﻿USE sofia;
DROP TABLE IF EXISTS sofia.bnp_vpl;
CREATE TABLE bnp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bnp_vpl WRITE;
INSERT INTO bnp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Muga na maki lobo ni rata, a Vure i rata rike a hunu a malala. ");
INSERT INTO bnp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","A malala i uka ma i manga ia ngane. I tabuli tavula kunana. A uvo i kavitagua a utu. A hanuna Vure kunana i rara polomeli vona. ");
INSERT INTO bnp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Muri a Vure i ta maea, “Ge palala.” Ngane i palala. ");
INSERT INTO bnp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","I masia a hini palala i kamumu. Muri i kalipida a hini palala, a uvo. ");
INSERT INTO bnp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A Vure i vunua a hini palala a parava, a uvo i vunua a rodo. I rodo i palala. Iea a mugana maka parava. ");
INSERT INTO bnp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Muri a Vure i ta maea, “Ge bele tara koropala ge kalipidea a naru ge tabuli na hini ge rua.” ");
INSERT INTO bnp_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Lakea, a Vure i ratea a koropala, i kalipidea a naru i tabuli polomeli ranga, i tabuli polotano ranga. Muri i bele manga a ngava i taki. ");
INSERT INTO bnp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","A koropala iea i vunua a hunu. I rodo i palala. Iea a ruana parava. ");
INSERT INTO bnp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Muri a Vure i ta maea, “A naru polotano na hunu ge tua lakea na hini ranga, ge bele a hini ge vu.” Muri i bele manga a ngava i taki. ");
INSERT INTO bnp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","A hini vu a Vure i vunua a malala. A hini vona a naru i vunua a dari. I matai a maki i rata i kamumu. ");
INSERT INTO bnp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Muri a Vure i ta maea, “A malala ge vakabele a maka varili, a kai, a uve ni varo, turana maka kai ri gi tahoka a kanena turana a vutuna ri gi vakabele tabu a hamone ria.” Muri i bele manga a ngava i taki. ");
INSERT INTO bnp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","A malala i tuvu vona a maka varili, a kai, a uve ni varo, turana a maka kai ri tahoka a kanena turana a vutuna ri gi vakabele tabu a hamone ria. A Vure i matai a maki i rata i kamumu. ");
INSERT INTO bnp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","I rodo, i palala. Iea a toluna parava. ");
INSERT INTO bnp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Muri a Vure i ta maea, “Ge tahoka a maka maki ri gi para polomeli na koropalana hunu, ri gi vakalipida a hini palala, a rodo. Ri gi vakasiri a parava, a pida, a tahuna na haro, a tahuna na vala. ");
INSERT INTO bnp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","A maka maki ri para na koropala bara ri vakapalala a malala.” Muri i bele manga a ngava i taki. ");
INSERT INTO bnp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","A Vure i rata a nipara dagi i rua. A viri dagi ne vona ni matakari a parava. A viri kiroko ne vona ni matakari a rodo. A hada ranga i rata rike. ");
INSERT INTO bnp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","I ru ria na koropala na hunu ne vona ni vakapalala a malala, ");
INSERT INTO bnp_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","bara ri matakari a parava, a rodo, bara ri kalipida a hini palala, a hini uvo. A Vure i matai a maki i rata i kamumu. ");
INSERT INTO bnp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","I rodo i palala. Iea a vana parava. ");
INSERT INTO bnp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Muri a Vure i ta maea, “A dari ge vonu vona a maka maki mahuri, ri gi laho lae na kabune ria. A maka kadirovo ri gi bebe polomeli na koropalana malala a hunu.” ");
INSERT INTO bnp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Lakea a Vure i rata rike a maka kabuna manu lobo, a maki dagi na utu, ri huru lae vona, ri vakavonu a dari, ri gi vakabele tabu a hamone ria. A maka kadirovo ranga, a Vure i rata rike ria ri gi vakabele tabu a hamone ria. A Vure i matai a maki i rata i kamumu, ");
INSERT INTO bnp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","i gamai ria i ta maea, “Mua a maki lobo na dari, mu bele kupo mu vakavonu a dari, mua a maka kadirovo mu bele kupo na robo.” ");
INSERT INTO bnp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","I rodo i palala. Iea a limana parava. ");
INSERT INTO bnp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Muri a Vure i ta maea, “A maka maki mahuri ri gi vakabele tabu a kabu ne ria: a sipsip a bulmakau, a maki kiroko ri karaka lae na robo, a livoa hateka.” Muri i bele manga a ngava i taki. ");
INSERT INTO bnp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","A Vure i rata rike a maka livoa, a sipsip a bulmakau, a maki i karaka lae na malala, ria lobo ri gi vakabele tabu a hamone ria. A Vure i matai a maki i rata i kamumu. ");
INSERT INTO bnp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Muri i ta maea, “Te ge rata rike a bakovi ge manga teu, ge matakari a manu na dari, a kadirovo, a sipsip a bulmakau, turana a maka maki ri karaka lae na malala.” ");
INSERT INTO bnp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Lakea a Vure i rata rikea a bakovi i manga ia. I muri mai ia, i rata rike varago a bakovi, a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","A Vure i gamai rua i taki rua, “Muru bele kupo, muru vakavonu a malala, muru matakaria. Muru matakari a maka manu na dari, a maka kadirovo, turana a maki mahuri lobo na robo.” ");
INSERT INTO bnp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Muri a Vure i ta maea, “Iau a habi marua a maka maki ni varo, turana a maka kai ri tahoka a kanena i vona a vutuna, bara a maki ni kani ne marua.” ");
INSERT INTO bnp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na maka kadirovo, a maka maki kiroko ri karaka na malala, a maki lobo i mahuri, a Vure i habi ne ria a maka pagana rau bara ri kani. Muri i bele manga a hini i taki. ");
INSERT INTO bnp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","A Vure i matai a maka maki i rata i kamumu hateka. I rodo i palala. Iea a polotarana parava. ");
INSERT INTO bnp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Na naro iea kunana, a Vure i rata rike a hunu a malala, turana a maki lobo. ");
INSERT INTO bnp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Na poloruana parava a Vure i malo, a vuhuna i vakalobo pali a leho vona. ");
INSERT INTO bnp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","A Vure i gamaia a poloruana parava, i ru hereherea, a vuhuna na parava iea i lobo a leho vona ni rata rike a maki lobo, i malo. ");
INSERT INTO bnp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","A ngava na hunu a malala ni rata rike i maea: Na tahuna e BAKOVI DAGI a Vure i rata rike a hunu a malala, ");
INSERT INTO bnp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","a varili i uka ma i gaga ma na malala. A maka kai na robo ranga, i uka ma ri mapoda ma, a vuhuna e BAKOVI DAGI a Vure i uka ma i vakaboru a vala. A malala, i uka viri ge leho vona. ");
INSERT INTO bnp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pali a maka naru ri tua rike kunana na malala, ri vakamea a hini polomeli na malala. ");
INSERT INTO bnp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Muri e BAKOVI DAGI a Vure i pipia na habulo a bakovi, i vaki dilia na ruperena a bangona nimahuri, i bele a bakovi mahuri. ");
INSERT INTO bnp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Muri, e BAKOVI DAGI a Vure i varoa a hania o Iden na nirikena haro. I rua vonga a bakovi i rata rikea. ");
INSERT INTO bnp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","E BAKOVI DAGI a Vure i rata rike a maka kai legelege ri mapoda na malala, a maka kai mata kamumu, i kamumu a kanena ni kanina. Na kurukuruna hania a kai i rua ru pesi: a kai i habi a nimahuri, turana a kai i habi a lohokanga na naro kamumu na naro hale. ");
INSERT INTO bnp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A naru dagi i tua tala vonga o Iden i bako va, ne vona ni vakamea a hania. ");
INSERT INTO bnp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","A bakona muga ni gale e Pison, i tua marogo lae na robo e Havila, a robo na gol. ");
INSERT INTO bnp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","A robo iea i vona a kai manginoro, a gol kamumu turana a maka kedo na mahala ranga. ");
INSERT INTO bnp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","A ruana bakona naru dagi ni gale e Gihon, i tua marogo lae na robo e Kus. ");
INSERT INTO bnp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","A rana toluna bakona naru dagi tara e Tigris. I tua na tabeke na nirikena haro na robo e Asiria. A vana bakona naru dagi ni gale e Iupretis. ");
INSERT INTO bnp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","E BAKOVI DAGI a Vure i bolea a bakovi i vakamadea na hania o Iden ge leho vona ge matakaria. ");
INSERT INTO bnp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","E BAKOVI DAGI a Vure i vakukua a bakovi, i ta maea, “A maka kanena kai lobo o kani, ");
INSERT INTO bnp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","pali a kai i habi a lohokanga na naro kamumu na naro hale, naha ni kania a kanena. Muholi hateka, na tahuna o kania bara o mate.” ");
INSERT INTO bnp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","E BAKOVI DAGI a Vure i ta maea, “I uka ma i kamumu a bakovi ge ia kikeri. Ga ratea tara turana ge tuhoria.” ");
INSERT INTO bnp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","E BAKOVI DAGI a Vure i rata rike pali na malala a maka livoa na robo turana a maka kadirovo. I bole lakea na bakovi ge matai ria ge vunu a rane ria takutaku. E rei a rana i vunu ria vona takutaku bara i tabuli liu a rana. ");
INSERT INTO bnp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","A bakovi i vunu a rana a maka sipsip a bulmakau, a kadirovo, a livoa na robo, pali i uka tara ge mata manga e Adam ga rihina. ");
INSERT INTO bnp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Lakea e BAKOVI DAGI a Vure i ratea e Adam i mahita mate. Na tahuna i mahita mate i paru talea a karona, muri i kavitagu mulea na bobona. ");
INSERT INTO bnp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Muri i pipia a ngatavine na karo i paru talea na bakovi, muri i tuli lakea vona a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","E Adam i masia, i ta maea, “Iea ngane a turagu a vuhuna ni bole tala na tuhagu, na bobogu, ga galea a ‘ngatavine’.” ");
INSERT INTO bnp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","I mavonga, a bakovi bara i pe e tamana e kinana i madoko turana e girihina, a kakaine rua ge taku. ");
INSERT INTO bnp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","A bakovi rua e girihina ru bobo, i uka ma ru maruhu. ");
INSERT INTO bnp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","A mata i moro hateka na rabu na taminga, i rangi a maka livoa lobo e BAKOVI DAGI a Vure i rata rike. I nanea a ngatavine, “I muholi a Vure i taki marua, nahea muru gu kani a maka kanena kai lobo na hania?” ");
INSERT INTO bnp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","A ngatavine i koli, i ta maea, “Maria bara miri kani lobo a maka kanena kai na hania, ");
INSERT INTO bnp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","pali a Vure i taki maria tabu nahea miri gi kani a kanena kai na kurukuruna hania, nahea miri gi padoi ia, ma ga miri gi mate.” ");
INSERT INTO bnp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Lakea a mata i takia a ngatavine, “I uka ma muru gu mate. I uka liu. ");
INSERT INTO bnp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","A Vure i lohoka, bara muru kania, a matane marua bara i palala, bara muru manga a Vure na nilohoka na naro kamumu na naro hale.” ");
INSERT INTO bnp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ngane a ngatavine i masia a kanena kai i kamumu na nikanina, i kamumu na matana, i ngaru ni tahoka a niluhoi dagi. I bolea, i kania. Muri i bole a kalavana i habia ne girihina, ia tara i kani. ");
INSERT INTO bnp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Muri a matane rua i palala, ru matakilala rua ru bobo, pali ru rahi a pagana kai a pik, ru kapikari rua vona. ");
INSERT INTO bnp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Muri a bakovi turana e girihina ru longoa e BAKOVI DAGI a Vure i lalaho na hania na malunga. Lakea ru vano ru pesi kapiloho vona na kai na hania. ");
INSERT INTO bnp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Lakea e BAKOVI DAGI a Vure i galea a bakovi, “Adam, ioe vai?” ");
INSERT INTO bnp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","E Adam i koli mule, i ta maea, “A longo ioe o laho na hania, a mangenge. A kapiloho a vuhuna a bobo.” ");
INSERT INTO bnp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Lakea a Vure i nanea, “E re i taki ioe o bobo? Ra ioe, o kania a kanena kai a ta pupukari ioe vona?” ");
INSERT INTO bnp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","A bakovi i koli, i ta maea, “Ra ngatavine o vakamade turagu, ia kunana i habia nau a kanena kai, a kania.” ");
INSERT INTO bnp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Muri e BAKOVI DAGI a Vure i nanea a ngatavine, “A ra o ratea ke?” Lakea a ngatavine i koli, “A mata i tami iau a kania a kanena kai.” ");
INSERT INTO bnp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Pali e BAKOVI DAGI a Vure i takia a mata, “Ngane a ruduraha ioe bara o bole a nimadihi polomeli liu na maka sipsip a bulmakau, a livoa, a vuhuna ioe o rata a naro hale. Ngane bara o laho na ngalamu, o todo a habulo na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Bara ioe a pile na ngatavine, e huriki a hamomu ranga bara ria a pile na hamona ngatavine. A hamona ngatavine bara i paha momo a gimu, pali ioe bara o kara tatea a vahana.” ");
INSERT INTO bnp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Muri a Vure i takia a ngatavine, i ta maea, “Ioe bara o bole a nimadihi dagi ni singou, ni poda a koma. Ra nimadihi, i uka ma go hatakia. Pali bara o ngarua e girihimu, e girihimu bara i matakari ioe.” ");
INSERT INTO bnp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Muri i takia e Adam, “Ioe, o longototo e girihimu o kania a kanena kai a ta pupukari vona, ‘Naha ni kania’. Ngane a rudurahea a malala a vuhuna o longotaro iau. Na parava vakaroro bara o leho, o kani. ");
INSERT INTO bnp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","A malala bara i vakabele a poto a barakau. Ioe bara o kani a maki o varo na hania. ");
INSERT INTO bnp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Bara i kani ioe a mavidia, o kani. Bara o rura i vano, i harena na tahuna o mate vona. Muri, bara o hamule lakea na habulo ra a vakabele ioe vona. Ioe a habulo, bara o hamule lakea tabu na habulo.” ");
INSERT INTO bnp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","E Adam i vunua a rane girihina e Eva, a vuhuna bara ia e kinane huriki lobo. ");
INSERT INTO bnp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","E BAKOVI DAGI a Vure i rahi a varakia na kulina kanirau, i vakarea rua. ");
INSERT INTO bnp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Muri e BAKOVI DAGI a Vure i ta maea, “A bakovi ngane i manga teu, i lohoka na vilo kamumu, na vilo hale. Nahea ge made tabukoi koea, ma ge padoi a kai na nimahuri, ge kania, ge mahuri vakaroro.” ");
INSERT INTO bnp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Lakea e BAKOVI DAGI a Vure i tono talea na hania o Iden a bakovi, ge hamule, ge leho na malala ni rata rike ia vona. ");
INSERT INTO bnp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A Vure i tono talea pali a bakovi, muri i vakapesi na nirikena haro na hania o Iden ranga agelo, turana a vito i hube i vito vito lae, ri gi tagaria a dala lakea na kai na nimahuri. ");
INSERT INTO bnp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","E Adam i mahita turana e girihina, e Eva, i singou, i podea e Kain. Lakea e Eva i ta maea, “I tuhori iau e BAKOVI DAGI, a vakabelea a bakovi.” ");
INSERT INTO bnp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Muri i podea e Abel, e tarine Kain. E Abel i matakari a sipsip, e Kain i leho na hania. ");
INSERT INTO bnp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Na parava tara e Kain i bole ranga maki ni kani na hania ge a nihabi ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Pali e Abel i bole a maka tuna sipsip a tabua i vi. Lakea e BAKOVI DAGI i ngarua a nihabi ne Abel, ");
INSERT INTO bnp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","pali a nihabi ne Kain, i uka ma i ngarua. Ngane e Kain i madihi a hatena, i robo a matana. ");
INSERT INTO bnp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Muri e BAKOVI DAGI i nanea e Kain, “I navai i madihi a hatemu, i robo a matamu? ");
INSERT INTO bnp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ioe bara o rata a rabu malamala bara ngarua a nihabi vomu. Ioe, i uka ma o rata a rabu malamala, a rabu hale i pesi kalidoga ge rabalaki ioe. O matakari a nilaho vomu, bara i lobo a naro hale vomu.” ");
INSERT INTO bnp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ngane e Kain i turea e tarina, i ta maea, “Abel, tu lakea na hania.” Lakea ru vano. Na tahuna ru bele na hania, lakea e Kain i ubi matea e tarina. ");
INSERT INTO bnp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Muri e BAKOVI DAGI i nanea e Kain, “Avia e tarimu e Abel?” E Kain i koli mule i ta maea, “I uka ma a masia. Ra iau, ge iau a vora ni matakari e tarigu?” ");
INSERT INTO bnp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Lakea e BAKOVI DAGI i ta maea, “A ra o ratea ke? O longo valai! A darane tarimu i tangi valai nau pali na malala, ga kolia a nimate vona. ");
INSERT INTO bnp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ngane bara ruduraha ioe, ga lili tala ioe na malala, ra i todo a darane tarimu na limamu. ");
INSERT INTO bnp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ngane na tahuna o leho na malala, i uka ma ge vakabele a maki ni kani vomu. I uka ma go made tata, bara o kanipede viliha.” ");
INSERT INTO bnp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","E Kain i kide i ta maea, “I kupo polo a maka maregoa nau. ");
INSERT INTO bnp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ngane o lili tala iau na malala bara kapiloho na matamu. Bara a uka tanga, a kanipede. Pali e re i matavisi iau bara i rabalaki iau.” ");
INSERT INTO bnp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","E BAKOVI DAGI i koli mule, i ta maea, “I uka ma ge mavonga. A viri bara i rabalaki ioe bara i bolea a nikoli dagi balaka polorua.” Muri i rua ne Kain tara kilakila ne vona ni matakilaka vona, i uka ma ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Muri e Kain i pea e BAKOVI DAGI, i vano i made na robo e Nod, na tabeke na nirikena haro o Iden. ");
INSERT INTO bnp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","E Kain i mahita turana e girihina, muri i singou e girihina, i podea e Enok. E Kain i ratea a tanga dagi i vunua e Enok, i muri mai a rane tuna. ");
INSERT INTO bnp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","E Enok i vakabelea e Irad, e Irad e tamane Mehusael, e Mehusael e tamane Metusael, e Metusael e tamane Lamek. ");
INSERT INTO bnp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","E Lamek i parangi a ngatavine ala rua. A rane rua e Ada e Sila. ");
INSERT INTO bnp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","E Ada i podea e Iabal. Iabal e tamane huriki ri matakari a sipsip a bulmakau, ri made na kape. ");
INSERT INTO bnp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","E turana a rana e Iubal, e tamane huriki ri lohoka ni sigi a gita, ni vaki a piloli. ");
INSERT INTO bnp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","E Sila tara i tahoka e tuna, a rana e Tubal-Kain, ia a mari ni rata a kira na aen a kapa. E kurabana a rana e Nama. ");
INSERT INTO bnp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","E Lamek i vakalongo e girihina rua, i ta maea, “Ada o Sila, muru longo valai muru longo a ngavagu. Iau a rabalakia a bakovi i rata tuhare iau, i tolo iau, a koma tamuhane. ");
INSERT INTO bnp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","A viri bara i rabalakia e Kain, a nikoli vona bara i bole dagi. Pali a viri bara i rabalaki iau, muholi hateka a nikoli vona bara i bole dagi hateka!” ");
INSERT INTO bnp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","E Adam i mahita turana tabu e girihina, lakea e girihina i podea a koma bakovi, i vunua e Set. Lakea e girihina i ta maea, “A Vure i habi tabua nau a koma ge bole a murine Abel, ra i rabalakia e Kain.” ");
INSERT INTO bnp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","E Set i tahoka e tuna bakovi, i vunua e Enos. Na tahuna iea, e huriki a bakovi ri vakatubu ni kavurikea a rane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iea a nitana kabu ne Adam ni here puru: Na tahuna a Vure i rata rike a bakovi, i ratea i manga ia. ");
INSERT INTO bnp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I rata rike a bakovi a ngatavine, muri i gamai rua. Na tahuna i rata rike rua, i vunu rua a “bakovi.” ");
INSERT INTO bnp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Na tahuna e Adam i tahoka a pida i 130 i vakabelea e tuna a bakovi i manga ia. I vunua e Set. ");
INSERT INTO bnp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Muri ne Set ni poda, ni poda tabu ranga e tuna a bakovi a ngatavine. Muri e Adam i tahoka tabu a pida i 800. ");
INSERT INTO bnp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A pida ne Adam, ni gi palupu lobo, i 930, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","E Set i tahoka a pida i 105 ngane, i vakabelea e Enos. ");
INSERT INTO bnp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Muri ne Enos ni poda, e Set i tahoka tabu a pida i 807, i vakabele tabu ranga e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","A pida ne Set, ni gi palupu lobo, i 912, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Na tahuna e Enos i tahoka a pida i 90, i vakabelea e Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Muri ne Kenan ni poda, e Enos i tahoka tabu a pida i 815, i vakabele tabu ranga e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","A pida ne Enos, ni gi palupu lobo i 905, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Na tahuna e Kenan i tahoka a pida i 70, i vakabelea e Mahalale. ");
INSERT INTO bnp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Muri ne Mahalale ni poda, e Kenan i tahoka tabu a pida i 840, i vakabele tabu ranga e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","A pida ne Kenan, ni gi palupu lobo, i 910, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Na tahuna e Mahalale i tahoka a pida i 65, i vakabelea e Iared. ");
INSERT INTO bnp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Muri ne Iared ni poda, e Mahalale i tahoka tabu a pida i 830, i vakabele tabu ranga e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","A pida ne Mahalale ni gi palupu lobo, i 895, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Na tahuna e Iared i tahoka a pida i 162, i vakabelea e Enok. ");
INSERT INTO bnp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Muri ne Enok ni poda, e Iared i tahoka tabu a pida i 800, i vakabele tabu ranga e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","A pida ne Iared, ni gi palupu lobo, i 962, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Na tahuna e Enok i tahoka a pida i 65, i vakabelea e Metusela. ");
INSERT INTO bnp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Muri ne Metusela ni poda, e Enok i laho turana Vure na pida i 300, i vakabele tabu ranga e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","A pida ne Enok, ni gi palupu lobo, i 365. ");
INSERT INTO bnp_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Muri a Vure i bolea e Enok, i uka ma ni matai tabu, a vuhuna a Vure i ngaru hatekea. ");
INSERT INTO bnp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Na tahuna e Metusela i tahoka a pida i 187, i vakabelea e Lamek. ");
INSERT INTO bnp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Muri ne Lamek ni poda, e Metusela i tahoka tabu a pida i 782, i vakabele tabu ranga e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","A pida ne Metusela, ni gi palupu lobo, i 969, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Na tahuna e Lamek i tahoka a pida i 182, i vakabelea e tuna a bakovi, ");
INSERT INTO bnp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","i vunua e Noa. Lakea e tamana i ta maea, “Hosi e BAKOVI DAGI i rudurahea a malala, mi leho hateka mi bole a nimadihi, pali a koma iea bara i vakasihomo mia.” ");
INSERT INTO bnp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Muri ne Noa ni poda, e Lamek i tahoka tabu a pida i 595 i vakabele tabu ranga e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","A pida ne Lamek, ni gi palupu lobo, i 777, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Na tahuna e Noa i tahoka a pida i 500, ni gale e tamane Sem, e Ham, e Iapet. ");
INSERT INTO bnp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Na tahuna e huriki a bakovi a ngatavine ri bele kupo na malala, ri vakabele e huriki e tune ria ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","E huriki a tuna Vure ri matai ria ri mata kamumu hateka, lakea e rei ne ria i ngaru ni parangi, bara ri parangi a ngatavine ri ngaru. ");
INSERT INTO bnp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Muri e BAKOVI DAGI i ta maea, “A hanugu i uka ma ge made pololilo na bakovi na parava vakaroro, a vuhuna ia a bakovi na malala kunana. A pida ne ria ge harena kunana ne 120.” ");
INSERT INTO bnp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Na tahuna iea, e huriki a kabu ne Nepilin ri made na malala. Lakea e huriki a tuna Vure bakovi ri parangi na ngatavine na malala, ri vakabele huriki a hamone ria. Re huriki nga, ria a bakovi hateka, a rane ria i dagi na tahuna iea. ");
INSERT INTO bnp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","E BAKOVI DAGI i matai a narone huriki na malala i hale liu, a maki ri luhoi kunanea a naro hale. ");
INSERT INTO bnp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","I kilu vona a hini i rata rike e huriki koea na malala. ");
INSERT INTO bnp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","I tapuhaki i ta maea, “Iau ga vakalobo koea na malala e huriki a bakovi a rata rike. Pali ga vakalobo tabu a maka livoa, a kadirovo, turana a maka maki lobo ri laho na robo, a vuhuna iau a kilu vona a hini a rata rike a maka maki nga.” ");
INSERT INTO bnp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pali e BAKOVI DAGI i vivi vona e Noa. ");
INSERT INTO bnp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Iea a nita na narone Noa: E Noa ia a bakovi kamumu, a narona i kiripiripi na matane huriki a bakovi na tahuna iea. I laho turana Vure. ");
INSERT INTO bnp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","E Noa i tahoka e tuna i ala tolu: e Sem, e Ham e Iapet. ");
INSERT INTO bnp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Na matana Vure, a malala i vonu na maka naro hale. E huriki ri tagege, ri vaubi lae. ");
INSERT INTO bnp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","A Vure i masia a malala i vonu na maka naro hale, a vuhuna a maka narone ria i hale hateka. ");
INSERT INTO bnp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Lakea, a Vure i takia e Noa, “Iau ga ratapile e huriki lobo, a vuhuna a malala i vonu vona a maka naro hale ne ria. Muholi hateka, iau ga ratapile lobo e huriki a bakovi, turana a malala. ");
INSERT INTO bnp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Pali ioe, o haea a agarungu vomu, o haea na kai a saipres. O nagi pololiloa, muri o kavitagu a hini pololilo, a hini polovavo na kasita. ");
INSERT INTO bnp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ra agarungu iea o hae maea: a niolana ge 150 mita, a nibolana ge 25 mita, a nipesina ge 15 mita. ");
INSERT INTO bnp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Na tahuna o hae a mapana roho na agarungu, nahea a mapana ge padoi liu a gagana. Ge tabuli a hini ge 5 mita. A tabekena agarungu ge tolu: ge polotano tara, na kurukuruna tara, ge polomeli tara. Na gagana tara o rua a hinebi. ");
INSERT INTO bnp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Iau ga rudua a marungulolo ge ratapile a maka maki polotano na hunu, a maka maki mahuri ri bango na ruperene ria, a maki lobo na malala bara ri mate. ");
INSERT INTO bnp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pali iau ga rata a ngava dagi turamu, muri bara o rike na agarungu vomu turana e girihimu, e tumu, e kamu. ");
INSERT INTO bnp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","O vakaha dili na agarungu a maki lobo ri laho na robo, ge ruarua, a toga, a kinana. ");
INSERT INTO bnp_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","O vakaha turane mua, ge ruarua a maka kadirovo, a livoa, a maki lobo mahuri legelege. ");
INSERT INTO bnp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","O bole tabu a maki ni kani, o ru kamumu, ne vona e mua turana a maka maki mahuri o vakarike.” ");
INSERT INTO bnp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Lakea e Noa i rata lobo a maki a Vure i taki vona ge rata. ");
INSERT INTO bnp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","E BAKOVI DAGI i takia e Noa, “O dili na agarungu turane huriki a kabu vomu, a vuhuna ioe kikeri a bakovi kamumu ne huriki a bakovi lobo. ");
INSERT INTO bnp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","O bole turamu na kabu na kanirau kabakaba, a toga ge polorua, a kinana ge polorua. Na kanirau mutomuto, a toga ge polorua, a kinana ge polorua. ");
INSERT INTO bnp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Na kadirovo, a toga ge polorua, a kinana ge polorua, ne vona ni vakabele a hamone ria na malala. ");
INSERT INTO bnp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Muri na parava ge polorua, ga vakaborua na malala a vala. Ge boru na parava ge ravulu va, a rodo ge ravulu va. Iau ga vakalobo a maka maki mahuri a rata rike koea na malala.” ");
INSERT INTO bnp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Lakea e Noa i muri mai a ngava lobo e BAKOVI DAGI i vakuku ia vona. ");
INSERT INTO bnp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Na tahuna a marungulolo i bele koea na malala, e Noa i tahoka a pida i 600. ");
INSERT INTO bnp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Muri e Noa turana e girihina, e tuna mai e kana mai, ri rike na agarungu, ri gi kapiloho vona a marungulolo. ");
INSERT INTO bnp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","A maka kanirau ri varihi, a kanirau kabakaba, a kanirau mutomuto, a kadirovo turana a maki lobo ri karaka na robo, ");
INSERT INTO bnp_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","a kinana, a toga ri valai mai e Noa, ri rike na agarungu, i manga a hini a Vure i vakukua e Noa vona. ");
INSERT INTO bnp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Pali i lobo a parava i polorua, i bele ngane na malala a marungulolo. ");
INSERT INTO bnp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Na parava i ravulu a polona i polorua na ruana keva, e Noa i tahoka pali a pida i 600, i vakatubu na parava iea, a maka naru polotano na bobona malala ri tuka, a maka niroga na naru na hunu ri mapuka. ");
INSERT INTO bnp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","A vala dagi i boru ngane na malala na parava i ravulu va, a rodo i ravulu va. ");
INSERT INTO bnp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Na parava iea kunana e Noa turane girihina, e tuna ala tolu: e Sem, e Ham, e Iapet turane girihine tou, ri rike na agarungu. ");
INSERT INTO bnp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ri rike turana a kabu na kanirau lobo, a kabu na sipsip a bulmakau lobo, a kabu na maki lobo ri laho na malala, a kabu na kadirovo, a maki lobo i tahoka a karapane ria. ");
INSERT INTO bnp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","A maka maki legelege ri mahuri, ri bango na ruperene ria, ri valai turana a rihine ria, ri valai mai e Noa, ri rike na agarungu. ");
INSERT INTO bnp_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","A maka livoa, a toga a kinana, ri rike na agarungu, i muri maia a nitana Vure i vakuku e Noa vona. Muri e BAKOVI DAGI i tukari tahoa e Noa. ");
INSERT INTO bnp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Na parava i ravulu va, a vala i boru mavonga, i vonu a naru i kavitagua a malala, lakea a agarungu i pasi langa na naru polomeli liu na malala. ");
INSERT INTO bnp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","A naru i lolo rike hateka, i kavitagua a malala, lakea a agarungu i pasi na bokona dari. ");
INSERT INTO bnp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","A naru i bubu rike mavonga, i kavitagu a maka lolo dagi lobo. ");
INSERT INTO bnp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Muri a naru i kavitagu a maka mapana lolo i polomeli na mita i polorua. ");
INSERT INTO bnp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","A maki lobo ri laho na malala ri pasiri: e huriki a bakovi lobo turana a sipsip a bulmakau, a livoa, a maka maki ri laho na robo. ");
INSERT INTO bnp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","A maki lobo na malala ri bango na ruperene ria, ri mate. ");
INSERT INTO bnp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","A maki lobo ri mahuri koea na malala, ri lobo liu. E huriki a bakovi a ngatavine, a maka kanirau, a kadirovo turana a maki lobo ri laho na robo, ri lobo liu na malala. A kabu ne Noa turana a maka maki mahuri pololilo na agarungu kunana ri mahuri. ");
INSERT INTO bnp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","A naru i kavitagua a malala na parava i 150. ");
INSERT INTO bnp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Pali a Vure, i uka ma i longo­kabu­rungi e Noa turana a maka kanirau, a sipsip a bulmakau ra ri kapiloho na agarungu. I rudua a vilu i ngalu langa vona a dari, lakea a dari i hoho puru. ");
INSERT INTO bnp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ngane a Vure i tukari a maka matana naru na bobona malala a hunu, lakea a vala i lobo na niboru valai meli na hunu. ");
INSERT INTO bnp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Pali a naru i vakatubu ni hoho puru na malala. Muri na parava i 150 a naru i hoho puru lobo. ");
INSERT INTO bnp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Na parava i ravulu a polona i polorua, na poloruana keva, a agarungu i koro na mapana lolo e Ararat. ");
INSERT INTO bnp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","A dari i hoho puru, lakea na mugana parava na ravuluna keva i lele a maka mapana lolo. ");
INSERT INTO bnp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","I lobo a parava i ravulu va, lakea e Noa i talea a matatalana agarungu, ");
INSERT INTO bnp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","i vakabebe talea a kokoa, i bebe lae polovavo, i davea a dari ge hoho puru. ");
INSERT INTO bnp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Muri i vakabebe talea a balu ge kasisia a dari i hoho puru pali, o i tabana. ");
INSERT INTO bnp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","A balu i uka ma i puruvisi a hini ge toka vona, a vuhuna a naru i tabana ni kavitagua a malala, lakea i bebe mule ne Noa na agarungu. E Noa i toto tala a limana i bole dilia a balu. ");
INSERT INTO bnp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","I dava na parava i polorua tabu na agarungu, muri i vakabebe tabua a balu. ");
INSERT INTO bnp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Na tahuna a balu i hamule na malunga, i gogoa a pagana kai a oliv i karaputu karabea. Ngane e Noa i lohoka a dari i hoho puru pali. ");
INSERT INTO bnp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","I dava tabu na parava i polorua, muri i vakabebe tabua a balu, pali na tahuna iea a balu i uka ma i hamule. ");
INSERT INTO bnp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Na tahuna e Noa i tahoka a pida i 601, na mugana parava na mugana keva, a naru i hoho puru liu na malala. I kalipidea a hini polomeli na agarungu, i masia a malala i kere. ");
INSERT INTO bnp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Na parava i ravulu rua a polona i polorua (27) na ruana keva, a malala i kere liu. ");
INSERT INTO bnp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Muri a Vure i takia e Noa, ");
INSERT INTO bnp_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ioe, turana e girihimu, e tumu mai turana e girihine tou, mu pagitala na agarungu. ");
INSERT INTO bnp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","O vakalaho tala a maka maki mahuri takutaku, ra ri turamu. A maka kadirovo, a maka kanirau, a maka maki lobo ri karaka na robo, ri gi poda kupo na malala, ri gi vole, ri gi vakavonu a malala, a kabune ria.” ");
INSERT INTO bnp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Muri e Noa i pagitala, turana e girihina, e tuna mai, turana e girihine tou. ");
INSERT INTO bnp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","A maka kanirau, a maki lobo ri laho na robo, a kadirovo lobo, a maki legelege lobo ri mahuri na malala ri laho na tete, ri pagitala na agarungu. ");
INSERT INTO bnp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Muri e Noa i kisia a dede-kedo ne BAKOVI DAGI, i bole ranga kanirau kabakaba, a kadirovo kabakaba, i rabalaki i gutu-vuro ria i habi ne Bakovi Dagi. ");
INSERT INTO bnp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Na tahuna e BAKOVI DAGI i burongi a mangina maki nga i huli lakea vona, lakea i taki mulea, “Iau i uka ma ga ruduraha tabua a malala ne vona ni koli a naro hale ne huriki. I muholi a naro hale ne ria i vakatubu na tahuna ri kiroko vona. Pali ngane, i uka ma ga ratapile tabu a maka maki mahuri, ge manga a hini a rata pali. ");
INSERT INTO bnp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“A malala bara i tahoka a parava, a rodo, a tahuna ni varo a hania, a tahuna ni mirio a hania, a tahuna na malangia, a tahuna ni kakarongo, a tahuna na haro, a tahuna na vala. A maka tahuna nga i uka ma ge lobo, bara ri tabuli vakaroro na malala.” ");
INSERT INTO bnp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Muri a Vure i gamai e Noa turana e tuna mai i taki ria, “Mu bele kupo, mu vakavonu a malala. ");
INSERT INTO bnp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","A kanirau lobo na malala, a kadirovo lobo, a maki lobo ri karaka na malala, a manu lobo, bara ri mangenge ne mua. Ngane a ru na limane mua. ");
INSERT INTO bnp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","A maka maki mahuri ri laho ga maki ni kani ne mua, i manga a hini muga a habi ne mua a kobo mu kani. Pali ngane a habi a maki lobo ga maki ni kani ne mua. ");
INSERT INTO bnp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pali a bobona maki i vona a dara, naha ni kani, a vuhuna a dara i habi a nimahuri. ");
INSERT INTO bnp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Pali e rei a bakovi, a kanirau, a livoa hateka i rabalakia tara viri, i muholi hateka bara kolia. E rei i rabalaki a viri tara, iau bara kolia vona a naro i ratea. ");
INSERT INTO bnp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","E rei a bakovi i rabalakia a viri tara, ia kunana bara i mate na limana bakovi, a vuhuna iau a Vure a rata rikea a bakovi i manga iau. ");
INSERT INTO bnp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Pali mua, mu bele kupo mu vakavonua a malala.” ");
INSERT INTO bnp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Muri a Vure i takia e Noa turana e tuna mai, ");
INSERT INTO bnp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ngane ga vakatubua a ngava dagi turamu, turana e huriki a hamomu ri gi bele muri ma, ");
INSERT INTO bnp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","turana a maki mahuri ra ri turane mua: a maka kadirovo, a sipsip a bulmakau, a kanirau, turana a maki lobo ri pagitala turane mua na agarungu, ra maka maki mahuri lobo na malala. ");
INSERT INTO bnp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Iau a rua a ngava dagi nau turane mua. A ta muholi, a marungulolo i uka ma ge ratapile tabu a maka maki mahuri. Muholi hateka a marungulolo i uka ma ge ratapile tabu a malala.” ");
INSERT INTO bnp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Muri, a Vure i ta maea, “Iau a rua a kuriki na bubu, ge a nivakasiri na ngava dagi nau na maka maki mahuri na malala. Ra kuriki iea a nivakasiri na ngava dagi a rata turane mua, turana a maka maki mahuri ri turane mua na agarungu. Ra ngava iea i lakea tabu ne huriki a hamomu bara ri bele muri ma. ");
INSERT INTO bnp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Na tahuna iau a ru a bubu polomeli na hunu, a kuriki bara i pesi vona. ");
INSERT INTO bnp_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Iau bara luhoi mule a ngava dagi a ratea turana a maka maki mahuri na malala. Nahea tabu a marungulolo ge ratapile lobo a maka maki mahuri. ");
INSERT INTO bnp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Na tahuna a kuriki i pesi na bubu, bara masia, a luhoi mule a ngava dagi i tabuli vakaroro turagu, turana a kabu na maki mahuri na malala.” ");
INSERT INTO bnp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Muri a Vure i takia e Noa, “A kuriki a nivakasiri na ngava dagi, a habia na maka maki mahuri na malala.” ");
INSERT INTO bnp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","E tune Noa to pagitala na agarungu ra nga: e Sem, e Ham, e Iapet. (E Ham e tamana e Kenan). ");
INSERT INTO bnp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","re tune Noa nga, tou a vuhuna e huriki lobo. To vakabele e huriki, muri ri mariu viliha lae na malala. ");
INSERT INTO bnp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","E Noa a bakovi ni leho na hania, i vakatubu ni varo a vain na hania vona. ");
INSERT INTO bnp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Na parava tara, i ninu ranga vain vona, i manga, i mahita bobo pololilo na kape vona. ");
INSERT INTO bnp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","E Ham e tamane Kenan, i masia e tamana i mahita bobo, lakea i pagitala, i vakalongo e turana rua polovavo. ");
INSERT INTO bnp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Lakea e Sem rua e Iapet ru nugu gaviri na bitone rua a varakia, ru laho bitona ru kavitagua e tamane rua, ra i mahita bobo. Ru matahere, a vuhuna ru koi ni masia e tamane rua i bobo. ");
INSERT INTO bnp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Na tahuna e Noa i hadongo, i palala a gina, ni vakalongo vona a naro i ratea vona e tuna, ra kabina ruru. ");
INSERT INTO bnp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Lakea e Noa i tahatea i ta maea, “E Kenan ni gi ruduraha! Bara ia a vorakato ne turana rua.” ");
INSERT INTO bnp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Muri i ta maea tabu, “Ni gi kavurike e BAKOVI DAGI, a Vure ne Sem, pali e Kenan bara ia a vorakato ne Sem kunana. ");
INSERT INTO bnp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","A Vure ge hudo talea a hamone Iapet, e huriki a hamona ri gi made turana a hamone Sem, pali e Kenan ge ia a vorakato ne Iapet.” ");
INSERT INTO bnp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Muri na marungulolo, e Noa i made tabu na pida i 350. ");
INSERT INTO bnp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","A pida vona ni gi palupu lobo i 950, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Iea a nitane tune Noa ala tolu: e Sem, e Ham, e Iapet. Ra bakovi nga to vakabele muri na marungulolo e huriki e tune tou bakovi. ");
INSERT INTO bnp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","A rane huriki e tune Iapet, a bakovi, ra nga: e Gomer, e Magog, e Madai, e Iavan, e Tubal, e Mesek, e Tiras. ");
INSERT INTO bnp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","A rane huriki e tune Gomer, a bakovi, ra nga: e Askenas, e Ripat, e Togama. ");
INSERT INTO bnp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","A rane huriki e tune Iavan, a bakovi, ra nga: e Elisa, e Tarsis, e Kitim, e Dodanim. ");
INSERT INTO bnp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","E huriki ri made tabukoi na dari ria a hamone Iavan. Ri mariu tala turana a kabu ne ria, a nita taku, ri lakea na robo takutaku ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","A rane huriki e tune Ham, a bakovi, ra nga: e Kus, e Misram, e Put, e Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","A rane huriki e tune Kus, a bakovi, ra nga: e Seba, e Havila, e Sabta, e Rama, e Sabteka. E tune Rama a bakovi ra nga: e Seba e Dedan. ");
INSERT INTO bnp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","E Kus i tahoka e tuna tara a rana e Nimrod. E Nimrod ia a ubu na malala. ");
INSERT INTO bnp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Na tahuna e huriki ri ngaru ni kavurike a bakovi tara bara ri ta maea, “A bakovi iea i manga e Nimrod, re BAKOVI DAGI i ratea ia a bakovi hateka na pinango.” ");
INSERT INTO bnp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","E Nimrod i matakari a maka tanga dagi na robo nga: e Babel, e Erek, e Akad, e Kalne na robo e Babel. ");
INSERT INTO bnp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","I pea a robo iea, i mariu lakea o Asiria i ratea vonga a tanga e Ninive, e Rehobot-Ir, e Kala, e Resen. ");
INSERT INTO bnp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","A tanga dagi e Resen i pesi na kurukuruna e Ninive e Kala. ");
INSERT INTO bnp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","A rane huriki e tuna e Misram ra nga: e Lud, e Anamim, e Lehab, e Naptu, ");
INSERT INTO bnp_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","e Patrus, e Kaslu (a vuhuna e huriki a Palestina), e Kaptor. ");
INSERT INTO bnp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","A rane huriki e tune Kenan a bakovi ra nga: e Sidon a tabua. E tarina e Het, ");
INSERT INTO bnp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","e Iebus, e Amor, e Girgas, ");
INSERT INTO bnp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","e Hivi, e Arki, e Sin, ");
INSERT INTO bnp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","e Arva, e Semar, e Hamat. Muri e huriki a kabu ne Kenan ri mariu viliha. ");
INSERT INTO bnp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","A vanagi na robo e Kenan i tubu o Sidon, i polo lakea o Gerar, i lokovonga liu o Gasa, muri i kaogo vonga i lakea mai e Sodoma, e Gomora, e Adma, e Seboim, lakea i harena o Lasa. ");
INSERT INTO bnp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Re huriki a kabu nga, a hamone Ham, ri tahoka a nita ne ria takutaku, ri made ramai a kabu ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","E tarina e Iapet a rana e Sem. E Sem tara i tahoka e huriki e tuna. E huriki a kabu ne Eber ria lobo ri mapoda tala ne Sem. ");
INSERT INTO bnp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","A rane huriki e tune Sem bakovi, ra nga: e Elam, e Asur, e Arpaksad, e Lud, e Aram. ");
INSERT INTO bnp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","A rane huriki e tune Aram bakovi, ra nga: e Us, e Hul, e Geter, e Mas. ");
INSERT INTO bnp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","E Arpaksad e tamane Sela, e Sela e tamane Eber. ");
INSERT INTO bnp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","E Eber i tahoka e tuna bakovi ala rua: e Ioktan, e Peleg. E Peleg ni gale maea, a vuhuna na tahuna iea e huriki ri vapida viliha lae. ");
INSERT INTO bnp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","E Ioktan i tahoka e tuna ranga, a rane ria ra nga: e Almodad, e Selep, e Hasarmavet, e Ierah, ");
INSERT INTO bnp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","e Hadoram, e Usal, e Dikla, ");
INSERT INTO bnp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","e Obal, e Abimael, e Seba, ");
INSERT INTO bnp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","e Opir, e Havila, e Iobab. E huriki a bakovi nga, ria e tune Ioktan. ");
INSERT INTO bnp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","A robo ri made vona i tubu o Mesa, i lokovonga o Separ na tabeke i vona a lolo na robo na nirikena haro. ");
INSERT INTO bnp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Re huriki a kabu nga a hamone Sem, ri tahoka a nita ne ria takutaku, ri made ramai a kabu ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Re huriki a bakovi nga ria a hamone huriki e tune Noa, ri made ramai a kabu ne ria takutaku. E huriki a kabu na malala ri mapoda tala ne ria muri na marungulolo. ");
INSERT INTO bnp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ngane e huriki na malala ri tahoka a nita i taku ri vata vona. ");
INSERT INTO bnp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ri mariu lakea na nirikena haro ri matavisia a bilane Sinar, ri made vona. ");
INSERT INTO bnp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Muri ri vata, ri ta maea, “Mu valai, si gi pipi, si gi rata kamumu a brik, si gi gutu kamumu, ri gi tora.” I uka ma ri bole a kedo, ri bole a brik. Muri ri hudo na kasita a brik. ");
INSERT INTO bnp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Muri ri ta maea, “Mu valai, si gi haea a vuhutanga ne hita. Ge pesi vona tara roho dagi, a mapana ge padoi a hunu, bara si tahoka a rane hita vona. Si gi made tata, i uka ma si gi mariu viliha lae na malala.” ");
INSERT INTO bnp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pali e BAKOVI DAGI i puru valai, ge kasisia a tanga dagi turana a mapana roho dagi e huriki a bakovi ri haea. ");
INSERT INTO bnp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Lakea e BAKOVI DAGI i ta maea, “Re huriki nga ri pesi taku, ri tahoka a nita i taku ri vakatubu ni haea a mapana roho, pali a ra maki ri luhoi ni rata, bara ri rata kunana. ");
INSERT INTO bnp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Te ge puru te ge vakavaroru a nitane ria, i uka ma ri gi valongokilala a ngava.” ");
INSERT INTO bnp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Lakea, e BAKOVI DAGI i kalipida ria vonga, ri mariu viliha lae na malala, i uka ma ri hae tabua a vuhutanga iea. ");
INSERT INTO bnp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ni gale a vuhutanga iea e Babel, a vuhuna e BAKOVI DAGI i vakavilihea a nitane huriki na malala. I vakatubu vonga, e BAKOVI DAGI i vakalipida ria, i vakamariu viliha lae ria, ri lakea na robo lobo na malala. ");
INSERT INTO bnp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","A nita na kabu ne Sem i maea: i lobo a pida i rua muri na marungulolo, e Sem i tahoka a pida i 100, lakea i vakabelea e Arpaksad. ");
INSERT INTO bnp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Muri i tahoka tabu a pida i 500, i vakabele e huriki e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","E Arpaksad i tahoka a pida i 35, i vakabelea e Sela. ");
INSERT INTO bnp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Muri i tahoka tabu a pida i 403, i vakabele e huriki e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","E Sela i tahoka a pida i 30, i vakabelea e Eber. ");
INSERT INTO bnp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Muri i tahoka tabu a pida i 403, i vakabele e huriki e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","E Eber i tahoka a pida i 34, i vakabelea e Peleg, ");
INSERT INTO bnp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","muri i tahoka tabu a pida i 430, i vakabele e huriki e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","E Peleg i tahoka a pida i 30, i vakabelea e Reu, ");
INSERT INTO bnp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","muri i tahoka tabu a pida i 209, i vakabele e huriki e tuna bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","E Reu i tahoka a pida i 32, i vakabelea e Serug, ");
INSERT INTO bnp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","muri i tahoka tabu a pida i 207, i vakabele e huriki e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","E Serug i tahoka a pida i 30, i vakabelea e Nahor, ");
INSERT INTO bnp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","muri i tahoka tabu a pida i 200, i vakabele e huriki e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","E Nahor i tahoka a pida i 29, i vakabelea e Tera, ");
INSERT INTO bnp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","muri i tahoka tabu a pida i 119, i vakabele e huriki e tuna a bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","E Tera i tahoka a pida i 70, i vakabele e Abram, e Nahor, e Haran. ");
INSERT INTO bnp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","A nita na kabu ne Tera i maea: e Tera ia e tamane Abram, e Nahor, e Haran. E Haran ia e tamane Lot. ");
INSERT INTO bnp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Na tahuna e Tera i tabana ni mahuri, e tuna, e Haran, i mate na tanga ni poda ia vona o Ur, na robo e Kaldia. ");
INSERT INTO bnp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","E Abram rua e Nahor ru tahoka e girihine rua. E Sarai, e girihine Abram. E Milka e girihine Nahor. E Milka rua e Iska, e tamane rua e Haran. ");
INSERT INTO bnp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","E Sarai i lame, i uka e tuna. ");
INSERT INTO bnp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","E Tera i tuli e tuna e Abram, e tubuna e Lot (e tune Haran), e lahuana e Sarai (e girihine Abram), ri pea a tanga e Ur na robo ne Kaldia, ri mariu lakea o Kenan. Pali na tahuna ri bele o Haran, ri made vonga. ");
INSERT INTO bnp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","E Tera i tahoka a pida i 205, muri i mate vonga o Haran. ");
INSERT INTO bnp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","E BAKOVI DAGI i takia e Abram, “O pe a tanga vomu, e huriki a viri vomu, a kabu ne tamamu, o lakea vona a robo ga vakasiri ioe vona. ");
INSERT INTO bnp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ga gamai ioe, ga rata e huriki a kabu vomu ri gi ala kupo. Ga ratea a ramu ge dagi, go gamai e huriki. ");
INSERT INTO bnp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","E huriki ri gamai ioe, iau tara ga gamai ria. Pali e rei a viri i ruduraha ioe, bara ruduraha ia. Ne vomu kunana, ga gamai lobo e huriki a bakovi na malala.” ");
INSERT INTO bnp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Lakea e Abram i muri mai a nita i takia vona e BAKOVI DAGI, i vano. E Lot tara i vano turana. E Abram i tahoka a pida i 75 na tahuna i pea e Haran. ");
INSERT INTO bnp_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","I vano turana e girihina e Sarai, e Lot e tune tarina, e huriki a vora na leho, turana a maka mahala vona i vakabele o Haran. Ri havai maia a robo e Kenan, ri lokovonga, ri bele vonga. ");
INSERT INTO bnp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Na tahuna ri bele o Kenan, ri lakea na hini i pesi vona a kai dagi ni gale e More, na tanga e Sekem. Na tahuna iea e huriki a Kenan ri made vona a robo iea. ");
INSERT INTO bnp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Pali e BAKOVI DAGI i bele ne Abram i ta maea, “Ga habia ne huriki a hamomu a malala iea.” Lakea i kisia vonga a dede-kedo na hini i bele vona e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Pali muri i pea a hini ngi, i havai maia a lolo i pesi na tabeke na nirikena haro na tanga e Betel. I vakapesia vonga a kape vona na kurukuruna tanga e Betel na nirolona haro, e Ai na nirikena haro. I ratea vonga a dede-kedo ne BAKOVI DAGI, i vasileki vona a rane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Muri e Abram i malaga, i laho lokovonga na robo e Negev. ");
INSERT INTO bnp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ngane i bele vona a pago a tanga i made vona e Abram. Lakea, i puru o Egipto, ge tanga taro vonga, a vuhuna i hateka a pago. ");
INSERT INTO bnp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Na tahuna ta ge dili o Egipto, i varea e girihina, e Sarai, i ta maea, “Ioe a ngatavine mata kamumu. ");
INSERT INTO bnp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Bara ri matai ioe e huriki a bakovi o Egipto, bara ri ta maea, ‘Ra ngatavine iea e girihina.’ Muri bara ri rabalaki iau, pali bara o mahuri ke. ");
INSERT INTO bnp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","O taki ria, ge ioe e kurabagu, pali iau bara ni rata kamumu, i uka ma ri gi rabalaki iau.” ");
INSERT INTO bnp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","E Abram i bele o Egipto, lakea e huriki a bakovi vonga ri masia e girihina i mata kamumu hateka. ");
INSERT INTO bnp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Lakea e huriki a bolekori ne Parao ri masia, ri vakalongoa e Parao. Muri ri tulia e Sara i lakea na ruma dagi vona. ");
INSERT INTO bnp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Lakea e Parao i rata kamumua e Abram, a vuhuna i pahaluhoia e Sara, ta e kurabana. Muri e Parao i habi ne Abram a maka sipsip, a bulmakau, a donki, a kamel a toga a kinana, turana e huriki a vora bakovi a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pali e BAKOVI DAGI i vakamadihi na maka gilanga dagi e Parao, turana e huriki ri leho vona, a vuhuna e Sarai i made na ruma ne Parao. ");
INSERT INTO bnp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Lakea e Parao i galea e Abram, i nanea, “Ioe o rata navai iau? I navai i uka ma o ta kavakava vona a ngatavine iea ge girihimu? ");
INSERT INTO bnp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","I navai a hini o tami iau o takia e Sarai ta e kurabamu, lakea iau a bolea ta ga parangi vona? Pali ra ngatavine iea, ia e girihimu! O bolea o vano turana!” ");
INSERT INTO bnp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Muri e Parao i rudu e huriki a tagari vona, ri tono tala o Egipto e Abram rua e girihina, turana a maki lobo ne rua. ");
INSERT INTO bnp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Lakea e Abram rua e girihina ru pea e Egipto ru hamule sike o Negev, turana a maki lobo ne rua. E Lot tara i turane rua. ");
INSERT INTO bnp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","E Abram i tahoka a mahala i kupo: a maka sipsip a bulmakau, a silva, a gol. ");
INSERT INTO bnp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","I pea e Negev i laho tope dili tope tala na maka tanga. Muri i vano i bele o Betel, na hini i vakapesi muga a kape vona na kurukuruna e Betel, e Ai, ");
INSERT INTO bnp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ra hini i kisi a dede-kedo muga vona. I vasileki tabu vonga ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ngane e Lot, ra i laho turana e Abram, ia tara i tahoka a mahala i kupo. I tahoka a kabuna sipsip, a kabuna bulmakau. E huriki a vora vona ranga, ri ala kupo. ");
INSERT INTO bnp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Lakea i uka ma i kupo a malala ge vona a varili ne vone rua ru gu made palupu vona, a vuhuna i kupo a kabuna sipsip a bulmakau ne rua. ");
INSERT INTO bnp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Lakea e huriki a vora ne Abram ri vagege turana e huriki a vora ne Lot. Na tahuna iea e huriki a Kenan a Peres ria ranga ri made vona a malala iea. ");
INSERT INTO bnp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Pali e Abram i takia e Lot, “Nahea tu gu vata puhaki. E huriki a vora ne tarua ranga, nahea ri gi vata puhaki, a vuhuna tarua a viri ala taku. ");
INSERT INTO bnp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Masia, a malala dagi i tabana, pali ngane tu gu vapida. Ioe bara o ngaru ni lakea na nirikena haro, iau bara lakea na nirolona haro. Pali ioe bara o lakea na nirolona haro, iau bara lakea na nirikena haro.” ");
INSERT INTO bnp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lakea e Lot i mata rike i masia a bila ne Iordan, i vano i harena o Soar i vona a maka naru. I mata manga a hania ne BAKOVI DAGI, i manga a malala ne huriki a Egipto, tabukoi o Soar. Ra hini nga i muga ne BAKOVI DAGI i ratapile e Sodoma e Gomora. ");
INSERT INTO bnp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lakea e Lot i bolea a bila ne Iordan na tabeke na nirikena haro. ");
INSERT INTO bnp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ru vapida, lakea e Abram i vano i made na malala ne huriki a Kenan. Pali e Lot i made na kurukuruna maka tanga dagi na bilane Iordan. I ratea a tanga vona tabukoi ne Sodoma. ");
INSERT INTO bnp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Re huriki a bakovi o Sodoma ria a viri hale, ri rata vakaroro a naro hale hateka na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","E Lot i vano pali, lakea e BAKOVI DAGI i takia e Abram, i ta maea, “O pesi vonga o mata sike, o mata puru, o mata lakea na nirikena haro, o mata lakea na nirolona haro. ");
INSERT INTO bnp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ra maka robo o matai, ga habi vomu turane huriki a hamomu, ge ne mua vakaroro. ");
INSERT INTO bnp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Iau ga rata e huriki a hamomu ri gi ala kupo manga a habulo na malala, pali e rei i kara ni gi a habulo, ia kunana bara i gi e huriki a hamomu. ");
INSERT INTO bnp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","O vano, o laho vona a niolana, a nibolana a malala, a vuhuna iau ga habia vomu.” ");
INSERT INTO bnp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Lakea e Abram i pukea a kape vona, i mariu lakea o Hebron. I ratea a tanga vona tabukoi na kai dagi ne Mamare, na hini i kisi muga a dede-kedo ne BAKOVI DAGI vona. ");
INSERT INTO bnp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Na tahuna iea, e Amrapel a hariki o Sinar re Babilon, e Ariok, a hariki o Elasar, e Kedor a hariki o Elam, e Tidal a hariki o Goim, ri vadili vapopo a tara, ");
INSERT INTO bnp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ri vaubi turana a tara ne Bera a hariki o Sodoma, e Birsa a hariki o Gomora, e Sinab a hariki o Adma, e Semeber a hariki o Seboim. A hariki o Bela re Soar, ia tara i dili turane ria. ");
INSERT INTO bnp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Re huriki a hariki nga ri vadili vapopo ri ru palupu a tara ne ria na maloku ne Sidim ra Dari Mate. ");
INSERT INTO bnp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Re huriki nga, e Kedor i matakari ria na pida i ravulu a polona i rua. Pali na tahuna ri bele na pida i ravulu a polona i tolu, ri koi na narone Kedor, lakea ri vaubi turana e huriki a tara vona. ");
INSERT INTO bnp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Na pida i ravulu a polona i va, e Kedor turana e huriki a hariki ri muri vona, ri vaubi turana a tara ne Repait iea o Asterot Karanaim. Ri ratapile a tara ne Sus iea o Ham. Ri ratapile a tara ne Em iea o Save Kiriataim. ");
INSERT INTO bnp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ri ratapile a tara ne Hori na lolo na robo e Seir, i vano i harena o El Paran tabukoi na tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ri vuru mule vonga, ri lakea mai e En-Mispat re Kades, ri rata a vabinga. Ri bole lobo a robo ne huriki a Amalek turana a robo ne huriki a Amor ra ri made o Hasason-Tamar. ");
INSERT INTO bnp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Muri a hariki i ala lima na tanga e Sodoma, e Gomora, e Adma, e Seboim, e Bela re Soar, ri puru na Maloku ne Sidim. ");
INSERT INTO bnp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ri paha taga vonga, ri dava a tara ne Kedor a hariki o Elam, e Tidal a hariki o Goim, e Amrapel a hariki o Sinar, e Ariok a hariki o Elasar. A tara na hariki o Sodoma i lima, a tara na hariki o Elam i va. ");
INSERT INTO bnp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ra Maloku ne Sidim i tahoka a maka lovo na kolta. Na tahuna ri ha a tara na hariki o Sodoma o Gomora, ri boru puru na lovo ranga, pali ranga ri ha sike na kupona. ");
INSERT INTO bnp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Lakea e huriki a tara ne huriki a hariki ala va ri bole lobo a maka mahala, a maki ni kani ne huriki a tara ne Sodoma e Gomora, ri vano turana. ");
INSERT INTO bnp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","E Lot, e tune tarine Abram, i made o Sodoma na tahuna iea. Ia tara ni lakavu, ni bole turana a maka mahala vona. ");
INSERT INTO bnp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","A bakovi i ha na vabinga, i vano i vakalongoa e Abram, ra Hibru. E Abram i made tabukoi na maka kai dagi ne Mamare. E Mamare e turana e Eskol e Aner, tou a hamone Amor, pali to taga turane Abram. ");
INSERT INTO bnp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Na tahuna e Abram i longo ni lakavu e tune tarina, i gale palupu e huriki a tara ni vaubi ala 318, na kabu vona kunana, ri vano ri matakana a hariki ala va nga, ri harena na tanga e Dan. ");
INSERT INTO bnp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Na rodo e Abram i kalipopoa a tara vona, ri valili vona e huriki a pile, ri vano ri harena o Hoba meli o Damaskus. ");
INSERT INTO bnp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","E Abram i bole mulea e Lot, e tuna e tarina, turana a maka mahala vona, e huriki a ngatavine turana e huriki a viri ranga. ");
INSERT INTO bnp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","E Abram i ratapilea a tara ne Kedor turana e huriki a hariki ri taga palupu, muri i hamule. A hariki o Sodoma i longoa, i vano i halala ia na Maloku e Save ra Maloku na Hariki. ");
INSERT INTO bnp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Muri e Melkisadek, a hariki o Salem i bole valai a bret a vain. E Melkisadek ia a prister na Vure Meli Liu. ");
INSERT INTO bnp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","I gamaia ngane e Abram i ta maea, “A Vure Meli Liu i rata rike a hunu a malala i gamai ioe. ");
INSERT INTO bnp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ni gi kavurike a Vure Meli Liu, i ru na limamu e huriki a pile vomu.” Lakea e Abram, i ru na naguna i ravulu a maki lobo i bole, i habi ne Melkisadek a naguna i taku. ");
INSERT INTO bnp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","A hariki o Sodoma i takia e Abram, i ta maea, “A ngaru go bole lobo a maka mahala, pali e huriki a bakovi nau kunana ri gi hamule mai iau.” ");
INSERT INTO bnp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Pali e Abram i koli mule, i ta maea, “Iau a kaba pali ne BAKOVI DAGI, a Vure Meli Liu, i rata rike a hunu a malala. Iau a rata a ngava dagi pali, ");
INSERT INTO bnp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","i uka ma ga bole ranga maki vomu. A maki lili kiroko i manga a motana vahapolo ranga i uka ma ga bole, a vuhuna muri ma bara o ta maea, ‘Iau kunana a tuhoria e Abram i tahoka a mahala i kupo.’ ");
INSERT INTO bnp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Iau i uka ma ga bolea tara maki. A maki bara bole kunana ra maki ri kani pali e huriki a tara nau. Pali a turagu nga ala tolu e Aner, e Eskol, e Mamare, to go bole ne tou.” ");
INSERT INTO bnp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Muri a nitane BAKOVI DAGI i bele ne Abram na vurena, i ta maea, “Abram, naha ni mangenge, iau a galeu vomu, ga rata kamumu hateka ioe.” ");
INSERT INTO bnp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Lakea e Abram i nana maea, “Bakovi Dagi, ioe a matakari na maki lobo, a ra go habia nau? Iau a bala e tugu. A viri bara i bole a murigu re Elieser o Damaskus. ");
INSERT INTO bnp_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ioe i uka ma o habia nau tara koma. A vora nau bara i bole lobo a mahala nau.” ");
INSERT INTO bnp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Muri a ngava ne BAKOVI DAGI i bele vona, “Ra bakovi iea i uka ma ge bole a murimu. E tumu muholi a viri bara i bole a murimu.” ");
INSERT INTO bnp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Muri e Bakovi Dagi i tuli talea e Abram i takia, “O mata rike na hunu, o toni ni gi lobo a hada nga.” Muri i takia, “E huriki a hamomu bara ri kupo manga a hada nga.” ");
INSERT INTO bnp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","E BAKOVI DAGI i galea e Abram a bakovi malamala, a vuhuna i luhoi a nitana. ");
INSERT INTO bnp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","I taki tabua e Abram, “Iau e BAKOVI DAGI. Iau kunana a bole tala ioe na tanga e Ur na robo e Kaldia, a habia vomu ra malala iea, ngane ge ne vomu liu.” ");
INSERT INTO bnp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Lakea e Abram i ta maea, “Bakovi Dagi, ioe a matakari na maki lobo, ga matakilala navia a malala iea ge ne nau?” ");
INSERT INTO bnp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Lakea a Vure i koli mulea, i ta maea, “O vano o bole valai a kinana bulmakau, a meme, a sipsip a toga. A pida ne tou ge tolu. O bole turana a balu tano, a balu havura.” ");
INSERT INTO bnp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Lakea e Abram i bole a maka maki nga, i habi na Vure. Muri i poka a maka maki nga, i bale ruarua. Pali a kadirovo i rua i uka ma i poka. ");
INSERT INTO bnp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Muri i valai a maka loha ta ri gi gogo a maka kania nga, pali e Abram i lili tala ria. ");
INSERT INTO bnp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","I tabukoi ge rolo a haro, i mahita mate e Abram, lakea a uvo vatubi i kavitagua, i ratea i mangenge hateka. ");
INSERT INTO bnp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Lakea e BAKOVI DAGI i takia, “Muholi hateka, e huriki a hamomu bara ria a mosi na robo basi tara, bara ni vakavora, ni vakamadihi ria na pida i 400. ");
INSERT INTO bnp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pali iau bara ratapilea a tanga ra i vakavora ria, muri bara ri pagitala turana a mahala i kupo. ");
INSERT INTO bnp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pali ioe bara o made na nivalemu ge harena na tahuna o gare liu vona, o mate, ni tanu. ");
INSERT INTO bnp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","E huriki a hamomu ri vakatubu ne kukulima, bara ri hamule valai koea muri ma. Pali i uka ma ge ioe, a vuhuna a naro hale ne huriki a Amor i uka ma i hale hateka ma.” ");
INSERT INTO bnp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","I rolo pali a haro, i bele a uvo lakea i bele a hubena kanono turana a ulo i vona a pokona, ru tabuli na kurukuruna kania. ");
INSERT INTO bnp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Na parava iea, e BAKOVI DAGI i ratea a ngava dagi turane Abram, i ta maea, “Iau a habia ne huriki a hamomu a malala iea, i vakatubu na naru e Vadi o Egipto i harena na naru dagi e Iupretis, ");
INSERT INTO bnp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","turana a maka robo na kabu ne Ken, ne Kenis, ne Kadmon, ");
INSERT INTO bnp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ne Hiti, ne Peres, ne Repaim, ");
INSERT INTO bnp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ne Amor, ne Kenan, ne Girgas, ne Iebus.” ");
INSERT INTO bnp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","E Sarai, e girihine Abram, i uka ma i poda a koma, pali a vorakato na ngatavine o Egipto i leho vona, a rana e Hagar. ");
INSERT INTO bnp_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Lakea e Sarai i takia e Abram, i ta maea, “E BAKOVI DAGI i uka ma i ngaru iau ga tahoka a koma. O vano o mahita turana a vora ngatavine nau, ge tahoka a koma. Muri ga paua a koma, ga vakabele a kabu tarua vona.” E Abram i longo vona a ngavane Sarai. ");
INSERT INTO bnp_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Lakea e Sarai i bolea a vorakato vona, a ngatavine o Egipto, i habia ne girihina i parangi vona. Na tahuna iea, e Abram i made pali vonga o Kenan na pida i ravulu. ");
INSERT INTO bnp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","E Abram i mahita turana e Hagar, muri i singou. Na tahuna e Hagar i lohoka vona i singou, i vakatubu ni tagege i biu a ngatavine dagi vona e Sarai. ");
INSERT INTO bnp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Lakea e Sarai i tahatea e Abram, i ta maea, “Ioe a vuhuna ra a nimadihi i bele nau. A habia vomu a vorakato nau ngane i singou, i tagege hateka. Pali e BAKOVI DAGI kunana bara i vara tarua ma.” ");
INSERT INTO bnp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","E Abram i koli mulea a nitane girihina, i ta maea, “A vorakato vomu ngane i made na limamu. O rata virihia vona a ra maki o ngarua vona.” I vakatubu vonga, e Sarai i tepua e Hagar, muri e Hagar i ha. ");
INSERT INTO bnp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Na dala lakea o Sur, tabukoi na naru kiroko na tabeke i ngeki, i luve taho e Hagar vonga a agelo ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Lakea a agelo i ta maea, “Hagar, ioe a vora ne Sarai, o valai vai? Pali ngane go loko vai?” E Hagar i koli, i ta maea, “Iau a ha na ngatavine dagi nau, e Sarai.” ");
INSERT INTO bnp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Lakea a agelo ne BAKOVI DAGI i tono mulea i takia, “O hamule mai e kabe Sarai, naha ni tagege tabu, o longototoa a ngavana.” ");
INSERT INTO bnp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Lakea a agelo ne BAKOVI DAGI i voro polo liu a nita, i ta maea, “Ga vakabele ge kupo e huriki a hamomu, bara ni keri ni gi.” ");
INSERT INTO bnp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","A agelo ne BAKOVI DAGI i taki tabua e Hagar, “Ngane o singou, bara o podea a bakovi, o vunua a rana e Ismael, a vuhuna e BAKOVI DAGI i longoa a nitangi vomu. ");
INSERT INTO bnp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","E tumu bara i mata ringangi manga a donki, bara i tepu e huriki lobo. E huriki lobo ranga bara ri tepua. A nimade vona turana e huriki a viri vona i uka ma ge kamumu.” ");
INSERT INTO bnp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","E Hagar i vunua a rana e BAKOVI DAGI ra i ta turana, “A Vure i matai iau.” A vuhuna i ta maea, “A masia pali a Viri i matai iau. ");
INSERT INTO bnp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Lakea ni gale liu ra lomu iea, “a naru na Viri Mahuri i matai iau.” A naru iea i tabana na kurukuruna e Kades e Bered. ");
INSERT INTO bnp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Muri, e Hagar i podea e tune Abram bakovi, lakea e Abram i vunua e Ismael. ");
INSERT INTO bnp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","E Abram i tahoka a pida i 86 na tahuna e Hagar i podea e Ismael. ");
INSERT INTO bnp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Na tahuna e Abram i tahoka a pida i 99, i bele vona e BAKOVI DAGI i takia, “Iau a Vure Tuhaka, o laho na matagu, o rata a naro malamala. ");
INSERT INTO bnp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ga vakatorea a ngava dagi ne tarua, e huriki a hamomu ri gi bele kupo.” ");
INSERT INTO bnp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Muri e Abram i turume i lolu puru na matana Vure, lakea a Vure i takia, ");
INSERT INTO bnp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Iau ga ratea vomu tara ngava dagi, ioe ga vuhuna e huriki a kabu ge ala kupo. ");
INSERT INTO bnp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ioe i uka ma ni gi gale tabu ge Abram, ngane a ramu e Abraham, a vuhuna a rata ioe ge ioe e tamane huriki a kabu ge kupo. ");
INSERT INTO bnp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ga ratea a kabu vomu ge vakabele e huriki a kabu i ala kupo, i ranga bara ria a hariki. ");
INSERT INTO bnp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Iau ga vakatorea vomu a ngava dagi. Ra ngava dagi iea ge tabuli vakaroro vomu, ne huriki a hamomu ri gi bele muri ma. A ngava dagi i maea: Iau a Vure Muholi vomu, a Vure ne huriki a hamomu. ");
INSERT INTO bnp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ra malala e Kenan, ngane o made manga a mosi vona, ga habia vomu, ge vomu liu. Muri ga habi poloa ne huriki a hamomu. Pali iau, ge iau a Vure ne ria.” ");
INSERT INTO bnp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Muri a Vure i takia e Abraham, i ta maea, “Ioe turana e huriki a hamomu mu longototo a ngavagu. ");
INSERT INTO bnp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ra ngava dagi i lakea vomu, i lakea ne huriki a hamomu mu gu longototo kamumua: e huriki a bakovi lobo na kabu vomu ni gi pala a kuline ria. ");
INSERT INTO bnp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ra naro ni vapala a kuli, ne vona ni vakasiri a ngava dagi a habia vomu. ");
INSERT INTO bnp_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","E huriki a hamomu ri gi muri mai a naro iea, ri gi pala a kulina koma bakovi, ri tahoka a parava i polotolu. E huriki a koma bakovi, i uka ma a hamomu, ni poda na tabeke vomu, a tuna vora ni kona na tanga basi, ngi ranga ni gi pala kuline ria. ");
INSERT INTO bnp_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","E huriki a koma ni poda na tabeke vomu o ni kona na moni, ni gi pala a kuline ria. Ra ngava dagi nau i lakea na kuline mua ni pala ge tabuli vakaroro. ");
INSERT INTO bnp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","A bakovi i uka ma ni pala a kulina, ni gi tonotala na kabu vona, a vuhuna i uka ma i ramai a ngava dagi nau.” ");
INSERT INTO bnp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","A Vure i taki tabua e Abraham, “E girihimu i uka ma ni gi gale tabu ge Sarai, ngane ni gi gale ge Sara. ");
INSERT INTO bnp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Iau ga gamaia e Sara ge podea tara e tumu a bakovi. Ga gamaia e Sara ge ia e kinana e huriki a kabu i kupo, e huriki a hariki bara ri bele vona.” ");
INSERT INTO bnp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Muri e Abraham i lolu puru liu na malala, i nongo, i taki mulea, “Iau a gare, a tahoka a pida i 100 pali, pali ga vakaluve navia a koma bakovi? Pali e Sara tara i gare, i tahoka a pida i ravulu polo va (90). Pali ge poda navia a koma?” ");
INSERT INTO bnp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Lakea e Abraham i takia a Vure, “O gamaia e Ismael, ge manga ra koma o takia.” ");
INSERT INTO bnp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Lakea a Vure i ta maea, “Muholi, pali e girihimu e Sara ge podea a koma bakovi, o vunua a rana e Isak. Ga vakatora a ngava dagi nau vona, turana e huriki a hamona. ");
INSERT INTO bnp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","A nitamu i lakea ne Ismael a longoa pali. Muholi hateka ia tara ga gamaia, ga ratea ge tahoka, ge bele kupo e huriki a hamona. Ge ia e tamane huriki a matakari i ala ravulu a polona i rua (12), ga ratea a kabu vona ge dagi. ");
INSERT INTO bnp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pali a ngava dagi nau ga habi kunanea ne Isak. E Sara ge poda na parava maea na pida muri.” ");
INSERT INTO bnp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Na tahuna a Vure i ta lobo i pea e Abraham, i sike. ");
INSERT INTO bnp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Muri e Abraham i ramaia a nitana Vure, i bole e tuna e Ismael turana e huriki ni poda na tabeke vona, a vora ni kona, e huriki a bakovi lobo na tabeke vona, ni pala ria. ");
INSERT INTO bnp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","E Abraham i tahoka a pida i ravulu polova a polona i polova (99), ni pala a kulina. ");
INSERT INTO bnp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","E tuna, e Ismael, i tahoka a pida i ravulu a polona i tolu (13), ni pala a kulina. ");
INSERT INTO bnp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Na parava iea kunana e Abraham rua e tuna e Ismael ni pala a kuline rua, ");
INSERT INTO bnp_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","turane huriki a bakovi ri made turana e Abraham, e huriki ni poda na tabeke vona, e huriki a vora ni kona na mosi, ni pala a kuline ria. ");
INSERT INTO bnp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","E BAKOVI DAGI i bele ne Abraham tabukoi na maka kai dagi o Mamare. A haro i kara hateka lakea i made na matana kape vona. ");
INSERT INTO bnp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","E Abraham i mata rike i matai a mosi i ala tolu to pesi tabukoi vona. Na tahuna i matai tou, i pesi rike na kape, i tagui tou, i lolu puru ge vakasiri a ningaru vona ne tou. ");
INSERT INTO bnp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Lakea i ta maea, “Matou a bakovi dagi ngane naha ni laho polo, iau a hulu mavonga, a ngaru matou moto malo ge popote. ");
INSERT INTO bnp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Moto made dili na taruna kai, ni gi bole valai a naru moto vahilolo a vahane matou vona. ");
INSERT INTO bnp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ga bole ranga maki moto kani, moto tuhaka, muri moto go laho, a vuhuna moto bele nau.” A mosi nga to koli a ngavana, to ta maea, “Kamumu hateka, o rata manga a hini o taki.” ");
INSERT INTO bnp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Lakea e Abraham i laho malaviriri lakea na kape i takia e Sara, “O mala­viriri, o bole a plaoa ge 22 lita, o pulo, o rata ranga bret.” ");
INSERT INTO bnp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Muri i nunu lakea na kabuna bulmakau, i rabalakia a tuna bulmakau gavutuvutu, i habia na vora vona, i papa hari ni gutuna. ");
INSERT INTO bnp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ni gutu lobo a tuna bulmakau, muri i bole turana sis, a namona ruru na bulmakau i ru puru na ngalane tou. To kakani tou, pali e Abraham i pesi dava tabukoi ne tou na taruna kai. ");
INSERT INTO bnp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ngane a mosi nga to nanea, “Avia e girihimu e Sara?” E Abraham i koli, i ta maea “Ia pololilo na kape.” ");
INSERT INTO bnp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Muri e BAKOVI DAGI i ta rike i ta maea, “Iau ga hamule valai tabu na tahuna maea na pida muri, e girihimu bara i tahoka pali e tuna a bakovi.” Pali e Sara i pesi kunana na matana kape na bitona e Bakovi Dagi, i longo a ngava i taki. ");
INSERT INTO bnp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","E Abraham rua e Sara ru gare pali, a pida ne rua i kupo. E Sara i polotaroa pali a pida na ni vakabele a koma. ");
INSERT INTO bnp_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Lakea e Sara i luhoi kadoa a ngava i takia a bakovi dagi, lakea i nongo vaki mule ia, i ta maea, “Iau i malulu pali a kuligu, e girihigu tara i gare, ra ngane ga pitei navai vona a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Muri e BAKOVI DAGI i takia e Abraham, i ta maea, “A ra vuhuna e Sara i nongo, i ta maea, ‘Iau ga singou navai? Iau a gare pali.’ ");
INSERT INTO bnp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","A maki lobo a maki tavula ne BAKOVI DAGI. Na tahuna a hamule valai tabu na tahuna maea na pida muri e Sara bara i tahoka pali e tuna a bakovi.” ");
INSERT INTO bnp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Pali e Sara i mangenge i ta maea, “Iau i uka ma a nongo.” Lakea e Bakovi Dagi i takia, “Muholi, ioe o nongo.” ");
INSERT INTO bnp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Na tahuna to pesi rike a mosi nga to go vano, to tuva puru, to masia e Sodoma. E Abraham i turane tou ge rupolo tou. ");
INSERT INTO bnp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Muri e BAKOVI DAGI i taki mule ia, “A maki ga ratea i uka ma ga ta ruhulolo ne Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Muholi, e huriki a hamone Abraham bara ri ala kupo, ri pesi tora hateka. A kabu lobo na malala ni gi gamai na limana kunana. ");
INSERT INTO bnp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Iau a vulakia e Abraham, ge vara e huriki e tuna, e huriki a viri vona ri gi longototoa a ngavagu. Ri gi rata a naro ge kamumu ge kiripiripi, lakea iau bara habia ne Abraham a maki a ta muholi vona ga habia vona.” ");
INSERT INTO bnp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Muri e BAKOVI DAGI i ta maea, “A ngava ni taki virihi e Sodoma e Gomora i dagi hateka, a naro hale ne huriki vonga i hale liu, ");
INSERT INTO bnp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Iau ga puru lokovonga ga matai a narone ria i manga a hini a longo pali o i uka. Ge uka, a ngaru ni longo.” ");
INSERT INTO bnp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","A bakovi ala rua nga ru ngalakapulo, ru laho lakea o Sodoma. Pali e BAKOVI DAGI rua e Abraham ru pesi mule vonga. ");
INSERT INTO bnp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Lakea e Abraham i pesi tabukoi vona i nanea, “Ioe go ratapile e huriki ri naro kamumu turana e huriki ri naro hale? ");
INSERT INTO bnp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ge navai e huriki ri ravulu lima, a narone ria i kamumu, a tanga dagi go ratapilea? I kara ioe go luhoi e huriki kamumu ala ravulu lima, o koria a tanga dagi. ");
INSERT INTO bnp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","I uka ma a naro kamumu ra naro ta go ratea, go ratapile e huriki a bakovi kamumu turana e huriki a bakovi hale. Bara o rata e huriki ri naro hale, e huriki ri naro kamumu ri palupulupu. I uka ma a naro kamumu na Matakari na malala ra naro go ratea.” ");
INSERT INTO bnp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Lakea e BAKOVI DAGI i ta maea, “Iau bara matavisi e huriki o Sodoma ri ala ravulu lima i kamumu a narone ria, i uka ma ga ratapilea a tanga dagi, a vuhuna bara dodo ria.” ");
INSERT INTO bnp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Muri e Abraham i takia “Bakovi Dagi, iau i uka ma a mangenge ni ta turamu. Iau a maki tavula, a manga a habulo. ");
INSERT INTO bnp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Pali ge uka a viri ala ravulu lima a narone ria i kamumu, pali ge tahoka kunana a viri ge ala 45, a tanga dagi go ratapilea?” E Bakovi Dagi i koli mule i ta maea, “Bara i tahoka a viri ala 45, i uka ma ga ratapilea a tanga dagi.” ");
INSERT INTO bnp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","E Abraham i nana tabu, “Pali ge tahoka a viri ge ala ravulu va ni gi matavisi, ge navai?” E Bakovi Dagi i koli mule, i ta maea, “Bara i tahoka a viri ala ravulu va, i uka ma ga ratapilea a tanga dagi.” ");
INSERT INTO bnp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","E Abraham i nana tabu, “O hatenono, o longotaro ga ta. Pali ge tahoka a viri ge ala ravulu tolu ni gi matavisi vonga, i kamumu a narone ria, a ra go ratea?” E Bakovi Dagi i koli, i ta maea, “Iau bara matavisi a viri i ravulu tolu vonga, i uka ma ga ratapilea a tanga dagi.” ");
INSERT INTO bnp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Muri e Abraham i nana tabu, “Bakovi Dagi, iau a rata hateka a ngava i lakea vomu, pali ge tahoka a viri ge ravulu rua ni gi matavisi vonga i kamumu a narone ria, a ra go ratea?” E Bakovi Dagi i koli mule, i ta maea, “Bara i tahoka a viri ala ravulu rua, i uka ma ga ratapilea a tanga dagi.” ");
INSERT INTO bnp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Muri e Abraham i nana tabu, “Bakovi Dagi naha ni tahate, ga nana ioe balaka taku tabu. Pali a viri ge ala ravulu ni gi matavisi vonga, i kamumu a narone ria, ge navai?” E Bakovi Dagi i koli mule, i ta maea, “Bara i tahoka a viri i ala ravulu, i uka ma ga ratapilea a tanga dagi.” ");
INSERT INTO bnp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","E BAKOVI DAGI i ta lobo turana e Abraham, muri i vano. Pali e Abraham i hamule mai a tanga vona. ");
INSERT INTO bnp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Na malunga, a agelo ala rua ru bele tahoa e Lot na poridala na tanga dagi e Sodoma. Na tahuna i matai rua, i pesi rike i tagui rua. I lolu puru ge vakasiri a ningaru vona ne rua. ");
INSERT INTO bnp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Lakea i ta maea, “Marua a bakovi dagi ngane, iau a bakovi tavula. Muru valai te ge lakea na ruma nau. Muru vahilolo a vahane marua, te ge mahita. Kuduvi na hatelanga muru vuho tala, muru vano.” Lakea ru koli ru ta maea, “I uka. Miri gi mahita na mailo.” ");
INSERT INTO bnp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lakea e Lot i ta hinituhana ne rua, ru gu lakea turana na ruma vona. To bele na ruma, lakea e Lot i gutu a bret i uka is, turana a maka kania ranga. Muri i habi ne rua, ru kani. ");
INSERT INTO bnp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Muga ne rua ru gu mahita, e huriki a bakovi lobo, a riau a gare, na tabeke lobo na tanga dagi e Sodoma, ri pesi haluia a ruma. ");
INSERT INTO bnp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ri galea e Lot, “Avai ra mosi nga ru valai ngane na rodo? O turari tala valai ne mia, mi gi tari rua.” ");
INSERT INTO bnp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lakea e Lot i pagitala, i tukari mulea a logo na ruma. I ta turana e huriki a bakovi, ");
INSERT INTO bnp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","i ta maea, “Mua o huriki a turagu, a naro mu ratea i hale, naha ni ratea. ");
INSERT INTO bnp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mu longo valai. A tahoka e tugu a sirula i ala rua. Ga taparaki lakea ne mua, mu rata virihi rua vona, a ningaru ne mua. Pali a mosi nga, naha ni rata hale rua, a vuhuna ru mahita na ruma nau, a matakari rua.” ");
INSERT INTO bnp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ri gege mule, ri ta maea, “O pesi lakene. Ioe, i uka ma ioe a bakovi koea go pelekado a narone mia. O Lot, o longo valai, bara mi ratapile a mosi nga, pali ioe bara mi ratapile hateka ioe.” Ri kopea e Lot, ri boletugu lokovongea ta ri gi pukea a logo. ");
INSERT INTO bnp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pali e vikirua a mosi pololilo, ru toto tala, ru turari mulea na ruma e Lot, ru tukaria a logo. ");
INSERT INTO bnp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Muri ru ratapile e huriki a bakovi dagi, e huriki a riau, ra ri vapesihi tabukoi na mataruma. Ru rata ria i uvo a matane ria, i uka ma ri masia a logo. ");
INSERT INTO bnp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Muri a bakovi nga ru takia e Lot, “Ioe o tahoka a viri vomu, e lahuamu, e tumu bakovi, e tumu ngatavine o a viri ranga pololilo na tanga dagi, o vano o tuli ria o ha turane ria. ");
INSERT INTO bnp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Maria miri gi ratapilea e Sodoma, a vuhuna a ngava ni kau virihi maia i hale hateka. E BAKOVI DAGI i longo pali a maka rabu hale ni rata na tanga iea. I rudu maria miri gi ratapilea. Ioe o tahoka ranga viri vomu, e lahuamu, e tumu pololilo koea na tanga dagi, o vakaha ria ngane.” ");
INSERT INTO bnp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lakea e Lot i vano, i ta turana e lahuana rua, ra ru ngaru ni parangi e tuna ngatavine ala rua. I ta maea, “Muru marata malaviriri, muru pagitala vona a tanga iea, a vuhuna e BAKOVI DAGI ta ge ratapilea e Sodoma!” Pali e lahuana rua, ru luhoi ta i ta padikede. ");
INSERT INTO bnp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","I mavida a more, lakea a agelo na Vure ala rua ru ta tuhaka maia e Lot, ru ta maea, “O malaviriri! O tuli tala e girihimu, e tumu ngatavine ala rua, mu ha. Ma ge uka, bara mu bole a vuranga na tahuna e Bakovi Dagi i ratapilea a tanga dagi iea.” ");
INSERT INTO bnp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Na tahuna e Lot i loho paepae, a bakovi nga ru nugu a limana, a limane girihina, a limane tuna ngatavine ala rua, ru turari tala ria na tanga dagi, a vuhuna e BAKOVI DAGI i dodo ria. ");
INSERT INTO bnp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Na tahuna ru turari tala ria pali, lakea a agelo tara i ta maea, “Mu nunu malaviriri, mu vakakori mua. Naha ni matagege, naha ni malo na bila. Mu nunu lakea na lolo, ge uka, bara mu mate.” ");
INSERT INTO bnp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lakea e Lot i taki rua, “I uka, marua a viri dagi nau, muru longo valai. ");
INSERT INTO bnp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Iau a vora marua, muru dodo iau muru rata kamumu iau pali, muru korimule iau pali. Iau a keri ni nunu lakea na lolo, ma ge ratapile iau a vuranga, ga mate. ");
INSERT INTO bnp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","O mata lakea. A tanga kiroko tara i tabukoi, ga nunu lokovonga. O taparaki iau ga ha lokovonga na tanga kiroko iea, ga vakakori a kuligu vonga.” ");
INSERT INTO bnp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Lakea a agelo i takia, “A longoa pali a ninana vomu, i uka ma ga ratapilea ra tanga o takia. ");
INSERT INTO bnp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","O ha lokovonga malaviriri, i uka ma ga rata ranga hini, ga dava ioe o bele taro na tanga kiroko.” Ra tanga kiroko iea ni gale e Soar. ");
INSERT INTO bnp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Na tahuna e Lot i bele o Soar i hera pali a haro. ");
INSERT INTO bnp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Muri e BAKOVI DAGI i vakaboru valai na hunu a bega i vila, i boru puru ne Sodoma e Gomora. ");
INSERT INTO bnp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","I ratapile a maloku, a tanga dagi turana e huriki lobo ri made vona, a maka kai ra ri pesi na robo. ");
INSERT INTO bnp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pali e girihine Lot i matagege i vulo ia a kedo, i pesi tata liu. ");
INSERT INTO bnp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Na hatelanga pokopoko na parava muri, e Abraham i pesi rike i hamule lakea na tabeke i ta turana e BAKOVI DAGI vona. ");
INSERT INTO bnp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","I mata puru o Sodoma o Gomora, i mata lokovonga liu i masia a bila i poko bulolo, i manga a pokona kanunga. ");
INSERT INTO bnp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","A Vure i ratapile lobo ra tanga dagi nga na bila na hini i made muga vona e Lot. Pali a Vure i luhoia e Abraham, i turari talea e Lot na vuranga, na tahuna i ratapile a tanga dagi nga. ");
INSERT INTO bnp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","E Lot, tou e tuna ngatavine ala rua, to mangenge ni made o Soar, lakea to vano to made na lolo, pololilo na babe. ");
INSERT INTO bnp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Na parava tara, e tuna dagi i takia e tarina, “E tamane tarua i gare, pali ngane i uka tara bakovi ge made tabukoi ge mahita turane tarua, i manga a vilone hita lobo na malala. ");
INSERT INTO bnp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tu gu vakaninua na vain e tamane tarua, muri tu gu mahita turana, tu gu vakabele a hamone teu.” ");
INSERT INTO bnp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Na rodo iea ru vakaninua na vain e tamane rua, lakea e tuna dagi i dili i mahita turana. E Lot, i uka ma i hatakia re tuna dagi, na tahuna i mahita turana o na tahuna i pesi rike. ");
INSERT INTO bnp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Na parava muri, a viri dagi i takia a viri kiroko, “Baroko na rodo a mahita turana e tata. Barama na rodo tu gu vakaninu tabua na vain, o dili ke, o mahita turana bara tu vakabele a hamone teu.” ");
INSERT INTO bnp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Lakea ru ratea e tamane rua i ninu tabu a vain vona a rodo iea, muri a viri kiroko i dili i mahita turana. Pali i manga a hini muga, i uka ma i hatakia re tuna kiroko na tahuna i mahita turana o na tahuna i pesi rike. ");
INSERT INTO bnp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lakea re tune Lot varago nga, ru singou mule ne tamane rua. ");
INSERT INTO bnp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","A viri dagi i podea e tuna bakovi, i vunua e Moab. Ra bakovi iea, a vuhuna a kabu ne Moab mona. ");
INSERT INTO bnp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A viri kiroko tara i podea a koma bakovi, i vunua e Ben-Ami. Ra bakovi iea, a vuhuna kabu ne Amon mona. ");
INSERT INTO bnp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ngane e Abraham i pea a tanga e Mamare, i mariu lakea na robo e Negev i made na kurukuruna tanga e Kades e Sur. I made popote o Gerar, ");
INSERT INTO bnp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","lakea i tamirabu ne huriki vonga vona e girihina e Sara i ta maea, “Ra ngatavine iea e kurabagu.” Lakea e Abimelek, a hariki o Gerar, i longo mavonga, lakea i talo rike a ngava ne Sara ge valai vona. ");
INSERT INTO bnp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Na rodo i mahita e Abimelek, i vurena vona a Vure, i takia, “Ioe bara o mate, a vuhuna a ngatavine o bolea i parangi pali.” ");
INSERT INTO bnp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","E Abimelek i uka ma i lakea tabukoi ma vona a ngatavine, lakea i ta maea, “Bakovi Dagi, ioe go ratapilea a viri i kiripiripi a vilona? ");
INSERT INTO bnp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","E Abraham i takia te kurabana e Sara, pali e Sara tara i takia te kurabana e Abraham. Iau a uka ngava. A naro a ratea i kavakava, i kamumu kunana na niluhoi nau.” ");
INSERT INTO bnp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Lakea a Vure i taki tabua na vurena, “Muholi, a lohoka vona a naro o ratea na niluhoi kamumu kunana, lakea a matakari ioe, i uka ma o ratea a naro hale, na ni mahita turana. ");
INSERT INTO bnp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ngane o taparaki mulea e girihine Abraham, a vuhuna ia a propet nau. Muri bara i vasileki vomu, i uka ma go mate. Ioe i uka ma go taparaki mulea e girihina, muholi hateka ioe turana e huriki a viri vomu, bara mu mate.” ");
INSERT INTO bnp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Na hatelanga pokopoko e Abimelek i gale palupu e huriki a bolekori vona, i vakalongo ria vona a maka ngava i vurena vona, lakea ri mangenge hateka. ");
INSERT INTO bnp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Muri e Abimelek i gale dilia e Abraham i nanea, “Ioe o rata navai mia? Iau a rata hale navai ioe, o vakarare iau na harikianga nau? Ra naro o ratea i uka ma i kamumu.” ");
INSERT INTO bnp_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Muri i nana tabua, “A ra vuhuna o ratea a rabu iea?” ");
INSERT INTO bnp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Lakea e Abraham i koli mule, i ta maea, “A luhoi ta e huriki na tanga koea i uka ma ri mangenge na Vure, ma ri gi rabalaki iau, ri gi bolea e girihigu. ");
INSERT INTO bnp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","I muholi ngi, e Sara e kurabagu, e tamane maria i taku, e kinane maria i herehere, lakea iau a bolea a parangi vona. ");
INSERT INTO bnp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na tahuna a Vure i taki iau ga pea a tabeke nau ga lakea na robo basi, a takia e Sara a ta maea: na tabeke tu gu lakea vona, o tami rabu, o vakasiri iau manga iau a hatemu o ta maea, ‘E Abraham e kurabagu.’” ");
INSERT INTO bnp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Muri e Abimelek i talo mulea e Sara i bole a maka sipsip, a bulmakau, a vora ngatavine a vora bakovi, i habi ne Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Lakea e Abimelek i takia e Abraham i ta maea, “Ra tabeke nga a robo nau. O matai ranga tabeke o made vona.” ");
INSERT INTO bnp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","I taki tabua e Sara i ta maea, “Ga habi ne kurabamu a kedo silva i 1000, ne vona ni vakalobo a maregoa i bele vomu. Na matane huriki a bakovi a ngatavine, ioe i uka ma o rata a naro hale.” ");
INSERT INTO bnp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Muri e Abraham i vasileki na Vure, lakea i korimulea e Abimelek. I korimule tabu e girihine Abimelek turana e huriki a vorakato ngatavine ri gi poda. ");
INSERT INTO bnp_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","A vuhuna e BAKOVI DAGI i rata e huriki a ngatavine lobo na tabeke ne Abimelek, ri lame, a vuhuna e Abimelek i rata a rabu hale, i parangi vona e Sara, re girihine Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","E BAKOVI DAGI i rata kamumua e Sara, i muri mai a ngava i takia vona, lakea i habia vona a ningaru i taki mugea. ");
INSERT INTO bnp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","E Sara i singou i podea a koma na tahuna e Abraham i gare pali. E Sara i podea a koma na tahuna e Bakovi Dagi i taki mugea pali. ");
INSERT INTO bnp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","E Abraham i vunua a koma i podea e Sara, e Isak. ");
INSERT INTO bnp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Na tahuna e Isak i tahoka a parava i polotolu, e Abraham i muri mai a nitana Vure, i palea a kuline tuna. ");
INSERT INTO bnp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","E Abraham i tahoka a pida i 100, lakea e Sara i podea e Isak. ");
INSERT INTO bnp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Muri, e Sara i ta maea, “A Vure i habia nau a nipitei. E rei i longoa a velengagu bara i vivi turagu.” ");
INSERT INTO bnp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","E Sara i ta tabu, “Muga, e rei a viri ge takia e Abraham ne Sara ge tahoka a koma? Ngane e Abraham i gare, pali a podea vona e tuna bakovi.” ");
INSERT INTO bnp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","E Isak i kulabo, lakea i pile a ruru. Na tahuna i pile a ruru, lakea e Abraham i made maia. ");
INSERT INTO bnp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","E Hagar, ra ngatavine o Egipto, ia tara i podea ne Abraham a koma bakovi. Na parava tara, e Sara i masia a koma iea i rehi turana e tuna, ");
INSERT INTO bnp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","lakea i takia e Abraham, “O lili talea ra vorakato ngatavine turana e tuna. E tuna vorakato ngatavine, i uka ma ru gu vaveru vona e tugu e Isak, a mahala vomu.” ");
INSERT INTO bnp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ra ngava iea, i ratea e Abraham i loho lege lae a vuhuna e Ismael tara e tuna. ");
INSERT INTO bnp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pali a Vure i takia, “Naha ni luhoi lege lae vona a koma bakovi turana a vorakato ngatavine vomu. O longo maia a ngava i taki ioe vona e Sara, a vuhuna e Isak bara i vakabele e huriki a hamomu. ");
INSERT INTO bnp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","E tuna vorakato ngatavine vomu tara ga ratea ge vakabele e huriki a hamona ri gi ala kupo, a vuhuna ia tara e tumu.” ");
INSERT INTO bnp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Na hatelanga pokopoko na parava muri, e Abraham i bole ranga maki ni kani turana a naru ni kiru dili na kulina meme, i vakakube e Hagar vona, i rudua ge vano turana e tuna. E Hagar i vano i laho viliha na tabeke i ngeki ne Bersiba. ");
INSERT INTO bnp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","A naru na buroi i lobo, lakea e Hagar i vakamadea e tuna na taruna kai kiroko. ");
INSERT INTO bnp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Muri i laho lokovonga popote, i made puru, a vuhuna i koi ni masia e tuna ge mate. E Hagar i made puru i vakatubu ni tangi. ");
INSERT INTO bnp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Muri a Vure i longoa a koma i tangi, lakea a agelo i gale valai meli na hunu i ta maea, “Hagar i navai? Naha ni mangenge. A Vure i longoa pali a nitangi ne tumu. ");
INSERT INTO bnp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","O vano o tuli pesia, o tangotata tora ia, a vuhuna iau ga ratea ge bele kupo e huriki a hamona.” ");
INSERT INTO bnp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Muri a Vure i vakapalala a matane Hagar, lakea i masia a lomu. I vano i kirua a buroi, i vakaninua e tuna. ");
INSERT INTO bnp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","A Vure i matakaria e Ismael, i koru rike. I made na tabeke i ngeki, ia a mari ni voro a kiniperi. ");
INSERT INTO bnp_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Na tahuna i made na tabeke i ngeki e Paran, e kinana i vakaparangia na ngatavine o Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Na parava tara e Abimelek turane Pikol, a burena tara vona, ru lakea ne Abraham. Lakea e Abimelek i takia, “A Vure i turamu na maki lobo o rata. ");
INSERT INTO bnp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ngane o kaba o ta muholi nau na matana Vure, naha ni tami iau, e huriki e tugu, turana e huriki a hamogu. Ioe a mosi, o vakasiri a naro kamumu nau turana a malala o made vona, i manga iau a rata a naro kamumu vomu.” ");
INSERT INTO bnp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Lakea e Abraham i koli mule, i ta maea, “Iau a ta muholi.” ");
INSERT INTO bnp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Muri e Abraham i hehea e Abimelek na lomu vona e huriki a vora ne Abimelek ri radia. ");
INSERT INTO bnp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Lakea e Abimelek i ta maea, “Iau i uka ma a lohoka vona a viri i ratea a naro iea. Ioe i uka ma o vakalongo muga iau. Mona kunana a longoa a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Lakea e Abraham i bole ranga sipsip a bulmakau, i habi ne Abimelek, ru valongo mai a ngava. ");
INSERT INTO bnp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","E Abraham i bole tala na kabu na sipsip vona, a tuna sipsip a kinana i polorua, i ru here ria. ");
INSERT INTO bnp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Lakea e Abimelek i nanea e Abraham, “I navai o bole a tuna sipsip a kinana i polorua, o ru here ria?” ");
INSERT INTO bnp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","E Abraham i ta maea, “O bole na limagu a tuna sipsip a kinana i polorua nga, ge vakasiri, iau a kelia ra lomu iea.” ");
INSERT INTO bnp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ra tanga iea ni gale Bersiba, a vuhuna ra bakovi ala rua nga ru valongo mai a nita muholi vonga. ");
INSERT INTO bnp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Muri na ngava dagi ni rata o Bersiba, e Abimelek rua e Pikol, a burena tara vona, ru hamule lakea na robo na Palestina. ");
INSERT INTO bnp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","E Abraham i varoa o Bersiba a kai a tamaris, lakea i kavurikea vonga a rana e BAKOVI DAGI, a Vure Vakaroro. ");
INSERT INTO bnp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Muri e Abraham i made tabaka na robo na Palestina na parava i kupo. ");
INSERT INTO bnp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Muri na parava ranga i polo, a Vure i ngaru ni tonia e Abraham. Lakea i galea, “Abraham!” E Abraham i longo, i ta maea, “Iau ieni.” ");
INSERT INTO bnp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Lakea a Vure i takia, “O bolea e tumu e Isak, re tumu a hatemu, i ala taku kunana. O havai maia a robo e Moria. Na tahuna o bele vonga, ga vakasiria vomu tara lolo. O sike maia, o rabalakia vonga e tumu, o habia nau, ge manga a nihabi gutu-vuro.” ");
INSERT INTO bnp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Na hatelanga pokopoko na parava muri e Abraham i hadongo i kisia a donki vona. Muri i vakarike na bitona donki a kai i popo puru ne vona ni gutu a nihabi vona. Muri i tuli e Isak turana a vora vona ala rua, ri havai maia a robo i takia vona a Vure. ");
INSERT INTO bnp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Na toluna parava i tuva e Abraham i masia a lolo. ");
INSERT INTO bnp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Muri i taki a vora vona ala rua i ta maea, “Muru dava koea turana a donki. Miri gi sike taro maria, miri gi kavurike a Vure, muri miri gi puru valai. ");
INSERT INTO bnp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Muri e Abraham i vakakaloho e Isak vona a galesi na kai, ne vona a nihabi gutu-vuro. I pi a kanono, i bole a vito ia. Na tahuna ru laho sike, ");
INSERT INTO bnp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","lakea e Isak i galea e Abraham, “O tata?” E Abraham i koli mule, i ta maea, “O tugu, i navai?” Lakea e Isak i nanea, “A kanono a kai koea, pali i vai a tuna sipsip ne vona a nihabi gutu-vuro?” ");
INSERT INTO bnp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","E Abraham i koli, i ta maea, “O tugu, a Vure bara i habia ne tarua a tuna sipsip ne vona a nihabi gutu-vuro.” E Isak i nana lobo e tamana, muri ru laho sike. ");
INSERT INTO bnp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Na tahuna ru bele na mapana lolo, na hini a Vure i taki e Abraham vona, lakea e Abraham i ratea vonga a dede-kedo. I ru vapopo langa vona a kai. Muri i kolotatea e tuna, i bolea i vakatabuli langea na kai. ");
INSERT INTO bnp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Muri i bole rikea a vito, ta ge rabalakia e tuna. ");
INSERT INTO bnp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Pali a agelo ne BAKOVI DAGI i gale valai na hunu i ta maea, “Abraham, Abraham!” E Abraham i ta maea, “Iau ieni.” ");
INSERT INTO bnp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Lakea a agelo i takia, i ta maea, “Naha ni padoia a koma, naha ni ratea vona tara maki. Ngane a lohoka vomu o mangenge a Vure, a vuhuna i uka ma o vakatokua vona e tumu, re tumu i ala taku kunana.” ");
INSERT INTO bnp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Muri e Abraham i taratavaga rike, i masia a sipsip a toga i koro na kai kiroko a pelengana. Lakea i bolea, i rabalakia, i habia, i bole a murine tuna. ");
INSERT INTO bnp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Lakea e Abraham i vunua a lolo iea, “E BAKOVI DAGI i habi.” Pali i vakatubu vonga i valai mona, e huriki ri ta maea, “Na lolo ne BAKOVI DAGI i habi.” ");
INSERT INTO bnp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","A agelo ne BAKOVI DAGI i gale valai tabu na hunu i takia e Abraham, ");
INSERT INTO bnp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","i ta maea, “E BAKOVI DAGI i kaba mule na rana, i vakalongo maea: ‘A vuhuna o ratea a naro i kamumu hateka i uka ma o vakatokua nau e tumu, re tumu i ala taku kunana, ");
INSERT INTO bnp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ngane ga gamai ioe, ga rata e huriki a hamomu ri gi ala kupo manga a hada na hunu, a hire na lavu. E huriki a hamomu ri gi vadede langa vona e huriki a pile ne ria, ri gi bole a vuhutanga ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","I kamumu o longototo a ngavagu. Ngane ga rata e huriki a hamomu ri gi rata kamumu e huriki lobo na malala.” ");
INSERT INTO bnp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Muri e Abraham rua e Isak ru hamule mai a vora ra ru dava tano, to hamule lakea o Bersiba. Lakea e Abraham i made vonga. ");
INSERT INTO bnp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Muri, e Abraham ni vakalongo maea, “E Milka, e girihine Nahor, i poda e huriki a koma bakovi. ");
INSERT INTO bnp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A tabua e Us. E tarina e Bus, e Kemuel re tamane Aram, ");
INSERT INTO bnp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","e Kesed, e Haso, e Pildas, e Idlap, e Betuel.” ");
INSERT INTO bnp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","E Betuel e tamane Rebeka. E Milka i poda e huriki a koma a bakovi i polotolu ne Nahor, re turane Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","E girihina tara, a rana e Reuma. Ia tara i poda e huriki e tuna a bakovi. A rane ria ra nga: e Teba, e Gaham, e Tahas, e Maka. ");
INSERT INTO bnp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","E Sara i tahoka a pida i 127, ");
INSERT INTO bnp_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","muri i mate na tanga e Kiriat-Araba, a rana tara e Hebron na robo e Kenan. Lakea e Abraham i dodo hatekea, i taringia. ");
INSERT INTO bnp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Muri e Abraham i pesi rike na dahana podane girihina, i taki e huriki a kabu ne Hiti, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Iau a mosi a made koea. Mu habi nau ranga malala ga kona, ga tanu e girihigu vona.” ");
INSERT INTO bnp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Lakea e huriki a kabu ne Hiti ri koli mule, ri ta maea, ");
INSERT INTO bnp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Bakovi dagi, o longo valai, ioe a kakaina tanga. O tanua e girihimu na tabeke o ngaru ni tanua vona. Mia takutaku, i uka ma mi gi vakatoku ioe vona a tabeke go tanu e girihimu vona.” ");
INSERT INTO bnp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Lakea e Abraham i pesi rike i lolu puru mai e huriki a tahona malala, i kavurike ria, ");
INSERT INTO bnp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","i ta maea, “Mua bara mu longo ga tanua koea e girihigu, pali a ngaru mua mu gu nanea e Epron e tune Sohar vona ");
INSERT INTO bnp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ra babe ni gale e Makpela, ra na harena malala vona. Mu takia ge habia nau ga kona talea vona, ga tanua vona e girihigu turane huriki ri gi mate muri ma.” ");
INSERT INTO bnp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","E Epron i made vonga turana e huriki a kabu vona a Hiti, lakea i takia e Abraham na matane huriki ri made vonga na poridala na tanga dagi, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Bakovi dagi, i uka ma ge mavonga. O longo valai. Ga habia vomu a malala. A babe tara, i vona ra malala iea. A habi vomu na matane huriki a viri nau. O vano o tanua e girihimu.” ");
INSERT INTO bnp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","E Abraham i lolu puru mai e huriki a tahona malala i kavurike ria, ");
INSERT INTO bnp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","i takia e Epron na matane ria lobo, “O longo valai, ioe o ngaru, ga konea a malala iea. O longo mai iau, ga tanua vonga e girihigu.” ");
INSERT INTO bnp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","E Epron i koli mulea e Abraham i ta maea, ");
INSERT INTO bnp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Bakovi dagi, o longo valai, a mapana malala i 50 kilo silva. A maki tavula ne tarua. O vano o tanu kunanea e girihimu.” ");
INSERT INTO bnp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","E Abraham i longo maia a nita ne Epron, ra i takia na matana e huriki a kabu vona, lakea i habi vona a 50 kilo silva, i muri mai a mapana maki ni vangoli ni vahabi a maki na tahuna iea. ");
INSERT INTO bnp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","I mavonga, a robo ne Epron, o Makpela, i tabukoi o Mamare, turana a malala, a babe, a maka kai pololilo vona i bole lobo. ");
INSERT INTO bnp_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","E huriki a kabu ne Hiti ri bele vona na tahuna iea ri lohoka vona a malala iea, ne vona e Abraham ngane. ");
INSERT INTO bnp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Muri e Abraham i rua a podane girihina, e Sara, pololilo na babe na malala e Makpela, tabukoi o Mamare, re Hebron, na robo e Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ra malala turana babe, a kabu ne Hiti i habia ne Abraham ge tanu a viri vona. ");
INSERT INTO bnp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ngane e Abraham i gare i tahoka a pida i kupo. E BAKOVI DAGI i gamaia na maka maki i rata. ");
INSERT INTO bnp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Lakea i takia a matakari na vora na ruma vona, ra viri i matakari a maka mahala vona, “O ru polotanoa na labugu a limamu. ");
INSERT INTO bnp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","A vuhuna a ngaru ioe go ta muholi ne BAKOVI DAGI a Vure na hunu a malala. I uka ma go habikaria e girihine tugu ne huriki a ngatavine na kabu ne Kenan, re huriki a made turane ria. ");
INSERT INTO bnp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","O hamule lakea na robo a vuhuna vona, ne huriki a viri nau, o habikaria vonga e girihine tugu, e Isak.” ");
INSERT INTO bnp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Lakea a vora i nanea, “Pali a ngatavine ge koi ni valai vona a robo iea, ga marata navai? E tumu, ga bole lokovongea na robo o vuhuna vona, o ge uka?” ");
INSERT INTO bnp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","E Abraham i koli mule, i ta maea, “Naha ni bole lokovongea na robo a vuhuna vona. ");
INSERT INTO bnp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","E BAKOVI DAGI, a Vure na hunu, ra i bole tala iau na tabeke ne tata, i rata a ngava dagi i ta maea, ‘Ga habia ne huriki a hamomu a robo iea.’ Bara i rudu mugea a agelo vona, ge habikaria vonga e girihine tugu. ");
INSERT INTO bnp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Pali a ngatavine ge koi ni hamule turamu, ra ngava dagi o ta muholi vona nau, naha ni loho paepae vona. E tugu kunana naha ni bole lokovongea.” ");
INSERT INTO bnp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Lakea a vora i ru polotanoa na labuna bakovi dagi vona, e Abraham, a limana, i ta muholi ge ramai a ngava ni taki vona. ");
INSERT INTO bnp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Muri a vora iea i lalu a kamel i ravulu na bakovi dagi vona, i vakarike a maka mahala vona, i vano. I havai maia a tanga dagi e Nahor na robo e Mesapotamia, a rana tara e Aram Naharaim. ");
INSERT INTO bnp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Na malunga i vakapasike tabukoi na lomu a kamel vona polovavo na tanga dagi, i dava e huriki a ngatavine ri gi kiru. ");
INSERT INTO bnp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Muri i vasileki maea, “BAKOVI DAGI, ioe a Vure na matakari nau e Abraham, o habi a mulangia nau mona, o vakasiri a naro kamumu vomu na matakari nau e Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Iau a pepesi na dahana lomu iea, e huriki a ngatavine na tanga dagi ri gi valai, ri gi kiru a naru. ");
INSERT INTO bnp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Pali iau ga takia tara ngatavine, ‘O habi nau a naru na ulo ga ninu.’ Pali ia ge ta maea, ‘O ninu. A kamel vomu ranga ga vakaninu ria.’ Ra ngatavine iea kunana a viri o vulakia na vora vomu, e Isak. Na naro iea kunana bara lohoka, ioe o rata a naro kamumu na matakari nau.” ");
INSERT INTO bnp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","I uka ma i vakaloboa ma a nivasileki vona, e Rebeka i kube vilia a ulo. E Rebeka, e tamana e Betuel. E Betuel ia e tune Milka rua e Nahor. E Nahor e turane Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Re Rebeka, ia a sirula, i mata kamumu hateka. I uka tara bakovi ge mahita turana ma. E Rebeka i puru na naru, i kirua a ulo vona, i sike valai tabu. ");
INSERT INTO bnp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Lakea a vora i laho malaviriri lakea vona, i taguia, i ta maea, “O habi nau a naru popote vomu na ulo, ga ninu.” ");
INSERT INTO bnp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Lakea e Rebeka i ta maea, “Bakovi dagi, o ninu.” Lakea i malaviriri kunana i bole purua a ulo i habia vona, i ninu. ");
INSERT INTO bnp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","I habi lobo a naru vona i ninu, lakea i ta maea, “Ga habi na kamel vomu ranga naru, ri gi ninu, ri gi maru.” ");
INSERT INTO bnp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","I malaviriri kunana, i liki vuroki na gaga a lingena naru, i nunu hamule na lomu i kiru tabu a naru, i vakaninu a maka kamel, ri maru. ");
INSERT INTO bnp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","A vora, i uka ma i takia tara ngava, i matanono kunanea, ge matakilalea, e BAKOVI DAGI i habi a mulangia vona, o i uka. ");
INSERT INTO bnp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","A maka kamel ri ninu lobo, lakea a vora i valiki talea a malau haluilui, ni rata na gol turana a bio i rua, ngi ranga ni rata na gol. A nimavana a malau haluilui i 5.5 gram. A nimavana bio i 110 gram. ");
INSERT INTO bnp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Muri i nana, “Ioe e tune rei? A ruma e tamamu, i tahoka a hini mi gi mahita taro vona na rodo?” ");
INSERT INTO bnp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Lakea e Rebeka i koli mulea i ta maea, “Iau e tune Betuel. E sisi bakovi e Nahor. E sisi ngatavine e Milka. ");
INSERT INTO bnp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Mi tahoka a varili i kupo a maka kamel vomu bara ri kani. A ruma ne tata tara i ngavaka, i tahoka a hini bara mu mahita vona na rodo.” ");
INSERT INTO bnp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Lakea a vora i lolu puru i kavurikea e BAKOVI DAGI, ");
INSERT INTO bnp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","i ta maea, “Iau a kavurike e BAKOVI DAGI, a Vure na matakari nau e Abraham, i uka ma i vakatoku a naro kamumu vona, a niluhoi kamumu na matakari nau. Pali iau, a nilaho nau iea, e BAKOVI DAGI i vakasiri iau vona a tabeke na kabu na matakari nau.” ");
INSERT INTO bnp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Lakea a koma ngatavine i nunu i vakalongo e huriki na tabeke ne kinana, na maka maki i bele. ");
INSERT INTO bnp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","E Leban e kurabana e Rebeka, i laho hari lakea na naru. ");
INSERT INTO bnp_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Na tahuna i matai a malau haluilui, a bio na limane kurabana, i longo a ngava i taki vona e Rebeka na nita i taki vona a bakovi. Lakea i vano i pugaia tabukoi na naru, i pesi turana a maka kamel. ");
INSERT INTO bnp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lakea e Leban i ta maea, “O valai, e BAKOVI DAGI i gamai ioe pali. I navai a hini o pepesi koea? Iau a kado purua pali a roho, a tabeke na kamel ranga a kado puru.” ");
INSERT INTO bnp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Muri a bakovi i vano i lakea na roho, lakea ri bole puru na kamel a maka mahala. Ri vakani a maka kamel, a naru ni bole lakea vona ge vahilolo a vahana turana e huriki a bakovi ri havai turana. ");
INSERT INTO bnp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ri bole a maka maki ni kani ri ru na ngalana, lakea a bakovi i ta maea, “Ga taki taro mua vona a ngava a laho vona, muri si gi kani.” Lakea e Leban i koli mule i ta maea, “O vakalongo mia taro.” ");
INSERT INTO bnp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Lakea a vora i ta maea, “Iau a vora ne Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","E BAKOVI DAGI i gamai kamumua a matakari nau. Ia a viri na mahala. I habi vona a maka sipsip, a bulmakau, a silva, a gol, a vora bakovi, a vora ngatavine, a kamel, a donki. ");
INSERT INTO bnp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","E girihina matakari nau, e Sara, i gare liu, pali i podea a koma bakovi, lakea e tamana i habi lobo vona a maka mahala vona. ");
INSERT INTO bnp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Lakea a matakari nau i taki iau ga ta muholi vona, i ta maea, ‘Naha ni bolea e girihine tugu ne huriki a ngatavine na kabu ne Kenan, ra malala ne ria a made vona. ");
INSERT INTO bnp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","O hamule lakea na kabu ne tata, na kabu nau, o bole ne ria e girihine tugu.’ ");
INSERT INTO bnp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Muri a nanea a matakari nau, ‘Pali a ngatavine ge koi ni hamule turagu?’ ");
INSERT INTO bnp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Lakea i ta maea, ‘Iau a laho turane BAKOVI DAGI. Ia bara i rudua a agelo vona ge laho turamu, ge ratea a nihavai vomu ge mulangi, bara o bolea e girihine tugu na kabu ne tata. ");
INSERT INTO bnp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","O lakea na kabu nau, pali ria ri gi koi ni habia vomu a ngatavine, ra ngava dagi a taki ioe vona, naha ni luhoi hatekea.’ ");
INSERT INTO bnp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Na tahuna a valai na naru mona, a vasileki maea, ‘BAKOVI DAGI, a Vure na matakari nau e Abraham. O habi a mulangia vona a ngava ra a havai maia. ");
INSERT INTO bnp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Iau a pepesi na dahana naru. A ngatavine tara ge valai ge kiru, ga takia, “Kamumu, o bole valai a naru popote na ulo vomu, ga ninu.” ");
INSERT INTO bnp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","A ngatavine ge kolia a ngava, ge ta maea, “O ninu. A kamel vomu ranga ga vakaninu ria.” ra ngatavine iea kunana e BAKOVI DAGI i vulakia ne vona e tuna matakari nau, ge parangi vona.’ ");
INSERT INTO bnp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Iau i uka ma a vakaloboa ma na hategu a nivasileki, lakea e Rebeka i kube valai a ulo. I puru na naru i kiru, lakea a takia, ‘O habi nau a naru ga ninu.’ ");
INSERT INTO bnp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Lakea e Rebeka i bole purua na gina a ulo, i ta maea, ‘O ninu, a kamel vomu ranga ga vakaninu.’ A ninu lobo, muri i vakaninu a maka kamel. ");
INSERT INTO bnp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Lakea a nanea, ‘Ioe e tune rei?’ “Lakea i ta maea, ‘Iau e tune Betuel. E sisi bakovi e Nahor. E sisi ngatavine e Milka.’ “Muri a vakarodoa na ruperena a malau haluilui, a vakarodoa na limana a bio. ");
INSERT INTO bnp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","A lolu puru a kavurikea e BAKOVI DAGI, a Vure na matakari nau e Abraham, a vuhuna i vakasiri iau vona a dala kamumu, a bolea vona a ngatavine na kabu na matakari nau, ge girihine tuna. ");
INSERT INTO bnp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ioe ngane o vakasiri a naro kamumu, a naro kiripiripi na matakari nau. O taki iau ngane. Ge uka o taki iau, bara ramaia a dala tara.” ");
INSERT INTO bnp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Muri e Leban rua e Betuel ru koli mulea, ru ta maea, “E BAKOVI DAGI i vakasiria ra naro iea. Maria i uka ma miri gi takia tara ngava. ");
INSERT INTO bnp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","E Rebeka, ia koea. O tulia, o vano turana, ge parangi e tune bakovi dagi vomu, ge muri maia a ngavane BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Na tahuna a vora i longo a hini ru taki, i lolu puru na malala, i kavurikea e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Muri i bole tala a maka gogo ni rata na silva, a gol, a maka varakia mata legelege, i habi ne Rebeka. I bole a mahala ranga i habi ne kurabana, rua e kinana. ");
INSERT INTO bnp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","I habi pali a maki, lakea a vora turana e huriki a bakovi ri havai turana ri kani, ri ninu, ri mahita vonga. Na hatelanga a vora i hadongo, i ta maea, “Iau ga hamule lakea na matakari nau.” ");
INSERT INTO bnp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pali e kurabana e kinana ru koli ru ta maea, “I uka, a ngatavine ge made taro turane mia na parava ge ravulu, muri ge vano.” ");
INSERT INTO bnp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Lakea a vora i taki rua, “Naha ni vakapae iau, e BAKOVI DAGI i habi a mulangia pali, na nihavai nau. Iau ga vano, ga hamule lakea na matakari nau.” ");
INSERT INTO bnp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Muri ru ta maea, “Te ge galea a ngatavine, te ge nanea.” ");
INSERT INTO bnp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Lakea ru galea e Rebeka, ru nanea, “Ioe go vano turana a bakovi iea?” I koli mule, i ta maea, “Ga vano”. ");
INSERT INTO bnp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Lakea ru talo e Rebeka turana a vora ngatavine vona, ru vano turana a vora ne Abraham, turana e huriki a bakovi vona. ");
INSERT INTO bnp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ru gamaia e Rebeka, ru takia, “Rebeka, bara ioe e kinane huriki ala kupo. E huriki a hamomu bara ri puka ri bole a maka tanga dagi ne huriki a pile ne ria.” ");
INSERT INTO bnp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Muri e Rebeka rua a vora ngatavine vona, ru rike na kamel, ru vano turana a vora ne Abraham turana e huriki a bakovi vona. Ngane a vora i tulia e Rebeka ru vano. ");
INSERT INTO bnp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","E Isak i pea pali a tabeke ne Bia Lahai Roi, ngane i made na robo e Negev. ");
INSERT INTO bnp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Na malunga i laho na hania. I mata rike, i matai a kamel ri laho valai. ");
INSERT INTO bnp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","E Rebeka tara i mata muga, i masia e Isak. I raga na kamel, ");
INSERT INTO bnp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","i nanea a vora, “E rei ra bakovi na hania i laho valai, ge tagui hita?” A vora i koli mule, i ta maea, “A bakovi dagi nau.” Lakea e Rebeka i bolea a hineva, i kavitagua a matana. ");
INSERT INTO bnp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Lakea a vora i taki e Isak vona a maki lobo i rata. ");
INSERT INTO bnp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Muri e Isak i bolea e Rebeka, i lakea na kape ne kinana, i parangi vona. E Isak i ngarua e girihina, i kamumu ngane a niluhoi vona, i uka ma i luhoi tabua e kinana i mate. ");
INSERT INTO bnp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","E Abraham i bole tabua tara e girihina, a rana e Ketura. ");
INSERT INTO bnp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ra ngatavine iea i poda e Simran, e Ioksan, e Medan, e Midian, e Isbak, e Sua. ");
INSERT INTO bnp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","E Ioksan e tamane Seba rua Dedan. E huriki a Asuri, a Letusi, a Leumi ria a hamone Dedan. ");
INSERT INTO bnp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","E huriki a bakovi e tune Midian a rane ria ra nga: e Epa, e Eper, e Hanok, e Abida, e Elda. Re huriki nga ria a hamone Ketura. ");
INSERT INTO bnp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","E Abraham i pe mule ne Isak a mahala lobo vona. ");
INSERT INTO bnp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Pali na tahuna i tabana ni mahuri, i habi ranga mahala ne huriki e tuna bakovi, i poda e huriki e girihina ranga. Lakea i rudu ria ri gi made na robo na nirikena haro, basi ne tuna, e Isak. ");
INSERT INTO bnp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","E Abraham I tahoka a pida i 175, ");
INSERT INTO bnp_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","i gare liu, i matai a maka pida i kamumu i kupo. Muri i taravango dilia a nilobona bangona, i mate. Ni bole, i made turana e huriki a viri vona ri mate pali. ");
INSERT INTO bnp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","E Isak rua e Ismael ru tanua e tamane rua na babe o Makpela, tabukoi o Mamare na malala e Epron, e tune Sohar, ra kabune Hiti. ");
INSERT INTO bnp_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ra malala iea e Abraham i konea ne huriki a kabu ne Hiti. E Abraham ni tanu vonga turana e girihina, e Sara. ");
INSERT INTO bnp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Muri ne Abraham i mate, a Vure i gamaia e Isak. Muri e Isak i vano i made tabukoi o Bia Lahai Roi. ");
INSERT INTO bnp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","A nita ne Ismael, e tune Abraham, i podea e Hagar, a ngatavine o Egipto ra vora ngatavine ne Sara. ");
INSERT INTO bnp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","A rane huriki e tune Ismael i ramai a nipodane ria. A tabua ne Ismael e Nebaiot. Muri ni poda e Kedar, e Adbil, e Mibsam, ");
INSERT INTO bnp_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","e Misma, e Duma, e Masa, ");
INSERT INTO bnp_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","e Hadad, e Tema, e Ietur, e Napis, e Kedema. ");
INSERT INTO bnp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Re huriki a bakovi nga ria e tune Ismael, ra vuhuna a kabu i ravulu a polona i rua. A tanga, a robo ri rata a mada vona ni gale virihi mai ria vona. ");
INSERT INTO bnp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","E Ismael i tahoka a pida i 137, muri i taravango dilia a nilobona bangona, i mate. Ni bole i made turana a viri vona ri mate pali. ");
INSERT INTO bnp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","E huriki a hamona ri made vona a robo i vakatubu o Havila i lakea o Sur, i tabukoi na harena e Egipto na dala lakea o Asiria. Re huriki a kabu nga, i uka ma ri vamade kamumu. Ri vatepu. ");
INSERT INTO bnp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iea a nitane Isak, e tune Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","E Isak i tahoka a pida i ravulu va i parangi vona e Rebeka, e tune Betuel. E Betuel ia a hamona kabune Aram, i made na robo e Padan-Aram re Mesapotamia. E Rebeka e kurabane Leban, ia tara a hamone Aram. ");
INSERT INTO bnp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","E girihine Isak i lame, lakea e Isak i vasileki ne BAKOVI DAGI, ge tuhoria e girihina. E BAKOVI DAGI i longototoa a nivasileki vona, i singou e Rebeka. ");
INSERT INTO bnp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Na palona i tahoka a koma i rua, ru varata tuhare bala pololilo, lakea e Rebeka i ta maea, “I navai i bele maea nau a hini?” Pali i vano i vasileki ge nana e BAKOVI DAGI vona a naro iea. ");
INSERT INTO bnp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Muri e BAKOVI DAGI i takia, “A boge pololilo na palomu ru gu vakabele a kabu ge rua. Ra kabu i rua nga bara ru vapida. A kabu tara bara i tora hateka vona a kabu tara, a tabua bara ia a vora ne tarina.” ");
INSERT INTO bnp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","I valai ngane a parava vona na ni poda, lakea i poda a boge bakovi ala rua. ");
INSERT INTO bnp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","A tabua i vururu a kulina, a kakaina i vona lobo a vungana, lakea ni vunu e Esau. ");
INSERT INTO bnp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Na tahuna ni poda e tarina i tangotatea a vahane Esau, lakea ni gale e Iakop. E Isak i tahoka a pida i ravulu polotara ni poda ra boge nga. ");
INSERT INTO bnp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Na tahuna ru dagi pali, e Esau ia a bakovi ni laho na robo, i moro na pinango. Pali e Iakop i madoru, i made kunana na kape. ");
INSERT INTO bnp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","E Isak i ngarua e Esau, a vuhuna i bole bala a kania, i kani. E Rebeka i ngarua e Iakop. ");
INSERT INTO bnp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Na parava tara, e Esau i hamule na pinango, i vitolo hateka. I masia e Iakop i nono a kania vona, ");
INSERT INTO bnp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","lakea i takia e Iakop, “A vitolo iau. O malaviriri kunana o habi nau ranga kania vururu vomu ga kani.” Na naro iea kunana ni gale visi vona e Idom. ");
INSERT INTO bnp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","E Iakop i koli mule i ta maea, “Tu gu vangoli taro a murine tarua. O taki iau ge iau a tabua.” ");
INSERT INTO bnp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Lakea e Esau i ta maea, “O longo valai, iau a mate na vitoloa, ra murigu a tabua, a ra i kamumu vona?” ");
INSERT INTO bnp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","E Iakop i ta maea, “O kaba taro, o taki iau ge iau a tabua.” Lakea e Esau i ta muholi vona, ru vangoli a murine rua. ");
INSERT INTO bnp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Muri e Iakop i habi ne Esau ranga bret turana a naruna bin, lakea i kani i ninu. Muri i pesi rike i vano. Na naro iea kunana, e Esau i lohopile vona a murina, ia a tabua. ");
INSERT INTO bnp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ngane a pago i bele na robo e Kenan i manga a hini muga na tahuna ne Abraham. E Isak i vano, i lakea ne Abimelek, a hariki ne huriki a Palestina, na tanga e Gerar. ");
INSERT INTO bnp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Na parava tara, e BAKOVI DAGI i bele ne Isak, i ta maea, “Naha ni puru o Egipto, o made vona a malala ga vakasiri ioe vona. ");
INSERT INTO bnp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","O made popote vona a malala iea. Iau ga made turamu, ga gamai ioe. Ra malala iea ga habia vomu turane huriki a hamomu, bara vakatorea ra nita dagi a ta muholi vona ne tamamu, e Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ga rata e huriki a hamomu ri gi kupo manga a hada na hunu. Ga habia ne ria a robo iea. Na hamomu kunana, ga gamai e huriki lobo na malala, ");
INSERT INTO bnp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","a vuhuna e Abraham i ramai tora a nitagu a vinara nau.” ");
INSERT INTO bnp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Lakea e Isak i made vonga na tanga e Gerar. ");
INSERT INTO bnp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","E huriki na tanga ri nanea vona e girihina, lakea e Isak i ta maea, “Ia e kurabagu.” I koi ni taki ria vona e Rebeka ge girihina, a vuhuna i mangenge. I luhoi maea, “E huriki a bakovi na tanga bara ri rabalaki iau, ri bolea e Rebeka, a vuhuna i mata kamumu hateka.” ");
INSERT INTO bnp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ngane e Isak i made tabaka pali na tanga iea. Na parava tara, e Abimelek, a hariki ne huriki a Palestina, i mata tala na mataruma, i masia e Isak i kakoa e girihina, e Rebeka. ");
INSERT INTO bnp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Lakea, e Abimelek i galea e Isak, i nanea, “Ra ngatavine iea, e girihimu! I navai o takia ta ia e kurabamu?” Lakea e Isak i koli mulea, i ta maea, “A vuhuna a luhoi maea, bara takia e girihigu, e huriki a bakovi bara ri rabalaki iau, ri bolea e Rebeka.” ");
INSERT INTO bnp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Muri e Abimelek i ta maea, “A ra o ratea ne mia? A bakovi tara bara i mahita turane girihimu, bara mi tahoka a ngava!” ");
INSERT INTO bnp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Lakea, e Abimelek i vara e huriki a tahotanga, i ta maea, “E rei a viri i rata hale a bakovi iea turane girihina, bara ni rabalaki.” ");
INSERT INTO bnp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","E Isak i rata a hania, i varo a maki ni kani vona a robo iea. Na pida iea kunana i vona hateka a maki ni kani a hania, a vuhuna e BAKOVI DAGI i gamaia. ");
INSERT INTO bnp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","E Isak i tahoka a mahala i kupo. A mahala vona i bele kupo, i rata ia a viri na mahala. ");
INSERT INTO bnp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","E Isak i tahoka a maka kabuna sipsip, a kabuna bulmakau, a vora ni leho, i rata ngane e huriki a Palestina ri masigoro na mahala vona. ");
INSERT INTO bnp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Lakea e huriki a Palestina ri bole a malala, ri kavitagu a lovo na naru e huriki a vora ne tamana, e Abraham, ri keli hosi. ");
INSERT INTO bnp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Muri, e Abimelek i takia e Isak, “O pe mia, o vano, a vuhuna o tuhaka hateka ne mia.” ");
INSERT INTO bnp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Lakea e Isak i pe a hini nga i vano i made na maloku ne Gerar. ");
INSERT INTO bnp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","I keli tabu a maka lomu, ra ri kavitagu e huriki a Palestina na tahuna e Abraham i mate. Lakea i gale tabu ria vona a rane ria, i vunu ria vona e Abraham. ");
INSERT INTO bnp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","E huriki a vora ne Isak ri keli lae na maloku, ri matavisia a narubele. ");
INSERT INTO bnp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lakea e huriki a vora na ni matakari a sipsip o Gerar, ri tahate e huriki a vora na ni matakari a sipsip ne Isak, ri ta maea, “Ra lomu iea ne mia.” Lakea e Isak i vunua a lomu iea e Esek a vuhuna ri vagege turana. ");
INSERT INTO bnp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Muri ri kelia a lomu tara, pali ri vatahate tabu maia, lakea i vunua e Sitna. ");
INSERT INTO bnp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","I pe a hini ngi, i lakea i keli tabua a lomu tara, pali i uka viri ge tahate vona. I vunua e Rehobot, lakea i ta maea, “Ngane e BAKOVI DAGI i habia ne hita a tabeke iea bara si leho vona, si tahoka a maki kupogala.” ");
INSERT INTO bnp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Muri, i pe a hini nga, i lakea o Bersiba. ");
INSERT INTO bnp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Na rodo tara e BAKOVI DAGI i bele vona, i takia, “Iau a Vure ne tamamu e Abraham. Naha ni mangenge. Iau a made turamu. Iau ga gamai ioe, ga vakabele kupo e huriki a hamomu, a vuhuna e Abraham ia a vora nau.” ");
INSERT INTO bnp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","E Isak i haea vonga a dede-kedo i kavurikea a rane BAKOVI DAGI. Muri i vakapesia vonga a kape vona, lakea e huriki a vora vona ri kelia a naru. ");
INSERT INTO bnp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","E Abimelek i pea a tanga e Gerar, i valai mai e Isak turana e Ahusat, ra bakovi ni habi a niluhoi vona, e Pikol, ra ubu na tara na vabinga vona. ");
INSERT INTO bnp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Lakea e Isak i nana tou, “I navai moto valai nau? I uka ma i hosi hateka moto tahate iau, moto tono tala iau.” ");
INSERT INTO bnp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Lakea to takia, “Mete matakilaka vona e BAKOVI DAGI i turamu, lakea mete ngaru si gi valongo mai a ngava. A ngava ge maea, ");
INSERT INTO bnp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","‘Ioe i uka ma go rata hale mateu. I manga mateu hosi, i uka ma mete rata hale ioe. Mete rata kamumu ioe, muri mete rudu ioe o vano na ni valemu. Ra ngane e BAKOVI DAGI i gamai ioe.’” ");
INSERT INTO bnp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","E Isak i ratea a habu ne tou, to kani, to ninu. ");
INSERT INTO bnp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Na hatelanga pokopoko to kaba takutaku vona a nita muholi. Muri to tarulu purua e Isak, to vano. ");
INSERT INTO bnp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Na parava iea kunana, e huriki a vora ne Isak ri valai ri vakalongoa vona a naru ri kelia pali. Ri ta maea, “Mi matavisia a naru!” ");
INSERT INTO bnp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Lakea i vunua e Siba. Mona ni gale liu a tanga iea e Bersiba. ");
INSERT INTO bnp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","E Esau i tahoka a pida i ravulu va, i parangi vona e Iudit, e tune Biri, a kabu ne Hiti. E girihina tara, e Basemat, e tune Elon, ia tara a kabu ne Hiti. ");
INSERT INTO bnp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ngane e Isak e Rebeka ru loho lege lae vona e tune rua i parangi na ngatavine o Hiti. ");
INSERT INTO bnp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","E Isak i gare ngane, i kepa a matana, i uka ma i matai kamumu a maka maki. Lakea i galea e Esau, e tuna a tabua, i ta maea, “O tugu.” E Esau i koli mule i ta maea, “Iau ieni.” ");
INSERT INTO bnp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Lakea e Isak i ta maea, “Iau a gare ngane, a popote ga mate. ");
INSERT INTO bnp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ngane o bolea a kiniperi, turana a maheto vomu, o lakea na robo, o pango, o padia tara kania ge ne nau. ");
INSERT INTO bnp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Muri o nonoa tara maki ni kani ra a ngarua, i nami kamumu hateka, o bole vilia nau ga kania. Muri ga gamai ioe, ga dava a nimate iau.” ");
INSERT INTO bnp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","E Rebeka i longo panahoa e Isak i takikia e tuna, e Esau. Na tahuna e Esau i vano pali ge pango kana a kania, ");
INSERT INTO bnp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","lakea e Rebeka i takia e tuna, e Iakop, i ta maea, “O longo valai. Iau a longo panahoa e tamamu i takia e tukamu, e Esau, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘O pango kanea tara kania, o rata ranga maki ni kani ge nami kamumu ga kani. Muri ga gamai ioe na matane BAKOVI DAGI, ga dava a nimategu.’ ");
INSERT INTO bnp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ngane, o tugu, o longo valai, o rata a maki ga taki ioe vona. ");
INSERT INTO bnp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","O lakea mai a kabuna meme, o rabalaki a tuna meme ge rua, ge gavutuvutu. O bole valai nau ga ratea tara maki ni kani, ra i namika, ge manga a hini i ngaru e tamamu. ");
INSERT INTO bnp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Muri o bole lakea vona, ge kani, ge gamai ioe, ge dava a ni mate ia.” ");
INSERT INTO bnp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Lakea e Iakop i takia e kinana, e Rebeka, “E tukagu i kuli vungaka, pali iau a kuli rularula. ");
INSERT INTO bnp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pali e tata ge nugu kilaka iau, ga ta navai? I mata manga iau a tamia e tata, lakea bara i ruduraha iau, i uka ma ge gamai iau.” ");
INSERT INTO bnp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Lakea e kinana i takia, “O tugu, a niruduraha bara i valai nau. O rata a hini a taki. O vano o bole valai ra maki a taki ioe vona.” ");
INSERT INTO bnp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Lakea i vano i rabalaki a meme kiroko i rua, i bole lakea ne kinana, i rata a maki ni kani i namika, i manga a hini i ngaru e tamana. ");
INSERT INTO bnp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Muri e Rebeka i bolea a padirodo kamumu ne Esau i tabuli na ruma, i vakarodo e Iakop vona. ");
INSERT INTO bnp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Muri i bole tabua a kulina meme, i kavitagu vona a limana a lohone Iakop, a vuhuna i rularula. ");
INSERT INTO bnp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Lakea i bole a maki ni kani i namika turana a bret i rata, i habi ne Iakop. ");
INSERT INTO bnp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","I bole lakea ne tamana i gale, “Tata.” Lakea e Isak i koli mulea, “Iau ieni. Ioe e rei ke?” ");
INSERT INTO bnp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Lakea e Iakop i tamia e tamana, i ta maea, “Iau e Esau, e tumu a tabua. A rata pali a maki o taki iau vona. O made kamumu o kani a kania vomu, muri o gamai iau.” ");
INSERT INTO bnp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","E Isak i nanea e tuna, “Ioe o mulangi, o hamule malaviriri polo?” Lakea e Iakop i ta maea, “E BAKOVI DAGI a Vure vomu i habi a mulangia nau.” ");
INSERT INTO bnp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Lakea e Isak i takia e Iakop, “O karuku valai tabukoi, ga nugua a kulimu, ioe muholi e tugu e Esau, o i uka?” ");
INSERT INTO bnp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Lakea e Iakop i karuku tabukoi lokovonga ne tamana, lakea e Isak i bakaia, i ta maea, “A nitamu i manga e Iakop, a limamu i manga e Esau.” ");
INSERT INTO bnp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Pali e Isak i uka ma i matakilalea e Iakop, a vuhuna i kuli vungaka manga e tukana e Esau, lakea i gamaia. ");
INSERT INTO bnp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Muri i nanea, “Ra ioe, ioe muholi e tugu e Esau?” E Iakop i koli mule, i ta maea, “Iau kunana.” ");
INSERT INTO bnp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Lakea e Isak i ta maea, “O tugu, o habi nau ranga kania vomu ga kani, muri ga gamai ioe.” Lakea e Iakop i bole lokovonga vona a maki ni kani, i kani. A vain ranga i bole lokovonga vona i ninu. ");
INSERT INTO bnp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Lakea e tamana i takia, “Tugu, o valai, o nguru iau.” ");
INSERT INTO bnp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Lakea e Iakop i lokovonga i ngurua e tamana, lakea e tamana i burongia a mangina a varakia vona, i gamaia, i ta maea, “A mangine tugu i mangi manga a hania i gamaia e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","A Vure bara i vakaborua na hunu a simuru i vakamea a hania vomu, i rike kamumu vona a vit, a vain. ");
INSERT INTO bnp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","E huriki e turamu mai bara ria a vora vomu. A maka tanga lobo bara ri polotano vomu. Bara ioe a bakovi dagi ne huriki e turamu. E rei i ruduraha ioe, a Vure bara i ruduraha ia. E rei i gamai ioe, a Vure bara i gamai ria.” ");
INSERT INTO bnp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","E Isak i gamai loboa e Iakop, muri e Iakop i pesi rike, i vano. I uka ma i pea ma a tabeke ne tamana, i bele na pinango e tukana, e Esau. ");
INSERT INTO bnp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ia tara i rata a maki ni kani i nami kamumu, i bole lakea ne tamana. Lakea i takia, “O tata, o made kamumu. O kani a kania nga, muri o gamai iau.” ");
INSERT INTO bnp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Lakea e tamana e Isak i nanea, “Ioe e rei ke?” E Esau i ta maea, “Iau e Esau, e tumu a tabua.” ");
INSERT INTO bnp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","E Isak i turutu i vakulu a tagana, lakea i nanea, “E rei a viri i pango muga, i bole valai pali a kania? A kani pali, a gamaia, o valai muri ke. I muholi, ra bakovi iea a gamaia pali!” ");
INSERT INTO bnp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Na tahuna e Esau i longoa a ngava i taki e tamana, i upu tala a nangi, i tangi. Lakea i takia e tamana, “Tata, o gamai iau, iau tara!” ");
INSERT INTO bnp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Lakea e tamana i takia, “E tarimu i valai i tami iau, a gamaia. I bolea pali a maki kamumu.” ");
INSERT INTO bnp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","E Esau i ta maea, “Ni gale lato vona a rana e Iakop. Ngane i balaka rua a hini i kau a maki nau. I muga i ngaru ge ia a tabua, a longo maia. Pali ngane i tamia e tata, i gamaia!” Muri i nanea, “Ioe o tahoka ranga maki kamumu o ru mule, go gamai iau vona?” ");
INSERT INTO bnp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Pali e Isak i koli mulea, i ta maea, “Iau a rua pali ge ia a bakovi dagi vomu. E turana mai bara ria a vora vona. Bara i tahoka a vit a vain i kupo. Pali o tugu, ga rata navai ioe?” ");
INSERT INTO bnp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Lakea e Esau i takia e tamana, “Tata, ioe o tahoka tara maki kamumu i tabana? Tata, iau tara o gamai iau.” Muri i upu tala tabu a nangi, i tangi. ");
INSERT INTO bnp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Lakea e tamana i takia, “A tanga vomu bara i pesi basi na robo i vole vona a maki, basi na robo i boru langa vona a simuru na rodo. ");
INSERT INTO bnp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Bara o made kunana na vabinga na bainat, bara ioe a vora ne tarimu. Muri bara o longotaroa, i uka ma ge matakari ioe tabu.” ");
INSERT INTO bnp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","E Esau i tahoka a rongova ne Iakop, a vuhuna e Isak i gamaia e Iakop. Lakea Esau i ta maea, “E tata i popote bara i mate. Ia ge mate, bara si taringi taroa, muri bara rabalakia e Iakop.” ");
INSERT INTO bnp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ni vakalongo e Rebeka vona a ngava i takia e Esau, lakea i rudu a ngava ne Iakop, ge valai vona, i takia, “E tukamu e Esau i luhoi na ni rabalaki ioe. ");
INSERT INTO bnp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tugu, ngane o longo mai a hini ga taki. O ha lakea ne hamu e Leban na tanga e Haran. ");
INSERT INTO bnp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","O made turana popote, ge lobo taro a rongova vona e tukamu, ");
INSERT INTO bnp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ge longokaburungia a hini o rata virihia vona. Muri ga talo rike a ngava vomu, o hamule valai. I navai a hini muru gu velu varago nau na parava i taku?” ");
INSERT INTO bnp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Muri e Rebeka i takia e Isak, “Iau i koi a kuligu pali vona ra ngatavine ne Hiti ala rua nga. E Iakop bara i bole e girihina na robo koea, na kabu ne Hiti, i manga ra ngatavine nga, iau a koi ni made koea. Ge rata iau a maki tara ga mate.” ");
INSERT INTO bnp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Lakea e Isak i galea e Iakop, i gamaia, i vakukua, “Naha ni parangi na ngatavine o Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","O lakea malaviriri o Padan-Aram na robo e Mesapotamia, na tabeke e tamane kinamu, e Betuel. O bole talea vonga ne hamu e Leban, tara e tuna a ngatavine, ge girihimu. ");
INSERT INTO bnp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","A Vure Tuhaka ge gamai ioe, go vakabele, go vakakupo e huriki a hamomu. ");
INSERT INTO bnp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","E Bakovi Dagi ge gamai ioe turana e huriki a hamomu, i manga a hini i gamaia e Abraham hosi. Muri bara o bolea a malala, ra o made manga mosi vona ngane, ra malala a Vure i habia ne Abraham.” ");
INSERT INTO bnp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Lakea e Isak i rudua e Iakop i vano i lakea o Padan-Aram ne hana e Leban, e tune Betuel, ra hamone Aram. E Leban e kurabane Rebeka. E Rebeka e kinane Iakop rua e Esau. ");
INSERT INTO bnp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","E Esau i lohoka vona ngane e Isak i gamaia e Iakop, muri i rudua i lakea o Padan-Aram ge bolea vonga e girihina. Na tahuna i gamaia i vakukua nahea ge parangi a ngatavine o Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","E Iakop i longototo e tamana e kinana, i vano i lakea o Padan-Aram. ");
INSERT INTO bnp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Pali e Esau i lohoka vona ngane e tamana i uka ma i ngaru a ngatavine o Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Lakea, i vano i parangi vona e Mahalat, e tune Ismael e kurabane Nebaiot. ");
INSERT INTO bnp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","E Iakop i malaga o Bersiba, ge lakea o Haran. ");
INSERT INTO bnp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I bele vona a tabeke tara, i mahita, a vuhuna i rolo a haro. I bolea tara kedo i ru polotano na gina, i kaloho langa vona, i mahita. ");
INSERT INTO bnp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Na tahuna i mahita i vurena, i masia a nirike ni vakapesi na malala, i padoia a hunu, lakea e huriki a agelo na Vure ri puru rike vona. ");
INSERT INTO bnp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","E BAKOVI DAGI i pesi polo meli vona, i ta maea, “Iau e BAKOVI DAGI, a Vure ne tubumu e Abraham, e tamamu e Isak, ga habia vomu, ne huriki a hamomu a malala o mahita vona. ");
INSERT INTO bnp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","E huriki a hamomu bara ri ala kupo manga a habulo na malala. Bara mu made vona a hini i vakatubu na nirolona haro, i lakea mai a nirikena haro, a hini i sike lakea i puru lakea. E huriki a viri lobo na malala ga gamai ria, a vuhuna iau a gamai e huriki a hamomu. ");
INSERT INTO bnp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Iau ga laho turamu, ga matakari ioe na hini o lakea vona. Muri ga bole mule valai ioe koea na malala iea. I uka ma ga pe ioe ngane, bara rata taro a maka maki a taki ioe vona.” ");
INSERT INTO bnp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","E Iakop i hadongo, i luhoi maea, “Muholi, e BAKOVI DAGI i made vona a hini nga, pali iau i uka ma a lohoka vona.” ");
INSERT INTO bnp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I mangenge, i ta maea, “Iau a mangenge hateka vona a tabeke iea, a vuhuna ra tabeke iea a roho na Vure, a dili dala na hunu.” ");
INSERT INTO bnp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Na hatelanga pokopoko na parava muri, e Iakop i bolea a kedo, ra i kaloho langa vona, i toto pesia ga kilakila. Muri i bolea a nibiri, i guru langea vona. ");
INSERT INTO bnp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Lakea i vunua a tanga iea e Betel. Ra tanga dagi iea, ni gale muga e Lus. ");
INSERT INTO bnp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Muri, e Iakop i ratea tara nita dagi, i ta maea, “A Vure bara i laho turagu, ge matakari iau na ni lahogu iea, ge habi a maki ni kani ga kani, a varakia ga rodo, ");
INSERT INTO bnp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","muri ge bole mule iau na tabeke ne tata na nivalemu, e BAKOVI DAGI bara ia a Vure nau. ");
INSERT INTO bnp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ra kedo iea a vakapesia i manga a kilakila ge vakasiri a hini nga ga hae a roho vomu vona. A maki i ravulu o habi nau bara habi mulea vomu a tabekena i taku.” ");
INSERT INTO bnp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Muri e Iakop i laho liu i bele na robo ne huriki na nirikena haro. ");
INSERT INTO bnp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Na tahuna i bele, i matai a kabuna sipsip i tolu, ri mahita tabukoi na lomu, a vuhuna a lomu iea, a naru ne ria. A lomu ni kavitagu na kedo dagi. ");
INSERT INTO bnp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Na tahuna a maka kabuna sipsip ri bele palupu ni ninu, e huriki a vora ni matakari a sipsip bara ri kule talea a kedo dagi i kavitagu a lomu ri ninu a maka sipsip, muri ri kavitagu tabua. ");
INSERT INTO bnp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","E Iakop i nana e huriki a matakari na sipsip, “Turagu mai, mua a viri vai?” Ri koli mule ri ta maea, “Mia a bakovi o Haran.” ");
INSERT INTO bnp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Lake i nana tabu, “E Leban, e tubune Nahor, mu lohoka vona o i uka?” Ri koli mule, ri ta maea, “Mi lohoka vona.” ");
INSERT INTO bnp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Muri i nana tabu, “Pali i kamumu, o i uka?” Ri koli mule, ri ta maea, “I kamumu kunana. Mata lakea, e Resel, e tuna a ngatavine i valai turana a kabu na sipsip vona.” ");
INSERT INTO bnp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Lakea e Iakop i ta maea, “Pali mua? A haro i tabana, pali i navai mu malaviriri hateka mu gale palupu a kabu na sipsip? Mu vakaninu, mu bole hamule ria, ri gi kani a varili.” ");
INSERT INTO bnp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ri koli mule, ri ta maea, “I uka ma mi gi rata mavonga. A kabuna sipsip bara ri bele palupu taro, muri bara mi kule talea a kedo ni tukari a lomu vona, mi vakaninu ria.” ");
INSERT INTO bnp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","E Iakop i tabana na ni ta turane huriki a matakari na sipsip, i bele e Resel turana a kabu na sipsip ne tamana, a vuhuna ia tara a matakari na sipsip. ");
INSERT INTO bnp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Na tahuna i masia e Resel, e tune hana, e Leban, i valai turana a kabuna sipsip vona, i vano i kule talea a kedo na matana lomu, i vakaninu a maka sipsip ne hana. ");
INSERT INTO bnp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Lakea e Iakop i ngurua e Resel, i vakatubu ni tangi. ");
INSERT INTO bnp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","I vakalongoa e Resel ia e tune Rebeka, e kurabane tamana. Lakea e Resel i nunu lakea na tanga, i vakalongoa e tamana. ");
INSERT INTO bnp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Na tahuna e Leban i longoa a velenga ne Iakop, e tune kurabana, i bele, i laho malaviriri kunana, ge tagui ia. Lakea i rakoa, i ngurua, i tuli lakea na ruma. I tuverei ne hana na maki i bele vona. ");
INSERT INTO bnp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lakea e Leban i takia e Iakop, “Muholi, ioe a daragu.” E Iakop i made turane Leban na keva i taku, ");
INSERT INTO bnp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","lakea e Leban i takia, “Ioe e tune kurabagu muholi. Pali a koi ioe go leho tavula. O taki iau, ge riva a mapana leho vomu?” ");
INSERT INTO bnp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","E Leban i tahoka e tuna ngatavine ala rua. A tabua e Lea, e tarina e Resel. ");
INSERT INTO bnp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","E Lea, a matana i havuhavu, pali e Resel, i labeka, i mata kamumu. ");
INSERT INTO bnp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","E Iakop i ngarua e Resel, lakea i takia e Leban, “Ga leho taro vomu na pida ge polorua, muri ga parangi vona e Resel, e tumu kiroko.” ");
INSERT INTO bnp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lakea e Leban i ta maea, “I kamumu bara o bolea, ma ge nabirei vona a viri na kabu tara. Ngane o made turagu.” ");
INSERT INTO bnp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Lakea e Iakop i leho na pida i polorua, ge bolea e Resel, pali ra pida nga, i manga a parava popote kunana, a vuhuna i ngaru hatekea e Resel. ");
INSERT INTO bnp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Muri e Iakop i takia e Leban, “O habia nau ngane e tumu, ga parangi vona. A vakalobo pali a pida o taki ga leho vona.” ");
INSERT INTO bnp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lakea e Leban i gale palupu e huriki na tanga, i ratea a habu. ");
INSERT INTO bnp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","I rodo a hini, i bolea e Lea, i habia ne Iakop, i mahita turana. ");
INSERT INTO bnp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","E Leban i habia ne Lea a vorakato ngatavine, a rana e Silpa, ge a vora vona. ");
INSERT INTO bnp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Na hatelanga, i turutu vona e Lea i mahita turana. Lakea e Iakop i takia e Leban, “Ioe o rata navai iau? Iau a leho vomu ta ga parangi vona e Resel. I navai a hini o tami iau?” ");
INSERT INTO bnp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lakea e Leban i koli mulea, “I uka ma a rabune mia koea a ngatavine i muri ge parangi languia a viri i muga. ");
INSERT INTO bnp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Pali ngane, o vakalobo taroa a parava na habu ge polorua ne marua e Lea muru parangi. Muri ga habi tabua vomu e tarina. Pali ioe bara o leho tabu na pida i polorua.” ");
INSERT INTO bnp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","E Iakop i longo vona a ngava iea. Muri i lobo a parava i polorua na habu, lakea e Leban i habi tabua vona e tuna e Resel, ge girihina. ");
INSERT INTO bnp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","E Bila, a vorakato ngatavine, i habi tabua ne Resel ge ia a vora vona. ");
INSERT INTO bnp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","E Iakop i mahita turane Resel, a vuhuna i ngaru hatekea ne Lea. Muri i leho tabu ne Leban na pida i polorua. ");
INSERT INTO bnp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","E BAKOVI DAGI i masia e Lea, i uka ma i ngaru hatekea e Iakop, lakea i tuhoria i tahoka a koma, pali e Resel i lame. ");
INSERT INTO bnp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","E Lea i singou. Muri i podea a koma bakovi, i vunua e Reuben. Lakea i ta maea, “E BAKOVI DAGI i masia pali a nimadihi nau. Pali ngane e girihigu bara i ngaru iau.” ");
INSERT INTO bnp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Muri e Lea i singou tabu. Na tahuna i poda tabua tara koma bakovi, i ta maea, “E BAKOVI DAGI i longo e Iakop i uka ma i ngaru iau, lakea i habi tabua nau a koma bakovi.” Lakea i vunua e Simion. ");
INSERT INTO bnp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Muri e Lea i singou tabu. Na tahuna i poda a koma bakovi tabu i ta maea, “Ngane e girihigu bara i madoko nau, a vuhuna a poda vona pali a koma bakovi ala tolu.” Lakea i vunua e Levi. ");
INSERT INTO bnp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","E Lea i singou tabu. Na tahuna i poda tabua tara koma bakovi, i ta maea, “Ngane bara kavurikea a rane BAKOVI DAGI.” Lakea i vunua e Iuda. Muri i lobo ni singou. ");
INSERT INTO bnp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Na tahuna e Resel i masia i uka ma i poda ne Iakop ranga koma, i madihi a hatena vona e tukana. Lakea i takia e Iakop, “O habi a koma nau. Ge uka, bara mate.” ");
INSERT INTO bnp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","E Iakop, i madihi a hatena, lakea i takia, “Iau i uka ma iau a Vure a rata ioe o lame.” ");
INSERT INTO bnp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Muri e Resel i ta maea, “O bolea e Bila, a vora ngatavine nau. O mahita turana ge poda ranga koma ga pau.” ");
INSERT INTO bnp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Lakea e Resel i habia ne Iakop e Bila ge girihina. Lakea e Iakop i mahita turana, ");
INSERT INTO bnp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","i singou, i podea a koma bakovi. ");
INSERT INTO bnp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ngane e Resel i ta maea, “A Vure i matakilaka nau, i longo a nigale nau, i habia nau a koma bakovi.” Na naro iea kunana, i vunua e Dan. ");
INSERT INTO bnp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","A vora ne Resel, e Bila, i singou tabu i podea a koma bakovi. Ngane i rua e tune Iakop i poda. ");
INSERT INTO bnp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Lakea e Resel i ta maea, “A vaubi bala ne tukagu, ngane a bolea pali.” Lakea i vunua e Naptali. ");
INSERT INTO bnp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","E Lea i masia i uka ma i poda tabu, lakea i bolea a vorakato ngatavine vona, i habia e Iakop ge girihina. ");
INSERT INTO bnp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ra vora ne Lea, e Silpa, i podea ne Iakop a koma bakovi. ");
INSERT INTO bnp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lakea e Lea i ta maea, “A nabirei vona!” Lakea i vunua e Gad. ");
INSERT INTO bnp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","E Silpa, a vorakato e Lea, i poda tabu. Ngane i rua e tune Iakop i poda. ");
INSERT INTO bnp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lakea e Lea i ta maea, “A vivi hateka. Ngane e huriki a ngatavine bara ri gale iau ‘a ngatavine ni vivi.’” Lakea i vunua e Aser. ");
INSERT INTO bnp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Na tahuna ni mirio a vit, e Reuben i lakea na hania, i matavisi ranga vuana kai manginoro. I bole lakea ne kinana, e Lea. Muri e Resel i nongi e Lea, “Iau a masia e tumu i habi vomu ranga vuana kai manginoro, o habi nau ranga.” ");
INSERT INTO bnp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Pali e Lea i marikoi, i ta maea, “Ioe o rata marogoa pali e girihigu. Pali ngane o ngaru ni bole tabu ranga vuana kai manginoro ne tugu?” Lakea e Resel i ta maea, “Kamumu hateka, ioe bara o habi nau ranga vuana kai manginoro, o mahita turana barama na rodo e Iakop.” ");
INSERT INTO bnp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Na malunga e Iakop i hamule na hania, lakea e Lea i vano i tagui ia, i ta maea, “Iau a kona ioe pali na vuana kai manginoro i bole e tugu. Na rodo o mahita turagu.” Na rodo iea e Iakop i mahita turana e Lea. ");
INSERT INTO bnp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","A Vure i longototoa a ninana ne Lea, lakea i singou i podea a limana e tune Iakop. ");
INSERT INTO bnp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Muri e Lea i ta maea, “A Vure i habi nau a maki a nanea vona, a vuhuna a habia ne girihigu a vora ngatavine nau.” Lakea e Lea i vunua e tuna e Isikar. ");
INSERT INTO bnp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","E Lea i singou tabu, i podea a polotarana e tune Iakop. ");
INSERT INTO bnp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Muri i ta maea, “A Vure i habi tavulea nau tara maki kamumu. Ngane e girihigu bara i togo iau, a vuhuna a poda vona e huriki e tuna a bakovi, i polotara.” Lakea i vunua e Sebulun. ");
INSERT INTO bnp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Muri i podea a koma ngatavine, i vunua e Daina. ");
INSERT INTO bnp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","A Vure i luhoia e Resel, i longoa a nivasileki vona, i gamaia ge singou. ");
INSERT INTO bnp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Muri e Resel i singou, i podea a koma bakovi. Lakea i ta maea, “A Vure i bole vuroki a nimaruhu nau.” ");
INSERT INTO bnp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","I vunua e Iosep, lakea i ta maea, “A ngarua e BAKOVI DAGI ge habi tabua nau tara koma bakovi.” ");
INSERT INTO bnp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Muri ne Resel i podea e Iosep, lakea e Iakop i takia e Leban, “Iau ga pe ioe, ga hamule lakea na tanga nau. ");
INSERT INTO bnp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Iau a leho kamumu hateka vomu. O lohoka vona a maka leho lobo a rata vomu, o habi nau e huriki e girihigu, e huriki e tugu, ri gi vano turagu.” ");
INSERT INTO bnp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lakea e Leban i ta maea, “O made turagu. Na naro kamumu vomu kunana iau a tahoka a mahala i kupo. Iau a matakilaka, e BAKOVI DAGI i gamai iau a vuhuna ioe o made turagu.” ");
INSERT INTO bnp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Lakea i ta maea, “O taki iau vona a mapamu, bara kona ioe.” ");
INSERT INTO bnp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","E Iakop i takia, “O lohoka vona a leho a ratea vomu, a matakaria a kabuna sipsip vomu, ri bele kupo. ");
INSERT INTO bnp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ra kabuna sipsip popote o tahoka muga, ngane ria a kabu dagigala, a vuhuna e BAKOVI DAGI i gamai ioe na tahuna a made turamu. Pali ngane, o luhoi kamumu. A ngaru go habi nau ranga maki.” ");
INSERT INTO bnp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lakea e Leban i nana, “Pali a ra o ngaru ga habi vomu?” E Iakop i koli, i ta maea, “A koi go habi nau a maki viliha. O rata kunanea tara naro, muri bara matakari tabu a kabuna sipsip vomu. ");
INSERT INTO bnp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Mona ga bole tala na kabuna sipsip vomu a maka sipsip logologo, a tuna sipsip kokoa, a meme logologo, ga mapagu. ");
INSERT INTO bnp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Muri bara o matai kamumu a sipsip a meme a bole vomu. Na tahuna o matai a meme i uka ma i logologo, a tuna sipsip i uka ma i kokoa o matavisi i laho turana a kabuna nau, bara o lohoka vona iau kunana a panaho.” ");
INSERT INTO bnp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lakea e Leban i ta maea, “I kamumu! O rata manga a hini o taki.” ");
INSERT INTO bnp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Na parava iea kunana, e Leban i vakalaho herehere a maka meme a toga, a kinana logologo keakea, a tuna sipsip kokoa, i habi ne huriki e tuna bakovi ri matakari. ");
INSERT INTO bnp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","E Leban i vano turane ria, ri laho na parava i tolu, turana a kabuna sipsip, a meme. Ri vano ri bele vona a tara tanga. Pali e Iakop i matakaria a kabuna sipsip a meme ne Leban. ");
INSERT INTO bnp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Muri, e Iakop i tolo karaba a rahana kai a popla, a almon, a plein, i rina a kulina, i tabuli kavakava a hini keakea pololilo. ");
INSERT INTO bnp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","I bole ra rahana kai i rina, i ru tabukoi na murina ni ninu. Na tahuna ri ngaru ni varadi a kabuna meme, bara ri valai ri ninu, ");
INSERT INTO bnp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ri varadi tabukoi na rahana kai. Muri a maka kinana bara ri poda, e tune ria ri logologo. ");
INSERT INTO bnp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Muri e Iakop i kalipida a maka tuna sipsip a meme na kabuna. I rata a kabuna sipsip a meme vona ri mata lakea na kabuna sipsip a meme logologo na sipsip a meme kokoa ne Leban. Na naro iea kunana, e Iakop i kalipida a sipsip a meme vona, i uka ma i ru turana a kabuna sipsip a meme ne Leban. ");
INSERT INTO bnp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Na tahuna a maka sipsip, a meme gavutuvutu ri ngaru ni varadi, bara i ru tabukoi na naru a maka rahana kai, bara ri matai, ri varadi. ");
INSERT INTO bnp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Na tahuna a maka sipsip, a meme tekiteki ri ngaru ni varadi, i uka ma i ru a maka rahana kai nga. I mavonga, a maka sipsip tekiteki ri lakea ne Leban, pali e Iakop i bole a maka sipsip gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Na vilo iea kunana e Iakop i vakabele kupo a maki vona. I tahoka a maka kabuna sipsip a meme, e huriki a vora bakovi, a vora ngatavine, a maka kamel, a donki. ");
INSERT INTO bnp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","E Iakop i longo e huriki e tune Leban ri ta maea, “E Iakop i bole lobo a maki ne tamane hita. Ngane i tahoka a mahala i kupo.” ");
INSERT INTO bnp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Lakea e Iakop i masia a narone Leban i mapulo, i uka ma i manga a narona muga. ");
INSERT INTO bnp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Muri e BAKOVI DAGI i takia e Iakop, “O hamule lakea na robo ne tamamu, ne huriki a viri vomu. Iau ga turamu.” ");
INSERT INTO bnp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Lakea e Iakop i talo rike a ngava ne Resel rua e Lea, ru gu masia na hini i matakari a kabuna sipsip vona. ");
INSERT INTO bnp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Lakea e Iakop i taki rua, “Iau a masia a narone tamane marua, i uka ma i manga a narona muga. Pali a Vure ne tata i made turagu. ");
INSERT INTO bnp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Marua, muru lohoka, iau a rata a leho dagi ne tamane marua, ");
INSERT INTO bnp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","pali e tamane marua i tami iau. I balaka ravulu i pulo viliha a mapagu. Pali a Vure, i uka ma i ngarua e Leban ge rata hale iau. ");
INSERT INTO bnp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","I muga i ta maea, ‘A maka sipsip padikuku ga mapamu.’ Lakea a kabuna sipsip ri poda a maka sipsip padikuku. Muri i ta maea, ‘A maka sipsip logologo ga mapamu.’ Lakea a kabuna sipsip ri poda a maka sipsip logologo kunana. ");
INSERT INTO bnp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Na naro iea a Vure i bole ne tamane marua a kabuna sipsip, i habi nau. ");
INSERT INTO bnp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Na tahuna a maka meme ri varadi, a vurena vona a maka meme a toga logologo, ri radi a maka kinana meme. ");
INSERT INTO bnp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","A vurena vona a agelo na Vure i gale iau, i ta maea, ‘Iakop.’ Lakea a koli, a ta maea, ‘Iau ieni.’ ");
INSERT INTO bnp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Lakea i taki iau i ta maea, ‘O mata rike o matai a maka meme a toga logologo, ria kunana ri radi a maka kinana meme. Iau a masia pali a naro hale i rata virihi ioe vona e Leban. ");
INSERT INTO bnp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Iau kunana a Vure, ra i bele vomu o Betel, na tabeke o taki a ngava dagi nau vona, muri o gamaia o rua vona a kedo, ga kilakila. Ngane o pe malaviriria a robo iea, o hamule lakea na robo vomu.’” ");
INSERT INTO bnp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Muri e Resel e Lea ru tapuhaki, ru ta maea, “E tamane maria i uka ma i vakatahoka maria vona tara maki. ");
INSERT INTO bnp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","I rata maria miri manga a mosi. I habi maria vomu, i vakalobo pali a mahala o kona maria vona. ");
INSERT INTO bnp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Muholi ra maka mahala, a Vure i bole mule ne tamane maria, bara ne maria, ne tune maria. Pali ngane o muri maia a ngava a Vure i taki ioe vona.” ");
INSERT INTO bnp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Lakea e Iakop i vakarike na kamel e huriki e tuna e girihina. ");
INSERT INTO bnp_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ri pea ngane a robo iea, ri hamule lakea ne tamana e Isak, na robo e Kenan. A maka kabuna sipsip a meme i lili muga. I vakamariu lobo a maka mahala i vakabele o Padan-Aram, re Mesapotamia. ");
INSERT INTO bnp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Na tahuna i vano e Leban, ge pala­kudu a vuna sipsip, lakea e Resel i panaho a maka hanuna vure ne tamana. ");
INSERT INTO bnp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","E Iakop tara, i tamia e Leban, ra bakovi o Aram, i uka ma i vakalongoa ge vano. ");
INSERT INTO bnp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","I ha turana a maki lobo vona. I vano i pagepoloa a naru dagi e Iupretis. I laho lokovonga liu na maka kupona na robo e Gilead. ");
INSERT INTO bnp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","A parava i tolu i lobo, e Leban i longoa e Iakop i ha pali. ");
INSERT INTO bnp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Lakea e Leban i bole e huriki a kabu vona, ri nunu muri maia e Iakop. Muri na parava i polorua, ri pakaraua na maka kupona na robo e Gilead. ");
INSERT INTO bnp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Na rodo, e Leban, ra bakovi o Aram, i vurena. A Vure i bele vona i ta maea, “Naha ni ratea tara ngava ge hale o ge kamumu ge lakea ne Iakop.” ");
INSERT INTO bnp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","E Iakop i vakapesia a kape na kupona na robo e Gilead, lakea e Leban i pakaraua vonga, ia tara i vakapesi a kape vonga turana e huriki a kabu vona. ");
INSERT INTO bnp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lakea e Leban i takia e Iakop, “Ra ioe, i navai o tami iau, o ha turana e tugu ngatavine ala rua i manga a viri ni lakavu na vabinga? ");
INSERT INTO bnp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","I navai o tami iau, o ha kapiloho? I navai i uka ma o vakalongo iau, ga talo kamumu ioe na ralova turana a nangina kude a golo? ");
INSERT INTO bnp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","I navai i uka ma o vakalongo iau, ga nguru e tubugu mai turane kinane ria? A naro o ratea i hale liu. ");
INSERT INTO bnp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Iau a tahoka a nitora na ni ratapile ioe. Pali baroko na rodo, a Vure ne tamamu i taki iau, i ta maea, ‘Naha ni ratea tara ngava ge hale o ge kamumu ge lakea ne Iakop.’ ");
INSERT INTO bnp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Pali ngane o vano, a vuhuna o ngaru hateka ni hamule na tanga vomu. Pali i navai o panaho a maka vure nau?” ");
INSERT INTO bnp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Lakea e Iakop i takia e Leban, “Iau a mangenge, a ha kapiloho, a vuhuna ma go rata virihi iau vona ranga hini, go bole hamule e tumu ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pali e rei o matavisia i bole a maka vure vomu, ia bara i mate. Na matane huriki a kabu vomu, o valai, o lei a maka maki, pali ioe bara o matavisi a maka maki vomu, o bole mule.” E Iakop, i uka ma i lohoka vona e Resel i panaho a maka vure ne tamana. ");
INSERT INTO bnp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lakea e Leban i dili na kape ne Iakop, na kape ne Lea, na kape na vora ngatavine ala rua, i uka ma i matavisi ranga maki. I pagitala na kape ne Lea, i vano i dili na kape ne Resel. ");
INSERT INTO bnp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","E Resel i bole pali a maka vure ne tamana, i ru pololilo na murina ni made na kamel, i made langa vona. E Leban i lei lobo a maka maki na kape, i uka ma i matavisia tara maki. ");
INSERT INTO bnp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","E Resel i takia e tamana, “Bakovi dagi, naha ni tahate iau, a keri ni pesi na matamu, a vuhuna a matai a keva.” Pali i matakana viliha lae, i uka ma i matavisi a maka vure vona. ");
INSERT INTO bnp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","E Iakop i madihi a hatena, i tahatea e Leban, i nanea, “A ra maki hale a ratea? A ra naro hale a ratea o nunu muri nau vona? ");
INSERT INTO bnp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ngane o lei lobo pali a maka maki nau, pali a ra maki vomu o matavisia? Ioe bara o matavisia tara maki vomu, o vakasiria ne huriki lobo. O ru tala na matane huriki a kabu vomu, a kabu nau, ri gi pelekado a ngavane tarua. ");
INSERT INTO bnp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Na tahuna iau a made turamu na pida i ravulu rua, a maka sipsip, a meme, ri poda kamumu kunana. Pali i uka ma a kania tara sipsip a toga vomu. ");
INSERT INTO bnp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Iau i uka ma a vakasiria vomu ma tara sipsip a meme ge rabalakia a livoa hateka. A maka sipsip a meme i velu, a kuloi ria. A maka sipsip a meme ni panaho na rodo o na hini palala, bara o taki iau a kona. ");
INSERT INTO bnp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Na parava i kupo a haro i kani pile iau. Na rodo i ratapile iau a malangia, i uka ma a mahita kamumu. ");
INSERT INTO bnp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Na pida i ravulu rua a made turamu, a naromu i maea kunana. A leho vomu na pida i ravulu a polona i va, a bole e tumu ngatavine ala rua. Na pida i polotara a bole a maka sipsip a meme vomu. Balaka kupo o pulo viliha a mapagu. ");
INSERT INTO bnp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Bara a Vure ne sisi e Abraham, ra Vure e Isak i kavurike balea, i uka ma ge made turagu, muholi hateka bara laho pa a limagu a hamule. A Vure i matai a nimadihi nau, a leho dagi a ratea na limagu, pali baroko na rodo i tahate ioe, a vuhuna i uka ma o rata a naro kamumu.” ");
INSERT INTO bnp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lakea e Leban i gegea e Iakop i ta maea, “Ra ngatavine nga e tugu, e huriki a koma nga, e tubugu. A maka sipsip a meme nga, a sipsip a meme nau. A maka maki o matai nga, a maka maki nau. Pali ngane ga rata navai e tugu ngatavine, turana e tune rua ru poda? ");
INSERT INTO bnp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","O valai ngane, tu gu valongo mai a ngava ne tarua, tu gu ratea a ngava dagi, bara tu luhoi a maki tu ratea.” ");
INSERT INTO bnp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Lakea e Iakop i bolea tara kedo dagi, i toto pesia ne vona a nivakasiri. ");
INSERT INTO bnp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Muri i taki e huriki a kabu vona ri gi ru palupu ranga kedo. Lakea ri ru palupu a maka kedo, muri ria lobo ri kani palupu tabukoi na kupona kedo iea. ");
INSERT INTO bnp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","E Leban i vunua na nita Aram a hini nga e Iegar Sahaduta. Pali e Iakop i vunua na nita Hibru e Galid. ");
INSERT INTO bnp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","E Leban i ta maea, “Ra kupona kedo iea, ne vona ni vakasiri a ngava tu ratea mona.” Pali ni gale liu a tabeke iea e Galid. ");
INSERT INTO bnp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","A rana tara, e Mispa, a vuhuna e Leban i ta maea, “E BAKOVI DAGI bara i matakari tarua, na tahuna i uka ma tu matai tabu tarua. ");
INSERT INTO bnp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ioe bara o rata hale e tugu ngatavine rua, o bole tabu e huriki a ngatavine karaba ge girihimu, o luhoi kamumu. I uka a viri ge matai tarua, a Vure kunana i matai a hini tu rata.” ");
INSERT INTO bnp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lakea e Leban i taki tabua e Iakop, “O masia a kupona kedo turana a kedo dagi a totopesia na kurukurune tarua. ");
INSERT INTO bnp_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","A kupona kedo turana a kedo dagi a toto pesia ne vona ni vakasiri a ngava dagi tu ratea. Iau i uka ma ga polotaro ga lakene, ga vaubi turamu. Pali ioe tara, i uka ma go polotaro go valai, go vaubi turagu. ");
INSERT INTO bnp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","A Vure ne Abraham, a Vure ne Nahor, a Vure ne tamane rua bara i pelekado a narone tarua.” Lakea e Iakop i kaba vona a ngava dagi na rana Vure ne tamana, e Isak. ");
INSERT INTO bnp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Muri i habi meli na lolo a nihabi na Vure. I gale e huriki a kabu vona ri kani palupu. Ri kani lobo, ri mahita tabu vonga. ");
INSERT INTO bnp_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Na hatelanga pokopoko, na parava muri, e Leban i nguru, i gamai e huriki e tubuna, e tuna. Muri i pe ria, i hamule lakea na tanga vona. ");
INSERT INTO bnp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","E Iakop tara i vano mai a hini ge lakea vona, lakea e huriki a agelo na Vure ri bele vona. ");
INSERT INTO bnp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","E Iakop i matai ria, i ta maea, “Ra hini nga a mada na Vure.” Lakea i vunua a tanga iea e Mahanaim. ");
INSERT INTO bnp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","E Iakop i rudu muga e huriki a vinuru ri gi vakalongoa e tukana e Esau i made o Seir, na robo e Idom. ");
INSERT INTO bnp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I taki e huriki a vinuru vona ri gi vakalongoa a matakari ne ria, e Esau, ri gi ta maea, ‘A vora vomu e Iakop ta ge vakalongo ioe vona a hini i made turane Leban, pali ngane i ngaru ni hamule valai vomu. ");
INSERT INTO bnp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I tahoka a maka kabu na bulmakau, a donki, a sipsip, a meme, a vora bakovi, a vora ngatavine. I rudu valai a ngava vomu, ioe a matakari vona, ta go rata a naro kamumu vona.’” ");
INSERT INTO bnp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ri hamule valai ne Iakop, ri ta maea, “Mi lakea ne tukamu e Esau, mi vakalongoa pali. Ngane ge muri valai turana e huriki a tara vona ri ala 400, ri gi tagui ioe.” ");
INSERT INTO bnp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","E Iakop i mangenge, i loho lege lae, i vakalipida na tete i rua a tara vona. A maka kabuna sipsip, a meme, a bulmakau, a kamel ngi ranga i vakalipida na tete i rua. ");
INSERT INTO bnp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","E Iakop i luhoi maea, “E Esau bara i valai, i vaubi turana a tete tara, a tete i uka ma i vaubi bara i ha.” ");
INSERT INTO bnp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Muri e Iakop i vasileki, i ta maea, “O Vure ne sisi e Abraham, ne tata e Isak. BAKOVI DAGI ioe a viri o taki iau ga hamule lakea na viri nau, na robo nau, go vakamade kamumu iau. ");
INSERT INTO bnp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Iau a vora vomu, i uka ma i kamumu a vilogu, pali ioe o dodo iau, o rata a naro kamumu nau. Hosi a pagepolo na naru dagi e Iordan turana a kodo nau kunana, pali ngane a tahoka a tara i rua. ");
INSERT INTO bnp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","A vasileki vomu, o kori iau na limane turagu e Esau, a vuhuna a mangenge vona, ma ge valai, ge vaubi turagu turane huriki a ngatavine e tune ria. ");
INSERT INTO bnp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Pali ioe o ta maea, ‘Muholi iau ga vakamade kamumu ioe, ga rata e huriki a hamomu ri gi bele kupo manga a hire na dari, bara ni keri ni gi.’” ");
INSERT INTO bnp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I mahita vonga vona a rodo iea, pali i pelekado a maka maki i bole a maka mahala ge habi ne turana e Esau. ");
INSERT INTO bnp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Lakea i ru palupu a kinana meme i 200, a meme a toga i ravulu rua, a kinana sipsip i 200, a sipsip a toga i ravulu rua, ");
INSERT INTO bnp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","a kinana a kamel i ravulu tolu turana tuna, a kinana bulmakau i ravulu va, a bulmakau a toga i ravulu, a donki a kinana i ravulu rua, a donki a toga i ravulu. ");
INSERT INTO bnp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","I taki e huriki a vora vona ri matakari a maka kabuna sipsip a bulmakau takutaku, i ta maea, “Mu laho muga. Naha ni vakalaho palupu a maka kabuna sipsip a bulmakau.” ");
INSERT INTO bnp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Lakea e Iakop i takia a vora i laho muga, “E tukagu e Esau, ge tagui ioe, ge nana ranga, ‘Ioe o leho ne rei? I vai a tanga go lakea vona? A sipsip a bulmakau ne rei ra ri laho na ngalamu?’ ");
INSERT INTO bnp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Pali o takia, o ta maea, ‘A maka sipsip a bulmakau nga, ne vona a vora vomu, e Iakop. A maka sipsip a bulmakau nga ge habi vomu, ioe a bakovi dagi vona. Ia ge muri valai.’” ");
INSERT INTO bnp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","E Iakop i taki tabu a ruana, a toluna vora, e huriki a vora lobo ri matakaria a kabuna sipsip a bulmakau, i ta maea, “Na tahuna mu taguia e Esau, mu takia a ngava ge palupulupu kunana. ");
INSERT INTO bnp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Mu ta tora vona a ngava, ‘A vora vomu e Iakop i muri valai.’” A vuhuna e Iakop i luhoi maea, “Na naro iea kunana bara luke mulea e Esau na maka mahala a vakaru muga, lakea na tahuna miri vakorokoro, bara i rata kamumu iau.” ");
INSERT INTO bnp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Lakea e Iakop i vakaru muga a maka mahala vona, i mahita vonga na mada ia. ");
INSERT INTO bnp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Na rodo iea, e Iakop i bole e girihina rua, a vora ngatavine vona ala rua, turana e tuna mai ala ravulu a polona i taku, ri pagepoloa a naru e Iabok. ");
INSERT INTO bnp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","I rudu muga ria turana a maka maki lobo vona. ");
INSERT INTO bnp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Pali ia kikeri i made mule. I bele tahoa tara bakovi ru valoi mavonga na rodo, i palala taho rua a hini. ");
INSERT INTO bnp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Na tahuna ru valoi, a bakovi i keri ni vakaborua e Iakop, lakea i ubi a labune Iakop, i maparu a tagana. ");
INSERT INTO bnp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Muri i ta maea a bakovi, “O taparaki iau ga vano. I palala pali a hini.” E Iakop i koli mule, i ta maea, “O gamai taro iau, muri o vano ke.” ");
INSERT INTO bnp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Lakea a bakovi i nanea, “E rei a ramu?” I koli mule, i ta maea, “A ragu e Iakop.” ");
INSERT INTO bnp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Muri a bakovi i ta maea, “A ramu ngane i uka ma ge Iakop tabu. A ramu ngane ni gi gale ge Israel, a vuhuna o valoi turana Vure, o valoi turana e huriki a bakovi, o rangi ria pali.” ");
INSERT INTO bnp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Lakea e Iakop i takia, “O taki iau vona a ramu!” A bakovi i koli, i ta maea, “I navai o nana vona a ragu?” Muri i gamaia e Iakop. ");
INSERT INTO bnp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Lakea, e Iakop i galea ra mada iea e Peniel, muri i ta maea, “A masia pali a matana Vure, pali i uka ma a mate.” ");
INSERT INTO bnp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Na tahuna i pea e Penuel a haro i hera pali, i kodo a vuhuna i maparu a tagana. ");
INSERT INTO bnp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Na tahuna iea, i valai mona, e huriki a kabu ne Israel i uka ma ri kani kilala a pona sipsip a bulmakau. Ri ramaia a vilo iea, a vuhuna a Vure i ubia a labune Iakop, i maparu a tagana. ");
INSERT INTO bnp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","E Iakop i mata muga, i masia e Esau i valai turana e huriki a bakovi ala 400, lakea i kalipida e Lea, e Resel, a vora ngatavine ala rua, e huriki a koma. ");
INSERT INTO bnp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","I vakalaho muga a vora ngatavine turane huriki e tune rua, e Lea turana e huriki e tuna ri laho na kurukuruna, e Resel e Iosep ru laho muri. ");
INSERT INTO bnp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","E Iakop kunana i laho muga, i lolu puru na malala balaka polorua na tahuna i laho lokovonga ge taguia e tukana. ");
INSERT INTO bnp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Lakea e Esau i nunu lokovonga ne Iakop, i taguia, i rakoa, i ngurua ru vataringi. ");
INSERT INTO bnp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Muri i mata rike e Esau, i matai e huriki a ngatavine a koma, lakea i nana, “E rei e huriki ri turamu?” Lakea e Iakop i koli mulea i ta maea, “Iau a vora vomu. A Vure i rata a naro kamumu nau, i habi nau e huriki a koma nga.” ");
INSERT INTO bnp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Muri a vora ngatavine turane huriki e tune rua, ri laho valai ri lolu puru. ");
INSERT INTO bnp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","E Lea turane e tuna mai ri muri mai ria, ri lolu puru. E Resel rua e Iosep ru muri, rua ranga ru lolu puru. ");
INSERT INTO bnp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Lakea e Esau i nana, “Ra maka sipsip a bulmakau a matai, go bole lokovai?” Lakea e Iakop i ta maea, “Bakovi dagi nau, ta ga habi vomu, go rata kamumu iau.” ");
INSERT INTO bnp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Pali e Esau i koli mulea i ta maea, “Tarigu, iau a tahoka i kupo hateka. O matakari a maka sipsip a bulmakau nga, ge ne vomu.” ");
INSERT INTO bnp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","E Iakop i hehe, i ta maea, “I uka ma ge mavonga. Ngane tu vamatai tabu, o bole nau a maki nga. Ra ngane a matai a matamu, i manga a matai a matana Vure, a vuhuna o vivi ni tagui iau. ");
INSERT INTO bnp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngane a ngaru go bole a mahala nga a vuhuna a Vure i rata a vilo kamumu nau, a tahoka a maki i kupo.” E Iakop i ta hinituhana, lakea e Esau i bole a maka mahala nga. ");
INSERT INTO bnp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Muri e Esau i ta maea, “Tu vano, iau ga laho turamu.” ");
INSERT INTO bnp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Lakea e Iakop i ta maea, “Tukagu, e huriki a koma, i uka ma ri paki kamumu ma. Pali iau a luhoi hateka a maka sipsip, a bulmakau ra ri vakaruru, ma ri gi laho hateka na parava i taku, ma ri gi mate. ");
INSERT INTO bnp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tukagu, o laho muga ke. Ge laho muri e tarimu. Ga bae a maka sipsip a bulmakau turane huriki e tugu mai, bara mi pakarau ioe o Seir.” ");
INSERT INTO bnp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Lakea e Esau i ta maea, “Ga taparaki vomu ranga vora nau ri gi laho turamu.” Pali e Iakop i koli, i ta maea, “Ge vona ra? A ngaru kunana ioe go ngaru iau” ");
INSERT INTO bnp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Na parava iea, e Esau i vakatubu ni laho mule lakea o Seir. ");
INSERT INTO bnp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Pali e Iakop i lakea o Sukot, i ratea vonga a tanga vona, i hae a kape na sipsip a bulmakau vona. Lakea ni gale liu ra mada iea e Sukot. ");
INSERT INTO bnp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Muri e Iakop i pea e Padan-Aram, re Mesapotamia, i bele na robo e Kenan, i ru a mada vona tabukoi na tanga dagi e Sekem. ");
INSERT INTO bnp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Lakea i bole a kedo silva i 100, i kona ne tamane Sekem, na kabune Hamor, a malala i vakapesi a kape vona. ");
INSERT INTO bnp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Lakea i vakapesia vonga a dede-kedo, i galea, “A Vure a Vure ne Israel.” ");
INSERT INTO bnp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","E Daina, e tune Iakop, e Lea i vano ge matai e huriki a ngatavine na tanga dagi. ");
INSERT INTO bnp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","E Hamor, a bakovi dagi na kabu na Hivi, i matakaria ra tanga dagi iea. E tuna, e Sekem. Na tahuna e Sekem i masia e Daina, i lakavua. ");
INSERT INTO bnp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","E Sekem i ngaru hatekea e Daina, e tune Iakop. Lakea i lukea na ngava, ge ngarua. ");
INSERT INTO bnp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Muri e Sekem i takia e tamana, i ta maea, “O tulia a ngatavine iea ge girihigu.” ");
INSERT INTO bnp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Na tahuna e Iakop i longoa e Daina ni lakavu, i uka ma i takia tara ngava. I dava kunana e huriki e tuna ri gi hamule taro, a vuhuna ria lobo ri vano ri matakari a sipsip. ");
INSERT INTO bnp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Muri e tamane Sekem i vano, ge ta turane Iakop. ");
INSERT INTO bnp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Na tahuna e huriki e kurabane Daina ri hamule na robo, ri longoa e Daina ni lakavu, i madihi a hatene ria, a vuhuna e Sekem i rata a rabu hale na kabu ne Israel na ni mahita turane Daina, re tune Iakop. Ra naro iea i hale hateka. ");
INSERT INTO bnp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Lakea e Hamor i taki ria, “E tugu e Sekem i ngarua e Daina. Mu habia vona ge girihina. ");
INSERT INTO bnp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Si gi vaparangi vakuloi. Mu habi valai ne mia a ngatavine. Mia ranga bara mi habi lakene mua a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mu made turane mia, mu leho vona a malala na tabeke mu ngaru. Mu vahabi, mu vakona, bara mu tahoka a mahala vona a malala iea.” ");
INSERT INTO bnp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Lakea e Sekem i takia e tamane Daina turana e huriki e kurabana, i ta maea, “Mua bara mu longo mai iau, bara habi tavula ne mua a maki mu nana iau vona. ");
INSERT INTO bnp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mu takia a mapana ngatavine, turana ranga maki, bara habi ne mua. Pali a ngatavine iea, mu habia nau ge girihigu.” ");
INSERT INTO bnp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","E huriki e tune Iakop ri longo tamilalu, ri tami e Hamor rua e tuna e Sekem, a vuhuna e kurabane ria, e Daina, ni rata a naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Lakea ri taki rua, “I uka ma mi gi longo mai marua. I uka ma mi gi habia e kurabane mia na bakovi i uka ma ni pala a kulina, ma ge habi a nimaruhu ne mia. ");
INSERT INTO bnp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Bara mi longo mai ioe na maki i taku kunana. Mi ngaru mu gu pala a kuline huriki a bakovi lobo, ri gi manga mia. ");
INSERT INTO bnp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Muri bara mi habi mua e huriki a ngatavine ne mia. Mua ranga bara mu habi ne mia e huriki a ngatavine. Bara mi made turane mua, muri bara hita a viri ala taku. ");
INSERT INTO bnp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pali mua, i uka ma mu longo mai mia, ni gi pala a kuline mua, bara mi bole mulea e kurabane mia, mi vano.” ");
INSERT INTO bnp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","A nitane ria i nangi kamumu ne Hamor rua e tuna, e Sekem. ");
INSERT INTO bnp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","A riau iea, ri kavurike hatekea e huriki a kabu ne tamana, i malaviriri kunana i muri mai a ngava ri taki, a vuhuna i ngaru hatekea e Daina. ");
INSERT INTO bnp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","E Hamor rua e tuna e Sekem, ru lakea na poridala na tanga dagi, ru ta turana e huriki a bakovi vonga. ");
INSERT INTO bnp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ru ta maea, “A narone e huriki a bakovi nga i kamumu. Ri gi made turane hita na malala ne hita, ri gi rata harikia ne ria. A malala i tabuli tavula, i uka viri ge leho vona. Ngane si gi parangi na ngatavine ne ria, pali ria ranga bara ri parangi na ngatavine ne hita. ");
INSERT INTO bnp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Pali si gi valongo mai vona tara ngava. E huriki a bakovi ne hita, ni gi pala a kuline ria, si gi manga ria. Muri bara ri longo ni made na malala ne hita, bara hita a viri ala taku kunana. ");
INSERT INTO bnp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","A maka mahala, a sipsip, a bulmakau ranga, bara ne hita. Si gi longo mai ria, bara ri made turane hita.” ");
INSERT INTO bnp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","E huriki a bakovi ri pagitala na poridala na tanga dagi, ri longo vona a nitane Hamor rua e tuna e Sekem. Lakea ni pala a kuline e huriki a bakovi lobo na tanga dagi. ");
INSERT INTO bnp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","I rongo ria a voko, ri malo kunana. I lobo a parava i tolu, lakea e tune Iakop ala rua, e Simion e Levi, ra to kinana taku e Daina, ru bole a bainat ne rua, ru vaubi turana e huriki a bakovi na tanga dagi, ru rabalaki ria. ");
INSERT INTO bnp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ru rabalaki na bainat e Hamor rua e tuna e Sekem, lakea ru bole mulea e Daina na ruma ne Sekem. ");
INSERT INTO bnp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ri sike e huriki e tune Iakop ranga, ri matai a podane huriki ri mate, ri bole a maki lobo na tanga dagi, a vuhuna e Sekem i rata a naro hale ne kurabane ria. ");
INSERT INTO bnp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ri bole a maka sipsip a bulmakau, a donki, a mahala lobo i tabuli pololilo, i tabuli polovavo na tanga dagi. ");
INSERT INTO bnp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ri bole a maka mahala, e huriki a ngatavine, e huriki a koma, ri bole a maki lobo na tanga dagi. ");
INSERT INTO bnp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Muri e Iakop i taki e Simion rua e Levi, “Marua muru rata hale a nimadegu. Muru rata iau ngane i uka ma a made kamumu na matane huriki a Kenan a Peres, re huriki a tahona a robo iea. Hita, i uka ma si ala kupo. E huriki nga bara ri vadili palupu, bara ri ratapile iau turane huriki a kabu nau.” ");
INSERT INTO bnp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Lakea ru nana maea, “O luhoi navai, miri gi mata taroa e kurabane maria, ni gi rata manga a ngoi?” ");
INSERT INTO bnp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Muri a Vure i takia e Iakop, “O sike o Betel, o made vona, o kisia a dede-kedo nau na tabeke a bele vomu na tahuna o ha ne turamu e Esau.” ");
INSERT INTO bnp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Lakea e Iakop i taki e huriki a kabu vona, i ranga e huriki ri turana, i ta maea, “Mu vuroki a maka vure taminga mu tahoka, mu kurudu pasi mua, mu rodo a varakia karaba. ");
INSERT INTO bnp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mu valai, si gi lakea o Betel, ga haea vonga a dede-kedo na Vure, a vuhuna i kori iau na tahuna na vuranga, i laho turagu na maka robo a lakea vona.” ");
INSERT INTO bnp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Lakea ri habi ne Iakop a maka vure taminga ne ria, turana a maka pato na talingane ria, i tanu ria na taruna kai a ok tabukoi o Sekem. ");
INSERT INTO bnp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Muri ri vano, lakea a Vure i rata e huriki a bakovi na maka tanga dagi tabukoi vonga ri mangenge, i uka ma ri valili ria. ");
INSERT INTO bnp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","E Iakop turane huriki a tara vona, ri bele o Lus, re Betel na robo ne huriki a Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","I kisia vonga a dede-kedo, i galea a hini ngi “A Vure ne Betel”, a vuhuna a Vure i bele vona vonga na tahuna i ha ne tukana. ");
INSERT INTO bnp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","E Debora, a vora ngatavine ne Rebeka i mate vonga, lakea i tanua na taruna kai a ok na tabeke mule puru ne Betel. Ni gale liu a kai iea “A Kai ni Tangi.” ");
INSERT INTO bnp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Muri ne Iakop i pe e Padan-Aram, a Vure i bele tabu vona i gamaia. ");
INSERT INTO bnp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Lakea a Vure i takia, “A ramu e Iakop, pali ngane i uka ma ni gi gale tabu ge Iakop, ni gi gale e Israel.” Lakea i vunua e Israel. ");
INSERT INTO bnp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Muri a Vure i takia, i ta maea, “Iau a Vure Tuhaka, o vakabele e huriki a hamomu, ri gi vakavonu a malala. Ge ioe a vuhuna e huriki a kabu lobo. E huriki a hamomu ranga, ge ria a hariki. ");
INSERT INTO bnp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ra robo a habia ne Abraham rua e Isak, ngane a habia vomu. Muri ga habia ne huriki a hamomu.” ");
INSERT INTO bnp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Muri a Vure i pea e Iakop na hini i ta turana vona, i sike. ");
INSERT INTO bnp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","E Iakop i rua a kedo ga kilakila ni gi vakasiri a tabeke i ta turana Vure vona. Lakea i guru langa na kedo a naruna vain, a naruna oliv, ge vakasiri a nihabi vona na Vure. ");
INSERT INTO bnp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","E Iakop i vunua a tabeke i ta turana Vure vona a “Roho na Vure”. ");
INSERT INTO bnp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","E Iakop turane huriki a tara vona ri pea e Betel, ri lakea na tanga dagi e Eprata. Ri tabukoi ni bele vonga, i pahea a koma i keri ni poda e Resel. ");
INSERT INTO bnp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Na tahuna i hataki a nimadihi na nipoda, a ngatavine bolekori i takia, “Naha ni mangenge, bara o poda tabua a koma bakovi.” ");
INSERT INTO bnp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Na tahuna e Resel i popote ge mate i vunua e tuna bakovi e Ben-Oni. Muri e tamana i vunu herea e Bensamin. ");
INSERT INTO bnp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","E Resel i mate, ni tanu na dala lakea o Eprata, ngane ni gale e Betlehem. ");
INSERT INTO bnp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","E Iakop i rua a kilakilana polomeli na lovona. I mona a kilakilana i vakasiria a lovo ne Resel. ");
INSERT INTO bnp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","E Israel i laho lokovonga, i polotaroa a tanga e Eder, i haea a kape vona. ");
INSERT INTO bnp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Na tahuna e Israel i made vona a robo iea, lakea e Reuben i mahita turana e Bila, a ngatavine i parangi tabu vona e tamana. Lakea i vano a nita i bele ne Iakop vona ra naro hale i ratea e Reuben. E Iakop i tahoka e tuna a bakovi ala ravulu a polona i rua. ");
INSERT INTO bnp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","E huriki e tune Lea a bakovi, a rane ria ra nga: e Reuben, a tabua ne Iakop, e Simion, e Levi, e Iuda, e Isikar, e Sebulun. ");
INSERT INTO bnp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","E tune Resel a bakovi a rane rua ra nga: e Iosep e Bensamin. ");
INSERT INTO bnp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","E tune Bila, a vorakato ne Resel, a bakovi a rane rua ra nga: e Dan e Naptali. ");
INSERT INTO bnp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","E tune Silpa, a vorakato ne Lea, a bakovi a rane rua ra nga: e Gad e Aser. Re huriki a bakovi nga, e tune Iakop ni poda o Padan-Aram. ");
INSERT INTO bnp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","E Iakop i bele taho e tamana na tanga e Mamare, i tabukoi na tanga dagi e Kiriat-Araba, re Hebron. E Abraham e Isak ru made vonga hosi. ");
INSERT INTO bnp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","E Isak i tahoka a pida i 180, ");
INSERT INTO bnp_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","i gare liu, muri i mate. I vano i made turane huriki a viri vona ri mate pali. Muri e Esau rua e Iakop ru tanua. ");
INSERT INTO bnp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","E Esau, a rana tara e Idom, i kupo a hamona. ");
INSERT INTO bnp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","I parangi a ngatavine o Kenan i ala tolu: E Ada, e tune Elon, a bakovi o Hiti; e Oholibama, e tune Anah, e tubune Sibion, a bakovi o Hivi; ");
INSERT INTO bnp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","e Basemat, e tune Ismael, e turane Nebaiot. ");
INSERT INTO bnp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","E Ada i podea ne Esau a koma bakovi i vunua e Elipas. E Basemat i podea e Ruel. ");
INSERT INTO bnp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","E Oholibama i poda e Ieus, e Ialam, e Kora. Re huriki a bakovi nga e Esau i vakabele na robo e Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Muri e Esau i pea vonga e Iakop i mariu lakea na tabeke tara. I vano turana e girihina ala tolu, e tuna mai, e huriki ri made turana. I bole a maka sipsip a bulmakau a mahala i vakabele o Kenan i vano. ");
INSERT INTO bnp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","E Esau i pea e Iakop, a vuhuna i kupo hateka a maka sipsip a bulmakau ne rua, i kiroko a malala. ");
INSERT INTO bnp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","I vano, i made na kupona na robo e Seir, re Idom. ");
INSERT INTO bnp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","E Esau a vuhuna e huriki o Idom, ra ri made na kupona na robo e Seir. ");
INSERT INTO bnp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","E tune Esau a bakovi e Elipas, e kinana e Ada; e Ruel, e kinana e Basemat. ");
INSERT INTO bnp_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","E huriki e tune Elipas a bakovi ra nga: e Teman, e Omar, e Sepo, e Gatam, e Kenas. ");
INSERT INTO bnp_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","E Elipas, e tune Esau, i tahoka a vora ngatavine tara a rana e Timna. I podea vona e Amalek. E huriki a bakovi nga e tubune Esau rua e Ada. ");
INSERT INTO bnp_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","E huriki e tune Ruel a bakovi a rane ria ra nga, e Nahat, e Sera, e Sama, e Misa. E huriki a bakovi nga e tubune Esau rua e Basemat. ");
INSERT INTO bnp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","E Oholibama, e girihine Esau tara i poda e Ieus, e Ialam, e Kora. E Oholibama, e tune Anah ngatavine. E Anah, e tune Sibion ngatavine. ");
INSERT INTO bnp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Re huriki a hariki nga a hamone Esau. A tabua ne Esau rua e Ada e Elipas. E tune Elipas a bakovi ra nga: e Teman, e Omar, e Sepo, e Kenas, ");
INSERT INTO bnp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","e Kora, e Gatam, e Amalek. Re huriki a hariki nga, e tune Elipas, e tubune Ada, ri matakari na robo e Idom. ");
INSERT INTO bnp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","E huriki a hariki e tune Ruel, re tune Esau, ra nga: e Nahat, e Sera, e Sama, e Misa. E huriki a hariki nga, e tune Ruel, ri matakari o Idom. Ria e tubune Esau rua e Basemat. ");
INSERT INTO bnp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","E huriki a hariki nga, e tune Esau rua e Oholibama: e Ieus, e Ialam, e Kora. E huriki a hariki nga, a hamone Esau rua e Oholibama re tune Anah. ");
INSERT INTO bnp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Re huriki a hariki nga ria a hamone Esau, a rana tara e Idom, ri matakaria a kabu ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","E huriki a hamone Seir a bakovi o Hori ri made vona a robo e Idom: e Lotan, e Sobal, e Sibion, e Anah, ");
INSERT INTO bnp_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","e Disan, e Eser, e Dison. Re huriki a hariki nga e tuna e Seir, ri matakaria a kabu ne Hori na robo e Idom. ");
INSERT INTO bnp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","E tune Lotan bakovi ra nga: e Hor, e Heman. E Timna e kurabane Lotan. ");
INSERT INTO bnp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","E huriki e tune Sobal bakovi ra nga: e Alvan, e Manahat, e Ebal, e Sepo, e Onam. ");
INSERT INTO bnp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","E tune Sibion bakovi ra nga: e Aia e Anah, re Anah i matakari a maka donki ne tamana e Sibion na tabeke i ngeki, i matavisia a navuha. ");
INSERT INTO bnp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","E Anah e tuna e Dison e Oholibama. ");
INSERT INTO bnp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","E tune Dison bakovi, a rane ria ra nga: e Hemdan, e Esban, e Itran, e Keran. ");
INSERT INTO bnp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","E tune Eser bakovi ra nga: e Bihan, e Savan, e Akan. ");
INSERT INTO bnp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","E tune Disan bakovi ra nga: e Us, e Aran. ");
INSERT INTO bnp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","A hariki na kabu ne Hori ra nga: e Lotan, e Sobal, e Sibion, e Anah, ");
INSERT INTO bnp_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","e Dison, e Eser, e Disan. Re huriki nga a hariki na kabu ne Hori. Ri matakari a tabeke takutaku ne ria na robo e Seir. ");
INSERT INTO bnp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Muga na tahuna e Israel i uka hariki, e huriki a hariki nga ri matakari o Idom: ");
INSERT INTO bnp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","e Bela tune Beor i matakari o Idom. A tanga dagi vona e Dinhaba. ");
INSERT INTO bnp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Na tahuna e Bela i mate, e Iobab, e tune Sera, i valai na tanga e Bosra, i bole a murina. ");
INSERT INTO bnp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Na tahuna e Iobab i mate, e Husam i bole a murina. A robo vona e Teman. ");
INSERT INTO bnp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Na tahuna e Husam i mate, e Hadad tune Bedad i bole a murina. E huriki a tara vona ri ratapile e huriki o Midian na robo e Moab. A tanga dagi vona e Avit. ");
INSERT INTO bnp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Na tahuna e Hada i mate, e Samla i bole a murina. A tanga dagi vona e Mesreka. ");
INSERT INTO bnp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Na tahuna e Samla i mate, e Sahul i bole a murina. A tanga dagi vona e Rehobot i pesi na dahana naru dagi, e Iupretis. ");
INSERT INTO bnp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Na tahuna e Sahul i mate, e Bal-hanan e tune Akbor i bole a murina. ");
INSERT INTO bnp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Na tahuna e Bal-hanan e tune Akbor i mate, e Hadar i bole a murina. A tanga dagi vona e Pau. A rana e girihina, e Mahetabel, e kinana e Matred, e tune Mesahab. ");
INSERT INTO bnp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","E huriki a hariki, a hamone Esau ri matakari na robo ni vunu virihi ria vona, a rane ria ra nga: e Timna, e Alva, e Dethet, ");
INSERT INTO bnp_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","e Oholibama, e Ela, e Pinon, ");
INSERT INTO bnp_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","e Kenas, e Teman, e Mibsa, ");
INSERT INTO bnp_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","e Magdiel, e Iram. Re huriki nga ria a hariki ne Idom. E Idom a rana tara e Esau. E Esau a vuhuna a kabu ne Idom. E huriki a hariki nga ri tahoka a tanga takutaku ne ria na robo ri made vona, lakea ni vunu muri mai ria a tanga nga. ");
INSERT INTO bnp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","E Iakop i made na malala e Kenan, hosi e tamana i made vona. ");
INSERT INTO bnp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iea ngane a nitane Iakop: E Iosep a riau i tahoka a pida i ravulu a polona i polorua (17). I tuhori e huriki e tukana ni matakari a kabuna sipsip. E huriki e tukana nga, e tune Bila rua e Silpa, e girihine Iakop varago. E tukana mai bara ri rata a naro hale, e Iosep bara i vano i taki tala ne tamana. ");
INSERT INTO bnp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","E Israel i ngaru hatekea e Iosep ne huriki e tuna bakovi lobo, a vuhuna i podea e kinana na tahuna e Iakop i gare. Lakea e Iakop i ratea a varakia mageregere i habia vona. ");
INSERT INTO bnp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Na tahuna e huriki e tukana ri masia e tamane ria i ngaru hatekea e Iosep, ri tepua, i uka ma ri rata kamumua. ");
INSERT INTO bnp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Na parava tara e Iosep i vurena, i tuvereia ne tukana mai a vurena. Na tahuna e huriki e tukana ri longoa, i madihi hateka a hatene ria. ");
INSERT INTO bnp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","E Iosep i taki ria, “Mu longoa a vuregu, ga tuvereia. ");
INSERT INTO bnp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Na tahuna si rotu a galesi na vit na hania, a galesi nau i pesi tamoro. Pali a galesi ne mua ri pesi haluia, ri lolu puru maia.” ");
INSERT INTO bnp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Na tahuna e tukana mai ri longoa, ri nanea, “Ioe o luhoi ge ioe a matakari ne mia? Ioe o ngaru mia mi gi longototo a ngavamu?” Lakea ri tepu hatekea vona a nuverei na vurena. ");
INSERT INTO bnp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Muri i vurena tabu, i tuverei poloa ne tukana mai a vurena, i ta maea, “Mu longo valai, iau a vurena tabu, a vurena vona a haro, a keva, a hada i ravulu a polona i taku ri lolu puru ma iau.” ");
INSERT INTO bnp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","I tuvereia ne tamana, e huriki e tukana ra vurena, lakea e tamana i tahatea, i ta maea, “O vurena navai ke? Ioe o ngaru e kinamu, iau, e tukamu mai, mi gi lolu puru na ngalamu?” ");
INSERT INTO bnp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","I madihi a hatene ria e huriki e tukana, pali e tamana i luhoi kado kunanea a vurene Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Na parava tara, e huriki e tukane Iosep ri vano ri matakari a kabuna sipsip tabukoi o Sekem. ");
INSERT INTO bnp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Lakea e Israel i takia e Iosep, “Ioe o lohoka vona a hini i matakari a sipsip vona e huriki e tukamu tabukoi o Sekem? O vano, o lokovonga mai ria.” E Iosep i koli mule i ta maea, “A lohoka vona.” ");
INSERT INTO bnp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Lakea i takia, “O vano o gosi e huriki e tukamu, o vakarakoli a maka kabu na sipsip, muri o hamule, o vakalongo iau.” E Israel, turana e huriki a kabu vona, ri made na maloku ne Hebron, i rudu talea vonga e Iosep. Na tahuna e Iosep i bele o Sekem, ");
INSERT INTO bnp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","a bakovi tara i matavisia i laho viliha vonga i nanea, “A ra o matakanea?” ");
INSERT INTO bnp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","I ta maea ia, “Iau a matakana e huriki e tukagu. O vakalongo iau vona a hini ri matakari a kabuna sipsip vona.” ");
INSERT INTO bnp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Lakea a bakovi i ta maea, “Ri mariu pali koea. A longo ria ri taki ni lakea o Dotan.” Lakea e Iosep i muri mai ria, i luve taho ria tabukoi o Dotan. ");
INSERT INTO bnp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","E huriki e tukana mai ri masia i laho valai, ri varodo a ngava ri gi rabalakia. ");
INSERT INTO bnp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ri varodo a ngava, ri ta maea, “Mata lakea. I valai ngane a koma na nivurena. ");
INSERT INTO bnp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mu valai, si gi rabalakia, si gi voro purua na lovo a podana. Muri bara si taki ta a livoa hateka i rabalakia. Muri si gi masia a ra maki ge bele vona a vurena.” ");
INSERT INTO bnp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Na tahuna e Reuben i longoa, i ngaru ni koria e Iosep, lakea i ta maea, “Nahea si gi rabalakia, ");
INSERT INTO bnp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","si gi vakatua a darana. Si gi voro puru kunanea koea na lovo na tabeke i ngeki.” E Reuben i ta mavonga, a vuhuna i ngaru ge koria e Iosep, ge tuli hamulea ne tamana. ");
INSERT INTO bnp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Na tahuna e Iosep i luve taho ria, ri lakavua, ri kali talea a varakia rengerenge vona. ");
INSERT INTO bnp_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ri bolea, ri voro purua na lovo i uka naru. ");
INSERT INTO bnp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Na tahuna ri made puru, ri gi kani, ri matai e huriki a Ismael ri valai o Giliat, ri gi puru o Egipto. Ri vakarike na maka kamel ne ria a mahala kamumu: a maki ni kani manginoro, a marasin ni bole na kai, a nibiri mangisipa. ");
INSERT INTO bnp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Lakea e Iuda i taki e huriki e turana, “A ra maki kamumu vona si gi rabalaki kapilohoa e tarine hita? ");
INSERT INTO bnp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Mu valai, si gi habia ne huriki a Ismael, ri gi konea. Nahea si gi rabalakia, a vuhuna ia e tarine hita muholi.” Lakea ri longototoa. ");
INSERT INTO bnp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","E huriki a Midian, a tara na ni vangoli a mahala, ri valai, ri laho polo. Ri matai e huriki e turana ri lalu rikea na lovo, ri habia ne huriki a Ismael, ri konea e Iosep na kedo silva i ravulu rua, muri ri bole lakea o Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Na tahuna e Reuben i hamule lakea na lovo, i uka ma i masia e Iosep, lakea i rapea a varakia vona. ");
INSERT INTO bnp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","I hamule lakea ne huriki e tarina i ta maea, “E Iosep, i uka ma ia na lovo! Ga navai iau?” ");
INSERT INTO bnp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Lakea, ri rabalakia tara meme, ri bole a darana, ri ravu na varakia e Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Muri ri bole lakea ne tamane ria a varakia rengerenge, ri ta maea, “A varakia iea mi matavisia. O matai kamumua, ma ge ne tumu e Iosep.” ");
INSERT INTO bnp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","E Iakop i matakilalea a varakia, lakea i ta maea, “Muholi hateka! A varakia ne tugu e Iosep. A livoa hateka tara i rabalakia, i kararapea e Iosep.” ");
INSERT INTO bnp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Muri, i rapea a varakia vona, i rodo a varakia nikalo, i taringia na parava i kupo e tuna. ");
INSERT INTO bnp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","E huriki e tuna bakovi, e tuna ngatavine ri valai, ri gi lukea, pali i koi ne ria ri gi lukea, i taki ria, “Naha ni luke mule iau. Ga tangi tangi, ga mate, ga muri mai e tugu.” Lakea e Iakop i tangi mavonga. ");
INSERT INTO bnp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Na tahuna e huriki a Midian ri bele o Egipto ri habia ne Potipar e Iosep, i konea. E Potipar a bolekori ne Parao, a ubu na tagari vona. ");
INSERT INTO bnp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Na parava tara, e Iuda i pe e huriki e turana, i puru na tanga e Adulam, i made turana a bakovi a rana e Hira. ");
INSERT INTO bnp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","I matavisia vonga a ngatavine, e tune Sua, a bakovi o Kenan, I parangi vona. ");
INSERT INTO bnp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","A ngatavine i singou, i podea a koma bakovi, i vunua e Er. ");
INSERT INTO bnp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","I singou tabu, i poda tabua a koma bakovi, i vunua e Onan. ");
INSERT INTO bnp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Muri i poda tabua a koma bakovi tara, i vunua e Sela. Na tahuna e Iuda i made o Kesib, lakea e girihina i podea e Sela. ");
INSERT INTO bnp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Muri e Iuda i vulakia e Tamar ge girihine Er, e tuna a tabua. ");
INSERT INTO bnp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","A narone Er, i uka ma i kamumu na matane BAKOVI DAGI, lakea e BAKOVI DAGI i rabalakia. ");
INSERT INTO bnp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Lakea e Iuda i takia e Onan, “O mahita turana e girihine tukamu, o vakabelea vona e tuna, ge muri mai a rabune hita.” ");
INSERT INTO bnp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Pali e Onan i lohoka vona a koma bara i vakabelea, i uka ma ge tuna. Lakea na tahuna i mahita turana e girihine tukana, i guru tavulea a naruna na malala. I rata mavonga a vuhuna i koi ni vakabele a hamone tukana. ");
INSERT INTO bnp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","A naro i ratea i hale na matane BAKOVI DAGI, lakea i rabalaki tabua e Onan. ");
INSERT INTO bnp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Lakea e Iuda i takia e kana, e Tamar, “I mate pali e girihimu, o hamule lakea na ruma e tamamu, o rukua e Sela ge koru rike taro.” E Iuda i luhoi maea, “E Sela bara i parangi vona a ngatavine iea, ia tara bara i mate manga e tukana rua.” Muri e Tamar i vano, i hamule lakea na ruma e tamana. ");
INSERT INTO bnp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Muri na keva ranga, e girihine Iuda i mate, re tune Sua. E Iuda i kalo lobo vona, muri i sike o Timna, ge matai e huriki a bakovi ri pali a vuna sipsip vona. E turana, e Hira, na tanga e Adula, i sike turana. ");
INSERT INTO bnp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Lakea tara viri i takia e Tamar, “E kamu ge lakea o Timna, ge pali a vuna sipsip vona.” ");
INSERT INTO bnp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Lakea e Tamar i kali talea a mohu vona, i bolea a hineva, i kavitagua a matana, ge ratea i uka ma ni gi matakilala. I vano, i made na poridala na tanga e Enaim, na dala lakea o Timna. I rata mavonga, a vuhuna e Sela ngane i koru rike, pali e Iuda i uka ma i ratea tara ngava ne Tamar ge parangi vona. ");
INSERT INTO bnp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Na tahuna e Iuda i masia, i pahaluhoi ta ia a ngoi, a vuhuna i kavitagua a matana. ");
INSERT INTO bnp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","I uka ma i matakilalea, ge kana. Lakea i lokovonga mai ia na dahana dala, i takia, “O valai ga mahita turamu.” Lakea e Tamar i nanea, “Ga mahita turamu, a ra go habia nau?” ");
INSERT INTO bnp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","I koli mulea a nitana i ta maea, “Bara habia vomu tara meme karaba.” Lakea e Tamar i nana tabu, “O habi taroa nau tara maki, muri bara habi mulea na tahuna o bole vilia a meme.” ");
INSERT INTO bnp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","E Iuda i nana maea, “A ra maki ga habi vomu?” E Tamar i koli, i ta maea, “O habi nau a kodo vomu, turana a maki ni ru a kilakilamu vona, turana a motana.” Lakea i habi ne Tamar a maki i ngaru, muri i mahita turana, i singou. ");
INSERT INTO bnp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","I mahita turana lobo, lakea e Tamar i hamule, i kali talea a hineva i kavitagu a matana, i rodo mulea a mohu vona. ");
INSERT INTO bnp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Muri e Iuda i vakarua ne Hira a meme ge habia ne Tamar, ge bole mule a maki i habi vona. I vano, i uka ma i matavisia e Tamar. ");
INSERT INTO bnp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Lakea i nana e huriki a bakovi, ra ri made vonga, “Avia ra ngoi i made bala na dala o Enaim?” Lakea ri ta maea, “Ra hini ngi, i uka ngoi vona.” ");
INSERT INTO bnp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Lakea e Hira i hamule lakea ne Iuda, i ta maea, “I uka ma a matavisia a ngatavine, pali e huriki a bakovi vonga ranga ri ta maea, ‘Ra hini ngi, i uka ngoi vona.’” ");
INSERT INTO bnp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Lakea e Iuda i ta maea, “Ge a ra. Ge bole liu ra maki a habi vona, ma ga tu gu bole hamule bara ni nongovaki tarua. I uka maki. A vakarua pali vona a meme karaba, pali i uka ma o matavisia.” ");
INSERT INTO bnp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","A keva i tolu i lobo, ni vakalongo e Iuda, “E kamu e Tamar i ngoi viliha, ngane i singou.” Lakea e Iuda i ta maea, “Mu bole talea, mu gutua na kanono ge mate.” ");
INSERT INTO bnp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Na tahuna ni bole tala ni gi gutu, i rudu a ngava lakea ne lahuana i ta maea, “Iau a singou na bakovi i habi nau a maki nga. A maki ni ru a kilakilana a viri vona turana a motana, a kodo. Mu matakilala, a maki e rei?” ");
INSERT INTO bnp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","E Iuda i matakilala a maki nga, lakea i ta maea, “Ra ngatavine iea, i uka ngava. Iau a viri a tahoka a ngava, a vuhuna i uka ma a habia ge girihine tugu e Sela.” Muri e Iuda i uka ma i mahita turana tabu. ");
INSERT INTO bnp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Na parava ta ge poda vona ri mata­kilalea i tahoka a boge na palona. ");
INSERT INTO bnp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Na tahuna i popoda, a boge tara i toto tala muga a limana, lakea a ngatavine bolekori i bolea a hotu vururu, i kolo tatea na limana koma, i ta maea, “A koma iea ge pori taro.” ");
INSERT INTO bnp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pali a koma iea i turari mulea a limana, i pori muga a koma tara. Lakea i ta maea, “Ioe o rede, o pori muga.” Muri ni vunu e Peres. ");
INSERT INTO bnp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Muri e turana ra ni kolotata na hotu vururu a limana, i pori, ni vunu e Sera. ");
INSERT INTO bnp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","E huriki a Ismael ri turaria e Iosep i lakea o Egipto, ri habia ne Potipar i konea. E Potipar a bolekori ne Parao, a ubu na tagari na vabinga vona. ");
INSERT INTO bnp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","E BAKOVI DAGI i matakaria e Iosep, i leho kamumu kunana na ruma e Potipar. ");
INSERT INTO bnp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","E Potipar i masia i kamumu a vilona, a vuhuna e BAKOVI DAGI i laho turana, i matakaria. ");
INSERT INTO bnp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","E Potipar i masia a leho vona i vivi, i ru ia ge ia a bolekori vona. I ru ia ge matakari a ruma vona, turana a maki lobo pololilo vona. ");
INSERT INTO bnp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","E BAKOVI DAGI i gamaia e Potipar, a vuhuna i rata kamumua e Iosep, i ru ia a matakari na ruma turana a maki lobo vona. I gamai tabu a maki lobo na hania vona. ");
INSERT INTO bnp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","E Potipar i ule lakea lobo ne Iosep a maki lobo i matakari. Na tahuna e Iosep i matakari a ruma ne Potipar, e Potipar i uka ma i luhoi lege vona tara maki. A maki i luhoi kunanea, a kinani. E Iosep i mata kamumu, i koru labeka. ");
INSERT INTO bnp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","I polo a parava ranga, e girihine Potipar i masia, i masigoroa, i takia, “O valai, o mahita turagu.” ");
INSERT INTO bnp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pali e Iosep i marikoi, lakea i takia, “Iau a matakari vona a hini nga. E girihimu i habi na limagu a maki lobo na ruma. I uka ma i luhoi lege vona tara maki. ");
INSERT INTO bnp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","I uka a viri ge matakaria a ruma, iau kunana a matakaria. E girihimu i uka ma i hatekakaria nau tara maki. Ioe kunana i hatekakari iau vomu, a vuhuna ioe e girihina. Ga rata a naro hale navai na matana Vure?” ");
INSERT INTO bnp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Na parava vakaroro i ngere maia na ngava e Iosep. Pali e Iosep i marikoi hateka ni lokovonga tabukoi vona, o ni mahita turana. ");
INSERT INTO bnp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Na parava tara i dili na ruma e Iosep ge rata a leho vona. E huriki a vora na ruma, i uka ma ria pololilo. ");
INSERT INTO bnp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Lakea a ngatavine i tangotatea na varakia vona e Iosep, i takia, “O valai o mahita turagu.” Pali e Iosep i pe purua na limana ngatavine a varakia vona, i ha tala na ruma ia. ");
INSERT INTO bnp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","A ngatavine i masia a varakia i ha taroa na limana, ");
INSERT INTO bnp_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","lakea i gale e huriki a vora na ruma i ta maea, “Mata lakea, ra koma o Hibru ni bole valai na ruma ne hita. I ngaru ni ratapile hita! I valai ta ge mahita turagu, lakea a haloho iau. ");
INSERT INTO bnp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","I longo iau a haloho, i pe purua tabukoi nau a varakia vona, i ha tala na ruma ia.” ");
INSERT INTO bnp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A ngatavine i bolea a varakia ne Iosep, i davea e girihina ge hamule na tanga, ge vakasiria vona. ");
INSERT INTO bnp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Lakea i tuverei maea ne girihina, “Ra vorakato na Hibru o bole vilia na ruma tarua, i valai ta ge rata a naro hale nau. ");
INSERT INTO bnp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Na tahuna a haloho iau, i pe tabukoi nau a varakia vona, i ha tala na ruma ia.” ");
INSERT INTO bnp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Muri ne Potipar i longoa e girihina i ta maea, “Ra naro iea i rata virihi iau vona a vorakato vomu.” I madihi a hatena. ");
INSERT INTO bnp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Lakea e Potipar i ru dilia na bavi e Iosep, na hini ni ru vona e huriki ri longotaro a nita na hariki. Pali na tahuna e Iosep i made na bavi, ");
INSERT INTO bnp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","e BAKOVI DAGI i matakaria, i ratea a matakari na bavi i ngarua. ");
INSERT INTO bnp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Lakea a tagari na bavi i rua e Iosep i matakari e huriki lobo na bavi, turana a leho lobo ni rata pololilo. ");
INSERT INTO bnp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","A tagari na bavi, i uka ma i loho lege vona a leho e Iosep i rata, a vuhuna e BAKOVI DAGI i matakaria, i rata kamumu a maka leho. ");
INSERT INTO bnp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Na parava ranga muri, a vora ni ninu kilehi a vain ne Parao turana a vora ni gutu a bret vona, ru rata a naro e Parao i uka ma i ngaru. ");
INSERT INTO bnp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","E Parao i madihi a hatena vona a vora vona nga, ra matakari na vain, a matakari na bret. ");
INSERT INTO bnp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Lakea i ru dili rua na roho na ubu ne huriki a tagari, ra na bavi ni ru dili e Iosep vona. ");
INSERT INTO bnp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","A ubu na tagari i habi rua ne Iosep ge matakari. Ru made tabaka popote na bavi, ");
INSERT INTO bnp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","lakea na rodo tara ru vurena varago, pali a vurene rua i uka ma i palupulupu. A nituveve na vurene rua ranga, i uka ma i palupulupu. ");
INSERT INTO bnp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Na hatelanga e Iosep i valai mai rua, i matai rua ru loholege vona a vurene rua. ");
INSERT INTO bnp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Lakea i nana ra bakovi nga, ra ru made turana na ruma na matakari vona, “I navai muru mata matasia mavonga mona?” ");
INSERT INTO bnp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ru koli, ru ta maea, “Maria miri vurena, pali i uka tara viri koea ge tuveve polo a ngava kapiloho na vurene maria.” Lakea e Iosep i ta maea, “A Vure kunana i kara ni tuveve a nita kapiloho na vurene marua. Muru tuverei a vurena marua, ga longo.” ");
INSERT INTO bnp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Lakea a matakari na vain i tuvereia ne Iosep a vurena, “Iau a vurena vona a kai a vain, ");
INSERT INTO bnp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","i tahoka a rahana i tolu. Muri kunana na pagana i koru rike, i pura, i rara liu a kanena. ");
INSERT INTO bnp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","A bolea a kikei ne Parao, a bebe purua vona a naruna vain, muri a habia vona.” ");
INSERT INTO bnp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Muri e Iosep i tuvevea vona a vurena, “A rahana i tolu i manga a parava i tolu. ");
INSERT INTO bnp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","A parava i tolu ge lobo, e Parao bara i bole mule ioe, o leho tabu vona, o habi tabu a kikei na vain vona, i manga hosi o leho vona. ");
INSERT INTO bnp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Na tahuna o pagitala o made kamumu o luhoi iau, o rata a naro kamumu nau. O takia e Parao ge bole tala iau na bavi. ");
INSERT INTO bnp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ra iau, hosi ni turari na robo ne huriki a Hibru, ni bole valai koea. Na tahuna a made koea i uka ma ratea tara naro hale, pali ni vakamadihi tavula a kuligu, ni ru dili na bavi.” ");
INSERT INTO bnp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Na tahuna a matakari na roho na bret i longoa e Iosep i tuveve kamumu a vurena bakovi i matakari a vain, lakea i takia, “Iau tara a tahoka a vuregu: a vurena a kube a kulopi na bret i tolu. ");
INSERT INTO bnp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","A kulopi polo meli liu, i vonu vona a maka bret legelege ne Parao. Pali a maka kadirovo ri valai ri karapasi tala a bret a kube na kulopi.” ");
INSERT INTO bnp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","E Iosep i tuvevea a vurena, “A nita kapiloho na vuremu i maea: a kulopi i tolu i manga a parava i tolu. ");
INSERT INTO bnp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ge lobo a parava i tolu, e Parao bara i vakatavore ioe na kai. Muri, a maka kadirovo bara ri valai ri kania a bobomu.” ");
INSERT INTO bnp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Muri na parava i tolu, e Parao i rata a habu na parava ni poda vona, i kani turana e huriki a bolekori. I bole valai a matakari na vain, a matakari na bret, i vakapesi rua na matane huriki a bolekori vona. ");
INSERT INTO bnp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Lakea i takia a bakovi i matakari a vain ge hamule lakea na leho vona, ge habi tabu a kikei na vain ne Parao. ");
INSERT INTO bnp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pali a bakovi i matakari na bret, ni bole ni vakatavore na kai, i manga a ngava e Iosep i tuveve polo vona. ");
INSERT INTO bnp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Na tahuna a matakari na vain i pagitala, i uka ma i luhoi tabua e Iosep, i longokaburungia. ");
INSERT INTO bnp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Muri na pida i rua, e Parao i vurena ta i pepesi na dahana naru dagi e Nail. ");
INSERT INTO bnp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","I matai a bulmakau i polorua ri gavutuvutu, ri pagitala na naru, ri kani na dahane Nail. ");
INSERT INTO bnp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Muri a bulmakau i polorua ri teki ri pagitala tabu na naru dagi, ri kani na dahana naru turana a maka bulmakau ri valai muga. ");
INSERT INTO bnp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Muri ra bulmakau ri teki, ri kani a bulmakau i polorua, ri gavutuvutu. Muri e Parao i hadongo. ");
INSERT INTO bnp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","I mahita mule, i vurena tabu. I matai a paruna vit i parukaruka, i polorua, ri toto tala na vuhuna i taku. ");
INSERT INTO bnp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Muri i matai tabu a paruna vit kaka kiroko i polorua. I pori a dari pida, i kave ria ri malai. ");
INSERT INTO bnp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Lakea a kanena vit kaka kiroko ri todo a kanena kaka dagi. Muri i hadongo, i luhoi kadoa a vurena. ");
INSERT INTO bnp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Na hatelanga i loholege lae vona a vurena. Lakea i rudu a ngava lakea ne huriki a bakovi na malulu, a bakovi na lohokanga na robo e Egipto, ri gi valai vona. I tuverei ne ria a vurena, pali i uka tara viri ge tuvevea. ");
INSERT INTO bnp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","A matakari na vain i longo visia ngane e Iosep, lakea i takia e Parao, “Iau a longo visia tara ngava. ");
INSERT INTO bnp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Hosi o tahate maria a bakovi i matakari a roho na bret vomu. O rudu dili maria na ruma na ubu ne huriki a tagari vomu. ");
INSERT INTO bnp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Na rodo tara, a vurena iau. Ia tara i vurena. A vurene maria i tahoka a pelegona. ");
INSERT INTO bnp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Na tahuna iea i tahoka tara koma na Hibru i made turane maria. Ia a vorakato na matakari ne huriki a tagari na roho hariki vomu. Miri takia vona a vurene maria, lakea i tuveve polo ne maria a ngava kapiloho na vurene maria. ");
INSERT INTO bnp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Muri i bele a maki i manga a hini i tuveve polo ne maria. A bole mule a leho nau iau, pali a bakovi na bret ni vakatavore.” ");
INSERT INTO bnp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","E Parao i longoa a ngava iea, i taki e huriki a vora vona ri gi bole vilia vona e Iosep. Ri vano malaviriri kunana, ri bole talea na bavi. I pagitala i ali a karirana, i kuloi a varakia vona, muri i lakea ne Parao. ");
INSERT INTO bnp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Lakea e Parao i takia e Iosep, “Iau a vurena, i uka tara bakovi ge tuveve poloa nau a vuregu. A longo ioe ta o lohoka na ni tuveve polo a vurena viri, lakea a rudu a ngava vomu.” ");
INSERT INTO bnp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Lakea e Iosep i ta maea, “Iau a keri. Pali a Vure kunana a viri bara i tuveve poloa vomu a ngava kapiloho na vuremu.” ");
INSERT INTO bnp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Muri e Parao i tuverei poloa ne Iosep a vurena, “Iau a vurena ta a pepesi na dahana naru dagi e Nail. ");
INSERT INTO bnp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","A matai a bulmakau i polorua ri gavutuvutu, ri pagitala na naru dagi ri kani na dahana. ");
INSERT INTO bnp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Muri a bulmakau i polorua ri pagitala tabu na naru dagi. Ri teki, ri mata marango. I uka ma a matai hosi na robo o Egipto ranga bulmakau ri gi mata marango maea. ");
INSERT INTO bnp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ra maka bulmakau ri teki, muri ri todo a bulmakau gavutuvutu i polorua, ra ri pagitala muga. ");
INSERT INTO bnp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ri kani lobo, i uka ma ni matai ge lolo a kavutune ria. Ri tabana na ni teki manga a hini muga. Muri a hadongo. ");
INSERT INTO bnp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“A mahita puru tabu, a matai a maka paruna vit ri parukaruka ri toto tala na vuhuna i taku. ");
INSERT INTO bnp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Muri a matai tabu a paruna vit i polorua i uka ma ri parukaruka. I uka ma ri parukaruka, a vuhuna a dari pida i pori i kave ria ri malai. ");
INSERT INTO bnp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Lakea a maka paruna vit kaka kiroko ri todo a paruna vit kaka dagi i polorua. A vakalongo e huriki a bakovi na malulu vona a vuregu, pali ri keri ni tuveve poloa nau.” ");
INSERT INTO bnp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Lakea e Iosep i takia e Parao, “Ra vuremu nga, ru palupulupu. A Vure i vakasiria vomu a naro i popote ta ge ratea. ");
INSERT INTO bnp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ra bulmakau gavutuvutu i polorua, a paruna vit koru kamumu i polorua, i manga a pida i polorua. Ra vuremu nga, i taku kunana a ngava kapiloho vona. ");
INSERT INTO bnp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ra tekina bulmakau i polorua, ri pagitala muri, i manga a pida i polorua. Pali ra paruna malaina vit i polorua i kave ria a dari pida, ngi ranga i manga a pida i polorua. I vakasiri a pida na pago i polorua. ");
INSERT INTO bnp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","I manga a hini a taki ioe vona. A Vure i vakasiria vomu a naro bara i ratea tabukoi kunana. ");
INSERT INTO bnp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ngane a pida i polorua bara i bele kupo vomu a maki ni kani na robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Muri bara i bele a pida na pago i polorua. E huriki lobo bara ri longokaburungia a tahuna na maruanga o Egipto. A pago bara i ratapilea a robo lobo. ");
INSERT INTO bnp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","E huriki a ngatavine a bakovi bara ri longokaburungia a tahuna i vole vona a maki ni kani, a vuhuna a pago bara i madihi hateka. ");
INSERT INTO bnp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ra vuremu nga i rua, i taku kunana a pelegona, a vuhuna a Vure i luhoi mugea pali a maki ta ge ratea, tabukoi kunana. ");
INSERT INTO bnp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ngane o matakanea a bakovi maratarata ge lohoka, o rua ge matakaria a robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","O ru ranga bolekori ri gi tuhoria, ri gi matakaria a robo. Na pida i polorua na maruanga, e huriki a bolekori ri gi nagi na tabeke ge lima a maki ni kani lobo na hania. A tabeke ge taku ri gi habia na hariki, ni gi ru kadolu. ");
INSERT INTO bnp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Na pida na maruanga nga, o taki e huriki a bolekori ri gi ru dili kamumu a vit na roho dagi na maka tanga dagi. ");
INSERT INTO bnp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ra maki ni kani nga ni gi ru kamumu, bara ni kani na pida i polorua na tahuna a pago ge bele o Egipto, lakea e huriki a bakovi a ngatavine i uka ma ri gi mate na vitoloa.” ");
INSERT INTO bnp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","A ngava ne Iosep i nangi kamumu hateka ne Parao turana e huriki a bolekori vona. ");
INSERT INTO bnp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Lakea e Parao i nana e huriki a bolekori, “Si gi bolea vai tara bakovi ge manga ra bakovi iea i ta vona a hanuna Vure?” ");
INSERT INTO bnp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Lakea e Parao i takia e Iosep, “A Vure i vakasiria vomu a ngava iea. I uka tara viri ge maratarata ge lohoka manga ioe. ");
INSERT INTO bnp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ngane ga ru ioe go muga na robo e Egipto. E huriki a viri nau lobo, ri gi longototo kunanea a ngavamu. Iau kunana, a polomeli vomu, a vuhuna iau a hariki.” ");
INSERT INTO bnp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Lakea e Parao i takia e Iosep, “Masia, ngane a ru ioe o matakaria a robo e Egipto.” ");
INSERT INTO bnp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Muri i kali talea a paga na kukulimana, i vakarodoa na kukulimane Iosep. A paga iea i vakasiri a nitora ne Parao. I vakarodoa na padirodo kamumu hateka, i vakahurakia na gogo ni rata na gol. ");
INSERT INTO bnp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E Parao i habia ne Iosep a karis, ge vakanunua, a vuhuna e Iosep i paha muria. E huriki a bakovi ri nunu muga, ri gale maea, “Mu malele ha na dala.” Na naro iea kunana e Parao i rua e Iosep i matakari o Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Muri e Parao i takia e Iosep i ta maea, “Iau e Parao. A ngavagu i maea, i uka tara viri ge rata a maki na ningaru vona kunana. Ri gi nana taro ioe, muri ri gi rata a maki.” ");
INSERT INTO bnp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Lakea e Parao i vunua e Iosep e Sapenat-Panea. Muri i habia vona a ngatavine, i parangi vona. A rana e Asenat, e tune Potipera, a prister na tanga e Heliopolis. Lakea e Iosep i laho i matai lobo a maka tanga na robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Na tahuna e Iosep i tahoka a pida i ravulu tolu, i vakatubu ni leho ne Parao, a hariki o Egipto. I pea e Parao i vano i matai a tanga lobo na robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Na pida na maruanga i polorua, i koru kamumu a maki ni kani. ");
INSERT INTO bnp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Lakea e Iosep i ru palupu a maka maki ni kani. I laho na tanga lobo, i bole palupu, i ru dili na roho a maka maki ni kani. A maka hania i pesi halui a tanga tara, bara i bole a maki ni kani ne ria, i ru dili na roho dagi na tanga iea. ");
INSERT INTO bnp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","A maka vit e Iosep i ru kadolu i kupo hateka, manga a hire na dari. I keri ni gi, a vuhuna i kupo hateka. ");
INSERT INTO bnp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Muga na pida na pago, e Asenat i poda ne Iosep a koma bakovi ala rua. E Asenat e tune Potipera, a prister o Heliopolis. ");
INSERT INTO bnp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","E Iosep i vunua a tabua vona e Manase, lakea i ta maea, “A Vure i rata iau a longokaburungi a naro hale ni rata nau koea, turana a naro hale i rata nau e huriki a viri nau.” ");
INSERT INTO bnp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A paha muri tabua vona i vunua e Epraim, lakea i ta maea, “A Vure i habi a hamogu na tanga a bole a nimadihi vona.” ");
INSERT INTO bnp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","A pida na maruanga i polorua i lobo, ");
INSERT INTO bnp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","i bele ngane a pida na pago i polorua, i manga a ngava e Iosep i taki. E huriki na robo basi, ngi ranga, a pago i bele ne ria. Pali pololilo o Egipto i tahoka a maki ni kani. ");
INSERT INTO bnp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Na tahuna e huriki a Egipto ri hataki a harena pago, ri tangi lakea ne Parao ge habi a maki ni kani ne ria. Lakea e Parao i taki ria, “Mu lakea ne Iosep, mu muri mai a ngavana.” ");
INSERT INTO bnp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ngane a pago i hale hateka vonga o Egipto, lakea e Iosep i tala a maka roho ni ru kadolu a vit vona, i habi a vit ne ria, ri kona, a vuhuna a pago i hale liu. ");
INSERT INTO bnp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","E huriki na robo basi ranga ri valai o Egipto, ri kona a vit ne Iosep, a vuhuna i hale liu a pago na maka tanga lobo na malala. ");
INSERT INTO bnp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Na tahuna e Iakop i longo i tahoka a vit o Egipto, i taki e huriki e tuna, “I navai mu made mu loho tavula? ");
INSERT INTO bnp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","A longo ta i tahoka a vit o Egipto. Mu puru lokovonga, mu kona ranga, ma si gi mate na vitoloa.” ");
INSERT INTO bnp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Muri e huriki e turane Iosep ala ravulu ri puru o Egipto, ri kona a vit vonga. ");
INSERT INTO bnp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pali e Bensamin, re tarine Iosep, i uka ma i longo vona e Iakop ge vano, a vuhuna i mangenge vona ma ge bole a vuranga. ");
INSERT INTO bnp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Na tahuna e huriki ranga ri vano ri gi kona a vit, e huriki e tune Iakop ranga, ri vano turane ria, a vuhuna a pago i bele pali na robo e Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","E Iosep ngane i matakari o Egipto. I habi tala a vit ne huriki lobo ri kona. Na tahuna e huriki e turana mai ri bele, ri turume na ngalana. ");
INSERT INTO bnp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Na tahuna i matai e huriki e turana mai, i matakilala liu ria, i tami rabu ta ia a bakovi tara. Lakea i tapuhaki, i nana ria, “Ra mua, mu valai vai ngane?” Ri ta maea ria, “Mi valai na robo e Kenan, ta mi gi kona a maki ni kani.” ");
INSERT INTO bnp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","E Iosep i matakilala e tukana mai, pali ria i uka ma ri matakilalea. ");
INSERT INTO bnp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ngane i longovisia a vurena i vurena ne ria, lakea i taki ria, “Ra mua, mua a kasisi! Mu valai ni kasisi a hini i uka ma ni tagakari.” ");
INSERT INTO bnp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ri ta maea ria, “Bakovi dagi, i uka ma i mavonga. Mia a vora vomu kunana, mi valai ta mi gi kona kunana a maki ni kani. ");
INSERT INTO bnp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","E tamane mia i taku. Mia e huriki a bakovi kamumu, i uka ma mia a kasisi.” ");
INSERT INTO bnp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","E Iosep i ta maea, “I uka liu! Mu valai kunana ni kasisi a hini i uka ma ni tagakari na robo ne mia.” ");
INSERT INTO bnp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ri ta maea ria, “Bakovi dagi, mia mi ala ravulu a polona i rua, e tamane mia i taku kunana. Ngane i made o Kenan. E tarine mia i made turana. E tarine mia tara i velu pali.” ");
INSERT INTO bnp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Lakea e Iosep i taki ria tabu, “I manga a hini a taki pali. Mua e huriki a kasisi! ");
INSERT INTO bnp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ngane bara toni a ngavane mua, i muholi o i uka. E tarine mua ge valai taro, ge pesi na matagu, muri mu vano. Ge uka, muholi hateka na rana e Parao, i uka ma mu gu vano. ");
INSERT INTO bnp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mu rudua tara ne mua ge vano ge tuli vilia e tarine mua. Mua lobo bara mu dili taro na bavi, ni gi toni a ngavane mua. Muholi hateka na rane Parao, mua e huriki a kasisi!” ");
INSERT INTO bnp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Lakea i ru dili ria na bavi na parava i tolu. ");
INSERT INTO bnp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A parava i tolu i lobo, lakea e Iosep i taki ria, “Mu longo mai a ngavagu, bara mu mahuri, a vuhuna iau a bakovi na Vure. ");
INSERT INTO bnp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Pali bara mua a viri ni ta muholi, a viri ge ala taku kunana ge made na bavi. Mua lobo mu bole ra vit mu kona pali, mu bole mule mai a kabu ne mua, ra ri vitolo. ");
INSERT INTO bnp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","E tarine mua kunana mu tuli vilia nau, bara matakilaka vona a ngavane mua. Bara mu rata mavonga, i uka ma mu gu mate.” Lakea ri longo vona a nitane Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ri tango mule ria na ngava ri ta maea, “Muholi hateka, si rata halea hosi e tarina hita, ngane si bole a vuranga. Si masia i tangi, i gale hita si gi dodo ia, pali hita i uka ma si longo maia. Pali ngane a nimadihi i bele ne hita.” ");
INSERT INTO bnp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lakea e Reuben i gege tala, i ta maea, “A taki navai mua hosi? A taki mua naha ni rata halea e Iosep, pali mua i uka ma mu longo! Ra maregoa i bele ne hita ngane ne vona ni koli e tarine hita i mate.” ");
INSERT INTO bnp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","I uka ma ri lohoka vona e Iosep i longokilala a ngava ri taki, a vuhuna na tahuna i ta turane ria, a bakovi ni pulo a ngava i pulo puru a ngava vona. ");
INSERT INTO bnp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","E Iosep i longokilala a ngava ri taki, lakea i pesi gaviri i tangi. Muri i hamule i ta turane ria tabu. Lakea e Iosep i taki e huriki a vora vona, ri tangotatea e Simion, ri kolotatea na matane huriki e turana. ");
INSERT INTO bnp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Muri i taki e huriki a vora ri gi tahoni na kulopi ne ria a vit. A moni silva ri kona a vit vona ranga, ni tahoni mule takutaku na kulopi ne ria. A maki ni kani ne ria na dala ranga ni tahoni. Lakea e huriki a vora ri muri mai a ngavane Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ri ru rike na donki a maka kulopi na vit, ri vano. ");
INSERT INTO bnp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","I rodo a hini, lakea ri ru a mada. A turane ria tara i vukea a kulopi vona ge bole a maki ni kani na donki, lakea i matavisi a moni silva na ngutuna kulopi vona. ");
INSERT INTO bnp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I vakalongo e huriki a turana i ta maea, “Ra kedo silva nau ni tahoni mule na kulopi!” Na tahuna ri longo a ngava iea, i lege a lohone ria, i vuruke a tagane ria, ri gi navai, lakea ri ta maea, “A Vure i rata navai hita?” ");
INSERT INTO bnp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Na tahuna ri bele o Kenan, ri vakalongoa e tamane ria e Iakop vona a maka maregoa i bele ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ri ta maea, “Ra bakovi dagi na robo e Egipto, i tapuhaki mai mia i luhoi mia ta mia a kasisi. ");
INSERT INTO bnp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pali mi takia, mi ta maea, ‘Mia a viri ni ta muholi, i uka ma mia a kasisi. ");
INSERT INTO bnp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Mi ala ravulu a polona i rua. E tamane mia i taku kunana. I velu ne mia tara, i made turana e tamane mia o Kenan a kabina ruru.’ ");
INSERT INTO bnp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Muri ra bakovi dagi na robo e Egipto i taki mia i ta maea, ‘Ngane bara toni mua, mu ta muholi, o i uka. Ge made turagu tara. Mua lobo mu bole a maki ni kani, mu hamule mu kori e huriki a viri mua. ");
INSERT INTO bnp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Na tahuna mu hamule valai, mu tulia e tarine mua ge valai nau. Bara matakilala mua i uka ma mua a kasisi, mua a viri ni ta muholi. Muri bara habi mulea e turane mua, pali mua bara mu valai, mu vahabi, mu vakona a maki koea, na ningaru ne mua kunana.’” ");
INSERT INTO bnp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Na tahuna ri guru tala a vit na kulopi ne ria, ri matavisi a kedo silva ni tahoni mule na kulopi takutaku ne ria! Lakea ri turutu, ri mangenge. E tamane ria tara i matai a kedo silva nga. ");
INSERT INTO bnp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Muri i taki ria, “Ra mua, mu ratapile pali e tugu rua. E Iosep i velu muga, pali ngane e Simion i velu tabu. Ngane mu ngaru tabua e Bensamin ge turane mua ge pe iau. Ngane a maki lobo i uka ma i kamumu nau!” ");
INSERT INTO bnp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Muri e Reuben i takia e tamana, “Iau i uka ma ga bole mulea e Bensamin, o rabalaki e tugu ala rua. O rua na limagu ga matakaria. Muri bara bole mulea.” ");
INSERT INTO bnp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pali e Iakop i koli a nitana i ta maea, “E tugu i uka ma ge puru turane mua. I mate pali e turana. Ia kikeri i tabana. Iau a gare ngane. Ge bele vona a vuranga na dala, bara matasia liu iau, a mate.” ");
INSERT INTO bnp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ngane a pago na robo ne Kenan i dagi hateka. ");
INSERT INTO bnp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Na tahuna ri kani lobo a maki ni kani ri bole o Egipto, lakea e Iakop i taki e huriki e tuna, “Mu hamule, mu kona tabu a maki ni kani ne hita.” ");
INSERT INTO bnp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Lakea e Iuda i takia e tamana, “O tata, ra bakovi dagi o Egipto i taki tora mia, i uka ma mi gi bole lokovongea e tarine mia, i koi hateka ni matai tabu a matane mia. ");
INSERT INTO bnp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ioe bara o longo vona e Bensamin ge turane mia, bara mi puru, mi kona a maki ni kani vomu. ");
INSERT INTO bnp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ioe i uka ma go longo vona e Bensamin ge turane mia, i uka ma mi gi puru, a vuhuna a bakovi dagi vonga i taki tora mia, mi gi bole lokovongea e tarine mia, ge uka, i koi hateka ni matai a matane mateu tabu.” ");
INSERT INTO bnp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Lakea e Israel i nana, “I navai mu vakalongoa mu tahoka e tarine mua? Ngane mu vakahale a nimadegu.” ");
INSERT INTO bnp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ri koli a nitane tamane ria, ri ta maea, “Ra bakovi dagi iea i ta hinituhana, i nana na kabu ne mia i nana maea, ‘E tamane mua i tabana? I tahoka e turane mua tara?’ Lakea mia mi koli mule kunanea a ninana. Pali mia, mi gi lohoka navai vona, ia ge ta maea, ‘Mu tuli puru vilia e tarine mua?’” ");
INSERT INTO bnp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Lakea e Iuda i takia e tamana, e Israel, “E Bensamin ge turagu, mi gi vano ngane. Ge uka, hita turana e huriki a koma, bara si mate na pago. ");
INSERT INTO bnp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Iau kunana ga matakaria e Bensamin. Iau kunana bara bole a ngava vona. Iau i uka ma ga tuli mulea go masia, pali a maregoa ge rike nau, ge tabuli turagu vakaroro. ");
INSERT INTO bnp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ioe i uka ma o ta putuputu, bara mi puru balaka rua pali.” ");
INSERT INTO bnp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","E tamane ria, e Israel, i longo mavonga a ngava, lakea i taki ria, “A ngava bara i mavonga, pali bara mu rata maea. Mu tahoni na kulopi ranga maki kamumu na robo ne hita, mu bole puru na bakovi dagi, mu vakapalala a matana vona. Mu bole a maka kania kamumu: a marasin ni bole na kai, a ame, a tangari ni gale a pistasio, a almon. ");
INSERT INTO bnp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","A kedo silva mu bole ge nagu rua. Bara mu koli mule ra kedo silva ni tahoni ruru hosi na kulopi ne mua. ");
INSERT INTO bnp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ngane mu tulia e tarine mua, mu hamule mai a bakovi dagi. ");
INSERT INTO bnp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","A Vure Tuhaka ge ratea a niluhoi na bakovi dagi ge dodo mua ge vakapagetalea e turane mua tara, ge turane Bensamin, mu gu hamule valai. Pali iau ngane bara matasia, a matasia liu.” ");
INSERT INTO bnp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Lakea e huriki e turana mai ri bole a mahala, a kedo silva nagu ruarua, turana e Bensamin ri vano, ri puru o Egipto, ri bele ne Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Na tahuna e Iosep i masia e Bensamin i turane ria i takia a vora vona, “O bole lakea na ruma e huriki a bakovi nga. O rabalakia tara sipsip a bulmakau, o gutua. Na haro ri gi kani turagu.” ");
INSERT INTO bnp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Lakea a vora i muri maia a ngavane Iosep, i tuli lakea na ruma e huriki a bakovi. ");
INSERT INTO bnp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ngane ri mangenge na tahuna ni tuli lakea na ruma ne Iosep. Ri luhoi maea, “Ri tuli valai hita koea na ruma a vuhuna, na tahuna si valai muga, ni tahoni mule na kulopi ne hita a moni silva. Ngane bara ri ratapile hita, ri nugu tata hita, bara hita a vorakato ne ria. A donki ne hita ranga bara ri bole.” ");
INSERT INTO bnp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ri masia a vora ne Iosep i pesi na matana ruma, ri lakea vona, ri ta maea, ");
INSERT INTO bnp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Bakovi dagi, o longo valai taro. Hosi mi puru valai koea, mi kona a maki ni kani. ");
INSERT INTO bnp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Na tahuna mi hamule, i hapu a rodo mi rata a mada. Lakea mi lei a kulopi ne mia, mi matavisi a kedo silva ra mi kona a maki ni kani vona ni tahoni mule takutaku na kulopi ne mia. Pali ngane mi bole mule tabu ra moni silva nga. ");
INSERT INTO bnp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","A moni silva mi kona a maki ni kani vona ranga, mi bole hamule valai. I uka ma mi lohoka vona a viri i tahoni mule ruru na kulopi a moni silva. ");
INSERT INTO bnp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Lakea a vora i ta maea, “Kamumu hateka. Naha ni mangenge. A Vure ne mua, ra Vure ne tamane mua, i habi mule ne mua ra mahala ni tahoni na kulopi. Pali ra moni silva mu kona a maki ni kani vona, a bole pali.” Muri i tuli talea ne ria e Simion. ");
INSERT INTO bnp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Muri a vora i tuli e huriki a bakovi ri lakea na ruma ne Iosep. I habi a naru ne ria, ri vahilolo a vahane ria, i vakani a donki ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Na tahuna ri longoa e Iosep ge kani turane ria na haro, ri ru palupu a maka mahala ri gi habi vona. ");
INSERT INTO bnp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Na tahuna e Iosep i bele na ruma, ri habi vona a maka mahala. Lakea ri turume puru na ngalana. ");
INSERT INTO bnp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","I tagui lobo ria, muri i nana vona e tamane ria, “Avia e tamane mua, ra mu vakalongo iau vona hosi? I kamumu kunana?” ");
INSERT INTO bnp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ri ta maea ria, “E tamane mia, a vora vomu, i kamumu kunana.” Muri ri turume puru na ngalana ri kavurikea. ");
INSERT INTO bnp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Na tahuna i ta turane ria i masia ngane e Bensamin, ra ru kinana taku, lakea i nana, “Ra koma iea e tarine mua, ra mu vakalongo iau vona hosi?” Lakea i ta tabu maea, “Tugu, a Vure bara i matakari ioe.” ");
INSERT INTO bnp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","E Iosep i dodo hateka na ni masina e tarina, lakea i ha tala i pesi kapiloho na tabeke na ruma tara, i tangi. ");
INSERT INTO bnp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","I tangi lobo, muri i vahiloloa a matana. I hatenono kunana, i pagitala i taki e huriki a vora ri gi habi a maki ni kani ne huriki a bakovi. ");
INSERT INTO bnp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","E Iosep i made herehere, i kani. E huriki e turana mai ri made palupu na dede tara ri kani. E huriki a Egipto ra ri turana, ri made na tabeke tara, a vuhuna e huriki a Egipto i uka ma ri rere ni kani palupu turana e huriki a Hibru. ");
INSERT INTO bnp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","E huriki e turana mai ni vakamade muri mai a hisi ne ria, i vakatubu na tabua, i vano i harena na kabina ruru. Na tahuna i vakamade maea ria, ri turutu, ri vamatanono. ");
INSERT INTO bnp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ni veru tala na tabeke e Iosep i kani vona a maki ni kani i lakea ne ria. A maki ni kani ne Bensamin i kupo hateka, i kara a bakovi ala lima ri gi kani. Lakea ri kani, ri ninu turane Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ri kani lobo, lakea e Iosep i takia a vora i matakari a ruma, i ta maea, “O tahoni a kulopi ne huriki a bakovi ge vonu, a moni silva ranga o tahoni mule ge tabuli polomeli na ngutuna kulopi. ");
INSERT INTO bnp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","O tahoni na kulopi na koma kiroko a kedo silva, turana a kikei silva nau.” Lakea a vora i ramai a ngavane Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Na hatelanga pokopoko e huriki a bakovi ri malaga, ri vano turana a maka donki ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","I uka ma ri vano basi ma na vuhutanga, lakea e Iosep i takia a vora vona, “O nunu muri mai ria malaviriri. Na tahuna o pakarau ria, o taki ria, o ta maea, ‘Ra mua, ni rata kamumu, pali i navai mu rata hale mia? ");
INSERT INTO bnp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Avia a kikei na bakovi dagi nau? Ra kikei iea ne vona ni ninu, ni kasisi a maki kapiloho. A naro hale hateka ra mu ratea.’” ");
INSERT INTO bnp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Na tahuna i pakarau ria, i taki ria vona a ngavane Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Lakea ri ta maea, “Bakovi dagi, a ra vuhuna o taki maea mia? Mia e huriki a vora vomu i uka ma mi gi ratea a naro iea! ");
INSERT INTO bnp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","O longo valai. Na tahuna mi pe a robo e Kenan mi bole hamule valai a moni silva, ra ni tahoni puru na kulopi ne mia na tahuna mi valai muga. Pali ngane i navai mi gi panaho a moni silva, a moni gol na ruma na bakovi dagi vomu? ");
INSERT INTO bnp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Pali ngane e rei a viri ni matavisi i bolea a kikei, ni gi rabalaki. Pali mia lobo bara mia a vorakato vomu.” ");
INSERT INTO bnp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Lakea a vora i ta maea, “Kamumu hateka. Ga rata manga a hini mu taki. E rei a viri ni matavisi i bolea a kikei, ia kunana ge ia a vorakato nau. Mua lobo bara mu hamule.” ");
INSERT INTO bnp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Lakea ri vakaraga a kulopi ne ria, ri vuka. ");
INSERT INTO bnp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Lakea a vora ne Iosep i vakatubu ni lei a kulopi ne ria, i doko na tabua, i vano i harena na kabina ruru. Lakea i matavisia na kulopi e Bensamin a kikei. ");
INSERT INTO bnp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ri ngapa, lakea ri rape a varakia ne ria. Muri ri vakarike tabu na donki a galesi ne ria, ri hamule lakea na vuhutanga. ");
INSERT INTO bnp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","E Iosep i tabana na ruma na tahuna e Iuda i hamule turane huriki e tarina. Ri mangenge hateka, lakea ri tabuli puru na malala, na ngalane Iosep. ");
INSERT INTO bnp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Lakea e Iosep i nana ria, “A ra maki mu ratea? Mua, i uka ma mu lohoka nau? Iau a tahoka a malulu ne vona ni lohoka na maki kapiloho.” ");
INSERT INTO bnp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Lakea e Iuda i ta maea, “Bakovi dagi, pali a ra mi gi takia vomu? Pali mi gi ta navai? Mi gi vakasiri navai mia, ge mia a viri kamumu? A Vure ngane i taki talea a naro hale ne mia. Ngane bara mia lobo a vorakato vomu, turana a viri ni matavisi a kikei na kulopi vona.” ");
INSERT INTO bnp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Lakea e Iosep i ta maea, “I uka ma ga ratea a naro ia! E rei a bakovi ni matavisi vona a kikei, ia kunana ge ia a vorakato nau. Mua lobo bara mu laho mule kamumu ne tamane mua.” ");
INSERT INTO bnp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Lakea e Iuda i lokovonga ne Iosep i takia, “Bakovi dagi, o longo valai. Iau a vora vomu. A tahoka a ngava vomu. A lohoka vomu ioe o manga e Parao, naha ni tahate iau. ");
INSERT INTO bnp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Hosi mi valai koea, o nana maea mia, ‘Mu tahoka e tamane mua o e turane mua tara?’ ");
INSERT INTO bnp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Lakea mi ta maea, ‘E tamane mia i gare liu, i made turana na tanga e tarine mia, a bakovi. E turana, ra ru kinana taku, i mate pali. E tamane mia i ngaru hatekea ra koma iea, a vuhuna ni poda na tahuna i gare vona.’ ");
INSERT INTO bnp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Lakea ke o ta maea, ‘Mu tuli vilia nau, ga masia.’ ");
INSERT INTO bnp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Lakea mi taki ioe mi ta maea, ‘A koma i uka ma ge pea e tamana. Bara i pea, bara i mate e tamana.’ ");
INSERT INTO bnp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Lakea ke o taki mia o ta maea, ‘A bakovi kiroko i uka ma ge valai, a koi hateka ni matai mule a matane mua.’ ");
INSERT INTO bnp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Muri mi hamule, mi takia e tamane mia vona a ngava o taki mia vona. ");
INSERT INTO bnp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Lakea i ta maea, ‘Mu hamule tabu, mu kona tabu a maki ni kani ne hita.’ ");
INSERT INTO bnp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mi takia, mi ta maea, ‘Mia mi gi puru tabu, e tarine mia ge turane mia. Bara i uka, ra bakovi dagi iea, bara i koi ni matai tabu a matane mia.’ ");
INSERT INTO bnp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Lakea e tamane mia i ta maea, ‘Mu lohoka vona e kinane mua tara, i poda a koma bakovi ala rua. ");
INSERT INTO bnp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","I ha taro iau pali tara, i uka ma a matai tabua. A luhoi kunanea i rabalakia pali a livoa hateka. ");
INSERT INTO bnp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ngane mu ngaru ni bolea a viri tara ge turane mua. Ge bele vona a maki tara, bara matasia liu, bara mate.’ ");
INSERT INTO bnp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“E tamane mia i ngaru hatekea ra koma iea. Ngane ra koma iea, i uka ma ge hamule turane mia, ");
INSERT INTO bnp_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","i uka ma ge masia ge turane mia, bara mi tugu talea a nidodo vona, bara i mate. ");
INSERT INTO bnp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Iau a takia e tata, iau kunana ga matakaria, lakea a takia, ‘Iau i uka ma ga bole hamule vilia vomu a koma iea, a maregoa ge rike nau bara i madoko nau na parava vakaroro.’ ");
INSERT INTO bnp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ngane a nana ioe, ga made koea, ge iau a vorakato vomu. E tarigu ge hamule turane huriki e tukana. ");
INSERT INTO bnp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","E tarigu i uka ma ge turagu, ga hamule navai ne tata iau? Naha ni rata iau ga masia a nimadihi ge bele ne tata.” ");
INSERT INTO bnp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","E Iosep i popote ge upu tala a nangi na matane huriki a vora vona, lakea i taki ria, “Mua lobo mu pagitala taro!” E huriki a vora ri pagitala lobo, lakea e Iosep i taki tala mule ia ne huriki e turana. ");
INSERT INTO bnp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Muri i upu tala a nangi, i tangi. E huriki a Egipto ri pesi polovavo ri longoa e Iosep i tangi. E huriki lobo na roho ne Parao ri longoa a velengana. ");
INSERT INTO bnp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Lakea i vakalongo e huriki e turana, “Iau e Iosep! Avia e tata, i tabana ni mahuri?” Pali e huriki e turana ri keri ni tara­totoa, a vuhuna ri mangenge hateka. ");
INSERT INTO bnp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Muri i taki e huriki e turana, “Mu karuku valai nau.” Ri karuku valai vona, lakea i taki ria, “Iau e turane mua e Iosep. Hosi mu habi iau ne huriki a Egipto! ");
INSERT INTO bnp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ngane naha ni mangenge. Naha ni vatahate ne nau mu habi iau koea. A Vure kunana i rudu muga iau, ga kori mua. ");
INSERT INTO bnp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","A pida i rua i lakea pali, a robo lobo ri pago. A pida i lima i tabana bara i uka viri ge bole a maki ni kani na hania. ");
INSERT INTO bnp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","A Vure i rudu muga iau ne mua ga kori mua, i uka ma mu gu mate na pago. Pali ra naro i ratea ge korimule mua vona i tebi liu. ");
INSERT INTO bnp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Hosi, i uka ma i mua, mu rudu valai iau koea. A Vure kunana i rudu valai iau koea. I rata iau a manga tabu e tamane Parao. I rata iau a bakovi dagi na tabeke vona, a matakari lobo vona a robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ngane mu hamule malaviriri mai e tata, mu takia, ‘E tumu e Iosep i ta maea: a Vure i rata iau a bakovi dagi na robo e Egipto. O malaviriri kunana o puru valai nau, ");
INSERT INTO bnp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","bara o made vona a robo e Gosen, ra i tabukoi kunana nau. Ioe turane huriki e tumu, e tubumu bara mu made vona a robo iea, turana a maka kabuna sipsip a bulmakau. ");
INSERT INTO bnp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Iau bara matakari mua vonga, a vuhuna a pida i lima na pago i tabana. Bara i uka, ioe turane huriki a kabu vomu, a sipsip a bulmakau vomu, bara mu vitolo. ");
INSERT INTO bnp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ngane mua turane Bensamin, mu matai iau, i uka ma iau a viri tara a ta turane mua. Iau kunana e Iosep a ta turane mua. ");
INSERT INTO bnp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mu takia e tata iau ngane ni ru langa liu, a matakari na robo e Egipto. A maki lobo mu matai koea ranga mu vakalongoa vona. Mu vano ngane, mu tulia e tata ge puru valai malaviriri.” ");
INSERT INTO bnp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","I ta lobo, muri i rakoa e tarina e Bensamin i tangi. E Bensamin tara i rakoa i tangi. ");
INSERT INTO bnp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","I nguru, i taringi e huriki e turana lobo. Muri i ta turane ria. ");
INSERT INTO bnp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Na tahuna e Parao turane huriki a bakovi vona ri longo a velengane huriki e turane Iosep ri bele na ruma hariki vona, ri vivi hateka. ");
INSERT INTO bnp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Lakea e Parao i takia e Iosep, “O taki e huriki e turamu, ri gi rata maea. Ri gi vakarike na donki a maka popou ne mua, ri gi hamule lakea na robo e Kenan, ");
INSERT INTO bnp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ri gi tuli valai nau e tamane mua turana a kabu ne mua. Ga habi ne ria ranga malala kamumu o Egipto, ri gi leho vona ri gi vakabele a maki ni kani ge kupo. ");
INSERT INTO bnp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ngane a rudu ioe o taki ria, ri gi bole koea o Egipto ranga karis, ri gi vano ri gi vakarike e tune ria, e girihine ria. E tamane mua tara ri gi vakarikea, ge valai. ");
INSERT INTO bnp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nahea ri gi loho pae vona a maka mahala ri tahoka. Ge naha vonga ngi. Ri gi valai bara habi ne ria a maka mahala na robo e Egipto.” ");
INSERT INTO bnp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Muri e huriki e tune Israel ri muri mai a ngavane Parao, lakea e Iosep i bole a maka karis i habi ne ria. A maki ni kani na dala ranga i habi. ");
INSERT INTO bnp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","I habi takutaku ne ria a maka varakia karaba. Pali i habi ne Bensamin a varakia i lima turana a kedo silva i 300. ");
INSERT INTO bnp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","I bole a donki a toga i ravulu, i vakarike ne ria a maka mahala kamumu na robo e Egipto i vakaru ne tamana. I bole a maka vit, a bret, turana a maka kania kamumu ranga, i vakarike na donki a kinana i ravulu, i vakaru ne tamana, ge kani laho na dala. ");
INSERT INTO bnp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Muri i ru polo e huriki e turana, ri vano. Na tahuna ri malaga ri gi vano i taki ria, “Mu laho kamumu, naha ni vatahate na dala.” ");
INSERT INTO bnp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ri pea e Egipto, ri vano ri sike na robo e Kenan ne tamane ria e Iakop. ");
INSERT INTO bnp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Lakea ri takia, “E Iosep i mahuri! Muholi hateka, ngane ia a matakari o Egipto.” E Iakop i turutu. I luhoi ta ri tatami. ");
INSERT INTO bnp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pali na tahuna ri tuverei poloa vona a maka maki i taki ria vona e Iosep, i matai a maka karis ni rudu ge bolea, i kamumu ngane a niluhoi vona. ");
INSERT INTO bnp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Muri e Israel i ta maea, “Muholi hateka! E tugu i tabana ni mahuri. Ga puru ga masia, muri ga mate.” ");
INSERT INTO bnp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","E Israel i ru palupu lobo a maka mahala vona, i bole e huriki a kabu vona ri vano ri bele vona a tanga e Bersiba. Muri i bolea a sipsip a bulmakau i rabalaki, i habi na Vure ne tamana e Isak. ");
INSERT INTO bnp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Na rodo i vurena vona a Vure i bele vona i galea, “Iakop! Iakop!” E Iakop i ta maea, “Iau ieni.” ");
INSERT INTO bnp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Lakea a Vure i ta maea, “Iau a Vure, a Vure ne tamamu. Naha ni mangenge ni puru o Egipto. Ga rata ioe ge ioe a vuhuna kabu dagi tara. ");
INSERT INTO bnp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ga puru turamu o Egipto, muri ga taparaki mule ioe. Na tahuna o mate, e Iosep ge tanu ioe.” ");
INSERT INTO bnp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","E huriki e tune Israel, ri vakarike na karis e tamane ria turana e huriki e tune ria, e girihine ria. A maka karis nga, i rudu sike e Parao, ge bole ria. Ngane e Iakop i pea e Bersiba. ");
INSERT INTO bnp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ri vakamariu lakea o Egipto a maka sipsip a bulmakau, a mahala ra ri vakabele o Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","E Iakop i mariu lakea o Egipto turana e huriki e tuna bakovi, e tuna ngatavine, e tubuna mai. ");
INSERT INTO bnp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","A rane e huriki a hamone Israel ri puru o Egipto ra nga: E Iakop turana e Reuben, a tabua vona. ");
INSERT INTO bnp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","E huriki e tune Reuben a bakovi ra nga: e Hanok, e Palu, e Herson, e Karmi. ");
INSERT INTO bnp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","E huriki e tune Simion a bakovi ra nga: e Iemuel, e Iamin, e Ohad, e Iakin, e Sohar, e Saul. E Saul, e kinana a ngatavine o Kenan. ");
INSERT INTO bnp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","E huriki e tune Levi a bakovi ra nga: e Gerson, e Kohat, e Merari. ");
INSERT INTO bnp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","E huriki e tune Iuda a bakovi ra nga: e Er, e Onan, e Sela, e Peres, e Sera. E Er rua e Onan ru mate na robo e Kenan. E tune Peres a bakovi ra nga: e Hesron, e Hamul. ");
INSERT INTO bnp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","E huriki e tune Isikar a bakovi ra nga: e Tola, e Puva, e Iob, e Simron. ");
INSERT INTO bnp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","E huriki e tune Sebulun a bakovi ra nga: e Sered, e Elon, e Ialil. ");
INSERT INTO bnp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","E huriki tune Iakop nga i poda e Lea o Padan-Aram. E Daina e kurabane ria, ia tara ni poda vonga. E huriki a hamone Iakop rua e Lea ri ala ravulu tolu a polona i tolu. ");
INSERT INTO bnp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","E huriki e tune Gad a bakovi ra nga: e Sipion, e Hagi, e Suni, e Esbon, e Eri, e Arodi, e Areli. ");
INSERT INTO bnp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","E huriki e tune Aser a bakovi ra nga: e Imna, e Isva, e Isvi, e Beria. E kurabane ria a rana e Sera. E tune Beria a bakovi ra nga: e Heber e Malkiel. ");
INSERT INTO bnp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Re huriki nga ri ala ravulu a polona i polotara, a hamone Iakop rua e Silpa. Ra ngatavine iea, e Leban i habia ne Lea, ga vorakato vona. ");
INSERT INTO bnp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","E Iosep e Bensamin, e kinane rua e Resel, re girihine Iakop tara. ");
INSERT INTO bnp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Na tahuna e Iosep i made o Egipto, i parangi vona e Asenat, e tuna prister tara a rana e Potipera na tanga e Heliopolis. E Asenat i poda e Epraim rua e Manase. ");
INSERT INTO bnp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","E huriki e tune Bensamin a bakovi: e Bela, e Beker, e Asbel, e Gera, e Naman, e Ehi, e Ros, e Mupim, e Hupim, e Ard. ");
INSERT INTO bnp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Re huriki a bakovi nga, a hamone Iakop rua e Resel, ri ala ravulu a polona i va. ");
INSERT INTO bnp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","E tune Dan a bakovi i taku kunana. A rana e Husim. ");
INSERT INTO bnp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","E huriki e tune Naptali a bakovi: e Iasiel, e Guni, e Ieser, e Silem. ");
INSERT INTO bnp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Re huriki a bakovi nga, a hamone Iakop rua e Bila, ra ngatavine e Leban i habia ne Resel ga vora vona. Ni gi palupu, ri ala polorua. ");
INSERT INTO bnp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","E huriki a hamone Iakop, ra ri lakea o Egipto, ri ala ravulu polo tara a polona i polotara (66). I uka ma ni gi e huriki e girihine ria. ");
INSERT INTO bnp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ni gi turane tune Iosep ala rua ra ni poda o Egipto, ria lobo ri ala ravulu polo rua (70). ");
INSERT INTO bnp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","E Iakop i rudua e Iuda ge muga ge takia e Iosep ge tagui ria o Gosen. Na tahuna ri laho lokovonga na robo e Gosen, ");
INSERT INTO bnp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","e Iosep i bolea a karis vona, i lakea o Gosen, ge taguia e tamana, re Israel. Na tahuna i masia e tamana, i rakoa i mate ni taringia. ");
INSERT INTO bnp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Lakea e Israel i takia e Iosep, “Ngane iau ga mate, a vuhuna a matai ioe pali, o tabana ni mahuri.” ");
INSERT INTO bnp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Muri e Iosep i taki e huriki e turana, a kabu vona, i ta maea, “Ga lakea ne Parao ga takia ga ta maea, ‘E huriki e turagu, a kabu nau, ra ri made na robo e Kenan, ri valai pali. ");
INSERT INTO bnp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","E huriki a bakovi nga ri matakari a sipsip. Ri bole valai ngane a kabu na sipsip, a bulmakau, a maka mahala lobo ne ria.’ ");
INSERT INTO bnp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Na tahuna e Parao ge gale dili mua ge nana na a ra leho mu lohoka vona, ");
INSERT INTO bnp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mu ta maea, ‘Bakovi dagi, mi matakari a sipsip a bulmakau na tahuna mi kiroko vona i valai i harena mona. I manga a leho i rata e tamane mia muga.’ Muri bara i longo vona a robo e Gosen bara mu made vona, a vuhuna e huriki a tahotanga ri marikoi hateka ni made turana e huriki ri matakari a sipsip.” ");
INSERT INTO bnp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Lakea e Iosep i vano i vaka­longoa e Parao i ta maea, “E tata turane huriki e turagu ri pea a robo e Kenan, ri bele pali na robo e Gosen. Ri valai turana a kabuna sipsip, a bulmakau, a mahala lobo ri tahoka.” ");
INSERT INTO bnp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","I vulaki e turana ala lima i vakasiri ria ne Parao. ");
INSERT INTO bnp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Lakea e Parao i nana ria, “A ra leho mu lohoka na niratana?” Ri ta maea ria, “Bakovi dagi. A leho mi lohoka vona, ni matakari a sipsip, i manga a leho i rata e tamane mia muga. ");
INSERT INTO bnp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Mi valai mi gi made tamilalu koea, a vuhuna a pago i hale hateka na robo e Kenan. A maka sipsip ne mia, i uka liu a varili ri gi kani. Pali ngane, o longo mai mia, mi gi rata a tanga na robo e Gosen.” ");
INSERT INTO bnp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Lakea e Parao i takia e Iosep, i ta maea, “E tamamu, e turamu mai ri valai vomu. ");
INSERT INTO bnp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","A robo e Egipto ioe o matakaria. O matai a malala ge kamumu hateka, o vakamade vona e tamamu, e turamu mai. O vakamade ria o Gosen. A bakovi maratarata, o ru ge matakari a sipsip a bulmakau nau.” ");
INSERT INTO bnp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Muri e Iosep i tuli dilia e tamana i vaka­siria ne Parao. E Iakop i taguia i gamai e Parao, ");
INSERT INTO bnp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","lakea e Parao i nanea, “I riva a pida vomu?” ");
INSERT INTO bnp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","I ta maea ia, “A pida a laho viliha lae vona i 130. A pida nga i uka ma i kupo. Pali a bole a nimadihi hateka ne ria, i uka ma i manga a pida ne huriki a gare nau hosi i kupo hateka.” ");
INSERT INTO bnp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ru vata lobo, lakea e Iakop i gamaia e Parao. Muri i pagitala. ");
INSERT INTO bnp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","E Iosep i vakamadea e tamana, e huriki e turana o Egipto. I habi ne ria a malala kamumu ri leho vona na robo e Remeses, i manga a hini i taki e Parao. ");
INSERT INTO bnp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Muri e Iosep i bole a maki ni kani i habi tabu ne tamana, e huriki e turana, e huriki lobo, ra ri valai turane tamana. A maki ni kani ni habi muri mai a naguna koma ri tahoka. ");
INSERT INTO bnp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","A pago i kara hateka, i ratapile a robo e Egipto e Kenan, i uka maki ni kani. ");
INSERT INTO bnp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","E Iosep i ru kadolu a maka moni ra ri kona a vit vona e huriki a Egipto a Kenan, i bole lakea na ruma dagi e Parao. ");
INSERT INTO bnp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Na tahuna i lobo a moni ne ria e huriki a Egipto a Kenan, lakea e huriki a Egipto ri valai ne Iosep ri ta maea, “O habi mia ranga maki ni kani. I navai mi gi mate na matamu? A moni ne mia i lobo liu pali.” ");
INSERT INTO bnp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Lakea e Iosep i ta maea, “Mu bole valai a maka sipsip a bulmakau ne mua, si gi vangoli. Ga habi ne mua a maki ni kani, mu habi nau a sipsip a bulmakau ne mua, a vuhuna i lobo liu pali a moni ne mua.” ");
INSERT INTO bnp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Lakea ri habi ne Iosep a maka sipsip a bulmakau, lakea i habi ne ria a vit. Ri bole valai a hos, a sipsip, a bulmakau, a meme, a donki ra ri habi valai vona. Na pida iea i kori ria na maki ni kani, a vuhuna ri bole valai vona a maka sipsip a bulmakau. ");
INSERT INTO bnp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","I lobo a pida iea, ri valai tabu na pida muri, ri ta maea, “Bakovi dagi, i uka ma mi gi ta kapiloho vomu. I lobo liu pali a moni ne mia, a sipsip a bulmakau mi habi lobo vomu. I uka ranga maki ge tabana mi gi habi vomu. A malala, a kakaine mia kunana i tabana. ");
INSERT INTO bnp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Naha ni matataro mia mi gi mate na vitoloa, a malala mia ranga i hale liu. O matakari mia na maki ni kani, pali mia ge mia a vorakato vomu. A malala ne mia ranga o kona. O habi ne mia a vutuna vit mi gi varo, i uka ma mi gi mate. A malala ranga i uka ma ge hale ge manga a tabeke i ngeki.” ");
INSERT INTO bnp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Lakea e Iosep i kona lobo a malala o Egipto i habi ne Parao. E huriki lobo o Egipto ri habi a malala ne ria ni kona, a vuhuna a pago i hale hateka. A malala lobo o Egipto ne vona e Parao kunana. ");
INSERT INTO bnp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","E huriki lobo o Egipto ria a vorakato vona. ");
INSERT INTO bnp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","E huriki a prister kunana e Parao i uka ma i kona a malala ne ria, a vuhuna i habi vakaroro a maki ni kani ne ria. Lakea i uka ma ri habi ni gi kona a malala ne ria. ");
INSERT INTO bnp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","E Iosep i taki e huriki i ta maea, “Muholi hateka, a kona mua turana a malala, ngane mua lobo a vorakato ne Parao. Mu bole a vutuna vit, mu varo na hania. ");
INSERT INTO bnp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Na tahuna ni mirio, mu kalipida na tabeke ge lima, mu habi ne Parao a tabekena tara. Ra a tabekena nga i va i tabana, mu varo a vutuna ranga, mu bole ranga ge kani e tune mua, a kabu ne mua.” ");
INSERT INTO bnp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Lakea ri ta maea, “Bakovi dagi, kamumu hateka o kori mia. Ngane bara mia a vorakato ne Parao kunana.” ");
INSERT INTO bnp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","I vakatubu na tahuna iea, e Iosep i rua o Egipto a vinara na malala. A vinara i maea, “A maka maki ni varo na hania ni gi ru na naguna ge lima. A naguna ge taku ni gi habi ne Parao. A naguna i va ge bole a tahona.” Ra vinara vona i tabana ni ramai mona. A malala ne huriki a prister kunana, e Parao i uka ma i bole. ");
INSERT INTO bnp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","E huriki a Israel ri rata a tanga na robo e Gosen vonga o Egipto. Ri bole a malala ri leho vona, ri tahoka a mahala i kupo. A hamone ria ranga i vakatubu ni bele kupo. ");
INSERT INTO bnp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","E Iakop i made o Egipto na pida i ravulu a polona i polorua. A pida vona lobo i 147. ");
INSERT INTO bnp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Na tahuna i popote ge mate, i galea e tuna e Iosep i takia, i ta maea, “Ioe o ngaru hateka iau. O ru polotanoa na labugu a limamu, o ta muholi o longo mai iau, o rata kamumu iau. Naha ni tanu iau o Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","O kaloho tala iau koea o Egipto, o tanu iau, turana e huriki a gare nau mai, na hini ni tanu ria vona.” E Iosep i koli mule, i ta maea, “Bara rata manga a hini o taki.” ");
INSERT INTO bnp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Lakea e Iakop i ta maea, “O ta muholi nau.” ");
INSERT INTO bnp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Muri na parava ranga ni vaka­longo maea e Iosep, “E tamamu i giloa.” Lakea i tuli e tuna rua, e Manase e Epraim, to go masia. ");
INSERT INTO bnp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Na tahuna e Iosep i bele, ri takia e Iakop, ri ta maea, “E tumu e Iosep i valai ge matai ioe.” Lakea e Israel i makali kamumu, i made rike na kiri. ");
INSERT INTO bnp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Muri i takia e Iosep i ta maea, “A Vure Tuhaka i bele nau na tanga e Lus, na robo e Kenan i gamai iau vonga, ");
INSERT INTO bnp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","i ta maea, ‘Ga rata ioe go tahoka a maka maki, ge bele kupo a hamomu. Ga vakamade palupu e huriki a hamomu ga habia ne ria a malala ge vona e ria liu muri ma.’ ");
INSERT INTO bnp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","E tumu e Epraim rua e Manase, ra ni poda koea o Egipto muga ne iau a valai koea, ngane ga pau, ge nau. Bara ru manga e Reuben rua e Simion ra rua e tugu. ");
INSERT INTO bnp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","E huriki a koma o vakabele muri ne rua ne vomu ngi. Na tahuna ri vaveru a malala takutaku ne ria, e huriki a koma nga bara ri pesi muri ne Epraim e Manase. ");
INSERT INTO bnp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Na tahuna a hamule o Padan, a dodo hatekea e kinamu e Resel i mate tabukoi o Eprata na robo e Kenan. Lakea a tanu tabukoi ia na dala lakea o Eprata, re Betlehem.” ");
INSERT INTO bnp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Na tahuna e Iakop i matai e tune Iosep ala rua, i nana, “E rei a koma nga?” ");
INSERT INTO bnp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Lakea e Iosep i vakalongoa e tamana i ta maea, “Ra koma nga, e tugu a bakovi i habi nau a Vure koea.” Lakea e Iakop i ta maea, “O bole valai nau, ga gamai rua.” ");
INSERT INTO bnp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","E Israel i kepa, i uka ma i matai kamumu a maki, a vuhuna i gare. Lakea e Iosep i vakapesi tabukoi ne Iakop e tuna rua, lakea e Israel i rako i nguru rua. ");
INSERT INTO bnp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Muri e Israel i takia e Iosep i ta maea, “A luhoi i uka ma ga matai tabu a matamu, pali ngane a Vure i tuhori iau, a matai ioe turane tumu rua.” ");
INSERT INTO bnp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Muri e Iosep i tuli tala rua na vahane Israel, i lolu puru na ngalane tamana, i padoi a malala a gina. ");
INSERT INTO bnp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Muri e Iosep i tulia e Epraim, i laho lokovoga na maurina e Israel, i tulia e Manase i laho lokovonga na limana kanena e Israel. ");
INSERT INTO bnp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pali e Israel i toto vahau a limana. I nugua na limana kanena a gine Epraim ra viri i pahamuri a tabua, i nugua na limana maurina a gine Manase a tabua. ");
INSERT INTO bnp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Lakea i gamaia e Iosep i ta maea, “A Vure ne sisi e Abraham, ne tata e Isak, i matakari iau na parava vakaroro i valai i harena mona. ");
INSERT INTO bnp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","I bele manga a agelo i kori iau na maki hale, ge gamai a koma nga. Ge rata a hamone rua ge bele kupo. Muri bara ri luhoi a ragu, a rane tata e Isak, e sisi e Abraham.” ");
INSERT INTO bnp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Na tahuna e Iosep i masia e tamana i ru langa a limana a kanena na gine Epraim, i marikoi, lakea i bolea a limane tamana i kalia na gine Epraim ge lakea na gina e Manase. ");
INSERT INTO bnp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Lakea e Iosep i takia e tamana i ta maea, “O tata, i uka ma ge mavonga. A tabua ra iea, o ru langea na gina a limamu a kanemu.” ");
INSERT INTO bnp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pali e tamana i koi, i ta maea, “O tugu, a lohoka vona a hini ngi. A lohoka vona e huriki a hamona bara ri kupo. Pali a hamone tarina bara ri ala kupo hateka, ge manga e huriki a kabu ri ala kupo, ri vadili vapopo.” ");
INSERT INTO bnp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Na parava iea, e Israel i gamai rua i ta maea, “Na tahuna e huriki a kabu ne Israel, ri ngaru ni gamai a viri, bara ri ta maea, ‘A Vure ge matakari ioe i manga a hini i matakari e Epraim rua e Manase.’” Na naro iea kunana, i ru mugea ne Manase e Epraim. ");
INSERT INTO bnp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Muri e Israel i takia e Iosep, i ta maea, “Iau a tabukoi ga mate. Pali a Vure ge turamu ge bole hamule ioe na robo ne huriki a gare vomu. ");
INSERT INTO bnp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ioe kunana, naha e huriki e turamu, ga habia vomu a robo a bolea ne huriki a Amor na tahuna a vaubi turane ria na bainat, na kiniperi nau.” ");
INSERT INTO bnp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Muri e Iakop i gale palupu e huriki e tuna, i ta maea, “Mu valai ga taki mua vona a maki bara i bele ne mua muri ma. ");
INSERT INTO bnp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Mua o huriki e tune Iakop, iau e Israel e tamane mua, a ngaru mua mu gu vapopo, mu gu longo a ngava ga taki mua vona: ");
INSERT INTO bnp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“O Reuben, ioe a tabua nau. A vakabele ioe na tahuna a riau, a tuhaka vona. O tero o gao hateka ne huriki e tugu. ");
INSERT INTO bnp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Pali ioe a raha. Ngane i uka ma go muga tabu, a vuhuna o mahita turane girihigu tara, o rata halea a kiri nau i katoki. ");
INSERT INTO bnp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“O Simion o Levi muru kinana taku, a bainat a lebo marua. ");
INSERT INTO bnp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Iau i uka ma ga ta turane marua kapiloho. Iau i uka ma ga made turane marua na vaponga, a vuhuna na tahuna muru tahate, muru rabalaki a bakovi. A bulmakau ranga muru ubiputu a vahane ria i manga a rihiva marua. ");
INSERT INTO bnp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ngane a ruduraha marua, a vuhuna muru hini hatena. E huriki a hamone marua bara ri made viliha turana a kabu ne Israel. ");
INSERT INTO bnp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“O Iuda, e huriki a turamu bara ri kavurike rike a ramu. Ioe bara o hori a lohone huriki a pile vomu. E huriki a turamu bara ri lolu puru na matamu. ");
INSERT INTO bnp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O Iuda, ioe o manga a tuna laion, i lakavu a kania, i hamule na murina, i mahita i po a kanimatana. I uka a viri ge kinikoi ia. ");
INSERT INTO bnp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","A kodo-hariki i tabuli na limamu, bara o matakari vakaroro, i harena na tahuna o bele na tanga e Silo, o matakari e huriki ala kupo. ");
INSERT INTO bnp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","A Vuhuna Iuda, a maka kaina vain vona i kupo. Bara o kolo tata a donki vomu na rahana, o loi a varakia vomu na naruna. ");
INSERT INTO bnp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A Vuhuna Bara o ninu hateka a vain, i vururu a matamu, o ninu hateka a namona ruru, a ngimu bara i kea manga a ruruna bulmakau. ");
INSERT INTO bnp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","A Vuhuna “E Sebulun, bara i made tabukoi na dari, a roa vona, bara i tahoka a bala kamumu na girimo ge pasi vona, a robo vona bara i harena o Sidon. ");
INSERT INTO bnp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","A Vuhuna “E Isikar, i gao manga a donki, pali i mahita turana a popou vona. ");
INSERT INTO bnp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A Vuhuna Bara i masia a malala i kamumu, i ngarua ge made vona. Muri bara ia a vorakato, i rata a leho dagi. ");
INSERT INTO bnp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“E Dan, ia ra kabu, bara i matakari e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","E Dan, i manga a mata hale i tabuli na dahana dala. Na tahuna a hos i nunu valai, bara i to tala, i kara tatea a vahana, i boru a bakovi i made na hos. ");
INSERT INTO bnp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O BAKOVI DAGI, a ngaru ioe go kori iau. ");
INSERT INTO bnp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“E Gad, e huriki a panaho, bara ri valai ri vaubi turana, pali bara i gege ria i lili mule ria. ");
INSERT INTO bnp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“E Aser, a malala vona bara i vakabele a maki ni kani kamumu, i kara ge kani a hariki. ");
INSERT INTO bnp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“E Naptali, i manga a kinana dia i laho viliha, i vakabele e tuna ri mata kamumu. ");
INSERT INTO bnp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“E Iosep i manga a kai a vain i pesi tabukoi na lomu, i kupo a kanena. A rahana i kupo i rako rike na nure. ");
INSERT INTO bnp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","E huriki ri vaubi na kiniperi ri gao hateka, bara ri valili ia ri vaubi turana. ");
INSERT INTO bnp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pali bara i nugu tata torea a kiniperi vona, a vuhuna a limana i vaga hateka, na nitora na Vure Tuhaka Hateka ne Iakop, a Matakari, a Kedo ne Israel. ");
INSERT INTO bnp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","A Vure Tuhaka ne tamamu ge matakari ge gamai ioe. Bara i rudu vilia vomu na hunu a vala, i rata a naru ri gi bele kupo na malala; i rata e huriki a ngatavine na kabu vomu ri vakabele a koma i kupo. ");
INSERT INTO bnp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","A Vuhuna Iau e tamamu a ngaru ioe, ge maragisi vomu a maki lobo. A maki kamumu a ngaru go bole bara i bele kupo bara ri kavitagu a maka lolo. Iosep, a maki lobo bara ri tabuli na limamu, a vuhuna ioe a bakovi dagi ne huriki e turamu lobo. ");
INSERT INTO bnp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","A Vuhuna “E Bensamin i manga a kaugara i rabalaki a kania. Na hatelanga i kani a maki i rabalaki. Na malunga i veru a maki i kani kaleva.” ");
INSERT INTO bnp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Re huriki nga, a kabu i ravulu a polona i rua ne Israel. Ra maka ngava nga, e Iakop i taki virihi ria vona na tahuna i gamai takutaku ria. ");
INSERT INTO bnp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Muri e Iakop i tarulu mule e huriki e tuna, i ta maea, “Iau a tabukoi ga mate. A ngaru mua mu gu tanu iau na dahana e huriki a gare nau, na babe na malala e Epron, a bakovi o Hiti. ");
INSERT INTO bnp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ra babe iea i tabuli na malala e Makpela tabukoi o Mamare, na robo e Kenan. Ra babe iea turana a malala, e Abraham i kona ne Epron, a bakovi o Hiti. ");
INSERT INTO bnp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","E tamarane mua e Abraham e Sara, e tubune mua e Isak e Rebeka, e kinane mua e Lea ni tanu vonga. ");
INSERT INTO bnp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ra babe iea turana a malala, ni kona na kabu ne Hiti.” ");
INSERT INTO bnp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Na tahuna e Iakop i tarulu lobo ria, i karuku lakea na kiri vona, i mahita puru. Muri i taravango a nilobona bangona i mate, i vano i made turana e huriki a viri vona ri mate pali. ");
INSERT INTO bnp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Na tahuna e Iosep i masia e tamana i mate, i mahita rike vona, i ngurua i taringia. ");
INSERT INTO bnp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Muri i taki e huriki a dokta ri gi ru a marasin vona a podane Israel, i uka ma ge mavuru malaviriri. Lakea ri rata manga a hini i taki. ");
INSERT INTO bnp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ra leho ni ru a marasin na podana viri mate bara i bole a parava i ravulu va. A podane Israel tara ni ru a marasin vona na parava i ravulu va. E huriki a Egipto ri taringia e Israel na parava i ravulu polorua. ");
INSERT INTO bnp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Muri i lobo a parava na nitangi, lakea e Iosep i takia a bolekori ne Parao i ta maea, “Ioe o ngaru iau, o bolea a ngava nau o vakalongo e Parao vona, o ta maea, ");
INSERT INTO bnp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Na tahuna e tata i popote ge mate, i takia e Iosep ge ta muholi na matana, i ta maea, “Iau a tabukoi ga mate. O tanu iau na babe a keli purua na robo e Kenan.” Ngane a ngaru ni sike ga tanua e tata, muri ga hamule valai.’” ");
INSERT INTO bnp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","E Parao i longo vona a ngavane Iosep, lakea i ta maea, “O sike o tanua e tamamu, a vuhuna o kaba na matana pali.” ");
INSERT INTO bnp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Lakea e Iosep i sike i tanua e tamana, turane huriki a bolekori, a bakovi dagi ne Parao, e huriki a bakovi dagi lobo na robo o Egipto. ");
INSERT INTO bnp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","E huriki a kabu ne Iosep, e huriki e turana mai, turane huriki a kabu ne tamana, ria lobo ri vano. E huriki a koma kunana ri made mule turana a maka kabu na sipsip, a bulmakau na robo e Gosen. ");
INSERT INTO bnp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","E huriki a bakovi ri rike na karis na hos, ngi ranga ri sike turana. I kupo hateka e huriki ri vano turana. ");
INSERT INTO bnp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Na tahuna ri bele o Atad, tabukoi o Iordan, ri upu tala a nangi. E Atad a tanga na ni vilatala a vinina vit. Ri vapopo vonga na parava i polorua, ri taringia vonga e tamana. ");
INSERT INTO bnp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","E huriki a Kenan ri matai ria, ri vapopo o Atad, ri ta maea, “E huriki a Egipto ri vapopo ri rata runga na viri mate.” Lakea ni gale liu ra tanga i tabukoi na naru dagi e Iordan, e Abel-misraim. ");
INSERT INTO bnp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","E huriki e tune Iakop ri muri mai kunanea a ngava e Iakop i tarulu mule ria vona. ");
INSERT INTO bnp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ri bole lakea na robo e Kenan, ri tanua na babe na malala e Makpela, tabukoi o Mamare. Ra babe turana a malala, e Abraham i kona ne Epron, a bakovi o Hiti. ");
INSERT INTO bnp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Muri ne Iosep i tanu loboa e tamana, i hamule puru o Egipto turana e huriki e turana. E huriki lobo ri do rikea, ria ranga ri hamule puru. ");
INSERT INTO bnp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Na tahuna e tamane ria i mate, lakea e huriki e turana ri ta maea, “Si gi navai ngane? E Iosep ma ge koli a naro hale si ratea vona hosi.” ");
INSERT INTO bnp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Lakea ri talo rike a ngava ne Iosep, ri ta maea, “Na tahuna e tamane hita i popote ge mate, i tarulu mule mia, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Mu takia e Iosep, ge longokaburungi a naro hale mu rata virihia vona hosi.’ Ngane, mi ngaru ni nana ioe go longokaburungi a naro hale ne huriki a vora na Vure ne tamamu.” Na tahuna e Iosep ni vakalongo vona a ngava ne turana mai, i tangi. ");
INSERT INTO bnp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Muri ri lokovonga, e huriki e turana mai ri turume puru na matana, ri ta maea, “Mia ngane bara mia a vorakato vomu.” ");
INSERT INTO bnp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pali e Iosep i ta maea, “Naha ni mangenge, iau, i uka ma iau a Vure. ");
INSERT INTO bnp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Hosi mu ngaru ni ratapile iau, a vuhuna a Vure i ngaru mua mu gu rata mavonga. Muri a valai a made koea, a kori e huriki ala kupo. ");
INSERT INTO bnp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Pali ngane, naha ni mangenge, a vuhuna bara matakari mua, turane huriki e tune mua.” Lakea e Iosep i luke mule ria, i pasi valo puru a hatene ria. ");
INSERT INTO bnp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","E Iosep i made o Egipto turane huriki a kabu ne tamana. I tahoka a pida i 110 i mate. ");
INSERT INTO bnp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Na tahuna e Iosep i mahuri, e Epraim i vakabele e huriki e tuna, e tubuna. E tune Manase, a rane Makir, i vakabele e huriki e tuna, lakea e Iosep i pau ria. ");
INSERT INTO bnp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Muri e Iosep i taki e huriki e turana, i ta maea, “Iau a tabukoi ga mate. Pali a Vure ge matakari mua. Muri bara mu ha taroa a robo iea, mu sike lakea na robo a Vure i vakasiria, i ta muholi vona ge habia ne Abraham, e Isak, e Iakop.” ");
INSERT INTO bnp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Muri e Iosep i taki e huriki e tune Israel bakovi ri gi kaba vona a nita muholi. A nita muholi i maea, “Na tahuna a Vure ge valai ge korimule mua, mu bole tala koea a maka tuhagu, mu kaloho sike turane mua.” ");
INSERT INTO bnp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","E Iosep i tahoka a pida i 110, muri i mate. Ni ru a marasin na podana, i uka ma ge mavuru malaviriri. Muri ni kapo, i tabuli vonga o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","E huriki e tune Israel turana a kabu ne ria ri puru o Egipto turane Iakop ra nga, ");
INSERT INTO bnp_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","e Reuben, e Simion, e Levi, e Iuda, ");
INSERT INTO bnp_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","e Isikar, e Sebulun, e Bensamin, ");
INSERT INTO bnp_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","e Dan, e Naptali, e Gad, e Aser. ");
INSERT INTO bnp_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","E Iosep i lokovonga muga. Na tahuna iea e huriki a hamone Iakop ri ala ravulu polorua. ");
INSERT INTO bnp_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Muri e Iosep, e turana mai, e huriki a hulu turana ri mate. ");
INSERT INTO bnp_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Pali e huriki a hamone Israel ri bele kupo, ri gao hateka, ri bele kupo o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Muri na pida i kupo a hariki karaba i matakari o Egipto. Ra hariki iea i uka ma i lohoka ne Iosep. ");
INSERT INTO bnp_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Lakea i taki e huriki a viri vona, “E huriki a Israel ri bele kupo, ri rangi hita. ");
INSERT INTO bnp_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","A vabinga tara bara i bele, bara ri taga turane huriki a pile, ri vaubi turane hita. Muri bara ri ha taroa a robo ne hita, ri vano. Si gi matakanea tara dala si gi rata ria nahea ri gi ala kupo hateka.” ");
INSERT INTO bnp_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Lakea e huriki a Egipto ri taki e huriki a matakari ri gi vakuku e huriki a Israel ri gi leho hateka. Ri rata a tanga dagi i rua e Pitom, e Rameses ne vona ni ru kadolu a maki ni kani ne Parao. ");
INSERT INTO bnp_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","E huriki a Egipto ri ratapile e huriki a Israel. Pali e huriki a Israel ri tababana ni bele kupo, lakea e huriki a Egipto ri mangenge ne ria, ");
INSERT INTO bnp_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ri rata ria ri leho hateka. ");
INSERT INTO bnp_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","A nimade ne ria ngane i hale liu, a vuhuna i uka ma ri malo. Ri vakuku ria ri gi rata a brik ne vona a ruma. Ri vakataki ria, ri gi leho hateka na hania, i uka ma ri dodo ria. ");
INSERT INTO bnp_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Na parava tara a hariki ne Egipto, e Parao, i taki a ngatavine o Hibru, e Sipra e Pua, a leho ne rua ni tuhori e huriki a ngatavine ni poda, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Na tahuna muru tuhoria tara ngatavine o Hibru ge poda a koma bakovi, muru rabalakia a koma. A ngata­vine ge poda a koma ngatavine, naha ni rabalakia a koma.” ");
INSERT INTO bnp_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pali ra ngatavine nga ru mangenge na Vure, i uka ma ru ramaia a nitana hariki, i uka ma ru rabalaki e huriki a koma bakovi. ");
INSERT INTO bnp_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Lakea a hariki i gale valai tabu a ngatavine nga, i nana rua, “I navai i uka ma muru ramaia a ngava a taki marua vona, muru gu rabalaki a koma bakovi?” ");
INSERT INTO bnp_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ru koli ru ta maea, “E huriki a ngatavine o Hibru i uka ma ri manga e huriki a ngatavine o Egipto. Ri gao hateka ri poda malaviriri kunana. Maria i uka ma miri bele malaviriri, bara ri poda muga pali.” ");
INSERT INTO bnp_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Lakea a Vure i rata kamumu a ngatavine nga, ru tahoka koma, a vuhuna ru togoa. Muri e huriki a Israel ri bele kupo, ri gao hateka. ");
INSERT INTO bnp_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Lakea e Parao i vakuku e huriki a Egipto, i ta maea, “Mu bole e huriki a koma bakovi na Hibru, mu voro puru na naru dagi e Nail, ri gi pasiri. Pali naha ni rabalaki a koma ngatavine.” ");
INSERT INTO bnp_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ngane a bakovi tara na kabu ne Levi i parangi vona a ngatavine, ia tara a kabu ne Levi. ");
INSERT INTO bnp_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Muri a ngatavine i singou i podea a koma bakovi. E kinana i masia i mata kamumu hateka, lakea i ruhuloloa na keva i tolu. ");
INSERT INTO bnp_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Na tahuna a koma i kulabo, e kinana i keri ni ruhuloloa. Muri e kinana i vaia na pagana gili a kulopi, i pipi karia na kasita, i vakamahitea vona a koma, i ruhuloloa na ganu na dahana naru e Nail. ");
INSERT INTO bnp_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","E kurabana koma i pesi basi popote, i matanonoa a a ra maki ge bele vona. ");
INSERT INTO bnp_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","I uka ma i tabaka, i masia e tune Parao ngatavine i valai turane huriki a vora ngatavine vona, ge hilolo. Na tahuna i hilolo, e huriki a vora ngatavine vona ri laho viliha na dahana naru, ri davea. Lakea e tune Parao i masia a kulopi i papasi na naru pololilo na ganu, i rudua a vora vona ge bole vilia. ");
INSERT INTO bnp_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Na tahuna i avea a kulopi, i masia a koma bakovi i mahita pololilo na kulopi, i tatangi. Lakea i dodoa i ta maea, “Ra koma iea a tuna Hibru.” ");
INSERT INTO bnp_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Muri e kurabana i valai i takia e tune Parao, “Ioe o ngaru, ga vano ga takia tara ngatavine na Hibru ge matakaria vomu a koma.” ");
INSERT INTO bnp_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Lakea e tune Parao i ta maea, “I kamumu. O vano o takia tara ngatavine ge valai.” Lakea e kurabana i vano i takia e kinana muholi, i valai. ");
INSERT INTO bnp_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Na tahuna e kinana i valai, lakea e tune Parao i takia, “O bokea a koma, o matakaria ge ne nau, muri ga kona ioe.” Lakea e kinana i bokea, i vakarurua, i matakaria. ");
INSERT INTO bnp_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Na tahuna a koma i koru rike, e kinana i boko lakea ne tune Parao i paua ge tuna. Muri i ta maea, “Ra koma iea i papasi na naru, a matavisia. Ngane a vunua a rana e Moses.” ");
INSERT INTO bnp_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Na tahuna e Moses i koru rike pali, i vano i matai e huriki a viri vona ni vakavora hateka. I masia tara Egipto i ubi halea tara Hibru. ");
INSERT INTO bnp_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","I mata lae, i uka ma i masia tara viri ge pesi tabukoi, lakea i rabalakia a bakovi o Egipto, i tanua na hire. ");
INSERT INTO bnp_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Na parava muri e Moses i hamule tabu i matai a Hibru ala rua ru vaubi. Lakea i takia a viri i vakatubu a vabinga, “I navai o ubia e turamu?” ");
INSERT INTO bnp_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A bakovi i koli, i ta maea, “E rei i ru ioe ge ioe a matakari, go pelekado a narone mia? I navai, o luhoi ni rabalaki iau, ge manga a hini o rabalakia a bakovi o Egipto ravi?” Na tahuna e Moses i longoa a ngava iea i mangenge, i luhoi maea, “E huriki ri lohoka vona pali a naro a ratea.” ");
INSERT INTO bnp_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Na tahuna e Parao i longoa a naro i ratea e Moses, i madihi a hatena, i ngaru ni rabalakia. Muri e Moses i ha lakea na robo ne huriki a Midian. Na tahuna i bele vonga i made na dahana lomu. ");
INSERT INTO bnp_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Na robo iea i tahoka tara prister. I tahoka e tuna ngatavine ala polorua. E Moses i made na dahana lomu i matai e huriki a ngatavine nga ri valai ri gi kiru a maka buroi ne ria, ri gi vakaninu a kabuna sipsip, a meme ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Pali i ranga matakari na sipsip ri valai, ri tono tala e huriki a ngatavine nga. Lakea e Moses i hateka ne huriki a ngatavine, i lili e huriki a bakovi, i vakaninu a maka sipsip, a meme ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Na tahuna ri hamule, e tamane ria e Ietro i nana, “I navai mu hamule malaviriri?” ");
INSERT INTO bnp_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ri koli ri ta maea, “A bakovi o Egipto tara i tuhori mia, lakea e huriki a tahona sipsip i uka ma ri valili ne mia. Muri i vakaninu a sipsip a meme ne mia.” ");
INSERT INTO bnp_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Lakea e tamane ria i nana, “Ra bakovi iea i made vai? I navai mu pe ia vonga? Mu vano mu takia ge valai ge kani turane hita.” Muri ri vano ri takia e Moses, i valai. ");
INSERT INTO bnp_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","E Ietro i ngarua e Moses ge made turana. Lakea i habia ne Moses e tuna, e Sipora, i parangi vona. ");
INSERT INTO bnp_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Muri e Sipora i singou i podea a koma bakovi. Lakea e Moses i taki mule ia i ta maea, “Iau a mosi a made vona a tanga iea. Ngane ga vunua a koma iea e Gersom.” ");
INSERT INTO bnp_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Na pida nga, e Moses i made o Midian, a hariki o Egipto i mate. E huriki a Egipto ri vakavora hateka e huriki a Israel, lakea ri dedo, ri tangi, ri nanea a Vure ge tuhori ria. ");
INSERT INTO bnp_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","A Vure i longoa a nitangi ne ria, i luhoi a ngava dagi i takia ne Abraham ne Isak ne Iakop. ");
INSERT INTO bnp_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Lakea a Vure i matai e huriki a Israel ri made hale hateka, i luhoi hateka ria. ");
INSERT INTO bnp_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","E Moses i matakari a maka sipsip a meme ne lahuana e Ietro, a prister ne Midian. Na parava tara e Moses i vakalaho a maka sipsip a meme, i lakea na tabeke na nirolona haro na tabeke i ngeki, i bele o Horeb, a lolo na Vure. ");
INSERT INTO bnp_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","A agelo ne BAKOVI DAGI i bele vona, i manga a kanono i hube langa na kai kiroko tara. Pali e Moses i masia a kai i hube vona a kanono, pali i uka ma i nono. ");
INSERT INTO bnp_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Lakea i ta maea, “Ga lokovonga tabukoi, ga masia a maki i hube. I navai a kai kiroko iea i uka ma i nono?” ");
INSERT INTO bnp_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","E BAKOVI DAGI i made na kurukuruna kai kiroko, i masia e Moses i valai tabukoi, lakea i galea, “Moses, Moses!” E Moses i koli, i ta maea, “Iau ieni.” ");
INSERT INTO bnp_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Lakea a Vure i takia, “Naha ni valai tabukoi. O kali tala a vahapolo vomu, a vuhuna a malala o pepesi vona, a tabea. ");
INSERT INTO bnp_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Iau a Vure ne huriki a gare vomu. Iau a Vure ne Abraham, ne Isak, ne Iakop.” E Moses i longoa a ngava iea i kavitagua a matana, a vuhuna i mangenge ni masia a matana Vure. ");
INSERT INTO bnp_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Lakea e BAKOVI DAGI i takia, “Iau a matai e huriki a Egipto ri vakavora hateka e huriki a viri nau. Ngane ri gale iau ga korimule ria na limane huriki a matakari hale. A longoa a nigale ne ria, a lohoka hateka vona a nimadihi ri bolea. ");
INSERT INTO bnp_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ngane a puru valai ga korimule ria na limane huriki a Egipto, ga taparaki ria vona a malala kamumu i vona a maki ni kani. Ra malala iea, ngane e huriki a Kenan, a Hiti, a Amor, a Peres, a Hivi, a Iebus ri made vona. ");
INSERT INTO bnp_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","A longoa pali a nitangi ne huriki a Israel, a masia pali a naro hale ne huriki a Egipto ri rata virihi ria vona. ");
INSERT INTO bnp_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ngane o lakea ne Parao, o takia go tuli e huriki a viri nau, ri gi pea e Egipto.” ");
INSERT INTO bnp_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Pali e Moses i takia a Vure, “Iau e rei a bakovi ga lakea ne Parao, ga takia ga tuli tala e huriki a Israel o Egipto?” ");
INSERT INTO bnp_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Lakea a Vure i ta maea, “Iau a made turamu. Ngane ga habia vomu tara kilakila ge vakasiri ioe, iau a rudu ioe. Ra kilakila iea ge maea, na tahuna o tuli tala e huriki a Israel o Egipto, ri gi valai, mu kavurike iau na lolo iea.” ");
INSERT INTO bnp_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Lakea e Moses i takia a Vure, “Na tahuna ga lakea ne huriki a Israel, ga taki maea ria, a Vure ne huriki a gare ne mua i rudu iau a valai. Pali ma ri gi nana ranga, ri gi ta maea, ‘E rei a rana?’ Ga ta navai?” ");
INSERT INTO bnp_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Lakea a Vure i takia e Moses, i ta maea, “Iau ra Iau. O taki maea e huriki a Israel, ‘Iau ra Iau i rudu iau a valai ne mua.’” ");
INSERT INTO bnp_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","A Vure i taki tabua e Moses ge taki e huriki a Israel, ge ta maea, “E BAKOVI DAGI, ra Vure na gare ne mua e Abraham, e Isak, e Iakop i rudu iau a valai.” Muri i ta maea, “A ragu i tabuli vakaroro. E huriki a hamone mua ri gi gale maea a rana muri ma. ");
INSERT INTO bnp_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“O vano, o gale palupu e huriki a bakovi dagi ne Israel. O vakalongo ria ne nau, iau e BAKOVI DAGI a Vure na gare ne ria e Abraham, e Isak, e Iakop a bele vomu. O taki ria vona iau a matakari ria, a matai pali a maka maki ni rata virihi ria vona o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","A luhoi muga pali ta ga bole tala ria na tanga na nimadihi o Egipto. Muri ga bole sike ria na robo ne huriki a Kenan, a Hiti, a Amor, a Peres, a Hivi, a Iebus. Ra malala iea i kamumu, i vona a maki ni kani. ");
INSERT INTO bnp_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“O taki e huriki a gare o Israel ri gi longo maia a nitamu, ri gi ramaia. Muri o bole ria ri gi lakea na hariki o Egipto ri gi ta maea, ‘E BAKOVI DAGI, a Vure ne mia a Hibru, i made turane mia. Ngane mi valai mi gi nana ioe ta go longo ne mia, mi gi lakea taro na tabeke i ngeki. Mi gi laho na parava ge tolu, muri mi gi habi a nihabi ne Bakovi Dagi a Vure ne mia.’ ");
INSERT INTO bnp_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“Pali iau a lohoka vona a hariki, e Parao, i uka ma i ngaru mu gu vano. Na nitora nau kunana bara mu vano. ");
INSERT INTO bnp_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","I mavonga iau bara vakasiria a nitora nau, ga rata a maka niturutu ga ratapile e huriki a Egipto. Muri e Parao bara i longo ne mua mu vano. ");
INSERT INTO bnp_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Muri na tahuna a vakamadihi e huriki a Egipto, bara ri mangenge ne mua, ri habi tavula a maki ne mua. Na tahuna mu mariu tala i uka ma mu gu laho pa. ");
INSERT INTO bnp_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","E huriki a ngatavine o Israel bara ri taki e huriki a ngatavine o Egipto ri made tabukoi ne ria, e huriki ri made na ruma ne ria, bara ri habi ne ria a maka kala, a mahala ni rata na gol, a silva. Ra mahala nga bara mu vakabagetu e huriki e tune mua vona. Na naro iea kunana bara mu vakalobo liu a maka mahala o Egipto.” ");
INSERT INTO bnp_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","E Moses i koli, i ta maea, “Pali e huriki a Israel ri gi koi ni luhoi a nitagu ri gi koi ni ramai a ngavagu, ri gi ta maea, ‘O tatami! E BAKOVI DAGI i uka ma i luve taho ioe.’” ");
INSERT INTO bnp_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Lakea e BAKOVI DAGI i nanea, “A ra o bolea na limamu?” E Moses i koli, i ta maea, “A kodo na nilaho.” ");
INSERT INTO bnp_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","I takia e Moses, “O voro purua na malala a kodo!” Lakea e Moses i voro purua na malala a kodo vona, i vulo a mata. Na tahuna i masia, lakea ta ge ha. ");
INSERT INTO bnp_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Pali e BAKOVI DAGI i takia, “Naha ni ha! O tangotatea na kuna.” Lakea e Moses i tangotatea a kuna, i mareli hamule i manga kodo tabu. ");
INSERT INTO bnp_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Muri e BAKOVI DAGI i takia, “Na tahuna o lakea ne huriki a Israel, o ratea a nivakasiri iea, bara ri matakilaka vona, iau e BAKOVI DAGI a bele vomu. Ra iau a Vure na gare ne ria e Abraham, e Isak, e Iakop.” ");
INSERT INTO bnp_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","E BAKOVI DAGI i taki tabua e Moses, “O ru dilia na nirodo vomu a limamu!” Lakea e Moses i ru dilia na nirodo vona a limana. Na tahuna i turari talea, i masia a limana i tuvu vona a patala, i kea manga a kamagi. ");
INSERT INTO bnp_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“I taki tabua, “O ru dili tabua na nirodo vomu a limamu!” Lakea e Moses i ru dilia na nirodo vona a limana. Muri i turari talea, i matapado a limana. ");
INSERT INTO bnp_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Lakea e Bakovi Dagi i takia, “E huriki nga, i uka ma ri gi longo mai a nitamu, i uka ma ri gi luhoi a nivakasiri ni rata muga, a ruana nivakasiri bara i rata ria ri luhoi tora. ");
INSERT INTO bnp_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Pali ra nivakasiri nga i rua ri matai, i uka ma ri luhoi ge muholi o ri gi longo mai ioe. O kirua a naru e Nail o gurua na malala bara i mapulo i manga a dara.” ");
INSERT INTO bnp_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Lakea e Moses i takia, “BAKOVI DAGI, ra iau, i uka ma iau a bakovi ni ta na matane huriki ala kupo. Ngane o ta turagu, pali iau i uka ma iau a bakovi ni ta hateka. A ngavagu i mava na nita, i uka ma a ta kamumu.” ");
INSERT INTO bnp_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Lakea e BAKOVI DAGI i koli, i ta maea, “E rei i rata a viri i ta? E rei i rata a viri i ngava rubu, i kepa? Iau kunana a rata ria. ");
INSERT INTO bnp_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","O vano ngane, bara tovo ioe, a tuhori ioe na ngava go taki.” ");
INSERT INTO bnp_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Pali e Moses i ta maea, “Bakovi Dagi, iau a vilikoma. O rudua tara viri.” ");
INSERT INTO bnp_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Lakea e BAKOVI DAGI i madihi a hatena, i tahatea e Moses, “I navai o vilikoma? E tukamu e Aron i made, a hamone Levi, bara i tuhori ioe. A lohoka vona i ta pagapaga. Ngane i laho valai ge tagui ioe, bara i vivi ni matai ioe. ");
INSERT INTO bnp_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","O taki polo vona a ngava ge taki. Iau ga tuhori marua, bara muru ta kamumu. Ga taki marua vona a ra maki muru gu rata. ");
INSERT INTO bnp_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ioe o taki polo ne Aron a ngava ge taki ge vakalongo ne huriki. Na matane Aron, ioe o manga a Vure, o habi a ngava vona ge vakalongo e huriki. ");
INSERT INTO bnp_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ngane o bolea a kodo vomu o vano, o rata a maka nivakasiri vona.” ");
INSERT INTO bnp_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","E Moses i ta turana lobo e Bakovi Dagi, muri i hamule mai e lahuana e Ietro, i takia, “Iau a ngaru ga hamule lakea o Egipto, ga kasisi e huriki a viri nau, ri mate pali o i uka.” E Ietro i longo maia a nitana, lakea i takia, “I kamumu. O vano na nivalemu.” ");
INSERT INTO bnp_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Pali e Moses i uka ma i pea ma e Midian, lakea e BAKOVI DAGI i takia, “Ngane o puru o Egipto. Hosi, re huriki ta ri gi rabalaki ioe, ri mate pali.” ");
INSERT INTO bnp_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Lakea e Moses i vakarike na donki e girihina, e tuna bakovi ala rua, i bolea a kodo na Vure i puru turane tou o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Muri e BAKOVI DAGI i takia, “Na tahuna o bele o Egipto o rata a maka nivakasiri na matane Parao. Iau a habia vomu a nitora ni ratana a nivakasiri. Pali iau bara ratea e Parao i gigitora i uka ma ge longo vona e huriki a Israel ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Muri o takia e Parao o ta maea, ‘A kabu ne Israel i manga a koma bakovi a tabua ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","A taki ioe, “O longo ne ria e huriki e tugu, ri gi vano ri gi vasileki nau.” Ioe bara o koi, e Bakovi Dagi bara i rabalakia e tumu bakovi, a tabua.’” ");
INSERT INTO bnp_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Na tahuna e Moses i laho puru o Egipto, i rodo a hini i mahitatutu na dala. Na tahuna i mahita e BAKOVI DAGI i valai ta ge rabalakia. ");
INSERT INTO bnp_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Lakea e Sipora i bole rikea a voko, i palea a kulina kapune tuna i vakapadoi a vahane Moses vona, i ta maea, “Muholi, ioe e girihigu, pali ioe a bakovi o mahuri na dara.” ");
INSERT INTO bnp_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Lakea e Bakovi Dagi i uka ma i rabalakia e Moses. E Sipora i luhoi a naro ni vapala a kuli, lakea i ta maea, “Ioe a bakovi o mahuri na dara.” ");
INSERT INTO bnp_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","E BAKOVI DAGI i takia e Aron, i ta maea, “O lakea na tabeke i ngeki o taguia vonga e Moses.” Muri i vano i taguia, i ngurua e Moses na lolo na Vure. ");
INSERT INTO bnp_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Lakea e Moses i taki e Aron vona a nita lobo e BAKOVI DAGI i taki vona ge vakalongo, i tuverei vona a maka nivakasiri e BAKOVI DAGI i taki vona ge rata. ");
INSERT INTO bnp_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Muri e Moses e Aron ru gale palupu e huriki a gare ne Israel. ");
INSERT INTO bnp_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Lakea e Aron i vakalongo ria vona a maka ngava e BAKOVI DAGI i taki ne Moses. Muri i rata tabu ranga nivakasiri na matane ria. ");
INSERT INTO bnp_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","E huriki ri longoa a nitane Moses ri lohoka vona i muholi. Na tahuna ri longoa e BAKOVI DAGI i tagui ria, ri matai e huriki a Egipto ri vakavora hateka ria, ri lolu ri kavurikea a Vure. ");
INSERT INTO bnp_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Muri e Moses e Aron ru lakea ne Parao ru takia, “E BAKOVI DAGI, a Vure ne huriki a Israel, i taki go longo ne ria, ri gi lakea na tabeke i ngeki ri gi vasileki.” ");
INSERT INTO bnp_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pali e Parao i koli, i ta maea, “E rei ra BAKOVI DAGI iea? Pali i navai ga longototoa ne mua a Israel mu gu vano? Iau i uka ma a lohoka vona a BAKOVI DAGI ne mua, i uka ma a ngaru mua mu gu vano.” ");
INSERT INTO bnp_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Lakea ru ta maea, “A Vure ne huriki a Hibru i bele ne maria. I taki maria miri gi tuli e huriki a Israel mi gi laho na parava ge tolu lakea na tabeke i ngeki, mi gi habi a nihabi ne BAKOVI DAGI a Vure ne mia. O longo ne mia mi gi vano. Mia i uka ma mi gi vano, bara i vakahale mia na gilanga dagi o na vabinga dagi.” ");
INSERT INTO bnp_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pali a hariki o Egipto i taki e Moses e Aron, “I navai muru ngaru ni rata e huriki ri gi ha na leho ne ria? Muru tuli hamule ria na leho! ");
INSERT INTO bnp_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ngane mu ala kupo hateka, mu ngaru ni hataro a leho ne mua.” ");
INSERT INTO bnp_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Na parava iea e Parao i vakuku e huriki a matakari na vorakato, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Naha ni habi a varili ge kere ne huriki a Israel ri gi rata a brik, i manga a hini ri rata vakaroro. Ria kunana, ri gi vano ri gi bole a varili. ");
INSERT INTO bnp_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pali mu taki ria ri gi rata a naguna brik ra ri rata vakaroro. Naha ni kali mule o ge popote a brik ri gi rata. Re huriki nga ri tuha malulu, lakea ri ngaru ni vano ri gi habi a nihabi na Vure. ");
INSERT INTO bnp_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Mu habi a leho ge kupo ne ria. Mu rata ria ri gi leho hateka, nahea ri gi longo mai a maka ngava taminga.” ");
INSERT INTO bnp_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Muri e huriki a matakari ri taki e huriki a Israel, ri ta maea, “E Parao i taki mia, nahea mi gi habi tabu a varili ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mu vano mu matakana a varili, mu rata a brik ge manga a hini muga, naha ni rata ge popote.” ");
INSERT INTO bnp_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Lakea ri laho viliha o Egipto ri matakana a varili ri gi rata a brik vona. ");
INSERT INTO bnp_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","E huriki a matakari na vorakato ri ta hinituhana ri ta maea, “A leho mu rata ge manga a leho mu rata muga na tahuna mi habi a varili ne mua.” ");
INSERT INTO bnp_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Lakea ri ubi e huriki a matakari ne Israel ni ru ri gi matakari a leho, ri ta maea, “I navai i uka ma mu rata a brik ge manga a hini mu rata muga?” ");
INSERT INTO bnp_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Muri e huriki a matakari ne Israel ri lakea ne Parao, ri ta maea, “I navai o rata maea mia? ");
INSERT INTO bnp_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ra mia, i uka viri ge habi a varili ne mia, pali ni taki mi gi rata a brik. Ngane ri ubi mia. Mi uka a maregoa. A maregoa i tabuli ne huriki a viri vomu.” ");
INSERT INTO bnp_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Lakea e Parao i taki ria, “Mu tuha malulu! Mu kolomare mu ngaru ni lakea na tabeke i ngeki mu gu habi a nihabi ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Mu hamule, mu leho. A varili i uka ma ni gi habi ne mua. Pali mu rata a brik ge palupulupu manga a hini mu rata muga.” ");
INSERT INTO bnp_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","E huriki a matakari ne Israel ri longoa a nitane Parao ri gi rata a brik ge manga a hini ri rata vakaroro. Ngane ri lohoka vona a maregoa dagi i bele ne ria pali. ");
INSERT INTO bnp_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Na tahuna ri pea e Parao ri vano ri matavisi e Moses e Aron ru dava ria. ");
INSERT INTO bnp_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Lakea ri taki e Moses e Aron, “E BAKOVI DAGI i matai pali a narone marua, bara i ratapile marua, a vuhuna muru ratea e Parao turane huriki a bolekori vona, ri luhoi mia ta mia a maki tavula. Ra marua, ngane muru vakarike a hatene Parao bara i rabalaki mia.” ");
INSERT INTO bnp_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Muri e Moses i lakea tabu ne BAKOVI DAGI i ta maea, “BAKOVI DAGI, i navai o rata hale e huriki a viri vomu? I navai o rudu iau a valai? ");
INSERT INTO bnp_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","I vakatubu na tahuna a habi a ngava vomu ne Parao, i valai i harena mona, e Parao i vakavora hateka ria. Pali i uka ma o ratea tara maki ge tuhori ria.” ");
INSERT INTO bnp_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Muri e BAKOVI DAGI i takia e Moses, “Ngane bara o masia a naro ga ratea ne Parao. Muholi hateka, na tuhakanga nau ga ratea ge longo ne mua mu vano. Na tuhakanga nau ga kinikuia ge tono tala mua na robo vona.” ");
INSERT INTO bnp_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","A Vure i taki tabua e Moses, “Iau kunana e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Hosi a bele ne Abraham, ne Isak, ne Iakop. To lohoka vona Iau A Vure Tuhaka. Pali iau i uka ma a vakalongo tou vona a ragu ge BAKOVI DAGI to go lohoka vona. ");
INSERT INTO bnp_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","A ta turane tou na ngava dagi, a ta muholi hateka ga habia ne tou a malala e Kenan, ra malala to made muga vona manga a mosi. ");
INSERT INTO bnp_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","E huriki a Egipto ri vakavora hateka e huriki a Israel ri rata ria ri tangi. Ngane a longoa pali a nitangi ne ria. A luhoi tabua a ngava dagi a takia ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Ngane o vakalongo e huriki a Israel vona a nitagu, ‘Iau kunana e BAKOVI DAGI. Ga korimule mua na limane huriki a Egipto na maka maregoa ri rata virihi mua vona. Na nitora dagi nau ga pelekado ria ga ratapile ria, ga korimule mua. ");
INSERT INTO bnp_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ga bole mua ge mua a ngate nau, pali iau ge iau a Vure ne mua. Muri bara tuli tala mua o Egipto, a tanga ni vakavora mua vona. Na tahuna iea bara mu lohoka vona iau kunana e BAKOVI DAGI, a Vure ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ga taparaki mua na malala a ta muholi vona ga habia ne Abraham, ne Isak, ne Iakop. Ga habia ne mua a malala iea bara mu made liu vona. Iau e BAKOVI DAGI a takia pali a ngava iea.’” ");
INSERT INTO bnp_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","E Moses i vakalongo e huriki a Israel vona a ngava iea, pali ria i uka ma ri longo maia, a vuhuna ri bole a nimadihi dagi, i viliha a niluhoi ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Muri e BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“O vano o takia e Parao a hariki o Egipto, ge longo ne ria e huriki a Israel ri gi vano.” ");
INSERT INTO bnp_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pali e Moses i koli, i ta maea, “E huriki a Israel i uka ma ri longototo a ngava a taki ria vona. Pali e Parao ge longototo navai a nitagu, a vuhuna a ta korokoro.” ");
INSERT INTO bnp_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ngane e BAKOVI DAGI i taki e Moses e Aron ru gu takia e Parao ge vakamariu tala o Egipto e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","E huriki a gare na maka kabu ne Israel ra nga, e Reuben a tabua ne Israel. E tuna bakovi i va, e Hanok, e Palu, e Herson, e Karmi. E huriki a hamone Reuben, ri mapoda tala na bakovi nga. ");
INSERT INTO bnp_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","E Simion e tuna i polotara, e Iemuel, e Iamin, e Ohad, e Iakin, e Sohar, e Saul. E kinane Saul a ngatavine o Kenan. E huriki a hamone Simion ri mapoda na bakovi nga. ");
INSERT INTO bnp_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","E Levi e tuna i tolu, e Gerson, e Kohat, e Merari. E Levi i tahoka a pida i 137, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","E Gerson i tahoka e tuna i rua, e Libni e Simei. ");
INSERT INTO bnp_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","E tune Kohat i va, e Amram, e Ishar, e Hebron, e Usiel. E Kohat i tahoka a pida i 133, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","E Merari e tuna i rua, e Mali e Musi. Ra bakovi nga ru mapoda tala na kabu ne Levi, ni ramai na nuverei ne rua. ");
INSERT INTO bnp_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","E Amram i parangi mule e balona e Iokebet, lakea e Iokebet i poda e Aron e Moses. E Amram i tahoka a pida i 137, muri i mate. ");
INSERT INTO bnp_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","E Ishar e tuna i tolu, e Kora, e Nepeg, e Sikri. ");
INSERT INTO bnp_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","E Usiel e tuna i tolu, e Misael, e Elsapan, e Sitri. ");
INSERT INTO bnp_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","E Aron i parangi e Eliseba e tune Aminadab, e kurabane Nason. E Eliseba i poda e Nadap, e Abihu, e Eleasar, e Itamar. ");
INSERT INTO bnp_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","E Kora i tahoka e tuna ala tolu, e Asir, e Elkana, e Abiasap. Ra bakovi nga to mapoda tala na kabu ne Kora. ");
INSERT INTO bnp_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","E Eleasar e tune Aron bakovi i parangi e tune Putiel ngatavine, lakea i podea e Pinias. Re huriki a gare nga a hamone Levi ni here ramai a kabu takutaku ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","E BAKOVI DAGI i taki e Aron e Moses, rua kunana ru gu bole tala e huriki a Israel o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Rua kunana ru gu takia e Parao a hariki o Egipto ge longo ne huriki a Israel ri gi vano. Rua kunana, e Aron e Moses, ru gu rata a ngava. ");
INSERT INTO bnp_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Na tahuna e BAKOVI DAGI i ta turane Moses o Egipto ");
INSERT INTO bnp_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","i ta maea, “Iau e BAKOVI DAGI. O vano o vakalongoa e Parao, a hariki o Egipto, na maka ngava a taki ioe vona.” ");
INSERT INTO bnp_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Pali e Moses i takia e BAKOVI DAGI, “O lohoka vona iau a ta korokoro, i navai e Parao ge longo mai iau?” ");
INSERT INTO bnp_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Muri e BAKOVI DAGI i takia e Moses, “O masia, iau a rata ioe, o manga a Vure na matane Parao. E tukamu e Aron i manga a propet vomu ge habi a ngava vomu ne Parao. ");
INSERT INTO bnp_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","O taki e Aron vona a maka ngava a taki vomu. Muri ge takia e Parao ge longo vona e huriki a Israel ri gi mariu tala na robo vona. ");
INSERT INTO bnp_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pali iau ga ratea a hatene Parao ge madihi, muri ga rata a maka nivakasiri o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","E Parao i uka ma ge longototo a ngavamu, bara ratapilea e Egipto, ga pelekado ga vakamadihi e huriki a tahotanga, ga vakamariu e huriki a viri nau, re huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na tahuna ga ratapile e huriki a Egipto, bara vakamariu e huriki a Israel. E huriki a Egipto bara ri matakilaka nau, iau kunana e BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","E Moses e Aron ru ramai lobo a ngava e BAKOVI DAGI i taki. ");
INSERT INTO bnp_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Na tahuna ru ta turane Parao, e Moses i tahoka a pida i ravulu polotolu (80), e Aron i tahoka a pida i ravulu polotolu a polona i tolu (83). ");
INSERT INTO bnp_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","E BAKOVI DAGI i taki e Moses e Aron, ");
INSERT INTO bnp_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Na tahuna e Parao ge taki marua, muru gu rata a nivakasiri, muru vakasiria vona iau a rudu marua. Ioe o Moses, o takia e Aron ge bolea a kodo vona, ge voro purua na malala, ge vulo a mata.” ");
INSERT INTO bnp_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Muri e Moses e Aron ru lakea ne Parao ru vakalongoa vona a ngava ne BAKOVI DAGI i taki. E Aron i voro purua a kodo vona na matane Parao, na matane huriki a bolekori, i vulo a mata. ");
INSERT INTO bnp_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Muri e Parao i gale palupu e huriki a bakovi na lohokanga, a bakovi na malulu o Egipto, ri toni ni ratea a maki iea na malulu ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Lakea ri voro puru a maka kodo ne ria ri vulo a mata. Pali a kodo ne Aron i todo a maka kodo ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","E Parao i masia a nivakasiri, pali i gigitora, i uka ma i longo mai a nitane Moses e Aron, i manga a ngava e BAKOVI DAGI i taki. ");
INSERT INTO bnp_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Muri e BAKOVI DAGI i takia e Moses, “E Parao i gigitora hateka, i marikoi ne huriki a Israel ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Na hatelanga bara i lakea na naru dagi e Nail. O vano o bulo ia vonga. O bolea a kodo vomu ra i vulo a mata, o davea na gagana naru dagi. ");
INSERT INTO bnp_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","O takia e Parao, o ta maea ‘E BAKOVI DAGI, a Vure ne huriki a Hibru, i rudu iau ga taki ioe, o longo vona e huriki a Hibru ri gi vano, ri gi kavurikea na tabeke i ngeki. Pali i valai i harena mona i uka ma o longo mai ria. ");
INSERT INTO bnp_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ngane e BAKOVI DAGI i ta maea, “Ioe bara o masia a maki ga ratea, bara o lohoka vona iau kunana e BAKOVI DAGI. O masia, bara lagua na kodo nau a naru dagi e Nail, bara i vulo a dara. ");
INSERT INTO bnp_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Muri a maka manu na naru dagi bara ri mate, ri mavuru. E huriki a Egipto i uka ma ri gi nua.” ’” ");
INSERT INTO bnp_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","E BAKOVI DAGI i takia e Moses, “O takia e Aron ge bolea a kodo vona ge toto langa na maka naru dagi, na naru kiroko, na hini ni keli kudu i tua vona a naru, na lomu, na darilomu ne Egipto, bara ri mapulo a dara. A dara bara i tabuli na hini lobo o Egipto. A naru ri kiru na tavila na buroi, ngi ranga bara i vona a dara.” ");
INSERT INTO bnp_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Lakea e Moses e Aron ru rata a maki e BAKOVI DAGI i taki rua vona. Na matane Parao, na matane huriki a bolekori vona, e Aron i bolea a kodo i lagua a naru dagi e Nail, i vulo a dara. ");
INSERT INTO bnp_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","A maka manu ri mate ri mavuru, i uka ma ni ninu a naru. A dara i bele na tabeke lobo ne Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","E huriki a bakovi na malulu o Egipto ria ranga ri rata ra naro i ratea e Aron. Lakea e Parao i gigitora, i uka ma i longototo e Moses e Aron. I tababana ni hehe, i manga a ngava e BAKOVI DAGI i taki mugea. ");
INSERT INTO bnp_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","E Parao i hamule na ruma-hariki vona, i uka ma i mangenge vona a maki i bele. ");
INSERT INTO bnp_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Muri e huriki a Egipto ri keli a maka lovo na gagane Nail ri kiru, a vuhuna ri keri ni ninu na naru dagi. ");
INSERT INTO bnp_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","A dara i kavitagu mavongea e Nail na parava i polorua muri ne BAKOVI DAGI i puloa a naru i manga a dara. ");
INSERT INTO bnp_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Muri e BAKOVI DAGI i takia e Moses ge lakea ne Parao ge takia, “E BAKOVI DAGI i ta maea, ‘O longo vona e huriki a viri nau ri gi valai, ri gi vasileki nau. ");
INSERT INTO bnp_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ioe i uka ma go longo ne ria ri gi valai, bara rudu a maka bura ri gi ratapilea a malala vomu. ");
INSERT INTO bnp_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","A maka bura bara ri bele, ri vakavonua e Nail. Muri bara ri pe a naru, ri dili na ruma-hariki vomu, ri dili na tabeke ni mahita na kiri vomu, na ruma ne huriki a bolekori vomu, na ruma ne huriki a viri vomu. Bara ri dili na murina kanono, na murina hini ni rata bret. ");
INSERT INTO bnp_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Bara ri page rike vomu, ri page rike ne huriki a viri vomu, a bolekori vomu.’” ");
INSERT INTO bnp_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Muri e BAKOVI DAGI i takia e Moses, “O takia e Aron ge toto langa a kodo vona na maka naru dagi, na naru kiroko, na naru na golu, na lomu, na darilomu. Ge rata a maka bura ri gi bele kupo hateka na robo e Egipto.” ");
INSERT INTO bnp_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Lakea e Aron i toto langa na maka naru ne Egipto a limana. Muri a maka bura ri bele ri vakavonua a robo. ");
INSERT INTO bnp_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","E huriki a bakovi na malulu, ria ranga ri rata mavonga. Ri rata a maka bura ri pe a naru ri rike na malala ne Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Lakea e Parao i gale valai vona e Moses e Aron i taki rua, “Muru vasileki ne BAKOVI DAGI ge lili vuroki a maka bura na tabeke ne mia, muri bara longo vona e huriki a viri ne mua ri gi vano, ri gi habi a nihabi ne BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Lakea e Moses i koli, i ta maea, “O vulakia tara parava ga vasileki, ga tuhori ioe turana e huriki a bolekori vomu, e huriki a viri vomu. Muri a maka bura bara ri pe a ruma ne mua, ri hamule puru ne Nail.” ");
INSERT INTO bnp_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Lakea e Parao i ta maea, “O vasileki kuduvi.” E Moses i koli, i ta maea, “Ga rata manga a hini o taki, bara o lohoka vona i uka tara viri ge manga e BAKOVI DAGI, a Vure ne mia. ");
INSERT INTO bnp_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","A maka bura bara ri pe a ruma vomu, ri pe e huriki a bolekori vomu, a viri vomu, ri hamule puru na naru dagi.” ");
INSERT INTO bnp_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Muri e Moses e Aron ru pea e Parao ru vano. Lakea e Moses i vasileki ne BAKOVI DAGI ge lili vuroki a maka bura. ");
INSERT INTO bnp_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E BAKOVI DAGI i longo vona a nivasileki ne Moses, lakea a maka bura ri tabuli na ruma, na poridala, na hania ri mate. ");
INSERT INTO bnp_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","E huriki ri poi a maka bura ri ru kadolu, a robo i mavuru. ");
INSERT INTO bnp_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Na tahuna e Parao i matai a maka bura ri mate lobo, i gigitora, i uka ma i longo mai e Moses e Aron, i manga a ngava e BAKOVI DAGI i taki. ");
INSERT INTO bnp_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Muri e BAKOVI DAGI i takia e Moses, “O takia e Aron ge toto talea a kodo vona ge lagu a habulo na malala, ge mapulo ge ria a namo, ri gi bebe viliha na robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Lakea ru rata mavonga. E Aron i toto tala a kodo, i lagu a habulo na malala. A habulo lobo na robo e Egipto, ri mapulo ri manga a namo, ri kani e huriki a bakovi, a maka livoa. ");
INSERT INTO bnp_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Pali e huriki a bakovi na malulu ri toni ni vakabele a namo, ri keri. A maka namo ri ratapile e huriki a bakovi, a maka livoa. ");
INSERT INTO bnp_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Lakea e huriki a bakovi na malulu ri takia e Parao, “A Vure kunana i ratea a maki iea.” Pali e Parao i gigitora, i uka ma i longo mai a nitane Moses e Aron, i manga a ngava e BAKOVI DAGI i taki. ");
INSERT INTO bnp_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","E BAKOVI DAGI i takia e Moses, “Na hatelanga pokopoko e Parao bara i puru na naru dagi. O vano o taguia, o takia, ‘E BAKOVI DAGI i ta maea: O longo vona e huriki a viri nau ri gi vano ri gi kavurike iau. ");
INSERT INTO bnp_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ioe i uka ma o longo ne ria, bara rudu a maka lango, ri lakene vomu, ne huriki a bolekori vomu, ne huriki a viri vomu. A ruma ne huriki a Egipto bara i vonu vona a lango. A hini i pesi vona a ruma ranga, bara i voi vona a lango. ");
INSERT INTO bnp_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“‘Na tahuna a maka lango ri gi bele, ga matakaria a malala e Gosen, ra tabeke i made vona e huriki a viri nau. A maka lango i uka ma ge vonu vonga, bara o lohoka vona, iau e BAKOVI DAGI na malala iea. ");
INSERT INTO bnp_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Iau i uka ma ga ratea na viri nau a naro iea, ge manga a naro a ratea na viri vomu. Ra nivakasiri iea ge bele kuduvi.’” ");
INSERT INTO bnp_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Lakea e BAKOVI DAGI i rata a maka lango ri dili na ruma-hariki vona, na ruma ne huriki a bolekori, a viri vona, ri ratapilea e Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Muri e Parao i gale e Moses e Aron i taki rua, “Mu vano mu habi a nihabi na Vure ne mua. Mu rata kunana koea na malala iea.” ");
INSERT INTO bnp_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Pali e Moses i koli, i ta maea, “Bara mi rata mavonga, i uka ma ge kamumu. A maka nihabi mi gi habi ne BAKOVI DAGI a Vure ne mia, i uka ma ge mata kamumu na matane huriki a Egipto. Bara mi rata mavonga, bara ri tahate ne mia, ri padi mia na kedo. ");
INSERT INTO bnp_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Mi gi laho na parava ge tolu na tabeke i ngeki, mi gi habi a nihabi ne BAKOVI DAGI a Vure ne mia, i manga a hini i taki mia vona.” ");
INSERT INTO bnp_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Lakea e Parao i ta maea, “Ngane a longo ne mua mu gu vano, mu gu habi a nihabi ne BAKOVI DAGI a Vure ne mua na tabeke i ngeki. Pali naha ni laho basi hateka. Ngane mu vasileki ge tuhori iau.” ");
INSERT INTO bnp_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Lakea e Moses i takia, “Muri ga pe ioe, ga vasileki ne BAKOVI DAGI ge lili vuroki a maka lango. Kuduvi a maka lango bara ri ha tala na ruma-hariki vomu, na ruma ne huriki a bolekori vomu, na ruma ne huriki a viri vomu. Pali naha ni tami mia tabu, go hatekakari mia, nahea mi gi vano mi gi habi a nihabi ne BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","E Moses i pea e Parao i vano i vasileki ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Lakea e BAKOVI DAGI i rata a maki e Moses i nana vona. I lili vuroki a maka lango ne Parao, ne huriki a bolekori, ne huriki a viri vona, i uka ma ni matai tabu ranga lango. ");
INSERT INTO bnp_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pali e Parao i tababana ni gigitora, i marikoi ne huriki a Israel ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Muri e BAKOVI DAGI i takia e Moses ge lakea ne Parao ge takia, “E BAKOVI DAGI, a Vure ne huriki a Hibru, i ta maea, ‘O longo vona e huriki a viri nau ri gi vano ri gi kavurike iau. ");
INSERT INTO bnp_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ioe bara o hatekakari ria, i uka ma o ngaru ria ri gi vano, o nugu tata ria, ");
INSERT INTO bnp_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","bara rudua a gilanga dagi ge ratapile a maka bulmakau a sipsip lobo vomu, a maka hos, a donki, a kamel, turana a sipsip, a meme. ");
INSERT INTO bnp_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pali a maka bulmakau a sipsip ne huriki a Israel, iau e BAKOVI DAGI, ga matakari, i uka ma ri gi mate manga ne huriki a Egipto.’” ");
INSERT INTO bnp_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","E BAKOVI DAGI i vulakia a parava i ta maea, “Kuduvi ga ratea a maki iea.” ");
INSERT INTO bnp_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Na parava muri i rata a bulmakau a sipsip ne huriki a Egipto ri mate, pali ne huriki a Israel i uka ma ri mate. ");
INSERT INTO bnp_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Lakea e Parao i rudu a bakovi ri gi kasisi a maka bulmakau a sipsip ne huriki a Israel ri mate o i uka. Ri matai a bulmakau a sipsip ne ria, ri kamumu kunana. Pali e Parao i tababana ni gigitora, i uka ma i longo ne huriki a Israel ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Muri e BAKOVI DAGI i taki e Moses e Aron, “Muru lakea na roho ni rata a brik muru bole ranga habulo muru lakea ne Parao. Na tahuna muru luve vona, e Moses ge voro rike a habulo ge matai. ");
INSERT INTO bnp_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ra habulo bara i poko viliha na tabeke lobo ne Egipto. Na tahuna a habulo i boru puru ne huriki a bakovi a ngatavine na maka hos a bulmakau, a loto bara i tuvu ne ria. Muri ri mapoka, ri vakabele a ngarava dagi.” ");
INSERT INTO bnp_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Muri ru bole a habulo, ru vano ru pesi na matane Parao, lakea e Moses i voro rike a habulo. A habulo i vakabele a loto, muri ri mapoka, ri vakabele a ngarava dagi ne huriki a bakovi, a ngatavine, a hos, a bulmakau. ");
INSERT INTO bnp_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","E huriki a bakovi na malulu i uka ma ri bele ne Moses, a vuhuna i tuvu ne ria a loto turane huriki lobo o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pali e BAKOVI DAGI i ratea e Parao i gigitora, i uka ma i longo mai e Moses e Aron, i manga a ngava i taki muga e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Muri e BAKOVI DAGI i takia e Moses ge lakea ne Parao na hatelanga pokopoko ge taguia ge takia, “E BAKOVI DAGI a Vure ne huriki a Hibru i ta maea, ‘O longo vona e huriki a viri nau, ri gi vano, ri gi kavurike iau. ");
INSERT INTO bnp_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ge uka, ga rudua a vuranga dagi ge ratapile ioe turana e huriki a bolekori, e huriki a viri vomu. Muri bara mu lohoka vona, i uka tara viri na malala ge manga iau. ");
INSERT INTO bnp_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Iau a tabukoi kunana ga ratapile e huriki a viri vomu, ga ratapile ria na vuranga, bara ri lobo liu na malala. ");
INSERT INTO bnp_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Pali iau a matataro mua i uka ma mu bole a vuranga ma, ga vakasiri mua vona a nitora dagi nau, lakea e huriki bara ri vakarere a ragu na tabeke lobo na malala. ");
INSERT INTO bnp_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pali ioe o hehe hateka, o marikoi vona e huriki a viri nau ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ngane o longo, kuduvi na tahuna maea ga rudu vilia a vala-kedo. Ra vala-kedo maea i uka ma i boru hosi koea o Egipto, i tubu na tahuna e Egipto ni rata rike karaba, i valai i harena mona. ");
INSERT INTO bnp_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ngane o vakuku e huriki ri gi vakaha dili na roho a maka bulmakau turana a maki lobo ri mahuri ri laho polovavo, a vuhuna e huriki a bakovi, a maka hos, a bulmakau i uka ma ri gi dili na roho, a vala-kedo bara i boru langa ne ria, i rabalaki ria.’” ");
INSERT INTO bnp_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","E huriki a bolekori ranga ne Parao ri mangenge vona a nitane BAKOVI DAGI, ri vakaha dili na roho e huriki a vora, a maka hos a bulmakau. ");
INSERT INTO bnp_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pali i ranga e huriki i uka ma ri mangenge vona a nitane BAKOVI DAGI, ri longotaro a nitana, ri mata taro e huriki a vora, a maka hos a bulmakau ri laho polovavo. ");
INSERT INTO bnp_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Muri e BAKOVI DAGI i takia e Moses, “O toto rike na hunu a limamu, ge boru puru a vala-kedo na tabeke lobo ne Egipto, ge ratapile e huriki a bakovi, a hos, a bulmakau, a maki ni kani na hania.” ");
INSERT INTO bnp_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Na tahuna e Moses i toto rike na hunu a kodo vona, e BAKOVI DAGI i rudu vilia a vala-kedo, i kururu, i maravila i puru na malala. Muri a vala-kedo i boru langa na tabeke lobo ne Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","A vala-kedo i boru hateka. A hini i kururu i maravila ni matai, ni longo na tabeke lobo ne Egipto. Ra vala-kedo iea i hale hateka. Hosi e huriki a Egipto i uka ma ri matai a vala-kedo ge boru maea. ");
INSERT INTO bnp_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","A vala-kedo i ratapile e huriki a bakovi a ngatavine, turana a maka hos a bulmakau, a maki i tabuli polovavo na tabeke lobo ne Egipto. Ra vala-kedo, i ratapile a maki ni varo na hania, a maka kai ni kani a kanena. ");
INSERT INTO bnp_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Pali na robo e Gosen, ra tabeke i made vona e huriki a Israel, a vala-kedo i uka ma i boru vonga. ");
INSERT INTO bnp_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Muri e Parao i talo rike a ngava ne Moses e Aron ru gu valai vona. Na tahuna ru bele, e Parao i taki rua, “Iau a rata a naro hale pali. E BAKOVI DAGI i rata a naro kamumu, pali iau turane huriki a viri nau mi rata a naro hale. ");
INSERT INTO bnp_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","A ngaru marua muru gu vasileki ne BAKOVI DAGI ge vakalobo a vala-kedo, a hini kururu. Muri bara longo ne mua mu vano malaviriri kunana.” ");
INSERT INTO bnp_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Lakea e Moses i koli, i ta maea, “Na tahuna ga pagitala na tanga dagi ga toto rike a limagu, ga vasileki ne Bakovi Dagi, a vila, a hini kururu bara ru lobo. A vala-kedo i uka ma ge boru tabu. Muri bara o lohoka vona ra malala iea ne vone Bakovi Dagi. ");
INSERT INTO bnp_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pali iau a lohoka vona, ioe turane huriki a bolekori vomu i uka ma mu mangenge ne BAKOVI DAGI a Vure.” ");
INSERT INTO bnp_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Na tahuna iea a maka kai kiroko ni rata hotu na kuline ria ri lubu, a maka rais ri moro i ratapile a vala-kedo. ");
INSERT INTO bnp_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pali a maka kanena vit kunana i uka ma ri hale, a vuhuna a maka vit i uka ma ri lua ma. ");
INSERT INTO bnp_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Muri e Moses i pea a tanga dagi i pagitala. Na tahuna i toto rike a limana i vasileki ne BAKOVI DAGI, a vila, a hini kururu ru lobo. A vala-kedo tara i lobo ni boru. ");
INSERT INTO bnp_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Na tahuna e Parao i uka ma i longo a hini ge kururu ge maravila, ge matai a vala-kedo ge boru, i rata a naro hale tabu turane huriki a bolekori, ri gigitora, ri koi ne huriki a Israel ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Muholi hateka, e Parao i gigitora hateka, i uka ma i longo ne huriki a Israel ri gi vano, i manga a ngava e BAKOVI DAGI i taki polo ne Moses. ");
INSERT INTO bnp_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","E BAKOVI DAGI i takia e Moses, “O vano o masia e Parao. Iau a ratea i gigitora, e huriki a bolekori vona ri gigitora, ga rata a maka nivakasiri na kurukurune ria. ");
INSERT INTO bnp_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Muri ma bara o tuverei polo ne huriki e tumu, e tubumu, a maka nivakasiri a rata virihi e huriki a Egipto vona. Lakea mua lobo bara mu lohoka vona, iau kunana e BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Lakea e Moses e Aron ru lakea ne Parao ru takia, “E BAKOVI DAGI a Vure ne mia e huriki a Hibru i ta maea, ‘I balaka riva go longotaro a ngavagu, go marikoi ni longo mai iau? O taki e huriki a viri nau, ri gi vano ri gi kavurike iau. ");
INSERT INTO bnp_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ioe go marikoi ne ria ri gi vano, kuduvi ga rudu a maka koa ri gi valai ri gi vonu vona a robo vomu. ");
INSERT INTO bnp_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Bara ri bebe lae vona a robo vomu, ri kavitagua a malala. A maki ni kani, a kai i uka ma i ratapile a vala-kedo, a maka koa bara ri ratapile ria ri vakalobo liu. ");
INSERT INTO bnp_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Bara ri vonu na ruma-hariki vomu, ri vonu na ruma ne huriki a bolekori a viri lobo vomu o Egipto. Hosi na tahuna ne huriki a gare ne mua, i valai i harena mona, a maka koa maea i uka ma ni matai.’” Muri e Moses i ngalakapulo, i pea e Parao i pagitala. ");
INSERT INTO bnp_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","E huriki a bolekori ri takia e Parao, “I balaka riva a hini go longotaro a bakovi nga? Ngane ru habi a maregoa ne hita. O longo ne ria ri gi vano ri gi kavurikea e BAKOVI DAGI, a Vure ne ria. Ra ioe, i uka ma o masia e Egipto i hale liu pali?” ");
INSERT INTO bnp_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Muri e Moses e Aron ni tuli hamule ne Parao, i taki rua, “Mu vano mu vasileki ne BAKOVI DAGI, a Vure ne mua. Pali mu taki iau ngane, e rei ge vano?” ");
INSERT INTO bnp_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Lakea e Moses i koli, i ta maea, “Mia lobo mi gi vano turane huriki a gare, a bakovi, a ngatavine, e tune mia, a maka bulmakau, a sipsip, a meme, a vuhuna bara mi rata a nivasileki dagi ne BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Lakea e Parao i ta maea, “I uka liu! A marikoi vona e huriki a ngatavine, a koma ri gi laho turane mua. I padi iau a mana pali, bara mu rata a naro hale ne mia. ");
INSERT INTO bnp_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Iau a marikoi! E huriki a bakovi kunana ri gi vano ri gi vasileki ne BAKOVI DAGI.” E Parao i ta lobo, muri e huriki a bolekori vona ri tono tala e Moses e Aron. ");
INSERT INTO bnp_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Muri e BAKOVI DAGI i takia e Moses, “O toto tala a limamu, o toto langa na robo e Egipto ge valai a maka koa, ri gi kani a maki ri tababana.” ");
INSERT INTO bnp_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Lakea e Moses i toto tala a kodo vona, lakea e BAKOVI DAGI i ratea a vilu i ngalu valai na nirikena haro na parava i taku, a rodo i taku. Na hatelanga a maka koa ri bele. ");
INSERT INTO bnp_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ri valai ri toka na tabeke lobo ne Egipto, ri ratapile a maki. Ra maka koa ri kupo hateka. E huriki a Egipto i uka ma ri matai hosi a maka koa ge kupo hateka maea, muri i uka ma ri gi matai tabu. ");
INSERT INTO bnp_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ri kavitagua a malala i katoki. Ri kani a maka varili, a pagana kai, a kanena kai i ratapile kaleva a vala-kedo. I uka liu tara maki ge goma ni gi matai tabu na robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","E Parao i malaviriri kunana i talo rike a ngava ne Moses e Aron ru gu valai vona. Lakea i taki rua i ta maea, “Iau a rata a naro hale ne BAKOVI DAGI, a Vure ne mua. A rata a naro hale ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","A ngaru marua muru gu puga vuroki tabua a naro hale nau. Muru vasileki ne BAKOVI DAGI ne mua, muru takia ge rata vurokia a maki na matenga ri ratapile a robo nau.” ");
INSERT INTO bnp_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ru pea e Parao, muri e Moses i vano i vasileki ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Lakea e BAKOVI DAGI i puloa a vilu dagi i rudua i pori valai na nirolona haro. I kave lakea na Dari Vururu a maka koa, i uka ma ni matai tabu o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pali e BAKOVI DAGI i ratea e Parao i gigitora, i uka ma i longo ne huriki a Israel ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Muri e BAKOVI DAGI i takia e Moses, “O toto rike na hunu a limamu, ge bele a uvo ge kavitagua e Egipto. Ra uvo iea ni hataki.” ");
INSERT INTO bnp_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Lakea e Moses i toto rikea na hunu a limana, i bele a uvo vatubi, i kavitagua e Egipto na parava i tolu. ");
INSERT INTO bnp_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","E huriki a Egipto ri keri ni matai mule ria, ri made kunana na ruma. Pali a tabeke i made vona e huriki a Israel i uka ma i bele vona a uvo vatubi. ");
INSERT INTO bnp_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Muri e Parao i galea e Moses i takia, “Mu vano ngane mu vasileki ne BAKOVI DAGI ne mua. E huriki a ngatavine a koma, ria ranga, ri gi vano turane mua. Pali a maka bulmakau, a sipsip, a meme ge tabuli.” ");
INSERT INTO bnp_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pali e Moses i koli, i ta maea, “I uka ma ge mavonga. A maki ngi ranga mi gi bole, bara mi habi ne BAKOVI DAGI, a Vure ne mia. ");
INSERT INTO bnp_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Mi gi bole lobo a maka sipsip a meme, bara mi vulaki ranga ge a nihabi ne BAKOVI DAGI a Vure. Pali mi gi vano taro, mi gi bele na murina nivasileki, mi gi pelekado a sipsip a bulmakau ge a nihabi ne BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pali e BAKOVI DAGI i ratea e Parao i gigitora, i uka ma i longo ne ria ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Lakea e Parao i takia e Moses, “Muru hataroa a tanga iea! Naha ni hamule valai! Marua muru pesi na matagu tabu, bara muru mate!” ");
INSERT INTO bnp_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","E Moses i koli, i ta maea, “I manga a hini o taki, i uka ma miri gi valai tabu miri gi matai ioe.” ");
INSERT INTO bnp_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","E BAKOVI DAGI i takia e Moses, “Ga habi tabua ne Parao turane huriki a Egipto tara vuranga. Muri bara i longo ne mua mu vano. Na tahuna i longo ne mua mu vano, bara i turahari mua, i lili tala mua. ");
INSERT INTO bnp_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","O taki e huriki a Israel ri gi lakea ne huriki a Egipto ri made tabukoi ne ria, ri gi nongi ne ria a mahala na gol a silva.” ");
INSERT INTO bnp_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","E BAKOVI DAGI i rata e huriki a Egipto ri togo e huriki a Israel. Pali na matane huriki a bolekori ne Parao turane huriki a Egipto, ri masia e Moses ia a bakovi dagi hateka. ");
INSERT INTO bnp_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Lakea e Moses i takia e Parao, “E BAKOVI DAGI i ta maea, ‘Na kururodo ga laho lobo na robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","E huriki a tabua bakovi o Egipto ri gi mate. Ga tubu na tabua bakovi vomu, ra viri ge bole a murimu, ge matakari o Egipto, ge harena na tabua ne huriki a vora ngatavine ri leho ni vila a vit ni rata a bret. A tabua na maka bulmakau a sipsip, ngi ranga ri gi mate. ");
INSERT INTO bnp_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","A halohoa dagi bara ni longo na tabeke lobo ne Egipto. Ra runga maea i uka ma ni longo hosi, i uka ma ni gi longo tabu muri ma. ");
INSERT INTO bnp_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pali iau i uka ma ga ratea tara maki hale ge bele ne huriki a Israel o na sipsip a bulmakau ne ria.’ Muri bara o matakilaka vona ra naro e BAKOVI DAGI i ratea ne huriki a Egipto, i uka ma ge ratea ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","E huriki a bolekori vomu bara ri valai, ri lolu na matagu ri ta maea, o vano ngane! Ioe turane huriki a viri vomu, mu vano malaviriri! Ra vuranga nga ge bele taro, muri iau ga pea e Egipto.” E Moses i madihi hateka a hatena, i pea e Parao, i pagitala. ");
INSERT INTO bnp_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Muri e BAKOVI DAGI i takia e Moses, “E Parao i uka ma ge longo mai ioe, ga rata tabu ranga nivakasiri na robo e Egipto.” ");
INSERT INTO bnp_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","A maka nivakasiri nga, e Moses e Aron ru rata na matane Parao. Pali e BAKOVI DAGI i ratea i gigitora, i uka ma i ngaru e huriki a Israel ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Na tahuna e Moses e Aron ru tababana o Egipto, e BAKOVI DAGI i taki rua, ");
INSERT INTO bnp_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ra keva iea, a mugana keva na pida. ");
INSERT INTO bnp_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","O taki e huriki a Israel, na ravuluna parava na keva iea, a bakovi takutaku ge lavea tara tuna sipsip ge kania a kabu vona. ");
INSERT INTO bnp_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","A kabu kiroko, i uka ma i kara ge kani kiria a tuna sipsip, ge takia tara kabu i made tabukoi ge valai ge kani turana. E huriki a bakovi, a ngatavine, a koma ri gi vaveru kamumu a bobona, ri gi kani. ");
INSERT INTO bnp_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mu vulaki a sipsip a toga o a meme a toga gavutuvutu, a pida vona ge taku, pali naha ni lave a viri i tahoka a gilanga. ");
INSERT INTO bnp_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","A maka sipsip a bulmakau ni gi matakari kamumu ge harena na parava ge ravulu a polona i va na keva iea. Na malunga liu, e huriki a Israel ri gi rabalaki a maka tuna sipsip. ");
INSERT INTO bnp_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","A darana sipsip ni gi bole, ni gi kalu varago a dahana mataruma, a tabeke polomeli na mataruma. ");
INSERT INTO bnp_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Na rodo iea mu gutu na kanono a maka tuna sipsip turana a lahia lahaha, mu kani kinika na bret i uka is. ");
INSERT INTO bnp_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Naha ni hoda a bobona sipsip a bulmakau, naha ni nono na ulo. Mu gutu kunana na kanono a mapana, a vahana, a mahalana. ");
INSERT INTO bnp_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Naha ni ru ranga bobona sipsip a bulmakau ge palala taho a hini. A bobona mu kani kaleva, mu gutu ge vuro lobo liu. ");
INSERT INTO bnp_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Na tahuna mu kani, mu rea tata a varakia ne mua, mu rodo a vahapolo, mu nugu a kodo na nilaho. Mu kani malaviriri, a vuhuna ra kinani iea ne vona ni luhoi a parava iau e Bakovi Dagi a pagepolo mua, i uka ma a ratapile mua. ");
INSERT INTO bnp_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Na rodo iea ga lakea na tabeke lobo ne Egipto, ga rabalaki e huriki a tabua bakovi, a tabua toga na sipsip, a bulmakau. Iau kunana e BAKOVI DAGI, bara ratapile a maka vure ne huriki a Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ra dara mu kalu na mataruma ne mua ge tabuli ga kilakila ne mua. Na tahuna a matai a dara mu kalu na mataruma, bara pagepolo a ruma ne mua. Ra vuranga iea i uka ma ge padoi mua na tahuna a ratapile e huriki a Egipto.” ");
INSERT INTO bnp_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Muri a Vure i ta maea, “Mu luhoi vaka­roroa ra parava iea na maka nivakasiri a rata ne mua. Na pida lobo e huriki a hamone mua, ria ranga, bara ri luhoi mulea a parava iea. Ra parava iea, a parava ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Na parava ge polorua mu kani a bret i uka ma ni vuli turana is. Na mugana parava mu vuroki a is i tabuli na ruma ne mua. E rei a viri i kani a bret i tahoka a is na parava nga, ni gi lili tala na kabu ne Israel. ");
INSERT INTO bnp_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Na mugana parava, na poloruana parava mu vapopo palupu mu vasileki. Naha ni leho vona a parava i rua nga, mu kisi puru kunana a kinani ge kani e huriki. ");
INSERT INTO bnp_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Na pida lobo mu luhoia ra Parava Dagi na Bret i Uka Is, a vuhuna a vakamariu tala mua o Egipto na parava iea. ");
INSERT INTO bnp_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Na mugana keva mu kani a bret i uka is. Mu vakatubu na malunga na parava na keva i ravulu a polona i va, ge harena na malunga na parava na keva i ravulu rua a polona i taku. ");
INSERT INTO bnp_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Na parava ge polorua nahea a is ge tabuli na ruma mua. A viri i kani a bret i tahoka is, mu lili talea na kabu ne Israel. A mosi tara mu rata mavongea. ");
INSERT INTO bnp_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Na tahuna mu made na hini vai, na parava iea, naha ni kani a bret i tahoka a is.” ");
INSERT INTO bnp_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","E Moses i gale palupu e huriki a gare ne Israel i taki ria, “Mu hamule mu vulaki a tuna sipsip na kabu takutaku, mu rabalaki ne vona a Habu na Nipagepolo. ");
INSERT INTO bnp_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mu guru dili na tavila a dara. Mu putu a rahana kai a hisop, mu lutu na dara i tabuli na tavila, mu kalu varago a dahana mataruma, a hini polomeli na mataruma. Mu made pololilo na ruma ge harena na hatelanga. ");
INSERT INTO bnp_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","E BAKOVI DAGI bara i lakea na tabeke lobo ne Egipto ge rabalaki e huriki a koma bakovi, a tabua. Na tahuna i matai a dara na mataruma ne mua, bara i pagepolo. I uka ma ge rudua a agelo vona ge dili na ruma ge ratapile mua. ");
INSERT INTO bnp_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Mu longo kamumu! Ra nita nga ge tabuli vakaroro turane mua, turane huriki a hamone mua. ");
INSERT INTO bnp_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Na tahuna mu dili vona a malala e BAKOVI DAGI i ta muholi vona ge habia ne mua, mu ratea a habu iea, mu luhoi mulea a parava iea. ");
INSERT INTO bnp_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na tahuna e huriki e tune mua ri gi nana, ‘I navai a vuhuna ra habu iea?’ ");
INSERT INTO bnp_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mu koli mu ta maea, ‘Si ratea a Habu na Nipagepolo iea, si habi a nihabi ne Bakovi Dagi, a vuhuna si luhoi mulea a parava i pagepolo a ruma ne hita, i rabalaki e huriki a koma bakovi, a tabua, ne Egipto.’” Muri ri lolu puru ri kavurikea a Vure. ");
INSERT INTO bnp_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","E huriki a Israel ri rata lobo a maki e BAKOVI DAGI i taki e Moses e Aron ru gu rata. ");
INSERT INTO bnp_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Na kururodo e BAKOVI DAGI i rabalaki e huriki a tabua bakovi ne Egipto. I vakatubu na tabua ne Parao i harena na tabua ne huriki a vorakato. A tabua a toga na maka bulmakau a sipsip, ngi ranga i rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Na rodo iea kunana, e Parao turane huriki a bolekori vona, e huriki a Egipto, ri hadongo ri matai e huriki a tabua bakovi ri mate. Na tabeke lobo ne Egipto e huriki lobo ri rata runga, a vuhuna a ruma takutaku i tahoka a matenga. ");
INSERT INTO bnp_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Na rodo iea kunana, e Parao i gale e Moses e Aron i taki rua, “Muru vano malaviriri turane huriki a Israel, mu pe mule e huriki a viri nau. Mu vano mu kavurikea e BAKOVI DAGI, i manga a ngava mu taki iau vona. ");
INSERT INTO bnp_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mu bole a maka sipsip, a meme, a bulmakau mu vano. Iau tara mu vasileki na Vure ge rata kamumu iau.” ");
INSERT INTO bnp_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","E huriki a Egipto ri turahari e huriki a Israel ri gi vano, ri ta maea, “Mu vano malaviriri, ma ge uka, mia lobo mi gi mate.” ");
INSERT INTO bnp_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Lakea e huriki a Israel ri bole a bret i uka ma ni vuli turana is, ri ru na tavila ri kavitagu na kala, ri kaloho, ri vano. ");
INSERT INTO bnp_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ri nongi ne huriki a Egipto a maka varakia, a maki ni rata na gol a silva, i ramaia a nitane Moses i taki ria vona. ");
INSERT INTO bnp_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","E BAKOVI DAGI i rata e huriki a Egipto ri habi tavula a maka mahala ne ria. Na naro iea kunana e huriki a Israel ri bole lobo a mahala ne Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","E huriki a Israel ri malaga o Rameses ri lakea o Sukot. E huriki ri mariu ri ala 600,000, a ngatavine a koma i uka ma ni gi. ");
INSERT INTO bnp_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","E huriki i uka ma ria a Israel ranga ri dili turane ria ri vano turana a maka sipsip a bulmakau ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Na tahuna ri gutu a bret ri gi bole turane ria, i uka ma ri vuli turana is, a vuhuna e huriki a Egipto ri turahari ria, i uka ma ri kisi kamumu a kinani. ");
INSERT INTO bnp_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","E huriki a Israel ri made na pida i 430 na robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Muri na pida i 430, na parava iea kunana, e huriki a tara ne BAKOVI DAGI ri pe a robo e Egipto, ri mariu tala. ");
INSERT INTO bnp_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Na rodo iea kunana e BAKOVI DAGI i matakari kamumu e huriki a Israel, i bole tala ria o Egipto ri vano. Na pida lobo e huriki a hamone ria ri gi luhoi mulea ra rodo iea, ri gi kavurikea e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","E BAKOVI DAGI i taki e Moses e Aron, “A vinara na Habu na Nipagepolo i maea, ‘E huriki a mosi nahea ri gi kani na habu. ");
INSERT INTO bnp_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","A vorakato ni kona i kara ge kani na habu, na tahuna ni pala pali a kulina. ");
INSERT INTO bnp_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A viri i made popote turane mua, a viri i leho ni gi kona, nahea ge kani na habu.’ ");
INSERT INTO bnp_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“E huriki ri kani a tuna sipsip ri gi kani palupu kunana na ruma ni gutu a kinani vona. Naha ni bole tala ranga bobona. Naha ni raputu ranga tuhana. ");
INSERT INTO bnp_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","E huriki a Israel ri gi rata palupua a habu iea. ");
INSERT INTO bnp_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“A bakovi basi i made turane mua i ngaru ni dili na Habu Nipagepolo ne BAKOVI DAGI, ni gi pala taro a kulina. Muri bara i manga a tahotanga, i dili na habu. A viri i uka ma ni pala a kulina, nahea ge kani na habu. ");
INSERT INTO bnp_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","A vinara i taku kunana ge ramai e huriki a tahotanga e huriki a mosi ra ri made turane mua.” ");
INSERT INTO bnp_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","E huriki a Israel ri ramai kunanea a vinara e BAKOVI DAGI i taki e Moses e Aron vona. ");
INSERT INTO bnp_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Na parava iea kunana e BAKOVI DAGI i vakamariu tala o Egipto e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“E huriki a Israel ri gi habi lobo nau e huriki a tabua bakovi, turana a tabua toga na maka sipsip a bulmakau.” ");
INSERT INTO bnp_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Muri e Moses i taki e huriki, “Na pida lobo mu luhoi mule vakaroroa a parava iea, naha ni kani a bret i vona is. Ra parava iea e BAKOVI DAGI i tuli tala mua o Egipto, a tanga na nivakavora. Na nitora vona kunana i vakamariu tala mua. ");
INSERT INTO bnp_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Mona na keva e Abib mu malaga koea. Ra keva iea a mugana keva na pida. ");
INSERT INTO bnp_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","E BAKOVI DAGI i ta tora pali ge habia ne mua a malala ne huriki a Kenan, a Hiti, a Amor, a Hivi, a Iebus. Ra malala iea i kamumu, i vona a maki ni kani. Na tahuna e BAKOVI DAGI ge taparaki lakea mua vona a malala iea, mu ratea a habu iea, na keva iea, na pida lobo. ");
INSERT INTO bnp_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“Mu kani a bret i uka is na parava ge polorua. Na poloruana parava mu rata a habu ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Na maka parava nga, e huriki ri gi kani kunana a bret i uka is. Nahea tara maki ge tahoka a is ni gi matai ge tabuli tabukoi o ge tabuli na tabeke ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Na tahuna a habu iea ge bele, mu vakalongo e huriki e tune mua mu ta maea, ‘A habu iea si ratea, si luhoi mulea a tahuna e BAKOVI DAGI i vakamariu tala mia o Egipto mi valai.’ ");
INSERT INTO bnp_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ra habu iea i manga a kilakila na limane mua, na dumene mua. Bara i rata mua mu luhoi, mu vata vona a vinara ne BAKOVI DAGI, a vuhuna na nitora dagi vona i vakamariu tala hita o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Na pida lobo mu ratea a habu iea na parava iea. ");
INSERT INTO bnp_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Na tahuna e BAKOVI DAGI ge taparaki mua na malala e Kenan i habia ne mua, ra i ta muholi vona hosi ne huriki a gare ne mua, ");
INSERT INTO bnp_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mu habi vona e huriki e tune mua a tabua bakovi, a tabua toga na sipsip a bulmakau. ");
INSERT INTO bnp_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Na tahuna mu ngaru ni konamulea tara tuna tabua na donki a toga, mu kuloia vona tara tuna sipsip. Ge uka, mu horia a lohona donki. Pali e huriki a tabua bakovi ne mua mu kona mule. ");
INSERT INTO bnp_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Muri ma, e huriki e tune mua bara ri nana, ‘I navai a vuhuna a naro iea?’ Mu koli mu ta maea, ‘E huriki a Egipto ri vakavora hateka mia na robo ne ria, pali e BAKOVI DAGI, na nitora dagi vona, i tuli tala mia mi valai. ");
INSERT INTO bnp_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Na tahuna e Parao i hehe i uka ma i ngaru mia mi gi vano, e BAKOVI DAGI i rabalaki e huriki a tabua bakovi, a maka tabua na sipsip a bulmakau, a toga ne huriki a Egipto. Ngane si luhoi mulea a naro i ratea ne mia, si habi e huriki a tabua bakovi turana a maka tabua toga na sipsip a bulmakau ne BAKOVI DAGI. Na naro iea kunana mi korimule e huriki e tune mia a tabua bakovi. ");
INSERT INTO bnp_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Si ratea a naro iea si gi luhoi tabua e BAKOVI DAGI i bole tala mia o Egipto i vakamariu valai mia koea na nitora vona. Ra nita iea i manga a kilakila ni topi na limane hita na dumene hita.’” ");
INSERT INTO bnp_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Na tahuna e Parao i longo vona e huriki a Israel ri gi vano, a Vure i uka ma i vakasiri ria vona a dala kapo tabukoi na dari i sike na robo e Palestina. I rata mavonga a vuhuna i luhoi maea, “Ma ri gi vakorokoro e huriki a kabu ranga, ri gi vaubi turane ria, bara ri mangenge, ri hamule tabu o Egipto.” ");
INSERT INTO bnp_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Lakea a Vure i bole ria, ri laho halui a tabeke i ngeki, ri vano ri bele na Dari Vururu. Na tahuna ri mariu tala o Egipto, ri bole a maki na vabinga ri vano. ");
INSERT INTO bnp_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","E Moses i bole a tuhane Iosep i vano turana, a vuhuna hosi e Iosep i taki e huriki a Israel i ta maea, “Muholi hateka, muri ma na tahuna a Vure ge vakamariu tala mua o Egipto, mu bole a tuhagu mu vano turana.” ");
INSERT INTO bnp_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Muri ri malaga tala na tanga e Sukot ri vano ri bele na tanga e Etam na harena tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Na haro e BAKOVI DAGI i made pololilo na bubu, i muga ria i vakasiri ria na dala. Na rodo i made pololilo na kanono, i muga ria ge habi a nipara. ");
INSERT INTO bnp_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Na haro a bubu i muga ria, na rodo a kanono i muga ria. ");
INSERT INTO bnp_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Muri e BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“O taki e huriki a Israel ri gi hamule, ri gi rata a mada tabukoi na tanga e Pihahirot. Ra tanga iea i pesi na kurukuruna tanga e Migdol, a Dari Vururu, tabukoi na tanga e Balsepon. ");
INSERT INTO bnp_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","E Parao bara i luhoi e huriki a Israel ri ruru na tabeke i ngeki, i uka hini ri gi lakea vona. ");
INSERT INTO bnp_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Iau ga ratea e Parao ge madihi a hatena ge lili ria. Pali iau bara ratapilea turana a tara na vabinga vona, ga vakadagia a ragu na maki a ratea vona. Muri e huriki a Egipto bara ri lohoka vona, iau kunana e BAKOVI DAGI.” E huriki a Israel ri longototoa a nitane Bakovi Dagi, ri hamule. ");
INSERT INTO bnp_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Na tahuna e Parao ni vakalongo ne huriki a Israel ri ha, e Parao turane huriki a bolekori vona ri pulo a niluhoi ne ria, ri deke, ri ta maea, “I navai si matataro e huriki a Israel ri vano? Ngane i uka viri ge leho ne hita.” ");
INSERT INTO bnp_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Lakea e Parao i bolea a karis vona, i gale palupu a tara na vabinga vona. ");
INSERT INTO bnp_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","I vulaki a maka vagana karis i 600 ne Egipto, turane huriki ri vakanunu ria. ");
INSERT INTO bnp_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","E BAKOVI DAGI i ratea e Parao a hariki o Egipto i gigitora, i nunu muri ne huriki a Israel, i matakana ria. Pali e huriki a Israel ri lohoka vona pali, ri mulangi, ri vivi ri vano. ");
INSERT INTO bnp_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","A tara na vabinga ne Egipto turana a maka hos a karis, ri nunu muri ne huriki a Israel. Ri pakarau ria na tahuna ri malo na dahana Dari Vururu, tabukoi na tanga e Pihahirot e Balsepon. ");
INSERT INTO bnp_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Na tahuna e Parao turana a tara na vabinga vona ri valai tabukoi, e huriki a Israel ri matai ria, ri mangenge hateka, ri galea e BAKOVI DAGI ge tuhori ria. ");
INSERT INTO bnp_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Lakea ri tahatea e Moses, “I navai o tuli valai mia koea na tabeke i ngeki? O luhoi e huriki a Egipto ri uka a hini ri gi tanu e huriki ri mate vona, o bole valai mia koea na tabeke i ngeki mi gi mate? I kamumu hateka mi gi made o Egipto mi gi mate vonga. ");
INSERT INTO bnp_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Na tahuna si tababana o Egipto, mi taki ioe nahea si gi ha, si gi made vonga ge hita a vorakato ne ria. Ngane i hale hateka si gi mate tavula koea na tabeke i ngeki.” ");
INSERT INTO bnp_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Lakea e Moses i taki ria, “Naha ni mangenge. Mu hatenono, bara mu matai a maki e BAKOVI DAGI ge rata ge korimule mua. E huriki a Egipto mu matai mona, muri i uka ma mu gu matai tabu ria. ");
INSERT INTO bnp_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","E BAKOVI DAGI bara i vaubi ni tuhori mua. Pali mua i uka ma mu gu ratea tara maki, bara mu matanono kunana.” ");
INSERT INTO bnp_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Muri e BAKOVI DAGI i takia e Moses, “I navai o tangi valai nau? O taki e huriki a Israel ri gi malaga ri gi laho. ");
INSERT INTO bnp_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","O toto rikea a kodo vomu o toto langa na dari, ge vakalipida na tabeke ge rua, ge lahopolo na mahasi e huriki. ");
INSERT INTO bnp_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Iau ga rata e huriki a Egipto ge madihi a hatene ria, ri gi valili ne mua a Israel. Muri ga ratapilea e Parao turana a tara na vabinga vona ra ri rike na karis a hos. A maki ga ratea bara vakadagi a ragu vona. ");
INSERT INTO bnp_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ga ratapilea e Parao, muri e huriki a Egipto bara ri matakilaka nau, iau kunana e BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Muri a agelo na Vure ra i muga a tara na vabinga ne Israel, i pe a hini muga i lukumuri na bitone ria. A bubu tara i pe a hini muga i pesi muri. ");
INSERT INTO bnp_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Na rodo malaku, a bubu i pesi mavonga na kurukuruna tara ne Israel, a tara ne Egipto. Ra bubu i ratea a tabeke i pesi vona e huriki a Egipto i uvo hateka, pali a tabeke i pesi vona e huriki a Israel i palala. Lakea e huriki a Egipto i uka ma ri lakea tabukoi ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Muri e Moses i toto langa na dari a limana. Na rodo e BAKOVI DAGI i ratea a vilu dagi i pori valai na nirikena haro, i tugu mulea a dari i vakalipida na tete i rua. ");
INSERT INTO bnp_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Lakea e huriki a Israel ri laho polo na tabeke i mahasi na kurukuruna. A dari i pesi manga a nure na kanene ria, na maurine ria. ");
INSERT INTO bnp_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","E huriki a Egipto ri nunu muri ne ria, turane huriki ri rike na hos a karis, ri dili na kurukuruna dari. ");
INSERT INTO bnp_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Na malabeonga e BAKOVI DAGI i made na bubu a kanono, i matapuru na tara na vabinga ne Egipto i vakaviliha a niluhoi ne ria, ri varoru. ");
INSERT INTO bnp_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","I rata a maka parere na karis i koro vona a kokota, ri keri ni nunu. Lakea ri ta maea, “Si hamule! E BAKOVI DAGI i tuhori e huriki a Israel ri vaubi ne hita. Si ha malaviriri, si pe mule ria.” ");
INSERT INTO bnp_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Muri e BAKOVI DAGI i takia e Moses, “O toto langa na dari a limamu ge hamule mai a murina a dari, ge kavitagu e huriki a Egipto turana a maka karis a hos ne ria.” ");
INSERT INTO bnp_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Lakea e Moses i toto langa na dari a limana. Na hatelanga a dari i hamule mai a murina. E huriki a Egipto ri toni ni ha, pali ri keri, lakea e BAKOVI DAGI i vakapasiri ria, ri mate. ");
INSERT INTO bnp_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","A dari i hamule mai a murina i kavitagu e huriki a tara na vabinga ne Parao, turana a maka karis a hos ne ria, ra ri nunu muri ne huriki a Israel, i uka tara viri ge mahuri. ");
INSERT INTO bnp_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pali e huriki a Israel ri laho polo na hini i mahasi, ri bele na tabeke tara. A dari i pesi manga a nure na kanene ria, a maurine ria. ");
INSERT INTO bnp_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Na parava iea kunana e BAKOVI DAGI i korimule e huriki a Israel na limane huriki a Egipto. E huriki a Israel ri matai a maka podane huriki a Egipto ri vatabulihi na lavu na Dari Vururu. ");
INSERT INTO bnp_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Na tahuna e huriki a Israel ri masia a nitora dagi ne BAKOVI DAGI i rata virihi e huriki a Egipto vona, ri mangenge ne BAKOVI DAGI ri longototoa turana a vora vona e Moses. ");
INSERT INTO bnp_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Muri e Moses turane huriki a Israel ri kaloloa a linge, ri kavurikea e BAKOVI DAGI: “Si gi kaloloa a linge ge longoa e BAKOVI DAGI, a vuhuna a nitora vona i dagi hateka. I voro puru na dari a hos turane huriki ri rike ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","E BAKOVI DAGI i vakatora mia, i rata mia mi kalolo. I korimule mia. Ia a Vure ne mia si gi kavurikea, ia a Vure ne tamane mia si gi kavurikea a rana. ");
INSERT INTO bnp_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","E BAKOVI DAGI i gao hateka na vabinga; a rana e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","I taribubu a maka karis, a tara na vabinga ne Parao. E huriki a vagana ubu ne Parao ri pasiri na Dari Vururu. ");
INSERT INTO bnp_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","A bokona dari i rere tagu ria; ri pasiri na utu manga a kedo. ");
INSERT INTO bnp_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“BAKOVI DAGI, a limamu a kanemu i gao hateka, i ratapile e huriki a pile. ");
INSERT INTO bnp_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na nitora dagi vomu o ratapile e huriki ri marikoi ioe. A rongova vomu i gutu manga a kanono; i gutu e huriki i manga a kanono i rungani a lulu. ");
INSERT INTO bnp_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","A bangomu i manga a vilu dagi, i ratea a dari i rere, i vakalipopo, i gatuka, i pesi manga a nure. ");
INSERT INTO bnp_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“A pile i bibi i ta maea, ‘Ga valili, ga nugutata ria. Ga bole ga veru a maka mahala ne ria; a maki a ngaru ni bole bara bole kunana. Ga lalu talea a bainat nau ga rabalaki ria.’ ");
INSERT INTO bnp_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pali ioe o bango tala balaka taku kunana, a dari i kavitagu ria. Ri pasiri puru na lilodari manga a kedo. ");
INSERT INTO bnp_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“BAKOVI DAGI, i uka tara vure ge manga ioe. Ioe a hariki dagi, o malamala hateka, a nitora vomu i dagi hateka. A bagetua vomu i kamumu hateka. O rata a maka nivakasiri, e huriki ri turutu, ri mangenge. ");
INSERT INTO bnp_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","O toto tala a limamu a kanemu, lakea a malala i mapuka, i todo ria. ");
INSERT INTO bnp_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“O dodo mia, o kori mia o vakasiri mia na dala. Na nitora vomu o rupolo mia na tanga kamumu vomu. ");
INSERT INTO bnp_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","E huriki bara ri longoa a velengana maki i bele, ri mangenge hateka. E huriki a Palestina ranga ri mangenge. ");
INSERT INTO bnp_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Nimariu E huriki a matakari o Idom ri mangenge hateka, e huriki a ubu na tara o Moab i vakulu a tagane ria, a nitora ne huriki a Kenan i lobo tavula. ");
INSERT INTO bnp_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Nimariu Ri masia a nitora dagi vomu, ri mangenge, ri keri ni ratea tara maki. Ri pesi tavula kunana manga a kedo, i harena ne huriki a viri vomu ri vano. BAKOVI DAGI, ioe kunana o bole tala mia o Egipto, ngane mi laho malimali. ");
INSERT INTO bnp_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nimariu O taparaki valai mia koea, mi gi made kamumu na lolo vomu, na tabeke o hae a roho vomu vona. ");
INSERT INTO bnp_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Nimariu BAKOVI DAGI, a nimatakari vomu i tabuli vakaroro.” ");
INSERT INTO bnp_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","A Dari Vururu i mahasi, lakea e huriki a Israel ri laho polo. Muri e BAKOVI DAGI i ratea a dari i hamule mai a murina, i kavitagu a tara na vabinga ne Parao, turana a maka karis a hos ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Muri e Miriam, a propet ngatavine, e kurabane Aron, i bolea a kude i kalolo i raulo turane huriki a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","E Miriam i kaloloa a linge iea, “Si gi kalolo lakea ne BAKOVI DAGI a linge, a vuhuna i mulangi na vabinga dagi. I voro puru na dari a maka hos turana e huriki ri rike ne ria.” ");
INSERT INTO bnp_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Muri e Moses i muga ne huriki a Israel ri pea a Dari Vururu, ri laho na parava i tolu lakea na tabeke i ngeki ne Sur, i uka ma ri masia tara naru. ");
INSERT INTO bnp_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Na tahuna ri bele na tanga e Mara, i uka ma ri nua a naru vona, a vuhuna i nami hurari. ");
INSERT INTO bnp_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Lakea e huriki ri tahatea e Moses, “A ra mi gi nua ngane?” ");
INSERT INTO bnp_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Muri e Moses i vasileki ne BAKOVI DAGI, lakea e BAKOVI DAGI i vakasiria vona tara rahana kai. I bolea a rahana kai i voro puru na naru, i nami kamumu a naru. Na tanga iea e BAKOVI DAGI i habia ne huriki a Israel tara vinara ge toni ria vona ri gi ramaia o ge uka. ");
INSERT INTO bnp_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I taki ria, “Mu longo kamumu a nitagu. Iau e BAKOVI DAGI a Vure ne mua. A vakamahuri mua na gilanga. Mu longototo iau, mu rata a naro ge kamumu, mu ramai a maka vinara, a nitovo nau, i uka ma ga ratapile mua na maka gilanga, i manga a hini a rata ne huriki a Egipto.” ");
INSERT INTO bnp_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Muri e huriki a Israel ri vano ri bele o Elim. Ra tanga iea i tahoka a naru i ravulu a polona i rua, a kai a det i ravulu polorua (70). Lakea ri hae vonga a kape ne ria tabukoi na naru. ");
INSERT INTO bnp_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","A keva i rua, a parava i ravulu a polona i lima i polo na tahuna ri pea pali e Egipto, ngane e huriki a Israel ri pea e Elim. Ri vano ri bele na tabeke i ngeki ne Sin, na koropalane Elim e Sinai. ");
INSERT INTO bnp_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Na tahuna ri made na tabeke i ngeki, ri deke ne Moses e Aron. ");
INSERT INTO bnp_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ri ta maea, “I kamumu hateka mi gi mate na limane BAKOVI DAGI o Egipto! Na tahuna mi made vonga mi kani a kinani legelege, mi maru. Pali marua muru tamitala valai mia koea, muru ngaru mia lobo mi gi mate na vitoloa na tabeke i ngeki.” ");
INSERT INTO bnp_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Muri e BAKOVI DAGI i takia e Moses, “Iau ga vakaboru valai na hunu a bret. Mu bole, mu kani. Na parava takutaku e huriki ri gi vano ri gi leba. Ga toni ria vona a naro iea, ri gi longototo a nitagu, o ge uka. ");
INSERT INTO bnp_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Na polotarana parava ri gi leba ne vona a parava ge rua.” ");
INSERT INTO bnp_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Lakea e Moses e Aron ru gale palupu e huriki a Israel ru ta maea, “Na malunga bara mu lohoka vona e BAKOVI DAGI, ra i bole tala mua o Egipto, ");
INSERT INTO bnp_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","bara mu masia a nipara vona na hatelanga, a vuhuna mu deke hateka vona. Ra maria, maria a bakovi tavula, pali i navai mu deke valai ne maria?” ");
INSERT INTO bnp_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","E Moses i ta tabu i ta maea, “Na malunga e BAKOVI DAGI ge habi a kania ne mua, na hatelanga ge habi a bret ne mua, a vuhuna i longoa pali a nideke ne mua. Ra maria, maria e rei muholi? Ra mua, i uka ma mu deke ne maria, mu deke ne BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Muri e Moses i takia e Aron, “O taki e huriki ri gi valai tabukoi ne BAKOVI DAGI, a vuhuna i longoa pali a nideke ne ria.” ");
INSERT INTO bnp_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Na tahuna e Aron i ta, e huriki a Israel ri mata lokovonga na tabeke i ngeki ri masia a nipara ne BAKOVI DAGI i parai a bubu. ");
INSERT INTO bnp_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Lakea e BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“A longoa pali a nideke ne huriki a Israel. O vano o taki ria, na malunga bara ri kani a kania, na hatelanga bara ri kani a bret. Muri bara ri lohoka vona, iau kunana e BAKOVI DAGI, a Vure ne ria.” ");
INSERT INTO bnp_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Na malunga a maka kadirovo ri bebe valai ri toka viliha na mada. Na hatelanga a simuru i vakamea a dahana mada. ");
INSERT INTO bnp_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Na tahuna a simuru i malaharere, a maka maki i keakea ri tabuli viliha na tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Na tahuna e huriki a Israel ri matai a maki nga, ri vanana, “A ra maki nga?” Lakea e Moses i taki ria, “Ra maki nga a bret, e BAKOVI DAGI i habi mu gu kani. ");
INSERT INTO bnp_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","E BAKOVI DAGI i vakuku maea, ‘A bakovi ge tahoni na ningaru vona a bret ge kani a kabu vona, a ulo kiroko na bret ge taku ne vona a viri ala taku, ge vakanakana e huriki ri made na kape vona.’” ");
INSERT INTO bnp_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","E huriki a Israel ri rata manga a hini i taki. Ri bole kupo hateka ranga, ri bole popote ranga. ");
INSERT INTO bnp_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Pali muri ri veru kamumu a bret. E huriki ri poi i kupo, ri kani, pali i uka kalavana ge tabuli mule. E huriki ri poi i popote, ri kani, ri maru. E huriki lobo ri poi, i kara ria. ");
INSERT INTO bnp_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Muri e Moses i taki ria, “Naha ni ru mule ranga bret mu gu kani kuduvi.” ");
INSERT INTO bnp_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pali e huriki ranga i uka ma ri longo mai a nitane Moses, lakea ri ru here ranga bret ne vona a hini kuduvi. Na hatelanga, a maka bret ri mavuru, i pidi ne ria a mata kiroko. Lakea e Moses i tahate ria. ");
INSERT INTO bnp_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Na hatelanga lobo e huriki ri bole a bret na ningaru ne ria. A bakovi i taku i tahoni vona a bret na ulo kiroko i taku. Na tahuna a haro i hera a maka bret, ri malaharere tavula. ");
INSERT INTO bnp_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Na polotarana parava ri bole kadolu a bret ne vona a parava i rua. A bakovi i taku i tahoni na ulo kiroko i rua a bret vona. E huriki a matakari ne Israel ri vakalongo e Moses vona a maki ri rata. ");
INSERT INTO bnp_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Muri e Moses i taki ria, “Kuduvi, a Parava Nimalo, ni gamai ne BAKOVI DAGI. A maki ni kani mu ngaru ni gutu o nono, mu gutu mu nono ngane. A maki ni kani ranga ri tababana, ngi ranga mu ru ne vona a hini kuduvi.” ");
INSERT INTO bnp_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ri ramai a nitane Moses, ri gutu a maki ni kani, ri ru kamumu ranga ne vona a parava muri. Ra maki ni kani nga i uka ma ri mavuru, ge pidi ne ria a mata kiroko. ");
INSERT INTO bnp_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Na parava muri e Moses i taki ria, “Mu kani a maki mu kani kaleva ravi. Mona a Parava Nimalo ne BAKOVI DAGI, i uka ma mu gu matavisi na malala ranga bret. ");
INSERT INTO bnp_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Na parava i polotara mu bole a bret, pali na poloruana parava, a Parava Nimalo, a bret i uka ma ge boru valai na hunu. ");
INSERT INTO bnp_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pali ranga e huriki ri vano ta ri gi bole a bret, pali i uka ma ri matavisi. ");
INSERT INTO bnp_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Lakea e BAKOVI DAGI i takia e Moses, “Balaka riva mu marikoi ni longo a nitagu, mu gu ramai a vinara nau? ");
INSERT INTO bnp_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mu longo kamumu, iau e BAKOVI DAGI a habia ne mua a Parava Nimalo. A rata mavonga, a vuhuna na polotarana parava a habi a maki ni kani ne vona a parava i rua. Na poloruana parava mua lobo mu gu made na kape ne mua. Nahea tara viri ge laho viliha.” ");
INSERT INTO bnp_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Lakea e huriki ri malo vona a poloruana parava. ");
INSERT INTO bnp_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","E huriki a Israel ri galea a bret iea a mana. Ra maki iea i keakea i manga a kanena kai tara. I nami manga a bisket ni kani turana a ame. ");
INSERT INTO bnp_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Muri e Moses i taki ria, “E BAKOVI DAGI i taki mua mu gu bolea a ulo kiroko, mu gu tahoni a mana vona, ge tabuli ni gi vakatungu e huriki a hamone mua vona. Muri ma, bara ri masia a bret e Bakovi Dagi i habia ne mua, na tahuna i vakamariu tala mua o Egipto, i tuli valai mua koea.” ");
INSERT INTO bnp_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Muri e Moses i takia e Aron, “O bolea tara ulo kiroko o tahoni vona a mana. O ru na ngalane BAKOVI DAGI, muri ma e huriki a hamone hita bara ri masia.” ");
INSERT INTO bnp_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Lakea e Aron i bolea a ulo kiroko i tahoni ranga mana, i ru tabukoia na tava ni ru a vinara na Vure vona. I ramaia a ngava e BAKOVI DAGI i takia e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","E huriki a Israel ri kani kunana a mana na pida i ravulu va, i harena na tahuna ri bele na nagi na malala kamumu e Kenan. ");
INSERT INTO bnp_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Na tahuna iea ri tahoka a ulo ni matai a mavana maki vona. I tara i manga a ulo kiroko. I tara i manga a ulo kiroko i ravulu ni ru vapopo.) ");
INSERT INTO bnp_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","E huriki a Israel ri ramai a nitane BAKOVI DAGI, ri pea a tabeke i ngeki e Sin. Na tahuna e Bakovi Dagi i taki ria ri gi vano, bara ri malaga ri vano. Ri vano ri bele na tanga e Repidim, ri rata a mada, pali ra tanga iea i uka naru. ");
INSERT INTO bnp_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Lakea ri tahatea e Moses ri ta maea, “O matakanea ngane a naru mi gi nua!” E Moses i koli, i ta maea, “I navai mu tahate iau? Mu ngaru ni toni a nitora ne BAKOVI DAGI?” ");
INSERT INTO bnp_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Pali e huriki ri mate na marohua, ri deke lakea ne Moses, ri ta maea, “Ge ra o tuli tala mia o Egipto? O ngaru mi gi mate turane huriki e tune mia, a sipsip a bulmakau ne mia?” ");
INSERT INTO bnp_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Muri e Moses i vasileki ne BAKOVI DAGI i ta maea, “A ra ga rata virihi ria vona e huriki nga? Ri tahate hateka, ri ngaru ni padimate iau na kedo.” ");
INSERT INTO bnp_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Lakea e BAKOVI DAGI i takia e Moses, “O laho muga o taki e huriki a gare ne Israel ri gi laho turamu. O bolea a kodo, ra o lagu e Nail vona, o vano. ");
INSERT INTO bnp_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Iau ga pesi langa na kedo na lolo e Horeb, ga dava mua vonga. Na tahuna o valai tabukoi, o bolea a kodo vomu o ubia a kedo dagi, ge bele a naru ge ninu e huriki a viri vomu.” E huriki a gare ri masia e Moses, i ubia a kedo dagi i bele a naru. ");
INSERT INTO bnp_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ri galea a hini nga e Masa e Meriba, a vuhuna e huriki a Israel ri tahate, ri ta maea, “E BAKOVI DAGI i made turane hita, o i uka?” Na naro iea kunana ri ngaru ni tonia e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Muri e huriki a Amalek ri valai ri vaubi turane huriki a Israel o Repidim. ");
INSERT INTO bnp_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Lakea e Moses i takia e Iosua, i ta maea, “O vulaki ranga bakovi ne hita. Kuduvi mu vano mu vaubi turane huriki a Amalek. Iau ga pesi langa na lolo, ga nugua a kodo na Vure.” ");
INSERT INTO bnp_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Lakea e Iosua i bole ranga bakovi, ri vano ri vaubi turane huriki a Amalek. E Moses turana e Aron e Hur to sike na lolo. ");
INSERT INTO bnp_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Na tahuna e Moses i toto rike a limana, e huriki a Israel ri vaubi kinigao. Pali na tahuna i totopuru a limana e huriki a Amalek ri vaubi kinigao. ");
INSERT INTO bnp_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Muri e Moses i malulu a limana, i uka ma i toto rike tabu. Lakea e Aron e Hur ru vakamade rikea na kedo. I pesi na dahana koea tara, i pesi na dahana lake tara, ru nugu rike a limana, i harena na haro i rolo. ");
INSERT INTO bnp_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Lakea e Iosua turane huriki a tara vona ri rangi, ri ratapile e huriki a tara ne Amalek. ");
INSERT INTO bnp_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Muri e BAKOVI DAGI i takia e Moses, “O herea na puhu a ngava iea ge luhoia e huriki, e Iosua tara ge longoa a ngava. A ngava i maea: iau ga vakalobo liu e huriki a Amalek, i uka ma ni gi luhoi mule tabu.” ");
INSERT INTO bnp_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","E BAKOVI DAGI i ta lobo, lakea e Moses i ratea tara dede i galea, “E BAKOVI DAGI ia a Nivakasiri nau.” ");
INSERT INTO bnp_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Lakea e Moses i ta maea, “E huriki a Amalek ri gege a nitora ne Bakovi Dagi. I mavonga e BAKOVI DAGI bara i vaubi turane huriki a hamone ria vakaroro.” ");
INSERT INTO bnp_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ngane e Ietro, a prister o Midian, e lahuane Moses, i longo a nuverei na maki a Vure i rata ne Moses turane huriki a Israel, na tahuna e BAKOVI DAGI i vakamariu tala ria o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Na parava tara, i valai i gosia e Moses. Na tahuna i lakea pali, e Moses i rudua e girihina e Sipora i lakea ne tamana. Ngane e Ietro i talo mulea e Sipora, ");
INSERT INTO bnp_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","turane tune Moses ala rua bakovi. A tabua a rane Gersom. Muga e Moses i ta maea, “Iau a mosi, a valai a made na robo basi.” ");
INSERT INTO bnp_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","A koma bakovi tara a rana e Elieser. Muga e Moses i ta maea, “A Vure ne tata mai i tuhori iau, i korimule iau na limane Parao.” ");
INSERT INTO bnp_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","E Ietro turane Sipora, e tune Moses ala rua ri lakea na tabeke i ngeki tabukoi na lolo na Vure, ra tabeke e Moses i rata a mada i made muga vona. ");
INSERT INTO bnp_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","E Ietro i talo rike a ngava ne Moses i ta maea, “Iau e Ietro e lahuamu. Ngane a valai turane girihimu, e tumu bakovi ala rua. ");
INSERT INTO bnp_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Na tahuna e Moses i longoa a ngava iea i vano i tagui e Ietro na dala. E Moses i lolu puru na ngalane Ietro, i ngurua a garena. Ru vatagui lobo, muri ru dili na kape. ");
INSERT INTO bnp_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Lakea e Moses i vakalongo e Ietro vona a maki lobo e BAKOVI DAGI i rata ne huriki a Egipto, i tuhori e huriki a Israel. I vakalongo e Ietro vona a maka maregoa i bele ne ria na dala, na naro e BAKOVI DAGI i tuhori i matakari ria. ");
INSERT INTO bnp_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","E Ietro i vivi na tahuna i longo a maka nuverei ne BAKOVI DAGI i rata, i korimule e huriki a Israel na limane huriki a Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Lakea i ta maea, “Ni gi kavurike a rane BAKOVI DAGI, i korimule mua na limane huriki a Egipto, na limane Parao. ");
INSERT INTO bnp_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ngane a lohoka vona e BAKOVI DAGI i rangi a vure lobo, a vuhuna i matakari mua na tahuna e huriki a Egipto ri vakavora hateka mua.” ");
INSERT INTO bnp_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ru tuverei lobo, lakea e Ietro i bole a maka nihabi gutu-vuro turana a nihabi ranga, i habi na Vure. Muri e Aron turane huriki a gare ne Israel ri valai ri kani a bret turane Ietro na matana Vure. ");
INSERT INTO bnp_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Na parava muri e Moses i made i talangaki a maka maregoa ne huriki a Israel. E huriki ri ngaru ni masia ri pesi haluia na hatelanga i harena na malunga. ");
INSERT INTO bnp_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","E Ietro i matai a maki e Moses i rata ge tuhori e huriki, lakea i takia, “Ioe o rata hateka a leho ni tuhori e huriki. I navai ioe kunana o ratea a leho iea, na tahuna ri valai ri pesi halui ioe na hatelanga i harena na malunga?” ");
INSERT INTO bnp_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Lakea e Moses i koli, i ta maea, “Ri ngaru ni lohoka na maki a Vure i ngaru ri gi rata, lakea ri valai nau. ");
INSERT INTO bnp_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Na tahuna a bakovi ala rua ru tahoka a rongova na maki tara, bara ru valai nau, a pelekado rua, a vakalobo a rongova ne rua. Muri bara tovo rua na maka vinara na Vure.” ");
INSERT INTO bnp_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Lakea e Ietro i takia, “Ioe i uka ma o lohoka ni ratena a leho iea. ");
INSERT INTO bnp_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ra leho iea i mava hateka vomu. Ioe kikeri i uka ma o kara ni ratena. Bara i vakamalulu a tuhamu. ");
INSERT INTO bnp_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","O longo valai, ga taki ioe vona tara naro go ratea vona a leho vomu. Ioe o ramaia, a Vure bara i turamu. I kamumu hateka go vakalongo a nitana Vure ne huriki. A maka leho ranga, o habi ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Pali ioe, o tovo ria na maka vinara lobo na Vure. O taki ria vona a vinara ri gi ramai, a leho ri gi rata. ");
INSERT INTO bnp_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","O vulaki a bakovi maratarata ri lohoka, ri ta muholi, ri ngaru a Vure, ge ria a bolekori. Ri gi matakari e huriki ge ala 1,000, ge ala 100, ge ala 10. ");
INSERT INTO bnp_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Re huriki nga, ge ria a bakovi ni pelekado a ngava. Ria kunana ri gi pelekado a maregoa kiroko. Pali a maka maregoa dagi ri gi taparaki valai vomu, o pelekado. Na naro iea kunana bara ri tuhori ioe, i uka ma go marego hateka. ");
INSERT INTO bnp_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","O ramaia a ngava a taki ioe vona, a vuhuna a Vure kunana i ngaru ioe go ratea. Ioe bara o ramai a ngava nau, i uka ma ge malulu a tuhamu. Muri e huriki bara ri hamule na tanga ne ria ri vivi.” ");
INSERT INTO bnp_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","E Moses i longo mai a ngava kamumu ne Ietro. ");
INSERT INTO bnp_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","I vulaki e huriki a bakovi kamumu na lohokanga ne Israel, i ru ria a bolekori, ri matakari e huriki ala 1,000, ala 100, ala 10. ");
INSERT INTO bnp_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","A leho ne ria ri longo a ngava na maregoa, ri pelekado. A maka maregoa kiroko ri pelekado. Pali a maka maregoa dagi ri bole lakea ne Moses i pelekado. ");
INSERT INTO bnp_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Muri e Moses i taloa e lahuana, i hamule mai a robo vona. ");
INSERT INTO bnp_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","E huriki a Israel ri mariu tala o Repidim ri vano. Na mugana parava na toluna keva na tahuna ri pe e Egipto, ri bele na tabeke i ngeki ne Sinai, ri rata a mada tabukoi na lolo. ");
INSERT INTO bnp_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Muri e Moses i sike na lolo ge taguia e BAKOVI DAGI, lakea a Vure i galea, i takia, “O vakalongo e huriki a hamone Iakop, ra kabu ne Israel, vona a maka ngava nga. ");
INSERT INTO bnp_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Mu matai a maki a rata pali ne huriki a Egipto. A boko mua manga a loha i boko e tuna na karapana, a taparaki valai mua koea. ");
INSERT INTO bnp_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Mua bara mu longo mai iau, mu ramaia a ngava dagi nau, bara vulaki mua ge mua a tara nau. A maki lobo, e huriki lobo na malala, ria ranga ne nau. ");
INSERT INTO bnp_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","A ngaru mua mu gu made malamala, ge mua e huriki a viri nau, mu gu rata a leho manga a prister. Ra ngava nga o vakalongo e huriki a Israel vona.” ");
INSERT INTO bnp_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","E Moses i pea a lolo, i puru, i gale palupu e huriki a gare ne Israel, i taki ria vona a ngava lobo ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ri ta palupu ri ta maea, “Mi gi rata a maki e BAKOVI DAGI i taki.” Muri e Moses i vano, i taki e BAKOVI DAGI vona a ngava ne huriki ri taki. ");
INSERT INTO bnp_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Lakea e BAKOVI DAGI i takia e Moses, “Iau ga made na bubu dagi ga valai vomu. E huriki ri gi longo iau a ta turamu, bara ri luhoi vakaroroa a nitamu i muholi.” Muri e Moses i taki e BAKOVI DAGI vona a maka ngava i taki e huriki. ");
INSERT INTO bnp_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","E BAKOVI DAGI i takia e Moses, “O vano o taki e huriki, mona, kuduvi ri gi taki tala a naro hale ne ria, ri gi loi na naru a maka varakia ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Girira na toluna parava ri gi dava iau, ga puru valai na lolo e Sinai, ria lobo ri gi matai iau. ");
INSERT INTO bnp_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","O ru haluia na lolo a nagi, o taki ria nahea a viri ge pagepoloa, ge sike na mapana lolo. A viri ge pagepoloa a nagi iea, bara ni rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Pali nahea ni gi ubi na lima. Ni gi padimate na kedo o na maheto. A bakovi o a sipsip a bulmakau ge pagepoloa a nagi iea, i uka ma ge mahuri. I tahoka a parava bara mu sike valai na lolo, na tahuna mu longo a tavure i sidi.” ");
INSERT INTO bnp_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Lakea e Moses i pe a lolo, i puru i taki e huriki ri gi loi a varakia ne ria, ri gi pelekado ria, ri gi kavurikea a Vure. ");
INSERT INTO bnp_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Muri e Moses i taki ria, “Mu kisi puru mua, ge vakatubu mona ge harena girira. Naha ni mahita turana a ngatavine.” ");
INSERT INTO bnp_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Na hatelanga na toluna parava, a bubu i kururu i pelaka, i maravila lae, i kavitagua a lolo. A tavure i tangi dagi hateka. E huriki ri made na mada ri mangenge hateka. ");
INSERT INTO bnp_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Muri e Moses i tuli tala ria na mada, ri pesi na dahana lolo, ri taguia a Vure. ");
INSERT INTO bnp_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","A lolo e Sinai i vuruke, a pokona kanono i kavitagua, a vuhuna e BAKOVI DAGI i puru valai turana a kanono dagi i made pololilo vona. ");
INSERT INTO bnp_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","A nangina tavure i tangi dagi hateka. Muri e Moses i ta turana Vure. A bubu i kururu i pelaka. E Moses i longoa a Vure i ta pololilo na bubu i koli a nitana. ");
INSERT INTO bnp_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Muri e BAKOVI DAGI i puru na mapana lolo, i galea e Moses i valai vona. Lakea e Moses i sike na lolo. ");
INSERT INTO bnp_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Lakea e BAKOVI DAGI i takia, “O puru o taki tora e huriki, nahea ge ruru a vurene ria ri gi polo taroa a nagi, ri gi valai ri gi matai iau. A viri ge polotaroa a nagi iea ge matai iau, bara i mate. ");
INSERT INTO bnp_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","E huriki a prister ra ri valai tabukoi nau, ria ranga, ri gi pelekado ria, ri gi valai tabukoi na matagu. Ge uka bara a ratapile ria.” ");
INSERT INTO bnp_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","E Moses i takia e BAKOVI DAGI, “E huriki i uka ma ri gi sike valai na lolo e Sinai, a vuhuna o habi tora a ngava ne ria nahea ri gi sike valai. O taki iau ga ru halui a nagi na lolo, ga vakalongo ria vona ra tabeke ni ru halui a nagi vona o tabea pali.” ");
INSERT INTO bnp_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","E BAKOVI DAGI i koli, i ta maea, “O puru o takia e Aron, ge sike valai turamu. Pali e huriki a prister, a bakovi a ngatavine nahea ri gi polotaroa a nagi, ri gi sike valai nau. E rei i longotaro a ngava bara ratapilea.” ");
INSERT INTO bnp_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Lakea e Moses i puru i vakalongo e huriki. ");
INSERT INTO bnp_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","A Vure i taki e huriki a Israel i ta maea, ");
INSERT INTO bnp_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Iau kunana e BAKOVI DAGI a Vure ne mua, a bole tala mua o Egipto, ra tanga ni vakavora mua vona. ");
INSERT INTO bnp_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Mu ramai iau kunana, naha ni ramai a maka vure ranga. ");
INSERT INTO bnp_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Naha ni kau na kai o na kedo a hanuna vure o a hanuna maki i tabuli polomeli na hunu, i tabuli polotano na malala, i tabuli polotano na dari. ");
INSERT INTO bnp_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Naha ni turume ni kavurike ria, a vuhuna iau e BAKOVI DAGI, iau a Vure ne mua, i uka ma ga matataroa tara vure ge kuloi iau. E huriki ri marikoi iau, bara ratapile e huriki a hamone ria ge harena ne tubune ria o ne tamarane ria. ");
INSERT INTO bnp_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","E huriki ri ngaru iau, ri gi ramai a maka vinara nau, bara ngaru vakaroro ria, a ngaru a hamone ria i ravulu rangale (1,000). ");
INSERT INTO bnp_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Naha ni kurahi tavulea a ragu, e BAKOVI DAGI, a Vure ne mua. A viri i kurahi tavulea a ragu bara i tahoka a ngava. ");
INSERT INTO bnp_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Mu luhoi mulea a Parava Nimalo, mu ru herea ge a parava nau kunana. ");
INSERT INTO bnp_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Mu leho na parava i polotara, na vik i taku, ");
INSERT INTO bnp_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","pali a poloruana parava ia a Parava Nimalo ne BAKOVI DAGI, a Vure ne mua. Ra parava iea naha ni leho, mu malo vona turane huriki e tune mua, a vora ne mua, a sipsip a bulmakau ne mua, e huriki a mosi ri made turane mua. ");
INSERT INTO bnp_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Mu rata mavonga, a vuhuna na parava i polotara, e BAKOVI DAGI i rata rike a hunu, a malala, a dari, a maki lobo i tabuli ne tou. Pali na poloruana parava, i malo, i gamaia a Parava Nimalo, i ratea i malamala. ");
INSERT INTO bnp_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Mu togo e kinane mua e tamane mua, lakea bara mu made tabaka na malala e BAKOVI DAGI, a Vure ne mua i habia ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Naha ni rabalaki a viri. ");
INSERT INTO bnp_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Naha ni rata a naro na molenga. ");
INSERT INTO bnp_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Naha ni panaho. ");
INSERT INTO bnp_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Naha ni tami a turamu na ngava. ");
INSERT INTO bnp_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Naha ni ngutu na ruma na viri tara o ne girihina, ne huriki a vora vona, a bulmakau a donki vona, a mahala vona.” ");
INSERT INTO bnp_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Na tahuna e huriki a Israel ri longoa a bubu i kururu, ri longoa a tavure i sidi, ri masia a pokona kanono i kavitagua a lolo, ri mangenge, i vakulu a tagane ria. Lakea ri karuku hamule, ri pesi basi, ");
INSERT INTO bnp_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ri takia e Moses, “Ioe kunana o ta turane mia mi gi longo. Pali a Vure nahea ge ta valai ne mia, ma mi gi mate.” ");
INSERT INTO bnp_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Lakea e Moses i taki ria, “Naha ni mangenge, a Vure i valai ge toni mua kunana, mu gu mangenge vona, nahea mu gu rata a naro hale.” ");
INSERT INTO bnp_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","E huriki ri pesi basi, pali e Moses kunana i lokovonga tabukoi na hini i uvo vatubi i made vona a Vure. ");
INSERT INTO bnp_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Muri e Bakovi Dagi i takia e Moses, “O taki e huriki a Israel e BAKOVI DAGI i ta maea, ‘Mu matai pali iau a made na hunu a ta turane mua. ");
INSERT INTO bnp_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Naha ni rata a maka vure na gol a silva mu gu kavurike ria. Mu kavurike iau kunana. ");
INSERT INTO bnp_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Mu ratea na malala a dede, mu habi vonga a maka sipsip a bulmakau, ge a nihabi gutu-vuro, ge a nihabi na nivalemu. Na tahuna mu rata mavonga mu kavurike iau, bara rata kamumu mua. ");
INSERT INTO bnp_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Na tahuna mu hae a dede, naha ni haea na kedo ni ubikeve na modona a aen, a vuhuna i uka ma ge kamumu na matagu. ");
INSERT INTO bnp_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Naha ni ratea a dede ge rike hateka mu gu vakapesi a nirike vona, mu gu habi a nihabi. Na tahuna mu rike vona, ma ga ni matai a tagane mua.’” ");
INSERT INTO bnp_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","A Vure i takia e Moses, “O vaka­longo e huriki a Israel vona a vinara nga. ");
INSERT INTO bnp_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Na tahuna o kona a vorakato na Hibru, ge leho kunana vomu na pida ge polotara. Na poloruana pida o rudua ge hamule na tanga vona, pali nahea ge kona ioe muri ge vano. ");
INSERT INTO bnp_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","A vorakato i uka ma i parangi na tahuna o bolea vona, ia kunana ge vano. Pali ia ge tahoka e girihina muga na tahuna o kona ia vona, ge bolea e girihina ge vano turana. ");
INSERT INTO bnp_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Na tahuna a matakari vona i habia na vorakato a ngatavine i parangi vona, i tahoka a koma, a ngatavine turane huriki e tuna ri gi made mule, a bakovi kunana ge vano. ");
INSERT INTO bnp_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Pali a vorakato iea ge marikoi ni vano, a vuhuna i ngaru hateka e girihina, e huriki e tuna, ");
INSERT INTO bnp_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","lakea a matakari vona ge bole lakea na matana roho na Vure, ge bolea a maki i vere ge paditalea a talingana. Muri bara i leho liu vona ge harena na tahuna i mate. ");
INSERT INTO bnp_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Na tahuna a bakovi i habia e tuna a ngatavine ni gi kona ge ia a vorakato, na poloruana pida nahea ni gi longo vona ge vano manga e huriki a vorakato bakovi. ");
INSERT INTO bnp_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Na tahuna a matakari ge parangi vona a ngatavine, muri i marikoi vona, e tamana ngatavine ge konamulea, a vuhuna a matakari vona i uka ma i rata a naro kamumu vona, nahea ge habia na robo basi ni gi kona. ");
INSERT INTO bnp_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Na tahuna a matakari i ngarua e tuna bakovi ge parangi vona a ngatavine, ge rata kamumua, ge manga a hini i rata kamumua e tuna ngatavine. ");
INSERT INTO bnp_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Na tahuna i parangi tabu a ngatavine tara, ge matakari kamumua ra ngatavine muga. Ge habi a maki ni kani, a varakia, ge mahita turana, manga a hini muga. ");
INSERT INTO bnp_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ia i uka ma i rata a maki i tolu nga, ge longo vona a ngatavine ge vano, pali nahea ge habi na ngatavine ranga moni. ");
INSERT INTO bnp_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“A bakovi i ubimatea tara bakovi, ra bakovi iea ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Pali ia i uka ma i luhoi ge rabalakia a bakovi iea, i ngapa vona a hini i mate, ra bakovi i rabalaki a viri ge ha lakea na tanga a ngarua ge lakea vona. ");
INSERT INTO bnp_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","A bakovi i madihi a hatena i rabalakia a turana, muri i ha lakea na dede nau ge vakakori ia, mu bole tala ia mu rabalakia. ");
INSERT INTO bnp_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“E rei a viri i toni ni rabalaki e tamana e kinana, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“A bakovi i panahoa tara viri ge ia a vorakato vona o ge habia ni gi kona, na tahuna ni matavisi, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“E rei a viri i harogi e tamana o e kinana, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“A bakovi i ala rua ru vatahate, lakea a viri tara i padia na kedo o ubia a turana, i uka ma i mate, i mahita kunana na kiri, ");
INSERT INTO bnp_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","muri i bole a kodo i laho, ra bakovi i ubia i uka rarenga. Pali ge koli a moni vona ge vatovotovo turana a maka parava, i uka ma i leho vona, ge matakaria ge tavaga. ");
INSERT INTO bnp_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“A bakovi i ubi a vorakato bakovi o a vorakato ngatavine na lebo i mate liu na parava iea, a bakovi i ubia ni gi vakamadihi. ");
INSERT INTO bnp_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Pali bara vora iea i tavaga muri na parava i taku o i rua, naha ni vakamadihia a bakovi, a vuhuna ra vorakato iea, a vorakato vona kunana. ");
INSERT INTO bnp_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Na tahuna e huriki ri vaubi, lakea ni ubi a ngatavine i singou, muri i podea a koma i mate, e girihina ngatavine ge vakalongoa a mari ni pelekado a maregoa, ge takia a bakovi i ubi a ngatavine ge konea. ");
INSERT INTO bnp_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pali a ngatavine ge bole a vuranga dagi, mu kolia a naro i rata virihia vona. A ngatavine ge mate, a bakovi i rabalakia ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Na tahuna a matana viri, a ngina viri, a limana viri, a vahana viri ni ratapile, mu koli mu rata mavongea na bakovi i vakatubua a rongova. ");
INSERT INTO bnp_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Na tahuna a bakovi i gutua a kuline girihina na kanono, i padia na vito i bele a ngarava, i lagua na lebo, ni gi koli ni gi rata mavonga a bakovi iea. ");
INSERT INTO bnp_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Na tahuna a bakovi i ubia a matana vorakato i ratapilea, ge takia a vorakato ge vano, ge kolia a matana ni ubi. ");
INSERT INTO bnp_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Na tahuna i ubia a vorakato vona i masigo a ngina, a vorakato iea nahea ge leho tabu vona, a mapana ra ngina i masigo. ");
INSERT INTO bnp_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Na tahuna a bulmakau i rabalaki a viri, a bulmakau ni gi padimate na kedo, nahea ni gi kani a bobona. Pali a tahona bulmakau nahea ni gi kau virihi na ngava. ");
INSERT INTO bnp_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Na tahuna a bulmakau i valili i rabalaki bala a viri, ni gi taki a tahona ge ru dilia na nure. Pali ia ge marikoi, lakea a bulmakau i rabalakia tabu tara viri, a bulmakau turana a tahona ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Pali na tahuna ni gi taki ge konea a maregoa vona, ge konea, ge vakakori ia i uka ma ge mate. ");
INSERT INTO bnp_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","A bulmakau ge rabalaki a koma, mu ramai kunanea a vinara iea. ");
INSERT INTO bnp_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","A bulmakau ge rabalakia tara vorakato, a tahona bulmakau ge habia na tahona vorakato a moni silva i 30, muri a bulmakau ni gi padimate na kedo. ");
INSERT INTO bnp_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Na tahuna a bakovi i talea a hinebi na lovo o i kelia a lovo dagi i uka ma i tukaria a hinebi, lakea a bulmakau o a donki i boru puru vona i mate, ");
INSERT INTO bnp_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","a tahona lovo ge konea a tahona bulmakau, a donki ge bolea ge ne vona. ");
INSERT INTO bnp_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Na tahuna a bulmakau na bakovi tara i rabalakia a bulmakau na bakovi tara, ra bakovi nga ru gu habia a bulmakau i mahuri ni gi kona. Muri ru gu vaveru a moni, ru gu pokea a bulmakau i mate, ru gu vaveru tabu. ");
INSERT INTO bnp_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pali, bara bulmakau iea i vaubi i rabalaki bala a bulmakau ranga, a vuhuna a tahona i uka ma i ru dilia na nure, a tahona ge ngulia na tahona bulmakau i mate a bulmakau i mahuri, ge bolea a bulmakau i mate ge ne vona. ");
INSERT INTO bnp_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“A bakovi i panaho a bulmakau o a sipsip, i rabalakia o i habia ni kona, ge koli mule na tahona, a bulmakau ge lima, a sipsip ge va. ");
INSERT INTO bnp_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Ia ge uka a maki ni koli mule a maki i panaho, ra matapanaho iea ni gi habi ni gi kona, ge a mapana ra maki i panaho. Na tahuna a bulmakau o a sipsip ni gi matai i tababana ni mahuri, ge koli balaka rua a maki i panaho. “Na tahuna a matapanaho ni matavisi i puka a ruma, i panaho a maki na rodo, ni gi rabalaki. A bakovi i rabalakia, i uka ngava. Pali a bakovi i panaho na haro ni rabalaki, a viri i rabalakia i tahoka a ngava. ");
INSERT INTO bnp_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Na tahuna a bakovi i matataroa a bulmakau a sipsip vona i laho viliha, i dili tavula na hania na viri tara, a tahona a bulmakau a sipsip ge koli a maki i kani a bulmakau a sipsip vona. ");
INSERT INTO bnp_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Na tahuna a bakovi i rata a kanono, muri a kanono i nono lakea na hania na bakovi tara, i nono a hania vona turana a maka vit i ru kadolu, a bakovi i vakatubu a kanono ge koli a maki i ratapile a kanono. ");
INSERT INTO bnp_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“A bakovi i habi a moni na turana ge matakari, ni panaho na ruma vona a moni. Na tahuna a matapanaho ni matavisi, a matapanaho ge koli balaka rua a moni i panaho. ");
INSERT INTO bnp_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pali a bakovi ni panaho i uka ma ni matavisi, ni gi bole a tahona ruma ge lakea na mari ni pelekado a maregoa, ge nanea, i panaho a moni o i uka. ");
INSERT INTO bnp_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Na tahuna a bakovi ala rua ru vakau vona tara bulmakau, a donki, a sipsip, a kala, a maki i velu, ra bakovi nga ru gu lakea na mari ni pelekado a maregoa, ni gi longo a maregoa ne rua. A bakovi i kau tavula a maki ge koli balaka rua a maki i kau na turana. ");
INSERT INTO bnp_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Na tahuna a bakovi i habia na turana a bulmakau, a sipsip o a maki tara ge matakaria, muri i mate, o ni padiha, o ni lakavu i uka ma ni matai, ");
INSERT INTO bnp_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ra bakovi i habi a bulmakau, a bakovi i bole a bulmakau ru gu dili na roho nau, lakea a bakovi i bole a bulmakau ge kaba na ragu ge ta maea, ‘Muholi hateka, i uka ma a ratapilea a bulmakau vona.’ A tahona bulmakau ge longo maia a nikaba na turana, nahea ge kolia a bulmakau vona i velu. ");
INSERT INTO bnp_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pali a bulmakau iea ni panaho vona, ge kona lakea na tahona. ");
INSERT INTO bnp_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Na tahuna a livoa hateka i rabalakia tara sipsip a bulmakau, a turana ge bole ranga balena i kani kalevea a livoa hateka ge vakasiri. Lakea i uka ma ge konea a maki i rabalakia a livoa hateka. ");
INSERT INTO bnp_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“A bakovi i bolea ne turana tara bulmakau ge rata taro a leho vona, muri a bulmakau i bole a gilanga i mate, a bakovi iea ge kona lakea na tahona. ");
INSERT INTO bnp_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pali a maregoa ge bele na bulmakau na tahuna a tahona ia vonga, a bakovi i bolea nahea ge konea, a vuhuna a moni i habi pali na tahuna i habikaria. ");
INSERT INTO bnp_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“A bakovi i lakavua a sirula, i uka ma ni habikari ge parangi vona, ra bakovi iea ge konea a ngatavine, muri ge bolea a ngatavine iea ge girihina. ");
INSERT INTO bnp_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","E tamana ngatavine i marikoi vona a bakovi iea ge parangi e tuna, i kamumu kunana. Pali a bakovi iea ge konea a ngatavine, ge manga a mapana sirula ni tovo. ");
INSERT INTO bnp_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“A ngatavine i tahoka a malulu ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“E rei a bakovi o a ngatavine i tari a ligo, a sipsip, o a bulmakau tara, ra bakovi o a ngatavine iea ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“E huriki ri gi habi a nihabi nau kunana, e BAKOVI DAGI. A viri i habi a nihabi na vure ranga ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Naha ni rata hale mu gu vakamarego e huriki a mosi, a vuhuna hosi mu made manga a mosi na robo e Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Naha ni rata hale e huriki a havuri, a duku. ");
INSERT INTO bnp_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Na tahuna mu rata hale ria bara ri tangi valai nau, a longo a nitangi ne ria, ");
INSERT INTO bnp_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","mu vakarike a hategu, bara rudu valai e huriki a pile ri gi rabalaki mua. Muri e huriki a ngatavine ne mua bara ria a havuri, e huriki e tune mua bara ria a duku. ");
INSERT INTO bnp_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Na tahuna mu habi a moni na matasia tara ne huriki a viri nau, ge koli kunana a moni i bole. Naha ge habi langa tabu ranga moni. ");
INSERT INTO bnp_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Na tahuna a viri ge bole taroa tara maki vomu, ge habia vomu a varakia vona ge a kilakila na maki i bole, o habi mulea muga na haro ge rolo a varakia vona, ");
INSERT INTO bnp_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","a vuhuna a bakovi iea i tahoka kunana a varakia i taku ge kavitagua vona na rodo. Bara o vakatokua, ge kavitagua na a ra? Na tahuna i tangi valai nau bara tuhoria, a longo maia a nitangi vona, a vuhuna iau a dodo e huriki lobo. ");
INSERT INTO bnp_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Naha ni harogia a Vure, naha ni harogi a matakari ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Naha ni vakatoku ni habi nau a vit, a vain, a oliv ri moro muga. E huriki a koma tabua bakovi, ngi ranga mu habi nau. ");
INSERT INTO bnp_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Mu habi nau tabu a tabua na bulmakau a sipsip. A tuna bulmakau a sipsip ni gi poda, ge laho turane kinana na parava ge polorua. Na polotoluna parava mu habia nau. ");
INSERT INTO bnp_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Iau a vulaki mua a Israel ge mua a viri nau. Naha ni kani a bobona sipsip a bulmakau i rabalaki a livoa hateka na robo. Mu voro lakea na ligo ge kani. ");
INSERT INTO bnp_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Na tahuna mu longoa tara ngava taminga, naha ni vakalongo lae. Naha ni tuhoria a bakovi, ge tami a mari ni pelekado a maregoa na tahuna i pelekadoa a ngava vona. ");
INSERT INTO bnp_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Naha ni ramai e huriki ri rata a naro hale. Naha ni tuhori e huriki ri gi tami a mari ni pelekado a maregoa. ");
INSERT INTO bnp_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","I mavonga tabu, naha ni tuhoria a matasia ge tatami na tahuna i pesi na matana mari ni pelekado a maregoa. ");
INSERT INTO bnp_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Na tahuna mu matai a bulmakau, a donki na gimane mua i puka a nure i laho viliha, mu bae mulea na tahona. ");
INSERT INTO bnp_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Na tahuna mu matai a donki na gimane mua i kaloho a maki i boru, mu tuhoria a donki vona ge kaloho rikea a maki i boru turana. ");
INSERT INTO bnp_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Na tahuna a matasia ge lakea na mari ni pelekado a maregoa ge longoa a ngava vona, naha ni tami virihia na ngava. ");
INSERT INTO bnp_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Naha ni rata a ngava taminga ni kau virihia na ngava hale a bakovi i malamala, ma ni gi rabalaki tavula. Ra bakovi i kau virihi tavula a viri na ngava, a uka ma ga pugea a naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Na tahuna a bakovi i luke mua na moni mu gu tuhoria na ngava, mu gu tami a mari ni pelekado a maregoa, naha ni bole a moni. Ra naro maea i vakaviliha a niluhoi na ngava na bakovi kamumu. ");
INSERT INTO bnp_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Naha ni rata hale e huriki a mosi ri made na tanga ne mua, a vuhuna hosi mua ranga mu made manga a mosi o Egipto. ");
INSERT INTO bnp_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Na pida i polotara mu leho na hania mu ru kadolu a maki ni kani. ");
INSERT INTO bnp_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Na poloruana pida, naha ni leho na hania, a malala ge malo. Naha ni bole a maki ni kani i rike na muriki na tahuna a malala i malo. A vinara i taku kunana mu ratea na hania na viri i varo a oliv. E huriki a matasia kunana ri gi bole a maki ni kani na muriki, muri a maka livoa ri gi kani paru a maki na muriki i bole kaleva e huriki a matasia. ");
INSERT INTO bnp_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Na vik lobo mu leho na parava ge polotara, na parava polorua naha ni leho, a vuhuna a maka donki, a bulmakau, e huriki a vorakato, a mosi ri laho ri made turane mua ri gi malo, ri gi bole a nitora. ");
INSERT INTO bnp_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Mu longo kamumu mu ramai a maka ngava a habi ne mua. Naha ni vasileki na maka vure ranga, naha ni gale a rane ria. ");
INSERT INTO bnp_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“A habu ge tolu ne vona ni kavurike iau, ge balaka tolu na pida lobo. ");
INSERT INTO bnp_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Mu ratea a Habu na Bret i Uka Is, mu kavurike iau. Mu kani a bret i uka is na parava ge polorua i manga a ngava a taki mua vona. A habu iea mu ratea na keva e Abib, a vuhuna na keva iea kunana mu mariu tala o Egipto. Na tahuna mu valai ni kavurike iau, mua takutaku mu bole a nihabi mu habi nau. ");
INSERT INTO bnp_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Mu rata a Habu na Nimirio na tahuna mu vakatubu ni vila kadolu a vit i moro. Na nilobona pida na keva i rara vona a maka kanena kai, mu pasi a maka kanena kai, mu malo na maka kape ne mua, mu ratea a Habu na Nivapopo. ");
INSERT INTO bnp_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Na pida lobo mu rata a habu nga i tolu, mu kavurike iau e Bakovi Dagi a Vure. ");
INSERT INTO bnp_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Na tahuna mu habi a nihabi nau, naha ni habi a sipsip a bulmakau turana a bret i tahoka a is. Mu gutu lobo a vina, ra mu habi nau. Naha ge tabuli ranga ge palala taho a hini na parava muri. ");
INSERT INTO bnp_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Mu bole a maki ni kani ri moro muga, mu bole lakea na roho e BAKOVI DAGI a Vure ne mua. Naha ni nono a tuna meme na namona ruru ne kinana. ");
INSERT INTO bnp_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Mu longo kamumu, ga rudua a agelo nau ge muga mua, ge matakari mua na dala. Ge vano ge taparaki mua na robo a kisi purua ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mu longototoa, mu ramaia a ngavana, a vuhuna iau a made turana. A agelo nau i uka ma ge puga a naro hale ne huriki ri longotaro a ngavana. ");
INSERT INTO bnp_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Mua bara mu longototo a ngavana, iau bara a taga ne mua ga ratapile e huriki a pile ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“A agelo nau bara i muga mua, mu bele na malala ne huriki a Amor, a Hiti, a Peres, a Kenan, a Hivi, a Iebus. Muri bara vakalobo liu ria. ");
INSERT INTO bnp_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Naha ni lolu puru ni kavurike a maka vure ne ria. Naha ni ramai a naro na nivasileki ne ria. Mu ratapile, mu ubikeve a maka vure ne ria ni rata na kedo. ");
INSERT INTO bnp_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mu kavurike iau kunana, e BAKOVI DAGI a Vure ne mua. Mu rata mavonga bara rata kamumu mua, a vakani, a vakaninu, a vakatavaga mua na gilanga. ");
INSERT INTO bnp_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ga matakari e huriki a ngatavine ri singou ri gi poda kamumu. Ria lobo bara ri tahoka a koma. Ga matakari mua bara mu made tabaka na malala. ");
INSERT INTO bnp_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Ga muga mua, ga vakamangenge, ga vakavaroru e huriki a pile ne mua, bara ri ngalakapulo ri ha. ");
INSERT INTO bnp_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ga rudu muga a maka vuvu ri gi tura e huriki a Hivi, a Kenan, a Hiti, ri gi lili tala ria. ");
INSERT INTO bnp_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Pali iau, i uka ma ga lili tala ria na pida ge taku, a vuhuna maka livoa hateka bara ri bele kupo, ri tahona vona a robo, ri ratapile mua. ");
INSERT INTO bnp_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ga lili tala gosi ria, ge harena na tahuna mu bele kupo mu bolea a malala ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“A harena malala ne mua ge vakatubu na Dari Vururu na tabeke ne Akaba ge vano ge harena na Dari na Kurukuruna Malala. Na tabeke mule sike ge vakatubu na naru dagi e Iupretis ge harena na tabeke i ngeki tano. Ga habi a nitora ne mua, bara mu dili vona a malala iea mu ratapile e huriki ri made vona, mu lili tala ria. ");
INSERT INTO bnp_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Naha ni valongo mai a ngava turane ria, naha ni ramai a vure ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Naha ni longo ne ria ri gi made na robo ne mua, ma ri gi piu rike mua, mu gu rata a naro hale nau. Mua bara mu kavurike a maka vure ne ria, bara mu matasia, mu bala maki!” ");
INSERT INTO bnp_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Muri e BAKOVI DAGI i takia e Moses, “A ngaru ioe, e Aron, e Nadap, e Abihu turane huriki a gare ne Israel ri ala ravulu polorua, mu sike valai na lolo, mu pesi basi, mu kavurike iau. ");
INSERT INTO bnp_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ioe kikeri o valai tabukoi nau. E huriki a matakari nahea ri gi valai tabukoi; e huriki a bakovi a ngatavine ria ranga nahea ri gi valai tabukoi.” ");
INSERT INTO bnp_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","E Moses i vano i vakalongo e huriki na maka vinara ne BAKOVI DAGI, lakea ri ta taku ri ta maea, “Mi gi ramai a ngava lobo e BAKOVI DAGI i taki.” ");
INSERT INTO bnp_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Lakea e Moses i here puru na puhu a ngava lobo e BAKOVI DAGI i taki. Na parava muri e Moses i hadongo na hatelanga pokopoko i haea a dede na gagana lolo. I ru tabukoi na dede a kedo i ravulu a polona i rua, ga kilakila na kabu ne Israel. ");
INSERT INTO bnp_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Muri i rudu ranga koma tamuhane ne Israel, ri habi a nihabi gutu-vuro ne BAKOVI DAGI. Ri rabalaki a bulmakau karaba ne vona a nihabi na nivalemu turana Vure. ");
INSERT INTO bnp_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Muri na nihabi, e Moses i bole a darana bulmakau i guru puru na tavila ranga, i voro tamali langa na dede ranga. ");
INSERT INTO bnp_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Muri i bolea a Puhu na Ngava Dagi, i gi poloa ne huriki. Ri longoa ri ta maea, “Mi gi ramai kunanea a nitane BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Muri e Moses i bolea a dara i tabuli na tavila i voro tamali langa ne huriki. Lakea i ta maea, “Ra dara iea i vakatorea a ngava dagi e BAKOVI DAGI i ratea ne mua na tahuna i habi a nitana ne mua.” ");
INSERT INTO bnp_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Muri e Moses, e Aron, e Nadap, e Abihu turane huriki a gare ne Israel ri ala ravulu polorua ri sike na lolo, ");
INSERT INTO bnp_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ri masia a Vure ne huriki a Israel. Ri masia i pesi langa na maki i mata manga a dala ni rata na kedo tara parahidi gomagoma ni gale a sapira. I gomagoma i manga a hunu. ");
INSERT INTO bnp_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Muholi ri masia a Vure, pali i uka ma i ratapile e huriki a gare ne Israel. Muri ri kani ri ninu vonga. ");
INSERT INTO bnp_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","E BAKOVI DAGI i takia e Moses, “O sike valai na lolo, o pesi tabukoi nau. A here pali na kedo i rua a vinara nau. Ga habi vomu a kedo nga i rua, o tovo e huriki vona.” ");
INSERT INTO bnp_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Muri e Moses i longo maia a nitana, i bolea a vora vona e Iosua ru sike na lolo na Vure. ");
INSERT INTO bnp_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","E Moses i taki e huriki a gare, “Mu dava koea miri gi sike taro na lolo, muri miri gi hamule valai. E Aron e Hur ru gu made turane mua. E rei i tahoka a maregoa, ge lakea ne rua ru gu pelekadoa.” ");
INSERT INTO bnp_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Muri e Moses i sike na lolo, a bubu i kavitagua a lolo. ");
INSERT INTO bnp_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","A nipara na Vure i paraia a lolo. Na parava i polotara a bubu i kavitagua a lolo. Na poloruana parava e BAKOVI DAGI i ta tala na bubu, i galea e Moses. ");
INSERT INTO bnp_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","E huriki a Israel ri masia a nipara ne BAKOVI DAGI i manga a kanono na mapana lolo. ");
INSERT INTO bnp_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","E Moses i dili na bubu i laho sike na lolo, i made vonga na parava i ravulu va. ");
INSERT INTO bnp_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“O taki e huriki a Israel ri gi bole a maka nihabi ri gi habi nau. A maki ri ngaru ni habi na hatene ria o bole. ");
INSERT INTO bnp_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","O bole ne ria a gol, a silva, a bras; ");
INSERT INTO bnp_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","a vuna sipsip ge gomagoma, ge vururu, ge kuakua; a kala kamumu ni rata na vuna meme, ");
INSERT INTO bnp_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","na kulina sipsip a toga ni kalu vururu; a kulina lui a bokona kai a akas; ");
INSERT INTO bnp_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","a namona oliv ne vona a lam; a havu ranga ni vuli turana a nibiri ne vona ni gamai; a havu ranga ne vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","a kedo oniks; a kedo parahidi ni gi kolo dili na bagetua na ngalana prister. ");
INSERT INTO bnp_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“O taki e huriki ri gi haea tara kape nau ga made turane ria. ");
INSERT INTO bnp_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","A maka mahalana kape ge manga a hini a taki polo vomu. ");
INSERT INTO bnp_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“O taki e huriki ri gi ratea a Tava na Ngava Dagi na mavilana kai a akas. A niolana ge 110 sentimita, a nibolana ge 66 sentimita, a nipesina ge 66 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","O bole a gol kabakaba, o kavitagu a hini pololilo a hini polovavo na tava, a harena a tava ranga o kavitagu na gol. ");
INSERT INTO bnp_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","O rata na gol a halui ge va o kolotata dili na vahana tava i va. O kolo na tabekena tava tara ge rua, na tabeke tara ge rua. ");
INSERT INTO bnp_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","O rata o naviri na gol a tabekena kai a akas ge rua, ge a binole. ");
INSERT INTO bnp_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","O rodo na halui ra binole nga; ge dili na tabeke koea tara, na tabeke lake tara, ne vona ni kaloho a tava. ");
INSERT INTO bnp_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ra binole nga, ru gu tabuli kunana na halui. Naha ni lalu tala. ");
INSERT INTO bnp_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Muri ga habi vomu a tabekena kedo i rua ru tahoka a Ngava Dagi, o ru pololilo na tava. ");
INSERT INTO bnp_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“O ratea na gol kabakaba a matana tava. Ra matana tava iea a murina nidodo. A niolana ge 110 sentimita, a nibolana ge 66 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","O bole a gol kabakaba o ubi, o rata a hanuna agelo ge rua. ");
INSERT INTO bnp_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","A agelo tara ge pesi na kanena tava, a agelo tara ge pesi na maurina tava. O rata na tabekena gol ge taku na matana tava a agelo nga. ");
INSERT INTO bnp_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ra agelo nga, ru gu vangalai, ru gu pesi langa na murina nidodo. A karapane rua, ru gu vulala tala ge kavitagua a matana tava. ");
INSERT INTO bnp_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ga habi vomu a tabekena kedo ge rua ru tahoka a Ngava Dagi ni here ne rua, o ru dili na tava o tukaria a matana. ");
INSERT INTO bnp_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Iau ga made na tabeke ni puga vuroki a naro hale, na kurukuruna a agelo nga polomeli na matana Tava na Ngava Dagi o tagui iau vonga. Ga vakalongo ioe vona a maka vinara nau, muri o habi ne huriki a Israel ri gi ramai. ");
INSERT INTO bnp_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“O ratea na kai a akas a dede. A niolana ge 88 sentimita, a nibolana ge 44 sentimita, a nipesina ge 66 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","O kavitagua na gol kabakaba, o ratea a gol ge ola o ru haluia na harena. ");
INSERT INTO bnp_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","A nigatukana gol ge 8 sentimita. A maka tabekena gol kiroko ni gi ru halui a harena dede. ");
INSERT INTO bnp_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","O rata na gol a halui ge va, ni gi kolotata dili na vahana nimodo na dede i va. ");
INSERT INTO bnp_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ra halui nga ge tabuli tabukoi na harena dede. ");
INSERT INTO bnp_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","O kau a tabekena kai a akas ge a binole na dede. ");
INSERT INTO bnp_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","O rata a maka pelete a tavila ne vona a havu mangisipa, a buroi a kikei ne vona ni guru dili a nihabi na naru. A maki nga mu rata na gol kabakaba. ");
INSERT INTO bnp_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Na parava vakaroro, a maka bret mu habi nau, mu ru na dede ga matai.” ");
INSERT INTO bnp_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","E Bakovi Dagi i takia e Moses, “O bole a gol kabakaba o ratea a butu ne vona ni ru langa a maka lam vona. A butuna lam o rata maea, O ubi na ama a gol o rata a murina ni vakapesi a lam, a lebona lam, a bako, a hanuna keke. O rata na tabekena gol ge taku. ");
INSERT INTO bnp_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ra butu na lam ge tahoka a bakona ge polotara. Ge tolu na tabeke tara, ge tolu na tabeke tara. ");
INSERT INTO bnp_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","A bakona ge taku ge tahoka a hanuna keke ge tolu, ge manga a purana kai a almon. ");
INSERT INTO bnp_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","A butuna lam tara ge mavonga. Ge tahoka a hanuna keke ge va ge manga a purana kai a almon. ");
INSERT INTO bnp_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","O rata a hanuna pagana keke na taruna murina lam. A keke i taku ge tabuli na taruna murina lam i rua. ");
INSERT INTO bnp_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","O rata na tabekena gol kabakaba ge taku a bako, a maka hanuna keke. ");
INSERT INTO bnp_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Muri o rata a lam ge polorua o ru na maka bako. O ru kamumu a lam ne ria, ri gi parai a hini pololilo na kape nau. ");
INSERT INTO bnp_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","O bole a gol kabakaba o rata a kaira ne vona ni nugu a kanono, a pelete ne vona habulo. ");
INSERT INTO bnp_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","O bole a gol kabakaba ge 35 kilo, o rata a butuna lam turana a maka mahalana. ");
INSERT INTO bnp_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Na tahuna o rata a maki nga, o ramai kamumua a naro a vakasiri ioe vona na lolo. ");
INSERT INTO bnp_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“O kavitagua a mailo nau na kala kamumu ge ravulu. O vakabagetu na hotu gomagoma, na hotu vururu, na hotu kuakua. O rahi dili a hanuna a agelo na kala. ");
INSERT INTO bnp_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","O rata a maka kala nga ge palupulupu; a kala i taku a niolana ge 12 mita, a nibolana ge 2 mita. ");
INSERT INTO bnp_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","O rahi palupu a kala ge lima. A kala ge lima tabu ngi ranga o rahi palupu. ");
INSERT INTO bnp_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","O rata ranga halui na harena kala gomagoma ne vona ni varaki palupu a kala dagi nga i rua. O kolo dili na kala dagi nga a maka halui. ");
INSERT INTO bnp_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","O kolo dili na harena kala muga a halui ge ravulu lima, na kala tara ge ravulu lima. A maka halui nga ge tabuli vakanakana. ");
INSERT INTO bnp_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","O rata a kinau ge ravulu lima, mu varaki palupu a kala nga, ru gu mata manga a kala ge taku. ");
INSERT INTO bnp_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Muri o ratea tara kala dagi ge kavitagua a mailo nau. O rata a maka kala ge 11, ni rata na vuna meme. ");
INSERT INTO bnp_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","A maka kala ge palupulupu; a kala i taku a niolana ge 13 mita, a nibolana ge 2 mita. ");
INSERT INTO bnp_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","O rahi palupu taro ge lima, muri o rahi palupu ge polotara. O rata kamumua a polotarana kala ge kavitagua a matana kape. ");
INSERT INTO bnp_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","O rahi dili na harena kala muga a halui ge ravulu lima, na kala tara ge ravulu lima. ");
INSERT INTO bnp_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","“O rata na bras a kinau ge ravulu lima, o kolo na halui ne vona ni varaki palupu a kala nga i rua, ge manga a kala dagi i taku. ");
INSERT INTO bnp_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ra hini i tavore tala, ge tavore kunana na bitona mailo nau. ");
INSERT INTO bnp_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","A niolana kala i kavitagu a kape ge ola popote; a harena tara ge tabuli tavula ge 50 sentimita, na harena tara ge 50 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","O rata tabu a kala ge rua ge kavitagu a kape, a kulina sipsip a toga ni kalu vururu, a kulina lui ge kavitagu a hini polomeli. ");
INSERT INTO bnp_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“O rata a maka mito na mailo na Vure na kai a akas. ");
INSERT INTO bnp_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","A niolana a maka mito ge 4 mita, a nibolana ge 66 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","A mito ge ola popote, bara ni ru dili na dupina vuhu-butu i tabuli polotano. A maka mito na mailo nau ni gi rata ge maea kunana. ");
INSERT INTO bnp_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Na tabeke mule puru mu rata a mito na nure ge ravulu rua, ");
INSERT INTO bnp_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","a vuhu-butu ni rata na silva ge ravulu va, ri gi tahoka a dupi ni vakapesi a mito. A vuhu-butu ge rua ru gu tabuli polotano na mito i taku. ");
INSERT INTO bnp_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","A nure na tabeke mule sike, ia tara o rata mavongea, o rata a mito ge ravulu rua, ");
INSERT INTO bnp_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","a vuhu-butu ni rata na silva ge ravulu va. A vuhu-butu ge rua ru gu tabuli polotano na mito ge taku. ");
INSERT INTO bnp_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","O rata a mito ge polotara ri gi pesi na bitona mailo nau na nirolona haro. ");
INSERT INTO bnp_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","A mito ge rua ru gu tabuli na nimodo i rua na bitona kape. ");
INSERT INTO bnp_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","O lapi palupu a mito ge rua na nimodona kape i rua mu vakapesi. A nimodo i rua tabu mu rata mavonga. ");
INSERT INTO bnp_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","A bitona kape ge tahoka a mitona nure ge polotolu, a vuhu-butu ni rata na silva ge ravulu a polona i polotara. A vuhu-butu i rua ru gu tabuli polotano na mito i taku. ");
INSERT INTO bnp_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“O bole a kai a akas ge lima, o lapi tavalavala na nure na gagana mailo na Vure. ");
INSERT INTO bnp_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","O rata ge lima na gagana mule puru, ge lima na gagana mule sike, ge lima na bitona mailo nau na gagana nirolona haro. ");
INSERT INTO bnp_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ra karona nure tavalavala na kurukuruna, ge tubu na harena iea ge lobo na harena tara. ");
INSERT INTO bnp_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","O kavitagu a maka mitona kape na gol. O ru dili ranga halui ni rata na gol, ge tangotata a maka karo ni ru tavalavala na nure. A maka karona, ngi ranga ni gi kavitagu na gol. ");
INSERT INTO bnp_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Muri o vakapesia a mailo na Vure, ge ramaia a ngava a taki ioe vona na lolo. ");
INSERT INTO bnp_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“O ratea tara kala o vakabagetua na hotu gomagoma, na hotu kuakua, na hotu vururu ni rata na vuna sipsip. O rahi dili vona a hanuna a agelo. ");
INSERT INTO bnp_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","O bole a kai a akas ge va o rata a butu, o naviri na gol turana a kinau ni rata na gol, o vakapesi na vuhu-butu i va ni rata na silva. ");
INSERT INTO bnp_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","O vakatavorea a kala na maka kinau, muri o bolea a Tava na Ngava Dagi, o rua na bitona kala. Ra kala iea ge nagi mulea a Tabeke Nitaba Hateka na Tabeke Nitaba. ");
INSERT INTO bnp_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","O rua a Tava na Ngava Dagi na Tabeke Nitaba Hateka, o tukaria a matana. Ra matana tava, a murina nidodo. ");
INSERT INTO bnp_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","O rua a dede polovavo na Tabeke Nitaba, na tabeke mule sike na mailo na Vure; a butuna lam o vakapesia na tabeke tano. ");
INSERT INTO bnp_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“O ratea a kala dagi ge a hinebi na kape. O vakabagetua na hotu gomagoma, na hotu vururu, na hotu kuakua ni rata na vuna sipsip. ");
INSERT INTO bnp_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","O rata na kai a akas a butu ge lima o naviri na gol. O bole a kinau ni rata na gol o kolo dili na maka butu ne vona ni vakatavore a kala. O rata na bras a vuhu-butu ge lima, ge tahoka a dupi ne vona ni vakapesi a maka butu. ");
INSERT INTO bnp_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“O ratea na kai a akas a dede na nihabi gutu-vuro a nipesina ge 1 mita 30 sentimita. A harena i va ge palupulupu, ge 2 mita 20 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","O kau a tupi ge va na tabekena kai a akas iea, o ru na nimodo na dede i va, o naviria a dede na bras. ");
INSERT INTO bnp_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","O bole ranga bras o rata a ulo ne vona a habulo, a maka nikuri, a maka tavila, a maka mego, a maka mola. ");
INSERT INTO bnp_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","O ratea na bras a mola ge kabelabela ne vona ni tunu a kanono. O rata a halui ge va na nimodo na dede, ne vona ni rodo polo a binole. ");
INSERT INTO bnp_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","O bolea a mola o ru pololiloa na kurukuruna hini polomeli, a hini polotano na dede. ");
INSERT INTO bnp_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","O bole a tabekena kai a akas o kau kamumu, o naviri na bras ge a binole. ");
INSERT INTO bnp_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Na tahuna a dede ni kaloho, a binole ni gi rodo dili na halui nga. ");
INSERT INTO bnp_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","O ratea a dede ge ngava lokaloka na mavilana kai, ge manga a naro a vakasiri ioe vona na lolo. ");
INSERT INTO bnp_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“O rahia a kala ge ola ni gi kapi halui a mailo na kape. Na tabeke mule puru a niolana kala ge 44 mita ni gi kapi a nure vona. ");
INSERT INTO bnp_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","O bolea a kala o vakatavorea na butu i ravulu rua ni rata na bras. Ra butu nga, o vakapesi langa na vuhu-butu i ravulu rua ni rata na bras. O rata na silva a kinau na kala, a karona nure. ");
INSERT INTO bnp_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","O rata mavongea a nure na tabeke mule sike. A niolana kala ge 44 mita ni gi kapi a nure vona. O bolea a kala o vakatavorea na butu i ravulu rua ni rata na bras. Ra butu nga, ge pesi langa na vuhu-butu i ravulu rua ni rata na bras. ");
INSERT INTO bnp_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Na tabeke na nirolona haro mu vakatavore vonga a kala, a niolana ge 22 mita. O vakapesi vonga a butu ge ravulu, a vuhu-butu ge ravulu ni rata na bras. ");
INSERT INTO bnp_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","A nure na tabeke na nirikena haro na hini i vona a logo, a niolana ge 22 mita. ");
INSERT INTO bnp_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Na tabeke tara polovavo na logo o vakatavorea vonga a kala, a niolana ge 6 mita 60 sentimita. O vakapesi langa vonga na vuhu-butu ge tolu, a butu ge tolu. ");
INSERT INTO bnp_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Na tabeke tara na logo ge mavonga kunana. ");
INSERT INTO bnp_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Na matana kape o vakatavorea tara kala kamumu a niolana ge 9 mita. O rahi dili a maka bagetua vona na maka hotu gomagoma, na hotu vururu, na hotu kuakua ni rata na vuna sipsip. O vakapesi a butu ge va na vuhu-butu ni rata na bras o vakatavorea a kala. ");
INSERT INTO bnp_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","O rata na silva kinau, o varaki a maka butu na nure na karo ni rata na silva. O bole a bras o rata a vuhu-butu ne vona ni vakapesi a butu. ");
INSERT INTO bnp_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","A niolana nure ge 44 mita, a nibolana ge 22 mita, a nipesina ge 2 mita 20 sentimita. O bole a kala keakea kamumu ni gi naviri vona a nure iea. O bole a bras ni gi rata a vuhu-butu ne vona ni vakapesi a butuna nure. ");
INSERT INTO bnp_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","A maka mahalana kape ni gi rata na bras, turana a maka niroka ne vona ni tua kamumu ni vakatora a kape, a niroka na nure. ");
INSERT INTO bnp_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“O taki e huriki a Israel ri gi habi a namona oliv ni gi guru dili na lam ge para vakaroro. ");
INSERT INTO bnp_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","E Aron turane huriki e tuna bakovi, ri gi bole dili na kape a lam ne vona ni tagui iau. Ra lam iea, ni gi ru polovavo na kala i naviri mule a Tava na Ngava Dagi. Na parava lobo ri gi guru dili a namona oliv na lam ge para na roho nau, e BAKOVI DAGI, ge vakatubu na malunga ge harena na hatelanga. E huriki a Israel turane huriki a hamone ria, ri gi ramai vakaroroa a vinara iea. ");
INSERT INTO bnp_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Na tahuna o hamule o taki e turamu e Aron turana e tuna bakovi, e Nadap, e Abihu, e Eleasar, e Itamar, ri gi valai vomu. O tuli tala ria na kurukurune huriki a Israel, o gamai ria ge ria a prister nau. ");
INSERT INTO bnp_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","O rata a maka bagetua ni gamai ne Aron ge rodo, ge mata tebi, ge mata hateka vona. ");
INSERT INTO bnp_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","O taki e huriki a mari ni rahi a bagetua, ri gi rata a maka bagetua ne Aron, ge rodo na tahuna ge bele manga a prister nau. ");
INSERT INTO bnp_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","E huriki a mari ri gi vakabagetu a bagetua nga, a kala kiroko na ngala, a kala kiroko tara, a nirodo ola ola, a siot, a hoi, a palabele. A maka bagetua ni gamai nga, ne vona e Aron turane huriki e tuna bakovi, ri gi bagetu vona na tahuna ri rata a leho na prister. ");
INSERT INTO bnp_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ri gi vakabagetu a maka nirodo nga, na hotu gomagoma, na hotu kuakua, na hotu vururu ni rata na vuna sipsip, a hotu ni rata na gol. ");
INSERT INTO bnp_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","8","“A bagetua na prister ni gi rata na hotu gomagoma, a hotu vururu, a hotu kuakua, a vuna sipsip ni kalu vururu. Muri ni gi vakabagetu na gol. A palabele na loho ni gi rata ge tangotatea a bagetua, a palabele tara ne vona ni rea halui a kakaina prister. ");
INSERT INTO bnp_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“O bole a kedo oniks i rua, o here a rane huriki e tune Israel i ravulu a polona i rua. ");
INSERT INTO bnp_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","O here a rane ria ge ramai a nipodane ria. A rana bakovi ala polotara o here na kedo tara, a rana bakovi polotara tabu o here na kedo tara. ");
INSERT INTO bnp_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ra leho iea, o habia na bakovi i lohoka ni here na kedo, ge here a rane huriki e tune Israel. O bole a gol ge rata a bagetua ge nugutata tora a kedo nga. ");
INSERT INTO bnp_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","O kolo ra kedo nga na palabele i rua na loho, ge tabuli ga kilakila na kabu i ravulu a polona i rua ne Israel. E Aron ge huraki na lohona a rane ria na matane BAKOVI DAGI, ne vona ni luhoi mule e huriki a viri vona. ");
INSERT INTO bnp_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","O taki ria ri gi rata na gol a bagetua ge rua, ");
INSERT INTO bnp_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","a sen ge rua ni gi rata na gol kabakaba ni gi viri, ni gi kolo dili na bagetua na gol. ");
INSERT INTO bnp_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“O bolea tara tabekena kala kamumu o ratea tara kala, ne vona ni ru na ngalana prister dagi. Ra kala iea ne vona ni bole a lohokanga na ningaru na Vure. Ra kala iea o vakabagetua na hotu ni rata na gol, na hotu gomagoma, na hotu kuakua, na hotu vururu. ");
INSERT INTO bnp_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","A niolana kala kiroko iea ge 44 sentimita, a nibolana ge 22 sentimita. Ni gi pilu na kurukuruna ge tabuli palupu a harena ge rua. ");
INSERT INTO bnp_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","O kolo dili na tete ge va a kedo parahidi. Na mugana tete o kolo dili a kedo a rubi, a topas, a beril. ");
INSERT INTO bnp_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Na ruana tete o kolo dili a kedo a emeral, a sapaia, a daiman. ");
INSERT INTO bnp_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Na toluna tete o kolo dili a kedo a iasint, a aget, a ametis. ");
INSERT INTO bnp_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Na vana tete o kolo dili a kedo a krisolait, a oniks, a iaspa. O kolo a kedo parahidi na bagetua kiroko na gol, muri o kolo dilia na kala. ");
INSERT INTO bnp_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","O here a rane huriki e tune Israel ala ravulu a polona i rua na kedo nga. A kedo ge taku ni gi here vona a rana a kabu ge taku. ");
INSERT INTO bnp_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“O bole a gol kabakaba, o ubi ge lili kiroko, o viri a sen ge rua, ge manga a mota ge ne vona a kala na ngala. ");
INSERT INTO bnp_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","O rata a halui ge rua, ni gi varomu na nimodo polomeli na kala kiroko na ngala. ");
INSERT INTO bnp_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","O bole a sen nga o varomu na halui i rua. ");
INSERT INTO bnp_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Na harena sen nga i rua o varomu dili na palabele a bagetua, ge nugutata a kala na prister dagi. ");
INSERT INTO bnp_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","O rata tabu a halui ge rua o kolo pololilo, polotano na nimodo na kala na ngalana prister. ");
INSERT INTO bnp_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","O rata na gol a halui ge rua, o kolo na palabele i nugutata a kala, tabukoi na palabele a prister i rea halui ia vona. ");
INSERT INTO bnp_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","O bole a mota gomagoma o kolo dili na kala na ngala a halui ge rua, muri o kolo lakea tabu na bagetua, bara i tabuli tora a bagetua na ngala. ");
INSERT INTO bnp_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Na tahuna e Aron i dili na Tabeke Nitaba, bara i bolea a kala kiroko iea, i tahoka a rane huriki a kabu ne Israel i ravulu a polona i rua, ge kolotatea na ngalana. Na tahuna a masia i kolotatea na ngalana a kala kiroko iea, iau, e BAKOVI DAGI, bara luhoi mule e huriki a viri nau, a Israel. ");
INSERT INTO bnp_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","O ru a kedo i rua ne vona ni bole a lohokanga na ningaru na Vure, pololilo na poket na kala na ngalana prister. Na tahuna e Aron i dili i pesi na matane BAKOVI DAGI, ge bole dili ra kedo nga. Na parava vakaroro ge koloa na ngalana ra kala iea, ge valai, ge bole a lohokanga na a ra maki e huriki a Israel ri gi rata. ");
INSERT INTO bnp_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“O rata a nirodo ola ola na hotu gomagoma. ");
INSERT INTO bnp_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","A murina gigi ge dili vona, ni gi rahi na hotu gatuka, i uka ma ge marape. ");
INSERT INTO bnp_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","O bole a hotu gomagoma, a hotu kuakua, a hotu vururu, o rahi dili a naro ge manga a kanena kai a pomigranet polotano na bagetua na prister. Na koropalana pomigranet, o rahi dili a belo kiroko ni rata na gol ge tavore. ");
INSERT INTO bnp_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","E Aron ge rodoa a bagetua iea, ge ratea a leho na prister. Na tahuna i valai tabukoi nau na Tabeke Nitaba, na tahuna i hamule pori, e huriki bara ri longoa a nangina belo. Ia i uka ma i ramaia a naro iea bara i mate. ");
INSERT INTO bnp_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“O bolea a gol kabakaba, o ratea a hulongi, o herea vona a ngava iea, ‘Ne vona e BAKOVI DAGI.’ ");
INSERT INTO bnp_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Muri o bolea a mota gomagoma o kolotatea a hulongi, muga na hoi na prister dagi. ");
INSERT INTO bnp_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Na parava vakaroro e Aron ge kubea ra hoi iea i tahoka a hulongi. Lakea iau bara bolea vona a nihabi ni gamai i habia nau e huriki a Israel. Ria bara ri rata ruru ranga naro na nihabi, e Aron bara i bole a rarenga. ");
INSERT INTO bnp_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“O bole a hotu kamumu, mu rahia a harena siot ge tora. O ratea a hoi na kala kamumu ge kubea e Aron. O bolea a tabekena kala o ratea a palabele kiroko, o rahi dili vona a maka bagetua kamumu. ");
INSERT INTO bnp_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","O rata a maka siot, a palabele kiroko, a hoi, ne vona e huriki e tune Aron bakovi, ri gi bagetu vona, ri gi mata hateka na matane huriki. ");
INSERT INTO bnp_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","O vakarodoa na bagetua e Aron, e huriki e tuna. O vakarodo lobo ria, muri o gamai ria, o biri ria na nibiri, o habi ria nau, ge ria a prister, ri gi rata a leho nau. ");
INSERT INTO bnp_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“O rahi a poho ri gi rodo, ma ge lele a tagane ria. ");
INSERT INTO bnp_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","E Aron turane huriki e tuna, ri gi rodo a poho nga na tahuna ri lakea na dede, ri gi rata a leho pololilo na Tabeke Nitaba, o na tahuna ri dili na Kape na Vaponga nau. Ria i uka ma ri rata mavonga, bara ri tahoka a ngava, a rabalaki ria. “E Aron turane huriki a hamona ri gi ramai vakaroroa a vinara iea. ");
INSERT INTO bnp_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ngane ga taki ioe vona a maki go ratea ne Aron turane huriki e tuna, ge ria a prister nau. O bole a bulmakau, a sipsip a toga karaba ge rua ge gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","O bole a bret kamumu ge uka a is, o vuli turana a namona oliv, o rata a bret a bisket. ");
INSERT INTO bnp_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","O ru dili na kulopi a maka bret a bisket o bole valai nau turana a bulmakau, a sipsip nga ge rua. ");
INSERT INTO bnp_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“O tuli valai na matana kape nau e huriki e tune Aron bakovi, o vahilolo ria na naru. ");
INSERT INTO bnp_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Muri o vakarodoa na bagetua na prister e Aron. O vakarodoa na siot, a nirodo ola ola, a kala kiroko, a kala na ngala, o vakarea ia vona a palabele. ");
INSERT INTO bnp_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","O bolea a hoi o vakakubea vona. Muri o bolea a hulongi ni gamai, o pipi dilia na hoi vona. ");
INSERT INTO bnp_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Muri o bolea a nibiri o guru langea na gina o gamaia. ");
INSERT INTO bnp_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","O gamai loboa e Aron o tuli valai e huriki e tuna, o vakarodo ria na siot, ");
INSERT INTO bnp_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","o vakarea ria na palabele, o kae a hoi na gine ria. Ra naro o ratea i vakasiri e Aron turana e tuna mai, ria e huriki a prister nau. Re huriki a bakovi nga, turane huriki a hamone ria bara ri rata vakaroro a leho na prister. ");
INSERT INTO bnp_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“O bole lakea na matana kape nau a bulmakau ge a nihabi. Muri e Aron turane huriki e tuna ri gi ru langa a limane ria na mapana. ");
INSERT INTO bnp_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","O rabalakia na matagu a bulmakau, tabukoi na matana kape nau. ");
INSERT INTO bnp_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","O bole ranga darana bulmakau na kuku limamu, o ru na tupina dede. Muri o bole paru a dara i tababana, o guru polotano na dede. ");
INSERT INTO bnp_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","O bole a maka mahalana bulmakau turana a hatena, a vuanalipina, o gutu na dede. ");
INSERT INTO bnp_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pali a bobona bulmakau, a kulina, a tamudina, o bole tala, o rungani polovavo na mada. Ra bulmakau iea, a nihabi ne vona ni puga vuroki a naro hale. ");
INSERT INTO bnp_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“O bolea a sipsip a toga ge a nihabi. E Aron turana e tuna mai, ri gi ru langa a limane ria na gina tuna sipsip. ");
INSERT INTO bnp_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Muri o rabalakia a sipsip, o bole a darana, o voro langa na tabeke na dede i va. ");
INSERT INTO bnp_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","O poka kesikesia, o vahilolo a vahana ge rua, a maka mahalana, o ru langa na mapana. ");
INSERT INTO bnp_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","O gutu ge vuro lobo liu a sipsip na dede, ge a nihabi gutu-vuro na kanono ne vona e BAKOVI DAGI. Lakea iau bara burongi a mangina bara vivi. ");
INSERT INTO bnp_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“O bole tabua tara sipsip, o taki e Aron turana e tuna mai, ri gi ru langa a limane ria vona. ");
INSERT INTO bnp_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","O rabalakia a sipsip iea, o bole ranga darana o ravu na kanena taruna talingana e Aron, e tuna mai. Muri o bole tabu a dara o ravu na kukukoru na limana a kanena, a kukukoru na vahana a kanene ria. O bole paru a dara i tababana, o voro langa na tabeke lobo na dede. ");
INSERT INTO bnp_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Muri o bole ranga dara i tabuli na gagana dede, a nibiri, o voro langa ne Aron turane huriki e tuna. O voro langa tabu na bagetua ne ria a dara, a nibiri. A naro o ratea ne ria, i vakasiri a bagetua ne ria a maki nau. ");
INSERT INTO bnp_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“O bole tabua tara sipsip a toga, o pokea, o bole lobo a maka vina ge a nihabi na tahuna ni gamai a prister. O bolea a kuna, a kinakena, a hatelilo, a hatekato, a hatelipi turana a vina, a gepena kanena. ");
INSERT INTO bnp_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Na kulopi na bret i uka is, ra nihabi nau, o bole tala a bret ni gutu na namona oliv, a bret tara i uka ma ni gutu na namona oliv, a bisket. ");
INSERT INTO bnp_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Muri o habi a bret a balena sipsip ne Aron, turane huriki e tuna. Ri gi bole a nihabi nga ri gi tabari iau vona, ge a nihabi na nitabari. ");
INSERT INTO bnp_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","O bole na limane ria a maki ni kani, o gutu na dede turana maka nihabi gutu-vuro, ge a nihabi na kanono ne vona e BAKOVI DAGI. Lakea iau bara burongi a mangina bara vivi. ");
INSERT INTO bnp_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","O bolea a siana sipsip ni poka muri ne vona ni gamai e Aron, o tabari iau vona. Muri o bolea ge ne vomu. ");
INSERT INTO bnp_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Na tahuna o ngaru ni ratea tara bakovi ge ia a prister, o bole a siana, a pona sipsip, o tabari iau vona. Muri o habi ne huriki a prister ra maka balena nga. ");
INSERT INTO bnp_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","E huriki a Israel ri gi rata vakaroroa a nihabi iea, ri gi habia nau e BAKOVI DAGI a sipsip, ne vona a nivalemu. Muri ri gi habi ne Aron turane tuna mai a siana, a gepena sipsip, ri gi kani. ");
INSERT INTO bnp_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","30","“Muri ne Aron ge mate, a maka bagetua vona na prister ge vabole polo vona e huriki a hamona. E rei ni gamai ge ia a prister dagi ge bole a murina, ge rodo a maka bagetua nga. Ra bagetua nga ge rodo na parava ge polorua, na tahuna i rata a leho na Tabeke Nitaba pololilo na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Na tahuna o gamai e Aron, e huriki e tuna, o bolea a bobona sipsip a toga ra o habia nau, o ru dili na ulo o nono pololiloa na mailo nitaba. ");
INSERT INTO bnp_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","E Aron turane tuna mai ri gi bole a bobona sipsip a bret i tababana na kulopi, ri gi kani na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ri gi kani ra maki ni kani ni habi nau, ga puga vuroki a naro hale ne ria, na tahuna ni gamai ria ge ria a prister. E huriki a prister kunana ri gi kani ra kinani nga. E huriki a bakovi tavula nahea ri gi kani a vuhuna ni gamai. ");
INSERT INTO bnp_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","A bobona sipsip a bret ranga ge palala taho a hini, naha ni kani. Ra maka kinani nga ni gamai, ni gi gutu na kanono ge vuro. ");
INSERT INTO bnp_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“O ratea a leho iea ni gamai e Aron turane huriki e tuna na parava ge polorua, ge manga a naro a vakuku ioe vona. ");
INSERT INTO bnp_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Na parava lobo o habia nau tara bulmakau, ge a nihabi ni kavitagu a naro hale. Ra nihabi iea ge ratea a dede nau ge matapado na matagu. O guru langa na dede a nibiri, o gamaia ga dede nau. ");
INSERT INTO bnp_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","O gamaia a dede iea na parava ge polorua, ga maki nau kunana. A viri tara ge nugua, a maki tara ge padoia bara i malamala. ");
INSERT INTO bnp_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Na parava vakaroro o bole a tuna sipsip ge rua, a pida ne rua ge taku, o habi na dede. ");
INSERT INTO bnp_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","O habia na hatelanga tara na malunga liu tara. ");
INSERT INTO bnp_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","O bolea a kilo ge taku na plaoa o vuli turana a lita ge taku na namona oliv, o habi nau turana a sipsip. O guru tabua a lita na vain ge taku, ge a nihabi na vain. ");
INSERT INTO bnp_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","O tabari tabua nau na malunga liu a sipsip tara. O bole a bret ge manga a hini muga turana a namona oliv, a vain, mu habi nau ge manga a nihabi na hatelanga, ge a nihabi gutu-vuro na kanono ne BAKOVI DAGI. Lakea iau bara burongi a mangina bara vivi. ");
INSERT INTO bnp_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ra nihabi ni gutu-vuro ge rata vakaroroa e huriki a hamone mua na matana Kape na Vaponga, iau e BAKOVI DAGI ga tagui mua vonga, ga ta turane mua. ");
INSERT INTO bnp_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","A nipara dagi nau ge bele na kape, ge ratea a tabeke iea, a tabeke nau kunana. Nahea tara viri ge valai vona. ");
INSERT INTO bnp_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Ga gamai a kape, a dede, ga maki nau kunana. Ga gamai tabu e Aron turane huriki e tuna, ri gi rata a leho nau manga a prister. ");
INSERT INTO bnp_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ga made turane huriki a Israel, ge iau a Vure ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ri gi lohoka kamumu nau, iau kunana a tuli tala ria o Egipto, a taparaki valai ria koea ga made turane ria. Iau kunana e BAKOVI DAGI a Vure ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“O bolea a kai a akas o haea a dede ne vona ni habi a havu mangisipa nau. ");
INSERT INTO bnp_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","A niolana dede ge 45 sentimita a nibolana tara ge 45 sentimita, a nipesina ge 90 sentimita. O kau ge va a tupi na nimodona dede i va. ");
INSERT INTO bnp_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","A hini polomeli, o kavitagu na gol kabakaba a tupi. A harena dede mu kavitagua na tabekena gol ge ola. ");
INSERT INTO bnp_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","O rata na gol a halui ge rua, o rua koea tara, na tabeke lake tara, ne vona ni rodo dili a binole. O kolotata ra halui nga polotano tabukoi na gol, o kolotata na harehare. ");
INSERT INTO bnp_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","O kau a tabekena kai a akas ge rua, ga binole na dede. O kavitagu na gol a binole nga. ");
INSERT INTO bnp_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","O bolea a dede o rua polovavo na kala dagi, i naviri mule a Tava na Ngava Dagi, tabukoi na murina nidodo polomeli na tava, na hini ga tagui ioe vona. ");
INSERT INTO bnp_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Na hatelanga lobo e Aron ge valai ge rata kamumu a maka lam, ge namia a havu mangisipa ge vakabele a pokona kanono manginoro. ");
INSERT INTO bnp_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Na malunga liu ge nami tabua a havu mangisipa, na tahuna i valai ge nami a maka lam. Ra nihabi iea, e huriki a hamone mua ri gi ratea vakaroro muri ma na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Na dede iea, naha ni tabari iau vona a havu mangisipa, a sipsip ni gutu-vuro, a vit, a vain i uka ma ni gamai. ");
INSERT INTO bnp_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Na parava ge taku kunana na pida lobo e Aron ge ratea a dede iea ge matapado na matagu. Ge bole ranga dara na sipsip ra mu habi ni puga vuroki a naro hale, mu ru na tupina dede. Ra dede iea ni gamaia, ne nau kunana. E huriki a hamomu ri gi rata maea muri ma.” ");
INSERT INTO bnp_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Muri e BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Na tahuna o bole a rane huriki a Israel, o here puru na puhu, o taki ria ri gi habi tavula nau ranga mahala. Ge uka, a gilanga dagi bara i bele i ratapile ria. ");
INSERT INTO bnp_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","E huriki ni here a rane ria ri gi habi a moni silva ge polotara na gram, ge a nihabi ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","O here puru a rane huriki ri tahoka a pida i ravulu rua, i rike. Ria lobo ri gi habi a moni nau. ");
INSERT INTO bnp_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","A bakovi na mahala, nahea ge habi kupo. A matasia, nahea ge habi popote. A bakovi i taku ge habi kunana nau a moni silva maea, ne vona ni kavitagu a naro hale vona, i uka ma ge mate. ");
INSERT INTO bnp_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ra moni nga ne vona ni matakari a kape nau. Ga matai a moni, ga luhoi e huriki a Israel, ga kavitagu a naro hale ne ria.” ");
INSERT INTO bnp_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Mu bole ranga bras mu ratea tara tavila, mu ratea tara dede ne vona ni ru langa a tavila vona. Mu kiru na tavila a naru, mu ru na koropalana a dede, a Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","E Aron turane huriki e tuna ri gi vahilolo a limane ria, a vahane ria vona. ");
INSERT INTO bnp_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","E huriki ri ngaru ni dili na roho nau o ri gi valai tabukoi na dede nau, ri gi habi a nihabi ni gutu na kanono ne BAKOVI DAGI, ri gi vahilolo taro a limane ria, a vahane ria, i uka ma ri gi mate. ");
INSERT INTO bnp_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Muholi hateka, ri gi vahilolo a limane ria a vahane ria, i uka ma ri gi mate. E huriki a hamone Aron kunana, bara ri ramaia a vinara iea.” ");
INSERT INTO bnp_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“O bole kadolu a maka mangisipa kamumu. O bolea a mir, a nimavana a kilo ge polotara. O bole ranga havu ni gale a sinamon, a nimavana a kilo ge tolu. ");
INSERT INTO bnp_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","O bole ranga havu ni rata na kulina kai a kasia, a nimavana a kilo ge polotara. O bole a namona oliv a lita ge taku; o guru dili na maki nga. ");
INSERT INTO bnp_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","O vuli ge bele manga a nibiri. Ra nibiri iea ni taba, ne vona ni gamai a maki nau. ");
INSERT INTO bnp_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","“O bolea a nibiri iea, o gamaia a Kape na Vaponga, a Tava na Ngava Dagi, ");
INSERT INTO bnp_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","a dede turana a maka mahalana, a butuna lam turana a maka mahalana, a dede na havu mangisipa, ");
INSERT INTO bnp_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","a dede ne vona a nihabi gutu-vuro turana a maka mahalana, a tavila na hilova turana a dede vona. ");
INSERT INTO bnp_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","O gamai a maki nga, ga maki nau kunana. A bakovi o a maki tara ge padoi a maki nga, bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Muri o gamai e Aron turane huriki e tuna bakovi, ge ria a prister, ri gi rata a leho nau. ");
INSERT INTO bnp_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","O taki e huriki a Israel, o ta maea, ‘Mua, turane huriki a hamone mua, mu bolea a nibiri iea mu gamai a maki nau. ");
INSERT INTO bnp_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Naha ni guru langa na bakovi tavula. Naha ni rata a nibiri ne mua ge maea. Ra nibiri iea ni taba, naha ni padoia. ");
INSERT INTO bnp_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","A bakovi i ratea tara nibiri maea, o ge guru langa tavulea na bakovi tavula tara, ra bakovi iea i uka ma ge made turane huriki a viri vona.’” ");
INSERT INTO bnp_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","E BAKOVI DAGI i takia e Moses, “O bole a stakti, a onika, a bulukana a keke ni gale a golbanum, a bulukana a kai a balsam, o vuli ge vakabele a havu na havu mangisipa. A nimavana maki nga ge palupulupu. ");
INSERT INTO bnp_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","O bole a maki nga, o vuli kamumu, o rata a havu na havu mangisipa. O bole a mami popote o ru puru na havu ge ratea ge matapado ge malamala. ");
INSERT INTO bnp_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","O tutu kamumu a maki nga, ge bele a havu, muri o bole dili na Kape na Vaponga ranga, o ru tabukoi na Tava na Ngava Dagi na hini ga tagui mua vona. Ra havu iea i malamala hateka. ");
INSERT INTO bnp_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Nahea tara bakovi ge ratea tara havu maea ge habia mua. Ra havu iea ni gi ru herehere ge nau kunana, e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","E rei a viri i ratea tara havu ge maea, ra bakovi iea i uka ma i kara ge made turane huriki a viri vona.” ");
INSERT INTO bnp_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“O longo, a vulakia pali e Besalel e tune Uri bakovi, e tubune Hur na kabu ne Iuda. ");
INSERT INTO bnp_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","A habia vona a Hanuna Vure, turana a nitora, a lohokanga, a niluhoi ni ratana a maki legelege. ");
INSERT INTO bnp_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ge rata a maka maki kamumu na gol, na silva, na bras. ");
INSERT INTO bnp_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ge rata a maki na kedo parahidi, na maka kai, na maki legelege ranga, ge vakabagetu a kape nau. ");
INSERT INTO bnp_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","A vulaki tabua e Oholiap, e tune Ahisimak na kabu ne Dan, ge leho turana e Besalel. A habi tabu a lohokanga ne huriki ranga, ri gi rata a maki a ngaru ri gi rata. ");
INSERT INTO bnp_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ri gi rata a Kape na Vaponga, a Tava na Ngava Dagi turana a murina nidodo, a maka mahalana kape. ");
INSERT INTO bnp_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Ri gi rata a dede turana a maka mahalana, a butuna lam ni rata na gol kamumu turana a maka mahalana dede na havu mangisipa. ");
INSERT INTO bnp_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Ri gi haea a dede na nihabi gutu-vuro turana mahalana, a tavila ni vahilolo a lima a vaha turana a dedena. ");
INSERT INTO bnp_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Ri gi rahi a maka bagetua kamumu ne Aron, ne huriki e tuna, ri gi rodo ri gi rata a leho na prister. ");
INSERT INTO bnp_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ri gi rata a nibiri ne vona ni gamai a maki nau, a havu mangisipa ni gi rungani na Tabeke Nitaba. Ri gi rata a maki nga, ge manga kunana a ngava a taki ioe vona na lolo.” ");
INSERT INTO bnp_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“O vano o taki e huriki a Israel, ‘A parava polorua, ia a Parava Nimalo nau. Na vik vakaroro mu malo vona a parava iea, ra a habia mua mu gu ramaia ngane, e huriki a hamone mua ri gi ramai vakaroroa, ge ia a kilakila ne mua muri ma. A rata mavonga, a vuhuna bara mu lohoka vona iau e BAKOVI DAGI, a vulaki mua ge mua a viri nau. ");
INSERT INTO bnp_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ra Parava Nimalo a parava nau, a malo vona. A viri i longotaro a vinara nau, i leho vona a parava iea, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Na maka vik lobo mu tahoka a parava i polotara mu leho vona, pali a parava polorua, a parava nau, a Parava Nimalo. E rei a viri i rata a leho vona a parava iea, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","E huriki a Israel, ri gi malo vona a parava iea, e huriki a hamone ria ri gi ramai vakaroroa a ngava dagi iea na maka pida ge valai. ");
INSERT INTO bnp_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ra parava iea a kilakila na ngava dagi a ratea turane huriki a Israel, ri gi luhoi vakaroroa. Na parava i polotara a rata rike a hunu a malala, pali na poloruana parava a taparaki a maka leho lobo, a malo.” ");
INSERT INTO bnp_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Na tahuna e Bakovi Dagi i ta lobo turane Moses na lolo e Sinai, i habi ne Moses a tabekena kedo i rua na Ngava Dagi, ra ia a Vure i here na limana. ");
INSERT INTO bnp_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","E Moses i made tabaka hateka na lolo, i uka ma i malaviriri ni puru valai. Lakea e huriki ri pesi halui e Aron ri takia, “I uka ma si lohoka vona a ra maki i bele ne Moses meli na lolo. I tuli tala hita o Egipto, i taparaki valai hita koea. Pali ngane si gi rata ranga vure, ri gi muga ri gi vakasiri a dala ne hita.” ");
INSERT INTO bnp_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Lakea e Aron i taki ria, “Mu paru tala a maka pato ni rata na gol na talingane girihine mua, e tune mua, mu bole valai nau.” ");
INSERT INTO bnp_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ri longo maia a nitane Aron, ri paru tala na talingane huriki a ngatavine a maka pato ni rata na gol, ri bole valai vona. ");
INSERT INTO bnp_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","E Aron i bole a maka gol, i gutu na kanono ri naru. I guru dili na lovo ni keli i manga a bulmakau, i ratea a hanuna bulmakau. Muri e huriki a Israel ri ta maea, “Ra maki iea, a vure ne hita. I tuli tala hita o Egipto, i taparaki valai hita koea.” ");
INSERT INTO bnp_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Na tahuna e Aron i masia, i ratea a dede tabukoi vona. Lakea i ta maea, “Kuduvi si gi ratea tara habu, si gi kavurikea e BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Na hatelanga pokopoko na parava muri, e huriki ri bole valai a maka sipsip a bulmakau, ge a nihabi gutu-vuro. Ri bole valai tabu a nihabi na nivalemu. Muri ri kani, ri ninu, ri rehi turane huriki a ngatavine. ");
INSERT INTO bnp_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Lakea e BAKOVI DAGI i takia e Moses, “O puru malaviriri. E huriki o tuli tala o Egipto ri rata hateka a naro hale. ");
INSERT INTO bnp_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ri longokaburungia a dala a takia ne ria ri gi ramaia. Ri ratea na gol a tuna bulmakau, ri kavurikea, ri habi a nihabi vona. Lakea ri ta maea, ‘Ra maki iea a vure ne hita, i tuli tala hita o Egipto, i taparaki valai hita koea.’” ");
INSERT INTO bnp_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Lakea e BAKOVI DAGI i takia e Moses, “Iau a lohoka vona e huriki nga, ri tagege hateka. ");
INSERT INTO bnp_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Iau, i madihi a hategu ne ria. Ngane ga ratapile ria, naha ni hatekakari iau. Muri ga rata ioe, turane huriki a hamomu bara mu kuloi ria, mu bele kupo.” ");
INSERT INTO bnp_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pali e Moses i vasileki tora ne BAKOVI DAGI, a Vure vona, i ta maea, “BAKOVI DAGI, nahea ge madihi hateka a hatemu, go ratapile ria. Ioe kunana o bole tala ria o Egipto na nitora dagi vomu. ");
INSERT INTO bnp_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ioe bara o ratapile ria, e huriki a Egipto bara ri ta maea, ‘A Vure i tami e huriki a viri vona, i bole tala o Egipto, i tuli lakea ria na lolo, i rabalaki ria.’ Pali naha ni ratea ra naro iea. I kamumu hateka o taparakia a rongova o puloa a niluhoi vomu, naha ni rabalaki e huriki a viri vomu. ");
INSERT INTO bnp_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","O luhoi mule a vora vomu e Abraham, e Isak, e Iakop. O kaba, o taki tou o ta maea, ‘A ta muholi hateka, e huriki a hamone matou ge kupo manga a hada na hunu. Ra malala a ta muholi vona, ga habia ne matou, bara habia ne huriki a hamone matou.’” ");
INSERT INTO bnp_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","E Moses i vasileki maea, lakea e BAKOVI DAGI i puloa a niluhoi vona, i uka ma i ratapile e huriki a viri vona. ");
INSERT INTO bnp_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Muri e Moses i ngalakapulo, i bole a tabekena kedo i rua e Bakovi Dagi i here a Ngava Dagi vona, i puru. ");
INSERT INTO bnp_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","A Vure kunana i rata ra kedo nga, i here vona a vinara. ");
INSERT INTO bnp_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Na tahuna e Iosua i longo e huriki ri kalolo, i takia e Moses, “O longo puru! A longo a nangine huriki ri vaubi na mada.” ");
INSERT INTO bnp_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pali e Moses i koli, i ta maea, “I uka ma a nangine huriki ri mulangi na vabinga, i uka ma a nangine huriki ri pinadi na vabinga. a nangine huriki ri kalolo a longoa.” ");
INSERT INTO bnp_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","E Moses i valai tabukoi na mada i masia a tuna bulmakau ni rata na gol. I matai e huriki ri raulo haluia a bulmakau, i madihi a hatena. Lakea i voro puru ra tabekena kedo nga ru momo kesikesi na dahana lolo. ");
INSERT INTO bnp_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Lakea e Moses i bolea ra bulmakau i ratea e huriki, i rungania na kanono, i ubimomoa i havula kesi. Muri i bole a habulona, i voro puru na naru, i vakuku e huriki a Israel ri nua a naru. ");
INSERT INTO bnp_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Lakea e Moses i nanea e Aron, “Re huriki nga a ra ri ratea vomu, o mata taro ria ri ratea ra naro hale dagi iea?” ");
INSERT INTO bnp_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","E Aron i kolia e Moses, i ta maea, “Bakovi dagi, naha ni tahate iau. O lohoka vona a narone ria. Ri ngaru hateka ni rata a naro hale. ");
INSERT INTO bnp_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ri taki iau, ri ta maea, ‘I uka ma mi lohoka vona a ra maki i bele vona e Moses, ra bakovi i bole tala hita o Egipto. O rata puru ne mia ranga vure ge muga, ge vakasiri a dala ne mia.’ ");
INSERT INTO bnp_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Muri a taki ria, ‘E rei a viri i tahoka a gol ge kali tala.’ Lakea ri habi nau a gol, a voro rike na kanono, i bele a tuna bulmakau.” ");
INSERT INTO bnp_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","E Moses i lohoka vona e huriki ri rata a naro hale, a vuhuna e Aron i matataro ria. I luhoi ma ge matai ria e huriki a pile bara ri biu, ri nongo vaki ria. ");
INSERT INTO bnp_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Muri i vano i pesi na poridala na mada i ta maea, “E rei i ngaru ni ramai e Bakovi Dagi, ge valai ge pesi turagu.” Lakea e huriki a bakovi na kabu ne Levi ri valai ri pesi halui ia. ");
INSERT INTO bnp_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Muri e Moses i taki ria, “E BAKOVI DAGI, a Vure ne hita a Israel i taki mu gu bole a maka bainat, mu lakea na tabeke lobo na mada mu rabalaki e huriki a turane mua.” ");
INSERT INTO bnp_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lakea e huriki a kabu ne Levi ri rata manga a hini e Moses i taki. Na parava iea kunana ri rabalaki e huriki ri ala 3,000. ");
INSERT INTO bnp_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Muri e Moses i taki e huriki a hamone Levi i ta maea, “Ngane mu rabalaki pali e huriki, i uka ma mu togo e huriki e turane mua, e tune mua. Na naro iea kunana, mu bele manga e huriki a prister ne BAKOVI DAGI. Mona e BAKOVI DAGI i rata kamumu mua.” ");
INSERT INTO bnp_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Na parava muri e Moses i taki e huriki, “Ra naro hale mu ratea i hale hateka. Pali ngane ga sike tabu na lolo, ga takia e BAKOVI DAGI, ge puga vuroki a naro hale ne mua.” ");
INSERT INTO bnp_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Muri e Moses i sike na lolo i takia e BAKOVI DAGI, “A dodo hateka re huriki nga, ri rata a naro hale dagi. Ri ratea na gol a vure. ");
INSERT INTO bnp_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Pali ngane a nana ioe, ta go puga vuroki a naro hale ne ria. Pali ge uka, a ngaru ioe go ravunu vurokia a ragu na puhu vomu.” ");
INSERT INTO bnp_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Pali e BAKOVI DAGI i takia e Moses, “I uka ma ge mavonga. Iau ga ravunu vuroki kunana a rane huriki ri rata a naro hale. ");
INSERT INTO bnp_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","O vano ngane, o tuli e huriki ri gi lakea vona a tanga, a taki ioe vona ri gi lakea vona. O longo kamumu. A agelo nau ge muga, ge vakasiri a dala ne mua. Pali na tahuna ga hamule valai, ga ratapile e huriki ri rata a naro hale.” ");
INSERT INTO bnp_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Muri e BAKOVI DAGI i rudua a gilanga dagi, i ratapile e huriki, a vuhuna ri simaia e Aron i ratea na gol a hanuna tuna bulmakau. ");
INSERT INTO bnp_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","E BAKOVI DAGI i takia e Moses, “Ngane, o vano turane huriki o bole tala o Egipto, mu pea a tanga iea, mu lakea na malala a ta muholi vona ga habia ne mua. Hosi a ta muholi vona ne Abraham, ne Isak, ne Iakop, a ta maea, ‘Ga habia ne huriki a hamone matou a malala iea.’ ");
INSERT INTO bnp_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ga rudua a agelo nau, ge muga mua, ge vakasiri a dala ne mua. Iau bara lili tala e huriki a Kenan, a Amor, a Hiti, a Peres, a Hivi, a Iebus ra ri made vona a malala iea. ");
INSERT INTO bnp_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mu vano mu made vona a malala kamumu i vona a maki ni kani. Pali iau i uka ma ga turane mua, a vuhuna mu tagege hateka. Ma ga turane mua, ga ratapile mua na dala.” ");
INSERT INTO bnp_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Na tahuna ri longoa a nitane Bakovi Dagi, ri mangenge, i uka ma ri bagetu na nirodo kamumu ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","E BAKOVI DAGI i takia e Moses ge vakalongo e huriki a Israel vona a nitana, “Mu tagege hateka. Iau bara vano turane mua o ga made popote turane mua, bara ratapile mua. Ngane mu longo, mu kali tala a maka bagetua ne mua ni rata na gol, ga luhoi kamumu a ra naro ga rata virihi mua vona.” ");
INSERT INTO bnp_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Na tahuna ri pe a lolo e Sinai, i uka ma ri bagetu na nirodo kamumu. ");
INSERT INTO bnp_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Na tahuna e huriki a Israel ri lakea na tabeke tara, ri vakapesi a kape ne ria. Pali e Moses bara i vakapesi basi popote na mada a kape ni tagui e BAKOVI DAGI. E rei a viri i ngaru ni lohoka na ningaru vona, bara i lakea vona a kape iea. ");
INSERT INTO bnp_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Na tahuna e Moses i dili vona a kape iea, e huriki ri made na kape ne ria bara ri pesi ri matanonoa e Moses i laho dili. ");
INSERT INTO bnp_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Na tahuna i dili pali, a bubu bara i puru valai i pesi tabukoi na matana kape. E huriki ri longoa e BAKOVI DAGI i made pololilo na bubu, i ta turane Moses. ");
INSERT INTO bnp_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bara ri pesi na matana kape ne ria, ri masia a bubu i pesi tabukoi na matana kape na Vure, lakea ri lolu ri kavurikea a Vure. ");
INSERT INTO bnp_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","E BAKOVI DAGI i ta turane Moses i manga a bakovi i ta turana a bakovi tara. Na tahuna ru vata lobo, e Moses i hamule na mada. Pali a koma tamuhane, e Iosua, a bolekori ne Moses, e tune Nun, i made mule na kape. ");
INSERT INTO bnp_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","E Moses i takia e BAKOVI DAGI, “Muga o taki iau ga matakari e huriki ri gi lakea na malala ne ria. Pali i uka ma o taki iau vona e rei a bakovi ge turagu ge tuhori iau. Muga o ta maea, ‘A lohoka kamumu vomu, a ngaru ioe.’ ");
INSERT INTO bnp_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ioe o ngaru iau, o taki iau vona a niluhoi vomu, ga lohoka kamumu vomu, ga rata vakaroro a maki o ngaru. O luhoi kamumu, e huriki a bakovi a ngatavine o vulaki pali, ngane ria a viri vomu.” ");
INSERT INTO bnp_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","E Bakovi Dagi i koli, i ta maea, “Iau ga vano turamu, ga habi a nivalemu vomu o malo.” ");
INSERT INTO bnp_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Lakea e Moses i taki tabua e Bakovi Dagi, “Ioe o marikoi ni vano turane mia, naha ni matataro mia mi gi pea a tabeke iea. ");
INSERT INTO bnp_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ioe i uka ma o vano turane mia, mi gi lohoka navai vomu o ngaru mia? Ioe bara o vano turane mia, e huriki a kabu ranga bara ri lohoka vona, e huriki a Israel ria a viri vomu.” ");
INSERT INTO bnp_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Lakea e BAKOVI DAGI i takia e Moses, “Iau ga rata manga a hini o taki, a vuhuna a ngaru ioe, a lohoka kamumu vomu.” ");
INSERT INTO bnp_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Muri e Moses i takia, “A ngaru ioe go vakasiri iau vona a bagetua vomu.” ");
INSERT INTO bnp_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","E BAKOVI DAGI i koli, i ta maea, “Iau ga vakasiria vomu a naro kamumu nau, ga vakalongoa vomu a ragu e BAKOVI DAGI. O longo kamumu! Na tahuna a ngaru ni rata kamumu a viri, bara rata kamumua. Na tahuna a ngaru ni dodo a viri, bara dodoa. ");
INSERT INTO bnp_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pali i uka ma o kara ni masia a matagu. A viri i matai a matagu bara i mate. ");
INSERT INTO bnp_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“Mata lakea, a kedo dagi i tabuli tabukoi nau, o pesi langa vona. ");
INSERT INTO bnp_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Na tahuna a bagetua nau ge valai tabukoi vomu, ga ru dili ioe na dupina kedo ga kavitagu ioe na limagu, ge harena na tahuna a polotaro ioe. ");
INSERT INTO bnp_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Muri ga bole talea a limagu, o masia a bitogu, pali a matagu i uka ma go masia.” ");
INSERT INTO bnp_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","E BAKOVI DAGI i takia e Moses, “O kau a tabekena kedo ge rua, ge manga ra kedo nga o bimomo kesikesi rira. Ga here tabu a ngava ge manga a ngava a here na kedo muga. ");
INSERT INTO bnp_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kuduvi na hatelanga o bole a tabekena nga, o sike na mapana lolo e Sinai, o tagui iau vonga. ");
INSERT INTO bnp_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nahea tara viri ge valai turamu. A koi vona tara viri ge valai ge made vona a lolo iea. E huriki lobo ri gi made na taruna. A maka sipsip, a bulmakau nahea ri gi valai ri gi kani tabukoi a varili na lolo.” ");
INSERT INTO bnp_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Lakea e Moses i kau a tabekena kedo i rua i manga a kedo muga, i bole sike na lolo, i ramai a ngava e BAKOVI DAGI i vakuku ia vona. ");
INSERT INTO bnp_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","E BAKOVI DAGI i puru valai turana a bubu, i pesi turane Moses na lolo, i vakalongo mulea a rana, e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","I polo na ngalane Moses, i vakalongo maea, “Iau e BAKOVI DAGI, iau e BAKOVI DAGI. Iau a Vure na nidodo na ni rata kamumu e huriki. Iau i uka ma a tahate malaviriri e huriki. A ngaru hateka e huriki a bakovi a ngatavine, a ramai lobo a ngava nau. ");
INSERT INTO bnp_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","A ngaru hateka e huriki ri ala ravulu rangale (1,000), i manga a ngava a ta muholi vona pali. A puga vuroki a naro hale ne huriki ri longotaro a nitagu, ri putu puru a vinara, ri rata a naro hale. Pali e huriki ri rata a naro hale, ri tahoka a ngava, ga vakamadihi ria turana e huriki a hamone ria, re huriki e tubune ria, e tamarane ria.” ");
INSERT INTO bnp_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Muri na Vure i ta lobo, e Moses i malaviriri kunana i lolu puru na malala, i kavurikea. ");
INSERT INTO bnp_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Lakea e Moses i takia, “Bakovi Dagi, ioe bara o ngaru muholi iau, a ngaru ioe go vano turane mia. I muholi ngi, re huriki nga ri longotaro hateka a ngava, a ngaru go puga vuroki a naro hale ne ria, o bole mia, ge mia e huriki a viri vomu.” ");
INSERT INTO bnp_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","E BAKOVI DAGI i takia e Moses, “Ngane a ta muholi, ga vakasiri na matane mua lobo a maka nivakasiri dagi, i uka ma a vakasiri ma ne huriki lobo na malala. A maka kabu ranga bara ri matai a maki legelege a rata ni tuhori mua, bara ri luhoi lege, ri mangenge. ");
INSERT INTO bnp_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mu ramai a vinara nau a taki ioe vona mu gu ramai. Iau ga muga ga lili tala e huriki a Amor, a Kenan, a Hiti, a Peres, a Hivi, a Iebus na malala ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Mu matadoko, naha ni valongo mai a ngava dagi turane huriki na tanga mu gu lakea vona, ma ri gi turari mua, mu gu longotaro a ngava nau, mu gu velu. ");
INSERT INTO bnp_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mu ratapile a maki na nivasileki ne ria. Mu ubikeve a maka dede a butu ni rata na kedo, mu ubivila a kai ni kau a hanuna vure ngatavine, e Asera. ");
INSERT INTO bnp_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Mu kavurike kunana iau, e BAKOVI DAGI ne mua. Naha ni kavurike a vure ranga, a vuhuna i uka ma ga matataroa tara vure ge kuloi iau. ");
INSERT INTO bnp_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Naha ni valongo mai na ngava turane huriki na tanga nga. Re huriki nga ri kavurike, ri habi a maka nihabi na maka vure ne ria. Mua bara mu valongo mai a ngava turane ria, bara ri taki mua mu vapopo turane ria, mu kani a kinani ri habi na maka vure ne ria. ");
INSERT INTO bnp_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Re huriki nga, bara ri taki e huriki a riau ne mua ri parangi a ngatavine ne ria. Mua bara mu rata mavonga, re huriki a ngatavine nga, bara ri turari e huriki e girihine ria, ri ha taro iau, ri kavurike a maka vure ne ria, manga a viri i rata a naro na molenga. ");
INSERT INTO bnp_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Naha ni rata a maka vure na aen mu gu kavurike ria. ");
INSERT INTO bnp_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Mu luhoi mulea a tahuna mu mariu tala o Egipto, mu ratea a Habu na Bret i Uka Is. Na keva e Abib na pida lobo, mu kani a bret i uka is na parava ge polorua, i manga a hini a taki. ");
INSERT INTO bnp_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“E huriki a tabua a bakovi, a maka tabua na bulmakau a sipsip ne mua, ge nau kunana. ");
INSERT INTO bnp_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mu ngaru ni kona mule a maka tuna tabua na donki, mu habia a tuna sipsip ge a makulina. Mua i uka ma mu konamulea, mu hori a lohona a donki. E huriki a tabua bakovi ne mua, ria ranga mu kona mule. ");
INSERT INTO bnp_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Na vik lobo mu tahoka a parava na leho i polotara, pali na poloruana parava naha ni rata a leho. A poloruana parava ge bele na tahuna na nivaro o na nimirio, naha ni leho vona a parava iea. ");
INSERT INTO bnp_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Mu luhoia a Habu na Nimirio, ra habu ni bole kadolu a maka kanena vit ri moro muga. Na keva ni pasi a maka kanena kai ri rara, mu luhoia a Habu na Nimalo na Kape. ");
INSERT INTO bnp_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ge balaka tolu na pida, e huriki a bakovi ne mua, ri gi kavurike e BAKOVI DAGI a Vure ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Iau ga lili tala e huriki ri made ngane vona a malala, ga hudotalea a harena malala ne mua. Balaka tolu na pida i taku, mu valai mu kavurike iau e BAKOVI DAGI a Vure ne mua. I mavonga e huriki a pile i uka ma ri gi bolea a malala ne mua. ");
INSERT INTO bnp_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Naha ni habi nau a bret i tahoka a is, na tahuna mu habi a sipsip a bulmakau nau. Nahea ge tabuli ranga nihabi, mu kani kaleva na Habu na Nipagepolo ge palala taho a hini. ");
INSERT INTO bnp_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Na pida lobo, na tahuna mu mirio a maki ri moro muga na hania, mu bole valai nau, iau e BAKOVI DAGI a Vure ne mua. “Naha ni guru puru na ulo a namona ruru na meme mu gu nono a tuna meme vona.” ");
INSERT INTO bnp_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","E BAKOVI DAGI i takia e Moses, “O here puru a ngava nga na puhu, a vuhuna a burena a maka ngava dagi a rata turamu, a rata turane huriki a Israel.” ");
INSERT INTO bnp_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Lakea e Moses i made turane BAKOVI DAGI na lolo na parava i ravulu va, a rodo i ravulu va, i uka ma i kani, i uka ma i ninu. I here a nita na ngava dagi na tabekena kedo i bole sike e Moses. A ngava nga ra vinara na Vure i ravulu. ");
INSERT INTO bnp_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Na tahuna e Moses i pe a lolo e Sinai i puru, i bole a tabekena kedo i rua ni here vona a Ngava Dagi. A matane Moses i parahidi, a vuhuna i ta turane Bakovi Dagi. Pali ia i uka ma i lohoka vona a matana i parahidi. ");
INSERT INTO bnp_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Na tahuna e Aron turane huriki a Israel ri masia a matane Moses i para hateka, ri mangenge, i uka ma ri valai tabukoi vona. ");
INSERT INTO bnp_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pali e Moses i gale e Aron turane huriki a matakari ne Israel, ri valai vona, i ta turane ria. ");
INSERT INTO bnp_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Muri e huriki a Israel ri valai tabukoi ne Moses, i vara ria na maka vinara e BAKOVI DAGI i habi vona na lolo e Sinai. ");
INSERT INTO bnp_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Na tahuna e Moses i vara lobo ria, i bolea a kala i kavitagua a matana. ");
INSERT INTO bnp_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pali na tahuna e Moses i dili na kape, bara i kali talea a kala, i ta turane BAKOVI DAGI. Na tahuna i pagitala, bara i vakalongo e huriki a Israel vona a ngava e BAKOVI DAGI i takia vona. ");
INSERT INTO bnp_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","E huriki a Israel ri masia a matane Moses i parahidi. Na tahuna i vakalongo ria lobo na vinara, i kavitagu a matana na kala, i harena na tahuna i hamule dili tabu na kape i ta turane Bakovi Dagi. ");
INSERT INTO bnp_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","E Moses i gale palupu e huriki a Israel i taki ria, “E BAKOVI DAGI i taki mua mu gu ramai a vinara nga: ");
INSERT INTO bnp_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Na vik lobo mu tahoka a parava i polotara ni leho. Pali a poloruana parava ia a Parava Nimalo, a tabea, naha ni rata a leho, a vuhuna a parava ne BAKOVI DAGI. A viri i leho vona a parava iea, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","A leho kiroko ni nami a kanono tara naha ni ratea.” ");
INSERT INTO bnp_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Muri e Moses i taki e huriki a Israel na ngava e BAKOVI DAGI i taki. ");
INSERT INTO bnp_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","“Iau bara vivi vona a nihabi na viri i ngaru ni habi a maki. Na tahuna mu ngaru ni habi a maki, mu habi a gol, a silva, a bras, ");
INSERT INTO bnp_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","a kala kamumu, a maka vuna sipsip i gomagoma, i kuakua, i vururu, a kala ni rata na vuna meme, ");
INSERT INTO bnp_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","a kulina sipsip a toga ni kalu vururu, a kulina lui, a kai a akas, ");
INSERT INTO bnp_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","a namona oliv ne vona a lam, a havu mangisipa ni vuli turana a namona oliv ne vona ni gamai, ne vona a havu mangisipa. ");
INSERT INTO bnp_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","A kedo oniks, a kedo parahidi ranga, mu habi ni gi topi na harena bagetua, a kala kiroko na ngalana prister. ");
INSERT INTO bnp_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“E huriki a mari ni ratana maki, ri gi valai, ri gi rata a maki e BAKOVI DAGI i vakuku ria vona; ");
INSERT INTO bnp_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","a kape, a maki ni kapi a kape, a maka kinau, a maka mito na nure, a maka karo ni gi kolo tavalavala na gaga, a maka butu, a maka vuhu-butu ge pesi langa vona a butu; ");
INSERT INTO bnp_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","a tava turana a binolena, a murina nidodo, a kala dagi ne vona ni kapikari a tava; ");
INSERT INTO bnp_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","a dede turana a mahalana, a binolena dede, a bret ni gamai; ");
INSERT INTO bnp_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","a butu na lam turana a mahalana, a namona oliv ne vona a lam; ");
INSERT INTO bnp_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","a dede na havu mangisipa turana a binolena, a nibiri nigamai, a havu mangisipa, a kala dagi ni gi vakatavore na matana kape; ");
INSERT INTO bnp_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","a dede na nihabi gutu-vuro turana a bras ni gi kolo na vahana, a binolena, a mahalana, a tavila turana a dede vona; ");
INSERT INTO bnp_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","a kala dagi, a maka butu turana a maka vuhu-butu ne vona ni tura halui a mailo na kape; ");
INSERT INTO bnp_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","a maka niroka na butuna kape, a maka niroka na mitona nure turana a maka motane ria; ");
INSERT INTO bnp_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","a maka bagetua kamumu ni rodo ni leho na kape. Ra bagetua ni taba ne Aron, a nirodo ne huriki e tuna bakovi, ri gi rodo na tahuna ri rata a leho na prister.” ");
INSERT INTO bnp_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Muri e huriki a Israel ri pea e Moses ri vano. ");
INSERT INTO bnp_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","A nitane Moses i vakarike a hatene huriki, ri ngaru ni habi a maki. E huriki a mari ni leho ri valai ne Moses ri tuhoria. Ri bole valai a maki ne vona a leho na Kape na Vaponga, ne vona ni kavurike a Vure, ne vona ni rata a bagetua ni taba na prister. ");
INSERT INTO bnp_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ri bole valai a maki legelege, a pato, a bio, a bagetua ranga ni rata na gol, ge a nihabi nitabari ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","E huriki ri bole valai a kala kamumu, a maka vuna sipsip a meme i gomagoma, i kuakua, i vururu, a kulina sipsip a toga ni kalu vururu, a kulina lui. ");
INSERT INTO bnp_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","E huriki ri tahoka a silva a bras, ri bole valai ri habi ne Bakovi Dagi. E huriki ri tahoka a kai a akas, ri bole valai ne vona ni hae a kape. ");
INSERT INTO bnp_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","E huriki a mari ngatavine ri lohoka ni rata a hotu, ri bole a maka vuna sipsip i gomagoma, i kuakua, i vururu, ri rata a hotu. Ri rata a hotu keakea ne vona ni ratana kala kamumu. ");
INSERT INTO bnp_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","E huriki a ngatavine ri lohoka kamumu ni ratana maki na vuna meme, ri rata. ");
INSERT INTO bnp_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","E huriki a matakari ri bole valai a maka kedo parahidi ne vona ni rahi dili na harena kala kiroko na ngalana prister dagi. ");
INSERT INTO bnp_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ri bole valai a maka maki mangisipa, a namona oliv, ne vona a lam, a nibiri ne vona ni gamai, a havu mangisipa. ");
INSERT INTO bnp_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","E huriki a bakovi a ngatavine o Israel ri ngaru ni habi tavula a maki ne vona a leho ne BAKOVI DAGI, ri ramaia a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Muri e Moses i taki e huriki a Israel, “Mu masia, e BAKOVI DAGI i vulakia pali e Besalel, e tune Uri bakovi, e tubune Hur na kabu ne Iuda. ");
INSERT INTO bnp_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","A Hanuna Vure i habia a lohokanga kamumu vona ni ratana a maki na limana. ");
INSERT INTO bnp_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","I lohoka pali ni ratana maki na gol, a silva, a bras, ");
INSERT INTO bnp_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ni ratana maka kedo parahidi ge a bagetua, ni kau a hanuna maki, ni rata a maki ranga na lima. ");
INSERT INTO bnp_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","E Bakovi Dagi i habi a lohokanga vona turane Oholiap, e tune Ahisimak bakovi na kabu ne Dan, ru gu tovo e huriki ni ratana maki na limane ria. ");
INSERT INTO bnp_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","I habi a lohokanga kamumu na bakovi nga, ru gu rata a maka leho ni ubi kamumu a kedo parahidi, ni kau a hanuna maki na kai, ni rahi a maka kala kamumu. Ru lohoka ni ratana maka bagetua na hotu ni rata na maka vuna sipsip i gomagoma, i kuakua, i vururu. Ra bakovi nga, ru mari hateka ni ratana maki na limane rua. ");
INSERT INTO bnp_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Nimariu “E BAKOVI DAGI i habi a loho­kanga kamumu ne Besalel e Oholiap turana a mari ranga, ri gi haea a kape. A leho ne ria ri gi ramai kunanea a nitane BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Muri e Moses i gale e Besalel e Oholiap, turana e huriki a mari e BAKOVI DAGI i habi a lohokanga ne ria, ri ngaru hateka ni ratana leho ri valai. ");
INSERT INTO bnp_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Lakea e Moses i habi ne huriki a mari a maka nihabi na kape ri ru kadolu. Pali na hatelanga takutaku e huriki a Israel ri tababana ni habina maki ri ngaru ri gi habi. ");
INSERT INTO bnp_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","E huriki a mari, ri matai a maki i kupo hateka, ");
INSERT INTO bnp_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","lakea ri takia e Moses, “E huriki ri habi i kupo hateka a maka maki e BAKOVI DAGI i ngaru.” ");
INSERT INTO bnp_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Lakea e Moses i talo rike a ngava viliha na mada, i taki e huriki, “Naha ni habi tabu ranga maki ne vona a kape.” Ri longoa a nitana, i uka ma ri habi tabu ranga maki, ");
INSERT INTO bnp_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","a vuhuna a maka maki ri habi pali i kupo hateka, bara i tabuli tavula ranga. ");
INSERT INTO bnp_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","E huriki a mari ri haea a mailo na Vure, ri bole a maka kala i ravulu ri vakabagetu na hotu gomagoma, na hotu kuakua, na hotu vururu ni rata na vuna sipsip, ri rahi na kala nga a hanuna agelo. ");
INSERT INTO bnp_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","A niolana a kala i taku i ravulu a polona i rua a mita, a nibolana i rua a mita. A maka kala lobo ri palupulupu. ");
INSERT INTO bnp_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ri rahi palupu a maka kala i lima, ri hudo tala i manga a kala i taku. A kala i lima tabu ranga ni rahi palupu. ");
INSERT INTO bnp_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ri rata a maka halui na kala gomagoma ni varomu na harena kala dagi nga i rua. ");
INSERT INTO bnp_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Na kala muga ri kolo dili na harena a halui i ravulu lima. Na harena a kala tara ri kolo dili tabu a halui i ravulu lima. ");
INSERT INTO bnp_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ri rata na gol a kinau i ravulu lima, ri varaki palupu a tabekena kala dagi nga i rua, i bele manga a kala i taku. ");
INSERT INTO bnp_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ri ratea a kala dagi ne vona ni kavitagu a mailo na Vure. Ra kala dagi iea ni rata na kala i ravulu a polona i taku, ni rata na vuna meme. ");
INSERT INTO bnp_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","A niolana a kala i taku i ravulu a polona i tolu a mita, a nibolana i rua a mita. A maka kala nga ri palupulupu. ");
INSERT INTO bnp_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","A kala i lima ni rahi palupu, a kala i polotara tabu ranga ni rata mavonga. ");
INSERT INTO bnp_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ri kolo na harena kala tara a halui i ravulu lima, na kala tara i ravulu lima. ");
INSERT INTO bnp_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ri rata na bras a kinau i ravulu lima ne vona ni varaki palupu a kala nga i rua, ge manga a kala i taku. ");
INSERT INTO bnp_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Muri ri ratea tara kadis na kulina sipsip a toga, ni kalu vururu, ne vona ni kavitagu tabu a mailo. Ri rata tabua a toluna kadis na kulina lui, ri ru langa tabua. ");
INSERT INTO bnp_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ri rata na kai a akas a maka mito ne vona a mailo. ");
INSERT INTO bnp_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","A niolana a mito i va a mita, a nibolana mito i ravulu polotara a polona i polotara (66) a sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ri rata a maka mito ge ola popote, ne vona ni vonu dili na vuhu-butu ge vakatora a nure. A maka mito ri palupulupu. ");
INSERT INTO bnp_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ri vakapesi na tabeke mule puru a mito i ravulu rua, ");
INSERT INTO bnp_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","turana a maka vuhu-butu i ravulu va ni rata na silva, ge pesi langa vona a maka mito. A vuhu-butu i rua ru tabuli polotano na mito i taku. ");
INSERT INTO bnp_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","A mito i ravulu rua tabu ranga ri vakapesi na tabeke mule sike. ");
INSERT INTO bnp_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ri rata na silva a vuhu-butu i ravulu va ge pesi langa vona a mito. ");
INSERT INTO bnp_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ri vakapesi na bitona mailo a mito i polotara, na tabeke na nirolona haro, ");
INSERT INTO bnp_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","turana a mito i rua na nimodo na bitona mailo. ");
INSERT INTO bnp_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ra mito na nimodo i tahoka a mito ni lapi turana. A nimodo i rua tabu ni rata mavonga. ");
INSERT INTO bnp_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Na bitona mailo i tahoka a mito i polotolu, a vuhu-butu ni rata na silva i ravulu a polona i polotara (16), ne vona ni vakatora a mito na nure. A vuhu-butu i rua, ru tabuli polotano na mito i taku. ");
INSERT INTO bnp_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ri kau na kai a akas a karo ri ru tavalavala, ge vakatora a gagana nure. A karo i lima ni kolotata na tabeke tano, ");
INSERT INTO bnp_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","i lima na tabeke meli, i lima na bitona mailo na nirolona haro. ");
INSERT INTO bnp_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ri ratea a karo tavalavala na kurukuruna nure, i tubu na tabeke koea, i harena na tabeke tara. ");
INSERT INTO bnp_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ri naviri na gol a maka mito, ri kolo dili na karo a maka halui ni rata na gol, ri gi tangotata a maka karo tavalavala ni lapi na gagana. Ra maka karo nga, ngi ranga ni kavitagu na gol. ");
INSERT INTO bnp_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ri rahia a kala dagi ri vakatavorea pololilo na kape. Muri ri vakabagetua na hotu ni rata na vuna sipsip gomagoma, na vuna sipsip kuakua, na vuna sipsip vururu. Ri rahi dili na kala dagi iea a hanuna agelo. ");
INSERT INTO bnp_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ri rata na kai a akas a butu i va, ne vona ni vakatavorea ra kala dagi iea. Ri kavitagu na gol a maka butu nga, ri kolo dili ne ria a maka kinau. Ri rata na silva a vuhu-butu i va, ge pesi vona a butu. ");
INSERT INTO bnp_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Na matana mailo na Vure ri vakatavorea a kala dagi ni vai na vuna sipsip gomagoma, na vuna sipsip kuakua, na vuna sipsip vururu, ni rahi dili vona a bagetua legelege. ");
INSERT INTO bnp_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ri rata a butu i lima, ri kolo dili ne ria a maka kinau, ne vona ni vakatavore a kala. Muri ri kavitagu na gol a mapana butu, a karona kape. Ri rata na bras a vuhu-butu i lima i pesi langa vona a maka butu. ");
INSERT INTO bnp_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","E Besalel i ratea na kai a akas a Tava na Ngava Dagi. A niolana i 110 sentimita, a nibolana i 66 sentimita, a nipesina i 66 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","I naviri na gol kabakaba a hini pololilo a hini polovavo, i naviri na gol olaola a harena. ");
INSERT INTO bnp_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","I rata na gol a halui i va, i kolo dili na vahana i va, i rua na tabeke koea, i rua na tabeke tara. ");
INSERT INTO bnp_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Muri i kau na kai a akas a binole i rua, i naviri na gol. ");
INSERT INTO bnp_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","I rodo dili na halui ra binole nga, ne vona ni kaloho a tava. ");
INSERT INTO bnp_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A tabeke polomeli na tava, a murina nidodo, ni rata na gol kabakaba. A niolana i 110 sentimita, a nibolana i 66 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","I bolea a tabekena gol ni ubi na ama ni rata a agelo i rua, ru pasike na hirina murina nidodo. ");
INSERT INTO bnp_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","I tara i pasike na kanena, i tara i pasike na maurina. Ra agelo nga turana a murina nidodo ni rata na tabekena gol i taku. ");
INSERT INTO bnp_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ra agelo nga, ru vangalai, ru vulala tala a karapane rua ru kavitagua a matana tava. ");
INSERT INTO bnp_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ri ratea a dede na kai a akas. A niolana i 88 sentimita, a nibolana i 44 sentimita, a nipesina i 66 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Muri ri kavitagua na gol kabakaba ri lili haluia a harena na tabekena gol ola ola. ");
INSERT INTO bnp_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","A harena dede ni kavitagu na lilina gol. A nibolana i 8 sentimita. Muri ri lili haluia vona a gol gatuka. ");
INSERT INTO bnp_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ri rata na gol a halui i va, ri kolo na nimodo i va na vahana dede. ");
INSERT INTO bnp_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ra halui nga, ni ru tabukoi na harehare polomeli, ne vona ni rodo dili a binole. ");
INSERT INTO bnp_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ri kau na tabekena kai a akas a binole, ri naviri na gol. ");
INSERT INTO bnp_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ri rata na gol kabakaba a maka mahalana dede, a maka tavila, a pelete, a kikei ne vona ni ratana a nihabi na vain. ");
INSERT INTO bnp_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ri rata tabua na gol kabakaba a butuna lam. Ri ubia na ama a tabekena gol, ri ratea a vuhu-butu ne vona ni vakapesi a butu. Ri rata loboa a butuna lam ri vakabagetua na maka keke ni rata na gol. A maki nga ri rata i manga a maki i taku. ");
INSERT INTO bnp_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","A butuna lam i tahoka a bakona i polotara. I tolu na tabeke koea, i tolu na tabeke tara. ");
INSERT INTO bnp_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ri vakabagetu a bakona takutaku na keke i tolu, i manga a purana kai a almon. ");
INSERT INTO bnp_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ri vakabagetu a butuna lam na keke i va ni rata manga a purana a kai a almon. ");
INSERT INTO bnp_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ri rata a pagana keke kiroko, a pagana i taku i polotano na bako i rua. ");
INSERT INTO bnp_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","A tabekena gol kabakaba ni tutu ni rata vona a maki nga i manga a maki i taku. ");
INSERT INTO bnp_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Muri ri bole a gol kabakaba ri rata a lam i polorua ne vona ni ru na bako, a maka pelete, a maka kaira ne vona ni kapi a kanono. ");
INSERT INTO bnp_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ri bole a gol kabakaba i 34 kilo, ri rata a butuna lam turana a maka mahalana. ");
INSERT INTO bnp_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ri ratea a dede na havu mangisipa na kai a akas. A harena i va i palupulupu i 45 sentimita, a nipesina i 90 sentimita. A dede i tahoka a tupina i va ni rata na nimodo na dede. ");
INSERT INTO bnp_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ri kavitagu a hini polomeli, a gagana i va, a tupina i va na gol, muri i raro haluia a harena na tabekena gol ola ola. ");
INSERT INTO bnp_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Muri ri rata na gol a halui i rua ne vona ni rodo polo a binole. Ra halui nga, ni kolo tabukoi na harena polomeli. ");
INSERT INTO bnp_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Muri ri kau na kai a akas a binole i rua, ri naviri na gol ne vona ni kaloho a dede na havu mangisipa. ");
INSERT INTO bnp_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Muri ri ratea a nibiri, ra nibiri iea ni taba ne vona ni gamai a maki, a havu mangisipa i ratea a mari. ");
INSERT INTO bnp_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","E Besalel turane huriki a mari ri ratea a dede na kai a akas, ne vona a nihabi gutu-vuro. A tabekena dede i va i palupulupu i 2 mita 2 sentimita, a nipesina i 1 mita 30 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ri kau a tupi na nimodo i va na dede, ri vakamadoko turana a dede i manga a maki i taku. Muri ri naviri loboa na bras a dede. ");
INSERT INTO bnp_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ri bole a bras ri rata a maka pelete ne vona ni bole a kanono, a maka nikuri, a maka tavila, a maka kaira, a maka tavila ne vona ni bole a habulona kanono. ");
INSERT INTO bnp_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ri bole a bras, ri rata a maki i va i tahoka a dupi, ri kolo na vahana dede, polotano na maki ni raro halui na kurukuruna dede. ");
INSERT INTO bnp_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ri rata na bras a halui i va, ri kolo tata na nimodona na dede i va. Ra halui nga, ne vona ni rodo dili a binole. ");
INSERT INTO bnp_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ri kau a tabekena a kai a akas i rua ga binole, ri naviri na bras. ");
INSERT INTO bnp_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ri rodo dili na halui a binole na tabekena dede i rua. Ra dede iea i manga a tava ni rata na kai, pali a hini polotano i uka kai. ");
INSERT INTO bnp_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ri bole a bras ne huriki a ngatavine ri leho na matana Kape na Vaponga, ri rata a tavila na hilova turana a dedena. ");
INSERT INTO bnp_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ri rahia a kala dagi ne vona ni tura halui a kape. Na tabeke mule puru a niolana kala i 44 mita. ");
INSERT INTO bnp_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ri bole a maka bras ri rata a mito i ravulu rua, a vuhu-butu ni vakapesi langa na mito vona i ravulu rua. Pali a maka karona a maka kinau ni rata na silva. ");
INSERT INTO bnp_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Na tabeke mule sike i mavonga kunana. ");
INSERT INTO bnp_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","A nure na tabeke na nirolona haro i tahoka tara kala i tavore vonga, a niolana i 22 mita, i tahoka a mito i ravulu ni rata na bras turana a vuhu-butu i ravulu. A maka kinau na butu, a maka karona ni rata na silva. ");
INSERT INTO bnp_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","A nure na tabeke na nirikena haro ia tara i 22 mita, a logo i vonga. ");
INSERT INTO bnp_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Na tabeke tara na dilidala i tahoka a kala, a niolana i 6 mita 60 sentimita, i tahoka a butu i tolu, a vuhu-butu i tolu. ");
INSERT INTO bnp_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","A tabekena logo tara i rata mavongea. ");
INSERT INTO bnp_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","A maka kala kamumu kunana ni rata ni kavitagu a nure. ");
INSERT INTO bnp_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","A maka vuhu-butu ni vakapesi a maka mito vona ni rata na bras. A maka kinau a maka karo ne vona ni vakatora a maka mito, ni rata na silva. Ri naviri a maka mapana mito na silva kunana. Muri ri varaki palupu a maka mito na nure na karona ni rata na silva. ");
INSERT INTO bnp_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ri ratea a kala kamumu na dilidala. Ri rahi dili a maka bagetua vona na maka hotu ni rata na vuna sipsip gomagoma, na vuna sipsip kuakua, na vuna sipsip vururu. A niolana kala i 9 mita, a nipesina i 2 mita 20 sentimita, i manga a kala na nure. ");
INSERT INTO bnp_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ri vakatavorea a kala iea na butu i va, i pesi langa na vuhu-butu i va ni rata na bras. A maka kinau, a tavana mapana mito, a maka karo ni rata na silva. ");
INSERT INTO bnp_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","A maka niroka ni rata na bras, ne vona ni tua, ni vakatora a mota na nure a kape. ");
INSERT INTO bnp_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ni gi palupu a maka gol, a silva, a bras ni hae a kape na Ngava Dagi vona. E Moses kunana i taki e huriki a Levi ri ratea a leho iea. E Itamar e tune Aron a prister, i matakaria ra leho iea. ");
INSERT INTO bnp_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","E Besalel, e tune Uri bakovi e tubune Hur na kabu ne Iuda, i rata lobo a maki e BAKOVI DAGI i vakuku e Moses vona ge rata. ");
INSERT INTO bnp_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","A bakovi i leho turana, e Oholiap, e tune Ahisimak na kabu ne Dan. A leho vona ni kau a maki legelege na kedo. I lohoka tabu ni rahi a bagetua na maka hotu legelege, na hotu gomagoma, na hotu kuakua, na hotu vururu ni rata na vuna sipsip. ");
INSERT INTO bnp_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","A maka gol i habi e huriki ne vona ni hae a mailo vona, ni gi palupu a nimavane ria i 998 kilo. ");
INSERT INTO bnp_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","A maka silva, a nimavane ria i 3,430 kilo. A rane huriki ri habi a maka silva ni here puru na puhu. ");
INSERT INTO bnp_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","E huriki ri tahoka a pida i ravulu rua i rike, ri habi a silva i 6 gram. E huriki ri habi a silva ri ala 603,550. ");
INSERT INTO bnp_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ni bole palupu a kilo na silva i 3,400 ni rata a vuhu-butu i 100 ne vona ni vakapesi a maka mito na nure, a vuhu-butu na butu ne vona ni vakatavore a kala dagi i naviri mulea a Tabeke Nitaba Hateka. A vuhu-butu i taku a nimavana i 34 kilo. ");
INSERT INTO bnp_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A silva i tababana i 30 kilo. Lakea ni bole ni rata a maka kinau, a maka karo, a naviri ni kavitagu a mapana mito. ");
INSERT INTO bnp_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","A nimavana a maka bras ni habi i 2,425 kilo. ");
INSERT INTO bnp_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ni bole a bras nga ni rata a vuhu-butu na matana Kape na Vaponga, a dede turana a maki ri tahoka a dupi, a maka mahalana dede, ");
INSERT INTO bnp_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","a maka vuhu-butu na nure ni tura halui a kape, turana a vuhu-butu na dilidala na nure, a maka niroka na nure na mailo na Vure. ");
INSERT INTO bnp_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","E Besalel turane huriki a mari ri bole a maka vuna sipsip i gomagoma, i kuakua, i vururu ni rata a bagetua kamumu na prister, ge rodo na tahuna ri leho na Tabeke Nitaba. A maka bagetua kamumu ne Aron, ni rata ramai a nitane BAKOVI DAGI i taki e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","A bagetua nga ni vakabagetu na hotu ni rata na gol, na hotu ni rata na maka vuna sipsip gomagoma, i kuakua, i vururu. ");
INSERT INTO bnp_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","A gol ni ubi na ama i lili kiroko liu, ne vona ni rahi dili na bagetua turana a hotu gomagoma, i kuakua, i vururu. ");
INSERT INTO bnp_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Muri ni rata a palabele na loho i rua, ne vona ni huraki a bagetua, bara i tavore na lohona prister. ");
INSERT INTO bnp_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","A palabele ni rata na lilina kala ne vona ni tango tata a bagetua iea. A maka bagetua ni rata na hotu ni rata na gol, na hotu ni rata na maka vuna sipsip gomagoma, i kuakua, i vururu, i ramaia a nitane BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ri here a rane huriki e tune Israel bakovi na kedo oniks i rua, ni vakabagetu na gol. ");
INSERT INTO bnp_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Muri ni kolotata a kedo nga na palabele ra i nugutata a kala na lohona prister, i ramaia a ngava e BAKOVI DAGI i vakuku e Moses vona. Ra kedo nga ne vona ni luhoi mule e huriki e tune Israel bakovi. ");
INSERT INTO bnp_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ri rata a kala na ngalana prister manga a bagetua ranga na prister. Ni vakabagetu na hotu ni rata na gol, na hotu ni rata na maka vuna sipsip gomagoma, i kuakua, i vururu. ");
INSERT INTO bnp_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","A kala na ngala ni pilu kamumu na kurukuruna, a niolana, a nibolana i palupulupu, i 22 sentimita. ");
INSERT INTO bnp_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","A maka kedo ni kolo na tete i va. Na tete muga ni kolo dili a sardius, a topas, a karbanakel. ");
INSERT INTO bnp_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Na ruana tete ni kolo dili a kedo a emeral, a sapaia, a daiman. ");
INSERT INTO bnp_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Na toluna tete ni kolo dili a iasin, a aget, a ametis. ");
INSERT INTO bnp_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Na vana tete ni kolo dili a beril, a oniks, a iaspa. A kedo i taku ni vakabagetu na gol, muri ri varomu dili na bagetua. ");
INSERT INTO bnp_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","A rane huriki e tune Israel ni here takutaku na kedo i ravulu a polona i rua, ge a kilakila na kabu takutaku ne Israel. ");
INSERT INTO bnp_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","A sen i rua ni rata na gol kabakaba ne vona ni tangotata a kala na ngala, ");
INSERT INTO bnp_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","a bagetua na gol i rua, a halui ni rata na gol i rua. Ni varomu a halui nga, polomeli na nimodona kala na ngala. ");
INSERT INTO bnp_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Muri ni ru a sen i rua ni rata na gol, a halui i rua na harena kala na ngala. ");
INSERT INTO bnp_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","A bagetua na gol ni varomu dili na harena sen, ni kolo dili na palabele i nugutata a kala. ");
INSERT INTO bnp_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ni rata na gol a halui i rua, ni kolo polotano na nimodona kala na ngala tabukoi na kala dagi. ");
INSERT INTO bnp_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","A halui gol i rua ni rata tabu ni varomu na palabele i rua i nugutata a bagetua, polomeli na palabele ni rea halui a kakai. ");
INSERT INTO bnp_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ni bole a mota gomagoma, ni varomu a halui i rua na kala na ngala i lakea na halui i rua na bagetua dagi. A kala na ngala i madoko tata na palabele, i uka ma ge mavuka, i ramaia a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","E Besalel turane huriki a mari ri bole a hotu gomagoma ri rahi a nirodo ola ola ne vona ni kolo turana a bagetua. ");
INSERT INTO bnp_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ni rahi halui a murina hini ni rodo dili a gina viri vona, lakea i uka ma ge marape. ");
INSERT INTO bnp_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","A hotu legelege ni bole ni rahi dili a maki i manga a kanena kai a pomigranet. A maka belo ni rata na gol kabakaba. A pomigranet a belo ni rahi na harena bagetua polotano. A maka belo ni ru na maka kurukuruna pomigranet ri tavore, i ramaia a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","29","A maka maki ne Aron turane huriki e tuna ri rodo, ni rata na kala kamumu, a nirodo ola ola, a hoi, a poho, a palabele, a paga. Ri bole a maka hotu legelege ni rahi dili a bagetua kamumu, ri ramai a ngava e BAKOVI DAGI i taki. ");
INSERT INTO bnp_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","A hulongi na prister ni rata na gol kabakaba, ge vakasiria i leho ne BAKOVI DAGI kunana. A nita ni here vona i maea, “Ne vona e BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ni bole a mota gomagoma ni kolo na hoi a hulongi, i ramaia a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","E huriki a Israel ri ru palupu lobo a maka mahalana kape, e BAKOVI DAGI i vakuku e Moses vona ge bole. ");
INSERT INTO bnp_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Muri ri habi ne Moses a kape turana a maka mahalana, a maka kinau, a maka mito, a maka karo, a maka butu, a maka vuhu-butu ne vona ni vakapesi a maka butu, ");
INSERT INTO bnp_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","a kadis na kape ni rata na kulina sipsip a toga, a kadis tara ni rata na kulina lui, a kala dagi ne vona ni naviri mule a Tabeke Nitaba Hateka, ");
INSERT INTO bnp_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","a Tava na Ngava Dagi turana a binolena i rua. Ra hini polomeli na tava a murina nidodo. ");
INSERT INTO bnp_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Ri bole valai a dede turana a maka mahalana, a maka bret ne vona ni ru na dede, ");
INSERT INTO bnp_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","a butu na lam ni rata na gol kabakaba, a maka lam turana a namona oliv. ");
INSERT INTO bnp_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Ri bole valai a dede ni rata na gol, a nibiri ne vona ni gamai a maki na nivasileki, a havu mangisipa, a kala ne vona a matana kape. ");
INSERT INTO bnp_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Ri bole valai a dede ni rata na bras turana a tabekena bras ni vakamadoko na vahana dede, a binole ni kaloho a dede, a maka mahalana dede, a tavila ni hilolo turana a dede vona; ");
INSERT INTO bnp_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","a maka kala na nure, a maka mito, a maka butu, a maka vuhu ni vakapesi a butu vona, a kala dagi na logo na kape, a maka mota ne vona ni kolotata a maki, a maka niroka ne vona ni tua a mota, a maka maki ne vona ni rata a leho pololilo na kape, ");
INSERT INTO bnp_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","a maka bagetua kamumu ni gi rodo, ni gi rata a leho pololilo na Tabeke Nitaba, a maka bagetua ne Aron, ne huriki e tuna. ");
INSERT INTO bnp_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","E huriki a Israel ri rata lobo a maka maki e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","E Moses i lei kamumu a maki ri rata, i vivi, a vuhuna ri rata lobo a maki e BAKOVI DAGI i vakukua vona. Muri e Moses i gamai ria. ");
INSERT INTO bnp_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“O longo, na mugana parava na keva, mu vakapesia a mailo nau. ");
INSERT INTO bnp_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","O bolea a Tava na Ngava Dagi o ru dilia o vulala karia na kala dagi. ");
INSERT INTO bnp_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","O ru dilia a dede o ru langa vona a maka mahalana. Muri o ru dilia a butuna lam o ru langa na bakona a maka lam. ");
INSERT INTO bnp_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","O bolea a dede ni rata na gol ne vona a havu mangisipa, o vakatabulia tabukoi na Tava na Ngava Dagi, polovavo na kala i naviri mule a tava. O vakatavorea a kala na matana mailo na Vure. ");
INSERT INTO bnp_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","O bolea a dede ne vona a nihabi gutu-vuro, o ru tabukoia na matana kape. ");
INSERT INTO bnp_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","O rua na koropalana Kape na Vaponga a dede na nihabi gutu-vuro, a tavila, o kiru dili a naru vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","O vonu a maka mito o tura haluia a mailo nau, o vakatavorea a kala dagi na matana. ");
INSERT INTO bnp_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Muri o bolea a nibiri, o gamai a mailo nau turana a maka mahalana ga maki nau. ");
INSERT INTO bnp_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","A dede ne vona a nihabi gutu-vuro tara, o gamaia turana a maka mahalana. ");
INSERT INTO bnp_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","A tavila turana a dede vona, ngi ranga o gamai. ");
INSERT INTO bnp_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“O tuli lakea na matana Kape na Vaponga e Aron turane huriki e tuna a bakovi, o vahilolo ria vonga. ");
INSERT INTO bnp_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Muri o vakarodoa na bagetua na prister e Aron, o guru langa a nibiri vona, o gamaia ge ia a prister. ");
INSERT INTO bnp_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Muri o tuli valai tabukoi e huriki e tuna bakovi, o vakabagetu ria na bagetua na prister. ");
INSERT INTO bnp_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","O gamai ria ge manga a hini o gamaia e tamane ria, ge ria a prister nau. Muri e huriki a hamone ria bara ri rata a leho na prister vakaroro.” ");
INSERT INTO bnp_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","E Moses i rata lobo a maka leho e BAKOVI DAGI i taki vona ge rata. ");
INSERT INTO bnp_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Na mugana parava, na mugana keva, na ruana pida muri na tahuna ri mariu tala o Egipto, a mailo na Vure ni vakapesi. ");
INSERT INTO bnp_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Na tahuna i vakapesi a mailo na Vure, i bole a maka vuhu-butu, i ru na malala ne vona ni vakapesi a maka mito. I ru tavalavala a maka karona nure; i vakapesi a maka butu ne vona ni vakatavore a kala. ");
INSERT INTO bnp_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Muri i ru langea na mailo na Vure a kadis, i kavitagu tabua a kape, i manga a ngava e BAKOVI DAGI i vakukua vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","I bole a kedo i rua ni here vona a Ngava Dagi, i ru dili na Tava na Ngava Dagi. I rodo dili a binole na halui na tava, i kavitagua a matana tava. Ra matana tava a murina nidodo. ");
INSERT INTO bnp_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Muri i ru pololilo na kape a tava, i vakatavorea a kala dagi i naviri mulea, i manga a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","E Moses i ru dilia na Tabeke Nitaba a dede na tabeke mule sike. ");
INSERT INTO bnp_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Muri i bole a maka bret, i ru na dede na matane BAKOVI DAGI, i manga a ngava i vakukua vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Muri i ru dilia na Kape na Vaponga na hini mule puru, tabukoi na dede a butuna lam. ");
INSERT INTO bnp_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Muri i vakapesi a maka lam na bakona butu, i nami i para na matane BAKOVI DAGI, i ramaia a ngava i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","I ru dilia a dede ni rata na gol na Kape na Vaponga polovavo na kala. ");
INSERT INTO bnp_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","I rungani langea na dede a havu mangisipa, i ramaia a ngava e BAKOVI DAGI i vakukua vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Muri i vakatavorea a kala na matana mailo na Vure. ");
INSERT INTO bnp_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Muri i bole a dede na nihabi gutu-vuro i ru tabukoia na matana mailo na Vure. Ra dede iea ne vona ni gutu-vuro a sipsip, a vit, i ramaia a ngava e BAKOVI DAGI i vakukua vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","I ru a tavila na koropalana dede, a Kape na Vaponga, i guru dili a naru, ne vona ni hilolo. ");
INSERT INTO bnp_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Muri e Moses e Aron turane huriki e tune Aron bakovi ri vahilolo a limane ria, a vahane ria vona a naru iea. ");
INSERT INTO bnp_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Muga ne ria ri dili na kape o ri lakea na dede, bara ri vahilolo taro a limane ria a vahane ria, i ramaia a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Muri e Moses i tura halui a mailo na Vure a dede, i vakatavorea a kala na poridala na nure. Ngane i vakalobo liu a maka leho. ");
INSERT INTO bnp_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","A leho i lobo, muri a bubu i kavitagua a Kape na Vaponga, a parana e BAKOVI DAGI i paraia a mailo vona. ");
INSERT INTO bnp_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Pali e Moses i keri ni dili na Kape na Vaponga, a vuhuna a bubu i pesi langa vona, a parana e BAKOVI DAGI i paraia. ");
INSERT INTO bnp_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Na tahuna a bubu i pe a mailo na Vure, e huriki a Israel bara ri bole a maka galesi ne ria, ri ramaia. ");
INSERT INTO bnp_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pali a bubu bara i tababana ni pesi langa na mailo na Vure, i uka ma ri gi vano. Na tahuna ri masia a bubu i pea a mailo, ngane bara ri pesi rike ri ramaia. ");
INSERT INTO bnp_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","A bubu ne BAKOVI DAGI i pesi langa na mailo na Vure na haro, a kanono i para pololilo na bubu na rodo. Ra maki nga i maea kunana, i matai e huriki a Israel na tahuna ri havai. ");
INSERT INTO bnp_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","E Levi E BAKOVI DAGI i gale pololilo na Kape na Vaponga, i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","E Levi “O taki e huriki a Israel, a viri i ngaru ni habi a nihabi nau, ge bolea tara bulmakau, a sipsip, o a meme ge habia. ");
INSERT INTO bnp_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Bara a viri i ngaru ni habi a nihabi gutu-vuro nau, ge bolea a bulmakau a toga ge gavutuvutu. Ge ratea a nihabi iea, ge taparaki lakea tabukoi na matana Kape na Vaponga, lakea iau, e BAKOVI DAGI, bara ngarua. ");
INSERT INTO bnp_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ge ru langea na gina bulmakau iea a limana, lakea iau bara ngarua a nihabi vona, bara i kavitagua a naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Muri ge rabalakia a bulmakau iea na matane BAKOVI DAGI, lakea e huriki a prister, e tune Aron bakovi, ri gi bole a darana, ri gi lakea na dede i tabuli tabukoi na matana Kape na Vaponga, ri gi voro tamali na tabeke lobo na dede. ");
INSERT INTO bnp_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Muri ra bakovi iea ge riri talea a kulina bulmakau, ra nihabi gutu-vuro, ge poka kesikesia. ");
INSERT INTO bnp_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","E huriki a prister, e tune Aron, ri gi tunua na dede a kanono, ri gi ru langa na kanono a kai. ");
INSERT INTO bnp_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Muri ri gi bole a maka bobona, a gina, a maka vina ri gi ru langa na kanono na dede. ");
INSERT INTO bnp_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Pali a mahalana, a vahana, ge loi kamumu na naru. Muri ge habi na prister ge gutu lobo na dede, ge a nihabi gutu-vuro, ge a nihabi ni gutu na kanono. Na tahuna e BAKOVI DAGI i burongi a mangina kinani, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Bara a viri i habi a sipsip o a meme ne vona ni habi gutu-vuro, ge bolea a toga ge gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ge rabalakia na matane BAKOVI DAGI na tabeke mule sike na dede. E huriki a prister ri gi bole a darana, ri gi voro tamali lakea na tabeke lobo na dede. ");
INSERT INTO bnp_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ge poka kesikesia, ge bole a mapana, a vina, ge habi na prister, ge ru langa na kanono na dede. ");
INSERT INTO bnp_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Pali a maka mahalana, a pakana ge vahilolo na naru. Muri ge habi na prister ge gutu lobo na dede, ge a nihabi gutu-vuro, ge a nihabi ni gutu na kanono. Na tahuna e BAKOVI DAGI i burongi a mangina kinani, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Bara a viri i ngaru ni habi a kadirovo ge a nihabi gutu-vuro ne BAKOVI DAGI, ge bolea tara balu, ge habia na prister. ");
INSERT INTO bnp_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Muri a prister ge bolea a balu ge lakea na dede, ge horia a lohona ge mate. Ge rakudu talea a gina balu, ge gutua na kanono na dede, ge guru tala na gagana dede a darana. ");
INSERT INTO bnp_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ge pasi vuroki a vuna balu, ge kini talea a guruna ra i tabuli vona a maki i kani, ge vuroki lakea na tabeke ni ru kadolu a habulo vona, na tabeke na nirikena haro na dede. ");
INSERT INTO bnp_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","A prister ge nugua na karapana balu ge tua tala, pali nahea ge tuarape kesikesia. Muri ge habi na prister ge gutu langa na kanono na dede, ge a nihabi gutu-vuro, ge a nihabi ni gutu na kanono. Na tahuna e BAKOVI DAGI i burongia a mangina kinani, bara i vivi.” ");
INSERT INTO bnp_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","E BAKOVI DAGI i taki tabua e Moses, “Na tahuna a bakovi tara i ngaru ni habi ne BAKOVI DAGI ranga vit, ge vila tala a kulina vit, ge bole a kanena, ge rata a plaoa kamumu. Ge guru langa vona a namona oliv, a havu mangisipa. ");
INSERT INTO bnp_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Muri ge bole a maki nga ge lakea ne huriki e tune Aron, re huriki a prister. A prister tara ge ragamu tala na limana ranga plaoa kamumu, turana a namona oliv, a havu mangisipa. Muri ge habi na prister ge gutu langa na dede, ge a nihabi ni gutu na kanono. A nihabi iea ge ratea e BAKOVI DAGI ge luhoia. Na tahuna e BAKOVI DAGI i burongia a mangina kinani, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","A maka nihabi na vit i tababana ni gi habi ne Aron turane huriki e tuna bakovi, ra nihabi iea, a nihabi ni gutu na kanono ni taba ne vona e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Mua bara mu ngaru ni gutu a bret na oven ge a nihabi, naha ni vuli turana a is. Mu bole a plaoa kamumu mu vuli turana a namona oliv, mu rata a bret, ge a nihabi. Mua mu marikoi ni rata a bret, mu rata a bisket ge i uka is, mu ravu na namona oliv. ");
INSERT INTO bnp_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Mua bara mu ngaru ni nono a plaoa na ulo kabelabela ge a nihabi, mu bole a plaoa kamumu ge uka is, mu vuli turana a namona oliv, mu gutu. ");
INSERT INTO bnp_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Mu pua a bret ge momo, mu guru langa vona a namona oliv, ge a nihabi na vit. ");
INSERT INTO bnp_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Mua bara mu rata a bret ge a nihabi, mu gutu na ulo, mu bole a plaoa kamumu, mu vuli turana a namona oliv. ");
INSERT INTO bnp_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Mu bolea a nihabi na vit, mu rata a maki nga, mu taparaki lakea na prister ge bole lakea na dede, ge habi ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Muri a prister ge bole tala na nihabi na vit a tabekena popote, a maki iea ge ratea e BAKOVI DAGI ge luhoia. Ge gutu na dede, ge a nihabi ni gutu na kanono. Na tahuna e BAKOVI DAGI i burongia a mangina kinani, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","A maka nihabi na vit i tababana ni gi habi ne Aron turane huriki e tuna bakovi, ra nihabi iea, a nihabi ni gutu na kanono ni taba ne vona e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Naha ni vuli a is turana plaoa ge a nihabi na vit ne BAKOVI DAGI, a vuhuna i uka ma go gutu a is, a ame na nihabi go habi ne BAKOVI DAGI na kanono. ");
INSERT INTO bnp_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ioe bara o ngaru, o vuli a is, a ame turana a maki i moro muga na hania, ge a nihabi ne BAKOVI DAGI, pali naha ni gutu na dede ge huli manginoro a mangina. ");
INSERT INTO bnp_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","A maka nihabi lobo na vit, ni gi ru a mami vona. Naha ni longokaburungi ni ru a mami na maka nihabi ne mua, a vuhuna a mami a kilakila na ngava dagi mu rata turana Vure. Mu ru a mami na maka nihabi lobo. ");
INSERT INTO bnp_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Mua bara mu habi ne BAKOVI DAGI a vit i moro muga na hania, mu tutu, mu gutu na kanono, muri mu habi vona. ");
INSERT INTO bnp_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Mu bole a namona oliv, a havu mangisipa mu guru langa na maka vit, ge a nihabi na vit. ");
INSERT INTO bnp_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","A prister ge bole tala a vit popote, a namona oliv, turana a maka havu mangisipa, a maki nga ge ratea e BAKOVI DAGI ge luhoia, ge a nihabi ni gutu na kanono lakea vona.” ");
INSERT INTO bnp_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","E BAKOVI DAGI i taki tabua e Moses, “A bakovi bara i habi a nihabi na nivalemu lakea ne BAKOVI DAGI, ge bolea a bulmakau a toga o a bulmakau a kinana ge gavutuvutu, ge habia ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ra bakovi iea ge ru langea na gina bulmakau a limana, muri ge rabalakia a bulmakau na matana Kape na Vaponga. E huriki a prister, re huriki e tune Aron, ri gi voro tamali a darana bulmakau na tabeke lobo na dede. ");
INSERT INTO bnp_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","Ra bakovi iea ge bole tala na nihabi na nivalemu maka vina i kavitagu a mahalana bulmakau, a maka vina pololilo na mahalana bulmakau, turana a vuanalipi i rua, turana a vina i rako taho rua, a kinake tara ni riri tala turana a vuanalipi. Ge habi na prister, ge gutu na kanono, ge a nihabi ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","E huriki e tune Aron ri gi gutu na dede a maki nga turana maka nihabi ni gutu-vuro i tabuli na kanono, ge a nihabi ni gutu na kanono. Na tahuna e BAKOVI DAGI i burongia a mangina kinani, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“A bakovi bara i habia a tuna sipsip o a meme ge a nihabi na nivalemu lakea ne BAKOVI DAGI, ge bolea a toga o a kinana, ge gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Na tahuna i habia a tuna sipsip ge a nihabi, ge rua na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Ra bakovi iea ge ru langea a limana na gina sipsip, muri ge rabalakia a sipsip na matana Kape na Vaponga. Muri e huriki e tune Aron, ri gi voro tamali a darana sipsip na tabeke lobo na dede. ");
INSERT INTO bnp_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Muri ge bole tala na nihabi na nivalemu a tabekena sipsip ni gi gutu, ge a nihabi ni gutu na kanono ne BAKOVI DAGI. Ge bole a maka vina, a vina i kavitagu a mahalana, a vina na mahalana, a vina na kuna. A kuna sipsip ni gi pala tala tabukoi liu na tuha burena. ");
INSERT INTO bnp_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Ge hali tala a vuanalipi i rua turana a vina i rako taho rua, a kinake tara ni riri tala turana a vuanalipi. ");
INSERT INTO bnp_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","A prister ge gutu langa na dede a maki nga ge a kinani, ge a nihabi ni gutu na kanono ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Na tahuna a bakovi ge habi a meme ge a nihabi, ge bole lakea na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Ra bakovi iea ge ru langea na gina meme a limana, muri ge rabalakia a meme na matana Kape na Vaponga. Muri e huriki e tune Aron, ri gi voro tamali a darana meme na tabeke lobo na dede. ");
INSERT INTO bnp_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Na nihabi iea, a bakovi ge habi a nihabi ni gutu na kanono ne BAKOVI DAGI: ge bole tala a vina i kavitagu a mahalana meme, a maka vina pololilo na mahalana, ");
INSERT INTO bnp_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","turana a vuanalipi i rua turana a vina i rako taho rua, a kinake tara ni riri tala turana a vuanalipi. ");
INSERT INTO bnp_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","A prister ge gutu a maki nga na dede ge a kinani, ge a nihabi ni gutu na kanono, i manginoro a mangina. A vina nga ne vona e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Ra vinara iea ge tabuli turana a hamone mua vakaroro. I vai a tabeke mu made vona, bara mu ramai kunanea: Naha ni kani a vina kanirau o mu gu ninu a darana.” ");
INSERT INTO bnp_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“O taki e huriki a Israel e rei a viri i rata ruru a naro hale, i putu puru a maka vinara ne BAKOVI DAGI, ge ramai a naro nga: ");
INSERT INTO bnp_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Na tahuna a prister dagi i rata a naro hale i habi a rarenga ne huriki, ge bolea tara bulmakau karaba, a toga ge gavutuvutu, ge habia ne BAKOVI DAGI ne vona a nihabi na naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","A prister ge bolea a bulmakau iea ge lakea na matana Kape na Vaponga na matane BAKOVI DAGI, ge ru langa a limana na gina bulmakau. Muri ge rabalakia na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","A prister ni gamai ge bole ranga darana bulmakau iea, ge bole dili na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Muri a prister ge lutua na dara a kukulimana, ge voro tamali balaka polorua na matane BAKOVI DAGI tabukoi na kala dagi i naviri mule a Tabeke Nitaba Hateka. ");
INSERT INTO bnp_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Muri a prister ge lakea na dede na havu mangisipa i pesi na matane BAKOVI DAGI pololilo na Kape na Vaponga, ge ru na maka tupi na dede ranga dara. A darana bulmakau a toga i tababana, ge bole tala na matana Kape na Vaponga, ge guru na taruna dede na nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Muri ge bole tala na nihabi na naro hale a vina, ra vina i kavitagu a mahalana, a vina pololilo na mahalana, ");
INSERT INTO bnp_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","turana a vuanalipi i rua turana a vina i rako taho rua, a kinake tara ni riri tala turana a vuanalipi. ");
INSERT INTO bnp_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","A prister ge gutu a mahalana nga, ge gutu na dede na nihabi gutu-vuro. Ge rata manga a vina bulmakau ni rata na nihabi na nivalemu. ");
INSERT INTO bnp_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Pali ge bole a kulina, a bobona, a gina, a maka vahana, a maka mahalana, a tahena, ");
INSERT INTO bnp_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","a maka tabekena i tababana, ge bole tala na mada na hini i matapado ni guru a habulo vona, ge gutu na kanono vonga polomeli na mola. ");
INSERT INTO bnp_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Na tahuna e huriki a Israel ri rata ruru a naro hale, ri putu puru a vinara ne BAKOVI DAGI, pali ria i uka ma ri lohoka vona, ra naro ri ratea ri tahoka a ngava vona. ");
INSERT INTO bnp_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Muri na tahuna ri matakilaka vona a naro hale ne ria, ri gi bole lakea na matana Kape na Vaponga tara bulmakau karaba a toga, ge a nihabi na naro hale ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Na matane BAKOVI DAGI, e huriki a gare na vaponga ri gi ru langa a limane ria na gina bulmakau, muri ri gi rabalakia na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Muri a prister ni gamai ge bole dili na Kape na Vaponga ranga darana, ");
INSERT INTO bnp_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ge lutua na dara a kukulimana, ge voro tamali balaka polorua na matane BAKOVI DAGI tabukoi na kala dagi i naviri mule a Tabeke Nitaba Hateka. ");
INSERT INTO bnp_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ge lakea na dede i pesi na matane BAKOVI DAGI pololilo na Kape na Vaponga, ge ravu na maka tupina dede ranga dara. A darana bulmakau a toga i tababana, ge bole paru, ge guru na taruna dede na nihabi gutu-vuro na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Muri ge bole a vina lobo, ge gutu na dede, ");
INSERT INTO bnp_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ge rata manga a naro i ratea na nihabi na naro hale vona. I mavonga kunana a prister ge rata a nihabi ge kavitagu ria, lakea bara ni puga vuroki a naro hale ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Muri ge bole talea a bulmakau a toga iea na mada, ge gutua na kanono, i manga a hini i gutu muga a bulmakau na naro hale vona. Ra bulmakau e huriki a Israel ri habia, a nihabi na naro hale ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Na tahuna a matakari tara i rata ruru a naro hale, i putu puru a vinara ne BAKOVI DAGI, a Vure vona, ra naro i ratea, i tahoka a ngava vona. ");
INSERT INTO bnp_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Muri ge matakilaka vona a naro hale i ratea, ge bolea tara meme a toga ge gavutuvutu, ge a nihabi. ");
INSERT INTO bnp_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Na matane BAKOVI DAGI ge ru langa a limana na gina meme, muri ge rabalakia na hini ni rabalaki a maka kanirau ne vona a nihabi gutu-vuro. Iea a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Muri a prister ge lutua na darana meme iea a kukulimana, ra nihabi na naro hale, ge ravu na maka tupina dede na nihabi gutu-vuro. Muri ge bole paru a dara i tababana, ge guru na taruna dede. ");
INSERT INTO bnp_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Muri ge gutu a vina meme iea na dede, ge manga a naro i ratea na nihabi na nivalemu. I mavonga kunana a prister ge rata a nihabi ne vona ni kavitagu a matakari iea, a naro hale vona ni gi puga vuroki. ");
INSERT INTO bnp_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Na tahuna a bakovi tavula tara i rata ruru a naro hale, i putu puru a vinara ne BAKOVI DAGI, ra naro i ratea, i tahoka a ngava vona. ");
INSERT INTO bnp_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Na tahuna i matakilaka vona a naro hale i ratea, ge bole vilia tara meme a kinana ge gavutuvutu, ge a nihabi na naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ge ru langea a limana na gina meme iea, ra nihabi na naro hale, muri ge rabalakia na tabeke ni gutu a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Muri a prister ge lutua na darana meme a kukulimana, ge ravu na maka tupina dede na nihabi gutu-vuro, ge bole paru a dara i tababana, ge guru na taruna dede. ");
INSERT INTO bnp_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ge bole tala a vina meme lobo, ge manga a naro ni bole tala a vina na nihabi na nivalemu, ge gutu na dede. Na tahuna e BAKOVI DAGI i burongi a mangina kinani, bara i vivi. I mavonga kunana a prister ge kavitagua a bakovi iea, a naro hale vona ni gi puga vuroki. ");
INSERT INTO bnp_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“A bakovi bara i habia tara tuna sipsip ge a nihabi na naro hale, ge bolea a sipsip a kinana ge gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ge ru langea a limana na gina sipsip, ra nihabi na naro hale, muri ge rabalakia na hini ni rabalaki a maka kanirau ne vona a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Muri a prister ge lutu a kukulimana na darana sipsip, ra nihabi na naro hale, ge ravu na maka tupina dede na nihabi gutu-vuro, ge bole paru a dara i tababana, ge guru na taruna dede. ");
INSERT INTO bnp_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ge bole tala lobo a vina tuna sipsip, ge manga a naro ni rata na nihabi na nivalemu. A prister ge gutu na dede langa na maka nihabi ni gutu na kanono ne BAKOVI DAGI. I mavonga kunana a prister ge rata a nihabi ne vona ni kavitagu a bakovi iea, a naro hale vona ni gi puga vuroki.” ");
INSERT INTO bnp_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","E BAKOVI DAGI i taki tabua e Moses, “Na tahuna ni tuli tara viri ge vakalongo a mari ni pelekado a ngava na maki i masia na bakovi tara i ratea, o na maki i longoa na bakovi tara i takia, pali ra bakovi iea i uka ma i taki talea a maki i masia o i longoa, ra bakovi iea i rata a naro hale, bara ni vakamadihi. ");
INSERT INTO bnp_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Na tahuna a bakovi i padoia tara maki i mate i manga a kanirau, a sipsip, a bulmakau, a maki i karaka viliha, ra bakovi iea i muto. Na tahuna a bakovi iea i lohoka vona a maki i ratea, i tahoka a ngava. ");
INSERT INTO bnp_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Na tahuna a bakovi tara i padoia a maki muto na bakovi tara, pali i uka ma i lohoka vona ra bakovi iea i muto. Na tahuna i lohoka vona a naro i ratea, i tahoka a ngava na naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Na tahuna a bakovi tara i kaba tavula ni ratana a maki hale o ni ratana a maki kamumu, i uka ma i lohoka vona a naro hale i ratea. Na tahuna i lohoka vona, i tahoka a ngava. ");
INSERT INTO bnp_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Na tahuna a bakovi i lohoka vona i ratea tara naro hale maea, ge taki tala a naro hale vona ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ne vona ni koli a naro hale vona, a bakovi ge habia tara tuna sipsip o a meme ge a kinana, ge a nihabi na naro hale. A prister ge kavitagua a bakovi iea na naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Pali ia ge uka a moni ni kona a sipsip, ge bole a balu ge rua ge bole valai ne BAKOVI DAGI, ge vakalobo a maregoa vona. A balu tara ge a nihabi ni puga vuroki a naro hale, a balu tara ge a nihabi ni gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ge bole lakea na prister ra balu nga, lakea a prister ge habi mugea tara, ne vona ni puga vuroki a naro hale. A prister ge horia a lohona balu, pali nahea ge rakudu talea a mapana. ");
INSERT INTO bnp_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","A prister ge voro tamali a darana popote na gagana dede. A darana ranga ge bole paru, ge guru polotano na dede. Ra balu iea a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Muri ge habia a balu tara ge a nihabi gutu-vuro, ge ramaia a naro na vinara na nihabi. I mavonga kunana a prister ge habia a balu ne vona ni kavitagu a bakovi iea, lakea a naro hale vona bara ni puga vuroki. ");
INSERT INTO bnp_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Pali na tahuna a bakovi ge uka a moni ni kona a balu ge rua, ge bole vilia a kilo na plaoa ge taku, ne vona a naro hale i ratea. Nahea ge ru a namona oliv o ge ru a havu mangisipa vona, a vuhuna ra plaoa iea a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ge bole lakea na prister, ge ragamu tala ranga, a nihabi iea ge ratea e BAKOVI DAGI ge luhoia. Lakea a prister ge gutu na dede a plaoa popote nga, turana a nihabi na maki ni kani ni gutu na kanono ne vona e BAKOVI DAGI. Ra plaoa iea a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","I mavonga a prister ge rata a nihabi ne vona ni kavitagu a bakovi iea, lakea a naro hale vona ni gi puga vuroki. A plaoa i tababana, ge bole a prister, i manga a nihabi na vit.” ");
INSERT INTO bnp_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Na tahuna a bakovi tara i longokaburungi ni habi a maki ni taba ne BAKOVI DAGI, i manga a hini i taki ge habi, i rata a naro hale. Ra bakovi iea ge bole vilia a sipsip a toga, ge habia ne BAKOVI DAGI ge vakaloboa a naro hale vona. A prister ge takia vona a mapana sipsip ge konea vona ge ramaia a mapana maki ni kona na mailo na Vure. Muri a bakovi iea ge bole vilia na prister tara sipsip a toga, a mapana ge maea. ");
INSERT INTO bnp_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ra maki ni taba i uka ma i habi muga ne BAKOVI DAGI, ngane ge habi ge ru langa tabu ranga ( ). Muri a prister ge habia a sipsip iea ge a nihabi na rarenga, ge kavitagua a bakovi iea, lakea a naro hale vona bara ni puga vuroki. ");
INSERT INTO bnp_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“A bakovi tara bara i putu puru ruru a vinara ne BAKOVI DAGI, pali i uka ma i lohoka vona, ra bakovi iea i rata a naro hale, bara i tahoka a ngava. ");
INSERT INTO bnp_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Lakea ge bole lakea na prister a tuna sipsip a toga ge gavutuvutu. A prister ge takia i riva a mapana, ge a nihabi na rarenga. Lakea a prister ge kavitagua a bakovi iea na hini i rata ruru a naro hale, lakea a naro hale vona bara ni puga vuroki. ");
INSERT INTO bnp_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Iea a nihabi na rarenga, a vuhuna i rata a naro hale na matane BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Bara a bakovi i putu puru a vinara ne BAKOVI DAGI, i rata a naro hale na tahuna i panaho, i tami, i rata marogo a maki na turana i matakari, i biu a turana, ");
INSERT INTO bnp_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","i matavisia tara maki i uka ma i habi mulea, i kaba tavula i uka ma i muholi a nitana, ra bakovi iea i rata a naro hale. ");
INSERT INTO bnp_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","A bakovi i rata a naro hale nga, ge koli a naro hale nga i rata. Na tahuna i rata a nihabi na rarenga vona, ge koli mule taro na tahona a maki nga. A bakovi ge bole a maki, ge habi mulea, turana a maki popote tabu ( ). ");
INSERT INTO bnp_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","A bakovi ge koli a rarenga vona, ge bolea tara sipsip a toga ge gavutuvutu, ge lakea na prister, ge ratea a nihabi na rarenga ne BAKOVI DAGI. A prister ge takia i riva a mapana. ");
INSERT INTO bnp_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Muri a prister ge kavitagua a bakovi iea, na matane BAKOVI DAGI, lakea ra naro hale i ratea i tahoka a ngava vona, bara ni puga vuroki.” ");
INSERT INTO bnp_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“O vakuku e Aron turane huriki e tuna na vinara na nihabi gutu-vuro. Ra nihabi iea ri gi gutu na dede, a kanono ge nono mavonga na rodo malaku, ge harena na hatelanga. ");
INSERT INTO bnp_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Muri a prister ge rodo a nirodo ola ola, a poho ni rata na kala kamumu, ge lakea na dede ge bole a habulo i vona a havu na nihabi gutu-vuro, ge ru tabukoi na dede. ");
INSERT INTO bnp_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Muri ge kali tala a nirodo ola ola vona ge rodo a nirodo ola ola ranga, ge bole tala na mada a havu na kanono, ge ru na tabeke i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","A kanono na dede ni gi rata ge nono vakaroro, nahea ge mate. Na hatelanga lobo a prister ge tunu rikea a kanono, ge bole a maka sipsip a bulmakau na nihabi gutu-vuro ge gutu. A maka vina sipsip a bulmakau na nihabi na nivalemu ranga ge gutu vonga. ");
INSERT INTO bnp_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","A kanono ge nono vakaroro na dede, nahea ge mate. ");
INSERT INTO bnp_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“A vinara na nihabi na vit i maea: e huriki e tune Aron ri gi bolea a nihabi na vit, ri gi habia ne BAKOVI DAGI tabukoi na dede. ");
INSERT INTO bnp_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","I tara ne ria ge ragamu ranga plaoa kamumu ge guru langa vona a namona oliv, a havu mangisipa. Muri ge gutu a plaoa na kanono na dede. Ra plaoa popote nga, ge ratea e BAKOVI DAGI ge luhoia. Na tahuna e BAKOVI DAGI i burongi a mangina kinani, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","A maka plaoa i tababana ge kani e Aron turane huriki e tuna bakovi. Ri gi bole a plaoa ri gi rata a bret i uka is, ri gi kani na Tabeke Nitaba, na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","A bret nahea ni gi vuli turana is ni gi gutu, a vuhuna ra nihabi iea ni taba, i manga a nihabi na naro hale, a nihabi na rarenga. A habi ne huriki a prister a kalavana plaoa ge ne ria, ra kalavana maki ni gutu na kanono ni habi nau, a habi ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","E huriki a bakovi na kabu ne Aron kunana ri gi kani a nihabi ni gutu na kanono ne BAKOVI DAGI. Ra vinara iea ni gi ramai vakaroro muri ma. A ra maki i padoi a nihabi nga, ni taba.” ");
INSERT INTO bnp_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“E huriki e tune Aron bakovi ri gi habi a nihabi ne BAKOVI DAGI na tahuna ri bole karaba a leho na prister. Na parava ni gamai tara ne ria ge ia a prister, ge habia nau tara nihabi. Ge bolea tara kilo i taku na plaoa, ge a nihabi na vit, ge habia na hatelanga a kalavana tara, na malunga a kalavana tara. ");
INSERT INTO bnp_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A prister ge vuli kamumu a plaoa turana a namona oliv, ge gutu na ulo kabelabela. Muri ge keve kesikesi, ge habi ne BAKOVI DAGI manga a nihabi na vit, na tahuna i burongia a mangina kinani bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","E rei a hamone Aron a bakovi ni gamai ge bole a murina, ge habi a nihabi iea ne BAKOVI DAGI. I manga a hini e BAKOVI DAGI i vakuku ria ri gi ramai vakaroro. E huriki a prister bara ri gutu-vuro lobo liu a nihabi. ");
INSERT INTO bnp_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","E huriki a prister nahea ri gi kani a nihabi na vit ri bole valai e huriki. A kanono ge gutu ge vuro lobo liu, a havulana kunana ge tabuli.” ");
INSERT INTO bnp_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“O vakuku e Aron turane huriki e tuna na vinara na naro hale. A nihabi iea ni gi rabalaki na murina ni rabalaki a kanirau na nihabi gutu-vuro na matane BAKOVI DAGI. A nihabi iea ni taba hateka. ");
INSERT INTO bnp_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","A prister ge habia a nihabi iea ne vona a naro hale, ia kunana ge kani a nihabi na tabeke ni taba, ra na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","A ra maki i padoia a bobona nihabi iea, bara ni taba. A darana nihabi iea ni gi voro tamali na varakia tara, mu vahiloloa na tabeke ni taba. ");
INSERT INTO bnp_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","A prister ge nonoa a nihabi iea na ulo ni rata na taka, muri ge ubipodea ra ulo iea. Pali ia ge nonoa na ulo ni rata na bras, ge tuhari kamumua, muri ge loi kamumua na naru. ");
INSERT INTO bnp_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","E rei a bakovi na tara na prister i kara ge kani a nihabi iea, a vuhuna ra nihabi iea ne vona e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pali a nihabi na naro hale, a darana sipsip o a bulmakau vona ni bole dili na Kape na Vaponga, ne vona ni kavitagu a naro hale ne huriki na Tabeke Nitaba, nahea ri gi kani a bobona. Ni gi gutu na kanono.” ");
INSERT INTO bnp_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","E BAKOVI DAGI i takia e Moses ta maea, “A nihabi na rarenga i kiripiripi hateka. A vinara na nihabi iea i maea: ");
INSERT INTO bnp_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","A sipsip a toga na nihabi na rarenga ni gi rabalaki na tabeke ni rabalaki a kanirau na nihabi gutu-vuro. A darana ni gi voro tamali na gagana dede i va. ");
INSERT INTO bnp_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","A vina ri gi habi nau na dede turana a vina na kuna, a kinakena, ");
INSERT INTO bnp_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","a vuanalipi i rua turana a vina, a kinake i kavitagu a hate turana a mahalana ranga. ");
INSERT INTO bnp_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","A prister ge gutu-vuro a vina nga na dede ge habi nau. Ra sipsip iea a nihabi na rarenga. ");
INSERT INTO bnp_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ra nihabi na rarenga i kiripiripi hateka. E huriki a prister ri kara ni kanina. Ri gi kania na tabeke nitaba. ");
INSERT INTO bnp_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","A nihabi na rarenga i manga kunana a nihabi na naro hale. A vinara ne rua i taku kunana. A prister i habi a nihabi iea, i kavitagu e huriki vona, ge bole a bobona kanirau, ge kani. ");
INSERT INTO bnp_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","A prister i rata a nihabi gutu-vuro ne huriki a bakovi, ge bole a kulina ge vona. ");
INSERT INTO bnp_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","I manga kunana a prister i rata a nihabi na vit ni gutu na oven, na ulo, na ulo kabelabela. Ge bole ge kani. ");
INSERT INTO bnp_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","A maka nihabi na vit ni vuli, o i uka ma ni vuli turana namona oliv, ge vaveru e huriki e tune Aron. ");
INSERT INTO bnp_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“A nita na nihabi na nivalemu turane BAKOVI DAGI i maea: ");
INSERT INTO bnp_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“Na tahuna a bakovi i ngaru ni habi a nihabi ni kavurikea e BAKOVI DAGI, ge habi turana a bret i uka is ni vuli turana namona oliv. Ge habi turana a bisket ni ravu na namona oliv, a skon ni vuli kamumu turana a namona oliv. ");
INSERT INTO bnp_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ra nihabi na nivalemu vona, i habi ne vona ni kavurike e BAKOVI DAGI, ge bole ranga bret i tahoka is ge habi turana. ");
INSERT INTO bnp_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","A bakovi ge bole takutaku na maka nihabi na bret ge habi ne BAKOVI DAGI. Ra bret nga ne vona a prister ra i voro tamali a darana sipsip, a bulmakau ne vona a nihabi na nivalemu. ");
INSERT INTO bnp_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ra bobona sipsip, a bulmakau ni rata a nihabi vona, a bakovi ge kani lobo na parava iea kunana, nahea ge tabuli ranga balena ge palala taho a hini. ");
INSERT INTO bnp_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Pali i tebi a nihabi na bakovi i ngaru ni rata a nihabi ne vona ni ta muholi, o ge habi nau a nihabi na ningaru vona. A bobona sipsip, a bulmakau ni gi kani na parava iea. A bobona ni kani kaleva i kara ni gi kani na parava muri. ");
INSERT INTO bnp_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","A bobona sipsip, a bulmakau na nihabi ni kani kaleva na parava muri, ni gi gutu na kanono na toluna parava, ge vuro lobo liu. ");
INSERT INTO bnp_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","A viri i kani a bobona sipsip, a bulmakau ni kani kaleva na toluna parava, na tahuna i habia a nihabi na nivalemu, i uka ma ga ngarua, a vuhuna a nihabi vona i muto na matana Vure. E rei i kania a bobona sipsip, a bulmakau iea i tahoka a ngava. ");
INSERT INTO bnp_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Na tahuna a bobona sipsip, a bulmakau i padoi a maki muto, naha ni kani. Ni gi bole ni gi gutu na kanono ge vuro lobo liu. E huriki ri matapado na matagu ri gi kani ra bobona sipsip, a bulmakau. ");
INSERT INTO bnp_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Pali a bakovi i uka ma i matapado, i kania a bobona sipsip, a bulmakau na nihabi na nivalemu ne BAKOVI DAGI, ni gi tono tala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","A viri i muto na tahuna i padoi a maki i muto na bakovi na ngatavine, a maki i muto na kanirau, a maki i muto na maki i karaka viliha, a maki ranga ri muto ri muma hateka, lakea i kani a bobona sipsip a bulmakau na nihabi na nivalemu ne BAKOVI DAGI, na tahuna i rata mavonga, ia tara ni gi tono tala na kabu vona.” ");
INSERT INTO bnp_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“O vakalongo e huriki a Israel o ta maea: Naha ni kani a vina bulmakau, a sipsip, a meme. ");
INSERT INTO bnp_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Naha ni kani a vina sipsip, a bulmakau i mate tavula, a vina sipsip, a bulmakau i rabalaki a kanirau hateka. Mu bole a vina mu rata a maki ranga vona. Pali naha ni kani. ");
INSERT INTO bnp_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","A bakovi i kani a vina kanirau, ra i kara ni gi habi ne BAKOVI DAGI manga a nihabi ni gutu na kanono, ni gi tono tala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","E LeviI uka ma ngi kunana. Naha ni kani a darana maki tara. I vai a tanga mu made vona, naha ni kani a darana kadirovo, a darana kanirau. ");
INSERT INTO bnp_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","A bakovi a ngatavine i longotaroa a vinara iea, ni gi tono tala na kabu vona.” A Kalavana Kinani ne Vona e Huriki a Prister ");
INSERT INTO bnp_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“O vakalongo e huriki a Israel o ta maea: A viri i ngaru ni habi a kanirau ge a nihabi na nivalemu, ge ru hereherea tara balena ge vona e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ra bakovi iea ge bole valai a vina turana siana, ge a nihabi ni gutu na kanono. A prister ge bolea a siana ge tabari e BAKOVI DAGI vona. ");
INSERT INTO bnp_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","A prister ge gutu a vina sipsip, a bulmakau na dede, pali a siana sipsip, a bulmakau ge ne vona e Aron, e huriki e tuna. ");
INSERT INTO bnp_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","A pona na kanena ri gi habia na prister, ge manga a sika vona na nihabi na nivalemu ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","E rei e tune Aron i rata a nihabi na nivalemu na darana, na vina kanirau, ge bole a pona na kanena kanirau iea. ");
INSERT INTO bnp_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Iau e BAKOVI DAGI a bole tala na nihabi na nivalemu ne huriki a Israel a siana, ra ni tabari iau vona, a pona sipsip, a bulmakau, a habi ne Aron a prister, turane huriki e tuna bakovi. E huriki a prister kunana ri gi bole vakaroro ne huriki a Israel a maka kalavana nihabi nga. ");
INSERT INTO bnp_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“Ra kalavana nihabi nga, ni bole valai ne BAKOVI DAGI, ge a nihabi ni gutu na kanono. E BAKOVI DAGI i pasivunu a kalavana nihabi nga ne vona e Aron turane huriki e tuna bakovi, na parava ni gamai ria ri gi leho manga a prister vona. ");
INSERT INTO bnp_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Na tahuna ni gamai ria, e BAKOVI DAGI i vakuku e huriki a Israel, ri gi habi ne huriki a prister ra kalavana nga. Ra vinara iea ri gi ramai vakaroroa muri ma. ");
INSERT INTO bnp_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","“Ra ngava nga, a vinara na nihabi gutu-vuro, a nihabi na vit, a nihabi na naro hale, a nihabi na rarenga, a nihabi na bakovi ni gamai ge ia a prister, a nihabi na nivalemu. ");
INSERT INTO bnp_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","E BAKOVI DAGI i habi ne Moses a vinara nga na lolo e Sinai, na tahuna e huriki a Israel ri made na tabeke i ngeki. Na parava e BAKOVI DAGI i vakuku e huriki a Israel ri gi habi a nihabi, i habi ne ria a vinara nga.” ");
INSERT INTO bnp_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“O tuli e Aron turane huriki e tuna bakovi. O bole a nirodo ola ola, a nibiri ne vona ni gamai, a bulmakau a toga ge a nihabi na naro hale, a sipsip a toga ge rua, a kulopi na bret i uka is. ");
INSERT INTO bnp_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Muri o gale palupu e huriki a bakovi a ngatavine ri gi valai na matana Kape na Vaponga.” ");
INSERT INTO bnp_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","E Moses i rata a maki e BAKOVI DAGI i vakuku ia vona, i gale palupu e huriki lobo, ri vapopo na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","E Moses i taki ria, “E BAKOVI DAGI i vakuku iau vona tara maki ga ratea ngane.” ");
INSERT INTO bnp_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","I gale e Aron turane tuna mai, ri valai ri pesi na matane huriki, i vahilolo ria na naru. ");
INSERT INTO bnp_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Muri i vakarodoa na nirodo e Aron, i bolea a kala i manga a palabele, i vakarea ia vona. Muri i vakarodoa e Aron na nirodo ola ola, i vakarea ia na kala dagi. I bolea a palabele ni vakabagetu, i kolo tatea a kala dagi ne Aron. ");
INSERT INTO bnp_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","I bolea a kala na ngala i koloa na ngalane Aron. I bole a kedo kiroko i rua ne vona ni bole a lohokanga na ningaru na Vure, i ru pololilo na kala na ngala. ");
INSERT INTO bnp_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","I bolea a hoi i ru halui a gine Aron vona. Muri i bolea a hulongi ni rata na gol, i topia na hini muga na hoi. Ra hulongi iea, i vakasiri e Aron ia a bakovi na Vure. E Moses i rata a maki nga, i ramai a ngava e BAKOVI DAGI i vakuku ia vona. ");
INSERT INTO bnp_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Muri e Moses i bolea a nibiri, i gamai a Mailo na Vure turana a maka maki i tabuli pololilo vona, ge ne vona e BAKOVI DAGI kunana. ");
INSERT INTO bnp_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","I bole tabua a nibiri i voro tamali langa na dede balaka polorua, i gamai a maka mahala ri tabuli vona, a tavila na hilova turana a dede kiroko vona. A maka maki nga ne vona e BAKOVI DAGI kunana. ");
INSERT INTO bnp_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","I bolea a nibiri i guru langea na gine Aron, i gamaia, ge vona e BAKOVI DAGI kunana. ");
INSERT INTO bnp_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Muri e Moses i tuli e huriki e tune Aron ri valai, i vakarodo ria na nirodo, i vakarea ria na palabele, i vakatama ria na tama, i ramaia a ngava e BAKOVI DAGI i vakukua vona. ");
INSERT INTO bnp_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Muri e Moses i bolea a bulmakau a toga, ge a nihabi na naro hale. Lakea e Aron turana e tuna mai ri ru langa a limane ria na gina. ");
INSERT INTO bnp_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Muri e Moses i rabalakia a bulmakau, i lutu a kukulimana na darana, i ravu na maka tupina dede na nihabi gutu-vuro. Na naro iea kunana i gamaia a dede i matapado na matana Vure. Muri i bole paru a darana i tababana, i guru na taruna dede, i gamaia, i kavitagua. ");
INSERT INTO bnp_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Lakea e Moses i bole a vina pololilo na mahalana, a kinake i kavitagu a hate, a vuanalipi i rua turana vina, i gutu-vuro na dede. ");
INSERT INTO bnp_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Pali i bole ranga balena bulmakau turana a kulina, a bobona, a tahena, i gutu-vuro polovavo na mada, i ramai a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Muri e Moses i bolea tara sipsip a toga ge a nihabi gutu-vuro. Lakea e Aron turane huriki e tuna ri ru langa a limane ria na gina. ");
INSERT INTO bnp_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Muri e Moses i rabalakia, i bole a darana, i voro tamali langa na tabekena dede i va. ");
INSERT INTO bnp_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","I pala kesikesia a sipsip, i gutu a gina, a vina, a balena. ");
INSERT INTO bnp_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","I vahilolo a maka mahalana, a vahana. I gutu loboa langa na dede. Ra sipsip iea a nihabi gutu-vuro ni rata na kanono, i manginoro a mangina. Ia a nihabi ni gutu na kanono ne BAKOVI DAGI, i ramaia a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Muri e Moses i bole tabua tara sipsip a toga, ne vona ni gamai a bakovi ge ia a prister. Lakea e Aron turane huriki e tuna ri ru langa a limane ria na gina sipsip. ");
INSERT INTO bnp_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Muri e Moses i rabalakia a sipsip iea, i bole ranga darana, i ravu na taruna talingana kanena ne Aron, na kukukoru na limana kanena, na kukukoru na vahana kanena. ");
INSERT INTO bnp_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Muri i tuli valai e huriki e tune Aron, i ravu a dara na taruna talingana kanene ria, na kukukoru na limana kanena ne ria, a vahana kanena ne ria. I bole paru a dara i tababana, i voro tamali lakea na tabekena dede i va. ");
INSERT INTO bnp_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Muri i bole a vina, a vina na kuna, a vina na mahalana, a kinake i kavitagu a hate, a vuanalipi i rua turana a vina, a pona kanena. ");
INSERT INTO bnp_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Muri e Moses i lakea na kulopi i vonu vona a bret i uka is, i tabuli na matane BAKOVI DAGI, i bole tala a bret i uka is, a bret ni gutu na namona oliv, a bisket i taku, i ru langa na vina, a pona kanena. ");
INSERT INTO bnp_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Lakea e Moses i ru a maki ni kani nga na limane Aron turane huriki e tuna, ri bole na limane ria, ri tabari e BAKOVI DAGI vona. ");
INSERT INTO bnp_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Muri e Moses i bole mule ne ria a maki ni kani, i gutu-vuro na dede turana a nihabi gutu-vuro ranga. Ra maki nga, a nihabi ni gamai e huriki a prister, i manginoro a mangina. Ia a nihabi ni gutu na kanono ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Muri e Moses i bolea a siana, i tabari e BAKOVI DAGI vona, manga a nihabi nitabari. Ra balena sipsip a toga iea, a sika ne Moses na nigamai e huriki a prister, i manga a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","E Moses i bole a merena nibiri na nigamai, turana a dara i tabuli na dede, i voro tamali langa ne Aron, ne huriki e tuna, na nirodo ne ria. Na naro iea kunana e Moses i gamai e Aron, e huriki e tuna, turana a maka nirodo ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Muri e Moses i taki e Aron turane huriki e tuna, i ta maea, “Mu nono a balena sipsip o a bulmakau iea na matana Kape na Vaponga. Mu kani kinika na maka bret ri tabuli na kulopi. Ra kulopi iea i tahoka a maka bret, a bisket ne vona a nihabi nigamai. Na naro iea bara mu ramai a ngava a vakuku e Moses vona, a ta maea, ‘E Aron, e huriki e tuna ri gi kani.’ ");
INSERT INTO bnp_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Na tahuna mu kani mu maru, a maka kalavana maki ni kani mu gutu-vuro na kanono. ");
INSERT INTO bnp_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Muri mu pagitala na matana Kape na Vaponga, mu made vonga na parava ge polorua, ge harena na tahuna ge lobo a parava ge polorua na Habu na Nigamai. ");
INSERT INTO bnp_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","E BAKOVI DAGI i taki hita si gi rata a maki i manga a hini si rata mona, bara i kavitagu mua. ");
INSERT INTO bnp_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","I taki iau pali, ta mu gu made na matana kape na haro, na rodo, ge harena na parava i polorua mu gu rata a maki i taki. Bara mu longotaro a ngavana, bara mu mate, a vuhuna ra ngava iea e BAKOVI DAGI i vakuku iau vona.” ");
INSERT INTO bnp_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","E Aron turane huriki e tuna, ri ramai kunana a ngava lobo e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Na polotoluna parava, e Moses i gale palupu e Aron turana e huriki e tuna bakovi, e huriki a gare ne Israel. ");
INSERT INTO bnp_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Lakea i takia e Aron i ta maea, “O bolea tara bulmakau karaba a toga, a sipsip a toga ru gavutuvutu, o habi ne BAKOVI DAGI. A bulmakau ge a nihabi na naro hale, a sipsip ge a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","O taki e huriki a Israel ri gi bolea tara meme a toga, ge a nihabi na naro hale, a tuna bulmakau, a tuna sipsip, ru pida takutaku, ru gavutuvutu, ge a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Muri e huriki ri gi habi a bulmakau, a sipsip a toga, ge a nihabi na nivalemu. A nihabi na vit ni vuli turana namona oliv, ia tara ni gi habi ne BAKOVI DAGI. Ri gi rata a maki nga, a vuhuna mona e BAKOVI DAGI ge bele, ri gi masia na matane ria. ");
INSERT INTO bnp_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","E huriki ri bole valai na matana Kape na Vaponga a maka maki e Moses i vakuku ria vona ri gi bole. Muri e huriki lobo ri valai tabukoi ri pesi na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Lakea e Moses i taki ria, i ta maea, “E BAKOVI DAGI i taki mua mu gu ratea a nihabi, muri bara mu masia a bagetua vona.” ");
INSERT INTO bnp_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Muri e Moses i takia e Aron i ta maea, “O valai na dede o ratea a nihabi na naro hale vomu, a nihabi gutu-vuro vomu. O rata a nihabi ge rua, ne vona ni kavitagu ioe, ne vona ni kavitagu e huriki, i ramaia a ngava e BAKOVI DAGI i vakuku.” ");
INSERT INTO bnp_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Lakea e Aron i valai na dede i rabalakia a bulmakau karaba, ra nihabi na naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Muri e huriki e tuna, ri bole valai vona a dara, lakea i lutua a kukulimana na dara, i ravu na tupi i va na dede. Muri i guru tala paru na taruna dede a dara i tababana. ");
INSERT INTO bnp_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Pali i gutu-vuro na dede a vina, a vuanalipi, a kinake i kavitagu a hate, i ramai a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Pali a bobona, a kulina bulmakau i bole tala, i gutu-vuro polovavo na mada. ");
INSERT INTO bnp_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Muri e Aron i vakalobo a leho nga, i rabalakia tara kanirau ge a nihabi gutu-vuro. E huriki e tuna ri bole a dara ri habi vona, i voro tamali langa na gagana dede i va. ");
INSERT INTO bnp_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ri habi vona a mapana, a maka balena kanirau, i gutu-vuro langa na dede. ");
INSERT INTO bnp_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Muri i loi a maka mahalana, a vahana i rua, i gutu langa na dede turana nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Muri e Aron i bole a nihabi ne huriki, i rabalakia a meme, i habia, ge a nihabi na naro hale ne huriki, i manga a nihabi muga. ");
INSERT INTO bnp_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","I bole valai tabu a nihabi gutu-vuro, i habia, i ramaia a nita na vinara. ");
INSERT INTO bnp_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","I bole valai tabu a nihabi na vit, i ragamu tala ranga, i gutu-vuro na dede. I gutu turana a nihabi gutu-vuro ni rata na hatelanga. ");
INSERT INTO bnp_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Muri e Aron i rabalaki a bulmakau a sipsip a toga, ge a nihabi na nivalemu ne huriki. Lakea e huriki e tuna ri bole a darana sipsip, a bulmakau, ri habi vona, i voro tamali na gagana dede i va. ");
INSERT INTO bnp_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Pali e Aron i bole a vina sipsip, a bulmakau nga: a vina kuna, a vuanalipi, a kinake i kavitagu a hate. ");
INSERT INTO bnp_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","I bole a vina i ru langa na siana sipsip, a bulmakau nga, i gutu-vuro na dede. ");
INSERT INTO bnp_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Pali a siana, a pona bulmakau a sipsip, e Aron i tabari e BAKOVI DAGI vona, i manga a nihabi na nitabari, i ramai a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Na tahuna e Aron i habi lobo a nihabi na naro hale, a nihabi gutu-vuro, a nihabi na nivalemu, i toto langa a limana ne huriki, i gamai ria. Muri i pea a dede i puru. ");
INSERT INTO bnp_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Muri e Moses e Aron ru dili na Kape na Vaponga. Na tahuna ru pagitala ru gamai e huriki. Muri ri masia a bagetua ne BAKOVI DAGI i bele kavakava. ");
INSERT INTO bnp_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Malaviriri kunana a kanono i pagitala valai ne BAKOVI DAGI, i vakalobo liu a maka nihabi gutu-vuro, turana a balena vina kanirau. Na tahuna e huriki ri masia a naro iea i bele, ri haloho, ri tabuli bararapuru na malala. ");
INSERT INTO bnp_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Na tahuna iea e tune Aron ala rua, e Nadap, e Abihu, ru pi a kanono, ru ru dili na ulo kiroko ni rata na aen, ru guru puru a havu mangisipa na ulo, ru habi a kanono i uka ma ni taba ne BAKOVI DAGI. Pali e BAKOVI DAGI i uka ma i taki rua ru gu rata mavonga. ");
INSERT INTO bnp_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Lakea i malaviriri kunana e BAKOVI DAGI i rudua a kanono i puru valai i gutu parina rua ru mate na matana. ");
INSERT INTO bnp_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Muri e Moses i takia e Aron, “E BAKOVI DAGI i ta maea: ‘E huriki ri leho nau, ri gi lohoka kamumu vona iau a kiripiripi. Na matane huriki lobo, bara vakasiri ria vona a nitora dagi, a bagetua nau.’” E Aron i longoa a nita iea, i uka ngavana. ");
INSERT INTO bnp_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Muri e Moses i gale e Misael, e Elsapan, e tune Usiel, e tamane Aron kiroko, ru valai vona. Lakea i taki rua i ta maea, “Muru valai, muru kaloho tala a podane turane marua na mailo na Vure, muru bole tala na mada.” ");
INSERT INTO bnp_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ru vano ru kaloho tala na mada a podane rua, i manga a ngava e Moses i vakuku. Pali uka ma ru kali tala a nirodo na bakovi nga ru mate. ");
INSERT INTO bnp_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ngane e Moses i habi a ngava tabu ne Aron turana e tuna ala rua, e Eleasar, e Itamar. I taki tou i ta maea, “Nahea ge patoka a vune matou, naha ni rape a varakia matou, ma ga moto rata mavonga bara moto mate, a rongova ne BAKOVI DAGI bara i bele ne huriki. Pali e huriki a viri ne mua a Israel, ria ri gi kalo vona ra bakovi nga e BAKOVI DAGI i rabalaki rua na kanono. ");
INSERT INTO bnp_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Naha ni pe taroa a Kape na Vaponga, ma moto go mate. A gamai matou pali, matou a vora ne BAKOVI DAGI kunana.” I mavonga, to longoa a nitane Moses, to ramaia. ");
INSERT INTO bnp_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","E BAKOVI DAGI i takia e Aron i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Na tahuna ioe turana e tumu ala rua moto dili na Kape na Vaponga, naha ni ninu a vain a naru vagole, ma moto go mate. Ra vinara iea, ge ramai vakaroroa e huriki a hamone matou. ");
INSERT INTO bnp_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Moto tovo matou ni matakilaka vona a maki ni taba, a maki i uka ma ni taba, a maki i kaba, a maki i muto. ");
INSERT INTO bnp_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Bara moto tovo e huriki a Israel na maka vinara e BAKOVI DAGI i vakuku e Moses vona.” ");
INSERT INTO bnp_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","E Moses i taki e Aron turana e tuna ala rua ru tababana ni mahuri, e Eleasar, e Itamar, i ta maea, “Moto bole a vit i tababana na nihabi ni gutu na kanono ne BAKOVI DAGI, moto rata a bret i uka is, moto kani tabukoi na dede, a vuhuna a bret iea ni taba. ");
INSERT INTO bnp_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Moto kani na hini ni taba pololilo na nure na Kape na Vaponga. A naguna vit ni gutu kaleva ra ni habi ne BAKOVI DAGI, moto bole ge ne matou, ne vona e tune matou bakovi, moto bole tala na nihabi ni gutu na kanono ne BAKOVI DAGI, i ramaia a ngava ni vakuku iau vona. ");
INSERT INTO bnp_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Pali matou turana e huriki e tune matou bakovi, e tune matou ngatavine, mu bolea na nihabi na nivalemu ne huriki a Israel a siana ni tabari, a pona a sipsip, a bulmakau. A tabeke tara i matapado na matana Vure, moto vano moto kani vonga. ");
INSERT INTO bnp_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","E huriki a bakovi, a ngatavine ri gi habi a vahana, a siana bulmakau, a sipsip turana a vina, moto bole moto tabari e BAKOVI DAGI vona. Muri moto gutu-vuro na dede a vina, pali moto bole a pona, a siana, moto kani. Ra pona, a siana sipsip, a bulmakau bara ne matou kunana vakaroro, turana e huriki e tune matou, i manga a ngava e BAKOVI DAGI i vakuku.” ");
INSERT INTO bnp_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Na tahuna e Moses i nana kado tou na a ra maki to ratea vona a meme na nihabi na naro hale, to takia ta to gutua pali na kanono! Lakea e Moses i tahate e Eleasar e Itmar, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“I navai i uka ma moto kani a nihabi na naro hale pololilo na kape? Ra nihabi iea ni taba hateka. Ni habi ne matou, moto go kube a rarenga ne huriki, moto go kavitagu ria na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Matou i uka ma moto bole a darana nihabi ge dili na Tabeke Nitaba, pali i navai i uka ma moto kani pololiloa vonga, ge ramaia a ngava iau a vakuku mua vona?” ");
INSERT INTO bnp_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Lakea e Aron i takia e Moses, “O longo, mona e huriki ri habi a nihabi na naro hale ne ria, a nihabi gutu-vuro. Pali ge a ra, a maki hale i bele nau pali. I mavonga, na tahuna ga kani a nihabi na naro hale mona, e BAKOVI DAGI ge ngarua a narogu?” ");
INSERT INTO bnp_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Na tahuna e Moses i longoa a ngavane Aron, i kamumu a lohona. ");
INSERT INTO bnp_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","E BAKOVI DAGI i taki e Moses e Aron, ");
INSERT INTO bnp_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","ru gu taki e huriki a Israel ru gu ta maea, “A maki mahuri ri laho na malala, mu gu kani, ra nga: ");
INSERT INTO bnp_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","a sipsip, a bulmakau a tagulana vahana ria i bako, ri ngau a varili manga a bulmakau. ");
INSERT INTO bnp_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“Pali naha ni kani a kanirau manga a kamel, a gola, a murongi talinga ola, a vuhuna ri ngau a varili manga a bulmakau, pali i uka ma i bako a tagulana vahane ria. Ri muto ni kani. ");
INSERT INTO bnp_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Naha ni kani a boro, a vuhuna a tagulana vahana i bako, pali i uka ma i ngau a varili. I muto ni kani. ");
INSERT INTO bnp_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Naha ni kani ra maka kania nga, naha ni nugu na tahuna ri mate, a vuhuna ri muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“A maki na naru, na dari bara mu kani, ra nga: a maka manu ri tahoka a honane ria a pelengane ria. ");
INSERT INTO bnp_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Pali a kabuna maki mahuri na naru, na dari, i uka honane ria, i uka pelengane ria, naha ni kani. Mu pile. ");
INSERT INTO bnp_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","A maka maki nga mu pile, lakea naha ni kani ria, naha ni nugu ria na tahuna ri mate. ");
INSERT INTO bnp_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Mu longo kamumu, naha ni kani a manu i uka pelengane ria, a honane ria. Mu pile. ");
INSERT INTO bnp_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Naha ni kani a kadirovo nga, a vuhuna ri muto. Mu pile: a loha, a kinikinimanu, pangopango-kaba, ");
INSERT INTO bnp_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","a luama vokuvoku, a luama katokato, a maka luama viliha, ");
INSERT INTO bnp_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","a maka kokoa viliha, ");
INSERT INTO bnp_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","a kadirovo i manga a mengo, a haloho, a nae, a maka loha viliha, ");
INSERT INTO bnp_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","a kuku kiroko, a kadirovo i manga a pato ni gale a komaran, a kuku dagi, ");
INSERT INTO bnp_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","a maka kuku viliha, a kadirovo i manga a kongo, ");
INSERT INTO bnp_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","a kadirovo ni gale a stork, a maka luhou viliha, a kadirovo ni gale a hupoe, a kopa. ");
INSERT INTO bnp_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Naha ni kani a maki ri tahoka a karapane ria, ri laho na vahane ria i va. Mu pile. ");
INSERT INTO bnp_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Pali mu kani a maki ri tahoka a karapane ria, ri laho na vahane ria i va, ri page viliha na malala. ");
INSERT INTO bnp_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","I mavonga mu kani a maka koa lobo. ");
INSERT INTO bnp_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Pali a maki ri tahoka a karapane ria, ri tahoka a vahane ria i va, mu pile. ");
INSERT INTO bnp_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Naha ni padoi a maki nga. A viri i padoia tara maki i mate, bara i muto i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","A viri i bole rikea tara maki i mate, ra bakovi iea i muto, ge loi pasi a varakia vona, pali bara i muto mavonga i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“A maka kanirau a tagulana vahane ria i uka ma i bako hateka, o i uka ma ri ngau a varili, ri muto. A viri i padoi a kanirau nga, bara i muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","A maka kanirau ri laho na vahane ria i va, i kabelabela a vahane ria, ri muto. Naha ni padoia tara ge mate. A viri i padoi a podana kanirau i mate, bara i muto mavonga i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","A bakovi i bole rikea a kanirau i mate, ge vahiloloa a varakia vona, pali ia bara i muto mavonga i harena na malunga liu, a vuhuna ra maki nga ri muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","“Na maka kanirau ri laho lae na malala ri muto: a murongi, a kuruve, a kapore, a karapoda-dole, a tabelebako, a miho. ");
INSERT INTO bnp_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ra maki nga ri laho viliha na malala, ri muto. Naha ni padoi na tahuna ri mate. Mua bara mu rata mavonga, bara mu muto i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Na tahuna a maki nga ri mate ri boru langa na maki tara, ra maki iea i muto. A podana ge boru langa na maki ni rata na kai, na kala, na kulina bulmakau, na beke, ra maki lobo nga ri muto. Mu bole mu loi na naru, pali bara ri muto mavonga i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Bara maki tara i mate i boru dili na ulo, a maka maki i tabuli pololilo ri muto. Mu bolea a ulo mu ubipodea. ");
INSERT INTO bnp_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","A maki ni kani i tabuli pololilo vona, i muto. A naru i tabuli pololilo vona, ia tara i muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Bara podana maki mate i boru langa na stov, na oven ni rata na taka, ra maki nga ru muto, mu ubipoda. ");
INSERT INTO bnp_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Pali bara a maki mate i boru langa na naru i tua, o na lomu, a naru i uka ma ge muto. Pali a maki i padoi a maki nga i mate, bara i muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","A maki i mate i boru langa na vutuna maki ni varo, a vutuna maki i kamumu kunana, i uka ma ri muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Pali a vutuna maki i tabuli na naru, lakea a maki i mate i boru langa ne ria, ra vutuna maki nga ri muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“A kanirau tara ra i kara ni gi kani, i mate, a viri i padoia bara i muto i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","A viri i kania a balena kanirau iea o i nugua, ge vahilolo a maka varakia vona. Pali ia bara i muto mavonga i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","“Naha ni kani a maki kiroko ri karaka o ri laho tabukoi viliha na malala, a maki i kupo a vahana. ");
INSERT INTO bnp_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Naha ni kani a maki nga. Bara mu kani, mu muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Iau e BAKOVI DAGI, a Vure ne mua. Mu habi mua nau, bara mu kiripiripi, a vuhuna iau a kiripiripi. Naha ni kani a maka kuruve, a maki kiroko ranga ri karaka viliha na malala, ma mu gu muto. ");
INSERT INTO bnp_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Iau e BAKOVI DAGI, a bole tala mua o Egipto a taparaki valai mua koea, ge iau a Vure ne mua. Mu ramai a naro ge kiripiripi, a vuhuna iau a kiripiripi. ");
INSERT INTO bnp_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Mu bolea pali ra vinara iea. I taki a maka kanirau, a maka kadirovo, a maka manu, a maka maki kiroko ri karaka ri laho na malala. ");
INSERT INTO bnp_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Mu pelekado kamumu a maki matapado, a maki muto, a maki mahuri mu gu kani, a maki mahuri i uka ma mu gu kani.” ");
INSERT INTO bnp_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“O taki e huriki a Israel, na tahuna a ngatavine i singou, i poda a koma bakovi, a ngatavine bara i muto na parava i polorua, i manga a hini i matai a keva. ");
INSERT INTO bnp_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Na polotoluna parava ni gi pala a kulina koma bakovi. ");
INSERT INTO bnp_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Muri a ngatavine ge made tabu na ruma na parava ge ravulu tolu a polona i tolu (33), a vuhuna a darana i tua tala na tahuna i poda a koma. Nahea ge nugua tara maki ni gamai, o ge lakea na mailo na Vure, a vuhuna i muto. Ra ngatavine iea bara i muto mavonga ge harena na tahuna ni vakamatapado. ");
INSERT INTO bnp_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Pali na tahuna a ngatavine ge poda a koma ngatavine, a ngatavine bara i muto na parava i ravulu a polona i va, i manga na tahuna i matai a keva. A ngatavine ge made tabu na ruma na parava ge ravulu polotara a polona i polotara (66), muri ge matapado, a vuhuna a darana i tua tala na tahuna i poda a koma vona. ");
INSERT INTO bnp_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Na tahuna a maka parava ni vaka­matapado i lobo, a ngatavine ge habi na prister na matana Kape na Vaponga tara tuna sipsip, a pida vona i taku, ge a nihabi ni gutu-vuro. Ge habi tabua a balu, ge a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","A prister ge bole a sipsip, a balu na ngatavine, ge habi ne BAKOVI DAGI, ge kavitagua a ngatavine. Ngane bara i matapado, a darana i uka ma ge rata tabu ia ge muto. A ngatavine i poda a koma bakovi o a koma ngatavine, ge ramaia a vinara iea. ");
INSERT INTO bnp_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Pali a ngatavine iea ge uka a moni ni kona a tuna sipsip, ge bole valai a balu ge rua. A balu tara ne vona a nihabi gutu-vuro. A balu tara ne vona a nihabi na naro hale. A prister ge habi ne BAKOVI DAGI a balu nga i rua, ge kavitagua a ngatavine. Muri a ngatavine bara i matapado na matane BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","E BAKOVI DAGI i taki e Moses e Aron i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Na tahuna a viri i tahoka a ngarava, a loto, a maki tara i kavuvu i vururu na kulina, lakea i vakabele a patala, a bakovi ni gi tuli lakea ne Aron a prister, o ge lakea ne tuna tara a prister. ");
INSERT INTO bnp_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","A prister ge lei kamumua a hini i hale na kulina. Na tahuna i matai a vungana na kulina i kea, a gilanga i dupi dili na kulina, ra gilanga iea a patala. Muri na prister i lei loboa, ge vakalongoa i muto. ");
INSERT INTO bnp_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Pali a hini hale na kulina i uka ma i kea a vungana ge dupi, ge tonoa ge hamule na ruma vona, ge made kikeri tabu na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Na poloruana parava a prister ge lei tabua. Pali a prister ge masia i uka ma i mavu i rako lae na kulina a gilanga, ge takia a bakovi ge made kikeri tabu na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Na poloruana parava a prister ge matai tabua, a gilanga na kulina i lobo o i uka. A gilanga ge lobo, a prister ge takia i matapado, ra gilanga iea a gilanga tavula. Muri a bakovi ge vahilolo a maka varakia vona, ge matapado ia. ");
INSERT INTO bnp_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pali muri na parava i vakasiri ia na prister, a gilanga na kulina i bele tabu, a bakovi iea ge vano ge matai tabua a prister. ");
INSERT INTO bnp_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","A prister ge lei kamumu tabua a gilanga na kulina. A gilanga ge rako lae na kulina, ra bakovi iea i tahoka a patala. A prister ge vakalongoa i muto. ");
INSERT INTO bnp_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“A viri i tahoka a patala ni gi tuli lakea na prister. ");
INSERT INTO bnp_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","A prister ge lei kamumua a kulina, ge masia a kulina i vaki, i kea, i ratea a vungana i kea, i mapoka a hini i vaki, ");
INSERT INTO bnp_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ra bakovi iea i tahoka a patala. A prister ge vakalongoa a bakovi iea i muto. Ngane a prister i lohoka vona, ra bakovi iea i muto, pali nahea ge tonoa ge made kikeri. ");
INSERT INTO bnp_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Na tahuna a prister i masia a patala i rako lae na kulina viri, i tubu na gina i puru na vahana, ");
INSERT INTO bnp_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","a prister ge lei kamumu tabua a kulina. Ia ge masia a gilanga i rako lobo na kulina, i ratea a kulina i kea, a kulina ge kea lobo, ra bakovi iea i matapado, a vuhuna a kulina i kea lobo pali. ");
INSERT INTO bnp_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Pali na tahuna a patala i mapoka, i tabuli kavakava a bobona, ra bakovi iea i muto. ");
INSERT INTO bnp_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","A prister ge lei tabua a patala, ge masia i mapoka, i tabuli kavakava a bobona, ra bakovi iea i muto. Ra gilanga maea i hale hateka. ");
INSERT INTO bnp_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Pali na tahuna a gilanga i lobo, i keke a murina, ra bakovi iea ge hamule lakea tabu na prister. ");
INSERT INTO bnp_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","A prister ge lei kamumua a kulina a bakovi iea, bara i masia i lobo, i keke a murina a patala, ra bakovi iea i matapado. Muri ge vakalongoa i matapado pali. ");
INSERT INTO bnp_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“A viri tara ge tahoka a loto na kulina, a loto vona i mavu, ");
INSERT INTO bnp_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","muri a murina loto i keke, i vaki tala, i vururu, ra bakovi iea ge lakea na prister. ");
INSERT INTO bnp_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","A prister ge lei kamumua a murina loto na bakovi. Na tahuna i mata visi a vungana na tabeke i vaki i kea, a ngarava vona i ngara i dupi, a prister ge takia a bakovi iea i muto. I tahoka a patala. ");
INSERT INTO bnp_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pali na tahuna a prister iea i lei kamumu a loto, i masia i uka ma i ngara, i uka ma i kea a vungana, ge tonoa ge made kikeri na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Muri na parava ge polorua ge lobo, a loto ge vaki dagi, ra loto iea a maki hale, lakea a prister ge takia a bakovi i muto. ");
INSERT INTO bnp_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pali bara a loto iea i tabuli na hini i taku kunana, i uka ma i rako ge tuvu lakea na hini ranga, ra loto iea a vuruna loto muga, a prister ge takia a bakovi iea i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Na tahuna a viri i gutua a kanono a kulina, i lele a bobona, i vururu keakea o i keakea, ");
INSERT INTO bnp_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","a prister ge lei kamumua a ngarava vona, ge masia a vungana ge kea na hini i gutua a kanono, i ngara i dupi, ra gilanga iea a patala. A hini i gutua a kanono i vakabelea a patala. A prister ge takia i muto. ");
INSERT INTO bnp_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pali na tahuna a prister i lei a kulina, i uka ma i matai a vungana ge kea na hini i gutua a kanono, i uka ma i ngara, a prister ge takia a bakovi ge made kikeri na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Na poloruana parava a prister ge lei kamumu tabua a bakovi. A gilanga vona ge rako lae, a prister ge takia i muto. I tahoka a patala. ");
INSERT INTO bnp_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pali a ngarava i uka ma i ngara, a harena kanono i kamumu kunana, a prister ge vakalongoa a bakovi iea i matapado, a vuhuna a ngarava vona a murina hini i gutua a kanono. ");
INSERT INTO bnp_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Na tahuna a bakovi, a ngatavine i vona a vuruputuka a gina, o i pero a sivana, ");
INSERT INTO bnp_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","a prister ge lei kamumua. A prister ge masia a vuruputuka, a pero ge dupi dili na kulina, a vungana ge ngango ngango, i makudu lae a vuna, ngane a prister ge vakalongoa i muto. A gilanga vona, a patala, i makali. ");
INSERT INTO bnp_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Na tahuna a prister i lei kamumua a vuruputuka a pero na bakovi, i matai i uka ma i dupi dili, a vuna i uka ma i koru rike ma, ge takia a bakovi ge made kikeri taro na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Na poloruana parava, a prister ge lei tabua a kulina bakovi iea. A vuruputuka a pero i uka ma i tuvu lakea na hini ranga, i uka ma i ngango a vungana, i uka ma i dupi dili, ");
INSERT INTO bnp_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","a bakovi iea ge ali a vuna na gina, a sivana, pali nahea ge ali a hini i tuvu vona a vuruputuka a pero. Muri a prister ge takia ge made kikeri na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Na poloruana parava, a prister ge lei tabua a vuruputuka a pero na bakovi iea. A vuruputuka a pero i uka ma i ngara, ge takia a bakovi iea i matapado. Muri ge loi a maka kala vona bara i matapado ia. ");
INSERT INTO bnp_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pali a vuruputuka a pero ge rako lae muri na tahuna a prister i takia i matapado, ");
INSERT INTO bnp_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","a prister ge lei tabua a kulina, i masia i rako lae na kulina a gilanga, nahea ge matakana a vuna i ngango, a vuhuna a bakovi iea i muto. ");
INSERT INTO bnp_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pali a prister i lei kamumua a bakovi, i matai a vuruputuka a pero i uka ma i ngara, i tuvu mule a ivu, a prister ge takia a bakovi iea i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Na tahuna a bakovi, a ngatavine tara i tahoka a maki i keke lae na kulina, ");
INSERT INTO bnp_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","a prister ge lei kamumua a hini keke. I uka ma i kea hateka, a maki tavula. A bakovi iea i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Na tahuna a vuna bakovi i makudu tala na gina i lete, ra bakovi iea i mata­pado. ");
INSERT INTO bnp_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","A vuna bakovi i makudu na hini polomeli na dumena, i lete, ra bakovi iea i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pali bara a ngarava tara ge bele na lete vona i vururu i kea, ra gilanga iea a patala. ");
INSERT INTO bnp_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Muri a prister ge lei kamumua a ngarava iea, ge vururu ge vona kume, ra ngarava iea i mata manga a patala. ");
INSERT INTO bnp_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Ra gilanga i tabuli na gina i hale hateka, a patala. A prister ge takia a bakovi iea i muto. ");
INSERT INTO bnp_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“A viri i tahoka tara ngarava hale maea ra patala, ge rea na matutuna varakia, nahea ge pelengea a vuna. Ge kavitagua a ngavana na limana, ge gale maea, ‘Iau a muto! Iau a muto!’ ");
INSERT INTO bnp_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","A bakovi i tahoka a gilanga maea, i muto. Ge pagitala na mada, ge made kikeri polovavo. ");
INSERT INTO bnp_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","“Na parava ranga a limuta i tuvu na maka varakia ni rata na vuna sipsip, na kala, na kulina bulmakau. ");
INSERT INTO bnp_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Ra maki iea ge goma o ge vururu, bara i rako lae, ni gi bole ni gi vakasiri na prister. ");
INSERT INTO bnp_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","A prister ge bolea ge lei kamumua, ge ru herehere na tabeke tara, ge harena na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Na poloruana parava ge lei kamumu tabua. A limuta ge tuvu lobo vona, bara i ratapilea. A maki i tuvu vona i muto. ");
INSERT INTO bnp_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","A prister ge bole a maki nga ge rungani na kanono, a vuhuna a maki i manga a patala i bele ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Bara prister ge masia a maki iea i maea kunana, i uka ma i tuvu tala tabu na maka varakia, ");
INSERT INTO bnp_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ge taki ria ri gi loi a maka varakia, ri gi ru here na parava ge polorua tabu. ");
INSERT INTO bnp_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Muri a prister ge lei tabu a maka varakia, muri na tahuna ni loi, ge matai a limuta i tababana vonga o i uka. Na tahuna i matai i tababana vonga, pali i uka ma i vulala tala, ge vakalongo ra maka varakia ri muto. Mu gu rungani na kanono. A limuta ge tabuli na ngalana, o na bitona, mu rungania. ");
INSERT INTO bnp_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“Pali a prister ge lei kamumu tabu a maka varakia ni loi, ge masia a maki i manga a limuta i lobo o i uka. Bara i lobo, ge rape tala a hini i madoko vona a limuta ge vuroki. ");
INSERT INTO bnp_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Muri a limuta ge bele tabu na varakia, na maki ni rata na kulina bulmakau, a tahona a maki nga ge bole ge rungani na kanono. ");
INSERT INTO bnp_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Pali na tahuna i loi a maka kala o a maki ni rata na kulina bulmakau, i malavuroki a limuta, ge vahilolo tabu, bara ri matapado.” ");
INSERT INTO bnp_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ra ngava iea a vinara na maki i manga a patala i vakahale a maki ri muto: ra nirodo, a kala ni rata na hotu kamumu, a vuna sipsip, a maka maki ni rata na vuna bulmakau. Ra vinara iea i taki a maki i matapado, a maki i muto. ");
INSERT INTO bnp_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ra ngava iea a vinara na viri i tahoka a patala. Na tahuna a gilanga vona i lobo, i ngaru ni matapado, ni gi tuli lakea na prister. ");
INSERT INTO bnp_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","A prister ge tuli talea na mada, ge lei kamumua a gilanga vona. A gilanga na patala vona i lobo muholi, ");
INSERT INTO bnp_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","a prister bara i vakuku ria, ri bole polo vona a kadirovo mahuri kaba­kaba ge rua, a mavilana a kai a sida, a mota vururu, a rahana kai a hisop. ");
INSERT INTO bnp_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","A prister ge vakuku ria ri gi bolea tara ulo, ri gi kiru a naru, ri gi bole vilia. Muri ri gi bole langea na ulo tara kadirovo mahuri, ri gi rabalakia, ge sisi puru na ulo a darana. ");
INSERT INTO bnp_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","A prister ge bole tabua tara kadirovo mahuri, a mavilana kai a sida, a mota vururu, a rahana kai a hisop, ge lutu na naru i tahoka a dara. ");
INSERT INTO bnp_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Muri ge voro tamali balaka polorua langa na bakovi i vona a patala a dara. A prister ge vakalongoa i matapado pali, muri ge bole talea a kadirovo mahuri ge vakabebea. ");
INSERT INTO bnp_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“A bakovi i ngaru ni matapado, ge vahilolo a varakia vona, ge ali vuroki a vuna na kakaina, ge hilolo ge matapado. Muri bara i dili valai na mada, pali bara i made polovavo taro na kape vona na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Na poloruana parava ge ali vuroki lobo a maka vuna na kakaina, a vungana na matana, a karirana. Ge hilolo, ge loi a maka kala vona, muri bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Na polotoluna parava ge bole a tuna sipsip a toga ge rua ge gavutuvutu, a sipsip a kinana ge gavutuvutu a pida vona ge taku, a kilo na plaoa kamumu ge tolu ni vuli turana namona oliv ge a nihabi na vit. Ge bole turana a kikei na namona oliv. ");
INSERT INTO bnp_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","A prister ge tulia a bakovi iea turana a maka nihabi vona, ge lakea na matana Kape na Vaponga na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“A prister ge bolea tara sipsip turana a kikei na namona oliv, ge a nihabi na rarenga. Muri ge tabari e BAKOVI DAGI vona, ge manga a nihabi. ");
INSERT INTO bnp_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Muri a prister ge rabalakia a tuna sipsip na tabeke ni rabalaki a sipsip, a bulmakau na nihabi na naro hale, na nihabi gutu-vuro. A prister ge rata mavonga, a vuhuna ra nihabi iea a nihabi na rarenga, i manga kunana a nihabi na naro hale. Ra nihabi nga ni gamai hateka ne vona e huriki a prister kunana. ");
INSERT INTO bnp_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","A prister ge bole ranga darana sipsip ge ravu polotano na talingana kanena bakovi. Ge bole tabu ranga ge ravu na kukukoru na limana a vahana a kanena. ");
INSERT INTO bnp_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Muri a prister ge bole a namona oliv ge guru langa na bolana limana a maurina. ");
INSERT INTO bnp_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Muri ge lutua na namona oliv iea a kukulimana a kanena, ge voro tamali balaka polorua na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","I ranga namona oliv i tababana ni gi ravu na talingana kanena bakovi ra ni vakamatapado, na kukukoru na limana kanena, na kukukoru na vahana kanena, polomeli na dara na nihabi na rarenga. ");
INSERT INTO bnp_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","A namona oliv i tababana na limana, a prister ge ravu na gina bakovi ta ni gi vakamatapado, ge kavitagua na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Muri a prister ge habi a nihabi na naro hale, ge kavitagua a bakovi ge matapado. Muri ge rabalakia a tuna sipsip ne vona a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Muri ge habia a sipsip, a bulmakau iea na dede, turana a nihabi na vit, ge kavitagua a bakovi iea, ge matapado. ");
INSERT INTO bnp_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Pali a bakovi i uka moni ni kona a maki ge a nihabi ni vakamatapado mule ia, ge bolea tara tuna sipsip a toga, ge a nihabi na rarenga. Muri a prister ge bolea, ge tabari rike e BAKOVI DAGI vona, ne vona ni kavitagua a bakovi iea. A bakovi ge bolea a kilo na plaoa kamumu ge taku, ge vuli turana a namona oliv, ge rata a nihabi na vit. Ge bole turana a kikei na namona oliv ge rua. ");
INSERT INTO bnp_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ge bole valai a balu ge rua, a vuhuna i uka moni ni kona a sipsip. A balu muga, ge a nihabi na naro hale, a balu muri ge a nihabi ni gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Na polotoluna parava, ge bole lakea na prister na matana Kape na Vaponga a balu nga, na matane BAKOVI DAGI, ne vona ni vakamatapado ia. ");
INSERT INTO bnp_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","A prister ge bolea a tuna sipsip ne vona a nihabi na rarenga, turana a namona oliv, ge tabari e BAKOVI DAGI vona. ");
INSERT INTO bnp_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","A prister ge rabalakia a tuna sipsip iea, ge ratea a nihabi na rarenga. Ge bole a dara popote na sipsip, ge ravu na talingana bakovi, ra talingana a kanena. Ge bole ranga, ge ru tabu na kukukoru na limana a kanena, na vahana a kanena. ");
INSERT INTO bnp_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","A prister ge bole a namona oliv ge guru langa na bolana limana a maurina, ");
INSERT INTO bnp_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ge lutua a kukulimana a kanena na naruna oliv iea, ge voro tamali balaka polorua na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Muri a prister ge ravu a namona oliv na talingana a kanena bakovi, na kukukoru na limana a kanena, na kukukoru na vahana a kanena. A naro iea ge ratea na tabeke ni ru a darana sipsip na nihabi na rarenga. ");
INSERT INTO bnp_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","A namona oliv ranga i tababana, ge ravu na gina bakovi i ngaru ia ge matapado. Na naro iea, a prister i rata a nihabi ne vona ni kavitagu a bakovi iea na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","A prister ge bole a balu nga i rua i bole valai a bakovi ge a nihabi, ");
INSERT INTO bnp_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ge habia tara ge a nihabi na naro hale. A viri tara ge a nihabi gutu-vuro, turana a nihabi na vit. Na naro iea, a prister i kavitagua a bakovi iea na matane BAKOVI DAGI, ra i ngaru ni matapado. ");
INSERT INTO bnp_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ra vinara iea a vinara na viri i tahoka a patala, pali i uka moni ni kona a nihabi na nivakamatapado.” ");
INSERT INTO bnp_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","E BAKOVI DAGI i taki e Moses e Aron, ");
INSERT INTO bnp_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Muri bara mu vano mu made na malala e Kenan, ra malala a habia ne mua, ge ne mua liu. Na tahuna mu made pali o Kenan, ga ratea a limuta ge tuvu na ruma tara, ");
INSERT INTO bnp_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","lakea a tahona ruma i masia a maki iea i bele na ruma vona, ge lakea na prister, ge vakalongoa vona a limuta i bele na ruma vona. ");
INSERT INTO bnp_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Muri a prister ge vakukua a tahona ruma ge bole tala na ruma a maki lobo vona, ma ge muto. Muri a prister ge dili ge lei a ruma. ");
INSERT INTO bnp_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ge lei kamumua a maki i vakahale a gagana ruma. Na tahuna i matai a maki gomagoma i vururu ri rata a maka dupi kiroko pololilo na gagana ruma, ");
INSERT INTO bnp_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","a prister ge pagitala ge tukaria a hinebi, ge vakalongoa vona a ruma ge mata kopu na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Na poloruana parava a prister ge hamule ge lei kamumu tabua a ruma. A maki iea ge rako lae na gagana ruma, ");
INSERT INTO bnp_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","a prister ge vakuku ria ri gi puka vuroki a maka kedo i rako ne ria a limuta, ri gi vuroki na lovo na lulu polovavo na tanga dagi. ");
INSERT INTO bnp_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ri gi haruri vuroki a maka simen ni kavitagu a gaga vona pololilo na ruma, ri gi bole tala tabu ri gi vuroki na murina lulu polovavo na tanga. ");
INSERT INTO bnp_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Muri ri gi bole a maka kedo karaba ri gi kuloi a maka kedo ri vuroki, ri gi kapi tabua a gagana ruma. Ri gi bole a simen karaba, ri gi pipikari tabu a murina a hini ni haruri vuroki a simen hale vona. ");
INSERT INTO bnp_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Na tahuna a limuta ge bele tabu na gagana ruma, muri ne ria ri rata a maka leho nga, ");
INSERT INTO bnp_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","a prister ge hamule tabu na ruma ge lei tabua. A maki iea i rako lae, i vakahale a ruma. A ruma iea i muto. ");
INSERT INTO bnp_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Lakea ri gi pukea a ruma, ri gi vuroki a maka kedo, a simen, a kai. Ri gi kaloho tala na tanga dagi, ri gi vuroki na murina lulu. ");
INSERT INTO bnp_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","A bakovi tara i dili vona a ruma ni tukari, a bakovi iea i muto, bara i muto mavonga i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","E rei a viri i kani o i mahita vona a ruma iea, ge vahilolo a maka varakia vona. ");
INSERT INTO bnp_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Na tahuna a prister i valai ge matai a ruma, i matai a gagana ruma i kamumu, i uka ma i tuvu vona a limuta, ge taki ria vona a ruma i matapado, a vuhuna a limuta ta ge ratapile a ruma i uka ma i bele tabu. ");
INSERT INTO bnp_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","A naro ni rata kamumu a ruma ge matapado na matana Vure i maea: A prister ge bole a kadirovo ge rua, a mavilana kai a sida, a mota vururu, a rahana kai a hisop. ");
INSERT INTO bnp_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","I ranga e huriki ri gi bolea a ulo ri gi kiru a naru, ri gi bole vilia. A prister ge bole langea na ulo a kadirovo tara, ge rabalakia, ge sisi puru na ulo a darana. ");
INSERT INTO bnp_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Muri ge bole a mavilana a kai a sida, a rahana kai a hisop, a mota vururu turana a kadirovo mahuri tara. Ge lutu a maki nga na ulo i vona a dara a naru, ge voro tamali langa na ruma balaka polorua. ");
INSERT INTO bnp_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","A prister ge rata maea a ruma, lakea bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Muri bara i pugea a kadirovo mahuri i bebe lakea na robo. Ra naro iea ne vona ni vakalobo a maki i muto na ruma, lakea a ruma bara i matapado.” ");
INSERT INTO bnp_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ra vinara nga ne vona a gilanga na kuli ra patala, a hini i makali, ");
INSERT INTO bnp_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ne vona a limuta i tuvu na varakia na ruma, ");
INSERT INTO bnp_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ne vona a loto, a pero, a vuruputuka. ");
INSERT INTO bnp_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ra vinara nga ne vona a gilanga na kuli, a limuta, ri vakasiri mua na maki i matapado, na maki i muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","E BAKOVI DAGI i taki e Moses e Aron, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“O taki e huriki a Israel, a bakovi i tahoka a kume i pagitala na kapuna, ra kume iea i rata ia i muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Na tahuna kume i pagitala turana a miha, o i gatuka i roga mule a dalana miha, ra bakovi iea i muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","A kiri vona i muto, a maki lobo i made vona, ngi ranga i muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","6","“E rei a viri i nugu a kiri vona o i made na hini i made muga vona, ge loi pasi a maka varakia vona, ge hilolo ia, pali bara i muto mavonga i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“A viri i padoi a bakovi i tahoka a gilanga iea, bara i muto i harena na malunga liu. Muri ge loi pasi a kala vona, ge hilolo ia. ");
INSERT INTO bnp_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“A bakovi i tahoka a gilanga iea i kalupe tahoa tara viri, ra viri i kalupe tahoa i muto, bara i muto i harena na malunga liu. Muri ge loi pasi a varakia vona, ge hilolo ia. ");
INSERT INTO bnp_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“A bakovi i tahoka a gilanga iea i made na sarel na hos, ra sarel iea i muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","A viri i padoi a sarel vona, bara i muto i harena na malunga liu. A viri i kaloho a sarel na bakovi i giloa, ra bakovi i kaloho a sarel i muto bara i harena na malunga liu. Muri ge hilolo, ge loi a varakia vona, bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Ra bakovi i tahoka a gilanga i uka ma i loi pasi a limana lakea i padoia a tara viri, ra viri i padoia bara i muto i harena na malunga liu. Muri ge loi pasi a varakia vona, ge hilolo ia. ");
INSERT INTO bnp_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Ia bara i padoi a ulo, ra ulo i padoia ni gi ubipoda. Pali ia ge padoi a tavila, ra tavila iea ni gi loi pasi. ");
INSERT INTO bnp_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Na tahuna a bakovi i lobo a gilanga vona, ra bakovi iea ge dava na parava ge polorua tabu, muga ne ia ge matapado. Ge lobo a parava i polorua, ge loi pasi a varakia vona, ge hilolo ia, bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Na polotoluna parava ge bole a balu ge rua, ge lakea na Kape na Vaponga ge habi na prister. ");
INSERT INTO bnp_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","A prister iea ge bole a balu nga, ge rata a leho vona. A balu muga ge a nihabi na naro hale, a balu tara ge a nihabi gutu-vuro. Na naro iea kunana a prister ge kavitagua na matane BAKOVI DAGI a bakovi i lobo a gilanga vona. ");
INSERT INTO bnp_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“A bakovi tara i mahita i maguru tavula a kuvena, ra bakovi iea i muto, bara i muto i harena na malunga liu. Muri ge vahilolo loboa a kakaina, bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","A kuvena ge maguru taho a kala vona, o a maki ni rata na kulina bulmakau, ra maki nga ri muto, bara i muto i harena na malunga liu. Muri ge bole ge vahilolo. ");
INSERT INTO bnp_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","A bakovi i mahita turana a ngatavine, ra bakovi a ngatavine nga ru muto, bara ru muto i harena na malunga liu, muri bara ru hilolo, ru matapado. ");
INSERT INTO bnp_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“A ngatavine i matai a keva, bara i muto mavonga na parava i polorua. A viri i padoia bara i muto i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","A maki lobo i mahita vona i made vona, ri muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","22","E rei a viri i padoi a kiri o a maki i made vona, bara i muto i harena na malunga liu. Muri ge vahilolo a varakia vona ge hilolo, ge matapado. ");
INSERT INTO bnp_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","A ra maki a ngatavine i made vona, a moke o a maki tara, e rei a viri i padoia bara i muto, i harena na malunga liu. ");
INSERT INTO bnp_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","A bakovi i mahita turana a ngatavine i matai a keva, ra bakovi iea i muto, bara i harena na parava ge polorua. Ra kiri i mahita vona bakovi i muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“A ngatavine i pori vona a dara na parava ranga na tahuna i uka ma i matai a keva, o na tahuna i tua mavonga a darana na tahuna i matai a keva, bara i muto ge harena na dara i lobo ni tua tala vona, i manga a hini i matai a keva. ");
INSERT INTO bnp_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","A kiri i mahita vona, a hini i made vona, ngi ranga i muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","A viri i padoi a maki nga, bara i muto i harena na malunga liu. Muri ge loi a kala vona, ge hilolo ia. ");
INSERT INTO bnp_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Muri na dara i lobo ni tua, ge dava na parava ge polorua, muri bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Na polotoluna parava ge bole a balu ge rua, ge bole lakea na matana Kape na Vaponga, ge habi na prister. ");
INSERT INTO bnp_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","A prister ge habia tara ne vona a nihabi na naro hale, i tara ne vona a nihabi gutu-vuro. Na naro iea a prister bara i kavitagua a ngatavine na matane BAKOVI DAGI, a vuhuna i muto na hini i pori vona a dara. ");
INSERT INTO bnp_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Muru habi tora a ngava ne huriki a Israel, ri gi matakari kamumu ria na tahuna ri muto na matagu. A mailogu i tabuli na kurukurune ria. Na tahuna ri muto nahea ri gi dili vona, ma ri gi mate, a vuhuna ri vakamutoa a mailogu.” ");
INSERT INTO bnp_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ra vinara nga, ne vona a bakovi i rali tala a kume na kakaina, a kuve i maguru tala tavula na kapuna, i rata ia i muto. ");
INSERT INTO bnp_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","I taki tabu, a ngatavine na tahuna i matai a keva, a kume i rali tala na muduna bakovi, o a ngatavine i pori vona a dara, a bakovi i mahita turana a ngatavine i muto. ");
INSERT INTO bnp_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Hosi e tune Aron bakovi ala rua ru habi a nihabi ne BAKOVI DAGI, pali e BAKOVI DAGI i uka ma i taki rua ru gu habi a nihabi, lakea i rabalaki rua. ");
INSERT INTO bnp_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Muri e BAKOVI DAGI i takia e Moses, “O takia e turamu e Aron, nahea ge dili na ningaru vona na Tabeke Nitaba Hateka na bitona kala dagi. Pali na tahuna i ngaru e rei a kilala ge dili vona, ge dili. A vuhuna iau a made pololilo na bubu, a bele kavakava na murina nidodo na Tava na Ngava Dagi. Ia ge dili tavula na tabeke iea, bara i mate. ");
INSERT INTO bnp_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Na tahuna e Aron ge dili na Tabeke Nitaba Hateka, muga ge bolea tara bulmakau karaba a toga, ge rata a nihabi na naro hale, a sipsip a toga tara ge bolea, ge a nihabi ni gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Na tahuna e Aron ge dili na Tabeke Nitaba Hateka, ge hilolo, ge rodo a maka nirodo keakea na prister: a poho, a nirodo ola ola, a palabele, a hoi. ");
INSERT INTO bnp_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","E huriki a Israel ri gi bole a meme a toga ge rua ne vona ni rata a nihabi na naro hale, a sipsip a toga tara ne vona a nihabi gutu-vuro, ri gi habi ne Aron. ");
INSERT INTO bnp_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“E Aron ge habia a nihabi na bulmakau, ne vona ni puga vuroki a naro hale vona, ne vona ni kavitagu ia turane huriki a kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Muri ge bole lakea ne BAKOVI DAGI na matana Kape na Vaponga a meme nga i rua. ");
INSERT INTO bnp_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","E Aron ge bole a kedo ge rua i tahoka a ngava. Ne vona e BAKOVI DAGI tara, ne vona e Asasel tara. Ge ruhulolo a kedo nga, ge bole tala takutaku ge kurahi iau vona tara, ge kurahi e Asasel vona tara. ");
INSERT INTO bnp_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","E Aron ge bolea ra meme i kurahi e BAKOVI DAGI vona, ge habia, ge a nihabi na naro hale ne huriki. ");
INSERT INTO bnp_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pali a meme i kurahi e Asasel vona, nahea ge rabalakia. Ni gi bole mahuri lakea na matane BAKOVI DAGI, ni gi vakakaloho vona a maka naro hale ne huriki, ge kaloho lakea ne Asasel na tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“E Aron ge bole valai a nihabi ni puga vuroki a naro hale, ge ramaia ra naro iea, ge kavitagu ia turane huriki na kabu vona. Muri ge rabalakia a bulmakau a toga, ge a nihabi na naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","13","Muri ge bole lakea na dede a ulo kiroko ni rata na aen, ge ru dili a katona kanono vona, ge bole lakea na matane BAKOVI DAGI na Tabeke Nitaba Hateka. Ge ragamu na limana balaka rua a havu mangisipa, ge guru dili na ulo i vona a katona kanono. A pokona a ulo bara i kavitagua a murina nidodo na Tava na Ngava Dagi. E Aron nahea ge masia a hini nga, ma ge mate. ");
INSERT INTO bnp_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ge bole ranga darana bulmakau iea ge lutua a kukulimana, ge voro tamali langa na murina nidodo na Tava na Ngava Dagi, na tabeke na nirikena haro. Muri ge bole tabu na kukulimana, ge voro tamali balaka polorua na ngalana murina nidodo. ");
INSERT INTO bnp_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Muri ge rabalakia ra meme ni habi na naro hale ne huriki. Ge bole dilia na Tabeke Nitaba Hateka a darana, ge voro tamali langa na murina nidodo na Tava na Ngava Dagi, na hini muga na murina nidodo, i manga a hini i rata pali na darana bulmakau. ");
INSERT INTO bnp_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Na naro iea kunana i kavitagu a naro hale ne huriki a Israel, i ratea a Tabeke Nitaba Hateka i matapado, a vuhuna ri tagege, ri longotaro a nitane BAKOVI DAGI, ri rata a naro hale, lakea i muto ra hini nga. A Kape na Vaponga i pesi na kurukurune ria, pali a naro hale ne ria i rata a maki na kape ri muto. E Aron ge bole a dara popote ge voro langa na kape, ge matapado tabu, i manga a naro i rata na Tabeke Nitaba Hateka. ");
INSERT INTO bnp_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","E Aron ge ratea a nihabi iea ne vona ni kavitagu ia, e huriki a kabu vona, turana e huriki a Israel. Na tahuna i dili na Tabeke Nitaba Hateka nahea tara viri ge dili na Kape na Vaponga, ge harena na tahuna e Aron i pagitala. ");
INSERT INTO bnp_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Muri ge pagitala, ge lakea na dede ra i tabuli na matane BAKOVI DAGI, ge rata a leho ni kavitagua. Ge bole a darana bulmakau, a meme, ge ru na tupina dede. ");
INSERT INTO bnp_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Muri ge lutua a kukulimana tara na dara, ge voro tamali balaka polorua langa na dede. Na naro iea kunana i ratea a dede nitaba, i matapado na naroanga ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Muri ne Aron ge kavitagu loboa a Tabeke Nitaba Hateka, a Kape na Vaponga, a dede na nihabi ni gutu-vuro, ge bole lakea na matana kape a meme mahuri. ");
INSERT INTO bnp_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Muri ge ru langa varago na gina meme mahuri a limana, ge taki tala a maka vilo hale, a maka tagenga, a naro hale lobo ne huriki a Israel. Na naro iea kunana, i ru langa na gina meme a maka naro hale ne ria. Muri ge habia na bakovi ni vulaki pali, ge turaria lakea na tabeke i ngeki a meme, ge taparakia vonga. ");
INSERT INTO bnp_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ra meme iea ge kaloho a naro hale lobo ne huriki a Israel. A viri i turaria, ge taparakia na tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Muri na leho iea ge lobo, e Aron ge dili na Kape na Vaponga, ge kali tala vonga a maka nirodo i rodo na tahuna i dili na Tabeke Nitaba Hateka, ge taparaki vonga. ");
INSERT INTO bnp_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ge vano ge hilolo na naru pololilo na nure i pesi halui a kape. Muri ge dili tabu na kape, ge rodo ge bagetu na maka bagetua na prister dagi. Na tahuna i pagitala ge rata a nihabi gutu-vuro ge rua, i tara ne vona, i tara ne huriki, ne vona ni kavitagu ia, ni kavitagu e huriki. ");
INSERT INTO bnp_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ge gutu langa na dede a vina sipsip, a bulmakau nevona a nihabi na naro hale ne huriki. ");
INSERT INTO bnp_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Ra bakovi i taparakia a meme i lakea ne Asasel, ge kali tala a maka varakia vona, ge hilolo, ge dili tabu na mada. ");
INSERT INTO bnp_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ri gi bole tala na mada a bulmakau, a meme, ra muga ni bole lakea na Tabeke Nitaba Hateka a darane rua ne vona a nihabi na naro hale. Ni gi gutu a kuline rua, a bobone rua, a tahene rua, ri gi vuro lobo liu. ");
INSERT INTO bnp_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ra bakovi i gutu-vuro a sipsip, a bulmakau nga, ge vano ge vahilolo a nirodo vona, ge hilolo ia, muri ge dili tabu na mada.” ");
INSERT INTO bnp_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","E BAKOVI DAGI i ta tabu, “Mu ramai vakaroroa a vinara iea. Na ravuluna parava, na poloruana keva, mua a Israel turane huriki a mosi ri made ne mua, mu peremu na kinani, naha ni raulo, naha ni leho, mu malo kunana. ");
INSERT INTO bnp_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","A vuhuna na parava iea kunana a prister ge rata a nihabi ne vona ni kavitagu mua, bara mu matapado na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ra parava dagi iea, a Parava Nimalo. Mu malele ha na maki nivivi, mu malo kunana. Ra vinara iea mu ramai vakaroroa. ");
INSERT INTO bnp_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","E rei a prister ni gamai ge bole a murine tamana, ge ia a prister dagi, ia kunana ge ratea a leho ge kavitagu e huriki, ge rodoa a nirodo keakea na prister. ");
INSERT INTO bnp_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Muri ge rata a nihabi ni kavitagu, ge matapado a Tabeke Nitaba Hateka, a Kape na Vaponga, a dede, e huriki a prister, e huriki a Israel lobo. ");
INSERT INTO bnp_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Ra vinara iea mu ramai vakaroroa. A vinara iea ni kavitagu a naro hale, ni gi rata balaka taku na maka pida lobo, ne vona a naro hale ne huriki a Israel.” E Moses i rata lobo a maki e BAKOVI DAGI i vakuku ia vona ge rata. ");
INSERT INTO bnp_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“O taki e Aron turana e tuna mai, e huriki lobo a Israel vona a maka vinara nga e BAKOVI DAGI i vakuku ria vona: ");
INSERT INTO bnp_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Na tahuna a bakovi tara i habi a bulmakau, a tuna sipsip, a meme pololilo o polovavo na mada, ");
INSERT INTO bnp_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","pali i uka ma i bole vilia na matana Kape na Vaponga, ge habia manga a nihabi ne BAKOVI DAGI na matana mailo vona, i putu puru a vinara, i vakatua a dara, i tahoka a ngava. Ni gi tono tala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ra vinara iea i ta pupukari ne huriki a Israel nahea ri gi rabalaki a sipsip, a bulmakau, ri gi rata a nihabi polovavo na mada. Ri gi bole a sipsip, a bulmakau ri gi lakea na matana Kape na Vaponga, ri gi rata a nihabi na nivalemu turane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Muri a prister ge bolea a darana sipsip, a bulmakau, ge voro tamali na gagana dede tabukoi na matana kape, ge gutu na dede a vina sipsip, a bulmakau. Na tahuna e BAKOVI DAGI i burongi a mangina bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Pali nahea ri gi habi tabu a nihabi na meme taua. Na tahuna ri rata mavonga, ri manga a ngoi, ri mata here ne BAKOVI DAGI ri kavurike viliha a vure ranga. Ra maka vinara nga ge tabuli tora turane ria, e huriki a hamone ria bara ri ramai vakaroro muri ma. ");
INSERT INTO bnp_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“O taki ria e rei tara ne ria, o a mosi tara i made turane ria, i ngaru ni habi a nihabi ni gutu-vuro, ");
INSERT INTO bnp_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","pali i uka ma i taparaki lakea na matana Kape na Vaponga ni gi habi ne BAKOVI DAGI, bara ni tono tala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“E rei tara ne ria na kabu ne Israel o a mosi tara i made turane ria, i rabalakia a kanirau, i ninu o i kani a darana, bara iau a pile vona, ni gi lili tala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","A dara i habi a nimahuri ne huriki a bakovi, a kanirau, i mavonga a taki maea mua. A prister ge guru na dede a darana kanirau, ne vona ni kavitagu a nimahuri vona, a vuhuna a dara kunana a maki ge kavitagu e huriki ri gi mahuri. ");
INSERT INTO bnp_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","I mavonga e BAKOVI DAGI i taki e huriki a Israel, nahea tara ne ria, o a mosi tara i made turane ria, ge kani a bobona maki i vona a dara. ");
INSERT INTO bnp_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Na tahuna a Israel tara o a mosi tara i pango, i lakavua tara kanirau, o a kadirovo i kara ni kanina, ge guru tala na malala a darana, ge kavitagua na malala, ");
INSERT INTO bnp_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","a vuhuna a nimahuri ne huriki lobo, a nimahuri na maka kanirau i tabuli na dara. Na naro iea kunana, e huriki a Israel nahea ri gi kani a bobona kanirau i vona a dara. A viri i kani a bobona sipsip, a bulmakau i vona a dara bara ni tonotala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Na tahuna a tahotanga o a mosi i kani a maki i mate, o i lakavua a kanirau hateka, ra bakovi iea i muto, bara i harena na malunga liu. Muri ge loi a maka varakia vona ge hilolo ia, bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ia i uka ma ge loi na naru a varakia vona, i uka ma ge hilolo, bara i tahoka a ngava.” ");
INSERT INTO bnp_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","ge taki e huriki a Israel, ge ta maea, “Iau kunana e BAKOVI DAGI, a Vure ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Hosi mu made na robo e Egipto, pali naha ni ramai a maka narone ria. Ngane ga taparaki mua lakea na malala e Kenan, pali naha ni ramai a narone ria, a vinara ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mu ramai kunana a vinara nau, mu rata kunana a maki a taki mua vona mu gu rata. Iau e BAKOVI DAGI a Vure ne mua, a habi ne mua a ngava nga. ");
INSERT INTO bnp_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Mu rata lobo a vilo kamumu a ngaru mu gu rata, mu ramai a maka vinara a habi ne mua. E rei a viri i rata maea, bara i made kamumu. Iau e BAKOVI DAGI a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Iau e BAKOVI DAGI a habi ne mua a vinara nga: Naha ni masigoro ni mahita turana, ni parangi vona tara ngatavine na kabu vomu. Ra naro maea, i muma hateka. ");
INSERT INTO bnp_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“Naha ni mahita turane kinamu. Bara o rata mavonga, o vakamaruhu e tamamu. ");
INSERT INTO bnp_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Naha ni mahita turana a ngatavine i parangi tabu vona e tamamu. Bara o rata mavonga, o vakamaruhu e tamamu. ");
INSERT INTO bnp_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Naha ni mahita turane kurabamu, o e tune tamamu ngatavine, o e tune kinamu ngatavine. Ra ngatavine nga e kurabamu. I made na ruma vomu, o i made na tabeke tara, ia e kurabamu kunana. ");
INSERT INTO bnp_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Naha ni mahita turana e tubumu ngatavine, re tune tumu bakovi a ngatavine, e tune tumu ngatavine a ngatavine. Ra naro iea bara i rata ioe o maruhu hateka. ");
INSERT INTO bnp_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Naha ni mahita turane tune girihine tamamu ngatavine, a vuhuna ia e tune tamamu. Ra ngatavine iea e kurabamu. ");
INSERT INTO bnp_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Naha ni mahita turana e kurabane tamamu, a vuhuna ia e balomu. ");
INSERT INTO bnp_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Naha ni mahita turana e kinamu tara, a vuhuna ia a viri vomu. ");
INSERT INTO bnp_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“Naha ni mahita turana e girihine tamamu tara, a vuhuna ra ngatavine iea e kinamu. Bara o mahita turana, o rata e tamamu tara i maruhu. ");
INSERT INTO bnp_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“Naha ni mahita turana e girihine tumu bakovi, a vuhuna ia e kamu. ");
INSERT INTO bnp_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Naha ni mahita turana e girihine turamu, a vuhuna ia e kua vomu. Ioe bara o rata mavonga, bara o vakamaruhu e turamu. ");
INSERT INTO bnp_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Naha ni mahita turana a ngatavine, turana e tuna a ngatavine. Naha ni mahita turana e tubumu, a vuhuna ia e tubumu. A naro iea i muma hateka. ");
INSERT INTO bnp_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“Naha ni parangi tabu e tarine girihimu na tahuna i tababana ni mahuri e girihimu, ma go rata rua ru gu vatahate mule ne rua. Ra naro iea i uka ma i kamumu. ");
INSERT INTO bnp_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Naha ni mahita turana a ngatavine i matai a keva, a vuhuna na tahuna iea i muto. ");
INSERT INTO bnp_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Naha ni mahita turana e girihina bakovi i made tabukoi vomu, bara o rata mavonga o muto. ");
INSERT INTO bnp_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Naha ni habi e tune mua ne Molek. Bara mu rata mavonga, mu vakahale a rana Vure ne mua. Iau e BAKOVI DAGI a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Naha ni mahita turana a bakovi tara i manga a naro ni mahita turana ngatavine. Ra naro iea i muma hateka. ");
INSERT INTO bnp_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Naha ni tari a ligo, a boro, a maki maea. A ngatavine tara nahea ge rata mavonga. Ra naro iea i muma hateka, i rata a viri i muto na matagu. ");
INSERT INTO bnp_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Naha ni rata a maka naro hale nga, ma mu gu muto na matagu. E huriki i uka ma ri lohoka na Vure muholi, ri made na robo e Kenan, ri rata a maka naro hale nga, ri muto na matagu. I mavonga a vakatubu ni lili tala ria, mu gu bole a malala ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","A naro hale ne ria i ratea a malala iea i muto. Lakea a rata halea a malala ne ria, i marikoi ne ria, i lua tala ria. ");
INSERT INTO bnp_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Pali mua turana e huriki a mosi ri made turane mua, mu ramai a maka vinara nau a habi ne mua. Naha ni ramai a narone huriki ri made muga na robo iea, a vuhuna a narone ria i mavuru hateka, a marikoi vona. ");
INSERT INTO bnp_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Mu lohoka vona e huriki ri made muga vona a robo iea, a narone ria i mavuru, i ratea a malala i muto. ");
INSERT INTO bnp_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Naha ni rata mavonga. Mua bara mu rata mavonga, a malala bara i lua tala mua i manga a hini i lua tala e huriki ri made muga vonga. ");
INSERT INTO bnp_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“E rei tara ne mua i ratea tara naro mavuru maea, bara ni tono tala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Mu ramai a maka ngava a habi ne mua. Naha ni ramai a maka naro mavuru ne huriki ri made muga vona a malala iea. Mua bara mu ramai a maka naro mavuru nga, bara mu muto na matagu. Mu longo, iau e BAKOVI DAGI a Vure ne mua a taki a ngava nga.” ");
INSERT INTO bnp_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","ge taki e huriki a Israel, ge ta maea, “Mu ramai a naro malamala, a vuhuna iau e BAKOVI DAGI, a Vure ne mua, a malamala. ");
INSERT INTO bnp_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Mua takutaku mu togo e kinane mua e tamane mua. Mu malo na Parava Nimalo. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Naha ni ha taro iau mu gu kavurike a vure ranga. Naha ni kau na kai, na aen a vure, mu gu kavurike. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Na tahuna mu rata a nihabi na nivalemu ne BAKOVI DAGI, mu ramai a vinara a habi ne mua. Mua bara mu rata mavonga, bara ngaru a nihabi ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","A bobona kanirau na nihabi na nivalemu ni gi kani na parava ni rabalaki vona, o na parava muri. I ranga ge tabuli polo na toluna parava, naha ni kani, mu gutu na kanono ge vuro. ");
INSERT INTO bnp_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","A viri i kani a bobona kanirau na toluna parava, i uka ma ga ngarua a nihabi vona, a vuhuna i muto. ");
INSERT INTO bnp_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","E rei a bakovi i kani a bobona sipsip, a bulmakau na toluna parava i vakahale a maki ni habi nau, i tahoka a ngava, bara ni tono tala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Na tahuna mu mirio a vit, naha ni mirio na harena hania, naha ni hamule mu gu poi a masigo. Ge tabuli ngi. ");
INSERT INTO bnp_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Na tahuna mu pasi pali a kanena vain, naha ni hamule tabu ni poi kado a masigo, a kanena mu pasi kaleva na rahana. Ge tabuli ngi ne vona e huriki a matasia, a mosi. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Naha ni panaho a maki, naha ni tami a viri ni rata marogo a maki vona. Naha ni ta marapusi. ");
INSERT INTO bnp_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“Na tahuna mu ta muholi ni rata a maki, naha ni kaba tavula na ragu ni tami a viri. I uka ma mu ramai a nita muholi mu rata, mu vakahale a ragu. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Naha ni rata hale a viri mu gu panaho a maki vona. Na tahuna mu taki a viri ge rata a leho ne mua, mu kona liu ia na parava iea. Naha ni nugu mule a mapana, mu gu habi kuduvi. ");
INSERT INTO bnp_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Naha ni harogi a viri i vou. Naha ni ru na dala a maki, ge sibo vona a kepa ge boru. Mu mangenge vona a Vure ne mua. Iau e BAKOVI DAGI, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Na tahuna mu varamai na ngava, mu rata a naro kamumu na nipelekado a ngava. Naha ni tuhori a matasia, o go mangenge na bakovi na mahala. A ngava mu rata ge malamala kunana. ");
INSERT INTO bnp_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Naha ni laho viliha ni padimomo a turamu. A bakovi tara ni vakapesi na ngava ni gi pelekado, pali ra ngava ni padi virihi ia vona i uka ma i muholi, mu ta tala mu tuhoria. Bara mu ngavarubu, bara ni rabalaki tavula a bakovi iea. Iau e BAKOVI DAGI, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Na tahuna a viri i rata hale ioe, naha ni mata robo vona. O pelekado a ngava muru vatahate vona. Ma go ru mavongea na niluhoi vomu a ngava muru vatahate vona, bara o dili na naro hale. ");
INSERT INTO bnp_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Naha ni koli a naro hale na viri i rata virihi ioe vona, naha ni tepu vakaroroa. O ngaru e huriki a turamu, i manga a hini o ngaru mule ioe. Iau e BAKOVI DAGI a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Mu ramai a maka vinara nau. Naha ni mata taroa a sipsip ge radia a meme, ge vakabele a tuna. Naha ni varo palupu na hania ge taku a vutuna maki legelege. Naha ni rodo a nirodo i uka ma ni rata na maki i taku. ");
INSERT INTO bnp_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Na tahuna a bakovi i mahita turana a vorakato ngatavine, ni taki ta ni gi habi na bakovi tara ge konea ge matukapaga, pali ra bakovi iea i uka ma i konea ma, mu tuli rua lakea na tabeke ni vapelekado. Muri ni gi vakamadihi rua. Pali naha ni rabalaki rua, a vuhuna ra ngatavine iea, i uka ma ni vakamatukapaga ma. ");
INSERT INTO bnp_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","A viri i mahita turana a vorakato ge lavea tara sipsip a toga, ge bole lakea na matana Kape na Vaponga, ge a nihabi na rarenga. ");
INSERT INTO bnp_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","A prister ge bolea a sipsip iea, ge rata a nihabi na rarenga na matane BAKOVI DAGI, ge kavitagua a bakovi iea, na naro hale i ratea. Lakea a naro hale vona bara ni puga vuroki. ");
INSERT INTO bnp_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Na tahuna mu lakea na malala e Kenan, mu varo a maka kai i vona a kanena. Pali naha ni kani a kanena kai na pida ge tolu. ");
INSERT INTO bnp_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Na vana pida mu habi ne BAKOVI DAGI a maka kanena kai, ne vona ni kavurike iau vona. ");
INSERT INTO bnp_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Na limana pida mu kani a maka kanena kai. Mua bara mu ramai a maka ngava nau, a maka kai ne mua bara ri vua kupo. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Naha ni kani a bobona kanirau i vona a dara. Naha ni rata a malulu legelege. ");
INSERT INTO bnp_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“Naha ni pali a ivu na tabalane mua, naha ni palakudu ge kapo a ivu na sivane mua. ");
INSERT INTO bnp_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“Naha ni tolo a kuline mua na tahuna a viri i mate, naha ni siri a kuline mua. Iau e BAKOVI DAGI a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Naha ni ramai a narone huriki ri kavurike a vure ranga, ri mata taro e tune ria ngatavine ge ria a ngoi. Bara mu rata mavonga, mu ha taro iau, mu ramai a maka vure ranga, a maka naro hale bara ri bele kupo na tanga ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Naha ni leho na Parava Nimalo. Mu rata kamumua mu togoa a mailo nau. Iau e BAKOVI DAGI a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Na tahuna mu ngaru a niluhoi kamumu, naha ni lakea ne huriki a bakovi na malulu, a bakovi na muto. Bara mu rata mavonga, mu muto na matagu. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Mu rata kamumu mu togo e huriki a gare. Mu mangenge nau, a Vure ne mua. Iau e BAKOVI DAGI a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Naha ni rata hale e huriki a mosi ri made na malala ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mu rata kamumu ria, i manga a hini mu rata kamumu a bakovi o Israel. Mu ngaru ria i manga a hini mu ngaru mule mua, a vuhuna hosi mu made manga a mosi o Egipto. Iau e BAKOVI DAGI, a Vure ne mua, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Na tahuna mu rovai a maki, mu guru dili a maki, mu gi a maki ge kona e huriki, naha ni ta tami. ");
INSERT INTO bnp_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Mu rovai kamumu, mu guru kamumu, mu gi kamumu a maka maki. Iau e BAKOVI DAGI a Vure ne mua, a tuli tala mua na robo o Egipto, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Iau e BAKOVI DAGI a Vure ne mua, a vakuku mua mu gu longototo a maka vinara nau, a nitagu.” ");
INSERT INTO bnp_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","E BAKOVI DAGI i takia e Moses ");
INSERT INTO bnp_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ge taki e huriki a Israel, ge ta maea, “E rei tara ne mua, o a mosi i made turane mua, ge habi e tuna ne Molek ge a nihabi, ra bakovi iea ni gi rabalaki. E huriki a tahotanga ri gi padimatea na kedo. ");
INSERT INTO bnp_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ra bakovi i habi e tuna ne Molek, i rata a mailo nau i muto, i ratapile a ragu. Ra bakovi iea a pile nau, bara lili talea ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Pali na tahuna e huriki ri mata taroa a bakovi iea i habia tara e tuna ne Molek, lakea i uka ma ri rabalakia, ");
INSERT INTO bnp_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","iau bara marikoi vona turane huriki a kabu vona, bara lili tala ria na kabu ne ria, a vuhuna ri kavurikea e Molek. ");
INSERT INTO bnp_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Na tahuna a bakovi tara i lakea na bakovi na malulu o na bakovi na muto, ra bakovi iea i pe iau pali, i ramai a naro na uvo. Ra bakovi iea bara a ngalahere vona, a lili talea ne huriki a viri vona. ");
INSERT INTO bnp_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“I mavonga, mu habi mua nau bara mu laho malamala, a vuhuna iau, e BAKOVI DAGI a Vure ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mu longototo a vinara nau, a vuhuna iau e BAKOVI DAGI a rata mua mu malamala. ");
INSERT INTO bnp_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“E rei a viri i harogi e tamana o e kinana, ni gi rabalaki, a vuhuna ia kunana i vakabele mule a vuranga vona. ");
INSERT INTO bnp_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Bara a bakovi i rata a naro na molenga ne girihina bakovi tara, ra bakovi a ngatavine nga ni gi rabalaki, a vuhuna rua kunana ru vakabele a vuranga ne rua. ");
INSERT INTO bnp_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“Bara bakovi i mahita turane girihine tamana, i vakahale e tamana. A bakovi a ngatavine nga ni gi rabalaki. Rua kunana ru vakabele a vuranga ne rua. ");
INSERT INTO bnp_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Bara bakovi i mahita turana e kana, a bakovi a ngatavine nga ni gi rabalaki. Rua kunana ru vakabele a vuranga ne rua. ");
INSERT INTO bnp_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Bara bakovi i mahita turana a bakovi turana, i manga i mahita turana a ngatavine, ra bakovi nga ru rata a naro i muma hateka ni gi rabalaki, a vuhuna a naro ru ratea i uka ma i ramai a vilo, rua kunana ru vakabele a vuranga ne rua. ");
INSERT INTO bnp_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Bara bakovi i parangi a ngatavine turana e kinana, tou lobo ni gi gutu na kanono, a vuhuna to rata a naro hale hateka. Ra naro maea nahea ni gi mata taro ge bele ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Bara bakovi i tari a ligo o a maki tara, ra bakovi iea ni gi rabalaki, a ligo tara ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Bara ngatavine i lakea mai a ligo i mahita turana, a ngatavine turana a ligo ni gi rabalaki; a vuhuna a ngatavine a ligo ru vakabele mule a vuranga ne rua. ");
INSERT INTO bnp_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Bara bakovi i parangi mule e kurabana, o e tune tamana, o e tune kinana, ra bakovi a ngatavine nga a narone rua i muma hateka. Ni gi lili tala na kabu ne rua, ru gu hatakia a maregoa na naro ru ratea. ");
INSERT INTO bnp_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Bara bakovi i mahita turana a ngatavine na tahuna a ngatavine i matai a keva, a bakovi a ngatavine nga ru rata a naro i muto, ni gi lili tala na kabu ne rua. ");
INSERT INTO bnp_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Naha ni mahita turana e balomu o kinamu tara, a vuhuna bara o vakahale a viri vomu, marua varago bara ni vakamadihi na naro muru ratea. ");
INSERT INTO bnp_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Bara bakovi i mahita turane girihine tamana tara o e girihine hana, ra bakovi iea i vakamaruhu e tamana tara o e hana. A bakovi a ngatavine nga bara ni vakamadihi na narone rua, i uka ma ru gu vakabele a koma. ");
INSERT INTO bnp_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“Bara bakovi i parangi polo vona e girihine turana, ra bakovi iea i vakahale e turana, i muto. Ra bakovi a ngatavine nga, bara ru bala e tune rua. ");
INSERT INTO bnp_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Mu ramai a ngava dagi, a vinara nau. A malala e Kenan ngane ga taparaki lokovonga mua vona, i uka ma ge lua tala mua, bara mu vivi ni made vona. ");
INSERT INTO bnp_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Naha ni ramai a narone huriki ri made na uvo vonga. Ri rata a naro hale nga lakea a marikoi hateka ne ria. Ngane ga lili tala ria na robo iea, muri bara mu bolea. ");
INSERT INTO bnp_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","A taki mua pali na maka uve, a kai ni kani, ri koru kamumu vona a malala iea. Ga habia ne mua, ge ne mua liu. Iau e BAKOVI DAGI a Vure ne mua, a vulaki tala mua ne huriki a kabu ranga ge mua e huriki a viri nau. ");
INSERT INTO bnp_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Mu pelekado a kanirau, a kadirovo i kaba mu kani, pali naha ni kani a viri i muto. A taki mua pali vona a maka kanirau, a kadirovo, a maki kiroko ri karaka ri muto, naha ni kani a vuhuna ri muto. ");
INSERT INTO bnp_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Lakea bara mu malamala na matagu, a vuhuna iau e BAKOVI DAGI a malamala, a ru here mua ne huriki a kabu ranga ge mua e huriki a ngate nau. ");
INSERT INTO bnp_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“E huriki a bakovi na malulu, a bakovi na muto, mu padimate na kedo. Ria kunana ri vakabele mule a vuranga ne ria.” ");
INSERT INTO bnp_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","E BAKOVI DAGI i takia e Moses, “O taki e huriki a prister re huriki e tune Aron o ta maea. ‘A prister nahea ge kalo na tahuna a viri i mate na kabu vona, nahea ge padoi a podana. Ra naro maea i rata ia i muto na matagu. ");
INSERT INTO bnp_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Pali na tahuna a viri vona i mate, i kara ni kalo, ni padoi a podana: re kinana, e tamana, e tuna, e turana, ");
INSERT INTO bnp_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","e kurabana a sirula i made na ruma e tamana. A prister i kamumu ge kalo ne kurabana i mate, pali bara i muto. ");
INSERT INTO bnp_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Pali nahea ge vano ge taringia e lahuana o e kana i mate, ma ge muto na matagu. ");
INSERT INTO bnp_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“‘E huriki a prister nahea ri gi ali vuroki a ivu na gine ria, nahea ri gi pali vuroki a karira na garene ria, nahea ri gi tolotolo a kuline ria, ri gi vakasiri ria ri dodo. ");
INSERT INTO bnp_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ri gi malamala na matana Vure ne ria, nahea ri gi vakahale a rana. Ri gi malamala, a vuhuna ri rata a nihabi na kanono, ri habi ne BAKOVI DAGI. Ra nihabi nga i manga a maki ni kani na Vure ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“‘Naha ni parangi na ngatavine a ngoi, o na ngatavine i parangi pali, o na ngatavine i mahita turana a bakovi tara pali, a vuhuna e huriki a prister ria ne vona a Vure kunana. ");
INSERT INTO bnp_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mua mu matai e huriki a prister ri malamala, a vuhuna ri habi a nihabi na Vure ne mua. Iau e BAKOVI DAGI, a Vure ne mua, a malamala, a rata e huriki a ngate nau ri malamala. ");
INSERT INTO bnp_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“‘Bara e tuna prister a ngatavine i ngoi viliha, i vakamaruhu e tamana. Mu bolea mu gutua na kanono, ge mate. ");
INSERT INTO bnp_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“‘A prister dagi ni gamai, ni bole tala ne huriki e turana, ge rata a leho vona, na tahuna ni guru langa a nibiri na gina, ni vakarodo na nirodo na prister. Pali na tahuna i ramai a naro ni kalo na tahuna a viri vona i mate, nahea ge ratea a vuna ge patoka, nahea ge rape a maka varakia vona. ");
INSERT INTO bnp_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","A prister dagi nahea ge lakea na hini i tabuli vona a podana a viri i mate, ma ge muto na matagu. E tamana e kinana ru mate, ngi ranga nahea ge lokovonga. ");
INSERT INTO bnp_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Nahea ge ha taroa a mailo na Vure vona ge lakea na ruma i tabuli vona a viri i mate. Ia bara i rata mavonga i ratea a mailo nau i muto. Iau a gamaia pali na nibiri, a habia ne mua ge ia a prister dagi. Iau e BAKOVI DAGI a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“‘A prister dagi ge parangi a sirula, ");
INSERT INTO bnp_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","nahea ge parangi a havuri, a ngatavine i pilea e girihina, a ngoi, a ngatavine ni mahita turana pali. Ra ngatavine maea, nahea ge parangi ne ria. Ge parangi kunana a sirula na kabu vona ne Levi. ");
INSERT INTO bnp_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Ia i uka ma i longo maia a nitagu, e huriki e tuna bara ri muto na matagu. Iau e BAKOVI DAGI, a ratea i malamala.’” ");
INSERT INTO bnp_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“O takia e Aron, nahea tara hamona ge nabatabuna ge habi a nihabi nau. Ra vinara iea ge tabuli vakaroro. ");
INSERT INTO bnp_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","E huriki a bakovi ri nabatabuna nahea ri gi habi a nihabi nau: ra kepa, a beu, a rupere mabebe, a mata marango, ");
INSERT INTO bnp_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","a vaha maputu, a lima maputu, ");
INSERT INTO bnp_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","a bito poku, a moku, a mata gelo, a bakovi i tuvu vona a pero, a bakovi i dole. ");
INSERT INTO bnp_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Nahea tara hamone Aron a prister, ge nabatabuna ge valai tabukoi, ge habi a nihabi ni gutu na kanono na Vure vona. ");
INSERT INTO bnp_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Pali i kara ni kani a kinani ni taba mu habi na Vure vona, ge bole tala na kinani a habi ne mua a prister mu gu kani. ");
INSERT INTO bnp_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Pali a vuhuna i nabatabuna, nahea ge lakea tabukoi na kala dagi i kavitagu a Tabeke Nitaba Hateka, nahea ge lakea tabukoi na dede i pesi vonga, ma ge vakamuto a mailo nau. Iau e BAKOVI DAGI a rata a maki nga i malamala.” ");
INSERT INTO bnp_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ra ngava nga, e Moses i vakalongo e Aron, e huriki e tuna, e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“O taki e Aron turane huriki e tuna bakovi, ri gi togo a nihabi ni taba e huriki a Israel ri habi nau, ma ri gi vakahalea a ragu. Iau e BAKOVI DAGI, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Na tahuna a bakovi tara na kabu na prister i muto, nahea ge valai tabukoi na maka nihabi ni taba ne huriki a Israel ri habi nau. A viri ge valai tabukoi, bara lili talea, i uka ma ge leho manga a prister tabu na matagu. Ra vinara iea mu ramai vakaroroa. Iau e BAKOVI DAGI, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","5","“Na tahuna a bakovi tara na hamone Aron ge tuvu vona a patala, o ge pori a kume na ngarava vona, nahea ge kani a maki ni kani ni taba, ge matapado taro, muri ge kani. A prister i padoi a podana viri mate, o i padoi a kuvena i maguru tala mule vona, o i padoi a maki ri muto ri karaka viliha, o i padoi a bakovi i muto, i muto na matagu, ");
INSERT INTO bnp_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","bara i muto mavonga i harena na malunga liu. Muri ge hilolo kamumu taro na naru, ge kani a nihabi ni habi nau. Ia i uka ma i hilolo, nahea ge kani. ");
INSERT INTO bnp_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Muri na haro i rolo, bara i matapado, ge kani a nihabi ni taba, a vuhuna a maki ni kani ri habi nau, ne vone ria e huriki a prister. ");
INSERT INTO bnp_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Nahea ge kani a bobona sipsip, a bulmakau i mate tavula o i rabalakia a kanirau hateka. Na tahuna i kani a bobona, bara i muto na matagu. Iau e BAKOVI DAGI, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“E huriki a prister ri gi ramai lobo a maka vinara a habi ne ria. Ria i uka ma ri ramai a vinara, bara ri tahoka a ngava, a rabalaki ria. Iau e BAKOVI DAGI, a gamai ria ge ria a prister nau, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“E huriki a bakovi tavula nahea ri gi kani a maka nihabi ni taba. E huriki a mosi, a vora na prister, ngi ranga nahea ri gi kani. ");
INSERT INTO bnp_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Pali a vorakato i konea a prister ge vona, o ni poda na tabeke vona, i kara ge kani a maki ni kani i bole a prister. ");
INSERT INTO bnp_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Bara prister i tahoka e tuna a ngatavine, i parangi a bakovi tavula, i uka ma ia a prister, ra ngatavine iea nahea ge kani a maki ni kani ni gamai. ");
INSERT INTO bnp_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pali ra ngatavine iea ge mate e girihina o ni pile, i uka e tuna, i hamule lakea ne tamana i made turana, ra ngatavine iea i kara ni kani a maki ni kani na prister. Pali e huriki a bakovi tavula, i uka ma ri gi kania. ");
INSERT INTO bnp_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“A bakovi tavula i kani ruru a maki ni kani ni gamai, ge koli lakea na prister a maki i kani, ge ru langa tabu ranga. ");
INSERT INTO bnp_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","E huriki a prister ri gi matadoko, nahea tara bakovi tavula ge kani a maki ni kani ni taba, ma ri gi rata hale a nihabi ne huriki a Israel ri habi ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Bara ri mata taroa tara bakovi tavula i kani a maki ni kani ni taba, ra bakovi iea i tahoka a ngava, ge koli a maki ni kani na prister, a vuhuna iau kunana e BAKOVI DAGI a rata ria ri malamala.” ");
INSERT INTO bnp_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“O taki e Aron, e huriki e tuna, turane huriki a Israel. Na tahuna a bakovi tara ne mua, a mosi tara i made turane mua, i habi a nihabi gutu-vuro ne vona ni vakaloboa tara nita muholi i takia ne BAKOVI DAGI, o na ningaru vona kunana, ");
INSERT INTO bnp_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ge bolea tara bulmakau, a sipsip, o a meme, ge a toga ge gavutuvutu, lakea bara ngarua a nihabi vona. ");
INSERT INTO bnp_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Pali na tahuna i habi nau a maki nabatabuna, bara pile, i uka ma ga ngaru. ");
INSERT INTO bnp_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","A bakovi i ngaru ni habi ne BAKOVI DAGI a nihabi na nivalemu ne vona ni vakalobo a nita muholi vona, o ge habi na ni ngaru vona kunana, ge bolea tara sipsip o a bulmakau, ge gavutuvutu. Ia bara i rata mavonga, bara ngarua a nihabi vona. ");
INSERT INTO bnp_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Naha ni habia ne BAKOVI DAGI a sipsip, a bulmakau i kepa, i maputu a vahana, i tekiteki, i tahoka a ngarava. Naha ni habi na dede a kanirau maea, ge a nihabi ni gutu na kanono lakea ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Na tahuna mu habi a nihabi na ningaru ne mua kunana, mu bole a sipsip, a bulmakau i laho puru rike, i uka maki. Pali naha ni habi nau a sipsip, a bulmakau maea ge vona a nihabi na nita muholi. I uka ma ga ngarua. ");
INSERT INTO bnp_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Naha ni habi ne BAKOVI DAGI a kanirau ni ratapile a dolena, ni pala a dolena, ni kini momo a dolena, ni rape a dolena. Naha ni ratea a naro iea na tahuna mu made na malala ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Naha ni habi ne BAKOVI DAGI a nihabi na kinani mu bole na mosi. Ra sipsip, a bulmakau maea, i uka ma i kamumu na matagu, i uka ma ga ngaru.” ");
INSERT INTO bnp_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Na tahuna a tuna bulmakau, a tuna sipsip, a tuna meme ni poda, ge laho turane kinana na parava ge polorua taro. Muri bara mu ngaru, mu bole lakea na dede mu habia, ge a nihabi ni gutu na kanono lakea ne BAKOVI DAGI. Iau bara ngarua. ");
INSERT INTO bnp_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Pali naha ni rabalaki a bulmakau turana e tuna, a sipsip turana e tuna, a meme turana e tuna na parava i taku kunana. ");
INSERT INTO bnp_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Na tahuna mu rata a nihabi mu gu kavurike e BAKOVI DAGI vona, mu ramai a vinara na nihabi bara ngaru a nihabi ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","A maka nihabi ni gi kani lobo na parava iea kunana. Naha ni gi ru ranga ni gi kani na hatelanga kuduvi. Iau e BAKOVI DAGI, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Iau e BAKOVI DAGI a ngaru mua, mu gu longototo mu gu ramai a maka vinara nau. ");
INSERT INTO bnp_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Naha ni vakahalea a ragu. Mua o huriki a kabu ne Israel, a ngaru mua lobo mu gu matakilaka nau a kiripiripi. Iau e BAKOVI DAGI a rata mua mu kiripiripi. ");
INSERT INTO bnp_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","A tuli tala mua o Egipto a taparaki valai mua koea, ge iau a Vure ne mua. Iau e BAKOVI DAGI, a takia a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","ge taki e huriki a Israel na maka habu dagi ne BAKOVI DAGI ri gi ramai, ge ta maea, “Na tahuna mu vapopo mu kavurike iau vona a parava nga a vulaki. ");
INSERT INTO bnp_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Mu tahoka a parava i polotara ni rata a leho. Pali na poloruana parava, a Parava Nimalo, naha ni leho vona. Mu vapopo mu kavurike iau. Na hini vai mu made vona mu luhoia a Parava Nimalo ne BAKOVI DAGI, mu ratea ge a parava nau. ");
INSERT INTO bnp_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Ngane ga taki mua vona a maka parava dagi e BAKOVI DAGI i vulaki, mu gu rata a habu vona. Na pida lobo mu vapopo vona a parava nga, mu vasileki. ");
INSERT INTO bnp_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Na parava ravulu a polona i va (14th) na mugana keva, ge vakatubu na haro i rolo, mu ratea a Habu na Nipagepolo. ");
INSERT INTO bnp_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Na parava ravulu a polona i lima (15th) na keva iea kunana, a Habu na Bret I Uka Is mu vakatubua. Na parava ge polorua mu kani a bret i uka ma ni vuli turana a is. ");
INSERT INTO bnp_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Na mugana parava na vik mu vapopo mu kavurike iau, naha ni rata a leho mu rata na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mu rata a nihabi ni gutu na kanono ne BAKOVI DAGI na parava ge polorua. Na poloruana parava mu vapopo tabu, mu kavurike iau. Na parava iea naha ni rata a leho mu rata bala.” ");
INSERT INTO bnp_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","ge taki e huriki a Israel, ge ta maea, “Na tahuna mu vano mu made vona a malala iau a habia ne mua, mu mirio a vit, mu bole lakea na prister a galesi na vit mu rotu muga. ");
INSERT INTO bnp_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Na parava muri na Parava Nimalo, a prister ge tabari e BAKOVI DAGI vona a nihabi nga, bara i ngaru mua. ");
INSERT INTO bnp_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Na parava mu tabaria a nihabi na vit, mu habi turana a tuna sipsip ge gavutuvutu, ge tahoka a pida i taku, ge a nihabi gutu-vuro ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Mu bole a kilo na plaoa ge rua, mu vuli turana a namona oliv, ge a nihabi na vit ni gutu na kanono ne vona e BAKOVI DAGI. Mu habi turana a nihabi ni gutu-vuro, i manginoro a mangina. Mu bole a lita na vain ge taku, ge a nihabi na vain, mu habi turana a nihabi nga i rua. ");
INSERT INTO bnp_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Pali mua, i uka ma mu bole valai nau, iau a Vure ne mua, a galesi na vit nga, naha ni kani a vit mu bole karaba na hania. Na tahuna mu habi pali, ngane mu kara ni kani a bret i uka is, o ni vuli turana a is. Ra vinara nga, ge ramai vakaroro e huriki a hamone mua muri ma. ");
INSERT INTO bnp_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“I tubu na parava muri na Parava Nimalo, ra parava mu tabari iau vona a galesi na vit, mu gi a vik ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Mu gi a parava ge ravulu lima, muri na vik i polorua ge lobo, mu habi tabua a nihabi na vit karaba ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Mu bole tala na hini mu made vona a balena bret ge rua, ra bret mu rata na kilo i rua na plaoa kamumu, mu vuli turana a is, mu gutu. Muri mu tabari iau e BAKOVI DAGI vona a nihabi na kanena maki i moro muga. ");
INSERT INTO bnp_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Mu habi turana maki ranga, ra bret iea. Mu habi a tuna sipsip ge polorua, a pida na viri taku i taku, a bulmakau a toga, a sipsip a toga ge rua. A sipsip, a bulmakau nga ri gi gavutuvutu, mu habi nau ge a nihabi ni gutu-vuro. Mu habi turana a nihabi na vit, a nihabi na vain. Ra nihabi maea i huli kamumu a mangina, a ngaru hatekea. ");
INSERT INTO bnp_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Mu bolea tara meme a toga, mu rata a nihabi na naro hale. A sipsip a toga ge rua, a pida ne rua ge taku, ge a nihabi na nivalemu. ");
INSERT INTO bnp_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","A prister ge bole a maki nga ge tabari e BAKOVI DAGI vona, turana a bret ni rata na vit i moro muga. Ra nihabi nga, a maki nau kunana, bara habi ne huriki a prister. ");
INSERT INTO bnp_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Na parava mu ratea a nihabi iea, mu vapopo mu vasileki. Naha ni rata a leho mu rata bala vona a parava iea. E huriki a hamone mua ri bele muri ma, na hini vai ri made vona, ri gi ramai vakaroroa a vinara iea. ");
INSERT INTO bnp_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Na tahuna mu mirio a vit na malala ne mua, naha ni bole a vit na harena hania. Naha ni hamule tabu ni poi a masigo. Ge tabuli vonga ngi, ge bole e huriki a matasia, e huriki a mosi. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","E BAKOVI DAGI i takia e Moses ");
INSERT INTO bnp_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","ge taki e huriki a Israel, ge ta maea, “Na mugana parava na poloruana keva naha ni leho, mu malo. Na tahuna mu longo a nangina tavure, mu vapopo mu vasileki. ");
INSERT INTO bnp_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Na parava iea naha ni rata a leho mu rata vakaroro, pali mu bole a nihabi ni rata na kanono mu habi nau.” ");
INSERT INTO bnp_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Na ravuluna parava na poloruana keva, mu vapopo mu ratea a habu ni kavitagu e huriki. Na parava iea mu vapopo, mu vasileki. Mu peremu ni kani, mu habi a nihabi ni gutu na kanono ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Naha ni leho vona a parava iea, a vuhuna ia a Parava na Nikavitagu. A prister ge rata a nihabi ni kavitagu mua na matane BAKOVI DAGI a Vure ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","A viri i uka ma i vakaperemua na parava iea, bara ni lili tala na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","E rei a bakovi i rata a leho vona a parava iea, bara ratapilea. ");
INSERT INTO bnp_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Naha ni ratea tara leho. Mu ramai vakaroroa a vinara iea. E huriki a hamone mua ri bele muri ma, na hini vai ri made vona, ria ranga ri gi ramaia a vinara iea. ");
INSERT INTO bnp_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Mu malo kamumu vona a parava iea. Ra habu iea ge vakatubu na polovana parava na malunga liu, ge harena na malunga liu tabu na ravuluna parava. Na parava iea naha ni kania tara maki, naha ni vakavivi mua vona tara maki.” ");
INSERT INTO bnp_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","ge taki e huriki a Israel, ge ta maea, “Na parava i ravulu a polona i lima, na poloruana keva mu vakatubua a Habu na Kape ne BAKOVI DAGI. Mu made na maka kape na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Na mugana parava na vik iea, mu vapopo mu vasileki, naha ni rata a leho mu rata na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Na parava lobo na vik iea mu ratea a nihabi ni gutu na kanono ge lakea ne BAKOVI DAGI. Na polotoluna parava mu vapopo tabu mu kavurike iau, mu ratea a nihabi tara ni gutu na kanono ge lakea ne BAKOVI DAGI, mu vakaloboa a habu iea. Na parava iea naha ni rata a leho mu rata na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Iau a vulaki a parava nga, ge ria a habu ne BAKOVI DAGI. Mu vapopo mu vasileki, mu habi a nihabi ni gutu-vuro, a nihabi na vit, a nihabi na vain, a nihabi ranga na parava nga. ");
INSERT INTO bnp_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ra nihabi nga ni rata langa tabu na nihabi na Parava Nimalo ne BAKOVI DAGI, ranga maki mu habi nau, a nihabi na nita muholi, turana a nihabi na ningaru ne mua.” ");
INSERT INTO bnp_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","E BAKOVI DAGI i taki tabua e Moses na Habu na Kape, i ta maea, “Na parava ravulu a polona i lima na keva polorua, muri kunana ne mua mu mirio, mu ratea a habu ne BAKOVI DAGI na parava ge polorua. Na mugana parava, na polotoluna parava na habu mu malo, naha ni leho. ");
INSERT INTO bnp_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Na mugana parava mu bole ranga kanena kai kamumu, a pagana niuniu, a rahana kai i paga bolabola, a rahana kai i paga madilidili, mu pitei na matane BAKOVI DAGI na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Na pida lobo na poloruana keva mu rata a habu ne BAKOVI DAGI na parava ge polorua. E huriki a hamone mua, ria ranga ri gi ramaia a vinara iea. ");
INSERT INTO bnp_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mua a tahotanga o Israel mu made na kape na hania na parava ge polorua, ");
INSERT INTO bnp_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","lakea e huriki a hamone mua bara ri lohoka vona a tahuna a tuli tala mua o Egipto mu valai koea, mu made na maka kape kiroko maea. Iau e BAKOVI DAGI, a Vure ne mua, a takia a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","E Moses i longo a ngava nga, i vakalongo e huriki a Israel vona a maka habu i vulaki e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“O vakuku e huriki a Israel ri gi bole valai a namona oliv, ne vona a maka lam ri tabuli pololilo na kape nau. E huriki a prister ri gi nami na rodo vakaroro a lam nga. ");
INSERT INTO bnp_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","E Aron ge nami ria na malunga liu, ri gi para na rodo ge harena na hatelanga pokopoko. A lam nga ri gi tabuli polovavo na kala dagi i naviri mule a Tava na Ngava Dagi na Kape na Vaponga. A vinara iea, a habia ne mua, mu gu ramai vakaroroa. E huriki a hamone mua ranga, ri gi ramaia. ");
INSERT INTO bnp_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","E Aron ge matakari kamumu a maka lam ri tabuli langa na butu ni rata na gol kabakaba, ri gi para vakaroro na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“O bole a plaoa kamumu o rata a bret ge ravulu a polona i rua. O guru tala a kilo ge rua na plaoa, o ratea a bret ge taku. ");
INSERT INTO bnp_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Muri o ru a bret nga na dede ni rata na gol na matagu. O ru na tete ge rua a maka bret, a bret ge polotara na tete i taku. ");
INSERT INTO bnp_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","O ru ranga havu mangisipa ni gi rungani, ge huli a mangina turana a tete na bret ge rua, muri ri gi habi ne BAKOVI DAGI a havu mangisipa, ge a nihabi ni gutu na kanono, ge ratea e BAKOVI DAGI ge luhoi mule ra bret nga. ");
INSERT INTO bnp_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","E Aron ge ru na dede na matane BAKOVI DAGI a maka bret na Parava Nimalo lobo. A nihabi iea, a nihabi ne huriki a Israel, ri gi ramai vakaroroa a ngava dagi iea, ri gi ratea a naro iea. ");
INSERT INTO bnp_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ra bret nga ne vona e Aron turane huriki a prister na kabu vona. Ri gi kani pololilo na Tabeke Nitaba, a vuhuna ra maki ni kani nga a kalavana nihabi ni taba hateka, ni gutu na kanono ni habi nau. Ra kalavana nga, ne vona e huriki a prister ri gi kani vakaroro.” ");
INSERT INTO bnp_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","A bakovi tara, e tamana a Egipto, e kinana a Israel. A rane kinana e Selomit, e tune Dibri na kabu ne Dan. Re tune Selomit i made na mada, i vaubi turana a Israel tara. Na tahuna ru vaubi, ra bakovi iea i kurahi a rane BAKOVI DAGI i harogia. Muri ri turari lakea ne Moses. ");
INSERT INTO bnp_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Lakea e Moses i ru dilia na bavi, ge davea e BAKOVI DAGI, ge takia na a ra naro ge rata virihia vona. ");
INSERT INTO bnp_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Lakea e BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“O turari talea na mada a bakovi iea. E huriki ri longoa i harogi iau, ri gi ru langa na gina a limane ria. Ri rata mavonga, ri gi vakasiria ra bakovi iea i tahoka a maregoa pali, ri gi padimatea na kedo. ");
INSERT INTO bnp_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Muri o taki e huriki a Israel, e rei a viri i harogi iau, i tahoka a ngava. Bara i bole a vuranga vona. ");
INSERT INTO bnp_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","A Israel, o a mosi i kurahi a ragu na tahuna i harogirogi, ra bakovi iea ni gi padimate na kedo. ");
INSERT INTO bnp_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“E rei a viri i rabalaki a bakovi, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","E rei a viri i rabalaki a kanirau na bakovi tara, ge kolia a kanirau na bakovi iea. ");
INSERT INTO bnp_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Bara bakovi i ratapile a kakaina viri, mu koli mu ratapilea a kakaina. ");
INSERT INTO bnp_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Bara bakovi i ubiputu a tuhana viri, mu koli mu ubiputua a tuhana. A bakovi i ratapile a matana viri, mu koli mu ratapilea a matana. A bakovi i ubisigo a ngina viri, mu koli mu ubisigo a ngina. A bakovi i rata hale navai a viri, mu koli mu rata mavongea. ");
INSERT INTO bnp_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","A bakovi i rabalaki a kanirau, ge kolia a kanirau i rabalakia. Pali a bakovi i rabalaki a viri, a bakovi iea ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ra vinara iea ne vona e mua e huriki a tahotanga ne Israel, turana a mosi ri made turane mua. Iau e BAKOVI DAGI, a Vure ne mua, a takia a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Muri e Moses i taki e huriki a Israel, ri turari talea ra bakovi i harogia a Vure, ri padimatea na kedo. Na naro iea kunana e huriki a Israel ri ramaia a vinara e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","E BAKOVI DAGI i takia e Moses na lolo e Sinai, ");
INSERT INTO bnp_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","ge taki e huriki a Israel, ge ta maea, “Na tahuna mu made pali vona a malala a habia ne mua, na poloruana pida lobo naha ni varo a maki ni kani na hania. Ge tabuli tavula a malala. A malala ge malo, ge manga a hini mu malo na Parava Nimalo. Mu rata mavonga, mu togoa a pida iea, a vuhuna a pida ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Na pida i polotara mu varo a maki ni kani, mu puri kamumu a rahana vain, mu ru kadolu a kanena maki ni varo na hania. ");
INSERT INTO bnp_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Pali na poloruana pida naha ni leho vona a malala, ge malo. Pali ra pida iea a pida ne BAKOVI DAGI. Naha ni varo a maki ni kani, naha ni puri a rahana vain ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Naha ni mirio a vit i rike tavula, naha ni pasi a kanena vain i uka ma ni puri a rahana. Mu mata taro ge tabuli, a vuhuna na pida iea a malala ge malo. ");
INSERT INTO bnp_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pali na pida iea a maki ni kani ri rike tavula na malala ne vona ni kani kunana. I uka ma ne vona ni ru palupu, o ni gi rata a vain vona. Mua, turana a vora ne mua, e huriki a mosi, mu kani. ");
INSERT INTO bnp_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","A maka bulmakau, a sipsip, a meme, a kanirau ri tegi, ria ranga ri gi kani. ");
INSERT INTO bnp_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Balaka polorua mu gi a pida ge polorua, ge bele na pida i ravulu va a polona i polova (49). ");
INSERT INTO bnp_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Muri na ravuluna parava na poloruana keva, mu pupu a tavure na tabeke lobo na robo ne mua. Ra parava iea a parava dagi ni kavitagu e huriki. ");
INSERT INTO bnp_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","A pida i ravulu lima (50) ge vakatubu na tahuna mu vaki a tavure vona, ra pida iea a pida ne BAKOVI DAGI. Mu vakalongo e huriki vona a maregoa ne ria i lobo ngane, ri gi made kamumu. Na pida iea a viri i kona a malala na bakovi tara, ge habi mulea na tahona, o ge habi mulea na hamona tara. E huriki a vora ri gi pe a tahone ria, ri gi hamule mai a kabu ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ra ravulu limana pida (50th), a pida ne huriki lobo ri gi made kamumu ri gi vivi. Na pida iea naha ni varo a maki ni kani na malala ne mua, naha ni bole a vit i rike tavula, naha ni pasi a kanena vain na rahana i uka ma ni puri. ");
INSERT INTO bnp_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mu luhoi kamumu, ra pida iea, a pida ni vaki a tavure, a pida nau kunana. Mu kani kunana a maki i rike tavula na malala ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Na Pida na Nihabimule a Maki iea mua e huriki mu habi a malala ni kona, mu bole mule a malala ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","15","“Na tahuna mu habi a malala ne huriki ranga ri gi konea, mu luhoi kamumu i riva a pida i tababana ge bele vona a Pida na Nihabimule a Maki. Mu gi kamumu, ge balaka riva ge varo a maki, ge mirio, lakea a mapana malala ge ramai i riva a pida i tababana. ");
INSERT INTO bnp_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","A pida i kupo i tababana, a mapana ge rike. A pida i popote i tababana, a mapana ge puru, a vuhuna i uka ma i kona a malala, i kona a maki ni kani i bole vona a malala iea. ");
INSERT INTO bnp_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Naha ni tami a turamu. Mu mangenge na Vure ne mua, mu rata a maka naro kamumu kunana. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“I mavonga mu ramai kamumu a maka ngava, a vinara ne BAKOVI DAGI. Bara mu rata mavonga bara mu made kamumu vona a malala iea. ");
INSERT INTO bnp_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","A malala bara i vakabele a maki ni kani i kupo, bara mu made kamumu hateka vona a malala iea. ");
INSERT INTO bnp_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ma ge ranga ne mua ge nana maea, ‘A ra mi gi kania vona na poloruana pida na tahuna i uka ma mi varo a maki ni kani?’ ");
INSERT INTO bnp_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Naha ni loho lege lae. E BAKOVI DAGI bara i gamai a malala na polotarana pida, ge bele kupo a maki ni kani, mu kani na pida i tolu. ");
INSERT INTO bnp_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Na tahuna mu varo a maki ni kani na polotoluna pida, bara mu tababana ni kani a maki mu mirio na polotarana pida. Bara mu tahoka a maki ni kani i harena na maki ni kani karaba i moro na polovana pida. ");
INSERT INTO bnp_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Na tahuna a bakovi i kona a malala, nahea ge bolea ge ne vona liu. A vuhuna i uka ma malala vona. A malala ne nau, a ru mua mu gu made vona, manga a mosi ni vakamade tamilalu na malala. ");
INSERT INTO bnp_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","A bakovi tara ne mua i konamulea a malala ne mua, ge lohoka kamumu vona, a tahona malala i ngaru ni konamulea ge bole mulea a malala. ");
INSERT INTO bnp_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Bara bakovi tara i bala maki i ngaru ni habi a malala vona ni gi kona, a kabu vona muholi ge koria ge konamulea, muri ge habi mulea vona. ");
INSERT INTO bnp_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Bara bakovi i uka viri vona ge tuhoria, ia kunana ge konea. Na tahuna i kupo a maka moni vona, ge konamulea a malala iea. ");
INSERT INTO bnp_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Ge gi i riva a pida i tababana ge kona a maka pida ni koli a maki nga, ge gi i riva a mapana a kanena maki ni varo ge vakabele a malala na pida nga. Ge bole a moni ga mapana kanena maki nga, ge habi na bakovi i kona a malala vona hosi, ge bole mulea a malala iea. ");
INSERT INTO bnp_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pali a bakovi iea ge uka moni, i uka ma i konamulea a malala iea, a malala ge tabuli na bakovi i konea, ge harena na Pida na Nihabimule a Maki ge bele tabu muri ma. Na tahuna a pida iea i bele, a bakovi i kona a malala ge habi mulea na tahona a malala. ");
INSERT INTO bnp_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Bara bakovi i tahoka a ruma i pesi na tanga dagi ni tura halui na nure, i konea a bakovi tara, a tahona i tahoka a pida i taku ni konamulea a ruma vona. ");
INSERT INTO bnp_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Bara pida i taku i lobo, lakea i uka ma i konamulea a ruma, ra ruma iea ngane ne vona a bakovi i konea turane huriki a hamona. I uka ma ge habi mulea na Pida na Nihabimule a Maki. ");
INSERT INTO bnp_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pali a maka ruma ri pesi na tanga kiroko i uka ma ni tura halui, mu luhoi kamumu, ri manga kunana a hania. A tahona ruma i kara ni konamulea a ruma vona. Na Pida na Nihabimule a Maki a bakovi i konea pali a ruma, ge habi mulea na tahona a ruma. ");
INSERT INTO bnp_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Pali e huriki a Levi nahea ri gi ramaia a vinara iea. Ria ri ngaru ni kona mule a ruma na tanga dagi ni tura halui a nure, bara ri kona mule. ");
INSERT INTO bnp_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Na tahuna a Levi tara i habi a ruma vona ni kona, pali i marikoi ni konamulea, ra bakovi i konea a ruma ge habi mulea na Levi na Pida na Nihabimule a Maki a ruma, a vuhuna mua lobo a Israel e BAKOVI DAGI i habi a malala ne mua, pali e huriki a Levi i uka ma i habi a malala ne ria. I habi kunana a maka tanga dagi ne ria. A maka ruma ri pesi na maka tanga dagi ne vona e huriki a Levi kunana vakaroro. ");
INSERT INTO bnp_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Pali a malala na harena maka tanga dagi ne huriki a Levi, nahea ge kona e huriki. Ra malala ngi ne vona e huriki a Levi vakaroro. ");
INSERT INTO bnp_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Na tahuna a Israel tara i made tabukoi vomu i bala maki, o tuhoria ge manga a naro mu rata virihi e huriki a mosi vona. Mu rata mavonga a hulu matasia bara i vivi ni made turane mua. ");
INSERT INTO bnp_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","37","Na tahuna i bole a moni ne mua, ge koli kunana a moni i bole. Naha ni takia ge ru langa tabu ranga. Na tahuna i kona a maki ni kani, naha ni vakarike hateka a mapana ni bole a moni dagi vona. Mu mangenge vona a Vure, bara a hulu matasia i made turane mua. ");
INSERT INTO bnp_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Iau e BAKOVI DAGI a Vure ne mua. A tuli tala mua o Egipto, a taparaki valai mua koea, a habia ne mua a robo e Kenan, ge iau a Vure ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Na tahuna a turamu tara i matasia hateka, i ngaru mua mu gu konea ge ia a vorakato, naha ni takia ge rata hateka a leho manga e huriki a vorakato. ");
INSERT INTO bnp_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ge made turane mua, manga a vora. Ge leho ne mua, ge harena na Pida na Nihabimule a Maki. ");
INSERT INTO bnp_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Na pida iea, ia turane girihina, e huriki e tuna ri gi pe mua, ri gi hamule mai a kabu ne ria ri made na malala ne tubune ria. ");
INSERT INTO bnp_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Hosi e huriki a Israel ri made manga a vorakato o Egipto. Muri a tuli tala ria vonga, ge ria a vora nau. Ngane naha ni kona mule a viri ne ria ge a vorakato ne ria. ");
INSERT INTO bnp_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Naha ni vakavora hateka ria. Mu togo iau, mu rata kamumu ria. ");
INSERT INTO bnp_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Mu ngaru ni bole a vorakato, mu bole tala na maka robo basi. ");
INSERT INTO bnp_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Mua mu ngaru tabu, mu kona e huriki a mosi ri made na tanga ne mua, turana a kabu ne ria ni poda ria na malala ne mua, ge ria a vorakato ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Na tahuna mu mate, e huriki e tune mua a bakovi ri gi bole e huriki a vorakato, ri gi rata a leho ne ria vakaroro. Na tahuna e huriki a viri ne mua ri leho manga a vorakato, naha ni vakavora hateka ria. ");
INSERT INTO bnp_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Na tahuna a mosi tara i tahoka hateka a mahala i made turane mua, pali a turane mua tara i bala a mahala, ra mosi iea i kara ge konea a turane mua ge a vorakato vona, o ge ia a vorakato na kabu vona tara. ");
INSERT INTO bnp_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Muri na mosi i konea a Israel iea, ge ia a vorakato vona, a viri vona tara i kara ni konamulea, ");
INSERT INTO bnp_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","o e tamana tara, o e turana tara, o a viri na kabu vona tara, ria ranga ri kara ni konamulea. Pali ra bakovi iea ge tahoka a moni, bara i kara ni kona mule ia, ge vano. ");
INSERT INTO bnp_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ge gi palupu a maka pida ri tababana ge harena na Pida na Nihabimule a Maki. A matakari iea ge ru a mapana a vora na pida nga. Ra bakovi iea o a kabu vona tara, ge konamulea na mapa ge maea: ");
INSERT INTO bnp_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","a pida vona i kupo i tababana, a bakovi iea ge koli mule a moni i kupo lakea na matakari, ge kona mule ia; ");
INSERT INTO bnp_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","a pida vona i popote i tababana na Pida na Nihabimule a Maki, ge koli mule a moni popote lakea na mata­kari, ge ramai a maka pida i leho vona, ge kona mule ia. ");
INSERT INTO bnp_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","A matakari ge luhoia ra vorakato iea ge manga a vora ni kona na pida takutaku, nahea ge vakavora hatekea. ");
INSERT INTO bnp_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Ra bakovi iea i uka ma ni kona mule vona tara naro iea, ia turane huriki e tuna ri gi hamule mai a kabu ne ria na Pida na Nihabimule a Maki. ");
INSERT INTO bnp_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Naha ni mata taroa tara Israel ge ia a vorakato vakaroro, a vuhuna iau a tuli tala mua o Egipto, a taparaki valai mua koea, ge mua a vora nau. Iau e BAKOVI DAGI a Vure ne mua, a takia a ngava iea.’” ");
INSERT INTO bnp_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","E BAKOVI DAGI i taki tabua e Moses, ge taki e huriki a Israel, ge ta maea, “Naha ni kau na kai na kedo a hanuna vure ranga, o mu gu bole a kedo dagi mu gu vakapesi, ge a vure ne mua mu gu turume na ngalana, a vuhuna iau e BAKOVI DAGI a Vure ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Naha ni leho na Parava Nimalo. Mu togoa a mailo nau. Iau e BAKOVI DAGI, a takia a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Mua bara mu ramai a vinara nau, mu rata a maki a ngaru mu gu rata, ");
INSERT INTO bnp_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","bara ratea a vala i boru, i rata a maki ni kani ri rike kamumu na malala ne mua. A maka kai bara ri vua kamumu. ");
INSERT INTO bnp_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","A maki ni kani bara ri bele kupo. Bara mu mirio mavonga a vit i harena na tahuna a vain i rara ni pasi. Bara mu pasi mavonga a kanena vain i rara, i harena na tahuna mu varo tabu a vit. Bara mu kani mu maru, mu made kamumu na malala ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Iau bara habi a nivalemu ne mua mu made kamumu. Na tahuna mu mahita, i uka ma mu gu mangenge vona tara maki. Ga lili vuroki a maka livoa hateka na robo ne mua. E huriki a pile i uka ma ri gi ratapile mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Na tahuna mu vaubi turane huriki a pile, bara mu valili ne ria, mu ratapile ria. ");
INSERT INTO bnp_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","A bakovi i ala lima ne mua bara ri valili na pile ala ravulu mule ma murina balaka taku (100). A bakovi i ala ravulu mule ma murina balaka taku (100) ne mua bara ri valili na pile ala ravulu rangale (10,000), ri ratapile ria. ");
INSERT INTO bnp_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Iau bara rata kamumu mua, a habi ne mua e huriki e tune mua ri ala kupo. Bara vakatorea a ngava dagi a takia ne mua hosi. ");
INSERT INTO bnp_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","A maki ni kani mu mirio na pida muga, bara i tabuli i harena na pida muri. A maki mu kani kaleva, bara mu vuroki tala, mu bole a maki ni kani karaba, mu ru na murine ria. ");
INSERT INTO bnp_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Iau ga made na mailo nau na kurukurune mua, i uka ma ga ngalahere ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ga laho turane mua, ge iau a Vure ne mua, mua ge mua e huriki a tara nau. ");
INSERT INTO bnp_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Iau e BAKOVI DAGI a Vure ne mua. Hosi mua a vorakato o Egipto ni vakavora hateka, muri a tuli tala mua vonga, a taparaki valai mua koea, lakea i uka ma ge mua a vorakato tabu ne ria. A ratapilea a nitora na bakovi i vakavora hateka mua, ngane mu laho na pesivahane mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Pali mua mu longotaro a ngavagu i uka ma mu ramai a vinara nau, ");
INSERT INTO bnp_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","mu putu puru a vinara nau, mu ngalahere na ngavagu, mu longotaro a ngava dagi a rata turane mua, ");
INSERT INTO bnp_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","bara vakamadihi mua maea: bara vakamangenge hateka mua, a habi a gilanga dagi ne mua, ra gilanga iea bara i rata a kuline mua i rongo, bara mu kepa, ge ratea a kakaine mua i malosi. Bara mu varo a maki ni kani na hania, pali i uka ma mu gu kani a kanena, a vuhuna e huriki a pile bara ri valai, ri kani a maki mu varo. ");
INSERT INTO bnp_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Iau bara iau a pile ne mua. E huriki a pile bara ri valai, ri vaubi turane mua, ri ratapile mua, ri matakari mua. Na tahuna i uka viri ge valili ne mua, bara mu mangenge tavula mu ha. ");
INSERT INTO bnp_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Muri na tahuna a vakamadihi mua na naro nga, pali i uka ma mu ramai tabu a ngavagu, bara vakamadihi hateka mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Bara ratapile a tagenga, a nitora ne mua. A vala i uka ma ge boru, a malala bara i tora manga a kedo. ");
INSERT INTO bnp_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","A maki ni kani i uka ma ri gi koru rike na hania, a maka kai i uka ma ri gi vua. A tuhakanga ne mua bara i lobo tavula. ");
INSERT INTO bnp_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Na tahuna a maka maregoa nga ri bele ne mua, pali mu tababana ni tagege, bara luhoi a maka naro hale mu rata, a habi mua a maregoa hale, i dagi hateka na maregoa muga. ");
INSERT INTO bnp_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ga rudu a maka livoa hateka ri gi lakene ri gi rabalaki e huriki e tune mua, a maka bulmakau ne mua, ga rata mua mu ala popote, i uka viri ge laho na dala ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Muri na tahuna a vakamadihi maea mua, i uka ma mu longototo a nitagu, mu tababana ni tagege, ");
INSERT INTO bnp_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","bara luhoi a naro hale ne mua, a ratapile mua hateka tabu. ");
INSERT INTO bnp_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mu ratapilea pali a ngava dagi, ngane ga rudu e huriki a pile ri gi vaubi turane mua. Na tahuna mu made pololilo na tanga dagi ni tura halui, mu luhoi ta mu made kamumu, pali bara rudua a gilanga dagi i ratapile mua. Na tahuna mu bole a maregoa na gilanga, bara habi mua na limane huriki a pile ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Na tahuna iea bara vakaperemu mua na maki ni kani. A ngatavine ala ravulu bara ri vatunu vona a kanono i taku, ri gutu a maki ni kani popote. Muri bara mu vaveru, mu kani, pali i uka ma mu gu maru. ");
INSERT INTO bnp_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Muri na hini a rata a naro nga, pali mu tababana ni tagege mu longotaro a ngavagu, ");
INSERT INTO bnp_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","bara tahate hateka na naro hale mu rata, iau kunana a habi a nimadihi dagi hateka ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Muri bara mu vitolo hateka, mu rabalaki mu kani e huriki e tune mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Iau bara ratapile a maka roho na nivasileki na maka vure ne mua meli na lolo, bara puka a maka dede na havu mangisipa. Bara rabalaki mua, a voro rike a podane mua na hanuna vure a ratapile muga pali. Lakea bara marikoi hateka ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ga ratapile a tanga dagi, a roho na nivasileki ne mua. I uka ma ga ngaru a maka nihabi mu rata. ");
INSERT INTO bnp_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ga ratapile hatekea a malala ne mua. Na tahuna e huriki a pile ne mua ri bolea a malala iea ri made vona, bara ri turutu vona a maki i bele vona. ");
INSERT INTO bnp_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Bara rata e huriki a pile ri vaubi turane mua, ri lili tala mua, mu vapida lae mu mariu lakea na maka tanga basi. A malala ne mua bara i tabuli tavula, a maka tanga dagi ne mua bara ni ratapile. ");
INSERT INTO bnp_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","“Na tahuna mu made na malala ne huriki a pile, a malala ne mua bara i tabuli tavula i malo. Muga na tahuna mu made vona a malala iea, i uka ma mu habi a nimalo vona a malala na poloruana pida ge ramai a ngava a taki. Pali na tahuna a malala i tabuli tavula, bara i malo kamumu. ");
INSERT INTO bnp_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Na tahuna mu made na robo ne huriki a pile, bara rata mua mu mangenge hateka. Bara mu longo tavulea a nangina vilu i ngalu a pagana kai, bara mu ha, i manga ni valili ne mua na tahuna na vabinga. Na tahuna mu ha, bara mu boru, mu ratapile lae mua na tahuna i uka viri ge valili ne mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Bara mu boru langa, mu tabuli taho lae mua, i manga a viri i lele a bainat na vabinga, pali i uka viri ge valili mua na bainat. Na tahuna e huriki a pile ri ngaru ni vaubi turane mua, bara mu keri ni vaubi turane ria. ");
INSERT INTO bnp_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Muri bara mu mate na robo ne huriki a pile, a malala ne ria bara i todo mua. ");
INSERT INTO bnp_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","E huriki ranga ne mua ri tababana na robo ne huriki a pile, bara i takutaku i bole a vuranga i lobo tavula, a vuhuna e huriki a gare ne mua ri rata a maka naro hale. ");
INSERT INTO bnp_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Pali muri e huriki ne mua bara ri taki tala a naro hale ne ria, ne huriki a gare ne ria, a vuhuna ra ri tagege ri longotaro a ngavagu. ");
INSERT INTO bnp_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Mu tagege, lakea iau a vakamadihi mua, a rudu lakea mua na robo ne huriki a pile. Pali na tahuna e huriki a hamone mua ri hatakia pali a nimadihi na naro hale, ri pulo a vilone ria ri duku. ");
INSERT INTO bnp_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Muri bara luhoi mulea a ngava dagi a ratea turana e Iakop, e Isak, e Abraham, ga luhoi mulea a malala e Kenan. ");
INSERT INTO bnp_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Pali muga mu pe purua a malala ge malo na pida ge kupo, ge bole a murina a maka pida i uka ma mu ru a malona a malala ge malo. Mu bole a nimadihi na naro hale mu rata, na hini mu ngalahere na maka vinara mu longotaro a ngavagu. ");
INSERT INTO bnp_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Na tahuna mu made na robo ne huriki a pile, i uka ma ga pe puru mua liu, o ga ratapile lobo mua. Ma ga rata mavonga, a ngava dagi a rata turane mua bara i lobo tavula. Iau e BAKOVI DAGI a Vure ne mua, i uka ma ga ratea a naro maea. ");
INSERT INTO bnp_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ga luhoi mua, ga luhoi tabua a ngava dagi a ratea ne huriki e tubune mua. A vakasiri a nitora dagi nau na maka tanga lobo, na tahuna a tuli tala ria na robo e Egipto, a taparaki valai ria koea. A bole valai ria nau, ge iau a Vure ne ria. Iau e BAKOVI DAGI, a takia a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","A vinara nga e BAKOVI DAGI i habi ne Moses na lolo e Sinai, ge ramai e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","ge taki e huriki a Israel, ge ta maea, “A viri i ta muholi ge habi ranga viri lakea nau, ge habi na prister ranga moni ge vakatorea a nita muholi vona. ");
INSERT INTO bnp_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ge pasia a mapana bakovi o ngatavine vona ge maea: a bakovi i tahoka a pida i ravulu rua, i harena na pida i ravulu polotara (60), ni gi kona na moni silva i 50, i ramai a nimavana moni na mailo ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","A ngatavine i tahoka a pida i ravulu rua, i harena na pida i ravulu polotara (60), ni gi kona na moni silva i 30. ");
INSERT INTO bnp_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","A viri i tahoka a pida i lima, i harena na pida i ravulu rua, a bakovi ni gi kona na moni silva i 20. A ngatavine ni gi kona na moni silva i ravulu. ");
INSERT INTO bnp_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","A koma i tahoka a keva i taku, i harena na pida i lima, a koma bakovi ni gi kona na moni silva i lima. A koma ngatavine ni gi kona na moni silva i tolu. ");
INSERT INTO bnp_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","A viri a pida vona i rangi a pida i ravulu polotara (60), a bakovi ni gi kona na silva moni i 15. A ngatavine ni gi kona na silva moni i ravulu. ");
INSERT INTO bnp_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Na tahuna a bakovi i ratea a nita tora iea, i uka moni ge kona mule ia, o ge kona mule a turana, a bakovi iea ge lakea na prister. A prister ge kali purua a mapana bakovi iea, bara i kara ni kona. ");
INSERT INTO bnp_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Bara bakovi i ta muholi ge habia ne BAKOVI DAGI tara kanirau ge a nihabi, ge habia a kanirau ra a taki mua vona ta mu gu habia. A kanirau maea mu habia ni taba. ");
INSERT INTO bnp_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ra bakovi iea, nahea ge kuloia a kanirau ge habia nau a viri nabatabuna. Nahea ge kuloia a kanirau nabatabuna ge habia nau a viri gavutuvutu. Ia ge rata mavonga, ra kanirau varago nga bara ne nau kunana. ");
INSERT INTO bnp_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","A kanirau i muto nahea ni gi habi ne BAKOVI DAGI. A kanirau maea ni gi bole lakea taro na prister. ");
INSERT INTO bnp_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","A prister ge masia a kanirau iea i muto o i kaba, ge takia a mapana. Ra mapana nahea ni gi pulo. ");
INSERT INTO bnp_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","A bakovi iea i ngaru ge konamulea ra kanirau iea, ge konamulea na moni i takia a prister, ge ru langa tabu ranga ( ). ");
INSERT INTO bnp_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Bara bakovi i habi a ruma vona i malamala lakea ne BAKOVI DAGI, a prister ge matai taroa a ruma iea i kamumu o i hale, lakea a prister ge takia a mapana. Ra mapana nahea ni gi pulo. ");
INSERT INTO bnp_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Bara bakovi iea ge ngaru ni konamulea, ge habi nau a mapana ruma, ge ru langa tabu ranga ( ). ");
INSERT INTO bnp_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Bara bakovi i habi ne BAKOVI DAGI a tabekena malala na kabu vona, a prister ge matai kamumua a malala, ge riva a vutuna vit ni gi varo vona a malala iea. A malala iea i kara ni gi varo vona a vutuna vit ge ravulu rua a kilo vona, a mapana malala iea ge a moni silva i ravulu lima (50). ");
INSERT INTO bnp_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Bara i habia nau na Pida na Nihabimule a Maki, a mapana ge tabuli mavonga, nahea ni gi pulo lae. ");
INSERT INTO bnp_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pali ia ge habia nau muri na Pida na Nihabimule a Maki, a prister ge gi palupu a maka pida ri tababana, ge bele na pida ni vakoli, ge kali purua a mapana malala iea. ");
INSERT INTO bnp_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Bara bakovi i habi a malala vona nau, ia ge ngaru ni konamulea a malala iea, ge konamulea na mapana i takia a prister, ge ru langa tabu ranga ( ). ");
INSERT INTO bnp_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Bara i uka ma i konamulea nau a malala iea, o i habia na bakovi tara i konea, ra malala iea i uka ma ni gi kona mule na tahuna a Pida Nivakoli i valai tabu. ");
INSERT INTO bnp_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Na tahuna a Pida na Nihabimule a Maki ge bele, a bakovi i konea a malala iea ge habia ne BAKOVI DAGI. Lakea ra malala iea ge tabuli ga malala nau liu, bara habia ne huriki a prister. ");
INSERT INTO bnp_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Bara bakovi i habia ne BAKOVI DAGI a hania i konea, i uka ma a tabeke na malala ne tubuna, ");
INSERT INTO bnp_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","a prister ge gi kadolu i riva a pida i tababana ge bele vona a Pida na Nihabimule a Maki. Ge takia a mapana malala ge harena vona a pida iea. Na pida iea kunana ge habia na prister a mapana malala. Ra mapana malala i malamala na matane BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Na Pida na Nihabimule a Maki, a bakovi ge habi mulea na tahona a malala vona. ");
INSERT INTO bnp_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","A mapana maki nga ni gi pasi ramai a moni na mailo ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Na tahuna mu habia ne BAKOVI DAGI a kanirau, naha ni bolea a tabua na kanirau, a vuhuna a tabua na maka kanirau ne BAKOVI DAGI. A tabua na bulmakau a sipsip, ngi ranga ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Pali bara tabua i podea a kanirau i muto, mu konamulea na mapana i takia a prister, mu ru langa tabu ranga ( ). Na tahuna a bakovi i marikoi ni konamulea a kanirau, a prister ge takia tara viri ge konea na mapana i takia. ");
INSERT INTO bnp_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Na tahuna a bakovi i ru herea tara maki ge ne vona e BAKOVI DAGI, i manga a bakovi, a ngatavine, a kanirau, a malala i bolea ne tubuna, nahea ge takia tara bakovi ge konea, ia tara i uka ma ge konamulea na prister, a vuhuna i malamala hateka a maki ni taba ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“A bakovi ni ru here ni gi ratapile, nahea ni gi kona mule, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“A maki ni kani ni varo na hania, i manga a vuana vit, a vutuna kai, mu ru kadolu na galesi ge ravulu. Muri mu habia nau e BAKOVI DAGI, a galesi ge taku i malamala na matagu. ");
INSERT INTO bnp_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Bara bakovi tara i ngaru ni kona mule ranga maki ni kani nga, ge konamulea na mapana, ge ru langa tabu ranga ( ). ");
INSERT INTO bnp_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Bara o tahoka a sipsip o a bulmakau i ravulu, o ru herea ge taku, ge malamala lakea ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ra kanirau o habia nau i kamumu o i hale, naha ni kuloia. Pali bara o kuloia ra kanirau nga, rua varago ru malamala, i uka ma ni gi kona mule.” ");
INSERT INTO bnp_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","A vinara nga e BAKOVI DAGI i habi ne Moses na lolo e Sinai, ge longo e huriki a Israel, ri gi ramai. ");
INSERT INTO bnp_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Na mugana parava na ruana keva na ruana pida muri ne huriki a Israel ri pea e Egipto, e BAKOVI DAGI i ta turane Moses pololilo na Kape na Vaponga na tabeke i ngeki ne Sinai. I ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Ioe turane Aron muru gi a rane huriki a bakovi ne Israel, muru here ramai a kabu ne ria, a rane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Muru here puru, ge ramai a tara ne ria, a rana e huriki a bakovi lobo o Israel ri tahoka a pida i ravulu rua i rike, ri kara ni vaubi, ge ria a nugumaheto. ");
INSERT INTO bnp_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Muru vulaki a bakovi a garena kabu takutaku ne Israel ge tuhori marua. ");
INSERT INTO bnp_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“A bakovi ri gi tuhori marua na leho, ra nga: na kabu ne Reuben, muru bolea e Elisur, e tune Sedeur. ");
INSERT INTO bnp_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Na kabu ne Simion, muru bolea e Selumiel, e tune Surisadai. ");
INSERT INTO bnp_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Na kabu ne Iuda, muru bolea e Nason, e tune Aminadab. ");
INSERT INTO bnp_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Na kabu ne Isikar, muru bolea e Nataniel, e tune Suar. ");
INSERT INTO bnp_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Na kabu ne Sebulun, muru bolea e Eliab, e tune Helon. ");
INSERT INTO bnp_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Ne tune Iosep na kabu ne Epraim, muru bolea e Elisama, e tune Amihud. Na kabu ne Manase, muru bolea e Gemaliel, e tune Pedasur. ");
INSERT INTO bnp_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Na kabu ne Bensamin, muru bolea e Abidana, e tune Gideoni. ");
INSERT INTO bnp_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Na kabu ne Dan, muru bolea e Ahieser, e tune Amisadai. ");
INSERT INTO bnp_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Na kabu ne Aser, muru bolea e Pagiel, e tune Okran. ");
INSERT INTO bnp_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Na kabu ne Gad, muru bolea e Eliasap, e tune Deuel. ");
INSERT INTO bnp_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Na kabu ne Naptali, muru bolea e Ahira, e tune Enan.” ");
INSERT INTO bnp_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Re huriki nga ni vulaki tala na vaponga. Ria e huriki a nupesi na maka kabu ne Israel. ");
INSERT INTO bnp_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","E Moses e Aron ru bole a gare nga ni vulaki. ");
INSERT INTO bnp_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Na mugana parava na ruana keva ri vapopo, lakea e huriki a gare ri gi palupu e huriki a bakovi ri tahoka a pida i ravulu rua i rike. Ri here na kabu ne tamane ria a rane ria, ");
INSERT INTO bnp_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","i ramai a ngava e BAKOVI DAGI i vakuku e Moses vona. Na tahuna e Moses i gi palupu a rane ria, e huriki a Israel ri made na tabeke i ngeki ne Sinai. ");
INSERT INTO bnp_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Na kabu ne Reuben, ra tabua ne Israel, ri bole e huriki a bakovi ri tahoka a pida i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","E huriki a bakovi na kabu ne Reuben, ni gi palupu lobo ri ala 46,500. ");
INSERT INTO bnp_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Na kabu ne Simion, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","E huriki a bakovi na kabu ne Simion, ni gi palupu lobo ri ala 59,300. ");
INSERT INTO bnp_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Na kabu ne Gad, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","E huriki a bakovi na kabu ne Gad, ni gi palupu lobo ri ala 45,650. ");
INSERT INTO bnp_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Na kabu ne Iuda, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","E huriki a bakovi na kabu ne Iuda, ni gi palupu lobo ri ala 74,600. ");
INSERT INTO bnp_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Na kabu ne Isikar, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","E huriki a bakovi na kabu ne Isikar, ni gi palupu lobo ri ala 54,400. ");
INSERT INTO bnp_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Na kabu ne Sebulun, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","E huriki a bakovi na kabu ne Sebulun, ni gi palupu lobo ri ala 57,400. ");
INSERT INTO bnp_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ne huriki a hamone Iosep, ra kabu ne Epraim, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","E huriki a bakovi na kabu ne Epraim, ni gi palupu lobo ri ala 40,500. ");
INSERT INTO bnp_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Na kabu ne Manase, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","E huriki a bakovi na kabu ne Manase, ni gi palupu lobo ri ala 32,200. ");
INSERT INTO bnp_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Na kabu ne Bensamin, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","E huriki a bakovi na kabu ne Bensamin, ni gi palupu lobo ri ala 35,400. ");
INSERT INTO bnp_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Na kabu ne Dan, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","E huriki a bakovi na kabu ne Dan, ni gi palupu lobo ri ala 62,700. ");
INSERT INTO bnp_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Na kabu ne Aser, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","E huriki a bakovi na kabu ne Aser, ni gi palupu lobo ri ala 41,500. ");
INSERT INTO bnp_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Na kabu ne Naptali, ri bole e huriki a bakovi a pida ne ria i ravulu rua i rike, ge ria a nugumaheto. Ri here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","E huriki a bakovi na kabu ne Naptali, ni gi palupu lobo ri ala 53,400. ");
INSERT INTO bnp_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","E huriki a nugumaheto nga, e Moses e Aron, ru gi palupu. E huriki a nupesi ala ravulu a polona i rua (12) ne Israel, ri kori rua na leho iea ni here puru a rane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","A bakovi a pida ne ria i ravulu rua i rike, ri kara ni tuhori a tara na vabinga ne Israel. Ni here a rane ria i ramai a kabu ne tamane ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","E huriki a bakovi, ni gi palupu lobo ri ala 603,550. ");
INSERT INTO bnp_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Na tahuna ni here puru a rane huriki, e huriki a bakovi na kabu ne Levi i uka ma ni here a rane ria, ");
INSERT INTO bnp_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","a vuhuna e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Na tahuna o here puru a rane huriki a Israel, naha ni here a rane huriki a bakovi na kabu ne Levi. Naha ni gi ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Pali, o habi a leho ne ria ri gi matakari a kape na Ngava Dagi turana a maka mahalana, ri gi rata a leho ne ria. Ri gi kalohoa a kape turana a maka mahalana, ri gi matakari. A maka kape ne ria ri gi vakapesi halui na kape nau. ");
INSERT INTO bnp_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Na tahuna mu mariu tala na mada mu gu lakea na mada tara, e huriki a bakovi ne Levi kunana ri gi pukea a kape, ri gi kaloho a maka mahalana. Na tahuna mu rata a mada karaba, ria kunana ri gi vakapesia a kape. E huriki na kabu ranga nahea ri gi valai tabukoi na kape. E rei a viri ge rata mavonga, mu rabalakia. ");
INSERT INTO bnp_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","A kabu ranga ne Israel ri gi vapopo turana kabu ne ria, ri gi vakapesi maka kape ne ria, ri gi vakabebe a kilakila na kabu takutaku ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Pali e huriki na kabu ne Levi ri gi vakapesi haluia a kape na Ngava Dagi, a maka kape ne ria ri gi tagaria, ma ge valai tabukoi vona tara viri, ge rata iau ga tahate ga vakabele a vuranga ne mua a Israel.” ");
INSERT INTO bnp_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Lakea e Moses i vakalongo e huriki a Israel vona a ngava iea, ri rata a maka maki i manga a ngava e BAKOVI DAGI i vakuku ia vona. ");
INSERT INTO bnp_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","E BAKOVI DAGI i taki e Moses e Aron i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Na tahuna e huriki a Israel ri gi rata a mada, a bakovi takutaku ge vakapesia a kape vona tabukoi na kilakila na kabu vona. A kape ne ria ri gi vakapesi halui a Kape na Vaponga, ge mata lakea vona. ");
INSERT INTO bnp_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Na tabeke na nirikena haro, e huriki a hamone Iuda ri gi vakapesi a kape ne ria tabukoi na kilakila ne ria, i ramai a tara ne ria. A gare ne ria e Nason, e tune Aminadab. ");
INSERT INTO bnp_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","A tara vona ri ala 74,600. ");
INSERT INTO bnp_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Tabukoi ne ria a kabu ne Isikar. A nupesi ne ria e Nataniel, e tune Suar. ");
INSERT INTO bnp_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","A tara vona ri ala 54,400. ");
INSERT INTO bnp_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Muri ne ria a kabu ne Sebulun. A nupesi ne ria e Eliab, e tune Helon. ");
INSERT INTO bnp_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","A tara vona ri ala 57,400. ");
INSERT INTO bnp_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","A kabu i tolu nga na mada ne Iuda ri ala 186,400. Na tahuna ni laho, a kabu nga bara to laho muga. ");
INSERT INTO bnp_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Na tabeke mule puru, a kabu ne Reuben ri gi vakapesi a kape ne ria tabukoi na kilakila ne ria. A nupesi ne ria e Elisur, e tune Sedeur. ");
INSERT INTO bnp_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","A tara vona ri ala 46,500. ");
INSERT INTO bnp_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Tabukoi ne ria a kabu ne Simion. A nupesi ne ria e Selumiel, e tune Surisadai. ");
INSERT INTO bnp_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","A tara vona ri ala 59,300. ");
INSERT INTO bnp_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Muri ne ria, a kabu ne Gad. A nupesi ne ria e Eliasap, e tune Ruel. ");
INSERT INTO bnp_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","A tara vona ri ala 45,650. ");
INSERT INTO bnp_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ra mada ne Reuben, a kabu i tolu nga, ri ala 151,450. Na tahuna ni laho, ri gi pahamuri a maka kabu na mada muga, ra kabu ne Iuda. ");
INSERT INTO bnp_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Na tahuna ri laho ri gi vakabebe ri gi vakasiri a kilakila ne ria. E huriki na kabu ne Levi ri gi kaloho a mahalana Kape na Vaponga ge laho na kurukuruna. A kabu ranga ri gi laho ramai a muri ne ria ri made vona na mada. ");
INSERT INTO bnp_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Na tabeke na nirolona haro a kabu ne Epraim ri gi vakapesi a kape ne ria tabukoi na kilakila ne ria ge ramai a tara ne ria. A nupesi ne ria e Elisama, e tune Amihud. ");
INSERT INTO bnp_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","A tara vona ri ala 40,500. ");
INSERT INTO bnp_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Tabukoi ne ria a kabu ne Manase. A nupesi ne ria e Gamaliel, e tune Pedasur. ");
INSERT INTO bnp_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","A tara vona ri ala 32,200. ");
INSERT INTO bnp_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Muri ne ria a kabu ne Bensamin. A nupesi ne ria e Abidana, e tune Gideoni. ");
INSERT INTO bnp_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","A tara vona ri ala 35,400. ");
INSERT INTO bnp_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","A kabu nga i tolu, ri made na mada ne Epraim ri ala 108,100. Na tahuna ri laho ri gi pahamuri a maka kabu na mada ne Reuben. ");
INSERT INTO bnp_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Na tabeke mule sike a mada ne Dan. A kabu ne Dan ri gi hae a kape ne ria tabukoi na kilakila ne ria. A nupesi ne ria e Ahieser, e tune Amisadai. ");
INSERT INTO bnp_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","A tara vona ri ala 62,700. ");
INSERT INTO bnp_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Tabukoi ne ria a kabu ne Aser. A nupesi ne ria e Pagiel, e tune Okran. ");
INSERT INTO bnp_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","A tara vona ri ala 41,500. ");
INSERT INTO bnp_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Muri ne ria a kabu ne Naptali. A nupesi ne ria e Ahira, e tune Enan. ");
INSERT INTO bnp_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","A tara vona ri ala 53,400. ");
INSERT INTO bnp_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","A kabu nga ri made na mada ne Dan ri ala 157,600. Na tahuna ni laho ri gi laho na iku, ri gi ramai a kilakila ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Iea e huriki a Israel ni gi palupu lobo i ramai a kabu ne tamane ria. Ni gi palupu lobo e huriki na mada takutaku i ramai a tara ne ria, ri ala 603,550. ");
INSERT INTO bnp_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Pali a kabu ne Levi i uka ma ni gi turane huriki a Israel, i ramaia a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","E huriki a Israel ri rata lobo a maki e BAKOVI DAGI i vakuku e Moses vona ri gi rata. E huriki lobo ri vakapesi a kape ne ria tabukoi na kilakila na kabu ne ria. Na tahuna ri laho, bara ri laho turana a kabu ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Na tahuna e BAKOVI DAGI i ta turane Moses na lolo e Sinai, a kabu ne Moses e Aron i maea: ");
INSERT INTO bnp_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","E Aron i tahoka e tuna bakovi ala va. A tabua e Nadap. To pahamuria e Abihu, e Eleasar, e Itamar. ");
INSERT INTO bnp_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","E tune Aron nga ni biri, ge ria a prister. ");
INSERT INTO bnp_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Na tahuna ri made na tabeke i ngeki ne Sinai, e Nadap e Abihu ru habi a kanono ne BAKOVI DAGI, na tahuna e BAKOVI DAGI i uka ma i taki rua ru gu habi vona. Lakea e BAKOVI DAGI i rabalaki rua, ru bala liu a hamone rua. Pali e Eleasar e Itmar kunana ru leho manga a prister na tahuna e Aron i tabana ni mahuri. ");
INSERT INTO bnp_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“O tuli valai e huriki a bakovi ne Levi ga gamai ria, ge ria a bolekori ne Aron. ");
INSERT INTO bnp_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ri gi leho na leho na Kape na Vaponga, ri gi tuhori e huriki a prister turana e huriki lobo. ");
INSERT INTO bnp_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Na tahuna ri leho, ri gi matakari kamumu a mahalana kape, ri gi matakari kamumu e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","E huriki a Levi ri tahoka a leho i taku kunana. Ne huriki a Israel lobo, ria kunana ri gi rata vakaroro a leho ne Aron, turane huriki e tuna. ");
INSERT INTO bnp_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","O vulaki kunana e Aron, turana e huriki e tuna, ri gi leho manga a prister. Pali e huriki ranga ri gi valai tabukoi, ni gi rabalaki.” ");
INSERT INTO bnp_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Ngane a vulaki e huriki a bakovi na kabu ne Levi, ge ria a tara nau kunana. Na tahuna a rabalaki a koma tabua ne huriki a Egipto, a vulaki a tabua bakovi ne huriki a Israel, a maka sipsip, a bulmakau, ge ne nau. Pali ngane i uka ma ga bole a tabua bakovi ne huriki a Israel, a vuhuna a kabu ne Levi ri bole a murine ria, ge ria a vora nau. Iau e BAKOVI DAGI a takia a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Na tabeke i ngeki ne Sinai e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“O gi e huriki a hamone Levi, o here ramai a kabu ne tamane ria takutaku. O here a rane huriki a koma bakovi ne ria ri tahoka a keva i taku i rike.” ");
INSERT INTO bnp_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Lakea e Moses i ramai a maka ngava e BAKOVI DAGI i vakukua vona. ");
INSERT INTO bnp_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","E Levi i tahoka e tuna bakovi to ala tolu: e Gerson, e Kohat, e Merari. ");
INSERT INTO bnp_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","A rane tune Gerson a bakovi ra nga: e Libni rua e Simei. ");
INSERT INTO bnp_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","A rane tune Kohat ra nga: e Amram, e Ishar, e Hebron, e Usiel. ");
INSERT INTO bnp_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","A rane tune Merari ra nga: e Mali, e Musi. E huriki a hamone Levi ri pesi muri mai a rane huriki e tubune ria nga. ");
INSERT INTO bnp_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","E huriki a hamone Gerson ri tahoka a kabu i rua: a kabu ne Libni, a kabu ne Simei. ");
INSERT INTO bnp_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","A koma bakovi ne ria ri tahoka a keva i taku i rike, ni gi palupu, ri ala 7,500. ");
INSERT INTO bnp_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Re huriki nga ri rata a mada ne ria na dahana Kape na Vaponga na tabeke na nirolona haro. ");
INSERT INTO bnp_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","E Eliasap e tune Lael ia a nupesi ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","A leho ne ria ni matakari a Kape na Vaponga, a maki ni kapina, a kala dagi na matana kape, ");
INSERT INTO bnp_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","a mota, a kala ni kapi halui a kape, a dede, a kala na ngavana nure. Ri gi rata lobo a leho ni matakari a maki nga. ");
INSERT INTO bnp_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","E huriki a Kohat ri tahoka a kabu i va: a kabu ne Amram, a kabu ne Isar, a kabu ne Hebron, a kabu ne Usiel. ");
INSERT INTO bnp_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","E tune ria bakovi ri tahoka a keva i taku i rike, ri ala 8,600. A leho ne ria ni tagari a kape. ");
INSERT INTO bnp_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ra hamone Kohat nga, ri gi rata a mada ne ria na tabeke mule puru na kape. ");
INSERT INTO bnp_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","E Elisapan, e tune Usiel, ia a nupesi ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","A leho ne ria ni matakari a Tava na Ngava Dagi, a dede, a butu na lam, a maka dede na nihabi, a maka pelete, a ulo ni rata a leho na Tabeke Nitaba, a kala dagi ni vulalakari a Tabeke Nitaba Hateka, a maki ranga ni rata na kape. Ri gi rata lobo a maka leho ni matakari a maki nga. ");
INSERT INTO bnp_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","E Eleasar, e tune Aron a prister, i matakari e huriki a matakari na kabu ne Levi. I matakari e huriki ri rata leho pololilo na tabeke ni taba na kape. ");
INSERT INTO bnp_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","E huriki a Merari ri tahoka a kabu i rua: a kabu ne Mali, a kabu ne Musi. ");
INSERT INTO bnp_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","E huriki e tune ria bakovi ri tahoka a keva ne ria i taku i rike, ri ala 6,200. ");
INSERT INTO bnp_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","A nupesi ne ria e Suriel, e tune Abihail. E huriki a tara nga, ri gi rata a mada ne ria mule sike na kape. ");
INSERT INTO bnp_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","A leho ne ria ni matakari a maka karona kape, a maka butuna kape, a maka tava ni vakapesi langa a maka butu, a maka kai ne vona ni roka a maka butu, turana a maka maki ranga ne vona ni vakatora a kape. ");
INSERT INTO bnp_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","A maka butu, a tava ni vakapesi langa a butu na nure ni tura halui a kape, a maka niroka, a mota ni kolotata a kape vona, ngi ranga bara ri matakari. ");
INSERT INTO bnp_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","E Moses, e Aron turane huriki e tuna, ri gi vakapesi a kape ne ria na tabeke na nirikena haro na matana kape na Vure. Ri gi madekari a Tabeke Nitaba, ri gi matakari e huriki a Israel, ma ri gi valai tabukoi, ni gi rabalaki. ");
INSERT INTO bnp_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","E Moses e Aron ru ramai a nitane BAKOVI DAGI, ru gi e huriki a bakovi na kabu ne Levi ri tahoka pali a keva i taku i rike, ri ala 22,000. ");
INSERT INTO bnp_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","E BAKOVI DAGI i takia e Moses i ta maea, “E huriki a tabua bakovi ne mua a Israel, ne nau kunana. O gi e huriki a tabua bakovi ri tahoka a keva i taku i rike, o here a rane ria. ");
INSERT INTO bnp_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Pali iau bara kuloi ne huriki na kabu ne Levi, re huriki a bakovi nga, ga bole e huriki a Levi ge ria a tara nau. Ga bole tabu a maka tabua na bulmakau ne huriki a Levi, ge bole a murine ria, a maka bulmakau ne huriki a Israel. Iau e BAKOVI DAGI a ta maea.” ");
INSERT INTO bnp_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Lakea e Moses i muri maia a nitane BAKOVI DAGI i gi e huriki a tabua bakovi ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ri tahoka a keva i taku i rike, ri ala 22,273. ");
INSERT INTO bnp_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ngane o habi nau a kabu ne Levi, ri gi kuloi e huriki a tabua bakovi ne huriki a Israel, ge ria a tara nau. Ri gi habi nau a bulmakau ne ria, ge kuloi a maka bulmakau ne huriki a Israel. Iau e BAKOVI DAGI a ta maea. ");
INSERT INTO bnp_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A tabua bakovi ne huriki a Israel ri kupo hateka ne huriki a Levi, ri ala 273. Ngane mu kona mule, re huriki a bakovi nga, ri ala 273. ");
INSERT INTO bnp_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","O bole a silva moni ge lima takutaku na bakovi ne ria, ne vona ni kona mule ria. A nimavana silva i ramai a nimavana maki na tahuna iea. ");
INSERT INTO bnp_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","O habi a moni nga ne Aron turane huriki e tuna, ga mapane huriki a Israel ri ala 473.” ");
INSERT INTO bnp_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Lakea e Moses i bole a moni ge kona mule e huriki a tabua ne Israel, e huriki a Levi i uka ma ri kuloi ria. ");
INSERT INTO bnp_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","E Moses i bole a moni silva i 1,365, i ramai a nimavana moni na tahuna iea. ");
INSERT INTO bnp_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Muri e Moses i habi a moni, a makoli ne Aron, ne huriki e tuna bakovi, i ramai a nita ne BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","E BAKOVI DAGI i taki e Moses e Aron, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Muru here a rane huriki a bakovi na tara ne Kohat, na kabu ne Levi. ");
INSERT INTO bnp_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Muru here a rane huriki a bakovi ri tahoka a pida i ravulu tolu, i harena na pida i ravulu lima, re huriki a bakovi ri kara ni rata a leho pololilo na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“A leho ne ria ne vona ni matakari a Kape na Vaponga, a maka maki ni taba hateka. ");
INSERT INTO bnp_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Na tahuna e huriki a Israel ri gi pea a mada ni lakea na tabeke tara, e Aron turane huriki e tuna bakovi ri gi dili na Kape na Vaponga, ri gi parua a kala dagi i naviri dili a Tava na Ngava Dagi, ri gi kavitagua a tava na kala iea. ");
INSERT INTO bnp_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ri gi naviri purua a kala na kulina lui kamumu, ri gi ru polomelia a kala gomagoma ne vona ni kavitagu loboa, bara ri rodo polo na halui a binole i rua, ri kalohoa. ");
INSERT INTO bnp_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Ri gi bole a kala gomagoma, ri gi kavitagua a dede ni ru langa a bret vona, ge a nihabi ne BAKOVI DAGI. Ri gi bole a pelete, a tavila na havu mangisipa, a maka pelete na maka nihabi ranga, a maka botol ne vona a nihabi na vain, a bret ni vakasiri vakaroro ni gi ru langa palupu lobo na kala gomagoma. ");
INSERT INTO bnp_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ri gi kavitagu lobo na kala vururu a maka maki nga, ri gi bole a kulina lui ri gi kavitagua a kala vururu, ri gi rodo dili na halui a binole ge rua. ");
INSERT INTO bnp_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ri gi bolea a kala gomagoma, ri gi kavitagua a butuna lam, a maki ni kisi a vik vona, a pelete kiroko ne vona ni tahoni a habulo na kanono, a maka botol na vel. ");
INSERT INTO bnp_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ri gi kavitagua ra kala gomagoma iea na kulina lui, ri gi ru langa na maki tara bara ni kaloho. ");
INSERT INTO bnp_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Muri ri gi kavitagua na kala gomagoma a dede ni rata na gol, ri gi kavitagua ra kala iea na kulina lui, ri gi rodo dili na halui a binole. ");
INSERT INTO bnp_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Muri ri gi bolea a kala gomagoma, ri gi bunu a maka tavila ni rata a leho ne ria na Tabeke Nitaba. Muri ri gi bunu kari tabua na kulina lui, ri gi ru langa na binole, bara ri kaloho. ");
INSERT INTO bnp_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Ri gi bole tala na dede a habulo, ri gi kavitagua na kala kuakua a dede. ");
INSERT INTO bnp_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ri gi bole lobo a maka maki ni rata a leho ne ria vona na dede: a maka tavila ni guru a habulo, a maka kinau, a maka savol kiroko, a maka pelete kiroko ne vona ni bole a dara na nihabi. Ri gi ru langa na dede a maka maki, muri ri gi kavitagu na kulina lui, ri gi rodo dili na halui a binole ge rua, bara ri kaloho. ");
INSERT INTO bnp_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Na tahuna e Aron, e tuna mai ri kavitagu lobo a maki i taba, muri e huriki e tune Kohat bara ri kaloho a maka mahala na kape, pali nahea ri gi padoi a maka maki nga. Ria bara ri padoi, bara ri mate. Na tahuna ri pe a mada, e Aron turane huriki e tuna, ri gi kavitagu kamumu a maka maki nga. Ra maki nga, e huriki e tune Kohat kunana ri kaloho. ");
INSERT INTO bnp_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“E Eleasar, e tune Aron a prister, ge matakari a kape, a vel na lam, a namona oliv ne vona ni gamai e huriki a prister, a havu mangisipa, a maka nihabi na vit, a nibiri, turana a maka maki nau ri tabuli na kape.” ");
INSERT INTO bnp_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","E BAKOVI DAGI i taki e Moses e Aron, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","19","“Na tahuna e huriki a Kohat ri valai tabukoi na maki nau, mu matadoko ne ria, ma ri gi ratea tara naro hale, ga rabalaki ria. I mavonga kunana, e Aron turane huriki e tuna, ri gi dili muga taro, ri gi ru a leho na bakovi takutaku na kabu ne Kohat. Ri gi taki ria vona a ra maki ri gi kaloho. ");
INSERT INTO bnp_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Pali e huriki a Kohat, nahea ri gi dili na kape, ri gi matai a maka maki ni taba, ma ga rabalaki ria.” ");
INSERT INTO bnp_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“O gi e huriki a bakovi na tara ne Gerson, re huriki a hamone Levi. ");
INSERT INTO bnp_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","O here puru a rane huriki ri tahoka a pida i 30, i harena na pida i 50, re huriki ri kara ni rata a leho pololilo na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ri tahoka a leho ni kaloho a maka maki nga: ");
INSERT INTO bnp_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","a kadis, a kala i kavitagua, a kulina lui i kavitagu a kala, a kala dagi na mataroho, ");
INSERT INTO bnp_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","a maka mota, a maka kala ne vona ni kapi halui a nure na kape, a dede, a kala dagi na mataroho na nure, a maka maki kiroko ne vona ni vakatora a kape, a nure. A kabu ne Gerson i tahoka a leho ni kaloho kamumu a maka maki nga. ");
INSERT INTO bnp_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","E Aron, turane huriki e tuna bakovi, ri gi matakari e huriki a Gerson, ri gi vakasiri ria vona a maki ri gi kaloho. ");
INSERT INTO bnp_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","E huriki a Gerson ri gi rata a maka leho nga na kape. E Itmar, e tune Aron a prister, ge matakari ria. ");
INSERT INTO bnp_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Na kabu ne Merari, o here puru ge ramai e huriki a gare ne ria a rane ria. ");
INSERT INTO bnp_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","O here puru a rane huriki a bakovi ri tahoka a pida ne ria i 30, i harena ne 50, re huriki ri kara ni rata a leho pololilo na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ri tahoka a leho ni kaloho a butu na kape, a maka kai ne vona ni vakatora a nure, a maka vuhubutu ne vona ni vakapesi a butu, ");
INSERT INTO bnp_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","a maka butu na nure, a maka vuhubutu ni vakapesi langa a maka butu na nure vona, a maka mota ne vona ni vakatora a nure, a maka maki ranga na nure. O taki a bakovi takutaku a ra maki ge kaloho. ");
INSERT INTO bnp_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","E huriki a Merari ri gi rata a maka leho nga na Kape na Vaponga. E Itamar, e tune Aron a prister, ge matakari ria.” ");
INSERT INTO bnp_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Lakea e Moses, e Aron, turane huriki a nupesi, ri here puru a rane huriki na kabu ne Kohat i ramai a rane huriki a kabu ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","A pida ne ria i ravulu tolu, i harena ne ravulu lima. Re huriki ri kara ni rata a leho pololilo na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","E huriki ni here a rane ria, ri ala 2,750. ");
INSERT INTO bnp_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","E Moses, e Aron ru here a rane huriki na kabu ne Kohat ri gi leho na roho na vaponga, i ramai a nitane BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","A Kabu ne Gerson, ngi ranga ni here muri mai a rana nupesi ne ria, a rane ria. ");
INSERT INTO bnp_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","A pida ne ria i ravulu tolu, i harena ne ravulu lima, ri kara ni leho na roho na vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Ni gi palupu ria, ri ala 2,630. ");
INSERT INTO bnp_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Re huriki nga, a rane huriki na kabu ne Gerson, ri leho na roho na vaponga, i ramaia a ngava ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","E huriki a Merari, ngi ranga, ni gi ramai a vuhune ria na kabu takutaku ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","A bakovi ri tahoka a pida i ravulu tolu, i harena na pida i ravulu lima, ri valai, ri leho na roho na vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Ni gi ramai a kabu ne ria, ri ala 3,200. ");
INSERT INTO bnp_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Re huriki nga a hamone Merari, e BAKOVI DAGI i vakuku e Moses, e Aron vona ru gu gi. ");
INSERT INTO bnp_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Lakea e Moses, e Aron, turana e huriki a nupesi ne Israel, ri gi e huriki a hamone Levi i ramai a kabu takutaku ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","A bakovi a pida ne ria i ravulu tolu, i harena na pida i ravulu lima, ri valai, ri rata a leho ni kaloho a maka mahalana kape, ");
INSERT INTO bnp_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Ni gi palupu lobo ria, ri ala 8,580. ");
INSERT INTO bnp_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ri ramai a nitane BAKOVI DAGI i vakuku e Moses vona, ri here puru lobo a rane huriki na kabu ne Levi. Ri gi rata a leho, ri gi kaloho a maka mahalana kape. ");
INSERT INTO bnp_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“O vakuku e huriki a Israel ri gi tono tala e huriki ri tahoka a gilanga na patala, ri tahoka a kume i rali tala na ngarava, a kakaine ria i rali tala vona a naru o a dara, e huriki ri padoi a viri i mate. Re huriki nga, i uka ma ri matapado na matagu, ri gi made polovavo na mada. ");
INSERT INTO bnp_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mu tono tala e huriki a bakovi a ngatavine ri muto, ma ri gi ratea a mada na hini a made vona ge muto.” ");
INSERT INTO bnp_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Lakea e huriki a Israel ri muri mai a ngava e BAKOVI DAGI i taki e Moses vona, ri tono tala e huriki ri tahoka a maka gilanga maea. ");
INSERT INTO bnp_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","ge taki e huriki a Israel, ge ta maea, “A viri i ngalahere nau, i rata a naro hale na viri tara, lakea i matakilaka vona a naro hale vona, a bakovi iea i tahoka a ngava. ");
INSERT INTO bnp_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ge taki tala a naro hale vona, ge konea a naro hale i ratea. Ge habi a moni ge karea a naro hale i ratea. Ge ru langa tabu ge popote ( ), ge habi lakea na viri i rata a naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Pali na tahuna a viri i bole a moni i mate pali, i uka viri vona ge bole a mapa, a bakovi i habi a moni ge habi ne BAKOVI DAGI, ge bole e huriki a prister. Ge habi tabua a sipsip a toga, ge a nihabi ne vona ni kavitagu a naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Na tahuna e huriki a Israel ri taparaki valai a maki ni gamai ri gi habi nau, ra maki nga ne vone huriki a prister ra ri bole na limane ria. ");
INSERT INTO bnp_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","A prister takutaku ge bole a nihabi nga ge ne vona.” ");
INSERT INTO bnp_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","E BAKOVI DAGI i takia e Moses ge taki e huriki a Israel, ge ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“A ngatavine tara ge ruru ge rata a naro na molenga, ");
INSERT INTO bnp_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","lakea i mahita kapiloho turana a bakovi tara, e girihina i uka ma i masia, i katoki, i muto ngane. Ge uka tara viri ge matai rua, ");
INSERT INTO bnp_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","lakea e girihina i bage vona a ngatavine iea ra i vakamuto mule ia, o ge bage tavula vona e girihina, pali e girihina i uka ma i vakamuto mule ia, ");
INSERT INTO bnp_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ge tuli lakea na prister a ngatavine. A bakovi ge bole a kilo ge taku na plaoa ni rata na barli, ge a nihabi. Pali nahea ge guru langa a namona oliv vona a nihabi iea, o ge ru a havu mangisipa, a vuhuna ra nihabi iea ne vona a bakovi i bage ne girihina, i ratea a nihabi ni gi matakilaka vona e girihina i rata a naro hale, o i uka. ");
INSERT INTO bnp_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“A prister ge tuli vilia a ngatavine ge pesi na matagu tabukoi na dede. ");
INSERT INTO bnp_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","A prister ge guru dili na ulo kiroko a naru ni gamai. Ge dili na kape ge bole ranga malala, ge ru na naru bara i nami hurari a naru. ");
INSERT INTO bnp_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Na tahuna a ngatavine i tabana ni pesi na matagu, a prister ge vuka a vuna ngatavine ni viri, ge tabuli tavula a vuna. A prister ge bole a plaoa na nihabi na bakovi i bage ne girihina, ge ru na limana ngatavine. A prister ge nugua a ulo na naru vagole. Ra naru iea ne vona ni ruduraha. ");
INSERT INTO bnp_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","A prister ge ratea a ngatavine ge kaba ge ta maea, ‘Ioe i uka ma o mahita turana tara bakovi, i uka ma o vakamuto mule ioe na tahuna o made na tarune kakaimu, a naru ni ruduraha i uka ma ge ratapile ioe. ");
INSERT INTO bnp_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pali ioe bara o ruru o rata a naro na molenga na tahuna o made na tarune girihimu, o vakamuto mule ioe, o mahita turana a bakovi tara i uka ma e girihimu.’ ");
INSERT INTO bnp_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Ngane a prister ge hudotala a ngava tabu, ge ta maea, ‘Ioe bara o ratea a naro iea, e BAKOVI DAGI i kara ni rata ioe a maki tavula liu na matane huriki, bara i dili na kavutumu i ratea a palomu i repo, ge veo a tagamu. ");
INSERT INTO bnp_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ra naru iea ge rata ioe, bara i dili na kavutumu i ratea a tamudimu i repo, bara i veu a tagamu.’ “A ngatavine ge koli ge ta maea, ‘I muholi. E BAKOVI DAGI ge rata mavonga.’ ");
INSERT INTO bnp_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“A prister ge herea ra ngava hateka iea na raukea, ge vahiloloa a nihere na ulo i tahoka a naru vagole vona. ");
INSERT INTO bnp_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Muri a prister ge habia na ngatavine a naru iea, ge nua, ge vakahalea a kavutuna. ");
INSERT INTO bnp_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Pali muga, a prister ge bolea a plaoa na nihabi na limana ngatavine, ge tabari iau vona. Muri ge bole lakea na dede. ");
INSERT INTO bnp_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ge bole a plaoa popote ge ratea e BAKOVI DAGI ge luhoia, ge gutu na dede ge a nihabi. Muri ge habia na ngatavine a naru vagole iea ge nua. ");
INSERT INTO bnp_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Bara a ngatavine iea i mahita muga turana tara bakovi, a naru iea bara i rata ia i bole a nimadihi dagi, bara i repo a kavutuna, i veo a tagana. Na tahuna e huriki a viri vona ri ngaru ni harogi a viri tara bara ri ta maea, “A Vure ge rata hale ioe, i manga a hini i rata halea a ngatavine iea. ");
INSERT INTO bnp_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pali bara ngatavine iea i uka ma i ratea tara naro hale, ra ngatavine iea i matapado na matagu, bara i uka ngava na matane BAKOVI DAGI, bara i kara ni singou, ni poda a koma. ");
INSERT INTO bnp_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Na tahuna a ngatavine i mahita turana tara bakovi, e girihina i bage vona, mu ramai kunanea a vinara iea. ");
INSERT INTO bnp_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Mu ramai tabua a vinara iea na tahuna a bakovi i tahoka a niluhoi hale i bage ne girihina ta i mahita turana a bakovi tara. A bakovi ge luhoi maea, ge tulia a ngatavine ge pesi na matagu tabukoi na dede, ge rata a prister a maki nga. ");
INSERT INTO bnp_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","E girihina ngatavine bara i uka ngava, pali na tahuna a ngatavine i tahoka a ngava, bara i bole a mapana na naro hale i ratea.” ");
INSERT INTO bnp_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","ge taki e huriki a Israel ge ta maea, “A bakovi o a ngatavine i rata a nita muholi ge habi mule ia ne nau na tahuna ranga, ");
INSERT INTO bnp_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","nahea ge ninu a vain o ge ninu a bia. Nahea ge ninu a naruna vain, nahea ge kani a kanena vain i rara, nahea ge kani a kanena vain ni rara na haro. ");
INSERT INTO bnp_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Na parava vakaroro ge nugutatea a nita muholi iea, ne vona ni habi mule ia ne nau, nahea ge kani a maki ni rata na kai, a vain. A pagana o kulina kanena vain, ngi ranga nahea ge kani. ");
INSERT INTO bnp_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Na parava vakaroro ge ramaia a nita muholi iea ge habi mule ia ne nau. Nahea ge palakudua a vuna, nahea ge alia a karirana. Ra bakovi iea ne nau kunana. Na tahuna nga nahea ge palakudu a vuna o ge ali a karirana, lakea bara i malamala. ");
INSERT INTO bnp_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Na parava vakaroro na tahuna i habi mule ia ne BAKOVI DAGI, nahea ge lakea tabukoi na podana viri i mate. ");
INSERT INTO bnp_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","E tamana, e kinana, a viri vona ranga ri mate, nahea ge lakea tabukoi ne ria, ma ge muto na matagu. A vuna i ola, i vakasiri i habi mule ia na Vure. ");
INSERT INTO bnp_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Na parava vakaroro ge ramaia ra nita muholi ne vona ni habi mule ia ne nau, bara i malamala. ");
INSERT INTO bnp_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Bara bakovi tara ge mate vakaturutu na dahana, ra matenga na bakovi iea bara i vakamuto a vuna, ra i ta muholi vona ge nau. Ra bakovi iea ge dava na parava i polorua ge palia a vuna. Na parava nga i uka ma ge matapado na matagu. ");
INSERT INTO bnp_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Na polotoluna parava ge bole a balu ge rua, ge bole valai na matana Kape na Vaponga, ge habi nau. ");
INSERT INTO bnp_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","A prister ge bolea tara, ge habia nau, ge a nihabi ni puga vuroki a naro hale, a balu tara ge a nihabi ni gi gutu-vuro. Ra bakovi i made tabukoi na podana bakovi i mate, i muto pali, ra nihabi nga i rua, ru kavitagua a bakovi iea. Na parava iea kunana, ra bakovi iea ge ru a kilakila vona tabu a vuna, ge ne nau tabu. ");
INSERT INTO bnp_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ge vakatubu tabu, ge gi a maka parava i ta muholi vona ge habi mule ia ne nau. Nahea ge luhoi ra parava ranga muga ra i habi ia ne nau, a vuhuna ra vuna i ta muholi vona ta ge nau i muto pali. Ra bakovi iea i muto pali, ngane ge bole vilia nau tara tuna sipsip a toga, a pida vona ge taku, ge a nihabi na rarenga. ");
INSERT INTO bnp_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Na tahuna a bakovi i hudotalea pali a nita muholi vona, ni gi bole ge pesi tabukoi na mataroho na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ge habi nau a nihabi ge tolu. Ge bolea tara tuna sipsip a toga ge tahoka a pida ge taku, ge a nihabi gutu-vuro, a tuna sipsip a kinana ge tahoka a pida ge taku, ge a nihabi na rarenga, a sipsip a toga ge gavutuvutu, ge a nihabi na nivalemu. ");
INSERT INTO bnp_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Ge bole a bret i uka is ge tahoni na kulopi, ge bole valai, ge a nihabi. Ra kulopi iea ge tahoka a maka tabekena bret dagi ni rata na plaoa kamumu, ni vuli turana a namona oliv, turana a maka bisket ni ravu na vel. Ge ramaia a narona a nihabi iea ge ratea a nihabi na vit, a nihabi na vain. ");
INSERT INTO bnp_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“A prister ge habi nau a maki nga ge rata a nihabi na naro hale, a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Muri ge rabalakia a sipsip a toga, ge habi turana a maka bret ni tahoni na kulopi, ge a nihabi na nivalemu ne BAKOVI DAGI. A nihabi na vit, a vain ranga ge rata. ");
INSERT INTO bnp_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Na tahuna a bakovi i hudotalea pali a nita muholi vona, ge made tabukoi na mataroho na Kape na Vaponga ge palia a vuna, ge bole a vuna ge ru na kanono ni gutu a nihabi na nivalemu vona. ");
INSERT INTO bnp_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Muri a prister ge bolea a gepena sipsip a toga, ge nonoa na ulo. Na tahuna a bobona sipsip i munae pali, a prister ge bole ranga bobona, ge bole talea na kulopi tara balena bret turana a bisket ge taku, ge ru na limana bakovi iea. ");
INSERT INTO bnp_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Muri a prister ge bole mule na bakovi a maki ni kani nga, ge tabari iau vona. Ra nihabi iea, ne nau kunana, ge bole a prister ge kani. A siana, a pona sipsip a toga, ngi ranga ne vona a prister. Na tahuna a prister i rata lobo a maka naro nga, a bakovi iea i kara ni ninu a vain tabu. ");
INSERT INTO bnp_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Iea a vinara na bakovi i ta muholi ge habi mule ia ne nau e BAKOVI DAGI. Na tahuna a bakovi tara i ta muholi ge habia nau tara maki, ra ngava dagi i takia ge ta muholi vona.” ");
INSERT INTO bnp_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","23","E BAKOVI DAGI i takia e Moses, “O takia e Aron turane huriki e tuna bakovi, ri gi gamai e huriki a Israel vona a ngava kamumu nau. Ri gi ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘E BAKOVI DAGI ge gamai mua, ge tagari mua. ");
INSERT INTO bnp_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","A matane BAKOVI DAGI ge parai mua, ge rata kamumu mua. ");
INSERT INTO bnp_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","E BAKOVI DAGI ge hate kamumu ne mua, ge habi a nivalemu ne mua.’ ");
INSERT INTO bnp_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Na naro iea kunana, e huriki a Israel bara ri galea a ragu e BAKOVI DAGI. Muri bara gamai ria.” ");
INSERT INTO bnp_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Na parava e Moses i vakalobo ni vakapesia a kape, muri i bolea a nibiri i gamai a kape turana a maka mahalana, a dede turana a maka mahalana. i rata ria ri malamala. ");
INSERT INTO bnp_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","E huriki a nupesi na kabu takutaku ri bole valai a maka nihabi ne BAKOVI DAGI. Re huriki nga, ria a nupesi ne Israel, ri matakari a leho ni gi palupu a rane huriki. ");
INSERT INTO bnp_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ri bole valai na kape ne BAKOVI DAGI a karis i polotara, a bulmakau i ravulu a polona i rua, ri habi ne BAKOVI DAGI. A karis i taku ne vona a nupesi i ala rua. A nupesi i taku i bole vilia a bulmakau i taku. ");
INSERT INTO bnp_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Lakea e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“O bole a maka nihabi i habi nau e huriki a nupesi, o habi ne huriki a kabu ne Levi. Ri gi rata a leho vona pololilo na Kape na Vaponga. A leho ne ria ri gi rata a leho ni kaloho a maka mahalana kape.” ");
INSERT INTO bnp_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Lakea e Moses i bole a maka karis, a bulmakau i habi ne huriki a kabu ne Levi. ");
INSERT INTO bnp_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","I habi na kabu ne Gerson a karis i rua, a bulmakau i va, ri gi rata a leho vona. ");
INSERT INTO bnp_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","I habi na kabu ne Merari a karis i va, a bulmakau i polotolu, ri gi rata a leho vona. E Itmar, e tune Aron a prister, i matakari ria. ");
INSERT INTO bnp_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Pali e Moses i uka ma i habi a karis, a bulmakau ne huriki na kabu ne Kohat, a vuhuna a maki na kape ni gamai bara ri kaloho kunana. ");
INSERT INTO bnp_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Na tahuna ni gamai a dede, e huriki a nupesi ri bole valai a maka nihabi ri habi na Vure. ");
INSERT INTO bnp_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Lakea e BAKOVI DAGI i takia e Moses, “E huriki a nupesi na kabu takutaku ri gi habi a nihabi ne ria, ne vona ni gamai a dede. Na parava takutaku, a nupesi i taku ge bole valai a nihabi vona.” ");
INSERT INTO bnp_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Na mugana parava, a nupesi ne huriki a Iuda, e Nason e tune Aminadab, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","a pelete silva, a nimavana i 130 sekel, a tavila silva, a nimavana i 70 sekel. Ra nimavana maki nga, i ramai a nimavana a sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","a vidiru ni rata na gol, a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ne vona a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","a meme a toga, ne vona a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga a nihabi ne Nason e tune Aminadab. ");
INSERT INTO bnp_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Na ruana parava (2nd), a nupesi ne huriki a Isikar, e Nataniel e tune Suar, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","a vidiru ni rata na gol a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ne vona a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","a meme a toga, ne vona a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima a pida ne ria i taku, ne vona a nihabi na nivalemu. Ra maki nga, a nihabi ne Nataniel e tune Suar. ");
INSERT INTO bnp_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Na toluna parava (3rd), a nupesi ne huriki a Sebulun, e Eliab e tune Helon, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana a sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","a vidiru ni rata na gol a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ne vona a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","a meme a toga ne vona a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga, a nihabi ne Eliab e tune Helon. ");
INSERT INTO bnp_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Na vana parava (4th), a nupesi na kabu ne Reuben, e Elisur e tune Sedeur, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","a vidiru ni rata na gol a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ne vona a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","a meme a toga, ne vona a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga, a nihabi ne Elisur e tune Sedeur. ");
INSERT INTO bnp_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Na limana parava (5th), a nupesi na kabu ne Simion, e Selumiel e tune Surisadai, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana namina oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","a vidiru ni rata na gol, a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ne vona a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","a meme a toga, ne vona a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga, a nihabi ne Selumiel, e tune Surisadai. ");
INSERT INTO bnp_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Na polotarana parava (6th), a nupesi na kabu ne Gad, e Eliasap e tune Deuel, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","a vidiru ni rata na gol, a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ge a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","a meme a toga, ne vona a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga a nihabi ne Eliasap, e tune Deuel. ");
INSERT INTO bnp_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Na poloruana parava (7th), a nupesi na kabu ne Epraim, e Elisama e tune Amihud, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","a vidiru ni rata na gol, a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ne vona a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","a meme a toga ge a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga, a nihabi ne Elisama, e tune Amihud. ");
INSERT INTO bnp_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Na polotoluna parava (8th), a nupesi na kabu ne Manase, e Gamaliel e tune Pedasur, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ge a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","a vidiru ni rata na gol, a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga i tahoka a pida i taku, ge a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","a meme a toga, ne vona a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga a nihabi ne Gamaliel, e tune Pedasur. ");
INSERT INTO bnp_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Na polovana parava (9th), a nupesi na kabu ne Bensamin, e Abidana e tune Gideoni, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","a pelete silva a nimavana i 130 sekel, a tavila silva, a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","a vidiru ni rata na gol, a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ge a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","a meme a toga ge a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga, a nihabi ne Abidana, e tune Gideoni. ");
INSERT INTO bnp_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Na ravuluna parava (10th), a nupesi na kabu ne Dan, e Ahieser, e tune Amisadai, i bole valai a nihabi: ");
INSERT INTO bnp_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","a pelete silva a nimavana i 130 sekel, a tavila silva, a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","a vidiru ni rata na gol a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ge a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","a meme a toga, ge a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ge a nihabi na nivalemu. Ra maki nga, a nihabi ne Ahieser, e tune Amisadai. ");
INSERT INTO bnp_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ne ravulu a mugana parava (11th), a nupesi na kabu ne Aser, e Pagiel e tune Okran, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana sekel na kape na tahuna iea. Ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","a vidiru ni rata na gol, a nimavana i 10 sekel, i vonu vona a havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ne vona a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","a meme a toga, ge a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga a nihabi ne Pagiel, e tune Okran. ");
INSERT INTO bnp_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ne ravulu a ruana parava (12th), a nupesi na kabu ne Naptali, e Ahira e tune Enan, i bole valai a nihabi vona: ");
INSERT INTO bnp_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","a pelete silva a nimavana i 130 sekel, a tavila silva a nimavana i 70 sekel. Ra nimavana pelete a tavila nga, i ramai a nimavana a sekel na kape na tahuna iea, ru vonu na plaoa kamumu ni vuli turana a namona oliv, ne vona a nihabi na vit; ");
INSERT INTO bnp_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","a vidiru ni rata na gol, a nimavana i 10 sekel i vonu na havu mangisipa; ");
INSERT INTO bnp_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","a tuna bulmakau a toga, a sipsip a toga, a tuna sipsip a toga a pida vona i taku, ne vona a nihabi gutu-vuro; ");
INSERT INTO bnp_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","a meme a toga, ge a nihabi na naro hale; ");
INSERT INTO bnp_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","a bulmakau a toga i rua, a sipsip a toga i lima, a meme a toga i lima, a tuna sipsip a toga i lima ri tahoka a pida i taku, ne vona a nihabi na nivalemu. Ra maki nga a nihabi ne Ahira, e tune Enan. ");
INSERT INTO bnp_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ra maki nga lobo e huriki a nupesi ne Israel ri habi na tahuna ni gamai a dede. Muri ri gi a maka nihabi na dede: a pelete silva i ravulu a polona i rua, a tavila silva i ravulu a polona i rua, a vidiru gol i ravulu a polona i rua. ");
INSERT INTO bnp_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","A nimavana pelete silva takutaku i 130 sekel, a tavila silva takutaku i 70 sekel. A maka nimavana silva lobo i 2,400 sekel, i ramai a nimavana sekel na kape na tahuna iea. ");
INSERT INTO bnp_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ri taparaki valai a vidiru gol i ravulu a polona i rua, a nimavana vidiru takutaku i 10 sekel. A nimavana gol lobo i 120 sekel. ");
INSERT INTO bnp_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ri taparaki valai a tuna bulmakau a toga i 12, a sipsip a toga i 12, a tuna sipsip a toga i 12 ri tahoka a pida i taku, ne vona a nihabi gutu-vuro, turana a maka plaoa ne vona a nihabi na vit; a meme a toga i 12, ne vona a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ri taparaki valai a bulmakau a toga i 24, a sipsip a toga i 60, a meme a toga i 60, a tuna sipsip a toga i 60, ne vona a nihabi na nivalemu. Ra nihabi nga ni habi muri na dede ni gamai. ");
INSERT INTO bnp_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Na tahuna e Moses i dili na Kape na Vaponga ge ta turane BAKOVI DAGI, i longoa a lohona, i ta tala na murina ni dodo, na kurukuruna a agelo i rua na Tava na Ngava Dagi, i ta turana. ");
INSERT INTO bnp_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“O takia e Aron na tahuna i ru a lam i polorua na maka butu ne ria pololilo na Tabeke Nitaba, ge ru kamumu ri gi paraia a kurukuruna a hini pololilo.” ");
INSERT INTO bnp_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Lakea e Aron i ramaia a nita e BAKOVI DAGI i vakuku e Moses vona, i ru a maka lam na rahana butu ri paraia a kurukuruna Tabeke Nitaba. ");
INSERT INTO bnp_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","A maka butu na lam ni rata maea. Ni bole a gol, ni ubi na ama ni rata a butu, a maka rahana, a maka bagetua vona ri manga a keke. Ri rata manga a hini e BAKOVI DAGI i taki e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Muri e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“O gale tala ne huriki a Israel, e huriki a Levi, o rata ria ri gi matapado na matagu. ");
INSERT INTO bnp_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","O rata maea: O bole ranga naru ne vona ni rata a bakovi ge matapado na matagu, o voro tamali langa ne ria. Ri gi ali lobo a vune ria, a vungane ria, ri gi loi pasi a maka kala ne ria. Bara ri rata lobo ri matapado. ");
INSERT INTO bnp_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Muri ri gi bolea tara bulmakau karaba a toga, turana ranga plaoa ni vuli turana namona oliv, ne vona a nihabi na vit, ni gi habi turana bulmakau. Ri gi bolea tara bulmakau a toga, ne vona a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","O taki e huriki a Levi ri gi pesi tabukoi na mataroho na Kape na Vaponga, turana e huriki a Israel lobo. ");
INSERT INTO bnp_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Na tahuna e huriki a Levi ri pesi na matagu, mua e huriki a Israel mu ru langa a limane mua na gine ria. ");
INSERT INTO bnp_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","E Aron ge bole a murine huriki a Israel, ge habi nau e huriki a Levi, ge a nihabi na nitabari. Na naro iea kunana e huriki a Levi bara ri kara ni rata a leho nau. ");
INSERT INTO bnp_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Muri e huriki a Levi ri gi ru langa a limane ria na gina bulmakau nga i rua. Ri gi habia tara, ge a nihabi na naro hale, a bulmakau tara, ge a nihabi gutu-vuro. Ra nihabi nga i rua, ne vona ni kavitagu a naro hale ne huriki a Levi. ");
INSERT INTO bnp_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","E huriki a Levi ri gi pesi na matane Aron turane huriki e tuna. O habi ria nau ge manga a nihabi na nitabari. ");
INSERT INTO bnp_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Na naro iea kunana e huriki a Levi ri tebi ne huriki a tara ranga ne Israel, ge ne nau kunana. ");
INSERT INTO bnp_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Na tahuna o rata ria ri matapado pali, o habi ria ne nau ri gi manga a nihabi na nitabari, ngane ri kara ni rata a leho na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","A bole e huriki a Levi ge ne nau, a vuhuna ri bole a murine huriki a tabua ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","O longo kamumu. E huriki a tabua ne huriki a Israel, a tabua na maka bulmakau a sipsip ne nau kunana. A ru here ria pali na tahuna a rabalaki e huriki a tabua bakovi ne huriki a Egipto. ");
INSERT INTO bnp_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","I mavonga a bole e huriki a Levi ri gi kuloi e huriki a tabua bakovi ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","A bole tala ne huriki a Israel e huriki a Levi. A habi ne Aron turane huriki e tuna a bakovi, ri gi rata a leho a taki e huriki a Israel vona ri gi rata pololilo na Kape na Vaponga, ri gi kavitagu e huriki a Israel, i uka ma mu gu lakea tabukoi na Tabeke Nitaba, ma mu gu lokovonga tabukoi bara ratapile mua.” ");
INSERT INTO bnp_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","E Moses e Aron turane huriki a Israel lobo, ri rata ne huriki a Levi a maki e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","E huriki a Levi ri muri mai a naro ni matapado na matane BAKOVI DAGI, ri loi pasi a varakia ne ria. Lakea e Aron i habi ria ne BAKOVI DAGI ri manga a nihabi na nitabari. I rata a nihabi ni kavitagu a naro hale ne ria ri gi matapado. ");
INSERT INTO bnp_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","E huriki ri rata a maki lobo ne huriki a Levi, i manga a ngava e BAKOVI DAGI i vakuku e Moses vona. I mavonga e huriki a Levi ri kara ni rata a leho pololilo na Kape na Vaponga. E Aron turane huriki e tuna ri matakari ria. ");
INSERT INTO bnp_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“E huriki a Levi ri tahoka a pida ne ria i ravulu rua a polona i lima i rike, ri kara ni rata a leho pololilo na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ri kara ni ratea a leho iea ge harena na tahuna ri tahoka a pida i ravulu lima, muri bara ri malo. ");
INSERT INTO bnp_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Muri nahea ri gi nugu tabua a leho iea, pali bara ri tuhori kunana e huriki ri leho na Kape na Vaponga. O habia a ngava iea ne huriki a Levi ri gi rata maea.” ");
INSERT INTO bnp_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Na mugana keva na ruana pida, muri ne huriki a Israel ri pe e Egipto ri made na tabeke i ngeki ne Sinai, lakea e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","“Ne ravulu a vana parava (14th) na keva iea, na malunga liu e huriki a Israel ri gi rabalaki a maka sipsip ge a nihabi, ri gi ratea a Habu na Nipagepolo ri gi luhoia a parava a pagepolo ria, a rabalaki e huriki a tabua ne Egipto. Ra parava iea, a parava muholi na habu. Mu ramai a maka vinara lobo vona mu kani.” ");
INSERT INTO bnp_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Lakea e Moses i taki e huriki a Israel ri gi ratea a habu iea, ne vona ni luhoi mule a parava a Vure i tuhori e huriki a Israel ri made kamumu. ");
INSERT INTO bnp_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ri ratea a habu iea na malunga liu na parava i ravulu a polona i va na mugana keva na malala golea ne Sinai, i ramai a ngava e BAKOVI DAGI i vakuku e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Pali ranga bakovi ri padoi a podana bakovi i mate, lakea i uka ma ri matapado na matana Vure. I mavonga i uka ma ri kara ni ratana a habu na parava vona muholi. Na parava na habu ri lakea ne Moses e Aron, ");
INSERT INTO bnp_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ri ta maea, “Mi nugu a podana bakovi i mate, i uka ma mi matapado. Pali i navai i uka ma mi gi vapopo turane huriki mi gi habi a nihabi ne BAKOVI DAGI?” ");
INSERT INTO bnp_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Lakea e Moses i koli i ta maea, “Mu dava popote taro, ga nana taroa e BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Lakea e BAKOVI DAGI i takia e Moses ");
INSERT INTO bnp_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","ge taki e huriki a Israel, ge ta maea, “Na tahuna mua, e huriki a hamone mua ri nugu a podana bakovi i mate ri muto, o ri havai na tanga basi, ri kara ni ratea a Habu na Nipagepolo ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","12","Pali na ruana keva na malunga liu ne ravulu a vana parava (14th), ri gi ratea a habu iea. Ri gi ramai lobo a maka vinara na habu iea. Ri gi kania a sipsip iea turana a bret i uka is, a kobo i lahaha. Nahea ri gi ru mule ranga bobona sipsip ge vona a hini kuduvi. Na tahuna ri poka a sipsip nahea ri gi biputu a tuhana. ");
INSERT INTO bnp_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Pali e rei a viri i matapado na matagu, o i uka ma i havai lakea na tanga basi, lakea i uka ma i ratea a habu iea na mugana keva. Ni gi tono tala ne huriki a tara nau, a vuhuna i uka ma i habi a nihabi nau na tahuna i rata a nihabi. I mavonga ge kaloho mulea a nimavana naro hale vona. ");
INSERT INTO bnp_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Na tahuna a mosi tara i made turane mua i ngaru ni ratea a Habu na Nipagepolo ne BAKOVI DAGI turane mua, ra bakovi iea i kara, pali ge ramai lobo a maka vinara na habu iea. E huriki a tahotanga, a mosi ri gi ramai kunanea a vinara iea kunana. ");
INSERT INTO bnp_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Na parava ri vakapesi a kape na Ngava Dagi, a bubu i puru valai i kavitagua a Mailo na Vure. Na rodo ri masia a bubu i manga a kanono. ");
INSERT INTO bnp_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Na parava vakaroro a bubu i kavitagua a kape. Na rodo vakaroro a hubena kanono i kavitagua a kape. ");
INSERT INTO bnp_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Na tahuna a bubu i pe a kape i vano, e huriki a Israel ri bole a maki ne ria ri muri maia. Na tahuna a bubu i pesi na tabeke tara, e huriki a Israel ri rata a mada karaba na tabeke iea. ");
INSERT INTO bnp_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Na tahuna e BAKOVI DAGI i ta, e huriki a Israel ri pe a mada ri vano, na tahuna i ta tabu ri rata a mada karaba. Na tahuna a bubu i tababana ni pesi na Mailo na Vure, ri made kunana na mada. ");
INSERT INTO bnp_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Na tahuna a bubu i pesi tabaka na Mailo na Vure, e huriki bara ri ramai a nita ne BAKOVI DAGI ri made na mada. ");
INSERT INTO bnp_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","21","Na parava ranga a bubu i pesi langa na Mailo na Vure na parava popote kunana, o na keva ranga, o na pida i taku, muri i malaga tabu i vano. Na tahuna a bubu i malaga i vano, e huriki a Israel ri masia ri malaga ri ramaia. I uka ma ri gi loho rua vona ni malaga na rodo o na haro. Na tahuna iea kunana bara ri malaga ri vano. ");
INSERT INTO bnp_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","I uka ma ni lohopae vona ge balaka riva a bubu ge pesi na Mailo na Vure, ge harena na parava i rua, o na keva i taku, o na pida i taku, re huriki a Israel i uka ma ri gi malaga ri gi vano. Pali na tahuna a bubu i malaga i vano, ria ranga ri malaga ri pea a tanga ri laho. ");
INSERT INTO bnp_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Na tahuna e BAKOVI DAGI i vakuku e huriki a Israel, bara ri rata a mada. Na tahuna i vakuku tabu, bara ri bole a maka maki lobo ne ria, ri malaga, ri lakea na tabeke tara. E BAKOVI DAGI i habia ne Moses a nita iea, lakea e Moses i vakalongo e huriki, ri ramaia. ");
INSERT INTO bnp_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ngane mu bole ranga silva mu ubi na ama, mu rata a tavure ge rua. Mu vaki a tavure na tahuna mu ngaru ni gale palupu e huriki, ri gi kisi puru a maki ri gi laho. ");
INSERT INTO bnp_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Na tahuna mu vaki varago a tavure i rua, e huriki lobo ri gi valai na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Pali na tahuna mu vaki a tavure i taku kunana, e huriki a nupesi kunana na kabu ri gi valai ri gi vapopo turamu. ");
INSERT INTO bnp_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Na tahuna mu vakikapo a tavure, e huriki ri made na tabeke na nirikena haro na kape nau, ri gi malaga ri gi vano. ");
INSERT INTO bnp_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Na tahuna mu vakikapo tabu a tavure, e huriki a tara ri made na tabeke mule puru na kape, ri gi malaga ri gi vano. Mu vakikapo kunana a tavure na tahuna mu rata kilakila ni pe a mada, mu gu vano. ");
INSERT INTO bnp_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Pali na tahuna mu ngaru ni gale palupu e huriki ri gi valai ri gi vapopo, mu vakilalu a tavure. ");
INSERT INTO bnp_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","E huriki e tune Aron kunana, re huriki a prister, ri gi vaki a tavure. Mua turane huriki a hamone mua mu ramaia ra vinara iea vakaroro. ");
INSERT INTO bnp_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Na tahuna e huriki a pile ri gi bele ri gi vaubi ne mua na malala ne mua, mu vaki a tavure ge malaga e huriki ri gi vaubi ne ria. Mua bara mu rata mavonga, ngane iau e BAKOVI DAGI a Vure ne mua, bara luhoi mua, a korimule mua ne huriki a pile. ");
INSERT INTO bnp_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Na maka parava dagi ni vasileki, i manga na keva karaba o na maka parava dagi ranga, mu vaki a tavure na tahuna mu rata a nihabi gutu-vuro, a nihabi na nivalemu. Bara luhoi mua, a tuhori mua. Iau e BAKOVI DAGI a Vure ne mua, a ta pali. ");
INSERT INTO bnp_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ne ravulu ruana parava (20th) na ruana keva na ruana pida, muri ne huriki a Israel ri pe e Egipto, a bubu i pe a kape na Ngava Dagi, i vano. ");
INSERT INTO bnp_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Lakea e huriki a Israel, ri malaga ri pe mulea a malala golea ne Sinai, ri laho lokovonga. A bubu i vano i pesi na malala golea ne Paran. ");
INSERT INTO bnp_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","E BAKOVI DAGI i habi taro a nita ne Moses, muri e Moses i taki e huriki a Israel ri malaga ri laho lokovonga. ");
INSERT INTO bnp_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","A mada tara ne Iuda, ne Isikar, ne Sebulun ri muga. Ri vapida na tara ne ria, ri nugu a kilakila ne ria, ri laho lokovonga. E Nason e tune Aminadab i matakaria a kabu nga. ");
INSERT INTO bnp_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","E Nataniel e tune Suar i matakari e huriki a Isikar. ");
INSERT INTO bnp_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","E Eliab e tune Helon i matakari e huriki a Sebulun. ");
INSERT INTO bnp_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","E huriki e tune Gerson, e huriki e tune Merari na kabu ne Levi, ri muri mai ra tara nga. Ri pukea a kape na Mailo na Vure, ri bole a mahalana kape ri kaloho lokovonga. ");
INSERT INTO bnp_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Muri e huriki na mada tara ne Reuben, ne Simion, ne Gad ri vapida na maka tara kiroko, ri bole a kilakila ne ria, ri malaga ri vano. E Elisur e tune Sedeur bakovi i matakari lobo ra tara nga i tolu. ");
INSERT INTO bnp_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","E Selumiel e tune Surisadai i matakari e huriki a tara ne Simion. ");
INSERT INTO bnp_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","E Eliasap e tune Deuel i matakari e huriki a tara ne Gad. ");
INSERT INTO bnp_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Muri e huriki a Kohat na kabu ne Levi ri kaloho a maka mahalana Mailo na Vure ni gamai, ri malaga ri vano. Na tahuna e huriki a Kohat ri bele na murina mada karaba, a kabu ne Levi ranga ri muga ri vakapesia pali a kape na Mailo na Vure. Na tahuna a tara ne Kohat ri bele, ri habi ne huriki a prister a maka maki ri kaloho, ri ru dili na kape. ");
INSERT INTO bnp_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Muri a mada tara ne Epraim, ne Manase, ne Bensamin ri vapida na maka tara kiroko ri nugu a kilakila ne ria, ri malaga ri vano. E Elisama e tune Amihud i matakari ra tara nga i tolu. ");
INSERT INTO bnp_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","E Gamaliel e tune Pedasur i matakaria a kabu ne Manase. ");
INSERT INTO bnp_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","E Abidana e tune Gideoni i matakaria a kabu ne Bensamin. ");
INSERT INTO bnp_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","A iku na mada tara ne Dan, ne Aser, ne Naptali ri tagari a tabeke muri. Ri vapida na maka tara kiroko, ri nugu a kilakila ne ria, ri malaga ri vano. E Ahieser e tune Amisadai i matakari ra tara nga i tolu. ");
INSERT INTO bnp_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","E Pagiel e tune Okran i matakaria a kabu ne Aser. ");
INSERT INTO bnp_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","E Ahira e tune Enan i matakaria a kabu ne Naptali. ");
INSERT INTO bnp_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Na tahuna e huriki a Israel bara ri malaga ri pea a mada, bara ri laho palupu maea kunana ri vano. ");
INSERT INTO bnp_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Lakea e Moses i takia e lavona, e Hobab, e tune Ietro a bakovi na robo e Midian, i ta maea, “Ngane mi gi malaga mi gi laho maia a robo tara e BAKOVI DAGI i taki ge habia ne mia. I ta muholi pali ta mi gi made kamumu hateka vona a robo iea. Ioe o ngaru o valai turane mia, ga veru ga habi vomu a maka maki kamumu ge kupo.” ");
INSERT INTO bnp_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Pali e Hobab i koli i ta maea, “I uka, ga hamule na tanga nau, na kabu nau.” ");
INSERT INTO bnp_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Pali e Moses i ta maea, “Lavogu, o longo valai. Naha ni pe mia. Ioe o lohoka vona i vai a hini ni gi ru a mada vona na tabeke i ngeki iea, bara o vakasiri a dala ne mia. ");
INSERT INTO bnp_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ioe bara o valai turane mia, bara mi veru kamumu a maka maki e BAKOVI DAGI i habi ne mia, bara mi habi vomu ranga.” ");
INSERT INTO bnp_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","E huriki a Israel ri pe mulea a lolo ne BAKOVI DAGI e Sinai, ri laho na parava i tolu. Ri kalohoa a Tava na Ngava Dagi ne BAKOVI DAGI, ri laho muga ri gi bele na tabeke tara ri gi malo vona. ");
INSERT INTO bnp_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Na tahuna ri laho, a bubu ne BAKOVI DAGI i tabuli polomeli ne ria. Na maka parava lobo na haro a bubu i tabuli maea kunana. ");
INSERT INTO bnp_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Na tahuna ri ngaru ni kaloho loko­vongea a Tava na Ngava Dagi, e Moses bara i taki ria, i ta maea, “BAKOVI DAGI, o pesi rike, o vaubi ne huriki a pile vomu, o lili viliha ria, o rata e huriki i uka ma ri ngaru ioe ri gi ha viliha.” ");
INSERT INTO bnp_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Na tahuna ri malo, ri rua na malala a Tava na Ngava Dagi, e Moses bara i ta maea, “BAKOVI DAGI, o hamule valai ne mia a Israel mi ala ravulu i rangale (10,000,000).” ");
INSERT INTO bnp_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","E huriki a Israel ri tapuhaki na maregoa i bele ne ria, lakea e BAKOVI DAGI i longo. E BAKOVI DAGI i madihi a hatena, i rudua a kanono i boru langa na mada. Lakea a kanono i gutua a tabeke na mada tara na harehare. ");
INSERT INTO bnp_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Muri e huriki ri galea e Moses ge tuhori ria. E Moses i longo ria, i vasileki ne BAKOVI DAGI, i mate a kanono. ");
INSERT INTO bnp_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ri galea a rana a tanga iea e Tabera, a vuhuna a kanono ne BAKOVI DAGI i gutu ria. ");
INSERT INTO bnp_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","E huriki a bakovi, a ngatavine na tanga basi ri laho turane huriki a Israel ri ala kupo. Ri ngaru a maki ni kani ge kupo, lakea ri deke ri ngaru ni kani a kania. E huriki a Israel ranga ri deke mavonga ri ta maea, “Mi ngaru ni kani a kania. Pali mi gi bole vai? ");
INSERT INTO bnp_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Mi luhoi mulea e Egipto na tahuna mi kani a maka manu mi bole tavula, mi kani a maka karero, a melon, a nian, a galik. ");
INSERT INTO bnp_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Pali ngane a nitora ne mia i lobo pali, mi bala a maki ni kani. A mana kunana i tahoka, pali mi marikoi hateka vona.” ");
INSERT INTO bnp_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","A mana a maki kiroko i kabelabela, i manga a vutuna bin, i tora manga a rerena tangari. ");
INSERT INTO bnp_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Na tahuna a simuru i boru langa na mada, a mana tara i boru turana. Na hatelanga e huriki a bakovi, a ngatavine bara ri laho viliha na mada, ri poi a mana. Muri bara ri bole a kedo, ri tutu, i bele manga a plaoa. Bara ri nono na ulo, ri bole ranga ri rata a bisket vona, i manga a bisket ni gutu turana a namona oliv. ");
INSERT INTO bnp_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","E huriki a bakovi, a ngatavine ri pesi turana a kabu ne ria na matana kape, ri tangi hateka, i longo ria e Moses. Lakea e BAKOVI DAGI i madihi hateka a hatena ne ria, pali e Moses i luhoi lege. ");
INSERT INTO bnp_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Lakea i takia e BAKOVI DAGI i ta maea, “I navai o rata hale iau? I navai i uka ma o vivi nau? I navai o habi kikeri a leho nau ga matakari e huriki nga? ");
INSERT INTO bnp_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Iau i uka ma vakabele ria na tamudine kinane ria. Iau i uka ma iau e kinane ria ga poda ria. Pali i navai o taki iau ga leho manga a tagari, ga boko ria manga a koma kiroko na limagu, i vakatubu o Egipto i lakea liu na malala o ta muholi vona go habia ne huriki a gare ne ria? ");
INSERT INTO bnp_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Re huriki a bakovi a ngatavine ri tangi ri nana iau na kania. Pali ga bole vai a maka kania ge kupo? Iau i uka ma kara ni matakana a kania ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Iau kikeri kunana i uka ma kara ni matakari e huriki nga. I uka ma kara ni matakari ria. ");
INSERT INTO bnp_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ioe o ngaru ni rata maea iau, i kamumu hateka o dodo iau o rabalaki liu iau, i uka ma ga leho hateka tabu ga bole a maregoa nga.” ");
INSERT INTO bnp_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Lakea e BAKOVI DAGI i takia e Moses i ta maea, “O gale a gare ala ravulu polorua ri gi valai nau. O tuli kunana e huriki a bakovi o lohoka ne ria, ri lohoka ni matakari. O tuli valai ria koea na Kape na Vaponga, ri gi vapopo turagu, ri gi pesi turamu. ");
INSERT INTO bnp_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ga puru valai ga ta turamu vonga. Ga bole ranga nitora na hanugu i tabuli pali vomu, ga habi ne ria. Ri gi tuhori ioe, ri gi bole a maregoa ne huriki a bakovi, a ngatavine, i uka ma ge ioe kunana go bole lobo. ");
INSERT INTO bnp_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ngane o taki e huriki o ta maea, ‘Mu ramaia a naro ge rata mua mu gu matapado na matana Vure. Mu kisi puru mua, kuduvi bara mu kani a kania. E BAKOVI DAGI i longo mua mu deke hateka na kania. I longo mua, mu taki mua ta mu made kamumu o Egipto. Mu longo. Ngane e BAKOVI DAGI ge habi a kania ne mua mu kani. ");
INSERT INTO bnp_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","I uka ma mu gu kani na parava ge taku, o ga parava ge rua, o ga parava ge lima, o ga parava ge ravulu, o ga parava ge ravulu rua. I uka. ");
INSERT INTO bnp_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Bara mu kani a kania na keva i taku, muri bara mu kide tala ni kani a kania bara mu ngaru ni muta. E BAKOVI DAGI i made na kurukurune mua, pali mu ngalahere mu deke lakea vona mu ta maea, “I navai mi pe a robo e Egipto mi valai?” ’” ");
INSERT INTO bnp_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Pali e Moses i koli i ta maea, “BAKOVI DAGI, o longo. Iau a made turane huriki a bakovi ri ala 600,000, lakea o taki ta go habi a kania ne ria na keva i taku. Go matakana a kania vai go habi ne ria? ");
INSERT INTO bnp_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bara mi rabalaki lobo a maka bulmakau, a sipsip, pali ra maka sipsip, a bulmakau nga i uka ma ge kara ria, a manu lobo na dari ranga i uka ma ge kara ria.” ");
INSERT INTO bnp_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","E BAKOVI DAGI i koli e Moses i ta maea, “O luhoi navai, o luhoi a nitora nau i uka ma i kara? I uka ma ge tabaka bara o matai. Bara o lohoka vona a maki a ta vona ge bele o ge i uka.” ");
INSERT INTO bnp_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","E Moses i longo, muri i pagitala i taki e huriki vona a ngava e BAKOVI DAGI i takia. I tagui e huriki a gare ri ala ravulu polorua, i taki ria ri gi pesi halui a kape. ");
INSERT INTO bnp_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Muri e BAKOVI DAGI i puru valai na bubu iea, i ta turane Moses. Lakea e BAKOVI DAGI i bole a nitora na hanuna, ra i habi muga ne Moses i habi ne huriki a gare ala ravulu polorua. Na tahuna a hanuna i valai i made turane ria, popote kunana ri vakalongo a nita propet, pali i uka ma ri rata lokovonga liu. ");
INSERT INTO bnp_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Pali a gare ala rua, e Eldat, e Medad, i uka ma ru lakea na kape turane huriki ranga. Ru tababana ni made na mada ne BAKOVI DAGI. Pali e BAKOVI DAGI i habia ne rua a hanuna ru ta propet na mada. ");
INSERT INTO bnp_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Muri a riau tara i nunu lakea ne Moses i ta maea, “E Eldat, e Medad ra ru made na mada, ru rata a nita propet.” ");
INSERT INTO bnp_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","E Iosua, e tune Nun, a bolekori ne Moses, i leho turana na tahuna i riau vona, i valai i harena mona. E Iosua i longo a nitana riau, lakea i takia e Moses i ta maea, “Bakovi dagi nau, o vano o taki rua naha ru gu ta.” ");
INSERT INTO bnp_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Pali e Moses i koli a ngava i ta maea, “O luhoi ge kuloi iau ranga bakovi? Naha ni loho lege lae? Iau a ngaru e BAKOVI DAGI ge habi a hanuna ne huriki a bakovi a ngatavine lobo, ri gi rata a nita propet.” ");
INSERT INTO bnp_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","E Moses i ta lobo, muri i hamule lakea na mada turane huriki a gare ne Israel. ");
INSERT INTO bnp_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","E BAKOVI DAGI i ratea a vilu i pori valai na dari, i vakabebe valai a maka kadirovo, ri puru halui a mada ri vatabuli taho, ri kupo lolo rike na mita i taku. Ri toka viliha pololilo na mada, ri toka polovavo na mada. Ri laho viliha, ri kavitagu loboa a tabeke dagi na malala, i harena na maka kilomita i kupo na dahana mada. ");
INSERT INTO bnp_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","E huriki a bakovi a ngatavine ri leho na haro, a rodo ri lakavu a maka kadirovo. Na parava muri ri rata mavonga tabu. A bakovi, a ngatavine ri lakavu a maka kadirovo i kupo, a nimavane ria i harena na 22 kilo i rike. Ri poka a maka kadirovo ri rara pololilo na mada ge kere. ");
INSERT INTO bnp_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Na tahuna ri vakatubu ni kani a maka bobona kadirovo, e BAKOVI DAGI i malaviriri kunana i madihi a hatena ne ria, i rudua a gilanga dagi hateka i valai ne ria, i kupo ne ria ri mate. ");
INSERT INTO bnp_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ri tanu a podane ria vona a tanga iea. Ri vunua a tanga iea e Kibrot-Hatava, a vuhuna ri tanu vonga e huriki ri kaningaru. ");
INSERT INTO bnp_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Muri ri pea e Kibrot-Hatava ri lakea na tanga e Haserot, ri ratea vonga a mada ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Na tahuna ri tababana ni made o Haserot, e Aron, e Miriam ru biu e Moses, a vuhuna e Moses i parangi na ngatavine o Kus. ");
INSERT INTO bnp_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Lakea ru ta maea, “E BAKOVI DAGI i habi kikeri a ngava ne Moses? I uka liu. Tarua ranga i habi a nita ne tarua.” E BAKOVI DAGI i longoa ne rua a ngava iea. ");
INSERT INTO bnp_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ra bakovi e Moses, ia a bakovi ni vakakiroko mule ia. I uka tara bakovi na malala ge vakakiroko mule ia ge manga e Moses. ");
INSERT INTO bnp_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Na tahuna ru ta lobo, e BAKOVI DAGI i malaviriri kunana i taki e Moses, e Aron, e Miriam i ta maea, “Moto valai na Kape na Vaponga.” Lakea to malaga to vano. ");
INSERT INTO bnp_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Lakea e BAKOVI DAGI i puru valai na bubu i pesi na matana kape, i gale tala i ta maea, “O Aron, o Miriam muru valai.” Ru longo, ru karuku lokovonga popote. ");
INSERT INTO bnp_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Lakea e BAKOVI DAGI i ta maea, “Muru longoa a nitagu. Na tahuna a propet tara i made turane mua a Israel, iau e BAKOVI DAGI a vakasiri iau vona na vurena, a habi a ngava nau na vurena. ");
INSERT INTO bnp_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Pali a vora nau e Moses i uka ma i manga e huriki a propet ranga. A naro a ratea vona i tebi. A habi lobo vona a maka leho nau, a lohoka vona bara i rata. ");
INSERT INTO bnp_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","I mavonga, a ta turana i manga a bakovi i ta turana e turana. A ta kavakava vona, i uka ma ta vakakika. Ia tara i matai iau. Pali i navai i uka ma muru mangenge ni harogi e Moses, a vora nau?” ");
INSERT INTO bnp_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","E BAKOVI DAGI i tahate hateka ne rua, muri i pe rua i vano. ");
INSERT INTO bnp_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","A bubu ne BAKOVI DAGI i pe a kape, i malaviriri kunana a gilanga na patala i kavitagua a kuline Miriam, i kea hateka a kulina manga a kamagi. Muri e Aron i matagege, i masia a gilanga hale i kavitagua a kuline Miriam. ");
INSERT INTO bnp_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Lakea e Aron i takia e Moses i ta maea, “Bakovi dagi, maria miri manga, miri rata a naro hale. O dodo maria, naha ni rata maria miri gi bolea a maregoa na naro hale ne maria. ");
INSERT INTO bnp_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Naha ni matataroa e Miriam ge mata manga a koma i mate pololilo na palone kinana, pali na tahuna i podea e kinana i marina pali a kulina.” ");
INSERT INTO bnp_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Lakea e Moses i nana torea e BAKOVI DAGI i ta maea, “O Vure, a ngaru hateka go ratea e Miriam ge matapado.” ");
INSERT INTO bnp_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Lakea e BAKOVI DAGI i koli i ta maea, “E tamane Miriam bara i kalupe tahoa a matane Miriam, bara i maruhu na parava i polorua. I mavonga kunana e Miriam ge made polovavo taro na mada na parava i polorua, muri ge dili tabu.” ");
INSERT INTO bnp_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Lakea ri vakamade polovavo na mada e Miriam na parava i polorua. E huriki a ngatavine, a bakovi i uka ma ri malaga ri gi lakea na hini ranga. Ri davea e Miriam ni gi tuli hamule valai taro. ");
INSERT INTO bnp_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Muri ri pea e Haserot, ri vano ri rata a mada na tabeke i ngeki ne Paran. ");
INSERT INTO bnp_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ioe o lohoka vona ra robo e Kenan ga habia ne mua e huriki a Israel. I mavonga o vulaki tala a ubu na tara takutaku na kabu i ravulu a polona i rua, o rudu ria ri gi vano ri gi kasisia a robo e Kenan.” ");
INSERT INTO bnp_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Na tahuna ri made na tabeke i ngeki ne Paran, i longototoa a ngava ne BAKOVI DAGI i rudu a ubu na tara ne huriki a Israel, ri vano. ");
INSERT INTO bnp_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","A rane ria ra nga: e Samua e tune Sakur, ni bole tala na kabu ne Reuben. ");
INSERT INTO bnp_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","E Sapat e tune Hori, ni bole tala na kabu ne Simion. ");
INSERT INTO bnp_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","E Keleb e tune Iepune, ni bole tala na kabu ne Iuda. ");
INSERT INTO bnp_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","E Igal e tune Iosep, ni bole tala na kabu ne Isikar. ");
INSERT INTO bnp_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","E Hosea e tune Nun, ni bole tala na kabu ne Epraim. ");
INSERT INTO bnp_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","E Palti e tune Rapu, ni bole tala na kabu ne Bensamin. ");
INSERT INTO bnp_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","E Gadiel e tune Sodi, ni bole tala na kabu ne Sebulun. ");
INSERT INTO bnp_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","E Gadi e tune Susi, ni bole tala na kabu ne Iosep, ra kabu ne Manase. ");
INSERT INTO bnp_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","E Amiel e tune Gemali, ni bole tala na kabu ne Dan. ");
INSERT INTO bnp_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","E Setur e tune Mikael, ni bole tala na kabu ne Aser. ");
INSERT INTO bnp_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","E Nabi e tune Vopsi, ni bole tala na kabu ne Naptali. ");
INSERT INTO bnp_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","E Guel e tune Maki, ni bole tala na kabu ne Gad. ");
INSERT INTO bnp_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","E Moses i rudu e huriki a bakovi nga, ri vano ri gi kasisi a maka tabeke lobo ne Kenan. E Moses i vunu herea e Hosea e tune Nun, i galea e Iosua. ");
INSERT INTO bnp_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Na tahuna e Moses i rudu ria ri gi kasisi a robo e Kenan, i taki ria i ta maea, “Mu sike lakea na tabeke ne Negev, mu polo sike na lolo. ");
INSERT INTO bnp_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mu matai kamumua ra tanga iea, mu matakilaka vona ra tanga iea i navai. Mu matai kamumu e huriki a bakovi vonga ri gao o i uka, ri ala kupo o i uka. ");
INSERT INTO bnp_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Mu matai kamumua a malala na robo iea, i kamumu o i hale. Mu matai kamumu a maka tanga ne ria ni tura halui o i uka. ");
INSERT INTO bnp_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mu matai kamumua a malala i kamumu ni varo a maki vona o i uka, i vona kai o i uka. Mu toni a pakianga ne mua, mu bole mule ranga kanena kai na robo iea.” Na tahuna iea, i tubu ni rara a maka vain. ");
INSERT INTO bnp_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Lakea e huriki a bakovi nga ri vano ri matai a maka tabekena malala lobo, i vakatubu na tabeke i ngeki ne Sin na tabeke mule puru, i lakea i harena na tanga e Rehob, tabukoi na ngutuna dala, i lakea na tanga e Lebo-Hamat na tabeke mule sike. ");
INSERT INTO bnp_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Muga ri lakea na tabeke ne Negev, ri vano ri bele na tanga e Hebron. E huriki a tara ne Ahiman, ne Sesai, ne Talmai ri made o Hebron. Re huriki nga, ria a hamona bakovi hateka tara, a rana e Anak. Ra tanga e Hebron ni rata muga, muri na pida i polorua e huriki a Egipto ri ratea a tanga e Soan. ");
INSERT INTO bnp_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Lakea e huriki a kasisi ri vano ri bele na maloku ne Eskol, ri valikudua a rahana kai a vain i parukaruka vona a kanena. Ra rahana iea i mava hateka, a bakovi i taku i uka ma i kara ge kaloho kiria. Lakea a bakovi ala rua ru koloa na binole ru kalohoa. Ri pasi tabu a maka kanena kai a pik, a maka kanena kai a pomigranet. ");
INSERT INTO bnp_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Muri e huriki a Israel ri vunua ra maloku iea e Eskol, a vuhuna e huriki a kasisi ri valikudu a rahana kai a vain vonga. ");
INSERT INTO bnp_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","I lobo a parava i ravulu va, e huriki a bakovi ri hamule ni kasisi a robo. ");
INSERT INTO bnp_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Muri ri hamule valai ne Moses, e Aron, ne huriki a Israel, ri made na tanga e Kades na tabeke i ngeki ne Paran, ri vakalongo ria na maka maki ri matai, ri vakasiri a maka kanena kai ri bole. ");
INSERT INTO bnp_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Lakea ri takia e Moses ri ta maea, “Ra robo o rudu lakea mia vona ta ga mi gi masia, mi masia pali. A malala vona i kamumu hateka, i kamumu ni varo a maki ni kani. O matai a maka kanena kai mi bole vonga. ");
INSERT INTO bnp_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Pali e huriki na robo iea ri gao hateka. A maka tanga ne ria ni tura halui na nure ri tora hateka. Mi matai vonga e huriki a hamone Anak. ");
INSERT INTO bnp_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","E huriki a Amalek ri made mule puru na tabeke ne Negev. E huriki a Hiti, a Iebus, a Amor ri made na lolo. E huriki a Kenan ri made tabukoi na dari na Kurukuruna Malala, pali i ranga ri made na gagane Iordan.” ");
INSERT INTO bnp_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","E huriki a Israel ri longo a maka nitane huriki a matakari ri mangenge, ri rata viliha a ngava. Lakea e Keleb i tahate ria na matane Moses i ta maea, “I navai mu ta hateka? Ngane si gi lokovonga, si gi vaubi turane ria, si gi bolea a malala ne ria, a vuhuna si tahoka a nitora, si kara ni rangi ria, si gi bolea a malala iea.” ");
INSERT INTO bnp_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Pali i ranga kasisi ri vano turane Keleb ri masia a robo iea ri ta maea, “E huriki na tanga iea ri gao hateka. I uka ma si kara ni vaubi turane ria. ");
INSERT INTO bnp_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Re huriki nga ri marapusi, ri tami e huriki a Israel vona a robo ri masia. Ri ta maea, A malala na robo iea i hale liu. I uka ma i koru kamumu vona a maka maki. E huriki a bakovi mi matai vonga ri koru dagi ri ola hateka. ");
INSERT INTO bnp_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Re huriki a bakovi nga, e huriki a Nepilim, a hamone Anak. Mi matai ria, mi luhoi mule mia, mia a maki tavula liu, mi manga a koa. Ria ranga ri matai mia, mi manga a koa.” ");
INSERT INTO bnp_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Na rodo iea e huriki lobo, ri tangi ri haloho. ");
INSERT INTO bnp_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ri deke ne Moses e Aron ri ta maea, “I kamumu hateka si gi mate o Egipto, o si gi mate koea na malala golea! ");
INSERT INTO bnp_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","I navai e BAKOVI DAGI i ngaru ni tuli lakea hita vona a robo karaba iea. Hita bara si lokovonga bara ri rabalaki hita na vabinga, ri bole e huriki e girihine hita, e tune hita, bara ri manga a vorakato ne ria. I kamumu si gi hamule lakea o Egipto.” ");
INSERT INTO bnp_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ri vata mule ne ria ri ta maea, “Si vulakia tara matakari ge bole mule hita lakea o Egipto.” ");
INSERT INTO bnp_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Na tahuna ri ta maea, lakea e Moses e Aron ru lolu na matane huriki lobo. ");
INSERT INTO bnp_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Lakea e Iosua e tune Nun, e Keleb e tune Iepune, ra turane huriki a ubu na tara nga ri kasisi e Kenan, ru rihate vona a ngava iea ru rape a varakia ne rua. ");
INSERT INTO bnp_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Lakea ru taki e huriki a bakovi a ngatavine ru ta maea, “Ra malala mi laho polo vona i kamumu hateka. ");
INSERT INTO bnp_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","E BAKOVI DAGI ge vivi ne hita bara, i bole lakea hita vona malala iea i kamumu hateka ni varo a maki ni kani vona, bara i habia ne hita. ");
INSERT INTO bnp_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Naha ni longotaro e BAKOVI DAGI, naha ni mangenge ne huriki ri made vona a robo iea, ria a maki tavula, bara si ratapile ria. E BAKOVI DAGI i made turane hita. I ratapile pali e huriki a vure taminga ta i matakari ria. Naha ni mangenge ne ria.” ");
INSERT INTO bnp_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Pali e huriki a Israel i uka ma ri ngarua a ngavane Keleb. Lakea ri taki ta ri gi padi rua na kedo, ru gu mate. Ta ri gi rata mavonga, i malaviriri kunana e huriki ri masia a nipara dagi ne BAKOVI DAGI i para polomeli na Kape na Vaponga. Lakea i uka ma ri padi rua na kedo. ");
INSERT INTO bnp_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","E BAKOVI DAGI i takia e Moses i ta maea, “Ge balaka riva e huriki nga ri gi longotaro iau? I uka ma ri luhoi tora iau. A rata a maka nivakasiri ri matai, pali i uka ma ri luhoi tora iau. ");
INSERT INTO bnp_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ngane ga rudua a gilanga dagi ge ratapile ria. Pali iau ga rata ioe, ge ioe a kabu dagi i gao hateka ne ria.” ");
INSERT INTO bnp_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Pali e Moses i koli i ta maea, “BAKOVI DAGI, na nitora vomu, o bole tala ria o Egipto e huriki o tuli valai ria koea. Ioe bara o ratapile ria, e huriki a Egipto bara ri longoa a velengana a naro o ratea ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Bara ri vakalongo e huriki ri made vona ngane na robo iea. Re huriki nga ri longoa pali a velengamu o made turane mia, o bele kavakava na tahuna a bubu vomu i pesi langa na matana kape. O made na bubu na haro, na rodo o made na kanono o muga mia. ");
INSERT INTO bnp_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ioe bara o rabalaki palupu lobo e huriki a tara vomu, e huriki a tara ranga ri longoa a ramu i dagi, bara ri ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘E BAKOVI DAGI i keri ni tuli e huriki a tara vona ri gi lakea na robo i ta muholi vona hosi ta ge habia ne ria, lakea i rabalaki ria na tabeke i ngeki.’ ");
INSERT INTO bnp_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Bakovi Dagi, a ngaru go vakasiri a nitora dagi vomu o ratea a maki o ta muholi vona go ratea. Ioe kunana o ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Iau, e BAKOVI DAGI, i uka ma ge madihi malaviriri a hategu. A ngaru hateka e huriki, pali ga muri mai vakaroro a nitagu. A puga vuroki a naro hale na tagenga ne ria. Pali bara vakamadihi e huriki ri rata a naro hale, ge ramai a hamone ria, ge harena ne tamarane ria, e kukulimane ria.’ ");
INSERT INTO bnp_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","BAKOVI DAGI, ioe o ngaru mia lobo i uka ma o mapulo kilala. I mavonga a nana ioe go puga vuroki a naro hale ne huriki nga, i manga a hini o rata na tahuna ri pe e Egipto i valai i harena mona, o rata vakaroro i valai i harena mona.” ");
INSERT INTO bnp_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","E BAKOVI DAGI i longo a nitane Moses, i koli i ta maea, “A puga vuroki pali a naro hale ne ria i manga a hini o taki iau vona ga rata. ");
INSERT INTO bnp_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Iau a Vure mahuri, a nitora, a nipara nau i tabuli na tabeke lobo na malala. ");
INSERT INTO bnp_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","I muholi hateka e huriki a bakovi a ngatavine ri longotaro ri toha iau, i uka ma ri gi lakea na robo ta ga habia ne ria. Ri masia a nipara i vakasiri ria ne nau a made turane ria. Ri matai a maka nivakasiri a rata pali o Egipto a rata pali na tabeke i ngeki. Pali ri longotaro vakaroro a nitagu. ");
INSERT INTO bnp_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","I uka liu tara ne ria ge dili vona a robo iea a ta muholi vona, ta ga habia ne huriki a hamone mua. ");
INSERT INTO bnp_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Pali a vora nau e Keleb, a niluhoi vona i tebi, i ramaia a ningaru nau muholi. Ngane ga taparaki lokovongea vona a robo i masia pali, ge made vona, muri ge bolea e huriki a hamona. ");
INSERT INTO bnp_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ra robo iea e huriki a Amalek, a Kenan ri made na maloku vona. Kuduvi, mua lobo mu mariu tala mu hamule lakea na tabeke i ngeki, mu laho lokovonga na Dari Vururu.” ");
INSERT INTO bnp_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","E BAKOVI DAGI i taki e Moses e Aron i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Balaka kupo e huriki a tara hale nga ri tapuhaki bala nau. A longo pali i tohai a kuligu vona a nitane ria. Garika ri gi voro taparaki a nitane ria? ");
INSERT INTO bnp_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ngane o taki ria vona a nitagu, a ta maea, ‘Iau e BAKOVI DAGI a made vakaroro a ta muholi ne mua, a longo mua pali mu taki ta mu gu mate iene, ngane ga rata manga a hini mu taki. ");
INSERT INTO bnp_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Na tahuna mu mate, a podane mua bara ri tabuli viliha na tabeke i ngeki. Mu tapuhaki mu ta hateka nau. Ngane e huriki a bakovi ri tahoka a pida i ravulu rua i rike, i uka ma ri gi lakea vona a robo iea. ");
INSERT INTO bnp_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","A ta muholi ta ga bole mua, mu gu made vona a robo iea, pali ngane mua lobo i uka ma mu gu vano. E Keleb e tune Iepune, rua e Iosua e tune Nun kunana ru gu vano. ");
INSERT INTO bnp_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mu taki e huriki na robo iea, ta ri gi vaubi turane mua, ri gi rangi mua, ri gi bole e huriki e tune mua. Pali i uka. Iau bara taparaki e huriki a koma nga ri gi lakea na robo ra i uka ma mu ngarua, bara ri bolea ri made vakaroro vona. ");
INSERT INTO bnp_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Pali mua i uka ma mu gu lokovonga, bara mu mate, mu bera na tabeke i ngeki iea. ");
INSERT INTO bnp_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","E huriki e tune mua bara ri laho viliha na tabeke i ngeki na pida i ravulu va, ge harena na tahuna mua lobo bara mu mate. Mu ha taro iau, mu manga a ngatavine i ha taro e girihina i ngoi viliha lae. Lakea e huriki a koma bara ri bole a maregoa na naro hale ne mua. ");
INSERT INTO bnp_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mu lakea vona a robo iea, mu masia na parava i ravulu va. Ngane bara mu bolea a maregoa na naro hale ne mua, ge harena na pida i ravulu va. A pida i taku ge bole a murina a parava i taku, ra mu kasisia a robo iea. Ra naro iea ge rata mua bara mu lohoka vona iau i uka ma ngarua a naro na tagenga ne mua.’ ");
INSERT INTO bnp_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Iau, e BAKOVI DAGI, a ta muholi bara vakalobo e huriki a bakovi a ngatavine, ri tahoka a niluhoi i taku ni tagege ni ngalahere nau. Mua takutaku bara mu mate koea na tabeke i ngeki. Iau e BAKOVI DAGI a takia a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","E huriki a bakovi e Moses i rudu ria ri gi kasisia a robo iea ri hamule, ri tami e huriki ri ta maea, “A robo iea i hale. Ra ngava iea kunana i rata e huriki ri deke ne BAKOVI DAGI.” Lakea e BAKOVI DAGI i ratea a gilanga dagi i bele ne huriki a bakovi nga, ri malaviriri kunana ri mate. ");
INSERT INTO bnp_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","E huriki a bakovi ri vano ri masia a robo iea, ri mate lobo. Pali e Keleb e tune Iepune, turana e Iosua e tune Nun kunana ru mahuri. ");
INSERT INTO bnp_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","E Moses i vakalongo lobo a nitane BAKOVI DAGI ne huriki a Israel, lakea ri tangi hateka. ");
INSERT INTO bnp_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Na hatelanga pokopoko, na parava muri ri vano, ri sike na lolo. Ri taki mule ria, “Si rata pali a naro hale. Si vano, si gi dili na tanga e BAKOVI DAGI i ta muholi vona si gi bolea.” ");
INSERT INTO bnp_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Pali e Moses i taki ria, i ta maea, “Naha ni vano. I navai mu gu tagege mu gu longotaro a nitane BAKOVI DAGI? Na tahuna bara mu lokovonga i uka ma mu gu rangi ria. ");
INSERT INTO bnp_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Naha ni lokovonga, e huriki a pile bara ri rangi mua, a vuhuna e BAKOVI DAGI i uka ma i made turane mua. ");
INSERT INTO bnp_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Na tahuna bara mu lokovonga, e huriki a Amalek a Kenan bara ri vaubi turane mua, ri rabalaki mua mu mate. E BAKOVI DAGI i uka ma ge pesi turane mua na vabinga, a vuhuna mu ngalahere vona i uka ma mu muri vona.” ");
INSERT INTO bnp_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","E Moses i taki ria vona a nita iea, pali i uka ma ri longototo. Ri malaga rike ri lakea na tanga na lolo. Pali e Moses i uka ma i vano turane ria, i made na mada. Re huriki nga i uka ma ri bolea a Tava na Ngava Dagi ne BAKOVI DAGI, i tabuli na mada. ");
INSERT INTO bnp_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Muri e huriki a Amalek a Kenan ri pe a tanga ne ria na lolo ri puru valai, ri vaubi turane huriki a Israel ri rangi ria. Ri valili ne huriki a Israel i harena na tanga e Horma. ");
INSERT INTO bnp_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","ge taki e huriki a Israel ge ta maea, “Na tahuna mu lakea vona a robo ta ga habia ne mua, ");
INSERT INTO bnp_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mu habi nau a maka bulmakau, a sipsip, a meme ne mua. Mu rata a nihabi gutu-vuro o a nihabi ni ramai a nita muholi, o a nihabi na habu dagi na lotu, o a nihabi na ni ngaru ne mua kunana. A mangina nihabi nga ri mangi kamumu hateka nau. ");
INSERT INTO bnp_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Na tahuna a bakovi i bole vilia tara sipsip o a meme ge a nihabi, ge habi turana a kilo i taku na plaoa, ge vuli turana a lita i taku na namona oliv, ne vona ni rata a nihabi gutu-vuro. A lita i taku na vain ge guru na dede, ge a nihabi na vain. ");
INSERT INTO bnp_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","7","Na tahuna o habi a sipsip a toga, o bole a kilo na plaoa ge rua, o vuli turana a namona oliv a lita ge taku a kalavana, turana a vain ge harena na lita ge taku a kalavana, ge habi nau ge a nihabi na vain. A mangina a nihabi iea a ngaru hatekea. ");
INSERT INTO bnp_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Na tahuna o habi a bulmakau a toga ge a nihabi gutu-vuro, o ne vona ni ramai a nita muholi, o ne vona a nivalemu, ");
INSERT INTO bnp_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","o bole a kilo na plaoa ge tolu, o vuli turana a namona oliv a lita ge rua. ");
INSERT INTO bnp_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","O bole valai a lita i rua na vain, o habi a maki nga turana a bulmakau a toga. Iau e BAKOVI DAGI a ngaru a mangina a nihabi nga. ");
INSERT INTO bnp_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","13","“Mua o huriki a tahotanga o Israel mu ramai vakaroro a vinara nga, na tahuna mu habi a bulmakau, a sipsip, a meme ge a nihabi. Na tahuna a burongi a mangina nihabi nga bara ngaru. ");
INSERT INTO bnp_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","E huriki a mosi ri made turane mua ria ranga ri ramai a vinara nga. ");
INSERT INTO bnp_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","A vinara i taku kunana mu ramaia, turana e huriki a mosi ri made turane mua. Ra vinara iea ge tabuli vakaroro, ge ramaia e huriki a hamone mua ri bele muri ma. A vuhuna, a matai mua turane huriki a mosi mu palupulupu kunana. ");
INSERT INTO bnp_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mua o huriki a Israel a mosi mu ramai kunanea a naro ge taku ni ratana a nihabi.” ");
INSERT INTO bnp_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","ge taki e huriki a Israel ge ta maea, “Ngane ga bole mua ga taparaki mua lakea vona a malala ta ga habia ne mua bara mu made vona. ");
INSERT INTO bnp_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Na tahuna mu kani vona a malala iea, mu bole ranga maki ni kani mu habi nau ge a nihabi, a vuhuna iau e BAKOVI DAGI ne mua. ");
INSERT INTO bnp_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Muri na vit ni mirio, na tahuna mu rata a bret na plaoa, mu habia nau a bret mu gutu mugea, ge a nihabi na vit. ");
INSERT INTO bnp_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Mua turane huriki a hamone mua, mu ramai a vinara iea mu habia nau a bret mu gutu mugea, ge a nihabi na vit. ");
INSERT INTO bnp_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","“Mu longo ne Moses a maka vinara nga, e huriki a hamone mua ri bele muri ma ria ranga bara ri longo polo ne mua. Pali ranga bakovi i uka ma ri gi luhoi kamumu, bara ri page poloa a vinara. ");
INSERT INTO bnp_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Na tahuna mua a Israel i uka ma mu luhoi kamumu mu pagepolo ranga vinara, i kamumu bara mu habia tara bulmakau a toga, ge a nihabi gutu-vuro, turana a nihabi na vit, a nihabi na vain, a meme a toga tara, ge a nihabi na naro hale. Na tahuna a burongi a mangine ria a ngaru hateka ria. ");
INSERT INTO bnp_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","A prister ge ratea a nihabi ge kavitagu e huriki a Israel. Na tahuna a masia bara puga vuroki a naro hale ne ria, a vuhuna i uka ma ri luhoi kamumu ri page poloa a vinara nau. ");
INSERT INTO bnp_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Iau bara puga vuroki a maka naro hale ne huriki a Israel ne huriki a mosi ri made turane ria, ra ri rata ruru a naro hale nga. ");
INSERT INTO bnp_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Bara bakovi tara i rata ruru a naro hale, ra bakovi iea ge habia a meme ge taku a kinana i tahoka a pida i taku, ge a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Na matane BAKOVI DAGI, a prister ge habia a sipsip ge kavitagua a viri i rata ruru a naro hale. Na tahuna ni kavitagu a bakovi iea, a naro hale vona bara ni puga vuroki. ");
INSERT INTO bnp_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Na tahuna a Israel tara o a mosi tara i rata ruru a naro hale, a vinara ge ramaia ge taku kunana. ");
INSERT INTO bnp_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Pali a viri i longotaro a nitagu i rata a naro hale, i manga i harogi iau. Ra bakovi iea ni gi rabalaki. Naha ni varoru vona ge ia a tahotanga o ge ia a mosi, ");
INSERT INTO bnp_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","a vuhuna ra bakovi iea i longotaro a nitagu. Na ningaru vona kunana i putu purua tara vinara nau. Mu rabalakia ra bakovi iea, a vuhuna i tahoka a ngava.” ");
INSERT INTO bnp_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Na tahuna e huriki a Israel ri tabana na tabeke i ngeki, ri masia a bakovi i popo a kai na Parava Nimalo. ");
INSERT INTO bnp_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Lakea ri tuli lakea na matane Moses e Aron, ne huriki lobo a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ri ru dili taroa na bavi, a vuhuna i uka ma ri lohoka vona a ra maki ri gi ratea vona. ");
INSERT INTO bnp_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Lakea e BAKOVI DAGI i takia e Moses i ta maea, “Mua e huriki a Israel mu rabalakia ra bakovi iea na kedo polovavo na mada.” ");
INSERT INTO bnp_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Lakea e huriki a bakovi a ngatavine ri longototo a nitane BAKOVI DAGI, ri tuli talea na mada ri padimatea na kedo. ");
INSERT INTO bnp_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","ge taki e huriki a Israel ge ta maea, “Mu bole a hotu mu rata a maka potu, mu varomu na nimodo na varakia ne mua. Na potu takutaku mu varomua a hotu gomagoma ge taku. Mua turane huriki a hamone mua ri gi bele muri ma, mu ramaia ra vinara iea. ");
INSERT INTO bnp_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Na tahuna mu matai a maka potu nga, bara mu luhoi a maka vinara lobo a habi ne mua, mu ramai. Lakea i uka ma mu gu pe iau, mu gu ramai a ningaru ne mua kunana mu gu rata a naro hale. ");
INSERT INTO bnp_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ra potu nga bara ri rata mua, mu gu ramai a maka vinara nau bara mu made kamumu ge mua e huriki a tara nau. ");
INSERT INTO bnp_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Iau e BAKOVI DAGI, a Vure ne mua, a bole tala mua o Egipto, ge iau a Vure ne mua. Iau e BAKOVI DAGI a Vure ne mua, a ta pali.” ");
INSERT INTO bnp_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","E Kora, e tune Ishar bakovi na kabu ne Levi, turana a bakovi ala tolu na kabu ne Reuben, ri longotaro e Moses. A rana bakovi nga: e Datan, e Abiram, rua e tune Eliab, e On e tune Pelet. ");
INSERT INTO bnp_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Ra bakovi nga turana ranga nupesi ne Israel ri ala 250 ri longotaro a ngavane Moses. Re huriki nga ria a tara na vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ri valai ne Moses e Aron ri taki rua ri ta maea, “Muru rata polomugamuga hateka. Hita lobo a tara na vaponga ne BAKOVI DAGI ni gamai, i uka ma i marua kunana. E BAKOVI DAGI i made turane hita lobo. I navai muru bibi rike mule marua muru matakari mia?” ");
INSERT INTO bnp_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Na tahuna e Moses i longoa a ngava iea, i tabuli ngalabarara puru na malala i vasileki. ");
INSERT INTO bnp_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Muri i pesi rike i taki e Kora turana e huriki a tara vona i ta maea, “Kuduvi na hatelanga e BAKOVI DAGI bara i vakasiri e rei e huriki a tara vona. E rei e huriki a bakovi i vulaki, bara i taki ria ri valai tabukoi vona. ");
INSERT INTO bnp_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ioe o Kora turane huriki a tara ri muri vomu, kuduvi na hatelanga mu bole a maka pelete, ");
INSERT INTO bnp_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","mu ru a kanono a havu mangisipa ne ria. Mu bole, mu pesi na matane BAKOVI DAGI. A bakovi e BAKOVI DAGI ge vulakia, a bakovi iea ni gamai. Mua o huriki a Levi mu rata polo muga muga hateka.” ");
INSERT INTO bnp_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Lakea e Moses i taki tabu e Kora i ta maea, “Mua o huriki a Levi mu longo. ");
INSERT INTO bnp_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","10","E BAKOVI DAGI a Vure ne hita a Israel, i vulaki tala mua ne huriki a Israel mu gu lakea tabukoi vona mu gu rata a leho vona na Mailo vona, mu gu pesi na matane huriki a bakovi a ngatavine ni tuhori ria. A Vure i taki mua turana a kabu ne Levi lobo mu gu ratea a leho iea, bara mu tahoka a rane mua. Pali i navai? Mu luhoia ra leho iea a maki tavula? I navai mu ngaru ge mua a prister? ");
INSERT INTO bnp_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ari mua, i navai mu padi momoa e Aron? Ra mua, i uka ma mu padi momo kunana e Aron, mu padi momo e BAKOVI DAGI a Vure ne hita.” ");
INSERT INTO bnp_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Lakea e Moses i rudua tara viri i vano i taki e Datan rua e Abiram ru gu valai taro vona. Pali ru koli ru ta maea, “Maria i uka ma miri gi lakene. ");
INSERT INTO bnp_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","O tuli tala mia na tanga kamumu e Egipto, o taparaki valai mia koea na tabeke i ngeki go rabalaki mia. Pali i uka ma ngi kunana. Ngane o ngaru ni matakari mia lobo. ");
INSERT INTO bnp_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ioe i uka ma o taparaki mia, mi gi lakea na robo ge tahoka a malala kamumu mi gi tahoka a hania na maki ni kani, a hania na vain. O luhoi ge mia a manga o tami mia? Maria i uka ma miri gi lakene.” ");
INSERT INTO bnp_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","E Moses i longoa a ngava iea i madihi a hatena, i takia e BAKOVI DAGI i ta maea, “Naha ni bole a maka nihabi ne huriki a tara nga ri habi vomu. Ri taki ta a matakari hale ria. Pali iau i uka ma bolea tara donki ne ria. I uka ma rata hale ria.” ");
INSERT INTO bnp_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","17","Muri e Moses i takia e Kora i ta maea, “Kuduvi, ioe turane huriki a bakovi ala 250 ri ramai ioe, mu valai na matane BAKOVI DAGI. E Aron tara ge valai. Mua takutaku mu bole valai na dede ne BAKOVI DAGI a pelete na havu mangisipa. ");
INSERT INTO bnp_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Na hatelanga e huriki a bakovi nga ri bole takutaku a pelete na havu mangisipa, ri pesi turane Moses e Aron na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Muri e Kora i vakalipopo e huriki ri pesi tabukoi na matana Kape na Vaponga, ri mata lakea ne Moses e Aron. Na tahuna ri vapopo, e BAKOVI DAGI i ratea a bagetua vona i bele kavakava i masia e huriki. ");
INSERT INTO bnp_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Lakea e BAKOVI DAGI i taki e Moses e Aron i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Muru malele ha ne huriki a bakovi a ngatavine nga. Ngane kunana ga rabalaki ria.” ");
INSERT INTO bnp_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Pali e Moses e Aron ru tabuli ngalabarara na malala, ru takia e BAKOVI DAGI ru ta maea, “Vure, ioe kunana o rata e huriki a bakovi a ngatavine ri made. I navai i madihi a hatemu ne huriki nga na naro hale na bakovi ala taku i ratea?” ");
INSERT INTO bnp_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Lakea e BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“O taki e huriki ri gi malele ha vona a kape ne Kora, ne Datan, ne Abiram ri gi pesi basi popote.” ");
INSERT INTO bnp_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Lakea e Moses i vano i matai e Datan e Abiram, e huriki a gare ne Israel ri ramaia. ");
INSERT INTO bnp_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Lakea e Moses i taki e huriki a bakovi a ngatavine i ta maea, “Mu karuku mule na kape na bakovi hale nga. Naha ni padoi ranga maki ne tou, ma mu gu vurua turane tou na naro hale ne tou.” ");
INSERT INTO bnp_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Lakea ri malele ha na kape ne Kora, ne Datan, ne Abirama. Pali e Datan, e Abiram ru pagitala ru pesi na matana kape ne rua, turane girihine rua, e tune rua. ");
INSERT INTO bnp_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Lakea e Moses i taki e huriki i ta maea, “Ngane bara mu masia tara maki ge bele, bara mu lohoka vona, e BAKOVI DAGI kunana i rudu iau ga matakari mua, ga rata a leho vona. Iau i uka ma a rata leho na ni ngaru nau. ");
INSERT INTO bnp_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Na tahuna e huriki nga bara ri mate manga kunana e huriki ri mate pali, bara mu lohoka vona e BAKOVI DAGI i uka ma i rudu iau. ");
INSERT INTO bnp_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Pali e BAKOVI DAGI ge rata rikea a naro karaba tara, a malala ge mapoka, ge ngavapanganga, lakea e huriki ri boru dili na lovo turana a maka maki ne ria, ri puru na murine huriki ri mate pali, na tahuna ri tabana ni mahuri, bara mu lohoka vona re huriki nga ri ngalahere ne BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","E Moses i ta lobo, i malaviriri kunana a malala i pesi vona e Datan e Abiram i mapoka, i vakabele a lovo dagi. ");
INSERT INTO bnp_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Lakea a malala i ngavapanganga, i todoa e Kora turana a tara vona, a kape ne ria, a maka maki ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ri tabana ni mahuri ri boru puru na murine huriki ri mate pali turana a maka maki ne ria. A malala i makapirubu tabu, i uka ma ni matai ria tabu. ");
INSERT INTO bnp_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Na tahuna ri boru puru ri gale dagi hateka. Lakea e huriki a bakovi a ngatavine o Israel ri pesi tabukoi ri ta maea, “Si gi ha malaviriri, ma ge mapoka a malala ge todo hita!” ");
INSERT INTO bnp_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","E BAKOVI DAGI i rudua a kanono, i valai i gutu parina e huriki a bakovi ala 250, ra ri rata a nihabi na havu mangisipa. ");
INSERT INTO bnp_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Muri e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“O takia e Eleasar e tune Aron a prister, ge bole a maka pelete ne huriki ri nono na kanono, ge voro viliha basi a katona kanono i tabuli ne ria. Ge rata mavonga, a vuhuna a pelete nga a taba. ");
INSERT INTO bnp_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ra maka pelete ne huriki a bakovi ri mate a taba, a vuhuna ri valai na matagu ri rata a nihabi na havu mangisipa. O tutu a pelete nga ge kabela, o naviri a dede vona, ge manga a kilakila na matane huriki a Israel.” ");
INSERT INTO bnp_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","E Moses i takia e Eleasar, a prister i bole a pelete nga, i habi ne huriki a mari ri tutu kamumu a maki ge kabela, ne vona ni naviri a dede ");
INSERT INTO bnp_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ra maki ni tutu i kabela ni kavitagu a dede vona, ge habi a niluhoi dagi ne huriki a Israel. Ri gi lohoka vona e huriki a tara ne Aron kunana ri gi lakea tabukoi na dede, ne vona ni habi a havu mangisipa na matane BAKOVI DAGI. E rei a bakovi tara i ratea a nihabi iea, e BAKOVI DAGI bara i ratapilea, i manga a hini i ratapile e Kora turana a tara vona. Lakea e Eleasar i rata a maka maki e BAKOVI DAGI i taki e Moses vona. ");
INSERT INTO bnp_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Na parava muri, e huriki lobo ri tapuhaki ne Moses e Aron, ri ta maea, “Muru rabalaki pali ranga e huriki a tara ne BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Na tahuna e huriki lobo ri vapopo ri tahate e Moses e Aron, ri mata lakea na Kape na Vaponga. Ri masia a bubu i kavitagua a kape, a bagetua dagi ne BAKOVI DAGI i bele kavakava. ");
INSERT INTO bnp_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","E Moses e Aron ru vano ru pesi na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Lakea e BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Muru pesi ha. Muru vano muru pesi basi popote ne huriki a bakovi a ngatavine, bara ratapile ria malaviriri kunana. Ru longoa a ngava iea, ru ngalabarara puru na malala.” ");
INSERT INTO bnp_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Lakea e Moses i takia e Aron, “O bole a pelete na havu mangisipa, o bole na dede a katona kanono o rua na pelete vomu. O bole lakea malaviriri ne huriki a bakovi a ngatavine, o rata a nihabi ge kavitagu ria na rongova na Vure, a vuhuna e BAKOVI DAGI i madihi a hatena ne ria, i vakabele a gilanga dagi ne ria pali.” ");
INSERT INTO bnp_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Lakea e Aron i muri mai a nitane Moses. I bole a pelete ne vona ni rata a nihabi na havu mangisipa, i nunu lakea ne huriki a bakovi a ngatavine ri vapopo. I masia a gilanga hale i bele pali ne ria. Lakea e Aron i ratea a nihabi na havu mangisipa, ne vona ni kavitagu ria. ");
INSERT INTO bnp_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Lakea e Aron i pesi na kurukurune huriki ri mate pali, e huriki ri mahuri, i rata a nihabi. Muri a gilanga iea i lobo. ");
INSERT INTO bnp_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Pali e huriki ri mate vona a gilanga iea i 14,700. E huriki ri mate turane Kora, i uka ma ni gi turane ria. ");
INSERT INTO bnp_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Na tahuna a gilanga i lobo, e Aron i hamule mai e Moses na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“O taki e huriki a Israel ri gi habi vomu a kodo ge ravulu a polona i rua (12), ge bole a murina a maka kabu ne Israel. O here puru a rana gare na kodo ne ria takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ne huriki a hamone Levi, o herea a rane Aron na kodo. ");
INSERT INTO bnp_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Muri o ru a maka kodo nga pololilo na Kape na Vaponga tabukoi na Tava na Ngava Dagi, na tabeke a tagui bala mua vona. ");
INSERT INTO bnp_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","A tuvu bara i gaga rike na kodo na viri a vulakia. Bara ri masia a kodo iea, ri lohoka vona, a vulakia pali a bakovi ge leho manga a prister. Na naro iea kunana, iau bara tangokapi a ngavane huriki a Israel, i uka ma ri gi ta barangungu mai ioe, i manga a hini ngane ri rata. ");
INSERT INTO bnp_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","E Moses i habia ne huriki a Israel a nita iea, lakea e huriki a matakari takutaku ri habi a kodo ne Moses. A kabu i taku i tahoka a kodo i taku. A kodo lobo i ravulu a polona i rua. A kodo i vona a rane Aron ni ru turana a kodo ne huriki a kabu. ");
INSERT INTO bnp_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Muri e Moses i bole a maka kodo i ru tabukoi na Tava na Ngava Dagi na matane BAKOVI DAGI pololilo na kape. ");
INSERT INTO bnp_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Na parava muri e Moses i dili na kape. I masia a kodo i vona a rane Aron, a kodo ne huriki a Levi, i tuvu i tahoka a vuana i vakabele a kanena kai a almon, ri rara pali. ");
INSERT INTO bnp_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","E Moses i bole a maka kodo ri tabuli na matane BAKOVI DAGI, i kaloho tala i vakasiri e huriki a Israel. Ri matai pali, muri i valai e huriki a matakari ri bole mule a maka kodo ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","E BAKOVI DAGI i takia e Moses i ta maea, “A kodo i tahoka a rane Aron o bole mule lakea na kape o ru tabukoia na Tava na Ngava Dagi, ge a kilakila ge rata e huriki a bakovi a ngatavine na tagenga ri gi luhoi kamumu. Ra naro iea bara i vakalobo a nita barangungu ne ria, i uka ma ri gi tapuhaki tabu ne nau.” ");
INSERT INTO bnp_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Lakea e Moses i ramai a ngava e BAKOVI DAGI i vakukua vona. ");
INSERT INTO bnp_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Muri e huriki a Israel ri takia e Moses, “Ngane bara mi bole a nimadihi. ");
INSERT INTO bnp_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","E rei a viri i lakea tabukoi na Mailo ne BAKOVI DAGI, bara i mate. Na naro iea kunana bara mi mate.” ");
INSERT INTO bnp_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","E BAKOVI DAGI i takia e Aron, “Na tahuna ioe, turana e huriki a Levi, e huriki e tumu, i uka ma mu rata kamumu a leho na Mailo nau, bara mu tahoka a maregoa mu bole a vuranga vona. Pali ioe turane huriki e tumu mu rata a naro hale na leho na prister, bara mu bole a maregoa vona. ");
INSERT INTO bnp_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","O bole e huriki a bakovi na kabu vomu e Levi, ri gi leho turamu ri gi tuhori ioe, na tahuna ioe turane huriki e tumu mu leho na kape na Ngava Dagi. ");
INSERT INTO bnp_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ri gi rata a maka leho o habi ne ria, a maka leho ne ria na kape. Pali nahea ri gi padoi a maka maki ri tabuli na Tabeke Nitaba o ri tabuli na dede. Ria ri gi padoi a maki nga, ioe turane ria bara mu mate. ");
INSERT INTO bnp_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","E huriki a Levi kunana ri gi leho turamu ri gi rata muholi a leho pololilo na Kape na Vaponga. E huriki a mosi i uka ma ri gi valai tabukoi vomu. ");
INSERT INTO bnp_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Ioe turane huriki e tumu bakovi kunana mu leho pololilo na Tabeke Nitaba na dede, lakea i uka ma ge madihi a hategu ne mua e huriki a Israel, i uka ma ga rata hale mua tabu. ");
INSERT INTO bnp_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mu longo, iau kunana a vulaki e huriki na kabu vomu, e Levi, na kurukurune huriki a Israel, a habi tavula ria vomu turane huriki e tumu bakovi. Re huriki nga, ria bakovi nau kunana, ri gi rata a leho pololilo na Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Pali ioe turane huriki e tumu bakovi kunana mu rata a maka leho na prister pololilo na Tabeke Nitaba. A leho na prister a habi tavulea ne mua. Ra leho na dede, a leho na tabeke ni taba, a leho ne mua. A bakovi tara i uka ma a vulakia i valai ge ratea a leho iea, ni gi rabalaki.” ");
INSERT INTO bnp_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","E BAKOVI DAGI i takia e Aron i ta maea, “Iau kunana a ru ioe a prister go matakari a nihabi malamala e huriki a Israel ri habi nau. A habi a maki ni taba lobo vomu turane huriki a hamomu. Ra naro iea ni gi rata vakaroro. ");
INSERT INTO bnp_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","A maka nihabi a taba hateka, naha ni gutu na dede, o bole, ra nihabi na vit, a nihabi na naro hale, a nihabi na rarenga. A maka maki e huriki ri habi nau ge a nihabi, a habi vomu turane huriki e tumu. ");
INSERT INTO bnp_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Mu kani a nihabi nga a taba. E huriki a bakovi ri gi kani, ri gi luhoi ra maki nga a maki malamala. ");
INSERT INTO bnp_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Mu bole a maka nihabi ranga, e huriki a Israel ranga ri habi nau, ra nihabi na nitabari. A maki ni kani nga a habi vomu ne huriki e tumu na parava vakaroro. E huriki na kabu vomu ri matapado pali na matagu, ri gi kani a kania nga. ");
INSERT INTO bnp_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Iau bara habi tabu ne mua a maki ri moro muga na hania na oliv, na vain, na vit na pida takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ra maki ri moro muga muga, ne vone mua kunana. E huriki a bakovi a ngatavine na kabu vomu ri matapado na matagu, ri gi bole ri gi kani. ");
INSERT INTO bnp_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","A maka maki e huriki a Israel ri habi nau a ta kari ria vona, i uka ma ri gi kona mule, ne vone mua kunana. ");
INSERT INTO bnp_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“E huriki a tabua ne huriki a Israel, a maka tabua na sipsip a bulmakau, ra ri habi ne BAKOVI DAGI, a habi vomu. Ri gi kona mule e huriki a tabua ne ria, turana maka tabua na livoa i uka ma ri matapado na matagu. ");
INSERT INTO bnp_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","E huriki a Israel ri gi kona mule e huriki e tune ria ri tahoka a keva i taku na silva sekel i lima, i ramai a nimavana sekel na kape na tahuna iea. ");
INSERT INTO bnp_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Pali i uka ma ri gi kona mule a tabua na bulmakau, a sipsip a meme, a vuhuna ni taba ria. Mu rabalaki ria, mu voro tamali na dede a darane ria, mu gutu na dede a vine ria, ge a nihabi. Na tahuna a burongi a mangina a nihabi nga, bara ngarua. ");
INSERT INTO bnp_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","A bobona nihabi nga, ne vone mua kunana, i manga a siana, a pona a kanena, a maka nihabi na nitabari ranga. ");
INSERT INTO bnp_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ra maka nihabi e huriki a Israel ri habi nau, ngane a habi vomu turane huriki e tumu na parava vakaroro. A ngava muholi iea a ratea turamu turana e huriki a hamomu, ge tabuli vakaroro na matagu.” ");
INSERT INTO bnp_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Lakea e BAKOVI DAGI i takia e Aron i ta maea, “Naha ni bole ranga tabekena malala ne Israel, ge ne vone huriki e tune mua. A vuhuna, a maki mu bala vona, bara mu bole nau, iau e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Na tahuna e huriki a Israel ri bole valai nau a naguna maki ni kani i ravulu, bara habia ne huriki a Levi a naguna i taku. Ra naguna iea i manga a mapane ria ri rata a leho ni matakari a Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Na parava vakaroro muri ma, e huriki a Israel nahea ri gi valai tabukoi na Kape na Vaponga, ma ri gi tahoka a ngava, bara ri mate. ");
INSERT INTO bnp_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Pali e huriki a Levi kunana ri gi matakaria a Kape na Vaponga. E rei a viri i putu puru a vinara na kape, e huriki a Levi kunana bara ri bole a nimadihi vona. Ra vinara iea ge tabuli vakaroro. E huriki a hamomu ranga ri gi ramaia. E huriki a Levi ri uka malala, a kabu ranga na Israel ri tahoka. ");
INSERT INTO bnp_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Na tahuna e huriki ri ru kadolu a maki na naguna i ravulu, ri habia nau a naguna i taku ge a nihabi nau, a habi poloa ne huriki a Levi. Na naro iea kunana a taki ria vona pali, i uka ma ri gi bole a tabekena malala pololilo ne Israel.” ");
INSERT INTO bnp_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“O taki e huriki a Levi o ta maea, ‘E huriki a Israel ri gi ru na naguna ge ravulu a maki ni kani, a naguna ge taku ri gi habia ne mua. Mu bolea a naguna iea mu ru tabu na naguna ge ravulu, muri mu habia ne BAKOVI DAGI a naguna ge taku. ");
INSERT INTO bnp_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","E BAKOVI DAGI ge masia a nihabi iea ge manga a nihabi na vit karaba, a vain karaba, e huriki ri habi vona. ");
INSERT INTO bnp_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Mu rata mavonga, mua ranga bara mu habi a nihabi ne BAKOVI DAGI. Ra tabekena ne BAKOVI DAGI, muri mu habia ne Aron. ");
INSERT INTO bnp_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Mu veru kamumu a maka maki ni kani mu bole, mu vulaki tala a maki i kamumu hateka ge ne vona e BAKOVI DAGI.’ ");
INSERT INTO bnp_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“O taki e huriki a Levi o ta maea, ‘Na tahuna mu habi lobo a maki ni kani kamumu ne BAKOVI DAGI, mu kani a kalavana i tababana, i manga e huriki a Israel ri kani a kalavana vit a vain, muri na nihabi i ratea ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ra maki ni kani nga, i manga a mapa ne mua mu rata a leho pololilo na Kape na Vaponga. I mavonga mua, turane huriki a kabu ne mua, mu vano mu kani a kalavana maki ni kani na hini lobo. ");
INSERT INTO bnp_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Mu habi muga a maki ni kani kamumu, bara mu uka ngava. Pali i uka ma mu habi muga, mu kani, bara mu vakahale a nihabi ni taba ne huriki a Israel. Ngane mu tahoka a ngava, bara mu mate.’” ");
INSERT INTO bnp_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","E BAKOVI DAGI i taki e Moses e Aron, ");
INSERT INTO bnp_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“A vinara tara a ngaru ni gi ramai ra iea: E huriki a Israel ri gi bolea tara bulmakau vururu, a kinana ge gavutuvutu, i uka ma ni rata a leho vona ma. Ri gi bole vilia ne marua. ");
INSERT INTO bnp_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Muru habia ra bulmakau iea ne Eleasar a prister. Ni gi bole tala na mada a bulmakau, ni gi rabalaki na matana. ");
INSERT INTO bnp_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","E Eleasar a prister ge bole a darana bulmakau popote, ge lutua na dara a kukulimana ge taku, ge voro tamali balaka polorua lakea na matana Kape na Vaponga. ");
INSERT INTO bnp_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","E Eleasar ge matanono ria ri gi gutu vuroa a bulmakau. Ni gi gutu a kulina, a bobona, a darana, a maka mahalana, ge vuro lobo liu. ");
INSERT INTO bnp_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","E Eleasar ge bolea a kai a sida, a rahana kai a hisop, a mota vururu, ge voro rike na kanono ni gutu a bulmakau vona. ");
INSERT INTO bnp_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Muri a prister ge loi pasi a maka varakia vona ge hilolo ia. A prister ge rata lobo a leho, muri ge dili na mada. Pali bara i muto na matagu i harena na haro i rolo. ");
INSERT INTO bnp_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","A bakovi i gutua a bulmakau, ia tara ge loi pasi a maka varakia vona, ge hilolo. Ia tara bara i muto na matagu i harena na haro i rolo. ");
INSERT INTO bnp_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Muri a bakovi tara i matapado na matagu, ge vano ge bole a havulana kanono ra ni gutu a bulmakau vona, ge bole tala na mada ge ru na tabeke i matapado na matagu. Ra habulona kanono ni gi ru kamumu, e huriki a Israel ri gi ru na naru, ne vona ni vahilolo ria, ge loi pasi a maki i muto na matagu. Ria ranga ri gi hilolo vona a naro iea, ne vona ni loi pasi a naro hale. ");
INSERT INTO bnp_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ra bakovi i bole a habulona kanono ge loi pasi a maka varakia vona. Pali ia tara bara i muto, i harena na haro i rolo. Ra vinara iea ge tabuli vakaroro. Mu ramaia. E huriki a mosi ri made turane mua, ria ranga ri gi ramaia. ");
INSERT INTO bnp_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“A bakovi tara i padoi a bakovi i mate, ra bakovi iea bara i muto na parava i polorua. ");
INSERT INTO bnp_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Pali ia ge vahilolo ia na naru na toluna parava, lakea na poloruana parava bara i matapado. Pali ia i uka ma ge vahilolo pasi ia na toluna parava, a poloruana parava, i uka ma ge matapado. ");
INSERT INTO bnp_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","A bakovi i padoi a podana viri, i uka ma i rata ia ge matapado, bara i muto mavonga. A vuhuna i uka ma i bolea ra naru ni rata a viri ge matapado, i uka ma ni voro tamali langa a naru vona. Ra naro iea i ratea a kape nau, i muto na matagu, lakea ra bakovi iea i uka ma ge made turane huriki a tara nau. ");
INSERT INTO bnp_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“A bakovi o a ngatavine i mate pololilo na kape, e huriki a bakovi ri made pololilo na kape iea, e huriki ri dili na kape, bara ri muto na matagu na parava i polorua. ");
INSERT INTO bnp_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","A maka ulo, a tavila, a maka maki ri uka a matane ria ri tabuli pololilo na kape, ria ranga ri muto. ");
INSERT INTO bnp_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","A bakovi i laho polovavo na tanga i padoi a podana bakovi ni rabalaki, o i padoi a podana bakovi i mate tavula kunana, o i padoi a tuhana bakovi, o i paha a lovo, ra bakovi iea bara i muto na matagu na parava i polorua. ");
INSERT INTO bnp_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“A naro ni rata vuroki a hini muto na bakovi o na ngatavine i maea. Mu ru na ulo ranga havulana bulmakau ni gutu-vuro ne vona a nihabi ni vakamatapado. Mu kirua na ulo a naru. ");
INSERT INTO bnp_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","A bakovi i matapado na matagu ge bolea a rahana kai a hisop ge lutua na naru, ge voro tamali lakea na kape i mate vona a bakovi ne huriki a bakovi a ngatavine, na maka maki lobo ri tabuli pololilo na kape. A bakovi i padoi a tuhana bakovi i mavuru pali, o i padoi a podana viri i mate pali, o i padoi a podana bakovi ni rabalaki, o i paha a lovo. Ra bakovi i matapado na matagu, ge voro tamali a naru vona a bakovi i muto na matagu. ");
INSERT INTO bnp_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Na toluna parava, a poloruana parava, ra bakovi i matapado ge voro tamali langa na bakovi i muto a naru. Ra bakovi i ngaru ni matapado, ge loi pasi a maka varakia vona, ge hilolo. Na tahuna a haro i rolo na poloruana parava, bara i matapado. ");
INSERT INTO bnp_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Pali bara bakovi tara i muto, i uka ma i ramai a naro ni vakamatapado, ra bakovi iea bara i muto mavonga na matagu. A vuhuna i uka ma ni guru langa a naru na ni ratana a bakovi ge matapado. Ra bakovi iea i ratea a kape nau i muto, lakea ni gi tono tala e huriki a tara nau. ");
INSERT INTO bnp_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","E huriki a Israel ri gi ramai vakaroroa a vinara iea. A bakovi i guru langa a naru na bakovi tara ge rata ia ge matapado, ge loi pasi a maka varakia vona. A bakovi tara i padoia a naru ne vona ni rata a bakovi ge matapado, ra bakovi iea i muto na matagu i harena na haro i rolo. ");
INSERT INTO bnp_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","A bakovi i muto i padoi a maki ranga, ra maki i padoi ri muto na matagu. E rei a bakovi i padoi a maki nga, ia tara i muto na matagu, bara i muto mavonga i harena na haro i rolo.” ");
INSERT INTO bnp_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Na mugana keva e huriki a Israel ri bele na tabeke i ngeki ne Sin, ri made na tanga e Kades. Na tahuna ri tabana ni made o Kades, e Miriam, e kurabane Moses e Aron, i mate, ni tanu vonga. ");
INSERT INTO bnp_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ra hini nga i uka naru, lakea e huriki ri vapopo ri deke ne Moses e Aron, ");
INSERT INTO bnp_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ri ta maea, “Mi luhoi, i kamumu, mi gi mate hosi na matane BAKOVI DAGI turane huriki a viri ne mia. ");
INSERT INTO bnp_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","I navai o bole valai mia koea na tabeke i ngeki? O ngaru mia turana a maka sipsip a bulmakau ne mia, mi gi mate koea na malala golea? ");
INSERT INTO bnp_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","I navai o bole tala mia o Egipto o bole valai mia koea na tanga hale, i uka ma i kara mi gi varo a maki ni kani vona? Ra tanga iea i uka vit, i uka kanena kai kamumu, i uka kai a vain. I uka naru koea mi gi ninu.” ");
INSERT INTO bnp_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","E Moses e Aron ru longoa a ngava iea, ru pe e huriki ru vano ru tabuli ngalabarara na matana Kape na Vaponga. A nipara ne BAKOVI DAGI i bele ne rua. ");
INSERT INTO bnp_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Lakea e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“O bolea a kodo. Marua e Aron muru vakalipopo e huriki. Na matane ria o ta lakea na kedo dagi, ge bele a naru. Na naro iea, bara o ratea a naru i bele na kedo. E huriki a bakovi a ngatavine turana a maka sipsip a bulmakau ne ria, bara ri ninu.” ");
INSERT INTO bnp_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","E Moses i ramaia a nita ne BAKOVI DAGI, i vano i bolea na kape a kodo vona. ");
INSERT INTO bnp_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","E Moses rua e Aron ru vakalipopo e huriki tabukoi vona ra kedo iea, lakea e Moses i taki ria, i ta maea, “Mu longo valai, mua e huriki a bakovi a ngatavine ni longotaro a ngava. Mu luhoi miri gi bole tala a naru vona a kedo iea?” ");
INSERT INTO bnp_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Muri e Moses i toto rike a limana, i ubi balaka rua a kedo na kodo vona. I tua tala na kedo a naru dagi, lakea e huriki turana a bulmakau a sipsip ne ria ri ninu. ");
INSERT INTO bnp_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Pali e BAKOVI DAGI i taki e Moses e Aron, “Mona marua i uka ma muru luhoi tora iau, i uka ma muru togo iau na matane huriki a Israel. Ngane i uka ma muru gu taparaki lakea e huriki na robo a ta muholi vona ga habia ne ria.” ");
INSERT INTO bnp_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ra maki iea i bele na naru e Meriba, ra tanga e Moses i ratea a naru i tua tala na kedo. Na tanga e Meriba e huriki a Israel ri tapuhaki ne BAKOVI DAGI, lakea e BAKOVI DAGI i vakasiri ria, ia i malamala. ");
INSERT INTO bnp_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","E huriki a Israel ri made na tanga e Kades, lakea e Moses i rudu ranga vinuru ri gi habi a ngava na hariki o Idom. Ri lokovonga ri ta maea, “Mi taparaki a ngava ne huriki a tara ne mua, re huriki a Israel. Ri taki ioe ri ta maea, Ioe o lohoka vona a maka maregoa i bele ne mia. ");
INSERT INTO bnp_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","O lohoka vona e huriki a gare ne mia ri vano ri made o Egipto na pida i kupo. E huriki a Egipto ri rata hale mia. ");
INSERT INTO bnp_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Lakea mi galea e BAKOVI DAGI ge tuhori mia. I longototo mia i rudua tara agelo vona i valai. I tuli tala mia o Egipto, i taparaki valai mia koea. “Ngane mi made o Kades, ra tanga i pesi na harena robo vomu. ");
INSERT INTO bnp_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Mi ngaru go longo ne mia mi gi laho polo vona a robo vomu. Mia turana a maka bulmakau ne mia i uka ma mi gi page dili, mi gi padikudu viliha lae na hania na vit, a vain ne mua, i uka ma mi gi kiru a naru na maka lomu ne mua. Mi gi laho na dala dagi na hariki kunana, mi gi page poloa a robo vomu.” ");
INSERT INTO bnp_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Pali a hariki o Idom i taki e huriki a Israel i ta maea, “I uka liu, naha ni laho polo na robo ne mia. Mua bara mu laho polo na robo ne mia bara si vaubi.” ");
INSERT INTO bnp_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","E huriki a Israel ri taki ria ri ta maea, “Mi ngaru ni ramai a dala dagi kunana. Na tahuna mi ninu a naru ne mua o mi vakaninu a bulmakau, a sipsip ne mia, bara mi konea a naru. Mi ngaru ni laho polo kunana na robo ne mua, e ra pali.” ");
INSERT INTO bnp_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Pali a hariki o Idom i ta tora hateka i ta maea, “I uka liu, naha ni laho polo.” Lakea a tara ne huriki a Idom ri pagitala valai, ri gi vaubi ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","E huriki a Idom ri marikoi e huriki a Israel ri gi laho polo na robo ne ria, lakea e huriki a Israel ri pe mulea e Idom ri ramai a dala tara. ");
INSERT INTO bnp_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","E huriki a Israel lobo ri pe mulea e Kades, ri laho lokovonga ri bele na lolo e Hor, ");
INSERT INTO bnp_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","na harena a robo e Idom. Ri made vona a lolo iea, lakea e BAKOVI DAGI i taki e Moses e Aron i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aron, i uka ma go lakea vona a robo a taki ta ga habia ne huriki a Israel. Ioe bara o mate a vuhuna muru longotaro a ngavagu na naru e Meriba. ");
INSERT INTO bnp_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","O Moses, o tungari e Aron turane tuna e Eleasar moto sike na lolo e Hor. ");
INSERT INTO bnp_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","O kali tala a maka bagetua na prister e Aron o vakarodo e Eleasar, a vuhuna e Aron bara i mate vona a lolo iea.” ");
INSERT INTO bnp_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Lakea e Moses i ramai a nitane BAKOVI DAGI, i tuli e Aron e Eleasar to sike na lolo. E huriki a Israel ri matai tou to vano. ");
INSERT INTO bnp_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Na tahuna to bele meli, lakea e Moses i kali tala a maka bagetua ne Aron i vakarodo e Eleasar, e tune Aron, vona. E Aron i made na lolo i mate. Muri e Moses e Eleasar ru raga puru na lolo. ");
INSERT INTO bnp_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Na tahuna e huriki a bakovi a ngatavine ri lohoka vona e Aron i mate pali, ria lobo ri taringia na parava i ravulu tolu. ");
INSERT INTO bnp_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","A hariki o Arad na robo e Kenan, i made o Negev, i longo e huriki a Israel ri ramai a dala ne Atarim. Lakea i bole e huriki a nugumaheto vona ri vaubi turane huriki a Israel. Ri lakavu ranga Israel ri vano turane ria. ");
INSERT INTO bnp_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","E huriki a Israel ri ratea tara ngava dagi ne BAKOVI DAGI, ri ta maea, “Ioe bara o habi mia na limane ria, bara mi ratapile lobo a tanga ne ria.” ");
INSERT INTO bnp_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","E BAKOVI DAGI i longoa a nitane ria i kori ria, ri rangi e huriki a Kenan. Lakea e huriki a Israel ri ratapile hateka e huriki a Kenan turana a tanga ne ria. Ri galea liu a tanga iea e Horma. ");
INSERT INTO bnp_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","E huriki a Israel ri pe mulea a lolo e Hor, ri ramai a dala dagi i lakea na Dari Vururu, na tabeke ne Akaba, a vuhuna ri ngaru ni polo gege vona a robo ne huriki a Idom. Ri laho laho, ri kide tala. ");
INSERT INTO bnp_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ri tapuhaki na Vure ne Moses ri ta maea, “I navai muru tuli tala mia o Egipto mi gi mate tavula koea na tabeke i ngeki? I uka maki ni kani koea! I uka naru! Mi marikoi vona ra mana mi kani balea, i uka ma a maki ni kani muholi.” ");
INSERT INTO bnp_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","E BAKOVI DAGI i longo a nitapuhaki ne ria, lakea i rudu a maka mata hale ri valai ne huriki a Israel ri kanipile ria, lakea i kupo ri mate. ");
INSERT INTO bnp_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","E huriki a bakovi a ngatavine ri valai ne Moses ri ta maea, “Mi rata a naro hale pali ne BAKOVI DAGI na tahuna mi tapuhaki ne marua e BAKOVI DAGI. Ngane o vasileki ne BAKOVI DAGI ge lili vuroki a maka mata nga.” Lakea e Moses i vasileki ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","E BAKOVI DAGI i longoa a nivasileki ne Moses lakea i takia, “O ratea tara hanuna mata hale o vakatavorea na kai ge ola. E rei a viri i kani ia a mata, ge mata rike maia bara i mahuri.” ");
INSERT INTO bnp_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Lakea e Moses i ratea na bras tara hanuna mata i vakatavorea na kai i ola. Na tahuna a mata hale i kani ria, bara ri mata rike maia, bara ri mahuri. ");
INSERT INTO bnp_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","E Huriki a Israel ri pea a lolo e Hor ri laho lokovonga ri bele na tanga e Obot, ri rata a mada. ");
INSERT INTO bnp_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Muri ri pea e Obot ri vano ri bele na tanga e Abarim, ri rata a mada. Ra tanga e Abarim i pesi na nirikena haro na robo e Moab, na tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Muri ri pea a hini nga, ri vano ri rata a mada na maloku ne Sered. ");
INSERT INTO bnp_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Muri ri pea e Sered ri tulu poloa a naru e Arnon, ri rata a mada na tabeke mule sike na naru e Arnon, na tabeke i ngeki. Ra tabeke i ngeki iea i dili na robo ne huriki a Amor. Ra naru e Arnon i nagi a robo e Moab e Amor. ");
INSERT INTO bnp_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","A Puhu na Nuverei na Vabinga ne BAKOVI DAGI i taki a tanga e Vahep na tabeke ne Supa, a maka maloku na naru e Arnon, ");
INSERT INTO bnp_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","turana a maka maloku i lokovonga i harena na tanga e Ar, i lokovonga i harena na robo e Moab. ");
INSERT INTO bnp_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Muri ri pea a tabeke iea ri vano ri bele o Bia, ra tanga iea i tahoka a naru ni keli. Ra tabeke e BAKOVI DAGI i takia e Moses vona a naru iea hosi, i ta maea, “O gale palupu e huriki a bakovi a ngatavine ga habi a naru ne ria.” ");
INSERT INTO bnp_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Na parava iea e huriki a Israel ri ratea tara linge, ri kaloloa: “Naru, o bubu rike, o tua lokovonga, mi gi masia mi gi kalolo a linge na nivivi. ");
INSERT INTO bnp_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","E huriki a gare ri bole a kodo-hariki, ri kelia a lomu iea.” Muri ri pea a tabeke i ngeki iea ri lakea na tanga e Matana. ");
INSERT INTO bnp_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Ri pea e Matana ri lakea na tanga e Nahaliel, muri ri pea e Nahaliel ri lakea na tanga e Bamot. ");
INSERT INTO bnp_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Ri pea e Bamot ri lakea na maloku ne Moab. Ra maloku iea i tabukoi na lolo e Pisga. Ra lolo iea e huriki bara ri pesi vona ri tuva lakea na tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Muri e huriki a Israel ri rudu a vinuru ne Sihon a hariki o Amor, ri ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Mi gi laho polo vona a robo vomu. I uka ma mi gi page dili mai a maka hania na vit o a hania na vain ne mua. A naru ne mua na lomu ranga i uka ma mi gi ninu. Mi gi ramai kunana a dala dagi na hariki, bara mi pe mule a robo ne mua.” ");
INSERT INTO bnp_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Pali a hariki e Sihon i marikoi. I gale palupu e huriki a nugumaheto vona, ri lakea na tanga e Iahas na tabeke i ngeki, ri vaubi turane huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Pali e huriki a Israel ri rabalaki na bainat e huriki a Amor ri ala kupo, ri bolea a malala ne ria, i vakatubu na naru e Arnon, i vano i harena na naru e Iabok na tabeke mule sike. Ra hini nga a harena a robo e Amon. E huriki a Amon ri tahoka e huriki a tara na maheto ri tora hateka, ri tagaria a harena malala ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Lakea e huriki a Israel ri bolea a tanga e Hesbon, turana a maka tanga tabukoi vona. Ri bole lobo tabu a maka tanga ne huriki a Amor, ri made vona, ");
INSERT INTO bnp_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","a vuhuna e Hesbon a tanga ne Sihon, a hariki ne huriki a Amor. Hosi e Sihon i vaubi turana a tara na hariki ne huriki a Moab, i bole lobo a maka tabekena malala vona, i harena na naru e Arnon. ");
INSERT INTO bnp_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","I mavonga e huriki ri bole visia a linge iea: “Mu valai o Hesbon ra tanga na hariki e Sihon. Ni gi rata tabu e Hesbon ge pesi tora. ");
INSERT INTO bnp_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ni Gi Hosi e huriki a tara na nugumaheto ne Hesbon, e Sihon ri pea a tanga, ri vano ri vaubi hateka, na tanga e Ar na robo e Moab, i manga a kanono i gutu a rehi. E huriki a nugumaheto ri ratapilea a tanga iea, ri vakalobo liu e huriki a bakovi dagi ri made na lolo, na naru e Arnon. ");
INSERT INTO bnp_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ai-o Moab! Bara mu tahoka a maregoa dagi hateka. Mua o huriki a ngate ne Kemos, bara mu vurua. Ra vure ne mua, i rata e huriki ri ramaia, ri pemo pali, ri made manga a bakovi i laho viliha. I ratea e Sihon, a hariki ne huriki a Amor i nugu tata e huriki e tuna mua ngatavine. Ri vora tavula vona. ");
INSERT INTO bnp_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Pali ngane mi rabalaki ria pali, re huriki a tara na tanga dagi e Hesbon, i vano i harena na tanga e Dibon. Mi ratapile hateka ria, i vano i harena na tanga e Nopa, tabukoi na tanga e Medeba.” ");
INSERT INTO bnp_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Lakea e huriki a Israel ri bole a maka tanga ne huriki a Amor. ");
INSERT INTO bnp_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Muri e Moses i rudu e huriki ri kasisia a tanga e Iaser. Lakea e huriki a Israel ri vaubi o Iaser, ri bolea a tanga iea turana a maka tanga tabukoi. Ri lili tala e huriki a Amor ra ri made vona a tanga iea. ");
INSERT INTO bnp_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Muri e huriki a Israel ri ngalakapulo, ri ramaia a dala i lakea na robo e Basan. Lakea e Og, a hariki o Bosan, turane huriki a nugumaheto vona, ri valai ri vaubi turane huriki a Israel na tanga e Edrei. ");
INSERT INTO bnp_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","E BAKOVI DAGI i takia e Moses i ta maea, “Naha ni mangenge ne ria, bara tuhori mua mu ratapile ria, mu bolea a malala ne ria. Bara mu ratapilea i manga a hini mu ratapilea e Sihon, a hariki o Amor, ra i matakari o Hesbon.” ");
INSERT INTO bnp_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Lakea e huriki a Israel ri ramaia ra ngava iea ri rabalakia a hariki e Og, turana e huriki e tuna bakovi, e huriki a tara na nugumaheto vona, e huriki a bakovi a ngatavine na tanga vona, i uka liu tara viri ge mahuri. Muri e huriki a Israel ri bolea a malala ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Muri e huriki a Israel ri pea a tabeke iea, ri vano ri rata a mada na bilane e Moab. Ra bila iea i tabuli na nirikena haro na tabeke mule lokovonga ne Iordan, tabukoi o Ieriko. ");
INSERT INTO bnp_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","E Balak, e tune Sipor bakovi, ia a hariki ne Moab. I longo a maka maki e huriki a Israel ri rata ne huriki a Amor. ");
INSERT INTO bnp_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ia turane huriki a Moab ri matai e huriki a tara bulolo ne Israel, ri mangenge hateka ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Lakea e huriki a Moab ri taki e huriki a matakari ne huriki a Midian ri ta maea, “I uka ma ge tabaka re huriki a tara bulolo nga bara ri vakalobo a maka maki ri tabuli viliha na tabeke ne hita, i manga a maka bulmakau ri kani a varili.” ");
INSERT INTO bnp_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Lakea a hariki e Balak i rudu e huriki a vinuru ri gi takia e Balam, e tune Beor bakovi, ge valai ge masia. E Balam i made na tanga e Petor tabukoi na naru e Iupretis, na robo ne huriki a Amav. E Balak i taki e huriki a vinuru vona ri gi takia e Balam ri gi ta maea, “E huriki a bakovi a ngatavine ri pea a robo e Egipto. Ria a tara dagi hateka. Ngane ri made tabukoi ne mia. ");
INSERT INTO bnp_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Re huriki nga ri gao hateka, i uka ma i kara mi gi rangi ria. I mavonga, i ngaru ioe, go valai go ruduraha ria. Ioe bara o rata mavonga, bara mi vaubi hateka, bara mi rangi ria, mi lili tala ria na malala ne mia. A viri o gamaia bara i made kamumu. A viri o rudurahea bara i bole a vuranga.” ");
INSERT INTO bnp_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Lakea e huriki a gare ne Moab e Midian ri vano ri gi vakalongo e Balam vona a ngava iea. Ri bole ranga moni ri gi kona e Balam vona, ge ruduraha e huriki a Israel. Ri vano ri bele ne Balam ri takia vona a ngavana hariki e Balak. ");
INSERT INTO bnp_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Lakea e Balam i taki ria, i ta maea, “Mu mahita na ruma nau na rodo. Bara taki mua vona a ngava e BAKOVI DAGI ge taki iau vona.” Lakea ri mahita vonga. ");
INSERT INTO bnp_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","A Vure i valai ne Balam i nanea, “E rei re huriki ri made turamu?” ");
INSERT INTO bnp_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","E Balam i takia a Vure, i ta maea, “E Balak, e tune Sipor, a hariki o Moab i rudu valai ria ri gi vakalongo iau, ri ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","e huriki a bakovi a ngatavine, ri valai o Egipto ri laho viliha na robo e Moab. I ngaru iau ga ruduraha e huriki a Israel, lakea a Vure ge ratapile ria, ge gao na vabinga ia ge lili tala ria.” ");
INSERT INTO bnp_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Lakea a Vure i takia e Balam i ta maea, “Naha ni vano turana re huriki a bakovi nga. Naha ni ruduraha e huriki nga, a vuhuna iau a gamai ria pali.” ");
INSERT INTO bnp_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Na hatelanga e Balam i lakea na gare ne huriki a vinuru ne Balak i ta maea, “Mu hamule mai a robo ne mua. Iau i uka ma ga vano, a vuhuna e BAKOVI DAGI i hatekakari iau.” ");
INSERT INTO bnp_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Lakea e huriki a vinuru ri hamule ri takia e Balak ri ta maea, “E Balam i marikoi ni valai turane mia.” ");
INSERT INTO bnp_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Muri e Balak i rudu e huriki a matakari ri dagi hateka ne huriki a matakari muga, ");
INSERT INTO bnp_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ri lakea ne Balam ri ta maea, “E Balak, e tune Sipor i ngaru go lakea taro vona. Nahea tara maki ge vakapae ioe. ");
INSERT INTO bnp_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","O valai bara i habi vomu a maka mahala i kupo, bara i rata a maki lobo o ngaru ge rata. I ngaru ioe go valai go ruduraha e huriki nga.” ");
INSERT INTO bnp_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Pali e Balam i koli i ta maea, “Iau a uka ngava vona e Balak. I ngaru ge habia nau a roho-hariki vona i vonu vona a maka silva, a gol, i uka ma ga lakene, a vuhuna a keri ni longotaro a nitane BAKOVI DAGI a Vure nau. ");
INSERT INTO bnp_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Pali mu mahita na roho nau na rodo, ga dava taroa e BAKOVI DAGI i tahoka ranga ngava ge habi nau o i uka.” ");
INSERT INTO bnp_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Na rodo iea a Vure i valai ne Balam i takia, i ta maea, “Re huriki a bakovi nga ri valai ri taki ioe go vano turane ria. I kamumu, o vano turane ria. Pali a ngaru go rata lobo a maka ngava ga taki ioe vona go rata. Naha ni rata tabua tara maki.” ");
INSERT INTO bnp_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Na hatelanga e Balam i kisia a donki vona, i rike vona, i vano turane huriki a matakari nga o Moab. ");
INSERT INTO bnp_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","I tura a bakovi ala rua, ru laho turana. Pali a Vure i tahate hateka ne Balam na tahuna i vano turane ria. Lakea i rudua a agelo ne BAKOVI DAGI ge pesi karia a dala ge hehea. ");
INSERT INTO bnp_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","A donki vona i masia a agelo ne BAKOVI DAGI i toto silala a bainat vona, lakea i toni ni polo lele vona. Pali e Balam i hotua a donki vona ge hamule mai a dala. ");
INSERT INTO bnp_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Muri a agelo ne BAKOVI DAGI i muga, i pesi kari na dala bala holoholo na kurukuruna a hania na vain i rua. A hania nga ni tura kari na kedo. ");
INSERT INTO bnp_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Na tahuna a donki i masia a agelo ne BAKOVI DAGI, i polo lele, i koro na nure, i kapi tatea na nure a vahane Balam. Lakea e Balam i hotu tabua a donki vona. ");
INSERT INTO bnp_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","A agelo ne BAKOVI DAGI i muga tabu i pesi kari a dala i bala holoholo liu, i uka hini ge polo lele vona na maurina o na kanena a donki. ");
INSERT INTO bnp_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Na tahuna a donki i masia a agelo i pesi kari tabua a dala, i mahita puru na dala. Lakea e Balam i madihi tata a hatena, i bolea a lebo i hotua a donki. ");
INSERT INTO bnp_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","E BAKOVI DAGI i ratea a donki i ta, i takia e Balam i ta maea, “A ra a ratea vomu o hotu iau balaka tolu?” ");
INSERT INTO bnp_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","E Balam i takia a donki i ta maea, “O rata iau a mata manga a manga lakea a hotu ioe. Iau ga tahoka a bainat bara rabalaki ioe ngane kunana.” ");
INSERT INTO bnp_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Lakea a donki i ta maea, “Iau a donki vomu o rike nau na tahuna a karaba vona i valai i harena mona. I hosi, iau a rata maea ioe?” Lakea e Balam i koli i ta maea, “I uka”. ");
INSERT INTO bnp_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Lakea e BAKOVI DAGI i vakapalalea a matane Balam, i masia a agelo ne BAKOVI DAGI i pesi kari a dala, i toto silala a bainat vona. Lakea i tabuli ngalabarara puru na malala. ");
INSERT INTO bnp_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Lakea a agelo ne BAKOVI DAGI i takia, i ta maea, “I navai o hotu balaka tolu maea a donki vomu? O longo, iau a valai a pesi karia a dala, ga gege ioe, a vuhuna iau i uka ma vivi vomu go vano.” ");
INSERT INTO bnp_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Pali a donki vomu i matai iau i polo lele nau balaka tolu. A donki i uka ma ge polo lele, bara rabalaki ioe pali, pali a donki bara i mahuri. ");
INSERT INTO bnp_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Muri e Balam i koli a ngavana agelo ne BAKOVI DAGI, i ta maea, “Iau a ratea a rabu hale i uka ma i kamumu, i uka ma lohoka vomu o pesi karia a dala. Ngane i uka ma o vivi vona a nilaho nau, ga hamule na tanga.” ");
INSERT INTO bnp_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Pali a agelo ne BAKOVI DAGI i takia, i ta maea, “I uka maki, o vano turana e huriki nga. Pali a ngaru ioe go taki kunana a ngava nau, a ngava ranga naha ni taki.” Lakea e Balam i vano turana e huriki a bolekori ne Balak. ");
INSERT INTO bnp_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Na tahuna e Balak i longoa e Balam i laho valai na dala, lakea i vano i taguia na tanga dagi e Moab. A tanga iea i pesi tabukoi na naru e Arnon, ra nagi ne Moab. ");
INSERT INTO bnp_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Lakea e Balak i takia e Balam, “Muga a rudu e huriki a vinuru ri lakene ri taki tora ioe go valai. I navai i uka ma o valai? O luhoi iau a keri ni habi a mahala vomu?” ");
INSERT INTO bnp_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Lakea e Balam i koli i ta maea, “Naha ni ta kupo lae, iau a valai pali. Pali ga vakalongo kunana a ngavana Vure i habi nau. Iau a keri ni rata a ngava ranga.” ");
INSERT INTO bnp_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Muri e Balam i vano turane Balak ru lakea na tanga e Kiriat-Husot. ");
INSERT INTO bnp_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Lakea e Balak i rabalaki ranga bulmakau a sipsip, ge a nihabi. I habi ne Balam ne huriki a bolekori vona ranga balena. ");
INSERT INTO bnp_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Na hatelanga e Balak i tulia e Balam ru sike na tanga e Bamot-Bal. E Balam i pesi vonga i tuva puru i matai ranga e huriki a Israel ri pesi tano. ");
INSERT INTO bnp_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","E Balam i takia e Balak, i ta maea, “O rata koea a dede ge polorua nau, o kisi a bulmakau a toga ge polorua, a sipsip a toga ge polorua.” ");
INSERT INTO bnp_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Lakea e Balak i rata a maki e Balam i takia ge rata, lakea ru rata a nihabi na dede i polorua, ru rata a nihabi na bulmakau a toga, a sipsip a toga na maka dede takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Muri e Balam i takia e Balak i ta maea, “O pesi tabukoi na nihabi gutu-vuro vomu, iau ga pesi tala, ga masia e BAKOVI DAGI ge tagui iau o ge uka? Ia ge taki iau vona tara maki, ga valai ga vakalongo ioe.” Muri i sike na mapana lolo. ");
INSERT INTO bnp_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Lakea a Vure i taguia e Balam. Lakea e Balam i takia a Vure i ta maea, “Iau a rata a dede i polorua, a rata a nihabi na bulmakau a toga, a sipsip a toga, na dede kedo takutaku.” ");
INSERT INTO bnp_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Muri e BAKOVI DAGI i habi a ngava ne Balam, i ta maea, “O hamule ne Balak o takia vona a ngava iea.” ");
INSERT INTO bnp_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Na tahuna e Balam i hamule, i masia e Balak i pesi turane huriki a bakovi dagi na robo e Moab, tabukoi na nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Lakea e Balam i vakalongo ria na nita vakakika, i ta maea, “E Balak a hariki o Moab i bole valai iau koea. I bole tala iau o Siria, na tabeke na nirikena haro, a valai koea. I taki iau i ta maea, ‘Iau a ngaru go valai koea, go ruduraha e huriki a Israel.’ ");
INSERT INTO bnp_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","“A Vure i uka ma i ruduraha ria, pali iau, i navai ga ruduraha na vai ria? E BAKOVI DAGI i uka ma i pelekado ria, ga pelekado navai ria? ");
INSERT INTO bnp_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","A pesi na mapana lolo kedo kedo a matai ria. A matai e huriki ri made herehere. Ri lohoka vona i uka ma ri manga e huriki na robo ranga. ");
INSERT INTO bnp_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","“A hamone huriki a Israel bara ri ala kupo hateka ri manga a habulo na malala. I uka tara viri ge kara ni gi palupu ria. A ngaru ga made manga ria ge harena na parava a mate vona. Muholi hateka, a ngaru ni made na nivalemu, ga mate manga a bakovi malamala.” ");
INSERT INTO bnp_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Muri e Balak i takia e Balam i ta maea, “I navai o ratea nau a rabu maea? A bole valai ioe koea, go ruduraha e huriki a pile. Pali i uka ma o rata mavonga, o gamai ria.” ");
INSERT INTO bnp_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Lakea e Balam i koli i ta maea, “Pali a ra ngava ga taki tabua? Iau bara taki kunana a ngava e BAKOVI DAGI i habi nau.” ");
INSERT INTO bnp_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Muri e Balak i takia e Balam i ta maea, “O valai turagu ngane tu gu lakea na tanga tara, go matai ria. I uka ma go matai lobo ria. O pesi vona a tabeke iea, a ngaru go ruduraha puru ria.” ");
INSERT INTO bnp_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Lakea ru sike na bilane Sopim na mapana lolo e Pisga. I rata vonga a dede i polorua, i rata a nihabi na bulmakau a toga a sipsip a toga na dede takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Lakea e Balam i takia e Balak i ta maea, “O pesi tabukoi na nihabi gutu-vuro, ga vano taro iau, ga ta turana Vure na harehare.” ");
INSERT INTO bnp_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","E Balam i vano, lakea e BAKOVI DAGI i bele vona, i takia na maka nita ge taki. Muri i ta maea, “O hamule o vakalongoa e Balak vona a nita iea.” ");
INSERT INTO bnp_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","I hamule i masia e Balak turane huriki a bakovi dagi o Moab tabukoi na maka nihabi gutu-vuro. Lakea e Balak i nanea e Balam i ta maea, “E BAKOVI DAGI i ta navai?” ");
INSERT INTO bnp_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Lakea e Balam i vakalongoa vona a nita vakakika iea, “O Balak, tune Sipor, o longoa a ngava ga taki. ");
INSERT INTO bnp_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","A Vure i uka ma i tatami kilala ge manga hita. Ia bara i ta muholi vona tara maki ge ratea, bara i ratea. I ta kunana na maki i ngaru ge bele, bara i bele. ");
INSERT INTO bnp_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","A Vure i taki iau ga gamai ria. Ia kunana i gamai ria. A keri ni pulo a niluhoi vona. ");
INSERT INTO bnp_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","A maka maki a matai ge bele ne huriki a Israel, i uka ma ge rata hale ria. E BAKOVI DAGI a Vure ne ria i made turane ria. Ri vivi, ri magulu rike, a vuhuna ia a hariki ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","A Vure i bole tala ria o Egipto. I vaubi turane huriki a pile vona. I gao hateka i manga a bulmakau i tegi. ");
INSERT INTO bnp_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Na tahuna e huriki a pile ri ubi e huriki a Israel na muto o ri ruduraha, i uka ma ge rata hale ria. Ngane e huriki bara ri taki virihi e huriki a Israel, ri ta maea, ‘Mu matai a maka maki dagi a Vure i rata.’ ");
INSERT INTO bnp_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","E huriki a Israel ri pesi rike manga a laion i gao hateka. I uka ma ri malo malaviriri. Bara ri kani a bobona, ri ninu a darana kania. Muri bara ri malo.” ");
INSERT INTO bnp_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Muri e Balak i takia e Balam i ta maea, “Pali, naha ni ruduraha ria, naha ni gamai ria!” ");
INSERT INTO bnp_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Lakea e Balam i koli i ta maea, “Hosi a taki ioe bara rata kunana a maki e BAKOVI DAGI i taki iau vona ga rata. ");
INSERT INTO bnp_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Lakea e Balak i takia e Balam maea, “O valai turagu ga taparaki ioe lakea na tanga tara. A Vure ma ge matai ioe o pesi na tabeke tara, bara i longo ioe go ruduraha ria.” ");
INSERT INTO bnp_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Muri i tulia e Balam ru sike na mapana lolo e Peor, ru tuva lokovonga liu ru masia a tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Lakea e Balam i takia, i ta maea, “O rata a dede ge polorua koea. O kisi a bulmakau a toga ge polorua, a sipsip a toga ge polorua.” ");
INSERT INTO bnp_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","E Balak i longoa a ngava iea i rata manga a hini e Balam i taki. I rata a nihabi na bulmakau a toga, a sipsip a toga, na dede takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ngane e Balam i lohoka vona e BAKOVI DAGI i ngaru ni gamai e huriki a Israel, lakea i uka ma i rata a malulu ge kasisi manga a hini muga i rata. I mata lakea na tabeke i ngeki. ");
INSERT INTO bnp_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","I matai a maka kape ne huriki a Israel ri vapesihi ramai a kabu takutaku ne ria. Muri a Hanuna Vure i bele vona, ");
INSERT INTO bnp_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","i ta vakakika, i ta maea: “Iea a nitane Balam, e tune Beor. A nita iea na viri i para hateka a matana, i matai kamumu a maka maki. ");
INSERT INTO bnp_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","A nitana viri i longo a nitana Vure, ra viri i matai a vurena i valai na Vure Tuhaka Hateka, ra viri i tabuli puru, i palala a gina. ");
INSERT INTO bnp_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","A matai a maka kape ne huriki a Israel, ri mata kamumu hateka. ");
INSERT INTO bnp_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ra maka kape nga ri ola manga a kai a det, ri manga a hania ni rata na gagana naru dagi, ri manga a maka kai dagi e BAKOVI DAGI i varo, ri manga a maka kai a sida ri pesi na dahana naru. ");
INSERT INTO bnp_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","A naru ge vonu pasilua, ge maguru tala na tavila vona. E huriki a hamona i uka ma ri gi bala a naru. A hariki ne ria, a rana bara i dagi, i gao hateka na hariki e Agag. A hariki o Israel bara i matakari e huriki ri ala kupo. ");
INSERT INTO bnp_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","A Vure i bole tala ria o Egipto, a vuhuna a Vure i made turane ria, ri gao hateka, manga a bulmakau i tegi. Ri vakalobo liu e huriki a pile ne ria. Ri raputu a tuhane huriki a pile, ri padimate ria na maheto. ");
INSERT INTO bnp_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","E Israel i manga a laion, i mahita. E rei ge vangoa? Ni gi gamai e huriki ri gamai ioe. Ni gi ruduraha e huriki ri ruduraha ioe!” ");
INSERT INTO bnp_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","E Balak i madihi tata a hatena, i kanipilu a limana i takia e Balam i ta maea, “Iau a gale valai ioe koea ta go ruduraha e huriki a pile nau, pali i balaka tolu o gamai ria. ");
INSERT INTO bnp_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ge a ra ngane, a marikoi. O hamule lakea na tanga vomu. Muga a ta muholi ni habi a maka mahala vomu, pali e BAKOVI DAGI i putu tagu a dalamu, i uka ma go bole ngane.” ");
INSERT INTO bnp_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Lakea e Balam i koli i ta maea, “A taki a vinuru o rudu valai ri gi bole iau a ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘E Balak ge ngaru ni habi a maka gol, a maka silva, ri tabuli na ruma-hariki vona, iau i uka ma ga bole, a vuhuna i uka ma ga ratea tara maki na ningaru nau, ma ga longotaro a nitane BAKOVI DAGI. Ga vakalongo kunana a ngava e BAKOVI DAGI i ngaru ga vakalongo.’ ");
INSERT INTO bnp_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ngane ga hamule mai e huriki a viri nau. Pali ga taki taro ioe vona a maka maki e huriki a Israel ri gi rata na tara vomu muri ma.” ");
INSERT INTO bnp_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Lakea e Balam i ta vakakika i ta maea, “Iau e Balam e tune Beor, mu longoa a nita vakakika nau. A matagu i para hateka a matai kamumu a maka maki. ");
INSERT INTO bnp_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","A nitana viri i longo a nitana Vure, ra viri i lohoka na lohokanga na Vure Meli Liu, ra viri i matai a vurena i valai na Vure Tuhaka Hateka, ra viri i tabuli puru, i palala a gina. ");
INSERT INTO bnp_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","A masia, pali i tabana, a masia, pali i uka ma i tabuli tabukoi. A hada bara i pagitala valai ne Iakop, a kodo hariki bara i pesi rike o Israel. Bara i ubi momo a dumena matana e huriki a Moab, bara i ubi momo a gine huriki e tune Set. ");
INSERT INTO bnp_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","E Idom bara ni ratapile, a pile vona e Seir tara bara ni ratapile, pali a Israel bara i gao hateka. ");
INSERT INTO bnp_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","A matakari bara i valai na kabu ne Iakop. Bara i ratapile e huriki ri tababana ni mahuri na tanga.” ");
INSERT INTO bnp_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Muri e Balam i matai e huriki a Amalek, i vakalongo a nita vakakika ne ria i ta maea: “E huriki a Amalek, muga ri gao hateka. Muri bara ri bole a vuranga dagi.” ");
INSERT INTO bnp_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Muri i matai e huriki a Keni, i vakalongo a nita vakakika ne ria i ta maea: “Ra tanga mu made i uka viri ge ratapilea. A tanga mu made vona i pesi tora manga a nuna loha i tabuli langa na kedo na mapana lolo. ");
INSERT INTO bnp_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ni Gi Pali e huriki a Asur bara ri vaubi turane mua, bara ri ratapile mua, ri lakavu e huriki a tara ne mua. ");
INSERT INTO bnp_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Muri e Balam i vakalongo tabua tara nita vakakika i ta maea: Na tahuna a Vure ge ratea ra naro iea, e rei ge mahuri? ");
INSERT INTO bnp_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ni Gi E huriki a Saiprus bara ri rike na aga ne ria ri valai ri vakamadihi e huriki a Asur e huriki a Eber. Pali ria ranga bara ri vurua.” ");
INSERT INTO bnp_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Muri e Balam i malaga i hamule mai a tanga vona, e Balak tara i malaga i hamule mai a tanga vona. ");
INSERT INTO bnp_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Na tahuna e huriki a Israel ri made na maloku ne Sitim, lakea e huriki a bakovi o Israel ri tubu ni rata a narona molenga turane huriki a ngatavine o Moab. ");
INSERT INTO bnp_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Re huriki a ngatavine nga ri gale e huriki a bakovi o Israel ri gi rata a nihabi i lakea na maka vure ne ria, ri lokovonga ne huriki a Moab ri kani turane ria, ri turume na ngalana vure ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Lakea e huriki a Israel ri rihi a vure e Bal o Peor, lakea e BAKOVI DAGI i tahate ria. ");
INSERT INTO bnp_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Muri e BAKOVI DAGI i takia e Moses, i ta maea, “O turari lobo e huriki a matakari ne mua e huriki a Israel, ra ri rata a naro hale, o vakatavore ria, o rabalaki ria na matane BAKOVI DAGI na haro. Bara mu rata mavonga ge lobo a rongova nau ne huriki a Israel.” ");
INSERT INTO bnp_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Lakea e Moses i taki e huriki a mari ni pelekado ne Israel i ta maea, “Mua takutaku mu rabalaki lobo e huriki na kabu ne mua ra ri rihi e Bal o Peor.” ");
INSERT INTO bnp_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Na tahuna e Moses turane huriki a bakovi a ngatavine ri tangi tabukoi na matana Kape na Vaponga, ri masia tara bakovi o Israel i bolea tara ngatavine o Midian i dili turana na kape vona. ");
INSERT INTO bnp_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Na tahuna e Pinias, e tune Eleasar e tubune Aron a prister, i matai rua, i pe e huriki a bakovi a ngatavine, i vano i bole a maheto vona, ");
INSERT INTO bnp_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","i muri mai rua i dili na kape na bakovi iea, i paditata rua na maheto ru mate. Muri i lobo a gilanga dagi, ra i ratapile e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","E huriki ala 24,000 ri mate. ");
INSERT INTO bnp_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Lakea e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“E Pinias, e tune Eleasar e tubune Aron a prister, i vakalobo liu a rongova nau ne huriki a Israel, i rabalaki rua pali, ngane a uka a rongova ne ria. I bage ne huriki a Israel, i manga iau a bage ne ria. I mavonga i uka ma ga vakalobo liu ria. ");
INSERT INTO bnp_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","I mavonga o takia e Pinias, ngane iau a rata a ngava dagi na nivalemu turana. ");
INSERT INTO bnp_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","A ngava dagi iea ne vona e huriki a hamona, ri gi leho vakaroro manga a prister nau, a vuhuna e Pinias i bage ne huriki a Israel, i ramai a narona Vure vona. A naro e Pinias i ratea i kavitagu e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","A bakovi o Israel e Pinias i rabalakia turana a ngatavine o Midian, a rana e Simri. E Simri e tune Salu, a hamone Simion, ia a gare na kabu vona. ");
INSERT INTO bnp_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","A ngatavine o Midian, a rana e Kosbi e tune Sur, a gare ne Midian. ");
INSERT INTO bnp_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Muri e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Mu vano mu rata tuhare e huriki a Midian mu rabalaki ria, ");
INSERT INTO bnp_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","a vuhuna ri vakamarego mua na tahuna ri tami mua na narone kurabane ria, e Kosbi, e tuna ngatavine na bakovi dagi tara o Midian. Ra ngatavine iea, ni rabalaki na tahuna a gilanga dagi i bele, a vuhuna a maka naro i bele o Peor.” ");
INSERT INTO bnp_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Muri na gilanga dagi i lobo, e BAKOVI DAGI i taki e Moses, e Eleasar e tune Aron a prister, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Ngane muru here puru a rane huriki a bakovi ne huriki a kabu lobo ne Israel ri tahoka a pida i ravulu rua i rike, ri kara ni vaubi, ge ria a nugumaheto ne Israel.” ");
INSERT INTO bnp_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Na maloku ne Moab na dahane Iordan tabukoi na tanga e Ieriko, e Moses e Eleasar a prister ru taki e huriki a Israel ru ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Mu bole a rane huriki a bakovi ri tahoka a pida i ravulu rua i rike, ge ramaia a nitane BAKOVI DAGI i habia ne Moses.” Re huriki a Israel ri mariu tala o Egipto, ni gi palupu ra nga: ");
INSERT INTO bnp_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","E huriki a hamone Reuben a tabua ne Israel ra nga: a kabu ne Hanok, a kabu ne Palu, ");
INSERT INTO bnp_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","a kabu ne Herson, a kabu ne Karmi. ");
INSERT INTO bnp_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ra kabu ne Reuben nga, ri vakabele e huriki ri ala 43,730. ");
INSERT INTO bnp_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","E Eliab e tune Palu bakovi. ");
INSERT INTO bnp_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","E huriki e tune Eliab a bakovi ra nga: e Nemuel, e Datan, e Abiram. Hosi e huriki a Israel ri ru e Datan, e Abiram ru matakari, pali ru longotaro a nitane Moses e Aron. Ra bakovi nga, turana a tara ne Kora, ri longotaro e BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Lakea a malala i mapoka i bele a lovo dagi, to boru puru na lilona malala, lakea a malala i kavitagu tou. To mate na tahuna a kanono i ratapile e huriki a turane Kora ri ala 250, i manga a kilakila. Na naro iea kunana a Vure i habi a niluhoi dagi ne huriki, nahea ri gi ramai a naro hale nga. ");
INSERT INTO bnp_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Pali a kabu ne Kora i uka ma i lobo. ");
INSERT INTO bnp_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","E huriki a hamone Simion ra nga: a kabu ne Nemuel, a kabu ne Iamin, a kabu ne Iakin, ");
INSERT INTO bnp_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","a kabu ne Sera, a kabu ne Saul. ");
INSERT INTO bnp_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ra kabu ne Simion nga ri vakabele e huriki a bakovi ri ala 22,200. ");
INSERT INTO bnp_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","E huriki a hamone Gad ra nga: a kabu ne Sepon, a kabu ne Hagi, a kabu ne Suni, ");
INSERT INTO bnp_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","a kabu ne Osni, a kabu ne Eri, ");
INSERT INTO bnp_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","a kabu ne Arod, a kabu ne Areli. ");
INSERT INTO bnp_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ra kabu ne Gad nga, ri vakabele e huriki a bakovi ri ala 40,500. ");
INSERT INTO bnp_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","E Er, e Onan e tune Iuda, pali ru mate o Kenan. ");
INSERT INTO bnp_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","E huriki a hamone Iuda ra nga: a kabu ne Sela, a kabu ne Peres, a kabu ne Sera. ");
INSERT INTO bnp_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","E huriki a hamone Peres ra nga: a kabu ne Hesron, a kabu ne Hamul. ");
INSERT INTO bnp_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ra kabu ne Iuda nga ri vakabele e huriki a bakovi ri ala 76,500. ");
INSERT INTO bnp_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","24","E huriki a hamone Isikar ra nga: a kabu ne Tola, a kabu ne Puva, a kabu ne Iasup, a kabu ne Simron. Ra kabu ne Puvi ri vunu mule ria e Pun. ");
INSERT INTO bnp_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ra kabu ne Isikar nga ri vakabele e huriki a bakovi ri ala 64,300. ");
INSERT INTO bnp_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","E huriki a hamone Sebulun ra nga: a kabu ne Sered, a kabu ne Elon, a kabu ne Ialil. ");
INSERT INTO bnp_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ra kabu ne Sebulun nga, to vakabele e huriki a bakovi ri ala 60,500. ");
INSERT INTO bnp_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","E huriki a hamone Iosep i ramai a kabu ne ria ri bele ne Manase rua e Epraim ra nga: ");
INSERT INTO bnp_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","30","E huriki a hamone Manase ra nga: e Makir, e tune Manase e tamane Gilead. E huriki a hamone Gilead ra nga: a kabu ne Ieser, a kabu ne Helek, ");
INSERT INTO bnp_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","a kabu ne Asriel, a kabu ne Sekem, ");
INSERT INTO bnp_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","a kabu ne Semida, a kabu ne Heper. ");
INSERT INTO bnp_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","E Selopehad, e tune Heper bakovi, i uka e tuna ga bakovi. I tahoka kunana e tuna ngatavine. A rane ria ra nga: e Mala, e Noa, e Hoglah, e Milka, e Tirsa. ");
INSERT INTO bnp_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ra kabu ne Manase nga, ri vakabele e huriki a bakovi ri ala 52,700. ");
INSERT INTO bnp_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","E huriki a hamone Epraim ra nga: a kabu ne Sutela, a kabu ne Beker, a kabu ne Tahan. ");
INSERT INTO bnp_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","A kabu ne Eran ria a hamone Sutela. ");
INSERT INTO bnp_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ra kabu ne Epraim nga, ri vakabele e huriki a bakovi ri ala 32,500. A kabu ne Manase a kabu ne Epraim, ru vuhuna ne Iosep. ");
INSERT INTO bnp_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","E huriki a hamone Bensamin ra nga: a kabu ne Bela, a kabu ne Asbel, a kabu ne Ahiram, ");
INSERT INTO bnp_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","a kabu ne Sepupam, a kabu ne Hupam. ");
INSERT INTO bnp_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","E Ard, e Naman, rua e tune Bela. ");
INSERT INTO bnp_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ra kabu ne Bensamin nga, ri vakabele e huriki a bakovi ri ala 45,600. ");
INSERT INTO bnp_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","E huriki a hamone Dan ri tahoka a kabu i taku kunana, ra kabu ne Suam. ");
INSERT INTO bnp_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ra kabu iea i vakabele e huriki a bakovi ri ala 64,400. ");
INSERT INTO bnp_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","E huriki a hamone Aser ra nga: a kabu ne Imna, a kabu ne Isvi, a kabu ne Beria. ");
INSERT INTO bnp_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","A hamone Beria ra nga: a kabu ne Heber, a kabu ne Malkiel. ");
INSERT INTO bnp_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","E Aser i tahoka e tuna ngatavine a rana e Sera. ");
INSERT INTO bnp_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ra kabu ne Aser nga, ri vakabele e huriki a bakovi ri ala 53,400. ");
INSERT INTO bnp_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","E huriki a hamone Naptali ra nga: a kabu ne Iasiel, a kabu ne Guni, ");
INSERT INTO bnp_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","a kabu ne Ieser, a kabu ne Silem. ");
INSERT INTO bnp_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ra kabu ne Naptali nga, ri vakabele e huriki a bakovi ri ala 45,400. ");
INSERT INTO bnp_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","E huriki a Israel a bakovi ni gi palupu lobo, ri ala 601,730. ");
INSERT INTO bnp_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Muri e BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“O veru a malala na kabu takutaku ne Israel. ");
INSERT INTO bnp_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","56","Mu rehi na rihiva na satu mu veru a tabekena malala. O habi a malala dagi vona na kabu i tahoka a tara i kupo, o habi a malala kiroko vona na kabu a tara vona i uka ma i kupo hateka, ge ramai a vuhuna kabu takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","E huriki a hamone Levi ra nga: a kabu ne Gerson, a kabu ne Kohat, a kabu ne Merari, ");
INSERT INTO bnp_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","turana a kabu ne Libni, a kabu ne Hebron, a kabu ne Mali, a kabu ne Musi, a kabu ne Kora. E Kohat e tamane Amram. ");
INSERT INTO bnp_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","E Amram i parangi e Iokebet, a ngatavine na kabu ne Levi, ni poda na tahuna ri tababana ni made o Egipto. E Iokebet i poda e Aron e Moses, e kurabane rua e Miriam. ");
INSERT INTO bnp_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Muri e Aron i parangi, i vakabele e tuna bakovi ri ala va: e Nadap, e Abihu, e Eleasar, e Itamar. ");
INSERT INTO bnp_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Pali e Nadap e Abihu ru mate na tahuna ru bolea a kanono ru habia ne BAKOVI DAGI, na tahuna e BAKOVI DAGI i uka ma i taki rua ru gu ratea. ");
INSERT INTO bnp_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","E huriki a bakovi na kabu ne Levi ri tahoka a keva i taku i rike, ni gi palupu ri ala 23,000. E huriki na kabu ne Levi i uka ma ni gi turana a kabu ranga ne Israel, a vuhuna i uka ma ri bole a malala manga a maka kabu ranga. ");
INSERT INTO bnp_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","A maka kabu nga, e Moses, e Eleasar a prister, ru gi palupu tabukoi na maloku ne Moab, na gagana naru e Iordan tabukoi o Ieriko. ");
INSERT INTO bnp_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Pali e Moses, e Aron a prister, ru gi palupu hosi e huriki na tabeke i ngeki o Sinai. E huriki nga ri mate lobo pali. ");
INSERT INTO bnp_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","A vuhuna e BAKOVI DAGI i taki re huriki nga i ta maea, “Re huriki a bakovi nga, bara ri mate na tabeke i ngeki.” Lakea ri mate na tabeke i ngeki, pali e Keleb e tune Iepune bakovi, e Iosua e tune Nun bakovi, rua kunana i uka ma ru mate. ");
INSERT INTO bnp_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","E Mala, e Noa, e Hoglah, e Milka, e Tirsa, e huriki a ngatavine e tune Selopehad, ri deke. E Selopehad e tune e Heper, e Heper e tune Gilead, e Gilead e tune Makir, e Makir e tune Manase, e Manase e tune Iosep. ");
INSERT INTO bnp_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Na parava tara a ngatavine nga ri vano ri pesi na matana Kape na Vaponga, na matane Moses, e Eleasar a prister, ne huriki a matakari, ne huriki a bakovi a ngatavine, ri ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“E tamane mia i mate na tabeke i ngeki, pali i uka ma i turana e huriki a tara ne Kora ra ri longotaro a nitane BAKOVI DAGI. Ia kunana i rata a naro hale, i mate. Pali i uka e tuna bakovi. ");
INSERT INTO bnp_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","I muholi ngi i uka e tuna ga bakovi ge bole a murina, pali i navai a rane tamane mia ge velu tavula ne hita e huriki a Israel? I mavonga o habi mia ranga tabekena malala, na kabu ne tamane mia.” ");
INSERT INTO bnp_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Lakea e Moses i bole lakea ne BAKOVI DAGI a nitane ria. ");
INSERT INTO bnp_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Lakea e BAKOVI DAGI i takia, i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“A nitane huriki e tune Selopehad i kamumu. O habi ne ria ranga tabekena malala na kabu ne tamane ria, ri gi tahoka. ");
INSERT INTO bnp_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“O taki e huriki a Israel o ta maea, ‘A bakovi ge uka e tuna bakovi, i tahoka kunana e tuna ngatavine, muri i mate, e huriki e tuna ngatavine ri gi bole a maki vona. ");
INSERT INTO bnp_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ge uka e tuna ngatavine, e huriki e turana ri gi bole a maki vona. ");
INSERT INTO bnp_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ge uka e turana, e huriki e turane tamana ri gi bole a maki vona. ");
INSERT INTO bnp_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ge uka e turane tamana, e tune turane tamana ge bole a maki vona. E huriki a Israel lobo ri gi ramaia a vinara iea.’” ");
INSERT INTO bnp_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","E BAKOVI DAGI i takia e Moses i ta maea, “O sike na lolo e Abarim, o tuvaia a malala ta ga habia ne huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","O matai taroa muri bara o mate ke, i manga e turamu e Aron i mate. ");
INSERT INTO bnp_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","A vuhuna muru longotaro a nitagu na tabeke i ngeki ne Sin. Na tahuna e huriki a bakovi a ngatavine ri tapuhaki ne nau na naru e Meriba, o marikoi ni vakasiri a nitora dagi nau ne ria.” Ra lomu e Meriba i tabuli o Kades na tabeke i ngeki ne Sin. ");
INSERT INTO bnp_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Lakea e Moses i takia e BAKOVI DAGI i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“O Vure, ioe e BAKOVI DAGI, ioe kunana a vuhuna a nimahuri ne huriki lobo. A nana ioe go vulakia tara bakovi ge matakari e huriki, ");
INSERT INTO bnp_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ge tuhori ria ri gi made kamumu, ge muga ria na vabinga. Lakea e huriki a tara vomu i uka ma ri gi laho viliha lae, ri gi manga a maka sipsip ri uka a matakari ne ria.” ");
INSERT INTO bnp_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Lakea e BAKOVI DAGI i takia e Moses, “O vulakia e Iosua e tune Nun, a vuhuna a hanugu i tabuli vona, o ru langa a limamu vona. ");
INSERT INTO bnp_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","O takia e Iosua ge pesi na matane Eleasar a prister, na matane huriki a Israel lobo. O vakalongo ria vona e Iosua i kuloi ioe, o habia vona pali a leho vomu. ");
INSERT INTO bnp_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","O habi vona ranga nitora vomu, lakea e huriki a Israel ri gi longototoa. ");
INSERT INTO bnp_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Pali e Iosua ge lakea ne Eleasar a prister ge lohoka kamumu vona a ningaru nau. E Eleasar ge bolea a kedo kiroko e Urim, ge bole a lohokanga na ningaru nau. Muri ge vakalongo e Iosua turane huriki a bakovi a ngatavine na maki lobo ri gi rata.” ");
INSERT INTO bnp_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Lakea e Moses i rata a maki e BAKOVI DAGI i taki ia vona ge rata. I bole vilia e Iosua, i vakapesia tabukoi na matane Eleasar a prister, na matane huriki. ");
INSERT INTO bnp_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Lakea e Moses i ru langa a limana na gine Iosua i taki ria ne Iosua ge bole a murina. E Moses i rata lobo a maki e BAKOVI DAGI i ngaru ge rata. ");
INSERT INTO bnp_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“O vakuku e huriki a Israel o ta maea, ‘Mua o huriki a Israel, mu bole a maki ni kani, mu gutu na dede, ge a nihabi. Mu rata a nihabi ge manginoro, ga ngaru. A nihabi nga, mu rata na parava a taki mua vona mu gu rata.’ ");
INSERT INTO bnp_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Moses, o taki e huriki a Israel o ta maea, ‘Na parava vakaroro mu bole a tuna sipsip a toga gavutuvutu ge rua, ru tahoka a pida i taku, ge a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mu habia ne BAKOVI DAGI na hatelanga tara, na malunga tara. ");
INSERT INTO bnp_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Na hatelanga mu bole a kilo na plaoa ge taku, mu vuli turana a namona oliv a lita ge taku, mu habi turana a sipsip ge taku. ");
INSERT INTO bnp_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ra nihabi gutu-vuro iea mu ratea na parava vakaroro. Hosi ni vakatubu na lolo e Sinai ra nihabi iea. Ge a nihabi ni gutu na kanono. Na tahuna e BAKOVI DAGI i burongi a mangina, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Mu bole a lita na naru vagole ge taku, mu habi turana a sipsip iea, mu guru tala na tabeke ni taba. ");
INSERT INTO bnp_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Na malunga liu mu habia nau a sipsip tara turana a nihabi na vit, a nihabi na vain, i manga a hini mu rata na hatelanga. Ra nihabi ni gutu na kanono, e BAKOVI DAGI i ngaru a mangina. ");
INSERT INTO bnp_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘Na Parava Nimalo mu habi a sipsip gavutuvutu ge rua, a toga, ru gu tahoka a pida ge taku. Mu bole a kilo na plaoa ge rua, mu vuli turana a namona oliv, ge a nihabi na vit. Muri mu rata a nihabi na vit, a nihabi na vain turana a sipsip. ");
INSERT INTO bnp_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ra nihabi gutu-vuro mu rata na maka Parava Nimalo lobo, ge turana ra nihabi mu habi na parava vakaroro, ra nihabi gutu-vuro, a nihabi na vain. ");
INSERT INTO bnp_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘Na mugana parava na maka keva lobo mu rata a nihabi ne BAKOVI DAGI, ra nihabi gutu-vuro. Mu habi a bulmakau karaba a toga ge rua, a sipsip a toga ge taku, a tuna sipsip gavutuvutu a toga ge polorua, ri tahoka a pida i taku. ");
INSERT INTO bnp_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","A nihabi na vit turana a sipsip a bulmakau mu rata maea. Mu bole a kilo ge tolu na plaoa, mu vuli turana a namona oliv, mu habi turana a bulmakau ge taku. Mu bole a kilo na plaoa ge taku, mu vuli turana a namona oliv, mu habi turana a sipsip a toga. ");
INSERT INTO bnp_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Mu bole a kilo na plaoa ge taku mu vuli turana a namona oliv, mu habi turana a tuna sipsip ge taku. Ra nihabi gutu-vuro, e BAKOVI DAGI i ngaru a mangina. ");
INSERT INTO bnp_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Mu bole a lita ge rua na vain, mu habi turana a bulmakau a toga. A lita na vain ge taku a kalavana mu habi turana a sipsip a toga. A lita na vain ge taku mu habi turana a tuna sipsip. Mu rata maea kunana na maka nihabi gutu-vuro, na mugana parava na keva takutaku na pida lobo. ");
INSERT INTO bnp_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Mu habi turana a nihabi gutu-vuro, a nihabi na vain, a meme a toga ge a nihabi na naro hale. ");
INSERT INTO bnp_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘Na ravulu a polovana parava (14th) na mugana keva a Habu na Nipagepolo ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Na parava i ravulu a polona i lima (15) a nivakatubuna a habu. Na parava i polorua mu kani a bret i uka is. ");
INSERT INTO bnp_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Na mugana parava na parava dagi nga e huriki lobo ri gi vapopo ri gi vasileki. Naha ni rata a leho mu rata na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mu rata a nihabi ne BAKOVI DAGI. Mu habi a bulmakau a toga karaba ge rua, a sipsip a toga ge taku, a tuna sipsip gavutuvutu, a toga ge polorua, ri tahoka a pida ne ria i taku. Mu gutu ria na kanono, ge a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Mu habi a kilo ge tolu na plaoa, mu vuli turana a namona oliv, mu habi turana a bulmakau a toga takutaku. Mu habi a kilo na plaoa ge rua, mu vuli turana a namona oliv, mu habi turana a sipsip a toga takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","A kilo i taku na plaoa mu vuli turana a namona oliv, mu habi turana a tuna sipsip takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Mu habia tara meme a toga, ge a nihabi na naro hale. Ra nihabi iea bara i kavitagu mua. ");
INSERT INTO bnp_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mu rata a nihabi nga turana a maka nihabi mu rata vakaroro na hatelanga. ");
INSERT INTO bnp_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Na naro iea kunana, mu kisi a kinani na nihabi na kanono na parava takutaku, na parava ge polorua. Na tahuna e BAKOVI DAGI i burongi a mangina, bara i vivi. Ra nihabi na kinani ni gi habi langa tabu na nihabi gutu-vuro, a nihabi na vain ra mu rata na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Na poloruana parava, mu vapopo mu vasileki. Naha ni rata a leho mu rata na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘Na parava dagi na Habu na Nimirio, mu bole a vit i moro muga mu habi ne BAKOVI DAGI. Mu vapopo ni kavurikea e BAKOVI DAGI, naha ni rata a leho mu rata na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mu bole a bulmakau karaba a toga ge rua, a sipsip a toga ge taku, a tuna sipsip a toga ge polorua, ri tahoka a pida i taku. Mu habi ge a nihabi gutu-vuro. Na tahuna e BAKOVI DAGI i burongi a mangina, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","A bulmakau takutaku a kinina a nihabi na vit, ra kilo na plaoa i tolu ni vuli turana a namona oliv. A sipsip a toga, a kinina a nihabi na vit, ra kilo i rua na plaoa, ni vuli turana a namona oliv. ");
INSERT INTO bnp_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Mu habi a kilo na plaoa ge taku, turana a sipsip ge taku. ");
INSERT INTO bnp_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Mu habi a meme a toga ge taku, ne vona ni kavitagu mua. ");
INSERT INTO bnp_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Na tahuna mu rata a maka nihabi nga, a maka sipsip a bulmakau mu habi ge gavutuvutu. A nihabi na vain, a nihabi gutu-vuro, a nihabi na vit ranga, mu rata, i manga a hini mu rata na parava vakaroro.’” ");
INSERT INTO bnp_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","E BAKOVI DAGI i takia e Moses, “Na mugana parava na poloruana keva, mu vapopo mu vasileki, naha ni rata a leho mu rata na parava vakaroro. Ra parava iea, a parava ni vaki a tavure. ");
INSERT INTO bnp_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Mu rata a nihabi gutu-vuro ge lakea ne BAKOVI DAGI. I ngaru hateka a mangina. Mu rata a nihabi na bulmakau karaba ge taku a toga, a sipsip a toga, a tuna sipsip gavutuvutu a toga ge polorua a pida ne ria ge taku. ");
INSERT INTO bnp_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Mu rata a nihabi na vit, ge a kinina maka nihabi nga. Mu bole a maka plaoa kamumu ni rata na vit, mu vuli turana a namona oliv, bara mu ratea vona a nihabi iea. Mu habi a kilo na plaoa ge tolu, ge a kinina bulmakau a toga, a kilo na plaoa ge rua, ge a kinina sipsip a toga, ");
INSERT INTO bnp_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","a kilo i taku, ge a kinina sipsip takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Mu bole tabua a meme ge taku, ge a nihabi na naro hale, ge kavitagu mua. ");
INSERT INTO bnp_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Mu rata a maka nihabi nga, mu rata tabu a nihabi gutu-vuro, a nihabi na vit ra mu rata na mugana parava na keva lobo. Mu habi tabu a nihabi ni rata na parava takutaku, ra nihabi gutu-vuro, a nihabi na vit, a nihabi na vain. Na tahuna e BAKOVI DAGI i burongi a mangina a nihabi na kanono nga, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Na ravuluna parava (10th) na polo­ruana keva (7th), mu vapopo mu vasileki. Mu peremu ni kani, naha ni rata a petoanga, naha ni rata a leho vona a parava iea. ");
INSERT INTO bnp_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mu bolea tara bulmakau karaba a toga, a sipsip a toga, a tuna sipsip gavutuvutu a toga ge polorua, a pida ne ria ge taku. Mu habi ne BAKOVI DAGI ge a nihabi gutu-vuro. Na tahuna e BAKOVI DAGI i burongi a mangina, bara i vivi. ");
INSERT INTO bnp_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Mu gutu a nihabi na vit turana a nihabi gutu-vuro. Mu bole a plaoa kamumu na vit, mu vuli turana a namona oliv, mu habi. Mu habi a kilo na plaoa ge tolu, ge a kinina bulmakau a toga, a kilo na plaoa ge rua, ge a kinina sipsip a toga, ");
INSERT INTO bnp_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","mu habi a kilo na plaoa ge taku, ge a kinina tuna sipsip a toga takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Mu habi tabu a meme a toga, ge a nihabi na naro hale. Mu habi tabu a nihabi ni kavitagu mua, a nihabi gutu-vuro mu rata vakaroro turana a nihabi na vit, a nihabi na vain. ");
INSERT INTO bnp_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Ne ravulu a pololimana parava (15th) na poloruana keva, mu vapopo mu vasileki. Naha ni rata a leho mu rata na parava vakaroro. Mu rata a habu ne BAKOVI DAGI na parava ge polorua. ");
INSERT INTO bnp_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Mu rata a nihabi ni gutu na kanono ne BAKOVI DAGI. I ngaru a mangina a maka nihabi nga. Mu habi a bulmakau karaba a toga ge ravulu a polona i tolu (13), a sipsip a toga ge rua, a tuna sipsip a toga ge ravulu a polona i va (14), ri tahoka a pida i taku. Ria lobo ri gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Mu bole a plaoa mu vuli turana a namona oliv, ne vona ni rata a nihabi na vit. Mu bole a kilo na plaoa ge tolu ge a kinina bulmakau takutaku, a kilo na plaoa ge rua ge a kinina sipsip a toga ge takutaku, ");
INSERT INTO bnp_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","a kilo na plaoa ge taku ge a kinina sipsip takutaku. ");
INSERT INTO bnp_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Mu habia tara meme a toga ge a nihabi na naro hale. Mu habi tabu a nihabi na parava takutaku, ra nihabi gutu-vuro, a nihabi na vit, a nihabi na vain. ");
INSERT INTO bnp_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Na ruana parava, mu habi a bulmakau karaba a toga ge ravulu a polona i rua, a sipsip a toga ge rua, a tuna sipsip a toga ge ravulu a polona i va ri tahoka a pida ne ria i taku. Ria lobo ri gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","A nihabi na bulmakau a toga, a sipsip a toga, a tuna sipsip, a kinina ne ria ge a nihabi na vit, a nihabi na vain, ge ramai a ngava a taki mua vona. ");
INSERT INTO bnp_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Mu habi tabu a meme a toga, ge a nihabi na naro hale. A nihabi gutu-vuro tara, ra mu habi na parava vakaroro turana a nihabi na vit, a nihabi na vain, mu habi. ");
INSERT INTO bnp_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Na toluna parava, mu habi a bul­makau ge ravulu a polona i taku, a toga, a sipsip a toga ge rua. A tuna sipsip a toga ge ravulu a polona i va, ri tahoka a pida ne ria i taku. Ria lobo ri gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","A maka nihabi na bulmakau a toga, a sipsip a toga, a tuna sipsip, a kinine ria ge a nihabi na vit, a nihabi na vain, ge ramai a ngava a taki mua vona. ");
INSERT INTO bnp_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Mu habi tabu a meme a toga, ge a nihabi na naro hale. A nihabi gutu-vuro tara, ra mu habi na parava vakaroro turana a nihabi na vit, a nihabi na vain, mu habi. ");
INSERT INTO bnp_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Na vana parava, mu habi a bulmakau a toga ge ravulu, a sipsip a toga ge rua, a tuna sipsip a toga ge polorua, a pida ne ria ge taku. Ria lobo ri gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","A nihabi na bulmakau a toga, a sipsip a toga, a tuna sipsip, a kinine ria ge a nihabi na vit, a nihabi na vain, ge ramai a ngava a taki mua vona. ");
INSERT INTO bnp_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Mu habi tabu a meme a toga, ge a nihabi na naro hale. A nihabi gutu-vuro, tara, ra mu habi na parava vakaroro turana a nihabi na vit, a nihabi na vain, mu habi. ");
INSERT INTO bnp_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Na limana parava, mu habi a bul­makau a toga ge polova, a sipsip a toga ge rua, a tuna sipsip a toga ge ravulu a polona i va, ri tahoka a pida ne ria i taku. Ria lobo ri gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","A maka nihabi na bulmakau a toga, a sipsip a toga, a tuna sipsip, a kinine ria ge a nihabi na vit, a nihabi na vain, ge ramai a ngava a taki mua vona. ");
INSERT INTO bnp_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Mu habi tabu a meme a toga, ge a nihabi na naro hale. A nihabi gutu-vuro tara, ra mu habi na parava vakaroro turana a nihabi na vit, a nihabi na vain, mu habi. ");
INSERT INTO bnp_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Na polotarana parava, mu habi a bul­makau a toga ge polotolu, a sipsip a toga ge rua, a tuna sipsip a toga ge ravulu a polona i va, ri tahoka a pida i taku. Ria lobo ri gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","A nihabi na bulmakau a toga, a sipsip a toga, a tuna sipsip, a kinine ria ge a nihabi na vit, a nihabi na vain, ge ramai a ngava a taki mua vona. ");
INSERT INTO bnp_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Mu habi tabu a meme a toga, ge a nihabi na naro hale. A nihabi gutu-vuro tara, ra mu habi na parava vaka­roro turana a nihabi na vit, a nihabi na vain, mu habi. ");
INSERT INTO bnp_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Na poloruana parava, mu habi a bulmakau a toga ge polorua, a sipsip a toga ge rua, a tuna sipsip a toga ge ravulu a polona i va, ri tahoka a pida ne ria i taku. Ria lobo ri gavutuvutu. ");
INSERT INTO bnp_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","A maka nihabi na bulmakau a toga, a sipsip a toga, a tuna sipsip, a kinine ria ge a nihabi na vit, a nihabi na vain, ge ramai a hini a taki mua vona. ");
INSERT INTO bnp_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Mu habi tabu a meme a toga, ge a nihabi na naro hale. A nihabi gutu-vuro tara, ra mu habi na parava vakaroro turana a nihabi na vit, a nihabi na vain, mu habi. ");
INSERT INTO bnp_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Na polotoluna parava, mua lobo mu vapopo ni vasileki, naha ni rata a leho mu rata na parava vakaroro. ");
INSERT INTO bnp_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mu rata a nihabi na kanono ne BAKOVI DAGI. I ngaru a mangina. Ra nihabi iea, mu bolea a bulmakau a toga ge taku, a sipsip a toga ge taku, a tuna sipsip a toga ge polorua ri gi tahoka a pida i taku. Ria lobo ri gavutuvutu. Mu bole mu rata a nihabi gutu-vuro. ");
INSERT INTO bnp_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","A maka nihabi na bulmakau a toga, a sipsip a toga, a tuna sipsip, a kinine ria ge a nihabi na vit, a nihabi na vain, ge ramai a ngava a taki mua vona. ");
INSERT INTO bnp_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Mu habi tabu a meme a toga, ge a nihabi na naro hale. A nihabi ni gutuvuro tara, ra mu habi na parava vakaroro turana a nihabi na vit, a nihabi na vain, mu habi. ");
INSERT INTO bnp_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“A nihabi nga, mu kisi turana a maki mu ta muholi mu gu habia ne BAKOVI DAGI, a maki mu ngaru ni habi ne BAKOVI DAGI. Mu kisi, mu habi na habu takutaku ne mua, ra a nihabi gutu-vuro, a nihabi na vit, a nihabi na vain, a nihabi na nivalemu.” ");
INSERT INTO bnp_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","E Moses i taki e huriki a bakovi a ngatavine o Israel na maka maki e BAKOVI DAGI i vakuku ia vona. ");
INSERT INTO bnp_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","E Moses i taki e huriki a nupesi na kabu takutaku ne Israel, i ta maea, “E BAKOVI DAGI i vakuku hita: ");
INSERT INTO bnp_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Na tahuna a bakovi tara i rata a nita muholi ge habia ne BAKOVI DAGI tara maki, o i ta muholi vona tara maki i uka ma ge ratea, ge ramai a nita muholi i ratea. ");
INSERT INTO bnp_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Na tahuna a sirula i tabana na ruma e tamana, lakea i ta muholi ne BAKOVI DAGI ge ratea tara maki, o i ta muholi ge pilea tara maki, ");
INSERT INTO bnp_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","pali e tamana i longo vona a ngava iea, lakea i uka ma i ta, a nita muholi na sirula iea bara i tabana. ");
INSERT INTO bnp_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Pali e tamana ge longo vona a nita muholi ne tuna a sirula, lakea i ta pupukari vona, a nita muholi lobo vona i uka ma ge tabuli. E BAKOVI DAGI bara i puga vuroki a nita muholi vona a vuhuna e tamana i ta pupukari vona. ");
INSERT INTO bnp_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Na tahuna a sirula i ta muholi vona tara maki ge ratea, o i kaba tavula na maki tara, muri i parangi, ");
INSERT INTO bnp_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","lakea e girihina i longo vona a nita muholi vona, pali na parava iea i uka ma i ta, a nita muholi na ngatavine iea bara i tabana. ");
INSERT INTO bnp_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Pali e girihina ge longo vona a nita muholi i rata hosi a ngatavine iea, lakea na parava iea i ta pupukari ia vona, ngane a nita muholi, o a nikaba tavula vona bara i uka nitora. E BAKOVI DAGI bara i puga vuroki a nita muholi vona a ngatavine iea. ");
INSERT INTO bnp_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Na tahuna a havuri, o a ngatavine i pilea e girihina, i kaba ge ratea tara maki o i ta kari mule vona nahea ge ratea tara maki, ge ramai kunana a nita muholi vona. ");
INSERT INTO bnp_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Na tahuna a ngatavine i parangi i kaba ni ratea tara maki, ");
INSERT INTO bnp_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","lakea e girihina i longoa a nita muholi vona, i uka ma i ta pupukari vona, a nita muholi lobo vona ge tabuli. ");
INSERT INTO bnp_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Pali na tahuna e girihina i longo vona a nita muholi vona, lakea na parava iea i ta pupukari vona, a nita muholi lobo na ngatavine i uka ma ge tabuli, e BAKOVI DAGI i puga vuroki a nita muholi vona, a vuhuna e girihina i ta pupukari vona. ");
INSERT INTO bnp_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","E girihina ngatavine iea i kara ge longo maia a nita muholi na ngatavine o ge ta pupukari vona a nikaba na ngatavine. ");
INSERT INTO bnp_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Pali na tahuna a bakovi i uka ma i rata malaviriria tara ngava ge lakea na ngatavine na tahuna i longoa a nita muholi vona, a ngatavine ge ratea a maki i ta muholi vona ge ratea. E girihina ngatavine i vakatorea, a vuhuna i uka ma i ta pupukari na parava i longo vona a nita muholi na ngatavine. ");
INSERT INTO bnp_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Pali a bakovi ge ta pupukari vona muri na parava ranga, ia kunana i tahoka a ngava na naro hale na hini i putu puru a nita muholi. ");
INSERT INTO bnp_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ra vinara nga e BAKOVI DAGI i habi ne Moses, i taki virihi a bakovi rua e girihina, a bakovi rua e tuna ngatavine, ra i tababana ni made na ruma vona. ");
INSERT INTO bnp_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","E BAKOVI DAGI i takia e Moses, ");
INSERT INTO bnp_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“O koli a naro e huriki a Midian ri rata virihi e huriki a Israel vona. Muri bara o mate.” ");
INSERT INTO bnp_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Lakea e Moses i taki e huriki a Israel i ta maea, “Mu bole a maka maki na vabinga, mu vano mu vaubi turane huriki a Midian. E BAKOVI DAGI i ngaru mu gu koli a narone ria. ");
INSERT INTO bnp_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mu rudu e huriki a bakovi ala 1,000 na kabu takutaku ne Israel, ri gi vaubi.” ");
INSERT INTO bnp_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Lakea a bakovi ala 12,000, ra 1,000 na kabu takutaku ne Israel, ni habi ne ria a maki na vabinga. ");
INSERT INTO bnp_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Lakea e Moses i rudu ria ri gi vaubi, ra bakovi ala 1,000 na kabu takutaku. E Pinias e tune Eleasar a prister, i turane ria. I bole a maka maki ni taba na kape, a maka tavure ni gale ria ri gi lakea na vabinga, ni gale hamule ria na vabinga. ");
INSERT INTO bnp_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Lakea ri vano ri vaubi ne huriki a Midian i manga a ngava e BAKOVI DAGI i vakuku e Moses vona, ri rabalaki e huriki a bakovi lobo. ");
INSERT INTO bnp_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ri rabalaki turana e huriki ranga a hariki o Midian ri ala lima: e Evi, e Rekem, e Sur, e Hur, e Reba. E Balam, e tune Beor, ia tara ni padimate na bainat. ");
INSERT INTO bnp_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","E huriki a Israel ri turari e huriki a ngatavine, e huriki a koma, ri bole polo a maka bulmakau, a maka sipsip, a maka maki kamumu ne huriki a Midian. ");
INSERT INTO bnp_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Muri ri rungani a maka mada, a tanga ne huriki a Midian. ");
INSERT INTO bnp_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ri turari e huriki a ngatavine, a koma, ri bole a maka bulmakau a sipsip, a maka mahala, ");
INSERT INTO bnp_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ri bole valai ne Moses ne Eleasar a prister, ne huriki a Israel ri made na bilane Moab, na gagana naru e Iordan tabukoi o Ieriko. ");
INSERT INTO bnp_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","E Moses e Eleasar a prister, turane huriki a matakari ne Israel ri vano ri tagui e huriki a nugumaheto polovavo na mada. ");
INSERT INTO bnp_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Muri e Moses i tahate e huriki a ubu ri matakari a nugumaheto ri ala 1,000, e huriki a ubu ri matakari a nugumaheto ri ala 100, ra ri hamule pali na vabinga. ");
INSERT INTO bnp_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Lakea i nana ria i ta maea, “I navai i uka ma mu rabalaki e huriki a ngatavine? ");
INSERT INTO bnp_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ria kunana ri longo mai a nita ne Balam ri rata e huriki a bakovi a ngatavine ne hita ri ngalahere ne BAKOVI DAGI, na tahuna ri made o Peor. Lakea a gilanga dagi i bele ne huriki a tara ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ngane mu rabalaki e huriki a koma bakovi, e huriki a ngatavine ri mahita turana a bakovi pali. ");
INSERT INTO bnp_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Pali naha ni rabalaki e huriki a koma ngatavine, a sirula. Mu bole ria ge ne mua. ");
INSERT INTO bnp_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Mua e huriki mu rabalaki a viri, o mu padoi a podana viri, mu made polovavo na mada na parava ge polorua. Na toluna parava, na poloruana parava, mua turane huriki a ngatavine mu bole na vabinga, mu rata a naro ni matapado. ");
INSERT INTO bnp_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Mu vakamatapado a varakia ne mua, a maki lobo ni rata na kulina bulmakau, a vuna meme, a kai.” ");
INSERT INTO bnp_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Lakea e Eleasar a prister i taki e huriki a nugumaheto ri hamule na vabinga i ta maea, “Ngane ga taki mua vona a vinara e BAKOVI DAGI i habi ne Moses. ");
INSERT INTO bnp_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","A maka maki i uka ma ge nono, manga a gol, a silva, a aen, a kapa, a bras, mu parai na kanono, ri gi matapado. Pali a maka maki bara i nono, mu loi pasi na naru ni vakamatapado, ri gi matapado. ");
INSERT INTO bnp_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Na poloruana parava, mu loi pasi a maka varakia ne mua, bara mu matapado na matana Vure, mu dili pololilo na mada.” ");
INSERT INTO bnp_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","E BAKOVI DAGI i takia e Moses i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Mua e Eleasar a prister, e huriki a matakari na maka kabu, mu gi palupu e huriki a vorakato, a maka sipsip a bulmakau, a maki lobo e huriki a nugumaheto ri bole na vabinga. ");
INSERT INTO bnp_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Mu ru na tabeke ge rua. Mu habi ne huriki ri lakea na vabinga a tabeke tara, a tabeke tara mu habi ne huriki ri made na mada. ");
INSERT INTO bnp_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","O bole a takis nau vona e huriki a vorakato, a bulmakau, a donki, a sipsip, a meme ra o habi ne huriki a nugumaheto. Ne huriki a vorakato ala 500 ri bole, o bole talea ge taku. Na maka bulmakau, a donki, a sipsip, a meme i 500 ri bole, o bole talea ge taku. ");
INSERT INTO bnp_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","O bole o habi ne Eleasar a prister ge manga a takis ri habi nau. ");
INSERT INTO bnp_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","E huriki a vorakato, a bulmakau, a donki, a sipsip, a meme, a kanirau ranga, ra o habi ne huriki ri made na mada, ngi ranga o bole a takis ne ria. Ne huriki a vorakato ala ravulu lima o bolea ge taku. Na maka bulmakau, a donki, a sipsip, a meme i ravulu lima o bole talea ge taku. O bole, o habi ne huriki a kabu ne Levi, ra ri matakari a kape ne BAKOVI DAGI.” ");
INSERT INTO bnp_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Lakea e Moses e Eleasar ru rata a maki e BAKOVI DAGI i vakuku rua vona ru gu rata. ");
INSERT INTO bnp_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","E huriki a nugumaheto ri bole na vabinga a maki nga: a maka sipsip i 675,000, ");
INSERT INTO bnp_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","a maka bulmakau i 72,000, ");
INSERT INTO bnp_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","a maka donki i 61,000, ");
INSERT INTO bnp_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","e huriki a sirula ri ala 32,000. ");
INSERT INTO bnp_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","A kalavana maki ni bole na vabinga i bole e huriki a nugumaheto i maea: A maka sipsip i 337,500, ");
INSERT INTO bnp_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ri habi ne BAKOVI DAGI mana a takis i 675. ");
INSERT INTO bnp_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ni Gi A maka bulmakau i 36,000, ri habi ne BAKOVI DAGI manga a takis i 72. ");
INSERT INTO bnp_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Ni Gi A maka donki i 30,500, ri habi ne BAKOVI DAGI manga a takis i 61. ");
INSERT INTO bnp_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Ni Gi E huriki a vorakato ri ala 16,000, ri habi ne BAKOVI DAGI manga a takis i ala 32. ");
INSERT INTO bnp_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Lakea i manga a hini e BAKOVI DAGI i vakuku e Moses vona, e Moses i habi ne Eleasar a prister a maki nga turana e huriki a vorakato, i manga a takis ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","A kalavana maki ni bole na vabinga, e Moses i habi ne huriki ri made na mada, ra nga: ");
INSERT INTO bnp_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","E huriki a bakovi a ngatavine ri bole a maka sipsip ri 337,500, ");
INSERT INTO bnp_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Ni Gi a maka bulmakau ri 36,000, ");
INSERT INTO bnp_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Ni Gi a maka donki ri 30,500, ");
INSERT INTO bnp_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Ni Gi e huriki a vorakato ri ala 16,000. ");
INSERT INTO bnp_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Na tabeke na maka maki ni bole na vabinga, ra ni habi ne huriki a Israel, e Moses i bole tala a takis. Ne huriki a vorakato ala ravulu lima, na maka kanirau i ravulu lima, e Moses i bole tala i taku, i manga a hini e BAKOVI DAGI i vakukua vona ge ratea. I habi ne huriki a Levi, ra ri matakari a kape ne BAKOVI DAGI. ");
INSERT INTO bnp_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Muri e huriki a ubu ri matakari a nugumaheto ala 1,000, e huriki a ubu ri matakari a nugumaheto ala 100 ri lakea ne Moses, ");
INSERT INTO bnp_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ri takia, “Bakovi dagi, mi gi palupu pali e huriki a nugumaheto mi matakari, i uka tara ne ria ge velu. ");
INSERT INTO bnp_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ngane mi gi habi vomu a maka bagetua na gol, mi paru tala na limane ria, na lohone ria, na talingane ria. Mi ngaru ni habi ne BAKOVI DAGI a maka mahala nga, ge a mapana ni kona mule mia ge kavitagu mia.” ");
INSERT INTO bnp_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Lakea e Moses e Eleasar a prister ru bole a gol a maka bagetua nga. ");
INSERT INTO bnp_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","A nimavana maka bagetua nga i 16,750 sekel. ");
INSERT INTO bnp_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Pali e huriki a nugumaheto takutaku, ri bole na vabinga ranga maki. ");
INSERT INTO bnp_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","E Moses e Eleasar a prister, ru bole ne huriki a ubu a maka gol, ru vano ru ru na Kape na Vaponga. Ru rata mavonga, e huriki a Israel ri gi luhoi mule e BAKOVI DAGI i matakari ria. ");
INSERT INTO bnp_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","A kabu ne Reuben ne Gad ri tahoka a maka bulmakau i kupo hateka. Ri matai a malala na tabeke ne Iaser, e Gilead i tahoka a maka varili kamumu ge kani a maka bulmakau. ");
INSERT INTO bnp_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Lakea ri lakea ne Moses e Eleasar a prister, ne huriki a nupesi ri ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“Ra tabekena malala iea e BAKOVI DAGI i tuhori hita vona, si bolea, i kamumu hateka. A tanga e Atarot, e Dibon, e Iaser, e Nimra, e Hesbon, e Eleale, e Sebam, e Nebo, e Beon, ri pesi vona. A malala i kamumu hateka na bulmakau a sipsip ri gi kani vona. Pali mia, e huriki a vora ne marua, mi tahoka a bulmakau a sipsip. ");
INSERT INTO bnp_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Mi ngaru mu gu habia ne mia a tabekena malala iea. Mi marikoi go rata mia mi gi tulu poloa a naru e Iordan, mi gi lakea na tabeke lake.” ");
INSERT INTO bnp_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Lakea e Moses i ta tora na kabu ne Reuben, na kabu ne Gad i ta maea, “I navai mu gu made koea mua, mu gu matataro e huriki a viri ne mua ri gi lakea na vabinga? ");
INSERT INTO bnp_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Mu ngaru ni vakahale a niluhoi ne huriki a Israel ranga? Mu marikoi ne ria ri gi tulupoloa a naru e Iordan ri gi lakea na robo e BAKOVI DAGI i habia ne ria? I navai mu rata mavonga? ");
INSERT INTO bnp_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Hosi e huriki e tamane mua ri rata mavonga, na tahuna mi made na tanga e Kades-Barnea, a rudu tala ria ri gi kasisia a robo e Kenan. ");
INSERT INTO bnp_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Ri vano ri harena na maloku ne Eskol ri masia a robo iea, pali na tahuna ri hamule ri rata e huriki a viri ne ria a Israel ri mangenge, i uka ma ri dili vona a robo iea e BAKOVI DAGI i habia ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Lakea na tahuna iea, e BAKOVI DAGI i madihi a hatena ne ria, i kaba i ta maea, ");
INSERT INTO bnp_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘E huriki a bakovi ri tahoka a pida i ravulu rua i rike, ra ri pe e Egipto ri valai, i uka ma ri luhoi tora iau na hatene ria. Muholi hateka, re huriki nga, i uka tara ne ria ge dili vona a malala a ta muholi vona ne Abraham, ne Isak, ne Iakop. ");
INSERT INTO bnp_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","A bakovi ala rua kunana ru gu vano, re Keleb e tune Iepune na kabu ne Kenas, e Iosua e tune Nun, a vuhuna ru luhoi tora iau na hatene rua, ru ramai iau e BAKOVI DAGI.’ ");
INSERT INTO bnp_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Lakea e BAKOVI DAGI i tahate e huriki a bakovi a ngatavine, i rata ria ri laho viliha lae na tabeke i ngeki na pida i ravulu va, i harena ne huriki ri rata a naro hale na matana ri mate lobo e huriki na hisi iea. ");
INSERT INTO bnp_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Ngane mu kuloi e huriki e tamane mua, mu manga a tara ni rata a naro hale, ge madihi hateka a hatene BAKOVI DAGI ne hita e huriki a Israel. ");
INSERT INTO bnp_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Mua o huriki a kabu ne Reuben, e Gad, bara mu lobo ni ramai e BAKOVI DAGI, bara i ngalahere ne hita a Israel, bara i pe mule tabu hita na tabeke i ngeki, lakea mua kunana bara mua a vuhuna a vuranga si bolea.” ");
INSERT INTO bnp_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Muri ri lakea ne Moses, ri takia, “Mi gi tura halui taro koea a nure na maka bulmakau a sipsip ne mia. Mi gi rata taro a maka tanga ne girihine mia, e tune mia. ");
INSERT INTO bnp_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","I mavonga, e girihine mia, e tune mia ri gi made kamumu na tanga ni tura halui, i uka ma ge ratapile ria e huriki a taho tanga. Muri mi gi bole a maki na vabinga, mi gi muga ne huriki a Israel na vabinga, mi gi taparaki ria na maka tanga ne ria. ");
INSERT INTO bnp_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","E huriki a kabu takutaku ne hita e huriki a Israel ri gi bole taro a tabekena malala ne ria, muri mi gi hamule na tanga ne mia. ");
INSERT INTO bnp_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Mia i uka ma mi gi bole ranga malala na tabekene Iordan tara, a vuhuna mi bole pali a tabekena malala koea na nirikena haro ne Iordan.” ");
INSERT INTO bnp_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Lakea e Moses i koli ria i ta maea, “Mua bara mu ta muholi, bara mu kisi puru na vabinga e huriki