﻿USE sofia;
DROP TABLE IF EXISTS sofia.bno_vpl;
CREATE TABLE bno_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bno_vpl WRITE;
INSERT INTO bno_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Sa kauna-unahan, gingtuga it Dios kag langit ag duta. ");
INSERT INTO bno_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","It kato, kag kalibutan ay waya it korte ag waya't suyor. Kag marayom nak katubian ay libon it karuymanan ag sa ibabaw it tubi, kag Ispirito it Dios ay raha nak nagbabantay. ");
INSERT INTO bno_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ag nagsiling kag Dios, “Magkainggwa't hadag!” ag nagkainggwa matuor it hadag. ");
INSERT INTO bno_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nakita it Dios nak maado kag hadag, ag Ida ingbuyag kag hadag ag ruyom. ");
INSERT INTO bno_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Gingtawag it Dios kag hadag nak “adlaw” ag kag ruyom ay “gab-i.” Naglipas kag gab-i ag nag-abot kag aga. Imaw kato kag unang adlaw. ");
INSERT INTO bno_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Ag nagsiling kag Dios, “Magkainggwa it kalawakan sa tunga it katubian agor mabuyag kag tubi sa ibabaw ag kag tubi sa ubos!” Nagbuyag matuor kali, ag nagkainggwa't kalawakan sa tunga it katubian. ");
INSERT INTO bno_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ag kaling kalawakan ay gingtawag it Dios nak “langit.” Naglipas kag gab-i ag nag-abot kag aga. Imaw kato kag pangruhang adlaw. ");
INSERT INTO bno_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ag nagsiling kag Dios, “Magtipon kag tubi sa ubos it langit sa usang lugar ag magyuaw kag uga nak lugar!” ag natuman matuor. ");
INSERT INTO bno_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Gingtawag it Dios kaling uga nak lugar nak “kadutaan,” ag kag tubi nak nagtipon ay “karagatan.” Ag nakita it Dios nak kali ay maado. ");
INSERT INTO bno_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Masunor, nagsiling kag Dios, “Magtubo sa duta kag mga hilamunon, mga tanom nak nagbubunga it busoy, ag mga kahoy ra nak nagpapamunga it di busoy, kumporme sa inro iba't-ibang klase!” ag natuman matuor. Kinang tanang klase it tanom ay nagtinubo matuor sa duta. Ag nakita it Dios nak kali ay maado. ");
INSERT INTO bno_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Naglipas kag gab-i ag nag-abot kag aga. Imaw kato kag pangtatlong adlaw. ");
INSERT INTO bno_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ag nagsiling kag Dios, “Magkainggwa it mga iwag sa kalangitan pramas mabuyag kag adlaw sa gab-i, agor parayan sa inra maaayaman kag pag-abot it usang adlaw, usang tuig, ag usang importanting panahon. ");
INSERT INTO bno_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Imaw ra kali kag mata-o it hadag sa kalibutan!” ag natuman matuor. ");
INSERT INTO bno_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nagkainggwa it ruhang maragko nak mga iwag. Kag adlaw ay imaw it nagrurumaya sa aga hastang maghapon, ag kag buyan ay imaw ra it nagrurumaya sa gab-i. Nagkainggwa ra it mga bituon. ");
INSERT INTO bno_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Gingbutang it Dios kag mga iwag sa langit agor mataw-an it hadag kag kalibutan, ");
INSERT INTO bno_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","agor magrumaya sa adlaw ag sa gab-i ag agor mabuyag kag hadag sa ruyom. Ag nakita it Dios nak kali ay maado. ");
INSERT INTO bno_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Naglipas kag gab-i ag nag-abot kag aga. Imaw kato kag pang-ap-at nak adlaw. ");
INSERT INTO bno_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ag nagsiling kag Dios, “Magkainggwa sa tubi it maramong mga di kabuhi nak nagrarangoy-rangoy nak nagpupunsok-punsok. Ag kag ibabaw ay magkainggwa it mga pispis nak nagyiyinupar!” ");
INSERT INTO bno_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ngani, gingtuga it Dios sa tubi kag mga balyena, mga isra, ag iba pang mga nagrarangoy-rangoy nak nagpupunsok-punsok, kumporme sa inra iba't-ibang klase. Ag sa ibabaw ay nagkainggwa it tanang mga pispis, kumporme sa inra iba't-ibang klase. Ag nakita it Dios nak kali ay maado. ");
INSERT INTO bno_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Gingpakamaado sinra it Dios sa pagsiling, “Magbuar ag magramo kamong tanan raha sa tubi ag pun-a kag ragat, ag magramo ra kamong mga pispis raha sa ibabaw!” ");
INSERT INTO bno_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Naglipas kag gab-i ag nag-abot kag aga. Imaw kato kag panglimang adlaw. ");
INSERT INTO bno_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ag nagsiling kag Dios, “Magkainggwa it mga di kabuhi sa duta, mga hadop nak maanar, ag mga hadop nak maila nak nagpapanaw ag nagkakamang, kumporme sa inra iba't-ibang klase!” ag natuman matuor. ");
INSERT INTO bno_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nagkainggwa it mga hadop sa duta, mga hadop nak maanar, ag mga hadop nak maila nak nagpapanaw ag nagkakamang, kumporme sa inra iba't-ibang klase. Ag nakita it Dios nak kali ay maado. ");
INSERT INTO bno_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ag nagsiling kag Dios, “Mahuman Kita it tawo nak naambit sa Ato nak pay tuyar sa Ato. Ag sinra kag magahom sa mga isra, mga pispis, mga hadop nak maanar, ag mga hadop nak maila nak nagpapanaw ag nagkakamang.” ");
INSERT INTO bno_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ag nagtuga ngani kag Dios it tawo nak naambit sa Ida nak pay tuyar sa Ida. Gingtuga Nida kag tawo, kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ag ingpakamaado sinra it Dios, ag nagsiling Sida, “Mag-anak ag magramo kamo agor mapupuno ninro kag kalibutan. Kamo it marumaya dili, pati tanang isra, tanang pispis ag tanang iba't-ibang mga hadop!” ");
INSERT INTO bno_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nagsiling pa kag Dios, “Ingtaw-an kamo Nako it pagkaon, tanang mga tanom nak nagbubusoy ag tanang bunga it kahoy. ");
INSERT INTO bno_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ag sa tanang mga hadop ag sa tanang mga pispis ay ingtaw-an ra Nako sinra it hilamunon ag rahon it ibang mga tanom agor imaw ninra it pagkaon,” ag natuman matuor. ");
INSERT INTO bno_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ag nakita it Dios nak kag tanang Ida inghuman ay abang ado. Naglipas kag gab-i ag nag-abot kag aga. Imaw kato kag pang-an-om nak adlaw. ");
INSERT INTO bno_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tuyar kali kag pagtuga it Dios sa langit ag sa duta ag tanang rahina, ag kaling tanan ay nataposey. ");
INSERT INTO bno_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Sa suyor it an-om nak adlaw natapos it Dios kag tanang Ida ingtuga ag sa pangpitong adlaw, nagtungon Sida sa pagtuga. ");
INSERT INTO bno_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Gingpakamaado it Dios kag pangpitong adlaw ag Ida inghuman kali nak sagrado, dahil sa adlaw nak kali nagtungon Sida sa pagtuga ag nagpahuway. ");
INSERT INTO bno_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Imaw kali kung pauno ingtuga it Dios kag langit ag duta. It katong ingtuga it GINOONG Dios kag langit ag duta ");
INSERT INTO bno_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","ay waya pang gador it mga paninanom ag mga uyas nak nagtutubo ag nagpapamunga sa duta, dahil it kato waya pa Nida gipapauyana raha. Pero inggwa't mga tuburan nak waya gitutungon it pag-ilig nak imaw kag nagbubunyag sa duta. ");
INSERT INTO bno_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ngasing, imaw kali kag parayan it GINOONG Dios kung pauno gingpurma kag tawo halin sa yunang. Ag Ida inghingaban sa ilong it hingab nak nagtata-o it kabuhi, ag kag tawo ay nagkainggwa it kabuhi. ");
INSERT INTO bno_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Katong tawo nak inghuman it GINOONG Dios ay Ida ingbutang sa usang tanuman nak abang ganda nak Ida ing-aman para sa ida. Kinang tanuman ay ruto sa lugar nak ingtatawag nak Eden nak hampig sa subatan. ");
INSERT INTO bno_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Gingpatubo Nida kag tanang mga iba't-ibang puno nak maganda gimuyatan ag tanang mga iba't-ibang puno nak nagpapamunga pramas kaunon. Sa tunga it kaling tanuman ay inggwa't ruhang puno. Kag usa ay nagtata-o it kabuhi ag kag usa ay nagtata-o it kaayaman tungor sa maado ag mayain. ");
INSERT INTO bno_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Inggwa ra sa Eden it usang suba nak nag-iilig ag nagbubunyag sa tanuman. Sa liwas it Eden kali ay nagsanga sa ap-at nak suba. ");
INSERT INTO bno_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kag una ay ingtawag nak Pison ag kali ay naglilibot sa lugar it Havila ");
INSERT INTO bno_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","kung hariin inggwa't purong buyawan. Inggwa ra ruto it mabangyo nak tagok ag mga marmol. ");
INSERT INTO bno_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kag pangruha ay ingtawag nak Gihon ag kali ay naglilibot sa lugar it Cus. ");
INSERT INTO bno_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kag pangtatlo ay ingtawag nak Tigris ag kali ay nagrarayan sa bandang subatan it lugar nak Asirya. Ag kag pang-ap-at ay ingtawag nak Yuprates. ");
INSERT INTO bno_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ingraya ag ingbutang it GINOONG Dios kag tawo sa Eden agor magrugkay ag mag-alaga ruto. ");
INSERT INTO bno_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ingsugo Nida kag tawo sa pagsiling, “Libre ka nak magkaon it tanang bunga it kaling mga kahoy. ");
INSERT INTO bno_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Pero ayang gador gikauna kaling bunga it kaling kahoy nak nagtata-o it kaayaman tungor sa maado ag mayain. Sa oras nak imo kina kaunon, ikaw ay siguradong mamamatay.” ");
INSERT INTO bno_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Pagkatapos, inghuman it GINOONG Dios kag kayake, nagsiling Sida, “Buko maado nak magpangabuhi kag kayake nak ausa. Mahuman Ako it usang kaibhanan nak magiging katuwang nida.” ");
INSERT INTO bno_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kada ingraya Nida ruto sa kayake nak Ida ingpurma rutong duta katong tanang klasi it hadop ag pispis, agor ida apangayanan. Ag kung ni-o kag ida ingtawag, imaw kag inra ngayan. ");
INSERT INTO bno_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ingpangayanan it kayake kaling tanang iba't-ibang mga hadop ag mga pispis rutong duta. Pero waya gihapon sida it nakita nak ida magiging kaibahan ag katuwang. ");
INSERT INTO bno_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kada, gingpakatuyog it pamuok-muok it GINOONG Dios kaling kayake ag tong sida'y muokey ay Ida ingbaoy kag usang gusok nida bag-o ingpapila Nida kag unor ruto. ");
INSERT INTO bno_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kaling gusok ay inghuman Nida nak kabade ag ingraya ruto sa kayake. ");
INSERT INTO bno_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kada napasiling kag kayake, “Ay salamat! Sida ay suká it ako suká, unor it ako unor. Atawagon nako sida nak ‘kabade,’ dahil sida ay halin sa kayake.” ");
INSERT INTO bno_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ngani, ibilin it kayake kag ida tatay ag nanay agor sida ay mapisan sa ida asawa, ag sinrang ruha ay magiging usa. ");
INSERT INTO bno_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Sinra ay uba, pero waya sinra nahuhuda. ");
INSERT INTO bno_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Sa tanang mga hadop nak inghuman it GINOONG Dios, kag sawa it pinaka-tuso. Usang beses, nagpangutana kag sawa sa kabade, “Nagsiling baga kag Dios sa inro nak indi kamo magkaon it mga bunga it kahoy dili sa tanuman?” ");
INSERT INTO bno_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nagsabat kag kabade, “Waya ay! Puydi kami magkaon it aber niong bunga it kahoy dili sa tanuman. ");
INSERT INTO bno_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kag siling it Dios, ‘Indi kamo puyde magkaon it bunga it kinang puno raha sa tunga it tanuman nak nagtata-o it kaayaman tungor sa maado ag mayain. Ag indi ra ninro puyding huytan kina. Kung kamo ay magsuway, mamamatay kamo.’ ” ");
INSERT INTO bno_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nagsabat kag sawa, “Indi ra kamo mamatay! ");
INSERT INTO bno_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kada ingsiling kina sa inro it Dios ay dahil ayam it Dios nak sa oras nak magkaon kamo it kina ay mabubuksan kag inro isip, ag kamo ay magiging pareho sa Dios nak nakakaayam it maado ag mayain.” ");
INSERT INTO bno_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Namasran it kabade nak katong bunga ay pay kamumuot, ag kaiila gikaunon. Nagustuhan ra nida nak magkaon it katong bunga agor magiging maayam sida, kada naghugot sida it bunga ag ida kato ingkaon. Pagkatapos, naghugot ray sida it usa pa ag ingta-o nida sa ida asawa ag ingkaon ra it kali. ");
INSERT INTO bno_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Pagkakaon ninra ay nabuksan kag inra isip ag namalayan ninra nak sinra ay uba, kada nagbaoy sinra it mga rahon it igos ag ingtahi-tahi ninra ag inghimong bahag bilang pangtabon sa inra yawas. ");
INSERT INTO bno_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","It katong bandang haponey, narunggan ninra kag GINOONG Dios nak nagpapamasyar sa tanuman, kada sinra ay nagtago sa yudo it mga puno it kahoy. ");
INSERT INTO bno_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pero ging-ayaba kag kayake it GINOONG Dios sa pagsiling, “Hariin ikaw?” ");
INSERT INTO bno_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nagsabat kag kayake, “Narunggan nako kag Imo pagpanaw dili sa tanuman, ag nahadlok ako dahil ako ay uba, kada ako ay nagtago.” ");
INSERT INTO bno_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nagpangutana kag Dios sa ida, “Sin-o kag nag-uma sa imo nak ikaw ay uba? Ingkaon baga nimo katong bunga nak ingsiling nako sa inro nak indi ninro gigkaunon?” ");
INSERT INTO bno_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nagsabat ray kag kayake, “Kali nganing kabade nak Imo ingta-o sa ako it imaw ka nagta-o sa ako it bunga it katong kahoy, kada nagkaon ako.” ");
INSERT INTO bno_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nagpangutana ngasing kag GINOONG Dios sa kabade, “Asing imo kali inghuman?” Nagrason kag kabade, “Kag sawa ay imaw it nagluko sa ako, kada nagkaon ako.” ");
INSERT INTO bno_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Pagkatapos, ingbisayahan it GINOONG Dios kag sawa, “Dahil dili sa imo ginghuman, Ako sumpa ay imo maaaguman. Sa tanang hadop dili sa kalibutan, aber sa mga maanar o maila man, pagsumpa sa imo ay yabaw sa tanan. Imo bituka kag imo ikamang, makaon ka it taybo hastang sa waya't katapusan. ");
INSERT INTO bno_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ikaw ag kaling kabade ay mahangit-hangitan, hasta sa imo kaanak-anakan ag sa ida kaanak-anakan, usa sa inra, sa imo uyo ay mayusak, kag ida buoy ay imo atukmuon.” ");
INSERT INTO bno_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ag ingbisayahan ra Nida kag kabade, “Arugangan Nako kag hirap nak imo arayanan, sa imo pagpanganak, hapros ay aaguman. Sa yudo it kali, asawa'y ahanrumon gihapon, ag sida kag imo asunron.” ");
INSERT INTO bno_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ag sa kayake kali kag Ida ingbisaya, “Dahil sa pagpati sa imo asawa, ag dahil sa pagkaon it bawal nak bunga, di baga siling Nako, ‘Aya kina gikauna,’ Kada kag duta ay Ako gingsusumpa. Sa imo ginghuman, imaw kali kag gaba, hastang ikaw ay buhi rahali sa duta, bag-o makakaon ay mahirap it rugkay sa raga. ");
INSERT INTO bno_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kag matubo rili'y mga tanom nak siiton, magabon ra kag mga hilamunon. Mga tanom sa kabukiran kag imo akaunon. ");
INSERT INTO bno_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Sa pagtrabaho ikaw ay apanggauson, bag-o ka magkainggwa it inro makakaon. Kali ay aagwantahon hastang imo kamatayon, hasta sa pagbalik it imo yawas sa raga, nak kung hariin ikaw ay Ako gingtuga, ikaw ay taybo yang, kada mabalik ka sa duta.” ");
INSERT INTO bno_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Pagkatapos it kaling ingbisaya it GINOONG Dios, kag kayake nak kag pangayan ay Adan, ay ida ingpangayanan kag ida asawa nak Eba, dahil sida kag magiging nanay it tanang tawo nak nabubuhi. ");
INSERT INTO bno_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ag sinra ay ginghimuan it GINOONG Dios it mga baro halin sa anit it hadop ag kali ay ingpasuksok Nida kana Adan ag Eba. ");
INSERT INTO bno_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Pagkatapos, nagsiling kag GINOONG Dios sa Ida sarili, “Muyati, kag tawo ay tuyarey sa ato nak ayamey kag maado ag mayain. Dapat tan-a ay inding gador sinra makakaon it bunga it kaling puno nak nagtata-o it kabuhi, dahil sa oras nak inra kali makaon ay mabubuhi sinra hastang sa waya't katapusan.” ");
INSERT INTO bno_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kada ingpalayas it GINOONG Dios kag tawo paliwas sa Eden ag ingparugkay kag raga. Halin sa raga ngani kag tawo ay ingpurma it Dios ag ngasing raga gihapon kag dapat nidang rugkayon pramas parayan raha ay magkakainggwa sida it akaunon. ");
INSERT INTO bno_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Pagkatabog Nida sa tawo halin sa Eden, nagbutang Sida ruto it mga anghel nak ingtatawag nak kerubin hampig sa subatan it kinang tanuman. Kali ay inggwa't hudot nak pay espadang nagrarayab-rayab ag nagtitiyog, agor sinra kag maharang sa mga masuor ruto sa puno nak nagtata-o it kabuhi. ");
INSERT INTO bno_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ngasing, ing-ubayan ni Adan kag ida asawa nak si Eba, ag kali ay nagsabak. Pagkaanak nida ay napasiling sida, “Nagkainggwa ako it anak nak kayake sa bulig it ato GINO-O,” kada ingpangayanan nida kali nak Cain. ");
INSERT INTO bno_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Masunor, ing-anak ray nida si Abel. Katong nagrakoey sinra, si Abel ay naging manug-alaga it mga karnero ag si Cain ay naging mangunguma. ");
INSERT INTO bno_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Pagkalipas it pilang panahon nagraya si Cain it mga bunga it ida mga panubas ag inghalar kali sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Pero para kang Abel, sida ay nagpili it pinaka-maado sa mga unang anak it ida mga alagang karnero. Ging-ihaw nida kali ag ingbaoy kag pinaka-maado ag pinaka-mataba nak parti ag ida ingraya pramas ihalar sa GINO-O. Namut-an it GINO-O kag halar ni Abel, ");
INSERT INTO bno_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","pero waya gibatuna it GINO-O kag halar ni Cain, kada napakahangit si Cain ag sida'y nagkusmor. ");
INSERT INTO bno_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ngani, nagpangutana kag GINO-O kang Cain, “Asing nahangit ka? Asing nagkukusmor ka? ");
INSERT INTO bno_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kung maado tan-a kag imo ginghimo, ay dey masadya tan-a ikaw ngasing. Pero dahil buko tama kag imo inghimo, buko mahirap para sa imo nak magkasala liwat. Dahil kag sala ay pay tuyar sa maisog nak sawa nak nag-uulikon mayungot sa hagran nak hanrang magpanukob sa imo. Dapat maraugan nimo kali.” ");
INSERT INTO bno_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Usang adlaw ing-ikag ni Cain kag ida manghor nak si Abel, “Kitay, mapamasyar ruto sa bukir.” Pag-abot ninra ruto sa bukir inglipat nida si Abel ag gingmatay. ");
INSERT INTO bno_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Pagkatapos it kali, gingpangutana it GINO-O si Cain, “Hariin kag imo manghor?” Sabat nida, “Ilam, buko nako ayam! Asi, ako kag manugbantay it ako manghor?” ");
INSERT INTO bno_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nagpangutana ray kag GINO-O, “Asi, ni-o kaling imo ginghimo? Panimati-i anay, kag rugo it imo manghor ay pay nagpapakitluoy sa Ako agor Ako it mabayos para sa ida. ");
INSERT INTO bno_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kada ingsusumpa ka Nako, ag ngasing, apalayason ka Nako rili sa duta nak inghunuban it rugo it imo manghor nak imo ingmatay. ");
INSERT INTO bno_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Pag nagrurugkay ikaw it bukir kag mga tanom ruto ay indiey magpanubas it maado, ag ikaw ay malibot-libot yangey ag waya't permanenting istaran.” ");
INSERT INTO bno_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Pagkarungog ni Cain sa ingsiling it GINO-O bilang parusa sa ida, ay napasiling sida, “Abang bug-at kaling Imo ingbayos sa ako, pay indi nako kaya. ");
INSERT INTO bno_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kung apalayason ako Nimo riling duta ag mapayado sa Imo pagbantay, sa ako paglibot-libot sin-o mang makakita sa ako, ako ay amatyon.” ");
INSERT INTO bno_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Pero nagsabat kag GINO-O sa ida, “Indi kina matabo! Sin-o man kag mamatay sa imo, ay pitong pilo kag kabaydong parusa para sa imo kabuhi. Kada abutangan ka Nako it tanra agor pag makita ikaw ninra, indi ikaw gimatyon.” ");
INSERT INTO bno_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Pagkatapos, nagyado si Cain sa GINO-O ag nagpagto sida sa lugar it Nod hampig sa subatan it Eden, ag ruto sida nag-istar. ");
INSERT INTO bno_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Pagkalipas it pilang panahon, ing-ubayan ni Cain kag ida asawa ag kali ay nagsabak, ag kag ida naging anak ay si Enoc. It kato nagtugrok si Cain it syudad ag kaling syudad ay ida ingpangayan sa ida anak nak si Enoc. ");
INSERT INTO bno_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Masunor, nagkainggwa si Enoc it anak nak si Irad. Kag anak ni Irad ay si Mehujael. Kag anak ni Mehujael ay si Metusael. Kag anak ni Metusael ay si Lamec. ");
INSERT INTO bno_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Si Lamec ay nagkainggwa't ruhang asawa. Kag usa ay si Ada, ag kag pangruha ay si Zilla. ");
INSERT INTO bno_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ing-anak ni Ada si Jabal nak imaw kag naging tatay it mga nag-aalaga it kahadupan, ag nag-iistar sa tolda nak human sa anit it mga hadop. ");
INSERT INTO bno_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Kag ida manghor ay si Jubal nak naging tatay it mga maayo maggitara ag maayo magplawta. ");
INSERT INTO bno_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ag si Zilla ay nag-anak kang Tubal-Cain nak naging manugsaysay it mga gamit nak human sa bronse ag saysayon. Kag ida manghor nak kabade ay si Naama. ");
INSERT INTO bno_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Tong huli, nagpahadak si Lamec sa ida mga asawa sa pagsiling, “Ada ag Zilla, panimati kamo sa ako, kamo nak mga asawa nako. Ako'y nagmatay it tawong sa ako ay nagpanglabo, usang binatang nagpanghapros sa ako. ");
INSERT INTO bno_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kag nagmatay kang Cain kuno ay abayusan it makapito (7), kag mamatay sa ako, nak si Lamec, kali ay klaro ay abayusan it makapitong pilo ag pito (77).” ");
INSERT INTO bno_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Pagkamatay ni Abel kaling mag-asawa nak si Adan ag si Eba ay nagkainggwa ray it anak nak kayake. Ag ingpangayanan kali ni Eba nak Set, dahil siling nida, “Ingtaw-an ray ako it Dios it anak nak kabaydo ni Abel nak gingmatay ni Cain.” ");
INSERT INTO bno_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ag tong marakoey si Set, nagkainggwa ra sida it anak nak si Enos. Ag sa kapanahunan ni Enos ay nagtuna it pagtawag kag mga tawo sa GINO-O sa inra pagdayaw ag pagpangamuyo. ");
INSERT INTO bno_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Imaw kali kag nakasuyat nahanungor sa mga inanak ni Adan. It katong gingtuga it Dios kag tawo, inghuman nida kag tawo nak pay tuyar sa ida. ");
INSERT INTO bno_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Gingtuga Nida kag kayake ag kabade, ag pagkatapos ay ingpakamaado sinra ag ingtawag nak “tawo.” ");
INSERT INTO bno_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Pag-abot ni Adan sa edad nak syento treynta (130) anyos, nagkainggwa sida it pangtatlong anak nak kayake nak pay tuyar sa ida ag naambit sa ida. Kali ay ida ingpangayanan nak Set. ");
INSERT INTO bno_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Pagkaanak kang Set ay nabuhi pa si Adan it otso syentos (800) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade, ");
INSERT INTO bno_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","bag-o sida namatay sa edad nak nwebe syentos ag trenta (930) anyos. ");
INSERT INTO bno_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Pag-abot ni Set sa edad nak syentoy-singko (105) anyos ay nagkainggwa sida it anak nak kayake nak si Enos. ");
INSERT INTO bno_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Pagkaanak kang Enos ay nabuhi pa si Set it otso syentos ag syete (807) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade, ");
INSERT INTO bno_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","bag-o sida namatay sa edad nak nwebe syentos ag dose (912) anyos. ");
INSERT INTO bno_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Pag-abot ni Enos sa edad nak nobenta (90) anyos ay nagkainggwa sida it anak nak kayake nak si Kenan. ");
INSERT INTO bno_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Pagkaanak kang Kenan ay nabuhi pa si Enos it otso syentos ag kinse (815) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade, ");
INSERT INTO bno_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","bag-o sida namatay sa edad nak nwebe syentos ag singko (905) anyos. ");
INSERT INTO bno_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Pag-abot ni Kenan sa edad nak sitenta (70) anyos ay nagkainggwa sida it anak nak kayake nak si Mahalalel. ");
INSERT INTO bno_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Pagkaanak kang Mahalalel ay nabuhi pa si Kenan it otso syentos ag kwarenta (840) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade, ");
INSERT INTO bno_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","bag-o sida namatay sa edad nak nwebe syentos ag dyes (910) anyos. ");
INSERT INTO bno_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Pag-abot ni Mahalalel sa edad nak saisentay-singko (65) anyos ay nagkainggwa sida it anak nak kayake nak si Jared. ");
INSERT INTO bno_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Pagkaanak kang Jared ay nabuhi pa si Mahalalel it otso syentos ag treynta (830) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade, ");
INSERT INTO bno_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","bag-o sida namatay sa edad nak otso syentos ag nobentay-singko (895) anyos. ");
INSERT INTO bno_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Pag-abot ni Jared sa edad nak syento saisentay-dos (162) anyos ay nagkainggwa sida it anak nak kayake nak si Enoc. ");
INSERT INTO bno_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Pagkaanak kang Enoc ay nabuhi pa si Jared it otso syentos (800) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade, ");
INSERT INTO bno_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","bag-o sida namatay sa edad nak nwebe syentos ag saisentay-dos (962) anyos. ");
INSERT INTO bno_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Pag-abot ni Enoc sa edad nak saisentay-singko (65) anyos ay nagkainggwa sida it anak nak kayake nak si Metusela. ");
INSERT INTO bno_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Pagkaanak kang Metusela ay nagpangabuhi pa si Enoc it kaibhanan permi kag Dios sa sakop it tres syentos (300) anyos, ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade ");
INSERT INTO bno_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","bag-o sida umabot sa edad nak tres syentos ag saisentay-singko (365) anyos. Kag Dios ay namuot kang Enoc dahil sida ay permi Nidang kaibahan. Kada usang adlaw it kato si Enoc ay gulping nawagit rili sa duta dahil gingraya sidang buhi pa it Dios sa langit. ");
INSERT INTO bno_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Pag-abot ni Metusela sa edad nak syento otsentay-syete (187) anyos ay nagkainggwa sida it anak nak kayake nak si Lamec. ");
INSERT INTO bno_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Pagkaanak kang Lamec ay nabuhi pa si Metusela it syete syentos ag otsentay-dos (782) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade, ");
INSERT INTO bno_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","bag-o sida namatay sa edad nak nwebe syentos ag saisentay-nwebe (969) anyos. ");
INSERT INTO bno_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Pag-abot ni Lamec sa edad nak syento otsentay-dos (182) anyos ay nagkainggwa sida it anak nak kayake, ");
INSERT INTO bno_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ag ingpangayanan nida kali nak Noe, dahil nagsiling sida, “Imaw kali kag mata-o sa ato it kahilwayan halin sa hirap sa pagpangabudlay rili sa duta nak ingsumpa it GINO-O.” ");
INSERT INTO bno_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Pagkaanak kang Noe ay nabuhi pa si Lamec it kinyentos ag nobentay-singko (595) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade, ");
INSERT INTO bno_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","bag-o sida namatay sa edad nak syete syentos ag sitentay-syete (777) anyos. ");
INSERT INTO bno_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Pag-abot ni Noe sa edad nak kinyentos (500) anyos ay ing-anak si Sem, si Ham, ag si Japet. ");
INSERT INTO bno_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","It katong nagramo kag mga tawo sa kalibutan ay nagkainggwa sinra it maramong mga anak nak kabade. ");
INSERT INTO bno_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","It kato ay inggwa it mga ingsisiling nak mga kayake nak anak it Dios, ag tong nakita ninra nak abang ganda kaling mga kabade nak anak it tawo ay nagpili sinra it aber sin-ong inra magustuhan, ag inra kali gingpangasawa. ");
INSERT INTO bno_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kada nagsiling kag GINO-O, “Indi Ako magpasensya sa mga tawo sa habang panahon, dahil sinra ay paliwat-liwat nak nagpapaka-sala. Indiey Nako gitugutan nak maglampas pa kag syento beynte (120) nak tuig.” ");
INSERT INTO bno_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","It katong panahong kato nak nagpangasawa kag mga kayake nak anak it Dios sa mga kabade nak anak it tawo, ag aber tong huli, ay inggway ra sa kalibutan it mga Nepilim nak imaw kag bantog nak mga kauisog ag mga karuragko nak mga mangraraog. ");
INSERT INTO bno_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","It katong nakita it GINO-O nak subra-subray kag kayainan it mga tawo sa kalibutan, ag perming mayain kag inra ing-iisip, ");
INSERT INTO bno_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ay nalisor ag nagsuli-suli Sida sa ida paghuman sa tawo. ");
INSERT INTO bno_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kada nagsiling Sida, “Awagiton Nako sa ibabaw it kalibutan kag tanang mga tawo nak Ako gingtuga, pati kag tanang hadop nak nagpapanaw o nagkakamang man, ag tanang mga pispis, dahil rakong gador kag Ako pagsuli-suli nak Ako sinra inghuman.” ");
INSERT INTO bno_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero kag GINO-O ay namuot sa batasan ni Noe. ");
INSERT INTO bno_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Imaw kali kag istorya tungor kang Noe ag ida mga inanak. Sa tanang mga tawo it kato, si Noe yang kag maadong tawo nak nagtuman sa Dios ag nagpapangabuhi nak kaibahan Nida. ");
INSERT INTO bno_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nagkainggwa si Noe it tatlong anak nak kayake nak sina Sem, Ham ag Japet. ");
INSERT INTO bno_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","It kato sa pagmuyat it Dios kag ibang mga tawo sa kalibutan ay abang yain, ag aber hariin sa kalibutan, kag inra ingpapakita nak batasan sa usa'g-usa ay mapintas ag maisog. ");
INSERT INTO bno_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Natingaya kag Dios tong nakita Nida kung pauno it yain kag mga tawo, dahil abang yain talaga kag inghihimo permi it tanan. ");
INSERT INTO bno_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ag nagbisaya kag Dios kang Noe, “Awagiton nak gadorey Nako kag tanang mga tawo, dahil kaisog kag inra pagtratar sa usa'g-usa sa bug-os nak kalibutan ay abang isog. Ngani awagiton nak gador Nako sinra parayan sa pagsira sa duta. ");
INSERT INTO bno_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Maghuman ka it arka nak yari sa mga maadong kahoy nak Sipres. Apahuptan nimo kag arka it ispalto sa suyor ag sa liwas. ");
INSERT INTO bno_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Tuyar kali kag imo paghuman it arka. Kag haba ay nobenta nak rupa (450 pye o 133 metros), ag kag yapar ay kinse nak rupa (75 pye o 22 metros), ag kag taas ay sidam nak rupa (45 pye o 13 metros). ");
INSERT INTO bno_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Humani kali it kuyungan ag kag palibot it ubos it kabhaan ay ibilin nimo nak abrido it tatlong rangaw (1.5 pye o 44 centimetros) agor imaw it arayanan it hangin. Sa suyor it kaling arka ay maghimo ka it tatlong palapag nak di kwarto bilang mga kulungan, ag butange it pwertahan sa habig it arka. ");
INSERT INTO bno_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Bantaye! Apabahaon Nako kag kalibutan agor kag tanan nak inggwa't kabuhi rili ay mamamatay. ");
INSERT INTO bno_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pero mahuman Ako it kasugtanan sa imo. Masuyor kamong tanan sa arka, kamo it imo asawa, imo mga anak nak kayake ag imo mga umagar. ");
INSERT INTO bno_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","“Maraya ra ikaw it iba't-ibang mga hadop nak mag-asawa, maanar ag maila, ag tanang iba't-ibang mga pispis, agor inggwa't matuturang buhi sa inra mga klase. Apasuuron Nako sinra sa imo. ");
INSERT INTO bno_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Maraya ra ikaw it inro mga akaunon para sa imo pamilya ag para sa tanang hadop, ag hipiron kali. Imaw kali kag inro akaunon pag sa suyorey kamo it arka.” ");
INSERT INTO bno_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ag ingtuman matuor ni Noe kag tanang ingsugo sa ida it Dios. ");
INSERT INTO bno_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Pagligar it pilang tuig, nagsugo kag GINO-O kang Noe, “Suyor kamo it imo pamilya sa arka nak imo inghuman, dahil nakita Nako nak ikaw yang kag maadong tawo sa tanang mga tinawo dili. ");
INSERT INTO bno_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Maraya ikaw it mag-asawa it tanang iba't-ibang mga hadop nak indi puyding matyon bilang inughalar sa Ako dahil buko malimpyo. Maraya ra ikaw it pitong iba't-ibang mga malimpyong hadop nak mag-asawa nak puyding matyon bilang inughalar sa Ako. ");
INSERT INTO bno_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Imaw ra, maraya ra ikaw it mag-asawa it tanang iba't-ibang mga pispis nak buko malimpyo ag pitong mag-asawa it iba't-ibang mga malimpyong pispis. Sa parayang kali magkakainggwa it matuturang buhi, nak imaw ray kag maparamo sa inra klase sa ibabaw it duta. ");
INSERT INTO bno_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pagkalipas it pitong adlaw, Ako apauyanon it kwarentang adlaw ag kwarentang gab-i, ag awagiton Nako kag tanang inggwa't kabuhi nak Ako inghuman dili sa duta purya sa inro nak asa suyor it arka.” ");
INSERT INTO bno_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ag ingtuman matuor ni Noe kag tanang ingsugo sa ida it Dios. ");
INSERT INTO bno_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Kag edad ni Noe it katong gingbaha kag kalibutan ay sais syentos (600) anyos. ");
INSERT INTO bno_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Si Noe ag kag ida asawa, kag ida mga anak nak kayake ag ida mga umagar ay naghanra sa pagsakay sa arka agor malibre sinra sa pagbaha. ");
INSERT INTO bno_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Pagsuor kang Noe it tanang iba't-ibang mga hadop ag pispis nak malimpyo ag buko malimpyo, ");
INSERT INTO bno_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ay ida ingpasuyor kali it tig-ruha-ruha, kabade ag kayake, kumporme sa sugo it Dios, ");
INSERT INTO bno_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","dahil paglipas it pitong adlaw ay matunaey kag pagbaha sa kalibutan. ");
INSERT INTO bno_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Pitsa disi-syete it pangruhang buyan ag pangsais syentos (600) anyos it edad ni Noe, tanang tuburan sa duta ag sa ragat ay nagbuka, ag nagpakarugos it pay nagbuka kag langit. ");
INSERT INTO bno_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Waya't tungon-tungon kag pagrugos sa suyor it kwarentang adlaw ag kwarentang gab-i. ");
INSERT INTO bno_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","It katong adlaw mismo nak kato, bag-o nagtuna kag pagbaha, si Noe ag kag ida asawa, kag ida mga anak nak kayake nak sina Sem, Ham ag Japet, kaibahan kag inra mga asawa ay nagsuyor sa arka. ");
INSERT INTO bno_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Asa suyorey ra kag mga mag-asawang hadop nak mga maanar ag mga maila nak nagpapanaw ag nagkakamang, ag mga pispis ag mga maintik nak sapat nak nagyiyinupar, kumporme sa inra iba't-ibang klase. ");
INSERT INTO bno_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Kaling tanan nak inggwa't kabuhi ay nagsuorey kang Noe ag ida'y napasuyor it tig-ruha-ruha. ");
INSERT INTO bno_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ag napasuyor matuor kaling tanang mga mag-asawang hadop, kumporme sa sugo it Dios. Masunor, nagsuyorey ra sina Noe ag ingsarhan it GINO-O kag pwertahan it arka. ");
INSERT INTO bno_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Pumakarugos ag pumakabaha sa suyor it kwarentang adlaw ag kwarentang gab-i ag kag tubi ay nagpakarako, kada nagyutaw kag arka. ");
INSERT INTO bno_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Kag tubi ay nagpakarako pa nak gador ag kag arka ay ging-anor-anor. ");
INSERT INTO bno_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nagpakarako gihapon kag tubi hastang kag tanang mataas nak baguntor sa duta ay nayapawan. ");
INSERT INTO bno_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Nagpakarako pa gihapon kag tubi hastang kag rayom ay nag-abot sa limang rupa (25 pye o 7 metros) halin sa ibabaw it mga baguntor nak nayapawaney. ");
INSERT INTO bno_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kada namatay kag tanan nak inggwa't kabuhi nak naghihiwas sa kalibutan, mga pispis, mga hadop nak maanar ag maila, mga maintik nak sapat nak nagyiyinupar, ag tanang mga tawo. ");
INSERT INTO bno_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tanang naghihingab sa kalibutan ay namatay. ");
INSERT INTO bno_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Gingwagit matuor it GINO-O kag tanang mga tawo, kag tanang mga hadop nak maanar ag maila, ag tanang mga pispis sa kalibutan. Kag waya yang nagkamatay ay sina Noe ag kag ida mga kaibahan nak hadop sa suyor it arka. ");
INSERT INTO bno_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kag tubi ay nagtiner sa kalibutan sa suyor it syento singkwenta (150) nak adlaw. ");
INSERT INTO bno_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","2","Waya gilimte it Dios sina Noe ag kag tanang mga kahadupan nak kaibahan nida sa suyor it arka. Gingpatabo Nida kag mga tuburan ag gingpahuyaw kag uyan. Ingpahudop ra Nida kag hangin sa kalibutan, ag kag tubi ay nag-inot-inot it paghubas. ");
INSERT INTO bno_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Matuor kag tubi sa duta ay nag-inot-inot it paghubas. Ag pagkalipas it syento singkwenta (150) nak adlaw, ");
INSERT INTO bno_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","sa pitsa disi-syete it pangpitong buyan it katong tuig nak kato ay naghubas kag tubi, ag nagsarsar kag arka sa usa sa mga bukir it Ararat. ");
INSERT INTO bno_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Hastang sa primerong adlaw it ika-sampuyong buyan nak padayon kag paghubas it tubi, kag mga tuktok it ibang mga baguntor ay nagyinuawey. ");
INSERT INTO bno_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Pagkalipas pa it kwarentang adlaw, ingbuksan ni Noe kag gaha it arka nak ida inghimo ");
INSERT INTO bno_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ag ingpayupar nida paliwas kag usang uwak. Kaling uwak ay waya gibalik kundi nagpakayupar yang palibot-libot sa kalibutan, hastang sa paghubas it tubi. ");
INSERT INTO bno_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Masunor ay ingpayupar ray ni Noe kag usang salumpati agor masaduran kung hubasey kag tubi sa kalibutan. ");
INSERT INTO bno_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pero waya kali it nakita nak maaapunan dahil yapaw pa kag tubi sa duta, kada nagbalik sida kang Noe ruto sa arka. Ingpaapon ni Noe sa ida damot kaling salumpati ag ingraya sa suyor. ");
INSERT INTO bno_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Naghuyat pa si Noe it pitong adlaw bag-o ingpayupar ray nida liwat katong salumpati. ");
INSERT INTO bno_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pagkagab-i ay nagbalik kali sa ida ag nakita nida nak sa buntok it kali ay inggwa't raya nak maisot nak sanga it olibo nak di usbor, kada naayaman ni Noe nak inggwa't duta nak nahubasaney. ");
INSERT INTO bno_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Masunor, naghuyat pa gihapon si Noe it pitong adlaw, ag ingpayupar ray liwat nida katong salumpati. Pero wayaey kali gibalik. ");
INSERT INTO bno_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Primerong adlaw it bag-ong tuig ay ika-sais syentos ag usang (601) anyos it edad ni Noe it katong naghubas kag tubi sa duta, ingtukas nida kag kuyungan it arka ag pagmuyat nida sa palibot, nakita nida nak wayaey it tubi. ");
INSERT INTO bno_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pitsa beynte syete it pangruhang buyan it tuig nak kato tong kag duta ay ugay nak gador. ");
INSERT INTO bno_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ngasing, nagsiling kag Dios kang Noe, ");
INSERT INTO bno_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Liwasey kamo raha sa arka, kamo it imo asawa, kaibahan it inro mga anak nak kayake ag inro mga umagar. ");
INSERT INTO bno_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Paliwasay ra kag tanang inro kaibahang mga hadop, kag mga pispis, kag mga hadop nak maanar ag maila nak nagpapanaw ag nagkakamang, agor sinra ay magbuar ag magpakaramo pa sa kalibutan.” ");
INSERT INTO bno_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kada si Noe ay nagliwas sa arka kaibahan kag ida asawa, kag ida mga anak nak kayake ag inra mga asawa. ");
INSERT INTO bno_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kag tanang mga hadop nak nagpapanaw ag nagkakamang, ag tanang mga pispis, kag tanan nak naghihiwas sa kalibutan ay nagliwas sa arka it pami-pamilya kumporme sa inra klasi. ");
INSERT INTO bno_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Pagkaliwas ninra sa arka, nagsug-on-sug-on si Noe it mga bato bilang altar para sa GINO-O. Nagbaoy sida it usa sa kada malimpyong hadop ag imaw ra sa pispis nak puyding ihalar, ag kali ay ida ingmatay ag ingsunog sa altar. ");
INSERT INTO bno_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","It kag nahugman it GINO-O kag mabangyo nak hugom it halar ni Noe ay nagsiling Sida sa Ida Sarili, “Indiey nak gador Nako gisiraon liwat kag kalibutan dahil sa tawo, aber naaayaman nako nak tuna pa yang sa pag-anak sa inra mayainey kag inra ing-iisip. Ag indiey nak gador Nako giwagiton liwat kag tanang inggwa't kabuhi tuyar it kaling Ako ginghimo ngasing. ");
INSERT INTO bno_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Habang kag kalibutan ay rahina, indi mawagit kag tigtanom ag tig-ani, kag tigyamig ag tig-init, kag kwarisma ag tig-uyan, ag kag adlaw ag gab-i.” ");
INSERT INTO bno_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Gingpakamaado it Dios si Noe ag kag ida mga anak sa pagsiling, “Mag-anak kamo ag magramo, ag pun-a ninro kag kalibutan. ");
INSERT INTO bno_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mapapaka-hadlok nak gador sa inro kag tanang mga hadop nak nagpapanaw ag nagkakamang, kag tanang mga pispis ag kag tanang mga isra, ag kamo kag magahom sa inra. ");
INSERT INTO bno_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ingtata-o kali Nako ngasing sa inro agor inro kaunon, tuyar sa pagkaon ninro sa mga tanom nak dating Ako ingta-o. ");
INSERT INTO bno_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Pero indi nak gador ninro gikaunon kag karne it hadop nak waya napatuyo kag rugo, dahil kag kabuhi ay hina sa rugo. ");
INSERT INTO bno_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sin-o man kag magpangmatay it ida isigkatawo, sida ay Ako asukton sa kabuhi nak ida ing-utang. Imaw ra kag kada hadop nak makamatay it tawo, dapat kaling hadop ay matyon. ");
INSERT INTO bno_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Kung sin-o man kag tawo nak mamatay sa ida isigkatawo, ay amatyon ra sida it ibang tawo, dahil kag tawo ay inghuman it Dios nak naambit sa Ida. ");
INSERT INTO bno_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Ag kamo ay mag-anak ag magramo, agor kag inro magiging mga inanak ay imaw it mapuno sa kalibutan.” ");
INSERT INTO bno_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ag nagsiling kag Dios kang Noe ag sa ida mga anak, ");
INSERT INTO bno_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Mahuman Ako it kasugtanan ag mapromisa nak gador Ako sa imo, Noe, ag sa imo magiging mga inanak, ");
INSERT INTO bno_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ag pati ra sa tanang inggwa't kabuhi nak kaibahan ninro nak nagliwas halin sa arka, sa mga pispis ag sa mga hadop nak maanar ag maila. ");
INSERT INTO bno_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mahuman Ako it kasugtanan sa inro nak indiey Nako liwat giwagiton kag tanang inggwa't kabuhi ag indiey Nako liwat gisiraon kag kalibutan sa parayan it pagbaha.” ");
INSERT INTO bno_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ag nagsiling pa kag Dios, “Imaw kali kag tanra it Ako kasugtanan sa inro ag sa tanang inggwa't kabuhi nak kaibahan ninro, ag pati sa tanang inro mga inanak sa paabutong balhin it inro linahi. ");
INSERT INTO bno_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ingbutang Nako kag Ako bayangaw sa langit bilang tanra it Ako kasugtanan sa inro rili sa kalibutan. ");
INSERT INTO bno_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Paglipas it marag-om nak rampog ag magyuaw sa langit kag bayangaw, ");
INSERT INTO bno_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","arumrumon Nako kag Ako promisa sa inro ag sa tanang iba't-ibang inggwa't kabuhi. Indiey magkainggwa liwat it baha nak mawagit sa tanang inggwa't kabuhi. ");
INSERT INTO bno_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pag nagyuaw kag bayangaw sa langit, makikita Nako kato ag marurumruman Nako kag Ako waya't katapusang kasugtanan sa inrong tanan nak inggwa't kabuhi sa kalibutan.” ");
INSERT INTO bno_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kada, nagsiling kag Dios kang Noe, “Imaw kali kag tanra nak nagpapamatuor it Ako kasugtanan sa inrong tanan rahali sa kalibutan.” ");
INSERT INTO bno_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Kag mga anak nak kayake ni Noe nak kaibahan nida nak nagliwas sa arka ay sina Sem, Ham ag Japet. Si Ham kag tatay ni Canaan. ");
INSERT INTO bno_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Kaling tatlong anak ni Noe ay imaw kag ginghalinan it tanang mga tawo sa kalibutan pagkalipas it baha. ");
INSERT INTO bno_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Si Noe ay usang mangunguma ag nagpapaninanom sida it mga ubas. ");
INSERT INTO bno_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Halin sa ubas, naghuman sida it ayak nak ida ing-inom ag sida ay nayango. It katong mayango si Noe, sida ay naghigra ag nakatuyugan nak nakauba sa suyor it ida istaran nak tolda nak halin sa anit it mga hadop. ");
INSERT INTO bno_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Si Ham, nak tatay ni Canaan, ay nagsuyor sa tolda ni Noe. It katong makita nida nak nakauba kag ida tatay ay ida ginur-an. Nagliwas sida ag nag-uma sa ida mga hali. ");
INSERT INTO bno_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Pagkasador nina Sem ag Japet nak nakauba kag inra tatay ay nagbaoy sinra it tamong ag inghuytan ninra sa magkanyudong pusor it lampas sa inra abaga, ag nag-iisol sinra habang nagpapayungot sa inra tatay ag inra ingtamungan. Waya ninra nakita nak uba kag inra tatay dahil nakatalikor sinra. ");
INSERT INTO bno_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","It katong naumpawaney si Noe ay naayaman nida kag ginghimo it kaling ida anak nak si Ham. ");
INSERT INTO bno_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nagsiling sida, “Si Canaan nak anak ni Ham, ay ako asumpaon, sa ida mga hali, sida'y mapaulipon.” ");
INSERT INTO bno_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nagsiling pa sida, “Kag GINO-O nak Dios ni Sem ay dayawon. Si Canaan ay ida magiging ulipon. ");
INSERT INTO bno_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kabay pang payaparon it Dios kag duta ni Japet, sa mga tolda ni Sem, sida'y abi-abihon, ag si Canaan, ida ra magiging ulipon.” ");
INSERT INTO bno_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pagkalipas it baha ay nabuhi pa si Noe it tres syentos ag singkwenta (350) anyos. ");
INSERT INTO bno_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Umabot sida sa edad nak nwebe syentos ag singkwenta (950) anyos bag-o sida namatay. ");
INSERT INTO bno_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Imaw kali kag istorya it mga inanak ni Noe parayan sa ida mga anak nak kayake nak sina Sem, Ham ag Japet. Nagkainggwa sinra it mga anak pagkalipas it baha. ");
INSERT INTO bno_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Imaw kali kag mga inanak nak kayake ni Japet: Sina Gomer, Magog, Maday, Javan, Tubal, Mesec ag Tiras. ");
INSERT INTO bno_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Si Gomer kag panganay ag imaw kali kag ida mga anak nak kayake: Sina Askenaz, Ripat ag Togarma. ");
INSERT INTO bno_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Usa sa mga manghor ni Gomer ay si Javan ag imaw kali kag ida mga anak nak kayake: Sina Elisar, Tarsis, Kitim ag Dodanim. ");
INSERT INTO bno_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Sa mga anak ni Japet naghalin kag mga tawo nak nagkadat ag nagpang-inistar sa mga habig it baybay ag sa mga puyo. Kada pamilya ay nagkainggwa't inra sariling lugar, ag tong huli ay naging lahi nak nagkainggwa't inra sariling mga bisaya. ");
INSERT INTO bno_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Imaw kali kag mga inanak nak kayake ni Ham: Sina Cus, Misraim, Put ag Canaan. ");
INSERT INTO bno_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Si Cus kag panganay ag imaw kali kag ida mga anak nak kayake: Sina Seba, Havila, Sabta, Raama, Sabteca ag kag pinaka-huli ay si Nimrod. Usa sa mga anak ni Cus ay si Raama, ag imaw kali kag ida mga anak nak kayake: Sina Seba ag Dedan. ");
INSERT INTO bno_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kaling pinaka-huling anak ni Cus nak si Nimrod ay imaw kag unang pinaka-maisog nak manraraog pagkalipas it baha sa kalibutan. ");
INSERT INTO bno_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Sida ay bantog ag maisog nak mangangadam sa pagmuyat it GINO-O, kada inggwa it kabisayahan para sa inra nak, “Abang isog ikaw tuyar kang Nimrod nak maisog nak mangangadam sa pagmuyat it GINO-O!” ");
INSERT INTO bno_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kag unang ida gingharian ay kag mga banwa it Babel, Erec ag Acad sa kapatagan it Sinar. ");
INSERT INTO bno_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Halin ruto nagpagto ra sida sa Asirya, kung hariin ida ingpatinrog kag ap-at nak syudad nak sakop it kinang marakong syudad nak Ninive, kag Ninive, Rehobot-Ir, Cala ag kag Resen nak asa tunga it Ninive ag Cala. ");
INSERT INTO bno_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Kag pangruhang anak nak kayake ni Ham ay si Misraim, ag imaw kali kag mga naging lahi it ida mga anak nak kayake: Mga Ludnon, Anamnon, Lehabnon, Naptunhon, Patrusnon, Caslunhon, ag Cretanhon nak imaw kag inghalinan it mga Pilistinhon. ");
INSERT INTO bno_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kag pang-ap-at ag puto sa mga kayake sa mga anak ni Ham ay si Canaan. Kag panganay nida ay si Sidon ag masunor ay si Het. ");
INSERT INTO bno_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Si Canaan ay tatay ra it mga Jebusnon, Amornon, Girgasanhon, ");
INSERT INTO bno_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hebinhon, Araknon, Sinanhon, ");
INSERT INTO bno_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadnon, Zemarnon ag Hamatnon. Tong huli nagpangkadat kaling mga naging lahi ni Canaan ");
INSERT INTO bno_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ag nagpang-inistar sinra tuna sa Sidon papagto sa Gerar, lampas sa Gaza ag papagto ray sa Sodoma, Gomora, Adma, Zeboyim, lampas sa Lasa. ");
INSERT INTO bno_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Imaw kali kag mga naging lahi ni Ham ag kag mga lugar nak inra ingpang-istaran, ag tong huli ay nagkainggwa sinra it inra sariling mga bisaya. ");
INSERT INTO bno_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Si Sem nak maguyáng nina Ham ag Japet kag tatay it mga Hebreo halin sa ida apo sa tuhor nak si Eber. ");
INSERT INTO bno_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Imaw kali kag mga inanak nak kayake ni Sem: Sina Elam, Asur, Arpaksad, Lud ag Aram. ");
INSERT INTO bno_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Imaw kali kag mga anak nak kayake it putong anak ni Sem nak si Aram: Sina Uz, Hul, Geter, ag Mas. ");
INSERT INTO bno_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Kag pangtatlong anak ni Sem nak si Arpaksad ay nagkainggwa't anak nak kayake nak si Sela, ag kag anak nak kayake ni Sela ay si Eber. ");
INSERT INTO bno_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Kag ruhang anak nak kayake ni Eber ay sina Peleg ag Joktan. Ingpangayanan sida it Peleg dahil kag mga tawo it katong panahon nida ay nagkabuyag-buyag. ");
INSERT INTO bno_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Kag mga anak nak kayake it manghor ni Peleg nak si Joktan ay sina Almodad, Selep, Hazarmavet, Jera, ");
INSERT INTO bno_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO bno_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO bno_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Havila ag Jobab. Imaw kali tanan kag mga anak nak kayake ni Joktan ");
INSERT INTO bno_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","nak nagpang-inistar ruto sa lugar tuna sa Mesa papagto sa Separ, ag papagto ray sa mga bukir nak hampig sa subatan. ");
INSERT INTO bno_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Imaw kali kag mga naging lahi ni Sem nak nagpang-inistar sa inra sariling lugar, ag tong huli ay nagkainggwa sinra it inra sariling mga bisaya. ");
INSERT INTO bno_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Imaw kali tanan kag mga inanak it mga anak ni Noe, kumporme sa inra mga pamilya ag sa inra mga naging lahi. Ag halin sa inra kag mga tawo sa mga nasyon nak nagpangkadat sa kalibutan pagkalipas it baha. ");
INSERT INTO bno_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Pagkalipas it baha, ausa yang kag linggwahe it mga tawo sa kalibutan, ag pare-pareho kag inra pagbisaya. ");
INSERT INTO bno_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Sa inra pagsaydo-saydo, nakaabot sinra sa usang patag sa lugar it Sinar nak tong huli ay naging Babilonya hampig sa subatan, ag ruto sinra nag-istar. ");
INSERT INTO bno_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tong huli, nagsiling sinra sa usa'g-usa, “Mahuman kita it mga kwadradong yunang ag ato atadihon it maado, agor magtibay ag agamiton nato sa pagtugrok it mga bayay.” Imaw kali kag inra inggamit imbes nak mga bato ag ingpapangpahupot kali it mga ispalto pag nagtutugrok sinra it bayay. ");
INSERT INTO bno_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ag nag-abot kag panahon tong nagsiling sinra nak, “Maley, mahuman kita it syudad nak inggwa't mataas nak tore nak abot hastang sa langit, agor kita ay mababantog sabaling kita ay magkabuyag-buyag sa ibabaw it kalibutan.” ");
INSERT INTO bno_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pero nagpilhig kag GINO-O ag ingmuyatan it maado kaling syudad nak inra gingtutugrok, laloey kaling tore nak inra ingpapatukor. ");
INSERT INTO bno_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ag nagsiling Sida, “Muyati kaling mga tawo. Nagkausa sinra nak himuon kali dahil kag inra linggwahe ay ausa yang. Imaw pa yang kali kag una ninrang inghuhuman. Indi marugay ag atumanoney ninra kag aber ni-o kag inra magustuhan. ");
INSERT INTO bno_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kitay, Ato sinra aguluhon pramas mag-iba-iba kag inra linggwahe, agor indi sinra magkaintyendihan.” ");
INSERT INTO bno_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ag inghimo matuor it GINO-O nak iba-iba kag inra mga linggwahe, kada kag ibang mga tawo ay indi maintyendihan it iba pang mga tawo. Kada natungnan kag pagpatugrok ninra it syudad ag sinra ay ingpangpabuyag-buyag it GINO-O ag nagkadat sinra sa ibabaw it kalibutan. ");
INSERT INTO bno_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kada ingpangayanan ninra katong banwa nak Babel nak kag gustong bisayahon ay “inggulo it GINO-O kag inra linggwahe,” ag halin ruto ingpangpabuyag-buyag ag ingpangkadat sinra it GINO-O sa ibabaw it kalibutan. ");
INSERT INTO bno_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Imaw kali kag listahan it mga inanak ni Sem. Ruhang tuig pagkalipas it baha, it katong si Sem ay nag-abot sa edad nak sanggatos (100) anyos, ay nagkainggwa sida it anak nak kayake nak si Arpaksad. ");
INSERT INTO bno_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Pagkaanak kang Arpaksad ay nabuhi pa si Sem it kinyentos (500) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Pag-abot ni Arpaksad sa edad nak treyntay-singko (35) anyos ay nagkainggwa sida it anak nak kayake nak si Sela. ");
INSERT INTO bno_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Pagkaanak kang Sela ay nabuhi pa si Arpaksad it kwatro syentos ag tres (403) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Pag-abot ni Sela sa edad nak treynta (30) anyos ay nagkainggwa sida it anak nak kayake nak si Eber. ");
INSERT INTO bno_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Pagkaanak kang Eber ay nabuhi pa si Sela it kwatro syentos ag tres (403) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Pag-abot ni Eber sa edad nak treyntay-kwatro (34) anyos ay nagkainggwa sida it anak nak kayake nak si Peleg. ");
INSERT INTO bno_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pagkaanak kang Peleg ay nabuhi pa si Eber it kwatro syentos ag treynta (430) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pag-abot ni Peleg sa edad nak treynta (30) anyos ay nagkainggwa sida it anak nak kayake nak si Reu. ");
INSERT INTO bno_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pagkaanak kang Reu ay nabuhi pa si Peleg it dos syentos ag nwebe (209) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Pag-abot ni Reu sa edad nak treyntay-dos (32) anyos ay nagkainggwa sida it anak nak kayake nak si Serug. ");
INSERT INTO bno_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Pagkaanak kang Serug ay nabuhi pa si Reu it dos syentos ag syete (207) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Pag-abot ni Serug sa edad nak treynta (30) anyos ay nagkainggwa sida it anak nak kayake nak si Nahor. ");
INSERT INTO bno_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Pagkaanak kang Nahor ay nabuhi pa si Serug it dos syentos (200) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Pag-abot ni Nahor sa edad nak beynte nwebe (29) anyos ay nagkainggwa sida it anak nak kayake nak si Tera. ");
INSERT INTO bno_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Pagkaanak kang Tera ay nabuhi pa si Nahor it syento disi-nwebe (119) anyos ag nagkainggwa sida it iba pang mga anak nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Pag-abot ni Tera sa edad nak sitenta (70) anyos ay nagkainggwa sida it mga anak nak kayake nak kag panganay ay si Abram, masunor si Nahor bag-o si Haran, nak puro mga kayake. ");
INSERT INTO bno_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Imaw kali kag mga inanak ni Tera. Kag mga anak nak kayake ni Tera ay sina Abram, Nahor, ag Haran. Si Haran ay imaw kag tatay ni Lot. ");
INSERT INTO bno_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","It katong namatay si Haran sa ida sariling lugar sa Ur sa Caldeya ay buhi pa kag ida tatay nak si Tera. ");
INSERT INTO bno_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Si Abram ag si Nahor ay parehong nag-asawa. Kag asawa ni Abram ay si Saray nak ida manghor sa tatay, ag kag asawa ni Nahor ay kag ida kumangkon nak si Milca, nak anak ni Haran, ag maguyáng ni Isca. ");
INSERT INTO bno_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ngasing, kaling si Saray ay baog, kada waya sida nakakaanak. ");
INSERT INTO bno_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Usang adlaw, gingnunot ni Tera kag ida anak nak si Abram, kag ida umagar nak si Saray, ag kag ida apo kang Haran nak si Lot. Halin sa Ur ay papagto tan-a sinra sa lugar it Canaan. Ugaling pag-abot ninra sa banwa it Haran sa Padan-aram ay ruto yangey sinra giistar. ");
INSERT INTO bno_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ag ruto ra namatay si Tera sa edad nak dos syentos ag singko (205) anyos. ");
INSERT INTO bno_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Usang adlaw, nagsiling kag GINO-O kang Abram, “Halin raha sa imo banwa, ag bada-e kag panimayay it imo tatay ag imo mga hali, ag magpagto ka sa lugar nak Ako itudlo sa imo.” ");
INSERT INTO bno_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Aparamuon Nako kag imo mga inanak, ag ahumanon Nako sinra nak bantog ag makusog nak nasyon. Apakamaaduhon Nako kag imo pagpangabuhi, ag mababantog kag imo pangayan. Apakamaaduhon ka Nako agor parayan sa imo kag ibang mga nasyon ay makakabaton ra it mga pagpakamaado.” ");
INSERT INTO bno_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","“Apakamaaduhon Nako kag mga mahimo it maado sa imo, ag isumpa Nako kag mga mahimo it mayain sa imo. Ag parayan sa imo tanang katawuhan sa kalibutan ay makakabaton it mga pagpakamaado.” ");
INSERT INTO bno_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Ngani, naghalin si Abram sa banwa it Haran ag nagpagto sa Canaan kumporme sa sugo it Dios sa ida. Sitentay-singko (75) anyos si Abram it katong naghalin sida ruto. Gingnunot nida kag ida asawa nak si Saray ag kag ida kumangkon nak si Lot. Ag ingraya ra nida kag inra tanang mga ari-arian nak napundar, ag mga suguon nak inra nasasakupan ruto sa Haran. ");
INSERT INTO bno_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Pag-abot ninra sa Canaan nagpadayon sinra hastang makaabot sinra sa More nak sakop it Siquem. Inggwa ruto it usang marakong kahoy nak abang bantog ag nagtungon sinra ruto. It katong panahon nak kato, ruto pa giiinistar kag mga Canaanhon. ");
INSERT INTO bno_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Hagto ay nagpakita kag GINO-O kang Abram ag nagsiling, “Imaw kali kag duta nak Ako ita-o sa usa sa imo mga inanak.” Kada nagsug-on-sug-on si Abram it bato bilang altar para sa GINO-O nak nagpakita sa ida. ");
INSERT INTO bno_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Pagkalipas it pilang adlaw, nagsaydo sinra papagto sa habagatan, sa bukir nak hampig sa subatan it banwa it Betel, ag ruto sida gitukor it inra istaran nak mga tolda nak human sa anit it hadop. Kag lugar nak kato ay asa tunga it Betel ag Ai. Kag Betel ay hampig sa sugbuhan ag kag Ai ay hampig sa subatan. Naghuman ray sida ruto it altar nak bato ag nagdayaw sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Pagkalipas it pilang panahon ay nagpadayon gihapon sinra sa pagsaydo-saydo papagto sa disyerto it Negeb mayungot sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ngasing, nagkainggwa it tigkagutom sa Canaan, kada nagpagto sina Abram sa bandang habagatan sa Ehipto ag ruto anay sinra madayon, dahil subrang tigkagutom sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","It katong mayungotey sinra magsuyor sa Ehipto ay nagsiling si Abram sa ida asawa nak si Saray, “Ayam nako nak ikaw ay maganda gimuyatan. ");
INSERT INTO bno_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Sabaling pag nakita ikaw it mga Ehiptohanon ay magsiling sinra, ‘Kaganda tan-a kaling kabade pero di asaway,’ kada ako ay inra amatyon pero ikaw ay indi. ");
INSERT INTO bno_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Maado pang silinggon yangey nimo nak ikaw ay ako manghor hah, agor aamiguhon ako ninra ag indi ninra ako gimatyon dahil sa imo!” ");
INSERT INTO bno_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Pagkasuyor ninra sa Ehipto nakita ngani it mga Ehiptohanon nak abang ganda kaling kabade. ");
INSERT INTO bno_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ag pagkakita ra sa ida it mga opisyales it hari it Ehipto nak inra ingtatawag nak Paraon, ay ingsiling ninra sa hari kag kagandahan ni Saray. Ngani, ingpabaoy sida ni Paraon ag ingraya sa palasyo. ");
INSERT INTO bno_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ag dahil kang Saray ay naging maado si Paraon kang Abram ag nagkainggwa sida it iba pang mga karnero, kambing, baka, asno ag kamelyo, pati mga kayake ag mga kabading suguon. ");
INSERT INTO bno_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pero kag panimayay ni Paraon ay gingparay-an it GINO-O it mga grabing sakit, dahil sa ida pagbaoy kang Saray nak asawa ni Abram. ");
INSERT INTO bno_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kada tong huli, gingpatawag ni Paraon si Abram ag nagsiling sa ida, “Ni-o kaling imo ginghuman sa ako? Asing waya nimo giumaan nak imo sida asawa? ");
INSERT INTO bno_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Siling nimo ay imo sida manghor, kada ingbaoy nako sida agor ako maging asawa! Hala, kali kag imo asawa. Bay-a sida ag lumayasey kamo!” ");
INSERT INTO bno_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ingsugo ni Paraon kag ida mga tawuhan nak ibhan si Abram paliwas sa Ehipto, kanunot kag ida asawa ag tanang inra mga sinakupan ag mga ari-arian. ");
INSERT INTO bno_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Pagkapalayas sa inra ni Paraon ay naghalin sina Abram sa Ehipto kaibahan kag ida asawa, kag ida tanang sinakupan, kaibahan ra si Lot nak ida kumangkon, ag nagbalik sinra sa disyerto it Negeb. ");
INSERT INTO bno_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ngasing, si Abram ay naging manggaranoney. Inggwa sida it maramong mga alagang hadop ag maramong pilak ag buyawan. ");
INSERT INTO bno_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Halin sa Negeb, nagpadayon gihapon sina Abram it pagsaydo-saydo pa-norte. Nagpatukar sinra hastang makaabot ray sinra sa dati ninrang istaran sa tunga it Betel ag Ai. ");
INSERT INTO bno_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ag hagto pa ra katong ida inghuman nak altar nak bato ag ruto ay nagdayaw si Abram sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Si Lot nak nunot-nunot kang Abram ay inggway ra it maramong mga karnero, kambing ag baka, pati maramong suguon ag tolda. ");
INSERT INTO bno_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ag dahil subrang ramoey kag inra mga alagang hadop, indiey maghusto para sa inrang tanan kag sabsabon ag indiey sinra magkuntento pag sinra ay nagpipinisan. ");
INSERT INTO bno_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kada nag-aaway-away kag mga manug-alaga it mga hadop nina Abram ag Lot. It katong panahong kato kag mga Canaanhon ag mga Pereznon ay ruto ra giiistar. ");
INSERT INTO bno_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kada, nagsiling si Abram sa ida kumangkon nak si Lot, “To, indi kita dapat mag-away, pati kag ato mga suguon dahil kita'y maghali. ");
INSERT INTO bno_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","To, muyati kag kayaparan it kaling duta. Mabuyag kita, ag mapili ka it imo gustong pagtuan. Kung gusto nimo nak magpagto sa wala ay mapagto ako sa tu-o, pero kung gusto nimo nak mapagto sa tu-o ay mapagto ako sa wala.” ");
INSERT INTO bno_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nagmuyat si Lot sa palibot ag nakita nida kag patag sa ubos nak asa tunga it mga baguntor kung hariin kag Suba it Jordan. Kag patag nak kali ay abot hastang sa Zoar. Ag nakita nida nak kali ay bugana sa tubi, nak pay tuyar sa Eden, o pay naambit ra sa duta it Ehipto. Kali ay it katong waya pa nasira-a it GINO-O kag mga syudad it Sodoma ag Gomora. ");
INSERT INTO bno_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kada gingpili ni Lot para sa ida sarili kag tanang patag it Jordan ag nag-us-osey sida pa-subatan. Tuyar kali kag pagbinuyagan ni Abram ag ni Lot. ");
INSERT INTO bno_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Si Abram ay nagpabilin sa duta it Canaan ag si Lot ay nagpadayon sa pagsaydo-saydo mayungot sa mga banwa rutong patag hastang makaabot mayungot sa Sodoma, kung hariin nida ingtukor kag inra mga istaran nak tolda. ");
INSERT INTO bno_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","It kato kag mga tawo sa Sodoma ay abang yain kag pagpangabuhi ag nagpapaka-sala pa sinra sa atubangan it GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","It katong nakahaliney si Lot, nagsiling kag GINO-O kang Abram, “Muyati kag imo palibot, tuna sa inghahalinan it hangin nak amihan, papagto sa subatan, papagto sa habagatan, hastang sa sugbuhan kung hariin kag ragat. ");
INSERT INTO bno_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tanang duta nak imo nakikita ay ita-o Nako sa imo ag sa imo mga inanak hastang sa katapusan. ");
INSERT INTO bno_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aparamuon Nako kag imo mga inanak hastang indiey kayang bilangon. Kung paunong kag taybo sa duta ay indi kayang bilangon ay imaw ra kag imo magiging inanak. ");
INSERT INTO bno_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Hala, tinrog, baktasa ag muyatan kag kayaparan it kaling duta, dahil ita-o nako kali sa imo.” ");
INSERT INTO bno_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kada ingtuman matuor ni Abram kag sugo it GINO-O ag nagsaydo-saydo sinra hastang nakaabot sinra ruto sa lugar nak inggwa it mga maragkong pananom nak kahoy it usang Amornon nak si Mamre. Kato ay mayungot sa banwa it Hebron. Ag sa lugar ni Mamre nagtukor ray sinra it mga istaran nak tolda ag naghuman ray sida it altar para sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","It katong si Lot ay nag-iistar sa Sodoma, ay imaw kag kapanahunan it mga pinunong hari nak sina Amrapel it Sinar, Arioc it Elasar, Kedorlaomer it Elam, ag Tidal it Goyim. ");
INSERT INTO bno_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","3","Nagkausa sinra ag inra inglabanan sina: Haring Bera it Sodoma, Haring Birsa it Gomora, Haring Sinab it Adma, Haring Semeber it Zeboyim ag Hari it Bela nak tong huli ay naging Zoar. Ruto sinra naggera sa kapatagan it Sidim mayungot sa Minatay nak Ragat. ");
INSERT INTO bno_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Imaw kali kag tanang natabo. Sa suyor it doseng tuig kaling inra mga kakampi nak mga hari it Sodoma ag Gomora ay asa irayom it gahom it usang pinunong hari nak si Kedorlaomer. Pero pag-abot it ika-treseng tuig ay naglaban sinra sa ida. ");
INSERT INTO bno_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","6","Ag pag-abot ray it ika-katorseng tuig sina Haring Kedorlaomer ag ida mga kakampi nak mga hari ay nagyusob, ag napirde ninra ag nabihag: kag mga Repaimnon sa Astarot-carnaim, kag mga Zuzimnon sa Ham, kag mga Emimnon sa Save-kiryataim ag kag mga Horhanon sa mga bukir it Seir. Nakaabot sinra hastang sa El-paran sa habig it disyerto. ");
INSERT INTO bno_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Pagkatapos ay nagbalik sinra ag nagpadayon sa pagpirde ag pagbihag sa mga taga-Enmispat nak tong huli ay naging Kades, sa mga nag-iistar sa patag nak tong huli ay naging duta it mga Amaleknon, ag sa mga Amornon sa Hazazon-temar. Ag nakaabot sinra hastang sa kapatagan it Sidim. ");
INSERT INTO bno_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ngasing, katong mga kakampi nak hari it Sodoma, Gomora, Adma, Zeboyim ag Bela nak naging Zoar, ay pumangyusob sa kapatagan it Sidim ag ruto sinra naggera ");
INSERT INTO bno_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","laban kana: Haring Kedorlaomer it Elam, Haring Tidal it Goyim, Haring Amrapel it Sinar ag Haring Arioc it Elasar. Ap-at nak hari laban sa limang hari. ");
INSERT INTO bno_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ruto sa kapatagan it Sidim inggwa't maramong tubog it ispalto nak delikadong mahuyugan. Habang katong mga kakampi it Sodoma ag Gomora ay nagtatakas, kag iba ay nahuyog ruto ag kag mga nabilin ay nagrinayagan ag nagtago sa mga bukir. ");
INSERT INTO bno_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ngani, ing-ubos it baoy it mga nagraog nak sina Haring Kedorlaomer kag mga butang ag mga pagkaon nak inra nakita sa Sodoma ag Gomora ag nagpadayoney sinra papauli sa inra. ");
INSERT INTO bno_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kaibahan sa mga gingbihag ninra ay si Lot nak kumangkon ni Abram nak nag-iistar sa Sodoma, kaibahan ra kag ida pamilya, mga sinakupan ag kag inra mga ari-arian. ");
INSERT INTO bno_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Inggwa't usang bihag nak nakabuhi ag nagbalik kali agor mag-uma kang Abram nak Hebreo tungor sa natabo kana Lot. It kato, si Abram ay nag-iistar gihapon ruto sa inggwa't mga maragkong pananom nak kahoy ni Mamre nak Amornon, ag hali nina Escol ag Aner. Sinra ay mga kakampi ra ni Abram. ");
INSERT INTO bno_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Pagkarungog ni Abram nak kag ida kumangkon ay nabihag, ay ida gingpanguyuhan kag ida mga tawuhan nak ida natudluan sa paglaban. Sinrang tanan ay tres syentos ag disi-otso (318) katawo nak tanan ay ging-anak sa ida sinakupan, ag inra inglahay kag mga hari nak nagbihag kana Lot, hastang sa lugar it Dan. ");
INSERT INTO bno_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tong rutoy sinra sa Dan, ida ingparti-parti kag ida mga tawuhan. Ag pag-abot it gab-i ay nagyusob sinra ag inra napirde kag mga sundalo it inra kalaban nak mga hari. Ingpangtabog ag inra ingpanglahay sinra hastang sa Hoba nak asa unhan pa it syudad it Damasco. ");
INSERT INTO bno_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Gingbawi nina Abram kag tanang mga ari-arian nak nabaoy nina Haring Kedorlaomer. Gingbawi ra nida kag ida kumangkon nak si Lot ag kag pamilya ag mga sinakupan it kali, pati ra kag mga kabade ag iba pang mga bihag. ");
INSERT INTO bno_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Sa pagbalik nina Abram sa inra pagkapirdi kana Haring Kedorlaomer ay gingsapoy sinra it hari it Sodoma ruto sa Patag it Save nak nagsubli (tong huli kali ay naging Patag it Mga Hari). ");
INSERT INTO bno_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Inggwa it Hari sa Syudad it Salem nak kag ngayan ay si Melkisedec, ag sida ra kag saserdote it Pinaka-mataas nak Dios. Nagsapoy-sapoy sida kana Abram ag ingray-an sinra it tinapay ag ayak. ");
INSERT INTO bno_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ingbendisyunan nida si Abram sa pagsiling, “Ikaw Abram ay ingpakamaado it Dios, nak imaw kag Pinaka-mataas. Kag langit ag duta ay Sida kag Nagtuga. ");
INSERT INTO bno_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Pinaka-mataas nak Dios, ato ra adayawon, sa mga kaaway, sa imo'y nagparaog!” Ag ingbuyag ni Abram kag ika-sampuyong parti it tanang ida nabawi ag ingta-o kang Haring Melkisedec. ");
INSERT INTO bno_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nagsiling kag Hari it Sodoma kang Abram. “Imo yangey kinang tanang butang nak imo nasamsam, pero ulian sa ako kag tanang ako tawuhan.” ");
INSERT INTO bno_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Nagsabat si Abram sa hari, “Nakataas kag ako damot nak nagsusumpa sa atubangan it GINO-O, nak imaw kag Pinaka-mataas nak Dios, Dios nak Tag-iya it Langit ag Duta, ");
INSERT INTO bno_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nak inding gador ako magbaoy maski bunang o sab-it it tsinelas o miski ni-o nak sa imo, agor indi nimo masiling nak, ‘Ako gingpayaman si Abram.’ ");
INSERT INTO bno_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Inding gador ako magbaoy it para sa ako sarili, purya sa mga nakaon it ako sinakupan ag sa parti ninra. Bahala sina Aner, Escol ag Mamre nak magbaoy it inra parti.” ");
INSERT INTO bno_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Pagkatabo it mga bagay nak kali, nagbisaya kag GINO-O kang Abram sa parayan it usang pangitaon, “Abram, aya gikahadlok, dahil Ako kag imo panagang ag Ako ka ataw-an it marakong premyo.” ");
INSERT INTO bno_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Pero nagsabat si Abram, “O GINOONG Dios, ni-o kag puyos it Imo maitata-o sa ako dahil waya pa gihapon ako it anak? Ag kag mapanubli yang it kali ay kag ako sugu-on nak si Eliezer nak taga-Damasco. ");
INSERT INTO bno_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Waya ra Nimo ako gitaw-e it anak, kada kaling usa yangey sa ako mga suguon kag ako manugpanubli.” ");
INSERT INTO bno_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Nagsabat kag GINO-O, “Buko kaling imo suguon kag manugpanubli nimo. Ikaw ay magkakainggwa it manugpanubli nak halin mismo sa imo rugo.” ");
INSERT INTO bno_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ag ingpasyar si Abram it GINO-O sa liwas ag nagsiling, “Tanga baga sa langit, ag bilangon kag mga bituon kung kaya nimo. Kag imo magiging mga inanak ay tuyar it ramo.” ");
INSERT INTO bno_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Si Abram ay nagtu-o nak gador sa GINO-O, ag dahil dili sida ay gingbilang nak matarong. ");
INSERT INTO bno_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nagbisaya pa kag GINO-O sa ida, “Ako kag GINO-O nak nagraya sa imo rili halin ruto sa imo banwa it Ur sa Caldeya, pramas ita-o sa imo kaling duta.” ");
INSERT INTO bno_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Nagpangutana si Abram, “O GINOONG Dios, pauno nako masasaduran nak magiging ako kali?” ");
INSERT INTO bno_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nagsabat kag GINO-O, “Hala, ray-i ako it usang rumayagang baka, usang rumayagang kambing, ag usang kayaking karnero nak bawat usa ay tigtatatlong tuig kag edad, ag ray-i ra ako it usang bato-bato ag usang bata pa nak salumpati.” ");
INSERT INTO bno_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ingbaoy ag ingraya matuor ni Abram kaling tanan nak gingsiling it GINO-O sa ida. Ingpang-ihaw ag ingpangbika nida kali bag-o ingpatungor kag magkasi-si, purya sa mga pispis nak waya gitunga-a. ");
INSERT INTO bno_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","It katong inggwa't naghugpa nak mga pispis nak nagpapangragit ruto sa ingpatungor nak magkasi-si ay ingpangbugaw kali ni Abram. ");
INSERT INTO bno_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tong pasugbuhoney kag adlaw, nakatuyugan it pamuok-muok si Abram, ag nabatyagan nida kag rakong kahadlok ag nalibon sida it karuymanan. ");
INSERT INTO bno_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ngasing, nagsiling kag GINO-O sa ida, “Gingpapasador nak gador Nako sa imo nak kag imo mga inanak ay mapagto ag madayon ruto sa lugar nak buko inra. Madayon sinra ruto sa suyor it kwatro syentos (400) nak tuig ag sinra ay magiging ihig ag ulipon. ");
INSERT INTO bno_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pero aparusahan Nako katong nasyon nak maihig sa inra ag pagkatapos, sinra ay mahalin ruto nak maramong raya. ");
INSERT INTO bno_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","“Ngani marayan anay kag pang-ap-at nak balhin it linahi it imo mga inapo bag-o mabalik sinra dili. Kali ay dahil indi pa Nako gipahalinon dili kaling mga Amornon, kumo buko pa subrang ramo kag inra mga sala pramas Ako sinra parusahan. Tuyar kina kag matabo sa inro mga inanak, pero para sa imo, Abram, apahabaon Nako kag imo kabuhi nak inggwa't kasadya, bag-o ka Nako bay-on agor magpahuway kapisan kag imo ginikanan.” ");
INSERT INTO bno_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Pagkasugbo it adlaw ag maruyomey ay nakabati si Abram ag nakita nida nak nagrayan kag usang pugon nak nag-aaso ag nagrarayab-rayab nak inggwa it suyo sa tunga it mga ing-ihaw nak hadop nak mga tig-kasi-si. ");
INSERT INTO bno_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Katong adlaw nak inghimo it GINO-O kag Ida kasugtanan kang Abram ay napasiling Sida, “Sa imo inanak, ita-o Nako kaling duta tuna sa Suba it Ehipto papagto sa marakong Suba it Yuprates. ");
INSERT INTO bno_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kaumir kag duta it mga Cenanhon, mga Cenisnon, mga Cadmonhon, ");
INSERT INTO bno_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","mga Hetanhon, mga Pereznon, mga Repaimnon, ");
INSERT INTO bno_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","mga Amornon, mga Canaanhon, mga Girgasanhon ag mga Jebusnon.” ");
INSERT INTO bno_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ngasing, kaling si Saray nak asawa ni Abram ay waya gihapon nakakaanak sa ida. Inggwa sida it sariling kabulig nak kabade nak kag ngayan ay si Hagar nak taga-Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Nagsiling si Saray kang Abram, “Dahil waya ra gibut-a it GINO-O nak magkainggwa ako it anak, ni-o ara kung mag-ubay ikaw sa ako kabulig, sabaling sida ay magkaanak ag parayan sa ida magkainggwa ra ako it anak.” Ag si Abram ay nagsugot sa ingsiling it ida asawa. ");
INSERT INTO bno_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kada gingta-o ngani ni Saray kag ida kabulig nak si Hagar nak usang Ehiptohanon kang Abram agor maging usa sa ida asawa. Kali ay natabo pagkatapos it sampuyong tuig it pag-istar nina Abram sa duta ni Mamre sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ing-ubayan nida si Hagar ag nagsabak kali. It katong maayaman ni Hagar nak sabakey sida ay gingpamidungan nida si Saray nak ida amo. ");
INSERT INTO bno_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ngasing, gingbasoy ni Saray si Abram, “Sala nimo kung asing ingpamidungan ako it ako kabulig! Ingta-o nako sida sa imo, pero it katong naayaman nida nak sida ay sabak gingpamidungan nida ako. Bahala kag GINO-O maghusgar kung sin-o sa ato kag tama ag buko.” ");
INSERT INTO bno_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Nagsabat si Abram kang Saray, “Bahala ikaw kung ni-o kag imo gustong himuon sa imo kabulig.” Kada ingpahirapan ag gingpintasan ni Saray kag ida kabulig ag kali ay naglayas. ");
INSERT INTO bno_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nakaabot si Hagar ruto sa tuburan sa disyerto papagto sa sur, ag nakita nida ruto kag anghel it GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Siling it kali sa ida, “Hagar, kabulig ni Saray, hariin ka gihalin ag pariin ikaw?” Nagsabat si Hagar, “Naglayas ako sa ako amo nak si Saray.” ");
INSERT INTO bno_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Siling ray it anghel it GINO-O, “Magbalik ka sa imo amo! Magpaubos ka sa ida! ");
INSERT INTO bno_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ag aparamuon Nako kag imo inanak hastang indiey mabilang sa karamuon. ");
INSERT INTO bno_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kaling anak nak imo ingsasabak ay kayake. Pangayani sida nak Ismael, dahil ingrungog it GINO-O kag imo pag-ayaba sa imo kahirapan. ");
INSERT INTO bno_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Sida ay magiging tuyar sa usang maila nak asno nak perming laban sa tanan ag kag tanan ay laban sa ida. Magiging kuntra sida sa ida kahalihan.” ");
INSERT INTO bno_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Gingtawag ni Hagar kag GINO-O nak nagbisaya sa ida nak “Dios nak Nakakakita,” dahil sa ida pagkatingaya ay napasiling sida nak, “Buhi pa baga ako? Nakita baga talaga nako kag GINO-O nak nakakita ra sa ako?” ");
INSERT INTO bno_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Imaw kato kung asing gingtawag kaling tuburan sa tunga it Kades ag Bered nak Beer-lahay-roy nak kag gustong bisayahon ay “Tuburan it Nakakita ag Nabuhi.” ");
INSERT INTO bno_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Pagkatapos, nagpauli si Hagar kana Saray ag nag-anak sida it kayake nak ingpangayanan nida nak Ismael. ");
INSERT INTO bno_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Si Abram ay otsentay sais (86) anyos it katong ing-anak ni Hagar si Ismael sa ida. ");
INSERT INTO bno_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Pag-abot ni Abram sa edad nak nobentay-nwebe (99) anyos, kag GINO-O ay nagpakita sa ida ag nagsiling, “Ako kag Dios nak Makagagahom, magpangabuhi ka it matarong sa ako atubangan. ");
INSERT INTO bno_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Atumanoney Nako kag ako kasugtanan sa imo ag aparamuon nak gador nako kag imo mga inanak.” ");
INSERT INTO bno_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kada nagpatirapa si Abram sa atubangan it Dios. Ag nagsiling pa kag Dios, ");
INSERT INTO bno_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Imaw kali kag Ako kasugtanan sa imo. Ikaw ay magiging tatay it maramong mga nasyon. ");
INSERT INTO bno_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tuna ngasing, bukoey Abram kag imo pangayan kundi ikaw ay atawagoney nak Abraham, dahil ahimuon ka Nako nak tatay it maramong mga nasyon. ");
INSERT INTO bno_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aparamuon nak gador Nako kag imo mga inanak agor magiging maramong mga nasyon, ag kag iba sa inra ay ahimuon Nako nak mga hari. ");
INSERT INTO bno_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Atuparon nako kag Ako kasugtanan sa imo, ag sa imo magiging mga inanak kaumir kag kahuli-hulihan nak balhin it inra linahi hastang sa waya't katapusan, ag Ako kag magiging Dios nimo, ag it imo mga inanak. ");
INSERT INTO bno_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ita-o Nako sa imo ag sa imo magiging mga inanak kaling bug-os nak duta it Canaan kung hariin ikaw ay nagtitiner. Tanan kali ay mapapasa-inro hastang sa waya't katapusan ag Ako kag magiging Dios nimo, ag it imo mga inanak.” ");
INSERT INTO bno_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ag nagsiling pa kag Dios kang Abraham, “Para sa imo, Abraham, ikaw ag imo magiging mga inanak kaumir kag kahuli-hulihang balhin it inra linahi, ay dapat ra nak magtuman it Ako kasugtanan. ");
INSERT INTO bno_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Imaw kali kag inro dapat himuon sa pagtuman it Ako kasugtanan sa imo ag sa imo magiging inanak. Kag tanang kayake sa inro ay dapat nak tulion. ");
INSERT INTO bno_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Tumana ninro kali bilang tanra it Ato kasugtanan. ");
INSERT INTO bno_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Pag-abot it pangwayong adlaw matapos matawo kag bawat anak ninro nak kayake, sida ay dapat tulion. Imaw kali kag inro ahimuon sa tanang inanak ninro nak kayake hastang sa kahuli-hulihang balhin it inro linahi. Atulion ninro sinra kung sinra ay matawo sa inro pamilya, ag sa inro sinakupan o miskin sinra ay mga ulipon nak inro ingbakay sa mga taga-ibang lugar. ");
INSERT INTO bno_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Dapat nak parehong tulion kag mga kayake nak ianak it inro mga sinakupan, ag mga kayake nak inro ingbakay. Imaw kali kag tanra it Ako waya't katapusang kasugtanan sa inro yawas. ");
INSERT INTO bno_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kung sin-o mang kayake kag indi magpatuli ay dapat nak iitsapuyra sida sa imo lahi, dahil gingsuway nida kag Ako kasugtanan.” ");
INSERT INTO bno_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nagsiling ray kag Dios kang Abraham, “Ngasing kaling imo asawa nak si Saray ay indiey nimo gitawagon nak Saray, kundi Sara. ");
INSERT INTO bno_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Apakamaaduhon Nako sida, ag ataw-an nak gador Nako ikaw it anak sa ida. Apakamaaduhon Nako sida ag sida ay magiging nanay it mga nasyon, ag kag ibang mga inanak nida ay magiging mga hari.” ");
INSERT INTO bno_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Pagkarungog it kali ni Abraham ay napayukso sida ag diretso yuhor ag pumakaguya. Napasiling sida sa ida sarili, “Makakaanak pa ara kag kayake nak nag-iidad it usang gatos (100) nak tuig? Maanak pa ara si Sara nak nag-iidad it nobentang (90) tuig?” ");
INSERT INTO bno_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ag nagsiling sida sa Dios, “Kabay pang si Ismael kag Imo pakamaaduhon ag imaw kag mapanubli it ako tanang ari-arian!” ");
INSERT INTO bno_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Sabat it Dios, “Indi ra Nako sida gipabad-an, pero si Sara nak imo asawa ay magkakaanak nak gador sa imo it anak nak kayake, ag apangayanan nimo sida nak Isaac. Atuparon Nako kag Ako waya't katapusang kasugtanan sa ida, ag sa ida magiging mga inanak. ");
INSERT INTO bno_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“Tungor kang Ismael, narunggan Nako kag imo pangamuyo, kada apakamaaduhon ra nako sida ag aparamuon nak gador Nako kag ida magiging mga inanak. Magiging tatay sida it doseng mga pinuno ag imaw ra sida it magiging tatay it usang bantog nak lahi. ");
INSERT INTO bno_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pero kang Isaac nak gador, nak ianak ni Sara sa tuyar rang panahon sa masunor nak tuig, ay Ako atuparon kag Ako kasugtanan.” ");
INSERT INTO bno_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Pagkatapos nagbisaya kag Dios kang Abraham ay nawagit kali sa ida atubangan. ");
INSERT INTO bno_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","It katong adlaw nak kato, ingnunot ni Abraham kag ida anak nak si Ismael ag ingtipon nida kag tanang kayake sa ida sinakupan, pati kag mga ing-anak sa inra ag kag mga ulipon nak ingbakay. Sinrang tanan ay ida ingtuli, kumporme sa sugo it Dios sa ida. ");
INSERT INTO bno_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Si Abraham ay nag-iidad it nobentay-nwebe (99) anyos ag kag ida anak nak si Ismael ay nag-iidad it trese (13) anyos it katong sinra ay ingtuli. ");
INSERT INTO bno_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","It katong adlaw rang kato gingtuli si Abraham ag kag ida anak nak si Ismael, ");
INSERT INTO bno_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ag kag tanang kayake nak natawo sa ida sinakupan, pati kag tanang kayaking ulipon nak ida ingbakay sa taga-ibang lugar. ");
INSERT INTO bno_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","It katong nag-iistar pa si Abraham ruto sa inggwa't maragkong kahoy kana Mamre, usang adlaw nagpakita sa ida kag GINO-O. Dahil mainit pa kag adlaw, nag-iingkor si Abraham sa atubangan it pasuyuran it ida istaran nak tolda. ");
INSERT INTO bno_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Pagmuyat nida sa unahan ay nakita nida kag tatlong kayake nak nagtitinrog. Pagkakita nida sa inra, sida ay nagrali-rali it tulay ag nagrayagan agor magsapoy sa inra, ag sida ay nagsuong ag nagsiling, ");
INSERT INTO bno_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Mga Gino-o, kung apaburan ninro ako ay rayan anay kamo dili sa amo. ");
INSERT INTO bno_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mapabaoy ako it tubi para panghinaw it inro siki bag-o kamo magpahuway raha sa nasisinrungan it kahoy. ");
INSERT INTO bno_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ag mahanra ako it aber maisot yang nak inro makakaon agor makakamerienda anay kamo bag-o kamo magpadayon. Haley rang gador kamo, hanra ako nak serbisyuhan kamo.” Nagsabat kag usa sa inra nak imaw kag GINO-O, “Ay di sige, ag salamat nak gador.” ");
INSERT INTO bno_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ag si Abraham ay nagrali-rali it suyor sa ida tolda, ag nagsiling kang Sara, “Tulina, masa it pinong arina nak kuyang-kuyang usang sako, ag humana kali nak tinapay.” ");
INSERT INTO bno_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Masunor, nagrayagan sida papagto sa ida mga baka ag nagpili it usang mataba ag bata pa nak turete, ag ida ingpaihaw ag ingpayuto sa ida kabulig. ");
INSERT INTO bno_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ag nagbaoy ra sida it pinakurta nak gatas, ag gatas nak presko, ag kaibahan katong tinapay ag suya nak baka ay ingraya kali nida ruto sa irayom it kahoy nak ingpapahuwayan it ida mga bisita ag ingtahaw sa inra atubangan. Habang nagkakaon sinra ay ruto ra si Abraham nak hanrang serbisyuhan sinra. ");
INSERT INTO bno_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nagpangutana kag GINO-O, “Hariin kag imo asawa nak si Sara?” Nagsabat si Abraham, “Hina sa suyor it tolda.” ");
INSERT INTO bno_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ag nagsiling ray kag GINO-O, “Sigurado nak Ako ay mabalik sa inro sa tuyar ra it kaling panahon sa masunor nak tuig ag si Sara ay maanak it usang kayake.” Habang si Sara ay asa suyor it tolda mayungot sa pasuyuran nak asa inra likor, sida ay nagpapanimati habang sinra ay nagbibisaya. ");
INSERT INTO bno_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Si Abraham ag si Sara ay parehong abang guyangey ag si Sara ay wayaey giaabuta. ");
INSERT INTO bno_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kada napaguya si Sara sa ida sarili ag napasiling, “Sa kaguyangon namong kali ay masasadyahan pa ara ako nak mag-ubay sa ako asawa? Maguyangey kami para magkainggwa it anak!” ");
INSERT INTO bno_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ag nagpangutana kag GINO-O kang Abraham, “Asing napaguya si Sara ag napasiling nak, ‘Maanak pa ara ako ngasing nak ako'y maguyangey?’ ");
INSERT INTO bno_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Inggwa baga it indi kayang humanon kag GINO-O? Sa panahon nak Ako ingsiling, pagkalipas it usang tuig sa tuyar ra it kaling panahon, mabalik Ako sa inro ag si Sara ay maanak it usang kayake.” ");
INSERT INTO bno_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Dahil sa kahadlok ni Sara, sida ay nagbalibar ag napasiling, “Waya po ako giguya ay!” Siling ray it GINO-O, “Bad-ey gibalibar! Nagguya ka!” ");
INSERT INTO bno_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Pagkatapos, nagginaney katong tatlong kayake papaagto sa Sodoma ag inghator sinra ni Abraham sa rayan. ");
INSERT INTO bno_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Bag-o sinra nagbinuyagan ay nagsiling kag GINO-O, “Ataguon baga Nako kang Abraham kag Ako ahimuon, ");
INSERT INTO bno_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","kumo sida kag magiging tatay it bantog ag makusog nak nasyon, ag parayan sa ida kag tanang katawuhan sa mga nasyon ay makakabaton it pagpakamaado? ");
INSERT INTO bno_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Indi! Indi Nako kali gitaguon sa ida dahil sida kag Ako ingpili, agor atudluan nida kag ida mga anak ag mga panimayay nak magsunor sa Ako sa inra pagpangabuhi it matarong, pramas atumanon Nako kag Ako ingpromisa sa ida.” ");
INSERT INTO bno_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ag nagsiling kag GINO-O kang Abraham, “Narunggan Nako kag maramong reklamo it mga tawo laban sa subrang pagpakasala it mga taga-Sodoma ag Gomora. ");
INSERT INTO bno_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kada ngani maus-os Ako agor usisaon kung talagang matuor kato o buko.” ");
INSERT INTO bno_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ag katong ruhang kayake nak kaibahan it GINO-O ay nagpadayoney papagto sa Sodoma, pero si Abraham ag kag GINO-O ay nagruruyog pa habang nag-iistoryahan. ");
INSERT INTO bno_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ag nagpayungot it maado si Abraham sa GINO-O ag nagpangutana, “Mamamatay baga kag mga maadong tawo kaibhanan kag mga makasal-anan pag Imo asiraon katong syudad? ");
INSERT INTO bno_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kung inggwa ruto it singkwentang (50) tawo nak maado, asiraon pa baga gihapon Nimo katong syudad? O akaluy-an Nimo dahil ruto sa singkwenta? ");
INSERT INTO bno_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Indi ako gipati nak amatyon Nimo kag mga maadong tawo kaibhanan kag mga makasal-anan! Dahil kung tuyar kina, ay dey pareho kag parusa it maadong tawo ag buko! Buko Ikaw tuyar. Di baga Ikaw kag Hukom it tanang katawuhan sa kalibutan ag mahusgar it matarong?” ");
INSERT INTO bno_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nagsabat kag GINO-O, “Kung inggwa Ako it makita nak singkwentang (50) tawo nak maado sa Sodoma, indi Nako kato gisiraon alang-alang ruto sa singkwenta.” ");
INSERT INTO bno_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Nagsiling ray si Abraham, “GINO-O, patawara ako sa ako pagbisaya sa Imo dahil ako ay waya't karapatan, kumo ako'y usang tawo yang. ");
INSERT INTO bno_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ay kung kag singkwentang maadong tawo ay kuyang it lima, asiraon baga gihapon Nimo kag tanan nak tawo ruto dahil kuyang sinra it lima?” Nagsabat ray kag GINO-O, “Indi Nako kato gisiraon kung inggwa Ako it makita ruto nak kwarentay-singko (45) nak maadong tawo.” ");
INSERT INTO bno_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nagpangutana ray liwat si Abraham, “Ay kung inggwa ruto it kwarentang (40) maadong tawo?” Nagsabat ray kag GINO-O, “Indi Nako gisiraon kag syudad alang-alang ruto sa kwarenta (40).” ");
INSERT INTO bno_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Nagsiling ray si Abraham, “Kabay pa GINO-O nak indi Ka mahangit sa ako dahil indi nako mapunggan kag ako ibisaya sa Imo. Ay kung inggwa ray ruto it treynta (30) yang?” Nagsabat ray kag GINO-O, “Indi, alang-alang ruto sa treynta (30).” ");
INSERT INTO bno_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Nagsiling ray si Abraham, “GINO-O, patawara gihapon ako sa ako pagbisaya. Ay kung inggwa ray ruto it beynteng (20) maadong tawo?” Nagsabat ray kag GINO-O, “Indi, alang-alang ruto sa beynte (20) nak maadong tawo.” ");
INSERT INTO bno_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Sa huli ay nagsiling si Abraham, “Kabay pa GINO-O nak indi Ka mahangit sa ako, imaw yangey ra kali kag ako ibisaya sa Imo. Ay kung sampuyo (10) yangey kag maadong tawo ruto?” Ag nagsabat kag GINO-O, “Alang-alang ruto sa sampuyo (10), indi Nako gisiraon kag syudad.” ");
INSERT INTO bno_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Pagkasabat Nida it kali kang Abraham, naghaliney kag GINO-O ag nagpauli si Abraham. ");
INSERT INTO bno_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Pagkagab-i it katong adlaw nak kato ay nag-abot sa syudad it Sodoma katong ruhang anghel nak nagpatuyar sa hitsura it mga tawong kayake. Si Lot ay nag-iingkor ruto sa lugar nak ingtitipunan it mga maguyangey it Sodoma. Kaling lugar nak kali ay rapit sa pwertahan pasuyor sa syudad. Pagkakita nida sa ruhang kayake ay nagtulay sida ag sinra ay ida ingsapoy. Nagsuong sida sa inra atubangan, ");
INSERT INTO bno_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ag nagsiling, “Mga Gino-o, ako nak inro suguon, ay nagpapangabay sa inro nak kung puyde ay magrayan anay kamo sa bayay nako, ag ruto kamo magpalipas it gab-i, pramas makakapanghinaw kamo it inro mga siki. Insulip yangey kamo padayon sa inro pagpanaw.” Nagsabat sinra, “Salamat nak gador, pero rili yang kami mapalipas it gab-i.” ");
INSERT INTO bno_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pero dahil sa kapipilit ni Lot sa inra ay nagnunot yangey sinra sa ida bayay. Ag nagpayuto sida it suya ag tinapay nak waya't pampaalsa, ag ingpakaon sinra it maado. ");
INSERT INTO bno_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bag-o sinra makakatuyog, ay gingpalibutan kag bayay ni Lot it tanang mga kayake sa Sodoma, mga maguyang ag mga binata. ");
INSERT INTO bno_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ag nag-inukaw sinra, “Hariin katong mga kayaking bisita nimo? Paliwasa sinra dili agor amo aubayan.” ");
INSERT INTO bno_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Nagliwas si Lot ag ingsarhan nida kag ida pwertahan, ");
INSERT INTO bno_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ag nagpakitluoy sida, “Mga kasimanwa, nagpapangabay ako sa inro nak daey ra ninro giulita kaling ako mga bisita. Abang yain kaling inro ahimuon! ");
INSERT INTO bno_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Inggwa ako rili it ruhang anak nak rayagang birhen, sinra yangey kag ako ita-o sa inro, ag himu-a ninro sa inra kung ni-o kag inro gusto. Basta indi yang ninro giunhon kaling mga kayake dahil sinra ay bisita nako ag dapat nako sinrang protektahan.” ");
INSERT INTO bno_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Pero nagsiling sinra, “Halin raha! Buko ka taga-rili, sin-o ka para maghusgar sa amo! Mahalin ka o indi? Ahapruson ka namo it subra pa sa amo ahimuon sa imo mga bisita!” Ag ingsiog ninra si Lot papayungot sa pwertahan agor asiraon tan-a ninra kato. ");
INSERT INTO bno_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pero ging-abrihan it maisot it kaling ruhang bisita kag pwertahan ag ingbira pasuyor si Lot bag-o kali ingsarhan. ");
INSERT INTO bno_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Pagkatapos, kinang tanang mga tawo sa liwas ay ingbulag it kaling ruhang bisitang anghel, kada nagpanghaphap yangey sinra sa paghanap it katong pwertahan, hastang tong huli ay nagsawa yangey sinra. ");
INSERT INTO bno_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Ngasing, nagsiling kaling ruhang bisita kang Lot, “Inggwa pa baga ikaw it mga hali rili? Kung inggwa pa ikaw it mga anak ag mga umagar, uma-e sinra nak ingparaya kami it GINO-O agor siraon kaling syudad, dahil sa subrang reklamo it mga tawo laban sa kayainan it mga taga-dili. Nuntan sinra ag maghalin kamo rili.” ");
INSERT INTO bno_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kada, ingpagtuan ni Lot kag mga sultero nak nakapamayadey sa ida mga anak nak rayaga ag nagsiling sida sa inra, “Maghanraey kamo ngasing! Rali-a! Mahalin kita dahil asiraoney it GINO-O kaling syudad.” Pero kabi ninra ay nagpapangintrimis yang si Lot, kada waya sinra gipati sa ida. ");
INSERT INTO bno_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","It katong nagpapanghudag-hudagey ay ing-apura it kaling ruhang anghel sina Lot sa pagsiling, “Bati kamo! Tulinay, haliney kamo rili kaibahan kag imo asawa ag ruhang mga anak nak rayaga, agor indi kamo maumir sa parusa hali sa Sodoma.” ");
INSERT INTO bno_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ugaling ay nagruruyog-ruyog pa si Lot, kada sa kaluoy it GINO-O ay inggudor pa sinrang ap-at it kaling ruhang anghel paliwas sa syudad. ");
INSERT INTO bno_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","It katong asa liwasey sinra, nagsiling kag usang anghel. “Rayagan kamo, agor indi kamo mamatay. Ayang gador kamo gisauli o gitungon dili sa patag. Rayagan kamo hastang makaabot nak gador ruto sa baguntor, agor indi kamo maumir sa matatabo.” ");
INSERT INTO bno_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Pero nagsabat si Lot, “Mga Gino-o, buko yangey ruto sa baguntor. ");
INSERT INTO bno_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Naging maado kamo sa ako ag karako kag inro nabulig sa ako, kada rako kag ako pagpasalamat nak inro kami ingluwas. Pero kung maaari, nagpapangabay ako sa inro, abang yado ra katong baguntor. Sabaling indiey ako makaabot ruto ag maabutan ra gihapon kami it parusa ag ako ay mamatay gihapon. ");
INSERT INTO bno_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Inggwa raha-o sa uibabaw it usang maisot nak banwa, puyde ara nak ruto yangey kami mapagto agor buko masyarong yado. Ruto yangey kami hah! Maisot yang kato ag indi kami ruto mauno.” ");
INSERT INTO bno_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nagsabat kag anghel, “Hala, mapahinunor ako sa imo, ag indi nako gisiraon katong banwa nak imo gingsisiling. ");
INSERT INTO bno_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tulina, pagtoy kamo ruto dahil waya pa kami it mahihimo hastang waya pa kamo nakakaabot ruto.” Kada tong huli, ingpangayanan katong banwa nak ingpagtuan nina Lot nak Zoar, nak kag gustong bisayahon ay “Maisot.” ");
INSERT INTO bno_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Nagsusubat pa yang kag adlaw pag-abot nina Lot sa Zoar. ");
INSERT INTO bno_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Pagkaabot ninra ruto, hingan pa yang gipauyana it GINO-O it mga nagbabagang bato, asupre ag kayado kag Sodoma ag Gomora. ");
INSERT INTO bno_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ag ingsira it GINO-O kag tanang banwa sa patag sa tunga it mga baguntor, kaibahan kag mga tawo, mga hadop ag tanang mga nagtutubo ruto sa duta. ");
INSERT INTO bno_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kag asawa ni Lot nak asa ida hulihan ay nagsauli ag sida ay naabutan it disgrasya. Kada sida ay naging tuyar sa haligi nak asin. ");
INSERT INTO bno_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","It katong parehong adlaw mismo maaga pa, ay nagpagtoy si Abraham sa lugar kung hariin sida gipangabay sa GINO-O parti sa Sodoma. ");
INSERT INTO bno_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nagmuyat sida sa ubos kung hariin kag Sodoma ag Gomora, ag kag patag. Imbes nak kag mga banwa kag ida nakita ay nakita nida kag nagpapaibabaw nak karuramoy nak aso nak pay naghahalin sa usang marakong pugon. ");
INSERT INTO bno_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Imaw kali kag natabo kung paunong nakalibre sina Lot sa pagsira it Dios sa mga banwa nak asa patag, dahil waya gilimti it Dios kag ida sabat sa mga pangabay ni Abraham. ");
INSERT INTO bno_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Pagkalipas it kato, nahadlok si Lot nak mag-istar sa Zoar, kada nagsaydo sinra it ida ruhang anak nak rayaga sa kabagunturan ag ruto sinra giistar sa usang kuyba. ");
INSERT INTO bno_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Katong marugayey, kag maguyáng nak anak ni Lot ay nagsiling sa ida manghor, “Maguyangey si Tatay, ag waya it mga kayake rili nak mapangasawa sa ato, kada indi kita magkainggwa't anak. ");
INSERT INTO bno_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Maado pa yanguhon nato si Tatay ag maubay kita sa ida, agor indi mawagit kag ato lahi.” ");
INSERT INTO bno_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kada ingyango ngani ninra kag inra tatay katong gab-ing kato. Ag tong yangoy si Lot, waya nida namalayi nak inubayan sida it katong ida maguyáng nak anak. Ag waya ra nida namalayi kag paghalin it kali. ");
INSERT INTO bno_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tong sumunor nak adlaw, nagsiling ray kag maguyáng sa ida manghor, “It gab-i ako kag nag-ubay kang tatay. Isag sa gab-i ay ayanguhon ray nato sida liwat, agor ikaw ray kag maubay sa ida tuyar sa ako inghimo, agor indi mawagit kag ato lahi.” ");
INSERT INTO bno_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kada ingyango ray ngani ninra kag inra tatay tong gab-i nak kato. Ag it tong yangoy si Lot, waya ray nida namalayi nak ing-ubayan ray sida it katong ida putong anak. Ag waya ra nida namalayi kag paghalin it kali. ");
INSERT INTO bno_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Dahil ruto, parehong nagsabak kaling ruhang anak nak kabade ni Lot sa ida. ");
INSERT INTO bno_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kag maguyáng nak anak ni Lot ay nag-anak it kayake ag ida kato gingpangayanan nak Moab. Ag sida kag naging tatay it mga Moabnon ngasing. ");
INSERT INTO bno_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kag puto nak anak ni Lot ay nag-anak ra it kayake ag ida kato gingpangayanan nak Ben-ami. Ag sida kag naging tatay it mga Amonhon ngasing. ");
INSERT INTO bno_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ngasing, naghalin si Abraham kana Mamre, ag nagsaydo-saydo papagto sa disyerto it Negeb, pero bag-o mag-abot ruto ay nag-istar anay sida sa Gerar sa tunga it Kades ag Sur. ");
INSERT INTO bno_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ag ruto sa banwa it Gerar, kag pakilaya ray ni Abraham kang Sara nak ida asawa ay ida manghor, kada ingpabaoy si Sara it inra hari nak ingtatawag ninrang Abimelec. ");
INSERT INTO bno_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Usang gab-i, nagbisaya kag Dios kang Abimelec sa parayan it pananamgo ag nagsiling, “Mamamatay ka, dahil kinang kabade nak si Sara nak imo ingbaoy ay inggway it asawa.” ");
INSERT INTO bno_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Kumo waya pa nauulit ni Abimelec si Sara, nagsiling sida, “Gino-o, waya ako it sala, mapangmatay baga Ikaw it inosenting tawo? ");
INSERT INTO bno_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Di baga si Abraham nak gador kag nagsiling sa ako nak si Sara kuno ay ida manghor. Aber sida ra ay nagsiling nak si Abraham kuno ay ida maguyáng. Inghuman kali nako nak malimpyo kag ako kunsensya ag waya ako it sala.” ");
INSERT INTO bno_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ag nagsabat kag Dios sa ida, “Oho, ayam Nako nak malimpyo kag imo kunsensya, kada ngani waya Nako gituguti nak imo sida uliton agor indi ka makasala laban sa Ako. ");
INSERT INTO bno_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ngasing, ulian kinang kabade sa ida asawa dahil kag ida asawa ay usang propeta Nako. Ag sida kag mapangamuyo para sa imo, agor indi ikaw mamatay. Pero kung indi nimo sida ig-uli, ingpapaunahaney ka Nako it siling, mamamatay nak gador ka, pati kag tanan nimo nak pamilya ag sinakupan.” ");
INSERT INTO bno_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kada ngani, pagkaaga, nagbangon it aga pa si Abimelec ag gingpatawag nida kag tanang ida sinakupan, ag ing-uma katong ida napananamguhan. Ag sinra'y nagkahadlok. ");
INSERT INTO bno_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Pagkatapos, gingpatawag ni Abimelec si Abraham, ag gingpangutana, “Ni-o kaling imo inghuman sa amo? Ni-o kag amo sala sa imo? Asing imo gingray-an kag ako gingharian it tuyar nak busong? Asing imo kali nahuman sa amo? Abang yain talaga kaling imo ginghuman! ");
INSERT INTO bno_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Asi, ni-o kag imo pagkasador sa amo hay?” ");
INSERT INTO bno_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Nagsabat si Abraham, “Kabi ngani nako ay wayang gador dili it di kahadlok sa Dios. Ag kabi nako, amatyon ninro ako pramas mabaoy ninro kag ako asawa. ");
INSERT INTO bno_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pero sa kamatuuran talaga sida ay ako manghor sa tatay, iba yang kag amo nanay, ag sida ay ako naging asawa. ");
INSERT INTO bno_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kada it katong gingsiling sa ako it Dios nak maghalin ako sa ako mga hali, agor magsaydo-saydo sa ibang mga lugar, gingtugon nako kang Sara nak aber hariin kami makaabot, kag ida isiling ay manghor nako sida.” ");
INSERT INTO bno_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Pagkatapos it bisaya ninra, ging-uli ni Abimelec si Sara sa ida asawa nak si Abraham, ag gingtaw-an nida si Abraham it mga karnero ag baka, ag mga kayake ag kabade nak ulipon bilang danyos sa ida inghimo. ");
INSERT INTO bno_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ag nagsiling pa sida kang Abraham, “Hali kag ako duta, pili yang kung hariin gusto nimong mag-istar.” ");
INSERT INTO bno_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Nagsiling ra sida kang Sara, “Ako ingtaw-an kag imo maguyáng it usang libong bilog nak pilak, bilang pamatuor sa atubangan it imo mga kaibahan ag tanang tawo, nak ikaw ay malimpyo gihapon, ag bilang danyos ra sa ako nahuman sa imo.” ");
INSERT INTO bno_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Pagkatapos it kali, ingpangamuyuan ni Abraham sina Abimelec, dahil tuna ingbaoy ni Abimelec si Sara ay ingpatungon it GINO-O kag pagsabak it tanang kabade sa ida pamilya ag panimayay. Pagkapangamuyo ni Abraham ay gingpaado it Dios kag asawa ni Abimelec ag tanang kabade sa ida panimayay sa inra pagtungon it pagsabak. Kada ngasing sinra ay nagkainggwa ray it abilidad nak magsabak. ");
INSERT INTO bno_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","It katong masunor nak tuig si Sara ay ingpakamaado it GINO-O ag sida ay nagsabak kumporme sa ingpromisa it GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ag sa panahon nak ingsiling it GINO-O, sida ay nag-anak it kayake kang Abraham, aber maguyangey sinra. ");
INSERT INTO bno_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ag kali ay ingpangayanan ni Abraham nak Isaac. ");
INSERT INTO bno_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Pagkalipas it wayong adlaw it pagkaanak kang Isaac ay ingtuli sida ni Abraham, kumporme sa sugo it Dios sa inra kasugtanan. ");
INSERT INTO bno_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","It katong si Isaac ay natawo, kag edad ni Abraham ay usang gatos (100) nak tuig. ");
INSERT INTO bno_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Si Sara ay nagsiling, “Gingpaguya ako it Dios ag tanang tawo nak makakasador it tungor dili ay mapapaguya ra. ");
INSERT INTO bno_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Hamak ninro, sin-o kag masiling kang Abraham nak si Sara ay makakapasuso pa it anak nida! Pero nataw-an gihapon nako sida it anak aber sida ay maguyangey.” ");
INSERT INTO bno_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nagrako si Isaac, ag it katong adlaw nak sida ay ging-utay, si Abraham ay nagta-o it usang rakong punsyon. ");
INSERT INTO bno_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Usang adlaw, nakita ni Sara nak ing-aagit-agit si Isaac ni Ismael nak anak ni Abraham kang Hagar nak Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kada nagsiling si Sara kang Abraham, “Palayasa kinang kabading ulipon, pati kag ida anak, dahil indi puyding kag ida anak ay magpanubli ra kaibahan kag ako anak nak si Isaac.” ");
INSERT INTO bno_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Waya kali nagustuhe ni Abraham ag kali ay mabug-at sa ida buot, dahil si Ismael ay ida ra anak. ");
INSERT INTO bno_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nagsiling kag Dios kang Abraham, “Aya gikalibog tungor sa imo anak ag sa ida nanay nak inro kabulig. Himu-a kag ingsiling sa imo ni Sara, dahil kang Isaac yang nak gador mahalin kag imo lahi nak maraya it imo pangayan. ");
INSERT INTO bno_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Pero kaling imo anak sa inro kabulig ay magiging usang nasyon ra, dahil sida ay imo ra anak.” ");
INSERT INTO bno_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Aga pa it katong masunor nak adlaw, ay ingtaw-an ni Abraham si Hagar it pagkaon ag tubi nak asa susudlan nak human sa anit it kambing ag kali ay ida ingsab-it sa ida abaga. Pagkatapos, ida'y ingpahalin si Hagar. Ag nagpalibot-libot sina Hagar ag Ismael sa mga mabatong mga bukir it Beerseba kung hariin ay bihira kag nag-iistar. ");
INSERT INTO bno_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","It katong marugayey naubusan sinra it tubi, ag si Ismael ay nagpangyuda nak pay mamamatayey, kada ingbutang sida ni Hagar sa sinrong it usang maisot nak puno. ");
INSERT INTO bno_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ingbilin nida kag ida anak ruto ag nagpayado sida nak kag yado ay usang tira it pana, ag sida ay nag-ingkor ruto. Habang sida ay nag-iingkor, sida ay nagtitibaw ag napasiling, “Indi nako makaya nak makita kag ako anak nak mamatay.” Ag habang naka-ingkor ruto si Hagar nak nagpapangalisor, ay sige ra kag tibaw ni Ismael. ");
INSERT INTO bno_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Narunggan it Dios kag pagtibaw ni Ismael, kada kag anghel it Dios ay nag-ayaba kang Hagar halin sa langit, “Hagar, ni-o kag imo problema? Aya gikalibog dahil narunggan it Dios kag tibaw it imo anak rutu-o. ");
INSERT INTO bno_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tulay, payungute kag imo anak ag pahilumon sida, dahil indi sida mamatay ag Ako sida ahumanon nak bantog nak nasyon.” ");
INSERT INTO bno_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Pagkatapos ingpakita it Dios kang Hagar kag usang bal-ong, kada nagpagto sida ag ingpuno nida it tubi kag ida susudlan, ag ingpainom nida si Ismael. Pagkainom ni Ismael, kali ay naulian. ");
INSERT INTO bno_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ingbantayan sida it GINO-O ag sida ay nagrako ruto sa kabukiran it Paran. Ag sida ay naging maayo nak mamamana. Ingpaasawa sida it ida nanay sa usang kabade nak taga-Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","It katong panahon it pagpalayas ni Abraham kana Hagar ag Ismael, si Abimelec ag si Picol nak pinuno it mga sundalo it Gerar ay nagbisita kang Abraham, ag nagsiling, “Ako namalayan nak ikaw ay ingpapaka-maado it Dios sa tanang imo inghuhuman, ");
INSERT INTO bno_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","kada magsumpa ka sa ako sa atubangan it Dios, nak indi nimo ako gilukuhon pati kag ako mga anak ag ako lahi. Maado kag ako pagtratar sa imo, kada magsumpa ka nak atrataron ra nimo kami it maado, ag imaw ra kag mga tawo nak ako nasasakupan hali sa duta nak imo ra ing-iistaran.” ");
INSERT INTO bno_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Nagsabat si Abraham, “Hala, masumpa ako.” ");
INSERT INTO bno_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Pero nagreklamo si Abraham kang Abimelec tungor sa usang bal-ong nak ging-agaw sa ida it mga suguon ni Abimelec. ");
INSERT INTO bno_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Nagsabat si Abimelec, “Waya ako nakakasador kung sin-o sa inra kag naghimo it kato. Ngasing yang nimo kali giumaan sa ako, kada ngasing yang kali nako narunggi!” ");
INSERT INTO bno_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Pagkatapos, nagbaoy si Abraham it mga karnero ag baka, ag kali ay ida gingta-o kang Abimelec ag sinra ay nagkasugtananey sa inra binisayahan. ");
INSERT INTO bno_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Nagpili ra si Abraham it pitong rumayagang karnero ag kali ay ida ingbuyag. ");
INSERT INTO bno_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Si Abimelec ay nagpangutana sa ida, “Asing imo kali ingbuyag? Ni-o kag gustong bisayahon it kali?” ");
INSERT INTO bno_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Sabat ni Abraham, “Batuna kaling pitong rumayagang karnero, ag sa imo pagbaton, imaw kali kag nagpapamatuor nak ako kag nagkutkot it kaling bal-ong nak kali.” ");
INSERT INTO bno_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kada ingpangayanan ninra katong lugar nak Beerseba kung hariin kag bal-ong nak kato, dahil sinrang ruha ay ruto nagkasugot sa inra sinumpaan. ");
INSERT INTO bno_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Pagkatapos ninrang magpanumpa sa usa'g-usa, si Abimelec ag si Picol ay nagpauliey sa Gerar nak imaw kag banwang ing-iistaran it hari it mga Pilistinhon. ");
INSERT INTO bno_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Pagkahalin ninra, nagtanom si Abraham sa Beerseba it usang Sampaloc, ag nagdayaw sida sa GINO-O nak Dios nak Waya't Katapusan. ");
INSERT INTO bno_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ag si Abraham ay nagpadayon sa pag-istar sa lugar it mga Pilistinhon sa suyor it mahabang panahon. ");
INSERT INTO bno_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Pagkatabo it mga bagay nak kali, ingpurbahan it Dios si Abraham, ag ingtawag sida, “Abraham!” Nagsabat si Abraham, “GINO-O, hali ako.” ");
INSERT INTO bno_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ag nagsiling kag Dios, “Nuntan kag imo bugtong ag kapupalanggang anak nak si Isaac sa Moraya ag ruto sa usang bukir nak ako itudlo sa imo, imo sida amatyon ag asunugon bilang halar nimo sa Ako.” ");
INSERT INTO bno_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kada, aga pa it katong masunor nak adlaw, nagbangoney si Abraham ag nagputpot sida it mga rabok para sa paghalar, bag-o ida kali ingkarga sa asno. Ingnunot nida kag ida anak nak si Isaac ag imaw ra kag ida ruhang suguon ag nagpanawey sinra papagto sa bukir nak ingsiling sa ida it Dios. ");
INSERT INTO bno_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sa pangtatlong adlaw it inra pagbaktas, nakita nida kag lugar nak Moraya sa unhan. ");
INSERT INTO bno_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Bag-o nagtukar sinra ruto sa bukir nak kato, nagsiling si Abraham sa ida ruhang suguon, “Rili yang anay kamo ag kaling asno. Ako ag kaling ako anak ay matukar agor madayaw sa GINO-O, mabalik yang ugaling kami rili.” ");
INSERT INTO bno_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ingbaoy ni Abraham kag rabok ag gingpapas-an kang Isaac, ag sida kag nagraya it kutsilyo ag gamit sa paghaling ag nagpadayon sinrang ruha. ");
INSERT INTO bno_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Marugay-rugay nagsiling si Isaac sa ida tatay, “Tay?” Ag nagsabat si Abraham, “Ni-o, To?” Nagpangutana si Isaac, “Inggwa kita it rabok ag gamit sa paghaling, pero hariin kag karnero nak ato ihalar?” ");
INSERT INTO bno_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Nagsabat si Abraham, “Anak, kag Dios ay imaw it mata-o sa ato it karnero nak ihalar.” Ag nagpadayon ray sinrang ruha. ");
INSERT INTO bno_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","It katong makaabot sinra sa lugar nak ingtudlo sa ida it Dios, nagsug-on-sug-on si Abraham it bato nak altar ag ida ingkamada kag rabok sa ibabaw it kato. Ida anay ingpahigra ag inggapos kag ida anak nak si Isaac tuyar sa hadop nak amatyon bilang inughalar, ag sida ay ingbutang sa ibabaw it mga rabok nak nakapatong sa altar. ");
INSERT INTO bno_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Pagkatapos ay ingbaoy nida kag kutsilyo pramas amatyoney tan-a nida kag ida anak, ");
INSERT INTO bno_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","pero ing-ayaba sida it anghel it GINO-O halin sa langit sa pagsiling, “Abraham, Abraham!” Nagsabat sida, “Hali ako GINO-O.” ");
INSERT INTO bno_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Nagsiling kag anghel, “Aya gimatya kinang imo anak! Ag ayang gador sida giunha! Napamatuuraney nimo nak inggwa ikaw it kahadlok sa Dios ag hanra ikaw nak magsunor sa Ida, dahil waya nimo giinakan kag imo bugtong nak anak.” ");
INSERT INTO bno_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Pagkabisaya it anghel, nakita ni Abraham kag usang kayake nak karnero nak nagsangit kag sungay sa kalikutan ruto, ag ida kato ingpagtuan ag ingbaoy. Imaw kali kag ida ingsubli nak ingmatay ag ingsunog bilang inughalar sa altar, imbes nak ida anak. ");
INSERT INTO bno_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ngani, ingpangayanan ni Abraham katong lugar nak “Kag GINO-O Kag Nag-aaman.” Ag hastang sa huli ay nagsisiling gihapon kag mga tawo nak “Sa bukir it GINO-O kag inughalar ay Ida ing-aaman.” ");
INSERT INTO bno_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nag-ayaba liwat kag anghel it GINO-O kang Abraham halin sa langit, ");
INSERT INTO bno_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","17","ag nagsiling, “Siling it GINO-O, ‘Nagsumpa Ako sa Ako Pagiging Dios, nak Ako ka apakamaaduhon dahil nagsunor ikaw sa Ako sugo ag waya nimo giinakan kag imo bugtong nak anak. Aparamuon Nako kag imo mga inanak, tuyar sa ramo it mga bituon sa langit ag tuyar sa ramo it baybay. Ag inra masasakop kag mga banwa it inra mga kaaway. ");
INSERT INTO bno_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ag sa parayan it imo mga inanak kag tanang katawuhan sa mga nasyon ay makakabaton it pagpakamaado, dahil sa imo pagsunor sa Ako.’ ” ");
INSERT INTO bno_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ag sina Abraham ay nagbalik ruto sa ida ruhang suguon ag nagpauliey sinra sa Beerseba kung hariin sinra giistar it marugay. ");
INSERT INTO bno_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Tong huli, inggwa it nagsiling kang Abraham nak kag ida manghor nak si Nahor ruto sa Padan-aram ay nagkainggwa it mga anak kang Milca. ");
INSERT INTO bno_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Kag panganay ay si Uz, masunor ay si Buz, ag masunor ray ay si Kemuel nak tatay ni Aram. ");
INSERT INTO bno_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kag masunor kang Kemuel ay si Cesed, ag masunor ray ay si Hazo, si Pildas, si Jidlap ag si Betuel. ");
INSERT INTO bno_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Si Betuel ay imaw kag tatay ni Rebeca. Imaw kali kag wayong mga anak ni Nahor kang Milca. ");
INSERT INTO bno_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Inggwa ra si Nahor it ibang asawa nak si Reuma ag kag ida mga anak ay sina Teba, Gaham, Tahas, ag Maaca. ");
INSERT INTO bno_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nag-abot si Sara sa edad nak syento beyntey-syete (127) anyos, ");
INSERT INTO bno_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ag sida ay namatay sa Kiriyat-arba, tong huli ay naging Hebron sa lugar it Canaan. Nagsuyor si Abraham kung hariin ingraramayan si Sara ag sida ay nagpanambitan sa ida rakong kalisor. ");
INSERT INTO bno_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Nagliwas anay si Abraham ag nagpayungot sida sa mga Hetanhon nak nagtitipon mayungot sa pwertahan pasuyor sa banwa. ");
INSERT INTO bno_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ag nagsiling si Abraham sa inra, “Buko talaga ako taga-rili, pero hali ako giiistar. Puyde baga ako magbakay it duta dili sa inro para yuyubngan, agor maiyubong nako kag ako asawa nak namatay.” ");
INSERT INTO bno_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Nagsabat kag mga Hetanhon, “Gino-o, ikaw ay amo ingkikilaya nak tuyar sa usang pinuno namo. Libre ikaw nak magpili aber sa pinaka-maado nak pantyon namo. Waya sa amo it mainak o mapiga sa imo sa pagyubong it imo minatay.” ");
INSERT INTO bno_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Nagtinrog ag nagsuong si Abraham sa inra atubangan, ");
INSERT INTO bno_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ag nagsiling sida, “Kung masugot kamo nak ako iyubong kag ako asawa, runggi anay ninro kag ako pangabay. Silingga anay si Epron nak anak ni Zohar, ");
INSERT INTO bno_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nak kung puyde ay ibaligya nida sa ako kag kuyba it Macpela nak asa guryunan it ida duta. Silingga baga sida nak hanra akong magbadar it ida presyo, ag kamo kag matestigo nak ako kato ingbabakay para maging yuyubngan namo.” ");
INSERT INTO bno_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ngasing, kaling si Epron ay usa sa mga maguyang nak Hetanhon nak nag-iingkor ra ruto, kada nagsabat sida kang Abraham ag ida ingparungog sa tanan. ");
INSERT INTO bno_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Gino-o, bad-ey yangey gibadari kato. Gamita yang katong kuyba nak yuyubngan pati katong duta. Hali ngasing kaling mga kasimanwa nako nak matestigo nak ingpapagamit nako kato sa imo, agor maiyubongey nimo kag imo minatay.” ");
INSERT INTO bno_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Nagsuong liwat si Abraham sa atubangan ninra ");
INSERT INTO bno_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ag nagsabat kang Epron, ag ida ingparungog sa tanan, “Kung talagang gusto nimo nak magamit nako katong duta, runggi anay ako. Kag ako gusto ay baligyaan yangey kato sa ako. Hanra akong magbadar it aber pila kag imo presyo, agor inggwa ako it ayubngan it ako minatay.” ");
INSERT INTO bno_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Nagsabat si Epron kang Abraham, ");
INSERT INTO bno_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Gino-o, ako it runggi. Makasugtanan kita dahil kita ay mag-amigo. Kag balor it kaling duta ay kwatro syentos (400) nak bilog it pilak yang. Hala, puyde nimong iyubong kag imo minatay ruto.” ");
INSERT INTO bno_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Kada nagkasugot sinra sa atubangan it mga tawo. Kumporme sa presyo it mga negosyante it katong inra kapanahunan, nagkilo si Abraham it balor it kwatro syentos (400) nak pilak, nak imaw kag ingsiling ni Epron nak presyo it kato sa atubangan it mga Hetanhon. ");
INSERT INTO bno_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kada, katong duta ni Epron sa Macpela, nak nakaatubang sa subatan it duta ni Mamre, pati kag kuyba ag kaumir kag mga kahoy sa palibot, ");
INSERT INTO bno_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","sa atubangan it mga maguyang nak Hetanhon ay napapagto kang Abraham. ");
INSERT INTO bno_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Pagkatapos it kali, ingyubongey ni Abraham si Sara sa kuyba sa duta it Macpela, mayungot kana Mamre sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ag katong parsela it duta nak nasasakupan it kuyba nak ida ingbakay sa mga Hetanhon ay naging kang Abraham nak imaw kag ida naging yuyubngan. ");
INSERT INTO bno_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ngasing, abang guyangey si Abraham ag ingpakamaado sida it GINO-O sa tanang ida inghuman. ");
INSERT INTO bno_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Usang adlaw, nagsiling sida sa ida usang suguon nak maguyangey nak imaw kag ida ingsasaligan ag imaw ra it manugpasulit it ida tanang ari-arian, “Butangan kag imo damot sa ako pa-a ");
INSERT INTO bno_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ag magsumpa ka sa atubangan it GINO-O, nak imaw kag DIOS it langit ag duta, nak indi ikaw magpili it rayaga nak Canaanhon dili sa ato ing-iistaran nak ipaasawa sa ako anak nak si Isaac. ");
INSERT INTO bno_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Pagto ruto sa Padan-aram nak lugar nak ako inghalinan, ag ruto ikaw mabaoy it rayaga sa ako kahalihan.” ");
INSERT INTO bno_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nagpangutana kag suguon sa ida amo nak si Abraham, “Nong, kung indi magnunot papali rili kag rayaga nak ako mapipili. Apapagtuon yangey baga nako si Isaac ruto sa imo inghalinan?” ");
INSERT INTO bno_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Nagsabat si Abraham, “Ayang gador gipapagtu-a kag ako anak ruto! ");
INSERT INTO bno_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Kag GINO-O, nak DIOS sa langit, nak imaw kag nagpahalin sa ako ruto sa banwa it ako mga hali kung hariin ako natawo, ay sida ra kag Dios nak nagpromisa sa ako nak ita-o sa ako mga inanak kag duta nak kali. Nagpapati ako nak Sida kag maparaya it anghel nak mauna sa imo ruto agor makakabaoy ka it asawa para sa ako anak. ");
INSERT INTO bno_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Pag indi magnunot sa imo kag rayaga nak imo mapipili, ay librey ikaw sa imo pagsumpa sa ako. Basta aya yang nak gador gipapagtu-a si Isaac ruto.” ");
INSERT INTO bno_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kada gingbutang it katong suguon kag ida damot sa pa-a ni Abraham ag nagsumpa nak masunor sida sa sugo it ida amo. ");
INSERT INTO bno_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Pagkatapos, inghanra it katong suguon kag sampuyong kamelyo it ida amo ag ingkarga nida kag mga pinili nak mga mamahayong regalo. Ag nagginaney sida, kanunot kag iba pang mga suguon papagto sa banwa ni Nahor nak manghor ni Abraham, ruto sa lugar it Padan-aram sa Mesopotamya. ");
INSERT INTO bno_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pagkalipas it pilang adlaw ay nag-abot sinra ruto sa liwas it banwa ni Nahor, ruto sa inggwa it bal-ong. Haponey it kato ag imaw kag oras it inugsag-ob it mga kabade it banwa. Ingpayuhor ninra ruto kag mga kamelyo sa mayungot it bal-ong ag nagpahuway sinra. ");
INSERT INTO bno_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Nagpangamuyo kag suguon, “GINO-O, nak DIOS it ako Amo nak si Abraham, buligi ako nak matuman nako kag sugo it ako Amo, ag kabay pa nak ipakita Nimo kag imo kaaduhan sa ako Amo. ");
INSERT INTO bno_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Hali ako ngasing sa mayungot it bal-ong, ag nakikita nako kag mga rayaga nak nagpapayungotey halin sa banwa, agor masag-ob. ");
INSERT INTO bno_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kabay pa nak kag rayaga nak ako asilinggon nak ‘Painuma anay baga ako,’ ag magsabat nak, ‘Oho Tang, inomey! Ag ako ra apainumon kag imo mga kamelyo,’ ay imaw sida kag Imo ingpili para sa Imo suguon nak si Isaac. Parayan dili makikilaya nako nak Imo ingpakita kag Imo kaaduhan sa ako Amo.” ");
INSERT INTO bno_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Waya pa nida natatapos kag ida pagpangamuyo, ay nag-abot kag usang rayaga nak inggwa't pas-an nak gining. Kali ay si Rebeca nak anak ni Betuel, nak putong anak nak kayake ni Milca ag ni Nahor. Kaling si Nahor ay imaw kag manghor ni Abraham. ");
INSERT INTO bno_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Si Rebeca ay abang ganda gimuyatan, pino gihiwas, ag birhen pa. Nag-us-os si Rebeca ruto sa di bal-ong ag gingpuno nida katong ida gining ag nagpaibabaw ray. ");
INSERT INTO bno_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Pagkakita it tong suguon nak pabalikey si Rebeca, nagrali-rali sida it payungot sa ida ag nagsiling, “Puyding mag-inom anay sa imo gining?” ");
INSERT INTO bno_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nagsabat sida, “Sige Tang, inomey.” Ag ida ingpahilig katong gining nak pas-an nida sa ida abaga, ag nag-inom kag suguon. ");
INSERT INTO bno_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Pagkainom it katong suguon, nagsiling pa si Rebeca, “Apainumon ra nako kag imo mga kamelyo hastang mabaoy kag inra uhaw.” ");
INSERT INTO bno_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kada nagrali-rali sida it paghuwar it tubi sa painuman it mga hadop ag pabalik-balik sida sa pagsag-ob sa bal-ong hastang ingsawaan kag mga kamelyo sa pag-inom. ");
INSERT INTO bno_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Habang ingpapainom ni Rebeca kag mga kamelyo, kag suguon ay nagmamasir sa ida, ag ida ing-iisip kung imawey kato kag sabat it GINO-O sa ida pagpangamuyo nak makakita it magiging asawa ni Isaac. ");
INSERT INTO bno_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Pagkatapos it inom it mga kamelyo, ingbaoy it suguon kag ida raya nak purong buyawan nak tagikaw, ag ruhang purong buyawan ra nak punseras nak karinamoy, ag ida ingta-o kang Rebeca. ");
INSERT INTO bno_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ag nagpangutana kag suguon, “Kanin-o ikaw anak? Puyde baga kaming magdayon sa bayay it imo tatay?” ");
INSERT INTO bno_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nagsabat si Rebeca, “Kag ako tatay ay si Betuel nak anak ni Milca kang Nahor. ");
INSERT INTO bno_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ag oho, puyde kamo nak magdayon sa amo. Ag inggwa ra kami it kumpay ag upa, ag lugar para sa imo mga kamelyo.” ");
INSERT INTO bno_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Pagkarungog nida it kali, nagsuong sida ag nagdayaw sa GINO-O ");
INSERT INTO bno_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","sa pagsiling, “Dayawon Ikaw, GINO-O, nak Dios it ako Amo nak si Abraham, nak waya gikalimot sa Imo promisa, ag Imo ingpakita kag Imo kaaduhan ag katutom sa ako Amo. Dayawon ra Ikaw, GINO-O, nak ako ay ingraya Nimo sa nak raan sa bayay it hali it ako Amo.” ");
INSERT INTO bno_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ag nagrayagan si Rebeca papauli sa inra ag sinra ay ida ingsilinggan tungor sa natabo. ");
INSERT INTO bno_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Si Rebeca ay inggwa it maguyáng nak kayake nak kag ngayan ay si Laban. ");
INSERT INTO bno_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Pagkakita nida it kaling buyawan nak tagikaw ag mga punseras nak suksok ni Rebeca, ag pagkarungog nida it bisaya ni Rebeca tungor sa ingsiling it katong tawo nak nagta-o sa ida, ay nagrayagan si Laban papagto sa bal-ong. Ruto nida nakita kag suguon ni Abraham nak nagtitinrog sa yudo it inra mga kamelyo mayungot sa bal-ong. Ag nagpayungot sida sa ida ");
INSERT INTO bno_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ag nagsiling, “Maley kamo nak mga kinaluy-an it GINO-O. Asing dili kamo sa liwas? Kitay kamo sa amo. Inggwa ako it lugar nak inghanra para sa inro ag sa inro ra mga kamelyo.” ");
INSERT INTO bno_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kada, nagnunot sinra kang Laban, ag pag-abot ninra sa bayay ingpadiskarga ni Laban kag mga karga it kamelyo ag ingpakaon kaling mga hadop it kumpay ag upa. Pagkatapos ay ingtaw-an nida katong suguon ag ida mga kaibanan it tubi nak panghinaw sa inra mga siki. ");
INSERT INTO bno_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ingpasuyor sinra ni Laban ag ingpatahawan it pagkaon, pero nagsiling kag suguon, “Indi anay kami magkaon hastang waya pa nako nasisiling kung asing nagpaali kami.” Nagsabat si Laban, “Ay hala, silingganey.” ");
INSERT INTO bno_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kada, nagsiling sida, “Ako ay suguon ni Abraham. ");
INSERT INTO bno_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ingpakamaado nak gador it GINO-O kag ako Amo ag sida ay nag-uswag. Ingtaw-an sida it GINO-O it maramo nak mga karnero, mga baka, mga asno, mga kamelyo, mga suguon nak kayake ag kabade, ag maramong pilak ag buyawan. ");
INSERT INTO bno_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Si Sara nak asawa it ako Amo ay nag-anak it usang kayake kang Abraham aber sida ay maguyangey, ag imaw kato kag nagpanubli it tanang ida manggar. ");
INSERT INTO bno_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","“Ingpasumpa ako it ako Amo nak indi ako magpili it rayaga nak ipaasawa sa ida anak sa mga taga-Canaan kung hariin sida giiistar. ");
INSERT INTO bno_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kada ingpapali ako nida sa inro nak ida kahalihan agor mapili it asawa para sa ida anak. ");
INSERT INTO bno_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Siling nako sa ako Amo, ‘Pauno kung indi sida magnunot sa ako?’ ");
INSERT INTO bno_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ag nagsabat sida, ‘Kag GINO-O nak ako ingsusunor ay imaw it maparaya it Ida anghel nak manunot sa imo, ag mabulig sa imo sa pagpili it rayaga nak halin sa ako kahalihan, nak ipaasawa sa ako anak. ");
INSERT INTO bno_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Pag-abot nimo sa ako mga hali ag kung indi sinra magsugot nak panunton kinang rayaga sa imo, librey ikaw sa imo ingsumpaan sa ako.’ ");
INSERT INTO bno_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“It kuman pag-abot nako sa bal-ong, nagpangamuyo ako sa ako sarili yang it tuyar kali, ‘GINO-O, nak Dios it ako Amo nak si Abraham, kabay pang buligan ako nimo sa ako obligasyon sa ako Amo. ");
INSERT INTO bno_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Hali ako ngasing sa bal-ong, ag kabay pa nak kag rayaga nak ako asilinggon nak, “Painuma anay baga ako,” ");
INSERT INTO bno_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ag magsabat nak, “Sige, inomey, ag apainumon ra nako kag imo mga kamelyo,” ay imawey kali kag rayaga nak gingpili it GINO-O para sa anak it ako Amo.’ ");
INSERT INTO bno_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Bag-o ako makatapos it ako pangamuyo, si Rebeca ay nag-abot nak pas-an kag ida gining, ag nag-us-os sa di bal-ong agor magsag-ob. Siling nako sa ida, ‘Puyding mag-inom anay?’ ");
INSERT INTO bno_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Sa nak raan ingpahilig nida kag ida pas-an nak gining ag nagsiling, ‘Inomey! Ag ako ra apainumon kag imo mga kamelyo.’ Kada nag-inom ako ag pagkatapos ida ray ingpainom kag amo mga kamelyo. ");
INSERT INTO bno_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ag nagpangutana ako sa ida, ‘Kanin-o ikaw anak?’ Sabat nida, ‘Kag ako tatay ay si Betuel nak anak ni Nahor kang Milca.’ Kada ingbutangan nako it tagikaw kag ida ilong ag ingsuksukan it ruhang punseras kag ida mga damot. ");
INSERT INTO bno_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Masunor nagsuong ako ag nagdayaw sa GINO-O. Nagpasalamat ako sa GINO-O, kag Dios it ako Amo, nak imaw kag nagraya sa ako sa nak raan sa bayay it ida manghor. Ag dili nako nakita kag apo nak rayaga it ida manghor nak magiging asawa it anak it ako Amo. ");
INSERT INTO bno_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","“Ngasing, gusto nakong maayaman kung inro ipakita kag inro kaaduhan ag katutom sa ako Amo ag masugot kamo nak kaling inro rayaga ay mapangasawa it ida anak. Umaan sa ako kung masugot kamo o indi. Agor kung indi, makakadesisyon ako kung ni-o kag ako mahihimo.” ");
INSERT INTO bno_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Nagsabat sina Laban ag Betuel, “Napati kami nak kali ay kabubut-on it GINO-O, kada indi ka namo mapaindian. ");
INSERT INTO bno_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Hali si Rebeca sa imo atubangan, puydey nimo sidang inunot. Sugot kami nak sida ay magiging asawa it anak it imo Amo, kumporme sa kabubut-on it GINO-O.” ");
INSERT INTO bno_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pagkarungog it kaling suguon ni Abraham sa inra ingsabat, nagyuhor sida ag nagpasalamat sa atubangan it GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ag ingpangliwas pa nida kag iba pang mga alahas nak pilak ag buyawan, ag mga mamahayong baro ag ingta-o kang Rebeca bilang payapot. Ida ra ingtaw-an it mga mamahayong regalo kag maguyáng ni Rebeca nak si Laban ag kag inra nanay. ");
INSERT INTO bno_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Pagkatapos it kali kag suguon ag kag ida mga kaibahan ay nagkinaoney ag nag-ininomey. Ruto ra sinra gigkatuyog. Pagkaaga, pagkabati ninra, katong suguon ay nagpamuhoney, “Mapauliey kami sa ako Amo.” ");
INSERT INTO bno_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pero nagpangabay kag maguyáng ni Rebeca nak si Laban ag kag ida nanay, “Ahawiran anay namo kamo aber mga sampuyong adlaw yang, ag pagkatapos inunotey ninro sida.” ");
INSERT INTO bno_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Pero nagsiling kag suguon, “Bad-ey ra ako ninro giparugaya rili dahil ingpakamaadoy it GINO-O kag ako ingpaali. Sugtey ako ninro nak makapauli sa ako Amo kanunot kaling inro rayaga.” ");
INSERT INTO bno_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nagsiling sinra, “Atawagon nato katong rayaga ag sida nato it apangutan-on.” ");
INSERT INTO bno_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ingtawag ngani ninra si Rebeca ag ingpangutana, “Gustoy baga nimo nak magnunot ngasing diling tawo?” Nagsabat si Rebeca, “Oho, manunotey ako ngasing.” ");
INSERT INTO bno_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kada ingsugtan yangey ninra si Rebeca, pati kag ida kabulig nak si Debora nak imaw kag nag-alaga sa ida tuna pagka-maisot, nak magnunot sa suguon ni Abraham ag sa ida mga kaibahan. ");
INSERT INTO bno_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Nagpamuhon sa inrang tanan si Rebeca ag gingbendisyunan ninra sida it tuyar kali, “Kabay pa Ne nak ikaw ay maging nanay it linibo nak inanak, ag kabay pa nak sinra ay magraog sa inra mga kaaway!” ");
INSERT INTO bno_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Nagliwas sina Rebeca pati kag ida mga kabading kabulig ag nagsakay sa mga kamelyo, ag pagkatapos ay nagsunorey sinra sa suguon nak nagbaoy sa ida. Tuyar kali kag pagraya it suguon kang Rebeca, ag naghaliney sinra. ");
INSERT INTO bno_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Myentras, tungor kang Isaac, sida ay nag-iistar ruto sa lugar it Negeb. Halin ruto sida ay nagpagto anay sa lugar it Beer-lahay-roy, ag pagkatapos nagpauli sa inra. ");
INSERT INTO bno_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Usang adlaw, waya narugay pagkatapos it ida pagpauli, nagpamasyar si Isaac sa bukir agor magpangamuyo. Haponey kato, ag pagmuyat nida, nakita nida nak inggwa't paabuton nak mga kamelyo. ");
INSERT INTO bno_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Pagkakita ni Rebeca kang Isaac, ay nagpilhig sida sa ida kamelyo, ");
INSERT INTO bno_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ag nagpayungot ag nagpangutana sida sa suguon, “Sin-o kinang kayake nak nagpapanaw pasapoy sa ato?” Nagsabat kag suguon, “Imaw kina kag anak it ako Amo,” kada gingtabunan ni Rebeca kag ida uda it bilo. ");
INSERT INTO bno_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Pag-abot it suguon kang Isaac, ingsiling nida kag tanang natabo ag ida mga inghuman. ");
INSERT INTO bno_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Pagkatapos, gingnunot ni Isaac si Rebeca nak ida kumangkon sa pakaisa, sa tolda it ida nanay ag ingbaton sida bilang ida asawa. Ingpalangga nida si Rebeca ag nabaoy kag ida kalisor para sa ida nanay. ");
INSERT INTO bno_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nag-asawa liwat si Abraham, ag kag ida pangruhang asawa ay si Ketura. ");
INSERT INTO bno_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kag mga anak nak kayake nida kang Abraham ay sina Zimran, Joksan, Medan, Midian, Isbak ag Sua. ");
INSERT INTO bno_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Joksan nak imaw kag pangruhang anak ni Abraham kang Ketura ay naging tatay it ruhang anak nak kayake nak sina Seba ag Dedan. Ag kag mga inanak ni Dedan ay imaw kag mga lahi nak Asurnon, Letusnon ag Leumnon. ");
INSERT INTO bno_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Si Midian nak imaw kag pang-ap-at nak anak ni Abraham kang Ketura ay naging tatay it mga anak nak kayake nak sina Epa, Eper, Hanoc, Abida ag Eldaa. Kali tanan ay mga inanak ni Abraham kang Ketura. ");
INSERT INTO bno_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Kang Isaac gipapanublian ni Abraham kag tanang ida ari-arian, ");
INSERT INTO bno_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","pero bag-o sida mamatay ay ingtaw-an ra nida it mga regalo kag iba pang mga anak nida sa ida ibang mga asawa. Ag sinra ay ingpapayado nida kang Isaac ag ingpapagto sa mga bukir sa subatan. ");
INSERT INTO bno_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Nag-abot si Abraham sa edad nak usang gatos ag sitentay-singko (175) nak tuig ag namatay sida sa ida kaguyangon, ag nagpahuwayey kapisan kag ida ginikanan. ");
INSERT INTO bno_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Sa Isaac ag Ismael nak ida mga anak kag nagpatigayon ag nagpayubong sa inra tatay ruto sa kuyba sa duta it Macpela, nak nakaatubang sa subatan it duta ni Mamre. Kato ay asa duta nak nabakay ni Abraham kang Epron nak anak ni Zohar nak Hetanhon. Sida ay ingyubong ruto katupar it ida asawa nak si Sara. ");
INSERT INTO bno_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pagkamatay ni Abraham, padayon nak ingpakamaado it Dios si Isaac nak ida anak ag rutoy sida giistar sa Beer-lahay-roy. ");
INSERT INTO bno_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Imaw kali kag mga inanak ni Abraham kang Ismael nak ida anak kang Hagar nak Ehiptohanong kabulig ni Sara. ");
INSERT INTO bno_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Kag mga anak nak kayake ni Ismael, tuna sa maguyang ay si Nebayot, sumunor si Kedar, si Adbeel, si Mibsam, ");
INSERT INTO bno_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","si Misma, si Duma, si Masa, ");
INSERT INTO bno_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","si Hadad, si Tema, si Jetur, si Napis ag si Kedema. ");
INSERT INTO bno_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dose tanan kag mga anak nak kayake ni Ismael, ag bawat usa sa inra ay naging pinuno it inra sariling lahi nak nag-istar sa mga tolda ag sa inra sariling mga banwa. ");
INSERT INTO bno_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Nag-abot si Ismael sa edad nak usang gatos ag treyntay-syete (137) nak tuig bag-o sida namatay ag nagpahuwayey kapisan kag ida ginikanan. ");
INSERT INTO bno_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Kag mga banwa it mga inanak ni Ismael ay asa tunga it Havila ag Sur nak hampig sa subatan it Ehipto papagto sa Asirya. Buyag ag laban sinra sa tanang inra kahalihan. ");
INSERT INTO bno_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Imaw kali kag istorya it mga inanak ni Isaac nak anak ni Abraham. ");
INSERT INTO bno_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kwarenta kag edad (40) ni Isaac it katong ida mapangasawa si Rebeca nak anak it ida pakaisa nak si Betuel. Ag si Rebeca ay manghor ni Laban. Sinra ay mga Aramnon sa Padan-aram. ");
INSERT INTO bno_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Dahil si Rebeca ay indi magkaanak, nagpangamuyo si Isaac sa GINO-O para sa ida asawa. Ag ingsabat it GINO-O kag ida pangamuyo, kada nagsabak si Rebeca. ");
INSERT INTO bno_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Katong sida ay sabakey, kag ida mga anak sa suyor it ida bituka ay nagsisiog-siugan, kada napasiling sida, “Kung tuyar yang ra kali it hirap kag ako pagsabak, asing kinahangyan pang mabuhi ako?” ");
INSERT INTO bno_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kada, nagpangutana sida sa GINO-O ag kag sabat it GINO-O sa ida ay, “Kinang asa imo bituka ay kapir, ag sinra ay magiging ruhang nasyon. Kag inra lahi ay mabuyag sa usa'g-usa. Ag sinra ay magiging magkalaban pa, ugaling magiging mas makusog kag usa kisa sa usa. Ngani, kag maguyáng kag maserbisyo sa manghor.” ");
INSERT INTO bno_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nag-abot kag panahon nak si Rebeca ay nagpasyapo, ag matuor nak kapir kag ida ging-anak. ");
INSERT INTO bno_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Pagpuslot it maguyáng, kali ay mapuya ag puno it bayukag kag ida yawas, kada ingpangayanan sida nak Esau. ");
INSERT INTO bno_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Masunor, pumuslot ray kag ida manghor ag kag ida damot ay nakahudot sa buoy it ida maguyáng, kada ingpangayan sida nak Jacob nak kag gustong bisayahon ay “Manluluko.” Saisentang (60) tuig kag edad ni Isaac it katong kag kapir ay ing-anak ni Rebeca. ");
INSERT INTO bno_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","It katong sinra ay maragkoey si Esau ay naging maayong mangangadam ag sida ay layas. Pero si Jacob ay mahipos nak tawo ag permi yang nak sa bayay. ");
INSERT INTO bno_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Kag palangga ni Isaac ay si Esau, dahil abang gusto nida kag suya nak karne it mga ilahas nak ida nararakop sa pagpangadam. Pero kag palangga ni Rebeca ay si Jacob. ");
INSERT INTO bno_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Usang adlaw si Jacob ay nagyuyuto it karne nak ingyus-ugan it tahuri. Nag-abot si Esau nak abang gutom halin sa pagpangadam sa bukir. ");
INSERT INTO bno_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Nagpayungot sida kang Jacob ag nagsiling, “Aroy, abang gutomey nako! Taw-e baga ako it kinang imo mapuyang ingyuyuto.” Kada tuna it kato si Esau ay ingtaw-an it palayaw nak Edom nak kag gustong bisayahon ay “Mapuya.” ");
INSERT INTO bno_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Pero nagsabat si Jacob, “O sige, ataw-an ka nako it kali, pero taw-an anay sa ako kag imo pagka-maguyáng.” ");
INSERT INTO bno_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Nagsabat si Esau, “Mamamatayey ra ako sa gutom, kada ni-o pa kag puyos it ako pagka-maguyáng? Hala, imoy!” ");
INSERT INTO bno_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Nagsiling ray si Jacob, “Sumpa anay sa ako!” Kada, nagsumpa ngani si Esau kang Jacob ag ida ingbaydo kag ida pagka-maguyáng sa mapuyang ingyuto ni Jacob. ");
INSERT INTO bno_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Pagkatapos, ingtahawan ni Jacob si Esau it tinapay ag katong ida ingyuto nak karne nak di yus-og nak tahuri. Nagkaon ag nag-inom sida ag pagkatapos ay nagpanawey. Tuyar kato kag ida pagbaliwaya sa ida pagka-maguyáng. ");
INSERT INTO bno_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ngasing, nagkainggwa liwat sa Canaan it tigkagutom. Kali ay iba ruto sa nakarayan nak tigkagutom it katong nabubuhi pa si Abraham. Kada nagpagto sina Isaac sa lugar nina Abimelec nak hari it mga Pilistinhon sa banwa it Gerar. ");
INSERT INTO bno_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Tuyar kali kag natabo, dahil bag-o nagpagto si Isaac ruto ay nagpakitaey kag GINO-O sa ida ag nagsiling nak, “Badaey gipagto sa Ehipto. Ruto yang ikaw sa lugar nak Ako itudlo sa imo. ");
INSERT INTO bno_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ruto yang anay ikaw, pag-abot nimo ruto, ag Ako ay magiging kaibhanan nimo dahil maabot kag oras nak ita-o nako kaling duta sa imo ag sa imo magiging mga inanak. Ako atuparon sa imo kag kasugtanan nak Ako ingpromisa sa imo tatay nak si Abraham. ");
INSERT INTO bno_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","“Aparamuon Nako kag imo mga inanak tuyar sa ramo it mga bituon sa langit, ag kaling tanang duta ay ita-o Nako sa inra. Parayan ra sa imo magiging mga inanak, kag tanang katawuhan sa mga nasyon sa kalibutan ay makakabaton it pagpakamaado. ");
INSERT INTO bno_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Apakamaaduhon Nako kamo dahil ingsunor ni Abraham kag Ako mga kabubut-on ag mga kasuguan.” ");
INSERT INTO bno_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kada, ruto giistar sina Isaac sa Gerar. ");
INSERT INTO bno_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Pag ingpapangutana si Isaac it mga taga-ruto kung sin-o si Rebeca, kag ida ingsisiling ay ida manghor. Kumo maganda si Rebeca, kada nahadlok sida magsiling nak si Rebeca ay ida asawa, dahil sabaling sida ay matyon agor mabaoy ninra si Rebeca. ");
INSERT INTO bno_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","It katong marugayey ruto sina Isaac, usang adlaw sa pagpaninggaha ni Abimelec nak hari it mga Pilistinhon, nakita nida nak ingkakarinyuhan ni Isaac si Rebeca. ");
INSERT INTO bno_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kada ingpatawag ni Abimelec si Isaac ag nagsiling, “Hay, asawa yaki nimo sida! Asing nagsiling ikaw nak sida ay imo manghor?” Nagsabat si Isaac, “Kabi nako ay inro ako amatyon agor mabaoy sida.” ");
INSERT INTO bno_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Nagsiling si Abimelec, “Ni-o kaling imo inghuman sa amo? Ay pauno kung usa sa ako mga tawuhan ay ing-ulit kag imo asawa? Ingray-an pa kami nimo it rakong kasal-anan!” ");
INSERT INTO bno_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kada ingpaandaman ni Abimelec kag ida mga sinakupan. Nagsiling sida, “Sin-o man sa inro kag makahimo it mayain kang Isaac ag sa ida asawa ay mamamatay.” ");
INSERT INTO bno_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Pagkatapos, nagpaninanom si Isaac it uyas sa inra duta ag sida ay nagpanubas it bugana it katong tuig nak kato. ");
INSERT INTO bno_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Sida ay ingpakamaado it GINO-O ag padayon sida nak nag-uswag hastang maging manggaranon. ");
INSERT INTO bno_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nagkainggwa sida it maramong mga karnero, kambing ag baka, pati maramong suguon, kada nahili sa ida kag mga Pilistinhon. ");
INSERT INTO bno_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kada ingtambakan it mga Pilistinhon kag mga bal-ong nak gingpakutkot it ida tatay nak si Abraham it katong ruto pa sida giiistar. ");
INSERT INTO bno_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ag nagsiling si Abimelec kang Isaac, “Payado kamo sa amo dahil mas makusogey ag mas mayamaney kamo kisa sa amo.” ");
INSERT INTO bno_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kada ngani, naghalin sina Isaac mayungot sa banwa it Gerar ag sinra ay nagpayado ag nagtukor it inra mga tolda sa patag sa tunga it mga baguntor nak sakop ra gihapon it Gerar, kung hariin ruto sinra giiistar it marugay. ");
INSERT INTO bno_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","It katong ruto pa sa Gerar giistar si Abraham, inggwa sida ruto it ingpakutkot nak mga bal-ong. Pero pagkamatay nida ingpangtambakan kato it mga Pilistinhon. Ngasing, ingpakutkot ray liwat ni Isaac kag mga bal-ong nak kato ag ingtawag nida kato sa mga pangayan nak ingtaoy dati it ida tatay. ");
INSERT INTO bno_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Sa pagkutkot it mga suguon ni Isaac, nakakita sinra it rakong tuburan, ");
INSERT INTO bno_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","pero ing-agaw kali it mga manugbantay it mga hadop nak taga-Gerar, kada sinra ay nag-away. Siling ninra, “Amo kali tubi.” Ag ingpangayanan ni Isaac kaling bal-ong nak Esek dahil sa inra pag-agaw-agawan. ");
INSERT INTO bno_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Masunor, nagkutkot ray sinra liwat, ag ing-awayan ray ninra kali. Ag ingpangayanan nida kaling bal-ong nak Sitna dahil sa inra paghangit-hangitan. ");
INSERT INTO bno_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Dahil ruto, nagsaydo ray sina Isaac ag nagpakutkot liwat it usang bal-ong, ag kali ay wayaey ninra giawaye. Ag ingpangayanan nida kaling bal-ong nak Rehobot dahil sa inra pagsiling nak, “Ngasing ingtaw-an kita it GINO-O it maliway nak lugar ag kita ay magiging bugana rili.” ");
INSERT INTO bno_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Pagkalipas it pilang panahon, sina Isaac ay nagsaydo ray pabalik sa Beerseba. ");
INSERT INTO bno_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","It katong gab-i it inra pag-abot ruto, kag GINO-O ay nagpakita sa ida ag nagsiling, “Ako kag Dios it imo tatay nak si Abraham. Aya gikahadlok, dahil kaibahan Ako nimo. Apakamaaduhon ikaw Nako, ag aparamuon nako kag imo mga inanak alang-alang kang Abraham nak Ako suguon.” ");
INSERT INTO bno_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kada nagsug-on-sug-on si Isaac it batong altar ag nagdayaw sa GINO-O. Ruto ra sinra gitukor it inra mga tolda ag nagpakutkot sida ruto it usang bal-ong. ");
INSERT INTO bno_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Habang hagto sina Isaac sa Beerseba, halin sa Gerar ay nagpagto si Abimelec sa ida, kaibahan si Ahuzat nak ida Manuglaygay, ag si Picol nak pinuno it ida mga sundalo. ");
INSERT INTO bno_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Pag-abot ninra, nagpangutana si Isaac, “Mauno kamo, asing nagpali kamo? Di baga hangit kamo sa ako, kada inro kami gingpahalin sa inro banwa?” ");
INSERT INTO bno_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nagsabat sinra, “Nakita nak gador namo nak kaibahan nimo kag GINO-O, kada ngani gusto namo nak maghuman it kasugtanan sa imo. ");
INSERT INTO bno_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Masumpaan kita nak indi ninro kami giunhon ag indi ra kamo namo giunhon. Maado ra kag amo pagtratar sa inro it katong hagto kamo sa amo. Ingpakitaan kamo namo it maado ag aber ingpahalin kamo nako ay sa maadong parayan, ag ngasing ikaw ay ingpakamaado nak gador it GINO-O.” ");
INSERT INTO bno_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Katong nagkasugotey sinra, nagpahanra si Isaac it maadong mga pagkaon ag sinra ay nagkinaon ag nag-ininom. ");
INSERT INTO bno_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Pagkaaga, maaga pa sinrang nagbati ag nagsumpaan kumporme sa inra binisayahan, bag-o ginghator sinra ni Isaac sa rayan papauli ag maado kag inra pagbinuyagan. ");
INSERT INTO bno_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","It katong adlaw nak kato, nag-uma kag mga suguon ni Isaac nak nakakutkotey sinra it bal-ong nak inggwa it tubi. ");
INSERT INTO bno_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ag ingpangayanan ninra katong bal-ong nak Seba dahil sa inra pagsinumpaan, kada hastang ngasing, ingtatawag kag inra syudad nak Beerseba. ");
INSERT INTO bno_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Pag-abot ni Esau sa edad nak kwarenta (40) nak tuig, nag-asawa sida kang Judit nak anak ni Beeri, ag kang Basemat nak anak ni Elon, nak parehong mga Hetanhon. ");
INSERT INTO bno_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Imaw kali kag naging dahilan it kalisor nina Isaac ag Rebeca. ");
INSERT INTO bno_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","It katong si Isaac ay maguyangey ag maruyomey kag ida mga mata, ag indiey sida makatuhob it maado. Usang adlaw, ida ing-ayaba kag ida anak nak panganay nak si Esau ag nagsiling, “Anak!” Ag nagsabat si Esau, “Tay, hali po ako.” ");
INSERT INTO bno_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Nagsiling si Isaac, “Maguyangey ako ag buko nako ayam kung sauno ako mamamatay. ");
INSERT INTO bno_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kada ray-a kag imo mga armas ag pana ag magpagto sa kaguyangan agor magpangadam it ilahas para sa ako. ");
INSERT INTO bno_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ag yutu-e ako it ako gustong suya, agor makakakaon ako ag mabendisyunan ka nako bag-o ako mamatay.” ");
INSERT INTO bno_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Habang si Isaac ay nagbibisaya kang Esau, nagpapanimati yaki si Rebeca. Kada pagkahalin ni Esau nak mapangadam sa kaguyangan, ");
INSERT INTO bno_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ay nagsiling si Rebeca sa ida anak nak si Jacob, “Narunggan nako kag imo tatay nak nagsugo kang Esau ");
INSERT INTO bno_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","nak magpangadam kuno it ilahas. Inapayuto nida kag ida gustong suya, agor makaon sida ag pagkatapos, abendisyunan kuno nida si Esau sa atubangan it GINO-O bag-o sida mamatay. ");
INSERT INTO bno_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kada ngasing, Toto, sunra kag ako isiling sa imo. ");
INSERT INTO bno_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pagto ruto sa ato mga kambing ag magpili it ruhang mataba ag bata pa nak kambing, agor ayutuon nako kag gustong suya it imo tatay. ");
INSERT INTO bno_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Pramas ikaw kag ida mabibendisyunan bag-o sida mamatay, ay imo aray-on kaling suya sa imo tatay agor sida ay makakaon.” ");
INSERT INTO bno_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Pero nagrason si Jacob sa ida nanay, “Pero Nay, si Esau ay puno it bayukag ag ako ay waya. ");
INSERT INTO bno_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Sabaling haphapon ako nida, ag masaduran nida nak ako sida ingluluko. Ida ako isumpa imbes nak abendisyunan.” ");
INSERT INTO bno_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nagsiling kag ida nanay, “Aya'g kalibog Toto, ako it bahala, basta't sunra yang ako. Pagtoy, baoy it mga kambing ag ray-on dili.” ");
INSERT INTO bno_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kada nagpagto si Jacob ag nagbaoy ngani it ruhang kambing, ag ida ingpangraya kali sa ida nanay. Ing-ihaw kali ni Rebeca ag ida ingyuto kag gustong suya ni Isaac. ");
INSERT INTO bno_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Masunor, nagsuyor si Rebeca sa tolda ag ingbaoy kag pinaka-maadong baro ni Esau nak ida panganay nak anak, ag ingpasuksok nida kang Jacob nak ida putong anak. ");
INSERT INTO bno_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ingbaoy ni Rebeca kag mga anit it kambing nak inggwa't bayukag, ag ingpuros sa mga damot ag liog ni Jacob nak waya it bayukag. ");
INSERT INTO bno_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ida ingta-o kang Jacob kag tinapay ag mainit nak suya nak ida ingyuto. ");
INSERT INTO bno_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ag nagsuyor si Jacob sa tolda it ida tatay ag nagsiling, “Tay!” Ag nagsabat si Isaac, “To, hali ako. Si-o ikaw anak?” ");
INSERT INTO bno_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Nagsabat si Jacob, “Ako si Esau nak imo panganay nak anak. Natumaney nako kag imo ingsugo sa ako. Tay! Bangoney, ag kaunoney kaling imo gustong suya nak ako ingyuto, bag-o nimo ako bendisyunan.” ");
INSERT INTO bno_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Pero nagpangutana si Isaac, “Asing abang rali ra ikaw makabaoy it ilahas Toto?” Sabat ni Jacob, “Sa kaluoy ra it GINO-O nak Dios nimo ay nakakita ako nak raan Tay.” ");
INSERT INTO bno_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Nagsiling ray si Isaac kang Jacob, “Maley, payungot baga rili To, agor ako ikaw mahaphap kung talagang ikaw ay si Esau.” ");
INSERT INTO bno_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kada si Jacob ay nagsuor sa ida tatay ag sida ay inghaphap it kali ag nagsiling, “Kag boses nimo ay pay kang Jacob, pero kag imo damot ay damot ni Esau.” ");
INSERT INTO bno_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ag waya nida nakilaya si Jacob dahil kag ida mga damot ay bayukagon tuyar it kang Esau. Abendisyunaney tan-a nida si Jacob, ");
INSERT INTO bno_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","pero nagpangutana pa gihapon sida, “Matuor baga nak ikaw talaga kag ako anak nak si Esau?” Sabat ni Jacob, “Oho, matuor talaga Tay.” ");
INSERT INTO bno_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ag nagsiling pa si Isaac, “Hala, be kinang suya nak imo ingyuto ag makaon ako, agor pagkatapos, abendisyunaney ikaw nako.” Ingta-o ngani ni Jacob kag pagkaon kang Isaac ag ida ingray-an ayak. Nagkaon ag nag-inom kag ida tatay. ");
INSERT INTO bno_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Pagkakaon ni Isaac, nagsiling sida, “Maley anay, haru-e baga ako To.” ");
INSERT INTO bno_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kada nagsuor si Jacob ag ida ingharuan kag ida tatay. Sa ida pagharo, nahugman ni Isaac kag hugom ni Esau sa ida baro ag ida ingbendisyunan si Jacob sa pagsiling, “Mm, kag hugom it ako anak ay kabubangyo, pay tuyar sa bukir nak gingpakamaado it GINO-O! ");
INSERT INTO bno_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kabay pang ita-o sa imo it Dios, kag tun-og nak halin sa langit, ag matabang paninanom, ag buganang panubas it uyas ag inumong ubas. ");
INSERT INTO bno_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kabay pa rang magpasakop ag serbisyuhan ka it mga nasyon, ag kag katawuhan sa imo ay magsinuong. Kag imo kahalihan ay imo apanguyuhan, ag kag mga inanak it imo nanay, ikaw ay ayurhan. Kabay pang kag magsumpa sa imo ay sumpaon ra, ag kag mapakamaado sa imo ay apakamaaduhon ra.” ");
INSERT INTO bno_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Pagkatapos it pagbendisyon ni Isaac kang Jacob ay nagliwasey sida. Isot yangey sida naabute ni Esau nak halin sa pagpangadam, pas-an kag ida nabaoy nak hadop. ");
INSERT INTO bno_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ida nak raan ingyuto kag gustong suya it ida tatay ag ingraya nida kali sa ida, ag nagsiling, “Tay! Bangoney, ag kaunoney kaling imo gustong suya nak ako ingyuto, bag-o nimo ako bendisyunan.” ");
INSERT INTO bno_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nagpangutana si Isaac, “Nak si-o ikaw?” Sabat ni Esau, “Ako ngani kag imo anak, kag imo panganay nak anak nak si Esau.” ");
INSERT INTO bno_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Pagkarungog it kali ni Isaac, ay abang panguyog nida ag sida ay nagpangutana, “Ay sin-o katong naunang nagpangadam nak nagraya sa ako it suya? Bag-o ikaw nag-abot, ay pagkatapos pa yang nako it kaon ag sida ay akoey ingbendisyunan. Ag kung ni-o kag ako ingtaong bendisyon sa ida ay iday talaga kato, ag indiey nako puyding bawion.” ");
INSERT INTO bno_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Pagkarungog it kali ni Esau, napaukaw sida it tibaw, ag nagpakitluoy sa ida tatay, “Tay, ako ra! Bendisyune ra ako!” ");
INSERT INTO bno_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ugaling nagsabat si Isaac, “Ingluko ako it imo manghor ag nabaoy nida kag bendisyon nak dapat tan-a ay para sa imo.” ");
INSERT INTO bno_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Siling ni Esau, “Hm! Tamang gador kag ida pangayan nak Jacob, dahil manluluko talaga sida! Ruhang besesey kaling ida pangluko sa ako. It katong una, ingbaoy nida kag ako pagka-maguyáng, ag ngasing ay ida ray ing-agaw kag bendisyon nak tan-a'y para sa ako.” Ag nagsiling pa sida, “Wayaey baga talaga Tay it nabilin nak bendisyon para sa ako?” ");
INSERT INTO bno_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Nagsabat si Isaac kang Esau, “Ingtaoy nako sa ida kag pagka-pinuno, ag tanang ida mga hali ay magiging suguon nida. Ingtaoy ra nako sa ida kag buganang paninanom ag duga it ubas. Ni-o pa kag nabibilin nak maitata-o nako sa imo To?” ");
INSERT INTO bno_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Pero padayon nak nagpakitluoy si Esau sa ida tatay, “Tay, wayaey bagang gador it nabilin, aber usa? Bendisyune ra ako Tay!” Ag nagpakatibaw ray liwat sida. ");
INSERT INTO bno_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kada, nagsabat si Isaac kang Esau ag kali kag ida bendisyon sa ida, “Anak, kag imo magiging istaran ay ruto sa dutang mayado sa kabuganaan, ruto sa lugar nak indi matun-ugan. ");
INSERT INTO bno_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Sa espada ka mabubuhi. Ikaw ay aulipunon it imo manghor, pero sida ay imo alabanan, ag ikaw ay makakahaw-as sa ida gahom.” ");
INSERT INTO bno_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Tuna it kato, nagpahimot si Esau kang Jacob dahil sa bendisyon it inra tatay. Kada nagsiling si Esau sa ida sarili, “Badyang! Mayungotey ra mamatay si Tatay. Pagkatapos it ida pasukat, amatyon nak gador nako kaling ako manghor nak si Jacob.” ");
INSERT INTO bno_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Pero kaling pahimot ni Esau ay nakaabot kang Rebeca, kada ingpatawag nida si Jacob, ag nagsiling sa ida, “Kaling imo manong nak si Esau ay nagtityempo yang nak ikaw ay matyon. ");
INSERT INTO bno_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kada ngasing, Anak, sunra kag ako sugo sa imo. Pagto sa ako maguyáng nak si Laban ruto sa Haran. ");
INSERT INTO bno_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Hagto yang anay ikaw hastang mawagit kag kahangit it imo manong. ");
INSERT INTO bno_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Pag bukoey sida hangit ag nalimtaney nida kag imo inghuman sa ida, apapaulioney ka nako. Indi ako magsugot nak magmatyanan kamong ako mga anak!” ");
INSERT INTO bno_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Pagkatapos, nagsiling si Rebeca kang Isaac, “Nasaputaney ako sa ako kabuhi sa pag-impon dili sa mga umagar nak Hetanhon. Kung tuyar yang ra gihapon kag maaasawa ni Jacob, ay maado pa't mamatay yangey ako!” ");
INSERT INTO bno_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ngani, ingpatawag ni Isaac si Jacob, ag ida ingbendisyunan ag ingtugon sida sa pagsiling, “Ayang gador gipangasawa it rayaga nak taga-dili sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Pagto ruto sa Padan-aram sa imo Lolo Betuel, nak tatay it imo nanay. Pili ruto it usang rayaga nak imo magiging asawa nak anak it imo Tiyo Laban, nak maguyáng it imo nanay. ");
INSERT INTO bno_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kabay pa nak pakamaaduhon ka it Dios nak Makagagahom, ag sa imo pag-asawa taw-an ka Nida it maramong anak, ag kag imo mga inanak ay magiging maramong lahi. ");
INSERT INTO bno_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kabay pa nak mapasa-imo ag sa imo mga inanak kag ingpromisa nak pagpakamaado it Dios sa imo Lolo Abraham, nak maging inro kaling duta nak ato ing-iistaran.” ");
INSERT INTO bno_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Imaw kali kag bendisyon ni Isaac kang Jacob sa ida pagpanaw papagto ruto sa Padan-aram, sa ida Tiyo Laban nak anak ni Betuel nak Aramnon. Kaling si Laban ay maguyáng ni Rebeca nak nanay nina Jacob ag Esau. ");
INSERT INTO bno_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ngasing, naayaman ni Esau nak ingbendisyunan ni Isaac si Jacob bag-o ingpapagto sa Padan-aram, agor ruto mapangasawa. Naayaman ra nida nak ingpakatugon ni Isaac si Jacob nak indi nak gador kali magpangasawa it rayaga nak taga-Canaan. ");
INSERT INTO bno_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ag nagsunor si Jacob sa gusto it ida tatay ag nanay ag sida ay naghaliney papagto sa Padan-aram. ");
INSERT INTO bno_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kada ngani it katong naayaman ni Esau nak kuntra kag ida tatay sa mga umagar nida nak taga-Canaan, ");
INSERT INTO bno_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ay nagpagto sida ruto sa ida Tiyo Ismael, ag ing-asawa pa gihapon si Mahalat nak hali ni Nebayot. Sinra'y mga anak ni Ismael. ");
INSERT INTO bno_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ngasing, naghalin si Jacob sa Beerseba papagto sa Haran. ");
INSERT INTO bno_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Naabutan sida it gab-i sa usang lugar ag ruto sida gipalipas it gab-i. Nagbaoy sida it usang bato nak ida ing-uyunan, ag ruto sida gighigra. ");
INSERT INTO bno_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nagpananamgo sida nak inggwa kuno it usang sanrig nak abot sa langit. Ag nakikita nida kag mga anghel it Dios nak nagsasaka ag nagpipilhig ruto. ");
INSERT INTO bno_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nakita ra nida kag GINO-O nak hina sa ida uyuhan. Ag nagsiling Kali sa ida, “Ako kag GINO-O, nak Dios it imo Lolo Abraham ag Dios ra it imo tatay nak si Isaac. Kaling duta nak imo inghihigraan ay ita-o Nako sa imo ag sa imo magiging mga inanak. ");
INSERT INTO bno_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kag imo mga inanak ay maramo tuyar sa ramo it taybo sa duta, ag makadat sinra sa tanang parti it kalibutan. Ag parayan sa imo ag sa imo magiging mga inanak, tanang mga lahi sa kalibutan ay makakabaton it pagpakamaado. ");
INSERT INTO bno_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kaibahan Ako nimo ag abantayan ka Nako aber hariin ikaw magpagto, ag ibalik ka Nako sa duta nak kali. Indi ka Nako gibadaan, atuparon Nako kag tanang Ako ingbisaya sa imo.” ");
INSERT INTO bno_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Nakabati si Jacob ag nagsiling, “Hali yaki kag GINO-O, waya nako naayame!” ");
INSERT INTO bno_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Hinadlukan sida ag nagsiling pa, “Napangidlis ako sa lugar nak kali! Hali yaki kag bayay it Dios, ag kali kag hagran pa-langit.” ");
INSERT INTO bno_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kada, maaga pa, nagbangoney si Jacob ag ingbaoy nida katong batong ida ing-uyunan, ag ingpatinrog kali bag-o binub-an it lana sa ibabaw bilang tanra it pagpakita sa ida it Dios. ");
INSERT INTO bno_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ingtawag nida katong lugar nak Betel nak kag gustong bisayahon ay “Bayay it Dios,” pero kag dating ngayan it katong banwa ay Luz. ");
INSERT INTO bno_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nagsumpa si Jacob sa Dios sa pagsiling, “Kung ako'y Imo aibhan ag abantayan sa ako pagpanaw, ag kung Imo ako apakaunon ag ayamitan, ");
INSERT INTO bno_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ag Imo ako ibalik it maado sa bayay it ako tatay, ay Ikaw GINO-O kag ako magiging Dios. ");
INSERT INTO bno_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ag kaling bato nak ako ingpatinrog ay tanra nak hali kag Imo bayay. Ag kag tanang butang nak Imo ita-o sa ako ay ita-o ra nako sa Imo kag ika-sampuyong parti.” ");
INSERT INTO bno_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Pagkatapos, nagpadayon si Jacob sa ida pagpanaw hastang sa makaabot sida sa Padan-aram nak imaw it ing-iistaran it mga halin sa Caldeya sa subatan. ");
INSERT INTO bno_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Pagmuyat nida, inggwa sida it nakita nak bal-ong sa bukir. Sa palibot it kato, inggwa't tatlong grupo it karnero nak nagpapahuway kaibahan it inra mga manugbantay, dahil ruto ninra kali gipapainuma. Inggwa't rakong bato nak nakatabon sa yuba it katong bal-ong. ");
INSERT INTO bno_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Pag nagtiniponey kag mga karnero, inapaligir it mga manugbantay katong marakong bato ag pagkatapos ninra it painom, inra ray inatabunan kag bal-ong. ");
INSERT INTO bno_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Nagpangutana si Jacob sa inra, “Mga amigo, taga-riin kamo?” Nagsabat sinra, “Taga Haran kami.” ");
INSERT INTO bno_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Nagpangutana ray si Jacob, “Kilaya baga ninro si Laban nak apo ni Nahor?” Sabat ninra, “Oho, kilaya namo sida.” ");
INSERT INTO bno_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nagsiling ray si Jacob, “Ay kamustay ra sida?” Sabat ninra, “Maado ra. Kina nganing paabuton nak rayaga nak di kanunot nak mga karnero ay si Raquel nak ida anak.” ");
INSERT INTO bno_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Siling ni Jacob, “Maaga pa, ag buko pa oras nak inugpasilong it mga karnero. Ay kung inapainomey ninro sinra agor makakasabsab ray.” ");
INSERT INTO bno_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Pero nagrason sinra, “Indi ngani puyde. Kinahangyan nak magtipon anay kag tanang mga karnero bag-o paligiron kag bato halin sa yuba it bal-ong pramas mapainom sinra.” ");
INSERT INTO bno_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Habang nag-iistorya pa sinra, nag-abot si Raquel nak kanunot kag mga karnero it ida tatay, dahil sida kag manugbantay ninra. ");
INSERT INTO bno_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Pagkakita ni Jacob kang Raquel nak anak ni Laban nak maguyáng it ida nanay, ay nagpagto sida sa yuba it bal-ong ag ingpaligir kag bato. Ida ingpainom kag mga karnero ni Laban, ");
INSERT INTO bno_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","ag nagpakilaya sida kang Raquel nak sida kag kumangkon it ida tatay ag anak it ida Tiya Rebeca. Pagkatapos, ingharuan nida si Raquel ag napatibaw sida sa kasadya. Pagkakilaya ni Raquel kang Jacob, nagrayagan sida papauli ag nagsiling sa ida tatay nak si Laban. ");
INSERT INTO bno_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pagkarungog ni Laban nak nag-abot kag anak it ida manghor, nagrayagan sida ag ida kali ingsapoy-sapoy. Pagkita ninra, ingkupkupan ag ingharuan nida si Jacob, bag-o ingnunot sa inra bayay. Nagbalita si Jacob kang Laban it kamutangan ninra. ");
INSERT INTO bno_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kada nagsiling si Laban, “Matuor nak ikaw ay ako karugo!” ag nagtiner sida sa inra bilang usang bisita sa suyor it usang buyan. ");
INSERT INTO bno_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ag nagsiling si Laban kang Jacob, “Buko kumo ikaw ay ako kumangkon ay matrabaho yang ikaw it waya it suhoy. Silinggan sa ako kung ni-o kag imo gustong suhoy.” ");
INSERT INTO bno_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Si Laban ay inggwa't ruhang anak nak rayaga. Kag ngayan it maguyáng ay si Lea ag kag ngayan it manghor ay si Raquel. ");
INSERT INTO bno_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Kag mga mata ni Lea ay pay manok-manukon, pero si Raquel ay maganda, pati kag kurte it yawas. ");
INSERT INTO bno_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Gingpalangga ni Jacob si Raquel, kada nagsiling sida, “Maserbisyo ako sa imo it pitong tuig para sa imo putong anak nak si Raquel.” ");
INSERT INTO bno_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Nagsugot si Laban, “Mas maado pa ngani kung ikaw kag ida maaasawa kisa ita-o pa nako sida sa iba. Hala, dili yang ikaw.” ");
INSERT INTO bno_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kada nagserbisyo si Jacob it pitong tuig para kang Raquel. Ag para sa ida, pay pilang adlaw yang kato dahil sa ida pagpalangga kang Raquel. ");
INSERT INTO bno_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Pagkalipas it pitong tuig, nagsiling si Jacob kang Laban, “Nataposey nako kag pitong tuig, kada taw-aney sa ako kag ako magiging asawa.” ");
INSERT INTO bno_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ngani, ing-imbitar ni Laban kag tanang taga-ruto, agor marungaw sa marakong punsyon sa kasay it ida anak. ");
INSERT INTO bno_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pero pagkagab-i kag ingraya ni Laban kang Jacob ay kag ida maguyáng nak anak nak si Lea, ag inubayan sida ni Jacob. ");
INSERT INTO bno_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ingtaw-an ra ni Laban si Lea it usang kabulig nak kabade nak kag ngayan ay si Zilpa. ");
INSERT INTO bno_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Pagkaaga, nakita ni Jacob nak si Lea yaki kag ida kaubay, kada ingsura ni Jacob si Laban, “Ni-o kaling imo ginghuman sa ako? Di baga nagserbisyo ako sa imo para kang Raquel? Asing imo ako ingluko?” ");
INSERT INTO bno_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Nagrason si Laban, “Buko tuyar kina kag amo sulunranon dili. Kinahangyan nak mauna mag-asawa kag maguyáng sa manghor. ");
INSERT INTO bno_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tapusa anay kaling usang dominggo it inro pagkasay, ag pagkatapos ita-o nako sa imo si Raquel, kung maserbisyo ray liwat ikaw sa ako it pitong tuig.” ");
INSERT INTO bno_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Nagsugot ra si Jacob ag gingtapos kag usang dominggo nak pagkinasadya sa kasay nida kang Lea, ag ingpaasawa ray ni Laban sa ida si Raquel. ");
INSERT INTO bno_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ingtaw-an ra ni Laban si Raquel it usang kabulig nak kabade nak kag ngayan ay si Bilha. ");
INSERT INTO bno_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Kada ngasing, naging asawa ra ni Jacob si Raquel. Mas palangga ni Jacob si Raquel kisa kang Lea ag nagserbisyo ray sida sa ida panugangan it pitong tuig pa. ");
INSERT INTO bno_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","It tong nakita it GINO-O nak si Lea ay ing-iihig ay ingbuot Nida nak magkaanak kali, pero si Raquel ay waya pa. ");
INSERT INTO bno_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nagsabak si Lea ag nag-anak sida it kayake. Ingpangayanan nida kali nak Ruben dahil napasiling sida, “Nakita it GINO-O kag ako kalisor ag ngasing nak nataw-aney nako kag ako asawa it anak, sabaling apalanggaoney ako nida.” ");
INSERT INTO bno_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Masunor, nagsabak ray si Lea ag nag-anak sida it kayake gihapon. Ingpangayanan nida kali nak Simeon dahil napasiling sida, “Dahil narunggan it GINO-O nak ako ay ing-iihig, kada ingtaw-an ray Nida ako it usa pang anak nak kayake.” ");
INSERT INTO bno_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ag nagsabak ray sida liwat ag kayake gihapon kag ida anak. Kali ay ida ingpangayanan nak Levi dahil napasiling sida, “Ngasing, mayungotey nak gador sa ako kag ako asawa dahil ingtaw-aney nako sida it tatlong anak nak kayake.” ");
INSERT INTO bno_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Masunor, nagsabak ray sida liwat ag nag-anak it kayake gihapon. Kali ay ida ingpangayanan nak Juda dahil napasiling sida, “Ngasing, adayawon nako kag GINO-O.” Ag nagtungon anay kag ida pagsabak. ");
INSERT INTO bno_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Pagkakita ni Raquel nak waya sida naaanaki ni Jacob, sida ay nahili sa ida maguyáng, kada nagsiling sida kang Jacob, “Taw-e ako it anak, dahil kung indi ay mamamatay ako!” ");
INSERT INTO bno_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Nagrayab-rayab kag kahangit ni Jacob kang Raquel ag sida ay napasabat nak, “Asi, ako baga kag Dios nak nagpiga para indi ka makaanak?” ");
INSERT INTO bno_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Medyo marugay-rugay pa gihapon nak waya nasabak si Raquel, kada nagsiling sida kang Jacob, “Kali kag ako kabulig nak si Bilha. Aubayan nimo sida agor parayan sa ida magkakainggwa ra ako it anak.” ");
INSERT INTO bno_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ag ingta-o ngani nida kag ida kabulig nak si Bilha agor maging asawa ni Jacob, ag kali ay ida ging-ubayan. ");
INSERT INTO bno_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Si Bilha ay nagsabak kang Jacob ag nag-anak it kayake. ");
INSERT INTO bno_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ag nagsiling si Raquel, “Ako ay ingpaburan it Dios kada Ida ingrungog kag ako pangamuyo ag ingtaw-an ako Nida it anak,” kada ingpangayanan nida kaling anak nak Dan. ");
INSERT INTO bno_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nagsabak ray si Bilha it pangruha ag nag-anak it kayake gihapon. ");
INSERT INTO bno_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nagsiling ngasing si Raquel, “Naglabanan kami it ako manang, ag nagraog ako,” kada ingpangayanan nida kaling anak nak Naptali. ");
INSERT INTO bno_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","It katong nakita ni Lea nak waya ray sida nasabak, ingta-o ra nida kag ida kabulig nak si Zilpa agor maging asawa ni Jacob. ");
INSERT INTO bno_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nagsabak si Zilpa kang Jacob ag nag-anak kali it kayake. ");
INSERT INTO bno_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ag nagsiling si Lea, “Talagang maswerte ako!” kada ingpangayanan nida kaling anak nak Gad. ");
INSERT INTO bno_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nagsabak ray si Zilpa it pangruha ag nag-anak it kayake gihapon. ");
INSERT INTO bno_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Nagsiling ngasing si Lea, “Abang sadya talaga ako! Asilinggon it mga tawo nak ako ay nasadyahan,” kada ingpangayanan nida kaling anak nak Aser. ");
INSERT INTO bno_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Usang adlaw sa panahon it tig-ani it trigo, nagpagto si Ruben sa bukir ag nakakita sida it mga tanom nak mandragora nak kali ay buyong nak pangpasabak. Nagbinaoy sida it kali ag ingraya sa ida nanay nak si Lea. Pagkakita ni Raquel, nagsiling sida kang Lea, “Mahagar baga be it pilang bilog nak mandragora nak raya it imo anak.” ");
INSERT INTO bno_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Pero nagsabat si Lea, “Buko ka pa kunteno nak pati ako asawa ay ing-agaw pa nimo? Ngasing, pati kaling mandragora nak raya it ako anak ay imo pa aagawon?” Nagsabat si Raquel, “Puydi kamong mag-ubay isag sa gab-i, basta't taw-e yang ako it kina.” ");
INSERT INTO bno_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Pag-abot ni Jacob it katong hapon halin sa bukir, ingsapoy-sapoy sida ni Lea ag nagsiling, “Isag sa gab-i ay sa ako ka maubay dahil ingbadaraney ka nako kang Raquel it mga mandragora nak raya it ako anak,” kada pagkagab-i sinra kag nag-ubay. ");
INSERT INTO bno_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ag ingrunggan it Dios kag pangamuyo ni Lea, kada nagsabak ag nag-anak ray sida it panglimang anak nak kayake kang Jacob. ");
INSERT INTO bno_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nagsiling si Lea, “Ingpremyuhan ako it Dios dahil ingta-o nako sa ako asawa kag ako kabulig,” kada ingpangayanan nida kaling anak nak Isacar. ");
INSERT INTO bno_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ag nagsabak ray si Lea ag nag-anak it pang-an-om nak kayake. ");
INSERT INTO bno_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Nagsiling ngasing sida, “Ingtaw-an ako it Dios it maadong regalo, kada ngasing siguradong importantey ako sa ako asawa dahil nataw-aney nako sida it an-om nak mga anak nak kayake,” kada ingpangayanan nida kali nak Zabulon. ");
INSERT INTO bno_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ag nag-anak pa sida it usang kabade nak ida ingpangayanang Dina. ");
INSERT INTO bno_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Sa huli ay naluoy ra kag Dios kang Raquel ag ingrungog nida kag pangamuyo it kali, kada nagsabak sida. ");
INSERT INTO bno_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nag-anak sida it usang kayake, ag nagsiling sida, “Ingbaoy it Dios kag ako kahud-anan.” ");
INSERT INTO bno_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ingpangayanan nida kaling anak nak Jose, dahil napasiling sida, “Kabay pa nak rugangan it GINO-O it usa pa kaling ako anak.” ");
INSERT INTO bno_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Pagkaanak ni Raquel kang Jose, nagpamuhon si Jacob sa ida panugangan nak si Laban, “Sugtey akong makapauli sa ako sariling panimayay ruto sa lugar nak ako inghalinan. ");
INSERT INTO bno_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Panunta sa ako kag ako mga asawa nak ako ingserbisyuhan sa imo, ag ako mga anak, ag papauli-ay ako. Ayam nimo nak taposey kag ako pagserbisyo sa imo.” ");
INSERT INTO bno_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Pero nagsabat si Laban, “Runggi anay kag ako ibisaya sa imo. Sa ako pagbuhat naayaman nako nak ingpakamaado ako it GINO-O dahil sa imo. ");
INSERT INTO bno_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kada silinggan sa ako kung ni-o kag imo gustong suhoy ag ako kato ita-o sa imo, basta hali yang kamo.” ");
INSERT INTO bno_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Nagsabat si Jacob, “Ikaw mismo kag nakakaayam kung pauno ako nagtrabaho para sa imo, ag kung ni-o kag kamutangan it imo mga hadop sa ako mga damot. ");
INSERT INTO bno_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kung natatanraan pa nimo, pag-abot nako dili, apilang bilog pa yang kag imo mga hadop, pero ngasing ay karuramoey dahil ngani ingpakamaado ikaw it GINO-O dahil sa ako. Pero pauno ra kag ako sariling pamilya?” ");
INSERT INTO bno_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Nagsiling liwat si Laban, “Ni-o talaga kag imo gustong ita-o nako sa imo?” Sabat ni Jacob, “Buko kinahangyan nak taw-an ako nimo it aber ni-o. Kung masugot ka sa ako ibisaya aalagaan gihapon nako kag imo kahadupan. ");
INSERT INTO bno_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ngasing, ayamey nato nak kag karamuang karnero diling lugar ay puti, ag tungor sa mga kambing, kag karamuan ay maitom. Kada sugti ako nak magpagto sa imo mga kahadupan ngasing ag ako abuyagon kag tanang mga kambang ag maitom nak mga karnero, ag tanang mga kambing nak di tumbok-tumbok nak puti, ag imaw kali kag mapapasa-ako bilang suhoy. ");
INSERT INTO bno_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ag sa bandang huli, imo makikita kung ako ay imo masasaligan pag imo makita kag mga hadop nak imo ingsuhoy sa ako. Tanang imo makita sa ako nak buko kambang ag buko maitom nak mga karnero, ag mga kambing nak waya it tumbok-tumbok nak puti ay masisiling nimo nak ako tinakaw!” ");
INSERT INTO bno_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Nagsugot si Laban ag nagsiling, “Maado! Imaw kina kag ato ahumanon!” ");
INSERT INTO bno_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Pero it katong adlaw nak kato bag-o makapagto si Jacob sa mga kahadupan ay ingpabuyag nak raan ni Laban kag tanang mga kayake ag kabading kambing nak di tumbok-tumbok nak puti ag kag tanang mga kambang ag maitom nak karnero, ag kali'y ingpaalagaan sa ida mga anak nak kayake ag ingpadigdig sa mayado. ");
INSERT INTO bno_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nagyanat si Laban ruto sa mayadong lugar nak kung abaktason halin sa lugar ni Jacob ay tatlong adlaw bag-o maabot. Ag kag mga nabilin nida nak hadop ay ing-alagaan ni Jacob. ");
INSERT INTO bno_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nagpang-utoy si Jacob it mga yab-as nak sanga it tatlong klasing mga kahoy ag ingtalipan kag ibang parti agor makikita nak pay kambang ag imaw it apanamkunan it mga nagsasabak nak hadop. ");
INSERT INTO bno_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ingpatinrog nida kaling mga sanga sa atubangan it mga painuman it mga hadop, dahil kag inra pagkasta ay sa oras it inra pag-inom. ");
INSERT INTO bno_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kada ngani sinra ay nagkakastahan sa atubangan it katong mga sanga nak ingpatingrog ni Jacob, ag sinra ay nag-anak it mga kambang ag mga maitom nak karnero ag kambing nak di tumbok-tumbok nak puti. ");
INSERT INTO bno_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kada maanak kag hadop, inabuyag nak raan ni Jacob kag ida parti, ag kag mga nabibilin nak kang Laban ay ida inapaatubang sa mga kambang ag mga maitom nak karnero ag sa mga kambing nak di tumbok-tumbok nak puti, agor maanak ra sinra it tuyar sa inra perming nakikita. Nagramo kag ida mga hadop ag ida ingbuyag kali sa mga hadop ni Laban. ");
INSERT INTO bno_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Inabutang yang ni Jacob katong mga sanga sa mga painuman pag kag mga guyang nak naglalandi ay katong mga makusog ag maado it yawas, agor makastahan sinra sa tunga it mga sanga. ");
INSERT INTO bno_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pero waya nida gibubutangan katong mga sanga kung kag mga guyang nak naglalandi ay katong mga mahinay. Ngani, kag mga mahinay nak hadop ay kang Laban ag kag mga makusog nak hadop ay kang Jacob. ");
INSERT INTO bno_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ag nagpakayaman nak gador si Jacob ag nagpakaramo kag ida mga karnero ag kambing, mga kamelyo ag asno, pati kag ida mga suguon nak kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Nakaabot kang Jacob nak ingsiling kuno it ida mga bayaw nak ida ingtakaw kag mga hadop it inra tatay ag tanang manggar nida ay halin kuno sa inra tatay. ");
INSERT INTO bno_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Namasran ra nida nak yabotey kag pagtratar sa ida ni Laban. ");
INSERT INTO bno_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Usang adlaw, nagsiling kag GINO-O kang Jacob, “Pauliey ruto sa lugar it imo tatay ag imo mga hali, ag Ako kag maiba sa imo.” ");
INSERT INTO bno_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kada, ingpapagto ni Jacob si Raquel ag si Lea sa bukir nak ida ing-aagsaman it mga hadop, ");
INSERT INTO bno_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ag ruto ay nagsiling sida sa inra, “Namasran nako nak yabotey kag pagtratar sa ako it inro tatay, bukoey tuyar it katong una. Pero sa yudo it kali, kaibahan gihapon nako permi kag DIOS it ako tatay. ");
INSERT INTO bno_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ayam ra ninrong ruha nak panghugot-hugot kag ako pagpangabudlay para sa inro tatay, ");
INSERT INTO bno_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","pero sa yudo it kaling tanan, ingrada gihapon ako nida. Karamong beses nak ida ingbag-o kag ako suhoy, pero waya gisugti it Dios nak ako ay mapayain. ");
INSERT INTO bno_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ngani, ako kali apamatuuran sa inro: Pag inasiling it inro tatay nak, ‘Kambang kag imo magiging suhoy,’ ay kag tanang ing-aanak nak hadop ay kambang. Pag inasiling ray nidang, ‘Mga di tumbok-tumbok nak puti kag imo mga suhoy,’ ay kag tanang ing-aanak nak hadop ay di tumbok-tumbok nak puti ra. ");
INSERT INTO bno_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tuyar kina kag parayan it pagbawi it Dios sa mga hadop it imo tatay ag pagta-o sa ako.” ");
INSERT INTO bno_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Siling pa ni Jacob, “It katong panahon it paglandi it mga hadop, ako ay nagpananamgo nak inggwa kuno it mga kambang ag mga maitom nak takay nak karnero, ag mga takay nak kambing nak di tumbok-tumbok nak puti nak nagpangkasta sa mga guyang. ");
INSERT INTO bno_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sa ako pananamgo, ay ing-ayaba kuno ako it anghel it Dios nak, ‘Jacob!’ ag nagsabat ako it, ‘Hali ako!’ ");
INSERT INTO bno_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ag siling kuno it Dios, ‘Muyati kag kulay it mga takay nak nagkasta sa mga guyang. Tanan sinra ay kambang dahil naayaman nako nak ikaw ay ingraradaan ni Laban. ");
INSERT INTO bno_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ako kag Dios nak nagpakita sa imo sa Betel, kung hariin ikaw nagpatinrog it bato bilang tanra it Ako pagpakita sa imo it kato, ag imo ingbub-an it lana kag ibabaw it kato, ag kung hariin ikaw nagpromisa sa Ako. Ngasing, haliney dili ag bumalik sa lugar kung hariin ikaw natawo.’ ” ");
INSERT INTO bno_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Nagsabat sina Raquel ag Lea, “Wayaey it nabilin para sa amo nak apanublion kang tatay. ");
INSERT INTO bno_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Kag ida pagtratar sa amo ay pay buko matuor nak mga anak. Pay ida kami ingbaligya ag ing-ubosey nida kag tanang kwarta nak ingbadar nimo sa ida bilang kabaydo namo. ");
INSERT INTO bno_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tanang mga hadop ag manggar nak ingbawi it Dios sa amo tatay ay talagang dapat yang nak mapapasa-amo ag sa amo mga anak. Kada kung ni-o kag sugo sa imo it imo Dios ay masugot kami.” ");
INSERT INTO bno_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","19","Usang adlaw inghuyat anay ninrang makahalin si Laban papagto sa lugar nak ingtutupihan ninra it mga karnero, ag naghanra sinra sa paghalin. Pagkahanra ninra, ingpangsakay ni Jacob kag ida mga anak ag mga asawa sa mga kamelyo, ag ingpadigdig nida kag ida tanang mga naparting hadop ag ingpangraya ra kag ida tanang napundar nak ari-arian sa Padan-aram, ag nagginan sinra papauli sa Canaan kung hariin kag ida tatay nak si Isaac. Bag-o sinra naghalin, sumuyor si Raquel sa kwarto it ida tatay ag ida ingbaoy kag mga maintik nak ribulto it mga dios-diosan it ida tatay. ");
INSERT INTO bno_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nausahan ni Jacob kag ida panugangan nak Aramnon nak si Laban dahil nakahalin sinra it waya namalaye it kali. ");
INSERT INTO bno_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Gingraya nida tanang ida ari-arian ag rali-rali sinra it halin. Nagtabok sinra sa Suba it Yuprates ag nagpadayon papagto sa kabukiran it Gilead. ");
INSERT INTO bno_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nakalipasey kag tatlong adlaw bag-o nasaduran ni Laban nak sina Jacob ay naglayas. ");
INSERT INTO bno_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ingnunot nida kag ida mga hali ag inra ingyagor sina Jacob. Sa pangpitong adlaw, nakaabot sinra sa kabukiran it Gilead ag naantawey ninra sina Jacob. ");
INSERT INTO bno_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Pagkagab-i it katong pangpitong adlaw, nagpakita kag Dios kang Laban nak Aramnon sa parayan it pananamgo, ag nagsiling sa ida, “Panimati-i Ako, aya nak gador gibisar-i si Jacob, ag badaey nak gador sida gihadluka!” ");
INSERT INTO bno_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Pagkahapon it masunor nak adlaw, inabutan nina Laban sina Jacob. Nagtukor sina Jacob it inra mga tolda sa kabukiran it Gilead, ag imaw ra sina Laban. ");
INSERT INTO bno_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Nagpangutana si Laban kang Jacob, “Ni-o kaling imo inghuman sa ako? Asing imo ako ingluko, ag ingtakas pa nimo kag ako mga anak nak pay mga bihag sa gera? ");
INSERT INTO bno_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Asing imo ako ingluko ag waya nimo gipasaduran kag inro paghalin, ag wayang gador kamo it pupamuhon? Tan-a'y nagta-o anay ako sa inro it despidida ag kita'y nagkinasadya ag nagkinanta nak inggwa't mga tamborin ag gitara. ");
INSERT INTO bno_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ag asing wayang gador ako nimo gitaw-i it pagkakataon nak maharuan kag ako mga anak ag ako mga apo? Pay wayang gador nimo gipag-isipi kaling imo inghimo! ");
INSERT INTO bno_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kung ako agustuhon kaya ka nako nak hapruson, pero kag Dios it imo tatay ay nagbisaya sa ako it gab-i ag nagsiling, ‘Panimati-i ako, aya nak gador gibisar-i si Jacob, ag badaey nak gador sida gihadluka!’ ");
INSERT INTO bno_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","“Ag ngasing, basta yang ikaw naghalin dahil ikaw ay inapakabuyongey sa imo mga pinalangga. Pero asing pati katong ako mga ribulto ay imo pa ingtakaw?” ");
INSERT INTO bno_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Nagsabat si Jacob kang Laban, “Naghalin ako nak waya gipamuhon dahil nahadlok ako sabaling imo apiliton nak bawion kag imo mga anak sa ako. ");
INSERT INTO bno_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pero tungor rutong ribulto nak imo ingsasana sa amo, kung sin-o sa amo kag imo makitaan it kali ay mamamatay. Ag sa atubangan it ato mga hali, kilay-a kag imo mga butang ag bay-on.” Waya nasasaduri ni Jacob nak si Raquel kag nagbaoy it mga ribulto ni Laban. ");
INSERT INTO bno_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ngani, ingpakahanap ni Laban kag ida mga ribulto, una ay sa tolda anay ni Jacob, masunor ay sa tolda ni Lea. Ingpanghanap ra kato ni Laban sa tolda it katong ruhang kabulig, ag masunor sa tolda ray ni Raquel. ");
INSERT INTO bno_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","It katong pagbaoy ni Raquel sa mga ribulto ay ida kato ingpangtago sa irayom it montura nak ida inggagamit sa pagsakay sa kamelyo. Pagsuyor ni Laban sa ida tolda ay ida iningkuran katong muntura ag nagpanghakar si Laban sa tanang rugo pero waya nida nakita kag ida ginghahanap. ");
INSERT INTO bno_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Nagsiling si Raquel sa ida tatay, “Tay, kabay pang indi ikaw mahangit sa ako kung indi ako magtinrog sa imo atubangan dahil inggwa ako.” Kada aber ni-o nida it panghakar, wayang gador nida nakita kag ida mga ribulto. ");
INSERT INTO bno_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ngasing, sa kahangit ni Jacob, sida ay naimpito ag ida ingsura si Laban sa pagsiling, “Ni-o kag ako nahuman nak mayain sa imo? Niong gador kag ako sala asing abang hangit ka ag imo pa ako ingyagor? ");
INSERT INTO bno_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Sa imo pagbusikar it tanang amo mga butang, inggwa ka baga it nakita nak halin sa imo? Butangan kina rili sa atubangan it ako mga hali ag imo mga hali, agor mahusgaran ninra kung sin-o kag matarong sa atong ruha. ");
INSERT INTO bno_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Sa suyor it beynteng tuig nak ruto ako sa imo, waya nak gador nako gipabad-e nak maagasan kag imo mga guyang, ag waya nak gador ako nakaihaw it imo hadop nak takay. ");
INSERT INTO bno_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kung inggwa man it nasisiba it ilahas, ako kag nag-aako it kato, buko ikaw, kada ako kag nalulugi. Ag kung inggwa man it natatakaw sa adlaw o sa gab-i, imong gador kato gingpapabadaran sa ako. ");
INSERT INTO bno_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tuyar kag ako kamutangan sa imo. Sa adlaw ay naagwanta ako it init ag sa gab-i ay nagtitiis ako it yamig, ag halos indi ako makakatuyog sa pagbantay sa imo mga hadop. ");
INSERT INTO bno_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","“Sa suyor it kaling beynteng tuig, ako ay asa irayom it imo puder. Katorseng tuig ako nak nagserbisyo para sa imo ruhang anak, ag an-om nak tuig akong nagserbisyo sa imo agor mabaoy nako kag imo suhoy nak mga hadop sa ako, ag karamong beses nak imo ingbag-o-bag-o kag ako suhoy. ");
INSERT INTO bno_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kung buko nako kakampi kag Dios nak ingkakahadlukan it ako tatay nak si Isaac, nak Dios ra it ako Lolo Abraham, siguro ingpalayasey nimo ako nak waya't karaya-raya. Nakita it Dios kag ako kahirapan ag kag ako kahugor ag it gab-i ingsaway ka Nida.” ");
INSERT INTO bno_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Nagsabat si Laban, “Ako kali mga anak, ako kali mga apo, ako kali mga hadop, ag tanang imo nakikita ay ako! Pero ni-o pa ngasing kag ako mahuhuman dili sa ako mga anak ag mga apo? ");
INSERT INTO bno_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Maado pa kung mahimo yangey kita it kasugtanan, ag imaw kali kag ato arumrumon agor indi kita mag-away.” ");
INSERT INTO bno_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kada, nagbaoy si Jacob it bato ag kali ay ida ingpatinrog bilang tanra it inra kasugtanan. ");
INSERT INTO bno_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ingpabaoy ra nida kag ida mga hali it mga bato ag ingpatumpok sa inra. Pagkatapos, ruto sinra gikaon sa tinumpok nak bato. ");
INSERT INTO bno_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ingtawag kali ni Laban nak Jegar-sahaduta, sa bisayang Aramnon, ag ingtawag kali ni Jacob nak Galeed sa bisayang Hebreo. ");
INSERT INTO bno_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kali ay ingtawag ni Jacob nak Galeed, dahil siling ni Laban, “Kaling tinumpok nak bato ay nagpapamatuor it kasugtanan nato nak ruha.” ");
INSERT INTO bno_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Kaling ingpatinrog nak bato ay ingtawag ni Jacob nak Mizpa, dahil sa ingbisaya ni Laban nak, “Kabay pang bantayan kitang ruha it GINO-O sa ato pagbinuyagan. ");
INSERT INTO bno_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kung imo ahapruson kag ako mga anak o kung mag-asawa pa ikaw it ibang kabade, aber waya't tawo nak mag-uma sa ako, rumruma nak nakikita it Dios kag imo inghuhuman.” ");
INSERT INTO bno_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Pagkatapos, nagsiling ray si Laban kang Jacob, “Tanra-e kaling ato ingtumpok nak bato ag kaling tanra nak bato sa tunga nato. ");
INSERT INTO bno_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kaling tinumpok nak bato ag kaling tanra nak bato ay imaw it giryunan nato ag imaw it mapamatuor nak indi ako magyaktaw papanha sa imo, ag ikaw ay indi ra magyaktaw papali sa ako para mag-inaway yang kitang ruha. ");
INSERT INTO bno_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kag Dios it imo Lolo Abraham, ag kag Dios it ako Lolo Nahor, ay imaw it mahusgar sa imo ag sa ako.” Ngani, nagsumpa si Jacob sa atubangan it Dios nak ingkakahadlukan it ida tatay nak si Isaac, ");
INSERT INTO bno_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ag nagmatay sida it hadop bilang inughalar para sa Dios ruto sa bukir. Ingtawag nida kag ida mga hali agor makaon ag nagtiner pa sinra ruto it usang gab-i. ");
INSERT INTO bno_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Aga pang gador it katong masunor nak adlaw, naghanra sina Laban sa pagpanaw. Bag-o sida naghalin, ingpangharuan anay nida kag ida ruhang anak nak kabade ag kag ida mga apo, ag sinra ay ida ingbendisyunan bag-o sinra nagginan papauli. ");
INSERT INTO bno_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Pagkatapos, nagpadayon sina Jacob sa inra pagpauli ag ingsapoy sinra it mga anghel it Dios. ");
INSERT INTO bno_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Pagkakita ni Jacob sa inra, sida ay napasiling, “Kali kag mga sundalo it Dios!” Kada ida ingpangayanan katong lugar nak Mahanaim, nak kag gustong bisayahon ay “Ruhang Grupo it mga Sundalo.” ");
INSERT INTO bno_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ruto sa lugar it Seir sa Edom kung hariin nag-iistar kag ida maguyáng nak si Esau, ay nagpauna si Jacob it mga suguon. ");
INSERT INTO bno_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Sinra ay ida ingtugon, “Imaw kali kag inro ibisaya sa ako pinalanggang maguyáng nak si Esau. Inro isiling nak kag ida nganat suguong manghor nak si Jacob ay paabuton halin sa ida pag-istar sa ida Tiyo Laban. ");
INSERT INTO bno_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ag inro isiling sa ida nak inggwa ako it mga baka, mga asno, ag iba pang mga hadop, ag mga suguon nak kayake ag kabade. Imaw kali kag inro isiling sa ako pinalanggang maguyáng agor sa ako pag-abot ay ida ako abatunon it maado.” ");
INSERT INTO bno_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nagpadayon sinra ag bag-o sinra nakatabok sa Suba it Jaboc, nagbalik kag mga suguon ag nag-uma sinra kang Jacob, “Nakaabot kami sa imo maguyáng nak si Esau ag papaley sida agor ikaw ay sapuyon, ag kaibahan nida kag ap-at nak gatos nak kakayakihan.” ");
INSERT INTO bno_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kada abang kahadlok ni Jacob ag abang kalibog. Ngani, ida ingparti sa ruhang grupo kag ida mga tawuhan pati kag ida mga karnero, mga kambing, mga baka ag mga kamelyo. ");
INSERT INTO bno_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Dahil ida ing-iisip nak kung masapoy ni Esau kag usang grupo ag ida kali pangmatyon, kag usang grupo ay makakatakas. ");
INSERT INTO bno_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kada, nagpangamuyo si Jacob, “Dios it ako Lolo Abraham ag Dios it ako tatay nak si Isaac, GINOONG Dios nak nagsiling sa ako, ‘Pauliey sa lugar it imo mga hali ag apakamaaduhon ikaw Nako,’ ");
INSERT INTO bno_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","buko ako angay sa imo kaaduhan ag sa katutom nak Imo ingpakita sa ako nak Imo suguon. Pagtabok nako it kato sa Suba it Jordan, waya ako it ibang raya kundi bakulo. Pero ngasing sa ako pagbalik, kami ay naging ruhang grupoy. ");
INSERT INTO bno_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","GINO-O, buligi ako ag libriha ako sa damot it ako maguyáng. Napakahadlok ako sa ida, sabaling kaming tanan ay ida matyon pati kag ako mga asawa ag mga anak. ");
INSERT INTO bno_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Di baga nagsiling nak gador Ikaw sa ako nak, ‘Apakamaaduhon ka Nako ag aparamuon Nako kag imo mga inanak, tuyar sa ramo it baybay sa ragat nak indi mabilang-bilang.’ ” ");
INSERT INTO bno_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ngani, pagkagab-i ruto sinra nagpahuway, ag pagkaaga, sida ay nagpili it mga hadop nak ipatabo kang Esau. ");
INSERT INTO bno_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ag kali kag ida mga napili nak inugpatabo: Ruhang gatos nak guyang nak kambing, beynteng takay nak kambing, ruhang gatos nak guyang nak karnero, beynteng takay nak karnero, ");
INSERT INTO bno_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","treyntang guyang nak kamelyo nak nagpapasuso raya kag inra mga anak, kwarentang rumayagang baka, sampuyong tureting turo, beynteng guyang nak asno ag sampuyong turong asno. ");
INSERT INTO bno_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Kaling tanan ay ida ing-intrigo sa ida mga suguon. Buyag-buyag kag bawat usang klase't hadop nak di agwat sa bawat usang grupo. Ag ingtugon nida kag ida mga suguon, “Una kamo sa ako nak di agwat kag bawat usang grupo, pero sunor-sunor.” ");
INSERT INTO bno_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ida ingtugon kag primerong grupo it mga suguon, “Pag masapoy kamo it ako maguyáng nak si Esau, ag magpangutana sida sa inro nak, ‘Sin-o kag inro Amo? Pariin kamo? Si-o kag tag-iya it kali?’ ");
INSERT INTO bno_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Masabat kamo, ‘Kali ay halin sa imo suguong manghor nak si Jacob. Kali kag ida patabo para sa ida pinalanggang maguyáng nak si Esau, ag sida ay hinaey sa amo hulihan nak nagsusunor.’ ” ");
INSERT INTO bno_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ag imaw ra kag ida ingtugon sa pangruha, pangtatlo ag iba pang nagsusunor nak mga manugdigdig it mga hadop, “Imaw ra kag inro isiling kang Esau pag magsapuyan kamo. ");
INSERT INTO bno_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ag aya ra ninro gilimti nak magsiling, ‘Hina sa amo hulihan kag imo suguong manghor nak si Jacob nak nagsusunor.’ ” Kag ida ing-iisip ay sabaling mabaoy kag kahangit sa ida ni Esau parayan diling mga patabo nak ida ingpauna, ag pag sinra ay magkita, sida ay batunon it ida maguyáng. ");
INSERT INTO bno_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kada ngani ida ingpauna it patabok katong mga patabo, dahil sida ay mapalipas pa it gab-i sa lugar nak inra ingpahuwayan. ");
INSERT INTO bno_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","It katong gab-i nak kato, ingnunot nida kag ida ruhang asawa, kag inra ruhang kabulig, kag ida onseng anak nak kayake, ag ida ingpatabok sa mababaw nak parti it Suba it Jaboc. ");
INSERT INTO bno_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","It katong sinrang tanan ay nakatabokey, ingpatabok ra nida kag tanang inra mga ari-arian. ");
INSERT INTO bno_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tong nakatabokey kag tanan, sida ay nagbalik nak ausa sa lugar nak inra ingpahuwayan. Katong gab-ing kato, inggwa it nag-abot nak usang kayake nak nagpuraso sa ida hastang sa pagpanghudag-hudag. ");
INSERT INTO bno_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","It katong nabatyagan it kaling kayake nak indi nida maraog si Jacob, ay ida yinubag kag yuta sa pa-a ni Jacob habang sinra ay nagpupuraso, kada kali ay nayuat ag sida ay napaki. ");
INSERT INTO bno_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ag nagsiling katong kayake, “Buhiey ako dahil nagpapanghudag-hudagey.” Pero nagsabat si Jacob, “Indi nako ikaw gibuhian hastang waya pa nimo ako nabibendisyune.” ");
INSERT INTO bno_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nagpangutana katong kayake, “Ni-o kag imo ngayan?” Nagsabat sidang, “Jacob.” ");
INSERT INTO bno_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nagsiling ray kag kayake, “Tuna ngasing, bukoey Jacob kag imo ngayan kundi Israeley, dahil ikaw ay nagpakiglaban sa Dios ag sa mga tawo, ag ikaw kag nagraog.” ");
INSERT INTO bno_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Masunor, nagpangabay ra si Jacob sa ida, “Umaan ra sa ako kag imo pangayan.” Pero nagsabat sida, “Asing imo pa ingpapangutana kag ako ngayan?” Ag pagkatapos, ida gingbendisyunan si Jacob. ");
INSERT INTO bno_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kada, ingpangayanan nida katong lugar nak Peniel, dahil sa ida pagsiling nak, “Nakaatubang nako kag Dios ag buhi pa gihapon ako.” ");
INSERT INTO bno_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Nasubataney si Jacob it adlaw bag-o sida nakahalin sa Peniel nak nagkikiang, dahil nayuat sida sa pa-a. ");
INSERT INTO bno_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Imaw kali kag rason kung asing hastang ngasing kag mga Israelinhon ay waya gikakaon it habit sa pigi it hadop, dahil diling parti it yawas gingyubag si Jacob kada napaki. ");
INSERT INTO bno_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Pagbalik ni Jacob sa ida pamilya, naantaw nida si Esau nak paabuton, kaibahan kag ap-at nak gatos nak kayake. Kada ingbuyag-buyag nida sina Lea ag Raquel ag inra mga anak, ag kag ruhang kabulig ag inra mga anak. ");
INSERT INTO bno_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ingbutang nida sa unahan kag ruhang kabulig ag inra mga anak, sunor si Lea ag ida mga anak, ag sa pinaka-huli ay si Raquel ag kag ida anak nak si Jose. ");
INSERT INTO bno_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Si Jacob kag asa unahan ninrang tanan, ag habang nagyuyungot sinra ni Esau ay makapitong beses sida nak nagsuong bilang pagta-o it respito hastang magtabo sinrang magmanghor. ");
INSERT INTO bno_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Pero nagrayagan si Esau pasapoy sa ida. Si Jacob ay ida ingkupkupan ag ingharuan, ag sinrang ruha ay nagtibaw-tibawan. ");
INSERT INTO bno_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","It katong nakita ni Esau kag mga kabade ag mga anak, sida ay nagpangutana, “Si-o kaling mga kanunot nimo?” Nagsabat si Jacob, “Sa kaaduhan it Dios, kali kag ako mga asawa ag mga anak nak Ida ingta-o sa ako.” ");
INSERT INTO bno_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kag ida unang ingpapayungot ay kag ida ruhang kabulig ag kag inra mga anak ag sinra ay nagsuong bilang pagta-o it pagrespito kang Esau. ");
INSERT INTO bno_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kag masunor nak ida ingpapayungot nak nagta-o it pagrespito ay si Lea ag kag ida mga anak, ag kag huli nak nagpayungot ag nagsuong ay si Raquel ag si Jose. ");
INSERT INTO bno_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Pagkatapos, nagpangutana si Esau, “Ni-o katong mga nasapoy nako nak mga karamo-ramong sunor-sunor nak grupo it mga hadop?” Nagsabat si Jacob, “Manong, imaw kato kag ako mga patabo sa imo, pramas imo ako batunon.” ");
INSERT INTO bno_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Pero nagsabat si Esau, “Maramoey kag ako mga hadop, kada sa imo yangey kato.” ");
INSERT INTO bno_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Nagsiling ray si Jacob, “Indi puyde! Talagang kato ay para sa imo. Kung talagang imo'y ako napatawar, batuna kato. Nasasadyahan ako nak maado kag imo pagbaton sa ako, ag pagkakita nako sa imo, ay pay nakita ra nako kag uda it Dios. ");
INSERT INTO bno_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Batuna yangey kag ako mga patabo, dahil ingpakamaado ra ako it Dios ag husto pa para sa among tanan kag mga nabilin.” Ingpakapilit nak gador nida si Esau hastang ingbaton nida kag mga patabo ni Jacob. ");
INSERT INTO bno_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Pagkatapos, nagsiling si Esau, “Kitay, mabalikey kita sa amo. Sunorey kamo sa amo.” ");
INSERT INTO bno_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Pero nagsiling si Jacob, “Manong, nakita nimo nak kaling ako mga anak ay maintik pa, kada mahinay magpanaw. Nalilibog ra ako rili sa mga hadop nak nagpapasuso, ag kung ato sinra sahuyon, sabaling mamatay sinra. ");
INSERT INTO bno_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Maado pa Manong, una yangey ikaw ag kami ay masunor sa imo, kumporme sa tulin it pagpanaw it kaling mga hadop ag imaw ra kaling ako mga anak, hastang makaabot kami sa inro sa Seir.” ");
INSERT INTO bno_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Nagsabat si Esau, “Hala, kung imaw kina kag imo gusto, apanuntan yangey kamo nako sa iba nakong mga tawo.” Pero nagsiling ray si Jacob, “Badyangey Manong, salamat yangey nak gador!” ");
INSERT INTO bno_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kada nag-una yangey sina Esau papauli sa Seir it katong adlaw nak kato. ");
INSERT INTO bno_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Pero sina Jacob ay nagbihang papagto sa ibang lugar ag ruto sida gipatinrog it bayay ag mga pasilungan it hadop, kada kaling lugar ay inra ingtawag nak Sucot. ");
INSERT INTO bno_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Pagkalipas it pilang panahon ay naghalin sina Jacob sa Sucot ag nagpadayon papagto sa banwa it Siquem nak sakopey it Canaan. Sa huli ay nakaabotey ra si Jacob sa Canaan pagkatapos it ida mahabang biyahe papauli halin sa Padan-aram. Nagpahuway ag nagtukor sinra it inra mga tolda sa usang lugar ruto bag-o mag-abot sa banwa. ");
INSERT INTO bno_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Katong duta nak ida ingtukuran it inra mga tolda ay ingbakay ni Jacob sa mga anak it pinuno it Siquem nak si Hamor nak Hebinhon. Ingbakay kali ni Jacob it usang gatos nak bilog it inra kwarta. Usa sa mga anak ni Hamor ay si Siquem. ");
INSERT INTO bno_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ruto ay nagsug-on-sug-on si Jacob it mga bato agor maging altar ag ingtawag nida kato nak El-Elohe-Israel, nak kag gustong bisayahon ay “Dios nak Imaw kag Dios ni Israel.” ");
INSERT INTO bno_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Usang adlaw, kag anak nak rayaga ni Jacob kang Lea ay nagpamasyar ag nagpakig-amiga sa mga rayaga nak taga-ruto sa lugar nina Hamor. ");
INSERT INTO bno_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Pagkakita sa ida ni Siquem nak anak it inra pinuno nak si Hamor, kali ay ida ingharangan ag ingpilit nak magnunot sa ida. Ag kaling rayaga ay ida ingpilit nak mag-ubay sa ida. ");
INSERT INTO bno_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Napagusto si Siquem kang Dina ag kali ay ida ingpalangga. Ida ing-amo-amo si Dina ag inghuman nida kag tanan agor sida ay magustuhan it kali. ");
INSERT INTO bno_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ngani, nagpangabay si Siquem sa ida tatay nak si Hamor, “Tay, gusto nako nak pakasayan kaling rayaga. Puyding patigayunon yangey kami nimo.” ");
INSERT INTO bno_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","It katong nasaduran ni Jacob kag natabo sa ida anak nak si Dina ay naghipos yang anay sida, dahil kag ida mga anak nak kayake ay rahagto pa sa bukir nak nagbabantay it ida mga hadop. ");
INSERT INTO bno_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Bag-o nag-abot kaling mga anak nak kayake ni Jacob, ay nag-abot sina Hamor ag ida anak nak si Siquem agor mapakigbisaya kang Jacob. ");
INSERT INTO bno_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Habang nagbibisaya si Hamor kang Jacob, imaw ra it pag-abot it mga anak nak kayake ni Jacob halin sa bukir. Pagkarungog ninra sa natabo sa inra manghor, nagrayab-rayab kag inra kahangit dahil kali ay usang marakong kahud-anan para sa lahi ni Israel. ");
INSERT INTO bno_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Pero nagsiling si Hamor sa inra, “Palangga talaga it ako anak nak si Siquem kag inro anak nak rayaga, kada nagpapangabay ako sa inro nak ato yangey sinra ipakasay. ");
INSERT INTO bno_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ag maado ra kung magkasugot kita nak puyding mag-asawa kag amo mga sultero sa inro mga rayaga, ag kag inro ra mga sultero sa amo mga rayaga. ");
INSERT INTO bno_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Sa tuyar nak parayan, puydey kamong mag-istar dili ag libre kamong magpangabuhi rili sa amo duta. Ag puyde ra kamong magpamakay ag magbinaligya sa amo banwa ag magpundar ra it inro mga ari-arian.” ");
INSERT INTO bno_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ag nagbisaya ra si Siquem kang Jacob ag sa mga maguyáng nak kayake ni Dina, “Sugot yangey ra kamo sa ako pangabay, ag aber ni-o kag inro ahagaron ay ako ita-o sa inro. ");
INSERT INTO bno_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Silinggan yang ninro sa amo kung ni-o kag inro gustong regalo sa pagpakasay nako sa inro manghor, ag aber ni-o pa kag inro gustong hagaron. Hanra akong magta-o sa inro it tanan, basta ipakasay yang ninro sida sa ako.” ");
INSERT INTO bno_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kaling mga anak nak kayake ni Jacob ay nagsabat it pabayagbag kang Siquem ag sa ida tatay nak si Hamor, dahil ingtaw-an ninra it kahud-anan kag inra manghor nak si Dina. ");
INSERT INTO bno_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kada nagsiling sinra, “Indi kami magsugot nak kag kayaking mapapangasawa it amo manghor ay buko tuli, dahil kali ay kahud-anan parti sa amo. ");
INSERT INTO bno_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Masugot yang kami kung kag inro tanang mga kayake ay mapatuli ra pareho sa amo. ");
INSERT INTO bno_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Pag mahimo ninro kali, hingan pa yang kami masugot nak mainasawahan kita ag kita ay mapisan nak nagkakausa. ");
INSERT INTO bno_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pero kung indi kamo magsugot nak magpatuli ay abawion namo si Dina ag kami ay mahalin dili.” ");
INSERT INTO bno_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Namut-an ni Hamor ag ni Siquem nak ida anak kag inra ingbisaya, kada sinra ay nagsugot nak mapatuli. ");
INSERT INTO bno_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Dahil abang gusto ni Siquem kaling anak ni Jacob nak si Dina, kada wayaey sida giruyog. Ag sa mga anak ni Hamor, si Siquem yang kag mapanubli it pagka-pinuno. ");
INSERT INTO bno_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Pagkatapos, nagpauli nak raan sina Hamor ag Siquem, ag inra gingtipon kag kakayakihan sa suyor it pwertahan it inra banwa, ag ingsiling, ");
INSERT INTO bno_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Mga kasimanwa, kaling mga tawo ay mabuot, kada maado kung apaistaron nato sinra rili ag sugtan nak magpamakay ag magbinaligya rili. Kayapar ra kaling ato duta. Apapangasawahon nato kag ato mga sultero sa inra mga rayaga ag imaw ra kag inra mga sultero sa ato mga rayaga. ");
INSERT INTO bno_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","“Pero kaling mga tawo ay masugot yang nak maistar dili ag maiba sa ato, kung kitang tanan nak mga kayake ay masugot nak tulion tuyar sa inra. ");
INSERT INTO bno_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Indi baga sa huli, kag inra mga hadop ag mga ari-arian ay mapapasa-ato? Kada sugot yangey kita agor dili sinra mag-istar sa ato.” ");
INSERT INTO bno_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ag tanan ngani nak mga kayake it inra banwa ay nagsugot sa ingsiling ni Hamor ag ni Siquem, ag nagpatuli sinrang tanan. ");
INSERT INTO bno_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Sa pangtatlong adlaw it pagkatuli sa inra, it katong sinra'y nagpapahapros pa, kag mga anak ni Jacob nak sina Simeon ag Levi nak ruha sa matuor nak mga maguyáng ni Dina, ay nagraya it espada ag nagyusob sa banwa. Waya gisasaligi it mga taga-banwa nak mayain kag inra tuyo. Ingpangmatay ninra kag tanang mga kayake ruto. ");
INSERT INTO bno_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ingmatay ra ninra si Hamor ag kag ida anak nak si Siquem, ag ingbaoy ninra si Dina sa bayay nina Siquem ag nagtakas. ");
INSERT INTO bno_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Pagpagto sa banwa it ibang mga anak nak kayake ni Jacob ay inra nakita kag mga ingpangmatay nak mga kayake ruto. Ingpangtakawan ninra kag banwa bilang bayos sa kahud-anan nak natabo sa inra manghor. ");
INSERT INTO bno_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ingraya ra ninra kag tanang mga hadop, ag aber ni-o nak nakita ninra sa suyor it banwa ag sa mga uma sa palibot. ");
INSERT INTO bno_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ingbaoy ninra kag tanang manggar, ingbihag ninra kag tanang mga kabade ag mga maintik nak anak ag waya sinra't ingtura. ");
INSERT INTO bno_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Pagkatabo it kali nagbisaya si Jacob kana Simeon ag Levi, “Asing ingtaw-an ako ninro it kalibugan ag inro ako ingpakahud-an sa pagmuyat it mga Canaanhon ag mga Pereznon dili. Apila yang kag ako mga tawuhan, ag kung sinra ay magkausa nak yusubon kita, kitang tanan ay mamamatay.” ");
INSERT INTO bno_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pero nagrason sinra, “Tay, apabad-an yangey baga nato nak himuon nidang pay tuyar sa kabading badaran kag amo manghor?” ");
INSERT INTO bno_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Pagkatabo it kali, nagsiling kag Dios kang Jacob, “Pagto sa Betel ag ruto mag-istar. Ikaw ay mahuman it batong altar para sa Ako nak imo Dios nak nagpakita sa imo it katong ikaw ay nagtakas sa imo maguyáng nak si Esau.” ");
INSERT INTO bno_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kada, ingsugo ni Jacob kag ida pamilya ag tanang ida sinakupan, “Pilakan ninro kag tanang mga ribulto nak inro mga dios-diosan, himua ninrong limpyo kag inro mga sarili sa atubangan it Dios ag mag-ilis it limpyong baro. ");
INSERT INTO bno_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pagkatapos, mapagto kita sa Betel, kung hariin ako ay mahuman it batong altar pramas madayaw kita sa Dios nak nagsabat it ako pangamuyo it katong ako ay nahihirapan, ag imaw ra kag nagbabantay sa ako aber hariin ako nagpagto.” ");
INSERT INTO bno_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ngani, ingta-o ninra kang Jacob kag inra tanang mga ribulto ag inra mga panika nak panguntra kuno sa mayaot, ag kaling tanan ay ida ingpangyubong sa irayom it katong marakong kahoy nak abang bantog ruto mayungot sa Siquem. ");
INSERT INTO bno_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pagkatapos nak ingtuman ninra kali, naghalin sinra sa Siquem. Ag habang nagrarayan sinra sa mga banwa papagto sa Betel, kag mga tawo sa mga banwa ay nakabatyag it rakong kahadlok nak halin sa Dios, kada waya nak gador ninra gilahaya katong mga anak ni Jacob. ");
INSERT INTO bno_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Pag-abot ninra sa Betel, nak it kato ay Luz pa kag inra tawag, ");
INSERT INTO bno_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","naghuman sinra it batong altar ag nagdayaw sinra sa Dios. Ingtawag nida katong lugar nak El-Betel, nak kag gustong bisayahon ay Dios it Betel, dahil hagto kag Dios ay nagpakita sa ida it katong sida ay nagtakas kang Esau. ");
INSERT INTO bno_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","It kag sinra ay rahagto, namatay si Debora nak dating manug-alaga it nanay ni Jacob nak si Rebeca. Ingyubong ninra sida sa irayom it puno it usang kahoy sa ubos it Betel, ag ingtawag nida katong kahoy nak Alon-ba-cut, nak kag gustong bisayahon ay “Kahoy it Kalisuran.” ");
INSERT INTO bno_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ngasing nak nagbalik si Jacob sa Canaan halin sa Padan-aram, nagpakita liwat kag Dios sa ida ag sida'y ingpakamaado. ");
INSERT INTO bno_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nagsiling kag Dios sa ida, “Kag imo ngayan ay Jacob, pero tuna ngasing ay bukoey Jacob kag itawag sa imo kundi Israel.” ");
INSERT INTO bno_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nagsiling pa kag Dios sa ida, “Ako kag Dios nak Makagagahom. Magpakaramo kamo. Kag imo mga inanak ay magiging usang nasyon ag magkakainggwa't maramong lahi nak mahalin sa imo mga inanak, ag kag iba sa inra ay magiging mga hari. ");
INSERT INTO bno_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kaling duta nak Ako ingta-o sa imo Lolo Abraham ag sa imo tatay nak si Isaac, ay ita-o ra Nako sa imo ag sa imo magiging mga inanak.” ");
INSERT INTO bno_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Pagkasiling it Dios it kali, nawagit Sida sa ida atubangan. ");
INSERT INTO bno_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Masunor, nagpatinrog si Jacob it bato bilang tanra ruto sa lugar nak kung hariin kag Dios ay nagpakig-istorya sa ida. Ingbub-an kali nida it halar nak ayak ag ingbub-an ra nida it lana. ");
INSERT INTO bno_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kali kag lugar nak ida ingtawag nak Betel. ");
INSERT INTO bno_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Pagkatapos, nagpadayon sinra halin sa Betel ag it katong sinra ay mayado-yado pa sa Eprata, nagpasyapo si Raquel ag abang hirap kag ida pag-anak. ");
INSERT INTO bno_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Habang sida ay nahihirapan sa pagpasyapo, kag buot ni Raquel ay ingpaisog it paltera sa pagsiling, “Aya gikahadlok, dahil kayake ray kag imo magiging anak.” ");
INSERT INTO bno_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Habang sida ay naghihingayo, ingpangayanan nida kaling anak nak Ben-oni, nak kag gustong bisayahon ay “anak sa ako kahirapan,” pero kali ay ingpangayanan liwat ni Jacob nak Benjamin, nak kag gustong bisayahon ay “kag ako tuong damot.” ");
INSERT INTO bno_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Namatay si Raquel sa pag-anak ag sida ay ingyubong sa habig it rayan papagto sa Eprata. Ag ngasing kaling Eprata ay imawey kag Betlehem. ");
INSERT INTO bno_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kag ida yuyubngan ay ingbutangan ni Jacob it tanra nak bato ag kali ay hagto pa gihapon hastang ngasing. ");
INSERT INTO bno_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Pagkayubong kang Raquel, nagpadayon sina Jacob hastang makaabot sa unhan it tore it Eder, kung hariin sinra nagtukor it inra mga tolda. ");
INSERT INTO bno_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Habang sina Jacob ay ruto giiistar sa bandang Eder, ing-ubayan ni Ruben si Bilha nak usa sa mga asawa it ida tatay. Imaw kali kag kabulig ni Raquel. Pagkasador ni Jacob it kaling inghimo ni Ruben ay abang kahangit nida. Dose tanan kag mga anak nak kayake ni Jacob. ");
INSERT INTO bno_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Kag mga anak nak kayake ni Lea ay si Ruben, nak imaw kag panganay, masunor si Simeon, si Levi, si Juda, si Isacar ag si Zabulon. ");
INSERT INTO bno_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Kag mga anak nak kayake ni Raquel ay sina Jose ag Benjamin. ");
INSERT INTO bno_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Kag mga anak nak kayake ni Bilha nak kabulig ni Raquel ay sina Dan ag Naptali. ");
INSERT INTO bno_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Kag mga anak nak kayake ni Zilpa nak kabulig ni Lea ay sina Gad ag Aser. Kali sinra kag mga anak nak kayake ni Jacob ag tanan sinra ay natawo sa Padan-aram, puyra yang kang Benjamin. ");
INSERT INTO bno_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nagpauli sina Jacob sa ida tatay nak si Isaac sa duta ni Mamre, nak imaw ra kag Kiriyat-arba o Hebron, kung hariin ra giistar si Abraham. ");
INSERT INTO bno_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Nag-abot si Isaac sa edad nak usang gatos ag otsenta (180) nak tuig, ");
INSERT INTO bno_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","bag-o sida namatay sa ida kaguyangon, ag nagpahuwayey kapisan kag ida mga ginikanan. Kag pagyubong sa ida ay ingpatigayon it ida mga anak nak sina Esau ag Jacob. ");
INSERT INTO bno_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Kali kag mga inanak ni Esau nak kag palayaw ay Edom. ");
INSERT INTO bno_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nag-asawa si Esau it mga kabading Canaanhon. Kali ay si Ada nak anak ni Elon nak Hetanhon, si Oholibama nak anak ni Ana ag apo ni Zibeon nak Hebinhon, ");
INSERT INTO bno_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ag si Basemat nak anak ni Ismael ag hali ni Nebayot. ");
INSERT INTO bno_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Kag anak nak kayake ni Esau kang Ada ay si Elipaz. Kag anak nak kayake ni Esau kang Basemat ay si Reuel, ");
INSERT INTO bno_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ag kag mga anak nak kayake ni Esau kang Oholibama ay sina Jeus, Jalam ag Core. Imaw kali tanan kag mga anak nak kayake ni Esau nak natawo sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ingnunot ni Esau kag ida mga asawa, mga anak nak kayake ag kabade, ag ida mga sinakupan. Ingraya ra nida kag ida tanang kahadupan ag tanang mga ari-arian nak ida napundar ag naghalin sa Canaan, agor magpayado sa ida manghor nak si Jacob. ");
INSERT INTO bno_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nagpayado sida dahil kag inra kahadupan ag mga ari-arian ay subrang ramoey, ag kung magpisan sinra ay mahuotey ag makuyang kag sabsabon. ");
INSERT INTO bno_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kada ruto sa mabatong mga bukir it Seir giistar si Esau nak kag tawag ra ay Edom. ");
INSERT INTO bno_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Kali kag mga inanak ni Esau nak imaw kag tatay it mga Edomnon nak nagpang-inistar sa mabatong mga bukir it Seir. ");
INSERT INTO bno_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Si Elipaz kag anak nak panganay ni Esau nak kag nanay ay si Ada, masunor ay si Reuel nak kag nanay ay si Basemat. ");
INSERT INTO bno_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Kag mga anak nak kayake ni Elipaz ay sina Teman, Omar, Zepo, Gatam ag Kenaz. ");
INSERT INTO bno_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Si Timna ay usa sa mga asawa ni Elipaz ag kag ida anak nak kayake ay si Amalek. Kali kag mga apo ni Esau sa mga anak nida kang Ada. ");
INSERT INTO bno_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Kag mga anak nak kayake ni Reuel ay sina Nahat, Zera, Sama ag Miza. Kali kag mga apo ni Esau sa mga anak nida kang Basemat. ");
INSERT INTO bno_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Kag iba pang mga anak nak kayake ni Esau ay sina Jeus, Jalam ag Core, ag kag inra nanay ay si Oholibama nak anak ni Ana ag apo ni Zibeon. ");
INSERT INTO bno_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Imaw kali kag mga pinuno sa lahi ni Esau. Sa mga inanak ni Elipaz nak panganay ni Esau kag mga naging pinuno ay sina Teman, Omar, Zepo, Kenaz, ");
INSERT INTO bno_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Core, Gatam ag Amalek. Sinra kag mga pinuno sa lugar it Edom sa mga inanak ni Elipaz nak anak ni Esau kang Ada. ");
INSERT INTO bno_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Sa mga inanak ni Reuel nak anak ni Esau kag mga naging pinuno ay sina Nahat, Zera, Sama ag Miza. Sinra kag mga pinuno sa lugar it Edom sa mga inanak ni Reuel nak anak ni Esau kang Basemat. ");
INSERT INTO bno_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Sa mga anak ni Esau kang Oholibama nak anak ni Ana kag mga naging pinuno ay sina Jeus, Jalam ag Core. ");
INSERT INTO bno_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Sinra tanan kag mga naging pinuno sa mga inanak ni Esau, nak kag palayaw ay Edom. ");
INSERT INTO bno_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Bag-o nag-abot sina Esau sa Seir ay inggway it dating mga nag-iistar ruto. Sinra ay mga Horhanon nak kag tatay ay si Seir. Kag mga inanak nak kayake ni Seir ay sina Lotan, Sobal, Zibeon, Ana, Dison, Ezer ag Disan. ");
INSERT INTO bno_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Sinra kag mga pinuno it mga Horhanon sa mga lahi ni Seir sa lugar it Edom. ");
INSERT INTO bno_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Kag mga anak nak kayake it panganay ni Seir nak imaw si Lotan ay sina Hori ag Heman. Si Timna nak usa sa ibang asawa ni Elipaz nak imaw kag panganay nak anak ni Esau ay hali nak kabade ni Lotan. ");
INSERT INTO bno_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Kag mga anak nak kayake ni Sobal ay sina Alvan, Manahat, Ebal, Sepo ag Onam. ");
INSERT INTO bno_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Kag mga anak nak kayake ni Zibeon ay sina Aya ag Ana. Si Ana ay imaw kag nakakita it katong tuburan it mainit nak tubi sa mabatong mga bukir habang sida ay nag-aagsam it mga asno it ida tatay. ");
INSERT INTO bno_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Kag mga anak it kaling si Ana nak putong anak ni Zibeon ay si Dison ag kag ida hali nak kabade nak si Oholibama nak naging asawa ni Esau. ");
INSERT INTO bno_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Kag mga anak nak kayake ni Dison ay sina Hemdan, Esban, Itran ag Keran. ");
INSERT INTO bno_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Kag mga anak nak kayake ni Ezer nak imaw kag anak ni Seir ay sina Bilhan, Zaavan ag Akan. ");
INSERT INTO bno_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Kag mga anak nak kayake ni Disan ay sina Uz ag Aran. ");
INSERT INTO bno_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Imaw kali kag mga pinuno sa mga lahi it mga Horhanon sa lugar it Seir nak sina Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO bno_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Ezer ag Disan. ");
INSERT INTO bno_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Imaw kali kag mga naghari sa lugar it Edom bag-o pa magkainggwa it usang hari kag mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Kag unang naging hari sa Edom ay si Bela nak anak ni Beor. Kag ida banwa ay Dinaba. ");
INSERT INTO bno_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Pagkamatay ni Haring Bela, kag nagsubli sa ida ay si Jobab nak anak ni Zera nak taga-Bozra. ");
INSERT INTO bno_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Pagkamatay ni Haring Jobab, kag nagsubli sa ida ay si Husam nak taga-Teman. ");
INSERT INTO bno_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Pagkamatay ni Haring Husam, kag nagsubli sa ida ay si Hadad nak anak ni Bedad. Sida kag nakapirde sa lahi ni Midian nak imaw kag anak ni Abraham kang Ketura sa lugar it Moab. Kag ida banwa ay Avit. ");
INSERT INTO bno_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Pagkamatay ni Haring Hadad, kag nagsubli sa ida ay si Samla nak taga-Masreca. ");
INSERT INTO bno_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Pagkamatay ni Haring Samla, kag nagsubli sa ida ay si Saul nak taga-Rehobot sa habig it Suba it Yuprates. ");
INSERT INTO bno_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Pagkamatay ni Haring Saul, kag nagsubli sa ida ay si Baal-hanan nak anak ni Acbor. ");
INSERT INTO bno_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Pagkamatay ni Haring Baal-hanan nak anak ni Acbor, kag nagsubli sa ida ay si Hadar. Kag asawa nida ay si Mehetabel nak anak ni Matred ag apo ni Mezahab. Kag ida banwa ay Paw. ");
INSERT INTO bno_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Imaw kali kag mga pinuno sa mga inanak ni Esau, kumporme sa inra mga lahi ag lugar. Kag mga naging pinuno ay sina Timna, Alva, Jetet, ");
INSERT INTO bno_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO bno_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO bno_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel ag Iram. Sinra tanan kag mga pinuno it mga Edomnon nak naghalin kang Esau, kumporme sa mga lugar nak inra nasakupan. ");
INSERT INTO bno_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","It kato ay nag-istar sina Jacob, nak ingtatawag rang Israel, mayungot sa banwa it Hebron sa Canaan nak imaw kag dating ingtineran it ida tatay nak si Isaac. ");
INSERT INTO bno_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Imaw kali kag istorya tungor sa pamilya ni Jacob. It katong kag ida anak nak si Jose ay disi-syete anyosey, sida ay nagbabantay it mga karnero ag mga kambing it ida tatay. Kaibahan nida kag ida mga maguyáng nak anak nina Bilha ag Zilpa nak ibang mga asawa it ida tatay. Ayam nida kag mayain nak inghihimo it ida mga maguyáng ag sida ay nag-uuma sa inra tatay. ");
INSERT INTO bno_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Si Jose kag pinaka-palanggang anak ni Israel sa tanang ida mga anak, dahil sida ay naging anak ni Israel sa ida kaguyangon. Ngani, gingpatahian nida si Jose it maganda ag mahabang baro nak mahaba ra it butkon. ");
INSERT INTO bno_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","It katong nakita it ida mga maguyáng nak sa inrang magmanghor si Jose kag ingpapaka-palabi it inra tatay, nahangit sinra sa ida ag permi sidang ingbibisayahan ninra it mayain. ");
INSERT INTO bno_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Usang gab-i, nagpananamgo si Jose ag tong gingsiling nida kaling ida pananamgo sa ida mga maguyáng, lalong nagpakarako kag inra kahangit sa ida. ");
INSERT INTO bno_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Siling ni Jose sa inra, “Panimati-i ninro kaling ako isiling tungor sa ako ingpananamgo. ");
INSERT INTO bno_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Habang hagto kuno kita sa bukir nak nagbubugkos it ato mga inanihan nak trigo, katong ako kuno binugkos ay nagtinrog ag nakita ra nako nak gingpalibutan kuno kali it inro mga binugkos nak trigo ag sinra ay masigsuong sa ako binugkos.” ");
INSERT INTO bno_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Siling sa ida it ida mga maguyáng, “Ni-o, ikaw kag mahari sa amo?” Lalo nak nagpakarako kag inra kahangit sa ida dahil sa ida pananamgo ag sa ida ingbisaya. ");
INSERT INTO bno_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nagpananamgo ray liwat sida ag kali ay ingsiling ray nida sa ida mga maguyáng. Siling nida, “Panimati-i ray ninro kaling ako isiling sa inro. Ako ay nagpananamgo ray, kag adlaw kuno, pati kag buyan ag onseng bituon ay nagsusuong sa ako.” ");
INSERT INTO bno_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Pero it katong ida kali ingsiling sa ida tatay ag sa ida mga maguyáng, sida ay ingsaway it ida tatay sa pagsiling, “Ni-o kaling imo pananamgo? Asi, masinuong baga kami it imo nanay ag mga maguyáng sa imo atubangan?” ");
INSERT INTO bno_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ag nahili sa ida katong ida mga maguyáng pero katong ingbisaya ni Jose sa ida tatay ay natanom sa ida isip. ");
INSERT INTO bno_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Usang adlaw, katong mga maguyáng ni Jose ay nagpagto sa bukir it Siquem agor mag-agsam it inra mga karnero ag kambing. ");
INSERT INTO bno_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ag nagsiling si Israel kang Jose, “Maley anay nak apapagtuon ka nako ruto sa imo mga maguyáng nak nag-aagsam sa Siquem.” Nagsabat si Jose, “Oho, Tay.” ");
INSERT INTO bno_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ag nagsiling ray kag ida tatay, “Pagtoy. Muyati ruto kung maado kag kamutangan it imo mga maguyáng, pati ra katong ato mga kahadupan, ag pagbalik nimo rili ay uma-e ako.” Kada halin sa patag it Hebron sida'y nagbaktas papagto sa Siquem. ");
INSERT INTO bno_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Pag-abot nida sa Siquem ay wayaey ruto kag ida mga maguyáng. Pero inggwa't usang tawo nak nakakita kang Jose nak nagpapanglingat-lingat ag kali ay nagpangutana sa ida, “Asi, si-o kag imo ginghahanap?” ");
INSERT INTO bno_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nagsabat ni Jose, “Ka ako mga maguyáng. Ayam baga nimo kung hariin sinra giagsam it amo mga karnero ag kambing?” ");
INSERT INTO bno_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nagsiling katong tawo, “Naghaliney sinra rili ag narunggan nako katong inra ingsiling nak sinra kuno ay mapagto sa Dotan.” Nagyanat ngasing si Jose sa ida mga maguyáng ag sinra ay ida nakita ruto sa lugar it Dotan. ");
INSERT INTO bno_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Habang mayado pa sida ay naantawey sida it ida mga maguyáng. Ag habang sida ay nagpapayungot ay inra ingplanuhan nak amatyon sida. ");
INSERT INTO bno_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nagbisaya sinra sa usa'g-usa, “Haley kaling perming pananamgo! ");
INSERT INTO bno_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Maley, amatyon nato sida, ag pagkatapos ay ato ihuyog sa usang bal-ong. Ag ato isiling nak sida ay ingsiba it usang ilahas nak hadop. Ag ato amuyatan kung matutupar matuor katong ida mga pananamgo.” ");
INSERT INTO bno_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Pero tong marunggan kali ni Ruben nak pinaka-panganay ninra, sida ay nagbisaya, “Indi nato sida gimatyon.” Imaw kali kag ida gingsiling pramas mapigahan kag ida mga manghor. ");
INSERT INTO bno_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Siling pa ni Ruben sa inra, “Badaey sida gimatya! Ihuyog yangey nato sida sa usang bal-ong nak uga rili sa kabukiran.” Kali kag gingsiling ni Ruben agor sa huli ay malilibre nida si Jose sa inra plano nak pagmatay agor makabalik sida sa inra tatay. ");
INSERT INTO bno_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Pag-abot ni Jose ruto sa ida mga maguyáng ay inra ingpigong ag inra ing-uba katong ida maganda ag mahabang baro. ");
INSERT INTO bno_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Pagkatapos ay ingraya sida sa usang bal-ong nak waya't tubi ag inra inghuyog. ");
INSERT INTO bno_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Pagkatapos, sinra ay nag-ingkor ag nagkaoney. Sa pag-antaw ninra sa mayado ay nakita ninra kag paabutong grupo it mga Ismaelinhon nak sunor-sunor nak nakasakay sa inra mga kamelyo halin sa lugar it Gilead. Kag karga it inra mga kamelyo ay mga himuong buyong, mga panamda, pabangyo ag mga insenso nak aray-on sa bansa it Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Pagkakita sa inra ni Juda, nagbisaya kali sa ida mga hali. Siling ni Juda, “Ni-o kag ato mapapakamos kung ato amatyon kaling ato manghor ag itago kag ida yawas? ");
INSERT INTO bno_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Maado pa siguro ay ibaligya yangey nato sida sa mga Ismaelinhon agor buko sa ato damot sida mamamatay, dahil ato ra sida manghor ag ato ra sida karugo.” Ag nagsugot katong ida mga hali. ");
INSERT INTO bno_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Pagrayan it kinang mga negosyante nak mga Ismaelinhon halin sa lahi ni Midian, ay inra ingpagtuan si Jose rutong bal-ong kung hariin ninra inghuyog sida ag inra ingbatak. Masunor ay inra ingbaligya si Jose sa mga Ismaelinhon sa balor nak beynteng (20) bilog nak pilak. Ag sida ay ingrayay papagto sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Pagkatapos nak natabo kali, kumo si Ruben ay waya ruto, sa ida pagbalik, sida ay nagsil-ip rutong bal-ong pero wayaey ruto si Jose. Sa nak raan inggisi nida kag ida baro bilang pagpakita it ida pagkalibog, ");
INSERT INTO bno_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ag nagbalik sa ida mga manghor. Siling nida, “Wayaey ruto si Jose! Mauno yangey ako?” ");
INSERT INTO bno_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Naghinuon ngasing sinra ag ingbaoy ninra katong ing-uba ninra nak baro kang Jose ag nag-ihaw sinra it usang kambing, bag-o gingpahiran katong baro ni Jose it rugo. ");
INSERT INTO bno_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ag inra gingraya katong baro nak di rugo ag ingpakita sa inra tatay. Siling ninra, “Nakita namo kali! Muyati baga kung imaw kali kag baro it imo anak o buko.” ");
INSERT INTO bno_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nakilaya ni Jacob katong baro ag sida'y napasiling, “Sa ako anak kali! Sida ay nasiba it ilahas nak hadop! Siguradong ginggumok it kato kag yawas ni Jose.” ");
INSERT INTO bno_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Sa kalisor ni Jacob, kumporme sa inra sulunranon sa pagpangalisor sa inra minatay, ay ida inggisi kag ida baro ag nag-apli sida it kustal. Ing-abot it maramong adlaw kag ida pagpangalisor. ");
INSERT INTO bno_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Inglibang sida it tanan nidang kaanakan, pero ingbaliwaya nida kali. Kag siling nida, “Bad-ey ninro ako iglibanga! Mapangalisor ako hastang bawion it Dios kag ako kabuhi ag magkita ray kami it ako anak.” Ag padayon kag ida pagtibaw. ");
INSERT INTO bno_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Habang nagpapangalisor si Jacob sa Canaan, si Jose ay nakaabotey ruto sa Ehipto ag sida ay ingbaligya ray it mga Ismaelinhon kang Potipar nak imaw kag pinaka-pinuno it mga gwardya sa palasyo it Hari it Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","It katong panahon rang kato, nagbuyag si Juda sa ida mga hali ag sida ay nagpangdayunan sa usang taga-Adulam nak si Hira. ");
INSERT INTO bno_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Rahagto nakita ni Juda kag rayagang anak it usang Canaanhon nak si Sua. Ing-asawa nida kali. ");
INSERT INTO bno_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ag kaling asawa ni Juda ay nagsabak ag nag-anak it kayake ag kali ay ingpangayanan nak Er. ");
INSERT INTO bno_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sa pangruhang pagsabak nida ay kayake gihapon kag ida naging-anak ag kali ay ingpangayanan nak Onan. ");
INSERT INTO bno_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nagsabak ray sida liwat ag kayake gihapon kag ida naging anak ag kali ay ingpangayanan nak Sela. Rahagto sinra sa lugar it Kizib it katong ing-anak si Sela. ");
INSERT INTO bno_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","It katong maragkoey sinra, kag panganay ni Juda nak si Er ay ida ingpaasawa sa usang rayaga nak si Temar. ");
INSERT INTO bno_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pero kaling si Er ay mayain kag inghuhuman sa atubangan it GINO-O kada sida ay ingmatay. ");
INSERT INTO bno_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Pagkatabo it kali, nagsiling si Juda kang Onan, “Kumporme sa ato sulunranon, kinahangyan nak asawahon nimo kag balo it imo maguyáng ag imo sida aanakan sa ida pangayan.” ");
INSERT INTO bno_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ayam ni Onan nak kung magkaanak sida sa balo it ida maguyáng ay indi matawag nak ida. Ngani, bawat maubay sinra it ida asawa, nak dating asawa it ida maguyáng ay ing-uudak nida kag ida similya sa raga. Ginghimo nida kato agor indi sida magkainggwa't anak nak imaw kag maraya it pangayan it ida maguyáng. ");
INSERT INTO bno_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Kumo mayain katong ida ginghimo sa pagmuyat it GINO-O, kaling si Onan ay gingmatay ra Nida. ");
INSERT INTO bno_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Pagkatabo it kali, nagsiling si Juda sa ida umagar nak si Temar, “Badaey anay giasawa liwat ag ruto ka yang anay sa imo tatay hastang waya pa narako katong ako puto nak kayake nak si Sela.” Nahadlok si Juda nak sabaling mamatay ra si Sela pareho sa ida mga maguyáng kung ipaasawa ray nida kang Temar. Ngani, nagpauli si Temar sa bayay it ida tatay ag rutoy sida giistar. ");
INSERT INTO bno_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sa pagligar it panahon, namatay kag asawa ni Juda nak anak ni Sua, ag katong wayaey sida gipapangalisor, sida ay nagtukar ruto sa banwa it Timna nak kung hariin ay ruto sinra gititipon pramas patupihan kag inra mga karnero. Kag ida kaibahan pagpagto ay kag ida amigo nak si Hira nak taga-Adulam. ");
INSERT INTO bno_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","It katong masaduran ni Temar nak mapa-Timna katong ida panugangan agor magpatupi it ida mga karnero, ");
INSERT INTO bno_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","nakaisip sida nak ubahon katong pangluto nida nak baro ag mag-alimungmong agor matabunan kag ida uda. Masunor, nagpagto sida sa rayan pasuyor it banwa't Enaim nak rayanan papagto sa Timna. Sida ay nag-ingkor ruto sa habig it rayan. Inghimo nida kali dahil naayaman nida nak si Sela ay marakoey, pero waya ra gipaasawahan sa ida. ");
INSERT INTO bno_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","It katong nakita sida ni Juda, kabi it kali si Temar ay usa sa mga badaran nak kabade, dahil natatabunan kag ida uda. ");
INSERT INTO bno_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ingsuuran sida ni Juda ruto sa habig it rayan ag nagsiling, “Kitay sa imo bayay.” Waya nida naayami nak imaw kali kag ida umagar. Siling ni Temar, “Ni-o kag imo ibadar sa ako agor makakanunot ikaw sa ako?” ");
INSERT INTO bno_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Sabat ni Juda, “Iparaya nako sa imo kag usang anak it ako kambing.” Nagsiling si Temar, “Puydi, pero magbilin anay ikaw it imo gamit bilang prinda nimo sa ako.” ");
INSERT INTO bno_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Nagpangutana si Juda, “Ni-o kag imo gusto?” Sabat ray nida, “Kag imo singsing nak pangpirma nak nakabitin sa imo kulintas ag kag imo baston.” Ngani, ingta-o ni Juda kaling tatlong bagay sa ida ag sinra ay nag-ubay. Pagkatapos nagbangon si Temar ag nagpauliey. Ing-uba nida katong ida alimungmong ag nagsuksok ray it katong ida baro nak pangluto. Ag pagkalipas it panahon namalayan nida nak sida ay sabakey yaki dahil ing-aptan nak raan sida. ");
INSERT INTO bno_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Pramas mabaoy ruto sa kabade katong ida ingpangbilin nak mga gamit, ingparaya ni Juda katong anak it kambing sa ida amigo nak si Hira nak taga-Adulam, pero wayaey ruto katong kabade. ");
INSERT INTO bno_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nagpangutana si Hira sa mga kayake ruto, “Hariiney katong kabade nak nagpapabadar nak rahagto sa rayan papagto sa Enaim?” Siling ninra sa ida, “Waya ra it tuyar nak kabade dili.” ");
INSERT INTO bno_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kada, nagbalik sida kang Juda ag nag-uma it tuyar kali, “Wayaey ruto katong kabade nak imo ingpapabadaran it kaling kambing. Ag siling it mga tawo rutong lugar ay waya kuno it tuyar nak kabade ruto.” ");
INSERT INTO bno_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Sabat ni Juda, “Badyangey. Ida yangey katong ako mga gamit, sabaling gur-an pa kita it mga tawo pag apakahanapon pa nato sida. Basta ayam nimo nak ako ingparaya kaling anak it ako kambing, pero wayaey nimo sida nakita ruto.” ");
INSERT INTO bno_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Pagkalipas it tatlong buyan, Inggwa't nag-uma kang Juda nak katong ida umagar nak si Temar ay nagpangayake ag nagsabak. Siling ni Juda, “Liwasan sida sa banwa ag sunugon.” ");
INSERT INTO bno_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Habang gingliliwas si Temar ay nagpauna sida it mensahe para sa ida panugangan, “Kag tag-iya it kaling mga gamit nak rahali sa ako ay imaw kag nakasabak sa ako. Pamuyati kung kanin-o kali, kaling kulintas, kaling singsing nak nakapabitin dili, ag kaling baston.” ");
INSERT INTO bno_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ing-ako ni Juda kaling mga gamit ag nagsiling sida, “Mas maado kag ida ginghimo kisa ako kumo waya ako gisugot nak mapangasawa nida kag ako anak nak si Sela.” Ag tuna it kato wayaey giubay si Juda kang Temar. ");
INSERT INTO bno_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","It katong adlaw nak nagpapasyapoey si Temar, namasran it paltera nak kapir kag suyor it ida bituka. ");
INSERT INTO bno_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ag it katong sida ay nagpapatawoy, gingliwas it katong usang anak kag ida damot ag inghigtan kali it paltera it puyang bunang ag nagsiling nak, “Imaw kali kag naunang nagliwas.” ");
INSERT INTO bno_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pero gingsuyor liwat it anak katong ida damot ag nagpuslot katong ida kakapir. Nagsiling katong paltera, “Ni-o kaling imo nauuna-una it puslot!” Kada ida ingpangayanan sida nak Perez ag sida kag panganay. ");
INSERT INTO bno_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Masunor ay nagpuslot ray katong ida manghor nak di puyang bunang sa damot. Kag ingpangayan sa ida ay Zera. ");
INSERT INTO bno_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ngasing, kaling si Jose ay gingraya sa Ehipto it mga Ismaelinhon ag ingbaligya kang Potipar. Sida ay pinaka-pinuno it mga gwardya sa palasyo it Hari it Ehipto nak ingtatawag ninrang Paraon. ");
INSERT INTO bno_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Si Jose ay ruto giistar sa bayay ni Potipar nak ida amo. Naging kaibahan nida ruto kag GINO-O kada naging maado kag ida kamutangan ruto. ");
INSERT INTO bno_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nakita it amo ni Jose nak kaibahan nida kag GINO-O ag imaw it nagpapauswag sa tanan nida nak inghuhuman. ");
INSERT INTO bno_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ngani, naging maado kag pagmuyat kang Jose it ida amo ag sida ay inghuman nak pangsariling kabulig, masunor manugpasulit it ida bayay ag manugrumaya it tanan nida nak mga ari-arian. ");
INSERT INTO bno_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Magtuna it kato ay gingpakamaado it GINO-O kag panimayay ni Potipar alang-alang kang Jose. Ag kag ida tanang ari-arian ag mga uma ay ingpakamaado ra it GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kada ida inintrigo sa puder ni Jose kag tanang kasablagan sa ida panimayay. Ag habang rahagto sida kang Potipar waya nak gador si Potipar it ibang ingkakalibgan kundi kag ida akaunon yang. Ag ngasing si Jose ay gwapo ag marako it yawas. ");
INSERT INTO bno_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ngani, sida ay namut-an it asawa it ida amo ag kali ay nagsiling sa ida, “Kitay sa ako higraan.” ");
INSERT INTO bno_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pero ida gingpaindian katong asawa it ida amo ag nagsiling sida, “Habang rahali ako sa bayay it ako Amo ay waya sida it dapat ikalibog miskan ni-o mang bagay rili sa ida bayay. Dahil kag tanan nak ida ari-arian ay ida ing-intrigo sa ako. ");
INSERT INTO bno_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Wayaey it nakakataas sa ako sa pwesto rili nak panimayay. Waya ra sida it gingbabawal sa ako aber ni-o man purya yang sa imo dahil ikaw ay ida asawa. Pauno nako mahuhuman kaling marakong kayainan ag kasal-anan sa atubangan it Dios?” ");
INSERT INTO bno_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Aber ingtitintar sida it kaling kabade adlaw-adlaw ay waya nida giiintyendiha ag waya ra sida ginununot sa ida higraan, ag waya sida nirurungan sa ida. ");
INSERT INTO bno_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Usang adlaw ay nagsuyor si Jose sa bayay agor magtrabaho. Waya it ibang kayake ruto. ");
INSERT INTO bno_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ginghawiran sida sa baro it kaling asawa it ida amo ag nagsiling, “Kitay sa ako higraan.” Sa nak raan ay nagrayagan si Jose paliwas it bayay, pero nabaoy it kabade katong baro ni Jose. ");
INSERT INTO bno_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Pagkakita nida nak nagrayagan si Jose paliwas it bayay ag hudot nida katong ida baro, ");
INSERT INTO bno_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","sa nak raan ay ida ing-ayaba katong ibang suguon nak kayake it ida asawa ag sida ay nag-uma sa inra. Siling nida, “Muyati ninro, gingray-an yang kita rili it ako asawa it usang ulipon nak Hebreo nak imaw kag nagpangluko sa ato. Ingpagtuan ako it kaling tawo sa ako higraan kada nagpakaukaw ako. ");
INSERT INTO bno_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tong narunggan nida nak nagpakaukaw ako, sida ay nagrayagan paliwas it bayay ag ida nabilin kaling ida baro.” ");
INSERT INTO bno_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Pagkatapos, inghipir it kaling kabade kag baro ni Jose hastang magpauli kag ida asawa. ");
INSERT INTO bno_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Pag-abot ni Potipar, imaw kali kag ing-uma sa ida, “Katong imo ingraya dili nak suguong Hebreo ay nagsuyor it kuman sa ako kwarto pramas ako'y abusuhon. ");
INSERT INTO bno_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Pero it tong ako ay nag-ukaw, sida ay nagrayagan paliwas it bayay ag kaling ida baro ay nabilin sa ako.” ");
INSERT INTO bno_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Katong marunggan ni Potipar kag ingbisaya it ida asawa kumayarkar kag ida rugo sa kahangit. ");
INSERT INTO bno_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ngani, ingparakop nida si Jose ag ingpapriso ruto sa prisuhan it mga nakakasala sa hari. ");
INSERT INTO bno_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ag kumo kaibahan ni Jose kag GINO-O ag waya gibabalhin kag pagpalangga sa ida it GINO-O, naging maado kag pagmuyat sa ida it katong pinunong gwardya sa prisuhan. ");
INSERT INTO bno_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ging-intrigo ngasing kang Jose it katong pinunong gwardya it prisuhan kag pag-intyendi sa tanang napipriso ag kung ni-o man kag ahumanon raha sa prisuhan ay sida kag nagpapatigayon it kina. ");
INSERT INTO bno_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ingpapabad-an yang it katong pinunong gwardya it prisuhan kag tanang bagay nak gingpapatigayon ni Jose. Ag dahil kaibahan ni Jose kag GINO-O, aber ni-o kag ida inghuhuman ay inapakamaado it Dios. ");
INSERT INTO bno_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Pagkalipas it pilang panahon, inggwa't ruhang importanting tawuhan kag Hari it Ehipto nak nakasala sa ida. Nahangit kag Hari nak si Paraon sa ida ruhang importanting tawuhan nak imaw kag Punong Manugtahaw it ida inumon ag kag ida Punong Panadero. ");
INSERT INTO bno_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kada kaling ruha ay ida gingsuyor ruto sa prisuhan sa bayay it pinaka-pinuno it mga gwardya nak si Potipar, nak kung hariin ay ruto ra si Jose. ");
INSERT INTO bno_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ag kang Jose ingtugyan ni Potipar katong ruha, ag sida kag nag-iintyendi sa inra. Nagrugay sinra ruto sa prisuhan. ");
INSERT INTO bno_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Usang gab-i, katong ruhang priso nak imaw kag Punong Manugtahaw it inumon ag kag Punong Panadero ni Paraon ay parehong nagpananamgo. Buko pareho kag inra pananamgo ag kali ay inggwa it gustong bisayahon para sa inra. ");
INSERT INTO bno_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Pagkaaga, gingbisita sinra ni Jose sa prisuhan ag nakita nida katong ruha nak nababayaka. ");
INSERT INTO bno_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ingpangutana ngasing sinra ni Jose, “Asing kag inro mga uda ay pay nalilisor?” ");
INSERT INTO bno_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nagsabat sinra, “Pareho kaming nagpananamgo pero waya it tawo nak nakakapahadag it gustong bisayahon it kali sa amo.” Siling ni Jose sa inra, “Di baga kag Dios kag nagpapahadag it mga gustong bisayahon it pananamgo? Umaan baga sa ako kung ni-o kato.” ");
INSERT INTO bno_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ngani, kag unang nag-uma kang Jose ay katong Punong Manugtahaw it inumon. Siling nida, “Sa ako pananamgo ay inggwa kuno it puno it ubas sa ako atubangan. ");
INSERT INTO bno_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ag kali ay inggwa't tatlong sanga. Pagliwas kuno it alimudong, nagka-inggwa't buyak ag kag buyak ay nahimong bunga, ag kali ay nahinog. ");
INSERT INTO bno_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Hudot kuno nako kag kupa ni Paraon. Naghugot ako it hinog ag ako ingpuga sa kupa bag-o ingrawat sa hari.” ");
INSERT INTO bno_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Pagkarungog ni Jose sa ida pagpahadag, ay nagsiling sida, “Imaw kali kag gustong bisayahon it kinang imo pananamgo. Kinang tatlong sanga ay tatlong adlaw. ");
INSERT INTO bno_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Sa pangtatlong adlaw ay apaliwason ikaw ni Paraon sa prisuhan ag ibalik sa imo dating pwesto, ag imo ray itahaw sa ida katong kupa pareho sa dati nimong inghihimo bilang Punong Manugtahaw it ida inumon. ");
INSERT INTO bno_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Pag natupar kali ag ikaw ay hagtoy sa imo dating kamutangan kabay pang marurumruman ra nimo ako! Ag maluoy ka sa ako. Silinggan ra kang Paraon kag tungor sa ako agor apaliwason nida ako rili sa prisuhan. ");
INSERT INTO bno_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Dahil sa kamatuuran ako ay ingbaoy yang sa lugar it mga Hebreo ag ingraya dili sa Ehipto ag aber dili ay waya ako it nahimong sala pramas prisuhon ako dili.” ");
INSERT INTO bno_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Pagkarungog it katong Punong Panadero nak maado kag gustong bisayahon it katong pananamgo it ida kaibahan, sida ra ay nagsiling kang Jose, “Ako ay nagpananamgo ra. Inggwa kuno ako it nasusunggoy nak tatlong nigo nak puno it tinapay. ");
INSERT INTO bno_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ag katong sa pinaka-ibabaw kuno ay inggwa't iba't-ibang mga tinapay para kang Paraon ugaling gingtutuktok kuno kina it mga pispis habang ingsusunggoy nako.” ");
INSERT INTO bno_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Nagsiling si Jose, “Imaw kali kag gustong bisayahon it imo pananamgo. Katong tatlong nigo ay tatlong adlaw. ");
INSERT INTO bno_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Sa pangtatlong adlaw ay apaliwason ikaw ni Paraon sa prisuhan ag apapugutan ikaw it uyo ag kag imo yawas ay abitinon sa kahoy, ag ruto atuktukon kina it mga pispis.” ");
INSERT INTO bno_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","It tong pangtatlong adlaw ay imaw kag kumplianyo ni Paraon ag ida ginghanraan it usang pabuda katong ida mga sinakupan. Katong ida Punong Manugtahaw it inumon ag ida Punong Panadero ay pareho nidang ingpaliwas sa prisuhan. ");
INSERT INTO bno_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Katong Punong Manugtahaw it inumon ay gingbalik nida sa ida dating trabaho, ag nagtahaw ray sida it inumon kang Paraon. ");
INSERT INTO bno_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pero katong Punong Panadero ay ida gingpapugutan ag gingpabitin sa kahoy kag yawas kumporme sa ingsiling ni Jose sa inra. ");
INSERT INTO bno_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ugaling yang, wayaey narumrumi si Jose it katong Punong Manugtahaw it inumon. Sida ay nalimtaney. ");
INSERT INTO bno_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Naglipas kag ruhang tuig, ag si Paraon ay nagpananamgo ra. Sida kuno ay nagtitinrog sa habig it Suba it Nilo. ");
INSERT INTO bno_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Sa ida pananamgo ay inggwa it gulping nagyuaw nak pitong mga mataba ag magandang baka nak nagtakas halin ruto sa suba, ag sinra kuno ay nagpanabsab ruto sa inggwa't mataas nak mga hilamunon. ");
INSERT INTO bno_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Masunor ay inggwa ray kuno it gulping nagtakas halin sa suba nak pitong mga maniwang ag hilwakon it bituka nak mga baka. Nagtinrog kuno sinra sa tupar it mga naunang baka ruto sa habig it suba. ");
INSERT INTO bno_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ingkaon kuno it kinang mga maniwang ag hilwakon it bituka nak mga baka katong mga mataba ag magandang baka. Ag nakabati si Paraon. ");
INSERT INTO bno_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ag nagkatuyog ray sida ag nagpananamgo ray liwat. Inggwa kuno it usang puno it mais nak inggwa it pitong pusô ag kag bawat pasî it kali ay maragko ag matimgas. ");
INSERT INTO bno_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ag inggwa ray kuno it nagtubo nak pitong puno nak inggwa yang it tig-usang pusô ag kag pasî it kali ay maintik. Ag kali kuno ay nagpapangruyaw dahil sa mainit nak hangin halin sa disyerto sa subatan. ");
INSERT INTO bno_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kinang maragko ag matimgas nak pasî ay ingkaon kuno it katong mga maintik nak pasî. Nakabati si Paraon ag ida namalayan nak pananamgo yang yaki kato. ");
INSERT INTO bno_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ngani, pagkaaga, nalibog sida ag ida gingpatawag katong tanan nak mga manughula it pananamgo ag pati katong mga maayong tawo ruto sa Ehipto. Ing-uma sa inra ni Paraon kag ida pananamgo ugaling waya nak gador sa inra it nakapahadag it gustong bisayahon it ida pananamgo. ");
INSERT INTO bno_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ngasing, katong Punong Manugtahaw it inumon ni Paraon ay nagsiling sa ida, “Narumrumaney yaki nako nak ako ay nakasala. ");
INSERT INTO bno_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ako Halandong Paraon, it kag ikaw ay nahangit sa amo it katong Punong Panadero, ag kami ay imo gingpapriso sa prisuhan ruto sa bayay it pinuno it mga gwardya, ");
INSERT INTO bno_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","usang gab-i ay nagpananamgo kaming ruha. Kada pananamgo namo ay inggwa it gustong bisayahon. ");
INSERT INTO bno_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ruto ay inggwa kami it nakaibahan nak usang Hebreo nak dating suguon it tong pinuno it mga gwardya it palasyo. Amo ing-uma sa ida kag amo mga pananamgo ag ida gingpahadag sa amo kag mga gustong bisayahon it kato. ");
INSERT INTO bno_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kung ni-o kag ida gingsiling ay imaw kag natabo. Ako ay gingbalik nimo sa ako dating pwesto ag katong Panadero ay imo ingpapugutan.” ");
INSERT INTO bno_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pagkarungog it kali ni Paraon, ingpatawag nida si Jose ag rali-rali nak gingpabaoy sida sa prisuhan. Pagkatapos it panigar ni Jose ay nag-ilis ag nag-atubang sida kang Paraon. ");
INSERT INTO bno_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Nagsiling si Paraon kang Jose, “Inggwa ako it pananamgo pero waya it nakakapahadag it gustong bisayahon it kali. Ako narunggan nak imo kuno natataw-an it kapahadagan kag mga pananamgo.” ");
INSERT INTO bno_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Nagsabat si Jose kang Paraon, “Buko ako it nagtata-o it kapahadagan sa mga pananamgo kundi kag GINO-O.” ");
INSERT INTO bno_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ag gingsiling ni Paraon kang Jose, “Sa ako pananamgo ay nagtitinrog kuno ako sa habig it Suba it Nilo. ");
INSERT INTO bno_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Inggwa kuno it gulping nagyuaw nak pitong mga mataba ag magandang baka nak nagtakas halin ruto sa suba, ag sinra kuno ay nagpanabsab ruto sa inggwa't mataas nak mga hilamunon. ");
INSERT INTO bno_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Masunor ay inggwa ray kuno it pitong baka nak mga maniwang ag hilwakon it bituka nak gulping nagtakas halin sa suba. Waya pa nak gador ako it nakita nak tuyar it yain nak baka sa bug-os nak Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ingkaon kuno it kinang mga baka nak mga maniwang ag hilwakon kaling mga naunang pitong baka nak mga mataba. ");
INSERT INTO bno_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pero pagkakaon ninra ay pay waya gihapon sinra nahalata nak nakakaoney dahil hilwakon gihapon kag inra bituka nak tuyar sa dati. Ag ako ay nakabati.” ");
INSERT INTO bno_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Nagpadayon si Paraon sa pagsiling, “Nakatuyugan ray ako ag nagpananamgo liwat nak inggwa kuno it usang puno it mais nak inggwa it pitong pusô ag kag bawat pasî it kali ay maragko ag matimgas. ");
INSERT INTO bno_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ag inggwa ray kuno it nagtubo nak pitong puno nak inggwa yang it tig-usang pusô nak kupos ag maintik kag pasî. Ag kali kuno ay nagpapangruyaw dahil sa mainit nak hangin halin sa disyerto sa subatan. ");
INSERT INTO bno_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kinang maragko ag matimgas nak pasî ay ingkaon kuno it katong mga maintik nak pasî. Pagkaaga ingpatawag nako kag mga manughula it pananamgo ag ingsiling sa inra pero waya it nakapahadag it gustong bisayahon it kali sa ako.” ");
INSERT INTO bno_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Pagkatapos, nagsiling si Jose kang Paraon, “Kaling mga pananamgo nimo ay ausa yang it gustong bisayahon. Ako Halandong Paraon, ingpapahadag it Dios sa imo kung ni-o kag Ida ahimuon. ");
INSERT INTO bno_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ka gustong bisayahon it kaling pitong matabang baka ay pitong tuig, ag imaw ra kaling pitong maragko nak pusô. Usa yang kag gustong bisayahon it kaling ruhang pananamgo. ");
INSERT INTO bno_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Katong masunor nak nagyuaw nak pitong maniwang ag hilwakon it bituka nak mga baka ay pitong tuig, ag imaw ra katong pitong pusô nak waya't mga unor ag nagpapangruyaw dahil sa mainit nak hangin. Kali ay pitong tuig nak tigkagutom. ");
INSERT INTO bno_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ako Halandong Paraon, kumporme sa ako bisaya sa imo, gingpapakita it Dios sa imo kung ni-o kag Ida ahimuon. ");
INSERT INTO bno_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Maabot kag pitong tuig nak talagang bugana sa bug-os nak bansa it Ehipto, ");
INSERT INTO bno_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","pero pagkatapos it kina ay magkakainggwa't masyarong tigkagutom sa sakop it pitong tuig kung riin kinang tanang kabuganaan ay malilimutan sa bug-os nak Ehipto. Waya't mabibilin pagrayan it kinang tigkagutom. ");
INSERT INTO bno_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ako Halandong Paraon, kinang pagpananamgo nimo liwat ay nagpapahadag nak kali ay ingpapamatuuran it Dios nak maabotey sa mayungot nak panahon. ");
INSERT INTO bno_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Kada, ako Halandong Paraon, sa ngasing pa yang ay piliey ikaw it usang mahipir ag maayam nak tawo ag ibutang sida bilang Pinunong Manugrumaya it bansa it Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Papili-a ra sida, ako Halandong Paraon, it iba pang mga manugpasulit sa mga banwa ag ipabuhin kag ika-lima nak parti it mga panubas it Ehipto habang hina pa kag pitong tuig nak mabugana. ");
INSERT INTO bno_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ag para sa paabutong mabugana nak tuig katong ika-limang parti it inra tubas ay imo ipatipon ag ipahipir sa imo pangayan, ako Halandong Paraon, bilang pagkaon sa mga banwa sa paabuton nak tigkagutom. ");
INSERT INTO bno_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kinang uyas ay bilang pagtigana agor indi mawar-an kag bansa it pagkaon pag-abot it katong pitong tuig nak tigkagutom nak siguradong maabot sa bansa it Ehipto.” ");
INSERT INTO bno_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nupay maado para kang Paraon kaling plano ni Jose ag imaw ra sa tanan nidang mga opisyales. ");
INSERT INTO bno_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kada nagsiling si Paraon sa ida mga opisyales, “Makakakita pa ara kita it tuyar nak tawo kung hariin asa ida kag Ispirito it Dios?” ");
INSERT INTO bno_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ag nagsiling ra si Paraon kang Jose, “Dahil sa imo ingpakita it Dios kaling tanan, wayaey it iba nak mas marako kag kaayaman ag maayo magpasulit tuyar sa imo. ");
INSERT INTO bno_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ikaw mismo kag marumaya sa ako palasyo ag kung ni-o kag imo isugo ay asunron it tanan nak sinakupan nako. Ako yang kag mas mataas sa imo dahil ako kag asa trono.” ");
INSERT INTO bno_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Siling pa nida, “Ingtatalaga ka nako bilang gobernador sa bug-os nak bansa it Ehipto.” ");
INSERT INTO bno_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pagkatapos, inghukas ni Paraon katong ida singsing nak pangtimbre bilang hari ag ida ingsuksok sa kidamot ni Jose. Ida ra ingtaw-an ag ingpasuksok si Jose it mga mamahayong baro ag buyawan nak kulintas. ");
INSERT INTO bno_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ingpasakay ra sida sa pangruhang karwahe ni Paraon habang kag mga manugbandilyo it palasyo ay nauuna ag nagbabandilyo, “Magta-o kamo it pagrespeto sa Gobernador!” Tuna it kato, si Josey kag naging gobernador ni Paraon sa bug-os nak Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ag nagsiling pa si Paraon kang Jose, “Ako kag Paraon ag kali kag ako kasuguan. Kung inggwa't tawo nak indi magpamuhon sa imo ay indi makahimo it aber ni-o o makakapanaw it libre sa suyor it bansa't Ehipto.” ");
INSERT INTO bno_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ingpangayanan ra si Jose ni Paraon nak Zapenat-panea ag ingpaasawa sa ida si Asenat nak anak ni Potipera nak saserdote sa banwa it On, nak tong huli ay naging Heliopolis. Ag bilang gobernador naglibot sida sa bug-os nak bansa it Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Treynta anyosey si Jose it katong nagtuna sida nak magserbe kang Paraon nak hari it Ehipto. Naghalin anay sida sa palasyo ag naglibot sa bug-os nak bansa it Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sa suyor it pitong tuig nak mabugana ay nag-ado kag pamunga it mga pananom. ");
INSERT INTO bno_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ingpatipon ni Jose kinang ika-limang parti it uyas sa suyor it pitong tuig nak nagkainggwa't buganang ani sa bansa it Ehipto. Ingpahipir ra nida sa bawat banwa kaling mga uyas halin sa mga bukir nak nakapalibot rahang lugar. ");
INSERT INTO bno_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Nakapahipir si Jose it karurakong uyas nak halos mapanunubray sa inra tanang usunan. Tong huli ay wayaey ninra gipapasulita kato dahil sa subrang rakoey. ");
INSERT INTO bno_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bag-o nag-abot kag mga tuig it tigkagutom ay nagkainggwa si Jose it ruhang anak nak kayake kang Asenat, nak anak ni Potipera, nak saserdote sa banwa it On. ");
INSERT INTO bno_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ingpangayanan nida kag ida panganay nak Manase, dahil napasiling sida, “Ingbuligan ako it Dios nak malimtan nako kag tanang kahirapan nak ako narayanan, ag kag tanan ruto sa panimayay it ako tatay.” ");
INSERT INTO bno_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ag kag ida ingpangayan sa ida pangruhang anak ay Epraim, dahil napasiling sida, “Ingtugutan it Dios nak mag-uswag kag ako kabuhi rili sa lugar it maramong subida.” ");
INSERT INTO bno_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Natapos kinang pitong tuig it kabuganaan sa Ehipto, ");
INSERT INTO bno_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ag nagtunaey kag pitong tuig it tigkagutom kumporme sa ingsiling ni Jose. Inggwa it kagutuman sa ibang mga bansa sa palibot pero sa Ehipto ay inggwa it hinipir nak pagkaon. ");
INSERT INTO bno_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ag it kag nagtunaey kag tigkagutom sa Ehipto, kag mga tawo ay nagpanghinagar kang Paraon it makakaon. Kag sabat sa inra ni Paraon ay, “Pagto kamo kang Jose ag kung ni-o kag ida isugo sa inro ay tumana.” ");
INSERT INTO bno_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","It katong laganapey kag kagutuman sa bug-os nak Ehipto ay ingpaabrihan ni Jose kag tanan nak mga usunan it uyas, ag ingpabaligya sa mga Ehiptohanon dahil subrang tigkagutomey sa inra. ");
INSERT INTO bno_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ag nagpinagto ra kang Jose kag mga tawo halin sa ibang mga bansa sa palibot agor magbakay it pagkaon dahil abang masyaro ra kag tigkagutom sa inra. ");
INSERT INTO bno_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kag Canaan ay nagrayan ra it tigkagutom, kada pagkabalita ni Jacob nak inggwa pa't uyas ruto sa Ehipto, ida ingsiling kag ida mga anak nak kayake, “Ni-o pa kag inro inghuhuyat? ");
INSERT INTO bno_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Narunggan nako nak inggwa pa sinra't uyas ruto sa Ehipto. Pagto kamo ruto ag bumakay it ato makakaon agor indi kita mamatay sa gutom.” ");
INSERT INTO bno_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ngani, nagpagto katong sampuyong hali ni Jose pa-Ehipto agor magbakay it uyas. ");
INSERT INTO bno_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pero katong manghor ni Jose nak si Benjamin ay waya gipanunta ni Jacob, sabaling kali ay madisgrasya kuno. ");
INSERT INTO bno_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ngani, nagpagto kag mga anak ni Jacob karungan it iba pang mga manugbakay it uyas sa Ehipto, dahil laganapey ra kag tigkagutom sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ngasing, kag gobernador ruto sa Ehipto nak si Jose ay sida kag nagpapabaligya it mga uyas sa tanang tawo. Kada pag-abot it mga hali ni Jose ay nagyuhor sinra sa ida atubangan. ");
INSERT INTO bno_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Pagkakita ni Jose sa inra ay nakilayang raan nida nak sinra kag ida mga maguyáng. Pero kag ida pagtratar sa inra ay pay buko nida kilaya ag maging kag ida pamisaya ay pabayahak. Nagpangutana sida, “Taga riin kamo?” Sabat ninra, “Taga-Canaan kami ag hali kami ngasing agor magbakay it pagkaon.” ");
INSERT INTO bno_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kilaya nak gador ni Jose katong ida mga maguyáng ugaling sinra ay waya nakakilaya sa ida. ");
INSERT INTO bno_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","It katong oras nak kato ay narumruman ni Jose katong ida mga pananamgo tungor sa inra. Siling nida, “Kada nagpali kamo ay agor mapaniir it mga kayudahon it amo bansa. Mga manugpaniir kamo no?” ");
INSERT INTO bno_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Nagsabat sinra, “Buko kina matuor Gobernador. Kami nak imo mga ulipon ay nagpali agor magbakay it pagkaon. ");
INSERT INTO bno_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kaming tanan ay maghali ag ausa yang it tatay. Buko kami mga manugpaniir!” ");
INSERT INTO bno_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Sabat ray ni Jose, “Indi ako magpati! Talagang nagpali kamo agor ausisaon kag mga kayudahon it amo bansa.” ");
INSERT INTO bno_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nagsabat ray gihapon sinra, “Gobernador, talagang kami nak imo mga ulipon ay doseng maghali ag ausa yang kami it tatay. Sa ngasing, kag amo puto ay nabilin nak kaibahan it amo tatay ruto sa Canaan. Ag kag usa pa sa amo ay nawayaey.” ");
INSERT INTO bno_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nagsiling sa inra si Jose, “Indi gihapon ninro ako mapapati. Talagang manugpaniir kamo. ");
INSERT INTO bno_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Pero hala, apurbahan kamo nako sa inro bisaya. Sa ngayan ni Paraon, indi kamo gihalin diling lugar hanggat indi magpaali kag inro manghor. ");
INSERT INTO bno_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Hala, papauli-a kag usa sa inro agor ida mararaya rili kag inro manghor habang kag iba sa inro ay mapipriso rili. Hina nako masasaduran kung matuor o buko kag inro bisaya. Pero kung buko matuor, sa ngayan ni Paraon, talagang manugpaniir kamo.” ");
INSERT INTO bno_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ag ida ingpapriso kaling tanang maghali sa sakop it tatlong adlaw. ");
INSERT INTO bno_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sa pangtatlong adlaw ay nagbisaya sa inra si Jose it tuyar kali, “Kali kag inro ahimuon agor mabubuhi pa kamo. Inggwa ra ako it kahadlok sa Dios. ");
INSERT INTO bno_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kung talagang waya kamo gibibinakak, binlan dili sa prisuhan kag usa sa inrong maghali ag kag iba ay puyding makapauliey agor mararaya sa inro mga pamilya kag mga pagkaon para sa inro kinahangyan. ");
INSERT INTO bno_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nuntan rili sa ako katong inro putong manghor agor mapamatuuran kag inro bisaya ag agor makabakay ray kamo it pagkaon ag indi kamo mamatay.” Ingtuman it kaling mga magmanghor kag bisaya ni Jose. ");
INSERT INTO bno_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Mansigsiling sinra sa usa'g-usa, “Hay, mati gani! Imawey kali kag gaba sa ato inghuman sa ato manghor nak si Jose! Nakita nato kag ida kalisuran it katong nagpakitluoy sida sa ato pero waya nato giintyendiha sida. Ngani, nagbalik sa ato ngasing kag tuyar nak kahirapan.” ");
INSERT INTO bno_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Nagsabat si Ruben, “Kita ngani. Di baga ingbawalan kamo nako nak indi giunhon sida? Pero waya ninro gipatihe katong ako bisaya, kada ngasing ingsusukot kita sa ida pagkawagit.” ");
INSERT INTO bno_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Buko ninra ayam nak naiintyendihan ni Jose kag inra bisaya, dahil pag nagbibisaya sida sa inra ay inggwa't manugsaydo it ida bisayang Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Naghalin anay si Jose sa inra atubangan ag nagtibaw. Marugay-rugay ay nagbalik ray sida ag nagpadayon it bisaya. Ida ingpabaoy si Simeon nak pangruha sa magmanghor ag ingpagapos sa inra atubangan. ");
INSERT INTO bno_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ngasing, ingpapuno ni Jose it uyas kag mga kustal it ida mga maguyáng ag kag kwarta nak inra ingbadar ay ida ingbutang sa kustal it kada usa sa inra. Ag ingparugangan ra nida kag inra bayon para sa inra pagpauli. ");
INSERT INTO bno_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Pagkatapos, inra ingkarga katong mga uyas sa inra rayang mga asno ag nagginaney. ");
INSERT INTO bno_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Pag-abot ninra sa usang lugar nak inra ingpahuwayan, usa sa inra ay nag-abri it ida kustal agor mabaoy it pagkaon para sa ida asno ag ruto sa ibabaw it uyas ay nakita nida katong ida ingbadar nak kwarta. ");
INSERT INTO bno_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nagsiling sida sa ida mga hali, “Asing dili kaling kwarta nak ako ingbadar! Ni-o kag gustong bisayahon it kali?” Dahil rili ay ingpakayawhakan sinra ag nagmuyat-muyatan sa usa'g-usa nak nagpipinanguyog sa kahadlok, bag-o masigsiling, “Ni-o kaling ingpapaagom sa ato it Dios?” ");
INSERT INTO bno_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pag-abot sa inra tatay ruto sa bansa it Canaan, inra ing-uma sa ida kag tanan-tanan nak inra naaguman ruto. ");
INSERT INTO bno_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Siling ninra, “Katong tawo nak imaw kag pinaka-gobernador rutong bansa ay pabayahak kag pagbisaya sa amo ag ida kami gingsan-an nak kami kuno ay mga manugpaniir sa inra bansa. ");
INSERT INTO bno_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pero nagsabat kami sa ida, ‘Buko kami mga manugpaniir! Waya kami gibibinakak!’ ");
INSERT INTO bno_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ag ingsiling ra namo sa ida nak, ‘Kami ay doseng maghali ag ausa yang kag amo tatay. Usa sa amo ay wayaey, ag kag usa ay nabilin nak kaibahan it amo tatay sa Canaan.’ ");
INSERT INTO bno_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Nagsiling ray sida sa amo, ‘Maaayaman yang nako nak matuor kag inro ingsisiling kung inro ibilin dili sa ako kag inro usang hali bag-o kamo magpauli, pramas ray-an ninro it uyas kag inro mga pamilya ruto sa Canaan, para sa inra pagkaon riling tigkagutom. ");
INSERT INTO bno_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Pagbalik ninro rili ay inro aray-on sa ako katong inro puto nak manghor. Hina nako maaayaman nak buko kamo mga manugpaniir ag buko kamo mga bakakon. Ag pagbalik ninro ay akoey iuli sa inro katong inro hali ag puydey kamo nak magpamakay ray rili sa amo bansa.’ ” ");
INSERT INTO bno_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ag it katong inghuwarey ninra katong suyor it mga kustal ay nakita ninra ag inra tatay nak kag kada kustal ay inggwa't nakabutang nak kwartang binugkos nak imaw kag inra ingbadar. Pagkakita ninra it kali ay lalo sinrang napakabayaka. ");
INSERT INTO bno_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ag nagsiling si Jacob, “Nagkakalisor ako dahil ingwagitey ninro sa ako kag ako mga anak. Wayaey ngani si Jose, ag wayaey ra si Simeon, ag ngasing pati si Benjamin ay gusto pa ninrong bay-on. Asi ara nak natabo kaling tanan sa ako?” ");
INSERT INTO bno_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nagsabat si Ruben sa inra tatay, “Hina kag ako ruhang anak. Kung indi nako maibalik si Benjamin sa imo, matya sinra. Akoy it bahala. Siguradong ibalik nako sida sa imo it buhi.” ");
INSERT INTO bno_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pero siling ray ni Jacob, “Sa imo pagbalik ruto, indi nak gador nako gipanunton si Benjamin sa imo, dahil minatayey ngani kag ida maguyáng ag sida yangey kag nabibilin nak anak nako kang Raquel. Usa pa, sabaling inggwa't matabo sa ida sa rayan ag sa ako kaguyangon ay imo ako amatyon sa kalisor ag indi ra ako matimunong ruto sa ‘Sheol’ nak ingpapagtuan it mga namamatay.” ");
INSERT INTO bno_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ngasing, lalong nagpakamasyaro katong tigkagutom sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Pagkaubos it inra uyas nak inghalin sa Ehipto, nagsiling si Jacob sa ida mga anak, “Pagto ray kamo liwat sa Ehipto ag bumakay ray it maisuting pagkaon para sa ato.” ");
INSERT INTO bno_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pero nagsabat si Juda, “Ingpakapaandaman nak gador kami it katong gobernador nak indi kuno nida kami giatubangon kung buko namo kanunot kag amo manghor. ");
INSERT INTO bno_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kung apanunton nimo si Benjamin ay mapagto kami ag abakyan ka namo it pagkaon. ");
INSERT INTO bno_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pero kung indi ay indi ra kami magpagto. Ingpakatugon nak gador kami it katong gobernador nak indi kami mag-atubang sa ida kung buko namo kanunot kag amo manghor.” ");
INSERT INTO bno_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Siling ray ni Jacob, “Asing inro ako ingtutuyar? Asing ing-uma pa ninro sa gobernador nak inggwa pa kamo it usang manghor?” ");
INSERT INTO bno_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kag sabat ninra ay, “Pauno ngani nak ingpakapangutana nak gador kami parti sa amo sarili ag sa amo ra mga hali. Siling pa ngani nida, ‘Buhi pa baga kag inro tatay? Ag inggwa pa baga kamo it ibang manghor?’ Katong amo ing-uma sa ida ay bilang pagsabat yang sa ida mga pangutana. Ag buko namo ayam nak ida iparaya kag amo manghor ruto.” ");
INSERT INTO bno_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Masunor, nagsiling si Juda sa ida tatay, “Tay, panunta yangey si Toto sa ako agor kami'y makakapanawey ag makakabakay it pagkaon pramas indi kita mamatay sa gutom pati kag amo mga anak. ");
INSERT INTO bno_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nagpupromisa ako nak ako kag mapanabat sa ida, kung indi nako sida maibalik dili sa imo. Ako kag imo abasuyon habang buhay! ");
INSERT INTO bno_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Muyati kina ngasing, nakabweltay tan-a kami it makaruhang beses kung waya kami naatraso.” ");
INSERT INTO bno_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Pagkatapos, nagsiling kag inra tatay nak si Jacob sa inra, “Kung imaw kina kag dapat himuon ay sige imaw kag himu-a. Raya kamo it pilang bilog nak pinaka-maadong produkto nak inggwa gihapon kita rili sa ato lugar, butangan sa inro mga susudlan ag ipatabo rutong gobernador, tuyar sa maisuting balsamo, maisuting duga it ubas nak inghumang matam-is, mga pabangyo, buyong nak mira ag mga bunga it pili. ");
INSERT INTO bno_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ag dubliha kag inro aray-ong kwarta. Kag katunga ay pangbadar sa inro abakyon ngasing ag kag katunga ay pambadar ruto sa naunang ingbakay ninro sabaling nagsala yang kag inra pagbutang sa inro mga kustal. ");
INSERT INTO bno_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Hala, ray-ay ninro kaling inro manghor ag balikey kamo ruto sa gobernador. ");
INSERT INTO bno_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","“Kabay pa nak kaluy-an kamo it ato Dios nak Makagagahom sa inro pag-atubang rutong gobernador ag kabay pang ida iuli katong inro napiprisong hali nak si Simeon ag imaw ra si Benjamin. Sige, pag indi makabalik kag ako mga anak, wayaey ako it mahuhuman kundi'y magpangalisor yangey.” ");
INSERT INTO bno_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ingraya ninra kinang mga patabo ag imaw ra si Benjamin ag inra ingdubli kag inra rayang kwarta. Ag pagkatapos ay nagginaney sinra papagto sa Ehipto. Pag-abot ninra ruto, inra ingprisentar kang Jose kag inra mga sarili. ");
INSERT INTO bno_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Pagkakita ni Jose nak kaibahan ninra si Benjamin, nagsiling sida sa Mayordumo it ida bayay, “Nunti kinang mga tawo sa ako bayay ag magpaihaw ka it usang baka para sa paning-ugto dahil ruto sinra makaon.” ");
INSERT INTO bno_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ingnunot it Mayordumo sa bayay ni Jose kag ida mga hali ag ida ingtuman katong sugo sa ida nak maghikot it paning-ugto. ");
INSERT INTO bno_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ingpangyawhakan katong mga hali ni Jose dahil ingnunot sinra sa ida bayay. Siling ninra, “Kada kita gingraya rili ay dahil ruto sa kwarta nak gingbalik sa ato kustal it katong primerong pagpaali nato. Kada siguro tuyar kag ida inghuman sa ato ay agor inggwa sida it bangranan agor kita ay marakop, ag mabaoy nak mga ulipon ag mapasa-ida pati kag ato mga asno.” ");
INSERT INTO bno_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ngani, nagsuor anay sinra sa Mayordumo it bayay ni Jose ag gingkaistorya ninra kali ruto sa mayungot it hagranan. ");
INSERT INTO bno_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ag nagsiling, “Mataas nak Mayordumo, tong primerong pagbisita namo rili pramas magbakay it pagkaon, ");
INSERT INTO bno_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","sa amo pagpauli ay nagpahuway kami sa usang lugar. Pagbukas namo it katong amo mga kustal ay nakita namo nak rahagto sa suyor it kada kustal namo kag amo kwarta nak amo ingbadar ag waya't bawas. Kinang kwarta ay amo gingraya ngasing pabalik rili pramas iuli sa gobernador. ");
INSERT INTO bno_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Inggwa ra kami it raya nak ibang kwarta pramas ibakay ray it pagkaon. Buko namo ayam kung sin-o kag nagbutang it katong kwarta sa amo mga kustal.” ");
INSERT INTO bno_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Nagsabat katong Mayordumo, “Aya giisipa kina. Aya kamo gikahadlok. Siguro katong mga kwarta sa inro mga kustal ay ingta-o sa inro it inro Dios nak Dios ra it inro tatay. Kato ay para talaga sa inro. Katong inro badar ay nabatoney nako.” Pagkabisaya nida't kina, ingpaliwas nida sa prisuhan si Simeon. ");
INSERT INTO bno_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","It katong kag mga hali ni Jose ay asa suyorey it ida bayay, kag inra mga siki ay ingpahinawan anay bag-o ingpainom it Mayordumo, ag kag inra mga asno ay gingpataw-an it upa. ");
INSERT INTO bno_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Pagkatapos, inra inghanra kag inra mga patabo para sa pag-abot ni Jose sa alas dose dahil narunggan ninra nak makaon kuno sinra ruto. ");
INSERT INTO bno_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Pag-abot ngani ni Jose, inra ingpangsuyor katong inra mga raya nak patabo ag sinra'y nagyuhor sa ida atubangan. ");
INSERT INTO bno_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nagpangutana si Jose tungor sa inra kamutangan, “Maado pa baga kag inro tatay? Katong maguyang baga nak inro ingsiling it katong una? Buhi pa baga sida?” ");
INSERT INTO bno_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Sabat ninra, “Gobernador, kag amo tatay nak imo ulipon ay buhi pa ag maado pa't yawas,” ag nagyuhor ray sinra kang Jose. ");
INSERT INTO bno_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Nagmuyat ngasing sa inra si Jose, pero kag ida ingpakamuyatan ay kag ida matuor nak manghor sa nanay nak si Benjamin. Bag-o nagsiling sida, “Imaw baga kali kag inro puto nak manghor nak inro gingsiling sa ako?” Ag siling nida kang Benjamin, “Toto, kabay pang mapasa-imo kag kaaduhan it Dios!” ");
INSERT INTO bno_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ag si Jose ay nagrali-rali it liwas dahil pay mapapatibawey sida, ag pay indiey nida mapunggan kag ida nababatyagan para sa ida manghor. Nagsuyor sida sa kwarto ag ruto nagpakatibaw. ");
INSERT INTO bno_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pagkatapos nida it tibaw, nagpangyam-os sida ag nagliwas ag habang ingpupunggan nida kag ida sarili ay nagsiling sida, “Hala tahawaney kag pagkaon!” ");
INSERT INTO bno_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Gingtahawan si Jose nak ausa sa ida sariling lamesa, buyag sa ida mga hali ag buyag ra sa ida mga kaibahan nak Ehiptohanon, dahil bawal sa inra nak magkaon kaibahan kag buko ninra kalahi sa usang lamesa. Kina ay kasal-anan para sa mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kada gingpaingkor ni Jose kag ida mga hali sa ibang lamesa nak asa ida atubangan it pasunor sa inra mga edad. Natingaya sinra ag nagminuyat-muyatan sa usa'g-usa. ");
INSERT INTO bno_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Gingtahawan sinra it pagkaon nak halin sa lamesa ni Jose, ugaling kag parti ni Benjamin ay ginghumang limang sanrok ag kag sa ida mga maguyáng ay usa yang. Nag-inuman ngasing sinra ag nagkinasadya nak kaibahan si Jose. ");
INSERT INTO bno_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Pagkatapos, nagsugo si Jose sa ida Mayordumo, “Pun-a it uyas kag mga kustal it kinang mga tawo kumporme sa inra mararaya. Ibutang ra nimo kag inra kwarta sa bawat kustal ninra. ");
INSERT INTO bno_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ag sa kustal it katong inra puto ay imo ibutang kag ako kupa. Kato baga nak pilak. Pisanan sa ida badar.” Ingtuman it Mayordumo katong bisaya ni Jose. ");
INSERT INTO bno_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Pagkaaga nak medyo masyanaawey, ingsugtaney nak makapauli kinang mga maghali ag kag inra mga asno. ");
INSERT INTO bno_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","It katong mayado-yadoey sinra, nagsiling si Jose sa ida Mayordumo, “Pagtoy, yagura katong mga tawo ag pag naabutan nimo sinra, kali kag imo isiling sa inra, ‘Asing ingbayusan ninro it mayain kag maadong pagtratar sa inro? Asing inro ingtakaw katong kupa nak pilak it ako Amo? ");
INSERT INTO bno_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Di baga imaw kato kag ing-iinuman it ako Amo ag imaw ra kag ida inggagamit sa ida pagbuhat? Nakasala kamo dahil sa inro inghuman.’ ” ");
INSERT INTO bno_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ngani, sinra ay ingyagor it Mayordumo, ag it katong sinra ay inabutan ay ida ingsiling kag ingpasiling it ida amo. ");
INSERT INTO bno_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nagsabat kag mga hali ni Jose sa ida, “Mataas nak Mayordumo, asing tuyar kali kag imo bisaya? Purya sulay! Kaming imo mga ulipon ay indi makahuman it kina. ");
INSERT INTO bno_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Di baga kato ganing kwarta nak amo nakita sa amo mga kustal pag-abot namo sa Canaan ay amo gingbalik dili sa inro. Asing mapanakaw kami it pilak o buyawan man sa bayay it imo Amo? ");
INSERT INTO bno_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kung sin-o sa amo nak imo mga ulipon kag imo makitaan it kina, matya sida. Ag kami ay mapaulipon sa inro.” ");
INSERT INTO bno_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Siling it Mayordumo, “Kung imaw kina kag inro bisaya muyatan baga nato. Kung sin-o kag makitaan it kina, sida ay magiging ulipon namo pero kag iba ay liwasey sa kasal-anan nak kali.” ");
INSERT INTO bno_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Rali-rali sinra't diskarga it inra mga kustal ag mansigbukar. ");
INSERT INTO bno_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Inghakar it Mayordumo kag inra kustal magtuna sa maguyáng hastang sa puto ag raha sa kustal ni Benjamin nakita katong kupa. ");
INSERT INTO bno_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Pagkakita ninra, inra ginggisi kag inra mga baro dahil sa inra pagkabayaka, ag inra ray gingpangkarga liwat kag raya sa mga asno ag nagbalik kang Jose. ");
INSERT INTO bno_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Pag-abot nina Juda ag ida mga hali sa bayay ni Jose, ay rahina pa si Jose. Sinra'y nagyuhor sa ida atubangan. ");
INSERT INTO bno_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Nagpangutana si Jose sa inra, “Ni-o kaling inro inghimo? Buko baga ninro ayam nak kag tuyar sa ako ay nakakapitlo it mga nagpapanakaw?” ");
INSERT INTO bno_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Sabat ni Juda, “Gino-o, ni-o kag amo isiling? Pauno namo kali isiling sa imo? Pay indi namo mapamatuuran nak waya kami it sala. Dios kag nagpaliwas it amo kasal-anan. Ngani, hali kami tanan bilang imo mga ulipon, kami ag kag usa nak inro nakitaan it kupa.” ");
INSERT INTO bno_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Pero siling ni Jose, “Buko kamo! Kundi katong tawo yang mismo nak nakitaan it ako kupa kag magiging ako ulipon. Kamo ay puyding magpauliey it hanuyos ruto sa inro tatay.” ");
INSERT INTO bno_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Masunor, nagsuor si Juda kang Jose ag nagsiling, “Gobernador, puyde akong magbisaya anay ag kabay pa nak indi ikaw mahangit sa ako, dahil ulipon yang nimo ako ag ikaw ay pay si Paraon. ");
INSERT INTO bno_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Gobernador, ikaw ay nagpangutana sa amo it tuyar kali, ‘Inggwa pa baga kamo it tatay o manghor?’ ");
INSERT INTO bno_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nagsabat kami sa imo Gobernador nak, ‘Inggwa pa. Katong amo tatay ay maguyangey ag katong amo manghor ay ing-anak sa ida kaguyangon. Kag maguyáng it katong anak ay minatayey ag sida yangey kag nabilin nak anak it ida nanay, kada abang palangga sida it amo tatay.’ ");
INSERT INTO bno_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Pagkatapos, nagsiling ikaw sa amo nak imo mga ulipon, ‘Ray-a sida dili sa ako agor ako ra makita.’ ");
INSERT INTO bno_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Siling namo sa imo Gobernador, ‘Indi sida puyding makahalin ruto sa amo tatay sabaling kali pa kag maging rason it ida pagkamatay.’ ");
INSERT INTO bno_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ag nagsiling pa ikaw sa amo, ‘Hangga't indi magpaali katong inro manghor indi ra kamo nako giatubangon.’ ");
INSERT INTO bno_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Gobernador, pagkabalik namo sa amo tatay nak imo suguon, ay amo ing-uma sa ida kag imo mga ingsiling. ");
INSERT INTO bno_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“It katong nagsiling sa amo kag amo tatay nak, ‘Balik ray kamo ruto ag bumakay liwat it maisuting pagkaon para sa ato,’ ");
INSERT INTO bno_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","nagsiling kami, ‘Indi kami puyding makabalik ruto. Kung manunot kaling amo manghor sa amo ay mapagto kami, pero kung indi, indi kami makaatubang rutong gobernador ninra.’ ");
INSERT INTO bno_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Pagkatapos, nagsabat kag amo tatay, ‘Ayam ra ninro nak aruhang anak yang kina sinra sa ako pinalanggang asawa nak si Raquel. ");
INSERT INTO bno_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kag usa, sa ida paghalin ay wayaey nakabalik sa ako, ag sa ako huna-huna sida ay ingsiba it ilahas nak hadop, ag hastang ngasing ay wayaey nak gador nako sida nakita. ");
INSERT INTO bno_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kung kaling usa sa ako ay abay-on pa ninro ag inggwa't matabo sa ida, sa ako kaguyangon ay amatyon ninro ako sa kalisor.’ ” ");
INSERT INTO bno_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Nagsiling pa si Juda kang Jose, “Kada ngasing, Gobernador, kung mapauli ako sa amo tatay ");
INSERT INTO bno_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ag makita nida nak buko namo kanunot si Toto, mamamatay nak gador sida dahil kali nak anak ay kapupalangga nida. Ag kami ay imaw kag maging rason it ida kalisor ag sabaling pati ida kamatayon ra. ");
INSERT INTO bno_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Amo Gobernador, ako kag mapanabat sa anak nak kali sa ako tatay dahil siling nako sa ida, ‘Tay, kung indi nako sida maibalik sa imo, ako ing-aako kag tanang kabasuyan sa atubangan nimo hastang sa ako kamatayon.’ ");
INSERT INTO bno_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Kada ngani amo Gobernador, kung maari ay ako yangey kag mapaulipon sa imo imbes nak si Toto. Ag kung puydey po, ay papauli-a yangey sida kaibahan kag ida ibang mga maguyáng. ");
INSERT INTO bno_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Pauno ako makakabalik ruto sa ako tatay kung waya si Toto? Amo Gobernador, nahahadlok ako sa matatabo sa amo tatay!” ");
INSERT INTO bno_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Pagkarungog ni Jose sa pakitluoy ni Juda ay waya nida napigahe kag ida nababatyagan sa atubangan it mga Ehiptohanon nak nakapalibot sa ida, kada sinra anay ay ida ingpahalin. Siling nida, “Halin anay kamo rili!” Kada it katong wayaey ruto it ibang tawo kundi sinra yangey nak mga magmanghor ay nagpakilaya si Jose sa ida mga hali. ");
INSERT INTO bno_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nagpakatibaw sida it makusog, kada narunggan sida it katong mga Ehiptohanon, ag narunggan pati it panimayay ni Paraon. ");
INSERT INTO bno_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Siling ni Jose sa ida mga hali, “Si Jose ako! Buhi pa baga kag ako tatay?” Pero waya nakasabat katong ida mga hali dahil pay naudom sinra sa kahadlok. ");
INSERT INTO bno_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Siling ray ni Jose sa ida mga hali, “Maley, suor anay kamo rili sa ako!” Ag pagkasuor ninra ay nagsiling sida, “Ako talaga kag inro manghor nak si Jose nak inro ingbaligya it kato. ");
INSERT INTO bno_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Aya kamo gikahadlok ag badaey kamo gibasuy-basuyan sa inro pagbaligya sa ako rili sa Ehipto. Kag Dios kag nagparaya sa ako rili nak mauna sa inro agor indi kamo mauno sa kaling tigkagutom. ");
INSERT INTO bno_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","“Kali nak kalamidad ay ruhang tuig pa yang ag inggwa pa't paabutong limang tuig. Sa suyor it kina nak panahon ay waya nak gador it matutubas. ");
INSERT INTO bno_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ingpauna ako rili it Dios agor inggwa it mga matuturang buhi sa ato lahi ag agor maramo rang tawo pa kag indi mamatay sa kaling tigkagutom. ");
INSERT INTO bno_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kada buko kamo kag nagparaya rili sa ako kundi kag ato Dios. Inghuman Nida ako nak manuglaygay ni Paraon ag manugrumaya it ida palasyo, ag bug-os nak sinakupan dili sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Hala, pauliey kamo sa ako tatay ag silinggon sida nak ako si Jose nak ida anak ay buhi pa. Ag ako nganat kag inghuman it Dios nak gobernador it bug-os nak Ehipto. Silinggan sa ida nak magpaaley nganat sa ako ag ayaey giruyog-ruyog pa. ");
INSERT INTO bno_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kamo nganat ay maistar ruto sa lugar it Gosen nak maadong agsaman agor mayungotey kamo sa ako, pati katong inro mga anak, mga apo, kahadupan ag tanang inro mga ari-arian. ");
INSERT INTO bno_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Pag rahagtoy kamo, ako'y kag mata-o it inro tanang kinahangyan dahil inggwa pa't paabutong limang tuig nak tigkagutom. Pag indi kamo magpaali sabaling kamo ag kag inro mga panimayay, ag tanang inro sinakupan ay mapakahirapan. ");
INSERT INTO bno_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Nakikita ninrong tanan, pati ni Benjamin nak imaw kag ako matuor nak manghor nak talagang ako kali kag nagbibisaya sa inro. ");
INSERT INTO bno_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Silinggan kang tatay kag ako mataas nak kahimtangan rili sa Ehipto ag tanang kabuganaan nako nak inro nakikita. Pauliey kamo ag papalion nak raan katong ako tatay.” ");
INSERT INTO bno_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ag pagkatapos, ida ingkupkupan katong ida manghor nak si Benjamin ag sinra ay mansigtibaw sa abaga it usa'g-usa. ");
INSERT INTO bno_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ida ra ingharuan katong ida mga hali habang sida ay nagtitibaw. Pagkatapos it kali, imaw pa yang kag pagkabisaya it ida mga hali. ");
INSERT INTO bno_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","It katong marunggan it panimayay ni Paraon nak nag-abot kag mga hali ni Jose ay napakasadyahan sinra ag imaw ra si Paraon. ");
INSERT INTO bno_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ingpatawag ni Paraon si Jose ag nagsiling sida, “Silingga kinang imo mga hali nak atumanon kaling ako bisaya. ‘Kargahe it mga uyas kag inro mga asno ag pumauli ruto sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Paray-an ra rili kag inro tatay kaibahan kag inro mga panimayay. Ataw-an nako kamo it pinaka-maadong duta rili sa Ehipto ag magkakainggwa kamo it abunda nak pagkaon dili sa ako sinakupan.’ ");
INSERT INTO bno_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Sugu-a ra sinra nak tumanon kali, ‘Gamita ninro kag ako mga karusa nak di gulong para sa inro mga maintik nak anak ag mga asawa. Ag ray-on dili kag inro tatay. ");
INSERT INTO bno_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Aya gikalibog kung inggwa kamo it mabibilin ruto nak ibang gamit, dahil kag pinaka-maado rili sa Ehipto ay inro ra magagamit.’ ” ");
INSERT INTO bno_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ing-uma ni Jose sa ida mga hali katong mga sugo ni Paraon ag imaw kag ingtuman it katong mga anak ni Jacob. Ingtaw-an sinra ni Jose it mga karusa ni Paraon ag ida ra gingpabayunan sinra it mga pagkaon para sa mahabang biyahe. ");
INSERT INTO bno_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kada usa sa inra ay ingtaw-an ra nida it tig-usang mamahayong baro. Pero kang Benjamin kag ida gingta-o ay buko yang usa kundi limang baro ag pilak nak tres syentos nak bilog. ");
INSERT INTO bno_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Sa ida tatay kag ida ingparaya ay imaw kali, sampuyong kayaking asno nak kargado it mga maadong produkto halin sa Ehipto, sampuyong guyangon nak asno nak kargado ra it mga uyas ag sari-saring pagkaon ag mga kinahangyanon it ida tatay sa pagbiyahe papagto sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ag ida ingpapauliey katong ida mga hali ag sa inra pagbinuyagan ay ida ingtugon nak, “Aya kamo giinaway sa rayan hah!” ");
INSERT INTO bno_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ngani, naghaliney sa Ehipto katong ida mga hali ag nagpa-Canaan kung hariin ay hagto kag inra tatay nak si Jacob. ");
INSERT INTO bno_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Pag-abot sa inra, nag-uma sinra sa inra tatay, “Tay, buhi pa yaki si Jose! Ag sida ngasing kag gobernador ruto sa bug-os nak Ehipto.” Nagulpihan si Jacob nak pay nagtungon it bado-bado kag ida puso, dahil indi sida makapati sa inra ingsiling. ");
INSERT INTO bno_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ugaling, it katong ing-uma ninra sa ida kag tanang gingbisaya ni Jose, ag ida ra nakita kag mga karusa ni Paraon nak paraya ni Jose agor ida masakyan ay nag-ado kag ida pamatyag. ");
INSERT INTO bno_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Siling ni Jacob, “Nagpapatey ako nak buhi kag ako anak nak si Jose. Hala, mapagto ako ruto agor makita nako sida bag-o ako mawagit dili sa kalibutan.” ");
INSERT INTO bno_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ngani, sina Jacob ay nagginaney papagto sa Ehipto halin sa Hebron raya kag inra mga ari-arian. Nakaabot sinra sa Beerseba ag nagmatay sinra ruto it hadop nak ginghalar sa Dios nak Dios ra it ida tatay nak si Isaac. ");
INSERT INTO bno_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Pagkagab-i habang rahagto sinra, nagbisaya kag Dios kang Jacob parayan sa pagpananamgo. Nagsiling kag Dios, “Jacob, Jacob!” Sabat ni Jacob, “Rahali ako.” ");
INSERT INTO bno_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Siling ray it Dios, “Ako kag Dios, nak Dios it imo tatay. Aya gikahadlok nak magpagto ruto sa Ehipto dahil ruto kamo ay magiging makusog nak lahi. ");
INSERT INTO bno_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Anuntan ra kamo Nako ruto sa Ehipto pero apabalikon ray kamo Nako rili sa Canaan. Si Jose kag mapatigayon sa imo pag bawioney Nako kag imo kabuhi.” ");
INSERT INTO bno_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Pagkatabo it kali, naghalin sina Jacob sa Beerseba. Ingpasakay si Jacob it ida mga anak sa karusa nak ingpagamit ni Paraon, imaw ra kag inra mga maintik nak anak ag mga asawa. ");
INSERT INTO bno_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ingraya ra ninra katong inra mga hadop ag mga gamit nak inra napundar sa Canaan. Nagpagto sina Jacob sa Ehipto kanunot kag tanang ida mga inanak. ");
INSERT INTO bno_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Kanunot ni Jacob kag tanang ida mga anak, kag tanang ida mga umagar ag tanang ida inapo. Tanan-tanan nak ida mga anak ag mga apo ay ida ingraya ruto sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ngasing, imaw kali kag mga pangayan it mga inanak ni Israel it katong pagpagto ninra sa Ehipto. Kag mga anak nak kayake ni Jacob ay: Si Ruben nak ida panganay, ");
INSERT INTO bno_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ag kag ida anak nak kayake ay sina Hanoc, Palu, Hezron ag Carmi. ");
INSERT INTO bno_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Si Simeon ag ida mga anak nak kayake nak sina Jemuel, Jamin, Ohad, Jaquin, Zohar ag si Saul nak anak nida sa usang kabade nak Canaanhon. ");
INSERT INTO bno_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Si Levi ag ida mga anak nak kayake nak sina Gerson, Kohat ag Merari. ");
INSERT INTO bno_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Si Juda ag ida mga anak nak kayake nak sina Er, Onan, Sela, Perez ag Zera, pero sina Er ag Onan namatayey ruto pa yang sa Canaan. Kaibahan ra ninra pa-Ehipto kag mga anak nak kayake ni Perez nak sina Hezron ag Hamul. ");
INSERT INTO bno_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Si Isacar ag ida mga anak nak kayake nak sina Tola, Puva, Iob ag Simron. ");
INSERT INTO bno_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Si Zabulon ag ida mga anak nak kayake nak sina Sered, Elon ag Jaleel. ");
INSERT INTO bno_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Imaw kina kag mga anak nak kayake ni Jacob kang Lea nak ing-anak ruto sa lugar it Padan-aram. Nagkaanak ra sinra it usang kabade nak si Dina. Treyntay-tres (33) tanan kag inra mga inanak nak nakalista. ");
INSERT INTO bno_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Si Gad ag ida mga anak nak kayake nak sina Zipion, Hagui, Suni, Ezbon, Eri, Arodi ag Areli. ");
INSERT INTO bno_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Si Aser ag ida mga anak nak kayake nak sina Imna, Isva, Isvi, Beria ag pati kag usang kabade nak si Sara. Kaibhanan ra kag mga anak nak kayake ni Beria nak sina Heber ag Malkiel. ");
INSERT INTO bno_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Imaw kina kag mga anak nak kayake ni Jacob kang Zilpa nak kabulig ni Lea nak ingta-o it ida tatay nak si Laban. Disi-sais (16) tanan kag mga inanak nina Jacob ag Zilpa. ");
INSERT INTO bno_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Kag mga anak ray ra nak kayake ni Jacob sa ida asawa nak si Raquel ay sina Jose ag Benjamin. ");
INSERT INTO bno_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Kaumir ra rili sa listahan kag mga anak nak kayake nina Jose ag Benjamin nak ruto gianakan sa Ehipto. Kag mga anak nak kayake ni Jose kang Asenat nak anak ni Potipera nak saserdote sa banwa it On ay sina Manase ag Epraim. ");
INSERT INTO bno_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Kag mga anak nak kayake ni Benjamin ay sina Belyo, Beker, Asbel, Gera, Naaman, Eji, Ros, Mupim, Hupim ag Ard. ");
INSERT INTO bno_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Imaw kina kag mga anak nak kayake ni Jacob kang Raquel. Katorseng bilog (14) kina tanan nak inra mga inanak nak asa listahan. ");
INSERT INTO bno_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Si Dan ag kag ida usang anak nak kayake nak si Husim. ");
INSERT INTO bno_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Si Naptali ag ida mga anak nak kayake nak sina Jazeel, Guni, Jezer ag Silem. ");
INSERT INTO bno_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Imaw kina kag mga anak nak kayake ni Jacob kang Bilha nak kabulig ni Raquel nak ingta-o it ida tatay nak si Laban. Pito (7) tanan kag mga inanak nina Jacob ag Bilha. ");
INSERT INTO bno_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Purya sa ida mga kabading umagar, saisentay-sais (66) tanan kag mga inanak ni Jacob nak ingbilang sa ida pamilya sa ida pagpagto sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Katong mga anak nak kayake ni Jose nak naanak ruto sa Ehipto ay ruha (2). Sitenta (70) tanan kag mga myembro it pamilya ni Jacob nak napagto sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","It katong mayungotey sina Jacob sa Ehipto ingpauna nida si Juda papagto kang Jose agor mapatudlo kung hariin kag rayan papagto sa Gosen, ag it katong natudluey ni Jose kang Juda ay sida kag nagraya sa inrang tanan papagto sa Gosen. ");
INSERT INTO bno_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Pagkahalin ni Juda inghanra ni Jose kag ida karwahe agor mapagto sa Gosen, ag ruto sinra makita it ida tatay. Pagkaabot ni Jose ruto, ingpresentar nida kag ida sarili sa ida tatay ag nagkupkupan sinra, ag rugay kag inra tinibawan sa abaga it usa'g-usa. ");
INSERT INTO bno_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Nagsiling si Jacob kang Jose, “Ngasing, puydey ako nak mamatay dahil nakitaey nako kag imo uda ag naayamaney nako nak buhi ikaw.” ");
INSERT INTO bno_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Pagkatapos, nagpamuhon anay si Jose sa ida tatay ag sa ida mga hali, “Mapagto anay ako kang Paraon ag ako sida aumaan nak nag-abotey kag ako tatay ag ako mga hali halin sa Canaan. ");
INSERT INTO bno_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ako ra sida aumaan nak kamo ay mga manug-alaga it mga karnero, baka ag iba pang mga hadop, ag kali ay inro raya rili sa Ehipto pati tanang mga butang nak inro nahakot. ");
INSERT INTO bno_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Pag ipatawag kamo ni Paraon ag magpangutana sida sa inro kung ni-o kag inro trabaho ");
INSERT INTO bno_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","kali kag inro isabat sa ida, ‘Kami nak imo mga ulipon ay mga manug-alaga it mga hadop magtuna pa it katong maintik kami. Imaw ra kag amo ginikanan.’ Tuyar kali kag inro isiling sa ida agor ida kamo apaistaron dili sa Gosen, dahil sa pagmuyat it mga Ehiptohanon kag usang manug-alaga it karnero ay pinaka-kubos sa tanan.” ");
INSERT INTO bno_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Pagkatapos, nagpili si Jose it lima sa ida mga maguyáng agor ipakilaya sinra kang Paraon. Ag nagpagtoy sinra ruto kang Paraon. Nagsuyor anay si Jose ag nag-uma kang Paraon nak, “Nag-abotey halin sa Canaan katong ako tatay ag mga hali nak raya kag inra mga baka, karnero, kambing, ag tanang inra gamit. Ngasing, rahagtoy sinra sa lugar it Gosen.” ");
INSERT INTO bno_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tapos, ingpresentar ni Jose kang Paraon katong ida limang mga maguyáng. Nagpangutana si Paraon sa inra, “Ni-o kag inro trabaho?” Sabat ninra kang Paraon, “Halandong Paraon, kami nak imo mga ulipon ay manug-alaga it mga karnero ag iba pang mga hadop pareho it amo ginikanan.” ");
INSERT INTO bno_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Siling pa ninra sa ida, “Halandong Paraon, nagpali kami agor dili anay kami maistar sa Ehipto, dahil wayaey it maagsaman ruto sa Canaan dahil masyaroy kag tigkagutom ruto. Halandong Paraon, kami nak imo mga ulipon ay nagpapangabay nak kung maaari ay maistar anay kami ruto sa lugar it Gosen.” ");
INSERT INTO bno_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Nagbisaya si Paraon kang Jose, “Ngasing nak nakaabotey dili kinang imo tatay ag mga hali, ");
INSERT INTO bno_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","pili kamo it pinaka-maadong lugar dili sa bug-os nak Ehipto, ag kung gustoy ninro sa lugar it Gosen ay puyde ra nak ruto yangey kamo. Ag usa pa, kung inggwa ra sa inra it maayam mag-alaga it mga baka, pili-a sinra ag ipaalaga sa inra kag ako mga baka.” ");
INSERT INTO bno_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Masunor, ingpresentar ra ni Jose kag ida tatay kang Paraon. Ag ingbendisyunan ni Jacob si Paraon. ");
INSERT INTO bno_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pagkatapos, nagpangutana si Paraon kang Jacob, “Tang, pilang tuigey ikaw?” ");
INSERT INTO bno_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Sabat ni Jacob sa ida, “Halandong Paraon, syento treynta (130) anyosey kag ako pagpangabuhi rili sa kalibutan, pero maramong kahirapan kag ako nadangatan. Ag kag haba it ako kabuhi ay mas malip-ot kung ikumpara sa kabuhi it ako mga ginikanan. Pero pareho sa inra ay waya ra ako it permanenting istaran dili sa kalibutan.” ");
INSERT INTO bno_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","It katong sida ay mahaliney ay ingbendisyunan ray ni Jacob si Paraon. ");
INSERT INTO bno_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ag ingtuman ngani ni Jose katong sugo ni Paraon nak taw-an kag ida tatay ag mga hali it pinaka-maadong lugar nak maiistaran, nak ruto ngani sa Gosen, nak tong huli ay naging Rameses. ");
INSERT INTO bno_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Si Jose it nag-intyendi sa pagpakaon sa ida tatay, ag sa ida mga hali, ag sa inra mga sinakupan kumporme sa kinahangyan it bawat usa sa inra. ");
INSERT INTO bno_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ngasing, dahil abang masyaroy kag tigkagutom sa tanang bansa palibot it Ehipto ag wayaey nak gador it naturang pagkaon, kada kag mga tawo sa mga bansa it Ehipto ag Canaan ay lalong nagpakahirap pa. ");
INSERT INTO bno_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ingtipon ni Jose kag tanang kwarta nak ingbadar sa ida it mga taga-Ehipto ag taga-Canaan bilang kabaydo it mga pagkaon. Ag kali ay ida ingraya kang Paraon. ");
INSERT INTO bno_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","It katong naubusaney it mga kwarta kag mga tawo sa Ehipto ag sa Canaan, sinra ay nagpagto kang Jose ag nagpakitluoy, “Gobernador, taw-e baga kami it pagkaon. Asi, imo baga kami apabadaang mamatay sa imo atubangan? Ubosey nak gador kag amo kwarta.” ");
INSERT INTO bno_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Sabat sa inra ni Jose, “Kung wayaey kamo it kwarta ray-a rili kag inro mga alagang hadop ag ako abayduhon kina it inro pagkaon.” ");
INSERT INTO bno_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ngani, inra ingraya kag inra mga alagang hadop kang Jose. Ingbayduhan nida it pagkaon katong inra mga kabayo, karnero, kambing, baka ag asno. Ag sa bug-os nak tuig nak kato ay kang Jose sinra gibabaoy it pagkaon nak kabaydo it inra mga alagang hadop. ");
INSERT INTO bno_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tong masunor ray nak tuig ay nagbalik sinra kang Jose ag nagsiling, “Gobernador, indi namo gitaguon sa imo nak ubosey kag amo kwarta ag nabaydoy ra namo sa imo kag amo tanang mga hadop, ag wayaey it nabilin sa amo kundi kaling amo mga sarili ag amo mga duta. ");
INSERT INTO bno_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Asing kinahangyan nak mamatay kami sa imo atubangan ag mapabad-an kag amo mga duta. Bayduhan yangey kag amo mga sarili ag kag amo mga duta it pagkaon. Mapaulipon yangey kami kang Paraon agor indi kami mamatay. Ag kag amo mga duta ay kang Paraon yangey ra. Ag Gobernador, taw-e kami it mga binhi agor matamnan ray namo kato, pramas indi mapabad-an.” ");
INSERT INTO bno_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ag dahil nagpadayon pa kag tigkagutom, naubos it bakay ni Jose kag tanang duta sa bug-os nak Ehipto sa ngayan ni Paraon. ");
INSERT INTO bno_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ag pati tanang mga tawo sa bug-os nak Ehipto ay naging uliponey ra nida. ");
INSERT INTO bno_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kag waya yang napasa-ida ay katong mga duta it mga saserdote it Ehipto, dahil kato ay ta-o ni Paraon sa inra it katong una pa agor inra apangabuhian. Sinra ay ingpataw-an yang it pagkaon ni Paraon, kada bukoey ninra kinahangyan nak magbaydo it inra duta. ");
INSERT INTO bno_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ag nagbisaya si Jose sa mga tawo, “Panimati kamo sa ako ibisaya. Ngasing nak adlaw kamo ag kag inro duta ay nabakayey nako para kang Paraon. Ngasing ra, ataw-an kamo nako it mga binhi nak inro itanom sa inro mga duta nak nabakayey ni Paraon. ");
INSERT INTO bno_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ag sa tig-ani, mata-o kamo kang Paraon it usa sa limang kapartihan. Katong ap-at nak kapartihan ay inroy para sa binhi ag pagkaon it inro panimayay ag inro mga anak.” ");
INSERT INTO bno_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nagsabat sinra, “Salamat Gobernador nak imo kami ingsalbar. Kabay pang mamut-an kami nimo ag kami ay magiging mga ulipon ni Paraon.” ");
INSERT INTO bno_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tuna it kato inghimo ni Jose kag laye sa bug-os nak Ehipto, nak sa bawat ani kag usa sa limang kapartihan ay magiging buhis kang Paraon. Pero kag mga inanihan sa duta it mga saserdote ay buko sakop it kali. Hastang ngasing ay imaw gihapon kag inra patakaran sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Imaw kato kag pagkaistar nina Jacob sa bansa it Ehipto ruto sa lugar it Gosen. Sinra ay nag-uswag ag nagramo nak gador. ");
INSERT INTO bno_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Nag-istar si Jacob sa Ehipto sa sakop it disi-syeteng (17) tuig ag sida'y nag-abot sa edad nak syento kwarentay-syete (147) anyos. ");
INSERT INTO bno_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","It katong mayungotey si Jacob mamatay ay ida ingpapagto sa ida kag ida anak nak si Jose pramas magsiling sa ida, “Kag ako huling pangabay sa imo ay masumpa ka sa ako. Butangan kag imo damot dili sa ako pa-a, ag magsumpa ka nak imong gador ipakita kag imo kaaduhan ag katutom sa ako ag tumanon nak gador kaling ako ipangabay. Pag ako ay nagtaliwaney dili sa duta ag nagpapahuwayey kapisan it ako mga ginikanan, ayang gador ako giyubungan dili sa Ehipto, ");
INSERT INTO bno_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","kundi itupar nimo kag ako yuyubngan sa yuyubngan it ako ginikanan. Bay-a ako rili sa Ehipto ag ray-on ako sa Canaan agor ruto ako iyubong sa yuyubngan it ato pamilya.” Nagsabat si Jose, “Oho Tay. Atumanon nak gador nako kag imo mga panugon sa ako.” ");
INSERT INTO bno_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ag nagsiling si Jacob, “Sumpa sa ako!” Ag si Jose ay nagsumpa sa ida. Ag si Jacob ay nagrapa sa ida higraan, ag ida ingtukon kag ida uyo it ida damot agor magdayaw sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Pagkalipas it pilang adlaw, inggwa't nag-uma kang Jose nak grabey kag ida tatay. Kada ida ingnunot kag ida ruhang anak nak kayake nak sina Manase ag Epraim ruto sa ida tatay. ");
INSERT INTO bno_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","It katong naumaaney si Jacob nak nag-abotey si Jose, ingpilit nida kag ida sarili nak magbangon ag nag-ingkor sida sa ida higraan. ");
INSERT INTO bno_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Pag-abot ni Jose, nagsiling sa ida si Jacob, “It katong rahagto ako sa Luz sa Canaan, nagpakita sa ako kag Dios nak Makagagahom ag ako ay Ida ingpakamaado, ");
INSERT INTO bno_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","sa Ida pagsiling nak, ‘Aparamuon Nako kag imo mga inanak ag sinra ay magiging maramong linahi. Ag ita-o Nako sa inro kaling duta it Canaan agor maging inro panublion hastang sa waya't katapusan.’ ");
INSERT INTO bno_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ngani ngasing, kaling imo ruhang anak nak natawo rili sa Ehipto bag-o ako nag-abot dili ay akoey ingkikilaya bilang ako anak. Pareho kana Ruben ag Simeon, sina Manase ag Epraim ay kaumirey ra sa ako mga anak nak ataw-an it panublion. ");
INSERT INTO bno_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pero kung ikaw ay magkakainggwa pa it masunor nak mga anak ay responsibilidadey nimo sinra, ag sinra ay imo abilangon nak anakey ninrong mag-asawa. Ag kag inra apanublion ay mahalin kana Manase ag Epraim. ");
INSERT INTO bno_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kali ay alang-alang kang Raquel nak imo nanay. Dahil it katong pagbalik nako sa Canaan halin sa Padan-aram ay namatay sida mayado-yado pa bag-o mag-abot sa Eprata kung hariin ruto ra nako sida giyubngan, ag rako kag ako kalisor.” ");
INSERT INTO bno_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Dahil maruyomey kag pagmuyat ni Jacob, pagkakita nida sa mga anak ni Jose ay nagpangutana sida, “Sasin-o kali?” Nagsabat si Jose, “Tay, kali kag ako mga anak nak ingta-o sa ako it Dios rili sa Ehipto.” Siling ray ni Jacob, “Papayunguta baga sinra rili sa ako agor ako sinra abendisyunan.” Ngani, gingpasuor ni Jose kag ida mga anak kang Jacob ag nagyuhor sinra, ag sinra ay gingpangkupkupan ag gingpangharuan nida. ");
INSERT INTO bno_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ag nagsiling sida kang Jose, “Wayaey ako gihuna-huna nak makita pa kita, pero sa kaluoy it Dios ay Ida ingbuot nak buko yang ikaw kag ako makita kundi pati kaling imo mga anak!” ");
INSERT INTO bno_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Marugay-rugay, gingbaoy anay ni Jose kag ida mga anak sa pagkakupkop it inra Lolo Jacob agor sida ay makayuhor ra sa ida tatay. ");
INSERT INTO bno_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ag katong hanraey si Jacob nak magta-o it ida bendisyon dili sa ida ruhang apo ay gingpasuor ray sinra ni Jose sa inra lolo. Si Epraim sa wala ni Jacob, ag si Manase sa tu-o. ");
INSERT INTO bno_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pero gingpakuros ni Jacob kag ida damot ag kag tu-o ay gingbutang nida sa uyo ni Epraim aber imaw kali kag manghor, ag kag ida wala ay gingbutang sa uyo ni Manase nak imaw kag maguyáng. ");
INSERT INTO bno_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ag ida gingbendisyunan kaling mga anak ni Jose sa pagsiling, “Kabay pang pakamaaduhon kamo it Dios nak imaw kag Dios nak gingsunor it ako tatay nak si Isaac ag ako lolo nak si Abraham, Dios nak nagbantay sa ako tuna pa it kato hastang ngasing nak adlaw. ");
INSERT INTO bno_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Kabay pa nak kag anghel nak naglibre sa ako sa mga mayaing natabo ay imaw it magpakamaado sa inro. Kabay pa rang kag ako ngayan ag kag ngayan it ako tatay nak si Isaac, ag ngayan ra it ida tatay nak si Abraham ay ray-on ninro, ag paramuon sa ibabaw it kalibutan.” ");
INSERT INTO bno_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pagkakita ni Jose nak gingpakuros ag gingbutang ni Jacob kag ida tu-o nak damot kang Epraim ay napayain sida. Kada ngani ginghuytan nida kag tuong damot ni Jacob ag isaydo tan-a nida kina halin sa uyo ni Epraim papagto kang Manase. ");
INSERT INTO bno_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ag napasiling sida, “Tay, sala kina. Imaw kali kag panganay. Dapat dili nimo ibutang kag imo tuong damot sa ida uyo.” ");
INSERT INTO bno_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pero nagrason si Jacob, “Ayam nako Toto kag ako ginghihimo, ayam nako. Mauswag ra si Manase ag kag ida mga inanak, ugaling mas magiging mauswag kisa sa ida kag ida manghor nak si Epraim. Ag kag ida mga inanak ay magiging mas maramo nak maragkong mga nasyon.” ");
INSERT INTO bno_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ngani sinra ay ida gingbendisyunan sa pagsiling, “Agamiton it mga Israelinhon kag inro mga pangayan sa pagta-o it inra mga bendisyon. Masiling sinra, ‘Kabay pang kag pagpakamaado it Dios sa inro ay pareho sa ingta-o it Dios kana Epraim ag Manase.’ ” Imaw kali kung asing nauna si Epraim kang Manase. ");
INSERT INTO bno_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Pagkatapos, nagsiling si Jacob kang Jose, “Panimati To! Ako'y mayungotey mamatay, pero kag Dios ay kaibahan gihapon nimo ag Sida kag mabalik sa imo ruto sa Canaan nak duta it imo mga ginikanan. ");
INSERT INTO bno_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ag usa pa, ikaw kag mapanubli it mas marako kisa sa imo mga hali. Sa imo nako ita-o katong lugar it Siquem, tong maadong bukir nak naraugan it ako espada ag pana laban sa mga Amornon.” ");
INSERT INTO bno_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ag ingpatawag ni Jacob kag ida tanang mga anak ag nagsiling sida, “Maley kamo sa ako agor ako isiling sa inro kag matatabo sa inro sa palaabuton. ");
INSERT INTO bno_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Mga anak nako payungot kamo it maado ag panimati-i kag ibisaya it inro tatay. ");
INSERT INTO bno_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ikaw Ruben, nak ako bungayan, bunga it ako kusog, balor it ako pagkakayake. Sa tanang ako mga anak ikaw kag pinaka-maisog, ag ikaw ra kag pinaka-makusog. ");
INSERT INTO bno_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tuyar sa baha nak indi mapunggan, ikaw ay rali-rali, indi mapigahan. Kag kabantugan indi nimo maaguman. Sa higraan nako nak imo tatay, ay imo gingsublian, ag kag ako pagkakayake ay imo nabuhinan.” ");
INSERT INTO bno_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Kamo Simeon ag Levi, ay magmanghor nak gador, kag inro mga sunrang ay pangmatay sa tawo. ");
INSERT INTO bno_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Sa inro mga hinuon, indi ako gipaibhon. Sa inro ahimuon, indi ako giumiron. Dahil sa inro subrang pagka-mahangiton ingmatay ninro kag tawo, ag baka ay inro piniang para yang inro idam-an. ");
INSERT INTO bno_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Subrang magtanom kamo it kahangit, sa inro kapintas abusungon it Langit, sa ako mga anak kamo ay mabubuyag, sa banwa't Israel, kamo ay makadat.” ");
INSERT INTO bno_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda, ikaw kag ipagmarako it imo kahalihan, mga liog it imo kalaban ay imo mahuhuytan, masinuong kag imo mga hali sa imo atubangan. ");
INSERT INTO bno_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ikaw Juda, ay tuyar sa maisog nak liyon, mayuko ray pagkasiba sa imo akaunon, hanrang magpanukob ray pag ikaw ay mangiton. ");
INSERT INTO bno_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kag baston it hari ay imo ahuytan. Juda kag marumaya sa rugay nak panahon hasta sa pag-abot it hari sa tanan, hariin ay sa ida masunor tanan nak nasyon. ");
INSERT INTO bno_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Mabuduboy kag bunga it ubasan it ida mga kaanakan. Kada, inra apasugtan nak kag inra asno sa puno ahigtan, pramas sinra ay makakaon it rahon it ubas. Kag duga it ubas ay bugana ra, kada inra baro ay puyding bunakan raha, sa duga nak abang puya nak tuyar sa rugo. ");
INSERT INTO bno_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Kag imo mga mata'y mapungay pay tuyar sa ayak, kag imo mga ngisi'y maputi nak pay gatas.” ");
INSERT INTO bno_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Ikaw Zabulon, ay mayungot sa ragat kag aistaran, mga ramyog ag batil, ikaw kag rungguan, hastang Sidon kag imo giryunan.” ");
INSERT INTO bno_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Ikaw Isacar, ay tuyar sa usang makusog nak asno, sa tunga it imo rayang mabug-at ikaw ay mayuko. ");
INSERT INTO bno_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kag imo pagpahuway ay imo maiilaan, kag dutang atungnan ay imo mamumut-an, kada imo ita-o kag imo abaga agor mapas-an, ag sa paghurnal ikaw ay mapipilitan, nupay ulipon kag imo asamputan.” ");
INSERT INTO bno_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Ikaw Dan, kag mapanguna ag mahusgar sa imo banwa, bilang usang tribo it mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ikaw ay magiging tuyar sa sawang sa rayan ay nag-uulikon, buoy it kabayong marayan ay imo atukbon, tawong nagsasakay patalikor nak ida ahuyugon.” ");
INSERT INTO bno_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“GINO-O, ako'y naghuhuyat it imo pagluwas.” ");
INSERT INTO bno_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Ikaw Gad, ay ayusubon it mga tulisan, ugaling sinra'y mararaog nimo ag mababayusan.” ");
INSERT INTO bno_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ikaw Aser, ay mahuman it malasang pagkaon, buko kahuhuda maski hari kag makaon.” ");
INSERT INTO bno_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Ikaw Naptali nak matam-is magbisaya, ay tuyar sa nabubuhiang usa nak kag mga ging-aanak ay kaginanda.” ");
INSERT INTO bno_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Ikaw Jose, ay tuyar sa sangang mabunga nak nagtubo mayungot sa tuburan, sa liwas it kuray, sanga nimo ay naggapa. ");
INSERT INTO bno_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ikaw ay tuyar sa ilahas nak gingpana it mga mangangadam nak nagta-o sa imo't rakong kalisuran. Ilam ngani asing ikaw ninra'y ginghangitan, ikaw rabuno ay inra gingpahirapan. ");
INSERT INTO bno_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ugaling ikaw ay nagtinrog ag naglaban, perming nagpipisik kag panang ginghuhuytan, dahil kag imo damot ay gingpakusog it Gamhanan nak Dios ni Jacob, Haliging Bato it Israel, ag imaw kag Pastor. ");
INSERT INTO bno_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Kag Dios it imo tatay nak Makagagahom, mabulig sa imo, ikaw ay apakamaaduhon. Abugnaan ka Nida, it uyan nak langitnon, pati it tubing bugnang naghahalin ruto sa irayom, ag ikaw, pati kag imo mga hadop ay aparamuon. ");
INSERT INTO bno_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Gingpakamaado ako it Dios nak Gamhanan, yabaw pa sa bugnang bukir nak waya't katapusan, yabaw pa ra sa tubas it matabang kabukiran. Kabay pa Jose, imo ra kali maaguman, ikaw nak nabuyag sa imo kahalihan.” ");
INSERT INTO bno_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Ikaw Benjamin, ay tuyar sa ilahas nak iro nak makagor, sa aga ay mapanukob it imo akaunon, sa gab-i ay mapangruyak gihapon.” ");
INSERT INTO bno_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Imaw kali kag naging doseng lahi ni Israel ag imaw kali kag panugon ag bendisyon it inra tatay nak si Israel sa bawat usa sa inra. Kada usa sa inra ay ingbendisyunan it angay sa bawat usa. ");
INSERT INTO bno_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Pagkatapos, ida gingtugon kag ida mga anak sa pagsiling, “Ngasing nak abay-oney ako it Dios agor magpahuwayey kapisan it ako ginikanan, ruto ninro ako iyubong sa tupar ninra, ruto sa kuyba it Macpela sa Canaan, ruto sa patag nak atubang sa subatan it duta ni Mamre. Katong ingbakay it ato Lolo Abraham kang Epron nak Hetanhon, agor maging yuyubngan nato. ");
INSERT INTO bno_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ruto giyubngan si Lolo Abraham ag kag ida asawa nak si Lola Sara. Ruto ra giyubngan kag ako tatay ag nanay nak sina Isaac ag Rebeca, ag ruto ra nako giyubngan kag ako asawa nak si Lea. ");
INSERT INTO bno_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Imaw kato kag patag ag kuyba nak gingbakay halin sa mga Hetanhon. Ruto ra ninro ako iyubong.” ");
INSERT INTO bno_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Pagkatapos it ida panugon ay naghigraey sida ag namatay. ");
INSERT INTO bno_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Pagkamatay ni Jacob, si Jose ay nagpakakupkop sa ida ag nagpakatibaw ag gingharuan kag ida uda. ");
INSERT INTO bno_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Pagkatapos, gingpabalsamo ni Jose kag ida tatay sa mga balsamador nak nagsiserbisyo sa ida. ");
INSERT INTO bno_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kada ingbalsamo ninra si Jacob it para sa kwarenta (40) nak adlaw nak imaw talaga kag haba it inra pagbalsamo, ag si Jacob ay inra gingramayan, pati ra it mga Ehiptohanon sa suyor it sitenta (70) nak adlaw. ");
INSERT INTO bno_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Pagkalipas it sitentang adlaw nak ingramayan kag ida tatay ay nagpangabay si Jose sa usang opisyales ni Paraon, “Kung puyde ay pamunhan anay baga ako kang Paraon nak makapagto sa Canaan agor iyubong kag ako tatay. ");
INSERT INTO bno_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Dahil bag-o sida namatay ay gingpasumpa ako nida, nak pag sida ay mamatay ay iyubong nako sida ruto sa yuyubngan nak ida inghanra para sa ida sarili ruto sa Canaan. Kada ngani kung maaari nganat ay tugutan nida ako nak iyubong ruto kag ako tatay. Pagkatapos ay mabalik ra ako.” ");
INSERT INTO bno_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nagbalik katong ida gingsugo nak opisyales ag nagsiling, “Nagsugot si Paraon. Pagtoy kuno kamo ag iyubong kinang imo tatay kumporme sa imo sinumpaan.” ");
INSERT INTO bno_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","8","Kada, gingrapit nina Jose kag ida tatay, kaibahan kag tanang ida panimayay, kag tanang panimayay it ida tatay, kag ida mga hali ag kag tanang inra mga panimayay, purya yang sa maintik nak mga anak nak ingtugyanan sa inra mga manugbantay, ag sa tanang inra mga kahadupan nak nabilin sa Gosen. Nagrapit ra kag tanang opisyales it bansa it Ehipto, ag kag tanang mga maguyang sa panimayay ni Paraon, ag kag tanan nidang mataas nak mga kabulig. ");
INSERT INTO bno_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kanunot ra kag mga sundalo nak nakakabayo ag nakasakay sa inra mga sasakyan. Ngani, abang ramong tawo kag nagrapit kang Jacob! ");
INSERT INTO bno_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pag-abot ninra ruto sa giukan ni Atad sa tabok it Suba it Jordan, ruto sinra gipanambitan it makusog ag nagkalisor sinra para sa minatay sa suyor it pitong adlaw. ");
INSERT INTO bno_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","It tong marunggan it mga Canaanhon kag abang kusog nak pagpanambitan ruto sa giukan ni Atad, nagsiling sinra, “Aroy! Abang kusog kag panambitan it kaling mga Ehiptohanon!” Dahil sa panambitan it mga Ehiptohanon gingtawag ninra katong lugar nak Abel-Misraim, nak kag gustong bisayahon ay “Panambitan it mga Ehiptohanon.” ");
INSERT INTO bno_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Imaw kali kag inghuman it mga anak ni Jacob bilang pagtuman sa ida panugon. ");
INSERT INTO bno_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ngani, ingraya ninra si Jacob ruto sa Canaan ag ingyubong sa kuyba sa patag it Macpela, atubang sa subatan it duta ni Mamre, nak ingbakay ni Abraham kang Epron nak Hetanhon. ");
INSERT INTO bno_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Pagkayubong ni Jose sa ida tatay ay nagbalikey sida sa Ehipto kanunot kag ida mga hali ag tanan nak nagnunot sa pagrapit sa ida tatay. ");
INSERT INTO bno_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ngasing nak minatayey kag inra tatay ay nahadlok ray kag mga maguyáng ni Jose ag nagsiling sinra, “Hangit pa ara si Jose sa ato? Sabaling ngasing ay bayusan nida kita sa tanang ato ginghimong mayain sa ida.” ");
INSERT INTO bno_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kada nagparaya sinra it suyat kang Jose nak nagsisiling, ");
INSERT INTO bno_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Bag-o namatay kag ato tatay ay gingsugo nida kami nak isiling sa imo kali, ‘Kabay pang patawaroney ra nimo kag imo mga maguyáng sa inra mga kasal-anan ag sa mga mayain nak nahuman ninra sa imo.’ Kada ngani kabay pang patawaroney nimo kami nak mga ulipon it Dios it imo tatay.” Pagkabaton ag pagkabasa ni Jose it kaling suyat, sida ay napatibaw. ");
INSERT INTO bno_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ag nagpagto kag mga maguyáng ni Jose ruto sa ida. Nagyuhor sinra sa ida ag nagsiling, “Hali kami, agor imo maging mga ulipon.” ");
INSERT INTO bno_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pero nagsabat si Jose, “Aya kamo gikahadlok! Sin-o ako agor maghusgar sa inro! Buko ra ako Dios. ");
INSERT INTO bno_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tama, inghumanan ninro ako it mayain pero ingtugutan kali it Dios para malibri sa kamatayon kag maramong tawo, ag kitang tanan ra. ");
INSERT INTO bno_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kada aya kamo gikahadlok! Ako it bahala sa inro ag sa inro mga anak.” Imaw kali kag ida gingsiling, kada nabaoy kag inra kahadlok ag natanrog kag inra mga tagipusuon. ");
INSERT INTO bno_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ngani, si Jose ag kag mga panimayay it ida tatay ay ruto gitiner sa Ehipto. Nag-abot si Jose sa edad nak syento dyes (110) anyos. ");
INSERT INTO bno_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Naabutan pa nida kag mga anak ni Epraim ag mga apo sa tuhor nida kang Maquir nak anak ni Manase. Ingbilang nida kinang mga anak ni Maquir nak ida ra sariling mga anak. ");
INSERT INTO bno_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Tong huli, nagsiling si Jose sa ida mga hali, “Mayungotey ako mamatay. Aya kamo gikalibog, abantayan kamo it Dios ag abay-on kamo rili agor ibalik ruto sa lugar nak Canaan nak imaw kag lugar nak ingpromisa it Dios kana Lolo Abraham ag Lolo Isaac, ag imaw ra sa ato tatay nak si Jacob.” ");
INSERT INTO bno_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kada ingpasumpa ni Jose kag mga inanak it ida tatay nak si Israel sa pagsiling, “Pag bay-oney kamo rili it Dios, ray-a nak gador kag ako mga suká halin dili.” ");
INSERT INTO bno_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Pagkamatay ni Jose sa edad nak syento dyes (110) anyos, sida ay ingbalsamo ag ingbutang sa kabaong nak inghipir sa Ehipto.");
INSERT INTO bno_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Riling libro ay ing-iistorya kag mga natabo sa mga lahi it mga Israelinhon nak halin kang Jacob. Pagkatapos it mahabang tigkagutom sa lugar it Canaan, sina Jacob ag ida mga anak, kaibhanan kag inra mga pamilya, ay nagpanaw papagto sa bansa it Ehipto kung hariin kag ida usang anak nak si Jose ay gobernador ruto. Imaw kali kag mga pangayan it mga anak ni Jacob nak ingtatawag rang Israel, nak nagpagto sa bansa it Ehipto, kaibhanan kag inra mga pamilya. ");
INSERT INTO bno_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Sinra ay sina Ruben, Simeon, Levi, Juda, ");
INSERT INTO bno_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulon, Benjamin, ");
INSERT INTO bno_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan ag Naptali, Gad ag Aser. ");
INSERT INTO bno_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Kada, sinrang tanan nak mga inanak ni Jacob nak nagpagto sa Ehipto ay sitenta (70), kaumirey kag ida usang anak nak si Jose nak rugayey ruto. ");
INSERT INTO bno_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Pagkalipas it mahabang panahon, sina Jose ag kag ida mga haling kayake, pati kag inra mga katubô ay namatay. ");
INSERT INTO bno_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ugaling kag inra mga lahi nak ingtatawag nak mga Israelinhon ay mabuar, matulin kag pagramo ag pagkusog hastang nagpakaramoey sinra. Ngani, halos napuno ninra kag lugar nak inra ing-iistaran ruto sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Naglipas kag marugay ray nak panahon nak nagbaydo-baydo it mga hari sa Ehipto, hastang nagkainggwa't bag-ong hari nak waya't ayam tungor sa dating gobernador nak si Jose. ");
INSERT INTO bno_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Nagsiling kaling hari sa ida mga kasimanwa, “Muyati, mas maramoey ag mas makusog pa sa ato ngasing kaling mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Dapat natong mausahan sinra, sabaling mapakaramo pa sinra. Ag kung gerahon kita it ato mga kaaway ag mag-apin pa kali, ay asamantalahon ninra nak sinra ay makahalin dili.” ");
INSERT INTO bno_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ngani, kag mga Israelinhon nak ingtatawag rang Hebreo, ay gingpabantayan sa mga mapintas nak mga manugmanda ag mga kapatas, agor piliton sinra nak magtrabaho ag pahirapan. Sinra ay gingpilit it hari nak imaw kag Paraon it Ehipto, nak magpatugrok it ruhang syudad, nak kag ngayan ay Pitom ag Rameses, agor kato ay maging tipunan it pagkaon ag manggar nida. ");
INSERT INTO bno_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero sa yudo nak gingpapahirapan sinra it mga Ehiptohanon ay lalo pa nganing nagramo sinra ag lalo pang nagkalat ruto. Kada sinra'y ginghangitan ag gingkahadlukan it mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Dahil rili, kag mga Israelinhon ay lalong gingpintasan parayan sa pagpatrabaho it pamatay-matay sa inra. Gingpahirapan sinra sa paghuman it mga bloke, sa pagpatugrok, ag sa tanang klase it trabaho sa uma it mga Ehiptohanon. Ag waya nak gador sinra it kaluoy sa inra. ");
INSERT INTO bno_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Usang adlaw gingbisayahan it inra hari nak Paraon kag mga Hebreo nak paltera. Kag usang gingkikilaya sa inra ay si Sipra ag kag usa ay si Pua. ");
INSERT INTO bno_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Nagsiling si Paraon sa inra, “Pag magpaanak kamo sa inro mga kalahi ag nakita ninro nak kali ay kayake, matya kali, pero pag kabade, pabad-e yang nak sida ay mabuhi.” ");
INSERT INTO bno_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ugaling kaling mga paltera ay inggwa't kahadlok sa Dios kada waya ninra gisunra kag sugo it hari, kundi inra gingpabad-an nak mabuhi aber kali ay kayake. ");
INSERT INTO bno_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ag katong nasaduran kali ni Paraon, gingpatawag nida kaling ruhang paltera ag gingbistigar, “Asing waya ninro gimatya kag mga kayaking anak? Asing inro gingpabad-an nak mabuhi sinra?” ");
INSERT INTO bno_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Sabat it kaling ruha kang Paraon, “Halandong Paraon, kag mga kabading Hebreo ay buko tuyar sa mga kabading Ehiptohanon. Makusog sinra ag abang rali kag inra pag-anak kada bag-o pa kami mag-abot ay nakaliwasey kag anak.” ");
INSERT INTO bno_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ngani, ingpakamaado it Dios kaling ruhang paltera. Ag kag mga Israelinhon ay padayon nak nagramo ag nagkusog. ");
INSERT INTO bno_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ag dahil kaling ruhang paltera ay inggwa't kahadlok sa Dios, gingkaluy-an Nida sinra ag nagkainggwa sinra it inra sariling mga anak. ");
INSERT INTO bno_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ngasing, gingsugo ni Paraon kag tanang Ehiptohanon, it tuyar kali, “Tanang kayake nak matatawo it mga Hebreo ay pilakan ninro sa Suba it Nilo, pero kag mga kabade ay inro apabad-an nak mabuhi.” ");
INSERT INTO bno_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ngasing, inggwa't usang kayake nak halin sa lahi ni Levi nak nakapangasawa it halin ra sa lahi ni Levi. ");
INSERT INTO bno_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Kaling kabade ay nagsabak ag nagkaanak it kayake. Pagkakita nida nak gwapo kaling ida anak, ida kali gingtago sa suyor it tatlong buyan. ");
INSERT INTO bno_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tong nakita nida nak indiey matago kaling anak, nagbaoy sida it basket nak human sa yawas it tigbaw ag ida kali pinahiran it alkitran. Pagkatapos, gingsuyor nida rili kag anak, ag binutang sa tunga it mga mataas nak hilamunon sa habig it suba. ");
INSERT INTO bno_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kag ida maguyáng nak kabade ay hagto sa mayado-yado nagbabantay sa ida agor ayamon kung ni-o kag matatabo sa ida manghor. ");
INSERT INTO bno_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Niong ado ra nak katong adlaw nak kato ay ruto ra sa Suba it Nilo, nagkakaligos kag anak nak rayaga it inra hari nak Paraon. Habang sinra it ida mga dama ay nagpapanaw sa habig it suba, nakita nida kaling basket sa tunga it mga hilamunon. Kada gingsugo nida kag usa sa ida mga suguon nak bay-on kato. ");
INSERT INTO bno_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Pagkabaton nida, binuksan kali ag nakita nida kag anak. Ag kali ay nagtitibaw. Naluoy sida riling anak ag napasiling, “Kaling anak ay anak it usang Hebreo.” ");
INSERT INTO bno_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kag inghuman ngasing it katong maguyáng nak nagbabantay ay nagsuor sa inra ag nagpangutana sa rayagang anak ni Paraon, “Mam, gusto baga nimo nak hanapan ka nako it manug-alaga nak halin sa mga Hebreo, agor inggwa't mapasuso riling anak para sa imo?” ");
INSERT INTO bno_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Sabat it kaling anak ni Paraon, “Hala! Pagtoy!” Kada gingsapoy it kaling anak kag ida nanay ag ingraya sa anak ni Paraon. ");
INSERT INTO bno_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pag-abot ninra ruto, nagsiling kaling anak ni Paraon sa nanay, “Ray-a kaling anak ag alaga-e sida para sa ako. Ako ikaw aswelduhan.” Kada rinaya it kaling nanay kag ida anak sa inra ag ida ray ingripara. ");
INSERT INTO bno_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Tong nagrakoey kaling anak, gingraya sida it ida nanay sa anak ni Paraon. Ag gingbilang sida nak matuor nak anak it prinsesa. Gingpangayanan nida kali nak Moises, dahil siling nida, “Ginghaw-as nako sida sa tubi.” ");
INSERT INTO bno_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Usang adlaw, tong si Moises ay di edadey, gingpasyaran nida kag ida mga kalahing Hebreo. Ag nakita nida kung pauno't bug-at kag inra mga gingtatrabaho. Nakita ra nida kag usang Ehiptohanon nak gingbabalbal kag usang ida kalahing Hebreo. ");
INSERT INTO bno_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nagpanglingat-lingat anay sida, ag tong ida nakita nak waya't nakakamalay sa ida, gingmatay nida kaling Ehiptohanon bag-o ingyubong. ");
INSERT INTO bno_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Pagkaaga ay nagbalik ray sida ag ida nakita kag ruhang Hebreo nak nag-aaway. Gingsilinggan nida kag kayake nak di sala, “Asing imo gingsusuntok kag imo kasimanwang Hebreo?” ");
INSERT INTO bno_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Nagrason kali, “Asi, sin-o ka nak mahusgar sa amo? Amatyon ra baga nimo ako tuyar sa imo pagmatay it tahapon sa usang Ehiptohanon?” Pagkarungog kali ni Moises hinadlukan sida, ag naisip nida nak siguro ayamey it mga tawo kag ida nahimo. ");
INSERT INTO bno_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pagkasador kali ni Paraon, ipamatay tan-a nida si Moises, ugaling nakatakasey sida papagto sa lugar it Midian. Pag-abot nida ruto, sida ay nagpahuway sa usang bal-ong. ");
INSERT INTO bno_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ngasing, inggwa ruto sa Midian it saserdote nak kag ngayan ay Reuel, nak gingtatawag rang Jetro. Kaling saserdote ay inggwa't pitong rayagang anak. Ag waya narugay nag-abot kaling pitong rayaga pramas pun-on kag mga painuman it mga karnero ag kambing it inra tatay. ");
INSERT INTO bno_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nag-abot ra kag iba pang mga kayaking manugbantay it hadop ag gingpahalin sinra. Nagtinrog ngasing si Moises ag gingbuligan kaling mga kabade sa pagpainom it inra mga hadop. ");
INSERT INTO bno_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Pagpauli ninra sa inra tatay nak si Reuel, gingpangutana sinra, “Asing abang rali kamo kapauli ngasing?” ");
INSERT INTO bno_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Nagsabat sinra, “Inggwa't usang Ehiptohanon nak nag-apin sa amo sa mga kayaking manugbantay it hadop. Gingbuligan pa kami nida sa pagpainom it ato mga karnero ag kambing.” ");
INSERT INTO bno_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ag siling it inra tatay, “Ay hariiney katong tawo? Asing inro sida gingbadaan? Sapuya anay kato agor sida ay makakaon.” ");
INSERT INTO bno_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Tuna it kato, rutoy nag-istar si Moises hastang ingpaasawa sa ida ni Jetro kag usang anak nida nak si Zipora. ");
INSERT INTO bno_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nag-abot kag adlaw nak nagkaanak si Zipora it kayake. Ag gingpangayanan kali ni Moises nak Gersom, dahil siling nida, “Ako ay buko taga-rili.” ");
INSERT INTO bno_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Tuna it katong pag-abot ni Moises sa Midian, sa suyor it katong mga tuig, namatay si Paraon nak hari it Ehipto. Ugaling kag mga Israelinhon ay ulipon gihapon it mga Ehiptohanon hastang sinra ay napatibaw sa kahirapon. Ag kag inra paghagar it tabang ay nakaabot sa Dios. ");
INSERT INTO bno_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Gingrungog it Dios kag inra mga aguyo ag gingrumrom Nida kag Ida kasugtanan kang Abraham, kang Isaac ag kang Jacob. ");
INSERT INTO bno_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nakita nak gador it Dios kag hirap nak kahimtangan it mga Israelinhon ag nabayaka Sida sa inra. ");
INSERT INTO bno_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ngasing, tuna it katong si Moises ay ruto giistar sa Midian, sida'y kag nagbabantay ag nagriripara it mga karnero ag kambing it ida panugangan nak si Jetro, nak imaw kag saserdote it Midian. Usang adlaw ida ging-agsam kag inra mga hadop sa unhan it disyerto, ag nakaabot sinra sa baguntor it Horeb, nak imaw kag ingsisiling nak baguntor it Dios. ");
INSERT INTO bno_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ruto, nagpakita sa ida kag anghel it GINO-O, parayan sa mga nagrarayab-rayab nak kayado sa tunga it usang mababang kahoy. Gingmuyatan ni Moises kaling kahoy, ag nakita nida nak kali ay sige kag rayab-rayab pero waya ra nasusunog. ");
INSERT INTO bno_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Napasiling si Moises sa ida sarili, “Katitingaya kali! Maliko ako ag amuyatan nako kung asing waya nasusunog kaling kahoy.” ");
INSERT INTO bno_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tong nakita it GINO-O nak nagliko sida papayungot riling kahoy, gingtawag Nida sida halin sa tunga it kaling kahoy, ag nagsiling, “Moises, Moises!” Ag nagsabat si Moises, “Hali ako.” ");
INSERT INTO bno_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ag nagsiling kag Dios, “Aya anay gipakapayungot. Ubaha kinang imo sandalyas, dahil kag lugar nak imo gingtutungtungan ay balaan.” ");
INSERT INTO bno_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ag siling pa it Dios sa ida, “Ako kag inro Dios, nak gingdadayaw it imo tatay, Dios it imo mga ginikanan nak sina Abraham, Isaac ag Jacob.” Pagkarungog kali ni Moises, gingtabunan nida it ida damot kag ida uda dahil nahadlok sida nak magmuyat sa Dios. ");
INSERT INTO bno_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Masunor, nagsiling ray kag GINO-O sa ida, “Nakita nak gador Nako kung pauno gingpapahirapan kag Ako mga katawuhan ruto sa Ehipto. Ag narungog ra Nako kag inra mga pagtibaw ag pagpatabang sa Ako, dahil sa inra mga mapintas nak kapatas. Nababayaka talaga Ako sa inra. ");
INSERT INTO bno_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kada nagpilhig Ako agor sinra ay luwason ag bay-on halin sa pagkaulipon it mga Ehiptohanon. Bag-o aray-on Nako sinra ruto sa usang maado ag mayapar nak lugar kung hariin ay bugana kag pagkaon nak pay nagbabaha kag gatas ag rugos. Katong lugar nak ging-iistaran it mga Canaanhon, Hetanhon, Amornon, Pereznon, Hebinhon ag Jebusnon. ");
INSERT INTO bno_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Narurungog nak gador Nako kag pagpatabang sa Ako it mga Israelinhon. Ag nakita ra Nako kag pag-ihig nak ginghihimo sa inra it mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kada ngasing, pagtoy! Asuguon ka Nako kang Paraon agor imo haw-ason kag Ako mga katawuhan nak mga Israelinhon, halin sa Ehipto.” ");
INSERT INTO bno_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ugaling nagsabat si Moises sa Dios, “Aroy! Sin-o ako nak maatubang sa Paraon, ag mahaw-as sa mga Israelinhon halin sa Ehipto?” ");
INSERT INTO bno_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Sabat it Dios, “Aya gikahadlok, aibhan ka Nako. Ag imaw kali kag pamatuor sa imo nak Ako kag nagsusugo sa imo. Pag imo'y nahaw-as kag Ako mga katawuhan halin sa Ehipto, mabalik kamo riling baguntor ag madayaw sa Ako.” ");
INSERT INTO bno_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Nagsiling gihapon si Moises sa Dios, “Pag magpagto nako sa ako mga kasimanwang Israelinhon ag magsiling sa inra, ‘Kag ato Dios, nak Dios it ato mga ginikanan ay nagsugo sa ako papali sa inro.’ Ay kung magpangutana sinra sa ako, ‘Siong dios kato? Ni-o kag ida ngayan?’ Ay ni-o kag ako isabat sa inra?” ");
INSERT INTO bno_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Sabat it Dios sa ida, “Ako ay Akoy. Silingga kag imo mga kasimanwa nak ‘Ako ay Akoy’ kag Dios nak nagsugo sa imo para sa inra.” ");
INSERT INTO bno_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Siling pa it Dios sa ida, “Silingga pa sinra, ‘Ako ay Akoy nak imaw si Yahweh, kag Dios it inro mga ginikanan, Dios ni Abraham, Dios ni Isaac ag Dios ni Jacob. Ako kag nagsugo sa imo para sa inra.’ Imaw kali kag Ako ngayan hastang sa waya't katapusan, kag ngayan nak dapat nak rumrumon hastang sa pagbalhin it inro mga lahi. ");
INSERT INTO bno_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Pagtu-e ag tipunon kag inro mga pinuno, ag silingga sinra nak ikaw ay ingsugo ni Yahweh nak imaw kag Dios it inro mga ginikanan, Dios ni Abraham, Dios ni Isaac ag Dios ni Jacob. Nagpakita nganat Sida sa ako ag nagsiling Sida nak, ‘Ingruaw Nako kamo ag nakita Nako kung pauno kamo gingpapahirapan it mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ag dahil dili Ako kamo abay-on rili sa Ehipto, ag aray-on ruto sa lugar it mga Canaanhon, Hetanhon, Amornon, Pereznon, Hebinhon, ag Jebusnon, rutong lugar kung hariin ay bugana kag pagkaon nak pay nagbabaha kag gatas ag rugos.’ ” ");
INSERT INTO bno_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ag katong mga pinuno ay mapanimati sa imo isiling, ag ikaw kaibhanan sinra ay mapagto ag maatubang sa hari it Ehipto. Kali kag inro isiling sa ida, ‘Kag GINO-O nak imaw kag ingdadayaw namong mga Hebreo ay nagpakita sa amo. Kada gingpapangabay namo sa imo, Halandong Paraon, nak sugtan kami nimo nak magbaktas it tatlong adlaw papagto sa disyerto agor ruto namo ahikuton kag amo inughalar sa GINO-O nak amo Dios.’ ");
INSERT INTO bno_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pero ayam Nako nak indi magsugot kag hari it Ehipto nak kamo ay mapagto kung indi sida gipiliton. ");
INSERT INTO bno_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ngani, matatagman ninra kag Ako rakong parusa ag maaaguman ninra kag mga kahahadlok nak pasilot. Ag pagkatapos it kina, asugtaney kamo nida nak maghalin.” ");
INSERT INTO bno_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ag siling pa it Dios, “Ako abut-on nak maging mabuot sa inro kag mga Ehiptohanon pramas taw-an kamo it pabor agor paghalin ninro indi kamo magpanaw nak limbay. ");
INSERT INTO bno_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kag inro mga kabade ay mahagar sa inra mga kayungot nak mga Ehiptohanon ag sa inra mga amo it mga alahas nak pilak ag buyawan, ag mga baro. Ag kali ay inro ipasuksok sa inro mga anak nak kayake ag kabade. Parayan dili inro apangbay-an it mga ari-arian kag mga Ehiptohanon.” ");
INSERT INTO bno_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ngasing, nagsabat si Moises sa GINO-O, “Kung indi magpati sa ako kag ako mga kasimanwang Israelinhon ag magsiling sinra, ‘Waya ra gipakita sa imo kag GINO-O!’ Ay ni-o kag ako ahimuon?” ");
INSERT INTO bno_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nagsabat kag GINO-O sa ida, “Ni-o kinang imo hudot?” Sabat nida, “Bakulo.” ");
INSERT INTO bno_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ag nagsiling kag GINO-O, “Buhi-i kina sa raga.” Gingbuhian matuor kali nida sa raga ag kali ay naging sawa. Ag si Moises ay napaisol. ");
INSERT INTO bno_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ag nagsiling ray kag GINO-O kang Moises, “Rakpa kina sa ikog!” Ag gingrakop matuor kali nida sa ikog. Ag pagkarakop kali, ay naging bakulo liwat. ");
INSERT INTO bno_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Tuyar kina kag imo ahimuon sa inra atubangan agor sinra ay mapati nak Ako ay nagpakita sa imo, Ako nak GINO-O nak imaw kag inro Dios, Dios it inro mga ginikanan, Dios ni Abraham, Dios ni Isaac ag Dios ni Jacob.” ");
INSERT INTO bno_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Pagkatapos, nagsiling pa kag GINO-O sa ida, “Suksukan kinang imo damot sa suyor it imo baro.” Ida matuor kali gingsuksok, ag pagbaoy nida, kag ida damot ay napuno it kitong nak nupay kaputi-puti. ");
INSERT INTO bno_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Masunor, nagsiling kag GINO-O, “Suksukan liwat.” Gingtuman ray nida kali ag pagbaoy nida liwat, kali ay maadoy tuyar sa dati. ");
INSERT INTO bno_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Siling ray it GINO-O, “Kung indi ka ninra gipatihan sa unang milagro, baka patihan ka ninra sa paruha. ");
INSERT INTO bno_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ugaling pag indi gihapon sinra magpati rili sa ruhang milagro ag magpanimati sa imo, sag-ob it tubi halin sa Suba it Nilo ag imo ibubo sa raga. Kaling imo gingbubong tubi ay magiging rugo.” ");
INSERT INTO bno_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Nagsabat ray si Moises, “Ako GINO-O, pasensyang gador, daok talaga ako magbisaya. It kato ag aber ngasing, tuna tong nagpakita Ikaw sa ako nak imo suguon, daok gihapon ako magbisaya. Abang rugay ako makasugrong it bisaya.” ");
INSERT INTO bno_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Masunor, nagsiling kag GINO-O sa ida, “Si-o kag naghimo sa yuba it tawo? Si-o kag inggwa't gahom nak maghimo sa apa, sa bungoy, sa nakakakita ag sa bulag? Buko baga Ako, Ako nak GINO-O? ");
INSERT INTO bno_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Hala pagtoy! Ako kag mabulig sa imo, Ako kag matudlo sa imo it imo ibisaya.” ");
INSERT INTO bno_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ugaling nagpapaka-hanap gihapon si Moises it idahilan agor indi sida dapat magbalik sa Ehipto ag tumanon kag sugo it GINO-O, “Asi GINO-O? Kung maaari, ay iba yangey kag sugu-a.” ");
INSERT INTO bno_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Dahil dili, nahangit kag GINO-O kang Moises, ag napasiling Sida, “Buko'y inggwa ikaw it maguyáng nak si Aaron, nak halin sa lahi ni Levi? Ayam Nako nak maayo sida magbisaya. Ag sa kamatuuran, papaley sida agor ikaw ay sapuyon. Pag nakita ka nida, siguradong masasadyahan kato. ");
INSERT INTO bno_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Uma-e sida it tanang Ako mga ingbisaya sa imo ag sida nganat kag mabisaya it kali sa inro mga kasimanwang Israelinhon. Ako kamo abuligan ag atudluan kung ni-o kag inro dapat himuon. ");
INSERT INTO bno_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Sida kag imo magiging manugbisaya. Aber ni-o kag Ako ibisaya sa imo, imaw kag imo ibisaya sa ida bilang propeta it Dios, ag sida ray kag mapaabot it kali sa mga tawo, imbes nak ikaw. ");
INSERT INTO bno_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Aya gilimti nak ray-on kinang imo hudot nak bakulo, dahil parayan hina mahimo ikaw it mga milagro.” ");
INSERT INTO bno_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Pagkatapos it pagbisaya it GINO-O kang Moises, nagpauli sida sa ida panugangan nak si Jetro ag nagpamuhon, “Tay, sugti ako nak magbalik sa ako mga kahalihan ruto sa Ehipto. Ako ausisaon kag inra kamutangan.” Ag nagsabat si Jetro kang Moises nak, “Ay hala, maado ra kato. Magrahan yang kamo.” ");
INSERT INTO bno_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Bag-o nakahalin sina Moises sa Midian ay nagsiling ray kag GINO-O sa ida, “Balikey sa Ehipto, dahil kag tanang mga tawo nak gustong magmatay sa imo it kato ay minatayey.” ");
INSERT INTO bno_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kada nagginaney sina Moises pabalik sa Ehipto ag ingpasakay nida kag ida asawa ag ruhang anak sa asno, raya kag bakulo nak gingsugo sa ida it Dios nak ray-on. ");
INSERT INTO bno_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ag nagsiling kag GINO-O kang Moises, “Pag-abot nimo sa Ehipto, parayan sa Ako gahom himuang gador kag tanang milagro nak Ako ingsugo sa imo sa atubangan ni Paraon. Ugaling apatugason Nako kag ida tagipusuon pramas indi nida gisugtan nak maghalin kag Ako mga katawuhan. ");
INSERT INTO bno_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kada tuyar kali kag imo ibisaya sa ida, ‘Gingpapasiling it GINO-O sa imo, “Kag Ako mga katawuhan nak Israelinhon ay pay Ako panganay nak anak,” ");
INSERT INTO bno_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ag Ako gingsisiling sa imo, “Sugti kag Ako anak nak magpanaw agor ida Ako dayawon.” Pag indi nimo sida gisugtan, muyati kag imo panganay nak anak kag Ako amatyon.’ ” ");
INSERT INTO bno_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Usang gab-i, habang sinra ay sa usang bayay nak dayunan raha sa rayan papagto sa Ehipto, gingpayungutan si Moises it GINO-O nak amatyon tan-a. ");
INSERT INTO bno_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Pero nagbaoy si Zipora it matayom nak bato ag ingtuli kag ida anak nak kayake bag-o gingsaplir kali sa siki ni Moises ag nagsiling, “Ngasing ikaw ay pay ingkasay liwat sa ako parayan sa rugo.” ");
INSERT INTO bno_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Dahil diling pagtuman sa kasugtanan kang Abraham nak dapat tulion kag bawat anak nak kayake, gingbuot it Dios nak mabuhi pa si Moises. Kada tuyar kina kag siling ni Zipora. ");
INSERT INTO bno_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Bag-o pa matabo kali nagsilingey kag GINO-O kang Aaron ruto sa Ehipto, “Pagto sa unhan it disyerto ag ruto sapuyon kag imo manghor nak si Moises.” Nagpagto matuor sida ag ruto sinra nagkita sa Baguntor it Dios, ag gingharuan ni Aaron kag ida manghor. ");
INSERT INTO bno_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ag ging-umaan ni Moises si Aaron it tanang gingsiling it GINO-O sa ida, ag kag tanang milagro nak gingsugo it Dios nak ida ahimuon pag-abot ninra sa Ehipto, bag-o sinra nagginan. ");
INSERT INTO bno_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Pag-abot ninra sa Ehipto inra gingtipon kag tanang pinuno it mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ging-uma ni Aaron sa inra kag tanang gingsiling it GINO-O kang Moises, bag-o naghimo kali it mga milagro sa atubangan ninra. ");
INSERT INTO bno_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ag nagpinati kag mga tawo. Pagkarungog ninra nak sinra ay gingruaw it GINO-O, kumo nakita Nida kung pauno sinra gingpapahirapan, nagyinuhor sinra ag nagdinayaw sa Ida. ");
INSERT INTO bno_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Pagkatapos it paghinuon nina Moises ag Aaron sa inra mga pinuno, sinra ay nag-atubang kang Paraon ag nagsiling, “Halandong Paraon, imaw kali kag gingsiling it GINO-O nak Dios it mga Israelinhon, ‘Sugti nak magpanaw kag Ako mga katawuhan, agor sinra ay magkainggwa't pista bilang pagdayaw sa Ako sa disyerto.’ ” ");
INSERT INTO bno_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nagsabat si Paraon, “Siong GINO-O, si-o sida nak ako asunron ag papanawon kag mga Israelinhon? Buko nako kilaya kaling GINO-O nak inro gingsisiling. Ag lalong indi nako gipapanawon kag mga Israelinhon.” ");
INSERT INTO bno_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Nagsiling ray sinra, “Halandong Paraon, kag Dios namong mga Hebreo ay nagpakita sa amo. Kada sugti kami nak magpagto sa disyerto, nak kag yado ay tatlong adlaw it baktas, agor ruto kami mahikot it amo inughalar bilang pagdayaw sa GINO-O nak amo Dios. Kung indi, baka kami ay madisgrasya ag mamatay sa sakit o sa gera.” ");
INSERT INTO bno_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pero nagsiling kag Paraon, “Moises ag Aaron, asing inro ging-aawat kaling mga tawo sa inra trabaho? Hala, balik kamo sa inro trabaho.” ");
INSERT INTO bno_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Nagsiling pa kag Paraon, “Mas kailangan namo sinra dahil mas maramo sinra sa amo, ag inro pa sinra abay-on sa pagtrabaho!” ");
INSERT INTO bno_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tong adlaw mismo nak kato, gingpatawag ni Paraon kag mga mapintas nak manugmanda it mga kapatas, ag pati ra kag mga kapatas, bag-o nagsiling, ");
INSERT INTO bno_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Tuna ngasing indiey ninro gitaw-an kag mga Israelinhon it mga uhot nak iyakot sa yunang para maging bloke. Bahala sinra nak maghanap ag maghakot para sa inra sarili. ");
INSERT INTO bno_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pero obligaha sinra nak makahimo gihapon it tuyar sa dating ramo nak inra ginghihimo. Aya gibawasi aber usa, sa bilang nak dapat ninrang matapos. Nagtitinamar yang kina sinra! Kada nagpapangabay sinra nak mapagto kuno agor maghalar sa inra Dios. ");
INSERT INTO bno_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Rugangi pang gador kag inra trabahuon agor waya sinra it panahon nak magpanimati sa mga binakak.” ");
INSERT INTO bno_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Pagkatapos it kali, katong tanang kapatas ag inra mga manugmanda ay nagliwas ag nagsiling sa mga Israelinhon, “Siling ni Paraon, ‘Indiey kamo gitaw-an it uhot. ");
INSERT INTO bno_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Bahalaey kuno kamo nak maghanap ag maghakot it kina, kung hariin kamo makakakita. Pero tuyar gihapon it tong dati kag ramo it bloke kag dapat ninrong mahimo. Dapat ay indi kina mabuhinan.’ ” ");
INSERT INTO bno_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kada nagkalat kag mga tawo sa bug-os nak Ehipto sa paghanap it mga uhot. ");
INSERT INTO bno_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Sinra ay gingsasahoy it mga mapintas nak punong kapatas sa pagsiling, “Tapusa ninro kag inro dating kuta it bloke nak inro natatapos sa usang adlaw, tuyar tong kamo pa ay gingtataw-an namo it uhot nak pangyakot sa yunang.” ");
INSERT INTO bno_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Pag nagkuyang kag inra nahihimo, kag mga Israelinhong kapatas ay gingkakastigo it mga Ehiptohanong manugmanda, ag gingpapangutana, “Asing kuyang kag inro nahimong mga bloke it tahapon ag ngasing? Asing waya ninro gikumpletuha tuyar it tong dati?” ");
INSERT INTO bno_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Dahil dili kag mga Israelinhong kapatas ay nagpagto ag nagpakitluoy kang Paraon, “Halandong Paraon, asing inro ra kami gingtutuyar, kaming imo mga suguon? ");
INSERT INTO bno_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Kaming imo mga suguon ay wayaey gitataw-e it uhot pero gingsusugo gihapon kami nak himuon kag pareho't ramong mga bloke sa dati namong ginghihimo! Ag usa pa, kaming imo mga suguon ay gingkakastigo, samantalang kag imo mga tawuhan ra it di sala.” ");
INSERT INTO bno_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pero nagsiling kag Paraon, “Mga tamaran! Gingtatamaran yang kamo, kada kamo nagpapaka-pamuhon nak magpanaw agor maghikot it inro inughalar sa inro GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Hala, balik kamo sa inro mga trabaho. Indiey nak gador kamo gitaw-an it uhot nak pangyakot sa yunang. Pero kag inro ahimuong bloke ay dapat tuyar sa inro dating nahihimo sa usang adlaw.” ");
INSERT INTO bno_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nakita it mga Israelinhong kapatas nak sinra ay asa hirap nak kahimtangan katong gingsilinggan sinra nak, “Kag inro ahimuong bloke ay dapat tuyar it ramo sa inro dating nahihimo sa usang adlaw.” ");
INSERT INTO bno_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","It kag pahalinoney sinra halin kang Paraon nasapoy ninra sina Moises ag Aaron nak naghuhuyat sa inra. ");
INSERT INTO bno_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Siling ninra sa ruha, “Kabay pang bayusan kamo it GINO-O sa inro ginghimo! Dahil sa inro, pay kami ay mga mayaing tawo nak inghahangitan nina Paraon ag ida mga opisyales. Kamo kag nagta-o sa inra it rason nak kami ay matyon parayan sa pagpahirap sa amo sa pagtrabaho.” ");
INSERT INTO bno_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Pagkatapos it kali, naghalin si Moises ruto, bag-o nagpayungot sida sa GINO-O ag nagpangamuyo, “Ako GINO-O, asing Imo gingtuyar kaling mga tawo? Asing Imo pa ako gingsugo rili? ");
INSERT INTO bno_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Dahil tuna tong nag-atubang ako kang Paraon ag nagbisaya it kumporme sa Imo ingsugo sa ako, ida gingpakapintasan pa lalo sinra. Ag waya rang gador Nimo sinra gitabangi.” ");
INSERT INTO bno_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ngasing nagsiling kag GINO-O kang Moises, “Ngasing makikita nimo kag Ako ahimuon kang Paraon. Indi yang sida mapipilitan nak kamo ay pahalinon, atabugon pa kamo paliwas sa ida duta.” ");
INSERT INTO bno_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nagsiling pa kag Dios sa ida, “Ako si Yahweh, nak imaw kag GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nagpakita Ako sa imo mga ginikanan nak sina Abraham, Isaac ag Jacob, bilang Dios nak Makagagahom. Pero parayan sa Ako pangayan nak Yahweh waya Ako gipakilaya sa inra nak imaw kato. ");
INSERT INTO bno_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Gingpapaninrugan ra Nako kag Ako kasugtanan sa inra nak ita-o kag duta it Canaan, kag duta nak inra gingtineran it kato bilang mga nagpapangdayunan yang. ");
INSERT INTO bno_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ag usa pa, narunggan Nako kag pang-aguyo it mga Israelinhon nak ging-uulipon it mga Ehiptohanon, ag narumruman nak gador Nako kag Ako kasugtanan sa inra. ");
INSERT INTO bno_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Kada, silinggan kali sa mga Israelinhon, ‘Ako si Yahweh. Ataw-an Nako kamo it kahilwayan halin sa mga pagpahirap it mga Ehiptohanon, ahaw-ason Nako kamo halin sa pagkaulipon, atubson Nako kamo parayan sa Ako gamhanang damot, ag matugpa sa inra kag Ako rakong mga paghusgar. ");
INSERT INTO bno_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ako kamo abilangon nak Ako sariling mga katawuhan, ag Ako kag inro magiging Dios. Makikilaya ninro nak Ako si Yahweh nak inro Dios, nak imaw kag nagta-o sa inro it kahilwayan halin sa pagpahirap it mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ako kamo aray-on rutong duta nak Ako gingsumpa tong Ako ingtaas kag Ako damot, nak ita-o kana Abraham, Isaac ag Jacob. Ako kato ita-o sa inro bilang inroy nak gador. Ako si Yahweh.’ ” ");
INSERT INTO bno_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ging-uma kali ni Moises sa mga Israelinhon, ugaling waya sinra gipati dahil nagmadlaey sinra sa inra narayanan nak subrang pagpahirap. ");
INSERT INTO bno_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Masunor, nagsiling ray kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Pagtoy kang Paraon, nak hari it Ehipto, ag silinggon nak paliwason nganat nida kag mga Israelinhon sa ida bansa.” ");
INSERT INTO bno_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pero nagrason si Moises sa GINO-O, “Kung kag mga Israelinhon ngani ay indi magpati sa ako, si Paraon pa ara? Siong gador ako! Buko ngani ako sanay magbisaya sa tawo.” ");
INSERT INTO bno_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Pero nagsiling kag GINO-O kana Moises ag Aaron, “Silingga kag mga Israelinhon ag kag hari it Ehipto nak si Paraon, nak Ako sida gingsugo nak sugtan kag mga Israelinhon halin sa bansa it Ehipto.” ");
INSERT INTO bno_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Sa mga anak ni Jacob nak inghalinan it mga Israelinhon, imaw kali kag listahan it ibang mga maguyang nak ginghalinan nina Moises ag Aaron: Kag panganay nak anak ni Jacob ay si Ruben, ag kag ida mga anak nak kayake ay sina Hanoc, Palu, Hezron, ag Carmi. Kali sinra kag mga inghalinan it lahi ni Ruben. ");
INSERT INTO bno_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Kag pangruhang anak ni Jacob ay si Simeon, ag kag ida mga anak nak kayake ay sina Jemuel, Jamin, Ohad, Jaquin, Zohar, ag si Saul nak anak nida sa usang kabade nak Canaanhon. Kali sinra kag mga inghalinan it lahi ni Simeon. ");
INSERT INTO bno_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Kag pangtatlong anak ni Jacob ay si Levi, kung hariin gihalin sina Moises ag Aaron. Ag kag mga anak nak kayake ni Levi ay sina Gerson, Kohat, ag Merari. Kag haba it kabuhi ni Levi ay usang gatos ag trentay-syeteng (137) tuig. ");
INSERT INTO bno_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Kag panganay nak anak ni Levi ay si Gerson, ag kag ida mga anak nak kayake ay sina Libni ag Simi. ");
INSERT INTO bno_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kag pangruhang anak ni Levi ay si Kohat, ag kag ida mga anak nak kayake ay sina Amram, Izar, Hebron ag Uziel. Kag haba it kabuhi ni Kohat ay usang gatos ag trentay-tres (133) nak tuig. ");
INSERT INTO bno_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Kag pangtatlong anak ni Levi ay si Merari, ag kag ida mga anak nak kayake ay sina Mali ag Musi. Kumporme sa mga listahan, kali kag tatlong anak ni Levi ag rili sa tatlong anak, kang Kohat gihalin kag lahi nina Aaron ag Moises. ");
INSERT INTO bno_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Kag panganay nak apo ni Levi kang Kohat ay si Amram, nak gingpangasawa kag hali it ida tatay nak si Jocabed, ag kag inra mga anak nak kayake ay sina Aaron ag Moises. Kag haba it kabuhi ni Amram ay usang gatos ag trentay-syeteng (137) tuig. ");
INSERT INTO bno_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Kag pangruhang apo ni Levi kang Kohat ay si Izar, ag kag ida mga anak nak kayake ay sina Core, Nepeg ag Zikri. ");
INSERT INTO bno_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Kag pang-ap-at nak apo ni Levi kang Kohat ay si Uziel, ag kag ida mga anak nak kayake ay sina Misael, Elsapan ag Sitri. ");
INSERT INTO bno_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Si Aaron ay panganay nak apo ni Kohat kang Amram. Gingpangasawa ni Aaron si Eliseba nak hali ni Nason, nak mga anak ni Aminadab. Ag kag inra mga anak nak kayake ay sina Nadab, Abihu, Eleazar ag Itamar. ");
INSERT INTO bno_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Si Core ay panganay nak apo ni Kohat kang Izar. Kag mga anak nak kayake ni Core ay sina Asir, Elcana ag Abiasap. Kali sinra kag mga inghalinan it lahi nak Corenhon. ");
INSERT INTO bno_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Si Eleazar nak pangruhang anak ni Aaron ay nagpangasawa it usa sa mga rayagang anak ni Putiel, ag kag inra anak nak kayake ay si Pines. Imaw kali kag listahan it mga pinuno it mga pamilya ni Levi, kumporme sa inra mga inanak. ");
INSERT INTO bno_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ngani, imaw kali kag inghalinan nina Aaron ag Moises nak gingsugo it GINO-O sa pagsiling, “Haw-asa kag mga Israelinhon sa bansa it Ehipto kumporme sa inra mga grupo.” ");
INSERT INTO bno_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Kaling si Moises ag si Aaron ay imaw kag nagbisaya kang Paraon nak hari it Ehipto tungor sa paghaw-as sa mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","It katong gingbisayahan it GINO-O si Moises sa lugar it Ehipto, ");
INSERT INTO bno_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","nagsiling Sida rili, “Ako kag GINO-O. Silinggan kang Paraon, nak hari it Ehipto, kag tanan nak Ako gingbisaya sa imo.” ");
INSERT INTO bno_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ugaling nagrason si Moises sa GINO-O, “Ayam nimo GINO-O nak ako ay nauuta magbisaya, pauno mapati si Paraon sa ako?” ");
INSERT INTO bno_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Nagsiling kag GINO-O kang Moises, “Muyati, ginghimo ka Nako nak nupay dios sa atubangan ni Paraon. Ag si Aaron nak imo maguyáng kag imo magiging propeta. ");
INSERT INTO bno_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Imo isiling kag tanang Ako gingbisaya sa imo, ag si Aaron nak imo maguyáng ay imaw it masiling kang Paraon nak paliwason kag mga Israelinhon halin sa ida bansa. ");
INSERT INTO bno_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pero Ako apatugason kag tagipusuon ni Paraon, kada aber mahimo Ako it maramong milagro bilang pamatuor it Ako gahom raha sa Ehipto, ");
INSERT INTO bno_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ay indi gihapon sida magpati sa inro. Pagkatapos, Ako iparaya kag mabug-at nak parusa it Ako damot sa mga Ehiptohanon ag matugpa sa inra kag Ako rakong mga paghusgar. Bag-o Ako iliwas kag Ako mga katawuhan nak Israelinhon nak sunor-sunor kumporme sa inra mga grupo. ");
INSERT INTO bno_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Maaayaman it mga Ehiptohanon nak Ako kag GINO-O, pag Akoey naipatagam sa inra kag Ako parusa ag Akoey naraya kag mga Israelinhon paliwas it Ehipto.” ");
INSERT INTO bno_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ingtuman matuor nina Moises ag Aaron kag gingsugo sa inra it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tong panahon nak nagbisaya sinra kang Paraon, si Moises ay otsenta't (80) edad, ag si Aaron ay otsentay-tres (83). ");
INSERT INTO bno_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nagsiling pa kag GINO-O kana Moises ag Aaron, ");
INSERT INTO bno_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Moises, pag magsiling sa inro si Paraon nak, ‘Pamatuuri kag inro sarili nak kamo talaga ay ingsugo it inro DIOS. Hala baga, himo it milagro!’ Silingga si Aaron nak, ‘Gamiton kinang imo bakulo. Itsahan kina sa atubangan ni Paraon ag kina ay magiging sawa.’ ” ");
INSERT INTO bno_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kada, nagpagto sina Moises ag Aaron kang Paraon ag inra ingtuman kag tanang gingsugo it GINO-O. Ging-itsa ni Aaron kag ida bakulo sa atubangan nina Paraon ag ida mga opisyales, ag kali ay naging sawa. ");
INSERT INTO bno_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pagkatapos it kali, gingpatawag ni Paraon kag mga maayam nak mga tawo ag mga amulitan sa irayom it ida sinakupan. Ag nagpatuyar ra sinra sa inghimo ni Aaron parayan sa inra paglimot. ");
INSERT INTO bno_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Bawat usa ay nag-itsa it inra bakulo, ag kali ra ay nagiging sawa. Pero gingtulon kali tanan it sawa nak halin sa bakulo ni Aaron. ");
INSERT INTO bno_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ugaling sa yudo it kali, kag tagipusuon ni Paraon ay nagmatugas ag waya sida gipati sa inra, tuyar sa gingpauna nak bisaya it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ngasing nagsiling kag GINO-O kang Moises, “Talagang indi matiog-tiog kag tagipusuon ni Paraon, waya nida gisugti kag Ako mga katawuhan nak maghalin. ");
INSERT INTO bno_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Insulip sa aga atabuon nimo si Paraon sa ida pagpagto sa suba. Ray-a kag imo bakulo nak naging sawa ag bantaye sida ruto sa habig it Suba it Nilo. ");
INSERT INTO bno_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ag kali kag imo ibisaya sa ida, ‘Kag GINO-O nak Dios it mga Hebreo ay nagsugo sa ako nak isiling sa imo kali, “Sugti kag Ako mga katawuhan nak magpanaw agor madayaw sinra sa Ako ruto sa disyerto. Pero hasta ngasing waya pa nimo nasunra.” ’ ” ");
INSERT INTO bno_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Kada siling it GINO-O, “Parayan dili sa Ako ahimuon, imo masasaduran nak Ako kag GINO-O. Bantaye! Dahil ako asikwilon it kaling ako hudot nak bakulo kaling tubi dili sa Suba it Nilo, ag kali ay magiging rugo. ");
INSERT INTO bno_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ngani, kag mga isra rili ay magkakamatay, ag kag tubi ay mayang-og, kada waya't maiinom nak tubi kag mga Ehiptohanon halin dili sa Suba it Nilo.” ");
INSERT INTO bno_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Siling pa it GINO-O kang Moises, “Silingga si Aaron nak, ‘Bay-a kag imo bakulo ag itudlo sa tanang lugar nak inggwa it tubi rili sa Ehipto, sa mga suba, sa mga kanal, sa mga tubog ag sa tanang mga deposito it tubi.’ Ag kag tubi raha ra ay magiging rugo. Kag makikita sa tanang lugar sa sakop it Ehipto ay rugo, aber sa inra mga batya ag gining.” ");
INSERT INTO bno_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ingtuman matuor nina Moises ag Aaron kag gingsugo it GINO-O. Sa atubangan ni Paraon ag sa ida mga opisyales ay gingtaas ni Aaron kag ida bakulo ag gingbakoy sa tubi nak asa Suba it Nilo, ag kag tanang tubi ruto ay naging rugo. ");
INSERT INTO bno_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kag mga isra sa suba ay nagkamatay ag kag suba ay nagbaho, kada kag mga Ehiptohanon ay indi kainom it tubi halin ruto. Ag sa bug-os nak Ehipto matuor ay nakikita kag rugo. ");
INSERT INTO bno_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pero kag mga amulitan nak tawo it Ehipto ay naghimo ra it tuyar kali parayan sa inra paglimot. Kada kag tagipusuon ni Paraon ay nagmatugas pa gihapon ag waya sida gipati sa inra, kumporme sa gingbisaya it GINO-O, ");
INSERT INTO bno_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","kundi gingtalikuran yang sinra ag nagbalik sida sa palasyo nak pay waya't natabo. ");
INSERT INTO bno_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Myentras kag tanang mga Ehiptohanon ay nagkutkot it mga bal-ong sa habig it Suba it Nilo agor inggwa sinra it maiinom, dahil indi nak gador ninra mainom katong tubi. ");
INSERT INTO bno_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pitong adlaw kag nakalipas pagkatapos nak inghimo matuor it GINO-O nak rugo kag tubi sa Suba it Nilo. ");
INSERT INTO bno_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Masunor, nagsiling ray kag GINO-O kang Moises, “Pagtu-e si Paraon ag silinggan nak, ‘Gingpapasiling it GINO-O nak, sugti nganat kag Ako mga katawuhan nak magpanaw agor madayaw sinra sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Pag indi nimo sinra gisugtan, Ako abut-on nak kag imo bug-os nak bansa ay mapupuno it mga paka. ");
INSERT INTO bno_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Indi mabilang-bilang nak mga paka kag matakas halin sa Suba it Nilo. Kali ay masuyor sa imo palasyo, imo kwarto, imo katri, sa mga bayay it imo mga opisyales ag sa tanang imo mga sinakupan. Masuyor ra sinra aber sa inro pugon ag sa inro mga hurnuhan nak kung hariin ingpapaalsa ninro kag tinapay. ");
INSERT INTO bno_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mayinukso kali sa imo, sa imo mga opisyales ag sa imo tanang sinakupan.’ ” ");
INSERT INTO bno_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Nagsiling pa kag GINO-O kang Moises, “Silinggan kang Aaron, ‘Gamita kinang imo hudot nak bakulo, ag itudlo sa mga suba, mga kanal, ag mga tubog, ag patakason kag mga paka sa Ehipto!’ ” ");
INSERT INTO bno_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kada, gingtudlo matuor ni Aaron kag ida bakulo sa mga katubian nak asa Ehipto, ag nagtinakas kag mga paka ag nagpangkalat sa duta. ");
INSERT INTO bno_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pero kag mga amulitan nak tawo it Ehipto ay nagpatuyar ra parayan sa inra paglimot. Nagpatakas sinra it mga paka ruto sa duta it Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Masunor, gingpatawag ni Paraon sina Moises ag Aaron, ag nagsiling, “Pangamuyo kamo sa GINO-O nak Ida bay-on kaling mga paka sa ako ag sa ako mga tawong sinakupan, ag ako asugtan kag inro mga katawuhan nak magpanaw agor sinra ay mag-ihaw it hadop nak inughalar sa Ida.” ");
INSERT INTO bno_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Siling ni Moises kang Paraon, “Haring Paraon, kasadyahan nako nak maayaman kung sauno nimo gustong magpangamuyo ako para sa imo, para sa imo mga opisyales ag para sa imo mga sinakupan, nak mawagit kag mga paka sa imo ag sa mga bayay it imo sinakupan. Ag kag mabibilin nak mga paka ay sa suba yang.” ");
INSERT INTO bno_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Sabat ni Paraon, “Insulip yangey.” Siling ni Moises, “Matutuman kina kumporme sa imo gingbisaya, agor imo maaayaman nak waya't ibang tuyar sa GINO-O nak ato Dios. ");
INSERT INTO bno_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kag mga paka ay mahalin sa imo ag sa inro mga bayay, sa imo mga opisyales ag sa imo mga sinakupan. Kag mabibilin yangey ay tong ruto sa Suba it Nilo.” ");
INSERT INTO bno_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Pagkahalin nina Moises ag Aaron sa atubangan ni Paraon ay nagpangamuyo si Moises sa GINO-O nak bay-on kag mga paka nak Ida gingpatakas ruto. ");
INSERT INTO bno_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Gingtuman matuor it GINO-O kag ginghagar sa ida ni Moises. Nagkamatay kag mga paka sa suyor it mga bayay, sa mga rayaag ag sa mga bukir. ");
INSERT INTO bno_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gingtipon kali it mga Ehiptohanon sa mga maragkong tumpok ag kag bug-os nak lugar ay abang baho. ");
INSERT INTO bno_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero tong nakita ni Paraon nak maado ray kag inra kahimtangan, pinatugas ray nida kag ida tagipusuon ag waya gipati kana Moises, tuyar sa gingpauna nak bisaya it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Pagkatapos, nagsugo ray kag GINO-O kang Moises, “Silingga si Aaron nak abakuyon kag raga it kinang ida hudot nak bakulo ag mahimo kaling mga hayukhok sa duta it Ehipto.” ");
INSERT INTO bno_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Gingtuman matuor ninra. Gingbakoy ni Aaron kag ida hudot nak bakulo sa raga ag halin sa taybo ay nagliniwas kag mga hayukhok ag nag-inapon sa mga tawo ag sa mga hadop. Kag taybo ruto sa Ehipto ay nahimong hayukhok. ");
INSERT INTO bno_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Pero tong nagpurba ra kag mga amulitan nak tawo it Ehipto nak makapaliwas ra sinra it hayukhok parayan sa inra paglimot ay waya ninra kali nahimo. Kag mga tawo ag mga hadop ay ingpapahirapan it kaling mga hayukhok. ");
INSERT INTO bno_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ag napasiling kaling mga amulitan nak tawo kang Paraon, “Halandong Paraon, kali ay waya't makakahimo kundi Dios yang.” Ugaling tuyar it tong una, kag tagipusuon ni Paraon ay nagmatugas gihapon ag waya gipati, tuyar sa gingpauna nak bisaya it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Masunor, nagsugo kag GINO-O kang Moises, “Paaga it bati insulip, ag bantayan si Paraon sa ida pagpagto sa suba. Payunguti sida ag silinggon nak, ‘Siling it GINO-O, “Sugti kag Ako mga katawuhan nak magpanaw agor madayaw sinra sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pag indi nimo sinra gisugtan, Ako iparaya kag abang ramong yangaw sa imo, sa imo mga opisyales ag sa imo mga sinakupan, pati sa inro mga bayay. Kag tanang mga bayay it mga Ehiptohanon ay mapupuno it kayangawan aber kag duta nak inra atungtungan. ");
INSERT INTO bno_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘ “Pero sa adlaw nak matabo kali, iba kag Ako pagtratar sa lugar it Gosen kung hariin giistar kag mga Israelinhon. Waya't aber usang makikitang yangaw ruto. Parayan dili inro maaayaman nak Ako nak imaw kag GINO-O kag naggagahom dili sa inro duta. ");
INSERT INTO bno_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ipakita Nako sa inro nak iba kag Ako pagmuyat sa Ako mga katawuhan ag sa imo mga katawuhan. Insulip makikita ninro kaling katitingayang bagay bilang pamatuor it Ako gahom.” ");
INSERT INTO bno_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","“ ‘Ag imaw matuor kag inghimo it GINO-O. Nagliniwas kag abang ramong yangaw ag nagsinuyor sa palasyo ni Paraon ag sa mga bayay it ida mga opisyales. Ag kag duta it Ehipto ay napuno it mga yangaw. ");
INSERT INTO bno_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","“ ‘Pagkatabo it kali, ingpatawag ni Paraon sina Moises ag Aaron ag nagsiling, “Hala, asugtan kamo nako nak mag-ihaw it hadop nak inughalar para sa inro Dios dili sa sakop yang it Ehipto.” ’ ” ");
INSERT INTO bno_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Pero nagsabat si Moises, “Halandong Paraon, indi puyde rili sa Ehipto, dahil kag mga hadop nak amo ging-iihaw bilang inughalar sa GINO-O nak amo Dios ay bawal sa pagmuyat ninro nak mga Ehiptohanon. Kung amo kali ahimuon sa inra atubangan, indi aboy kami ninra gimatyon parayan sa pagbunggo? ");
INSERT INTO bno_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kinahangyan nak magpanaw kami it tatlong adlaw sa disyerto ag ruto kami maihaw it hadop bilang inughalar sa GINO-O nak amo Dios, kumporme sa Ida gingsugo sa amo.” ");
INSERT INTO bno_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kada, siling ni Paraon, “Hala sige, asugtan kamo nako nak magpanaw agor himuon kina para sa inro GINO-O sa disyerto. Ugaling indi dapat kamo magpakapayado. Ag pangamuyuan ra ninro ako.” ");
INSERT INTO bno_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Nagsabat si Moises kang Paraon, “Pagkahalin nako, ako ipangamuyo sa GINO-O, ag insulip kaling maramong yangaw ay mahalin sa imo, sa imo mga opisyales, ag sa imo mga sinakupan. Pero aya ray gibawi-a kinang imo binisayahan, parayan sa pagpiga sa mga tawo nak magpanaw agor mag-ihaw it hadop nak inughalar sa GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Pagkahalin ni Moises sa atubangan ni Paraon ay nagpangamuyo sida sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Gingtuman matuor it GINO-O kag inghagar sa ida ni Moises. Nagkawagit kag mga yangaw kana Paraon, sa ida mga opisyales ag sa ida mga sinakupan. Waya't aber usang yangaw nak nabilin. ");
INSERT INTO bno_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pero pinatugas liwat ni Paraon kag ida tagipusuon ag waya gihapon nida gisugti kag mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ngasing nagsugo kag GINO-O kang Moises, “Pagtu-e si Paraon ag silingga nak, ‘Gingpapasiling it GINO-O nak Dios it mga Hebreo, sugti nganat kag Ako mga katawuhan nak magpanaw agor madayaw sinra sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Pag indi nimo sinra gisugtan ag pigahan gihapon, ");
INSERT INTO bno_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","kag Ako gamhanang damot ay maparaya it grabeng silot sa inro mga alagang kahadupan nak asa agsaman, mga kabayo, mga asno, mga kamelyo, mga baka, mga karnero ag mga kambing. ");
INSERT INTO bno_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pero iba kag Ako pagtatap sa mga kahadupan it mga Israelinhon ag mga kahadupan it mga Ehiptohanon. Waya't aber usang alagang hadop kag mga Israelinhon nak mamamatay.’ ");
INSERT INTO bno_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Gingterminuhaney kali it GINO-O ag insulip kali ahimuon Nida sa inro duta.” ");
INSERT INTO bno_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Pagkaaga gingtuman matuor it GINO-O kag Ida gingbisaya. Kag tanang kahadupan it mga Ehiptohanon nak asa agsaman ay nagkamatay. Pero waya't aber usang alagang hadop it mga Israelinhon nak namatay. ");
INSERT INTO bno_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ingpausisa pa ni Paraon kaling natabo, ag klaro matuor nak waya't aber usang hadop it mga Israelinhon nak namatay. Pero waya gihapon natiog-tiog kag ida tagipusuon ag waya gisugti kag mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Masunor, nagsugo kag GINO-O kana Moises ag Aaron, “Hakop it abo halin sa abuhan ag ipasabuyak kang Moises sa atubangan ni Paraon. ");
INSERT INTO bno_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Kali ay mahihimong mapinong taybo sa duta it Ehipto, ag kag tanang tawo ag mga kahadupan ay magkakainggwa't maramong hubag nak waya gipipila.” ");
INSERT INTO bno_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kada, nagbaoy matuor sinra it abo halin sa abuhan ag ingraya sa atubangan ni Paraon. Ingsabwag kali ni Moises, ag nagtinubo kag mga hubag sa mga tawo ag sa mga hadop. ");
INSERT INTO bno_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Aber kag mga amulitan nak tawo it Ehipto ay indi makaatubang kang Moises dahil tanang yawas ninra ay puro hubag, pati kag tanang mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pero ingpatugas gihapon it GINO-O kag tagipusuon ni Paraon ag waya sida gipati sa inra, kumporme sa Ida gingpaunang bisaya kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Masunor, nagsugo kag GINO-O kang Moises, “Paaga it bati insulip, ag bantayan si Paraon, payunguti ag silinggon nak, ‘Siling it GINO-O nak Dios it mga Hebreo: Sugti kag Ako mga katawuhan nak magpanaw agor madayaw sinra sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Pag indi, ngasing nak raan, ikaw ay Ako asiluton it grabe, pati kag imo mga opisyales ag imo mga sinakupan. Parayan dili, maaayaman nimo nak waya't ibang tuyar sa Ako sa bug-os nak kalibutan. ");
INSERT INTO bno_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Aber it kato nak raan puydey ka tan-a Nakong matyon, kamo it imo mga sinakupan, parayan sa pesti nak ikakamatay ninrong tanan. ");
INSERT INTO bno_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ugaling waya kali Nako gihimu-a, dahil ingbuot Nako nak ikaw ay mabuhi pa agor ipakita kag Ako rakong gahom, ag agor kag Ako ngayan ay mabantog sa ibabaw it kalibutan. ");
INSERT INTO bno_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","“ ‘Pero padayon gihapon kag imo pagmarako it imo sarili sa Ako mga katawuhan ag waya nimo gisugti sinra nak magpanaw. ");
INSERT INTO bno_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ngani, insulip sa tuyar kaling oras, Ako aparuguson it yelo rili, nak waya pang gador it katuyar nak kusog tuna tong mapundar kag Ehipto hastang ngasing. ");
INSERT INTO bno_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kada sugu-a kag imo mga sinakupan nak pasilungan kag inro mga kahadupan, pati kag inro tanang sinakupan nak asa kabukiran ay mapasilong ra. Dahil kaling uyan it yelo ay imaw it mamatay sa tanang matutugpaan.’ ” ");
INSERT INTO bno_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Katong mga opisyales ni Paraon nak nagkainggwa't kahadlok sa bisaya it GINO-O ay nagrali-rali sa pagpasilong sa inra mga ulipon ag mga alagang kahadupan nak asa kabukiran. ");
INSERT INTO bno_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pero katong mga waya gialibhat sa bisaya it GINO-O ay gingpabad-an nak asa liwas yang kag inra mga ulipon ag mga kahadupan. ");
INSERT INTO bno_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Masunor, nagsugo kag GINO-O kang Moises, “Tudluan kag imo damot sa langit agor matugpa kag uyan it yelo sa duta it Ehipto, sa mga tawo, sa mga hadop ag sa tanang pananom sa bukir.” ");
INSERT INTO bno_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Gingtuman kali ni Moises. Ag pagtudlo nida sa ida bakulo sa langit, kag GINO-O ay nagparaya it pagkakusog nak pangilat nak diretso sa duta, pangrayugrog, ag uyan it yelo. Kag GINO-O ay nagparugos matuor it yelo sa duta it Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Abang kusog kag bagyo it yelo, ag waya't tungon-tungon kag pagpangilat. Kaling natabo ay imaw nak gador kag pinaka-makusog nak bagyo sa lugar it Ehipto, tuna tong kali ay naging nasyon. ");
INSERT INTO bno_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ingsira it kaling uyan it yelo kag tanang butang nak natamaan, maging tawo man o hadop nak asa liwas it bayay sa bug-os nak duta it Ehipto. Nagkabali-bali kag mga tanom nak asa bukir ag kag tanang kahoy ay naugoy. ");
INSERT INTO bno_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Pero sa Gosen kung hariin giiistar kag mga Israelinhon ay waya giuyan it yelo. ");
INSERT INTO bno_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pagkatabo it kali, ingpatawag ni Paraon sina Moises ag Aaron, ag nagsiling, “Ngasing nako naayami nak nagkasala ako. Tama kag GINO-O, ako ag kag ako mga sinakupan ay nakasala. ");
INSERT INTO bno_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kada pangamuyo kamo sa GINO-O, dahil kung indi, orasey kali namo dahil diling pangrayugrog ag bagyo it yelo. Patungna nganat ag akoey kamo asugtan sa nak raan. Indiey nako kamo gipigahan pa.” ");
INSERT INTO bno_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Sabat ni Moises sa ida, “Oho, Halandong Paraon, pagkaliwas nako riling syudad, ako itaas kag ako mga damot sa pagpangamuyo sa GINO-O. Matungon kag pagpangrayugrog, ag mahuyaw ra kag uyan it yelo, agor inro maaayaman nak kag kalibutan ay sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero ayam nako nak kamo it imo mga opisyales ay waya gihapon it kahadlok sa GINO-O nak Dios.” ");
INSERT INTO bno_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Kag natabo habang nag-uuyan it yelo, kag sebada ag ibang tanom nak imaw kag inghahalinan it mga inghihimong tela nak lino ay nagkasira, dahil kag sebada ay di uhayey ag kag iba ay nagbuburosey. ");
INSERT INTO bno_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ugaling waya nasira kag trigo ag iba pang uyas nak huley gitubo. ");
INSERT INTO bno_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Pagkahalin ni Moises sa atubangan ni Paraon ay nagliwas sida sa syudad ag ingtaas kag ida mga damot sa pagpangamuyo sa GINO-O. Ag nagtungon kag pangrayugrog ag naghuyaw ra kag uyan, pati yelo. Wayaey matuor giuyan it yelo sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pero pagkakita ni Paraon nak naghuyawey kag uyan ag yelo ag wayaey gipapangrayugrog, sida ay nagkasala liwat. Ida ray ingpatugas kag ida tagipusuon, pati kag ida mga opisyales. ");
INSERT INTO bno_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Talagang pay bato kag tagipusuon ni Paraon, ag indi ray nida gisugtan kag mga Israelinhon, kumporme sa gingpaunang bisaya it GINO-O parayan kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ngasing nagsugo kag GINO-O kang Moises, “Pagtu-e si Paraon dahil ingpatugas Nako kag ida tagipusuon, pati kag ida opisyales agor Ako maipakita kaling Ako ahimuong mga milagro bilang pamatuor it Ako gahom sa tunga ninra. ");
INSERT INTO bno_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Kali kag Ako ahimuon agor maaayaman ninro ag inro mga inanak kung pauno Nako gingpahud-an kag mga Ehiptohanon, tong naghimo Ako it mga milagro sa inra tunga. Ag usa pa, kali ay agor maaayaman ninro nak Ako kag GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kada, nagpagto ray sina Moises ag Aaron kang Paraon ag nagsiling, “Halandong Paraon, gingsiling it GINO-O nak Dios it mga Hebreo, ‘Sauno pa ikaw mapaubos it imo sarili sa Ako? Sugtey kag Ako mga katawuhan nak magpanaw agor madayaw sinra sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Pag padayon gihapon nimo sinrang pigahan, insulip ay Ako kamo aparay-an it maramong apan-apan. ");
INSERT INTO bno_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Mainapon sinra sa ibabaw it duta hastang wayaey nak gador it makikitang raga. Aupton ninra katong mga tanom nak natura it bagyo it yelo, pati kag mga kahoy nak nabilin. ");
INSERT INTO bno_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Asudlon ninra ag apun-on kag imo palasyo, ag kag mga bayay it imo mga opisyales ag it tanang Ehiptohanon. Waya pang gador nakakakita it tuyar kali kag imo mga maguyang ag mga luluhon, tuna tong sinra'y natawo riling duta hastang ngasing.’ ” Pagkabisaya kali ni Moises, gingtalikuran nida si Paraon ag naghalin. ");
INSERT INTO bno_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Nagsiling ngasing kag mga opisyales ni Paraon sa ida, “Halandong Paraon, hastang sauno kita aguluhon it kaling tawo? Maado pa siguro, sugti yangey kaling mga tawo sa inra kagustuhan, agor makadayaw sinra sa GINO-O nak inra Dios. Indi pa baga nimo mabaton nak yumosey kag mga Ehiptohanon sa kahirapan?” ");
INSERT INTO bno_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ngani, gingpabalik ni Paraon sina Moises ag Aaron, ag nagsiling sida, “Hala, pagtoy kamo ag magdayaw sa GINO-O nak inro Dios. Ugaling gusto anay nakong maayaman kung sasin-o kag mga mapinanaw.” ");
INSERT INTO bno_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Sabat ni Moises, “Tanan kami, tuna sa pinaka-bata hastang sa pinaka-maguyang, kaibahan kag amo mga anak nak kayake ag kabade, raya pati namo kag amo mga karnero, kambing ag baka, dahil mahiwat kami it marakong Pista para sa GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Napasiling si Paraon, “Aba, ingsuswerte kamo no! Asi, masugot ako nak pati kag inro mga anak ag asawa ay magnunot! Ayam nako nak inggwa kamo it gingpaplanong mayain! ");
INSERT INTO bno_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Indi ako'g sugot! Kamong mga kayake yang. Kamo yang kag dayaw sa GINO-O, tutal imaw kina kag inro ingpapaka-hagar.” Ag sinra ay ingtabog nak maghalin sa atubangan ni Paraon. ");
INSERT INTO bno_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Pagkahalin nina Moises, nagsugo kag GINO-O sa ida, “Itudlo nimo kinang imo damot sa bug-os nak duta it Ehipto agor maragsa kag pagkaruramong apan-apan dili. Ag inra aupton kag tanang tanom nak natura it bagyo it yelo.” ");
INSERT INTO bno_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Gingtudlo matuor ni Moises kag ida bakulo sa bug-os nak duta it Ehipto. Ag nagpahuyop kag GINO-O it makusog nak hangin halin sa subatan ag kali ay waya gitungon-tungon, tuna tong aga hastang gab-i ag hastang aga ray liwat. Pagkaaga, rayay it hangin kag maramong apan-apan. ");
INSERT INTO bno_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Nag-uyob kali sa bug-os nak duta it Ehipto. Abang ramo talaga kali. Pinaka-grabe kali sa mga dating silot it apan-apan ag wayaey it makakapareho dili. ");
INSERT INTO bno_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ingtabunan it kaling mga apan-apan kag bug-os nak duta hastang kali ay nagruyom. Ingpang-upot ninra kag tanang tanom nak waya nasira it katong yelo, kaumir kag tanang bunga nak nabilin sa mga puno. Wayaey nak gador it aber usang pisik it hilamunon nak makikita sa bug-os nak duta it Ehipto, ugoy nak gador. ");
INSERT INTO bno_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pagkatabo it kali, gingparali-rali it patawag ni Paraon sina Moises ag Aaron ag nagsiling, “Nagkasala ako laban sa GINO-O nak imo Dios ag laban sa inro. ");
INSERT INTO bno_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Patawara ninro ako liwat, ag pangamuyo sa GINO-O nak inro Dios nak bay-on kaling nakakamatay nak pesti sa ako.” ");
INSERT INTO bno_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Pagkahalin nina Moises sa atubangan ni Paraon ay nagpangamuyo sida sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Gingpalihis it GINO-O kag hangin agor makusog kag hangin halin sa sugbuhan, ag kali kag nagraya sa mga apan-apan papagto sa Puyang Ragat. Waya't natura aber usang apan-apan sa bug-os nak duta it Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero ingpatugas gihapon it GINO-O kag tagipusuon ni Paraon, ag waya ray nida gisugti nak magpanaw kag mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Masunor, nagsugo ray kag GINO-O kang Moises, “Tudluan kinang imo damot sa langit agor maruyom dili sa Ehipto, usang klase it ruyom nak talagang mababatyagan kag epekto.” ");
INSERT INTO bno_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kada ingtudlo matuor ni Moises kag ida damot sa langit, ag nagruyom talaga sa Ehipto sa suyor it tatlong adlaw. ");
INSERT INTO bno_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Indi ninra makita kag usa'g-usa, ag waya't nakaliwas sa inra bayay sa sakop it katong tatlong adlaw. Pero raha sa lugar kung hariin giiistar kag mga Israelinhon ay mahadag. ");
INSERT INTO bno_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pagkatabo it kali, ingpatawag ni Paraon si Moises ag nagsiling, “Hala pagtoy kamo, dayawa kag inro GINO-O, pati kag inro mga asawa ag mga anak ay nuntan, ugaling bilinan kag inro mga karnero, kambing ag baka.” ");
INSERT INTO bno_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pero nagrason si Moises, “Haring Paraon, indi kato puyde, dapat nak sugtan nimo kami nak inunot ra kag amo mga hadop, agor inggwa kami it aihawon ag asunugon bilang inughalar kang Yahweh nak amo Dios. ");
INSERT INTO bno_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Kinahangyan nak ray-on namo kag tanang amo mga hadop, agor ruto ay puyding pilion kag mga inughalar pramas dayawon kag GINO-O nak amo Dios. Aber usang bayukag ay waya't ibilin. Dahil waya pa namo naaayami kung hariin sa inra kag amatyon hastang waya pa kami nakakaabot ruto.” ");
INSERT INTO bno_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero ingpatugas gihapon it GINO-O kag tagipusuon ni Paraon ag waya nida gisugti sinra nak maghalin. ");
INSERT INTO bno_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Bag-o nagsiling si Paraon kang Moises, “Layas sa ako atubangan! Tanra-e kali, wayaey ako't gustong makita kag imo hitsura! Pag makita ka pa nako liwat ay mamamatayey ka!” ");
INSERT INTO bno_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Sabat ni Moises, “Kung imaw kina kag imo gusto, indiey ako magpakita sa imo.” ");
INSERT INTO bno_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ngasing nagsiling ray kag GINO-O kang Moises, “Usa yangey nak silot kag Ako iparaya kang Paraon ag sa mga Ehiptohanon. Pagkatapos it kali, asugtaney kamo nida nak maghalin dili. Buko yang kina, halos ida pa kamo atabugon agor makahaliney. ");
INSERT INTO bno_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sugu-a kag mga Israelinhon, kayake ag kabade, nak magpanghagar sa inra mga kayungot it mga alahas nak pilak ag buyawan.” ");
INSERT INTO bno_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ag gingbuot it GINO-O nak magta-o it pabor kag mga Ehiptohanon sa mga Israelinhon. Ag sa kamatuuran, pati si Moises ay gingtahor it mga opisyales it Ehipto ag it tanang sinakupan ni Paraon ruto. ");
INSERT INTO bno_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kada, bag-o maghalin si Moises sa atubangan ni Paraon ay nagsiling anay sida, “Haring Paraon, siling it GINO-O, ‘Isag sa tungang gab-i Ako ay malibot sa bug-os nak Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Kag tanang panganay nak kayake ninrong mga Ehiptohanon ay mamamatay, tuna sa panganay nak anak nimo, Paraon, ikaw nak asa trono, hastang sa panganay nak anak it pinaka-ulipon nak kabade nak asa gilingan, ag aber kag mga unang anak it inro mga kahadupan. ");
INSERT INTO bno_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Waya't ibang marurunggan sa bug-os nak Ehipto kundi kag makusog nak panambitan. Waya pang gador it tuyar nak panambitan nak narungog sa Ehipto tuna tong una pa, ag wayaey it marurunggan pa nak tuyar kali. ");
INSERT INTO bno_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","“ ‘Pero sa mga Israelinhon, wayang gador it marurunggan nak aber batok it iro sa tawo o hadop man.’ Parayan dili maaayaman ninro nak iba kag pagtratar it GINO-O sa mga Israelinhon ag sa mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Tanang imo mga opisyales ay mapayungot ag mayuhor sa ako atubangan sa pagpangabay, ‘Hala pagtoy kamo, kamo ag tanang gustong magnunot sa inro!’ Ag imaw kato kag oras nak ako'y mapanaw.” Pagkasiling ni Moises it kali, naghaliney sida sa atubangan ni Paraon nak abang hangit. ");
INSERT INTO bno_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Imaw pa kali kag ingsiling it GINO-O kang Moises it kato, “Indi magpati sa imo si Paraon, agor maramong milagro kag Ako mahihimo sa Ehipto.” ");
INSERT INTO bno_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ag ginghimo nina Moises ag Aaron kaling tanang mga milagro sa atubangan ni Paraon. Pero sa yudo it kina, waya gihapon nida gisugti kag mga Israelinhon nak maghalin sa ida duta dahil ingpatugas it GINO-O kag ida tagipusuon. ");
INSERT INTO bno_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nagsiling kag GINO-O kana Moises ag Aaron ruto sa Ehipto, ");
INSERT INTO bno_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Kaling buyan kag magiging unang buyan it inro tuig. ");
INSERT INTO bno_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Silingga kag tanang Israelinhon nak imaw kali kag inra dapat ahimuon sa pitsa dyes it kaling buyan. Bawat tatay ay mabaoy it usang tureting karnero para sa ida pamilya, ag usa sa usang panimayay. ");
INSERT INTO bno_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Pero kung kag usang pamilya ay apila yang, nak indi makaubos it usang turete nak karnero, puyde sinrang magpisan sa inra kayungot, nak apila ra, agor husto yang para sa inra kag usang turete. Akarkuluhon kung pauno't ramo kag makakaon it kada usang tawo. ");
INSERT INTO bno_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kag inro piniling turete ay dapat waya't diperensya, usang kayake nak nakaabot sa usang tuig. Kung waya't karnero ay kambing yangey. ");
INSERT INTO bno_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Abukuton kali ninro hastang sa ika-katorse it kaling buyan. Ag sa pagsugbo it adlaw it katong pitsa, rungan-rungan kaling aihawon ninrong tanan nak Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Pagkayu-yo ninro, masayor kamo it rugo. Ag magbaoy it husto yang para ipahir sa syapar ag sa magkanyudong hamba it hagran it bayay, kung hariin kamo makaon. ");
INSERT INTO bno_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Bag-o, sa gab-ing kato, inro kina aasayon ag isuya sa pagkaon it tinapay nak waya't pangpaalsa, kaibahan kag sawsawan nak mga mapait nak usbor it panamda. ");
INSERT INTO bno_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Indi kali ninro gikaunon it hilaw o yauda, kundi inasay, kaumir kag siki, uyo ag mga kasudlan. ");
INSERT INTO bno_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Aubuson ninro kali it kaon, ag aya gitura para sa aga. Pero kung inggwa't matura ay inro kali asunugon. ");
INSERT INTO bno_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Bag-o kamo magkaon, dapat ay preparadoy kamo para sa inro paghalin, nakahagkosey, nakasuksokey it sandalyas ag hudotey kag inro bakulo. Kag inro pagkaon ay paspasan. Kag tawag it kali ay Pista it Pagluwas it GINO-O sa Ida katawuhan sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Sa gab-ing kali, alibuton Nako kag bug-os nak bansa it Ehipto, ag amatyon Nako kag tanang panganay nak kayaking anak, maging tawo ag hadop, ag aparusahan Nako kag tanang gingkikilayang dios it mga Ehiptohanon. Ako yang kag GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Kinang rugo, nak inro ipahir sa syapar ag sa mga hamba it inro hagran ay magiging tanra. Pag makita Nako kina ay Ako kamo aligaran. Waya't mamamatay sa inrong nakaistar rahang bayay parayan diling silot, sa oras nak parusahan Nako kag mga Ehiptohanon.” ");
INSERT INTO bno_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Nagpadayon pa sa pagbisaya kag GINO-O, “Imaw kali kag adlaw nak inro arumrumon. Kaling Pista ay inro ahiwaton tuig-tuig bilang pagrumrom sa ginghimo it GINO-O sa inro, hastang sa pagbalhin it inro mga henerasyon. ");
INSERT INTO bno_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Tuyar kali kag inro pagrumrom. Sa suyor it pitong adlaw ay makaon kamo it tinapay nak waya't pangpaalsa. Sa unang adlaw, bay-a kag tanang pangpaalsa sa tinapay sa inro bayay, dahil aber si-o kag magkaon it inggwa't kali, tuna sa unang adlaw hastang sa ika-pito ay dapat iitsapuyra sa mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Kag una ag pangpitong adlaw ay inro agahinon agor magtipon ag magdayaw sa Ako. Sa suyor it ruhang adlaw nak kato, dapat waya't aber sin-o nak magtrabaho, puyra yang sa pag-intyendi it inro pagkaon. Imaw yang kato kag inro puyding himuon. ");
INSERT INTO bno_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Inro ahimuon kaling unang adlaw it Pista it Tinapay nak Waya't Pangpaalsa bilang pamatuor, nak sa adlaw nak kali ay Ako ingraya kag inro tanang lahi nak grupo-grupo paliwas sa Ehipto. Tuig-tuig ahiwaton ninro kali hastang sa pagbalhin it inro mga henerasyon. ");
INSERT INTO bno_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Kada tuig, sa unang buyan, tuna sa gab-i it pitsa katorse hastang sa gab-i it pitsa beynte-uno, kag tinapay nak inro akaunon ay katong waya't pangpaalsa. ");
INSERT INTO bno_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sa sakop it pitong adlaw ay dapat waya't makikitang pangpaalsa sa tinapay sa suyor it inro bayay. Gingsisiling Nako sa inro nak sin-o man kag magkaon it di pangpaalsa ay dapat iitsapuyra sa lahi it Israelinhon, sida man ay matuor nak Israelinhon o buko. ");
INSERT INTO bno_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Bawal nak kamo ay magkaon it tinapay nak di pangpaalsa. Aber hariin kamo giiistar, dapat tinapay yang nak waya't pangpaalsa.” ");
INSERT INTO bno_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Pagkabisaya it GINO-O kang Moises, ingtawag ni Moises kag mga pinuno it mga Israelinhon, ag nagsiling, “Mga Tatay, pagtoy ag pili kamo it tureteng karnero para sa inro pamilya. Ag kali ay inro aihawon agor ahiwaton kag Pista it Pagkaluwas sa inro. ");
INSERT INTO bno_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Pagkaihaw ninro kali, sayura kag rugo. Magbaoy kamo it pilang maintik nak sanga it isopo, ag itum-oy kina sa rugo, bag-o pahiran ninro kag syapar ag magkanyudong hamba it inro hagran. Pagkahimo ninro it kali, waya't maliwas sa inro hastang sa aga. ");
INSERT INTO bno_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","“Isag sa gab-i, malibot kag GINO-O sa bug-os nak Ehipto agor matyon kag mga panganay nak kayaking anak it mga Ehiptohanon. Pag nakita Nida kag rugo nak nakapahir sa syapar ag mga hamba it inro hagran, aligaran Nida kag inro bayay. Indi Nida gitugutan kag anghel nak manugmatay nak magsuyor raha pramas matyon kamo. ");
INSERT INTO bno_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Tumana ninro kaling inro dapat ahimuon hastang sa inro pagbalhin it mga lahi. ");
INSERT INTO bno_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Pag rahagtoy kamo sa duta nak gingpromisa it GINO-O nak ita-o sa inro, dapat nak inro kali ahiwaton tuig-tuig. ");
INSERT INTO bno_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ag pag ingpangutana kamo it inro mga anak kung asing inro kali ginghihiwat, ");
INSERT INTO bno_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","masiling kamo nak, ‘Ginghihiwat nato kaling pagmatay it karnero bilang inughalar sa GINO-O agor rumrumon tong gingligaran Nida kag mga bayay it ato mga ginikanan sa Ehipto. Kada kag mga Ehiptohanon ay Ida gingpamatay, ag gingluwas kita.’ ” Pagkarungog kali it mga Israelinhon, nagyinuhor sinra ag nagdinayaw. ");
INSERT INTO bno_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Gingtuman it mga Israelinhon kag tanang gingsugo it GINO-O parayan kana Moises ag Aaron. ");
INSERT INTO bno_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Pagkatungang gab-i, matuor naglibot kag GINO-O sa Ehipto, ag gingpamatay kag tanang panganay nak kayaking anak it mga Ehiptohanon, magtuna sa panganay ni Paraon nak asa trono hastang sa panganay it ida mga priso nak asa bartulina, pati tanang unang anak it inra kahadupan. ");
INSERT INTO bno_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tong gab-ing kato nautoy kag pagkatuyog nina Paraon ag tanang ida mga opisyales, pati tanang Ehiptohanon. Matuor nak marurungog sa bug-os nak Ehipto kag makusog nak panambitan dahil waya't aber usang bayay nak waya't minatay. ");
INSERT INTO bno_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tong gab-i rang kato, ingpatawag ni Paraon sina Moises ag Aaron ag nagsiling, “Hala, haliney kamo, ngasing nak raan! Kamong tanang mga Israelinhon pagtoy, ag magdayaw kamo sa inro GINO-O tuyar sa inro ginghahagar! ");
INSERT INTO bno_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Pagtoy, ray-a kag inro tanang mga kahadupan tuyar ra sa inro ginghahagar ag pumagtoy kamo! Pangamuyuan ra ninro ako nak ako'y kaluy-an Nida!” ");
INSERT INTO bno_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Pati kag tanang Ehiptohanon ay nagbubulig sa pagpalayas sa mga Israelinhon paliwas sa inra lugar sa pagsiling, “Halin kamo sabaling kaming tanan ay mamatay pa!” ");
INSERT INTO bno_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kada gingbaoy it mga Israelinhon ag gingbutang sa planggana kag inra minasang arina nak waya pa't pangpaalsa. Ag kali ay inra ingpuros it yamit pramas mapas-an bag-o maghalin. ");
INSERT INTO bno_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ag bag-o ra sinra nakahalin, gingtuman it mga Israelinhon kag gingbisaya sa inra ni Moises ag nagpanghagar sinra sa mga Ehiptohanon it mga alahas nak human sa pilak ag buyawan, pati mga baro. ");
INSERT INTO bno_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Gingbuot matuor it GINO-O nak maging maatag kag mga Ehiptohanon sa inra, ag gingta-o kag inra ginghagar. Parayan dili, inra ingpangbay-an it mga ari-arian kag mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ngasing kag mga Israelinhon ay naghalin sa lugar it Gosen nak ingtatawag rang Rameses, sa Ehipto, papagto sa Sucot. Mga sais syentos mil (600,000) nak mga kayake kag nagpanaw halin ruto, puyra pa sa mga kabade ag mga anak. ");
INSERT INTO bno_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Buko yang kato kag inra ramo dahil inggwa't ibang mga buko Israelinhon nak nagnunot sa inra, pati kag inra maramong kahadupan, grupo-grupo it mga karnero, kambing ag baka. ");
INSERT INTO bno_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pagpahuway ninra, gingyuto ninra kag inra minasang arina nak waya't pangpaalsa. Gingraya ninra kali halin sa Ehipto tong sinra ay ingtabog ruto, dahil wayaey sinra it oras nak maghikot pa it inra bayon. ");
INSERT INTO bno_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Kag rugay it pag-istar it mga Israelinhon ruto sa Ehipto ay ap-at nak gatos ag treyntang (430) tuig. ");
INSERT INTO bno_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Sa katapusan it katong pang-ap-at nak gatos ag treyntang (430) tuig, imaw nak gador kato kag adlaw tong kag tanang katawuhan it GINO-O ay nagliniwas nak grupo-grupo halin sa duta it Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Sa suyor it katong gab-i nak kato, gingbantayan nak gador sinra it GINO-O hastang makahalin sinrang tanan sa bansa it Ehipto. Kada bawat tuig, tuna it kato ay ingrurumrom it mga Israelinhon kaling pagbantay sa inra it GINO-O parayan sa pagramyag, bilang pagtahor sa Ida. Tuig-tuig ahiwaton ninra kali hastang sa pagbalhin it inra mga henerasyon. ");
INSERT INTO bno_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Nagsiling kag GINO-O kana Moises ag Aaron, “Kali kag mga kasuguan nahanungor sa Pista it Pagkaluwas it mga Israelinhon sa Ehipto: “Kag mga tawong buko Israelinhon ay indi puyding magkaon. ");
INSERT INTO bno_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ugaling kung inggwa kamo it mga nabakay nak ulipon sa inro panimayay ay puyde sinrang magkaon, basta sinra ay natuliey. ");
INSERT INTO bno_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Pero kag mga nagbisita yang sa inro ag mga suhuyan nak trabahador ay indi puyding magkaon. ");
INSERT INTO bno_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Ag kinahangyan nak sa suyor yang it bayay dapat ninrong kaunon kaling karnero. Aya giraya it aber maisot sa liwas. Ag nahanungor sa mga suká it kali, dapat indi ninro gibalion. ");
INSERT INTO bno_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","“Kag tanang Israelinhon ay dapat maghiwat it kaling Pista. ");
INSERT INTO bno_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Kung inggwa't tawong buko Israelinhon nak nagsaydo raha sa inro, ag gustong mag-iba sa Pista it Pagkaluwas ninro sa Ehipto ay puyde sinra, basta kag tanang kayake sa inra pamilya ay natuliey. Dahil kung inra kali asunron, pay sinra'y mga Israelinhoney ra. Pero indi nak gador puyde magkaon kag mga waya pa natutuli. ");
INSERT INTO bno_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tanan ay naumir it kaling kasuguan, sida man ay matuor nak Israelinhon o katong mga nagsaydo raha agor mag-istar sa inro lugar.” ");
INSERT INTO bno_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Gingsunor matuor it tanang mga Israelinhon kag tanang gingsugo it GINO-O kana Moises ag Aaron. ");
INSERT INTO bno_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ag tong adlaw nak kato gingliwas it GINO-O kag mga Israelinhon sa duta it Ehipto kumporme sa inra lahi nak grupo-grupo. ");
INSERT INTO bno_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nagsiling pa kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Gahina para sa Ako kag inro tanang panganay nak anak nak kayake. Kag tanang panganay it mga Israelinhon ay para sa Ako, maging tawo o hadop man.” ");
INSERT INTO bno_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Nagsiling ray si Moises sa mga Israelinhon, “Ako mga kasimanwa, rumruma ninro kaling adlaw, nak imaw kali kag adlaw nak kamo ay gingliwas it GINO-O sa Ehipto. Kamo ay Ida ra ginglibre sa pagkaulipon ruto parayan sa Ida rakong gahom. Indi kamo magkaon it tinapay nak inggwa't pangpaalsa. ");
INSERT INTO bno_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","“Ngasing nak adlaw, sa buyan it Abib, mahalin kamo rili sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Aray-on kamo it GINO-O sa duta nak gingpromisa Nida sa inro mga ginikanan nak mapapasa-inro, sa duta it mga Canaanhon, Hetanhon, Amornon, Hebinhon, ag Jebusnon, katong duta nak bugana kag pagkaon nak pay nagbabaha kag gatas ag rugos. “Pag-abot ninro ruto, ahiwaton ninro kaling pista bawat tuig sa tuyar nak pitsa it buyan it Abib: ");
INSERT INTO bno_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sa suyor it pitong adlaw makaon kamo it tinapay nak waya't pangpaalsa, ag sa ika-pitong adlaw mahiwat kamo it pista para sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Kag inro kaunon nak tinapay ay katong waya't pangpaalsa sa sakop it kinang pitong adlaw. Dapat waya't pangpaalsa o tinapay nak di pangpaalsa nak makikita sa inro mga nasasakupan. ");
INSERT INTO bno_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Sa adlaw nak kato, inro isiling sa inro mga anak kung asing ginghihiwat nato kali ay dahil sa ginghimo it GINO-O sa amo tong kami ay Ida gingliwas sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“Kaling paghiwat it pista nak kali ay nupay tanra sa inro mga damot ag sa inro mga yupa, agor indi ninro malimtan nak ibisaya kag kasuguan it GINO-O. Dahil parayan sa Ida rakong gahom Ida kami gingliwas sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kaling paghiwat ay inro ahimuon tuig-tuig sa tamang adlaw. ");
INSERT INTO bno_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Kag GINO-O kag maraya sa inro sa duta it mga Canaanhon, tuyar sa Ida gingpromisa sa inro ag sa inro mga ginikanan, nak ita-o sa inro. ");
INSERT INTO bno_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Pag-abot ninro ruto, inro ihalar sa GINO-O kag inro tanang panganay nak kayake. Pati tanang unang anak it inro mga hadop ay para sa Ida. ");
INSERT INTO bno_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ugaling tanang unang anak it inro asno nak inughalar sa Ida ay puyding tubuson it karnero. Pero kung indi ninro igtubuson, inro abalion kag liog it kali. Tanang inro panganay nak anak nak kayake ay dapat ninrong tubuson. ");
INSERT INTO bno_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Sa huli, pag magpangutana kag inro mga anak nak, ‘Ni-o kag gustong bisayahon it kali?’ inro asabton sinra nak, ‘Ato kali ginghihiwat dahil parayan sa rakong gahom it GINO-O, Ida kita gingsalbar sa Ehipto halin sa pagkaulipon. ");
INSERT INTO bno_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","It katong nagmatugas si Paraon sa pagsugot nak makaliwas kita sa Ehipto, gingmatay it GINO-O kag tanang panganay nak kayake ruto, maging tawo o hadop. Kada ngani gingmamatay nato bilang inughalar sa Ida kag tanang unang anak nak kayake it ato mga hadop, pero gingtutubos nato kag ato mga panganay nak anak nak kayake.’ ");
INSERT INTO bno_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","“Kaling paghiwat nak kali ay nupay tanra sa inro mga damot ag sa mga yupa agor indi nato malimtan nak kita ay gingliwas it GINO-O sa Ehipto parayan sa Ida rakong gahom.” ");
INSERT INTO bno_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ngasing, tong gingsugtan ni Paraon kag mga Israelinhon nak maghalin sa Ehipto, waya sinra giparayana it Dios sa lugar it mga Pilistinhon, aber kali kag pinaka-mayungot nak rayan. Dahil siling it Dios, “Baka masapoy ninra kag gera ag magbaydo kag inra isip ag magbalik sa Ehipto.” ");
INSERT INTO bno_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kada gingparayan sinra it Dios sa rayan sa disyerto hastang nakasampot sa Puyang Ragat. Nagpanaw kag mga Israelinhon halin sa Ehipto nak hanraey para sa pagpakiglaban. ");
INSERT INTO bno_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Sa pagtakas nina Moises halin sa Ehipto ay ingraya ra ninra kag mga suká it inra ginikanan nak si Jose. Dahil gingpasumpa nida it kato sa mga Israelinhon nak, “Kag Dios nak gador kag maruaw ag matabang sa inro. Kada paghalin ninro rili sa Ehipto, ray-a kag ako mga suká halin dili.” ");
INSERT INTO bno_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Paghalin it mga Israelinhon sa Sucot ay nagbaktas sinra hastang nakaabot sa Etam pasuyuron it disyerto, kung hariin sinra ay nagpahuway. ");
INSERT INTO bno_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Gingbabantayan sinra it GINO-O. Sa adlaw, nag-uuna Sida sa inra parayan sa haligi nak rampog agor tudluan sinra it rayan. Imaw ra sa gab-i, nag-uuna Sida sa inra parayan sa haligi nak kayado agor imaw kag maging iwag ninra. Kali ay pramas makakapadayon sinra sa pagpanaw, gab-i man o adlaw. ");
INSERT INTO bno_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Kag haligi nak rampog sa adlaw ag kag haligi nak kayado sa gab-i ay waya gibubuyag sa inra unahan. ");
INSERT INTO bno_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ngasing nagsiling kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Silingga kag mga Israelinhon nak magbalik halin sa Etam pasuyuron sa disyerto ag magkampo sa atubangan it Pihahirot, sa tunga it Migdol ag ragat, sa atubangan ra it Baal-zepon. Ruto kamo mapatukor it inro mga tolda mayado-yado sa ragat. ");
INSERT INTO bno_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Maiisip ni Paraon nak, ‘Siguradong katong mga Israelinhon ay nagkayaag-yaag dahil waya sinra't makitang ayusutan sa disyerto.’ ");
INSERT INTO bno_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ako apatugason kag tagipusuon ni Paraon ag kamo'y ida ayaguron. Pero apirdihon Nako sida ag ida tanang mga sundalo, ag apurihon Ako it tanang tawo aber hariing lupalop. Maaayaman nak gador it mga Ehiptohanon nak Ako kag GINO-O.” Ngani, gingtuman matuor kali it mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","It katong nabalitaan it hari it Ehipto nak imaw si Paraon, nak kag mga Israelinhon ay nakahaliney, kag ida isip, pati kag isip it ida mga opisyales ay nagbag-o. Siling ninra, “Ni-o kaling ato ginghimo? Asing ato gingsugtan kag mga Israelinhon nak maghalin? Si-o pa ngasing kag matrabaho para sa ato?” ");
INSERT INTO bno_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ngani, inghanra ni Paraon kag ida karwahe nak panggera ag ingnunot kag ida mga sundalo. ");
INSERT INTO bno_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Kag ida ingnunot ay an-om nak gatos (600) nak maadong mga karwahe nak panggera, pati kag tanang klase it karwahe nak di sakay nak mga sundalo. ");
INSERT INTO bno_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ingpatugas ray it GINO-O kag tagipusuon ni Paraon, nak hari it Ehipto, kada ida yinagor kag mga Israelinhon habang sinra ay nagtatakas nak inggwa't kaisog sa inra huna-huna. ");
INSERT INTO bno_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Kag mga Ehiptohanon ay nagyagor sa mga Israelinhon, tanang mga sundalo ni Paraon, tanang mga karwahe nak panggera, tanang sundalo nak nakasakay sa kabayo, ag tanang sundalo nak nagbabaktas. Naantaw ninra kag mga Israelinhon nak nagkakampo sa tungor it baybay, mayungot sa Pihahirot sa atubangan it Baal-zepon. ");
INSERT INTO bno_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Habang nagpapayungotey sina Paraon, nakita it mga Israelinhon kag matulin nak pagmartsa it ida mga sundalo. Ag sinra ay napakahadlok ag nag-ayaba sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ag nagsiling sinra kang Moises, “Kumo waya it kamposanto sa Ehipto, kada imo kami rinaya riling disyerto pramas mamatay? Asing tuyar kag imo ginghimo sa amo? Asing gingbaoy pa kami nimo sa Ehipto? ");
INSERT INTO bno_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Di baga kag amo siling sa imo tong ruto pa kami sa Ehipto ay, ‘Pabad-e yang kami nak magpaulipon sa mga Ehiptohanon? Aya kami gikalibgi!’ Mas maado pa nak magpaulipon kami sa inra kisa mamatay rili sa disyerto.” ");
INSERT INTO bno_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nagsabat si Moises sa mga tawo, “Aya kamo gikahadlok! Pakusuga kag inro buot, ag inro makikita kung pauno kamo isalbar it GINO-O. Ngasingey kina Nida ahimuon. Kinang mga Ehiptohanon nak inro nakikita ngasing ay indiey nak gador ninro sinra makikita liwat. ");
INSERT INTO bno_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Kag GINO-O it malaban para sa inro, waya kamo it mahihimo.” ");
INSERT INTO bno_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ag nagsiling kag GINO-O kang Moises, “Asing imo Ako ging-aayaba? Silingga kag imo mga haling Israelinhon nak magpadayon sa pagpanaw. ");
INSERT INTO bno_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tas-an kinang imo hudot nak bakulo ag itudlo sa ragat. Ag kali ay matutunga agor kamong mga Israelinhon ay mapanaw sa uga nak duta patabok sa ragat. ");
INSERT INTO bno_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","18","Apatugason pa Nako kag tagipusuon it mga Ehiptohanon agor inra kamo ayaguron. Apurihon Ako it tanan pag napirdi Nako sinra parayan sa matatabo kang Paraon, sa ida tanang mga sundalo, pati sa ida mga karwahe ag mga sundalo nak nakasakay sa kabayo. Parayan dili maayaman nak gador it mga Ehiptohanon nak Ako kag GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ngasing kag anghel it Dios nak nagpapanguna sa mga Israelinhon ay nagpahuli sa inra, ag kag haligi nak rampog ay nagsaydo ra sa huli ag nagruyog sa inra likor. ");
INSERT INTO bno_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Kaling rampog ay nagpatunga sa inra ag sa mga Ehiptohanon. Ngani, sa bug-os nak gab-i, maruyom sa parti it mga Ehiptohanon ag mahadag sa parti it mga Israelinhon, ag dahil rili waya nakapayungot kag mga Ehiptohanon sa inra. ");
INSERT INTO bno_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Masunor, gingtudlo matuor ni Moises kag ida damot sa ragat. Sa bug-os nak gab-i, gingpahuyop it GINO-O kag makusog nak hangin halin sa subatan, ag natunga kag tubi. Kada nagkainggwa't ugang rayanan sa tunga it ragat. ");
INSERT INTO bno_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ngani, kag mga Israelinhon ay nagpanaw patabok sa ugang duta raha sa tunga it ragat. Kag tubi ay pay naging pader sa inra bandang wala ag tu-o. ");
INSERT INTO bno_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Pagkaaga ingyagor ray sinra it mga Ehiptohanon. Kaibahan sa pagyagor kag tanang mga sundalo ni Paraon, tanang nakapangabayo ag tanang nakakarwahe. ");
INSERT INTO bno_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Halin sa haliging kayado ag rampog ingmumuyatan it GINO-O kag tanang natatabo, ag it katong mayungotey magpanghudag-hudag, inatraso Nida sa pagbiyahe kag mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kag mga gulong it inra mga karwahe ay naputik, kada nahirapan sinra magbiyahe. Ngani, siling yangey ninra, “Balik yangey kita! Dahil kag GINO-O it naglalaban sa ato para sa inra.” ");
INSERT INTO bno_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Pagkatabok nina Moises, nagsiling kag GINO-O sa ida, “Tudluan ray raha kag imo damot sa ragat, agor kag tubi ay mabalik ag matabunan kag mga Ehiptohanon, pati kag inra mga karwahe, ag kag mga nakapangabayo.” ");
INSERT INTO bno_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kada gingtudlo matuor ni Moises kag ida damot sa ragat, ag pagsubat it adlaw kag tubi ay nagbalik matuor sa ida dating suyog. Nagtinguha kag mga Ehiptohanon nak makatakas, ugaling gulping ingpabalik it GINO-O kag tubi, kada tanan sinra ay nagkayunor. ");
INSERT INTO bno_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nagtabo katong tubi, ag natabunan kag mga nakasakay sa karwahe ag kag mga nakapangabayo, tanang mga sundalo ni Paraon nak nagsinunor sa mga Israelinhon hastang sa tunga it ragat, ag wayang gador it aber usa nak nabuhi pa sa inra. ");
INSERT INTO bno_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pero kag mga Israelinhon ay nagtabok sa ugang duta sa tunga it ragat, naging pader ninra sa wala ag tu-o kag tubi. ");
INSERT INTO bno_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tong adlaw nak kato, gingsalbar it GINO-O kag mga Israelinhon halin sa mga damot it mga Ehiptohanon. Ag nakita it mga Israelinhon kag abang ramong minatay nak Ehiptohanon nak ingragsa sa piliw. ");
INSERT INTO bno_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Pagkakita it mga Israelinhon sa rakong gahom it GINO-O laban sa mga Ehiptohanon, sinra ay nagkainggwa't kahadlok sa Ida ag nagtu-o sinra sa Ida, pati kang Moises nak Ida suguon. ");
INSERT INTO bno_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Pagkatabok ninra sa ragat, nagkinanta si Moises ag kag mga Israelinhon para sa GINO-O it tuyar kali: “Kami ay makanta sa GINO-O, dahil katitingaya kag Ida pagraog. Kag mga kabayo ag mga sundalong nakapangabayo it amo kaaway ay Ida yang tinapyak sa ragat. ");
INSERT INTO bno_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Kag GINO-O kag nagtata-o sa amo it kusog, Sida kag amo ingkakanta. Sida kag amo Manluluwas, Sida kag amo Dios, amo Sida adayawon, Sidang Dios it amo tatay, amo Sida itaas. ");
INSERT INTO bno_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Kag GINO-O ay sundalo nak waya't kapantay. GINO-O kag Ida pangayan. ");
INSERT INTO bno_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Kag mga karwahe ni Paraon ag kag ida mga sundalo, Ida yang tinapyak sa ragat. Gingyunor ra Nida sa Puyang Ragat kag mga piling pinunong sundalo ni Paraon. ");
INSERT INTO bno_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kag marayom nak tubi it nagtabon sa inra. Nagrugyang sinra nak nupay bato. ");
INSERT INTO bno_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Kag Imo tuong damot, amo GINO-O, ay makagagahom. Ingwagit kag amo mga kaaway parayan sa Imo rakong gahom. ");
INSERT INTO bno_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ikaw nak Halandong Hari, it nagpirdi sa Imo mga kalaban. Nagrayab-rayab kag Imo kahangit, nak imaw kag pay nagsunog sa inra tuyar sa mga uhot. ");
INSERT INTO bno_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Pay Imo yang inghuyop, ag natunga kag tubi. Kag suyog ay nagpaibabaw nak pay tuyar sa pader. Kag marayom nak tubi ay pay nagtugas hastang sa katugkaran. ");
INSERT INTO bno_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kag mga kaaway ay naghinambog, ‘Ayaguron namo sinra, amo sinra maaabutan, ag amo aparti-partihon kag inra mga manggar sa amo mga kaibahan, hastang sinra ay magkawar-an. Amo ahukason kag amo talibong, ag amo sinra apangmatyon.’ ");
INSERT INTO bno_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pero sa usang hudop yang Nimo, natabunan sinra it ragat. Nagyugrang sinra nak pay tingga sa marayom nak tubi. ");
INSERT INTO bno_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Si-o sa inra mga dios kag makakapantay sa Imo, amo GINO-O? Si-o kag makakapantay sa Imo nak makagagahom ag balaan? Si-o kag makakapareho sa Imo nak gingkakahadlukan dahil sa Imo mga ginghihimo nak mga katitingayang milagro? ");
INSERT INTO bno_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Pay Imo yang ginghunat kag Imo tuong damot, ag sinra ay gingyubong sa irayom it ragat. ");
INSERT INTO bno_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Dahil sa Imo waya gibabag-ong pagpalangga, nag-uuna Ikaw sa amo, nak Imo mga tinubos. Parayan sa Imo kusog, kami ay Imo ingpapangunahan papagto sa Imo balaan nak istaran. ");
INSERT INTO bno_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kali ay mababantog sa ibang mga nasyon, ag sinra ay mapanguyog; Mababatyagan it mga Pilistinhon kag kahadlok tuyar sa kabading nagpapasyapo. ");
INSERT INTO bno_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Kag mga pinuno it Edom ay magkakahadlok. Kag mga nagpapanguyo sa Moab ay mapinanguyog, ag kag tanang mga taga-Canaan ay pay matutunaw sa kahadlok. ");
INSERT INTO bno_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Kahadlok ag pagkalibog kag mahari sa inra. Parayan sa rakong gahom it Imo damot, sinra'y pay mga bato nak indi makahiwas, Hastang kaming Imo mga tawuhan, amo GINO-O, ay nakarayan, Kaming Imo mga tinubos, sinra ay amo nalampasan. ");
INSERT INTO bno_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Aray-on Nimo kami ag ibutang sa Imo gingpromisang duta, sa lugar nak Imo pinili, amo GINO-O, agor maging Imo istaran, sa Templo nak gingtinrog it Imo damot. ");
INSERT INTO bno_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Kag GINO-O it mahari hastang sa waya't katapusan.” ");
INSERT INTO bno_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","20","Ngasing kag manghor nak rayaga ni Aaron nak kag ngayan ay si Miriam ay usang propeta. Ag pagkatabok ninra sa ragat, narumruman nida nak tong gingyayagor kag mga Israelinhon it mga kabayo ni Paraon, kanunot kag mga nakasakay sa karwahe ag ibang mga sundalo ay ingpabalik it GINO-O kag tubi ag natabunan sina Paraon. Pero kag mga Israelinhon ay imaw kag sa unahan nak nagpapanaw yang patabok sa ugang duta sa tunga it ragat. Kada nagbaoy sida it tamborin, ag nagsunor ra sa ida kag tanang mga kabade nak gamit ra kag tamborin ag nagsasadaw habang nagkakanta sida. ");
INSERT INTO bno_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Tuyar kali kag kanta ni Miriam: “Magkanta it pagdayaw sa GINO-O dahil Sida ay nagraog. Kag mga kabayo ag mga sundalong nakapangabayo it ato kaaway ay Ida yang tinapyak sa ragat.” ");
INSERT INTO bno_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Pagkatapos, gingpahanra ni Moises kag mga Israelinhon sa pagpadayon, ag nagginaney sinra halin sa Puyang Ragat papagto sa Disyerto it Sur. Nagpanaw sinra sa sakop it tatlong adlaw, ag waya sinra't nakitang tubi. ");
INSERT INTO bno_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Tong bandang huli, nakaabot sinra sa tuburan it Mara, ugaling indi ninra mainom kag tubi ruto dahil kali ay mapait. Kada kaling tuburan ay gingtawag nak Mara. ");
INSERT INTO bno_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ngani, nagnginuyob kag mga tawo laban kang Moises, ag siling ninra, “Ni-o ngasing kag ato ainumon?” ");
INSERT INTO bno_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Dahil rili, sida ay nag-ayaba sa GINO-O. Ag gingtudlo sa ida it GINO-O kag usang klasing sanga raha. Ingbaoy nida kina ag ingpilak sa tubi, ag kag pait it kinang tubi ay nabaoy. Ruto, gingpurbahan sinra it GINO-O ag ingtaw-an it kasuguan. ");
INSERT INTO bno_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Siling Nida sa inra, “Ako kag GINO-O nak inro Dios, kung kamo yang ay magpanimati it maado sa Ako gingsisiling sa inro, ag himuon kung ni-o kag tama sa Ako pagmuyat ag tumanon kag Ako mga kasuguan, ay indi Nako giparaya sa inro kag mga sakit tuyar sa Ako gingparaya sa mga Ehiptohanon, dahil Ako kag GINO-O nak inro manugbuyong.” ");
INSERT INTO bno_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Pagkatapos it kina, kag masunor nak lugar nak inra ingsamputan ay Elim, kung hariin ay inggwa't doseng tuburan ag sitentang puno it palmera. Ruto sinra gikampo sa palibot it mga tuburan. ");
INSERT INTO bno_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kag pagkampo it tanang Israelinhon sa Elim ay waya narugay kundi nagpadayon ray sinra hastang nakaabot sa Disyerto it Sin nak asa tunga it Baguntor it Sinay ag Elim. Nakaabot sinra raha it pitsa kinse it ika-ruhang buyan tuna tong sinra ay naghalin sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Habang sinra ay nagpapadayon it pagpanaw sa disyerto, kag mga Israelinhon ay nagnginginuyob kana Moises ag Aaron. ");
INSERT INTO bno_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Kag inra siling ay, “Maado pang gingmatay yangey kami it GINO-O it katong ruto pa kami sa Ehipto! Ruto ay nakakaatubang kami sa kinantong nak suya ag nakakakaon kami hangga't gusto namo it tinapay ag iba pang pagkaon. Pero rili sa disyerto nak inro gingray-an sa amo, ay inro kami amatyon sa gutom.” ");
INSERT INTO bno_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kada ngani, nagsiling kag GINO-O kang Moises, “Ako kamo apauyanan it pagkaon nak halin sa langit. Silingga kag mga tawo nak adlaw-adlaw maliwas sinra ag mapunpon it tama yang nak inra pagkaon sa adlaw nak kato. Rili apurbahan Nako sinra, ag maaayaman kung talagang inra asunron kag Ako gingsusugo o indi. ");
INSERT INTO bno_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ugaling sa pang-an-om nak adlaw ay mapunpon sinra ag ayutuon nak tama yang para sa inra kunsumo sa ruhang adlaw.” ");
INSERT INTO bno_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kada, gingsilinggan nina Moises ag Aaron kag mga Israelinhon, “Mga kasimanwa, isag sa gab-i, maaayaman ninro nak kag GINO-O it naghaw-as sa inro sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ag insulip sa aga, makikita ninro kag Ida kahimayaan dahil narunggan Nida kag inro pagnguyob laban sa Ida. Asing sin-o rang gador kami para sa amo kamo magnguyob?” ");
INSERT INTO bno_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ag nagsiling pa si Moises, “Ngasing nak hapon, ataw-an kamo it GINO-O it karne, ag sa aga, ay tinapay ray hastang gusto ninro. Dahil narunggan Nida kag inro mga nguyob laban sa Ida. Asing sin-o rang gador kami para sa amo kamo magnguyob? Buko kami kag inro gingngunguyuban kundi kag GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ag masunor, nagsiling si Moises kang Aaron, “Manong, silingga kag tanang Israelinhon nak magpayungot nganat sinra sa GINO-O dahil Ida narunggan kag inra mga nguyob.” ");
INSERT INTO bno_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ag habang nagbibisaya si Aaron sa inra, nagmuyat sinra sa disyerto ag gingpakita it GINO-O kag Ida kahimayaan hina sa rampog. ");
INSERT INTO bno_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nagsiling kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Narunggan Nako kag mga pagnguyob it mga Israelinhon. Silingga sinra nak sa hapon, karne kag inra akaunon, ag sa aga, mabubusog sinra it tinapay. Ag inra maaayaman nak Ako kag GINO-O nak inro Dios.” ");
INSERT INTO bno_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Pagkahapon matuor abang ramong pugo kag nagtugpa sa inra kampo, nak pay halos indiey makita kag raga. Ag pagkaaga, maramoy nak tun-og kag nakapalibot sa inra kampo. ");
INSERT INTO bno_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Pagkawagit it tun-og, makikita sa raga kag pay limbok nak abang puti. ");
INSERT INTO bno_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Pagkakita kali it mga Israelinhon, nagpangutana sinra sa usa'g-usa, “Ni-o kali?” Dahil waya ninra naaayami kung ni-o kato. Ag nagsiling si Moises sa inra, “Kali kag pagkaon nak gingta-o sa inro it GINO-O agor inro akaunon. ");
INSERT INTO bno_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ag imaw kali kag tugon it GINO-O, ‘Kada usa sa inro ay mapunpon it tama yang para sa inro kunsumo sa usang adlaw, tunga sa gantang kada usang tawo nak asa inro tolda.’ ” ");
INSERT INTO bno_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Imaw matuor kag inghimo it mga Israelinhon. Kag iba ay nagpunpon it maramo ag kag iba ay maisot yang. ");
INSERT INTO bno_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ugaling tong ingtakosey ninra kali, katong nagpunpon it maramo ay waya't subra, ag katong nagpunpon it maisot yang ay waya't kuyang. Kada pay kag inra gihapon napunpon ay tama yang. ");
INSERT INTO bno_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ag nagsiling pa si Moises, “Aya kamo giaman it para sa aga.” ");
INSERT INTO bno_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ugaling kag iba sa inra ay waya gisunor kang Moises. Nag-aman gihapon sinra it para sa aga. Pero pagkaaga, kali ay inapihis ag nagbaho. Ngani, nahangit si Moises sa inra. ");
INSERT INTO bno_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tuna it kato kada aga, nagpupunpon yangey sinra it tama yang para sa inra kunsumo. Ag pag-init it adlaw, kali ay natutunaw. ");
INSERT INTO bno_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Pero sa pang-an-om nak adlaw, nagpunpon sinra it duble, nak imaw kag usang gantang para sa usang tawo. Pagkakita kali it mga nagpapamuno sa mga Israelinhon, nag-uma sinra kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ag sinra ay ida ingsabat, “Pabad-e yang sinra dahil imaw kali kag sugo it GINO-O, ‘Insulip ay Adlaw it Inugpahuway ag mapahuway kita dahil kali kag sagradong adlaw para sa Ida. Kayduhay kag inro gustong kayduhon, ag ya-gaay kag inro gustong ya-gaon. Puyding magtura kamo it para insulip.’ ” ");
INSERT INTO bno_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kada, tuyar sa gingsugo sa inra ni Moises gingtura ninra kag para sa masunor nak adlaw. Ag kali ay waya giapihisa ag waya gibaho. ");
INSERT INTO bno_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Pagkaaga siling ni Moises, “Kauna ninro kali ngasing nak adlaw dahil kali ay Adlaw it Inugpahuway nak inggahin para sa GINO-O. Ag usa pa, ngasing, ay waya kamo it makikita nak tuyar it kali sa raga. ");
INSERT INTO bno_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","An-om nak adlaw kamong mapunpon it kali, pero sa pangpitong adlaw nak imaw kag Adlaw it Inugpahuway ay waya kamo't makikita.” ");
INSERT INTO bno_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pero sa yudo it kina, tong pangpitong adlaw, inggwa gihapon it mga nagliwas agor magpunpon, ugaling waya sinra't nakita. ");
INSERT INTO bno_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Dahil rili, siling it GINO-O kang Moises, “Hastang sauno kamo masuway sa Ako mga sugo ag mga tudlo? ");
INSERT INTO bno_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Tanra-e ninro, Ako kag GINO-O kag nagta-o sa inro it Adlaw it Inugpahuway. Kada ngani sa pang-an-om nak adlaw Ako kamo gingtataw-an it pagkaon para sa ruhang adlaw. Sa pangpitong adlaw, waya't maliwas sa inro tolda.” ");
INSERT INTO bno_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ngani, kag mga tawo ay nagpahuway sa pangpitong adlaw. ");
INSERT INTO bno_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Manna kag tawag it mga Israelinhon sa pagkaon nak inra napupunpon. Kali ay tuyar sa limbok nak abang puti, ag kag lasa it kali ay pay tinapay nak gingpatam-isan it rugos. ");
INSERT INTO bno_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ag nagsugo pa sa inra si Moises, “Kali kag tugon it GINO-O, ‘Baoy kamo it usang susudlan nak masuyor it tunga sa gantang, ag pun-on ninro it manna. Hipira kali, agor makikita pa hastang sa pagbalhin it inro mga henerasyon kag pagkaon nak gingta-o Nako sa inro sa disyerto, tong Ako kamo ginghaw-as sa Ehipto.’ ” ");
INSERT INTO bno_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ngani, siling ray ni Moises kang Aaron, “Baoy it usang kuyon ag pun-on kali it manna. Bag-o ibutang kali sa atubangan it GINO-O para taguon, agor makikita pa hastang sa pagbalhin it ato mga henerasyon.” ");
INSERT INTO bno_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kumporme sa sugo it GINO-O kang Moises, ingbutang ni Aaron kaling manna sa atubangan it Balaan nak Kaban agor taguon. ");
INSERT INTO bno_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Manna kag gingkaon it mga Israelinhon sa suyor it kwarentang tuig, hastang nakaabot sinra sa lugar it Canaan kung hariin sinra gipangabuhi. ");
INSERT INTO bno_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Kag inra butangan nak ingtatakusan it manna ay omer nak kag unor ay kuyang nak tunga sa gantang. ");
INSERT INTO bno_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Halin sa kabagunturan it Sin, kag tanang Israelinhon ay nagpadayon sa inra pagpanaw. Nagsaydo-saydo sinra kumporme sa sugo it GINO-O, hastang nakaabot sa Repidim kung hariin sinra nagkampo. Pero waya't tubi ruto nak puyding inumon kag mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kada si Moises ay ging-away ray it mga tawo ag nagsiling, “Taw-e kami it tubi nak inumon.” Nagsabat sida, “Asing ako kag inro ging-aaway? Asing inro talaga gingpupurbahan kag GINO-O?” ");
INSERT INTO bno_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ugaling pwerting uhawey kag mga Israelinhon ruto, kada sige gihapon kag inra pagnguyob laban kang Moises. Siling ninra, “Asing imo pa kami gingliwas sa Ehipto, kung imo yang ra kami amatyon sa uhaw, ag kag amo mga anak, pati kag amo mga kahadupan?” ");
INSERT INTO bno_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ngani, nagpangamuyo ray si Moises sa GINO-O, “Ni-o kag ako ahimuon riling mga tawo? Kuyang yangey ay inra ako matyon parayan sa pagbunggo.” ");
INSERT INTO bno_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nagsabat kag GINO-O kang Moises, “Mag-una ka sa mga tawo, ag nuntan kag pilang inro pinuno. Ray-a kag imo bakulo nak imo dating gingsikwil sa Suba it Nilo, ag magpanaw. ");
INSERT INTO bno_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ahuyaton ka Nako ruto sa marakong bato sa Horeb. Pag-abot nimo ruto, lampuse katong bato, ag maliwas kag tubi ruto pramas kag mga tawo ay makakainom.” Inghimo kali ni Moises sa atubangan it mga pinuno it mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kaling lugar ay gingtawag nida nak Masa ag Meriba. Kali ay dahil sa pagbasoy it mga Israelinhon kang Moises, ag sa inra pagpurba sa GINO-O tong sinra ay nagsiling, “Kaibahan baga nato kag GINO-O o buko?” ");
INSERT INTO bno_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Tong hagto pa kag mga Israelinhon sa Repidim, gingyusob sinra it usang lahi nak kag tawag ay Amaleknon. ");
INSERT INTO bno_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","It kato inggwa si Moises it usang saligan nak kag ngayan ay Josue. Ag ngasing ingsugo sida ni Moises, “Josue, magpili ka it pilang mga kayake ag ikaw kag magpamuno sa paglaban sa mga Amaleknon. Insulip sa inro paglaban, ako ay matinrog rahang baguntor nak hudot kag bakulo it Dios.” ");
INSERT INTO bno_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ingsunor ni Josue kag sugo ni Moises sa ida nak magpakiglaban sa mga Amaleknon. Ag sina Moises, Aaron ag usa pang saligan nak si Hur ay nagtukar rahang baguntor. ");
INSERT INTO bno_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Sa inra pagpakiglaban, habang kag mga damot ni Moises ay nakataas, nagraraog kag mga Israelinhon, pero pag nakababa ay nagraraog kag mga Amaleknon. ");
INSERT INTO bno_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Tong ingpilay kag mga damot ni Moises ay nagbaoy sina Aaron ag Hur it bato pramas ingkuran ni Moises. Ag ingtaas nina Aaron ag Hur kag ida mga damot. Si Hur ay sa usang damot ag si Aaron ay sa usa. Kada kag mga damot ni Moises ay padayon nak nakataas hastang sa pagsugbo it adlaw. ");
INSERT INTO bno_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ngani, napirdi nina Josue kag mga sundalo it mga Amaleknon. ");
INSERT INTO bno_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Pagkatapos, nagsiling kag GINO-O kang Moises, “Suyatan kaling natabo agor indi ninro malimutan. Ag paayaman kali kang Josue dahil awagiton nak gador Nako kag mga Amaleknon sa ibabaw it kalibutan.” ");
INSERT INTO bno_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kada, nagsug-on-sug-on si Moises it mga bato bilang altar sa GINO-O, nak ida ingtawag nak “Kag GINO-O kag Ako Bandera it Pagraog.” ");
INSERT INTO bno_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Siling nida sa mga tawo, “Tas-an kag bandera it GINO-O! Kag GINO-O kag padayon nak malaban sa mga Amaleknon hastang sa paabutong balhin it inra mga lahi.” ");
INSERT INTO bno_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ngasing, si Jetro nak saserdote it Midian nak imaw kag panugangan ni Moises, ay nakarungog it tanang ginghimo it Dios para kana Moises, pati sa ida katawuhan nak Israelinhon. Narunggan ra nida kung pauno gingliwas it GINO-O kag mga Israelinhon sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","It kato gingpapauli anay ni Moises kag ida asawa nak si Zipora kaibahan it ida ruhang anak nak kayake, kada si Jetro kag nagrepara sa inra. ");
INSERT INTO bno_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Kag panganay nak anak ni Moises ay gingpangayanan nak Gersom, dahil kag ida gingsiling ay, “Ako ay buko taga-rili.” ");
INSERT INTO bno_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ag kag ngayan it ida pangruhang anak ay si Eliezer, dahil kag ida gingsiling ay, “Kag Dios it ako tatay ay imaw it nagtabang sa ako. Gingsalbar Nida ako sa planong pagmatay sa ako ni Paraon.” ");
INSERT INTO bno_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Kada ngasing, gingnunot ni Jetro kag asawa ni Moises, nak imaw kag ida anak nak si Zipora ag kag ida ruhang apo, sa mabatong mga bukir sa puno it baguntor it Dios, kung hariin gikakampo sina Moises. ");
INSERT INTO bno_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Gingpaabot ni Jetro kang Moises nak, “Maabotey kag imo panugangan, kaibahan kag imo asawa ag ruhang anak.” ");
INSERT INTO bno_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Pagkasador kali ni Moises, gingsapoy-sapoy nida sinra ag nag-amin anay bag-o gingharuan kag ida panugangan. Nagpangamustahan sinra ag nagsuyorey sinra sa tolda ni Moises. ");
INSERT INTO bno_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Masunor, gingsiling ni Moises sa ida panugangan kag tanang inghimo it GINO-O kang Paraon ag sa mga Ehiptohanon, alang-alang sa mga Israelinhon. Gingsiling ra nida kag tanang hirap nak inra narayanan sa inra pagpanaw, ag kung pauno gingtabangan sinra it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nasadyahan si Jetro nak narunggan kag tungor sa tanang kaaduhan nak ginghimo it GINO-O sa mga Israelinhon sa pagsalbar Nida sa inra halin sa mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Siling ni Jetro, “Dayawon kag GINO-O nak nagsalbar sa imo ag sa tanang Israelinhon halin sa mga Ehiptohanon ag kang Paraon. Dayawon Sida nak imaw kag nagsalbar sa inro halin sa pagkaulipon it mga Ehiptohanon. ");
INSERT INTO bno_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ngasing ayamey nako nak kag GINO-O ay yabaw pa sa tanang ibang mga dios, dahil sa Ida ginghimo sa mga Ehiptohanon tong ging-ihig ninra kamong Ida mga katawuhan.” ");
INSERT INTO bno_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Masunor, nagbaoy si Jetro it usang hadop nak ing-ihaw ag ingsunog bilang inughalar sa Dios, pati kag iba pang mga inughalar. Ag nagsuor si Aaron kaibahan it tanang mga pinuno it mga Israelinhon, pramas magkaon it tinapay kaibahan kag panugangan ni Moises, sa atubangan it Dios. ");
INSERT INTO bno_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Pagkaaga, nag-ingkor si Moises bilang manughusgar sa mga tawo. Nakapalibot sa ida kag mga tawo tuna aga hastang gab-i. ");
INSERT INTO bno_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Pagkakita ni Jetro nak ida panugangan it tanang ginghihimo ni Moises para sa mga tawo, napasiling sida, “Ni-o kaling imo ginghihimo para sa mga tawo? Asing ausa yang ikaw nak naghuhusgar para sa tanan, habang nakapalibot kag mga tawo sa imo tuna aga hastang maggab-i?” ");
INSERT INTO bno_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Nagsabat si Moises sa ida panugangan, “Pauno nganing nagpapayungot sinra sa ako agor ayamon kag kabubut-on it Dios? ");
INSERT INTO bno_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Pag inggwa't ruhang indi magkaintyendihan, nagpapayungot sinra sa ako, ag ako gingsisiling sa inra kung si-o kag di sala. Usa pa, ako gingpapahadag sa inra kag mga tugon ag mga sugo it Dios.” ");
INSERT INTO bno_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Siling sa ida ni Jetro, “Kaling imo ginghihimo ay buko tama. ");
INSERT INTO bno_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Imo gingpapahirapan kag imo sarili, pati kaling mga tawo. Abang bug-at kali para sa imo ag indi nimo kali kaya it ikaw yang. ");
INSERT INTO bno_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Runggi kaling ako ilaygay sa imo, ag kabay pang buligan ka it Dios! Maado kung ikaw kag matinrog sa atubangan it Dios para sa mga tawo, ag ikaw kag maraya it inra mga problema sa Ida. ");
INSERT INTO bno_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ikaw ra kag matudlo sa inra it mga tugon ag kabubut-on it Dios, pati ra kag pagpasador sa inra kung pauno magpangabuhi it tadlong ag magtuman kung ni-o kag tama. ");
INSERT INTO bno_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","“Pero sa tanang katawuhan magpili ka it mga kayaking inggwa't kakayahan, inggwa't kahadlok sa Dios, mga kayaking masasaligan ag indi masuhuyan. Imaw sinra kag imo ibutang nak mapamuno sa mga tawo, usang mapamuno para sa linibo, usa para sa ginatos, usa para sa singkwenta, ag usa para sa sampuyo yang. ");
INSERT INTO bno_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Sinra kag perming maareglo sa mga kaso it ida sinakupan. Pero sugu-a sinra nak ray-on katong mga kasong mabug-at sa imo. Pabad-e sinrang aregluhon katong mga kasong magaan pramas maghagan-hagan kag imo gingraraya, ag parayan rili mabubuligan ka ninra. ");
INSERT INTO bno_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Pag tuyar kali kag imo ahimuon, ag imaw kag sugo it Dios sa imo, indi ka masyarong mahirapan, ag kag mga tawo ay mapauli nak hanuyos kag isip.” ");
INSERT INTO bno_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Gingrunggan ni Moises kaling laygay it ida panugangan ag kaling tanan ay ida ingsunor. ");
INSERT INTO bno_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Nagpili matuor sida it mga kayaking inggwa't kakayahan halin sa tanang Israelinhon, ag ingbutang nida nak mga manug-areglo sa problema it mga tawo, usang mapamuno sa linibo, usa sa ginatos, usa sa singkwenta, ag usa sa sampuyo. ");
INSERT INTO bno_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Sinra kag perming manug-areglo sa problema it mga tawo. Kag mga mabug-at nak kaso yang kag inra gingraraya kang Moises, pero kag mga magaan ay sinra kag nag-aareglo. ");
INSERT INTO bno_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Pagkatapos, ginghator ni Moises kag ida panugangan sa rayan papauli sa ida sariling banwa. ");
INSERT INTO bno_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Pagkalipas it ruhang buyan it inra pagliwas sa Ehipto, ay nakaabot kag mga Israelinhon sa mabatong mga bukir it Sinay. Katong adlaw rang kato, naghalin sinra sa Repidim ag ruto sinra nagkampo sa atubangan it Baguntor it Sinay. ");
INSERT INTO bno_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Masunor, nagtukar si Moises rutong baguntor agor magpakigkita sa Dios. Ag sida ay ingtawag it GINO-O halin sa tumbo it baguntor nak nagsiling, “Imaw kali kag imo ibisaya sa mga inanak ni Jacob, nak mga Israelinhon. Silinggan sa inra, ");
INSERT INTO bno_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“ ‘Nakita nak gador ninro kag Ako ginghimo sa mga Ehiptohanon ag kung pauno gingkaluy-an Nako kamo ag gingraya rili, tuyar sa pagripara it usang agila sa ida isiw. ");
INSERT INTO bno_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ngasing, kung asunron yang ninro Ako ag indi gisuwayon kag Ako ahimuong kasugtanan sa inro, kamo ay Ako magiging palanggang pinili halin sa tanang katawuhan. Matuor nak kag tanang nasyon sa kalibutan ay Ako, ");
INSERT INTO bno_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","pero kamong tanan ay ahimuon Nakong lahi it mga saserdote nak maserbisyo sa Ako. Ag kamo ra kag nasyon nak Ako agahinon agor tumanon kag Ako kabubut-on.’ Imaw kali kag imo ibisaya sa mga Israelinhon.” ");
INSERT INTO bno_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ngani, nagbalik si Moises ag ida ingtipon kag mga pinuno it mga Israelinhon, ag ingsiling sa inra kag tanang gingsugo it GINO-O sa ida. ");
INSERT INTO bno_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Pagkarungog kali it mga tawo, nagkausa sinra, “Tanang gingbisaya it GINO-O ay amo atumanon.” Kada nagbalik si Moises sa GINO-O raya kag sabat it mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nagsiling kag GINO-O sa ida, “Mapakigkita ray Ako sa imo hina sa maramoy nak rampog, agor marunggan it mga tawo nak nagbibisaya Ako sa imo, kada perming mapati sinra sa imo.” Bag-o ingsiling ni Moises sa GINO-O kag sabat it mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Masunor, nagsiling kag GINO-O kang Moises, “Pagtu-e kag mga tawo, ag silinggon nak humanon nak limpyo kag inra sarili ngasing nak adlaw ag insulip, agor sa masunor nak adlaw ay hanraey nak magdayaw sa Ako. Ag kinahangyan ra nak bunakan ninra kag inra mga yamit. ");
INSERT INTO bno_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Pag-abot it pangtatlong adlaw, dapat ay hanraey sinrang tanan dahil sa adlaw nak kato, Ako nak imaw kag GINO-O ay mababa sa Baguntor it Sinay sa atubangan it tanang mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","“Kinahangyan nak butangan it giryunan sa palibot it baguntor, ag silinggan sinra nak, ‘Mag-andam nganat kamo nak indi magyaktaw sa giryunan dahil bawal nak magdama sa baguntor. Kung magyaktaw nganat kamo, kamo ay dapat matyon. ");
INSERT INTO bno_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kag tawo nak mayaktaw raha ay dapat nak bungguon hastang mamatay o panaon, dahil bawal nak sapliron sida. Tuyar kag ahimuon, maging tawo man o hadop man. Indiey sida mabuhi.’ Pag inro narunggan kag makusog nak budyong, imaw pa yang kag inro pagpayungot sa puno it baguntor.” ");
INSERT INTO bno_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Pagkaus-os ni Moises sa baguntor, gingsugo nida kag mga tawo nak himuong limpyo kag inra sarili agor magdayaw sa Dios, ag gingpabunakan ra kag inra mga yamit. ");
INSERT INTO bno_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Bag-o ingsilinggan nida kag mga tawo, “Ihanra ninro kag inro sarili para sa usa pang adlaw. Waya anay it maubay sa inro mga asawa.” ");
INSERT INTO bno_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Pagkaaga sa paglipas it ruhang adlaw, nagpangrayugrog ag nagpakapangilat hina sa maramoy nak rampog nak nagtabon sa baguntor, ag narunggan ra ninra kag abang kusog nak budyong. Tanang tawo nak asa kampo ay nagpinanguyog. ");
INSERT INTO bno_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ag gingpangunahan ni Moises kag tanang tawo paliwas sa kampo agor magpakigkita sa Dios. Pag-abot ninra sa puno it baguntor nagtininrog sinra. ");
INSERT INTO bno_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Kag Baguntor it Sinay ay nalibon it aso dahil kag GINO-O ay nagbaba ruto ag nagpakita parayan sa kayado. Nagpaibabaw kag karuramoy nak aso nak pay naghahalin sa marakong pugon, ag kag baguntor ay naglinog it abang kusog ");
INSERT INTO bno_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","habang kag budyong ay nagpakakusog pa. Masunor, nagbisaya si Moises, ag gingsabat sida it Dios parayan sa pangrayugrog. ");
INSERT INTO bno_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Nagbaba kag GINO-O halin sa tumbo it Baguntor it Sinay, ag ing-ayaba si Moises nak magtukar ruto, kada nagtukar sida. ");
INSERT INTO bno_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Pag-abot nida ruto, nagsiling sa ida kag GINO-O, “Os-os ruto, ag paandaman kag mga tawo nak indi magpilit nak maglampas sa giriyunan dahil yang sa gustong makita ninra Ako, sabaling maramo kag mamamatay. ");
INSERT INTO bno_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Aber ra kag mga saserdote nak mapayungot sa Ako ay kinahangyan nak himuon anay nak limpyo kag inra sarili, dahil kung indi, aparusahan Nako sinra.” ");
INSERT INTO bno_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Nagsabat si Moises sa GINO-O, “Indi makatukar kag mga tawo rili sa Baguntor it Sinay kumo Ikaw mismo kag nagpaandam sa amo nak, ‘Butangan it giryunan sa palibot it baguntor ag gahinon kali nak balaan.’ ” ");
INSERT INTO bno_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Nagsiling kag GINO-O, “Os-os ray ag ray-on si Aaron patukar rili. Pero paandame kag mga saserdote ag kag mga tawo nak indi dapat magpilit nak maglampas sa giryunan dahil yang sa gustong makita ninra Ako, sabaling aparusahan Nako sinra.” ");
INSERT INTO bno_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ngani, nag-us-os matuor si Moises pabalik sa mga tawo ag ingsilinggan sinra. ");
INSERT INTO bno_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kali kag tanan nak gingbisaya it Dios: ");
INSERT INTO bno_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ako kag GINO-O nak inro Dios, nak imaw kag naghaw-as sa inro sa Ehipto, kung hariin kamo ay ging-ulipon.” ");
INSERT INTO bno_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Indi kamo dapat magdayaw sa ibang mga dios. Ako yang kag inro adayawon.” ");
INSERT INTO bno_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Indi kamo dapat maghimo it mga ribulto para sa inro sarili, nak kahitsura it aber niong butang raha sa langit, raha sa kalibutan, o raha sa katubian.” ");
INSERT INTO bno_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","“Indi kamo dapat magyuhor ag magdayaw sa inra, dahil Ako kag GINO-O nak inro Dios ay waya gustong inggwa pa kamo it ibang dios puyra sa Ako. Aparusahan Nako kag mga nakakasala sa Ako hastang sa ika-tatlo ag sa ika-ap-at nak henerasyon. ");
INSERT INTO bno_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pero para sa tawong nagpapalangga sa Ako ag nagsusunor it Ako mga kasuguan, ay ipakita Nako sa ida kag Ako rakong pagpalangga hastang sa linibo nak henerasyon.” ");
INSERT INTO bno_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Indi ninro dapat sambiton sa waya't puyos kag Ako pangayan nak GINO-O nak imaw kag inro Dios, dahil Ako aparusahan kag sin-o man nak magamit it Ako pangayan sa waya't puyos nak butang.” ");
INSERT INTO bno_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Rumroma ninro kag Adlaw it Inugpahuway ag gahinon para sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sa suyor it an-om nak adlaw puyde kamo nak magtrabaho. ");
INSERT INTO bno_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Pero sa pangpitong adlaw gahinon kali para sa Ako, nak imaw kag GINO-O nak inro Dios, dahil imaw kali kag Adlaw it Inugpahuway. Bawal magtrabaho sa adlaw nak kina, ikaw ag kag imo mga anak nak kayake ag kabade, kag imo mga suguon nak kayake ag kabade, kag imo mga kahadupan, pati kag mga nagdadayon sa inro. ");
INSERT INTO bno_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kali ay dahil sa suyor it an-om nak adlaw, Ako nak imaw kag GINO-O, kag nagtuga it langit ag duta, ragat, ag tanang rahina. Pero sa pangpitong adlaw Ako ay nagtungon it pagtuga ag nagpahuway, kada gingpakamaado Nako kag Adlaw it Inugpahuway ag ginggahin kali para sa balaan nak katuyuan.” ");
INSERT INTO bno_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Tahura kag inro tatay ag nanay, agor mapangabuhi kamo it mayawig sa duta nak ita-o Nako sa inro, Ako kag GINO-O nak imaw kag inro Dios.” ");
INSERT INTO bno_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Indi kamo magpangmatay.” ");
INSERT INTO bno_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Indi kamo magpangawatan.” ");
INSERT INTO bno_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Indi kamo magpanakaw.” ");
INSERT INTO bno_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Indi kamo magtestigo it binakak laban sa inro isigkatawo.” ");
INSERT INTO bno_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Indi kamo maghingabot sa bayay it inro isigkatawo. Bawal ra maghingabot sa asawa it inro isigkatawo, o sa inra mga suguon nak kayake o kabade, o sa inra baka ag asno, o sa aber niong butang it inro isigkatawo.” ");
INSERT INTO bno_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tong marunggan it mga tawo kag pangrayugrog ag budyong, ag tong makita ninra kag pangilat ag pay nag-aaso kag baguntor, nagpinanguyog sinra dahil sa kahadlok habang nagtitininrog sa mayado-yado. ");
INSERT INTO bno_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ag nagsiling kag mga tawo kang Moises, “Ikaw yangey kag magbisaya sa amo ag mapanimati kami, buko kag Dios sabaling mamatay kami.” ");
INSERT INTO bno_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Nagsabat si Moises sa mga tawo, “Aya kamo gikahadlok, gingpupurbahan yang kamo it Dios. Ginghimo kali it Dios agor magkakainggwa kamo it kahadlok sa Ida pramas indi kamo makasala.” ");
INSERT INTO bno_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ngani, nagpabilin kag mga tawo sa mayado-yado habang si Moises ay nagpayungot ray sa maitom nak rampog kung hariin kag Dios. ");
INSERT INTO bno_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Masunor, nagsiling kag GINO-O kang Moises, “Imaw kali kag imo isiling sa mga Israelinhon, ‘Nakita mismo ninro nak nagbisaya Ako halin sa langit. ");
INSERT INTO bno_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Indi kamo dapat maghimo it mga dios-diosan, nak human sa pilak o buyawan, nak inro adayawon tuyar sa inro pagdayaw sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Kag inro dapat ahimuon ay magtumpok it raga bilang altar para sa Ako. Rili kamo mahalar it inro mga ingmatay nak mga karnero, kambing ag baka, nak asunugon para sa pagpatawar it inro mga sala, ag imaw ra para sa pagpasag-uli ninro sa Dios. Aber riing lugar nak Ako itudlo sa inro, ruto ninro Ako adayawon, ag apakamaaduhon Nako kamo. ");
INSERT INTO bno_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ag kung magsug-on-sug-on kamo it bato bilang altar para sa Ako, aya ninro gikurtihe. Kung himuon ninro kina, kag altar ay indi dapat nak gamiton para sa pagdayaw sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Indi kamo maghuman it mataas nak altar nak kinahangyan pangsakaon pramas indi kamo masil-ipan.’ ” ");
INSERT INTO bno_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Imaw kali kag ibang mga kasuguan nak gingsiling it GINO-O kang Moises para sa mga Israelinhon: ");
INSERT INTO bno_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Kung kag usang tawo ay mabakay it ulipon nak halin sa inro lahing Hebreo, kali ay maserbisyo sa ida sa sakop it an-om nak tuig. Pero pag-abot it pangpitong tuig, makakahaliney sida aber indiey igtubson. ");
INSERT INTO bno_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kung sida ay ingbakay nak waya't asawa, mahalin sidang waya't asawa ra. Kung sida ay ingbakay nak di asaway, mahalin sidang kaibahan kag ida asawa. ");
INSERT INTO bno_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kung sa ida pagkaulipon, sida ay gingtaw-an it asawa it ida amo ag sinra ay nagkainggwa't mga anak, kag ida asawa ag mga anak ay para sa ida amo. Sida yang nak usa kag makakahalin. ");
INSERT INTO bno_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Ugaling kung wayaey sida't gustong maghalin dahil palangga nida kag ida amo, ida asawa ag ida mga anak, ");
INSERT INTO bno_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","dapat nak ray-on sida it ida amo sa mga husgado. Masunor, inunot sida sa pwertahan o sa hamba it ida bayay ag atusukon it ida amo kag ida talinga. Kada sida ay maserbisyo sa ida amo habang sida ay buhi. ");
INSERT INTO bno_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Kung kag anak nak kabade ay ingbaligya it ida tatay bilang ulipon, indiey kali makahalin tuyar sa mga ulipon nak kayake. ");
INSERT INTO bno_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Pero kung sida ay ging-asawa it ida amo ag wayaey nasasadyahe kag ida amo sa ida, dapat kali ay ipatubos sa ida pamilya. Dahil waya't karapatan kag ida amo nak ibaligya sida sa ibang lahi, kumo kag amo mismo kag nagtalikor sa ida. ");
INSERT INTO bno_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kung kag kabade ay ingbakay bilang asawa para sa anak it amo, dapat ay ita-o sa ida kag pribilehiyo bilang usang matuor nak anak. ");
INSERT INTO bno_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“Kung kaling anak nak kayake ay mag-asawa ray it iba, kaling ida unang asawa ay indi dapat pabad-an sa pagkaon, pagyamit ag iba pang mga bagay nak karapatan it usang asawa. ");
INSERT INTO bno_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kung kaling tatlong obligasyon ay indi nida gituparon, kag kabade ay puyding maghalin nak indiey dapat pangtubuson.” ");
INSERT INTO bno_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Sin-o man kag magpanghapros ag magpangmatay sa ida isigkatawo ay dapat nak mamatay ra. ");
INSERT INTO bno_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ugaling, kung waya nida gihungra o waya giplanuha kaling pagpangmatay, pero gingtugutan it Dios nak kali ay matabo, kaling nakamatay ay puyding magrayagan ag ruto magtago anay sa lugar nak itudlo sa inro it Dios bilang rayaganan it mga nakakasala. ");
INSERT INTO bno_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Pero kung kag pagmatay ay inghungor, aber sa altar pa sida magrayagan ay arakpon gihapon sida ag amatyon. ");
INSERT INTO bno_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Sin-o man kag maglaban sa ida tatay o nanay parayan sa ida kusog ay dapat mamatay. ");
INSERT INTO bno_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Sin-o man kag magbaoy it pilit sa ida isigkatawo ay dapat sidang rakpon ag matyon, aber ingbaligyaey nida kato o hina pa sa ida. ");
INSERT INTO bno_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Sin-o man kag magsumpa sa ida tatay o nanay ay dapat mamatay. ");
INSERT INTO bno_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Sin-o man kag magpangsuntok o maggamit it bato sa inra pag-away ay indi dapat parusahan kung kag ingsuntok o inggamitan it bato ay waya namatay kundi naulian. Dapat nak ipakita nak sida ay naulian parayan sa pagliwas nida it bayay nak nakabakulo. Ugaling kung marugay sida nak naghigra, sida ay dapat nak riparahon it katong nakasuntok o nakabunggo, ag abadaran pa kag atraso sa panahon nak waya kali nakatrabaho. ");
INSERT INTO bno_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Kung ingbakoy it amo kag ida ulipong kayake o kabade, ag kali ay namatay sa nak raan, ay dapat nak parusahan sida. ");
INSERT INTO bno_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ugaling kung kag ulipon ay waya namatay, kundi pagkalipas it usa o ruhang adlaw sida ay naulian, kaling amo ay indi giparusahan dahil ida propriyedad katong ulipon. ");
INSERT INTO bno_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Kung nag-away kag ruhang kayake ag sinra ay nakabangga it sabak, ag kaling sabak ay naagasan pero waya namatay, dapat nak katong kayake nak nakabangga sa ida ay apabadaron kumporme sa ahagaron sa ida it asawa it katong kabade, ag kumporme sa piyansa it husgado. ");
INSERT INTO bno_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero kung namatay sida, dapat nak parusahan katong nakabangga sa ida. Kag kabadaran ay kabuhi sa kabuhi, ");
INSERT INTO bno_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mata sa mata, ngisi sa ngisi, damot sa damot, siki sa siki, ");
INSERT INTO bno_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","paso sa paso, ugar sa ugar, ag yabhag sa yabhag. ");
INSERT INTO bno_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Kung inghapros it amo kag ida ulipon nak kayake o kabade ag kali ay nabulag, kaling ulipon ay dapat yangey nak pabad-an nak makahalin bilang kabadaran sa ida mata. ");
INSERT INTO bno_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Imaw ra kung kag ida ulipon ay nabingawan, dapat yangey nak ida kali pabad-an nak makahalin bilang kabadaran sa ida ngisi. ");
INSERT INTO bno_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kung kag baka ay nagpanungki it tawo nak kayake o kabade, ag kaling tawo ay namatay, dapat kag baka ay abungguon hastang mamatay, ag kag ida karne ay indi puyding kaunon. Pero kag tag-iya ay wayaey it salabtanon. ");
INSERT INTO bno_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","“Ugaling kung kaling baka ay dating nagpapanungkiey, ag aber kag tag-iya ay naabisuhaney, pero waya gihapon sa ida buot nak ikulong, ag kali ay nakamatay ray it kayake o kabade, kag tag-iya ay dapat nak mamatay ra pagkatapos it matay sa baka. ");
INSERT INTO bno_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ugaling kung sida ay apabadaron yangey para rutong kabuhi, puyde nidang tubuson kag ida kabuhi kumporme sa halagang asukton sa ida, ag indiey sida gimatyon. ");
INSERT INTO bno_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Imaw ra kag ahimuon bilang basihan para sa tag-iya, kung anak nak kayake o kabade kag ingsungki it ida alagang baka ag namatay. ");
INSERT INTO bno_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kung ulipon nak kayake o kabade kag ingsungki it baka ag namatay, kag tag-iya it baka ay dapat nak magbadar rutong amo it ulipon it treyntang bilog nak pilak, ag kag baka ay dapat nak bungguon hastang mamatay. ");
INSERT INTO bno_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","34","“Kung inggwa't tawong nagbaoy it takyob sa buho o bal-ong, o nagkutkot it buho o bal-ong ag waya kali nida gitabuni, tapos inggwa't nahuyog ruto nak baka o asno, kag nahuyog nak hadop ay dapat nak badaran it tag-iya it bal-ong. Ag katong nahuyog nak hadop ay iday. ");
INSERT INTO bno_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Kung kag baka ay nakapanungki it baka it ibang tawo ag kali ay namatay, dapat nak ibaligya ninra kag buhing baka ag inra apartihon kag binta. Ag maparti ra sinra sa karne it katong bakang namatay. ");
INSERT INTO bno_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","“Ugaling kung kaling baka ay dating nagpapanungkiey, ag waya gihapon gikulunga it tag-iya, sida ay dapat nak magbadar it baka sa tag-iya it namatayan. Ag kaling namatay nak hadop ay iday.” ");
INSERT INTO bno_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","4","“Kung kag usang tawo ay nagpanakaw it baka o karnero, agor ihawon o ibaligya, dapat ida kali abadaran it lima para sa usang baka, ag ap-at para sa usang karnero. Kag mananakaw ay kinahangyang magbadar. Kung waya sida it ibadar, dapat ay sida kag ibaligya ag kag binta ay imaw it ibadar, o kung buko man tuyar ay sida kag ibadar. Kung kag ingtakaw nak hadop ay makita sa ida nak buhi pa, baka man, asno o karnero, dapat ay duble kag ida ibadar.” “Ag kung kag mananakaw ay naabutan sa gab-i nak nagsuyor sa usang bayay, ag sida ay ingpukoy ag namatay, waya't salabtanon kag nakamatay sa ida. Pero kung kag pagkamatay ay natabo sa adlaw, inggwa't salabtanon kag nakamatay sa ida.” ");
INSERT INTO bno_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Kung kag usang tawo ay nagpapasabsab it ida kahadupan sa bukir o sa ubasan, ag kaling ida hadop ay nakabuhi ag nakasabsab sa uma it ibang tawo, dapat sida nak magbadar para rutong nasira it ida hadop. Kag ida ibadar ay katong pinaka-maado sa ida panubas halin sa ida uma o sa ubasan.” ");
INSERT INTO bno_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Kung inggwa't nagpanuga it mga likot sa palibot it ida mga tanom ag kag kayado ay nagkamang papagto sa tanom it iba, sida ay inggwa it salabtanon sa nasunugan. Sida ay dapat magbadar para sa kalugihan it katong nasunugan kung kina man ay mga tanom, mga tanom nak nakatalapokey o mga tanom nak aanihoney.” ");
INSERT INTO bno_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Kung inggwa't tawo nak nagpatago it kwarta o ni-o mang mga kagamitan sa ida kayungot, ag kali ay natakaw sa inra bayay, apabadaron it duble katong narakop nak nagpanakaw. ");
INSERT INTO bno_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ugaling, kung waya narakop kag nagpanakaw, kag ingbilinan ay apasumpaon sa atubangan it Dios, pramas pamatuuran kung talagang sida o buko kag nag-atriber it katong ingpatago it ida kayungot.” ");
INSERT INTO bno_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Nahanungor sa mga butang nak ging-aagawan, tuyar sa baka, asno, karnero, mga yamit o ni-o mang butang nak nawagit, halimbawa, kung inggwa't ruhang tawo nak nagsisiling, ‘Ako kali,’ dapat aray-on ninrang ruha kaling inra kaso sa atubangan it Dios. Si-o man sa inra kag ahusgaran nak nakasala ay dapat magbadar it duble sa ida kayungot.” ");
INSERT INTO bno_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Kung inggwa't tawo nak nagpaalaga sa ida kayungot it asno, baka, karnero, o iba pang mga hadop, ag kali ay namatay, indi man ay napiang o ingtakaw nak waya't nakakita sa natabo, ");
INSERT INTO bno_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","kag inra kaso ay dapat ray-on sa atubangan it GINO-O, pramas pasumpaon kag nag-aalaga nak waya matuor sida giatriber sa hadop it ida kayungot. Kung matuor kali, kinahangyan nak mapapati nida kag tag-iya it kaling hadop agor waya sida it salabtanon. ");
INSERT INTO bno_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pero kung ingtakaw kag ida alagang hadop, dapat kato nidang badaran sa tag-iya. ");
INSERT INTO bno_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kung kali ay ingsiba it ilahas, dapat nidang ipakita kag natura, bilang ebidensya, agor waya sida it abadaran sa tag-iya.” ");
INSERT INTO bno_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Kung kag usang tawo ay nagpanghuyam it hadop sa ida kayungot ag kali ay napiang o namatay nak waya nakita it tag-iya, dapat badaran kali it naghuyam. ");
INSERT INTO bno_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pero kung rahagto kag tag-iya, indiey kinahangyan nak kali ay badaran it naghuyam. Pero kung kag hadop ay gingpiplitihan, katong plite kag kabadaran para sa natabo sa hadop. ");
INSERT INTO bno_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Kung kag usang rayaga, nak waya pa't nagpapangasawa, ay narayhan ag inubayan it usang binata, dapat sida ay apakasayan it katong kayake, ag ita-o it katong kayake ni-o man kag ahagaron sa ida it mga maguyang it katong kabade. ");
INSERT INTO bno_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Pero kung kag tatay it katong rayaga ay indi magsugot nak ipakasay, dapat nak ita-o gihapon it katong kayake sa tatay it kabade kag halagang ahagaron nida bilang danyos. ");
INSERT INTO bno_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Kag mga amulitan nak tawo ay indi dapat pasugtan nak magpangabuhi kundi dapat nak mamatay. ");
INSERT INTO bno_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Sin-o man kag mag-ubay sa hadop ay dapat nak mamatay. ");
INSERT INTO bno_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Sin-o man kag maghalar sa ibang dios ay dapat nak mamatay dahil sa GINO-O yang dapat maghalar. ");
INSERT INTO bno_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Indi ninro gipintasan o giihigon kag mga tawong dayo yang sa inro. Rumruma ninro nak kamo ra ay dating mga dayo sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Indi ninro giihigon kag mga kabading balo o mga ilo. ");
INSERT INTO bno_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kung sinra ay inro aihigon ag mag-ayaba sinra sa Ako, siguradong Ako sinra arunggan. ");
INSERT INTO bno_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Dahil rili, kag Ako kahangit ay iparanas sa inro ag amatyon kamo Nako parayan sa gera. Kada kag inro mga asawa ay mababalo ra, ag kag inro ra mga anak ay maiilo sa tatay. ");
INSERT INTO bno_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Kung nag-uutang sa inro kag inro kasimanwa nak pobre, indi ninro sinra gipatubuan tuyar sa ginghihimo it mga nagpapatubo it subra. ");
INSERT INTO bno_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kung inggwa sa inro mga kayungot it nagprinda it ida alimungmong, inro kali dapat iuli bag-o magsugbo kag adlaw, ");
INSERT INTO bno_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","dahil imaw yang kato kag ida pangyamig. Ag ni-o kag ida itamong pag sida ay magkatuyog? Ag pag sida ay mag-ayaba sa Ako, Ako sida arunggan dahil Ako ay maluluy-on.” ");
INSERT INTO bno_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Indi ninro gipasipalahan kag Dios, o sumpaon kag pinuno ninro. ");
INSERT INTO bno_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Aya ninro gilimti nak maghalar halin sa inro mga tubas nak uyas ag ubasan. “Ihalar ninro sa Dios kag tanang inro panganay nak anak nak kayake. ");
INSERT INTO bno_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Imaw ra kag inro mga baka ag karnero. Indi anay ninro giutayon sa nanay hastang sa pangpitong adlaw. Sa pangwayong adlaw inro'y kali ita-o sa Dios. ");
INSERT INTO bno_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Inro agahinon kag inro sarili para sa balaan nak katuyuan it Dios. Ngani, indi kamo magkaon it karne nak ingsiba it ilahas, ag pabad-e yangey nak kaunon kina it mga iro.” ");
INSERT INTO bno_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Padayon kaling ibang mga kasuguan nak gingsiling it GINO-O kang Moises para sa mga Israelinhon: “Indi kamo magpanira it inro isigkatawo. Indi kamo magbinakak sa pagtestigo para yang apinan kag usang tawo nak imaw kag nakasala.” ");
INSERT INTO bno_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Indi kamo magparaya-raya sa karamuan sa paghimo it mayain. Pag magtestigo kamo, indi ra magparaya-raya sa karamuan agor balion kag hustisya. ");
INSERT INTO bno_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Pero indi ra ninro giapinan kag makasal-anan nak pobre sa inra kaso dahil sa inro kaluoy yang sa inra kumo sinra ay pobre.” ");
INSERT INTO bno_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kung imo nakita kag baka o asno it aber imo kaaway nak nakabuhi, ray-a kali sa ida ag iuli. ");
INSERT INTO bno_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“Kung imo nakita kag asno it tawong hangit sa imo, nak nayupog dahil sa bug-at it ida raya, aya yang gilipase, buligi ninro kag tag-iya nak bangunon kali.” ");
INSERT INTO bno_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Aya ninro giisnaki it hustisya kag mga pobre sa inra kaso. ");
INSERT INTO bno_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Aya kamo gipang-akusar kung buko klaro, ag indi ninro gihusgaran it kamatayon kag mga waya't sala dahil aparusahan it Dios kag mahimo it kina.” ");
INSERT INTO bno_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Indi kamo magbaton it lagay dahil kag lagay ay imaw it nagbubulag aber sa mga tawong tadlong, ag ingbabaliktar kag bisaya it mga matarong.” ");
INSERT INTO bno_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Indi ninro giihigon kag mga dayo yang. Narayananey ninro kag kahimtangan it usang dayo dahil dati kamo ay mga dayo yang ra sa lugar it Ehipto.” ");
INSERT INTO bno_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Siling pa it Dios, “Sa sakop it an-om nak tuig atamnan ninro kag inro duta ag maani kamo. ");
INSERT INTO bno_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Pero pag-abot it pangpitong tuig, inro kali apahuwayan it tanom ag indi ra ninro gianihon kag ni-o mang nagtutubo uli nak tubo ruto. Kato ay para sa inro mga kasimanwang mahirap. Ag kag matutura ay inro yangey ipahinungor sa mga ilahas. Imaw ra kag inro ahimuon sa inro mga ubasan ag mga nagpapamungang olibo. ");
INSERT INTO bno_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“An-om nak adlaw kamong matrabaho, pero sa pangpito, indi kamo magtrabaho, agor kag inro mga baka ag asno ay makapahuway ra, pati kag inro mga ulipon nak natawo sa inro panimayay, ag kag mga dayo ay makapahuway ra. ");
INSERT INTO bno_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Magrahan sa pagsunor sa tanang Ako gingbisaya sa inro. Ag aya kamo gipangamuyo sa ibang mga dios o taw-an sinra it balor aber sa inro pagbisaya.” ");
INSERT INTO bno_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Nagsugo kag Dios, “Tatlong beses sa usang tuig ninrong arumrumon Ako sa pista. ");
INSERT INTO bno_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Una, ihanra ninro kag Pista it Tinapay nak Waya't Pangpaalsa kumporme sa Ako sugo. Sa suyor it pitong adlaw, puyde kamong magkaon it tinapay, pero katong waya't pangpaalsa. Kali ay inro ahimuon sa gingterminong adlaw sa unang buyan it Abib, dahil imaw kato kag buyan it inro paghalin sa Ehipto. “Waya't maatubang sa Ako nak waya't rayang ihalar. ");
INSERT INTO bno_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Pangruha, ihanra ninro kag Pista it Pag-ani, bawat mag-ani kamo it unang bunga it inro tanom. “Pangtatlo, ihanra ninro kag Pista it Pagpu-po bawat huling parti it tuig, pag tigpu-po it ubas ag mga bunga it inro mga prutas. ");
INSERT INTO bno_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Tatlong beses sa usang tuig kag inro tanang kayake ay dapat mag-atubang sa Ako, nak imaw kag GINO-O nak Dios. ");
INSERT INTO bno_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Indi ninro giibhan it tinapay nak inggwa't pangpaalsa kag rugo ag hadop nak inro ihalar para sa Ako. “Ag kag taba ay indi ra ninro gitura hastang sa aga. ");
INSERT INTO bno_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Aray-on ninro kag pinaka-maado ag unang produkto it inro duta sa bayay Nako, nak imaw kag GINO-O nak inro Dios. “Indi kamo magyuto it anak nak kambing nak waya pa nauutay sa gatas it guyang.” ");
INSERT INTO bno_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Siling pa it GINO-O kang Moises, “Maparaya Ako it anghel nak imaw it mauuna sa inro. Sida kag mabantay sa inro sa pagpanaw, ag maraya sa inro sa lugar nak Ako ing-aman. ");
INSERT INTO bno_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Inro sida apatihan ag asunron kag tanang ida isiling sa inro. Indi ninro gikuntrahon kinang anghel dahil indi kamo nida gipatawaron, kumo ingtaw-an Nako sida it kahigayunan nak ray-on kag Ako pangayan. ");
INSERT INTO bno_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Kung talagang inro asunron kag ida isiling ag atumanon kag Ako itugon sa inro, kag inro kaaway ay magiging kaaway ra Nako ag Ako kag malaban sa mga kalaban ninro. ");
INSERT INTO bno_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“Apamunuan kamo it Ako anghel ag aray-on papagto sa duta it mga Amornon, mga Hetanhon, mga Pereznon, mga Canaanhon, mga Hebinhon ag mga Jebusnon. Ag Ako sinra apangwagiton. ");
INSERT INTO bno_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Indi kamo magyuhor o magdayaw sa inra mga dios, o patuyaran kag inra mga ginghihimo. Dapat ninrong siraon kag inra mga dios-diosan ag siraon kag inra mga ribultong bato. ");
INSERT INTO bno_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Kag inro yang adayawon ay Ako, nak imaw kag GINO-O nak inro Dios. Ag kamo ra ay Ako abendisyunan it pagkaon ag tubi. Ako ra iyado kag sakit sa inro. ");
INSERT INTO bno_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ag waya it maaagasan o baog sa inro lahi. Imaw ra, apahabaon Nako kag inro kabuhi. ");
INSERT INTO bno_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Bag-o kamo makaabot sa usang lugar Ako iparaya kag rakong kahadlok sa mga nasyon nak inro aabutan, ag Ako alituhon kag inro mga kaaway, kada indi ninra maayaman kag inra ahimuon ag mapangyasihas sinra payado sa inro. ");
INSERT INTO bno_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Bag-o kamo makaabot ruto ipabatyagey Nako kag rakong kahadlok sa mga Hebinhon, mga Canaanhon ag mga Hetanhon nak inro mararayanan. ");
INSERT INTO bno_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Indi nak raan Nako sinra gitabugon sa suyor it usang tuig yang, sabaling kag duta ay mapabad-an ag magramo kag mga ilahas ruto. ");
INSERT INTO bno_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Inot-inot kag Ako pagtabog sa inra, hastang magramo kag inro mga anak nak sinray mismo kag maging tag-iya. ");
INSERT INTO bno_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Apaabuton Nako kag inro mga giryunan tuna sa Puyang Ragat sa bandang habagatan, papagto sa Ragat it mga Pilistinhon sa bandang sugbuhan, ag halin sa disyerto sa bandang subatan, papagto sa marakong Suba it Yuprates sa bandang amihan. Ako ipapirdi sa inro kag mga nag-iistar ruto ngasing ag inro sinra apangtabugon habang pasuyuron kamo ruto. ");
INSERT INTO bno_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Indi kamo maghimo it kasugtanan sa inra ag sa inra mga dios. ");
INSERT INTO bno_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Indi ra ninro sinra gipasugtan nak magpangabuhi nak kaibahan ninro ruto, sabaling maraya pa kamo sa pagpakasala laban sa Ako, dahil kag pagdayaw sa inra mga dios ay siguradong magiging dahilan it inro pagkasira.” ");
INSERT INTO bno_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Masunor, nagsiling kag GINO-O kang Moises, “Tukar ray liwat dili sa Ako sa baguntor, Ako nak imaw kag GINO-O. Nuntan sina Aaron ag ida ruhang anak nak sa Nadab ag Abihu, pati kag sitentang (70) mga pinuno it mga Israelinhon. Pag diley kamo, raha yang anay sinra sa mayado-yado pramas magdayaw sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ikaw yang Moises kag puyde nak magpayungot sa Ako, Ako nak imaw kag GINO-O, pero katong iba ay indi puyding magpayungot. Ag kag nabilin nak mga Israelinhon ay indi ra puyding magtukar rili sa Ako kaibahan ninro.” ");
INSERT INTO bno_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Pag-us-os ni Moises ingsiling nida sa mga tawo kag tanang gingtudlo ag gingsugo it GINO-O sa ida. Nagkausa sinra sa pagsabat, “Tanang gingsiling it GINO-O ay amo atumanon.” ");
INSERT INTO bno_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Bag-o gingsuyat ni Moises kag tanang ingbisaya it GINO-O. Pagkaaga, temprano pa sidang nagbati, ag nagpagto sa puno it baguntor pramas maghuman it altar. Nagpatinrog ra sida it doseng haliging bato bilang tanra it doseng lahi it mga inanak ni Israel nak ingtatawag rang Jacob. ");
INSERT INTO bno_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Pagkatapos, ingsugo nida kag ibang mga binata nak magraya sa altar it mga aihawon nak hadop nak asunugon, ag mga tureting turo nak amatyon ra bilang inughalar para sa pagpasag-uli ninra sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ingbaoy ni Moises kag katungang rugo ag ingbutang sa mga mayukong, ag kag katunga ay gingwisik sa altar. ");
INSERT INTO bno_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Masunor, ingbaoy nida kag Libro it Kasugtanan ag ingbasa it makusog sa mga tawo. Pagkabasa nida, nagkausa sinra sa pagsabat, “Tanang gingsiling it GINO-O ay amo asunron ag amo atumanon.” ");
INSERT INTO bno_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Pagkatapos, ingbaoy ni Moises kag mga mayukong nak inggwa't rugo ag ingwisikan kag mga tawo, sa pagsiling, “Kaling rugo kag pamatuor it Kasugtanan it GINO-O sa inro, kumporme sa mga bisayang inro narunggan.” ");
INSERT INTO bno_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Pagkatapos it kali, nagtukar matuor sina Moises ag Aaron, sa Nadab ag Abihu, pati kag sitentang pinuno it mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ruto, nakita ninra kag Dios it mga Israelinhon. Kag ida gingtutungtungan ay pay magandang alahas nak kag kulay ay asul ag mahadag nak tuyar sa langit. ");
INSERT INTO bno_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Pero waya't mayaing natabo sa mga pinuno it mga Israelinhon miskan nakita ninra kag Dios. Ag ruto sinra nagkaon ag nag-inom. ");
INSERT INTO bno_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nagsugo ray kag GINO-O kang Moises, “Tukar papali sa Ako sa tumbo it baguntor ag magrugay anay ikaw rili. Ag Ako ita-o sa imo kag ruhang mayapar nak bato, kung hariin ingsuyat Nako kag mga tugon ag mga kasuguan, agor imo itudlo sa mga tawo.” ");
INSERT INTO bno_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ngani, nagginan ray si Moises kaibahan kag ida suguon nak si Josue, kada nagpadayon it pagtukar sina Moises sa Baguntor it Dios nak ingtatawag rang Baguntor it Sinay. ");
INSERT INTO bno_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Bag-o sida nagginan ay nagtugon sida sa mga pinuno nak, “Huyata ninro kag amo pagbalik rili. Kaibahan ninro sina Aaron ag Hur nak mabibilin rili, kada si-o man sa inro kag magkainggwa't problema ay sa inra kamo magpayungot.” ");
INSERT INTO bno_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ngani, pagkatapos nida it bisaya sa mga pinuno ay nagpadayon si Moises sa pagtukar sa baguntor ag kali ay natabunan it rampog. ");
INSERT INTO bno_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ag kag kahimayaan it GINO-O ay naglibon sa Baguntor it Sinay. Sa suyor it an-om nak adlaw kag baguntor ay natabunan it rampog, ag sa pangpitong adlaw si Moises ay ging-ayaba it GINO-O halin sa rampog. ");
INSERT INTO bno_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Sa pagmuyat it mga Israelinhon habang sinra ay sa ubos kag kahimayaan it GINO-O ay nupay nagrarayab-rayab nak kayado sa ibabaw it baguntor. ");
INSERT INTO bno_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ag habang nagtutukar si Moises, nagsuyor sida sa maramoy nak rampog ag ruto sida nagtiner sa suyor it kwarentang adlaw ag kwarentang gab-i. ");
INSERT INTO bno_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nagsiling ray kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Silingga kag mga Israelinhon nak maghalar sinra sa Ako. Ikaw kag mabaton para sa Ako it mga halar nak gingtata-o it bawat tawo nak hugot sa inra tagipusuon. ");
INSERT INTO bno_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Imaw kali kag imo abatunon halin sa inra: buyawan, pilak ag bronse, ");
INSERT INTO bno_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","mga bunang nak kulay asul, ubi ag puya, pati mga magandang klase it puting bunang nak lino, mga bayukag it kambing, ");
INSERT INTO bno_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","mga anit it turong karnero nak ingtina it puya, ag mga pinong anit it katong isra nak naambit sa yumba-yumba, tabla nak akasya, ");
INSERT INTO bno_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lana it olibo para sa mga iwag, mga mabangyong buyong para sa inugbanlos nak lana nak ginggagamit it mga saserdote ag para sa mabangyong insenso, ");
INSERT INTO bno_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mga alahas nak tuyar sa marmol, pati iba pang mga mamahayong bato nak itakor sa ingsusuksok it Pinaka-mataas nak Saserdote, katong pangibabaw nak baro nak ingtatawag nak epod, pati sa pangsukyob sa rughan.” ");
INSERT INTO bno_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Masunor, pahimu-e Ako sa inra it dayawan ag Ako ay maistar sa tunga ninra. ");
INSERT INTO bno_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kumporme sa Ako ipakita sa imo tungor sa hitsura it Toldang Dayawan, pati tanang kagamitan raha, imaw kali kag dapat ninrong himuon.” ");
INSERT INTO bno_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ngasing, nahanungor sa mga kagamitan nak kinahangyan para sa Toldang Dayawan: “Maghimo kamo it kaban nak akasya. Kag haba ay an-om nak rangaw (3.75 pye o 110 centimetros), kag yapar ay ap-at nak rangaw (2.25 pye o 66 centimetros), imaw ra kag taas. ");
INSERT INTO bno_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Inro kali apahuptan it purong buyawan, sa suyor ag sa liwas, bag-o kali ribitihan it buyawan palibot sa yuba. ");
INSERT INTO bno_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Inro kali ahimuan it ap-at nak ragkong talinga nak buyawan ag itakor sa ida ap-at nak siki, tigruha sa magkanyudong habig. ");
INSERT INTO bno_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Masunor, maghimo ra kamo it pangbadaw nak akasya ag pahuptan ra kali it buyawan. ");
INSERT INTO bno_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kaling pangbadaw ay inro isuksok sa mga talinga sa magkanyudong habig it kaban agor kali ay puyding badawan. ");
INSERT INTO bno_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Kaling pangbadaw ay ruto yang sa mga talinga. Indi ninro kali gitangkason. ");
INSERT INTO bno_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Pagkatapos, imo ibutang rahang kaban kag ruhang mayapar nak bato, kung hariin isuyat kag mga Kasuguan nak Ako ita-o sa imo, bilang tanra it Ako Kasugtanan sa inro. ");
INSERT INTO bno_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Masunor, mahimo kamo it takyob nak purong buyawan para sa Balaan nak Kaban. Kaling takyob ay imaw it maging ingkuran nak ingtatawag nak Ingkuran it Kaluoy, kung hariin mapapasa-inro kag kapatawaran sa inro mga sala. Kag haba it kali ay an-om nak rangaw (3.75 pye o 110 centimetros) ag kag yapar ay ap-at nak rangaw (2.25 pye o 66 centimetros). ");
INSERT INTO bno_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kag bawat ugbos it kali ay inro ahimuan it ruhang ingtatawag nak kerubin nak buyawan, ");
INSERT INTO bno_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","tig-usang kerubin sa bawat ugbos. Inro kali apurmahan sa takyob agor kag ruhang kerubin ag kag takyob ay usa yang. ");
INSERT INTO bno_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ahimuon ninrong magkaatubang kag ruhang kerubin nak nagmumuyat paubos sa takyob it kaban, nak parehong nakabuka kag mga pakpak nak gingsisinrungan kag takyob. ");
INSERT INTO bno_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Pag kali ay natapos, butangan sa ibabaw it Balaan nak Kaban, kung hariin ibutang kag ruhang mayapar nak bato nak nasusuyatan it Kasuguan nak Ako ita-o sa imo. ");
INSERT INTO bno_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ruto sa takyob nak imaw kag Ingkuran it Kaluoy mapakigkita Ako sa imo sa tunga it ruhang kerubin nak asa ibabaw it Balaan nak Kaban, kung hariin nakabutang kag Kasuguan nak Tanra it Kasugtanan. Ruto ra Nako ita-o sa imo kag tanang kasuguan Nako para sa mga Israelinhon.” ");
INSERT INTO bno_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Nagpadayon pa kag GINO-O sa pagbisaya, “Maghimo ra kamo it lamesa nak akasya. Kag haba ay limang rangaw (3 pye o 88 centimetros), kag yapar ay ruha ag tunga (1.5 pye o 44 centimetros), ag kag taas ay ap-at nak rangaw (2.25 pye o 66 centimetros). ");
INSERT INTO bno_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Inro kali apahuptan it purong buyawan ag ribitihan it buyawan sa palibot. ");
INSERT INTO bno_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Inro kali ahimuan it sanipa paibabaw nak tunga sa rangaw kag yapar (75 milimetros), bag-o pahuptan ra kali ag ribitihan it buyawan sa palibot. ");
INSERT INTO bno_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Inro kali ahimuan it ap-at nak ragkong talinga nak buyawan ag itakor sa ap-at nak pusor sa ibabaw it siki. ");
INSERT INTO bno_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ruto ninro itakor kaling mga talinga sa mayungot it sanipa pramas suksukan it pangbadaw it mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Maghimo kamo it kaling pangbadaw nak akasya ag inro ra kali pahuptan it buyawan. Kali kag agamiton sa pagbadaw it lamesa. ");
INSERT INTO bno_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Masunor, maghimo ra kamo it mga mayukong ag pinggan, pati mga pitsil ag tasa para sa pagbuhos it mga inughalar nak inumon sa atubangan it Dios. Ahimuon ninro kaling tanan sa purong buyawan. ");
INSERT INTO bno_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Sa ibabaw it lamesa kung hariin permi kag Ako Presensya, ibutang ninro kag hinalar nak Tinapay. ");
INSERT INTO bno_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Masunor, nak inro ahimuon ay kag kandilerio nak purong buyawan. Asaysayon ninro kali it bilog, kag puno, yawas, ag mga sanga, pati kag mga butangan it iwag sa tunga it pay buskar nak buyak nak inggwa't pilang alimudong sa palibot. ");
INSERT INTO bno_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ahimuan ninro kali it an-om nak sanga, tig-tatlo sa magkanyudo. ");
INSERT INTO bno_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kada usa sa an-om nak mga sanga ay magkakainggwa it tatlong kurting buskar nak buyak nak inggwa't pilang alimudong sa palibot bilang pangpaganda. ");
INSERT INTO bno_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kag yawas it kaling kandilerio ay magkakainggwa it ap-at nak kurting buskar nak buyak nak inggwa't pilang alimudong sa palibot bilang pangpaganda. ");
INSERT INTO bno_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Abutangan ra ninro it usang buskar nak buyak sa irayom it kada bukó it pares nak sanga. ");
INSERT INTO bno_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Kag mga buskar nak buyak, alimudong ag sanga ay ahimuon ninrong unay sa yawas ag puno. Bilog kali nak ingsaysay sa purong buyawan. ");
INSERT INTO bno_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Bag-o, maghimo kamo it pitong iwag para sa kandilerio, agor mahadag kag atubangan. ");
INSERT INTO bno_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Pagkatapos, maghimo kamo it mga gamit nak panglimpyo ag pangsayor halin sa purong buyawan. ");
INSERT INTO bno_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kag buyawan nak inro agamiton sa pagsaysay it kandilerio ag mga gamit ay treyntay kwatrong (34) kilo. ");
INSERT INTO bno_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Sunra it maado kag Ako ingpapakita sa imo rili sa baguntor tungor sa hitsura it kaling kagamitan.” ");
INSERT INTO bno_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Nagpadayon pa kag GINO-O sa pagbisaya kang Moises, “Nahanungor ray sa Toldang Dayawan. Maghimo kamo it tolda nak halin sa sampuyong rolyo it mapinong tela nak hinaboy sa bunang nak puting lino, ag mga bunang ra nak kulay asul, ubi ag puya. Kali ay aburdahan it mga maayo magburda it hitsura it mga kerubin nak inggwa't pakpak. ");
INSERT INTO bno_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Tanang rolyo ay pare-pareho it sukat. Kag haba ay katorseng yarda (12 metros), ag kag yapar ay ruhang yarda (2 metros). ");
INSERT INTO bno_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Atambihon anay kag limang rolyo tuna sa ibabaw paubos. Imaw ra katong lima. ");
INSERT INTO bno_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kag kada habig it kaling ruhang natambey ay inro ahimuan it mga talinga nak halin sa retasong asul. ");
INSERT INTO bno_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Sa kada usa singkwentang talinga kag inro itahi, agor magpares kaling mga talinga. ");
INSERT INTO bno_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Bag-o, maghimo kamo it singkwentang kaw-it nak buyawan. Imaw kali kag inro agamiton pramas kaling ruhang natambey ay matabo. Imaw kali kag parayan it inro paghimo pramas kag Toldang Dayawan ay magiging usa. ");
INSERT INTO bno_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Masunor, maghimo kamo it onseng rolyo nak human sa bayukag it kambing. Imaw kali kag pangibabaw it katong unang tela nak lino sa tolda. ");
INSERT INTO bno_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tanang rolyo it bayukag it kambing ay pare-pareho kag sukat. Kag haba ay kinseng yarda (13 metros), ag kag yapar ay ruhang yarda (2 metros). ");
INSERT INTO bno_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Atambihon anay kag limang rolyo, ag imaw ra kag an-om, tuna sa ibabaw paubos. Pilu-a kaling pang-an-om nak tinambing rolyo, ag imaw it ibutang sa atubangan it Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Sa habig it kada usang natambey nak rolyo it bayukag it kambing ay inro atahian it singkwentang talinga. ");
INSERT INTO bno_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","“Bag-o maghimo kamo it singkwentang kaw-it nak bronse. Imaw kali kag inro agamiton pramas kaling ruhang natambey ay magtabo, agor kag Toldang Dayawan ay magiging usa. ");
INSERT INTO bno_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kag katunga it subrang yamit halin sa bayukag it kambing ay apaluyluyon yang sa likor it tolda. ");
INSERT INTO bno_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kaling pangibabaw sa tolda nak human sa bayukag it kambing ay mas mayapar it tunga sa yarda (50 centimetros) sa magkanyudong habig kisa sa rako it Toldang Dayawan, pramas kag luyloy it kali ay makatabon it husto. ");
INSERT INTO bno_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Pagkatapos, maghimo kamo it usa pa nak inugtakyob sa Toldang Dayawan halin sa anit it turong karnero nak ingtina it puya. Ag kag huli ay ahimuon ninro kag pangibabaw sa tanan nak human sa pinong anit it isra nak naambit sa yumba-yumba. ");
INSERT INTO bno_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ngasing, maghimo kamo it mga purma nak akasya para sa ringring it tolda. ");
INSERT INTO bno_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kada usang purma, kag taas ay kinseng pye (4 metros) ag kag yapar ay ruhang pye ag tatlong purgada (66 centimetros). ");
INSERT INTO bno_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Kada usang purma ay abutangan ninro it tigruhang siki. Tanang purma ay tuyar kag inro paghimo. ");
INSERT INTO bno_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Pag ahimuon ninro kali, dapat ay beynteng purma kag para sa ringring sa bandang habagatan. ");
INSERT INTO bno_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Saysay ra kamo it kwarentang tungtungan nak human sa pilak: Ruhang tungtungan para sa kada usang purma, tig-usa sa kada siki. ");
INSERT INTO bno_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Para sa ringring sa bandang amihan ay ahimuon ra ninro kag beynteng purma. ");
INSERT INTO bno_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Imaw ra kag inra kwarentang tungtungang pilak: Ruhang tungtungan sa irayom it ruhang siki it kada purma. ");
INSERT INTO bno_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Sa parting likor it tolda, bandang sugbuhan ay ahimuon ninro kag an-om nak purma, ");
INSERT INTO bno_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ag ruhang purma para sa ruhang rugo. ");
INSERT INTO bno_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Kaling tigruhang purma nak pangrugo ay atabuon halin sa ubos hastang sa ibabaw, ag ipisan it suksok kag ruhang siki sa usang tungtungan yang. ");
INSERT INTO bno_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ngani, wayo tanan kag purma para sa likor, ag kag inra mga tungtungang pilak ay disi-sais tanan, ruha sa kada purma. ");
INSERT INTO bno_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Maghimo ra kamo it mga panggakot nak mga mahabang akasya: Lima para sa mga purma sa kada habig it tolda, ");
INSERT INTO bno_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ag lima ra para sa likor it tolda sa bandang sugbuhan. ");
INSERT INTO bno_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kag haba it panggakot sa tunga ay dapat halin sa usang ugbos hastang sa usang ugbos para sa kada habig ag likor. ");
INSERT INTO bno_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Apahuptan ninro kaling tanang purma ag panggakot it buyawan, ag ahimuan ninro it mga ragkong talinga nak buyawan pramas suksukan it mga panggakot. ");
INSERT INTO bno_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Imo itukor kag Toldang Dayawan kumporme sa plano nak Ako ingpakita sa imo rili sa baguntor. ");
INSERT INTO bno_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Para sa suyor it Toldang Dayawan, magpahimo ka sa mga maayo maghaboy it kurtinang halin sa magandang klasing bunang nak puting lino, ag mga bunang ra nak kulay asul, ubi ag puya. Kali ay aburdahan it mga maayo magburda it hitsura it mga kerubin nak inggwa't pakpak. ");
INSERT INTO bno_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kali ay imo itakor parayan sa mga buyawang kaw-it sa ap-at nak haliging akasya. Kaling mga haligi ay napahuptan it buyawan nak nakatungtong sa ap-at nak tungtungang pilak. ");
INSERT INTO bno_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Pagkatakor ninro it kurtina parayan sa mga pangkaw-it ay isuyor ninro kag Balaan nak Kaban, kung hariin nakabutang kag Kasuguan nak Tanra it Kasugtanan. Kaling kurtina kag mabuyag sa inro halin sa Sagradong Lugar papagto sa Pinaka-sagradong Lugar kung hariin kag Balaan nak Kaban. ");
INSERT INTO bno_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Butangan ra kag takyob nak imaw kag Ingkuran it Kaluoy sa Balaan nak Kaban ag isuyor sa Pinaka-sagradong Lugar. ");
INSERT INTO bno_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Imo ray ibutang kag lamesa sa liwas it kurtina sa bandang amihan it tolda, ag kag kandilerio sa habig bandang habagatan. ");
INSERT INTO bno_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Bilang pangsara sa pwertahan it Toldang Dayawan, kali ay pahimu-e it kurtina sa mga maayo maghaboy halin sa magandang klasing bunang nak puting lino, ag mga bunang ra nak kulay asul, ubi ag puya. ");
INSERT INTO bno_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Saysay it mga buyawang kaw-it pramas itakor kaling kurtina sa limang haliging akasya nak ingpahuptan it buyawan. Saysay ra it limang bronse para tungtungan it haligi.” ");
INSERT INTO bno_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Nagpadayon pa kag GINO-O sa pagbisaya kang Moises, “Maghimo kamo it altar nak akasya. Kinahangyan nak kwadrado kali. Kag haba ag yapar ay ruha ag tungang yarda (2.25 x 2.25 metros), ag kag taas ay usa ag tungang yarda (1.34 metros). ");
INSERT INTO bno_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Kag ap-at nak pusor it kali ay ahimuan ninro it matagar, nak pay sungay kag korte, ag nakaunay sa altar. Bag-o apahuptan kali it bronse sa liwas ag sa suyor. ");
INSERT INTO bno_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Pagkatapos, ahimuan ra ninro kag altar it mga gamit nak bronse: Mga butangan it abo, mga pala, mga mayukong, mga marakong tinidor ag mga butangan it baga. ");
INSERT INTO bno_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ahimuan ra ninro it parilyang human sa bronse, nak kag hitsura ay pay lambat. Maghimo ra it ap-at nak ragkong talingang bronse para sa ap-at nak pusor. ");
INSERT INTO bno_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Inro isuyor kaling parilya sa suyor it altar agor kali ay nakabutang sa ida pinaka-tungtungan sa tunga. ");
INSERT INTO bno_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Masunor, maghimo pa kamo it ruhang pangbadaw nak akasya nak napahuptan ra it bronse. ");
INSERT INTO bno_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Kaling pangbadaw ay isuksok rutong mga talinga pramas sa magkanyudong habig ay puyding badawan. ");
INSERT INTO bno_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kada kag altar nak inro ahimuon ay dapat halin sa tabla ag waya't sayog, kumporme sa hitsura nak Ako ingpakita sa imo rili sa baguntor. ");
INSERT INTO bno_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Kag tolda ay ahimuan ninro it rayaag, nak palibot it kuray nak human sa mga rolyo it mapinong puting tela nak lino. Sa bandang habagatan ay singkwentang yarda (44 metros) kag haba. ");
INSERT INTO bno_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Kaling mga rolyo it tela nak lino ay itakor ninro sa beynteng haligi, nak nakatinrog sa beynteng tungtungang bronse. Kag mga pangkaw-it it kali ag kag mga ragkong singsing ay asaysayon ninro sa pilak. ");
INSERT INTO bno_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Imaw ra kag kuray sa bandang amihan, ay singkwentang yarda (44 metros) kag haba, kag mga rolyo it tela ay nakatakor sa beynteng haligi nak nakatinrog sa tungtungang bronse, ag kag mga pangkaw-it ag mga ragkong singsing ay ingsaysay sa pilak. ");
INSERT INTO bno_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Sa bandang sugbuhan, beynte singkong yarda (44 metros) kag yapar it rayaag, ag kag mga rolyo it tela ay nakatakor sa sampuyong haliging nakatinrog sa ida tungtungan. ");
INSERT INTO bno_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Sa bandang subatan, kung hariin kag rayan pasuyor, kag yapar it rayaag ay beynte singkong yarda ra (22 metros). ");
INSERT INTO bno_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Sa usang habig it kali ay ahimuan it mga rolyo it tela nak lino nak kag haba ay pitong yarda ag tunga (6.67 metros), ag itakor sa tatlong haligi sa ida tungtungan. ");
INSERT INTO bno_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Imaw ra sa usang habig, pitong yarda ag tunga (6.67 metros) kag haba it mga rolyo it tela nak nakatakor sa tatlong haligi sa ida tungtungan. ");
INSERT INTO bno_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Para sa rayan pasuyor, kag haba it kurtinang pangsara nak mapinong tela ay sampuyong yarda (9 metros). Kali ay ipahaboy sa mga maayo maghaboy halin sa bunang nak puting lino ag mga bunang ra nak kulay asul, ubi ag puya. Bag-o kali ay isab-it sa ap-at nak haligi nak nakatinrog sa ida tungtungan. ");
INSERT INTO bno_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","“Tanang haligi sa palibot it rayaag ay dapat nak kag inra pangkaw-it ag ragkong singsing ay pilak, ag kag inra tungtungan ay bronse. ");
INSERT INTO bno_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kag haba it rayaag ay dapat singkwentang yarda (44 metros) ag kag buka ay beyntey-singkong yarda (22 metros). Ag ruha ag tungang yarda (2.2 metros) kag taas it mapinong tela nak kuray, nak nakatakor sa mga haliging nakatinrog sa tungtungang bronse. ");
INSERT INTO bno_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tanang kagamitan para sa pagserbisyo sa Toldang Dayawan, aber riin agamiton, pati tanang palpal para sa Toldang Dayawan ag para sa pagtukor it kuray sa palibot it rayaag ay dapat nak human sa bronse. ");
INSERT INTO bno_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Imo asuguon kag mga Israelinhon nak magraya it matin-aw nak lana, halin sa ingpuga nak olibo, para sa mga iwag sa kandilerio, pramas kali ay padayon nak naghahadag. ");
INSERT INTO bno_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Si Aaron ag kag ida mga kayaking anak, imaw kag maripara it kaling mga iwag sa kandilerio, sa liwas it Pinaka-sagradong Lugar it Toldang Dayawan, kung hariin kag Balaan nak Kaban nak butangan it Tanra it Kasugtanan. Asiguraduhon ninra nak indi kali mapayong sa Ako atubangan, tuna sa gab-i hastang sa aga. Kali ay atumanon it mga Israelinhon hastang sa pagbalhin it inra mga henerasyon.” ");
INSERT INTO bno_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Nagpadayon pa kag GINO-O sa pagbisaya kang Moises, “Patawagan si Aaron nak imo maguyáng, pati kag ida mga anak nak kayaking sina Nadab, Abihu, Eleazar ag Itamar. Imo sinra agahinon halin sa mga Israelinhon pramas sinra ay magserbisyo sa Ako bilang mga saserdote. ");
INSERT INTO bno_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Imo apatahian kag imo manong Aaron it mga sagradong baro pramas kag ida sarili ay maging dungganon ag talahuron. ");
INSERT INTO bno_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Sugu-a kag tanang mga gingtaw-an Nako it maadong abilidad sa pagtahi, nak tahion kag mga baro ni Aaron agor maihalar sida sa pagserbisyo sa Ako bilang saserdote. ");
INSERT INTO bno_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Kali kag mga baro nak inra ahimuon: Usang pangsukyob sa rughan, usang pangibabaw nak baro nak ingtatawag nak epod, usang pangirayom sa epod, usang sutana nak inghabuyan it pakwadrado, usang turban ag usang hagkos. Ipatahi nimo kaling mga sagradong baro para kang Aaron nak imo manong, ag para sa ida mga kayaking anak, pramas magserbisyo sa Ako bilang mga saserdote. ");
INSERT INTO bno_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Pagamitan sa manughaboy kag mga bunang nak buyawan ag kulay asul, ubi ag puya, pati mapinong puting lino. ");
INSERT INTO bno_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Patahian sa mga maayo magtahi kag epod nak waya't butkon, halin sa mapinong bunang nak puting lino, ag sa mga bunang ra nak buyawan ag kulay asul, ubi ag puya. ");
INSERT INTO bno_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kali ay dapat inggwa it ruhang mayapar nak terante, pramas imaw kali kag masugrong sa likor ag sa atubangan. ");
INSERT INTO bno_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kag paha, nak unay kag pagkahaboy sa epod, ay halin ra sa bunang nak buyawan ag kulay asul, ubi ag puya, pati mapinong puting lino. ");
INSERT INTO bno_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Masunor, mabaoy ikaw it ruhang alahas nak tuyar sa marmol, ag itiltil ruto kag mga ngayan it mga anak nak kayake ni Jacob nak ingtatawag rang Israel, ");
INSERT INTO bno_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","tuna sa panganay hastang sa puto, an-om sa kada usang bato. ");
INSERT INTO bno_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Itiltil ruto kaling mga ngayan it mga anak ni Israel tuyar sa pagtiltil it maayong manugsaysay it alahas. Bag-o imo itakor kaling ruhang alahas sa ida butangang buyawan nak ingpalibutan it mapinong pinisi-pisi nak buyawan. ");
INSERT INTO bno_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Pagkatapos, imo itakor kaling ruhang batong alahas sa ida butangan sa ruhang terante it epod, bilang pagrumrom sa mga anak ni Israel. Sa tuyar nak parayan, pag maatubang si Aaron sa Ako nak GINO-O, aray-on nida sa ida ruhang abaga kag mga ngayan it mga anak ni Israel agor sinra ay marurumruman Nako. ");
INSERT INTO bno_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","“Mahimo pa ikaw it ruhang alahas nak pinisi-pisi, ");
INSERT INTO bno_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ag ruhang kadina nak yinubir, halin sa purong buyawan. Ag kali ay itakor raha sa ruhang alahas. ");
INSERT INTO bno_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Pahimuan ra sa mga maayo magtahi kag pangsukyob sa rughan para sa paghusgar. Kag paghimo it kali ay tuyar sa epod nak ingtahi sa mga bunang nak buyawan ag kulay asul, ubi ag puya, pati sa mapinong bunang nak puting lino. ");
INSERT INTO bno_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kinahangyan ay nakapilo kali agor maging kwadrado, usang rangaw kag haba (8 purgada o 22 centimetros). Imaw ra kag yapar. ");
INSERT INTO bno_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Imo kali atakran it ap-at nak lihira it magandang alahas, nak nakabutang sa inra buyawan nak butangan. Sa unang lihira ay kulay puya, ruyaw ag pus-awon nak berde. ");
INSERT INTO bno_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Kag mga kulay sa pangruhang lihira ay tuyar sa kulay it pispis nak tangkali, asul nak tuyar sa langit, ag puti. ");
INSERT INTO bno_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Kag mga kulay ray sa pangtatlong lihira ay tuyar sa pus-awon nak kulay-ubi, brawn nak marmol, ag kulay-ubi. ");
INSERT INTO bno_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ag kag mga kulay sa pang-ap-at nak lihira ay tuyar sa buyak it kayabasa, itom nak marmol, ag berde. Kaling tanan ay ibutang sa ida butangang buyawan nak ingpalibutan it mapinong pinisi-pisi nak buyawan. ");
INSERT INTO bno_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Tanan kali ay doseng magandang alahas. Sa kada usa ay nakatiltil kag bawat ngayan it doseng anak ni Jacob nak ingtatawag rang Israel, ag sinra kag mga pinuno it inra mga lahi. ");
INSERT INTO bno_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Masunor, magpasaysay ka it ruhang kadina nak yinubir, halin sa purong buyawan para sa pangsukyob sa rughan. ");
INSERT INTO bno_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ag ipasaysay ra nimo kag ruhang maragkong talinga nak buyawan, ag itakor sa ruhang pusor sa ibabaw it kwadradong pangsukyob. ");
INSERT INTO bno_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Rili nimo itakor kag ruhang kadina nak buyawan. ");
INSERT INTO bno_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ag kag ruhang ugbos it ruhang kadinang buyawan ay imo itakor sa atubangan it ruhang butangan it alahas sa terante it epod, pramas magsugrong. ");
INSERT INTO bno_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Masunor ray, magpasaysay ka it ruhang maragkong talinga nak buyawan, ag itakor sa ruhang pusor sa ubos it pangsukyob sa rughan, sa irayom. ");
INSERT INTO bno_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Bag-o pasaysayan kag ruhang maragkong talinga nak buyawan para sa kilir it epod, kung hariin nagsugrong kag paha. ");
INSERT INTO bno_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kag ruhang talinga it pangsukyob sa rughan ay agamitan it higot nak asul bilang pagsugrong sa ruhang talinga sa paha it epod, pramas indi magbitin-bitin kag pangsukyob sa rughan. ");
INSERT INTO bno_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Parayan sa pagsuksok ni Aaron sa pangsukyob sa rughan nak imaw kag tanra it paghusgar, kada masuyor sida sa Sagradong Lugar sa Toldang Dayawan ay raya-raya nida sa ida tagipusuon kag mga ngayan it doseng anak ni Israel. Parayan dili ay padayon nak marurumruman Nako sinra. ");
INSERT INTO bno_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ibutang ra nimo sa suyor it nakapilong tela it pangsukyob sa rughan nak pay bulsa sa rughan kag ruhang kagamitan sa paghusgar nak ingtatawag nak Urim ag Tumim, agor kali ay asa tagipusuon ni Aaron pagsuyor nida nak mag-atubang sa Ako nak GINO-O. Parayan dili, kada maatubang sida sa Ako, raya-raya nida sa ida tagipusuon kag mga kagamitan sa paghusgar para sa mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ag imo apahimuan it pangirayom nak baro nak yabaw sa epod, nak puro asul. ");
INSERT INTO bno_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Butangi kali it buho para sa uyo, ag aribitihan kag palibot pramas indi kali magisi. ");
INSERT INTO bno_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kag gadar it kali ay apahimuan nimo it pay mga prutas nak granada nak yari sa mga bunang nak kulay asul, ubi ag puya. Apahimuan ra nimo it mga maintik nak bagting nak buyawan pramas ipatunga sa granada. ");
INSERT INTO bno_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Kaling bagting nak buyawan ag pay prutas nak granada ay bay-ot-bay-ot kag pagbutang palibot sa gadar it kaling pangirayom sa epod. ");
INSERT INTO bno_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Kali ay dapat isuksok ni Aaron pag nagsiserbisyo sida bilang Pinaka-mataas nak Saserdote, agor marurunggan kag bagting kada masuyor ag maliwas sida sa pag-atubang nida sa Ako nak GINO-O sa Sagradong Lugar it Tolda nak Dayawan. Sa tuyar nak parayan indi sida mamatay. ");
INSERT INTO bno_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Masunor, pasaysayan kag usang alahas nak purong buyawan, ag itiltil dili kag ‘Ginahing Balaan Para sa GINO-O.’ ");
INSERT INTO bno_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kag atubangan it turban ay ahigtan it pisi nak asul. ");
INSERT INTO bno_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Isuksok kali ni Aaron sa ida yupa, ag sida kag maraya it ni-o mang kasal-anan it mga Israelinhon sa inra paghalar it ni-o mang bagay sa Ako nak GINO-O. Kali ay perming asa yupa ni Aaron agor abatunon Nako sinra. ");
INSERT INTO bno_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ag apahumanan nimo sa maayo maghaboy si Aaron it sutana nak inghabuyan it pakwadrado, ag turban nak human sa mapinong puting lino. Ag pahimu-e ra it panghagkos nak di burda. ");
INSERT INTO bno_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Para sa mga anak nak kayake ni Aaron, imo sinra apahabuyan it mga sutana, hagkos ag bugkos sa uyo, pramas kag pagmuyat sa inra ay talahuron ag maado. ");
INSERT INTO bno_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Pagkapasuksok nimo kali sa imo maguyáng nak si Aaron ag sa ida mga anak, abubuan nimo sinra it lana bilang paggahin sa pagserbisyo sa Ako bilang mga saserdote. ");
INSERT INTO bno_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Ag imo ra sinra apahabuyan it mahabang karsunsilyo, tuna sa hawak hastang sa ibabaw it tuhor, halin sa tela nak mapinong puting lino. Isuksok kali nina Aaron agor indi sinra masil-ipan. ");
INSERT INTO bno_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Kada masuyor sinra sa Tolda nak Dayawan kung hariin nagpapakigkita Ako sa inra ay isuksok kali nina Aaron, ag imaw ra kada masuor sinra sa altar agor magserbisyo sa Sagradong Lugar, pramas indi sinra magkasala ag mamatay. “Imaw kali kag padayon nak atumanon ni Aaron ag ida mga inanak nak imaw it masubli sa inra.” ");
INSERT INTO bno_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Nagpadayon pa kag GINO-O sa pagbisaya kang Moises, “Tuyar kali kag imo ahimuon sa paggahin kana Aaron ag sa ida mga kayaking anak bilang mga saserdote nak maserbisyo sa Ako: Magbaoy ka it usang tureting turo ag ruhang kayaking karnero nak waya't diperensya. ");
INSERT INTO bno_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Magbaoy ra ikaw it mga tinapay nak waya't pangpaalsa, imaw ra pati mga bibingka nak inggwa't hinalong mantika ag mga biskwit nak ingpahiran it mantika. Tanan kali ay kinahangyan nak halin sa pinaka-maadong arinang trigo ag waya nak gador it pangpaalsa. ");
INSERT INTO bno_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Butangan kali sa usang nigo ag ihalar sa Ako, kaibahan it tureting turo ag ruhang kayaking karnero. ");
INSERT INTO bno_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Aray-on nimo sina Aaron ag ida mga anak sa atubangan Nako sa pwertahan it Toldang Dayawan kung hariin mapakigkita Ako sa inro, ag ruto nimo sinra akaligusan. ");
INSERT INTO bno_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Si Aaron anay kag imo asuksukan it sutana ag pangirayom sa epod, epod ag pangsukyob sa rughan, bag-o ihugot kag paha it epod nak maganda kag pagkatahi. ");
INSERT INTO bno_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Masunor, iputong nimo sa ida uyo kag turban, ag ihigot ruto kag buyawan nak alahas bilang kuruna nak inggwa't suyat nak ‘Ginahing Balaan Para sa GINO-O.’ ");
INSERT INTO bno_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Pagkatapos, imo abubuan sida sa uyo it lana nak pangbanlos nak inggagamit para sa paggahin sa ida nak magserbisyo sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Kag masunor nak imo asuksukan it sutana ay kag ida mga anak. ");
INSERT INTO bno_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Hagkuse ag bugkusan kag inra uyo. Tuyar kina kag imo ahimuon bilang pag-ordinar kang Aaron ag sa ida mga anak, dahil sinra ag kag inra magiging mga inanak ay magiging saserdote hastang sa katapusan. ");
INSERT INTO bno_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ray-a kag tureting turo sa atubangan it Toldang Dayawan kung hariin nagpapakigkita Ako sa inro. Ag silingga si Aaron ag kag ida mga anak nak ibabaw kag inra mga damot sa uyo it kali. ");
INSERT INTO bno_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Sa tuyar nak parayan, imo ayu-yuon kag turete sa atubangan Nako nak GINO-O sa pwertahan it Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Sayura kag rugo it kali, ag parayan sa imo tudlo, imo apahiran anay kag mga matagar it altar. Kag matuturang rugo ay imo ibubo sa puno it altar. ");
INSERT INTO bno_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Pagkatapos, imo abay-on kag taba nak nagtatabon sa mga kasudlan, kag atay ag kag ruhang bato kaibahan kag taba ay asunugon sa altar bilang halar. ");
INSERT INTO bno_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero kag anit, unor ag mga kasudlan kaibahan kag kinaon ay asunugon sa liwas it kampo, dahil kali ay halar para sa kasal-anan. ");
INSERT INTO bno_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Masunor, bay-a kag usa sa ruhang karnero ag imaw ra, ibabaw sa uyo it kali kag mga damot nina Aaron ag ida mga anak, ");
INSERT INTO bno_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","bag-o yu-yuon kali, sayura kag rugo ag iwisik sa mga habig it altar. ");
INSERT INTO bno_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Pagkatapos, imo akarnehon kag karnero, hugasi kag ida mga kasudlan ag kag mga siki, bag-o ipisan sa uyo ag sa iba pang parti. ");
INSERT INTO bno_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Sa tuyar nak parayan, imo kali aubuson it sunog sa altar. Usa kaling sinunog nak halar nak mabangyo sa atubangan Nako nak GINO-O. Kali ay halar sa Ako parayan sa kayado. ");
INSERT INTO bno_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Bay-a ray kag usang karnero ag imaw ra, ibabaw ra sa uyo it kali kag mga damot nina Aaron ag ida mga anak, ");
INSERT INTO bno_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","bag-o yu-yuon kali ag sayuron kag rugo. Pahiri it rugo kag ugbos it tuong talinga nina Aaron ag ida mga anak. Imaw ra kag inra tuong aminrakoy it damot ag siki. Ag kag rugong matutura ay imo iwisik sa mga habig it altar. ");
INSERT INTO bno_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Bag-o kali ay maubos, mabaoy anay ikaw it maisot nak rugo halin raha, ag maisot nak lana nak pangbanlos nak inggagamit para sa paggahin sa tawo nak maserbisyo sa Ako. Ag iwisik kali nimo kana Aaron ag sa ida mga baro, pati sa ida mga anak ag sa inra mga baro. Sa tuyar nak parayan sida ag kag ida mga anak, pati kag inra mga baro ay magagahin para sa Ako nak GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Pagkatapos, bay-a kag taba sa ikog it kaling karnero, kag taba nak nakapuros sa mga kasudlan, kag atay ag ruhang bato kaibahan kag taba, ag kag tuong pigi. Kaling mga parti it karnero ay inggagamit sa pag-ordinar bilang pagka-saserdote. ");
INSERT INTO bno_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ag magbaoy it usang tinapay, usang bibingka nak inggwa't hinalong mantika, ag usang biskwit halin sa nigo nak inggwa't mga tinapay nak waya't pangpaalsa, nak inghalar sa Ako nak GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Masunor, imo ibutang sa mga damot nina Aaron ag ida mga anak kaling mga tinapay, kaibahan kag mga parti it karnero, bag-o ihalar kali parayan sa pagkaway it inra mga damot sa Ako nak GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Pagkatapos, imo kali abay-on sa inra mga damot ag sunugon sa altar, kaibahan kag ingsunog nak halar bilang mabangyong halar sa atubangan Nakong GINO-O. Kali ay halar sa Ako parayan sa kayado. ");
INSERT INTO bno_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Masunor, bay-a kag bandang rughan it karnero nak inggagamit sa pag-ordinar kang Aaron. Ikaway kali sa atubangan Nakong GINO-O bilang paghalar. Imaw kali kag magiging parti nimo. ");
INSERT INTO bno_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Gahina kag ruhang parti halin sa karnero nak inggamit sa pag-ordinar kana Aaron ag ida mga anak, ag kag bandang rughan nak gingkaway ag kag pigi nak ginggahin. ");
INSERT INTO bno_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Tuna ngasing, kaling mga parti nak halin sa hadop nak inughalar it mga Israelinhon para sa pagpasag-uli, ay mapapagto kana Aaron ag ida mga anak bilang ta-o it mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Pagkamatay ni Aaron, kag sagrado nidang mga baro ay asublion it ida mga inanak agor katong masunor nak magiging Pinaka-mataas nak Saserdote ay imaw it magsuksok pag sida ay bubuan it lana nak pangbanlos nak inggagamit para sa pag-ordinar sa ida, tuyar tong ginghimo sa ida tatay. ");
INSERT INTO bno_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Pitong adlaw kaling isuksok it sin-o mang masubli kang Aaron bilang Pinaka-mataas nak Saserdote nak masuyor sa Toldang Dayawan agor magserbisyo sa Sagradong Lugar. ");
INSERT INTO bno_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Bay-a kag mga parti it karnerong inggamit sa pag-ordinar ag yaudahon kali sa lugar nak inggagamit para sa tuyar nak sagradong trabaho sa sakop it rayaag it Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ruto sa pwertahan it Toldang Dayawan, ay imo ipakaon kaling yauda kana Aaron ag sa ida mga anak, pati kag mga tinapay nak asa nigo. ");
INSERT INTO bno_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Inra akaunon kaling mga hinalar para sa katubusan, tong sinra ay ginggahin ag ging-ordinar. Pero kag buko mga saserdote ay indi puyding magkaon it kali dahil kali ay sagrado. ");
INSERT INTO bno_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kung inggwa't natura pagkaaga, sa karne o tinapay nak ginggamit sa pag-ordinar, dapat kali nak sunugon. Indi kali puyding kaunon dahil kali ay sagrado. ");
INSERT INTO bno_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Sunra tanan kaling Ako mga gingsugo sa imo parti sa pag-ordinar kana Aaron ag ida mga anak. Kali ay imo ahimuon sa sakop it pitong adlaw. ");
INSERT INTO bno_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Adlaw-adlaw sa sakop it pitong adlaw, ay mamatay ikaw it inughalar sa Ako nak GINO-O it usang turong baka para sa katubusan it sala. Ag himuon nimong limpyo kag altar parayan diling inughalar nak hadop, bag-o bub-an it lana nak pangbanlos bilang paghanra para sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ahimuon nimo kali sa sakop it pitong adlaw. Ag pagkatapos, kag altar ay abilangon nak matuor nak balaan, ag aber ni-o mang ibutang dili ay magiging balaan ra. ");
INSERT INTO bno_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Pagkatapos it kinang tanan, kag inro dapat himuon adlaw-adlaw ay ihalar sa altar kag ruhang tureting karnero nak kag guyang ay usang tuig, ");
INSERT INTO bno_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","usa sa aga ag usa ra sa pagsugbo. ");
INSERT INTO bno_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kaibahan it kaling inughalar sa aga ay ihalar ra kag usang gantang nak pinaka-maadong arina nak minasa sa usang litrong mantika di olibo, ag ibuhos ra kag usang litrong ayak bilang inughalar. ");
INSERT INTO bno_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ag kaibahan it kaling inughalar sa hapon ay ihalar ra kag parehong arina, mantika ag ayak. Mabangyo kali sa atubangan Nakong GINO-O. Kali ay halar sa Ako parayan sa kayado. ");
INSERT INTO bno_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Kaling paghalar nak kali ay inro ahimuon habang kamo ay buhi, hastang sa pagbalhin it inro mga henerasyon. Inro kali ahimuon sa pwertahan it Toldang Dayawan sa Ako atubangan kung hariin mapakigkita Ako ag mabisaya sa imo. ");
INSERT INTO bno_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","“Ruto ra Ako mapakigkita sa mga Israelinhon, ag kag lugar nak kato ay magagahin parayan sa Ako kahimayaan. ");
INSERT INTO bno_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ako agahinon katong Toldang Dayawan, pati kag altar, ag imaw ra si Aaron ag kag ida mga anak para magserbisyo sa Ako bilang saserdote. ");
INSERT INTO bno_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ako ay maistar sa tunga it mga Israelinhon ag Ako kag inra magiging Dios. ");
INSERT INTO bno_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Inra maaayaman nak Ako kag GINO-O nak inra Dios nak naghaw-as sa inra halin sa Ehipto, agor Ako ay maistar sa inra tunga. Matuor nak Ako kag GINO-O nak inra Dios.” ");
INSERT INTO bno_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Nagpadayon pa kag GINO-O sa pagbisaya kang Moises, “Maghimo kamo it altar nak akasya nak sunugan it insenso. ");
INSERT INTO bno_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kinahangyan nak kwadrado kali. Kag haba ag yapar ay ruha ag tungang rangaw (1.5 pye o 45 centimetros) ag kag taas ay limang rangaw (3 pye o 90 centimetros). Himu-e ra ninro it ap-at nak pusor nak matagar nak pay sungay kag korte, ag unay sa altar. ");
INSERT INTO bno_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kag ibabaw, kag palibot ag kag mga matagar ay pahupte it purong buyawan. Ag ribitihan ra it buyawan kag palibot it ibabaw. ");
INSERT INTO bno_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Inro kali ahimuan it ruhang marakong talinga nak buyawan, ag itakor sa ida magkanyudong habig sa irayom it ribiti pramas suksukan it pangbadaw it mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Maghimo kamo it kaling pangbadaw nak akasya, ag inro ra kali pahuptan it buyawan. ");
INSERT INTO bno_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","“Pag nahimoy kali, imo kali ibutang sa liwas it kurtina nak naglilipor sa Balaan nak Kaban kung hariin nakasuyor kag Tanra it Kasugtanan. Ag hina Ako mapakigkita sa inro. ");
INSERT INTO bno_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Kada aga, pag magripara si Aaron sa mga iwag, masunog sida it mabangyong insenso riling altar. ");
INSERT INTO bno_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Imaw ra sa pagsugbo, pag suga nida it mga iwag, masunog ray sida it insenso sa atubangan Nakong GINO-O. Adlaw-adlaw tuyar kali kag inro ahimuon hastang sa pagbalhin it inro mga henerasyon. ");
INSERT INTO bno_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Aya kamo gisunog dili it ibang insenso, ag aya ra kamo gihalar rili it ni-o mang sinunog nak hadop, pagkaon o inumon. ");
INSERT INTO bno_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Usang beses sa usang tuig ahimuon ni Aaron kag paglimpyo sa kasal-anan sa mga matagar sa kada pusor it kaling altar. Ahimuong limpyo kali kada tuig parayan sa rugo it hadop nak ihalar para sa katubusan it kasal-anan. Inro kali ahimuon hastang sa pagbalhin it inro mga henerasyon. Kaling altar ay pinaka-balaan para sa Ako nak GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Masunor, nagsiling kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Pag ilista nimo kag mga Israelinhon pramas mabilang sinra, kada usa sa inra ay abay-an nimo it kwartang pangtubos para sa inra kabuhi. Ita-o ninra kali para sa Ako, pramas waya't silot nak maabot sa inra habang imo sinra gingbibilang. ");
INSERT INTO bno_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kada usa nak marayanan it pagbilang ay dapat magbadar it an-om nak gramong pilak, kumporme sa taksanan nak ginghahagar it Toldang Dayawan. Kali ay ginghahalar sa Ako nak GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kada usa nak narayanan it pagbilang, halin sa beynte anyos pataas ay dapat magbadar it tuyar para sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Pag magbadar kamo sa Ako nak GINO-O bilang pangtubos sa inro kabuhi an-om nak gramong pilak, kag mga manggaranon ay indi puyding magrugang it kabadaran, ag kag mga pobre ay indi puyding magbuhin. ");
INSERT INTO bno_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Batuna kaling pangtubos nak kwarta halin sa mga Israelinhon, ag gamiton sa pagserbisyo sa Toldang Dayawan, bilang pagrumrom it mga Israelinhon sa atubangan Nako nak GINO-O. Kali ay pangtubos para sa inro kabuhi.” ");
INSERT INTO bno_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Masunor, nagsiling kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Maghimo ka it usang tipunan it tubi nak panghugas, nak pay marakong plangganang bronse nak inggwa't tungtungan. Imo kali ibutang sa tunga it Toldang Dayawan ag altar nak sunugan it hadop. Dapat kali ay perming puno it tubi. ");
INSERT INTO bno_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Sina Aaron ag ida mga anak nak kayake ay mahasog raha it ihinaw sa inra mga damot ag siki. ");
INSERT INTO bno_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Bag-o sinra magsuyor sa Toldang Dayawan, dapat anay sinrang magpanghinaw. Imaw ra, bag-o sinra magserbisyo parayan sa pagsunog it inughalar nak hadop sa Ako nak GINO-O raha sa altar ay ");
INSERT INTO bno_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","dapat ra anay sinrang magpanghinaw it mga damot ag siki, pramas indi sinra mamatay. Kali ay kasuguan habang panahon para kang Aaron ag sa ida mga inanak, hastang sa pagbalhin it ida mga henerasyon.” ");
INSERT INTO bno_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Masunor, nagsiling kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Mabaoy ka it kaling mga buyong ag pabangyo: An-om nak kilo nak duga it mira, tatlong kilong talingag, tatlong kilong mataas nak hilamunong balsamo, ");
INSERT INTO bno_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ag an-om nak kilong binuyar nak mga buyak it kasya. Kaling tanan ay atakson kumporme sa taksanan sa Toldang Dayawan. Pagkatapos, ihalo sa ap-at nak litrong lana it olibo. ");
INSERT INTO bno_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Imo ipahimo kaling balaan ag mabangyong lanang pangbanlos sa maayong manughimo it pabangyo. Kali ay magiging balaang pangbanlos nak lana. ");
INSERT INTO bno_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Pagkahimo nimo it kali, bub-e kag Toldang Dayawan, kag Balaan nak Kaban it Kasugtanan, ");
INSERT INTO bno_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","kag lamesa ag tanang kagamitan raha, kag kandilerio ag tanang gamit it kina, kag altar nak sunugan it insenso, ");
INSERT INTO bno_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kag altar nak sunugan it hadop nak inughalar sa Ako nak GINO-O ag tanang gamit it kina, ag kag tipunan it tubi raha sa ida tungtungan. ");
INSERT INTO bno_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Parayan dili kag imo paggahin rahang tanang nasambit pramas kali ay magiging balaan, ag pati kag tawo o butang nak masaplir rili ay magiging balaan ra. ");
INSERT INTO bno_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Imo ra abanlusan sina Aaron ag ida mga anak nak kayake bilang paggahin sa inra, agor magserbisyo sinra sa Ako bilang mga saserdote. ");
INSERT INTO bno_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Imo isiling sa mga Israelinhon, ‘Imaw kali kag Balaang lana it GINO-O, nak pangbanlos sa inro hastang sa pagbalhin it inro mga henerasyon. ");
INSERT INTO bno_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Kali ay indi ninro gibubo it basta-basta yang sa inro yawas, ag indi ninro gipatuyaran kag paghimo it kali. Kali ay matuor nak balaan, kada dapat maging balaan sa inro pagmuyat. ");
INSERT INTO bno_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Si-o man kag mapatuyar sa paghimo it kali, ag si-o man kag basta-bastang magbanlos it kali sa aber siong tawo, ay iitsapuyra sa ida lahi.’ ” ");
INSERT INTO bno_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Masunor, nagsiling kag GINO-O kang Moises, “Mabaoy ka it parehong tumpok it kaling mga buyong ag pabangyo: Duga it estakte, pangtuob nak onika, buyong nak galbano, ag purong insenso. ");
INSERT INTO bno_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ag imo ipahimo kali nak mabangyong insenso sa maayong manughimo it pabangyo. Kali ay dapat yaktan nida it asin pramas maging malimpyo ag balaan. ");
INSERT INTO bno_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Badu-a kag iba ag ibutang sa atubangan it Balaan nak Kaban it Kasugtanan kung hariin Ako ay mapakigkita sa inro, sa suyor it Toldang Dayawan. Gahina kali nak balaan para sa Ako nak GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Imo isiling sa mga Israelinhon, ‘Indi ninro gipatuyaran kag paghimo it kaling balaan nak insenso para sa inro kagustuhan yang. Dapat nak muyatan ninro nak kali ay balaan ag para sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Si-o man kag magpatuyar sa paghimo it kali agor maging sariling pabangyo yang ay iitsapuyra sa ida lahi.’ ” ");
INSERT INTO bno_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Masunor, nagsiling kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ngasing, gingpili Nako kag usang maayong panray nak marumaya sa paghuman it Toldang Dayawan. Sida ay si Besalel nak anak nak kayake ni Uri, apo ni Hur, halin sa lahi ni Juda. ");
INSERT INTO bno_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ako sida ingpun-an it Ispirito it Dios, kada ngasing sida ay inggwa't kaayam ag abilidad, pati pagkaintyendi tungor sa tanang klasi't pagpamanray. ");
INSERT INTO bno_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Maayo sida magplano it mga magandang butang halin sa buyawan, pilak ag bronse. ");
INSERT INTO bno_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Maayo ra sida magtabas it mamahayong bato ag magsaysay it mga alahas. Ag inggwa sida it kaayam sa pagkurte it kahoy ag sa tanang klasing pagpamanray. ");
INSERT INTO bno_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ako ra gingpili kag usang panray nak makabulig nida. Sida ay si Oholiab nak anak ni Ahisamac, halin sa lahi ni Dan. Ag Ako gingtaw-an ra it kaayam kag ibang mga panray pramas inra matuman kag tanang Ako gingsugo sa imo ");
INSERT INTO bno_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","tungor sa Toldang Dayawan, sa Balaan nak Kaban it Kasugtanan, nak natakyuban it Ingkuran it Kaluoy, pati sa ibang kagamitan sa Tolda, ");
INSERT INTO bno_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tuyar sa lamesa ag ida mga gamit, sa kandilerio nak purong buyawan ag ida mga gamit, sa altar nak sunugan it insenso, ");
INSERT INTO bno_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","pati sa altar nak sunugan it hadop nak inughalar sa GINO-O ag tanang ida mga gamit, ag sa tipunan it tubi raha sa ida tungtungan. ");
INSERT INTO bno_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Naumir kag mga hinaboy nak mga baro ni Aaron nak Pinaka-mataas nak Saserdote, ag kag mga baro ra it ida mga anak nak kayake sa inra pagserbisyo bilang mga saserdote. ");
INSERT INTO bno_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Imaw ra kag lana nak pangbanlos ag pag-ordinar, ag kag mabangyong insenso para sa Sagradong Lugar. Kumporme sa Ako gingsugo sa imo, kaling tanan ay sinra kag mahimo.” ");
INSERT INTO bno_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Masunor, nagsiling kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Silingga kag mga Israelinhon, ‘Inro dapat sunron kag Ako Adlaw it Inugpahuway. Imaw kali kag tanra Nako sa inro hastang sa pagbalhin it inro mga henerasyon, pramas inro maayaman nak Ako kag GINO-O nak naggahin sa inro para maging balaan. ");
INSERT INTO bno_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Inro dapat sunron kag Adlaw it Inugpahuway dahil kali ay sagrado para sa inro. Si-o man kag magsuway rili ay dapat nak mamatay. Si-o man kag magtrabaho sa adlaw nak kali ay dapat nak iitsapuyra sa ida lahi. ");
INSERT INTO bno_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sa sakop it an-om nak adlaw, matrabaho kamo, pero kag pangpitong adlaw ay Adlaw it Inugpahuway, nak sagrado para sa Ako nak GINO-O. Si-o man kag magtrabaho sa Adlaw nak kina ay dapat nak mamatay. ");
INSERT INTO bno_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","“ ‘Kada kinahangyan nak kamong mga Israelinhon ay magsunor sa Adlaw it Inugpahuway, hastang sa pagbalhin it inro mga henerasyon bilang waya't katapusang kasugtanan. ");
INSERT INTO bno_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Bilang GINO-O kali ay tanra Nako sa inrong mga Israelinhon habang panahon, nak sa sakop it an-om nak adlaw ginghuman Nako kag langit ag duta, ag sa pangpitong adlaw Ako ay nagtungon it trabaho ag nagpahuway.’ ” ");
INSERT INTO bno_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Pagkatapos it pagbisaya it GINO-O kang Moises sa Baguntor it Sinay, Ida'y gingta-o kang Moises kag ruhang mayapar nak bato nak nasuyatan it Kasuguan, bilang tanra it Kasugtanan. Kali ay gingsuyat mismo it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Pagkakita it mga tawo nak narugay si Moises sa baguntor, nagtipon sinra kang Aaron ag nagsiling, “Maley, mahimo kita it ato mga dios, nak imaw kag mapanguna sa ato. Tungor rutong Moises nak nagraya sa ato paliwas sa Ehipto, waya nato naaayami kung ni-oy kag natabo sa ida.” ");
INSERT INTO bno_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Nagsabat si Aaron sa inra, “Hala! Pangbay-a kag mga panika nak buyawan sa talinga it inro mga asawa, mga anak nak kayake ag kabade, ag ray-on sa ako.” ");
INSERT INTO bno_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Imaw matuor kag ginghimo it mga tawo. Pinanghukas ninra kag inra mga buyawan nak panika ag ingraya kang Aaron. ");
INSERT INTO bno_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ingbaton kali ni Aaron ag ingtunaw bag-o ingbuhos nida sa usang hurnuhan nak kag kurte ay bata pa nak turong baka. Masunor, ginglinas nida katong ribultong baka. Pagkakita kali it mga tawo, siling ninra, “Imaw kali kag ato dios, mga Israelinhon! Imaw kali kag nagliwas sa ato sa Ehipto.” ");
INSERT INTO bno_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Pagkakita kali ni Aaron, inghimuan nida kali it altar sa atubangan ag nag-anunsyo, “Insulip ay Pista para sa GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Pagkaaga ay temprano pa sinra nagbangon ag nagsunog it ingpadaga, ag inghalar ninra kag iba para sa pagpasag-uli raha sa ribulto. Pagkatapos, nagkinaon, nag-inom, ag malaw-ay kag inra pagkinasadya. ");
INSERT INTO bno_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Myentras rahagto si Moises sa baguntor, nagsiling kag GINO-O sa ida, “Pilhigey, dahil kag imo mga tawo nak imo gingraya halin sa Ehipto ay nagpapaka-sala. ");
INSERT INTO bno_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nayaag nak raan sinra halin sa rayan nak Ako gingsugo sa inra, ag naghulma sinra para sa inra sarili it ribulto nak bata pang turong baka nak buyawan. Ruto sinra giyuhor ag gipadaga sa pagsiling, ‘Mga Israelinhon, imaw kali kag ato dios! Imaw kali kag nagliwas sa ato sa Ehipto.’ ” ");
INSERT INTO bno_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nagsiling pa kag GINO-O kang Moises, “Kilaya Nako kaling mga tawo ag ayam Nakong tugasan sinra it mga uyo. ");
INSERT INTO bno_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Pabad-e Ako! Nahangit nak gador Ako sa inra, kada Ako sinra awagiton. Ag pagkatapos, sa imo mahalin kag usang marakong nasyon.” ");
INSERT INTO bno_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pero nagpakitluoy si Moises sa GINO-O nak ida Dios, “GINO-O, asing abang rako kag Imo kahangit riling Imo mga tawo, nak Imo ginghaw-as sa Ehipto parayan sa rakong gahom it Imo damot? ");
INSERT INTO bno_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Asing masiling kag mga Ehiptohanon nak, ‘Mayain kag plano it Dios sa inrang mga Israelinhon sa pagbaoy sa inra sa Ehipto. Amatyon yang yaki Nida sinra sa kabukiran pramas mawagit sa ibabaw it kalibutan.’ Bad-ey gihangiti sinra. Bag-uha kag Imo plano ag aya gipaaguman sa inra kag Imo marakong kahangit. ");
INSERT INTO bno_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","“Rumruma kag Imo mga suguon nak sina Abraham, Isaac ag Israel, nak Imo ingpangakuan sa Imo sariling pangayan: ‘Ako aparamuon kag inro mga inanak tuyar sa bituon sa langit, ag Ako ita-o sa inro kaling tanang duta nak Ako gingpromisa. Ako ipapanubli kali sa inro mga inanak hastang sa waya't katapusan.’ ” ");
INSERT INTO bno_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ag dahil rili nagbag-o kag GINO-O it Ida plano ag waya matuor Nida gipaaguman kag Ida rakong kahangit sa Ida mga tawo, kumporme sa Ida ingsiling kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ngani, nagpilhig si Moises halin sa baguntor nak raya katong ruhang mayapar nak bato kung hariin nakasuyat kag Kasuguan it Kasugtanan. Katong ruhang bato ay inggwa't suyat sa magkanyudo. ");
INSERT INTO bno_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ag kali ay Dios mismo kag naghimo. Kag suyat nak gingtiltil ruto ay suyat ra mismo it Dios. ");
INSERT INTO bno_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Tong narunggan ni Josue kag pag-inukaw it mga tawo, napasiling sida kang Moises, “Nong, pay nakakarungog ako it inaway sa kampo a!” ");
INSERT INTO bno_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pero nagsabat si Moises, “Buko kali inukaw it pagraog, buko kali panambitan it kapirdihan, kundi pay pagkinasadya yang kag ako narurunggan.” ");
INSERT INTO bno_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tong mayungotey sinra sa kampo sa ubos it baguntor, naantaw ni Moises kag bata pang turong baka nak buyawan ag mga tawong nagsisinadaw. Kada pay nagkayarkar kag ida rugo sa kahangit, ag ida ingpilak sa raga katong ruhang mayapar nak bato kung hariin nakasuyat kag Kasuguan it Dios, ag kali ay nagkabasag. ");
INSERT INTO bno_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ag pagkatapos, ingbaoy nida kag buyawang baka nak inra inghimo ag kali ay ingsunog anay ag gingtumok. Bag-o ida kali ingsabwag sa tubi ag ingpainom sa mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Masunor, nagsiling si Moises kang Aaron, “Manong, ni-o kag ginghimo it kaling mga tawo sa imo nak asing nagpasugot ka nak pangunahan sinra riling rakong kasal-anan?” ");
INSERT INTO bno_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Nagsabat si Aaron, “Moises, bad-ey ako gihangiti, ayam ra nimo nak marali maraya kaling mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Siling ninra sa ako, ‘Himu-e kami it ato mga dios, nak imaw kag mapanguna sa ato. Tungor rutong Moises nak nagraya sa ato paliwas sa Ehipto, wayaey kita it ayam kung nioy kag natabo sa ida.’ ");
INSERT INTO bno_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kada siling nako sa inra, ‘Si-o mang inggwa't buyawang alahas ay hukasa ag taw-an sa ako. Ngani, gingta-o ninra sa ako kag mga buyawan ag ako kato ging-itsa sa kayado, ag kag nagliwas ay imaw kaling bata pang turong baka nak buyawan!’ ” ");
INSERT INTO bno_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Nakita ni Moises nak kag mga tawo ay nagwawala sa pagkinasadya ag gingkunsente ra ni Aaron. Kada sinra ay nabutang sa rakong kahud-anan sa pagmuyat it inra mga kaaway. ");
INSERT INTO bno_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Dahil rili nagtinrog sida sa bungar it kampo, ag nagbisaya it makusog, “Si-o mang tawo kag kampi sa GINO-O ay magpaali sa ako.” Ag tanang mga inanak ni Levi ay nagrinagipon sa ida. ");
INSERT INTO bno_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Masunor, nagsiling sida sa ida mga haling inanak ni Levi, “Mga hali nako, imaw kali kag siling it GINO-O, nak Dios it mga Israelinhon, ‘Itakyos it bawat kayake kag ida talibong. Ag libuton kag bug-os nak kampo, ag pangmatyon ninro kag mga naghimo it kasal-anan aber inro mga hali, mga amigo ag mga kayungot.’ ” ");
INSERT INTO bno_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Gingtuman matuor it mga inanak ni Levi kaling gingsugo sa inra ni Moises, ag katong adlaw nak kato mga tres mil nak tawo kag nagkamatay. ");
INSERT INTO bno_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Pagkatapos, nagsiling si Moises sa inra, “Ngasing nak adlaw, kamong mga lahi ni Levi ay ginggahin para sa pagserbisyo sa GINO-O dahil nagsunor kamo sa Ida aber sa pagpangmatay sa inro mga anak ag mga hali. Ngani, ngasing nak adlaw gingbendisyunan kamo it Dios.” ");
INSERT INTO bno_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Pagkaaga, nagsiling si Moises sa mga tawo, “Mga kasimanwa, nakahimo kamo it rakong kasal-anan. Pero ngasing, ako ay matukar sa GINO-O. Sabaling ako kamo maihagar it kapatawaran sa inro mga sala.” ");
INSERT INTO bno_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ngani, nagbalik matuor si Moises sa GINO-O ag nagsiling, “Amo GINO-O, abang rakong kasal-anan kag nahimo it kaling ako mga kasimanwa. Naghuman sinra it ibang dios nak buyawan para sa inra sarili. ");
INSERT INTO bno_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Pero ngasing, kung maaari, patawara kag inra mga kasal-anan. Pero kung indi, ako yangey kag paya-a sa libro kung hariin inglistay Nimo kag mga pangayan it Imo mga katawuhan.” ");
INSERT INTO bno_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ugaling nagsabat kag GINO-O kang Moises, “Indi puyde. Kung si-o man kag nagkasala laban sa Ako, ay sida yang kag apayaon sa Ako libro. ");
INSERT INTO bno_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ngasing, pagtoy, ag pangunahan kag mga tawo rutong lugar nak Ako gingsiling sa imo, ag apangunahan gihapon kamo it Ako anghel. Pero maabot kag tamang adlaw nak Ako sinra apatagmon nak gador it kaparusahan dahil sa inra nahimong kasal-anan.” ");
INSERT INTO bno_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ag matuor ngani nak nagparaya kag GINO-O it silot sa mga Israelinhon, dahil sa inra ginghimong kasal-anan tong gingpahuman ninra kang Aaron kag ribulto nak bata pang turong baka nak buyawan. ");
INSERT INTO bno_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Pagkatapos, nagsiling ray kag GINO-O kang Moises, “Halin kamo rili. Nuntan kag mga tawo nak imo gingraya paliwas sa Ehipto, ag magpagto kamo sa lugar nak Ako gingpromisa nak ita-o kana Abraham, Isaac ag Jacob, tong nagsiling Ako sa inra nak, ‘Sa inro mga inanak, Ako kali ita-o.’ ");
INSERT INTO bno_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Apaunahon Nako kag anghel sa inro, nak imaw kag matabog sa mga Canaanhon, mga Amornon, mga Hetanhon, mga Pereznon, mga Hebinhon, ag mga Jebusnon nak nag-iistar ruto. ");
INSERT INTO bno_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Pagto kamo sa lugar kung hariin bugana kag pagkaon nak pay nagbabaha kag gatas ag rugos. Pero indi Ako magnunot sa inro baka Ako kamo pangmatyon sa rayanan dahil kamo ay katinugas it uyo.” ");
INSERT INTO bno_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Pagkarungog it mga tawo riling mayain nak balita, nalisor sinra ag waya't usa man sa inra nak nagsuksok it mga alahas. ");
INSERT INTO bno_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Dahil it kato nagsiling kag GINO-O kang Moises, “Silingga kag mga Israelinhon, ‘Kamo ay mga katinugas it uyo, ag kung manunot Ako sa inro aber sa malip-ot yang nak oras, baka pangmatyon Nako kamo. Kada ngasing, hukasa kinang inro mga alahas habang ing-iisip pa Nako kung ni-o kag Ako ahimuon sa inro.’ ” ");
INSERT INTO bno_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ngani, tuna sa Baguntor it Horeb nak ingtatawag rang Baguntor it Sinay, ginghukas it mga Israelinhon kag inra mga alahas sa inra yawas. ");
INSERT INTO bno_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ngasing, batasaney ni Moises nak bay-on kag usang tolda ag patinrugon kali sa liwas sa mayado-yado it kampo. Ida kali ingtawag nak Tolda it GINO-O. Ag si-o man kag inggwa't kinahangyan sa GINO-O ay nagpapagto rutong Tolda nak asa liwas it kampo. ");
INSERT INTO bno_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Pag si Moises ay magliwas papagto rutong Tolda, tanang mga tawo ay natinrog ag nagbabantay sa pwertahan it inra sariling tolda, hastang si Moises ay makasuyor sa Tolda it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Pagkasuyor nida ruto, kag haligi nak rampog ay nagbaba ag nagpabilin sa pwertahan it Tolda. Habang raha pa kina, kag GINO-O ay nagpapakigbisaya kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Pagkakita it mga tawo sa haligi nak rampog nak ruto sa inggwa't pwertahan it Tolda, kada usa sa inra ay nakatulay yang ag nagdadayaw sa GINO-O, tanan nak asa pwertahan it ida tolda. ");
INSERT INTO bno_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Pag natatabo kali, kag GINO-O ay nagbibisaya kang Moises, tuyar sa mag-amigo nak nag-aatubang sa usa'g-usa. Pagkatapos, si Moises ay mabalik sa kampo, pero kag ida suguon nak si Josue, nak anak ni Nun, ay waya gihahalin rutong Tolda it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ngasing, nagsiling si Moises sa GINO-O, “Muyati, gingsugo Nimo sa ako nak, ‘Pamunuan kaling mga tawo,’ pero waya Nimo gipaayaman sa ako kung si-o kag Imo iparaya bilang kanunot nako. Siling pa Nimo, ‘Kilaya ka Nako Moises, ag namumuot Ako sa imo.’ ");
INSERT INTO bno_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kada ngasing, kag ako pangabay, kung talagang namumuot Ka sa ako, tudluan sa ako kag Imo mga parayan agor padayon Ka nako nak akilay-on ag tumanon nak gador kag Imo kabubut-on. Rumruma pati nak kaling nasyon ay Imo mga katawuhan.” ");
INSERT INTO bno_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Sabat it GINO-O, “Kanunot ninro kag Ako Presensya ag ataw-an Nako kamo it kahilwayan.” ");
INSERT INTO bno_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Siling ray ni Moises, “Kung kag Imo Presensya ay buko namo kanunot, bad-ey yangey kami gipahalina rili. ");
INSERT INTO bno_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Dahil pauno masasaduran it ibang mga tawo nak Ikaw ay namumuot sa ako, pati riling Imo mga katawuhan, kung indi Ikaw magnunot sa amo? Ni-o pa kag makakapamatuor nak iba kag Imo pagtratar sa ako ag sa Imo mga katawuhan kisa sa ibang mga tawo sa ibabaw it kalibutan?” ");
INSERT INTO bno_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ag sabat ray it GINO-O kang Moises, “Kaling imo ginghahagar ay Ako nak gador ita-o sa imo dahil namumuot Ako sa imo, ag kilayang gador ikaw Nako Moises.” ");
INSERT INTO bno_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ngasing nagsiling pa si Moises, “Usa pa tan-a nakong pangabay sa Imo, pakitaan sa ako kag Imo kahimayaan.” ");
INSERT INTO bno_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nagsabat kag GINO-O, “Ako ipakita sa imo kag Ako kaaduhan parayan sa Ako pagrayan sa imo atubangan. Ag Ako ay mapakilaya sa imo bilang GINO-O. Gingpapakita Nako kag Ako pagpalangga ag kaluoy sa si-o mang Ako apilion. ");
INSERT INTO bno_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ugaling, indi nimo puyding makita kag Ako uda, dahil waya't tawong puyding makakita sa Ako uda nak mabubuhi pa.” ");
INSERT INTO bno_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ag nagsiling pa kag GINO-O, “Muyati, inggwa't lugar rili mayungot sa Ako kung hariin makakatinrog ka sa rakong bato. ");
INSERT INTO bno_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Habang nagrarayan kag Ako Mahimayaong Presensya, Ako ikaw apasuryon sa siwang it rakong bato. Ag Ako ka atabunan it Ako damot hastang makalampas Ako sa imo. ");
INSERT INTO bno_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Pagkalampas Nako, abay-on Nako kag Ako damot ag likor yangey Nako kag imo makikita. Pero kag Ako uda, indi nimo puyding makita.” ");
INSERT INTO bno_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Pagkatapos, nagsiling kag GINO-O kang Moises, “Tabas it ruhang mayapar nak bato nak tuyar it tong unang mga bato, ag Ako isuyat ruto katong mga Kasuguan nak nakasuyat ruto sa unang mga bato nak imo nabasag. ");
INSERT INTO bno_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Paaga it bati insulip ag maglisto sa pagtukar papagto sa ibabaw it Baguntor it Sinay pramas magpakigkita sa Ako ruto. ");
INSERT INTO bno_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Waya't si-o mang tawo nak manunot sa imo ag wayang gador it tawo nak masuor sa palibot it baguntor. Aber kag mga karnero o baka ay indi giagsam sa ubos it kina.” ");
INSERT INTO bno_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Nagtabas matuor si Moises it ruhang mayapar nak bato nak tuyar it tong unang mga bato. Aga pa tong masunor nak adlaw ay nagtukar sida sa Baguntor it Sinay, raya kag bato, kumporme sa gingsugo sa ida it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Pag-abot nida ruto, nagbaba kag GINO-O sa rampog, ag nagtinrog sa tupar ni Moises, bag-o nagpakilaya nak sida kag GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Masunor, nagrayan kag GINO-O sa atubangan nida, ag nagsiling, “Ako kag GINO-O! GINO-O nak Dios nak maluluy-on ag buko mainak. Buko Ako mahangiton, ag kag Ako rakong pagpalangga ag pagka-matutom ay waya gibabag-o. ");
INSERT INTO bno_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Padayon Nako nak gingtutupar kag Ako promisang pagpalangga sa libo-libong pagbalhin it lahi it Ako mga katawuhan, ag Ako gingpapatawar kag inra mga kayainan, paglaban ag kasal-anan. Ugaling waya Nako gipapalampasa kag kasal-anan it si-o mang tawo. Kag Ako parusa ay tuna sa inra, papagto sa inra mga anak, mga apo, hastang sa inra mga apo sa tuhor ag yapa-yapa.” ");
INSERT INTO bno_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Nagrali-rali si Moises sa pagyuhor nak subsob kag ida uyo sa duta, bag-o nagdayaw. ");
INSERT INTO bno_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Nagsiling sida, “Kung talagang namumuot Ikaw sa ako, GINO-O, ako'y nagpapangabay sa Imo, GINO-O, nak ibhan kami Nimo. Aber kami ay mga tawo nak tugasan it uyo, patawara kag amo mga kayainan ag kasal-anan. Ag kabay pang batunon Nimo kami bilang Imo pag-aari.” ");
INSERT INTO bno_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nagsabat kag GINO-O, “Panimati kamo! Mahimo Ako it Kasugtanan sa inro. Sa atubangan it tanang imo mga kasimanwa, Ako ay mahimo it mga milagro nak waya pang gador natatabo aber riing nasyon sa ibabaw it kalibutan. Kag tanang tawo sa inro palibot ay makakakita it katitingaya nak Ako ahimuon, Ako nak inro GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Tumana kag Ako isugo sa inro ngasing nak adlaw. Ag makikita ninro, Ako atabugon sa inro atubangan kag mga Amornon, mga Canaanhon, mga Hetanhon, mga Pereznon, mga Hebinhon, ag mga Jebusnon. ");
INSERT INTO bno_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Mag-andam kamo nak indi maghimo it kasugtanan sa mga tawo nak inro maaabutan sa lugar nak inro apagtuan, sabaling imaw kali kag inra patibong laban sa inro. ");
INSERT INTO bno_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Guba-a ninro kag inra mga altar, sira-a kag inra mga ingdadayaw nak bato, ag pukana kag inra mga haliging ribulto. ");
INSERT INTO bno_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Aya kamo giyuhor sa ibang dios, kumo Ako nak GINO-O ay nakakabatyag it kahangit pag kag Ako mga katawuhan ay nagyayado kag pagpalangga sa Ako. Dahil kag tuyar nak klase it pag-imon ay talagang imawey kag Ako nababatyagan bilang Dios. ");
INSERT INTO bno_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Ag indi nak gador kamo maghimo it kasugtanan sa mga tawo nak nag-iistar sa lugar nak inro apagtuan. Dahil pag magdayaw ag magpadaga sinra sa inra mga dios ag inra kamo aimbitaron ay matuor nak makaon kamo. ");
INSERT INTO bno_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kag problema, baka pangasaw-on it inro mga binata kag inra mga rayaga, ag pag kaling mga rayaga ay magdayaw sa inra mga dios ay mararaya kag inro mga binata nak anak ag kali ay mabadaey sa Ako. ");
INSERT INTO bno_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Indi kamo maghimo it mga ribulto. ");
INSERT INTO bno_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Ahiwaton ninro kag Pista it Tinapay nak Waya't Pangpaalsa. Sa sakop it pitong adlaw, tinapay nak waya't pangpaalsa kag inro akaunon, kumporme sa Ako gingsugo sa inro. Ahiwaton ninro kali sa buyan it Abib nak Ako gingsiling dahil imaw kali kag buyan tong kamo ay nagliwas sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Tanang panganay nak kayake ay para sa Ako, pati tanang unang anak nak kayake it inro mga hadop, baka o karnero man. ");
INSERT INTO bno_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","“Tanang unang anak it inro asno nak inughalar sa Ako nak GINO-O ay puyding tubuson it anak it karnero, pero kung waya kamo it gustong tubson, inro abalion kag liog it kali. Tanang inro panganay nak anak nak kayake ay dapat ninrong tubuson. “Waya't maatubang sa Ako nak waya't rayang inughalar. ");
INSERT INTO bno_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Sa suyor it an-om nak adlaw puyde kamo nak magtrabaho, pero sa pangpitong adlaw kamo ay mapahuway. Aber tigtanom o tig-ani, dapat nak kamo ay mapahuway. ");
INSERT INTO bno_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Pitong dominggo pagkalipas it Pista it Tinapay nak Waya't Pangpaalsa, ay ahiwaton ninro kag Pista it mga Dominggo kung sauno kag unang panubas it trigo. Ag sa katapusan it tuig, ahiwaton ray ninro kag Pista it Pagpu-po. ");
INSERT INTO bno_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Tatlong beses sa usang tuig, kag inro tanang mga kayake ay dapat mag-atubang sa Ako, nak imaw kag GINO-O, Mananakop ag Dios it mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Dahil Ako atabugon kag mga nasyon sa unahan ninro, Ako apayaparon kag inro duta, ag waya't si-o mang tawo kag makakalanggab it kali pag kamo ay maatubang sa Ako it tatlong beses kada tuig. ");
INSERT INTO bno_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Indi ninro giibhan it tinapay nak inggwa't pangpaalsa kag rugo ag hadop nak inro ihalar para sa Ako. Sa Pista it Pagkaluwas sa Ehipto aya kamo gitura it halin sa hadop nak gingmatay bilang inughalar hastang sa aga. ");
INSERT INTO bno_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ray-on ninro kag pinaka-maadong unang produkto it inro duta sa Ako bayay, nak bayay it GINO-O nak inro Dios. “Indi kamo magyuto it tureting kambing nak waya pa nauutay sa gatas it guyang.” ");
INSERT INTO bno_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Pagkatapos, nagsiling kag GINO-O kang Moises, “Suyatan kaling Ako mga ingbisaya. Parayan rili, ginghimo Nako kag kasugtanan sa imo ag sa mga Israelinhon.” ");
INSERT INTO bno_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Si Moises ay nagtiner ruto kaibahan kag GINO-O sa suyor it kwarentang adlaw ag kwarentang gab-i. Ag waya nak gador sida gikaon o giinom. Ag gingsuyat it GINO-O ruto sa ruhang mayapar nak bato kag mga bisaya sa Kasugtanan, nak imaw kag Sampuyong Kasuguan. ");
INSERT INTO bno_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Pagkatapos, nag-us-os si Moises sa Baguntor it Sinay. Gingraya nida kag ruhang mayapar nak bato nak nasusuyatan it Kasuguan, ag waya nida naaayami nak kag ida uda ay naghahadag dahil sa ida pagpakigbisaya sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Tong nakita nina Aaron ag it mga Israelinhon si Moises, natingaya sinra nak mahadag kag ida uda, kada nahadlok sinra magpayungot sa ida. ");
INSERT INTO bno_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pero ing-ayaba sinra ni Moises, kada sina Aaron ag tanang pinuno it mga Israelinhon ay nagsuor liwat sa ida bag-o nagbisaya sa inra si Moises. ");
INSERT INTO bno_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Pagkatapos, nagsuor ra sa ida kag tanang mga Israelinhon, ag ingta-o nida sa inra kag tanang kasuguan nak gingbisaya sa ida it GINO-O ruto sa Baguntor it Sinay. ");
INSERT INTO bno_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Pagkabisaya ni Moises sa inra, gingtabunan nida it bilo kag ida uda. ");
INSERT INTO bno_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pero kada masuyor sida sa Tolda it GINO-O pramas magpakigbisaya sa GINO-O, ida inahukas kag bilo hastang sa ida pagliwas. Pagliwas nida, ida ray inabisaya sa mga Israelinhon kung ni-o kag gingsugo sa ida it GINO-O, ");
INSERT INTO bno_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ag nakikita ray it mga Israelinhon nak kag ida uda ay mahadag. Ngani, ida ray inasuksok kag bilo hastang sa masunor ray nidang pagpakigbisaya sa GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ngasing gingtipon ni Moises kag tanang Israelinhon ag nagsiling sa inra, “Mga Kasimanwa, kali kag mga gingsugo it GINO-O nak inro dapat sunron: ");
INSERT INTO bno_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","An-om nak adlaw matrabaho kamo, pero sa pangpitong adlaw inro kali agahinon para sa balaang adlaw, Adlaw it Inugpahuway para sa GINO-O. Si-o man kag matrabaho sa adlaw nak kina ay dapat mamatay. ");
INSERT INTO bno_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Aber maghaling it kayado sa inro bayay ay indi ninro gihimuon sa Adlaw it Inugpahuway.” ");
INSERT INTO bno_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Nagsiling gihapon si Moises sa tanang Israelinhon, “Imaw kali kag gingsugo it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kung ni-o kag raha sa inro, maghalar kamo sa GINO-O. Si-o man nak inggwa't gustong ihalar sa GINO-O ay himu-a kina it hugot sa inro tagipusuon ag imaw kali kag mga puyde ninrong ihalar: buyawan, pilak ag bronse, ");
INSERT INTO bno_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","mga bunang nak kulay asul, ubi ag puya, pati mga magandang klase it puting bunang nak lino, bayukag it kambing, ");
INSERT INTO bno_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","mga anit it turong karnero nak ingtina it puya, ag mga pinong anit it isra nak naambit sa yumba-yumba, tabla nak akasya, ");
INSERT INTO bno_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lana it olibo para sa iwag, mga mabangyong buyong para sa inugbanlos nak lana nak ginggagamit it mga saserdote ag para sa mabangyong insenso, ");
INSERT INTO bno_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","mga alahas nak tuyar sa marmol, pati iba pang mamahayong bato nak itakor sa epod ag pangsukyob sa rughan it Pinaka-mataas nak Saserdote.” ");
INSERT INTO bno_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Kag tanang mga maayong panray ay magkatipon agor tumanon kag tanang gingsugo it GINO-O tungor sa mga parti it Toldang Dayawan, nak dapat ninrang himuon tuyar sa: ");
INSERT INTO bno_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","tolda mismo ag sa ida atop, mga kaw-it, mga talinga, mga purma, mga panggakot, mga haligi ag mga tungtungan, ");
INSERT INTO bno_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","kag Balaan nak Kaban ag ida mga pangbadaw, pati kag takyob nak imaw kag Ingkuran it Kaluoy, ag kag kurtina nak panglipor sa Kaban, ");
INSERT INTO bno_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","kag lamesa ag ida mga pangbadaw ag mga gamit, pati kag tinapay nak hinalar sa atubangan it Dios, ");
INSERT INTO bno_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","kag kandilerio ag ida mga gamit, pati kag ida mga iwag ag lana para dili, ");
INSERT INTO bno_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ag kag altar nak sunugan it insenso ag ida mga pangbadaw, kag lana nak pangbanlos it mga saserdote, kag mabangyong insenso, ag kag kurtina para sa pwertahan sa pasuyuron it Toldang Dayawan, ");
INSERT INTO bno_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kag altar nak sunugan it hadop nak inughalar sa Dios, ida parilya nak bronse, ida mga pangbadaw, ag ida tanang gamit, pati kag tipunan it tubi ag ida tungtungan, ");
INSERT INTO bno_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","kag mapinong tela nak kuray sa rayaag, kag mga haligi ag mga tungtungan, pati kag kurtina para sa pasuyuron it rayaag, ");
INSERT INTO bno_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ag kag mga palpal para sa tolda ag para sa kuray, pati kag inra mga higot. ");
INSERT INTO bno_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Sinra ray ra kag matahi it mga baro nak gingsusuksok it mga saserdote nak nagsiserbisyo sa Toldang Dayawan, tuyar sa balaang baro ni Aaron bilang Pinaka-mataas nak Saserdote ag sa ida mga anak nak kayake, sa inra pagserbisyo bilang mga saserdote ra.” ");
INSERT INTO bno_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Pagkatapos, kag tanang mga Israelinhon ay naghaliney sa atubangan ni Moises. ");
INSERT INTO bno_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Kag bawat usa nak gustong maghalar it hugot sa tagipusuon ay nagbalik agor magraya it kali sa GINO-O. Kaling tanan ay ingta-o para sa paghimo it tanang butang sa Toldang Dayawan, para sa mga buluhaton ruto, ag sa mga ingsusuksok it mga saserdote. ");
INSERT INTO bno_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Nagbalik pati kag mga kayake ag kabade nak gustong magta-o it inra mga buyawan nak alahas, tuyar sa mga barpin, panika, singsing, ag aber niong mga butang nak yari sa buyawan. Kaling tanan ay inra ginghalar ag gingkaway sa atubangan it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Inggwa ra it mga nagraya it mga bunang nak kulay asul, ubi ag puya, pati mga magandang klase it puting bunang nak lino, mga bayukag it kambing, mga anit it turong karnero nak ingtina it puya ag mga pinong anit it katong isra nak naambit sa yumba-yumba. ");
INSERT INTO bno_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Katong mga naraya nak pilak ag bronse ay imaw kag inghalar sa GINO-O. Imaw ra kag mga ingraya nak tabla nak akasya nak puyding magamit sa pagtrabaho. ");
INSERT INTO bno_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kag tanang mga kabade nak maayo magyubir it bunang ay nagraya it inra nahumaney nak kulay asul, ubi ag puya, pati kag magandang klase it puting lino. ");
INSERT INTO bno_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Imaw ra kag mga kabade nak maayo ag gustong magyubir it bunang halin sa bayukag it kambing. ");
INSERT INTO bno_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Nagraya ra it mga alahas nak tuyar sa marmol ag iba pang mga mamahayong bato kag mga pinuno, agor itakor sa epod ag sa pangsukyob sa rughan it Pinaka-mataas nak Saserdote. ");
INSERT INTO bno_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Inggwa ra't nagraya it lana it olibo para sa mga iwag sa kandilerio, pati mga mabangyong buyong nak iyakot sa mabangyong insenso ag sa lana nak pangbanlos it mga saserdote. ");
INSERT INTO bno_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ngani, tanang mga Israelinhon nak kayake ag mga kabade nak gustong magta-o it hugot sa tagipusuon ay naghalar sa GINO-O it mga butang nak kali para sa trabaho nak gingsugo sa inra parayan kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Pagkatapos, nagsiling si Moises sa mga Israelinhon, “Hali, gingpili it GINO-O si Besalel nak anak ni Uri, apo ni Hur, halin sa lahi ni Juda. ");
INSERT INTO bno_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Puno sida it Ispirito it Dios, kada ngasing, sida ay inggwa't kaayaman ag abilidad, pati pagkaintyendi tungor sa tanang klase it pagpamanray. ");
INSERT INTO bno_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Maayo sida magplano it mga magandang butang halin sa buyawan, pilak ag bronse. ");
INSERT INTO bno_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Maayo ra sida magtabas it mga mamahayong bato ag magsaysay it mga alahas. Ag inggwa sida it kaayam sa pagkurte it kahoy ag sa tanang klase it pagpamanray. ");
INSERT INTO bno_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Gingpili ra it GINO-O si Oholiab nak anak ni Ahisamac, halin sa lahi ni Dan, nak makabulig ni Besalel sa pagtudlo sa iba it inra naaayaman. ");
INSERT INTO bno_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Gingtaw-an ra it GINO-O kag iba it kaayam pramas matuman kag tanang klase it pagpamanray tuyar sa pagplano it mga magandang butang, pagyubir ag paghaboy it mga bunang nak kulay asul, ubi ag puya, pati pinong puting lino. Kag inra linya ay sa tuyar nak mga trabaho.” ");
INSERT INTO bno_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Ngani, sina Besalel, Oholiab ag tanan nak gingtaw-an it GINO-O it kaayaman ag abilidad sa pagpatugrok it Toldang Dayawan ay dapat magtuman kumporme sa tanang gingsugo it GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Masunor, gingtawag ni Moises sina Besalel, Oholiab ag tanan nak gingtaw-an it GINO-O it kaayaman ag abilidad ag gustong magtrabaho, nak magpayungot sa ida. ");
INSERT INTO bno_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Gingta-o sa inra ni Moises kag tanang mga inghalar it mga Israelinhon agor ipatugrok ninra kag Toldang Dayawan. Adlaw-adlaw ay inggwa pa gihapon it mga nagraraya it hugot sa tagipusuon nak mga halar. ");
INSERT INTO bno_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ngani, sa paglipas it pilang adlaw, nagtungon anay it pagtrabaho kag mga trabahador ag nagpayungot kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Nagsiling sinra, “Subray kag mga gingtata-o it kaling mga tawo nak gamiton sa pagtrabaho, kumporme sa gingsugo it GINO-O sa ato.” ");
INSERT INTO bno_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kada gingsugo ni Moises kag pagbandilyo sa bug-os nak kampo, “Tamaey kag inro paghalar it mga butang para sa paghimo it Toldang Dayawan.” Imaw yang kato kag pagtungon it mga tawo sa pagraya, ");
INSERT INTO bno_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","dahil subray matuor kag inra mga gamiton para sa tanang trabahuon. ");
INSERT INTO bno_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ginghimo it mga maayong manugpanray ag manughaboy kag Toldang Dayawan halin sa sampuyong rolyo it mapinong tela nak inghaboy sa bunang nak puting lino, ag mga bunang ra nak kulay asul, ubi, ag puya. Gingburday ninra rili kag hitsura it mga kerubin nak inggwa't pakpak. ");
INSERT INTO bno_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Tanang rolyo ay pare-pareho it sukat. Kag haba ay katorseng yarda (12 metros) ag kag yapar ay ruhang yarda (2 metros). ");
INSERT INTO bno_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Gingtambi anay ninra kag limang rolyo ag imaw ra katong lima. ");
INSERT INTO bno_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Kag kada habig it kaling ruhang natambey ay inra ginghimuan it mga talinga nak halin sa mga ritasong asul. ");
INSERT INTO bno_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Sa kada usa, singkwentang talinga kag inra gingtahi agor magpares kaling mga talinga. ");
INSERT INTO bno_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Bag-o ginghimo ninra kag singkwentang kaw-it nak buyawan. Imaw kali kag inra ginggamit pramas kaling ruha ay matabo, agor kag Toldang Dayawan ay maging usa. ");
INSERT INTO bno_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Masunor, ginghimo ninra kag onseng rolyong tela nak human sa bayukag it kambing. Imaw kali kag pangibabaw it katong unang tela nak lino sa Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Tanang rolyo ay pare-pareho't sukat. Kag haba ay kinseng yarda (13 metros) ag kag yapar ay ruhang yarda (2 metros). ");
INSERT INTO bno_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Gingtambi anay ninra kaling limang rolyo ag imaw ra kaling an-om. ");
INSERT INTO bno_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Sa kada usa ay inra gingtahian sa habig it singkwentang talinga agor magpares kaling mga talinga. ");
INSERT INTO bno_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Bag-o ginghimo ninra kag singkwentang kaw-it nak bronse. Imaw kali kag inra ginggamit pramas kaling ruha ay magtabo, agor kag Toldang Dayawan ay maging usa. ");
INSERT INTO bno_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Pagkatapos, ginghimo ninra kag inugtakyob sa Toldang Dayawan halin sa anit it turong karnero nak ingtina it puya. Ag kag huli ay ginghimo ninra kag pangibabaw sa tanan, nak human sa pinong anit it katong isra nak naambit sa yumba-yumba. ");
INSERT INTO bno_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ngasing, ginghimo it mga panray kag mga purma nak akasya para sa ringring it tolda. ");
INSERT INTO bno_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kada usang purma, kag taas ay kinseng pye (4 metros) ag kag yapar ay ruhang pye ag tatlong purgada (66 centimetros). ");
INSERT INTO bno_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Kada usang purma ay gingbutangan it tigruhang siki, agor magtabo it maado kag mga purma. Tanang purma ay tuyar kali kag paghimo. ");
INSERT INTO bno_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Tong ginghimo ninra katong mga purma ay beynte kag para sa ringring sa bandang habagatan. ");
INSERT INTO bno_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Gingsaysay ra ninra kag kwarentang tungtungan nak human sa pilak: Ruhang tungtungan para sa kada usang purma ag tig-usa sa kada siki. ");
INSERT INTO bno_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Para sa ringring sa bandang amihan ay ginghimo ra ninra kag beynteng purma. ");
INSERT INTO bno_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Imaw ra kag inra kwarentang tungtungang pilak: Ruhang tungtungan sa irayom it ruhang siki it kada purma. ");
INSERT INTO bno_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Sa parting likor it tolda, bandang sugbuhan, ginghimo ninra kag an-om nak purma, ");
INSERT INTO bno_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","pati ruhang purma para sa ruhang rugo. ");
INSERT INTO bno_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kaling tigruhang purma, nak pangrugo, ay gingtabo halin sa ubos hastang sa ibabaw, ag gingpisan it suksok kag ruhang siki sa usang tungtungan yang. ");
INSERT INTO bno_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ngani, wayo tanan kag purma para sa likor, ag kag inra mga tungtungang pilak ay disi-sais tanan, ruha sa kada purma. ");
INSERT INTO bno_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Naghimo ra sinra it mga panggakot nak mahabang akasya, lima para sa mga purma sa kada habig it tolda, ag lima ra para sa likor it tolda sa bandang sugbuhan. ");
INSERT INTO bno_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Kag haba it panggakot sa tunga ay dapat halin sa usang ugbos hastang sa usang ugbos para sa kada habig ag likor. ");
INSERT INTO bno_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Gingpahuptan ninra kaling tanang purma ag panggakot it buyawan, ag ginghimuan ninra it mga ragkong talinga nak buyawan pramas suksukan it mga panggakot. ");
INSERT INTO bno_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Para sa suyor it Toldang Dayawan, ginghimo ninra kag kurtinang panglipor sa Balaan nak Kaban, ag hinabuyan kali it magandang klasing bunang halin sa puting lino, ag mga bunang ra nak kulay asul, ubi ag puya. Kali ay gingburdahan it hitsura it mga kerubin nak inggwa't pakpak it mga maayo magburda. ");
INSERT INTO bno_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Kali ay inra gingtakor parayan sa mga buyawang kaw-it sa ap-at nak haliging akasya. Kaling mga haligi ay napahuptan it buyawan nak nakatungtong sa ap-at nak tungtungang pilak. ");
INSERT INTO bno_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Bilang pangsara sa pwertahan it Toldang Dayawan, kali ay ginghumanan it kurtina it mga maayo maghaboy, halin sa magandang klasing bunang nak puting lino, ag mga bunang ra nak kulay asul, ubi ag puya. ");
INSERT INTO bno_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Gingsaysay ninra kag mga buyawang pangkaw-it pramas itakor kaling kurtina sa limang haliging akasya nak ingpahuptan it buyawan. Gingsaysay ra ninra kag limang bronse para sa tungtungan it haligi. ");
INSERT INTO bno_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Pagkatapos, ginghimo ni Besalel kag Balaan nak Kaban halin sa akasya nak kahoy. Kag haba it kali ay an-om nak rangaw (3.75 pye o 110 centimetros), ag kag yapar ay ap-at nak rangaw (2.25 pye o 66 centimetros) imaw ra kag taas. ");
INSERT INTO bno_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Gingpahuptan nida kali it purong buyawan sa suyor ag sa liwas, bag-o ingribitihan it buyawan palibot sa yuba. ");
INSERT INTO bno_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ginghimuan nida kali it ap-at nak ragkong talinga nak buyawan sa ida ap-at nak siki, tigruha sa magkanyudong habig. ");
INSERT INTO bno_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Masunor, ginghimo ra nida kag pangbadaw nak akasya ag ingpahuptan kali it buyawan. ");
INSERT INTO bno_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Kaling pangbadaw ay ida gingsuksok sa mga talinga sa magkanyudong habig it kaban agor kali ay puyding badawan. ");
INSERT INTO bno_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Masunor, ginghimo nida kag takyob nak purong buyawan para sa Balaan nak Kaban. Ag kaling takyob ay imaw it naging ingkuran nak ingtatawag nak Ingkuran it Kaluoy. Kag haba it kali ay an-om nak rangaw (3.75 pye o 110 centimetros) ag kag yapar ay ap-at nak rangaw (2.25 pye o 66 centimetros). ");
INSERT INTO bno_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Kag bawat ugbos it kali ay ginghumanan it ruhang ingtatawag nak kerubin nak buyawan, ");
INSERT INTO bno_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","tig-usang kerubin sa bawat ugbos. Ida kali gingpurma sa takyob agor kag ruhang kerubin ag kag ingkuran ay usa yang. ");
INSERT INTO bno_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ginghimo nidang magkaatubang kag ruhang kerubin nak nagmumuyat paubos sa takyob it kaban, nak parehong nakabuka kag pakpak nak gingsisinrungan kag takyob. ");
INSERT INTO bno_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Masunor, inra ginghimo kag lamesa halin sa akasya. Kag haba ay limang rangaw (3 pye o 88 centimetros), kag yapar ay ruha ag tunga (1.5 pye o 44 centimetros), ag kag taas ay ap-at nak rangaw (2.25 pye o 66 centimetros). ");
INSERT INTO bno_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Inra kali gingpahuptan it purong buyawan ag gingribitihan it buyawan sa palibot. ");
INSERT INTO bno_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Inra kali inghimuan it sanipa paibabaw, nak tunga sa rangaw kag yapar (75 milimetros), bag-o ingpahuptan kali ag ingribitihan it buyawan sa palibot. ");
INSERT INTO bno_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Inra kali ginghimuan it ap-at nak ragkong talinga nak buyawan ag ingtakor sa ida ap-at nak pusor sa ibabaw it siki. ");
INSERT INTO bno_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ruto ninra gingtakor kaling mga talinga sa mayungot it sanipa pramas suksukan it pangbadaw it mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ginghimo ra ninra kaling pangbadaw nak akasya ag ingpahuptan it buyawan. ");
INSERT INTO bno_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Masunor, ginghimo ra ninra kag mga gamit para sa lamesa halin sa purong buyawan, tuyar sa mga mayukong ag pinggan, pati mga pitsil ag tasa para sa paghalar it inumon. ");
INSERT INTO bno_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Masunor, ginghimo ninra kag kandilerio nak purong buyawan. Gingsaysay ninra kali it bilog, kag puno ag yawas, ag mga sanga, pati kag mga butangan it iwag sa tunga it pay buskar nak buyak nak inggwa't pilang alimudong sa palibot. ");
INSERT INTO bno_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ginghimuan ninra kali it an-om nak sanga, tigtatlo sa magkanyudo. Kada usa sa an-om nak mga sanga ay ");
INSERT INTO bno_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","nagkainggwa't tatlong kurting buskar nak buyak nak inggwa't pilang alimudong sa palibot bilang pangpaganda. ");
INSERT INTO bno_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Kag yawas it kaling kandilerio ay nagkainggwa't ap-at nak kurting buskar nak buyak nak inggwa't pilang alimudong sa palibot bilang pangpaganda. ");
INSERT INTO bno_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Gingbutangan ra ninra it usang buskar nak buyak sa irayom it kada bukó it pares nak sanga. ");
INSERT INTO bno_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Kag mga buskar nak buyak, alimudong ag sanga ay ginghimo ninrang unay sa yawas ag puno. Bilog kali nak ingsaysay nak purong buyawan. ");
INSERT INTO bno_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bag-o, ginghimo ninra kag pitong iwag para sa kandilerio, pati kag mga gamit sa panglimpyo ag sa pangsayor halin sa purong buyawan. ");
INSERT INTO bno_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Halin sa trentay-kwatrong kilo it buyawan ay inra gingsaysay kag kandilerio ag kag tanang gamit. ");
INSERT INTO bno_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Masunor, ginghimo ninra kag altar halin sa akasya nak sunugan it insenso. Kwadrado kali. Kag haba ag yapar ay ruha ag tungang rangaw (1.5 pye o 45 centimetros) ag kag taas ay limang rangaw (3 pye o 90 centimetros). Ginghumanan ra ninra kag ap-at nak pusor it matagar nak pay sungay kag korte, ag unay sa altar. ");
INSERT INTO bno_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kag ibabaw, kag palibot ag kag mga matagar ay ingpahuptan it purong buyawan. Ag ingribitihan ra it buyawan kag palibot it ibabaw. ");
INSERT INTO bno_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Inra kali inghimuan it ruhang marakong talinga nak buyawan, ag ingtakor sa ida magkanyudong habig sa irayom it ribiti, pramas suksukan it pangbadaw it mga tawo. ");
INSERT INTO bno_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ginghimo ra ninra kaling pangbadaw nak akasya ag gingpahuptan ra kali it buyawan. ");
INSERT INTO bno_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Gingpahimo ra ninra kag balaan, puro ag mabangyong lanang pangbanlos sa mga maayong manughimo it pabangyo. ");
INSERT INTO bno_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Pagkatapos, ginghimo ninra kag altar nak sunugan it hadop nak inughalar sa Dios, halin sa akasya nak kahoy, nak kag taas ay usa ag tungang yarda (2.25 metros). Kwadrado kali ag kag haba ag yapar ay ruha ag tungang yarda (2.25 x 2.25 metros). ");
INSERT INTO bno_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Kag ap-at nak pusor it kali ay ginghimuan ninra it matagar nak pay sungay kag korte, ag kali ay unay sa altar. Bag-o kaling altar ay gingpahuptan it bronse. ");
INSERT INTO bno_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Pagkatapos, ginghimuan ra ninra kag altar it mga gamit nak bronse: Mga butangan it abo, mga pala, mga mayukong, mga marakong tinidor, ag butangan it baga. ");
INSERT INTO bno_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ginghimuan ra ninra it parilyang human sa bronse, nak kag hitsura ay pay lambat. Ag ingsuyor ninra kaling parilya sa altar agor kali ay nakabutang sa pinaka-tungtungan sa tunga it altar. ");
INSERT INTO bno_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ginghuman ra ninra kag ap-at nak ragkong talinga para suksukan it pangbadaw sa ap-at nak pusor it parilya. ");
INSERT INTO bno_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Masunor, naghimo ray sinra it ruhang pangbadaw nak akasya ag gingpahuptan ra it bronse. ");
INSERT INTO bno_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Kaling mga pangbadaw ay inra gingsuksok rutong mga talinga pramas sa magkanyudong habig ay puyding badawan. Kada kag altar nak inra inghuman ay halin sa tabla ag waya't sayog. ");
INSERT INTO bno_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Masunor, ginghimo ninra kag usang tipunan it tubi nak panghugas, nak pay marakong planggana nak inggwa't tungtungan. Ingsaysay ninra kali halin sa bronse nak ginggagamit it mga kabade bilang salamin. Kaling mga salamin ay ginghalar it mga kabade nak nagsiserbisyo sa inggwa't pasuyuron it Tolda it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Masunor, ginghimuan ninra kag Toldang Tipunan it rayaag nak napalibutan it kuray nak mga rolyo it mapinong puting tela nak lino. Sa bandang habagatan ay singkwentang yarda (44 metros) kag haba. ");
INSERT INTO bno_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Kaling mga rolyo it tela nak lino ay ingtakor ninra sa beynteng haligi nak nakatinrog sa beynteng tungtungang bronse. Kag mga pangkaw-it it kali ag kag mga ragkong singsing ay gingsaysay ninra sa pilak. ");
INSERT INTO bno_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Imaw ra kag kuray sa bandang amihan, ay singkwentang yarda (44 metros) kag haba, kag mga rolyo it tela ay nakatakor sa beynteng haligi nak nakatinrog sa tungtungang bronse, ag kag mga pangkaw-it ag ragkong singsing ay ingsaysay sa pilak. ");
INSERT INTO bno_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Sa bandang sugbuhan, beynte singkong yarda (22 metros) kag yapar it rayaag, ag kag rolyo it tela ay nakatakor sa sampuyong haliging nakatinrog sa ida tungtungan, ag kag mga pangkaw-it ag ragkong singsing ay ingsaysay sa pilak. ");
INSERT INTO bno_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Sa bandang subatan kag yapar it rayaag ay beynte singkong yarda ra (22 metros). ");
INSERT INTO bno_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Sa usang habig it pasuyuran ay inghimuan it mga rolyo it tela nak lino nak kag haba ay pitong yarda ag tunga yarda (6.67 metros), ag ingtakor sa tatlong haligi sa ida tungtungan. ");
INSERT INTO bno_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Imaw ra sa usang habig, pitong yarda ag tunga (6.67 metros) kag haba it mga rolyo it tela nak nakatakor sa tatlong haligi ag ida tungtungan. Sa tunga it kali ay rayan pasuyor. ");
INSERT INTO bno_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Tanang rolyo it tela nak nakapalibot sa rayaag ay hinaboy sa mapinong puting lino. ");
INSERT INTO bno_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Kag mga tungtungan it mga haligi ay bronse. Ag kag mga pangkaw-it ag mga ragkong singsing ay pilak. Kag mga haligi ay natakyuban ra it pilak. Tanang haligi sa palibot it rayaag ay inggwa't ragkong singsing nak ingsaysay sa pilak. ");
INSERT INTO bno_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Para sa rayan pasuyor, gingpahabuyan kag kurtinang pangsara halin sa mapinong puting bunang nak lino, ag mga bunang ra nak kulay asul, ubi ag puya, sa mga maayo maghaboy. Kag haba it kali ay sampuyong yarda (9 metros) ag kag taas ay ruha ag tungang yarda (2 metros), tuyar sa palibot nak kuray. ");
INSERT INTO bno_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Bag-o kali ay gingsab-it sa ap-at nak haligi nak nakatinrog sa ida tungtungang bronse. Ag kag mga pangkaw-it ag mga ragkong singsing it kali ay pilak. Natakyuban ra kali it pilak. ");
INSERT INTO bno_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tanang palpal nak ginggamit sa Toldang Dayawan ag sa palibot it rayaag ay bronse. ");
INSERT INTO bno_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Imaw kali kag listahan it tanang buyawan, pilak ag bronse nak nagamit sa Toldang Dayawan ag sa paghimo it Balaan nak Kaban it Kasugtanan. Kag listahang kali ay ingpahimo ni Moises sa mga inanak ni Levi, sa irayom it pamumuno ni Itamar nak anak ni Aaron nak Pinaka-mataas nak Saserdote. ");
INSERT INTO bno_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Tanang gingsugo it GINO-O kang Moises ay gingtuman ni Besalel, nak anak ni Uri, apo ni Hur, halin sa lahi ni Juda. ");
INSERT INTO bno_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Kag nagbulig sa ida ay si Oholiab, nak anak ni Ahisamac, halin sa lahi ni Dan. Sinra ay mga maayong panray, manugplano it magandang butang, ag manughaboy it mga bunang nak kulay asul, ubi ag puya, pati pinong puting lino. ");
INSERT INTO bno_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tanang buyawan nak ginghalar it mga Israelinhon sa GINO-O pramas magamit sa pagpatinrog it Toldang Dayawan ay nag-abot sa mga usang tonelada, kumporme sa taksanan nak ginghahagar sa Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Tanang pilak nak natipon halin sa mga nabilang sa pagpalista it tanang Israelinhon ay umabot sa mga tatlo ag tungang tonelada, kumporme ra sa taksanan nak ginghahagar sa Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Kada usang tawo nak narayanan it pagbilang ay nagbadar it lima ag tungang gramo, kumporme sa taksanan nak ginghahagar it Toldang Dayawan. Kag mga narayanan it pagbilang nak nag-iidad it beynte pataas nak mga kayake ay saisyentos tres mil, kinyentos singkwenta (603,550). ");
INSERT INTO bno_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Imaw kali kag tanang pilak nak nagamit sa kada usang tungtungan it haligi para sa Toldang Dayawan, pati kag pangsara, ay nag-abot sa mga tatlo ag tungang (3,500 kilo) tonelada. Kada usa sa usang gatos nak tungtungan ay naggagamit it treyntay-kwatrong (34) kilo nak pilak. ");
INSERT INTO bno_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ag beynteng (20) kilo nak pilak kag inggamit sa mga pangkaw-it, sa mga singsing, ag sa mga pangtakyob it haligi it kuray. ");
INSERT INTO bno_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tanang bronse nak ginghalar ninra sa GINO-O ay nag-abot sa mga ruha ag tungang (2,500 kilo) tonelada. ");
INSERT INTO bno_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ginggamit ninra kali para sa mga tungtungan it haligi sa pasuyuron it Toldang Dayawan, sa altar nak sunugan it hadop nak inughalar sa Dios, pati sa parilya ag sa tanang gamit sa altar. ");
INSERT INTO bno_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Hali ra ninra gibay-a kag ginggamit sa mga tungtungan it haligi sa palibot it rayaag, ag sa mga tungtungan it haligi para sa kurtinang pangsara sa pasuyuron it rayaag. Imaw ra sa tanang palpal nak inggamit sa Toldang Dayawan, ag sa kuray. ");
INSERT INTO bno_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ginghabuyan nina Besalel it mga baro si Aaron ag iba pang mga saserdote nak nagsiserbisyo sa Toldang Dayawan. Ginghaboy ninra kali halin sa mga bunang nak kulay asul, ubi ag puya, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ginghimo ra ninra kag epod nak waya't butkon halin sa mga bunang nak buyawan ag kulay asul, ubi ag puya, pati mapinong puting lino. ");
INSERT INTO bno_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Kag buyawan ay inra pini-pi anay it manipis, bag-o inghiwa-hiwa it mahaba pramas puyding maging pay bunang, nak inghaboy kaibahan it mga bunang nak kulay asul, ubi ag puya, pati it mapinong puting lino. Kali ay trabaho it mga maayo maghaboy. ");
INSERT INTO bno_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Kag epod ay ginghumanan ninra it ruhang mayapar nak terante, pramas imaw kali kag nagsugrong sa likor ag sa atubangan. ");
INSERT INTO bno_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Kag paha, nak ging-unay ninra sa paghaboy ay halin ra sa mga bunang nak buyawan ag kulay asul, ubi ag puya, pati mapinong puting lino, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Gingtakor ninra sa epod kag ruhang alahas nak tuyar sa marmol sa ida butangang buyawan, nak ingpalibutan it mapinong pinisi-pisi nak buyawan. Tiniltil ruto kag mga ngayan it mga anak ni Jacob nak ingtatawag rang Israel. ");
INSERT INTO bno_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Inra ingtakor kaling ruhang batong alahas sa ruhang terante it epod bilang pagrumrom sa mga anak ni Israel, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Masunor, ginghimuan ra it mga maayo magtahi si Aaron it pangsukyob sa ida rughan. Kag paghimo it kali ay tuyar sa epod nak inghaboy sa mga bunang nak buyawan ag kulay asul, ubi ag puya, pati mapinong puting lino. ");
INSERT INTO bno_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kali ay inapilo agor maging kwadrado. Usang rangaw kag haba (8 purgada o 22 centimetros), imaw ra kag yapar. ");
INSERT INTO bno_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Inra kali gingtakran it ap-at nak lihira it magandang alahas. Sa unang lihira kag mga kulay ay puya, ruyaw ag pus-awon nak berde. ");
INSERT INTO bno_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Sa pangruhang lihira ay kag mga kulay ay tuyar sa pispis nak tangkali, asul nak tuyar sa langit, ag puti. ");
INSERT INTO bno_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Sa pangtatlong lihira ay kag mga kulay ay pus-awon nak kulay-ubi, tuyar sa brawn nak marmol, ag kulay-ubi. ");
INSERT INTO bno_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Sa pang-ap-at nak lihira ay kag mga kulay ay tuyar sa buyak it kayabasa, tuyar sa itom nak marmol, ag berde. Kaling tanan ay ingbutang sa ida butangang buyawan nak ingpalibutan it mapinong pinisi-pisi nak buyawan. ");
INSERT INTO bno_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Tanan-tanan ay doseng magandang alahas. Sa bawat usa ay nakatiltil kag kada ngayan it doseng anak ni Jacob nak ingtatawag rang Israel, nak pinuno it inra lahi. ");
INSERT INTO bno_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Masunor, gingsaysay ninra kag ruhang kadina nak yinubir, halin sa purong buyawan, para sa pangsukyob sa rughan. ");
INSERT INTO bno_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Bag-o gingsaysay ra ninra kag ruhang butangang human sa pinisi-pisi nak buyawan, ag ruhang maragkong talinga nak buyawan. Kali ay inra gingtakor sa ruhang pusor sa ibabaw it pangsukyob sa rughan. ");
INSERT INTO bno_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ag rili gingtakor ninra katong ruhang kadina nak buyawan, ");
INSERT INTO bno_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ag kag ruhang ugbos it kato ay inra ingtakor sa atubangan it ruhang butangan it alahas, sa atubangan it terante it epod. ");
INSERT INTO bno_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Pagkatapos, gingsaysay ray ninra kag ruhang maragkong talinga nak buyawan, para sa ruhang pusor sa ugbos it pangsukyob sa rughan, sa irayom nak lapat sa epod. ");
INSERT INTO bno_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Bag-o gingsaysay ninra kag ruhang maragkong talinga nak buyawan, para sa kilir it epod, kung hariin nagsugrong kag paha. ");
INSERT INTO bno_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kag ruhang talinga it pangsukyob sa rughan ay gingsugrong sa ruhang talinga sa magandang pagkatahi sa paha it epod it higot nak asul, pramas indi magbitin-bitin kag pangsukyob sa rughan, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Pagkatapos, gingpahaboy sa mga maayo maghaboy kag pangirayom sa epod nak puro asul. ");
INSERT INTO bno_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Gingbutangan kali it buho para sa uyo ag gingribitihan kag palibot pramas indi kali magisi. ");
INSERT INTO bno_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Kag gadar it kali ay ginghimuan ninra it pay mga prutas nak granadang halin sa mga bunang nak kulay asul, ubi ag puya, pati mapinong puting lino. ");
INSERT INTO bno_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ginghimuan ra ninra it mga maintik nak bagting nak purong buyawan ag inra kali ingpatunga sa mga granada. ");
INSERT INTO bno_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Kaling mga bagting nak buyawan ag pay mga prutas nak granada ay bay-ot-bay-utan kag pagtakor sa palibot sa gadar it kaling pangirayom nak baro nak yabaw sa epod. Kali ay dapat isuksok ni Aaron pag nagsiserbisyo sida bilang saserdote, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Masunor, gingpahabuyan sa mga maayo maghaboy sina Aaron ag ida mga anak it sutana halin sa mapinong tela nak puting lino. ");
INSERT INTO bno_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Imaw ra kag turban ag mga bugkos sa uyo, pati mga karsunsilyo. ");
INSERT INTO bno_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Gingpahuman ra sa mga maayo maghaboy kag panghagkos halin sa mga bunang nak kulay asul, ubi ag puya, pati mapinong puting lino, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Masunor, gingsaysay ninra kag usang sagradong alahas nak purong buyawan, ag gingtiltil ruto kag bisayang, “Ginahing Balaan Para sa GINO-O.” ");
INSERT INTO bno_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ginghigot ninra kali sa atubangan it turban it pisi nak asul, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ngasing, natapos ninra kag tanang trabahuon sa Toldang Dayawan nak imawey ngasing kaling Tolda it Tipunan. Kali ay gingtuman it mga Israelinhon, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Bag-o gingprisentar ninra kali kang Moises: Kag tolda ag mga kagamitan dili, tuyar sa mga pangkaw-it, mga purma, mga panggakot, mga haligi, ag mga tungtungan; ");
INSERT INTO bno_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kag pangtabon nak human sa mga anit it turong karnero nak ingtina it puya, kag pangtabon nak human sa pinong anit it isra nak naambit sa yumba-yumba, pati kag hinaboy nak kurtina; ");
INSERT INTO bno_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","kag Balaan nak Kaban it Kasugtanan kaibahan kag ida mga pangbadaw, ag kag takyob nak Ingkuran it Kaluoy; ");
INSERT INTO bno_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","kag lamesa, kaumir kag ida mga gamit, ag kag tinapay nak hinalar sa atubangan it Dios; ");
INSERT INTO bno_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kag kandilerio nak purong buyawan, kaumir kag ida mga gamit, pati kag lana para sa mga iwag; ");
INSERT INTO bno_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","kag buyawan nak altar nak sunugan it insenso, kag lanang pangbanlos it mga saserdote, kag mabangyong insenso, pati kag kurtinang pangsara para sa pasuyuran it tolda. ");
INSERT INTO bno_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Gingprisentar ra ninra kag altar nak bronse nak sunugan it hadop nak inughalar sa Dios, kaibahan kag ida parilyang bronse, kag mga pangbadaw, ag tanang ida gamit, pati kag tipunan it tubi ag ida tungtungan. ");
INSERT INTO bno_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Kaibahan raha gingprisentar ninra kag mga rolyo it tela para sa kuray, kag mga haligi kaibahan kag ida tungtungan, pati kag kurtinang pangsara para sa pasuyuran sa rayaag, kag mga pisi ag mga palpal, ag tanan-tanang mga gamit para sa Toldang Dayawan nak imawey ngasing kaling Tolda it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Tong huli gingprisentar ninra kag mga inghaboy nak inugsuksok para kana Aaron ag sa ida mga anak, pag sinra ay nagsiserbisyo sa Toldang Dayawan bilang mga saserdote. ");
INSERT INTO bno_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Gingtuman matuor it mga Israelinhon kag tanang trabahuon, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ag ging-usisa kali tanan ni Moises, ag nakita nida nak inra natuman kag tanang gingsugo it GINO-O, kada gingbendisyunan nida kali. ");
INSERT INTO bno_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ngasing nagsugo ray kag GINO-O kang Moises, ");
INSERT INTO bno_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Sa primerong adlaw it bag-ong tuig, imoy ipatugrok kag Toldang Dayawan, nak imawey ngasing kaling Tolda it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Una isuyor nimo raha kag Balaan nak Kaban it Kasugtanan ag alipran kina it kurtina. ");
INSERT INTO bno_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Masunor, imo isuyor kag lamesa, ag iplastar raha kag mga gamit nida. Bag-o isuyor kag kandilerio ag ihanra kag ida mga iwag. ");
INSERT INTO bno_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Isunor nimo kag buyawan nak altar nak sunugan it insenso sa atubangan it nakurtinahang Balaan nak Kaban it Kasugtanan. Pagkatapos, atakran nimo it kurtinang pangsara kag pasuyuran it Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Masunor, ibutang nimo kag altar nak sunugan it mga hadop nak inughalar sa Dios sa atubangan diretso sa pasuyuran it Toldang Dayawan, nak imawey ngasing kaling Tolda it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ag masunor ray, ay kag tipunan it tubi sa tunga it Toldang Dayawan ag altar, bag-o sudlan kato it tubi. ");
INSERT INTO bno_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Pagkatapos, kurayi kag palibot it rayaag it mga rolyong tela ag atakran it kurtinang pangsara kag rayan pasuyor. ");
INSERT INTO bno_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Pagkatapos, imo abay-on kag lanang pangbanlos it mga saserdote, ag imo abub-an kag Toldang Dayawan ag tanang kagamitan raha. Sa tuyar nak parayan imo agahinon kali para sa balaan nak katuyuan. ");
INSERT INTO bno_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Masunor, abub-an ray nimo kag altar nak sunugan it hadop nak inughalar sa Dios ag tanang gamit raha. Sa tuyar nak parayan imo agahinon kaling altar para sa pinaka-balaan nak katuyuan. ");
INSERT INTO bno_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Pati kag tipunan it tubi ag ida tungtungan ay imo ra abub-an sa paggahin dili sa balaan nak katuyuan. ");
INSERT INTO bno_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Pagkatapos, imo aray-on si Aaron ag kag ida mga kayaking anak sa pwertahan it Tolda it GINO-O ag kaligusan sinra. ");
INSERT INTO bno_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Pagkakaligos, pasuksukan kang Aaron kag mga balaan nak baro, ag imo sida bub-an it lana bilang paggahin, pramas sida ay maserbisyo sa Ako bilang Pinaka-mataas nak Saserdote. ");
INSERT INTO bno_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Masunor, papayunguta ra kag ida mga anak ag pasuksukon sinra it mga sutana. ");
INSERT INTO bno_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ag bub-an ra nimo sinra it lana tuyar sa imo inghimo sa inra tatay, agor sinra ay maserbisyo sa Ako bilang mga saserdote. Kaling paggahin sa inra bilang mga saserdote ay mapadayon hastang sa pagbalhin it inra mga henerasyon.” ");
INSERT INTO bno_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Gingtuman matuor ni Moises kag tanang gingsugo sa ida it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ngani, sa primerong adlaw it bag-ong tuig, nak imaw kag pangruhang tuig tuna tong naghalin sinra sa Ehipto, kag Toldang Dayawan ay naplastarey. ");
INSERT INTO bno_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Tong gingplastar kali ni Moises, ida ging-una it plastar kag mga tungtungan it haligi para sa tolda. Bag-o gingpatinrog raha kag mga purma, gingsuksok kag mga panggakot, ag gingpatinrog kag mga haligi. ");
INSERT INTO bno_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Masunor, ida gingbukyar kag mga pang-atop sa pangibabaw it Tolda ag gingkamada kag ap-at nak klase it atop, tuyar sa gingsugo it GINO-O sa ida. ");
INSERT INTO bno_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Masunor, gingbaoy nida kag ruhang mayapar nak bato nak nasuyatan it kasuguan ag gingsuyor sa Balaan nak Kaban. Gingsuksok nida kag ruhang pangbadaw it Kaban ag gingtakyuban kali it Ingkuran it Kaluoy. ");
INSERT INTO bno_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ag pagkatapos ay gingsuyor kali sa Toldang Dayawan ag ginglipran it kurtina, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Masunor, ida gingbutang kag lamesa sa liwas it kurtina sa bandang amihan sa suyor it Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ida ray ingplastar kag tinapay raha sa atubangan it GINO-O, kumporme sa gingsugo Nida sa ida. ");
INSERT INTO bno_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Masunor, ida gingbutang kag kandilerio nak nakaatubang sa lamesa, sa bandang habagatan sa suyor it Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ida ginghanra kag mga iwag sa atubangan it GINO-O, kumporme ra sa gingsugo Nida kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Tong huli ay ida ingbutang kag buyawan nak altar nak sunugan it insenso sa liwas yang it kurtina sa tungor it Balaan nak Kaban. ");
INSERT INTO bno_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Nagsunog sida raha it mabangyong insenso, kumporme sa gingsugo it GINO-O sa ida. ");
INSERT INTO bno_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Bag-o gingsarhan it kurtina kag pwertahan it Toldang Dayawan. ");
INSERT INTO bno_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Pagkatapos, gingbutang nida kag altar nak sunugan it hadop nak inughalar sa Dios sa atubangan diretso sa pasuyuran it Toldang Dayawan, nak imawey ngasing kaling Tolda it GINO-O. Ag ruto sida gisunog it mga hadop ag mga uyas nak inughalar, kumporme sa gingsugo it GINO-O sa ida. ");
INSERT INTO bno_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Masunor, ida gingbutang kag tipunan it tubi sa tunga it Tolda it GINO-O ag altar, bag-o ingbutangan it tubi nak inugpanghinaw. ");
INSERT INTO bno_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Hali sina Moises, Aaron ag ida mga anak nak kayake gipapanghinaw. ");
INSERT INTO bno_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Napanghinaw anay sinra kada masuyor sa Tolda it GINO-O ag kada mapayungot sa altar nak sunugan it mga hadop nak inughalar sa Dios, kumporme sa gingsugo it GINO-O kang Moises. ");
INSERT INTO bno_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Pagkatapos, gingkurayan ni Moises kag rayaag palibot sa Tolda it GINO-O ag sa altar bag-o gingsarhan it kurtina kag rayan pasuyor it rayaag. Tuyar kali kag pagtapos ni Moises sa tanang trabahuon. ");
INSERT INTO bno_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","35","Pagkatapos, nagbaba katong rampog ag nalibon kag Toldang Dayawan, nak imawey ngasing kaling Tolda it GINO-O, ag kali ay napuno it kahimayaan it GINO-O. Kada indi ruto makasuyor si Moises dahil nagtiner sa Tolda kag kahimayaan it GINO-O. ");
INSERT INTO bno_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ag sa oras nak nagpapaibabaw katong rampog sa Toldang Dayawan ag pay nagpapanaw, ay imaw pa yang ray kato kag pagginan it mga Israelinhon. ");
INSERT INTO bno_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pero kung kag rampog ay waya gipapaibabaw ag pay waya gipapanaw, ay indi ra sinra maginan hastang kali ay magpaibabaw ray ag pay nagpapanaw ray. ");
INSERT INTO bno_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kada kag rampog it GINO-O ay asa ibabaw it Toldang Dayawan kung adlaw, ag kung gab-i ay rampog nak pay nagkakayado. Nakikita kali permi it mga Israelinhon sa inra mga pagpanaw.");
INSERT INTO bno_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Imaw kali kag lahi nak inghalinan ni Hesu-Kristo, parayan sa mga inanak ni David ag halin ra sa mga inanak ni Abraham: ");
INSERT INTO bno_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham kag tatay ni Isaac, ag si Isaac ray kag tatay ni Jacob. Si Jacob kag tatay ni Juda ag ida mga haling kayake. ");
INSERT INTO bno_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Kaling si Juda kag tatay nina Pares ag Zara, ag kag inra nanay ay si Temar. Si Pares ray kag tatay ni Esron, ag si Esron kag tatay ni Aram. ");
INSERT INTO bno_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram kag tatay ni Aminadab, ag si Aminadab kag tatay ni Naason nak tatay ray ni Salmon. ");
INSERT INTO bno_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon kag tatay ni Booz, ag kag ida nanay ay si Rahab. Si Booz ray kag tatay ni Obed, ag kag ida nanay ay si Ruth. Si Obed kag tatay ni Jese, ");
INSERT INTO bno_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ag sida kag naging tatay ni Haring David. Masunor, si David kag tatay ni Solomon. Ag kag ida nanay ay katong dating asawa ni Urias. ");
INSERT INTO bno_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon kag tatay ni Rehoboam, ag si Rehoboam ray kag tatay ni Abias nak tatay ni Asa. ");
INSERT INTO bno_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa kag tatay ni Jehosafat, ag si Jehosafat ray kag tatay ni Joram nak tatay ni Ozias. ");
INSERT INTO bno_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Ozias kag tatay ni Jotam, ag si Jotam ray kag tatay ni Ahaz nak tatay ni Esequias. ");
INSERT INTO bno_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esequias kag tatay ni Manases, ag si Manases ray kag tatay ni Amon nak tatay ni Josias. ");
INSERT INTO bno_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Kaling si Josias kag tatay ni Jeconias ag ida mga hali nak kayake. Katong kapanahunan ninra, kag mga Israelinhon ay ingbihag ag ingraya paliwas sa Herusalem papagto sa mayadong bansa it Babilonya. ");
INSERT INTO bno_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pagkatapos it inra pagkaraya sa Babilonya: Si Jeconias kag tatay ni Salatiel, ag si Salatiel ray kag tatay ni Zorobabel. ");
INSERT INTO bno_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Zorobabel kag tatay ni Abiud, ag si Abiud ray kag tatay ni Eliaquim nak tatay ni Azor. ");
INSERT INTO bno_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Azor kag tatay ni Sadoc, ag si Sadoc ray kag tatay ni Aquim nak tatay ni Eliud. ");
INSERT INTO bno_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud kag tatay ni Eleazar, ag si Eleazar ray kag tatay ni Matan nak tatay ni Jacob. ");
INSERT INTO bno_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Kaling si Jacob kag naging tatay ni Jose. Ag si Jose kag naging asawa ni Maria nak imaw kag nanay ni Hesus, nak ingtatawag nak Kristo. ");
INSERT INTO bno_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ngani, kaling inghalinan ni Hesu-Kristo ay nagpapakita nak inggwa it katorseng henerasyon magtuna kang Abraham hastang kang Haring David, katorse rang henerasyon magtuna kang Haring David hastang kag mga Israelinhon ay ingbihag ag ingraya paliwas sa Herusalem papagto sa mayadong bansa it Babilonya, ag katorse ray ra magtuna it katong pagkaraya sa inra sa Babilonya hastang sa pagkatawo kang Kristo. ");
INSERT INTO bno_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ngasing, tuyar kali kag parayan kung pauno ing-anak si Hesu-Kristo. Si Maria nak Ida nanay ag si Jose ay nagpamayadey. Pero bag-o sinra kasayon, nasaduran ninra nak sabakey si Maria sa parayan it gahom it Ispirito Santo. ");
INSERT INTO bno_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si Jose nak ida magiging asawa ay usang maadong tawo nak nagtutuman sa Dios. Ag dahil ngani sa tuyar nak kamutangan ni Maria, ay ida naisip nak buyagan kali myentras waya pa it nakakasador nak iba, dahil waya sida it gusto nak mapahuda si Maria. ");
INSERT INTO bno_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Habang ing-iisip nida kaling ida plano, nagpakita sa ida kag usang anghel it Ginoong Dios parayan sa pananamgo ag nagsiling sa ida, “Jose, inanak ni David, aya giruha-ruha sa pagpakasay kang Maria, kumo parayan sa gahom it Ispirito Santo kag ida pagsabak. ");
INSERT INTO bno_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sida ay maanak it kayake ag apangayanan nimo Sidang Hesus, dahil Sida kag maluwas sa Ida mga katawuhan sa inra mga kasal-anan.” ");
INSERT INTO bno_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Natabo kaling tanan para matuman kag ingpasiling it Ginoong Dios sa propeta it kato nak, ");
INSERT INTO bno_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Masabak kag usang birhen nak rayaga ag maanak it kayake, ag atawagon nak Emmanuel.” (Kag gustong bisayahon it pangayan nak Emmanuel ay “kaibahan nato kag Dios.”) ");
INSERT INTO bno_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pagbati ni Jose, ingtuman nida kag sugo it anghel it Gino-o ag ingpakasayan nida si Maria. ");
INSERT INTO bno_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero waya sinra giubay hastang waya pa naanak si Maria. Ag katong nag-anakey si Maria it kayake ay ingpangayanan kali ni Jose nak Hesus. ");
INSERT INTO bno_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Si Hesus ay ing-anak sa banwa it Betlehem sa probinsya it Hudeya. Kag hari it kato ay si Herodes. Pagkaanak kang Hesus, inggwa it nag-inabot sa syudad it Herusalem halin sa subatan. Kaling mga tawo ay maayam magbasa it gustong bisayahon it mga bituon. ");
INSERT INTO bno_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pag-abot ninra ruto, sinra ay nagpinangutana, “Hariiney kag ing-anak nak magiging hari it mga lahi it Hudyo? Tong hagto kami sa amo lugar sa subatan, nakita namo kag bituon nak tanra it Ida pagkatawo, kada nagpali kami para dayawon Sida.” ");
INSERT INTO bno_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Katong narunggan kali ni Haring Herodes, nalibog sida, ag imaw ra kag tanang taga-Herusalem. ");
INSERT INTO bno_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kada ingtipon ni Haring Herodes kag tanang Punong Saserdote ag mga Manunudlo it Kasuguan, ag ingpangutana sa inra kung hariin gianakan kag gingpromisang Kristo. ");
INSERT INTO bno_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nagsabat sinra, “Sa Betlehem sa probinsya it Hudeya, dahil ngani tuyar kali kag ingsuyat it propeta it katong una,” ");
INSERT INTO bno_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Ikaw, Betlehem sa duta it lahi ni Juda, aber ikaw ay maisot nak baryo, ikaw kag magiging pinaka-importante, dahil sa imo mahalin kag usang punong marumaya sa Ako katawuhan nak banwang Israel.’ ” ");
INSERT INTO bno_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tong narunggan kali ni Haring Herodes, gingpatawag nida it pasikreto katong mga tawong halin sa subatan ag ida ing-ayam kung kauno unang nagpakita kag bituon. ");
INSERT INTO bno_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ag pagkatapos sinra ay ida gingsugo pa-Betlehem ag nagsiling, “Pagtoy ag hanapon nak gador katong anak, ag pag makita ninro, balik nak raan kamo dili ag umaan ako, agor ako ay makapagto ag makadayaw ra sa ida.” ");
INSERT INTO bno_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pagkarungog ninra sa ingsiling it hari, nagginaney katong mga halin sa subatan ag nakita ray ninra liwat katong bituon nak inra dating nakita habang hagto pa sinra sa inra lugar sa subatan. Sinra ay ingpangunahan it bituon ag kali ay nagpundo pag tungor rutong bayay kung hariin katong Anak. ");
INSERT INTO bno_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Abang rako kag inra kasadya dahil nakita ray ninra katong bituon. ");
INSERT INTO bno_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pag-abot ninra ruto, nagsuyor sinra sa bayay ag nakita ninra kag Anak ag Ida nanay nak si Maria. Nagyuhor sinra ag nagdayaw sa Anak. Masunor, ingbuksan ninra kag inra mga mamahayong regalo nak buyawan, mabangyong insenso ag mira ag ingta-o kali sa Anak. ");
INSERT INTO bno_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","It katong pabalikey sinra kang Haring Herodes, ingpaandaman sinra it Dios parayan sa pananamgo nak indiey gibalik. Kada nag-iba yangey sinra it rayan papauli sa inra sariling lugar. ");
INSERT INTO bno_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pagkahalin it kinang mga tawong halin sa subatan, nagpakita kag anghel it Ginoong Dios kang Jose parayan ray sa pananamgo ag nagsiling, “Bangon, ag ray-on nak raan kag Anak ag Ida nanay sa Ehipto. Ruto yang anay kamo hastang waya pa kamo Nako nasilingga. Dahil siguradong ipahanap nak gador ni Haring Herodes kag Anak para matyon.” ");
INSERT INTO bno_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Rali-rali it bangon si Jose sa gab-i nak kato ag ingraya kag Anak ag Ida nanay papagto sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ruto sinra giistar hastang mamatay si Haring Herodes. Kali ay natabo pramas matupar kag ingpasiling it Ginoong Dios it kato parayan sa propeta, “Halin sa Ehipto ay ingtawag Nako kag Ako Anak.” ");
INSERT INTO bno_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Katong naayaman ni Haring Herodes nak sida ay ingluko it katong mga tawong halin sa subatan, abang kahangit nida. Kada ingsugo nida nak ipamatay kag tanang mga anak nak kayake sa Betlehem ag sa mga kayungot nak lugar nak kag edad ay ruhang tuig paubos, dahil imaw kina kag edad it kinang anak basi sa ida bilang tuna tong nakita ninra katong bituon. ");
INSERT INTO bno_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kada natupar kag ingpasiling it Dios parayan kang Propeta Jeremias nak, ");
INSERT INTO bno_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Abang kusog nak tibaw ag panambitan kag narurunggan sa lugar it Rama, Ingtitibawan ni Raquel kag ida mga anak. Inding gador sida magpaamo-amo, dahil namatayey sinrang tanan.” ");
INSERT INTO bno_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pagkamatay ni Haring Herodes, nagpakita ray kag usang anghel it Ginoong Dios sa pananamgo ni Jose hagto sa Ehipto, ");
INSERT INTO bno_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ag nagsiling ray sa ida, “Bangon, ag ray-on kag Anak ag Ida nanay papauli sa inro bansang Israel, dahil minatayey kag mga tawong gustong magpamatay sa Anak.” ");
INSERT INTO bno_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kada, nagbangon sida ag ingraya nida kag Anak ag Ida nanay pabalik sa Israel. ");
INSERT INTO bno_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero pag-abot ninra ruto, narunggan nida nak kag anak ni Haring Herodes nak si Arquelao ay imaw kag nagsubli nak hari sa probinsya it Hudeya, ag nahadlok sida, kada waya sida igbalik ruto. Ag natabo ray nak ingpaandaman sida it Dios parayan sa pananamgo, kada naglikaw sida papagto sa probinsya it Galileya. ");
INSERT INTO bno_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ag ruto sinra nag-istar sa banwa it Nazaret. Kada natupar kag ingpasiling it Dios parayan sa mga propeta it kato nak, “Atawagon Sidang taga-Nazaret.” ");
INSERT INTO bno_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Katong panahong kato, nagpagto si Juan nak Manugbawtismo sa mayangkag nak kabukiran it Hudeya, ag hagto sida nagbabantala nak, ");
INSERT INTO bno_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Maghinuysoy kamo! Mayungotey kag paghari it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kaling si Juan kag ingpapatungran ni Propeta Isaias katong nagsiling sidang, “Inggwa't usang nagbabantala it makusog sa mayangkag nak kabukiran nak nagsisiling, ‘Ihanra ninro kag arayanan it Gino-o, Tadlunga kag Ida mga rayanan.’ ” ");
INSERT INTO bno_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kag suksok ni Juan ay human sa yinayang balahibo it kamelyo ag kag ida panghagkos ay human sa anit it hadop, ag kag ida pagkaon ay mga apan-apan ag rugos. ");
INSERT INTO bno_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Katong panahon nak kato ay maramong tawo halin sa syudad it Herusalem, sa bug-os nak probinsya it Hudeya ag ruto ra hampig sa Suba it Jordan ay nagpipinagto sa ida. ");
INSERT INTO bno_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ingpahadag anay ninra kag inra mga kasal-anan bag-o ingbabawtismuhan sinra ni Juan sa Suba it Jordan. ");
INSERT INTO bno_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero katong nakita nida kag mga Pariseo ag Saduseo nak nagsusuor sa ida para magpabawtismo, ingbisar-an nida sinra. Siling nida, “Kamong mga tusong tawo! Sin-o kag nagpaandam sa inro nak makakaiwas kamo sa paabutong parusa it Dios kung kamo ay mapabawtismo? ");
INSERT INTO bno_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kung klarong kamo ay naghinuysoyey ay ipakita kina ninro parayan sa inro maadong buhat. ");
INSERT INTO bno_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aya ninro giisipa nak porke si Abraham kag inro inghalinan ay makakaiwasey kamo sa parusa. Ingsisiling nako sa inro nak kaya ra it Dios nak maghuman it mga magiging inanak ni Abraham halin sa mga bato nak kali. ");
INSERT INTO bno_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kag parusa it Dios sa inro ay tuyar sa wasay nak nakahanaey sa pinaka-ugat it puno. Ag bawat puno nak waya gipapamunga it maado ay apukanon yangey ag ahimuong rabok. ");
INSERT INTO bno_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ingbabawtismuhan nako kamo sa tubi pramas ipakita nak kamo ay naghinuysoyey. Pero inggwa it usang paabuton nak mas yabaw pa kisa sa ako ag aber sa pagbaoy it Ida sandalyas ay buko ako angay. Sida kag mabawtismo sa inro it Ispirito Santo ag kayado. ");
INSERT INTO bno_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sida ay puyding ikumpara sa usang manugpakuyay nak ibuyag kag mga upa sa timgas. Ahawanan anay nida kag apakuyadan, ag tipunoney nida kag timgas sa ida usunan ag asunugon kag upa sa kayado nak indi mapayong-payong.” ");
INSERT INTO bno_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","It katong nagbabawtismo pa si Juan sa Suba it Jordan, si Hesus ay nagpagto ra ruto sa ida halin sa Galileya pramas magpabawtismo ra. ");
INSERT INTO bno_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero mapaindi tan-a si Juan sa pagsiling nak, “Asing gusto Nimong magpabawtismo sa ako? Ako kag dapat magpabawtismo sa Imo.” ");
INSERT INTO bno_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero ingsabat sida ni Hesus, “Himu-a yangey kali. Tama yang nak mahimo kali para matuman kag tanang kabubut-on it Dios.” Kada nagsugot si Juan ag ingbawtismuhan si Hesus. ");
INSERT INTO bno_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagkatapos it bawtismo kang Hesus, nagtakas nak raan Sida sa tubi. Pagtakas nida, nagbuka kag langit, ag nakita Nida kag Ispirito it Dios nak nagbababa tuyar sa usang salumpati, ag nag-apon kali sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ag inggwa't usang Boses halin sa langit nak nagsiling, “Kali kag Ako pinalanggang Anak, nak Ako namumut-an.” ");
INSERT INTO bno_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagkatapos it bawtismo kang Hesus, ingraya Sida it Ispirito Santo sa mayado ag mayangkag nak kabukiran para tintaron ni Satanas. ");
INSERT INTO bno_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nagpuasa Sida sa suyor it kwarentang adlaw ag kwarentang gab-i, ag ginutom nak gador Sida. ");
INSERT INTO bno_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ngasing, nag-abot kag Tintador nak si Satanas ag nagsiling sida kang Hesus, “Kung Ikaw kag matuor nak Anak it Dios, sugu-a kaling mga bato nak maging tinapay.” ");
INSERT INTO bno_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero nagsabat si Hesus, “Nakasuyat sa Sagradong Kasuyatan nak, ‘Buko yang sa pagkaon nabubuhi kag tawo kundi sa bawat bisaya it Dios.’ ” ");
INSERT INTO bno_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Masunor ay ingraya Sida ni Satanas sa ingtatawag nak sagradong syudad it Herusalem, ag Sida ay ingpatinrog sa pinaka-tumbo it Templo, ");
INSERT INTO bno_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ag nagsiling sa Ida, “Kung matuor Kang Anak it Dios, yukso, dahil nakasuyat sa Sagradong Kasuyatan, “ ‘Asuguon it Dios kag Ida mga anghel nak kuguson ag rahanan Ka pramas kag Imo siki ay indi magtama sa bato.’ ” ");
INSERT INTO bno_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nagsabat si Hesus sa ida, “Nakasuyat ra sa Sagradong Kasuyatan, ‘Daey igpurbahe kag GINO-O nak inro Dios.’ ” ");
INSERT INTO bno_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagkatapos, ingraya ray Sida ni Satanas sa pinaka-tumbo it abang taas nak baguntor ag ingpakita sa Ida kag tanang gingharian it kalibutan ag tanang kamanggaran it kali. ");
INSERT INTO bno_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ag nagsiling si Satanas sa Ida, “Ita-o nako kaling tanan sa Imo kung mayuhor Ka ag madayaw sa ako.” ");
INSERT INTO bno_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero nagsabat si Hesus sa ida, “Satanas, layas! Nakasuyat sa Sagradong Kasuyatan, ‘Kag Ginoong Dios yang kag imo dapat dayawon, ag Sida yang kag imo dapat serbisyuhan.’ ” ");
INSERT INTO bno_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pagkatapos it kali, naghalin si Satanas sa Ida ag nag-inabot kag mga anghel para asikasuhon Sida. ");
INSERT INTO bno_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pagkarungog ni Hesus nak napriso si Juan nak Manugbawtismo, nagbalik Sida sa probinsya it Galileya. ");
INSERT INTO bno_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero bukoey Sida sa Nazaret giistar, kundi nagsaydo Sida sa syudad it Capernaum sa habig it Ragat it Galileya, sa lugar it mga inanak nina Zabulon ag Naptali. ");
INSERT INTO bno_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Parayan sa Ida pag-istar raha ay natupar kag ingpasiling it Dios parayan kang Propeta Isaias it kato nak, ");
INSERT INTO bno_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kag duta nak Zabulon ag Naptali ay nararayanan papagto sa ragat, patabok sa Suba it Jordan, sa lugar it Galileya kung riin nag-iistar kag maramong buko Hudyo. ");
INSERT INTO bno_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kag mga tawo hagto nak pay nabubuhi sa karuymanan, ay kamatayon yang kag inra ingpapaabot. Pero nakikitaey ninra kag paabutong kasusiga nak kahadagan, ag pay tuyar sa pagsubat it adlaw sa aga, kali ay maabot ag mapahadag sa inra isip.” ");
INSERT INTO bno_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tuna it kato, ingtunaan ni Hesus kag Ida pagbantala nak, “Maghinuysoy kamo, dahil mayungotey kag paghari it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Usang adlaw, habang nagpapanaw si Hesus sa habig it Ragat it Galileya, nakita Nida kag ruhang magmanghor nak sina Simon nak ingtatawag rang Pedro, ag si Andres. Sinra ay nagpapangyada dahil mangingisra sinra. ");
INSERT INTO bno_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ing-ayaba sinra ni Hesus, “Maley! Sunor kamo sa Ako! Atudluan Nako kamo kung pauno makaraya it mga tawo nak masunor sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sa nak raan, ingbadaan ninra kag inra pagpangisra ag nagsunor sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nagpadayon sina Hesus it pagpanaw halin ruto ag nakita ray Nida kag ruhang magmanghor nak sina Santiago ag Juan nak mga anak ni Zebedeo. Sa rayapang sinra kaibahan kag inra tatay nak nagtatahi it inra lambat. Ing-ayaba ra sinra ni Hesus nak magsunor sa Ida, ");
INSERT INTO bno_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ag sa nak raan, ingbilin ninra kag inra tatay ag inra rayapang ag nagsunor sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Inglibot nina Hesus kag bug-os nak probinsya it Galileya, ag nagtutudlo sa mga sinagoga ag nagbabantala it Maadong Balita tungor sa paghari it Dios sa kabuhi it tawo. Ingpaado ra Nida kag tanang klasi it sakit ag nababatyagan it tawo. ");
INSERT INTO bno_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kada nabantog Sida sa bug-os nak bansa it Sirya, ag rinaya sa Ida kag tanang inggwa't nababatyagan ag iba't-ibang klasi it sakit, mga nakakabatyag it hapros, mga tawong ingsasaniban it mayaot, mga di tigbak ag mga yupog, ag Ida ingpaado sinrang tanan. ");
INSERT INTO bno_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kada ngani ingsunran Sida it maramong tawo halin sa probinsya it Galileya, sa Sampuyong Syudad sa lugar it Decapolis, sa syudad it Herusalem, sa probinsya it Hudeya ag sa yudo it Suba it Jordan. ");
INSERT INTO bno_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Usang adlaw, tong nakita ni Hesus kag abang ramong tawo, nagtukar Sida sa usang baguntor ag nag-ingkor. Pagkaingkor Nida, nagpayungot sa Ida kag Ida mga manugsunor. ");
INSERT INTO bno_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ag nagtuna Sida it pagtudlo sa inra sa pagsiling: ");
INSERT INTO bno_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Abang buynas kag mga nag-aako nak sinra ay waya it mahihimo kung waya kag bulig it Dios, dahil kabilang sinra sa mga inghaharian it Dios! ");
INSERT INTO bno_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Abang buynas kag mga nalilisor, dahil aramayan sinra it Dios. ");
INSERT INTO bno_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Abang buynas kag mga mapainubuson, dahil mabaton sinra it tanang ingpromisa it Dios. ");
INSERT INTO bno_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Abang buynas kag mga naghahanrom nak magtuman sa kabubut-on it Dios, dahil ita-o sa inra it Dios kag inra inghahanrom! ");
INSERT INTO bno_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Abang buynas kag mga maluluy-on, dahil akaluy-an ra sinra it Dios! ");
INSERT INTO bno_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Abang buynas kag mga malimpyo it tagipusuon, dahil makikita ninra kag Dios! ");
INSERT INTO bno_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Abang buynas kag mga nagpapatigayon para mag-ado kag relasyon it inra mga isigkatawo, dahil abilangon sinrang mga anak it Dios! ");
INSERT INTO bno_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Abang buynas kag mga gingpapahirapan, dahil sa inra pagtuman sa kabubut-on it Dios, kumo sinra ay kabilang sa mga inghaharian it Dios!” ");
INSERT INTO bno_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Abang buynas kamo kung dahil sa inro pagsunor sa Ako kamo ay inglilibak it mga tawo, ingpapahirapan, ag ingbibisayahan it waya't kaklaruhan! ");
INSERT INTO bno_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ngani, magkinasadya kamo, dahil karako kag inro mababatong premyo sa langit, kumo kag inra inghihimo sa inro ay tuyar ra sa inghimo sa mga propeta it kato!” ");
INSERT INTO bno_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nagpadayon si Hesus sa Ida pagtudlo ag nagsiling: “Kamo nak Ako mga manugsunor ay tuyar sa asin sa kalibutan. Pero kung mawar-an it lasa kag asin, ay pauno pa kali mapapaasin ray liwat? Wayaey kina it puyos, kada ipilak yangey ag adama-damaan it mga tawo. ");
INSERT INTO bno_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kamo ra ay tuyar sa iwag sa kalibutan. Ag tanra-e ninro nak kag syudad nak nakatugrok sa ibabaw it baguntor ay indi maitago. ");
INSERT INTO bno_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ag waya ra it nagsusuga it iwag ag ibutang sa irayom it gantangan, kundi ingbubutang sa tamang butangan agor mahahadagan kag tanan nak nasasakupan. ");
INSERT INTO bno_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ag tuyar ra, pahadaga kag inro iwag sa atubangan it mga tawo agor makita ninra kag inro maadong buhat ag dayawon kag inro Tatay nak asa langit.” ");
INSERT INTO bno_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nagsiling pa si Hesus, “Aya ninro giisipang nagpaali Ako para wagiton kag Kasuguan ni Moises ag kag pagtudlo it mga propeta, kundi nagpaali Ako para tuparon kag inra tanang ingsiling. ");
INSERT INTO bno_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Matuor kaling Ako ingsisiling sa inro, myentras rahina pa kag langit ag duta, ay inding gador mawagit kag pinaka-maisot nak letra o tuldok sa Kasuguan it Dios hastang waya pa natupar kag tanan. ");
INSERT INTO bno_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Kada kag tawong magsuway aber sa pinaka-maisot nak kasuguan, ag magtudlo sa iba nak indi gitumanon kina, sida ay magiging pinaka-mababa sa gingharian it Dios. Pero kag magtuman sa kasuguan ag magtudlo sa iba nak tumanon kina ay magiging mataas sa gingharian it Dios. ");
INSERT INTO bno_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kada ingsisiling Nako sa inro nak kung indi ninro mayabawan kag kaaduhan it mga Pariseo ag mga Manunudlo it Kasuguan, inding gador kamo makaagom sa gingharian it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nagsiling pa si Hesus, “Narungganey ninro kag ingsugo sa ato mga ginikanan it katong una pa nak, ‘Indi kamo magpangmatay, ag si-o mang tawo nak magpangmatay ay dapat husgaran ag parusahan.’ ");
INSERT INTO bno_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero kali kag Ako masisiling sa inro. Aber si-o mang tawo kag mahangit sa ida isigkatawo ay ahusgaran ag aparusahan. Ag aber si-o man nak mainsulto sa ida isigkatawo sa pagsiling nak ‘waya ka't puyos!’ ay puyding iakusar sa atubangan it Konseho. Ag aber si-o man nak masiling sa ida isigkatawo nak ‘buang ka!’ kag apagtuan nida ay kayado ruto sa impyerno. ");
INSERT INTO bno_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kada, kung mahalar ikaw sa Dios ruto sa Templo, ag sa oras nak mapayungot ikaw sa altar ay narumruman nimo nak inggwa it tawo nak napayain sa imo, ");
INSERT INTO bno_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bilinan anay kag imo inughalar sa atubangan it altar ag suuran katong nahangit sa imo, ag magpasag-uli anay kamo bag-o magbalik ag maghalar sa Dios. ");
INSERT INTO bno_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ag usa pa, kung inggwa it maakusar sa imo, aregluha nak raan bag-o ka nida ray-on sa korte. Kung indi, aray-on ka nida sa husgado ag ita-o ka nida sa gwardya, ag aprisuhon ka. ");
INSERT INTO bno_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ag matuor kaling Ako ingsisiling sa inro. Indi ka kaliwas hanggat waya nimo nababadare kag tanang atraso nimo.” ");
INSERT INTO bno_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nagsiling pa si Hesus, “Narungganey ra ninro kag kasuguan nak, ‘Indi kamo magpangawatan.’ ");
INSERT INTO bno_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero kali kag Ako masisiling sa inro. Aber si-o mang tawo kag magmuyat nak inggwa't mayaing hanrom sa usang kabade ay pay nahimoy nida kag pagpangawatan sa ida tagipusuon. ");
INSERT INTO bno_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kung kag imo tuong mata kag magiging dahilan it imo pagkakasala, yukata ag ipilak, dahil maado pang mawar-an ka it usang parti it imo yawas, kisa kumpleto kang ipilak sa impyerno. ");
INSERT INTO bno_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kung kag imo tuong damot kag magiging dahilan it imo pagkakasala, utuya ag ipilak, dahil maado pang mawar-an ka it usang parti it imo yawas, kisa kumpleto kang ipilak sa impyerno.” ");
INSERT INTO bno_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nagsiling pa si Hesus, “Nasisiling ra it kato nak kung abuyagan it usang kayake kag ida asawa, dapat nidang taw-an kag ida asawa it Kasuyatan bilang pamatuor it inra pagbinuyagan. ");
INSERT INTO bno_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero kali kag Ako masisiling sa inro, aber si-o mang kayake kag mabuyag sa ida asawa, puyra yang kung nagpangawatan kag kabade nak waya ra it ibang rason, kag kayake kag nakasala. Ag kaling kayake kag nakasala ray liwat dahil sida kag nagtutuy-og sa kabade nak magpangawatan pag mag-asawa ray liwat kaling kabade. Ag aber si-o man kag maasawa diling kabade nak ingbuyagan it ida asawa ay nagpapangawatan ra.” ");
INSERT INTO bno_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nagsiling pa si Hesus, “Narungganey ra ninro kag ingsugo sa ato mga ginikanan it katong una pa nak, ‘Indi ninro igbaliwayaon kag inro ingsumpaan sa Ginoong Dios kundi tumanon kina.’ ");
INSERT INTO bno_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero kali kag Ako masisiling sa inro. Ayang gador kamo gisumpa. Aya gisiling nak saksi nako kag langit, dahil trono kina it Dios. ");
INSERT INTO bno_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aya ra gisiling nak saksi nako kag duta, dahil tungtungan kina it Ida mga siki. Aya ra gisiling nak saksi nako kag Herusalem, dahil syudad kina it Makagagahom nak Hari. ");
INSERT INTO bno_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ag aya ra gisumpaan kag imo uyo, dahil indi nimo mapaputi o mapaitom miskin usang buhok sa imo uyo. ");
INSERT INTO bno_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Magsiling yangey ikaw nak ‘Oho’ kung ‘Oho,’ ag ‘Buko’ kung ‘Buko,’ dahil kung inggwa pa it magsubra raha ay haliney kina sa kayainan.” ");
INSERT INTO bno_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nagsiling pa si Hesus, “Narungganey ra ninro kag ingsugo sa ato mga ginikanan it katong una pa nak, ‘Kag kabadaran it nakasala sa imo ay mata sa mata ag ngisi sa ngisi,’ ");
INSERT INTO bno_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero kali kag Ako masisiling sa inro, aya gibayos sa mga nakasala sa inro. Kung inggwa it matampa sa imo tuong uda, atubangan pa sa ida kag kayudo. ");
INSERT INTO bno_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kung iakusar ka para mabaoy kag imo baro, taw-an yangey pati kag imo alimungmong. ");
INSERT INTO bno_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ag kung apiliton ka it usang tawo nak pas-anon kag ida raya it usang kilometro, pas-ana kina it ruhang kilometros. ");
INSERT INTO bno_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ag kung inggwa it naghahagar sa imo, taw-e, ag aya gipaindi-e kag gustong maghuyam sa imo.” ");
INSERT INTO bno_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nagsiling pa si Hesus, “Narungganey ra ninro kag ingsiling it katong una pa nak, ‘Palangga-a kag imo amigo pero hangite kag imo kaaway.’ ");
INSERT INTO bno_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero kali kag Ako masisiling sa inro, palangga-a kag inro kaaway ag pangamuyuan kag mga nagpapahirap sa inro, ");
INSERT INTO bno_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","pramas abilangon kamong anak it inro Tatay nak asa langit. Ingpapasubat Nida kag adlaw buko yang para sa mga maado kundi para ra sa mga mayain, ag ingpapauyan Nida buko yang para sa mga nagtutuman sa Dios kundi para ra sa mga waya. ");
INSERT INTO bno_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kung kag apalanggaon yang ninro ay katong nagpapalangga sa inro, niong premyo kag inro mababaton? Di baga, aber kag mga manugsukot it buhis ag iba pang mga makasal-anan ra ay nagpapalangga sa mga nagpapalangga sa inra? ");
INSERT INTO bno_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ag kung sa inro hali yang kamo mapakita it maado, ay ni-o kag inro nahimong mas maado kisa sa iba? Inghihimo ra kina it mga waya gipapati sa Dios. ");
INSERT INTO bno_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ngani, kinahangyan nak kag inro pagpalangga ra ay maging pareho sa pagpalangga it inro Tatay sa langit nak waya nak gador it kakuyangan.” ");
INSERT INTO bno_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nagpadayon si Hesus it Ida pagtudlo, “Magrahan kamo nak buko yang pakitang tawo kag paghimo ninro it maado para purihon kamo. Kung tuyar kag inro ahimuon, wayang gador kamo it mababaton nak premyo halin sa inro Tatay sa langit. ");
INSERT INTO bno_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kada, pag kamo ay magbulig sa mga mahirap, aya gipatuyar sa mga tawo nak kag pagbulig ay pakitang tawo yang nak ingpaparadaw kina sa sinagoga ag sa mga rayan, agor apurihon sinra it tawo. Matuor kaling Ako ingsisiling sa inro, kag pagpuri it tawo sa inra ay imaw yang kag premyo nak inra mababaton. ");
INSERT INTO bno_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Kada ngani pag mabulig kamo, aya gipaayaman miskin sa pinaka-mayungot ninrong hali, ");
INSERT INTO bno_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","agor waya it makaayam. Ag kag tatay ninro sa langit nak imaw kag nakakakita it inro inghuhuman nak patago ay Sida kag mata-o sa inro it premyo.” ");
INSERT INTO bno_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nagsiling pa si Hesus, “Pag kamo ay magpangamuyo, aya gipatuyar sa mga tawo nak kag pangamuyo ay pakitang tawo yang. Abang gusto ninrang magpangamuyo it nakatinrog sa mga sinagoga ag sa mga kanto it rayan agor makita sinra it mga tawo. Matuor kaling Ako ingsisiling sa inro, kag pagpuri it tawo sa inra ay imaw yang kag premyo nak inra mababaton. ");
INSERT INTO bno_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Kada pag kamo ay magpangamuyo, suyor sa inro kwarto ag sarhe kag hagran, bag-o magpangamuyo sa inro Tatay nak indi makitang kaibahan ninro. Ag Sida nak imaw kag nakakakita it inro inghuhuman nak patago ay imaw it mata-o't premyo sa inro. ");
INSERT INTO bno_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pag kamo ay magpangamuyo, aya giulit-ulita it sambit kag mga bisayang waya it kapuyos-puyos tuyar sa inghuhuman it mga waya gikikilaya sa Dios. Kabi ninra ay arunggan sinra it Dios dahil sa ramo it inra nabisaya. ");
INSERT INTO bno_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aya ninro sinra gipatuyare, dahil ayamey it inro Tatay kung ni-o kag inro kinahangyan bag-o pa kamo maghagar. ");
INSERT INTO bno_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ngani, tuyar kali kag inro pangamuyo, ‘Amo Tatay sa langit, dayawon kag Imo balaang pangayan. ");
INSERT INTO bno_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kabay pang mapasa-amo kag Imo paghari, ag kabay pang matuman kag Imo kabubut-on dili sa duta tuyar sa langit. ");
INSERT INTO bno_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Taw-e kami it amo pagkaon sa adlaw-adlaw. ");
INSERT INTO bno_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawara kami sa amo mga kasal-anan, tuyar sa amo pagpatawar sa mga nakakasala sa amo. ");
INSERT INTO bno_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ag aya gituguting maraya kami it panulay, kundi likawan kami sa kayainan.’ ” “Dahil waya it katapusan kag Imo paghari, pagka-gamhanan ag kahimayaan. Kabay pa.” ");
INSERT INTO bno_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kung apatawaron ninro kag mga nakasala sa inro, apatawaron ra kamo it inro Tatay sa langit. ");
INSERT INTO bno_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero kung indi ninro gipatawaron kag mga nakasala sa inro, indi ra kamo gipatawaron it inro Tatay sa langit.” ");
INSERT INTO bno_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nagsiling pa si Hesus, “Pag mapuasa kamo, aya gipatuyar sa mga tawo nak kag pagpuasa ay pakitang tawo yang. Ingpapakita ninra nak pay nalilisor sinra ag waya ninra giaayusa kag inra sarili agor makita it mga tawo nak sinra ay nagpupuasa. Matuor kaling Ako ingsisiling sa inro, kag pagpuri it tawo sa inra ay imaw yang kag premyo nak inra mababaton. ");
INSERT INTO bno_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kada pag kamo ay magpuasa, magpangyam-os anay ag husayon kag inro buhok, ");
INSERT INTO bno_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","agor indi maayaman it mga tawo nak nagpupuasa kamo, kundi kag makakaayam yang ay kag inro Tatay nak indi makita. Ag Sida nak imaw kag nakakakita it inro inghuhuman nak patago ay imaw it mata-o't premyo sa inro.” ");
INSERT INTO bno_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nagsiling pa si Hesus, “Aya kamo gitipon it manggar dili sa duta dahil kag inro mga kamanggaran dili ay aanayon yang, atuktukon, ag kag inro mga bayay ay asuryon ag atakawan. ");
INSERT INTO bno_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kada sa langit tipuna kag inro kayamanan. Hagto ay waya it mga anay ag tuktok nak masira, ag waya ra it masuyor sa inro bayay ag mapanakaw. ");
INSERT INTO bno_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dahil kung hariin kag inro kayamanan, ay hagto ra kag inro tagipusuon. ");
INSERT INTO bno_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kag mata ay pay iwag it imo yawas. Kada kung mahadag kag imo mata, mahahadagan kag imo bug-os nak yawas. ");
INSERT INTO bno_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero kung maruyom kag imo mata, maruruyman ra kag imo bug-os nak yawas. Kada ngani kung kabi nimo ay mahadagey kag imo kaisipan ag imo naayaman nak kag kahadagan yaki nak rahina sa imo ay maruyom, kinang ruyom ay grabing karuymanan talaga. ");
INSERT INTO bno_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Waya it makakaserbisyo it rungan sa ruhang amo, dahil apabad-an nida kag usa ag apalanggaon kag usa, o matutom sida sa usa ag amayainon kag usa. Ngani, indi kamo makaserbisyo it rungan sa Dios ag sa manggar. ");
INSERT INTO bno_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kada, kali kag Ako masisiling sa inro. Aya gikalibog sa inro mga kinahangyan para sa pagpangabuhi, kung ni-o kag inro akaunon ag ainumon, ag tungor sa kinahangyan it inro yawas, kung ni-o kag inro isuksok. Dahil mas mahalaga kag inro kabuhi kisa sa pagkaon ag kag inro yawas kisa sa baro. ");
INSERT INTO bno_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Muyati ninro kag mga pispis nak nagyuyupar. Waya sinra gitatanom o giaani. Waya ra sinra gititipon sa usunan, pero gingpapakaon gihapon sinra it inro Tatay sa langit. Kamo pa ara nak mas mahalaga kisa rahang mga pispis? ");
INSERT INTO bno_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nak si-o sa inro kag makakasugrong it aber usang oras sa haba it ida kabuhi parayan sa pagpakalibog? ");
INSERT INTO bno_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Asing nalilibog kamo kung ni-o kag inro isuksok? Muyati ag isipa kung pauno nagtutubo kag mga buyak sa bukir. Waya sinra gipapangabudlay o gihahaboy, ");
INSERT INTO bno_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","pero ingsisiling nako sa inro, aber si Haring Solomon nak abang ramong manggar ay waya kasuksok it tuyar't ganda sa mga buyak. ");
INSERT INTO bno_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kung paunong ingpapaganda it Dios kag mga buyak it hilamunon sa bukir, nak ngasing ay buhi ag pagkainsulip ay ahayason ag ipilak sa kayado, kamo pa ara kag indi Nida gibaruan? Abang isot kag inro pagtu-o! ");
INSERT INTO bno_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kada ngani aya ninro gikalibge kung ni-o kag inro akaunon o ainumon o isuksok, ");
INSERT INTO bno_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","kumo kina kag inghihingabot it mga tawong waya gipapati sa Dios. Pero ayamey it inro Tatay sa langit nak kinahangyan ninro kinang tanan. ");
INSERT INTO bno_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kada imbes nak magpakakalibog kamo, kag inro yangey unahon ay magtinguha kamo nak magpasakop sa paghari it Dios ag tumanon kag Ida kabubut-on. Kung tuyar kag inro ahimuon, Ida ra ita-o sa inro kag inro tanang mga kinahangyan. ");
INSERT INTO bno_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Kada aya gikalibog it para insulip. Bahalaey kag para insulip nak mga isipon. Tamaey kag para ngasing nak adlaw.” ");
INSERT INTO bno_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nagpadayon si Hesus it Ida pagtudlo, “Aya gihusgare kag inro isigkatawo agor indi ra kamo gihusgaran it Dios, ");
INSERT INTO bno_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","dahil kung pauno ninro inghuhusgaran kag inro isigkatawo ay tuyar ra kag paghusgar it Dios sa inro. Ngani, kung kag inro paghusgar ay ikumpara sa taksanan, kung ni-o kag ingtaksan it inro ingta-o ay imaw ra kag agamiton nak pangtakos it Dios sa inro. ");
INSERT INTO bno_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Asing nakikita nimo kag maintik nak puling sa mata it imo isigkatawo, pero waya nimo namamasre kag pay trusong puling nak hina sa imo mata? ");
INSERT INTO bno_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ag pauno nimo masisiling sa imo isigkatawo nak, ‘Maley, abay-on nako kinang puling sa imo mata,’ kung sa imo mata mismo ay inggwa't pay trusong puling? ");
INSERT INTO bno_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kag imo inghuhuman ay pay pakitang tawo yang ra! Bay-a anay kinang pay trusong puling sa imo mata, agor makakakita ka it maado ag mababaoy kinang maintik nak puling sa mata it imo isigkatawo. ");
INSERT INTO bno_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Aya gipilitan kag pagtudlo it sagradong mga bisaya it Dios sa mga indi magpati, dahil sinra ay pay tuyar sa iro nak mapangagat gihapon aber ingtataw-aney it malasang bahog. Imaw ra sa mga baktin, kung imo ita-o kag perlas sa inra ay inra yang kina adama-damaan.” ");
INSERT INTO bno_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Nagsiling pa si Hesus, “Padayon yang kamo it hagar sa Dios, ag kamo ay Ida ataw-an. Padayon yang kamo sa paghanap, ag Ida kamo abuligan pramas makakakita. Padayon yang kamo it pagkatok, ag Ida kamo abuksan. ");
INSERT INTO bno_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dahil aber si-o man kag naghahagar sa Dios ay ataw-an, ag aber si-o man kag naghahanap ay makakakita, ag aber si-o man kag nagkakatok ay abuksan. ");
INSERT INTO bno_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Inggwa baga it maguyang nak mata-o it bato sa ida anak, kung tinapay kag ida ginghahagar, ");
INSERT INTO bno_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","o sawa, kung isra kag ida inghahagar? Syempre waya! ");
INSERT INTO bno_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kung kamong mga makasal-anan ay maayam magta-o it mga maadong butang sa inro mga anak, kag inro pa ara Tatay nak asa langit? Maayam ra Sida magta-o it mga maadong bagay sa mga naghahagar sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kada kung ni-o kag imo gusto nak ahimuon sa imo it iba, ay imaw ra kag imo ahimuon sa inra. Imaw kina kag ingtutudlo it Kasuguan ni Moises ag ingsuyat it mga propeta.” ");
INSERT INTO bno_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Nagsiling pa si Hesus, “Suyor kamo sa makitir nak pasuyuran. Mayapar kag pasuyuran ag maado kag rayanan papagto sa impyerno, kada karamong nagrarayan raha. ");
INSERT INTO bno_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero makitir kag pasuyuran ag mahirap kag rayanan papagto sa kabuhi nak waya't katapusan, kada apila yang kag nakakakita it kaling rayan.” ");
INSERT INTO bno_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nagsiling pa si Hesus, “Mag-andam kamo sa buko matuor nak propeta nak nag-aabot sa inro. Kag inra hitsura ay pay kabuot-buot nak mga tawo nak pay tuyar sa maanar nak karnero, pero sa kamatuuran, sinra ay maisog tuyar sa bang-aw nak iro. ");
INSERT INTO bno_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Makikilaya ninro sinra parayan sa inra mga inghimo, tuyar sa inro pagkilaya sa puno parayan sa inra bunga. Kada ngani indi kita makapu-po it ubas sa ruyog-rugay, ag indi kita makahugot it igos sa puno it aruma. ");
INSERT INTO bno_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kag maadong puno ay nagbubunga it maado, pero kag mayaing puno ay nagbubunga ra it mayain. ");
INSERT INTO bno_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ag kag maadong puno ay indi magbunga it mayain, ag kag mayaing puno ay indi ra magbunga it maado. ");
INSERT INTO bno_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kag bawat puno nak waya gipapamunga it maado ay apukanon yangey ag ahimuong rabok. ");
INSERT INTO bno_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kada ngani makikilaya ninro kag mga buko matuor nak propeta parayan sa inra mga mayaing inghimo.” ");
INSERT INTO bno_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Buko tanang nag-aayaba sa Ako nak, ‘Gino-o, Gino-o’ ay makakasuyor sa gingharian it Dios, kundi kag mga nagtutuman yang sa kabubut-on it Ako Tatay sa langit. ");
INSERT INTO bno_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pag-abot it adlaw it huling paghusgar it Dios sa tawo, karamo kag masiling sa Ako nak, ‘Gino-o, Gino-o, di baga sa Imo pangayan ingbantala namo kag mga mensahe, sa Imo pangayan ingpalayas ra namo kag mga mayaot ag sa Imo pangayan naghuman kami it mga milagro?’ ");
INSERT INTO bno_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero kali kag Ako isiling sa inra, ‘Buko kamo Nako kilaya! Halin kamo dili, kamo nak waya gitutuman sa Ako kabubut-on!’ ” ");
INSERT INTO bno_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nagsiling pa si Hesus, “Kag tanang nagrurungog it Ako mga bisaya, ag ingtutuman kali, ay tuyar sa maayong tawo nak nagtugrok it ida bayay sa kabatuan. ");
INSERT INTO bno_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nag-uyan, nagbaha, ag nagbagyo, ag kaling bayay ay inglampusan it makusog nak hangin. Pero wayang gador kali naguba, dahil kali ay nakatugrok sa kabatuan. ");
INSERT INTO bno_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Pero sida nak nagrurungog it kaling Ako mga bisaya ag waya kali gitutumana, ay tuyar sa tawo nak kuyang kag pag-iisip nak nagtugrok it ida bayay sa baybay. ");
INSERT INTO bno_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nag-uyan, nagbaha, ag nagbagyo, ag kaling bayay ay inglampusan it makusog nak hangin. Ag kali ay naguba. Ag talagang ingdistruso it husto kina.” ");
INSERT INTO bno_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkatapos it kaling pagtudlo ni Hesus, rakong gador kag katingaya it mga tawo, ");
INSERT INTO bno_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","dahil nakita ninra nak kag Ida pagtudlo ay inggwa't gahom, ag buko tuyar sa pagtudlo it inra mga Manunudlo it Kasuguan. ");
INSERT INTO bno_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pag-us-os ni Hesus halin sa baguntor, nagsinunor sa Ida kag abang ramong tawo. ");
INSERT INTO bno_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ag inggwa it usang tawong di sakit nak kitong nak nagpayungot ag nagyuhor sa atubangan ni Hesus, ag nagsiling, “Gino-o, kung Imo abut-on, mapapaado Nimo ako.” ");
INSERT INTO bno_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Inghunat ni Hesus kag Ida damot ag inghuytan kaling tawo, ag nagsiling, “Oho, gusto Nako! Apaaduhon ka Nako!” Ag sa nak raan ay nawagit kag ida kitong ag naglinas kag ida anit. ");
INSERT INTO bno_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ag gingsilinggan sida ni Hesus, “Aya nak gador gipang-uma-umaan sa mga tawo kaling Ako inghuman sa imo, kundi pagto anay nak raan sa saserdote ag pamuyati sa ida kag imo yawas nak naulian. Ag mata-o ka it halar kumporme sa Kasuguan ni Moises bilang pamatuor sa mga tawo nak ikaw ay maadoy.” ");
INSERT INTO bno_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pag-abot ni Hesus sa syudad it Capernaum, inggwa it usang Kapitan it mga sundalo it Roma nak nagsuor sa Ida ag nagpangabay, ");
INSERT INTO bno_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Gino-o, kag usa nakong suguon ay indi makahiwas ag abang hirap kag ida kamutangan. Hagto sida sa amo bayay nakahigra.” ");
INSERT INTO bno_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ag nagsiling si Hesus, “Kitay! Apagtuan Nato sida, ag Ako sida apaaduhon.” ");
INSERT INTO bno_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero nagsiling kag Kapitan, “Gino-o, buko ako karapatdapat nak pagtuan Nimo sa amo bayay. Kung magsiling yang Ikaw nak mauulian kag ako suguon, ay talagang mauulian sida. ");
INSERT INTO bno_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ayam nako nak kaya Nimong himuon kali dahil ako ra ay asa irayom it gahom it ako pinuno, ag inggwa ra ako it mga sundalo nak asa irayom it ako gahom. Kung masiling ako sa usa nak, ‘Pagtoy,’ ay mapagto sida. Ag kung masiling ray ako sa iba nak, ‘Payungot dili,’ ay mapayungot sida sa ako. Ag imaw ra kung masiling ako sa ako suguon nak, ‘Himu-a kali,’ ay matuor nak ahimuon nida kina.” ");
INSERT INTO bno_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagkarungog it kali ni Hesus, abang katingaya talaga Nida, kada Sida ay napasiling sa Ida mga manugsunor, “Matuor kaling Ako ingsisiling sa inro. Waya pang gador Ako it nakikita nak Israelinhon nak tuyar it rako kag pagtu-o. ");
INSERT INTO bno_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tanra-e ninro kali. Karamong buko Hudyo nak halin sa subatan ag sugbuhan ay maatubang sa lamesa ag makaon kaibahan nina Abraham, Isaac ag Jacob sa gingharian it Dios. ");
INSERT INTO bno_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero kag mga lahi it Hudyo nak dapat tan-a'y kabilang ruto sa gingharian it Dios, sinra ay ipilak sa liwas sa karuymanan, ag hagto sinra matinibaw ag mapangpagot kag inra mga ngisi.” ");
INSERT INTO bno_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pagkatapos, nagsiling si Hesus sa Kapitan, “Pauliey. Matutuman kag imo ginghahagar kumporme sa imo pagtu-o.” Ag katong oras rang kato, naulian matuor kag suguon it Kapitan. ");
INSERT INTO bno_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pagkatapos, nagpagto si Hesus sa bayay nina Pedro ag nakita Nida kag ida panugangang kabade nak nakahigra, dahil sida ay ingsasagnat. ");
INSERT INTO bno_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ingpayungutan sida ni Hesus ag inghuytan kag damot. Sa nak raan ay nawagit kag ida sagnat ag sida ay nagbangon ag gingtahawan sinra. ");
INSERT INTO bno_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Maruyomey, gingpangraya it mga tawo kang Hesus kag maramong ingsasaniban it mga mayaot, ag parayan sa Ida bisaya ay naglayas kinang mga mayaot ag nag-ado kag tanang di sakit. ");
INSERT INTO bno_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kinang Ida inghuman ay katuparan it gingbisaya it Dios parayan kang Propeta Isaias it kato nak, “Sida kag nagbaoy it ato mga kayudahan ag Sida ra kag nagpaado sa ato mga sakit.” ");
INSERT INTO bno_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pagkakita ni Hesus nak nagraragipon sa Ida kag abang ramong tawo, gingsilinggan Nida kag Ida mga disipulos nak matabok sinra sa ragat papagto sa yudo. ");
INSERT INTO bno_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Katong sinra ay patabukon pa yang, inggwa it usang Manunudlo it Kasuguan nak nagsuor kang Hesus ag nagsiling, “Maestro, masunor ako sa Imo aber hariin Ka magpagto.” ");
INSERT INTO bno_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nagsabat si Hesus, “Aber kag mga ilahas nak iro ay inggwa it yukuhan, ag kag mga pispis ay inggwa it pugar, pero Ako nak dati pa ay ingtatawagey nak Anak it Tawo ay waya it maadong katuyugan.” ");
INSERT INTO bno_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Inggwa ra it nagsiling sa Ida nak usa sa Ida mga manugsunor, “Gino-o, pasugte anay akong magpauli. Hingan ako masunor sa Imo pag namatayey kag ako tatay ag ako napayubongey sida.” ");
INSERT INTO bno_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nagsabat si Hesus, “Sunor yangey sa Ako. Pabadyang kag mga waya't pagtu-o nak tuyar sa mga minatay sa pagmuyat it Dios nak magyubong sa inra kapwa minatay.” ");
INSERT INTO bno_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pagkatapos, nagsakay si Hesus sa rayapang kanunot kag Ida mga manugsunor, ag naglargay sinra. ");
INSERT INTO bno_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ag habang sinra ay nagbibiyahe ay inggwa't bagyo nak gulping nag-abot. Ag halos napupun-aney it tubi kag rayapang nak pay mayugrangey. Pero si Hesus ay katuyog gihapon. ");
INSERT INTO bno_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kada ingsuuran Sida it mga disipulos ag ingpukaw, “Gino-o, salbara kita! Mayugrangey kita!” ");
INSERT INTO bno_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ag napasiling si Hesus sa inra, “Asing nahadlok kamo? Abang isot gihapon kag inro pagtu-o.” Nagbangon Sida ag ingsaway kag hangin ag ragat. Ag sa nak raan ay nagkalma. ");
INSERT INTO bno_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Natingaya sinra ag napasiling, “Niong klasing tawo kali? Asing miskin hangin ag ragat ay nasunor sa Ida?” ");
INSERT INTO bno_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","It katong nakaabotey sina Hesus sa lugar it Gadara, inggwa it ruhang kayake nak halin sa mga kuyba nak yuyubngan nak nagsapoy-sapoy sa Ida. Kaling mga tawo ay ingsasapian it mga mayaot ag abang isog sinra, kada waya it nagrarayan raha. ");
INSERT INTO bno_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pagkakita ninra kang Hesus sinra ay napaukaw, “Anak it Dios, ni-o kag Imo labot sa amo? Asing nagpali Ikaw, buko pa oras para kastiguhon kami?” ");
INSERT INTO bno_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ruto sa mayado-yado ay inggwa it maramong baktin nak nagpapang-ibok. ");
INSERT INTO bno_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ag nagpakitluoy kang Hesus katong mga mayaot hina sa ruhang kayake, “Kung apalayason Nimo kami, pasuyura yangey kami raha sa mga kabaktinan.” ");
INSERT INTO bno_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ag nagsiling si Hesus, “Hala suyor kamo!” Ngani, kag mga mayaot ay nagliniwas sa ruhang kayake ag nagsinuyor sa mga baktin. Ag naggulpi it ragyo kag mga kabaktinan diretsuhan papagto sa pangpang, kada nagkahuyog sinra sa ragat ag nagkayumos. ");
INSERT INTO bno_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pagkakita dili it mga manugbantay it kinang mga baktin ay nagrinayagan ra sinra papauli sa banwa. Pag-abot ninra ruto ay inra gingpamalita kag tanang natabo, pati katong natabo sa ruhang kayaking nasaniban. ");
INSERT INTO bno_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ngani, nagliniwas kag halos tanang tawo sa banwa ag nagpinagto kang Hesus. Tong inra nasapoy si Hesus ay inra ingpakapilit nak pahalinon Sida sa inra lugar. ");
INSERT INTO bno_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pagkatapos, nagsakay ray sina Hesus sa rayapang ag nagtabok sa ragat papauli sa Capernaum nak Ida sariling banwa. ");
INSERT INTO bno_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pag-abot ninra ruto, inggwa it mga tawong nagraya kang Hesus it usang yupog nak nakahigra sa rudan. Tong nakita ni Hesus kung pauno't rako kag inra pagtu-o, siling Nida sa yupog, “Doy, pakusuga kag imo buot. Gingpatawarey kag imo mga kasal-anan.” ");
INSERT INTO bno_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Inggwa ra ruto it mga Manunudlo it Kasuguan ag tong narunggan ninra kali napasiling sinra sa inra sarili, “Rakong pasipala kali sa Dios! Kaling tawo ay pay nag-aako nak Sida ay kapareho it Dios!” ");
INSERT INTO bno_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero ayamey ni Hesus kung ni-o kag inra ing-iisip, kada napasiling Sida sa inra, “Asing nag-iisip kamo it mayain? ");
INSERT INTO bno_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ni-o kag mas marali igsiling, ‘Ingpatawarey kag imo mga kasal-anan,’ o ‘Bangon ag magpanaw?’ ");
INSERT INTO bno_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ako kali ingpapakita sa inro pramas pamatuuran nak Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay inggwa't karapatan dili sa duta nak magpatawar sa mga kasal-anan.” Kada nagsiling ray Sida sa yupog, “Bangoney raha, ag ray-on kinang imo rudan ag pumauliey.” ");
INSERT INTO bno_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nagtinrog matuor kinang yupog ag pumauli. ");
INSERT INTO bno_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagkakita it mga tawo sa natabo, sinra ay nahadlok ag nagdayaw sa Dios dahil ingtaw-an Nida kag tawo it karapatan ag gahom nak tuyar it kali. ");
INSERT INTO bno_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Naghalin si Hesus ruto, ag sa Ida pagpanaw nakita Nida kag usang manugsukot it buhis nak kag ngayan ay Mateo. Sida ay nag-iingkor sa ida pwesto. Nagsiling si Hesus sa ida, “Maley, sunor sa Ako!” Nagtinrog matuor si Mateo ag nagnunot sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Marugay-rugay, myentras nagkakaon sina Hesus ag Ida mga manugsunor sa bayay nina Mateo, nag-inabot kag maramong manugsukot it buhis ag iba pang mga makasal-anang tawo, ag nagrungan sinra it kaon nina Hesus. ");
INSERT INTO bno_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pagkakita kali it mga Pariseo, nagpangutana sinra sa mga manugsunor ni Hesus, “Asing nagrurungan it kaon kag inro maestro sa mga manugsukot it buhis ag iba pang mga makasal-anan?” ");
INSERT INTO bno_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Narunggan ni Hesus kag inra ingsiling ag napasiling Sida, “Kag tawo nak waya't sakit ay bukoey kinahangyan kag doktor, kundi kag inggwa yang it sakit. ");
INSERT INTO bno_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Isipa anay it maado kung ni-o kag gustong bisayahon it kaling nakasiling sa Sagradong Kasuyatan nak, ‘Kag Ako hanrom ay maging maluluy-on kamo sa inro isigkatawo, buko nak mahalar yang kamo pramas matuman kag Kasuguan.’ Kag rason kung asing nagpali Ako ay para tawagon kag mga makasal-anan, buko para sa mga nag-iisip nak sinra ay maadong tawo.” ");
INSERT INTO bno_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pagkatapos, nagpayungot kang Hesus kag mga manugsunor ni Juan nak Manugbawtismo ag nagpangutana, “Asing kami yang ag kag mga manugsunor it mga Pariseo kag perming nagpupuasa, pero kag Imo mga manugsunor ay waya?” ");
INSERT INTO bno_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ingsabat sinra ni Hesus, “Asi, sa oras it kasay, ay malilisor pa baga kag mga tigkayake kung kaibahan pa ninra kag kayake nak akasayon? Syempre indi! Pero maabot kag mga adlaw kung sauno abay-oney sa inra kinang kayake nak kasayon, ag imawey kag adlaw nak sinra ay mapuasa.” ");
INSERT INTO bno_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Waya it naghahakpoy it bag-ong yamit sa yumang baro, dahil maukyo kag bag-ong yamit nak inghakpuyan ag lalong marako kag gisi. ");
INSERT INTO bno_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Imaw ra, waya it nagsusuyor it bag-ong human nak ayak sa yumang susudlan nak human sa anit it hadop, dahil kung isuyor kina sa yumang susudlan, mayupok kag susudlan, mauudak kag ayak ag indiey mapuyusan kinang susudlan. Kag tamang himuon ay ibutang kag bag-ong human nak ayak sa bag-ong susudlan agor parehong mapupuyusan.” ");
INSERT INTO bno_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Myentras ingbibisaya pa kali ni Hesus, inggwa it nag-abot nak pinuno it mga Hudyo. Nagyuhor sida sa atubangan ni Hesus ag nagsiling, “Sir, kamamatay pa yang it ako anak nak kabade. Maley, nunot anay sa ako ag ipatong kag Imo damot sa ida, agor mabuhi pa sida.” ");
INSERT INTO bno_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kada nagtinrog si Hesus ag nagnunot sa ida. Imaw ra kag Ida mga manugsunor. ");
INSERT INTO bno_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Katong sa rayan pa yang sinra, inggwa't usang kabade nak doseng tuigey nak nahihirapan dahil ingrurugo. Nagpayungot sida sa likor ni Hesus ag ingsaplir kag gadar it Ida baro. ");
INSERT INTO bno_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Inghuman nida kali dahil naisip nida nak kung mahuytan yang nida kag baro ni Hesus ay mauulianey sida. ");
INSERT INTO bno_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Napasauli si Hesus ag pagkakita Nida sa kabade ay napasiling Sidang, “Ding, pakusuga kag imo buot. Gingpaado ka dahil sa imo pagtu-o sa Ako.” Ag sa nak raan ay naulianey sida. ");
INSERT INTO bno_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pag-abot nina Hesus sa bayay it kinang pinuno it mga Hudyo, nakita Nida kag mga tawo nak nagkikinanta ag kag iba ay naggugulo. ");
INSERT INTO bno_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nagsiling si Hesus sa inra, “Halin kamo! Buko minatay kinang anak kundi nagkakatuyog yang sida.” Pero inggur-an yang Sida it mga tawo. ");
INSERT INTO bno_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","It katong ingpaliwasey ninra kag mga tawo, nagsuyor si Hesus sa kwarto kung hariin kag anak, ag inghuytan Nida kag damot it anak, ag nagbangon kali. ");
INSERT INTO bno_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nabantog kaling inghuman ni Hesus sa tanang mga banwa ruto. ");
INSERT INTO bno_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pagkahalin nina Hesus ruto ay inggwa it ruhang kayaking bulag nak nagsunor sa Ida ag nag-aayaba it makusog, “Inanak ni David, kaluy-i kami!” ");
INSERT INTO bno_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pag-abot ni Hesus sa bayay nak Ida ingpapagtuan, nagsuyor Sida ruto. Nagsuyor ra kinang ruhang bulag, ag sinra ay Ida ingpangutana, “Nagtutu-o baga kamo nak kaya Nako kamong paaduhon?” Nagsabat sinra, “Opo, Gino-o.” ");
INSERT INTO bno_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Inghuytan ni Hesus kag inra mga mata ag nagsiling Sida sa inra, “Kumporme sa inro pagtu-o ay imaw it matutuman.” ");
INSERT INTO bno_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ag sinra ay nakakita matuor. Ag ingpakatugon nak gador sinra ni Hesus nak indi kali ninra gipang-uma-uma miskin kanin-o. ");
INSERT INTO bno_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero paghalin ninra ruto, gingpamalita gihapon ninra kag ginghuman ni Hesus sa inra sa bug-os nak lugar. ");
INSERT INTO bno_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pagkahalin it katong ruhang bulag, inggwa it ingraya kang Hesus nak usang udom nak ingsasaniban it mayaot. ");
INSERT INTO bno_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ingpalayas ni Hesus kag mayaot ag nakabisayang raan kag udom. Abang katingaya it mga tawo ag napasiling sinra, “Abaa! Waya pang gador it natatabong tuyar it kali sa bug-os nak Israel!” ");
INSERT INTO bno_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero nagpamidong yang kag mga Pariseo ag napasiling, “Kag Ida gahom nak magpalayas it mga mayaot ay parayan yang kang Satanas nak pinuno ninra!” ");
INSERT INTO bno_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pagkatapos, inglibot nina Hesus kag tanang mga banwa ag baryo sa pagtudlo sa mga sinagoga ag pagwali it Maadong Balita tungor sa paghari it Dios. Ag nagpapaado Sida it tanang klasi it sakit ag nababatyagan it tawo. ");
INSERT INTO bno_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pagkakita Nida sa maramong tawo, naluoy Sida sa inra, dahil napuproblemahan sinra ag pay nawawar-an it pag-asa, tuyar sa mga karnero nak waya it manugbantay. ");
INSERT INTO bno_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kada nagsiling Sida sa Ida mga manugsunor, “Abang bugana kag anihon, pero apila yang kag manug-ani. ");
INSERT INTO bno_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngani, pangamuyo kamo sa Gino-o nak Tag-iya it Anihon nak magparaya it mga manug-ani sa Ida anihan.” ");
INSERT INTO bno_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pagkatapos, gingtawag ni Hesus kag Ida doseng disipulos, ag ingtaw-an it karapatan ag gahom nak magpalayas it mga mayaot ag magpaado it tanang klasi it sakit ag nababatyagan it tawo. ");
INSERT INTO bno_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Imaw kali kag mga ngayan it doseng apostoles: kag una ay si Simon nak ingtatawag rang Pedro, masunor, si Andres nak ida manghor, si Santiago ag ida manghor nak si Juan nak mga anak ni Zebedeo, ");
INSERT INTO bno_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","sina Felipe ag Bartolome, sina Tomas ag si Mateo nak manugsukot it buhis, sina Santiago nak anak ni Alpeo, ag Tadeo, ");
INSERT INTO bno_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simong makabayan, ag si Judas Iscariote nak tong huli ay imaw kag nagtraidor kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ingpapanaw ni Hesus kaling Ida doseng apostoles ag ingtugunan sinra nak: “Aya kamo gipagto sa lugar it mga buko Hudyo. Aya ra gisuyor sa aber usang banwa it mga Samaryanhon, ");
INSERT INTO bno_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","kundi hagto kamo mapagto sa inro mga kalahing Hudyo nak pay mga karnerong nawagit. ");
INSERT INTO bno_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sa tanan nak mga lugar nak inro apagtuan ay ipalapnag sa inra nak mayungotey kag paghari it Dios. ");
INSERT INTO bno_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Paaduha kag mga di sakit ag banhawon kag mga minatay. Paaduha ra kag mga di kitong ag palayason kag mga mayaot sa mga ingsasaniban. Kag inro ingbaton ay waya't badar, kada mata-o ra kamo it waya't badar. ");
INSERT INTO bno_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aya kamo giraya it marakong kwarta o aber niong sinsilyo sa inro panghagkos. ");
INSERT INTO bno_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Aya ra giraya it binagtong para sa inro pagpanaw, o ilisan nak baro, sandalyas, o miskin bakulo. Dahil tuyar sa usang trabahador kamo ra ay karapatdapat nak magbaton it inro mga akaunon. ");
INSERT INTO bno_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kung hariin man kamong banwa o baryo magpagto, hanapa anay ninro kag usang tawo nak hanrang magbaton sa inro, ag ruto yangey kamo madayon sa inra bayay hastang maghalin kamo rutong lugar. ");
INSERT INTO bno_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagsuyor ninro sa bayay, siling anay nak, ‘Kabay pang pakamaaduhon it Dios kaling inro panimayay!’ ");
INSERT INTO bno_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ag kung karapatdapat sinra dahil inra ingbabaton kag inro ingrarayang panudlo, sinra ay talagang apakamaaduhon it Dios, pero kung indi ninra'g batunon ay indi ra sinra gipakamaaduhon it Dios. ");
INSERT INTO bno_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kung indi gibatunon o girunggan kag inro ingtutudlo it mga nag-iistar rutong bayay o banwa man, ay halin kamo raha. Pero sa inro paghalin ay paypage it taybo kag inro siki bilang tanra nak wayaey kamo it salabton sa inra kabuhi. ");
INSERT INTO bno_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Matuor kaling Ako ingsisiling sa inro. Sa huling paghusgar it Dios sa tawo ay mas mabug-at kag parusang maabot sa inra kisa sa parusang abatunon it mga taga-Sodoma ag Gomora.” ");
INSERT INTO bno_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nagsiling pa si Hesus, “Mag-andam kamo! Dahil ingsusugo Nako kamo sa tunga it mga tawong maisog tuyar sa mga ilahas nak iro, aber kamo ay pay tuyar sa mga karnero nak mabuot. Kada kinahangyan nak kamo ay maging listo sa peligro tuyar sa mga sawa, ag magrahan tuyar sa mga salumpati. ");
INSERT INTO bno_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Mag-andam kamo! Dahil bilang mga manugsunor Nako, kamo ay inra arakpon ag aray-on sa inra mga korte. Kamo ay inra alatiguhon sa inra mga sinagoga, ");
INSERT INTO bno_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ag abistigaron sa atubangan it mga gobernador ag hari, dahil sa inro pagtu-o sa Ako. Ag imaw kina kag oras nak kamo ay makakapamatuor sa inra ag sa mga buko Hudyo it tungor sa Ako. ");
INSERT INTO bno_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero sa oras nak iatubang kamo sa inra, aya kamo gikalibog kung pauno kamo masabat o kung ni-o kag inro ibisaya. Dahil sa oras nak kato, ipaayam it Dios sa inro kung ni-o kag tamang ibisaya. ");
INSERT INTO bno_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kumo buko halin sa inro sariling isip yang kag inro ibisaya, kundi halin sa Ispirito it Dios nak inro Tatay. ");
INSERT INTO bno_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sa oras rang kato, inggwa it mga tawong waya nagtutu-o sa Ako nak matraidor ag ipamatay kag inra mga hali nak nagtutu-o. Imaw ra kag ahimuon it mga tatay sa inra anak ag alabanan it mga anak kag inra maguyang ag ipamatay ra. ");
INSERT INTO bno_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Alabanan ra kamo it tanan, dahil sa pagsunor ninro sa Ako. Pero kung makakatiis kamo hastang sa kamatayon ay maluluwas kamo. ");
INSERT INTO bno_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kung apahirapan kamo sa usang banwa, takas kamo papagto sa ibang banwa. Matuor kaling Ako ingsisiling sa inro, myentras waya pa ninro natatapos kag inro paglibot sa tanang banwa it Israel ay maabotey Ako, nak dati pa ay ingtatawagey nak Anak it Tawo. ");
INSERT INTO bno_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Waya it usang nag-aaray nak mas maayam kisa sa ida maestro, ag waya ra it usang suguon nak mas mataas kisa sa ida amo. ");
INSERT INTO bno_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kada ngani dapat hanraey kag nag-aaray nak magbaton it parehong pagtrato nak ingbabaton ra it ida maestro, ag imaw ra kag suguon ag ida amo. Kung Ako nganing pinuno it panimayay ay ing-iinsulto it tawo sa pagtawag sa Ako nak Beelzebul, ay dey laloey kamong mga myembro it Ako panimayay.” ");
INSERT INTO bno_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nagsiling pa si Hesus, “Kada, aya gikahadlok sa mga mapahirap sa inro, dahil waya it nakatabon nak sa tamang oras ay indi gibuksan, ag waya ra it nakatago nak indi giliwas ag maaayaman. ");
INSERT INTO bno_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kag tanang Ako ingbisaya sa inro sa maruyom, ay inro isiling sa karamuan ruto sa mahadag. Ag kag tanang Ako ingbisaya nak para sa ato yang, ay imaw it inro ibandilyo sa maramong tawo halin sa kuyungan. ");
INSERT INTO bno_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aya gikahadluki kag mga tawong nagmamatay it yawas, pero indi kamatay it kalag. Kag Dios yang kag inro dapat kahadlukan, dahil Sida kag makakaparusa it kalag ag yawas sa impyerno. ");
INSERT INTO bno_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Di baga kag ruhang maya ay indi mabadaran it mamagong? Pero aber maisot yang kag inra balor, ay waya gihapon it aber usa sa inra kag mamatay ag matikrag sa duta kung indi gitugutan it Dios nak inro Tatay sa langit. ");
INSERT INTO bno_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ay kamo pa ara? Miskin buhok gani ninro ay biláng Nida. ");
INSERT INTO bno_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kada ngani aya kamo gikahadlok. Mas mahalaga kamo kisa sa libo-libong maya. ");
INSERT INTO bno_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kag tanang nag-aako sa atubangan it tawo nak Ako ay ingkikilaya ninra, ay akilay-on ra Nako sa atubangan it Ako Tatay sa langit. ");
INSERT INTO bno_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero si-o man kag magbalibar sa Ako sa atubangan it mga tawo ay ibalibar ra Nako sa atubangan it Ako Tatay sa langit.” ");
INSERT INTO bno_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nagsiling pa si Hesus, “Aya giisipang nagpaali Ako sa duta para magraya it katimunungan sa mga tawo. Buko katimunungan kag Ako raya, kundi kaguluhan. ");
INSERT INTO bno_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kada sa paabuton, dahil sa Ako, maaway-away ‘kag anak nak kayake ag tatay, imaw ra kag anak nak kabade ag nanay, ag kag umagar nak kabade ag ida panugangang kabade. ");
INSERT INTO bno_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ngani, kag ida mismong panimayay kag ida magiging kaaway.’ ");
INSERT INTO bno_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Si-o mang nagpapalangga sa ida maguyang o sa ida anak it mas yabaw pa sa ida pagpalangga sa Ako ay buko karapatdapat nak maging Ako manugsunor. ");
INSERT INTO bno_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kung si-o man kag indi magpas-an it ida krus parayan sa pagtiis it tanang hirap hastang sa ida kamatayon, dahil sa ida pagsunor sa Ako, ay buko karapatdapat nak maging manugsunor Nako. ");
INSERT INTO bno_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Kag tawong nagsasalig yang sa ida sarili ay imaw kag mawawar-an it kabuhi nak waya't katapusan. Pero kag tawo nak ingbabaliwaya kag ida sarili para yang magsunor sa Ako ay imaw kag magkakainggwa it kabuhi nak waya't katapusan.” ");
INSERT INTO bno_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nagsiling pa si Hesus, “Kag nagbabaton sa inro ay nagbabaton ra sa Ako, ag kag nagbabaton sa Ako ay nagbabaton ra sa Dios nak nagparaya sa Ako. ");
INSERT INTO bno_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kag nagbabaton sa usang propeta, dahil sida ay propeta it Dios, ay mabaton ra it premyo pareho sa propeta. Ag kag nagbabaton sa usang maadong tawo nak nagtutuman sa Dios, dahil sida ay nagtutuman sa Dios, sida ay mabaton ra it premyo nak pareho sa tawong kina. ");
INSERT INTO bno_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Matuor kaling Ako ingsisiling sa inro. Si-o man kag mapainom it aber usang basong tubi sa pinaka-kubos, dahil sida ay Ako manugsunor, ay siguradong mabaton it premyo katong nagpainom sa ida.” ");
INSERT INTO bno_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagkatapos it kaling pagtugon ni Hesus sa Ida doseng disipulos, naghalin Sida ruto para magtudlo ag magwali sa ibang mga banwa sa Galileya. ");
INSERT INTO bno_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Habang si Juan nak Manugbawtismo ay asa prisuhon pa, ay nag-abot sa ida kag mga balita tungor sa inghihimo ni Kristo. Kada ingsugo ni Juan kag ida pilang manugsunor nak magpagto ");
INSERT INTO bno_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ag magpangutana, “Ikaw baga kag ingpromisa it Dios nak mapali o inggwa pa kami it ahuyaton nak iba?” ");
INSERT INTO bno_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nagsabat si Hesus, “Balik kamo kang Juan ag silinggan sa ida kag inro narunggan ag nakita. ");
INSERT INTO bno_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nakakita nganat kag mga bulag, nakapanaw kag mga piang, naulian kag mga di kitong, nakarungog kag mga bungoy, nabuhi kag mga minatay ag ingbantala sa mga mahirap kag Maadong Balita. ");
INSERT INTO bno_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Silinggan ra sa ida nak abang buynas kag mga tawong waya nawawar-e it pagtu-o sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagkahalin it mga ingsugo ni Juan nak Manugbawtismo, ingsiling ni Hesus sa mga tawong nagtitipon ruto kag tungor kang Juan. Siling Nida: “It katong nagpagto kamo sa mayangkag nak kabukiran, ni-o kag inro gustong makita? Usang tawong waya it bisaya nak ingpapaninrugan tuyar sa tigbaw nak ingpapalir-palir it hangin? Syempre buko no? ");
INSERT INTO bno_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kung buko, ni-o talaga kag inro gustong makita? Usang tawong maganda it baro? Syempre buko! Kag mga nagbabaro it maganda ay nag-iistar sa palasyo it hari. ");
INSERT INTO bno_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kung tuyar, asing nagpagto kamo ruto? Ni-o talaga kag inro gustong makita, usang propeta? Oho, pero ingsisiling Nako sa inro, mas yabaw pa sida sa inra. ");
INSERT INTO bno_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Si Juan nak Manugbawtismo kag ingtutukoy sa Sagradong Kasuyatan, “ ‘Apaunahon Nako sa Imo kag Ako suguon, nak imaw kag mahanra it Imo arayanan.’ ");
INSERT INTO bno_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Matuor kaling Ako ingsisiling sa inro. Sa mga ing-anak dili sa duta ay waya pang gador it nakikilaya nak mas yabaw kisa kang Juan nak Manugbawtismo. Pero kag pinaka-kubos nak tawo sa gingharian it Dios ay mas yabaw pa kisa sa ida. ");
INSERT INTO bno_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Tuna it katong nagpabantala si Juan nak Manugbawtismo hasta ngasing, abang rako nak gador kag epekto it pagwali tungor sa paghari it Dios, ag maramong tawo kag nagmamakusog nak magpasakop sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kag tanang ingpaunang suyat sa mga libro it mga propeta ag sa Kasuguan ni Moises ay tungor sa palaabuton, ag kag pag-abot ni Juan nak Manugbawtismo ay imaw pa yang kag pagtuna it katuparan it kaling tanan. ");
INSERT INTO bno_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kada kung nagpapati kamo sa ingsiling it usang propeta it kato nak mabalik si Propeta Elias sa palaabuton, ay buko si Elias kag ingpapatungran it kali, kundi si Juan nak Manugbawtismo mismo. ");
INSERT INTO bno_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kamong mga nagpapanimati ay isipa ninro it maado kag inro narunggan!” ");
INSERT INTO bno_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nagsiling pa si Hesus, “Hariin Nako ikumpara kag mga tawo ngasing nak panahon? Sinra ay tuyar sa mga anak nak nag-iidamo sa plasa nak indi mamutang sa inghihimo it inra kaidamo. Kada nag-iinukawan sinra it tuyar kali, ");
INSERT INTO bno_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Aber naghuhuyop kami it turutot para sa inro, ay waya kamo gisasadaw! Ag aber nagpapanambitan kami, ay waya gihapon kamo nalilisor!’ ");
INSERT INTO bno_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Kamong mga tawo ay tuyar sa inra ngasing. Asi? Dahil it katong nag-abot si Juan nak Manugbawtismo nak nagpupuasa ag waya nag-iinom it ayak, ay nakasiling kamo nak, ‘Sida ay ingsasaniban it mayaot!’ ");
INSERT INTO bno_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ag ngasing nak nagpali ra Ako, nak dati pa ay ingtatawagey nak Anak it Tawo, nak nagkakaon ag nag-iinom ay nakasiling ray kamo nak, ‘Muyati yang kaling tawo, abang kagor ag palayango! Ag Sida ay nag-iiba sa mga manugsukot it buhis ag iba pang mga makasal-anang tawo.’ Pero aber tuyar kag inro ingsisiling, makikita gihapon ninro nak tama kag kaayaman it Dios parayan sa maadong inghihimo it mga nagbabaton it kina.” ");
INSERT INTO bno_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pagkatapos, ingbisar-an ni Hesus kag mga nag-iistar sa mga banwa kung hariin Sida naghuman it maramong milagro, dahil waya sinra gihihinuysoy sa inra mga kasal-anan. ");
INSERT INTO bno_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Siling Nida, “Kahahadlok kag matatabo sa inro mga taga-Corazin! Imaw ra kamong taga-Betsayda! Kahahadlok kag parusang inro maaaguman dahil waya kamo gihinuysoy sa inro mga kasal-anan! Kung sa Tiro ag Sidon ay inghuman Nako kag mga milagro nak pareho sa inghuman ra Nako sa inro, ay dey marugayey ra tan-a sinra nak nakasuksok it barong kustal ag ingwiwisikan it abo kag inra uyo, bilang tanra it inra paghinuysoy. ");
INSERT INTO bno_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kali kag Ako ingsisiling sa inro. Sa huling paghusgar it Dios sa tawo ay mas mabug-at kag parusang maabot sa inro kisa sa parusang abatunon it mga taga-Tiro ag Sidon. ");
INSERT INTO bno_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kamong mga taga-Capernaum, kabi baga ninro ay aray-on kamo sa langit. Inding gador! Dahil impyerno kag inro apagtuan! Kung sa Sodoma ay inghuman Nako kag mga milagro nak pareho sa inghuman ra Nako sa inro, ay dey tan-a'y naghinuysoy sinra ag hasta ngasing hagto pa gihapon kag inra banwa. ");
INSERT INTO bno_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kali kag Ako ingsisiling sa inro. Sa huling paghusgar it Dios sa tawo ay mas mabug-at kag parusang maabot sa inro kisa sa parusang abatunon it mga taga-Sodoma.” ");
INSERT INTO bno_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Masunor, nagpangamuyo si Hesus, “Tatay, Gino-o it langit ag duta, ingpapasalamatan Ka Nako dahil waya Nimo gipaayaman kaling tanan sa mga maayo ag nakaaray. Pero ingpahadag Nimo kali sa mga tawong hanraey magpaubos ag magtuon tuyar sa mga anak. ");
INSERT INTO bno_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Opo Tatay, dahil imaw kina kag Imo gustong matuman.” ");
INSERT INTO bno_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pagkatapos, gingsilinggan Nida kag mga tawo, “Kag tanang butang ay ingtugyan sa Ako it Ako Tatay. Waya it nakakilaya kung si-o nak gador Ako bilang Anak kundi kag Tatay yang. Waya ra it nakakilaya kung si-o nak gador kag Tatay kundi Ako yang nak Ida Anak, ag imaw ra sa mga tawo nak gusto Nakong ipakilaya kag Tatay sa inra.” ");
INSERT INTO bno_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nagsiling pa si Hesus, “Kamong mga napilay ag nabubug-atan, payungot sa Ako, ag kamo ay Ako apapahuwayon. ");
INSERT INTO bno_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magpasakop kamo sa Ako ag magtuon, dahil Ako'y mabuot ag mapainubuson, ag kag inro huna-huna ay magkakainggwa it kahilwayan. ");
INSERT INTO bno_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kag Ako mga sugo ay buko mabug-at nak tumanon kundi magaan yang.” ");
INSERT INTO bno_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Usang adlaw nak Sabado nak imaw kag Adlaw it Inugpahuway it mga lahi it Hudyo, naparayan sina Hesus sa triguhan, ag nakabatyag it gutom kag Ida mga manugsunor, kada nagpuksi sinra it uhay ag ingkitkit. ");
INSERT INTO bno_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagkakita it mga Pariseo, nagsiling sinra kang Hesus, “Hay, muyati, mismong Imo mga manugsunor kag naghuhuman it ingbabawal sa Adlaw it Inugpahuway.” ");
INSERT INTO bno_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nagsabat si Hesus, “Waya baga ninro nabasa kag inghimo nina Haring David it katong inggutom sida ag ida mga kanunot? ");
INSERT INTO bno_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nagsuyor sida sa Bayay it Dios ag nagbaoy it tinapay nak hinalar sa Dios ag ingkaon. Kumporme sa Kasuguan ni Moises kina ay bawal kaunon it aber si-o puyra yang sa mga saserdote. Pero nagkaon si David ag ingpakaon ra nida kag ida mga kaibahan. ");
INSERT INTO bno_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Waya pa baga ninro nababasa sa Kasuguan ni Moises nak kag tawo kung magtrabaho sa Adlaw it Inugpahuway ay nakakasala? Pero kag mga saserdote nak padayon nak nagsiserbisyo sa Templo sa Adlaw it Inugpahuway ay waya gipapamutangan nak nakakasala. ");
INSERT INTO bno_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kali kag Ako ingsisiling sa inro. Kag mas yabaw kisa sa Templo ay rahali ngasing. ");
INSERT INTO bno_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ingpasuyat it Dios sa Sagradong Kasuyatan, ‘Kag Ako hanrom ay maging maluluy-on kamo sa inro isigkatawo, buko nak mahalar yang kamo pramas matuman kag Kasuguan.’ Kung naintyendihan ninro kag gustong bisayahon it kali ay waya tan-a ninro gipapamutangan nak nakakasala kaling mga waya gisusuway sa Kasuguan. ");
INSERT INTO bno_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ingsisiling Nako, sinra'y waya ighihimo it sala, ag Ako nak dati pa ay ingtatawagey nak Anak it Tawo kag inggwa it karapatan nak magsiling kung ni-o kag puyding himuon ag indi sa Adlaw it Inugpahuway.” ");
INSERT INTO bno_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pagkahalin nina Hesus ruto ay nagpagto sinra sa inra sinagoga. ");
INSERT INTO bno_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ag inggwa ruto it usang kayaking pingkaw kag usang damot. Ruto ra ay inggwa it pilang Pariseo nak naghahanap it rason pramas maiakusar si Hesus. Nagpangutana sinra sa Ida, “Tama bagang magpaado it mga di sakit sa Adlaw it Inugpahuway?” ");
INSERT INTO bno_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ingsabat sinra ni Hesus, “Kung usa sa inro rili ay inggwa it karnerong nahuyog sa bal-ong sa Adlaw it Inugpahuway, indi baga ninro kato igpagtuan pramas bay-on? ");
INSERT INTO bno_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mas mahalaga kag tawo kisa sa karnero, kada puyde kitang maghimo it maado sa ato isigkatawo sa Adlaw it Inugpahuway.” ");
INSERT INTO bno_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Masunor, ingsugo Nida kag pingkaw, “Hunata kinang imo damot.” Inghunat matuor it kinang kayake kag ida damot ag nag-ado kato it pareho sa kayudong damot. ");
INSERT INTO bno_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ag tong nakita ninra kina, naghinalin kinang mga Pariseo ag nagplano kung pauno ipamatay si Hesus. ");
INSERT INTO bno_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pero naayaman ni Hesus kag inra plano, kada naghalin nak raan Sida ruto. Maramo kag nagsunor sa Ida ag gingpaado Nida kag tanang di sakit. ");
INSERT INTO bno_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ugaling Ida ingtugon sinra nak indi gipamalita kag tungor sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngani, natupar kag ingpasuyat it Dios parayan kang Propeta Isaias nak, ");
INSERT INTO bno_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hali kag Ako suguon nak Ako pinili. Sida kag Ako pinalangga ag Ako namumut-an. Ita-o Nako sa Ida kag Ako Ispirito ag ibantala Nida sa tanang mga nasyon kung pauno maging matarong sinra sa pagmuyat Nako. ");
INSERT INTO bno_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Indi Sida gipakig-away o magkusog it boses. Indi ra Sida mag-ukaw sa mga karsada. ");
INSERT INTO bno_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Indi Sida giutoy it tigbaw nak naghahapay, o magpayong it nag-iidlap-idlap nak iwag. Mapadayon Sida nak magpakita it kaluoy hastang mapirde kag kayainan it pagka-matarong it Dios. ");
INSERT INTO bno_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sida kag aasahan it tanang mga nasyon!” ");
INSERT INTO bno_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Usang adlaw, inggwa it ingraya kang Hesus nak usang kayaking bulag ag udom nak ingsasaniban it mayaot, pramas paaduhon sida. Kada sida ay nakabisaya ag nakakita. ");
INSERT INTO bno_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dahil dili, abang katingaya it tanang nakakita ag napasiling, “Sabaling Sida katong ingpromisa it Dios nak naghalin sa mga inanak ni Haring David.” ");
INSERT INTO bno_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero tong narunggan kali it mga Pariseo, napasiling sinra, “Kag Ida gahom nak magpalayas it mga mayaot ay parayan yang kang Beelzebul nak pinuno ninra!” ");
INSERT INTO bno_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nasasaduran ni Hesus kag inra ging-iisip, kada napasiling Sida: “Mabagsak kag bawat gingharian nak kag mga sinakupan ay naglalaban-labanan. Ag imaw ra, masisira kag bawat syudad ag pamilya. ");
INSERT INTO bno_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ag kung si Satanas it mapalayas sa ida mga sinakupang mayaot, ingkakalaban nida kag ida sarili. Kung tuyar ay pauno mayawig kag ida gingharian? ");
INSERT INTO bno_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kung Ako ay nagpapalayas it mga mayaot parayan sa gahom ni Beelzebul, ay kanin-o gahom kag inggagamit it inro mga manugsunor nak magpalayas it mayaot? Kag inro mismong mga manugsunor kag nakakapamatuor nak sala kamo! ");
INSERT INTO bno_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero kung parayan sa Ispirito it Dios kag Ako pagpalayas sa mga mayaot, ay maaayaman nak gador ninro nak nag-abotey sa inro kag paghari it Dios. ");
INSERT INTO bno_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Si Satanas ay tuyar sa usang makusog nak tawo, ag kung inggwa it gustong magsuyor sa ida bayay agor bay-on kag ida ari-arian, ay kinahangyan anay nak gapuson sida, ag pagkatapos, puyding bay-oney kag ida tanang mga gamit. ");
INSERT INTO bno_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kag waya gikakampi sa Ako ay nagkukuntra sa Ako, ag kag waya gibubulig sa pagtipon it mga tawo para sa Ako, ay imaw kag nagbubulig sa mga tawo nak magpayado sa Ako. ");
INSERT INTO bno_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ngani, ingsisiling Nako kali sa inro, apatawaron it Dios kag tanang nahimong kasal-anan ag tanang pagpasipala it tawo. Pero kag magbisaya it pasipala laban sa Ispirito Santo ay inding gador igpatawaron. ");
INSERT INTO bno_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Imaw ra, apatawaron it Dios kag magpasipala sa Ako nak dati pa ay ingtatawagey nak Anak it Tawo, pero kag magbisaya it pasipala laban sa Ispirito Santo ay inding gador igpatawaron, ngasing ag hastang sa waya't katapusan.” ");
INSERT INTO bno_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nagsiling pa si Hesus, “Kung maado kag bunga it usang puno it kahoy, masisiling nak maado ra kag inghalinang puno. Pero kung mayain kag bunga it usang puno it kahoy, masisiling nak mayain ra kag inghalinang puno, dahil nakikilaya kag puno sa ida bunga. ");
INSERT INTO bno_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kamong mga tusong tawo! Pauno kamo makakabisaya it maadong bagay kung kamo mismo ay mayain? Kung ni-o kag sa suyor it inro tagipusuon ay imaw ra it nagliliwas sa inro yuba! ");
INSERT INTO bno_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kag nagliliwas sa yuba it maadong tawo ay maado, halin sa ida maadong tagipusuon. Ag kag nagliliwas sa yuba it mayaing tawo ay mayain ra, halin sa ida mayaing tagipusuon. ");
INSERT INTO bno_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tanra-e ninro kali. Sa adlaw it paghusgar it Dios sa tawo, apanabtan it mga tawo kag tanang inra nabisaya nak waya't puyos. ");
INSERT INTO bno_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kag inro ingbibisaya, ay imaw kag agamiton it Dios bilang pamatuor sa Ida paghusgar sa inro, kung kamo ay nakasala o waya.” ");
INSERT INTO bno_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pagkatapos, inggwa it mga Manunudlo it Kasuguan ag mga Pariseo nak nagsiling kang Hesus, “Maestro, pakita-e baga kami it milagro bilang pamatuor nak Ikaw ay halin sa Dios!” ");
INSERT INTO bno_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ingsabat sinra ni Hesus, “Kamong mga tawo sa ngasing nak panahon ay subrang yain ag buko matutom sa Dios! Aber tuyar, ingpapaka-hanapan gihapon ninro Ako it milagro bilang pamatuor kung sin-o talaga Ako. Pero waya it ibang ipakita sa inro, kundi kag natabo yang it kato kang Propeta Jonas. ");
INSERT INTO bno_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kung paunong si Jonas ay nagtiner it tatlong adlaw ag tatlong gab-i sa suyor it bituka it marakong isra, ay imaw ra Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay matiner ra it tatlong adlaw ag tatlong gab-i sa irayom it duta. ");
INSERT INTO bno_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sa huling paghusgar it Dios sa tawo, matinrog kag mga taga-Ninive kaibahan it mga tawo sa ngasing nak panahon ag sinra kag maakusar sa inro, dahil sinra ay naghinuysoy katong gingpaandaman sinra ni Jonas, ag ngasing ay haley kag mas yabaw pa kisa kang Jonas, pero waya gihapon kamo gihihinuysoy. ");
INSERT INTO bno_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sa adlaw rang kato, matinrog ra kag Reyna it Seba kaibahan it mga tawo sa ngasing nak panahon ag sida ra ay maakusar sa inro. Dahil halin sa pinaka-mayadong lugar, nagpagto sida kang Haring Solomon para runggan kag ida rakong kaayaman. Ag ngasing ay haley kag mas yabaw pa kisa kang Solomon, pero waya gihapon ninro Sida gipapatihe.” ");
INSERT INTO bno_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nagsiling pa si Hesus, “Kung inggwa it usang mayaot nak magliwas sa usang tawo, malibot-libot anay kina sa mga kabukiran kung hariin ay waya it tubi myentras naghahanap it mapahuwayan. ");
INSERT INTO bno_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ag kung waya it makita, masiling kina sa ida sarili, ‘Mabalik yangey ako sa ako ginghalinan.’ Pagbalik nida hagto sa tawong ida ginghalinan, makikita nidang waya it nag-iistar ruto. Ag kali ay malimpyoy ag mas maadoy ngasing. ");
INSERT INTO bno_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kada pagkakita nida kali, ay mapanaw ray sida ag mapang-ikag it pito pang mayaot nak mas mayain pa sa ida, ag masuyor sinra ag maistar ruto. Ngani, kag kamutangan it katong tawo ay lalong mapakayain. Ag imaw ra kina kag matatabo sa mga mayaing tawo sa ngasing nak panahon.” ");
INSERT INTO bno_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Myentras nagbibisaya pa si Hesus ay nag-abot kag Ida nanay ag mga hali. Naghuhuyat sinra sa liwas, dahil gusto ninrang makabisaya Sida. ");
INSERT INTO bno_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ag inggwa't nagpayungot ag nagsiling sa Ida, “Maestro, pasensya anay. Hagto sa liwas kag Imo nanay ag mga hali. Gusto Ka ninrang makabisaya.” ");
INSERT INTO bno_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero nagsabat si Hesus, “Oho ngani! Pero sasin-o pa kag Ako ingkikilaya nak Ako nanay ag Ako mga hali?” ");
INSERT INTO bno_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pagkatapos, Ida ingtudlo kag Ida mga manugsunor ag nagsiling Sida, “Kali kag Ako nanay ag mga hali. ");
INSERT INTO bno_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dahil kag tanang nagsusunor sa kabubut-on it Ako Tatay nak asa langit ay imaw kag Ako ingkikilaya nak Ako mga hali ag Ako nanay.” ");
INSERT INTO bno_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Katong adlaw rang kato, nagliwas si Hesus sa bayay ag nagpagto sa habig it Ragat it Galileya, ag ruto Sida nag-ingkor. ");
INSERT INTO bno_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ingragipunan Sida it karuramong tawo, kada nagsakay Sida sa usang rayapang nak asa piliw, ag ruto Sida nag-ingkor pramas magbisaya sa inra myentras sinra ay nakatulay sa habig it baybay. ");
INSERT INTO bno_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ag nagtudlo Sida it maramong bagay parayan sa mga istorya nak ingtatawag nak parabula. Siling Nida: “Panimati kamo! Usang adlaw, inggwa't usang mangunguma nak nagliwas para magsabwag it binhi sa ida uma. ");
INSERT INTO bno_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sa ida pagsabwag, inggwa't ibang binhi nak nagtugpa sa rayan, ag inggwa't mga pispis nak nag-inabot ag ingpangtuktok kali. ");
INSERT INTO bno_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kag ibang binhi ay nagtugpa sa mabatong duta, ag dahil manipis yang kag raga ruto ay nagtinubo nak raan kag mga binhi. ");
INSERT INTO bno_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ugaling it katong nag-initey kag adlaw, kag mga bag-ong tubo nak tanom ay nagkupos ag nagpangyadong, dahil waya nakaungot it maado kag gamot sa irayom it raga. ");
INSERT INTO bno_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kag ibang binhi ray ay nagtugpa sa duta nak inggwa it mga siiton nak hilamunon. Nagtinubo kali, ugaling nagpakagapa kag mga hilamunon ag nayumos kag mga nagtubo nak binhi ruto. ");
INSERT INTO bno_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero kag ibang binhi ay nagtugpa sa maadong duta, ag kali ay nagtubo it maado ag nagpamunga, kada inggwa't natubas. Inggwa't mga binhi nak nagpanubas it katamtaman yang, inggwa ra't nagpanubas it rako, ag inggwa't nagpanubas it bugana. ");
INSERT INTO bno_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kamong mga nagpapanimati ay isipa ninro it maado kag inro narunggan!” ");
INSERT INTO bno_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Marugay-rugay, nagpayungot kang Hesus kag Ida mga manugsunor ag nagpangutana, “Asing Imo ingpaparayan pa sa mga istorya kag Imo pagtudlo sa mga tawo?” ");
INSERT INTO bno_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nagsabat si Hesus: “Dahil kamo yang kag gingtaw-an it pribilehiyo nak maintyendihan kag mga dating tinago nak kaayaman tungor sa paghari it Dios. Pero kag karamuan ay waya gitaw-e, kada kag tanan nak inra narurunggan ay pay mga istorya yang. ");
INSERT INTO bno_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kag tawo nak nagpapati sa ida narurunggan ay mas lalong marurugangan pa kag kaayam ag magiging bugana pa. Pero kag tawo nak waya gipapati, aber katong maisot nak pagkaintyendi raha sa ida ay abay-on pa. ");
INSERT INTO bno_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kada ngani mga istorya yang kag Ako inggagamit nak parayan sa Ako pagtudlo sa mga tawo, “dahil aber magpakamuyat man sinra ay indi gihapon sinra makakita, ag aber magpakapanimati man ay indi gihapon sinra makarungog ag makaintyendi. ");
INSERT INTO bno_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kada, natumaney sa inra kag ingsiling ni Propeta Isaias it kato nak, ‘Aber magpakapanimati man kamo ay indi gihapon kamo makaintyendi, ag aber magpakamuyat man ay indi ra gihapon ninro mabaoy kung ni-o kag gustong bisayahon it inro nakikita. ");
INSERT INTO bno_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kumo indiey giruytan kag tagipusuon it kaling mga tawo, nagpapabungoy-bungoy kag inra mga talinga, ag gingpipilot ninra kag inra mga mata, sabaling makakita pa matuor sinra, makarungog pa kag inra mga talinga, ag makaintyendi pa kag inra tagipusuon. Waya nak gador sinra it gustong makaintyendi, sabaling maghinuysoy pa sinra, ag paaduhon Nako.’ ” ");
INSERT INTO bno_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Pero abang buynas kamo, dahil naiintyendihan ninro kag inro nakikita ag narurunggan. ");
INSERT INTO bno_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Matuor kaling Ako ingsisiling sa inro. Maramong mga propeta ag mga maadong tawo nak nagtutuman sa Ako ay naghahanrom nak makita ra kag inro nakikita, ugaling ay waya ninra nakita. Inghahanrom ra ninrang marunggan kag inro narurunggan, ugaling waya kali ninra narunggi.” ");
INSERT INTO bno_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nagsiling pa si Hesus, “Ngasing, panimati-i ninro kaling Ako ipahadag sa inro it katong Ako ing-istorya tungor sa mangunguma nak nagsasabwag it mga binhi. ");
INSERT INTO bno_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Kag natabo sa ibang binhi nak nagtugpa sa rayan ay gingpapatuyar sa mga tawong nakarungog it mensahe tungor sa paghari it Dios, pero waya ninra naintyendihe kag inra narunggan. Nag-abot si Satanas nak imaw kag inghalinan it tanang kayainan, ag ing-agaw nida sa inra isip kag inra mga narunggan. ");
INSERT INTO bno_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kag natabo sa ibang binhi nak nagtugpa sa mabatong duta ay gingpapatuyar ray sa mga nakarungog it mensahe it Dios nak masadyang ingbaton nak raan kina, ");
INSERT INTO bno_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ugaling buko marayom kag ruyot it kali sa inra tagipusuon. Kada waya pa ngani narugay, it katong nag-abot kag mga pagpurba o mga pagpahirap sa inra dahil sa inra pagsunor sa mensahe, ay sa nak raan kag inra pagtu-o ay nagyamig ag nawagit. ");
INSERT INTO bno_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Kag natabo ray sa ibang binhi nak nagtugpa sa duta nak inggwa it mga siiton nak hilamunon ay gingpapatuyar sa mga nakarungog it mensahe it Dios, ugaling mas ing-una pa ninra kag pagpangalibog sa kalibutanhong mga butang ag paghanap it manggar nak imaw kag mabulag sa inra, hastang mawar-an it lugar sa inra tagipusuon kag mensahe. Kada kag inra kabuhi ay waya it bunga halin sa inra narunggan. ");
INSERT INTO bno_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero kag natabo sa ibang binhi nak nagtugpa sa maadong duta ay gingpapatuyar sa mga nakarungog it mensahe it Dios ag nakaintyendi. Kada nagkainggwa kali it bunga sa inra kabuhi. Sinra ay tuyar sa duta kung hariin kag mga binhi ay nagpanubas it bugana. Inggwa ra't nagpanubas it rako ag inggwa ra't nagpanubas it katamtaman yang.” ");
INSERT INTO bno_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Inggwa ray it ibang istoryang gingsiling si Hesus sa mga tawo. Siling Nida: “Kag paghari it Dios ay tuyar sa usang tawo nak nagsasabwag it mga maadong binhi sa ida uma. ");
INSERT INTO bno_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Usang gab-i habang katuyog kag ida mga trabahador, nag-abot kag ida kaaway, ag kag ida triguhan ay ingsabwagan it mga binhi it hilamunon bag-o humalin. ");
INSERT INTO bno_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Katong nagtuboey kag trigo ag nagburos, rungan nak nagyuaw kag mga hilamunon. ");
INSERT INTO bno_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Kada, nagsuor kag mga trabahador sa ida ag nagpangutana, ‘Sir, buko baga maadong binhi kag imo ingpasabwag sa amo sa imo uma? Asing inggwa it hilamunon nak nagtubo rili? Hariin ara kali gihalin?’ ");
INSERT INTO bno_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ingsabat nida sinra, ‘Inggwa it kaaway nak naghimo it kali!’ “Pagkarungog it kali, ingpangutana ray sida it mga trabahador, ‘Agabuton baga namo kaling mga hilamunon?’ ");
INSERT INTO bno_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Sabat nida, ‘Aya anay, sabaling magabot pati kag trigo. ");
INSERT INTO bno_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Badyang anay raha, sinra magrungan it ragko hastang sa anihon. Pag maaney, asilinggon nako kag mga manug-ani nak, “Tipunon anay kag mga hilamunon ag pangbugkos-bugkuson para sunugon. Ag kag mga trigo ay tipunon sa ako usunan.” ’ ” ");
INSERT INTO bno_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nagbisaya ray si Hesus sa inra it usa pang istorya. Siling Nida: “Kag paghari it Dios ay tuyar sa pagtubo it usang maisot nak busoy it mustasa nak ingtanom it usang tawo sa ida uma. ");
INSERT INTO bno_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kaling busoy kag pinaka-maisot sa tanang klase it busoy it mga tanom dili sa ato. Pero kung kali ay ingtanomey, kali ay marako tuyar sa mababang puno ag mapakagapa. Ag sa mga sanga it kali ay naghuhuman it pugar kag mga pispis.” ");
INSERT INTO bno_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kali pa kag usa sa mga istorya ni Hesus. Siling Nida: “Kag paghari it Dios ay tuyar sa rakong epekto it maisot nak pangpaalsa sa paghuman it tinapay. Kag maisot nak pangpaalsa nak gingyakot it usang kabade sa marakong minasang arina ay imaw kag nagpaalsa sa tanang minasa.” ");
INSERT INTO bno_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ingtudlo ni Hesus kaling tanan sa maramong tawo parayan sa mga istorya. Waya ra Sida it gingbisaya nak waya giparayanan sa istorya. ");
INSERT INTO bno_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ginghuman Nida kali agor matuman kag ingsiling it Dios parayan sa Ida propeta it kato nak, “Sa Ako pagbisaya sa inra, mga istorya kag Ako agamiton. Ako ipahadag sa inra kag mga butang nak waya napahadagan sa inra tuna tong ingtuga kag kalibutan.” ");
INSERT INTO bno_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagkatapos, ingpahalin ni Hesus kag mga tawo ag nagsuyor sida sa bayay. Nagpayungot sa Ida kag Ida mga manugsunor ag siling sa Ida, “Pahadagan sa amo kag gustong bisayahon it istorya tungor sa hilamunon sa uma.” ");
INSERT INTO bno_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Siling ni Hesus, “Ako nak dati pa ay ingtatawagey nak Anak it Tawo kag nagsabwag it maadong binhi. ");
INSERT INTO bno_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kag uma ay kag kalibutan. Ag kag mga maadong binhi ay kag mga tawong inghaharian it Dios, ag kag mga hilamunon ay kag mga tawong inghaharian ni Satanas nak imaw kag inghalinan it tanang kayainan. ");
INSERT INTO bno_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kag kaaway ra nak nagsabwag it hilamunon ay si Satanas. Kag inug-ani ay kag katapusan it kalibutan ag kag mga manug-ani ay kag mga anghel. ");
INSERT INTO bno_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Kung paunong ingpangbugkos-bugkos kag mga hilamunon para sunugon, imaw ra kag matatabo sa katapusan it kalibutan. ");
INSERT INTO bno_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay maparaya it mga anghel para bay-on kag tanang naghihimo it kayainan ag tanang mga suwail. ");
INSERT INTO bno_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ipilak sinra it mga anghel sa lugar it kayadong indi nak gador mapayong. Ag hagto sinra matinibaw ag mapangpagot kag inra mga ngisi. ");
INSERT INTO bno_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pero kag mga maadong tawo nak nagtutuman sa Dios ay mahadag it pay tuyar sa adlaw sa gingharian it inra Tatay nak Dios. Kamong mga nagpapanimati ay isipa ninro it maado kag inro narunggan!” ");
INSERT INTO bno_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nagbisaya ray si Hesus it ibang istorya, “Kag paghari it Dios ay tuyar ra sa tibor nak nakayubong sa usang bukir. Pagkakita rili it usang tawo, abang kasadya nida. Ag gingtabunan nida kali liwat ag pumauli sida. Pagkatapos, binaligya nida kag tanang ida ari-arian ag binakay katong bukir.” ");
INSERT INTO bno_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nagsiling pa si Hesus, “Kag paghari it Dios ay tuyar sa usang negosyante nak naghahanap it pinaka-magandang perlas. ");
INSERT INTO bno_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Katong nakitaey nida kag usang perlas nak abang ganda, pumauli sida ag binaligya kag tanang ida ari-arian ag ingbakay katong perlas.” ");
INSERT INTO bno_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nagsiling pa si Hesus, “Kag paghari ra it Dios ay tuyar sa lambat nak ing-iitsa sa ragat ag nakakabaoy it sari-saring isra. ");
INSERT INTO bno_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Katong punoey kag lambat, hinaas kina patakas, ag nag-ingkor kag mga tawo para hikniton kag mga isra sa lambat. Gingtipon sa kanastro kag mga maado, ag pinamilak kag mga indi makaon. ");
INSERT INTO bno_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tuyar ra kag matatabo sa katapusan it kalibutan. Mainabot kag mga anghel ag abuyagon kag mga mayain sa mga maado. ");
INSERT INTO bno_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ipilak it mga anghel kag mga naghihimo it kayainan sa lugar it kayadong inding gador mapayong. Ag hagto sinra matinibaw ag mapangpagot kag inra mga ngisi.” ");
INSERT INTO bno_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pagkatapos, nagpangutana si Hesus sa Ida mga manugsunor, “Ngasing, naintyendihan baga ninro kaling tanan?” Nagsabat sinra, “Opo.” ");
INSERT INTO bno_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ag nagsiling ray si Hesus, “Kada ngasing, ayamey ra ninrong kag bawat manunudlo it Kasuguan nak nagpasakopey sa paghari it Dios, ay tuyar sa mayaman nak tag-iya it bayay nak inggwa it maramong mga magandang butang. Ag maayam sida kung pauno gamiton kag mga bag-o, pati kag mga yuma.” ");
INSERT INTO bno_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pagkatapos it kaling pagtudlo ni Hesus parayan sa mga istorya naghalin Sida ruto. ");
INSERT INTO bno_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pagkatapos, nagpauli Sida sa Ida sariling banwa kung hariin Sida girako ag nagtudlo sa inra sinagoga. Ag natingaya kag mga nakarungog sa Ida ag napasiling sinra, “Hariin Sida gibaoy it Ida kaayam? Pauno Sida nakakahuman it Ida mga milagro? ");
INSERT INTO bno_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Buko baga Sida kag anak it panray? Ag kag Ida nanay ay si Maria? Ag sina Santiago, Jose, Simon ag Judas kag Ida mga hali nak kayake? ");
INSERT INTO bno_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ag di baga dili ra sa ato nag-iistar kag Ida mga hali nak kabade? Hariin Nida natun-an kinang tanan?” ");
INSERT INTO bno_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ag waya nak gador ninra nakilaya Sida. Pero siling ni Hesus sa inra, “Kag propeta ay ingtatahor aber hariin puyra yang sa ida sariling banwa ag pamilya.” ");
INSERT INTO bno_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ag dahil waya sinra it pagtu-o sa Ida, apila yang kag Ida inghumang milagro ruto. ");
INSERT INTO bno_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Katong nakaabot kang Herodes Antipas nak gobernador it Galileya kag balita tungor kang Hesus, ");
INSERT INTO bno_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nagsiling sida sa ida mga opisyales nak, “Kina ay si Juan nak Manugbawtismo. Nabanhaw sida, kada nakakahuman sida it mga milagro.” ");
INSERT INTO bno_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nasiling nida kali dahil sa ida inghuman kang Juan it kato. Ida ingparakop si Juan, ingpagapos ag ingpapriso, dahil imaw kag gusto it ida asawa nak si Herodias. Kaling si Herodias kag dating asawa it maguyáng ni Herodes nak imaw si Felipe. Ag parehong ingbuyagan nina Herodes ag Herodias kag inra unang asawa agor sinrang ruha kag maasawa. ");
INSERT INTO bno_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Dahil dili, puat ingbibisayahan ni Juan si Herodes nak, “Bawal sa Kasuguan it Dios nak asawahon nimo kinang kabade.” ");
INSERT INTO bno_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kada gusto ni Gobernador Herodes nak ipamatay tan-a si Juan, pero nahadlok sida sa mga tawo, dahil ingkikilaya ninrang propeta si Juan nak Manugbawtismo. ");
INSERT INTO bno_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pag-abot it kompli-anyo ni Gobernador Herodes, nagsadaw sa atubangan it ida mga bisita kag rayagang anak ni Herodias, ag namut-an kali ni Gobernador Herodes. ");
INSERT INTO bno_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kada nagpromisa sida riling rayaga nak ita-o kung ni-o man kag ida ahagaron. ");
INSERT INTO bno_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ag dahil sa sugsog it ida nanay nagsiling kaling rayaga, “Taw-an sa ako kag uyo ni Juan nak Manugbawtismo nak nakabutang sa bandihado.” ");
INSERT INTO bno_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dahil dili nalisor nak gador si Gobernador Herodes, pero dahil sa ida gingpromisa sa atubangan it ida mga bisita, ingsugo nida nak ita-o yangey kag inghagar it rayaga. ");
INSERT INTO bno_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kada ingpapugutan si Juan sa prisuhan. ");
INSERT INTO bno_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ag ingraya ninra kag uyo ni Juan nak nakabutang sa bandihado, ag ingta-o ninra sa rayaga. Pagkabaton nida, ingrayang raan nida kina sa ida nanay. ");
INSERT INTO bno_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pagkasador kali it mga manugsunor ni Juan, nagpagto sinra ag ingbaoy kag ida yawas ag ingyubong. Bag-o, gingpaayam ninra kali kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Katong narunggan ni Hesus nak ingpugutan si Juan nak Manugbawtismo, naghalin Sida ruto sa karamuan kaibahan it Ida mga disipulos, ag nagsakay sa rayapang patabok sa lugar nak waya't mga tawo. Tong nasaduran it mga tawo nak naghaliney sina Hesus nagyanat sinra sa Ida. Halin sa mga banwa, nagpamaybayan sinra papagto sa lugar kung hariin nagpagto sina Hesus. ");
INSERT INTO bno_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagrunggo nina Hesus sa habig it baybay, nakita ninra kag abang ramong tawo. Naluoy si Hesus sa inra ag ingpaado Nida kag mga di sakit. ");
INSERT INTO bno_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tong pasugbuhoney kag adlaw, kag Ida mga disipulos ay nagpayungot sa Ida ag nagsiling, “Bukir pa man kali ag haponey. Kada papagtu-a anay kinang mga tawo raha sa mga baryo pramas makabakay sinra it inra makakaon.” ");
INSERT INTO bno_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero siling ni Hesus sa inra, “Bukoey kinahangyan nak maghinalin pa sinra. Kamo it mapakaon sa inra.” ");
INSERT INTO bno_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nagsabat sinra, “Limang bilog yang nak tinapay ag ruhang bilog nak tinapahang isra kag hali sa ato.” ");
INSERT INTO bno_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Siling ni Hesus, “Ray-a kina rili sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Masunor, ingpaingkor anay Nida kag mga tawo sa hilamunon, ag ingbaoy Nida kinang limang bilog nak tinapay ag ruhang bilog nak tinapahang isra. Nagtanga Sida sa langit ag nagpasalamat anay sa Dios. Pagkatapos ay Ida gingparti-parti kaling mga tinapay ag tinapahang isra hastang kali ay nagramo, bag-o gingta-o sa Ida mga disipulos agor sinra it mapana-o sa mga tawo. ");
INSERT INTO bno_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nagkinaon sinrang tanan ag nabusog. Pagkatapos, ingpangtipon it mga disipulos kag mga natura ag nakapuno pa sinra it doseng tabig. ");
INSERT INTO bno_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ruto sa mga nagkaon ay inggwa it limang libong kayake. Ag sa pagbilang ay buko pa kaumir rili kag mga kabade ag mga anak. ");
INSERT INTO bno_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pagkatapos, ingpasakay nak raan ni Hesus sa rayapang kag Ida mga disipulos ag ingpauna sa tabok it ragat habang Ida ingpapauli kag mga tawo. ");
INSERT INTO bno_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagkahalin it mga tawo, ausa Sidang nabilin ruto ag nagtukar Sida sa baguntor agor magpangamuyo. Naabutan Sida it gab-i ruto nak ausa. ");
INSERT INTO bno_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Katong oras nak kato, sa yaworey kag rayapang nak ingsasakyan it Ida mga disipulos. Nagyain kag panahon ag inglalampusan it bayor kag rayapang dahil sungsungon kag hangin. ");
INSERT INTO bno_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Katong aga-agay, nagpayungot si Hesus sa inra nak nagpapanaw sa ibabaw it tubi. ");
INSERT INTO bno_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagkakita sa Ida it mga disipulos nak nagpapanaw Sida sa ibabaw it tubi, abang kahadlok ninra ag napaukaw it, “Aroy! Murto!” ");
INSERT INTO bno_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sa nak raan nagsiling si Hesus sa inra, “Aya kamo gikahadlok. Ako kali! Kusuge kag inro buot!” ");
INSERT INTO bno_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pagkarungog kali ni Pedro, siling nida, “Gino-o, kung Ikaw talaga kina, papanawa ra ako sa ibabaw it tubi papanha sa Imo.” ");
INSERT INTO bno_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ag siling ni Hesus, “Maley!” Nagsalta si Pedro sa rayapang ag pumanaw sa ibabaw it tubi papagto kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero katong namalayan nida nak nagraragko kag bayor dahil sa makusog nak hangin, nahadlok sida ag inot-inot sida it pairayom, kada pumakaukaw sida, “Gino-o, tabangi ako!” ");
INSERT INTO bno_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sa nak raan, inghunat ni Hesus kag Ida damot ag hinawiran sida. Ag nagsiling si Hesus, “Kaisot kag imo pagtu-o! Asing nagruruha-ruha ikaw?” ");
INSERT INTO bno_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Masunor, nagsakay sinra sa rayapang ag naggulpi it kalma kag hangin. ");
INSERT INTO bno_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ag ingdayaw Sida it mga disipulos ruto sa rayapang ag nagsiling sinra sa Ida, “Matuor nak Ikaw kag Anak it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagkatapos, nagtabok sinra sa ragat ag nagrunggo sa lugar it Genesaret. ");
INSERT INTO bno_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nakilaya si Hesus it mga taga-ruto ag gingpamalitang raan sa tanang lugar palibot ruto kag pag-abot Nida. Kada ingraya it mga tawo sa Ida kag tanang di sakit. ");
INSERT INTO bno_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nagpakitluoy sinra sa Ida nak aber pahuytan yang kag gadar it Ida baro sa mga di sakit. Ag matuor, kag tanang nakahudot ay nag-ado. ");
INSERT INTO bno_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Usang adlaw, inggwa it mga Pariseo ag mga Manunudlo it Kasuguan halin sa Herusalem nak nagpayungot kang Hesus, ag nagpangutana sa Ida, ");
INSERT INTO bno_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Asing waya gisusunra it Imo mga manugsunor kag mga sulunranon nak gingmat-an it ato mga maguyang? Asing nagkakaon sinra it waya gipapanghinaw it damot kumporme sa ato sulunranon?” ");
INSERT INTO bno_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nagsabat si Hesus, “Ay kamo, asing waya ra ninro gisusunra kag Kasuguan it Dios, dahil baga sa inro mga sulunranon? ");
INSERT INTO bno_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Halimbawa, kag mga sugo it Dios ay, ‘Tahura kag imo tatay ag nanay,’ ag ‘Si-o man kag magsumpa sa ida tatay o nanay ay dapat mamatay.’ ");
INSERT INTO bno_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero sa inro pagtudlo, kag usang tawo ay puyding magsiling sa ida mga maguyang nak, ‘Ibulig tan-a kali nako sa inro, ugaling inghalarey kali nako sa Dios,’ ");
INSERT INTO bno_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","kada bukoey sida obligado nak sustentuhan pa kag ida mga maguyang. Dahil dili, ingbabaliwaya ra ninro kag mga sugo it Dios ag ingtutuman yang kag inro mga sulunranon. ");
INSERT INTO bno_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mga pakitang tawo yang! Tamang gador kag ingsiling it Dios parayan kang Propeta Isaias tungor sa inro. ");
INSERT INTO bno_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Siling Nida, “ ‘Ingtatahor yang Ako it kaling mga tawo sa inra yuba, pero kag inra tagipusuon ay mayado sa Ako. ");
INSERT INTO bno_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Waya it puyos kag inra pagdayaw sa Ako, dahil kag inra ingtutudlo ay mga kasuguan yang it tawo, pero inra ingsisiling nak kina ay mga Kasuguan kuno Nako.’ ” ");
INSERT INTO bno_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gingpayungot ni Hesus sa Ida kag mga tawo ag ingsilinggan nak, “Panimati-i kaling ibisaya Nako sa inro ag intyendihon it maado. ");
INSERT INTO bno_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Waya it bagay nak nagsusuyor sa yuba it tawo pramas sida ay maging mabuling sa pagmuyat it Dios, kundi katong nagliliwas.” ");
INSERT INTO bno_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ngasing, nagpayungot kag mga manugsunor sa Ida ag nag-uma. Siling ninra, “Gino-o, ayam baga nimo nak napayain kag mga Pariseo dahil sa Imo ingbisaya?” ");
INSERT INTO bno_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nagsabat si Hesus, “Kag tanang tanom nak waya gitamnan it ako Tatay sa langit ay Ida agabuton sa palaabuton. ");
INSERT INTO bno_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabad-e yang sinra! Sinra ay pay mga bulag nak nag-aagkay sa kaparehong bulag. Kung bulag kag maagkay sa tawong bulag, pareho sinrang mahuhuyog sa buho!” ");
INSERT INTO bno_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nagpangutana si Pedro sa Ida, “Pahadagan sa amo kung ni-o kag gustong bisayahon it katong Imo ing-istorya it kuman tungor sa mga niong bagay kag nagpapabuling sa tawo sa pagmuyat it Dios?” ");
INSERT INTO bno_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nagsiling si Hesus, “Asi pati ra kamo ay waya pa nakaintyendi? ");
INSERT INTO bno_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Waya pa baga ninro naiintyendihe nak kag nagsusuyor sa yuba it tawo ay nagdidiretso sa bituka ag inaliwas? ");
INSERT INTO bno_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero kag kayainan nak nagliliwas sa yuba ay halin sa tagipusuon, ag imaw kina kag nagpapabuling sa tawo. ");
INSERT INTO bno_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dahil naghahalin sa tagipusuon kag mga hanrom nak mayain tuyar sa pagpangmatay, pagpangawatan, pag-ubay sa buko imo sariling asawa, pagpanakaw, pagpangsira sa isigkatawo ag pagpasipala. ");
INSERT INTO bno_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Imaw kali kag mga nagpapabuling sa tawo. Pero kung makaon nak waya anay gipapanghinaw it damot kumporme sa pagtudlo it mga Pariseo ay waya kina gipapabuling sa tawo.” ");
INSERT INTO bno_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pagkatapos, naghalin ruto si Hesus ag nagpagto sa mga lugar palibot sa mga banwa it Tiro ag Sidon. ");
INSERT INTO bno_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ruto ay inggwa't nag-iistar nak usang kabade nak buko Hudyo. Sida ay halin sa lahi it mga taga-Canaan it kato. Nagpayungot sida kang Hesus nak nag-uukaw, “Gino-o, Inanak ni Haring David, kaluy-i ako! Kag ako anak nak kabade ay ingsasaniban it mayaot ag ingpapahirapan nak gador sida.” ");
INSERT INTO bno_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero gingpabunguy-bunguyan yang sida ni Hesus, kada gingpayungutan Sida it Ida mga manugsunor ag nagsiling sa Ida, “Pahalina kina. Kasasapot! Pakasunor-sunor sa ato ag pakaukaw.” ");
INSERT INTO bno_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Siling ni Hesus, “Ingpapali Ako para yang sa mga lahi it Hudyo nak sinra ay tuyar sa mga karnerong yaag.” ");
INSERT INTO bno_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero katong kabade ay nagsunor gihapon ag nagyuhor sa atubangan ni Hesus ag nagpapaka-siling nak, “Gino-o, buligi ako!” ");
INSERT INTO bno_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ugaling gingsabat sida ni Hesus, “Buko tama nak bay-on kag pagkaon sa mga anak ag ibahog sa mga iro.” ");
INSERT INTO bno_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero nagsabat kag kabade, “Oho ngani, Gino-o, pero miskin mga iro ay nagkakaon ra it mga mumog nak nahuhuyog sa irayom it lamesa it inra amo.” ");
INSERT INTO bno_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pagkarungog ni Hesus sa ida sabat, nagsiling Sida, “Nang, abang rako ka imo pagtu-o! Matutuman kinang imo inghahagar.” Ag katong oras rang kato ay nag-ado kag ida anak. ");
INSERT INTO bno_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pagkahalin ruto, nagpagto si Hesus sa habig it Ragat it Galileya, ag nagtukar Sida sa usang baguntor ag nag-ingkor ruto. ");
INSERT INTO bno_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nag-inabot kag karuramong tawo nak di rayang mga piang, bulag, yupog, udom ag maramong iba pang mga di sakit. Pinangbutang ninra sa atubangan ni Hesus kaling tanan ag Ida ingpaado sinrang tanan. ");
INSERT INTO bno_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pagkakita it mga tawo nak nakabisayay kag mga udom, nag-adoy kag mga yupog, nakapanawey kag mga piang, ag nakakitaey kag mga bulag, abang katingaya ninra ag nagdayaw sinra sa Dios it Israel. ");
INSERT INTO bno_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pagkalipas it tatlong adlaw ruto, ging-ayaba ni Hesus kag Ida mga disipulos ag nagsiling, “Naluluoy Ako riling mga tawo. Tatlong adlawey nato sinrang kanunot ag wayaey sinra it akaunon. Waya Ako it gustong pahalinon sinrang gutom sabaling malupyo sinra sa rayan.” ");
INSERT INTO bno_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nagsabat kag Ida mga disipulos, “Riin kita mabaoy it ipakaon sa tuyar it ramong tawo rili sa lugar nak waya it kabayay-bayay?” ");
INSERT INTO bno_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nagpangutana si Hesus, “Pilang bilog kag tinapay ninro raha?” Sabat ninra, “Pito, ag pilang bilog nak tinapahang isra nak maintik.” ");
INSERT INTO bno_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Masunor, ingpaingkor anay ni Hesus kag mga tawo, ");
INSERT INTO bno_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ag ingbaoy Nida katong pitong bilog nak tinapay ag mga tinapahang isra. Nagpasalamat anay Sida sa Dios, ag ingparti-parti Nida kali hastang nagramo, bag-o ingta-o sa Ida mga disipulos kag mga tinapay ag isra, ag sinra ray kag nagpana-o sa mga tawo. ");
INSERT INTO bno_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nagkinaon sinrang tanan ag nabusog. Pagkatapos, ingpangtipon it mga disipulos kag mga natura ag nakapuno pa sinra it pitong marakong tabig. ");
INSERT INTO bno_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ruto sa mga nagkaon ay inggwa it ap-at nak libong kayake. Ag sa pagbilang ay buko pa kaumir rili kag mga kabade ag mga anak. ");
INSERT INTO bno_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagkatapos, ingpapauliey ni Hesus kinang mga tawo bag-o Sida nagsakay sa rayapang kaibahan kag Ida mga disipulos papagto sa lugar it Magadan. ");
INSERT INTO bno_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pag-abot ninra ruto, inggwa't mga Pariseo ag Saduseo nak nagpayungot kang Hesus. Gusto ninrang purbahan kung talagang Sida ay ingparaya it Dios, kada naghagar sinra it usang milagro halin sa langit bilang pamatuor. ");
INSERT INTO bno_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero nagsabat si Hesus sa inra, “Kung puya kag sugbuhan nasiling kamo nak, ‘Masilak insulip dahil puya kag sugbuhan.’ ");
INSERT INTO bno_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ag kung karuyom kag langit sa aga nasiling ray kamo nak, ‘Mauyan isag dahil karuyom kag langit.’ Nababasa ninro kag mga tanra it panahon sa langit, pero indi ninro mabasa kag mga tanra nak ingpapakita it Dios tungor sa natatabo sa ngasing nak panahon! ");
INSERT INTO bno_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kag mga tawo sa ngasing nak panahon ay subrang yain ag buko matutom sa Dios! Aber tuyar, ingpapaka-hanapan gihapon ninra Ako it milagro bilang pamatuor kung sin-o talaga Ako. Pero waya it ibang ipakita sa inra, kundi kag natabo yang it kato kang Propeta Jonas.” Pagkatapos, ingbadaan sinra ruto nina Hesus. ");
INSERT INTO bno_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pagkatabok nina Hesus sa kayudong rekudo, namalayan it mga manugsunor nak waya yaki sinra nakaraya it bayon nak tinapay. ");
INSERT INTO bno_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ag nagsiling si Hesus sa inra, “Mag-andam kamo sa pangpaalsa it mga Pariseo ag mga Saduseo.” ");
INSERT INTO bno_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pagkarungog kali it mga manugsunor, nag-istoryahan sinra. Siling ninra, “Yati ngani, waya abi kita it bayon nak tinapay e, kada nasiling Nida kato.” ");
INSERT INTO bno_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ayam ni Hesus kung ni-o kag inra ing-iistorya, kada ingpangutana Nida sinra, “Asing ingkakalibgan ninro kung waya kamo it bayon nak tinapay? Abang isot kamo it pagtu-o! ");
INSERT INTO bno_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Waya pa baga gihapon kamo nakakaintyendi? Nalimutaney baga ninro katong ingparti-parti Nako kag limang bilog yang nak tinapay hastang kina ay nagramo ag ingpakaon sa subrang limang libong tawo? Ag nalimtaney baga ninro kung pilang tabig kag natura? ");
INSERT INTO bno_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Imaw ra katong pitong bilog nak tinapay nak ingparti-parti hastang kina ra ay nagramo para sa subrang ap-at nak libong tawo. Pilang marakong tabig pa kag natura? ");
INSERT INTO bno_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Asing waya ninro naiintyendihe kag Ako ingbibisaya sa inro nak buko tinapay kag Ako ingpapaandam, kundi kag pangpaalsa it mga Pariseo ag mga Saduseo!” ");
INSERT INTO bno_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kada ngasing, naintyendihaney it mga manugsunor nak buko yaki tungor sa pangpaalsa nak inggagamit sa tinapay kag pagpaandam ni Hesus sa inra, kundi tungor sa salang tudlo it mga Pariseo ag Saduseo. ");
INSERT INTO bno_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Katong nag-abot sina Hesus sa lugar it Cesareya Pilipos, gingpangutana Nida kag Ida mga manugsunor, “Siling it mga tawo sin-o kuno Ako nak dati pa ay ingtatawagey nak Anak it Tawo?” ");
INSERT INTO bno_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nagsabat sinra, “Kag siling it iba, Ikaw kuno ay si Juan nak Manugbawtismo. Siling ray it iba, Ikaw kuno ay si Propeta Elias. Ag inggwa ra it nagsisiling nak, Ikaw kuno ay si Propeta Jeremias o usa sa iba pang mga propeta it kato.” ");
INSERT INTO bno_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nagpangutana ray si Hesus sa inra, “Pero kamo, sin-o Ako para sa inro?” ");
INSERT INTO bno_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nagsabat si Simon Pedro, “Ikaw kag gingpromisang Kristo nak Anak it buhi nak Dios.” ");
INSERT INTO bno_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pagkarungog ni Hesus it kaling ida sabat, siling Nida sa ida, “Abang buynas ikaw Simon nak anak ni Jonas, dahil buko kag mga tawo kag nagpasador sa imo it kaling kamatuuran kundi kag Ako Tatay sa langit. ");
INSERT INTO bno_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ag ingsisiling Nako sa imo, ikaw ay kilaya rang Pedro nak kag gustong bisayahon ay bato. Ag riling bato, ay Ako itugrok kag Ako iglesya nak imaw kag tanang nagtutu-o sa Ako, ag aber kag gahom ni Satanas ag tanang ida mga sinakupan ay indi makapirde dili. ");
INSERT INTO bno_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ita-o Nako sa imo kag karapatan tuyar sa naghuhudot it mga dawi it Gingharian it Dios. Aber ni-o kag imo ingbabawal rili sa duta ay imaw ra sa langit, ag aber ni-o man kag imo itugot rili sa duta ay imaw ra sa langit.” ");
INSERT INTO bno_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pagkatapos ay Ida ingtugon kag Ida mga manugsunor nak inding gador giuma aber kanin-o nak Sida kag Kristo nak gingpromisa it Dios. ");
INSERT INTO bno_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tuna it kato, ingtunaaney ni Hesus it pahadag sa Ida mga manugsunor nak Sida ay kinahangyang magpagto sa Herusalem, ag matiis it maramong hirap sa damot it mga pinuno it mga Hudyo, mga Punong Saserdote ag mga Manunudlo it Kasuguan. Siling pa Nida, Sida ay amatyon, pero sa pangtatlong adlaw, Sida ay mababanhaw. ");
INSERT INTO bno_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagkarungog it kali ni Pedro, ingraya anay nida si Hesus sa habig-habig ag gingsaway, “Gino-o, kabay pang indi kina gitugot it Dios nak matabo sa Imo.” ");
INSERT INTO bno_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero ing-atubang sida ni Hesus ag nagsiling, “Payado sa Ako, Satanas! Imo Ako ingpipigahan sa pagtuman sa kabubut-on it Dios. Kag imo ging-iisip ay buko para sa Dios kundi para sa tawo.” ");
INSERT INTO bno_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pagkatapos, nagsiling si Hesus sa Ida mga manugsunor: “Sin-o man sa inro kag gustong magsunor sa Ako ay dapat limtan kag ida sariling kagustuhan, ag pas-anon kag ida krus, nak kag gustong bisayahon ay hanraey sidang magtiis it hirap hastang sa kamatayon, alang-alang sa ida pagsunor sa Ako. ");
INSERT INTO bno_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kag tawong nagsasalig yang sa ida sarili ay imaw kag mawawar-an it kabuhi nak waya't katapusan. Pero kag tawo nak ingbabaliwaya kag ida sarili para yang magsunor sa Ako ay imaw kag magkakainggwa it kabuhi nak waya't katapusan. ");
INSERT INTO bno_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ni-o kag mapapakamos it usang tawo aber mapasa-ida man kag bug-os nak kalibutan, kung mawawagit ra kag ida kabuhi? Mababayduhan baga it aber niong butang it tawo kag ida kabuhi? Syempre indi! ");
INSERT INTO bno_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Dahil Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay mabalik sa kahimayaan it Ako Tatay, ag kanunot kag Ida mga anghel. Ag imaw kag oras nak Ako ita-o kag tamang kabadaran sa bawat tawo kumporme sa ida ginghimo. ");
INSERT INTO bno_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Matuor kaling Ako ingsisiling sa inro. Inggwa it ibang nagtitinrog dili nak indi makaagom it kamatayon, hastang waya ninra nakikita kag pagpaali Nako bilang Hari, Ako nak dati pa ay ingtatawagey nak Anak it Tawo.” ");
INSERT INTO bno_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagkalipas it an-om nak adlaw, gingnunot ni Hesus si Pedro ag kag magmanghor nak sina Santiago ag Juan, patukar ruto sa usang mataas nak baguntor nak sinra-sinra yangey. ");
INSERT INTO bno_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","It katong hagtoy sinra nakita ninra nak nagyabot kag hitsura ni Hesus sa inra atubangan. Naghadag it pay adlaw kag Ida uda ag nagputi it kasusilaw kag Ida baro. ");
INSERT INTO bno_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","It yang pakita sina Moises ag Propeta Elias, ag sinra ay nagpakig-istorya kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kada, napasiling si Pedro kang Hesus, “Gino-o, maado nak hali kami! Kung gusto Nimo, matukor ako it tatlong pasilungan no? Usa para sa Imo, usa para kang Moises ag usa para kang Elias.” ");
INSERT INTO bno_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Myentras nagbibisaya pa sida ay nayampuyan sinra it kasusilaw nak rampog, ag halin raha ay inggwa it Boses nak nagsiling, “Imaw kali kag Ako Pinalanggang Anak nak Ako namumut-an. Panimati kamo sa Ida!” ");
INSERT INTO bno_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagkarungog it mga disipulos diling Boses, abang kahadlok ninra ag naparapa sinra. ");
INSERT INTO bno_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ingpayungutan sinra ni Hesus ag inghuytan. Siling Nida, “Tinrog kamo, ag aya gikahadlok!” ");
INSERT INTO bno_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ag katong nagtanga sinra, wayaey sinra it ibang nakita ruto kundi si Hesus yangey. ");
INSERT INTO bno_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ag habang nag-uus-os sinra halin sa baguntor, ingtugon sinra ni Hesus nak, “Aya gipang-uma-umaan aber kanin-o kag inro nakita, hastang waya pa nababanhaw Ako nak dati pa ay ingtatawagey nak Anak it Tawo.” ");
INSERT INTO bno_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Masunor, ingpangutana si Hesus it kinang tatlo, “Asing nagsisiling kag mga Manunudlo it Kasuguan nak dapat magpaali anay si Propeta Elias?” ");
INSERT INTO bno_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nagsabat si Hesus, “Matuor, dapat magpaali anay si Elias para maghanra it tanang butang. ");
INSERT INTO bno_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero kag Ako masisiling sa inro ay nakapaley si Elias. Ugaling waya sida gikilay-a it mga tawo ag inra ingpahirapan sida kumporme sa inra gusto. Ag imaw ra, Ako nak dati pa ay ingtatawagey nak Anak it Tawo ay apahirapan ra ninra.” ");
INSERT INTO bno_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pagsiling ni Hesus it kina, naintyendihan it mga manugsunor nak si Juan nak Manugbawtismo yaki kag Ida gingsisiling nak Elias. ");
INSERT INTO bno_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagbalik ni Hesus ag Ida tatlong disipulos sa ubos it baguntor ay karamong tawoy ruto. Inggwa it usang kayaking nagpayungot kang Hesus ag nagyuhor sa Ida atubangan, bag-o nagsiling, ");
INSERT INTO bno_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Gino-o, kaluy-i kag ako anak! Sida ay ingtitigbak ag napapaka-hirapan pag ing-aabot. Permi sidang natutumba sa kayado ag sa tubi. ");
INSERT INTO bno_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ingrayay nako sida sa Imo mga disipulos, pero waya ninra napaado.” ");
INSERT INTO bno_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nagsabat si Hesus, “A! Kamong mga tawo sa ngasing nak panahon ay mga waya't pagtu-o ag mga matugas it uyo! Hastang sauno pa Nako kamo dapat ibhan ag tis-an? Hala! Maley, ray-a kinang imo anak dili sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ingsaway ni Hesus kag mayaot ag naghalin kato sa anak, ag sa nak raan nag-ado sida. ");
INSERT INTO bno_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pagkatapos it kina, katong sinra yangey, nagpayungot kag mga disipulos kang Hesus ag nagpangutana, “Asing waya namo napalayas katong mayaot?” ");
INSERT INTO bno_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nagsabat si Hesus, “Dahil kuyang kag inro pagtu-o! Matuor kaling Ako ingsisiling sa inro. Kung inggwa kamo it pagtu-o aber tuyar yang it isot sa busoy it mustasa, pwede ninrong silinggan kaling baguntor, ‘Saydo hagto!’ Ag masaydo kali. Ag makakahuman kamo it aber ni-o. ");
INSERT INTO bno_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero sa parayan yang it pagpangamuyo ag pagpuasa, mapapahalin kinang tuyar it klasing mayaot.” ");
INSERT INTO bno_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Usang adlaw, nagtipon ray kag mga manugsunor sa Galileya, ag nagsiling si Hesus sa inra, “Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay atraiduron ag ita-o sa damot it mga mahusgar sa Ako. ");
INSERT INTO bno_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Amatyon ninra Ako, pero sa pangtatlong adlaw Ako ay mababanhaw.” Pagkarungog kali it mga manugsunor, abang kalisor ninra. ");
INSERT INTO bno_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagbalik nina Hesus sa banwa it Capernaum, nagpayungot kang Pedro kag mga manugsukot it buhis it Templo ag ingpangutana sida, “Nagbabadar baga it buhis sa Templo kag inro maestro?” ");
INSERT INTO bno_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nagsabat si Pedro, “Oho, syempre.” Pagkatapos, nagsuyor sida sa bayay ag nauna si Hesus magpangutana sa ida, “Ni-o sa Imo muyat, Simon? Kanin-o gisusukot it mga buhis kag mga hari rili sa duta, sa inra mga anak o sa iba?” ");
INSERT INTO bno_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nagsabat si Pedro, “Sa iba!” Siling ray ni Hesus, “Kung tuyar, bukoey kinahangyan nak magbadar kag inra mga anak no? ");
INSERT INTO bno_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero miskin tuyar, pramas waya sinra it masiling sa ato, pagto sa ragat ag iitsa kag imo bunit ruto. Bay-a kag unang isra nak makubit ag buk-a kag yuba, ag inggwa ka it makikitang kwarta nak balor it buhis natong ruha. Bay-a kina ag ibadar kag buhis sa Templo para sa atong ruha.” ");
INSERT INTO bno_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Katong oras nak kato, nagpayungot kang Hesus kag mga disipulos ag nagpangutana, “Gino-o, sin-o kag pinaka-yabaw sa tanan sa gingharian it Dios?” ");
INSERT INTO bno_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pagkarungog ni Hesus it kali, ing-ayaba Nida kag usang anak ag ingpapayungot sa inra tunga. ");
INSERT INTO bno_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ag nagsiling Sida sa inra: “Matuor kaling Ako ingsisiling sa inro. Kung kamo ay indi magbag-o ag magpatuyar sa mga anak, inding gador kamo makaagom it paghari it Dios. ");
INSERT INTO bno_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kag si-o mang nagpapaubos it tuyar sa anak nak kali, ay imaw kina kag pinaka-yabaw sa mga ginghaharian it Dios. ");
INSERT INTO bno_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ag aber si-o man kag nagbabaton sa usang mapainubusong tawo nak nagsusunor sa Ako, tuyar diling anak, ay nagbabaton ra sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nagsiling pa si Hesus, “Aber sin-o man kag maging dahilan it pagkasala it usang mapainubusong tawo tuyar riling mga anak nak nagtutu-o sa Ako, ay mas maado pang maghigot yangey sida sa liog it marakong bato nak panggiling ag ihuyog sa ragat. ");
INSERT INTO bno_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kahahadlok kag matatabo sa mga tawo sa kalibutan dahil sa maramong bagay nak nagiging dahilan pramas sinra ay mahuyog sa pagpakasala! Inding gador mawagit kag mga tuyar nak dahilan, pero mas kahahadlok kag matatabo sa tawong imaw kag inghahalinan it pagkakasala it ida isigkatawo! ");
INSERT INTO bno_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ag kung kag imo damot o siki kag magiging dahilan it imo pagpakasala, utuya ag ipilak! Maado pang mag-agom ka it kabuhi nak waya't katapusan nak utoy kag usang siki o damot, kisa ipilak ka sa kayado nak inding gador mapayong nak inggwa it ruhang damot o ruhang siki. ");
INSERT INTO bno_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Imaw ra, kung kag imo mata kag magiging dahilan it imo pagpakasala, yukata ag ipilak! Mas maado pang mag-agom ka it kabuhi nak waya't katapusan nak usa yang kag mata, kisa ruha ngani, kung ipilak yang ra ikaw sa kayado ruto sa impyerno.” ");
INSERT INTO bno_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nagsiling pa si Hesus, “Magrahan kamo nak indi gimayainon aber usa sa mga anak nak kali. Dahil ingsisiling Nako sa inro, kag inra mga anghel ay puat nakaatubang sa Ako Tatay sa langit. ");
INSERT INTO bno_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Ag Ako nak dati pa ay ingtatawagey nak Anak it Tawo kag nagpaali agor luwason kag mga tawong nayaag.) ");
INSERT INTO bno_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Halimbawa, kung inggwa it usang tawo nak nagbabantay sa usang gatos nak karnero ag nayaag kag usa, ni-o kag ida ahimuon? Di baga ibilin anay nida kag nobentay-nuybe nak nagsasabsab sa bukir agor hanapon katong nayaag? ");
INSERT INTO bno_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Matuor kaling Ako ingsisiling sa inro. Kung makita nida kali, mas marako kag ida kasadya dahil diling usa, kisa sa nobentay-nuybe nak waya nayaag. ");
INSERT INTO bno_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tuyar ra kag pamatyag it inro Tatay sa langit. Waya Sida gusto nak mawagit kag aber usa sa mga anak nak kali.” ");
INSERT INTO bno_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nagsiling ra si Hesus, “Kung inggwa it hali sa pagtu-o nak nakasala sa imo, payungute sida ag bisayahan it sida yang. Kung abatunon nida kag ida nahimong sala, mabalik kag inro maadong relasyon. ");
INSERT INTO bno_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero kung indi sida magbaton it ida kasal-anan, nuntan kag usa o ruhang hali sa pagtu-o agor sinra it matestigo sa kamatuuran nak inro ing-iistorya. ");
INSERT INTO bno_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ag kung indi pa gihapon sida magbaton it ida kasal-anan sa inra atubangan, umaan kali sa grupo it mga nagtutu-o. Ag kung indi pa gihapon sida magbaton it ida kasal-anan sa inra atubangan, ipamutang sida nak wayaey it pagtu-o sa Dios o sida ay makasal-anan tuyarey sa usang manugsukot it buhis. ");
INSERT INTO bno_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Matuor kaling Ako ingsisiling sa inro. Aber ni-o kag inro ingbabawal rili sa duta ay imaw ra sa langit, ag aber ni-o man kag inro itugot rili sa duta ay imaw ra sa langit. ");
INSERT INTO bno_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ag usa pa, matuor nak gador kaling Ako ingsisiling sa inro. Kung kag ruha sa inro rili sa duta ay magkausa ag magpangamuyuan, atumanon it Ako Tatay sa langit kag inro inghahagar, ");
INSERT INTO bno_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","dahil miskin riin kung inggwa it ruha o tatlong nagtitipon dahil sa inra pagtu-o sa Ako, hagto Ako kaibhanan ninra.” ");
INSERT INTO bno_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pagkatapos, nagpayungot si Pedro kang Hesus ag nagpangutana sa Ida, “Gino-o, kung nakasala sa ako kag usa nakong hali sa pagtu-o, pilang beses nako sidang apatawaron? Hastang pitong beses baga?” ");
INSERT INTO bno_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Gingsabat sida ni Hesus, “Buko yang pitong beses kundi sitentay-syeteng beses pa. ");
INSERT INTO bno_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kumo kag paghari it Dios ay puyding ikumpara sa usang hari nak gustong magpanukot it utang sa ida mga suguon. ");
INSERT INTO bno_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kag unang ida ingsukot ay inggwa it utang nak pilang milyong pesos, ");
INSERT INTO bno_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","pero waya sida it ibadar. Kada ingsugo it hari nak ibaligya kinang tawo bilang ulipon, kaibahan kag ida asawa, mga anak ag tanang ida ari-arian pramas makabadar. ");
INSERT INTO bno_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kada, nagyuhor kaling suguon sa atubangan it hari ag nagpakitluoy. Siling nida, ‘Pinalanggang Hari, taw-e pa ako it panahon ag abadaran ka nako it tanang ako utang sa imo.’ ");
INSERT INTO bno_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naluoy sa ida kag hari, kada ingpatawar sida ag ingpahalin. ");
INSERT INTO bno_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pero pagkaliwas it kinang suguon ruto ay nasapoy nida kag usa sa mga pareho ra nidang suguon nak di utang sa ida it usang gatos yang. Ida kali niliab ag gingyutok bag-o sumiling nak, ‘Badare kag imo utang!’ ");
INSERT INTO bno_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ngani, nagyuhor katong suguon ag nagpakitluoy sa ida. Siling nida, ‘Taw-e pa ako it panahon ag abadaran ka nako.’ ");
INSERT INTO bno_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Pero waya sida gisugot ag ingpapriso nida katong di utang sa ida hastang nakabadar. ");
INSERT INTO bno_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Katong nakita kali it ibang mga suguon, napayain sinra ag nagpagto sinra sa hari pramas iuma kung ni-o kag natabo. ");
INSERT INTO bno_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kada, ingpatawag kinang suguon it hari ag nagsiling sa ida, ‘Abang yain ikaw nak tawo! Gingpatawar ka nako sa imo utang dahil nagpakitluoy ka sa ako. ");
INSERT INTO bno_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Naluoy ako sa imo. Asing waya ikaw naluoy sa imo kaparehong suguon?’ ");
INSERT INTO bno_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ag sa kahangit it hari, ingpapriso nida kinang suguon hastang nakabadar it ida tanang utang. ");
INSERT INTO bno_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tuyar ra kag ahimuon sa inro it Ako Tatay sa langit kung indi ninro gipatawaron it hugot sa inro tagipusuon kag inro isigkatawo.” ");
INSERT INTO bno_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkatapos it kaling pagtudlo ni Hesus, Sida ay naghalin sa Galileya ag nagpagto sa probinsya it Hudeya bag-o nagtabok sa Suba it Jordan. ");
INSERT INTO bno_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gingsunran Sida it karuramong tawo ag ingpaado Nida kag mga di sakit. ");
INSERT INTO bno_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Inggwa ra it mga Pariseo ruto nak nagpayungot sa Ida para purbahan Sida. Nagpangutana sinra, “Ingtutugutan baga it ato Kasuguan nak buyagan it usang kayake kag ida asawa miskin ni-o man kag rason?” ");
INSERT INTO bno_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nagsabat si Hesus, “Waya baga ninro nabasa sa Sagradong Kasuyatan nak tuna pa it katong una ay gingtugay it Dios kag tawo, nak kayake ag kabade? ");
INSERT INTO bno_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ag siling pa it Dios, ‘Ngani, inabilin it kayake kag ida tatay ag nanay agor sida ay mapisan sa ida asawa ag sinrang ruha ay magiging usa.’ ");
INSERT INTO bno_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bukoey sinra ruha kundi usa. Kada ngani indi dapat pabuyagon it tawo kag ingpag-usa it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ingpangutana ray Sida it mga Pariseo, “Kung tuyar, asing nagsugot si Moises nak kag kayake ay puyding magbuyag sa ida asawa basta't ahimuon nida kag Kasuyatan bilang pamatuor nak sinra ay buyagey.” ");
INSERT INTO bno_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nagsabat si Hesus, “Dahil ngani abang tugas kamo it uyo, kada ingtugot ni Moises nak buyagan ninro kag inro asawa. Pero buko kina kag kabubut-on it Dios tuna pa sa Ida pagtuga sa kayake ag kabade. ");
INSERT INTO bno_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kada ingsisiling Nako sa inro, si-o mang kayake kag magbuyag sa ida asawa, puyra yang kung nagpangawatan kag kabade nak waya ra it ibang rason, ag kaling kayake ay maasawa ray sa ibang kabade, sida ay nakakasala it pagpangawatan.” ");
INSERT INTO bno_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pagkarungog it kali, nagsiling sa Ida kag mga manugsunor, “Kung tuyar yang ra it kina kag kamutangan it kayake sa pag-asawa, maado pang indi yangey giasawa.” ");
INSERT INTO bno_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ingsabat sinra ni Hesus, “Imaw, pero buko tanan ay kayang magtiis nak indi mag-asawa, kundi katong ingtaw-an yang it tuyar nak abilidad. ");
INSERT INTO bno_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maramo kag mga rason kung asing kag ibang tawo ay indi mag-asawa. Inggwa't mga kayake nak indi mag-asawa dahil kag inra pagkakayake ay inggwa't diperensya. Kag iba ay indi mag-asawa dahil sinra ay ingkapon. Ag kag iba ray ra ay indi mag-asawa dahil sa inra hanrom nak magserbisyo sa gingharian it Dios. Kada kag makakatiis nak indi mag-asawa, ay batunon yangey kali nak inggwa it kasadya.” ");
INSERT INTO bno_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pagkatapos, inggwa it tawong nagraya it inra mga anak kang Hesus para ipangabay nak ipatong Nida kag Ida damot ag ipangamuyo sinra. Pero ingsaway sinra it mga disipulos. ");
INSERT INTO bno_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero nagsiling si Hesus, “Pabad-e kinang mga anak nak magpayungot sa Ako. Aya sinra gipigahe, dahil tuyar sa inra kag mga mapasakop sa paghari it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ag ingpatong ni Hesus kag Ida mga damot sa inra bilang pagbendisyon, bag-o Sida naghalin ruto. ");
INSERT INTO bno_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Usang adlaw, inggwa it usang kayake nak nagpayungot kang Hesus ag nagpangutana, “Maestro, ni-o kag ako maadong ahimuon agor mapasa-ako kag kabuhi nak waya't katapusan?” ");
INSERT INTO bno_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nagsabat si Hesus, “Asing nagpapangutana ka sa Ako kung ni-o kag maado? Waya't ibang maado kundi kag Dios yang. Pero kung gusto nimong mapasa-imo kag kabuhi nak waya't katapusan, tumana kag Ida Kasuguan.” ");
INSERT INTO bno_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nagpangutana ray katong kayake, “Niong kasuguan?” Nagsabat si Hesus, “Indi magpangmatay, indi magpangawatan, indi magpanakaw, ag indi magtestigo it binakak laban sa imo isigkatawo. ");
INSERT INTO bno_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tahura kag imo tatay ag nanay, ag palangga-a kag imo isigkatawo tuyar sa pagpalangga nimo sa imo sarili.” ");
INSERT INTO bno_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Siling it katong kayake, “Kinang tanan ay natumaney nako. Ni-o pa kag dapat nakong himuon?” ");
INSERT INTO bno_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Siling ray ni Hesus sa ida, “Kung gusto nimong waya ka it kakuyangan sa imo inghihimo, pauli anay, ag ibaligya kag imo tanang ari-arian, ag ibulig kag binta sa mga pobre. Pag nahimo nimo kina, magkakainggwa ka it kayamanan sa langit. Pagkatapos, balik ag magsunor sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagkarungog rili it katong kayake ay nagpanaw sida nak mabug-at kag buot, dahil abang yaman sida. ");
INSERT INTO bno_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Siling ni Hesus sa Ida mga manugsunor, “Matuor kaling Ako ingsisiling sa inro. Abang hirap talaga para sa mga mayaman nak magpasakop sa paghari it Dios. ");
INSERT INTO bno_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ag ingsisiling pa Nako, mas marali pa para sa usang kamelyo nak magsuyor sa buho it radom kisa magpasakop kag mayaman sa paghari it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagkarungog kali it mga manugsunor, natingaya sinra ag nagpangutana, “Ay kung tuyar kina, sin-o yang kag maluluwas?” ");
INSERT INTO bno_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ingpakamuyatan sinra ni Hesus ag nagsiling, “Imposible nak mahimo kali it tawo, pero kaya it Dios nak himuon kag tanan.” ");
INSERT INTO bno_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ag nagsiling si Pedro, “Gino-o, ay pauno kami? Ingbadaan namo kag tanan ag nagsunor kami sa Imo. Ni-o ra kag para sa amo?” ");
INSERT INTO bno_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nagsiling ray sa inra si Hesus, “Matuor kaling Ako ingsisiling sa inro. Sa oras nak abag-uhon it Dios kag kalibutan, Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay maingkor sa Ako mahimayaong trono. Ag kamo ra nak Ako mga disipulos ay maingkor sa doseng trono ag ahusgaran kag doseng lahi it Israel. ");
INSERT INTO bno_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ag aber sin-o man nak nagbada it ida bayay, o mga hali nak kayake ag kabade o tatay, nanay, mga anak o mga duta alang-alang sa pagsunor sa Ako, ay mabalik kag mas subra pang kabuganaan para sa tanang ida ingbadaan ag magkakainggwa pa sida it kabuhi nak waya't katapusan. ");
INSERT INTO bno_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Maramong ingkikilaya sa ngasing nak mas nakakayabaw kag mawawar-an it puyos sa palaabuton, ag kag mga ingmumuyatan nak pay waya't puyos sa ngasing ay imaw kag makikilaya nak mas yabaw sa tanan sa palaabuton.” ");
INSERT INTO bno_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nagpadayon si Hesus sa Ida pagtudlo parayan sa usang istorya nak ingtatawag nak parabula. Siling Nida: “Kag paghari it Dios ay tuyar kali. Inggwa it usang tag-iya it ubasan. Usang adlaw, nagliwas sida it aga pa pramas maghanap it mga trabahador para sa ida ubasan. ");
INSERT INTO bno_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Katong nakita nida kag pilang bilog nak trabahador, nagkasugtanan sinra nak usang denaryo kag inra inadlaw. Ag ingpapagto nida sinra sa ida ubasan. ");
INSERT INTO bno_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Katong mataas-taasey kag adlaw, nagliwas ray sida ag nakita nida kag iba sa merkado nak waya it inghuhuman. ");
INSERT INTO bno_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Siling nida sa inra, ‘Pagto kamo sa ako ubasan ag magtrabaho ruto. Asuhuyan nako kamo it husto.’ ");
INSERT INTO bno_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kada nagpagto sinra. “Ag nagliwas ray sida pagkatapos it paning-ugto ag nagbaoy ray sida it iba. Ag pagka-alas-tres it hapon, imaw gihapon kag ida inghimo. ");
INSERT INTO bno_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Katong maalas-singkoy, nagliwas ray sida ag nakakita pa gihapon sida it ibang waya ra it inghuhuman. Siling nida sa inra, ‘Asing nag-iistambay yang kamo rili hastang hapon?’ ");
INSERT INTO bno_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Nagsabat sinra, ‘Waya it nata-o sa amo it trabaho.’ “Nagsiling ray sida sa inra, ‘Kung tuyar, pagto kamo sa ako ubasan ag magtrabaho.’ ");
INSERT INTO bno_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Katong serom-seromey, siling nida sa ida tawuhan, ‘Tawagay kag mga trabahador ag suhoyey sinra, magtuna sa nahuli, hastang sa nauna gitrabaho.’ ");
INSERT INTO bno_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kag mga nagtuna it alas-singko it hapon ay nagbaton it tig-usang denaryo. ");
INSERT INTO bno_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Kada katong nagpayungotey kag mga nauna gituna it trabaho, kabi ninra ay mabaton sinra it mas marako. Pero bawat usa sa inra ay nagbaton ra it tig-usang denaryo. ");
INSERT INTO bno_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagkabaton ninra, nagreklamo sinra sa tag-iya it ubasan. ");
INSERT INTO bno_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Siling ninra, ‘Hamak, usang oras yang kag ingtrabaho it kinang mga nahuli giabot. Pero asing tuyar, kami ay bug-os nak adlaw nak nagtrabaho, ag ingtiis namo kag init it adlaw, ay asing imo ingpareho kag inra suhoy sa amo?’ ");
INSERT INTO bno_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ingsilinggan it tag-iya kag usa sa inra, ‘Amigo, waya ka nako girada-a. Indi baga nagkasugot kita nak usang denaryo kag suhoy nimo sa usang adlaw?’ ");
INSERT INTO bno_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bay-a kag imo suhoy ag pumauli. Ginusto nakong suhuyan kaling mga nahuli it pareho sa suhoy nimo. ");
INSERT INTO bno_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Asi? Waya baga ako it karapatan nak humanon kag ako gusto sa ako kwarta? O nahihili ka sa ako maadong buot?” ");
INSERT INTO bno_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pagkatapos, nagsiling si Hesus, “Tuyar ra, kag mga ingmumuyatan nak pay waya't puyos sa ngasing ay imaw kag akilay-on nak mas yabaw sa tanan sa palaabuton, ag kag mga ingkikilaya sa ngasing nak mas nakakayabaw kag mawawar-an it puyos sa palaabuton.” ");
INSERT INTO bno_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pagkatapos, nagpadayon sina Hesus patukar sa Herusalem, ag myentras nagpapanaw sinra, ingpayado Nida kag doseng disipulos sa mga tawo ag ingsilinggan Nida sinra, ");
INSERT INTO bno_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Runggi ninro kali! Ngasing ay patukarey kita sa Herusalem ag pag-abot nato ruto, Ako nak dati pa ay ingtatawagey nak Anak it Tawo ay atraiduron ag ita-o sa mga Punong Saserdote ag sa mga Manunudlo it Kasuguan, nak mahusgar sa Ako it kamatayon. ");
INSERT INTO bno_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ag pagkatapos, ita-o ray ninra Ako sa mga buko Hudyo para libakon, latiguhon ag ilansang sa krus. Pero sa pangtatlong adlaw ay mababanhaw Ako.” ");
INSERT INTO bno_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pagkatapos, nagpayungot kang Hesus kag asawa ni Zebedeo, kanunot kag ida ruhang anak nak kayake. Inggwa sida it gustong hagaron, kada nagyuhor sida sa atubangan ni Hesus. ");
INSERT INTO bno_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gingpangutana sida ni Hesus, “Nang, ni-o kag imo gusto?” Nagsabat sida, “Tan-a'y tugutan Nimong makaingkor kaling ako ruhang anak sa Imo tu-o ag wala, pag Ikaw ay maghariey sa Imo gingharian.” ");
INSERT INTO bno_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero nagsabat si Hesus sa inra, “Waya ninro naaayami kung ni-o kag inro inghahagar. Kaya baga ninro nak tis-an kag hirap tuyar sa Ako arayanan?” Nagsabat sinra, “Oho, kaya namo!” ");
INSERT INTO bno_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Siling pa ni Hesus, “Matuor, atis-an nak gador ninro kag hirap nak Ako arayanan. Pero buko Ako kag masiling kung sin-o kag makakaingkor sa Ako tu-o ag wala, dahil kinang pwesto ay gingtiganaey it Ako Tatay para sa Ida ingpili nak maingkor raha.” ");
INSERT INTO bno_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","It katong narunggan kali it katong sampuyong disipulos nahangit sinra sa ruhang magmanghor. ");
INSERT INTO bno_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kada ing-ayaba sinra ni Hesus ag nagsiling sa inra, “Ayam ninro nak dili sa kalibutan kag pinuno it mga nasyon nak waya nagkikilaya sa Dios ay inggagahuman kag inra mga nasasakupan nak inggwa it kaisog, ag kag mga importanting tawo sa inra ay imaw ra kag nagmamayor. ");
INSERT INTO bno_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero para sa inro, buko dapat tuyar, kundi kung si-o man kag gustong makilaya sida ay dapat nak maging tuyar sa usang suguon. ");
INSERT INTO bno_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ag aber sin-o sa inro kag gustong mapamuno ay dapat maserbisyo sida tuyar sa usang ulipon. ");
INSERT INTO bno_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ako nak dati pa ay ingtatawagey nak Anak it Tawo ay tuyar ra it kina. Nagpaali Ako buko para serbisyuhan, kundi para magserbisyo ag magta-o it Ako kabuhi bilang pangtubos para sa maramong tawo.” ");
INSERT INTO bno_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ngasing, habang paliwason sina Hesus sa banwa it Jerico ay ingsunran sinra it maramong mga tawo. ");
INSERT INTO bno_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ag natabo ra nak inggwa ruto it ruhang bulag nak nag-iingkor sa habig it rayan. Katong narunggan ninra nak nagrarayan si Hesus, nag-aayaba sinra it makusog, “Gino-o, Inanak ni David, kaluy-i kami!” ");
INSERT INTO bno_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gingsaway sinra it mga tawo ag gingpapahipos. Pero lalo ninrang pinaka-kusgan kag inra pag-ukaw, “Gino-o, Inanak ni David, kaluy-i kami!” ");
INSERT INTO bno_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nagruyog anay si Hesus ag ing-ayaba sinra, bag-o nagpangutana, “Ni-o kag inro gustong himuon Nako para sa inro?” ");
INSERT INTO bno_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nagsabat sinra, “Gino-o, gusto tan-a namo nak makakita!” ");
INSERT INTO bno_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naluoy nak gador si Hesus sa inra, kada inghuytan Nida kag inra mga mata, ag sa nak raan sinra ay nakakita ag nagsunor sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","It katong mayungotey sina Hesus sa Herusalem, narayanan ninra kag baryo it Betpage paus-uson sa Baguntor it mga Olibo. Gingpauna anay ni Hesus kag ruha sa Ida mga disipulos, ");
INSERT INTO bno_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ag ingsugo sinra, “Pagto kamo rutuong baryo nak asa uunhan. Sa nak raan makikita ninro kag usang guyang nak asno nak nakalig-or kanunot kag ida turete. Hubara ag ray-on dili. ");
INSERT INTO bno_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kung inggwa it magpangutana sa inro kung ni-o kag inro inghihimo, silinggang kinahangyan nganat kina it Gino-o, ag sa nak raan asugtan kamong bay-on kina.” ");
INSERT INTO bno_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Natabo kali para matuman kag ingbisaya it propeta it kato. Siling Nida, ");
INSERT INTO bno_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Silingga kag mga taga-Herusalem, ‘Muyati, nag-aabot kag inro Hari. Mapainubuson Sida, ag nakasakay Sida sa usang tureting asno.’ ” ");
INSERT INTO bno_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kada, kinang ruhang disipulos ay nagpagto ag gingtuman kag ingsugo ni Hesus. ");
INSERT INTO bno_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inggudor ninra kag guyang nak asno ag turete papagto kang Hesus. Pag-abot ninra ruto, inghapinan anay ninra it inra mga baro kag turete ag nagsakayey si Hesus. ");
INSERT INTO bno_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Maramong tawo kag nagbukyar it inra baro sa rayan. Kag iba ay nag-utoy it mga pakyang it palmera ag mga ugbos it sanga nak di rahon halin sa mga puno sa habig, ag inghanig ra kali sa rayan bilang pagpakita it inra pagtahor. ");
INSERT INTO bno_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kag mga tawong nag-uuna ag nagsusunor kang Hesus ay nag-iinukaw it, “Hosana! Mabuhay kag Inanak ni David!” “Dayawon kag nag-aabot sa ngayan it Gino-o!” “Dayawon kag Dios sa kataas-taasan!” ");
INSERT INTO bno_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagkasuyor ni Hesus sa Herusalem, nagkinagulo kag mga tawo ag nagpinangutana, “Si-o ara kali?” ");
INSERT INTO bno_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nagsabat kag karamuang nagnununot kang Hesus, “Kali kag Propetang si Hesus nak taga-Nazaret sa probinsya it Galileya.” ");
INSERT INTO bno_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pag-abot nina Hesus sa Herusalem, nagsuyor Sida sa rayaag it Templo ag ingpaliwas Nida kag mga nagbabaligya ag mga nagpapamakay it mga hadop para ihalar ruto. Ingpabalintong Nida kag mga lamesa it mga nagbabaydo it kwarta, imaw ra kag mga ingkuran it mga nagbabaligya it salumpati. ");
INSERT INTO bno_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ag nagsiling Sida sa inra, “Gingpasuyat it Dios sa Sagradong Kasuyatan, ‘Kag Ako bayay ay atawagong bayay nak pangamuyuan. Pero inghuhuman ninro kaling lugar it mga radaon.’ ” ");
INSERT INTO bno_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Masunor, inggwa ray ruto it mga bulag ag mga piang nak nagpayungot kang Hesus, ag Ida sinra ingpaado. ");
INSERT INTO bno_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Katong nakita it mga Punong Saserdote ag Manunudlo it Kasuguan kag inghimo ni Hesus ag mga anak nak nag-uukaw sa pagdayaw raha sa Templo sa pagsiling nak, “Dayawon kag Inanak ni David!” nahangit sinra. ");
INSERT INTO bno_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ag napasiling sinra kang Hesus, “Narurunggan baga Nimo kag ingsisiling ninra?” Nagsabat si Hesus, “Oho, narurunggan Nako. Waya pa baga ninro nabasa kag ingsiling sa Sagradong Kasuyatan nak, ‘O Dios, ingtutudluan Nimo kag mga anak ag mga nagsususo pa nak magdayaw sa Imo.’ ” ");
INSERT INTO bno_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pagkatapos it kali, ingbilin sinra nina Hesus ruto ag nagliwas sa syudad para magpagto sa baryo it Betanya, ag ruto sinra nagkatuyog. ");
INSERT INTO bno_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkaaga, nagbalik sina Hesus sa syudad, ag myentras sa rayan sinra ay nakabatyag it gutom si Hesus. ");
INSERT INTO bno_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sa habig it rayan nakakita Sida it usang puno it igos. Ida kali ingpayungutan, pero waya Sida it nakitang bunga kundi puro rahon yang. Kada siling Nida sa puno it igos, “Indiey ka magpamunga liwat.” Ag sa nak raan namatay kag puno. ");
INSERT INTO bno_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkakita it kali it Ida mga disipulos abang katingaya ninra, ag napasiling, “Asing namatay nak raan kaling puno?” ");
INSERT INTO bno_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nagsabat si Hesus, “Matuor kaling Ako ingsisiling sa inro. Kung magtu-o kamo sa Dios nak waya it pangruha-ruha, mahihimo ra ninro kag tuyar sa Ako inghimo riling puno it igos. Ag buko yang kina, kung isiling ra ninro riling baguntor, ‘Halin raha ag magsaydo sa ragat,’ kina ay matutuman. ");
INSERT INTO bno_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ag ni-o man kag inro hagaron sa Dios sa inro pangamuyo ay inro mababaton, kung matu-o nak gador kamo.” ");
INSERT INTO bno_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pag-abot nina Hesus sa Herusalem, nagsuyor ray si Hesus sa Templo ag nagtudlo ruto. Habang nagtutudlo Sida, nagpayungot sa Ida kag mga Punong Saserdote ag iba pang mga pinuno it mga Hudyo, ag ingsura Sida, “Ni-o kag Imo karapatan para himuon kag tanang Imo ginghihimo? Si-o kag nagta-o sa Imo it kali?” ");
INSERT INTO bno_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ingsabat sinra ni Hesus, “Apangutan-on ra kamo Nako. Pag nasabat ninro Ako, asabton ra kamo Nako kung riin gihalin kag Ako karapatan nak himuon kali. ");
INSERT INTO bno_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kag pagbawtismo baga ni Juan sa mga tawo ay halin sa Dios o sa tawo?” Nagpangunseho anay sinra ag nagsiling, “Kung magsabat kita nak ‘Halin sa Dios,’ isiling ray Nida sa ato nak, ‘Hay, asing waya ninro sida gipatihe?’ ");
INSERT INTO bno_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero kung masabat kita, ‘Halin sa tawo,’ ay madedelikaduhan kita sa mga tawo, dahil inra ingkikilaya nak si Juan ay usang propeta.” ");
INSERT INTO bno_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kada, ingsabat ninra si Hesus, “Ilam, buko namo ayam.” Ngani, nagsiling ra si Hesus sa inra, “Ay indi ra Nako igsiling sa inro kung hariin gihalin kag Ako karapatan nak himuon kali.” ");
INSERT INTO bno_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Masunor, nagbisaya si Hesus sa inra parayan sa istorya nak ingtatawag nak parabula. Siling Nida, “Ngasing, ni-o aboy kag inro masisiling dili sa istorya nak isiling Nako sa inro? Inggwa it usang tawo nak di ruhang anak. Usang adlaw, nagsiling sida sa panganay, ‘Anak, pagto sa ubasan ag magtrabaho ruto.’ ");
INSERT INTO bno_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Nagsabat kag ida anak, ‘Indi ako.’ Pero marugay-rugay, nagbag-o kag ida isip ag nagpagto sa ubasan. ");
INSERT INTO bno_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ag nagpayungot ray kag tatay sa manghor ag tuyar ra kag ida ingsiling. Nagsabat kaling anak, ‘Opo, Tatay. Mapagto ako.’ Pero waya ra sida gipagto. ");
INSERT INTO bno_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Si-o ngasing sa ruha kag nagsunor sa gusto it inra tatay?” Nagsabat sinra, “Kag panganay.” Nagsiling ray si Hesus sa inra: “Matuor kaling Ako ingsisiling sa inro. Kag mga makasal-anan tuyar sa mga manugsukot it buhis ag mga kabade nak nagbabaligya it inra sarili ay mauuna pa sa inrong magpasakop sa paghari it Dios. ");
INSERT INTO bno_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dahil nagpaali sa inro si Juan nak Manugbawtismo ag ingpasador sa inro kung pauno magpangabuhi sa tamang parayan, pero waya ninro sida gipatihe. Pero kag mga tuyar sa manugsukot it buhis ag mga mayaing kabade ay nagpati sa ida. Ag aber nakitaey ninro kina, waya gihapon kamo gihinuysoy ag igpati kang Juan.” ");
INSERT INTO bno_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nagpadayon sa pag-istorya si Hesus sa inra, “Panimati-i ray ninro kaling usa pang istorya. Inggwa it usang tawo nak nagpatanom it ubas sa ida bukir. Ingkurayan nida kali ag inghumanan it pusaan it ubas, bag-o nagtugrok sida it mataas nak bantayan. Masunor, ida ingpabantayan sa ida mga bantay kaling ubasan dahil mapagto sida sa ibang lugar.” ");
INSERT INTO bno_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Katong nag-abot kag oras it inugpu-po, ingpapagto it tag-iya sa ubasan kag ida mga ulipon para bay-on sa ida mga bantay kag ida parti. ");
INSERT INTO bno_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ugaling pag-abot it ida mga ulipon sa ubasan ingrakop sinra it mga bantay, ingbakoy kag usa, ingmatay kag usa ag ingbunggo kag usa. ");
INSERT INTO bno_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ingpapagto ray it tag-iya kag ida maramo pang ulipon, pero imaw gihapon kag inghimo it mga bantay. ");
INSERT INTO bno_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Katong huli ay kag iday nak gador anak nak kayake kag ida ingpapagto. Siling nida sa ida sarili, ‘Siguradong atahuron ninra kaling ako anak.’ ” ");
INSERT INTO bno_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Pero pagkakita it mga bantay sa ida anak, nagkausa sinra ag nagsiling, ‘Imaw kali kag manugpanubli. Maley! Amatyon nato sida agor mapapasa-ato kaling ida panublion.’ ");
INSERT INTO bno_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kada pag-abot nida, inra sida ingrakop ag ingraya sa liwas it ubasan bag-o ingmatay. ");
INSERT INTO bno_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ngani, pagbalik it tag-iya it ubasan, ni-o ara kag ida ahimuon sa ida mga bantay?” ");
INSERT INTO bno_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nagsabat sinra, “Amatyong gador nida katong mga mayain nak bantay, ag apabantayan kag ubasan sa iba nak mata-o sa ida it ida parti sa oras it inugpu-po.” ");
INSERT INTO bno_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ingsilinggan sinra ni Hesus, “Waya pa baga ninro nabasa sa Sagradong Kasuyatan nak, ‘Kag batong ingsikway it mga nagtutugrok it bayay ay imaw it naging pinaka-importante bilang pangpatibay dili. Inghimo kali it Gino-o. Abang katitingaya kali sa ato pagmuyat.’ ” ");
INSERT INTO bno_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kada ngani, kali kag ako isiling sa inro, abay-on it Dios sa inro kag Ida paghari ag ita-o sa ibang mga lahi nak mapangabuhi it maado sa Ida pagmuyat. ");
INSERT INTO bno_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kag sin-o mang mahuyog sa batong kali ay magkakabali-bali ag kag mahuhuyugan it kaling bato ay mayayata.” ");
INSERT INTO bno_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagkarungog it mga Punong Saserdote ag mga Pariseo it kaling istorya ni Hesus, nahalata ninra nak sinra kag gingpapatamaan it Ida ing-istorya. ");
INSERT INTO bno_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kada arakpon tan-a ninra si Hesus, pero nahadlok sinra sa mga tawo, dahil ingkikilaya ninrang propeta si Hesus. ");
INSERT INTO bno_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nagbisaya ray si Hesus sa inra parayan sa istorya nak ingtatawag nak parabula. Siling Nida: ");
INSERT INTO bno_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kag paghari it Dios ay tuyar sa usang hari nak naghanra para sa pakasay it ida anak nak kayake. ");
INSERT INTO bno_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Gingsugo nida kag ida mga ulipon para sapuyon kag mga imbitado sa pakasay, pero waya't nagrungaw sa ida mga inimbitar. ");
INSERT INTO bno_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kada, ingsugo ray nida kag iba nidang suguon ag siling nida sa inra, ‘Silingga kag mga imbitado nak nakahanraey kag pagkaon. Naihawey kag mga pinatabang turo ag hanraey nganat kag tanan, kada pagto'y kamo!’ ");
INSERT INTO bno_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Pero waya kali gialibhata it mga imbitado ag nagpadayon gihapon sinra sa inra inghihimo. Kag iba ay nagpatukar sa inra bukir, kag iba ray ay nag-intyendi it inra negosyo. ");
INSERT INTO bno_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kag ginghimo it tong iba ay ingrakop kag mga ulipon it hari, ginghapros ag ingmatay. ");
INSERT INTO bno_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kada abang kahangit it hari, ag ingpapagto nida kag ida mga sundalo para matyon ra kag mga nagpangmatay sa ida mga ulipon, ag sunugon kag inra syudad. ");
INSERT INTO bno_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Pagkatapos, ingtawag nida kag ida mga ulipon ag nagsiling sida sa inra, ‘Hanraey kag pagkaon pero katong ako ing-imbitar ay buko karapatdapat. ");
INSERT INTO bno_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kada pagto ray kamo kung hariin kag maramong tawo ag papalion dili sa kasayan kag tanang inro makita.’ ");
INSERT INTO bno_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kada nagpagto matuor kag mga ulipon ag ing-imbitar kag tanang inra makita, mayain man ag maado. Ngani, napuno it mga tawo kag rungawan it kinasay. ");
INSERT INTO bno_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ag nagsuyor kag hari para muyatan kag mga nagrurungaw ag nakita nida nak inggwa't usang tawo nak waya nakabaro it angay para sa kasayan. ");
INSERT INTO bno_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kada kali ay ingpangutana it hari, ‘Amigo, asing nagsuyor ikaw rili nak waya nakabaro it angay para sa kasayan?’ Pero waya nakalihok katong tawo. ");
INSERT INTO bno_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kada, nagsiling kag hari sa ida mga suguon, ‘Gapusa kag ida damot ag siki, ag ipilak sa liwas sa karuymanan. Hagto sida matinibaw ag mapangpagot kag ida ngisi.’ ");
INSERT INTO bno_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Maramo kag ingtawag it Dios nak magpasakop sa Ida paghari pero apila yang kag mga napili.” ");
INSERT INTO bno_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naghalin kag mga Pariseo ruto ag nagplano sinra kung pauno ninra marakop si Hesus sa Ida mga ingbisaya. ");
INSERT INTO bno_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ag ingpapagto ninra kang Hesus kag ibang inra mga manugsunor kanunot kag mga kakampi ni Gobernador Herodes. Nagpayungot sinra kang Hesus ag nagsiling, “Maestro, ayam namo nak kag Imo pagbisaya ay perming matuor, ag imaw ra kag Imo pagtudlo tungor sa kabubut-on it Dios. Waya ra Ikaw it ingpipiling tawo, ag waya Ikaw nahadlok aber sa isip it mga mataas nak tawo ay ingmamayain Nimo sinra parayan sa Imo pagbisaya. ");
INSERT INTO bno_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kada ni-o kag Imo masisiling dili? Tama baga nak kitang mga lahi it Hudyo ay magbadar it buhis sa Cesar nak Emperador it Roma?” ");
INSERT INTO bno_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero ayamey ni Hesus kag inra mayaing plano, kada nagsiling Sida, “Kamong mga pakitang tawo! Asing ingpupurbahan ninro Ako? ");
INSERT INTO bno_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakita-e baga Ako it kwarta ninra nak inggagamit sa pagbadar it buhis.” Kada ingraya ninra sa Ida kag kwartang denaryo, ");
INSERT INTO bno_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ag nagpangutana si Hesus, “Kanin-ong uda ag ngayan kag nakasuyat diling kwarta?” ");
INSERT INTO bno_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nagsabat sinra, “Sa Cesar.” Siling ray ni Hesus sa inra, “Ay kung imaw, ita-o ninro sa Cesar kag para sa Cesar ag sa Dios kag para sa Dios.” ");
INSERT INTO bno_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagkarungog ninra it kali, natingaya sinra ag naghalin sinra ruto. ");
INSERT INTO bno_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Marugay-rugay sa adlaw rang kato, inggwa it mga Saduseo nak nagpayungot kang Hesus. Sinra kag mga nagpapati nak kag mga minatay ay indi mabanhaw. Ag nagpangutana sinra sa Ida, ");
INSERT INTO bno_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maestro, ingsiling ni Moises nak, ‘Kung mamatay kag maguyáng nak kayake, ag mabalo kag ida asawa nak waya it anak, dapat sidang pakasayan it katong masunor sa ida nak kayake agor magkaanak sida para sa ida maguyáng.’ ");
INSERT INTO bno_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Halimbawa, inggwa it pitong magmanghor nak kayake. Nag-asawa katong panganay ag namatay nak waya't anak. Kada ing-asawa ray it ida manghor nak masunor sa ida kag ida asawa. ");
INSERT INTO bno_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Imaw ra kag natabo sa pangruha, pangtatlo, hastang sa pangpito. ");
INSERT INTO bno_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pagkamatay ninrang tanan, namatay ra katong kabade. ");
INSERT INTO bno_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ngasing, sa adlaw it pagkabanhaw it mga minatay, dahil naging asawa nida katong tanan, si-o sa pito kag ida maaasawa?” ");
INSERT INTO bno_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nagsabat si Hesus, “Sala kinang inro ingpapatihan, dahil waya ninro naiintyendihe kag ingsiling sa Sagradong Kasuyatan ag kung pauno it rako kag gahom it Dios. ");
INSERT INTO bno_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pag mabanhaw kag mga tawo, indiey sinra mag-asawa o aasawahon pa, dahil sinra ay magiging tuyarey sa mga anghel sa langit. ");
INSERT INTO bno_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ag tungor sa pagkabanhaw it mga minatay, waya pa baga ninro nabasa kag ingsisiling sa inro it Dios tungor raha? ");
INSERT INTO bno_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Siling Nida, ‘Ako kag Dios ni Abraham, Dios ni Isaac ag Dios ni Jacob.’ Kag Dios ay buko Dios it mga minatay kundi Dios it mga buhi.” ");
INSERT INTO bno_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ag katong narunggan kali it karamuan, natingaya sinra sa Ida tudlo. ");
INSERT INTO bno_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Katong narunggan it mga Pariseo nak kag mga Saduseo ay waya it naisabat kang Hesus, naghinuon sinra ag nagpagto sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nagpangutana kag usa sa inra nak maayam sa Kasuguan agor purbahan si Hesus. ");
INSERT INTO bno_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maestro, ni-o kag pinaka-importanting sugo sa tanang Kasuguan it Dios?” ");
INSERT INTO bno_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nagsabat si Hesus, “ ‘Palangga-a kag Gino-o nak imo Dios it hugot sa imo tagipusuon, bug-os nimong pagkatawo, ag bug-os nimong kaisipan.’ ");
INSERT INTO bno_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Imaw kina kag pinaka-importanting sugo it Dios. ");
INSERT INTO bno_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ag kag pangruhang sugo nak pinaka-importante ay imaw kali, ‘Palangga-a kag imo isigkatawo tuyar sa pagpalangga nimo sa imo sarili.’ ");
INSERT INTO bno_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kag tanang Kasuguan ni Moises ag kag tudlo it mga propeta ay rahaley sa suyor it kaling ruhang Kasuguan.” ");
INSERT INTO bno_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ngasing, dahil ingpalibutan si Hesus it mga Pariseo, ingpangutana sinra ni Hesus, ");
INSERT INTO bno_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ni-o kag inro pagkaayam tungor sa ingpromisang Kristo? Riin Sida gihalin?” Nagsabat sinra, “Kang Haring David.” ");
INSERT INTO bno_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nagpangutana ray si Hesus, “Kung tuyar, asing Gino-o kag tawag sa Ida ni David? Buko baga tuyar kag ingsiling ni David it katong sida ay sa irayom pa it gahom it Ispirito Santo, ag siling nida,” ");
INSERT INTO bno_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Siling it Gino-o sa Ako Gino-o: Ingkor rili sa Ako tu-o hastang mapairayom Nako sa Imo mga siki kag Imo mga kaaway.” ");
INSERT INTO bno_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Kung si David mismo ay nagtawag sa Ida it ‘Gino-o,’ pauno masisiling nak halin kang David kag ingpromisang Kristo?” ");
INSERT INTO bno_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Waya it nakasabat miskin usa sa inra. Ag tuna it kato wayaey it nagkakasa-kasa nak magpangutana pa sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pagkatapos, nagbisaya si Hesus sa karamuan ag sa Ida mga manugsunor. ");
INSERT INTO bno_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Siling Nida: “Kag mga Manunudlo it Kasuguan ag mga Pariseo kag ingkikilaya nak manugpahadag it Kasuguan ni Moises. ");
INSERT INTO bno_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kada tumana ninro kag inra ingtutudlo, pero aya gipatuyare kag inra mga inghihimo, dahil sinra mismo ay waya gisusunor sa inra ingtutudlo. ");
INSERT INTO bno_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sa inra pagpatuman it Kasuguan ay pay ingpapas-an yang ninra kag mabug-at nak raya sa mga tawo, nak sinra mismo ay waya gibubulig miskin iruot kag inra usang tudlo.” ");
INSERT INTO bno_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Tanang inra inghihimo ay puro paradaw agor apurihon sinra it mga tawo. Kada kag mga maintik nak kahon nak ingbubutangan it mga bersikulo halin sa Sagradong Kasuyatan nak inra inghihigot sa inra yupa ag braso, ag kag mga pabiling sa gadar it inra alimungmong ay inra ingpaparagkuan. ");
INSERT INTO bno_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sa mga punsyunan abang gusto ninrang mag-ingkor sa ingkuran it pinaka-importanting tawo, ag imaw ra sa atubangan it sinagoga. ");
INSERT INTO bno_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Abang gusto pati ninrang bugnuhon sinra it mga tawo sa banwa ag ayabahon nak ‘Maestro.’ ” ");
INSERT INTO bno_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pero kamo, aya gipaayaba it ‘Maestro,’ dahil kamong tanan ay pay magmanghor ag ausa kag inro Maestro. ");
INSERT INTO bno_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ag aya ra giayabahang ‘Tatay’ kag inro isigkatawo rili sa duta, dahil ausa yang kag inro Tatay sa langit. ");
INSERT INTO bno_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ag aya ra gipaayabang ‘Gino-o,’ dahil ausa yang kag inro Gino-o nak imaw kag ingpromisang Kristo. ");
INSERT INTO bno_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kag usa nak imaw it ingkikilaya it tanan ay dapat nak maging suguon ninro. ");
INSERT INTO bno_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sin-o man kag nagtataas it ida sarili ay ibaba it Dios, ag kag nagpapaubos ay Ida itaas.” ");
INSERT INTO bno_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nagsiling pa si Hesus, “Kahahadlok kag matatabo sa inro nak mga Manunudlo it Kasuguan ag mga Pariseo! Mga pakitang tawo! Kamo kag nagpipiga sa mga tawo nak gustong magpasakop sa paghari it Dios. Kamo ngani ay waya gustong magpasakop raha ag ingpipigahan pa ninro kag iba.” ");
INSERT INTO bno_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kahahadlok kag matatabo sa inro nak mga Manunudlo it Kasuguan ag mga Pariseo! Mga pakitang tawo! Ingluluko ninro kag mga kabading balo hastang naghirap sinra, ag kaling inro mayaing inghimo ay gingtatabunan it inro mahabang pagpangamuyo. Ngani, yabaw kag inro abatunon nak parusa.” ");
INSERT INTO bno_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kahahadlok kag matatabo sa inro nak mga Manunudlo it Kasuguan ag mga Pariseo! Mga pakitang tawo! Inglilibot ninro kag ragat ag duta para yang makaraya it usang buko Hudyo sa inro pagtudlo. Pagkatapos, apatuyaron sida sa inro, hastang maging duble pa kag ida kayainan sa inro, kada mas yabaw pa kag ida kaparusahan sa impyerno. ");
INSERT INTO bno_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kahahadlok kag matatabo sa inro nak pay tuyar sa mga bulag nak manug-agkay! Ingtutudlo ninro nak kung agamiton it usang tawo kag Templo sa ida pagsumpa, pweding indi nida kato gitumanon. Pero kung agamiton nida sa pagsumpa kag buyawan sa Templo, ay dapat nidang tumanon kag ida ingsumpaan. ");
INSERT INTO bno_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kamong mga bulag ag mga kuyang kag pag-iisip! Ni-o kag mas importante, kag buyawan o kag Templo nak imaw kag naghihimo nak maging sagrado kag buyawan? ");
INSERT INTO bno_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ingsisiling ra ninro nak kung agamiton it usang tawo kag altar sa ida pagsumpa, pweding indi nida kato gitumanon. Pero kung agamiton nida sa pagsumpa kag halar sa altar, ay dapat nidang tumanon kag ida ingsumpaan. ");
INSERT INTO bno_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kamong mga bulag! Ni-o kag mas importante, kag halar o kag altar nak imaw kag naghihimo nak maging sagrado kag halar? ");
INSERT INTO bno_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kada ngani kung agamiton it usang tawo sa pagsumpa kag altar, syempre pati kag tanang halar ruto ay iday ra ing-umir sa pagsumpa. ");
INSERT INTO bno_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ag kung agamiton it usang tawo sa pagsumpa kag Templo, pati kag Dios ay iday ra ing-umir sa pagsumpa dahil kag Templo ay istaran it Dios. ");
INSERT INTO bno_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ag imaw ra, kung agamiton it usang tawo sa pagsumpa kag langit, pati kag trono it Dios ay iday ra ing-umir sa pagsumpa dahil ruto nakaingkor kag Dios. ");
INSERT INTO bno_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kahahadlok kag matatabo sa inro nak mga Manunudlo it Kasuguan ag mga Pariseo! Mga pakitang tawo! Mismong mga tanom nak inggagamit ninro sa pampalasa ay ingtata-o ninro kag ika-sampuyong parti sa Dios. Pero kag Ida mga importanting sugo ay inro ingbabaliwaya, tuyar sa pagka-matarong, pagka-maluluy-on ag pagka-matinumanon. Ngani, imaw kali kag dapat ninrong tumanon ag indi ra dapat magpabada sa pagta-o it inro ika-sampuyong parti. ");
INSERT INTO bno_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kamong mga bulag nak manug-agkay! Sa inro pagtuman sa Dios, kamo ay tuyar sa mga tawo nak ingsasaya kag hayukhok sa inra ainumon, pero kag inra ingyayag-ok ra ay marakong kamelyo. ");
INSERT INTO bno_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kahahadlok kag matatabo sa inro nak mga Manunudlo it Kasuguan ag mga Pariseo! Mga pakitang tawo! Kamo ay pay tuyar sa naghugas it baso ag mayukong, nak liwas yang kag inghugasan ag waya kag suyor. Kada mabuling gihapon kag suyor, pay tuyar sa tawong maado sa pangliwas, pero kag tagipusuon ay puno it kahakugan ag pagka-gahaman. ");
INSERT INTO bno_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamong mga bulag nak Pariseo! Limpyuha anay kag inro suyor agor maging malimpyo ra kag liwas. ");
INSERT INTO bno_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kahahadlok kag matatabo sa inro nak mga Manunudlo it Kasuguan ag mga Pariseo! Mga pakitang tawo! Kamo ay tuyar sa pantyon nak ingpintahan it puti. Maganda kag pangliwas, pero kag suyor ay puno it mga suká ag nagyunot nak minatay. ");
INSERT INTO bno_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tuyar kamo. Sa muyat it tawo ay abang ado kamo, pero sa kaklaruhan ay puro kamo pakitang tawo ag mga suwail. ");
INSERT INTO bno_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kahahadlok kag matatabo sa inro nak mga Manunudlo it Kasuguan ag mga Pariseo! Mga pakitang tawo! Ingpapahimo pa ninro kag mga pantyon it mga propeta ag ingpapaganda ra kag mga lapida it mga maadong tawo nak nagtutuman sa Dios. ");
INSERT INTO bno_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ag ingsisiling ninro kung nabuhi tan-a kamo it katong panahon it inro mga ginikanan, indi ninro gipamatay kag mga propeta tuyar sa inghimo ninra. ");
INSERT INTO bno_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero sa ingbisaya ninrong kina, ingpapamatuuran ninro nak kamo ay mga inanak it mga nagmatay rutong mga propeta. ");
INSERT INTO bno_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hala, tapusa ninro kag ingtunaan it inro mga ginikanan! ");
INSERT INTO bno_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Kamong mga tuso! Indi kamo makalikaw sa parusa sa impyerno. ");
INSERT INTO bno_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Kada panimati kamo, Ako mismo kag maparaya sa inro it mga propeta, mga maayam ag mga manunudlo it mga bisaya it Dios. Pero kag iba ay inro amatyon parayan sa paglansang sa krus, kag iba ay alatiguhon sa inro sinagoga, ag kag iba ray ay ayaguron ag apahirapan aber hariin man sinra magpagto. ");
INSERT INTO bno_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngani, kamong mga tawo sa ngasing nak panahon ay sa inro asukton it Dios kag pagmatay it tanang mga maadong tawo nak nagtutuman sa Ida dili sa kalibutan, magtuna pa kang Abel hastang kang Zacarias nak anak ni Baraquias, nak ingmatay it inro mga ginikanan sa tunga it Sagradong Lugar it Templo ag altar raha sa rayaag. ");
INSERT INTO bno_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Matuor kaling Ako ingsisiling sa inro. Kamong mga tawo nak nabubuhi pa ngasing kag mapanabat sa tanang kasal-anang kali.” ");
INSERT INTO bno_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Pagkatapos, nagsiling si Hesus: “Mga taga-Herusalem! Asing tuyar kamo? Ingpamatay ninro kag mga propeta ag ingbunggo ra kag mga suguon it Dios hastang mamatay! Maramong beses nak gusto tan-a Nakong tatapon kamo tuyar sa pagkupkop it usang guyang nak manok sa ida mga isiw, ugaling waya kamo it gusto nak himuon kina Nako sa inro. ");
INSERT INTO bno_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kada ngasing bahalaey kamo! Apabad-aney kamo it Dios! ");
INSERT INTO bno_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ag kali kag Ako isiling sa inro, tuna ngasing, indiey ninro Ako makita, hastang mag-abot kag oras nak silinggon ninrong, ‘Dayawon kag nag-aabot sa ngayan it Gino-o!’ ” ");
INSERT INTO bno_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nagliwas si Hesus sa Templo ag katong pahalinoney Sida, nagpayungot kag mga disipulos ag ingtudlo sa Ida kag kagandahan it tanang parti it Templo. ");
INSERT INTO bno_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pero siling ni Hesus sa inra, “Ah! Nagagandahan kamo rahang maragkong Templo. Pero matuor kaling Ako ingsisiling sa inro. Maabot kag adlaw nak masisira kinang tanan ag wayaey it mabibilin nak batong nakatungtong raha.” ");
INSERT INTO bno_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pagkatapos, habang nag-iingkor si Hesus sa Baguntor it mga Olibo, nagpayungot sa Ida kag Ida mga disipulos ag nagpangutana sa Ida it pasikreto, “Gino-o, silinggan sa amo kung sauno matatabo kinang Imo ingsiling? Ag ni-o kag tanra it Imo pagbalik ag kag katapusan it kalibutan?” ");
INSERT INTO bno_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nagsabat si Hesus: “Mag-andam kamo agor indi kamo maluko ag mayaag, ");
INSERT INTO bno_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","dahil maramo kag mapali ag magamit it Ako pangayan. Masiling sinra, ‘Ako kag ingpromisang Kristo,’ kada karamo sinrang maluluko. ");
INSERT INTO bno_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makakarungog kamo it mga gera mayungot sa inro ag mabalitaan ra ninro nak inggwa it mga gera sa mayado. Pero aya kamo gikalibog. Dapat matabo kinang tanan. Pero buko pa kina kag katapusan. ");
INSERT INTO bno_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Magera kag mga nasyon ag mga gingharian. Ag marayan kag mga tigkagutom ag mga linog sa iba't-ibang lugar. ");
INSERT INTO bno_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero kaling tanan ay buko pa katapusan it kalibutan kundi pagtuna pa yang it kahirapan. Kaling mga matatabo ay puyding ikumpara sa usang manug-anak nak napasyapo anay. ");
INSERT INTO bno_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sa oras rang kato, arakpon kamo, apahirapan ag amatyon. Ag alabanan kamo it tanang mga tawo dahil sa inro pagsunor sa Ako. ");
INSERT INTO bno_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sa oras rang kato ay karamo kag matalikor sa inra pagtu-o, atraiduron ag alabanan kag inra isigkatawo. ");
INSERT INTO bno_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mayuaw kag maramong buko matuor nak mga propeta nak maluko sa maramong tawo. ");
INSERT INTO bno_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ag dahil sa pagramo it mga suwail, mawawagit kag pagpalangga it maramong tawo sa inra isigkatawo ag sa Dios. ");
INSERT INTO bno_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero kag tawong makakatiis hastang sa katapusan ay imaw it maluluwas. ");
INSERT INTO bno_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ipalapnag sa bug-os nak kalibutan kag Maadong Balita tungor sa paghari it Dios bilang pamatuor sa tanang lahi ag imawey kag pag-abot it katapusan.” ");
INSERT INTO bno_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nagbisaya pa si Hesus, “Sa paabuton, kag ingpaunang bisaya ni Propeta Daniel ay matutuparey kung makikitaey ninro kinang nagraraya it subrang kayainan nak nagtitinrog sa sagradong lugar. Imawey kina kag magiging dahilan nak abadaan kina it Dios. (Kamong mga nagbabasa, bahalaey kamo mag-intyendi it kali!) ");
INSERT INTO bno_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pag kali'y matabo, kag mga tawo dili sa Hudeya ay dapat magrayagan papagto sa kabukiran. ");
INSERT INTO bno_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kung inggwa't usang tawo nak sa ibabaw it ida bayay ay dapat sidang maghalin nak raan, ag indiey magsuyor sa bayay agor magbaoy pa it ida mga kagamitan. ");
INSERT INTO bno_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ag kung kag usang tawo ay hagto sa ida bukir ay indiey dapat magpauli agor magbaoy it ida baro. ");
INSERT INTO bno_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kaluluoy kag mga sabak ag mga nagpapasuso sa mga adlaw nak kato. ");
INSERT INTO bno_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipangamuyo ninro nak kag inro pagtakas ay indi matabo sa tigyamig o sa Adlaw it Inugpahuway, ");
INSERT INTO bno_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","dahil arayanan it mga tawo kag subrang kahirapan, nak waya't kapareho, tuna pa it katong pagtuga it kalibutan hastang sa ngasing, ag indiey kali marayanan liwat. ");
INSERT INTO bno_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ag kung indi gipalip-uton it Dios kag haba it kaling matatabo ay wayang gador it tawong matutura dili sa duta. Pero alang-alang sa Ida mga pinili, apalip-uton Nida kag haba it kali. ");
INSERT INTO bno_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sa oras rang kato, kung inggwa it mga masiling sa inro, ‘Hali kag ingpromisang Kristo,’ o ‘Hina Sida,’ aya gipati. ");
INSERT INTO bno_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Dahil mayuaw kag maramong buko matuor nak Kristo ag maramong buko matuor nak propeta, ag mapakita sinra it mga katitingayang milagro ag tanra pramas lukuhon ag yaagon kag mga tawo, ag kung pwede, pati kag mga pinili it Dios. ");
INSERT INTO bno_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tanra-e ninro kali! Ingpapaunay Nako kali it siling sa inro. ");
INSERT INTO bno_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kada, kung inggwa't mga masiling sa inro, ‘Hagto Sida sa disyerto!’ Aya gipagtu-e. Ag kung inggwa't masiling sa inro, ‘Hina sida sa suyor!’ Aya gipati. ");
INSERT INTO bno_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Dahil kag Ako pagbalik ay tuyar sa paghadag it kilat halin sa subatan hastang sa sugbuhan, Ako nak dati pa ay ingtatawagey nak Anak it Tawo. ");
INSERT INTO bno_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Matatabo kali tuyar sa ingsiling sa kabisayahan nak marali ninro makita kung hariin inggwa't minatay dahil sa pagragipon it mga uwak.” ");
INSERT INTO bno_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nagpadayon si Hesus sa Ida pagbisaya: “Sa nak raan, pagkatapos it kinang tanan nak kahirapan, ‘maruyom kag adlaw ag indiey maghadag kag buyan. Kag mga bituon halin sa langit ay mahuhuyog, ag kag tanan sa kalangitan ay mahinudong.’ ” ");
INSERT INTO bno_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ag mayuaw sa langit kag tanra it Ako pagbalik, Ako nak dati pa ay ingtatawagey nak Anak it Tawo. Ag mapanambitan kag tanang nasyon dili sa duta, ag makikita ninra Ako nak nagpipilhig ag nakatungtong sa rampog nak puno it gahom ag rakong kahimayaan. ");
INSERT INTO bno_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kag trumpeta ay matunog it makusog ag Ako iparaya kag mga anghel sa tanang parti it kalibutan ag tanang parti it kalangitan pramas tipunon kag tanan nak Ako mga pinili. ");
INSERT INTO bno_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Isipa ninro kag puno it igos dahil inggwa kamo it matutun-an halin raha. Pag nakita ninro nak nagsasalingsingey ag nag-uusborey kag mga rahon, ayamey ninro nak mayungotey kag kwarisma no? ");
INSERT INTO bno_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Imaw ra, pag makita ninro nak natataboey kaling tanang Ako ingsisiling sa inro, maaayaman ninrong mayungotey kag pagbalik Nako nak pay hinaey sa liwas it pwertahan. ");
INSERT INTO bno_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Matuor kaling Ako ingsisiling sa inro. Matatabo kaling tanan bag-o mamatay kag mga buhi pa sa ngasing nak panahon. ");
INSERT INTO bno_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kag langit ag duta ay mawawagit, pero kag Ako mga bisaya ay inding gador mawagit.” ");
INSERT INTO bno_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nagsiling pa si Hesus, “Waya it nakakaayam kung niong adlaw o oras kag Ako pagbalik, aber kag mga anghel sa langit, ag aber ra Ako nak dati pa ay ingtatawagey nak Anak it Tawo. Kag Tatay yang kag nakakaayam it kali. ");
INSERT INTO bno_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kung ni-o kag inghihimo it mga tawo katong sa kapanahunan ni Noe, ay imaw ra kag ahimuon it mga tawo sa Ako pagbalik, Ako nak dati pa ay ingtatawagey nak Anak it Tawo. ");
INSERT INTO bno_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","It kato bag-o gingpabaha kag kalibutan, kag mga tawo ay nagkakaon, nag-iinom ag nag-iinasawa hastang sa adlaw nak nagsuyor sina Noe sa arka. ");
INSERT INTO bno_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ag waya ninra naiisip kung ni-o kag matatabo sa inra hastang nag-abot kag pagbaha ag nagkayumos sinrang tanan. Tuyar ra kag matatabo sa Ako pagbalik, Ako nak dati pa ay ingtatawagey nak Anak it Tawo. ");
INSERT INTO bno_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Sa panahong kato, kung inggwa it ruhang kayake nak nagtatrabaho sa bukir, abay-on kag usa ag ibilin kag usa. ");
INSERT INTO bno_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ag kung inggwa it ruhang kabading nag-aasuran, abay-on kag usa ag ibilin kag usa. ");
INSERT INTO bno_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kada, maghanra kamo, dahil buko ninro ayam kag adlaw it pag-abot it inro Gino-o. ");
INSERT INTO bno_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tanra-e ninro kali. Kung inggwa it usang tag-iya it bayay nak nakakasador kung niong oras maabot kag mananakaw, mabantay sida ag indi nida gipabad-ang suryon kag ida bayay. ");
INSERT INTO bno_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kada kamo ra ay maghanra puat, dahil Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay maabot sa oras nak waya ninro gipapaabuta.” ");
INSERT INTO bno_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nagsiling pa si Hesus, “Isipa ninro kung kamo ay tuyar sa matutom ag maayong suguon nak ingtugyanan it ida amo sa pagrumaya sa ibang mga suguon para mapakaon sinra sa tamang oras. ");
INSERT INTO bno_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Abang buynas katong suguon, kung sa pagbalik it ida amo ay maaabutan sida nak naghihimo it mga ingtugyan sa ida. ");
INSERT INTO bno_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Matuor kaling Ako ingsisiling sa inro. Kinang suguon nak saligan ay imaw kag aimbyaran it ida amo sa ida tanang ari-arian. ");
INSERT INTO bno_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero kung mayain katong suguon, masiling kali sa ida sarili, ‘Rugay pa bag-o magbalik kag ako amo!’ ");
INSERT INTO bno_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kada ida apintasan kag ida mga kaparehong suguon ag sida ay makinaon ag maininom kaibahan kag mga palayango. ");
INSERT INTO bno_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ag sa adlaw ag oras nak waya nida gipapaabuta ay mabalik kag ida amo. ");
INSERT INTO bno_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Grabe kag parusa nak ita-o sa ida it ida amo, ag ipilak sida kaibahan it mga pakitang tawo ruto sa lugar kung hariin kag mga tawo ay nagtitinibaw ag nagpapangpagot kag inra mga ngisi.” ");
INSERT INTO bno_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nagpadayon si Hesus sa Ida pagtudlo. Siling Nida: “Kag mga gusto magpasakop sa paghari it Dios ay puyding ikumpara sa sampuyong rayagang abay nak nagraya it inra iwag ag nagliwas para magsapoy sa kayaking kasayon. ");
INSERT INTO bno_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kag lima sa inra ay alisto, ag kag lima ay buko. ");
INSERT INTO bno_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kag limang buko listo ay nagraya it inra mga iwag, ugaling waya sinra giaman it lana. ");
INSERT INTO bno_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero kag mga listo ay nagraya it lana, puyra pa katong hagto sa inra iwag. ");
INSERT INTO bno_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Narugay kag pag-abot it kayaking kasayon, kada tinungka sinrang tanan ag nakatuyugan. ");
INSERT INTO bno_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pag-abot it tungang gab-i, inggwa it nag-ukaw. Siling nida, ‘Haley sida! Sapuya ninro!’ ");
INSERT INTO bno_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Sa nak raan, nagbangon kag sampuyong abay ag inghanra kag inra mga iwag. ");
INSERT INTO bno_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nagsiling kag mga buko listo sa mga listo, ‘Mahagar baga it aber maisot yang nak lana. Nag-iidlap-idlapey kaling amo mga iwag.’ ");
INSERT INTO bno_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Nagsabat kag mga listo, ‘Sabaling indi gihusto kali sa atong tanan. Maado pa ay pagto yangey kamo sa tinrahan ag magbakay it para sa inro.’ ");
INSERT INTO bno_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kada, naghalin kinang limang buko listo nak abay para magbakay it lana. Pagkahalin ninra, tamang nag-abot kag kayaking kasayon. Kag limang listo ay kanunot nidang nagsuyor sa kasayan, ag ingtrangkahan kag hagran. ");
INSERT INTO bno_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Marugay-rugay, nag-abot kaling limang buko listong mga abay ag nag-ayaba it makusog, ‘Sir, Sir, pasurya kami!’ ");
INSERT INTO bno_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Pero nagsabat kinang kasayon, ‘Matuor kaling Ako ingsisiling sa inro. Buko kamo Nako kilaya!’ ");
INSERT INTO bno_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Kada, maging listo kamo permi, dahil buko ninro ayam kag adlaw ag kag oras it Ako pag-abot.” ");
INSERT INTO bno_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nagsiling pa si Hesus, “Kali kag ibang istorya tungor sa paghari it Dios. Inggwa it usang tawo nak naghanra para magpagto sa mayadong lugar. Bag-o sida naghalin, ingpatawag nida kag ida mga suguon ag ingtugyan sa inra kag ida tanang ari-arian. ");
INSERT INTO bno_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ingsalig nida kag ida kwarta sa bawat usa kumporme sa inra abilidad. Kag usa ay ingtaw-an it limang libo, kag usa ay ingtaw-an it ruhang libo, ag kag usa ay usang libo, bag-o naghalin sida. ");
INSERT INTO bno_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Kinang ingtaw-an it limang libo ay nagpamakay it ibaligya, ag nagkainggwa sida it ganansya nak limang libo. ");
INSERT INTO bno_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Imaw ra katong ingtaw-an it ruhang libo, nagganansya ra sida it ruhang libo. ");
INSERT INTO bno_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero katong ingtaw-an it usang libo ay nagkutkot sa raga ag hagto yinubong katong kwartang ida nabaton.” ");
INSERT INTO bno_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Sa karugayon, nagbalik kinang amo it kaling mga suguon ag ingsumada kag mga ingtugyan sa inra. ");
INSERT INTO bno_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nagsuyor kag ingtugyanan it limang libo ag nagsiling sida, ‘Sir, haley kag limang libo nak ingta-o nimo sa ako pati kag limang libong ganansya nako.’ ” ");
INSERT INTO bno_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Siling it amo sa ida, ‘Ay maado! Matutom ag maado kang suguon! Nasasaligan ka sa maisot nak kwarta, kada aintriguhan ka nako it mas marako. Maley, makinasadya kita.’ ” ");
INSERT INTO bno_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nagpayungot ra kag ingtugyanan it ruhang libo ag nagsiling, ‘Sir, haley kag ruhang libo nak ingta-o nimo sa ako pati kag ruhang libong ganansya nako.’ ” ");
INSERT INTO bno_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Siling it amo sa ida, ‘Ay maado! Matutom ag maado kang suguon! Nasasaligan ka sa maisot nak kwarta, kada aintriguhan ka nako it mas marako. Maley, makinasadya kita!’ ” ");
INSERT INTO bno_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Masunor, nagpayungot kag ingtugyanan it usang libo ag nagsiling, ‘Sir, ayam nakong ikaw ay istrikto. Nag-aani ka aber buko nimo tinamnan ag nagtitipon ka aber buko nimo sinabwagan. ");
INSERT INTO bno_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kada nahadlok ako ag ingyubong nako kag imo kwarta. Kali kag imo usang libo-o.’ ” ");
INSERT INTO bno_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Siling sa ida it ida amo, ‘Mayain ag tamaran kang suguon! Ayam yaki nimo nak nag-aani ako aber buko nako tinamnan ag nagtitipon ako aber buko nako sinabwagan. ");
INSERT INTO bno_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kung tuyar, asing waya nimo kina gihuyugan sa bangko? Ay dey, inggwa tan-a ako it nabaoy nak ganansya ngasing!’ ” ");
INSERT INTO bno_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ag ingsugo nida sa ida mga ibang suguon, ‘Bay-a sa ida kinang usang libo ag ita-o sa inggway it dyes mil. ");
INSERT INTO bno_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kada ngani kag tawo nak inggway ay arugangan pa ag magiging bugana, pero kag waya, dahil sida ay pabada, aber kag asa iday ay abay-on pa. ");
INSERT INTO bno_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ag kaling suguon nak waya't puyos, pilakan ninro ruto sa liwas sa karuymanan. Hagto sida matinibaw ag mapangpagot kag ida ngisi!’ ” ");
INSERT INTO bno_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nagsiling pa si Hesus, “Pag magbalik Ako, nak dati pa ay ingtatawagey nak Anak it Tawo, raya kag Ako kahimayaan ag kanunot kag tanang mga anghel, Ako ay maingkorey sa Ako mahimayaong trono. ");
INSERT INTO bno_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Matipon kag tanang lahi sa Ako atubangan ag abuyag-buyagon Nako sinra sa ruhang grupo, tuyar sa pagbuyag-buyag it manugbantay sa ida mga hadop, usa para sa mga karnero ag usa para sa mga kambing. ");
INSERT INTO bno_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ibutang Nako sa Ako tu-o kag mga maadong tawo nak ingkukumpara sa karnero, ag sa Ako wala kag mga mayaing tawo nak ingkukumpara sa mga kambing. ");
INSERT INTO bno_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ag Ako nak imaw kag Hari ay masiling sa mga asa Ako tu-o, ‘Maley, kamong mga ingpakamaado it Ako Tatay! Batuna kag panublion nak Ida ing-aman sa Ida gingharian para sa inro magtuna pa sa pagtuga it kalibutan. ");
INSERT INTO bno_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Abatunon ninro kina dahil tong Ako ay inggutom, ingpakaon ninro Ako. Tong Ako ay ing-uhaw, Ako ay inro ingpainom, ag tong Ako ay usang dayo sa inro lugar, ingbaton ninro Ako sa inro pamayay. ");
INSERT INTO bno_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","It katong waya Ako it baro, Ako ay inro ingbaruan, tong Ako ay nagkasakit ay inro Ako ing-alagaan, ag tong Ako ay napriso ay inro Ako ingpagtuan ag ingbuligan.’ ");
INSERT INTO bno_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Masabat kag mga maadong tawo nak nagtutuman sa Dios, ‘Gino-o, kauno Ka namo nakita nak nagutom ag ingpakaon Ka namo, nauhaw Ka ag amo ingpainom? ");
INSERT INTO bno_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kauno Ka naging dayo ag amo Ikaw gingbaton sa amo pamayay o waya Ka it baro ay amo Ka ingbaruan? ");
INSERT INTO bno_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kauno Ka ra namo nakitang nagkasakit o sa suyor it prisuhan ag amo Ikaw ingpagtuan ag ingbuligan?’ ");
INSERT INTO bno_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Akong hari ay masabat, ‘Matuor kaling Ako ingsisiling sa inro. It katong inghimo ninro kina para sa aber usa sa mga kubos nak Ako mga hali ay pay sa Ako ra kina ninro ginghimo.’ ");
INSERT INTO bno_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Masunor, masiling Ako ruto sa mga tawo nak asa Ako wala, ‘Payado kamo sa Ako, kamong mga sinumpa it Dios. Pagto kamo sa lugar it kayado nak inding gador mapayong, nak inghanra para kang Satanas ag ida mga sinakupang anghel. ");
INSERT INTO bno_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aparusahan kamo ruto dahil tong Ako ay inggutom, waya ninro Ako gipakauna. Tong Ako ay ing-uhaw, waya ninro Ako gipainuma, ");
INSERT INTO bno_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ag tong Ako ay usang dayo sa inro lugar, waya ninro Ako gibatuna sa inro pamayay. It katong waya Ako it baro, waya ninro Ako gibaru-e, tong Ako ay nagkasakit ag sa suyor it prisuhan, waya ninro Ako gipagtu-e ag gibulige.’ ");
INSERT INTO bno_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ag masabat ra sinra, ‘Gino-o, kauno Ka namo nakita nak inggutom, ing-uhaw, naging dayo, ag nawar-an it baro, inggwa it sakit o asa prisuhan ag waya Ka namo gibulige?’ ");
INSERT INTO bno_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Masiling Ako sa inra, ‘Matuor kaling Ako ingsisiling sa inro. It katong waya ninro gihimu-a kina para sa aber usa sa mga kubos nak Ako mga hali ay waya ra ninro kina gihimu-a sa Ako.’ ");
INSERT INTO bno_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kada ngani Ako aray-on kaling mga tawo sa kaparusahan nak waya't katapusan, pero kag mga maadong tawo nak nagtutuman sa Dios ay Ako ataw-an it kabuhi nak waya't katapusan.” ");
INSERT INTO bno_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagkatapos it kaling tanang pagtudlo ni Hesus, nagsiling Sida sa Ida mga manugsunor, ");
INSERT INTO bno_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ayamey ra ninro nak ruhang adlaw yangey ay Kapistahaney it Pagkaluwas it mga lahi it Hudyo sa Ehipto. Sa oras nak kina Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay atraiduron ag ilansang sa krus.” ");
INSERT INTO bno_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Myentras ingsisiling ni Hesus kali, kag mga Punong Saserdote ag iba pang mga pinuno it mga Hudyo ay nagtipon sa palasyo it Pinaka-mataas nak Saserdote nak si Caipas, ");
INSERT INTO bno_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ag nagplano sinra nak rakpon si Hesus it patago bag-o ipamatay. ");
INSERT INTO bno_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kali kag inra plano, “Indi kali nato gihumanon sa kasagsagan it Pista sabaling magkagulo kag mga tawo.” ");
INSERT INTO bno_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ngasing, habang si Hesus ay ruto sa baryo it Betanya, sa bayay nina Simon nak dati ay di kitong nak ingpaado ni Hesus, ");
INSERT INTO bno_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","inggwa it usang kabading nagpayungot kang Hesus habang sinra ay nagkakaon. Kaling kabade ay inggwa it rayang pabangyo sa usang susudlan nak human sa piling bato, nak kag tawag ay alabastro. Ag ingbubo nida kaling pabangyo sa uyo ni Hesus. ");
INSERT INTO bno_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagkakita kali it Ida mga manugsunor, sinaputan sinra ag napasiling sa usa'g-usa, “Asing ida yang ing-uudakan kinang pabangyo? Kanugon! ");
INSERT INTO bno_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Maado pang ingbaligya yangey kato ag ingta-o kag binta sa mga pobre!” ");
INSERT INTO bno_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Naayaman ni Hesus katong inra ingbisaya, kada siling Nida sa inra, “Asing sida ay inro ingmamayain? Maado kaling ida inghimo sa Ako. ");
INSERT INTO bno_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kag mga pobre ay hina yang permi. Ag aber sauno gusto ninro sinrang buligan ay puyde. Pero Ako ay buko ninro perming kaibahan. ");
INSERT INTO bno_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ingbubo nida kaling pabangyo sa Ako pramas ihanra kag Ako yawas sa pagyubong. ");
INSERT INTO bno_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ag matuor kaling Ako ingsisiling sa inro. Aber hariin ibantala kag Maadong Balita sa bug-os nak kalibutan ay mauumir it sambit nak gador kag inghimo it kaling kabade bilang pagrumrom sa ida.” ");
INSERT INTO bno_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pagkatapos, si Judas Iscariote nak usa sa doseng disipulos ay nagpagto sa mga Punong Saserdote. ");
INSERT INTO bno_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ag nagpangutana sida, “Ni-o kag inro ita-o sa ako kung abuligan nako kamong marakop si Hesus?” Ngani, nagbilang sinra it treyntang pilak ag ingta-o sa ida. ");
INSERT INTO bno_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tuna it kato, naghanapey si Judas it magandang tyempo pramas maita-o si Hesus sa inra mga damot. ");
INSERT INTO bno_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","It katong unang adlaw it Pista it Tinapay nak Waya't Pangpaalsa, nagpayungot kang Hesus kag Ida mga disipulos ag nagpangutana, “Hariin kag Imo gusto nak ihanra namo kag paninghapon para sa Pista it Pagkaluwas sa Ehipto?” ");
INSERT INTO bno_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nagsabat Sida, “Pagto kamo sa syudad ag hanapon ninro katong ato kakilaya ag silingga sida, ‘Siling it Maestro, mayungotey kag Ida oras. Kada ngasing nak Pista, makaon nganat kami sa inro bayay it paninghapon kaibahan kag Ako mga disipulos.’ ” ");
INSERT INTO bno_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nagsunor matuor kag mga disipulos sa sugo ni Hesus ag inghanra ninra kag paninghapon nak para sa Pista it Pagrumrom sa Pagkaluwas sa Ehipto. ");
INSERT INTO bno_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pagkagab-i, nag-atubang si Hesus sa lamesa kaibahan kag Ida doseng disipulos. ");
INSERT INTO bno_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ag habang sinra ay nagkakaon, nagsiling si Hesus sa inra, “Matuor kaling Ako ingsisiling sa inro. Usa sa inro rili kag matraidor sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","It katong narunggan ninra kali, nalisor nak gador kag mga disipulos ag kada usa sa inra ay mansigpangutana kang Hesus, “Ako baga kato, Gino-o? Di baga buko?” ");
INSERT INTO bno_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nagsabat si Hesus, “Kag matraidor sa Ako ay usa sa inro nak nagrurungan sa Ako sa pagsawsaw it tinapay sa mayukong. ");
INSERT INTO bno_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ako nak dati pa ay ingtatawagey nak Anak it Tawo ay mataliwan, kumporme sa nakasuyat sa Sagradong Kasuyatan. Pero kahahadlok kag matatabo sa tawong matraidor sa Ako! Maado pang wayaey sida natawo.” ");
INSERT INTO bno_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nagpangutana ra si Judas nak matraidor sa Ida, “Maestro, ako baga kato?” Nagsabat si Hesus, “Ikaw ngani!” ");
INSERT INTO bno_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Myentras nagkakaon pa sinra, nagbaoy si Hesus it tinapay, ag pagkatapos it pasalamat sa Dios, Ida kali ingbika-biká ag ingpasa sa Ida mga disipulos ag nagsiling, “Baoy kamo. Kali kag Ako yawas.” ");
INSERT INTO bno_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Masunor, ingbaoy ra Nida kag kupa it inumon nak ubas, ag pagkatapos it pasalamat sa Dios ay Ida ra kali ingpasa sa inra ag nagsiling, “Mansig-inom kamong tanan.” ");
INSERT INTO bno_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ag siling Nida, “Kali kag Ako rugo nak imaw it pamatuor sa kasugtanan it Dios sa tawo, ag kali ay mabubuhos para sa maramong tawo agor mapatawar kag inra kasal-anan. ");
INSERT INTO bno_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kali kag Ako isiling sa inro. Tuna ngasing indiey nak gador Ako mag-inom liwat it kaling klase it inumon nak ubas, hastang waya pa Ako nakainom it bag-ong klase it inumon kaibahan ninro sa gingharian it Ako Tatay.” ");
INSERT INTO bno_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pagkatapos it kaling bisaya ni Hesus, nagkanta sinra it usang kantang pagdayaw sa Dios, ag nagpagto sa Baguntor it mga Olibo. ");
INSERT INTO bno_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Habang sinra ay nagpapanaw, nagsiling si Hesus sa Ida mga disipulos, “Isag sa gab-i, Ako ay abadaan ag apabad-an ninrong tanan. Kali kag katuparan it nakasuyat sa Sagradong Kasuyatan nak nagsisiling, “ ‘Amatyon Nako kag manug-alaga, ag kag mga karnero ay mapangyasihas.’ ");
INSERT INTO bno_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Pero pag banhawon Ako it Dios, mauna Ako sa inro ruto sa Galileya.” ");
INSERT INTO bno_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ag nagsiling si Pedro sa Ida, “Aber badaan Ka it tanan, ako ay indi magbada sa Imo.” ");
INSERT INTO bno_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nagsiling si Hesus sa ida, “Matuor kaling Ako ingsisiling sa imo. Isag sa gab-i, bag-o magbayo kag manok, ay tatlong besesey nimo Akong ibalibar.” ");
INSERT INTO bno_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pero nagmatugas si Pedro sa pagsiling, “Aber ako ay mamatay nak kaibhanan Nimo, inding gador Ka nako gibalibar.” Ag imaw ra kag siling it ibang mga disipulos. ");
INSERT INTO bno_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pagkatapos, nagpagto sina Hesus sa usang lugar nak ingtatawag nak Getsemane ag nagsiling Sida sa Ida mga disipulos, “Dili yang anay kamo. Mapangamuyo Ako rutu-o.” ");
INSERT INTO bno_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ag ingnunot ni Hesus si Pedro ag kag ruhang anak ni Zebedeo, ag nasusub-an nak gador Sida ag pay nahihirapan kag Ida buot. ");
INSERT INTO bno_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ag nagsiling Sida sa inra, “Pay Ako'y mamamatay sa Ako rakong kalisor. Hali yang anay kamo ag maging listo ag magbantay kaibahan Nako.” ");
INSERT INTO bno_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Medyo nagpayado-yado si Hesus sa inra ag nagpangamuyo it pasubsob. Siling Nida, “Tatay Nako, kung puyde tan-a ay bay-a sa Ako kaling rakong hirap nak Ako arayanan. Pero sa gihapon ay buko kag Ako kabubut-on it masusunor kundi kag Imo.” ");
INSERT INTO bno_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagkatapos it Ida pangamuyo, nagbalik Sida ag naabutan Nidang nagkakatuyog kinang tatlong disipulos. Kada napasiling Sida kang Pedro, “Indi baga kamo makatiis nak bati kanunot Nako miskin usang oras yang? ");
INSERT INTO bno_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Maging mapagbantay kamo ag magpangamuyo agor indi kamo maraog it panulay. Matuor nak hanra kag ispirito pero kag yawas ay mayuda.” ");
INSERT INTO bno_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nagpayado-yado ray liwat si Hesus ag nagpangamuyo. Siling Nida, “Tatay Nako, kung kinahangyan rang gador nak dapat Nakong rayanan kaling hirap, matutuman kag Imo kabubut-on.” ");
INSERT INTO bno_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pagkatapos, nagbalik ray Sida sa Ida mga disipulos ag naabutan Nida nak katuyog gihapon sinra, dahil waya ninra nakayani kag tungka. ");
INSERT INTO bno_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nagpayado ray liwat Sida sa inra ag nagpangamuyo ray sa pangtatlong beses, ag imaw gihapon kag Ida ingpangamuyo. ");
INSERT INTO bno_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagkatapos, nagbalik ray Sida sa Ida mga disipulos ag nagsiling, “Katuyog pa gihapon kamo? Ag sige pa kag inro paunug-unog? Muyati! Orasey nak atraiduron Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ag ita-o sa damot it mga makasal-anan. ");
INSERT INTO bno_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kitay! Tinrogey kamo! Haley kag matraidor sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Habang nagbibisaya pa yang si Hesus, nag-abot si Judas nak usa sa Ida doseng disipulos. Abang ramo kag ida kanunot nak di rayang talibong ag mga pamakoy. Ingparaya sinra it mga Punong Saserdote ag iba pang mga pinuno it mga Hudyo. ");
INSERT INTO bno_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Bag-o pa sinra nakaabot ruto ay nataoy sa inra it traidor nak si Judas kag sinyas. Siling nida sa inra, “Kag ako aharuan ay imaw nato it ingpali. Rakpa Sida!” ");
INSERT INTO bno_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pag-abot ninra, nagdiretso si Judas kang Hesus ag nagsiling, “Maadong gab-i, Maestro!” ag hinaruan nida kali. ");
INSERT INTO bno_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Siling sa ida ni Hesus, “Amigo, tumanay kung ni-o kag Imo ingpali.” Ag sa nak raan, ingsuuran si Hesus it mga kanunot ni Judas, pinigong ag ingrakop. ");
INSERT INTO bno_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pagkakita kali it mga disipulos ni Hesus, usa sa inra ay naghugot it ida talibong ag inglabo kag suguon it Pinaka-mataas nak Saserdote, ag natagpas matuor kag talinga it kali. ");
INSERT INTO bno_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ag nagsiling si Hesus sa naglabo, “Balikan kinang Imo talibong sa tagob. Kung sa talibong ikaw nabubuhi, sa talibong ra ikaw mamamatay. ");
INSERT INTO bno_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Buko baga nimo ayam nak makakahagar Ako it tabang sa Ako Tatay, ag aparay-an nak raan Ako Nida it mga anghel nak mas maramo pa sa doseng batalyon? ");
INSERT INTO bno_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero kung tuyar kag Ako ahimuon, pauno matutupar kag nakasuyat sa Sagradong Kasuyatan nak nagsisiling nak kali ay dapat nak matabo?” ");
INSERT INTO bno_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ag ing-atubang ni Hesus katong mga tawo ag nagsiling Sida sa inra, “Ako baga ay tulisan? Asing ingraya pa ninro kag mga talibong ag pamakoy para rakpon Ako? Adlaw-adlaw hagto yang Ako nakaingkor sa Templo ag nagtutudlo ag waya ninro Ako girakpa ruto. ");
INSERT INTO bno_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero natabo kaling tanan agor matupar kag ingsuyat it mga propeta sa Sagradong Kasuyatan.” Ag nagpangliklikan kag tanang mga disipulos ag binadaan Sida. ");
INSERT INTO bno_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ingraya si Hesus it mga nagrakop sa Ida sa palasyo ni Caipas nak Pinaka-mataas nak Saserdote kung hariin ay nagtiniponey kag mga Manunudlo it Kasuguan ag kag ibang mga pinuno it mga Hudyo. ");
INSERT INTO bno_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nagsunor si Pedro kana Hesus, ugaling sa mayado-yado sida. Pag-abot sa palasyo it Pinaka-mataas nak Saserdote, nagsuyor si Pedro sa plasa sa tunga it palasyo ag nag-ingkor kanunot it mga gwardya agor makita kung ni-o kag matatabo kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kag mga Punong Saserdote ag kag inra mga kaibahan sa Konseho it mga Hudyo ay naghahanap it dahilan agor maiakusar kang Hesus para ipamatay Sida. ");
INSERT INTO bno_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero aber maramo kag nag-atubang ag nagtestigo it buko matuor laban kang Hesus, waya gihapon sinra it makitang magiging dahilan it inra pag-akusar. Ugaling, katong huli, inggwa it ruhang nag-atubang, ");
INSERT INTO bno_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ag nagsiling, “Siling it kaling tawo kaya kuno Nidang gub-on kag Templo it Dios ag sa suyor kuno it tatlong adlaw ay Ida ray kali apatinrugon.” ");
INSERT INTO bno_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nagtinrog kag Pinaka-mataas nak Saserdote ag nagpangutana kang Hesus, “Waya baga Ikaw it masasabat raha sa inra ing-aakusar sa Imo?” ");
INSERT INTO bno_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero naghipos yang gihapon si Hesus. Kada ingkumpronta ray Sida it Pinaka-mataas nak Saserdote, “Ingsusugo Ka nako sa ngayan it Dios nak Buhi, silinggan sa amo kung Ikaw kag klaro nak ingpromisang Kristo nak Anak it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nagsabat si Hesus, “Oho, Ako ngani. Ag inggwa pa Ako it isiling sa inro. Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay makikita ninro nak nakaingkor sa bandang tu-o it Dios nak Makagagahom. Ag sa Ako pagbalik makikita ra ninro Ako nak nagpipilhig sa mga rampog.” ");
INSERT INTO bno_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagkarungog it kali it Pinaka-mataas nak Saserdote, inggisi nida kag ida baro sa ida kahangit ag napasiling, “Nagpapasipala Sida sa Dios! Pay gingbubutang Nida kag Ida sarili nak Sida ay kapantay it Dios! Bukoey nato kinahangyan kag iba pang testigo. Narungganey ra ninro kag Ida pagpasipala sa Dios! ");
INSERT INTO bno_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ni-o kag inro masisiling?” Nagrungan sinra sa pagsabat, “Dapat sidang matyon!” ");
INSERT INTO bno_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ag ingruy-an ninra si Hesus sa uda ag sinuntok. Gingtampudong pa it iba ");
INSERT INTO bno_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ag nagsiling, “Kristo! Pitlu-a kung si-o kag nagtampudong sa Imo?” ");
INSERT INTO bno_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ngasing, habang si Pedro ay nakaingkor sa plasa sa tunga it palasyo ay nagsuor sa ida kag usang kabulig nak kabade ag nagsiling, “Buko baga ikaw ay usa sa mga kaibahan ni Hesus nak taga-Galileya?” ");
INSERT INTO bno_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero nagbalibar si Pedro sa atubangan it tanang tawo raha. Siling nida, “Ilam, waya nako naaayami kung ni-o kinang imo gingbibisaya.” ");
INSERT INTO bno_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sa nak raan, naglikaw sida papagto sa hagran it pader, ag hagto ray inggwa it usa pang suguon nak kabading nagsiling sa mga tawo, “Kaling kayake ay kanunot ni Hesus nak taga-Nazaret.” ");
INSERT INTO bno_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nagbalibar ray si Pedro. Siling nida “Sumpa man, buko nako kilaya kinang tawo!” ");
INSERT INTO bno_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Marugay-rugay nagpayungot kang Pedro kag mga tawong rahagto ag nagsiling sa ida, “Talagang usa ka sa inra, dahil nakikilaya ka sa punto it imo pagbisaya.” ");
INSERT INTO bno_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nagsabat si Pedro, “Sumpa man, mamatay man ako, talagang buko nako kilaya kinang tawo!” Pagkabisaya it kali ni Pedro, sa nak raan nagbayo kag manok. ");
INSERT INTO bno_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ag narumruman ni Pedro kag pagbisaya sa ida ni Hesus nak, “Bag-o magbayo kag manok ay tatlong besesey nimo Akong ibalibar.” Kada, nagliwas sida ag pumakatibaw. ");
INSERT INTO bno_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagkaaga, habang maruyom pa ay nagtipon ray kag mga Punong Saserdote ag iba pang mga pinuno it mga Hudyo para magkausa sinra kung pauno husgaran it kamatayon si Hesus. ");
INSERT INTO bno_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pagkatapos, ingpagapos ninra Sida ag ingraya kang Gobernador Pilato. ");
INSERT INTO bno_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pagkasador ni Judas nak si Hesus ay inghusgaran it kamatayon, abang rako kag ida pagsuli-suli ag ida ing-uli kag treyntang pilak sa mga Punong Saserdote ag iba pang mga pinuno it mga Hudyo. ");
INSERT INTO bno_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Siling nida, “Nagkasala ako sa ako pagtraidor sa tawo nak waya it sala.” Pero sida ay ingsabat ninra, “Buko amo problema kina! Bahala ka!” ");
INSERT INTO bno_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kada, ingpilak ni Judas katong kwarta sa suyor it Templo bag-o naghalin ag nagbikti. ");
INSERT INTO bno_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ingpunpon it mga Punong Saserdote katong kwarta ag siling ninra, “Bawal sa ato Kasuguan nak irugang kaling kwarta sa kwarta it Templo, dahil kali ay kabadaran sa kabuhi it usang tawo.” ");
INSERT INTO bno_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kada nagkasugot sinra nak katong kwarta ay abakyon yangey kag duta it manughuman it kuyon para himuon nak yubungan it mga dayo. ");
INSERT INTO bno_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kada hastang ngasing, ingtatawag pa gihapon katong duta nak “Duta it Rugo.” ");
INSERT INTO bno_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sa inra inghimong kali, natupar kag ingsiling ni Propeta Jeremias it kato, tong nagsiling sida, “Ingbaton ninra kag treyntang pilak bilang kabadaran sa kasugtanan it mga taga-Israel para sa ida kabuhi, ");
INSERT INTO bno_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ag ingbadar sa duta nak ingbakay sa manughuman it kuyon tuyar sa ingsiling sa ako it Gino-o.” ");
INSERT INTO bno_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ingraya ag ingpaatubang it mga pinuno it mga Hudyo si Hesus kang Gobernador Pilato para husgaran, ag ingpangutana Sida ni Pilato, “Ikaw baga kag Hari it mga lahi it Hudyo?” Nagsabat si Hesus, “Ikawey kag nagsiling!” ");
INSERT INTO bno_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Masunor, ing-akusar Sida it mga Punong Saserdote ag iba pang mga pinuno it mga Hudyo, pero wayaey Sida gisabat. ");
INSERT INTO bno_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kada ingpangutana Sida ni Gobernador Pilato, “Waya baga Nimo narurunggi kag mga ing-aakusar ninra laban sa Imo?” ");
INSERT INTO bno_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wayang gador gilihok-lihok si Hesus, kada abang katingaya ni Pilato. ");
INSERT INTO bno_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bawat Pista it Pagkaluwas sa Ehipto, batasaney it gobernador nak paliwason kag si-o mang priso nak pinili it mga lahi it Hudyo. ");
INSERT INTO bno_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","It kato ay inggwa it usang priso nak bantog sa kayainan ag kag ida ngayan ay Hesus Barabas. ");
INSERT INTO bno_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Katong nagtinipon kag mga tawo, ingpangutana sinra ni Pilato, “Si-o kag inro gustong paliwason nako, si Barabas o si Hesus nak ingtatawag nak Kristo?” ");
INSERT INTO bno_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ingpangutana kali ni Pilato sa inra dahil ayam nidang nahihili yang kang Hesus kag mga pinuno it mga Hudyo, kada ingraya ninra si Hesus para husgaran nida. ");
INSERT INTO bno_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ag habang si Pilato ay nag-iingkor sa husgaran, ingpaabot it ida asawa sa ida nak, “Aya gihusgare it kamatayon kinang tawong waya it kasal-anan, dahil it gab-i ay ingpahirapan ako it ako pananamgo tungor sa Ida.” ");
INSERT INTO bno_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ugaling gingsugsog pang gador it mga Punong Saserdote ag iba pang mga pinuno it mga Hudyo kag mga tawo nak hagaron kang Pilato nak si Barabas kag apaliwason, ag si Hesus kag ipamatay. ");
INSERT INTO bno_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kada, nagpangutana si Pilato sa inra, “Si-o sa ruha kag gusto ninrong paliwason nako?” Nagsabat sinra, “Si Barabas!” ");
INSERT INTO bno_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nagpangutana ray si Pilato sa inra, “Kung tuyar, ni-o kag ahimuon nako kang Hesus nak ingtatawag nak Kristo?” Nagsabat sinrang tanan, “Lansangan Sida sa krus!” ");
INSERT INTO bno_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nagpangutana ray liwat si Pilato, “Asi, niong gador kag Ida nahimong kayainan?” Pero lalo pa sinrang nagpakaukaw, “Lansangan Sida sa krus!” ");
INSERT INTO bno_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Katong nakita ni Pilato nak waya sida it mahihimo ag sabaling magpakagulo pa kag mga tawo, nagpabaoy sida it tubi ag nagpanghinaw sa atubangan it mga tawo. Ag nagsiling sida, “Waya ako it salabtanon sa kamatayon it kaling tawo. Bahalaey kamo.” ");
INSERT INTO bno_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nagsabat kag mga tawo, “Kami ag kag amo mga anak it mapanabat sa ida pagkamatay.” ");
INSERT INTO bno_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pagkatapos it kina, ingpaliwas nida si Barabas ag ingpalatigo si Hesus, bag-o ingtugyan sa mga sundalo para ilansang sa krus. ");
INSERT INTO bno_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pagkatapos, ingraya it mga sundalo si Hesus sa baraks sa suyor it palasyo ni Gobernador Pilato, ag ingraguso Sida it iba pang mga sundalo it inra batalyon. ");
INSERT INTO bno_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ing-ubahan ninra si Hesus ag ingsuy-uban it puyang tela nak pay kapa it hari. ");
INSERT INTO bno_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Masunor, nagyubir sinra it usang siitong bayagon nak inghumang kuruna ag ingputong sa uyo ni Hesus, ag ingpahudot sa Ida tuong damot kag usang kahoy nak pay bakulo. Bag-o nagyuhor sinra ag Sida ay inra inglibak sa pagsiling, “Mabuhay kag Hari it mga Lahi it Hudyo!” ");
INSERT INTO bno_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ingruy-an ninra Sida bag-o ingbaoy katong kahoy nak pay bakulo ag pinaka-bakoy Sida sa uyo. ");
INSERT INTO bno_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkatapos ninrang libakon si Hesus, inra ing-uba katong puyang tela ag ingsuksukan Sida liwat it Ida baro. Masunor, Sida ay inra ingraya paliwas pramas ilansang sa krus. ");
INSERT INTO bno_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Habang ingraraya it mga sundalo si Hesus papagto sa liwas it syudad, inra nakita kag usang kayake nak kag ngayan ay Simon nak taga-Cirene, ag inra ingpilit nak ipapas-an sa ida kag krus ni Hesus. ");
INSERT INTO bno_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pag-abot ninra sa lugar nak ingtatawag nak Golgota, nak kag gustong bisayahon ay “Lugar it Bungo,” ");
INSERT INTO bno_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ingparimrim ninra si Hesus it ayak nak kag simbog ay mapait nak buyong nak pangbaoy it hapros. Pero pagkatagam Nida it kali ay waya Nida giinuma. ");
INSERT INTO bno_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Masunor, inglansangey ninra Sida sa krus bag-o ingpartida kag Ida mga suksok sa parayan it pagbunut-bunutan. ");
INSERT INTO bno_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pagkatapos, nag-iningkor sinra ag ingbantayan Sida ruto. ");
INSERT INTO bno_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ag sa Ida uyuhan, inggwa't nakasuyat nak akusar laban sa Ida nak nagsisiling, KALI SI HESUS NAK HARI IT MGA LAHI IT HUDYO. ");
INSERT INTO bno_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sa Ida magkanyudong habig ay inggwa it ruhang tulisan nak rungan ra sa Idang inglansang sa krus, usa sa tu-o ag usa sa wala. ");
INSERT INTO bno_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kag mga nagrarayan ruto ay naglilibak sa Ida ag napapaliong-liong habang nagsisiling, ");
INSERT INTO bno_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“A! Imaw kuno kali kag maguba it Templo ag mapatinrog liwat sa suyor it tatlong adlaw! Ngasing, salbara kag Imo sarili! Kung klarong Ikaw kag Anak it Dios, pilhig raha sa krus!” ");
INSERT INTO bno_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Imaw ra kag inghihimo it mga Punong Saserdote kanunot kag mga Manunudlo it Kasuguan ag mga pinuno it mga Hudyo. ");
INSERT INTO bno_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nagsisiling sinra, “Ingsalbar Nida kag ibang tawo pero kag Ida sarili ay indi Nida kayang salbaron! Anong klasing Hari kali it Israel? Kung mapilhig yang Sida ngasing sa krus, mapatey kami sa Ida! ");
INSERT INTO bno_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nagsasalig kuno Sida sa Dios ag ingsisiling pa Nidang Sida kag Anak it Dios. Kung klaro kina, asalbaron tan-a Sida it Dios.” ");
INSERT INTO bno_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Katong ruhang tulisan nak ginglansang nak karungan Nida ay naglibak ra sa Ida. ");
INSERT INTO bno_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pag-abot it alas dose it adlaw, gulping nagruyom kag bug-os nak kadutaan hastang alas tres it hapon. ");
INSERT INTO bno_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Katong maalas tresey it hapon, nag-ukaw it abang kusog si Hesus, “Eli, Eli, lama sabaktani?” Kag gustong bisayahon it kali ay “Ako Dios, Ako Dios, asing Imo Ako gingpabad-an?” ");
INSERT INTO bno_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pagkarungog kali it ibang mga nagtitinrog ruto ay napasiling sinra nak, “Ging-aayaba Nida si Propeta Elias!” ");
INSERT INTO bno_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Inggwa ruto it usa nak nagrayagan ag nagbaoy it espongha, ingbasa kali it maaslom nak ayak nak pay sukà ag ingtuslok sa ugbos it usang pay tigbaw. Bag-o ida kato ingruot sa yuba ni Hesus para supsupon. ");
INSERT INTO bno_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero siling ray it iba, “Ya anay, amuyatan nato kung mapakita si Propeta Elias agor isalbar Sida sa krus.” ");
INSERT INTO bno_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nag-ukaw ray liwat si Hesus it makusog ag gingtugyan Nida kag Ida ispirito sa Dios. ");
INSERT INTO bno_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Katong oras rang kato, it yang gulpi't gisi kag maramoy nak kurtina sa tunga it Sagradong Lugar it Templo, tuna sa ibabaw hastang sa ubos. Naglinog ag nagis-ak kag mga maragkong bato. ");
INSERT INTO bno_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Naabrihan kag mga yuyubngan ag nabanhaw kag maramong sinakupan it Dios nak namatayey. ");
INSERT INTO bno_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nagliniwas sinra sa yuyubngan, ag it katong nabanhaw si Hesus, sinra ay nagsuyor sa Herusalem nak imaw kag sagradong syudad, ag hagto sinra ay nakita it maramong tawo. ");
INSERT INTO bno_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Katong nabatyagan kag linog it Kapitan ag mga sundalo nak nagbabantay kang Hesus, ag nakita ninra kag tanang natabo, abang kahadlok ninra ag sinra ay napasiling, “Matuor nak gador, Sida kag Anak it Dios!” ");
INSERT INTO bno_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hagto ra sa medyo mayado-yado ay inggwa it maramong kabade nak nagmumuyat. Sinra ay mga manugsunor ra ni Hesus ag nagsiserbisyo sa Ida tuna pa sa Galileya. ");
INSERT INTO bno_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kag iba sa inra ay si Maria Magdalena, si Mariang nanay ni Santiago ag Jose, ag kag nanay it ruhang anak ni Zebedeo. ");
INSERT INTO bno_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Katong medyo haponey, nag-abot kag usang manggaranon nak taga-Arimateya nak kag ngayan ay Jose. Sida ra kag usa sa mga manugsunor ni Hesus. ");
INSERT INTO bno_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nagpagto sida kang Gobernador Pilato ag inghagar nida kag yawas ni Hesus. Nagsugo si Pilato nak ita-o kato sa ida. ");
INSERT INTO bno_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kada ingbaoy ni Jose kag yawas ni Hesus ag ingsaliburburan it bag-ong yamit nak lino. ");
INSERT INTO bno_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Masunor, ingyubong nida kato sa sarili nidang yuyubngan, nak bag-o pa yang nidang ingpatiltil nak pay kuyba sa abang rakong bato. Pagkatapos, ida ingpaliger kag usang marakong bato nak pangsara rahang bungaran it yuyubngan, bag-o naghalin sida. ");
INSERT INTO bno_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ruto ra si Maria Magdalena ag usa pang Maria. Nakaingkor sinra ruto nak nakaatubang sa yuyubngan ni Hesus. ");
INSERT INTO bno_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Katong adlaw nak ingyubong si Hesus ay ingtatawag nak Adlaw it Paghanra para sa Adlaw it Inugpahuway. Ag pagkasunor nak adlaw, nak imawey kag Adlaw it Inugpahuway, nagpagto kang Gobernador Pilato kag mga Punong Saserdote ag mga Pariseo. ");
INSERT INTO bno_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Siling ninra, “Gobernador, narumruman yaki namo nak it katong buhi pa katong manluluko, siling Nida, Sida kuno ay mababanhaw sa pangtatlong adlaw, ");
INSERT INTO bno_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","kada pabantayi it maado kag Ida yuyubngan hastang sa pangtatlong adlaw. Sabaling magpagto kag Ida mga manugsunor ag takawon kag minatay, ag isiling sa mga tawo nak Sida ay nabanhaw. Kung matabo kina, mas grabe pa kag aliwasan it pangluko ninra kisa naunang inghimo ni Hesus.” ");
INSERT INTO bno_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ingsabat sinra ni Pilato, “Baoy it mga sundalo ag pabantayi it maado kag yuyubngan sa abot it inro kakayahan.” ");
INSERT INTO bno_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kada nagpagto sinra sa yuyubngan, ag ingmarkahan kag batong ingsara rili para maayaman kung inggwa it mapaliger sa bato. Ag ingbilin kag mga sundalo para magbantay sa yuyubngan. ");
INSERT INTO bno_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagkalipas it Adlaw it Inugpahuway, myentras aga-aga pa it adlaw nak Dominggo, nagpagto sina Maria Magdalena ag katong usang Maria. ");
INSERT INTO bno_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Katong oras mismo it yang gulpi't linog it makusog, dahil nagbaba halin sa langit kag usang anghel it Gino-o nak nagpayungot sa yuyubngan ag ingliger kag batong pangsara ruto bag-o nag-ingkor sa ibabaw it bato. ");
INSERT INTO bno_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kag ida uda ay abang siga nak pay kilat ag abang puti kag ida baro. ");
INSERT INTO bno_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sa kahadlok it mga sundalong nagbabantay sinra ay nagpanguyog, nagtinumba ag nawar-an it malay nak pay minatay. ");
INSERT INTO bno_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pero nagsiling kag anghel sa mga kabade, “Aya kamo gikahadlok. Ayam nakong inghahanap ninro si Hesus nak inglansang sa krus. ");
INSERT INTO bno_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wayaey sida rili, dahil nabanhawey Sida kumporme sa Ida ingsiling! Maley, muyati ninro kag lugar kung hariin ingbutang kag Ida yawas. ");
INSERT INTO bno_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pagkatapos ninrong mamuyatan, pagtoy kamo ag ibalita sa Ida mga manugsunor nak Sida ay nabanhawey. Ag mauunay Sida sa inro papagto sa Galileya. Ruto ay makikita ninro Sida. Aya ninro gilimti kaling ako ingsiling sa inro.” ");
INSERT INTO bno_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kada, nagrali-rali sinra it halin sa yubungan. Nahahadlok sinra pero rako ra kag inra kasadya. Paspasan sinra it rayagan papagto sa mga manugsunor ni Hesus para ibalita kag natabo. ");
INSERT INTO bno_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Habang nagrarayagan sinra, nasapoy ninra it gulpi si Hesus ag ingbugno sinra, “Pariin kamo?” Nagpayungot sinra sa Ida, ag inghuytan ninra kag Ida siki ag ingdayaw Sida. ");
INSERT INTO bno_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ingsilinggan sinra ni Hesus, “Aya kamo gikahadlok! Pagtoy ag silinggan kag Ako mga hali nak magpagto nganat sa Galileya. Makikita ninra Ako ruto.” ");
INSERT INTO bno_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pagkahalin it katong mga kabade, kag ibang mga sundalo nak nagbabantay sa yuyubngan ay nagbalik ra sa syudad ag ingbalita sa mga Punong Saserdote kag tanang natabo. ");
INSERT INTO bno_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kada nagtinipon kag mga Punong Saserdote ag iba pang mga pinuno it mga Hudyo ag naghinuon kung ni-o kag inra ahimuon. Ingbadaran ninra it husto kag mga sundalo agor tumanon ninra kag inra plano, ");
INSERT INTO bno_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ag ingsugo ninra kag mga sundalo nak ipamalita. Siling ninra, “Imaw kali kag inro isiling, ‘Katong gab-i habang katuyog kami, nagpagto kag mga manugsunor ni Hesus ag ingtakaw kag Ida yawas.’ ");
INSERT INTO bno_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ag aya kamo gikalibog, kung makaabot man kali sa gobernador, kami it bahala, nak magpaintyendi sa inro agor indi kamo maparusahan.” ");
INSERT INTO bno_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ngani, ingbaton it mga sundalo katong kwarta ag inghimo kag sugo sa inra. Kada hasta ngasing, imaw pa kali kag ing-iistorya it mga lahi it Hudyo. ");
INSERT INTO bno_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ngasing, kag onseng disipulos kag nagpagto sa Galileya, sa bukir nak ingtudlo sa inra ni Hesus. ");
INSERT INTO bno_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkakita ninra kang Hesus, Sida ay inra ingdayaw. Pero kag iba sa inra ay nagdududa gihapon. ");
INSERT INTO bno_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nagpayungot sa inra si Hesus ag nagsiling, “Ingtaoy sa Ako kag tanan nak karapatan sa langit ag duta. ");
INSERT INTO bno_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kada pagtoy kamo sa tanang mga lahi ag tudluan sinra kung pauno maging manugsunor Nako. Bawtismuhe sinra sa ngayan it Dios nak Tatay, Anak ag Ispirito Santo. ");
INSERT INTO bno_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tudlu-e ra sinrang tumanon kag tanang sugo Nako sa inro. Ag tanra-e ninro, Ako ay puat kaibhanan ninro hastang sa katapusan it kalibutan.”");
INSERT INTO bno_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Imaw kali kag pagtuna it Maadong Balita nahanungor kang Hesu-Kristo nak Anak it Dios. ");
INSERT INTO bno_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","It katong una pa ay gingsuyat ni Propeta Isaias kaling mga bisaya it Dios sa Ida Anak, “Apaunahon Nako sa Imo kag Ako suguon, nak imaw kag mahanra it Imo arayanan.” ");
INSERT INTO bno_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Sida katong nagbabantala it makusog sa mayangkag nak kabukiran nak nagsisiling, “ ‘Ihanra ninro kag arayanan it Gino-o, Tadlunga kag Ida mga rayanan.’ ” ");
INSERT INTO bno_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Natupar kali it katong nagpagto si Juan nak Manugbawtismo sa mayangkag nak kabukiran, ag hagto sida nagbabantala nak kag mga tawo ay dapat maghinuysoy ag magpabawtismo agor apatawaron it Dios kag inra mga kasal-anan. ");
INSERT INTO bno_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ag maramong tawo halin sa bug-os nak probinsya it Hudeya ag maramong taga-Herusalem ay nagpipinagto sa ida. Ingpahadag anay ninra kag inra mga kasal-anan bag-o ingbabawtismuhan sinra ni Juan sa Suba it Jordan. ");
INSERT INTO bno_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kag gingsusuksok yang ni Juan ay baro nak human sa yinayang balahibo it kamelyo ag kag Ida panghagkos ay human sa anit it hadop, ag kag ida gingkakaon ay mga apan-apan ag rugos. ");
INSERT INTO bno_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kali kag ida perming ingwawali, “Sa paabuton ay inggwa it usang maabot nak mas yabaw pa kisa sa ako, ag aber magyuhor agor hubaron kag higot it Ida sandalyas ay buko ako angay. ");
INSERT INTO bno_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ingbabawtismuhan nako kamo sa tubi, pero Sida kag mabawtismo sa inro it Ispirito Santo.” ");
INSERT INTO bno_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","It katong hagto pa si Juan sa Suba it Jordan, si Hesus ay nagpagto ra ruto halin sa banwa it Nazaret sa Galileya. Pag-abot Nida ruto, nagpabawtismo ra Sida kang Juan. ");
INSERT INTO bno_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pagkatapos it bawtismo kang Hesus, katong nagtatakasey Sida sa tubi, sa nak raan nakita Nida nak nagbuka kag langit, ag nagbaba sa Ida kag Ispirito Santo tuyar sa usang salumpati. ");
INSERT INTO bno_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ag inggwa't usang Boses halin sa langit nak nagsiling, “Ikaw kag Ako pinalanggang Anak, ag sa Imo ay rako kag Ako kamuot.” ");
INSERT INTO bno_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pagkatapos it bawtismo kang Hesus, sa nak raan ay ingpilit Sida it Ispirito Santo nak magpagto pa sa mayado ag mayangkag nak kabukiran. ");
INSERT INTO bno_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ag ruto Sida gitiner sa suyor it kwarentang adlaw nak ingtitintar ni Satanas. Ruto ay inggwa it mga ilahas nak hadop, pero kag mga anghel kag nag-aasikaso sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pagkarungog ni Hesus nak napriso si Juan nak Manugbawtismo, nagbalik Sida sa probinsya it Galileya ag ruto Sida nagwali it Maadong Balita halin sa Dios. ");
INSERT INTO bno_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Siling Nida sa mga tawo, “Imawey kali kag panahon ag mayungotey kag paghari it Dios. Kada maghinuysoyey kamo ag magtu-o sa Maadong Balita.” ");
INSERT INTO bno_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Usang adlaw, habang nagpapanaw si Hesus sa habig it Ragat it Galileya, nakita Nida kag ruhang tawo nak kag mga ngayan ay si Simon ag si Andres nak ida manghor. Sinra ay nagpapangyada dahil mangingisra sinra. ");
INSERT INTO bno_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ing-ayaba sinra ni Hesus, “Maley! Sunor kamo sa Ako! Atudluan Nako kamo kung pauno makaraya it mga tawo nak masunor sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sa nak raan ingbadaan ninra kag inra pagpangisra ag nagsunor sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nagpadayon sina Hesus sa pagpanaw, ag sa medyo unhan ay inggwa ray sinra it nakita nak magmanghor nak sina Santiago ag Juan nak mga anak ni Zebedeo. Sinra ay asa inra rayapang nak nagtatahi it inra lambat. ");
INSERT INTO bno_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ging-ayaba ra nak raan sinra ni Hesus nak magsunor sa Ida. Ag nagsalta sinra sa rayapang ag inra ingbilin kag inra tatay nak si Zebedeo ruto kaibahan kag mga grumiti, bag-o nagsunor sinra kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pagkatapos, nagpagto sina Hesus sa syudad it Capernaum. Ag pag-abot it Adlaw it Inugpahuway, nagsuyor sinra sa sinagoga ag ingtudluan ni Hesus kag mga tawo. ");
INSERT INTO bno_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Katong mga tawo nak nakarungog ay rakong gador kag katingaya ninra sa Ida pagtudlo, dahil nakita ninra nak kag Ida pagtudlo ay inggwa't gahom, ag buko tuyar sa pagtudlo it inra mga Manunudlo it Kasuguan. ");
INSERT INTO bno_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ruto sa sinagoga ay inggwa it usang tawo nak nasasaniban it mayaot. ");
INSERT INTO bno_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Marugay-rugay ay umidagak sida ag nagbisaya, “Hoy! Hesus nak taga-Nazaret! Aunhon kami Nimo? Nagpali baga Ikaw agor parusahan kami? Kilaya Ka nako! Ikaw kag Balaan nak halin sa Dios!” ");
INSERT INTO bno_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero, gingsaway ni Hesus katong mayaot sa pagsiling, “Hipos! Layas hina sa tawo!” ");
INSERT INTO bno_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Gingpakisay-kisay anay it mayaot katong tawo ag nagpapaka-idagak bag-o nagliwas sa ida. ");
INSERT INTO bno_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Abang katingaya it tanang nakakita it kali, kada sinra ay mansigpangutana sa usa'g-usa tungor kang Hesus. Siling ninra, “Ni-o kali? Bag-ong parayan ray baga it pagtudlo? Asing inggwa Sida it gahom nak pati kag mayaot ay nasunor sa Ida?” ");
INSERT INTO bno_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sa nak raan ay nabalita sa bug-os nak probinsya it Galileya kag tungor kang Hesus ag sa Ida ginghuman. ");
INSERT INTO bno_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Halin sa sinagoga, nagpagto si Hesus sa bayay nina Simon ag Andres kaibahan sina Santiago ag Juan. ");
INSERT INTO bno_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ruto kag panugangan nak kabade ni Simon ay naghihigra dahil sida ay gingsasagnat. Pag-abot ni Hesus ruto, ging-umaan nak raan Sida nak ingsasagnat katong maguyang. ");
INSERT INTO bno_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ingpayungutan sida ni Hesus ag inghuytan kag damot ag ingbangon. Sa nak raan ay nawagit kag ida sagnat ag nagtahaw sida sa inra. ");
INSERT INTO bno_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pagsugbo it adlaw, maruyomey, gingpangraya it mga tawo kang Hesus kag tanang mga masakit ag mga ingsasaniban it mayaot agor apaaduhon Nida. ");
INSERT INTO bno_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kada halos tanang tawo sa banwa ay nagtinipon sa atubangan it bayay ni Simon. ");
INSERT INTO bno_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kag tanan nak inggwa't aber niong klasing sakit ay gingpaado ni Hesus. Gingpalayas ra Nida kag maramong mayaot, pero waya Nida gipabisayaha, dahil ayam ninra kung sin-o si Hesus. ");
INSERT INTO bno_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Aga-aga pa it kag masunor nak adlaw, nagbangoney si Hesus ag nagpagto sa usang lugar nak waya't tawo, kung hariin ay ruto Sida nagpangamuyo. ");
INSERT INTO bno_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pagkamalay nina Simon nak wayaey ruto si Hesus ay inra Sida inghanap. ");
INSERT INTO bno_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ag tong nakitaey ninra Sida, nagsiling sinra, “Inghahanap Ka namo!” ");
INSERT INTO bno_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero nagsabat si Hesus, “Badyangey anay, dahil kinahangyan pa nato nak magpagto sa mga banwa nak mayungot dili, agor mawali ra Ako ruto. Imaw kali kag rason kung asing nagpaali Ako sa kalibutan.” ");
INSERT INTO bno_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kada, ginglibot nina Hesus kag bug-os nak probinsya it Galileya ag Sida ay nagbabantala sa mga sinagoga, ag nagpapalayas it mga mayaot sa mga tawo nak nasasaniban it kali. ");
INSERT INTO bno_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Usang adlaw, inggwa it usang tawo nak di sakit nak kitong nak nagpayungot kang Hesus, ag nagyuhor sa Ida atubangan habang nagpapakitluoy. Siling nida, “Gino-o, kung Imo abut-on, mapapaado Nimo ako.” ");
INSERT INTO bno_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Abang kaluoy ni Hesus diling tawo ag inghuytan Nida kali, ag nagsiling, “Oho, gusto Nako! Apaaduhon ka Nako!” ");
INSERT INTO bno_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ag sa nak raan ay nawagit kag ida kitong ag naglinas kag ida anit. ");
INSERT INTO bno_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Pagkatapos, gingsilinggan sida ni Hesus it tuyar kali, “Tanra-e it maado, aya nak gador gipang-uma-umaan sa mga tawo kaling Ako inghuman sa imo. Kundi pagto anay nak raan sa saserdote ag pamuyati sa ida kag imo yawas nak naulian. Ag mata-o ka it halar kumporme sa Kasuguan ni Moises bilang pamatuor sa mga tawo nak ikaw ay maadoy.” Ag sida ay gingpahalin Nida sa nak raan. ");
INSERT INTO bno_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero imbes nak maghipos yang kaling tawo ay gingpang-uma-uma nida kag ginghuman sa ida ni Hesus sa tanang ida nasasapoy. Ngani, napakabantog si Hesus ag indiey basta-basta makasuyor sa mga banwa, dahil gingpapaka-ragipunan Sida it mga tawo. Kada ruto yangey Sida sa mga bukir-bukir. Pero sige gihapon kag pinagto sa Ida it mga taga-iba't-ibang mga lugar. ");
INSERT INTO bno_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pagkalipas it pilang adlaw, nagbalik sina Hesus sa syudad it Capernaum. Nagkalat nak raan sa mga tawo ruto kag balita nak sinra ay nag-abotey. ");
INSERT INTO bno_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Maramong tawo kag nagpinagto kang Hesus ag nagtinipon ruto sa Ida gingdadayunan. Ag napuno it mga tawo kag suyor it kinang bayay hastang sa hagranan, kada indiey makasuyor kag iba. Ag ruto Sida ay nagwali it mga bisaya it Dios sa inra. ");
INSERT INTO bno_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","It kag Sida ay nagwawali, inggwa't aray-on tan-a sa Ida nak usang yupog nak gingbabadawan sa rudan it ap-at nak tawo. ");
INSERT INTO bno_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero dahil sa kasiot, waya sinra nakapayungot kang Hesus. Kada kag inra yangey ginghuman ay nagsaka sa diskanso sa ibabaw it bayay ag ingyubtan ninra kato sa tungor ni Hesus, agor iyusot katong yupog. Bag-o gingtunton ninra katong ida higraan nak rudan paubos. ");
INSERT INTO bno_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pagkakita ni Hesus kung pauno't rako kag inra pagtu-o sa Ida, nagsiling Sida sa yupog, “Doy, gingpatawarey kag imo mga kasal-anan.” ");
INSERT INTO bno_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Inggwa ra ruto it mga nag-iingkor nak pilang mga Manunudlo it Kasuguan. Ag pagkarungog ninra it kaling gingbisaya ni Hesus, nagpangutana sinra sa inra sarili, ");
INSERT INTO bno_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Asing tuyar magbisaya kaling tawo? Rakong pasipala kali sa Dios! Kaling tawo ay pay nag-aako nak Sida ay kapareho it Dios! Asi, si-o pa it makakapatawar sa mga kasal-anan it tawo, di baga Dios yang?” ");
INSERT INTO bno_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero ayamey ni Hesus kung ni-o kag inra ing-iisip, kada napasiling Sida sa inra, “Asing tuyar kag inro ging-iisip? ");
INSERT INTO bno_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ni-o kag mas marali igsiling diling yupog? ‘Ingpatawarey kag imo mga kasal-anan,’ o ‘Bangoney ag ray-on kinang imo rudan ag pumanawey!?’ ");
INSERT INTO bno_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ako kali ingpapakita sa inro pramas pamatuuran nak Ako, nak dati pa ay ingtatawagey nak Anak it Tawo, ay inggwa't karapatan dili sa duta nak magpatawar sa mga kasal-anan.” Kada nagsiling ray Sida sa yupog, ");
INSERT INTO bno_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Gingsisiling Nako sa imo, bangoney raha, ag ray-on kinang imo rudan ag pumauliey.” ");
INSERT INTO bno_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ag habang nagmumuyat sinra, nagtulay matuor kinang yupog ag nagpanaw. Abang katingaya it katong tanan nak nagmumuyat, ag sinra ay nagdayaw sa Dios nak napasiling, “Aba! Waya pang gador ako nakakita it tuyar kato!” ");
INSERT INTO bno_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pagkatapos it kina, nagbalik ray sa Hesus sa habig it Ragat it Galileya, ag ingragipunan Sida it maramong tawo, kada nagtudlo Sida sa inra. ");
INSERT INTO bno_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Naghalin si Hesus ruto, ag sa Ida pagpanaw nakita Nida kag usang manugsukot it buhis nak kag ngayan ay Levi, nak anak ni Alpeo. Sida ay nag-iingkor sa ida pwesto. Nagsiling si Hesus sa ida, “Maley, sunor sa Ako!” Nagtinrog matuor si Levi ag nagnunot sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Marugay-rugay, habang nagkakaon sina Hesus ag Ida mga manugsunor sa bayay nina Levi, nag-inabot kag maramong manugsukot it buhis ag iba pang mga makasal-anang tawo, ag nagrungan sinra it kaon nina Hesus, dahil maramong tuyar nak tawo kag nagsinunor sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nakaabot sa mga Pariseo ag mga Manunudlo it Kasuguan nak nagrurungan it kaon yaki si Hesus sa mga manugsukot it buhis ag iba pang mga makasal-anan. Kada nagpangutana sinra sa mga manugsunor ni Hesus, “Asing nagrurungan Sida it kaon sa mga manugsukot it buhis ag iba pang mga makasal-anang tawo?” ");
INSERT INTO bno_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Narunggan sinra ni Hesus, kada nagsabat Sida parayan sa usang kabisayahan, “Kag tawo nak waya't sakit ay bukoey kinahangyan kag doktor kundi kag inggwa yang it sakit. Kag rason kung asing nagpali Ako ay para tawagon kag mga makasal-anan, buko para sa mga nag-iisip nak sinra ay maadong tawo.” ");
INSERT INTO bno_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Usang adlaw, it katong nagpupuasa kag mga manugsunor ni Juan nak Manugbawtismo ag mga manugsunor it mga Pariseo ay inggwa't pilang tawo nak nagpayungot ag nagpangutana kang Hesus, “Asing katong mga manugsunor ni Juan ag mga manugsunor it mga Pariseo ay nagpupuasa, pero kag Imo mga manugsunor ay waya?” ");
INSERT INTO bno_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Gingsabat sinra ni Hesus, “Asi, sa oras it kasay, mapuasa pa baga kag mga tigkayake kung kaibahan pa ninra kag kayake nak akasayon? Syempre indi! Myentras rahina pa kag kasayon nak kayake ay waya gipupuasa kag mga tigkayake. ");
INSERT INTO bno_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero maabot kag mga adlaw kung sauno abay-oney sa inra kinang kayake nak kasayon, ag imawey kag adlaw nak sinra ay mapuasa. ");
INSERT INTO bno_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Waya it naghahakpoy it bag-ong yamit sa yumang baro, dahil maukyo kag bag-ong yamit nak inghakpoy ag lalong marako kag gisi it kinang yumang baro. ");
INSERT INTO bno_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Imaw ra, waya it nagsusuyor it bag-ong human nak ayak sa yumang susudlan nak human sa anit it hadop, dahil kung isuyor kina sa yumang susudlan, mayupok kag susudlan, mauudak kag ayak ag indiey mapuyusan kinang susudlan. Kag tamang himuon ay ibutang kag bag-ong human nak ayak sa bag-ong susudlan nak human sa anit it hadop.” ");
INSERT INTO bno_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Usang adlaw nak Sabado nak imaw kag Adlaw it Inugpahuway it mga lahi it Hudyo, naparayan sina Hesus sa triguhan. Ag habang nagrarayan sinra ruto ay nagpuksi kag Ida mga manugsunor it uhay. ");
INSERT INTO bno_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pagkakita it mga Pariseo, nagsiling sinra kang Hesus, “Hay, muyati kag inra inghihimo! Asing inghihimo ninra kag ingbabawal sa Adlaw it Inugpahuway?” ");
INSERT INTO bno_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nagsabat si Hesus, “Waya baga ninro nabasa kag inghimo nina Haring David it katong inggutom sida ag ida mga kanunot? ");
INSERT INTO bno_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","It katong kapanahunan it Pinaka-mataas nak Saserdote nak si Abiatar, ay nagsuyor si David sa Bayay it Dios ag nagbaoy it tinapay nak hinalar sa Dios ag ingkaon, ag ida ra ingpakaon kag ida mga kaibahan. Kumporme sa Kasuguan ni Moises kina ay bawal kaunon it aber sin-o puyra yang sa mga saserdote.” ");
INSERT INTO bno_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Siling pa ni Hesus, “Ginghimo it Dios kag Adlaw it Inugpahuway alang-alang sa kaanduan it tawo, buko nak kag tawo ay ginghimo para sa Adlaw it Inugpahuway. ");
INSERT INTO bno_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kada ngani Ako nak dati pa ay ingtatawagey nak Anak it Tawo kag inggwa it karapatan nak magsiling kung ni-o kag puyding himuon ag indi, sa Adlaw it Inugpahuway.” ");
INSERT INTO bno_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Usang Adlaw ray it Inugpahuway, nagpagto si Hesus sa inra sinagoga. Ag inggwa ruto it usang kayaking pingkaw kag usang damot. ");
INSERT INTO bno_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ruto ra ay inggwa it pilang mga Pariseo, ag inra gingmamasran si Hesus kung Ida apaaduhon katong pingkaw sa Adlaw it Inugpahuway pramas inggwa sinra it rason nak maiakusar Sida. ");
INSERT INTO bno_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ing-ayaba ni Hesus katong pingkaw ag ingsilinggan, “Maley dili sa tunga.” ");
INSERT INTO bno_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ag nagpangutana si Hesus sa mga tawo, “Kumporme sa Kasuguan, ni-o kag puyding himuon nato sa Adlaw it Inugpahuway, maado o mayain? Magsalbar it tawo o magpangmatay?” Pero naghipos yang sinra ag waya gisabat. ");
INSERT INTO bno_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Gingmuyatan sinrang tanan palibot ni Hesus nak inggwa't kahangit, dahil waya sinra it kaluoy sa inra isigkatawo. Ag Sida ay nalisor ra, dahil sa inra katugasan it tagipusuon. Masunor, gingbisayahan ni Hesus katong pingkaw, “Hunata kag imo damot!” Inghunat matuor it kinang kayake kag ida damot ag nag-ado kato. ");
INSERT INTO bno_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ag tong nakita ninra kina, sa nak raan naghinalin kinang mga Pariseo kaibahan kag mga kakampi ni Haring Herodes Antipas, ag nagplano sinra kung pauno ipamatay si Hesus. ");
INSERT INTO bno_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pagliwas nina Hesus ag Ida mga manugsunor sa sinagoga, naglikaw sinra papagto sa Ragat it Galileya. Nagsinunor sa inra kag abang ramong tawo halin sa mga probinsya it Galileya ag Hudeya, ");
INSERT INTO bno_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ag halin ra sa syudad it Herusalem. Inggwa ra it mga halin sa lugar it Idumeya ag sa tabok it Suba it Jordan, ag inggwa ra it halin sa palibot it mga banwa it Tiro ag Sidon. Nagpagto sinra kang Hesus dahil narunggan ninra kag tanang Ida ginghihimo. ");
INSERT INTO bno_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Dahil sa karuramong tawo, nagpahanra si Hesus sa Ida mga manugsunor it baruto nak Ida asakyan, sabaling maipit Sida it kaling mga tawo nak nagrurukrukan. ");
INSERT INTO bno_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ag dahil karamo kag Ida mga napaado, tanang mga di sakit ay nagtutuyuran agor makapayungot ag makahudot sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kaibahan sa mga tawo rahagto ay kag mga nasasaniban it mga mayaot, ag bawat makita ninra si Hesus, sinra ay nagyiyinuhor sa atubangan Nida ag nagpapaka-ukaw it, “Ikaw kag Anak it Dios!” ");
INSERT INTO bno_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero gingbabawalan ni Hesus kaling mga mayaot nak mag-uma sa mga tawo kung si-o Sida. ");
INSERT INTO bno_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagkatapos, nagtukar si Hesus ruto sa baguntor ag gingpanunot Nida kag Ida mga gustong panunton. ");
INSERT INTO bno_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nagpili Sida it dose nak tawo nak imaw kag ingtatawag nak mga “apostoles” pramas maging kaibahan Nida, ag agor Ida iparaya nak magwali sa mga tawo. ");
INSERT INTO bno_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Sinra ay Ida ra gingtaw-an it karapatan ag gahom nak magpalayas it mga mayaot sa mga ingsasaniban. ");
INSERT INTO bno_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Imaw kali kag doseng apostoles: Si Simon nak ingtatawag rang Pedro, ");
INSERT INTO bno_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago ag kag ida manghor nak si Juan nak mga anak ni Zebedeo. Sinra ay gingtatawag rang Boanerges, nak kag gustong bisayahon ay “mga anak it pangrayugrog,” dahil sinra ay marali mahangit. ");
INSERT INTO bno_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kag iba ay sina Andres, Felipe, Bartolome, Mateo ag Tomas. Imaw ra si Santiago nak anak ni Alpeo, si Tadeo, si Simon nak makabayan, ");
INSERT INTO bno_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ag si Judas Iscariote nak tong huli ay imaw kag nagtraidor kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagkapili sa Ida mga apostoles, nagpauli sina Hesus sa inra gingdadayunan nak bayay ag nagtipon ray ruto kag maramong tawo, kada pay halos indiey sina Hesus makakaon. ");
INSERT INTO bno_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","It tong marunggan it Ida mga hali kag siling it mga tawo nak pay nagbubuangey si Hesus, dahil siguro kuno sa permi Sida nak nalilipasan it gutom, ay inra ingsapoy si Hesus agor piliton nak papaulion. ");
INSERT INTO bno_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sa oras nak kato, inggwa ra it nag-inabot nak mga Manunudlo it Kasuguan halin sa Herusalem, ag sinra ay napasiling, “Ingsasanibaney Sida ni Beelzebul nak pinuno it mga mayaot. Ngani, kag Ida gahom nak magpalayas it mga mayaot ay parayan yang kang Beelzebul!” ");
INSERT INTO bno_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pagkarungog ni Hesus sa inra mga bisaya, gingpapayungot Nida sinra ag nagsabat Sida sa inra sa parayan it mga istorya nak ingtatawag nak parabula: “Asi, apalayason aboy ni Satanas kag ida sariling sinakupan? ");
INSERT INTO bno_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kung kag usang gingharian nak kag mga sinakupan ay naglalaban-labanan, kali ay indi magrugay. ");
INSERT INTO bno_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ag imaw ra, masisira kag pamilya. ");
INSERT INTO bno_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ag kung si Satanas ra ay malaban sa ida sinakupang mayaot, ingkakalaban nida kag ida sarili, kada indiey magyawig kag ida gingharian. Kina ay siguradong mabagsak. ");
INSERT INTO bno_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Si Satanas ay tuyar sa usang makusog nak tawo, ag kung inggwa it gustong magsuyor sa ida bayay agor bay-on kag ida ari-arian, ay kinahangyan anay nak gapuson sida, ag pagkatapos, puyding bay-oney kag ida tanang mga gamit. ");
INSERT INTO bno_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Matuor kaling Ako ingsisiling sa inro. Apatawaron it Dios kag tanang nahimong kasal-anan ag tanang pagpasipala it tawo. ");
INSERT INTO bno_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero kag magbisaya it pasipala laban sa Ispirito Santo ay inding gador igpatawaron, dahil kag sala nak kali ay waya't kapatawaran hastang sa waya't katapusan.” ");
INSERT INTO bno_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Gingsiling kali ni Hesus sa inra dahil sa inra ingsiling nak, “Mayaot kag nagtitiner sa Ida!” ");
INSERT INTO bno_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Habang nagbibisaya pa si Hesus ay nag-abot kag Ida nanay ag mga hali. Gingpatawag ninra si Hesus ag naghuyat yang sinra sa liwas. ");
INSERT INTO bno_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Maramong tawo kag nakaingkor sa palibot Nida, ag inggwa't nagpayungot ag nagsiling, “Maestro, pasensya anay. Hagto sa liwas kag Imo nanay ag mga hali. Ginghahanap Ka ninra.” ");
INSERT INTO bno_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero nagsabat si Hesus, “Oho ngani! Pero sasin-o pa kag Ako ingkikilaya nak Ako nanay ag mga hali?” ");
INSERT INTO bno_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ag gingmuyatan Nida kag mga tawo nak nakaingkor sa palibot Nida, ag nagsiling, “Kali kag Ako nanay ag mga hali. ");
INSERT INTO bno_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dahil kag tanang nagsusunor sa kabubut-on it Dios ay imaw kag Ako ingkikilaya nak Ako mga hali ag Ako nanay.” ");
INSERT INTO bno_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Usang adlaw, nagtudlo ray si Hesus sa mga tawo sa habig it Ragat it Galileya. Ingragipunan Sida it karuramong tawo, kada nagsakay Sida sa usang rayapang nak asa piliw, ag ruto Sida nag-ingkor pramas magbisaya sa inra ruto sa takas. ");
INSERT INTO bno_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ag nagtudlo Sida it maramong bagay parayan sa mga istorya nak ingtatawag nak parabula. Sa Ida pagtudlo ay nagsiling Sida: ");
INSERT INTO bno_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Panimati kamo! Usang adlaw, inggwa't usang mangunguma nak nagliwas para magsabwag it binhi sa ida uma. ");
INSERT INTO bno_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sa ida pagsabwag, inggwa't ibang binhi nak nagtugpa sa rayan, ag inggwa't mga pispis nak nag-inabot ag ingpangtuktok kali. ");
INSERT INTO bno_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kag ibang binhi ay nagtugpa sa mabatong duta, ag dahil manipis yang kag raga ruto ay nagtinubo nak raan kag mga binhi. ");
INSERT INTO bno_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ugaling it katong nag-initey kag adlaw, kag mga bag-ong tubo nak tanom ay nagkupos ag nagpangyadong dahil waya nakaungot it maado kag gamot sa irayom it raga. ");
INSERT INTO bno_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kag ibang binhi ray ay nagtugpa sa duta nak inggwa it mga siiton nak hilamunon. Nagtinubo kali, ugaling nagpakagapa kaling mga hilamunon ag nayumos kag mga nagtubo nak binhi ruto. ");
INSERT INTO bno_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero kag ibang binhi ay nagtugpa sa maadong duta, ag kali ay nagtubo it maado ag nagpamunga, kada inggwa't natubas. Inggwa't mga binhi nak nagpanubas it katamtaman yang, inggwa ra't nagpanubas it rako, ag inggwa't nagpanubas it bugana.” ");
INSERT INTO bno_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Siling pa ni Hesus, “Kamong mga nagpapanimati ay isipa ninro it maado kag inro narunggan!” ");
INSERT INTO bno_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Marugay-rugay, pagkahalin it mga tawo ag sinra-sinra yangey pati si Hesus ag Ida doseng apostoles ag pilang iba nak Ida mga kaibahan, ay nagpangutana sinra kang Hesus kung ni-o kag gustong bisayahon it katong Ida mga ing-istorya. ");
INSERT INTO bno_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gingsabat sinra ni Hesus, “Kamo yang kag gingtaw-an it pribilehiyo nak maintyendihan kag mga dating tinago nak kaayaman tungor sa paghari it Dios. Pero kag karamuan ay waya gitaw-e, kada kag tanan nak inra narurunggan ay pay mga istorya yang. ");
INSERT INTO bno_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kada matutupar sa inra kag ingsiling ni Propeta Isaias it kato nak, “ ‘Aber magpakamuyat man sinra ay indi gihapon ninra mabaoy kung ni-o kag gustong bisayahon it inra nakikita, ag aber magpakapanimati man ay indi gihapon sinra makaintyendi. Ingtugot kali it Dios sabaling maghinuysoy sinra, ag patawaron Nida.’ ” ");
INSERT INTO bno_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pagkatapos, nagpangutana si Hesus sa inra: “Asi, waya baga gihapon ninro naintyendihe katong Ako ing-istorya tungor sa pagsabwag it binhi? Kung tuyar kina ay pauno ninro maiintyendihan kag iba pa Nako nak iistorya? ");
INSERT INTO bno_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Imaw kali kag gustong bisayahon it kato. Kag mga binhi nak gingsabwag it usang mangunguma ay gingpatuyar sa mensahe it Dios. ");
INSERT INTO bno_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kag natabo sa ibang binhi nak nagtugpa sa rayan ay ginpapatuyar sa mga tawong nakarungog it mga bisaya it Dios, ugaling pagkarungog ninra, waya narugay ay nag-abot si Satanas, ag ing-agaw nida sa inra isip kag inra mga narunggan. ");
INSERT INTO bno_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kag natabo sa ibang binhi nak nagtugpa sa mabatong duta ay gingpapatuyar ray sa mga nakarungog it mensahe it Dios nak masadyang ingbaton nak raan kina, ");
INSERT INTO bno_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ugaling buko marayom kag ruyot it kali sa inra tagipusuon. Kada waya pa ngani narugay, it katong nag-abot kag mga pagpurba o mga pagpahirap sa inra dahil sa pagsunor sa mensahe, ay sa nak raan kag inra pagtu-o ay nagyamig ag nawagit. ");
INSERT INTO bno_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ag kag natabo ray sa ibang binhi nak nagtugpa sa duta nak inggwa it mga siiton nak hilamunon ay gingpapatuyar sa mga nakarungog it mensahe it Dios, ");
INSERT INTO bno_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ugaling mas ing-una pa ninra kag pagpangalibog sa mga kalibutanhong mga butang, ag paghanap it manggar ag iba pang mga butang nak imaw kag mabulag sa inra, hastang mawar-an it lugar sa inra tagipusuon kag mensahe. Kada kag inra kabuhi ay waya it bunga halin sa inra narunggan. ");
INSERT INTO bno_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero kag natabo sa ibang binhi nak nagtugpa sa maadong duta ay gingpapatuyar sa mga nakarungog it mensahe it Dios ag ingbaton. Kada nagkainggwa kali it bunga sa inra kabuhi. Sinra ay tuyar sa duta kung hariin kag mga binhi ay nagpanubas it katamtaman yang, inggwa ra't nagpanubas it rako ag inggwa ra't nagpanubas it bugana.” ");
INSERT INTO bno_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nagpadayon pa si Hesus, “Waya't tawong nagbibitbit it iwag nak inggwa't suga agor ibutang yang kali sa irayom it gantangan o ataguon sa silong it katri, ag indi gibutang sa tamang butangan. ");
INSERT INTO bno_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Imaw ra tungor sa Ako mga ingbibisaya, waya it nakatago nak sa tamang oras ay indi giliwas. Ag imaw ra, waya't nakatagong kaayaman nak indi maintyendihan. ");
INSERT INTO bno_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kamong mga nagpapanimati ay isipa ninro it maado kag inro narunggan!” ");
INSERT INTO bno_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ag gingrugang pa Nida, “Intyendiha it maado kag inro narurunggan. Kung ni-o't rako kag inro ingtitinguha nak pang-intyendi ay imaw ra kag ita-o it Dios sa inro. Ag kina ay Ida apaamanan pa. ");
INSERT INTO bno_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kag tawo nak nagpapati sa ida narurunggan ay mas lalong marurugangan pa kag kaayam. Pero kag tawo nak waya gipapati, aber katong maisot nak pagkaintyendi raha sa ida ay abay-on pa.” ");
INSERT INTO bno_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nagpadayon pa si Hesus, “Kag paghari it Dios ay tuyar sa usang tawo nak nagsabwag it binhi sa ida uma. ");
INSERT INTO bno_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ag sa marayan nak mga adlaw ag gab-i sa ida pagtrabaho, sida ay padayon sa pagkatuyog ag pagbati. Ag kag mga binhing ida gingsabwag ay matubo ag maanam it inra yang nak buko nida ayam kung pauno kato matubo. ");
INSERT INTO bno_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kag binhi mismo nak ingsabwag rahang duta ay nagtubo yang it ida ag nagpamunga, una ay nagpisik anay ag nag-anam. Masunor ay maburos ag magiging uyasey. ");
INSERT INTO bno_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pagkahinog it uyas, kato ay agapasoney, dahil orasey para anihon.” ");
INSERT INTO bno_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nagsiling pa si Hesus, “Ni-o kag ato puyding akumparahan it paghari it Dios, o niong istorya kag ato agamiton sa ato pagpahadag it kali? ");
INSERT INTO bno_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kag paghari it Dios ay tuyar sa pagtubo it usang maisot nak busoy it mustasa nak ingtanom it usang tawo sa ida duta. Kaling busoy kag pinaka-maisot sa tanang klase it busoy it mga tanom dili sa ato. ");
INSERT INTO bno_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero kung kali ay ingtanomey, kali ay marako tuyar sa mababang puno ag mapakagapa. Kada marako kag mga sanga it kali hastang inghuhuman kali it mga pispis nak apunan ag raha ra sinra mapugar.” ");
INSERT INTO bno_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Parayan sa tuyar nak mga istorya kag Ida pagtudlo sa mga tawo tungor sa mga bisaya it Dios, kumporme sa inra kayang intyendihon. ");
INSERT INTO bno_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kung sa karamuan, kag Ida pagtudlo ay perming parayan sa mga istorya yang, pero kung sinra-sinra yangey it Ida mga manugsunor ay Ida ingpapahadag sa inra kag gustong bisayahon it kali. ");
INSERT INTO bno_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pagruyom-ruyom it katong adlaw nak kato, nagsiling si Hesus sa Ida mga disipulos, “Kitay, matabok kita sa ragat papagto sa yudo.” ");
INSERT INTO bno_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kada ginghalinan ninra kag karamuan ruto sa takas. Ag si Hesus ay wayaey ninra gipasayduha halin sa Ida ging-iingkuran nak rayapang, ag sinra ay naglargay. Inggwa ra sinra it kanunot nak ibang mga baruto. ");
INSERT INTO bno_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","It katong hagtoy sinra sa yawor, nagkusog it gulpi kag hangin, ag kag inra rayapang ay gingpapaka-lampusan it ragkong humbak, kada nagsuyor kag maramong tubi hastang kali ay halos mapupunoey. ");
INSERT INTO bno_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero si Hesus ay sige gihapon kag katuyog ruto sa pupa habang nakahilig sa uyunan. Kada gingpukaw Sida it Ida mga disipulos ag gingsiling, “Maestro, waya baga Ikaw nababayaka nak sabaling kita ay magyugrang?” ");
INSERT INTO bno_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nagbangon si Hesus ag Ida ingsaway kag hangin ag ingsilinggan kag ragat nak, “Timunongey ag kumalma!” Ngani, naghupa kag hangin ag nagkalma kag ragat. ");
INSERT INTO bno_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pagkatapos ay gingbisayahan Nida kag Ida mga manugsunor, “Asing nahadlok kamo? Asi, waya pang gador baga kamo it pagtu-o!” ");
INSERT INTO bno_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ag sinra ay napakahadlok, kada sinra ay naghininghingan, “Sin-o talaga Sida, nak pati kag hangin ag ragat ay nasunor sa Ida?” ");
INSERT INTO bno_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ngasing, nakatabokey sina Hesus sa ragat papagto sa lugar it mga Gerasanhon. ");
INSERT INTO bno_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagkasalta ninra, inggwa it usang kayake nak halin sa mga kuyba nak yuyubngan nak nagsapoy-sapoy sa Ida. Kaling tawo ay ingsasapian it mga mayaot ");
INSERT INTO bno_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ag nag-iistar ruto sa mga yuyubngan. Wayaey nak gador sa ida it makakagapos aber kadina pa. ");
INSERT INTO bno_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","It kato ay maramong besesey sida nak ginggapos it pay pusas nak human sa kahoy, ag kadina ra. Katong mga pusas ay ida pinanglampos hastang magkabika-biká, ag katong kadina ay ida pinangbugto-bugto. Wayang gador it tawong di kusog nak makapiga sa ida. ");
INSERT INTO bno_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Adlaw-gab-i, sida ay ruto sa mga kuyba nak yuyubngan ag sa mga kabagunturan nak nagpapaka-idagak ag nagpapaka-inukaw, ag ging-uugaran nida it mga bato kag ida sarili. ");
INSERT INTO bno_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pagkaantaw it kaling tawo kang Hesus, nagpakarayagan sida payungot, ag pag-abot sa Ida atubangan kali ay nagyuhor. ");
INSERT INTO bno_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nagpakaukaw sida it kakusog-kusog ag nagsiling, “Hesus, Ikaw nak Anak it Pinaka-mataas nak Dios, ni-o kag Imo labot sa ako? Alang-alang sa Dios, maluoy Ka sa ako ag aya ako gikastiguha!” ");
INSERT INTO bno_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Imaw kali kag ingsiling it kinang tawo, dahil kag sugo ni Hesus sa mayaot ay, “Mayaot, layas sa ida!” ");
INSERT INTO bno_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Masunor, ingpangutana sida ni Hesus, “Ni-o kag imo ngayan?” Nagsabat kag mayaot, “Kag ako ngayan ay Linibo, dahil karamo-ramo kami.” ");
INSERT INTO bno_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ag nagpakapakitluoy sida kang Hesus nak indi sinra gipahalinon rahang lugar. ");
INSERT INTO bno_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ruto sa mataas nak bukir ay inggwa it abang ramong baktin nak nagpapang-ibok. ");
INSERT INTO bno_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ag nagpakitluoy kang Hesus katong mga mayaot hina sa tawo, “Pasuyura yangey kami raha sa mga baktin.” ");
INSERT INTO bno_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ag ingsugtan ra sinra ni Hesus. Ngani, kag mga mayaot ay nagliniwas ruto sa tawo ag nagsinuyor sa mga baktin. Katong mga kabaktinan nak maabot sa mga ruhang libo ay naggulpi it ragyo diretsuhan papagto sa pangpang, kada nagkahuyog sinra sa ragat ag nagkayumos. ");
INSERT INTO bno_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pagkakita dili it mga manugbantay it kinang mga baktin ay nagrinayagan ra sinra ag gingpamalita sa banwa ag sa mga bukir kag tanang natabo. Dahil dili, nagpinagto kag mga tawo sa pangpang agor muyatan. ");
INSERT INTO bno_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pag-abot ninra ruto ay hagto pa sina Hesus, ag nakita it mga tawo katong tawo nak dating nasasaniban it mga mayaot nak nag-iingkorey ag nakabaroey. Ngani, kaling tawo nak dati ay nagbubuang, ngasing ay maadoy ka pag-iisip, kada nagkahadlok kinang mga tawo. ");
INSERT INTO bno_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Gingbalitaan sinra it katong ibang mga tawo ruto nak nakakita kung ni-o kag natabo ruto sa tawo nak dating nasasaniban it mga mayaot, ag imaw ra kag tungor sa mga baktin. ");
INSERT INTO bno_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dahil ruto, ingpakapilit it mga tawo nak pahalinon si Hesus sa inra lugar. ");
INSERT INTO bno_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","It katong pasakayoney si Hesus sa inra rayapang, nagpangabay sa Ida katong tawo nak dating nasasaniban it mga mayaot nak kung maaari ay Ida panunton sida. ");
INSERT INTO bno_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero waya sida gisugti ni Hesus ag nagsiling Sida nak, “Pauli yangey sa inro, ag silinggan kag imo mga kasimanwa kung ni-o't rako kag kaaduhan nak ginghimo sa imo it Gino-o, ag kung pauno ikaw gingkaluy-an Nida.” ");
INSERT INTO bno_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ag nagpauliey matuor sida, ag ida ra gingpamalita sa tanang mga lugar sa Decapolis kung niong gador kag kaaduhan nak ginghimo sa ida ni Hesus, ag kag tanang tawo ruto ay nagkatingaya. ");
INSERT INTO bno_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa pagtabok liwat nina Hesus sa ragat it Galileya, ag pagrunggo pa yang ninra sa baybay, ingragipunan nak raan si Hesus it abang ramong tawo. ");
INSERT INTO bno_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nagpagto ra ruto kag usang pinuno it Sinagoga nak kag ngayan ay si Jairo. Ag pagkakita nida kang Hesus, nagyuhor sida sa Ida atubangan ");
INSERT INTO bno_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nak nagpapakitluoy, “Naghihingayoey kag ako anak nak dalagita. Nunot ra anay sa amo ag ipatong kag Imo damot sa ida agor maulian ag mabuhi.” ");
INSERT INTO bno_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kada nagnunot ngani si Hesus sa ida. Ag nagsinunor ra kang Hesus kag karuramong tawo nak nagrurukrok sa Ida palibot. ");
INSERT INTO bno_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kaibahan sa inra kag usang kabade nak doseng tuigey nak gingrurugo. ");
INSERT INTO bno_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Katong kabade ay napakahirapaney sa iba't-ibang parayan it pagbuyong sa ida it maramong manugbuyong, ag naubosey ra rabuno kag tanang ida ari-arian, pero imbes nak maulian ay mas lalong nagmasyaro kag ida nababatyagan. ");
INSERT INTO bno_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","It kato ay narungganey nida kag balita tungor kang Hesus, kada ngasing ay sumagil-ot sida sa karamuan hastang makaabot sa likor ni Hesus. Ingsaplir nida kag baro ni Hesus, ");
INSERT INTO bno_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","dahil sa ida isip, “Kung masaplir yang nako kag Ida baro ay mauulianey ako.” ");
INSERT INTO bno_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ngani, pagkasaplir nida sa baro ni Hesus, nagtungon nak raan kag ida pagrugo ag nabatyagan nida nak sida ay naulianey. ");
INSERT INTO bno_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ag dahil nabatyagan ni Hesus nak inggwa't gahom nak naghalin sa Ida, sa nak raan ay sumauli Sida ag nagpangutana sa mga tawo, “Si-o sa inro kag nagsaplir it Ako baro?” ");
INSERT INTO bno_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nagsabat kag Ida mga manugsunor, “Maestro, nakikita ra Nimo nak nagsisiniog-siugan kag maramong tawo sa Imo palibot, pauno namo masasaduran kung sin-o kag nagsaplir it Imo baro?” ");
INSERT INTO bno_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero, nagpanglingat-lingat gihapon Sida sa paghanap kung si-o kag nagsaplir sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ag dahil ayam it katong kabade kag natabo sa ida, miskan sida'y nagpapanguyog sa kahadlok, nagpayungot sida kang Hesus ag nagyuhor sa Ida atubangan bag-o nag-uma it kaklaruhan. ");
INSERT INTO bno_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ag nagsiling si Hesus sa ida, “Ding, gingpaado ka dahil sa imo pagtu-o sa Ako. Pauliey it hanuyos, dahil naulianey nak gador ikaw.” ");
INSERT INTO bno_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Myentras nagbibisaya pa yang it kali si Hesus, ay inggwa't mga nag-abot halin sa bayay it katong pinuno it Sinagoga nak si Jairo. Nagsiling sinra, “Tang, kabay nak indi ikaw magulpihanan dili sa amo ibalita. Kag imo anak rabuno ay ingbaoyey it Dios. Badaey yangey giawata kinang Maestro.” ");
INSERT INTO bno_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Narunggan ni Hesus kaling inra ging-uma kang Jairo, pero ingbaliwaya Nida kali ag nagsiling kang Jairo, “Aya gikahadlok, magtu-o ka yang sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nagpagto gihapon si Hesus sa bayay ni Jairo, pero waya Sida't ibang gingnunot kundi si Pedro ag kag magmanghor yang nak sina Santiago ag Juan. ");
INSERT INTO bno_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pag-abot ninra sa bayay ni Jairo, nakita ninra kag maramong tawo nak nagkakagulo. Inggwa't mga nagtitinibaw ag inggwa ra't mga nagpapanambitan. ");
INSERT INTO bno_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagkasuyor ni Hesus, nagsiling Sida, “Asing nagkikinagulo ag nagtitinibaw kamo? Kinang anak ay buko minatay kundi nagkakatuyog yang sida.” ");
INSERT INTO bno_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero inggur-an yang Sida it mga tawo. Kada ingpaliwas Nida sinrang tanan, puyra yang sa mga maguyang it anak ag sa Ida mga kanunot nak manugsunor. Ag nagsuyor sinra sa kwarto kung hariin kag anak. ");
INSERT INTO bno_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gingsuuran sida ni Hesus ag inghuytan sa damot, bag-o nagsiling Sida nak, “Talita kumi!” nak kag gustong bisayahon ay, “Nene, ingsisiling Nako sa imo, bangoney!” ");
INSERT INTO bno_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ag sa nak raan nagbangon katong anak ag nagpanaw-panaw. Katong anak ay nag-iidad it dose anyos. Pagkakita rili it katong mga hagto sa kwarto ay pay mabuang sinra sa subrang katingaya. ");
INSERT INTO bno_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ag gingpakatugon nak gador sinra ni Hesus nak indi gipang-uma-uma aber kanin-o kag natabo. Pagkatapos, nagsiling Sida, “Hala sige, pakaunay sida.” ");
INSERT INTO bno_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pagkatapos, naghalin si Hesus ruto ag nagpauli sa Ida sariling banwa kung hariin Sida girako, kanunot kag Ida mga manugsunor. ");
INSERT INTO bno_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pag-abot it Adlaw it Inugpahuway ay nagpagto sinra sa sinagoga ag ruto Sida nagtudlo. Maramong mga tawo ruto, ag pagkarungog ninra it Ida mga ingtutudlo ay nagkatingaya sinra ag napasiling, “Hariin Sida gibaoy it Ida kaayam? Niong kaayam kaling Ida ingtutudlo? Pauno Sida nakakahuman it Ida mga milagro? ");
INSERT INTO bno_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Buko baga kali katong panray nak anak ni Maria, ag hali nina Santiago, Jose, Judas ag Simon? Ag di baga dili ra sa ato nag-iistar kag Ida mga hali nak kabade?” Ag waya nak gador ninra nakilaya Sida. ");
INSERT INTO bno_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pagkarungog it kali ni Hesus, nagbisaya Sida sa inra, “Kag usang propeta ay ingtatahor aber hariin, puyra yang sa Ida sariling banwa, sa tunga it Ida mga kahalihan ag sa Ida pamilya.” ");
INSERT INTO bno_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kada ngani waya Sida nakahuman it maramong milagro ruto puyra sa pilang tawo nak Ida ginghuytan ag gingpaado. ");
INSERT INTO bno_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ag natingayang gador Sida dahil waya sinra it pagtu-o sa Ida. Pagkatapos it kina inglibot nina Hesus kag ibang mga baryo ag nagtudlo. ");
INSERT INTO bno_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ag gingtawag Nida kag Ida doseng apostoles, ag sinra ay Ida ingpapanaw it tig-ruha-ruha, ag ingtaw-an Nida it karapatan ag gahom nak magpalayas it mga mayaot. ");
INSERT INTO bno_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Sa inra pagpanaw, sinra ay Ida gingtugon nak indi magraya it aber niong gamit, puyra yang sa inra bakulo. Indi ra kuno sinra magraya it bayon nak pagkaon, o magbitbit it binagtong, o magsuksok it kwarta sa inra panghagkos. ");
INSERT INTO bno_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Indi ra kuno ninra puyding dublihon kag inra suksok nak baro, pero puyde sinrang magsuksok it inra sandalyas. ");
INSERT INTO bno_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gingsiling pa sinra ni Hesus, “Pag abatunon kamo it usang tagbayay, ay ruto yangey kamo madayon sa inra bayay hastang maghalin kamo rutong lugar. ");
INSERT INTO bno_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kung indi gibatunon o girunggan kag inro ingtutudlo sa usang lugar, ay halin kamo raha. Pero sa inro paghalin ay paypage anay it taybo kag inro siki bilang pamatuor it inro paandam sa inra nak wayaey kamo it salabton sa inra kabuhi.” ");
INSERT INTO bno_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kada, nagpanaw sinra ag nagwali nak kag mga tawo ay dapat maghinuysoy sa inra mga kasal-anan. ");
INSERT INTO bno_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nagpalayas sinra it maramong mayaot sa mga tawo, ag kag ibang masakit ay ingbanlusan ra ninra it lana it olibo ag gingpaado. ");
INSERT INTO bno_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Waya narugay, narunggan ni Haring Herodes Antipas kag mga inghihimo ni Hesus, dahil Sida ay bantog. Inggwa't mga nagsiling, “Sida kuno ay si Juan nak Manugbawtismo nak nabanhaw, kada inggwa Sida it gahom pramas makahuman it milagro!” ");
INSERT INTO bno_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero kag iba ay nagsiling, “Sida ay si Propeta Elias!” Ag kag siling ray it iba ay, “Sida ay usang propeta nak tuyar sa mga propeta it katong una!” ");
INSERT INTO bno_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero kag siling ni Haring Herodes Antipas ay, “Ingpapugutaney nako si Juan nak Manugbawtismo! Nabanhaw baga sida?” ");
INSERT INTO bno_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nasiling nida kali dahil sa ida inghimo kang Juan it kato. Ida ingparakop si Juan, ingpagapos ag ingpapriso, dahil imaw kag gusto it ida asawa nak si Herodias. Kaling si Herodias kag dating asawa it maguyáng ni Herodes nak imaw si Felipe. Ag parehong ingbuyagan nina Herodes ag Herodias kag inra unang asawa agor sinrang ruha kag maasawa. ");
INSERT INTO bno_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Dahil dili, puat ingbibisayahan ni Juan si Herodes nak, “Bawal sa Kasuguan it Dios nak asawahon nimo kag asawa it imo maguyáng.” ");
INSERT INTO bno_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kada, nagpahimot si Herodias kang Juan, ag gustong gador nidang ipamatay kali. Ugaling, indi nida kali mahimo, ");
INSERT INTO bno_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","dahil si Juan ay ingtago ni Haring Herodes sa prisuhan. Inghimo nida kali dahil nahadlok sida kang Juan, kumo ayam nida nak kali ay maadong tawo ag balaan. Ag inggwa ra it oras nak gusto nidang magrungog sa ingwawali ni Juan, aber sida ay nakukunsensya sa mga bisaya nak ida narurunggan. ");
INSERT INTO bno_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero it katong huli, nagkainggwa't lugar si Herodias nak tumanon kag ida hanrom. Nag-abot kag kumpli-anyo ni Haring Herodes, ag nagkainggwa't rakong punsyon para sa mga opisyales, mga pinunong sundalo, ag mga dungganong tawo sa probinsya it Galileya. ");
INSERT INTO bno_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sa tunga it inra kasadyahan ay nagsuyor ag nagsadaw kag rayagang anak ni Herodias. Namut-an kali ni Haring Herodes ag ida mga bisita. Kada, napasiling si Haring Herodes sa rayaga, “Hagara kag aber niong imo magustuhan ag ako kali ita-o sa imo!” ");
INSERT INTO bno_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ag nagsumpa pa sida, “Aber ni-o kag imo hagaron ay ako ita-o, aber katunga pa it ako gingharian.” ");
INSERT INTO bno_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nagliwas anay kaling rayaga ag nagpangutana sa ida nanay, “Nay, ni-o kag ako ahagaron?” Sabat ni Herodias, “Kag uyo nganat ni Juan nak Manugbawtismo.” ");
INSERT INTO bno_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sa nak raan ay nagrayagan kaling rayaga pabalik sa Hari ag nagsiling, “Kag gusto nako nak ita-o nimo sa ako ngasing nak raan ay kag uyo ni Juan nak Manugbawtismo nak nakabutang sa bandihado.” ");
INSERT INTO bno_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dahil dili nasubo nak gador si Haring Herodes, pero dahil sa ida gingpromisa sa atubangan it ida mga bisita ay waya sida it gustong baliwayaon kag ida binisayahan sa rayaga. ");
INSERT INTO bno_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kada sa nak raan gingpapagto nida sa prisuhan kag usang sundalo ag ingsugo nak bay-on kag uyo ni Juan. Nagpagto katong sundalo sa prisuhan ag ingpugutan si Juan. ");
INSERT INTO bno_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Gingraya it kali kag uyo ni Juan nak nakabutang sa bandihado ag ingta-o sa rayaga. Pagkabaton nida, ingta-o ray nak raan nida kina sa ida nanay. ");
INSERT INTO bno_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","It katong nabalitaan kali it mga manugsunor ni Juan, gingpagtuan ninra ag ingbaoy kag ida yawas ag ingyubong sa usang pantyon. ");
INSERT INTO bno_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ngasing, nagbalikey kag mga apostoles ni Hesus sa Ida, ag nag-uma sinra it tanan nak inra nahimo ag naitudlo. ");
INSERT INTO bno_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ag nagsiling si Hesus sa inra, “Kitay, mapagto anay sa usang lugar nak medyo mayado-yado sa karamuan agor makapahuway kamo.” Ida kali gingsiling dahil waya gitutungon kag pag-inabot it mga tawo, ag halos ay nawawar-aney sinra it oras nak makapahuway o makakaon it maado. ");
INSERT INTO bno_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kada, nagsakay sinra sa rayapang patabok sa lugar nak waya't mga tawo. ");
INSERT INTO bno_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero nakita sinra it maramong tawo ag naayaman ninra kag inra rumbo, kada nagrali-rali sinra it baktas halin sa iba't-ibang mga banwa, ag kag iba ay nauna pa ruto kana Hesus. ");
INSERT INTO bno_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagrunggo nina Hesus sa habig it baybay, nakita ninra kag abang ramong tawo. Naluoy si Hesus sa inra, dahil sinra ay tuyar sa mga karnero nak waya it manugbantay. Ag sinra ay Ida ingtudluan it maramong mga bagay. ");
INSERT INTO bno_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tong pasugbuhoney kag adlaw, kag Ida mga disipulos ay nagpayungot sa Ida ag nagsiling, “Bukir pa man kali ag haponey. ");
INSERT INTO bno_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kada papagtu-a anay kinang mga tawo raha sa inggwa't mga bayay ag sa mga baryo nak asa palibot, pramas makabakay sinra it inra makakaon.” ");
INSERT INTO bno_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero nagsabat si Hesus sa inra, “Kamo it mapakaon sa inra.” Ag nagpangutana sinra, “Hariin ra namo abay-on kag kwartang ibakay it ipakaon sa inrang tanan? Kung mabakay kami it tinapay nak ipakaon sa inra ay halos tuyar sa wayong buyan nak kita it trabahador kag amo magagastos!” ");
INSERT INTO bno_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nagsiling ray si Hesus sa inra, “Pilang gador kag tinapay nak hina sa inro? Hala, 'toy ag usisa-a anay.” Pagkausisa ninra ay nagsiling sinra, “Inggwa yang dili sa atong tanan it limang bilog nak tinapay ag inggwa ra it ruhang bilog nak tinapahan nak isra.” ");
INSERT INTO bno_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Gingpaingkor sinrang tanan ni Hesus it punsok-punsok sa bag-ong tubo yang nak hilamunon. ");
INSERT INTO bno_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ngani, kag mga tawo ay nag-iningkor it punsok-punsok. Kag iba ay sanggatos, kag iba ay singkwenta. ");
INSERT INTO bno_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Gingbaoy ni Hesus kinang limang bilog nak tinapay ag ruhang bilog nak tinapahang isra. Nagtanga Sida sa langit ag nagpasalamat anay sa Dios. Pagkatapos ay Ida gingparti-parti kaling mga tinapay hastang kali ay nagramo ag ingta-o sa Ida mga disipulos agor sinra kag magpana-o sa tanang mga tawo. Ag imaw ra kag Ida inghuman sa ruhang bilog nak tinapahang isra. ");
INSERT INTO bno_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nagkinaon sinrang tanan ag nabusog. ");
INSERT INTO bno_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagkatapos, ingpangtipon it mga disipulos kag mga naturang tinapay ag tinapahan nak isra, ag nakapuno pa sinra it doseng tabig. ");
INSERT INTO bno_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kag ingbilang yang ninra ruto sa mga nagkaon ay mga kayake nak nag-abot it limang libo. ");
INSERT INTO bno_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagkakaon, ingpasakay nak raan ni Hesus kag Ida mga disipulos sa rayapang ag ingpauna sa tabok it ragat papagto sa banwa it Betsayda habang Ida ingpapauli kag mga tawo. ");
INSERT INTO bno_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pagkahalin it mga tawo, ausa Sidang nabilin ruto ag nagtukar Sida sa baguntor agor magpangamuyo. ");
INSERT INTO bno_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","It katong gumab-ey asa yaworey kag rayapang nak ingsasakyan it mga disipulos ni Hesus, ag Sida ay nabilin ruto sa takas nak ausa. ");
INSERT INTO bno_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nakita ni Hesus nak napapaka-hirapan sa paggaor kag Ida mga disipulos dahil sungsungon kag hangin. Mga bandang alas kwatro it aga, natyamparan sinra ni Hesus nak nagpapanaw sa ibabaw it tubi, ag pay alampasan tan-a sinra ni Hesus. ");
INSERT INTO bno_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero nakita Sida it Ida mga disipulos nak nagpapanaw sa ibabaw it tubi ag kabi ninra Sida ay murto, kada napaukaw sinra. ");
INSERT INTO bno_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tanan sinra ay nakakita sa Ida ag abang kahadlok ninra. Pero sa nak raan nagbisaya si Hesus sa inra, “Aya kamo gikahadlok! Ako kali! Kusuge kag inro buot!” ");
INSERT INTO bno_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Masunor, nagsakay Sida sa inra rayapang ag naggulpi it kalma kag hangin. Ag subra kag inra katingaya, ");
INSERT INTO bno_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","dahil waya pa gihapon ninra naisip kung sin-o talaga Sida aber it katong Ida mapakaon kag karuramong tawo it pilang bilog yang nak tinapay, dahil buko pa ninra kali kayang isipon. ");
INSERT INTO bno_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pagkatapos, nagtabok sinra sa ragat ag nagrunggo sa lugar it Genesaret ag inra ingsaog kag inra ingsakyan nak rayapang. ");
INSERT INTO bno_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagkasalta ninra, nakilaya nak raan si Hesus it mga taga-ruto, ");
INSERT INTO bno_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ag gingpamalitang raan sa tanang lugar palibot ruto kag pag-abot Nida. Ag naggayak sinra pramas ray-on kag inra mga masakit, aber katong mga asa rudan, aber hariin man sinrang lugar nak inra narunggan nak hagto si Hesus. ");
INSERT INTO bno_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ngani, aber hariin Sida magpagto, sa mga banwa, baryo o bukir man, ay ingraraya it mga tawo kag inra mga di sakit sa inra mga plasa. Nagpapakitluoy sinra sa Ida nak aber pahuytan yang kag gadar it Ida baro agor sinra ay mag-ado. Ag kag tanang mga tawo nak nakahudot rili ay talagang nag-ado. ");
INSERT INTO bno_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Usang adlaw, inggwa it mga Pariseo ag mga Manunudlo it Kasuguan halin sa Herusalem nak nagpayungot kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ag nakita ninra nak kag Ida mga manugsunor ay nagkakaon nak waya anay gipapanghinaw ag kali ay buko kumporme sa inra gingtutudlo. ");
INSERT INTO bno_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Dahil kag mga Pariseo ag tanang mga lahi it Hudyo ay indi magkaon hastang waya sinra nakakapanghinaw it damot, kumporme sa sulunranon nak namat-an it inra mga maguyang. ");
INSERT INTO bno_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ag kung sinra ay halin sa merkado, indi anay sinra magkaon hastang waya pa sinra nakakalimpyo it inra yawas agor mawagit kag mga mabuling o mga kasal-anan nak nagtapon sa inra halin sa ibang mga tawo ruto sa merkado. Ag maramo pa kag inra mga gingsusunor tuyar sa paghugas it mga tasa, pitsil, ag kalderong bronse, imaw ra kag pagpunas anay sa inra mga pasanrigan sa pagkaon, bag-o kali gamiton.) ");
INSERT INTO bno_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kada, nagpangutana kaling mga Pariseo ag mga Manunudlo kang Hesus, “Asing waya gisusunor kaling Imo mga manugsunor sa mga sulunranon nak namat-an it ato mga maguyang, ag nagkakaon yang sinra it waya gipapanghinaw it damot?” ");
INSERT INTO bno_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Gingsabat sinra ni Hesus: “Tamang gador kag ingsiling it Dios parayan kang Propeta Isaias tungor sa inro nak mga pakitang tawo yang! Dahil kali kag nakasuyat sa Sagradong Kasuyatan. “ ‘Ingtatahor yang Ako it kaling mga tawo sa inra yuba, pero kag inra tagipusuon ay mayado sa Ako. ");
INSERT INTO bno_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Waya it puyos kag inra pagdayaw sa Ako, dahil kag inra ingtutudlo ay mga kasuguan yang it tawo, pero inra ingsisiling nak kina ay mga Kasuguan kuno Nako.’ ");
INSERT INTO bno_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Gingbabaliwaya ninro kag Kasuguan it Dios ag imaw ninro it gingpapalabi kag pagsunor sa mga sulunranon it mga tawo.” ");
INSERT INTO bno_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nagpadayon pa Sida sa pagsiling, “Talagang kamo ay maayo maghuman it mga parayan pramas mabaliwaya kag Kasuguan it Dios, agor kag asunron ay kag inro mga sulunranon! ");
INSERT INTO bno_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Di baga, nagsiling si Moises, ‘Tahura kag imo tatay ag nanay,’ ag ‘Si-o man kag magsumpa sa ida tatay ag nanay ay dapat mamatay.’ ");
INSERT INTO bno_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero sa inro pagtudlo, kag usang tawo ay puyding magsiling sa ida mga maguyang nak, ‘Ibulig tan-a kali nako sa inro, ugaling “Kurban” kali, nak kag gustong bisayahon ay inghalarey kali nako sa Dios,’ kada bukoey sida obligado nak sustentuhan pa kag ida mga maguyang. ");
INSERT INTO bno_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Dahil dili sa inro ingtutudlo ay ingbabay-an ninro it lugar nak makabulig kag mga anak sa inra mga maguyang. ");
INSERT INTO bno_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ingbabaliwaya ra ninro kag mga bisaya it Dios ag ingtutuman yang kag inro mga sulunranon. Ag buko yang kali kag inro ginghuhuman kundi maramo pang iba.” ");
INSERT INTO bno_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Gingpayungot liwat ni Hesus kag mga tawo sa Ida ag ingsilinggan nak, “Panimati-i kaling ibisaya Nako sa inro ag intyendihon it maado. ");
INSERT INTO bno_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Waya it bagay nak nagsusuyor sa yawas it tawo pramas sida ay maging mabuling sa pagmuyat it Dios kundi katong nagliliwas. ");
INSERT INTO bno_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kung gusto ninro nak makaintyendi ay panimati it maado.” ");
INSERT INTO bno_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagkatapos, ingbadaan ni Hesus kag mga tawo ag kaibahan kag Ida mga manugsunor ay nagsuyor sinra sa bayay nak inra ingdadayunan. Ag ruto ay gingpangutana Sida it Ida mga manugsunor tungor sa Ida ingbisaya. ");
INSERT INTO bno_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Siling Nida sa inra, “Asi pati ra kamo ay waya pa nakaintyendi! Waya pa baga ninro naiintyendihe nak aber ni-o kag nagsusuyor sa yuba it tawo ay indi makapabuling sa ida, ");
INSERT INTO bno_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","dahil kali ay nagdidiretso sa bituka buko sa tagipusuon, ag kali ay inaliwas?” Sa pagbisaya Nida it kali ay Ida gingsisiling nak tanang pagkaon ay malimpyo ag puyding kaunon. ");
INSERT INTO bno_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Padayon pa Nida nak ingsiling, “Ngani, kag kayainan nak nagliliwas sa tagipusuon it tawo ay imaw kag nagpapabuling sa ida. ");
INSERT INTO bno_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dahil naghahalin sa tagipusuon kag mga hanrom nak mayain tuyar sa pag-ubay sa buko ida sariling asawa, pagpanakaw, pagpangmatay, pagpangawatan, ");
INSERT INTO bno_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kahakugan, kayainan, pangluko, malaw-ay nak hanrom, pagkahili, pagpasipala, kahambugan, ag kuyang kag pag-iisip sa paghimo it tama. ");
INSERT INTO bno_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kaling tanan nak mayaing mga bagay nak naghahalin sa tagipusuon it tawo ay imaw kag nagpapabuling sa tawo.” ");
INSERT INTO bno_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pagkatapos, naghalin ruto si Hesus ag nagpagto sa mga lugar palibot sa banwa it Tiro. Ruto nagdayon Sida sa usang bayay ag waya tan-a Sida it gusto nak maayaman it mga tawo nak hagto Sida, ugaling ay indi nak gador kali matago sa inra. ");
INSERT INTO bno_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ruto ay inggwa't nag-iistar nak usang kabade nak kag anak nak kabade ay nasasaniban it mayaot. Nagpayungot kaling nanay kang Hesus ag nagyuhor sa Ida atubangan. ");
INSERT INTO bno_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kaling nanay ay buko Hudyo, kundi usang Griyego nak taga-Siropenisya. Sida ay nagpakitluoy gihapon kang Hesus nak palayason kag mayaot sa ida anak. ");
INSERT INTO bno_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ugaling gingsabat sida ni Hesus, “Abusgon anay kag mga anak, dahil buko tama nak bay-on kag pagkaon sa mga anak ag ibahog sa mga iro.” ");
INSERT INTO bno_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero nagsabat kaling nanay, “Oho ngani, Gino-o, pero miskin kag mga iro nak nagbabantay sa irayom it lamesa ay nagkakaon ra it mga mumog nak nahuhuyog it mga anak.” ");
INSERT INTO bno_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kada, nagsabat si Hesus sa ida, “Dahil sa imo sabat nak kina, makakapauliey ka it hanuyos. Katong mayaot ay naglayasey sa imo anak.” ");
INSERT INTO bno_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nagpauliey matuor katong nanay ag nakita nida nak kag ida anak ay maadoy kag pagpahuway, ag kag mayaot ay wayaey sa ida. ");
INSERT INTO bno_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pagkatabo rili naghalin si Hesus sa lugar it Tiro. Nagdiretso anay Sida sa banwa it Sidon ag bag-o Sida bumalik sa habig it Ragat it Galileya ay naglikaw anay Sida papagto sa lugar it Decapolis (o Sampuyong Syudad). ");
INSERT INTO bno_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Gingraya sa Ida ruto it mga tawo kag usang tawo nak bungoy ag apa. Nagpakitluoy sinra kang Hesus nak ipatong kag Ida damot dili sa tawo agor sida ay mag-ado. ");
INSERT INTO bno_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Gingraya sida ni Hesus sa uunhan nak mayado sa mga tawo. Ingsuksok anay Nida kag Ida mga tudlo sa buho it magkanyudong talinga it kaling tawo. Masunor ay gingruy-an Nida kag Ida damot ag gingsaplir kag rila it kaling tawo, ");
INSERT INTO bno_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","bag-o nagtanga Sida sa langit ag naghingab it marayom. Pagkatapos, nagsiling Sida sa tawo, “Epata.” Kag gustong bisayahon it kali ay “Maabrihan ka.” ");
INSERT INTO bno_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sa nak raan naabrihan kag ida talinga ag sida'y nakarungog ag pay nagyuga kag ida rila, ag nakabisaya sida it tadlong. ");
INSERT INTO bno_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Gingpakatugon ni Hesus kag mga tawo nak nagsinunor gihapon sa inra nak inding gador mag-uma aber kanin-o it tungor rili sa Ida inghimo. Pero aber ni-o Nida it piga ay lalo pa ngani sinra nak nagpang-uma-uma. ");
INSERT INTO bno_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ag kag mga tawo nak nakarungog ay abang katingaya ag nagsiling, “Aba, abang ado kag Ida inghuman no! Napapaado Nida kag bungoy ag kag apa.” ");
INSERT INTO bno_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","It katong panahon nak kato ra, nagtipon ray kag maramong tawo agor magpanimati kang Hesus. Ag tong naubusan sinra it pagkaon ay ing-ayaba Nida kag Ida mga disipulos ag nagsiling, ");
INSERT INTO bno_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Naluluoy Ako riling mga tawo. Tatlong adlawey nato sinrang kanunot ag wayaey sinra it akaunon. ");
INSERT INTO bno_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Waya Ako it gustong pahalinon sinrang gutom sabaling malupyo sinra sa rayan, ag mayado pa man kag ginghalinan it iba sa inra.” ");
INSERT INTO bno_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nagsabat kag Ida mga disipulos, “Riin kita mabaoy it ipakaon sa tuyar it ramong tawo rili sa lugar nak waya it kabayay-bayay?” ");
INSERT INTO bno_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nagpangutana si Hesus, “Pilang bilog kag tinapay ninro raha?” Sabat ninra, “Pito.” ");
INSERT INTO bno_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Masunor, ingpaingkor anay ni Hesus kag mga tawo, ag ingbaoy Nida katong pitong bilog nak tinapay. Nagpasalamat anay Sida sa Dios, ag ingparti-parti Nida kali hastang nagramo bag-o ingta-o sa Ida mga disipulos, ag sinra ray kag nagpana-o sa mga tawo. ");
INSERT INTO bno_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Inggwa ra sinra it pilang bilog nak tinapahang isra nak maintik, ag pagka-pasalamat ray ni Hesus sa Dios, Ida gingsugo sa mga disipulos nak kali ay inra ra ipana-o sa mga tawo. ");
INSERT INTO bno_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nagkinaon sinrang tanan ag nabusog. Pagkatapos, ingpangtipon it mga disipulos kag mga natura ag nakapuno pa sinra it pitong marakong tabig. ");
INSERT INTO bno_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kag ingbilang yang ninra ruto sa mga nagkaon ay nag-abot it subrang ap-at nak libo. Pagkatapos, ingpapauliey ni Hesus kinang mga tawo. ");
INSERT INTO bno_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bag-o nagsakay Sida sa rayapang kaibahan kag Ida mga disipulos papagto sa lugar it Dalmanuta. ");
INSERT INTO bno_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pag-abot ninra ruto, inggwa't mga Pariseo nak nagpayungot kang Hesus ag ingkumpronta Sida. Gusto ninrang purbahan kung talagang Sida ay ingparaya it Dios, kada naghagar sinra it usang milagro halin sa langit bilang pamatuor. ");
INSERT INTO bno_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Napahingab si Hesus it marayom ag nagsiling, “Asi arang kag mga tawo sa ngasing nak panahon ay perming naghahanap yang it mga milagro? Matuor kaling Ako ingsisiling sa inro. Indi nak gador Ako magpakita sa inra it milagro!” ");
INSERT INTO bno_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pagkasiling ni Hesus it kali, binadaan Nida sinra ag nagsakay ray sinra it Ida mga manugsunor sa rayapang ag nagtabok papagto sa ibang baybay. ");
INSERT INTO bno_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Habang nakasakay sinra patabok it ragat, namalayan it mga manugsunor nak waya yaki sinra it rayang bayon nak pagkaon, puyra yang sa usang bilog nak tinapay. ");
INSERT INTO bno_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ag nagsiling si Hesus sa inra, “Mag-andam kamo sa pangpaalsa it mga Pariseo ag ni Haring Herodes.” ");
INSERT INTO bno_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pagkarungog kali it mga manugsunor, nag-istoryahan sinra. Siling ninra, “Waya abi kita it bayon nak tinapay e.” ");
INSERT INTO bno_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ayam ni Hesus kag inra ing-iistorya, kada ingpangutana Nida sinra, “Asing ingkakalibgan ninro kung waya man kamo it bayon nak tinapay? Waya pa baga gihapon kamo nakakaintyendi? Talaga baga nak matugasey kag inro mga tagipusuon? ");
INSERT INTO bno_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Inggwa nak gador kamo it mga mata, indi baga kamo makakita? Inggwa ra kamo it mga talinga, indi baga kamo makarungog? Waya baga ninro natatanra-e kag Ako ginghimo? ");
INSERT INTO bno_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","It katong Ako ingparti-parti kag limang bilog yang nak tinapay hastang kina ay nagramo ag gingpakaon sa subrang limang libong tawo, pilang tabig kag tura nak inro natipon?” Sabat ninra, “Dose.” ");
INSERT INTO bno_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ay it katong ingpakaon Nako kag subrang ap-at nak libong tawo it ingparti-parti nak pitong bilog yang nak tinapay hastang kina ra ay nagramo, pilang marakong tabig kag tura nak inro natipon?” Sabat ray ninra, “Pito.” ");
INSERT INTO bno_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ag siling Nida sa inra, “Hay waya pa gihapon ninro naiintyendihe!” ");
INSERT INTO bno_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ngasing, nagrunggoey sinra mayungot sa banwa it Betsayda. Ruto ay inggwa't mga tawo nak nagraya kang Hesus it usang kayaking bulag, ag nagpakitluoy sinra sa Ida nak Ida kali huytan agor mag-ado. ");
INSERT INTO bno_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ging-agkay anay Nida kaling bulag paliwas sa baryo. Ruto ay Ida ingruy-an kag mga mata it kaling bulag bag-o inghuytan kag mga mata it kali ag ingpangutana, “Inggwa'y ka't nakikita?” ");
INSERT INTO bno_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nagmuyat kag bulag it diretso ag nagsiling, “Inggway ako't nakikita nak mga tawo, ugaling sinra ay pay mga kahoy nak nagpapanaw.” ");
INSERT INTO bno_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ginghuytan liwat ni Hesus kag mga mata it kaling bulag. Nagtarok kali ag nakakita sida it maado dahil nagbalikey kag ida dating pagmuyat. ");
INSERT INTO bno_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pagkatapos, ingpapauliey sida ni Hesus, pero ingtugon sida, “Ayaey girayan sa baryo.” ");
INSERT INTO bno_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pagkatapos, nagpadayon si Hesus ag kag Ida mga manugsunor sa inra pagpanaw papagto sa mga baryo sa palibot it Cesareya Pilipos. It kag sinra ay nagpapanaw, pinangutana sinra ni Hesus, “Sin-o kuno Ako siling it mga tawo?” ");
INSERT INTO bno_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ag nagsabat sinra, “Kag siling it iba, Ikaw kuno si Juan nak Manugbawtismo. Siling ray it iba, Ikaw kuno ay si Propeta Elias. Ag inggwa ra it nagsisiling nak, Ikaw kuno ay usa sa ibang mga propeta it kato.” ");
INSERT INTO bno_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nagpangutana ray si Hesus sa inra, “Pero kamo, sin-o Ako para sa inro?” Kag nagsabat ay si Pedro, “Ikaw kag gingpromisang Kristo.” ");
INSERT INTO bno_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pagkarungog it kali ni Hesus, ingtugon Nida sinra nak inding gador giuma kali aber kanin-o. ");
INSERT INTO bno_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ag nagtunaey si Hesus it pagpahadag sa Ida mga manugsunor nak Sida, nak dati pa ay ingtatawagey nak Anak it Tawo, ay kinahangyan nak magtiis it maramong hirap ag isikway it mga pinuno it mga Hudyo, mga Punong Saserdote ag mga Manunudlo it Kasuguan. Siling pa Nida, Sida ay amatyon, pero sa pangtatlong adlaw, Sida ay mababanhaw. ");
INSERT INTO bno_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mahadag kag Ida pagbisaya it kali sa inra. Ag dahil dili, ingraya anay Sida ni Pedro sa habig-habig ag gingsaway, dahil abi nida ay nagpapangasa si Hesus. ");
INSERT INTO bno_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero ingtalikran Nida si Pedro ag habang nagmumuyat Sida sa Ida mga manugsunor ay ingsaway ray Nida si Pedro ag nagsiling, “Payado sa Ako, Satanas! Kag imo ging-iisip ay buko para sa Dios kundi para sa tawo.” ");
INSERT INTO bno_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ag ingpapayungot ni Hesus kag mga tawo kaumir kag Ida mga manugsunor, ag nagsiling sa inra: “Sin-o man sa inro kag gustong magsunor sa Ako ay dapat limtan kag ida sariling kagustuhan, ag pas-anon kag ida krus, nak kag gustong bisayahon ay hanraey sidang magtiis it hirap hastang sa kamatayon, alang-alang sa ida pagsunor sa Ako. ");
INSERT INTO bno_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kag tawong nagsasalig yang sa ida sarili ay imaw kag mawawar-an it kabuhi nak waya't katapusan. Pero kag tawo nak ingbabaliwaya kag ida sarili para yang magsunor sa Ako, ag para sa pagpalapnag it Maadong Balita, ay imaw kag magkakainggwa it kabuhi nak waya't katapusan. ");
INSERT INTO bno_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dahil ni-o kag mapapakamos it usang tawo aber mapasa-ida man kag bug-os nak kalibutan, kung mawawagit ra kag ida kabuhi? ");
INSERT INTO bno_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mababayduhan baga it aber niong butang it tawo kag ida kabuhi? Syempre indi! ");
INSERT INTO bno_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sa ngasing nak panahon kag mga tawo ay subrang yainey ag buko matutom sa Dios! Ag aber sin-o man kag mahuda nak magsiling nak sida ay nagsusunor sa Ako ag sa Ako mga bisaya, ay Ako ra sida ikahuda sa Ako pagbalik, Ako nak dati pa ay ingtatawagey nak Anak it Tawo, raya kag kahimayaan it Ako Tatay sa langit kaibahan kag mga balaan nak anghel.” ");
INSERT INTO bno_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ag nagpadayon Sida sa pagsiling, “Matuor kaling Ako ingsisiling sa inro. Inggwa it ibang nagtitinrog dili nak indi makaagom it kamatayon, hastang waya ninra nakikita kag gamhanang paghari it Dios.” ");
INSERT INTO bno_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagkalipas it an-om nak adlaw, gingnunot ni Hesus sina Pedro, Santiago ag Juan patukar ruto sa usang mataas nak baguntor nak sinra-sinra yangey. Sa inra pagtukar, si Hesus ay nauuna sa inra ag kaling tatlo ay nagsusunor sa Ida. It katong hagtoy sinra nakita ninra nak nagyabot kag hitsura ni Hesus sa inra atubangan. ");
INSERT INTO bno_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pati kag Ida baro ay nagputi it kasusilaw, ag kag puti it kali ay mas subra pa sa pinaka-maadong pangkula. ");
INSERT INTO bno_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ag it yang pakita sina Propeta Elias kaibahan ni Moises, ag sinra ay nagpakig-istorya kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kada, napasiling si Pedro kang Hesus, “Maestro, maado nak hali kami! Matukor kami it tatlong pasilungan no? Usa para sa Imo, usa para kang Moises ag usa para kang Elias.” ");
INSERT INTO bno_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Imaw kag ida nasiling dahil buko nida ayam kung ni-o kag ida ibisaya, dahil sa kahadlok ninra. ");
INSERT INTO bno_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ag imaw katong nayampuyan sinra it rampog, ag halin raha ay inggwa it Boses nak nagsiling, “Imaw kali kag Ako Pinalanggang Anak. Panimati kamo sa Ida!” ");
INSERT INTO bno_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pagkawagit it kinang rampog, nagpanglingat-lingat sinra, ugaling wayaey sinra it ibang nakita ruto kundi si Hesus yangey. ");
INSERT INTO bno_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ag habang nag-uus-os sinra halin sa baguntor, ingtugon sinra ni Hesus nak, “Aya gipang-uma-umaan aber kanin-o kag inro nakita, hastang waya pa nababanhaw Ako nak dati pa ay ingtatawagey nak Anak it Tawo.” ");
INSERT INTO bno_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kada ngani naghipos yang sinra, pero nagpinangutan-an sinra sa usa'g-usa kung ni-o kaling Ida gingsisiling nak mababanhaw Sida. ");
INSERT INTO bno_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Masunor, ingpangutana ninra si Hesus nak, “Asing nagsisiling kag mga Manunudlo it Kasuguan nak dapat magpaali anay si Propeta Elias?” ");
INSERT INTO bno_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nagsabat si Hesus, “Matuor, dapat magpaali anay si Elias para maghanra it tanang butang. Ag di baga inra gingsuyat ra nak Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay dapat magtiis it maramong hirap ag pagsikway? ");
INSERT INTO bno_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero kag Ako masisiling sa inro ay nakapaley si Elias ag inra ingpahirapan sida kumporme sa inra gusto, suno sa nakasuyat nak matatabo sa ida.” ");
INSERT INTO bno_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pagbalik ni Hesus ag Ida tatlong disipulos sa ibang nabilin nak mga manugsunor sa ubos it baguntor, nakita ninra nak abang ramong tawo kag nakapalibot sa inra. Inggwa ra ruto it mga Manunudlo it Kasuguan ag mga manugsunor ni Hesus nak nagsusuay-suayan. ");
INSERT INTO bno_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Abang katingaya it mga tawo pagkakita kang Hesus, ag sa nak raan ay nagrayagan sinra ag masadya nak nagsapoy-sapoy sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ag nagpangutana Sida sa inra, “Ni-o kag inro ingsusuayan?” ");
INSERT INTO bno_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ag ruto sa karamuang mga tawo ay inggwa it usa nak nagbisaya sa Ida, “Maestro, gingraya nako sa Imo kag ako anak nak binatilyo nak naudom, dahil sida ay ingsasaniban it mayaot. ");
INSERT INTO bno_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ag bawat ing-aabot sida ay inabuyagsak sida it kali. Nagsusubo kag ida yuba, nagpapagot kag ida mga ngisi, ag napanugas sida. Nagpapangabay ako sa Imo mga disipulos nak palayason kaling mayaot, pero indi ninra kayang himuon kali.” ");
INSERT INTO bno_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nagsabat si Hesus, “A! Kamong mga tawo sa ngasing nak panahon ay mga waya't pagtu-o! Hastang sauno pa Nako kamo dapat nak ibhan ag tis-an? Hala! Maley, ray-a kinang imo anak dili sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ag ingraya ngani ninra kinang anak sa Ida. Pagkakita it mayaot kang Hesus, sa nak raan gingpasalikar katong anak ag kali ay nagtumba ag nagkisay-kisay sa raga habang nagsusubo kag yuba. ");
INSERT INTO bno_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nagpangutana ngasing si Hesus sa tatay it kaling anak, “Kag-uno pa sida gitutuyar it kali?” Sabat it tatay, “Tuna it katong maisot pa sida. ");
INSERT INTO bno_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Maramong besesey nak sida ay ingbubuyagsak it kali sa kayado ag sa tubi agor matyon. Maluoy Ka sa amo, ag kung puyde, buligi kami.” ");
INSERT INTO bno_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Siling ni Hesus sa ida, “Asing masiling ka nak, kung puyde! Tanan ay mahihimo sa usang nagtutu-o.” ");
INSERT INTO bno_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sa nak raan napaukaw kinang tatay ag nagsiling, “Nagtutu-o ako. Buligi pa ako nak mahusto kag ako pagtu-o sa Imo!” ");
INSERT INTO bno_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pagkakita ni Hesus nak maragipon kag mga tawo sa inra ay Ida ingsaway kinang mayaot nak nagsanib sa anak, “Ikaw mayaot nak nagpapangbungoy ag nagpapang-udom, layas hina sa ida ag badaey nak gador gibalik!” ");
INSERT INTO bno_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pakaidagak nak gador kinang mayaot nak asa anak ag pakakisay-kisay it tudo kali, bag-o naghaliney sa anak. Ag kinang anak ay pay minatayey gimuyatan, kada napasiling kag karamuang tawo, “Minatayey sida!” ");
INSERT INTO bno_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero inghuytan ni Hesus sa damot kinang anak ag ingbangon. Ag nakatinrog ngani kinang anak. ");
INSERT INTO bno_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pagkatapos, nagsuyor sina Hesus sa bayay nak inra ingdadayunan, ag it katong sinra yangey ay nagpangutana sa Ida kag Ida mga disipulos, “Asing waya namo napalayas katong mayaot?” ");
INSERT INTO bno_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Gingsabat sinra ni Hesus, “Katong klase it mayaot ay inding gador mapalayas, kundi parayan yang sa pagpangamuyo.” ");
INSERT INTO bno_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Naghalin sina Hesus ruto ag nagrayan sa iba't-ibang lugar sa probinsya it Galileya. Ugaling waya Sida it gusto nak masaduran it mga tawo, ");
INSERT INTO bno_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dahil ngasing ay Iday gingtutudluan kag Ida mga manugsunor sa pagsiling, “Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay atraiduron ag ita-o sa damot it mga mahusgar sa Ako. Amatyon ninra Ako, pero sa pangtatlong adlaw Ako ay mababanhaw.” ");
INSERT INTO bno_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Waya ninra kali naintyendihe, pero natahap sinrang magpangutana sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nagpadayon sina Hesus ag nakaabot sa syudad it Capernaum. Pagkasuyor ninra sa bayay nak inra ingdadayunan ay nagpangutana Sida sa Ida mga manugsunor, “Ni-o katong inro gingsusuayan sa rayan?” ");
INSERT INTO bno_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero naghipos yang sinra, dahil habang sinra ay nagbabaktas pa, sinra ay nagsusuay kung sin-o sa inra kag pinaka-yabaw sa tanan. ");
INSERT INTO bno_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ngasing, nag-ingkor si Hesus ag Ida ging-ayaba kag doseng disipulos ag nagsiling sa inra, “Kung inggwa sa inro it gustong magpamuno, ay dapat sidang mapainubuson ag magserbisyo sa tanan.” ");
INSERT INTO bno_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ag raha ra ay inggwa it usang anak ag kali ay Ida inghuytan ag ingpapayungot sa inra tunga, bag-o Ida ingkupkupan ag nagsiling sa inra, ");
INSERT INTO bno_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aber si-o man kag nagbabaton sa usang mapainubusong tawo nak nagsusunor sa Ako, tuyar diling anak, ay nagbabaton ra sa Ako. Ag aber si-o man kag nagbabaton sa Ako ay buko Ako yang kag ida gingbabaton, kundi kag Dios nak nagparaya sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pagkatapos, nagsiling si Juan kang Hesus, “Maestro, nakakita kami it usang tawo nak nagpapalayas it mga mayaot sa paggamit it Imo pangayan ag ingsaway namo sida, dahil buko namo sida kaibahan.” ");
INSERT INTO bno_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero nagsabat si Hesus: “Pabad-e yang ninro sida, dahil waya't naghuhuman it milagro parayan sa Ako ngayan ag pagkatapos ay amayainon ray Ako. ");
INSERT INTO bno_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Dahil sida nak buko ato kalaban ay kakampi nato. ");
INSERT INTO bno_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Matuor kaling Ako ingsisiling sa inro. Si-o man kag mapainom it aber usang basong tubi sa inro, dahil kamo ay nagsusunor sa Ako nak imaw kag Kristo, ay siguradong mabaton it premyo katong nagpainom sa inro.” ");
INSERT INTO bno_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Aber sin-o man kag maging dahilan it pagkasala it usang mapainubusong tawo tuyar riling mga anak nak nagtutu-o sa Ako, ay mas maado pang maghigot yangey sida sa liog it marakong bato nak panggiling ag ipilak sa ragat. ");
INSERT INTO bno_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ag kung kag imo damot yang ra kag magiging dahilan it imo pagpakasala ay maado pa nak utuyon yangey kina. Mas maado pa sa imo nak makaagom it kabuhi nak waya't katapusan nak utoy kag damot, kisa ruha ngani, kung ipilak yang ra ikaw sa impyerno kung hariin indi mapayong-payong nak kayado.” ");
INSERT INTO bno_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","“Hagto ra ay inggwa it mga apihis nak indi mamatay ag kayado nak indi mapayong-payong.” ");
INSERT INTO bno_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Ag kung kag imo siki yang ra kag magiging dahilan it imo pagpakasala ay maado pa nak utuyon yangey kina. Mas maado pa sa imo nak makaagom it kabuhi nak waya't katapusan nak utoy it siki, kisa ruha ngani, kung ipilak yang ra ikaw sa impyerno.” ");
INSERT INTO bno_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","“Hagto ra ay inggwa it mga apihis nak indi mamatay ag kayado nak indi mapayong-payong.” ");
INSERT INTO bno_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Imaw ra, kung kag imo mata kag magiging dahilan it imo pagpakasala, yukata yangey kina. Mas maado pang makasuyor sa gingharian it Dios sa langit nak ausa it mata, kisa ruha ngani, kung ipilak yang ra ikaw sa impyerno, ");
INSERT INTO bno_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kung hariin ay “ ‘waya it pagkamatay kag mga apihis ag kag kayado ay waya it pagkapayong.’ ");
INSERT INTO bno_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tuyar sa pagrayan it buyawan sa kayado pramas mabaoy kag buling, kag bawat tawo ra ay marayan it maramong hirap pramas makatuon kung pauno maging maadong manugsunor it Dios. Maado kag epekto it kina tuyar sa asin nak inglilimpyo kag ni-o mang mabutangan it kali.” ");
INSERT INTO bno_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Kag asin ay maado. Pero kung kag lasa it kaling asin ay mabaoy ay pauno pa kali ipang-asin? Tuyar sa maadong ingtata-o it asin, ray-a ra ninro sa inro kabuhi kag inro maadong kabubut-on ag maging maado kag inro pagsinunranan.” ");
INSERT INTO bno_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ngasing, naghalin sina Hesus sa Capernaum ag nagpagto sa probinsya it Hudeya bag-o nagtabok sa Suba it Jordan. Kag mga tawo ruto ay nagtinipon liwat sa Ida, ag kumporme sa batasang Ida dating ginghuhuman ay ingtudluan ray Nida sinra. ");
INSERT INTO bno_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Inggwa ra it mga Pariseo ruto nak nagpayungot kang Hesus ag nagpangutana sa Ida, “Ingtutugutan baga it ato Kasuguan nak buyagan it usang kayake kag ida asawa?” Inra kali ingpangutana dahil gusto ninra nak purbahan Sida. ");
INSERT INTO bno_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Gingbalik sa inra ni Hesus kag inra pangutana, “Asi, ni-o kag sugo sa inro ni Moises nahanungor sa pagbuyag?” ");
INSERT INTO bno_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sabat ninra, “Nasugot si Moises nak kag kayake ay puyding magbuyag sa ida asawa basta't ahimuon nida kag Kasuyatan bilang pamatuor nak sinra ay buyagey.” ");
INSERT INTO bno_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nagsabat si Hesus, “Dahil ngani abang tugas kamo it uyo, kada ingsuyat nida kina. ");
INSERT INTO bno_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero tuna pa it katong una ay, ‘Gingtugay it Dios kag tawo, nak kayake ag kabade.’ ");
INSERT INTO bno_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ngani, inabilin it kayake kag ida tatay ag nanay agor sida ay mapisan sa ida asawa ");
INSERT INTO bno_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ag sinrang ruha ay magiging usa.’ Bukoey sinra ruha kundi usa. ");
INSERT INTO bno_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kada ngani kag ingpag-usa it Dios, indi dapat pabuyagon it tawo.” ");
INSERT INTO bno_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pagkasabat it kina sa inra ni Hesus ay nagsuyorey sinra sa bayay nak inra ingdadayunan ag ruto nagpangutana kag Ida mga manugsunor it tungor raha. ");
INSERT INTO bno_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Siling Nida sa inra, “Aber si-o man kag kayake nak magbuyag sa ida asawa ag mag-asawa ray sa iba, sida ay nagpapangawatan laban sa ida unang asawa. ");
INSERT INTO bno_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ag imaw ra, aber si-o man kag kabade nak magbuyag sa ida asawa ag mag-asawa ray sa iba, sida ay nagpapangawatan laban sa ida unang asawa.” ");
INSERT INTO bno_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pagkatapos, inggwa it tawong nagraya it inra mga anak kang Hesus agor apabendisyunan sa Ida. Pero ingsaway sinra it mga disipulos. ");
INSERT INTO bno_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pero it katong nakita kali ni Hesus nahangit Sida ag napasiling sa inra, “Pabad-e kinang mga anak nak magpayungot sa Ako. Aya sinra gipigahe, dahil tuyar sa inra kag mapasakop sa paghari it Dios. ");
INSERT INTO bno_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Matuor kaling Ako ingsisiling sa inro. Aber sin-o man kag indi magpasakop sa paghari it Dios it tuyar sa pagpasakop it usang anak sa ida maguyang, ay indi nak gador makasuyor sa Ida gingharian.” ");
INSERT INTO bno_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ag Ida ingkugos ag ingkupkupan kag mga anak, bag-o Ida gingbendisyunan sinra sa pagpatong it Ida damot sa inra. ");
INSERT INTO bno_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","It katong pahalinoney sina Hesus habang sa rayan sinra, inggwa't usang tawo nak nagrayagan pasapoy sa Ida ag nagyuhor sa Ida atubangan. Nagpangutana kaling tawo, “Maadong Maestro, ni-o kag ako dapat himuon agor mapasa-ako kag kabuhi nak waya't katapusan?” ");
INSERT INTO bno_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nagsabat si Hesus sa ida, “Asing imo Ako gingtatawag nak maado? Waya't ibang maado kundi kag Dios yang. ");
INSERT INTO bno_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ag tungor ray sa imo pangutana, ayam ra nimo kag mga Kasuguan, ‘Indi magpangmatay, indi magpangawatan, indi magpanakaw, indi magtestigo it binakak laban sa imo isigkatawo, indi magpangrada, ag tahura kag imo tatay ag nanay.’ ” ");
INSERT INTO bno_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ag siling ray it kaling tawo, “Maestro, tuna sa ako pagka-maisot akoey kali ingtutuman.” ");
INSERT INTO bno_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nabatyagan ni Hesus nak nagyungot kag Ida buot sa ida ag ingmuyatan sida ag nagsiling, “Oho, pero puyra pa raha, inggwa pa it usang bagay nak kuyang sa imo. Pauli anay ag ibaligya kag imo tanang ari-arian, ag ibulig kag binta sa mga pobre. Pag nahimo nimo kina, magkakainggwa ka it kayamanan sa langit. Pagkatapos, balik ag magsunor sa Ako.” ");
INSERT INTO bno_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagkarungog nida rili ay nasubo kaling tawo ag nagpanaw sida nak mabug-at kag buot, dahil abang yaman sida. ");
INSERT INTO bno_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pagkatapos, gingmuyatan ni Hesus kag Ida mga manugsunor ag nagsiling, “Abang hirap talaga para sa usang mayaman nak magpasakop sa paghari it Dios!” ");
INSERT INTO bno_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abang katingaya it Ida mga manugsunor sa Ida ingsiling. Ag nagsiling ray si Hesus sa inra, “Mga anak, abang hirap talaga nak magpasakop sa paghari it Dios! ");
INSERT INTO bno_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas marali pa para sa usang kamelyo nak magsuyor sa buho it radom kisa magpasakop kag usang mayaman sa paghari it Dios.” ");
INSERT INTO bno_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lalo pang natingaya kag Ida mga manugsunor, kada nagpangutana ray sinra sa Ida, “Ay kung tuyar kina, sin-o yang kag maluluwas?” ");
INSERT INTO bno_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ingpakamuyatan sinra ni Hesus ag nagsiling, “Imposible nak mahuman kali it tawo, pero kaya it Dios nak himuon kag tanan, dahil waya't imposible sa Dios.” ");
INSERT INTO bno_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ag nagsiling si Pedro, “Gino-o, ay pauno kami? Ingbadaan namo kag tanan ag nagsunor kami sa Imo.” ");
INSERT INTO bno_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nagsabat si Hesus, “Matuor kaling Ako ingsisiling sa inro. Waya't tawo nak nagbada it ida bayay o mga hali nak kayake ag kabade, o nanay, tatay, mga anak o mga duta, alang-alang sa pagsunor sa Ako ag sa pagpalapnag it Maadong Balita, ");
INSERT INTO bno_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nak indi makabaton it mas subra pang kabuganaan para sa tanang ida ingbadaan. Kinang tanan ay mabalik sa ida ngasing, tuyar sa, kabuganaan sa mga bayay, mga hali nak kayake ag kabade, o nanay, mga anak ag mga duta, ugaling makaagom ra sida it pagpahirap. Ag sa paabuton nak panahon ay mabaton ra sida it kabuhi nak waya't katapusan. ");
INSERT INTO bno_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Maramong ingkikilaya sa ngasing nak mas nakakayabaw kag mawawar-an it puyos sa palaabuton, ag kag mga ingmumuyatan nak pay waya't puyos sa ngasing ay imaw kag makikilaya nak mas yabaw sa tanan sa palaabuton.” ");
INSERT INTO bno_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pagkatapos, nagpadayon sina Hesus patukar sa Herusalem. Ag si Hesus ay nag-una-una sa inra, ag kag ibang Ida mga manugsunor ay natingaya ag kag iba ay ingyawhakan. Marugay-rugay, Ida inghuyat kag Ida doseng disipulos ag Ida ray ingsiling sa inra kung ni-o kag matatabo sa Ida. ");
INSERT INTO bno_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nagsiling Sida, “Runggi ninro kali! Ngasing ay patukarey kita sa Herusalem ag pag-abot nato ruto, Ako nak dati pa ay ingtatawagey nak Anak it Tawo, ay atraiduron ag ita-o sa mga Punong Saserdote ag sa mga Manunudlo it Kasuguan, nak mahusgar sa Ako it kamatayon. Ag pagkatapos, ita-o ray ninra Ako sa mga buko Hudyo ");
INSERT INTO bno_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nak imaw kag mainsulto ag maruya sa Ako. Inra ra Ako alatiguhon ag amatyon, pero sa pangtatlong adlaw Ako ay mababanhaw.” ");
INSERT INTO bno_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pagkatapos, nagpayungot kang Hesus sina Santiago ag Juan nak mga anak ni Zebedeo. Nagsiling sinra sa Ida, “Maestro, inggwa tan-a kami it ipangabay sa Imo.” ");
INSERT INTO bno_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nagpangutana Sida sa inra, “Asi, ni-o kag inro gusto nak himuon Nako?” ");
INSERT INTO bno_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ag nagpangabay sinra, “Gusto namo nak kaming ruha it Imo apaingkuron sa Imo tu-o ag wala, pag Ikaw ay maghariey sa Imo kahimayaan.” ");
INSERT INTO bno_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero nagsiling si Hesus sa inra, “Waya ninro naaayami kung ni-o kag inro inghahagar. Kaya baga ninro nak tis-an kag hirap tuyar sa Ako arayanan? Kaya baga ninro nak agumon kag kamatayon nak Ako aaguman?” ");
INSERT INTO bno_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nagsabat sinra, “Oho, kaya namo!” Siling pa ni Hesus, “Matuor, atis-an nak gador ninro kag hirap nak Ako arayanan, ag aagumon ra ninro kag kamatayon nak Ako aaguman. ");
INSERT INTO bno_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero buko Ako kag masiling kung sin-o kag makakaingkor sa Ako tu-o o wala, dahil kinang pwesto ay para talaga sa mga gingtiganaey it kali.” ");
INSERT INTO bno_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","It katong narunggan kali it katong sampuyong disipulos nahangit sinra kana Santiago ag Juan. ");
INSERT INTO bno_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kada ing-ayaba sinra ni Hesus ag nagsiling sa inra, “Ayam ninro nak dili sa kalibutan kag pinuno it mga nasyon nak waya nagkikilaya sa Dios ay inggagahuman kag inra mga nasasakupan nak inggwa it kaisog, ag kag mga importanting tawo sa inra ay imaw ra kag nagmamayor. ");
INSERT INTO bno_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero para sa inro, buko dapat tuyar, kundi kung si-o man kag gustong makilaya sida ay dapat nak maging tuyar sa usang suguon. ");
INSERT INTO bno_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ag aber sin-o sa inro kag gustong mapamuno ay dapat maserbisyo sida tuyar sa usang ulipon. ");
INSERT INTO bno_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ako nak dati pa ay ingtatawagey nak Anak it Tawo ay nagpaali buko para serbisyuhan, kundi para magserbisyo ag magta-o it Ako kabuhi bilang pangtubos para sa maramong tawo.” ");
INSERT INTO bno_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ngasing, nakaabotey sina Hesus ag Ida mga manugsunor sa banwa it Jerico. Ag tong paliwasoney sinra ruto ay nakarungan ninra kag maramong mga tawo. Sa habig it inra ingrarayanan ay inggwa't nag-iingkor nak usang bulag nak nagpapalimos. Kag ida ngayan ay si Bartimeo nak anak ni Timeo. ");
INSERT INTO bno_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Narunggan ni Bartimeo nak si Hesus nak taga-Nazaret ay marayan. Kada nag-aayaba sida it makusog, “Hesus, Inanak ni David, kaluy-i ako!” ");
INSERT INTO bno_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gingsaway sida it mga tawo ag gingpapahipos. Pero lalo nidang pinaka-kusgan kag ida pag-ukaw, “Inanak ni David, kaluy-i ako!” ");
INSERT INTO bno_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nagruyog anay si Hesus ag nagsiling, “Payunguta sida.” Ag ging-ayaba ngani ninra kinang bulag ag ingsilinggan, “Pakusuga kag imo buot! Maley, tinrog, gingpapayungot ka Nida.” ");
INSERT INTO bno_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ging-itsa nida kag ida alimungmong ag nagtinrog nak raan ag nagpayungot kang Hesus. ");
INSERT INTO bno_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nagpangutana si Hesus sa ida, “Ni-o kag gusto nimong himuon Nako para sa imo?” Nagsabat kag bulag, “Maestro, gusto tan-a nakong makakita.” ");
INSERT INTO bno_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nagsiling si Hesus, “Pauliey, napaado ka parayan sa imo pagtu-o.” Ag sa nak raan sida ay nakakita ag nagsunor kang Hesus sa rayan. ");
INSERT INTO bno_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","It katong mayungotey sina Hesus sa Herusalem, sa mga baryo it Betpage ag Betanya nak asa paus-uson sa Baguntor it mga Olibo, gingpauna anay ni Hesus kag ruha sa Ida mga disipulos, ");
INSERT INTO bno_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ag ingsugo sinra, “Pagto kamo rutuong baryo nak asa uunhan. Pagkasuyor ninro ruto, makikita ninro kag usang nakalig-or nak tureting asno nak waya pang gador it nakakasakay. Bay-a yang ninro ag ray-on dili. ");
INSERT INTO bno_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kung inggwa it magpangutana sa inro kung asing ingbabaoy ninro kina, silinggang kinahangyan nganat kina it Gino-o, ag iuli ra nak raan pagkatapos.” ");
INSERT INTO bno_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ag nagpagtoy ngani katong ruha. Ag nakita ninra katong usang turete nak asno nak nakalig-or sa habig it rayan sa liwas it hagran it usang bayay. Inra inghubar kag higot it kato. ");
INSERT INTO bno_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ruto ay inggwa it mga nag-iistambay nak nagpangutana sa inra, “Hoy, asing inro kina inghuhubar?” ");
INSERT INTO bno_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ag nagsabat sinra kumporme sa ingtugon sa inra ni Hesus, kada gingpabad-an yangey sinra nak makahalin. ");
INSERT INTO bno_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Inggudor ninra kag tureting asno papagto kang Hesus. Pag-abot ninra ruto, inghapinan anay ninra it inra mga baro kag turete ag nagsakayey si Hesus. ");
INSERT INTO bno_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Maramong tawo kag nagbukyar it inra baro sa rayan. Kag iba ay nag-utoy it mga pakyang ag mga ugbos it sanga nak di rahon halin sa mga puno sa habig, ag inghanig ra kali sa rayan bilang pagpakita it inra pagtahor. ");
INSERT INTO bno_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kag mga tawong nag-uuna ag nagsusunor kang Hesus ay nag-iinukaw it, “Hosana!” “Mabuhay kag nag-aabot sa ngayan it Gino-o!” ");
INSERT INTO bno_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Kabay pang pakamaaduhon kag maabotey nak gingharian it ato tatay nak si Haring David!” “Dayawon kag Dios sa kataas-taasan!” ");
INSERT INTO bno_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pagkasuyor nina Hesus sa Herusalem ay nagpagto sinra sa Templo. Nagsuyor Sida ag naglibot ruto habang nagpapangmuyat-muyat. Ugaling dahil maruyomey, nagliwas ray Sida ag nagbalik sa Betanya kaibahan kag Ida doseng disipulos. ");
INSERT INTO bno_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagkasunor nak adlaw, it katong naghaliney sinra sa Betanya pabalik sa Herusalem ag habang sa rayan sinra, ay nakabatyag si Hesus it gutom. ");
INSERT INTO bno_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Naantaw Nida kag usang puno it igos nak maguyangey kag mga rahon ag dapat ay di bungay, kada nagpayungot Sida ruto agor muyatan kung inggwa Sida it mahuhugot. Pero pag-abot Nida ruto, waya Sida it nakitang bunga kundi puro rahon yang, dahil buko pa kato kag panahon it tigbunga it igos. ");
INSERT INTO bno_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kada napasiling Sida sa puno, “Wayaey nak gador it makakaon it imo bunga!” Ag narunggan kali it Ida mga disipulos. ");
INSERT INTO bno_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pag-abot nina Hesus sa Herusalem, nagsuyor Sida sa rayaag it Templo ag ingpaliwas Nida kag mga nagbabaligya ag mga nagpapamakay it mga hadop para ihalar ruto. Ingpabalintong Nida kag mga lamesa it mga nagbabaydo it kwarta, imaw ra kag mga ingkuran it mga nagbabaligya it salumpati. ");
INSERT INTO bno_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ag waya Nida gipayaktura sa rayaag it Templo kag mga tawo nak di rayang mga pinamakay. ");
INSERT INTO bno_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ag gingtudluan Nida kag mga tawo sa pagsiling, “Di baga gingpasuyat it Dios sa Sagradong Kasuyatan nak, “ ‘Kag Ako bayay ay atawagong bayay nak pangamuyuan it mga tawo halin sa tanang mga nasyon?’ Pero inghuhuman ninro kaling lugar it mga radaon.” ");
INSERT INTO bno_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pagkarungog it kali it mga Punong Saserdote ag mga Manunudlo it Kasuguan ay naghanap sinra it parayan kung pauno ninra amatyon si Hesus, kumo nahadlok sinra sa Ida, dahil kag tanang mga tawo ay natitingaya sa Ida pagtudlo. ");
INSERT INTO bno_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ag it katong medyo gab-ey, nagliwas sina Hesus sa syudad. ");
INSERT INTO bno_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkaaga, sa inra pagbalik liwat sa syudad, nakita ninra katong puno it igos nak minatayey. ");
INSERT INTO bno_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Narumruman ni Pedro kag ingsiling ni Hesus sa kahoy, ag napasiling sida, “Maestro, muyati! Kag puno nak Imo gingsumpa ay minatayey!” ");
INSERT INTO bno_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nagsabat si Hesus, “Magtu-o kamo sa Dios! ");
INSERT INTO bno_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Matuor kaling Ako ingsisiling sa inro. Aber sin-o man nak inggwa't pagtu-o sa Dios ay puyding magsiling riling baguntor nak, ‘Halin raha ag magsaydo sa ragat!’ Ag kung waya sida it pangruha-ruha sa ida tagipusuon ag magtu-o yang it matuor nak kag ida ginghahagar ay matutuman, ay talagang kina ay matutuman. ");
INSERT INTO bno_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kada rumruma ninro nak aber ni-o man kag inro inghahagar sa pangamuyo, magtu-o kamo nak nabatoney ninro kali ag talagang kali ay mapapasa-inro. ");
INSERT INTO bno_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Ag sa inro pagpangamuyo, patawara anay ninro kag nakasala sa inro agor apatawaron ra kamo it inro Tatay sa langit sa inro kasal-anan. ");
INSERT INTO bno_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kung indi kamo makapatawar sa mga nakasala sa inro, indi ra kamo gipatawaron it inro Tatay sa langit.” ");
INSERT INTO bno_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nakaabot ray sina Hesus sa Herusalem ag nagsuyor sinra sa Templo. Habang nagpapanaw si Hesus raha ay ingpayungutan Sida it mga Punong Saserdote, mga Manunudlo it Kasuguan, ag iba pang mga pinuno it mga Hudyo, ");
INSERT INTO bno_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ag ingsura Sida, “Ni-o kag Imo karapatan para himuon kag tanang Imo ginghihimo? Si-o kag nagta-o sa Imo it kali?” ");
INSERT INTO bno_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ingsabat sinra ni Hesus, “Apangutan-on ra kamo Nako. Pag nasabat ninro Ako, asabton ra kamo Nako kung riin gihalin kag Ako karapatan nak himuon kali. ");
INSERT INTO bno_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kag p