﻿USE sofia;
DROP TABLE IF EXISTS sofia.bmu_vpl;
CREATE TABLE bmu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bmu_vpl WRITE;
INSERT INTO bmu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Könakönahiŋe Anutunöŋ Suep aka gölme miwikŋaim etkiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Miwikŋaim etkiiga gölme mi gwamönŋi aka kizik-kazukŋambuk ahöyök. Ahöiga o diginŋambuk mi söŋaupnöŋ turuiga tarök. Mewö tariga Anutugö Uŋa Töröŋan o mieŋgö qakŋine anda kaba malök. ");
INSERT INTO bmu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mewö maliga Anutunöŋ kewö jim kutuyök: “Asakŋan mönö asuhum tiŋgitma.” Mewö jim kutuiga miri mönö asariyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Asarii ehi miaŋön mönö ölöwahiga asakŋi pandamanöhök mendeŋ etkiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Asakŋaŋgö qetŋi wehön asakŋi aka pandamangö qetŋi suŋgem mewö etkoholök. Mewö etkoholiga wehön mutukŋi teköiga miri söŋauba giaŋiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Giaŋiiga Anutunöŋ kewö jim kutuyök: “Mönö o sutŋine suepkö jabö köhöikŋi asuhuba o mendeŋniga euke aka emuke ahömahot.” ");
INSERT INTO bmu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Mewö jim kutuba suepkö jabö köhöikŋi miwikŋaiba miaŋön o mendeŋniga tiŋgita jabö qakŋe euke aka jabö bapŋe emuke ahöyohot. Mewö asuhuiga ");
INSERT INTO bmu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","suepkö jabö köhöikŋi eukeaŋgö qetŋi suep qerök. Mewö qeriga wehön yahötŋi teköiga miri kunbuk söŋauba giaŋiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Giaŋiiga Anutunöŋ kewö jim kutuyök: “O suep bapŋe ahözei, mi mönö qezakögetka kambu mohot aiga gölme örönŋi asuhuma.” Mewö jim kutuiga mönö mewö asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mewö asuhuiga örönŋaŋgö qetŋi gölme qeta o kambu tokogeri, miaŋgö qetŋi köwet etkoholök. Etkohola etkehiga miaŋön mönö ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ölöwahiga kewö jim kutuyök: “Gölme qakŋe mönö yuai görökŋi (töŋgönŋi) pakpak kewö asuhuba wahötme: Gwözözak yuai kötŋinambuk mi mönö asuhuba wahöta kötŋini kuŋguba söhömakŋe. Ip kösö tandökŋini könaŋi könaŋi mönö gölmenöŋ asuhuba ölŋini kötŋinambuk kuŋguba söhömakŋe.” Mewö jim kutuiga mönö kewö asuhuyök: ");
INSERT INTO bmu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Gölme qakŋe yuai görökŋi (töŋgönŋi) pakpak asuhuba wahötket. Gwözözak yuai kötŋinambuk tandökŋini könaŋi könaŋi mi asuhuget. Ip kösö tandökŋini könaŋi könaŋi mi gölmenöŋ asuhuba ölŋini kötŋinambuk kuŋgum söhöget. Mewö asuhuiga Anutunöŋ eŋgehiga miaŋön mönö ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Wehön karöbutŋi teköiga miri kunbuk söŋauba giaŋiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Giaŋiiga Anutunöŋ kewö jim kutuyök: “Suepkö jabö köhöikŋe mönö asakŋi asakŋi asuhuba wehön aka suŋgem mi mendeŋ etkiba kinda (yara) yambu, kömunjaŋ kie nalö aka wehön nalö, gwani nalö aka silim mohot mohotkö aiwesökŋina ahöme. ");
INSERT INTO bmu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Mieŋön mönö suepkö jabö köhöikŋi miaŋgöreŋ asakŋi asakŋi aka gölme mem asarime.” Mewö jim kutuiga mönö kewö asuhuget: ");
INSERT INTO bmu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Anutunöŋ asakŋi ketaŋi yahöt miwikŋaim etkiyök: Asakŋaŋgö galömŋi wehön jeŋi kiniga miaŋgö eretŋi köiŋ mi suŋgemgö galömŋa kinda ahöm öŋgömahot. Seŋgelau mi mewöŋanök miwikŋaim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Anutunöŋ mi suepkö jabö köhöikŋe miaŋgöreŋ gölme mem asarimegöra al eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Mi gölme mem asariba wehön aka suŋgem galömŋina kinda asakŋi aka pandamanŋi mendeŋ etkimegöra al eŋgiyök. Mewö asuhuiga Anutunöŋ eŋgehiga miaŋön mönö ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Wehön 4:ŋi teköiga miri kunbuk söŋauba giaŋiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Giaŋiiga Anutunöŋ kewö jim kutuyök: “O köwet mieŋgö uruŋine mönö yuai isikusukŋinambuk asuhuba dop köla o qeba ölölaŋgöba laŋ anda kaba malme. Mewöŋanök neiŋi neiŋi gölme qakŋe könakemba bölbölgöba kutuba anda kaba malme.” ");
INSERT INTO bmu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Mewö jiba köwetkö sömbupŋi ketaŋi ketaŋi aka yuai isikusukŋinambuk tandökŋini könaŋi könaŋi o qeba ölölaŋgöba qeqelaŋlaŋ anda kamakzei, mi miwikŋaim eŋgiyök. Mewöyök nei tandökŋini könaŋi könaŋi ginginŋinambuk mi miwikŋaim eŋgiyök. Miwikŋaim eŋgiba eŋgehiga miaŋön mönö ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ölöwahiga kötuetköm eŋgiba keu kewö jiyök: “Iŋini mönö köt moröŋinambuk jul sehiba o köwet dop köla malme aiga nei iŋini mönö mewöŋanök gölme qakŋe ahum sehime.” ");
INSERT INTO bmu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Keu mewö jiiga wehön 5:ŋi teköiga miri kunbuk söŋauba giaŋiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Giaŋiiga Anutunöŋ kewö jim kutuyök: “Gölme qakŋe mönö yuai pakpak malmalŋinambuk tandökŋini könaŋi könaŋi asuhume. Mirigö sömbupŋi, yuai bapŋinan köla ölölöŋgömakzei aka arökŋaŋgö sömbupŋi tandökŋini könaŋi könaŋi, mi mönö asuhume.” Mewö jim kutuiga mönö kewö asuhuget: ");
INSERT INTO bmu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Anutunöŋ arökŋaŋgö sömbupŋi tandökŋini könaŋi könaŋi mi miwikŋaim eŋgiyök. Mirigö sömbupŋi tandökŋini könaŋi könaŋi mi miwikŋaim eŋgiyök aka yuai pakpak bapŋini gölmenöŋ köla ölölöŋgömakzei, tandökŋini könaŋi könaŋi mi miwikŋaim eŋgiyök. Miwikŋaim eŋgiba eŋgehiga miaŋön mönö ölöwahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Miaŋgö andöŋe Anutunöŋ kewö jiyök: “Ayop, nini mönö azi nanine tandökö dop meinga kaisoŋgolomnini ewö aka yuai pakpak galöm köl eŋgiba malma. Yuai pakpak mi köwetkö söraŋi, suepkö neiŋi aka mirigö sömbupŋi, gölme körek aka yuai pakpak bapŋini gölmenöŋ köla ölölöŋgömakzei, mönö mieŋgö galömŋina aka malma.” ");
INSERT INTO bmu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Mewö jiba nanŋi kaisoŋgolomŋaŋgö dop azi miwikŋaiyök. Anutugö kaisoŋgolomŋi ewö malmapköra i miwikŋaim waŋgiyök. Azi aka ambi malmahotköra i miwikŋaim etkiyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Miwikŋaim etkiba i kötuetköba kewö jim kutum etkiyök: “Iŋiri mönö ahum sehiba gwölönarökpuk malohotka gölme dop köla malme. Mewö mala gölme toŋi akŋe. Mewö aka köwetkö söraŋi, könakembagö neiŋi aka sömbup mokoleŋ laigisip gölmenöŋ anda kamakzei, mönö mi pakpak galöm köl eŋgiba malme.” ");
INSERT INTO bmu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mewö jiba keu kewö jiyök: “Mötket, nöŋön yöha könaŋi könaŋi gölme pakpak dop köla asuhuba wahöta kötŋini kuŋgum söhömakzei aka ip kösö pakpak öl kötŋinambuk kuŋgum söhömakzei, mi numbu neneŋini akŋapköra al eŋgizal. ");
INSERT INTO bmu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Arökŋaŋgö sömbupŋi pakpak, könakembagö neiŋi pakpak aka yuai pakpak gölmenöŋ anda kamakzei aka tosatŋi pakpak söŋgörö ösumŋini örömakzei, yeŋgöra gwözözak görökŋi (töŋgönŋi) könaŋi könaŋi mi neneŋamŋini akŋapköra al eŋgizal. “Keu mewö jiiga mönö mewö asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Asuhuiga Anutunöŋ yuai pakpak miwikŋaiyöhi, mi ehiga mönö ölöp kötökŋi aiga urusösöŋgai mörök. Wehön 6:ŋi teköiga miri kunbuk söŋauba giaŋiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Giaŋiiga suepkö jakeŋi jakeŋi, gölme aka mietkö yuaiŋiri aködamunŋirambuk pakpak mi lök miwikŋaim eŋgim teköyök. ");
INSERT INTO bmu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Anutunöŋ nupŋi mi mei teköiga wehön 7 miaŋgöreŋ kendon tarök. Nupŋi pakpak meyöhaŋgöra wehön 7 miaŋgöreŋ luhut meyök. ");
INSERT INTO bmu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Miwimiwikŋai nupŋi pakpak meyöhaŋgöra aka wehön miaŋgöreŋ luhut meyök. Miaŋgöra wehön 7:ŋi mi kendon jiba kötuetköba jim kömbuhiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Anutunöŋ suep gölme miwikŋaim etkiiga asuhuyohoraŋgö kösohotŋi mi mewö. Kembu Anutunöŋ suep aka gölme miwikŋaim etkiyöhi, nalö miaŋgöreŋ ");
INSERT INTO bmu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","Kembu Anutugö jitsihitköra gölme qakŋe kie qahö yöhöiga nup kölkömötköra azi kun kude malökmö, gölme uruŋeyök bedunöŋ miyök kota gölme qakŋi dop köla mem samuruyök. Miaŋgöra arökŋaŋgö ip kösö kun me sombemgö gwözözak yuai kun mi gölmenöŋ qahö asuhum tiŋgita ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Nalö miaŋgöreŋ Kembu Anutunöŋ gölme sömsöm memba miaŋön azi mem yaköba malmalgö numbu ösumŋi söŋgöröŋe ui geiga öröba guliba malmalgö uŋaŋambuk ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mewö aiga Kembu Anutunöŋ wehön kotkotŋe göröken miri qetŋi Eden miaŋgöreŋ oyaeŋkoyaeŋ nup kömöta azi miwikŋaiyöhi, i miaŋgöreŋ al waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Al waŋgiba jiiga gölmenöhök ip tandökŋini könaŋi könaŋi asuhuba wahötket. Ip mi eksihimŋinambuk aiga ölŋini neneŋi mi nahömŋinambuk. Oyaeŋkoyaeŋ nup bibiŋe malmal köhöikŋaŋgö ipŋi aka mötkutukutugö ipŋi mi mohotŋe jim kutuiga asuhuyohot. Mötkutukutugö ipŋaŋgö könaŋi kewö: Ölŋi nemba miaŋön ölöpŋi aka bölöŋi mietkö könaŋiri mi möt kutubahotpuk. ");
INSERT INTO bmu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ip mewö wahötketka o töwatŋi kun mi Edenök könahiba oyaeŋkoyaeŋ miri mem kelita miaŋgöreŋök eta jula o böröŋi töwatŋi 4 aka anget. ");
INSERT INTO bmu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","O töwatŋi mutukŋaŋgö qetŋi Pison, mi Hawila gölme körek liliköba ahöba anja. Gölme miaŋgöreŋ goul ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gölme miaŋgö goulŋi mi ölöpŋi kötökŋi akza. Sileqösösök umköhöwakŋambuk qetŋi bedelion aka köt ölŋambuk qetŋi oniks mi mewöyök miaŋgöreŋ ahözahot. ");
INSERT INTO bmu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","O böröŋi töwatŋi jaŋgö 2 miaŋgö qetŋi Gihon. Mi (Mesopotemiagö) gölme qetŋi Kus mi körek liliköba ahöba anja. ");
INSERT INTO bmu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","O böröŋi töwatŋi karöbutŋi qetŋi Taigris. Mi Asiria gölme wösöŋe wehön kotkotŋe göröken geba anja. O böröŋi töwatŋi jaŋgö 4 miaŋgö qetŋi mi Yufreitis. ");
INSERT INTO bmu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mewö aiga Kembu Anutunöŋ azi waŋgita oyaeŋkoyaeŋ miri Eden köl kömöta ek galöm akŋapköra jiba al waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Al waŋgiba kewö jiba jim kutum waŋgiyök: “Oyaeŋkoyaeŋ nup uruŋe ip pakpak kin anjei, mieŋgö ölŋini mi ölöp amqeba mem nemba malman. ");
INSERT INTO bmu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mimö, mötkutukutugö ipkö ölŋi mi mönö kude neman. Mi nemba ölöpŋaŋgö könaŋi aka bölöŋaŋgö könaŋi möt kutuman ewö, gi mönö wehön miaŋgöreŋök kömum köhöiman. Miaŋgöra mi mönö kude neman.” ");
INSERT INTO bmu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mewö jiba Kembu Anutunöŋ jiyök: “Azinöŋ nanŋök maliga ölöp qahö akza. Miaŋgöra nöŋön mönö nanŋi tandökŋaŋgö dop alabaukŋi miwikŋaimam.” ");
INSERT INTO bmu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Mewö jiba arökŋaŋgö sömbupŋi pakpak aka könakembagö neiŋi pakpak mi gölmenöŋ miwikŋaim eŋgiba azigö kösutŋe eŋguaŋgita azinöŋ qetŋini denöwö qetmawi, mi eka mötmapköra yaŋgöreŋ al eŋgiyök. Al eŋgiiga azinöŋ yuai malmalŋinambuk pakpak mieŋgö qetŋini mohok mohok qeriga Anutunöŋ mewö mia ahömapköra jim köhöiyök. ");
INSERT INTO bmu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mewö aiga azinöŋ mirigö sömbupŋi pakpak, könakembagö neiŋi pakpak aka arökŋaŋgö sömbupŋi pakpak mi qetŋini eŋgim teköyök. Eŋgim teköyökmö, nanŋi tandökŋaŋgö dop alabaukŋi malmapköra kun qahö miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Qahö miwikŋaiiga Kembu Anutunöŋ mi eka azi mem lömböriiga gaun lömbötŋi ahöyök. Ahöiga maröm sihitŋi kun öröba dumdumŋi busuŋan mem gwözöŋnök. ");
INSERT INTO bmu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Gwözöŋda azinöhök maröm sihitŋi meyöhi, miaŋön ambi meyök. I memba azigöreŋ waŋgita kayök. ");
INSERT INTO bmu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Waŋgita kaiga azinöŋ i eka kewö jiyök: “Yei! Ki nani tandöha. Yaŋgö sihit busuŋi mi nani sihit busunöhök asuhuza. Anutunöŋ i azigö sile kitipŋeyök mei letota azi tandök ewö maljawaŋgöra qetŋi mönö ambi (azigö alaŋi) qetme.” ");
INSERT INTO bmu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Mewö jiiga Anutunöŋ kewö jim kutum etkiyök: “Mewö aiga azinöŋ mönö iwinamŋi etkömosöta anömŋaŋgöreŋ qekötahöba silemohot aka malmahot.” ");
INSERT INTO bmu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Azi miaŋön anömŋambuk opo söröŋiri qahö aukŋe malohotmö, töndup nanŋiraŋgö gamuŋiri qahö möta malohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kembu Anutunöŋ gölmegö sömbup malmalŋinambuk pakpak miwikŋaim eŋgiyöhi, mieŋgö sutŋine mokoleŋnöŋ isimkakalek mötmötnöŋ sömbup pakpak mi eŋgoŋgita öŋgöyök. Mewö öŋgöba ambigöra kewö jiyök: “Oyaeŋkoyaeŋ mire ip pakpak kin anjei, mieŋgö ölŋini kun kude nemahotköra Anutunöŋ ölŋa jim kutum etkiyök me qahö?” ");
INSERT INTO bmu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mewö jiiga ambinöŋ meleŋda mokoleŋgöra kewö jiyök: “Oyaeŋkoyaeŋ mire ip tosatŋi kin anjei, mieŋgö ölŋini mi ölöp nembitköra jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mimö, miri bibiŋe ip kun kinjawi, miaŋgö ölŋi mi nemba kömumbitpuköra mönö kewö jiyök: ‘Mi mönö kude nemahot. Mia kude misirimahot.’ Mewö jim kutum netkii maljit.” ");
INSERT INTO bmu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mewö meleŋda jiiga mokoleŋnöŋ ambigöra kewö jiyök: “Mi saumbaŋ! Iŋiri kude kömumahot. ");
INSERT INTO bmu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mimö, ip miaŋgö ölŋi mi neyohotka wehön miaŋgöreŋök mönö jeŋiran tohoiga Anutu ewö aka ölöpŋaŋgö könaŋi aka bölöŋaŋgö könaŋi möt tekömahot. Anutunöŋ keu mi möta mewö asuhubapuköra keuŋi mewö jiyök.” ");
INSERT INTO bmu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mewö jiiga ambinöŋ ip mi uba ehiiga ölŋi ölöpŋi neneŋaŋgö dop ahök. “Mi eksihimŋambuk kiniga mötkutukutu ketaŋi awamŋanök niŋgima,” mewö mötmöriba ölŋi kun meköba neyök. Nemba apŋi yambuk malöhi, i tok waŋgiiga neyök. ");
INSERT INTO bmu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Neiga jeŋiran mönö miaŋgöreŋök tohoiga sileŋiri aukŋe malohori, mi aŋgek kutuyohot. Mewö aŋgek kutuba kinda fig ipkö sinŋi mumburatiba opo söröŋiri uba lata malohot. ");
INSERT INTO bmu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Malohotka wehön jeŋi geiga miri löwöriiga Kembu Anutunöŋ oyaeŋkoyaeŋ mire tiba kaiga köna ötöŋi mörohot. Mi möta awanöm yetkön Kembu Anutugö jemesoholŋeyök mömölaköba oyaeŋkoyaeŋ mirigö ip uruŋine anda asambörohot. ");
INSERT INTO bmu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Asambörohotmö, Kembu Anutunöŋ azigö qeta kewö jiyök, “Gi mönö denike maljane?” ");
INSERT INTO bmu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mewö qeta jiiga kewö meleŋnök: “Gi oyaeŋkoyaeŋ miri uruŋe tiba kanöŋga köna ötöŋgi möta sileni aukŋe maljalaŋgöra keŋgötni mötzal. Miaŋgöra mömölaköba asamböta maljal.” ");
INSERT INTO bmu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mewö meleŋniga kewö jiyök: “Gi sile aukŋe maljani, mi mönö daŋön jii mötzan? Nöŋön ip kungö kötŋi nembanbukö soŋgo al gihiali, göŋön miaŋgöreŋök kun nezan me?” ");
INSERT INTO bmu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mewö jiiga azinöŋ kewö jiyök: “Ambi nömbuk malmapköra niŋginöŋi, yanöŋ mönö ip miaŋgö kötŋi niŋgiiga nezal.” ");
INSERT INTO bmu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mewö jiiga Kembu Anutunöŋ ambi kewö qesim waŋgiyök: “Göŋön wuanöŋgöra mewö akzane?” Qesim waŋgiiga kewö meleŋnök: “Mokoleŋnöŋ mönö tilipköm niŋgiiga nezal.” ");
INSERT INTO bmu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mewö meleŋniga Kembu Anutunöŋ mokoleŋgöra kewö jim waŋgiyök: “Mewö akzanaŋgöra aka gi mönö mirigö sömbupŋi pakpak aka arökŋaŋgö sömbupŋi pakpak yeŋgö sutŋiŋe kewö jim qesuahöm gihibiga malman: Göŋön mönö gölmenöŋ malmanaŋgö dop bapkan köla anda kaba sömsöm uruŋe mala nesak yuai nemakŋan. ");
INSERT INTO bmu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mewö nemba ambibuk sutŋire kerök al etkibiga mi möta malman. Kerök mi göhö gwölönarökurupki aka yaŋgö gwölönarökurupŋi yeŋgö sutŋine toroqeba ahöm öŋgöi kewö asuhuma: Yeŋgöreŋök azi kunöŋ mönö göhö nöröpki tölölahöiga göŋön yaŋgö köna gwakötŋi yöhösulmakŋan.” ");
INSERT INTO bmu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Toroqeba ambi kewö jim waŋgiyök: “Göŋön gölömgabuk aka malnöŋga sihimbölöŋi ketaŋi al gihibiga masö ahum gihiiga möta morö mem eŋgimakŋan. Mi töndup sihimgan mönö apkahöra ahöm gihiiga yaŋön galömgi aka malma.” ");
INSERT INTO bmu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Toroqeba azi kewö jim waŋgiyök: “Nöŋön ip kungö ölŋi nembanbuköra ‘Mia kude neman,’ jiba soŋgo al gihialmö, göŋön mi töndup anömgahö keuŋi wuataŋgöba nezan. Miaŋgöra nöŋön gölme mi göhöra aka saitköbiga ahöma. Mewö ahöiga göŋön gölmenöŋ malmanaŋgö dop mönö sileqeqe aka nup gwötpuk memba sihimbölö möta nenegi miwikŋaiba malman. ");
INSERT INTO bmu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nup memba malnöŋga göhö nene nupnöŋ nuŋgakal, koururuk (köwörörök) yuai mi asuhuiga arökŋaŋgö yöha yuai mi nemba malman. ");
INSERT INTO bmu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mewö mala mesoholge nöŋgöp ariba nup memba tup yakagi mewö nemba mala gölmenöŋ mem gihiali, gölme miaŋgöreŋ mönö kunbuk liliŋgöba geman. Silegi gwakömnöŋ mem gihibiga mala öŋgöbagun mönö kunbuk gwaköm akŋan. “Mewö jim waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Azinöŋ anömŋi yuai pakpak malmalŋinambuk maljei, mieŋgö namŋini aiga azinöŋ qetŋi Iw (Ewa) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kembu Anutunöŋ sömbup sileŋan opo sörö memba Adam anömŋet lat etkiiga malohot. ");
INSERT INTO bmu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mewö malohotka Kembu Anutunöŋ kewö jiyök: “Yei! Ambazip mi neŋgöreŋök kungö dop aka ölöpŋi bölöŋi mietkö könaŋiri lök mendeŋ etkibitkö mötzahot. Mewö aiga malmal köhöikŋaŋgö ip kötŋi kude nemahotköra soŋgo alalmö, yetkön nalö kewöŋe toroqeba böröŋiri böraŋda mi mewöyök mem nemba mewö miaŋön qahö kömumba teteköŋi qahö köhöikŋanök mal öŋgöbahotpuk.” ");
INSERT INTO bmu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Mewö jiba miaŋgöra oyaeŋkoyaeŋ nup Eden miaŋgöreŋök közöl etkiba gölmenöhök mem etkiyöhi, mönö gölme miaŋgöreŋök kölkömöt nup memahotköra melaim etkiiga yaigep geba anohot. ");
INSERT INTO bmu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ambazip mewö közöl etkiba oyaeŋkoyaeŋ miri Edengö likepŋe wehön kotkotŋe göröken zerubim garata tosatŋi al eŋgiiga malmal köhöikŋaŋgö ip miaŋgö könaŋi utuba galöm kölget. Yeŋgö böröŋine bimgö souŋi ketaŋi aliga miaŋön könöp bölam ewö gilikbilikŋambuk jeba andöŋe wösöŋe liliköba biliksikö dop aiga kinda galöm köla malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Azi Adamnöŋ anömŋambuk mala amiyohotka Iwnöŋ (Ewa) gölöm ala Kein (Kain) meyök. Memba Kein qetköra kewö jiyök: “Anutunöŋ bauköm niŋgiiga nahöni mezal.” ");
INSERT INTO bmu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Iwnöŋ könaŋgep Adamgö nahönŋi Abel, Keingö munŋi meyök. Abelnöŋ mala qariba lama galömŋina aiga Keinöŋ kölkömöt azia aka malök. ");
INSERT INTO bmu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mewö malohotka nalö kunöŋ Keinöŋ nupkö nene tosatŋi memba kaba Kembugöra jöwöwöl ohom waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abelnöŋ mewöyök lama kambuŋaŋgö mutuk asuasuhuŋi tosatŋi meköba eŋguba kitipŋi kelökŋinambuk memba kaba Kembugö jöwöwöl ohoyök. Ohoiga Kembunöŋ Abel nanŋi aka jöwöwölŋi etkeka möri ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ölöwahökmö, Kembunöŋ Kein aka yaŋgö jöwöwölŋi mi ek tököyök. Mewö aiga Keingö irimŋi seholiiga kömbuhiba jemesoholŋan bosoliyök. ");
INSERT INTO bmu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Bosoliiga Kembunöŋ Keingöra kewö jii mörök: “Irimgi mönö wuanöŋgöra seholiiga jemesoholgan bosoliza? ");
INSERT INTO bmu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Gi yuai ölöpŋi aknöŋga möt aŋgön köl gihibiga ölöp jemesoholgi öhal (hak) akŋan me qahö? Yuai ölöpŋi qahö aknöŋga siŋgisöndokö Toŋan mönö urugahö naŋguŋe kinda göhöra ak gihiba mönömakza. Mewö mönömakzapmö, göŋön mönö miaŋgö soŋgo ala galöm memba luhut alman.” ");
INSERT INTO bmu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kembunöŋ Keingöra mewö jii mörökmö, Keinöŋ töndup munŋi Abelgöra kewö jiyök: “Mönö nanirök nupnöŋ anbit. “Mewö jiiga nupnöŋ anda mala Keinöŋ luhuba munŋi Abel qelanjiba memba qeba qei kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kömuiga Kembunöŋ Kein kewö qesim waŋgiyök: “Mungi Abel mi denike malja?” Qesim waŋgiiga kewö meleŋnök: “Ni qahö mötzal. Ni munangö jegalöma qahö akzal.” ");
INSERT INTO bmu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mewö meleŋniga Kembunöŋ jiyök: “Gi wani yuaia akzan? Mötnöŋ, mungahö sepŋan mönö gölmenöhök qeriga mötzal. ");
INSERT INTO bmu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Gölme kiaŋgö numbuŋan aŋaŋiba mungahö sep börögeyök mezawi, nöŋön mönö kiaŋgöreŋök közöl gihibi anman. Jöramörahö mi mönö göhö qake albi öŋgöza. ");
INSERT INTO bmu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Közöl gihibiga kölkömöt nup menöŋga gölmenöŋ möriamŋaŋgö ölŋi aŋgön köl gihiiga gölme dop mömölaköba kekelolo aka ölöŋ köla laŋ anda kaba malman.” ");
INSERT INTO bmu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Mewö jiiga Keinöŋ Kembugöra kewö jiyök, “Keunaŋgö likepŋi meleŋnöŋga qakne öŋgözawi, miaŋön mönö ösumni oŋgiri lömböriiga bisimamgö osimam. ");
INSERT INTO bmu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mötnöŋ, gi merak ni nupqeqe gölmenöhök nuataŋgönöŋga jemesoholgeyök mömölaköba gölme dop kekelolo aka ölöŋ köla laŋ anda kaba malmam. Miaŋgöra kunŋan ni neka ölöp nuŋgui kömumbileŋbuk.” ");
INSERT INTO bmu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mewö jiyökmö, Kembunöŋ kewö jii mörök: “Mewö qahö. Kunŋan Kein qei kömuma ewö, miaŋgö likepŋi mönö yaŋgö qakŋe öŋgöiga ambemŋi 7 akŋa. “Mewö jiba kunŋan Kein miwikŋaiba i qei kömumbapuköra sileŋe aiwesök kulem kun alök. ");
INSERT INTO bmu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Mi aliga Kembugö jemesoholŋi mosöta anda anda gölme qetŋi Laŋlaŋ lilikqilik (Nod) miaŋgöreŋ aŋgota malök. Gölme mi Edenök wehön kotkotŋe göröken ahöza. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Keinöŋ anömŋambuk mala amiyohotka gölöm ala Henok meyök. Keinöŋ taon kun memba nahönŋaŋgö qetŋi Henok qet waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henokö nahönŋi qetŋi Irad. Iradkö nahönŋi Mehujael. Mehujaelgö nahönŋi Metusael. Metusaelgö nahönŋi Lamek. Mewö asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameknöŋ ambi yahöt etkömeyök: Kun qetŋi Ada, kun qetŋi Zila. ");
INSERT INTO bmu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adanöŋ gölöm ala Jabal meyök. Yaŋön ambazip opo seri koumŋine ahöba mala bau bulmakau galöm köl eŋgiba maljei, yeŋgö bömönŋini ahök. ");
INSERT INTO bmu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabalgö munŋaŋgö qetŋi mi Jubal. Yaŋön ambazip gita kulele qeba awölop uba maljei, yeŋgö bömönŋini ahök. ");
INSERT INTO bmu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zilanöŋ mewöyök nahönŋi qetŋi Tubal-Kein meyök. Yaŋön qariba börögö tulsŋi aka bimqeqegö yuaiŋi könaŋi könaŋi mi bras aka ainöŋ ohoi kolkolgöi qekötahöba mezapma. Tubal-Keingö nenŋi qetŋi Nama. ");
INSERT INTO bmu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameknöŋ nalö kunöŋ anömyahötŋi mi kewö jii mörohot, “Ada aka Zila anömyahötni, iŋiri mönö kezap ala keuni ki mötmahot: Kunŋan nuŋgum kuziriga uzinaŋgö kitipŋaŋgöra mönö azi kun qebi kömuma. Kunŋan nuŋgum miziriga gurusep (gulibambam) löpötnaŋgö kitipŋaŋgöra mönö azi gwabö kun qebi kömuma. ");
INSERT INTO bmu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kunŋan Kein qeiga likepŋi yaŋgö qakŋe öŋgöiga ambemŋi 7 akŋapmö, kunŋan Lamek ni nuŋguiga miaŋgö likepŋi mönö yaŋgö qakŋe öŋgöiga ambemŋi 77 akŋa. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Azi mutukŋi Adam yaŋön kunbuk anömŋambuk mala amiyohotka nahönŋiri kun memba kewö jiyök: “Keinöŋ Abel qei kömuyöhaŋgöra Anutunöŋ Abelgö salupŋe nahöni kun niŋgiza. “Miaŋgöra qetŋi Set (Niŋgiza) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setkö nahönŋi mewöyök asuhuiga qetŋi Enos qerök. Mewö. Nalö miaŋgöreŋ ambazip yeŋön könahiba Kembugö qetŋi köuluköba malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adamgö isimorö aka amböisikurupŋi yeŋgö qet areŋ papiaŋi ki. Anutunöŋ azi miwikŋaiyöhi, yaŋön mi nanŋi kaisoŋgolomŋaŋgö dop meyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mewö memba azi ambi malmahotköra miwikŋaim etkiba nalö miaŋgöreŋ qetŋiri ambazip qeta kötuetköm etkiyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamnöŋ mala yambuŋi 130 aiga nahönŋi kun asuhuyök. Mi Adam nanŋi kaisoŋgolomŋi aka tandökŋaŋgö dop maliga qetŋi Set qerök. ");
INSERT INTO bmu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set asuhuiga nalö miaŋgöreŋök Adamnöŋ toroqeba yambu 800 mala mala maliga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamnöŋ mewö mala öŋgöba yambuŋi mindiriba 930 meköba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Kömuiga nahönŋi Set yaŋön yambuŋi 105 aiga nahönŋi Enos asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enos asuhuiga nalö miaŋgöreŋök Setnöŋ toroqeba yambu 807 mala mala maliga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Öŋgögetka Setnöŋ mala mala öŋgöba yambuŋi mindiriba 912 meköba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Kömuiga nahönŋi Enos yaŋön yambuŋi 90 aiga nahönŋi Kenan asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenanöŋ asuhuiga nalö miaŋgöreŋök Enosnöŋ toroqeba yambu 815 mala mala mal öŋgöiga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Öŋgögetka Enosnöŋ mala mala öŋgöba yambuŋi mindiriba 905 meköba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kömuiga nahönŋi Kenan yaŋön yambuŋi 70 aiga nahönŋi Mahalalel asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel asuhuiga nalö miaŋgöreŋök Kenanöŋ toroqeba yambu 840 mala mala mal öŋgöiga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Öŋgögetka Kenanöŋ mala mala öŋgöba yambuŋi mindiriba 910 meköba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Kömuiga nahönŋi Mahalalel yaŋön yambuŋi 65 aiga nahönŋi Jared asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jared asuhuiga nalö miaŋgöreŋök Mahalalelnöŋ toroqeba yambu 830 mala mala mal öŋgöiga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Öŋgögetka Mahalalelnöŋ mala mal öŋgöba yambuŋi mindiriba 895 meköba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Kömuiga nahönŋi Jared yaŋön yambuŋi 162 aiga nahönŋi Enok asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enok asuhuiga nalö miaŋgöreŋök Jarednöŋ toroqeba yambu 800 mala mala mal öŋgöiga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Öŋgögetka Jarednöŋ mala mala mal öŋgöba yambuŋi mindiriba 962 meköba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Kömuiga nahönŋi Enok yaŋön yambuŋi 65 aiga nahönŋi Metusela asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela asuhuiga nalö miaŋgöreŋök Enoknöŋ yambu 300:gö dop uruŋi Anutubuk jöhöba anda kaba maliga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Öŋgögetka Enoknöŋ mala mal öŋgöba yambuŋi mindiriba 365 meköyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Meköba uruŋi Anutubuk jöhöba anda kaba maliga Anutunöŋ öne waŋgiriga atatop (jiatatoŋ) kölök. ");
INSERT INTO bmu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Atatop köliga nahönŋi Metusela yaŋön yambuŋi 187 aiga nahönŋi Lamek asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Asuhuiga nalö miaŋgöreŋök Metuselanöŋ toroqeba yambu 782 mala mal öŋgöiga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Öŋgögetka Metuselanöŋ mala mala mal öŋgöba yambuŋi mindiriba 969 meköba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Kömuiga nahönŋi Lameknöŋ yambuŋi 182 aiga nahönŋi kun asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Asuhuiga qetŋi Noa (kölalep) qeta kewö jiyök: “Anutunöŋ gölme saitköiga nini böröninan nup köl kömöta sileqeqe aka sihimbölö möta malinga morö kiaŋön mönö ölöp urukölalep neŋgimakŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noa asuhuiga nalö miaŋgöreŋök Lameknöŋ toroqeba yambuŋi 595 aiga nalö sutŋe miaŋgöreŋ nahönböratŋi tosatŋi asuhuba öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Öŋgögetka Lameknöŋ mala mala mal öŋgöba yambuŋi mindiriba 777 meköba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Lameknöŋ kömuiga nahönŋi Noa yaŋön yambuŋi 500 aiga nahönurupŋi karöbut qetŋini Sem, Ham aka Jafet asuhuget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ambazip gölme qakŋe malgetka qötöŋinan könahiba qariiga böraturupŋini mi mewöyök asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Asuhugetka nalö miaŋgöreŋ Anutugö nahönurupŋi yeŋön ambazip yeŋgö böraturupŋini eŋgeketka eksihimŋinambuk aketka eŋgek sorigeraŋgö dop mi pakpak eŋgömegetka anömurupŋini aket. ");
INSERT INTO bmu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Mewö aketka nalö miaŋgöreŋ Kembunöŋ keu kewö jiyök: “Gölme ambazipnöŋ silebuk nalö teteköŋi qahö mal öŋgömemö, yeŋön mönö kömume. Areŋini mewö al eŋgizal. Nalö kewöŋeyök könahiba malmalŋini mönö yambu 120 jaŋgö mi qahö oŋgita mal öŋgöme.” ");
INSERT INTO bmu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Anutugö nahönurupŋi yeŋön gölme ambazip yeŋgö böraturupŋini eŋgömegetka morö mem eŋgigetka nalö miaŋgöreŋ aka könaŋgep mewöyök azi weliwelipŋinambuk mönö asuhuba qariba gölmenöŋ malget. Möpŋaŋgö möpŋeyök bemurup qetbuŋaŋinambuk malgeri, yeŋön mönö mia aket. ");
INSERT INTO bmu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Gölme ambazip yeŋgö bölöŋamŋini mi keta bölökŋi aiga uruŋinaŋgö mötmöt areŋini pakpak mi nalö dop qösösök (qörörök) bölöŋanök pakpak aka malgeri, mi Kembunöŋ ehök. ");
INSERT INTO bmu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mi eka ambazip miwikŋaim eŋgiiga gölmenöŋ malgeri, miaŋgöra Anutunöŋ möt bölim aŋguiga wösöbiriknöŋ uruŋi kokolak qeiga sihimbölö möta malök. ");
INSERT INTO bmu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Mewö möta mala keu kewö jiyök: “Ambazip miwikŋaim eŋgiali, nöŋön mönö mi gölmenöhök qeteköm eŋgimam. Ambazip, mirigö sömbupŋi, yuai bapŋinan köla ölölöŋgömakzei aka könakembagö neiŋi mi miwikŋaim eŋgialaŋgöra möt bölim aŋguba mi mönö qeköm eŋgimam.” ");
INSERT INTO bmu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mewö jiyökmö, azi Noa yaŋön Kembugö jeŋe ak-kömukömu miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noagö gwölönarökurupŋi mieŋgö kösohotŋini mi kewö: Nahönurupŋi karöbut qetŋini Sem, Ham aka Jafet mi asuhuget. Noanöŋ ambazip sutŋine azi solanŋi köpösihitkö keuŋi qahö mala uruŋi Anutubuk jöhöba anda kaba malök. ");
INSERT INTO bmu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Noanöŋ mewö malökmö, ambazip tosatŋi pakpak yeŋön Anutugö jeŋe goŋgiba bölim tekögetka ambazip ayuhum eŋgieŋgi mi gölme körek dop köla ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ambazip pakpak gölmenöŋ anda kaba malmalŋini mem bölim tekögetka miri gölme pakpak yeŋgö ahakmemeŋini mi goŋgiba aŋgöjörakŋinambuk aiga Anutunöŋ gölme uba tandökŋini mi mewö ehök. ");
INSERT INTO bmu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mewö eka Anutunöŋ Noagöra keu kewö jii mörök: “Ambazip yeŋgöra aka ayuhum eŋgieŋgi mi gölme körek dop köla ahöza. Miaŋgöra nöŋön ambazip pakpak mem kömum teköm eŋgimamgöra mönö keuni jöhöyal. Mötnöŋ, nöŋön mönö onöŋ gölme meleŋbi geiga yuai pakpak isikusukŋinambuk mi kömum teköme. ");
INSERT INTO bmu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Miaŋgöra göŋön mönö suman ip köla miaŋön nangahöra waŋge kun meman. Miaŋgö uruŋi kutunöŋga uruŋi morömorö asuhume. Waŋgegö uruŋi aka sileŋi mi qandöŋnöŋ me gisak marasinöŋ kösiba ohom teköman. ");
INSERT INTO bmu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Waŋge mi kewö meman: köröpŋamŋi 133 mita (450 fit), andipŋi 22 mita (75 fit) aka köŋgepŋi 13 mita (45 fit) mewö meman. ");
INSERT INTO bmu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Boŋi muhungöba sel aka bo sutŋire liliköba jeŋgenaŋ tiŋi 44 sentimita (18 ins) mi mosöta kötohoman. Waŋgegö uruŋi mösöŋnöŋga uruŋi qakŋi, kembaŋi aka dutŋi karöbut asuhume. Waŋge naŋguŋi mi namŋe alman. ");
INSERT INTO bmu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mötman! Nöŋön mönö jibiga göulu ketaŋan kota gölme jömukŋi köl turuiga ambazip aka yuai malmalgö ösumŋinambuk pakpak suep bapŋe maljei, mieŋön mönö o nemba nemulahöba kömume. Mewö kömumba gölmegö yuai pakpak mi mönö qahöwak teköme. ");
INSERT INTO bmu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mewö asuhumapmö, nöŋön göbuk jöhöjöhö areŋ kewö akzal: Gi mönö waŋgenöŋ öŋgöman. Gi, anömgi aka nahöniranurupki eŋön mönö mohotŋe waŋgenöŋ öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Öŋgöba mala yuai malmalŋinambuk pakpak mi qahöwak teköbepuköra yeŋgöreŋök yahöt yahöt aziŋi aka ambiŋi mi dopŋine eŋguaŋgitnöŋga göbuk mohotŋe waŋgenöŋ öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Nei tandökŋini könaŋi könaŋi, mirigö sömbupŋi tandökŋini könaŋi könaŋi aka gölmegö mokoleŋ, lolohom yuai tandökŋini könaŋi könaŋi körek yeŋgöreŋök yahöt yahöt mi mönö kömumbepuköra eŋguaŋgitnöŋga göhöreŋ kaŋgotketka öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mewöyök nanŋini aka nei, sömbup yuai pakpak yeŋön nemeaŋgö dop mönö numbu nene könaŋi könaŋi miwikŋaiba otoŋ qezaköba waŋgenöŋ alnöŋga kahaimök ahöma.” ");
INSERT INTO bmu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Anutunöŋ Noa mewö akŋapkö jim kutum waŋgiiga miaŋgö dowök mönö tem köla mi pakpak ahök. Mewö mia aka mem teköyök. ");
INSERT INTO bmu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Noanöŋ waŋge mem teköiga Kembunöŋ keu kewö jii mörök: “Gi ambazip kambu kieŋgö sutŋine solanŋi aka maljan. Nöŋön göhö könaŋamgi mewö miwikŋaizal. Miaŋgöra gi aka saiwaurupki pakpak iŋini mönö waŋgenöŋ öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Sömbup neneŋi, dönqizizinŋini qahö mi pakpak yeŋgöreŋök sewen sewen, aziŋi 7 aka ambiŋi 7 dopdop eŋgömenöŋga göhöreŋ kaŋgotme. Mewöyök sömbup dönqizizinŋinambuk pakpak yeŋgöreŋök yahöt yahöt aziŋi aka ambiŋi mewö eŋgömenöŋga göhöreŋ kaŋgotme. ");
INSERT INTO bmu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Toroqeba nei könaŋi könaŋi pakpak yeŋgöreŋök mewöyök sewen sewen, aziŋi 7 aka ambiŋi 7 mi eŋguaŋgitnöŋga göbuk waŋgenöŋ öŋgöme. Mewö aknöŋga sömbup aka nei tandökŋini könaŋi könaŋi pakpak mi kude qahöwakŋemö, toroqeba gölmenöŋ ahumsehip aka malme. ");
INSERT INTO bmu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Öŋgögetka wehön 7 teköiga jim kutubiga kie römbum ketaŋan mönö gölmenöŋ eta yöhöiga suŋgem silim 40:gö dop toroqeba yöhöm teköma. Mewö yöhöiga yuai isikusukŋinambuk pakpak miwikŋaim eŋgiali, mi mönö mohotŋe jim teköbiga gölmenöhök qahöwakŋe.” ");
INSERT INTO bmu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kembunöŋ Noa mewö akŋapkö jim kutum waŋgiiga miaŋgö dowök mönö tem köla mi pakpak ak teköyök. ");
INSERT INTO bmu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Mewö mia aka meiga yambuŋi 600 aiga göulu ketaŋan gölme qakŋe kaŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Kaŋgotmapkö aiga Noa anömŋet aka nahöniranurupŋiri yeŋön mohotŋe göulunöŋ kömumbepuköra ölöŋ köla waŋgenöŋ öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Mewöyök sömbup neneŋi, dönqizizinŋini qahö aka sömbup dönqizizinŋinambuk aka nei aka yuai pakpak bapŋinan köla ölölöŋgömakzei, ");
INSERT INTO bmu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","mi yahöt yahöt pakpak aziŋi aka ambiŋi mi dopdopŋine waŋgenöŋ öŋgöba Noagöreŋ kaget. Anutunöŋ Noa jim kutum waŋgiyöhi, mi mönö miaŋgö dop asuhuyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mewö asuhuiga wehön 7:göra jiyöhi, mi teköiga göulu ketaŋan gölme qakŋe kaŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noanöŋ yambuŋi 600 aiga yambu miaŋgö köiŋi 2 miaŋgö wehönŋi jaŋgö 17 silim miaŋgöreŋ o jeŋi pakpak, o diginŋinambuk mieŋgö namŋini pakpak mi emuyök qariba qariba kotket. Mewöyök euyaŋgöreŋ könakembagö oŋi oŋi mieŋgö numbuŋini mi aŋaŋiget. ");
INSERT INTO bmu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kie römbum ketaŋi mi gölmenöŋ eta yöhöba yöhöba suŋgem silim 40:gö dop ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kienöŋ könahimapköra aiga wehön miaŋgöreŋ Noa aka nahönurupŋi Sem, Ham aka Jafet, Noagö anömŋet aka iranurupŋiri karöbut yeŋön mohotŋe waŋgenöŋ öŋgöm teköget. ");
INSERT INTO bmu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Toroqeba arökŋaŋgö sömbupŋi aka mirigö sömbupŋi pakpak, yuai pakpak bapŋinan köla ölölöŋgömakzei, nei pakpak aka yuai ginginŋinambuk pakpak mi ambazip yembuk mohotŋe waŋgenöŋ öŋgöm teköget. ");
INSERT INTO bmu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Anutunöŋ yuai pakpak malmalgö ösumŋinambuk miwikŋaim eŋgiyöhi, mieŋgöreŋök yahöt yahöt (2-2) mi Noagöreŋ kaŋgota waŋgenöŋ öŋgöm teköget. ");
INSERT INTO bmu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anutunöŋ Noa jim kutum waŋgiyöhaŋgö dop yuai isikusukŋinambuk pakpak waŋgenöŋ öŋgöm tekögeri, mi aziŋi aka ambiŋi ahot. Körekŋan öŋgöm tekögetka Kembunöŋ nanŋak Noagö andöŋe waŋgegö naŋguŋi kölök. ");
INSERT INTO bmu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Naŋguŋi köliga miaŋgöreŋök göulu ketaŋan könahiba suŋgem asak 40:gö dop toroqeba gölmenöŋ kaŋgoriga o yeŋön qariba qariba gölme köl turuba öŋgöba waŋge gölmenöhök koaŋgetka wahöta öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Öŋgöiga o yeŋön gölme qakŋe qariba qariba öŋgögetka waŋgenöŋ o qakŋe nanŋök öne laŋ anda kaba ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mewö aiga onöŋ gölme qakŋe kunbuk qariba öŋgöyök. Mewö kunduŋi köröpŋi köröpŋi suepkö bapŋe kin anjei, mi pakpak mönö musulumgöm eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Musulumgöm eŋgiba öŋgöba öŋgöba kunduŋi bohonŋi bohonŋi mi köl turuba 8 mita (25 fit) miaŋgö dop eŋgoŋgita ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Mewö ahöiga yuai isikusukŋinambuk pakpak gölme qakŋe anda kaba malgeri, mieŋön o nemba nemulahöba kömum teköget. Yuai pakpak mi nei me mirigö sömbupŋi me arökŋaŋgö sömbupŋi me mokoleŋ, gisip aka yuai pakpak kambuŋini köla gölmenöŋ qeqelaŋlaŋ anda kamakzei aka ambazip pakpak mi mohotŋe qahöwak teköget. ");
INSERT INTO bmu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Yuai pakpak gölme örönŋe mala malmalgö ösumŋi söŋgöröŋine öröba malgeri, mi körekŋanök kömum teköget. ");
INSERT INTO bmu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yuai malmalŋinambuk pakpak gölmenöŋ malgeri, mi Anutunöŋ eŋgum teköyök. Yuai pakpak mi ambazip, sömbup me yuai bapŋinan köla ölölöŋgömakzei me könakembagö neiŋi neiŋi mi mönö Anutunöŋ eŋgum teköyök. Noa aka saiwaurupŋi waŋge uruŋe malgeri, miyök mönö eŋgehoriba aŋgön köla gou köl eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","O göulu miaŋön gölme köl turuba qahö öröba geyökmö, wehön 150:gö dop ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Wehön 150 mi teköiga miaŋgöreŋ Anutunöŋ Noagö aka arökŋaŋgö mirigö sömbupŋi aka yuai pakpak yambuk waŋgenöŋ malgeri, mi mötmörim eŋgiba luhut ketaŋi röja aliga gölme qakŋe qeiga onöŋ könahiba öröba erök. ");
INSERT INTO bmu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Anutunöŋ emune o diginŋinambuk yeŋgö jeŋini aka euyaŋgöreŋ könakembagö oŋi oŋi mieŋgö numbuŋini mi qaliba soŋgo aliga kienöŋ tiŋgita tömböriba suepnöhök kunbuk qahö erök. ");
INSERT INTO bmu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Qahö eriga o ketaŋan könahiba gölme qakŋe ahöahöŋeyök liliŋgöba öröba eta geyök. Wehön 150:gö dop o mieŋön öröba eta geba ahöget. ");
INSERT INTO bmu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Mewö ahögetka waŋgenöŋ köiŋ 7 miaŋgö silimŋi 17 miaŋgöreŋ kunduŋi qetŋi Ararat miaŋgö bohonŋi kunöŋ mekötahöba köhöiba tarök. ");
INSERT INTO bmu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Miaŋgöreŋ tariga o miaŋön toroqeba öröba eta eta anök. Anda köiŋ 10 miaŋgö silimŋi mutukŋi miaŋgöreŋ kunduŋi mieŋgö bohonŋini mi aukŋe asuhum tiŋgitket. ");
INSERT INTO bmu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tiŋgitketka wehön 40 teköiga Noanöŋ waŋgegö jeŋgenaŋi mutuk memeŋi mi metalök. ");
INSERT INTO bmu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Metala koekoe nei kun melaiiga könakemba laŋ bölbölgöba anda kaba qahö liliŋgöba maliga gölmegö oŋi miaŋön jöpköyök. ");
INSERT INTO bmu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Miaŋgö andöŋe Noanöŋ kembö kun melaiiga anök. Gölme qakŋe onöŋ öröba geyök me qahö, miaŋgö könaŋi mötmamgöra mi melaiiga anök. ");
INSERT INTO bmu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kembönöŋ anda kaba onöŋ toroqeba gölme körekŋanök turuba ahöyöhaŋgöra luhut memeŋaŋgö tatatŋi qahö miwikŋaiba waŋgegöreŋ liliŋgöiga Noanöŋ böröŋi böraŋda waŋge uruŋe waŋgiriga öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Öŋgöiga wehön 7:gö dop toroqeba mamböt mala miaŋgöreŋ kembö mi kunbuk waŋgenöhök melaiiga anök. ");
INSERT INTO bmu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Anda mare miaŋgöreŋ liliŋgöba oil ipkö sinŋi gwölögwölö kun mi meteköba numbuŋan yöhösaŋda Noagöreŋ kayök. Mewö kaiga Noanöŋ mi eka kewö möt asariyök: Onöŋ mönö öröba eriga gölmenöŋ asuhum teköza. ");
INSERT INTO bmu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mi möt asariba kunbuk wehön 7:gö dop mamböta kinda kembö mi kunbuk melaiiga bölbölgöba anök. Anökmö, nalö miaŋgöreŋ mi yaŋgöreŋ kunbuk qahö liliŋgöba kayök. ");
INSERT INTO bmu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noagö malmal yambuŋi 601 miaŋgö köiŋ mutukŋaŋgö silimŋi mutukŋi miaŋgöreŋ onöŋ gölme qakŋe jöpköba öröniba ahöyök. Mewö aiga Noanöŋ waŋgegö boŋi mei aniga kewö uba ehök: Gölme qakŋan mönö öröniba ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mi ehi kunbuk öröniba köiŋ yahötŋaŋgö silimŋi 27 miaŋgöreŋ örönim teköba ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Anutunöŋ Noagöra keu kewö jiba jii mörök: ");
INSERT INTO bmu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Gi, anömgi aka nahöniranurupki iŋini mönö waŋge mosöta etket. ");
INSERT INTO bmu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Eta sömbup yuai malmalŋinambuk pakpak göbuk waŋgenöŋ maljei, mi neiŋi neiŋi, mirigö sömbupŋi aka mokoleŋ yuai pakpak bapŋini gölmenöŋ köla ölölöŋgömakzei, mi mönö körek eŋguaŋgita etket. Mewö aknöŋga ölöp gölmenöŋ ahum sehiba gwölönarökpuk aka deŋda gölme dop köla malme.” ");
INSERT INTO bmu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Mewö jii möta Noa anömŋet aka nahöniranurupŋi yeŋön mohotŋe waŋge mosöta etket. ");
INSERT INTO bmu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Etketka arökŋaŋgö sömbupŋi pakpak, mokoleŋ yuai pakpak, nei pakpak aka yuai pakpak gölmenöŋ anda kamakzei, mieŋön mönö mewöŋanök isikŋinaŋgö dop waŋge mosöta awataŋgöba et teköget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Et tekögetka Noanöŋ Kembugöra jöwöwöl alta kun memba mirigö sömbupŋi dönqizizinŋini qahö mi pakpak aka nei dönqizizinŋini qahö mi pakpak yeŋgöreŋök tosatŋi eŋgömemba alta qakŋe ala miaŋön Anutugöra jöwöwöl ohoyök. ");
INSERT INTO bmu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ohoiga Kembunöŋ wörön umköhöwakŋi nahömŋambuk mi möri dop köliga uruŋan keu kewö jiyök: “Ambazip yeŋgö uruŋinaŋgö mötmöt areŋinan mönö moröŋineyök könahiba bölöŋi akzemö, töndup gölme mi nalö kunöŋ ambazipköra aka kunbuk kude qesuahömam. Yuai pakpak malmalŋinambuk maljei, nöŋön mi lök qahöwak teköm eŋgialmö, miaŋgö dop nalö kunöŋ kunbuk qahö jim teköba ak eŋgimam. ");
INSERT INTO bmu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Gölmenöŋ ahöm öŋgömawaŋgö dop mönö gölmenöŋ köl kömötketka ölŋi asuhui megetka miaŋön mönö kude qahöwak teköma. Miri amöriiga saŋgenŋi mörakŋe aka könöpŋambuk aiga könöwiba mörakŋe. Kömunjaŋ kie nalö aka wehön nalö, suŋgem aka asakŋi mi nalöŋi nalöŋi lilikqilik aka awataŋ ahöba anmahot. Mi pakpak teteköŋi qahö ahöm öŋgöiga malme. Mewöŋan mönö mewö toroqeba ahöma. “Mewö”. ");
INSERT INTO bmu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mewö jiba Anutunöŋ Noa aka nahönurupŋi kewö jiba kötuetköm eŋgiyök: “Iŋini mönö ahum sehiba gwölönarökpuk mala gölme dop köla malme. ");
INSERT INTO bmu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mewö aketka gölmegö sömbupŋi pakpak, könakembagö neiŋi pakpak, yuai pakpak bapŋinan gölme köla ölölöŋgömakzei aka köwetkö söraŋi pakpak mi mönö eŋgö böröŋine al eŋgibi eŋön mi galöm köl eŋgiba malgetka yeŋön eŋgöra keŋgöt mötmöt aketka jönömŋini unduiga malme. ");
INSERT INTO bmu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Yuai pakpak isikusukŋinambuk anda kaba maljei, mi eŋgö neneya aka ahöma. Mutuk yöha yuai görökŋi (töŋgönŋi) neneŋina al eŋgiala merak yuai pakpak ki mewöyök al eŋgizal. ");
INSERT INTO bmu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mohok-kun mi mönö kude neme. Mi sömbup sepŋambuk. Sep mi malmalgö söpsöpŋi akzawaŋgöra aka soŋgo ki al eŋgizal. ");
INSERT INTO bmu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nanŋini sepŋini mi kunŋan kun kude mokoma. Kunŋan mi mokomawi, miaŋgö likepŋan mönö nanŋi qakŋe öŋgöma. Sömbup kunŋan me ambazip kunŋan ambazip kun qeiga malmalŋaŋgö söpsöpŋi mokomawi, miaŋgö likepŋan mönö nanŋi qakŋe öŋgöiga kömuma. ");
INSERT INTO bmu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Anutunöŋ ambazip nanŋi kaisoŋgolomŋi tandök meyöhaŋgöra aka kun daŋön ambazip kun qei kömumawi, kunŋan mönö i mewöŋaŋök qei kömuma. ");
INSERT INTO bmu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Iŋini mönö ahum sehiba gwölönarökpuk aka malme. Mewö gölme qakŋe ahum sehigetka qötöŋinan qarim öŋgöma.” ");
INSERT INTO bmu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Anutunöŋ toroqeba Noa aka nahönurupŋi yambuk malgeri, yeŋgöra keu kewö jiyök: ");
INSERT INTO bmu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nöŋön merak iŋini aka eŋgö gwölönarökurupŋini könaŋgep asuhumei, embuk jöhöjöhö areŋ akzal. ");
INSERT INTO bmu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Mewöŋanök yuai malmalŋinambuk pakpak, mi mirigö me arökŋaŋgö nei sömbupŋi pakpak göbuk mala waŋgenöhök etkeri, mönö gölmegö öröyuai malmalŋinambuk pakpak yembuk jöhöjöhö areŋ kewö akzal: ");
INSERT INTO bmu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nöŋön jöhöjöhö areŋni mi embuk kewö al köhöizal: Nöŋön o göulunöŋ öröyuai isikusukŋinambuk pakpak mi kunbuk kude eŋgubi qahöwakŋe. O göulu mi gölme ayuhumapköra kunbuk qahö albi kama.” ");
INSERT INTO bmu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Anutunöŋ toroqeba keu kewö jiyök: “Nöŋön mönö jöhöjöhö areŋ ki mi nani aka iŋini aka öröyuai malmalŋinambuk pakpak embuk maljei, neŋgö sutnine albiga teteköŋi qahö köhöiba ahöm öŋgöma. Jöhöjöhö areŋ miaŋgö aiwesökŋi mi kewö: ");
INSERT INTO bmu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nöŋön nani mariloŋloŋni mi kousunöŋ albiga ahöma. Nöŋön nani aka gölmenöŋ maljei, neŋgö sutnine jöhöjöhö areŋ akzali, mariloŋloŋ miaŋön mönö miaŋgö aiwesökŋi aka ahöma. ");
INSERT INTO bmu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Nöŋön nalö kunöŋ kousuŋi kousuŋi gölme qakŋe öröm eŋgibi eta tokogetka mariloŋloŋan kousunöŋ asuhumawi, ");
INSERT INTO bmu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nalö miaŋgöreŋ nöŋön jöhöjöhö areŋni mi mötmörimam. Mi nani aka iŋini aka öröyuai malmalŋinambuk pakpak tandökŋini könaŋi könaŋi neŋgö sutŋine ahali, mönö mia mötmörimam. Miaŋgöra o mieŋön kunbuk mewö kude qariba yuai isikusukŋinambuk pakpak ayuhumegöra göulu ketaŋi qahö akŋa. ");
INSERT INTO bmu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nalö kunöŋ mariloŋloŋan kousunöŋ asuhumawi, nöŋön mi eka miaŋgöreŋök jöhöjöhö areŋni mi mötmörimam. Mi teteköŋi qahö nani aka öröyuai malmalŋinambuk pakpak tandökŋini könaŋi könaŋi gölme qakŋe maljei, neŋgö sutnine al köhöibi ahöza.” ");
INSERT INTO bmu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Anutunöŋ Noagöra mewö jiba toroqeba kewö jiyök: “Nöŋön jöhöjöhö areŋ ki mi nani aka gölmegö öröyuai malmalŋinambuk pakpak neŋgö sutnine al köhöizal. Jöhöjöhö areŋ miaŋgö aiwesökŋi mi mewö.” ");
INSERT INTO bmu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noagö nahönurupŋi waŋgenöhök etkeri, yeŋgö qetŋini mi Sem, Ham aka Jafet. Ham mi Keinangö iwiŋa. ");
INSERT INTO bmu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Yeŋön Noagö nahönurupŋi karöbut aket. Ambazip pakpak deŋqeŋda gölme dop köla maljini, nini yeŋgöreŋök asuhuin. ");
INSERT INTO bmu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noanöŋ kölkömöt azia aka wain kösö nup mutukŋi kömörök. ");
INSERT INTO bmu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mi kömörökmö, nalö kunöŋ wain o tosatŋi memba neiga uruŋi eŋololoŋ aiga nanŋi opo seri koum uruŋe opoŋi qeköba sile aukŋe ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Keinangö iwiŋi Ham yaŋön iwiŋan sile aukŋe ahöyöhi, mi eka yaigep geba darumunyahötŋi jii mörohotka iwiŋi mewö gamu qem waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem aka Jafet yetkön mi mörohotmö, maluku kun memba awötŋire ala andöandö öŋgöba iwiŋiran sile aukŋe ahöyöhi, mi esuhuyohot. Jeŋiri kungen uyohoraŋgöra aka iwiŋiran aukŋe ahöyöhi, mi qahö ehot. ");
INSERT INTO bmu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noanöŋ eŋololoŋ aiga imbiŋi törörök möta wahöta nahönŋi moröŋan silik ak waŋgiyöhi, mi mörök. ");
INSERT INTO bmu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Mi möta uruŋi öngöiga Hamgöra kewö jiyök: “Keinan mi jim suehöm waŋgizal. Yaŋön mönö darumunyahötŋi yetkö welenqeqeurupŋiri yeŋgö welenqeqeŋini omaŋi aka malma.” ");
INSERT INTO bmu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Toroqeba kewö jiyök: “Anutu, Semgö Kembuŋi, ia mönö möpöseizal. Keinanöŋ mönö Semgö welenqeqeŋi omaŋi aka malma. ");
INSERT INTO bmu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Anutunöŋ mönö Jafetkö gölmeŋi mem qariiga Semgö opo seri koumŋine malme. Keinan yeŋön mönö Sem yeŋgö welenqeqeurupŋini omaŋi aka malme.” ");
INSERT INTO bmu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Göulu ketaŋan teköiga Noanöŋ toroqeba (yara) yambu 350:gö dop mal öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Malmalŋaŋgö yambuŋi mi mindiriba 950 miaŋgö dop mala kota kömuyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noagö nahönurupŋi Sem, Ham aka Jafet yeŋgö gwölönarökurupŋini göulu teköiga asuhugeri, yeŋgö qet areŋini kewö: ");
INSERT INTO bmu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafetkö nahönurupŋi yeŋgö qetŋini mi Gomer, Magog, Madai, Jawan, Tubal, Mesek aka Tiras. ");
INSERT INTO bmu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomergö nahönurupŋi yeŋgö qetŋini mi Askenas, Rifat aka Togarma. ");
INSERT INTO bmu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Jawangö nahönurupŋi yeŋgö qetŋini mi Elisa, Tarsis aka Saiprus könagesö aka Dodan könagesö. ");
INSERT INTO bmu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yeŋgö isimoröurupŋini mi jula deŋqeŋda Sutŋire Köwetkö jitŋe aka miaŋgö gölme jöhanŋi jöhanŋi miaŋgöreŋ nanŋini gölmeŋine anda malje. Yeŋön isikŋini dop, kambuŋini dop aka keuŋini dop nanŋini gölmeŋine anda malje. Jafetkö könagesöŋi mewö. ");
INSERT INTO bmu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamgö nahönurup yeŋgö qetŋini mi Kus, Ijipt, Libia aka Keinan. ");
INSERT INTO bmu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusgö nahönurupŋi yeŋgö qetŋini mi Seba, Hawila, Sabta, Rama aka Sabteka. Ramagö nahönyahötŋi yetkö qetŋiri mi Seba aka Dedan. ");
INSERT INTO bmu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusgö nahönŋi kun qetŋi Nimrod asuhuyök. Yaŋön qariba wahöta bimqeqegö suahö azi köhöikŋi kötökŋi aka gölmenöŋ malök. ");
INSERT INTO bmu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yaŋön Kembugö jemesoholŋe böröjaŋ azi köhöikŋi malöhaŋgöra aka keu saiŋi kewö jimakze: “Kunöŋ Nimrod ewö Kembugö jemesoholŋe böröjaŋ azi köhöikŋi akza.” ");
INSERT INTO bmu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrodkö bemtohoŋi mi gölme kewöŋe miaŋgöreŋ könahiget: Babel, Erek, Akad aka Kalne. Taon 4 mi Babilonia (Sinar) gölmenöŋ ahöze. ");
INSERT INTO bmu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrodnöŋ Babilonia gölme mosöta Asiria anda miri ketaŋi ketaŋi qetŋini Niniwe, Rehobotir aka Kala mi mem wahörök. ");
INSERT INTO bmu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Mewöyök Resen mi Niniwe aka siti ketaŋi qetŋi Kala yetkö sutŋire mem wahörök. ");
INSERT INTO bmu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ijiptkö gwölönarökurupŋi yeŋön Libia könagesö, Anam könagesö, Lehab könagesö aka Naftu könagesö akze. ");
INSERT INTO bmu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Mewöyök Patrus, Kaslu aka Krit. Krit mi Filistia könagesö yeŋgö bömönŋini ahök. ");
INSERT INTO bmu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Keinangö nahönŋi mutukŋi mi Saidon. Yaŋgö andöŋe Keinanöŋ könagesö kewöŋi yeŋgö bömönŋini ahök: Hit könagesö, ");
INSERT INTO bmu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebus könagesö, Amor könagesö, Girgas könagesö, ");
INSERT INTO bmu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi könagesö, Arka könagesö, Sini könagesö, ");
INSERT INTO bmu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwad könagesö, Zemar könagesö aka Hamat könagesö. Keinanöŋ körek pakpak yeŋgö iwi bömönŋini aiga yeŋön könaŋgep jula deŋqeŋget. ");
INSERT INTO bmu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mewö deŋqeŋgetka Keinan könagesö yeŋgöreŋ gölme göraŋi mi miri qetŋi Saidon miaŋgöreŋök könahiba anda Gerar mire anda Gaza miaŋgöreŋ teköza. Mewöyök Sodom göröken anda Gomora anda Adma aka Zeboim anda Lasa miaŋgöreŋ teköza. ");
INSERT INTO bmu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hamgö nahönurupŋi mi isikŋini dop, keuŋini dop, gölmeŋini dop aka könagesö kambuŋini dop mewö malje. ");
INSERT INTO bmu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafetkö datŋi Sem yaŋgö nahönurupŋi mewöŋanök asuhuget. Semnöŋ mewö Ebergö nahönurup pakpak yeŋgö bömönŋini ahök. ");
INSERT INTO bmu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semgö nahönurupŋi yeŋgö qetŋini mi Elam, Asur, Arfaksad, Lidia (Lud) aka Aram. ");
INSERT INTO bmu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramgö nahönurupŋi yeŋgö qetŋini mi Uz, Hul, Geter aka Mas. Mewö malget. ");
INSERT INTO bmu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksadkö nahönŋi Sela asuhuiga yaŋgö nahönŋi Eber asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebergö nahönyahötŋi yahöt asuhuyohot. Kunöŋ asuhuba mala koröhi, nalö miaŋgöreŋ gölme ambazipnöŋ jula deŋqeŋget. Miaŋgöra yaŋgö qetŋi Peleg (Deŋqeŋ) qetket. Munŋaŋgö qetŋi mi Joktan. ");
INSERT INTO bmu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktangö nahönurupŋi kewö asuhuget: Almodad, Selef, Hazarmawet, Jera, ");
INSERT INTO bmu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO bmu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO bmu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila aka Jobab. Azi pakpak mi Joktangö nahönurupŋa. ");
INSERT INTO bmu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Yeŋgö tatat malmal gölmeŋini mi miri qetŋi Mesa miaŋgöreŋök könahiba miri qetŋi Sefar miaŋgöreŋ göröken anda wehön kotkotŋaŋgö gölme kunduŋambuk miaŋgöreŋ teköza. ");
INSERT INTO bmu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Semgö nahönurupŋi mi isikŋini dop, keuŋini dop, gölmeŋini dop aka könagesö kambuŋini dop mewö malje. ");
INSERT INTO bmu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Noagö isimoröurupŋi mi isikurup areŋini, könagesöŋini aka gölmeŋini dop mewö aket. Yeŋön jul sehiba deŋqeŋda könagesö kambuŋi kambuŋi aketka göulu ketaŋan teköiga anda gölme dop köla malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mutuk miaŋgöreŋ gölmeŋi gölmeŋi pakpak yeŋön keu mohot jigetka miaŋön mindirim eŋgii malget. ");
INSERT INTO bmu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mewö mala mosöta wehön kotkotŋe göröken anda Babilon uruŋe gölme köröŋi ketaŋi kun miwikŋaiba miaŋgöreŋ miriŋini memba tatket. ");
INSERT INTO bmu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Miaŋgöreŋ tata nanŋinök kewö eraum-mötket: “Mönö kaget. Nini mönö birik mem mözözömgöba könöpnöŋ ohoinga köhöikŋi akŋe. “Mewö jiba miri selŋi membingöra köt jamönjiŋ qahöpmö, birik ala sutŋine gölme sapösapö qandöŋ ewö algetka miaŋön birik mi mekötahöm eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nup mewö memba kunbuk kewö jiget: “Mönö kaget. Nini mönö naninaŋgöra siti kun memba miaŋgöreŋ miri köröpŋi kötökŋi (taua) meinga boŋan suep oseima. Mewö oseiiga qahö deŋqeŋda gölme pakpak dop köla laŋ anda malbinbuköra mönö nanini qetbuŋaninambuk akin.” ");
INSERT INTO bmu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mewö jiba nup megetmö, Kembunöŋ ambazip siti aka miri köröpŋi megeri, mi ekŋamgöra erök. ");
INSERT INTO bmu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Eta mi eka kewö jiyök: “Yeŋön simbisembel qahöpmö, urumohot könagesö aka keuŋini mohot jiba kinda yuai ki könahiba meze ewö, könaŋgep i me wai membingö areŋini albeak, mi mönö miaŋgöra qahö osiba qaköme. ");
INSERT INTO bmu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ayop, nini mönö gölmenöŋ geba keuŋini mem sohoinga kambu kun yeŋön kambu tosatŋi yeŋgö keuŋini qahö möt asariba malme.” ");
INSERT INTO bmu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kembunöŋ mewö jiba ambazip miaŋgöreŋ mendeŋqendeŋ eŋgiiga gölme körek dop köla anda kaba siti memegö nupŋi jöhöba mosötket. ");
INSERT INTO bmu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kembunöŋ ambazip pakpak yeŋgö keuŋini mem sohoyöhi, miaŋgöra miri miaŋgö qetŋi Babel (eŋololoŋ siksauk) ahök. Miaŋgöreŋök Kembunöŋ i mendeŋqendeŋ eŋgiiga deŋda gölme pakpak dop köla anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semgö gwölönarökurup yeŋgö qet areŋini ki. Göulu andöŋe yambu yahöt teköiga Semnöŋ yambuŋi 100 aiga nalö miaŋgöreŋ nahönŋi Arfaksad asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arfaksadnöŋ asuhuiga miaŋgö andöŋe Semnöŋ toroqeba yambu 500 maliga nalö sutŋe miaŋgöreŋ nahönböraturupŋi tosatŋi asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksadnöŋ yambuŋi 35 aiga nahönŋi Sela asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Selanöŋ asuhuiga miaŋgö andöŋe Arfaksadnöŋ toroqeba yambu 403 maliga nalö sutŋe miaŋgöreŋ nahönböraturupŋi tosatŋi asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selanöŋ yambuŋi 30 aiga nahönŋi Eber asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebernöŋ asuhuiga miaŋgö andöŋe Selanöŋ toroqeba yambu 403 maliga nalö sutŋe miaŋgöreŋ nahönböraturupŋi tosatŋi asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebernöŋ yambuŋi 34 aiga nahönŋi Peleg asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelegnöŋ asuhuiga miaŋgö andöŋe Ebernöŋ toroqeba yambu 430 maliga nalö sutŋe miaŋgöreŋ nahönböraturupŋi tosatŋi asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegnöŋ yambuŋi 30 aiga nahönŋi Reu asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reunöŋ asuhuiga miaŋgö andöŋe Pelegnöŋ toroqeba yambu 209 maliga nalö sutŋe miaŋgöreŋ nahönböraturupŋi tosatŋi asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reunöŋ yambuŋi 32 aiga nahönŋi Serug asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugnöŋ asuhuiga miaŋgö andöŋe Reunöŋ toroqeba yambu 207 maliga nalö sutŋe miaŋgöreŋ nahönböraturupŋi tosatŋi asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugnöŋ yambuŋi 30 aiga nahönŋi Nahor asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahornöŋ asuhuiga miaŋgö andöŋe Serugnöŋ toroqeba yambu 200 maliga nalö sutŋe miaŋgöreŋ nahönböraturupŋi tosatŋi asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahornöŋ yambuŋi 29 aiga nahönŋi Tera asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teranöŋ asuhuiga miaŋgö andöŋe Nahornöŋ toroqeba yambu 119 maliga nalö sutŋe miaŋgöreŋ nahönböraturupŋi tosatŋi asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teranöŋ yambuŋi 70 aiga nahönŋi Abram, Nahor aka Haran asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teragö gwölönarökurup yeŋgö qet areŋini ki. Teragö nahönurupŋi Abram, Nahor aka Haran asuhuget. Harangö nahönŋi Lot asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haranöŋ Kaldia yeŋgö gölmenöŋ mala nanŋi ahuahu miriŋi qetŋi Ur miaŋgöreŋ kömuiga Harangö iwiŋi Teranöŋ toroqeba malök. ");
INSERT INTO bmu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram aka Nahor yetkön öröröŋ ambi meyohot. Abramgö anömŋi qetŋi Sarai aiga Nahorgö anömŋi qetŋi Milka. Milkanöŋ Harangö böratŋa ahök. Haranöŋ Milka aka Iska yetkö iwiŋiri ahök. ");
INSERT INTO bmu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarainöŋ ambi köpina moröŋi qahöpmö, öne malök. ");
INSERT INTO bmu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teranöŋ nahönŋi Abram, isiŋi Lot Harangö nahönŋi aka iranŋi Sarai, nahönŋi Abramgö anömŋi mi eŋguaŋgiriga mohotŋe Kaldia gölmegö miri qetŋi Ur mosöta Keinan gölmenöŋ anbingöra anget. Mewö angetmö, Haran miri gölmenöŋ kaba kinda miaŋgöreŋ miriŋini memba tatket. ");
INSERT INTO bmu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tatketka Teranöŋ yambuŋi 205 aiga Haran miri miaŋgöreŋ tata kömuyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kembunöŋ Abramgöra kewö jiyök: “Gi gölmegi, könagesögi aka iwigahö miri yuaiŋi mosöta gölme kondel gihimami, mönö miaŋgöreŋ anman. ");
INSERT INTO bmu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nöŋön ahumsehip gihibiga gwölönarökurupkan könagesö ketaŋi akŋe. Nöŋön kötuetköba naŋgöm gihibiga qetbuŋagan qariba ketaŋi akŋa. Mewö aiga Anutunöŋ göhöra aka könagesö tosatŋi kötuetköm eŋgiba malma. ");
INSERT INTO bmu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Denike yeŋön gi kötuetköm gihimei, nöŋön mönö i kötuetköm eŋgiba malmam. Denike yeŋön gi jim suehöm gihimei, nöŋön mönö i mewöyök jim suehöm eŋgiba malmam. Göhöra aka nöŋgö kötumötuetnan mönö gölmegö könagesö kambuŋi pakpak yeŋgö qakŋine öŋgöiga oyaeŋkoyaeŋ akŋe.” ");
INSERT INTO bmu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Mewö jiiga Abramnöŋ Kembunöŋ jiyöhaŋgö dop Haran miri mosöta aniga Lotnöŋ yambuk anohot. Abramnöŋ yambuŋi 75 aiga miaŋgöreŋ Haran miri mosöta anök. ");
INSERT INTO bmu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Anmam jiba anömŋi Sarai, behötŋi Lot, sukinapŋi pakpak qezakögetka sehiyöhi aka welenqeqe ambazip Haran mirinöŋ mala eŋgömegeri, mi memba eŋguaŋgita mosöta Keinan gölmenöŋ anbingöra anda mala miaŋgöreŋ aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramnöŋ gölme miaŋgöreŋ anda mala mala miri qetŋi Sekem miaŋgöreŋ kaŋgota in ip ketaŋi qetŋi More miaŋgö kösutŋe koumŋi qeba tarök. Nalö miaŋgöreŋ Keinan ambazip yeŋön lök gölme miaŋgöreŋ malget. ");
INSERT INTO bmu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mewö malgetka Kembunöŋ Abramgöreŋ asuhuba kewö jiyök: “Gölme ki mi mönö göhö gwölönarökurupki yeŋgö buŋaya qem eŋgimam. “Mewö jiiga Abramnöŋ Kembu yaŋgöreŋ asuhuyöhi, yaŋgöra jöwöwöl ohohogö altaŋi kun miaŋgöreŋ meyök. ");
INSERT INTO bmu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Miaŋgöreŋök mosöta toroqeba Betel mirigö wehön kotkotŋe göröken gölme kunduŋambuk miaŋgöreŋ anda opo seri koumŋi möröreŋgöba kuŋgui kinök. Mewö kiniga Betel miri miaŋön wehön gegeŋe göröken tariga Ai taonöŋ wehön kotkotŋe göröken tarök. Mewö tarohotka sutŋire kinda Kembugö jöwöwöl altaŋi kun miaŋgöreŋ memba Kembugö qetŋi qeta köuluköm waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Miaŋgö andöŋe gölme mi mosöta toroqeba Saut göröken anda distrik qetŋi Negew miaŋgöreŋ tata malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nalö miaŋgöreŋ Keinan gölmenöŋ bödi (buörö) asuhuiga miaŋön köhöiba lömbötŋi aiga Abramnöŋ Ijipt kantrinöŋ kusukŋanök malbingöra anget. ");
INSERT INTO bmu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Könanöŋ anda Ijipt dopdowigetka Abramnöŋ miaŋgöreŋ anömŋi Saraigöra keu kewö jiyök: “Mötnöŋ, göŋön ambi eksihimgabuk akzani, mi mötzal. ");
INSERT INTO bmu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mewögöra Ijipt azi yeŋön gi geka kewö jime: ‘Ki yaŋgö anömŋa.’ Mewö jiba ni nuŋguget kömumam-mö, gi gehorigetka malman. ");
INSERT INTO bmu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Miaŋgöra göŋön mönö kewö jiman: ‘Ni yaŋgö nenŋa.’ Mewö jinöŋga göhöra aka ölöpŋanök ak niŋgiba nöŋgö malmalni gou kölgetka malmam.” ");
INSERT INTO bmu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abramnöŋ Ijipt kaiga Ijiptkö ambazipŋi yeŋön Sarai eketka ambi eksihimŋambuk qetpuk ahök. ");
INSERT INTO bmu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Miaŋgöreŋök Farao kiŋ kembugö pom jembonurupŋi yeŋön i ekeraŋgöra Farao kiŋgöreŋ anda Saraigö sileŋi möpöseigetka mörök. Mi möta jiiga Sarai waŋgita kiŋ kembugö jakömbuak miri uruŋe öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Öŋgögetka Farao kiŋnöŋ Saraigöra aka Abram ölöpŋanök ak waŋgiyök. Mewö ak waŋgiiga yuai kewöŋi mi Abramgö buŋaya ahök: lama, bulmakau, doŋki aziŋi aka ambiŋi, welenqeqe azi aka ambi aka kamel jesöŋgöŋi mi Abram waŋgiiga buŋa qem aŋguyök. ");
INSERT INTO bmu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mi buŋa qem aŋguyökmö, Kembunöŋ Abramgö anömŋi Sarainöŋ Farao kiŋgö mire malöhaŋgöra aka jiiga kawöl bölöŋi kötökŋan Farao kiŋ aka ambazip yaŋgö jakömbuak mire malgeri, yeŋgö qakŋine öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Mi öŋgöiga Farao kiŋnöŋ Abram köl öröi kaiga kewö qesim waŋgiyök: “Göŋön mönö wani kimbia ak niŋginöŋ? Wuanöŋgöra ‘Mi anömna,’ mewö qahö jinöŋga möral? ");
INSERT INTO bmu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Wuanöŋgöra ‘I mi nena,’ jinöŋ? Mewö jinöŋga nöŋön i anömna akŋapköra waŋgiral? Anömgi ki. Mönö i waŋgita anohot.” ");
INSERT INTO bmu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Mewö jiba aziurupŋi jim kutum eŋgiiga Abram waŋgita könanöŋ anda al eŋgigetka anömŋi aka öröyuaiŋi pakpak ahöm waŋgiyöhi, mi memba eŋguaŋgita anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramnöŋ Ijipt gölme mosöta anömŋi aka bau inap yuaiŋi pakpak memba eŋguaŋgita Lotpuk mohotŋe liliŋgöba anda Keinan gölmegö Saut likepŋi qetŋi Negew miaŋgöreŋ kaŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramgöreŋ lama bulmakau aka goul silwö mi lömbötpuk ahöm waŋgiiga azi kindiŋbirik malök. ");
INSERT INTO bmu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mewö mala Negew distrik uruŋe tata mosöta kusukŋanök rowoŋqeqeŋine ahöba wahöta anda mala Betel mire kaŋgotket. Opo seri koumŋi mutuk Betel aka Ai miri mietkö sutŋire kuŋgui kinöhi, mönö miaŋgöreŋ kaŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Mutuk jöwöwöl alta meyöhi, mönö miaŋgöreŋ kaŋgota Kembugö qetŋi qeta köuluköyök. ");
INSERT INTO bmu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lotnöŋ Abrambuk tata mosöta malöhi, yaŋön mewöŋanök lama bulmakau kambuŋi kambuŋi aka opo seri koumŋi koumŋi mi gwötpuk memba malök. ");
INSERT INTO bmu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Mewö mala sömbup sukinap yuaiŋiri gwötpuk ketaŋi ahöm etkiiga gölmenöŋ qahö dop kölök. Mi öröröŋ gumohom eŋgieŋgigö dop qahö ahöiga mohotŋe tata malmalgö lömböriba osiyohot. ");
INSERT INTO bmu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Osiba Abram aka Lot yetköreŋ sömbup galömurupŋiri yeŋgö sutŋine gölmegö aŋgururuk asuhuyök. Nalö miaŋgöreŋ Keinan könagesö aka Periz könagesö yeŋön gölme miaŋgö toŋi aketka yembuk mohotŋe malget. ");
INSERT INTO bmu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Mewö mala Abramnöŋ Lotköra kewö jii mörök: “Niri mönö iwi moröya maljit. Miaŋgöra ni aka gi sutnire me sömbup galömurupniri yeŋgö sutŋine aŋgururuk kude ahöma. ");
INSERT INTO bmu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Miaŋgöra ölöp deŋbit. Gölme pakpak mönö göhö jemesoholge aukŋe ahöm anjawi, mi ölöp ekzan. Mewö aiga göŋön qaninire göröken anmam jiman ewö, nöŋön ölöp ölnire göröken anmam. Me göŋön ölnire göröken anmam jiman ewö, nöŋön ölöp qaninire göröken anmam.” ");
INSERT INTO bmu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Mewö jiiga Lotnöŋ uba wahöta Jordangö gölme köröŋi ketaŋi pakpak ehiga Anutunöŋ mi ölöp mem kelöriga Kembugöreŋ oyaeŋkoyaeŋ arö kelökŋambuk ewö ahök. Mi Ijipt yeŋgö gölme ewö ahöba Zoar miri göröken anök. Mutuk Kembunöŋ Sodom aka Gomora qahö ayuhum etkiiga nalö miaŋgöreŋ gölme mi mewö ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Mewö ahöiga Lotnöŋ mi ek kewöta Jordangö gölme köröŋi ketaŋi pakpak mi möwölöhöba wehön kotkotŋe göröken anök. Mewö aka deŋnohot. ");
INSERT INTO bmu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Deŋda Abramnöŋ Keinan gölmenöŋ anda malökmö, Lotnöŋ gölme köröŋi ketaŋaŋgö taonŋi taonŋi yeŋgö sutŋine anda kaba malök. Mewö mala opo seri koumŋi meköba memba kuŋguba anda kinda teteköŋe Sodom kösutŋe aŋgota malök. ");
INSERT INTO bmu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Miaŋgöreŋ malökmö, Sodom könagesö yeŋön könagesö tandök bölöŋi aka Kembu qetala siŋgisöndok keta bölökŋi aka memba malget. ");
INSERT INTO bmu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lotnöŋ Abram umbula aniga nalö miaŋgöreŋ Kembunöŋ Abramgöra keu kewö jiyök: “Mönö jegi ötök ala mesoholge uba wahöta eleŋda andöge uba mewöyök wehön kotkotŋe aka wehön gegeŋe göröken unöŋ. ");
INSERT INTO bmu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Gölme pakpak ki ekzani, mi mönö gi aka göhö gwölönarökurupki eŋgö buŋaya qebi nalö teteköŋi qahö buŋaŋina ahöm öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nöŋön gwölönarökurupki ahumsehip gwötpuk eŋgibiga qötöŋinan qariba gölmegö sakösakŋi (sakösiŋi) ewö akŋa. Kun daŋön sakösiŋ kötŋi mieŋgö jaŋgöŋini oyoŋbawak, yaŋön ölöp gwölönarökurupki yeŋgö jaŋgöŋini mema. ");
INSERT INTO bmu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Nöŋön gölme ki mönö göhö buŋaya qem gihizal. Miaŋgöra ölöp wahöta anda kaba gölme pakpak ki bahöbahö euke emuke ek kutuba malman.” ");
INSERT INTO bmu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Mewö jiiga Abramnöŋ wahöta opo seri koumŋi qeköba memba kuŋguba anda Hebron gölmenöŋ kaba Mamre mire in ip ketaŋi kin angeri, mieŋgö kösutŋine tarök. Miaŋgöreŋ tata Kembugöra jöwöwöl alta kun meyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nalö miaŋgöreŋ Babilongö (Sinargö) kiŋi qetŋi Amrafel, Elasargö kiŋi qetŋi Ariok, Elamgö kiŋi qetŋi Kedorlaomer aka Goimgö kiŋi qetŋi Tidal malget. ");
INSERT INTO bmu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Yeŋön kiŋ kewö miembuk könahiba bim auget: Sodom taongö kiŋi qetŋi Bera, Gomora taongö kiŋi qetŋi Birsa, Adma taongö kiŋi qetŋi Sinab, Seboim taongö kiŋi qetŋi Semeber aka Bela (qetŋi alaŋi Zoar) taon miaŋgö kiŋi. ");
INSERT INTO bmu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kiŋ pakpak kieŋön örue (ruerue) qetŋi Sidim miaŋgöreŋ tokoba kukösumŋini mindiriba jöhöjöhö aket. Sidim öruenöŋ nalö kewöŋe Sihi Köwet Köhömuŋi mi ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Yeŋön yambu 12:gö dop Kedorlaomergö jimkutukutu bapŋe mala kota yambu 13 miaŋgöreŋ yaŋgö keu bapŋe anbingö qetala karim aka yarö gilget. ");
INSERT INTO bmu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mewö aketka yambu 14 miaŋgöreŋ Kedorlaomer aka kiŋ tosatŋi yambuk jöhöjöhö aka malgeri, mieŋön kaba könagesö kewöŋi yembuk bim qeba luhut alget: Refa könagesö mi Asterot Karnaim mire eŋguba luhut alget. Zuzi könagesö mi Ham mire aka Eme könagesö mi Kiriataim miri miaŋgöreŋ eŋguba luhut alget. ");
INSERT INTO bmu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hor könagesö mi Seir gölme kunduŋambuk miaŋgöreŋ eŋguba eŋguataŋgöba anda anda El Paran miri miaŋgöreŋ aŋgota luhut al eŋgiget. El Paran mi gölme qararaŋkölkölŋaŋgö göraŋe ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Luhut al eŋgiba miaŋgöreŋök liliŋgöba En Mispat (qetŋi alaŋi Kades) miaŋgöreŋ kaba Amalek könagesö luhut al eŋgiba gölmeŋini pakpak aŋgön kölget. Amor könagesö Hazezon Tamar gölmenöŋ malgeri, mi mewöŋanök eŋguba luhut al eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mewö asuhuiga Sodomgö kiŋi, Gomoragö kiŋi, Admagö kiŋi, Zeboimgö kiŋi aka Bela (qetŋi alaŋi Zoar) miaŋgö kiŋi yeŋön wahöta asasaitiba Sidim öruenöŋ aŋgota kiŋ kewö miembuk bim qebingö jaböŋi ala aröŋda kinget: ");
INSERT INTO bmu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elamgö kiŋi Kedorlaomer, Goimgö kiŋi Tidal, Babilongö (Sinargö) kiŋi Amrafel aka Elasargö kiŋi Ariok. Kiŋ 4 mieŋön kiŋ 5 yembuk aröŋget. ");
INSERT INTO bmu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mewö aröŋgetmö, Sidim gölme örue miaŋgöreŋ löm dodoho sapösapöŋambuk miaŋön kokolak qeba tarök. Mewö tariga Sodom aka Gomora taon mietkö kiŋiran yarö aziurupŋiri yembuk unjurata angaitketka azi tosatŋan löm miaŋgöreŋ tötohoba geba eŋguyök. Mewö eŋguiga alaurupŋini tosatŋi pakpak yeŋön ölöŋ köla unjurata gölme kunduŋambuk miaŋgöreŋ öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Öŋgögetka kiŋ 4 mieŋön Sodom aka Gomora anda sukinapŋini aka numbu neneŋini pakpak mi kiom köla memba tököba anget. ");
INSERT INTO bmu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abramgö behötŋi Lot yaŋön Sodom malöhaŋgöra aka i mewöŋanök sukinapŋambuk waŋgita anget. ");
INSERT INTO bmu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mewö angetka azi kunŋan ölöŋ köla misiŋgöba kaba miaŋgö buzup keuŋi mi Hibru (kian) azi Abramgöra jii mörök. Nalö miaŋgöreŋ Abramnöŋ Amor azi qetŋi Mamre yaŋgöreŋ in ip ketaŋi ketaŋi mieŋgö kösutŋine malök. Mamrenöŋ munyahötŋi qetŋiri Eskol aka Aner yetpuk mohotŋe Abrambuk jöhöjöhö aka malget. ");
INSERT INTO bmu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramnöŋ behötŋi Lot waŋgita angeri, miaŋgö keuŋi möta aziurupŋi 318 nanŋi mire asuhuba mötmöt möta bimqeqe köl guliba malgeri, mi eŋgohol tokoba kerök kambu eŋguataŋgöba Not göröken anda mala Dan mire aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abramnöŋ aziurupŋi mendeŋ eŋgiiga yeŋön suŋgem miaŋgöreŋ közöla kerök kambu qeraköm eŋgimemba luhut al eŋgiget. Luhut al eŋgiba eŋguataŋgöba anda mala Damaskusgö Not likepŋe miri qetŋi Hoba miaŋgöreŋ aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Miaŋgöreŋ aŋgota sukinap pakpak kiom qeba memba angeri, mi miwikŋaiget. Behötŋi Lot aka yaŋgö öröyuaiŋi mi memba waŋgita liliŋgöba kayök. Sodom aka Gomora yeŋgö ambimoröurupŋini aka ambazip tosatŋi mi tok lökŋanök eŋguaŋgita kaget. ");
INSERT INTO bmu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramnöŋ mewö Kedorlaomer aka kiŋ tosatŋi yambuk jöhöjöhö aka malgeri, mi eŋguba luhut al eŋgiba liliŋgöba kaiga Sodomgö kiŋi yaŋön Sawe örue (qetŋi alaŋi Kiŋgö örue) miaŋgöreŋ miwikŋaiba ekŋamgöra anök. ");
INSERT INTO bmu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Nalö miaŋgöreŋ Melkizedek Salemgö kiŋi miaŋön bered aka wain o memba kayök. Yaŋön Anutu öŋgöŋgöŋaŋgö jike nup galömŋi ahök. ");
INSERT INTO bmu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Mewö aka Abram kötuetköm waŋgiba keu kewö jiyök: “Anutu öŋgöŋgöŋan suep gölme miwikŋaim etkiyöhi, yaŋön mönö Abram gi kötuetköm gihii malman. ");
INSERT INTO bmu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Anutu öŋgöŋgöŋan kerökurupki göhö böröge al eŋgiyöhi, mönö i möpöseizin. “Mewö jiiga Abramnöŋ öröyuaiŋi pakpak mendeŋniga kambu ten asuhuiga mieŋgöreŋök mohot mohot (10%) memba naluha waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mi waŋgiiga Sodomgö kiŋan Abramgöra kewö jiyök: “Ambazipurupni mia niŋgimanmö, sukinap mia mönö nangi buŋaya akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mewö jiyökmö, Abramnöŋ Sodomgö kiŋaŋgöra kewö jiyök: “Keuni köhöimapköra nöŋön böröni Kembu Anutu öŋgöŋgöŋi Suep gölme miwikŋaim etkiyöhi, yaŋgöreŋ göröken memba wahöta jöjöpaŋ keu kewö jizal: ");
INSERT INTO bmu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Nöŋön göhöreŋ yuai kun mi qahö kötökŋi memam. Möt kösögahö kitipŋi me köna esugahö kösöŋi mi mewöŋanök qahö memam. Mewö akiga göŋön könaŋgep kewö jibanbuk: ‘Nöŋön Abram yuai waŋgibiga yaŋön azi pomŋi qetbuŋaŋambuk aka malja.’ Göŋön mönö mewö jimamgö osiba malman. ");
INSERT INTO bmu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nöŋön yuai kun qahö toroqeba memam-mö, aziurupnan wani yuaia negeri, mi lök neŋgigetka dop köl teköza. Mewöyök azi alaurupni Aner, Eskol aka Mamre nömbuk kageri, yeŋön mönö töwa jijiŋinaŋgö dop meme. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Mewö asuhuiga Abramgö jeŋi meleŋniga imut ehiga Kembunöŋ keu kewö jii kaiga mörök, “Abram, gi keŋgötki kude mötman. Nöŋön göhö sumanga akzal. Göhö töwagi mönö keta bölökŋi aka ahöma.” ");
INSERT INTO bmu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Keu mewö kayökmö, Abramnöŋ kewö jiyök, “O Kembu ketaŋamni, ni nahönböratni qahö malbiga töwa niŋginöŋga miaŋön mönö denöwö bauköm niŋgibawak? Nöŋön kömumbiga Damaskus azi Eliezer yaŋön nöŋgö sukinapnaŋgö toŋi akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Mewö jiba toroqeba kewö jiyök, “Göŋön gwölönarökni kun qahö niŋginöŋaŋgöra nup azini bohonŋan nöŋgö mire maljawi, yaŋön mönö nöŋgö öröyuaini pakpak buŋa qem aŋguma.” ");
INSERT INTO bmu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mewö jiiga Kembugöreŋ keu jit kun mi yaŋgöreŋ kewö kaiga mörök, “Azi miaŋön sukinapkahö toŋi qahö akŋapmö, nangi silegeyök morö nahön kun asuhumawi, yaŋön mönö göhö öröyuaigi pakpak buŋa qem aŋguma.” ");
INSERT INTO bmu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Keu mewö kaiga Anutunöŋ Abram waŋgita gumnöŋ geba keu kewö jii mörök, “Mönö suepnöŋ unöŋ öŋgöiga seŋgelau oyoŋ engimanaŋgö dop akŋa ewö, mi mönö ölöp oyoŋ eŋgiman. “Mewö jiba kewö toroqeba jiyök, “Göhö gwölönarökurupki yeŋgö qötöŋinan mönö miaŋgö dop akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Mewö jiiga Abramnöŋ Kembu möt narim waŋgiiga mötnaripŋi ehi dop köliga keuŋi jim teköiga solaniyök. ");
INSERT INTO bmu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kembunöŋ toroqeba keu kewö jii mörök, “Nöŋön Kembu akzal. Gi Kaldia gölmegö miri qetŋi Ur miaŋgöreŋ malnöŋga goaŋgita ki kait. Gölme ki gihibi buŋa qem aŋgumangöra aka gi goaŋgita ki kait.” ");
INSERT INTO bmu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mewö jiyökmö, Abramnöŋ kewö jiyök, “O Kembu ketaŋamni, gölme kiaŋön nöŋgö buŋaya akŋawi, mi mönö wani aiwesöha eka möt kutumam?” ");
INSERT INTO bmu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mewö jiiga Kembunöŋ yaŋgöra kewö jiyök, “Gi mönö anda bulmakau ambi seramŋi yambuŋi karöbut, meme (noniŋ) ambiŋi yambuŋi karöbut aka lama aziŋi yambuŋi karöbut aka kembö kun aka kembö supsup dölökunŋi kun mi memba nöŋgöreŋ kaman.” ");
INSERT INTO bmu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Mewö jiiga Abramnöŋ anda mi pakpak körek memba kaba sömbup mi bibiŋine qesiŋ eŋgiba likepŋi likepŋi mi areŋgöiga köna likep likep aröŋnöŋ ahöget. Mewö ahökmö, nei mi qahö qesiŋnök. ");
INSERT INTO bmu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Qahö qesiŋda qamötŋini likep likep areŋgöm eŋgiiga nei kalŋi yeŋön kaba qamöt yeŋgö qakŋine eta kölgetmö, Abramnöŋ mi közöl eŋgiiga anget. ");
INSERT INTO bmu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Wehön jeŋi teköba gemamgö aiga nalö miaŋgöreŋ Abramnöŋ jeŋi eta meiga gaun lömbötŋi ahöyök. Mewö ahöiga pandaman göjiwinaŋgö kanjamŋi miaŋön kaba turum waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Turum waŋgiiga Kembunöŋ kewö jii mörök, “Keu ki mönö ölŋa mötman: Göhö gwölönarökurupkan mönö nanŋini gölmeŋini mosöta kantri kunöŋ anda kiana mala mal öŋgöme. Mewö mala yeŋgö welenqeqeurupŋini omaŋi aketka i yambu 400:gö dop tulumgöm eŋgiba malme. ");
INSERT INTO bmu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mewö malmemö, nöŋön kantri welenqeqeurupŋini omaŋi aka malmei, yeŋgö keuŋini mewöyök jim teköba likepŋi meleŋbiga qakŋine öŋgöma. Mewö mi öŋgöiga pösat eŋgigetka kantri mi mosöta sukinapŋini gwötpuk memba liliŋgöba kame. ");
INSERT INTO bmu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Nöŋön Amor könagesö mi gölme kiaŋgöreŋ zilaŋ qahö eŋguataŋgömam. Mutuk siŋgisöndokŋi siŋgisöndokŋi aka bölimqölim tekögetka likepŋi törörök meleŋ eŋgimamaŋgö nalöŋan akŋawi, nalö miaŋgöreŋ mönö i eŋguataŋgömam. Miaŋgöra göhö isiurupki yeŋgö isiurupŋinan asuhuba malmei, nalö miaŋgöreŋ göhö gwölönarökurupkan mönö liliŋgöba ki kame. (15) Yeŋön mewö kamemö, nangak mutuk yambugahö nalöŋi ölöm kömuiga luainöŋ iwiasaurupki yeŋgöreŋ anöŋga löm köl gihime.” ");
INSERT INTO bmu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kembunöŋ mewö jiiga wehön jeŋan teköba geiga pandaman meiga yuai kewö asuhuiga ehök: Kimbut kungö uruŋe könöp bölamŋan kököbilikbilikŋambuk jeba asariiga köwak köndumŋambuk pukpuköyök. Yuai miaŋön asuhuba sömbup qamöt qesiŋqesiŋi mieŋgö sutŋine kinda anda kayök. ");
INSERT INTO bmu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kembunöŋ mewö sömbup likepŋi likepŋi mieŋgö sutŋire anda kaba sömaŋ miaŋgöreŋ Abrambuk jöjöhö areŋ aka (kaisöpsöpŋan mi mem köhöiba) keu kewö jii mörök, “Nöŋön gölme ki mi göhö gwölönarökurupki yeŋgö buŋaya qem engimam. Miaŋgö jaböŋi mi Ijiptkö o töwatŋi (Nail) miaŋgöreŋök könahiba kaba ki oŋgita anda o töwatŋi ketaŋi qetŋi Yufreitis miaŋgöreŋ teköma. ");
INSERT INTO bmu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Nalö kewöŋe mi könagesö kewö yeŋgö gölmeŋina ahöza: Kin könagesö, Kenas könagesö, Kadmon könagesö, ");
INSERT INTO bmu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit könagesö, Periz könagesö aka Refaim könagesö, ");
INSERT INTO bmu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor könagesö, Keinan könagesö, Girgas könagesö aka Jebus könagesö. Yeŋgöreŋ gölme pakpak mi mönö körekŋanök memba dop köla anme. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abramgö anömŋi Sarainöŋ köpin mala morö qahö meyökmö, Saraigö welen ambi qetŋi Hagar malök. Mi Ijipt ambia. ");
INSERT INTO bmu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Yaŋön malöhaŋgöra Sarainöŋ Abramgöra kewö jiyök: “Kembunöŋ soŋgo jöhöm niŋgiiga morö qahö mealaŋgöra gi mönö welen ambini menöŋga gölöm ala morö kun meiga nöŋgö buŋaya asuhubawak. “Mewö jiiga Abramnöŋ Saraigöreŋ keugöra urumohot ahök. ");
INSERT INTO bmu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abramnöŋ Keinan gölmenöŋ yambu 10 mal teköiga nalö miaŋgöreŋ Sarai Abramgö anömŋan Ijiptkö welen ambiŋi Hagar memba apŋaŋgö anömŋi akŋapköra waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Mewö waŋgiiga memba maliga gölöm alök. Gölöm ala mi möta galöm ambiŋi Sarai könahiba jijiwilit ak waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Mewö ak waŋgiiga Sarainöŋ Abramgöra kewö jiyök: “Urunan böliiga sihimbölö mörakzali, miaŋgö keuŋan mönö göhö qake öŋgöba ahöma. Nöŋön welen ambini göhö böröge albiga gölöm ala mi möta miaŋgöreŋök könahiba jijiwilit ak niŋgiba malja. Miaŋgöra Kembunöŋ mönö ni aka gi netkö sutnire keu kewöta jim teköma.” ");
INSERT INTO bmu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Mewö jiiga Abramnöŋ kewö jiyök: “Welen ambigi miaŋön nange böröge maljawaŋgöra wania mötnöŋga dop köljawi, mönö miaŋgö dop i ak waŋgiman. “Mewö jiiga Sarainöŋ Hagar laŋ örömureim ak waŋgiiga mosöta tököba ölöŋ köla anök. ");
INSERT INTO bmu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Aniga Kembugöreŋ garata kunöŋ gölme qararaŋkölkölŋe o jeŋi kungö kösutŋe miwikŋaim waŋgiyök. O jeŋi mi Sur mire anangö köna jitŋe miaŋgöreŋ ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Miaŋgöreŋ miwikŋaim waŋgiba kewö jiyök: “Hagar, Saraigö welen ambiŋi, gi mönö denikeyök kazana denike anman?” Mewö jiiga kewö meleŋnök: “Ni galöm ambini Saraigöreŋök asamböta ölöŋ köla kazal.” ");
INSERT INTO bmu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mewö jiiga Kembugöreŋ garatanöŋ Hagar kewö jim kutum waŋgiyök: “Gi mönö kunbuk Saraigöreŋ anda welenŋi qeba yaŋgö keu bapŋe malman.” ");
INSERT INTO bmu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Keu mi toroqeba kewö jii mörök: “Hagar, nöŋön mönö göhö gwölönarökurupki ahum sehim eŋgibiga qötöŋini oyoŋoyoŋgö dop qahö aiga malme.” ");
INSERT INTO bmu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kembugöreŋ garatanöŋ kunbuk toroqeba Hagargöra kewö jiyök: “Gi moröbuk akzana nahöngi meman. Dölki tapötkokorok möta sahötnöŋga mi mönö Kembugö kezapŋe geiga mötza. Miaŋgöra morögö qetŋi Ismael qetman. (Ismael Anutunöŋ kezapŋan mötza.) ");
INSERT INTO bmu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Yaŋön azi doŋki bau kömböt ewö aka (nanŋi imbi-imbi qakŋe laŋ anda kaba) malma. Yaŋön böröŋan ambazip pakpak qetal eŋgiiga ambazip pakpak yeŋön i qetal waŋgiba malme. Yaŋön munurupŋi pakpak yembuk kerök-kerök aka nanŋök kekelolo malma.” ");
INSERT INTO bmu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Mewö jiiga Hagarnöŋ kewö jiyök: “Nöŋön mönö dölki kunöŋ ni nehakzawi, i ekzal. “Miaŋgöra Kembu yaŋgöra keu jiyöhi, yaŋgö qetŋi kewö qet waŋgiyök: “Gi Kembu ni nehakzanaŋön akzan. “Qetŋi mewö qerök. ");
INSERT INTO bmu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Könaŋi miaŋgöra aka o löm miaŋgö qetŋi mi Ber Lahai Roi (Malmalŋambuk mala nehakzawaŋgö o lömŋi) qetketka ahöza. O löm mi toroqeba miri yahöt qetŋiri Kades aka Bered mietkö sutŋire ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagarnöŋ Abramgö morö nahönŋi meyök. Abramnöŋ nanŋi moröŋi Hagar meyöhi, yaŋgö qetŋi Ismael qerök. ");
INSERT INTO bmu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramnöŋ yambuŋi 86 aiga Hagarnöŋ Ismael morö mi Abramgöra meyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramnöŋ yambuŋi 99 aiga Kembunöŋ asuhum waŋgiba keu kewö jiyök: “Nöŋön Anutu kukösum pakpakö Toŋi akzal. Miaŋgöra gi mönö nöŋgö keuni tem köla pöndaŋ ahakmeme diŋdiŋi wuataŋgöba malman. ");
INSERT INTO bmu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nöŋön jöhöjöhö areŋ mi gi aka ni netkö sutnire ahali, mi mem köhöiba ahumsehip gihibi gwölönarökurupki yeŋgö jaŋgöŋinan mönö keta bölökŋi akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Mewö jiiga Abramnöŋ simin köla bamgöiga Anutunöŋ yaŋgöra keu kewö jiyök: ");
INSERT INTO bmu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Mötman, nöŋön jöhöjöhö areŋni göbuk kewö akzal: Göŋön könagesö gwötpuk yeŋgö iwi bömönŋina akŋan. Keu mewö jim jöhöbi ahöma. ");
INSERT INTO bmu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Göhö qetki Abram mi qahö toroqeba qetketka ahömapmö, göŋön könagesö gwötpuk yeŋgö iwi bömönŋina akŋangöra kuŋgum gihizali, miaŋgöra qetki mönö Abraham qetketka ahöma. ");
INSERT INTO bmu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nöŋön ahumsehip gihibiga gwölönarökurupki mi önöŋi qahö asuhume. Yeŋön jula deŋda könagesö kambuŋi kambuŋi gwötpuk akŋe. Göhö gwölönarökurupki yeŋgöreŋök tosatŋan kiŋ kembuŋi kembuŋi akŋe. ");
INSERT INTO bmu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nöŋön mönö jöhöjöhö areŋni mi nani aka gi, göhö gwölönarökurupki göhö andöge toroqeba asuhum öŋgömei, neŋgö sutnine al köhöibiga teköteköŋi qahö ahöm öŋgöba ahöma. Nöŋön göhö Anutugi aka gwölönarökurupki göhö andöge asuhum öŋgömei, mönö yeŋgö Anutuŋina aka malmam. ");
INSERT INTO bmu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Gi Keinan gölmenöŋ kiana maljani, nöŋön gölme mi jömukŋanök gi aka göhö gwölönarökurupki eŋgö buŋaya qem eŋgibiga buŋaŋini teteköŋi qahö ahöm öŋgöba ahöma. Mewö ahöiga nöŋön mönö yeŋgö Anutuŋina aka malmam.” ");
INSERT INTO bmu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Anutunöŋ Abrahamgöra mewö jiba toroqeba keu kewö jiyök: “Mewö malmam-mö, göŋön mönö nöŋgö jöhöjöhö areŋnaŋgö keuŋi mi tem köla wuataŋgöba malman. Göhö gwölönarökurupki göhö andöge toroqeba asuhum öŋgömei, yeŋön mönö mewöŋanök mi tem köla wuataŋgöba mala mal öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Gi aka göhö gwölönarökurupki embuk jöhöjöhö areŋni aka mi wuataŋgömegöra jizali, miaŋgö aiwesökŋi mi kewö: Eŋgö sutŋine azi pakpak yeŋgö sileŋine mönö nöŋgö aiwesökni yandime. ");
INSERT INTO bmu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Nöŋgö aiwesökni mönö sileŋine yandime. Miaŋön jöhöjöhö areŋ ni aka eŋgö sutnine albi ahözawi, miaŋgö aiwesökŋa ahöm öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Nalö kewöŋeyök könahiba azi pakpak eŋgö sutŋine toroqeba asuhum öŋgömei, yeŋgö sileŋine mönö sömaŋini 8 aiga miaŋgöreŋ nöŋgö aiwesökni yandiba malme. Nanŋine miri uruŋe nanŋini aka welenqeqeurupŋini yeŋgöreŋ morönahönurupŋini asuhumei, mi mönö öröröŋ ak eŋgiba malme. Welenqeqe tosatŋi mi kian yeŋgöreŋök moneŋnöŋ bohonŋini megetka yeŋgö morö nahönŋini asuhume. Yeŋön nanŋini gwölönarökurupŋini qahö akzemö, mi töndup nöŋgö aiwesökni mi mönö yeŋgö sileŋine mewöŋanök yandiba malme. ");
INSERT INTO bmu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Welenqeqe tosatŋan nanŋine miri uruŋe asuhugetka welenqeqe tosatŋi mi moneŋnöŋ bohonŋini megetka yeŋgö morö nahönŋini asuhume. Nöŋgö aiwesökni mi mönö yeŋgö sileŋine mewöŋanök yandiba malme. Nöŋgö jöhöjöhö areŋnaŋgö aiwesökŋi sileŋine yandimei, mi mönö jöhöjöhö areŋ teteköŋi qahö ahöm öŋgömapköra jim köhöizal. ");
INSERT INTO bmu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Azi kun daŋön nöŋgö aiwesökni sileŋe qahö yandigetka öne malmawi, yaŋön mönö nöŋgö jöhöjöhö areŋni oŋgita qetalakza. Miaŋgöra azi mewöŋi mi mönö nanŋi ambazip kambu eŋgö sutŋineyök yakörim waŋgigetka yaigep eta malma.” ");
INSERT INTO bmu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Anutunöŋ toroqeba Abrahamgöra kewö jiyök: “Gi anömgahö qetŋi Sarai mi kude toroqeba qeta malmanmö, yaŋgö qetŋi mönö Sara (jembon ambi) qeta malman. ");
INSERT INTO bmu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nöŋön Sara kötuetköm waŋgibiga yaŋön göhöra morö nahön kun mema. Nöŋön kötuetköm waŋgibiga yaŋön ambazip kambuŋi kambuŋi gwötpuk yeŋgö nam bömönŋina akŋa. Yaŋgö gwölönarökurupŋi yeŋgöreŋök tosatŋan könagesö kambu yeŋgöreŋ azi kembuŋi kembuŋi akŋe.” ");
INSERT INTO bmu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kembunöŋ mewö jiiga Abrahamnöŋ mi möta simin köla bamgöba uruŋan kewö mötmöriba miaŋgöra gön kölök, “Azi yambuni 100 akiga morö nahönan mönö denöwö asuhubawak? Mewöyök Saranöŋ yambuŋi 90 aiga mönö denöwö morö membawak?” ");
INSERT INTO bmu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahamnöŋ mewö mötmöriba welipköba Anutu kewö qesim waŋgiyök: “Göŋön ölöp Ismael kuŋgum waŋginöŋga qetki bisiiga nöŋgö gwölönarökurupni mi yaŋgöreŋök asuhume.” ");
INSERT INTO bmu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mewö qesiiga Anutunöŋ kewö meleŋnök, “Anömgi Saranöŋ mönö göhö morö nahöngi mema. Mi meiga qetŋi Aisak (gön kölja) qetman. Nöŋön Aisakpuk aka yaŋgö gwölönarökurupŋi yembuk jöhöjöhö areŋni mi al köhöibiga teteköŋi qahö ahöm öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismael kötuetköm waŋgimamgö qesim niŋgizani, mi mewöyök ölöp möt gihiba kötuetköm waŋgimam. Yaŋön azi kembu 12 mieŋgö iwi bömönŋini akŋa. Nöŋön ahumsehip waŋgibiga gwölönarökurupŋi yeŋgö jaŋgöŋinan mönö keta bölökŋi akŋa. Yeŋön sehiba könagesö kambu ketaŋi akŋe. ");
INSERT INTO bmu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mewö akŋemö, Saranöŋ nahöngi Aisak mi yambu euneaŋgö nalö kewöŋe memawi, nöŋön mönö nani jöhöjöhö areŋni mi yambuk al köhöimam.” ");
INSERT INTO bmu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Anutunöŋ Abrahambuk keu jiyohori, mi teköiga i mosöta wahöta öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Wehön miaŋgöreŋök Abrahamnöŋ Anutugöreŋ keu tem köla nanŋi nahönŋi Ismaelgö sileŋe Anutugö aiwesökŋi yandiyök. Mewöyöhök welenqeqeurupŋi nanŋi miri uruŋe asuhugetka tosatŋi moneŋnöŋ bohonŋini meiga malgeri, azi pakpak mi yaŋgö miri uruŋe tatkeri, i mönö körek mewöŋanök ak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamnöŋ yambuŋi 99 aiga sileŋe aiwesök mi yandiget. ");
INSERT INTO bmu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Nahönŋi Ismael mi yambuŋi 13 aiga sileŋe mi yandiget. ");
INSERT INTO bmu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham aka nahönŋi Ismael yetkö sileŋire aiwesök mi sömaŋ mohot miaŋgöreŋök yandiget. ");
INSERT INTO bmu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Azi pakpak Abrahamgö miri uruŋe tatkeri, tosatŋan nanŋi miri uruŋe asuhugetka tosatŋi mi kian yeŋgöreŋök bohonŋini meiga malgeri, körek yeŋgö sileŋine aiwesök mi mewöŋanök yandiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahamnöŋ Mamre mire in ip ketaŋi ketaŋi mieŋgö sutŋine maliga Kembunöŋ asuhum waŋgiyök. Silim miaŋgöreŋ wehön jitŋi sihitŋi köhöikŋi qeiga Abrahamnöŋ opo seri koumŋaŋgö numbuŋe tarök. ");
INSERT INTO bmu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Tata uba wahöta ehiga azi karöbutŋan wösöŋe kinget. Kingetka eŋgeka opo seri koum numbuŋeyök wölaŋ wahöta jömjölöŋini jiba eŋguaŋgitmamgöra kiŋkiŋgöba anök. Anda waikŋini memba simin köla gölmenöŋ bamgöba geyök. ");
INSERT INTO bmu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Geba kewö jiyök: “O Kembu-urupni, nöŋön eŋgö welenqeqeŋini aka eŋgö jeŋine kalem möriam miwikŋaiba maljal ewö, iŋini mönö ni kude noŋgita anme. ");
INSERT INTO bmu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ni eŋgö welenqeqeŋini aka ölöp o moröŋi kun memba kaba eŋgibiga könaŋini saŋgoŋda ip kiaŋgö aumŋe tata luhut meme. ");
INSERT INTO bmu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nöŋön ölöp nene moröŋi kun memba kaba eŋgibiga neme. Miaŋön mem köhöim eŋgiiga ölöp köna kunbuk toroqeba anme. Nöŋön kewöröpni malbiga iŋini ni göda qem niŋgiba kazeaŋgöra ölöp welen qem eŋgimam. “Mewö jiiga meleŋda kewö jiget: “Saiwap, jizanaŋgö dop mewö ölöp akin.” ");
INSERT INTO bmu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Mewö jigetka Abrahamnöŋ ösumŋan kiŋkiŋgöba seri koum uruŋe anda öŋgöba Saragöra kewö jiyök: “Mönö ösumok plaua ölöp kötökŋi amae (dis) karöbutkö dop memba meleŋda yeŋgöra bered ohoman.” ");
INSERT INTO bmu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mewö jiba ösumŋan bulmakau kambunöŋ anda bulmakau dömŋi busuŋi löwötŋi möwölöhöba welenqeqeŋi kun waŋgiiga könahiba ösumok qeba möhamgöba ohoyök. ");
INSERT INTO bmu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Mi möhamgöba ohom teköiga mi, kelök kosökŋi aka juju o tosatŋi memba anda azi tatkeraŋgö bapŋine alök. Bapŋine aliga nemba tatketka nanŋi nalö miaŋgöreŋ kösutŋine ip könaŋe galömŋina kinök. ");
INSERT INTO bmu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kiniga kewö qesim waŋgiget: “Anömgi Sara mi denike?” Qesim waŋgigetka jiyök: “I opo seri koum uruŋe endu tatza.” ");
INSERT INTO bmu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mewö jiiga azi yeŋgöreŋök kunŋan kewö jiyök: “Yambu mohotkö dop teköiga nöŋön ölŋa liliŋgöba ki kabiga anömgi Saranöŋ mönö morö nahönŋambuk aka malma. “Mewö jiyökmö, Saranöŋ opo seri koumgö numbuŋe apŋaŋgö andöŋe kinda keu mi kezapŋe geiga mörök. ");
INSERT INTO bmu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham aka Sara yetkön lök ambazip namŋi ahotka yambuŋiran gwötpuk ketaŋi aiga malohot. Saranöŋ köiŋgö aŋgeka malöhi, miaŋgö nalöŋan lök oŋgit teköyök. ");
INSERT INTO bmu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Miaŋgöra Saranöŋ mi möta uruŋan kewö mötmöriba gön kölök: “Nöŋön lök ambi namŋi sohosoholiŋi akiga apni azi kembunan mewöŋanök azi namŋi aiga yambuk ahöahögö sihimnan kunbuk asuhubawak me qahöpto?” ");
INSERT INTO bmu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mewö mötmöriiga Kembunöŋ Abraham qesim waŋgiba kewö jiyök: “Saranöŋ wanigöra gön köla kewö mötmöriza: ‘Nöŋön ambi namŋi kötökŋi aka ölŋa morö membileŋak me?’ ");
INSERT INTO bmu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kembunöŋ mönö yuai kungöra qahö kötökŋi qakömakza. Miaŋgöra jizali, ‘Yambu mohotkö dop teköiga nöŋön ölŋa liliŋgöba ki kabiga Saranöŋ mönö morö nahönŋambuk aka malma.’” ");
INSERT INTO bmu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saranöŋ keŋgötŋi möta mi köyatiba kewö jiyök: “Ni gön qahö köljal. “Mewö jiyökmö, Kembunöŋ kewö jiyök: “Qahö, gi gön ölŋa köljan. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mewö jiiga azi karöbut yeŋön wahöta etkömosöta Sodom taonöŋ göröken eleŋda anbingö aket. Abrahamnöŋ mewöŋanök i eŋgubulmamgöra yembuk mohotŋe anget. ");
INSERT INTO bmu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kembunöŋ nanŋaŋgöra kewö jiyök: “Ni yuai akŋamgö mötzali, mi alani Abrahamgöra ölöp qahö asambötmam. ");
INSERT INTO bmu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kewögöra mi asambötmamgö osizal: Abrahamnöŋ nöŋgö alani qainŋi kun aka ahumsehip aiga könagesö ketaŋi kukösumŋinambuk aka malme. Nöŋgö kötumötuetnan mönö yaŋgöra aka gölmegö könagesö kambuŋi pakpak yeŋgö qakŋine öŋgöiga oyaeŋkoyaeŋ akŋe. ");
INSERT INTO bmu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nöŋön i kewögöra möwölöhöm waŋgial: Yaŋön nahönböraturupŋi aka gwölönarökurupŋi yaŋgö andöŋe asuhuba mal öŋgömei, yeŋgöra Kembugöreŋ köna kondela ahakmeme diŋdiŋi dop kölakzawi, mi wuataŋgömegöra jim kutum eŋgiba malma. Mewö maliga tem köla wuataŋgöba malme ewö, Kembu nöŋön Abrahamgöra yuai asuhumapkö jim jöhöyali, miaŋön mönö ölŋambuk pakpak ahakŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kembunöŋ nanŋök mewö jiba toroqeba Abrahamgöra kewö jiyök: “Sodom aka Gomora yeŋön siŋgisöndok lömbötŋi lömbötŋi aka malgetka kahasililiŋ öŋgöŋgöŋi ketaŋi asuhuiga gwötpukŋan miaŋgöra qeta sahörakze. Miaŋgöra yeŋgö siŋgisöndokŋinaŋgö keuŋan mönö qariba qariba keta bölökŋi akza. ");
INSERT INTO bmu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Miaŋgöra nöŋön mönö yeŋgöreŋ geba könaŋamŋini ekŋam. Kahasililiŋ akeraŋgöra aka gwötpukŋan nöŋgö jene qeta sahöta malgeri, mi pakpak ölŋa aket me qahö, mi nöŋön kewöta mötmamgö mötzal.” ");
INSERT INTO bmu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mewö jiiga azi yahötŋan eleŋda Sodom göröken anohotmö, Abrahamnöŋ toroqeba Kembugö jemesoholŋe kinök. ");
INSERT INTO bmu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kinda Kembugö kösutŋe anda kewö qesim waŋgiyök: “Gi ambazip solanŋi aka ambazip aŋgöjörakŋinambuk mi mohotŋe ayuhum eŋgimamgöra jizan me? ");
INSERT INTO bmu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Taon miaŋgöreŋ ambazip solanŋi 50 malje ewö, göŋön i ölŋa ayuhum eŋgimamgö jizan me? Taon mi yeŋgöra aka eŋgehoribanak me qahö? ");
INSERT INTO bmu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Göŋön mewö akŋangö osibanak. Mi yapmakek! (qahöpmahöp!) Göŋön ambazip solanŋi mi ambazip aŋgöjörakŋinambuk yembuk mohotŋe mindiriba eŋgunöŋga qahö dop kölbapuk. Mewö öröröŋ kömumbepuk. Göŋön gölme ambazip pakpak yeŋgö keuŋini jim tekömakzani, miaŋgöra mönö nanŋi könagi diŋdiŋi wuataŋgönöŋga dop kölma.” ");
INSERT INTO bmu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Abrahamnöŋ mewö jiiga Kembunöŋ meleŋda kewö jiyök: “Nöŋön Sodom taonöŋ ambazip solanŋi 50 miwikŋaim eŋgimam ewö, yeŋgöra aka taon pakpak mi ölöp eŋgehorimam.” ");
INSERT INTO bmu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Mewö jiiga Abrahamnöŋ kunbuk kewö jiyök: “Kembu, ni nesak sömsöm omaŋi ewö akzalmö, töndup keu köhöikŋi Kembunaŋgöra kuŋguba jizal. Mi kude dop köljapmö, mi töndup ölöp ni möt niŋgiman. ");
INSERT INTO bmu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Taon miaŋgöreŋ ambazip solanŋi 50 qahöpmö, 45 miyök malbeak ewö, göŋön ambazip 5 yeŋgöra aka taon pakpak mi töndup ayuhum eŋgiman me qahö?” Mewö jiiga Kembunöŋ kewö jiyök: “Nöŋön ambazip solanŋi 45 miaŋgöreŋ miwikŋaim eŋgimam ewö, taon mi mönö qahö ayuhumam.” ");
INSERT INTO bmu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahamnöŋ dumŋe kunbuk keu kewö jiyök: “Ambazip solanŋi 40 miyök miaŋgöreŋ miwikŋaim eŋgiman ewö, mönö denöwö akanak?” Mewö jiiga kewö meleŋnök: “Ambazip 40 yeŋgöra aka taon mi qahö ayuhumam.” ");
INSERT INTO bmu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Mewö jiiga jiyök: “O Kembu, urugi öngöbapukmö, ni kunbuk keu jimamgö mötzal. Ambazip solanŋi 30 miyök miaŋgöreŋ miwikŋaim eŋgiman ewö, mönö denöwö akanak?” Mewö jiiga kewö meleŋnök: “Ambazip solanŋi 30 miaŋgöreŋ miwikŋaim eŋgimam ewö, nöŋön mönö taon mi qahö ayuhumam.” ");
INSERT INTO bmu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahamnöŋ toroqeba kewö jiyök: “Kembu, ni keu köhöikŋi Kembunaŋgöra kuŋguba jizal. Mi kude dop köljapmö, mi töndup ölöp möt niŋgiman. Ambazip solanŋi 20 miyök miaŋgöreŋ miwikŋaim eŋgiman ewö, mönö denöwö akanak?” Mewö jiiga kewö meleŋnök, “Ambazip 20 yeŋgöra aka taon mi qahö ayuhumam.” ");
INSERT INTO bmu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Mewö jiiga Abrahamnöŋ kunbuk kewö qesiyök: “O Kembu urugi öngöbapukmö, ni kunbuk sömaŋi mohot-töp ki keu jimamgö mötzal. Ambazip solanŋi 10 miyök miaŋgöreŋ miwikŋaim eŋgiman ewö, mönö denöwö akanak?” Mewö jiiga kewö meleŋnök, “Ambazip 10 yeŋgöra aka taon mi qahö ayuhumam.” ");
INSERT INTO bmu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mewö eraum-mörohot teköiga Kembunöŋ Abraham mosöta aniga yaŋön kunbuk liliŋgöba miriŋe kayök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Suep garata yahöt mi Abraham mosöta anda mare aiga Sodom aŋgorohot. Aŋgorohotka Lot azi miaŋön taon miaŋgö kiripo naŋgune tarök. Tata etkeka wahöta jömjölöŋiri jiba eŋguaŋgitmamgöra anda gölmenöŋ simin köla bamgöba geyök. ");
INSERT INTO bmu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Geba kewö jiyök: “O kembuyahötni, iŋiri ölöp welenqeqeŋiri nöŋgö mire kaba könaŋiri saŋgoŋda mohotŋe suŋgem ahöbin. Ahöba wahöta ölöp söŋanök köna toroqeba anmahot. “Mewö jiyökmö, yetkön kewö jiyohot: “Qahö, niri ölöp qenjarök sombem kunöŋ anda ahöbit.” ");
INSERT INTO bmu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mewö jiyohotmö, Lotnöŋ kapaŋ köhöikŋi köla jiba etkuaŋgita nanŋi miriŋe anda öŋgöget. Öŋgöba welenqeqeurupŋi jim kutum eŋgiiga bered yistŋi qahö ohoget. Mewöyök numbu nene nahömŋambuk möhamgöba ohoba etkigetka neyohot. ");
INSERT INTO bmu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mi nemba gaun ahöbitkö ahotka miaŋgöreŋök Sodom ambazipnöŋ kaba miri mi liliköget. Sodom taongö bahöŋi pakpak miaŋgöreŋök ambazip namŋi aka sepgwölö mi totnöŋ totnöŋ lömbötŋambuk öröba kaŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kaŋgota Lotköra kewö qetket: “Azi yahöt mare göhöreŋ kazahori, mi denike? Azi nini yetpuk sero akingöra mötzin. Miaŋgöra mönö i etkuaŋgita neŋgöreŋ etme.” ");
INSERT INTO bmu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Mewö qetketka Lotnöŋ naŋgu metala yeŋgöreŋ geba andöŋe naŋgu kölök. ");
INSERT INTO bmu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Naŋgu köla kewö jiyök: “Alaurupni, mewö qahö. Silik bölöŋi mi kude akŋe. ");
INSERT INTO bmu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mötket. Nöŋgö böratni yahöt seram mala nalö kunöŋ azibuk qahö ahöyohot. I ölöp eŋgöra etkuaŋgita etpiga wanat yuaia akingö mötzei, mi ölöp sihimŋini meköme. Mewömö, nöŋgö miri boŋan azi yahöt etkualöŋda sel jöhöm etkizawi, ia mönö yuai bölöŋi kun qahöpmahöp ak etkime.” ");
INSERT INTO bmu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mewö jiyökmö, yeŋön kewö meleŋda teriŋda qetket: “Mönö kesalnöŋ. Göŋön ki kaba kiana mala nangahöra niŋia jiba mötnöŋ öŋgöiga ninia pöndaŋ jim kutum neŋgimamgö mötzan? Yetkön qahö kamahot ewö, mönö nangak neŋgöreŋ kanöŋga mönö kahasililiŋ keta bölökŋi nangi ak gihibin. “Mewö jiba Lot utalgetka kököndöt aniga öŋgöba miri naŋguŋi qesiŋbingö aka kinget. ");
INSERT INTO bmu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mewö aka kingetmö, azi yahöt mietkön böröŋiri böraŋda Lot öröm gilohotka miri uruŋe öŋgöiga naŋgu kölohot. ");
INSERT INTO bmu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Naŋgu köla kinda azi ketaŋi moröŋi miri naŋguŋe yaigep kingeri, mi jiyohotka keu jitŋiran eŋgualöŋniga jeŋini gömöliiga jipjap kota naŋgu miwikŋaibingö mezaŋqezaŋ aka jaruba osiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Azi yahöt yetkön Lotköra kewö jiyohot: “Gi nahönurupki, qiŋgiböraturupki aka tinilosomurupki tosatŋi pakpak taon kiaŋgöreŋ maljei, i mönö eŋguaŋgitnöŋga taon ki mosöta anme. ");
INSERT INTO bmu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nini taon ki ayuhuba köndeŋmöndeŋbin. Könagesö kieŋgö kahasililiŋgöra gwötpukŋan Kembugö jeŋe önöŋi qahö qeta sahöta malget. Miaŋgöra yaŋön melaim netkiiga gölme ki ayuhuba köndeŋmöndeŋbitköra ki kazit.” ");
INSERT INTO bmu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Mewö jiyohotka möta Lotnöŋ anda qiŋgi buŋa yahöt böratyahötŋi etkömembitkö jiiga malohori, yetköra kewö jiyök: “Iŋiri mönö ösumok wahörohotka miri ki mosöta anbin. Kembunöŋ taon ki ayuhuba köndeŋmöndeŋmamgö akza. “Mewö jiiga yetkön keu mi mörohotka göngönahit tandök ahök. ");
INSERT INTO bmu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Miri waŋgaraŋ suruiga Suep garata yahöt yetkön Lot öröm kuŋgum waŋgiba kewö jiyohot: “Anutunöŋ Sodom yeŋgö siŋgisöndokŋinaŋgö likepŋi meleŋda taonŋini köndeŋmöndeŋma. Göŋön yembuk mohotŋe ayuhubanbuköra mönö zilaŋ wahöta anömgi aka böratyahötki göbuk tatzahori, mi eŋguaŋgita taon ki mosötket.” ");
INSERT INTO bmu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mewö jiyohotka Lotnöŋ toroqeba eksekpeksek aiga azi yahöt yetkön Lotkö böröŋi melanjiba memba anömŋi aka böratyahötŋi yeŋgö böröŋini mewöŋanök melanjiba memba eŋguaŋgita taon sileŋe anget. Kembunöŋ mewö ak kömum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Taon sileŋe angetka azi yahöt yetköreŋök kunöŋ keu kewö jiyök: “Malmalŋini aŋgön kölmegöra mönö ösumok misiŋgöba angaitme. Andöŋine kude liliŋgöba uba anda gölme köröŋe endu aŋgota miaŋgöreŋ mewöyök dörök kude alme. Ayuhubepuköra mönö kunduŋe eu öŋgöba misiŋgöba angaitme.” ");
INSERT INTO bmu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mewö jiyökmö, Lotnöŋ kewö jii mörohot: “O Kembuni, göŋön mewö akingöra kude jiman. ");
INSERT INTO bmu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Göŋön malmalnaŋgö bohonŋi jöhöba ak-kömukömu ketaŋi kondelnöŋga göhö jege ölŋa kalem möriam miwikŋaiba welenqeqegi akzalmö, mötnöŋ, nöŋön kunduŋe eu misiŋgöba angaitmamgö osimam. Köndeŋmöndeŋ kiaŋön nöŋgö qakne öŋgöiga kömumbileŋbuköra keŋgötni mötzal. ");
INSERT INTO bmu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mötnöŋ, taon moröni kun endu ahöi ekzani, miaŋön köröpŋi qahöpmö, ölöp anbinaŋgö dop akza. Miaŋgöra ölöp jinöŋga miaŋgöreŋ misiŋgöba angaita ölöwaka malbin. Miri morörökŋi mi eknöŋga dowe ahöiga miaŋgöreŋ ölöp anda malmalninaŋgö bohonŋi jöhöbin.” ");
INSERT INTO bmu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mewö jii mörohotka kunöŋ kewö meleŋnök: “Mi ölöp! Keu jizani, miaŋgöra mewöyök ölöp imbi köl gihimam. Taon moröŋaŋgöra jizani, mi qahö ayuhumam. ");
INSERT INTO bmu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Mi qahö ayuhumam-mö, iŋini mönö ösumok miaŋgöreŋ misiŋgöba angaitme. Miaŋgöreŋ qahö aŋgotketka nalö sutŋi kewöŋe nöŋön yuai kun akŋamgö osimam. Iŋini mutuk miaŋgöreŋ aŋgotketka miaŋgö andöŋe ölöp jim kutubiga köndeŋmöndeŋ asuhuma. “Lotnöŋ taongöra ‘morodökŋi’ jiyöhaŋgöra aka taon miaŋgö qetŋi mi Zoar (morodökŋi) qetketka ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Wehönöŋ lök koriga Lotnöŋ Zoar taonöŋ kaŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kaŋgoriga Kembunöŋ jiiga suepnöhök Kembugö mireyök salfa köt könöpŋambuknöŋ mi kie ewö Sodom aka Gomora yeŋgö qakŋine eta turum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Turum eŋgiba miaŋön taon yahöt mi aka gölme köröŋi pakpak kösutŋire ahözawi, ambazip körek miaŋgöreŋ malgeri aka ip kösö yuai görökŋi (töŋgönŋi) gölme miaŋgöreŋ ahögeri, mi ayuhum eŋgim teköyök. ");
INSERT INTO bmu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lotkö anömŋan apŋi wuataŋgöba anda kunbuk eleŋda andöŋe uba miaŋgöreŋök letota sihi köt aka tandö ewö kinök. ");
INSERT INTO bmu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abrahamnöŋ söŋanök wahöta mutuk Kembugö jemesoholŋe kinda keu eraum-mörohori, miaŋgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Miaŋgöreŋ anda kinda Sodom, Gomora aka gölme köröŋi ketaŋi pakpak miaŋgöreŋ göröken ui aniga gölme miaŋgöreŋ köwak injaŋi ketaŋan tokoba koriga ehök. Mi könöp ketaŋi ohogetka köwak ketaŋi wahörakzawi, miaŋgö dop ahök. ");
INSERT INTO bmu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Anutunöŋ gölme köröŋi miaŋgö taonŋi taonŋi ayuhuba köndeŋmöndeŋda nalö miaŋgöreŋ Abraham mötmörim waŋgiyök. Behötŋi Lotnöŋ taon mieŋgöreŋ maliga mieŋön meleŋni gebingö aketka Anutunöŋ nalö miaŋgöreŋök jim kutuiga Lot köndeŋmöndeŋ miaŋgö uruŋeyök waŋgita kaget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lotnöŋ Zoar taonöŋ malmamgö keŋgötŋi mörök. Miaŋgöra böratyahötŋi etkuaŋgita Zoar mosöta gölme kunduŋambuk miaŋgöreŋ anda tatket. Böratyahötŋi yahöt yetpuk baŋet uruŋe ahöm wahöt aka malget. ");
INSERT INTO bmu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Miaŋgöreŋ mala böratŋi ketaŋan nalö kunöŋ munŋaŋgöra kewö jiyök: “Naniri iwiniran lök azi namŋi akza. Ambazipnöŋ gölme dop miaŋgöreŋ amimba nahönbörat miwikŋaim eŋgimakzemö, gölme kiaŋgöreŋ azi kun netkömemapköra qahö malja. ");
INSERT INTO bmu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Miaŋgöra ölöp kaba iwiniri wain o waŋgizi nemba uruŋi eŋololoŋ aiga yambuk ahöba gölöm ala gwölönarök miwikŋaiziga könagesöninan toroqeba malme.” ");
INSERT INTO bmu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Mewö jiba suŋgem miaŋgöreŋök iwiŋiri wain o waŋgiyohotka neyök. Nemba uruŋi eŋololoŋ aiga datŋan anda yambuk ahöyök. Wani nalönöŋ qöhöröŋe kayök aka wani nalönöŋ wahöröhi, mi iwiŋan qahö mörök. ");
INSERT INTO bmu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ahöba wahöta böratŋi ketaŋan munŋaŋgöra kewö jiyök: “Nöŋön uran suŋgem iwinambuk ahöyal. Ölöp merak suŋgem mewöyök wain o kunbuk waŋgizi nemba uruŋi eŋololoŋ aiga göŋön mönö anda yambuk ahömahot. Mewö ahöba iwiniraŋgöreŋök gölöm ala gwölönarök miwikŋaiziga könagesöninan toroqeba malme.” ");
INSERT INTO bmu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mewö jiba suŋgem miaŋgöreŋ mewöyök iwiŋiri wain o waŋgiyohotka neyök. Nemba uruŋi eŋololoŋ aiga munŋan anda yambuk ahöyök. Wani nalönöŋ qöhöröŋe kayök aka wani nalönöŋ wahöröhi, mi iwiŋan qahö mörök. ");
INSERT INTO bmu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Mewö ahotka miaŋgöra mohotŋamŋire iwiŋiraŋgöreŋök gölöm alohot. ");
INSERT INTO bmu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Böratŋi ketaŋan morö azia memba qetŋi Moab (iwinaŋgöreŋök) qerök. Moab yaŋgö gwölönarökurupŋan ahumsehip aka kotketka nalö kewöŋe mewöyök qetŋini Moab könagesö qerakzin. ");
INSERT INTO bmu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Böratŋi moröŋan mewöŋanök morö azia memba qetŋi Ben Ami (könagesönaŋgö nahönŋi) qerök. Azi miaŋgö gwölönarökurupŋan ahumsehip aka kotketka nalö kewöŋe mewöyök qetŋini Amon könagesö qerakzin. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamnöŋ Mamre miri mosöta toroqeba Saut göröken distrik qetŋi Negew miaŋgöreŋ anda miri qetŋiri Kades aka Sur mietkö sutŋire malök. Miaŋgö andöŋe toroqeba taon qetŋi Gerar miaŋgöreŋ anda kusukŋanök malök. ");
INSERT INTO bmu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Miaŋgöreŋ mala ambazip mieŋgöra kewö jii mötket: “Sara mi nena. “Mewö jiiga Gerargö kiŋi Abimelek yaŋön keu ali aniga Sara waŋgita jakömbuak miriŋe kaget. ");
INSERT INTO bmu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mewö aketmö, Anutunöŋ suŋgem kunöŋ Abimeleköreŋ kaba gaunöŋ kewö jiyök: “Ambi buŋa qem aŋguzani, mi azi kungö anömŋa. Miaŋgöra gi mönö yaŋgöra aka kömupkö buŋaya akŋan.” ");
INSERT INTO bmu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mewö jiyökmö, kiŋ Abimeleknöŋ Sara qahö meyöhaŋgöra aka kewö jiyök: “Kembu, ni siŋgisöndokö keuni qahö. Miaŋgöra göŋön ni aka könagesöurupni nini öne töhön ayuhum neŋgibanbuk. ");
INSERT INTO bmu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahamnöŋ mönö nanŋak nöŋgöra kewö jiyök: ‘Ambi mi nena.’ Ambinöŋ mewöyök kewö jiyök: ‘Abraham mi nena.’ Miaŋgöra urune geŋmoŋ qahö ahöiga ambi mi jibi kaiga börönan yuai tölokŋi kun qahö ahal.” ");
INSERT INTO bmu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mewö jiiga Anutunöŋ gaunöŋ likepŋi kewö jii mörök: “Keu jizani, mi ölŋa. Göhö uruge geŋmoŋ kun qahö ahöiga göhöreŋ kayöhi, mi mötzal. Miaŋgöra göŋön ambi mi misiriba nöŋgö jene siŋgisöndok akanbuköra sel jöhöm gihiba malal. ");
INSERT INTO bmu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Mewögöra ambi mi mönö kunbuk meleŋda apŋaŋgöreŋ waŋgiman. Azi mi kezapqetok azia aka ölöp göhöra köuluköiga qahö kömuman. I kunbuk qahö waŋgiman ewö, keu ki mönö ölŋa mötman: Gi aka tinitosolomurupki iŋini mönö körek kömume.” ");
INSERT INTO bmu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Keu mi jii kiŋnöŋ möta söŋanök wahöta pom jembonurupŋi pakpak eŋgohol tokom eŋgiba Kembunöŋ keu pakpak jiyöhi, mi jii möta töwöratiba keŋgötŋini gwötpuk mötket. ");
INSERT INTO bmu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Mewö mötketka kiŋ Abimeleknöŋ Abrahamgöra keu ali öŋgöiga kewö jiba qesim waŋgiyök: “Gi mönö wani kimbia ak neŋginöŋ? Nöŋön wani bölöŋi kun ak gihibiga göŋön kondotnöŋga siŋgisöndokö keu lömbötŋan mönö ni aka könagesöni nöŋgö sel tohoŋ uruŋe maljei, neŋgö qaknine öŋgömamgö akza? Göŋön yuai qahö ahakŋaŋgö dop mia soŋgo walöŋda ak niŋginöŋ. ");
INSERT INTO bmu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Göŋön mönö könaŋi wuanöŋgöra silik mi aknöŋe?” Kiŋ Abimeleknöŋ Abraham mewö qesim waŋgiiga ");
INSERT INTO bmu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","kewö meleŋnök: “Nöŋön keu mi kewö mötmöriba jial: ‘Gölme kiaŋgö könagesö eŋön Anutugö jitŋi oŋgitpinbuköra keŋgötŋini qahö mötpeak. Miaŋgöra ni anömnaŋgöra aka nuŋguget kömumbileŋbuk.’ ");
INSERT INTO bmu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Yaŋön ölŋa neni, iwinaŋgö böratŋi akza. Namnaŋgö böratŋi qahö akzawaŋgöra i anömna meal. ");
INSERT INTO bmu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Anutunöŋ Iwinaŋgö miriŋi mosöta kungen anmangö jiyöhi, nöŋön nalö miaŋgöreŋ Saragöra kewö jial: ‘Niri denike denike anbiri, miaŋgöreŋ nöŋgöra nena jiman. Mewö aka miaŋön ni urukalem kondel niŋgiba malman.’” ");
INSERT INTO bmu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Mewö jii möta Abimeleknöŋ Abrahamgö anömŋi Sara meleŋda waŋgiyök. Mewöŋanök lama bulmakau aka welenqeqe azi aka ambi mi mohotŋe i waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Waŋgiba keu kewö jiyök: “Mötnöŋ. Nöŋgöreŋ gölme ki wösöge ahözawi, miaŋgöreŋ mönö nangi sihimgahö dop malman.” ");
INSERT INTO bmu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Mewö jiba Saragöra kewö jiyök: “Mötnöŋ. Nöŋön moneŋ silwö köt 1000:gö dop nengi waŋgibiga miaŋön töwagi akza. Töwa miaŋön könaŋamgi kondeliga ambazip körek göbuk maljei, yeŋön mi eka kewö jiba möt yaköme, ‘Siŋgisöndokö keuŋi mi Saragöreŋ qahö ahöza.’” Mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abrahamgö anömŋi Saragöra aka Kembunöŋ ambi pakpak kiŋ Abimelekö miri uruŋe malgeri, yeŋgö morö memegö könaŋi jöhöyök. Miaŋgöra Abrahamnöŋ Anutu köuluköiga Abimelek mem ölöwahök. Mewöyök anömŋi aka welenqeqe ambiurupŋi mem ölöwak eŋgiiga kunbuk moröŋinambuk aket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Kembunöŋ Sara kalem möriam waŋgimamgö keuŋi jim jöhöi ahöyöhi, miaŋgö dop i ek galöm ak waŋgii malök. Keu jiyöhi, miaŋgö dop i kewö ak waŋgiyök: ");
INSERT INTO bmu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saranöŋ gölöm aliga Abrahamnöŋ azi namŋi aiga töndup yaŋgö morö nahönŋi meyök. Anutunöŋ morö nahön asuhumapkö keuŋi qeljiŋe jim jöhöyöhaŋgö dop mi mönö nalö miaŋgöreŋök asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Saranöŋ Abrahamgö morö nahönŋi meiga qetŋi Aisak (gön kölja) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Qeriga Aisaknöŋ wehönŋi 8 aiga nalö miaŋgöreŋ Anutugö aiwesökŋi sileŋe yandiyök. Anutunöŋ keu jim kutui ahöyöhaŋgö dop mi yandiyök. ");
INSERT INTO bmu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamnöŋ yambuŋi 100 aiga nahönŋi Aisak asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Asuhuiga Saranöŋ keu kewö jiyök: “Anutunöŋ gönkölköl miwikŋaim niŋgiyök. Miaŋgöra denike yeŋön nöŋgö kösohotni mötmei, yeŋön mönö nömbuk gön kölme.” ");
INSERT INTO bmu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Mewö jiba toroqeba kewö jiyök: “Saranöŋ morö galömkölkölŋa akŋawi, daŋön keu mi qeljiŋe möta Abrahamgöra jibawak? Mewö qahöpmö, nalö kewöŋe yaŋön azi namŋi aiga nöŋön töndup yaŋgö nahönŋi meal. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisaknöŋ qariba juzu mosöriga wehön miaŋgöreŋök Abrahamnöŋ nene lömbuaŋ ketaŋi alök. ");
INSERT INTO bmu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ijipt ambi Hagarnöŋ Abrahamgö morö nahönŋi Ismael meyöhi, yaŋön nalö kunöŋ munŋi Aisak ilita mepaiköba gönawöt ak waŋgiiga Saranöŋ mi ehök. ");
INSERT INTO bmu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Mewö eka Abrahamgöra kewö jiyök: “Welen ambigö nahönŋan mönö nöŋgö nahöni Aisakpuk göhöreŋ öröyuai mi qahö mendeŋda buŋa qem aŋgumahot. Welen ambi mi aka nahönŋi mi mönö közölnöŋga anmahot.” ");
INSERT INTO bmu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Saranöŋ keu mi jiyöhi, miaŋön Abrahamgö uruŋi qeiga Ismael mi nahönŋi ahöhaŋgöra aka urueret möriga uruŋi mötökömbuk ahök. ");
INSERT INTO bmu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mewö ahiga Anutunöŋ yaŋgöra keu kewö jiyök: “Nahöngi aka welen ambigi Hagar yetköra mönö urugoro ketaŋi kude mötman. Aisakö gwölönarökurupŋi yeŋönök mönö göhö qetbuŋagi bisiba malme. Miaŋgöra Saranöŋ keu göhöra jizawi, mi pakpak mönö möta tem kölman. ");
INSERT INTO bmu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Welen ambigahö nahönŋan göhö gwölönaröki akzawaŋgöra nöŋön i mewöŋanök ahumsehip waŋgibiga gwölönarökurupŋan könagesö ketaŋi akŋe.” ");
INSERT INTO bmu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mewö jii möta Abrahamnöŋ ahöba söŋan kötökŋe wahöta nene tosatŋi memba o uu (ou huhu) lama sileŋan memeŋi miaŋön o uba kaba Hagargö qamböŋe ala mindiŋgöba nahönŋambuk melaim etkiiga mosöta anohot. Anda Berseba gölme qararaŋkölkölŋe aŋgota liliköba malohot. ");
INSERT INTO bmu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Malohotka lama sileŋe o memba anöhi, miaŋön qahöwahiga nahönŋi mi böŋbaŋ ip köhösöŋi kungö bapŋe ali ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ali ahöiga kinda kewö mötmöriyök: “Nahönan jeni qakŋe kömumawi, mi ekŋamgö osiba jemörön akzal. “Mewö mötmöriba pokom mulget anakzawaŋgö dop tikep anda tata silata sahöt gigilahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Morö sahöröhi, mi Anutunöŋ möriga garataŋan suepnöhök Hagargö qeta kewö jiyök: “Hagar, gi wani lömbötkö uruŋe maljan? Keŋgötki kude mötnöŋ. Morönöŋ endu ahöba sahötzawi, Anutunöŋ sahötŋi mi lök mötza. ");
INSERT INTO bmu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mönö wahöta morö nahöngi gölmenöhök kököbihinöŋ wahöriga böröŋe memba mökökölim waŋgiman. Nöŋön i könaŋgep ahumsehip waŋgibiga gwölönarökurupŋan sehiba könagesö ketaŋi qetbuŋaŋinambuk akŋe.” ");
INSERT INTO bmu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Suep garatanöŋ mewö jiiga Anutunöŋ jeŋi metohoiga uba o lömŋi kun ehök. Mi eka lama sileŋi memba anda miaŋön o uba kaba nahönŋi waŋgiiga neyök. ");
INSERT INTO bmu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Anutunöŋ Ismaelbuk kiniga qariba gölme qararaŋkölkölŋe mala erim nembi azia ahök. ");
INSERT INTO bmu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Gölme qararaŋkölkölŋi qetŋi Paran miaŋgöreŋ maliga namŋan Ijipt kantrinöhök ambi kun memba anömŋa waŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nalö miaŋgöreŋ Abimelek aka yaŋgö yarö kambuŋaŋgö suahö galömŋi qetŋi Fikol yetkön Abrahamgöra kewö jiyohot: “Göŋön öröyuai pakpak aka memakzani, Anutunöŋ mönö miaŋgöreŋ göbuk kinakza. ");
INSERT INTO bmu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Miaŋgöra göŋön mönö merak kiaŋgöreŋ Anutugö jeŋe jöjöpaŋ keu kewö jiba jim köhöiman: ‘Nöŋön gi, moröurupki aka gwölönarökurupki embuk isimkakalek kun kude aka malmam.’ Mewö jim köhöiba nöŋön ak kömum gihiba malali, miaŋgö dop göŋön mönö mewöŋanök gölme ki aka ni ak kömum netkiba malman. Gi gölme kiaŋgöreŋ kiana aka maljan.” ");
INSERT INTO bmu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Mewö jiyohotka Abrahamnöŋ kewö jiyök: “Nöŋön jöjöpaŋ keu mi ölöp jiba jim köhöimam.” ");
INSERT INTO bmu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mewö jiyökmö, Abimelekö welenqeqeurupŋan o löm kun nanŋinaŋgöra aŋgön kölgeri, Abrahamnöŋ miaŋgöra Abimelek jim waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Jim waŋgiyökmö, Abimeleknöŋ kewö meleŋda jiyök: “Daŋön silik mi ahöhi, mi nöŋön qahö mötzal. Nangak miaŋgö keuŋi kun mutuk qahö jinöŋ möta mala merak-kun keu mi mötzal.” ");
INSERT INTO bmu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Mewö meleŋda jiiga Abrahamnöŋ anda lama aka bulmakau memba kaba Abimelek waŋgiiga nalö miaŋgöreŋök sutŋire jöhöjöhö aka alohot. ");
INSERT INTO bmu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Mi ala Abrahamnöŋ lama kambuŋineyöhök lama ambiŋi moröŋi 7 meköm eŋgiba al eŋgii nanŋinök kinget. ");
INSERT INTO bmu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Mewö kingetka Abimeleknöŋ Abraham kewö qesim waŋgiyök: “Lama ambiŋi moröŋi 7 kewöta endu al eŋginöŋga nanŋinök kinjei, mi könaŋi wuanöŋgöra?” ");
INSERT INTO bmu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Qesim waŋgiiga kewö meleŋnök: “Nöŋön o lömŋi ki esiali, keu mi jibiga mi möt narizan ewö, lama moröŋi 7 ki mönö nöŋgö böröneyök buŋa qem aŋgunöŋga nöŋgö keunaŋgö dangunuŋi akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mewö meleŋda azi yahöt mi gölme miaŋgöreŋ kinda jöjöpaŋ keuŋiri jiba jim jöhöm aŋguyohot. Miaŋgöra miri miaŋgö qetŋi Berseba qerakze. ");
INSERT INTO bmu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Berseba mire jöhöjöhö mewö ahot teköiga Abimelek aka yaŋgö yarö kambuŋaŋgö suahö galömŋi Fikol yetkön wahöta liliŋgöba Filistin yeŋgö gölmenöŋ anohot. ");
INSERT INTO bmu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Anohotka Abrahamnöŋ berem ip kun Berseba miri miaŋgöreŋ kömöta Kembu Anutu bem koŋkoŋ yaŋgö qetŋi qeta köuluköyök. ");
INSERT INTO bmu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Köuluköba kinda Filistin yeŋgö gölmenöŋ nalö köröpŋi kiana aka malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Yuai mi asuhuiga nalö tosatŋi teköiga Anutunöŋ Abraham esapköm waŋgiyök. Qetŋi “Abraham!” qeriga yaŋön “Ni ki kinjal,” jiba meleŋnök. ");
INSERT INTO bmu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Mewö meleŋniga kewö jiyök: “Aisak nahöngi nanŋi mohotsirik urugan jöpaköm waŋgimakzani, i mönö waŋgita Moria gölmenöŋ anda kunduŋi kun kondel gihimami, miaŋgöreŋ öŋgöba i nöŋgö jöwöwöla ohoman.” ");
INSERT INTO bmu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mewö jiiga Abrahamnöŋ ahöba söŋan kötökŋe wahöta doŋki qakŋe dum tatatŋi möhamgöba welenqeqeŋi yahöt aka nahönŋi Aisak eŋguaŋgirök. Jöwöwölgö könöpŋi dopŋe köl teköba börangöba ala eŋguaŋgita Anutunöŋ gölme jiyöhi, miaŋgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Anda mala wehön karöbutŋi miaŋgöreŋ jeŋan uba wahöta gölme mi ehiga köröwen ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Mi eka welenqeqe yahötŋi yetköra kewö jiyök: “Iŋiri doŋkibuk ki tarohotka ni aka morö nahön netkön endu anda Anutu waikŋi memba möpöseiba kunbuk liliŋgöba etköreŋ kabit.” ");
INSERT INTO bmu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahamnöŋ mewö jiba jöwöwöl ohohogö könöp böranŋi memba nahönŋi Aisakö qamböŋe ali öŋgöiga nanŋak könöp jit aka sou meyök. Mewö meiga mohotŋamŋire anohot. ");
INSERT INTO bmu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Mewö anda Aisaknöŋ aŋ ala iwiŋi Abrahamgöra kewö jiyök: “Iwini!” Mewö jiiga kewö meleŋnök: “Nahöni, wania?” Mewö meleŋniga kewö qesiyök: “Könöp jitŋi aka könöp mia ki memba kazitmö, jöwöwöl ohohogö lamaŋi mi denike?” ");
INSERT INTO bmu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Mewö qesiiga iwiŋan kewö meleŋnök: “Nahöni, Anutu nanŋak mönö jöwöwöl ohohogö lamaŋi kun miwikŋaiba netkima. “Mewö meleŋniga toroqeba mohotŋamŋire anohot. ");
INSERT INTO bmu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Anda Anutunöŋ gölme jiyöhaŋgöreŋ aŋgota kinda jöwöwöl ohohogö altaŋi kun memba könöp miaŋgö qakŋe ala areŋgöyök. Areŋgöba nahönŋi Aisak jöhöba altanöŋ könöp qakŋe al waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Al waŋgiba nahönŋi umamgöra böröŋi böraŋda sou memba atöŋnök. ");
INSERT INTO bmu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Atöŋniga miaŋgöreŋök Kembugöreŋ garatanöŋ Suepnöhök Abrahamgöra kewö qerök: “Abraham, Abraham!” Mewö qeriga “Ni ki kinjal,” jiba meleŋnök. ");
INSERT INTO bmu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mewö meleŋniga kewö jiyök: “Börögan mönö morögö qakŋe kude alman. Yaŋgö qakŋe yuai kun kude akŋan. Göŋön nahöngi mohotsirik mi nöŋgöra qahö aŋgön köljanaŋgöra könaŋamgi merak kewö möt yaközal: Gi Anutugö keu jitŋi oŋgitpanbuköra keŋgötki mörakzan.” ");
INSERT INTO bmu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Mewö jiiga miaŋgöreŋök uba wahöta ehiga lama aziŋi kun ilitŋan böŋbaŋ ip köhösönöŋ gili geiga kinök. Mi eka anda memba kaba nahönŋaŋgö salupŋe lama miaŋön jöwöwöl ohoyök. ");
INSERT INTO bmu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Miaŋgöra Abrahamnöŋ gölme miaŋgö qetŋi mi ‘Kembunöŋ miwikŋaiba netkima,’ jiba qerök. Nalö kewöŋe mewöŋanök keu kewö jimakze: “Kembunöŋ mi kunduŋe miwikŋaiba netkima.” ");
INSERT INTO bmu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kembugö garataŋan Abrahamgöra Suepnöhök kunbuk kewö qeriga yahöt ahök: ");
INSERT INTO bmu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Kembu nöŋön kewö jizal: Nanak nani qetni qeta jöjöpaŋ keu kewö jiba jim köhöizal: Göŋön silik ki aka nahöngi mohotsirik mia nöŋgöra qahö aŋgön köljani, ");
INSERT INTO bmu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","miaŋgöra nöŋön ölŋa gi kötuetköba ahumsehip gihibiga gwölönarökurupki yeŋön önöŋi qahö sehime. Sehigetka qötöŋinan mönö suep könakembagö seŋgelauŋi ewö akŋa aka köwet jitŋe sakösiŋ ahöm anjei, miaŋgö dop akŋa. Göhö gwölönarökurupki yeŋön mönö köhöiba kerökurupŋini eŋguba luhut ala siti gölmeŋini eŋguaŋgita aŋgön köla malme. ");
INSERT INTO bmu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Göŋön nöŋgö keuni tem köljani, miaŋgöra göhö gwölönarökurupki yeŋgöreŋök kungöra aka nöŋgö kötumötuetnan mönö gölmegö könagesö kambuŋi pakpak yeŋgö qakŋine öŋgöiga oyaeŋkoyaeŋ akŋe.” ");
INSERT INTO bmu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kembugö garataŋan mewö jiiga Abrahamnöŋ moröŋambuk liliŋgöba welenqeqeyahötŋi yetköreŋ anda aitoŋgöba mohotŋe Berseba mire anget. Abrahamnöŋ Berseba miri miaŋgöreŋ opo seri koumŋi möröreŋgöba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nalö tosatŋi teköiga buzup keu kun kewö jigetka Abrahamgöreŋ kayök: “Milkanöŋ mewöŋaŋök nama akza. Yaŋön mungi Nahorgö nahönurupŋi tosatŋi eŋgömeyök.” ");
INSERT INTO bmu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Moröŋi mutukŋaŋgö qetŋi mi Uz, yaŋgö munŋi Buz aiga yaŋgö könaŋe Kemuel, Aramgö iwiŋi. ");
INSERT INTO bmu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kemuelgö könaŋe Kesed, Hazo, Pildas, Jidlaf aka Betuel. ");
INSERT INTO bmu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuelnöŋ Rebekagö iwiŋa ahök. Milkanöŋ Abrahamgö munŋi Nahorgö nahönurupŋi 8 mi eŋgömeyök. ");
INSERT INTO bmu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahorgö anömŋi bohonŋi qahö memeŋi qetŋi Reuma yaŋön mewöŋaŋök nahönurupŋi tosatŋi eŋgömeyök. Yeŋgö qetŋini mi Teba, Gaham, Tahas aka Maka. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saranöŋ mala mal öŋgöiga yambuŋi 127 ahök. Saranöŋ miaŋgö dop malök. ");
INSERT INTO bmu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Mala Keinan gölmenöŋ miri qetŋi Kiriat Arba, qetŋi alaŋi Hebron qerakzei, miaŋgöreŋ kömuyök. Kömuiga Abrahamnöŋ miaŋgöreŋök anömŋaŋgöra jiŋgen köla sahötmamgöra anök. ");
INSERT INTO bmu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Anda sahöt teköba wahöta anömŋaŋgö qamötŋi mosöta anda kinda Hit ambazip yeŋgöra keu kewö jiyök: ");
INSERT INTO bmu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ni eŋgö sutŋine kiana kaba qandak (kusuk) maljal. Miaŋgöra iŋini mönö gölmeŋinaŋgö bahöŋi kun kiaŋgöreŋ niŋgigetka bohonŋi membiga qaksirini aiga alaurupni yeŋgö qamötŋini miaŋgöreŋ ala löm köl eŋgimakŋam.” ");
INSERT INTO bmu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Keu mewö jiiga Hit yeŋön meleŋda kewö jiget: ");
INSERT INTO bmu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“O azi kembu, gi ölöp neŋgöreŋ keu ki mötnöŋ. Gi neŋgö sutnine Anutugö azi jembonŋi maljanaŋgöra aka qaksirigi sihimgan denike ek soroköba memangö mötzani, miaŋgöreŋ mönö ölöp qamötki löm kölman. Göŋön qamötki esim kölmam jinöŋga neŋgöreŋök kunŋan mi qahö aŋgön köl gihima.” ");
INSERT INTO bmu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Mewö jigetka Abrahamnöŋ wahöta gölme tourupŋi Hit ambazip yeŋgö wösöŋine geba sipköm eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Sipköm eŋgiba kinda yeŋgöra keu kewö jiyök: “Nöŋön qamötni esim kölmamgö ölöp jime ewö, mönö nöŋgöreŋ keu ki möta Zohargö nahönŋi Efron yaŋgöreŋ anda keu jitni ki toroqeba jiba kuŋgum waŋgime. ");
INSERT INTO bmu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Kuŋgum waŋgigetka möta baŋet qetŋi Makpela yaŋgö buŋaya aka nupŋaŋgö imbiŋe göröken ahözawi, mönö mia jim teköiga söŋgöröŋi memam. Mönö qesigetka bohonŋi jömuk jim teköiga söŋgöröŋi membiga nöŋgö qaksirini eŋgö sutŋine ahöma.” ");
INSERT INTO bmu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Mewö jiiga Efronöŋ alapurupŋi Hit könagesö pakpak taonŋinaŋgö kiripo naŋguŋe kaba sombemnöŋ tokogeri, yeŋgö sutŋine tariga keu kezap ala mötketka Efronöŋ Abrahamgöra kewö meleŋ waŋgiyök: ");
INSERT INTO bmu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“O azi kembuni, mewö qahöpmö, mönö nöŋgöra kezap alnöŋ. Nöŋön gölme köröŋi mi aka baŋet miaŋgöreŋ kinjawi, mi kalema gihizal. Nani könagesöurupni yeŋgö jeŋine kinda mi gihibiga ekze. Qamötki mi ölöp miaŋgöreŋ esim löm kölman.” ");
INSERT INTO bmu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Mewö jiiga Abrahamnöŋ gölme tourupŋi yeŋgö wösöŋine kunbuk geba sipköm eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Sipköm eŋgiba kinda yeŋgö jeŋine Efrongöra kewö jiiga mötket: “Nöŋgöreŋ keu ki mönö kezap ala mötnöŋ. Göŋön ölöp mewö akanakmö, nöŋön mönö gölme köröŋi miaŋgö bohonŋi mi gihimam. Mi ölöp jiba töwa menöŋga nöŋön qamötni miaŋgöreŋ esim löm kölmam.” ");
INSERT INTO bmu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Mewö jiiga mötketka Efronöŋ Abrahamgöra kewö meleŋ waŋgiyök: ");
INSERT INTO bmu_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“O azi kembuni, nöŋgöreŋ keu ki mönö kezap ala mötnöŋ. Gölme miaŋgö bohonŋi mi 400 silwö kötŋi (50 kilogram). Ala-ala akziraŋgöra aka miaŋön mönö netkö sutnire yuai omaŋi akza. Miaŋgöra qamötki ölöp esim löm kölman.” ");
INSERT INTO bmu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Mewö meleŋ waŋgiiga möta Abrahamnöŋ gölme bohonŋaŋgö jaŋgöŋi Efronöŋ Hit könagesö yeŋgö jeŋine jiiga mötkeri, miaŋgö urumohot ahök. Jaŋgöŋi silwö kötŋi 400 mi kölköl-örörö ambazipnöŋ nalö miaŋgöreŋ bohonŋaŋgö dopŋi jiget ahöyöhi, miaŋgö dop moneŋ mi kewöta waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Mewö waŋgiiga Efrongöreŋ gölme köröŋi Mamre kösutŋe Makpela miaŋgöreŋ ahöyöhi, baŋet miaŋgöreŋ kinöhi aka ip pakpak gölme miaŋgö jabö uruŋe kingeri, miaŋgö keuŋi teköyök. ");
INSERT INTO bmu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Keuŋi teköiga Abrahamgö buŋaya ahök. Hit könagesö pakpak taonŋinaŋgö kiripo naŋguŋe kaba sombemnöŋ tokogeri, yeŋön töwaŋi mi eketka buŋaŋi ahök. ");
INSERT INTO bmu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Miaŋgö andöŋe Abrahamnöŋ anömŋi Saragö qamötŋi mi Keinan gölmegö baŋetŋe esim löm kölök. Baŋet mi Mamre qetŋi alaŋi Hebron miaŋgö kösutŋe gölme köröŋi qetŋi Makpela miaŋgöreŋ ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mewö asuhuiga gölme köröŋi aka baŋet miaŋgöreŋ kinjawi, mi Hit könagesö yeŋön Abrahamgö buŋaya qem waŋgigetka qaksiriŋi ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamnöŋ azi namŋi ahiga Anutunöŋ yuai pakpak aka meyöhi, miaŋgöreŋ i kötuetköm waŋgii mala korök. ");
INSERT INTO bmu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Mewö ahiga nalö kunöŋ miriŋaŋgö welenqeqe jembonŋi bohonŋi, miriŋi uruŋe öröyuai ahöm waŋgiyöhi, miaŋgö galömŋi yaŋgöra keu kewö jiyök, “Gi mönö keugi jim köhöimangöra börögi nöŋgö tambuni bapŋe alman. ");
INSERT INTO bmu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Mewö ala Kembu, Suep aka gölme mietkö Anutuŋiraŋgö qetŋe jöjöpaŋ keu kewö jiman: Nöŋön Keinan könagesö yeŋgö sutŋine ki maljalmö, göŋön mönö nahönaŋgö anömŋi mi yeŋgö nen böratŋina kun kude memba waŋgiman. ");
INSERT INTO bmu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mewö qahöpmö, gi mönö nane kantrinöŋ anda tinitosolomurupni yeŋgöreŋök nahöni Aisakö anömŋa waŋgita kaman.” ");
INSERT INTO bmu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mewö jiiga welenqeqe jembonöŋ kewö qesim waŋgiyök: “Anda jibiga ambi miaŋön nömbuk gölme kiaŋgöreŋ kamamgö tököma ewö, nöŋön mönö denöwö akŋam? Nahöngi waŋgita kantri kanöŋaŋgöreŋ kunbuk liliŋgöba anbit me qahö?” ");
INSERT INTO bmu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Mewö qesim waŋgiiga Abrahamnöŋ kewö meleŋnök: “Qahöpmahöp! Gi nöŋgö nahöni waŋgita miaŋgöreŋ kunbuk kude anmahot. ");
INSERT INTO bmu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Suepkö Kembuŋi Anutunöŋ ni iwinaŋgö miri aka ahuahu kantrineyök keu kewö jii mötpiga jöjöpaŋ keunöŋ jöhöba noaŋgiri kayal: ‘Nöŋön gölme ki mönö göhö gwölönarökurupki yeŋgö buŋaya qem eŋgimam.’ Miaŋgöra yaŋön mönö Suep garataŋi melaiiga mutuk aniga göŋön ölöp nahönaŋgö anömŋi mi miaŋgöreŋök waŋgita kaman. ");
INSERT INTO bmu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Anda jinöŋga ambi miaŋön göbuk kamamgö tököma ewö, jöjöpaŋ keugi kiaŋön mönö qahö toroqeba jöhöm gihima. Nöŋgö nahöni mi mönö qahö kötökŋi waŋgita miaŋgöreŋ liliŋgöba anmahot.” ");
INSERT INTO bmu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Mewö jiiga welenqeqe jembonŋan keu mi jim jöhöm waŋgiba jöjöpaŋ keunöŋ jim köhöimamgöra böröŋi ketaŋamŋi Abrahamgö tambuŋi bapŋe alök. ");
INSERT INTO bmu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Mewö jim köhöiba kinda ketaŋamŋaŋgöreŋ kamel 10 aka yaŋgö köweŋeyök yuai aködamunŋinambuk könaŋi könaŋi mohotŋe meyök. Mi memba mosöta Not Mesopotemia (Aram Naharaim) kantrinöŋ anda Nahornöŋ taon malöhaŋgöreŋ aŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Aŋgota taon yaigepŋe o lömŋi kinöhaŋgö kösutŋe kamelurupŋi al eŋgiiga siminŋini mösököba geba luhut meget. Wehön jeŋi gemamgö aiga taongö ambiŋi yeŋön o ubingö o lömŋe kaka nalöŋini mi ahök. ");
INSERT INTO bmu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Miaŋgöreŋ kinda kewö köuluköyök: “O Kembu, ketaŋamni Abrahamgö Anutuŋi, gi mönö merak töhötmöriam niŋgiba ketaŋamni Abrahamgöra keu jim jöhönöŋi, miaŋgö ölŋi asuhuma. ");
INSERT INTO bmu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mötnöŋ, ni o löm kösutŋe kiaŋgöreŋ kinbiga taongö ambi seramurupŋini yeŋön o ubingö kame. ");
INSERT INTO bmu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kagetka kewö asuhumapköra köuluközal: Nöŋön ambi seram kungöra kewö jimam: ‘Gi ölöp köuraŋengi möŋgoninöŋga (mondokönöŋga) o nembileŋak.’ Mewö jibiga yaŋön kewö meleŋda jima: ‘Ölöp nenöŋga kamelurupki mewöyök o gumohom eŋgimam.’ Mewö jimawi, ambi seram ia göŋön welenqeqe azigi Aisakö buŋaya qenöŋi, yaŋön mönö mia akŋa. Mewö asuhuiga göŋön ketaŋamnaŋgöra keu jim jöhönöŋi, miaŋön ölŋambuk akza, mewö mötmam.” ");
INSERT INTO bmu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Köuluk mi qahö köuluköm teköiga miaŋgöreŋök ambi kun qetŋi Rebeka yaŋön köuraŋen qamböŋe aŋguba miaŋgöreŋ kaŋgorök. Yaŋön Abrahamgö munŋi Nahor aka anömŋi Milka, yetkö nahönŋiri qetŋi Betuel yaŋgö böratŋa ahök. ");
INSERT INTO bmu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ambi miaŋgö kaisoŋgolomŋi mi eksihimŋambuk kötökŋi aiga ambi seram jömukŋi azinöŋ qahö memeŋa malök. Yaŋön eta o lömnöŋ geba o uba korök. ");
INSERT INTO bmu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Koriga miaŋgöreŋök welenqeqe jembonöŋ ösumŋan yaŋgö kösutŋe anda kewö jiyök: “Gi ölöp köuraŋengeyök o kun niŋginöŋga nembileŋak.” ");
INSERT INTO bmu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mewö jiiga kewö meleŋnök: “O kembuni, ölöp neman. “Mewö jiba ösumok köuraŋenŋi böröŋan memba eta moŋgoŋgoniiga (mondoköiga) o neyök. ");
INSERT INTO bmu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mi neiga kewö jiyök: “Nöŋön kamelurupki yeŋgöra mewöyök o uba eŋgibi nemba anda bikŋini eŋguiga mosötme.” ");
INSERT INTO bmu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Mewö jiba ösumok köuraŋenŋi mokoi o körek joutnöŋ geiga kunbuk diŋdiŋgöba o lömnöŋ o umamgöra geba kamelurupŋi pakpak yeŋgöra o dopŋine uyök. ");
INSERT INTO bmu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mewö ahiga welenqeqe jembonöŋ göröŋ kinda i törörök eka kewö möta mötmöriyök: “Ölŋa, Kembunöŋ köna köröpŋi ki kayalaŋgö möriamŋi mi mönö kewö kondori asuhuza me denöwö?” ");
INSERT INTO bmu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mewö mötmöriba kiniga kamel yeŋön o nem tekögetka welenqeqe jembonöŋ pinjim (möpöŋ) goulnöŋ memeŋi kun lömbötŋi 5 gram mi memba ambi seramgö söŋgöröŋe ala böröjeŋjeŋ goulnöŋ memeŋi yahöt lömbötŋiri 110 gram mi böröŋe mei öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Mei öŋgöiga kewö qesim waŋgiyök: “Gi dagö böratŋa? Iwigahö miri uruŋe neŋön suŋgem ahöbinakö tiŋi kun ahöza me qahö, mi ölöp jinöŋ mötpileŋak.” ");
INSERT INTO bmu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mewö qesim waŋgiiga kewö meleŋ waŋgiyök: “Ni Betuelgö böratŋa. Abu asani qetŋiri Milka aka Nahor.” ");
INSERT INTO bmu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Mewö jiba toroqeba kewö jiyök: “Neŋgöreŋ luplup aip aka kamel yeŋgö gwözözak neneŋi mi gwötpuk ahöza aka suŋgem gaun ahömegö tiŋi mi mewöyök ölöp kinja.” ");
INSERT INTO bmu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mewö jiiga welenqeqe jembonöŋ gölmenöŋ geba bamgöba Kembugö waikŋi memba möpöseiyök. ");
INSERT INTO bmu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Möpöseiba kewö jiyök: “O Anutu, ketaŋamni Abrahamgö Kembuŋi, nöŋön gi möpöseim gihizal. Göŋön ketaŋamnaŋgöra kalem möriamgö keugi jim jöhönöŋi, mi törörök wuataŋgönöŋga qahö sörauyök. Miaŋgö dop Kembu göŋön noaŋgitnöŋga köna köröpŋi ki kaba mala ketaŋamnaŋgö tinitosolomurupŋi yeŋgö mire kaŋgotzal.” ");
INSERT INTO bmu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mewö asuhuiga ambi seramnöŋ ösumŋan kiŋkiŋgöba anda miaŋgö kösohotŋi mi namŋaŋgö saiwaurupŋi miriŋe malgeri, yeŋgöra jiiga mötket. ");
INSERT INTO bmu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekagö nenŋi qetŋi Laban malök. Yaŋön mi möta Abrahamgö welenqeqe jembonŋi ekŋamgöra ösumŋan yaigep o lömŋe kiŋkiŋgöba anök. ");
INSERT INTO bmu_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Nenŋaŋgö böröŋe goul böröjeŋjeŋ aka söŋgöröŋe goul pinjim tari ehiga nenŋi Rebekanöŋ welenqeqe jembonöŋ keu jiiga möröhi, miaŋgö kösohotŋi jii möta yaŋgöreŋ anök. Anda o lömŋe aŋgota azi mi ehiga miaŋgöreŋ kamelurupŋi yeŋgö qöhöröŋine kinök. ");
INSERT INTO bmu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kiniga kewö jiyök: “Kembunöŋ kötuetköm gihii maljani, gi mönö kanöŋga mirinöŋ anbit. Yaigep kiaŋgöreŋ kude kinman. Nöŋön nanŋini ahömeaŋgö miriŋi aka kamelurupki yeŋgö dumŋini tok möwölöhözal.” ");
INSERT INTO bmu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mewö jiiga welenqeqe jembonöŋ mire kaiga kamel qakŋine sukinap taröhi, mi Labanöŋ musula mei eri jiiga kamel yeŋgöra luplup aip aka gwözözak nene memba kaba eŋgiget. Welenqeqe jembon aka yaŋgö aziurupŋan könaŋini saŋgoŋmeaŋgö oŋi mi tok mohotŋe uba kaba eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Miaŋgö andöŋe nene welenqeqe jembongö wösöŋe kölgetmö, yaŋön kewö jiyök: “Mutuk keu memba kazali, mi jibi mötketkun mönö nene ki nemam. “Mewö jiiga Labanöŋ kewö jiyök: “Mi ölöp jinöŋ mötpin.” ");
INSERT INTO bmu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Mewö jiiga kewö jiyök: “Nöŋön Abrahamgö welenqeqe azia akzal. ");
INSERT INTO bmu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Kembunöŋ ketaŋamni önöŋi qahö kötuetköm waŋgiiga azi öŋgöŋgöŋi sukinapuk aka malja. Kembunöŋ lama aka bulmakau, silwö aka goul, welenqeqe azi aka ambi aka kamel, doŋki mi gwötpuk waŋgiiga malja. ");
INSERT INTO bmu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ketaŋamnaŋgö anömŋi Sara yaŋön ambi namŋi kötökŋi aka nalö miaŋgöreŋ ketaŋamnaŋgöra nahönŋi kun meyök. Iwiŋan sukinapŋi pakpak mi nahönŋaŋgöra buŋa qem waŋgii malja. ");
INSERT INTO bmu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","“Ketaŋamnan nöŋön jöjöpaŋ keu kewö jimamgö jim kutum niŋgiyök: ‘Nöŋön Keinan yeŋgö gölmenöŋ ki maljalmö, göŋön mönö nahönaŋgö anömŋi mi Keinan yeŋgö nen böratŋina kun kude memba waŋgiman. ");
INSERT INTO bmu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mewö qahöpmö, gi mönö iwinaŋgö mire nani tinitosolomurupni yeŋgöreŋ anda nahönaŋgö anömŋi mi miaŋgöreŋök waŋgita kaman.’ ");
INSERT INTO bmu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Mewö jiiga ketaŋamni mi kewö qesim waŋgial, ‘Nöŋön anda jibiga ambi miaŋön nömbuk qahö kama ewö, nöŋön mönö denöwö akŋam?’ ");
INSERT INTO bmu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Mewö qesim waŋgibiga kewö meleŋnök: ‘Nöŋön Kembugö jeŋe anda kaba aka memba malali, yaŋön mönö Suep garataŋi melaiiga göbuk aniga köna anmani, miaŋön töhötmöriamŋambuk akŋa. Mewö nani iwinaŋgö mire anda tinitosolomurupni yeŋgöreŋök nahönaŋgö anömŋi mi memba kaman. ");
INSERT INTO bmu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nöŋgö tinitosolomurupni yeŋgöreŋ anda jöjöpaŋ keu nöŋgöra jinöŋi, miaŋön mönö miaŋgö andöŋe qahö toroqeba jöhöm gihima. Ambi kun qahö gihime ewö, göŋön töndup jöjöpaŋ keu miaŋgö kösönöhök lolohoman.’ ");
INSERT INTO bmu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mewö jiiga merak o lömŋe kaŋgota kinda kewö köuluközal: ‘O Anutu, ketaŋamni Abrahamgö Kembuŋi, ni köna köröpŋi kazali, mi mönö jitsihitkahö dop mötnöŋga töhötmöriamŋambuk akŋa. ");
INSERT INTO bmu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Eknöŋ, nöŋön o löm kiaŋgö kösutŋe kinjal. Kewö kinbiga ambi seram kunŋan o umamgö kaiga nöŋön yaŋgöra kewö jimam: “Gi ölöp köuraŋengeyök o moröŋi kun niŋginöŋga nembileŋak?” ");
INSERT INTO bmu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Mewö jibiga yaŋön kewö meleŋda jima: “Ölöp nenöŋga kamelurupki yeŋgö o mewöŋanök uba eŋgimam. “Mewö meleŋda jima ewö, nöŋön miaŋgöra kewö mötmam: Kembu göŋön i ketaŋamnaŋgö nahönŋaŋgö anömŋa akŋapköra möwölöhözan.’ ");
INSERT INTO bmu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Uruneyök köuluk mi qahö köuluköm teköbiga miaŋgöreŋök Rebeka yaŋön köuraŋen qamböŋe aŋguba miaŋgöreŋ kaŋgotza. Kaŋgota o lömŋe geba o uiga nöŋön yaŋgöra kewö jizal: ‘Ölöp o kun niŋginöŋga nembileŋak.’ ");
INSERT INTO bmu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Mewö jibiga yaŋön zilaŋ köuraŋenŋi qamböŋeyök mei eriga kewö jiza: ‘Ölöp nenöŋga kamelurupki yeŋgö o mewöŋanök eŋgibiga neme.’ Mewö jii nembiga kamelurupni mi mewöyök o gumohom eŋgiza. ");
INSERT INTO bmu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Gumohom eŋgiiga kewö qesim waŋgizal, ‘Gi dagö böratŋa?’ Qesim waŋgibiga kewö meleŋja: ‘Ni Betuelgö böratŋa. Abu asani qetŋiri Milka aka Nahor.’ Mewö meleŋniga nöŋön pinjim söŋgöröŋe möndöba böröjeŋjeŋ böröŋe membi öŋgöza. ");
INSERT INTO bmu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nalö miaŋgöreŋök gölmenöŋ geba bamgöba Kembugö waikŋi memba möpöseizal. Anutu ketaŋamni Abrahamgö Kembuŋan mönö köna diŋdiŋi noaŋgiri ketaŋamnaŋgö munŋaŋgö mire kaba isiŋi nahönŋaŋgö anömŋa akŋapköra miwikŋaizal. Miaŋgöra Kembu möpöseim waŋgizal. ");
INSERT INTO bmu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","“Mewö kaba ki kinjal. Miaŋgöra iŋini ketaŋamni ek soriba sepkitip akzeaŋgö keuŋi pöndaŋ wuataŋgöba ak kömum waŋgize ewö, mi mönö kondela jigetka mötmam. Mewö qahö akŋe ewö, keu mi tok jigetka mötmam. Mi möta kungen eleŋda anmamgö mötmörimam.” ");
INSERT INTO bmu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Mewö jim teköiga Laban aka Betuel yetkön kewö meleŋda jiyohot, “Keu ki Kembugöreŋök kaza. Miaŋgöra netkön keu mewö me mewö jibiraŋgö dop qahö. ");
INSERT INTO bmu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mötnöŋ, Rebekanöŋ ki kinja. Kembunöŋ jimqindiŋ akzawaŋgö dop ölöp i waŋgita anda ketaŋamgahö nahönŋi waŋginöŋga anömŋi akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mewö jiyohotka keuŋiri möta Abrahamgö welenqeqe jembonŋan eta Kembugö jeŋe gölmenöŋ geba bamgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Bamgöm teköiga wahöta gösöŋeyök goul aka silwö aködamunŋi eksihimŋinambuk aka opo maluku kulemŋinambuk ujeta Rebeka waŋgiyök. Mewöŋanök kalem yuai tosatŋi söŋgöröŋini ketaŋi mi nam nenŋi etkiyök. ");
INSERT INTO bmu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Etkiba i aka aziurupŋi yambuk kageri, yeŋön nene kuluŋ nemba tata mala suŋgem aiga ahöget. Ahöba söŋan wahötketka kewö jiyök: “Ölöp melaim niŋgigetka ketaŋamnaŋgöreŋ anmam.” ");
INSERT INTO bmu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mewö jiyökmö, nam nenŋi yetkön kewö meleŋnohot, “Ölöp nenböratniri mosötnöŋga toroqeba nalö tosatŋi silim ten mewö nembuk malma. Miaŋgö andöŋe ölöp i waŋgita anme.” ");
INSERT INTO bmu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mewö meleŋnohotmö, welenqeqe jembonöŋ kewö meleŋda jii mötket, “Welen könani kazali, mi Kembunöŋ kötuetköiga töhötmöriamŋambuk akza. Miaŋgöra nalöni mönö kude qekörime. Mönö melaim niŋgigetka ölöp könani liliŋgöba anda ketaŋamnaŋgöreŋ aŋgotmam.” ");
INSERT INTO bmu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Mewö jii möta kewö jiyohot, “Ölöp ambi seram mi qetzi kaiga nanŋaŋgöra qesim waŋgibin.” ");
INSERT INTO bmu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Mewö jiba Rebeka qerohot kaiga kewö qesim waŋgiyohot, “Gi azi kiambuk anmamgö mötzan me qahö?” Qesim waŋgiyohotka “Ölöp anmam,” jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Mewö jiiga kinda nenböratŋiri mi welen ambiŋambuk melaim etkigetka Abrahamgö welenqeqe jembon aka yaŋgö aziurupŋi yeŋön i etkuaŋgita anbingö aket. ");
INSERT INTO bmu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Anbingö aketka miaŋgöreŋ iwinam nenmunurupŋan Rebeka kötuetköm waŋgiba kewö jiget, “O nen böratnini, Kembunöŋ ölöp ahumsehip gihiiga göŋön gwölönarökurupki milyönŋi milyönŋi yeŋgö bömön jalöŋina akŋan. Yeŋön mönö köhöiba kerökurupŋini eŋguba luhut ala siti gölmeŋini eŋguaŋgita aŋgön köla malme.” ");
INSERT INTO bmu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Mewö jiget teköiga Rebekanöŋ welenqeqeambiurupŋi yembuk wahöta kamel qakŋine öŋgöba tata welenqeqe jembonŋi wuataŋgöba anget. Jembon yaŋön Rebeka waŋgiriga mosöta köna liliŋgöba anget. ");
INSERT INTO bmu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Anda kaba mala mala Keinan gölmenöŋ kaŋgotket. Aisaknöŋ gölme miaŋgö Saut likepŋe distrik qetŋi Negew miaŋgöreŋ mala nalö miaŋgöreŋök o löm qetŋi Ber Lahai Roi mi mosöta gölme qararaŋkölkölŋe kaba malök. ");
INSERT INTO bmu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kaba mala miri söŋaumamgö aiga miaŋgöreŋ koumŋi mosöta gölme köröŋi ketaŋi miaŋgöreŋ anda liliköba keu mötmöriba uba wahöta ehiga tosatŋan kamel qakŋine tata yaŋgö kösutŋe kabingö kaget. ");
INSERT INTO bmu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Mewö kagetka Rebekanöŋ uba wahöta Aisak eka kamel qakŋe taröhi, miaŋgöreŋök ösumok luhuba gölmenöŋ erök. ");
INSERT INTO bmu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Eta welenqeqe jembongöra qesiba kewö jiyök, “Azi gölme köröŋe endu kinda mesohol köl neŋgiba kazawi, mi daŋön?” Mewö jiiga kewö meleŋnök, “Yaŋön mönö ketaŋamnaŋgö nahönŋi akza. “Mewö meleŋniga möta nöröp kawöseŋi (kawaseŋ) öröba jemesoholŋi esuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Esuhuiga aitoŋgögetka welenqeqe jembonöŋ yuai pakpak aka memba malöhi, miaŋgö kösohotŋi mi Aisaköra jii mörök. ");
INSERT INTO bmu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Möri teköiga Aisaknöŋ Rebeka waŋgiriga namŋi Saragö opo seri koumŋe öŋgöba maliga könaŋgep mei anömŋi aiga uruŋan jöpaköm waŋgiba malök. Aisakö namŋan kömuiga wösöbirik uruŋe malöhaŋgöra aka urukölalepŋi mewö miwikŋaiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aisaknöŋ ambi meiga iwiŋi Abrahamnöŋ anömŋi kun qetŋi Ketura meyök. ");
INSERT INTO bmu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Meiga Keturanöŋ Abrahamgö moröurupŋi kewö eŋgömeyök: Zimran, Joksan, Medan, Midian, Isbak aka Sua. ");
INSERT INTO bmu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksanöŋ nahönyahötŋi qetŋiri Seba aka Dedan yetkö iwiŋira ahök. Dedan yaŋön Asur könagesö, Letus könagesö aka Leum könagesö yeŋgö bömönŋini ahök. ");
INSERT INTO bmu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiangö nahönurupŋi mi Efa, Efer, Hanok, Abida aka Elda. Mi pakpak Keturagö isiurupŋi aka malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahamnöŋ sukinapŋi pakpak mi nahönŋi Aisak buŋa qem waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mi waŋgiyökmö, anömurupŋi bohonŋini qahö memeŋi yeŋgö nahönurupŋini yeŋgöra kalem yuai toto qeba mendeŋda eŋgiyök. Mendeŋ eŋgiba jebuk mala melaim eŋgiiga datŋini Aisak mosöta gölme wehön kotkotŋe göröken miaŋgöreŋ anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamnöŋ mala koriga yambuŋi mindiriba 175 aiga kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Malmal yambuŋaŋgö qötöŋan öŋgöŋgöŋi aka dop köliga öliba azi namŋi aka söŋgörö ösum kondikŋi öröba nöŋ qeba kömuiga Anutunöŋ waŋgiri tinitosolomurupŋan kömugeri, yeŋgöreŋ anda toroqeyök. ");
INSERT INTO bmu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kömuiga nahönyahötŋi Aisak aka Ismael yetkön iwiŋiraŋgö qamötŋi memba anda Makpela baŋetnöŋ löm kölohot. Baŋet mi Hit azi Efron Zohargö nahönŋi yaŋgö gölme köröŋe Mamre miri gölmenöhök wehön kotkotŋe göröken ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abrahamnöŋ gölme köröŋi mi Hit könagesö yeŋgöreŋök bohonŋi meyöhi, miaŋgöreŋ i aka anömŋi Sara mi löm köl etkiget. ");
INSERT INTO bmu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahamnöŋ kömuiga Anutunöŋ nahönŋi Aisak kötuetköm waŋgiba malök. Yaŋön Negew gölmenöŋ o löm qetŋi Ber Lahai Roi (Malmalŋambuk mala nehakzawaŋgö o lömŋi) miaŋgö kösutŋe tata malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ijipt ambi Hagar yaŋön Saragö welen ambia maliga Abrahamnöŋ meiga gölöm ala nahönŋi Ismael meyök. Ismaelgö nahönurupŋi yeŋgö qet areŋini kewö: ");
INSERT INTO bmu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismaelgö nahönurupŋi yeŋgö qetŋini aka asuhugeraŋgö areŋini mi kewö: Nahönŋi mutukŋi qetŋi Nebaiot. Yaŋgö könaŋe Kedar, Adbel, Mibsam, ");
INSERT INTO bmu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","toroqeba Misma, Duma aka Masa, ");
INSERT INTO bmu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafis aka Kedema. ");
INSERT INTO bmu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismaelgö nahönurupŋan mewö asuhuba kambuŋinaŋgö dop pomŋini 12 aka mala kotket. Pomŋini qetkeri, miaŋgö dop opo koum tamböŋini aka jike miriŋini mewöyök qeta memba mala kotket. ");
INSERT INTO bmu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelnöŋ mala koriga yambuŋi mindiriba 137 aiga kömuyök. Mewö azi namŋi aka söŋgörö ösum kondikŋi öröba nöŋ qeba kömuiga Anutunöŋ waŋgiri tinitosolomurupŋan kömugeri, yeŋgöreŋ anda toroqeyök. ");
INSERT INTO bmu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismaelgö gwölönarökurupŋi yeŋön köröpken köröpken deŋda anda mala gölme qetŋiri Hawila aka Sur mietkö sutŋire gölme memba malget. Gölmeŋini mi Ijipt kantrigö jaböŋeyök könahiba wehön kotkotŋe Asiria göröken angeri, köna miaŋgö kösutŋe miaŋgöreŋ ahöza. Ismaelgö gwölönarökurupŋi yeŋön Abrahamgö gwölönarökurupŋi tosatŋi pakpak mi kerök-kerök ak eŋgiba malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abrahamgö nahönŋi Aisak yaŋgö gwölönarökurupŋi yeŋgö qet areŋini mi kewö: Abrahamgö nahönŋi Aisak. ");
INSERT INTO bmu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisaknöŋ yambuŋi 40 aiga Mesopotemia (Padan Aram) kantrigö Aram azi qetŋi Betuel yaŋgö böratŋi Rebeka anömŋa meyök. Rebekagö nenŋi mi Aram azi qetŋi Laban. ");
INSERT INTO bmu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisaknöŋ anömŋan köpin maliga yaŋgöra aka Kembu köuluköm waŋgiyök. Köuluköm waŋgiiga köulukŋi möriga Rebekanöŋ gölöm alök. ");
INSERT INTO bmu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Gölöm aliga moröyahöt yetkön namŋiraŋgö körö uruŋe utal aŋguyohot. Mi möta kewö jiyök: “Yuai kewöŋi mi mönö wuanöŋgöra asuhum niŋgiza?” Mewö jiba anda miaŋgöra Kembugö qesim waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Qesim waŋgiiga kewö jii mörök: “Göhö körö uruge kambu yahöt mietkö bömönŋiri ahözahot. Yetköreŋök könagesö yahöt asuhuba deŋda malme. Ambazip kambu kunöŋ kambu alaŋi eŋgoŋgita ösum köhöikŋi akŋe. Datŋan munŋi welen qem waŋgiba malma.” ");
INSERT INTO bmu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Morö meme nalöŋan kam kuŋguiga köröŋi uruŋe morö nahön siwisiwi yahöt ahöyohot. ");
INSERT INTO bmu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mutuk köröŋeyök asuhuyöhi, yaŋgö sileŋan pisikpisik aiga sile jupŋan sileŋi körek dop köla ahöyök. Miaŋgöra qetŋi Iso (jupŋambuk) qetket. ");
INSERT INTO bmu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Miaŋgö könaŋe munŋan Isogö köna gwakötŋe böröŋan memba asuhuyök. Miaŋgöra yaŋgö qetŋi Jeikob qetket. (Jeikob keu miaŋgö könaŋi yahöt: gwaköt aka tilipköza.) Aisaknöŋ yambuŋi 60 aiga nalö miaŋgöreŋ Rebekanöŋ moröyahötŋi yahöt mi etkömeyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Morö nahön yahöt mietkön asuhuba qariba ketaŋi ahotka Isonöŋ böröjaŋ nupkö könaŋi törörök möt yaköba pöndaŋ jölömnöŋ malmamgö mörökmö, munŋan azi bönjöŋi aka kapaŋ köla mire malök. ");
INSERT INTO bmu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisaknöŋ arökŋaŋgö sömbupŋi nemamgö möta malök. Miaŋgöra uruŋan Iso gwötpuk jöpaköm waŋgiba malökmö, Rebekanöŋ urukönömŋan Jeikob gwötpuk jöpaköm waŋgiba malök. ");
INSERT INTO bmu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Nalö kunöŋ Jeikobnöŋ koziŋ memba nanŋaŋgöra nene kuluŋ ohoi tariga datŋan jölömnöhök kaba sileŋi lömbörii wösöŋi gwötpuk alök. ");
INSERT INTO bmu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Mewö aiga Jeikobköra kewö jii mörök: “Sileni lömbörii wösöni gwötpuk aljawaŋgöra mönö zilaŋ koziŋ kuluŋi pisikpisik mi niŋginöŋga nembi. “Miaŋgöra qetŋi Edom (pisikpisik) qetket. ");
INSERT INTO bmu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Mewö jii möta Jeikobnöŋ jiyök: “Datni, gi mutuk asuhunöŋga miaŋgö qetbuŋagi mi mönö mutuk tököm niŋginöŋga nene kuluŋ mi ölöp gihibi neman.” ");
INSERT INTO bmu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Mewö jiiga keu kewö meleŋ waŋgiyök: “Muni mötnöŋ, ni mönö kömumamgö akzal. Miaŋgöra mutuk asuhuyalaŋgö qetbuŋanan mönö denöwö bauköm niŋgibawak?” ");
INSERT INTO bmu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Mewö meleŋ waŋgiiga kewö jiyök: “Miaŋgö keuŋi mi mönö mutuk jöjöpaŋ keunöŋ jim köhöinöŋga mötpi. “Mewö jiiga mi jöjöpaŋ keunöŋ jim köhöim waŋgiba mutuk asuhuyöhaŋgö qetbuŋaŋi mi Jeikob tököm waŋgiiga nenenöŋ bohonŋi meyök. ");
INSERT INTO bmu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Bohonŋi memba bered aka koziŋ kuluŋi Iso waŋgiiga nemba wahöta kinda mosöta anök. Isonöŋ mutuk asuhuyöhaŋgö qetbuŋaŋi mi miaŋgö dop möriga eretŋi ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Mutuk Abrahamgö nalöŋe bödi asuhuyök. Mewöyök Aisakö nalöŋe mi kunbuk asuhuba gölme dop köla ahöyök. Mi asuhuiga Aisaknöŋ mosöta Filistin yeŋgö kiŋ kembu qetŋi Abimelek yaŋgö miriŋi qetŋi Gerar miaŋgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Anda maliga Kembunöŋ asuhum waŋgiba kewö jiyök: “Gi Ijipt gölmenöŋ kude anman. Gölme ki buŋagi akŋapkö jim kutuyali, mönö kiaŋgöreŋ tata malman. ");
INSERT INTO bmu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nöŋön iwigi Abrahamgöra jöhöjöhö keu waŋgiba mi jöjöpaŋ keunöŋ jim köhöiyali, mi mönö galöm kölbiga ölŋambuk akŋa. Nöŋön gölme pakpak ki mi gi aka göhö gwölönarökurupki yeŋgö buŋaya qem eŋgimam. Miaŋgöra ölöp gölme kiaŋgöreŋ tata kian malnöŋga nöŋön göbuk mala kötuetköm gihibiga malmam. ");
INSERT INTO bmu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nöŋön gwölönarökurupki ahumsehip eŋgibiga qötöŋinan suepnöŋ könakembagö seŋgelau tat anjei, mönö mieŋgö dop akŋa. Mewö aketka gölme pakpak ki mi yeŋgö buŋaya qem eŋgimam. Göhö gwölönarökurupki yeŋgöreŋök kungöra aka nöŋgö kötumötuetnan mönö gölmegö könagesö kambuŋi pakpak yeŋgö qakŋine öŋgöiga oyaeŋkoyaeŋ akŋe. ");
INSERT INTO bmu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nöŋön kewögöra mewö akŋam: Abrahamnöŋ nöŋgö keuni tem köla malök. Jöjöpaŋ keuni, jimkutukutu keuni aka köna keuni waŋgiali, yaŋön mi pakpak wuataŋgöba malök.” ");
INSERT INTO bmu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Anutunöŋ mewö jiiga Aisaknöŋ toroqeba Gerar taonöŋ tata malök. ");
INSERT INTO bmu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Maliga gölme miaŋgö aziŋi yeŋön anömŋaŋgö qesim waŋgigetka kewö jiyök, “I mi nena. “Mewö jiba uruŋan kewö mötmöriyök: “Rebekagö kaisoŋgolomŋan eksihimŋambuk akzawaŋgöra azi mieŋön mönö yaŋgöra aka ni nuŋguget kömumbileŋbuk. “Mewö mötmöriba “I anömna,” mewö jimamgö keŋgötŋi möta malök. ");
INSERT INTO bmu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisaknöŋ miaŋgöreŋ nalö köröpŋi mala kota nalö kunöŋ anömŋambuk susuhuba aŋgum aŋguyohotka Filistin yeŋgö kiŋini Abimelek yaŋön jeŋgenaŋnöhök yaigep ui geiga i etkehök. ");
INSERT INTO bmu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Etkeka Aisak oholi kaiga kewö jii mörök: “Mötnöŋ, yaŋön mönö göhö anömgi akza. Mönö wuanöŋgöra ‘I mi nena,’ jinöŋ?” Mewö möta kewö meleŋ waŋgiyök: “Ni yaŋgöra aka nuŋguget kömumbileŋbuköra mötmöriba mewö jial.” ");
INSERT INTO bmu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Meleŋ waŋgiiga kiŋ Abimeleknöŋ kewö jiyök: “Göŋön mönö wani kimbia ak neŋginöŋe? Nöŋgö aziurupni yeŋgöreŋök kunŋan mönö amqeba göhö anömgabuk ahöbawak. Mewö asuhuiga göŋön kondotnöŋga siŋgisöndokö keu lömbötŋan mönö neŋgö qaknine öŋgöbawak.” ");
INSERT INTO bmu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Mewö jiba könagesö kambuŋi pakpak yeŋgöra jimkutukutu kewö al eŋgiyök: “Kunŋan kun azi ki me yaŋgö anömŋi mem bölim etkimawi, i mönö kömupkö buŋaya jim teköinga kömuma. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisaknöŋ gölme miaŋgöreŋ nene nup köl kömöriga Kembunöŋ kötuetköm waŋgiiga yambu miaŋgöreŋ kötŋi kömöri, mi 100:kö dop sehiba asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mewö asuhuiga töhötmöriam ketaŋi ketaŋi miwikŋaiba maliga sukinapŋan toroqeba qariba öŋgöiga kindiŋbirik azi qetbuŋaŋambuk ahök. ");
INSERT INTO bmu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yaŋgöreŋ lama, meme (noniŋ) aka bulmakau kambuŋi kambuŋi mi asuhuba sehiget. Mewöŋanök welenqeqeurupŋi gwötpuk eŋgömeiga malget. Miaŋgöra Filistin yeŋön mi eka könahiba körögisigisi aka andöqeqe keu jiget. ");
INSERT INTO bmu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Andöqeqe keu jiba iwiŋi Abrahamgö welenqeqeurupŋan o löm yaŋgö nalöŋe esigeri, mi pakpak gölmenöŋ qem turum teköget. ");
INSERT INTO bmu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Mewö asuhuiga kiŋ Abimeleknöŋ Aisaköra kewö jiyök: “Gi kukösumgabuk aka gwötpuk neŋgoŋgizanaŋgöra mönö kölolohoba neŋgömosöta kungen anman.” ");
INSERT INTO bmu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Mewö jii möta gölme mi mosöta Gerar öruenöŋ (rueruenöŋ) anda geba opo seri koumŋi möröreŋgöba kuŋguba miaŋgöreŋ tata malget. ");
INSERT INTO bmu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Tata mala o löm iwiŋi Abrahamgö nalöŋe esigetmö, Abraham kömuiga Filistin yeŋön qem turugeri, mi Aisaknöŋ jiiga kunbuk esim luluŋda möhamgöget. Möhamgögetka iwiŋan o löm qetŋini qeröhi, Aisaknöŋ mi mewö kunbuk qerök. ");
INSERT INTO bmu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Mewö qeriga welenqeqeurupŋan öruenöŋ o löm esiba mala o löm kun oŋi sarakŋi soksoköyöhi, mi miwikŋaiget. ");
INSERT INTO bmu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mi miwikŋaigetmö, Gerar yeŋgö lama bulmakau galömŋinan Aisakö lama bulmakau galömurupŋi yembuk könahiba aŋgururuk aka keu kewö jiget, “O mi neŋgöreŋa!” Nanŋambuk aŋgururuk keu mewö jigeraŋgöra aka Aisaknöŋ o löm miaŋgö qetŋi Esek (Aŋgururuk) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Miaŋgö andöŋe o löm kun kunbuk esigetka miaŋgöra mewöyök aŋgururuk aket. Mewö akeraŋgöra aka o löm miaŋgö qetŋi Sitna (Kerök-kerök) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Mewö qeta gölme mi mosöta anda o löm kun kunbuk jii esiget. O löm miaŋgöra aŋgururuk keu qahö asuhuiga miaŋgöra qetŋi Rehobot (Tiŋi ölöpŋi) qeta keu kewö jiyök: “Merak Kembunöŋ tiŋi ölöpŋi neŋgiiga ölöp gölme kiaŋgöreŋ mala ahumsehip akin.” ");
INSERT INTO bmu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mewö jiba miaŋgöreŋ mala mosöta Berseba mire anök. ");
INSERT INTO bmu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Berseba aniga suŋgem miaŋgöreŋ Kembunöŋ asuhum waŋgiba kewö jiyök: “Nöŋön iwigi Abrahamgö Anutuŋi akzal. Nöŋön göbuk mala kötuetköm gihiba malmam. Miaŋgöra keŋgötki kude mötman. Nöŋön nup azini Abrahamgöra aka göhö gwölönarökurupki ahumsehip eŋgibiga qötöŋinan öŋgöŋgöŋi akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Mewö jiiga Aisaknöŋ jöwöwöl alta kun miaŋgöreŋ memba Kembugö qetŋi qeta köuluköyök. Köuluköba opo koumŋi möröreŋgöba kuŋguba tata malget. Mala jiiga welen aziurupŋan o löm kun miaŋgöreŋ esiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Aisaknöŋ Berseba maliga nalö kunöŋ kiŋ Abimelek yaŋön Gerar taon mosöta yaŋgöreŋ kayök. Gorojiji alaŋi Ahuzat aka yarö kambuŋaŋgö suahö galömŋi Fikol yetkön yambuk mohotŋe kaget. ");
INSERT INTO bmu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kagetka Aisaknöŋ kewö qesim eŋgiyök: “Iŋini kerök möt niŋgiba gölmeŋineyök közöl niŋgigetka töndup mönö wuanöŋgöra nöŋgöreŋ ki kaze?” ");
INSERT INTO bmu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Qesim eŋgiiga kewö meleŋget: “Kembunöŋ göbuk kinjawi, nini mi aukŋe ek kutuba mötzin. Miaŋgöra kewö mötmörizin: ‘Neŋön göbuk jöhöjöhö akingö sihimnini mötzin. Ölöp gi aka neŋgö sutnine jöhöjöhö aka mi jöjöpaŋ keunöŋ jim köhöininga kewö ahöma: ");
INSERT INTO bmu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Nini kahasililiŋ kun qahö ak gihiinmö, nalö dop ölöpŋi ak gihiba gömosöringa luainöŋ mirigi mosöta anda kaba malnöŋ. Miaŋgö dop göŋön mewöŋanök nini yuai bölöŋi kun kude ak neŋgiba malman.’ Nalö kewöŋe Kembunöŋ kötuetköm gihiiga maljan.” ");
INSERT INTO bmu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Mewö jigetka Aisaknöŋ közölömbuaŋ mözözömgöba ohoba aliga nene kuluŋ nemba tatket. ");
INSERT INTO bmu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tata ahöba söŋan ömandiŋe wahöta jöhöjöhöŋini jöhöm aŋguba mi jöjöpaŋ keunöŋ jim köhöiget. Jim köhöigetka Aisaknöŋ i melaim eŋgiiga luai qakŋe mosöta anget. ");
INSERT INTO bmu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Angetka wehön miaŋgöreŋök Aisakö welen azi yeŋön kaba o löm kun esigeri, miaŋgö kösohotŋi i jigetka kewö mörök: ");
INSERT INTO bmu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","“Nini o miwikŋaizin. “Mewö jigetka möta o löm miaŋgö qetŋi Siba qerök. Miaŋgöra taon miaŋgö qetŋi mi nalö kewöŋe mewöyök toroqeba Berseba qerakzin. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isonöŋ yambuŋi 40 aiga Hit ambi yahöt anömyahötŋa etkömeyök. Qetŋiri Judit, iwiŋi qetŋi Beri aka Basemat, iwiŋi qetŋi Elon. ");
INSERT INTO bmu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ambi mietkön Aisak aka Rebeka urukömbuk aka wösöbirik keta bölökŋi miwikŋaim etkiba malohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisaknöŋ mala kota azi namŋi aiga jeŋi ömun köliga yuai kunbuk ek kutumamgö osiyök. Mewö osiba nahönŋi mutukŋi Iso köl öröm waŋgii kaiga kewö jii mörök: “Nahöni mötnöŋ. “Mi möta kewö meleŋ waŋgiyök: “Iwini, ni ki kinjal.” ");
INSERT INTO bmu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Meleŋ waŋgiiga kewö jii mörök: “Mötnöŋ, ni azi namŋi aka wani nalönöŋ kömumami, mi qahö mötzal. ");
INSERT INTO bmu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Miaŋgöra göŋön ölöp timbi liŋgipki aka kesarek gösögi memba jölömnöŋ anda sömbupkö böröjaŋ memba qeba nöŋgöreŋ kaman. ");
INSERT INTO bmu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kaba nene nahömŋambuk sihimnaŋgö dop ohoba mözözömgöba memba kaba niŋginöŋga nemam. Mi nemba kinda kötumötuet gihimam. Mi mutuk gihibi teköiga nöŋön miaŋgö andöŋe ölöp kömumam.” ");
INSERT INTO bmu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Aisaknöŋ nahönŋi Isogöra keuŋi mewö jiiga Rebekanöŋ mi kezap ala mörök. Möriga Isonöŋ mosöta sömbup böröjaŋ memba qeba iwiŋi waŋgimamgöra jölömnöŋ anök. ");
INSERT INTO bmu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Aniga Rebekanöŋ nahönŋi Jeikobköra keu kewö jii mörök: “Nahöni mötnöŋ, Iwigan datki Isogöra keu kewö jiiga mötzal: ");
INSERT INTO bmu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Gi mönö sömbup memba kaba niŋgiba nene nahömŋambuk ohoba mözözömgöba niŋginöŋga nemam. Nembagun Kembugö jemesoholŋe kötumötuet gihimam. Mi mutuk gihibi teköiga miaŋgö andöŋe ölöp kömumam.’ ");
INSERT INTO bmu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Miaŋgöra nahöni, kezap ölöpŋanök ala mötnöŋ. Keu dölki jim kutum gihimami, gi mönö miaŋgö dop akŋan. ");
INSERT INTO bmu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mönö meme kambunöŋ anda miaŋgöreŋök meme (noniŋ) dömŋi kelökŋambuk yahöt memba kaba niŋginöŋga nöŋön miaŋön iwigahö sihimŋaŋgö dop numbu nene nahömŋambuk ohoba mözözömgömam. ");
INSERT INTO bmu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ohoba mözözömgöbiga memba anda iwigi waŋginöŋga nemba kötumötuet gihibawak. Miaŋgö andöŋe ölöp kömuma.” ");
INSERT INTO bmu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mewö jii möta namŋi Rebekagöra kewö jiyök: “Namni mötnöŋ, datni Isonöŋ sile jupŋambuk akzapmö, nöŋgö silenan solanŋi akza. ");
INSERT INTO bmu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Iwinan ni nömisiriba mötpawak ewö, ni yaŋgö jemesoholŋe tilipqilip azi tandök asuhubiga möt niŋgibapuk. Mewö möt niŋgiiga kötumötuet qahöpmö, jimqesuak öröbi nani qakne öŋgöbapuk.” ");
INSERT INTO bmu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mewö jiiga namŋan kewö jii mörök: “Nahöni, jimqesuak gihibawahi, miaŋön mönö ölöp nöŋgö qakne öŋgöma. Göŋön mönö töndup keu jizali, mi möt tem köla anda yuai mi memba kanöŋ.” ");
INSERT INTO bmu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Mewö jiiga anda meme (noniŋ) yahöt memba kaba namŋi waŋgiyök. Waŋgiiga nene nahömŋambuk iwiŋan sihimŋi möröhi, miaŋgö dop ohoba mözözömgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ohoba nahönŋi mutukŋi Isogö opo malukuŋi ölöp kötökŋi opo köweŋe galöm kölöhi, mi memba nahönŋi könaŋgepŋi Jeikob waŋgiiga löŋgörök. ");
INSERT INTO bmu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Löŋgöriga meme (noniŋ) sileŋi mi memba böröŋi köpeiba jölŋi solanŋi esuhuyök. ");
INSERT INTO bmu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Esuhuba nene nahömŋambuk aka bered ohoyöhi, mi memba Jeikobkö böröŋe alök. ");
INSERT INTO bmu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Aliga memba iwiŋaŋgöreŋ anda “Iwini!” jiyök. Jiiga kewö meleŋnök: “O nahöni, gi daŋön?” ");
INSERT INTO bmu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Mewö meleŋniga iwiŋaŋgöra kewö jii mörök: “Ni nahöngi mutukŋi Iso. Jim kutum niŋginöŋi, ni mönö miaŋgö dop ak teközal. Ölöp wahöta tata sömbupni memba kazali, mi nemba kötuetköm niŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Mewö jii möta nahönŋi kewö qesim waŋgiyök: “Nahöni, mi mönö denöwö könöpuk miwikŋaizan?” Qesim waŋgiiga kewö meleŋnök: “Anutu, göhö Kembugan mönö bauköm niŋgiiga mi zilaŋ miwikŋaizal.” ");
INSERT INTO bmu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Mewö meleŋniga Jeikobköra kewö jiyök: “Nahöni, gi ölŋa nahöni Iso akzan me qahö, mi mötmamgöra mönö ölöp kösutne ki kanöŋga gömisirimam.” ");
INSERT INTO bmu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Mewö jiiga iwiŋi Aisakö kösutŋe aniga misirim möta kewö jiyök: “Imbi jölgan Jeikobkö imbia akzapmö, börögan Isogö böröŋi ewö.” ");
INSERT INTO bmu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Böröŋi jupŋambuk datŋi Isogö börö tandök ewö ahöhaŋgöra Aisaknöŋ i qahö möt kutum waŋgiba kötuetköm waŋgimamgöra ahök. ");
INSERT INTO bmu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Töndup kunbuk kewö qesim waŋgiyök: “Gi ölŋa nahöni Isoya me qahö?” Qesim waŋgiiga kewö meleŋnök: “Ni mönö Isoya.” ");
INSERT INTO bmu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Mewö meleŋniga kewö jiyök: “Nahöni, ölöp sömbupki tosatŋi niŋginöŋga nemba kötumötuetni gihimam. “Mewö jiiga mi waŋgii neyök. Neiga wain o tosatŋi mohotŋe mokoba waŋgii neyök. ");
INSERT INTO bmu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nemba kinda nahönŋaŋgöra kewö jii mörök: “Gi ölöp kösutne kaba numbuni yöhötim neman.” ");
INSERT INTO bmu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Mewö jii möta kösutŋe anda numbuŋi yöhötim neyök. Neiga opo malukuŋaŋgö wörönŋi möta kötuetköm waŋgiba kewö jiyök: “Aha nahöni, Kembunöŋ urukisigö jölömŋi kötuetköi ahözawi, nöŋgö nahönaŋgö sile qösösökŋi ölöpŋan mönö mi ewö aiga mötzal. ");
INSERT INTO bmu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Anutunöŋ mönö suepkö umjijilŋi aka gölmegö töhötmöriamŋi tököm gihiiga yaka yöhagi, sehoŋ padigi aka wain o yuaigi mi önöŋi qahö asuhum sehime. ");
INSERT INTO bmu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kantriŋi kantriŋi yeŋön mönö welen qem gihiba malme. Könagesö kambuŋi kambuŋi yeŋön mönö simin köl gihiba malme. Göŋön mönö nani nahönurupni mi kembu ak eŋgiba malman. Namgahö nahönurupŋan mönö simin köl gihiba malme. Kunŋan qesuahöm gihimawi, qesuaknöŋ mönö yaŋgö qakŋe öŋgöma. Kunŋan kötuetköm gihimawi, kötumötuetnöŋ mönö yaŋgö qakŋe öŋgöma. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisaknöŋ Jeikob kötuetköm waŋgim teköiga iwiŋaŋgö miri uruŋi mosöta yaigep aniga wölaŋ miaŋgöreŋök datŋi Isonöŋ böröjaŋ mali teköiga mire kayök. ");
INSERT INTO bmu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kaba yaŋön mewöyök nene nahömŋambuk ohoba mözözömgöba memba kaba iwiŋi waŋgiba kewö jiyök: “Iwini, ölöp wahöta tata sömbupni tosatŋi nemba kötumötuetki niŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Mewö jiiga iwiŋi Aisaknöŋ kewö qesim waŋgiyök: “Gi daŋön?” Qesim waŋgiiga kewö meleŋda jiyök: “Ni nahöngi mutukŋi Iso.” ");
INSERT INTO bmu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Mewö jiyöhaŋgöra Aisaknöŋ töwöratiba sile jönömŋi gwötpuk unduiga kewö jiyök: “Gi qahö kanöŋga miaŋgöreŋ böröjaŋ azi kunöŋ sömbup memba kaba niŋgiyöhi, mi mönö daŋön? Yaŋön mi niŋgiiga nemba kötumötuetni lök waŋgim teközal. Mi waŋgim teközalaŋgöra miaŋön mönö ölŋa yaŋgö qakŋe ahöm öŋgöma.” ");
INSERT INTO bmu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Isonöŋ iwiŋaŋgö keu jitŋi mi möta urukömbuk aka amburereŋ memba silata sahöta iwiŋaŋgöra kewö ulerök: “Iwini, nia mönö mewöyök kötuetköm niŋginöŋ.” ");
INSERT INTO bmu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Mewö ulerökmö, iwiŋan meleŋda jiyök: “Mungan mönö tilipqilip qakŋe kaba göhö kötumötuetki taköba memba anja.” ");
INSERT INTO bmu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Mewö jiiga Isonöŋ kewö jiyök: “Munan mönö indimŋi yahöt tilipköm niŋgiiga maljal: Yaŋön mutuk asuhuyalaŋgö qetbuŋaŋi mi mutuk noaŋgit teköyök aka merak nöŋgö kötumötuetni mi mewöyök taköba noaŋgita meza. Miaŋgöra qetŋi Jeikob (tilipqilip azi) qerakzini, mi mönö dopŋe akza. Kötumötuet kun mönö nöŋgöra ahöm gihiza me qahö?” ");
INSERT INTO bmu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Mewö jiiga iwiŋan Isogöra kewö meleŋnök: “Mötnöŋ, nöŋön mungi göhö azi kembugi malmapköra kuŋgum waŋgizal. Tinitosolomurupŋi pakpak yeŋön i welen qem waŋgiba malmegöra jim kutum eŋgizal. Yaka yöha, sehoŋ padi aka wain o yuai mi lök jim teközalawa Anutunöŋ mi waŋgiba malma. O nahöni, wanat kötumötuetna kun toroqeba ahöm niŋgizawa mia gihibileŋak? Mi mönö osizal.” ");
INSERT INTO bmu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Mewö meleŋniga iwiŋaŋgöra kewö jiyök: “O iwini, kötumötuet mohok-kun miyök mönö ahöm gihiza me denöwö? O iwini, mönö nia kun kötuetköm niŋginöŋ. “Mewö jiba könahiba silata sahörök. ");
INSERT INTO bmu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Sahöriga iwiŋan kewö meleŋda jiyök: “Mötnöŋ, göŋön mönö gölme töhötmöriamŋambuk mosöta köröwen anda malman. Miaŋgöreŋ suepkö umjijilŋi mi könakembayök qahö erakŋa. ");
INSERT INTO bmu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Gi bimgö sou ketaŋi miaŋön ambazip laŋ eŋguba malmalgi aŋgön köla mungahö welenqeqeŋi eretŋi aka malman. Mewö malmanmö, kekelolo aka qetal waŋgiba nalö miaŋgöreŋ karim aka yaŋgö galöm kölkölŋi qeköba yaköriba nangi kinkin malman.” ");
INSERT INTO bmu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iwiŋan Jeikob kötumötuetŋi waŋgiyöhi, Isonöŋ miaŋgöra aka könahiba munŋi uruönön möt waŋgiba malök. Nanŋi uruŋan mewö möta alaŋi kungöra kewö jiyök: “Iwiniraŋgö kömupŋaŋgö nalöŋan töriza. Yaŋön kömuiga sahöt jiŋgeŋ nalöŋe miaŋgöreŋ ölöp muni Jeikob qebi kömuma.” ");
INSERT INTO bmu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Isogö mötmötŋe mewö ahuiga kunöŋ miaŋgö buzupŋi möta Rebekagöreŋ anda jii möta nahönŋi könaŋgepŋi Jeikobköra keu ali anda waŋgita kaiga kewö jiyök: “Mötnöŋ, datki Isonöŋ mönö likepŋi meleŋni qake öŋgöiga guhui kömumangö mötmöriza. ");
INSERT INTO bmu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mewögöra nahöni, nöŋön keu jimami, mi mönö tem kölman. Mönö dölki wahöta ölöŋ köla Haran mire neni Labangöreŋ anman. ");
INSERT INTO bmu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Anda yambuk nalö tosatŋi toroqeba malnöŋga datkahö urupikŋan amörima. ");
INSERT INTO bmu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Uruönönŋi amöriba eriga yuai ak waŋginöŋi, mi ölum qeigun nöŋön miaŋgö andöŋe göhöra keu albi kaiga goaŋgita kame. Yaŋön guhui kömunöŋga kunŋan i qei kömumbapuk. Mönö wanigöra nalö mohok miaŋgöreŋök öröröŋ qahöwahotka etkömosötpileŋbuk. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekanöŋ apŋi Aisaköreŋ anda kewö jiyök: “Nöŋön iranyahötni Hit ambi yetköra aka toroqeba malmamgö ölan nöhöi sihimbölö mörakzal. Jeikobnöŋ mewöyök Hit yeŋgö böraturupŋini yeŋgöreŋök kun iranyahötniri ewö anömŋa membapuk. Gölme kiaŋgöreŋ asuhugeri, yeŋgö silikŋinan mönö mewöyök ahöza. Mewöŋi kun memba kabapuk ewö, nöŋön mönö malmalni wuanöŋgöra toroqeba malbileŋak? Sihimbölönan mönö toroqeba önöŋi qahö akapuk. “Rebekanöŋ mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Mewö jiiga Aisaknöŋ Jeikob köl öröi kaiga kötuetköba kewö jim kutum waŋgiyök: “Nahöni, gi Keinan yeŋgö nenböratŋini yeŋgöreŋök kun anömgi kude meman. ");
INSERT INTO bmu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mewö qahöpmö, mönö wahöta Mesopotemia (Padan Aram) gölmenöŋ anda namgahö iwiŋi Betuel yaŋgö mire aŋgota ehongi Labangö böraturupŋi yeŋgöreŋök kun anömga meman. ");
INSERT INTO bmu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Anömgi menöŋga Anutu, kukösum pakpakö Toŋan mönö gi kötuetköba ahum sehip gihiiga gwölönarökurupki yeŋgö qötöŋinan sehiiga könagesö kambu gwötpuk mieŋgö iwi bömönŋina akŋan. ");
INSERT INTO bmu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Anutunöŋ mönö gi aka gwölönarökurupki iŋini Abrahamgö kötumötuetŋi mi toroqeba eŋgima. Mewöyök gölme asagi Abraham waŋgiiga göŋön miaŋgöreŋ kian aka maljani, mi buŋa qem aŋgume.” ");
INSERT INTO bmu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Mewö jiba Jeikob melaiiga mosöta Mesopotemia (Padan Aram) gölmenöŋ Labangöreŋ anmamgöra anök. Laban mi Aram azi Betuelgö nahönŋa aka Jeikob aka Iso yetkö namŋiri Rebeka yaŋgö nenŋa malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Aisaknöŋ Jeikob kötuetköba anömŋi memamgöra Mesopotemia gölmenöŋ melaiyöhi, mi Isonöŋ mörök. Kötuetköm waŋgiba kewö jim kutum waŋgiyök: “Gi Keinan yeŋgö nenböratŋini yeŋgöreŋök kun anömgi kude meman.” ");
INSERT INTO bmu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Mewö jim kutuiga iwinamŋi yetkö keu jit tem köla mosöta Mesopotemia (Padan Aram) gölmenöŋ anöhi, Isonöŋ mi mewöyök mörök. ");
INSERT INTO bmu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Mi möta iwiŋi Aisaknöŋ Keinan ambi tököba möt bölim aŋguba malöhi, Isonöŋ mi eka möt kutuyök. ");
INSERT INTO bmu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Mi möt kutuba iwiŋaŋgö jeŋe dop kölmapköra asaŋi Abrahamgö nahönŋi Ismaelnöŋ kömuiga yaŋgö mire anda böratŋi Malahat, Nebaiotkö nenŋi mi meiga anömurupŋi karöbut aket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jeikobnöŋ mewö Berseba miri mosöta Haran mire anmamgö anök. ");
INSERT INTO bmu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Anda mala gölme kunöŋ aŋgota wehön jeŋi geyöhaŋgöra aka miaŋgöreŋ köt tatkeri, mieŋgöreŋök kun memba nöröp qömböŋi qeba suŋgem gaun ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Gaun ahöba miaŋgöreŋ imut kun kewö ehök: Döp kungö kitipŋi gölmenöŋ algetka qak kitipŋi mi Suepnöŋ öŋgöba kuŋguba kiniga Anutugö garataurupŋi yeŋön miaŋgöreŋ tiba öŋgöm et aket. ");
INSERT INTO bmu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mewö aketka Kembunöŋ yaŋgö kösutŋe kinda keu kewö jii mörök: “Nöŋön Kembu, asagi Abrahamgö Anutuŋi aka iwigi Aisakö Anutuŋi akzal. Gölme ki ahözani, nöŋön mi gi aka göhö gwölönarökurupki eŋgö buŋaya qem eŋgimam. ");
INSERT INTO bmu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Göhö gwölönarökurupki yeŋön ahumsehip aketka jaŋgöŋinan gölmegö sömsöm ewö akŋa. Mewö aiga jula deŋda gölme wehön kotkotŋe aka gegeŋe, Saut likep aka Not likep, eu aka emu miaŋgöreŋ göröken dop köla anda malme. Göhöra aka göhö gwölönarökurupki yeŋgöreŋök kungöra aka nöŋgö kötumötuetnan mönö gölmegö könagesö kambuŋi pakpak yeŋgö qakŋine öŋgöiga oayeŋkoyaeŋ akŋe. ");
INSERT INTO bmu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mötnöŋ, nöŋön göbuk mala denike denike anda kaba malmani, miaŋgö dop mönö sel jöhöm gihiba mal öŋgöba goaŋgitpiga gölme kiaŋgöreŋ kunbuk liliŋgöba kaman. Nöŋön gi qahö gömosöta keu jim jöhöm gihiali, miaŋgö dop akiga ölŋi asuhum teköma.” ");
INSERT INTO bmu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Mewö jiiga Jeikobnöŋ gaun uruŋeyök imbiŋi möta wahöta kewö jiyök: “Kembunöŋ mönö ölŋa gölme kiaŋgöreŋ maljapmö, nöŋön mi mutuk qahö mötzal.” ");
INSERT INTO bmu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Mewö jiiga jönömŋi unduiga keu kewö jiyök: “Gölme ki mönö kömbukŋi aka keŋgötmötmötŋambuk akza. Kiaŋön mönö ölŋa Anutugöreŋ tatat dundumŋi aka Suepkö naŋguŋi akza.” ");
INSERT INTO bmu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mewö jiba miri giaŋiiga söŋanök wahöta köt qömböŋi qeba ahöyöhi, mi memba wahöta jabö mötök ewö kuŋguba qakŋe kelök o mokoba miriyök. ");
INSERT INTO bmu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Miriba gölme miaŋgö qetŋi Betel (Anutugö miriŋi) qerök. Mutuk taon miaŋgö qetŋi mi Luz qeta malget. ");
INSERT INTO bmu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jeikobnöŋ gölme miaŋgö qetŋi dölökŋi Betel qeta keu kewö jim jöhöba jöjöpaŋ keunöŋ jim köhöiyök: “O Anutu, göŋön nömbuk mala köna ki anda malmami, miaŋgöreŋ nek galöm ak niŋgiba numbu neneŋamni aka silenaŋgö esuŋi miwikŋaim niŋginöŋga ");
INSERT INTO bmu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ölöp luai qakŋe iwinaŋgö mire kunbuk liliŋgöba kamam ewö, nöŋön mönö göhö jitsihitki tem köla malbiga göŋön nöŋgö Kembu Anutuni aka malman. ");
INSERT INTO bmu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Köt ki memba wahöta jabö ewö mötök kuŋguzali, miaŋön mönö göhö tatat dundumgi ahöiga yuai pakpak tököm niŋgiba malmani, nöŋön mi ölŋa mendeŋbiga kambu 10 aketka mieŋgöreŋök mohok mohok memba kalema gihiba malmam. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jeikobnöŋ mewö jiba mosöta könaŋi toroqeba anda wehön kotkotŋaŋgö könagesö yeŋgö gölmenöŋ aŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Miaŋgöreŋ aŋgota gölme köröŋe o löm kun ehök. Miri toŋi yeŋön lama kambuŋini eŋguaŋgita miaŋgöreŋ o eŋgiba malget. Nalö miaŋgöreŋ o löm miaŋgö kösutŋe lama kambu karöbut ahögetka o löm numbuŋaŋgö kötŋi ketaŋi mi qahö metalget. ");
INSERT INTO bmu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Lama galöm yeŋön mutuk lama kambuŋini pakpak miaŋgöreŋ tokom eŋgiba köt mi o löm numbuŋeyök gwililöŋgöba lamaurupŋini o eŋgiget negetka köt mi kunbuk dundumŋe köla malget. ");
INSERT INTO bmu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jeikobnöŋ lama galöm mi kewö qesim eŋgiyök: “Azi alaurupni, iŋini denikegöra?” Qesim eŋgiiga “Nini Harangöra,” mewö meleŋ waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Meleŋ waŋgigetka kewö qesim eŋgiyök: “Iŋini Nahorgö isiŋi Laban möt waŋgize me qahö?” Qesim eŋgiiga “Ölöp möt waŋgizin,” jiget. ");
INSERT INTO bmu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jigetka kewö qesim eŋgiba jiyök: “I ölöp malja me qahö?” Mewö jiiga kewö jiget: “I ölöp malja. Eknöŋ, yaŋgö böratŋi Reizölnöŋ mönö endu lama eŋguaŋgita kaza.” ");
INSERT INTO bmu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Mewö jigetka Jeikobnöŋ jiyök: “Eket, wehön ketaŋi ahöiga lama mi suŋgemgöra tokom eŋgibingö nalöŋan qahö töriza. Miaŋgöra ölöp lamaŋini o eŋgiget negetka kunbuk eŋguaŋgita malmalŋine anda al eŋgigetka neneŋamŋini neme.” ");
INSERT INTO bmu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mewö jiiga kewö meleŋget: “Mewö ölöp qahö akin. Mutuk lama kambu pakpak tokom eŋgiba köt mi o löm numbuŋeyök gwililöŋgöbagun mönö lamaurupnini o eŋgiinga neme.” ");
INSERT INTO bmu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jeikobnöŋ yembuk keu mewö eraum-möta kingetka miaŋgöreŋök Reizölnöŋ iwiŋaŋgöreŋ lama kambuŋi eŋguaŋgita kayök. Reizöl yaŋön lama galöm nup memba malök. ");
INSERT INTO bmu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kaiga Jeikobnöŋ ehonŋaŋgö böratŋi Reizöl aka ehonŋaŋgö lama kambuŋi eŋgeka o löm numbuŋe anda köt mi metala ehonŋi Labangö lamaurupŋi o eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Eŋgim teköba Reizöl numbu yöhötim nemba könahiba köhöikŋi qeta sahörök. ");
INSERT INTO bmu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Sahöta Reizölgöra jiyök: “Ni göhö iwigahö tinitosolomŋi akzal. Ni Rebekagö nahönŋa. “Mewö jiiga Reizölnöŋ möta ösumŋan kiŋkiŋgöba iwiŋaŋgöreŋ anda buzup mi jii mörök. ");
INSERT INTO bmu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labanöŋ nenŋaŋgö nahönŋi Jeikobkö buzupŋi möta i ösumok miwikŋaimamgöra anök. Anda miwikŋaiba eka aŋgöm waŋgiba numbuŋi yöhötim nemba waŋgita miriŋe öŋgöyohot. Öŋgöba yuai pakpak asuhuyöhi, Jeikobnöŋ miaŋgö kösohotŋi jii mörök. ");
INSERT INTO bmu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Mi möta kewö jiyök: “Ölöp, göŋön nani sepkitipni akzan. “Mewö jiiga köiŋ mohotkö dop yambuk tata malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Mewö maliga Labanöŋ Jeikob kewö jii mörök: “Gi tinitosolomni maljanaŋgöra töwagi qahö öne welen qem niŋgibanbuk. Mi qahö dop kölma. Miaŋgöra töwagi dawik memangö mötzani, mi ölöp jinöŋga mötmam.” ");
INSERT INTO bmu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labangö böratyahötŋi yahöt malohot. Ketaŋaŋgö qetŋi Lea. Munŋaŋgö qetŋi Reizöl. ");
INSERT INTO bmu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leagö jeŋan eksihimŋambuk ahökmö, Reizölgö sileŋaŋgö kaisoŋgolomŋi aka jemesoholŋi mi körek eksihimŋambuk kötökŋi ahök. ");
INSERT INTO bmu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jeikobkö urusihimŋi mi Reizölgöreŋ ahöyöhaŋgöra aka keu kewö jiyök: “Nöŋön böratki könaŋgepŋi Reizöl memamgöra ölöp yambu 7 welen qem gihiba malmam.” ");
INSERT INTO bmu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Mewö jiiga kewö jiyök: “I azi murutŋi kun waŋgibiga qahö dop kölbapukmö, gi gihibiga dop kölma. Miaŋgöra ölöp nömbuk ki malman.” ");
INSERT INTO bmu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Mewö jiiga Reizöl memamgöra yambu 7 welen qem waŋgiba malök. Urusihimŋan Reizölgöra ahöhaŋgöra aka yambu mieŋgö möriga wehön awamŋi tandök ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yambu 7 teköiga Jeikobnöŋ ehonŋi Laban kewö jii mörök: “Nöŋgö nup meme nalönan lök teközawaŋgöra ölöp anömni Reizöl niŋginöŋga yambuk ahöba malmam.” ");
INSERT INTO bmu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labanöŋ keu mi möta miri toŋi pakpak öröm tokom eŋgiba lömbuaŋ aliga nem söŋgaip aket. ");
INSERT INTO bmu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mi aket teköiga miri söŋauiga Labanöŋ böratŋi Lea waŋgita anda Jeikob waŋgiiga miri uruŋe öŋgöba mohotŋe ahöyohot. ");
INSERT INTO bmu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labanöŋ welen ambiŋi qetŋi Zilpa mi böratŋi Leagö welenqeqeŋa malmapköra waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mohotŋe ahöyohotka miri giaŋiiga Jeikobnöŋ anömŋi eka möri Reizöl qahöpmö, i Lea aiga yöwöŋaŋgöreŋ anda kewö jim waŋgiyök: “Gi mönö wani kimbia ak niŋgizane? Ni Reizöl memamgöra welen qem gihiba malalmö, gi mönö wuanöŋgöra tilipköm niŋgizan?” ");
INSERT INTO bmu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Mi möta meleŋda kewö jiyök: “Gölme kiaŋgöreŋ datŋi öne maliga munŋan azi memapkö ahakmemeŋi mi neŋgöreŋ qahö ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Miaŋgöra ölöp maren sösöŋgai mi Leabuk sonda mohotkö dop mal söŋgainöŋ teköiga munŋi mewöyök gihimam. I memangöra mönö mewöyök yambu 7 toroqeba welen qem niŋgiba malman.” ");
INSERT INTO bmu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Mewö jiiga urumohot aka Leabuk maren sösöŋgai nalö mi sonda mohotkö dop mali teköiga Labanöŋ böratŋi Reizöl mewöyök anömŋi akŋapköra waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labanöŋ welen ambiŋi qetŋi Bilha mi böratŋi Reizölgö welenqeqeŋa malmapköra waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jeikobnöŋ Reizöl i mewöyök anömŋa meyök. Urusihimŋan Reizölgöra ahöyöhaŋgöra aka Reizöl mi Lea oŋgita jöpaköm waŋgiba malök. Miaŋgöra yambu 7 toroqeba Laban welenŋi qem waŋgiba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jeikobkö uruŋan Leagö gwötpuk qahö ahöiga boromdökŋi tököiga Kembunöŋ ehi qahö dop köliga Lea gölöm almapköra bauköm waŋgiyökmö, munŋi Reizölnöŋ köpinŋa malök. ");
INSERT INTO bmu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leanöŋ köröbuk aka mala morö azia memba keu kewö jiyök, “Kembunöŋ tapötkokorokni ehiga apnan ölöp könahiba jöpaköm niŋgiba malma. “Mewö jiba qetŋi miaŋgö dop Ruben qerök. (Ruben Tapötkokorokni ehök.) ");
INSERT INTO bmu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Könaŋgep kunbuk körö ala morö azi kun memba keu kewö jiyök: “Apnan boromdökŋi jöpaköm niŋgiiga Kembunöŋ mi möta morö ki mewöyök niŋgiza. “Mewö jiba qetŋi miaŋgö dop Simeon qerök. (Simeon Kezapŋan mörök.) ");
INSERT INTO bmu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Miaŋgö andöŋe kunbuk körö ala morö azi kun memba keu kewö jiyök: “Ni nahönurupŋi karöbut apnaŋgöra mealaŋgöra yaŋön mönö könahiba uruŋi nömbuk jöhöma. “Mewö jiba qetŋi miaŋgö dop Liwai qerök. (Liwai Uruŋi jöhöma.) ");
INSERT INTO bmu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Miaŋgö andöŋe dumŋe kunbuk körö ala morö azi kun memba keu kewö jiyök: “Nöŋön nalö kewöŋe Kembu möpöseizal. “Miaŋgöra qetŋi miaŋgö dop Juda (möpöseip) qerök. Miaŋgö andöŋe morö kunbuk qahö meyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Reizölnöŋ köpinŋi mala Jeikobköra nahönbörat kun qahö memba nanŋi könaŋi mewö eka datŋi Lea andö qeba uruŋan mututqutut möta Jeikobköra keu kewö jiyök: “Gi mönö morö qiwikŋainöŋ. Mi qahö qiwikŋainöŋga nöŋön mönö malmamgö osiba kömumam.” ");
INSERT INTO bmu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Mewö jiiga Jeikobnöŋ irimŋi seholiiga uruönön möt waŋgiba kewö jiyök: “Ni mönö morö denöwö qiwikŋaibileŋak? Anutunöŋ gi morö memangö jöhöm gihiba malökmö, nöŋön Anutuya qahö.” ");
INSERT INTO bmu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Mewö jiiga Reizölnöŋ kewö jiyök: “Nöŋgö welen ambini Bilha mi ki. Ölöp yambuk ahönöŋga nöŋgöra morö mema. Yaŋön nam köliga nöŋön mewöyök yaŋgöreŋök nahönbörat miwikŋaim eŋgiba namŋini aka malmam.” ");
INSERT INTO bmu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Mewö jiba welen ambiŋi Bilha waŋgiiga anömŋa memba yambuk ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ahöiga Bilhanöŋ gölöm ala Jeikobkö nahönŋi meyök. ");
INSERT INTO bmu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Nahönŋi meiga Reizölnöŋ kewö jiyök: “Anutunöŋ kewöt niŋgii dop kölbiga köuluk keuni möta morö azia niŋgiza. “Miaŋgöra qetŋi Dan qerök. (Dan Kewöt niŋgii dop köljal.) ");
INSERT INTO bmu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Reizölgö welen ambiŋi Bilha yaŋön kunbuk gölöm ala Jeikobkö nahönŋi kun meiga yahöt ahök. ");
INSERT INTO bmu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Mewö meiga Reizölnöŋ kewö jiyök: “Datnambuk gwötpuk aum-möriba luhut aljal. “Mewö jiba miaŋgö dop morö qetŋi Naftali (Aum-mörial) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leanöŋ kunbuk gölöm qahö ala mi eka miaŋgöra nanŋi welen ambiŋi qetŋi Zilpa memba Jeikob waŋgii anömŋa ahök. ");
INSERT INTO bmu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Anömŋa aka Jeikobkö morö azia meyök. ");
INSERT INTO bmu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Meiga Leanöŋ “Simbawoŋ!” jiba qetŋi Gad (simbawoŋ) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, Leagö welen ambiŋi miaŋön Jeikobkö nahönŋi kun kunbuk meiga yahöt ahök. ");
INSERT INTO bmu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Mewö aiga Leanöŋ keu kewö jiyök: “Nöŋön uruölöwak ketaŋi mötzal. Ambi yeŋön mönö nöŋgöra oyaeŋkoyaeŋ qeta malme. “Mewö jiba miaŋgö dop morö qetŋi Aser qerök. (Aser Oyaeŋkoyaeŋ qetme.) ");
INSERT INTO bmu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Witnöŋ öliiga yandiyandi nalöŋe sömaŋi kunöŋ Rubenöŋ yaigep anda gölme köröŋe asagwalim amöt miwikŋaiyök. Amöt mi miwikŋaiba memba kaba namŋi Lea waŋgiyök. Waŋgiiga Reizölnöŋ datŋaŋgöra kewö jiyök: “Göhö nahöngan amöt memba kazawi, miaŋgö tosatŋi mönö niŋginöŋga nembi.” ");
INSERT INTO bmu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Mewö jiiga Leanöŋ kewö jiyök: “Göŋön apni noaŋgitnöŋga dop kölmapkö mötmörialmö, gi mönö nahönaŋgöreŋ asagwalim amöt ki mewöŋanök noaŋgitmamgö mötzan. Mi qahö dop kölja. “Mewö jiiga Reizölnöŋ kewö jiyök: “Ölöp! Nahöngahöreŋ amöt mi niŋgiman ewö, mönö ölöp Jeikobpuk suŋgem ki ahömahot.” ");
INSERT INTO bmu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Mewö jiiga Jeikobnöŋ mare miaŋgöreŋ nup mosöta kaiga Leanöŋ anda miwikŋaim waŋgiba kewö jiyök: “Nöŋön nahönaŋgöreŋ asagwalim amöt miaŋön lök göhö söŋgörögi mezal. Miaŋgöra mönö nömbuk ahöbit. “Mewö jiiga Jeikobnöŋ suŋgemŋi miaŋgöreŋ yambuk ahöyohot. ");
INSERT INTO bmu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Yambuk ahöyohotka Anutunöŋ Leagöreŋ keu köulukŋi möriga gölöm ala Jeikobkö nahönŋi 5:ŋi meyök. ");
INSERT INTO bmu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Mi memba keu kewö jiyök: “Nöŋön welen ambini mi apni waŋgialaŋgöra Anutunöŋ miaŋgö töwaŋi ki niŋgiza. “Mewö jiba miaŋgö dop qetŋi Isakar (töwa) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Miaŋgö andöŋe Leanöŋ kunbuk gölöm ala Jeikobkö nahönŋi 6:ŋi meyök. ");
INSERT INTO bmu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Mi memba keu kewö jiyök: “Anutunöŋ kalem qetpuk niŋgiza. Apni Jeikobkö nahönurupŋi 6 mealaŋgöra yaŋön mönö pöndaŋ nömbuk mala qetbuŋa niŋgiba malma. “Mewö jiba miaŋgö dop morö qetŋi Zebulun qerök. (Zebulun qetbuŋa) ");
INSERT INTO bmu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Nalö tosatŋi teköiga Leanöŋ morö börat memba qetŋi Daina qerök. ");
INSERT INTO bmu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Anutunöŋ dumŋe Reizöl mewöyök mötmörim waŋgiba keu köulukŋi möta gölöm almamgö bauköm waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Bauköm waŋgiiga gölöm ala morö nahön kun memba keu kewö jiyök: “Anutunöŋ gamuni meköza.” ");
INSERT INTO bmu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mewö jiba toroqeba kewö jiyök: “Kembunöŋ mönö nahöni kun toroqeba niŋgima. “Mewö jiba miaŋgö dop morö qetŋi Josef (Toroqeba niŋgima.) qerök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Reizölnöŋ nahönŋi Josef meiga miaŋgö andöŋe Jeikobnöŋ Labangöra kewö jiyök: “Ni nani miri gölmene anmamgö mötzal. Miaŋgöra ölöp melaim niŋginöŋga liliŋgöba anmam. ");
INSERT INTO bmu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Anöm moröurupni kieŋgöra aka göhö welengi qeba malali, mönö i niŋginöŋga mohotŋe köna anbin. Nöŋön nup gwötpuk ketaŋi memba malali, mi nangak ölöp mötzan.” ");
INSERT INTO bmu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Mewö jiiga Labanöŋ kewö jiyök: “Gi möt ölöwak niŋgizan ewö, mönö ölöp ki malman. Kembunöŋ göhöra aka ni kötuetköm niŋgiba malöhi, nöŋön unju qebiga keu mewö asuhui mötzal.” ");
INSERT INTO bmu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mewö jiba toroqeba kewö jiyök: “Mönö nupkahö töwaŋaŋgö jaŋgöŋi jinöŋga söŋgöröŋi mi ölöp gihimam.” ");
INSERT INTO bmu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Mewö jiiga Jeikobnöŋ kewö jiyök: “Nöŋön göhö welengi denöwö qeba mala göhö mirigö sömbup kambuŋi kambuŋi galöm köl eŋgibiga qarigeri, mi nangak ölöp mötzan. ");
INSERT INTO bmu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Mutuk ni ki qahö kabiga miaŋgöreŋ sömbup yuaigi gwötpuk qahö ahöm gihiyökmö, miaŋön mönö ni kabiga nalö miaŋgöreŋ sehiba jesöŋgö akze. Ni denike denike anda kayali, miaŋgöreŋ Kembunöŋ kötuetköm gihiiga malnöŋ. Mewö malnöŋmö, ni mönö wani nalönöŋ ölöp nani könagesöurupni naŋgöm eŋgimamgöra aka nup yuai könahiba membileŋak?” ");
INSERT INTO bmu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Mewö jiiga Labanöŋ kewö qesiyök: “Ni mönö wania gihibileŋak?” Mewö qesiiga Jeikobnöŋ meleŋda kewö jiyök: “Yuai kun kude niŋgimanmö, yuai mohot ki nöŋgöra akŋan ewö, ni ölöp toroqeba göhöreŋ lama kambuŋi kambuŋi mi köyan köla jegalöm ak eŋgiba malmam. ");
INSERT INTO bmu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ni ölöp göhöreŋ lama aka meme kambugi pakpak mi merak eŋgek kewötmam. Mi kewöta lama moröŋi baröm pakpak aka meme (noniŋ) dömŋi tiktokŋinambuk aka kulemŋini diriweŋ, soŋo me koromboŋgi mi pakpak mendeŋda nanŋini tokom eŋgiman. Mieŋön ölöp nup memba malalaŋgö töwani akŋe. ");
INSERT INTO bmu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Könaŋgep nupnaŋgö töwani, lama aka meme mi eŋgek kewötmamgöra kabanak, nalö miaŋgöreŋ uruni diŋdiŋaŋgö könaŋi mi amqeba kewö miwikŋaiman: Meme (noniŋ) tiktokŋini qahö aka diriweŋ, soŋo me koromboŋgi qahö mi pakpak aka lama baröm qahö pakpak nöŋgö kambunöŋ kinmei, mi nöŋön yoŋgorö meal, mewö möt kutuman.” ");
INSERT INTO bmu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Mewö jiiga Labanöŋ kewö meleŋnök: “Ni ölöp urumohot akzal. Keu jizan ewö köna mi ahöma.” ");
INSERT INTO bmu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mewö meleŋda silim miaŋgöreŋök Labanöŋ meme (noniŋ) aziŋi kulemŋini jiŋjalalaŋ aka diriweŋ soŋo me koromboŋgi aka meme ambiŋi pakpak kulemŋini tiktokŋinambuk aka diriweŋ soŋo me koromboŋgi me sile jupŋine yuai tuatŋi taröhi, mi pakpak aka lama moröŋi baröm pakpak mi kewöta meköm eŋgiba nanŋi nahönurupŋi yeŋgö böröŋine al eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Labanöŋ mi al eŋgiba yembuk Jeikobköreŋ lama aka meme kambu mi eŋguaŋgita silim karöbut anangö dop anda miaŋgöreŋ malget. Köröwen mewö malgetka Jeikobnöŋ toroqeba Labangöreŋ lama aka meme kambuŋi kambuŋi mi galöm köl eŋgiba malök. ");
INSERT INTO bmu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mewö mala sau, kömin aka kuŋgam ip mieŋgö böröŋini gwölögwölö kutuba memba sileŋini jölanjölan (jöraŋjöraŋ) köndölatiiga sutŋe sutŋe tuariiga jiŋjalalaŋ ahök. ");
INSERT INTO bmu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Mewö aiga ip böröŋini köndököndölatiŋi mi memba sömbup yeŋgö o joutŋini pakpak miaŋgöreŋ aliga o nembingöra kagetka wösöŋineyök ahöyök. Mewö ahöiga lama aka meme kambu yeŋön aziŋan eŋgualöŋmegö sihim könöpŋi möta o nembingöra kaba miwikŋaiba eket. ");
INSERT INTO bmu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Mewö eka meme aziŋi yeŋön ip böröŋi mieŋgö kösutŋine ambiŋi eŋgualöŋget. Mewö eŋgualöŋgetka gölöm ala malgeraŋgöra moröurupŋini jiŋjalalaŋ, tiktokŋinambuk aka diriweŋ, soŋo me koromboŋgi mi eŋgömemba malget. ");
INSERT INTO bmu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Mewö malgetka Jeikobnöŋ lama aka meme (noniŋ) moröŋi mewöŋi mi kewöta mendeŋ eŋgiba nanŋök nanŋök kambu köl eŋgiyökmö, sömbup ketaŋi mi areŋgöm eŋgiiga jeŋini Labangöreŋ sömbup baröm aka kimbiŋini tiktokŋinambuk yeŋgöreŋ göröken uba kinget. Mewö aka nanŋaŋgöra lama aka meme (noniŋ) kambuŋi kambuŋi meköba miwikŋaim eŋgiyök. Mi miwikŋaiba jöhöm eŋgiiga Labangö lama kambunöŋ qahö anda toroqem eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sömbup ambiŋi köhöikŋi yeŋön aziŋan eŋgualöŋmegö sihim könöpŋi mötketka Jeikobnöŋ nalö dop miaŋgöreŋ ip böröŋi mi o joutnöŋ alök. Miaŋgöra sömbup aziŋi yeŋön kaba mi wösöŋine miwikŋaiba eka kösutŋe miaŋgöreŋ ambiŋi mi eŋgualöŋda malget. ");
INSERT INTO bmu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mewö malgetmö, sömbup ambiŋan ösumŋini eretŋi aket ewö, yaŋön ip böröŋi mi yeŋgö wösöŋine qahö ala malök. Mewö aka maliga sömbup ösumŋini eretŋi mieŋön Labangöreŋ kambunöŋ toroqegetka ösumŋini köhöikŋi yeŋön Jeikobkö kambunöŋ anda toroqeget. ");
INSERT INTO bmu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jeikobnöŋ mewö aka kindiŋbirik azi qetbuŋaŋambuk aka töhötmöriam miwikŋaiyök. Lama aka meme kambu gwötpuk buŋa qem aŋguba welenqeqe ambazip eŋguaŋgiriga kamel aka doŋki kambuŋi kambuŋi asuhum sehigetka toŋini ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Labangö nahönurupŋan keu kewö jigetka Jeikobkö kezapŋe geiga mörök: “Iwininan yuai buŋa qeba malöhi, Jeikobnöŋ mi pakpak kalöpköba könjörata aŋgön kölök. Iwininaŋgö sukinapŋi galöm köla miaŋgöreŋök inapŋi pakpak mi nanŋaŋgöra miwikŋaiba kindiŋbirik akza.” ");
INSERT INTO bmu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Keu mi mörök aka yöwöŋaŋgö jemesoholŋi eka kewö möt asariyök: “Labanöŋ mutuk ala ölöpŋi ak niŋgiba mala korökmö, mewö qahö toroqeba aka malja.” ");
INSERT INTO bmu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mewö möt asariiga Kembunöŋ Jeikob kewö jii mörök: “Göŋön mönö liliŋgöba iwiasaurupki yeŋgö gölmenöŋ anda tinitosolomurupki yembuk malman. Anda malnöŋga nöŋön göbuk kinda malmam.” ");
INSERT INTO bmu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jeikobnöŋ keu mi möta Reizöl aka Lea yetköra keu ali aniga gölme köröŋe lama kambuŋi kambuŋi galöm köl eŋgiyöhi, miaŋgöreŋ kayohot. ");
INSERT INTO bmu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Kayohotka kewö jii mörohot: “Nöŋön iwiŋiraŋgö jemesoholŋi eka kewö möt asarizal: Yaŋön mutuk ala ölöpŋi ak niŋgiba mala korökmö, mewö kunbuk qahö aka malja. Iwinaŋgö Anutuŋan mönö töndup nömbuk kinda mala korök. ");
INSERT INTO bmu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ni ösumni pakpak qezaköba miaŋgö dop iwiŋiri welen qem waŋgiba mala korali, iŋiri mi ölöp mötzahot. ");
INSERT INTO bmu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","“Mewö malalmö, yaŋön isimkakalek qakŋe ak niŋgiba mala nupnaŋgö töwaŋi mi sömaŋi 10:gö dop utekutek ala malök. Mewö ak niŋgiba malökmö, Kembunöŋ aŋgön köl waŋgiiga geŋmororoŋ kun qahö ak niŋgiiga malal. ");
INSERT INTO bmu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nalö kunöŋ kewö jiyök, ‘Lama aka meme (noniŋ) tiktokŋinambuk asuhumei, mi mönö göhö nup töwagi akŋe.’ Mewö jiiga sömbup kambu jömukŋi yeŋön moröŋini tiktokŋinambuk eŋgömeget. Nalö kunöŋ kewö jiyök, ‘Lama aka meme (noniŋ) jiŋjalalaŋ asuhumei, mi mönö göhö nup töwagi akŋe.’ Mewö jiiga sömbup kambu jömukŋi yeŋön moröŋini jiŋjalalaŋ eŋgömeget. ");
INSERT INTO bmu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Anutunöŋ mewö aiga asuhuiga iwiŋiraŋgö kambuŋeyök sömbup könjörata eŋguaŋgita niŋgiiga sehiyök. ");
INSERT INTO bmu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Sömbup aziŋan ambiŋi eŋgualöŋda malgeri, nalö kun miaŋgöreŋ gaun kunöŋ jeni uba wahöta ekiga meme (noniŋ) aziŋan ambiŋi eŋgualöŋda kingeri, yeŋgö sileŋini mi jiŋjalalaŋ, tiktokŋinambuk aka diriweŋ, soŋo me koromboŋgi pakpak aket. ");
INSERT INTO bmu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nöŋön gaun ekiga miaŋgöreŋ Anutugö garata kunŋan nöŋgöra ‘Jeikob!’ qerök. Mewö qeriga ‘Ki kinjal,’ jiba meleŋnal. ");
INSERT INTO bmu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Meleŋniga kewö toroqeba jiyök: ‘Labanöŋ yuai pakpak ak gihimakzawi, nöŋön mi eka mötzal. Miaŋgöra ölöp jegi uba wahöta eknöŋ: Meme (noniŋ) aziŋi pakpak ambiŋi eŋgualöŋda kinjei, yeŋgö sileŋinan jiŋjalalaŋ, tiktokŋinambuk aka diriweŋ, soŋo me koromboŋgi akza. ");
INSERT INTO bmu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nöŋön Betel miaŋgöreŋ asuhum gihibiga köt dangunu kun kuŋguba miriba nöŋgöra keu jöhöba jöjöpaŋ keunöŋ jim köhöinöŋ. Nöŋön Anutu mi aka göhöra keu kewö jizal: Gi mönö dölki wahöta kantri ki mosöta nangi ahuahu gölmege kunbuk liliŋgöba anman.’” ");
INSERT INTO bmu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Jeikobnöŋ keuŋi mewö jiiga Reizöl aka Lea yetkön kewö meleŋ waŋgiba jiyohot: “Iwiniraŋgö mire börösamotkö bahöŋi kun mi neŋgöreŋ qahö toroqeba tatza. ");
INSERT INTO bmu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yaŋön azi netkiiga söŋgöröniran kaiga mi nanŋaŋgörök memba gil teköyök. Miaŋgöra niri mönö kian tandök ak netkiiga mala korit. ");
INSERT INTO bmu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Miaŋgöra Anutunöŋ iwiniraŋgö kambuŋeyök sukinap öröyuai könjörata waŋgiri sehiyöhi, mi pakpak mönö ölŋa nanine aka nahönböraturupnini neŋgö buŋaya akza. Miaŋgöra Anutunöŋ jim kutum gihiyöhi, göŋön mönö mi pakpak tem köla wuataŋgöman.” ");
INSERT INTO bmu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Mewö jiyohotka wahöta mem mözözöm aka anöm-moröurupŋi kököbihim eŋgiiga kamel qakŋine öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Mirigö sömbup kambuŋi pakpak közöl eŋgiiga mutuk anget. Sukinap yuaiŋi (merömbuŋi) pakpak Mesopotemia (Padan Aram) gölmenöŋ mala miwikŋaim sehiyöhi, mi körekbörek kölolohoba iwiŋi Aisaköreŋ anbingöra Keinan gölmenöŋ göröken anget. ");
INSERT INTO bmu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Nalö miaŋgöreŋ Labanöŋ lama jupŋini mitimamgö aniga Reizölnöŋ iwiŋaŋgöreŋ miri domlopioŋ morörökŋi yoŋgorö meyök. ");
INSERT INTO bmu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yoŋgorö meiga Jeikobnöŋ toroqeba yöwöŋi Aram azi Laban i kewö tilipköm waŋgiyök: Anbingö keuŋi mi qahö jii mörökmö, mönö ölöŋ mosöta anget. ");
INSERT INTO bmu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Mewö ölöŋ angetka kamel yeŋön öröyuaiŋi pakpak mem bisiget. Anda Yufreitis o kutuba Gilead gölme kunduŋambuk miaŋgöreŋ göröken anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Angetmö, silim karöbut aiga miaŋgöreŋ keu kewö jigetka Labanöŋ mörök, “Jeikobnöŋ mönö tököba ölöŋ köla anök.” ");
INSERT INTO bmu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Mi möta wahöta tinitosolom aziurupŋi eŋgömemba wehön 7:gö dop eŋguataŋgöba anda mala Gilead gölme kunduŋambuk miaŋgöreŋ miwikŋaiba eŋgömeget. ");
INSERT INTO bmu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Eŋgömemba suŋgem miaŋgöreŋök Anutunöŋ Aram azi Labangöra gaunöŋ asuhuba keu kewö jii mörök: “Göŋön Jeikobköra kötumötuet me qesuak keu kun jibanbuköra mönö möt kutuba galöm mem aŋguman.” ");
INSERT INTO bmu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Eŋgömegetka Jeikobnöŋ opo seri koumŋi Gilead gölme kunduŋambuknöŋ möröreŋgöba kuŋguiga Laban aka aziurupŋi yeŋön mewöyök opo seri koumŋini miaŋgöreŋ kuŋguba ahöget. ");
INSERT INTO bmu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ahöba wahöta qiŋgiŋi Jeikobköreŋ anda kewö jii mörök: “Gi mönö wani kimbia ak niŋginöŋe? Gi tilipköm niŋgizan. Kerök yeŋön yarö gila ambi yoŋgorö örömakzei, mönö miaŋgö tandök nöŋgö böratyahötni ölöŋ etkuaŋgita kanöŋ. ");
INSERT INTO bmu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Gi wuanöŋgöra isimkakalek ak niŋgiba ösumok ölöŋ köla nömosöta kanöŋ? Gi mönö wuanöŋgöra keu kun qahö jinöŋ mötpi laŋ kanöŋ? Mi mötpileŋak ewö, nöŋön ölöp liŋet gwawet albi kömam köla gita kulele qegetka sösöŋgai qakŋe gumbulbi könanöŋ kabeak. ");
INSERT INTO bmu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","“Mi mötpileŋak ewö, mönö ölöp isiurupni aka böratyahötni numbuŋini yöhötim nemba yaizökzökŋini jibileŋak. Gi mönö uruqahö kimbia aknöŋ. ");
INSERT INTO bmu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nöŋön kukösumnambuk kaba ölöp ayuhum gihibileŋakmö, suŋgem ahöbiga iwigahö Anutuŋan keu kewö jii mötzal: ‘Göŋön Jeikobköra kötumötuet me qesuak keu kun jibanbuköra mönö möt kutuba galöm mem aŋguman.’ ");
INSERT INTO bmu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Miaŋgöra muat, nangi iwigahö miri gölmeŋe liliŋgömamgö urusihimgi ketaŋi möta malagun lök mosöta könanöŋ kaba maljan. Miaŋgöra ölöp anmanmö, nöŋgö domlopioŋurupni mi mönö wuanöŋgöra yoŋgorö memba kanöŋ?” ");
INSERT INTO bmu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Labanöŋ mewö jiiga Jeikobnöŋ kewö meleŋ waŋgiyök: “Göŋön böratyahötki yarö ösum qakŋe noaŋgitpanbukö mötmöriba keŋgötni möta ölöŋ köla kain. ");
INSERT INTO bmu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kainmö, kunŋan domlopioŋurupki meiga miwikŋaimani, i ölöp qenöŋga kömuma. Öröyuai pakpak memba maljali, mi ölöp tinitosolomurupniri yeŋgö jeŋine ek kewöta kinda göhöreŋ yuaigi kun miwikŋaiba eka mi ölöp meman. “Jeikobnöŋ mewö jiyökmö, anömŋi Reizölnöŋ domlopioŋ mi yoŋgorö meyöhi, apŋan mi qahö möröhaŋgöra mi tönpin jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Mewö jiiga qiŋgiŋi Jeikobkö opo seri koumŋe öŋgöba qezaŋda jaruba Leagö opo seri koumŋe öŋgöba toroqeba welen ambiyahöt mietkö opo seri koumŋire öŋgöba qezaŋda jaruba yuai kun qahö miwikŋaiyök. Leagö koumŋi mosöta miaŋgö andöŋe Reizölgö koumnöŋ öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Öŋgöyökmö, Reizölnöŋ domlopioŋurup mi memba gösönöŋ löŋgöta kamel qakŋe tatatkö dum uruŋe ala qakŋe öŋgöba qelanjim eŋgiba tarök. Mewö tariga iwiŋan opo koumŋaŋgö uruŋi körek qezaŋnökmö, mi qahö miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Reizölnöŋ iwiŋi kewö jii mörök: “Ketaŋamni, ni köiŋnöŋ nehiga tatzalaŋgöra aka göhö jemesoholge ölöp qahö wahötmam. Miaŋgöra uruönön kude möt niŋgiman. “Mewö jiiga miriŋaŋgö domlopioŋurupŋi mieŋgöra jaruyökmö, mi qahö miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Qahö miwikŋaiiga kinda Jeikobnöŋ irimŋi seholiiga tembula Laban kewö jim waŋgiba qesim waŋgiyök: “Nöŋön wani könaya ak siŋgial? Mönö wani silik bölöŋi ak gihialaŋgöra kahasililiŋnöŋ böröjaŋ suhum niŋgizan? ");
INSERT INTO bmu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nöŋgö sukinapni pakpak qezaŋ teköbagun mönö wanat yuaia kun miwikŋainöŋga nangi mirigahö buŋaya akawak? Mi ölöp memba yuhu kaba tinitosolomurupniri yeŋgö jeŋine alnöŋ eketka sutnire keu lömböt ahöiga mi kewöta jim teköba mindiŋgöm netkime. ");
INSERT INTO bmu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Nöŋön göbuk lök yambu 20 mala koral. Nalö miaŋgö uruŋe nupki membiga göhöreŋ lama aka meme (noniŋ) yeŋön morö membingö pömsöm qahö qegetmö, ölöpŋanök ahumsehip aka malget. Mewöyök lama aziŋi kun göhö sömbup kambunöhök qahö qem neal. ");
INSERT INTO bmu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nalö tosatŋe sömbup kalŋan lama qeba yöhöqöhötiyöhi, mi qahö memba kaba gihiba malalmö, miaŋgö kitipŋi mi nani kambunöhök memba salupŋe ala malal. Lamagi suŋgemŋe me asakŋe yoŋgorö memba malbeahi, mi töndup miaŋgö salupŋi almamgö jimkutukutu alnöŋga mi wuataŋgöba malal. ");
INSERT INTO bmu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","“Silimnöŋ miri könöpŋan nohotiriiga suŋgemnöŋ amötŋan nuŋguiga saŋgenŋi möta malal. Nalö gwötpuk gaun guli mem niŋgiiga malal. ");
INSERT INTO bmu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yambu 20:gö dop mewö göhö mire mala kotpi teköza. Yambu 14 mi böratyahötki etkömemamgöra welen qem gihiba malal. Miaŋgö andöŋe yambu 6 mi lama bulmakau miwikŋaimamgöra göhöreŋ nup memba malal. Mewö malalmö, göŋön nup memegö töwani mi sömaŋi 10:gö dop utekutek ala malnöŋ. ");
INSERT INTO bmu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","“Asani Abrahamgö Anutuŋi iwini Aisaknöŋ waikŋi memba möpöseimakzawi, yaŋön andöne awörök qahö aka kötöngöm niŋgibawak ewö, göŋön mönö böröbörak melaim niŋginöŋga köna anbileŋak. Mewö ak niŋgibanakmö, Anutunöŋ nöŋgöreŋ sihimbölö kahasililiŋ möriga nup börönan sileqeqe aka memba malali, mi eka merak suŋgem nöŋgö keuni kewöta jim teköiga mötzan. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Jeikobnöŋ mewö jiiga Labanöŋ kewö meleŋ waŋgiyök: “Ambi yahöt ki mönö nöŋgö böratyahötna. Yetkö nahönböraturupŋiri mi nöŋgöreŋa. Lama bulmakau kambuŋi kambuŋi ki mi nöŋgöreŋa. Yuai pakpak ki ekzani, mi körek nöŋgö buŋayök akza. Mewömö, muat nöŋön merak böratyahötni ki aka nahönböraturupŋiri eŋgömeyohori, yeŋön anmegö keuŋini jigetka mi qeapkömamgö lömbörizal. ");
INSERT INTO bmu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Miaŋgöra ölöp kaba gou köl aŋguba sutnire jöhöjöhö akit. Mi qendeŋbitpuköra mötmörim netkiba dangunu ewö sutnire ahöma.” ");
INSERT INTO bmu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Mewö jiiga Jeikobnöŋ köt kun memba kuŋguiga timbetuat ewö dangunu jaböŋiri aka kinök. ");
INSERT INTO bmu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Miaŋön kiniga Jeikobnöŋ tinitosolomurupŋi yeŋgöra köt memba tokomegöra jiyök. Mewö jiiga köt memba qaknöŋ qaknöŋ ala tokoget öŋgöiga miaŋgö kösutŋe nene lömbuaŋ ohoba neget. ");
INSERT INTO bmu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labanöŋ köt kambu miaŋgö qetŋi Jegar Sahaduta qeri Jeikobnöŋ qetŋi Galed qerök. ");
INSERT INTO bmu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Mewö qerohotka yöwöŋan qiŋgiŋi Jeikob kewö jii mörök: “Köt kambu ki mönö merak netkö sutnire dangununira ahöma. “Miaŋgöra Jeikobnöŋ miaŋgö qetŋi Galed qerök. ");
INSERT INTO bmu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Labanöŋ keu toroqeba kewö jiyök: “Kembunöŋ mönö deŋda malbiri, nalö miaŋgöreŋ sutnire jeŋan netkek tiba galöm mem netkiba malma. “Miaŋgö dop gölme miaŋgö qetŋi kun Mizpa qerök. (Mizpa Galöm meme miri köröpŋi.) ");
INSERT INTO bmu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labanöŋ keu mi toroqeba kewö jiyök: “Göŋön böratyahötni öröm ureim ak etkiman me toroqeba kakasun ambi tosatŋi eŋgömeman ewö, mönö keu ki möta malman: Gölme azi kunŋan kösutnire qahö mala netkehiga Anutunöŋ mönö töndup ölöp netkeka sutnire jöhöjöhö ahözawaŋgö keuŋi mi naŋgöba jiba malma.” ");
INSERT INTO bmu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Mewö jiba kunbuk toroqeba kewö jiyök: “Qiŋgini mötnöŋ, köt kambu ki aka mötök ki kuŋguzali, mietkön mönö netkö sutnire dangunu ewö tat öŋgömahot. ");
INSERT INTO bmu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Köt kambu ki mönö dangununira aka tat öŋgöma aka mötök ki mi mewöyök dangununira aka tat öŋgöma. Mietkön jöhöjöhöniraŋgöra kewö mötmörim netkiba tat öŋgömahot: Nöŋön mem bölim gihimamgö möta köt kambu ki qahö oŋgita göhöreŋ kamam. Göŋön mewöŋanök mem bölim niŋgimamgöra möta köt kambu aka mötök ki qahö etkoŋgita nöŋgöreŋ kaman. ");
INSERT INTO bmu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham, Nahor aka yetkö iwiŋiri yeŋgö bemŋini Anutu yaŋön mönö keu sutnire asuhuiga mi kewöta jim teköm netkima. “Labanöŋ mewö jiiga Jeikobnöŋ keu mi jöhöba Anutugö qetŋe jöjöpaŋ keunöŋ jim köhöiyök. Iwiŋi Aisaknöŋ Anutu miaŋgö waikŋi memba möpöseiba malök. ");
INSERT INTO bmu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jeikobnöŋ mewö aka gölme kunduŋe sömbup qeba miaŋön jöwöwöl ohoba tinitosolomurupŋi öröm eŋgiiga lömbuaŋnöŋ kaget. Kaba nene nemba suŋgem liŋet unduba kunduŋe miaŋgöreŋ ahöget. ");
INSERT INTO bmu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ahögetka miri asariiga Labanöŋ söŋanök wahöta isiurupŋi aka böratyahötŋi numbuŋini yöhötim nemba kötuetköm eŋgiba yaizökzökŋini jiyök. Mi jiba eŋgömosöta liliŋgöba miriŋe anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yöwöŋan aniga Jeikobnöŋ mewöyök könanöŋ aniga Anutugö garataurupŋi tosatŋan miwikŋaim waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Miwikŋaim waŋgigetka eŋgeka kewö jiyök: “I Anutugöreŋ yarö kambuya akze. “Miaŋgö dop gölme miaŋgö qetŋi Mahanaim (yarö kambu yahöt) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jeikobnöŋ könanöŋ anda mala kolek aziurupŋi tosatŋi mutuk melaim eŋgii Edom kantrigö gölme qetŋi Seir miaŋgöreŋ datŋi Iso ekingöra anget. ");
INSERT INTO bmu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Melaim eŋgiba kewö jim kutum eŋgiyök: “Iŋini mönö anda dat kembuni Iso kewö jigetka mötma: ‘Ketaŋamni mötnöŋ, ni welen azigi Jeikob. Ni ehoniri Labanbuk mala kota mal teköba nalö kewöŋe i mosöta kazal. ");
INSERT INTO bmu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Miaŋgöreŋ mala bulmakau, doŋki, lama, meme (noniŋ) kambuŋi kambuŋi aka welenqeqe ambazip miwikŋaiba eŋgömemba könanöŋ kazal. O azi kembuni, nöŋön göhö jege ak-kömukömu miwikŋaimamgöra möta keu buzupni ki mutuk albi göhöreŋ kaza.’” ");
INSERT INTO bmu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mewö jim kutum eŋgiiga anda liliŋgöba kaba kewö jigetka mörök: “Nini datki Isogöreŋ anin. Yaŋön mönö aziurupŋi 400 eŋgömemba könanöŋ kaba göbuk aitoŋgöbingö jöjöröba malje.” ");
INSERT INTO bmu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Mewö jigetka möta awöwöliba köŋjiliŋ ketaŋi mörök. Mewö möta kinda könagesöurupŋi yambuk kageri, mi aka lama meme kambuŋi kambuŋi, bulmakau kambuŋi kambuŋi aka kamelurupŋi mi mendeŋ eŋgiiga kambu yahöt aket. ");
INSERT INTO bmu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kewö mötmöriba mewö ahök: “Isonöŋ kaba yarö gila kambu kun eŋgum ayuhuma ewö, kambu kun yeŋön mönö ölöp ölöŋ köla anbeak.” ");
INSERT INTO bmu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Mewö mötmöriba kewö jiba köuluköyök: “O Anutu, asani Abrahamgö aka iwini Aisakö bemŋiri, göŋön ölöp möt niŋgiman. Kembu, gi nangok keu kewö jinöŋ möral: ‘Gi mönö wahöta nangi gölmenöŋ liliŋgöba nangi tinitosolomurupki yeŋgöreŋ anman. Endu anöŋga nöŋön töhötmöriam gihibiga malman.’ Mewö jinöŋ möral. ");
INSERT INTO bmu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mönöwök nani öröpnanök memba Jordan o töwatŋi ki kutuba analmö, ölöp ahum sehiba merak liliŋgöba kambu yahöt aka ki kazal. Ni welen azigi etqeqeŋi aka malalmö, göŋön töndup keugi pöndaŋ wuataŋgöba ak-kömukömugi pakpak kondel niŋgiba malnöŋ. Ni eretŋi aka urukalemgi mi buŋa qem aŋgumamaŋgö dop qahö aka malal. ");
INSERT INTO bmu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","“Datni Isonöŋ könanöŋ kaba nani, nam aka moröurupnini nini neŋguba ayuhum neŋgibapuköra nöŋön keŋgötni mötzal. Miaŋgöra göŋön mönö bauköm neŋgiba yaŋgö böröŋeyök meköm neŋgiman. ");
INSERT INTO bmu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Gi nangok keu kewö jinöŋga möral: ‘Nöŋön töhötmöriam gihiba gwölönarökurupki ahumsehip eŋgibiga qötöŋinan qariba köwetkö sakösiŋi ahözawaŋgö dop akŋa. Mi gwötpuk ketaŋi ahömawaŋgöra aka oyoŋoyoŋgö dop qahö. Keu mi ölŋa.’” ");
INSERT INTO bmu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Mewö köuluköba suŋgemŋi mi gölme miaŋgöreŋ ahöyök. Ahöbagun sömbup kambuŋi kambuŋi mieŋgöreŋök datŋi Iso kalem waŋgimamgöra sömbup kewö kewöt mendeŋ eŋgiba nanŋinök al eŋgiyök: ");
INSERT INTO bmu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Meme (noniŋ) ambiŋi 200, aziŋi 20, lama ambiŋi 200, aziŋi 20, ");
INSERT INTO bmu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel 30 moröurupŋini juzunöŋ, bulmakau ambiŋi 40, aziŋi 10, doŋki ambiŋi 20, aziŋi 10. ");
INSERT INTO bmu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Kambu mewö mewö kewöt mendeŋda kambu nanŋök nanŋök mi welenqeqeurupŋi yeŋgö böröŋine al eŋgiba kewö jii mötket: “Iŋini ölöp mutuk anda sömbup kambuŋi kambuŋi kieŋgö sutŋine tiriŋ kutuba eŋguaŋgita awataŋ anme.” ");
INSERT INTO bmu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Mewö jiba kambu mutukŋi anmeaŋgö galömŋi kewö jim kutum waŋgiyök: “Könanöŋ angetka datni Isonöŋ miwikŋaim eŋgiba kewö qesim gihima: ‘Gi dagö welenqeqe azia akzan? Gi denike anmam jiba kazan? Sömbup wösöge anjei, mi dagöreŋa?’ ");
INSERT INTO bmu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Mewö qesim gihiiga kewö jiman: ‘Mi welen azigi Jeikobköreŋa. Mi ketaŋamŋi Iso kalem waŋgimamgöra al eŋgii kaze. Nanŋak mönö andönine könanöŋ kaza.’” ");
INSERT INTO bmu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Mewö jim kutum waŋgiba sömbup kambu 2:ŋi, kambu 3:ŋi aka sömbup kambu tosatŋi pakpak yeŋgö galömŋini andöŋine kageri, i mewöyök jim kutum eŋgiiga kewö mötket: “Iŋini datni Iso miwikŋaimei, mönö keu tandökŋi miyök jigetka mötma.” ");
INSERT INTO bmu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Mewö jim kutum eŋgiba kewö mötmöriyök: “Nöŋön esapköba uruŋi memba eta ala kalem waŋgimamgöra sömbup kambuŋi kambuŋi melaim eŋgibi mutuk anme. Datnan mi eŋgeka uruŋi bönjöŋ köliga amöribawak. Uruŋi amöriiga ölöp nanak yaŋgö jemesoholŋe ösöŋ aŋgotpi siŋgisöndokni mosöta ala ak niŋgibawak. “Mewö mötmöriba toroqeba kewö jiget mötmapkö jiyök: “Göhö welen azigi Jeikobnöŋ mönö andönine ösöŋ kaza.” ");
INSERT INTO bmu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Mewö jiba kalemŋi al eŋgii mutuk könanöŋ angetmö, nanŋak suŋgem mi opo koumnöŋ tatmam jiba miaŋgöreŋ tarök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Suŋgem miaŋgöreŋ Jeikobnöŋ wahöta anömyahötŋi, welen ambiyahötŋi aka morönahönurupŋi 11 mi eŋguaŋgiriga anda Jabok o sakŋi qöleqöleleiŋi kutubingö aket. ");
INSERT INTO bmu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Eŋguaŋgiri o kutuba anda sukinap yuaiŋi pakpak buŋaŋi ahöyöhi, mi mewöyök memba an teköget. ");
INSERT INTO bmu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","An tekögetmö, Jeikobnöŋ nanŋök o likepŋe miaŋgöreŋ kunbuk tarök. Nanŋök tariga azi kunŋan kaiga yambuk suŋgem aum-möriba malohotka miri giaŋiyök. ");
INSERT INTO bmu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Azi miaŋön luhut al waŋgimamgö osiba eka miaŋgöra Jeikob mi ikinŋe qeyök. Qeiga mohotŋe aum-möriba malohotka miaŋgöreŋ Jeikobkö ikin sihitŋan sulök. ");
INSERT INTO bmu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Sihitŋan suliga azi miaŋön kewö jiyök: “Miri giaŋimamgö akzawaŋgöra mönö ölöp nömosötnöŋga anmam. “Mewö jiyökmö, Jeikobnöŋ kewö meleŋ waŋgiyök: “Ni qahö kötuetköm niŋgiman ewö, nöŋön mönö gi qahö gömosötpi anman.” ");
INSERT INTO bmu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mewö meleŋ waŋgiiga “Gi qetki niŋi?” jiba qesim waŋgiiga “Jeikob,” jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Mewö jiiga keu kewö jiyök: “Gi Anutu aka ambazip yembuk aum-möriba mala luhut al eŋginöŋ. Miaŋgöra göhö qetki mönö kunbuk Jeikob qahöpmö, Israel qetme. “(Israel Anutubuk aum-möriyök.) ");
INSERT INTO bmu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Mewö jiiga kewö jiyök: “Gi ölöp qetki qetnöŋga mötmam. “Mewö jiyökmö, garatanöŋ miaŋön kewö meleŋ waŋgiyök: “Gi denöwögöra nöŋgö qetnaŋgöra qesizan?” Mewö meleŋ waŋgiba miaŋgöreŋ kinda kötuetköm waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kötuetköm waŋgiiga Jeikobnöŋ kewö jiyök: “Ni Anutubuk mesohol köl aŋguba jeŋi törörök ekzalmö, töndup nehoriiga jebuk maljal. “Mewö jiba miaŋgöra gölme miaŋgö qetŋi Penuel qerök. (Penuel Anutugö jemesoholŋi) ");
INSERT INTO bmu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Wehön jeŋan lök koriga Jeikobnöŋ Penuel gölme mi mosöta oŋgita kaba ikinŋi sulöhaŋgöra aka timkorik anök. ");
INSERT INTO bmu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Azi miaŋön Jeikobkö ikin sihit toroqeqeŋaŋgö ginimuramŋe (bidororo) qeyöhaŋgöra aka Israel könagesö yeŋön nalö kewöŋe mewöyök sömbup nemba miaŋgöreŋ ikin sihit toroqeqeŋaŋgö ginimuramŋi mi tököba qahö nemakze. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jeikobnöŋ jeŋi uba wahöta Isonöŋ aziurupŋi 400 yembuk mohotŋe könanöŋ kageri, mi eŋgehök. Miaŋgöra nahönböraturupŋi mendeŋ eŋgiba Lea, Reizöl aka welen ambiyahötŋi yeŋgö böröŋine al eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Mewö al eŋgiba kewö areŋgöm eŋgiyök: Welen ambiyahötŋi yetkön nahönböraturupŋiri eŋguaŋgita mutuk anget. Yeŋgö andöŋine Leanöŋ nahönböraturupŋi yembuk angetka Reizöl aka nahönŋi Josef yetkön qöndökŋi anohot. ");
INSERT INTO bmu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Saiwaŋi mewö areŋgöm eŋgiba nanŋak yeŋgö wösöŋine mutuk anda simin köla gölmenöŋ bamgöba wahöriga indimŋi 7 aiga anda datŋaŋgö jemesoholŋe aŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Aŋgorökmö, Isonöŋ munŋi ekŋamgöra ösumŋan kiŋkiŋgöba kaba suhumgöm waŋgiba böröŋan imbiŋe gili geiga numbuŋi yöhötim neiga urusahöt auyohot. ");
INSERT INTO bmu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Isonöŋ jeŋi uba wahöta Jeikobkö anöm-moröurupŋi eŋgeka munŋi qesim waŋgiyök: “Ki denike yeŋön göbuk kaze?” Qesim waŋgiiga kewö meleŋnök: “Anutunöŋ kalem möriamŋi qakŋe nahönbörat ki welen azigi ni niŋgiyök.” ");
INSERT INTO bmu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mewö meleŋniga welen ambiyahötŋi yetkön nahönböraturupŋiri yembuk dowe kaŋgota simin köla gölmenöŋ bamgöget. ");
INSERT INTO bmu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Miaŋgö andöŋe Lea aka nahönböraturupŋi yeŋön mewöŋanök dowe kaŋgota simin köla gölmenöŋ bamgöget. Teteköŋe Josef aka Reizöl yetkön dowe kaŋgota simin köla gölmenöŋ bamgöyohot. ");
INSERT INTO bmu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Mewö aketka Isonöŋ kewö qesim waŋgiyök: “Azi aka sömbup kambu pakpak könanöŋ miwikŋaim eŋgizali, mi könaŋi denöwögöra melaim eŋginöŋga kaze?” Mewö qesim waŋgiiga kewö jiyök: “O azi kembuni, nöŋön mi göhö jege ak-kömukömu miwikŋaimamgöra aka melaim eŋgial.” ");
INSERT INTO bmu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mewö jiyökmö, Isonöŋ keu kewö jiyök: “O muni, mi nöŋgöreŋ gwötpuk lök dopne ahöze. Miaŋgöra mi ölöp toroqeba nangi buŋaya aka ahöma.” ");
INSERT INTO bmu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Mewö jiiga Jeikobnöŋ kewö jiyök: “Mewö qahö. Göŋön neksihim aka ala ölöpŋi ak niŋginöŋga göhö jemesoholgi ekiga Anutugö jemesoholŋi ewö akza. Miaŋgöra nöŋön göhö jege ak-kömukömu miwikŋaizal ewö, mönö kalemni ki ölöp buŋa qem aŋguman. ");
INSERT INTO bmu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Anutunöŋ kalem möriam kondel niŋgiiga mala kotpiga yuai pakpak osimakzali, mi pakpak ölöp ahöm niŋgiza. Mewögöra uruölöwak kalemni memba kageri, mi ölöp meman. “Mewö jiba kapaŋ köla malöhaŋgöra Isonöŋ uruölöwak kalemŋi mi buŋa qem aŋguyök. ");
INSERT INTO bmu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Buŋa qem aŋguba kewö jiyök: “Mönö ölöp mosöta köna anbin. Nöŋön köiputŋini akiga eŋön ölöp nömbuk kagetka anbin.” ");
INSERT INTO bmu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mewö jiyökmö, Jeikobnöŋ kewö jiyök: “Azi kembuni, mötnöŋ. Nahönböraturupni yeŋön ösumŋini eretŋi akze aka lama namŋi aka bulmakau namŋi moröŋini juzu eŋgimakzei, nöŋön mi köyan köl eŋgimakzal. Mewö aiga i köna anmegöra wehön mohotkö dop könöpuk eŋguataŋgöbinak ewö, yeŋön mönö ösumŋini eriga kambu körek pakpak kömumbeak. ");
INSERT INTO bmu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mewögöra azi kembuni, gi ölöp mutuk anöŋga welen azigi nöŋön ösöŋösöŋ andöge guataŋgöba kamam. Sömbup eŋguataŋgöbi wösöne mutuk anmei aka nahönböraturupni ösumŋinaŋgö dop ösöŋösöŋ kaba mala mala biaŋ Seir mire ketaŋamni göhöreŋ kaŋgotpin.” ");
INSERT INTO bmu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Mewö jiiga Isonöŋ kewö jiyök: “Mewö aiga nöŋön ölöp aziurupni tosatŋi eŋgömosötpiga göbuk ösöŋ kame. “Mewö jiiga Jeikobnöŋ kewö qesiyök: “Gi mönö wuanöŋgöra mewö akanak? O azi kembuni, ni göhö jege ak-kömukömu miwikŋaibiga lök dop köl niŋgim teköza.” ");
INSERT INTO bmu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Mewö jiiga Isonöŋ wehön miaŋgöreŋök liliŋgöba anda Seir miriŋe aŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jeikobnöŋ Sukot mire anda miaŋgöreŋ nanŋi miriŋi esiba sömbupurupŋi yeŋgöra koumŋi koumŋi qeyök. Mewögöra miri gölme miaŋgö qetŋi Sukot (Koumkoum) qerakze. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jeikobnöŋ mewö Mesopotemia (Padan Aram) gölme mosörök. Mosöta kaba Keinan gölmegö taon qetŋi Sekem miaŋgöreŋ ölöpŋanök ölulup kaŋgorök. Kaŋgota opo seri koumŋi taon kösutŋe gölme köröŋe möröreŋgöba kuŋguba tatket. ");
INSERT INTO bmu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Opo seri koumŋi gölme köröŋe kuŋguyöhi, yaŋön gölme kitipŋi mi Sekemgö iwiŋi Hamor yaŋgö nahönurupŋi yeŋgöreŋök silwö kötŋi 100 miaŋön bohonŋi meyök. ");
INSERT INTO bmu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Bohonŋi memba miaŋgöreŋ jöwöwöl alta kun memba qetŋi “El, Israelgö bem Anutuŋi,” mewö qerök. (El bem) ");
INSERT INTO bmu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Leanöŋ Jeikobkö böratŋi Daina meyöhi, yaŋön nalö kunöŋ Keinan ambi seram eŋgekŋamgöra anök. ");
INSERT INTO bmu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Aniga gölme miaŋgö azi kembuŋi Hamor yaŋön Hiwi könagesögö azia malök. Yaŋgö nahönŋi Sekem yaŋön Daina eka miaŋgöreŋök eksihim möta öröba mem bölim waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekemnöŋ wölbötŋi Jeikobkö böratŋi Dainagöra pöröraköiga jöhöba urukalemŋan jöpaköm waŋgiba kelök keuŋan jiba tutuhum waŋgiba malök. ");
INSERT INTO bmu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tutuhum waŋgiba mala iwiŋi Hamor kewö jii mörök: “Iwini, gi ölöp ambi seram ki nöŋgö anömna akŋapköra keu nup meman.” ");
INSERT INTO bmu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nalö miaŋgöreŋ Jeikobkö nahönurupŋi yeŋön gölme köröŋe anda mirigö sömbupurupŋini galöm köl eŋgiba malgetka Sekemnöŋ Daina mem böliiga iwiŋi Jeikobnöŋ böratŋaŋgö keu buzupŋi mi mewö mörök. Mi mörökmö, mi mösamböta nahönurupŋan mire kaŋgotmegöra keu bök mamböta tarök. ");
INSERT INTO bmu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Mamböta tariga Sekemgö iwiŋi Hamor yaŋön keu nup memamgöra Jeikobköreŋ kayök. ");
INSERT INTO bmu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kaba tariga Jeikobkö nahönurupŋan gölme köröŋeyök kaŋgotket. Kaŋgota miaŋgöreŋök yuai asuhuyöhaŋgö kösohotŋi mi kewö mötket: Sekemnöŋ Jeikobkö böratŋi mem böliba Israel könagesö sutŋine silik gamuŋambuk ahök. Silik mi kude ahakŋaŋgö dop ahök. Mi möta uruŋinan kömbuhiiga wösöbirik möta urupik aket. ");
INSERT INTO bmu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Urupik aketmö, Hamornöŋ kewö jii mötket: “Nahöni Sekemgö uruwölbötŋaŋgö sihimŋi mi eŋgö nenböratŋinaŋgöreŋ mösölatiba tatza. Miaŋgöra ölöp jim tekögetka Dainanöŋ yaŋgö anömŋi akawak. ");
INSERT INTO bmu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ölöp nembuk nenböraturupnini utekutek aka aŋguin anda kaiga malbin. Mewö ölöp qenaqena aka malbin. ");
INSERT INTO bmu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mewö aka ölöp neŋgö sutnine tata malme. Nini gölmenini ki mi qahö aŋgön kölbinmö, iŋini ölöp miaŋgöreŋ laŋ anda kaba sihimŋinaŋgö dop gölme kitipŋi kitipŋi buŋa qem aŋguba miriŋini memba nembuk aŋgumnep-qaŋgumnep aka malbin.” ");
INSERT INTO bmu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Mewö jiiga Sekemnöŋ Dainagö iwinenurupŋi yeŋgöra kewö jiyök: “Nöŋön eŋgö jeŋine ak-kömukömu miwikŋaimamgö möta qesim eŋgizal. Miaŋgöra i me waigö qesim niŋgimei, nöŋön mi ölöp eŋgimam. ");
INSERT INTO bmu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ambi bohonŋi aka kalem memba kaba eŋgimami, miaŋgö qötöŋi mi ölöp sihimŋinaŋgö dop memba öŋgöme. I me waigö qesim niŋgimei, nöŋön mi ölöp eŋgimam. Keuni kötŋi ki: Eŋön mönö jim teköba nenböratŋini niŋgigetka nöŋgö anömna akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sekemnöŋ nenŋini Daina mem böliyöhaŋgöra aka Jeikobkö nahönurupŋi yeŋön isimkakalek qakŋe Sekem aka iwiŋi Hamor meleŋ etkiba ");
INSERT INTO bmu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","keu kewö jigetka mötket: “Azi kungö sileŋe Anutugö aiwesökŋi qahö yandigeri, nini nenböratnini azi mewöŋi ölöp qahö waŋgibin. Mewö ahinga gamumamusumnöŋ qaknine öŋgöbapuk. Miaŋgöra nini i waŋgibingö osizin. ");
INSERT INTO bmu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Iŋini silik mohok-kun kewö aketka neŋön urumohot akin: Mutuk Anutugö aiwesökŋi mi aziurupŋini pakpak eŋgö sileŋine yandiget teköiga nini maljin ewö akŋe ewö, mönö nenböratnini ölöp eŋgibin. ");
INSERT INTO bmu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mewö aketka ölöp embuk nenböraturupnini utekutek aka aŋguin anda kaiga malbin. Mewö ölöp eŋgö sutŋine tata könagesö kambu mohok aka malbin. ");
INSERT INTO bmu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mewö malbinmö, Anutugö aiwesökŋi sileŋine yandibingö urumohot qahö akŋe ewö, nini mönö nenböratnini waŋgita kungen anbin.” ");
INSERT INTO bmu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Keu mewö jigetka Hamor aka nahönŋi Sekem yetkön keu mewöŋi miaŋgöra mörohotka dop kölök. ");
INSERT INTO bmu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mewö mörohotka azi gwabö Sekemnöŋ iwiŋaŋgö saiwaurupŋi yeŋgö sutŋine tosatŋi eŋgoŋgita qetbuŋa ketaŋi memba malök. Yaŋgö urusihimŋan Jeikobkö böratŋaŋgöra gwötpuk ahöyöhaŋgöra aka keu jigeri, mi wuataŋgömamgö eksekpeksek qahö aka nalö qahö qem körii öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Mewö aiga Hamor aka nahönŋi Sekem yetkön Sekem taongö azi alaurupŋi yembuk keu jibingöra taongö naŋgu kösutŋe totoko sombemŋine anda kewö jiyohot: ");
INSERT INTO bmu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Azi kieŋön nembuk ala ölöpŋi ak aŋgumakze. Miaŋgöra nini ölöp jim teköinga yeŋön neŋgö gölmenöŋ tata laŋ anda kaba miriŋini memba nembuk aŋgumnep-qaŋgumnep aka malbin. Yeŋön gölme kitipŋi memegöra tiŋi gwötpuk ahöza. Nini ölöp yembuk nenböraturupnini utekutek aka aŋguin anda kaiga malbin. ");
INSERT INTO bmu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nini silik mohok-kun kewö ahinga azi mieŋön nembuk malbingö urumohot akŋe: Anutugö aiwesökŋi mi azi mieŋgö sileŋine yandiget ahözawi, miaŋgö dop mi mutuk körek neŋgö silenine mewöyök yandiin teköiga nini ölöp yembuk könagesö kambu mohot aka malbin. ");
INSERT INTO bmu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","“Mewö ahinga yeŋgöreŋ mirigö sömbup kambuŋini aka sukinap yuaiŋini pakpak mi mönö nanini buŋaya akŋe. Miaŋgöra keu jigeri, mi ölöp möta imbi kölinga yeŋön neŋgö sutnine tatat dundumŋini miwikŋaiba malme.” ");
INSERT INTO bmu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Mewö jiyohotka taongö kiripo naŋguŋe kaba tokogeri, yeŋön körek Hamor aka nahönŋi Sekem yetkö keugöra urumohot aka jigetka Anutugö aiwesökŋi mi Sekem taongö azi pakpak yeŋgö sileŋine yandim teköget. ");
INSERT INTO bmu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Yandim tekögetka wehön 3:ŋi aiga miaŋgöreŋ uziŋinaŋgö sihimbölöŋi mi tok toroqeba möta tatketka Jeikobkö nahönŋi yahöt Simeon aka Liwai, Dainagö nenyahötŋi yetkön bimgö souŋiri ketaŋi memba taon miaŋgöreŋ saŋgabaŋga anda tihitŋini qahö möta tatketka wölaŋ bim qeba azi pakpak qaurapaŋ eŋguyohotka kömum teköget. ");
INSERT INTO bmu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor aka nahönŋi Sekem mi mewöŋanök bimgö sou ketaŋan etkuyohotka kömuyohot. Kömuyohotka Sekemgö mireyök nenŋiri Daina mi öröba eta waŋgita anohot. ");
INSERT INTO bmu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mewö ahotka Jeikobkö nahönurupŋan Sekemnöŋ nenŋini mem bölim waŋgiyöhaŋgöra aka taonöŋ kiŋkiŋgöba anda azi qamötŋini eŋgeka taongö sukinap yuaiŋi kiom qeba yoŋgorö meget. ");
INSERT INTO bmu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Lama, meme, bulmakau aka doŋki kambuŋi kambuŋi aka öröyuaiŋini pakpak taon uruŋe aka gölme köröŋe ahögeri, mi pakpak kalöpköba mem teköget. ");
INSERT INTO bmu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Sukinap yuaiŋini pakpak otoŋda ambimoröurupŋini körek eŋguaŋgita miriŋine yuaiŋini tosatŋi ahöyöhi, mi mönö kölolohoba kiom qeba yoŋgorö memba tököba anget. ");
INSERT INTO bmu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mewö aketka Jeikobnöŋ Simeon aka Liwai kewö jii mörohot: “Iŋiri mewö ahotka kahasililiŋ ketaŋaŋgö keuŋan mönö nöŋgö qakne öŋgöiga malmam. Gölme kiaŋgö toŋi Keinan könagesö aka Periz könagesö yeŋön mönö kazik möt niŋgiba malme. Nöŋgö könagesöni nini awamdökŋi maljin. Miaŋgöra yeŋön yarö aziurupŋini tokom eŋgiba qetala bim yarö gil niŋgime ewö, yeŋön mönö ölöp qaurapaŋ nuŋguba ni aka könagesöni ayuhum neŋgime.” ");
INSERT INTO bmu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Jeikobnöŋ mewö jii mörohotmö, yetkön keu kewö jiyohot: “Kunöŋ neŋgö nenini köna ketaŋi ambi tandök ak waŋgiyöhi, nini mönö miaŋgö likepŋi meleŋ eŋgiinga dop kölja. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Anutunöŋ Jeikob keu kewö jii mörök: “Gi mönö wahöta Betel mire anda tatat dundumgi miwikŋaiba miaŋgöreŋ Anutugöra jöwöwöl alta kun meman. Datki Isogöra ölöŋ köla anöŋga Anutunöŋ nalö miaŋgöreŋ asuhum gihiyöhi, mönö yaŋgöra alta mi meman.” ");
INSERT INTO bmu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Mewö jii möta Jeikobnöŋ saiwaŋi aka ambazip pakpak yambuk malgeri, i kewö jim kutum eŋgiyök: “Lopioŋ bem yuai tömbuŋi sutŋine ahözei, mi mönö qeköba gilget geiga köl könjörat mem aŋguba sileŋini saŋgoŋda opo malukuŋini uteköme. ");
INSERT INTO bmu_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ni köŋjiliŋ uruŋe mala Anutu köuluköbiga meleŋ niŋgiyök aka denike denike anda kaba malali, yaŋön miaŋgöreŋ nömbuk mala korök. Miaŋgöra iŋini mönö kagetka Betel mire anbin. Nöŋön miaŋgöreŋ Anutugöra jöwöwöl alta kun memam.” ");
INSERT INTO bmu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Mewö jim kutum eŋgiiga böröŋine lopioŋ yuai tömbuŋi pakpak ahögeri aka kezapŋine jeŋjeŋ möndögeri, mi qeköba kölolohoba Jeikob waŋgiget. Waŋgigetka anda in ip kun Sekem mire kinöhi, miaŋgö könaŋe gölmenöŋ esim löm kölök. ");
INSERT INTO bmu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mewö aka wahöta angetka taonŋi taonŋi liliköba tatkeri, Anutunöŋ könagesöŋini mieŋgö uruŋini kuŋguiga waekanjam möta elemŋini eri Jeikob aka nahönurupŋi mi qahö eŋguataŋgöget. ");
INSERT INTO bmu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Mewö anda mala Jeikobnöŋ könagesöŋi pakpak yambuk malgeri, mi eŋguaŋgita Luz mire aŋgotket. Luz qetŋi alaŋi Betel mi Keinan gölmenöŋ ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Miaŋgöreŋ aŋgota Jeikobnöŋ jöwöwöl alta kun meyök. Datŋaŋgöra ölöŋ köla anöhi, nalö miaŋgöreŋ Anutunöŋ gölme miaŋgöreŋ asuhum waŋgiyök. Miaŋgöra Jeikobnöŋ miri gölme miaŋgö qetŋi El-Betel qerök. (El-Betel Betelgö Bemŋi.) ");
INSERT INTO bmu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Betel miaŋgöreŋ malgetka Rebekagö welen ambiŋi Debora yaŋön kömuyök. Kömuiga Betel miri bapŋe qerema ip kungö könaŋe löm kölget. Jiŋgeŋ qeta sahötkeraŋgöra aka qerema ip miaŋgö qetŋi Jiŋgeŋ sahötkö qeremaŋi mewö qetket. ");
INSERT INTO bmu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jeikobnöŋ Mesopotemia (Padan Aram) gölmenöhök liliŋgöba kaiga Anutunöŋ kunbuk asuhum waŋgiba kötuetköm waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kötuetköm waŋgiba kewö jii mörök: “Göhö qetki Jeikob (tilipqilip azi) qerakzemö, mewö toroqeba kude qeta malme. Merak könahiba öŋgöba qetki mi Israel ahöma. “Kembunöŋ mewö jiba qetŋi Israel qerök. (Israel Anutubuk aum-möriyohot.) ");
INSERT INTO bmu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Qetŋi mewö qeta toroqeba Jeikob kewö jii mörök: “Nöŋön Anutu kukösum pakpakö Toŋi akzal. Gi ölöp ahumsehip aknöŋga gwölönarökurupki yeŋgö qötöŋinan mönö qarim öŋgöma. Göhöreŋök könagesö gwötpuk aka könagesö kambuŋi kambuŋi asuhume. Gi kiŋi kiŋi yeŋgö bömön jalöŋina akŋan. ");
INSERT INTO bmu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nöŋön gölme Abraham aka Aisak buŋa qem etkiali, mi mönö göhö buŋaya qemam aka göhö andöge gwölönarökurupki yeŋgö buŋaya mewöyök akŋapköra mi qemam.” ");
INSERT INTO bmu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Anutunöŋ keu mewö jii möriga Jeikob mosöta miri miaŋgöreŋök öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Anutunöŋ keuŋi jii möröhi, Jeikobnöŋ gölme miaŋgöreŋ mötök köt kun memba wahöta kuŋguba mi wain o nalukŋan miriba miaŋgö qakŋe oil ipkö kelökŋi mokoi geyök. ");
INSERT INTO bmu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Anutunöŋ yambuk keu jiyöhi, Jeikobnöŋ miri gölme miaŋgö qetŋi Betel (Anutugö miriŋi) qerök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Miaŋgö andöŋe Jeikobnöŋ saiwaurupŋi eŋguaŋgita Betel miri mosöta anda mala Efrata miri dopdowigetka Reizölgö morö meme nalöŋan kam kuŋguiga masö keta bölökŋi qeyök. ");
INSERT INTO bmu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Masö qönsihimŋambuk ketaŋan qeyöhi, nalö miaŋgöreŋ anjö meme ambinöŋ keu kewö jii mörök: “O Reizöl, keŋgötki kude mötnöŋ. Gi mönö nalö kewöŋe mewöyök morö azia kun kunbuk meman.” ");
INSERT INTO bmu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mewö jiiga morö memba kömumamgö aka timotŋi mem kuŋgui ahöba qetŋi miaŋgöra Benoni qerök. (Benoni sihimbölönaŋgö nahöni) Mewö qerökmö, iwiŋan qetŋi Benjamin qerök. (Benjamin Simbawoŋ nahöni) ");
INSERT INTO bmu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Reizölnöŋ mewö kömuiga Efrata köna töwokŋe Betlehem miaŋgöreŋ löm kölget. ");
INSERT INTO bmu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Löm kölgetka Jeikobnöŋ mötök köt kun memba Reizölgö qaksirinöŋ kuŋguyök. Reizölgöreŋ mötök köt mi nalö kewöŋe mewöyök toroqeba kinja. ");
INSERT INTO bmu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Mewö asuhuiga Israelnöŋ miri mi mosöta toroqeba anda mala Eder miri köröpŋaŋgö likepŋe aŋgota opo seri koumŋi miaŋgöreŋ möröreŋgöba kuŋguyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Jeikobkö saiwaurupŋi yeŋön gölme miaŋgöreŋ tata mala nahönŋi mutukŋi Ruben yaŋön iwiŋaŋgö anömŋi bohonŋi qahö memeŋi Bilha yaŋgöreŋ anda mohotŋe ahöyohotka iwiŋi Israelnöŋ miaŋgö buzupŋi mörök. ");
INSERT INTO bmu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jeikobkö nahönurupŋi 12 mi kewö: Leagö nahönurupŋi Ruben mi Jeikobkö nahönŋi mutukŋi. Yaŋgö andöŋe Simeon, Liwai, Juda, Isakar aka Sebulun. ");
INSERT INTO bmu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Reizölgö nahönyahötŋi qetŋiri Josef aka Benjamin. ");
INSERT INTO bmu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilha Reizölgö welen ambigö nahönyahötŋi mi Dan aka Naftali. ");
INSERT INTO bmu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zilpa Leagö welen ambigö nahönyahötŋi mi Gad aka Aser. Jeikobkö nahönurupŋi mewö mi Mesopotemia (Padan Aram) gölmenöŋ asuhuget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jeikobnöŋ anda mala Kiriat Arba (qetŋi alaŋi Hebron) miaŋgö kösutŋe Mamre mire iwiŋi Aisaköreŋ aŋgorök. Asaŋi Abraham aka iwiŋi Aisak yetkön mutuk gölme miaŋgöreŋ kian aka malohot. ");
INSERT INTO bmu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Iwiŋi Aisakö malmal nalöŋi mi yambu 180 aiga kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Azi namŋi aiga yambuŋan öliiga nöŋ qeba kömumba ambösakonurupŋi yeŋgöreŋ toroqeyök. Nahönyahötŋi Iso (Esau) aka Jeikob yetkön qamötŋi mi löm kölohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso qetŋi alaŋi Edom yaŋgö gwölönarökurupŋi yeŋgö qet areŋini kewö: ");
INSERT INTO bmu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isonöŋ Keinan ambi karöbut eŋgimeyöhi, mieŋgö qetŋini kewö: Ada mi Hit azi Elon yaŋgö böratŋa, Oholibama mi Hiwi azi Zibeongö nahönŋi Ana yaŋgö böratŋa. ");
INSERT INTO bmu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basemat mi Ismaelgö böratŋi Nebaiotkö nenŋi. ");
INSERT INTO bmu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adanöŋ Isogö nahönŋi Elifaz meiga Basematnöŋ yaŋgö nahönŋi Reuel meyök. ");
INSERT INTO bmu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamanöŋ Jeus, Jalam aka Kora eŋgömeyök. Isogö nahönurupŋi mewö mi Keinan gölmenöŋ asuhuget. ");
INSERT INTO bmu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Jeikob aka Iso yetköreŋ mirigö sömbup kambuŋi kambuŋi gwötpuk ahögeraŋgöra gölme kiana malohori, miaŋön qahö dop kölök. Sukinapŋiran keta bölökŋi aiga mohotŋe tata malbingö osiget. (6) Miaŋgöra Isonöŋ anömurupŋi, nahönböraturupŋi aka könagesöurupŋi pakpak yaŋgö mire malgeri, mi eŋguaŋgirök. Mi eŋguaŋgita lama bulmakau kambuŋi kambuŋi, doŋki kamelurupŋi aka sukinap yuaiŋi pakpak Keinan gölmenöŋ mala miwikŋaiyöhi, mi memba munŋi Jeikob mosöta gölme kunöŋ anök. ");
INSERT INTO bmu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Iso qetŋi alaŋi Edom yaŋön mewö aka Seir gölme kunduŋambuk miaŋgöreŋ anda malget. ");
INSERT INTO bmu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isonöŋ Seir gölme kunduŋambuk miaŋgöreŋ mala Edom könagesö yeŋgö bömön jalöŋini ahöhi, yaŋgö gwölönarökurupŋi yeŋgö qet areŋini kewö: ");
INSERT INTO bmu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Isogö nahönurupŋi yeŋgö qetŋini kewö: Anömŋi Ada yaŋgö nahönŋi qetŋi Elifaz. Anömŋi Basemat yaŋgö nahönŋi qetŋi Reuel. ");
INSERT INTO bmu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazkö nahönurupŋi 5 mi Teman, Omar, Zefo, Gatam aka Kenaz. ");
INSERT INTO bmu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Isogö nahönŋi Elifaz yaŋgö anömŋi bohonŋi qahö memeŋi qetŋi Timna yaŋön Elifazkö nahönŋi Amalek meyök. Isogö anömŋi Ada yaŋgö isi aziurupŋi mi mewö. ");
INSERT INTO bmu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuelgö nahönurupŋi 4 mi Nahat, Zera, Sama aka Miza. Isogö anömŋi Basematkö isi aziurupŋi mi mewö. ");
INSERT INTO bmu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isogö anömŋi Oholibama yaŋön Isogö nahönurupŋi karöbut eŋgömeiga qetŋini Jeus, Jalam aka Kora qetket. Oholibama mi Zibeongö nahönŋi Ana yaŋgö böratŋi ahök. ");
INSERT INTO bmu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Isogö gwölönarökurup kambuŋi kambuŋi yeŋgö azi kembuŋini mi kewö: Isogö nahönŋi mutukŋi Elifaz yaŋgö nahönurupŋi mi azi kembu qetŋini Teman, Omar, Zefo, Kenaz, ");
INSERT INTO bmu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam aka Amalek. Elifazkö gwölönarökurupŋi azi kembu Edom gölmenöŋ asuhugeri, mi mewö. Mi Isogö anömŋi Ada yaŋgö isiurupŋi aket. ");
INSERT INTO bmu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isogö nahönŋi Reuel yaŋgö nahönurupŋi mi azi kembu qetŋini kewö: Nahat, Zera, Sama aka Miza. Reuelgö gwölönarökurupŋi azi kembu Edom gölmenöŋ asuhugeri, mi mewö. Mi Isogö anömŋi Basemat yaŋgö isiurupŋi aket. ");
INSERT INTO bmu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Isogö anömŋi Oholibama yaŋgö nahönurupŋi mi azi kembu qetŋini kewö: Jeus, Jalam aka Kora. Azi kembu mi Isogö anömŋi Oholibama, Anagö böratŋi yaŋgö nahönurupŋi aket. ");
INSERT INTO bmu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Iso (Esau) qetŋi alaŋi Edom yaŋgö nahönurupŋi mewö aka yeŋgö könagesöurup mieŋgö azi kembuŋini mi mewö. ");
INSERT INTO bmu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hor könagesögö azi Seir yaŋgö nahönurupŋi mutuk Edom gölmenöŋ malgeri, yeŋgö qetŋini kewö: Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO bmu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Ezer aka Disan. Seirgö nahönurupŋi mi mutuk Edom gölmenöŋ Hor könagesö yeŋgö azi kembuŋina malgetka Isonöŋ könaŋgep kayök. ");
INSERT INTO bmu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotangö nahönyahötŋi yahöt mi qetŋiri Hori aka Heman. Lotangö nenŋi qetŋi Timna. ");
INSERT INTO bmu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobalgö nahönurupŋi qetŋini kewö: Alwan, Manahat, Ebal, Sefo aka Onam. ");
INSERT INTO bmu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon yaŋgö nahönyahötŋi yahöt qetŋiri Aia aka Ana. Anagö kösohotŋi kewö: Yaŋön iwiŋi Zibeongö doŋkiŋi gölme qararaŋkölkölŋe galöm köl eŋgii nene jaruba negetka miaŋgöreŋ o jeŋi jeŋi könöpŋinambuk miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anagö nahönböratyahötŋi yahöt mi nahönŋi Dison aka böratŋi Oholibama. ");
INSERT INTO bmu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disongö nahönurupŋi qetŋini kewö: Hemdan, Esban, Itran aka Keran. ");
INSERT INTO bmu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezergö nahönurupŋi qetŋini kewö: Bilhan, Zawan aka Akan. ");
INSERT INTO bmu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disangö nahönyahötŋi yahöt qetŋiri Uz aka Aran. ");
INSERT INTO bmu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hor könagesöŋi könagesöŋi yeŋgö azi kembu-urupŋini yeŋgö qetŋini mi Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO bmu_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Ezer aka Disan. Hor könagesöŋi könagesöŋi yeŋgö azi kembu-urupŋini mi areŋinaŋgö dop Seir gölmenöŋ mewö malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israel könagesö yeŋgöreŋ kiŋ kembu kun qahö galöm köl eŋgiiga qeljiŋe nalö miaŋgöreŋ kiŋ kembu kewöŋan lök Edom gölme miaŋgöreŋ galöm köl eŋgiba malget: ");
INSERT INTO bmu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beorgö nahönŋi Bela yaŋön Edom yeŋgö kiŋ kembuŋini ahök. Yaŋgö sitiŋaŋgö qetŋi Dinhaba. ");
INSERT INTO bmu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Belanöŋ kömuiga Bozra mirigö azi qetŋi Jobab, Zeragö nahönŋi yaŋön Belagö salupŋe kiŋ aka malök. ");
INSERT INTO bmu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobabnöŋ kömuiga Teman gölmegö azi qetŋi Husam yaŋön salupŋe kiŋ aka malök. ");
INSERT INTO bmu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husamnöŋ kömuiga Hadad, Bedadkö nahönŋi yaŋön salupŋe kiŋ aka malök. Hadadnöŋ Moab gölmenöŋ anda Midian azi yembuk yarö gila eŋguba luhut alök. Yaŋgö sitiŋaŋgö qetŋi mi Awit. ");
INSERT INTO bmu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadnöŋ kömuiga Masreka mirigö azi qetŋi Samla yaŋön salupŋe kiŋ aka malök. ");
INSERT INTO bmu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlanöŋ kömuiga Saul yaŋön salupŋe kiŋ aka malök. Yaŋgö miriŋi Rehobot mi Yufreitis o töwatŋaŋgö kösutŋe ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saulnöŋ kömuiga Balhanan, Akborgö nahönŋi yaŋön Saulgö salupŋe kiŋ aka malök. ");
INSERT INTO bmu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akborgö nahönŋi Balhanan kömuiga Hadarnöŋ salupŋe kiŋ aka malök. Yaŋgö sitiŋaŋgö qetŋi mi Pau. Anömŋaŋgö qetŋi Mehetabel. I Matredgö böratŋi aka Mezahabgö isiŋi malök. ");
INSERT INTO bmu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Isogö gwölönarökurupŋi yeŋgö azi kembu qet areŋi mi isikŋinaŋgö dop aka miri gölmeŋinaŋgö dop kewö ahök: Timna, Alwa, Jetet, ");
INSERT INTO bmu_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO bmu_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO bmu_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel aka Iram. Azi mi Edom könagesögö azi kembu-urupŋina malgetka qetŋinaŋgö dop miri gölmeŋinaŋgö qetŋini qetket. Edom qetŋi alaŋi Iso yaŋön mutuk gölme memba tata mala Edom könagesögö bömön jalöŋi ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Aisaknöŋ Keinan gölmenöŋ kian aka maliga nahönŋi Jeikobnöŋ miaŋgöreŋ toroqeba malök. ");
INSERT INTO bmu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jeikobkö gwölönarökurupŋi mieŋgö kösohotŋini kewö: Josefnöŋ azi gwabö yambuŋi 17 aiga darumunurupŋi, iwiŋaŋgö anömyahötŋi bohonŋiri qahö memeŋi Bilha aka Zilpa yetkö nahönurupŋi yembuk lama aka meme (noniŋ) kambuŋi kambuŋi galöm köl eŋgiba malget. Mewö mala darumunurupŋan silik akeri, miaŋgö kösohotŋi bölöŋi bölöŋi mi iwiŋaŋgö jii möta malök. ");
INSERT INTO bmu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jeikobnöŋ azi namŋi aiga nahönŋi Josefnöŋ asuhuyöhi, miaŋgöra iwiŋan i nahönurupŋi tosatŋi pakpak eŋgoŋgita uruŋan jöpaköm waŋgiba malök. Nalö kunöŋ maluku köröpŋi ekjeritŋambuk böröŋi köröpŋi mi memba Josef waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Iwiŋan i darumunurupŋi pakpak eŋgoŋgita uruŋan jöpaköm waŋgiba malöhi, yaŋgö darumunurupŋan mi eka könahiba kazik ak waŋgiba yambuk ala-alagö keuŋi kun qahö eraum-möta malget. ");
INSERT INTO bmu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Suŋgem kunöŋ Josefnöŋ gaun kun eka miaŋgö kösohotŋi mi darumunurupŋi jiiga mötket. Mi mötketka uruŋinan öngöiga kazik gwötpuk ak waŋgiba malget. ");
INSERT INTO bmu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kösohotŋi mi kewö jiiga mötket: “Mötket, ni gaun kun ekzali, mi kewö: ");
INSERT INTO bmu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nini nupnöŋ mala wit padi böranini jöhöbingö tandök akzin. Mewö ahinga nöŋgöreŋ wit padi börani miaŋön wahöta köŋgep kiniga eŋgöreŋ böran mieŋön mönö nöŋgöreŋ böran liliköba sököba kinje.” ");
INSERT INTO bmu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Mewö jiiga möta darumunurupŋan Josefköra kewö jiget: “Gi neŋgöreŋ kiŋ kembuya akanak me? Gi ölŋa galöm köl neŋgimamgöra mötzan me?” Josefnöŋ gaunŋi eka miaŋgö kösohotŋi jiyöhi, miaŋgöra yeŋgö uruŋinan kunbuk toroqeba öngöiga kazik keta bölökŋi möt waŋgiba malget. ");
INSERT INTO bmu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Miaŋgö andöŋe gaun kun kunbuk eka miaŋgö kösohotŋi darumunurupŋi kewö jiiga mötket: “Nöŋön gaun kun ekiga miaŋgöreŋ wehön, köiŋ aka seŋgelau 11 mieŋön nöŋgöra sipköget.” ");
INSERT INTO bmu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kösohotŋi mi iwiŋi aka darumunurupŋi jii mötketka iwiŋan tembula kewö jim waŋgiyök: “Gi gaun tandökŋi mewöŋi mi denöwögöra ekzane? Ni, namgi aka darumunurupki neŋön mönö denöwö aka göhöreŋ kaba jemesoholge simin köla gölmenöŋ bamgöbinak?” ");
INSERT INTO bmu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Mewö asuhuiga darumunurupŋan uruŋinan mututqutut (jelös) möt waŋgiba malgetmö, iwiŋan keu mi uru könömŋe ali ahöiga mötmöriba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nalö kunöŋ Josefkö darumunurupŋi yeŋön iwiŋinaŋgöreŋ lama kambu-urupŋi galöm köl eŋgibingöra Sekem miri kösutŋe anda malget. ");
INSERT INTO bmu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Miaŋgöreŋ malgetka Israelnöŋ Josef kewö jii mörök: “Nahöni, göhö darumunurupkan Sekem kösutŋe lama kambunini galöm köl eŋgiba maljei, mi mötzan. Ölöp kanöŋga melaim gihibi yeŋgöreŋ anman. “Mewö jiiga möta “Ölöp anmam,” jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Jiiga kewö jii mörök: “Gi mönö anda darumunurupki aka lama kambunini eŋgeka denöwö maljei, miaŋgö keu kösohotŋi mi memba liliŋgöba kaba jinöŋga mötmam. “Mewö jii möri Hebron örueŋeyök (ruerueŋeyök) melaim waŋgiiga anda mala Sekem gölmenöŋ aŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sekem gölmenöŋ aŋgota gölme köröŋe köna jaruba laŋ anda maliga azi kunŋan miwikŋaiba eka kewö qesim waŋgiyök: “Gi wani yuaia jaruba maljan?” ");
INSERT INTO bmu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Qesim waŋgiiga kewö meleŋnök: “Ni darumunurupni yeŋgöra jaruzal. Yeŋön denikeaŋgöreŋ mala lamaurupŋini galöm köl eŋgizei, mi ölöp jinöŋga mötmam.” ");
INSERT INTO bmu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mewö meleŋniga kewö jiyök: “Yeŋön lök gölme ki mosöta anget. Dotan mire anbingöra jigetka möral. “Mewö jiiga möta darumunurupŋi yeŋgö könaŋine eŋguataŋgöba mala Dotan miri kösutŋe anda miwikŋaim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Miwikŋaim eŋgiba kösutŋine qahö aŋgorökmö, tikep endu kaiga darumunŋan i eka tokoba Josef qebingö aŋgönaŋ alget. ");
INSERT INTO bmu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Aŋgönaŋ ala nanŋinök kewö eraum-mötket: “Eket, gaun ehek azi miaŋön mönö endu kaza. ");
INSERT INTO bmu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ayop, mönö kagetka anda qein kömuiga qamötŋi o lömŋi kunöŋ gilin geiga kewö jibin: ‘Sömbup kalŋan mönö i qei kömuyök.’ Gaunŋaŋgö ölŋan denöwö asuhumawi, mi mönö miaŋgö andöŋe ekin.” ");
INSERT INTO bmu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mewö eraum-mötketka Rubenöŋ mi möta Josef böröŋineyök meköba malmalŋi jöhömamgöra möta kewö jiyök: “I mönö kude qeinga kömuma.” ");
INSERT INTO bmu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Toroqeba kewö jii mötket: “Sepŋi mönö kude mokome. Gölme qararaŋkölkölŋe o löm ki kinjawi, i ölöp miaŋgöreŋ gilgetka gemapmö, böröŋinan mönö yaŋgö sileŋe kude misiriba qeme. “Rubenöŋ Josef böröŋineyök meköba aŋgön köla waŋgita iwiŋaŋgöreŋ liliŋgöba anbitköra möta keu mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Mewö jii möta kingetka Josefnöŋ darumunurupŋi yeŋgöreŋ kaŋgorök. Kaŋgoriga malukuŋi köröpŋi ekjeritŋambuk böröŋi köröpŋi wöta kayöhi, mi laŋ öröba munjurata qeköget. ");
INSERT INTO bmu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Mi qeköba munŋini qeraköba memba anda o lömnöŋ gilgetka geyök. O löm mi oŋi qahöpmö, gwamönŋa kinök. ");
INSERT INTO bmu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mewö aka nene nembingö eta tatket. Eta tata jeŋini uget aniga Ismael könagesögö kölköl-örörö azi tosatŋan Gilead miri mosöta kamelŋini totnöŋ totnöŋ al eŋgiba awataŋ kagetka eŋgeket. Yeŋön kamel qakŋine gipmi bakötök, sile mirimirigö kelökŋi aka marasin ip tokuŋi qetŋi mör gipit mi algetka bisiba Ijipt kantrinöŋ anbingöra kaget. ");
INSERT INTO bmu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Mewö eŋgeka Judanöŋ darumunurupŋi kewö jii mötket: “Nini munini qein kömuiga sepŋaŋgö keuŋi köyatiba asambötpin ewö, miaŋön mönö denöwö bauköm neŋgibawak? ");
INSERT INTO bmu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Yaŋön nanini munini aka nanini sepkitipnini akzawaŋgöra mönö böröninan sileŋe kude misiriba qebinmö, ölöp kagetka anda Ismael azi mieŋön i söŋgöröŋi memegöra eŋgibin. “Mewö jiiga darumunurupŋan mi möta urumohot aka imbi kölget. ");
INSERT INTO bmu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mewö aketka Midian gölmegö Ismael könagesögö kölköl-örörö azi mieŋön kaba kaŋgota eŋgoŋgitpingö aket. Mewö aketka munŋini Josef mi o lömnöhök öröget koriga silwö kötŋi 20:nöŋ söŋgöröŋi memegöra al waŋgiget. Al waŋgigetka Ismael azi mieŋön i bohonŋi memba waŋgita Ijipt kantrinöŋ anget. ");
INSERT INTO bmu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Angetka Rubenöŋ kungenök liliŋgöba o lömnöŋ kaiga Josefnöŋ miaŋgöreŋ kunbuk qahö kiniga eka wösöŋi juliga wösöbirikŋi kondela malukuŋi munjurarök. ");
INSERT INTO bmu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Malukuŋi munjurata munurupŋi yeŋgöreŋ liliŋgöba kaba kewö jiyök: “Morö gwabönöŋ mönö denike ayapköba sohoza? Yei! Miaŋgö keuŋan nöŋgö qakne öŋgöiga mönö denöwö akileŋak?” ");
INSERT INTO bmu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mewö jiiga meme (noniŋ) aziŋi kun memba qeget kömuiga Josefköreŋ malukuŋi memba meme miaŋgö sepŋan kundumgöba membiliget. ");
INSERT INTO bmu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Membiliba malukuŋi köröpŋi ekjeritŋambuk böröŋi köröpŋi mi memba mire anda iwiŋi kondela kewö jiget: “Nini ki miwikŋaizin. Mi nahöngi Josefköreŋa me qahö, mi ölöp ek kewötman.” ");
INSERT INTO bmu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Mewö jigetka ek kewöta kewö jiyök: “Ki mi nahönaŋgöreŋ malukuya. Sömbup kalŋi kunŋan mönö yaijapaleleŋ qei kömuiga gwahörök. Ölŋa, Josef mi yöhöqöhötiiga boromborom ahök.” ");
INSERT INTO bmu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Mewö jiba amburereŋ aka wösöbirikŋi kondela malukuŋi munjurata sileŋi gölmenöŋ membiliba nahönŋaŋgö nalö köröpŋi jiŋgeŋ köla sahöta malök. ");
INSERT INTO bmu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Mewö maliga nahönböraturupŋi pakpak yeŋön kaba urukölalep mem waŋgibingö aketmö, yaŋön mi qetala tököba urukondumök möta kewö jiyök: “Qahö! Nöŋön mönö jiŋgeŋ köla sahöta mala kömumba uŋem mire nahönaŋgöreŋ gemam. “Mewö jiba Josefköra sahöta malök. ");
INSERT INTO bmu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mewö maliga nalö miaŋgöreŋ Midian gölmegö kölköl-örörö azi yeŋön Josef waŋgita Ijipt kantrinöŋ aŋgota bohonŋi memegöra algetka Farao kiŋgö jembonŋi kun qetŋi Potifar, kiŋgö malmalŋaŋgö sikiriti yeŋgö suahö galömŋina malöhi, yaŋön i söŋgöröŋi meiga welenqeqeŋi omaŋi ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nalö miaŋgöreŋ Judanöŋ darumunurupŋi eŋgömosöta yagömanŋe Adulam mire geba azi kun qetŋi Hira yambuk tata malök. ");
INSERT INTO bmu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Miaŋgöreŋ mala Judanöŋ Keinan azi kun qetŋi Sua yaŋgö böratŋi eka anömŋa meiga mohotŋe ahöyohot. ");
INSERT INTO bmu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mohotŋe ahöyohotka anömŋan gölöm ala morö nahön memba qetŋi Er qerök. ");
INSERT INTO bmu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mewö qeta kunbuk gölöm ala morö nahön kun memba qetŋi Onan qerök. ");
INSERT INTO bmu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Miaŋgö bapŋe dumŋe kunbuk morö nahön kun memba yaŋgö qetŋi Sela qerök. Morö nahön mi Kezib mire mala miaŋgöreŋ meyök. ");
INSERT INTO bmu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mewö malgetka Judanöŋ nahönŋi mutukŋi Er yaŋgöra ambi kun qetŋi Tamar waŋgiiga anömŋa ahök. ");
INSERT INTO bmu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Anömŋa ahökmö, Judagö nahönŋi mutukŋi Er yaŋön Kembugö jeŋe bölöŋi aka memba malöhi, miaŋgöra Kembunöŋ jim teköm waŋgiiga kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kömuiga Judanöŋ nahönŋi Onangöra kewö jiyök: “Gi ölöp datkahö malöŋi memba qambötŋi akzanaŋgö köna keuŋi wuataŋgöba yambuk ahöba datkahöra gwölönarök qiwikŋaiman.” ");
INSERT INTO bmu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mewö jiyökmö, Onanöŋ gwölönarök mi yaŋgö buŋaya qahö akŋawi, mewö möta silik kewö aka malök: Datŋaŋgöra gwölönarök qiwikŋaibapuköra yaŋgö anöm malöŋambuk ahöba malöhi, nalö miaŋgöreŋ nalö dop morö qiwiqiwikŋaigö sile oŋi mi öne gölmenöŋ qokoba malök. ");
INSERT INTO bmu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Silik mewö aka malöhi, mi Kembugö jeŋe bölöŋi ahök. Miaŋgöra Kembunöŋ i mewöyök jim teköm waŋgiiga kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kömuiga Judanöŋ iranŋi Tamargöra kewö jiyök: “Gi mönö iwigahö mire liliŋgöba anda malöya mala malnöŋga nahöni Selanöŋ qariba ketaŋi akagun gi gömima. “Keŋgötŋi kewö mötmöriba mewö jiyök: Selagö datyahötŋan kömuyohotka yaŋön miaŋgö dop mala mewöyök kömumbapuk. Mewö mötmöriba Tamargöra jiiga iwiŋaŋgö mire liliŋgöba anda miaŋgöreŋ tata malök. ");
INSERT INTO bmu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Miaŋgöreŋ tata maliga nalö köröpŋi teköiga Suagö böratŋi, Judagö anömŋi yaŋön kömuyök. Kömuiga jiŋgeŋ köla sahöta mali teköiga Judanöŋ miri gölme qetŋi Timna miaŋgöreŋ azi tosatŋan nanŋi lamaurupŋi yeŋgö jupŋini mitigeri, i eŋgekŋamgöra öŋgöyök. Adulam mirigö azi alaŋi Hira yambuk mohotŋe miaŋgöreŋ öŋgöyohot. ");
INSERT INTO bmu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Öŋgöyohotka Tamargöra buzup kewö jigetka mörök: “Mötnöŋ, göhö azi irangan mönö lamaurupŋi yeŋgö jupŋini mitimamgöra aka Timna miri gölmenöŋ anja.” ");
INSERT INTO bmu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Mewö jigetka mörök. Judagö nahönŋi Selanöŋ lök qariba ketaŋi aiga töndup i anömŋi akŋapköra qahö waŋgiyök. Miaŋgöra Tamarnöŋ malö malmamgö malukuŋi qeköba nöröp kawöseŋnöŋ nöröp jeŋi esuhuba turum aŋguyök. Mewö aka Timna anangö könanöŋ anda taon qetŋi Enaim miaŋgöreŋ aŋgota kiripo naŋgu kösutŋe tarök. ");
INSERT INTO bmu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Tariga Judanöŋ kaba eka jemesoholŋi esuhuyöhaŋgöra i qahö ek kutuba mi köna ketaŋi ambia mewö mötmöriyök. ");
INSERT INTO bmu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Iranŋa taröhi, mi qahö möt kutuyöhaŋgöra aka köna jitŋe yaŋgöreŋ anda kewö jiyök: “Ölöp kanöŋga nöŋön göbuk ahöbit. “Mewö jiiga möta kewö qesiyök: “Nömbuk ahömanaŋgö töwaŋi mönö wani yuaia niŋgiman?” ");
INSERT INTO bmu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Mewö qesiiga kewö jiyök: “Ni nani kambunöhök meme moröŋi gwaböŋi kun albi göhöreŋ kama. “Mewö jiiga kewö qesiyök: “Mi mutuk qahö kaba kaŋgoriga keugahö ölŋi akŋawaŋgö yuai kun mi niŋgiman me qahö?” ");
INSERT INTO bmu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Mewö qesiiga kewö jiyök: “Nöŋgö keunaŋgö ölŋi akŋawaŋgö yuai kun mi mönö wani yuaia gihibileŋak?” Mewö jiiga kewö meleŋnök: “Köpep supapkan qetki mekötahömakzani, mi, miaŋgö kösö wötŋi aka öröpki börögan memba kinjani, mönö mia niŋgiman. “Mewö meleŋniga yuai mi waŋgiba yambuk ahöiga gölöm alök. ");
INSERT INTO bmu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Yambuk ahöba wahöta miriŋe anda nöröp kawöseŋi luluŋda qeköba malö malmamgö malukuŋi mi kunbuk löŋgöta malök. ");
INSERT INTO bmu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mewö maliga Judanöŋ nalö kunöŋ Adulam mirigö azi alaŋi Hira melaiba kewö jiyök: “Gi mönö meme (noniŋ) moröŋi gwaböŋi memba anda ambi mi waŋginöŋga nöŋgö keunaŋgö ölŋi akŋawaŋgö yuaiŋi mi meleŋ gihiiga memba kaman. “Nup mewö memapköra Hira melaiiga anökmö, Hiranöŋ ambi mi qahö miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Qahö miwikŋaiba Enaim azi tosatŋi kewö qesim eŋgiba jiyök: “Jöwöwöl jikegö köna ketaŋi ambinöŋ Enaim kiaŋgöreŋ köna göraŋe taröhi, mi denike?” Mewö jiiga kewö meleŋda jiget: “Ambi mewöŋi kun mi kiaŋgöreŋ qahö malök.” ");
INSERT INTO bmu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Mewö jigetka Hiranöŋ öne liliŋgöba Judagöreŋ kaba jiyök: “Nöŋön anda ambi mi qahö ehal. Miri miaŋgö toŋi yeŋön mewöyök keu kewö jigetka möral: ‘Jöwöwöl jikegö köna ketaŋi ambiŋi kun mi kiaŋgöreŋ qahö malök.’” ");
INSERT INTO bmu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Mewö jiiga Judanöŋ kewö jiyök: “O alani, muat! Yaŋön yuai mi ölöp memba malma. Yuai kun akirak, mönö gön köl netkigetka gamunöŋ turum netkibapuk. Nöŋön meme moröŋi gwaböŋi ki mi ölöp albiga anökmö, göŋön ambi mi qahö miwikŋainöŋ.” ");
INSERT INTO bmu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mewö jiiga köiŋ karöbutkö dop teköiga tosatŋan Judagöra buzup keu kewö jigetka mörök: “Göhö irangi Tamarnöŋ mönö serowilin aka gölöm ala malja. “Mewö jigetka Judanöŋ mi möta Mosesgö köna keugö dop jimkutukutu kewö alök: “I mönö waŋgita örörahöba könöpnöŋ gilgetka geba jema.” ");
INSERT INTO bmu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","I waŋgita örörahöba angetka iranŋan Judagöra keu kewö aliga anök: “O irani, yuai kieŋgö toŋan mönö nömeiga gölöm ala maljal. Miaŋgöra köpep supap ki, miaŋgö kösö wötŋi aka öröp ki mönö ek kewöta toŋi miwikŋaiman.” ");
INSERT INTO bmu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Keu mewö ali aniga möta nanŋi yuaiŋi mi ek kewöta kewö jiyök: “Yaŋön keu mi ölŋa jiza. Nöŋön i nahöni Selagö anömŋi akŋapköra qahö waŋgial. Miaŋgöra yaŋön mönö ni noŋgita ambi diŋdiŋi aka keu mi jiza. “Mewö jiba ambi miambuk kunbuk qahö ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Könaŋgep morö memamgö nalöŋan kam kuŋguiga morö gösöŋaŋgö uruŋe siwisiwi azi moröŋi yahöt tarohot. ");
INSERT INTO bmu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tarohotka morö memamgö aiga kunöŋ böröŋi suluiga erök. Eriga anjö meme ambinöŋ mi eka möt kösö pisikŋi pötpöt memba böröŋe jöhöba kewö jiyök: “Yaŋön mutuk asuhuza.” ");
INSERT INTO bmu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mewö jiyökmö, morö miaŋön böröŋi kunbuk öröi öŋgöiga alaŋan mutuk asuhuyök. Yaŋön asuhuiga anjö meme ambinöŋ kewö jiyök: “O mönö mewö aka könagi munjurata asuhuzan. “Mewö jiiga qetŋi Perez qetket. (Perez Könaŋi munjuratza.) ");
INSERT INTO bmu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Miaŋgö andöŋe alaŋaŋgö böröŋe möt kösö pisikŋi pötpöt ahöyöhi, yaŋön asuhuiga qetŋi Zera qetket. (Zera pisikŋi pötpöt) Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nalö sutŋe miaŋgöreŋ Ismael könagesögö kölköl-örörö azi yeŋön Josef waŋgita Ijipt kantrinöŋ aŋgota bohonŋi memegöra alget. Algetka Ijipt azi kun qetŋi Potifar, Farao kiŋgö jembonŋi kun aka malmalŋaŋgö sikiriti yeŋgö suahö galömŋina malöhi, yaŋön i söŋgöröŋi meiga welenqeqeŋi omaŋi ahök. ");
INSERT INTO bmu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mewö aka maliga Kembunöŋ Josefpuk kiniga yuai pakpak aka memba malöhi, miaŋgöreŋ mönö töhötmöriam miwikŋaiyök. Yaŋön toŋi Ijipt azi yaŋgö mire malök. ");
INSERT INTO bmu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mewö maliga Kembunöŋ Josefpuk kinda kondot waŋgiiga yuai pakpak böröŋan memba malöhi, miaŋön mönö töhötmöriamŋambuk ahök. Mewö aiga toŋan mi ehök. ");
INSERT INTO bmu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Toŋan mi ehi ölöp dop köliga yaŋgö jeŋe eksihim miwikŋaiiga jiiga nanŋi malmalŋaŋgö galömŋi ahök. Potifarnöŋ Josef kuŋgum waŋgiiga miriŋaŋgö yuai pakpak galöm köliga sukinap buŋaŋi pakpak yaŋgö böröŋe aliga köyan köla malök. ");
INSERT INTO bmu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Miriŋaŋgö yuaiŋi aka sukinap buŋaŋi mi pakpak Josefnöŋ galöm kölmapköra böröŋe ala malöhi, Kembunöŋ nalö miaŋgöreŋök könahiba Ijipt azi miaŋgö miri yuaiŋi mi Josefköra aka kötuetköba malök. Potifargö miriŋe aka nupŋe öröyuaiŋi pakpak ahöyöhi, mi mönö kötumötuet qakŋe ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Mewö ahöiga Potifarnöŋ öröyuaiŋi ahöm waŋgiyöhi, mi pakpak Josefkö böröŋe al teköba kinda nanŋak i me wai miaŋgö waimanjatŋi kun qahö mörök. Yaŋön nene nemamgöra mohot mötkurumkurum aka malök. Josefkö sileŋi öndölböndöl qariiga kaisoŋgolomŋan eksihimŋambuk ahöiga malök. ");
INSERT INTO bmu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mewö maliga nalö tosatŋi teköiga Potifargö anömŋan Josef eka eksihimŋi möta kewö jiyök: “Gi mönö kanöŋga nömbuk ahöbit.” ");
INSERT INTO bmu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mewö jiyökmö, yaŋön mi tököba toŋaŋgö anömŋi kewö jii mörök: “Qahö! Mötnöŋ, toni nanŋak miriŋe öröyuai ahözawaŋgö waimanjatŋi qahö ahakzapmö, sukinap buŋaŋi pakpak mi mönö nöŋön galöm köla malmamgöra nöŋgö böröne al teköiga ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mewö ahöiga miri kiaŋgö uruŋe i aka ni netkö kukösumniran mönö öröröŋ ahöza. Göŋön anömŋi akzanaŋgöra gi aŋgön köl niŋgiyökmö, yuai tosatŋi kun mi nöŋgöra qahö aŋgön kölök. Miaŋgöra nöŋön denöwögöra aka ahakmeme bölöŋi kötökŋi mewöŋi mi aka miaŋön Anutu qetala siŋgisöndok akileŋak?” ");
INSERT INTO bmu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mewö jii möta keu mewöŋi mi wehön dop Josefköra jiba malökmö, yaŋön töndup mi qetala mala yaŋgö ahöahö dumnöŋ anda yambuk ahöbitkö imbi qahö kölök. Mewö yambuk mohotŋe malbitkö mewöyök tököyök. ");
INSERT INTO bmu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mewö tököba maliga wehön kunöŋ mirigö welenqeqeurupŋi yeŋgöreŋök kunŋan miri uruŋe qahö maliga Josefnöŋ nupŋi jijiŋi memamgöra miri uruŋe öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Öŋgöiga ambi miaŋön Josefkö malukuŋe qelanjiba memba kewö jiyök: “Gi mönö kanöŋga nömbuk ahöbit. “Mewö jiyökmö, Josefnöŋ malukuŋi mi yaŋgö böröŋe mosöta ölöŋ köla diŋdiŋgöba sombemnöŋ sileŋe erök. ");
INSERT INTO bmu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Malukuŋi yaŋgö böröŋe mosöta ölöŋ köla sombemnöŋ eröhi, ambi miaŋön mi ehök. ");
INSERT INTO bmu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Mi eka mirigö welenqeqeurupŋi eŋgoholi kagetka yeŋgöra kewö jiyök: “Mötket, apnan Hibru azi mi waŋgita mirinine kayöhi, yaŋön mönö göngönahit ak neŋgiba malja. Yaŋön nömbuk ahöbitköra nöŋgöreŋ kotzapmö, nöŋön qet gigilahözal. ");
INSERT INTO bmu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Qet gigilahöbiga möta malukuŋi nöŋgö wösöne mosöta ölöŋ köla diŋdiŋgöba sileŋe geza.” ");
INSERT INTO bmu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mewö jiba Josefkö malukuŋi kösutŋe ali ahöi Josefkö toŋan liliŋgöba kamapkö mamböta tari kayök. ");
INSERT INTO bmu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kaiga kösohotŋi mewöyöhök jii möriga kewö jiyök: “Hibru welenqeqe azi mi waŋgitnöŋga neŋgöreŋ kayöhi, yaŋön mönö nömbuk göngönahit akŋamgöra nöŋgöreŋ kotza. ");
INSERT INTO bmu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kotzapmö, nöŋön qet gigilahöbiga möta malukuŋi nöŋgö wösöne mosöta ölöŋ köla diŋdiŋgöba sileŋe geza.” ");
INSERT INTO bmu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mewö jiiga Josefkö toŋan anömŋan kösohot mewö jii möriga kewö jiyök: “Göhö welenqeqegan mönö mewö ak niŋgiza. “Mewö jii möta irimŋi seholiiga uruŋi könöp jeyök. ");
INSERT INTO bmu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Uruŋi könöp jeiga jiiga Josef memba Farao kiŋgö kösö mirinöŋ azi galöm köl eŋgiba malgeri, mönö kösö miri miaŋgöreŋ alget geba ahöba malök. ");
INSERT INTO bmu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Josefnöŋ kösö miri miaŋgöreŋ malökmö, Kembunöŋ Josefpuk kinda kötuetköba ak kömum waŋgiba mali kösö mirigö galöm bohonŋan mi eka yaŋgöra eksihim mörök. ");
INSERT INTO bmu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Eksihim möröhaŋgöra azi pakpak kösö mire tatkeri, mi Josefnöŋ galöm köl eŋgimapköra yaŋgö böröŋe al eŋgiyök. Yuai pakpak miaŋgöreŋ aka memba malgeri, mi Josefnöŋ jim kutum eŋgiyöhaŋgö dop aka memba malget. ");
INSERT INTO bmu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kembunöŋ Josefpuk kinda kötuetköm waŋgiba kondoriga yuai pakpak aka memba malöhi, mi töhötmöriamŋambuk asuhuba ahöyök. Miaŋgöra kösö mirigö galöm bohonŋan Josefnöŋ yuai pakpak denöwö galöm köla jim kutum eŋgiba malöhi, miaŋgö waimanjatŋi kun qahöpmahöp möta malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Nalö tosatŋi teköiga Ijiptkö kiŋ kembuŋaŋgö wain o qambigö galömŋi aka bered ohohogö galömŋi yetkön ketaŋamŋiri Ijiptkö kiŋi qetala köna siŋgiyohot. ");
INSERT INTO bmu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mewö ahotka Farao kiŋnöŋ jembonŋi yahöt, wain o qambigö galömŋi bohonŋi aka bered ohohogö galömŋi bohonŋi yetköra aka irimŋi seholiyök. ");
INSERT INTO bmu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Irimŋi seholiiga jiiga etkuaŋgita kiŋgö malmalŋaŋgö sikiriti yeŋgö suahö galömŋinaŋgö kösö mire yaŋgö böröŋe al etkigetka geyohot. Josefnöŋ kösö miri miaŋgöreŋök malök. ");
INSERT INTO bmu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sikiriti yeŋgö suahö galömŋinan Josef jim kutum waŋgiiga i welen qem etkiba malök. Mewö maliga nalö tosatŋi toroqeba kösö mire malget. ");
INSERT INTO bmu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Mewö mala malgetka Ijipt kiŋgö wain o qambigö galömŋi aka bered ohohogö galömŋi yetkön suŋgem mohot miaŋgöreŋök gaunŋiri inanŋök inanŋök ehot. Gaunŋiraŋgö könaŋi mi inanŋök inanŋök. ");
INSERT INTO bmu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mi ehotka Josefnöŋ söŋanöhök yetköreŋ öŋgöba etkehi urueret aka bosoliba tarohot. ");
INSERT INTO bmu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Mewö tarohotka Farao kiŋgö jembon yahötŋi yetkön Josefkö ketaŋamŋaŋgö kösö mire yambuk mohotŋe tarohori, i kewö qesim etkiyök: “Iŋiri merak denöwögöra jemesoholŋiri wösöbirikjeje uba tatzahot?” ");
INSERT INTO bmu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Qesim etkiiga kewö meleŋda jiyohot: “Niri nanŋök nanŋök gauniri ekzitmö, mietkö könaŋiri mi daŋön jii mötpirak?” Mewö jiyohotka Josefnöŋ kewö jiyök: “Anutunöŋ mönö gaungö könaŋini jiji Toŋi akzapmö, ölöp töndup gaunŋiri jiyohotka mötmam.” ");
INSERT INTO bmu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mewö jiiga wain o qambigö galöm bohonŋan gaunŋi ehöhi, miaŋgö kösohotŋi mi Josef kewö jii mörök: “Nöŋön gauni uruŋe wain ip kun mi nöŋgö wösöne kiniga ekzal. ");
INSERT INTO bmu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Wain ipkö böröŋi karöbut kingetka könahiba sötŋi jula kota kuŋguzawi, nalö miaŋgöreŋök juraŋi kota tuliga kaŋgeŋi kaŋgeŋi asuhuba öligetka ölŋaŋgö kötŋi pisihize. ");
INSERT INTO bmu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pisihigetka ni Farao kiŋgö qambiŋi mi börönan memba kinda ölŋaŋgö kötŋi memba mözöhölbiga oŋi Farao kiŋgö qambinöŋ geiga kiŋgö böröŋe aljal.” ");
INSERT INTO bmu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Mewö jii möta Josefnöŋ kewö jii mörök: “Gaungahö könaŋi mi kewö: Ip böröŋi karöbut mi wehön karöbutkö söpsöpŋi akza. ");
INSERT INTO bmu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Wehön karöbut teköiga Farao kiŋnöŋ göhö nöröpki mem wahöta pösat gihiba kunbuk nupke al gihima. Gi mutuk yaŋgö wain o qambigö galömŋa mala qambi Farao kiŋgö böröŋe ala malnöŋi, miaŋgö dop mönö kunbuk aka malman. ");
INSERT INTO bmu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mewö malmanmö, sösöŋgai qakŋe malmani, nalö miaŋgöreŋ mönö ni mötmöriba ak kömum niŋgiba nöŋgö kösohotni Farao kiŋgöra jinöŋga mötma. Mewö aka bauköm niŋginöŋga kösö miri ki mosöta etpileŋak. ");
INSERT INTO bmu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mötnöŋ, ni Hibru könagesögö gölmenöhök ösum-mumu qakŋe yoŋgorö noaŋgitketka kaba kiaŋgöreŋ mewöyök yuai bölöŋi kun kösö miri kiaŋgö dutŋe al niŋgigeraŋgö dop mi qahö ahal.” ");
INSERT INTO bmu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Josefnöŋ mewö jii möriga bered ohohogö galöm bohonŋan alaŋaŋgö gaunŋaŋgö könaŋi ölöpŋi jim asariyöhi, mi eka kewö jii mörök: “Nöŋön mewöyök gauni ekiga miaŋgöreŋ bered könde karöbut nöŋgö nöröpne kunduta kazal. ");
INSERT INTO bmu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kaba könde qakŋe eu tatzawi, miaŋgöreŋ bered yuai nahömŋinambuk könaŋi könaŋi Farao kiŋgöra ahözapmö, neiŋi neiŋi yeŋön kaŋgota könde kunduta kazali, miaŋgöreŋök mi nem teköze.” ");
INSERT INTO bmu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Mewö jii möta Josefnöŋ kewö meleŋda jiyök: “Gaungahö könaŋi mi kewö: Könde karöbut mi wehön karöbutkö söpsöpŋi akza. ");
INSERT INTO bmu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Wehön karöbut teköiga Farao kiŋnöŋ jiiga liŋgipnöŋ geriba qetohom gihiba nöröpki aka qamötki mem wahöta ipnöŋ möndögetka neiŋi neiŋi yeŋön kaŋgota busugi nem teköme.” ");
INSERT INTO bmu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Mewö meleŋda jiiga wehön karöbut teköiga Farao kiŋgö ahuahu nalöŋan kam kuŋguiga jembonurupŋi pakpak i nene lömbuaŋ ohoba eŋgiyök. Mi ohoba eŋgiba wain o qambigö galöm bohonŋi aka bered ohohogö galöm bohonŋi yetkö nöröpŋiri mi jembonurupŋi yeŋgö jeŋine memba wahörök. ");
INSERT INTO bmu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Wain o qambigö galömŋan mutuk nupŋi memba malöhi, mi toroqeba memapköra kuŋgum waŋgiiga dumŋe kunbuk qambi mi Farao kiŋgö böröŋe ala malök. ");
INSERT INTO bmu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mewö malökmö, kiŋnöŋ bered ohohogö galöm bohonŋaŋgö keuŋi jim teköiga Josefnöŋ gaunŋiraŋgö könaŋi jii mörohoraŋgö dop i liŋgipnöŋ eriba qetohoba nöröpŋi aka qamötki mi mem wahöta möndöget. ");
INSERT INTO bmu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Miaŋgö andöŋe wain o qambigö galöm bohonŋan Josef qahö mötmörim waŋgiyökmö, i ölum qeiga laŋ malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Yambu yahöt teköiga Farao kiŋnöŋ gaun kun kewö ehök: Yaŋön Nail o töwatŋaŋgö göraŋe kiniga ");
INSERT INTO bmu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","bulmakau dömŋi 7 ölöp sorokŋi kelök busuŋinambuk mi o töwatŋi miaŋgöreŋök kota jejepözaŋ sutŋine kinda tembam keuqaŋ neget. ");
INSERT INTO bmu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mieŋgö andöŋine bulmakau tosatŋi 7 sihitqarambuŋinanök kaisoŋgolomŋini piromŋi mi o töwatŋi miaŋgöreŋök kota bulmakau mutukŋi mieŋgö kösutŋine anda o töwatŋaŋgö göraŋe kinget. ");
INSERT INTO bmu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bulmakau piromŋi sihitqarambuŋinanök mieŋön bulmakau dömŋi ölöp sorokŋi kelök busuŋinambuk 7 mi gwahöt eŋgiget. Farao kiŋnöŋ gaun mi eka miaŋgöreŋök imbiŋi möta wahörök. ");
INSERT INTO bmu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Wahöta gaunŋaŋgö kunbuk möta gem anda ahöba gaun kun kewö ehök: Wit padi ip mohotkö kembaŋe ölŋi kötŋi ketaŋi ketaŋi kaŋgeŋinambuk 7 ölöp kötökŋi mi loŋkam gili eta kinget. ");
INSERT INTO bmu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mieŋgö andöŋine ölŋi kaŋgeŋinambuk 7 mi kunbuk loŋkam gili eta kingetka gölme qararaŋkölkölŋaŋgö luhut könöpŋan mi eŋgohotiriiga soholiba gilipitŋi (ambetakŋi) aket. ");
INSERT INTO bmu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ölŋi morömorö kaŋgeŋinambuk mi ölŋi kaŋgeŋinambuk kötŋini ketaŋi ketaŋi kuŋgukuŋguŋi mi gwahöt eŋgiget. Farao kiŋnöŋ miaŋgöreŋök imbiŋi möta wahöriga ölŋi qahöpmö, mi gauna ahök. ");
INSERT INTO bmu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Miri asariiga Farao kiŋnöŋ gaunŋaŋgö mötkurumkurum möta Ijipt kantrigö tiripqözölqözöl aka mötkutukutu azi pakpak öröm eŋgii yaŋgö jemesoholŋe kaŋgotket. Kaŋgotketka gaun ehöhaŋgö kösohotŋi mi jii mötketmö, körek yeŋön gaunŋaŋgö könaŋiri mi Farao kiŋgöra jim asaribingö osiget. ");
INSERT INTO bmu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Osigetka wain o qambigö galöm bohonŋan kinda Farao kiŋ kewö jii mörök: “O kiŋ, nöŋön köna siŋgiali, miaŋgö keuŋan dölki urune kaŋgoriga mötmörizal. ");
INSERT INTO bmu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nalö kunöŋ Farao kiŋnöŋ jembonurupŋi neŋgöra aka irimŋi seholiiga nömemba malmalŋaŋgö sikiriti yeŋgö suahö galömŋaŋgö kösö mire al niŋgiyök. Ni aka bered ohohogö galöm bohonŋi mi nömbuk nanŋi kösö miriŋe al netkiiga tarit. ");
INSERT INTO bmu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","“Miaŋgöreŋ tata mala netkön suŋgem mohot miaŋgöreŋök gauniri inanŋök inanŋök ehit. Gauniraŋgö könaŋi mi inanŋök inanŋök. ");
INSERT INTO bmu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Gauniri ekziga Hibru azi gwabö kunöŋ miaŋgöreŋ netpuk malök. Yaŋön sikiriti yeŋgö suahö galömŋaŋgö welenqeqeŋi maliga niri gauniri yaŋgöra jizi mörök. Yaŋön gauniraŋgö könaŋiri mi inanŋök inanŋök jim asarim netkiyök. ");
INSERT INTO bmu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Könaŋiri jii möriraŋgö dop ölŋi mönö törörök kewö asuhuyök: Nöŋön nupni mutuk memba malali, Farao kiŋnöŋ ni nup miaŋgöreŋ kunbuk al niŋgiyökmö, alani bered ohohogö galömŋaŋgö keuŋi jim teköiga liŋgipnöŋ eriba qetohoba nöröpŋi aka qamötki mi mem wahöta möndöget.” ");
INSERT INTO bmu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mewö jiiga Farao kiŋnöŋ möta Josefnöŋ jemesoholŋe kaŋgotmapköra jim kutuba tosatŋi melaim eŋgiiga anda kösö mirigö dutŋeyök zilaŋ waŋgita kaget. Kagetka jiiga nöröp jupŋi mitigetka opo malukuŋi uteköba Farao kiŋgö jemesoholŋe kaŋgorök. ");
INSERT INTO bmu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kaŋgoriga Farao kiŋnöŋ Josefköra kewö jiyök: “Nöŋön gaun kun ekiga körekŋan miaŋgö könaŋi jibingö osizemö, kunöŋ göhö könagi kewö jiiga mötzal: ‘Kunŋan göhöra gaunŋi jii möta göŋön miaŋgö könaŋi ölöp jim asarimakzan.’” ");
INSERT INTO bmu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Mewö jiiga Josefnöŋ Farao kiŋgöra kewö meleŋ waŋgiyök: “O Farao kiŋ, nöŋön qahöpmö, Anutunöŋ mönö gaungahö könaŋi jim asariba keu ölöpŋi gihiiga urugan ölöwakŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Mewö meleŋ waŋgiiga Farao kiŋnöŋ kewö jiyök: “Nöŋön gauni ekzali, miaŋgö uruŋe nanak Nail o töwatŋaŋgö göraŋe kinjal. ");
INSERT INTO bmu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Miaŋgöreŋ kinbiga bulmakau dömŋi 7 ölöp sorokŋi busuŋini kelökŋinambuk mi o töwatŋi miaŋgöreŋök kota jöjöpözaŋ sutŋine kinda tembam keuqaŋ neze. ");
INSERT INTO bmu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mieŋgö andöŋine bulmakau tosatŋi 7 sihitqarambuŋinanök kaisoŋgolomŋini piromŋi kötökŋi mi o töwatŋi miaŋgöreŋök kotze. Nöŋön bulmakau bölöŋi kötökŋi mewöŋi mi nalö kunöŋ Ijipt gölme pakpak kiaŋgöreŋ qahö eŋgehal. ");
INSERT INTO bmu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bulmakau sihitqarambuŋinanök kaisoŋgolomŋini piromŋi mieŋön bulmakau dömŋi busuŋini kelökŋinambuk 7 mutuk kotzei, mi gwahöt eŋgize. ");
INSERT INTO bmu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","“Mi gwahöt eŋgizemö, mi töndup kaisoŋgolomŋinan gwahöt eŋgizeaŋgö dop utekutek qahö aiga eŋgekzalmö, mutuk kaisoŋgolomŋinan piromŋi kötökŋi kota kinjei, yeŋön mewöŋanök tok kinje. Ni gaun mewö eka imbini möta wahötzal. ");
INSERT INTO bmu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Wahöta kunbuk ahöba gaun kun kewö ekzal: Wit padi ip mohotkö kembaŋe ölŋi kötŋi ketaŋi ketaŋi kaŋgeŋinambuk 7 ölöp kötökŋi mi loŋkam gili eta kinje. ");
INSERT INTO bmu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","“Mieŋgö andöŋine ölŋi kaŋgeŋinambuk tosatŋi 7 mi sötŋi jula kota loŋkam gili eta kingetka gölme qararaŋkölkölŋaŋgö luhut könöpŋan mi eŋgohotiriiga soholiba moröŋi aka gilipitŋi (ambetakŋi) akze. ");
INSERT INTO bmu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ölŋi morömorö gilipitŋi kaŋgeŋinambuk mi ölŋi kaŋgeŋinambuk ölöp sorokŋi mi gwahöt eŋgize. Nöŋön gaun yahöt mi eka tiripqözölqözöl aziurupni jibi mötzemö, yeŋön körek mietkö könaŋiri jim asarim niŋgibingö osize.” ");
INSERT INTO bmu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Farao kiŋnöŋ mewö jiiga Josefnöŋ keu kewö jiyök: “O Farao kiŋ, göhö gaunyahötki mietkö könaŋiri mi mohok akza. Anutunöŋ yuai könaŋgep akŋamgö mötzawi, yaŋön mi Farao kiŋ göhöra indelja. ");
INSERT INTO bmu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulmakau dömŋi 7 ölöp sorokŋi mi yambu 7:gö söpsöpŋi akze. Wit padi ölŋi kaŋgeŋinambuk ölöp kötökŋi 7 mi mewöyöhök yambu 7:gö söpsöpŋi akze. Könaŋiri mi öröröŋ aka mohok akzahot. ");
INSERT INTO bmu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","“Bulmakau sihitqarambuŋinanök kaisoŋgolomŋini piromŋi 7 könaŋgep kotzei, mi yambu 7:gö söpsöpŋi akze. Wit padi ölŋi kaŋgeŋinambuk 7 gölme qararaŋkölkölŋaŋgö luhut könöpŋan eŋgohotiriiga soholiba gilipitŋi (ambetakŋi) akzei, mi bödi (buörö) malmalgö yambu 7 miaŋgö söpsöpŋi akze. ");
INSERT INTO bmu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Anutunöŋ yuai könaŋgep akŋamgö mötzawi, yaŋön mi göhöra indela kondelja. Farao kiŋgöra keu dölki mewö jizali, mi mönö mewögöra aka jizal. ");
INSERT INTO bmu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","O kiŋ, yambu 7:gö dop nene möriam keta bölökŋi asuhuba Ijipt gölme pakpak dop köla ahöma. ");
INSERT INTO bmu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","“Mi ahömapmö, yambu 7 mieŋgö andöŋine bödigö yambu 7 asuhuba ayuayuhu ketaŋi kondoriga Ijipt kantrinöŋ bölima. Miaŋön asuhuiga nene möriam mutuk Ijipt gölmenöŋ ahöyöhi, mi gölme dop yeŋön ölum eŋgum teköma. ");
INSERT INTO bmu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bödi mi köhöikŋi kötökŋi ahömawaŋgöra aka gölme dop ambazip yeŋön nene möriamgö yambuŋi 7 mutuk Ijipt gölmenöŋ ahöyöhi, miaŋgö keuŋi mi kunbuk qahö möta malme. ");
INSERT INTO bmu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Anutunöŋ gaun könaŋi mohot mi indimŋi yahöt gihii ekzani, mi könaŋi kewögöra: Anutunöŋ keu mi lök jöhöba jim köhöiba alök. Mi jim köhöiba alöhi, miaŋgöra miaŋön mönö zilaŋ asuhuma. ");
INSERT INTO bmu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Miaŋgöra Farao kiŋ göŋön ölöp mötkutukutu azi kun keu törörök kewörakzawi, mi möwölöhöba kuŋgunöŋga Ijipt kantri ki galöm köla malma. ");
INSERT INTO bmu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mewöŋanök kiap bohonŋi bohonŋi kuŋgum eŋginöŋga gölme dop köla galömŋina malme. Yeŋön nene möriamgö yambuŋi 7 mieŋgö uruŋine nene ölŋinambuk Ijipt gölmenöŋ asuhumei, miaŋgöra jiiga mendeŋgetka bahöŋini 5 asuhugetka mieŋgöreŋök mohot mohot memba gawmangö köwenöŋ tokoba malme. ");
INSERT INTO bmu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","“Yeŋön mönö kinda jimkutukutu algetka yambu ölöpŋi 7 asuhumei, mieŋgö uruŋine nene ölŋini körek pakpak tokoba kewöta malme. Mewö aka wit padi mi Farao kiŋgö köwe miriŋi miriŋi miaŋgöreŋ qezaköba malme. Mi taon dop gawmangö köwe miriŋi miriŋi miaŋgöreŋ qezaköba galöm köla malgetka könaŋgepkö neneŋa ahöma. ");
INSERT INTO bmu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nene mewö tokoba malmei, mi mönö gawmangö köwe miri dop galöm kölgetka kahaimök ahöiga könaŋgep bödigö yambu 7 Ijipt gölme dop asuhumawi, nalö miaŋgöreŋ mi ölöp memba mendeŋda nemba malme. Mewö aketka kantrigö könagesö neŋön bödi miaŋgö nalöŋe nenegö qahö kömumba gororoŋgöbin. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Josefnöŋ keu mewö jiiga Farao kiŋ aka jembonurupŋi pakpak yeŋön areŋ miaŋgöra mötket dop köliga sihimŋi mötket. ");
INSERT INTO bmu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mewö mötketka Farao kiŋnöŋ jembonurupŋi kewö jii mötket: “Azi kiaŋgö uruŋe bem yeŋgö uŋaŋan kini maljawi, nini i ewö azi kun ölöp qahö miwikŋaibin.” ");
INSERT INTO bmu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mewö jii mötketka Josefköra kewö jiyök: “Anutunöŋ keu areŋ pakpak ki indel gihizawi, miaŋgöra gi ewö mötkutukutu azi keu törörök kewötpawak, mi kun qahö malja. ");
INSERT INTO bmu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Miaŋgöra göŋön mönö jakömbuak mirinaŋgö galömŋi bohonŋi aka malman. Göŋön nöŋgö könagesöurupni pakpak jim kutum eŋginöŋga yeŋön mönö göhöreŋ keu tem köla keugi bapŋe malme. Nöŋön jakömbuak dum tatatnöŋ tarakzali, miyök mötmöriba miaŋgöra aka gi goŋgita ketaŋamgi aka malmam.” ");
INSERT INTO bmu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mewö jiba toroqeba kewö jiyök: “Mötnöŋ, nöŋön gi Ijipt kantri pakpak kiaŋgö azi kembuya malmangöra kuŋgum gihizal.” ");
INSERT INTO bmu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Mewö jiba börö kesötŋaŋgö jeŋjeŋi miaŋön supap köpep ewö qetŋi mekötahöba malöhi, mi qeköba Josefkö börö kesötŋe löŋgörök. Opo maluku eksihimŋambuk opo tuatŋan memeŋi mi löŋgöt waŋgiba sorom goulnöŋ memeŋi kun mi memba Josefkö imbiŋe kölök. ");
INSERT INTO bmu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Mewö aka hos kare qetpuk sorokŋi nanŋi kareŋaŋgö qorembiŋi mi yaŋgöra jim teköiga miaŋgöreŋ öŋgöiga hosnöŋ örögetka anda kaba malök. Mewö anda maliga kiŋgö sikiriti yarö azi kunöŋ mutuk anda göda qem waŋgibingöra kewö qeri qetketka malök: “Kezap! Mönö kesalget!” Mewö ak waŋgiba Ijipt kantri pakpakö azi kembuya kuŋgum waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farao kiŋnöŋ Josefköra kewö jiyök: “Nöŋön Farao kiŋ akzalmö, Ijipt kantri pakpak kiaŋgöreŋ kunŋan kun mönö göhö jitki qetala böröŋi me könaŋi mi kude mem wahötma.” ");
INSERT INTO bmu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Mewö jiba Josefkö qetŋi dölökŋi (Ijipt keunöŋ) Zafenat-Panea qerök. Mewö qeta Heliopolis taongö jike nup galöm qetŋi Potifera yaŋgö böratŋi Asenat mi anömŋa akŋapköra waŋgiyök. Mewö kantrigö azi kembuya aka Ijipt kantri ekŋamgöra anda liliköyök. ");
INSERT INTO bmu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josefnöŋ yambuŋi 30 aiga miaŋgöreŋ Farao Ijiptkö kiŋi yaŋgö jakömbuak nupŋi könahiba meyök. Mi memba Farao kiŋgö sitiŋi mosöta Ijipt uruŋe dop köla liliköba malök. ");
INSERT INTO bmu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nene möriamgö yambuŋi 7 miaŋgö nalöŋe gölmeŋine nene önöŋi qahö asuhum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nene möriamgö yambuŋi 7 kam kuŋgugeri, miaŋgö nalöŋe Josefnöŋ jiiga nene könaŋi könaŋi Ijipt gölme asuhugeri, mi tokoba taonŋine dop anda gawmangöra alget. Gölme köröŋi taon dop liliköba tat angeri, miaŋgöreŋ nene ölŋi asuhugetka mi memba taonŋine dop anda qenjarök köwe miriŋine alget. ");
INSERT INTO bmu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josefnöŋ jiiga wit padiŋi padiŋi mi qenjarök köwe miriŋine önöŋi qahö tokoba alget. Mi sakösiŋ köwet jitŋe ahözawaŋgö dop öŋgöba kinök. Nene möriam sesegilgil asuhuba toroqeba ahöyöhaŋgöra nene toruŋini mi toroqeba oyoŋ bibihigetka lömböriiga osiba mosötket. ");
INSERT INTO bmu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bödi nalöŋan qahö kam kuŋguiga qeljiŋe miaŋgöreŋ anömŋi Asenatnöŋ Josefkö nahönyahötŋi yahöt etkömeyök. Asenat mi Heliopolis taongö jike nup galöm qetŋi Potifera yaŋgö böratŋa. ");
INSERT INTO bmu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nahönŋi mutukŋi asuhuiga Josefnöŋ keu kewö jiyök: “Anutunöŋ bauköm niŋgiiga kahasililiŋ waimanjatni pakpak aka iwinaŋgö mirigö yuaiŋi pakpak mi lök ölum nuŋgui maljali, miaŋgöra. “Mewö jiba nahönŋaŋgö qetŋi Manase (Ölum nuŋguza.) qerök. ");
INSERT INTO bmu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nahönŋi könaŋgepŋi asuhuiga Josefnöŋ keu kewö jiyök: “Ni sihimbölönaŋgö gölmeŋe malbiga Anutunöŋ ahumsehip niŋgizawi, miaŋgöra. “Mewö jiba qetŋi Efraim qerök. (Efraim Ahumsehip niŋgiza.) ");
INSERT INTO bmu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nene möriam ketaŋaŋgö yambuŋi 7 Ijipt gölme dop köla kam kuŋgugeri, mi ahöm kota teköget. ");
INSERT INTO bmu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Yambu mi tekögetka Josefnöŋ keu jiyöhaŋgö dop bödigö yambuŋi 7 mi könahiba kam kuŋguget. Bödi mi gölme tosatŋi pakpak dop köla asuhuba ahöyökmö, Ijipt gölmenöŋ nene mi miri dop köweŋine ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ijipt könagesö körek pakpak yeŋön könahiba bödi möta Farao kiŋgö qeta nene eŋgimapköra uletket. Uletketka möta Farao kiŋnöŋ körek yeŋgöra kewö jiyök: “Iŋini mönö Josefköreŋ angetka yuai mi me mi akŋegö jim kutum eŋgimawi, mi mönö tem köla ahakŋe.” ");
INSERT INTO bmu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Bödinöŋ kantri jömukŋi dop köla ahöba Ijiptkö miriŋi miriŋi pakpak mieŋgöreŋ toroqeba gwötpuk lömböriyök. Mewö asuhuiga Josefnöŋ jiiga qenjarök köwe miriŋi miriŋi mieŋgö naŋguŋini öröba nene mi Ijipt yeŋön söŋgöröŋi memegöra alget. ");
INSERT INTO bmu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bödi mi gölme pakpak dop köla lömböriba ahöyöhaŋgöra ambazipnöŋ gölme dop miaŋgöreŋök Ijipt kaba Josefköreŋ kaŋgota nene söŋgöröŋi memba malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ijipt miaŋgöreŋ nene ahöyöhi, keu mi Keinan gölme miaŋgöreŋ jigetka Jeikobnöŋ möta nahönurupŋi kewö jii mötket: “Iŋini mönö wuanöŋgöra silekmalek aka kuruk je aŋgeka malje? ");
INSERT INTO bmu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ijipt miaŋgöreŋ wit padi ahözawi, nöŋön keu mewö möral. Nini qahö kömumba malmal toroqeba malbingöra iŋini mönö wahöta Ijipt geba miaŋgöreŋ nene tosatŋi bohonŋi memba kagetka nemba malbin.” ");
INSERT INTO bmu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Mewö jii möta Josefkö daturupŋi 10 yeŋön miriŋini mosöta nene bohonŋi membingöra Ijipt gölmenöŋ anbingö aket. ");
INSERT INTO bmu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Iwiŋini Jeikobnöŋ Josefkö munŋi Benjamingö qakŋe ayuayuhu kun öŋgöbapuköra keŋgötŋi möröhaŋgöra i daturupŋi yembuk qahö melaim waŋgiiga anget. ");
INSERT INTO bmu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Keinan gölmenöŋ bödi mi mewöŋanök ahöyöhaŋgöra Israelgö nahönurupŋi yeŋön Keinan azi tosatŋan angeri, yeŋgö sutŋine wit padi bohonŋi membingöra mohotŋe anget. ");
INSERT INTO bmu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Angetmö, Josefnöŋ Ijipt kantrigö azi kembuŋini tata malök. Yaŋön wit padi mi könagesöŋi pakpak yeŋön bohonŋi memegöra aliga yaŋgöreŋ kaŋgota malget. Miaŋgöra daturupŋan kageri, yeŋön kaŋgota miaŋgöreŋök yaŋgö wösöŋe simin köla gölmenöŋ bamgöget. ");
INSERT INTO bmu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Mewö bamgögetka Josefnöŋ daturupŋi eŋgeka möt kutum eŋgiyökmö, könaŋamŋi köyatim eŋgiba kian azigö tandök ak eŋgiba örömureim keu könöpŋambuk jiba kewö qesim eŋgiyök: “Iŋini mönö denikepköra kazeye?” Qesim eŋgiiga kewö meleŋget: “Nini Keinan gölmenöhök nene söŋgöröŋi membingöra kazin.” ");
INSERT INTO bmu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Mewö meleŋgetka Josefnöŋ daturupŋi möt kutum eŋgiyökmö, yeŋön i qahö möt kutum waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Qahö möt kutum waŋgigetka Josefnöŋ mönöwök gaunŋi yeŋgöra ehöhi, mi mötmötŋe kaŋgoriga mötmöriba jihip je suŋini mitiba kewö jii mötket: “Yei! Iŋini mönö kegwek azia akze. Nini kantrinini denikeaŋgöreŋ göröken awörök aka yarö gilbingö lömbörizini, iŋini mi ek kewöta mötpingöra ki kaze.” ");
INSERT INTO bmu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Mi möta kewö meleŋ waŋgiget: “Azi kembunini, mewö qahö. Welenqeqeurupki nini mönö nene söŋgöröŋi membingöra kazin. ");
INSERT INTO bmu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nini körekŋanök azi mohotkö nahönurupŋi akzin. Nini azi diŋdiŋi mala muneŋ qahö jimakzin. Göhö welenqeqeurupki neŋön mönö gölme ek-kewötkö yarö azia qahö aka maljin.” ");
INSERT INTO bmu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Meleŋ waŋgigetka “Qahö!” töhöreŋ qeta kewö toroqeyök: “Nini kantrinini denikeaŋgöreŋ göröken awörök aka yarö gilbingö lömbörizini, iŋini mi ek kewöta mötpingöra ki kaze.” ");
INSERT INTO bmu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Mi möta kewö meleŋ waŋgiget: “Welenqeqeurupki nini Keinan gölmegö aziŋi mohotkö nahönurupŋa, darumun 12 akzin. Munini qöndökŋan nalö kewöŋe iwininambuk mire tariga kunŋan qahö toroqeba malja.” ");
INSERT INTO bmu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Mewö meleŋ waŋgigetka kewö jim eŋgiyök: “Mewö aiga iŋini ölŋa gölme ek-kewötkö yarö azia akzei, mi lök jibi mötze. ");
INSERT INTO bmu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mewö maljeaŋgöra nöŋön kewö esapköm eŋgimam: Farao kiŋnöŋ jebuk maljawi, nöŋön keu öl töhönŋi miaŋgö dop jöjöpaŋ keu kewö jim köhöizal: Munŋini qöndökŋan ki qahö kama ewö, iŋini mönö gölme ki qahö mosöta anme. ");
INSERT INTO bmu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Iŋini keu ölŋi jize me qahö, nöŋön mi esapkömamgöra kewö jizal: Iŋini mönö sutŋineyök kun melaigetka anda munŋini qöndökŋi waŋgita ki kamahot. Tosatŋi iŋini mönö ki mamböta kösö mire tata malme. Mewö qahö akŋe ewö, iŋini mönö ölŋa gölme ek-kewötkö yarö azia akze. Farao kiŋnöŋ jebuk malja ewö, nöŋön keu öl töhönŋi miaŋgö dop jöjöpaŋ keu mi jim köhöizal.” ");
INSERT INTO bmu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Mewö jim eŋgiba jiiga kösö miriŋe al eŋgigetka wehön karöbutkö dop tatket. ");
INSERT INTO bmu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Wehön karöbut aiga Josefnöŋ kaba keu kewö jii mötket: “Jeŋinambuk toroqeba malbingö mötze ewö, iŋini mönö yuai jimami, mi aketka nöŋön ölöp malmalŋini jöhömam. Nöŋön mewöyök iŋini ewö Anutugö jitŋi oŋgitpileŋbuköra keŋgötni mörakzal. Miaŋgöra iŋini mönö kewö akŋe: ");
INSERT INTO bmu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Iŋini azi diŋdiŋi muneŋini qahö malje ewö, darumun eŋgöreŋök mönö kunŋan kösö miri kiaŋgöreŋ toroqeba tariga tosatŋi iŋini ölöp wit padi memba miriŋine liliŋgöba anme. Miaŋgöreŋ anda miriŋine könagesöurupŋinan bödi aka maljei, mi nene eŋgime. ");
INSERT INTO bmu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Iŋini mönö mewö anda munŋini qöndökŋi waŋgita nöŋgöreŋ kame. Kagetka keuŋinaŋgö ölŋan mewö asuhuiga eka möt kutuba qahö eŋgubi kömume. “Keuŋi mewö jiiga mönö miaŋgö dop aket. ");
INSERT INTO bmu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Yeŋön nanŋini Hibru keunöŋ sutŋine keu kewö eraum-mötket: “Nini munini silik ak waŋgiini, miaŋgö likepŋi bölöŋan mönö ölŋa qaknine öŋgöza. Yaŋön malmalŋi jöhöba ak kömum waŋgibingöra uleta kuŋgum neŋgiiga kahasililiŋi ketaŋi ehinmö, yaŋgö keuŋi möta mi qahö wuataŋgöin. Miaŋgöra kahasililiŋ lömbötŋambuk kiaŋön neŋgö qaknine öŋgöza.” ");
INSERT INTO bmu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Mewö eraum-mötketka Rubenöŋ kewö jiyök: “Nöŋön kewö jibi mötket: ‘Iŋini azi gwabö mi silik bölöŋi kude ak waŋgime.’ Mewö jialmö, iŋini nöŋgö keuni mi möta silekmalek aket. Mötket, nalö kewöŋe yaŋgö sepŋaŋgö keugö likepŋan mönö qaknine öŋgöiga kahasililiŋ mötzin.” ");
INSERT INTO bmu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Mewö eraum-mötketka Josefnöŋ yembuk Ijipt keunöŋ keu jiiga kunöŋ mi meleŋnök. Miaŋgöra yeŋön keuŋini jigetka ölöp möt asariyöhi, mi daturupŋan qahö möt kutuget. ");
INSERT INTO bmu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josefnöŋ keuŋini möt asariba liliŋgöba sahörök. Sahöta kunbuk liliŋgöba eŋgeka yembuk keu jiyök. Yembuk keu jiba Simeon sutŋineyök memba jiiga yeŋgö jeŋine jöhöget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josefnöŋ jimkutukutu kewö alök: “Welenqeqe iŋini mönö azi mieŋgö toru gösöŋine wit padi löŋgötketka numbuŋe kotketka mohot mohot yeŋgö moneŋ esuŋini mi totoŋine inanŋik inanŋik toruŋine alme aka köna anangö nene semönŋi mi tok eŋgime. “Mewö jim kutum eŋgiiga miaŋgö dop ak eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Mewö ak eŋgigetka wit padi toruŋini mi doŋki qakŋine ala mosöta anget. ");
INSERT INTO bmu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Anda mala gaun ahöbingöra miri kunöŋ aŋgota darumun yeŋgöreŋök kunŋan doŋkiŋi gumohomamgöra aka toru kösöŋi pösata moneŋ esuŋi mi toru numbuŋe nene qakŋe kiniga ehök. ");
INSERT INTO bmu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Mi eka darumunŋi kewö jii mötket: “Eket, nöŋgöreŋ moneŋ mi mönö meleŋda torune utketka kinja. “Mewö möta wösöŋini juliga aurum tililiŋgöba aŋgeka kewö jiget: “Anutunöŋ mönö wani yuaia ki ak neŋgizawe?” ");
INSERT INTO bmu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Anda mala Keinan gölmenöŋ iwiŋini Jeikobköreŋ aŋgota yuai asuhum eŋgiyöhi, miaŋgö kösohotŋi mi körek kewö jigetka mörök: ");
INSERT INTO bmu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Kantri miaŋgö azi kembuŋi yaŋön örömureim keu könöpuk jiba gölme ek-kewötkö yarö azia akinak, miaŋgö tandök ewö ak neŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","“Mewö ak neŋgiyökmö, nini yaŋgöra kewö jiin: ‘Nini azi diŋdiŋi muneŋnini qahö mala gölme ek kewötpingöra aka qahö kazin. Qahöpmahöp! ");
INSERT INTO bmu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nini azi mohotkö nahönurupŋa, darumun 12 aka maljin. Kunŋan qahö toroqeba maliga munini qöndökŋan nalö kewöŋe Keinan gölmenöŋ iwininambuk mire tatza.’ ");
INSERT INTO bmu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Mewö jiinga gölme miaŋgö azi kembuŋan neŋgöra keu kewö jiyök: ‘Iŋini azi diŋdiŋi me muneŋi maljei, mi kewö kewöt eŋgiba mötmam: Eŋgöreŋöhök darumunŋini kun i mönö mosötketka nömbuk ki tariga tosatŋi iŋini ölöp wit padi memba liliŋgöba anme. Anda miriŋine könagesöurupŋinan bödi aka maljei, mi nene eŋgime. ");
INSERT INTO bmu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Iŋini gölme ek-kewötkö yarö azia qahöpmö, azi diŋdiŋi muneŋini qahö maljei, mi kewö kewöt eŋgiba mötmam: Iŋini mönö anda munŋini qöndökŋi mi waŋgita nöŋgöreŋ kame. Mewö kagetka darumunŋini meleŋ eŋgibiga ölöp gölme kiaŋgöreŋ aŋgumnep-qaŋgumnep aka malme.’” ");
INSERT INTO bmu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mewö jiba toru gösöŋineyök nene köweŋine mokogetka moneŋ esuŋini moneŋinambuk mi toruŋine mohot mohot totoŋine kini miwikŋaiget. Moneŋ esuŋini miwikŋaiba eka i aka iwiŋini mohotŋe auruba keŋgötkotkot mötket. ");
INSERT INTO bmu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Mewö mötketka iwiŋini Jeikobnöŋ kewö jii mötket: “Iŋini nahönurupni körek pakpak noaŋgitpingö mötze: Josefnöŋ qahö malja. Simeon nembuk qahö malja. Benjamin mi mewöŋanök noaŋgita waŋgita anbingö jize. Sihimbölö pakpak miaŋön mönö nöŋgö qakne öŋgöza.” ");
INSERT INTO bmu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Mewö jii möta Rubenöŋ iwiŋaŋgöra keu kewö jiyök: “Ni Benjamin qahö waŋgita liliŋgöba kaba gihimam ewö, gi ölöp nani nahönyahötni yahöt mi etkunöŋga kömumahot. Benjamin mi ölöp nöŋgö böröne alnöŋga i mönö galöm köla anda mala waŋgita liliŋgöba kaba gihimam.” ");
INSERT INTO bmu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mewö jiyökmö, Jeikobnöŋ meleŋda jiyök: “Nahönyahötni qöndökŋi yahöt yetköreŋök datŋan kömuiga munŋan mohot malja. Iŋini könanöŋ anbingö mötzei, miaŋgöreŋ ayuayuhu kunŋan yaŋgö qakŋe öŋgöma ewö, iŋini mönö kondotketka wösöbirik öŋgöŋgöŋan nöŋgö qakne öŋgöiga kömumba nöröp jupni yaŋgonambuknöŋ uŋem mire gemam. Miaŋgöra nöŋgö nahönan mönö nömosöta embuk qahö anma. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Keinan gölmenöŋ bödi lömbötŋambuk mi toroqeba ahöyök. ");
INSERT INTO bmu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jeikobkö könagesöurupŋan wit padi Ijipt kantrinöhök memba kageri, mi körek nem tekögetka qahöwahiga iwiŋinan nahönurupŋi mi kewö jii mötket: “Iŋini mönö kunbuk liliŋgöba anda neneŋamnini tosatŋi söŋgöröŋi meme.” ");
INSERT INTO bmu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Mewö jii mötketka Judanöŋ kewö jiyök: “Azi miaŋön mönö kapaŋ köla neŋgöra galöm meme keu köhöikŋi kewö jiyök: ‘Munŋinan embuk qahö kama ewö, iŋini mönö nöŋgö jemesoholne kunbuk kaŋgotpingö osime.’ ");
INSERT INTO bmu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Miaŋgöra göŋön munini melainöŋga nembuk kama ewö, neŋön ölöp gömosöta neneŋamnini söŋgöröŋi membingöra anbin. ");
INSERT INTO bmu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Azi miaŋön keu kewö jii mörin: ‘Munŋinan embuk qahö kama ewö, iŋini mönö nöŋgö jemesoholne kunbuk kaŋgotpingö osime.’ Miaŋgöra göŋön Benjamin aŋgön kölman ewö, nini qahö anbin.” ");
INSERT INTO bmu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Mewö jiiga Israelnöŋ kewö jiyök: “Iŋini mönö wanigöra munŋini kun maljawi, keu mi azi miaŋgö jiget möröhaŋgöra ni urulömböt ketaŋi niŋgize?” ");
INSERT INTO bmu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Mewö jiiga kewö meleŋda jiget: “Azi miaŋön nini aka könagesöurupnini eŋgöra törörök qeqesi könaŋi könaŋi neŋgiba kewö jiyök, ‘Iwiŋinan jebuk malja me qahö? Darumunŋini kun malja me qahö?’ Mewö jiyöhaŋgöra qeqesiŋi mi neŋön ölŋanök jiba meleŋnin. Yaŋön könaŋgep munini waŋgita kamegöra jibawak, mi mönö qeljiŋe nalö miaŋgöreŋ denöwö mötpinak?” ");
INSERT INTO bmu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Mewö jigetka Judanöŋ iwiŋi Israelgöra kewö jiyök: “Miaŋgöra azi gwabö mi nöŋgö böröne ala melainöŋga mohotŋe anbin. Mewö aknöŋga amqeba zilaŋ gömosöta könanöŋ aninga nini, gi aka anöm-moröurupnini neŋön qahö kömum gororoŋgöbin. ");
INSERT INTO bmu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Benjamingö malmalŋaŋgö sohopŋi miaŋgö keuŋan mönö nöŋgö böröne ahöiga liliŋgöba kaba gihimamgö jim köhöizal. Nöŋön i qahö waŋgita liliŋgöba ki kaba göhö jemesoholge qahö almam ewö, miaŋgö keu lömbötŋan mönö nöŋgö qakne öŋgöiga göhö jege bisiba malbiga gölmenöŋ malmalnan teköma. ");
INSERT INTO bmu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nalö köröpŋi eksekpeksek aka qahö mambötpinak ewö, neŋön lök endu anda liliŋgöba ki kainga ambemŋi yahöt akawak.” ");
INSERT INTO bmu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Mewö jiiga iwiŋini Israelnöŋ kewö jii mötket: “Mewö akza ewö, iŋini mönö kewö akŋe: Gölme kiaŋgö töhötmöriamŋi ölöp kötökŋi tosatŋi kewöŋi mi memba toru gösöŋine löŋgöta anda azi mi kalema waŋgime: Sile mirimirigö kelökŋi tosatŋi, moroŋ oŋi tosatŋi, gipmi bakötök, marasin ip tokuŋi qetŋi mör gipit, kömin, kuŋgam aka saugö alaŋi almond mieŋgö ölŋini. ");
INSERT INTO bmu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Silwö moneŋ walŋi toru gösöŋinaŋgö numbuŋine algetka memba kageri, mi aka miaŋgö dop qakŋe toroqeba ala mindirigetka jaŋgöŋan qariba 2:kö dop aiga mi memba liliŋgöba anda waŋgime. Tosatŋan köpösihira aka mi gösöŋine alget me denöwö? ");
INSERT INTO bmu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Munŋini mewöyök waŋgita zilaŋ wahöta azi miaŋgöreŋ kunbuk liliŋgöba anget. ");
INSERT INTO bmu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Anutu kukösum pakpakö Toŋan mönö azi miaŋgö jeŋe ak-kömukömuŋi eŋgiiga yaŋön darumunŋini kun aka Benjamin mi embuk mire liliŋgöba kamegöra imbi kölma. Nöŋgö moröurupnan tönbirin akŋe ewö, nöŋön mönö öne töhön malmam.” ");
INSERT INTO bmu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Mewö jiiga kalem yuai mi memba silwö moneŋ memba kageri, miaŋgö dop qakŋe toroqeba ala mindirigetka jaŋgöŋan qariba 2:kö dop ahök. Mi memba Benjamin mohotŋe waŋgita wahöta ösumŋinan Ijipt anda Josefkö jeŋe aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Aŋgotketka Josefnöŋ Benjamin mi yeŋgö sutŋine eka miaŋgöreŋök miriŋaŋgö galömŋi kewö jim kutum waŋgiyök: “Gi mönö azi ki eŋguaŋgita nani mire anda al eŋginöŋga tatme. Tatketka anda sömbup kun qeba ohoba silimgö neneŋi mözözömgönöŋga yeŋön ölöp nömbuk mohotŋe nene nembin.” ");
INSERT INTO bmu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Josefkö miriŋaŋgö galömŋan jim kutum waŋgiyöhaŋgö dop azi mi eŋguaŋgiriga Josefkö mire anget. ");
INSERT INTO bmu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Eŋguaŋgiriga Josefkö mire anda jönömŋini unduiga keŋgötŋini möta kewö mötmöriba sutŋine jiget: “Mutuk kainga moneŋnini meleŋda toru gösönine algetka memba anini, miaŋgöra yeŋön mönö neŋguaŋgita kaba ki al neŋgigetka tatzin. Yeŋön mönö qeraköba neŋgum ureiba luhut al neŋgiba neŋgömegetka welenqeqeurupŋi omaŋi ahinga doŋkiurupnini kalöpköba aŋgön köl eŋgibepuk.” ");
INSERT INTO bmu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Mewö jiba kinda Josefkö mirigö galömŋi yaŋgöreŋ öŋgöba angetka miri naŋguŋe kiniga yaŋgöra keu kewö jiget: ");
INSERT INTO bmu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“O ketaŋamnini, nini nalö mutukŋa nene bohonŋi membingöra ki kain. ");
INSERT INTO bmu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kaba nene bohonŋi memba kunbuk liliŋgöba anda könanöŋ miri kunöŋ anda ahöbingöra tata toru gösöninaŋgö kösöŋi pösata moneŋnini totonine mi körekŋanök gösönini nanŋök nanŋök numbuŋine nene qakŋe ahöiga ehin. Miaŋgöra moneŋ mia merak kunbuk meleŋda memba kazin. ");
INSERT INTO bmu_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Silwö moneŋ mi daŋön toru gösönine meleŋda kunbuk alöhi, mi neŋön qahö mötzin. Neŋön mi aka silwö moneŋ tosatŋi mi qakŋe juhuköba nene söŋgöröŋi kunbuk membingöra gösönine ala memba kazin.” ");
INSERT INTO bmu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mewö jigetka miri galömŋan kewö jiyök: “Waimanjat kude mötme. Nanŋini aka iwiŋinaŋgö Anutuŋan mönö kungö uruŋi kuŋguiga silwö moneŋ mi toru gösöŋine aliga miwikŋaiget. Nöŋön eŋgöreŋ silwö moneŋ mi lök meal. Miaŋgöra keŋgötŋini kude möta urubönjöŋ tatme. “Mewö jiba Simeon waŋgita yeŋgöreŋ kayohot. ");
INSERT INTO bmu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kayohotka mohotŋe eŋguaŋgita Josefkö mire öŋgögetka könaŋini saŋgoŋmegöra o eŋgiyök aka doŋkiŋini gwözözak neneŋini miaŋön gumohom eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yeŋön silimgö neneŋi Josefkö mire mohotŋe nemeaŋgö keuŋi mötket. Miaŋgöra Josefnöŋ silimnöŋ miriŋe kaŋgotmapköra mamböta kalem yuaiŋini mi aukŋe areŋgöba tatket. ");
INSERT INTO bmu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tatketka Josefnöŋ mire kaiga kalem yuaiŋini memba kaba miriŋe öŋgögeri, mi waŋgiba wösöŋe simin köla gölmenöŋ bamgöget. ");
INSERT INTO bmu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Bamgöba wahötketka jölöŋini jiba denöwö maljei, qesim eŋgiba kewö jiyök: “Iwiŋini azi namŋaŋgö jigeri, yaŋön denöwö malja? Toroqeba jebuk malja me qahö?” ");
INSERT INTO bmu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Mewö jiiga kewö meleŋget: “Göhö welenqeqegi, neŋgö iwininan mönö ölöp malja. Mönö toroqeba jebuk malja. “Mewö meleŋda göda qem waŋgiba simin köla gölmenöŋ bamgöget. ");
INSERT INTO bmu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Mewö aketka jeŋan ui anda kaiga munŋi Benjamin, nanŋi namŋaŋgö nahönŋi mi eka kewö qesim eŋgiyök: “Munŋini qöndökŋaŋgö jigetka mörali, yaŋön mönö ki akza me denöwö?” Qesim eŋgiba toroqeba kewö jiyök: “Nahöni, Anutunöŋ mönö ak kömum gihiiga malman.” ");
INSERT INTO bmu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Mewö jiba munŋi eka wösöŋi pöröraköiga jeŋi asöliiga sahötmamgö möta miaŋgöreŋök wölaŋ liliŋgöba eŋgömosöta ösumŋan miri uruŋi ölöŋi kunöŋ öŋgöba nanŋök mala sahörök. ");
INSERT INTO bmu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Sahöt teköba je imbilŋi saŋgoŋda miri uruŋi ölöŋi mi mosöta kaba törörök mökösöŋda kinda nanŋi galöm köl aŋguba numbu nene kölmegöra jiyök. ");
INSERT INTO bmu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ijipt yeŋön Hibru ambazip yembuk mohotŋe nene nembingö mötketka imbiloŋloŋambuk akzawaŋgöra mi osimakze. Miaŋgöra Josefkö neneŋi mi inanŋök köl waŋgigetka tari darumunurupŋi yeŋgö mi inanŋök köl eŋgiget tatketka Ijipt ambazip yambuk nene nembingö kaba tatkeri, yeŋgö neneŋini mi inanŋök kölgetka tatket. ");
INSERT INTO bmu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Josefnöŋ jiiga darumunurupŋi mi ahugeraŋgö dop areŋgöm eŋgigetka mutukŋan qaikŋe tariga bezupŋinan qöndökŋe tariga Josefnöŋ mesohol köl eŋgiba tarök. Mewö tata nanŋini aŋgek kutuba welipköba tatket. ");
INSERT INTO bmu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Mewö tatketka Josefnöŋ jiiga nanŋi teibolnöhök nene tosatŋi mendeŋda memba kaba köl eŋgigetka munŋi Benjamingöra ambemŋi 5:gö dop toroqeba kölgetka neyök. Mewö nemba Josefpuk közölömbuaŋ ala awamŋanök o köhöikŋi nemba sösöŋgai qakŋe tatket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Miaŋgö andöŋe Josefnöŋ miriŋaŋgö galömŋi jim kutum waŋgiba kewö jiyök: “Gi mönö azi mieŋgö toru gösöŋine wit padi mi sirimeaŋgö dop löŋgötnöŋga numbuŋine kotme. Mewöŋanök mohot mohot yeŋgö moneŋ esuŋini mi nanŋök nanŋök toto qeba toru gösöŋinaŋgö numbuŋine alman. ");
INSERT INTO bmu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Munŋini qöndökŋi yaŋgö toru gösöŋaŋgö numbuŋe miaŋgöreŋ nane qambi silwönöŋ memeŋi mi wit padigö moneŋi memba kayöhi, miambuk almam. “Mewö jim kutum waŋgiiga miaŋgö dop ahök. ");
INSERT INTO bmu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Miri asariiga söŋanök azi mi melaim eŋgigetka doŋkiŋini eŋguaŋgita könanöŋ anget. ");
INSERT INTO bmu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Anda siti mosöta köröwen qahö angetka Josefnöŋ miriŋaŋgö galömŋi kewö jim kutum waŋgiyök: “Gi mönö zilaŋ wahöta azi mi eŋguataŋgöba anda miwikŋaim eŋgiba eŋgeka kewö qesim eŋgiman: ‘Azi kembunöŋ ölöpŋi ak eŋgiiga iŋini mönö wuanöŋgöra miaŋgö kitipŋi bölöŋi meleŋ waŋgiba kaze? ");
INSERT INTO bmu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nöŋgö ketaŋamnan qambiŋeyök kuluŋ nemakzawi aka qambiŋi miaŋön unji aka keu asa-asambötŋaŋgö könaŋi miwikŋaimakzawi, iŋini qambi mi mönö wuanöŋgöra yoŋgorö memba kaze? Iŋini mönö silik mi bölöŋi kötökŋa akze.’” ");
INSERT INTO bmu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Josefnöŋ miriŋaŋgö galömŋi mewö jim kutum waŋgiiga anda miwikŋaim eŋgiba keuŋi mi jiyöhaŋgö dop jii mötket. ");
INSERT INTO bmu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Jii mötketka kewö meleŋ waŋgiget: “Ketaŋamninan keu tandökŋi mewöŋi mi mönö wuanöŋgöra jiza? Göhö welenqeqeurupki neŋön silik bölöŋi mewöŋi mi qahöpmahöp akzin. Mi yapmakek! ");
INSERT INTO bmu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Mötnöŋ, nini toru gösöninaŋgö numbuŋine silwö moneŋ esu miwikŋainini, mi mewöyök Keinan gölmenöhök memba kaba gihiin. Nini mönö wuanöŋgöra silwö me goul mi ketaŋamgahö mireyök yoŋgorö membinak? ");
INSERT INTO bmu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Welenqeqeurupki neŋgöreŋök kungö toru gösöŋe silwö qambi mi miwikŋaiman ewö, yaŋön mönö kömupkö buŋaya aiga tosatŋi neŋön ketaŋamnini, göhö welenqeqe omaŋi aka malbin.” ");
INSERT INTO bmu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mewö meleŋ waŋgigetka kewö jiyök: “Mewö miaŋön ölöp. Jizeaŋgö dop mi ölöp akin. Kungö toru gösönöhök silwö qambi mi miwikŋaimami, yaŋön mönö nöŋgö welenqeqeni omaŋi akŋapmö, tosatŋi eŋgö sileŋine keu qahö ahöiga ölöp nanŋinök miriŋine anme.” ");
INSERT INTO bmu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Mewö jii möta körekŋan gösöŋini nanŋök nanŋök ösumok qeköba memba eta gölmenöŋ ala numbuŋinaŋgö kösöŋi pösatket. ");
INSERT INTO bmu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Pösatketka Josefkö miriŋaŋgö galömŋam datŋini mutukŋaŋgö toru gösöŋeyök könahiba qezaŋda jaruba anda anda munŋini qöndökŋi Benjamingö toru gösöŋe teteköŋe eka qambi mi miaŋgöreŋ miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Mi miwikŋaiiga yeŋön uruŋini kot gwözöŋniga wösöbirikŋini kondela malukuŋini munjukunjuratket. Mewö aka sukinapŋini doŋki qakŋine ala kunbuk liliŋgöba sitinöŋ anget. ");
INSERT INTO bmu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda aka darumunurupŋi yeŋön liliŋgöba Josefkö mire angetka yaŋön tok miriŋeyök tarök. Tariga wösöŋe aŋgota simin köla gölmenöŋ bamgöget. ");
INSERT INTO bmu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Bamgögetka Josefnöŋ kewö jiyök: “Iŋini mönö wani siliha mi akzeye? Azi ni ewöŋan mönö ölöp unju memba yuai yoŋgorö megetka mi miwikŋaimakzali, iŋini mi qahö mötze me?” ");
INSERT INTO bmu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Mewö jiiga Judanöŋ kewö meleŋnök: “O ketaŋamni, nini mönö wani keuya göhöra jibinak? Nini keugö jaruzin. Neŋön yuai bölöŋi qahö ahini, mi kondel gihibinaŋgö dop qahö. Anutunöŋ mönö welenqeqeurupki, neŋgö pinjitkö keuŋi indeli aukŋe ahöza. Miaŋgöra kungö toru gösöŋeyök qambi mi miwikŋaizawi aka tosatŋi neŋön mewöyök mönö azi kembunaŋgö welenqeqeurupŋi omaŋi aka malbin.” ");
INSERT INTO bmu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mewö meleŋnökmö, Josefnöŋ kewö jiyök: “Nöŋön yuai mewöŋi mi qahö ak eŋgimam. Mi saumbaŋ! Azi dagö toru gösöŋe qambi mi miwikŋaizawi, yaŋönök mönö nöŋgö welenqeqeni aka malmapmö, tosatŋi iŋini ölöp luai qakŋe liliŋgöba iwiŋinaŋgöreŋ mire anme.” ");
INSERT INTO bmu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Mewö jiiga Judanöŋ Josefkö wösöŋe anda keu kewö jiyök: “O azi kembuni, ölöp imbi kölnöŋga welenqeqegi nöŋön keu tosatŋi azi kembuni göhöra jibileŋak. Göŋön Farao kiŋ nanŋambuk öröröŋ akzanmö, töndup welenqeqegi nömbuk kazik kude ak niŋgiman. ");
INSERT INTO bmu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Azi kembuni göŋön welenqeqeurupki nini mutuk kainga kewö qesim neŋginöŋ: ‘Eŋgö iwiŋini aka darumunŋini kun maljahot me qahö?’ ");
INSERT INTO bmu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","“Mewö qesim neŋginöŋga neŋön azi kembuni göhöra kewö meleŋnin: ‘Neŋgö iwinini azi namŋi aka munini azi gwaböya kun mire tatzahot. Munini miaŋön iwininan lök azi namŋi aiga nalö miaŋgöreŋ asuhuyök. Namŋan azi morö yahöt etkimeiga datŋan kömuiga nanŋök töhön malja. Yaŋön mönö iwiŋaŋgö wölböt (jojopaŋ) nahönŋi akza.’ ");
INSERT INTO bmu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mewö meleŋninga göŋön welenqeqeurupki neŋgöra keu kewö jinöŋ, ‘Iŋini mönö munŋini mi waŋgita nöŋgöreŋ ki kagetka i ölöp nani jenan uba ekŋam.’ ");
INSERT INTO bmu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","“Mewö jinöŋga neŋön azi kembunini göhöra kewö meleŋnin: ‘Azi gwabö mi iwiŋi mosötmamgö osima. Iwiŋi mosötpawak ewö, iwiŋan mönö kömumbawak.’ ");
INSERT INTO bmu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Mewö meleŋninmö, göŋön welenqeqeurupki neŋgöra keu kewö jim kutunöŋ: ‘Munŋini qöndökŋan embuk ki qahö kama ewö, iŋini mönö nöŋgö jemesoholne kunbuk kude asuhume.’ ");
INSERT INTO bmu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Mewö jim kutunöŋga mirinine liliŋgöba anda nöŋgö iwini, göhö welenqeqegi yaŋgöra azi kembuni göhö keugi mi jiinga mörök. ");
INSERT INTO bmu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Mi jiinga möta iwininan könaŋgep kewö jiyök: ‘Iŋini mönö kunbuk anda neŋgöra nene tosatŋi söŋgöröŋi memba kame.’ ");
INSERT INTO bmu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","“Mewö jiyökmö, nini kewö jiin, ‘Neŋön naninök anbingö osibin. Munini qöndökŋan nembuk mohotŋe anmapkö jiman ewö, mönö ölöp anbin. Munini bezupŋi qahö waŋgita anbin ewö, neŋön mönö azi miaŋgö jemesoholŋe asuhubingö osibin.’ ");
INSERT INTO bmu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Mewö jiinga nöŋgö iwini göhö welenqeqegi yaŋön kewö jiyök: ‘Anömni Reizölnöŋ nahönyahötni yahöt etkimeyök. Mi nanŋini ölöp mötze. ");
INSERT INTO bmu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Datŋan nömosöta anda sohoiga kewö jial, “Sömbup kalŋan mönö yöhöqöhöi kömumbawak me denöwö?” Nalö miaŋgöreŋök könahiba i qahö ehal. ");
INSERT INTO bmu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Merak munŋi ki mewöyök noaŋgita angetka könanöŋ ayuayuhu kunŋan yaŋgö qakŋe öŋgöma ewö, iŋini mönö kondotketka wösöbirik öŋgöŋgöŋan nöŋgö qakne öŋgöiga köŋjiliŋ möta kömumba nöröp jupni yaŋgonambuknöŋ uŋem mire gemam.’” ");
INSERT INTO bmu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Judanöŋ toroqeba keu kewö jiyök: “O azi kembuni, nöŋön munini azi gwabö mi qahö waŋgita anda iwini, göhö welenqeqegi yaŋgö mire aŋgotpileŋak ewö, iwininan mönö ayuhubapuk. Yaŋön mönö uruŋi pakpak nahönŋi bezupŋi yaŋgöreŋ jöhöiga malmalŋiri mohot maljahot. ");
INSERT INTO bmu_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Miaŋgöra azi gwabö mi qahö waŋgita aninga iwininan mi eka mönö kömup miwikŋaibapuk. Göhö welenqeqeurupki neŋgöreŋ mewö asuhuiga nini mönö kondoringa wösöbirik öŋgöŋgöŋan iwinini göhö welenqeqegi yaŋgö qakŋe öŋgöiga kömumba nöröp jupŋi yaŋgonŋambuknöŋ uŋem mire gema. ");
INSERT INTO bmu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Göhö welenqeqegi nöŋön azi gwabönöŋ qahö ayuhumapkö keuŋi mi iwinaŋgöra jim jöhöba kewö jial: ‘I qahö waŋgita göhöreŋ liliŋgöba kamam ewö, miaŋgö keu lömbötŋan mönö göhö jege nöŋgö qakne öŋgöba ahöiga gölmenöŋ malmalni mewö mal öŋgöm tekömam.’ ");
INSERT INTO bmu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Miaŋgöra göŋön ölöp jim tekönöŋga nöŋön azi gwabö yaŋgö salupŋe azi kembuni göhö welenqeqegi omaŋi aka ki malbiga yaŋön daturupŋi yembuk liliŋgöba miriŋine anme. ");
INSERT INTO bmu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","“Azi gwabö miaŋön nömbuk qahö kama ewö, nöŋön mönö denöwö aka iwinaŋgöreŋ anbileŋak? Wösöbirik öŋgöŋgöŋan iwinaŋgö qakŋe öŋgöbawak, nöŋön mönö mi ekŋamgö tököm köhöizal. Miaŋgöra i mönö kude jöhöman.” ");
INSERT INTO bmu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Judanöŋ mewö jiiga ambazip liliköm eŋgiba kinda eŋgekeri, Josefnöŋ körek yeŋgö jeŋine toroqeba könaŋi köyatiba nanŋi galöm köl aŋgumamgö lömböriba osiyök. Miaŋgöra Josefnöŋ kewö silata qerök: “Eŋön mönö körekŋanök nömosöta deŋget. “Mewö jiiga deŋgetka Ijipt azi kunŋan kösutŋine qahö kiniga Josefnöŋ nanŋi könaŋi mi darumunurupŋi yeŋgöra kewö indelök: ");
INSERT INTO bmu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yaŋön amburereŋ aka ötömbepuk qei sahöriga Ijipt ambazip gumnöŋ malgeri, yeŋön mi möta Farao kiŋgö jakömbuak mire anda buzup keuŋi mi jigetka mötket. ");
INSERT INTO bmu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josefnöŋ sahöta kinda darumunurupŋi mi kewö jii mötket: “Ni Josef! Iwinan tok jebuk malja me qahö?” Mewö jii mötketmö, darumunŋan uruŋinan kot gwözöŋniga aurum tililiŋgöba jeŋe öne kinda keu kun qahö mötmöriba meleŋ waŋgibingö osiget. ");
INSERT INTO bmu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Osiba kingetka Josefnöŋ yeŋgöra kewö jiyök: “Eŋön mönö nöŋgö kösutne ki kaget. “Mewö jii kagetka kewö jiyök: “Ni Josef, darumunŋini bohoni memegöra algetka Ijipt kayali, mönö mia. ");
INSERT INTO bmu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","“Mönö uruköŋjiliŋ kude mötme. Anutunöŋ eŋön kömumbepuköra ni mutuk melaim niŋgiiga qeljiŋe ki kabiga iŋini kaze. Ni bohoni memegöra al niŋgigetka ki kayali, miaŋgöra mönö nanŋinaŋgöra irimsesewöl kude möt aŋgume. ");
INSERT INTO bmu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Bödi kiaŋön lök yambu yahötkö dop gölme dop köla ahöza. Mi toroqeba kunbuk yambu 5:gö dop ahöiga nalö miaŋgö uruŋe gölme qem kömöt qahö aka nene ölŋi qahö miwikŋaiba tokoba malbin. ");
INSERT INTO bmu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","“Anutunöŋ mönö köna wewelipköŋambuk wuataŋgöba eŋgö malmalŋinaŋgö bohonŋi jöhöiga toroqeba jebuk mala gwölönarök miwikŋaim eŋgiba gölme qakŋe malmegöra mötza. Miaŋgöra aka ni mutuk melaim niŋgiiga qeljiŋe ki kabiga iŋini kaze. ");
INSERT INTO bmu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Miaŋgöra eŋön qahö melaim niŋgiget tandök akzapmö, Anutunöŋ mönö ölŋa melaim niŋgiiga ki kayal. Yaŋön kuŋgum niŋgiiga Farao kiŋgö jembonŋi mutukŋi aka jakömbuak miriŋe wanat nup memakzei, körek yeŋgö ketaŋamŋina akzal. Mewö akiga Anutunöŋ Ijipt kantri jömukŋanök mi nöŋgö böröne aliga azi kembuŋina akzal. ");
INSERT INTO bmu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Iŋini mönö dölki wahöta ösumŋinan iwinaŋgöreŋ liliŋgöba anda keu kewö jigetka mötma: ‘Göhö nahöngi Josef yaŋön keu kewö jiza: Anutunöŋ ni kuŋgum niŋgiba Ijipt kantri jömukŋanök nöŋgö böröne aliga azi kembuŋina akzal. Miaŋgöra göŋön mönö nalö kude qem körimanmö, zilaŋ nöŋgöreŋ kaman. ");
INSERT INTO bmu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ki kaba ölöp tatat dumdumgi Gosen gölmenöŋ möhamgöba nane kösutne malman. Gi aka isimoröurupki, göhöreŋ lama bulmakau kambuŋi kambuŋi aka öröyuai pakpak buŋagi ahözawi, mi mönö memba kölolohoba kame. ");
INSERT INTO bmu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","“Bödi kiaŋön mönö kunbuk toroqeba yambu 5:gö dop ahöm öŋgöma. Nalö miaŋgö uruŋe gi, mirigahö saiwaurupki me tinitosolomurupki tosatŋi yeŋgöreŋök kunŋan bödi mala nenegö mözöqözöröm aka kömum gororoŋgöbapuk. Miaŋgöra mönö Gosen gölmenöŋ kaba mala wani yuaigöra osimei, nöŋön mi eŋgiba malmam.’ Iwininaŋgöra keu mi mönö mewö jigetka mötma. ");
INSERT INTO bmu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Ni nanak ölŋa ki kinda eŋgöra keu jizali, mi ölöp nanŋini jeŋinan nek kutuze aka muni Benjaminöŋ mewöyök ni nek kutuza. ");
INSERT INTO bmu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Miaŋgöra iŋini mönö iwinaŋgöreŋ anda Ijipt kantrinöŋ qetbuŋa ketaŋi pakpak niŋgigetka maljali aka yuai pakpak ekeri, miaŋgö kösohotŋi mi iwini jigetka mötma. Mi möriga mönö ösumok waŋgita eta ki kame.” ");
INSERT INTO bmu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Mewö jiba böröŋi munŋi Benjamingö imbiŋe gili geiga sahöriga Benjaminöŋ mewöŋaŋök aŋgöm waŋgiba sahörök. ");
INSERT INTO bmu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Toroqeba böröŋi daturupŋi körek yeŋgö imbiŋine gili geiga sahöta numbuŋini yöhötim neyök. Miaŋgö andöŋe darumunurupŋan yambuk keu eraum-mötket. ");
INSERT INTO bmu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Josefkö darumunurupŋan kageri, miaŋgö buzupŋan Farao kiŋgö jakömbuak mire aniga Farao kiŋ aka jembonurupŋi pakpak yeŋön mi möta uruölöwak mötket. ");
INSERT INTO bmu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Mewö möta Farao kiŋnöŋ Josefköra kewö jiyök: “Darumunurupki mönö jinöŋga kewö akŋe: ‘Sukinapŋini mönö doŋki qakŋine ala kunbuk liliŋgöba miriŋine Keinan gölme anme. ");
INSERT INTO bmu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Anda iwiŋini aka saiwaurupŋini eŋguaŋgita liliŋgöba nöŋgöreŋ kame. Ki kagetka nöŋön gölme ölöp kötökŋi Ijipt kantri uruŋeyök möwölöhöba eŋgibiga ölöp miaŋgö kelökŋi miwikŋaiba nem söŋgaip aka malme.’ ");
INSERT INTO bmu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Mewöyök kewö jim kutum eŋginöŋga akŋe: ‘Ijipt kiaŋgöreŋök mönö hosgö kareŋi tosatŋi memba anda anöm-moröurupŋini miaŋgöreŋ al eŋgiba iwiŋini waŋgita mohotŋe ki kame. ");
INSERT INTO bmu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Miriŋinaŋgö yuaiŋi tosatŋi Keinan gölmenöŋ mosötmei, miaŋgö waimanjatŋi kude akŋe. Nöŋön miaŋgö salupŋe Ijipt kantri jömuk kiaŋgö yuaiŋi ölöp kötökŋi mi eŋgibiga buŋaŋini akŋa.’” ");
INSERT INTO bmu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Farao kiŋnöŋ mewö jiiga Israelgö nahönurupŋan miaŋgö dop aket. Josefnöŋ Farao kiŋgö jimkutukutu keuŋi wuataŋgöba hosgö kareŋi tosatŋi eŋgiyök. Mewöyök köna anangö nene semön tosatŋi eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Mi eŋgibagun daturupŋi mohot mohot yeŋgö opo malukuŋini dölökŋi totoŋine eŋgiyökmö, munŋi Benjamingöra opo maluku dölökŋi börö kun waŋgiba moneŋ silwö köt 300 waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Iwiŋaŋgöra Ijipt kantrigö yuai ölöp sorokŋi jesöŋgö memba doŋki ten mieŋgö qakŋine aliga anget. Mewöŋanök doŋki ambiŋi ten mieŋgö qakŋine wit padi, bered aka nene tosatŋi iwiŋaŋgö köna semöna aliga bisiba anget. ");
INSERT INTO bmu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Angetka Josefnöŋ darumunurupŋi melaim eŋgii anbingö aketka keu kewö jii mötket: “Iŋini könanöŋ anda aŋgururuk kude akŋe.” ");
INSERT INTO bmu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Mewö jiiga Ijipt mosöta anda Keinan gölmenöŋ iwiŋini Jeikobköreŋ aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Aŋgota iwiŋinaŋgöra keu kösohot kewö jiget: “Josefnöŋ mönö toroqeba jebuk malja. Ijipt kantri jömukŋanök mi yaŋgö böröŋe ahöiga azi kembuŋina aka malja. “Mewö jigetka keu mi qahö möt nariyöhaŋgöra uruŋi toroqeba amöriiga tarök. ");
INSERT INTO bmu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mewö tarökmö, Josefnöŋ keu pakpak jiyöhi, mi jiget mörök aka hosgö kareŋi tosatŋi i waŋgita Ijipt anmapköra ali kayöhi, iwiŋini Jeikobnöŋ mi eka kinda uru sileŋan köleŋni könöpkönöp ahök. ");
INSERT INTO bmu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Könöpkönöp aka kewö jiyök: “O mi alakŋa! Mi möt köhöizal. Nahöni Josefnöŋ mönö toroqeba jebuk malja. Nöŋön mönö anda i ekagun könaŋgep ölöp kömumam. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israelnöŋ sukinap yuaiŋi pakpak kölolohoba memba wahöta köna anök. Anda Berseba mire aŋgota kinda miaŋgöreŋ iwiŋi Aisakö Anutuŋaŋgöra umjöwöwöl ohoyök. ");
INSERT INTO bmu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mi ohoba suŋgem ahöiga jeŋi meleŋniga imut eka miaŋgöreŋ Anutunöŋ Israelgöra keu jiba qetŋi “Jeikob, Jeikob!” qeriga “Ni ki,” jiba meleŋnök. ");
INSERT INTO bmu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Meleŋniga kewö jiyök: “Ni Anutu, göhö iwigahö bemŋi. Gi Ijipt gemamgö keŋgötki kude mötman. Nöŋön miaŋgöreŋ kötuetköm gihibiga könagesö kambu ketaŋi akŋe. ");
INSERT INTO bmu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nöŋön mönö göbuk Ijipt gemam aka mewöyök gwölönarökurupki miaŋgöreŋök eŋguaŋgitpiga kunbuk liliŋgöba kame. Göŋön kömunöŋga Josef nanŋi böröŋan mönö göhö je jupki kusui etma.” ");
INSERT INTO bmu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Miaŋgö andöŋe Jeikobnöŋ Berseba miri mosötpin jiiga Israelgö nahönurupŋan iwiŋini aka anöm-moröurupŋini mi közözohom eŋgigetka hosgö karenöŋ öŋgöget. Farao kiŋnöŋ hosgö kare miaŋön eŋgömemba kamegöra jiba ali memba anget. ");
INSERT INTO bmu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Sukinapŋini aka miri sömbupŋini pakpak Keinan gölmenöŋ mala buŋa qeba memba malgeri, mi tok mohotŋe memba anget. Jeikob aka gwölönarökurupŋi pakpak mieŋön mewö Ijipt anget. ");
INSERT INTO bmu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Gwölönarökurupŋi pakpak, isimoröurupŋi azi aka ambi mi körek eŋguaŋgita Ijipt anget. ");
INSERT INTO bmu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israel qetŋi alaŋi Jeikob aka yaŋgö gwölönarökurupŋi Ijipt angeri, yeŋgö qetŋini kewö: Jeikobkö nahönŋi mutukŋi Ruben. ");
INSERT INTO bmu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubengö nahönurupŋi qetŋini Hanok, Palu, Hezron aka Karmi. ");
INSERT INTO bmu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeongö nahönurupŋi qetŋini Jemuel, Jamin, Ohad, Jakin, Zohar aka Saul. Saulgö namŋi mi Keinan ambi kun. ");
INSERT INTO bmu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Liwaigö nahönurupŋi qetŋini Gerson, Kohat aka Merari. ");
INSERT INTO bmu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judagö nahönurupŋi qetŋini Er, Onan, Sela, Perez aka Zera. (Er aka Onan yetkön lök Keinan gölmenöŋ kömuyohot.) Perezkö nahönyahötŋi mi Hezron aka Hamul. ");
INSERT INTO bmu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakargö nahönurupŋi qetŋini Tola, Puwa, Jasub aka Simron. ");
INSERT INTO bmu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulungö nahönurupŋi qetŋini Sered, Elon aka Jalel. ");
INSERT INTO bmu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Jeikobkö nahönurupŋi anömŋi Leanöŋ Mesopotemia (Padan Aram) gölmenöŋ eŋgömeyöhi, yeŋgö qetŋini mewö. Böratŋiri Daina mi mewöyök meyök. Jeikob aka Lea yetkö isimoröurupŋiri mi mewö oyoŋda mindirigetka 33 ahök. ");
INSERT INTO bmu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadkö nahönurupŋi qetŋini Zefon, Hagi, Suni, Ezbon, Eri, Arodi aka Areli. ");
INSERT INTO bmu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asergö nahönurupŋi qetŋini Imna, Iswa, Iswi aka Beria. Nenŋinaŋgö qetŋi Sera. Beriagö nahönyahötŋi qetŋiri Heber aka Malkiel. ");
INSERT INTO bmu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Labanöŋ ambi qetŋi Zilpa böratŋi Leagö welen ambia malmapköra waŋgiyöhi, yaŋön Jeikobkö nahönurupŋi mewö eŋgömeyök. Jeikob aka Zilpa yetkö isimoröurupŋiri mi mewö oyoŋda mindirigetka 16 ahök. ");
INSERT INTO bmu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jeikobkö anömŋi Reizölgö nahönyahötŋi mi Josef aka Benjamin. ");
INSERT INTO bmu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Josefkö nahönyahötŋi Ijipt kantrinöŋ asuhuyohori, mi qetŋiri Manase aka Efraim. Namŋiri qetŋi Asenat mi Heliopolis (On) taongö jike nup galöm qetŋi Potifera yaŋgö böratŋa. ");
INSERT INTO bmu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamingö nahönurupŋi qetŋini Bela, Beker, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim aka Ard. ");
INSERT INTO bmu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jeikobkö nahönyahötŋi Reizölnöŋ etkömeyöhi, yetkö qetŋiri mewö. Jeikob aka Reizöl yetkö isimoröurupŋiri mewö oyoŋda mindirigetka körekmakörek 14 ahök. ");
INSERT INTO bmu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dangö nahönŋi qetŋi Husim. ");
INSERT INTO bmu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftaligö nahönurupŋi qetŋini Jaziel, Guni, Jezer aka Silem. ");
INSERT INTO bmu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Labanöŋ ambi qetŋi Bilha böratŋi Reizölgö welen ambia malmapköra waŋgiyöhi, yaŋön Jeikobkö nahönurupŋi mewö eŋgömeyök. Jeikob aka Bilha yetkö isimoröurupŋiri mi mewö oyoŋda mindirigetka körekmakörek 7 ahök. ");
INSERT INTO bmu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jeikobkö isimoröurupŋi diŋdiŋi töhön yambuk Ijipt angeri, mieŋgö jaŋgöŋini oyoŋda mindirigetka körekŋanök könagesö 66 aket. Nahönurupŋi yeŋgö anömŋini mi jaŋgö miaŋgöreŋ qahö toroqeget. ");
INSERT INTO bmu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Josefkö nahönyahötŋi Ijipt kantrinöŋ asuhuyohori, mi yahöt. Jeikobkö könagesöurupŋi Ijipt angeri, mieŋgö jaŋgöŋini mi mewö oyoŋda mindirigetka 70 ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Könanöŋ anda mala Jeikobnöŋ Juda mutuk melaiba kewö jiyök: “Gi mönö Josefköreŋ anda Gosen gölmenöŋ anangö könaŋaŋgöra qesim waŋgiman. “Mewö jii möta anda kaiga Gosen prowinsnöŋ aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josefnöŋ aŋgotkeraŋgö buzupŋi möta jiiga hos karenöŋ jöhöba mözözömgögetka qakŋe öŋgöba iwiŋi Israelbuk aitoŋgöbitkö Gosen gölmenöŋ anök. Anda eka yaŋgö jeŋe aŋgota böröŋi imbiŋe gili geiga aŋgum waŋgiba nalö köröpŋi titipepeŋi memba urusahöt qeyök. ");
INSERT INTO bmu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israelnöŋ Josef kewö jii mörök: “Göŋön toroqeba jebuk maljani, mi nanak gekzala nalö kewöŋe ölöp jöjöröba kömumam.” ");
INSERT INTO bmu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Mewö jiiga Josefnöŋ darumunurupŋi aka iwiŋaŋgö könagesöŋi kewö jii mötket: “Nöŋön mönö Farao kiŋgöreŋ öŋgöba keu kewö jibi mötma: ‘Darumunurupni aka iwinaŋgö könagesöŋi Keinan gölmenöŋ malgeri, yeŋön lök nöŋgöreŋ kaze. ");
INSERT INTO bmu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Darumunurupni mieŋön lama bulmakau galömŋini aka mi galöm köl eŋgiba maljeaŋgöra kabingö aka lama kambuŋini, bulmakau kambuŋini aka sukinap öröyuaiŋini pakpak mi eŋguaŋgita kaze.’ ");
INSERT INTO bmu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Miaŋgöra Farao kiŋnöŋ eŋgoholi jemesoholŋe aŋgotketka kewö qesim eŋgima: ‘Iŋini wani nuwa memakze?’ ");
INSERT INTO bmu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","“Mewö qesim eŋgiiga iŋini kewö meleŋ waŋgime: ‘Welenqeqeurupki neŋön mönö abu asaurupnini mutuk memba malgeraŋgö dop moröröpnineyök lama bulmakau galöm kölköl nupŋi memba mala maljin.’ Mewö meleŋ waŋgigetka yaŋön ölöp Gosen prowinsnöŋ tatat dumdumŋini möhamgömegöra oŋ jiiga malme. Ijipt ambazip yeŋön lama bulmakau galöm kölköl ambazip pakpak yeŋgöra mötketka imbiloŋloŋinambuk ahakze. “Josefnöŋ keuŋi mewö jii mötket. ");
INSERT INTO bmu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josefnöŋ anda Farao kiŋgöra kewö jiyök: “Nöŋgö iwi darumunurupni yeŋön lama bulmakau kambuŋini aka sukinap öröyuaiŋini pakpak memba Keinan gölme mosöta kaba mala dölki Gosen gölmenöŋ kaŋgota malje.” ");
INSERT INTO bmu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yaŋön darumunurupŋi yeŋgöreŋök azi 5 eŋguaŋgita Farao kiŋgö jeŋe öŋgöba kingetka eŋgehök. ");
INSERT INTO bmu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Eŋgeka kewö qesim eŋgiyök: “Iŋini wani nuwa memakze?” Mewö qesim eŋgiiga kewö meleŋ waŋgiget: “Welenqeqeurupki neŋön iwiurupninan mutuk malgeraŋgö dop lama bulmakau galöm kölköl nupŋi memba mala maljin.” ");
INSERT INTO bmu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Mewö jiba toroqeba kewö jiget: “Keinan gölmenöŋ bödi lömbötŋambuk ahözawaŋgöra welenqeqeurupki neŋön lama bulmakau kambunini yeŋgöra nene qahö miwikŋainin. Miaŋgöra neŋön gölme kiaŋgöreŋ kusuk malbingöra kain. Mewö aiga welenqeqeurupki ölöp oŋ jiba jim teköm neŋginöŋga nini Gosen prowins miaŋgöreŋ tatat dumdumnini möhamgöbin.” ");
INSERT INTO bmu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Mewö jigetka Farao kiŋnöŋ Josef kewö jii mörök: “Iwi darumunurupkan göhöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ijipt kantri ki aukŋe göhö jege ahözawaŋgöra ölöp iwi darumunurupki gölme bahöŋi kelökŋi ölöpŋi miaŋgöreŋ al eŋginöŋga malme. Ölöp Gosen prowinsnöŋ malme. Sutŋine nup qetpuk meme azi tosatŋi maljei, mi möt eŋgiman ewö, ölöp nöŋgö mirigö sömbup kambuni mi yeŋgö böröŋine al eŋginöŋga galöm köl eŋgiba malme.” ");
INSERT INTO bmu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Mewö jii möta Josefnöŋ iwiŋi Jeikob Farao kiŋgö jeŋe waŋgita kaiga ehi Farao kiŋ mi kötuetköm waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kötuetköm waŋgiiga kewö qesim waŋgiyök: “Göhö yambugi dawik akza?” ");
INSERT INTO bmu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Qesim waŋgiiga kewö meleŋnök: “Nöŋön yambu 130:gö dop gölmenöŋ liliköba mala kota maljal. Nöŋgö malmalnaŋgö yambuŋi pakpak mi awamdökŋi aka osikosiŋinambuk aket. Iwiurupnan yambu sehisehiŋi gölmenöŋ liliköba malgeri, nöŋgö yambu qötönan yeŋgöreŋambuk dop mohot qahö akza.” ");
INSERT INTO bmu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Mewö jiba Farao kiŋ mi kunbuk kötuetköm waŋgiba jemesoholŋeyök eta anök. ");
INSERT INTO bmu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Josefnöŋ iwi darumunŋi mi Farao kiŋnöŋ jim kutuyöhaŋgö dop Ijipt kantrinöŋ al eŋgiba Ijiptkö gölme bahöŋi kelökŋi ölöpŋi kun mi Rameses prowins (Gosen) miaŋgöreŋ eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josefnöŋ mewöyök iwi darumunurupŋi aka iwiŋaŋgö könagesöurupŋi pakpak mi neneŋini anöm-moröurupŋini malgeri, qötö miaŋgö dop dopŋine eŋgiba malök. ");
INSERT INTO bmu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bödi ketaŋi mi lömbötŋambuk ahöiga nenenöŋ gölme dop qahöwahiga Ijipt aka Keinan kantri mietkö könagesöŋiran mönö nenegö kömum soholip aka malget. ");
INSERT INTO bmu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Mewö mala Josefköreŋ kaba wit padi söŋgöröŋi megetka yaŋön moneŋ pakpak Ijipt aka Keinan kantri uruŋe ahöyöhi, mi tokoba memba Farao kiŋgö jakömbuak mirigö köweŋe alök. ");
INSERT INTO bmu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ijipt könagesö aka Keinan könagesö yeŋgöreŋ moneŋ qahöwak teköiga Ijipt körek yeŋön Josefköreŋ kaba kewö jiget: “Moneŋninan qahöwak teközawaŋgöra göŋön mönö nene neŋgiman. Nene qahö neŋgiman ewö, neŋön mönö göhö jemesoholge kömumbin.” ");
INSERT INTO bmu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Mewö jigetka Josefnöŋ kewö jiyök: “Moneŋinan qahöwakzawaŋgöra eŋgöreŋ lama aka bulmakau ahözei, mönö mi memba kaba niŋgigetka nöŋön nene eŋgimam.” ");
INSERT INTO bmu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Mewö jiiga anda lama bulmakauŋini eŋguaŋgita kaba Josef waŋgiget. Yeŋön hosŋini, lamaŋini, memeŋini, bulmakauŋini aka doŋkiŋini mi eŋguaŋgita kaba nenegö söŋgöröŋa Josef waŋgiba nene memba malget. Lama bulmakauŋini pakpak mi Josef waŋgigetka yaŋön nene eŋgiba mewö miaŋön yambu mohotkö uruŋe malmalŋini naŋgöiga qahö kömuget. ");
INSERT INTO bmu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Qahö kömugetka yambu miaŋön teköyök. Teköiga yambu dölökŋe dumŋe kunbuk yaŋgöreŋ kaba kewö jiget: “Azi kembunini, moneŋnini qahöwakzawaŋgöra könaŋamnini ölŋi mi göhö jege ölöp qahö köyatibin. Neŋgöreŋ lama bulmakaunini mi mewöyök gihiinga göhö buŋaya ak teköza. Nini mi pakpak azi kembunini gi gihim teköinaŋgöra nanini aka gölmenini miyök ahöm neŋgiza. Miaŋgöra mönö wania kun gihibinak? ");
INSERT INTO bmu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nini mönö könaŋi wuanöŋgöra göhö jege töndup kömumbinak? Nanini kömuinga gölmeninan mönö wuanöŋgöra öne ahöba apopam köla bölibawak? Miaŋgöra mönö nanini aka gölmenini bohonini memba miaŋön numbu nene neŋginöŋga nini ölöp Farao kiŋgö welenqeqe omaŋi ahinga gölmeninan mewöyök yaŋgö buŋaya akŋa. Neŋön toroqeba jebuk mala kömumbinbuköra mönö nene kötŋi neŋgiman. Neŋginöŋga gölme nup waŋgiinga öne qahö ahöba gönjaŋ akŋa.” ");
INSERT INTO bmu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Bödi köhöikŋi kötökŋi miaŋön Ijipt könagesö yembuk ahöyöhaŋgöra yeŋön körek mohot mohot nup gölmeŋini köröŋi mi bohonŋinaŋgöra algetka Josefnöŋ Ijipt gölme pakpak mi söŋgöröŋi meiga Farao kiŋgö buŋaya ak teköyök. ");
INSERT INTO bmu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Josefnöŋ Ijipt könagesö miri dop kantrigö jabö teteköŋi uruŋe malgeri, mi pakpak eŋgömeiga gawmangö welenqeqe omaŋi aka malget. ");
INSERT INTO bmu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Farao kiŋnöŋ jike nup galöm yeŋgö fotnait töwaŋini eŋgiiga memba miaŋön malmalŋini naŋgöba malget. Mewö aiga neneŋinaŋgöra qahö lömböriiga gölmeŋini Josefnöŋ söŋgöröŋi memapköra qahö alget. Miaŋgöra jike nup galöm yeŋgöreŋ gölme mieŋön mohot kiŋ Faraogö buŋaŋi qahö aket. ");
INSERT INTO bmu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Josefnöŋ könagesö yeŋgöra kewö jiyök: “Mötket, nöŋön nanŋini aka gölmeŋini söŋgöröŋini mem teköbiga Farao kiŋgö buŋaya akze. Miaŋgöra nöŋön nene kötŋi eŋgibiga mi ölöp memba gölmenöŋ kömötme. ");
INSERT INTO bmu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kömötketka ölŋi asuhuiga mi mönö kewötketka kambu 5 asuhugetka mieŋgöreŋök mohot mohot mi Farao kiŋgöra ala waŋgiba malmemö, kambu 4 mi kunbuk gölmenöŋ kömötmeaŋgöra aka neneŋinaŋgöra ahöma. Mi nanŋini, anöm-moröurupŋini aka tosatŋi miriŋine maljei, mönö eŋgö neneŋina ahöma.” ");
INSERT INTO bmu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Mewö jiiga kewö jiget: “Göŋön neŋgö malmalnini bödinöhök mekönöŋ. Miaŋgöra azi kembuninaŋgö jeŋe ak-kömukömu miwikŋaibin ewö, neŋön ölöp Farao kiŋgö welenqeqe omaŋi aka malbin.” ");
INSERT INTO bmu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Josefnöŋ Ijipt yeŋgö gölmegöra jimkutukutu ali ahöba kota ki ohozali, nalö kewöŋe mewöyök toroqeba ahöza. Jimkutukutu mi kewö: Nene nupkö ölŋini mi mönö mendeŋgetka kambu 5 aiga mieŋgöreŋök mohot mohot mi Farao kiŋgö buŋaya akŋapköra ala malme. Jike nup galöm yeŋgöreŋ gölme mieŋön mohot Farao kiŋgö buŋaŋi qahö aket. ");
INSERT INTO bmu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel yeŋön Ijipt gölmegö prowins qetŋi Gosen miaŋgöreŋ tatat dundumŋini memba gölme aŋgön köla malget. Miaŋgöreŋ mala ahumsehip aketka qötöŋinan gwötpuk qariyök. ");
INSERT INTO bmu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jeikobnöŋ malmalŋi yambu 17 mi Ijipt gölmenöŋ malök. Malmalŋi jömukŋaŋgö yambuŋi mi mindiriba 147 ahök. ");
INSERT INTO bmu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israelgö kömup nalöŋan dopdowiiga nahönŋi Josef jii kaiga kewö jii mörök: “Nöŋön göhö jege ak-kömukömu miwikŋaizal ewö, göŋön mönö dölki urukalem kondela keu kewö pöndaŋ wuataŋgöba mem yakömamgö jiba börögi nöŋgö tambuni bapŋe ala kewö jim jöhöman: Nöŋön kömumbiga qamötni mi mönö Ijipt gölme kiaŋgöreŋ kude löm kölman. ");
INSERT INTO bmu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nöŋön kömumba iwi asani yembuk luhut memba ahömami, nalö miaŋgöreŋ nöŋgö qamötni mi mönö Ijipt kantrinöhök memba anda iwi asani löm köl eŋgigeri, yeŋgö qaksiriŋine nesim kölman. “Mewö jiiga kewö jiyök: “Jizanaŋgö dop mi ölöp akŋam.” ");
INSERT INTO bmu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Mewö jiiga iwiŋan kewö jiyök: “Keu mi mönö jöjöpaŋ keunöŋ jim köhöim niŋgiman. “Mewö jiiga Josefnöŋ mi jöjöpaŋ keunöŋ jim köhöiiga Jeikobnöŋ mi möta bilipköba nöröpŋi memba geba öröpŋaŋgö kitipŋe ala nariba Anutugö waikŋi memba möpöseiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nalö tosatŋi teköiga Jeikobnöŋ kawöl miwikŋaiiga keu mi Josefköra jigetka mörök. Mi möta nahönyahötŋi yahöt Manase aka Efraim mi etkuaŋgita iwiŋaŋgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Aniga tosatŋan Jeikobköra kewö jigetka mörök, “Nahöngi Josefnöŋ mönö gi gekŋamgöra kaza. “Israelnöŋ keu mi möta ösumŋi ahöyöhi, mi qezaköba ahöahö dumŋeyök wahöta tarök. ");
INSERT INTO bmu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Wahöta tata Josefköra kewö jiyök: “Anutu kukösum pakpakö Toŋi yaŋön Keinan gölmegö Luz miri miaŋgöreŋ nöŋgöreŋ asuhuba kötuetköm niŋgiba ");
INSERT INTO bmu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","kewö jiyök: ‘Nöŋön ahumsehip gihibiga gwölönarökurupki yeŋgö qötöŋinan mönö qariba qariba öŋgöiga göŋön könagesö kambuŋi kambuŋi gwötpuk yeŋgö bömön jalöŋina akŋan. Gwölönarökurupki könage asuhum öŋgömei, nöŋön gölme ki mi i buŋa qem eŋgibiga yeŋgö buŋaŋina teteköŋi qahö ahöm öŋgöma.’ ");
INSERT INTO bmu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Anutunöŋ mewö jiyök. Mutuk nöŋön Ijipt gölmenöŋ göhöreŋ qahö kayalaŋgöreŋ anömgan nahönyahötki yahöt Ijipt kiaŋgöreŋ etkömeyöhi, yetkön mönö nöŋgö buŋaya akŋahot. Manase aka Efraim yetkön mönö Ruben aka Simeon ewö nöŋgö buŋaya akŋahot. ");
INSERT INTO bmu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mewö ahotka könaŋgep gölme mesiŋda yetköra distrik yahöt etkime. Efraim aka Manase yetkö bapŋire nahönböraturupki tosatŋi asuhugeri, mieŋön mönö nange buŋaya akŋe. Yeŋön gölme bahöŋini buŋa qem aŋgumei, mi mönö Efraim aka Manase yetkö distrik yahötŋiri mietkö uruŋe ahögetka bohon toŋiri ahotka datyahötŋiri yetkö nembö bapŋire malme. ");
INSERT INTO bmu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nöŋön Mesopotemia (Padan Aram) mosöta liliŋgöba Keinan gölmenöŋ kaba Efrata taon dopdowibiga anömni Reizölnöŋ kömuiga wösöbirik ketaŋi ahum niŋgiyök. Kömuiga qamötŋi mi Efrat anangö köna töwokŋe löm kölal. Efrat mirigö qetŋi alaŋi mi Betlehem.” ");
INSERT INTO bmu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israelnöŋ mewö jiba Josefkö nahönyahötŋi etkeka kewö qesim waŋgiyök: “Azi moröŋi yahöt ki daŋön daŋön?” ");
INSERT INTO bmu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Qesim waŋgiiga Josefnöŋ iwiŋaŋgöra kewö jiyök: “Nöŋgö nahönyahötni Anutunöŋ Ijipt kiaŋgöreŋ niŋgiyöhi, i mönö mia. “Mewö jiiga Israelnöŋ jiyök: “Nöŋön kötuetköm etkimamaŋgöra i ölöp etkuaŋgitnöŋga nöŋgö kösutne kamahot.” ");
INSERT INTO bmu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mewö jiiga Josefnöŋ nahönyahötŋi etkuaŋgita kösutŋe kagetka böröŋi giliga imbiŋire geiga numbuŋiri yöhötim neyök. Israelnöŋ azi namŋi aiga jeŋi ömuŋ köliga yuai kun ek kutumamgö tönpin aka osiyök. ");
INSERT INTO bmu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Numbuŋiri yöhötim nemba Josefköra kewö jiyök: “Nöŋön mutuk göhö jemesoholgi kunbuk gekŋamgöra qahö al mamböta malalmö, Anutunöŋ köna mesariga dölki nangi aka nahönyahötki mewöyök eŋgekzal.” ");
INSERT INTO bmu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Mewö jiiga Josefnöŋ nahönyahötŋi iwiŋaŋgö tambuŋeyök etkömemba simin köla bamgöba geyök. ");
INSERT INTO bmu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Bamgöba geba wahöta nahönyahötŋi böröŋire memba etkuaŋgiriga nanŋi iwiŋaŋgö wösöŋe kayohot. Efraim mi böröŋi ölŋan memba Israelgö böröŋi qaniŋe ala Manase mi böröŋi qaniŋan memba Israelgö böröŋi ölŋe alök. ");
INSERT INTO bmu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mewö al etkiyökmö, Efraim munŋi aiga asaŋan töndup böröŋi ölŋan böraŋda yaŋgö nöröpŋe alök. Manasenöŋ Josefkö nahönŋi mutukŋi ahökmö, asaŋan töndup böröŋi qaniŋan yaŋgö nöröpŋe alök. Mewö aka böröŋi maripom ewö al kutuba nöröpŋire alök. ");
INSERT INTO bmu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Mewö ala tata Josef kötuetköm waŋgiba kewö jiyök: “Asani Abraham aka iwini Aisak yetkön Anutugö jeŋe anda kaba aka memba malohot. Nöŋön asuhuba mala korali, Anutunöŋ mönö nalö miaŋgöreŋ pöndaŋ köyan köl niŋgiba mala korök. ");
INSERT INTO bmu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Suep garatanöŋ ni bölöŋi pakpak miaŋgöreŋök meköba aŋgön köl niŋgiba malöhi, yaŋön mönö azi gwabö yahöt ki kötuetköm etkiba malma. Ambazipnöŋ yetkö qetŋiri qetketka miaŋön mönö ni aka iwi asani Aisak aka Abraham neŋgö qetbuŋanini bisiba malmahot. Yetkö könagesöŋiran mönö gölme qakŋe önöŋi qahö sehiba malme.” ");
INSERT INTO bmu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mewö jiyökmö, Josefnöŋ iwiŋan böröŋi ölŋan Efraimgö nöröpŋe ali mi ehi dop qahö köliga miaŋgöra möt böliba iwiŋaŋgö böröŋi ölŋe memba Efraimgö nöröpŋeyök meköba Manasegö nöröpŋe almamgö ahök. ");
INSERT INTO bmu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Mewö aka iwiŋaŋgöra kewö jiyök: “Iwini, mewö kude aknöŋ. Morö kiaŋön nahöni mutukŋi akza. Miaŋgöra börögi ölŋan mönö yaŋgö nöröpŋe alnöŋ.” ");
INSERT INTO bmu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mewö jiyökmö, iwiŋan mi akŋamgö qetala Josef kewö jii mörök: “Nahöni, mi ölöp mötzal. Nöŋön mi mötzal. Manasenöŋ mewöyök qetbuŋaŋambuk aiga yaŋgö gwölönarökurupŋan mewöyök ahumsehip aka könagesö ketaŋi akŋemö, Efraimgö qetbuŋaŋan mönö Manasegöreŋ qetbuŋa oŋgita ahöma. Yaŋgö gwölönarökurupŋan mönö ahumsehip ketaŋi aka könagesö kambuŋi kambuŋi gwötpuk aka malme.” ");
INSERT INTO bmu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Mewö jii möriga silim miaŋgöreŋök kötuetköm etkiba kewö jiyök: “Israel yeŋön mönö etkö qetŋiri qeta könagesöŋini kötuetköm eŋgiba kewö jime: Anutunöŋ mönö oyaeŋkoyaeŋ ak eŋgiiga eŋön Efraim aka Manase ewö akŋe. “Mewö jiba Manase mi Efraimgö nembö bapŋe alök. ");
INSERT INTO bmu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israelnöŋ kötuetköm eŋgii teköiga Josefköra keu kewö jiyök: “Mötnöŋ, nöŋön kömumamgö akzalmö, Anutunöŋ embuk mal öŋgöma. Yaŋön mönö eŋguaŋgiriga iwi asaurupŋini yeŋgö gölmenöŋ liliŋgöba anme. ");
INSERT INTO bmu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Miaŋgöreŋ anda sutŋine gölme mesiŋgetka nöŋön göhö gölmegi toroqeba Sekem gölme kelökŋambuk mi gihizal. Nöŋön kukundu gölme mi Amor könagesö yembuk bim qeba nani timbi aka bimgö sou ketaŋi miaŋön yeŋgöreŋök meal. Josef gi darumunurupki yeŋgö bohonŋini akzanaŋgöra mi darumunurupki yeŋgöra qahöpmö, göhö buŋaya jim teköbi ahöma. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Miaŋgö andöŋe Jeikobnöŋ nahönurupŋi eŋgoholi kagetka keu kewö jiyök: “Iŋini mönö öröm tokogetka nöŋön malmalŋine könaŋgep denöwö asuhumawi, miaŋgö kezapqetok keuŋi indela jibi mötme. ");
INSERT INTO bmu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Jeikobkö nahönurupŋi, iŋini mönö kaba tokoba iwiŋini Israelgöreŋ keu kezap ala mötket. ");
INSERT INTO bmu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","O Ruben, göŋön nani nahöni mutukŋi akzan. Göŋön nöŋgö ösum-mumuni aka ambi membiga ösumnaŋgö ölŋi mutukŋi asuhunöŋ. Qetbuŋagahö aködamunŋi aka kukösumŋi miaŋön mönö munurupki yeŋgöreŋ eŋgoŋgitza. ");
INSERT INTO bmu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Luhutnöŋ köwet siri kunduriga kalöpmalöp anda kamakzawi, göhö urugan mönö miaŋgö dop wahöri kalöpköba laŋ anda kamakzan. Göŋön iwigi nöŋgö ahöahö dumne öŋgöba qömböŋne qeba anömnambuk ahönöŋga dum miaŋön mönö aŋgöjörakŋambuk aka tölohoyök. Miaŋgöra göhö qetbuŋagahö aködamunŋan mönö munurupki qahö toroqeba eŋgoŋgita ahöma. ");
INSERT INTO bmu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon aka Liwai yetkön darumuna akzahot. Yetkö timbi liŋgip nupŋiran mönö kegwek kahasililiŋ kondorakza. ");
INSERT INTO bmu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Yetkön irimsesewöl qakŋe azi eŋguyohot kömugetka öne töhön sihimŋaŋgöra bulmakau aziŋi mieŋgö köna börö yuaiŋini laŋ eŋgum yandiyohotka poriŋ aket. Miaŋgöra yetkön keu goro jöhömakzahori, nöŋön miambuk urumohot qahö ahakzal. Totoko almahori, nöŋön miaŋgöreŋ yetpuk qahö toroqeba tatmam. ");
INSERT INTO bmu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Urukazikŋiran könöpŋambuk akzawaŋgöra i jim qesuahöm etkizal. Urusiŋgokŋiran kanjamŋambuk akzawaŋgöra i jim jörahöm etkizal. Nöŋön könagesöŋiri köndeŋ eŋgibiga yeŋön Jeikobkö gölme dop köla anme. Nöŋön mendeŋ eŋgibiga yeŋön Israel sutŋine laŋ lalöpköba malme. ");
INSERT INTO bmu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","O Juda, göhö darumunurupkan gi möpöseim gihiba malme. Göhö börögan mönö kerökurupki yeŋgö imbi jölŋine tatma. Iwigahö nahönurupŋi yeŋön mönö göhöra geba simin köla malme. ");
INSERT INTO bmu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O Juda, göŋön laion gwaböŋi ewö maljan. O nahöni, gi böröjaŋ suhuba sömbup qem nemala miaŋgöreŋök liliŋgöba kazan. Yaŋön laion ewö sileŋi al kötöteiba laion ambiŋi ewö eta köla ahömakza. Körekŋan i suahö aka utuba möndöbingö keŋgötŋini mörakze. ");
INSERT INTO bmu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kukösumgö aiwesökŋi mi kunŋan Juda yeŋgö böröŋineyök qahö eŋguaŋgitma. Azi kembugö öröpŋan könaŋi sutŋire kiniga kunŋan mi qahö qeköma. Nanŋi aka gwölönarökurupŋan jakömbuak dumŋe tata mal öŋgögetka könaŋgep kunöŋ asuhuiga könagesö kambuŋi kambuŋi yeŋön yaŋgö jitŋi tem köla malme. ");
INSERT INTO bmu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yaŋön doŋkiŋi wain ip kembaŋe jöhöi kinma. Doŋkiŋi moröŋi mi wain kösö sutŋire gwaröhöiga ahöma. Yaŋön opoŋi mi wain oŋan saŋgoŋma. Malukuŋi mi wain kötŋaŋgö sepŋe kusahöla közöhölma. ");
INSERT INTO bmu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Wain o neiga jeŋan wain oŋi ewö pisihiba injaŋ kölma. Juzu oŋi neiga jitŋan juzu oŋi ewö tuarima. ");
INSERT INTO bmu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun könagesö yeŋön köwet jitŋe malme. Yeŋgö gölmenöŋ waŋgeŋi waŋgeŋi surumakŋe. Gölmeŋinaŋgö jaböŋi miaŋön mönö Saidon taonöŋ göröken anda ahöma. ");
INSERT INTO bmu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar mi doŋki sihitŋi kotkotŋi miaŋgö dop akza. Doŋki qakŋe dum tatatkö gösöŋi yahöt mietkö sutŋire al kötöteiba lokoliba söloŋda ahömakza. ");
INSERT INTO bmu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Lokoliba söloŋda luhut memba ahöiga dum miriŋi mi ölöp dop köliga gölmeŋan sihim kötökŋi akŋa. Mi eka andöŋi yuai lömbötŋi aŋgumamgöra sipköba geiga tosatŋan welenqeqe nup memapköra kuŋguba jöhöm waŋgime. ");
INSERT INTO bmu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Tosatŋan Dangö könagesöurupŋi mulumgöm eŋgigetka Dan yaŋön mönö awörök aka keu diŋdiŋaŋgöra bim qeba malma. Dan kambu yeŋön Israelgö kambu tosatŋi i ewö aka malme. ");
INSERT INTO bmu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan yaŋön qatö mokoleŋ ewö könanöŋ ahöba hosgö gwakötŋe yöhöiga töwöratiba giliga qakŋe tatmawaŋön mönö tala andöandö gölmenöŋ gema. ");
INSERT INTO bmu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Kembu, göŋön ni kösö gwarönöhök meköba aŋgön köl niŋgimangöra uba mambörakzal. ");
INSERT INTO bmu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kegwek kahasililiŋ kambu yeŋön Gad könagesö eŋgum ohoba malmemö, Gad yeŋön mönö meleŋda könaŋine eŋguataŋgöba nanŋini eŋgum ohoba malme. ");
INSERT INTO bmu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asergö gölmenöŋ nene möriam gwötpuk asuhumakŋa. Kiŋ yeŋön nene nahömŋinambuk nemakzei, yaŋön mönö nene mewöŋi mi gölmeŋe kömöt sehiba miaŋön tosatŋi bauköm eŋgiba malma. ");
INSERT INTO bmu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Teunöŋ sihimŋaŋgö dop ösumŋan laŋ lalöpkömakzawi, Naftalinöŋ mönö miaŋgö dop aka moröurupŋi eŋgeksihimŋinambuk eŋgömemba malma. ");
INSERT INTO bmu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Wain ip o jeŋaŋgö kösutŋe kömötketka kötŋi gwötpuk kuŋguba böröŋi giliga anda sel qösököba yaigep anakzawi, Josefnöŋ mönö miaŋgö dop akza. ");
INSERT INTO bmu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Yaŋgö kerökurupŋan timbi jaugemŋini memba urukönöp qakŋe Josefkö kambu mi eŋguataŋgöba eŋgeriba eŋgum ohoba malme. ");
INSERT INTO bmu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mewö malmemö, Jeikobkö bemŋi Anutu kukösumŋambuk yaŋgö böröŋan mönö mem köhöim waŋgiiga yaŋön timbi töhötŋi qahö mosöta börö sihitŋi kakŋi qahö qeiga malma. Anutu yaŋön mönö urugö lama galömŋi aka Israelgö aŋgönkölköl Toŋi akza. ");
INSERT INTO bmu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Iwigahö Anutuŋan mönö bauköm gihiba malma. Bem kukösum pakpakö Toŋan mönö kewö kötuetköm gihiiga malman: Kiegö kötumötuetŋan mönö könakembayök göhöreŋ eriga gölme dutŋi emuyaŋgö oŋan göhöreŋ koriga nahönbörat aka sömbup gwötpuk miwikŋaim eŋgiba malman. ");
INSERT INTO bmu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Kunduŋi kunduŋi mieŋgö kötumötuetŋinan nalöŋi nalöŋi ambazip dop köl eŋgii mala kotket. Kunduŋaŋgö sörökŋe yambu dop nene nupŋini memba malgetka nene möriam asuhui mala kotketmö, göhö iwigahö kötumötuetŋan mönö mi pakpak oŋgitza. Kötumötuet mieŋön mönö Josefkö nöröp qakŋe öŋgöme. Darumun sutŋine pom jembon tök-kutukutuŋi akzawaŋgö malmalŋe mi pakpak mönö ahöm öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin mi kiam kalŋi ewö akza. Söŋan dop böröjaŋ suhuba sömbup eŋguba nem gwahöt eŋgimakza. Silimnöŋ yuai kiom qemakzawi, mi suŋgem dop mendeŋmakza. “Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Israelgö kambu pakpak jaŋgöŋini 12 mi mewö. Iwiŋinan kötuetköm eŋgiba keu mewö mewö jiiga mötket. Kötumötuetŋini murutŋi murutŋi mi nanŋök nanŋök mendeŋda körek kötuetköm eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kötuetköm eŋgiba kinda keu kewö jim kutum eŋgiyök: “Anutunöŋ mönö noaŋgiri nöŋön isik alaurupnan kömugeri, yembuk toroqemamgö akzal. Nöŋgö qamötni mi mönö iwiurupni yeŋgö qöhöröŋine baŋet Hit azi Efrongö gölme köröŋe ahözawi, miaŋgöreŋ löm köl niŋgime. ");
INSERT INTO bmu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Baŋet mi Keinan gölmenöŋ Makpela gölme köröŋe Mamre kösutŋe ahöza. Abrahamnöŋ gölme köröŋi baŋetŋambuk mi isikninaŋgö qaksiriŋi ahömapköra Hit azi qetŋi Efron yaŋgöreŋök söŋgöröŋi meyök. ");
INSERT INTO bmu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham aka anömŋi Sara mi baŋet miaŋgöreŋ löm köl etkiget. Mewöyök Aisak aka anömŋi Rebeka mi miaŋgöreŋ löm köl etkiget. Nöŋön toroqeba Lea miaŋgöreŋ löm köl waŋgial. ");
INSERT INTO bmu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Abrahamnöŋ gölme köröŋi baŋetŋambuk mi mutuk Hit yeŋgöreŋök bohonŋi meiga ahöza.” ");
INSERT INTO bmu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jeikobnöŋ nahönurupŋi keu mewö jim kutum eŋgim teköba könayahötŋi öröi ahöahö dumnöŋ öŋgöiga nöŋ qeba kömuiga Anutunöŋ waŋgiri isik alaurupŋi yeŋgöreŋ toroqeyök. Mewö.");
INSERT INTO bmu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jeikobnöŋ kömuiga Josefnöŋ luhuba iwiŋi kepölaköm waŋgiba lipköba anda imbiŋi gili geiga numbuŋi yöhötim neyök. ");
INSERT INTO bmu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Miaŋgö andöŋe Josefnöŋ doktaurupŋi jimkutukutuŋaŋgö bapŋe malgeri, mi iwiŋaŋgö qamötŋi sile mem köhököhöi kelöknöŋ mirimegöra jim kutum eŋgiyök. Jim kutum eŋgiiga yeŋön Israelgö qamötŋi mewö ak waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Nup mi memba malgetka wehön 40 jömuk teköyök. Qamötŋini kelöknöŋ mirizema, miaŋgö nupŋi mi nalö köröpŋi mewö memba maljema. Ijipt könagesö yeŋön Jeikobköra wehön 70:gö dop jiŋgeŋ köla sahöta malget. ");
INSERT INTO bmu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sahöta jiŋgeŋ köla wösöbirik malgeraŋgö nalöŋi miaŋön teköiga Josefnöŋ Farao kiŋgö jakömbuak mire nup memba malgeri, yeŋgöra keu kewö jiyök: “Nöŋön eŋgö jeŋine ak-kömukömu miwikŋaial ewö, iŋini mönö nöŋgö jitne memba Farao kiŋgöra keu kewö jigetka mötma: ");
INSERT INTO bmu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Iwinan jebuk mala keu kewö jöhöba jöjöpaŋ keunöŋ jim köhöimamgöra jim kutum niŋgiyök: ‘Nöŋön kömumamgö akzal. Ni nanaŋgöra köt köteŋ Keinan gölmenöŋ esibi kinjawi, nöŋgö qamötni mi mönö miaŋgöreŋ anda löm kölman.’ Miaŋgöra ölöp merak jinöŋga nöŋön miaŋgöreŋ anda iwinaŋgö qamötŋi löm kölagun kunbuk liliŋgöba kamam.” ");
INSERT INTO bmu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Mewö jii jigetka Farao kiŋnöŋ mi möta kewö jiyök, “Gi iwigahöra keu jöhöba jöjöpaŋ keunöŋ jim köhöinöŋi, miaŋgö dop ölöp anda iwigahö qamötŋi löm kölman.” ");
INSERT INTO bmu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Mewö jiiga Josefnöŋ iwiŋaŋgö qamötŋi löm kölmamgöra öŋgöyök. Farao kiŋgö jembonurupŋi qetbuŋaŋinambuk pakpak, jakömbuak miriŋaŋgö aka Ijipt kantrigö jitŋe memeurupŋi qetbuŋaŋinambuk mi körek yambuk mohotŋe anget. ");
INSERT INTO bmu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Josefkö mirigö saiwaurupŋi körek pakpak, yaŋgö darumunurupŋi aka iwiŋaŋgö könagesöurupŋi yeŋön mewöyök mohotŋe anget. Anöm-moröurupŋini, lama, meme aka bulmakau kambuŋi kambuŋi miyök mönö eŋgömosötketka Gosen gölmenöŋ tatket. ");
INSERT INTO bmu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Hosgö kareŋi kareŋi aka azi hos qakŋine tatkeri, mi mewöyök anget. Mewö mindiriba kambu keta bölökŋi anget. ");
INSERT INTO bmu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Anda mala Jordan o kutuba likepŋe toroqeba anda Atad mire wit padigö ölŋi aka kamböŋi mendeŋda kewötkeri, miri gölme miaŋgöreŋ aŋgota köhöikŋanök jiŋgeŋ köla silata sahöt böliba malget. Josefnöŋ iwiŋaŋgöra wehön 7:gö dop jiŋgeŋ köla sahöta malök. ");
INSERT INTO bmu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Atad mire jiŋgeŋ köla sahötketka gölme toŋi Keinan könagesö yeŋön mi eka möta kewö jiget, “Ijipt yeŋön jiŋgeŋ sahötkö areŋi öŋgöŋgöŋi alje. “Mewö jigetka miri gölme miaŋgö qetŋi mi könahiba Abel Mizraim qetket. Mi Jordan ogö wehön kotkotŋe ahöza. ");
INSERT INTO bmu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jeikobnöŋ nahönurupŋi jim kutum eŋgiyöhi, yeŋön miaŋgö dop mewö ak waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Yeŋön qamötŋi aŋguba Keinan gölmenöŋ anda Mamre kösutŋe Makpela gölme köröŋe baŋet ahözawi, miaŋgöreŋ anda löm kölget. Abrahamnöŋ mutuhök gölme köröŋi baŋetŋambuk mi qaksiriŋini ahömapköra Hit azi Efron yaŋgöreŋök söŋgöröŋi meyök. ");
INSERT INTO bmu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Josefnöŋ iwiŋaŋgö qamötŋi löm köli teköiga nanŋi, darumunurupŋi aka tosatŋi pakpak yambuk iwiŋaŋgö qamötŋi löm kölbingö angeri, mieŋön kunbuk Ijipt gölmenöŋ liliŋgöba kaget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Josefkö darumunurupŋan iwiŋinan kömuiga mi eka tata kewö mötmöriba jiget: “Josefköra silik bölöŋi pakpak ak waŋgiini, yaŋön miaŋgöra urukondum möt neŋgiba nalö kewöŋe könahiba likepŋi meleŋ neŋgibapuk.” ");
INSERT INTO bmu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Mewö jiba Josefköra keu jit kewö algetka anök, “Iwigan kömumamgö aka neŋgöra keu kewö jim kutuyök: ");
INSERT INTO bmu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Iŋini mönö Josefköra keu kewö jigetka mötma: Darumunurupkan silik bölöŋi aka ayuhum gihibingö akeri, göŋön mönö yeŋgö siŋgisöndokŋini aka kahasililiŋini mi mosötman. Miaŋgöra göŋön ölöp iwigahö Anutuŋaŋgö welenqeqeurupŋi neŋgö siŋgisöndoknini mosötman. “Yeŋön keu jit mi algetka Josefköreŋ kaiga möta mönö qeta sahörök. ");
INSERT INTO bmu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Miaŋgö andöŋe Josefkö darumunurupŋan nanŋinak kaba gölmenöŋ tala wösöŋe sipköba eta kewö jiget: “Mötnöŋ, nini göhö welenqeqeurupki omaŋi akzin.” ");
INSERT INTO bmu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mewö jigetmö, Josefnöŋ meleŋda kewö jiyök: “Mönö keŋgötŋini kude mötme. Nöŋön Anutugö salupŋe qahö kinjal. ");
INSERT INTO bmu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ölŋa, eŋön silik bölöŋan ayuhum niŋgibingöra kapaŋ köla aketmö, Anutunöŋ mi möŋaiiga salupŋe yuai ölöpŋi asuhumapköra kapaŋ köla ahök. Mewö aka kondota kuŋgum niŋgiiga könagesö gwötpuk eŋgö malmalŋini jöhöbiga miaŋgö ölŋan nalö kewöŋe aukŋe asuhuiga ek kutuzin. ");
INSERT INTO bmu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Miaŋgöra mönö keŋgötŋini kude mötket. Nöŋön mönö nanŋini aka anöm-moröurupŋini eŋgö malmalŋini körek naŋgöm eŋgiba malmam. “Mewö jiba bölöŋamŋinaŋgö likepŋi qahö meleŋmamgö kunbuk jim köhöiba guŋböjönjöŋ ak eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josefnöŋ iwiŋaŋgö könagesöurupŋi yembuk toroqeba Ijipt gölmenöŋ malget. Josefnöŋ mal öŋgöiga yambuŋi 110 aiga kömuyök. ");
INSERT INTO bmu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josefnöŋ isi amböurupŋi Efraimgöreŋök asuhugetka mi eŋgehök. Mewöyök Manasegö nahönŋi Makir yaŋgö nahönböraturupŋi asuhugetka Josefkö tambuŋe al eŋgigetka dohongöm eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Miaŋgö andöŋe Josefnöŋ darumunurupŋi yeŋgöra keu kewö jii mötket, “Nöŋön kömumamgö akzalmö, Anutunöŋ mönö köyan köl eŋgiiga malme. Yaŋön iŋini gölme kiaŋgöreŋök eŋguaŋgita gölme Abraham, Aisak aka Jeikob yeŋgö buŋaŋina akŋapköra jim teköba jöjöpaŋ keunöŋ jim köhöiyöhi, mönö miaŋgöreŋ anda malme.” ");
INSERT INTO bmu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Mewö jii mötketka Israelgö nahönurupŋan keu jim jöhöba jöjöpaŋ keunöŋ kewö jim köhöimegöra jim kutum eŋgiyök: “Anutunöŋ köyan köl eŋgii malgetka nöŋön kömumbiga nöŋgö sihitni mi mönö gölme kiaŋgöreŋök aŋguba Keinan gölmenöŋ anme.” ");
INSERT INTO bmu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Mewö jiba yambuŋi 110 aiga kömuyök. Kömuiga Ijipt miaŋgöreŋ qamötŋi mi sile mem köhököhöigö kelökŋan miriba qamöt bokisnöŋ algetka ahöyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Walahok Israel uruŋe kiŋ kun qahö maliga aiwi kembu yengön könagesö galim köl engiwa malget. Nalö miaŋgöreŋ bödi hikŋaiwa balöŋ patpat söp köla ahöyök. Bödi nalö miaŋgöreŋ Juda aiwi kunöŋ anömŋi hala nahönweitŋi engaŋgita taonŋini Betlehem mosota kantri qetŋi Moab miaŋgöreŋ anda dum tatatŋini möhamgöwa kiana malget. ");
INSERT INTO bmu_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Aiwi qetŋi Elimelek, anömŋi qetŋi Naomi hala nahönweitŋiri qetŋiri Malon hala Kilion. Balöŋini qetŋi Efrata. Yengön taonŋini Betlehem mosota Moab balöŋnöŋ anda miaŋgöreŋ malget. ");
INSERT INTO bmu_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Miaŋgöreŋ malgetka Naomikö apŋi Elimeleknöŋ komuyök. Komuiga Naominöŋ anbi malöya hala nahönweitŋe malget. 4Nahönweitŋi yetkön mala qariwa Moabkö anbi weit qetŋiri Orpa hala Rut ");
INSERT INTO bmu_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","muewö malget: Tamar, Rahab, Rut hala Batseba. Mat 1,3-6 etkömeyöwöt. Etkömeyöwötka toroqemba Moab balöŋnöŋ yambu 10:gö söp mala kutket. ");
INSERT INTO bmu_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mala kuta nahönweitŋi weit Malon hala Kilion yetkön mewöyök komuyöwöt. Komuyöwötka namönŋiri Naomi yaŋgön apmeröŋi qahö nanŋök malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naominöŋ nanŋok Moab kantrinöŋ mala nalö kunöŋ buzup keu muewö zöget mörök: ‘Kembunöŋ könagesöŋi bauköm engiwa Israel miaŋgöreŋ numbu nene ölip miwikŋaim engimamja.’ Mewö möta Moab mosota Israel balöŋe liliŋgöwa anmamgöra mem mözözöm hali iranweitŋi yetkuk wahötket. ");
INSERT INTO bmu_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Wahöta köhöm balöŋ malöhi, mihi mosota Juda balöŋnöŋ liliŋgöwa anmamgöra haliga iranweitŋi yetkuk mohotŋe könanöŋ anget. ");
INSERT INTO bmu_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Könanöŋ andaga Naominöŋ iranweitŋi muewö etkezöyök: “Anbiweit, etkön mönö liliŋgöwa namönweitŋiri yetkö köhömnöŋ anda malmawöt. Etkön nöŋgö apmeröni komugeri hala ni nengöra ölipŋanök ala hal nengiwa malöwötka Kembunöŋ mönö miaŋgö söp likepŋi meleŋda ölipŋanök hal komum etkiiga malme. ");
INSERT INTO bmu_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Kembunöŋ ölip köna meiga iŋiri aiwi kunduk etkömimba malmal tatatŋiri yetkö köhömnöŋ miwikŋaiwa urusösöŋgai qakŋe malmawöt.” Mewö zömba numbuŋiri etköhötim neyöknöŋ, yetkön amburereŋ hala silata sahöröwöt. ");
INSERT INTO bmu_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Sahöta muewö zöyöwöt: “Qahöwi! Niri mönö gowuk liliŋgöwa göhö könagesö kiripki yengöreŋ anbin.” ");
INSERT INTO bmu_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Mewö zöyöwötka meleŋda muewö etkezöyök: “O iranweitni, mönö nöpaköra noŋguk kambitkö halzawöt? Nöŋgön kunduk merö nahönweit membiga qariyöwötka etkömembawörak me? Mewö römöngöwawörak ewö, miaŋön qahö söpköza. Qahöpmahöp! Mönö dölmuhu liliŋgöwa anmawöt. ");
INSERT INTO bmu_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Ni anbi namönŋi halzalaŋgöra aiwi kunŋan qahö nömima. O iranweitni, etkön mönö liliŋgöwa köhömŋire anöwöt. Ni kunduk aiwi memamgö römöngöwa erap suŋgem aiwi kunguk ahöwa köriguk hala nahönweitni etkömembileŋak ewö, tondup mihi lömböriza. ");
INSERT INTO bmu_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Merö mietkön qariyöwötka apweitŋira etkimamgö mamböta malmawörak me qahöpto? Yetköra hala aiwi memekö könaŋiri jöhöm aŋguwa nalö köripŋi sutŋi mihi mönö in malmawötkuk. Miŋgi qahö söpköza. O iranweitni, mewö qahö. Kembunöŋ biriŋi böraŋda qeköm niŋgiiga apnan komuiga miaŋgöra malmalninan lömböriiga nöŋgön etköra wösöjiŋjiŋni mötzal.” ");
INSERT INTO bmu_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Mewö zöiga dumŋe kunduk silata sahöröwöt. Sahöröwöt teköiga Orpanöŋ iranŋaŋgö yaizözökŋi zömba numbuŋi yöhötim nemba eleŋda köhömŋe anök. Orpanöŋ anöknöŋ, Rutnöŋ kapaŋ köla sele köpaŋe mösölatiyök. ");
INSERT INTO bmu_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Mewö mösölatiiga Naominöŋ muewö ezöyök: “Mötnöŋ, kasungan anja. Yaŋgön nanŋi bemŋi hala nanŋi anbazip kiripŋi yengöreŋ anja. Gi mönö mewöŋanök eleŋda köhömge anöŋ.” ");
INSERT INTO bmu_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Mewö zöyöknöŋ, Rutnöŋ tondup muewö meleŋnök: “Ni gi gomosotmamgö de kapaŋ köla zöman. Ölip zönöŋga gowuk anbit. Gi denike denike anmani, nöŋgön mönö mewöyök gowuk miaŋgöreŋ anmam. Gi denike denike malmani, nöŋgön mönö mewöyök miaŋgöreŋ malmam. Göhö anbazip kiripki miŋgi mönö nöŋgö anbazip kiripna halgetka göhöreŋ Anutu mihi mönö nöŋgöreŋ Anutuya hali malmam. ");
INSERT INTO bmu_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Gi denikeaŋgöreŋ komumani, nöŋgön mönö mewöyök miaŋgöreŋ mohok komumbi löm köl niŋgimeköra mötzal. Keu mihi muewö zöm köhöimam: Komup mohotnöŋ mönö mendeŋ netkima. Iwai mörötŋi kunöŋ mendeŋ netkima ewö, Kembunöŋ ölip miaŋgö likepŋi meleŋniga nöŋgö qakne öŋgöma.” ");
INSERT INTO bmu_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Mewö zömba yaŋguk anmamgö köhöikŋanök kapaŋ köliga ekta möt qitiwa miaŋgö keuŋi kunduk qahö zöyöknöŋ, ");
INSERT INTO bmu_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","mohotŋamŋire anda mala Betlehem taonöŋ kauröwöt. Kauröwötka taongö anbazip patpat yengön i etkekta sösöŋgai ketaŋi möta tokoget. Anbi yengön qeta Naomikö yaizözökŋi muewö zöget: “Hei! I halakŋa Naomiya me denöwö? Oe oe oe!” ");
INSERT INTO bmu_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Mewö zögetka Naominöŋ muewö zöyök: “Nöŋgö qetni Naomi miŋgi in de qetme. Ni urusösöŋgai anbia qahö. Anutu kukosum Touŋan mönö kondot niŋgiiga urukombuk möta malzal. Miaŋgöra nöŋgö qetni Mara qetketka söpköma. ");
INSERT INTO bmu_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Nöŋgöreŋ iwai kombuŋi ahöiga mutuk taon muhu mosota analnöŋ, erap Kembunöŋ naŋgiriga biribörak liliŋgöwa omaŋe kazal. Kembu kukosum Touŋan keuni kewöta mem kirehöm niŋgiiga köŋjiliŋ qakŋe malzal. Miaŋgöra qetni Naomi mihi in de qetme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Naomi hala iranŋi Rut, Moab anbi miaŋön Moab mosota Betlehem taonöŋ kayöwöri, nalö miaŋgöreŋ anbazipnöŋ könahiwa padikö alaŋi bali miŋgi nupŋine koholget. ");
INSERT INTO bmu_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomikö apŋi Elimelekö isik uruŋe tinitosolomŋi aiwi qetbuŋaŋaŋguk kun qetŋi Boaz malök. ");
INSERT INTO bmu_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Nalö kunöŋ Moab anbi Rut yaŋgön iranŋi Naomikö muewö ezöyök: “Ölip zöm tekönöŋga nöŋgön nup kunöŋ anda anbazip bali ipŋi kohola iriremönŋi mosoramjei, mihi qendaŋda tokomam. Ni ölip aiwi kungö jeŋe eksihim miwikŋaiwiga ‘Oŋ!’ zöiga ölip yaŋgö andöŋe anda mihi tokomam.” Mewö zöiga Naominöŋ zöyök: “O böratni, ölip anman.” ");
INSERT INTO bmu_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Mewö zöiga mosota nup kun dahöreŋ nuwa, mihi qahö mötaga tondup laŋ anda kinda bali koholgetka yengö andöŋine anda ipŋi mohok mohok qeqelaŋlaŋ heta ahögeri, mihi qendaŋda qendaŋda anök. Nup köriŋe anöhi, mihi Boaz, iranŋi Elimelekö isiknöhök kun yaŋgöreŋ nuwa ahöyök. ");
INSERT INTO bmu_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Yaŋgön dölmuhu Betlehemök kauta nup anbazipŋi engeikta yaizözökŋini muewö zöyök: “Bönjöŋ! Kembunöŋ enguk malma.” Mewö zöiga meleŋda muewö qetket: “Kembunöŋ mönö kötuetköm gihima.” ");
INSERT INTO bmu_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Mewö qetketka Boaznöŋ nup galimŋi muewö qesiyök: “Anbi mihi dahön?” ");
INSERT INTO bmu_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Mewö qesiiga muewö meleŋnök: “Anbi mihi köriwengöra. I Naomiguk Moab kantrinöhök kayöwöt. ");
INSERT INTO bmu_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Yaŋgön söŋan hömandiŋe kamba qesim niŋgiiga ölip zömbiga nup anbazip yengö könaŋine engohorata bali ipŋi qendaŋda tokoza. Nup pöndaŋ memba malzawa döldimuhu koumnöŋ endu anda luhut memba tatza.” ");
INSERT INTO bmu_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Mewö meleŋniga Boaznöŋ Rutköra muewö zöyök: “Böratni mötnöŋ, nöŋgön keu goroya kun gihimam: Gi nup muhu de mosota tosatŋi yengö nupŋine qahö anda bali memba tokoman. Mönö nöŋgö welenqeqe anbiurupni yenguk mohotŋe muyaŋgöreŋ qendaŋda malman. ");
INSERT INTO bmu_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ni nup aiwiurupnan gömisiriwekuköra soŋgo halzal. Nup denike denike anda padi koholmei, gi mönö miaŋgö jegalim hala yengö andöŋine anda anbi yenguk malman. Ougaŋgö mötman ewö, welenqeqe yengön ou köwöraŋgenöŋ huzei, ölip miaŋgöreŋ anda ou neman.” ");
INSERT INTO bmu_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Mewö zöiga Rutnöŋ mihi möta balöŋnöŋ gewa bamgöwa Boazköra muewö zöyök: “Ni denöwököra kian mala tondup göhö jege halkomukomu miwikŋaiwiga mewö köyan köl niŋgizan?” ");
INSERT INTO bmu_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Mewö zöiga muewö meleŋnök: “Nöŋgön göhö ambamemegaŋgö sundutŋi mihi körek zögetka mötzal. Göhön apkan komuiga irangi ölip galim köla mala kutnöŋ. Göhön namönmamgi hala hikŋaihikŋai kantrigi mihi mosota anbazip walak qahö möt nenginöŋi, nengö sutŋine kamba malzan. ");
INSERT INTO bmu_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Göhön saiwaurupki ölipŋi hal enginöŋga Anutu Israel nengö Kembuninan mönö miaŋgö töwaŋi gihima. Kuruknöŋ ginginŋan meröurupŋi kölközizip hal engimamjawi, miaŋgö söp göhön Anutukö aumŋe malmamgöra muhu kanöŋ.” ");
INSERT INTO bmu_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Mewö zöiga Rutnöŋ muewö meleŋnök: “Ketaŋamni, ni göhö nup meme anbiurupki yengö söp qahöpnöŋ, göhön tondup ölipŋi hal niŋgizan. Göhön keu nuŋgunöŋga seleni pösatza.” Mewö meleŋnök. ");
INSERT INTO bmu_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Numbu nene nalöŋan kaiga Boaznöŋ Rutköra muewö zöyök: “Ölip muhu kamba bered muŋgu memba kasaknöŋ kundumgöwa neman.” Mewö haliga nup anbazip yenguk tariga Boaznöŋ bali ohomqitiqitiŋi mihi waŋgiyök. Mihi waŋgiiga neiga tomeŋi juliga nene tosatŋi mosota tarök. ");
INSERT INTO bmu_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Tata wahöta anda toroqemba bali ipŋi qendaŋniga Boaznöŋ nup aiwiurupŋi muewö zöm qitim engiyök: “Yaŋgön bali ipŋi mihi böran mieŋgö sutŋine miaŋgöreŋ mewöyök qendaŋda tokoma ewö, iŋini mönö keu töhöreŋ de zöm waŋgime. ");
INSERT INTO bmu_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Mewö qahöpnöŋ, bali ipŋi tosatŋi mihi böranŋineyök mewöyök höröwa halget heriga kamba nanŋaŋgöra mem tokoma. Iŋini i de zöm waŋgime.” ");
INSERT INTO bmu_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Mewö zöm qitim engiiga Rutnöŋ bali ipŋi qendaŋda tokoi öŋgöiga hölŋi hala kamböŋi mendeŋ etkimamgö sapak keriŋaŋguknöŋ humba qöröreŋgöwa gösiiga hölŋi gösö karömbötkö söp (36 lita) haliga köhöm siŋsiŋgöwa kayök. ");
INSERT INTO bmu_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Mewö haliga bali hölŋi mihi memba taonöŋ liliŋgöwa kamba dawik qendaŋda malöhi, mihi iranŋi kundel waŋgiyök. Miaŋgö andöŋe nene söpŋe nemba tosatŋi mosoröhi, mihi mewöyök ujeta waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Mihi waŋgiiga muewö qesim waŋgiyök: “Gi erap denike anda bali qendaŋda memba malzan? Dahö nup uruŋe nup memba malzan? Aiwi galim köl gihizawi, Anutunöŋ mönö i kötuetköm waŋgima.” Mewö zöiga dahö nupnöŋ nup memba malöhi, yaŋgö sundutŋi Naomiköra zömba muewö zöyök: “Ni erap aiwi kunguk nup memba malzali, yaŋgö qetŋi mihi Boaz.” ");
INSERT INTO bmu_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Mewö zöiga Naomikö elemŋi heriga muewö zöi mörök: “Kembunöŋ mönö Boaz kötuetköm waŋgima. Kembunöŋ hal komum nengimamgö keu jöhöyöhi, miaŋgö söp mönö pöndaŋ apmeröurupnan komugeri hala nini erap muhu malzini, nengöra halkomukomuŋi qahö jöhöwa malza.” Toroqemba keu muewö zöyök: “Aiwi mihi nanini tinitosolomnina hala isikninaŋgö sohopŋi meme aiwia. Miaŋgöra yaŋgön mönö ölip galim köl nengima.” ");
INSERT INTO bmu_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Mewö zöi möta Moab anbi Rutnöŋ muewö zöyök: “Keu kun toroqeba muewö zöi mötzal: ‘Gi mönö nöŋgö nup meme anbazip yenguk nömtik malnöŋga nöŋgöreŋ bali patpat mihi kohol teköme.’” ");
INSERT INTO bmu_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Mewö zöiga Naominöŋ muewö zöyök: “O böratni, mihi ölip. Gi tosatŋi yengö nup köriŋine anöŋga silik kirekŋi hal gihiwekuk. Miaŋgöra gi ölip Boazkö nup meme anbi yenguk anda nup memba malman.” ");
INSERT INTO bmu_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Mewö zöiga Rutnöŋ Boazkö nup meme anbi yengö kösutŋine nömtik mala hölŋi qendaŋda tokowa maliga bali hala wit mietkö koholkohol nalöŋiran teköyök. Teköiga toroqemba iranŋi Naomiguk malöwöt. Mewö. ");
INSERT INTO bmu_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Nalö tosatŋi teköiga Naominöŋ iranŋi Rutkö muewö zöyök: “O böratni, ni ölip aiwi kun batököwa miwikŋaiwiga galim köl gihiiga yaŋguk sösöŋgai qakŋe köhömgi nangöhök tatman. ");
INSERT INTO bmu_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Gi nup meme anbi yenguk mösölatiwa malnöŋi, yengö galimŋini Boaznöŋ mönö nanini tinitosolomnina halza. Mötnöŋ, yaŋgön erap suŋgem baliqeqe sombemnöŋ gewa bali hölŋi hala kamböŋi mendeŋ etkimamgöra sapak keriŋaŋguknöŋ humba qöröreŋgöwa kewötma. ");
INSERT INTO bmu_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Miaŋgöra gi mönö dölmuhu ou ariwa selegi kelök umköhöwakŋaŋguknöŋ miriwa opo sirigi löŋgöta baliqeqe sombemnöŋ geman. Emu gemanöŋ, mutuk tikep malnöŋga numbu neneŋi hala ougisipŋi nem dariga miaŋgö andöŋe ölip yaŋgö jeŋe hikŋainöŋga geikma. ");
INSERT INTO bmu_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Gawöngö möta heta denike höl köla ahömawi, mönö miŋgi ekta miaŋgöreŋ anman. Kölközizip gihimapköra qesimani, miaŋgö kaisöpsöpŋi mönö muewö halman: Gi yaŋgö qöhöröŋe anda könaŋe göröken esu kitipŋi menöŋ wahöriga gewa ahöman. Mewö ahönöŋga miwikŋaim gihiwa denöwö halmani, mihi gezöiga mötman.” ");
INSERT INTO bmu_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Iranŋan mewö zöiga Rutnöŋ muewö meleŋnök: “Keu patpat zözani, nöŋgön mihi ölip hal datmam.” ");
INSERT INTO bmu_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Mewö meleŋda baliqeqe sombemnöŋ gewa iranŋan zöm qitim waŋgiyöhaŋgö söwök muewö hal teköyök: ");
INSERT INTO bmu_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boaznöŋ suŋgem numbu neneŋi hala ougisipŋi nem dari kip seleŋi mem kolihiiga wahöta bali kirip kungö göraŋe gewa gawön ahöyök. Miaŋgöreŋ ahöiga Rutnöŋ ölöŋ zaŋ qemba anda könaŋe göröken esu kitipŋi mei wahöriga miaŋgöreŋ gewa ahöyök. ");
INSERT INTO bmu_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ahöiga suŋgem hömbiwiŋe iwai kungöra outupŋe tiiga imbiŋi möta eleŋda anbi kun könaŋe ahöyöhi, mihi miwikŋaiwa ekta hauruyök. ");
INSERT INTO bmu_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Hauruwa qesim waŋgiyök: “Gi dahön?” Qesim waŋgiiga muewö meleŋnök: “O ketaŋamni, ni Rut, göhö welenqeqe anbia. Göhön nangi isikaŋgö sohopŋi meme aiwia halzan. Miaŋgöra Juda engö ambamemeŋini wuataŋgöwa ni ölip galim köl niŋgiwa esugan turum niŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Mewö meleŋniga muewö zöyök: “O böratni, Kembunöŋ mönö kötuetköm gihima. Gi ölip aiwi wanapŋi me pomŋi sukinapŋinaŋguk yengö andöŋine anbanaknöŋ, mewö qahö halzan. Gi walahok isikurupni ölip naŋgöm eŋgiwa malnöŋa erap mihi oŋgita silik ölip sorokŋi halzan. ");
INSERT INTO bmu_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","O böratni, gi mönö torok de hala bönjöŋ malman. Gi anbi ölip sorokŋi halzani, miŋgi taongö anbazip körekŋan ölip mötze. Miaŋgöra gi ikö me waikö qesim niŋgimani, nöŋgön mihi ölip hal teköm gihimam. ");
INSERT INTO bmu_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ni göhö tinitosolomgi hala galim köl gihimamaŋgö söp halzal. Keu miŋgi hölŋapnöŋ, aiwi kunöŋ nöŋgö isiknaŋgö sohopŋi meme aiwi bohonŋi halza. Nöŋgön yaŋgö qerembeŋi miyök malzal. ");
INSERT INTO bmu_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Mewököra ölip suŋgem muhu muewö ahöman. Sohop meme aiwi bohonŋan uran bohongi memamgö zömbawak ewö, mihi ölipnöŋ, bohongi memamgö qahö mötma ewö, nöŋgön ölip bohongi memam. Keu mihi jöhöwa Kembukö qetŋe jöjöpaŋ keunöŋ zöm köhöizal. Miaŋgöra ölip bönjöŋ ahönöŋga söŋan halma.” ");
INSERT INTO bmu_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Boaznöŋ mewö zömba anbi kunöŋ baliqeqe sombemnöŋ yaŋgöreŋ heröhi, kunŋan mihi mötpakuköra mörök. Miaŋgöra Rutnöŋ Boazkö könaŋe heta ahöyöknöŋ, waŋgeraŋ suluiga nalö miaŋgöreŋok kunŋan i qahö ek qitiiga ölöŋ anmapköra wahörök. ");
INSERT INTO bmu_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Wahöriga Boaznöŋ muewö zöyök: “Mönö malukugi selegeyök meköwa merereŋgöwa memba kinöŋ.” Mewö zöiga meköwa memba kiniga bali kötŋi 25 kilogramgö söp kewöta mokoi geyök. Geiga memba köbibihiwa Rutkö hawötŋe haliga haŋguwa liliŋgöwa taonöŋ anök. ");
INSERT INTO bmu_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rutnöŋ mewö taonöŋ anda iranŋaŋgöreŋ aŋgoriga muewö qesiyök: “O böratni, denöwö mala kazan?” Mewö qesiiga Boaznöŋ yaŋgö iwai patpat halöhi, miaŋgö sundutŋi zöi mörök. ");
INSERT INTO bmu_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Möriga muewö toroqemba zöyök: “‘Gi irangaŋgöreŋ biribörak de anman,’ zömba bali muŋgu niŋgiza.” ");
INSERT INTO bmu_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Mewö zöiga Naominöŋ muewö zöyök: “O böratni, aiwi miaŋön erap in luhut qahö memapnöŋ, keugi galim köla maliga mihi mindiŋgöget teköiga miaŋgö andöŋe ölip tata luhut mema. Miaŋgöra gi mönö ösöŋ mamböta tata keugi denöwö zögetka hikŋaimawi, mihi mötman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boaznöŋ taongö kiripo naŋguŋe anda qenjarök sombemnöŋ heta tarök. Tariga isikŋaŋgö sohop meme aiwiköra keu zöyöhi, yaŋgön kamba oŋgitmamgö haliga yaŋgöra muewö qerök: “O alani, gi ölip muhu kamba heta tatman.” Mewö qeriga kamba miaŋgöreŋ heta tarök. ");
INSERT INTO bmu_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Tariga Boaznöŋ taonöhok jötŋe meme aiwi 10 engömiiga kagetka tatmeköra zöiga mohotŋe heta tatket. ");
INSERT INTO bmu_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Tatketka Boaznöŋ isikŋaŋgö sohop meme aiwiköra muewö zöyök: “Nalö muewöŋe Naominöŋ Moab kantri mosota liliŋgöwa kayöhi, yaŋgön datnini Elimeleköreŋ balöŋ kitipŋi mihi bohonŋi memeköra halza. ");
INSERT INTO bmu_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Miaŋgöra nöŋgön muewö römöngözal: Göhön keu mihi mötmangöra göhöra zözal. Göhön isikniraŋgö sohop meme aiwia halnöŋga nöŋgön göhö qerembeŋgi halzal. Sohop meme aiwi mörötŋi kun qahö malja. Miaŋgöra göhön mihi bohonŋi memangöra kuŋgum gihizal. Göhön miŋgi bohonŋi memamgö sihimŋi mötman ewö, mihi ölip bohonŋi memanöŋ, mihi tököman ewö, ölip mihi mewöyök zönöŋga mötmam. Mihi ölip aiwi muhu tatzei, yeŋgö jeŋine zöman. Mihi könagesö kiripnaŋgö jötŋe meme muŋgu yeŋgö jeŋine zöman.” Boaznöŋ mewö zöiga aiwi alaŋan muewö zöyök: “Nöŋgön mihi ölip bohonŋi memam.” ");
INSERT INTO bmu_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Mewö zöiga Boaznöŋ zöyök: “Göhön Naomiköreŋ balöŋ köriŋi miŋgi söŋgöröŋi memani, nalö miaŋgöreŋ mönö Moab anbi Rut, aiwi komuyöhaŋgö malöŋi miŋgi mohok bohonŋi meman. Mewö hala aiwi komuyöhaŋgö qetŋan mönö birisamot balöŋ miaŋgöreŋ ahömapköra mihi galim köla malman.” ");
INSERT INTO bmu_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Mewö zöiga sohop meme aiwi bohonŋan muewö meleŋnök: “Mewö haliga nöŋgön mihi bohonŋi memamgö osizal. Rutnöŋ nani nahönböratni yenguk mohotŋe birisamotni mendeŋgetka mohot mohot yengön balöŋ kitipŋi merömerö miyök buŋa qem aŋguwekuk. Nöŋgön mewö halmamgö osizal. Miaŋgöra göhön ölip mihi söŋgöröŋi menöŋga nangi buŋaya halma.” Mewö meleŋnök. ");
INSERT INTO bmu_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Walahok Israel uruŋe kunŋan balöŋ iwai bohonŋi meiga buŋaŋi haliga miaŋgö keuŋan köhöimapköra yengön silik muewö hala malget: Keu zöm teköwa jöjöhö halget teköiga yetköreŋök kunöŋ köna esuŋi qeköwa alaŋi waŋgizapma. Israel yengön iwai bohonŋi memekö keuŋan teköyöhi, mihi silik mewö miaŋön kundelzema. ");
INSERT INTO bmu_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Miaŋgöra aiwi miaŋön Boazköra muewö zöyök: “Göhön mihi ölip söŋgöröŋi menöŋga buŋagi halma.” Mewö zömba köna esuŋi qeköwa Boaz waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Mihi waŋgiiga Boaznöŋ jötŋe meme aiwi hala könagösö patpat yengöra muewö engezöyök: “Nöŋgön Elimelek, Kilion hala Malon yengöreŋ iwai patpat miŋgi Naomiköreŋök söŋgöröŋi mezal. Iŋini mihi erap jeqawa suluwa ölip naŋgöwa zömeaŋgö söp halze. ");
INSERT INTO bmu_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Nöŋgön Moab anbi Rut, Malongöreŋ malöya i mewöŋanök bohonŋi membi nöŋgö anömna halma. Mewö hala aiwi komuyöhaŋgö qetŋan birisamot balöŋ miaŋgöreŋ ahömapköra mihi galim köla malmam. Qetŋan mewö qahö ayapkömapnöŋ, gulinarökurupŋan Elimelekö qetŋi ölum enguwakuköra mihi ölip taon ofiskö buknöŋ ahöm öŋgöma. Iŋini mihi erap jeqawa suluwa ölip naŋgöwa zömeaŋgö söp halze.” ");
INSERT INTO bmu_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Boaznöŋ mewö zöiga jötŋe meme aiwi hala könagesö taongö kiripo naŋguŋe sombemnöŋ tatkeri, yengön körek muewö zöget: “Nini mihi jeqawa suluwa naŋgöwin. Kembunöŋ ölip anömgi göhö köhömge kamawi, i kötuetköm waŋgiiga yaŋgön Reizöl hala Lea yetkö söp halma. Yetkön Jeikobkö nahönböraturupŋi kombuŋi engömeyöwötka Israel könagesöninan hikŋaiyök. Göhön ölip Efrata balöŋnöŋ jötŋe meme aiwi pomŋi hala Betlehem taonöŋ qetbuŋagaŋguk malman. ");
INSERT INTO bmu_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Kembunöŋ anbi malö ramikŋi miaŋgöreŋök gulinarök gihimawi, göhöreŋ könagesö yengön mönö Juda hala Tamar yetkö nahönŋiri Perez yaŋgö saiwakö söp hala malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Mewö hala Boaznöŋ Rut waŋgita köhömŋe anda anömŋa meiga Kembunöŋ kötuetköm waŋgiiga köri hala nahönŋa meyök. ");
INSERT INTO bmu_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Nahönŋa meiga anbi yengön Naomiköra muewö zöget: “Nini Kembu möpöseizin. Yaŋgön erap isikaŋgö sohop meme aiwia gihizawa yaŋgön ölip galim köl gihiwa malma. Merö miaŋön mönö Israel uruŋe qetbuŋaŋaŋguk halma. ");
INSERT INTO bmu_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Göhö irangan jöpaköm gihimamja. Göhö nahönurupki 7 malweak ewö, yaŋgön mönö i patpat engoŋgita bauköm gihiwa malök. Yaŋgön erap isiga gihiiga yaŋgön mönö malmalgi kölöŋaiwa uruöliwam qem gihiwa malma. Könaŋgep anbi namönŋi halnöŋga yaŋgön ölip galim köl gihiiga malman.” ");
INSERT INTO bmu_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Mewö zögetka Naominöŋ merö mihi memba dohongöwa galim köl waŋgiwa malök. ");
INSERT INTO bmu_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Anbi kösutŋe malgeri, yengön muewö zöget: “Naomiköreŋök isi nahönŋa hikŋaiza.” Mewö zömba qetŋi Obed qetket. Obedkö nahönŋi Jesi, isiŋi kiŋ Deiwid. ");
INSERT INTO bmu_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Qet areŋ muhu mei Perezköreŋök könahiwa kinda Deiwidköreŋ öŋgöza: Perezkö nahönŋi Hezron, ");
INSERT INTO bmu_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezrongö nahönŋi Ram. Ramgö nahönŋi Aminadab. ");
INSERT INTO bmu_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabkö nahönŋi Nason. Nasongö nahönŋi Salmon. ");
INSERT INTO bmu_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmongö nahönŋi Boaz. Boazkö nahönŋi Obed. ");
INSERT INTO bmu_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedkö nahönŋi Jesi. Jesikö nahönŋi kiŋ Deiwid. Mewö. ");
INSERT INTO bmu_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Israel miaŋgöreŋ Kembugöreŋ keu mi Amitaigöt nahönŋi Jona yaŋgöreŋ kewö asuhuyök: ");
INSERT INTO bmu_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Asiria kantrigöt siti ketauŋi Niniwe mi wehön kotkotŋe ahöza. Yeŋön bau jegömöl aka bölöŋamŋini memba malakze. Miaŋgöt keu mi nöŋgöt jemesoholne öŋgöiga mötzal. Miaŋgörap göŋön möp wahöta eu anda nöŋgöt buŋa keuni jiba miaŋön uruŋini kuŋguman.” ");
INSERT INTO bmu_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Mewö jiyökmö, Jonanöŋ möp Kembugöt jemesoholŋeyök ölöŋ köla wehön gegeŋe göröken anmamgörap wahörök. Wahöta miri qetŋi Jopa (Jaffa) miaŋgöreŋ geba waŋge kun miwikŋaiba “Ölöp yembuk Tarsis mire Spein kantrinöŋ anmam,” jiba köna söŋgöröŋi memba waŋgenöŋ öŋgöyök. Mewö öŋgöba Kembugöt jemesoholŋeyök mömölaköba anök. ");
INSERT INTO bmu_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Mewö anökmö, Kembunöŋ möp luhut köhöikŋi melaii köwetnöŋ anda qeiga siridimbom ketauŋi asuhuiga waŋgenöŋ miaŋgörap jömgömamgöt ahök. ");
INSERT INTO bmu_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Mewö aiga waŋge börö azi yeŋön keŋgötŋini möta nanŋini bemurupŋinaŋgöt dop nanŋök nanŋök köuluköm eŋgiget. Mewö aka waŋgenöŋ amgömapkörap miaŋgöt inap yuaiŋi mi körek gilgetka köwetnöŋ gem teköyökmö, Jonanöŋ waŋge dutŋaŋgöt uruŋe geba miaŋgöreŋ öl köla gaun lömbötŋi ahöyök. ");
INSERT INTO bmu_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Miaŋgöreŋ ahöiga waŋge galömŋan yaŋgöreŋ kaba kewö jiyök: “Gi möp wuanöŋgörap ki gaun ahözane? Möp wahöta nangi bemgi qeta köulukönöŋga yaŋön mötmörim neŋgiiga kude ayuhubinak.” Mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Mewö jiiga sutŋine kewö jiget: “Ayop möp kaget! Nini möp unju qeba azi dagöt siŋgisöndokörap ayuayuhu ki neŋgöt qaknine öŋgözawi, miaŋgöt könaŋi mewö miwikŋaibin.” Mewö jiba unju qegetka Jonanöŋ asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Asuhuiga jiget kaiga kewö qesim waŋgiget: “Ayuayuhu ki mi dagöt siŋgisöndokörap aka neŋgöt qaknine öŋgözawi, gi möp miaŋgöt könaŋi jinöŋga mörin. Gi wanat nuwa memakzan? Gi waniŋeyök kazan? Göhöreŋ kantri mi waniŋe aiga göhöreŋ könagesöurupki mi waniŋe malje?” ");
INSERT INTO bmu_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Mewö qesim waŋgigetka kewö meleŋnök: “Ni Israelgöt Hibru azia akzal. Ni Kembu, Suepkö Anutuŋi waikŋi memba möpöseimakzal. Yaŋön köwet aka gölme örönŋi miwikŋaim etkiyök. ");
INSERT INTO bmu_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yaŋön börö osikosibuk niŋgiiga nöŋön mi tököba Kembugöt jemesoholŋeyök ölöŋ köla kazal.” Mewö meleŋniga azi yeŋön mi möt yaköba gwötpuk awöwöliba kewö jiba jim waŋgiget: “Yei! Gi möp wuanöŋgörap mewö akzane?” ");
INSERT INTO bmu_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Köwet mi toroqeba bölim köhöiba ahöyök. Miaŋgörap yeŋön kewö qesim waŋgiget: “Nini möp denöwewö ak gihiinga köwetnöŋ giŋ qebawak?” ");
INSERT INTO bmu_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Mewö qesim waŋgigetka yeŋgörap kewö meleŋnök: “Siridimbom ketauŋi kiaŋön möp nöŋgörap aka eŋgöt qakŋine öŋgöba qezawi, nöŋön mi ölöp mötzal. Miaŋgörap iŋini möp nömimba köwetnöŋ gilgetka gemam. Gilget gebiga köwetnöŋ ölöp giŋ qemap. Mewö jizal.” ");
INSERT INTO bmu_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Mewö jiiga börö azi yeŋön töndup waŋge kunbuk gölme oronŋe aŋgotmapkörap lökuatnöŋ naŋgöbingöt qeba qegetmö, köwetnöŋ bölim teköyöhaŋgörap aka mi osiget. ");
INSERT INTO bmu_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Osiba Israelgöt Kembuŋi yaŋgöt qeta köuluköba kewö jiget: “O Kembu, gi nangak keu jitkahöt dop mi wuataŋgöba yuai ki akzan. Mewögörap Kembu, azi kiaŋön kömumapkörap aiga miaŋgörap nini kude ayuhum neŋgiman. Sepŋaŋgöt keuŋi mi neŋgöt qaknine kude alnöŋga öŋgömap. Keu mi ölŋap.” ");
INSERT INTO bmu_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Mewö köuluköba anda Jona memba gilgetka köwetnöŋ geyök. Geiga köwetkö kukŋan ösumok bököiga giŋ qeyök. ");
INSERT INTO bmu_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Giŋ qeiga azi yeŋön Kembugörap euam awöwöliba naluk ketauŋi ala Kembu jöwöwöl ohom waŋgiba keuŋini kewö jöhöget: “Nini möp Kembugöt keuŋi tem köla kude qetalbin.” ");
INSERT INTO bmu_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Jonanöŋ köwetnöŋ geiga Kembunöŋ söra ketauŋi kun melaiiga anda Jona gwahörök. Gwahöriga söra miaŋgöt uruŋe suŋgem silim karöbut ahöba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jonanöŋ söra uruŋe ahöba Kembu Anutuŋi köuluköm waŋgiba kewö jiyök: ");
INSERT INTO bmu_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Nöŋön wahöjaliŋ uruŋe Kembu köuluköm gihibiga göŋön ölöp keuni mötzan. Ni uŋem senjom kömgokŋe ahöba uleralga göŋön ölöp uletni mötzan. ");
INSERT INTO bmu_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Göŋön köwet röndum ketauŋe tötal niŋginöŋga gezal. Göŋön köwet söŋsöŋauŋaŋgöt dutŋe tuapkönöŋ eralga göulu ketauŋan esuhum niŋgizap. Göhöreŋ qölqöl-söutsöut pakpak mi musulumgöm niŋgizap. Göhöreŋ siri pakpak mi qeba turuba nem ulahöm niŋgizap. ");
INSERT INTO bmu_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Mia möta kewö mötmörizal: Göŋön ni göhöt jemesoholgeyök közöl niŋginöŋga maljal. Mi töndup nöŋön möp kunbuk göhöreŋ jöwöwöl jike kömbukŋe göröken jenan ubi anma. Mi kunbuk kude ekileŋahak kun. ");
INSERT INTO bmu_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","O aka omanjaret mi nöŋgöt qakne öŋgöba turum niŋgim teközap. Röndumnöhök möp liliköm niŋgim teközap. Köwetköt kumburereŋi miaŋön möp nöröp jupni köpeiba esuhuzap. ");
INSERT INTO bmu_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ni kunduŋaŋgöt röndaŋ könaŋaŋgöt dop yuhuyaŋgöreŋ eral. Röndaŋgöt botŋi miaŋön möp nöŋgöt qakne jöhöm qözöŋda jöhöm qözöŋ köhöizap. Yuhu maljalmö, o Kembu Anutuni, göŋön möp neka röndaŋ dutŋeyök kunbuk öröm niŋginöŋga malmalnöŋ kotmam. ");
INSERT INTO bmu_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nöŋgöt malmalnan qahöwakŋamgöt aiga nöŋön nalö miaŋgöreŋ Kembu, gi mötmörim gihibiga köuluknan öŋgöba göhöt Suep jike kömbukŋe euyaŋgöreŋ öŋgöba göhöreŋ aŋgotmap. ");
INSERT INTO bmu_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ambazip kopa-bemlopioŋ omaŋi göda qem eŋgimakzei, yeŋön mewö aka kalem möriam Toŋi gi andö guhumakze. ");
INSERT INTO bmu_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Andö mewö guhumakzemö, nöŋön möp möpömöpösei löŋet omsa köla naluk ala jöwöwöl ohom gihimamgöt mötzal. Nöŋön yuaigöt keuŋi jim jöhözali, miaŋgöt dop möp ak sorokömakŋam. O Kembu, gi mohotnöŋ nöŋgöt malmalnaŋgöt bohoni jöhömamgöt köhöizan. Keu mi ölŋap.” ");
INSERT INTO bmu_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Mewö köuluköm teköiga Kembunöŋ möp söra mi jim kutum waŋgiiga kaba kota Jona loŋniga gölme oronŋe erök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Gölme oronŋe eriga Kembugöreŋ keu ki mi kunbuk Jonagöreŋ asuhuyök: ");
INSERT INTO bmu_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Göŋön möp wahöta siti ketauŋi Niniwe miaŋgöreŋ anda buŋa keu gihimami, mi jiba uruŋini kuŋguman.” ");
INSERT INTO bmu_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Keu mewö asuhuiga Jonanöŋ wahöta Kembugöt keu jit tem köla Niniwe anök. Niniwegöt dopŋi mi kewö: Gi göraŋeyök könahiba anda malnöŋga wehön karöbut teköiga likepŋe endu aŋgotman. ");
INSERT INTO bmu_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jonanöŋ könahiba siti uruŋe anda maliga wehön mohot teköiga buŋa keu qeta kewö jiyök: “Wehön 40 kun ahözap. Mi teköiga Niniwe siti kiaŋön möp meleŋni gemap.” ");
INSERT INTO bmu_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Keu mewö qeta jiiga Niniwe könagesö yeŋön Anutugöreŋ keu möt nariba uruŋini meleŋda nene siŋgi malbingöt nalö ala jim köhöiget. Mi jim köhöiba ambazip ketauŋi moröŋi yeŋön lökŋanök imbi meleŋgöt samot meget sileŋine öŋgöiga kau ariget. ");
INSERT INTO bmu_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Mewö aketka miaŋgöt buzup keuŋi mi Niniwegöt kiŋ (praim minista) yaŋgöreŋ aŋgorök. Aŋgoriga möta jakömbuak dum tatatŋeyök eta malukuŋi köteköba samot memba at-turuba kau utuba ariba tarök. ");
INSERT INTO bmu_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Tata jim kutukutu kewö aliga Niniwe siti dop köl teköba anök: “Iŋini möp kiŋ aka jembonurupŋi yeŋgöreŋ jim kutukutu ki mötme: Kunŋan kun möp nene kuluŋ kude nemap. Ambazip me bau kuruk-lama bulmakau-iŋini nene kuluŋ kun nemegöt kude möt eŋgime. ");
INSERT INTO bmu_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Nene siŋgi mewö mala samot mem teköba Anutu köhöikŋanök sahöt köuluköm waŋgiba nanŋök nanŋök könaŋamŋini bölöŋi aka ambazip ayuayuhu böröŋini töwötpuk meget ahözawi, mi möp andö qem teköba mosötme. ");
INSERT INTO bmu_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Mewö ahinga Anutugöt uruŋan kunbuk eriga wösöŋi möt neŋgiba kukŋaŋgöt könöpŋi qeraköba siŋgisöndoknini mosötpawak. Mi mosöriga kude ayuhubinak. Mewö jizin.” ");
INSERT INTO bmu_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Mi möt asahiba könaŋamŋini bölöŋi andö qeba uruŋini meleŋgetka Anutunöŋ ahakmemeŋini mi eka wösöŋi möt eŋgiba mötmötŋi liliŋgöiga siŋgisöndokŋinaŋgöt likepŋi meleŋ eŋgimapkö ahöhi, mi mosörök. Uruŋan mewö eriga kude mem bölim eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Mewö asuhuyökmö, Jonanöŋ miaŋgörap urubölö ketauŋi möta irimŋi seholiyök. ");
INSERT INTO bmu_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Irimŋi seholiiga Kembu ulet waŋgiba kewö jiyök: “Aek Kembu, gi ak-kömukömugöt bemŋi mala ölöp neŋgehorimakzan. Göhöreŋ kuki mi öŋsöŋ aiga kalem möriamgi mi önöŋi qahöp ahöza. Mewö urugi zölaŋ amöröiga wösögi möta könagesö kun mem bölöm eŋgimamgöt kude mörakzan. Mia nane gölmenöŋ mala lök möt yaköba jiali, mia ölum guhuza me qahöp? Könaŋi mewögörap aka nalö miaŋgöreŋ Tarsis anmam jiba ösumok mömölaköba anda malal. ");
INSERT INTO bmu_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Merak malmalgöt tököba kömupköt möralga ölöwakzap. Miaŋgörap Kembu, göŋön möp malmalni dölki noaŋgötnöŋ. Keu mi ölŋap.” ");
INSERT INTO bmu_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Mewö ulerökmö, Kembunöŋ kewö meleŋ waŋgiyök: “Jona, gi ak-kömukömugörap irimsesewöl mötzani, mi dop köljap me qahöp?” ");
INSERT INTO bmu_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Mewö jiiga Jonanöŋ siti mosöta eta wehön kotkotŋe göröken anda köna töwokŋe endu koum qeba miaŋgöt aumŋe tarök. Tata sitigörap mewö me mewö asuhumawi, mi ekŋamgörap uba tarök. ");
INSERT INTO bmu_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Mewö tarökmö, Kembu Anutunöŋ Jona uruölöwak ak waŋgimamgörap jiiga ölunölun kun asuhuba köriba kota Jonagöt nöröpŋi aum köl waŋgiyök. Aum köl waŋgiiga ölunölungörap uruölöwak ketauŋi möta tarök. ");
INSERT INTO bmu_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Tata suŋgem kun ahöiga miri giaŋiiga miaŋgöreŋ Anutunöŋ taröŋ kun melaiiga kaba ölunölun mi yöhöröŋgöiga sinŋi soholiyök. ");
INSERT INTO bmu_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Wehönöŋ koriga Anutunöŋ jiiga luhut könöpŋambuk kötökŋi mi miri jeŋi kotkotŋeyök qeiga wehön jeŋan nöröpŋe qei qei uruŋi öngöba duhuiga kömumamgöt möt teköba köuluköba kewö jiyök: “Nöŋön malmalgöt tököba kömupköt möralga ölöwakzap. Keu mi ölŋa.” ");
INSERT INTO bmu_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Mewö jiyökmö, Anutunöŋ Jonagörap kewö jiyök: “Gi ölunölungörap irimgi seholizawi, mi dop köljap me qahöp?” Mewö jiiga kewö meleŋ waŋgiyök: “Irimni seholizawi, mi möp dop köljawa. Nöŋgöt irimsesewölni mi ketauŋi aiga urunan kude amörimap. Miaŋgörap ölöp kömumam. Keu mi ölŋap.” ");
INSERT INTO bmu_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Jonanöŋ mewö jiiga Kembunöŋ kewö jiyök: “Gi ölunölungöt böröŋi kun kude memba mi kunde galöm kölnöŋga köriyök. Mi suŋgem mohotkö uruŋe asuhuyök aka suŋgem mohotkö uruŋe soholiba kömuyök. Töndup göŋön nangak yuai omaŋi mewöŋi miaŋgörap sahöta waimanjat mötzan. ");
INSERT INTO bmu_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Mewö aiga nöŋön möp denöwögörap siti ketauŋi kiaŋgöt könagesöŋi yeŋgörap waimanjat kude mötpileŋak? Miaŋgöt uruŋe morö namande 1 20.000 (handöt twenti tausen) jaŋgö mi oŋgöta maljei, mi ölöpŋaŋgöt aka bölöŋaŋgöt könaŋiri kude möt kewöt etkimakzei aka bau kuruk yuai mi tok gwötpuk malje. Mi ambazip ketauŋi yembuk mohok mem bölim eŋgibileŋbukörap nöŋön möp sihimnan Niniwe eŋgehorizal.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisös Kraistkö ambösakon yeŋgö qet areŋini kewö: Abrahamgö gwölönarökŋi kun Deiwid. Deiwidkö gwölönarökŋi kun Jisös. ");
INSERT INTO bmu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamgö nahönŋi Aisak. Aisakö nahönŋi Jeikob. Jeikobkö nahönurupŋi Juda aka yaŋgö darumunurupŋi. ");
INSERT INTO bmu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judagö nahönyahötŋi Perez aka Zera, namŋiri Tamar. Perezgö nahönŋi Hezron. Hezrongö nahönŋi Ram. ");
INSERT INTO bmu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramgö nahönŋi Aminadab. Aminadabkö nahönŋi Nason. Nasongö nahönŋi Salmon. ");
INSERT INTO bmu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmongö nahönŋi Boaz, namŋi kantri kungö ambiŋi Rahab. Boazgö nahönŋi Obed, namŋi kantri kungö ambiŋi Rut. Obedkö nahönŋi Jesi. ");
INSERT INTO bmu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesigö nahönŋi kiŋ Deiwid. Deiwidkö nahönŋi Solomon, namŋi mutuk Uriagö anömŋa malök. Juda kiŋ pakpak mi Deiwidkö gwölönarökurupŋi aka malget. ");
INSERT INTO bmu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomongö nahönŋi Rehoboam. Rehoboamgö nahönŋi Abiya. Abiyagö nahönŋi Asa. ");
INSERT INTO bmu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asagö nahönŋi Jehosafat. Jehosafatkö nahönŋi Jehoram. Jehoramgö nahönŋi Usia. ");
INSERT INTO bmu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiagö nahönŋi Jotam. Jotamgö nahönŋi Ahaz. Ahazgö nahönŋi Hezekia. ");
INSERT INTO bmu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiagö nahönŋi Manase. Manasegö nahönŋi Amon. Amongö nahönŋi Josia. ");
INSERT INTO bmu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiagö nahönurupŋi Jekonia aka yaŋgö darumunurupŋi. Nalö miaŋgöreŋ Babilon yeŋön Israel könagesö eŋguaŋgitketka Babilon anda kösö mire malmal ewö tandök welenqeqeŋina malget. ");
INSERT INTO bmu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon kösö mire malmal ewö tandök mala miaŋgöreŋ Jekoniagö nahönŋi Sealtiel asuhuyök. Sealtielgö nahönŋi Jerubabel. ");
INSERT INTO bmu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubabelgö nahönŋi Abiud. Abiudkö nahönŋi Eliakim. Eliakimgö nahönŋi Azor. ");
INSERT INTO bmu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorgö nahönŋi Jadok. Jadokö nahönŋi Akim. Akimgö nahönŋi Eliud. ");
INSERT INTO bmu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudkö nahönŋi Eleazar. Eleazargö nahönŋi Matan. Matangö nahönŋi Jeikob. ");
INSERT INTO bmu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jeikobkö nahönŋi Josef, Mariagö apŋi. Marianöŋ Jisös meiga qetŋi Kraist Amötqeqe Toŋi qerakzin. ");
INSERT INTO bmu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nalö Abrahamgöreŋök könahiba mala kotketka Deiwid asuhuyöhi, isik mieŋgö jaŋgö areŋi mi 14. Kunbuk kiŋ Deiwidköreŋök könahiba mala kotketka Israel könagesö eŋguaŋgitketka Babilon anda kösö mire malmal ewö tandök malgeri, isik mieŋgö jaŋgö areŋi mi mewöyök 14. Babilon kösö mire malmal ewö tandök malgeri, nalö miaŋgöreŋök könahiba mala kotketka Kraist asuhuyöhi, isik mieŋgö jaŋgö areŋi mi mewöyök 14. ");
INSERT INTO bmu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisös Kraist asuhuyöhaŋgö kösohotŋi kewö: Yaŋgö namŋi Maria mi Josefbuk buŋabuŋa mala mindimindiri qahö aka malohotka nalö miaŋgöreŋ Uŋa Töröŋan mem letot waŋgiiga köröbuk mali könaŋi mewö miwikŋaiget. ");
INSERT INTO bmu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mewö miwikŋaigetka azi buŋaŋi Josef yaŋön malmal diŋdiŋi malöhaŋgöra Mariagö könaŋi aukŋe asuhui gamuŋambuk akapuköra tököyök. Mewö tököba uruŋan i ölöŋ mosötmamgö mötmöt areŋi alök. ");
INSERT INTO bmu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mewö mötmöriba ahöiga Kembugö garata kunŋan gaunöŋ asuhum waŋgiba kewö jiyök, “Josef Deiwidkö gwölönarökŋi, Uŋa Töröŋan mönö Maria letot waŋgiiga köröŋambuk malja. Miaŋgöra gi mönö i örönöŋ mirige kaba anömgi akŋapkö keŋgötki kude mötman. ");
INSERT INTO bmu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Marianöŋ mönö morö nahön mema. Azi miaŋön könagesöŋi siŋgisöndokŋineyök amöt qem eŋgiiga solanime. Miaŋgöra göŋön qetŋi Jisös qetman.” Mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kembunöŋ kezapqetok azi kun sölölöhöiga keu kun jiyöhi, miaŋön ölŋambuk akŋapköra yuai pakpak mi asuhuyök. Kezapqetok keu mi kewö, ");
INSERT INTO bmu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ambi seram jömukŋi kunöŋ gölömŋambuk aka morö azia meiga qetŋi Imanuel qetme.” Qet miaŋgö könaŋi kewö, “Anutunöŋ nembuk malja.” ");
INSERT INTO bmu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josefnöŋ imbiŋi möta wahöta Kembugö garatanöŋ jim kutum waŋgiyöhi, mönö miaŋgö dop aka Maria anömŋi akŋapköra waŋgita miriŋe anök. ");
INSERT INTO bmu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Anda malohotmö, nalö sutŋe miaŋgöreŋ mohotŋe qahö ahöyohot anda nahönŋi meiga Josefnöŋ qetŋi Jisös qerök. Morö meiga miaŋgö andöŋe awanöm malohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisösnöŋ kiŋ kembu Herodkö nalöŋe Judia prowinsgö taon qetŋi Betlehem asuhuyök. Asuhuyöhi, nalö miaŋgöreŋ seŋgelaugö mötmöt azi wehön kotkotŋeyök Jerusalem sitinöŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kaba kewö qesiget, “Juda eŋgöreŋ kiŋ kembu akŋawi, morö mi asuhuba denike ahöza? Nini wehön kotkotŋe mala yaŋgöreŋ undi asuhui eka könaŋi mewö möta waikŋi memba möpöseibingöra kazin.” ");
INSERT INTO bmu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mewö qesigetka kiŋ kembu Herod aka Jerusalem könagesö yambuk malgeri, yeŋön körek pakpak keu mi möta auruget. ");
INSERT INTO bmu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aurugetka kiŋ Herodnöŋ keu ala könagesögö jike nup galöm bohonŋi aka Köna keugö böhi pakpak köl öröm eŋgii kaget. Kaba tokogetka kewö qesim eŋgiyök, “Amötqeqe Toŋi Kraistnöŋ mönö denike asuhumapköra jigetka ahöza?” ");
INSERT INTO bmu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Qesim eŋgiiga kewö meleŋ waŋgiget, “Yaŋön mönö Judia prowinsgö taon qetŋi Betlehem miaŋgöreŋ asuhuma. Miaŋgö keuŋi mi kezapqetok azi Maikanöŋ kewö ohoi ahöza, ");
INSERT INTO bmu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O Betlehem könagesö Juda gölmenöŋ maljei, eŋgö sutŋineyök kembu ketaŋi asuhuba nani Israel könagesö mindiŋgöba köyan köl neŋgima. Miaŋgöra iŋini Juda gölmegö jitŋememe yeŋgö sutŋine malgetka qetbuŋaŋinan eretŋi qahöpmahöp akza.’” ");
INSERT INTO bmu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mewö meleŋ waŋgigetka mötkutukutu azi mi ölöŋ eŋgoholi kagetka kewö qesim eŋgiyök, “Undiŋi mönö wani nalönöŋ asuhui könahiba eket?” Miaŋgö könaŋi törörök mötmamgö möta mewö qesim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Miaŋgö keuŋi möta melaiba kewö jim kutum eŋgiyök, “Iŋini mönö Betlehem anda morö mi törörök qesiba miwikŋaiba miaŋgöreŋök buzup keu algetka nöŋgöreŋ kama. Nöŋön mi möta mewöŋanök anda i waikŋi memba möpöseim waŋgimam.” ");
INSERT INTO bmu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kiŋnöŋ mewö muneŋ jiba jim kutum eŋgiiga möta könanöŋ anget. Anda undi wehön kotkotŋe mala ekeri, miaŋön nöröpŋine mutukmutuk ani mötötei-get Betlehem anda miri morö nahön ahöyöhi, mönö miaŋgöreŋ kinök. ");
INSERT INTO bmu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Undi mi kini eka sösöŋgai keta bölökŋi aket. ");
INSERT INTO bmu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sösöŋgai aka miri uruŋe öŋgöba morö aka namŋi Maria etkeket. I etkeka simin köla sipköba waikŋi memba möpöseim waŋgiget. Möpöseim waŋgiba bayaŋgösöŋini qeaŋda miaŋgöreŋök goul, jiniŋ paura aka sanda qetŋi mör mi uzeta kalem waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Suŋgem kun ahöget-ka Anutunöŋ gaun kondela kiŋ Herodköreŋ kunbuk anbepukö qetal eŋgiyök. Miaŋgöra köna kungenök nanŋini miri gölmeŋine liliŋgöba anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mötkutukutu azi mieŋön angetka Josefnöŋ gaun ehiga Kembugöreŋ garata kunŋan asuhum waŋgiba kewö jii mörök, “Herodnöŋ morö qei kömumapkö jarum waŋgima. Miaŋgöra mönö wahöta morö aka namŋi etkuaŋgita ölöŋ köla Ijipt kantrinöŋ anme. Miaŋgöreŋ anda malgetka biaŋ nanak kamegö nalö jimami, miaŋgöreŋ mönö liliŋgöba kame.” ");
INSERT INTO bmu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mewö jii möta wahöta suŋgem miaŋgöreŋök morö nahön aka namŋi etkuaŋgita Ijipt anget. ");
INSERT INTO bmu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ijipt anda malgetka kiŋ Herodnöŋ kömuiga nalö miaŋgöreŋök liliŋgöba kaget. Mutuk Kembunöŋ kezapqetok azi Hosea sölölöhöiga keu kewö jii ahöza, “Nöŋön nahöni oholbiga Ijipt gölme mosöta kayök.” Kezapqetok keu miaŋön mönö mewö asuhuiga ölŋambuk ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mötkutukutu azi mieŋön Juda gölme ölöŋ mosöta angetka Herodnöŋ miaŋgö könaŋi eka “Tilipköm niŋgiget,” jiba irimŋi gwötpuk seholiiga jimkutukutu kewö alök, “Yarö azi, iŋini Betlehem aka gölme pakpak mi liliköba ahözawi, mönö miaŋgöreŋ anda azi morö (yara) yambuŋini yahöt aka miaŋgö bapŋe akzei, mi körek eŋguget kömume.” Mötkutukutu azi undi asuhuyöhaŋgö nalögöra törörök qesim eŋgiiga jiget möröhi, miaŋgö dop morö azi yambuŋinaŋgöra jimkutukutu mi alök. ");
INSERT INTO bmu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kezapqetok azi Jeremaianöŋ keu kun jii ahözawi, miaŋön mönö mewö asuhuiga ölŋambuk ahök. Keu mi kewö, ");
INSERT INTO bmu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Silat mi Betlehem kösutŋeyök miri qetŋi Rama miaŋgöreŋök mötketka sahöt gigilahöze. Reizöl ambigö gwölönarökurup yeŋön moröurupŋini qahöwaketka urureŋ meze. Miaŋgöra sahötketka urukölalep mem eŋgibingö aketka urukondumök mörakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josefnöŋ Ijipt maliga kiŋ Herodnöŋ kömuiga miaŋgöreŋök Kembugöreŋ garata kunŋan gaunöŋ asuhum waŋgiba ");
INSERT INTO bmu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kewö jiyök, “Morö qeget kömumapkö mönögeri, yeŋön lök kömuget. Miaŋgöra mönö wahöta morö aka namŋi etkuaŋgita liliŋgöba Israel gölmenöŋ anme.” ");
INSERT INTO bmu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mewö jiiga Josefnöŋ wahöta morö aka namŋi etkuaŋgita liliŋgöba Israel gölmenöŋ anget. ");
INSERT INTO bmu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Könanöŋ anda keu kewö mörök, “Herodkö nahönŋi Arkelausnöŋ iwiŋaŋgö salupŋe Judia prowins galöm köla malja.” Mewö möta miaŋgöreŋ anmamgö keŋgötŋi mörök. Möta mali Anutunöŋ gaunöŋ Galili prowinsnöŋ anmegö jim kutum waŋgiiga wahöta miaŋgöreŋ anget. ");
INSERT INTO bmu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galili prowinsnöŋ aŋgota taon qetŋi Nazaret miaŋgöreŋ malget. Mewö malgetka kezapqetok azi yeŋön Amötqeqe Toŋaŋgöra keu jigeri, miaŋön ölŋambuk ahök. Keu mi kewö, “Yaŋgö qetŋi mi Nazaret azi qeta malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yambu tosatŋi teköiga Jon O-melun azinöŋ kaba Judia prowinsgö gölme qararaŋkölkölŋe liliköba ambazip uruŋini Buŋa keunöŋ kuŋguba kewö jiba malök, ");
INSERT INTO bmu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Suep Toŋan bemtohoŋi almawaŋgö nalöŋan lök kam kuŋguza. Miaŋgöra mönö uruŋini meleŋda miaŋgöreŋ aŋgotket.” ");
INSERT INTO bmu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jongöra kezapqetok azi Aisaianöŋ keu kun kewö jiba ohoyök, “Kolek garata kunöŋ gölme qararaŋkölkölŋe qeta maliga anda jölŋi kewö mötme, ‘Kembunöŋ kamawo! Miaŋgöra mönö jöjöröba könaŋi mesatket. Mönö uruŋini mindiŋgöba könaŋi köl diŋgiba qölöleiget.’” ");
INSERT INTO bmu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jongöreŋ maluku mi kamel jupŋan memeŋi aiga kembaŋe örigit sömbup sileŋan memeŋi mi jöhöba malök. Neneŋamŋi mi gawöt jinam aka arökŋaŋgö moroŋ oŋi. Mi pakpak kezapqetok azi Elaija (Elia) yaŋgö dowa. ");
INSERT INTO bmu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jonöŋ nupŋi meiga ambazip kambulelembe yeŋön Jerusalem siti aka Judia prowinsgö miri tosatŋi pakpak mieŋgöreŋök yaŋgöreŋ öröba kaget. Mewöŋanök Jordan o likeplikep miri pakpak tat angeri, mieŋgöreŋök kaget. ");
INSERT INTO bmu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kaba kaŋgota siŋgisöndokŋini jim miwikŋaigetka Jonöŋ i Jordan o töwatŋe o melun mem eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mem eŋgiyökmö, Farisi (Köna keugö kapaŋkölköl) aka Sadyusi (Jike nupkö kapaŋkölköl) ambazip gwötpukŋan o melun mem eŋgimapköra kagetka eŋgeka yeŋgöra kewö jiyök, “O qatö moröŋi, iŋini uruŋini qahö meleŋgetka Anutugö irimŋan seholiiga likepŋi meleŋ eŋgimamgö akza. Mi ölöŋ kölbingö goro keuŋi mi mönö daŋön jii möta sömbuŋini möta ki kaze? ");
INSERT INTO bmu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Miaŋgöra mönö ölŋanök uruŋini meleŋme. Bölöŋamŋineyök liliŋgögetka ölŋi asuhui mi mönö ahakmemeŋinan aukŋe kondela malme. ");
INSERT INTO bmu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Uruŋine möndömöndö keu kewö jibingö kude mötmörime, ‘Neŋön mönö Abrahamgö gwölönarökŋa malinga Anutunöŋ qahö ayuhum neŋgima.’ Mewö jiba töptöpŋine qemakzemö, ölŋi mi qahö ahakze. Nöŋön miaŋgöra kewö jibi mötket, Anutunöŋ köt ki ölöp jim kutum eŋgiiga letota Abrahamgö gwölönarökurupŋi aka Anutu möpöseimakŋemö, iŋini denöwö? ");
INSERT INTO bmu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Uruŋini qahö meleŋme ewö, Anutunöŋ mönö iŋini ip ewö teŋgöri etpingö akze. Ip pakpak kötŋi ölöpŋi qahö kuŋgumakzei, mi mönö köli etket könöpnöŋ gili geme. Ip mewöŋi kölmamgö kesiŋi lök jitŋi saŋe ala ip könaŋe ali jöjöröba ahöza. Anutunöŋ mönö bölöŋamŋinaŋgö likepŋi meleŋ eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nöŋön iŋini uruŋini meleŋmeaŋgöra o töhönöŋ melun mem eŋgizalmö, nöŋgö andöne azi kukösumŋi köhöikŋi kun kama. Yaŋgö kukösumŋi öŋgöŋgöŋan mönö nöŋgöreŋ oŋgitma. Yaŋön azi öŋgöŋgöŋi akŋawaŋgöra nöŋön yaŋgö köna esuŋi bauköba gösönöŋ löŋgöta teŋgömamgö qötötaŋgömam. Yaŋön mönö Uŋa Töröŋi uruŋine ali könöp bölamŋan köl könjörat eŋgiiga mewö miaŋön melun mem eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Yaŋön ölŋi aka kamböŋi mendeŋ etkimamgö sapakŋi memba kaŋgota uba qöröreŋgöba kewötma. Kewöta wit kötŋi tokoba köweŋe almapmö, kamböŋi aka gwaugulapŋi mi mönö usuŋniga könöpnöŋ geba teteköŋi qahö jema.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nalö miaŋgöreŋ Jisösnöŋ Galili prowins mosöta Jordan o töwatŋe Jongöreŋ kaba o melun mem waŋgimapköra qesiyök. ");
INSERT INTO bmu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Qesiyökmö, Jonöŋ qetal waŋgiba kewö jiyök, “Göŋön ölöp ni o melun mem niŋgibanakmö, göŋön siŋgisöndok qahö aka mönö denöwögöra nöŋgöreŋ kazan?” ");
INSERT INTO bmu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mewö jiiga Jisösnöŋ kewö meleŋnök, “Nalö kewöŋe mi ölöp akŋan. Mewö akziga miaŋön Anutunöŋ ahakmeme diŋdiŋi wuataŋgöbingö keu jiyöhi, miaŋgö ölŋi asuhuiga dop kölma.” Mewö jiiga Jonöŋ möri dop köliga urumohot ahök. ");
INSERT INTO bmu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Urumohot aka o melun mem waŋgii teköiga miaŋgöreŋök onöhök koriga kewö asuhuyök: Suepnöŋ aŋaŋiiga Jisösnöŋ uba ehiga Anutugö Uŋa Töröŋan meleŋda kembö nei ewö aka Jisösgö qakŋe eta meyök. ");
INSERT INTO bmu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eta meiga Suepnöhök qet kun kewö asuhuyök, “Yaŋön mönö nani wölböt nahöna aiga köröni ölöwahiga eknahöm ak waŋgizal.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Miaŋgö andöŋe Uŋa Töröŋan Jisös kuŋgum waŋgiiga gölme qararaŋkölkölŋe Bölöŋaŋgö Toŋan esapköm waŋgimapköra aka anök. ");
INSERT INTO bmu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Miaŋgöreŋ anda suŋgem asak 40 Anutugöra nene siŋgi mala nenegö kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nenegö kömuiga öme bohonŋini qetŋi esapesap Toŋi yaŋön asuhuba kewö jiyök, “Gi Anutu Nahönŋa akzan ewö, mi mönö kondela köt ki jim kutunöŋga letota beret aketka neman.” ");
INSERT INTO bmu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mewö jiyökmö, Jisösnöŋ keu kewö meleŋnök, “Qahö! Buŋa Kimbinöŋ keu kun kewö ohoget ahöza, ‘Nenenöhök ambazip malmal qahö neŋgimakzapmö, Anutugö jitŋeyök keu kamakzawi, mi pakpak tem kölinga miaŋön mönö gumohom neŋgiiga köhöiba maljin’.” ");
INSERT INTO bmu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mewö jiiga Bölöŋaŋgö Toŋan Jisös waŋgita Jerusalem siti töröŋe anda jöwöwöl jikegö boŋe euyaŋgöreŋ öŋgöba ali kinök. ");
INSERT INTO bmu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mewö kiniga kewö jii mörök, “Gi Anutugö Nahönŋa akzan ewö, mönö kiaŋgöreŋök luhuba emu geman. Buŋa Kimbinöŋ keu kun kewö ohoget ahöza, ‘Anutunöŋ göhöra aka garataurupŋi jim kutum eŋgiiga ölöp kököbihigetka geba kötnöŋ könage qahö guhum qizit akŋa.’ Miaŋgöra geba kude ayuhuman.” ");
INSERT INTO bmu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mewö jiiga kewö meleŋnök, “Qahö! Buŋa Kimbinöŋ keu kun mewöyök kewö ahöza, ‘Gi mönö Kembugi Anutu kude esapköm waŋgiman.’” ");
INSERT INTO bmu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mewö jiiga Bölöŋaŋgö Toŋan kunbuk waŋgita kunduŋi köröp tiŋtiŋi kunöŋ öŋgöba gölme pakpak yeŋgö kantri tohoŋi tohoŋi aka mieŋgö inap yuaiŋini aködamunŋinambuk pakpak kondel waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kondel waŋgiba kewö jiyök, “Göŋön simin köl niŋgiba waikni memba möpöseim niŋgiman ewö, nöŋön öröyuai pakpak ki mönö tököm gihibi buŋa qem aŋguba galöm köl eŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mewö jiiga Jisösnöŋ kewö jii mörök, “Qahö! Satan gi mönö kesalnöŋ. Buŋa Kimbinöŋ keu kun kewö ohoget ahöza, ‘Gi mönö Kembugi Anutu, ia mohot simin köl waŋgiba waikŋi memba möpöseiman’.” ");
INSERT INTO bmu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mewö jiiga Bölöŋaŋgö Toŋan miaŋgöreŋök Jisös mosöta kesalök. Mewö aiga garata yeŋön kaba Jisös bauköm waŋgiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Miaŋgö andöŋe Jon O-melun azi kösö mire alget tari Jisösnöŋ mi möta Judia prowins mosöta Galili anök. ");
INSERT INTO bmu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Anda prowins miaŋgöreŋ miriŋi Nazaret mosöta Kaperneam anda malök. Kaperneam siti mi Zebulun aka Naftali gölmenöŋ Galili o aŋgö qöhöröŋe ahöza. ");
INSERT INTO bmu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Miaŋgöreŋ mala nupŋi meiga Anutunöŋ keu kun kezapqetok azi Aisaia sölölöhöiga jiyöhi, miaŋön ölŋambuk ahök. Keu mi kewö, ");
INSERT INTO bmu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ambazip Zebulun gölmenöŋ aka Naftali gölmenöŋ Jordan likepŋe malgetka sutŋine köna namŋi köwetnöŋ göröken anda kinjawi aka Juda qahöpmö, kambu tosatŋan Galili prowinsnöŋ maljei, ");
INSERT INTO bmu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","könagesö mieŋön söŋaupnöŋ mala asakŋi ketaŋi ekŋe. Kömupnöŋ ambazip aum köl eŋgiiga pandaman gölmenöŋ maljei, yeŋgöra mönö miri waŋgaraŋ suruma.” ");
INSERT INTO bmu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisösnöŋ Kaperneam mala nalö miaŋgöreŋök könahiba Buŋa keuŋi jim asariba ambazip uruŋini kuŋguba kewö jiba malök, “Suep Toŋan bemtohoŋi almawaŋgö nalöŋan mönö kam kuŋguza. Miaŋgöra mönö siŋgisöndok malmalŋini mosöta uruŋini meleŋget.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mewö jiba liliköba mala Galili o aŋgögö göraŋe mötöteiba anda darumun yahöt Saimon qetŋi alaŋi Pitö aka munŋi Andru etkehök. Yetkön söra örörö azia mala mösakŋiri o aŋgönöŋ söra öröbitköra gila malohot. ");
INSERT INTO bmu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisösnöŋ etkeka kewö jiyök, “Aziyahöt, iŋiri mönö ni nuataŋgöba kayohotka kusum etkibi ambazip söra ewö öröm eŋgimakŋahot.” ");
INSERT INTO bmu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mewö jiiga miaŋgöreŋök mösakŋiri mosöta könahiba Jisös wuataŋgöba anohot. ");
INSERT INTO bmu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisösnöŋ yetpuk borom kun toroqeba anda kunbuk darumun yahöt Zebedigö nahönyahötŋi Jeims aka Jon etkehök. Yetkön iwiŋiri Zebedibuk waŋgenöŋ tata mösakŋini möhamgöba jöhöba malgetka eŋgeka etkoholök. ");
INSERT INTO bmu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mewö eŋgeka etkoholiga miaŋgöreŋök wahöta waŋge aka iwiŋiri mosöta könahiba Jisös wuataŋgöba andöŋe anohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisösnöŋ anda Galili prowins uruŋe lökŋanök liliköba köuluk miriŋine öŋgöba bemtohoŋgö Ölöwak Buŋaŋi jim asariba uruŋini kuŋguba kusum eŋgiba malök. Mewö aka sutŋine ambazip kawöl aka jepajerepe könaŋi könaŋi eŋgöhöi malgeri, mi mem ölöwak eŋgiba malök. ");
INSERT INTO bmu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mewö memba maliga Jisösgö qetbuŋaŋan sehiba Siria kantri dop köl teköba anök. Mewö ani mi möta kawöl ambazip pakpak eŋguaŋgita yaŋgöreŋ kaget. Tosatŋan uzi kawöl aka jepajerepe könaŋi könaŋi eŋgöhöi malget. Tosatŋan ömewörömenöŋ uruŋine geiga töŋöt me kölköljiŋjiŋbuk malget. Tosatŋan tala eta eŋguiga bözok mitiba semben auba malget. Tosatŋan sileŋinaŋgö likepŋi kömukömuŋi malget. Mewö mewöŋi mieŋön Jisösgöreŋ kagetka mem ölöwak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mewö ak eŋgiiga ekeraŋgöra ambazip könagesö ketaŋi yeŋön Jisösgö andöŋe wuataŋgöba kaget. Kambu ketaŋi ketaŋi mi Galili prowins aka Ten Taon distriknöhök kaget. Kambu tosatŋan Jerusalem siti aka Judia prowinsgö miri tosatŋeyök kaget. Kambu tosatŋan Jordan o likepŋeyök kaget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisösnöŋ ambazip kambu ketaŋi eŋgeka kunduŋe öŋgöba tariga gwarekurupŋan kaŋgota liliköm waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Liliköm waŋgigetka könahiba ambazip kambuŋi kambuŋi kusum eŋgiba kewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Denike yeŋön Anutugö jeŋe etqeqeŋi tandök mötzei, yeŋön Suepkö bemtohoŋi buŋa qem aŋgumeaŋgöra mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Denike yeŋön jiŋgeŋ köla sahötzei, Anutunöŋ i urukölalep eŋgimapköra mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Denike yeŋön guŋbönjönjöŋ malakzei, Anutunöŋ gölme ki mi yeŋgöra eŋgii buŋaŋina akŋapköra yeŋön mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Denike yeŋön Anutugö jeŋe solanibingöra kapaŋ köla mi nene aka ogö ewö kömumba qemjeŋ qeba maljei, Anutunöŋ mönö sihimŋini mi gumohom eŋgima. Miaŋgöra yeŋön mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Denike yeŋön tosatŋi ak kömum eŋgimakzei, Anutunöŋ i ak kömum eŋgimapköra yeŋön mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Denike yeŋgö uruŋinan sarakŋi akzawi, yeŋön ölöp Anutu ekŋe. Miaŋgöra yeŋön mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Denike yeŋön luai qemakzei, yeŋgö qetŋini mi Anutugö nahönböraturupŋi qetme. Miaŋgöra yeŋön mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anutunöŋ keuŋini jim teköi solanizeaŋgöra sesewerowero ak eŋgimakzei, yeŋön Suepkö bemtohoŋi buŋa qem aŋgume. Miaŋgöra yeŋön mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ambazipnöŋ iŋini nöŋgöra aka uruqeqe keu töhöreŋ jim eŋgiba sesewerowero aka keu bölöŋi könaŋi könaŋi sileŋine ala muneŋmuneŋ jimakzei, eŋön mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mötket, Anutunöŋ töwaŋini öŋgöŋgöŋi Suep mire ali ahözawaŋgöra mönö gönköiraŋ ala sösöŋgai aka malme. Mi kewögöra: Kezapqetok ambazip mutuk malgeri, mi sesewerowero tandökŋi mewöŋanök ak eŋgigetka eŋön yeŋgö andöŋine asuhuba yembuk öröröŋ malje.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisösnöŋ jiyök, “Iŋini gölme ambazip yeŋgö howe tandök akzemö, howe nahömŋan piahima ewö, mi mönö denöwö möhamgöinga kunbuk nahömŋambuk akawak? Miaŋgö könaŋi kun qahö. Toroqeba yuai kungöra qahö dop kölmapmö, mi nesak ewö gilget geiga ambazipnöŋ mi könaŋinan tiahöme. ");
INSERT INTO bmu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Iŋini gölmeŋi gölmeŋi yeŋgö kiwa tandök ewö aka malje. Siti kun kunduŋe öŋgöba meget tatzawi, miaŋön tölapŋe tatmamgö osimakza. ");
INSERT INTO bmu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kunŋan kiwa ohotiriba kumbut bapŋe qahö almapmö, kiwagö dum tatatŋe ali tatma. Mewö tata asariiga ambazip miri uruŋe maljei, mönö körek yeŋgö jeŋini kuŋguiga asakŋi ehakŋe. ");
INSERT INTO bmu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","“Mewöŋanök mönö eŋgö asakŋini kondelgetka ambazip sutŋine asariiga ehakŋe. Amba-zipnöŋ ahakmemeŋini ölöpŋi eka miaŋgöra Iwiŋini Suep mire maljawi, mönö i möpöseiba malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nöŋön Mosesgöreŋ Köna Keu aka kezapqetok ambazip yeŋgö Buzup Kimbiŋini mi qeapkömamgöra aka qahö kaba maljal. Mewö laŋ kude mötmörime. Nöŋön qeapkömamgöra qahöpmö, keu mi tem köl teköbi mieŋgö ölŋinan pöndaŋ asuhumapköra aka kaba maljal. ");
INSERT INTO bmu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nöŋön keu ölŋi kun kewö jibi mötket, Mosesgö Köna keunöhök kulem moröŋi morö közömŋi kun me kirifi ohohogö jönbölanŋi mohok-kun mi qahö kötökŋi ayapkömapmö, keu pakpak mi mutuk ölŋinambuk asuhugetka Suep gölme yetkön göröŋ qemahot. ");
INSERT INTO bmu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Miaŋgöra kunŋan Köna keugö jimkutukutu morörökŋi mieŋgöreŋök keu kun koyoŋaniba ambazip mewö kusum eŋgimakzawi, yaŋön Suepkö bemtohoŋe aŋgoriga qetŋi morörökŋi bezup qetme. Mewö qetmemö, kunŋan mi tem köla wuataŋgöba ambazip mewö kusum eŋgimakzawi, yaŋön Suepkö bemtohoŋ uruŋe aŋgoriga qetŋi ketaŋamnini qetme. ");
INSERT INTO bmu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Nöŋön miaŋgö dop kewö jibi mötket: Eŋgö ahakmemeŋini solanŋi miaŋön mönö Köna keugö böhi aka Farisi (Köna keugö kapaŋkölköl) yeŋgö silikŋini tandök ewö öröröŋ akapuk. Silikŋinan yeŋgö silikŋini gwötpuk qahö oŋgitma ewö, eŋön mönö Suepkö bemtohoŋ uruŋe qahö aŋgotme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisösnöŋ toroqeba jiyök, “Eŋön möpŋeyök keu kun kewö jiget mötzema, ‘Ambazip kun kude qeget kömuma aka kunŋan kazikŋi qei kömumawi, i mönö distrikö keu jakeŋe algetka keuŋi jim teköme.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Mewö jiget mötketmö, nöŋön keu mi kewö jim tuaribi mötme: Kunŋan alaŋambuk aŋgururuk aka irimŋan seholii yom kazik akzawi, i mönö mewöyök distrikö keu jakeŋe al waŋgiget keuŋi jim tekömeaŋgö dop akza. Mewöŋanök kunŋan alaŋi jijiwilit keunöŋ jim böliba ‘Gi uruqahö akzan,’ jizawi, i mönö kantrigö jike kaunsöl yeŋgö jeŋine al waŋgiget keuŋi jim tekömeaŋgö dop akza. Kunŋan alaŋi lösö keunöŋ jim böliba ‘Gi aŋgöjörakabuk akzan,’ jizawi, yaŋön mönö könöp sianöŋ gemawaŋgö dop akawak. ");
INSERT INTO bmu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Miaŋgöra göŋön kalem naluki memba kaba altanöŋ almamgö aknöŋga miaŋgöreŋ keu kewöŋan mötmötke kaŋgotpawak: Alagahö uruŋe keu ahöi yaŋön kazik ak gihimamgö mötza. Keu mewöŋi mötmöriman ewö, ");
INSERT INTO bmu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kalemgi mi mönö alta wösöŋe ala mutuk alagahöreŋ anda yambuk keuŋiri jim solaniba urumohot aka miaŋgö andöŋe kunbuk kaba kalem naluki Anutugöra alman. ");
INSERT INTO bmu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kerökan silege ala keu jakeŋe öröm gihimamgö aiga komitigöreŋ anda köna namŋe miaŋgöreŋ mönö kapaŋ köla imbi mohot aka keuŋiri jim solanimahot. Mewö qahö akŋahot ewö, kerökan ölöp örörahöm gihiiga (jas, majistreit) jimtekötekö toŋaŋgö jeŋe aŋgotnöŋga möta jii opotöröpkö böröŋe genöŋga kösö mire al gihibapuk. ");
INSERT INTO bmu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nöŋön keu ölŋi kewö jibi mötnöŋ, Gi miaŋgöreŋ töwagi pakpak almanaŋgö dop qaköba tatman. Toiyagi kondikŋi mewöyök al teköbagun mönö töwagi memba etman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Keu kun kewö jiget mötzema, ‘Sero yoŋgorö kude akŋan.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mewö jiget mötketmö, nöŋön keu mi kewö jim tuaribi mötme: Kunŋan serogö sihim kömbönaŋi qakŋe ambi uba ekzawi, yaŋön lök uruŋan yambuk sero yoŋgorö akza. ");
INSERT INTO bmu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Jegi ölŋan siŋgisöndok akŋangö kölgorom ak gihima ewö, mi mönö qözöla gilnöŋ anma. Sile kitipki kunŋan ayuhui mewö Suepnöŋ öŋgönöŋga dop kölmapmö, silegi jömukŋi malnöŋga gil gihigetka könöp sianöŋ geba ayuhubanbuk. ");
INSERT INTO bmu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Börögi ölŋan siŋgisöndok akŋangö kölgorom ak gihima ewö, mi mönö yandiba gilnöŋ anma. Sile kitipki kunŋan ayuhui Suepnöŋ öŋgönöŋga dop kölmapmö, silegi jömukŋi mala könöp sianöŋ geba ayuhubanbuk.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Keu kun kewö jiget ahöza, ‘Kunŋan anömŋi mosötmawi, yaŋön mönö aŋgömosötmosöt papia ohoba anömŋi waŋgima.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mewö jiget ahözapmö, nöŋön kewö jibi mötme: Kunŋan anömŋi qesabulum aiga mosötpawakmö, könaŋi kungöra anömŋi mosöt-mawi, mewö miaŋön mönö anömŋan qesabulum akŋapkö kondota siŋgisöndokö keuŋambuk akŋa. Mewö aiga azi kunbuk meiga azi dölökŋi miaŋön mönö mewöyök qesabulum akŋa.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Keu kun mi mewöyök möpŋeyök kewö jiget mötzema, ‘Keuŋini jöjöpaŋ keunöŋ jim köhöigeri, mi mönö kude oŋgitme. Kembugöra yuai akingö keuŋini jöjöpaŋ keunöŋ jim jöhögeri, mi mönö wuataŋgögetka ölŋambuk akŋa.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Mewö jiget mötketmö, nöŋön keu mi kewö jim tuaribi mötme: Keuŋini mönö jöjöpaŋ keunöŋ qahöpmahöp jim köhöime. Suep mi Anutugö jakömbuak dumŋi akzawaŋgöra aka keu kewö kude jime, ‘Keu ölŋi qahö jimam ewö, Suep Toŋan ölöp likepŋi meleŋni qakne öŋgöma.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Gölme mi Anutugö könaŋaŋgö döpŋi akzawaŋgöra aka keu kewö kude jime, ‘Keu ölŋi qahö jimam ewö, gölmenöŋ ölöp tiŋgita turum niŋgima.’ Jerusalem mi Kiŋ Tök-kutukutuŋaŋgö sitiŋi akzawaŋgöra aka keu kewöŋi mi mewöyök kude jime, ‘Keu ölŋi qahö jimam ewö, Kiŋ Ketaŋi yaŋön ölöp qemasolokepnaŋgö likepŋi meleŋni qakne öŋgöma.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gi nöröp jupki injaŋi menöŋ tuatŋi akŋapkö osiman aka nöröp jupki tuatŋi menöŋ injaŋi akŋapkö osiman. Miaŋgöra keu kewö kude jiman, ‘Keu ölŋi qahö jimam ewö, Anutunöŋ ölöp nöröpni qeiga jupŋaŋgö mundaŋan uteköma.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jöjöpaŋ keu kude jimemö, oŋ-keugöra mönö ‘Oŋ!’ jime aka qahö-keugöra ‘Qahö!’ jime. Keu diŋdiŋi miaŋgöreŋ keu yuai toroqemei, mi mönö Bölöŋaŋgö Toŋan sölölöhöm eŋgii asuhuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Keu kun kewö jiget mötzema, ‘Kunŋan jegi qösökömawi, gi mönö kitipŋi meleŋda yaŋgö jeŋi qösököman. Kunŋan jitki kumburatimawi, gi mönö kitipŋi meleŋda yaŋgö jitŋi kumburatiman.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","“Mewö jiget mötketmö, nöŋön keu mi kewö jim tuaribi mötme: Kunŋan bölöŋi ak eŋgimawi, i mönö kude qetala tuarenjoŋ ak waŋgime. Mewö qahöpmö, nuŋgulumgi ölŋi qekötahöma ewö, mönö nuŋgulumgi likepŋi mewöyök qekötahömapköra meleŋman. ");
INSERT INTO bmu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kunŋan ‘Sileötaŋgi memam,’ jiba keunöŋ al gihimamgö mötza ewö, mönö mosöta malukugi qakŋi mewöyök waŋginöŋga buŋa qem aŋguma. ");
INSERT INTO bmu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“Mewöyök kunŋan gösöŋi kilomita (mail) mohotkö dop siriba anmangö kuŋgum gihima ewö, mönö ölöp tem köla kilomita (mail) yahötkö dop siriba yambuk anman. ");
INSERT INTO bmu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kunŋan göhöreŋ yuai kungöra qesim gihimawi, mi mönö waŋgiman. Kunŋan ‘Yuai niŋginöŋga kitipŋi biaŋ meleŋmam,’ jiba qesim gihimawi, i mönö andö kude qeman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Keu kun kewö jiget mötzema, ‘Ambazip kösutŋine mala alaurupŋini akzei, mi jöpaköm eŋgimakŋemö, kazikurupŋini mönö meleŋda kazik ak eŋgiba malme.’ ");
INSERT INTO bmu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Mewö jiget mötketmö, nöŋön keu mi kewö jim tuaribi mötme: Iŋini mönö kazikurupŋini jöpaköm eŋgiba kinda sesewerowero ak eŋgimakzei, yeŋgöra mönö köuluköba malme. ");
INSERT INTO bmu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mewö ahakŋe ewö, mewö miaŋön Iwiŋinan Suep mire maljawi, mönö yaŋgö könaŋi kondela nahönböraturupŋi aka malme. Yaŋgö könaŋi kewö: Yaŋön wehönŋi qahö aŋgön köliga kota ambazip ölöpŋi aka bölöŋi mewöyök mem asarim eŋgiba kie aliga ambazip diŋdiŋi aka goŋgoŋi yeŋgö nupŋini mewöyök mem kelörakza. ");
INSERT INTO bmu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Eŋön mönö niŋginöŋ gihibigö tandökŋi oŋgita Anutugö könaŋi kondela ahakŋe. Takis tilipqilipŋinambuk megetka sisitŋini memakzei, yeŋön alaurupŋinan jöpaköm eŋgigetka i meleŋda jöpaköm eŋgimakze. Mi urumeleŋgö silikŋi qahö. Iŋini yeŋgö silik miyök wuataŋgöba ahakŋe ewö, Anutugöreŋ tosa kun qahö ahuiga yaŋön mönö silikŋinaŋgö likepŋi qahö eŋgiiga töwa kun qahö buŋa qem aŋgume. Miaŋgöra mönö ambazip körek pakpak jöpaköm eŋgiba malme. ");
INSERT INTO bmu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“Urumeleŋgö kopa ambazipnöŋ mewöyök sutŋine jölöŋini jim aŋguba maljemö, mi urumeleŋgö aiwesökŋi qahö. Iŋini yeŋgö dop alaurupŋini eŋgö sutŋineyök jölöŋini jim aŋgumakŋe ewö, mewö mönö kopa ambazip ewö akze. Kopa ambazip yeŋgö silikŋini mönö oŋgita qetpuk sorokŋi aka malme? ");
INSERT INTO bmu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Eŋgö Suep Iwiŋinan aködamun sorokŋi akzawi, eŋön mönö miaŋgö dop aködamun sorokŋinambuk aka malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisösnöŋ kewö kusum eŋgiyök, “Mönö kewögöra galöm mem aŋguba malme: Ahakmemeŋini solanŋi diŋdiŋi mi ambazipnöŋ eka eŋgöra mötket öŋgömapköra aka kude ahakŋe. Mewö ahakŋe ewö, eŋgö Iwiŋini Suepnöŋ maljawaŋön mönö silikŋinaŋgö likepŋi qahö eŋgiiga töwa qahö buŋa qem aŋgume. ");
INSERT INTO bmu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Miaŋgöra ‘Mözöqözöröŋ ambazip kalem eŋgimam,’ jiba mi qenjaröknöŋ kömam tömunbuk uba kolek almegöra kude akŋan. Urumeleŋgö silesile ambazip yeŋön ambazipnöŋ miwidimgöm (mem biwim) eŋgimegöra möta köuluk mire aka köna namŋe anda ambazip eŋgeka mewö ahakze. Nöŋön keu öl töhönŋi kun kewö jibi mötme, Yeŋön mönö silikŋinaŋgö töwaŋi pakpak lök buŋa qem aŋgugetka Suep Toŋan mi qahö toroqema. ");
INSERT INTO bmu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Göŋön mewö kude akŋanmö, ‘Mözöqözöröŋ ambazip kalem eŋgimam,’ jiba börögi ölŋan denöwö akzawi, börögi qaniŋan mi kude mötma. ");
INSERT INTO bmu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kalemgi miaŋön tölapŋe ahöiga Iwigan ahakmeme tölapŋi ehakzawi, yaŋön mönö töwa gihima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Miaŋgöra Anutugö köulukömei, mi mönö urumeleŋgö silesile ambazip yeŋgö dop kude akŋe. Yeŋön ambazipnöŋ eŋgekŋegöra möta sihimŋinan köuluk mire aka köna soŋanöŋ kinda köulukömakze. Nöŋön keu öl töhönŋi kun kewö jibi mötme, Yeŋön mönö silikŋinaŋgö töwaŋi pakpak lök buŋa qem aŋgugetka Suep Toŋan mi qahö toroqema. ");
INSERT INTO bmu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Göŋön mewö kude akŋanmö, ‘Anutugö köulukömam,’ jiba mönö nangi miri uruŋi moröŋe öŋgöba naŋgu köla Iwigi tölapŋe maljawi, i köuluköm waŋgiman. Mewö aknöŋga Iwigan ahakmeme tölapŋi ehakzawi, yaŋön mönö töwa gihima. ");
INSERT INTO bmu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Köulukömei, miaŋgöreŋ mönö urumeleŋgö kopa ambazip yeŋgö tandök ewö keu oyoŋdewetdewet mi kude jiba malme. Yeŋön keu jit sehisehiŋi jigetka Anutunöŋ miaŋgöra aka kezap ala möt eŋgimapkö mötmörimakze. ");
INSERT INTO bmu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mönö kewögöra yeŋgö dop kude aka malme: Iŋini wani yuaigöra osiba mözöqözöröŋ akzei, Iwiŋinan mi qahö köulukögetka qeljiŋe lök mötza. ");
INSERT INTO bmu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mönö kewö köulukömakŋe: “Neŋgö Iwinini, gi Suepnöŋ maljan. Göhö qetki mönö töröŋi ahöma. ");
INSERT INTO bmu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mönö galöm köl neŋginöŋga bemtohoŋgahö ölŋi asuhuma. Göhö jitsihitki Suepnöŋ tem kölakzei, mewöŋanök mönö gölmenöŋ asuhuma. ");
INSERT INTO bmu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Merakö neneŋi mönö dopnine neŋgiman. ");
INSERT INTO bmu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tosatŋi yeŋgöreŋ tosa neŋgöreŋ ahözawi, nini mi mosöt eŋgizin ewö, gi mönö miaŋgö dop neŋgö tosanini saŋgoŋman. ");
INSERT INTO bmu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Esapesapnöŋ et neŋgubapuköra mönö aŋgön köl neŋgiba Bölöŋi Toŋaŋgö böröŋeyök meköm neŋgiman. (Gi nangak bemtohoŋ Toŋi, kukösum Toŋi aka asakmararaŋ Toŋi mi nalöŋi nalöŋi mala kota malnöŋ aka teteköŋi qahö mal öŋgöman. Mi ölŋa.) ");
INSERT INTO bmu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Iŋini ambazip yeŋgö siŋgisöndokŋini mosötme ewö, eŋgö Suep Iwiŋinan mönö mewöyök eŋgö siŋgisöndokŋini mosötma. ");
INSERT INTO bmu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mosötmapmö, ambazip yeŋgö siŋgisöndokŋini qahö mosötme ewö, eŋgö Iwiŋinan mönö mewöyök eŋgö siŋgisöndokŋini qahö mosötma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nenegö siŋgi malmei, miaŋgöreŋ mönö urumeleŋgö silesile ambazip ewö kukbosole kude aka malme. Yeŋön Anutugöra nene siŋgi malakzei, ambazipnöŋ mi ekŋegöra aka zoloŋ örögetka jemesoholŋinan mölmölimakza. Nöŋön keu öl töhönŋi kun kewö jibi mötme, Yeŋön mönö silikŋinaŋgö töwaŋi pakpak lök buŋa qem aŋgugetka Suep Toŋan mi qahö toroqema. ");
INSERT INTO bmu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Göŋön mewö kude akŋanmö, Anutugöra nenegö siŋgi mala miaŋgöreŋ mönö sinim jupuknöŋ me saipenöŋ jemesoholgi saŋgoŋda nöröp jupki qeba malman. ");
INSERT INTO bmu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mewö aka nenegö siŋgi malnöŋga ambazipnöŋ qahöpmö, Iwigi tölapŋe maljawaŋön mi ekŋa. Mewö aknöŋga Iwigan ahakmeme tölapŋi ehakzawi, yaŋön mönö töwa gihima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Moneŋ inap yuai mi mönö gölmenöŋ ahöm eŋgimapköra kude tokome. Mewö tokogetka miaŋgöreŋ jijilukut kezaploŋloŋnöŋ mi yöhötigetka kahawet töromnöŋ (ros, ufeŋ) mem böliiga kegwek-kahasililiŋ yeŋön miri qesiŋda öŋgöba yoŋgorö memakze. ");
INSERT INTO bmu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","“Gölmenöŋ qahöpmö, Anutugö jitsihitŋi tem kölgetka qetbuŋaŋinan qarimapköra mönö kapaŋ kölme. Mewö aketka guli dötnamŋini qainŋi kun mi Suep mire ahöiga gurem jijilukutnöŋ mi qahö yöhötigetka kahawet töromnöŋ (ros, ufeŋ) mi qahö mem bölime. Kegwek-kahasililiŋ yeŋön eu qahö öŋgöba miri qesiŋda qahö yoŋgorö meme. ");
INSERT INTO bmu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yuaigöra aködamunŋi memba mötnöŋ öŋgözawi, miaŋön miri kungen ahöiga göŋön mönö urugi mewöyök miaŋgöreŋ qekötahöba malman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Göhö jegi mi uru silegahö kiwaŋi akza. Miaŋgöra kawöl kunöŋ jegi qahö mem böliza ewö, miaŋön mönö unöŋ asarim teköi Anutugö asakŋan ölöp uruge mem asariiga malmalgi pakpak asakŋe malman. ");
INSERT INTO bmu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","“Asakŋe malmanmö, sihim kömbönaŋi bölöŋan me yuai kunŋan jegi mem böliba asakŋi közambötza ewö, miaŋön silegö malmalgi pakpak mewöyök mem söŋauiga pandaman uruŋe jipjap malman. Mewö aiga söŋaupnöŋ urugahö asakŋi közamböri söŋauza ewö, nangi pandamanöŋ mönö Yei! keta bölökŋi wewelipŋambuk akza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kunŋan kembu yahöt welen qem etkimamgö osimakza. Kunŋan mewö akŋamgö mötzawi, yaŋön mönö kun kazik ak waŋgiba kun uruŋan jöpaköma. Kungöreŋ qekötahöba kun jijiwilit ak waŋgima. Miaŋgöra eŋön Anutu aka moneŋ inap mi mindiriba welen qem etkibingö osime.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mewö aiga nöŋön kewö jibi mötket: Iŋini gölmenöŋ malmeaŋgö waimanjatŋi mi kewö jiba kude akŋe, ‘Mönö wani yuainöŋ gumohom aŋgubinak aka wanatnöŋ sileninaŋgö löŋgötpinak?’ Jeŋinambuk maljei, miaŋön bohonŋi aiga nenenöŋ mönö miaŋgö nemböŋe akza. Sileŋinambuk maljei, miaŋön bohonŋi aiga opo sörönöŋ mönö miaŋgö nemböŋe ahöza. Mönö mi mötmörime. ");
INSERT INTO bmu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Könakemba neiŋi neiŋi mönö eŋgekŋe. Mieŋön nene kötŋi qahö qesiŋ gilakze. Padi ölŋi qahö yandiba köwe miriŋine qahö tokomakze. Mi qahöpmahöp aiga eŋgö Suep Iwiŋinan mönö töndup i gumohom eŋgimakza. Iŋini nei yeŋgö dop qahöpmö, eŋgö söŋgöröŋinan mönö nei söŋgöröŋini eŋgoŋgita öŋgöŋgöŋi akza me qahö? Mönö mi mötmöriget anök. ");
INSERT INTO bmu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Eŋgöreŋök kunŋan waimanjat aka mewö miaŋön gölmenöŋ malmawaŋgö nalöŋi mi sömaŋi mohotkö dop mem toroqema me qahö? Mi qahöpmahöp! ");
INSERT INTO bmu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Opo söröŋinaŋgöra mönö denöwögöra waimanjat akze? Mi qahö dop kölja. Sombemgö jariŋ juraŋi qarimakzei, mönö mi uba eŋgekŋe. Mieŋön opo söröŋinaŋgöra möt qahö loŋgalakze aka nup tosatŋi qahö memakze. ");
INSERT INTO bmu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","“Mi töndup nöŋön kewö jibi mötme, Kiŋ Solomonöŋ goul silwöŋi qeraköba asoŋbilikŋambuk malökmö, yaŋgö malukuŋi mi kiteŋ soranjiŋ me jura kungö dop eksihimŋambuk qahö ahöyök. ");
INSERT INTO bmu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sombemgö jariŋ juraŋi töhön merak kösutnine ahöi uran kölgetka eri qezaköba gila ohoget jemapmö, mi töndup Anutunöŋ mi ölöpŋanök meŋölömakza. Miaŋgöra yaŋön iŋini mewöyök ölöp esuhum eŋgima. Iŋini jariŋ juraŋaŋgö dop qahö. Anutunöŋ köyan köl eŋgimamgö möta miaŋgöra sihimŋi öŋgöŋgöŋi mörakza. O ambazip, mötnaripŋinan mönö wuanöŋgöra öne töhön morörökŋi akza? ");
INSERT INTO bmu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mewö aiga iŋini mönö malmalŋinaŋgö waimanjat aka mötkurumkurum kude ahakŋe. Mi aka lömböriba kewö jibepuk, ‘Nini mönö wani nene aka wani oya nembinak?’ aka ‘Wani yuainöŋ silenini esuhubinak?’ ");
INSERT INTO bmu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","“Mi kewögöra: Urumeleŋgö kopa yeŋön yuai pakpak mi buŋa qem aŋgubingö kapaŋ köla urukönöp ahakze. Iŋini yuai pakpaköra mözöröŋgöba osimakzei, eŋgö Suep Iwiŋinan mönö mi möt teköza. ");
INSERT INTO bmu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Miaŋgö urukönöp kude akŋemö, mutuk mönö Anutugö bemtohoŋnöŋ aŋgota yaŋgö jeŋe solanibingö kapaŋ kölme. Uruŋini miaŋgöreŋ alget ahöiga yaŋön mönö galöm köl eŋgiba yuai mewöŋi pakpak mi mewöŋanök eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Mewö aiga iŋini mönö uran malmeaŋgö waimanjatŋi kude ahakŋe. Urangö waimanjatŋi mi urangöra. Silim mohot mohotkö waimanjatŋini mönö nanŋök nanŋök bisiinga dopŋine akŋa.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jisösnöŋ toroqeba kewö jiyök, “Anutunöŋ keuŋini kewöta jim teköi etpepuköra mönö tosatŋi yeŋgö keuŋini kude kewöta jim teköme. ");
INSERT INTO bmu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Miaŋgö könaŋi kewö: Iŋini tosatŋi yeŋgö keuŋini kewöta jim tekömei, Anutunöŋ mönö dop mohot miaŋönök nanŋini keuŋini kewöta jim teköma. Iŋini tosatŋi yeŋgöra jimkutukutu ala memba öŋgöba eta kewöt eŋgimakzei, Anutunöŋ mönö miaŋgö dop nanŋini ak eŋgii öŋgöba erakŋe. ");
INSERT INTO bmu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Gi alagahö jeŋe gödöwöröt morörökŋi ekzanmö, nangi jege ip sahötŋi ketaŋi ahözawi, mia mönö wuanöŋgöra kude ek kutuzan? ");
INSERT INTO bmu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Me denöwögöra aka amqeba alagahöra kewö jizan, ‘Alani mötnöŋ, ni ölöp jegeyök gödöwöröt itaköbi etma?’ Mewö amqeba jizanmö, ip sahötŋi ketaŋi mi nange jege ahöza. ");
INSERT INTO bmu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","“O gi urumeleŋgö silesile azia, gi mönö mutuk nange jegeyök ip sahötŋi (tametŋi) ketaŋi memba gilman. Mi mem gilagun törörök ek kutuba alagahö jeŋeyök gödöwöröt morörökŋi mi ölöp itakönöŋga etma. ");
INSERT INTO bmu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yuaigöra mötketka tök-kutukutuŋi qainŋi kun akzawi, mi mönö kiam kude eŋgime. Guli damandaŋ qeqeŋi mi mönö bau wösöŋine kude gilget anma. Mewö akŋe ewö, yeŋön mönö mi könaŋinan tiahöm eŋgiba dumŋe meleŋda nanŋini eŋgöhöba yöhöqöhötim eŋgibepuk.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mönö Anutu köuluköme. Köulukögetka kewöta eŋgima. Urugö yuaigö Anutugöreŋ böröjaŋ memba jarume. Mi jarugetka kondeliga miwikŋaime. Kinda naŋgunöŋ qeme. Qegetka naŋguŋi öröm eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kunŋan Anutu köulukömakzawi, yaŋön mönö likepŋi buŋa qem aŋguma. Yuaigö jarumakzawaŋön mönö mi miwikŋaima. Naŋgunöŋ qemakzawaŋgöra mönö naŋgu öröm waŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mötket, ambazip eŋgöreŋök daŋön kewö akawak: Nahönŋan bisketköra qesiiga köt waŋgima? ");
INSERT INTO bmu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Me nahönŋan söragöra qesiiga qatö waŋgima? ");
INSERT INTO bmu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","“Mewö aiga iŋini ambazip bölöŋi aka töndup kalem ölöpŋi ölöpŋi nahönböraturupŋini eŋgibingö dop akze ewö, eŋgö Iwiŋini Suep mire maljawaŋön mönö kalemŋi denöwö aŋgön kölbawak? Yaŋgö uruŋaŋgö ahakmemeŋi mi neŋgoŋgita tandökŋi kun akza. Miaŋgöra iŋini yuai ölöpŋaŋgöra köuluköba qesim waŋgime ewö, yaŋön mönö sihimŋan mi eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Miaŋgöra ambazipnöŋ yuai pakpak nanŋinaŋgö ak eŋgimegö mörakzei, miaŋgö dop mönö nanŋini mewöyök i ak eŋgimakŋe. Mewö aketka Mosesgö Köna Keu aka kezapqetok ambazip Buzup Kimbi keuŋini miaŋön mönö ölŋinambuk aketka mindimindiri könaŋan aukŋe asuhuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Könöp sianöŋ gebingö könaŋi mi amqeqeŋi aka numbuŋaŋgö naŋguŋi mi ketaŋi. Ambazip sehisehiŋan naŋgu mi kutuba köna mi mötöteiba anme. Miaŋgöra iŋini mönö kiripo naŋgu giwikŋi kutuba miaŋgö uruŋe anme. ");
INSERT INTO bmu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","“Malmal köhöikŋe aŋgotpingö könaŋi mi pökpökŋi (pipitŋi) osukosubuk aiga numbuŋaŋgö naŋguŋi mi giwikŋi. Ambazip awamdökŋan naŋgu mi miwikŋaime.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kezapqetok ambazip takapulakaŋi yeŋön lamagö sile ewö esuŋini löŋgöta eŋgöreŋ kamakzemö, uruŋinan ubibi kiam kalŋi ewö akze. Miaŋgöra iŋini mönö yeŋgöra aka tihitŋini möta galöm mem aŋguba malme. ");
INSERT INTO bmu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nupŋinaŋgö ölŋi eketka könaŋini kondeli ölöp möt kutume. Nejoŋ kötŋi mi jömnöŋ asuhumakza me qahö? Warun kötŋi mi koururuknöŋ (köwörörök) asuhui tokomakzin me qahö? Qahö. ");
INSERT INTO bmu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","“Miaŋgö dop ip ölöpŋi pakpak mieŋön ölŋi ölöpŋi kuŋgumakzemö, ip bölöŋan mönö kötŋi bölöŋi kuŋgumakza. ");
INSERT INTO bmu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ip ölöpŋan ölŋi bölöŋi kuŋgumamgö osiza aiga ip bölöŋan kötŋi ölöpŋi kuŋgumamgö osiza. ");
INSERT INTO bmu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","“Ip pakpak ölŋi ölöpŋi qahö kuŋgumakzei, mi mönö galömŋan kutuba memba könöpnöŋ giliga geme. ");
INSERT INTO bmu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Miaŋgö dop ambazip mieŋgö nupŋinaŋgö ölŋi eketka könaŋini kondeli ölöp möt kutume.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nöŋgö Suep Iwinaŋgö jitsihitŋi tem kölakzawaŋön mönö yaŋgö bemtohoŋnöŋ aŋgotma. Gwötpuk yeŋön nöŋgöra ‘Kembuni, Kembuni!’ qeta jimakzemö, körek yeŋön Suepkö bemtohoŋnöŋ qahö aŋgotme. ");
INSERT INTO bmu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Jimtekötekögö nalö ketaŋi miaŋgöreŋ gwötpuk yeŋön kaba nöŋgöra kewö jime, ‘O Kembu Kembu, neŋön mönö göhö qetke yuai asuhumapkö kezapqetok keu qeljiŋe jiba malin. Neŋön mönö göhö qetkahö ösumnöŋ ömewöröme eŋguataŋgöba malin. Göhö qetkan mönö nam köl neŋgiiga aŋgöletot ösum-mumuŋinambuk gwötpuk memba malin. Mi ölum guhuza me?’ ");
INSERT INTO bmu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mewö jigetka nalö miaŋgöreŋ könaŋini aukŋe kewö jibi mötme, ‘Nöŋön iŋini nalö kunöŋ qahö möt eŋgial. Iwilele ahak ambazip, iŋini mönö nömosöta kesalget.’” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mewö aiga denike yeŋön keu jitni jizali, mi möta miaŋgö dop tem köla memakzei, nöŋön körek yeŋgö könaŋamŋini kondela mötkutukutu azigö dop ala kewö jimam, Yaŋön miriŋi jamönjiŋ köt qakŋe meyök. ");
INSERT INTO bmu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mewö meiga kie uru nalöŋe kie römbum yöhöba eriga göulu luhuiga luhut ketaŋi qeiga o göulu köhöikŋi gila miri selŋe kuŋguyökmö, miri mi jamönjiŋ köt qakŋe mei kinöhaŋgöra aka qahö kusuyök. ");
INSERT INTO bmu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Denike yeŋön keu jitni jizali, mi möta miaŋgö dop qahö tem köla memakzei, nöŋön körek yeŋgö könaŋamŋini kondela azi mötkutukutuŋi piromŋaŋgö dop ala kewö jimam, Yaŋön miriŋi sak kösahet qakŋe meyök. ");
INSERT INTO bmu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mewö meiga kie uru nalöŋe kie römbum yöhöba eriga o luhuiga luhut ketaŋi qeiga o göulu köhöikŋi gila miri selŋe kuŋgui kusuiga goromororoŋgöba erök.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisösnöŋ keu mi jim teköiga ambazip kambuŋi kambuŋi yeŋön mötketka kusum eŋgiyöhi, tandök miaŋgöra auruba welipköget. ");
INSERT INTO bmu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yaŋön yeŋgö Köna keugö böhiurupŋinaŋgö tandök qahö kusum eŋgiyökmö, kukösum Toŋi akzawaŋgö dop ambazip kusum eŋgiiga möta tandök miaŋgöra welipkögetka nemböŋini teköyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisösnöŋ kunduŋi mi mosöta eri könagesö kambulelembe ketaŋan andöŋe wuataŋgöget. ");
INSERT INTO bmu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mewö kagetka miaŋgöreŋ uzikuku azi kunöŋ kaba simin köla Jisösgö wösöŋe geba kewö jiyök, “O Kembu, göŋön sihimgan mem ölöwak niŋgimamgö mötzan ewö, mönö ni ölöp mem solanim niŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mewö jiiga böröŋi böraŋda sileŋi misiriba jiyök, “Nöŋön mi akŋamgö mötzal. Gi mönö solaniman.” Mewö jiiga uzikukuŋi mi miaŋgöreŋök solanii ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Solaniiga kewö jim kutum waŋgiyök, “Mötnöŋ, kiaŋgö buzup keuŋi mi kun kude jinöŋ mötme. Qahöpmö, mönö jike nup galömgöreŋ anda silegi kondel waŋgiman aka Mosesgöreŋ jimkutukutuŋi wuataŋgöba solani-zanaŋgö saiwap nalukŋi ala jöwöwöl ohoman. Mi ohonöŋ ehiga ambazipnöŋ könaŋamgi möt kutume.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisösnöŋ Kaperneam taonöŋ kaŋgoriga Rom suahö galöm kunŋan yaŋgöreŋ kaba köuluköba kewö jiyök, ");
INSERT INTO bmu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“O Kembu, nöŋgö nup azinaŋgö sileŋi likepŋan kömukömuŋi aiga sihimbölö kanjamŋambuk möta mire ahöza.” ");
INSERT INTO bmu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mewö jiiga kewö jii mörök, “Nöŋön mönö anda i mem ölöwakŋam.” ");
INSERT INTO bmu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mi möta kewö meleŋda jiyök, “O Kembu, ni mewöröpŋan malbiga nöŋgö miri boŋan goalöŋmapkö gamuni mötzal. Miaŋgöra keu jitkanök jinöŋga welen azinan ölöwakŋa. ");
INSERT INTO bmu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“Mi kewögöra: Ni nanak mewöyök galömnaŋgö kukösum bapŋe al niŋgigetka maljal. Nöŋgö bapne yarö azi malgetka mi jim kutum eŋgimakzal. Yeŋgöreŋök kungöra ‘Anman,’ jim kutubi yaŋön anma. Kungöra ‘Kanöŋ,’ jim kutubi yaŋön kama aka welen azini kungöra ‘Nup ki meman,’ jibiga yaŋön mi mema.” ");
INSERT INTO bmu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisösnöŋ keu mi möta welipköba ambazip wuataŋgöba kageri, yeŋgöreŋ liliŋgöba kewö jiyök, “Nöŋön keu ölŋi kun kewö jibi mötme: Israel könagesö sutŋine mewöyök mötnarip ketaŋi mewöŋi mi kungö uruŋe qahö miwikŋaial. ");
INSERT INTO bmu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Nöŋön keu kewö jibi mötme: Ambazip kambulelembenöŋ mönö wehön kotkotŋeyök aka wehön gegeŋeyök kaba Suepkö bemtohoŋ uruŋe kaŋgota Abraham, Aisak aka Jeikob yembuk nene sösöŋgai aka malme. ");
INSERT INTO bmu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yeŋön mewö malmemö, bemtohoŋgö nahönböraturup mi mönö eŋgömosöta aköm eŋgigetka pandamanöŋ yaigep geme. Miaŋgöreŋ malmei, yeŋön mönö sahöt gigilahöba irimŋini yöhözömgögetka qetŋi qeri malme.” ");
INSERT INTO bmu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mewö jiba suahö galömgöra kewö jiyök, “Gi mönö mirige anman. Mötnaripkahö dop mönö asuhum gihima.” Mewö jiiga welen aziŋan mönö aua miaŋgöreŋök ölöwahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisösnöŋ Pitögö mire anda Pitögö suhunŋan silekönöp kawöl yöhöi ahöiga ehök. ");
INSERT INTO bmu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","I eka böröŋe misiriiga silekönöpŋan mosöri wahöta könahiba Jisös nene ohoba gumohom waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mewö malgetka miri söŋauiga miaŋgöreŋ ambazipnöŋ alaurupŋini ömeŋinambuk mi gwötpuk eŋguaŋgita yaŋgöreŋ kaget. Kagetka ömewöröme mi keuŋan jiba közöl eŋgiiga kota anget aka kawöl ambazip pakpak mi mem ölöwak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mewö miaŋön Anutunöŋ keuŋi kezapqetok azi Aisaiagö uruŋe ali jii ahözawi, miaŋön ölŋambuk ahök. Keu mi kewö, “Yaŋön mönö neŋgö uzi kawölnini meiga qakŋe öŋgöiga bisiyök.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisösnöŋ ambazip kambu ketaŋi liliköm waŋgiget eŋgeka nalö miaŋgöreŋ gwarekurupŋi yembuk o aŋgö kutuba likep aŋgotpingö jim kutuyök. ");
INSERT INTO bmu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Köna keugö böhi kunŋan Jisösgöreŋ kaba kewö jii mörök, “Böhi, gi denike denike anmani, nöŋön mönö miaŋgöreŋ gi guataŋgöba kamam.” ");
INSERT INTO bmu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mi möta Jisösnöŋ kewö jii mörök, “Arökŋaŋgö kiam yeŋön köteŋine ahögetka könakemba nei yeŋön öŋgot jajöŋini memba malakzemö, Suep gölmegö azi ölŋan mönö denike anda nöröpŋi wani qömböŋnöŋ nariba luhut membawak?” ");
INSERT INTO bmu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mewö jii gwarek yeŋgöreŋök kunöŋ kewö jii mörök, “Mi ölöpmö, iwinan kömumamgö aiga mutuk jinöŋga anda galöm kölbi kömui löm kölbigun.” ");
INSERT INTO bmu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mewö jiyökmö, Jisösnöŋ meleŋda jiyök, “Mosötnöŋ, köhömuŋi yeŋön qamötŋini köhömuŋi mi ölöp löm kölmemö, göŋön mönö kaba ni nuataŋgöman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisösnöŋ anda waŋge uruŋe öŋgöiga gwarekurupŋan wuataŋgöba yambuk mohotŋe anget. ");
INSERT INTO bmu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Angetka raidimbom ketaŋan ömtöröp (töröpŋanök) o aŋgönöŋ asuhuba gilök. Giliga sirinöŋ waŋge uruŋe geiga numbuŋe qemamgö ahökmö, Jisösnöŋ gaun ahöyök. ");
INSERT INTO bmu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gaun ahöiga gwarekurupŋan anda möndöba jiget, “Hei Kembu, mönö bauköm neŋginöŋ. Nini aŋgönöŋ ayuhubingö akzin.” ");
INSERT INTO bmu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mewö jigetka meleŋda kewö jim eŋgiyök, “O iŋini mötnaripŋini morörökŋi, mönö wuanöŋgöra keŋgöt mötmöt azia akze?” Mewö jiba wahöta luhut aka siri jim qetal etkiiga sirinöŋ nöŋ qeba ahöyök. ");
INSERT INTO bmu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mewö aiga awöwöliba qesiba jiget, “Yei! Azi kia mönö denöwöŋan malja. Yaŋön mönö luhut aka köwet jim kutum etkiiga jitŋi tem köl waŋgizahot.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mewö asuhuiga o aŋgö kutuba likepŋe Gadara yeŋgö gölmenöŋ aŋgorök. Miaŋgöreŋ aŋgota azi ömeŋirambuk yahöt yetkön qaksirinöhök kaba Jisös miwikŋaiyohot. Yetkön irimsesewöl azi urukönöpŋirambuk ahotka kunŋan köna miaŋgöreŋ anmamgö osiyök. ");
INSERT INTO bmu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yetkön Jisös miwikŋaiba silata kewö qet gigilahöyohot, “Aek! Gi Anutugö Nahönŋi akzan. Gi mönö denöwö ak neŋgimamgöra kazan? Sihimbölö mötmöt nalöŋan qahö kam kuŋguiga qeljiŋe mi könöpŋambuk ak neŋgimamgö ki kazan me?” ");
INSERT INTO bmu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Miaŋgöreŋök köröwen qahöpmö, kösutŋine miaŋgöreŋ bau kambu ketaŋi kun gwözözak uruŋe kuluŋda malget. ");
INSERT INTO bmu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Miaŋgöra ömenöŋ kewö jiba Jisös ulet waŋgiget, “Göŋön nini közöl neŋgiman ewö, mönö melaim neŋginöŋga ölöp bau kambu mieŋgö uruŋine gebin.” ");
INSERT INTO bmu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ulet waŋgigetka Jisösnöŋ “Mönö anda geget,” jiba jim kutuyök. Mewö jim kutuiga miaŋgöreŋök azi uruŋireyök kota anda bau uruŋine geget. Gegetka bau kambu körek yeŋön mönö luhuba nembönembönöŋ anda jororoŋgöba o aŋgönöŋ geba nemulahöba kömuget. ");
INSERT INTO bmu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kömugetka bau galöm yeŋön ölöŋ unjurata taonöŋ anda keu buzupŋini pakpak jiget. Azi ömeŋirambuk yetköreŋ yuai asuhuyöhi, miaŋgö buzupŋi mewöyök jiget mötket. ");
INSERT INTO bmu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jiget möta taon ambazip pakpak yeŋön mosöta Jisös miwikŋaiba ekingö kaget. Kaba eka Jisösnöŋ yeŋgö mindimindiri sel gölme mosöta anmapkö ulet waŋgiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisösnöŋ waŋge uruŋe öŋgöba kunbuk o aŋgö kutuba likepŋe aŋgota nanŋe taonöŋ kayök. ");
INSERT INTO bmu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nalö miaŋgöreŋ azi tosatŋan alaŋini sile likepŋi kömukömuŋi tumbulahöpnöŋ ahöyöhi, mi kululunöŋ ala aŋguba kaget. Mewö kaba Anutu möt narim waŋgigeri, Jisösnöŋ yeŋgö tandökŋini mi ehi dop köliga kawöl azigöra kewö jiyök, “Nahöni, nöŋön siŋgisöndoki mosötzal. Mönö köhöiba ewebibigabuk saitiŋgit malman.” ");
INSERT INTO bmu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mewö jiiga Köna keugö böhi tosatŋan kinda uruŋinan kewö mötmöriget, “Azi kiaŋön mönö Anutu ilita mepaqepaik akza.” ");
INSERT INTO bmu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mewö mötmörigetmö, Jisösnöŋ mötmötŋini mi möt kutuba kewö jiyök, “Iŋini mönö wuanöŋgöra keu bölöŋi uruŋinan mötmörize? ");
INSERT INTO bmu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nöŋön ‘Siŋgisöndoki mosötzal,’ jizali, keu miaŋön mönö awamŋanök jijiŋa. Kunŋan mewö jiiga tosatŋan keu miaŋgö ölŋi qahö ekŋe. Miaŋgöra mi keu awamŋaŋgö dop. Nöŋön keu kun kewö jimamgö mötzal, ‘Mönö wahöta anöŋ.’ Keu mi mönö lömbötŋambuk jijiŋa akza. Mewö jibiga ölŋi ahuma me qahöwi, miaŋön mönö aukŋe asuhui ekŋe. ");
INSERT INTO bmu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Mötket, gölmenöŋ siŋgisöndok mosötmosötkö kukösumŋi mi Suep gölmegö azi ölŋaŋgöreŋ ahözawi, iŋini miaŋgö könaŋaŋgöra jaŋjuŋ malbepuk. Miaŋgöra keu lömbötŋi mi azi kiaŋgöra jibi ölŋi eket.” Mewö jiba azi sile likepŋi kömukömuŋaŋgö jeŋe eka jiyök, “Gi mönö wahöta tumbulahöpki memba mirige anöŋ. Keu lömbötŋi mi ölŋambuk akŋa ewö, keu awamŋi mi mönö mewöyök denöwögöra omaŋi akawak?” ");
INSERT INTO bmu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mewö jiiga miaŋgöreŋök wahöta miriŋe anök. ");
INSERT INTO bmu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mewö asuhuiga ambazip kambu yeŋön mi eka welipköba Anutu möpöseim waŋgiget. Gölme azigöra kukösum mewöŋi waŋgiyöhaŋgöra Anutu möpöseiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisösnöŋ miaŋgöreŋök anda takis ofis oŋgitmamgö aiga miaŋgöreŋ azi qetŋi Matyu tariga eka jii mörök, “Gi mönö nöŋgö andöne kanöŋ.” Mewö jii möta wahöta takis nup mosöta Jisösgö andöŋe anök. ");
INSERT INTO bmu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Anda Matyugö mire anda nene nemba tatkeri, nalö miaŋgöreŋ takis meme azi tilipqilipŋinambuk aka siŋgisöndok azi gwötpukŋan kaba Jisös aka yaŋgö gwarekurupŋi yembuk tata nene mohotŋe neget. ");
INSERT INTO bmu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mewö negetka Farisi (Köna keugö kapaŋkölköl) yeŋön mi eka Jisösgö gwarekurupŋi kewö jim eŋgiget, “Aek! Eŋgö böhiŋinan mönö wuanöŋgöra takis meme tilipqilipŋinambuk aka siŋgisöndok ambazip yembuk tata nene neza? Mi qahö dop kölja.” ");
INSERT INTO bmu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mewö jim eŋgigetka Jisösnöŋ likepŋi kewö jii mötket, “Sile unditundit ambazipnöŋ doktagöra qahö ak eŋgimakzapmö, kawöl ambazipnöŋ mönö doktagöreŋ anakze. ");
INSERT INTO bmu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nöŋön siŋgisöndok ambazip eŋgoholmamgöra kaba maljalmö, ambazip nanŋinaŋgö mötketka solanŋi akzei, i qahö. Miaŋgöra keu kiaŋgö könaŋi mönö anda kusum aŋguba mötme, ‘Nöŋön jöwöwöl ohobingö qahöpmö, ak kömum aŋgubingö sihimŋi mötzal.’” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nalö miaŋgöreŋ Jon O-melun azigö gwarekurupŋi yeŋön Jisösgöreŋ kaba kewö qesiget, “Neŋön aka Farisi (Köna keugö kapaŋkölköl) yeŋön Anutugöra nene siŋgi gwötpuk malahakzin. Nangi gwarekurupkan mönö wuanöŋgöra nene siŋgi qahö malje?” ");
INSERT INTO bmu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mewö qesigetka kewö meleŋnök, “Ölŋa, nini wani nalönöŋ nene siŋgi malakzin? Ambi meme nalöŋe azigö andöurupŋan könöpŋi algetka ambigö sepkitipurupŋan yuai mi tökömakze me qahö? Nöŋön nani gwarekurupni yeŋgö azi buŋaya aka yeŋgö sutŋine köisirik tatzal. Tatpiga yeŋön miaŋgöra aijölöŋ söŋgaiba tata siŋgi malbingö osimakze. Osimakzemö, Anutunöŋ noaŋgiri kömumbiga yeŋön mönö nalö miaŋgöreŋ ölöp siŋgi malakŋe. ");
INSERT INTO bmu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","(“Iŋini malmal walŋi aka sösöŋgai Buŋa dölökŋi mi mindirim etkibingö osime. Miaŋgö keu pasetŋi mi kewö jibi mötket:) Löŋgölöŋgöt walŋi jurariga kunöŋ opo dölökŋi qahö saŋgoŋsaŋgoŋi mitiba miaŋön opo su jöhanŋi qahö ala umgöreŋgömakza. Opo su jöhanŋi dölökŋi mewöŋan mönö waziba löŋgölöŋgöt walŋi öröiga kunbuk tiŋgiriga kinimŋan qariba böliqölibapuk. ");
INSERT INTO bmu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Mewöŋanök kunöŋ wain o dölökŋi mi jobö me toru walŋi lama sileŋan memeŋi miaŋgöreŋ qahö kusuiga gemakza. Mewö akawak ewö, wain o dölökŋan mönö qariba toru qesiŋniga jula mokoiga gölmenöŋ eta sohoiga toruŋan böliqölibepuk. Miaŋgöra wain o dölökŋi mi toru dölökŋeyök mokoin geiga dop kölma. Möwö ahinga mietkön ölöwakŋahot. (Mewöŋanök o ölöpŋi mi gina gisagisahöŋe qahö umakzin. Mewö ubinak ewö, miaŋön mönö jula kisipisirik eriga nemba kawöl neŋgöhöbapuk. Mewö akapuköra o ölöpŋi mi gina ölöpŋe umakzin. Iŋini mewöyök malmal walŋi aka Ölöwak Buŋa dölökŋi mi mindirim etkibingö osime.) Mewö.” ");
INSERT INTO bmu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisösnöŋ keu mi jii mötketka keu galöm kunŋan kaŋgota Jisösgö wösöŋe geba simin köla kewö köuluköm waŋgiyök, “Nöŋgö böratnan mönö dölki kömuzapmö, mönö kaba börögan sileŋe misirinöŋga guliba toroqeba malma.” ");
INSERT INTO bmu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Köuluköm waŋgiiga wahöta gwarekurupŋi yembuk i wuataŋgöba anget. ");
INSERT INTO bmu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Angetka miaŋgöreŋ sutŋine ambi kun malök. Yaŋön (yara) yambu 12 miaŋgö dop köiŋnöŋ ehiga nalö dop kawöl yöhöiga malök. Ambi miaŋön Jisösgö andöŋe kaba malukuŋaŋgö kitip suŋi misiriyök. ");
INSERT INTO bmu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mi misiriba nanŋaŋgöra kewö jiyök, “Nöŋön i oseimamgö möt lömböriba malukuŋeyök borom kun misiribileŋak ewö, mönö ölöp ölöwakŋam.” ");
INSERT INTO bmu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mewö jiba misiriiga Jisösnöŋ miaŋgöreŋök liliŋgöba i eka kewö jii mörök, “Böratni, mötnaripkan mönö mem ölöwak gihiza. Mönö köhöiba ewebibigabuk saitiŋgit malman.” Mewö jii möta aua miaŋgöreŋök ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Toroqeba angetka Jisösnöŋ keu galömŋaŋgö mire öŋgöba ambazip jiŋgeŋ köla awölop ugeri aka ambazip kambu göju gilgeri, mi eŋgeka kewö jim kutum eŋgiyök, ");
INSERT INTO bmu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Mönö yaigep anget. Ambi moröŋan qahö kömuzapmö, gaunök ahöza.” Mewö jim kutum eŋgiiga mötketka gönahit ewö aiga gön köl waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Gön köl waŋgigetmö, ambazip kambu ketaŋi mi jiiga yaigep angetka ambi moröŋaŋgö ahöahö miri uruŋe öŋgöba böröŋe meiga wahörök. ");
INSERT INTO bmu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wahöriga miaŋgö buzup keuŋan sehiba mindimindiri sel mi körek dop köla anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisösnöŋ miri gölme mi mosöta anmamgö ani jegömöl azi yahötŋan wuataŋgöba andöŋe kaba kewö qerohot, “Deiwidkö gwölönarökŋi, gi mönö ak kömum netkiman.” ");
INSERT INTO bmu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mewö qerohotka miri kungö uruŋe öŋgöiga jegömöl azi yetkön Jisösgöreŋ kayohotka kewö qesim etkiyök, “Jeŋiri mem tohomamgö kukösumŋi nöŋgöreŋ ahözawi, mi möt narizahot me qahö?” Qesim etkiiga kewö meleŋ waŋgiyohot, “Kembuniri, mi ölöp möt narizit.” ");
INSERT INTO bmu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mewö meleŋ waŋgiyohotka je dapötŋire misiriba jiyök, “Mötnaripŋiraŋgö dop mönö asuhuma.” ");
INSERT INTO bmu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mewö jiiga jeŋiran tohoyök. Mewö asuhuiga galöm meme keu köhöikŋi al etkiba kewö jiyök, “Mörohot, kiaŋgö buzupŋi mi kun kude jiyohot mötme.” ");
INSERT INTO bmu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mewö jiyökmö, yetkön mosöta anda miaŋgö buzupŋi jim sehiyohotka mindimindiri sel mi körek dop kölök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jeŋiri tohoi anohotka töŋöt azi keu jijiŋi qahö mi waŋgita Jisösgöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kagetka Jisösnöŋ ömeŋi közöli mötök azinöŋ keu jiiga ambazip kambu yeŋön mi eka welipköba jiget, “Tandök kewöŋi mi Israel uruŋe mönöwök nalö kungen qahö ehin. Qahö. Dölki je murutŋa ekzin.” ");
INSERT INTO bmu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mewö jigetmö, Farisi (Köna keugö kapaŋkölköl) yeŋön jiget, “Yaŋön mönö öme yeŋgö kembuŋinaŋgö ösumnöŋ ömewöröme eŋguataŋgömakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisösnöŋ anda miri aka taon dop liliköba ambazip köuluk miriŋine kusum eŋgiba bemtohoŋgö Ölöwak Buŋa jim asariba miaŋön uruŋini kuŋguba uzi kawöl aka jepajerepe könaŋi könaŋi mem ölöwak eŋgiba malök. ");
INSERT INTO bmu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mewö mala ambazip kambuŋi kambuŋi eŋgehiga lama galömŋini qahö tandök simbisembel aka iliŋgösöŋ qeŋgalaŋga malgetka yeŋgöra wösöŋi mörök. ");
INSERT INTO bmu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mewö eŋgeka gwarekurupŋi kewö jii mötket, “Anutugö nupnöŋ nene ölŋi gwötpuk öliba ahözapmö, mi tokobingö nup meme ambazipnöŋ mönö awamdökŋi malje. ");
INSERT INTO bmu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Miaŋgöra nene öliöliŋaŋgö Kembuŋan nup meme ambazip melaim eŋgimapköra mönö köuluköba malme. Köuluköm waŋgigetka nup ambazip asuhuba ölŋi mi mem tokome.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisösnöŋ gwarekurupŋi 12 eŋgoholi yaŋgöreŋ kagetka ömewöröme közöl eŋgimegö kukösumŋi al eŋgiyök. Mewöyök uzi kawöl qemjem-mamjeŋ könaŋi könaŋi mem ölöwakŋegö kukösumŋi al eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Melaimelai azi aposol 12 mieŋgö qetŋini kewö: mutukŋi yaŋön Saimon, qetŋi kun Pitö qetket aka yaŋgö munŋi Andru. Miaŋgö andöŋe Jeims aka munŋi Jon, iwiŋiri qetŋi Zebedi. ");
INSERT INTO bmu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip aka Bartolomyu, Tomas aka Matyu takis meme azi, Jeims Alfiusgö nahönŋi aka Lebeus qetŋi kun Tadius, ");
INSERT INTO bmu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Zelot-politik azia aka Judas Iskariot. Kariot azi miaŋön könaŋgen Jisös mamalolo mem waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisösnöŋ azi 12 mi melaim eŋgiba kewö jim kutum eŋgiba jiyök, “Iŋini kian kantrigö ambazip yeŋgöreŋ kude anme. Mewöyök Samaria prowins yeŋgö taonŋini kunöŋ kude anme. ");
INSERT INTO bmu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Miaŋgöreŋ kude anmemö, Israel könagesögö lama sohogeri, mönö yeŋgöreŋ anme. Mi nup mutukŋi. ");
INSERT INTO bmu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Denike denike anmei, miaŋgöreŋ mönö Buŋa keu kewö jiba jim asarime, ‘Suepkö bemtohoŋan mönö dowe kazawa miaŋgö uruŋe aŋgotme.’ ");
INSERT INTO bmu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Ambazip kawölŋinambuk mönö mem ölöwak eŋgiba kömukömuŋi mi mem gulim eŋgiba malme. Uzikuku ambazip mönö mem solanim eŋgigetka öme wöröme közöl eŋgiba malme. Anutunöŋ yuai kalema eŋgiyöhi, mi mönö toroqeba kalema eŋgiba malme. ");
INSERT INTO bmu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Köna anmeaŋgöra soujeŋi goul me silwö me ain kopönöŋ memeŋi mi mönö irimuŋgaŋine kude jöhöme. ");
INSERT INTO bmu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ambazipnöŋ nup meme ambazip malmalŋini naŋgömeaŋgö dop akze. Miaŋgöra köna anmeaŋgö yuaiŋi ki mi kude memba anme: gösö qahö, maluku semönŋi qahöpmö, mohot meme, köna esu qahö, öröp qahö. ");
INSERT INTO bmu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Anda taon me miri denike denike aŋgotmei, miaŋgöreŋ mönö daŋön azi ipŋi qetbuŋaŋambuk akzawi, miaŋgöra qesigetka miri eŋgimei, mönö miaŋgöreŋök mala nup memba taon mi mosöta köna anme. ");
INSERT INTO bmu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Miri kunöŋ öŋgöba luainöŋ yembuk ahömapkö jime. ");
INSERT INTO bmu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mi jigetka luaiŋini aŋgön kölmeaŋgö dop akze ewö, luaiŋinan mönö yeŋgö qakŋine öŋgömapmö, mi aŋgön kölmeaŋgö dop qahö akze ewö, luaiŋinan mönö liliŋgöba nanŋine kama. ");
INSERT INTO bmu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Anda mala miri kunöŋ aŋgotketka qahö köl öröm eŋgiba keuŋini qahö mötketka nesampurekŋini mönö kewö jiba kondel eŋgime, ‘Nini eŋgö gölmenöŋ kainga sölbuham köna tambönine mekötahözawi, mi mönö tim tönjöraringa nanŋine liliŋgöba gema.’ Mewö jiba ölöp miri me taon mi mosöta toroqeba anme. ");
INSERT INTO bmu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nöŋön keu ölŋi kun kewö jibi mötme: Anutunöŋ nalö ketaŋe qemasolokepŋinaŋgö likepŋi meleŋni taon miaŋgö qakŋe öŋgömawi, dop miaŋön mönö Sodom aka Gomora gölme yeŋgö dop oŋgita toroqem eŋgima.” (Sodom Gomora yeŋön bölöŋi kanjamŋambuk memba uruŋini qahö meleŋgetka Anutunöŋ könöpnöŋ köndeŋ eŋgiyök.) Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mötket, lama yeŋön arökŋaŋgö kiam kalŋi yeŋgö sutŋine gegetka luhuba eŋgöhöbepuk, nöŋön iŋini miaŋgö tandök ewö melaim eŋgibi anme. Miaŋgöra mönö mokoleŋ ewö mötkutukutu qakŋe galöm mem aŋguba mala kembö ewö ambazip bönjöŋi köpösihitkö keuŋini qahö malme. ");
INSERT INTO bmu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ambazipnöŋ iŋini öröba keu jakeŋine al eŋgiba köuluk miriŋine keu nupŋini memba ihilek wahiŋambuknöŋ tauköm eŋgime. Miaŋgöra ambazip mewöŋi yeŋgöra mönö galöm mem aŋguba malme. ");
INSERT INTO bmu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“Tosatŋan nöŋgöra aka eŋguaŋgitketka kantriŋi kantriŋi yeŋgö kiŋ kembu aka premiö yeŋgö jemesoholŋine kinme. Mewö kinda nöŋgö könaŋamni naŋgöba jigetka azi ipŋi mi aka kian kantri könagesö yeŋön mi mötme. ");
INSERT INTO bmu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mi mötmemö, keu jakeŋe al eŋgigetka kinmei, nalö miaŋgöreŋ wani keuya denöwö jibinak, miaŋgö waimanjatŋi kude mötme. Keu jimei, mi Uŋa Töröŋan aua miaŋgöreŋök eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nanŋine uruŋineyök keu kude jimemö, Iwiŋinaŋgö Uŋa Töröŋan mönö uruŋini sölölöhöiga keu jime. ");
INSERT INTO bmu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Urumeleŋgö kopa kunöŋ darumunŋan uruŋi meleŋnö-haŋgöra aka i mamalolo meiga keu jakeŋe algetka qeget kömuma. Mewöyök iwi kunöŋ nahönböratŋi mamalolo meiga kömuma aka nahönbörat yeŋön iwinamurupŋini qetal eŋgiba jigetka eŋguget kömume. ");
INSERT INTO bmu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nöŋgö qetnaŋgöra aka kantriŋi kantriŋi yeŋön körek kazik al eŋgigetka malmemö, kunŋan kapaŋ köla nalö tekömawaŋgö dop köhöiba böŋ qeba kinmawi, yaŋön mönö oyaeŋkoyaeŋ buŋa qem aŋguma. ");
INSERT INTO bmu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Taon kunöŋ sesewerowero ak eŋgimei, mi mönö kök ala taon kunŋan anme. Nöŋön keu ölŋi kun kewö jibi mötme: Iŋini Israel taonŋi taonŋi qahö liliköm tekögetka Suep gölmegö azi ölŋan mönö liliŋgöba kama. ");
INSERT INTO bmu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Gwarek kunŋan böhiŋi oŋgita mötmötŋambuk qahö akza aka welenqeqe kunŋan ketaŋamŋi oŋgita nupkö mötmöt qahö memba malja. ");
INSERT INTO bmu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","“Gwareknöŋ böhiŋi ewö mötmötŋambuk aiga dop kölma aka welenqeqenöŋ ketaŋamŋi ewö nupkö mötmöt memba maliga dop kölma. Miri uruŋi kungö saiwa galömŋi jim böliba qetŋi Katakömulat qetket ewö, yaŋgö saiwaurupŋi yeŋgö qetŋini mönö amqeba awamŋanök mewö qerakŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ambazipnöŋ yuai önun meget ahözawi, mi pakpak mönö luluŋgetka aukŋe ahuma. Mewöŋanök keu asambötket ahözawi, mi pakpak mönö indelgetka möt kutume. Miaŋgöra ambazip yeŋgöra keŋgötŋini kude möta malme. ");
INSERT INTO bmu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nöŋön keu söŋaupnöŋ ölöŋ jimami, mi mönö asakŋe jime. Keu saŋep algetka kezapŋine gei mötmei, mi mönö sombemnöŋ aukŋe jime. Miaŋgöra mönö keuŋinaŋgö galöm memba malme.” ");
INSERT INTO bmu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Tosatŋan sileŋini qem kömumbeakmö, uŋaŋini qem kömumbingö osimei, yeŋgöra keŋgötŋini kude möta malme. Mi qahöpmö, yuai mutukŋi ki: Kunŋan kukösum memba uŋa aka sile mohot ayuhum etkiiga könöp sianöŋ gemahori, yaŋgöra mönö keŋgötŋini möta malme. ");
INSERT INTO bmu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tosatŋan bekösöm (jöjöröm, ulisit) yahöt moneŋ kötŋi mohot-töpnöŋ söŋgöröŋi memegöra alakzemö, etkerigetka Iwiŋinan oŋ qahö jiiga yetköreŋök mohotnöŋ gölmenöŋ qahö etma. ");
INSERT INTO bmu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","“Anutunöŋ köyan köl eŋgiba nöröp jupŋini pakpak mewöyök oyoŋ teköba jaŋgöŋini mötza. ");
INSERT INTO bmu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ambazip eŋgö söŋgöröŋini mi bekösöm ulisit gwötpuk eŋgoŋgita öŋgöŋgöŋi akza. Miaŋgöra keŋgötŋini mönö kude möta malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mewö aiga kunŋan ni ambazip jeŋine jim miwikŋaim niŋgimawi, nöŋön mönö mewöŋanök i Iwini Suep mire maljawaŋgö jeŋe jim miwikŋaimam. ");
INSERT INTO bmu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mewömö, kunŋan ni ambazip jeŋine qaŋ köl niŋgimawi, nöŋön mönö mewöŋanök Iwini Suep mire maljawaŋgö jeŋe qaŋ kölmam.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisösnöŋ toroqeba kewö jiyök, “Kewö kude mötmörime: Jisösnöŋ luai qemamgöra aka gölmenöŋ erök. Nöŋön luai qemamgöra qahöpmö, nöŋgöra aka jula deŋgetka bimgö sou ketaŋan aume. ");
INSERT INTO bmu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","“Mi kewögöra jizal: Nöŋgö Buŋa keunan ambazip uruŋini kuŋgui meleŋgeraŋgöra kewö asuhuma, ‘Iwi morö yetkön jula kerök-kerök ahotka nam morö yetkön tötal aŋguyohotka iranŋan iranŋi qetala julmahot. ");
INSERT INTO bmu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ambazip nanŋini saiwaurupŋinan mönö kerökurupŋini akŋe.’ ");
INSERT INTO bmu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kunŋan ni göragöra al niŋgiba iwiŋi me namŋi jegep ala jöpakömawi, yaŋön mönö nöŋgöreŋ qahö dop kölma. Kunŋan ni göragöra al niŋgiba nahönŋi me böratŋi jegepŋe ala jöpakömawi, yaŋön mönö nöŋgöreŋ qahö dop kölma. ");
INSERT INTO bmu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sisitŋini megetka kunŋan ni nuataŋgöba sihimbölö möta maripomnöŋ kömumamgö qahö jöjörömawi, yaŋön mönö nöŋgöreŋ qahö dop kölma. ");
INSERT INTO bmu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Kunŋan nanŋi malmal siyoŋsayoŋi qahö mi miwikŋaimawi, yaŋgö malmalŋan mönö sohoma. Kunŋan nöŋgöra aka malmalŋi köleŋniga sohomawi, yaŋön mönö oyaeŋkoyaeŋ malmal miwikŋaima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisösnöŋ jiyök, “Kunŋan iŋini miriŋe köl öröba köyan köl eŋgimawi, yaŋön mönö ni köl öröm niŋgima. Kunŋan ni köl öröm niŋgimawi, yaŋön melaim niŋgiyöhi, mönö i miriŋe köl öröm waŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kunŋan kezapqetok ambazip kun kezapqetok nupŋaŋgöra aka miriŋe köl öröba köyan kölmawi, yaŋön mönö kezapqetok ambazipkö töwaŋi buŋa qem aŋguma. Kunŋan ambazip solanŋi kun solanŋi akzawaŋgöra aka miriŋe köl öröba köyan kölmawi, yaŋön mönö ambazip solanŋaŋgö töwaŋi buŋa qem aŋguma. ");
INSERT INTO bmu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Kunŋan morö kieŋgöreŋök kungöra nöŋgö gwarekni akzawaŋgöra aka o amötŋi qambiŋambuk nemapköra waŋgimawi, Anutunöŋ mönö miaŋgö töwaŋi meleŋda waŋgima. Nöŋön keu ölŋi kun kewö jibi mötme: Naŋgöm eŋgimei, mieŋön mönö töwa meme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisösnöŋ gwarekurupŋi 12 keu mewö kusum eŋgii teköiga miri mi mosöta toroqeba Galili prowinsgö taon tosatŋe anda Buŋa keu kusum eŋgiba miaŋön uruŋini kuŋguba malök. ");
INSERT INTO bmu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nalö miaŋgöreŋ Jon O-melun azinöŋ kösö mire tata Kraistnöŋ nup mewö meyöhi, mi möta gwarekyahötŋi melaim etkii Jisösgöreŋ anohot. ");
INSERT INTO bmu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kewö qesim waŋgimahotköra melaim etkii anda jiyohot, “Mem ölöwak azi kamapköra mambörakzini, göŋön mia akzan me azi kun biaŋ kamapköra mambötpin?” ");
INSERT INTO bmu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mewö qesim waŋgiyohotka kewö meleŋnök, “Yuai eka mötzahori, miaŋgö kösohotŋi mönö anda Jon kewö jiyohot mötma: ");
INSERT INTO bmu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jegömöl yeŋön jeŋini uba eketka lokon yeŋön köna anda kagetka uzikuku yeŋön solanigetka kezapduhup yeŋön keu mötketka kömuget yeŋön guliba wahötketka etqeqeŋi yeŋgöra Ölöwak Buŋa jim asaribiga mörakze. ");
INSERT INTO bmu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mewö asuhui eketka kungö uruŋan qahö bölii andö nuŋgumawi, yaŋön mönö simbawoŋ akza.” ");
INSERT INTO bmu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mewö jiiga Jongö gwarek yetkön anohotka Jisösnöŋ könahiba Jongö könaŋi ambazip kambu yeŋgöra kewö jim asariyök, “Iŋini gölme qararaŋkölkölŋe miaŋgöreŋ wania ekingöra anget? Luhutnöŋ jehot uwutapköba metali anjaŋbanjaŋ ahakzawi, iŋini azi mewöŋi ekingöra anget me? ");
INSERT INTO bmu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Me wanat yuaia ekingöra anget? Azi malukuŋi aködamunŋambuk löŋgöta malöhi, mi ekingöra me? Mötket, ambazip malukuŋini eksihimŋinambuk löŋgörakzei, mieŋön mönö kiŋ yeŋgö jakömbuak miriŋine malje. Mi gölme qararaŋkölkölŋe qahö. ");
INSERT INTO bmu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Me wanat yuaia ekingöra anget? Kezapqetok azi kun ekingöra me? Ölŋa, nöŋön kewö jibi mötket: Azi ekeri, yaŋön mönö kezapqetok ambazip pakpak eŋgoŋgita tandökŋi kun akza. ");
INSERT INTO bmu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yaŋgö könaŋi mi mönöwök kewö ohoget ahöza, ‘Mötnöŋ, nöŋön kolekni garata kun melaibiga qeljiŋe anda ambazip uruŋini mindiŋgöba göhö könagi mesariga göŋön mönö yaŋgö andöŋe gölmenöŋ emu geman.’ ");
INSERT INTO bmu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Keu mewö ahözapmö, nöŋön keu ölŋi kun kewö jibi mötket: Ambinöhök morö pakpak asuhugeri, yeŋgö sutŋine Jonöŋ mönö körek eŋgoŋgita qetbuŋaŋambuk kinja. Kinjapmö, Suepkö bemtohoŋ uruŋe aŋgota Anutugö qetbuŋaŋi miwikŋaimakzei, yeŋgö sutŋine eretŋi kondikŋi yaŋön mönö Jon oŋgitza. ");
INSERT INTO bmu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Jon O-melun azinöŋ Buŋa keu jiiga nalö miaŋgöreŋök könahiba Suepkö bemtohoŋi könöpŋambuk tuarenjoŋ aka yarö gilakzemö, töndup ösumŋan anda qarimakza. Könöpŋinambuk yarö gilakzeaŋön mönö bemtohoŋ mi nanŋinaŋgöra öröba buŋa qem aŋgumakze. ");
INSERT INTO bmu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bemtohoŋgö könaŋi mi Mosesgöreŋ Köna keunöŋ aka kezapqetok ambazip körek yeŋgö Buzup Kimbiŋine ohogetka oyoŋda mala koringa Jonöŋ asuhuba ölŋi aukŋe indelök. ");
INSERT INTO bmu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Keu ki möt aŋgön kölbingö mötze ewö, Elaija (Elia) asuhumawaŋgö dop ahöhi, Jonöŋ mönö mia akza. ");
INSERT INTO bmu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kunŋan urukezapŋambuk maljawi, yaŋön mönö keu mi kezap ala möt kutuma. ");
INSERT INTO bmu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ambazip merak gölmenöŋ maljei, mi mönö wanatpuk dop al eŋgibileŋak? Yeŋön namande ewö akze. Mieŋön maket sombemnöŋ tata keu gön gila laŋ qeta kewö jimakze, ");
INSERT INTO bmu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nini awölop uinga iŋini liŋet gwawet qahö unduget. Nini jiŋgeŋ kölinga iŋini qahö toroqeba sahötket.’ ");
INSERT INTO bmu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Miaŋgö könaŋi kewö: Jon O-melun azinöŋ kaba nene siŋgi mala wain o qahö neiga yaŋgöra jimakze, ‘Öme kunöŋ uruŋe geiga malja.’ ");
INSERT INTO bmu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Suep gölmegö azi ölŋan kaba nene nem söŋgaip aiga yaŋgöra kewö jimakze, ‘Mötket, yaŋön bau numbu tandök közöjeriba wain o gwötpuk nemba takis tilipqilipŋinambuk aka bölöŋi meme yeŋgö alaŋina malja!’ Anutugö mötkutukutu köl gulimakzei, yeŋgö ahakmemeŋinaŋgö ölŋan mönö mötkutukutu-ŋinan dop köljawi, mi kondelakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Miaŋgö andöŋe Jisösnöŋ könahiba taon tosatŋi tembul eŋgiyök. Taon tosatŋi mieŋgöreŋ aŋgöletotŋi kukösumŋinambuk sehisehiŋi meiga asuhugetmö, töndup uruŋini qahö meleŋget. Miaŋgöra i tembula kewö jim eŋgiyök, ");
INSERT INTO bmu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“O Korazin toŋi, nöŋön eŋgöra Yei! jiba sahötzal aka Betsaida toŋi, eŋgöra mewöyök Yei! jiba sahötzal. Nöŋön yeŋgöreŋ anbiga keuni jibi sösönihii aŋgöletotni kukösumŋinambuk asuhugetmö, uruŋini töndup qahö meleŋget. Aŋgöletot mi kian gölmenöŋ Taiö aka Saidon sitinöŋ asuhubeak ewö, yeŋön mönö nalö köröpŋi uruŋini meleŋbingö kaisöpsöpŋi kondela dodohonöŋ aŋgömiriba kau ariba sahötpeak. ");
INSERT INTO bmu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Sahötpeakmö, nöŋön kewö jibi mötme: Anutunöŋ könaŋgep Korazin aka Betsaida yeŋgö keuŋini jim teköba likepŋi meleŋni sihimbölö mötmei, nalö ketaŋi miaŋgöreŋ mi mönö Taiö aka Saidon yeŋgö sihimbölö dopŋi oŋgita mötme. ");
INSERT INTO bmu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Aka Kaperneam toŋi, Anutunöŋ iŋini ölöp mem wahöt eŋgii Suep mire öŋgöbeak me qahöpto? Qahöpmahöp! Iŋini mönö kömupkö senjom mire kölölohoba geme. Nöŋön yeŋgöreŋ anbiga keuni jibi sösönii aŋgöletotni kukösumŋinambuk asuhugetmö, uruŋini töndup qahö meleŋget. Aŋgöletot mi Sodom taonöŋ asuhubeak ewö, taon miaŋön mönö nalö kewöŋe mewöyök toroqeba kinbawak. ");
INSERT INTO bmu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“Kinbawakmö, nöŋön kewö jibi mötme: Anutunöŋ könaŋgep Kaperneam eŋgö keuŋini jim teköba likepŋi meleŋni sihimbölö mötmei, nalö ketaŋi miaŋgöreŋ mi mönö Sodom gölme yeŋgö sihimbölö dopŋi oŋgita mötme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nalö miaŋgöreŋ Jisösnöŋ keu kewö jiyök, “O Iwini, göŋön Buŋa keugi mötkutukutu ambazip mötmöt ketaŋi megeri, yeŋgöreŋ asambötnöŋmö, ambazip nahönbörat ewö nanŋinaŋgöra mötketka gukmaulem akzei, mi mönö yeŋgöreŋ indelnöŋga möt asarize. Miaŋgöra nöŋön Suep gölmegö Kembuŋi gi möpöseim gihizal. ");
INSERT INTO bmu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Iwini, gi nangak mewö asuhumapköra mötnöŋ dop köli ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Iwinan mönö yuai pakpak jim kutuiga nöŋgö buŋaya ahök. Iwinan Nahönŋaŋgö könaŋi nanŋök möt yaköiga kunöŋ mi qahö mötza. Mewöyök Nahönŋan Iwiŋaŋgö könaŋi möt yaköiga kunŋan mi qahö mötza. Mewöyök kunŋan Iwinaŋgö könaŋi qahö möt yaköiga Nahönŋanök mi mötza aka ambazip möwölöhöm eŋgiba yeŋgöra mi indelmawi, yeŋön mönö Iwi möt waŋgime. ");
INSERT INTO bmu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nup memba urulömbötŋinambuk maljei, iŋini mönö körek nöŋgöreŋ kagetka uruawam eŋgibi luhut meme. ");
INSERT INTO bmu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nöŋgö temni mönö awötŋine ala aŋgugetka Buŋani kusum eŋgibi mi möt soroköba malme. Nöŋön uruni memba et ala guŋbönjönjöŋ azia akzalaŋgöra ölöp uruawam eŋgibi luhut miwikŋaime. ");
INSERT INTO bmu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nöŋgö temni meget aŋguinga dopŋine akza aiga lömböt eŋgibi bisimei, miaŋön mönö awamŋi akza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Miaŋgö andöŋe Sabat kendon kunöŋ Jisösnöŋ wit padi nup köröŋi ketaŋi kutuba anök. Aniga gwarekrupŋan wösöŋini eŋguiga wit ölŋi mohot mohot könahiba böröŋinan misiba neget. ");
INSERT INTO bmu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Negetmö, Farisi (Köna keugö kapaŋkölköl) tosatŋan mi eka Jisös kewö jiget mörök, “Mötnöŋ, göhö gwarekurupkan mönö Sabat kendongö nup meme soŋgoŋi oŋgitze?” ");
INSERT INTO bmu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mewö jigetka kewö meleŋnök, “Kiŋ Deiwidnöŋ yarö aziurupŋi yembuk liliköba wösöŋini eŋguiga yuai akeri, mi lök oyoŋget me qahö? ");
INSERT INTO bmu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yaŋön mönö Anutugö opo seri jikenöŋ öŋgöba beret kömbukŋi Anutugö jemesoholŋe altanöŋ alget tariga ösumŋan walöŋniga qekögeri, mi mönö meiga neget. Beret kömbukŋi mosötmosötŋi mi jike nup galöm yeŋönök nezema. Yaŋön aka yaŋgö suŋgurumurupŋan mi nembepuköra soŋgo ahöyökmö, mi töndup neget. ");
INSERT INTO bmu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mewöŋanök jike nup galöm yeŋön Sabat kendonöŋ jöwöwöl jikenöŋ kinda nup memba nup memegö soŋgoŋi oŋgita töndup keuŋinambuk qahö ahakze. Keu mi Köna keunöŋ oyoŋget me qahö? ");
INSERT INTO bmu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Mi oyoŋget, mewö mötzalmö, nöŋön kewö jibi mötme: Ki kinjawi, yaŋön mönö jöwöwöl jike oŋgita öŋgöŋgöŋi akza. ");
INSERT INTO bmu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Buŋa Kimbigö keu kun kewö ahöza, ‘Nöŋön jöwöwöl ohomegöra qahöpmö, sutŋine ak kömum aŋgumegöra mötzal.’ Iŋini keu miaŋgö könaŋi mötpeak ewö, ambazip pinjitkö keunini qahö neŋgö keunini mönö laŋ qahö jim teköbeak. ");
INSERT INTO bmu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Mi kewögöra jizal: Suep gölmegö azi ölŋan mönö Sabat kendongö Kembuŋi akza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisösnöŋ miri mi mosöta köuluk miriŋine öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Miaŋgöreŋ azi böröŋi sosoholiŋi kun tarök. Ambazipnöŋ Jisös keu jakeŋe al waŋgibingöra kewö qesim waŋgiget, “Azi Sabat kendonöŋ möhamgöba Köna keu oŋgitpin me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Qesim waŋgigetka kewö meleŋnök, “Eŋgöreŋök daŋön kewö akza: Azi kungö lamaŋi mohok-kunŋan Sabat kendonöŋ lömnöŋ gema ewö, yaŋön mi qahö memba öröiga kotma? ");
INSERT INTO bmu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Azigö bohonŋan mönö lamagö bohonŋi gwötpuk oŋgitzawi, mönö mi mötmörime. Miaŋgöra Sabat kendonöŋ nup ölöpŋi memba mewö Köna keu qahö oŋgitpin.” ");
INSERT INTO bmu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mewö meleŋda azi miaŋgö jiyök, “Gi mönö börögi qötöteinöŋ.” Mewö jiiga qötöteiiga mutuk ahöhi, miaŋgö dop ölöwaka böröŋi alaŋaŋgö dop ahök. ");
INSERT INTO bmu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mewö asuhuiga Farisi (Köna keugö kapaŋkölköl) yeŋön yaigep anda totoko ala Jisös denöwö aka qein kömumapkö keu jim jaruget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisösnöŋ keuŋini mi ek kutuba miaŋgöreŋök miri mi mosöta kungen anök. Aniga gwötpukŋan yaŋgö andöŋe wuataŋgöba angetka yeŋgö sutŋine kawöl ambazip pakpak mem ölöwak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mi mem ölöwak eŋgiba könaŋi aukŋe jibepuköra köhöikŋanök qetal eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mewö aiga Anutunöŋ kezapqetok azi Aisaia sölölöhöiga keu kun jiyöhi, miaŋön mönö mewö ölŋambuk ahök. Keu mi kewö jii ahöza, ");
INSERT INTO bmu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Eket, ki mönö nöŋgö nup azini aiga i möwölöhöm waŋgial. Nöŋön wölböt alani yaŋgöra mötpi ölöwahiga urunan yaŋgöra söŋgaimakzal. Nöŋön Uŋani Töröŋi yaŋgö uruŋi dop kölmapköra melaibi geiga yaŋön keu diŋdiŋanök jim tekömakzalaŋgö Buŋaŋi indela jim sehiiga kantriŋi kantriŋi yeŋgöreŋ anma. ");
INSERT INTO bmu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yaŋön aŋgururuk qahö aka keu töhöreŋ qahö qerakŋa. Ambazip kunŋan yaŋgö qet kourukŋi mi rowoŋqeqe könanöŋ qahö mötma. ");
INSERT INTO bmu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jehot qölökögeri, yaŋön mi qahö qesiŋma. Lambegö wikŋan jem kutuba sanjöp aiga bölamŋan jem bökbök ahakzawi, yaŋön mönö mi qahö qömbököma. Mewö nupŋi memba ambazipnöŋ keu diŋdiŋi wuataŋgömegöra bim qeba maliga keu miaŋön luhut aliga köiraŋ alme. ");
INSERT INTO bmu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kantriŋi kantriŋi yeŋön mönö yaŋön bauköm eŋgimapköra mamböta jörömqörömŋini yaŋgö qetŋe ala malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ömenöŋ azi kun töŋöt aka numbuŋi jöhöiga jeŋan gömölii mötök malöhi, mi waŋgita Jisösgöreŋ kaget. Jisösnöŋ i mem ölöwahiga ömeŋan kota mosöri nesilamŋan lolohoiga kunbuk keu jiba uba ehök. ");
INSERT INTO bmu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Uba ehiga ambazip kambu pakpak yeŋön mi eka auruba Jisösgöra jiget, “Azi kiaŋön mönö Deiwidkö gwölönarökŋi akza me?” ");
INSERT INTO bmu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mewö jigetmö, Farisi (Köna keugö kapaŋkölköl) yeŋön mi möta kewö jiget, “Azi kiaŋön kungö ösumnöŋ qahöpmö, öme yeŋgö Kembuŋini Katakömulat yaŋgö ösumnöŋ ömewöröme eŋguataŋgömakza.” ");
INSERT INTO bmu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mewö jigetmö, Jisösnöŋ urumötmötŋini möt teköba kewö jii mötket, “Kantri denike yeŋgö galömurupŋinan sutŋine aŋgururuk aka julmei, yeŋön mönö ayuhum aŋgugetka kantriŋinan böliba sahopŋanök aka qeqelaŋlaŋ ahöma. Mewöyök siti me miri kungö könagesö yeŋön sutŋine aŋgururuk aka julmei, yeŋön mönö galömkölköl nupŋini memba kinbingö osime. ");
INSERT INTO bmu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Mötket, Satanöŋ mönö alaŋi Satan kun wuataŋgöbawak ewö, yeŋön mönö sutŋine aŋgururuk aka julbeak. Mewö aiga gawman nupŋini membingö osigetka ömetohoŋinan mönö denöwö kinbawak? ");
INSERT INTO bmu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Mötket, nöŋön Katakömulatkö ösumnöŋ ömewöröme közöl eŋgibileŋak ewö, eŋgö alaurupŋinan mönö dagö ösumnöŋ mi közöl eŋgibeak? Miaŋgöra yeŋön mönö keuŋini ölŋi me qahö, mi kewöta jim teköme. ");
INSERT INTO bmu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mi jim tekömemö, Anutugö ösumŋan nöŋgö börö kesötni sölölöhöi öme eŋguataŋgömakzal ewö, Anutugö bem-tohoŋan mönö eŋgöreŋ kam kuŋguza. ");
INSERT INTO bmu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kunŋan azi köhöikŋaŋgö köna böröŋi mutuk qahö jöhöma ewö, yaŋön mönö denöwö miriŋe öŋgöba qezaŋda sukinapŋi membawak? Mutuk i jöhöi tarigun mönö ölöp miriŋeyök öröyuaiŋi pakpak waŋgita memba anma. (Miaŋgö dop nöŋön mewöyök Satan jöhöba andöŋe ömeŋi eŋguataŋgömakzal.) ");
INSERT INTO bmu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kunŋan nömbuk qahö maljawi, yaŋön mönö qetal niŋgimakza. Kunŋan ambazip nöŋgö qetne tokomegöra qahö öröm eŋgimakzawi, yaŋön mönö mendeŋ eŋgimakza. ");
INSERT INTO bmu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Miaŋgöra nöŋön keu kun kewö jibi mötme: Ambazip siŋgisöndok aka mepaqepaik pakpak ahakzei, mi Anutunöŋ ölöp mosörakzapmö, kunŋan Uŋa Töröŋi ilita mepaikömawi, miaŋgö siŋgisöndokŋi Anutunöŋ mönö nalö kunöŋ qahö mosötma. Saumbaŋ! ");
INSERT INTO bmu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Kunŋan Suep gölmegö azi ölŋi qetala keu jima ewö, Anutunöŋ mi ölöp mosötmapmö, kunŋan Uŋa Töröŋi qetala keu yuai jimawi, yaŋgö siŋgisöndokŋi mi Anutunöŋ gölmenöŋ malmawaŋgö dop me kömup andöŋe miaŋgöreŋ qahö mosötma.” ");
INSERT INTO bmu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ipkö könaŋi mi ölŋi eka kewöta mötzin. Miaŋgöra mönö ip galöm kölgetka ölöwaka ölŋi ölöpŋi kuŋgumakŋa me ip mem böligetka ölŋi bölöŋi kuŋgumakŋa. ");
INSERT INTO bmu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Azi uruŋan yuai kokolak qei ahözawi, mia mönö numbuŋan aukŋe jimakza. Miaŋgöra qatögö moröŋi iŋini, nanŋinak bölöŋi aka mönö denöwö keu ölöpŋi jibeak? ");
INSERT INTO bmu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Azi ölöpŋaŋgö uru köweŋe ölöpŋaŋgö möriamŋi ahözawi, yaŋön mönö ölöpŋi mi aukŋeyök jimakza. Azi bölöŋaŋgö uru köweŋe bölöŋaŋgö möriamŋi ahözawi, yaŋön mönö bölöŋi mi aukŋe jimakza. ");
INSERT INTO bmu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mewö jimakzapmö, nöŋön keu ölŋi kun kewö jibi mötme: Ambazipnöŋ soŋgo walöŋda keu jit omaŋi omaŋi jimei, yeŋön mönö keu pakpak miaŋgö könaŋi mi jimtekötekögö nalö ketaŋe Anutugöra jim asarigetka kewötma. ");
INSERT INTO bmu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Miaŋgö könaŋi kewö: Anutunöŋ mönö keu jitki kewöta miaŋgö dopkeugi jim teköi solaniman me keugabuk aka lömböt miwikŋaiman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nalö miaŋgöreŋ Farisi (Köna keugö kapaŋkölköl) aka Köna keugö böhi tosatŋan Jisösgöra kewö jiget, “Böhi, gi ölöp aŋgöletot kun menöŋga mi ekingö mötzin.” ");
INSERT INTO bmu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mewö jigetka kewö meleŋ eŋgiyök, “Ambazip merak gölmenöŋ maljei, mi kambu bölöŋi aka serowilin ahakze. Yeŋön Anutugö aiwesökŋaŋgöra kapaŋ kölakzemö, aiwesök kun kezapqetok azi Jonagöra lök asuhuyök. Anutunöŋ aiwesök murutŋi kun qahö al eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonanöŋ suŋgem silimŋi karöbut köwet sömbupkö (gajugaju) gölömŋe malöhi, miaŋgö dop Suep gölmegö azi ölŋan mewöyök suŋgem asak karöbutkö dop gölme uruŋe ahöma. ");
INSERT INTO bmu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Jonanöŋ Niniwe ambazip sutŋine anda Anutugö keunöŋ uruŋini kuŋgui möta miaŋgöreŋök uruŋini meleŋgetmö, mötket, nöŋön sutŋine asuhuba kinda Jonagö ahakmemeŋi oŋgita ahakzal. Mewö ahakzalmö, iŋini töndup nesampurek ak niŋgimakze. Miaŋgöra Niniwe ambazipnöŋ jimtekötekögö nalö ketaŋe ambazip kambu ki kinjei, embuk öröröŋ kömupnöhök wahöta eŋgö qöhöröŋine mohotŋe kinme. Mohotŋe kinda Niniwe yeŋön keu kewö eŋgö sileŋine alme, ‘Iŋini Suep gölmegö azi ölŋi nesampurek ak waŋgigetka Anutunöŋ likepŋi meleŋ eŋgii sihimbölö öŋgöŋgöŋi mötme.’ Niniwe yeŋön mewö jigetka ahakmemeŋinan nanŋini könaŋamŋini indelgetka gamuŋini mötme. ");
INSERT INTO bmu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Könaŋamŋinaŋgö kaisöpsöpŋi kun kewö: Anutunöŋ mönöwök mötkutukutu öŋgöŋgöŋi ketaŋi mi kiŋ Solomon waŋgiiga Saut görökenök kantri kungö qin ambinöŋ Solomongö mötkutukutuŋi mötmamgö sihimŋi mörök. Sihimŋi möta gölme göraŋeyök wahöta köna köröp tiŋtiŋi kaba mala Solomongö mötmötŋi mörök. “Mi mörökmö, mötket, nalö kewöŋe nöŋön sutŋine asuhuba kinda Anutugöreŋ mötkutukutu öŋgöŋgöŋi memba kazali, mi Solomongö mötkutukutuŋi oŋgitza. Oŋgitzapmö, iŋini töndup nesampurek ak niŋgiba tönpin kingetka qahö dop kölja. Miaŋgöra Anutunöŋ könaŋgep ambazip körek pakpak öröm eŋgii keuŋini jim tekömapköra jeŋe aŋgotmei, nalö miaŋgöreŋ Saut kantrigö qin ambi miaŋön mönö mewöyök aŋgotma. Yaŋön ambazip kambu ki kinjei, embuk öröröŋ kömupnöhök wahöta eŋgö qöhöröŋine mohotŋe kinma. Mohotŋe kinda keu kewö eŋgö sileŋine alme, ‘Iŋini Jisös nesampurek ak waŋgigetka Anutunöŋ likepŋi meleŋ eŋgii sihimbölö öŋgöŋgöŋi mötme.’ Yaŋön mewö jiiga silikŋi kewöta nanŋinaŋgöra gamuŋini mötme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ömenöŋ azi uruŋeyök kota gölme qararaŋkölkölŋe anda laŋ liliköba mala luhut memamgö miri jaruba kun qahö miwikŋaima. ");
INSERT INTO bmu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mi qahö miwikŋaiba osiba kewö jima, ‘Mirini mosöta kazali, miaŋgöreŋ mönö kunbuk liliŋgömam.’ Mewö jiba liliŋgöba miriŋi usuŋda meŋölöi ahöyöhi, mi gwamönŋi ahöi miwikŋaima. ");
INSERT INTO bmu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","“Mewö miwikŋaiba anda öme tosatŋi 7 eŋguaŋgitma. Öme 7 mi nanŋi oŋgita bölöŋi kötökŋi akze. Yaŋön mi eŋguaŋgiriga kaba miri mi öŋgöba miaŋgö uruŋe malme. Mewö aiga azi miaŋgö könaŋi mutuk kileŋkileŋ ahökmö, könaŋgep böliqölim teköma. Ambazip kambu bölöŋi ki merak gölmenöŋ maljei, eŋgöreŋ mewöyök mewö asuhuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisösnöŋ toroqeba ambazip kambu yeŋgöra keu jiba maliga nam-munŋan kaba yaigep kinda yambuk keu jibingö mötket. ");
INSERT INTO bmu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mötketka kunŋan kewö jii mörök, “Mötnöŋ, göhö nam-mungan mönö yaigep kinda göbuk keu jibingö mötze.” ");
INSERT INTO bmu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Keu mi jii mörökmö, yaŋgöra meleŋda kewö jiyök, “Nöŋgö namni daŋön? Nöŋgö munurupni mi daŋön?” ");
INSERT INTO bmu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mewö jiba böröŋi gwarekurupŋi yeŋgöreŋ göröken böraŋda jiyök, “Eket, nöŋgö namni aka munurupni ölŋi mönö ki.” ");
INSERT INTO bmu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Denike yeŋön nöŋgö Suep Iwinaŋgö jitsihitŋi tem kölakzei, körek mieŋön mönö nöŋgö namni aka nenmunurupni akze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nalö miaŋgöreŋök Jisösnöŋ miri mi mosöta o aŋgö jitŋe geba tarök. ");
INSERT INTO bmu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tariga ambazip kambulelembenöŋ yaŋgöreŋ anda tokogetka waŋgenöŋ öŋgöba tarök. Tariga ambazip kambu pakpak yeŋön aŋgö göraŋe saknöŋ tokoget. ");
INSERT INTO bmu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mewö tokogetka dopkeu gwötpuk jii mötketka kewö jiyök, “Mötket! Azi kunŋan nene kötŋi qesiŋ gilmamgöra nupnöŋ anök. ");
INSERT INTO bmu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Anda qesiŋ giliga kötŋi tosatŋan köna jitŋe geba kölget. Geba kölgetka (warawen) neiŋi neiŋi kaŋgota mi nem teköget. ");
INSERT INTO bmu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","“Kötŋi tosatŋan köt jamönjiŋnöŋ geba kölget. Geba köla miaŋgöreŋ gölme gwötpuk qahö miwikŋaiget. Gölme dutŋi qahö ahöyöhaŋgöra korapŋi zilaŋ kotket. ");
INSERT INTO bmu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kotketmö, wehönöŋ kota eŋguba jem kutum eŋgiiga jalöŋini qahöpköra soholiba gororoŋgöget. ");
INSERT INTO bmu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Kötŋi tosatŋan siriuret wahiŋinambuknöŋ geba kölget. Geba kölgetka mieŋön kota qem turuba böbölohot mem eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mewö pömsöm qeyökmö, kötŋi tosatŋan gölme ölöpŋe geba kölget. Geba köla tosatŋi mieŋgö kötŋini 100 asuhuget. Tosatŋan kötŋini 60, tosatŋan 30 miaŋgö dop ahum sehiget. ");
INSERT INTO bmu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kunŋan urukezapŋambuk malja ewö, yaŋön mönö dopkeu ki kezap ala möt kutuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mewö jiiga gwarekurupŋan kaba Jisös kewö qesim waŋgiget, “Gi mönö wuanöŋgöra ambazip yeŋgö ‘Keu jimam,’ jiba dopkeunöŋ ala jimakzan?” ");
INSERT INTO bmu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Qesim waŋgigetka kewö meleŋda jiyök, “Mi kewögöra: Suepkö bemtohoŋe aŋgota malbingö keu tölapŋi mi eŋgöra aukŋe jibi möt kutuzemö, yeŋgöra mi mewö qahö. ");
INSERT INTO bmu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Miaŋgö könaŋi kewö: Kunŋan mötkutukutuŋambuk maljawi, Anutunöŋ mönö mi toroqem waŋgiiga köl guliba möriamŋambuk malmapmö, kunŋan mötkutukutuŋi qahö maljawi, Anutunöŋ mönö mötmötŋi moröŋi ahözawi, mi mewöyök qeköba waŋgitma. ");
INSERT INTO bmu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Ambazip yeŋgö keu jimam jiba kewögöra dopkeunöŋ ala jimakzal: Yeŋön nanŋini jeŋinan yuai ekagun könaŋi töndup qahö ek kutume. Nanŋini kezapŋinan keu törörök mötagun könaŋi töndup qahö möt asarime. ");
INSERT INTO bmu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kezapqetok azi Aisaianöŋ qeljiŋe keu kun jiba ohoyöhi, miaŋön ambazip mewöŋi yeŋgöreŋ ölŋambuk ahakza. Keu mi kewö, ‘Keu möt bibihibagun könaŋi töndup kude möt asarime. Yuai ek bibihibagun könaŋi töndup kude ek kutume. ");
INSERT INTO bmu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ambazip kambu kieŋgö uruŋinan mönö köhöikŋi gwözöŋda ahöza. Kezapŋinan keu möt bibihiba jeŋini kömaziliköba (kömazilihiwa) malje. Mewö qahö akeak ewö, mönö jeŋinan yuai ek kutuba kezapŋinan keu möta uruŋinan könaŋi möt asariba uruŋini meleŋgetka nöŋön i ölöp mem ölöwak eŋgibileŋak.’ ");
INSERT INTO bmu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Keu mewö ahözapmö, eŋgö jeŋinan yuai ek kutuzawaŋgöra mönö simbawoŋ akze. Kezapŋinan keu möt kutuzawaŋgöra mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nöŋön keu öl töhönŋi kun kewö jibi mötket: Kezapqetok ambazip aka Anutugöreŋ ambazip solanŋi gwötpukŋan iŋini yuai ki ekzei, mi ekingö awöweŋgöba malgetmö, qahö eket. Iŋini keu ki mötzei, yeŋön mi mötpingö awöweŋgöba malgetmö, qahö mötket.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Qesiŋ gilgil azigö dopkeu jizali, miaŋgö könaŋi mi kezap ala mötme. ");
INSERT INTO bmu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nene kötŋi qesiŋ giliga köna jitŋe geba kölöhi, mi kewö: Kunŋan bemtohoŋgö Buŋa keuŋi möta könaŋi qahö möt asariiga Bölöŋaŋgö Toŋan kaba uruŋe kötŋi kömötkeri, mi qeköma. ");
INSERT INTO bmu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nene kötŋi qesiŋniga köt jamönjiŋnöŋ geba kölöhi, mi ambazip söpsöpŋi kun. Yeŋön Buŋa keu möta mi miaŋgöreŋök sösöŋgai qakŋe möt aŋgön kölakze. ");
INSERT INTO bmu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","“Mewö ahakzemö, uruŋine jalöŋi qahö ahöm eŋgimapmö, nalö töröptökŋi miyök kin köhöiba malme. Buŋa keugöra aka kahasililiŋ me sesewerowero asuhuiga nalö miaŋgöreŋök mönö tala eŋguma. ");
INSERT INTO bmu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nene kötŋi qesiŋniga siriuret wahiŋinambuknöŋ geba kölgeri, mi kewö: Yeŋön Buŋa keu mötketka uruŋine gezapmö, gölmenöŋ malmalgö waimanjatŋi aka moneŋ inap memegö urukönöpŋi ahuba lömbörim eŋgimakza. Qetbuŋaŋinambuk akingöra köpösöŋgögetka sihim kömbönaŋi bölöŋi tosatŋan mewöyök uruŋine dumgöba Buŋa keu böbölohot mem waŋgize. Mewö aiga ölŋini qahö gilipitŋi (ambetakŋi) akŋe. ");
INSERT INTO bmu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Nene kötŋi gölme ölöpŋe qesiŋniga geba kölgeri, mi ambazip kewöŋi: Yeŋön Buŋa keu kezap ala möta möt asariba pöndaŋ kinda ölŋini miwikŋaimakze. Tosatŋan keu jit mohotnöhök kötŋi 30 miwikŋaimakze. Tosatŋan ölŋini 60, tosatŋan keu köt mohot mohot mieŋgö ölŋini 100 mem sehiba miwikŋaimakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisösnöŋ söpsöp keu kun kewö jii mötket, “Suepkö bemtohoŋaŋgö könaŋi mi azi kewöŋaŋgö dop ala jimam. Yaŋön nupŋe anda nene kötŋi ölöpŋi qesiŋ gilök. ");
INSERT INTO bmu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Qesiŋ gilökmö, suŋgem ahögetka miaŋgöreŋ kerök aziŋan kaba wit padi sutŋine miaŋgöreŋ dorowetkö kötŋi qesiŋ gila mosöta anök. ");
INSERT INTO bmu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit padi kötŋan jula wahöta öŋgöba ölŋi asuhuyöhi, nalö miaŋgöreŋ dorowetnöŋ mewöyök aukŋe asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Miaŋön aukŋe asuhuiga welenqeqeurupŋan mi eka nup toŋaŋgöreŋ kaba kewö jigetka mörök, ‘Ketaŋamnini, nupke nene köt ölöpŋi qesiŋ gilnöŋ me qahö? Dorowetkö kötŋi mi mönö denikeyök miaŋgöreŋ geba asuhuza?’ ");
INSERT INTO bmu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Mewö jigetka möta kewö jii mötket, ‘Kerök azinöŋ mi qesiŋ gilök.’ Mewö jii möta welenqeqe yeŋön kewö jiget, ‘Nini ölöp anda dorowet mi qözöla tokobingö mötzan me qahö?’ ");
INSERT INTO bmu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mewö jigetmö, kewö jii mötket, ‘Qahö! Iŋini dorowet qözöla tokoba miaŋgöreŋ padi tosatŋi mi mewöyök qözölbepuk. ");
INSERT INTO bmu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Mönö mosötketka mohotŋe qariba wahörohotkun ölŋi meme nalöŋan kam kuŋguiga nalö miaŋgöreŋ nöŋön padi misimisi ambazip yeŋgöra kewö jibi mötme: Mönö mutuk dorowet memba tokoba ohomegöra börangöba kösönöŋ jöhöme. Mi jöhöbagun mönö wit padi ölŋi mi tokoba memba kaba nöŋgö köwe mire alme.’” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisösnöŋ dopkeu kun kewö toroqeba jii mötket, “Suepkö bemtohoŋi mi kewö: Azi kunŋan nejoŋ (nemuya) kötŋi memba nanŋe nup gölmeŋe anda alök. ");
INSERT INTO bmu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kötŋi mi morö közözömŋi. Mi nene köt pakpak mieŋgö eretŋini akzapmö, jula wahöta yöha pakpak eŋgoŋgita qariba ip akŋa. Mewö aka kiniga könakemba neiŋi neiŋi kaŋgota aipŋini ip miaŋgö böröŋe alakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisösnöŋ dumŋe kunbuk söpsöpkeu kun kewö jii mötket: “Suepkö bemtohoŋi mi yist me flaua mem qariqarigö dop kewö akza: Ambi kunöŋ ‘Beret ohomam,’ jiba yist memba flaua amae (dis) karöbut miaŋgöreŋ mindiriba meleŋqeleŋ aka anda anda tari körekŋanök qariyök.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisösnöŋ keu pakpak mi könagesö yeŋgöra söpsöp keunöŋ jiyök. Söpsöpkeu qahö mewö keu kun qahö jii mötket. ");
INSERT INTO bmu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mewö aiga Anutunöŋ kezapqetok azi kun sölölöhöiga keu kun jiyöhi, miaŋön ölŋambuk ahök. Yaŋön keu mi kewö jii ahöza, “Nöŋgö numbunan mönö amqeiga söpsöp keuŋi keuŋi jimam. Anutunöŋ gölme miwikŋaiiga asuhuyöhi, nalö miaŋgöreŋök keu tölapŋe ahöi mala korini, nöŋön mönö keu mi aukŋe jim indelmam.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisösnöŋ söpsöp keu mi jim teköba ambazip kambu ketaŋi eŋgömosöta miri uruŋe öŋgöyök. Öŋgöiga gwarekurupŋan yaŋgöreŋ kaba kewö qesiba jiget, “Dorowet nene nupnöŋ asuhuyöhi, gi mönö söpsöp keu miaŋgö könaŋi jim asarim neŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mewö jigetka kewö meleŋda jiyök, “Suep gölmegö azi ölŋan mönö nene kötŋi ölöpŋi ölöpŋi qesiŋ gilakza. ");
INSERT INTO bmu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nene nup mi gölmegö kantri pakpak. Nene kötŋi ölöpŋi mi bemtohoŋgö nahönbörat eŋgöra jizal aka dorowet mi azi bölöŋaŋgö nahönbörat yeŋgöra jizal. ");
INSERT INTO bmu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Keröknöŋ mi qesiŋ gilöhi, mi Bölöŋaŋgö Toŋaŋgöra jizal. Padi misimisi nalöŋi mi gölmegö nalöŋan tekömawaŋgö nalö ketaŋi mi. Padi misimisi ambazip mi Suep garata yeŋgöra jizal. ");
INSERT INTO bmu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Dorowet tokoba könöpnöŋ ohoget jemawi, miaŋgö dop mönö gölmegö nalöŋan tekömawaŋgö nalö ketaŋe asuhuma. ");
INSERT INTO bmu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Suep gölmegö azi ölŋan mönö garataurupŋi melaim eŋgiiga kaba keu areŋ bölöŋi pakpak Kraistkö bemtohoŋ uruŋe siŋgisöndok akingö kondorakzawi, mi qeapköba mindiŋgöme aka bölöŋi meme ambazip pakpak mi qözöla qezaköm eŋgime. ");
INSERT INTO bmu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","“Mewö mindiŋqindiŋ aka ambazip mi gil eŋgigetka owen imarurubuk jeba ahözawi, miaŋgöreŋ geme. Miaŋgöreŋ gemeaŋön mönö sahöt gigilahöba irimŋini yöhözömgögetka qetŋi qeri malme. ");
INSERT INTO bmu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nalö miaŋgöreŋ ambazip solanŋi mieŋön mönö wehön tandök aka Iwiŋinaŋgö bemtohoŋ uruŋe asariba mal öŋgöme. Kunŋan urukezapŋambuk maljawi, yaŋön mönö keu mi kezap ala möt kutuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Suepkö bemtohoŋi mi guli damandaŋ söŋgöröŋi öŋgöŋgöŋi miaŋgö dop kewö akza: Mi nupnöŋ mesambötket ahöiga azi kunŋan mi miwikŋaiba aŋgön köla kunbuk gölmenöŋ mesambörök. Mesamböta miaŋgöra söŋgaiba anda sukinapŋi pakpak bohonŋi memegöra ali moneŋ kaiga miaŋön nup gölme mi bohonŋi meyök.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Suepkö bemtohoŋi mi stua azigö dop ala söpsöp keu kun kewö jimam: Yaŋön sorom kötŋi ekjeritŋambuk jaruba malök. ");
INSERT INTO bmu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jaruba mala sorom kötŋi mohot söŋgöröŋi ketaŋi miwikŋaiba anda sukinapŋi pakpak bohonŋi memegöra ali moneŋ kaiga miaŋön sorom kötŋi mi bohonŋi meyök.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Suepkö bemtohoŋi mi mösakö dop ala söpsöpkeu kun kewö jimam: Mi o aŋgönöŋ gilget geiga söra tandökŋini könaŋi könaŋi gegetka eŋgömem tokoyök. ");
INSERT INTO bmu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tokoi kokolak qeiga ambazipnöŋ mi örögetka körökŋe koriga eta tata söra ölöpŋi kewöta sakapnöŋ tokogetmö, bölöŋi mi gilgetka anök. ");
INSERT INTO bmu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Keu miaŋgö dop mönö gölmegö nalöŋan tekömawaŋgö nalö ketaŋe asuhuma. Suep garata yeŋön kaba ambazip bölöŋi mi solanŋi mieŋgöreŋök kewöt eŋgime. ");
INSERT INTO bmu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kewöt eŋgiba ambazip bölöŋi mi gil eŋgigetka owen imarurubuk jeba ahözawi, miaŋgöreŋ geme. Miaŋgöreŋ gemeaŋön mönö sahöt gigilahöba irimŋini yöhözömgögetka qetŋi qeri malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisösnöŋ söpsöp keu mi jim teköba kewö qesim eŋgiyök, “Keu pakpak jizali, mi möt asarize me qahö?” Qesim eŋgiiga meleŋda “Oŋ!” jiget. ");
INSERT INTO bmu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Oŋ!” jigetka kewö jii mötket, “Miri toŋan miriŋaŋgö köweŋeyök inap yuai walŋi aka dölökŋi uzeta alakza. Miaŋgö dop Köna keugö böhi pakpak Suep bemtohoŋgö gwarekurupŋi akeri, yeŋön mönö mewöyök uruŋinaŋgö köweŋineyök keu aködamunŋinambuk dölökŋi aka keu ölöp sorokŋi walŋi uzeta jimakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisösnöŋ dopkeu mi jim teköba miri gölme mi mosöta anök. ");
INSERT INTO bmu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Anda malqarip taonŋe aŋgota köuluk miriŋine öŋgöba Buŋa keu kusum eŋgiyök. Kusum eŋgiiga auruba welipköba kewö jiget, “Yei! Kezapjupjup! Yaŋön mötkutukutu ki aka aŋgöletot kukösumŋinambuk mi mönö denikeyök meza? ");
INSERT INTO bmu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Azi ki mönö miri kiaŋgö mitimqeqe azigö nahönŋa. Namŋaŋgö qetŋi Maria aka munurupŋi Jeims, Josef, Saimon aka Juda. Mi ölöp mötzin. ");
INSERT INTO bmu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nenurupŋan mönö körek sutnine ki malje. Miaŋgöra yuai pakpak ki mönö denikeyök memba kaba akza?” ");
INSERT INTO bmu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nazaret yeŋön mewö jigetka uruŋinan böliiga miaŋgöreŋ qaköget. Qakögetmö, Jisösnöŋ kewö jii mötket, “Kezapqetok azi mi nanŋi taonöŋ aka nanŋi mire jijiwilit ak waŋgimakzemö, miri tosatŋe mewö qahö.” ");
INSERT INTO bmu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mewö jiiga mötnaripŋinan qahö asuhuiga yaŋgiseŋinaŋgöra aka aŋgöletot kukösumŋinambuk mi miaŋgöreŋ gwötpuk qahö meyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nalö miaŋgöreŋ gölme bahöŋaŋgö (Galili prowinsgö) kiŋ Herod yaŋön Jisösgö qetbuŋaŋi mörök. ");
INSERT INTO bmu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mi möta welen-qeqeurupŋi yeŋgöra kewö jiyök, “Mi mönö Jon O-melun azia. Yaŋön mönö kömupnöhök wahöta nupŋi meiga aŋgöletot kukösumŋinambuk asuhumakze.” Waimanjat möta mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mi kewögöra jiyök: Herodnöŋ munŋi Filipkö anömŋi Herodias ölöŋ meiga Jon O-melun azinöŋ kiŋ jim waŋgiiga opotöröp melaim eŋgiiga anda Jon memba jöhöba kösö mire al waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jonöŋ Herodköra keu kewö jiyök, “Gi qambötki memba mala Köna keu oŋgitzan.” ");
INSERT INTO bmu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mewö jiiga Herodnöŋ Jon qeget kömumapkö mörökmö, könagesö yeŋön Jongöra mötketka kezapqetok azia malöhi, miaŋgöra könagesö yeŋgöra keŋgötŋi mörök. ");
INSERT INTO bmu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Keŋgötŋi mörökmö, Herodkö ahuahu nalöŋan kaiga ketaurupŋan tokoba tatketka Herodiasgö böratŋan yeŋgö jeŋine danis aliga Herodnöŋ miaŋgö eksihimŋi gwötpuk mörök. ");
INSERT INTO bmu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Miaŋgöra ambi seram miaŋön wani yuaigöra qesibawak, kiŋnöŋ mi tököm waŋgimamgö keu jöhöba keu mi jöjöpaŋ keunöŋ jim köhöiyök. ");
INSERT INTO bmu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mewö jim köhöiiga namŋan ambi seram mi kuŋgum waŋgiiga kewö jiyök, “Mönö qesinöŋga Jon O-melun azigö jölŋi yandigetka nöröpŋi memba ki kaba köndenöŋ niŋgima.” ");
INSERT INTO bmu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mewö jiiga kiŋgö uruŋan kömbuhiiga wösöbirik mörökmö, jöjöpaŋ keuŋan jöhöi ketaurupŋan mi mötketka yeŋgö jemesoholŋine etpapuköra möta nöröpŋi waŋgimegöra jim kutuyök. ");
INSERT INTO bmu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mewö jim kutuba opotöröpŋi kun melaiba jiyök, “Gi mönö kösö mire anda Jongö jölŋi yandiba nöröpŋi memba kaman.” ");
INSERT INTO bmu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mewö jiiga Jongö nöröpŋi köndenöŋ ala memba kaba ambi seram mi waŋgiiga memba anda namŋi waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jongö gwarekurupŋan miaŋgö buzupŋi möta anda qamötŋi memba qaksirigö köt köteŋnöŋ ala löm kölget. Löm köla anda keu mi Jisös jiget mörök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisösnöŋ Jongö kösohotŋi möta miri mi mosöta waŋgenöŋ öŋgöba gölme kötikŋi kunöŋ nanŋinök malbingöra anget. Ambazip kambu yeŋön miaŋgö buzupŋi möta taon aka miriŋini mosöta Jisösgö andöŋe wuataŋgöba gölme köna anget. ");
INSERT INTO bmu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Angetka Jisösnöŋ waŋgenöhök eta ambazip kambulelembe eŋgeka yeŋgöra wösöŋi mörök. Wösöŋi möta sutŋine kawöl eŋgöhöi malgeri, mi mem ölöwak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mewö aka mali mare aiga gwarekurupŋan Jisösgöreŋ kaba kewö jiget, “Böhi, nini gölme kötikŋi kiaŋgöreŋ malinga wehön jeŋan teköba gemamgö akza. Miaŋgöra gi ölöp ambazip kambu ki melaim eŋginöŋga miriŋi miriŋi mieŋgöreŋ anda numbu neneŋini söŋgöröŋi memba neme.” ");
INSERT INTO bmu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mewö jigetmö, Jisösnöŋ kewö jii mötket, “Yeŋön ölöp kiaŋgöreŋ tatme. Eŋön mönö nanŋinak i nene gumohom eŋgime.” ");
INSERT INTO bmu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mewö jii möta jiget, “Nini beret 5 aka söra yahöt miyök memba maljin.” ");
INSERT INTO bmu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mewö jigetka jiyök, “Mönö mi memba kaba niŋgime.” ");
INSERT INTO bmu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mewö jiba ambazip kambu mi kegwaŋ luplupnöŋ eta tatmegöra jim kutum eŋgiiga tatket. Tatketka beret 5 aka söra yahöt mi memba Suenöŋ ui öŋgöiga kötuetköba beret mindipköba gwarekurupŋi eŋgiiga ambazip kirip dop mendeŋda eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mendeŋda eŋgigetka ambazip körekmakörek nemba nem timbireŋ aket. Nem timbireŋ aka nene kitipŋi kitipŋi mosötkeri, mi gwarek yeŋön qezakögetka sakap 12 miaŋgöreŋ geba kokolak qeyök. ");
INSERT INTO bmu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Azi beret negeri, yeŋgö jaŋgöŋini mi 5000. Ambi nahönbörat yeŋgö jaŋgöŋini mi qahö meget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Neget teköiga Jisösnöŋ miaŋgöreŋök gwarekurupŋi jim kutum eŋgiba kewö jiyök, “Iŋini mönö waŋgenöŋ öŋgöba qeljiŋe o aŋgö kutuba likepŋe anme. Nöŋön ölöp nalö sutŋe ambazip kambu ki melaim eŋgibagun kamam.” ");
INSERT INTO bmu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ambazip melaiba eŋgubula kunduŋe öŋgöba nanŋök mala köuluköyök. Köuluköba mali mare aiga kunduŋe nanŋik kötikŋi tarök. ");
INSERT INTO bmu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tariga waŋgeŋinan lök o aŋgö bibiŋe köröwen aniga luhutnöŋ angeraŋgöreŋök gila kaiga sirinöŋ waŋgenöŋ giliga kekwilik anda kayök. ");
INSERT INTO bmu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mewö ahiga miri awöraŋgöiga (3-6 kilok) miaŋgöreŋ Jisösnöŋ o aŋgö qakŋe tiba tiba gwarekurupŋi yeŋgöreŋ kayök. ");
INSERT INTO bmu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kaba o aŋgö qakŋe tiba tiba kaiga gwarekurupŋan mi eka keŋgötporiŋ aka “Köwet Soŋgoriŋnöŋ kaza,” jiba sömbuŋini möta qeta silatket. ");
INSERT INTO bmu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Qeta silatketmö, Jisösnöŋ miaŋgöreŋök keukeu jiba kewö jii mötket, “Alaurupni, mönö ewebibiŋinambuk saitiŋgit malme. Nanak kazal. Keŋgötŋini kude mötme.” ");
INSERT INTO bmu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mewö jii möta Pitönöŋ meleŋda kewö jii mörök, “Göŋön Kembuya akzan ewö, mönö ölöp jinöŋga nöŋön o qakŋe tiba tiba göhöreŋ kamam.” ");
INSERT INTO bmu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisösnöŋ mi möta “Ölöp kanöŋ,” jiyök. Mewö jiiga Pitönöŋ waŋge mosöta o aŋgö qakŋe tiba tiba könahiba Jisösgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Könahiba anökmö, luhutnöŋ gwötpuk gili mi eka keŋgötporiŋ aka könahiba o uruŋe geba kewö qerök, “Kembu, bauköm niŋginöŋ.” ");
INSERT INTO bmu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Qeriga Jisösnöŋ miaŋgöreŋök böröŋi böraŋda Pitögö böröŋe memba kewö jiyök, “Mötnaripki morörökŋi. Mönö wuanöŋgöra uruyahöt akzan?” ");
INSERT INTO bmu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mewö jiba bauköm waŋgii waŋgenöŋ öŋgöyohotka luhutnöŋ nöŋ qeba göröŋ alök. ");
INSERT INTO bmu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Göröŋ aliga azi waŋgenöŋ tatkeri, yeŋön waikŋi memba möpöseim waŋgiba kewö jiget, “Alakŋa, gi Anutugö nahönŋa.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","O aŋgö kutuba likepŋe Genesaret mire aŋgota waŋge mosöta saknöŋ geget. ");
INSERT INTO bmu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Saknöŋ gegetka miri miaŋgö ambazipnöŋ Jisös möt kutum waŋgiget. Möt kutum waŋgiba keu algetka miri pakpak kösutŋe tatkeri, miaŋgöreŋ aniga buzupŋi möta kawöl ambazip körek eŋguaŋgita Jisösgöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kagetka kinda Jisös malukuŋaŋgö suŋe misiribingö ulet waŋgiba malget. Misirigeri, körek yeŋön mönö ölöwak teköget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Miaŋgö andöŋe Farisi (Köna keugö kapaŋkölköl) aka Köna keugö böhi tosatŋan Jerusalem sitiyök Jisösgöreŋ kaba kewö qesim waŋgiget, ");
INSERT INTO bmu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Göhö gwarekurupkan wuanöŋgöra köna walöŋda ambösakoninaŋgö silikŋini qeze? Yeŋön mönö böröŋini saŋgoŋda dom-amöt qahö qeba töndup könahiba nene neze?” ");
INSERT INTO bmu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mewö qesim waŋgigetka kewö jii mötket, “Nanŋinak mönö wuanöŋgöra ambösakoninaŋgö silikŋini wuataŋgöbingöra köna walöŋda Anutugöreŋ jöjöpaŋ keu qeze? ");
INSERT INTO bmu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Miaŋgö keuŋi kun kewö: Anutunöŋ kewö jim kutuyök, ‘Iwinamgi mönö göda qem etkimakŋan,’ aiga ‘Kunŋan iwiŋi me namŋi qesuahömawi, i mönö qegetka kömuma.’ ");
INSERT INTO bmu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Mewö jim kutuyökmö, iŋini keu mi oŋgita kewö jimakze, ‘Kunŋan iwiŋaŋgöra me namŋaŋgöra kewö jima: Wösöni mötzal. Nöŋgö naŋgönaŋgö yuaini buŋa qem aŋgubanak, mi lök Anutugö saiwap naluköra kewöta albi ahöza. Kunŋan mewö jiba iwiŋi me namŋi göda qem waŋgimawaŋgö dop qahö akza.’ ");
INSERT INTO bmu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Mewö jiba silikŋini walŋaŋgöra aka Anutugö jöjöpaŋ keuŋi utalgetka omaŋi aka pömsöm qemakza. Mi qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","O urumeleŋgö silesile ambazip, kezapqetok azi Aisaianöŋ mönö eŋgö könaŋamŋini törörök qeljiŋe indela kewö jii ahöza, ");
INSERT INTO bmu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ambazip kambu kiaŋön mönö numbu jitŋinan ölöpŋanök göda qem niŋgimakzemö, uruŋinan nönöŋgan ak niŋgiba kungen algetka köröwen ahöza. ");
INSERT INTO bmu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mewö ahöiga nöŋgö waikni öne töhön memba möpöseim niŋgimakze. Köna keu kusum eŋgibin, jiba salupŋe ambazip yeŋgö jimkutukutuŋini mi numbu o alakze.’” Mewö meleŋ eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisösnöŋ ambazip kambu kunbuk eŋgoholi kagetka kewö jii mötket, “Iŋini mönö keu ki kezap ala möt asarime. ");
INSERT INTO bmu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yuai azigö numbuŋeyök uruŋe gemakzawi, miaŋön qahö tölohom waŋgimakzapmö, nanŋi numbuŋeyök keu erakzawi, miaŋön mönö tölohom waŋgimakza.” ");
INSERT INTO bmu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mewö jii mötketka gwarekurupŋan kaba kewö qesiget, “Farisi (Köna keugö kapaŋkölköl) yeŋön keu mi mötket eŋgui uruŋinan bölizawi, mi mötzan me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Qesigetka kewö meleŋnök, “Nöŋön warök pakpak nöŋgö Suep Iwinan qahö kömöröhi, mi mönö jalöŋinambuk qözölmam. ");
INSERT INTO bmu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Muat, i mönö eŋgömosötme. Yeŋön ‘Jegömöl ambazip eŋguaŋgitpin,’ jimakzemö, nanŋini jeŋinan mönö gömöliza. Jegömöl kunŋan jegömöl alaŋi kun böröŋe memba waŋgitma ewö, yetkön mönö mohotŋe lömnöŋ geba etkuma.” ");
INSERT INTO bmu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mewö meleŋniga Pitönöŋ jiyök, “Dopkeu miaŋgö könaŋi mönö jim asarinöŋ mörin.” ");
INSERT INTO bmu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mewö jiiga Jisösnöŋ jiyök, “O alaurupni, iŋini mewöyök toroqeba mötmötŋini ölöpŋi qahö akze me? ");
INSERT INTO bmu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yuai pakpak azi numbuŋeyök uruŋe gemakzawi, mi kömgokŋe geba yaigep erakza. Mi möt kutuze me qahö? ");
INSERT INTO bmu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","“Mi erakzapmö, keu uru könömŋeyök kota numbuŋeyök erakzawi, miaŋön mönö tölohom waŋgimakza. ");
INSERT INTO bmu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ambazip uru könömŋineyök yuai kewöŋi asuhuba korakza: Keu bölöŋi mötmöriba suŋa jinaŋ memba ambazip eŋguget kömumegö mörakze. Qesabulum aka serowilin akingö mörakze. Yoŋgorö membingö mörakze. Jitnöŋ alal keu muneŋi jibingö mörakze. Andöqeqe keu yöhösaŋ jiba Anutu mepaiköbingö mörakze. ");
INSERT INTO bmu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yuai mewöŋan mönö ambazip tölohom eŋgimakzapmö, böröŋini qahö saŋgoŋda nene nemakzei, miaŋön azi kun qahö tölohomakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisösnöŋ Genesaret gölme mosöta siti qetŋiri Taiö aka Saidon mietkö distrik qetŋi Fonisia miaŋgö uruŋe anök. ");
INSERT INTO bmu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aniga Kenan ambi, gölme miaŋgö toŋi kunŋan kaba Jisös uleta kewö qeta jiyök, “Kembu, Deiwidkö gwölönarökŋi, mönö ak kömum niŋgiman! Ömenöŋ böratni kölköljiŋjiŋ ak waŋgiiga sihimbölö ketaŋi mörakza.” ");
INSERT INTO bmu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Qeta jiyökmö, Jisösnöŋ keu kun qahö meleŋnök. Mewö aiga gwarekurupŋan kaba kewö kuŋgum waŋgiba jiget, “Ambi mi sahöta qeta könanine kazawaŋgöra mönö bauköm waŋginöŋga anma.” ");
INSERT INTO bmu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mewö jigetka meleŋnök, “Iwinan Israel könagesögö lama sohosohoŋi miyöhök amöt qem eŋgimamgöra aka melaim niŋgiiga kazal.” ");
INSERT INTO bmu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mewö meleŋniga ambi miaŋön kösutŋe kaba simin köl waŋgiba jiyök, “Kembu, mönö bauköm niŋginöŋ!” ");
INSERT INTO bmu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mewö jiyökmö, Jisösnöŋ kewö meleŋ waŋgiyök, “Qahö, morö yeŋgö miriŋineyök beret memba kiam eŋgiinga qahö dop kölbapuk. Juda nini kianurup eŋgö qetŋini kiam qerakzin. Nöŋön mutuk Juda ambazip bauköm eŋgibiga kantri tosatŋi eŋön mönö kiamgö dop mamböta malme.” ");
INSERT INTO bmu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Meleŋ waŋgiyökmö, ambinöŋ jiyök, “Kembu, mi ölöp mötzalmö, kiam moröŋi yeŋön mönö mewöyök toŋinaŋgö tebolnöhök nene boromŋi eriga nemakze.” ");
INSERT INTO bmu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mewö jiiga Jisösnöŋ kewö jii mörök, “O ambi, göhö mötnaripki mi ketaŋi. Miaŋgöra ulet niŋgizanaŋgö ölŋi mönö asuhuma.” Mewö jii möta böratŋan aua miaŋgöreŋök ölöwahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisösnöŋ gölme mi mosöta kaba Galili o aŋgögö jitŋe kaŋgota kunduŋe öŋgöba eta tarök. ");
INSERT INTO bmu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tariga ambazip kambulelembenöŋ yaŋgöreŋ kaba ambazip kewöŋi eŋguaŋgitket: Simalokon aka jegömöl ambazip, tosatŋi köna böröŋini heramheramgöŋi, tosatŋi keuŋini mötökŋi aka kawöl tosatŋi gwötpuk eŋgöhöi malgeri, mi eŋguaŋgita Jisösgö köna kösutŋe al eŋgigetka mem ölöwak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mem ölöwak eŋgiiga ambazip keuŋini mötökŋi yeŋön keu jigetka köna böröŋini heramheramgöŋi yeŋön ölöwaka diŋgigetka simalokon yeŋön köna tiba anda kagetka jeŋini döndöŋgöŋi yeŋön je uba eketka ambazip kambu yeŋön mi eka welipköba Israel neŋgö Anutunini möpöseiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisösnöŋ gwarekurupŋi eŋgoholi yaŋgöreŋ kagetka kewö jii mötket, “Nöŋön ambazip kambu kieŋgöra wösöni mötzal. Yeŋön nöŋgöreŋ kaba wehön karöbut lök mala kotketka neneŋini qahöwahiga ekzal. Könanöŋ anda mala kembaŋe jeŋini gili tirinbirin akepuköra i öne melaim eŋgimamgö töközal. Miaŋgöra i nene gumohom eŋgimamgö mötzal.” ");
INSERT INTO bmu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mewö jii gwarekurupŋan meleŋda kewö jiget mörök, “Gölme qararaŋkölkölŋe kiaŋgöreŋ neŋön mönö denikeyöhök numbu nene gwötpuk miwikŋaiba ambazip kambulelembe ki gumohom eŋgibinak?” ");
INSERT INTO bmu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mi möta Jisösnöŋ kewö qesim eŋgiyök, “Eŋgöreŋ beret dawik ahöza?” Qesim eŋgiiga “Beret 7 aka söra moröŋi tosatŋi ahöza,” jiget. ");
INSERT INTO bmu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jigetka Jisösnöŋ ambazip kambu mi gölmenöŋ geba tatmegöra jim kutum eŋgiiga geba tatket. ");
INSERT INTO bmu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Geba tatketka beret 7 aka söra mi memba Anutugö saiwap jiba mindipköba gwarekurupŋi eŋgiiga yeŋön mi ambazip kambu dop toto qem eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Toto qem eŋgigetka nemba nem timbireŋ-göget. Nem timbireŋgöba nene kitipŋi mosötket geyöhi, mi sakap 7 miaŋgöreŋ qezakögetka numbuŋe qeyök. ");
INSERT INTO bmu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Azi nene negeri, yeŋgö jaŋgöŋini mi 4000. Ambi nahönbörat yeŋgö jaŋgöŋini mi qahö meget. ");
INSERT INTO bmu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisösnöŋ ambazip kambu melaim eŋgiiga angetka nanŋi waŋgenöŋ öŋgöba Magadan gölmenöŋ anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi (Köna keugö kapaŋkölköl) aka Sadyusi (Jike nupkö kapaŋkölköl) tosatŋan Jisösgöreŋ kaba keugö bötaknöŋ örömap-köra esapköm waŋgiba kewö qesiget, “Mönö jinöŋga Suepnöhök aŋgöletot kun asuhuiga ekin.” ");
INSERT INTO bmu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mewö jigetka kewö meleŋnök, “Wehön gemamgö ahiga miaŋgöreŋ kewö jimakze, ‘Suepnöŋ pisihizawaŋgöra uran wehön ölöpŋi akŋa.’ ");
INSERT INTO bmu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","“Mewöyök söŋanök kewö jimakze, ‘Suepnöŋ pisihiiga kousunöŋ töwizawaŋgöra mönö kie luhut gilma.’ Mewö mewö jiba suepkö tandökŋi eka kie wehöngö könaŋi ölöp kewörakzemö, nalö maljini, miaŋgö aiwesökŋi kewötpingö qahö mötze. Mi qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ambazip kambu bölöŋi gölmenöŋ mala qesabulum ahakzei, yeŋön Anutugö aiwesökŋi asuhumapköra kapaŋ kölakzemö, Anutunöŋ kezapqetok azi Jonagö aiwesökŋi lök eŋgiiga aiwesök tosatŋi qahö toroqeba kondel eŋgima.” Mewö jiba eŋgömosöta kungen anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisösnöŋ gwarekurupŋi yembuk o aŋgö kutuba likepŋe aŋgota semön membingö ölum eŋguyöhi, mi eket. ");
INSERT INTO bmu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mi eketka Jisösnöŋ kewö jii mötket, “Iŋini Farisi aka Sadyusi pati yahöt yeŋgö wösökömbukŋini aka gipŋi kakŋi mietköra mönö galömŋini meme. Mi ölöpŋanök qahö kewöta andö qegetka mietkön mönö yist ewö qariba mem bölim eŋgimahot.” ");
INSERT INTO bmu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jiiga keu pasetŋi mi qahö möt asariba sutŋine kewö eraum mötket, “Nini beret qahö memba kazin. Miaŋgöra jiza me denöwö?” ");
INSERT INTO bmu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mi eraum mötket kezapŋe geiga kewö jii mötket, “O iŋini mötnaripŋini morörökŋi, wuanöŋgöra ‘Beret qahö mezin,’ jiba nanŋini eraum mötze? ");
INSERT INTO bmu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nöŋgö könaŋamni mi wuanöŋgöra qahö möt kutuze? Nöŋön beret 5 mi 5000 yeŋgöra mindipköbiga miaŋgö kitipŋi qezakögetka könde dawiknöŋ geba numbuŋe qeyök? Mi ölum eŋguza me qahö? ");
INSERT INTO bmu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Mewöyök beret 7 mi 4000 yeŋgöra mindipköbiga miaŋgö kitipŋi qezakögetka sakap dawiknöŋ geba kokolak qeyök? Mi ölum eŋguza me qahö? ");
INSERT INTO bmu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ni beretköra keu qahö jizali, mi denöwö aka qahö möt kutuze? Nöŋön beretköra qahöpmö, Farisi aka Sadyusi pati yeŋgö wösökömbukŋini aka gipŋi kakŋi kewöta andö qemegöra jizal.” ");
INSERT INTO bmu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mewö jiiga miaŋgöreŋök keuŋaŋgö könaŋi kewö möt asariget, “Aha! Plaua mem qariqari yistkö galöm mem aŋgubingöra qahö jiyökmö, Farisi pati aka Sadyusi pati yeŋgöreŋ keu loloŋqaloŋi andö qebingöra jiyök.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisösnöŋ Sisaria Filipai taongö kösutŋe anda miaŋgöreŋ gwarekurupŋi kewö qesim eŋgiyök, “Ambazipnöŋ Suep gölmegö azi ölŋi nöŋgöra denöwö jimakze? Ni niŋia akzal?” ");
INSERT INTO bmu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jiiga meleŋda kewö jiget, “Tosatŋan ‘Gi Jon O-melun azia akzan,’ jimakzemö, tosatŋan ‘Gi Elaija akzan,’ jimakze aka tosatŋan toroqeba kewö jimakze, ‘Gi Jeremaia me kezapqetok azi walŋi yeŋgöreŋök kun akzan.’” ");
INSERT INTO bmu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mewö jigetka kewö qesim eŋgiyök, “Aka nanŋinak nöŋgöra denöwö jize? Ni niŋia akzal?” ");
INSERT INTO bmu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Qesim eŋgiiga Saimon Pitönöŋ meleŋda jii mörök, “Gi Amötqeqe Toŋi Kraist aka malmal Toŋi Anutugö Nahönŋi akzan.” ");
INSERT INTO bmu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mewö jiiga Jisösnöŋ meleŋda kewö jii mörök, “O Saimon Jonagö nahönŋi, gölme azi sep busuŋambuk kunŋan qahöpmö, nöŋgö Iwini Suep mire maljawi, yaŋön mönö keu mi göhöreŋ indelök. Miaŋgöra göŋön mönö simbawoŋ akzan. ");
INSERT INTO bmu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nöŋön kewö jibi mötman: Gi Pitö (nanine keunöŋ jamönjiŋ) aknöŋga nöŋön jamönjiŋ miaŋgö qakŋe urumeleŋ könagesönaŋgö tandöŋi albi naŋgöm eŋginöŋga uruŋini möhamgöba köhöiba kinme. Göŋön i galöm köl eŋginöŋga kömup Toŋan i senjom mirigö kiripo naŋguŋe öröm eŋgimamgö osima. Ömewöröme tosatŋi yeŋgö kukösumŋinan mewöyök i köndeŋda luhut al eŋgibingö osime. ");
INSERT INTO bmu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“Nöŋön Suep bemtohoŋaŋgö ki moröŋi yahöt gihimam. Gi gölmenöŋ siŋgisöndok jöhönöŋga miaŋön mönö Suep mire mewöyök jöhöjöhöŋi ahöma. Gi gölmenöŋ siŋgisöndok mosöta pösatnöŋga miaŋön mönö Suep mire mewöyök pösatpösatŋi ahöma.” ");
INSERT INTO bmu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mewö jiba Amötqeqe Toŋi Kraist ahöhi, mi aukŋe jiget kunŋan mötpepuköra gwarekurupŋi yeŋgöra soŋgo köhöikŋi al eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nalö miaŋgöreŋök Jisösnöŋ könahiba gwarekurupŋi yeŋgöra keu kewö indelök, “Nöŋön Jerusalem anda sihimbölö gwötpuk mötmam. Kantrigö jitŋememe, jike nup galöm aka Köna keugö böhi yeŋön nuŋgugetka kömumam. Kömumbiga wehön karöbut aiga kömupnöhök wahötmam.” ");
INSERT INTO bmu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jisösnöŋ mewö jiiga Pitönöŋ öröm waŋgiba göraŋe anda könahiba qetala kewö jim waŋgiyök, “O Kembu, mi nalö kunöŋ asuhum gihibapuköra Anutunöŋ mönö sel jöhöm gihima.” ");
INSERT INTO bmu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Qetal waŋgiiga liliŋgöba Pitö kewö jim waŋgiyök, “Gi keu mötmörizani, mi Anutugöreŋ keuya qahöpmö, gölme ambazip aka Satangö sihima. Gi nöŋgö köna utumamgö mötnöŋga urunan böliza. Miaŋgöra Satan, gi mönö dölki nöŋgö jemesoholneyök kesalnöŋ!” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nalö miaŋgöreŋ Jisösnöŋ gwarekurupŋi keu kewö jii mötket, “Kunŋan nöŋgö andöne kamamgö mötzawi, yaŋön mönö nanŋi urusileŋaŋgö sihim kömbönaŋi bölöŋi andö qeiga sisitŋi megetka sihimbölö mi bisimakŋa. Mi maripomnöŋ kömumawaŋgö dop mökösöŋda ni nuataŋgöba kama. ");
INSERT INTO bmu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kunŋan malmalŋi nanŋaŋgöra aŋgön köla nanŋi imbi-imbi maljawi, yaŋön mönö malmalŋi ölŋi jöhöi sohoma. Sohomapmö, kunŋan gölmegö malmalŋi nöŋgöra aka köleŋda tököm niŋgimawi, yaŋön mönö malmal ölŋaŋgö könaŋi miwikŋaiba köhöiba malma. ");
INSERT INTO bmu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Kunŋan gölmeŋi gölmeŋi mieŋgö öröyuaiŋi pakpak köl öröiga buŋaŋi an teköiga uruŋaŋgö malmalŋi mem sohoba silebile mala kömuiga Anutunöŋ keuŋi jim teköiga uŋaŋan ayuhuiga qahö dop kölma. Sukinapŋi miaŋön mönö urusösöŋgai qahö ak waŋgima. Qahöpmahöp. Körek neŋön mönö bohonini jöhöm aŋgubingö osibin. ");
INSERT INTO bmu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Suep gölmegö azi ölŋan könaŋgep Suep garata töröŋi yembuk ki etketka Iwiŋaŋgö asakmararaŋi eka aurume. Nalö miaŋgöreŋ mohot mohot neŋgö ahakmemenini kewöta likepŋi miaŋgö dop neŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nöŋön keu ölŋi kun kewö jibi mötme: Kiaŋgöreŋ kinjei, eŋgö sutŋineyök tosatŋan Suep gölmegö azi ölŋan kiŋ aka asuhumawi, mi ek kutume. Jebuk mala kömupkö sihimbölöŋi qahö mötketka asuhum tiŋgiriga mi ekŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wehön 6 teköiga Jisösnöŋ Pitö, Jeims aka Jeimsgö munŋi Jon eŋguaŋgita nanŋinök kunduŋi köröpŋi kunöŋ öŋgöba kötikŋe malget. ");
INSERT INTO bmu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Malgetka jemesoholŋine kiniga Jisösgö sile tandökŋan letota murutŋi ahök. Jemesoholŋan wehön jeŋi ewö kölköl-bilikbilikŋambuk asariiga malukuŋan tuat lalamŋi aka asakŋambuk ahök. ");
INSERT INTO bmu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mewö aiga eketka Moses aka Elaija yetkön asuhum eŋgiba Jisösbuk keukeu jiget. ");
INSERT INTO bmu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jigetka Pitönöŋ könahiba keu jiba Jisösgöra kewö jiyök, “Kembu, neŋön kiaŋgöreŋ uruölöwak mötzin. Miaŋgöra sihimgan mötzan ewö, nöŋön ölöp koum karöbut qemam. Göhö kun, Mosesgö kun aka Elaijagö kun.” ");
INSERT INTO bmu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mewö jiba kiniga unuŋunuŋ tuat lalamŋi asakmararaŋambuk kunöŋ eta aumŋan esuhum eŋgiiga miaŋgö uruŋeyök qet kun kewö eriga mötket, “Azi ki mi nani wölböt nahöna. Nöŋgö urusihimni ketaŋan mönö yaŋgöreŋ ahöza. Mönö yaŋgö keuŋi möta malme.” ");
INSERT INTO bmu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gwarek yeŋön keu mi möta jönömŋini undui sipköba gölmenöŋ eta keŋgötŋini gwötpuk mötket. ");
INSERT INTO bmu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mewö mötketka Jisösnöŋ yeŋgöreŋ kaba sileŋini oseiba kewö jii mötket, “Mönö wahötket. Keŋgötŋini kude mötme!” ");
INSERT INTO bmu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Keu mi möta uba wahöta tosatŋi qahö eŋgeketmö, Jisösnöŋ nanŋök kiniga eket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kunduŋeyök etketka Jisösnöŋ sörökŋi miaŋgöreŋ kewö jim kutum eŋgiyök, “Iŋini yuai ekzei, miaŋgö buzupŋi mi ambazip kun kude jiget mötme. Suep gölmegö azi ölŋan kömupnöhök wahöriga miaŋgö andöŋe mi ölöp jim asariba malme.” ");
INSERT INTO bmu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mewö jim kutum eŋgiiga gwarekurupŋi karöbut yeŋön Jisös kewö qesim waŋgiget, “Köna keugö böhi yeŋön keu kewö mi wuanöŋgöra jimakze, ‘Kezapqetok azi Elaijanöŋ mönö mutuk Suepnöhök eriga Amötqeqe Toŋan miaŋgö andöŋe asuhuma?’” ");
INSERT INTO bmu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Qesim waŋgigetka meleŋda kewö jiyök, “Elaijanöŋ mutuk eta asuhuba malmal pakpak möhamgöma. Keu mi ölŋapmö, ");
INSERT INTO bmu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","nöŋön kewö jibi mötme: Elaijanöŋ lök eta asuhuyökmö, i eka könaŋi qahö möt kutugetmö, ambazipnöŋ i nanŋini sihimŋini wuataŋgöba laŋ ak waŋgiget. Mewöŋanök Suep gölmegö azi ölŋi mewöyök laŋ ak waŋgigetka Juda yeŋgö böröŋine geba sihimbölö mötma.” ");
INSERT INTO bmu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Elaijagöra mewö jiba ölŋa Jon O-melun azigöra keu jii mötkeri, gwarek yeŋön mi mewö möt asariget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisös aka gwarek karöbut yeŋön kunduŋeyök eta ambazip kambu yeŋgöreŋ kagetka azi kunöŋ Jisösgö kösutŋe kaba simin köl waŋgiba kewö jii mörök, ");
INSERT INTO bmu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kembu, göŋön mönö nahöni ak kömum waŋgiman. Kawölnöŋ yöhöiga tala eta qeiga bözok mitiba semben auba sihimbölö gwötpuk mörakza. Nalö gwötpuk tala könöpnöŋ me onöŋ gemakza. ");
INSERT INTO bmu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nöŋön i waŋgita gwarekurupki yeŋgöreŋ kazalmö, yeŋön i mem ölöwak waŋgibingö osize.” ");
INSERT INTO bmu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mewö jiiga meleŋ waŋgiba jiyök, “Yei, gölmegö yaŋgiseŋ aka misimkaulup ambazip, mönö nalö dawik embuk mala qatön eŋgubiga Anutu qahö möt narigetka sihimbölö mötmam? I mönö waŋgita nöŋgöreŋ ki kaget.” ");
INSERT INTO bmu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Waŋgita kagetka Jisösnöŋ öme mi jim waŋgii mosöta ani morönöŋ nalö miaŋgöreŋök ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ölöwahiga gwarekurupŋan mi eka nanŋinök Jisösgöreŋ kaba tata kewö qesim waŋgiget, “Neŋön mönö wuanöŋgöra mi naninök wuataŋgöbingö osizin?” ");
INSERT INTO bmu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Qesim waŋgigetka kewö jii mötket, “Mötnaripŋinan morörökŋi akzawaŋgöra mi wuataŋgöbingö osize. Nöŋön keu ölŋi kun kewö jibi mötme: Mötnaripŋinaŋgö ölŋi mi nejoŋ kötŋaŋgö dop ahöbawak ewö, eŋön ölöp kunduŋi kiaŋgö Toŋaŋgöra kewö jim kutubeak, ‘Gi mönö kunduŋi mi meköba wahöta anda likepŋe endu alman.’ Mewö jiba möt narigetka miaŋgö dop aiga endu anma. Anutu möt narigetka inahöm eŋgiiga yuai kungöra qahö qaköbeak.” ");
INSERT INTO bmu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Öme tandökŋi mewöŋi mi mönö köuluköba nene siŋgi mala wuataŋgöbin. Yuai murutŋi kun ahinga qahö kota anma. Mewö.) ");
INSERT INTO bmu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisösnöŋ gwarekurupŋi yembuk mohotŋe Galili prowins uruŋe liliköba könanöŋ angetka Jisösnöŋ keu kötŋi kewö jii mötket, “Anutunöŋ Suep gölmegö azi ölŋi mi gölme ambazip yeŋgö böröŋine al waŋgii gema. ");
INSERT INTO bmu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Geiga i qegetka kömuma. Kömuiga wehön karöbut aiga mönö kömupnöhök wahötma.” Gwarekurupŋan mi möta uruŋinan lömböriiga wösöbirik mötket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisösnöŋ gwarekurupŋi yembuk Kaperneam taonöŋ kaŋgotketka jöwöwöl jikegö takis meme azi yeŋön Pitögöreŋ kaba kewö qesim waŋgiget, “Eŋgö böhiŋinan jöwöwöl jikegö takisŋi alma me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Qesim waŋgigetka “Oŋ!” jiyök. Miaŋgö andöŋe Pitönöŋ miri uruŋe öŋgöiga Jisösnöŋ keu mutukŋi kewö qesim waŋgiyök, “Saimon, gi denöwö mötmörizan? Denike yeŋön kölköl-örörögö töwaŋi aka takis tosatŋi mi gölmegö kiŋ azi kembu yeŋgöra alakze? Kantri toŋi neŋön me kian yeŋön mi algetka tokomakze?” ");
INSERT INTO bmu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mewö qesim waŋgiiga meleŋda “Kian yeŋön,” jiyök. Mewö jiiga Jisösnöŋ kewö jii mörök, “Mewö aiga kantri toŋi neŋön mi albinaŋgö dop qahö akzin. ");
INSERT INTO bmu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mewö akzinmö, takis qahö alinga azi mieŋgö uruŋinan bölibapuköra mönö anda kösö kawiki o aŋgönöŋ gilman. Gila söra mutukŋi öröba memani, mönö miaŋgö numbuŋi mesaköba moneŋ kötŋi miaŋgöreŋ miwikŋaiman. Moneŋ kötŋi mi azi yahöt netkö takisniraŋgö dop. Mönö mi memba eŋgiba miaŋön nöŋgö aka nangi takisniri alman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nalö miaŋgöreŋ gwarek yeŋön Jisösgöreŋ kaba kewö jiget, “Suepkö bemtohoŋ uruŋe daŋön öŋgöŋgöŋi akza?” ");
INSERT INTO bmu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mewö jigetka namande moröŋi kun qeri kaiga sutŋine ali kinök. ");
INSERT INTO bmu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kiniga kewö jiyök, “Nöŋön keu ölŋi kun kewö jibi mötme: Uruŋini qahö meleŋda nahönbörat ewö qahö akŋe ewö, iŋini mönö nalö kunöŋ Suepkö bemtohoŋnöŋ qahö aŋgotme. ");
INSERT INTO bmu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Miaŋgöra kunŋan nanŋi memba et ala morö kiaŋgö dop akŋawi, yaŋön mönö Suepkö bemtohoŋ uruŋe öŋgöŋgöŋi akza. ");
INSERT INTO bmu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kunŋan namande kewöŋi kun nöŋgö qetne köl öröba köyan kölmawi, yaŋön mönö ni köl öröm niŋgima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jisösnöŋ toroqeba kewö jiyök, “Morö kewöŋi möt narim niŋgizei, kunŋan yeŋgöreŋök kun kölgorom ak waŋgiiga siŋgisöndok akŋawi, azi miaŋön mönö lömböt öŋgöŋgöŋi miwikŋaima. Anutunöŋ lömböt miaŋgö likepŋi denöwö waŋgiiga dopŋe akawak? Kemuŋ jamönjiŋ jölŋe jöhöba köwet röndumnöŋ gilget mulumgöi gebawak, miaŋön mönö awamŋi ahum waŋgii tandök akawak. ");
INSERT INTO bmu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Siŋgisöndokö supatitikŋan mönö awamŋanök asuhumakza. Miaŋgöra gölme ambazip eŋgöra Yei wösöbirik! mötzal. Kunŋan supatitik aŋgön kölmamgö osimakzapmö, kun daŋön tosatŋi kölgorom ak eŋgiiga siŋgisöndok akŋei, yaŋgöra mönö Yei! jiba sahötzal. Sihimbölö öŋgöŋgöŋan mönö yaŋgö qakŋe öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Börögan me könagan siŋgisöndok akŋangö kölgorom ak gihima ewö, mönö yandim gilman. Yandim gilagun börötak me könatohot mala malmal köhöikŋi miwikŋaiba oyaeŋkoyaeŋ akŋanmö, köna börö yahötpuk malnöŋga könaŋgep könöp sianöŋ gil gihigetka gebanbuk. Sia könöpŋi mi teteköŋi qahö jema. ");
INSERT INTO bmu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Mewöŋanök jegan siŋgisöndok akŋangö kölgorom ak gihima ewö, mönö qözöla gilman. Qözöla gilagun je-ilik mala malmal köhöikŋe aŋgota oyaeŋkoyaeŋ akŋanmö, je yahötpuk malnöŋga könöp siagö könöpnöŋ gil gihigetka gebanbuk.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ambazip moröŋi kieŋgöreŋök kun memba et al waŋgibe-puköra mönö galömŋini meme. Nöŋön keu kewö jizal: Yeŋgö kölközizip garataurupŋinan mönö Suep miri miaŋgöreŋ nöŋgö Suep Iwinaŋgö kösutŋe mala jemesoholŋi sundan ehakze. Miaŋgöra jijiwilit kude ak eŋgime. ");
INSERT INTO bmu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Suep gölmegö azi ölŋan mönö ambazip sohosohoŋi mem letot eŋgii oyaeŋkoyaeŋ akŋegöra erök.) ");
INSERT INTO bmu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Keu kiaŋgöra denöwö mötmörize? Azi kungö lamaurupŋi 100 malgetka mieŋgöreŋök kunŋan sohoba jaŋjuŋ aniga toŋan denöwö akŋa? Yaŋön mönö 99 mi kunduŋe eŋgömosöta anda mohot jaŋjuŋ anöhi, miaŋgö jaruba anma. ");
INSERT INTO bmu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jaruba anda mala miwikŋaima ewö, nöŋön keu ölŋi kun kewö jibi mötme: Yaŋön 99 jaŋjuŋ qahö angeri, mieŋgöra nalö miaŋgöreŋ gwötpuk qahö söŋgaimapmö, mohot miaŋgöra önöŋi qahö söŋgaiba malma. ");
INSERT INTO bmu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Miaŋgö dop eŋgö Iwiŋini Suep mire maljawaŋön mönö ambazip moröŋi kieŋgöreŋök kunŋan sohoba könöp sianöŋ gebapuköra mörakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Urumeleŋ alagan siŋgisöndok ak gihima ewö, gi mönö yaŋgöreŋ anda mesohol köl waŋgiba köna siŋgiyöhi, mi kondel waŋgiman. Mewö aknöŋga keugi möta bapŋe anma ewö, göŋön mönö alagi luhut al waŋginöŋga kunbuk urumohot aka malmahot. ");
INSERT INTO bmu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mewö aknöŋga keugi möta miaŋgö bapŋe qahö anma ewö, göŋön mönö toroqeba ala mohot me yahöt etkuaŋgita yaŋgöreŋ anme. Mewö Buŋa Kimbigö keu kiaŋgö dop akŋan, ‘Keu pakpak mi ambazip yahöt karöbutŋan naŋgöba jigetka köhöima.’ ");
INSERT INTO bmu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","“Mewö aketka keuŋini möta miaŋgö bapŋe qahö anma ewö, göŋön mönö urumeleŋ könagesögö jitŋememe yeŋgöra jinöŋga yambuk eraum mötme. Eraum mötmemö, yeŋgö keu bapŋe mewöyök qahö anma ewö, mi mönö aukŋe jigetka jabö ahui urumeleŋgö kopa ewö ak waŋgiba malman. Takis tilipqilip-ŋinambuk megetka sisitŋini memakzei, miaŋgö tandök ewö i mönö mosötnöŋga yaigep malma.” ");
INSERT INTO bmu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nöŋön keu öl töhönŋi kun kewö jibi mötme: Eŋön siŋgisöndok gölmenöŋ jöhömei, mi pakpak mönö Suep mire mewöyök jöhöjöhöŋi ahöma aka siŋgisöndok gölmenöŋ mosöta pösatmei, mi pakpak mönö Anutunöŋ mosöri Suep mire mewöyök pösatpösatŋi ahöma. ");
INSERT INTO bmu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Toroqeba keu kewö jibi mötme: Gölmenöŋ eŋgöreŋök yahötŋan keu mi me mi miaŋgöra urumohok aka köuluköbitkö keu jöhömahori, mi nöŋgö Iwini Suep mire maljawaŋön mönö etkiiga buŋa qem aŋgumahot. ");
INSERT INTO bmu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mi kewögöra: Ambazip yahöt me karöbutŋan nöŋgö qetne igen me waigen tokomei, nöŋön mönö miaŋgöreŋ yeŋgö sutŋine malmam.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nalö miaŋgöreŋ Pitönöŋ Jisösgöreŋ kaba keu kewö jii mörök, “Kembu, alanan siŋgisöndok ak niŋgimakzawi, nöŋön mi indimŋi dawikö dop mosötpiga dop kölma? Indimŋi 7 mi gwötpuk. Miaŋgö dop mosötpiga dop kölma me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisösnöŋ mi möta kewö meleŋ waŋgiyök, “Indimŋi 7 qahöpmö, 70 taims 7 mi mosötnöŋga dop kölma. Nöŋön göhöra mewö jizal. ");
INSERT INTO bmu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Miaŋgö könaŋi mi kewö jim tuarimam. Suepkö bemtohoŋi mi kiŋ azi kembugö dop albi kewö akza: Kiŋnöŋ welenqeqeurupŋi eŋgohola moneŋini galöm kölgeri, miaŋgö areŋ papiaŋi kondelget mindiŋgömapköra kapaŋ kölök. ");
INSERT INTO bmu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Mewö könahiba moneŋaŋgö kösohotŋi kewöta mindiŋgögetka miaŋgöreŋ azi kun waŋgita kagetka yaŋgö jeŋe kinök. Tosaŋi 10 milyön kina mi yaŋgöreŋ ahöyök. ");
INSERT INTO bmu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mi ahöyökmö, tosaŋi mi mekömamgöra moneŋi qahö dop köli osiyöhaŋgöra aka ketaŋamŋan kinda kewö jim kutuyök, ‘Sukinapŋi ahözawi, mi pakpak mönö söŋgöröŋi memegöra alme. I aka anöm-moröŋi i mewöyök mönö söŋgöröŋini memegöra algetka moneŋ kaiga miaŋön tosaŋi mi meköme. ");
INSERT INTO bmu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mewö jim kutuiga welenqeqeŋan wösöŋe eta simin köla sipköba kewö ulet waŋgiyök, ‘Gi mönö urukönöp kude aka mökösöŋda mamböt niŋginöŋga göhöreŋ tosagi pakpak mi ölöp meköm gihimam.’ ");
INSERT INTO bmu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mewö ulet waŋgiiga ketaŋamŋan welenqeqeŋaŋgöra wösö mötmöt aka tosaŋi mi kutuba mosöta pösari erök. ");
INSERT INTO bmu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Erökmö, yaigep anda miaŋgöreŋ welenqeqe alaŋi kun miwikŋaiba ehök. Yaŋgö tosaŋi mi silim 100:kö töwaŋi (Kina500,-) miaŋgö dop yaŋgöreŋ ahöyök. I eka memba jölŋi köhöikŋanök mözöhöla kewö jiyök, ‘Nöŋgöreŋ tosa göhöreŋ ahözawi, mi mönö meköm niŋgiman me?’ ");
INSERT INTO bmu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Mewö jiiga welenqeqe alaŋan wösöŋe eta simin köla sipköba kewö ulet waŋgiyök, ‘Gi mönö urukönöp kude aka mökösöŋda mamböt niŋginöŋga göhöreŋ tosagi mi ölöp meköm gihimam.’ ");
INSERT INTO bmu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Mewö jiyökmö, yaŋön mi tököba anda jii memba jöhöba kösö mire alget tari tosaŋi mekögetka etma. ");
INSERT INTO bmu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yuai mi asuhuiga welenqeqe alaurupŋan tandök mi eka uruŋinan kömbuhiiga wösöbirik möta anda miaŋgö kösohotŋi mi körek ketaŋamŋinaŋgöra jigetka mörök. ");
INSERT INTO bmu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Mi möta ketaŋamŋinan welenqeqe mutukŋi mi qeri jeŋe kaŋgoriga kewö jii mörök, ‘Gi nup meme azi bölöŋi! Gi tosagi kutuba mosötmamgö qesim niŋginöŋga nöŋön mi pakpak mosöt gihizal. ");
INSERT INTO bmu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nöŋön gehoriba ak kömum gihibiga göŋön mewöyök miaŋgö dop welenqeqe alagi ak kömum waŋginöŋga dop kölbawak.’ ");
INSERT INTO bmu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Ketaŋamŋan mewö jiiga irimŋi seholiiga welenqeqe miaŋgö keuŋi jim teköba kösö mirigö galöm yeŋgö böröŋine al waŋgiiga sihimbölö gwötpuk möta tatma. Miaŋgöreŋ tata tosaŋi kiŋgöreŋ ahöyöhi, mi pakpak meköm teköiga etma. ");
INSERT INTO bmu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Söpsöp keu kiaŋgö ölŋi kewö: Iŋini mohot mohot alaŋinaŋgö siŋgisöndokŋi uruŋinan qahö mosötme ewö, nöŋgö Suep Iwinan mönö mewöyök keu miaŋgö dop ak eŋgima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisösnöŋ keu mi jim teköbagun Galili prowins mosöta Jordan o kutuba likepŋe anda mötöteiba eta kunbuk o mi kutuba Judia prowinsnöŋ kayök. ");
INSERT INTO bmu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kaiga ambazip kambulelembenöŋ wuataŋgöba kagetka miaŋgöreŋ mem ölöwak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mem ölöwak eŋgiiga Farisi (Köna keugö kapaŋkölköl) tosatŋan yaŋgöreŋ kaba keugö bötaknöŋ örömapkö esapköm waŋgiba kewö qesim waŋgiget, “Azinöŋ könaŋi i me waigöra anömŋi mosötmawi, mi Köna keu oŋgitma me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Qesim waŋgigetka meleŋda kewö jiyök, “Miwimiwikŋai Toŋan lök könakönahiŋeyök i ‘azi aka ambi malmegöra miwikŋaim eŋgiyök.’ Buŋa keu mi oyoŋget me qahö? ");
INSERT INTO bmu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Miwikŋaiba kewö jiyök, ‘Miaŋgöra azinöŋ mönö iwinamŋi etkömosöta anömŋaŋgöreŋ anda qekötahöiga yetkön sile mohot aka malmahot.’ Keu mi oyoŋget me qahö? ");
INSERT INTO bmu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mewö aka toroqeba yahöt qahö akzahotmö, sile mohot aka malmahot. Anutunöŋ azi aka ambi mindirim etkiyöhi, ambazip kunöŋ mönö i kude mendeŋ etkima.” ");
INSERT INTO bmu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mewö jii möta kewö jiget, “Azinöŋ aŋgömosötmosöt papia ohoba anömŋi ölöp mosötma. Mosesnöŋ mönö wuanöŋgöra keu mewö jim kutum neŋgii ahöza?” ");
INSERT INTO bmu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mewö jigetka kewö jim eŋgiyök, “Mosesnöŋ mönö uruköhöikŋinaŋgöra aka anömŋi mosötmapkö keu mewö jim kutuyökmö, könakönahiŋeyök mewö qahö ahöyök. ");
INSERT INTO bmu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nöŋön kewö jibi mötme: Anömŋan qesabulum qahö ahiga töndup wuataŋgöba ambi kun memawi, yaŋön mönö sero yoŋgorö akŋa. Kunŋan ambi mosötmosötŋi memawi, yaŋön mönö sero yoŋgorö akŋa.” ");
INSERT INTO bmu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisösnöŋ mewö jiiga gwarek yeŋön jiget, “Awanöm sutŋire aŋgömosötpitkö soŋgo mewö ahöza ewö, mönö awanöm qahö ahinga dop kölma.” ");
INSERT INTO bmu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mewö jigetmö, Jisösnöŋ kewö meleŋnök, “Miaŋgö keuŋi kusum eŋgizali, ambazip körekŋan mi nanŋinaŋgöra aŋgön köla miaŋgö dop ölöp qahö akŋemö, Anutunöŋ keu mi ambazip tosatŋi yeŋgöra eŋgiyöhi, yeŋönök mönö miaŋgö dop akŋe. ");
INSERT INTO bmu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Miaŋgö könaŋi kewö: Tosatŋan nam körö uruŋe ahuba miaŋgöreŋök könahiba awanöm akingö qahö mötze. Tosatŋan ambazipnöŋ sileŋini yandiba kondot eŋgigetka awanöm akingö dop qahö akze. Tosatŋan Suep bemtohoŋaŋgöra aka awanöm qahö akingö keuŋi jim jöhöba keuŋini mi wuataŋgömakze. Kunŋan keu mia me mia möt aŋgön köla wuataŋgömamgö dop akzawi, yaŋön mönö miaŋgö dop akŋa.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nalö miaŋgöreŋ tosatŋan nahönbörat morömorö eŋguaŋgita Jisösnöŋ böröŋi nöröpŋine ala köulukömapköra yaŋgöreŋ kagetmö, gwarek yeŋön ambazip mi jim qetal ak eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mewö aketka Jisösnöŋ kewö jiyök, “Nahönbörat moröŋi mi ölöp eŋgömosötketka nöŋgöreŋ kame. Suepkö Toŋan ambazip mewö mia bemtohoŋi buŋa qem eŋgima. Miaŋgöra i kude jöhöm eŋgime.” ");
INSERT INTO bmu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mewö jiba böröŋi nöröpŋine ala eŋgömosöta kungen anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nalö kungen azi kunöŋ Jisösgöreŋ kaba kewö qesim waŋgiyök, “Böhi, nöŋön ahakmeme ölöpŋi denöwö aka malmal köhöikŋaŋgö buŋa qem aŋgubileŋak?” ");
INSERT INTO bmu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Qesim waŋgiiga kewö jii mörök, “Ahakmeme ölöpŋi denöwö, wuanöŋgöra mewö qesim niŋgizan? Mohot-kunŋan mönö ölöpŋi akza. Malmal köhöikŋe aŋgotmamgö mötman ewö, mönö jöjöpaŋ keu tem köla malman.” ");
INSERT INTO bmu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mi möta kewö jii mörök, “Wani jöjöpaŋ keugöra jizan?” Jisösnöŋ mi möta jiyök, “Mönö ki, ‘Ambazip kun kude qenöŋ kömuma, Sero yoŋgorö kude akŋan, Yoŋgorö kude meman, Jitnöŋ alal keu kude jiman, ");
INSERT INTO bmu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Iwinamgi mönö göda qem etkimakŋan,’ aka ‘Nangi jöpaköm aŋgumakzani, miaŋgö dop mönö ambazip pakpak jöpaköm eŋgimakŋan.’” ");
INSERT INTO bmu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mewö jiiga azi gwabönöŋ kewö jiyök, “Mi pakpak mönö tem köla mala kotzal. Wanigöra kunbuk osizal?” ");
INSERT INTO bmu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Mewö jiiga Jisösnöŋ jiyök, “Gi aködamungabuk malmamgö mötman ewö, mönö anda sukinapki söŋgöröŋi memegöra alnöŋ moneŋ kaiga ambazip wanapŋi eŋgiman. Mewö aknöŋga sukinapki ketaŋi (guli masapu, milyön Kina ewö) mi Suep mire ahöm gihima. Mewö aka ni nuataŋgöba kaman.” ");
INSERT INTO bmu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mewö jiyökmö, gwabönöŋ keu mi möta sukinapŋi gwötpuk ahöyöhaŋgöra aka wösöbirik möta jeŋi asöliiga öne mosöta anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mosöta aniga Jisösnöŋ gwarekurupŋi kewö jii mötket, “Nöŋön keu ölŋi kun kewö jibi mötme: Yei! Ambazip pomŋi yeŋön mönö Suepkö bemtohoŋnöŋ aŋgotpingö lömböriba kupuk-kapak akŋe. ");
INSERT INTO bmu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi kewö jim tuarimam: Sömbup ketaŋi kamel mi kondi kinimŋe ölöp qahö aŋgotma. Miaŋgö dop ambazip pomŋi yeŋön Anutugö bemtohoŋ uruŋe aŋgotpingö lömböriba qaköme.” ");
INSERT INTO bmu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mewö jii möta gwarek yeŋön aurum tililiŋgöba kewö jiget, “Opopoŋ! Ambazip daŋön mönö Suepkö buŋaya akawak?” ");
INSERT INTO bmu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mewö jigetka Jisösnöŋ uba eŋgeka kewö jiyök, “Ambazipnöŋ mi esapköba osiba qakömakzemö, Anutunöŋ mönö yuai pakpak ölöp ahakza. Yaŋön yuai kun aka memamgö qahö osiba qakömakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pitönöŋ keu mi möta meleŋda kewö jiyök, “Mötnöŋ, neŋön mönö yuai pakpak mosöta gi guataŋgöba kain. Miaŋgö likepŋi mönö wani yuaia membin?” ");
INSERT INTO bmu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mewö jiiga Jisösnöŋ kewö jii mötket, “Nöŋön keu ölŋi kun kewö jibi mötme: Yuai pakpak kölöŋaiiga Suep gölmegö azi ölŋan jakömbuak dumŋe tari asakmararaŋan asarimawi, nalö qainŋi kun miaŋgöreŋ ni nuataŋgöba kageri, eŋön mönö mewöyök jakömbuak dum 12 miaŋgöreŋ tata Israel kambu 12 yeŋgö keuŋini kewöta jim teköme. ");
INSERT INTO bmu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Kunŋan nöŋgö qetnaŋgöra aka yuai kun mosöröhi, - mi jike miriŋi, darumunŋi, nenbehötŋi, iwinamŋi, nahönböratŋi me nup kisiŋi - mi eŋgömosöriga Anutunöŋ mönö miaŋgö likepŋi oŋgita meleŋ waŋgiiga sehima. Mewö sehiiga malmal köhöikŋi teteköŋi qahö buŋa qem aŋguma. ");
INSERT INTO bmu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mewö asuhumapmö, mutukŋi eŋgöreŋök gwötpukŋan dagibezupŋi aketka dagibezupŋi yeŋgöreŋök gwötpukŋan mutukŋi akŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisösnöŋ jiyök, “Suepkö bemtohoŋi mi kewö: Gölme toŋi kunöŋ söŋanök wahöta yaigep anda azi tosatŋi eŋgeka wain nupŋe moneŋ nup memegöra qesim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Qesim eŋgiiga ‘Ölöp,’ jigetka silim mohotkö töwaŋini (Kina 5) eŋgimapkö urumohot aketka melaim eŋgiiga wain nupŋe anget. ");
INSERT INTO bmu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Angetka 9 kilok miaŋgö dop aiga kunbuk toroqeba anda azi tosatŋi maket sombemŋe önewat kingetka eŋgehök. ");
INSERT INTO bmu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eŋgeka kewö jii mötket, ‘Iŋini mönö mewöyök nöŋgö wain nupne anda nup megetka töwaŋini dopŋeyök eŋgimam.’ ");
INSERT INTO bmu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Mewö jiiga wain nupŋe anget. Angetka 12 kilok aiga kunbuk anök aka mare 3 kilok miaŋgö dop dumŋe kunbuk yaigep anda mewöŋanök ahök. ");
INSERT INTO bmu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mewö aka mare 5 kilok miaŋgö dop yaigep aniga azi tosatŋi dumŋe kunbuk öne laŋ kingetka eŋgehök. Eŋgeka kewö qesim eŋgiyök, ‘Iŋini mönö wuanöŋgöra silim köröp ki öne malje?’ ");
INSERT INTO bmu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Mewö qesim eŋgiiga kewö meleŋget, ‘Kunŋan moneŋ nup membingöra qahö qesim neŋgiza. Miaŋgöra öne ki kinjin.’ Meleŋgetka kewö jii mötket, ‘Iŋini mönö mewöyök nöŋgö wain nupne anda nup meget.’ ");
INSERT INTO bmu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nup megetka mare aiga wain nup toŋan nup galömŋi öröba kewö jii mörök, ‘Gi mönö nup meme azi eŋgohola töwaŋini eŋgiman. Mare qöndökŋi kazei, yeŋgöreŋök könahiba eŋgiba anda söŋanök kazei, yeŋgöreŋ teköman.’ ");
INSERT INTO bmu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Mewö jiiga mare 5 kilok nupnöŋ kageri, yeŋön kaŋgotketka silim mohotkö töwaŋi (Kina 5) mi mohot mohot eŋgiiga meget. ");
INSERT INTO bmu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mutuk nupnöŋ kageri, yeŋön kaŋgota töwaŋini oŋgita memegöra mötmörigetmö, i mohot mohot mewöyök silim mohotkö töwaŋi (Kina 5) eŋgiiga meget. ");
INSERT INTO bmu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Töwa mohot miyök memba könahiba gölme toŋaŋgöra uruŋinan ihururuk möta jimoŋgot ak waŋgiba kewö jiget, ");
INSERT INTO bmu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nini wehöngöra nöŋgöp ariba nupkö lömbötŋi bisizinmö, azi mi dölök-kun nup memegöra qesim eŋgizan. Yeŋön aua mohot-kungö dop nup mezemö, göŋön töndup yeŋgöra mötmörinöŋga nembuk öröröŋ akze. Mi qahö dop kölja.’ ");
INSERT INTO bmu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mewö jigetmö, yeŋgöreŋök kungöra kewö meleŋda jiyök, ‘Alani, ni göbuk keu jiba silim mohotkö töwa (Kina 5) gihimamgö urumohot akzit. Miaŋgö dop töwa miyöhök gihibiga dop kölja. Mönö mi mötmöriman. ");
INSERT INTO bmu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Urugi miaŋgöra bölibapukmö, mönö nangi töwagi memba anman. Azi dölök-kun nup memegöra qesim eŋgizali, yeŋgöra mewöyök töwa gihizali, mönö miyök eŋgimamgö mötzal. ");
INSERT INTO bmu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","“Nani moneŋnöŋ nani sihimnaŋgö dop akiga dop kölja me qahö? Nöŋön ekbonep qahö akiga urugan auiga jegi bosoleiza me?’” ");
INSERT INTO bmu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisösnöŋ keu mi jim teköba kewö jiyök, “Miaŋgö dop qöndökŋi yeŋön mutukŋi aketka mutukŋi yeŋön qöndökŋi akŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisösnöŋ Jerusalem sitinöŋ öŋgöbingöra gölme köna angetka gwarekurupŋi 12 mi öröm eŋgiba göraŋe anda kewö jii mötket, ");
INSERT INTO bmu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mötket, nini Jerusalem öŋgöbin. Miaŋgöreŋ kunŋan Suep gölmegö azi ölŋi mamalolo mem waŋgiiga jike nup galöm aka Köna keugö böhi yeŋgö böröŋine gema. Yeŋön kömumapkö keuŋi jim teköba ");
INSERT INTO bmu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kian gawman yeŋgö böröŋine al waŋgime. Al waŋgigetka mepaiköba ihilek wahiŋambuknöŋ tauköm waŋgime. Tauköm waŋgiba maripomnöŋ qegetka kömuma. Kömumba wehön karöbut aiga kömupnöhök wahötma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nalö miaŋgöreŋ Zebedigö nahönyahöt yetkö namŋiran nahönyahötŋi yetpuk Jisösgöreŋ kaba simin köl waŋgiba yuai qainŋi kungöra uletmamgö jiyök. ");
INSERT INTO bmu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mewö jiiga qesim waŋgiyök, “Gi wani yuai akŋamgö mötzan?” Qesim waŋgiiga kewö jiyök, “Göŋön ölöp jim kutunöŋga nöŋgö nahönyahötni kietkön mönö göhö bemtohoŋnöŋ eu öŋgöba kunöŋ börögi ölŋe aka kunŋan börögi qaniŋe tata yuai pakpak galöm kölbeak.” ");
INSERT INTO bmu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mewö jiyökmö, Jisösnöŋ meleŋda kewö jiyök, “Iŋini miaŋgö könaŋi qahö möt yaköba uletze. Nöŋön qambi kakŋambuk nemami, iŋiri mi ölöp nemba sihimbölö mötmahot me qahö?” Mi möta “Ölöp nembit,” jiyohot. ");
INSERT INTO bmu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jiyohotka kewö jii mörohot, “Mi ölŋa! Nöŋön qambi kakŋambuk nemami, iŋiri mi mewöŋanök nemahotmö, nöŋgö böröni ölŋe me qaniŋe daŋön tatmahori, nöŋön keu mi jim kutumamaŋgö dop qahö. Nöŋgö Iwinan dum yahöt mi denike yetköra mözözömgöyöhi, mi mönö yetköra etkiiga nömbuk tata galöm kölmahot.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Darumun yahöt yetkön mewö ulerohotka alaurupŋi 10 yeŋön mi möta urubölö aket. ");
INSERT INTO bmu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mewö aketmö, Jisösnöŋ eŋgoholi kagetka kewö jii mötket, “Gölmegö kantriŋi kantriŋi mieŋgö jembonŋinan mönö azi kembu tandök ak eŋgimakze. Yeŋgö ketaŋamŋinan mönö keu jim kutuba mindiŋgöm eŋgiba kukösumŋini kondelakze. Iŋini könaŋini mi ölöp mötze. ");
INSERT INTO bmu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Eŋgö sutŋine silik mewö ahöbapukmö, kunŋan eŋgö sutŋine ketaŋamŋini akŋamgö mötzawi, yaŋön mönö welen qem eŋgiba malma. ");
INSERT INTO bmu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Mewöyök kunŋan eŋgö sutŋine mutukŋi malmamgö mötzawi, yaŋön mönö eŋgö nembö bapŋine mala welenqeqeŋini omaŋi akŋa. ");
INSERT INTO bmu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Suep gölmegö azi ölŋan mönö mewöyök silik mewöŋi kondela nanŋi welen qem waŋgimegöra aka qahö kayök. Qahöpmö, mönö welen qem eŋgiba ambazip sehisehiŋi yeŋgö sohopŋini memamgöra aka eta malmalŋi köleŋda mosötma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisösnöŋ gwarekurupŋi yembuk Jeriko siti mosötpingö aketka ambazip kambulelembenöŋ eŋguataŋgöba andöŋine kaget. ");
INSERT INTO bmu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mewö kagetka jegömöl azi yahöt köna jitŋe tarohot. Tarohotka “Jisösnöŋ neŋgoŋgitmamgö akza,” jiget möta kewö qerohot, “Kembu Deiwidkö gwölönarökŋi, mönö ak kömum netkinöŋ!” ");
INSERT INTO bmu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mewö qerohotka ambazip kambu yeŋön keu bök tatmahotköra qetal etkigetmö, yetkön mönö kapaŋ köla kewö qerohot, “Kembu Deiwidkö gwölönarökŋi, mönö ak kömum netkinöŋ!” ");
INSERT INTO bmu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mewö qerohotka Jisösnöŋ dörök ala yaŋgöreŋ kamahotköra qeri kayohotka kewö qesim etkiyök, “Alayahötni, nöŋön wani yuai ak etkimamgöra mötzahot?” ");
INSERT INTO bmu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mewö qesim etkiiga kewö jiyohot, “Kembu, niri jeniri kunbuk ubitköra mötzit.” ");
INSERT INTO bmu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mewö jiyohotka Jisösnöŋ yetköra wösöŋi möta jeŋiri misirii miaŋgöreŋök tohoiga uba Jisös wuataŋgöba andöŋe anohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisösnöŋ gwarekurupŋi yembuk Jerusalem siti dopdowiba Oil ip kunduŋe Betfage mirinöŋ kaget. Kaba gwarekyahötŋi yahöt melaim etkimamgöra aka ");
INSERT INTO bmu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kewö jii mörohot, “Miri wösöŋire tatzawi, mönö miaŋgöreŋ anmahot. Anda miaŋgöreŋ aŋgota doŋki ambiŋi kösönöŋ jöhöget kinjawi aka doŋki moröŋi mi miaŋgöreŋök miwikŋaim etkimahot. Mi mönö pösat etkiba memba nöŋgöreŋ kamahot. ");
INSERT INTO bmu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Pösarohotka kunŋan keu kun jiiga kewö jimahot, ‘Kembu-niran mönö miaŋgöra osiza.’ Mewö jiyohotka doŋki mi zilaŋ al etkiiga ki kamahot. ");
INSERT INTO bmu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Anutunöŋ keu kun kezapqetok azi kungö uruŋe ali jiyöhi, miaŋön ölŋambuk akŋapköra mewö asuhuyök. Keu mi kewö, ");
INSERT INTO bmu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“O Jerusalem ambazip Zaion kunduŋi liliköba maljei, yeŋgöra mönö kewö jigetka mötme, ‘Mötket, eŋgö kiŋ kembuŋinan mönö eŋgöreŋ asuhuma. Yaŋön guŋbönjönjöŋ aka doŋki qakŋe tata kama. Doŋki lömböt bisimakzawaŋgö moröŋi miaŋgö qakŋe tata kama.’” ");
INSERT INTO bmu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jisösnöŋ gwarekyahötŋi melaim etkiiga anda keu jiyöhaŋgö dop ahot. ");
INSERT INTO bmu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yetkön doŋki ambiŋi moröŋambuk etkömemba kayohot. Kayohotka malukuŋini qeköba doŋki qakŋire algetka Jisösnöŋ moröŋaŋgö qakŋe öŋgöba tarök. ");
INSERT INTO bmu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mewö tata aniga ambazip kambulelembeŋan göda qeba malukuŋini qeköba köna namŋe tumbulgetka tosatŋan ip uruŋe anda böröŋi qezuŋgata köna namŋe tumbulget. ");
INSERT INTO bmu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tumbulgetka ambazip kambu jeŋe köl öröba angeri aka andöŋe wuataŋgöba kageri, yeŋön kewö jiba qetket, “Hosana! Anutu möpöseizin. Deiwidkö gwölönarökŋi owe owe! Kembugö qetŋe kamawi, Anutunöŋ mönö i kötuetköma. Hosana! Qetbuŋagi möpöseininga euyaŋgöreŋ öŋgöza! Owe owe!” ");
INSERT INTO bmu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mewö qetketka Jerusalem sitinöŋ öŋgöba sitigö ambazip körekŋan auruba göjupmajup aka kewö qesiget, “Azi ki mönö niŋia?” ");
INSERT INTO bmu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Qesigetka ambazip kambulelembe yeŋön kewö meleŋget, “Yaŋön mönö kezapqetok azi Jisös, Galili prowinsgö Nazaret mirigöra.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisösnöŋ jöwöwöl jikegö tohoŋ uruŋe anök. Miaŋgöreŋ ambazip eŋgehiga inap bohonŋi memegöra algetka söŋgöröŋi megeri, yaŋön mi pakpak közöl eŋgiiga etket. Moneŋ utekutek ambazip yeŋgö jakeŋini metali anget. Mewöyök kembö bohonŋini memegöra algeri, mieŋgö dum tatatŋini mi tok tötaliga anget. ");
INSERT INTO bmu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mewö aka kewö jii mötket, “Aisaianöŋ keu kun kewö ohoi ahöza, ‘Nöŋgö jikenan mönö köulukö miriŋina akŋapkö qetme.’ Keu mi ahözapmö, iŋini mi utekögetka kegwek-kahasililiŋ yeŋgö baŋet ewö akza.” ");
INSERT INTO bmu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mewö aiga jegömöl aka simalokon ambazip jöwöwöl jikenöŋ yaŋgöreŋ kagetka mem ölöwak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mewö asuhuyökmö, jike nup galöm aka Köna keugö böhi yeŋön aŋgöletot meyöhi, mi eket aka nahönbörat jöwöwöl jikenöŋ qeta “Hosana! Deiwidkö gwölönarökŋi owe owe!” jigeri, mi eŋgeka urubölö aket. ");
INSERT INTO bmu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Urubölö aka kewö jim waŋgiget, “Morö mi keu qetzei, mi mötzan me qahö?” Jim waŋgigetka kewö meleŋ eŋgiyök, “Ölöp mötzal. Iŋini nalö kungen Buŋa keu ki oyoŋget me qahö, ‘Göŋön mönö nahönbörat aka morösepsep juzu nemakzei, mi kusum eŋginöŋga nangi törörök möpöseim gihimakze.’” ");
INSERT INTO bmu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mewö jiba eŋgömosöta siti mosöta mare aiga Betani anda ahöyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ahöba söŋanök wahöta kunbuk sitinöŋ anda nenegö kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nenegö kömumba köna jitŋe fig ip kun eka miaŋgö könaŋe anök. Anökmö, ölŋi qahö miwikŋaiiga sinŋanök kiniga ehök. Mewö eka ip mi kewö jim waŋgiyök, “Göŋön mönö nalö kunöŋ ölgi kunbuk kude kuŋguman.” Mewö jim waŋgiiga fig ip miaŋön mönö miaŋgöreŋök ululuŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ululuŋgöiga gwarekurupŋan mi eka auruba kewö jiget, “Fig ipnöŋ mönö denöwö ösumok ululuŋgöza?” ");
INSERT INTO bmu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jigetka Jisösnöŋ kewö meleŋnök, “Nöŋön keu ölŋi kun kewö jibi mötme: Mötnarip töp memba uruyahöt qahö akeak ewö, fig ipköra yuai asuhuzawi, iŋini miyök qahö akeakmö, ki mewöyök ölöp akeak: Kunduŋi kiaŋgö toŋaŋgöra kewö jim kutubeak, ‘Mönö kunduŋi ki qeköba wahöta anda köwetnöŋ alman.’ Mewö jim kutuba Anutu möt nariiga mönö miaŋgö dop ahuma. ");
INSERT INTO bmu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wani yuaigöra qesiba köulukömei, mi pakpak buŋa qem aŋgubingö möt narigetka mönö buŋaŋini akŋa.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisösnöŋ jöwöwöl jikegö tohoŋ uruŋe anda ambazip kusum eŋgiiga jike nup galöm aka kantrigö jitŋememe tosatŋi yeŋön yaŋgöreŋ kaŋgotket. Kaŋgota kewö qesim waŋgiget, “Gi kiaŋgöreŋ yuai akzani, mi mönö daŋön jim kutum gihiiga ahakzan? Miaŋgö kukösumŋi mi daŋön gihiyök?” ");
INSERT INTO bmu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Qesim waŋgigetka kewö meleŋ eŋgiyök, “Nöŋön mewöyök keu kun qesim eŋgimam. Mi meleŋ niŋgime ewö, nöŋön mewöyök daŋön kukösum niŋgiiga yuai ki ahakzali, mi jibi mötme. ");
INSERT INTO bmu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jonöŋ ambazip o-melun mem eŋgiba malöhi, yaŋön miaŋgö kukösumŋi mi denikeyök meyök? Suep Toŋan waŋgiyök me gölme toŋan waŋgiget?” Mewö qesim eŋgiiga sutŋine eraum möta kewö jiget, “‘Kukösumŋan Suepnöhök asuhuyök,’ mewö jibin ewö, yaŋön mönö kewö jima, ‘Iŋini mönö wuanöŋgöra Jon qahö möt narim waŋgiget?’ Mi qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Me ‘Gölme ambazipnöhök asuhuyök,’ jibin ewö, neŋön mönö ambazip kambu yeŋgöra keŋgötnini möta osibin. Könagesö pakpak yeŋön mönö Jongöra ‘Kezapqetok azia akza,’ jiba malje.” ");
INSERT INTO bmu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Keu mewö kewöta Jisösgöra kewö meleŋget, “Mi qahö mötzin.” Mewö meleŋgetka Jisösnöŋ kewö jii mötket, “Mewö aiga nöŋön mewöyök yuai ki ahakzalaŋgö kukösumŋi daŋön niŋgiyök, mi qahö jibi mötme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisösnöŋ söpsöpkeu kun kewö jiyök, “Iŋini keu kiaŋgöra denöwö mötmörize? Azi kun nahönyahötŋi yahöt malget. Nalö kunöŋ iwiŋiran nahönŋi kungöreŋ anda kewö jiyök, ‘Nahöni, gi ölöp merak nöŋgö wain kösö nupne anda nup meman.’ ");
INSERT INTO bmu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Mewö jiiga kewö meleŋnök, ‘Ni töközal.’ Mewö jiyökmö, könaŋgep keuŋi miaŋgö möt böliba eleŋda anda nup meyök. ");
INSERT INTO bmu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Miaŋgö andöŋe iwiŋiran nahönŋi kungöreŋ anda nahönŋi mutukŋaŋgö jiyöhi, keu miyök jii mörök. Mi möta keu kewö jiba meleŋnök, ‘Oŋ! Ketaŋamni, ölöp anmam.’ Mewö jiyökmö, töndup qahö anök.” ");
INSERT INTO bmu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jisösnöŋ mewö jiba qesim eŋgiyök, “Yahöt yetköreŋök daŋön mönö iwiŋiraŋgö jitŋi tem kölök?” Mewö qesim eŋgiiga kewö meleŋget, “Nahönŋi mutukŋi yaŋön.” Mewö meleŋgetka kewö jii mörök, “Nöŋön keu öl töhönŋi kun kewö jibi mötme: Takis meme ambazip tilipqilipŋinambuk aka köna ketaŋi ambi yeŋön mönö iŋini eŋgoŋgita mutuk Anutugö bemtohoŋ uruŋe öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Keu miaŋgö könaŋi kewö: Jon O-melun azinöŋ eŋgöreŋ kaba Anutugö jeŋe solanibingö könaŋi kondeliga iŋini yaŋgö keuŋi mi qahö möt narigetmö, takis meme ambazip tilipqilipŋinambuk aka köna ketaŋi ambi yeŋön mönö i möt narim waŋgiget. Yeŋön i möt narim waŋgigeri, iŋini mi eka töndup könaŋgep mewöyök nanŋini qahö möt bölim aŋguba eleŋda i qahö möt narim waŋgiget.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisösnöŋ jiyök, “Dopkeu kun kewö mötme: Gölme toŋi kunöŋ wain kösö nup kun köla kömörök. Köla kömöta selŋi memba liliköyök. Mem liliköba kötnöŋ wain jout ketaŋi kötnöŋ meyök. Miaŋgöreŋ waingö ölŋi ala könanöŋ tözöhölget oŋan lalanöŋ geyök. Wain jout ketaŋi mi kötnöŋ memba wain yoŋgorö membepuköra galöm meme jake köröpŋi köweŋambuk meyök. Yuai pakpak mem teköba wain nup galöm tosatŋi miwikŋaim eŋgiba kewö jiyök, ‘Mönö nup memba ölŋaŋgö bahöŋi nanŋini memba bahöŋi toŋi ni niŋgime.’ Mewö jiba nup mi böröŋine ala eŋgömosöta kantri kunöŋ anda malök. ");
INSERT INTO bmu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Mala mali ölŋi öliyöhaŋgö nalöŋi (yambu 5) töriiga miaŋgöreŋ welenqeqeurupŋi kun melaim eŋgiiga galöm yeŋgöreŋ anda wain nup ölŋaŋgö bahöŋi waŋgimegöra jiget. ");
INSERT INTO bmu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jigetmö, galöm yeŋön i eŋgömemba jöhöba tosatŋi kömbinöŋ sepgwörörök eŋguba tosatŋi eŋguget kömugetka tosatŋi kötnöŋ gila eŋguget kömuget. ");
INSERT INTO bmu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Miaŋgö andöŋe welenazi tosatŋi toroqeba melaim eŋgiiga gwötpuk aketmö, i mewöŋanök öröm ureim mem eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Mewö aketka wain nup toŋan keu jaruba jiyök, ‘Nani nahöni mönö göda qem waŋgime me denöwö?’ Mewö jiba qöndökŋi mi nahönŋa melaiiga yeŋgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Anökmö, wain nup galöm yeŋön nahönŋi eka sutŋine kewö eraum möta jiget, ‘Yaŋön mönö börösamotŋaŋgö toŋi akŋa. Ayop, mönö memba qein kömuiga wain kösö nupŋan mönö nanine buŋanina akŋa.’ ");
INSERT INTO bmu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Mewö jiba memba jöhöba gilgetka nup yaigepŋe geiga qeget kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wain nup toŋan mi möta kaba nup galöm mi mönö denöwö ak eŋgima?” ");
INSERT INTO bmu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jisösnöŋ mewö qesiiga kewö jiget mörök, “Galöm bölöŋi mi mönö köndeŋda yaijapaleleŋ mem eŋgima aka nup galöm dölökŋi miwikŋaim eŋgiba wain kösö nupŋi yeŋgö böröŋine alma. Yeŋön ölŋi ölimawaŋgö nalöŋe bahöŋi törörök waŋgimakŋe.” ");
INSERT INTO bmu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisösnöŋ mi möta kewö jii mötket, “Buŋa Kimbigö keu ki nalö kungen oyoŋget me qahö, ‘Miri meme yeŋön köt tandö kun andö qeba öne mosötket taröhi, miaŋön mönö tandö kömbönaŋi aiga miwikŋaiget. Miaŋön tiŋgiriga mirinöŋ gororoŋgöba eta kölma. Kembunöŋ tandö mi kuŋguiga jeninan ehinga qetbuŋabuk aiga welipkömakzin?’ ");
INSERT INTO bmu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Miaŋgöra kewö jibi mötme, Anutunöŋ mönö bemtohoŋi eŋguaŋgita ambazip kambu kun eŋgiiga yeŋön miaŋgö ölŋi ölöp kuŋgumakŋe. ");
INSERT INTO bmu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kunŋan tandö bohonŋi miaŋgöreŋ tötöŋgata eta qemawi, mi mönö sileŋi kutumutumapmö, ain tandö miaŋön jöla tala kungö qakŋe eta kölmawi, mi mönö körek qözömözö-zamgöma.” ");
INSERT INTO bmu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jisösnöŋ mewö jiiga jike nup galöm aka Farisi (Köna keugö kapaŋkölköl) yeŋön dopkeuŋi mi möta könaŋi möt asariba kewö jiget, “Mi mönö neŋgöra jiza.” ");
INSERT INTO bmu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Miaŋgöra i memba jöhöbingö mötketmö, ambazip kambu yeŋgöra keŋgötŋini möta osiget. Ambazip kambu yeŋön Jisösgöra mötketka kezapqetok azia ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisösnöŋ kunbuk könahiba söpsöp keunöŋ keu kewö jiyök, ");
INSERT INTO bmu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Suepkö bemtohoŋi mi kiaŋgö dop akza: Kiŋ azi kembunöŋ nahönŋaŋgöra maren lömbuaŋ areŋgöba mözözömgöyök. ");
INSERT INTO bmu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mözözömgöba welenqeqeurupŋi melaim eŋgiba kewö jiyök, ‘Nöŋön ambazip tosatŋi maren lömbuaŋnöŋ kamegö mötzal. Iŋini mönö yeŋgöreŋ kolek anda kamegö jiget mötme.’ Mewö jii anda jigetmö, ambazip mieŋön mi möta kabingö tököba taŋqaŋ aket. ");
INSERT INTO bmu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Miaŋgö andöŋe welenqeqeurup tosatŋi kunbuk melaim eŋgiba kewö jiyök, ‘Ambazip kamegöra jiali, mönö yeŋgöreŋ anda kewö jime: Mötket, nöŋön lömbuaŋgö neneŋamni lök mözözömgöbiga tatza. Nöŋgö bulmakau aziŋi aka bulmakau tosatŋi gumohom eŋgiinga kelökŋinambuk akeri, mi eŋguba ohom qeraköinga yuai pakpak lök jöjöröba ahöza. Iŋini mönö maren lömbuaŋnöŋ kaget.’ ");
INSERT INTO bmu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Mewö jii angetka ambazip mieŋön keu miaŋgö kezap qahö algetmö, nönöŋgan aka laŋ anget. Tosatŋan nene nupŋine angetka tosatŋan kölköl-örörö nupŋine anget. ");
INSERT INTO bmu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tosatŋan kiŋgö welen-qeqeurupŋi qelanjiba eŋgömemba öröm ureim ak eŋgiba eŋguget kömuget. ");
INSERT INTO bmu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kömugetka kiŋgö irimŋi seholiiga yarö kambuŋi melaim eŋgiiga anda kinda eŋguget kömukömu azi mi köndeŋ eŋgiba taon miriŋini mi ohogetka jeyök. ");
INSERT INTO bmu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Miaŋgö andöŋe kiŋnöŋ welenqeqeurupŋi yeŋgöra kewö jiyök, ‘Maren lömbuaŋ mözözömgöinga jöjöröba tatzapmö, ambazip kamegöra jiali, yeŋön mönö sösöŋgainöŋ kakagö dop ölöpŋi qahö akze. ");
INSERT INTO bmu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Miaŋgöra iŋini mönö köna soŋanöŋ aka miri sombemŋi sombemŋi miaŋgöreŋ anda ambazip mi me mi miwikŋaim eŋgimei, i mönö maren lömbuaŋnöŋ kamegöra jiba kapaŋ köla kuŋgum eŋgime.’ ");
INSERT INTO bmu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Mewö jiiga welenqeqeurupŋan mosöta könaŋi könaŋi miaŋgöreŋ anda ambazip mi me mi miwikŋaim eŋgigeri, mi körek pakpak öröm tokom eŋgiget. Ambazip ölöpŋi aka bölöŋi mewöyök mi mewö kagetka maren lömbuaŋ mirinöŋ kokolak qeiga tebol liliköba tatket. ");
INSERT INTO bmu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tebol liliköba tatketmö, kiŋnöŋ i eŋgekŋamgöra kaba miaŋgöreŋ azi kun maren lömbuaŋgö maluku tuatŋi qahö köli geiga ehök. ");
INSERT INTO bmu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Azi mi eka kewö jii mörök, ‘Alani, gi maren lömbuaŋgö malukuŋi qahö löŋgöta töndup denöwögöra miri kiaŋgö uruŋe kazan?’ Mewö jiiga azi miaŋön keuŋi bököiga ölöŋ tarök. ");
INSERT INTO bmu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Mewö tariga kiŋnöŋ welenqeqeurupŋi kewö jim kutum eŋgiyök, ‘Mönö azi mi memba köna böröŋi jöhöba yaigep gilgetka pandamanöŋ gema.’ Miaŋgöreŋ malmeaŋön mönö sahöt gigilahöba irimŋini yöhözömgögetka qetŋi qeri malme. ");
INSERT INTO bmu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Keu miaŋgö dop Anutunöŋ ambazip sehisehiŋan kamegöra jiyökmö, awamdökŋi yeŋön keu mi möt aŋgön köla kaba Anutunöŋ kambu möwölöhöm eŋgiyöhi, mönö yeŋgö sutŋine kaŋgotme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Miaŋgö andöŋe Farisi (Köna keugö kapaŋkölköl) yeŋön anda eraum möta Jisös qesiba keugö bötaknöŋ öröi gwaröhöm waŋgibingö areŋi alget. ");
INSERT INTO bmu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mewö areŋ ala gwarekurupŋi aka premiö Herodkö pati-alaurupŋi tosatŋi melaim eŋgigetka Jisösgöreŋ kaba kewö qesiba jiget, “Böhi, göŋön azi ölŋi akzani, nini mi mötzin. Göŋön ambazip tosatŋi qahö eŋgek soriba tosatŋi qahö qepureim eŋgimakzanmö, dop mohotnöŋ kewöt neŋgimakzan. Miaŋgöra kuŋgum gihigetka qahö goŋgiba ketaŋi qahö esuhum eŋgimakzanmö, Anutugöreŋ köna mi keu ölŋaŋgö dop kusum neŋgimakzan. Göŋön Anutugöreŋ keu diŋdiŋi miaŋön öŋgöŋgöŋi eretŋi mohot pakpak jim qindiŋ ak neŋgimakzan. ");
INSERT INTO bmu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Miaŋgöra keu kiaŋgöra denöwö mötmörizan, mi jinöŋ mötpin. Nini sisa-kiŋgöra takis ala miaŋön Mosesgö Köna keu siŋgibin me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mewö qesigetka areŋini muneŋi möt kutuba kewö jii mötket, “O urumeleŋgö silesile azi, iŋini mönö wuanöŋgöra keugö bötaknöŋ al niŋgibingö esapköm niŋgize? ");
INSERT INTO bmu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ölöp takis alalgö moneŋi kun kondel niŋgigetka eki.” Mewö jiiga silwö moneŋ (Kina 5) kun memba kaget. ");
INSERT INTO bmu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kagetka kewö qesim eŋgiyök, “Dagöreŋ imut aka qet mi ki ohoget ahöza?” ");
INSERT INTO bmu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“O mi sisa-kiŋgöreŋ,” mewö meleŋda jiget. Jigetka kewö jii mötket, “Mewö aiga yuai sisa-kiŋgö imutŋambuk buŋaŋi akzawi, mi mönö yaŋgöra al waŋgime. Yuai kun Anutugö buŋaya akzawi, mi mönö Anutugö buŋa qeme.” ");
INSERT INTO bmu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mewö jii möta yaŋgöra gwötpuk welipköba mosöta yaigep anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadyusi (Jike nupkö kapaŋkölköl) yeŋön ‘Kömugeri, yeŋön kude wahötme,’ jiba malget. Nalö miaŋgöreŋ yeŋgöreŋök tosatŋan Jisösgöreŋ kaba kewö qesim waŋgiba jiget, ");
INSERT INTO bmu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Böhi, Mosesnöŋ kewö jim kutum neŋgiyök ahöza, ‘Azi kun ambi meiga nahönbörat qahö ahui kömuiga munŋan ölöp malöŋi memba mala gwölönarök qiwikŋaim waŋgiiga datŋaŋgö qet bisiba malma.’ ");
INSERT INTO bmu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mötnöŋ, nalö kunöŋ darumun 7 malget. Datŋini mutukŋan ambi memba mala gwölönarökŋi qahö öne mala kömuyök. Kömuiga munŋan malöŋi mi meyök. ");
INSERT INTO bmu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","“Memba mala kömuiga munŋi kunŋan malöŋi mi meyök. Meiga miaŋgö andöŋe munŋi kunöŋ ambi miyök meyök. Mewöŋa mewö darumun 7 pakpak yeŋön ambi mohok miyök memba gwölönarök qahö mala kömum teköget. ");
INSERT INTO bmu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kömum tekögetka qöndökŋi malöŋini mi mewöyök kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Göŋön ‘Kömugeri, yeŋön guliba wahötme,’ jizanmö, nini mi qahö möt narizin. Mötnöŋ, azi 7 pakpak mi öröröŋ wahötpeak ewö, ambi mohok mi anömŋina meget malöhaŋgöra aka mönö dagö anömŋa akawak?” ");
INSERT INTO bmu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mewö qesigetka Jisösnöŋ meleŋda kewö jii mötket, “Iŋini keu jim sohoze. Urumeleŋgö Buŋa Kimbiŋi aka Anutugö kukösumŋi qahö möt kutuzeaŋgöra mönö jaŋjuŋ ahakze. ");
INSERT INTO bmu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ölŋa, kömupnöhök wahöta nalö miaŋgöreŋ awanöm qahö akŋemö, garata yeŋön Suep mire maljeaŋgö tandök aka malme. ");
INSERT INTO bmu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Mötket! Kömugeri, yeŋön guliba wahötmegö keuŋi Anutunöŋ eŋgöra jiyöhi, iŋini mi lök oyoŋget me qahö? Keu mi kewö, ");
INSERT INTO bmu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nöŋön Anutu Abrahamgö Kembu, Aisakö Kembu aka Jeikobkö Kembuya mala kota maljal.’ Anutunöŋ kömukömuŋi yeŋgö Kembuŋini qahöpmö, malmal köhöikŋi maljei, mönö yeŋgö Kembuŋina malja.” ");
INSERT INTO bmu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jisösnöŋ mewö ambazip kambu kusum eŋgii möta welipköget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sadyusi (Jike nupkö kapaŋkölköl) yeŋön Jisös qesim waŋgigetka meleŋda jim soroköiga keu bök akeri, mi Farisi (Köna keugö kapaŋkölköl) yeŋön möta kaba tokoget. ");
INSERT INTO bmu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yeŋgöreŋök böhi kun Köna keu törörök möt kutuyöhi, yaŋön kaba Jisös bötak ala kewö qesim waŋgiyök, ");
INSERT INTO bmu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Böhi, Mosesgö Köna keu uruŋe wani jöjöpaŋ keu mi bohonŋi ketaŋi akza?” ");
INSERT INTO bmu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Qesim waŋgiiga meleŋnök, “Bohonŋi ketaŋi mi kewö, ‘Gi urugi jömukŋi, uŋagi jömukŋi aka mötmötki jömukŋi miaŋön mönö Kembu Anutugi jöpaköba malman.’ ");
INSERT INTO bmu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Miaŋön jöjöpaŋ keu bohonŋi aka mutukŋi akza. ");
INSERT INTO bmu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jöjöpaŋ keu miaŋgö alaŋi kewö, ‘Nangi jöpaköm aŋgumakzani, mewöŋanök mönö ambazip pakpak jöpaköm eŋgiba malman.’ ");
INSERT INTO bmu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jöjöpaŋ keu yahöt mi mönö Mosesgö Köna keu aka kezapqetok ambazip yeŋgö Buzup Kimbi pakpak mieŋgö bohonŋina akza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi (Köna keugö kapaŋkölköl) yeŋön kaba tokogetka Jisösnöŋ kewö qesim eŋgiyök, ");
INSERT INTO bmu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Iŋini Kraistköra denöwö mötze? Yaŋön mönö dagö nahönŋa akza?” Mewö jiiga meleŋda jiget, “Mönö kiŋ Deiwidkö gwölönarökŋa akza.” ");
INSERT INTO bmu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jigetka jiyök, “Mewö akzapmö, denöwö aka Uŋa Töröŋan Deiwid sölölöhöm waŋgiiga yaŋgöra ‘Nani Kembuni,’ qeta kewö jiyök, ");
INSERT INTO bmu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anutunöŋ kinda nöŋgö Kembuni kewö jii mörök, Göŋön mönö kaba nöŋgö böröni ölŋe tatnöŋga nöŋön nalö sutŋe kerökurupki tim tötala luhut al eŋgiba göhö köna tambö gwaröŋe al eŋgimam. Nalö mi kam kuŋgumawaŋgö dop mönö asak-mararaŋnöŋ ki tatman.’ ");
INSERT INTO bmu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deiwidnöŋ nanŋak mewö jiba qetŋi ‘Nöŋgö Kembuni’ jiza. Kembuni jiba mönö denöwö aka yaŋgö gwölönarökŋi mohot akawak?” ");
INSERT INTO bmu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mewö jiiga miaŋgö kitipŋi kunöŋ kun meleŋmamgö osiba keu bök kinget. Sömaŋi miaŋgöreŋök körek yeŋön Jisös kunbuk keu kungö qesim waŋgibingö kölköldömdöm aka mosötket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nalö miaŋgöreŋ Jisösnöŋ ambazip kambulelembe aka gwarekurupŋi yeŋgöra kewö jii mötket, ");
INSERT INTO bmu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Köna keugö böhi aka Farisi (Köna keugö kapaŋkölköl) yeŋön Mosesgö jakömbuaknöŋ tata Köna keugö könaŋi kukösum qakŋe kusum eŋgimakze. ");
INSERT INTO bmu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Miaŋgöra keu pakpak jim kutum eŋgimakzei, mi mönö tem kölmemö, ahakmemeŋini mi kude wuataŋgöme. Yeŋön keu jitŋinan jim asarimakzemö, nanŋinak mi qahö wuataŋgömakze. Miaŋgöra mönö i ewö kude ahakŋe. ");
INSERT INTO bmu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Yeŋön keuŋi keuŋi jim kutuba miaŋgö könjöŋ lömbötŋi ambazip awötŋine alagun algetka mi tem kölbingö lömböriiga jaraŋbaraŋ ahakzemö, nanŋinak i kesötŋini moröŋi kunöŋ bauköm eŋgibingö wösömötmötŋini kun qahö ahöza. ");
INSERT INTO bmu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Yeŋön ahakmemeŋini pakpak ambazipnöŋ eŋgekŋegöra aka memakze. Baiböl keu köt (memori wös) irimuŋga bokisŋini mem qariba aukŋe kondela Buŋa mötmötŋinaŋgöra aiweliköm aŋgumakze. Malukuŋinaŋgö suŋe aködamungö biretŋi ketaŋi ketaŋi memba möndömakze. ");
INSERT INTO bmu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yeŋön közölömbuaŋnöŋ dum tatat mutukŋe jegep tatpingö mörakze aka köuluk mire qaikŋe eu tatpingö sihimŋi mörakze. ");
INSERT INTO bmu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Maketnöŋ me könanöŋ ambazip eŋgeketka jölöŋini jimegö möta ‘O ketaŋamnini,’ qetŋini mewö qetmegöra sihimŋini mörakze. ");
INSERT INTO bmu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Yeŋön mewö ahakzemö, mohok-kun yaŋön eŋgö Böhiŋini aiga iŋini körekŋan yaŋgö urumeleŋ alaurupŋi akze. Miaŋgöra eŋgö qetŋini böhinini qetmegöra kude mötme. ");
INSERT INTO bmu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mohok-kun yaŋön Iwiŋini akza. Yaŋön Suep mire maljawaŋgöra gölme azi kungöra neŋgö iwinini qet mewö kude qetme. ");
INSERT INTO bmu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kraist mohok-kun nöŋön eŋgö ketaŋamŋini akzal. Miaŋgöra eŋgö qetŋini ketaŋamnini qetmegöra kude mötme. ");
INSERT INTO bmu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Mewö qahöpmö, eŋgö sutŋine bohonŋi akzawaŋön mönö welen qem eŋgiba malma. ");
INSERT INTO bmu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mewö malmapmö, kunŋan nanŋi uruŋi memba öŋgömawi, Anutunöŋ mönö i memba et al waŋgima. Kunŋan nanŋi uruŋi memba etmawi, Anutunöŋ mönö i memba öŋgöba al waŋgima.” ");
INSERT INTO bmu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“O Köna keugö böhi aka miaŋgö kapaŋkölköl ambazip! Iŋini urumeleŋgö silesile ambazip aketka lömböt qakŋine öŋgözawaŋgöra mönö wölziköba Yei! jizal. Ambazip Suepkö bemtohoŋ uruŋe aŋgotpepukö naŋguŋi köla jöhömakze. Nanŋinak miaŋgö uruŋe qahö aŋgotze aka tosatŋan miaŋgö uruŋe aŋgotpingö akzei, iŋini i jöhöba aŋgön köl eŋgimakze. ");
INSERT INTO bmu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O Köna keugö böhi aka miaŋgö kapaŋkölköl ambazip! Iŋini urumeleŋgö silesile ambazip aketka lömböt qakŋine öŋgözawaŋgöra mönö wölziköba Yei! jizal. Iŋini malö yeŋgöreŋ miri yuai bidaŋda gagabe köla eŋguaŋgirakze aka qetbuŋaŋini asuhumapköra aka köuluk köröpŋi köuluköba töptöpŋine qemakze. Miaŋgöra Anutunöŋ keuŋini jim teköba likepŋi öŋgöŋgöŋi meleŋni eŋgö qakŋine öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“O Köna keugö böhi aka miaŋgö kapaŋkölköl ambazip! Iŋini urumeleŋgö silesile ambazip aketka lömböt qakŋine öŋgöza-waŋgöra mönö wölziköba Yei! jizal. Iŋini kunöŋ Juda ambazip kun akŋapköra kapaŋ köla köwetŋi köwetŋi kutuba gölmeŋi gölmeŋi lilikömakze. Mewö aketka kunŋan Juda neŋgö ahakmemenöŋ qekötahömawi, i mönö kusum sohom waŋgigetka könöp siagö buŋaya kun akŋa. Nanŋini ewö qahöpmö, indimŋi yahöt nanŋini eŋgoŋgita böliqölima. ");
INSERT INTO bmu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Jeŋinan gömöliiga ambazip böröŋine memba eŋguaŋ-girakzei, lömböt eŋgö qakŋine öŋgözawaŋgöra mönö wölziköba Yei! jizal. Iŋini keu kewö jimakze, ‘Kunŋan jöwöwöl jikegö qetŋe keuŋi jöjöpaŋ keunöŋ jim köhöima ewö, miaŋön qahö köhöimapmö, kunŋan jöwöwöl jikegö yuai goulnöŋ memeŋi miaŋgö qetŋe jöjöpaŋ keuŋi jima ewö, jöjöpaŋ keu miaŋön mönö jöhöm waŋgima.’ ");
INSERT INTO bmu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“O jegömöl ambazip mötkutukutuŋini piromŋi! Yuai goulnöŋ memeŋi aka jöwöwöl jike yahöt mietköreŋök wani yuainöŋ öŋgöŋgöŋi akza? Goulnöŋ nanŋak kömbukŋi qahö akzapmö, jöwöwöl jikenöŋ algetka miaŋön mönö mi mem kömbuhiza. ");
INSERT INTO bmu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Keu kun kewö jimakze, ‘Kunŋan altagö qetŋi qeta keuŋi jöjöpaŋ keunöŋ jim köhöima ewö, miaŋön qahö köhöimapmö, kunŋan naluk kötin altanöŋ ahözawi, miaŋgö qetŋi qeta jöjöpaŋ keuŋi jima ewö, jöjöpaŋ keu miaŋön mönö jöhöm waŋgima.’ ");
INSERT INTO bmu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“O jegömöl ambazip! Naluk kötin aka alta mietköreŋök wani yuainöŋ öŋgöŋgöŋi akza? Naluknöŋ nanŋak eretŋi akzapmö, altanöŋ algetka miaŋön mönö naluk mem kömbuhiza. ");
INSERT INTO bmu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Miaŋgöra kunŋan altagö qetŋe keuŋi jöjöpaŋ keunöŋ jim köhöimawi, yaŋön alta aka yuai pakpak altanöŋ ahözawi, mönö miaŋgö qetŋe keuŋi jim köhöima. ");
INSERT INTO bmu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Kunŋan jöwöwöl jikegö qetŋe keuŋi jöjöpaŋ keunöŋ jim köhöimawi, yaŋön mönö jike miaŋgö aka miaŋgöreŋ mal köhöizawaŋgö qetŋe keuŋi jim köhöima. ");
INSERT INTO bmu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mewöyök kunŋan Suepkö qetŋe keuŋi jöjöpaŋ keunöŋ jim köhöimawi, yaŋön Anutugö jakömbuak dum aka miaŋgöreŋ tatzawaŋgö qetŋe keuŋi jim köhöima. ");
INSERT INTO bmu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“O Köna keugö böhi aka miaŋgö kapaŋkölköl ambazip! Iŋini urumeleŋgö silesile ambazip aketka lömböt qakŋine öŋgözawaŋgöra mönö wölziköba Yei! jizal. Iŋini nene pakpak mendeŋda bahöŋi 10 miaŋgöreŋök mohot Anutugö buŋaya qemakze. Gipŋi, raki aka kiap kösö köt mi mewöyök mendeŋda tenöhök mohot mi Anutugö buŋa qemakze. Naluk mi törörök alakzemö, Köna keugö kötŋi bohonŋi ki mönö oŋgita mosörakze: Gi ambazip sutŋine ahakmeme diŋdiŋi wuataŋgöba ak kömum aŋguba keu pöndaŋ wuataŋgöba malman. Keu bohonŋi mi mönö kapaŋ köla wuataŋgöba malme aka keu morömorö mi mewöyök kude oŋgita mosötme. ");
INSERT INTO bmu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jeŋinan gömöliiga ambazip böröŋine memba eŋguaŋgirakzei, iŋini söp obuk nembepuköra oŋini saiyanöŋ kewörakzemö, sömbup ketaŋi kamel mi laŋ gwahörakze. ");
INSERT INTO bmu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","O Köna keugö böhi aka miaŋgö kapaŋkölköl ambazip! Iŋini urumeleŋgö silesile ambazip aketka lömböt qakŋine öŋgözawaŋgöra mönö wölziköba Yei! jizal. Iŋini amöt qem aŋgubingöra qambi aka al nenegö sileŋi saŋgoŋ yakömakzemö, dogo jimamoŋini qahö galöm köla yuai laŋ göröngöba membagun megetka nepaqepalok miaŋön uruŋini kokolak qei malje. ");
INSERT INTO bmu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“O jegömöl azi Köna keugöra kapaŋ kölakzani, gi mönö mutuk qambigö uruŋi saŋgoŋnöŋga sileŋan mewöyök sarakŋi akŋa. ");
INSERT INTO bmu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","O Köna keugö böhi aka miaŋgö kapaŋkölköl ambazip! Iŋini urumeleŋgö silesile ambazip aketka lömböt qakŋine öŋgöza-waŋgöra mönö wölziköba Yei! jizal. Iŋini qaksirigö maripomŋi saŋgoŋgetka tuatŋi akeak, mönö miaŋgö dop akze. Sileŋinan eksihimŋinambuk tandök akzemö, qaksirigö uruŋe qamöt sihit aka yuai imbiloŋloŋambuk miaŋön kokolak qei ahöza. ");
INSERT INTO bmu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","“Miaŋgö dop eŋön mewöyök ambazip jeŋine ölŋa diŋdiŋi tandök asuhumakzemö, urumeleŋgö silesile tandök aka qewöloŋnöŋ mönö uruŋini kokolak qei malje.” ");
INSERT INTO bmu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“O Köna keugö böhi aka miaŋgö kapaŋkölköl ambazip! Iŋini urumeleŋgö silesile ambazip aketka lömböt qakŋine öŋgöza-waŋgöra mönö wölziköba Yei! jizal. Iŋini kezapqetok ambazip yeŋgö qaksirinöŋ simen koum memakze aka ambazip solanŋi yeŋgö köt köteŋini meŋölömakze. ");
INSERT INTO bmu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mewö aka kewö jimakze, ‘Neŋön ambösakonini yeŋgö nalönöŋ malbinak ewö, mönö yembuk qahö toroqeinga kezapqetok ambazip yeŋgö sepŋinan mönö neŋgö qaknine qahö öŋgöbawak.’ ");
INSERT INTO bmu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Mewö jiba miaŋön nanŋinak kezapqetok ambazip eŋgugeri, yeŋgö isiurupŋina akzei, mönö keu mi naŋgöba jiba dangunu ewö kinje. ");
INSERT INTO bmu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Miaŋgöra ambösakonŋinan siŋgisöndok könahiba akeri, miaŋgö dop iŋini mönö toroqeba körek ak teköme. ");
INSERT INTO bmu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“O soramen, iŋini mönö qatö moröŋi ewö akze. Anutunöŋ keuŋini jim teköi könöp sianöŋ gebepuköra mönö denöwö unjuratpeak? Mi mönö osime. ");
INSERT INTO bmu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Miaŋgöra mötket, nöŋön kezapqetok aka mötkutukutu ambazip aka Köna keugö böhi melaim eŋgibi eŋgöreŋ kame. Kagetka yeŋgöreŋök tosatŋi i eŋguget kömume aka tosatŋi maripom qakŋe al eŋgime. Tosatŋi köuluk miriŋine örörahöm eŋgiba keuŋini jim teköba ihileknöŋ tauköm eŋgiba közöl eŋgigetka taonŋi taonŋi miaŋgöreŋ anakŋe. ");
INSERT INTO bmu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Azi solanŋi Abelgö sepŋan eriga miaŋgöreŋök könahiba eŋguba kota mala Zekaraia jöwöwöl jike kömbukŋi aka jöwöwöl alta mietkö sutŋire qeget sepŋi eri miaŋgöreŋ teköyök. Ambazip solanŋi yeŋgö sepŋini gölmenöŋ mokomalgeri, sep pakpak miaŋgö kitipŋan mönö eŋgö qakŋine öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nöŋön keu ölŋi kun kewö jibi mötme: Sepŋinaŋgö kitipŋi pakpak mi mönö ambazip merak maljei, eŋgö qakŋine öŋgöi Anutunöŋ likepŋi meleŋ eŋgii mötme.” ");
INSERT INTO bmu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisösnöŋ jiyök, “O Jerusalem Jerusalem, iŋini kezapqetok ambazip eŋguget kömugetka Anutunöŋ ambazip melaim eŋgii eŋgöreŋ kamakzei, mi kötnöŋ kumbuköm eŋgimakze. Poi namŋan moröurupŋi ginginŋi bapŋe ala köjöjohom eŋgimakzawi, nöŋön mönö miaŋgö dop nalöŋi nalöŋi göhö könagesöurupki kötala tokom eŋgimamgö möta malalmö, iŋini mi tököba mala kotket. ");
INSERT INTO bmu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mötket, Anutunöŋ mönö jike miriŋini andö qeiga sahopŋanök ahöma. ");
INSERT INTO bmu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“Mewö ahömapmö, nöŋön kewö jibi mötket, iŋini ni kunbuk qahö nekŋe. Könaŋgep nalö kun kam kuŋgui miaŋgöreŋ neka kewö jime, ‘Kembugö qetŋe kam neŋgizawi, Anutunöŋ mönö i kötuetköm waŋgima.’ Mewö.” ");
INSERT INTO bmu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisösnöŋ jöwöwöl jike mosöta eriga gwarekurupŋan yaŋgöreŋ kaba jöwöwöl jikegö tohoŋ uruŋe miri tatkeri, mi Jisös kondel waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kondel waŋgigetka meleŋda kewö jii mötket, “Miri pakpak mi ölöp eŋgekzemö, nöŋön keu ölŋa kewö jibi mötket: Mi mönö köndeŋgetka mirigö köt kun mi köt kungö qakŋe qahö ahömapmö, qeqelaŋlaŋ aka sahopŋanök ahöma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisösnöŋ Oil ip kunduŋe anda tariga gwarekurupŋan nanŋinöhök yaŋgöreŋ kaba kewö qesim waŋgiget, “Böhi, keu jizani, miaŋgö ölŋi mönö wanat nalönöŋ asuhum tiŋgitma aka göŋön kanöŋga gölmegö nalöŋan tekömamgö akŋawi, miaŋgö aiwesökŋan mönö denöwö asuhum? Mia ölöp jinöŋ mörin!” ");
INSERT INTO bmu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mewö qesim waŋgigetka meleŋda kewö jiyök: “Kunŋan isimkakalek aiga jaŋjuŋ anbepuköra mönö galömŋini memba malme. ");
INSERT INTO bmu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","‘Ambazip gwötpukŋan asuhuba nöŋgö qetne kewö jime, ‘Nöŋön Amötqeqe Toŋi Kraist akzal’. Mewö jiba ambazip gwötpuk tilipköm eŋgime. ");
INSERT INTO bmu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Iŋini yarö mieŋgö buzupŋini aka ötöŋini asuhugetka mörakŋe. Mi möta jönömŋini undubapuköra mönö galömŋini meme. Yuai mewöŋi mi mutuhök asuhumapkö jijiŋa. Mi asuhumapmö, gölmegö nalöŋan mönö miaŋgöreŋök zilaŋ qahö teköma. ");
INSERT INTO bmu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Kantri kunŋan kantri kun eŋgubingöra wahötme. Ambazip kambu kunŋan kambu kun yembuk aröŋ aŋgubingöra wahötme. Gölmeŋi gölmeŋi miaŋgöreŋ bödiŋi bödiŋi (buöröŋi buöröŋi) asuhume aka kenöŋ ketaŋi ketaŋi mi qözöla memba gölme meleŋni gemakŋa. ");
INSERT INTO bmu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yuai pakpak mi ambi köröbuknöŋ masi könahiba eŋgumakzawaŋgö dop. Gölmegö nalöŋan mönö miaŋgö dop könahiba tekömamgö akŋa. ");
INSERT INTO bmu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mewö akŋapmö, nalö miaŋgöreŋ tosatŋan iŋini uruŋini meleŋgeraŋgöra aka gawman yeŋgö böröŋine al eŋgigetka sihimbölö ak eŋgiba eŋguget kömume. Kantri pakpak yeŋön nöŋgöra aka kazik ak eŋgimakŋe. ");
INSERT INTO bmu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nalö miaŋgöreŋ gwötpukŋan mötnaripŋini mosöta aŋgönaŋ memba kazik ak aŋgume. ");
INSERT INTO bmu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kezapqetok ambazip takapulakaŋi gwötpukŋan asuhuba ambazip gwötpuk kilik-kaluk ak eŋgigetka jaŋjuŋ anakŋe. ");
INSERT INTO bmu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“Iwilele Toŋan sehiba ambazip galöm köl eŋgimawaŋgöra aka urumeleŋ ambazip sehisehiŋi yeŋgö uruŋinan amöriiga urukalemŋinan sörörauma. ");
INSERT INTO bmu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kunŋan kapaŋ köla köhöiba böŋ qeba kinda maliga gölmegö nalöŋan tekömawi, yaŋön mönö oyaeŋkoyaeŋ buŋa qem aŋguma. ");
INSERT INTO bmu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anutugö bemtohoŋaŋgö Ölöwak Buŋa ki mönö mutuk gölmegö kantriŋi kantriŋi pakpak miaŋgöreŋ jim sehigetka könagesö dop naŋgönaŋgö keuŋi mötketkun gölmegö nalöŋan miaŋgö andöŋe teköma.” Mewö ");
INSERT INTO bmu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kezapqetok azi Danielnöŋ köndeŋmöndeŋ uru-önön-ŋambukö keuŋi jii ahöza. Keu miaŋgö dop tosatŋan kaba köndeŋmöndeŋ aka yuai aŋgöjörakŋambuk mi jöwöwöl jike töröŋe alget kiniga ekŋei, - keu ki oyoŋmawaŋön mönö ölöp kezap ala möt kutuma- ");
INSERT INTO bmu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nalö miaŋgöreŋ Judia prowinsnöŋ malmei, eŋön mönö misiŋgöba öröba kunduŋe anme. ");
INSERT INTO bmu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Miri kösutŋe sombemnöŋ malmawaŋön mönö eta gösö yuaiŋi memamgöra miri uruŋe kude öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nupnöŋ anda malmawaŋön mönö mewöyök malukuŋi memamgöra liliŋgöba mirinöŋ kude anma. ");
INSERT INTO bmu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Yei! Ambi gölömbuk aka morö juzunöŋ yeŋön nalö miaŋgöreŋ denöwö ösumŋinan anbeak? ");
INSERT INTO bmu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Miaŋgöra yuai mi kie uru me Sabat kendongö nalöŋe kude asuhumapköra köuluköme. ");
INSERT INTO bmu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“Mi kewögöra: Nalö miaŋgöreŋ kahasililiŋ keta bölökŋi asuhuma. Kahasililiŋ dopŋi mewöŋi mi mönöwök nalö kungen kude asuhuba ahöyök. Anutunöŋ yuai pakpak miwikŋaiyöhi, nalö miaŋgöreŋök könahiba nalö kiaŋgöreŋ mala kota nalö sutŋe kun kude asuhuyök. Mönöwök qahö asuhuyök aka könaŋgep nalö kunöŋ kunbuk qahö ahuma. Miaŋgöra mönö köuluköba malme. ");
INSERT INTO bmu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kembunöŋ wahöjaliŋ nalö mi qahö mem töribawak ewö, ambazip körekŋan mönö ayuhum teköbeakmö, ambazip nanŋaŋgöra möwölöhöm eŋgiyöhi, yeŋgöra aka wehön mieŋgö qötöŋini mem törima. ");
INSERT INTO bmu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nalö miaŋgöreŋ kewö jime, ‘Mötket! Kraistnöŋ ki malja,’ me ‘Eket! Amötqeqe Toŋan endu kinja.’ Kunŋan mewö jima ewö, mi mönö kude möt narime. ");
INSERT INTO bmu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mi kewögöra: Amötqeqe toŋi muneŋi aka kezapqetok ambazip takapulakaŋi asuhuba aŋgöletot aka aiwesök ketaŋi ketaŋi megetka letotme. Mewö letotketka Anutunöŋ ambazip nanŋaŋgöra möwölöhöm eŋgiyöhi, i mewöyök eŋololoŋ mem eŋgimegö esapköba kapaŋ kölgetka jaŋjuŋ akepuk. Eŋön ölöpŋanök galömŋini memba malgetka mi osibeak. ");
INSERT INTO bmu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mötket! Nöŋön yuai pakpak mi qahö asuhuiga qeljiŋe lök jibi mötze.” ");
INSERT INTO bmu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Miaŋgöra ‘Amötqeqe Toŋan mönö gölme apopamkölkölŋe malja,’ mewö jiget mötme ewö, miaŋgöreŋ mönö kude anme. Me ‘Mötket! Kraistnöŋ mönö miri miaŋgö uruŋe asuhuba tatzawi,’ mewö jiget möta mi kude möt narime. ");
INSERT INTO bmu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mi kewögöra: Suep gölmegö azi ölŋan kunbuk kamawi, nalö mi mönö wölbilikö dop kewö akŋa: Mi wehön kotkotŋeyök zilaŋ biliksik ala likepŋe wehön gegeŋe dop köla asariba ani ekzini, yaŋön mönö miaŋgö dop asuhuma. ");
INSERT INTO bmu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Sömbup gisakŋan kungen ahöiga, manu köraraknöŋ miaŋgöreŋ öröba tokomakzei, miaŋgö dop asuhuma.” Mewö ");
INSERT INTO bmu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Wahöjaliŋ nalö miaŋön teköiga miaŋgöreŋök wehön jeŋan injaŋ köliga köiŋnöŋ ömuŋ kölma. Seŋgelau yeŋön suepnöhök teköba etme aka suepnöŋ uturuköiga miaŋgö öröyuaiŋi mi tatatŋini mosöta eŋololoŋ aketka sohoma. ");
INSERT INTO bmu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nalö miaŋgöreŋ Suep gölme azi ölŋaŋgö aiwesökŋan suepnöŋ asuhuiga ekŋe. Nalö miaŋgöreŋ gölmegö könagesö pakpak yeŋön jiŋgeŋ köla sahötme. Sahöta Suep gölmegö azi ölŋi yaŋön suepkö kousu qakŋe kaŋgori ekŋe. Kukösumŋi ketaŋan saköl-diŋdiŋambuk aukŋe asuhuiga asakmararaŋi ekŋe. ");
INSERT INTO bmu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kaŋgori eketka tömunŋi qainŋi kun ugetka ötöŋi köhöikŋi mötketka Suep garataurupŋi melaim eŋgiiga yeŋön ambazip Anutunöŋ nanŋaŋgöra möwölöhöm eŋgiyöhi, i gölme göraŋi likeplikep euke emuke miaŋgöreŋök kölolohoba eŋguaŋgitme.” Mewö ");
INSERT INTO bmu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Iŋini geröp ip eka tandökŋi mötmöriba dopkeu ki mötme. Böröŋan lök oŋambuk aiga sinŋini yoŋgoigetka mi eka möta kewö jimakze, ‘Wehön nalöŋan mönö dopdowiza.’ ");
INSERT INTO bmu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eŋön mewöŋanök aiwesök miaŋgö dop asuhuiga eka möt asariba könaŋi kewö jime, ‘Jisösnöŋ mönö naŋgunöŋ dopdowiza.’ ");
INSERT INTO bmu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Nöŋön keu ölŋi kun kewö jibi mötket: Ambazip ki merak gölmenöŋ maljei, yeŋön qahö kömugetka yuai pakpak jizali, mi mönö yeŋgö malmal nalöŋine asuhuma. ");
INSERT INTO bmu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Suep gölmenöŋ ayapkömahotmö, nöŋgö Buŋa keunan mönö nalö kunöŋ qahö ayapköma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Suep gölmegö azi ölŋan kamapmö, dawinöŋ kam kuŋgumawi, miaŋgö wehönŋi me aua nalöŋi mi kunŋan kun kude mötza. Suep garatanöŋ mi qahö mötze. Anutugö Nahönŋan mewöyök mi qahö mötza. Iwinöŋ nanŋök mi mötza. ");
INSERT INTO bmu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mönöwök Noagö nalöŋe ambazipnöŋ malmalŋini qemasolokep qakŋe mala ayuhugeri, miaŋgö dop mönö Suep gölmegö azi ölŋan kunbuk kamawaŋgö nalöŋe asuhuma. ");
INSERT INTO bmu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","“O göulu ketaŋan qahö kaiga qeljiŋe miaŋgöreŋ ambazip nene lömbuaŋ ala o köhöikŋi nemba ambi kenam bohonŋaŋgö alget anda kaiga aŋgömeget. Ahakmeme mewö aka memba qemasolokep malgetka Noanöŋ waŋge uruŋe öŋgöyöhi, silim miaŋgöreŋ teköyök. ");
INSERT INTO bmu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Teköiga wanat yuai asuhumawi, mi qahö mötketka o göulu ketaŋan kaba jinonŋi qahö ayuhum eŋgiyök. Könaŋgep Suep gölmegö azi ölŋan kunbuk kamawi, nalö miaŋgöreŋ ambazipnöŋ mewöŋanök qemasolokep aka mala ayuhume. ");
INSERT INTO bmu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nalö miaŋgöreŋ azi yahöt nupnöŋ malohotka yetköreŋök kun waŋgita kun mosötme. ");
INSERT INTO bmu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mewöŋanök ambi yahöt taweŋ urasiba (bunahöba) tatmahori, yetköreŋök kun waŋgita kun mosötme. ");
INSERT INTO bmu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kembunöŋ kamawaŋgö nalöŋi me auaŋi qahö mötzeaŋgöra mönö uruguliguli aka malme. ");
INSERT INTO bmu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gwölö malbingö keu ki mönö möt kutume: Suŋgem aiga kegwek-kahasililiŋ azinöŋ wani nalönöŋ me auanöŋ kamawi, miri toŋan mi mötpawak ewö, yaŋön mönö gwölö mala miriŋi ölöpŋanök galöm meiga qesiŋda öŋgömamgö osima. ");
INSERT INTO bmu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Iŋini ‘Suep gölmegö azi ölŋan nalö kiaŋgöreŋ qahö kaŋgotma,’ jiba mötmörigetka yaŋön mönö nalö miaŋgöreŋök kaŋgotma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Mewö aiga nup meme ambazip sutŋine daŋön tiŋ kutuba tosatŋi eŋgoŋgitza? Tosatŋan sörörauba nup mosötketka kunŋan mötkutukutu ölöpŋaŋgö qakŋe kapaŋ köla pöndaŋ memakzawi, yaŋön mönö simbawoŋ akza. Miri toŋan ahakmemeŋi kewöta eka kungen anda miriŋaŋgö öröyuaiŋi mi böröŋe ali galöm akŋa. Galöm aka welenqeqeurupŋi jiyöhaŋgö dop köyan köla nalö diŋdiŋe gumohom eŋgimakŋa. ");
INSERT INTO bmu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mewö köyan köl eŋgiba maliga toŋan liliŋgöba kaba mewö eka mönö simbawoŋ jima. ");
INSERT INTO bmu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Nöŋön keu ölŋi kun kewö jibi mötket: Toŋan simbawoŋ jiba sukinapŋi pakpakö galömŋi kuŋgum waŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kuŋgum waŋgimapmö, nup meme okonŋi yaŋön uruŋan mötmöriba kewö jima ewö, ‘Kembunaŋgö kaka nalöŋan mönö köröpŋi ahöza.’ ");
INSERT INTO bmu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mewö jiba könahiba nup meme ambazipurupŋi eŋgum ureiba közölömbuaŋ ala söŋgaiba o köhöikŋi nemba uruŋi sohoiga eŋololoŋ silekmalek aka malma. ");
INSERT INTO bmu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","“Mewö mala nalö kunöŋ kembuŋi kaŋgotmapköra qahö mambötmawi, mönö miaŋgöreŋ kaŋgotma. Nalögöra ikmaok iŋululuŋ mali mönö aua miaŋgöreŋ kaŋgota ");
INSERT INTO bmu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","qeba yaijapaleleŋ mem waŋgiba jim kutuiga urumeleŋgö silesile ambazip ewö könöp sianöŋ geba sihimbölö mötma. Mewö möta sahöt gigilahöba irimŋini yöhözömgögetka qetŋi qeri malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisösnöŋ jiyök, “Kunbuk kamami, nalö miaŋgöreŋ Suepkö bemtohoŋan kewö akŋa: Maren lömbuaŋ nalöŋe ambi seram jömukŋi tenŋan ‘Azi buŋabuk aitoŋgöbin,’ jiba kiwaŋini memba könanöŋ anget. ");
INSERT INTO bmu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yeŋgöreŋök 5 mi mötkutukutuŋinambuk aketmö, tosatŋi 5 yeŋgö mötkutukutuŋini mi piromŋi. ");
INSERT INTO bmu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mötkutukutuŋini piromŋi yeŋön kiwaŋini megetmö, könöp (kuwiŋ) kelökŋi qahö memba anget. ");
INSERT INTO bmu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mötkutukutuŋinambuk yeŋön kiwaŋini aka kuwiŋ kelök kirinŋini mewöyök memba anget. ");
INSERT INTO bmu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Angetka azi buŋanöŋ zilaŋ qahö kaiga mambötketka nalö köriyöhaŋgöra körek yeŋgö jeŋini böŋböŋ meiga nöröpŋini eri sipköba gaun ahöget. ");
INSERT INTO bmu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Gaun ahögetmö, suŋgem bibiŋe kunöŋ tömun qeri qet kewö mötket, ‘Mötket, azi buŋa kazawo! Mönö yaŋgöreŋ anda aitoŋgöme.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Qet mi möta ambi seram ten mi körekŋan wahöta kiwaŋini memba möhamgöba ohotiriget. ");
INSERT INTO bmu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ohotirigetka mötkutu-kutuŋini piromŋi yeŋön mötmöt ambi yeŋgöreŋ kaba kewö jiget, ‘Neŋgö kiwaninan böközawaŋgöra eŋön mönö kuwiŋ kelökŋi tosatŋi neŋgime.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Mewö jigetka mötkutukutuŋinambuk yeŋön meleŋda kewö jiget, ‘Qahö. Mi iŋini aka nini dopnine qahö. Miaŋgöra mönö stuanöŋ anda nanŋini kuwiŋ kelökŋini söŋgöröŋi meme.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Mewö jigetmö, kuwiŋ kelökŋi bohonŋi membingöra anda könanöŋ malgetka azi buŋanöŋ mönö miaŋgöreŋök kaŋgorök. Ambi seram jöjöröba kingeri, yeŋön anda yambuk aitoŋgöba maren lömbuaŋ miri uruŋe öŋgögetka naŋguŋi kölget. ");
INSERT INTO bmu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ambi seram stuanöŋ angeri, yeŋön mewöyök könaŋgep kaŋgota naŋgu qeba kewö qetket, ‘Kembu Kembu, mönö naŋgu metal neŋginöŋ!’ ");
INSERT INTO bmu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Mewö qetketmö, kewö meleŋda jiyök, ‘Qahö. Ni iŋini qahö möt eŋgizal. Keu ölŋa mi jizal.’” ");
INSERT INTO bmu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisösnöŋ söpsöp keu mewö jiba gwarekurupŋi yeŋgöra keu kewö jii mötket, “Iŋini ni kamamaŋgö nalöŋi me auaŋi kude mötzeaŋgöra mönö uruguliguli aka malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Mönö dopkeu kiaŋgö dop asuhuma: Azi kun miriŋi mosöta köröwen kantri kunŋan anmamgö möta welenqeqeurupŋi eŋgoholi kagetka moneŋ sukinapŋi galöm kölmegöra jim kutum eŋgiba böröŋine alök. ");
INSERT INTO bmu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nup memeŋini kewöta ölŋi dawik asuhumawaŋgö dop möta nup meme azi kungöra moneŋ esu 5 (Kina 5000,-) waŋgiba kun moneŋ esu yahöt (Kina 2000,-) waŋgiba kun mohok-kun (Kina 1000,-) waŋgiyök. Mewö galöm kölmegöra mendeŋ eŋgiba eŋgömosöta anök. ");
INSERT INTO bmu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Azi Kina 5000,- meyöhaŋön miaŋgöreŋök anda kölköl-örörö nup meiga moneŋ sehiiga esu 5 kunbuk meyök. ");
INSERT INTO bmu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mewöŋanök Kina 2000,- meyöhaŋön anda kölköl örörö nup meiga moneŋ sehiiga esu yahöt kunbuk meyök. ");
INSERT INTO bmu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Mewö meyohotmö, azi moneŋ esu mohok-kun (Kina 1000,-) meyöhaŋön mönö mosöta anda gölme esiba azi kembuŋaŋgö moneŋi löm köla asambörök. ");
INSERT INTO bmu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nalö köröpŋi teköiga welenqeqe yeŋgö azi kembuŋinan liliŋgöba kaba ‘Nup megeraŋgö kösohotŋini möta kewötmam,’ jiba köl öröm eŋgiiga kaget. ");
INSERT INTO bmu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Mewö kagetka azi Kina 5000,- meyöhaŋön jeŋe kaŋgota esu 5 kunbuk toroqeba memba kaba kewö jiyök, ‘Ketaŋamni mötnöŋ, göŋön moneŋ esu 5 niŋginöŋi, nöŋön miaŋgö kölköl öröröŋi membi sehiiga esu 5 kunbuk asuhuiga memba kazal.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Mewö jiiga azi kembuŋan kewö meleŋ waŋgiyök, ‘Mi ölöp. Gi nup meme azi ölöpŋi memburik-qemburiki qahö. Gi yuai awamŋi memba mi kapaŋkapaŋ aka galöm köla malnöŋga sehiyök. Miaŋgöra nöŋön yuai gwötpuk göhö böröge albi miaŋgö galömŋa malman. Ölöp kaba azi kembugi nöŋgö miri uruŋe kaŋgota mohotŋe sösöŋgai aka malbin.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Azi Kina 2000,- meyöhaŋön mewöŋanök kaŋgota kewö jiyök, ‘Ketaŋamni mötnöŋ, göŋön moneŋ esu yahöt niŋginöŋi, nöŋön miaŋgö kölköl-öröröŋi membi sehiiga esu yahöt kunbuk asuhuiga memba kazal.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Mewö jiiga azi kembuŋan kewö meleŋ waŋgiyök, ‘Mi ölöp. Gi nup meme azi ölöpŋi memburik-qemburiki qahö. Gi yuai awamdökŋi memba mi kapaŋkapaŋ aka galöm köla malnöŋga sehiyök. Miaŋgöra nöŋön yuai gwötpuk göhö böröge albi miaŋgö galömŋa malman. Ölöp kaba azi kembugi nöŋgö miri uruŋe kaŋgota mohotŋe sösöŋgai aka malbin.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Miaŋgö andöŋe azi moneŋ esu mohok-kun (Kina 1000,-) meyöhaŋön kaŋgota kewö jiyök, ‘Ketaŋamni mötnöŋ, nöŋön könaŋamgi kewö möt yaköyal: Azi kembunan mönö azi köhöikŋi könöpŋambuk akza. Nangak nene kötŋi qahö qesiŋ gilnöŋga miaŋgöreŋ mönö töndup ölŋi sounöŋ yandiba memamgö mörakzan. Padi kötŋi qahö esinöŋ geiga miaŋgöreŋ mönö töndup ölŋi qezakömamgö mörakzan. ");
INSERT INTO bmu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","“Mewö möt yaköba keŋgötni möta anda göhö moneŋ esugi mi gölmenöŋ asambötpiga ahöyök. Eknöŋ, moneŋ esu niŋginöŋi, miyöhök mönö törörök ki.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mewö jiba mi waŋgiyökmö, azi kembuŋan meleŋda kewö jim waŋgiyök, ‘Gi injarere aka welenqeqe bölöŋi akzan! Gi könaŋamni möt yakönöŋ: Nanak nene kötŋi qahö qesiŋ gilbiga miaŋgöreŋ mönö töndup ölŋi sounöŋ yandiba memamgö mörakzal. Nanak padi kötŋi qahö esibi geiga miaŋgöreŋ töndup ölŋi qezakömamgö mörakzal. Nöŋgö tandökni mewö möt yaköbagun mönö wuanöŋgöra ak sohoba malnöŋ? ");
INSERT INTO bmu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","“Gi nöŋgö moneŋni benknöŋ alnöŋga dop kölbawak. Benknöŋ alnöŋga qariiga liliŋgöba kayali, nalö kiaŋgöreŋ mi ölöp suŋambuk membileŋak.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Toroqeba tosatŋi yeŋgöra jiyök, ‘Iŋini mönö qölzöm injarere azi miaŋgö moneŋ esuŋi mi waŋgita kun esu 10 miwikŋaiyöhi, mönö i waŋgime.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Dopkeu kiaŋgö könaŋi kewö: Denike yeŋgöreŋ yuai ahözawi, körek yeŋgöra mönö toroqeba eŋgiget sehiiga keleŋmaleleŋ ahöm eŋgima. Mewö sehimapmö, kungöreŋ yuai kun qahö ahözawi, yaŋgöreŋ yuai mi mönö mewöyök waŋgitketka öne töhöntöhön malma. ");
INSERT INTO bmu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ayop, welenqeqe azi omaŋi nupŋaŋgö ölŋi qahö i mönö yaigepŋe gilgetka söŋaupnöŋ gema. Miaŋgöreŋ geba sahöt gigilahöba göboŋini yöhözömgögetka qetŋi qeri malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Suep gölmegö azi ölŋan kinda Suep garata pakpak eŋguaŋgita mohotŋe kamei, nalö miaŋgöreŋ Suepkö asakmararaŋan asuhuiga yaŋön Kiŋ Kembugö jakömbuak dumnöŋ tatma. ");
INSERT INTO bmu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tata jiiga gölmegö ambazip kambu pakpak qezaköm eŋgigetka yaŋgö jeŋe asuhume. Asuhugetka lama galömŋan lamaurupŋi meme (noniŋ) yeŋgöreŋök mendeŋ eŋgizawi, miaŋgö dop i mendeqendeŋ ak eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mi ak eŋgiba jiiga lama mi böröŋi ölŋe aka meme (noniŋ) mi qaniŋe al eŋgime. ");
INSERT INTO bmu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Mewö al eŋgigetka Kiŋ Kembunöŋ böröŋi ölŋe kinmei, yeŋgöra kewö jima, ‘Nöŋgö Iwinan kötuetköm eŋgii malgeri, iŋini mönö kaget. Iwi Anutuninan gölme pakpak miwikŋaim eŋgiyöhi, nalö miaŋgöreŋök lök eŋgöra bemtohoŋ mözözömgöba mei jöjöröba ahöba kotzawi, iŋini mönö kaba mi buŋa qem aŋguba malme. ");
INSERT INTO bmu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‘Mi kewögöra jizal: Nöŋön yakanaŋgö kömumba malbiga iŋini nene niŋgiba malget. Nöŋön ogöra qemjeŋ qeba malbiga iŋini o niŋgiba malget. Nöŋön kian aka malbiga iŋini köl öröm niŋgigetka miriŋine öŋgöba malal. ");
INSERT INTO bmu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nöŋön sile esunaŋgöra osiba malbiga iŋini opo kereŋ niŋgiba malget. Nöŋön kawöl nöhöi ahöbiga iŋini galöm köl niŋgiba malget. Nöŋön kösö mire malbiga iŋini ni nekingöra miaŋgöreŋ kaba malget.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Mewö jiiga ambazip solanŋi yeŋön kewö meleŋ waŋgiba jime, ‘Kembu, gi mönö wani nalönöŋ yakagahö kömunöŋ geka gumohom gihiba malin? Mönö wani nalönöŋ ogöra qemjeŋ qeba malnöŋga geka o gihiba malin? ");
INSERT INTO bmu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mönö wani nalönöŋ kiana kanöŋga geka köl öröm gihiinga mirinine öŋgönöŋga malin? Mönö wani nalönöŋ sile esugahöra osiba malnöŋga geka opo kereŋ gihiba malin? ");
INSERT INTO bmu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","‘Mönö wani nalönöŋ kawöl göhöi ahönöŋga geka me kösö mire malnöŋga möta gi gekingöra göhöreŋ kaba malin?’ ");
INSERT INTO bmu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mewö jigetka Kiŋ Kembunöŋ meleŋda kewö jii mötme, ‘Nöŋön keu ölŋi kun kewö jibi mötme: Iŋini nani urumeleŋ alaurupni etqeqeŋi kieŋgöreŋök kungöra yuai kun akeri, mi pakpak mönö ni ak niŋgiba malget.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mewö jiba miaŋgö andöŋe böröŋi qaniŋe kinmei, yeŋgöreŋ meleŋda kewö jima, ‘Iwinan qesuahöm eŋgii malgeri, iŋini mönö nömosöta kesalget. Könöp sia teteköŋi qahö jem öŋgömawi, mönö miaŋgöreŋ anda geme. Anutunöŋ mi Bölöŋaŋgö Toŋi aka yaŋgö garataurupŋi yeŋgöra mözözömgöba meköiga jöjöröba ahöza. ");
INSERT INTO bmu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mi kewögöra jizal: Nöŋön yakanaŋgö kömumba malbiga iŋini nene qahö niŋgiba malget. Nöŋön ogöra qemjeŋ qeba malbiga iŋini o qahö niŋgiba malget. ");
INSERT INTO bmu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","‘Nöŋön kian aka kabiga iŋini qahö köl öröm niŋgigetka miriŋine qahö öŋgöba malal. Nöŋön sile esunaŋgöra osiba malbiga iŋini opo kereŋ qahö niŋgiba malget. Nöŋön kawöl nöhöi ahöyal aka kösö mire malalmö, iŋini ni nekingöra miaŋgöreŋ qahö kaba malget.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Mewö jiiga yeŋön mewöyök meleŋ waŋgiba kewö jime, ‘Kembu, gi mönö wani nalönöŋ yakagahö kömunöŋ me ogöra qemjeŋ qeba malnöŋ me kiana malnöŋ me sile esugahöra osiba malnöŋ me kawöl göhöi ahönöŋ me kösö mire malnöŋga nini gi qahö welen qem gihiba malin?’ ");
INSERT INTO bmu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mewö jigetka meleŋda kewö jii mötme, ‘Nöŋön keu ölŋi kewö jibi mötme: Iŋini urumeleŋ alaurup etqeqeŋi kieŋgöreŋök kungöra yuai kun qahö akeri, mi pakpak mönö ni qahö ak niŋgiba malget akza.’ ");
INSERT INTO bmu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Mewö jii mötketka likepŋi meleŋ eŋgii qakŋine öŋgöiga aköm eŋgii anda sihimbölö nalö teteköŋi qahö möta mal öŋgöme. Mewö mal öŋgömemö, solanŋi yeŋön oyaeŋkoyaeŋ malmal mi nalö teteköŋi qahö mal öŋgöba malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisösnöŋ keu pakpak mi jim teköba gwarekurupŋi kewö jii mötket, ");
INSERT INTO bmu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Silim yahöt teköigun Pasowa kendonŋi kam kuŋguma. Iŋini mi ölöp mötze. Kam kuŋguiga Suep gölmegö azi ölŋi mi kian gawman yeŋgö böröŋine algetka maripomnöŋ qegetka kömuma.” ");
INSERT INTO bmu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nalö miaŋgöreŋ jike nup galöm aka kantrigö jitŋememe yeŋön tokoba jike nup galöm bohonŋi qetŋi Kaiafas yaŋgö jakömbuak miriŋe tatket. ");
INSERT INTO bmu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Miaŋgöreŋ tata denöwö möndöŋninga Jisös ölöŋ memba qeget kömumbawak, miaŋgö könaŋi jaruba kewötket. ");
INSERT INTO bmu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jaruba kewöta kewö jiget, “Ambazip irimŋini seholiiga karimŋi karimŋi asuhubepuköra mi sösöŋgai kendon nalöŋe akingö osibin.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisösnöŋ Betani mirinöŋ mala Saimon kun uzikukuŋi mem solaniyöhi, yaŋgö mire öŋgöba tarök. ");
INSERT INTO bmu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Miaŋgöreŋ nene nemba tariga ambi kunöŋ köt-kirin kun memba yaŋgöreŋ kayök. Kirin mi nöluk tuat-tuat qetŋi alabastö miaŋön memeŋa. Mia o umköhöwakŋambuk miaŋön kokolak qeqeŋa. Yaŋön mi bohonŋi ketaŋan memba kaba oŋi Jisösgö nöröpŋe mimbiliba miriyök. ");
INSERT INTO bmu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Miriiga gwarekurupŋan mi eka urubölö aka kewö jiget, “Mi mönö wuanöŋgöra mewö ayuhuzawi? ");
INSERT INTO bmu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","O kelökŋambuk mi bohonŋi memegöra ali moneŋ öŋgöŋgöŋan asuhuiga mi ambazip wanapŋi eŋgiiga dop kölbawak.” ");
INSERT INTO bmu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisösnöŋ urumötmötŋini mi ek kutuba kewö jii mötket, “Ambi kiaŋgö uruŋi mi wuanöŋgöra mem bölize? Yaŋön silik ölöpŋi ak soroköm niŋgiiga dop kölja. ");
INSERT INTO bmu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ambazip wanapŋi mi nalöŋi nalöŋi sutŋine malmemö, nöŋön eŋgö sutŋine nalö dop qahö malmam. ");
INSERT INTO bmu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","“Nöŋön kömumbi löm köl niŋgimeaŋgöra aka kelök miaŋön sileni nömiriza. ");
INSERT INTO bmu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nöŋön keu ölŋi kun kewö jibi mötket: Ölöwak Buŋa ki kantri igen waigen jim sehigetka anmawi, miaŋgöreŋ ambi kiaŋön yuai ak niŋgizawi, miaŋgö buŋaŋi mohok jiget sehiiga yaŋgöra mötmöriba malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nalö miaŋgöreŋ gwarekurupŋi 12 yeŋgöreŋök kun qetŋi Judas Iskariot yaŋön jike nup galöm yeŋgöreŋ anda ");
INSERT INTO bmu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kewö qesim eŋgiyök, “Nöŋön Jisös mamalolo mem waŋgiba böröŋine albiga eŋön töwa wania niŋgibeak?” Qesim eŋgiiga silwö moneŋ kötŋi 30 oyoŋda böröŋe alget. ");
INSERT INTO bmu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aua miaŋgöreŋök könahiba Jisös nalö kungen mamalolo mem waŋgimamgö köna möt jaruba köiŋbiŋgöba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Beret yistŋi qahö miaŋgö kendon silim mutukŋe (Seqononöŋ) gwarek yetkön Jisösgöreŋ kaba kewö qesim waŋgiyohot, “Böhi! Nini miri denikeaŋgöreŋ anda pasowa lama mözözömgöm gihiziga neman? Sihimgi denöwö ahöza?” ");
INSERT INTO bmu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Qesim waŋgiyohotka kewö meleŋnök, “Iŋiri Jerusalem sitinöŋ öŋgöba azi kun mötzali, i miwikŋaiba kewö jiyohotka mötma, ‘Böhinöŋ jiza: Nöŋgö nalönan mönö dopdowiza. Nöŋön göhö mire kaba gwarekurupni yembuk Pasowa lama membin.’” ");
INSERT INTO bmu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gwarek yetkön Jisösnöŋ jim kutum etkiyöhi, miaŋgö dop aka Pasowa lama mözözömgöyohot. ");
INSERT INTO bmu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mare aiga miri söŋauiga Jisösnöŋ gwarekurupŋi 12 yembuk miri miaŋgöreŋ kaŋgota öŋgöba dum kösutŋe tata nene mendeŋda neget. ");
INSERT INTO bmu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nene negeraŋgöreŋ Jisösnöŋ kewö jii mötket, “Nöŋön keu ölŋi kun kewö jibi mötket: Eŋgöreŋök kunŋan mönö mamalolo mem niŋgima.” ");
INSERT INTO bmu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mewö jii möta miaŋgöreŋök uruŋinan wösöbirik ketaŋi aiga könahiba nanŋök nanŋök qesim waŋgiba jiget, “Kembu, mönö nöŋgöra jibanbuk?” ");
INSERT INTO bmu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Qesim waŋgigetka kewö meleŋnök, “Nömbuk beret kuluŋnöŋ kundumgözawi, mönö yaŋön. ");
INSERT INTO bmu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Suep gölmegö azi ölŋan mönö yaŋgöra keu ohoget ahözawaŋgö dop ölŋa gölme mosöta anmapmö, kunŋan i mamalolo mem waŋgimawi, yaŋgöra mönö Yei! jiba sahötzal. Miaŋgö likepŋi kanjamŋambuknöŋ mönö yaŋgö qakŋe öŋgöma. Azi mi nam körö uruŋeyök qahö asuhubawak, miaŋön mönö amqem waŋgibawak.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mewö jiiga Judas mamalolo mem waŋgimawaŋön kewö meleŋda jiyök, “Böhi, mi mönö nöŋgöra jibanbuk?” Jisösnöŋ kewö jii mörök, “Jizani, mönö mewö!” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nene nemba tata Jisösnöŋ beret memba kötuetköba mindipköba eŋgiba kewö jiyök, “Ki nani busuni. Ki memba neget.” ");
INSERT INTO bmu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mewö jiba wain qambi memba saiwap jiba eŋgiba kewö jiyök, “Iŋini körek qambi kiaŋgöreŋök neget. ");
INSERT INTO bmu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ki nani sepni. Mi Anutunöŋ ambazip yembuk jöhöjöhö areŋ aiga köhöimapköra sepni mokoget geiga ambazip gwötpuk yeŋgö siŋgisöndokŋini mosötma. ");
INSERT INTO bmu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nöŋön keu kun kewö jibi mötket: Nöŋön wain kösögö ölŋi ki kiaŋgöreŋ kunbuk toroqeba qahö nemam. Könaŋgep Iwinaŋgö bemtohoŋ uruŋe eu taringa közölömbuaŋ almawi, wehön miaŋgöreŋ mönö wain o qainŋi kun mia nemam.” ");
INSERT INTO bmu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mewö jiiga sösöŋgai liŋet köla mosöta anda Oil ip kunduŋe öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Öŋgöba Jisösnöŋ kewö jii mötket, “Kezapqetok azi kunöŋ keu kun kewö ohoi ahöza, ‘Nöŋön galömŋini qebiga lama kambuŋan deŋme.’ Miaŋgö dop eŋön körek suŋgem kiaŋgöreŋ uruŋini nöŋgöra aka böliiga nömosöta buratime. ");
INSERT INTO bmu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Buratigetka nuŋgumemö, nöŋön mönö kömupnöhök wahöta mutuk Galili prowinsnöŋ anda miaŋgöreŋ asuhum eŋgimam.” ");
INSERT INTO bmu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mewö jiiga Pitönöŋ meleŋda kewö jii mörök, “Yeŋön körek uruŋini göhöra aka böliiga gömosöta buratime ewö, nöŋön mönö töndup nalö kunöŋ qahö gömosötmam.” ");
INSERT INTO bmu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jiiga Jisösnöŋ jii mörök, “Nöŋön keu ölŋi kun kewö jibi mötnöŋ: Kuruknöŋ qahö qeriga göŋön merak suŋgem qaŋ köl niŋginöŋga indimŋi karöbut akŋa.” ");
INSERT INTO bmu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mewö jiyökmö, Pitönöŋ kewö jii mörök, “Böhi! Mewö qahöpmö, ni nuŋgugetka göbuk mohotŋe kömumbirak, mi töndup nöŋön gi qahö qaŋ köl gihimam.” Gwarek tosatŋi pakpak mewöyök keu miyöhök jiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mewö eraum möta anda yembuk arö kun qetŋi Gezemane miaŋgöreŋ aŋgotket. Aŋgota Jisösnöŋ gwarekurupŋi kewö jii mötket, “Nöŋön endu anda köuluköbiga iŋini ölöp nalö sutŋe ki nanŋinök tatme.” ");
INSERT INTO bmu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mewö jiba Pitö aka Zebedigö nahönyahötŋi yahöt etkuaŋgita angetka Jisösnöŋ könahiba wösöbirik möriga köŋjiliŋan köna böröŋi qeköyök. ");
INSERT INTO bmu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nalö miaŋgöreŋ kewö jii mötket, “Nöŋgö urunan mönö kondum köla kotzawaŋgöra aka wösöbirik mötpiga kömukömuŋi ak niŋgiza. Iŋini ölöp kiaŋgöreŋ tata nömbuk guli malbin.” ");
INSERT INTO bmu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mewö jiba nanŋök borom kun toroqeba anda simin köla sipköba kewö köuluköba jiyök, “Iwini, gi yuai kun qahö mölölömbizan. Miaŋgöra sihimgi ahöza ewö, sihimbölögö qambiŋi kiaŋön mönö nöŋgö qakne öŋgöbapuköra noaŋgitman. Noaŋgitman me qahö, mi mönö nangi jit keugahö dop asuhuma. Mi nöŋgö sihimgö dop qahö.” ");
INSERT INTO bmu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mewö jiba liliŋgöiga gwarekurupŋi karöbut yeŋön gaun ahöget eŋgeka Pitögö kewö jii mörök, “Iŋini aua mohot-töp nömbuk guli malbingö kude köhöize me? ");
INSERT INTO bmu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uruninan guli malbingö sihimŋi mörakzinmö, sileninan lölöwöröŋi akza. Miaŋgöra esapesapnöŋ et eŋgubapuköra mönö köuluköba guliguli malme.” ");
INSERT INTO bmu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mewö jii möriga kunbuk eŋgömosöta anda indimŋi yahöt aiga kewö köuluköba jiyök, “Iwini, sihimbölögö qambi kiaŋön qahö noŋgitma ewö, mi ölöp nemam-mö, mi mönö nangi jitkahö dop asuhuma.” ");
INSERT INTO bmu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Köuluköba liliŋgöiga jeŋini böŋböŋ meyöhaŋgöra kunbuk gaunök ahöget eŋgehök. ");
INSERT INTO bmu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kunbuk eŋgömosöta likep anda keu miyöhök kunbuk jiba köuluköiga indimŋi karöbut ahök. ");
INSERT INTO bmu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gwarek yeŋgöreŋ liliŋgöba kaba kewö jii mötket, “Iŋini toroqeba luhut memba gaunök ahöbingö mötze me? Mötket! Kunöŋ Suep gölmegö azi ölŋi mamalolo mem waŋgiiga bölöŋi meme yeŋgö böröŋine öŋgöma. Miaŋgö aua nalöŋan lök kam kuŋguza. ");
INSERT INTO bmu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mönö wahötketka anin! Mamalolo mem niŋgimawi, yaŋön mönö dowe ki kaza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisösnöŋ mewö jiba kiniga miaŋgöreŋ gwarekurupŋi 12 yeŋgöreŋök kun qetŋi Judas yaŋön kambu ketaŋi kun jitŋe mem eŋgiiga kaŋgotket. Jike nup galöm aka kantrigö jitŋememe yeŋön i melaim eŋgigetka bimgö sou ketaŋi aka liŋgipŋini memba kaget. ");
INSERT INTO bmu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mamalolo memamgö ahöhi, yaŋön mutuk yembuk aiwesök keu kewö jöhöba jii mötket, “Nöŋön azi numbuŋi yöhötim nemami, yaŋön mönö mia akza. Mönö i memba jöhöme.” ");
INSERT INTO bmu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mewö jiba kaba miaŋgöreŋök Jisösgöreŋ aŋgota “Böhi, bönjöŋ!” jiba numbuŋi yöhötim neyök. ");
INSERT INTO bmu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yöhötim neiga Jisösnöŋ kewö jii mörök, “Alani, gi wuanöŋgöra kazani, mi mönö zilaŋ akŋan.” Mewö jiiga azi kambu yeŋön Jisösgöreŋ kaŋgota qelanjiba memba jöhöget. ");
INSERT INTO bmu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jöhögetka Jisösbuk malgeri, yeŋgöreŋök kunŋan böröŋan bimgö sou ketaŋi öröba jike nup galöm bohonŋaŋgö welenqeqeŋi qeba kezapŋi köteköi erök. ");
INSERT INTO bmu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisösnöŋ mi eka kewö jii mörök, “Mönö mosötnöŋ! Bimgö sou ketaŋi körök memei, i mönö körek bimgö sou ketaŋan eŋgui kömume. Miaŋgöra mönö sougi kupinŋe qenöŋ geyök! ");
INSERT INTO bmu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nöŋön Iwini köuluköbiga ölöp bauköm niŋgimawi, mi mötzan me qahö? Köuluköm waŋgibileŋahi, yaŋön mönö miaŋgöreŋök garata yarö kambu 12 oŋgita melaim eŋgii kaba bauköm niŋgibeak. ");
INSERT INTO bmu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bauköm niŋgibeak ewö, Buŋa Kimbigö keuŋan mönö denöwö ölŋambuk akawak? Buŋa Kimbi keugö dop yuai kiaŋön mönö asuhumapkö dop jijiŋa akza.” ");
INSERT INTO bmu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nalö miaŋgŋöreŋök Jisösnöŋ yarö kambu yeŋgöra kewö jii mötket, “Ni kegwek-kahasililiŋ azia qahöpmö, töndup nöŋgöra mewö möta bimgö sou ketaŋi aka liŋgip memba nömemba jöhöbingöra kaŋgotze. Nöŋön wehön dop jöwöwöl jikenöŋ embuk tata kinda Buŋa keu kusum eŋgiba malbiga qahö nömiget. ");
INSERT INTO bmu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mewömö, yuai pakpak ki mönö kezapqetok ambazipnöŋ keu ohogeri, mieŋön ölŋinambuk akŋapköra asuhuza.” Jisös jöhögetka gwarek yeŋön körek Jisös mosöta buratiba unjurata anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yarö azi Jisös memba jöhögeri, yeŋön i waŋgita jike nup galöm bohonŋi qetŋi Kaiafas yaŋgö mire anget. Angetka Köna keugö böhi aka kantrigö jitŋememe yeŋön miaŋgöreŋ kaba tokoget. ");
INSERT INTO bmu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Angetka Pitönöŋ sikepsikep eŋguataŋgöba miaŋgöreŋ aŋgota jakömbuak mirigö kiripo uruŋe öŋgöyök. Öŋgöba teteköŋe denöwö asuhumawi, mi ekŋamgöra welenqeqe azi yeŋgö sutŋine tarök. ");
INSERT INTO bmu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mewö tarökmö, jike nup galöm aka jike kaunsöl kambu yeŋön Jisösgö silenöŋ alal keu denöwö möndöba naŋgöinga qeget kömumapkö jim jaruget. ");
INSERT INTO bmu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jaruba kinda gwötpukŋan wahöta kinda keu muneŋi Jisösgö sileŋe ala naŋgöba jigetmö, töndup könaŋi kun qahö miwikŋaiget. Qahö miwikŋaigetmö, teteköŋe azi yahöt kaŋgota ");
INSERT INTO bmu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kewö jiyöhot, “Azi kiaŋön kewö jiiga mörit, ‘Ni ölöp Anutugö jöwöwöl jikeŋi köndeŋbiga gölmenöŋ eriga wehön karöbutkö uruŋe mi kunbuk mem wahöta kuŋgumam.’” ");
INSERT INTO bmu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mewö jiyohotka jike nup galöm bohonŋan wahöta Jisös qesim waŋgiba kewö jiyök, “Yeŋön göhö silege keu ala naŋgözei, miaŋgö likepŋi kun jiman me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Qesim waŋgiiga Jisösnöŋ yuai bölöŋi kun qahö ahökmö, töndup keuŋi bök kinök. Keuŋi bök kiniga jike nup galöm bohonŋan kewö jii mörök, “Nöŋön Anutu malmal Toŋaŋgö qetŋe kewö qesiba kuŋgum gihizal: Gi Anutugö Nahönŋi Kraist akzan me qahö, mi törörök jiba jöjöpaŋ keunöŋ jim köhöinöŋga mötpin.” ");
INSERT INTO bmu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mewö jiiga kewö jiyök, “Jizani, mönö mia. Miamö, nöŋön körek eŋgöra kewö jibi mötket: Nalö kewöŋeyök könahiba Suep gölmegö azi ölŋan mönö Kukösum Toŋaŋgö böröŋi ölŋe tata suepkö kousu qakŋe eri ekŋe.” ");
INSERT INTO bmu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Keu mi jiiga jike nup galöm bohonŋan malukuŋi munjurata kewö jiyök, “Yei, iwinaŋgö jitŋi! Mönö Anutu mepaiköza. Tosatŋan keuŋi naŋgömegöra kunbuk qahö qesim eŋgibin. Anutu mepaiközawi, mi dölki nanŋinak möt teköze. ");
INSERT INTO bmu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Miaŋgöra denöwö mötmörize?” Mewö qesim eŋgiiga kewö jim teköget, “Yaŋön mönö kömupkö buŋaya akŋa.” ");
INSERT INTO bmu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mewö jim teköba jeŋe söutkölap söutköm miriba böröŋinan misiba mesoholŋe qekötahöget. Tosatŋan nuŋgulumŋe qekötahöba ");
INSERT INTO bmu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kewö jiget, “Gi kezapqetok azi Kraist akzanaŋgöra daŋön guhuzawi, mönö yaŋgö qetŋi qetnöŋ mörin.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mewö asuhuiga Pitönöŋ yaigep kiripo uruŋe sombemnöŋ tarök. Tari welenqeqe ambi kunŋan yaŋgöreŋ kaba kewö jiyök, “Gi mewöyök Galili azi Jisösbuk mohotŋe malnöŋ.” ");
INSERT INTO bmu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mewö jiyökmö, körek yeŋgö jeŋine qaŋ köla kewö jiyök, “Keu jizani, mi köndatzal.” ");
INSERT INTO bmu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mewö jiba kiripo naŋguŋe geiga welenqeqe ambi kunŋan i eka azi kösutŋe kingeri, mi kewö jii mötket, “Azi kiaŋön mönö mewöyök Nazaret azi Jisösbuk malök.” ");
INSERT INTO bmu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mewö jiiga kunbuk qaŋ köla jöjöpaŋ keunöŋ jim köhöiba kewö jiyök, “Nöŋön azi mi qahö möt waŋgizal.” ");
INSERT INTO bmu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nalö borom kun teköiga azi kösutŋe kingeri, yeŋön Pitögöreŋ kota kewö jiget mörök, “Alakŋa! Göŋön mewöyök yeŋgöreŋök kun akzan! Galili keu jöl jizani, miaŋön mönö mewöyök mi kondeliga mötzin.” ");
INSERT INTO bmu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mi möta könahiba nanŋi qesuahöm aŋguba jöjöpaŋ keunöŋ jim köhöiba jiyök, “Ni azi mi qahö möt waŋgizal! Muneŋ jibileŋak ewö, Anutunöŋ mönö likepŋi meleŋ niŋgima.” Mewö jiiga miaŋgöreŋök kuruk qerök. ");
INSERT INTO bmu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kuruk qeri möta Jisösnöŋ keu kewö jii möröhi, mi mötmöriyök, “Göŋön mutuk indimŋi karöbut qaŋ köl niŋginöŋga kuruknöŋ qetma.” Keu mi mötmöriba wösöŋi julmamgö aiga yaigep geba sahöt böliyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Miri giaŋiiga amandiŋe jike nup galöm pakpak aka kantrigö jitŋe meme (70) yeŋön tokoba Jisös qeget kömumapkö keuŋi eraum mötket. ");
INSERT INTO bmu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eraum mötket teköiga Jisös jöhöba waŋgita Rom premiö Pailötkö böröŋe alget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisös qeget kömumawaŋgö keuŋi jim tekögetka Judas mamalolo waŋgiyöhaŋön mi möta möt bölim aŋguba silwö moneŋ köt 30 waŋgigeri, mi memba jike nup galöm aka kantrigö jitŋememe yeŋgöreŋ anda meleŋda eŋgiba kewö jiyök, ");
INSERT INTO bmu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nöŋön siŋgisöndok aka azi köpösihitŋi qahö mi mamalolo mem waŋgibiga qeget kömuma.” Mewö jiyökmö, yeŋön jiget, “Mi neŋgöreŋ yuaia qahö! Mi mönö nangi manjara!” ");
INSERT INTO bmu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mewö jiget möta silwö moneŋ köt mi memba gil tipköiga jöwöwöl jike uruŋe anök. Aniga nanŋi mosöta anda imbi auyök. ");
INSERT INTO bmu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jike nup galöm bohonŋi yeŋön moneŋ köt mi memba kewö jiget, “Moneŋ ki mönö azi sepŋaŋgö bohonŋa. Miaŋgöra mi jöwöwöl jikegö moneŋ köwenöŋ albingö dopŋi qahö. Mewö aka Mosesgö Köna keu oŋgitpinbuk.” ");
INSERT INTO bmu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mewö jiba eraum möta moneŋ miaŋön gwakömnöŋ kimbut meme azi kungöreŋ gölme köröŋi kun bohonŋi megetka kian ambazip yeŋgö qaksiriŋina ahök. ");
INSERT INTO bmu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Miaŋgöra aka gölme köröŋi miaŋgö qetŋi mi nalö kewöŋe mewöyök toroqeba ‘Gölme köröŋi sepŋambuk,’ qerakze. ");
INSERT INTO bmu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kezapqetok azi Jeremaianöŋ keu qeljiŋe jiyöhi, miaŋön mönö ölŋambuk ahök. Keu mi kewö, “Yeŋön Israel könagesögö jitŋememeŋini aka azi mi söŋgöröŋi memegöra kewöta algetka silwö moneŋ köt 30 ahöhi, mi meget. Mi azigö bohonŋa. ");
INSERT INTO bmu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yeŋön mi memba miaŋön gwakömnöŋ kimbut meme azi kungöreŋ gölme köröŋi kun bohonŋi meget. Mi mönö Kembunöŋ jim kutum niŋgiyöhaŋgö dop mewö meget.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nalö miaŋgöreŋ Jisösnöŋ Pailötkö jeŋe kiniga kewö qesim waŋgiyök, “Ölŋa, gi Juda yeŋgö kiŋa akzan me qahö?” Qesim waŋgiiga Jisösnöŋ meleŋda jii mörök, “Mönö nangak jizani, mewö.” ");
INSERT INTO bmu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jike nup galöm aka kantrigö jitŋememe (70) yeŋön keu gwötpuk Jisösgö sileŋe ala jigetmö, töndup keu kitipŋi kun qahö meleŋnök. ");
INSERT INTO bmu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Keu bök kiniga Pailötnöŋ Jisös kunbuk qesim waŋgiba jiyök, “Mötnöŋ! Yeŋön keu gwötpuk göhö silege ala naŋgöba jizei, mi mötzan me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mewö jiyökmö, Jisösnöŋ bölöŋi kun qahö ahökmö, töndup keu mieŋgö likepŋi kun qahö meleŋnök. Keu bök kiniga premiönöŋ gwötpuk welipköyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Rom premiönöŋ yambu (yara) dop pasowa sösöŋgai nalöŋe kösö mireyök azi mohok sihimŋinaŋgö dop qetŋi qeta qesigeri, mi pösat eŋgizapma. ");
INSERT INTO bmu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nalö miaŋgöreŋ azi kun qetŋi Barabas qetkeri, yaŋön kösö mire tarök. I bölöŋamŋaŋgöra miwidimgögetka malök. ");
INSERT INTO bmu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mewö aiga tokogetka kewö qesim eŋgiyök, “Barabas me Jisös, qetŋi Kraist qerakzei, yetköreŋök niŋia pösat eŋgibi etmapköra mötze?” ");
INSERT INTO bmu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Galöm yeŋön Jisösgöra körögisigisi mötkeraŋgöra aka i premiögö böröŋe al waŋgiget. Mi möta sihimŋinaŋgö mewö qesim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mi mörökmö, jimtekötekögö jakömbuak dum tatatŋe tariga anömŋan buzup keu kun kewö ali kayök, “Ni merak suŋgem gaun kun eka miaŋgöreŋ azi miaŋgöra aka sihimbölö gwötpuk mötzal. Miaŋgöra azi solanŋi mi mönö lömböt kude waŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Keu mewö kayökmö, jike nup galöm aka kantrigö jitŋememe yeŋön ambazip kambu uruesiesi mem eŋgiba kewö jiget, “Mönö Barabas pösata Jisös maripomnöŋ qemegöra jiman. Mewö qesim waŋgime.” ");
INSERT INTO bmu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mewö jigetka premiönöŋ meleŋda qesim eŋgiyök, “Azi yahöt mietköreŋök mönö niŋia pösat eŋgibi etmapköra mötze?” Mewö qesim eŋgiiga “Barabas!” jiget. ");
INSERT INTO bmu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mewö jigetka Pailötnöŋ kewö qesim eŋgiyök, “Mewö jizeaŋgöra Jisös, qetŋi Kraist qerakzei, nöŋön i mönö denöwö ak waŋgibileŋak?” Mewö qesim eŋgiiga yeŋön körek qetket, “Mönö maripomnöŋ qeget jiman!” ");
INSERT INTO bmu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mewö qetketka premiönöŋ jiyök, “Mi wuanöŋgöra? Yaŋön mönö wani bölöŋa ahök?” Mewö jiyökmö, yeŋön mi möta kapaŋ köla toroqeba qet gigilahöba kewö qetket, “Mönö maripomnöŋ qeget jiman!” ");
INSERT INTO bmu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mewö qetketka kezap-ölök aketka göjupmajupnöŋ kunbuk qariiga Pailötnöŋ mi eka möta bim karim asuhubapuköra o memba böröŋi ambazip kambu jeŋine saŋgoŋda kewö jiyök, “Azi kiaŋgö sepŋi mokoget gemawi, miaŋön mönö nöŋgö qakne qahöpmö, mönö nanŋini qakŋine öŋgöma.” ");
INSERT INTO bmu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mewö jiiga ambazip kambu körek pakpak yeŋön kewö meleŋget, “Sepŋaŋgö likepŋan mönö nini aka nahönböratnini neŋgö qaknine öŋgöma!” ");
INSERT INTO bmu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mewö meleŋgetka Pailötnöŋ Barabas pösat eŋgii erökmö, Jisösya jiiga ihilek wahiŋambuknöŋ qeyöyaköba qeget. Mewö qegetka maripomnöŋ qemegöra Rom yarö azi yeŋgö böröŋine alök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Böröŋine aliga Rom premiögö yarö azi yeŋön Jisös waŋgita premiögö jakömbuak mirigö kiripo uruŋe aŋgotket. Aŋgota yarö kambu lökŋanök öröm eŋgigetka kaba tokoba Jisös liliköm waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Liliköm waŋgiba nanŋi sile esuŋi köteköba maluku pisikŋi gugakgugak kun löŋgöt waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Löŋgöt waŋgiba sötman kösö limbiŋda ila ewö nöröpŋe kölget geyök. Geiga jehot kun böröŋi ölŋe ala simin köl waŋgiba göngönahit ak waŋgiba kewö jiget, “Owe owe, Juda yeŋgöreŋ kiŋ, owe!” ");
INSERT INTO bmu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Titipepe mewö aka söutkölap qeba jehot öröpŋi waŋgita miaŋön nöröpŋe qeget. ");
INSERT INTO bmu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mepaqepaik mewö ak waŋgim teköba maluku pisikŋi gugakgugak mi qeköba nanŋe sile esu kunbuk löŋgöt waŋgiba maripomnöŋ qebingöra waŋgita anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Anda köna namŋe azi kun qetŋi Saimon miwikŋaiget. Yaŋön Afrika siti qetŋi Sairini miaŋgö aziŋa. Miwikŋaiba kuŋgum waŋgigetka Jisösgö maripomŋi memba aŋguyök. ");
INSERT INTO bmu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jisös mewö waŋgita gölme kun qetŋi Golgota mi nanine keunöŋ Nöröpsihit, miaŋgöreŋ anda aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aŋgota wain o aka marasin qetŋi mör mi mindiriba loloŋqaloŋ memba nemapköra waŋgigetmö, Jisösnöŋ mi esapköba nemba möta tököyök. ");
INSERT INTO bmu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tököiga kinda maripomnöŋ qeget. Qeget kiniga kiawen meget qötöŋi ahuiga miaŋgö dop Jisösgö sile esuŋi sutŋine mendeŋda meget. ");
INSERT INTO bmu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mi memba tata Jisös jegalöm ak waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nöröpŋe eu qegeraŋgö könaŋi kewö ohoba qeget, ‘Juda yeŋgö kiŋ kembuŋina ki.’ ");
INSERT INTO bmu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kegwek-kahasililiŋ azi yahöt mi yambuk maripomnöŋ etkuget. Kun böröŋi ölŋe, kun qaniŋe likeplikep mewö etkuget. ");
INSERT INTO bmu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ambazip oŋgita anda kaba kukulömbuaŋ aka jelikit aka nöröp köla kewö jiget, ");
INSERT INTO bmu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yei! Gi mönö jöwöwöl jike ölöp köndeŋnöŋga gölmenöŋ eriga wehön karöbutkö uruŋe kunbuk mem wahöt kuŋgumamgö jinöŋ. O, gi azi qetpuk! Gi Anutugö Nahönŋa akzan ewö, mönö ölöp nangi bauköm aŋguba maripomnöhök etman.” ");
INSERT INTO bmu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jike nup galöm, Köna keugö böhi aka kantrigö jitŋememe yeŋön mewöyök mepaqepaik ak waŋgiba kewö jiget, ");
INSERT INTO bmu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tosatŋa bauköm eŋgiba malökmö, nanŋi bauköm aŋgumamgö osiza. Yaŋön Israelgö kiŋ akza ewö, mönö dölki maripomnöhök eri eka mi möt naribinak. ");
INSERT INTO bmu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yaŋön Anutu möt narim waŋgiba ewebibiŋambuk mala nanŋaŋgöra ‘Anutugö Nahönŋi akzal’ jiiga mörin. Ayop, Anutunöŋ i nalö kewöŋe meköm waŋgimamgö mötza me qahöwi, mi ölöp ekin.” Mewö jiget. ");
INSERT INTO bmu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kegwek-kahasililiŋ azi yambuk maripomnöŋ etkugeri, yetkön mewöŋanök uruqeqe keu töhöreŋ jim waŋgiyohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Silim bibiŋi 12 kilok aiga miaŋgöreŋök söŋaupnöŋ eta gölme pakpak dop köla ahöiga anda aua karöbutkö dop ahök. ");
INSERT INTO bmu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jisösnöŋ 3 kilok miaŋgöreŋ nanŋe keunöŋ kewö qet ketaŋi qerök, “Eloi, eloi, lama sabaktani?” Mi nanine keunöŋ: Anutuni, Anutuni, mönö wuanöŋgöra andö nuŋguzan? ");
INSERT INTO bmu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mewö qeriga azi kösutŋe kingeri, yeŋgöreŋök tosatŋan mi möta jiget, “Mönö Elaijagöra qetza.” ");
INSERT INTO bmu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Miaŋgöreŋök yeŋgöreŋök kunŋan ösumŋan anda mömöndö kun kahali tandök mi memba wain o asölŋambuknöŋ kundumgöba ip göröm kitipŋe jöhöba suruba Jisös numbuŋe eu ali neyök. ");
INSERT INTO bmu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Neyökmö, tosatŋan jiget, “Mönö mosötketka nanŋök kinök. Elaijanöŋ kaba meköi etma me qahöpto, mönö mi ekin.” ");
INSERT INTO bmu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mewö aketka Jisösnöŋ kunbuk qet ketaŋi qeta söŋgörö ösum kondikŋi öröba kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kömuiga miaŋgöreŋök jöwöwöl jikegö uruŋe opo kinöhi, miaŋön euyök bibiŋe jurata eta yahöt ahök. Mewö eriga gölmenöŋ kenöŋ ketaŋan meiga köt ketaŋi ketaŋi mesiŋnök. ");
INSERT INTO bmu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Qaksirigö köt köteŋi mieŋgö numbuŋinan nanŋök aŋaŋigetka ambazipŋi sarakŋi kömugeri, yeŋgöreŋök gwötpukŋan guliba wahötket. ");
INSERT INTO bmu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wahöta qaksirigö köt köteŋini mosöta Jisösnöŋ kömupnöhök wahöröhi, miaŋgö andöŋe Jerusalem siti töröŋi miaŋgöreŋ kaba ambazip gwötpuk asuhum eŋgigetka eŋgeget. ");
INSERT INTO bmu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Suahö galöm aka yarö azi yambuk Jisösgö jegalöm memba malgeri, yeŋön kenöŋ meiga yuai tosatŋi pakpak asuhuyöhi, mi eka auruba jönömŋini gwötpuk unduiga keŋgötporiŋ aka kewö jiget, “Yaŋön mönö ölŋa Anutugö Nahönŋa akza.” ");
INSERT INTO bmu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ambi gwötpukŋan sikep kinda yuai mi mewöyök eket. Yeŋön Jisös wuataŋgöba Galiliyök kaba welen qem waŋgiba malget. ");
INSERT INTO bmu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yeŋgö sutŋine Magdalagö Maria aka Maria Jeims aka Joses yetkö namŋiri aka Zebedigö nahönyahöt yetkö namŋiri. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mare aiga Arimatia azi pomŋi kun qetŋi Josef kayök. Yaŋön mewöyök Jisösgö gwarekŋi kun ahök. ");
INSERT INTO bmu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yaŋön Pailötgöreŋ anda Jisösgö qamötŋi memamgö qesiyök. Qesiiga suahö azinöŋ mi Josef waŋgimegö jim kutum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jim kutum eŋgiiga Josefnöŋ anda Jisösgö qamötŋi memba eta opo tuatŋan esuhuyök. ");
INSERT INTO bmu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Esuhuba memba qaksirinöŋ anda nanŋi köteŋ dölökŋi kötnöŋ urorohogetka kinöhi, qamötŋi mi miaŋgöreŋ alök. Mewö ala köt ketaŋi kun metaliga köteŋ numbuŋi közipköiga mosöta anök. ");
INSERT INTO bmu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdalagö Maria aka Maria alaŋi kun yetkön miaŋgöreŋ köt köteŋ mesohol köla tarohot. ");
INSERT INTO bmu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabat kendon tatatköra yuai mözözömgöba ahöba wahöta miaŋgöreŋ jike nup galöm aka Farisi (Köna keugö kapaŋkölköl) yeŋön Pailötköreŋ anda tokoba kewö jiget, ");
INSERT INTO bmu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ketaŋamnini, eŋololoŋgö urukuŋgukuŋgu azi miaŋön jebuk malöhi, nalö miaŋgöreŋ kewö jii mörin, ‘Nöŋön wehön karöbut teköiga kunbuk guliba wahötmam.’ Neŋön keu mi mötmörizin. ");
INSERT INTO bmu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Miaŋgöra göŋön ölöp yarö aziurupki jinöŋ möta qaksirinöŋ anda mi törörök jegalöm memba malgetka wehön karöbut teköiga mosötme. Mewö qahö galöm membeak ewö, gwarekurupŋan mönö anda qamötŋi ölöŋ memba asamböta ambazip kewö jiget mötpeak, ‘Jisösnöŋ mönö kömupnöhök wahörök.’ Mewö jigetka tilipqilip eŋololoŋ keu kondikŋi kiaŋön mönö eŋololoŋ keu mutukŋi oŋgiriga böliqölibapuk.” ");
INSERT INTO bmu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mewö jigetka kewö jii mötket, “Yarö azi ki mönö ölöp eŋguaŋgita anda al eŋgigetka qaksiri köteŋ numbuŋi mi törörök galöm köl soroköme.” ");
INSERT INTO bmu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mewö jii möta qaksirinöŋ anda köt köteŋaŋgö numbuŋe köt ketaŋi algetka közipköba kinöhi, mi supapŋi ala yarö azi al eŋgigetka jegalöm köhöikŋi meget. ");
INSERT INTO bmu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat kendon tatket teköiga Sonda söŋanök wahöta miri giaŋiiga Magdalagö Maria aka alaŋi Maria kun yetkön qaksirigö köt köteŋ ekitkö anohot. ");
INSERT INTO bmu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Anohotka miaŋgöreŋök kenöŋ ketaŋi kewögöra meyök: Kembugö garata kunöŋ Suepnöhök eta qaksirinöŋ kaba numbuŋe köt ketaŋi qetali ani qakŋe tarök. ");
INSERT INTO bmu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Garatagö kaisoŋgolomŋi mi wöl ewö aiga malukuŋi mi kousu ewö tuat lalamŋi ahök. ");
INSERT INTO bmu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mewö asuhuiga yarö azi qaksiri galöm megeri, yeŋön yaŋgöra awöwöliba jönömŋini undui kömum töriget. ");
INSERT INTO bmu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mewö aketka garatanöŋ ambi yahöt yetköra keu kewö jiyök, “Jisös maripomnöŋ qegeri, iŋiri yaŋgöra jaruzahot, mi mötzal. Miaŋgöra mönö keŋgötŋiri kude mötmahot. ");
INSERT INTO bmu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nanŋak jiyöhaŋgö dop mönö kömupnöhök wahötza. Miaŋgöra ki qahö ahöza. Mönö kaba dum ahöyöhi, salupŋi mi ekŋahot. ");
INSERT INTO bmu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“Mi eka ösumok gwarekurupŋi yeŋgöreŋ anda buzup keu ki jiyohot mötme, Jisösnöŋ kömupnöhök wahötza. Mötket, yaŋön mönö qeljiŋe mutuk Galili prowinsnöŋ anma. Iŋini ölöp miaŋgöreŋ anda i ekŋe. Mötket, nöŋön mi lök jibi mötze.” ");
INSERT INTO bmu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mewö jiiga zilaŋök qaksiri mosöta keŋgötŋiri möta töndup önöŋi qahö söŋgaiba buzup mi memba gwarekurupŋi jiyohot mötmegöra ösumŋiran anohot. ");
INSERT INTO bmu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ösumŋiran anohotka Jisösnöŋ i könanöŋ asuhum etkiba “Söŋanŋiri!” jiyök. Mewö jiiga kösutŋe anda sipköba könaŋe meraköba waikŋi memba möpöseim waŋgiyohot. ");
INSERT INTO bmu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Möpöseim waŋgiyohotka kewö jii mörohot, “Keŋgötŋiri kude mötmahot. Mönö anda munurupnan Galili anmegö keu jiyohotka miaŋgöreŋ anda ni nekŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ambiyahöt yetkön köna anohotka qaksirigö köt köteŋ galöm meme yarö azi tosatŋan sitinöŋ kaba jike nup galöm eŋgeka yuai pakpak asuhuyöhi, miaŋgö kösohotŋi jiget mötket. ");
INSERT INTO bmu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yeŋön mi möta Juda yeŋgö jitŋememeurupŋini öröm eŋgigetka mohotŋe totoko ala Jisös wahötwahötkö keu asambötpingö keu areŋ miwikŋaiba moneŋ keta bölökŋi mi yarö azi eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Mi eŋgiba kewö jim kutum eŋgiget, “Iŋini mönö keu kewö jime: Nini suŋgem gaun ahöinga gwarekurupŋan ölöŋ kaba qamötŋi yoŋgorö memba anget. ");
INSERT INTO bmu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Keu mewö jigetka keu miaŋön premiögö kezapŋe gei mötma ewö, lömböt eŋgö qakŋine öŋgöbapuköra neŋön mönö uruŋi mölöwöriba memba eta alinga waimanjat qahö malme.” ");
INSERT INTO bmu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mewö jim kutum eŋgigetka miaŋgö dop aka moneŋ memba anda nup keuŋini wuataŋgöget. Mewö aketka Juda yeŋön keu mi sutŋine jim sehigetka möta malgetka anda nalö kewöŋe mewöyök mi toroqeba jiget mörakzin. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Gwarekurup 11 yeŋön Jerusalem mosöta Galili prowinsnöŋ anda Jisösnöŋ kunduŋe anmegöra jiyöhi, miaŋgöreŋ öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Miaŋgöreŋ öŋgöba Jisös eka waikŋi memba möpöseim waŋgigetmö, tosatŋan yaŋgöra uruyahöt aket. ");
INSERT INTO bmu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Möpöseim waŋgigetka yeŋgöreŋ kaba kewö jiiga mötket, “Suepkö aka gölmegö kukösum pakpak mi Anutunöŋ niŋgiiga nöŋgöreŋ ahöza. ");
INSERT INTO bmu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","“Miaŋgöra iŋini mönö gölme dop anda ambazip kambu pakpak kewö eŋgömegetka nöŋgö gwarekurupni akŋe: I mönö Iwi, Nahön aka Uŋa Töröŋi neŋgö qetnine o melun mem eŋgime ");
INSERT INTO bmu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","aka nöŋön keu wuataŋgömegöra jim kutum eŋgiali, mi pakpak tem kölmegöra mönö kusum eŋgiba malme. Mötket, nöŋön mönö nalöŋi nalöŋi embuk mala anda malbiga gölmegö nalöŋan teköma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Amötqeqe Toŋi Jisös Kraist mi Anutugö Nahönŋi akza. Nöŋön yaŋgö Ölöwak Buŋaŋi könahiba ohozal. ");
INSERT INTO bmu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anutunöŋ Suep uruŋe Nahönŋaŋgöra keu kun jiiga kezapqetok azi Aisaianöŋ mi ohoiga yaŋgö Buzup Kimbinöŋ kewö ahöza, “Mötnöŋ. Nöŋön kolek garatani kun melaibiga qeljiŋe anda ambazip uruŋini mindiŋgöba göhö könagi mesariga göŋön yaŋgö andöŋe gölmenöŋ geman.” ");
INSERT INTO bmu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Kolek garata kunöŋ gölme qararaŋkölkölŋe qeta maliga anda qetŋi kewö mötme, ‘Kembunöŋ kamawo! Miaŋgöra mönö jöjöröba könaŋi mesatket. Mönö uruŋini mindiŋgöba könaŋi qölöleiget’.” ");
INSERT INTO bmu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Keu miaŋgö dop azi kun qetŋi Jon asuhuyök. Qetŋi alaŋi O-melun azi. Asuhuba gölme qararaŋkölkölŋe mala kinda Buŋa keuŋi kewö jiba malök, “Iŋini mönö uruŋini meleŋgetka nöŋön o melun mem eŋgimam. Mewö aketka Anutunöŋ siŋgisöndokŋini saŋgoŋda mosötma.” ");
INSERT INTO bmu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mewö jiba maliga Judia prowinsgö miriŋi pakpak aka Jerusalem siti yeŋön kambuŋi kambuŋi köla öröba Jongöreŋ kaget. Kaba kaŋgota siŋgisöndokŋini jim miwikŋaigetka Jonöŋ i Jordan o töwatŋe o-melun mem eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jongöreŋ silepöke mi kamel jupŋan memeŋi aiga kembaŋe örigit sömbup sileŋan memeŋi mi jöhöba malök. Neneŋamŋi mi gawöt jinam aka arökŋaŋgö moroŋ oŋi, mia nemba malök. Mi pakpak kezapqetok azi Elaija (Elia) yaŋgö dowa. ");
INSERT INTO bmu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jonöŋ keu kewö jim asariba malök, “Nöŋgö andöne azi kukösumŋi köhöikŋi kun kama. Yaŋgö kukösumŋi öŋgöŋgöŋan mönö nöŋgöreŋ oŋgitma. Yaŋön azi öŋgöŋgöŋi akŋawaŋgöra nöŋön yaŋgö köna esuŋaŋgö kösöŋi bauköba pösatmamgö qötötaŋgömam. ");
INSERT INTO bmu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nöŋön o töhönöŋ melun mem eŋgizalmö, yaŋön mönö Uŋa Töröŋan melun mem eŋgima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nalö miaŋgöreŋ Jisösnöŋ Galili prowinsgö miri Nazaret miaŋgöreŋök Jongöreŋ kaiga Jordan o töwatŋe o-melun mem waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mem waŋgiiga onöhök koriga miaŋgöreŋök Suepnöŋ aŋaŋiiga Jisösnöŋ uba ehiga Uŋa Töröŋi meleŋda kembö nei ewö aka Jisösgö qakŋe eta meöyk. ");
INSERT INTO bmu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mi ehiga Suep mireyök keu kun kewö asuhuyök, “Göŋön mönö nani wölböt nahöni aknöŋga köröni ölöwahiga geknahöm ak gihizal.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","O melun mem waŋgiiga miaŋgöreŋök Uŋa Töröŋan Jisös kuŋgum waŋgiiga gölme qararaŋkölkölŋe anök. ");
INSERT INTO bmu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anda wehön 40 miaŋgö dop miaŋgöreŋ maliga öme bohonŋini Satan yaŋön esapköm waŋgiba malök. Sömbup kalŋi mieŋgö sutŋine maliga Suep garata yeŋön bauköm waŋgiba malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Könaŋgep Jon kösö mire alget tariga Jisösnöŋ nalö miaŋgöreŋ Galili prowinsnöŋ liliŋgöba anök. Anda Anutugö Ölöwak Buŋaŋi jim asariba malök. ");
INSERT INTO bmu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jim asariba kewö jiyök, “Anutunöŋ bemtohoŋi almawaŋgö nalöŋan mönö dopdowiza. Anutunöŋ nalö aliga mala malgetka dölki akza miaŋgöra mönö uruŋini meleŋda Ölöwak Buŋa möt nariget.” ");
INSERT INTO bmu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisösnöŋ mewö jiba liliköba mala Galili o aŋgögö göraŋe mötöteiba anda söra örörö azi yahöt ekehök. Qetŋiri Saimon, munŋi qetŋi Andru. Yekŋön mösakŋiri o aŋgönöŋ söra öröbitköra gila malohot. ");
INSERT INTO bmu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisösnöŋ etkeka kewö jiyök, “Aziyahöt, iŋiri mönö ni nuataŋgöba kayöhotka kusum etkibi ambazip söra ewö öröm eŋgimakŋahot.” ");
INSERT INTO bmu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mewö jiiga miaŋgöreŋök mösakŋiri mosöta könahiba Jisös wuataŋgöba anöhot. ");
INSERT INTO bmu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jisösnöŋ yetpuk borom kun toroqeba anda Zebedigö nahönŋi Jeims aka munŋi Jon ekehök. Yetkön mewöŋanök waŋgenöŋ tata mösakŋiri möhamgöba jöhöba malohot. ");
INSERT INTO bmu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Malohot ekeka miaŋgöreŋök etkoholök. Etkoholiga iwiŋiri Zebedi aka moneŋ nup aziurupŋi waŋgenöŋ eŋgömosöta könahiba Jisös wuataŋgöba andöŋe anohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mewö mohotŋe anda Kaperneam sitinöŋ aŋgotketka Sabat kendon aiga Jisösnöŋ miaŋgöreŋök köuluk miriŋine öŋgöba Buŋa kusum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Köna keugö böhi ewö qahöpmö, kukösum ahöm waŋgiyöhaŋgö dop kusum eŋgiba ahakmemeŋaŋgö dop akŋegöra jiyök. Miaŋgöra könagesö yeŋön mi eka auruba welipköget. ");
INSERT INTO bmu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Köuluk miriŋine miaŋgöreŋ nalö miaŋgöreŋök azi kun ömeŋambuk tariga öme miaŋön qetŋi kewö qerök, ");
INSERT INTO bmu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O Jisös, Nazaret azia! Gi wania ak neŋgimamgö akzane? Mönö ayuhum neŋgimamgöra kazan me? Ni könaŋamgi möt kutuzal. Gi Anutugöreŋ azi Tök-kutukutuŋi mi akzan.” ");
INSERT INTO bmu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mewö qeriga Jisösnöŋ tembula kewö jim waŋgiyök, “Gi mönö keugi bököiga azi ki mosöta kesalnöŋ.” ");
INSERT INTO bmu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mewö jim waŋgiiga ömenöŋ azi mi utuköba urepköm waŋgiba qet bölöbölö qeta kota mosöta anök. ");
INSERT INTO bmu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aniga körekŋan nemböŋini teköiga welipköba qesim aŋguba kewö jiget, “Yei! Ki mönö wani yuaia? Ki mötmöt dölökŋi kukösumŋambuk. Yaŋön ömewöröme mewöyök jim kutum eŋgiiga jitŋi tem kölje.” ");
INSERT INTO bmu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mewö asuhuiga Jisösgö qetbuŋaŋan könöpuk sehiba miri kösutŋe tat angeri, miaŋgöreŋ anda anda Galili prowins pakpak dop kölök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisösnöŋ Kaperneam yeŋgöreŋ köuluk miri mosöta miaŋgöreŋök Jeims Jon yetpuk Saimon aka Andru yetkö mire öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Miaŋgöreŋ öŋgögetka Saimongö suhunŋan silekönöp kawöl yöhöi ahöyök. Ahöiga buzupŋi mi ösumok Jisös jiget mörök. ");
INSERT INTO bmu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jiget möta yaŋgöreŋ anda böröŋe memba kököbiiga wahörök. Wahöriga silekönöpŋan mosöriga nene ohoba gumohom eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gumohom eŋgiiga mare aiga wehön jeŋi geiga miaŋgöreŋ Kaperneam toŋi yeŋön kinda ambazipŋi ambazipŋi kawöl ömeŋinambuk mi körek eŋguaŋgita Jisösgöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaperneam taonöhök kambulelembenöŋ kaba Saimongö miri naŋguŋe tokoget. ");
INSERT INTO bmu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tokogetka kinda ambazip kawöl könaŋi könaŋi eŋgöhöyöhi, mi gwötpuk mem ölöwak eŋgiyök. Mewöyök ömewöröme yeŋön Jisösgö könaŋi mötkeraŋgöra Jisösnöŋ numbuŋini muhungöba gwötpuk eŋguataŋgöyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jisösnöŋ gaun ahöiga miri waŋgaraŋ suruiga wahöta miri yaigepŋe geba göraŋe anda nanŋök tiŋ kutuba miaŋgöreŋ köuluköyök. ");
INSERT INTO bmu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Köuluköiga Saimon aka alaurupŋi yambuk malgeri, yeŋön zilaŋ könaŋe anget. ");
INSERT INTO bmu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Anda miwikŋaiba kewö jiget mörök, “Ambazip körekŋan mönö göhöra jaruze.” ");
INSERT INTO bmu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mewö jigetka möta kewö jiyök, “Miri tosatŋi tosatŋi liliköba tat anjei, ekze. Nöŋön Buŋa keu miri dop jim sehimamgöra eta maljal. Miaŋgöra mönö miri liliköba anbin.” ");
INSERT INTO bmu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mewö jiba anda Galili prowins körek liliköba köuluk miriŋine Buŋa keu jiba ömeŋi ömeŋi mi eŋguataŋgöba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jisösnöŋ taon kunöŋ maliga uzikuku azi kunŋan kaba simin köla Jisösgö wösöŋe geba kewö köuluköm waŋgiyök, “Göŋön sihimgan mem ölöwak niŋgimamgö mötzan ewö, mönö ni ölöp mem solanim niŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mewö jiiga yaŋgöra wösöŋi möta böröŋi böraŋda sileŋi misiriba jiyök, “Nöŋön mi akŋamgö mötzal. Gi mönö solaniman.” ");
INSERT INTO bmu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mewö jiiga uzikukuŋi mi miaŋgöreŋök solanii ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Solaniiga galöm meme keu köhöikŋi waŋgiba miaŋgöreŋök “Ölöp anman,” jiyök. ");
INSERT INTO bmu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Goro mi kewö jiiga mörök, “Mötnöŋ. Kiaŋgö buzup keuŋi mi kun kude jinöŋ mötme. Qahöpmö, mönö jike nup galömgöreŋ anda silegi kondel waŋgiman aka Mosesgöreŋ jimkutukutu wuataŋgöba solanizanaŋgö saiwap nalukŋi ala jöwöwöl ohoman. Mi ohonöŋ ehiga ambazipnöŋ könaŋamgi möt kutume.” ");
INSERT INTO bmu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jisösnöŋ mewö jiyökmö, yaŋön anda töndup könahiba keu buzupŋi mi gwötpuk jiba maliga sehiyök. Sehiiga Jisösnöŋ taonŋi taonŋi miaŋgöreŋ aukŋe kunbuk anmamgö osiyök. Osiba taon andöŋine miri gwamönŋi miaŋgöreŋök malök. Miaŋgöreŋ maliga miri dop miaŋgöreŋök ambazipŋi ambazipŋi mi yaŋgöreŋ kaget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mewö liliköiga nalö tosatŋi teköiga Jisösnöŋ liliŋgöba kunbuk miriŋe Kaperneam kayök. Kaiga “Mire malja,” jiget mötket. ");
INSERT INTO bmu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ambazip gwötpukŋan mi möta tokoba yaŋgö miri naŋgu söndakŋe gwözöŋda sombemŋe kokolak qeget. Kokolak qegetka Jisösnöŋ kinda Buŋa keu jiiga mötket. ");
INSERT INTO bmu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mötketka miaŋgöreŋ azi kun sile likepŋi kömukömuŋi, mi waŋgita yaŋgöreŋ kaget. Azi 4:ŋan i kululunöŋ ala aŋguba kaget. ");
INSERT INTO bmu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kagetka gwözöŋda kingeraŋgöra aka Jisösgö kösutŋe anda albingö osiget. Osiba miri qakŋe öŋgöba Jisösgö bohonŋeyök bo esim luluŋget. Luluŋgetka kinimŋi ahuiga miaŋgöreŋ kawöl azi mi kululuŋambuk kösönöŋ jöhöba algetka geiyök. ");
INSERT INTO bmu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mewö geiga Anutu möt narim waŋgigeri, Jisösnöŋ yeŋgö tandökŋini mi ehi dop köliga kawöl azigöra kewö jiyök, “Nahöni! Nöŋön siŋgisöndoki mosötzal.” ");
INSERT INTO bmu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mewö jiiga Köna keugö böhi tosatŋan sutŋine tata uruŋinan kewö mötmöriget, ");
INSERT INTO bmu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Azi kiaŋön denöwögöra mewö jiza. Mönö Anutu ilita mepaqepaik akza. Anutu mohotŋan siŋgisöndoknini mosörakzapmö, azi kunŋan mi qahö.” ");
INSERT INTO bmu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Uruŋinan mewö mötmörigetka Jisösnöŋ miaŋgöreŋök uruŋan mi möt kutuba kewö jii mötket, “Iŋini mönö wuanöŋgöra keu mewöŋi uruŋinan mötmörize? ");
INSERT INTO bmu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nöŋön ‘Siŋgisöndoki mosötzal,’ kawöl azigö mewö jizali, keu miaŋön mönö awamŋanök jijiŋa. Kunŋan mewö jiiga tosatŋan keu miaŋgö ölŋi qahö ekŋe. Miaŋgöra mi keu awamŋaŋgö dop. Nöŋön keu kun kewö jimamgö mötzal, ‘Mönö wahöta tumbulahöpki memba anöŋ.’ Keu mi mönö lömbötŋambuk jijiŋa akza. Mewö jibiga ölŋi ahuma me qahöwi, miaŋön mönö aukŋe asuhui ekŋe. ");
INSERT INTO bmu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mötket, gölmenöŋ siŋgisöndok mosötmosötkö kukösumŋi mi Suep gölmegö azi ölŋaŋgöreŋ ahözawi, iŋini miaŋgö könaŋaŋgöra janjuŋ malbepuk. Miaŋgöra keu lömbötŋi mi azi kiaŋgöra jibi ölŋi eket,” Mewö jiba azi sile likepŋi kömukömuŋaŋgö jeŋe eka jiyök, “Nöŋön göhöra jizal: Gi mönö wahöta tumbulahöpki memba mirige anöŋ. Keu lömbötŋi mi ölŋambuk akŋa ewö, keu awamŋi mi mönö mewöyök denöwögöra omaŋi akawak?” ");
INSERT INTO bmu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mewö jiba azi sile likepŋi kömukömuŋi kewö jii mörök, “Nöŋön göhöra jizal: Gi mönö wahöta tumbulahöpki memba mirige anöŋ.” ");
INSERT INTO bmu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jiiga mönö wahöta miaŋgöreŋök tumbulahöpŋi memba ambazip pakpak yeŋgö jeŋine yaigepŋe anök. Mewö aniga körekŋan welipköba Anutu möpöseiba kewö jiget, “Yei! Tandök kewöŋi mi mönöwök nalö kungen qahö ehin. Qahö. Dölki je murutŋa ekzin.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisösnöŋ kunbuk Kaperneam mosöta aŋgönöŋ geba sak qöhöröŋe anda malök. Maliga ambazip kambulelembenöŋ yaŋgöreŋ kagetka Buŋa keu kusum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anda takis ofis oŋgitmamgö aiga miaŋgöreŋ azi qetŋi Liwai Alfiusgö nahönŋi tariga eka jii mörök, “Gi mönö nöŋgö andöne kanöŋ.” Mewö jiiga möta wahöta takis nup mosöta Jisösgö andöŋe anök. ");
INSERT INTO bmu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Anda Liwaigö mire anda nene nemba tatkeri, nalö miaŋgöreŋ takis meme azi tilipqilipŋinambuk aka siŋgisöndok azi gwötpukŋan kaba Jisös aka yaŋgö gwarekurupŋi yembuk tata nene mohokŋe neget. Gwötpukŋan mönö Jisös wuataŋgöba malget. ");
INSERT INTO bmu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jisösnöŋ takis meme tilipqilipŋinambuk aka siŋgisöndok ambazip tosatŋi yembuk tata nene negeri, mi Farisi (Köna keugö kapaŋkölköl) aka yeŋgöreŋ böhi tosatŋan eka Jisösgö gwarekurupŋi kewö jim eŋgiget, “Aek! Yaŋön mönö wuanöŋgöra takis meme tilipqilipŋinambuk aka siŋgisöndok ambazip yembuk tata nene neza? Mi qahö dop kölja.” ");
INSERT INTO bmu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mewö jim eŋgigetka Jisösnöŋ likepŋi kewö jii mötket, “Sile unditundit ambazipnöŋ doktagöra qahö ak eŋgimakzapmö, kawöl ambazipnöŋ doktagöreŋ anakze. Nöŋön siŋgisöndok ambazip eŋgoholmamgöra kaba maljalmö, ambazip nanŋinaŋgö mötketka solanŋi akzei, i qahö.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nalö miaŋgöreŋ Jongöreŋ gwarekurupŋi aka Farisi (Köna keugö kapaŋkölköl) yeŋön nene siŋgi malgetka tosatŋan Jisösgöreŋ kaba kewö qesiget, “Jon O-melun azigö gwarekurupŋi neŋön Anutugöra nene siŋgi malahakzin. Farisi (Köna keugö kapaŋkölköl) yeŋgö gwarekurupŋinan mewöŋanök aka malje. Nangi gwarekurupkan mönö wuanöŋgöra Anutugöra siŋgi qahö malje?” ");
INSERT INTO bmu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mewö qesigetka kewö meleŋnök, “Ölŋa! Nini wani nalönöŋ nene siŋgi malakzin? Ambi meme nalöŋe azigö andöurupŋan könöpŋi algetka ambigö sepkitipurupŋan yuai mi tökömakze me qahö? Nöŋön nani gwarekurupni yeŋgö azi buŋaya aka yeŋgö sutŋine köisirik tatzal. Tatpiga yeŋön miaŋgöra aijölöŋ söŋgaiba tata siŋgi malbingö osimakze. ");
INSERT INTO bmu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Osimakzemö, Anutunöŋ noaŋgiri kömumbiga yeŋön mönö nalö miaŋgöreŋ ölöp siŋgi malakŋe. ");
INSERT INTO bmu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","(Iŋini malmal walŋi aka sösöŋgai Buŋa dölökŋi mi mindirim etkibingö osime. Miaŋgö keu pasetŋi mi kewö jibi mötket:) Löŋgölöŋgöt walŋi jurariga kunŋan opo dölökŋi qahö saŋgoŋsaŋgoŋi mitiba miaŋön opo su jöhanŋi qahö uhum memba umgöreŋgömakza. Mewö akawak ewö, opo su jöhanŋi dölökŋan mönö waziba löŋgölöŋgöt walŋi öröiga kunbuk tiŋgiriga kinimŋan qariba böliqölibapuk. ");
INSERT INTO bmu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mewöŋanök kunŋan wain o dölökŋi mi jobö me toru walŋi lama sileŋan memeŋi miaŋgöreŋ qahö kusuiga gemakza. Mewö akawak ewö, wain o dölökŋan mönö qariba toru qesiŋniga jula mokoiga gölmenöŋ eta sohoiga toruŋan böliqölibepuk. Miaŋgöra wain o dölökŋi mi toru dölökŋeyök mokoin geiga dop kölma. (Mewöŋanök o ölöpŋi mi gina gisagisahöŋe qahö umakzin. Mewö ubinak ewö, miaŋön mönö jula kisipisirik eriga nemba kawöl neŋgöhöbapuk. Mewö akapuköra o ölöpŋi mi gina ölöpŋe umakzin. Iŋini mewöyök malmal walŋi aka Ölöwak Buŋa dölökŋi mi mindirim etkibingö osime.) Mewö.” ");
INSERT INTO bmu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Miaŋgö andöŋe Sabat kendon kunöŋ Jisösnöŋ wit padi nup köröŋi ketaŋi kutuba anök. Aniga gwarekurupŋan wösöŋini eŋguiga wit ölŋi mohot mohot könahiba böröŋinan misiba neget. ");
INSERT INTO bmu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mewö negeraŋgöra Farisi (Köna keugö kapaŋkölköl) tosatŋan Jisös kewö jiget mörök, “Mötnöŋ, yeŋön mönö wuanöŋgöra Sabat kendongö nup meme soŋgoŋi oŋgitze?” ");
INSERT INTO bmu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mewö jigetka kewö meleŋnök, “Kiŋ Deiwidnöŋ yarö aziurupŋi yembuk liliköba wösöŋini eŋguiga nenegöra osiba yuia akeri, mi lök nalö kunöŋ oyoŋget me qahö? ");
INSERT INTO bmu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yaŋön mönö Anutugö opo seri jikenöŋ öŋgöba beret kömbukŋi Anutugö jemesoholŋe altanöŋ alget tariga ösumŋan walöŋniga qekögeri, mi mönö memba neyök. Beret kömbukŋi mosötmosötŋi mi jike nup galöm yeŋönök nezema. Tosatŋan mi nembepuköra soŋgo ahöiga töndup neyök. Nemba aziurupŋi tok eŋgiiga mohotŋe neget. Nalö miaŋgöreŋ azi qetŋi Abiatar yaŋön jike nup galöm bohonŋaŋgö nup memba malök.” ");
INSERT INTO bmu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mewö jiba kewö jii mötket, “Anutunöŋ Sabat kendon mi ambazip ölöwakŋegöra ali ahöza. Mia ambazipnöŋ laŋ jim kutumegöra aka qahö. ");
INSERT INTO bmu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mewö aiga Suep gölmegö azi ölŋan mönö Sabat kendongö Kembuŋi mewöyök akza.” ");
INSERT INTO bmu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisösnöŋ kunbuk köuluk mire öŋgöiga miaŋgöreŋ azi böröŋi sosoholiŋi kun tarök. ");
INSERT INTO bmu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Miaŋgöreŋ azi böröŋi sosoholiŋi kun tarök. Ambazipnöŋ Jisös keu jakeŋe al waŋgibingöra “Azi mi Sabat kendonöŋ möhamgöma me qahö?” jiba Jisös je galöm memba tatket. ");
INSERT INTO bmu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Megetka Jisösnöŋ azi böröŋi sosoholiŋi mi kewö jii mörök, “Mönö wahöta jenine kinöŋ.” ");
INSERT INTO bmu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mewö jiba kewö jii mötket, “Köna keu wuataŋgöba Sabat kendonöŋ yuai ölöpŋi me bölöŋi akin? Ölöp kungö bohonŋi jöhöbin me mosöringa kömuma? Wanat kun meinga dop kölma?” Mewö jii möta göröŋ alget. ");
INSERT INTO bmu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Keuŋini göröŋ tatketka liliŋgöm purik eŋgehi uruŋinan köhöikŋi gwözöŋnöhaŋgöra wösöbirik aka kukjejenöŋ eŋgehök. Mewö eŋgeka azi miaŋgö jiyök, “Gi mönö börögi qötöteinöŋ.” Mewö jiiga böröŋi qötöteiba kunbuk ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ölöwahiga Farisi (Köna keugö kapaŋkölköl) yeŋön yaigep anda miaŋgöreŋök premiö Herodkö pati alaurup yembuk totoko ala “Jisös denöwö qein kömuma?” jiba keu nup meget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Mewö megetka Jisösnöŋ gwarekurupŋi eŋguaŋgita o aŋgö jitŋe anget. Angetka Not prowins qetŋi Galili miaŋgöreŋök ambazip kambulelembe yeŋön könaŋe wuataŋgöba anget. Judia prowins miaŋgöreŋök mewöyök yaŋgöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Siti bohonŋi qetŋi Jerusalem, Saut prowins qetŋi Aidumia aka Jordan o likepŋeyök Wehön Kotkotŋe yeŋön aka Wehön Gegeŋe görökenök taon qetŋiri Taiö aka Saidon liliköba maljei, yeŋön mohok kambulelembenöŋ öröba kaget. Jisösnöŋ aŋgöletot ketaŋi ketaŋi memba malöhi, miaŋgö buzupŋi möta mindiqindiriba kaŋgotket. ");
INSERT INTO bmu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mewö kaŋgota utal waŋgibepuköra Jisösnöŋ gwarekurupŋi kewö jii mötket, “Ölököm niŋgibepuköra iŋini mönö waŋge kun miwikŋaiba nöŋgöra dowe alget tarök.” ");
INSERT INTO bmu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mewö jii möta ambazip sehisehiŋi mem ölöwak eŋgiba malök. Miaŋgöra qemjem-mamjeŋ aka sile lölömböröŋinambuk pakpak yeŋön sileŋe misiribingöra liliköba gwötpuk aum metala utal waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ömeŋi ömeŋi yeŋön Jisös eka jemesoholŋe gölmenöŋ geba kewö qetket, “Gi Anutugö Nahönŋi akzan!” ");
INSERT INTO bmu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mewö qetketka Jisösnöŋ qetal eŋgiba könöŋamŋan aukŋe asuhubapuköra soŋgo köhöikŋi al eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Könaŋgep Jisösnöŋ kunduŋe öŋgöba miaŋgöreŋ nanŋi sihimŋaŋgö dop azi eŋgoholiga yaŋgöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kagetka azi 12 mi yambuk malmegöra al eŋgiba Buŋa keuŋi jim sehimegöra melaim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Melaim eŋgiba ömewöröme közöl eŋgimegö kukösumŋi eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mewö aka azi 12 ki kewö al eŋgiyök: Pitö, Jisösnöŋ qet mi Saimon waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jeims aka munŋi Jon, iwiŋiri qetŋi Zebedi. Jisösnöŋ yetkö qetŋiri kun Boanerges qerök. Mi nanine keunöŋ Pöndandaŋgö Nahönyahötŋi. ");
INSERT INTO bmu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Bartolomyu, Matyu, Tomas, Jeims Alfiusgö nahönŋi, Tadius, Saimon Zelot-politik azia ");
INSERT INTO bmu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aka Judas Iskariot. Kariot azi miaŋön könaŋgen Jisös mamalolo mem waŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisösnöŋ mi al eŋgiba kunduŋeyök eta nanŋi miriŋe kayök. Mire kaiga ambazip kambu ketaŋi kunbuk kaŋgota tokogetka mönö miaŋgöra tosolomŋi yembuk nene nembingö osiget. ");
INSERT INTO bmu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Osigetka sepkitipurupŋan mi möta “Uruŋi lök sohoza!” jiget. Jiba geba waŋgitpingöra anget. ");
INSERT INTO bmu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Angetka Köna keugö böhi Jerusalemök kageri, yeŋön jiget, “Satangö Katakömulatnöŋ mönö uruŋe geiga malja. Yaŋön öme yeŋgö kembuŋinaŋgö ösumnöŋ ömewöröme eŋguataŋgömakza.” ");
INSERT INTO bmu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mewö jigeraŋgöra Jisösnöŋ eŋgoholi kagetka dopkeunöŋ kewö jii mötket, “Satanöŋ mönö denöwö alaŋi Satan kun wuataŋgöbawak? ");
INSERT INTO bmu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kantri kungö galömurupŋinan sutŋine aŋgururuk aka julme ewö yeŋön mönö galömkölköl nupŋini memba kinbingö osime. ");
INSERT INTO bmu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mewöyök miri kungö könagesö yeŋön sutŋine aŋgururuk aka julme ewö, mönö galömkölköl nupŋini memba kinbingö osime. ");
INSERT INTO bmu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mewöyök Satangö könagesö yeŋön sutŋine aŋgururuk aka tuarenjoŋ ak aŋgubeak ewö, galömkölkölŋinaŋgö ösumŋan eriga bemtohoŋinan mönö qahöwakŋamgö akza. ");
INSERT INTO bmu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kunŋan azi köhöikŋaŋgö köna böröŋi mutuk qahö jöhöma ewö, yaŋön mönö miriŋe öŋgöba qezaŋda sukinapŋi memamgö osima. Mutuk i jöhöi tarigun mönö ölöp miriŋeyök öröyuaiŋi pakpak waŋgita memba anma. (Miaŋgö dop nöŋön mewöyök Satan jöhöba andöŋe ömeŋi eŋguataŋgömakzal.”) Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nöŋön keu ölŋi kun kewö jibi mötme, “Ambazip ketaŋi moröŋi siŋgisöndok ahakzei, mi Anutunöŋ mosörakza. Lömbötŋambuk me awamŋi mepaqepaik akeak mönö mi Anutunöŋ saŋgoŋ eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Saŋgoŋ eŋgimapmö, Kunŋan Uŋa Töröŋi ilita mepaikömawi, miaŋgö siŋgisöndokŋi Anutunöŋ mönö nalö kunöŋ qahö mosötma. Saumbaŋ! Siŋgisöndok miaŋön mönö qakŋe öŋgöiga nalö teteköŋi qahö Anutugö jeŋe keuŋambuk malma.” Mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Ömenöŋ uruŋe geyöhawa malja,” Jigeraŋgöra aka mewö kusum eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mewö eraum mötketka nam-munŋan kaba yaigep kinda yeŋgöreŋ etmapkö keu alget yaŋgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aniga ambazip kambu yeŋön liliköm waŋgiba tata kewö jiget mörök, “Mötnöŋ! Göhö nam-mungan mönö yaigep kinda göhöra qesize.” ");
INSERT INTO bmu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jigetka meleŋda kewö jii mötket, “Nöŋgö namni mi daŋön aka munurupni daŋön?” ");
INSERT INTO bmu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jisösnöŋ mewö jiba ambazip liliköm waŋgiba tatkeri, i uba eŋgeka kewö jiyök, “Eket nöŋgö namni aka munurupni mönö ki. ");
INSERT INTO bmu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anutugöreŋ jitsihitŋi tem kölahakzei, mieŋön mönö nöŋgö namni aka nen-munurupni akze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisösnöŋ kunbuk o aŋgö jitŋe geba könahiba kusum eŋgiyök. Kusum eŋgiiga ambazip kambulelembenöŋ yaŋgöreŋ anda tokogetka waŋgenöŋ öŋgöba o aŋgö qakŋe anda tarök. Tariga ambazip pakpak yeŋön aŋgö göraŋe saknöŋ tokoget. ");
INSERT INTO bmu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mewö tokogetka dopkeu gwötpuk jiba kusum eŋgiyök. Kusum eŋgiba kewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mötket! Azi kunŋan nene kötŋi qesiŋ gilmamgöra nupnöŋ anök. ");
INSERT INTO bmu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Anda qesiŋ giliga kötŋi tosatŋan köna jitŋe geba kölget. Geba kölgetka (warawen) neiŋi neiŋi kaŋgota mi nem teköget. ");
INSERT INTO bmu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kötŋi tosatŋan köt jamönjiŋnöŋ geba kölget. Geba köla miaŋgöreŋ gölme gwötpuk qahö miwikŋaiget. Gölme dutŋi qahö ahöyöhaŋgöra korapŋi zilaŋ kotket. ");
INSERT INTO bmu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kotketmö, wehönöŋ kota enguba jem kutum eŋgiiga jalöŋini qahöpköra soholiba gororoŋgöget. ");
INSERT INTO bmu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kötŋi tosatŋan siriuret wahiŋinambuknöŋ miaŋgöreŋ geba kölget. Geba kölgetka mieŋön kota qem turugetka böbölohot mem eŋgiget. Mewö aka ölŋi qahö kuŋguget. ");
INSERT INTO bmu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kötŋi tosatŋan gölme ölöpŋe geba kölget. Geba köla korapŋini jula wahöta ipŋinaŋgö ölŋini ölöpŋi asuhuget. Tosatŋan kötŋini 30, Tosatŋan kötŋini 60, tosatŋan 100 miaŋgö dop ahum sehiget.” ");
INSERT INTO bmu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mewö jiba jim teköyök, “Kunŋan urukezapŋambuk malja ewö, yaŋön mönö dopkeu ki kezap ala möt kutuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kambu ketaŋi yeŋön deŋda angetka Jisösnöŋ nanŋök tarök. Nanŋök tariga gwarekurupŋi 12 aka tosatŋi liliköm waŋgigeri, mi mohotŋe dopkeu kieŋgö könaŋinaŋgöra qesim waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Qesim waŋgigetka kewö meleŋda jiyök, “Anutugö bemtohoŋe aŋgota malbingö keu tölapŋi mi eŋgöra aukŋe jibi möt kutuzemö, yaigep maljei, yeŋgöra mi pakpak mönö dopkeunöhök asuhumakza. ");
INSERT INTO bmu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mewö asuhuiga ‘Nanŋini jeŋinan yuai ekagun könaŋi töndup qahö möt kutume. Nanŋini Kezapŋinan keu törörök mötagun könaŋi töndup qahö möt asarime. Mi möt asaribeak ewö, mönö ölöp uruŋini meleŋgetka Anutunöŋ siŋgisöndokŋini mosötpawak.’” ");
INSERT INTO bmu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisösnöŋ toroqeba kewö jii mötket, “Dopkeu miaŋgö könaŋi kewö. Mi kude möt asarize ewö, dopkeu tosatŋi pakpak jimami, mi mönö denöwö möt asaribeak? ");
INSERT INTO bmu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dop Keu miaŋgö könaŋi kewö: Qesiŋgilgil azinöŋ Buŋa keu qesiŋda gilja. ");
INSERT INTO bmu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nene kötŋi köna jitŋe geba kölgeri, mi kewö: Buŋa keu qesiŋ gilgetka ambazip uruŋine gezapmö, mi mötketka Satanöŋ miaŋgöreŋök kaba keu uruŋine qesiŋget geyöhi, mi qeköba eŋguaŋgirakza. ");
INSERT INTO bmu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nene Kötŋi qesiŋniga köt jamönjiŋnöŋ geba kölgeri, mi mewöyök ambazip söpsöpŋi kun. Yeŋön Buŋa keu möta miaŋgöreŋök sösöŋgai qakŋe möt aŋgön kölakze. ");
INSERT INTO bmu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mewö ahakzemö, uruŋine jalöŋi qahö ahöm eŋgimapmö, nalö töröptökŋi miyök kin köhöiba malme. Buŋa keugöra aka kahasililiŋ me sesewerowero asuhuiga nalö miaŋgöreŋök mönö tala eŋguma. ");
INSERT INTO bmu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nene kötŋi qesiŋniga siriuret wahiŋinambuknöŋ geba kölgeri, mi kewö: Yeŋön Buŋa keu mötketka uruŋine geza. ");
INSERT INTO bmu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Gezapmö, gölmenöŋ malmalgö waimanjatŋi aka moneŋ inap memegö urukönöpŋi ahuba lömbörim eŋgimakzal. Qetbuŋaŋinambuk akingö köpösöŋgögetka sihim kömbönaŋi bölöŋi tosatŋan mewöyök uruŋine dumgöba Buŋa keu böbölohot mem waŋgize. Mewö aiga ölŋini qahö gilipitŋi (ambetakŋi) akŋe. ");
INSERT INTO bmu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nene kötŋi gölme ölöpŋe qesiŋniga geba kölgeri, mi ambazip kewöŋi: Yeŋön Buŋa keu kezap ala möta möt aŋgön köla pöndaŋ kinda ölŋini miwikŋaimakze. Tosatŋan keu jit mohoknöhök kötŋi 30 miwikŋaimakze. Tosatŋan ölŋini 60, tosatŋan keu köt mohot mohot mieŋgö ölŋini 100 mem sehiba miwikŋaimakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisösnöŋ keu kun kewö jiyök, “Kunŋan lambe me kiwa memba ohotiriba kimbut me dum bapŋe alma me qahö? Mi waniŋe alma? Mi mönö miaŋgö dum tatatnöŋ aukŋe alma. ");
INSERT INTO bmu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mewöŋanök yuai kun asambötket ahözawi, mi mönö aukŋe asuhum tiŋgitmapköra ahöza. Yuai kun köl turuget ahözawi, mi mönö luluŋget kötulmapköra aka ahöza. ");
INSERT INTO bmu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kunŋan urukezapŋambuk malja ewö, yaŋön mönö dopkeu ki kezap ala möt kutuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jisösnöŋ keu kewö jii mötket, “Keu mötzei, mi mönö möt aŋgön köla urukönimŋine ala köl guliba malme! (Mewö malgetka uruŋini diŋgiiga mötmötŋinan qariiga möt kömume.) Iŋini tosatŋi yeŋgö keuŋini kewöta jim tekömei, Anutunöŋ mönö jimkutukutuŋini mohot miaŋgö dop nanŋini keuŋini kewöta jim teköma. Dop mi mönö oŋgita likepŋi meleŋ eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Miaŋgö könaŋi kewö: Kunŋan mötkutukutuŋambuk maljawi, Anutunöŋ mönö mi toroqem waŋgiiga malmapmö, kunŋan mötkutukutuŋi qahö maljawi, Anutunöŋ mönö mötmötŋi moröŋi ahözawi, mi mewöyök qeköba waŋgitma. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisösnöŋ dopkeu kun kewö jiyök, “Anutugöreŋ bemtohoŋi mi kiaŋgö dop: Azi kunŋan nuwe anda nene kötŋi qesiŋda gilma. ");
INSERT INTO bmu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Qesiŋda gila anda suŋgem silim ahöba wahöta ahöba wahöriga nene kötŋaŋgö korapŋi jula korakze. Denöwö jula korakzei, mi nanŋak qahö möt kutuza. ");
INSERT INTO bmu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gölmenöŋ nanŋök nam köli ölŋi asuhumakza: Mutuk ipŋi, könaŋgep ölŋi aka miaŋgö andöŋe ölŋaŋgö kötŋi mi körek asuhuba qarim teköme. ");
INSERT INTO bmu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ölŋi qarim teköba öliiga ölŋi memegö nalöŋi aiga welenqeqeurupŋi melaim eŋgiiga souŋini kapeŋkapeŋgöŋi jitŋinambuk memba ölŋi membingöra nupŋe anme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisösnöŋ dopkeu kun kewö jiyök, “Anutugö bemtohoŋi mi wanatpuk dop albinak me wanat söpsöp keu jiba jim asaribinak? ");
INSERT INTO bmu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mi nejoŋ kötŋaŋgö dop kewö akza: Kötŋi mi morö közözömŋi. Mi gölmegö nene köt pakpak mieŋgö eretŋini akza. Mewö aiga nup gölmenöŋ esize. ");
INSERT INTO bmu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Esizemö, jula wahöta yöha pakpak eŋgoŋgita qariba böröŋi ketaŋi gili anje. Mewö gili angetka könakembagö neiŋi neiŋi mieŋön aipŋini miaŋgö aumŋe alakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisösnöŋ dopkeu mewöŋi mewöŋi mi gwötpuk jiba mala Buŋa keu jiiga mötket. Möt kutugeraŋgö dop mi jiiga möta malget. ");
INSERT INTO bmu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nalö dopkeuŋi pakpak mi dopkeunöŋ jiba malök. Keuŋi kun öne kude jiyökmö, gwarekurupŋi yembuk nanŋinök malgetka keu pakpak mieŋgö könaŋini mi jim asarim eŋgiba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wehön miaŋgöreŋ mare aiga Jisösnöŋ gwarekurupŋi kewö jii mötket, “Mönö mosöta aŋgö kutuba likepŋe aŋgotpin.” ");
INSERT INTO bmu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mewö jiiga ambazip kambu eŋgömosöta Jisös waŋgigetka waŋgenöŋ tari anget. Waŋge tosatŋi mi mewöyök yembuk awataŋ anget. ");
INSERT INTO bmu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Angetka raidimbom ketaŋan ömtöröp (töröpŋanök) giliga sirinöŋ waŋge uruŋe gegetka waŋge numbuŋe qemamgö ahök. ");
INSERT INTO bmu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mewö aiga Jisösnöŋ waŋge teteköŋe tata qömböŋnöŋ nariba gaun ahöyök. Gaun ahöiga gwarekurupŋan anda möndöba jiget, “Hei böhi! Nini aŋgönöŋ ayuhubingöra akzin. Miaŋgö waimanjatŋi kun mötzan me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mewö jigetka imbiŋi möta luhut aka siri kewö jim qetal etkiyök, “Mönö bököba öne ahönöŋ!” Mewö jiiga luhutnöŋ döŋgöiga sirinöŋ nöŋ qeba ahöyök. ");
INSERT INTO bmu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mewö aka kewö jim eŋgiyök, “Iŋini mönö wuanöŋgöra keŋgöt mötmöt azia akze? Denöwögöra aka Anutu qahö möt narize? Sömbuŋini mönö öne mötze.” ");
INSERT INTO bmu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jiiga awöwöliba qem sömbuŋini möta eraum mötket, “Yei, azi kia mönö denöwöŋan malja? Yaŋön mönö luhut aka köwet jim kutum etkiiga jitŋi tem köljahot?” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mewö asuhuiga aŋgö kutuba likepŋe Gerasin yeŋgö gölmenöŋ aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aŋgota körökŋe öŋgögetka Jisösnöŋ waŋge mosöriga miaŋgöreŋök azi ömeŋambuk kun mi qaksirinöhök kaba kinda Jisös miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Azi mi qaksirinöŋ mala qamöt köteŋi esiba urorohoget ahögeraŋgöreŋ ahöm malök. Azi körekŋön könaböröŋi tapep (muŋgamuŋga) kösönöŋ jöhöbingö osiba malget. ");
INSERT INTO bmu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Indimŋi gwötpuk könaŋi tapep kösönöŋ jöhöba börötakŋi qeba malgetmö, börö takŋi kusula köna kösöŋi titikutuba maliga körekŋan i galöm köl osiget. ");
INSERT INTO bmu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Osiba suŋgem asak dop sundan qaksirigö köt köteŋnöŋ me kunduŋe laŋlaŋ ahöba malök. Mewö mala silata qeta sileŋi kötnöŋ qem kutumutuba malök. ");
INSERT INTO bmu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisösnöŋ tikep kaiga eka ösumŋan kaba gölmenöŋ kösutŋe geba simin kölök. ");
INSERT INTO bmu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Simin köliga Jisösnöŋ ömeŋi mi kewö jim waŋgimamgöra ahök, “Öme bölöŋi! Gi mönö azi ki mosöta anöŋ!” Mewö jimamgöra aiga qet bölöbölö ketaŋi qeta jiyök, “Aek! Gi Jisös, Anutu öŋgöŋgöŋaŋgö Nahönŋi akzan. Gi denöwö ak niŋgimamgöra kazan? Nöŋön Anutugö jemesoholŋe ulet gihizal: Gi keu jöhöba jöjöpaŋ keunöŋ jim köhöiba mönö sihimbölö könöpŋambuk kude ak niŋginöŋ.” ");
INSERT INTO bmu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mewö jiiga kewö qesiyök, “Gi qetki niŋi?” Qesiiga jiget, “Nini gwötpuk maljinaŋgöra qetnini Lijön jizin.” Mi nanine keunöŋ Kerök kambu ketaŋi. ");
INSERT INTO bmu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mewö jiba kapaŋ köla kewö ulet waŋgiget, “Gi neŋguataŋgöbanak, mewö mönö gölme kiaŋgöreŋök kude melaim neŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kösutŋine kunduŋi marömŋe miaŋgöreŋ bau kambu ketaŋi kun gwözözak uruŋe kuluŋda malget. ");
INSERT INTO bmu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Miaŋgöra ömenöŋ kewö jiba Jisös ulet waŋgiget, “Göŋön melaim neŋginöŋga nini ölöp bau mieŋgö uruŋine gebin.” ");
INSERT INTO bmu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jigetka “Mönö anda geget,” jiba jim kutum eŋgiiga azi uruŋeyök kota anda bau uruŋine geget. Gegetka miaŋgöreŋök bau kambu 2000 miaŋgö dop mi mönö luhuba nembönembönöŋ anda jororoŋgöba o aŋgönöŋ geba nemulahöba kömuget. ");
INSERT INTO bmu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kömugetka bau galöm yeŋön ölöŋ unjurata taon aka miri morömorö miaŋgöreŋ anda keu buzupŋi jiget. Jiget mötketka ambazip sesegilgil yeŋön yuai asuhuyöhi, mi ekingöra kaget. ");
INSERT INTO bmu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kaba Jisösgöreŋ kaŋgota eketka azi öme kambuŋambuknöŋ malöhaŋön mönö opo sileötaŋi törörök jöhöba tata uruŋi amöriiga imbi mötmötŋi pakpak asuhuiga eka awöwöliget. ");
INSERT INTO bmu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kingetka bau mi denöwö geba kömugeri aka azi ömeŋambuk yaŋgöreŋ yuai asuhuyöhi, mi ekeraŋön kösohot yahöt mi jiget mötket. ");
INSERT INTO bmu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Möta kinda Jisösnöŋ mindimindiri sel gölmeŋini mosöta anmapkö ulet waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ulet waŋgigetka mosöta waŋgenöŋ öŋgömamgöra ahiga azi ömeŋambuk malöhaŋön kaba Jisösbuk mohotŋe anda malmamgöra qesiyök.” ");
INSERT INTO bmu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Qesiyökmö, Jisösnöŋ qetal waŋgiba kewö jii mörök, “Gi mönö mirige anda tinitosolomurupki eŋgeka Kembunöŋ aŋgöletot ketaŋi aka ak-kömum gihiyöhi, miaŋgö kösohotŋi jinöŋga mötme.” ");
INSERT INTO bmu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mewö jiiga mosöta anda Jisösnöŋ aŋgöletot ketaŋi ketaŋi ak waŋgiyöhi, miaŋgö keuŋi könahiba Ten-taon distrik uruŋe jim sehiiga körekŋan welipköget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisösnöŋ waŋgenöŋ öŋgöba liliŋgöba aŋgö kutuba likepŋe kaiga ambazip kambu gwötpukŋan yaŋgöreŋ kaba tokogetka aŋgö jitŋe kinget. ");
INSERT INTO bmu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kingetka köuluk mirigö keu galöm kun qetŋi Jairus yaŋön kaba Jisös eka wösöŋe geba simin köl waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Simin köl waŋgiba kapaŋ köla köuluköba kewö jiyök, “Böratni moröŋan mönö kömumamgö akza. Mönö kaba börögi qakŋe alnöŋga ölöwaka toroqeba malma.” ");
INSERT INTO bmu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mewö jiba Jisös waŋgiriga mohotŋe anohotka ambazip kambulelembe yeŋön andöŋire anda ölöqölököba liliköm etkiba anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Angetka miaŋgöreŋ sutŋine ambi kun malök. Yaŋön (yara) yambu 12:gö dop köiŋnöŋ ehiga nalö dop kawöl yöhöiga malök. ");
INSERT INTO bmu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mewö mala sihimbölö gwötpuk möriga sile galöm gwötpukŋan yaŋgö nup megetka baukbauk kun kude miwikŋaiba malök. Yaŋön sile galöm ambazip yeŋgö töwaŋinaŋgöra moneŋ inapŋi körek gila malökmö, kawölŋi miaŋön mönö mem bölim waŋgiiga malök. ");
INSERT INTO bmu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Mewö mala Jisösgö buzupŋi möta kewö jiyök, “Nöŋön i oseimamgö möt lömböriba malukuŋeyök borom kun misiribileŋak ewö, mönö ölöp ölöwakŋam.” Mewö jiba ambazip kambu sutŋine Jisösgö andöŋe anda malukuŋe misiriyök. ");
INSERT INTO bmu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Misiriiga sepŋi miaŋgöreŋök jöpköiga qemjem-mamjeŋan qahöwahiga sileŋan ölöwahiga mörök. ");
INSERT INTO bmu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ölöwahiga Jisösnöŋ miaŋgöreök ösumŋi kun kutuba anöhi mi möta ambazip kambu sutŋine liliŋgöba jiyök, “Daŋön malukuni misiriza?” ");
INSERT INTO bmu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mewö jiiga gwarekurupŋan kewö jiget mörök, “Ambazip kambunöŋ ölököba liliköm gihiba goseize. Mi eka denöwö ‘Daŋön nömisiriza?’ jizan?” ");
INSERT INTO bmu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mewö jigetmö, Jisösnöŋ kunbuk “Daŋön mi akza?” jiba mi miwikŋaimamgöra liliŋgöba uba eŋgehök. ");
INSERT INTO bmu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eŋgehiga ambi sileŋe angöletot asuhuyöhi, yaŋön mi möta miaŋgöra keŋgötŋi möta jönömŋi unduiga kaba Jisösgö wösöŋe geba simin köla könaŋi pakpak jiiga mörök. ");
INSERT INTO bmu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisösnöŋ mi möta kewö jii mörök, “Böratni, mötnaripkan mönö mem ölöwak gihiza. Qemjem-mamjeŋgan mönö qahöwahiga ölöp urubönjöŋnöŋ anman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Keu mewö jiba kiniga köuluk mirigö keu galömŋaŋgö mireyök kunŋan welen kaba Jairusgöra jiyök, “Böratki kömuza! Miaŋgöra böhigö qakŋe lömböt toroqeba kude alman.” ");
INSERT INTO bmu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jiiga Jisösnöŋ keu miaŋgö nönöŋgan aka köuluk mirigö keu galömŋi kewö jii mörök, “Keŋgötki kude mötnöŋ! Mönö ni möt narim niŋginöŋ.” ");
INSERT INTO bmu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mewö jiba ambazip tosatŋi eŋgömosöta Pitö, Jeims aka Jeimsgö munŋi Jon miyök eŋguaŋgiri i wuataŋgöba anget. ");
INSERT INTO bmu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Anda köuluk mirigö keu galömŋaŋgö mire aŋgotketka ambazip kambu göju megetka eŋgehök. Gwötpukŋan jiŋgeŋ köla köhöikŋanök sahöta amburereŋ meget. ");
INSERT INTO bmu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Eŋgeka mire öŋgöba kewö jii mötket, “Iŋini mönö wuanöŋgöra göju memba sahötze? Morö miaŋön qahö kömuzapmö, gaunök ahöza.” ");
INSERT INTO bmu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mewö jii mötket gönahit ewö aiga gön köl waŋgigetmö, yaŋön i körek eŋguataŋgöba morögö iwinamŋi aka tosatŋi yambuk malgeri, miyök eŋguaŋgiriga morönöŋ ahöyöhaŋgöreŋ öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Öŋgögetka börat mi böröŋe memba yaŋgöra jiyök, “Talita kum.” Mi nanine keunöŋ Ambi moröŋi, ni göhöra jizal: Mönö wahötnöŋ! ");
INSERT INTO bmu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mewö jiiga ambi (yara) yambuŋi 12 miaŋön mönö miaŋgöreŋök wahöta kinda anda kayök. Mewö aiga eka kesötŋini yöhözömgöba welipköget. ");
INSERT INTO bmu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Welipkögetka miaŋgö buzupŋi kun jiget mötpepukö jiba soŋgo köhöikŋi al eŋgiyök. Al eŋgiba ambi moröŋi numbu nene waŋgiget nemapkö jiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mi asuhuiga Jisösnöŋ Jairusgö miri gölme mosöriga gwarekurupŋan wuataŋgöba yambuk anda Jisösgö malqarip taonön aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat kendonöŋ kaiga köuluk mire öŋgöba Buŋa keu könahiba kusum eŋgiyök. Kusum eŋgiiga möta ambazip gwötpukŋan auruba welipköba kewö jiget, “Yei, kezapjupjup! Yuai pakpak ki mönö denikeyök möta jiza? Mötkutukutuŋi mi mönö daŋön kusum waŋgiiga jiza? Aka aŋgöletot kukösumŋinambuk mewöŋi mi mönö daŋön inahöi böröŋan meiga asuhuze? ");
INSERT INTO bmu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Azi ki mönö miri kiaŋgö mitimqeqe azia. Mariagö nahönŋi aka Jeims, Josef, Juda aka Saimon yeŋgö datŋina. Nenurupŋan mönö sutnine ki malje.” Nazaret yeŋön mewö jigetka uruŋinan böliiga miaŋgöreŋ qaköget. ");
INSERT INTO bmu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Qakögetka Jisösnöŋ kewö jii mötket, “Kezapqetok azigö sepkitip aka tinitosolomurupŋan mönö nanŋi taonöŋ jijiwilit ak waŋgimakzemö, miri tosatŋi miaŋgöreŋ mewö qahö. ");
INSERT INTO bmu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mewö akeraŋgöra Jisösnöŋ kawöl ambazip mohot mohot böröŋi qakŋine ala mem ölöwak eŋgiyökmö, aŋgöletot kukösumŋinambuk tosatŋi memamgö osiyök. ");
INSERT INTO bmu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mewö ahiga mötnaripŋinan qahö asuhuiga yaŋgiseŋinaŋgöra aka auruyök. Auruba Nazaret mosöta kösutŋe miriŋi miriŋi liliköba Buŋa keu kusum eŋgiba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisösnöŋ gwarekurupŋi 12 mi eŋgoholi kagetka könahiba yahöt yahöt pakpak melaim eŋgiyök. Melaim eŋgiba ömewöröme közöl eŋgimegö kukösumŋi eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mi eŋgiba kewö jim kutum eŋgiyök, “Köna anmeaŋgöra öröpŋini memba anme. Yuai tosatŋi kun kude meme. Köna nalem qahö, gösö qahö me soujeŋi mi irimuŋgaŋine kude jöhöme. ");
INSERT INTO bmu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Köna esu ölöp könaŋine jöhöba maluku semönŋi qahöpmö, mohot meme.” ");
INSERT INTO bmu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mewö jiba kewö jii mötket, “Anda miri denike denike aŋgotmei, mönö miaŋgöreŋök mala nup memba taon mi mosöta köna anme. ");
INSERT INTO bmu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Anda mala miri kunöŋ aŋgotketka qahö köl öröm eŋgiba keuŋini qahö mötketka nesampurekŋini mönö kewö jiba kondel eŋgime, ‘Nini eŋgö gölmenöŋ kainga sölbuham köna tambönine mekötahözawi, mi mönö tim tönjöraringa nanŋine liliŋgöba gema.’ Mewö jigetka könaŋamŋini solanŋi möt kutugetka ölöp miri me taon mi mosöta toroqeba anme.” ");
INSERT INTO bmu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mewö jiiga mosöta anda ambazip uruŋini meleŋmegö Buŋa keuŋi jim sehiba malget. ");
INSERT INTO bmu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mala öme gwötpuk eŋguataŋgöba kawöl ambazip gwötpuk kelöknöŋ eŋgömiriba mem ölöwak eŋgiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jisösgö qetbuŋaŋan sehiba kiŋ Herodkö kezapŋe gei mörök. Ambazipnöŋ kewö jiget, “Jon o melun azinöŋ mönö kömupnöhök wahöta nupŋi meiga aŋgöletot kukösumŋinambuk asuhumakze.” ");
INSERT INTO bmu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mewö jigetmö, tosatŋan kewö jiget, “Mi mönö Elaija (Elia)” Tosatŋan toroqeba jiget, “Mi kezapqetok azi walŋi yeŋgöreŋök kun.” ");
INSERT INTO bmu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mewö jigetmö, kiŋ Herodnöŋ mi möta kewö jiyök, “Jon o melun azi nöŋön jibi jölŋi kutugeri, yaŋön mönö kömupnöhök wahöta malja.” Waimanjat möta Mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mi kewögöra jiyök: Herodnöŋ munŋi Filipkö anömŋi Herodias ölöŋ meiga Jon o melun azinöŋ kiŋ jim waŋgiiga opotöröp melaim eŋgiiga anda Jon memba jöhöba kösö mire al waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jonöŋ Herodköra keu kewö jiyök: Gi qamböt ki memba mala Köna keu oŋgitzan.” ");
INSERT INTO bmu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mewö jiiga Herodiasnöŋ Jon kazik ak waŋgiba qeget kömumapkö mörökmö, miaŋgö könaŋi kun qahö miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Qahö miwikŋaiba Jonöŋ azi solanŋi aka sarakŋi töröŋi ahöhi, mi möta sel jöhöba kölközizip ak waŋgiba Jongöra keŋgötŋi möta malök. Mewö mala Jongö jitŋeyök keu möröhi, mi uruŋi kuŋgugetka keu gwötpuköra uruyahöt ahök. Mi töndup töndup Jongö keuŋi mötmamgö sihim mörök. ");
INSERT INTO bmu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mewö aiga Herodiasnöŋ Jon qemamgö könaŋi qahö miwikŋaiba maliga miaŋgö nalöŋi ölöpŋi kewö kam kuŋguyök: Kiŋgö ahuahu nalöŋan kaiga közölömbuaŋ ala jembon aka suahö galömurupŋi aka Galili prowinsgö jitŋememe bohonŋi mi köl öröm, eŋgiiga kaba tatket. ");
INSERT INTO bmu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kaba tatketka Herodiasgö böratŋan miri miaŋgö uruŋe kaŋgota danis aliga Herod aka yambuk tebol liliköba tatkeri, yeŋön miaŋgö eksihimŋi gwötpuk mötket. Mewö mötketka kiŋnöŋ ambi seramgöra kewö jiyök, “Böratni! Wani yuaigöra sihimgi mötzani, mi ölöp qesinöŋga tököm gihimam.” ");
INSERT INTO bmu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mewö jiba keu mi jöjöpaŋ keunöŋ jim köhöiba kewö jii mörök, “Wani yuaigöra qesim niŋgimani, mi mönö ölöp gihimam. Yuai mi me mi me prowins galöm kölakzali, mi tok ölöp endeŋda likepŋi kun gihibiga galömŋi akŋan.” ");
INSERT INTO bmu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mewö jii möta yaigep anda namŋi kewö qesim waŋgiyök, “Namni, ni mönö Kiŋnöŋ wani yuaiya niŋgimapköra qesimam?” Mewö qesim waŋgiiga kewö meleŋnök, “Mönö jinöŋga Jon O-melun azigö jölŋi yandigetka nöröpŋi memba kaba niŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mewö meleŋniga miaŋgöreŋök miri uruŋe kiŋkiŋgöba kiŋgöreŋ öŋgöba kewö qesiba jiyök, “Kewöni! Nöŋön sihimnan kewö mötzal: Göŋön mönö jimkutunöŋga Jon O-melun azigö jölŋi yandiba nöröpŋi memba kaba köndenöŋ algetka mia döldöpki niŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mewö jiiga kiŋgö uruŋan kömbuhiiga wösöbirik mörökmö, jöjöpaŋ keuŋan jöhöi ketaurupŋan mi mötketka yeŋgö jemesoholŋine etpapuköra qeqesiŋi andö qemamgö möt lömböriba tököyök. ");
INSERT INTO bmu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tököba miaŋgöreŋök opotöröpŋi kun melaiba jiyök, “Gi mönö anda Jongö jölŋi yandiba nöröpŋi memba kaman.” ");
INSERT INTO bmu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mewö jiba melaiiga kösö miri gwaröŋe anda jölŋi yandiba nöröpŋi memba kaba köndenöŋ ala ambi seram mi waŋgiiga namŋi waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jongö gwarekurupŋan miaŋgö buzupŋi möta anda qamötŋi memba qaksirigö köt köteŋnöŋ ala löm kölget. Mewö asuhuyöhaŋgöra kiŋ Herodnöŋ könaŋgep Jisösgöra jiyök, “Jonöŋ mönö kömupnöhök guliba wahöta malja.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Melai melai azi Aposol yeŋön Jisösgöreŋ kaba tokoba yuai memba ambazip kusum eŋgigeri, miaŋgö kösohotŋi pakpak jiget mörök. ");
INSERT INTO bmu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jiget möriga ambazip totnöŋ totnöŋ qösösök kaba anda aketka sileŋini köŋgaŋiiga nene nembingö nalö qahö ahöyök. Miaŋgöra Jisösnöŋ gwarekurupŋi kewö jii mötket, “Iŋini mönö kaba gölme kötikŋe naninök malbingöra anda borom kun luhut meme.” ");
INSERT INTO bmu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mewö jiiga eŋgömosöta waŋgenöŋ öŋgöba gölme kötikŋi kungen nanŋinök malbingöra anget. ");
INSERT INTO bmu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Angetka ambazipnöŋ mi eka gwötpukŋan miaŋgö buzupŋi möta taon aka miri dop mieŋgöreŋök gölme köna kiŋkiŋgöba mutuk anda miaŋgöreŋ aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aŋgotketka Jisösnöŋ waŋgenöhök eta ambazip kambu ketaŋi eŋgehiga lama galömŋini qahö tandök iliŋgösöŋ laŋ malgetka yeŋgöra wösöŋi mörök. Wösöŋi möta könahiba Buŋa keu könaŋi könaŋi kusum eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mewö aka maliga miri jeŋan teköba gemamgö ahiga gwarekurupŋan Jisösgöreŋ kaba kewö jiget, “Böhi! Nini gölme kötikŋi kiaŋgöreŋ malinga miri lök söŋaumamgö akza. ");
INSERT INTO bmu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Miaŋgöra gi ölöp ambazip ki melaim eŋginöŋga miri aka koum dowe dowe tat anjei, miaŋgöreŋ anda numbu neneŋini söŋgöröŋi memba neget. ");
INSERT INTO bmu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mewö jigetmö, kewö meleŋda jii mötket, “Eŋön mönö nanŋinak i nene gumohom eŋgime.” Mewö jiiga jiget, “Neŋön mönö denöwö akinto? Nup meme nalö 200:kö töwaŋi (Kina 1000,-) ahöza. Moneŋ mia memba anda nene beret söŋgöröŋi memba gumohom eŋgibingöra jizan me?” ");
INSERT INTO bmu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mewö qesim waŋgigetka jiyök, “Nanŋine nene beret dawik ahöza? Mi anda eket.” Mewö jiiga gösöŋini qeaŋda jiget, “Beret 5 aka söra yahöt mia memba maljin.” ");
INSERT INTO bmu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mewö jigetka Jisösnöŋ ambazip kambu kewö jim kutum eŋgiyök, “Ambazip pakpak, iŋini mönö deŋda nene nembingö kambu morömorö tokoba luplup görökŋe geba tatket.” ");
INSERT INTO bmu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mewö jim kutum eŋgiiga kambuŋi kambuŋi dowe dowe deŋda tatket. Kirip tosatŋi 100 aka tosatŋi 50 mewö mewö tokoba tat anget. ");
INSERT INTO bmu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tat angetka beret 5 aka söra yahöt mi memba Suepnöŋ ui öŋgöiga kötuetköba beret mindipköba gwarekurupŋi eŋgiiga ambazip kirip dop mendeŋda sutŋine alget. Söra yahöt mi mewöyöhök kambu pakpak yeŋgöra mendeŋnök. ");
INSERT INTO bmu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mendeŋniga ambazip körekmakörek nemba nem timbireŋ aket. ");
INSERT INTO bmu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nem timbireŋ aka nene kitipŋi kitipŋi mosötkeri, mi gwarek yeŋön qezakögetka sakap 12 miaŋgöreŋ geba kokolak qeyök. Mewöyök söra kitipŋi mi mem kiripköget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Azi beret negeri, yeŋgö jaŋgöŋini mi 5000. ");
INSERT INTO bmu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Neget teköiga Jisösnöŋ miaŋgöreŋök gwarekurupŋi jim kutum eŋgiba kewö jiyök, “Iŋini mönö waŋgenöŋ öŋgöba qeljiŋe o aŋgö kutuba likepŋe Betsaida mire anme. Nöŋön ölöp nalö sutŋe ambazip kambu ki melaim eŋgibagun kamam.” ");
INSERT INTO bmu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mewö jiba yaizökzök jim eŋgiba eŋgubula kunduŋe öŋgöba köuluköyök. ");
INSERT INTO bmu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Köuluköba mali mare ahiga nanŋik kötikŋi kunduŋe maliga waŋgeŋinan aŋgö bibiŋe anök. ");
INSERT INTO bmu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ani lökuatnöŋ qeba qem bibihiba naŋgöget aniga luhutnöŋ angeraŋgöreŋök gila kai lömböriiga bömbömgöget. Miri awöraŋgöiga (3-6 kilok) miaŋgöreŋ Jisösnöŋ mewö eŋgeka o aŋgö qakŋe tiba tiba gwarekurupŋi yeŋgöreŋ Kaba eŋgoŋgitmamgö ahök. ");
INSERT INTO bmu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","O aŋgö qakŋe tiba tiba kaiga eka “Köwet Soŋgoriŋnöŋ kaza!” jiba könahiba qeta silatket. ");
INSERT INTO bmu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Qeta silata körek i eka keŋgötporiŋ aketmö, Jisösnöŋ miaŋgöreŋök keukeu jiba kewö jii mötket, “Alaurupni! Mönö ewebibiŋinambuk saitiŋgit malme. Nanak kazal. Keŋgötŋini kude mötme.” ");
INSERT INTO bmu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mewö jiba yeŋgöreŋ waŋgenöŋ öŋgöiga luhutnöŋ nöŋ qeba göröŋ alök. Göröŋ aliga jönömŋini undui önöŋi qahö auruget. ");
INSERT INTO bmu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mutuk beret mem sehiba gumohom eŋgiyöhi, miaŋgö könaŋi qahö möt asarigetmö, uruŋinan gwözöŋniga tok auruba tatket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","O aŋgö kutuba likepŋe Genesaret mire aŋgota waŋge mosöta saknöŋ geget. ");
INSERT INTO bmu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Waŋge mosöta Saknöŋ gegetka ambazipnöŋ Jisös miaŋgöreŋök möt kutum waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Möt kutum waŋgiba keu algetka kiŋkiŋgöba mindimindiri sel gölmeŋine miri dop liliköget. Lilikögetka möta könahiba kawöl ambazip kululunöŋ aŋgum eŋgiba Jisösnöŋ miri denike malöhaŋgö dop eŋguaŋgita kaget. ");
INSERT INTO bmu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Miri dop, taon, miri me koum kungö uruŋe anöhaŋgö dop kawöl ambazip eŋguaŋgita sombemŋine al eŋgiget. Al eŋgiba sileŋe me Jisös malukuŋaŋgö suŋe misiribingö ulet waŋgiba malget. Misirigeri, körek yeŋön mönö ölöwak teköget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Köna keugö kapaŋkölköl aka miaŋgö böhi tosatŋi Jerusalem sitinöhök kageri, yeŋön Jisösgöreŋ kaba tokoget. ");
INSERT INTO bmu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nalö miaŋgöreŋ Jisösgö gwarekurup tosatŋan böröŋini kude saŋgoŋda dom amöt qahö qeba nene negetka eŋgeka uruŋini böliyök. ");
INSERT INTO bmu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi (Köna keugö kapaŋkölköl) aka Juda ambazip tosatŋi pakpak yeŋön ambösakon yeŋgö silikŋini wuataŋgöba malget. Miaŋgöra böröŋini mutuk saŋgoŋ soroköbagun nene nemalget. ");
INSERT INTO bmu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mewöyök nupnöhök me maketnöhök kamei, mutuk o utuba arim tönjöratagun nene misirimalget. Mewöyök kiwi qambi, közökimbut aka jout pakpak mi saŋgoŋda amöt qemalget. Silik mewöŋi mewöŋi mi gwötpuk wuataŋgöba malget. ");
INSERT INTO bmu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Miaŋgöra Köna keugö kapaŋkölköl aka miaŋgö böhi yeŋön Jisös kewö qesim waŋgiget, “Göhö gwarekurupkan wuanöŋgöra ambösakoninaŋgö silikŋini qahö wuataŋgöba böröŋini domamöt qahö qeba töndup nene neze.” ");
INSERT INTO bmu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mewö qesim waŋgigetka kewö jii mötket, “O urumeleŋgö silesile ambazip, kezapqetok azi Aisaianöŋ mönö eŋgö könaŋamŋini törörök indela Buzup Kimbi kun kewö ohoi ahöza, ‘Ambazip kambu kiaŋön mönö numbu jitŋinan ölöpŋanök göda qem niŋgimakzemö, uruŋinan nönöŋgan ak niŋgiba kungen algetka köröwen ahöza. ");
INSERT INTO bmu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mewö ahöiga nöŋgö waikni öne töhön memba möpöseim niŋgimakze. Köna keu kusum eŋgibin, jiba salupŋe ambazip yeŋgö jimkutukutuŋini mi numbu o alakze.’ ");
INSERT INTO bmu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisaianöŋ mewö ohoyök. Iŋini mönö miaŋgö dop Anutugöreŋ jöjöpaŋ keu andö qeba ambösakonŋinaŋgö silikŋi wuataŋgömakze. Mi qahö dop kölja.” ");
INSERT INTO bmu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mewö jiba kewö jiyök, “Nanŋini silikŋini walŋi wuataŋgöbingöra mönö ölöpŋanök Anutugöreŋ jöjöpaŋ keu qeapkömakze. ");
INSERT INTO bmu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Miaŋgö keuŋi kun kewö: Mosesnöŋ kewö jim kutuyök, ‘Iwinamgi mönö göda qem etkimakŋan,’ aiga ‘Kunŋan iwiŋi me namŋi qesuahömawi, i mönö qegetka kömuma.’ ");
INSERT INTO bmu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mewö jim kutuyökmö, iŋini keu mi oŋgita kewö jimakze, ‘Kunŋan iwinamŋi yetköra kewö jima. Wösöni mötzal. Nöŋgö naŋgönaŋgö yuaini buŋa qem aŋgubahorak, mi lök Anutugö daŋge tahaya albi ahöza. Mi saiwap naluköra kewöta albi ahöza. ");
INSERT INTO bmu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kunŋan mewö jiiga dop kölma.’ Mewö jiba jöhöm waŋgigetka iwinamŋi yetköra baukbauk kun qahö toroqeba etkimakŋa. Mi qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yei! Mewö aka nanŋini ahakmemeŋinaŋgö silikŋini jim kutuba miaŋön Anutugöreŋ jöjöpaŋ keu utala omaŋi aka pömsöm qemakza. Iŋini yuai mewöŋi gwötpuk ahakze.” Mewö meleŋ eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisösnöŋ ambazip kambu kunbuk eŋgoholi kagetka kewö jii mötket, “Iŋini mönö körek keu ki kezap ala möt asarime. ");
INSERT INTO bmu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Azi yaigepŋeyök yuai uruŋe gemakzawi, miaŋön mönö tölohom waŋgimamgö osimakzapmö, nanŋi urukönömŋeyök keu kota erakzawi, miaŋön mönö tölohom waŋgimakza. ");
INSERT INTO bmu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kunŋan kezapŋambuk malja ewö, yaŋön mönö keu ki kezap ala möt kutuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisösnöŋ mewö jiba ambazip kambu eŋgömosöta anda miri kunöŋ öŋgöyök. Öŋgöba tariga gwarekurupŋan dopkeu miaŋgö könaŋaŋgöra qesiget. ");
INSERT INTO bmu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Qesigetka kewö jii mötket, “O alaurupni, iŋini mewöyök mötmötŋini ölöpŋi qahö akze me? Nene yuai azi yaigepŋeyök uruŋe gemakzawi, mi tölohom waŋgimamgö osimakza. Mi möt kutuze me qahö? ");
INSERT INTO bmu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mi urukönömŋe qahö gemakzapmö, kömgokŋe geba yaigep erakza.” Jisösnöŋ keu mewö jiba miaŋön “Numbu nene pakpak mem sarahim teköyök.” ");
INSERT INTO bmu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisösnöŋ toroqeba kewö jiyök, “Azi urukönömŋeyök keu kota erakzawi, miaŋön mönö tölohom waŋgimakza. ");
INSERT INTO bmu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ambazip uru könömŋineyök yuai kewöŋi asuhuba korakza: Keu bölöŋi mötmöriba serowilin akingö mörakze. Yoŋgorö memba suŋa jinaŋ memba ambazip eŋguget kömumegö mörakze. ");
INSERT INTO bmu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Qesabulum akingö mörakze. Membagu membingö nepaqepalok köpösöŋgömakze. Bidaŋda gatmisimisi, jiliwitiŋ aka isimkakalek akingö mörakze. Lösö jiba urupik akingö mörakze. Kezapjupjup aka körögisigisi akingö mörakze. Söŋgöröqök mala andöqeqe keu yöhösaŋ jiba Anutu mepaiköbingö mörakze. Jakbak-öraŋböraŋ aka uruqahö ahakze. ");
INSERT INTO bmu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yuai bölöŋi pakpak miaŋön mönö ambazip uru könömŋineyök kota ambazip tölohom eŋgimakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisösnöŋ wahöta Genesaret gölme mosöta siti qetŋiri Taiö aka Saidon mietkö distrik qetŋi Fonisia miaŋgö uruŋe anök. Anda miri kunöŋ öŋgöba buzupŋi kunŋan mötpapuköra numbuŋini muhungöyökmö, töndup tölapŋe malmamgö osiyök. ");
INSERT INTO bmu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Osiiga miaŋgöreŋök ambi kun böratŋi moröŋan ömeŋambuk maliga Jisösgö buzupŋi möta yaŋgöreŋ kaba könaŋe geba simin kölök. ");
INSERT INTO bmu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ambi mi Judaya qahöpmö, Grik keu jiba malök. Iwinamŋan Siria prowinsgö Fonisiagöra. Yaŋön böratŋaŋgö uruŋeyök öme közölmapköra ulet waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ulet waŋgiiga kewö jii mörök, “Juda nini mutuk nanine nahönböraturupnini gumohom eŋgiinga bikŋi eŋguma. Miaŋgöra morö yeŋgö miriŋineyök beret memba kiam eŋgiinga qahö dop kölbapuk. Juda nini kianurup eŋgö qetŋini kiam qerakzin. Nöŋön mutuk Juda ambazip bauköm eŋgibiga kantri tosatŋi eŋön mönö kiamgö dop mamböta malme.” ");
INSERT INTO bmu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mewö jii möta kewö meleŋnök, “Kembu, mi ölöp mötzalmö, kiam moröŋi yeŋön mönö mewöyök morö yeŋgöreŋ nene boromŋi tebol bapŋe eriga nemakze.” ");
INSERT INTO bmu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mewö meleŋniga Jisösnöŋ kewö jii mörök, “Keu mewö jizanaŋgöra ölöp möt gihizal. Öme miaŋön mönö dölki böratki mosöta anja. Miaŋgöra ölöp anman.” ");
INSERT INTO bmu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mewö jii möta miriŋe ani ömenöŋ böratŋi mosöriga dumŋe ahöiga ehök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisösnöŋ kunbuk Taiö siti gölme mosöta Saidon sitinöŋ anda oŋgita mösököba Ten-taon gölmegö bibiŋi oŋgita Galiligö o aŋgö kösutŋe kayök. ");
INSERT INTO bmu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kaiga kezapduhup azi kun keuŋi qahöwakŋapköra ahöhi, mi waŋgita Jisösgöreŋ kaget. Kaba böröŋi nöröpŋe almapköra qesim waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Qesim waŋgigetka azi mi waŋgita ambazip kambu mosöta kungen anohot. Anda Jisösnöŋ börö suapŋi kezapŋe ala kinda kunbuk nanŋi börö suapŋe söutköba nesilamŋe misiriyök. ");
INSERT INTO bmu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Misiriba suepnöŋ ui öŋgöiga osoŋgombuk köuluköba nanŋe keunöŋ “Efata,” nanine keunöŋ Tohonöŋ! mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mewö jiiga kezapyahötŋan tohoyohotka nesilamŋan lolohoiga keuŋi ölöpŋanök jiyök. ");
INSERT INTO bmu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jiiga Jisösnöŋ miaŋgö buzupŋi ambazip jiget mötpepuköra qetal eŋgiyök. Qetal eŋgiba kapaŋ köliga yeŋön mi kapaŋ köla jim sehiba malget. ");
INSERT INTO bmu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jim sehiba malgetka ambazipnöŋ kamböŋda welipköba kewö jiget, “Yuai pakpak ölöpŋanök ahakza. Kezapduhup kezapŋini metohoiga mötketka ambazip mötökŋi yeŋgö nesilamŋini pösariga keu jimakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nalö miaŋgöreŋ ambazip kambu ketaŋan dumŋe kunbuk tokoget. Neneŋini qahö malgeraŋgöra Jisösnöŋ gwarekurupŋi eŋgoholi yaŋgöreŋ kagetka kewö jii mötket, ");
INSERT INTO bmu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nöŋön ambazip kambu kieŋgöra wösöni mötzal. Yeŋön nöŋgöreŋ kaba wehön karöbut lök mala kotketka neneŋini qahöwahiga ekzal. ");
INSERT INTO bmu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yeŋgöreŋök tosatŋan köröwenök kaba malgetka nöŋön ‘Ölöp miriŋine anme,’ jibi nene qahö negetka öne melaim eŋgibiga könanöŋ anda mala kembaŋe jeŋini gili tirinbirin akepuk.” ");
INSERT INTO bmu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mewö jiiga gwarekurupŋan meleŋda kewö jiget mörök. “Gölme qararaŋkölkölŋe kiaŋgöreŋ kunŋan mönö denikeyöhök numbu nene mewöŋi mi mönö miwikŋaiba kambu ki gumohom eŋgibawak?” ");
INSERT INTO bmu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mewö möta kewö qesim eŋgiyök, “Eŋgöreŋ beret dawik ahöza?” Qesim eŋgiiga “Beret 7 ahöza,” jiget. ");
INSERT INTO bmu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jigetka Jisösnöŋ ambazip kambu mi gölmenöŋ geba tatmegöra jim kutum eŋgiiga geba tatket. Geba tatketka beret 7 mi memba Anutugö saiwap jiba mindipköba gwarekurupŋi eŋgiba ambazip kambu dop sutŋine almegöra jiyök. Mewö jiiga miaŋgö dop alget. ");
INSERT INTO bmu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yeŋgöreŋ söra morömorö tosatŋi mewöyök ahöyök. Mi tok memba kötuetköba ambazip kambu dop sutŋine toto qem eŋgimegöra jim kutuyök. ");
INSERT INTO bmu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jim kutuiga eŋgiget nemba nem timbireŋgöget. Nem timbireŋgöba nene kitipŋi mosötket geyöhi, mi sakap 7 miaŋgöreŋ qezakögetka numbuŋe qeyök. ");
INSERT INTO bmu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Azi nene negeri, yeŋgö jaŋgöŋi mi 4000. Negetka melaim eŋgiiga miriŋine anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Angetka miaŋgöreŋök gwarekurupŋi yembuk waŋgenöŋ öŋgöba distrik qetŋi Dalmanuta miaŋgöreŋ anget. ");
INSERT INTO bmu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi (Köna keugö kapaŋkölköl) tosatŋan miaŋgöreŋ kaba Jisösbuk könahiba jitnakölik aket. Keu bötaknöŋ örömapköra esapköm waŋgiba kewö kapaŋ köla qesiget, “Mönö jinöŋga Suepnöhök aŋgöletot kun asuhuiga ekin.” ");
INSERT INTO bmu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mewö jigetka uruŋan lömböriiga osoŋgombuk qeiga jiyök, “O ambazip nalö kewöŋe gölmenöŋ maljei, iŋini mönö wuanöŋgöra Anutugö aiwesök asuhumapköra kapaŋ kölakze? Nöŋön keu ölŋi kun kewö jibi mötme: Anutunöŋ aiwesök mewöŋi mi qahö memba kondel eŋgima. Ombaŋ saumbaŋ!” ");
INSERT INTO bmu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mewö jiba eŋgömosöta kunbuk gwarekurupŋi yembuk waŋgenöŋ öŋgöba aŋgö kutuba likepŋe aŋgotket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Miaŋgöreŋ aŋgota semön membingö ölum eŋguiga beret mohot-töp mia waŋgenöŋ memba tatket. ");
INSERT INTO bmu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tatketka Jisösnöŋ kewö jim kutum eŋgiyök, “Iŋini Köna keugö kapaŋkölköl (Farisi) yeŋgö wösökömbukŋini aka Herodkö gipmi kakŋi mietköra mönö galömŋini meme. Mi ölöpŋaŋök qahö kewöta andö qegetka mietkön mönö yist ewö qariba mem bölim eŋgimahot.” ");
INSERT INTO bmu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jiiga keu pasetŋi mi qahö möt asariba sutŋine kewö eraum mötket. “Beretnini qahöpköra jiza me denöwö?” ");
INSERT INTO bmu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mi eraum mötket kezapŋe geiga kewö jii mötket, “Wuanöŋgöra beretnini qahö jiba eraum mötze? Nöŋgö könaŋamni mi wuanöŋgöra qahö möt kutuze? Mi tok qahö möt asarize me? Urukezapŋinan gwözöŋda tatza me? ");
INSERT INTO bmu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jeŋini ahözapmö, töndup qahö ek kutuze me? Kezapŋini ahözapmö, töndup qahö möt asarize me? Yuai asuhuyöhi, mi ölum eŋguza me qahö? ");
INSERT INTO bmu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nöŋön beret 5 mi 5000 yeŋgöra mindipköbiga miaŋgö kitipŋi qezakögetka könde dawiknöŋ geba numbuŋine qeyök?” Qesim eŋgiiga “Könde 12,” jiget. ");
INSERT INTO bmu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jigetka toroqeyök, “Nöŋön beret 7 mi 4000 yeŋgöra mindipköbiga miaŋgö kitipŋi qezakögetka sakap dawiknöŋ geba kokolak qeyök?” Qesim eŋgiiga sakap 7 jiget.” ");
INSERT INTO bmu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jigetka jii mötket, “Miaŋgöra könaŋamni mi mönö tok qahö möt asarize me?” Mewö ");
INSERT INTO bmu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisösnöŋ gwarekurupŋi yembuk Betsaida taonöŋ kaget. Miaŋgöreŋ kaba jegömöl azi kun waŋgita Jisösgöreŋ kaŋgota böröŋan misirimapkö köuluköm waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Köuluköm waŋgigetka jegömöl azi mi böröŋe memba waŋgita miri yaigepŋe anohot. Anda söutnezit jeŋe ala böröŋi nöröpŋe ala qesim waŋgiyök, “Yuai kun ekzan me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Qesim waŋgiiga jeŋi ui öŋgöiga jiyök, “Ambazip eŋgekzalmö, mi ip tandöktandök aketka imutimutŋanök eŋgekiga anda kaba kinje.” ");
INSERT INTO bmu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mewö jiiga kunbuk böröŋan jeyahötŋi misiriiga tohoyohotka törörök uiga asarim sölölöŋgöiga yuai pakpak ölöpŋanök ek teköyök. ");
INSERT INTO bmu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ek teköiga melaim waŋgiba kewö jii mörök, “Gi miri kungen kude anmanmö, diŋdiŋanök nangi mirige anman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisösnöŋ Betsaida mosöta gwarekurupŋi yembuk Sisarea Filipai taongö kösutŋe anget. Könanöŋ anda gwarekurupŋi kewö qesim eŋgiyök, “Ambazipnöŋ nöŋgöra denöwö jimakze? Ni niŋia akzal?” ");
INSERT INTO bmu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jiiga meleŋda kewö jiget, “Tosatŋan ‘Gi Jon O-melun azia akzan,’ jimakzemö, tosatŋan ‘Gi Elaija akzan,’ jimakze aka tosatŋan toroqeba kewö jimakze, ‘Gi kezapqetok azi walŋi yeŋgöreŋök kun akzan.’ ");
INSERT INTO bmu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mewö jigetka kewö qesim eŋgiyök, “Aka nanŋinak nöŋgöra denöwö jize? Ni niŋia akzal?” Qesim eŋgiiga Pitönöŋ kewö meleŋnök, “Gi Anutugöreŋ Amötqeqe Toŋi Kraist akzan.” ");
INSERT INTO bmu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mewö jiiga könaŋi aukŋe jiget kunŋan mötpapuköra soŋgo köhöikŋi al eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisösnöŋ gwarekurupŋi könahiba kewö kusum eŋgiyök, “Suep gölmegö azi ölŋan mönö sihimbölö gwötpuk mötma. Kantrigö jitŋememe, jike nup galöm aka Köna keugö böhi yeŋön mönö andö qeba qegetka kömuma. Kömui wehön karöbut teköiga kömupnöhök wahötma.” ");
INSERT INTO bmu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisösnöŋ keu mi qahö köyatiba aukŋe jiiga Pitönöŋ miaŋgöreŋök öröm waŋgiba göraŋe anda könahiba qetal waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Qetal waŋgiiga liliŋgöba gwarekurupŋi uba eŋgeka Pitö qetala kewö jim waŋgiyök, “Gi keu mötmörizani, mi Anutugöreŋ keuya qahöpmö, gölme ambazip aka Satangö sihima. Miaŋgöra Satan, gi mönö dölki nöŋgö jemesoholneyök kesalnöŋ.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jisösnöŋ ambazip kambu aka gwarekurupŋi eŋgoholi kagetka keu kewö jii mötket, “Kunŋan nöŋgö andöne kamamgö mötzawi, yaŋön mönö nanŋi urusileŋaŋgö sihim kömbönaŋi bölöŋi andö qeiga sisitŋi megetka sihimbölö mi bisimakŋa. Mi maripomnöŋ kömumawaŋgö dop mökösöŋda ni nuataŋgöba kama. ");
INSERT INTO bmu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kunŋan malmalŋi nanŋaŋgöra aŋgön köla nanŋi imbi-imbi maljawi, yaŋön mönö malmalŋi ölŋi jöhöi sohoma. Sohomapmö, kunöŋ gölmegö malmalŋi mi ni aka nöŋgö Ölöwak Buŋanaŋgöra aka köleŋda tököm niŋgimawi, yaŋön mönö malmal ölŋaŋgö könaŋi miwikŋaiba köhöiba malma. ");
INSERT INTO bmu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kunŋan gölmeŋi gölmeŋi mieŋgö öröyuaiŋi pakpak köl öröi buŋaŋi an teköiga uruŋaŋgö malmalŋi mem sohoba silebile mala kömuiga Anutunöŋ keuŋi jim teköiga uŋaŋan ayuhuiga qahö dop kölma. Sukinapŋi miaŋön mönö urusösöŋgai qahö ak waŋgima. Qahöpmahöp! ");
INSERT INTO bmu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Körek neŋön mönö bohonini jöhöbingö osibin. ");
INSERT INTO bmu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ambazip kambuŋi kambuŋi nalö kewöŋe gölmenöŋ qesabulum aka siŋgisöndok tosatŋi aka malakze. Kunŋan yeŋgö sutŋine nöŋgö qetni aka Buŋa keuni memba et aljawi, mi Suep gölmegö azi ölŋan mewöyök ehöröŋ kölma. Yaŋön könaŋgep Suep garata töröŋi yembuk ki etketka Iwiŋaŋgö asakmararaŋi eka aurugetka yaŋön azi me ambi mewöŋi mönö ehöröŋ köl waŋgima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mewö jiba kewö jii mötket, “Nöŋön keu ölŋi kun kewö jibi mötme: Kiaŋgöreŋ kinjei, eŋgö sutŋineyök tosatŋan Anutunöŋ bemtohoŋi kuŋguiga kukösumŋan asuhumawi, mi ek kutume. Jebuk mala kömupkö sihimbölöŋi qahö mötketka asuhum tiŋgiriga ekŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wehön 6 teköiga Jisösnöŋ Pitö, Jeims aka Jon eŋguaŋgita ambazip eŋgömosöta nanŋinök kunduŋi köröpŋi kunöŋ öŋgöba kötikŋe malget. Miaŋgöreŋ malgetka jemesoholŋine kiniga Jisösgö sile tandökŋan letota murutŋi ahök. ");
INSERT INTO bmu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Malukuŋan tuat lalamŋi asakmararaŋambuk ahök. Gölmenöŋ opo tuatŋi saipenöŋ (omo bliz) saŋgoŋmakzei, mönö mi oŋgita tuariyök. ");
INSERT INTO bmu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mewö aiga Elaija aka Moses yetkön asuhum eŋgiba Jisösbuk keukeu jiget. ");
INSERT INTO bmu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jigetka Pitönöŋ könahiba keu jiba Jisösgöra kewö jiyök, “Ketaŋamnini! Neŋön kiaŋgöreŋ uruölöwak mötzin. Miaŋgöra neŋön ölöp koum karöbut qebin: Göhö kun, Mosesgö kun aka Elaijagö kun.” ");
INSERT INTO bmu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Gwarek yeŋön jönömŋini gwötpuk unduiga Pitönöŋ “Denöwö jimam,” jiba keu jaruyök. ");
INSERT INTO bmu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Keu jaruba kiniga unuŋunuŋ tuat lalamŋi asakmararaŋambuk kunöŋ eta aumŋan esuhum eŋgiiga miaŋgö uruŋeyök qet kun kewö eriga mötket, “Azi ki nani wölböt nahöna akza. Mönö yaŋgö keuŋi möta malme.” ");
INSERT INTO bmu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Keu mi möta könöpuk liliŋgöm purik um jaruba tosatŋi kunbuk qahö etkeketka Jisösnöŋ nanŋök yembuk kinök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kunduŋeyök etketka Jisösnöŋ sörökŋi miaŋgöreŋ kewö jim kutum eŋgiyök, “Iŋini yuai ekzei, miaŋgö buzupŋi mi mönö ambazip kun kude jiget mötme. Suep gölmegö azi ölŋan kömupnöhök wahöriga miaŋgö andöŋe mi ölöp jim asariba malme.” ");
INSERT INTO bmu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mewö jim kutum eŋgiiga gwarekurupŋi karöbut yeŋön keu mi uruŋine aŋgön köla “kömupnöhök wahötwahötkö” könaŋi mi nanŋini qesim aŋguba eraum mötket. ");
INSERT INTO bmu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eraum möta Jisös kewö qesim waŋgiget, “Köna keugö böhi yeŋön mönö keu kewö jimakze, ‘Kezapqetok azi Elaijanöŋ mönö Suepnöhök mutuk eta asuhuma.” ");
INSERT INTO bmu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Qesim waŋgigetka meleŋda kewö jiyök, “Elaijanöŋ mutuk eta asuhuba malmal pakpak möhamgöma. Keu mi ölŋa akzapmö, keu kun ki mönö wuanöŋgöra ohoget ahöza: Suep gölmegö azi ölŋan mönö sihimbölö gwötpuk möriga jijiwilit ak waŋgime.” ");
INSERT INTO bmu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Keu yahöt mi ahözahotmö, nöŋön kewö jibi mötme: Elaijanöŋ lök eta asuhuyökmö, yaŋgöra Buŋa keu ohoget ahözawaŋgö dop ambazipnöŋ i nanŋini sihimŋini wuataŋgöba laŋ ak waŋgiget.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisös aka gwarek karöbut yeŋön kunduŋeyök eta gwarekurupŋi tosatŋi yeŋgöreŋ kaba yuai kewö eket: Köna keugö böhi tosatŋan kinda yembuk jitnakölik aka goranora keu jigetka ambazip jesöŋgöŋan liliköba eŋgeka kinget. ");
INSERT INTO bmu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mewö kinda ambazip kambu pakpak yeŋön Jisös eka miaŋgöreŋök auruba kiŋkiŋgöba kösutŋe anda jölöŋi jiget. ");
INSERT INTO bmu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jölöŋi jigetka kewö qesim eŋgiyök, “Iŋini wanatköra yembuk jitnakölik aka goranora keu jize?” ");
INSERT INTO bmu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Qesim eŋgiiga kambuŋineyök azi kunöŋ meleŋda kewö jii mörök, “Böhi! Nöŋgö nahöni ömenöŋ numbuŋi muhungöba töŋöt mem waŋgiiga waŋgita göhöreŋ kazal. ");
INSERT INTO bmu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mi miaŋgöreŋ me miaŋgöreŋ memba mendawöla öröm giliga eta qeba numbuŋeyök qölqöl söutsöut eriga irimŋi yöhözömgöba sileŋan sölöpkömakza. Mewö ahiga kaba göhö gwarekurupki ulet eŋgiba öme mi wuataŋgömegö jizalmö, yeŋön osize.” ");
INSERT INTO bmu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mewö jiiga meleŋ waŋgiba jiyök, “Gölmegö yaŋgiseŋ ambazip yei! Mönö nalö dawik embuk mala qatön eŋgubiga Anutu qahö möt narigetka sihimbölö mötmam. I mönö waŋgita nöŋgöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mewö jiiga waŋgita yaŋgöreŋ kaget. Kagetka ömenöŋ Jisös eka miaŋgöreŋök morö utuköba urepköm waŋgiiga wölöhariba tala gölmenöŋ qeba pöraŋpöraŋ mitiba semben auba ahöiga numbuŋeyök qölqöl söutsöut kota erök. ");
INSERT INTO bmu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisösnöŋ mi eka iwiŋi kewö qesim waŋgiyök, “Nalö dawikö dop yuai ki lök asuhum waŋgiiga kotza?” Qesim waŋgiiga jiyök, “Mi lök morörökŋeyök asuhum waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mi mem bölim waŋgimamgöra nalö tosatŋe könöpnöŋ, nalö tosatŋe onöŋ metal waŋgiiga nalö gwötpuk geba qebayök kinahakza. Mewömö, miaŋgö kukösumŋi kun göhöreŋ ahöza ewö, mönö ak kömumba bauköm netkiman.” ");
INSERT INTO bmu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mewö jiiga jiyök, “‘Kukösumŋi göhöreŋ ahöza ewö,’ jizan. Anutugö kukösumŋan mönö yuai kungöra qahö qakömakza. Anutu möt narizawaŋön mönö yuai pakpak ölöp ahakŋa.” ");
INSERT INTO bmu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mewö jiiga iwiŋan miaŋgöreŋök qeta jiyök, “Anutu möt narizalmö, mötnaripnan lölöwöröŋi akza. Mötnaripni mönö mem köhöiman.” ");
INSERT INTO bmu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jiiga ambazip jesöŋgöŋan ösumŋinan kaba kingetka eka miaŋgöra öme mi kewö jim waŋgiyök, “Gi töŋöt aka kezapduhupkö ömeŋi, nöŋön jim kutum gihizal: Gi mönö azi ki mosöta kota anda kunbuk kude liliŋgöba kaman.” ");
INSERT INTO bmu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jim waŋgiiga qeta silata morö mi utuköba könöpuk urepköm waŋgii wölöhariiga utala kota anök. Kota aniga qeba qamöt tandök aka ahöiga gwötpukŋan mi eka “Wösöŋi alja!” jiget. ");
INSERT INTO bmu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mewö jigetmö, Jisösnöŋ böröŋe memba köbibiiga wahöta kinök. ");
INSERT INTO bmu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mewö kiniga Jisösnöŋ miri uruŋe öŋgöiga gwarekurupŋan nanŋinök tata kewö qesim waŋgiget, “Neŋön mönö wuanöŋgöra mi naninök wuataŋgöbingö osizin?” ");
INSERT INTO bmu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Qesim waŋgigetka kewö jii mötket, “Öme tandökŋi mewöŋi mi mönö köuluköba nene siŋgi mala wuataŋgöbin. Yuai murutŋi kun ahinga qahö kota anma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisösnöŋ gwarekurupŋi yembuk miri gölme mi mosöta anda Galili prowins uruŋe liliköba denike malgeri, mi kunŋan mötmapkö tököyök. ");
INSERT INTO bmu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mia tököba gwarekurupŋi kusum eŋgimamgöra ölöŋ anget. Könanöŋ anda keu kötŋi kewö jii mötket, “Anutunöŋ Suep gölmegö azi ölŋi mi gölme ambazip yeŋgö böröŋine al waŋgii gema. Geiga i qegetka kömuma. I qeget kömui wehön karöbut teköiga miaŋgöreŋ mönö kömupnöhök wahötma.” ");
INSERT INTO bmu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Keu kötŋi mewö jii mötketmö, mi qahö möt kutuget aka könaŋi denöwö, mi qesibingö kölköldömdöm aket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mewö anda Kaperneam taonöŋ kaŋgotket. Miaŋgöreŋ kaŋgota nanŋi miri uruŋe öŋgöba gwarekurupŋi kewö qesim eŋgiyök, “Iŋini Könanöŋ kaba wani keuya eraum mötze?” ");
INSERT INTO bmu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yeŋön könanöŋ kaba ‘Daŋön öŋgöŋgöŋi akza’ mia nanŋinök eraum möta kaget. Miaŋgöra qesim eŋgiiga keu bök tatket. ");
INSERT INTO bmu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Keu bök tatketka Jisösnöŋ geba tata gwarekurupŋi 12 eŋgoholi kagetka kewö jii mötket, “Kunŋan mutukŋi malmamgö mötza ewö, yaŋön mönö körek eŋgö nembö bapŋine eta qöndökŋi aka tosatŋi pakpak welen qem eŋgimakŋa.” ");
INSERT INTO bmu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mewö jiba namande moröŋi kun memba sutŋine ali kinök. Kiniga böröŋan memba tambuŋe ala kewö jii mötket, ");
INSERT INTO bmu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kunŋan namande kewöŋi kun nöŋgö qetne miriŋe köl öröba köyan kölmawi, yaŋön mönö ni köl öröm niŋgima. Kunŋan mewö ak niŋgizawi, yaŋön niyök qahöpmö, daŋön melaim niŋgiyöhi, mönö i mewöyök köl öröm waŋgima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jonöŋ Jisös kewö jii mörök, “Böhi! Nini azi kun neŋgö andönine qahö kayöhi, yaŋön göhö qetnöŋ ömewöröme közöl eŋgiiga ehin. Yaŋön nembuk qahö liliköba maljawaŋgöra nini i qetal waŋgiin.” ");
INSERT INTO bmu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mewö jiiga Jisösnöŋ jiyök, “I kude qetal waŋgime. Kunŋan nöŋgö qetni qeta aŋgöletot mezawi, yaŋön mönö miaŋgö andöŋe nöŋgö andöqeqe keu awamŋanök jimamgö osima. ");
INSERT INTO bmu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kunŋan qahö qetal neŋgimakzawi, yaŋön mönö neŋgö areŋnöŋ malja. (Miaŋgöra nöŋgö alaurupni tosatŋi mi kude qetala aŋgösirip meme.) ");
INSERT INTO bmu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","I mönö naŋgöm eŋgigetka Anutunöŋ töwaŋini eŋgima. Kunŋan Kraistkö qetŋe yaŋgö buŋaŋi akzeaŋgöra aka o qambi nemegö eŋgimawi, Anutunöŋ mönö miaŋgö töwaŋi meleŋda waŋgima. Nöŋön keu ölŋi kun kewö jibi mötme: Naŋgöm eŋgimei, mieŋön mönö töwa meme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisösnöŋ keu kewö jiyök, “Morö kewöŋi möt narim niŋgizei, kunŋan yeŋgöreŋök kun kölgorom ak waŋgiiga siŋgisöndok akŋawi, azi miaŋön mönö lömböt öŋgöŋgöŋi miwikŋaima. Anutunöŋ lömböt miaŋgö likepŋi denöwö waŋgiiga dopŋe akawak? Kemuŋ jamönjiŋ jölŋe jöhöba köwet röndumnöŋ gilget mulumgöi gebawak, miaŋön mönö awamŋi ahum waŋgii tandök akawak. ");
INSERT INTO bmu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Miaŋgöra börögan siŋgisöndok akŋangö kölgorom ak gihima ewö, mönö yandim gilman. Yandim gilagun börötak mala malmal köhöikŋi miwikŋaiba oyaeŋkoyaeŋ akŋanmö, börö yahötpuk mala könaŋgep könöp sianöŋ gebanbuk. Sia könöpŋi mi nalö kunöŋ qahö bököma. ");
INSERT INTO bmu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Miaŋgöreŋ ‘Döhöŋini eŋgöhöm pilikuta mala qahö kömume aiga könöpŋinan nalö kunöŋ kude bököma.’ ");
INSERT INTO bmu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mewöyök könagan siŋgisöndok akŋangö kölgorom ak gihima ewö, mönö yandim gilman. Yandim gilagun könatohot mala malmal köhöikŋi miwikŋaiba oyaeŋkoyaeŋ akŋanmö, köna yahötpuk malnöŋga könöp sianöŋ gil gihigetka gebanbuk. ");
INSERT INTO bmu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Miaŋgöreŋ ‘Döhöŋini eŋgöhöm pilikuta mala qahö kömume aiga könöpŋinan nalö kunöŋ kude bököma.’ ");
INSERT INTO bmu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mewöŋanök jegan siŋgisöndok akŋangö kölgorom ak gihima ewö, mönö qözöla gilman. Qözöla gilagun je-ilik mala Anutugö bemtohoŋnöŋ aŋgota oyaeŋkoyaeŋ akŋanmö, je yahötpuk malnöŋga könöp sianöŋ gil gihigetka gebanbuk. ");
INSERT INTO bmu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Miaŋgöreŋ ‘Döhöŋini eŋgöhöm pilikuta mala qahö kömume aiga könöpŋinan nalö kunöŋ kude bököma.’ ");
INSERT INTO bmu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Könöp sia miaŋgöreŋ ambazip körek mi howe sihi kölköl ewö könöpnöŋ eŋgohogetka sihimbölöŋi mötme. ");
INSERT INTO bmu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Howe mi ölöpŋi akzapmö, howegö sihimŋi mosötma ewö, mi mönö denöwö möhamgögetka nahömŋi kunbuk ahubawak? Iŋini mewöŋanök urumohot malmalgö nahömŋi mosötpepuk. Miaŋgöra Suep howeŋini mosötpepuköra mönö galömŋini memba sutŋine luai qem aŋguba malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisösnöŋ wahöta Kaperneam miri mosöta Jordan o kutuba likepŋe anda mötöteiba eta kunbuk o mi kutuba Judia prowinsnöŋ kayök. Kaiga ambazip kambulelembenöŋ kunbuk yaŋgöreŋ tokogetka akmalöhi, miaŋgö dop kunbuk kusum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kusum eŋgiiga Farisi (Köna keugö kapaŋkölköl) tosatŋan yaŋgöreŋ kaba keugö bötaknöŋ örömapkö esapköm waŋgiba kewö qesim waŋgiget, “Azinöŋ anömŋi mosötmawi, mewö miaŋön Köna keu oŋgitma me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Qesim waŋgigetka meleŋda kewö jii mötket, “Mosesnöŋ miaŋgö keuŋi denöwö jim kutum eŋgiiga ahöza?” ");
INSERT INTO bmu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mewö jii möta kewö jiget, “Azinöŋ aŋgömosötmosöt papia ohoba anömŋi ölöp mosötma. Mosesnöŋ mewö jim kutui ahöza.” ");
INSERT INTO bmu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mewö jigetka kewö jim eŋgiyök, “Yaŋön mönö uruköhöikŋinaŋgöra aka jimkutukutu mewö ohom eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ohom eŋgiyökmö, Anutunöŋ könakönahiŋe yuai pakpak miwikŋaiyöhi, nalö miaŋgöreŋök ‘Azi aka ambi malmegöra miwikŋaim eŋgiyök.’ ");
INSERT INTO bmu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Miaŋgöra azinöŋ mönö iwinamŋi etkömosöta anömŋaŋgöreŋ anda qekötahöiga ");
INSERT INTO bmu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yetkön sile mohot aka malmahot. Mewö aka toroqeba yahöt qahö akzahotmö, sile mohot aka malmahot. ");
INSERT INTO bmu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutunöŋ azi aka ambi mindirim etkiyöhi, ambazip kunŋan mönö i kude mendeŋ etkima.” ");
INSERT INTO bmu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jisösnöŋ mewö jiba miri uruŋe öŋgöiga gwarekurupŋan keu miaŋgöra kunbuk qesim waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Qesim waŋgigetka kewö jii mötket, “Azi kunöŋ anömŋi wuataŋgöba ambi kun memawi, yaŋön mönö qesabulum sero yoŋgorö akŋa. ");
INSERT INTO bmu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mewöyök ambi kunöŋ apŋi wuataŋgöba azi kun memawi, yaŋön mönö qesabulum sero yoŋgorö akŋa.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ambazip tosatŋan nahönbörat morömorö eŋguaŋgita Jisösnöŋ eŋgömisirimapköra yaŋgöreŋ kagetmö, gwarek yeŋön ambazip mi jim qetal eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mewö aketmö, Jisösnöŋ mi eka uruŋi böliiga kewö jii mötket, “Nahönbörat moröŋi mönö eŋgömosötketka nöŋgöreŋ kame. Anutunöŋ ambazip mewö mia bemtohoŋi buŋa qem eŋgima. Miaŋgöra i kude jöhöm eŋgime. ");
INSERT INTO bmu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nöŋön keu ölŋi kun kewö jibi mötme, “Kunŋan Anutugö bemtohoŋi mi nahönbörat ewö buŋa qahö qem aŋgumawi, yaŋön mönö miaŋgö uruŋe aŋgotmamgö osima. ");
INSERT INTO bmu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mewö jiba tambuŋe ala dohongöm eŋgiba böröŋi nöröpŋine ala kötuetköm eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisösnöŋ könahiba köna anmamgö ahiga azi kunöŋ ösumŋan yaŋgöreŋ kayök. Kaba wösöŋe geba simin köla kewö qesim waŋgiyök, “Böhi ölöpŋi, nöŋön mönö denöwö aka malmal köhöikŋaŋgö buŋa qem aŋgubileŋak?” ");
INSERT INTO bmu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Qesim waŋgiiga kewö jii mörök, “Nöŋgöra ‘Böhi ölöpŋi,’ mi wuanöŋgöra jizan? Anutu mohotŋan ölöpŋi akza. Azi kunŋan i ewö ölöpŋi qahö akza. ");
INSERT INTO bmu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gi jöjöpaŋ keu ki möt teközan, ‘Ambazip kun kude qenöŋ kömuma. Sero yoŋgorö kude akŋan. Yoŋgorö kude meman. Jitnöŋ alal keu kude jiman. Kalöpköba yoŋgorö kude meman. Iwinamgi mönö göda qem etkimakŋan.’” ");
INSERT INTO bmu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mewö jii möta kewö jiyök, “Böhi, mi pakpak mönö gwaböneyök tem köla mala kotzal.” ");
INSERT INTO bmu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mewö jiiga Jisösnöŋ uba eka urukönömŋan jöpaköm waŋgiba kewö jii mörök, “Mohot kungöra kewö osizan: Gi mönö anda sukinapki pakpak söŋgöröŋi memegöra alnöŋ moneŋ kaiga ambazip wanapŋi engiman. Mewö aknöŋga sukinapki ketaŋi (guli masapugi milyön kinagi ewö) ketaŋi mi Suep mire ahöm gihima. Mewö aka ni nuataŋgöba kaman.” ");
INSERT INTO bmu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jisösnöŋ mewö jiyökmö, sukinapŋi gwötpuk ahöyöhaŋgöra aka keu mi möta uruŋi bosoleiiga wösöbirik aka jeŋi asöliiga öne mosöta anök. ");
INSERT INTO bmu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mosöta aniga Jisösnöŋ ui anda kaiga gwarekurupŋi kewö jii mötket, “Yei! Ambazip moneŋ inapŋinambuk yeŋön mönö Anutugö bemtohoŋnöŋ aŋgotpingö lömböriba kupuk-kapak akŋe.” ");
INSERT INTO bmu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mewö jiiga gwarek yeŋön mi möta welipkögetmö, Jisösnöŋ toroqeba kewö jii mötket, “Gupanurupni, ambazip denike yeŋön moneŋ inapŋini möt narimakzei, yeŋön mönö Anutugö bemtohoŋ uruŋe aŋgotpingö lömböriba kupuk-kapak akŋe. ");
INSERT INTO bmu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mi kewö jim tuarimam: Sömbup ketaŋi kamel mi kondi kinimŋe ölöp qahö aŋgotma. Miaŋgö dop ambazip pomŋi yeŋön Anutugö bemtohoŋ uruŋe aŋgotpingö lömböriba qaköme.” ");
INSERT INTO bmu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mewö jii möta aurum tililiŋgöba nanŋinaŋgöra kewö jiget, “Opopoŋ! Ambazip daŋön mönö Suepkö buŋaya akawak?” ");
INSERT INTO bmu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mewö jigetka Jisösnöŋ uba eŋgeka kewö jiyök, “Ambazipnöŋ mi esapköba osiba qakömakzemö, Anutunöŋ mewö qahö ahakza. Anutunöŋ mönö yuai pakpak ölöp ahakza. Yaŋön yuai kun aka memamgö qahö osiba qakömakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pitönöŋ keu mi möta meleŋda Jisös kewö jii mörök, “Mötnöŋ, neŋön mönö yuai pakpak mosöta gi guataŋgöba kain.” ");
INSERT INTO bmu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mi möta Jisösnöŋ kewö jiyök, “Nöŋön keu ölŋi kun kewö jibi mötme: Kunŋan nöŋgö aka Ölöwak Buŋagöra aka yuai kun mosöröhi, - mi jike miriŋi, darumunŋi, nenbehötŋi, iwinamŋi, nahönböratŋi me nup kisiŋi - mi eŋgömosöriga Anutunöŋ mönö miaŋgö likepŋi oŋgita meleŋ waŋgiiga sehima. ");
INSERT INTO bmu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Kunŋan yuai mi mosöröhi, Anutunöŋ mönö salupŋe mi 100:kö dop toroqeba waŋgiiga nanŋi buŋaya akŋa. Gölmegö malmalnöŋ sesewerowero uruŋe malmapmö, jike miri, darumun, nenbehöt, iwinam, nahönbörat aka nup kisi mi mönö salupŋe ahum waŋgima aka nalö könaŋgepŋe malmal köhöikŋi teteköŋi qahö buŋa qem aŋguma. ");
INSERT INTO bmu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mewö asuhumapmö, mutukŋi eŋgöreŋök gwötpukŋan dagibezupŋi aketka dagibezupŋi yeŋgöreŋök gwötpukŋan mutukŋi akŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisösnöŋ gwarekurupŋi yembuk Jerusalem sitinöŋ öŋgöbingöra gölme köna anget. Jisösnöŋ mutuk aniga gwarekurupŋan andöŋe anda welipköget aiga ambazip andöŋine kageri yeŋön mönö keŋgötŋini mötket. Mewö aketka Jisösnöŋ gwarekurupŋi 12 mi kunbuk öröm eŋgiba könahiba kusum eŋgiyök. Yaŋgöreŋ yuai asuhumawi, keu mi jim asariba kewö jiyök, ");
INSERT INTO bmu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Mötket, nini Jerusalem öŋgöbin. Miaŋgöreŋ kunŋan Suep gölmegö azi ölŋi mamalolo mem waŋgiiga jike nup galöm aka Köna keugö böhi yeŋgö böröŋine gema. Yeŋön kömumapkö keuŋi jim teköba kian gawman yeŋgö böröŋine al waŋgime. ");
INSERT INTO bmu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Al waŋgigetka mepaiköba söutkölap qeba ihilek wahiŋambuknöŋ tauköm waŋgime. Tauköm waŋgiba qegetka kömuma. Kömumba wehön karöbut teköiga kömupnöhök wahötma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jisösnöŋ mewö jiiga Jebedigö nahönyahötŋi Jeims aka Jon yetkön yaŋgöreŋ anda kewö jiyohot, “Böhi, niri yuai kungöra ulet gihiziri mi ak netkimangö mötzit.” ");
INSERT INTO bmu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jiyohotka qesim etkiyök, “Iŋiri wani yuai ak etkimamgöra mötzahot?” ");
INSERT INTO bmu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Qesim etkiiga kewö jiyohot, “Göŋön ölöp jim kutunöŋga niri göhö asakmararaŋnöŋ eu öŋgöba kunöŋ börögi ölŋe aka kunŋan börögi qaniŋe tata yuai pakpak galöm kölbinak.” ");
INSERT INTO bmu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mewö Jiyohotmö, Jisösnöŋ kewö jii mörohot, “Iŋiri miaŋgö könaŋi qahö möt yaköba uletzahot. Nöŋön qambi asölŋambuk nemami, iŋiri mi ölöp nemba sihimbölö mötmahot me qahö? Jöm nöŋgwambuknöŋ melun mem niŋgimei, iŋiri mi memahot me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jii möta jiyohot, “Mi ölöp membit.” Jiyohotka kewö jii mörohot, “Mi ölŋa! Nöŋön qambi asölŋambuk nemami, iŋiri mi mewöŋanök nemahot aiga jöm nöŋgwambuknöŋ melun mem niŋgimei, miaŋön mönö iŋiri mewöyök melun mem etkime. ");
INSERT INTO bmu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mem etkimemö, nöŋgö böröni ölŋe me qaniŋe daŋön tatmahori, nöŋön keu mi jim kutumamaŋgö dop qahö. Anutunöŋ dum yahöt mi denike yetköra mözözömgöyöhi, mi mönö yetköra etkiiga nömbuk tata galöm kölmahot.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jeims Jon yetkön mewö ulerohotka alaurupŋi 12 yeŋön mi möta könahiba urubölö aket. ");
INSERT INTO bmu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mewö aketmö, Jisösnöŋ eŋgoholi kagetka kewö jii mötket, “Gölmegö kantriŋi kantriŋi mieŋgö jembonŋinan galöm köl eŋgibingö jizei, yeŋön mönö azi kembu tandök ak eŋgimakze. Yeŋgö ketaŋamŋinan mönö keu jim kutuba mindiŋgöm eŋgiba kukösumŋini kondelakze. Iŋini könaŋini mi ölöp mötze. ");
INSERT INTO bmu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Eŋgö sutŋine silik mewö ahöbapukmö, kunŋan eŋgö sutŋine ketaŋamŋini akŋamgö mötzawi, yaŋön mönö welen qem eŋgiba malma. ");
INSERT INTO bmu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mewöyök kunŋan eŋgö sutŋine mutukŋi malmamgö mötzawi, yaŋön mönö körek eŋgö nembö bapŋine mala welenqeqeŋini omaŋi akŋa. ");
INSERT INTO bmu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Suep gölmegö azi ölŋan mönö mewöyök silik mewöŋi kondela nanŋi welen qem waŋgimegöra aka qahö kayök. Qahöpmö, welen qem eŋgiba ambazip sehisehiŋi yeŋgö sohopŋini memamgöra aka eta malmalŋi köleŋda mosötma. ");
INSERT INTO bmu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisösnöŋ gwarekurupŋi yembuk Jeriko sitinöŋ kaget. Kaba siti mi mosötpingö aketka ambazip kambulelembenöŋ eŋguataŋgöba andöŋine kaget. Mewö kagetka jegömöl azi qetŋi Bartimeus, Timeusgö nahönŋi yaŋön moneŋ aka nene waŋgimegö ulet eŋgiba köna jitŋe tarök. ");
INSERT INTO bmu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tariga “Nazaret-azi Jisösnöŋ kaza!” jiget möta könahiba kewö qerök, “Jisös Deiwidkö gwölönarökŋi, mönö ak-kömum niŋgiman!” ");
INSERT INTO bmu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mewö qeriga gwötpukŋan bök tatmapköra qetal waŋgigetmö, yaŋön mönö kapaŋ köla qerök. “Deiwidkö gwölönarökŋi, mönö ak-kömum niŋginöŋ!” ");
INSERT INTO bmu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Qeriga Jisösnöŋ dörök ala kewö jiyök, “Ölöp qetketka ki kama.” Mewö jiiga jegömöl azi mi qeta kewö jiget mörök, “Göhöra qeza. Mönö mötkurumkurum mosöta wahöta kaman.” ");
INSERT INTO bmu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mi möta malukuŋi qeköba gila pöraŋ wahöta kinda Jisösgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aniga kewö qesim waŋgiyök, “Alani, nöŋön wani yuai ak gihimamgöra mötzan?” Mewö qesim waŋgiiga jegömöl azinöŋ jiyök, “Ketaŋamni, ni jeni kunbuk umamgöra mötzal.” ");
INSERT INTO bmu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mewö jiiga Jisösnöŋ kewö jii mörök, “Mötnaripkan mönö mem ölöwak gihiza. Mönö ölöp anman.” Mewö jii möta jeŋan miaŋgöreŋök tohoiga uba andöŋine Jisös wuataŋgöba anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisösnöŋ gwarekurupŋi yembuk Jerusalem siti dopdowiba Betfage aka Betani miri yahöt kösutŋire kaba Oil ip kunduŋe öŋgöba gwarekyahötŋi yahöt melaim etkimamgöra aka ");
INSERT INTO bmu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kewö jii mörohot, “Miri wösöŋire tatzawi, mönö miaŋgöreŋ anohot. Anda miaŋgöreŋ aŋgota doŋki moröŋi kösönöŋ jöhöget kinjawi, mi miaŋgreŋök miwikŋaimahot. Doŋki mi dölökŋa, azi kunŋan qakŋe qahö tatatŋa. Mi mönö pösata memba ki kamahot. ");
INSERT INTO bmu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pösarohotka kunŋan ‘Wuanöŋgöra mewö akzahot?’ jiba qesim etkiiga kewö jimahot, ‘Kembuniran mönö miaŋgöra osiba jiiga kazira zilaŋ meleŋniga kunbuk ki kama.’ ");
INSERT INTO bmu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mewö jiba melaim etkiiga anda doŋki moröŋi miri towokŋe miri kungö naŋguŋe kösönöŋ jöhöget kiniga miwikŋaiba pösarohot. ");
INSERT INTO bmu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pösarohotka azi tosatŋi miaŋgöreŋ kingeri yeŋön kewö qesim etkiget, “Hei, wania akitköra doŋki moröŋi pösatzahot?” ");
INSERT INTO bmu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mewö qesim etkigetka Jisösnöŋ jiyöhaŋgö dop jiyohot möta “Ölöp memba anmahot,” jiget. ");
INSERT INTO bmu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jigetka memba Jisösgöreŋ kayohotka malukuŋini qeköba doŋki moröŋaŋgö qakŋe algetka öŋgöba tarök. ");
INSERT INTO bmu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mewö tata aniga ambazip jesöŋgöŋan göda qeba malukuŋini qeköba köna namŋe tumbulgetka tosatŋan gölme köröŋe anda ip sinŋi mitiba tumbulget. ");
INSERT INTO bmu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tumbulgetka ambazip jeŋe köl öröba angeri aka andöŋe wuataŋgöba kageri, yeŋön kewö jiba qetket, “Hosana, owe owe! Anutu möpöseizin. Kembugö qetŋe kamawi, Anutunöŋ mönö i kötuetköm waŋgima. ");
INSERT INTO bmu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kiŋ Deiwidnöŋ kantri tohoŋ kuŋguba galöm köl eŋgiyöhi, nalö mewöŋan mönö kunbuk kam neŋgiza. O Anutu mönö kantri tohoŋnini kötuetköman. Hosana! Qetbuŋagi möpöseininga euyaŋgöreŋ öŋgöza. Owe Owe!” ");
INSERT INTO bmu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mewö qetketka Jerusalem sitinöŋ öŋgöba jöwöwöl jikegö tohoŋ uruŋe anök. Miaŋgöreŋ liliköba yuai pakpak ehi mare ahiga eta gwarekurupŋi 12 yembuk jike mosöta Betani mire anda ahöget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ahöba söŋanök wahöta gwarekurupŋi yembuk Betani miri mosöta angetka Jisösnöŋ nenegö kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nenegö kömumba ui aniga fig ip kun sinŋambuk kini ehök. Eka “Sinŋaŋgö uruŋe ölŋi tari miwikŋaiba nembileŋak,” jiba fig ipkö könaŋe anök. Anökmö, ölŋaŋgö nalöŋan qahö töriyöhaŋgöra sinŋanök kini ehök. ");
INSERT INTO bmu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mewö eka ip mi kewö jim waŋgiyök, “Kunŋan ölgi kunbuk kude nema.” Mewö jim waŋgiiga keu mi gwarekurupŋan mötket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Anda mala Jerusalem sitinöŋ öŋgögetka Jisösnöŋ jöwöwöl jikegö tohoŋ uruŋe anök. Miaŋgöreŋ ambazip eŋgehiga inap bohonŋi memegöra algetka söŋgöröŋi megeri, mi könahiba közöl eŋgiiga etket. Moneŋ utekutek ambazip yeŋgö jakeŋini metali anget. Mewöyök kembö bohonŋini memegöra algeri, mieŋgö dum tatatŋini mi tok tötaliga anget. ");
INSERT INTO bmu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sombem kömbukŋi kutuba yuai siriba aŋgotkaŋgotkö könaŋi jöhöyök. ");
INSERT INTO bmu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mewö aka kusum eŋgiba kewö jii mötket, “Aisaianöŋ keu kun kewö ohoi ahöza, ‘Nöŋgö jikenan mönö gölmeŋi gölmeŋi pakpak yeŋgö köulukö miriŋina akŋapkö qetme.’ Keu mi ahözapmö, iŋini mi utekögetka kegwek-kahasililiŋ yeŋgö baŋet ewö akza.” ");
INSERT INTO bmu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mewö jii möta ambazip kambu pakpak yeŋön miaŋgöra nemböŋini teköiga welipköget. Miaŋgöra jike nup galöm aka Köna keugö böhi yeŋön mi möta Jisösgöra keŋgötŋini möta eraum möta kewö jiget, “Mönö denöwö jiinga qegetka kömumbawak?” ");
INSERT INTO bmu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mare ahiga Jisösnöŋ gwarekurupŋi yembuk siti mosöta yaigep anda ahöget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ahöba söŋanök wahöta könanöŋ anda fig ip mi oŋgitpingö aketka jalöŋambuk uluŋgöba kini eket. ");
INSERT INTO bmu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kiniga Pitönöŋ Jisösgöreŋ keu mötmöriba kewö jii mörök, “Ketaŋamni eknöŋ, fig ip qesuahönöŋi, mi mönö ululuŋgöba kinja.” ");
INSERT INTO bmu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jii möta Jisösnöŋ kewö meleŋnök, “Anutugö mötnarip mönö töp memba malme.” ");
INSERT INTO bmu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nöŋön keu ölŋi kun kewö jibi mötme, “Kunŋan keuŋaŋgö ölŋi ahumapkö uruyahöt qahö aka kunduŋi kiaŋgö toŋaŋgöra kewö jim kutubawak, ‘Mönö kunduŋi ki qeköba wahöta anda köwetnöŋ alman.’ Mewö jim kutuba Anutu möt nariiga ölŋi mönö miaŋgö dop ahuma. ");
INSERT INTO bmu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Miaŋgöra nöŋön kewö jibi mötme: Wani yuaigöra qesiba köulukömei, mi pakpak lök buŋa qem aŋguzin, mewö möt narigetka mönö buŋaŋini akŋa. ");
INSERT INTO bmu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Iŋini kinda Anutu köulukögetka kunŋan alaŋaŋgö pinjitköra urubölö akŋa ewö, pinjit mi mönö mosötme. Mewö akŋe ewö, eŋgö Iwiŋini Suep mire maljawaŋön mönö mewöŋanök eŋgöreŋ siŋgisöndok mosötma. ");
INSERT INTO bmu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Iŋini tosatŋi yeŋgöreŋ siŋgisöndok qahö mosötme ewö, eŋgö Iwiŋini Suep mire maljawaŋön mönö mewöŋanök eŋgöreŋ siŋgisöndok qahö mosötma.)” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisösnöŋ gwarekurupŋi yembuk kunbuk Jerusalem sitinöŋ öŋgöget. Öŋgöba jöwöwöl jikegö tohoŋ uruŋe anda kaiga jike nup galöm, Köna keugö böhi aka kantrigö jitŋememe tosatŋi yeŋön yaŋgöreŋ kaŋgotket. ");
INSERT INTO bmu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kaŋgota kewö qesim waŋgiget, “Gi kiaŋgöreŋ yuai akzani, mi mönö daŋön jim kutum gihiiga ahakzan? Mi memamgö kukösumŋi mi daŋön gihiyök?” ");
INSERT INTO bmu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Qesim waŋgigetka kewö meleŋ eŋgiyök, “Nöŋön mewöyök keu kun qesim eŋgimam. Mi meleŋ niŋgigetka nöŋön mewöyök daŋön kukösum niŋgiiga yuai ki ahakzali, mi jibi mötme. ");
INSERT INTO bmu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonöŋ ambazip o-melun mem eŋgiba malöhi, yaŋön miaŋgö kukösumŋi mi denikeyök meyök? Suep Toŋan waŋgiyök me gölme toŋan waŋgiget? Mi jiget mötmam.” ");
INSERT INTO bmu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mewö meleŋ eŋgiiga sutŋine eraum möta kewö jiget, “‘Kukösumŋan Suepnöhök asuhuyök,’ mewö jibin ewö, yaŋön mönö kewö jima: Iŋini mönö wuanöŋgöra Jon qahö möt narim waŋgiget? Mi qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Me ‘Gölme ambazipnöhök asuhuyök,’ jibinak? Mi qahö dop kölja.” Ambazip körekŋan Jongöra ‘Ölŋa kezapqetok azia akza,’ jigeraŋgöra aka ambazip kambu yeŋgöra keŋgötŋini möta mi jibingö osiget. ");
INSERT INTO bmu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Miaŋgöra “Mi qahö mötzin,” meleŋget. Mewö meleŋgetka Jisösnöŋ kewö jii mötket, “Mewö aiga nöŋön mewöyök yuai ki ahakzalaŋgö kukösumŋi daŋön niŋgiyök, mi qahö jibi mötme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisösnöŋ könahiba ambazip dopkeunöŋ kewö jii mötket, “Azi kunöŋ wain kösö nup kun köla kömörök. Köla kömöta selŋi memba liliköyök. Mem liliköba wain jout ketaŋi kötnöŋ meyök. Miaŋgöreŋ waingö ölŋi ala könanöŋ tözöhölget oŋan lalanöŋ geyök. Wain jout ketaŋi mi memba wain yoŋgorö membepuköra galöm meme jake köröpŋi köweŋambuk meyök. Yuai pakpak mem teköba wain nup galöm tosatŋi miwikŋaim eŋgiba kewö jiyök, “Mönö nup memba ölŋaŋgö bahöŋi nanŋini memba bahöŋi toŋi ni niŋgime.” Mewö jiba nup mi böröŋine ala eŋgömosöta kantri kunöŋ anda malök. ");
INSERT INTO bmu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mala mali ölŋi öliyöhaŋgö nalöŋi (yambu 5) töriiga miaŋgöreŋ welenqeqeŋi kun melaim waŋgiiga galöm yeŋgöreŋ anda wain nup ölŋaŋgö bahöŋi waŋgimegöra jiyök. ");
INSERT INTO bmu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jiyökmö, galöm yeŋön i memba jöhöba kömbinöŋ qeba wuataŋgögetka böröŋi börak liliŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Miaŋgö andöŋe welen azi kun melaii yeŋgöreŋ aniga nöröpŋi qesiŋda gamu qem waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Miaŋgö andöŋe welen azi kun kunbuk melaiiga ani qeget kömuyök. Mewöŋanök azi tosatŋi gwötpuk melaim eŋgiiga tosatŋi kömbinöŋ sepgwörörök eŋguba tosatŋi eŋguget kömuget. ");
INSERT INTO bmu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mewö aketka wain nup toŋan keu jaruba jiyök, ‘Nani wölböt nahöni mohok mi tok malja. I mönö göda qem waŋgime me denöwö?’ Mewö jiba qöndökŋi mi nahönŋa melaiiga yeŋgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Anökmö, kaiga eka sutŋine kewö jiget, ‘Yaŋön mönö börösamotŋaŋgö toŋi akŋa. Ayop, mönö memba qein kömuiga wain kösö nup kiaŋön mönö nanine buŋanina akŋa.’ ");
INSERT INTO bmu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mewö jiba memba jöhöba qeget kömuiga qamötŋi nup yaigepŋe gilget geyök. ");
INSERT INTO bmu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Wain nup toŋan mi möta mönö denöwö akŋa? Yaŋön mönö nanŋak kaba nup galöm mi köndeŋ eŋgima aka nup galöm dölökŋi miwikŋaim eŋgiba wain kösö nupŋi yeŋgö böröŋine alma. ");
INSERT INTO bmu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Buŋa Kimbigö keu ki lök oyoŋget me qahö? ‘Miri meme yeŋön köt tandö kun andö qeba öne mosötket taröhi, miaŋön mönö tandö kömbönaŋi ahiga miwikŋaiget. Miaŋön tiŋgiriga mirinöŋ mönö gororoŋgöba eta kölma. ");
INSERT INTO bmu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kembunöŋ tandö mi kuŋguiga jeninan ehinga qetbuŋabuk ahiga welipkömakzin.’” ");
INSERT INTO bmu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisösnöŋ mewö jiiga galöm yeŋön keu miaŋgö könaŋi möt asariba kewö jiget. “Dopkeu mi mönö neŋgöra jiza.” Miaŋgöra i memba jöhöbingö mötketmö, ambazip kambu yeŋgöra keŋgötŋini möta osiba mosöta anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Juda jitŋememe yeŋön Farisi aka premiö Herodkö pati alaurup tosatŋi melaim eŋgiba kewö jiget, “Iŋini mönö Jisösgöreŋ anda qesiba keugö bötaknöŋ öröi gwaröhöm waŋgime.” Mewö jigetka Jisösgöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jisösgöreŋ kaba kewö jigetka mörök, “Böhi, göŋön azi ölŋi akzani, nini mi mötzin. Göŋön ambazip tosatŋi qahö eŋgek soriba tosatŋi qahö qepureim eŋgimakzanmö, dop mohotnöŋ kewöt neŋgimakzan. Miaŋgöra kuŋgum gihigetka qahö goŋgiba ketaŋi qahö esuhum eŋgimakzanmö, Anutugöreŋ köna mi keu ölŋaŋgö dop kusum neŋgimakzan. Göŋön Anutugöreŋ keu diŋdiŋi miaŋön öŋgöŋgöŋi eretŋi mohot pakpak jim qindiŋ ak neŋgimakzan. Miaŋgöra nini sisa-kiŋgöra takis ala miaŋön Mosesgö Köna keu siŋgibin me qahö? Mi alinga dop kölja me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mewö jiget möta areŋini muneŋi mi möt kutuba kewö jii mötket, “Iŋini wuanöŋgöra keugö bötaknöŋ al niŋgibingö esapköm niŋgize? Ölöp silwö moneŋ (Kina 5) kun memba kaget eki.” ");
INSERT INTO bmu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mewö jiiga mi memba kagetka kewö qesim eŋgiyök. “Dagöreŋ imut aka qet mi ki ohoget ahöza?” “Mi sisa kiŋgöreŋ!” Mewö meleŋda jiget. ");
INSERT INTO bmu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jigetka kewö jii mötket, “Mewö ahiga yuai sisa-kiŋgö imutŋambuk buŋaŋi ahözawi, mi mönö yaŋgöra al waŋgime. Yuai kun Anutugö buŋaya ahözawi, mi mönö Anutugö buŋa qeme.” Mewö jii möta yaŋgöra gwötpuk welipköget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi (Jike nupkö kapaŋkölköl) yeŋön “Kömugeri yeŋön kude wahötme,” jiba malget. Yeŋgöreŋök tosatŋan Jisösgöreŋ kaba kewö qesim waŋgiget, ");
INSERT INTO bmu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Böhi, Mosesnöŋ kewö jim kutum neŋgiyök ahöza, ‘Azi kun ambi meiga nahönbörat qahö ahui kömumba malöŋi öne mosöriga munŋan ölöp malöŋi memba gwölönarök qiwikŋaim waŋgiiga datŋaŋgö qet bisiba malma.’ ");
INSERT INTO bmu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mötnöŋ! Nalö kunöŋ darumun 7 malget. Datŋini mutukŋan ambi memba mala gwölönarökŋi qahö öne mala kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kömuiga munŋan malöŋi mi memba mala mewöyök gwölönarökŋi qahö öne kömuyök. Kömuiga munŋi kun yaŋgö bapŋe miaŋön ambi miyöhök memba mala öne kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mewöŋa mewö darumun 7 pakpak yeŋön ambi mohot miyöhök memba gwölönarök qahö mala kömum teköget. Körek kömugetka qöndökŋi malöŋini mi mewöyöhök kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Göŋön Kömugeri yeŋön guliba wahötme,’ jizanmö, nini mi qahö möt narizin. Mötnöŋ! Azi 7 pakpak mi öröröŋ wahötpeak ewö, ambi möhot mi anömŋina meget malöhaŋgöra aka mönö dagö anömŋa akawak?” ");
INSERT INTO bmu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mewö qesigetka Jisösnöŋ meleŋda kewö jii mötket, “Iŋini keu jim sohoze. Urumeleŋgö Buŋa Kimbiŋi aka Anutugö kukösumŋi qahö möt kutuzeaŋgöra mönö jaŋjuŋ ahakze. ");
INSERT INTO bmu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ölŋa, kömupnöhök wahöta nalö miaŋgöreŋ awanöm qahö akŋemö, garata yeŋön Suep mire maljeaŋgö tandök aka malme. ");
INSERT INTO bmu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mötket! Kömugeri, yeŋön guliba wahötmegö keuŋi mi Mosesgö Buknöŋ kewö ahöza: Sötman köhösönöŋ könöp bölam ahuba qahö jem kutuyöhi, iŋini kösohot mi oyoŋget me? Anutunöŋ miaŋgöreŋ Moses kewö jii mörök, ‘Nöŋön Anutu Abrahamgö Kembu, Aisakö Kembu aka Jeikobkö Kembuya mala kota maljal.’ ");
INSERT INTO bmu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Isik bömön karöbut yeŋön Anutubuk mala mal köhöiba öŋgöme. Anutunöŋ köhömuŋi yeŋgö Kembuŋini qahöpmö, malmal köhöikŋi maljei, mönö yeŋgö Kembuŋina akza. O Sadyusi (Jike nupkö kapaŋkölköl pati) iŋini mönö keu gwötpuk möt sohomakze.” Mewö meleŋnök. ");
INSERT INTO bmu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jisösnöŋ Sadyusi (Jike nupkö kapaŋkölköl) yembuk eraum möta jim soroköba meleŋ eŋgiyöhi, mi Köna keugö böhi azi kunöŋ mörök. Mewö möta jeŋe kaŋgota kewö qesim waŋgiyök, “Jöjöpaŋ keu pakpak mieŋgöreŋök bohonŋi ketaŋi mi denöwö?” ");
INSERT INTO bmu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Qesim waŋgiiga meleŋnök, “Bohonŋi ketaŋi mi kewö, ‘Israel könagesö mötket! Anutu mi Kembunini. Yaŋön Kembu mohot ahiga bem alaŋi kun qahö. ");
INSERT INTO bmu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Miaŋgöra urugi jömukŋi, uŋagi jömukŋi, mötmötki jömukŋi aka kuki jömukŋi, miaŋön mönö Kembu Anutugi jöpaköba malman.” ");
INSERT INTO bmu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jöjöpaŋ keu miaŋgö alaŋi kewö, ‘Nangi jöpaköm aŋgumakzani, mewöŋanök mönö ambazip pakpak jöpaköm eŋgiba malman.’ Jöjöpaŋ keu kunŋan mönö keu yahöt mi qahö etkoŋgitza.” ");
INSERT INTO bmu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Köna keugö böhigöra mewö meleŋniga jiyök, “Böhi! Gi törörök keu ölŋaŋgö dop jizan. Anutunöŋ mohot akza. Bem alaŋi kun qahö. ");
INSERT INTO bmu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Gi urugi jömukŋi, mötkutukutugi jömukŋi aka kuki jömukŋi, miaŋön Anutu jöpaköba malman. Aka nangi jöpaköm aŋgumakzani, mewöŋanök mönö ambazip pakpak jöpaköm eŋgiba malman. Jöjöpaŋ keu yahöt mi bohonŋi ketaŋi akzahot. Mi tem kölmani, miaŋön mönö jöwöwöl pakpak aka naluk kötin tosatŋi eŋgoŋgitza.” ");
INSERT INTO bmu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mewö jiiga Jisösnöŋ urumötmötŋi möri dop köliga kewö jii mörök, “Gi Anutugö bemtohoŋnöŋ aŋgotmamgö dopdowizan.” Mewö eraum möröhotka körek yeŋön Jisös toroqeba qesim waŋgibingö kölköldömdöm aka mosötket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisösnöŋ jöwöwöl jikenöŋ kinda Buŋa keu kusum eŋgiba kewö qesim eŋgiyök, “Kraistnöŋ kiŋ Deiwidkö gwölönarökŋi akzawi, Köna keugö böhi yeŋön keu mi denöwögöra jimakze? ");
INSERT INTO bmu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Deiwidnöŋ nanŋak Uŋa Töröŋan sölölöhöm waŋgiiga kewö jiyök, ‘Anutunöŋ kinda nöŋgö Kembuni kewö jii mörök: Göŋön mönö kaba nöŋgö böröni ölŋe tatnöŋga nöŋön nalö sutŋe kerökurupki tim tötöla luhut aleŋgiba göhö köna tambö gwaröŋe al eŋgimam. Nalö mi kam kuŋgumawaŋgö dop mönö asakmararaŋnöŋ ki tatman.’ ");
INSERT INTO bmu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deiwidnöŋ nanŋak mewö jiba qetŋi ‘nöŋgö Kembuni’ jiza.’ Kembuni jiba mönö denöwö aka yaŋgö gwölönarökŋi mohot akawak?” Mewö jiiga ambazip kambu ketaŋi yeŋön Jisösgö keuŋaŋgö sihimŋi möta kezap alget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisösnöŋ kusum eŋgiba toroqeba kewö jiyök, “Iŋini mönö Köna keugö böhi yeŋgöra galöm memba malme. Yeŋön maluku köröpŋi löŋgöta anda kaba kondel aŋgubingö mörakze aka maketnöŋ me könanöŋ ambazip eŋgigetka jölöŋini jimegö mörakze. ");
INSERT INTO bmu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Köuluk mire qaikŋe eu tatpingö sihimŋi mörakze, aka közölömbuaŋnöŋ dum tatat mutukŋe jegep tatpingö mörakze. ");
INSERT INTO bmu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yeŋön malö yeŋgöreŋ miri yuai bidaŋda gagabe köla eŋguaŋgirakze, aka qetbuŋaŋini asuhumapköra köuluk köröpŋi köuluköba töptöpŋine qemakze. Miaŋgöra Anutunöŋ keuŋini jim teköba likepŋi öŋgöŋgöŋi meleŋni qakŋine öŋgöma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisösnöŋ jöwöwöl jikenöŋ naluk dundum andöŋe tariga ambazipnöŋ moneŋ miaŋgöreŋ alget geiga uba eŋgehök. Ambazip pomŋi sukinapŋinambuk gwötpuk yeŋön kaŋgota kina moneŋ lömbötŋambuk alget geyök. ");
INSERT INTO bmu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Alget geiga malö wanapŋi kunöŋ kaŋgota souje kötŋi yahöt, mi toiya tosatŋi miaŋgö dop ali geyök. ");
INSERT INTO bmu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisösnöŋ mi eka gwarekurupŋi köl öröm eŋgiba kewö jii mötket, “Nöŋön keu ölŋi kun kewö jibi mötme: Malö wanapŋi kiaŋön naluk aljawi, mi mönö tosatŋi pakpak yeŋön yuai dundumnöŋ alget gezawi, miaŋgö dopŋi oŋgita alja. ");
INSERT INTO bmu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Körek yeŋön moneŋ gwötpuk ahöm eŋgiiga kitipŋanöhök aljemö, ambi kiaŋön mönö köruebörue maljawaŋgö dop yuaiŋi pakpak al teköba öne töhön malma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisösnöŋ jöwöwöl jike mosöta eriga gwarekurupŋi yeŋgöreŋök kunŋan kewö jii mörök, “Böhi eknöŋ! Jikegö tohoŋ uruŋe miriŋi miriŋi mi mönö wewelipŋambuk. Mi kötnöŋ memba meŋölögetka ölöpbölöpŋi kinja.” ");
INSERT INTO bmu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisösnöŋ mi möta keu kewö meleŋnök, “Jikegö tohoŋ uruŋe miri ketaŋi ki eŋgekzanmö, mi mönö köndeŋgetka mirigö köt kun mi köt kungö qakŋe qahö ahömapmö, qeqelaŋlaŋ aka sahopŋanök ahöma.” ");
INSERT INTO bmu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mewö jiiga Oil ip kunduŋe öŋgöba likepŋe endu jöwöwöl jikenöŋ kinöhi, mi eka tatket. Miaŋgöreŋ tata Pitö, Jeims, Jon aka Andru yeŋön Jisös nanŋök öröba kewö qesim waŋgiget, ");
INSERT INTO bmu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Böhi! Keu jizani, miaŋgö ölŋi mönö wanat nalönöŋ asuhum tiŋgitma aka yuai pakpak mi könahiba asuhum tekömawi, miaŋgö aiwesökŋan mönö denöwö asuhuma? Mia ölöp jinöŋ mörin.” ");
INSERT INTO bmu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mewö qesim waŋgigetka könahiba kewö jii mötket, “Kunŋan isimkakalek aiga jaŋjuŋ anbepuköra mönö galömŋini memba malme. ");
INSERT INTO bmu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","“Ambazip gwötpukŋan asuhuba nöŋgö qetne kewö jime, ‘Nöŋön Kraist akzal.’ Mewö jiba ambazip gwötpuk tilipköm eŋgime. ");
INSERT INTO bmu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Iŋini yarö mieŋgö buzupŋini aka ötöŋini asuhugetka mörakŋe. Mi möta jönömŋini kude undumakŋa. Yuai mewöŋi mi mutuhök asuhumapkö jijiŋa. Mi asuhumapmö, gölmegö nalöŋan mönö miaŋgöreŋök zilaŋ qahö teköma. ");
INSERT INTO bmu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kantri kunöŋ kantri kun eŋgubingöra wahötme. Ambazip kambu kunöŋ kambu kun yembuk aröŋ aŋgubingöra wahötme. Gölmeŋi gölmeŋi miaŋgöreŋ kenöŋ ketaŋi ketaŋi qözöla memba gölme meleŋni gemakŋa. Mewöyök bödiŋi bödiŋi (buöröŋi buöröŋi) asuhuba öŋgöba ahöma. Yuai mewöŋi mi ambi köröbuknöŋ masi könahiba eŋgumakzawaŋgö dop. Gölmegö nalöŋan mönö miaŋgö dop könahiba tekömamgö akŋa. ");
INSERT INTO bmu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mewö akŋapmö, iŋini ölöp galömŋini mem aŋguba malme. Ambazipnöŋ iŋini öröba keu jakeŋe al eŋgiba köuluk mireŋini keu nupŋini memba kömbinöŋ eŋgume. Tosatŋan nöŋgöra aka eŋguaŋgitketka kantriŋi kantriŋi yeŋgö kiŋ kembu aka premiö yeŋgö jemesoholŋine kinme. Mewö kinda nöŋgö könaŋamni naŋgöba jigetka mötme. ");
INSERT INTO bmu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ölöwak Buŋa ki mönö mutuk gölmegö kantriŋi kantriŋi pakpak yeŋgöra jim sehim tekögetkun gölmegö nalöŋan miaŋgö andöŋe teköma. ");
INSERT INTO bmu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Öröba eŋguaŋgita keu jakeŋe al eŋgigetka kinmei, nalö miaŋgöreŋ keu denöwö jibinak, miaŋgö waimanjatŋi qeljiŋe kude mötme. Uŋa Töröŋan aua miaŋgöreŋök keu eŋgimawi, mönö mia jime. Nanŋine uruŋinaŋgöra keu qahö jimemö, Uŋa Töröŋan mönö uruŋini sölölöhöiga keu jime. ");
INSERT INTO bmu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Urumeleŋgö kopa kunöŋ darumunŋan uruŋi meleŋnöhaŋgöra aka i mamalolo meiga keu jakeŋe algetka qeget kömuma. Mewöyök iwi kunöŋ nahönböratŋi mamalolo meiga kömuma aka nahönbörat yeŋön iwinamurupŋini qetal eŋgiba jigetka eŋguget kömume. ");
INSERT INTO bmu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kantri pakpak yeŋön nöŋgö qetnaŋgöra aka kazik ak eŋgigetka malmemö, kunŋan kapaŋ köla köhöiba böŋ qeba kinda maliga gölmegö nalöŋan tekömawi, yaŋön mönö oyaeŋkoyaeŋ buŋa qem aŋguma. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Könaŋgep tosatŋan kaba köndeŋmöndeŋ aka yuai aŋgöjörakŋambuk jikenöŋ qahö alalgö dop mi altanöŋ ala kiniga ekŋei, - keu ki oyoŋmawaŋön mönö ölöp kezap ala möt kutuma - nalö miaŋgöreŋ Judia prowinsnöŋ malmei, eŋön mönö misiŋgöba öröba kunduŋe anme. ");
INSERT INTO bmu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Miri kösutŋe sombemnöŋ malmawaŋön mönö eta yuaiŋi memamgöra miri uruŋe kude öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nupnöŋ anda malmawaŋön mönö mewöyök malukuŋi memamgöra liliŋgöba mirinöŋ kude anma. ");
INSERT INTO bmu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yei! Ambi gölömbuk aka morö juzunöŋ yeŋön nalö miaŋgöreŋ denöwö ösumŋinan anbeak. ");
INSERT INTO bmu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Miaŋgöra yuai mi kie luhut nalöŋe kude asuhumapköra köuluköme. ");
INSERT INTO bmu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nalö miaŋgöreŋ kahasililiŋ keta bölökŋi asuhuma. Kahasililiŋ dopŋi mewöŋi mi mönöwök nalö kungen kude asuhuba ahöyök. Anutunöŋ yuai pakpak miwikŋaiyöhi, nalö miaŋgöreŋök könahiba nalö kiaŋgöreŋ mala kota nalö sutŋe kun qahö asuhuyök. Mönöwök qahö asuhuyök aka könaŋgep nalö kunöŋ qahö ahuma. Miaŋgöra mönö köuluköba malme. ");
INSERT INTO bmu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kembunöŋ wahöjaliŋ nalö mi qahö mem töribawak ewö, ambazip körekŋan mönö ayuhum teköbeakmö, ambazip nanŋaŋgöra möwölöhöm eŋgiyöhi, yeŋgöra aka wehön mieŋgö qötöŋini mi mem törima. ");
INSERT INTO bmu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nalö miaŋgöreŋ kewö jime, ‘Mötket! Kraistnöŋ ki malja.’ aka ‘Eket! Amötqeqe Toŋan endu kinja.’ Kunŋan mewö jima ewö, mi mönö kude möt narime. ");
INSERT INTO bmu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mi kewögöra: Amötqeqe toŋi muneŋi aka kezapqetok ambazip takapulakaŋi asuhuba aŋgöletot aka aiwesök jemurutŋi megetka letotme. Mewö letotketka Anutunöŋ ambazip nanŋaŋgöra möwölöhöm eŋgiyöhi, i mewöyök eŋololoŋ mem eŋgimegö esapköba kapaŋ kölgetka jaŋjuŋ akepuk. Eŋön ölöpŋanök galömŋini memba malgetka mi osibeak. ");
INSERT INTO bmu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nöŋön yuai pakpak mi kude asuhuiga qeljiŋe lökŋanök jibi mötze. Mi mutuk jizalaŋgöra mi mönö uruŋine ala galömŋini mem aŋguba malme. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wahöjaliŋ mi teköiga nalö miaŋgöreŋök wehön jeŋan injaŋ köliga köiŋnöŋ ömuŋ kölma. ");
INSERT INTO bmu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Seŋgelau yeŋön suepnöhök teköba etme aka suepnöŋ uturuköiga miaŋgö öröyuaiŋi mi tatatŋini mosöta eŋololoŋ aketka sohoma. ");
INSERT INTO bmu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nalö miaŋgöreŋ Suep gölmegö azi ölŋi yaŋön kousu qakŋe kaŋgori ekŋe. Kukösumŋi ketaŋan saköl-diŋdiŋambuk aukŋe asuhuiga asakmararaŋi ekŋe. ");
INSERT INTO bmu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kaŋgota Suep garataurupŋi melaim eŋgiiga yeŋön ambazip Anutunöŋ nanŋaŋgöra möwölöhöm eŋgiyöhi, i gölme göraŋi likeplikep, euke emuke miaŋgöreŋök kölolohoba eŋguaŋgitme. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iŋini geröp ip eka tandökŋi mötmöriba dopkeu ki mötme. Böröŋan lök oŋambuk aiga sinŋan yoŋgoigetka mi eka möta kewö jimakze, ‘Wehön nalöŋan mönö dopdowiza.’ ");
INSERT INTO bmu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eŋön mewöŋanök aiwesök miaŋgö dop asuhuiga eka möt asariba könaŋi kewö jime, ‘Jisösnöŋ mönö naŋgunöŋ dopdowiza.’ ");
INSERT INTO bmu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nöŋön keu ölŋi kun kewö jibi mötket: Ambazip ki merak gölmenöŋ maljei, yeŋön qahö kömugetka yuai pakpak jizali, mi mönö yeŋgö malmal nalöŋine asuhuma ");
INSERT INTO bmu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Suep gölmenöŋ göröŋ qemahotmö, nöŋgö Buŋa keunan mönö qahö ayapköma.’ Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Suep gölmegö azi ölŋan dawinöŋ kamawi, miaŋgö wehönŋi me aua nalöŋi mi kunŋan kun qahö mötza. Suepnöŋ garata yeŋön mi qahö mötze. Anutugö Nahönŋan mewöŋanök mi qahö mötza. Iwinöŋ nanŋök mi mötza. ");
INSERT INTO bmu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nalö dawinöŋ asuhumawi, mi qahö mötzeaŋgöra eŋön mönö alöm memba uruguliguli malme. ");
INSERT INTO bmu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mi dopkeu kiaŋgö dop ahöza: Azi kunöŋ miriŋi mosöta kantri kungen anök. Anmamgöra aka galömurupŋi yuai pakpakŋaŋgöra jim kutum eŋgiba naŋgu kiŋi böröŋine ala kukŋi eŋgiyök. Kukŋi eŋgiba welenqeqeurupŋi mohok mohok nup keu eŋgiyök. Eŋgiba mala naŋgu galömŋi mewöyök uruguliguli malmapköra jim kutum waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Miri toŋan dawinöŋ liliŋgöba kamawi, mi qahö mötze. Mare me suŋgem ömbibiŋe kama me? Waŋgaraŋ suruiga kama me? Wehön giaŋiiga kama me? Miaŋgö dop iŋini mi qahö mötzeaŋgöra mönö uruguliguli malme. ");
INSERT INTO bmu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Könöpuk wölaŋ kaiga eŋön gaun ahögetka mewö miwikŋaim eŋgibapuk. ");
INSERT INTO bmu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iŋini mönö uruguliguli malme. Keu mi gwarekurupŋi eŋgöra jizali, mi mewöyök alaurupni körek pakpak eŋgögöra jizal: Iŋini mönö urugwölögwölö malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pasowa kendon aka beret yistŋi qahö miaŋgö kendonŋi töriyohot. Wehön yahöt teköiga miaŋgöreŋ könahibitkö ahotka jike nup galöm aka Köna keugö böhi yeŋön tokoget. Tokoba denöwö möndöŋninga Jisös ölöŋ memba qeget kömumbawak, miaŋgö könaŋi jaruba kewötket. ");
INSERT INTO bmu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jaruba kewöta kewö jiget, “Ambazip irimŋini seholiiga karimŋi karimŋi asuhubepuköra mi sösöŋgai kendon nalöŋe akingö osibin.” Mewö jiget. ");
INSERT INTO bmu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisösnöŋ Betani mirinöŋ mala Saimon kun uzikukuŋi mem solaniyöhi, yaŋgö mire öŋgöba tarök. Miaŋgöreŋ nene nemba tariga ambi kunŋan köt kirin kun memba yaŋgöreŋ kayök. Kirin mi nöluk tuat-tuat qetŋi alabastö miaŋön memeŋa. Mia o um-köhöwakŋambuk ölŋi qetŋi nad miaŋön kokolak qeba tarök. Yaŋön mi bohonŋi ketaŋan memba kaba nöluk jölŋi kutuba oŋi Jisösgö nöröpŋe mimbiliba miriyök. ");
INSERT INTO bmu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Miriiga azi tatkeri, yeŋgöreŋök tosatŋan urubölö aka nanŋinök kewö eraum mötket, “Nad o mi mönö wuanöŋgöra mewö ayuhuzawi? ");
INSERT INTO bmu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nad o kelökŋambuk mi bohonŋi memegöra albawak ewö, ölöp silim 300:kö töwaŋi (Kina 1500,-) oŋgita yöhötibawak. Mi ambazip wanapŋi eŋgiiga dop kölbawak.” Mewö jiba ambi mi jim waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jim waŋgigetka Jisösnöŋ kewö jii mötket, “Ambi ki kude jim waŋgime. Wuanöŋgöra uruŋi mem bölize? Yaŋön silik ölöpŋi ak soroköm niŋgiiga dop kölja. ");
INSERT INTO bmu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ambazip wanapŋi mi nalöŋi nalöŋi sutŋine malgetka ölöpŋi ak eŋgibingö möta mi ölöp nalö dop akŋemö, nöŋön eŋgö sutŋine nalö dop qahö malmam. ");
INSERT INTO bmu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yaŋön mi nanŋi akakmemeŋaŋgö dop ak niŋgiza. Nöŋön kömumbi löm köl niŋgimeaŋgöra ölöp qeljiŋe sileni kelöknöŋ nömiriza. ");
INSERT INTO bmu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nöŋön keu ölŋi kun kewö jibi mötket: Ölöwak Buŋa ki kantri igen waigen jim sehigetka anmawi, miaŋgöreŋ ambi kiaŋön yuai ak niŋgizawi, miaŋgö buŋaŋi mohok jiget sehiiga yaŋgöra mötmöriba malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Gwarekurupŋi 12 yeŋgöreŋök kun qetŋi Judas Iskariot yaŋön Jisös mamalolo mem waŋgimamgöra aka jike nup galöm yeŋgöreŋ anök. ");
INSERT INTO bmu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yeŋgöreŋ anda keuŋi jiiga mi möta uruŋinan ölöwahiga söŋgöröŋi moneŋ waŋgibingöra keu jöhöget. Keu jöhögetka Jisös nalö kungen mamalolo mem waŋgimamgö köna möt jaruba köiŋbiŋgöba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Beret yistŋi qahö miaŋgö kendon silim mutukŋe (Seqononöŋ) pasowa lama kun qeba ohozema. Miaŋgöra Jisösgö gwarekurupŋan jiget, “Böhi, nini miri denikeaŋgöreŋ anda pasowa lama mözözömgöm gihiba nembin? Sihimgi denöwö ahöza?” ");
INSERT INTO bmu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mewö jigetka gwarekyahötŋi yahöt kewö jiba melaim etkiyök, “Iŋiri Jerusalem sitinöŋ öŋgöyohotka azi kun o kumbut kunduta kaiga miwikŋaimahot. Miwikŋaiba i ölöp wuataŋgöba anmahot. ");
INSERT INTO bmu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Anohotka mire öŋgöiga miaŋgö toŋi kewö jiyohot mötma, ‘Böhinöŋ kewö jiza: Ölöp miri uruŋi kun niŋginöŋga miaŋgöreŋ öŋgöba gwarekurupni yembuk pasowa lama nembin.’ ");
INSERT INTO bmu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mewö jiyohotka toŋan möta miri qakŋe eu öŋgöba uruŋi ketaŋi kun kondel etkima. Miaŋgöreŋ dum tatat yuai mözözömgöget ahöza. Mi kondel etkiiga miaŋgöreŋ lama qeba ohomahot.” ");
INSERT INTO bmu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mewö jiiga gwarekyahötŋan mosöta sitinöŋ öŋgöba Jisösnöŋ keu jiyöhi, miaŋgö dop miwikŋaiba kinda lama qeba ohom mözözömgöyohot. ");
INSERT INTO bmu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Miri söŋauiga Jisösnöŋ gwarekurupŋi 12 yembuk miri miaŋgöreŋ kaŋgotket. ");
INSERT INTO bmu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kaŋgota öŋgöba dumnöŋ tata nene negetka Jisösnöŋ kewö jii mötket, “Nöŋön keu ölŋi kun kewö jibi mötket: Eŋgöreŋök kun nömbuk nene nemba tatzawaŋön mönö mamalolo mem niŋgima.” ");
INSERT INTO bmu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mewö jiiga uruŋinan wösöbirik aiga könahiba nanŋök nanŋök qesim waŋgiba jiget, “Nöŋgöra jibanbuk?” ");
INSERT INTO bmu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Qesim waŋgigetka kewö jii mötket, “12 eŋgöreŋök kun nömbuk beret kuluŋnöŋ kunduŋgözawi, yaŋön. ");
INSERT INTO bmu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Suep gölmegö azi ölŋan mönö yaŋgöra keu ohoget ahözawaŋgö dop gölme mosöta anma. Anmapmö, mamalolo mem waŋgimawi, yaŋgöra Yei wösöbirik! jizal. Anutunöŋ mönö likepŋi öŋgöŋgöŋi meleŋ waŋgima. Azi mi nam köröuruŋeyök qahö ahubawak, miaŋön mönö amqem waŋgibawak.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nene nemba tata Jisösnöŋ beret memba kötuetköba mindipköba eŋgiba kewö jiyök, “Ki nani busuni. Ki memba neget.” ");
INSERT INTO bmu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mewö jiba wain qambi memba saiwap jiba eŋgiiga körekŋan qambi kiaŋgöreŋök neget. ");
INSERT INTO bmu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Negetka kewö jii mötket, “Ki nani sepni. Ki Anutunöŋ ambazip yembuk jöhöjöhö areŋ aiga köhöimapköra sepni mokoget geiga ambazip gwötpuk amöt qem eŋgima. ");
INSERT INTO bmu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nöŋön keu ölŋi kun kewö jibi mötket: Nöŋön wain kösögö ölŋi kiaŋgöreŋ kunbuk toroqeba qahö nemam. Könaŋgep Anutugö bemtohoŋ uruŋe eu taringa közölömbuaŋ almawi, wehön miaŋgöreŋ mönö wain o qainŋi kun mia nemam.” ");
INSERT INTO bmu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mewö jiiga sösöŋgai liŋet köla mosöta anda Oil ip kunduŋe öŋgöget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Öŋgöba Jisösnöŋ kewö jii mötket, “Kezapqetok azi kunöŋ keu kun kewö ohoi ahöza, ‘Nöŋön galömŋini qebiga lama kambuŋan deŋme.’ Miaŋgö dop eŋön körek uruŋini böliiga nömosöta buratime. ");
INSERT INTO bmu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Buratigetka nuŋgumemö, nöŋön mönö kömupnöhök wahöta mutuk Galili prowinsnöŋ anda miaŋgöreŋ asuhum eŋgimam.” ");
INSERT INTO bmu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mewö jiiga Pitönöŋ kewö jii mörök, “Yeŋön körek uruŋini böliiga gömosöta buratime ewö, nöŋön mönö töndup mewö qahö akŋam.” ");
INSERT INTO bmu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jiiga Jisösnöŋ jii mörök, “Nöŋön keu ölŋi kun kewö jibi mötnöŋ: Kuruknöŋ indimŋi yahöt qahö qeriga göŋön merak suŋgem qaŋ köl niŋginöŋga indimŋi karöbut akŋa.” ");
INSERT INTO bmu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mewö jiyökmö, Pitönöŋ kapaŋ köla köhöiköhöi ahök, “Böhi! Mewö qahöpmö, ni nuŋgugetka göbuk mohotŋe kömumbirak, mi töndup nöŋön gi qahö qaŋ köl gihimam.” Gwarek tosatŋi pakpak mewöyök keu miyöhök jiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mewö eraum möta anda arö kun qetŋi Gezemane miaŋgöreŋ aŋgotket. Aŋgota gwarekurupŋi kewö jii mötket, “Nöŋön endu anda köuluköbiga iŋini ölöp nalö sutŋe ki tatme.” ");
INSERT INTO bmu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mewö jiba Pitö, Jeims aka Jon eŋguaŋgita anget. Angetka Jisösnöŋ könahiba köŋjiliŋ kanjamŋambuk möriga köna böröŋi qeköyök. ");
INSERT INTO bmu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mewö aka kewö jii mötket, “Nöŋgö urunan mönö kondum köla kotzawaŋgöra aka wösöbirik mötpiga kömukömuŋi ak niŋgiza. Iŋini ölöp kiaŋgöreŋ tata nömbuk guli malbin.” ");
INSERT INTO bmu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mewö jiba nanŋök boromkun toroqeba anda simin köla sipköba sihimbölö nalöŋi mi Iwiŋaŋgö jitŋaŋgö dop oŋgitmapköra köuluköyök. ");
INSERT INTO bmu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Köuluköba jiyök, “Aba Iwini, gi yuai kun qahö mölölömbizan. Miaŋgöra sihimbölögö qambiŋi ki mönö noaŋgitman. Noaŋgitpanak, mi nöŋgö sihimgö dop qahöpmö, mönö nangi jitkahö dop asuhuma.” ");
INSERT INTO bmu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mewö jiba liliŋgöiga gwarekurupŋi karöbut yeŋön gaun ahöget eŋgeka Pitögö kewö jii mörök, “Saimon, gi gaun ahözan me? Gi aua mohot-töp guli malmamgö kude köhöizan me? ");
INSERT INTO bmu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Uruninan guli malbingö sihimŋi mörakzinmö, sileninan lölöwöröŋi akza. Miaŋgöra esapesapnöŋ et eŋgubapuköra mönö köuluköba guliguli malme.” ");
INSERT INTO bmu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mewö jii möriga kunbuk eŋgömosöta anda keu miyöhök kunbuk jiba köuluköyök. ");
INSERT INTO bmu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Köuluköba liliŋgöiga jeŋini böŋböŋ meyöhaŋgöra kunbuk gaunök ahöget eŋgehök. Gaunöhök wahöta keu meleŋbingö jaŋjuŋ aket. ");
INSERT INTO bmu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jisösnöŋ ani indimŋi karöbut aiga liliŋgöba kaba kewö jii mötket, “Iŋini toroqeba luhut memba gaunök ahöbingö mötze me? Mötket! Kunöŋ Suep gölmegö azi ölŋi mamalolo mem waŋgiiga bölöŋi meme yeŋgö böröŋine öŋgöma. Miaŋgö aua nalöŋan lök kam kuŋguza. Eŋgö gaun ahöahö nalöŋinan mönö teköza. ");
INSERT INTO bmu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mönö wahötketka anin. Mötket! Mamalolo mem niŋgimawi, yaŋön mönö dowe ki kaza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisösnöŋ mewö jiba kiniga miaŋgöreŋök gwarekurupŋi 12 yeŋgöreŋök kun qetŋi Judas yaŋön kambu kun jitŋe mem eŋgiiga kaŋgotket. Jike nup galöm, Köna keugö böhi aka kantrigö jitŋememe yeŋön i melaim eŋgigetka bimgö sou ketaŋi aka liŋgipŋini memba kaget. ");
INSERT INTO bmu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mamalolo memamgö ahöhi, yaŋön mutuk yembuk aiwesök keu kewö jöhöba jii mötket, “Nöŋön azi numbuŋi yöhötim nemami, i eka ‘Mönö mi!’ jiba memba jöhöba törörök galöm köla anme.” ");
INSERT INTO bmu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mewö jiba kaba miaŋgöreŋök Jisösgöreŋ aŋgota “O Böhini!” jiba numbuŋi yöhötim neyök. ");
INSERT INTO bmu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yöhötim neiga eka Jisös qelanjiba memba jöhöget. ");
INSERT INTO bmu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jöhögetka kösutŋe kingeri, yeŋgöreŋök kunŋan bimgö sou ketaŋi öröba jike nup galöm bohonŋaŋgö welenqeqeŋi qeba kezapŋi köteköi erök. ");
INSERT INTO bmu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisös jöhögetka keu kewö jii mötket, “Ni kegwek-kahasililiŋ azia qahöpmö, töndup nöŋgöra mewö möta bimgö sou ketaŋi aka liŋgip memba nömemba jöhöbingöra kaŋgotze. ");
INSERT INTO bmu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nöŋön wehön dop jöwöwöl jikenöŋ embuk kinda Buŋa keu kusum eŋgiba malbiga qahö nömigetmö, yuai ki mönö Buŋa Kimbigö keuŋan ölŋambuk akŋapköra asuhuza. ");
INSERT INTO bmu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jisös jöhögetka gwarek yeŋön körek Jisös mosöta buratiba unjurata anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Azi gwabö kunöŋ bindoŋi tuatŋanök köpeiba Jisösgö andöŋe wuataŋgöba anök. Opoŋi tosatŋi qahö löŋgöta aniga i esapköba meget. ");
INSERT INTO bmu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Membingö osiba bindoŋi qekögetka aukŋamŋe unjurata anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisös jöhöba waŋgita jike nup galöm bohonŋaŋgö mire anget. Angetka jike nup galöm pakpak, kantrigö jitŋememe aka Köna keugö böhi yeŋön miaŋgöreŋ anda tokoget. ");
INSERT INTO bmu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Angetka Pitönöŋ sikepsikep eŋguataŋgöba jike nup galöm bohonŋaŋgö mire aŋgota jakömbuak mirigö kiripo uruŋe öŋgöyök. Öŋgöba welenqeqe azi yeŋgö sutŋine tata könöp kösutŋe jömörök. ");
INSERT INTO bmu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mewö tarökmö, jike nup galöm aka jike kaunsöl kambu yeŋön Jisösgö silenöŋ alal keu denöwö naŋgöinga qeget kömumapkö jim jarugetmö, könaŋi kun qahö miwikŋaiget. ");
INSERT INTO bmu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jaruba kinda gwötpukŋan keu muneŋi sileŋe ala naŋgöba jigetmö, keuŋinan könaŋi mohok qahö ahök. ");
INSERT INTO bmu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mewö aiga tosatŋan wahöta kinda keu muneŋi sileŋe ala naŋgöba kewö jiget, ");
INSERT INTO bmu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yaŋön kewö jiiga mörin, ‘Nöŋön jöwöwöl jike börönöŋ memeŋi ki köndeŋbiga gölmenöŋ eriga wehön karöbutkö uruŋe jike qainŋi kun börönöŋ memeŋi qahö mi mem wahöta kuŋgumam.’” ");
INSERT INTO bmu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mewö jigetmö, töndup keuŋinan könaŋi mohok qahö ahök. ");
INSERT INTO bmu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mewö aiga jike nup galöm bohonŋan wahöta mesohol köl eŋgiba kinda Jisös qesim waŋgiba kewö jiyök, “Yeŋön göhö silege keu ala naŋgözei, miaŋgö likepŋi kun jiman me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Qesim waŋgiiga yuai bölöŋi kun qahö ahökmö, töndup likepŋi kun qahö meleŋda keuŋi bök kinök. Keuŋi bök kiniga jike nup galöm bohonŋan kunbuk kewö qesim waŋgiyök, “Anutu möpöseim waŋgimakzini, gi yaŋgö Nahönŋi Kraist akzan me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Qesim waŋgiiga “Oŋ!” jiba kewö jii mötket, “Suep gölmegö azi ölŋan mönö kukösum Toŋaŋgö böröŋi ölŋe tata suepkö kousu qakŋe eri ekŋe.” ");
INSERT INTO bmu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Keu mi jiiga jike nup galöm bohonŋan malukuŋi munjurata kewö jiyök, “Yei, iwinaŋgö jitŋi! Tosatŋan keuŋi naŋgömegöra kunbuk qahö qesim eŋgibin. ");
INSERT INTO bmu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anutu mepaiközawi, mi mönö nanŋinak möt teköze. Miaŋgöra denöwö mötmörize?” Mewö qesim eŋgiiga yeŋön körek Jisös kömupkö buŋaya akŋapköra jim teköget. ");
INSERT INTO bmu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mewö jim teköba tosatŋan könahiba söutkölap miriba jemesoholŋi esuhuba böröŋinan misiba qeba kewö jiget mörök, “Daŋön guhuzawi, mi ölöp jinöŋ mörin.” Jikegö kiripo galöm (sikiriti) yeŋön mewöyök Jisös memba nuŋgulumŋe qekötahöget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nalö miaŋgöreŋ Pitönöŋ kiripo uruŋe sombemnöŋ malök. Emu maliga jike nup galöm bohonŋaŋgö welenqeqe ambiŋi kunŋan miaŋgöreŋ kaŋgorök. ");
INSERT INTO bmu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kaŋgota Pitönöŋ könöp kösutŋe jömöri ehiba kewö jiyök, “Gi mewöyök Nazaret azi Jisös miambuk malnöŋ.” ");
INSERT INTO bmu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mewö jiyökmö, Pitönöŋ qaŋ köla kewö jiyök, “Keu jizani, mi qahö möta köndatzal.” Mewö jiba kiripo naŋguŋe geiga kinda kuruk qerök. ");
INSERT INTO bmu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naŋgunöŋ geiga welenqeqe ambi kunŋan i miaŋgöreŋ kunbuk eka azi kösutŋe kingeri, i könahiba kewö jii mötket, “Azi kiaŋön mönö yeŋgöreŋök kun akza.” ");
INSERT INTO bmu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mewö jii mötketmö, yaŋön kunbuk qaŋ kölök. Qaŋ köliga nalö borom kun teköiga azi kösutŋe kingeri, yeŋön kunbuk Pitögöra kewö jiget, “Göŋön Galili azia kun akzanaŋgöra mönö alakŋa, yeŋgöreŋöhök kun akzan.” ");
INSERT INTO bmu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mi möta könahiba nanŋi qesuahöm aŋguba jöjöpaŋ keunöŋ jim köhöiba jiyök, “Azi keuŋi jizei, mi qahö möt waŋgizal. Muneŋ jibileŋak ewö, Anutunöŋ mönö likepŋi meleŋ niŋgima.” ");
INSERT INTO bmu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mewö jiba kiniga miaŋgöreŋök kuruk qeri yahöt ahök. Kuruk qeriga Jisösgö keu kewŋö jii möröhi, Pitönöŋ mi mötmöriyök, “Göŋön indimŋi karöbut qaŋ köl niŋginöŋga kuruknöŋ qeri indimŋi yahöt akŋa.” Keu mi mötmöriba wösöŋi julmamgö aiga sahöt böliyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Miri giaŋiiga amandiŋe jike nup galöm, kantrigö jitŋememe (70), aka Köna keugö böhi aka jike kaunsöl pakpak yeŋön kot öŋgöŋgöŋi miaŋgö totoko ala Jisösgö keu jim teköget. Jim tekögetka Jisös jöhöba waŋgita premiö Pailötkö böröŋe alget. ");
INSERT INTO bmu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Rom premiö yaŋön Jisös kewö qesim waŋgiyök, “Ölŋa, gi Juda yeŋgö kiŋa akzan me qahö?” Qesim waŋgiiga Jisösnöŋ meleŋda jii mörök, “Mönö nangak jizani, mewö.” ");
INSERT INTO bmu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jike nup galöm yeŋön keu gwötpuk Jisösgö sileŋe ala jiget. ");
INSERT INTO bmu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jigetka Pailötnöŋ Jisös kunbuk qesim waŋgiba jiyök, “Mötnöŋ! Yeŋön keu gwötpuk göhö silege ala jizei, göŋön miaŋgö likepŋi kun jiman me qahö?” ");
INSERT INTO bmu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mewö jiyökmö, Jisösnöŋ bölöŋi kun qahö ahökmö, töndup keu kitipŋi kunbuk qahö meleŋnök. Keu bök kiniga premiönöŋ welipköyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yambu (yara) dop pasowa sösöŋgai nalöŋe premiönöŋ kösö mireyök azi kun qetŋi qeta qesigeri, mi pösat eŋgizapma. ");
INSERT INTO bmu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nalö miaŋgöreŋ azi kun qetŋi Barabas qetkeri, yaŋön kösö mire tarök. Yaŋön kegwek-kahasililiŋ azi tosatŋi yembuk karim gila azi kun qeget kömuyöhi, miaŋgöra kösö mire al eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mewö aiga könagesö yeŋön premiögö miri sombemŋe eu öŋgöba kinda könahiba akŋalöhaŋgö dop akŋapkö qesim waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Qesim waŋgigetka meleŋda kewö jii mötket, “Nöŋön Juda eŋgöreŋ kiŋ pösatpi etmapkö mötze me?” ");
INSERT INTO bmu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jike nup galöm yeŋön Jisösgöra körögisigisi mötkeraŋgöra aka i premiögö böröŋe al waŋgiget. Mi möta sihimŋinaŋgö mewö qesim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Qesim eŋgiiga jike nup galöm yeŋön ambazip kambu uruesiesi mem eŋgiba kewö jiget, “Mönö Jisös mosöta Barabas pösatman! Mewö qesim waŋgime.” ");
INSERT INTO bmu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mewö jigetka kunbuk meleŋda qesim eŋgiyök, “Mewö jizeaŋgöra Juda eŋgöreŋ kiŋ qetŋi mewö qerakzei, nöŋön mönö i denöwö ak waŋgibileŋak?” ");
INSERT INTO bmu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mewö qesim eŋgiiga kunbuk qetket, “Mönö maripomnöŋ qeget jiman!” ");
INSERT INTO bmu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mewö qetketka Pailötnöŋ kewö jii mötket, “Mi wuanöŋgöra? Yaŋön mönö wani bölöŋa ahök?” Mewö jiyökmö, yeŋön mi möta kapaŋ köla toroqeba qet gigilahöba kewö qetket, “Mönö maripomnöŋ qeget jiman!” ");
INSERT INTO bmu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mewö qetketka Pailötnöŋ ambazip kambu sihimŋinaŋgö dop akŋamgö möta Barabas pösat eŋgii erökmö, Jisösya jiiga ihilek wahiŋambuknöŋ qeyöyaköba qeget. Mewö qegetka maripomnöŋ qemegöra Rom yarö azi yeŋgö böröŋine alök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yarö azi yeŋön Jisös waŋgita premiögö jakömbuak mirigö kiripo uruŋe aŋgotket. Aŋgota yarö kambu lökŋanök öröm eŋgigetka miaŋgöreŋ kaget. ");
INSERT INTO bmu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kaba maluku pisikŋi gugakgugak mi Jisösgö sileŋe löŋgöt waŋgiba sötman kösö limbiŋda ila ewö nöröpŋe kölget geyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mewö geiga könahiba waikŋi memba jölöŋi jiget, “Owe owe, Juda yeŋgöreŋ kiŋ, owe!” ");
INSERT INTO bmu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Titipepe mewö aka jigetka jehotnöŋ nöröpŋe qeba söutkölap qeba simin köl waŋgiba sipköba möpöqöpösei muneŋi mem waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mepaqepaik mewö ak waŋgim teköba maluku pisikŋi gugakgugak mi qeköba nanŋe sile esu löŋgöt waŋgiba maripomnöŋ qebingöra waŋgita anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Anda köna namŋe azi kun qetŋi Saimon miwikŋaiget. Yaŋön Afrika siti qetŋi Sairini miaŋgö aziŋa aka Aleksander aka Rufus yetkö iwiŋira. Yaŋön nupnöhök kaŋgoriga kuŋgum waŋgigetka Jisösgö maripomŋi memba aŋguyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jisös mewö waŋgita gölme kun qetŋi Golgota mi nanine keunöŋ nöröp sihit, miaŋgöreŋ anda aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Aŋgota wain o aka marasin qetŋi mör mi mindiriba loloŋqaloŋ memba waŋgigetmö, Jisösnöŋ mi tököyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tököiga kinda maripomnöŋ qeget. Qeget kiniga kiawen meget qötöŋi ahuiga Jisösgö sile esuŋi mohok mohok sutŋine miaŋgö dop mendeŋda meget. ");
INSERT INTO bmu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Söŋan 9 kilok miaŋgöreŋ maripomnöŋ qeget. ");
INSERT INTO bmu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Maripomnöŋ qeba nöröpŋe eu qegeraŋgö könaŋi kewö ohoba qeget, “Juda yeŋgö kiŋ kembuŋina ki.” ");
INSERT INTO bmu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kegwek-kahasililiŋ azi yahöt mewöyök yambuk maripomnöŋ etkuget. Kun böröŋi ölŋe kun qaniŋe likeplikep mewö etkuget. ");
INSERT INTO bmu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Anutugöreŋ Buŋa Kimbinöŋ keu kewö ohoget ahöza, “I kewöta kegwek-kahasililiŋ azi ewö mötmöriba yeŋgö sutŋine alget.” Keu miaŋön mewö ölŋambuk ahök.) ");
INSERT INTO bmu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ambazip oŋgita anda kaba kukulömbuaŋ aka jelikit aka nöröp köla kewö jiget, “Yei! Gi mönö jöwöwöl jike ölöp köndeŋnöŋga gölmenöŋ eriga wehön karöbutkö uruŋe kunbuk mem wahöt kuŋgumamgö jinöŋ. O, gi azi qetpuk! ");
INSERT INTO bmu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mönö nangi bauköm aŋguba maripomnöhök etman.” ");
INSERT INTO bmu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jike nup galöm aka Köna keugö böhi yeŋön mewöyök sutŋine mepaqepaik ak waŋgiba jiget, “Tosatŋa bauköm eŋgiba malökmö, nanŋi bauköm aŋgumamgö osiza. ");
INSERT INTO bmu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yaŋön Amötqeqe Toŋi Kraist aka Israelgö kiŋ akza ewö, mönö dölki maripomnöhök eri eka mi möt naribinak.” Mewö jiget. Azi yambuk maripomnöŋ etkugeri, yetkön mewöyök uruqeqe keu töhöreŋ jim waŋgiyohot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Silim bibiŋi 12 kilok aiga miaŋgöreŋ söŋaupnöŋ eta gölme pakpak dop köla ahöiga anda aua karöbutkö dop ahök. ");
INSERT INTO bmu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jisösnöŋ 3 kilok miaŋgöreŋ nanŋe keunöŋ kewö qet ketaŋi qerök, “Eloi, eloi, lama sabaktani?” Mi nanine keunöŋ: Anutuni, Anutuni mönö wuanöŋgöra andö nuŋguzan? ");
INSERT INTO bmu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mewö qeriga azi kösutŋe kingeri, yeŋgöreŋök tosatŋan mi möta jiget, “Mötket! Mönö Elaijagöra qetza.” ");
INSERT INTO bmu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yeŋgöreŋök kunöŋ ösumŋan anda mömöndö kun kahali tandök mi memba wain o asölŋambuknöŋ kundumgöba ip göröm kitipŋe jöhöba suruba Jisös numbu susuŋe eu ali neiga jiyök, “Mönö mosötketka nanŋök kinök. Elaijanöŋ kaba meköi etma me qahöpto, mönö mi ekin.” ");
INSERT INTO bmu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mewö aketka Jisösnöŋ qet ketaŋi qeta wösöŋi nöŋ qeiga kömuyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kömuiga miaŋgöreŋök jöwöwöl jikegö uruŋe opo kinöhi, miaŋön mönö euyök bibiŋe jurata eta yahöt ahök. ");
INSERT INTO bmu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Suahö galömnöŋ maripom mesohol köla kinda Jisösnöŋ wösöŋi nöŋ qeiga kömuyöhi, mi eka kewö jiyök, “Azi kiaŋön mönö ölŋa Anutugö nahönŋa akza.” ");
INSERT INTO bmu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ambi tosatŋan mewöyök sikep kinda yuai mi eket. Yeŋgö sutŋine Magdalagö Maria aka Maria Jeims dubatŋi aka Joses yetkö namŋiri aka Salome yeŋön mohotŋe kinget. ");
INSERT INTO bmu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yeŋön Jisösnöŋ Galili prowinsnöŋ maliga miaŋgöreŋ i wuataŋgöba welen qem waŋgiba malget. Mewöyök ambi tosatŋi gwötpuk Jisösbuk Jerusalem sitinöŋ öŋgöba kageri, yeŋön mewöŋanök kösutŋe kinget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sabat kendon tatatköra yuai mözözömgögetka Sabat kendonöŋ könahimamgöra dopdowiiga mare aka kayök. ");
INSERT INTO bmu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Neŋgogie miaŋgöreŋ Arimatia toŋi, azi qetbuŋaŋambuk qetŋi Josef yaŋön kayök. Yaŋön mewöyök Anutu bemtohoŋaŋgö ölŋi asuhumapköra mamböta malök. Yaŋön Juda yeŋgö jike kaunsöl kambugö jitŋememe kun aka Sabat kendonöŋ könahimamgö ahöraŋgöra aka keŋgötŋi yaköriba Pailötköreŋ anda Jisösgö qamötŋi memamgö qesiyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Qesiiga “Ölŋa kömuza me qahöpto?” jiba mötmöriba suahö galömŋi jii kaiga “Jisösnöŋ nalö köröpŋi me töröpŋi kömuza,” jiba qesim waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Qesim waŋgiiga buzup keuŋi möta Jisösgö qamötŋi Josef jim teköm waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jim teköm waŋgiiga opo tuatŋi söŋgöröŋi memba anda qamötŋi maripomnöhök qeköba memba eta oponöŋ esuhuyök. Esuhuba memba qaksirinöŋ anda kötnöŋ köteŋ urorohogetka dum ahöyöhi, miaŋgöreŋ alök. Ala köt kötaŋi kun metaliga köteŋ numbuŋi közipköyök. ");
INSERT INTO bmu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Denike alöhi, mi Magdalagö Maria aka Maria Josesgö namŋi yetkön kinda ehot. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat kendon tatket teköiga miaŋgöreŋ Magdalagö Maria, Maria Jeimsgö namŋi aka Salome yeŋön “Jisösgö qamötŋi anda miribin.” jiba jiniŋ jimoroŋ umköhöwakŋambuk söŋgöröŋi meget. ");
INSERT INTO bmu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Memba ahöba Sonda söŋanök wahöta miri giaŋii wehön jiliŋbölaŋ kori qaksirinöŋ anget. ");
INSERT INTO bmu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Anda eraum möta jiget, “Qaksirigö numbuŋe köt ketaŋi tatzawi, mi mönö daŋön qetalma?” ");
INSERT INTO bmu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mewö jiba ugetka ani kewö eket: Köt keta bölökŋi mi lök qetalget anda ahöyök. ");
INSERT INTO bmu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Qaksirigö köt köteŋ numbuŋi mewö aŋaŋiba kiniga uruŋe öŋgöget. Öŋgögetka ölŋine göröken azi gwabö kun malukuŋi köröpŋi tuatŋi tariga eket. Mewö eka gwötpuk awöwöliget. ");
INSERT INTO bmu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Awöwöligetmö, kewö jii mötket, “Mönö keŋgötŋini kude mötme. Iŋini Nazaret azi Jisösgöra jaruze. I maripomnöŋ qegetmö, mönö guliba wahörök. Miaŋgöra ki kude ahöza. Eket! Dumŋi ki, miaŋgöreŋ suluget ahöyök. ");
INSERT INTO bmu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Miaŋgöra mönö anda Pitö aka gwarekurupŋi pakpak buzup kewö jiget mötme, ‘Yaŋön mönö qeljiŋe mutuk Galili prowinsnöŋ anma. Iŋini mewöyök miaŋgöreŋ anda keuŋi jiyöhaŋgö dop i ekŋe.’” ");
INSERT INTO bmu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mewö jiiga auruba jönömŋini unduiga köt köteŋök eta ösumŋinan anget. Sömbuŋini mötkeraŋgöra keu kun kude jigetmö, keuŋini bököyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisösnöŋ Magdalagö Maria yaŋgö uruŋeyök öme 7 eŋguataŋgöiga malök. Jisösnöŋ kömupnöhök wahöta Sonda söŋan amandiŋnöŋ mutuk Maria mi asuhum waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Asuhum waŋgiiga alaurupŋan Jisösbuk mala kota nalö miaŋgöreŋ jiŋgeŋ köla sahötkeri, Marianöŋ mönö yeŋgöreŋ anda buzupŋi jii mötket. ");
INSERT INTO bmu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mötketmö, Jisösnöŋ guliba mali Marianöŋ ehöhi, mi qahö möt nariget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Miaŋgö andöŋe alayahötŋan Jerusalem siti mosöta miri kunöŋ anbitköra könanöŋ anohotka Jisösnöŋ kaisoŋgolomŋan meleŋniga asuhum etkiyök. ");
INSERT INTO bmu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yetkön mewöyök anda buzupŋi mi alaurupŋi jiyohot mötketmö, yeŋön mi mewöyök qahö möt nariget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Könaŋgep gwarekurupŋi 11 mieŋön tokoba nene nemba tatketka yeŋgöra mewöyök asuhuyök. Asuhuba uruköhöikŋinaŋgöra tembula kömupnöhök wahöriga ekeraŋön buzupŋi jiget möta mi qahö möt narigeri, miaŋgöra i jim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jisösnöŋ kewö jii mötket, “Iŋini mönö kantri dop anda gölmeŋi gölmeŋi liliköba ambazip mal anjeaŋgö dop Ölöwak Buŋani jim asarigetka mötme. ");
INSERT INTO bmu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kunŋan Anutu möt nariiga o melun mem waŋgigetka uruŋi meleŋmawi, yaŋön mönö letota Suepkö buŋaya akŋa. Kunŋan qahö möt nariba yaŋgiseŋ malmawi, Anutunöŋ mönö yaŋgö keuŋi jim teköiga könöp siagö buŋaya akŋa. ");
INSERT INTO bmu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Möt narim niŋgiba malmei, mi aiwesök mem eŋgibiga könaŋamŋini kewö asuhuma: Yeŋön nöŋgö qetne ömewöröme eŋguataŋgöme. Kantri tosatŋi yeŋgö keuŋini jime. ");
INSERT INTO bmu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mokoleŋ böröŋinan memba wahötme. Möröm warabe o yuai negetka miaŋön mönö qahö mem bölim eŋgima. Böröŋini kawöl ambazip qakŋine algetka ölöwakŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kembu Jisösnöŋ keuŋi mewö jii mötketka Anutunöŋ waŋgiriga Suepnöŋ öŋgöba Anutugö böröŋi ölŋe tata malja. ");
INSERT INTO bmu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eu maljapmö, gwarekurupŋan mosöta miri gölme dop anda Buŋa keuŋi jim sehiba malget. Mewö malgetka Kembunöŋ yembuk nup memba inahöm eŋgiiga aŋgöletot asuhugetka keuŋinan köhöiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kezapqetok ambazipnöŋ Amötqeqe Toŋi ahumapkö keu jigetka miaŋgö ölŋi sutnine asuhuyöhi, ambazip gwötpukŋan miaŋgö kösohotŋi könahiba ohoget. ");
INSERT INTO bmu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yuai ölŋi mi sutnine asuhuiga tosatŋan mi könakönahiŋeyök könahiba kota nanŋine jeŋinan eka möt yakögeri, yeŋön miaŋgö dop miaŋgö buzupŋi toroqeba jim sehigetka kezapnine geba nanine buŋaya ahök. Ambazip mewöŋi yeŋön Buŋa mi könahiba papianöŋ ohoba areŋgöget ahöza. ");
INSERT INTO bmu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nöŋön mewöyök yuai pakpak asuhuba koröhi, mi törörök qesim eŋgibi könaŋeyök könahiba jigetka möt kutuzal. O Tiofilus nöŋön göhöra mötpi öŋgöŋgöŋi akzan. Nöŋön göbuk keu eraum mötpitkö mötpi ölöwahiga Jisösgö kösohotŋi mi körekŋanök areŋgöba ohozal. ");
INSERT INTO bmu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Buŋa keu ölŋi kusum gihigetka mötzani, göŋön miaŋgö könaŋi oyoŋda körekŋanök möt kömuman. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judia prowinsgö kiŋ qetŋi Herod yaŋgö nalöŋe azi kun qetŋi Zekaraia malök. Yaŋön jike nup galöm mala Abaiagö nup areŋnöŋ kinök. Anömŋi qetŋi Elisabet yaŋön mewöyök jike nup galöm Arongö gwölönarökŋi kun ahök. ");
INSERT INTO bmu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yekŋön Anutugö jeŋe malmal diŋdiŋi mala Kembugö jöjöpaŋ keu aka jimkutukutuŋi pakpak törörök wuataŋgöba köpösihitkö keuŋiri qahö malohot. ");
INSERT INTO bmu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Malohotmö, Elisabetnöŋ köpingöra gwölönarökŋiri qahö mala ambazip namŋi ahot. ");
INSERT INTO bmu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nalö kunöŋ Abaiagö nup areŋ nalöŋan kaiga Zekaraianöŋ jike nup galöm nup memapköra Anutugö jemesoholŋe kaŋgorök. ");
INSERT INTO bmu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kaŋgoriga jike nup galöm yeŋön aiakaŋini wuataŋgöba sutŋine nup mendeŋda Zekaraia mekögetka Kembugö altanöŋ öŋgöba jiniŋ wörönŋambuk ohoyök. ");
INSERT INTO bmu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jiniŋ wanafu ohoho nalöŋan kam kuŋguiga yaŋön yuai wörönŋambuk mi ohoiga ambazip kambu pakpak yeŋön jöwöwöl jike yaigepŋe mamböta Anutu köuluköba malget. ");
INSERT INTO bmu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jiniŋ ohoiga wörönŋan pukpuköba miri uruŋi dop köliga miaŋgöreŋ Kembugö garata kunöŋ altanöŋ eu asuhum waŋgiba böröŋi ölŋe göröken kinök. ");
INSERT INTO bmu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kiniga Zekaraianöŋ eka auruba keŋgötŋi mörök. ");
INSERT INTO bmu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Keŋgötŋi mörökmö, garatanöŋ kewö jii mörök, “Zekaraia, gi keŋgötki kude mötnöŋ. Anutunöŋ köuluki lök mötza. Miaŋgöra anömgan gölöm ala morö nahöna mema. Mi meiga göŋön qetŋi Jon qetman. ");
INSERT INTO bmu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nahönŋi asuhuiga urugan yaŋgöra ölöwahiga söŋgainöŋga ambazip gwötpukŋan sösöŋgai akŋe. ");
INSERT INTO bmu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","I nam körö uruŋe tariga Uŋa Töröŋan miaŋgöreŋök könahiba uruŋi kokolak qeiga qariba wain me o köhöikŋi mi qahö nemba Kembugö qöhöröŋe azi öŋgöŋgöŋi aka malma. ");
INSERT INTO bmu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mewö mala Israel ambazip gwötpuk urumeleŋ eŋgiiga Kembuŋini Anutugöreŋ liliŋgöme. ");
INSERT INTO bmu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anutugö Uŋaŋan kezapqetok azi Elaija inahöiga kukösum qakŋe nup meyöhi, yaŋön mönö miaŋgö dop mutuk qeljiŋe aniga Kembunöŋ andöŋe kama. Yaŋön anda könagesö uru kuŋgum eŋgiiga Kembunöŋ kamapköra jöjöröba kinme. Iwi aka nahönbörat jula deŋgetka uru kuŋgum eŋgiiga kunbuk mindirim aŋgume aka qeqetal ambazip mi diŋdiŋi yeŋgö mötmöt areŋnöŋ aŋgotme.” ");
INSERT INTO bmu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Suep garatanöŋ mewö jiiga Zekaraianöŋ jiyök, “Anömni netkön ambazip namŋi akziraŋgöra keugan mönö dewöwö ölŋambuk akawak?” ");
INSERT INTO bmu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mewö jiiga meleŋnök, “Ni Geibriel. Nöŋön Anutugö mesoholŋe kinbi melaim niŋgii buzup ölöpŋi ki memba kaba jibi mötzan. ");
INSERT INTO bmu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nöŋgöreŋ keu jit ölŋambuk asuhumawi, göŋön mi jibi qahö möt narizanaŋgöra keugan mönö qahöwahiga mötök malman. Mewö malnöŋga buzup keu kiaŋgö ölŋi asuhumapkö nalöŋan kam kuŋguiga miaŋgöreŋ nesilamgan lolohoi keu kunbuk jiman.” ");
INSERT INTO bmu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nalö sutŋe miaŋgöreŋ ambazipnöŋ mamböt mala Zekaraianöŋ jöwöwöl jikenöŋ nalö köröp tiŋtiŋi kinöhaŋgöra mötkurumkurum aket. ");
INSERT INTO bmu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mewö aka tatketka yaigep eta keu jimamgö osiiga möt asariba kewö jiget, “Yaŋön jöwöwöl jikenöŋ kinda jeŋi meleŋni Suepnöhök imut kun ekza.” Mewö jigetka böröŋanök kaisöpsöp al eŋgiba mötök aka malök. ");
INSERT INTO bmu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mewö mala jike nup meme nalöŋan teköiga liliŋgöba miriŋe anök. ");
INSERT INTO bmu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wehön tosatŋi teköiga Elisabetnöŋ gölöm ala köiŋ 5 miaŋgö dop mire asamböta kewö jiba tata malök, ");
INSERT INTO bmu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Moröni qahöpköra ambazipnöŋ memba eta al niŋgigetka Kembunöŋ mesohol köl niŋgiba miaŋgö lömbötŋi memba gila ak kömum niŋgiza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabetnöŋ gölöm alöhaŋgö köiŋi 6 aiga Anutunöŋ garataŋi qetŋi Geibriel melaiiga Galili prowinsgö miriŋi kun qetŋi Nazaret miaŋgöreŋ erök. ");
INSERT INTO bmu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Eta ambi seram jömukŋi qetŋi Maria yaŋgöreŋ anök. Yaŋön azi qetŋi Josef yaŋgö ambi buŋaya malök. Josefnöŋ kiŋ Deiwidkö gwölönarökŋi kun ahök. ");
INSERT INTO bmu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Garatanöŋ Mariagöreŋ anda kewö jiyök, “O Maria, silimgi ölöpŋi. Kembunöŋ kalem möriam gihiba göbuk kinma.” ");
INSERT INTO bmu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mewö jiyökmö, Marianöŋ jölöŋ miaŋgöra gwötpuk auruba könaŋi jaruba mötkurumkurum ahök. ");
INSERT INTO bmu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mötkurumkurum aiga kewö jii mörök, “Maria, Anutunöŋ kalem möriam gihiiga yaŋgö jeŋe dop köljan. Miaŋgöra keŋgötki kude mötnöŋ. ");
INSERT INTO bmu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mötnöŋ, göŋön gölöm ala morö nahöna meman. Memba qetŋi Jisös qetman. ");
INSERT INTO bmu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jisös yaŋön qariba azi qetbuŋaŋambuk aiga qetŋi ‘Öŋgöŋgöŋi ketaŋaŋgö Nahönŋi,’ qetketka malma. Mewö mali Kembu Anutunöŋ amböŋi kiŋ Deiwidkö jakömbuak dum waŋgiiga salupŋe ambazip galöm köl eŋgiba malma. ");
INSERT INTO bmu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jeikobkö könagesö yeŋgö kiŋa aka teteköŋi qahö galöm köl eŋgiba malma. Bemtohoŋi miaŋön mönö nalö kunöŋ kude qahöwakŋa.” ");
INSERT INTO bmu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Garatanöŋ mewö jiiga Marianöŋ jii mörök, “Yei! Ni azigö könaŋi qahö mötzal. Miaŋgöra keu jizani, miaŋgö ölŋi mönö denöwö asuhuma?” ");
INSERT INTO bmu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mewö jii möta meleŋnök, “Uŋa Töröŋan mönö aum köl gihiiga Anutu öŋgöŋgöŋi ketaŋaŋgö ösumŋan dop köla turum gihima. Miaŋgöra morö memani, yaŋön töröŋi aiga ambazipnöŋ qetŋi ‘Anutugö Nahönŋi,’ jiba qerakŋe. ");
INSERT INTO bmu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mötnöŋ. Tinigi Elisabet yaŋön mewöyök ‘Köpin mala morö memamgö osiza,’ jigetmö, töndup ambi namŋi aka nalö kewöŋe morö nahöngö gölömŋambuk aiga köiŋi 6 akza. ");
INSERT INTO bmu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutunöŋ yuai kun akŋamgö jiba mi qahö qaköba osimakza.” ");
INSERT INTO bmu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mewö jiiga Marianöŋ jiyök, “Mötnöŋ, nöŋön Kembugö welenqeqe ambia akzal. Miaŋgöra keu jizani, miaŋgö dop ölöp ahum niŋgima.” Mewö jiiga Suep garatanöŋ mosöta anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Marianöŋ mi möri nalö köröpŋi qahö aiga wahöta zilaŋ jöjöröba gölme kunduŋe öŋgöba Judia prowinsgö taon kunöŋ anök. ");
INSERT INTO bmu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Anda Zekaraiagö mire öŋgöba anömŋi Elisabet eka söŋgaiba jölöŋi jiyök. ");
INSERT INTO bmu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jölöŋi jiiga miaŋgöreŋök möri morö nahönöŋ körö uruŋe luhuba öŋgöba eri Uŋa Töröŋan Elisabetkö uruŋi kokolak qeyök. ");
INSERT INTO bmu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kokolak qeiga qet ketaŋi qeta kewö jiyök, “O alani, Anutunöŋ kötumötuetŋi öŋgöŋgöŋi al gihiiga ambi sutnine malman aka morö memani, i mewöŋanök kötuetköm waŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Denöwögöra Kembunaŋgö namŋan kaba neiga mewö asuhum niŋgiza? ");
INSERT INTO bmu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mötnöŋ, gi jölöŋni jinöŋga keu jölgi kezapne gei morönöŋ urune mewöyök sösöŋgai qakŋe luhuba öŋgöba etza. ");
INSERT INTO bmu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kembunöŋ buzup keuŋi jiiga möta miaŋgö ölŋi asuhumawi, mi möt narizanaŋgöra göhö mötpi simbawoŋ akzan.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Marianöŋ keu mi möta kewö jiyök, “I-ia! Nöŋgö urukönömnan mönö önöŋi qahö Kembu möpöseiza. ");
INSERT INTO bmu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nöŋgö uŋanan Anutu, Amötqeqe Toni yaŋgöra söŋgaiba köiraŋ kölja. ");
INSERT INTO bmu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nöŋön welenqeqe ambi etqeqeŋi maljalmö, Anutunöŋ töndup mesohol köla ak kömum niŋgiza. Mötnöŋ, ambazip kambuŋi kambuŋi merak könahiba asuhumei, yeŋön mönö nöŋgöra ‘Simbawoŋ!’ jiba möpöseim niŋgiba malme. ");
INSERT INTO bmu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kukösum Toŋan mönö aŋgöletot öŋgöŋgöŋi mem niŋgii maljal. Yaŋgö qetŋi mi Töröŋi. ");
INSERT INTO bmu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ambazip merak gölmenöŋ maljei aka könaŋgep ahum sehimei, yeŋgö sutŋine gwöt isik denike yeŋön Anutugö jitŋi oŋgitpinbukö keŋgötŋini mötmei, yaŋgö ak-kömukömuŋan mönö yembuk pöndaŋ ahöma. ");
INSERT INTO bmu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anutunöŋ böröŋan aŋgöletot memba miaŋön kukŋi kondel neŋgiiga ehin. Ambazip nanŋini miwidimgöba söŋgöröqök malgeri, yaŋön mönö i köndeŋ eŋgiiga simbisembel aka malget. ");
INSERT INTO bmu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kiŋ kembuŋi kembuŋi jakömbuak dumŋine tata ambazip galöm köl eŋgiba malgeri, yaŋön i miaŋgöreŋök qeköba utal eŋgiiga etket. Etketmö, etqeqeŋi ia mönö mem wahöta al eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ambazip yuaigö jaŋkötataŋ malgeri, mieŋgö uruŋini mönö yuai ölöpŋi ölöpŋi miaŋön kokolak qeyökmö, ambazip pomŋi mi melaim eŋgiiga böröŋini börak öne anget. ");
INSERT INTO bmu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yaŋön ambösakonurupnini meköba eŋgömeiga Israel aketka nini toroqeba Anutugö welenqeqeurupŋi maljin. Anutunöŋ mönöwök jöjöpaŋ keuŋi kewö jim jöhöm neŋgiyök, ‘Nöŋön Abraham aka yaŋgö gwölönarökurupŋi teteköŋi qahö mal öŋgöba malmei, i ak kömum eŋgiba malmam.’ Mewö jiba keuŋi mi qahö ölum qei mala korök. Qahöpmö, yaŋön mönö keu jitŋi mi wuataŋgöba mala merak bauköm neŋgimamgöra kaza.” Marianöŋ mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marianöŋ köiŋ karöbut miaŋgö dop Elisabetpuk mala kunbuk miriŋe liliŋgöyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetkö morö meme nalöŋan kam kuŋguiga morö nahöna meyök. ");
INSERT INTO bmu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Morö nahöna meiga miri kösutŋe malgeri aka tinitosolomurupŋi yeŋön Kembunöŋ ak-kömukömu öŋgöŋgöŋi kondel waŋgiyöhi, mi möt asariba yambuk mohotŋe sösöŋgai aket. ");
INSERT INTO bmu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sösöŋgai aka wehön 7 teköiga wahöta anda Anutugö aiwesökŋi morö sileŋe yandimegöra tokoget. Tokoba iwiŋaŋgö qetŋi Zekaraia mi wakaŋ mem waŋgibingöra jiget. ");
INSERT INTO bmu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jigetmö, namŋan jiyök, “Mi qahöpmahöpmö, qetŋi mönö Jon qetpin.” ");
INSERT INTO bmu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jiiga kewö jiget mörök, “Jon qetzanmö, göhö tinitosolomgi yeŋgöreŋök kunŋaŋgö qetŋi mi qahö ahöza.” ");
INSERT INTO bmu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mewö jiget möri kinda iwiŋan yaŋgö qetŋi qetmapkö qesiba böröŋinan kaisöpsöp alget. ");
INSERT INTO bmu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kaisöpsöp algetka tafegöra qesii waŋgigetka miaŋgöreŋ kulem kewö ohoyök, “Qetŋi mi Jon.” Mewö ohoiga miaŋgöra körek aurum tililiŋgöget. ");
INSERT INTO bmu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aurum tililiŋgögetka miaŋgöreŋök numbuŋi amgöiga nesilamŋi lolohoiga keu jiba Anutu möpöseiyök. ");
INSERT INTO bmu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Möpöseiiga miri alaurupŋini pakpak yeŋön qemsömbuŋini gwötpuk mötket. Mötketka yuai asuhuyöhi, miaŋgö buzupŋi eraum mötketka sehiba Judia kunduŋi gölme pakpak dop kölök. ");
INSERT INTO bmu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Buzupŋi eraum mötketka körekŋan mi möta urukönömŋine ala aŋgön kölget. Kembunöŋ kukösumŋi morösepsep qakŋe mokoi malöhi, miaŋgö könaŋi möt asariba kewö jiget, “Morö kiaŋön qariba mönö wani yuaia kun denöwö akŋa?” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mewö jigetka Uŋa Töröŋan iwiŋi Zekaraiagö uruŋi kokolak qeiga kezapqetok keu kewö jiyök, ");
INSERT INTO bmu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nini Israel neŋgöreŋ Kembu Anutu möpöseibin. I-ia! Yaŋön mönö könagesöurupŋi mesohol köl neŋgiba sohopnini memamgöra jöjöröba kama. ");
INSERT INTO bmu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anutunöŋ welen aziŋi kiŋ Deiwidkö könagesö neŋgö sutnineyök azi kukösumŋambuk kuŋgui wahöta Amötqeqe Tonina akŋa. ");
INSERT INTO bmu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Möpŋaŋgö möpŋeyök kezapqetok ambazipurupŋi tök-kutukutuŋi i sölöhöm eŋgii keu jit kewö jiba malget, ");
INSERT INTO bmu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Nöŋön mönö kerökurupŋini yeŋgö ösumŋini qebi eriga bohonŋini jöhömam. Denike yeŋön kazik ak eŋgimei, nöŋön mönö körek yeŋgö böröŋineyök meköba sel jöhöm eŋgimam.’ ");
INSERT INTO bmu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Keu mewö jiba bömönurupnini ak kömum eŋgiba yembuk jöhöjöhö areŋ qainŋi kun jöhöyöhi, mi mötmöriba wuataŋgöiga amötqeqegö ölŋi asuhuma. ");
INSERT INTO bmu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jöhöjöhö keu mi bömönini Abrahamgöra jiba jöjöpaŋ keunöŋ jim köhöii ahöza. ");
INSERT INTO bmu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jöhöjöhö keu miaŋgö ölŋi kewö: Yaŋön nini kerökurupnini yeŋgö böröŋineyök meköm neŋgiiga yeŋgöra keŋgötnini qahö möta welenŋi qem waŋgiba malbin. ");
INSERT INTO bmu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yaŋön keunini jim teköi solaniba yaŋgö jeŋe sarakŋi aka malmalnini ölulup mewö mala kömumbin. ");
INSERT INTO bmu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","O gömokni Jon, göŋön qariba mala qeljiŋe mala ambazip uruŋini mindiŋgöba mewö miaŋön Kembugö könaŋi mesatnöŋga kama. Miaŋgöra qetki ‘Anutu öŋgöŋgöŋi ketaŋaŋgö kezapqetok azia,’ mewö qetketka malman. ");
INSERT INTO bmu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mewö mala amötqeqegö könaŋi mi Anutugö könagesöurupŋi kusum eŋginöŋga mi möt kutuba uruŋini meleŋgetka Anutunöŋ siŋgisöndokŋini saŋgoŋda mosötma. ");
INSERT INTO bmu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutuninan uruŋan jöpaköba ak kömum neŋgimakza. Mewö aka mesohol köl neŋgiba undiŋi euyaŋgöreŋök ali gilikbilik akza. Mewögöra neŋön mönö waŋgaraŋ surui aukŋe asaribingö akzin. ");
INSERT INTO bmu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nini pandamanöŋ jipjap taringa kömupkö kondotkondot Toŋan aum köl neŋgimakzapmö, wehön jiliŋbölaŋ kota qaknine kuŋguba mem asarim neŋgima. Mem asarim neŋgiiga luaigö könaŋi aukŋe asuhui eka miaŋgöreŋ aŋgota tiba kinbin.” Zekaraianöŋ mewö jiyök. ");
INSERT INTO bmu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Morö Jon yaŋön qariba wahöriga Uŋa Töröŋan inahöm waŋgiiga Anutugö kolek azi köhöikŋi ahök. Mewö aka gölme qararaŋkölkölŋe mala mali nalöŋan kam kuŋguiga Israel könagesö yeŋgö jeŋine aukŋe asuhuba qenjarök nupŋi könahiba meyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jon O-melun azinöŋ ahuiga nalö miaŋgöreŋ sisa kiŋ Ogastus yaŋön Rom sitinöŋ gölmeŋi gölmeŋi galöm köl eŋgiyök. Galöm köl eŋgiba takis könahiba memegöra gawmangö jimkutukutu aliga gölmeŋi gölmeŋi pakpak yeŋön tokogetka kuskus (sensus azi) yeŋön qetŋini papianöŋ ohoba areŋgöget. ");
INSERT INTO bmu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Areŋ nup mi nalö mutukŋa meget. Megeri, nalö miaŋgöreŋ azi qetŋi Qirinius yaŋön Siria prowinsgö premiö mala galöm köl eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ogastusnöŋ jimkutukutu aliga ambazip körek pakpak yeŋön öröba anda qetŋini areŋnöŋ ohomegöra nanŋini ahuahu miri bohonŋini dop anget. ");
INSERT INTO bmu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Galili prowinsgö taon qetŋi Nazaret miaŋgöreŋ azi qetŋi Josef malök. Yaŋgö amböŋi mi kiŋ Deiwid. Kiŋ Deiwidkö taonŋi qetŋi Betlehem mi Judia prowinsnöŋ ahöyök. Miaŋgöra Josefnöŋ Nazaret mosöta öŋgöba geba Betlehem anök. ");
INSERT INTO bmu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Anmam jiiga nalö miaŋgöreŋ ambi buŋaŋi qetŋi Marianöŋ gölömŋambuk malök. Maliga i auaŋgita qetŋiri ohomegöra mohotŋe anohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Anda Betlehem aŋgorohotka Mariagö morö meme nalöŋan kam kuŋguyök. ");
INSERT INTO bmu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kam kuŋguiga qenjarök ahöahö mire aŋgota miaŋgö uruŋe tiŋi qahö miwikŋaiyohot. Miaŋgöra bau bulmakau miriŋe öŋgöba tarohot. Tata miaŋgöreŋ nahönŋi mutukŋi memba oponöŋ esuhuba bulmakau joutŋe ali geba ahöyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Betlehem taon gölme miaŋgöreŋ azi tosatŋan suŋgem dop gölme köröŋi miaŋgöreŋ anda lama kambuŋini galöm köl eŋgiba malget. ");
INSERT INTO bmu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mewö malgetka suŋgem miaŋgöreŋ Kembugö garata kunŋan kösutŋine asuhum eŋgiyök. Asuhum eŋgiiga Kembugö asakmararaŋan liliköm eŋgiba asariiga qem sömbuŋini möta jönömŋini unduyök. ");
INSERT INTO bmu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jönömŋini unduyökmö, Suep garatanöŋ jii mötket, “Mönö kezap alget. Nöŋön sösöŋgai Buŋa ketaŋi ambazip körek pakpak yeŋgöra memba kazal, mi indel eŋgimam. Miaŋgöra jönömŋini kude unduma. ");
INSERT INTO bmu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Buŋa mi kewö: Eŋgö Amötqeqe Toŋinan dölki ahuza. Yaŋön kiŋ Deiwidkö taonöŋ asuhuba Kembu qetŋi Kraist akza. ");
INSERT INTO bmu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Keu miaŋgö aiwesökŋi kewö: Iŋini anda morö sepsep oponöŋ esuhuba bulmakau joutŋe alget ahözawi, mi miwikŋaime.” ");
INSERT INTO bmu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Garatanöŋ mewö jiiga miaŋgöreŋök garata kambu ketaŋan Suepnöhök kaŋgota yambuk aitoŋgöba Anutugö möpömöpösei liŋet köla kewö jiget, ");
INSERT INTO bmu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anutugö qetbuŋaŋi möpöseininga Suepnöŋ euyaŋgöreŋ öŋgöza. Yaŋön ambazip nanŋaŋgöra meköm eŋgiyöhi, yeŋgöra körö ölöwak möta gölmenöŋ luai al eŋgiza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Garata yeŋön eŋgömosöta Suepnöŋ liliŋgöba öŋgögetka lama galöm yeŋön naninak kewö jiget, “Ayop, Betlehem miaŋgöreŋ yuai ahuiga Kembunöŋ miaŋgö keuŋi jii mötzini, nini mönö mia anda ekin.” ");
INSERT INTO bmu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mewö jiba ösumŋinan anda Maria Josef aka morösepsep bulmakau joutŋe ahöyöhi, miwikŋaiba eket. ");
INSERT INTO bmu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Eka kinda garatanöŋ morögöra keu jii möta kageri, mi indela jim asariget. ");
INSERT INTO bmu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jim asarigetka mötkeri, yeŋön körek pakpak auruba welipköget. ");
INSERT INTO bmu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Welipkögetmö, Marianöŋ keu pakpak mi uru könömŋe ala dumgöba jöhöba könaŋi mötmöriba malök. ");
INSERT INTO bmu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Welipkögetmö, yuai pakpak Suep garatanöŋ jiyöhaŋgö dop asuhuyöhi, mi lama galöm yeŋön eka möta miaŋgöra Anutugö sösöŋgai liŋet köla möpöseiget. Möpöseiba mosöta liliŋgöba anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jisös ahui Sonda mohot miaŋgö dop teköiga Anutugö aiwesökŋi sileŋe yandibingö nalöŋi kaiga qetŋi Jisös qetket. Suep garatanöŋ qet mi mutuk qeta waŋgiigun nalö miaŋgöreŋök namŋaŋgö gölöm uruŋe ahuyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosesgö Köna keunöŋ keu kewö ahöza, “Ambinöŋ morö nahönŋi mutukŋi memba silim 40 koumŋe mali teköiga sörö guluŋi köl könjörat waŋgiba iŋini mönö jöwöwöl jikenöŋ öŋgöba morö mi Anutugö jeŋe algetka yaŋgö buŋaya akŋa.” Miaŋgöra nalö mi kam kuŋguiga Josef Maria yetkön keu mi tem köla Jisös waŋgita Kembugö buŋaya akŋapköra Jerusalem öŋgöyohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kembugö Köna keunöŋ keu kewö ohoget ahöza, “Morö nahön pakpak sep mutuk mokozei, mi mönö Kembugö buŋaya akŋapköra qem teköba mem sarahime.” Yetkön keu mi wuataŋgöyohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mewöyök Kembugö Köna keunöŋ jimkutukutu keu ahözawaŋgö dop kembö me kembö supsup nei yahöt mi jöwöwöl ohomahotköra Jerusalem sitinöŋ öŋgöba anohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nalö miaŋgöreŋ azi kun qetŋi Simeon Jerusalem malök. Yaŋön uruŋi jömuk Anutugöreŋ qekötahöba urumeleŋgö kölguliguli aiga Uŋa Töröŋan yambuk kiniga Amötqeqe Toŋan Israel uruŋe asuhumapköra mamböta malök. ");
INSERT INTO bmu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mamböta maliga Uŋa Töröŋan keu kewö indeli mörök, “Gi Kembugö Amötqeqe Toŋi Kraist ahui mutuk ekagun kömupkö sihimbölöŋi mötman.” ");
INSERT INTO bmu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iwinamŋan Mosesgö Köna keu wuataŋgöba Jisös waŋgita jöwöwöl jikenöŋ öŋgöyohot. Öŋgöyohotka Uŋa Töröŋan Simeon sölölöhöi nalö miaŋgöreŋök mewöyök jikenöŋ öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Öŋgöba morö mi eka memba dohongöba Anutu möpöseiba kewö jiyök, ");
INSERT INTO bmu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Kembu, merak welen azigan ölöp anda uruluainöŋ mala kömuma. ");
INSERT INTO bmu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Göhö keugahö dop Amötqeqe Toŋi melainöŋ asuhuiga i nani jenan eka simbawoŋ mötzal. Miaŋgöra ölöp anda kömumam. ");
INSERT INTO bmu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Göŋön amötqeqegö könaŋi mözözömgöba kantri pakpak yeŋgöra indel eŋginöŋga mi eka möt kutume. ");
INSERT INTO bmu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Göŋön Amötqeqe Toŋaŋgö asakŋi indelnöŋga kian kantri yeŋgö uruŋini kuŋguiga asarime aka qetbuŋagan nangi könagesögi Israel neŋgö sutnine mewöyök qarima.” ");
INSERT INTO bmu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeonöŋ morögöra keu mewö jiiga iwinamŋan möta köŋkuŋ aka welipköyohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Welipköyohotka kötuetköm eŋgiba namŋi Maria kewö jii mörök, “Mötnöŋ, Anutunöŋ morö ki kuŋguba ali Israel ambazip sehisehiŋan i andö qeba eta eŋgugetka gwötpukŋan uruŋini meleŋda ölöwakŋe. Anutunöŋ nanŋak i ali aiwesök aiga gwötpukŋan i tuaköpek jim waŋgime. ");
INSERT INTO bmu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tuaköpek jim waŋgigetka urumötmötŋini asa-asambötŋan mewö aukŋe asuhuma. Nangi urugan mewöyök wösöbirik aiga miaŋön sou zuluk alalŋi ewö urugi kuŋguba qesiŋma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jerusalem miaŋgöreŋ kezapqetok ambi namŋi kun qetŋi Ana malök. Yaŋgö isikŋi qetŋi Aser, iwiŋi qetŋi Fanuel. Ambi miaŋön seramŋe azi memba mali yambu (yara) 7 mohotŋe malohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Malohotka apŋi kömui malö aka mala kori nalö miaŋgöreŋ yambuŋi 84 ahök. Yaŋön nalö dop jöwöwöl jikenöŋ öŋgöba mi silim kun qahö mosörökmö, suŋgem asak Anutugöra nene siŋgi mala köuluköba waikŋi memba möpöseiba malök. ");
INSERT INTO bmu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yaŋön nalö miaŋgöreŋök kaŋgota morö mi eka Anutu möpöseiyök. Anutunöŋ Jerusalem ambazip sohopŋini memapköra mamböta malgeri, körek yeŋgöra morö miaŋgö könaŋi jim asarii mötket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josef Maria yetkön Kembunöŋ areŋi jim kutuiga Köna keunöŋ ahözawi, mi körek ahot teköiga Galili prowinsnöŋ liliŋgöba taonŋiri Nazaret miaŋgöreŋ anohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Morönöŋ qariba wahöta köhöiba mötkutukutuŋi ahuba kokolak qeiga Anutugö kalem möriamŋan qakŋe öŋgöi kinök. ");
INSERT INTO bmu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jisös iwinamŋan yambu (yara) dop ak-kömukömu kendon nalöŋe Jerusalem siti öŋgöba anjahotma. ");
INSERT INTO bmu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mewö mala Jisös yambu (yara)ŋi 12 aiga silikŋini ahakzeaŋgö dop nalöŋi kam kuŋguiga mewöyök öŋgöba anget. ");
INSERT INTO bmu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Anda mala kendon nalö miaŋön teköiga liliŋgöba miriŋire anohot. Anohotmö, morö gwabö Jisösnöŋ Jerusalem tari iwinamŋan mi qahö möt kutuyohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Yaŋön ambazip kambu yembuk anja,” jiba silim mohotkö dop köna anda sepkitip aka alaurupŋiri yeŋgö uruŋine qeta jaruyohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Qeta jaruyohotmö, qahö miwikŋaiba kunbuk liliŋgöba Jerusalem anda jaruyohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jaruba malohotka silim karöbut teköiga jöwöwöl jikenöŋ öŋgöba miaŋgöreŋ miwikŋaiyohot. Miwikŋaiyohotka azi ketaŋi yeŋgö sutŋine tarök. Tari kusum waŋgigeri, mi möta qesim eŋgiba tarök. ");
INSERT INTO bmu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tata Buŋa keugö könaŋi törörök möt asariba diŋdiŋanök meleŋniga körek pakpak yeŋön mi möta welipköget. ");
INSERT INTO bmu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iwinamŋan eka auruba namŋan jii mörök, “Nahöni, gi denöwögöra mewö ak netkizan? Mötnöŋ, niri iwigabuk göhöra waimanjat möta qeta jaruba malit.” ");
INSERT INTO bmu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mewö jiiga kewö meleŋ etkiyök, “Iŋiri mönö wuanöŋgöra ni göraim niŋgizahot? Ni Iwinaŋgö mire tatpi dop kölja, mi mötzahot me qahö?” ");
INSERT INTO bmu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mewö meleŋ etkiyökmö, yetkön keu jiyöhi, miaŋgö könaŋi mi qahö möt asariyohot. ");
INSERT INTO bmu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Qahö möt asariyohotmö, töndup wahöta yetpuk liliŋgöba Nazaret taonöŋ anda iwinamŋi tem köl etkiba malök. Jisösnöŋ keu jiyöhi, namŋan mi pakpak möta urukönömŋe ala jöhöba aŋgön kölök. ");
INSERT INTO bmu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisösnöŋ mala qarii yambu (yara)ŋi öŋgöiga mötkutukutuŋi asariba sehiiga Anutunöŋ kalem möriamŋi waŋgii köhöiba ambazip aka Anutu yeŋgö jeŋine dop köl eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Zekaraiagö nahönŋi Jon yaŋön nupŋi könahiyök. Nalö miaŋgöreŋ sisa kiŋ qetŋi Taiberius yaŋön Rom sitinöŋ mala gölmeŋi gölmeŋi mindiriba yambu (yara) 15 azi kembu aka toroqeba galöm köl eŋgii malget. Galöm köl eŋgimamgöra gölmeŋi gölmeŋi Israel liliköba ahözei, mi mesiŋgetka bahöŋi 4 aiga mieŋgö kiŋini 4 mi kewö kuŋguget: Pontius Pailöt, Herod, Filip aka Lisanias. Pontius Pailöt mi Judia prowinsgö premiöŋina malök. Kiŋ Herodnöŋ Galili prowins galöm köl eŋgiyök aka datŋi Filipnöŋ Ituria aka Trakonitis prowins yahöt mieŋgö kembuŋina malök aka Lisanias yaŋön Abilene gölme memba malök. ");
INSERT INTO bmu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jike nup galöm bohonŋini yahöt malohot, qetŋiri Anas aka Kaiafas. Nalö miaŋgöreŋ Zekaraiagö nahönŋi Jon yaŋön gölme qararaŋkölkölŋe maliga Anutugöreŋ Buŋa keu asuhuiga mörök. ");
INSERT INTO bmu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Anutugö Buŋa möta anda Jordan o töwatŋaŋgö kösutŋe miri dop liliköba malök. Liliköba mala Buŋa keunöŋ uruŋini kuŋguba kewö jiba malök, “Iŋini mönö uruŋini meleŋgetka nöŋön o melun mem eŋgimam. Mewö aketka Anutunöŋ siŋgisöndokŋini saŋgoŋda mosötma.” ");
INSERT INTO bmu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Miaŋgö keuŋi mi kezapqetok azi Aisaianöŋ ohoi yaŋgö Buzup Kimbinöŋ kewö ahöza, “Kolek garata kunŋan gölme qararaŋkölkölŋe qeta maliga anda qetŋi kewö mötme, ‘Kembunöŋ kamawo! Miaŋgöra mönö jöjöröba könaŋi mesatket. Mönö uruŋini mindiŋgöba könaŋi qölöleiget. ");
INSERT INTO bmu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Köna örue pakpak mönö qem tigetka diŋdiŋi akŋa. Kunduŋi wanjaŋi pakpak mi mönö qeköba köl qölöleigetka köröŋi akŋa. Köna mösökqösökŋambuk mi mönö möhamgögetka diŋgime. Luhutnöŋ köna misiiga simbiŋsambaŋ tatzawi, mi mönö kutuba mesatketka solanima. ");
INSERT INTO bmu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anutunöŋ oyaeŋkoyaeŋ Toŋi melaii kaiga gölmeŋi gölmeŋi pakpak yeŋön mi eka ek kutume.” ");
INSERT INTO bmu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jonöŋ miaŋgö dop uruŋini kuŋguiga ambazip kambuŋi kambuŋi yeŋön o melun mem eŋgimapköra yaŋgöreŋ kagetka eŋgeka yeŋgöra kewö jiyök, “O qatö moröŋi, iŋini uruŋini qahö meleŋgetka Anutugö irimŋan seholiiga likepŋi meleŋ eŋgimamgö akza. Mi ölöŋ kölbingö goro keuŋi mi mönö daŋön jii möta sömbuŋini möta ki kaze? ");
INSERT INTO bmu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","“Miaŋgöra mönö ölŋanök uruŋini meleŋme. Bölöŋamŋineyök liliŋgögetka ölŋi asuhui mi mönö ahakmemeŋinan aukŋe kondela malme. Uruŋine möndömöndö keu kewö kude mötmörime, ‘Neŋön mönö Abrahamgö gwölönarökŋa malinga Anutunöŋ qahö ayuhum neŋgima.’ Mewö töptöpŋine qemakzemö, ölŋi mi qahö ahakze. Nöŋön miaŋgöra kewö jibi mötket: Anutunöŋ köt ki ölöp jim kutum eŋgiiga letota Abrahamgö gwölönarökurupŋi aka Anutu möpöseimakŋemö, iŋini denöwö? ");
INSERT INTO bmu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Uruŋini qahö meleŋme ewö, Anutunöŋ mönö iŋini ip ewö teŋgöri etpingö akze. Ip pakpak ölŋi ölöpŋi qahö kuŋgumakzei, mi mönö köli etket könöpnöŋ gili geme. Ip mewöŋi kölmamgö kesiŋi lök jitŋi saŋe ala ip könaŋe ali jöjöröba ahöza. Anutunöŋ mönö bölöŋamŋinaŋgö likepŋi meleŋ eŋgima.” ");
INSERT INTO bmu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mewö jiiga ambazip kambuŋi kambuŋi yeŋön kewö qesiba jiget, “Mewögöra nini mönö denöwö ahinga dop kölma?” ");
INSERT INTO bmu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Qesiba jigetka kewö meleŋnök, “Kunŋan maluku yahöt memba maljawi, yaŋön mönö mietköreŋök kun mi malukuŋi qahö i waŋgima aka denike yeŋön neneŋinambuk maljei, yeŋön mönö mewöyök neneŋini qahö yeŋgöra mendeŋ eŋgime.” ");
INSERT INTO bmu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis meme azi tosatŋan mewöyök o melun mem eŋgimapkö kaba qesim waŋgiget, “Böhi, neŋön mönö denöwö ahinga dop kölma?” ");
INSERT INTO bmu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Qesim waŋgigetka jii mötket, “Gawmanöŋ takisgö jim kutum eŋgii ahözawi, dop mi mönö qahö oŋgita meme.” ");
INSERT INTO bmu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yarö azi tosatŋan mewöyök qesim waŋgiget, “Niniato? Neŋön denöwö ahinga dop kölma?” Qesim waŋgigetka kewö jii mötket, “Kungöreŋ moneŋgöra kuŋguba upetkupet aka kiom kude kölmemö, nanŋini töwaŋini memakzei, miambuk mönö urumohok aka ösöŋ malme.” ");
INSERT INTO bmu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ambazip pakpak yeŋön “Jonöŋ Amötqeqe Toŋi Kraist akapuk,” jiba uruŋinan mewö mötmöriget. Miaŋgö könaŋi mötpingö kezapŋini köröpŋi aket. ");
INSERT INTO bmu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mewö aketka Jonöŋ körek yeŋgöra kewö jiyök, “Nöŋön o töhönöŋ melun mem eŋgizalmö, azi kukösumŋi köhöikŋi kun kama. Yaŋgö kukösumŋi öŋgöŋgöŋan mönö nöŋgöreŋ oŋgitma. Yaŋön azi öŋgöŋgöŋi akŋawaŋgöra nöŋön yaŋgö köna esuŋaŋgö kösöŋi bauköba pösatmamgö qötötaŋgömam. Yaŋön mönö Uŋa Töröŋi uruŋine ali könöp bölamŋan köl könjörat eŋgiiga mewö miaŋön melun mem eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yaŋön ölŋi aka kamböŋi mendeŋ etkimamgö sapakŋi memba kaŋgota uba qöröreŋgöba kewötma. Kewöta wit kötŋi tokoba köweŋe almapmö, kamböŋi aka gwaugulapŋi mi mönö usuŋniga könöpnöŋ geba teteköŋi qahö jema.” ");
INSERT INTO bmu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Keu mewöŋi mewöŋi gwötpuk toroqeba jiba uruŋini kuŋguba Ölöwak Buŋa ambazip kambu yeŋgöra jim asariba malök. ");
INSERT INTO bmu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Malökmö, gölme bahöŋaŋgö kiŋ Herod yaŋön datŋaŋgö anömŋi qetŋi Herodias mi ölöŋ meyök aka bölöŋi könaŋi könaŋi aka malöhi, miaŋgö sapŋi Jonöŋ qeba munjurariga jim waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jim waŋgiba bölöŋamŋi kun toroqeba aka Jongöreŋ nupŋi tözöpköba suahö galömŋi jii Jon memba kösö mire alget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jonöŋ ambazip pakpak o melun mem eŋgiba Jisös mewöyök o melun mem waŋgiyök. Mem waŋgii köuluköiga miaŋgöreŋök Suepnöŋ aŋaŋiyök. ");
INSERT INTO bmu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aŋaŋiiga Uŋa Töröŋan meleŋda kembö nei ewö aka Jisösgö qakŋe erök. Mewö eriga Suepnöhök qet kun kewö asuhuyök, “Göŋön mönö nani wölböt nahöna aknöŋga köröni ölöwahiga geknahöm ak gihizal.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jonöŋ Jisös o melun mem waŋgiiga yambu (yara)ŋi 30 miaŋgö dop aiga amötqeqe nupŋi könahiba memba malök. Memba maliga Josefgö nahönŋa akzawi, ambazipnöŋ mewö mötmöriget. Jisös iwiŋi Josef, asaŋi qetŋi Heli. ");
INSERT INTO bmu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jisös amböŋi qetŋi Matat, sukumŋi qetŋi Liwai. Liwai iwiŋi Melki, asaŋi Janai, amböŋi Josef, ");
INSERT INTO bmu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","sukumŋi Matatias. Matatias iwiŋi Amos, asaŋi Nahum, amböŋi Esli, sukumŋi Nagai. ");
INSERT INTO bmu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai iwiŋi Mat, asaŋi Matatias, amböŋi Semen, sukumŋi Josek. Josek iwiŋi Joda, ");
INSERT INTO bmu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","asaŋi Joanan, amböŋi Resa, sukumŋi Zerubabel. Zerubabel iwiŋi Sealtiel, asaŋi Neri, ");
INSERT INTO bmu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","amböŋi Melki, sukumŋi Adi. Adi iwiŋi Kosam, asaŋi Elmadam, amböŋi Er, ");
INSERT INTO bmu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","sukumŋi Josua. Josua iwiŋi Eliezer, asaŋi Jorim, amböŋi Matat, sukumŋi Liwai. ");
INSERT INTO bmu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai iwiŋi Simeon, asaŋi Juda, amböŋi Josef, sukumŋi Jonam. Jonam iwiŋi Eliakim, ");
INSERT INTO bmu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","asaŋi Melea, amböŋi Menna, sukumŋi Matata. Matata iwiŋi Neitan, asaŋi Deiwid, ");
INSERT INTO bmu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","amböŋi Jesi, sukumŋi Obed. Obed iwiŋi Boaz, asaŋi Salmon, amböŋi Nason, ");
INSERT INTO bmu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","sukumŋi Aminadab. Aminadab iwiŋi Admin, asaŋi Arni, amböŋi Hezron, sukumŋi Perez. Perez iwiŋi Juda, ");
INSERT INTO bmu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","asaŋi Jeikob, amböŋi Aisak, sukumŋi Abraham. Abraham iwiŋi Tera, asaŋi Nahor, ");
INSERT INTO bmu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","amböŋi Serug, sukumŋi Reu. Reu iwiŋi Peleg, asaŋi Eber, amböŋi Sela, ");
INSERT INTO bmu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","sukumŋi Kainan. Kainan iwiŋi Arpaksad, asaŋi Siem, amböŋi Noa, sukumŋi Lamek. ");
INSERT INTO bmu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek iwiŋi Metusela, asaŋi Enok, amböŋi Set, sukumŋi Adam. Adam mi Anutunöŋ mei ahuyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","(-) ");
INSERT INTO bmu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jonöŋ Jisös o melun mem waŋgiiga Uŋa Töröŋan uruŋi kokolak qei Jordan onöhök liliŋgöiga waŋgita gölme qararaŋkölkölŋe anök. ");
INSERT INTO bmu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Anda miaŋgöreŋ mali Bölöŋi Toŋan esapköm waŋgii wehön 40 teköyök. Nalö 40 miaŋgöreŋ nene kun qahö nemba mali teköiga neneŋaŋgö kömuyök. ");
INSERT INTO bmu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yakaŋaŋgö kömuiga Bölöŋi Toŋan jii mörök, “Gi Anutugö nahönŋa akzan ewö, mi mönö kondela köt ki jim kutunöŋga letota beret aketka neman.” ");
INSERT INTO bmu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jii möta meleŋnök, “Qahö, Buŋa Kimbinöŋ keu kewö ohoget ahöza, ‘Nenenöhök ambazip malmal qahö neŋgimakza.’” ");
INSERT INTO bmu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Meleŋniga waŋgita kunduŋi köröpŋi kunöŋ öŋgöba gölmegö kantriŋi kantriŋi pakpak mi zilaŋ kondel waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kondel waŋgiba jii mörök, “Nöŋön kantri pakpak mi galöm köl eŋgimamgö kukösumŋi aka inap yuaiŋaŋgö aködamunŋi mi nöŋgö böröne alalŋa ahöza. Miaŋgöra mi nani sihimnaŋgö dop niŋia waŋgimam jiba ölöp waŋgimam. Miaŋgöra yuai pakpak ki mönö göhö böröge almam. ");
INSERT INTO bmu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Miaŋgöra gi waikni memba möpöseim niŋgiman ewö, mi pakpak mönö göhö buŋaya ak teköma.” ");
INSERT INTO bmu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mewö jii möta kewö meleŋnök, “Qahö, Buŋa Kimbinöŋ keu kewö ohoget ahöza, ‘Gi mönö Kembugi Anutu waikŋi memba möpöseiba ia mohot welen qem waŋgiba malman.’” ");
INSERT INTO bmu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Meleŋniga Jisös waŋgita Jerusalem sitinöŋ anda jöwöwöl jikegö boŋe euyaŋgöreŋ öŋgöba kewö jii mörök, “Gi Anutugö nahönŋa akzan ewö, mönö kiaŋgöreŋök luhuba emu geman. ");
INSERT INTO bmu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Buŋa Kimbinöŋ keu kun kewö ohoget ahöza, ‘Anutunöŋ garataurupŋi jim kutum eŋgiiga ölöpŋanök galöm köla sel jöhöm gihime,’ ");
INSERT INTO bmu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","aka keu kun kewö, ‘Yeŋön böröŋine ala nönögölim gihigetka geba kötnöŋ könage qahö guhum qizit akŋa.’” Miaŋgöra geba kude ayuhuman. ");
INSERT INTO bmu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mewö jiyökmö, Jisösnöŋ kewö meleŋ waŋgiyök, “Qahö! Anutunöŋ jiza, ‘Gi mönö Kembugi Anutu kude esapköm waŋgiman.’” ");
INSERT INTO bmu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bölöŋi Toŋan esapesap pakpak mi Jisös ak waŋgii teköiga mosöta anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisösnöŋ gölme qararaŋkölkölŋi mosöri Uŋa Töröŋaŋgö ösumŋan yambuk kiniga Galili prowinsnöŋ liliŋgöyök. Liliŋgöiga keu buzupŋan sehiba miri gölme liliköba tat angeri, mi pakpak dop köla anök. ");
INSERT INTO bmu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dop köli miriŋi miriŋi liliköba köuluk miriŋine öŋgöba Buŋa keu kusum eŋgiyök. Kusum eŋgiiga mötkeri, körek yeŋön mönö söŋgaiba möpöseim waŋgiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisösnöŋ liliŋgöba malqarip taonŋi Nazaret miaŋgöreŋ anök. Sonda kendonöŋ kaiga ahakzawaŋgö dop köuluk mire öŋgöba Buŋa Kimbi oyoŋ eŋgimamgö wahörök. ");
INSERT INTO bmu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wahöri kezapqetok azi Aisaiagö Buzup Kimbi waŋgigetka kötula keu kembaŋi kewö ohoget ahözawi, mi miwikŋaiyök: ");
INSERT INTO bmu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kembugö Uŋa Töröŋan nöŋgö urune geba nup memegö kelök supapŋi köl niŋgiba ambazip etqeqeŋi yeŋgöra Ölöwak Buŋa jim asarimakzal. Yaŋön melaim niŋgiiga keu kewö jim sehimakzal: Bölöŋan gwaröhöm eŋgii maljei, Anutunöŋ mönö i pösata meköm eŋgiiga malme. Anutunöŋ jegömöl ambazip jeŋini mem tohoiga kunbuk uba ekŋe. Taikpaik memba eta alget maljei, Anutunöŋ mönö i meköm eŋgiiga siyoŋsayoŋi qahö malme. ");
INSERT INTO bmu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kembunöŋ amötqeqegö yambu ölöpŋi ali kam kuŋgumawi, nöŋön miaŋgö kolekŋa kaba mi jim asarimakzal.” ");
INSERT INTO bmu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Keu mewö oyoŋda köpep supap mi köpeiba galömŋi waŋgiba eta tarök. Tariga köuluk mire tatkeri, yeŋön körek je qisilmisilŋi qahö dörötköba ehiget. ");
INSERT INTO bmu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ehigetka könahiba kewö jii mötket, “Buzup Kimbigö keu ki oyoŋbi kezapŋine gei mötzei, miaŋgö ölŋan mönö merak asuhuza.” ");
INSERT INTO bmu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mewö jii mötketka kalem möriam keuŋi keuŋi numbuŋeyök eriga körekŋan mi möta welipköba jim soroköm waŋgiba keu miaŋgö jiji-kilik-kilikŋi mi kewö jiget, “Azi ki Josefgö nahönŋa me?” ");
INSERT INTO bmu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jigetka kewö jii mötket, “Iŋini nalöŋi nalöŋi keu kötŋi ki jimakze, ‘Mem ölöwak azi gi mönö nangi mem ölöwak aŋguman.’ Iŋini keu kötŋi mi dölki nöŋgöra jibingö mötze, mi mötzal. Mi jiba kewö jibeak, ‘Gi Kaperneam taonöŋ anda aŋgöletot öŋgöŋgöŋi menöŋga buzupŋi mörini, miaŋgö dop mönö nangi miri kiaŋgöreŋ mewöyök meman.’” ");
INSERT INTO bmu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mewö jiba jiyök, “Nöŋön keu ölŋi kun kewö jibi mötme: Kezapqetok ambazip kunöŋ mönö nanŋi malqarip taonöŋ qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nöŋön keu ölbölŋi kun kewö jibi mötme: Elaijagö (Elia) nalöŋe Anutunöŋ Suep naŋguŋi köli yambu (yara) karöbut aka köiŋ 6 miaŋgö uruŋe kie qahö yöhöiga bödi ketaŋi ahuiga gölme pakpak dop kölök. Nalö miaŋgöreŋ ambi malö gwötpuk Israel uruŋe malget. ");
INSERT INTO bmu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gwötpuk malgetmö, Anutunöŋ Elaija yeŋgöreŋök kungöreŋ anmapkö qahö melaiyökmö, kian gölme Saidongö miri qetŋi Sarefat miaŋgöreŋ ambi malö mohot-töp yaŋgöreŋ melaiiga anök. ");
INSERT INTO bmu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kezapqetok azi Elisagö nalöŋe uzikukunöŋ Israel azi gwötpuk turum eŋgiiga malgetmö, yeŋgöreŋök kunŋan kun qahö solaniyök. Qahöpmö, kian gölme Siriagö azi qetŋi Naman yaŋön mohot-kun mönö Elisagö keuŋi möt nariba solaniba ölöwahök.” ");
INSERT INTO bmu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisösnöŋ mewö jiiga köuluk mire tatkeri, yeŋön körek keu mi möta irimŋini seholiiga urupik aket. ");
INSERT INTO bmu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Urupik aka wahöta Jisös közöla taon yaigepŋe wuataŋgöba taon mi kunduŋaŋgö sem kösutŋe meget kinöhi, miaŋgöreŋ aköget gemapköra anget. ");
INSERT INTO bmu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Angetmö, sutŋine qendeŋda eŋgömosöta anök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisösnöŋ Galili prowins uruŋe Kaperneam sitinöŋ eta aŋgota Sabat kendonöŋ ambazip kambu kusum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kusum eŋgiiga keuŋan kukösumŋambuk aiga jiyök. Miaŋgöra könagesö yeŋön mi eka auruba welipköget. ");
INSERT INTO bmu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Köuluk miri miaŋgöreŋ azi kun ömeŋambuk tarök. Tariga ömeŋan teriŋgöba silata qetŋi kewö qerök, ");
INSERT INTO bmu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aek! Jisös, Nazaret azia! Gi wania ak neŋgimamgö akzane? Mönö ayuhum neŋgimamgöra kazan me? Ni könaŋamgi möt kutuzal. Gi Anutugöreŋ azi Tök-kutukutuŋi akzan.” ");
INSERT INTO bmu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mewö qeriga Jisösnöŋ tembula kewö jim waŋgiyök, “Gi mönö keugi bököiga azi ki mosöta kesalnöŋ.” Mewö jim waŋgiiga ömenöŋ azi mi memba gili tala sutŋine gölmenöŋ geiga miziqizikŋi qahöpmahöp aka kota mosöta anök. ");
INSERT INTO bmu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aniga körekŋan nemböŋini teköiga welipköba sutŋine eraum möta kewö jiget, “Yei! Keu ki mönö wani keuya? Yaŋön kuk aka ösum-mumu qakŋe ömewöröme jim kutum eŋgiiga tem köla kota anje.” ");
INSERT INTO bmu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mewö asuhuiga Jisösgö qetbuŋaŋan sehiba miri pakpak kösutŋe tat angeri, miaŋgöreŋ anda gölme mi dop kölök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisösnöŋ wahöta Kaperneam köuluk miri mi mosöta Saimon Pitögö mire öŋgöyök. Öŋgöiga Saimongö suhunŋan sile könöp öŋgöŋgöŋi yöhöi ahöyök. Ahöiga yaŋgöra aka Jisös köuluköm waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Köuluköm waŋgigetka anda sipköba geba sile könöp jim kutum waŋgiiga mosöriga miaŋgöreŋök wahöta nene ohoba gumohom eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wehön jeŋi teköba geiga miaŋgöreŋ ambazip denike yeŋön alaurupŋini kawöl könaŋi könaŋi miaŋön eŋgöhöi ahögeri, mi körek eŋguaŋgita Jisösgöreŋ kaget. Kagetka böröŋi körek yeŋgö qakŋine inanŋik inanŋik aliga ölöwak teköget. ");
INSERT INTO bmu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ömewöröme yeŋön mewöyök ambazip gwötpuk yeŋgö uruŋineyök kota silata kewö qetket, “Gi Anutugö nahönŋi akzan.” Jisösnöŋ Amötqeqe Toŋi Kraist akzawi, yeŋön mi mötkeraŋgöra Jisösnöŋ jim eŋgiba numbuŋini muhungöba eŋguataŋgöyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jisösnöŋ gaun ahöiga miri waŋgaraŋ suruiga wahöta nanŋik tiriŋ (tiŋ) kutuba geba göraŋe kunöŋ anök. Anökmö, ambazip yeŋön göraim waŋgiba anda miwikŋaiba kude eŋgömosöta anmapköra esapköba aŋgön köl waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aŋgön köl waŋgigetmö, kewö jii mötket, “Nöŋön Anutu bemtohonŋaŋgö Ölöwak Buŋaŋi mi taon tosatŋi yeŋgöra mewöyök jim asarim eŋgibi dop kölma. Anutunöŋ mönö miaŋgöra melaim niŋgiyök.” ");
INSERT INTO bmu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mewö jiba anda Galili prowins liliköba köuluk miriŋine Buŋa keunöŋ uru kuŋgum eŋgiba malök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nalö kunöŋ Jisösnöŋ Genesaret o aŋgö jitŋe kiniga ambazipnöŋ kambu köla Anutugö Buŋa keu mötpingö ölöqölököba liliköm waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Liliköm waŋgigetka kinda waŋge yahöt köwet göraŋe tarohotka etkehök. Söra örörö yeŋön waŋge mi mosöta geba mösakŋini kusahöla saŋgoŋget. ");
INSERT INTO bmu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Waŋge kun mi Saimongöreŋa. Jisösnöŋ miaŋgöreŋ öŋgöba toŋi kewö qesim waŋgiyök, “Göŋön mönö naŋgönöŋga borom kun noaŋgita onöŋ göröken anma.” Qesim waŋgiiga naŋgöiga anda waŋgenöŋ tata ambazip kambu kusum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kusum eŋgim teköba Saimongöra jiyök, “Göŋön mönö waŋge ki naŋgönöŋga o aŋgö bibiŋe aniga alaurupki yembuk mösakŋini söragöra gilgetka gema.” ");
INSERT INTO bmu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jiiga Saimonöŋ meleŋnök, “Ketaŋamni, nini suŋgem köröp mösak gil bibihiba ölŋi kun qahö mezin. Qahöpmö, göŋön jim kutuzanaŋgöra mönö töndup anda gilin gema.” ");
INSERT INTO bmu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mewö meleŋni jiyöhaŋgö dop aketka söranöŋ awamŋi qahö mösakŋine gegetka buratibingö aket. ");
INSERT INTO bmu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mewö aketka alaurupŋini waŋge kunöŋ malgeri, yeŋgöra kaba bauköm eŋgimegö börökaek kölgetka kaget. Kagetka waŋge yahöt mi söranöŋ kokolak qegetka nemulahöm taköyohot. ");
INSERT INTO bmu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Söra öŋgöŋgöŋi mewö memba eka miaŋgöra körekŋan welipköget. Welipköba Saimon Pitönöŋ mi eka Jisösgö wösöŋe geba simin köla jiyök, “O Kembu, ni siŋgisöndok azia akzalaŋgöra mönö nömosöta anöŋ.” ");
INSERT INTO bmu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimongö alayahötŋi Jeims aka Jon Zebedigö nahönyahötŋi yetkön mewöyök nemböŋiri teköiga welipköyohot. Saimonöŋ keuŋi jiyökmö, Jisösnöŋ kewö meleŋnök, “Mönö keŋgötki kude mötman. Gi kiaŋgö andöŋe ambazip mi söra ewö öröba eŋgömemba malman.” ");
INSERT INTO bmu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mewö jiiga waŋgeŋini öröba kota saknöŋ ala öröyuaiŋini pakpak mosöta Jisösgö andöŋe wuataŋgöba anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisösnöŋ taon kunöŋ maliga miaŋgöreŋ azi kun sileŋi uzikukunöŋ mem bölim teköiga tarök. Tata Jisös eka kösutŋe simin köla geba kewö köuluköm waŋgiyök, “O Kembu, göŋön sihimgan mem ölöwak niŋgimamgö mötzan ewö, mönö ni ölöp mem solanim niŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mewö jiiga böröŋi böraŋda sileŋi misiriba jiyök, “Nöŋön mi akŋamgö mötzal. Gi mönö solaniman.” Mewö jiiga uzikukuŋi mi miaŋgöreŋök solaniyök. ");
INSERT INTO bmu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Solaniiga kewö jim kutum waŋgiyök, “Mötnöŋ kiaŋgö buzup keuŋi mi kun kude jinöŋ mötme. Qahöpmö, gi mönö jike nup galömgöreŋ anda silegi kondel waŋgiba Mosesgöreŋ jimkutukutuŋi wuataŋgöba solanizanaŋgö saiwap nalukŋi ala jöwöwöl ohoman. Mi ohonöŋ ehiga ambazipnöŋ könaŋamgi möt kutume.” ");
INSERT INTO bmu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mewö jiyökmö, mi töndup Jisösgö qetbuŋaŋi sehiba miri dop asariba anök. Anöhaŋgö dop ambazip kambuŋi kambuŋi yeŋön keuŋi mötpingö aka kawölŋini mem ölöwakŋapkö yaŋgöreŋ kaba tokoget. ");
INSERT INTO bmu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kagetmö, Jisösnöŋ eŋgömosöta gölme qararaŋkölkölŋe anda mala köuluköyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jisösnöŋ wehön kunöŋ Buŋa keu kusum eŋgiiga Farisi (Köna keugö kapaŋkölköl) aka Köna keugö böhi tosatŋan Galili aka Judia prowinsgö miriŋi miriŋi aka Jerusalemök kaba ambazip kambu sutŋine tatket. Kembugö kukösumŋan Jisös nam köl waŋgiiga ambazip kawölŋini mei ölöwaket. ");
INSERT INTO bmu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nalö miaŋgöreŋ azi tosatŋan alaŋini sile likepŋi kömukömuŋi mi kululunöŋ ala aŋguba kaget. Kaba kutuba Jisösgö kösutŋe miri uruŋe öŋgöba albingö esapköget. ");
INSERT INTO bmu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Esapkögetmö, ambazip kambunöŋ ölököba kingeraŋgöra paŋpaŋgöba miri uruŋe öŋgöbingö köna kun qahö miwikŋaiba memba miri qakŋe öŋgöget. Öŋgöba bo kötnöŋ memeŋi mi esim luluŋgetka kinimŋi ahui kawöl azi kululuŋambuk kösönöŋ jöhöba miaŋgöreŋ algetka ambazip sutŋine Jisösgö wösöŋe geyök. ");
INSERT INTO bmu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mewö geiga Anutu möt narim waŋgigeri, Jisösnöŋ yeŋgö tandökŋini mi ehi dop köliga kawöl azigöra kewö jiyök, “Alani, nöŋön siŋgisöndoki mosötzal.” ");
INSERT INTO bmu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mewö jiiga Köna keugö böhi aka Farisi yeŋön mi möta könahiba kewö jiba mötmöriget, “Azi ki niŋia? Yaŋön mönö Anutu ilita mepaqepaik akza. Anutu mohotŋan siŋgisöndoknini mosörakzapmö, azi kunŋan mi qahö.” ");
INSERT INTO bmu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mewö mötmörigetmö, Jisösnöŋ uruŋini ek kutuba kewö jii mötket, “Tosatŋi iŋini uruŋinan wuanöŋgöra keu jizali, miaŋgöra gwötpuk mötmörize? Mi qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Nöŋön siŋgisöndoki mosötzal, jizali, keu miaŋön mönö awamŋanök jijiŋa. Kunŋan mewö jiiga tosatŋan keu miaŋgö ölŋi qahö ekŋe. Miaŋgöra mi keu awamŋaŋgö dop. Nöŋön keu kun kewö jimamamgö mötzal, ‘Mönö wahöta anöŋ.’ Keu mi mönö lömbötŋambuk jijiŋa akza. Mewö jibiga ölŋi asuhuma me qahöwi, miaŋön mönö aukŋe asuhui ekŋe. ");
INSERT INTO bmu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mötket, gölmenöŋ siŋgisöndok mosötmosötkö kukösumŋi mi Suep gölmegö azi ölŋaŋgöreŋ ahözawi, iŋini miaŋgö könaŋaŋgöra jaŋjuŋ malbepuk. Miaŋgöra keu lömbötŋi mi azi kiaŋgöra jibi ölŋi eket.” Mewö jiba azi sile likepŋi kömukömuŋi yaŋgöra jiyök, “Nöŋön göhöra jizal: Gi mönö wahöta tumbulahöpki memba mirige anöŋ. Keu lömbötŋi mi ölŋambuk akŋa ewö, keu awamŋi mi mönö mewöyök denöwögöra omaŋi akawak?” ");
INSERT INTO bmu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mewö jiiga miaŋgöreŋök jeŋine wahöta tumbulahöpŋi ahöyöhi, mi memba Anutu möpöseiba mosöta miriŋe anök. ");
INSERT INTO bmu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mewö asuhuiga ambazip körekŋan welipköba sömbuŋini möta Anutu möpöseiba jiget, “Yei! Merak yuai qetpuk soroha ekzin.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Miaŋgö andöŋe Jisösnöŋ Kaperneam mosöta anda takis ofis oŋgitmamgö aiga miaŋgöreŋ takis meme azi qetŋi Liwai tariga eka jii mörök, “Gi mönö nöŋgö andöne kanöŋ.” ");
INSERT INTO bmu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mewö jii möta nupŋi pakpak mosöta wahöta Jisösgö andöŋe anök. ");
INSERT INTO bmu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Anda Jisös miriŋe köl öröba yaŋgöra közölömbuaŋ ketaŋi mözözömgöyök. Mözözömgöba takis meme tilipqilipŋinambuk aka alaurupŋi tosatŋi öröm eŋgiiga kambu ketaŋi köla yembuk tata nene neget. ");
INSERT INTO bmu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mewö negetka Farisi (Köna keugö kapaŋkölköl) aka yeŋgöreŋ böhi yeŋön mi eka jimoŋgot aka Jisösgö gwarekurupŋi kewö jim eŋgiget, “Aek! Iŋini mönö wuanöŋgöra takis meme tilipqilipŋinambuk aka siŋgisöndok ambazip yembuk tata nene aka o neze? Mi qahö dop kölja.” ");
INSERT INTO bmu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mewö jim eŋgigetka Jisösnöŋ likepŋi kewö jii mötket, “Sile unditundit ambazipnöŋ doktagöra qahö ak eŋgimakzapmö, kawöl ambazipnöŋ mönö doktagöreŋ anakze. ");
INSERT INTO bmu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nöŋön siŋgisöndok ambazip uruŋini meleŋmegö eŋgoholmamgöra kaba maljalmö, ambazip nanŋinaŋgö mötketka solanŋi akzei, i qahö.” ");
INSERT INTO bmu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ambazip tosatŋan Jisösgöreŋ kaba qesiget, “Jon O-melun azigö gwarekurupŋi neŋön nalö gwötpuk Anutugöra nene siŋgi mala köuluk totoko köröpŋi alakzin. Farisi (Köna keugö kapaŋkölköl) yeŋgö gwarekurupŋinan mewöŋanök aka maljemö, nangi gwarekurupkan mönö pöndaŋ nene aka o nemakze.” ");
INSERT INTO bmu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mewö qesigetka kewö meleŋnök, “Ölŋa! Nini wani nalönöŋ nene siŋgi malakzin? Ambi meme nalöŋe azigö andöurupŋan könöpŋi algetka ambigö sep kitipurupŋan yuai mi tökömakze me qahö? Nöŋön nani gwarekurupni yeŋgö azi buŋaya aka yeŋgö sutŋine köisirik tatzal. Tatpiga siŋgi malbingö jigetka yeŋön aijölöŋ söŋgaiba tata siŋgi malbingö osimakze. ");
INSERT INTO bmu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Osimakzemö, Anutunöŋ noaŋgiri kömumbiga yeŋön mönö nalö miaŋgöreŋ ölöp siŋgi malakŋe. ");
INSERT INTO bmu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","“Iŋini malmal walŋi aka sösöŋgai Buŋa dölökŋi mi mindirim etkibingö osime. Miaŋgö dopkeu pasetŋi kun mi kewö jibi mötket: Löŋgölöŋgöt walŋi jurariga kunöŋ löŋgölöŋgöt dölökŋi mitiba opo su jöhanŋi miaŋön qahö ala uhum göreŋgömakza. Mewö akawak ewö, opo su jöhanŋi dölökŋan mönö walŋambuk öröröŋ qahö aka mi öröba munjurariga böliqölibapuk. ");
INSERT INTO bmu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Mewöŋanök kunöŋ wain o dölökŋi mi jobö me toru walŋi lama sileŋan memeŋi miaŋgöreŋ qahö kusuiga gemakza. Mewö akawak ewö, wain o dölökŋan mönö qariba toru qesiŋniga jula mokoiga gölmenöŋ eta sohoiga toruŋan böliqölibepuk. ");
INSERT INTO bmu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","“Miaŋgöra wain o dölökŋi mi toru dölökŋeyök mokoin geiga dop kölma. (Mewöŋanök kunöŋ o ölöpŋi mi gina gisagisahöŋe qahö umakzin. Mewö ubinak ewö, miaŋön mönö jula kisipisirik eriga nemba kawöl neŋgöhöbapuk. Mewö akapuköra o ölöpŋi mi gina ölöpŋe umakzin. Iŋini mewöyök malmal walŋi aka Ölöwak Buŋa dölökŋi mi mindirim etkibingö osime.) ");
INSERT INTO bmu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kunŋan wain o walŋi möpöseiba nemba malakzawi, yaŋön wain o dölökŋi nemamgö sihimŋi qahö möta ölan alakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Miaŋgö andöŋe Sabat kendon kunöŋ Jisösnöŋ wit padi nup köröŋi ketaŋi kutuba anök. Ani gwarekurupŋan wösöŋini eŋguiga wit ölŋi mohot mohot böröŋinan misiba sömaŋda neget. ");
INSERT INTO bmu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mewö negeraŋgöra Farisi (Köna keugö kapaŋkölköl) tosatŋan mi eka kewö jiget, “Iŋini mönö wuanöŋgöra Sabat kendongö nup meme soŋgoŋi oŋgitze?” ");
INSERT INTO bmu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mewö jigetmö, Jisösnöŋ kewö meleŋnök, “Kiŋ Deiwidnöŋ yarö aziurupŋi yembuk liliköba wösöŋini eŋguiga yuai akeri, mi lök oyoŋget me qahö? ");
INSERT INTO bmu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yaŋön mönö Anutugö opo seri jikenöŋ öŋgöba beret kömbukŋi Anutugö jemesoholŋe altanöŋ alget tariga ösumŋan walöŋniga qekögeri, mi mönö meiga neget. Beret kömbukŋi mosötmosötŋi mi jike nup galöm yeŋönök nezema. Yaŋön aka yaŋgö suŋgurumurupŋan mi nembepuköra soŋgo ahöyök mi töndup neget.” ");
INSERT INTO bmu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mewö jiba kewö jii mötket, “Suep gölmegö azi ölŋan mönö Sabat kendongö Kembuŋi akza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jisösnöŋ Sabat kendon kunöŋ köuluk mire öŋgöba Buŋa kusum eŋgiyök. Miaŋgöreŋ azi kun böröŋi ölŋi soholiiga tarök. ");
INSERT INTO bmu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Köna keugö böhi aka Farisi (Köna keugö kapaŋkölköl) yeŋön Jisös eka keu jakeŋe al waŋgibingö könaŋi jaruba “Azi mi Sabat kendonöŋ möhamgöma me qahö?” jiba je galöm memba tatket. ");
INSERT INTO bmu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tatketmö, Jisösnöŋ mötmötŋini mi möt kutuba azi böröŋi sosoholiŋi mi kewö jii mörök, “Mönö wahöta jenine kinöŋ.” Mewö jiiga wahöta kinök. ");
INSERT INTO bmu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kini Jisösnöŋ jii mötket, “Köna keu wuataŋgöba Sabat kendonöŋ yuai ölöpŋi me bölöŋi akin? Ölöp kungö bohonŋi jöhöbin me mosöringa ayuhuma. Wanat kun meinga dop kölma? Mi qesim eŋgibi jiget.” ");
INSERT INTO bmu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mewö jiba körek pakpak liliŋgöm purik eŋgeka azi miaŋgö jiyök, “Gi mönö börögi qötöteinöŋ.” Mewö jiiga böröŋi qötöteiiga kunbuk ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ölöwahökmö, galöm yeŋön irimŋini gwötpuk seholiiga “Jisös denöwö ak waŋgibin?” jiba nanŋini eraum mötket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nalö miaŋgöreŋ Jisösnöŋ kunduŋe köulukömamgö öŋgöba suŋgem köröp mi Anutu köuluköm waŋgiba mali miri alök. ");
INSERT INTO bmu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Miri giaŋiiga gwarekurupŋi eŋgohola yeŋgöreŋök 12 möwölöhöm eŋgiba melaimelai azi aposol qet mi eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Qetŋini kewö qerök: Saimon, Jisösnöŋ qetŋi Pitö waŋgiyök, yaŋgö munŋi Andru aka Jeims, Jon, Filip, Bartolomyu, ");
INSERT INTO bmu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jeims Alfiusgö nahönŋi aka Saimon qetŋi kun Tuaköpek azi qetket. ");
INSERT INTO bmu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jeimsgö nahönŋi aka Judas Iskariot. Kariot azi miaŋön könaŋgen mamalolo azia ahök. ");
INSERT INTO bmu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisösnöŋ aposolurupŋi yembuk kunduŋeyök eta gölme köröŋe anda kinget. Kingetka gwarek kambuŋi ketaŋi aka ambazip kambulelembe yeŋön yaŋgöra tokoba mambötket. Yeŋön “Buŋaŋi jii möringa kawölnini mem ölöwakŋa,” jiba miaŋgöra Judia prowins pakpak, Jerusalem siti aka köwet jitŋeyök Taiö aka Saidon taon miaŋgöreŋök kaba tokoget. ");
INSERT INTO bmu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ömewörömenöŋ kölköljiŋjiŋ mem eŋgiyöhi, yeŋön mewöyök kaba ölöwaket. ");
INSERT INTO bmu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kukösumŋan yaŋgöreŋök kutuba yeŋgöreŋ öŋgöiga körek ölöwak eŋgiyök. Miaŋgöra ambazip körekŋan Jisös misiribingö jaram tiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisösnöŋ gwarekurupŋi uba wahöta eŋgeka kewö jiyök, “Anutugö bemtohoŋ mi wanapŋi eŋgö buŋaya. Miaŋgöra wanapŋi iŋini mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nalö kewöŋe nenegö ewö kömumba qemjeŋ qeba maljei, Anutunöŋ mönö sihimŋini mi gumohom eŋgima. Miaŋgöra iŋini mönö simbawoŋ akze. Nalö kewöŋe sahötzei, eŋön mönö sösöŋgai aka gön kölme. Miaŋgöra wösöbirik maljei, iŋini mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ambazipnöŋ iŋini Suep gölmegö azi ölŋaŋgöra aka kazik aka yaköriba sileŋe ala uruqeqe keu töhöreŋ jim eŋgiba kiam sekbölö ewö qetŋini kutumei, iŋini mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ambösakonurupŋinan miaŋgö dop kezapqetok ambazip yeŋgöra ak eŋgiba malget. Mötket! Anutunöŋ töwaŋini öŋgöŋgöŋi Suep mire ali ahöza. Miaŋgöra mewö ak eŋgigetka nalö miaŋgöreŋ mönö söŋgaiba köiraŋ kölme. ");
INSERT INTO bmu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Iŋini simbawoŋ maljemö, pomŋi sukinapŋinambuk iŋini malmal siyoŋsayoŋi qahö maljei, mi teköma. Miaŋgöra nöŋön eŋgöra wölziköba ‘Yei!’ jizal. ");
INSERT INTO bmu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nalö kewöŋe nem timbireŋ maljei, iŋini mönö wösöŋini ali (buörö) bödi malme. Miaŋgöra nöŋön eŋgöra wölziköba ‘Yei!’ jizal. Nalö kewöŋe sösöŋgai aka gön köljei, iŋini mönö amburereŋ aka sahötme. Miaŋgöra nöŋön eŋgöra wölziköba ‘Yei!’ jizal. ");
INSERT INTO bmu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ambösakonurupŋinan kezapqetok ambazip takapulakaŋi jim möpöseim eŋgiba malget. Ambazip pakpak miaŋgö dop ak eŋgigetka nöŋön eŋgöra wölziköba ‘Yei!’ jizal.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Bölöŋi ak eŋgimemö, iŋini keuni möta maljei, nöŋön eŋgöra kewö jibi mötme: mönö kerökurupŋini uruŋinan jöpaköm eŋgiba malme. Denike yeŋön kazik ak eŋgizei, i mönö ölöpŋanök ak eŋgiba malme. ");
INSERT INTO bmu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Denike yeŋön qesuahöba jiŋjerereŋ ak eŋgizei, i mönö köl tömbiba kötuetköm eŋgime. Öröm ureim ak eŋgizei, yeŋgöra mönö Anutugö köuluköme. ");
INSERT INTO bmu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Kunŋan nuŋgulumgi likepŋi qekötahöliiga likepŋi mewöyök meleŋ waŋgiman. Kunŋan qakŋaŋgö malukugi goaŋgiriga göŋön mönö dutŋaŋgö opoŋi mohokŋe memamgö möri mi kude aŋgön kölman. ");
INSERT INTO bmu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Yuaigö ulet gihigetka mi mönö körek yeŋgöra eŋgiman. Kunŋan göhö inap yuaigi meiga mi mönö meleŋ gihimapkö kude kapaŋ köla qesiman. ");
INSERT INTO bmu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ambazipnöŋ yuai nanŋinaŋgö ak eŋgimegö mörakzei, miaŋgö dop mönö nanŋini mewöyök i ak eŋgimakŋe. ");
INSERT INTO bmu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Gölmegö siŋgisöndok ambazipnöŋ alaurupŋinan jöpaköm eŋgigetka kitipŋi meleŋda jöpaköm eŋgiba möpöseim aŋgumakze. Iŋini miaŋgö dop gölmegö tandökŋi wuataŋgömakze ewö, Anutugöreŋ tosa qahö ahuiga mönö denöwö iŋini möpöseim eŋgibawak? Alaurupŋini aka kerökurupŋini mi mönö mohotŋe jöpaköm eŋgigetka töwa eŋgiiga oyaeŋkoyaeŋ akŋe. ");
INSERT INTO bmu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Gölmegö siŋgisöndok ambazipnöŋ alaurupŋinan yuai ölöpŋi ak eŋgigetka kitipŋi meleŋ eŋgiba ala ak aŋguba möpöseim aŋgumakze. Iŋini miaŋgö dop aka gölmegö tandökŋi wuataŋgömakze ewö, Anutugöreŋ tosa qahö ahuiga iŋini qahö möpöseim eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Gölmegö siŋgisöndok ambazipnöŋ moneŋ yuai mi siŋgisöndok ambazip tosatŋi yeŋgöra eŋgiba kitipŋi miyök meleŋ eŋgimegöra kapaŋ kölakze. Mi gölmegö ahakmemeya. Iŋini tosatŋan tosaŋini meleŋ eŋgimegö al mambötketka Anutunöŋ mönö denöwö möpöseim eŋgibawak? Tosatŋan tosaŋini qahö meleŋ eŋgigetka Anutunöŋ mönö kitipŋi mi meleŋda töwa eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Iŋini mönö Suep Toŋaŋgö ahakmemeya aka memba malme. Gölme ambazipnöŋ bölöŋi aka saiwap qahö jimakzemö, Anutunöŋ töndup i ölöpŋi ak eŋgimakza. Miaŋgöra iŋini mönö kerökurupŋini uruŋinan jöpaköba ölöpŋanök ak eŋgiba moneŋ yuai eŋgiba miaŋgö likepŋi kun meleŋda eŋgimegöra kude al mambötme. Mewö aka malgetka töwaŋinan sehiba öŋgöŋgöŋi aiga Anutu öŋgöŋgöŋaŋgö nahönböraturupŋi aka malme. ");
INSERT INTO bmu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Suep Iwiŋinan körek pakpak ak kömum eŋgimamgö mötzawi, iŋini mönö miaŋgö dop ambazip pakpak ak kömum eŋgiba malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ambazip tosatŋi yeŋgö keuŋini mi kude kewöta jim teköme. Mi qahö jim teköm eŋgigetka Anutunöŋ mönö nanŋini mewöyök qahö jim teköm eŋgima. Iŋini tosatŋi yeŋgö siŋgisöndokŋinaŋgö likepŋi mi qahö meleŋ eŋgime. Mi qahö meleŋ eŋgigetka Anutunöŋ mönö nanŋini siŋgisöndokŋinaŋgö likepŋi mi mewöyök qahö meleŋ eŋgima. Iŋini mönö tosatŋi yeŋgö siŋgisöndokŋini mosötme. Mi mosötketka Anutunöŋ nanŋini siŋgisöndokŋini mewöyök saŋgoŋda mosötma. ");
INSERT INTO bmu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Iŋini ambazip tosatŋi yeŋgöra yuai ak eŋgigetka Anutunöŋ mönö miaŋgö dop kewöta yuai mi meleŋda eŋgöra ak eŋgima. Miaŋgöra iŋini mönö yuai kalema eŋgimakŋe. Mewö eŋgigetka Anutunöŋ mönö mewöŋanök kalema eŋgimakŋa. Ölŋa, Anutunöŋ ekbonep qahö möta bauköm eŋgimakŋa. Anutunöŋ kewöta iŋini eŋgigeri, miaŋgö dopŋi jömuk memba kiwinöŋ mokoi numbuŋe kori utuköi qöröraŋ aiga mulumgöi gei toroqeba qakŋe mokoi dopŋi oŋgita qeqelaŋlaŋ eri, mi mönö gösöŋine löŋgöt eŋgima.” Anutugö könaŋi mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisösnöŋ dopkeu kun kewö jii mötket, “Jegömöl ambazip kunöŋ jegömöl alaŋi kun ölöp böröŋe memba waŋgitma me qahö? Mewö anbahorak mönö mohotŋe lömnöŋ geba etkubawak. ");
INSERT INTO bmu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Gwareknöŋ böhiŋi qahö oŋgitza. Böhiŋinan mötmöt pakpak törörök kusum eŋgii möt kömumei, körek yeŋön mönö böhiŋini ewö akŋe. ");
INSERT INTO bmu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Gi wuanöŋgöra alagahö jeŋe gödöwöröt morörökŋi ekzanmö, nangi jege ip sahötŋi ketaŋi ahözawi, mia denöwö kude ek kutuzan? ");
INSERT INTO bmu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nangi jege ip sahötŋi ketaŋi ahözawi, mi qahö ek kutuba denöwögöra alagahö kewö jibanak, ‘Alani mötnöŋ! Jege euke gödöwöröt geba tatzawi, mi ölöp itaköbi etma.’ O urumeleŋgö silesile azi, gi mönö mutuk nange jegeyök ip sahötŋi (tapötŋi) ketaŋi mi memba gilman. Mi mem gilagun törörök ek kutuba alagahö jeŋe gödöwöröt geba tatzawi, mi ölöp itakönöŋga etma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ip ölöpŋi kunŋan ölŋi bölöŋi qahö kuŋgumakza. Mewöŋanök ip bölöŋi kunŋan ölŋi ölöpŋi qahö kuŋgumakza. ");
INSERT INTO bmu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jau kötŋi mi jömnöŋ asuhuiga membingö osimakzin aka muli ölŋi mi koururuknöŋ asuhuiga qeköbingö osimakzin. Miaŋgö dop ipkö ölŋi eka kewöta könaŋi möt kutume. ");
INSERT INTO bmu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Azi uruŋan yuai kokolak qei ahözawi, mia mönö numbuŋan aukŋe jimakza. Miaŋgöra azi ölöpŋaŋgö uru köweŋe ölöpŋaŋgö möriamŋi ahözawi, yaŋön mönö ölöpŋi mi aukŋeyök jimakza. Azi bölöŋaŋgö uru köweŋe bölöŋi ahözawi, yaŋön mönö bölöŋi mi aukŋe jimakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Iŋini nöŋgöra ‘Kembu Kembu!’ qet mi mönö wuanöŋgöra qerakzemö, nöŋön yuai memegö jimakzali, mi qahö tem köla memakze. ");
INSERT INTO bmu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Denike yeŋön nöŋgöreŋ kaba keuni möta tem köla mezei, nöŋön yeŋgö könaŋamŋini kondela dopkeunöŋ jimam. ");
INSERT INTO bmu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yaŋön mitim qeqe azi kiaŋgö dop akza: Azi miaŋön ‘Miri memam,’ jiba löm köröpŋi esiba geba tandöŋi köt jamönjiŋ qakŋe kuŋgum köhöii kinök. Mewö kiniga kie uru nalöŋe o göulu köhöikŋi gila miri kembaŋe kuŋguyökmö, ölöpŋanök mem muhungöi kinök. Miaŋgöra kusumamgö qem bibihiiga köhöiba kinök. ");
INSERT INTO bmu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Qem bibihiyökmö, kunöŋ keuni möta qahö tem köla mezawi, yaŋön mönö mitimqeqe azi kiaŋgö dop akza: Yaŋön ‘Miri memam,’ jiba tandö qahö esim kömöta gölme qakŋe kut bim miyök ala meyök. Mei kiniga kie uru nalöŋe o göulu köhöikŋi gila miri kembaŋe kuŋguiga miri mi miaŋgöreŋök kusuiga goromororoŋgöba erök.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisösnöŋ ambazip kambu sutŋine mala Buŋa keuŋi pakpak mi jii mötketka eŋgömosöta Kaperneam taonöŋ kaŋgorök. ");
INSERT INTO bmu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Miaŋgöreŋ Rom suahö galöm kungö nup aziŋan kawöl yöhöi kömumamgö ahök. Galömŋan yaŋgö möri öŋgöŋgöŋi ahök. ");
INSERT INTO bmu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Miaŋgöra Jisösgö buzupŋi möta Juda yeŋgö jitŋememe tosatŋi melaim eŋgiiga Jisösgöreŋ anda kewö qesiget, “Mönö kaba welen aziŋi mem ölöwakŋan.” ");
INSERT INTO bmu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Anda Jisösgöreŋ aŋgota kapaŋ köla köuluköba jiget, “Ketaŋamnini, suahö galöm miaŋön mönö bauköm waŋgimanaŋgö dop ölöp sorokŋi akza. Miaŋgöra mönö kanöŋ.” ");
INSERT INTO bmu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mötnöŋ, yaŋön Juda ambazip kambu neŋgöra ak waŋgiiga ‘Köuluk mirinini membin,’ jiinga kian yaŋön moneŋ ali meget.” ");
INSERT INTO bmu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mewö jiget möta yembuk anök. Anökmö, suahö galömgö miriŋi dopdowii yaŋön alaurupŋi melaim eŋgiba Jisösgöra keu kewö alök, “O Kembu, ni mewörökŋi malbiga nöŋgö miri boŋan gualöŋmapkö gamuni mötzal. Miaŋgöra mönö qahö aum kömumba kaman. ");
INSERT INTO bmu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni nanaŋgö mötpi eretŋi akzawaŋgöra göhöreŋ kamamgö dop kude mötzalmö, keu jitkanök jinöŋga welen azinan ölöwakŋa. ");
INSERT INTO bmu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mi kewögöra: Ni nanak mewöyök galömnaŋgö kukösum bapŋe al niŋgiget maljal. Nöŋgö bapne yarö azi malgetka mi jim kutum eŋgimakzal. Yeŋgöreŋök kungöra ‘Anman’ jim kutubi yaŋön anma. Kungöra ‘Kanöŋ’ jim kutubi yaŋön kama aka welen azini kungöra ‘Nup ki meman,’ jibiga yaŋön mi mema.” ");
INSERT INTO bmu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisösnöŋ keu mi möta suahö galömgöra welipköba ambazip kambu wuataŋgöba kageri, yeŋgöreŋ liliŋgöba kewö jiyök, “Nöŋön kewö jibi mötme: Israel könagesö sutŋine mewöyök mötnarip ketaŋi mewöŋi mi kungö uruŋe qahö miwikŋaial.” ");
INSERT INTO bmu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mewö jiiga suahö galömgö kolekaziurupŋan liliŋgöba mire aŋgota welen azi miwikŋaiba eketka ölöwaka tarök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Miaŋgö andöŋe Jisösnöŋ taon qetŋi Nain miaŋgöreŋ aniga gwarekurupŋi aka ambazip kambulelembenöŋ wuataŋgöba anget. ");
INSERT INTO bmu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Miaŋgöreŋ taon kiripo naŋguŋi dopdowiiga qamöt kun aŋguba kaget. Malö kungö nahönŋa mohok-kunŋan kömuiga taongö ambazip kambu ketaŋan tokoba löm kölbingö kaget. ");
INSERT INTO bmu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kembunöŋ malö mi eka wösöŋi möta jii mörök, “Kude sahötman.” ");
INSERT INTO bmu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mewö jiba anda bokis aŋguba kageri, mi jii dörök algetka bokis misiriba kewö jiyök, “Azi gwabö, mönö wahötnöŋ. Nöŋön göhöra mewö jizal.” ");
INSERT INTO bmu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mewö jiiga qamöt miaŋön guliba wahöta könahiba keu jiyök. Keu jiiga Jisösnöŋ namŋambuk anmapkö waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ambazip pakpak yeŋön mi eka qem sömbuŋini möta Anutu möpöseiba jiget, “Kezapqetok azi ketaŋi kunöŋ mönö sutnine asuhuba malja.” Tosatŋan jiget, “Anutunöŋ könagesöŋi mesohol köl neŋgii maljin.” ");
INSERT INTO bmu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yaŋgö keu buzupŋi mi sehiba Judia prowins pakpak dop köla gölmeŋi gölmeŋi likeplikep miaŋgöreŋ an teköyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon O-melun azinöŋ kösö mire tariga gwarekurupŋan yuai pakpak mi asuhuyöhi, miaŋgö kösohotŋi jiget mörök. ");
INSERT INTO bmu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jiget möta gwarekŋi yahöt etkoholi kayohotka Kembugöreŋ anda kewö qesim waŋgimahotköra melaim etkiyök, “Mem ölöwak azi kamapköra mamböringa göŋön mia akzan me azi kun biaŋ kamapköra mambötpin.” ");
INSERT INTO bmu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Melaim etkiiga Jisösgöreŋ aŋgota jiyohot, “Jon O-melun azinöŋ kewö qesim gihibitköra melaim netkiiga kazit, ‘Mem ölöwak azi kamapköra mamböringa göŋön mia akzan me azi kun biaŋ kamapköra mambötpin.’” ");
INSERT INTO bmu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jisösnöŋ nalö miaŋgöreŋök ambazip gwötpuk uzi kawöl izekwaizek (ijeŋwaijeŋ) aka ömeŋinambuk mi mem ölöwak eŋgiyök aka jegömöl ambazip gwötpuk jeŋini metohoi uba eket. ");
INSERT INTO bmu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jongö gwarek yahötŋan aŋgota qesim waŋgiyohotka kewö meleŋnök, “Yuai eka mötzahori, miaŋgö kösohotŋi mönö anda Jon kewö jiyohot mötma: Jegömöl yeŋön uba eketka lokon yeŋön köna anda kagetka uzikuku yeŋön solanigetka kezapduhup yeŋön keu mötketka kömuget yeŋön guliba wahötketka etqeqeŋi yeŋgöra Ölöwak Buŋa jim asaribiga mörakze. ");
INSERT INTO bmu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mewö asuhui eketka kungö uruŋan qahö bölii andö nuŋgumawi, yaŋön mönö simbawoŋ akza.” ");
INSERT INTO bmu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mewö jiiga Jongö gwarek yetkön anohotka Jisösnöŋ könahiba Jongö könaŋi ambazip kambu yeŋgöra kewö jim asariyök, “Iŋini gölme qararaŋkölkölŋe miaŋgöreŋ wania ekingöra anget? Luhutnöŋ jehot uwutapköba metali anjaŋbanjaŋ ahakzawi, iŋini azi mewöŋi ekingöra anget me? ");
INSERT INTO bmu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Me wanat yuaia ekingöra anget? Azi malukuŋi aködamunŋambuk löŋgöta malöhi, mi ekingöra me? Mötket, ambazip malukuŋini kulemŋi ek sihimŋambuk löŋgöta anda kaba siyoŋsayoŋi qahö maljei, mieŋön mönö kiŋ yeŋgö jakömbuak miriŋine malje. Mi gölme qararaŋkölkölŋe qahö. ");
INSERT INTO bmu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Me wanat yuaia ekingöra anget? Kezapqetok azi kun ekingöra me? Ölŋa, nöŋön kewö jibi mötket: Azi ekeri, yaŋön mönö kezapqetok ambazip tosatŋi eŋgoŋgita tandökŋi kun akza. ");
INSERT INTO bmu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yaŋgö könaŋi mi mönöwök kewö ohoget ahöza, ‘Mötnöŋ, nöŋön kolekni garata kun melaibiga qeljiŋe anda ambazip uruŋini mindiŋgöba göhö könagi mesariga göŋön mönö yaŋgö andöŋe gölmenöŋ emu geman.’ ");
INSERT INTO bmu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Keu mewö ahözapmö, nöŋön kewö jibi mötket: Ambinöhök morö pakpak eŋgömegetka asuhugeri, yeŋgö sutŋine Jonöŋ mönö körek eŋgoŋgita qetbuŋaŋambuk kinja. Kinjapmö, Anutugö bemtohoŋ uruŋe aŋgota Anutugö qetbuŋaŋi miwikŋaimakzei, yeŋgö sutŋine eretŋi kondikŋi yaŋön mönö Jon oŋgitza.” ");
INSERT INTO bmu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ambazip könagesö pakpak aka yeŋgö sutŋine takis meme yeŋön mohokŋe Jongö Buŋaŋi mötkeri, yeŋön jim köleŋda “Aha! Anutugö köna diŋdiŋi jim asariza,” jiba uruŋini meleŋgetka Jonöŋ o melun mem eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mewö eŋgiyökmö, Farisi aka Köna keugö böhi yeŋön Anutugö areŋi qahö tem köla Buŋaŋi andö qeba silekmalek aketka Jonöŋ o melun qahö mem eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Ambazip merak gölmenöŋ maljei, mi mönö wanatpuk dop al eŋgibileŋak? Yeŋgö silikŋini mi denöwö? ");
INSERT INTO bmu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yeŋön namande ewö akze. Mieŋön maket sombemnöŋ tata keu gön gila laŋ qeta kewö jimakze, ‘Nini awölop uinga iŋini liŋet gwawet qahö unduget. Nini jiŋgeŋ kölinga iŋini qahö toroqeba sahötket.’ ");
INSERT INTO bmu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Miaŋgö könaŋi kewö: Jon O-melun azinöŋ kaba nene siŋgi mala wain o qahö neiga iŋini yaŋgöra jimakze, ‘Öme kunöŋ uruŋe geiga malja.’ ");
INSERT INTO bmu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","“Suep gölmegö azi ölŋan kaba nene nem söŋgaip aiga eŋön jimakze, ‘Mötket, yaŋön bau numbu tandök közöjeriba wain o gwötpuk nemba takis tilipqilipŋinambuk aka bölöŋi meme yeŋgö alaŋina malja.’ ");
INSERT INTO bmu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Körek pakpak Anutugö mötkutukutu köl gulimakzei, yeŋgö ahakmemeŋinaŋgö ölŋan mönö mötkutukutuŋinan dop köljawi, mi kondelakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi (Köna keugö kapaŋkölköl) azi yeŋgöreŋök kunŋan Jisös mi nanŋi miriŋe kaba nene nemapkö köl öröyök. Köl öröi anda miriŋe öŋgöba nene dumŋe tarök. ");
INSERT INTO bmu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Taon miaŋgöreŋ siŋgisöndok ambi kun malök. Yaŋön Jisös Farisi azigö mire öŋgöba tata nene neyöhi, miaŋgö buzupŋi möta kelök umköhöwakŋambuk mokoi köt kirin kun kokolak qeyöhi, mi memba öŋgöba kayök. Kirin mi nöluk tuat-tuat qetŋi alabastö miaŋön memeŋa. ");
INSERT INTO bmu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Öŋgöba kaba Jisösgö könaŋe geba tata könahiba sahöri imbilŋan tiŋgita geba könaŋe miriyök. Miriiga nöröp jupŋan kereŋ memba kutui öröniiga könaŋi numbuŋan yöhötim nemba kelök umköhöwakŋambuknöŋ miriyök. ");
INSERT INTO bmu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Miriyökmö, Farisi azinöŋ Jisös köl öröyöhi, yaŋön mi eka uruŋan kewö mötmöriyök, “Ambi ki siŋgisöndokŋambuha. Azi kiaŋön kezapqetok azia malbawak ewö, yaŋön mönö ambi könaŋe misirizawaŋgö könaŋi möt kutubawak.” ");
INSERT INTO bmu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisösnöŋ mi möt kutuba kewö meleŋda jiyök, “Saimon, nöŋön keu kun jimamgö mötzal.” Jiiga jiyök, “Böhi, ölöp jinöŋ mötpi.” ");
INSERT INTO bmu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jiiga Jisösnöŋ kewö jii mörök, “Ambazip yahötŋan benknöŋ anda tosa albitkö moneŋ galömŋaŋgö qesiyohot. Kunöŋ silim 500:kö töwaŋi (Kina 2500,-), kunöŋ silim 50:gö töwaŋi (Kina 250,-) miaŋgö dop tosa albitkö qesiyohot. Qesiyohotka miaŋgö dop etkiyök. ");
INSERT INTO bmu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Etkiba könaŋgep tosaŋiri misimahot jiiga moneŋiri qahöwahiga osiyohot. Osiyohotka benk galömŋan tosaŋiri qeköba kutuba mosöt etkiyök. Mosöt etkiiga yetköreŋök daŋön i uruŋan gwötpuk jöpaköm waŋgimakza?” ");
INSERT INTO bmu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mewö qesiiga Saimonöŋ kewö meleŋnök, “Nöŋgö mötmötnöŋ tosa ketaŋi kutuba mosöt waŋgiyöhi, yaŋön.” Mewö meleŋniga jiyök, “Gi keu törörök kewöta jizan.” ");
INSERT INTO bmu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mewö jiba ambigöreŋ liliŋgöba kewö jii mörök, “Ambi ki eknöŋ. Nöŋön mirige kotpiga göŋön könani saŋgoŋmamgö o kun qahö niŋgizanmö, ambi kiaŋön mönö könani imbilŋan miriba nöröp jupŋan kereŋ memba kutui öröniza. ");
INSERT INTO bmu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Göŋön numbuni qahö yöhötim nezanmö, ambi kiaŋön mönö mire kotpiga miaŋgöreŋök kapaŋ köla könani yöhötim nemba malja. ");
INSERT INTO bmu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Göŋön nöröpni kelök kude mirizanmö, ambi kiaŋön mönö kelök umköhöwakŋambuknöŋ könane nömiriza. ");
INSERT INTO bmu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Miaŋgöra nöŋön kewö jibi mötnöŋ: Anutunöŋ ambi kiaŋgö siŋgisöndokŋi gwötpuk mi mosöta saŋgoŋniga miaŋgöra uruŋan ni gwötpuk jöpaköm niŋgiza. Kunöŋ siŋgisöndok boromdökŋi ahiga Anutunöŋ siŋgisöndokŋi morörökŋi mosöriga yaŋön uruŋan borom kun miyök jöpaköm niŋgimakza.” ");
INSERT INTO bmu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mewö jiba ambi mi kewö jii mörök, “Nöŋön göhö siŋgisöndoki saŋgoŋda mosötzal.” ");
INSERT INTO bmu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mewö jiiga azi mohotŋe nene nemba tatkeri, yeŋön könahiba nanŋinök kewö jiget, “Siŋgisöndok saŋgoŋda mosötzawi, yaŋön mönö niŋi azia akŋamgö mötza?” ");
INSERT INTO bmu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mewö jigetmö, Jisösnöŋ ambigöra jiyök, “Mötnaripkan mönö amöt qem gihiza. Ölöp luainöŋ anman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Miaŋgö andöŋe Jisösnöŋ liliköba taonŋi taonŋi aka miriŋi miriŋi miaŋgöreŋ anda Anutugö bemtohoŋgö könaŋi jim asariba Ölöwak Buŋa keunöŋ ambazip uruŋini kuŋguba malök. Gwarekurupŋi 12 yeŋön yambuk mohotŋe anget. ");
INSERT INTO bmu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mewöyök ambi tosatŋan yambuk anget. Ambi mi mutuk kawöl eŋgöhöi ömenöŋ kölköljiŋjiŋ mem eŋgii malgetka Jisösnöŋ mem ölöwak eŋgiyök. Ambi mi kewö: Maria qetŋi kun Magdalagö ambia qetket. Jisösnöŋ yaŋgö uruŋeyök öme 7 közöl eŋgii kota anget. ");
INSERT INTO bmu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ambi kun qetŋi Joana. Yaŋgö apŋi qetŋi Kuza yaŋön kiŋ Herodkö jakömbuak miri miaŋgöreŋ gawmangö moneŋ galömŋa malök. Ambi kun qetŋi Susana, Yeŋön aka ambi tosatŋi gwötpuk yeŋön nanŋini moneŋ inapŋinan Jisös aka gwarekurupŋi könanöŋ galöm köla naŋgöm eŋgiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ambazipnöŋ taon dop miaŋgöreŋök öröba Jisösgöreŋ kaba kambulelembenöŋ tokogetka Jisösnöŋ dopkeu kun kewö jiyök: ");
INSERT INTO bmu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Azi kunöŋ nene kötŋi qesiŋ gilmamgö anök. Anda qesiŋniga kötŋi tosatŋan köna jitŋe geba kölget. Geba kölgetka ambazipnöŋ tim tökötahögetka könakemba (warawen) neiŋi neiŋi kaŋgota mi nem teköget. ");
INSERT INTO bmu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kötŋi tosatŋan köt jamönjiŋnöŋ geba kölget. Geba köla miaŋgöreŋ gölme oŋambuk qahö miwikŋaiba korapŋi kota soholiba gororoŋgöget. ");
INSERT INTO bmu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Kötŋi tosatŋan siri uret wahiŋinambuknöŋ geba kölget. Geba kölgetka mieŋön öröröŋ kota eŋgoŋgita qem turuba böbölohot mem eŋgiget. ");
INSERT INTO bmu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kötŋi tosatŋan gölme ölöpŋe geba kölget. Geba köla jula wahöta ölŋini ölöpŋi asuhuba handötkö dop ahum sehiget.” Keu mi jim teköba qet ketaŋi kewö qerök, “Kunŋan urukezapŋambuk malja ewö, yaŋön mönö dopkeu ki kezap ala möt kutuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mewö jiiga gwarekurupŋan dopkeu kiaŋgö könaŋaŋgöra Jisös qesim waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Qesim waŋgigetka jiyök, “Anutugö bemtohoŋe aŋgota malbingö keu tölapŋi mi eŋgöra aukŋe jibi möt kutuzemö, tosatŋi yeŋgöra mia dop keunöŋ jibi mörakze. Mewö möta nanŋini jeŋinan yuai ekagun könaŋi töndup qahö ek kutume. Nanŋini kezapŋinan keu törörök mötagun könaŋi töndup qahö möt asarime.” ");
INSERT INTO bmu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Dopkeu miaŋgö könaŋi kewö: Köt qesiŋ giljawi, mi Anutugöreŋ Buŋa keu. ");
INSERT INTO bmu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nene kötŋi köna jitŋe geba kölgeri, mi kewö: Ambazip tosatŋan Buŋa keu mötzemö, mi mötketka Bölöŋi Toŋan kaba uruŋini meleŋda Suepkö buŋa akepuköra keu kötŋi mi uruŋineyök qeköba eŋguaŋgirakza. ");
INSERT INTO bmu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nene kötŋi qesiŋniga köt jamönjiŋnöŋ geba kölgeri, mi ambazip söpsöpŋi kun. Yeŋön Buŋa keu möta mi sösöŋgai qakŋe möt aŋgön kölakzemö, uruŋine geba jalöŋini qahö megeraŋgöra nalö töröptökŋi miyök möt nariba malgetka esapesapkö nalöŋe mönö tala eŋguma. ");
INSERT INTO bmu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Nene kötŋi qesiŋniga siriuret wahiŋinambuknöŋ geba kölgeri, mi kewö: Yeŋön Buŋa keu mötketka uruŋine gezapmö, gölmenöŋ malmalgö waimanjatŋi aka moneŋ inap memegö urukönöpŋi ahuba lömbörim eŋgimakza. Qetbuŋaŋinambuk akingöra köpösöŋgögetka sihim kömbönaŋi bölöŋi tosatŋan mewöyök uruŋine dumgöba Buŋa keu böbölohot mem waŋgize. Mewö aiga ölŋini qahö gilipitŋi akŋe. ");
INSERT INTO bmu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Qahöpmö, nene kötŋi gölme ölöpŋe geba kölgeri, mi ambazip kewöŋi: Yeŋön Buŋa keu kezap ala mötketka uruŋini ölöpŋi geŋmoŋi qahö miaŋgöreŋ geiga sohobapukö mökösöŋda 8kapaŋ köla galöm kölgetka ölŋini ölöpŋi ölöpŋi miwikŋaimakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kunŋan lambe me kiwa ohotiriba kimbutnöŋ kude köl turuma me dum bapŋe qahö alma. Mi qahöpmö, mi miaŋgö dum qakŋe ali tatma. Tata asariiga tosatŋan miri uruŋe öŋgöbingö mötzei, yeŋön miaŋgö asakŋi eka ölöp öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Mewöŋanök urunine yuai kun asambötket tölapŋe ahözawi, mi mönö aukŋe asuhum tiŋgitma. Yuai kun köl turuin ahözawi, mi mönö luluŋgetka kötula ahöma. ");
INSERT INTO bmu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Miaŋgöra Anutugö keu mötzei, mi mönö urukönömŋine ala mötmöriba köl guliba malme. Kunŋan mötkutukutuŋambuk maljawi, Anutunöŋ mönö mi toroqem waŋgii qarimapmö, kunŋan mötkutukutuŋi qahö maljapmö, ‘Miambuk maljal,’ jizawi, Anutunöŋ mönö mötmötŋi moröŋi mi mewöyök qeköba waŋgitma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisösnöŋ mewö jiba maliga nam munŋan i ekingö kagetmö, ambazip kambu ketaŋan ölököba gwözöŋgeraŋgöra kösutŋe anbingö osiget. ");
INSERT INTO bmu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Osiba kingetka kunŋan kewö jii mörök, “Göhö nam-mungan mönö yaigep kinda gi gekingö mötze.” ");
INSERT INTO bmu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jii mörökmö, Jisösnöŋ kewö meleŋda jii mötket, “Ambazip ki Anutugö Buŋa keu möta tem köla köl gulimakzei, mieŋön mönö nöŋgö namni aka munurupni akze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wehön kunöŋ Jisösnöŋ gwarekurupŋi kewö jii mötket, “Mönö mosöta o aŋgö kutuba likepŋe aŋgotpin.” Mewö jiiga waŋgenöŋ mohotŋe öŋgöba o aŋgö qakŋe anget. ");
INSERT INTO bmu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Anda opo seri möröreŋgögetka luhutnöŋ naŋgöiga angetka Jisösnöŋ gaun ahöyök. Ahöiga luhut raidimbom o aŋgönöŋ gila siri kunduriga waŋge uruŋe geyök. Geba numbuŋe qemamgö aiga ayuhubingö aket. ");
INSERT INTO bmu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ayuhubingö aka gwarekurupnan anda möndöba jiget, “Kembu Ketaŋamnini, mönö nini aŋgönöŋ ayuhubingö akzin.” Mewö jigetka imbiŋi möta luhut aka o aŋgögö siriŋi kewö jim qetal etkiiga ösumŋiran eriga nöŋ qeba ahöyök. ");
INSERT INTO bmu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mewö aiga jii mötket, “Eŋgö mötnaripŋini mi denike?” Mewö jiyökmö, yeŋön awöwöliba qem sömbuŋini möta jiget, “Yei, azi kia mönö denöwöŋan malja? Yaŋön mönö luhut aka köwet siri jim kutum etkiiga jitŋi tem köl waŋgizahot.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jisösnöŋ gwarekurupŋi yembuk toroqeba opo seri möröreŋgögetka luhutnöŋ naŋgöi anda o aŋgö kutuba Galili prowins likepŋe Gerasa gölmenöŋ aŋgotket. ");
INSERT INTO bmu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Miaŋgöreŋ aŋgota saknöŋ öŋgöi azi ömeŋambuk kun mi taonöhök kaba Jisös miwikŋaiyök. Azi mi qaksirinöŋ mala qamöt köteŋi esiba urorohoget ahögeraŋgöreŋ ahöm malök. Nalö köröpŋi opo maluku qahö löŋgöta miri kungö uruŋe qahö ahömalök. ");
INSERT INTO bmu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ömenöŋ nalö köröpŋi öröm ureim waŋgiiga azi gwötpukŋan börö takŋi qeba könaŋi tapepnöŋ (muŋgamuŋga) jöhöba galöm köla malgetmö, tapepŋi öröi tiŋgitqiŋgiriga ömenöŋ kuŋguiga gölme qararaŋkölkölŋe anda laŋ malök. Miaŋgöra Jisösnöŋ ömeŋi mi kewö jim kutum waŋgimamgöra ahök, “Öme bölöŋi, gi mönö kota azi ki mosöta anöŋ.” Mewö jimamgö aiga Jisös eka silata gölmenöŋ kösutŋe geba qet gigilahöba kewö qerök, “Aek Jisös, gi Anutu öŋgöŋgöŋaŋgö nahönŋi akzan. Gi mönö denöwö ak niŋgimamgöra ki kazan. Nöŋön ulet gihizal: Gi sihimbölö könöpŋambuk kude ak niŋginöŋ.” ");
INSERT INTO bmu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mewö jiiga kewö qesiyök, “Gi qetki niŋi?” Ömewöröme gwötpuk uruŋe geba malgeraŋgöra “Qetnini lijön jizin” jiget. Mi nanine keunöŋ Kerök kambu ketaŋi. ");
INSERT INTO bmu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mewö jiba Jisös kewö ulet waŋgiget, “Gi neŋguataŋgöba öme löm dutŋi qahö miaŋgöreŋ gebingöra kude jim kutum neŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kösutŋine kunduŋi marömŋe miaŋgöreŋ bau kambu ketaŋi kun gwözözak uruŋe kuluŋda malget. Miaŋgöra ömenöŋ kewö jiba ulet waŋgiget, “Gi ölöp jinöŋga nini bau mieŋgö uruŋine gebin.” Ulet waŋgigetka “Mönö anda geget.” Jiba jim kutum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jim kutum eŋgiiga azi uruŋeyök kota anda bau uruŋine geget. Gegetka bau kambu yeŋön mönö luhuba nembönembönöŋ anda jororoŋgöba o aŋgönöŋ geba nemulahöba kömuget. ");
INSERT INTO bmu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mi asuhuiga bau galöm yeŋön mi eka taon aka miri morömorö miaŋgöreŋ ölöŋ unjurata anda keu buzupŋi mi jiget mötket. ");
INSERT INTO bmu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jiget möta ambazip sesegilgil yeŋön yuai asuhuyöhi, mi ekingöra kaget. Kaba Jisösgöreŋ kaŋgota azi uruŋeyök ömenöŋ kotkeri, yaŋön könaŋe tariga miwikŋaiget. Opo sileötaŋi törörök jöhöba uruŋi amöriiga imbi mötmötŋi pakpak asuhuiga eka awöwöliget. ");
INSERT INTO bmu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Azi ömeŋambuk malöhaŋön denöwö ölöwahöhi, mi jeŋinan ekeraŋön jiget mötket. ");
INSERT INTO bmu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Möta gwötpuk awöwöliba qem sömbuŋini mötket. Miaŋgöra Gerasa gölmegö ambazip kambu pakpak yeŋön Jisösnöŋ eŋgömosötmapköra ulet waŋgiget. Ulet waŋgigetka liliŋgöba anmamgö waŋgenöŋ öŋgömamgö ahök. ");
INSERT INTO bmu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Öŋgömamgö aiga azi uruŋeyök ömenöŋ kotkeri, yaŋön kaba Jisösbuk mohotŋe anda malmamgöra qesiyök. Mewö qesiyökmö, Jisösnöŋ qetala melaim waŋgiba kewö jiyök, ");
INSERT INTO bmu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gi mönö liliŋgöba mirige anda Anutunöŋ aŋgöletot ketaŋi ketaŋi ak gihiyöhi, miaŋgö kösohotŋi jinöŋga mötme.” Mewö jiiga anda Jisösnöŋ aŋgöletot ketaŋi ketaŋi ak waŋgiyöhi, miaŋgö keuŋi mi taon uruŋe liliköba miri dop jim sehiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ambazip pakpak Jisösgö mambötketka liliŋgöba kaiga kambu köla söŋgaiba öröm waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Köuluk mirigö keu galöm kun qetŋi Jairus yaŋön kaba Jisösgö wösöŋe geba simin köla miriŋe kamapköra köuluköm waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Moröurupŋi qahöpmö, böratŋi mukmorö mohok yambuŋi (yara) 12:gö dop mala kömumamgö ahök. Jisös köl öröm waŋgigetka aniga ambazip kambunöŋ likeplikep ölököba utal waŋgiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Utal waŋgiba angetka miaŋgöreŋ sutŋine ambi kun malök. Yaŋön yambu (yara) 12 miaŋgö dop köiŋnöŋ ehiga nalö dop kawöl yöhöiga malök. Yaŋön sile galöm yeŋgö töwaŋini moneŋ inapŋi pakpak gil maliga sile galöm körekŋan mem ölöwakingö osiget. ");
INSERT INTO bmu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ambi miaŋön Jisösgö andöŋe anda malukuŋaŋgö kitip suŋi misiriiga miaŋgöreŋök sepŋi jöpköyök. ");
INSERT INTO bmu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisösnöŋ qesiba jiyök, “Daŋön nömisiriza?” Mewö jiyökmö, ambazip körekŋan mi qaŋ kölgetka Pitönöŋ jiyök, “Ketaŋamni, ambazip kambunöŋ ölököba utal aŋguba kaba goseize.” ");
INSERT INTO bmu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jiiga Jisösnöŋ jiyök, “Qahö, kunŋan nömisiriiga ösumni kun ani mötzal.” ");
INSERT INTO bmu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mewö jiiga ambinöŋ “Könaŋamni lök asuhuza,” jiba jönömŋi unduiga kaba Jisösgö wösöŋe simin köla kawölŋaŋgö könaŋi aka misiriba miaŋgöreŋök ölöwahöhi, miaŋgö könaŋi aukŋe jiiga ambazip kambu körekŋan mötket. ");
INSERT INTO bmu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mötketka Jisösnöŋ kewö jii mörök, “Böratni, mötnaripkan mönö mem ölöwak gihiza. Ölöp urubönjöŋnöŋ anman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Keu mewö jiba kiniga köuluk mirigö keu galömŋaŋgö mireyök kunŋan welen kaba Jairusgöra jiyök, “Böratkan kömuza! Miaŋgöra böhigö qakŋe lömböt toroqeba kude alman.” ");
INSERT INTO bmu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jiyökmö, Jisösnöŋ keu mi möta köuluk mirigö keu galömŋi kewö jii mörök, “Keŋgötki kude mötman! Mohok-kun akŋan. Mönö ni möt narim niŋginöŋga böratkan ölöwakŋa.” ");
INSERT INTO bmu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mewö jiba yaŋgö mire anda ambazip tosatŋi eŋgömosöta Pitö, Jon, Jeims aka morö böratkö iwinamŋi iyök eŋguaŋgiri nanŋinök miri uruŋe öŋgöget. ");
INSERT INTO bmu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Öŋgögetka ambazip körekŋan jiŋgeŋ köla sahöta amburereŋ megetmö, Jisösnöŋ jiyök, “Yaŋön qahö kömuzapmö, gaunök ahöza. Miaŋgöra mönö sahöt mosötme.” ");
INSERT INTO bmu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mewö jiiga gönahit ewö aiga “Mönö kömuza!” möta gön köl waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gön köl waŋgigetmö, börat mi böröŋe memba qeta jiyök, “Böratni, mönö wahötnöŋ.” ");
INSERT INTO bmu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mewö jiiga uŋaŋan liliŋgöiga miaŋgöreŋök wahöta kinök. Kiniga numbu nene waŋgiget nemapkö jiyök. ");
INSERT INTO bmu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iwinamŋan mi eka welipköyohotmö, Jisösnöŋ yuai asuhuyöhi, miaŋgö buzupŋi kun jiget mötpepukö soŋgo al eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisösnöŋ gwarekurupŋi 12 mi eŋgoholi tokogetka ömewöröme pakpak közöl eŋgimegöra aka uzi kawöl mem ölöwakŋegöra kukösumŋi ösum-mumuŋambuk al eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kukösum eŋgiba kewö jiba melaim eŋgiyök, “Iŋini mönö anda Anutugö bemtohoŋaŋgö könaŋi ambazip jim asarim eŋgiba kawöl ambazip mem ölöwak eŋgiba malme.” ");
INSERT INTO bmu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Melaim eŋgiba jii mötket, “Iŋini köna anmeaŋgöra yuaiŋi kun qahö memba anme, öröp qahö, gösö qahö, köna nalem qahö, soujeŋi qahö. Maluku semönŋi qahöpmö, mohok meme. ");
INSERT INTO bmu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Anda mire denike denike aŋgotmei, mönö miaŋgöreŋök mala nup memba taon mi mosöta köna anme ");
INSERT INTO bmu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Anda mala miri kunöŋ aŋgotketka qahö köl öröm eŋgiba keuŋini qahö mötketka nesampurekŋini mönö kewö jiba kondel eŋgime, ‘Nini eŋgö gölmenöŋ kainga sölbuham köna tambönine mekötahözawi, mi mönö tim tönjöraringa nanŋine liliŋgöba gema.’ Mewö jigetka könaŋamŋini solanŋi möt kutugetka ölöp taon mi mosöta toroqeba anme.” ");
INSERT INTO bmu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mewö jiiga mosöta anda miriŋi miriŋi liliköba miri dop Ölöwak Buŋa jim asariba kawöl ambazip mem ölöwak eŋgiba malget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yuai pakpak asuhuyöhi, miaŋgö qetbuŋaŋan sehiba gölme bahöŋaŋgö (Galili prowinsgö) kiŋ Herodkö kezapŋe geiga mörök. Ambazip tosatŋan kewö jiget, “Jon O-melun azinöŋ mönö kömupnöhök wahöta malja.” Miaŋgöra kiŋnöŋ keugö jaruba lalalulu siksauk ahök. ");
INSERT INTO bmu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ahökmö, tosatŋan jiget, “Elaijanöŋ kunbuk asuhuba malja.” Tosatŋan toroqeba jiget, “Kezapqetok azi walŋi yeŋgöreŋök kunöŋ mönö guliba wahöta malja.” ");
INSERT INTO bmu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mewö jigetmö, kiŋ Herodnöŋ kewö jiyök, “Jon O-melun azi mi nöŋön jibi jölŋi kutugetmö, kungö keuŋi mewö jiget mötzali, mi mönö daŋön?” Mewö jiba Jisös ekŋamgö kapaŋ köla jörömqöröm ahök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Melaimelai azi aposol yeŋön Jisösgöreŋ liliŋgöba yuai aka megeri, miaŋgö kösohotŋi pakpak jiget mörök. Jiget möta eŋguaŋgita ambazip qenjarökŋini mosöta taon qetŋi Betsaida miaŋgö kösutŋe nanŋinök kötikŋe malbingö anget. ");
INSERT INTO bmu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Angetmö, ambazip kambu yeŋön mi möta Jisös andöŋe wuataŋgöba anget. Anda Jisösgöreŋ kagetka köl öröm eŋgiba Anutu bemtohoŋaŋgö könaŋi jim asariba kawöl ambazip mem ölöwak eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mewö aka mali wehön jeŋan teköba gemamgö ahök. Mewö aiga gwarek 12 yeŋön kaba Jisös kewö jiget mörök, “Nini gölme kötikŋi kiaŋgöreŋ maljinaŋgöra gi ölöp ambazip kambu ki melaim eŋginöŋga miri koum dowe dowe tat anjei, miaŋgöreŋ anda ahöahö miri aka nene miwikŋaime.” ");
INSERT INTO bmu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mewö jigetmö, kewö jii mötket, “Eŋön mönö nanŋinak i nene gumohom eŋgime.” Mewö jiiga meleŋget, “Nini beret sahötŋi 5 aka söra yahöt miyök memba maljin. Miaŋgöra denöwö akinto? Nini ölöp anda ambazip kambu ki pakpak yeŋgöra nene söŋgöröŋi membinak me? ");
INSERT INTO bmu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Yeŋön azi 5000:gö dop malje.)” Mewö meleŋgetka gwarekurupŋan kewö jii mötket, “Eŋön mönö ambazip eŋgöra jiba mendeŋ eŋgigetka kambu dop 50:gö dop nene nembingö tokoba eta tatme.” ");
INSERT INTO bmu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jiiga mewö aka mendeŋ eŋgigetka ambazip körekŋan eta kambuŋi kambuŋi tat anget. ");
INSERT INTO bmu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tat angetka beret 5 aka söra yahöt mi memba suepnöŋ ui öŋgöiga kötuetköyök. Kötuetköba beret mindipköba gwarekurupŋi eŋgiiga ambazip kirip dop mendeŋda sutŋine alget. ");
INSERT INTO bmu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sutŋine algetka körekmakörek nemba nem timbireŋ aket. Nene kitipŋi kitipŋi mosötkeri, mi gwarek yeŋön qezakögetka sakap 12 miaŋgöreŋ geba kokolak qeyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nalö kunöŋ Jisösnöŋ nanŋök gölme kungen köuluköiga gwarekurupŋan yambuk malgetka qesim eŋgiba kewö jiyök, “Ambazipnöŋ nöŋgöra denöwö jimakze? Ni niŋia akzal?” ");
INSERT INTO bmu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jiiga meleŋda kewö jiget, “Tosatŋan ‘Gi Jon O-melun azia akzan,’ jimakzemö, tosatŋan ‘Gi Elaija akzan,’ jimakze aka tosatŋan toroqeba kewö jimakze, ‘Gi kezapqetok azi walŋi yeŋgöreŋök kunŋan kömupnöhök wahöta maljan.’” ");
INSERT INTO bmu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mewö jigetka kewö qesim eŋgiyök, “Aka nanŋinak nöŋgöra denöwö jize? Ni niŋia akzal?” Qesim eŋgiiga Pitönöŋ meleŋda jii mörök, “Gi Anutugöreŋ Amötqeqe Toŋi Kraist akzan.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mewö jiiga könaŋi aukŋe jiget kunŋan mötpepuköra soŋgo köhöikŋi al eŋgiyök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jisösnöŋ jiyök, “Suep gölmegö azi ölŋan mönö sihimbölö gwötpuk mötma. Kantrigö jitŋememe, jike nup galöm aka Köna keugö böhi yeŋön mönö andö qeba qegetka kömuma. Kömumba wehön karöbut aiga kömupnöhök wahötma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jisösnöŋ ambazip pakpak yeŋgöra keu kewö jii mötket, “Kunŋan nöŋgö andöne nuataŋgöba kamamgö mötzawi, yaŋön mönö nanŋi urusileŋaŋgö sihim kömbönaŋi bölöŋi andö qeiga sisitŋi megetka sihimbölö mi bisimakŋa. Mi maripomnöŋ kömumawaŋgö dop mökösöŋda ni nuataŋgöba kama. ");
INSERT INTO bmu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Kunŋan malmalŋi nanŋaŋgöra aŋgön köla nanŋi imbi-imbi maljawi, yaŋön mönö malmalŋi ölŋi jöhöi sohoma. Sohomapmö, kunŋan gölmegö malmalŋi nöŋgöra aka köleŋda tököm niŋgimawi, yaŋön mönö malmal ölŋaŋgö könaŋi miwikŋaiba köhöiba malma. ");
INSERT INTO bmu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Kunŋan gölmeŋi gölmeŋi mieŋgö öröyuaiŋi pakpak köl öröiga buŋaŋi an teköiga uruŋaŋgö malmalŋi mem sohoba silebile mala kömuiga Anutunöŋ keuŋi jim teköiga könöp sianöŋ geba uŋaŋan ayuhuiga qahö dop kölma. Sukinapŋi miaŋön mönö urusösöŋgai qahö ak waŋgima. Qahöpmahöp! ");
INSERT INTO bmu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Kunŋan nöŋgö qetni aka Buŋa keuni memba eta aljawi, i Suep gölmegö azi ölŋan mewöyök ehöröŋ kölma. Yaŋön könaŋgep Suep garata töröŋi yembuk ki etketka yeŋgö, nanŋaŋgö aka Iwiŋaŋgö asakmararaŋini eka aurume. Nalö miaŋgöreŋ azi me ambi mewöŋi mönö ehöröŋ köl waŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nöŋön keu ölŋi kun kewö jibi mötme: Kiaŋgöreŋ kinjei, eŋgö sutŋineyök tosatŋan Anutugö bemtohoŋan asuhumawi, mi ek kutume. Jebuk mala kömupkö sihimbölöŋi qahö mötketka asuhum tiŋgiriga mi ekŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Keu mi jiiga wehön 8:kö dop teköiga Jisösnöŋ Pitö, Jon aka Jeims eŋguaŋgita kunduŋe öŋgöba Anutu köuluköyök. ");
INSERT INTO bmu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Köuluköiga miaŋgöreŋ jemesoholŋaŋgö kaisoŋgolomŋan letota tandökŋi murutŋi ahök. Malukuŋan tuat lalamŋi aka kölköl-bilikbilikŋambuk asariyök. ");
INSERT INTO bmu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Miaŋgöreŋök eketka azi yahötŋan asuhuba Jisösbuk keu keu jiget. Mi Moses aka Elaija. ");
INSERT INTO bmu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Asakmararaŋ uruŋe asuhuba Jisösbuk keu kewö eraum mötket, “Anutunöŋ Jisös sihimbölö möta kömumapkö melaiiga eta zilaŋ Jerusalem sitinöŋ aniga areŋ miaŋön ölŋambuk ak teköma.” ");
INSERT INTO bmu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mewö eraum mötketmö, Pitönöŋ alayahötŋi yetpuk jeŋinan lömböriiga gaun ahöget. Ahögetmö, gaunöhök imbiŋini möta jeŋini uba Jisösgö asakmararaŋi aka azi yahöt yambuk kinohori, mi eŋgeket. ");
INSERT INTO bmu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Eŋgeketka kinda Jisös mosötpitkö ahotka Pitönöŋ Jisösgöra jiyök, “Ketaŋamnini, neŋön kiaŋgöreŋ uru ölöwak mötzin. Miaŋgöra neŋön ölöp koum karöbut qebin: Göhö kun, Mosesgö kun aka Elaijagö kun.” Pitönöŋ mewö jiyökmö, nanŋi keuŋaŋgö könaŋi mi qahö möt kutuyök. ");
INSERT INTO bmu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mewö jiba kiniga unuŋunuŋ kunöŋ eta aumŋan esuhum eŋgiiga kousu uruŋe mala awöwöliba jönömŋini unduyök. ");
INSERT INTO bmu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jönömŋini undui kingetka kousu uruŋeyök qet kun kewö eriga mötket, “Azi ki mi nani nahöna. I ambazip amöt qem eŋgimamgöra möwölöhöm waŋgial. Mönö yaŋgö keuŋi möta malme.” ");
INSERT INTO bmu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Qet miaŋön eri möta gwarek yeŋön miaŋgöreŋök uba Jisösnöŋ nanŋök kini eket. Kunduŋe yuai ekeri, miaŋgö buzupŋi mi nalö miaŋgöreŋ kude jiba keu bök malgetka kunŋan kun qahö mörök. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ahöba wahötketka Jisösnöŋ gwarekurupŋi karöbut yembuk kunduŋeyök eta sörökŋe ambazip kambulelembe eŋgeget. ");
INSERT INTO bmu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eŋgegetka ambazip kambunöhök azi kunŋan qeta kewö jiyök, “Böhi, nöŋgö nahöni mukmoröya akzawaŋgöra mönö kaba i ekŋan. Miaŋgöra köuluköm gihizal. ");
INSERT INTO bmu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mötnöŋ, öme kunöŋ i memba mendawöli miaŋgöreŋök qet gigilahöi utuköm waŋgii wölöhariiga numbuŋeyök qölqölsöutsöut erakza. Öme miaŋön öröm ureim waŋgiba nalö gwötpuk qahö mosörakza. ");
INSERT INTO bmu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mewö aiga göhö gwarekurupki öme mi wuataŋgömegö ulet eŋgizalmö, yeŋön mi osize.” ");
INSERT INTO bmu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mewö jiiga Jisösnöŋ meleŋ waŋgiba jiyök, “Yei, gölmegö yaŋgiseŋ aka misimkaulup ambazip, nöŋön mönö nalö dawik embuk mala qatön eŋgubiga Anutu qahö möt narigetka sihimbölö mötmam? Nahöngi mönö waŋgita ki kanöŋ.” ");
INSERT INTO bmu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Morö mi waŋgita kaiga nalö miaŋgöreŋ mewöyök ömenöŋ morö utuköba urepköm waŋgiiga wölöhariyök. Mewö ahökmö, Jisösnöŋ öme mi jim waŋgii mosöri morö mem ölöwaka iwiŋi waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Anutugö kukösumŋi ketaŋan mewö asuhuiga körekŋan mi eka nemböŋini teköi welipköget. Mewö. Jisösnöŋ yuai pakpak mi meyöhi, miaŋgöra ambazip körekŋan welipkögetka Jisösnöŋ nalö miaŋgöreŋ gwarekurupŋi keu kötŋi kewö jii mötket, ");
INSERT INTO bmu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Keu ki mönö kezap ala mötme: Anutunöŋ Suep gölmegö azi ölŋi mi gölme ambazip yeŋgö böröŋine al waŋgii gema.” ");
INSERT INTO bmu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Keu kötŋi mi jii mötketmö, mi qahö möt kutuget. Anutunöŋ mi köl turui tölapŋe ahöiga mi qahö möt asariget aka könaŋi denöwö, mi qesibingö kölköldömdöm aket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gwarek neŋgöreŋök ‘Daŋön öŋgöŋgöŋi akza?’ jiba keu mi mötmöriget. ");
INSERT INTO bmu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mi mötmörigetmö, Jisösnöŋ urumötmötŋini möt kutuba namande moröŋi kun memba qöhöröŋe ali kinök. ");
INSERT INTO bmu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kiniga kewö jii mötket, “Körek eŋgöreŋök kunŋan eretŋi kondökŋi akzawi, yaŋön mönö öŋgöŋgöŋi akza. Miaŋgöra kunŋan namande ki nöŋgö qetne miriŋe köl öröba köyan kölmawi, yaŋön mönö ni köl öröm niŋgima. Kunŋan ni köl öröm niŋgimawi, yaŋön melaim niŋgiyöhi, mönö i mewöyök köl öröm waŋgima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nalö miaŋgöreŋ Jonöŋ könahiba keu kewö jiyök, “Ketaŋamni, azi kunŋan göhö qetnöŋ öme közöl eŋgiiga ehin. Yaŋön nembuk qahö liliköba maljawaŋgöra nini i qetal waŋgiin.” ");
INSERT INTO bmu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mewö jiyökmö, Jisösnöŋ kewö jii mörök, “I kude qetal waŋgime. Kunŋan qahö qetal eŋgimakzawi, yaŋön mönö eŋgö areŋnöŋ malja. (Miaŋgöra iŋini mönö nöŋgö alaurupni tosatŋi mi qetala aŋgösirip mem eŋgibepuk.)” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisösnöŋ Suepnöŋ öŋgömamgö ahök. Miaŋgö nalöŋi törizawaŋgöra Jisösnöŋ kinda “Jerusalem sitinöŋ anmam,” jiba jim köhöiba könahiba könanöŋ anök. ");
INSERT INTO bmu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Anda kolek qeljiŋe aliga mutuk anget. Könanöŋ anda mala Samaria prowinsgö miri kunöŋ aŋgota “Jisösgöra mözöqözözöm akingöra kazin,” jiget. ");
INSERT INTO bmu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jiba angetka anökmö, “Ni Judia prowinsnöŋ Jerusalem jike göröken anmam” jiiga miaŋgöra miri aŋgön köla yaizökzök qahö jiget. ");
INSERT INTO bmu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mewö aketka gwarekyahötŋi Jeims aka Jon yekŋön mi eka jiyohot, “O Kembu, Suepnöhök könöp eta eŋgohoi qahöwakeak, mewö köuluköbingö mötzan me qahö?” ");
INSERT INTO bmu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mewö jiyohotmö, Jisösnöŋ liliŋgöba tembula jim etkiyök. ");
INSERT INTO bmu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Miaŋgöreŋök toroqeba miri kunöŋ anget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Könanöŋ angetka azi kunŋan kaba Jisösgöra jiyök, “Gi denike denike anmani, nöŋön mönö miaŋgöreŋ gi guataŋgöba kamam.” ");
INSERT INTO bmu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mi möta Jisösnöŋ kewö jii mörök, “Arökŋaŋgö kiam yeŋön köteŋine ahögetka könakemba nei yeŋön aipŋini memba malakzemö, Suep gölmegö azi ölŋan mönö denike anda nöröpŋi wani qömböŋnöŋ nariba luhut membawak.” ");
INSERT INTO bmu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisösnöŋ azi kungöra jiyök, “Gi kaba ni nuataŋgöman.” Jiyökmö, kewö meleŋnök, “Kembu, mi ölöpmö, iwinan kömumamgö aiga mutuk jinöŋga anda galöm kölbi kömui löm kölbigun.” ");
INSERT INTO bmu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mewö jiyökmö, Jisösnöŋ meleŋda jiyök, “Mosötnöŋ! Köhömuŋi yeŋön qamötŋini köhömuŋi mi ölöp löm kölmemö, göŋön mönö anda Anutu bemtohoŋaŋgö könaŋi jim asarim eŋgiba malman.” ");
INSERT INTO bmu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kunbuk azi kunŋan kaŋgota jiyök, “Kembu, nöŋön gi guataŋgömamgö sihimni mötzalmö, mötnöŋ, gi ölöp jinöŋga mutuk mire anda tinitosolomurupni yaizökzökŋini jibigun.” ");
INSERT INTO bmu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jiyökmö, Jisösnöŋ meleŋnök, “Kunöŋ gölme mesiŋmesiŋgö kinoŋ mi hos andöŋe jöhöba böröŋan kinoŋ supŋe memba kini aniga dumŋe liliŋgöba andöŋe uzawi, yaŋön mönö Anutugö bemtohoŋnöŋ aŋgota nupŋi memawaŋgö dop qahö akza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Miaŋgö andöŋe Kembunöŋ gwarek tosatŋi 72 mi möwölöhöm eŋgiyök. Nanŋak “Taonŋi taonŋi miriŋi miriŋi anmam,” jiba miaŋgöreŋ yahöt yahöt meköba mutuk melaim eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Melaim eŋgimam,” jiba kewö jii mötket, “Anutugö nupnöŋ nene ölŋi gwötpuk öliba ahözapmö, mi tokobingöra nup meme ambazip nini awamdökŋi maljin. Miaŋgöra mönö nene öliöliŋaŋgö Kembuŋi köuluköm waŋgigetka nup meme ambazip melaim eŋgiiga ölŋi mem tokome. ");
INSERT INTO bmu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Iŋini mönö anme. Mötket, lama yeŋön arökŋaŋgö kiam kalŋi yeŋgö sutŋine gegetka luhuba eŋgöhöbepuk, nöŋön iŋini miaŋgö tandök ewö melaim eŋgibi anme. ");
INSERT INTO bmu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Iŋini moneŋ irimuŋga me gösö kun me köna esu mi kude memba anme. Anda könanöŋ ambazip eŋgeka jiji-kilik-kilik yaizökzök kude akŋe. ");
INSERT INTO bmu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Anda miri kunöŋ öŋgöba mutuk kewö jime, ‘Anutunöŋ miri kiaŋgöreŋ luai ali bönjöŋ malme.’ ");
INSERT INTO bmu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mewö jigetka kunŋan luai aŋgön kölmamgö dop akzawi ewö, luaiŋinan mönö yaŋgö qakŋe öŋgömapmö, kunŋan mi qahö aŋgön kölma ewö, luaiŋinan mönö liliŋgöba nanŋini qakŋine öŋgöma. ");
INSERT INTO bmu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Miri öŋgömei, mönö miaŋgöreŋök mala nup meme. Ambazipnöŋ nup meme ambazip malmalŋini naŋgömeaŋgö dop akze. Miaŋgöra yeŋön nene aka o eŋgimei, mi mönö neme. Miri tosatŋe laŋlaŋ kude ahöme. Miri suen kude anda kame. ");
INSERT INTO bmu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Taon miaŋgöreŋ me miaŋgöreŋ aŋgotketka köl öröba nene eŋgimei, mia mönö neme. ");
INSERT INTO bmu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nemba tosatŋan miaŋgöreŋ kawöl eŋgöhöi ahömei, i mönö mem ölöwak eŋgime. Mewö aka kewö jiget mötme, ‘Anutugö bemtohoŋan mönö dowe kaiga miaŋgö uruŋe aŋgotme.’ ");
INSERT INTO bmu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mewö akŋemö, taon kunöŋ aŋgotketka andö eŋgumei, miaŋgöreŋ mönö maketnöŋ me sombemnöŋ anda kewö jiget mötme, ");
INSERT INTO bmu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nini eŋgö taonöŋ kainga sölbuham yuai köna tambönine mekötahözawi, mi mönö tim tönjöraringa nanŋine liliŋgöba gema. Gemapmö, keu ki mönö möt yaköme: Anutugö bemtohoŋan mönö kösutŋine asuhuza.’ ");
INSERT INTO bmu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nöŋön kewö jibi mötket: Anutunöŋ nalö ketaŋe qemasolokepŋinaŋgö likepŋi meleŋni taon miaŋgö qakŋe öŋgömawi, dop miaŋön mönö Sodom yeŋgö sihimbölö dopŋi oŋgita toroqem eŋgima.” ");
INSERT INTO bmu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“O Korazin toŋi, nöŋön eŋgöra ‘Yei!’ jiba sahötzal aka Betsaida toŋi, eŋgöra mewöyök ‘Yei!’ jiba sahötzal. Nöŋön yeŋgöreŋ anbiga keuni jibi sösönihii aŋgöletotni kukösumŋinambuk asuhugetmö, uruŋini töndup qahö meleŋget. Aŋgöletot mi kian gölmenöŋ Taiö aka Saidon sitinöŋ asuhubeak ewö, yeŋön mönö nalö köröpŋi uruŋini meleŋbingö kaisösöpŋi kondela dodohonöŋ aŋgömiriba kau ariba sahötpeak. ");
INSERT INTO bmu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Sahötpeakmö, Anutunöŋ könaŋgep Korazin aka Betsaida yeŋgö keuŋini jim teköba likepŋi meleŋni sihimbölö mötmei, nalö ketaŋi miaŋgöreŋ mi mönö Taiö aka Saidon yeŋgö sihimbölö dopŋi oŋgita mötme. ");
INSERT INTO bmu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aka Kaperneam toŋi, Anutunöŋ iŋini ölöp mem wahöt eŋgii Suep mire öŋgöbeak me qahöpto? Qahöpmahöp! Iŋini mönö kömupkö senjom mire kölölohoba geme. ");
INSERT INTO bmu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Kunŋan keuŋini mötmawi, yaŋön mönö nöŋgö keuni mötma. Kunŋan andö eŋgumawi, yaŋön mönö ni andö nuŋgumapmö, kunŋan ni andö nuŋgumawi, yaŋön melaim niŋgiyöhi, mönö i andö qema.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gwarek 72 yeŋön mala liliŋgöba kaba söŋgaiba kewö jiget, “Kembu, nini göhö qetke öme wöröme jim kutum eŋgiinga yeŋön mewöyök keunini bapŋe anda tököba anget.” ");
INSERT INTO bmu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mewö jigetka Jisösnöŋ meleŋnök, “Nöŋön Satan kakögetka Suepnöhök luhuba wölbilik ewö aköba gei ehal. ");
INSERT INTO bmu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mötket, nöŋön kukösum eŋgibiga iŋini ölöp kitim soramen, skorpion (nendaŋ kömbukŋi pomemba) aka kerökninaŋgö ösum-mumuŋi jitŋambuk pakpak tiget eriga luhut alme. Miaŋgöra yuai kunŋan qahö eŋgum mizit ak eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Miaŋgöra ömewöröme yeŋön keuŋini bapŋe anjemö, töndup eŋgöreŋ sösöŋgai bohonŋi mi miaŋgöra kude söŋgaime. Eŋgö qetŋini Suep mire ohoget Anutugö buknöŋ ahözawi, miaŋgöra mönö önöŋi qahö söŋgaime.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nalö miaŋgöreŋ Uŋa Töröŋan Jisös inahöm waŋgiiga söŋgaiba keu kewö jiyök, “O Iwini, göŋön Buŋa keugi mötkutukutu ambazip mötmöt ketaŋi megeri, yeŋgöreŋ asambötnöŋmö, ambazip nahönbörat ewö nanŋinaŋgöra mötketka gukmaulem akzei, mi mönö yeŋgöreŋ indelnöŋga möt asarize. Miaŋgöra nöŋön Suep gölmegö Kembuŋi gi möpöseim gihizal. O Iwini, gi nangak mewö asuhumapköra mötnöŋ dop köli ölöwahök. ");
INSERT INTO bmu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Iwinan mönö yuai pakpak jim kutuiga nöŋgö buŋaya ahök. Iwinan Nahönŋaŋgö könaŋi nanŋök möt yaköiga kunŋan mi qahö mötza. Mewöyök kunŋan Iwiŋaŋgö könaŋi qahö möt yaköiga Nahönŋanök mi mötza aka ambazip möwölöhöm eŋgiba yeŋgöra mi indelmawi, yeŋön mönö Iwi möt waŋgime.” ");
INSERT INTO bmu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisösnöŋ mewö jiba gwarekurupŋi yeŋgöreŋ liliŋgöba nanŋinök ölöŋ kewö jii mötket, “Iŋini yuai ek kutuzei, denike yeŋön mi ek kutuzei, yeŋön mönö jeŋinaŋgöra aka simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Miaŋgö könaŋi kewö: Nöŋön keu kewö jibi mötket, Kezapqetok ambazip aka kiŋ azi kembu gwötpukŋan iŋini yuai ki ekzei, mi ekingö awöweŋgöba malgetmö, mi qahö eket. Iŋini keu ki mötzei, yeŋön mi mötpingö awöweŋgöba malgetmö, mi qahö mötket.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Köna keugö böhi kunŋan wahöta Jisös bötak ala kewö qesim waŋgiba jiyök, “Böhi, nöŋön denöwö aka malmal kömbönaŋi teteköŋi qahö buŋa qem aŋgubileŋak?” ");
INSERT INTO bmu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jiiga Jisösnöŋ kewö meleŋda qesiyök, “Mosesgö Köna keunöŋ keu denöwö ohoget ahöza? Miaŋgö könaŋi denöwö?” ");
INSERT INTO bmu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Qesiiga meleŋda jiyök, “‘Gi urugi jömukŋi, uŋagi jömukŋi, kuki jömukŋi aka mötmötki jömukŋi miaŋön mönö Kembu Anutugi jöpaköba malman,’ aka ‘Nangi jöpaköm aŋgumakzani, mewöŋanök mönö ambazip pakpak jöpaköm eŋgiba malman.’” ");
INSERT INTO bmu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jiiga Jisösnöŋ meleŋnök, “Törörök meleŋjan. Mi tem köla malmal kömbönaŋaŋgö buŋaya akŋan.” ");
INSERT INTO bmu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mewö meleŋnökmö, Köna keugö böhinöŋ ‘Mi tem köla solanŋi akzal,’ mewö mötmöriba könaŋamŋi kondelmamgö möta Jisösgöra jiyök, “Ambazip sutŋine mala korali, yeŋgöreŋök mönö dagöra jizan? Niŋia qahö jöpaköm waŋgibileŋak?” ");
INSERT INTO bmu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mewö jiiga Jisösnöŋ meleŋda jiyök, “Azi kunŋan Jerusalem siti mosöta Jeriko mire geba könanöŋ kegwek-kahasililiŋ yeŋgö böröŋine gei meget. Memba inap yuaiŋi waŋgita opoŋi qeköba gurusep qeba gila angetka kömumamgö aka ahöyök. ");
INSERT INTO bmu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ahöba mamböriga jike nup galöm kunŋan köna miyök anda eka ek siriba köna likepŋeyök anda oŋgita anök. ");
INSERT INTO bmu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aniga mamböri jike nup azi (Liwait) kunŋan miaŋgöreŋ kaŋgota eka mewöŋanök ek siriba oŋgita anök. ");
INSERT INTO bmu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Anökmö, Samaria prowinsgö azi kunŋan köna miyök anda ahöyöhi, miaŋgöreŋ aŋgota eka wösöŋi möta ehoriyök. ");
INSERT INTO bmu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","“Ehoriba kösutŋe geba uziŋi kelök aka wain oŋan miriba esuhuyök. Uziŋi esuhuba memba kököbihiba doŋkiŋi qakŋe ala waŋgita qenjarök ahöahö mire anda ala köyan köl waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Köyan köl waŋgiba ahöba wahöta söŋanök silim yahötkö töwaŋi (Kina 10,-) uzeta qenjarök mirigö toŋi waŋgiba jiyök, ‘Azi ki mönö köyan köl waŋgiba malnöŋga moneŋ gihizali, mi kude dop köla oŋgitma ewö, mi mönö liliŋgöba kaba miaŋgöreŋ toroqeba gihimam.’ ");
INSERT INTO bmu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Azi karöbut könaŋamŋini mewö kondelget. Azi kegwek-kahasililiŋ yeŋgö böröŋine geyöhi, yaŋgö alaŋi daŋön ahök? Yeŋgöreŋök dagöra mötnöŋ, i uru kalem ak waŋgiyök?” ");
INSERT INTO bmu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Qesim waŋgiiga meleŋnök, “Ak kömum waŋgiyöhi, yaŋön.” Mewö meleŋniga Jisösnöŋ jii mörök, “Gi mönö anda mewöŋanök aka malman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisösnöŋ gwarekurupŋi yembuk könanöŋ angetka Kembuŋinan miri kunöŋ aŋgorök. Aŋgoriga ambi kun qetŋi Marta yaŋön köl öröm waŋgii miriŋe öŋgöyök. ");
INSERT INTO bmu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martagö munŋi qetŋi Maria malök. Yaŋön Kembu eka könaŋi kösutŋe eta tata Buŋa keu jiyöhi, mi kezap ala mörök. ");
INSERT INTO bmu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mörökmö, Martanöŋ lömbuaŋ nupnöŋ öröi anda kaba mökösusu aka Jisösgöra jiyök, “Kembu, munan nömosöri nanök welen nup membi mötnöŋ dop kölja me qahö? Miaŋgöra mönö Maria jinöŋga kaba bauköm niŋgima.” ");
INSERT INTO bmu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jiiga Kembunöŋ meleŋda jii mörök, “Marta Marta, gi yuai könaŋi könaŋi miaŋgöra waimanjat möta mötkurumkurum aka könöpŋambuk aka kinjan. ");
INSERT INTO bmu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mewö kinjanmö, waimanjat mohok kun memba mem köhöininga dop kölma. Nini yuai sehisehiŋi miaŋgöra qahö osizin. Marianöŋ kewöta urugö likepŋi möhamgöm aŋgumamgö möwölöhöba simbawoŋ akza. Malmalgö bahöŋi ölöpŋi mi kunŋan kun kude waŋgitma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jisösnöŋ miri kunöŋ köuluköba mali teköiga gwarekurupŋi yeŋgöreŋök kunŋan kewö jiyök, “Kembu, Jon O-melun azinöŋ gwarekurupŋi köulukö könaŋi kusum eŋgiyöhi, gi mönö mewöŋanök nini kusum neŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jiiga Jisösnöŋ kewö jii mötket, “Iŋini köuluköbin jiba kewö jime: Iwi, göhö qetkan mönö töröŋi ahöma. Mönö galöm köl neŋginöŋga bemtohoŋgahö ölŋi asuhuma. (Göhö jitsihitki Suepnöŋ tem kölakzei, gölmenöŋ mönö mewöŋanök asuhuma.) ");
INSERT INTO bmu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gi wehön dop nene dopnine neŋgiman. ");
INSERT INTO bmu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tosatŋan bölöŋi ak neŋgigeri, nini körek yeŋgö siŋgisöndokŋini mosötzin ewö, gi mönö neŋgöreŋ siŋgisöndok saŋgoŋ neŋgiman. Gi esapesapnöŋ eta neŋgubapuköra aŋgön köl neŋgiba Bölöŋi Toŋaŋgö böröŋeyök meköm neŋgiman.” ");
INSERT INTO bmu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jisösnöŋ toroqeba kewö jii mötket, “Eŋgöreŋök kunŋan suŋgem bibiŋe alaŋaŋgö mire anda möndöba kewö jima, ‘Alani, beret karöbut niŋginöŋga likepŋi biaŋ meleŋ gihibi. ");
INSERT INTO bmu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Alani kunŋan könanöŋ mala nöŋgöreŋ kaŋgoriga neneŋamni qahöpköra gumohom waŋgimamgö jaruzal.’ ");
INSERT INTO bmu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mewö jii alaŋan miri uruŋeyök kewö meleŋda jima, ‘Gi gaun gwölö ak neŋgizan. Ni naŋguŋi lök köl köhöibiga nahönböraturupnan nömbuk tumbulahöpnini tumbula gaun ahözin. Miaŋgöra wahöta mi gihimamgö osizal.’ ");
INSERT INTO bmu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mewö jimapmö, nöŋön jibi mötket: Miri toŋan alaŋi akzawaŋgöra aka qahö wahöta waŋgimapmö, mi töndup kapaŋ köla jiba kinjawaŋgöra mi ölöp wahöta qesizawaŋgö dop körek waŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nöŋön miaŋgö likepŋi kewö jibi mötket: Mönö Anutu köuluköme. Köulukögetka eŋgima. Anutugöreŋ mönö yuaigö böröjaŋ memba jarume. Mi jarugetka kondeliga miwikŋaime. Kinda naŋgunöŋ qeme. Qegetka naŋgu tal eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kunŋan Anutu köulukömakzawi, yaŋön mönö likepŋi buŋa qem aŋguma, yuaigö jarumakzawaŋön mönö mi miwikŋaima. Naŋgunöŋ qemakzawaŋgöra mönö naŋgu öröm waŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Iwiurup eŋgöreŋök daŋön kewö akza: Nahönŋan söragöra qesiiga salupŋe qatö waŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","me kuruk kötŋaŋgö qesiiga skorpion (nendaŋ kömbukŋi pomemba) waŋgima? ");
INSERT INTO bmu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mewögöra iŋini ambazip bölöŋi akze aka töndup kalem ölöpŋi ölöpŋi mi nahönböraturupŋini eŋgibingö mötze ewö, Suep Iwinöŋ mönö kalemŋi denöwö aŋgön kölbawak? Yaŋgö uruŋaŋgö ahakmemeŋi mi neŋgoŋgita tandökŋi kun akza. Miaŋgöra Uŋa Töröŋaŋgöra köuluköba qesim waŋgime ewö, yaŋön mönö sihimŋan i melaiiga uruŋine gema.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ömenöŋ azi kun töŋöt aka numbuŋi jöhöiga mötök maliga Jisösnöŋ ömeŋi mi wuataŋgöiga kota mosöri nesilamŋan lolohoiga kunbuk keu jiyök. Keu jiiga ambazip kambu yeŋön mi eka welipköget. ");
INSERT INTO bmu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Welipkögetmö, yeŋgöreŋök tosatŋan kewö jiget, “Yaŋön mönö öme yeŋgö kembuŋini Katakömulat yaŋgö ösumnöŋ ömewöröme eŋguataŋgömakza.” ");
INSERT INTO bmu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mewö jigetka tosatŋan Jisös keugö bötaknöŋ örömapköra esapköm waŋgiba kewö qesiget, “Gi mönö jim kutunöŋga Suepnöhök aŋgöletot kun asuhuiga ekin.” ");
INSERT INTO bmu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Qesigetmö, yaŋön uru mötmötŋini möt teköba kewö jii mötket, “Kantri denike yeŋgö galömurupŋinan sutŋine aŋgururuk aka julmei, yeŋön mönö ayuhum aŋgugetka kantriŋinan böliba sahopŋanök ahöma. Mewöyök miri kungö könagesö yeŋön julmei, miriŋinan mönö qeqelaŋlaŋ ahöma. ");
INSERT INTO bmu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Mötket! Satangö könagesö yeŋön mewöyök sutŋine aŋgururuk aka julbeak ewö, yeŋön mönö gawman nupŋini membingö osigetka ömetohoŋinan mönö denöwö kinbawak? Iŋini nöŋgöra kewö jize: Yaŋön Katakömulatkö ösumnöŋ ömewöröme eŋguataŋgömakza. ");
INSERT INTO bmu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mewö jizemö, mötket, nöŋön Katakömulatkö ösumnöŋ ömewöröme közöl eŋgibileŋak ewö, eŋgö alaurupŋinan mönö dagö ösumnöŋ mi közöl eŋgibeak? Miaŋgöra yeŋön mönö keuŋini ölŋi me qahö, mi kewöta jim teköme. ");
INSERT INTO bmu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mi jim tekömemö, Anutugö ösumŋan nöŋgö börö kesötni sölölöhöi öme eŋguataŋgömakzal ewö, Anutugö bemtohoŋan mönö eŋgöreŋ kam kuŋguza. ");
INSERT INTO bmu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Azi köhöikŋan timbi liŋgipŋambuk miri gölmeŋi galöm meiga sukinapŋan mönö kahaimök ahöma. ");
INSERT INTO bmu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mewö ahömapmö, azi köhöikŋi kötökŋan luhuba kaba qeba luhut al waŋgiba timbi liŋgipŋi nariyöhi, mi körek waŋgita qezaŋda sukinapŋi memba anda alaurupŋi mendeŋ eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kunŋan nömbuk qahö maljawi, yaŋön mönö qetal niŋgimakza. Kunŋan ambazip nöŋgö qetne tokomegöra qahö öröm eŋgimakzawi, yaŋön mönö mendeŋ eŋgimakza.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ömenöŋ azi uruŋeyök kota gölme qararaŋkölkölŋe anda laŋ liliköba mala luhut memamgö miri jaruba kun qahö miwikŋaiba ölan yöhöiga kewö jima, ‘Mirini mosöta kazali, miaŋgöreŋ mönö kunbuk liliŋgömam.’ ");
INSERT INTO bmu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mewö jiba liliŋgöba miriŋi usuŋda meŋölöi ahöyöhi, mi mewöŋanök ahöi miwikŋaima. ");
INSERT INTO bmu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mewö miwikŋaiba anda öme tosatŋi 7 eŋguaŋgitma. Öme 7 mi nanŋi oŋgita bölöŋi kötökŋi akze. Yaŋön mi eŋguaŋgiriga kaba miri mi öŋgöba miaŋgö uruŋe malme. Mewö aiga azi miaŋgö könaŋi mutuk kileŋkileŋ ahökmö, könaŋgep bölim qölim teköma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisösnöŋ keu mewö jiba mali ambazip kambu sutŋineyök ambi kunŋan qeta Jisös kewö jii mörök, “Gömokni, ambinöŋ gölöm ala gömimba juzu gumohom gihiyöhi, nöŋön yaŋgö mötpi simbawoŋ akza.” ");
INSERT INTO bmu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mewö jiyökmö, Jisösnöŋ kewö meleŋnök, “Mi jizanmö, nöŋön kewö jimam: Ambazip Anutugö keugöra kezap ala möta tem köla köl gulimakzei, yeŋön mönö simbawoŋ akze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ambazip kambunöŋ tokogetka qariiga Jisösnöŋ toroqeba keu kewö jiyök, “Ambazip merak gölmenöŋ maljei, mi kambu bölöŋa. Yeŋön Anutugö aiwesökŋaŋgöra kapaŋ kölakzemö, aiwesök kun kezapqetok azi Jonagöra lök asuhuyök. Anutunöŋ aiwesök murutŋi kun qahö al eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Keu miaŋgö könaŋi kewö: Anutunöŋ mönöwök Jona melaiiga Niniwe yeŋgö sutŋine anda Anutugö aiwesökŋi ahök. Miaŋgö dop Suep gölmegö azi ölŋan mewöyök ambazip kambu kiaŋgö sutŋine asuhuba uruŋini meleŋmegöra kuŋgum eŋgiba aiwesökŋina akŋa. ");
INSERT INTO bmu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Könaŋamŋinaŋgö kaisösöpŋi kun kewö: Anutunöŋ mönöwök mötkutukutu öŋgöŋgöŋi ketaŋi mi kiŋ Solomon waŋgiiga Saut görökenök kantri kungö qin ambinöŋ Solomongö mötkutukutuŋi mötmamgö sihimŋi mörök. Sihimŋi möta gölme göraŋeyök wahöta köna köröp tiŋtiŋi kaba mala Solomongö mötmötŋi mörök. Mi mörökmö, mötket, nalö kewöŋe nöŋön sutŋine asuhuba kinda Anutugöreŋ mötkutukutu öŋgöŋgöŋi memba kazali, mi Solomongö mötkutukutuŋi oŋgitza. Oŋgitzapmö, iŋini töndup nesampurek ak niŋgiba tönpin kingetka qahö dop kölja. “Miaŋgöra Anutunöŋ könaŋgep ambazip körek pakpak öröm eŋgii keuŋini jim tekömapköra jeŋe aŋgotmei, nalö miaŋgöreŋ Saut kantrigö qin ambi miaŋön mönö mewöyök aŋgotma. Yaŋön ambazip kambu ki kinjei, embuk öröröŋ kömupnöhök wahöta eŋgö qöhöröŋine mohotŋe kinma. Mohotŋe kinda keu kewö eŋgö sileŋine alma, ‘Iŋini Jisös nesampurek ak waŋgigetka Anutunöŋ likepŋi meleŋ eŋgii sihimbölö öŋgöŋgöŋi mötme.’ Yaŋön mewö jiiga silikŋi kewöta nanŋinaŋgöra gamuŋini mötme. ");
INSERT INTO bmu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Jonanöŋ Niniwe ambazip sutŋine anda Anutugö keunöŋ uruŋini kuŋgui möta miaŋgöreŋök uruŋini meleŋgetmö, mötket, nöŋön sutŋine asuhuba kinda Jonagö ahakmemeŋi oŋgita ahakzal. Mewö ahakzalmö, iŋini töndup nesampurek ak niŋgimakze. Miaŋgöra Niniwe ambazipnöŋ jimtekötekögö nalö ketaŋe ambazip kambu ki kinjei, embuk öröröŋ kömupnöhök wahöta eŋgö qöhöröŋine mohotŋe kinme. Mohotŋe kinda Niniwe yeŋön keu kewö eŋgö sileŋine alme, ‘Iŋini Suep gölmegö azi ölŋi nesampurek ak waŋgigetka Anutunöŋ likepŋi meleŋ eŋgii sihimbölö öŋgöŋgöŋi mötme.’ Niniwe yeŋön mewö jigetka ahakmemeŋinan nanŋini könaŋamŋini indelgetka gamuŋini mötme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kunŋan lambe me kiwa ohotiriba köwe waŋgömŋe me kimbutnöŋ qahö almapmö, mi mönö miaŋgö dum tatatnöŋ alma. Mewö ali tosatŋan miri uruŋe öŋgöbingö mötzei, yeŋön miaŋgö asakŋi eka ölöp öŋgöme. ");
INSERT INTO bmu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Göhö jegi mi uru silegahö kiwaŋi akza. Miaŋgöra kawöl kunöŋ jegi qahö mem böliza ewö, miaŋön mönö tohoba asarim teköi Anutugö asakŋan ölöp uruge mem asariiga malmalgi pakpak asakŋe malman. Asakŋe malmanmö, sihim kömbönaŋi bölöŋan me yuai kunŋan jegi mem böliba asakŋi közambötza ewö, miaŋön silegö malmalgi mewöyök mem söŋauiga pandaman uruŋe jipjap malman. ");
INSERT INTO bmu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Mewö aiga mötnöŋ, söŋaupnöŋ urugahö asakŋi közamböri söŋaubapuköra mönö tihitki möta galöm mem aŋguman. ");
INSERT INTO bmu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mewö aknöŋga Anutugö asakŋan urugi körek dop köli waŋgömŋi kun qahö söŋauza ewö, göhö silegan mönö mewöyök asoŋ-kilik-kilikŋambuk aka jemesoholgan asariza. Kiwa ketaŋan silege kuŋguba kölköl-bilikbilikŋambuk mem asarim gihizawi, malmalgi mönö miaŋgö dop Anutugö asakŋe al teköba malman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisösnöŋ keu mi jim teköi Farisi (Köna keugö kapaŋkölköl) azi kunöŋ kewö jiba köl öröm waŋgiyök, “Gi ölöp nöŋgö mire öŋgöba tata nene nembin.” Mewö jiiga anda öŋgöba nene nemamgö tarök. ");
INSERT INTO bmu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mutuk böröŋi qahö saŋgoŋda eta tarökmö, Farisi azinöŋ silik mi eka welipköyök. ");
INSERT INTO bmu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Welipköiga Kembunöŋ kewö jii mörök, “O Farisi iŋini mönö ölŋa amöt qem aŋgubingöra qambi aka al nenegö sileŋi saŋgoŋ yakömakzemö, nanŋini uruŋinan mönö tölohoza. Mi dogo jimamoŋ aka qewöloŋ miaŋön kokolak qei malje. ");
INSERT INTO bmu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“O iŋini, uruŋini qahö. Kunöŋ sileŋi pakpak miwikŋaiyöhi, yaŋön mönö uruŋi mewöyök miwikŋaiyök me qahö? Iŋini mönö wuanöŋgöra uru likepŋaŋgöra taŋqaŋ akze? Mi qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Miaŋgöra yuai kiwi al nenenöŋ tatzawi, mi mönö kalema ambazip wanapŋi eŋgime. Mewö aketka Anutunöŋ amöt qem eŋgii eŋgöreŋ yuai pakpak mönö sarakŋi ahöma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“O Farisi ambazip, lömböt qakŋine öŋgözawaŋgöra mönö wölziköba ‘Yei!’ jizal. Iŋini nene pakpak mendeŋda bahöŋi 10 miaŋgöreŋök mohot Anutugö buŋaya qemakze. Gipŋi, supe aka yöha könaŋi könaŋi mi mewöyök meŋdeŋda tenöhök mohot mi Anutugö buŋa qemakze. Naluk mi törörök alakzemö, Köna keugö kötŋi bohonŋi ki mönö oŋgita mosörakze: Gi Anutu uru könömgan jöpaköm waŋgiman aka ambazip sutŋine ahakmeme diŋdiŋi wuataŋgöba malman. Keu bohonŋi mi mönö kapaŋ köla wuataŋgöba malme aka keu morömorö mi mewöyök kude oŋgita mosötme. ");
INSERT INTO bmu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“O Farisi, lömböt qakŋine öŋgözawaŋgöra mönö wölziköba ‘Yei!’ jizal. Iŋini köuluk mire dum tatat mutukŋe jegep tatpingö sihimŋi mörakze. Maketnöŋ me könanöŋ ambazip eŋgeketka jölöŋini jimegö mörakze. ");
INSERT INTO bmu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","O iŋini, lömböt qakŋine öŋgözawaŋgöra wölziköba ‘Yei!’ jizal. Iŋini qaksiri qetŋini qahö miaŋgö dop akze. Ambazipnöŋ qamöt wörönŋambuk denike ahözawi, mi qahö möta qakŋine laŋlaŋ tiba yuai dönqizinŋambuk oseiba tölohomakze.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisösnöŋ keu mewö jiiga Köna keugö böhi yeŋgöreŋök kunŋan möta meleŋda kewö jiyök, “Böhi, gi keu mewö jiba nini mewöyök gamu qem neŋgizan.” ");
INSERT INTO bmu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mewö jiyökmö, Jisösnöŋ keu kewö jiyök, “O Köna keugö böhi, eŋgö qakŋine mewöyök lömböt öŋgözawaŋgöra wölziköba ‘Yei!’ jizal. Iŋini keuŋi keuŋi jim kutuba miaŋgö könjöŋ lömbötŋi ambazip qakŋine alagun algetka mi tem kölbingö lömböriiga jaraŋbaraŋ ahakzemö, nanŋinak i kesötŋinan borom kun bauköm eŋgibingö wösömötmötŋini kun qahö ahöza. ");
INSERT INTO bmu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“O iŋini, lömböt qakŋine öŋgözawaŋgöra mönö wölziköba ‘Yei!’ jizal. Iŋini kezapqetok ambazip yeŋgö qaksirinöŋ simen koum memba meŋölömakzemö, nanŋini ambösakonŋinan mönö i eŋguget kömuget. ");
INSERT INTO bmu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nanŋini ambösakonŋinan kezapqetok ambazip eŋguget kömugetka iŋini yeŋgö qaksiriŋine koum memba simen alakze. Mewö aka miaŋön ambösakonŋini yeŋgö ahakmemegöra imbi köla keuŋini naŋgöba jiba dangunu ewö kinje. ");
INSERT INTO bmu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Miaŋgöra Anutu, mötkutukutu Toŋi yaŋön kewö jiza, ‘Nöŋön kezapqetok ambazip aka aposol melaim eŋgibi eŋgöreŋ kame. Kagetka yeŋgöreŋök tosatŋi i eŋguget kömume aka tosatŋi sesewerowero ak eŋgime.’ ");
INSERT INTO bmu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Anutunöŋ Suep gölme miwikŋaim etkiyöhi, nalö miaŋgöreŋök könahiba kezapqetok ambazip eŋgugetka sepŋini mokoget eri, miaŋgö sep kitipŋi pakpak mi ambazip merak maljei, mönö eŋgö qakŋine öŋgöi sihimbölö mötme. ");
INSERT INTO bmu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelgö sepŋan eri miaŋgöreŋök könahiba eŋguba kota mala Zekaraia jöwöwöl alta aka jöwöwöl jike kömbukŋi mietkö sutŋire qeget sepŋi eri miaŋgöreŋ teköyök. Nöŋön keu kewö jibi mötme: Sepŋinaŋgö kitipŋan mönö ambazip merak maljei, eŋgö qakŋine öŋgöiga sihimbölö mötme. ");
INSERT INTO bmu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“O Köna keugö böhi iŋini, lömböt qakŋine öŋgözawaŋgöra mönö wölziköba ‘Yei!’ jizal. Iŋini Anutugö mötmöt membingö naŋgu ki moröŋi mi ambazip eŋguaŋgita aŋgön köl eŋgimakze. Nanŋinak miaŋgö uruŋe qahö aŋgotket aka tosatŋan miaŋgö uruŋe aŋgotpingö akzei, iŋini i jöhöba aŋgön köl eŋgiba malget.” ");
INSERT INTO bmu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisösnöŋ keu mewö jiba mosöta ani Köna keugö böhi aka Farisi yeŋön könahiba keu könöpŋambuk jim waŋgiba keu könaŋi könaŋi jimapkö qeqesi gwötpuk al waŋgiget. ");
INSERT INTO bmu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Al waŋgigetka numbuŋeyök keu kun qiwitipköiga miaŋön köpeiba keugö bötaknöŋ örömapköra mönöget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jisösnöŋ keuŋi jiiga nalö sutŋe miaŋgöreŋ ambazip tausenŋi tausenŋi yaŋgöreŋ tokoba ölöqölököba utakutal aŋguba kinget. Mewö aka kingetka könahiba gwarekurupŋi kewö jii mötket, “Yuai mutukŋi ki: Iŋini mönö Farisi (Köna keugö kapaŋkölköl) yeŋgö urumeleŋgö silesile ahakmemeŋinaŋgöra galömŋini meme. Mi wösö kömbukŋi ewö akza. Mi qahö mosötme ewö, miaŋön mönö yist ewö qariba mem bölim eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Ambazipnöŋ yuai önun meget ahözawi, mi pakpak mönö kötulgetka aukŋe ahuma. Mewöŋanök keu asambötket ahözawi, mi pakpak mönö indelgetka möt kutume. ");
INSERT INTO bmu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Miaŋgöra mönö keuŋinaŋgö galöm memba malme. Iŋini keu söŋaupnöŋ ölöŋ jimei, mi mönö asakŋe jigetka mötme. Iŋini miri uruŋe waŋgömŋi kungen saŋepnöŋ kezapŋine jimei, mi sobemnöŋ aukŋe jim asarime.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Alaurupni nöŋön eŋgöra kewö jibi mötme: Tosatŋan sileŋini qem kömumba miaŋgö andöŋe yuai kun toroqeba akingö osimei, yeŋgöra mönö keŋgötŋini kude möta malme. ");
INSERT INTO bmu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi qahöpmö, dagöra keŋgötŋini mötketka dop kölmawi, nöŋön mi kondel eŋgimam. Kun daŋön kukösum memba eŋgui kömugetka tötal eŋgii könöp sianöŋ gemei, yaŋgöra mönö keŋgötŋini möta malme. Eŋgöra keu mi kunbuk jizal: yaŋgöra mönö keŋgötŋini möta malme! ");
INSERT INTO bmu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tosatŋan bekösöm (jöjöröm, ulisit) 5 mi toiya yahötŋan söŋgöröŋi memegöra alakzemö, Anutunöŋ mieŋgöreŋök mohok-kungö qahö ölum qeyök. ");
INSERT INTO bmu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anutunöŋ köyan köl eŋgiba nöröp jupŋini pakpak mewöyök oyoŋ teköba jaŋgöŋini mötza. Ambazip eŋgö söŋgöröŋini mi bekösöm ulisit gwötpuk eŋgoŋgita öŋgöŋgöŋi akza. Miaŋgöra keŋgötŋini mönö kude möta malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nöŋön keu kun jibi mötket: Kunŋan ni ambazip jeŋine jim miwikŋaim niŋgimawi, Suep gölmegö azi ölŋan mönö mewöŋanök i Anutugö garataurup yeŋgö jeŋine jim miwikŋaima. ");
INSERT INTO bmu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mewömö, kunŋan ni ambazip jeŋine qaŋ köl niŋgimawi, nöŋön mönö mewöŋanök i Anutugö garataurup yeŋgö jeŋine qaŋ kölmam. ");
INSERT INTO bmu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Kunŋan Suep gölmegö azi ölŋi qetala keu jimawi, Anutunöŋ mi ölöp mosötmapmö, kunŋan Uŋa Töröŋi ilita mepaqepaik akŋawi, yaŋgö siŋgisöndokŋi mi Anutunöŋ qahö mosötma. ");
INSERT INTO bmu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ambazipnöŋ iŋini öröba keu jakeŋine al eŋgigetka köuluk miriŋine me kiap premiö aka kantriŋi kantriŋi mieŋgö kiŋ kembu yeŋgö jemesoholŋine kinmei, nalö miaŋgöreŋ keuŋinaŋgö likepŋi wani keuya denöwö jibinak miaŋgö waimanjatŋi kude mötme. ");
INSERT INTO bmu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mi kewögöra: Iŋini keu jimei, mi Uŋa Töröŋan aua miaŋgöreŋök kusum eŋgiiga jime.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ambazip kambu sutŋineyök azi kunŋan Jisösgö jiyök, “Böhi, iwiniran kömuiga gi mönö datnaŋgö jinöŋga iwiniraŋgöreŋ börösamotŋi mendeŋda niŋgima.” ");
INSERT INTO bmu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mewö jiyökmö, Jisösnöŋ kewö meleŋ waŋgiyök, “O azi, daŋön etkö jimtekötekö toŋiri akŋamgöra kuŋgum niŋgiyöha gölmeŋiri mendeŋbileŋak?” ");
INSERT INTO bmu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mewö jiba keu kewö toroqeyök, “Inap ainemalukuŋinan awamŋanök me keleŋmaleleŋ ahöbawak, malmalŋinaŋgö könaŋi mi miaŋgöreŋ qahö ahöza. Malmalŋini qahö kewöta moneŋ sukinapnöŋ möndöme ewö, mönö ayuhume. Miaŋgöra membagun membingö nepaqepalok (gridi) pakpaköra mönö galömŋini memba malme.” ");
INSERT INTO bmu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mewö jiba dopkeu kun kewö jii mötket, “Azi pomŋi kun malök. Yaŋön gölmeŋe nene nupŋi meiga töhötmöriam ketaŋi asuhuyök. ");
INSERT INTO bmu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mi asuhuiga uruŋan kewö mötmöriba jiyök, ‘Nöŋgö köwe mirini mi morörökŋi. Miaŋgöra padi gösöŋi gösöŋi, koŋ kambuŋi kambuŋi, sehoŋ böranŋi böranŋi mi mönö denikeaŋgöreŋ tokobileŋak? Mönö denöwö akŋamto?’ ");
INSERT INTO bmu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mewö jiba jiyök, ‘Mönö kewö akŋam: Ni köwe mirini köndeŋda salupŋe köwe miri ketaŋi ketaŋi memam. Mi memba nene töhötmöriamni aka sukinapni pakpak mönö miaŋgöreŋ qezaköbi tatma. ");
INSERT INTO bmu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Miaŋgöreŋ tariga nanaŋgöra kewö jimam: O gi simbawoŋ! Töhötmöriamgi mönö awamŋi qahö ahöm gihiza. Miaŋgöra mönö nene nem söŋgaiba yambuŋi yambuŋi siyoŋsayoŋi qahö luhut memba ösöŋ malman.’ ");
INSERT INTO bmu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mewö jiyökmö, Anutunöŋ kewö jii mörök, ‘O gi, urugi qahö! Nöŋön nalögi ala jim teköba uŋagi suŋgem kiaŋgöreŋök goaŋgitpiga kömuman. Kömunöŋga öröyuai pakpak buŋa qem aŋguba malnöŋi, mi mönö dagö buŋaya akŋapto?’ ");
INSERT INTO bmu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Kunŋan nanŋaŋgöra ainemaluku guli dötnam yuai tokomakzapmö, Anutugö qöhöröŋe urugö töhötmöriamŋi qahö ahöm waŋgizawi, yaŋgöra mönö lömböt ketaŋi mewö asuhuma.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisösnöŋ gwarekurupŋi kewö jii mötket, “Mewö asuhumapmö, nöŋön eŋgöra kewö jibi mötket: Iŋini gölmenöŋ malmeaŋgö waimanjatŋi mi kewö jiba kude akŋe: Nini mönö wanat yuainöŋ gumohom aŋgubinak aka wanatnöŋ sileninaŋgö löŋgötpinak? ");
INSERT INTO bmu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sileŋinambuk maljei, miaŋön bohonŋi aiga opo kereŋnöŋ mönö miaŋgö nembö bapŋe ahöza. Jeŋinambuk maljei, miaŋön bohonŋi aiga nenenöŋ mönö miaŋgö nembö bapŋe ahöza. ");
INSERT INTO bmu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Mönö koekoe nei eŋgekŋe: Mieŋön nene kötŋi qahö qesiŋ gilakze. Padi ölŋi qahö yandiba köwe miriŋine qahö tokomakze. Yöha sihiŋini mi qeköm nembi mirinöŋ qahö alakze aka Anutunöŋ mi töndup i gumohom eŋgimakza. Ambazip eŋgö söŋgöröŋini mi nei söŋgöröŋini eŋgoŋgita öŋgöba ahöza. Mönö mi mötmöriget anök. ");
INSERT INTO bmu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Eŋgöreŋök kunŋan waimanjat aka mewö miaŋön gölmenöŋ malmawaŋgö nalöŋi mi sömaŋi mohotkö dop mem toroqema me qahö? Mi qahöpmahöp! ");
INSERT INTO bmu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Mewö aiga yuai morörökŋi mewö akingö osime ewö, yuai tosatŋi pakpaköra mönö denöwögöra waimanjat akeak? ");
INSERT INTO bmu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Iŋini mönö jariŋ juraŋi aködamunŋinambuk mi eŋgekŋe: Mieŋön opo söröŋinaŋgöra möt qahö loŋgalakze. Nup yuai tosatŋi kun qahö memakze aka mi töndup kewö jibi mötket: Kiŋ Solomonöŋ goul silwöŋi qeraköba malukuŋi asoŋ-bilikbilikŋambuk löŋgöta malökmö, yaŋgö malukuŋi mi kiteŋ soranjiŋgö dop eksihimŋambuk qahö ahöyök. ");
INSERT INTO bmu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“Jariŋ juraŋi töhön mi merak gölmenöŋ kösutnine ahöi uran kölgetka eri gila qezaköba ohoget jema. Mi töndup Anutunöŋ juraŋi mewöŋi kun mi tok ölöpŋanök meŋölömakza. Miaŋgöra yaŋön iŋini mewöyök ölöp esuhum eŋgima. Iŋini jariŋ juraŋi miaŋgö dop qahö akze. Anutunöŋ köyan köl eŋgimamgö mötzawi, sihimŋi miaŋön mönö yuai pakpak eŋgoŋgita öŋgöza. O ambazip, mötnaripŋinan mönö wuanöŋgöra morörökŋi akza? ");
INSERT INTO bmu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Mewö aiga iŋini mewöyök malmalŋinaŋgöra mötkurumkurum kude akŋe. Mi aka lömböriba kewö jibepuk, ‘Nini mönö wani nene aka wani o nembinak?’ Mewö jiba uruŋini miaŋgöreŋ kude ala urueret aka urukönöpuk miwikŋaibepuk. ");
INSERT INTO bmu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kantri dop urumeleŋgö kopa yeŋön yuai mewöŋi pakpak buŋa qem aŋgubingö kapaŋ köla urukönöp ahakze. Mi ahakzemö, iŋini nene opo yuaigöra mözöröŋgöba osizei, Iwiŋinan mönö mi möt teköza. ");
INSERT INTO bmu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Miaŋgö urukönöp kude akŋemö, mönö Anutugö bemtohoŋnöŋ aŋgotpingö kapaŋ kölme. Uruŋini miaŋgöreŋ alget ahöiga yaŋön mönö galöm köl eŋgiba yuai mewöŋi mi mewöŋanök toroqem eŋgima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“O kambuni morörökŋi, Iwiŋinan bemtohoŋ al eŋgimamgö mötzawaŋgöra mönö keŋgötŋini kude möta malme. ");
INSERT INTO bmu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gölmegö moneŋ inapŋi mi kapaŋ köla qeraköbepuk. Miaŋgöra yuai ahöm eŋgizawi, mi mönö söŋgöröŋaŋgö ala moneŋ öröba bahöŋi ambazip wanapŋi kalemŋinaŋgöra eŋgime. Mewö aketka qetbuŋaŋini guli dötnam ewö mi Suep mire ahöba sehiba kude qahöwakŋa. Moneŋ gösöŋini qainŋi kun mi Suep miaŋgöreŋ qahö bölime. Gurem jijilukut aka yoŋgorö meme yeŋön mönö eu öŋgöba yuai mem bölibingö osime. ");
INSERT INTO bmu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Yuaigöra aködamunŋi memba mötnöŋ öŋgözawi, miaŋön miri kungen ahöiga göŋön mönö urugi mewöyök miaŋgöreŋ qekötahöba malman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Iŋini mönö Anutugö nupŋi membingöra jöjöröba opo söröŋini jöhöm yaköba aködamunŋinambuk kinda uruŋinaŋgö kiwaŋan ohotirigetka jeiga malme. ");
INSERT INTO bmu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mi kiaŋgö dop: Miri toŋi kun mi ambazip amemegö lömbuaŋnöŋ kaba söŋgaibingöra öröm waŋgigetka anök. Miaŋgöreŋ ani moröurupŋan mire tata liliŋgömapköra jeŋinan yaigep uba ‘Kiŋsiŋ-paŋsaŋ!’ jiba kapaŋ köla mambötze. Mamböta malgetka yaŋön nalö miaŋgöreŋ me miaŋgöreŋ kaŋgota naŋgunöŋ qebawak, yeŋön mönö miaŋgöreŋök naŋgu örögetka kotma. Iŋini mönö morö mieŋgö dop aka jöjöröba malme. ");
INSERT INTO bmu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","“Kembunöŋ liliŋgöba kaiga nup memeurupŋi tosatŋan urugwölö malgetka mewö miwikŋaim eŋgimawi, yeŋön mönö simbawoŋ akze. Nöŋön ölŋa kewö jibi mötket: Yaŋön kaŋgota tokom eŋgiba nene dumnöŋ ali tatketka nene gumohom eŋgimamgö jöjöröm aŋguba welen qem eŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yaŋön ömbibiŋe me miri awöraŋgöiga miaŋgöreŋ liliŋgöi tosatŋan urugwölö malgetka miwikŋaim eŋgimawi, yeŋön mönö simbawoŋ akze. ");
INSERT INTO bmu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Gwölö malbingö keu ki mönö ölöp mötmörime: Suŋgem aiga kegwek azinöŋ wanat nalönöŋ me auanöŋ kamawi, miri toŋan mi mötpawak ewö, yaŋön mönö gwölö mala miriŋi ölöp galöm meiga qesiŋda öŋgömamgö osima. ");
INSERT INTO bmu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iŋini ‘Suep gölmegö azi ölŋan nalö kiaŋgöreŋ qahö kaŋgotma,’ jiba mötmörimei, yaŋön mönö nalö miaŋgöreŋök kaŋgotma. Miaŋgöra iŋini mewöyök jöjöröba malme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisösnöŋ keu mewö jii Pitönöŋ qesiyök, “Kembu, gi dopkeu ki mi neŋgöra me ambazip tosatŋi pakpak yeŋgöra mohok jizan?” ");
INSERT INTO bmu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mewö qesii Kembunöŋ jiyök, “Nup meme ambazip sutŋine daŋön tiŋ kutuba tosatŋi eŋgoŋgitza? Tosatŋan sörörauba nup mosötketka kunŋan mötkutukutu ölöpŋaŋgö qakŋe kapaŋ köla pöndaŋ memakzawi, yaŋön mönö simbawoŋ akza. Miri toŋan ahakmemeŋi kewöta eka kungen anda miriŋaŋgö öröyuaiŋi mi yaŋgö böröŋe ali galöm akŋa. Galöm aka welenqeqeurupŋi jiyöhaŋgö dop köyan köla nalö diŋdiŋe gumohom eŋgimakŋa. ");
INSERT INTO bmu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mewö köyan köl eŋgiba maliga toŋan liliŋgöba kaba mewö eka mönö simbawoŋ jima. ");
INSERT INTO bmu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Nöŋön keu ölŋi kun kewö jibi mötket: Toŋan simbawoŋ jiba sukinapŋi pakpakö galömŋi kuŋgum waŋgima. ");
INSERT INTO bmu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kuŋgum waŋgimapmö, nup meme okonŋi yaŋön uruŋan mötmöriba kewö jima ewö, ‘Kembunaŋgö kaka nalöŋan mönö köröpŋi ahöza.’ Mewö jiba könahiba nup meme ambazipurupŋi eŋgum ureiba közölömbuaŋ ala söŋgaiba o köhöikŋi nemba uruŋi sohoiga eŋololoŋ silekmalek aka malma. ");
INSERT INTO bmu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mewö mala nalö kunöŋ Kembuŋi kaŋgotmapköra qahö mambötmawi, mönö miaŋgöreŋ kaŋgotma. Nalögöra ikmaok iŋululuŋ mali mönö aua miaŋgöreŋ kaŋgota qeba yaijapaleleŋ mem waŋgiba jim kutuiga qeqetal ambazip ewö könöp sianöŋ geba sihimbölö mötma. ");
INSERT INTO bmu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nup meme kunŋan Kembuŋaŋgö jitsihitŋi möt yaköyökmö, keu areŋi jiyöhaŋgö dop qahö jöjöröm aŋguba nupŋi memba malöhi, Kembuŋan miaŋgö likepŋi jiiga jöhöba ihileknöŋ ambemŋi gwötpuk qeaköba qeme. ");
INSERT INTO bmu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mewö qememö, nup meme azi kunŋan Kembuŋaŋgö jitsihitŋi qahö möt yaköba yuai aka meiga likepŋi ölöp jiget ihileknöŋ qemeaŋgö dop akzawi, Kembunöŋ miaŋgö likepŋi jiiga amqeqeŋi qeme. Anutunöŋ kungöra yuai gwötpuk waŋgiyöhi, yaŋön mönö mi mem sehiiga ölŋi gwötpuk ahumapköra al mambötma. Anutunöŋ kungöra yuaigö warökŋi sehisehiŋi al waŋgiyöhi, yaŋön mönö mi mem sehiiga ölŋi sehisehiŋi ahui meleŋ waŋgimapköra qesima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nöŋön gölmenöŋ könöp ala ubi jemapköra etpiga urusihimni miaŋgö bölamŋan lök jeyöhaŋgöra ahöza. ");
INSERT INTO bmu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ahözapmö, mi ‘Ala umam,’ jibi sihimbölö gwötpuk mi nöŋgö qakne öŋgöba mösölumgöm niŋgimamgö akŋa. Anutunöŋ mewö miaŋön melun murutŋi mem niŋgima. O ni wahöjaliŋ ketaŋi möta malbi mem niŋgii miaŋgöreŋ teköma. ");
INSERT INTO bmu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kewö mötmöribepuk: Jisösnöŋ luai qemamgöra aka gölmenöŋ erök. Nöŋön kewö jibi mötket: Nöŋön luai qemamgöra qahöpmö, nöŋgöra aka jula deŋgetka köŋ jabö ahuma. ");
INSERT INTO bmu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Mi kewögöra jizal: Nöŋgö Buŋa keunan ambazip uruŋini kuŋgui meleŋgeraŋgöra nalö kewöŋeyök könahiba kewö asuhuma: Miri kungö uruŋe ambazip 5 yeŋön sutŋine aŋgururuk aka julme. Likep karöbut yeŋön yahöt yetpuk aŋgururuk aketka likep yahöt yetkön karöbut yembuk jujul aka malme. ");
INSERT INTO bmu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iwi morö yetkön jula kerök-kerök ahotka nam morö yetkön tötal aŋguyohotka iranŋan iranŋi qetala julmahot.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisösnöŋ toroqeba ambazip kambu yeŋgöra kewö jii mötket, “Wehön gegeŋe miri böuleiba kousu töwiiga iŋini mi eka miaŋgöreŋök ‘Kie kama,’ jimakze. Mewö jigetka kama. ");
INSERT INTO bmu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Saut görökenök luhut giliga eka möta kewö jimakze, ‘Miri könöpŋambuk akŋa.’ Jigetka miaŋgö dop akŋa. ");
INSERT INTO bmu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","O urumeleŋgö silesile ambazip, iŋini suep gölmegö tandökŋiri eka kie wehöngö könaŋiri ölöp kewörakzemö, nalö ki maljini, miaŋgö könaŋi qahö kewöta möt kutugetka qahö dop kölja.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Iŋini ‘Yuai diŋdiŋi mi denöwö akin,’ jiba miaŋgö könaŋi mi denöwögöra aka nanŋinak qahö kewöta jim tekömakze? Mi qahö dop kölja. ");
INSERT INTO bmu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kerökan silege ala keu jakeŋe öröm gihimamgö aiga jimtekötekö galömgöreŋ anda köna namŋe miaŋgöreŋ mönö kapaŋ köla imbi mohok aka keuŋiri jim solanimahot. Mewö qahö akŋahot ewö, kerökan ölöp örörahöm gihiiga (jas, majistreit) jimtekötekö toŋaŋgö jeŋe aŋgotnöŋga möta jii opotöröpkö böröŋe genöŋga kösö mire al gihibapuk. ");
INSERT INTO bmu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nöŋön kewö jibi mötnöŋ, Gi miaŋgöreŋ töwagi pakpak almanaŋgö dop qaköba tatman. Toiyagi kondikŋi mewöyök al teköbagun mönö töwagi memba etman.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nalö miaŋgöreŋök tosatŋan kaŋgota Jisös kösohot kewö jiget mörök, “Galili ambazip tosatŋan Jerusalem jikenöŋ jöwöwöl ohogetka premiö Pailötnöŋ jiiga suahö galömurupŋan miaŋgöreŋ öŋgöba eŋgum kömugetka sepŋini eta lama bulmakau sepŋinambuk loloŋqaloŋ ahök.” ");
INSERT INTO bmu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mewö jigetka meleŋda kewö jii mötket, “Iŋini miaŋgöra kewö mötmöribepuk: Galili ambazip mieŋön Galili ambazip tosatŋi pakpak eŋgoŋgita siŋgisöndok aka malgeraŋgöra sihimbölö mi mötket. ");
INSERT INTO bmu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mewö qahöpmö, nöŋön kewö jibi mötket: Iŋini uruŋini qahö meleŋme ewö, iŋini körekŋan mönö mewöyök ayuhum teköme. ");
INSERT INTO bmu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Me miri qetŋi Siloam miaŋgöreŋ miri köröpŋi kunŋan eta köla ambazip 18 turum eŋgii kömugeri, iŋini yeŋgöra kewö mötmöribepuk: Yeŋön Jerusalem könagesö tosatŋi pakpak eŋgoŋgita siŋgisöndok aka keuŋinambuk malget. ");
INSERT INTO bmu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Qahöpmö, nöŋön kewö jibi mötket: Iŋini uruŋini qahö meleŋme ewö, iŋini körekŋan mönö mewöyök ayuhum teköme.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jisösnöŋ dopkeu kun kewö jiyök, “Azi kunŋan muli ip kömöri nupŋe kota kini miaŋgö ölŋi jarumamgö anökmö, kun qahö miwikŋaiyök. ");
INSERT INTO bmu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Qahö miwikŋaiba nup galömŋaŋgöra jiyök, ‘Mötnöŋ, nöŋön muli ip kiaŋgö ölŋi yambu (yara) karöbutkö dop kaba jaruyalmö, kun qahö miwikŋaial. Miaŋgöra mi mönö wuanöŋgöra toroqeba gölmegö kelökŋi önewat öröi sihitŋanök akapuk. Miaŋgöra mi mönö köla gilnöŋ anma.’ ");
INSERT INTO bmu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Toŋan mewö jiyökmö, galömnöŋ meleŋda jii mörök, ‘O azi kembuni, mi ölöp mosötnöŋga yambu (yara) ki kunbuk kinma. Nöŋön nalö sutŋe kiaŋgöreŋ kinoŋnöŋ gölme esiba kundupköba isoŋbasoŋ ala liliköbi kelökŋambuk akŋa. ");
INSERT INTO bmu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nöŋön mewö akiga yambu (yara) andöŋe miaŋgö ölŋi ölöp ahubawak. Mi qahö ahuma ewö, mi ölöp kölman.’” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jisösnöŋ Sabat kendonöŋ köuluk miri kunöŋ öŋgöba Buŋa keu kusum eŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Miaŋgöreŋ ambi kun tarök. Ömenöŋ yambu (yara) 18 miaŋgö dop mem löwörim waŋgiiga könisemŋi milipköiga qötöteimamgö osiba tata malök. ");
INSERT INTO bmu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisösnöŋ ambi mi eka oholi kaiga kewö jii mörök, “Ambi, eksekpeksek kawölgan mönö gömosöri ölöwakzan.” ");
INSERT INTO bmu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mewö jiba böröŋi nöröpŋe ali miaŋgöreŋök qötöteiba Anutu möpöseim waŋgiyök. ");
INSERT INTO bmu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Möpöseim waŋgiyökmö, Jisösnöŋ Sabat kendonöŋ ambi mi mem ölöwahöhi, köuluk mirigö galömŋan mi eka miaŋgöra möri bölii keu könahiba ambazip kambu yeŋgöra jiyök, “Nup memegö nalö 6 ahözawi, miaŋgöreŋ mönö kaba mem ölöwak eŋgimapköra jime. Mi Sabat kendonöŋ qahö.” ");
INSERT INTO bmu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mewö jiyökmö, Kembunöŋ meleŋda kewö jiyök, “O urumeleŋgö silesile ambazip! Iŋini pakpak bulmakau aziŋini me doŋkiŋini mi Sabat kendonöŋ mireyök pösata eŋguaŋgitketka onöŋ anda nemakze me qahö? Eŋgöreŋök kunöŋ mi qahö aŋgön köl eŋgimakza. ");
INSERT INTO bmu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mötket! Ambi kiaŋön Abrahamgö gwölönaröha aiga Satanöŋ jöhöm waŋgii yambu (yara) köröpŋi 18:gö dop maliga nöŋön kösöŋi mi Sabat kendonöŋ pösatpi dop köl eŋgiza me qahö?” ");
INSERT INTO bmu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mewö jiiga tuarenjoŋurupŋi pakpak yeŋön gamuŋini mötket aka ambazip kambu pakpak yeŋön aŋgöletot wewelipŋambuk meyöhi, mi pakpak eka möta söŋgaiget. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisösnöŋ dopkeu kun kewö jiyök, “Anutugö bemtohoŋaŋgö könaŋi mi denöwö? Mi wanatpuk dop albileŋak? ");
INSERT INTO bmu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mi nejoŋ kötŋaŋgö dop kewö akza: Azi kunŋan mi memba nupŋe anda esiiga wahöta qariba ip ahök. Ip aiga könakemba neiŋi neiŋi mieŋön aipŋini ip miaŋgö böröŋe alget.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisösnöŋ dumŋe kunbuk dopkeu kun kewö jiyök, “Anutugö bemtohoŋi mi wanat yuaibuk dop albileŋak? ");
INSERT INTO bmu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mi yist me flaua mem qariqarigö dop kewö akza: Ambi kunŋan ‘Beret ohomam,’ jiba yist memba flaua könde karöbut miaŋgöreŋ mindiriba meleŋqeleŋ aka anda anda tari körekŋanök qariyök.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisösnöŋ anda taonŋi taonŋi aka miriŋi miriŋi miaŋgöreŋ Buŋa kusum eŋgiba anda mala Jerusalem sitinöŋ göröken anök. ");
INSERT INTO bmu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ani kunŋan kewö qesim waŋgiyök, “Kembu, uruŋini meleŋget Anutunöŋ amöt qem eŋgii letotmei, mi ambazip awamdökŋa me denöwö?” Qesim waŋgii kewö jii mötket, ");
INSERT INTO bmu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Iŋini mönö naŋgu giwikŋe aŋgotpingö jaram tiba aum-mörime. Nöŋön kewö jibi mötket: Ambazip gwötpukŋan Anutugö bemtohoŋ uruŋe aŋgotpingö esapkömemö, mi osime. ");
INSERT INTO bmu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Könaŋgep miri toŋan wahöta naŋgu köligun iŋini nalö miaŋgöreŋ könahiba yaigep kinda naŋgunöŋ qeba kewö jime, ‘Kembu, mönö naŋgu öröm neŋginöŋ.’ Mewö jigetka meleŋda kewö jii mötme, ‘Ni qahö möt eŋgizal. Iŋini denikegöra, mi qahö mötzal.’ ");
INSERT INTO bmu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mewö jiiga iŋini miaŋgöreŋök könahiba kewö jime, ‘Neŋön mönö göbuk köisirik tata nene nein. Göŋön mönö liliköba neŋgö sombemnöŋ Buŋa kusum neŋginöŋ.’ ");
INSERT INTO bmu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mewö jimemö, yaŋön keu kewö jima, ‘Iŋini denikeaŋgöra, ni qahö möt eŋgizal. Miaŋgöra kewö jibi mötket: Bölöŋi meme pakpak, iŋini mönö nömosöta kesalget.’ ");
INSERT INTO bmu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kesalgetka miaŋgöreŋ Abraham, Aisak, Jeikob aka kezapqetok ambazip pakpak yeŋön Anutugö bemtohoŋ uruŋe kingetka eŋgekŋemö, nanŋini aköm eŋgigetka yaigep kinme. Könaŋini mewö miwikŋaiba sahöt gigilahöba irimŋini yöhözömgögetka qetŋi qeri malme. ");
INSERT INTO bmu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ambazipŋi ambazipŋi mi wehön kotkotŋeyök aka gegeŋeyök aka likeplikep Not Saut miaŋgöreŋök kaba Anutugö bemtohoŋnöŋ aŋgota dum tatatŋini memba nene nem söŋgaip aka malme. ");
INSERT INTO bmu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mewö malmemö, mötket! Qöndökŋi yeŋgöreŋök tosatŋan mutukŋi akŋe aka mutukŋi yeŋgöreŋök tosatŋan qöndökŋi akŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nalö miaŋgöreŋök Farisi (Köna keugö kapaŋkölköl) tosatŋan Jisösgöreŋ kaba kewö jiget, “Kiŋ Herodnöŋ guhui kömumangö mötza. Miaŋgöra mönö miri ki mosöta anman.” ");
INSERT INTO bmu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jigetka kewö meleŋ eŋgiyök, “Iŋini mönö arökŋaŋgö kiam soŋ mi kewö jiget mötma, ‘Mötnöŋ! Nöŋön merak aka uran ömewöröme eŋguataŋgömam aka kawöl ambazip mem ölöwak eŋgiba malmam. Anmami, uruwale mönö miaŋgöreŋ aŋgota nupni mekömam.’ ");
INSERT INTO bmu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Kezapqetok ambazip sehisehiŋi mi Jerusalem sitinöŋ eŋgugetka kömuget. Miri tosatŋe qahö toroqeba eŋguget kömumakze, miaŋgö tandöktandök ahöza ekzal. Miaŋgöra nöŋön merak aka uran uruwale köna anda malmam. Jerusalem aŋgotpiga nuŋguget kömumam ewö, mönö yeŋgöreŋ aiakaŋina mi toroqeba akŋe.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jisösnöŋ jiyök, “O Jerusalem Jerusalem, iŋini kezapqetok ambazip eŋguget kömugetka Anutunöŋ ambazip melaim eŋgii eŋgöreŋ kamakzei, mi kötnöŋ kumbuköm eŋgimakze. Poi namŋan moröurupŋi ginginŋi bapŋe ala köjöjohom eŋgimakzawi, nöŋön miaŋgö dop nalöŋi nalöŋi göhö könagösöurupki suhuba tokom eŋgimamgö möta malalmö, iŋini mi tököba mala kotket. ");
INSERT INTO bmu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mötket! ‘Anutunöŋ mönö jike miriŋini andö qeiga sahopŋanök ahöma.’ Mewö ahömapmö, nöŋön kewö jibi mötket, iŋini ni kunbuk qahö nekŋemö, könaŋgep nalö kun kam kuŋgui miaŋgöreŋ neka kewö jime, ‘Kembugö qetŋe kam neŋgizawi, Anutunöŋ mönö i kötuetköm waŋgima.’ Mewö.” ");
INSERT INTO bmu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jisösnöŋ Sabat kendon kunöŋ Farisi (Köna keugö kapaŋkölköl) yeŋgö jitŋememe kungö miriŋe öŋgöba nene neyök. Nemba tari tosatŋan galöm memba ektiget. ");
INSERT INTO bmu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Miaŋgöreŋ yaŋgö jemesoholŋe kawöl azi kun köna böröŋi onöŋ ölököba qarii tarök. ");
INSERT INTO bmu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisösnöŋ i eka könahiba Köna keugö böhi aka Farisi mi qesim eŋgiba kewö jiyök, “Sabat kendonöŋ azi mem ölöwak waŋgiba mewö miaŋön Köna keu oŋgitpin me qahö?” ");
INSERT INTO bmu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mewö jiyökmö, yeŋön göröŋ qeba tatket. Tatketka böröŋan azi mi misiriba mem ölöwaka melaii anök. ");
INSERT INTO bmu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ani kewö jii mötket, “Eŋgöreŋök kungöreŋ morö me bulmakau aziŋi mi Sabat kendonöŋ o lömnöŋ gema ewö, mi mönö ösumok örögetka kotma. Daŋön mi qahö öröi kotpawak?” ");
INSERT INTO bmu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mewö qesim eŋgii miaŋgö likepŋi meleŋbingö lömböriba numbuŋini muhungöba bök tatket. Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Farisi (Köna keugö kapaŋkölköl) azinöŋ ambazip nenegöra köl öröm eŋgiyöhi, yeŋön dum qaikŋe eu meköba tatkeri, Jisösnöŋ mi eka miaŋgöra dopkeu kun kewö jii mötket, ");
INSERT INTO bmu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kunŋan gi amembitkö lömbuaŋgöreŋ köl öröm gihii miaŋgöreŋ anda dum jegenŋeyök qahö memba tatman. Mewö akŋan ewö, tosatŋi köl öröm eŋgiyöhi, yeŋgöreŋök kunŋan gi goŋgita qetbuŋaŋambuk akapuk. ");
INSERT INTO bmu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“Yaŋön kaŋgoriga lömbuaŋ toŋan göhöreŋ kaba kewö jibawak, ‘Gi dum ki mosötnöŋga öŋgöŋgöŋi yaŋön tatma.’ Mewö jima ewö, gi mönö wahöta bapŋe emu eta dum memba tata gamugi senjombuk mötpanbuk. ");
INSERT INTO bmu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mewö qahöpmö, kunöŋ köl öröm gihimawi, gi ölöp dum siminŋe emu anda tatman. Mewö tatnöŋga lömbuaŋ toŋan kota geka jima, ‘Alani, gi ölöp kaba dum jegenŋe eu anda tatman’. Mewö jiiga göŋön ambazip göbuk tata nene nezei, mönö körek yeŋgö jeŋine qetbuŋagabuk akŋan. ");
INSERT INTO bmu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mi kewögöra: Nanŋini uruŋini memba öŋgömei, Anutunöŋ i körek memba et al eŋgima. Kunŋan nanŋi uruŋi memba etmawi, Anutunöŋ mönö i memba öŋgöba al waŋgima.” ");
INSERT INTO bmu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Farisi (Köna keugö kapaŋkölköl) azinöŋ ambazip köl öröm eŋgii lömbuaŋnöŋ tatketka Jisösnöŋ lömbuaŋ toŋi liliŋgöba eka kewö jii mörök, “Gi silimgö me suŋgemgö lömbuaŋ kun ohoba miaŋgöreŋ nangi alaurupki me darumunurupki mi kude köl öröm eŋgiman. Tinitosolomurupki me miri kasunŋaŋgö ambazip pomŋi qetbuŋaŋinambuk mi kude köl öröm eŋgiman. Mewöŋi lömbuaŋgöra köl öröm eŋginöŋi, i mewöŋanök köl öröm gihiba tosagi mi meköm gihiget teköma. Mewö akŋan ewö, Anutunöŋ mönö miaŋgö töwaŋi qahö gihima. ");
INSERT INTO bmu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Mewö qahöpmö, lömbuaŋ mözözömgöba ohomani, gi mönö ambazip etqeqeŋi mia köl öröm eŋgiman. Ambazip wanapŋi, simalokon aka jegömöl akzei, mönö mia eŋgoholnöŋga dop kölma. ");
INSERT INTO bmu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mi köl öröm eŋginöŋga yeŋön tosa meköm gihibingö osigetka gi miaŋgöra simbawoŋ aka malman. Tosaŋini mi öne ahöi malnöŋga solanŋi yeŋön kömupnöhök wahötketka nalö miaŋgöreŋ Anutunöŋ nanŋak mi göhöra meköm gihima.” Mewö. ");
INSERT INTO bmu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jisösnöŋ mewö jiiga nene nemba tatket yeŋgöreŋök kunŋan mi möta kewö jii mörök, “Kunöŋ Anutugö bemtohoŋ uruŋe aŋgota nene nemba tatmawi, nöŋön yaŋgöra simbawoŋ jizal.” ");
INSERT INTO bmu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mewö jiiga kewö me