﻿USE sofia;
DROP TABLE IF EXISTS sofia.bmrNT_vpl;
CREATE TABLE bmrNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bmrNT_vpl WRITE;
INSERT INTO bmrNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jinoodɨmou Jesucristo eedeetemɨhaiu iicaumo. Jaabo Jesucristo David, Abraham, icamɨsi iyaachi iicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Jaabo Abraham Isaac onooboco seemevauhi. Jaabo Isaac seemevauhi Jacob onooboco. Jaabo Jacob seemeneu Juda onoobo bu saatoho inahabomɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jaabo Juda seemevauhi Fares, Zara, onoomɨsico. Jaamɨsi seejɨu Tama onoogo. Jaabo Fares seemevauhi Esrom onooboco. Jaabo Esrom seemevauhi Aram onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Jaabo Aram seemevauhi Aminadaco. Jaabo seemevauhi Naaso onooboco. Jaabo seemevauhi Salmon onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jaabo seemevauhi Boos onooboco. Jaabo seejɨu Rahab onoogo. Jaabo Boos seemevauhi Obed onooboco. Jaabo seejɨu Rut onoogo. Jaabo Obed seemevauhi Isai onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jaabo Isai seemevauhi aivojɨɨbo Davidco. Jaabo aivojɨɨbo David taabau Betsabe onoogo. Jaago Uria onoobo taabaco udumɨtɨɨcɨugo Salomon onooboco seemevauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jaabo Salomon Roboan onooboco seemevauhi. Jaabo seemevauhi Abia onooboco. Jaabo Abia seemevauhi Asa onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jaabo Asa seemevauhi Josafat onooboco. Jaabo seemevauhi Joram onooboco. Jaabo seemevauhi Uzias onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jaabo Uzias seemevauhi Jotan onooboco. Jaabo seemevauhi Acaz onooboco. Jaabo Acaz seemevauhi Ezequias onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jaabo Ezequias seemevauhi Manase onooboco. Jaabo seemevauhi Amon onooboco. Jaabo seemevauhi Josia onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jaabo seemevauhi Jeconia onoobo, bu inahabomɨ icamoco Israel cuumimɨnaaco Babilonia jiinɨjevɨ asatyuudɨɨhivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jaanobuunatɨ Jeconia seemevauhi Salatiel onooboco. Jaabo seemevauhi Zorobabelco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jaabo Zorobabel seemevauhi Abiud onooboco. Jaabo seemevauhi Eliaquim onooboco. Jaabo seemevauhi Azor onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jaabo seemevauhi Sadoc onooboco. Jaabo seemevauhi Aquin onooboco. Jaabo seemevauhi Eliud onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jaabo Eliud seemevauhi Eleazar onooboco. Jaabo seemevauhi Matan onooboco. Jaabo seemevauhi Jacob onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaabo Jacob seemevauhi Joseque Maria taje iicauboco. Jaago Maria Jesuco seemevauhi Cristo imomo iicaaboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jaamaño Abraham iicaunotɨ David ifiivuunovɨ icamo fahuseecɨ siino igueenemeheje ɨdɨɨmobacajeva. Jaanotɨ bu siino tonoodɨbacajevaro, bu israelmɨco babiloniamɨ iguiinonɨumoro aamocasiunovɨ. Jaamo nanivamɨnaaco iicanɨcɨbadɨ. Babilonia jiinɨjevɨ satyuumo. Jaanotɨ bu siino tonoodɨbacajeva nigacɨtɨ jari Cristo fiivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jillɨ Jesucristo fiivuuhi seejɨ Maria Joseque itajevaqui icacuuhi. Jaarugo diibomahi iicautɨnaacaro seemene ijeebɨɨfaño icacuuhi Moocaani Gaija mitya noojɨri. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jaanaa Jose aijɨ ijeebɨɨ imino iicahicaumaño imuguutɨɨbo miyamɨnaaco diigo tollɨ iicaunoco uguubusunoco. Jillɨ llɨɨvɨ diigotɨ gaajacɨratɨno idugaavequi omoonɨjiruno, ");
INSERT INTO bmrNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","esamaajeri icahicaubovɨ fucu tɨgafañodɨ Moocaani toomomɨnaafi diibovɨ ajafeveuboro diiboco nuuhi: Jose David iyaachi, igototɨɨboro Mariaco diitaabatɨ gaayɨcɨ oono diigofaño seemene ifiivosee Moocaani Gaija seemene. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jaasee ifiivoseeque Jesutɨ momonɨ. Jillɨ diibo momo icaji diibo cuumimɨnaaco iimitɨtɨ ataajasujiibo iicamaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jillɨ icauno johono Moocaani ihiimaamɨnaafi Isaia onoobofeenedɨ unuuno imiyacafetequi: ");
INSERT INTO bmrNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Bagocaja ohoovagoro seemevajigo. Jaabo momoji, Emanuel, nooboro. Jaano jino momo Emanuel onoono: Moocaani mɨɨhaivɨ gasecuhi, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jaabo Jose aaicuudɨ, Moocaani toomomɨnaafi diiboco unuubadɨ moonɨubo Mariaco mogaitɨ gaayɨcɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Jaarugoma icautɨɨbo iseemeneque ɨɨcɨugoro Jesutɨ omomonɨutɨnohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jaabo Jesu fiivuuhi Belen onoocuumivɨ Judea jiinɨjevɨ. Jaasumi Herode onoobo toojiinɨje aivojɨɨbou. Jaanaa Jerusale cuumivɨ gaseumo oriente aamɨjɨtɨ asaaumo maaimomɨ gaseuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jaamo dilluuhi: ¿Cuuca iicaabo judiomɨ aivojɨɨbo ifiivoobo? Mɨɨro mɨɨhai orientetɨ imeecɨrɨgaico maatyɨmemere jino masaahi diiboco mihimovamo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Diito jillɨ unuunoco ihaivojɨɨbo Herode uguubuuboro nɨjɨ nɨjɨ minifutuuhi, bu paryɨ Jerusale cuumi miyamɨnaa icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jaaboro ihaivojɨɨbo paryɨɨcɨno sacerdotemɨ aivojɨtoco ucuuhuvauboro, bu Moise tajɨɨbaco miyamɨnaaco ɨjɨɨbeguefimoco icano ucuuhuvauboro diitoco dilluubo: ¿Naa, conoovɨ fiivejiibo Cristo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jaanegui nuumo: Belen de Judeavɨ fiivejiibo tollɨ nooboro Moocaani iimaamɨnaafi caatɨnɨuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ɨɨjoho Belen Juda jiinɨje cuumi, aivo obocɨgotɨrucuumi, bu toojiinɨjeo aivojɨtoguiinovɨ diicarahi. Jaarunaa Moocaani bocɨgusuhi. Mɨɨro difañotɨ aivojɨɨbo fiiveji taacuumimɨnaa israelmɨnaaco eteemejiibo, noono, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jaanoma iicaubo Herode diito maaimomɨco toovono ucuuhuvauboro imino dilluuhi diitoco imeecɨrɨgaico cofucu aatyɨmeunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jaaboro diitoco Belen cuumijaa agalluuboro nuubo: Tahɨ mofoo. Jaamoro imino midillu toosee iicamañoco. Jaamo mahatyɨmedɨ uco mɨjɨɨbogo uujoho bu tollɨro imetequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jillɨ nooboro diitoco maaimomɨco ihaivojɨɨbo ɨjɨɨbuguuneri fuumo. Jaanaaca diibo imeecɨrɨgaico aamɨjɨtɨ aatyɨmeubo diito ɨmega feehicauhi. Jaanofeenevɨ jari imeecɨrɨgai samañovɨro minifutuuhi toosee iicaunohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jaagai imeecɨrɨgaico imaaimomɨ aatyɨmeumoro sihidɨ imo imo minifutuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jaadɨ toojafaño ajaaheveumo tooseeque atyɨmeuhi, bu seejɨ Mariaco icano. Jaamoro tooseeguiino ememuɨɨvuumoro tooseeque imuumo. Jaadɨ isatyotaaco afaayɨumoro tooseeque acɨumo oro, insienso, mirra icanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jaadɨ tɨgafañodɨ diitoco: Herode iicahɨgodɨ muhuumidino, noonoro afaguunegui, siijɨriro uumiumo ijiinɨjejaago. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jaamo diito maaimomɨ ufuunobuunatɨ tɨgafaño Moocaani toomomɨnaafi Josevɨ ajafeveuboro diiboco nuuhi: Gañiivo jaaboro seemeneque seejɨma dɨɨcɨɨbo Egipto jiinɨjevɨ digaa. Jaaboro tahɨ diica jari ɨco onoonohachuta Herode amɨɨsi seemeneque guiinejiibo igaicaauqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jaanegui Jose agañiivuuboro tooseema seejɨco ɨɨcɨuboro fucufeenevɨro fuuhi Egipto jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tahɨ icaumo Herode iguijeveutɨnohachuta. Jillɨ icauno Moocaani ihiimaamɨnaafifeenedɨ unuuno imiyacafetequi: Egipto jiinɨjetɨ Taseemeneque cuuhuvaji, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jaanaaca Herode maaimomɨ diibo iijɨco agañɨɨunoco agaajacɨuboro sihidɨ sɨfiiratuubo. Jaaboro seemeque paryɨɨcɨno gaisiraicɨsuubo mificabacɨtɨ guiinovɨ iicaumoco paryɨ Belen cuumiri icaumo seemeque, bu paryɨ ihallɨdɨ iicaucuumije miyamɨnaa seemeque icano, maaimomɨ diiboco unuusumi paryɨ ifiivuusehejeque. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jillɨ miyaavuuno, Moocaani iimaamɨnaafi Jeremia acaatɨnɨuno: ");
INSERT INTO bmrNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Guubuvusuno ico Rama onoohɨgovɨ ataacasino sihidɨ ɨjɨjovoonɨno; Jaago Raquel iseemeque ataago. Jaago imogotɨhi diigoco ajacusunoco ochoomocɨnɨcuuneguiiha, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jaanobuunatɨ Herode iguijeveunobuunatɨ siino Moocaani toomomɨnaafi Josevɨ siino jafeveuhi tɨgafañodɨ Egipto jiinɨjevɨ. Jaabo diiboco nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Goova gañiivoobo seemeneque seejɨma dɨɨcɨɨbo dojɨcuvɨro duhuumi Israel jiinɨjevɨ guijevecuumo seemeneque agaicaauguehicaumo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jaanegui Jose agañiivuuboro tooseeque seejɨma satyuuhi Israel jiinɨjejaago. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jaarunaa Arquelao onoobo caanibuuna Judeavɨ aivojɨɨbotɨ iicaunoco Jose agaajauboro tahɨ ufuunoco iguiubo. Jaaboco tɨgafañodɨ ɨjɨɨbuguunoma iicaubo Galilea jiinɨjejaagovɨro fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jahɨgo ɨɨfutuudɨ Nazare cuumivɨ icatuubo. Jillɨ icauno Moocaani iimaamɨnaa unuuno imiyaavequi: Jesu Nazareoobo, noocɨnɨji, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tusumi Jua Nitɨmɨnaafi saauhi Judeatɨ iicano sɨcaihɨgovɨ jɨɨbogooboro jillɨ neehicauhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Amɨɨhai imitɨco mejeevesucu, jino Moocaani aivojɨ iicajino fiitɨvucuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jaabo jaanɨ Jua, johono diibotɨ Moocaani iimaamɨnaafi Isaia jillɨ nooboro acaatɨnɨubo: Saatoho ico guubuvusuhi sɨcaihɨgotɨ ocoovadiicɨnɨno: Moocaani jɨɨhaico mihimibachu; sano tɨcovoro jɨɨhaico meheetavo, onoono. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jaabo Jua gaachehuu camellomɨ ijeene eetavotau. Jaabo machutahicau chahacamɨ, bajɨo iimɨ icanoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jaaboco uguubunɨcɨvamo saahicauhi Jerusale cuumitɨ. Paryɨ Judeao jiinɨjemɨnaa, bu Jorda teehi fiitɨno iicano jiinɨjemɨnaa icamo diiboco uguubunɨcɨvamo. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jaamo iimitɨco ɨjɨɨbogonobuunatɨ Jua diitoco Jorda onoohifaño nitɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jaanaaca bu diibojaago ajashutɨmo fariseomɨoto, saduceomɨoto icamo diibojaa initɨquimaaivamo asaahicaunoco aatyɨmeuboro diitoco nuuhi: ¡Jiinimomɨbadɨ mihicano miyamɨnaa! ¿Mɨɨjoho amɨɨhaico ɨjɨɨbogonotɨ mataajaji ñɨhicuno Moocaani omoonɨjino ifiitɨvonotɨ? ");
INSERT INTO bmrNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jaanegui imino mihica miyaano amɨɨhai eedeehifiico mejeevesuno foovono ihɨfuvusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jaamoro mɨɨhai Abraham iyaachimɨhai, noomoro mihiimaadino. Mɨɨro jino amɨɨhaico neehi: Jiba guiisiba icarubatɨ Abraham iyaachimɨhaitɨ Moocaani fiivusujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mɨɨro jɨgaaje imibaicɨnɨcuuhi ɨmohonoco iquitɨqui. Jaabadɨ paryɨ ɨmohono iiminoco onoovatɨhehejeque miquitɨmoro cɨɨjɨgaifaño mɨjɨgasutahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Miyaano naha uujoho nɨfaihuri nitɨhicahi amɨɨhai imitɨco mejeevesucuuno jɨɨbogobadɨ iicano. Jaanotɨ naha taabuunatɨ asaabo amɨɨhaico nitɨji Moocaani Gaijari, cɨɨjɨgairi icano. Diibo tajanaanɨcɨvɨ mityahi. Jaamaño uujoho aivo ɨfototɨhi diibo tɨhaipaajeque asatyejirunovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jaabo usefaño ipala icacuuhi. Jaaneri itrigoco iimibachuuboro ibeevaco aicujiibo. Jaaboro itrigo noovataco igranerofaño ficujiibo. Jaaboro ibeevanoco jɨgasujiibo ufucuro ajabaavejitɨno cɨɨjɨgaifaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jaanaaca Jesu saauhi Galileatɨ Jorda onoohijaago Jua iicauhɨgo diiboco Jua initɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jaarunaaca Jua itɨconɨ imuguutɨhi. Jaaboro Jesuco nuubo: ¿Uco naha ɨɨjoho nitɨjirahi mɨllɨtɨ bu ɨco uujoho nitɨjirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jaarunaa Jesu diiboco nuuhi: Jaafa jisumihiica tollɨ icano, tollɨ Moocaani atajɨɨbanoco imino momoonɨqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jaadɨ Jesuco initɨubo iteehifañotɨ iinovaubacaro niqueje faayacafutuuhi. Jaanofañotɨ Jesu atyɨmeuhi Moocaani Gaija nimɨihubadɨ jeevaabo diibohallɨvɨ iniitovaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jaanaaca guubuvusuuno niquejefañotɨ unuuno: Jaanɨ Taseemene aivo agaijɨɨbo diiberi sihidɨ uujoho imo imo iicaabo, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jaanaacaro Moocaani Gaija Jesuco satyuuhi sihɨ sɨcaihɨgovɨ, ɨjɨ diiboco inɨsuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jaabo tahɨgo icaubo cuarentadɨ cuujeva, bu cuarentadɨ fucuva icano machutɨɨbo. Jaanobuunatɨ jari diibo ajeba aivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jaaneguiiha ihɨjɨ Jesujaa asaauboro diiboco nɨsuvauhi jillɨ nooboro: Miyaano Moocaani Seemene idiicahachiijɨ jiba guiisibaco tajɨɨba maahunotɨ iminifetequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jaarunaa Jesu diiboco iimusuuhi: Mɨɨro Caatɨnɨhaame neehi: Ɨdɨɨnoro maahu sefari miyamɨnaafi icajitɨhi, tollɨro bu Moocaani iijɨ sefari icajiibo, noono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jaadɨ ihɨjɨ Jesuco satyuuhi iimino Jerusale cuumihallɨvɨ. Jaaboro diiboco caamovono ficuubo Moocaani iija niibahucu nijequevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jaaboro diiboco nuubo: Miyaano aivo Moocaani Seemene idiicahachiijɨ juugatɨ baavɨ casiniivo. Mɨɨro Caatɨnɨhaamefaño noono: Moocaani itoomomɨnaaco tajɨɨbaji ɨco iteemequi ihusenehallɨvɨ ɨco gaayɨcɨnɨjimo. Jaabo guiisiba sefavɨ ditɨhaiño aivovotɨno iicaqui, noono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jaanegui Jesu diiboco iimusuuhi: Mɨɨro tollɨro noono Caatɨnɨhaamefaño: Moocaanico nɨsudino, noono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jaanaaca bu siino ihɨjɨ diiboco satyuuhi caamovobaɨ nijequevɨ. Jaaboro paryɨ diiboco ɨɨfusuubo fanoojiinɨjeneque paryɨ ihaivojɨnoma. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jaaboro diiboco nuubo: Meecɨ, paryɨ jinooco ɨco uujoho acɨji, taaguiino ememuɨɨvooboro uco idiimohachiijɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jaanoma iicaabo Jesu diiboco nuuhi: Satanas fuucu, mɨɨro Caatɨnɨhaame neehi: Moocaani Dioscoro diimo. Jaaboro diibocoro deecɨvo, noono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jaadɨ jari ihɨjɨ Jesuditɨ buhɨgovɨ minifutuuhi. Jaadɨ Moocaani toomomɨnaa asaaumoro diiboco jeecɨvovauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jaanaa Jesu guubuuhi Jua cɨvojafaño iicaunoco uguubuuboro fuuhi Galilea jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jaaruubo Nazare cuumivɨ icautɨɨboro ufuubo icatuuhi Capernau cuumivɨ, Zabulon, Neftali icamɨsi jiinɨje onoohɨgo muuaijɨniri iicaucuumivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tollɨ icauno, Moocaani iimaamɨnaafi Isaia acaatɨnɨuno imiyaacafetequi: ");
INSERT INTO bmrNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulon jiinɨje, Neftali jiinɨje icano muuaijɨnidɨ iicano jɨɨhairi, Jordantɨ aamɨjɨjaagovɨ, Galilea iicahɨgo judiomɨ iicatɨmo iicahɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Cɨvono jiinɨjeguiino iicaumoco achɨcɨuno seseene. Jaabadɨro bu guijeve cɨvo jiinɨjeguiino iicaumoco sesee achɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jaadɨ jari Jesu tɨconɨuhi miyamɨnaaco ɨjɨɨbogoobo: Amɨɨhai imitɨco mejeevesucu jino Moocaani aivojɨ fiitɨvucuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jaanaaca Jesu feehicauhi Galilea muuaijɨnidɨ. Jaabo atyɨmeuhi miimɨsiicɨ inahaboma icamɨsico. Saafi momou Simon onoobo bu samomou Pedro. Jaanotɨ saafi momou Andre onoobo. Jaamɨsi fiicɨmɨnaatɨsi iicaumaño isinɨcuuhuneri muuaifaño fiicɨhicaumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jaamɨsico Jesu nuuhi: Tadyojɨcutɨ masaa amɨɨsico miyamɨnaa fiicɨmɨnaatɨsitɨ eetavequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jaasumiro isinɨcuuhunoco ejeevesuumɨsiro diibo dojɨcutɨ fuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bu jaano janaanɨcɨ Jesu siino sitɨsico atyɨmeuhi: Jacoobo onoobo, bu Jua icano iicamɨsi Zebedeo achimɨsico, imeenegafaño caanima iicaumɨsi isinɨcuuhunoco amaahunɨumɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jaamɨsico Jesu ucuuhuvaunegui caanico imeenegafaño ejeevesuumɨsiro diiboma fuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jaabo Jesu fahɨgovadɨ Galilea jiinɨjeri feehicauhi faacuumiva sinagogajanofaño jɨɨbogooboro. Moocaani aivojɨ jɨɨbogo iimino jɨɨbogoco jɨɨbogooboro, bu fanoova guihuvaneri iguihuvamoco buheesuuboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jaanoco Jesuditɨ guubucuumo paryɨɨcɨno Siria jiinɨjeri. Jaamoro diibojaa sɨvaumo paryɨɨcɨno fanoova guihuvaneri iicaumehejeque fanoova aivoneri, bu emeimɨvatomehejeque, epilepsia guihuvari iicaumoco, bu idɨɨno isifañɨɨmehejeque icano. Jaamoco Jesu buheesuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jaaboco bucasihicaumo sihidɨ miyamɨnaa Galileaoto, bu Decapoli jiinɨje cuuminooto Jerusale cuumioteheje, bu Judea jiinɨjeoteheje, bu Jordan aamɨjɨjaagoteheje icamo. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jaanaa Jesu sihidɨ miyamɨnaa iicaumoco aatyɨmeuboro caamo ifabaɨ nijequevɨ ufuuboro casɨɨvutuubo. Jaabo cojɨvɨ ijɨɨbogomɨnaa igaivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jaadɨ Jesu tɨcovauhi diitoco ɨjɨɨbogoobo jillɨ nooboro: ");
INSERT INTO bmrNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Imicani icamo Moocaanico iimogomo ijeebɨɨno ɨɨdaasumaño. Jaamaño niquejefaño mihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Imicani icamo ɨɨdaasuno iicamo. Diitoco Moocaani jacusuji. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Imicani icamo, ijeebɨɨno ɨsɨɨcumo. Diito jiinɨjeque Moocaani aacɨguujeque gaayɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Imicani icamo iiminoco omoonɨjirunoco aivo iimogomo. Diito imo imo minifeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Imicani icamo sitaaco ɨɨdaasugomo. Diitoco Moocaani ɨdaasugueji. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Imicani icamo ijeebɨɨ ɨmɨhɨnivatɨmo. Diito Moocaanico atyɨmeji. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Imicani icamo sajeebɨɨ icaco omoonɨmo. Diitoco Moocaani: Taseeme, eneejimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Imicani icamo Moocaani iimogonoco omoonɨnohallɨtɨ diitoco ɨjɨɨheveme. Diitononeji niqueje aivojɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Imicani amɨɨhai tahallɨtɨ amɨɨhaico miyamɨnaa aivonoono onoomoro ɨdaasuno omoonɨmo, amɨɨhaihallɨvɨ sɨcamañehejeque ɨjɨɨbocasimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jaasumi sihidɨ imo imo mihica, toono jaada ufucu niquejefaño sihidɨ jeevano ijaadaco magaayɨcɨji. Mɨɨro tollɨro amɨɨhai ɨmegavɨ iicaumo Moocaani iimaamɨnaaco ɨdaasuno moonɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Amɨɨhai jiinɨje ɨmuhu. Jaano ɨmuhu ijeevetecuuruva, ¿jinejeri bu mɨhɨmuhunɨjirahi; jinejebaguiiha imicuujitɨruno? Jaanoco buhɨ magañɨɨnoco miyamɨnaa quicujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Amɨɨhai jiinɨje aachɨcɨnɨmɨnaa. Mɨɨro ifabaɨhallɨri iicacuumi toovono icatatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bu jaabadɨro cuugahuco mɨnɨɨmoro siinerihallɨvɨ mafabaacutatɨhi. Jillɨro ofoovomañovɨ caamo mificutahi paryɨ jaahe iicamoco ihachɨcɨnɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jaabadɨ amɨɨhai momoonɨ amɨɨhai foovo miyamɨnaa ɨmefeenevɨ foovono ihɨfuvusuqui. Jaamoro amɨɨhai imino momoonɨnoco aatyɨmemere, Moocaani niquejefaño iicaaboco iimequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Uco mehesɨcɨnɨdino, Moise tajɨɨbaco, bu Moocaani iimaamɨnaa jɨɨbogoco icano finɨsuvaabo, noomoro. Jillɨ toono unuuno imiyacafetequi saahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mɨɨro miyanotɨro amɨɨhaico neehi: Niqueje, jiinɨje icano iicanohachuta tajɨɨbahaame naavutusutɨ sanooba gañɨɨcafetejitɨhi, ufucu iicajino iicanohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jaamaño tajɨɨbatɨ sanoogayɨ ajashurunoco miyaano nootɨɨbo tollɨ omoonɨɨbo, bu jaaboro sitaaco tollɨro imitɨno imoonɨqui agaajasuuboco ufucu niquejefaño tollɨro jillɨ imɨhɨɨfoobotɨ noocafetejiibo. Jaanotɨ imityagooboro imino omoonɨɨboro sitaaco tollɨro imoonɨqui ijɨɨbogoobo ufucu niquejefaño aivo miyaabotɨ noocafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mɨɨro jino amɨɨhaico neehi: Amɨɨhai caatɨnɨmɨnaa, fariseomɨ icamo iicabadɨro mihicamoro Moocaani iimogonoco momoonɨtɨhachiijɨ bu niquejefaño mefeejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Amɨɨhai muguubuhicacuuhi, amɨɨhai eedeetemɨhaico jillɨ unuunoco: Gaicaaudino; cajaanɨhacho sitaaco agaicaaubo castigacafeteji, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mɨɨro jino uujoho amɨɨhaico neehi: Cajaatyohacho inahabojaago ɨsɨfiiratomo castigacafeteji. Cajaatyohacho inahaboco imitɨno onoomoco aivo isefa aivojɨto castigaji. Jaanotɨ bu inahaboco: Miyaaboɨvɨdɨ, onoomo infierno cɨɨjɨgai ñɨhicuguiino guiinovɨ minifeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jaanegui Moocaanico imequi ofooboro dinahaboma imitɨno idiicanoco edeesafotooboro, ");
INSERT INTO bmrNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","siino uduumiiboro itɨconɨ dinahabojaagovɨhi difoo. Jaaboro diibo dimijɨɨvotoobo sajeebɨɨ minifototo. Jaadɨ jari duhuumiibo Moocaanico diimoto. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Jaanotɨ bu cajaatyohacho dihallɨvɨ ɨjɨɨbogomoro ɨco isisɨsuqui asatyohachiijɨ, dinahaboma jɨɨhaivɨro dimijɨɨvo. Ɨco dugaacumɨnaafico acɨtotɨɨbo iicaqui. Jaabo diibo sisɨmɨnaaco ɨco acɨjiruubo. Jaamo ɨco cɨvojafaño jɨɨhacujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Miyanotɨro ɨco neehi: Tahɨgotɨ dihiinejitɨrahi niinojegayɨco adaadutɨnohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Amɨɨhairyo muguubuhicacuuhi sɨɨcɨje unuucuunoco: Sifigoma diicadino. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mɨɨro jino uujoho amɨɨhaico neehi: Cajaatyohacho gaigooco imogomoro emeecɨmo ijeebɨɨfañodɨ diigoma icacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jaanegui dimiyanaagohaallɨɨ ɨco imitɨfaño agañɨɨsuhachiijɨ, toollɨɨco dɨɨcɨɨbo tehesino gañɨɨ; imijirunaa difiitɨ samañogayɨro ɨɨtɨ agañɨɨcafotono. Jaanotɨ imijitɨruno faabohoro difi cɨɨjɨgaifaño agañɨɨcafotono. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jaanotɨ bu dihuse dimiyahuse ɨco imitɨfaño agañɨɨsuhachiijɨ quitɨcɨɨbo tehesino gañɨɨ; imijiruno samañogayɨro ɨɨtɨ agañɨɨcafotono. Jaanotɨ aivo imijitɨruno faabohoro cɨɨjɨgaifaño agañɨɨcafotono. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tollɨro bu sɨɨcɨje nuumo: Cajaanɨhacho mogaico ejeevesumo, diigoco ejeevesucuunohaameque ihacɨqui, noono. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jaarunofaño uujoho neehi: Cajaanɨhacho mogaico ajevahallɨtɨ icatɨno ejeevesuhachiijɨ diigoco ajeva imitɨco ɨcɨsuubo. Jaamaño sifi ejeevesucuugoco ɨɨcɨɨbo diigofañodɨ ajeva imitɨco ɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tollɨro bu muguubuhicacuuhi, sɨɨcɨjemɨnaaco unuunoco: Moocaani momofañodɨ unuucuunoco bañɨdino diibo ɨmefeenevɨ, noono. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jaarunaaca uujoho amɨɨhaico neehi: Moocaani momofañodɨ mohoovɨcɨdino, niquejefañodɨ oovɨcɨmoro meneedino, toono Moocaani aivojɨ icaga iicahɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tollɨro bu jiinɨjefañodɨ mohoovɨcɨdino, toojehallɨvɨ Moocaani itɨhaico ificuunɨcɨje iicamaño; bu Jerusale cuumifañodɨ mohoovɨcɨdino, tuucuumi Aivojɨɨbo Jesu cuumi iicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tollɨro bu oovɨcɨɨboro: Tañigaɨ seseeteji, needino. Tollɨ eneeneri sajebaco diinigaɨjeque seseetesujirahi, nacu bu cɨvutusujirahi jaanucuhu. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jillɨ tɨcovonoro: Jɨɨhɨ, Chahano, monoo. Jaanotɨ janaanɨcɨvɨ mejeenesucuuno, toono ɨjɨtɨ asaacuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Amɨɨhairyo muguubuhicacuuhi, sɨɨcɨje jillɨ unuunoco: Saafi aallɨɨco ifinicaruhachiijɨ, bu diibo aallɨɨco finicarujirumo. Tollɨro iigaico igañɨɨsuruva, bu diibo iigaico gañɨɨjirumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jaarunofaño uujoho amɨɨhaico neehi: Iimitɨɨboma mɨhɨɨbacasidino. Ɨvɨnaaca jillɨro saatoho amɨɨhai ɨmetɨ agabacuhachiijɨ, saanaagohɨmeque bu mahacɨ tollɨro bu igabacuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tollɨro bu cajaatyohacho ɨco ahaamɨmoro dicaamoojaco udumɨtɨɨcɨgohachiijɨ, tollɨro bu disacoco daacɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jaanotɨ bu tollɨro saatoho, fiisetaco minoocɨ kilometro tɨcovovɨ satyequi atajɨɨbahachiijɨ igueeneme kilometro tɨcovovɨ satyo. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jaanotɨ bu cajaatyohacho ɨco siinoco idillumoco daacɨ, bu duvuduuvedino sita ɨco: Uco tooneguiiha presta, noomoro idillumeditɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tollɨro bu sɨɨcɨje unuunoco muguubucuuhi: Digataavomɨnaafico gaijɨ. Jaaboro dimɨnaafico dɨɨhegue, unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jaarunofaño uujoho amɨɨhaico neehi: Amɨɨhai mɨnaafico magaijɨ, Moocaanima mihiimaa amɨɨhaico aivonoono onoomoro ɨdaasuno omoonɨmohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jaachiijɨ amɨɨhai Caani niquejefaño iicaabo seemetɨ mihicaji. Mɨɨro diibo inɨhɨbaco iinusuhicahi iimitɨmohallɨvɨ, bu iimimohallɨvɨ icano, bu tollɨro niijabaco galluhicaabo iimihiijɨmohallɨvɨ, bu iimitɨ iijɨmɨnaahallɨvɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jaanotɨ bu amɨɨhaico agaijɨmocoro magaijɨhachiijɨ, ¿mɨllɨ bu ijaadaco magaayɨcɨjirahi? Mɨɨro bu impuesto jaadusumɨnaa imitɨmo iicarumo tollɨro moonɨnɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jaabadɨro bu dinahabocoro idilluhachiijɨ, ¿mɨnoodɨ imico toono edeetavono? Mɨɨro bu tollɨro Moocaanico agaajatɨmeheje tollɨro moonɨfihi. ");
INSERT INTO bmrNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jaanegui amɨɨhaico neehi: Imimo mihica oono amɨɨhai Caani niquejefaño iicaabo aivo imiibo iicabadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Amɨɨhai imino momoonɨnoco miyamɨnaa ɨmega momoonɨdino; jillɨ amɨɨhaico imityaguequiguiiharo. Jaanotɨ tollɨ momoonɨhachiijɨ amɨɨhai Caani niquejefaño iicaabo ijaadaco amɨɨhaico acɨjitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jaaneguiiha siinotɨ ucuujɨvaachumoco siineri adaamususumi faacuumimɨnaacoro gaajasudino: Oono bañɨsumɨnaa sinagogajanofaño, callenefeenevɨ icano omoonɨfibadɨ. Jaamo jillɨ moonɨnɨcɨmo miyamɨnaa diitotɨ imino ihiimaaqui. Jaarunofaño uujoho miyanotɨro amɨɨhaico neehi: Jaamaño miyamɨnaa ɨco iimono toonorucu dijaada. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jaanotɨ naha ɨɨjoho ɨɨdaasumoco siinoco adaacɨhachiijɨ, toovono daacɨ, dimiyahuse omoonɨnoco dinanihuse gaajacɨtɨno iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jillɨ toovonoro deetavo, jaachiijɨ diicaani niquejefaño iicaabo toovono edeetavonoco aatyɨmeebere ɨco ijaadaco ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jaamo bu amɨɨhai Moocaanima mihiimaasumi bañɨsumɨnaafi iicabadɨ mihicadino. Diibo imeguefihi julleecɨnɨɨboro sinagogajanofaño ihiimaabo, bu callenejɨninovɨ jillɨ miyamɨnaa diiboco ihatyɨmequiguiiharo. Miyanotɨro amɨɨhaico neehi: Toono miyamɨnaafi obocɨgoneriro jaaducafutucuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jaanotɨ naha ɨɨjoho Moocaanima idiimaajisumi, dimecufaño ɨdɨcafotooboro cuhufono diguhugaco fabaacuubo diimaa Moocaanima ɨɨro idiicahɨgo. Jaachiijɨ diicaani niquejefaño iicaabo toovono omoonɨnoco aatyɨmeebere ɨco ijaadaco acɨjiibo. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jaabo Moocaanima idiimaasumi jillɨ mɨhɨɨfoneheje sɨcamañeheje samañocoro unuucumañocoro siino needino: Oono Moocaanico agaajatɨmo iicanɨcɨbadɨ: Fɨne jillɨ: sihidɨ ihiimaaneri Moocaani uco guubuhi, noomoro eesɨcɨnɨfimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jaamobadɨ mejeevadino. Mɨɨro Moocaani ɨmegavɨro amɨɨhai midillutɨnaacaro gaajacuuhi amɨɨhai mucuujɨvaachunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaaneguiiha amɨɨhai jillɨ noomoro Moocaanima mihiimaa: Moocaani niquejefaño idiicaabo, jaafa dimomo imino ijeevadɨ ficucafetehi. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jaafa dihaivojɨ saahi. Jaafa dijeebɨɨ onoobadɨ eetavocafetehi jiinɨjehallɨvɨ, oono niquejefaño iicabadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mɨɨhaico daacɨ machutaatɨ fafucuvaacɨvɨro. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jaaboro mɨɨhaico mohimitɨco buusu, oono bu mɨɨhai, mɨɨhaico imitɨno omoonɨmoco toonoco mihimibachubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jaaboro mɨɨhaico ɨnɨsunofaño gañɨɨsudino. Mɨɨhaico imitɨ ɨjɨ usetɨ taajasu. Fɨne. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mɨɨro amɨɨhaico sita imitɨno omoonɨmoma toonoco mihimibachuhachiijɨ, bu tollɨro amɨɨhai Caani niquejefaño iicaabo amɨɨhai imitɨco imibachuji. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jaanotɨ amɨɨhai sitaama mihimibachucasitɨhachiijɨ, bu amɨɨhai Caani niquejefaño iicaabo amɨɨhai imitɨco imibachujitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jaabadɨro bu amɨɨhai safucuco mahaigasumi amɨɨhai ɨmeque ɨdaasuno miminiiyudino, oono bañɨsumɨnaa omoonɨnɨcɨbadɨ. Diito tollɨ moonɨfihi amachutɨnoco miyamɨnaa ihatyɨmequi. Jaanegui amɨɨhaico neehi: Toono ijaadaco mɨhɨcɨcuuhi miyamɨnaa obocɨgoneriro. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jaanotɨ ɨɨjoho machutɨɨbo adaigasumi dihɨmeque nitɨɨbo imino feedamaje, ");
INSERT INTO bmrNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","miyamɨnaa machutɨɨbo adaigaiñoco gaajacɨtɨmo iicaqui, ɨdɨɨboro niquejefaño iicaabo Moocaani ijeevadɨ samɨsi diiboma mihicaabo igaajaqui. Jaabo ɨco toono jaadaco acɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jiijehallɨvɨ sihidɨ busumijeeneque mititibaanɨdino, deeɨra ifinɨsufijehallɨvɨ, bu tollɨro paryɨ busumijeene unucufijehallɨvɨ, bu tollɨro nanivamɨnaa ananinɨcɨnehejehallɨvɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ɨvɨ ɨdɨhɨgoro niquejefaño sihidɨ busumijeque mititibaanɨ, deeɨra ifinɨsutɨhɨgo, fanoova unucutatɨhɨgo, bu nanivamɨnaa ananifitɨhɨgo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mɨɨro amɨɨhai busumijeene iicahɨgovɨ, bu amɨɨhai jeebɨɨ icajirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Mɨɨro saafi ihaallɨɨ iimitɨɨbo imino icajitɨrahi. Jaabadɨro saafi ijeebɨɨ iimitɨɨbo imihusetɨhi. Jaabo iimitɨnoguiino icaji. Jaanotɨ Moocaani ijeebɨɨco iimibachuhachiijɨ imihusetejiibo. Moocaani iimogobadɨ icacujiibo. Jaanotɨ mɨɨno imitɨco iminobadɨ mehesɨcɨnɨhachiijɨ, janaanɨcɨvɨ aivo imitɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mɨɨhaiñooba miimɨsiicɨ ihaivojɨtɨsima icajitɨrahi. Mɨɨro saafiico ɨjɨɨhegueebere saafiicoro gaijɨjiruubo. Jaabadɨro bu sano nɨhɨbamɨco, Moocaanico icano magaijɨjitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Amɨɨhaico neehi: Nɨjɨ nɨjɨ amɨɨhai jeebɨɨnoco momoonɨdino toono sefari mihicaqui, mamachujirunehejeri, bu mahadujirunehejeri icano, bu tollɨro mɨjɨɨcɨnɨjino gaachehuri icano. ¿Nacu mofi gaachehu janaanɨcɨvɨ jaaducafototɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Eneecau oono joomɨ caamodɨ agahafomoco mɨhɨɨfɨnɨcɨ, basutɨrumo, bu abasuno noovaco ɨcɨtɨrumo icano. Jaarumoco amɨɨhai Caani niquejefaño iicaabo diitoco machuco acɨfihi. Jaamo diito joomɨ janaanɨcɨvɨ amɨɨhai majaaducafetehi. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Nacu amɨɨhaitɨ cajaanɨ siino janaanɨcɨ tɨcovovɨ macaamevetejirahi toono fanoovari nɨjɨ nɨjɨ mihicahicanotɨ? ");
INSERT INTO bmrNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Jaamo collɨhi amɨɨhai gaachehuri nɨjɨ nɨjɨ mihicahicahi? Eneecau oono deecanoco mɨhɨɨfɨnɨcɨ, dudɨcamaaitɨruno gaachehunoco eetavotɨruno icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jaarunaa amɨɨhaico neehi: Salomon aivo sihidɨ jeevano iminoonoma icauruubo toono deecanobadɨ jeevautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jaabo Moocaani, buhɨcaga toono ñaavahu jaachiijɨ bajɨfaño icano, cɨvohogo iquitɨcafotonoro cɨɨjɨgaifaño jɨgasucafotono icarunoco Moocaani imino gaachehuco mɨjɨɨhacubadɨ moonɨhi. Jaanegui amɨɨhaico gaachehunoco jɨcujiibo, ajashucani amɨɨhai miyaavogo mihicano miyamɨnaaco. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jaanegui nɨjɨ nɨjɨ mihicadino jillɨ noomoro: ¿Jinejeque jana mamachuji? ¿Jinejeque jana mahaduji? ¿Jinejeque jana mɨjɨcafeteji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mɨɨro jihomonehejequere imiyaavogotɨmo guiinehicahi. Jaanotɨ naha amɨɨhai, amɨɨhai Caani niquejefaño iicaaboma mihicahi. Jaabo gaajacuuhi amɨɨhai paryɨ tonehejeri mucuujɨvaachunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jaaneguiiha Moocaani aivojɨjaagovɨro dijeebɨɨco ficu, jaaboro diibo iimogonocoro deetavo icano. Jaadɨ jari paryɨ tonehejeque bu gaayɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jaaneguiiha cɨvohogo iicajinehejeri amɨɨhai jeebɨɨco nɨjɨ nɨjɨ momoonɨdino. Toono amɨɨhaitɨ cɨvohogoro finɨjitɨhi. Fafucuvaacɨvɨro ɨɨma ajashutɨno icahicacuuno toono nɨjɨ nɨjɨ idiicano. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sitaaco iimitɨ meneedino, jaachiijɨ amɨɨhaico bu Moocaani amɨɨhai imitɨ needino. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Toono amɨɨhai sitaaco meneehicabadɨro bu amɨɨhaico moonɨjiibo, bu oono amɨɨhai sitaaco mohoovɨcɨhicaneriro amɨɨhaico oovɨcɨjiibo. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jaabo mɨllɨ bu dinahabo aallɨɨfaño iicano beevagayɨco daatyɨmejirahi, dihaallɨɨfaño bu iicatuucɨ cutuucɨco atyɨmetɨɨboro? ");
INSERT INTO bmrNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jaabo ɨɨjoho dihaallɨɨfaño cutuucɨma idiicaabo, ¿mɨllɨ bu dinahaboco neejirahi: Juugavɨ disaa oono dihaallɨɨfaño iicano beevagayɨco ɨco ɨcɨqui, nooboro? ");
INSERT INTO bmrNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Bañɨsumɨnaafi idiicaabo! Itɨconɨ toono dihaallɨɨfaño iicatuucɨco dɨɨcɨ. Jaadɨ jari imino adaatyɨmeebere dinahabo aallɨɨfaño iicano beevagayɨco dɨɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Iiminoco imiyaavogotɨmo jɨcubadɨ iicamoco mahacɨdino, amɨɨhaijaagovɨ emecafotomoro amɨɨhaico dedaahenɨdimo. Bu amɨɨhai iimogonoco diito iimitɨmo faafaimɨbadɨ iicamoco mahacɨdino, toono iiminoco quicudimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Midillu amɨɨhaico Moocaani ihacɨqui. Miguiino, jaamo mahatyɨmehi. Tollɨro bu guhugatɨ mocoova amɨɨhaidi ifaayɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mɨɨro idilluubo gaayɨcɨfihi, bu iguiinoobo atyɨmefihi; bu guhugatɨ ocoovaaboco faayɨcɨfimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Nacu icamo saatohoba amɨɨhaitɨ amɨɨhai seemeneque maahuco idillusumi guiisibaco mahacɨjirumo? ");
INSERT INTO bmrNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Nacu bu taavaaboco idillusumi jiinimocoro mahacɨjirumo? ");
INSERT INTO bmrNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mɨɨro amɨɨhai mihimifitɨrumo iiminocoro amɨɨhai seemeque mahacɨnoco magaajahi. ¡Jaanegui imi amɨɨhai Caani niquejefaño iicaabo iiminoco acɨji midillumoco! ");
INSERT INTO bmrNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jaaneguiiha amɨɨhai sitaama imino mihica oono amɨɨhaima diito imino iicanoco mihimogobadɨ; Mɨɨro tollɨ Moise tajɨɨba neehi, bu Moocaani iimaamɨnaa aamene neehi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ijene jɨɨhai aamɨjɨriro mɨjɨcamaaje. Jaanotɨ oono guijevefaño asatyono jɨɨhai aamɨjɨ guiraahi, jɨɨhai guiraahi icano. Jaano carecunoono jahɨgovɨro sihidɨ miyamɨnaa feehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jaanotɨ naha fiivojaa asatyono jɨɨhai aamɨjɨ, bu fiivojaa asatyono jɨɨhai icano ijene, ajashuno icano. Jaamaño mɨɨdɨmoro atyɨmehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Amɨɨhai ifiico magaihuɨnɨ oono abañɨfifimo uujoho Moocaanijaagodɨ iimaahi eneehicamotɨ. Diito amɨɨhaijaago saaji ovejamɨbadɨ iminifotomoro. Jaarumo fañooto jɨcumɨ sɨfiirafiimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jaamoco magaajacɨ omoonɨnehejetɨ; mɨɨro mɨɨjoho baacuco jaanotɨ ɨcɨtatɨhi, bu añaajeque jarɨɨmohotɨ ɨcɨtatɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mɨɨro paryɨ iimino ɨmohono iiminocoro noovafihi. Jaabadɨro bu iimitɨno ɨmohono iimitɨnocoro noovafihi. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Iimiho ɨmoho iimitɨnoco noovajitɨrahi, bu iimitɨho iiminoco noovajitɨrahi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jaano paryɨɨcɨno iiminoco onoovatɨno ɨmohonoco mihillumoro cɨɨjɨgaifaño mɨjɨgasutahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jaaneguiiha diitoco magaajacɨ omoonɨnotɨro. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Famooro oono uco: Aivojɨɨbo, Aivojɨɨbo, eneehicamo niquejefaño feejitɨhi. Ɨdɨɨmoro Taacaani niquejefaño iicaabo iimogonoco omoonɨhicamo feeji. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tufucu agasedɨ ajashutɨmo uco neeji: Aivojɨɨbo, Aivojɨɨbo, mɨɨhai dimemeri mihiimaahicahi, dimomofañodɨ mɨɨhai iimitɨno ɨjɨmɨco buhɨ magañɨɨhicahi, bu dimomofañodɨ mɨɨhai guiraano sihidɨ ejeevanehejeque meheetavehicahi icano, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jaarumoco uujoho neeji: Amɨɨhaico uujoho gaajatɨhi. Uutɨ buhɨgovɨ miminifoto amɨɨhai iimitɨnoco momoonɨhicamo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jaamaño uujoho onoonoco uguubuuboro uujoho onoobadɨ omoonɨɨbo, oono saafi agaajaabo guiisibanohallɨvɨ iijaco eheetavuubobadɨ jeevahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jaajahallɨvɨ aiguuruno, sihidɨ teehino machituurahi, bu sefano guibuhuba toojahallɨvɨ saaurahi icano. Jaarunofaño tooja acutuutɨhi, tano cuhufono guiisibanohallɨvɨ cuhufono tano inicucɨnɨumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jaanotɨ uco guubucuuruubo uujoho onoonoco omoonɨtɨɨbo agaajatɨɨbobadɨ jiinɨgaibaahohallɨvɨ iijaco eheetavuubobadɨ jeevahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Toojahallɨvɨ aiguuno, teehino machituuhi, sefano quijeba saauhi icano. Jaaneri tooja sano acutuuhi. ¡Jaano sihɨdaasu! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu ɨjɨɨbuguunoco iimivuudɨ sihidɨ miyamɨnaa jabafiitehicauhi, ");
INSERT INTO bmrNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","fariseomɨbadɨ icatɨɨbo, aivojɨɨbo mityama iicaabo iicanɨcɨbadɨ ɨjɨɨbeguehicauneri. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jaabo Jesu tobaɨ nijequetɨ iniituuboco sihidɨ miyamɨnaa bucasiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jaanaaca diibojaago saaubo saafi foojohoma iicaubo. Jaaboro Jesuguiino ememuɨɨvuuboro diiboco nuuhi: Aivojɨɨbo idiimogohachiijɨ uco dimibachu taguihuvatɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jaanegui Jesu diiboco ihuseri dudɨɨcɨuhi: Imeguehi, buheetecu, nooboro. Jaasumiro diibo toono ifoojohotɨ buheetecuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jaaboro Jesu diiboco nuuhi: Jeedɨcahi mɨɨhaiñoobaco dɨɨbeguedino, jillɨro foobo sacerdoteque difiico dɨhɨfusuto. Jaaboro asigayɨtɨ satyoobo Moocaanico deecɨvoto Moise atajɨɨbaubadɨ, toonotɨ famooro igaajaqui toono diguihuvatɨ idihimitucuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jaabo Jesu Capernau cuumifaño jɨcafutuubaaca romanomɨ amocasimɨnaa aivojɨɨbo diibojaago asaauboro diiboco noovauhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aivojɨɨbo, tacojɨmɨnaafi jaahe ɨdaasuno icahi aiveneri isifañɨɨbo acahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jaanegui Jesu diiboco nuuhi: Uujoho ofooboro buheesuteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jaarunaa ihaivojɨɨbo iimusuuhi: Aivojɨɨbo, sihidɨ jeevahi jaabo iijajaagou efeejiruno. Jillɨro tajɨɨba dihiijɨco jaaneri tacojɨmɨnaafi ibuheetequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mɨɨro bu uujoho icaruubo aivojɨto iijɨguiino icahi, bu jaaruubo amocasimɨnaa aivojɨɨbotɨ icahi. Jaamotɨ saafiico: Difo, unuusumi foonɨcɨɨbo. Jaanotɨ bu sifiico: Disaa, unuusumi bu saanɨcɨɨbo. Tollɨro bu tacojɨmɨnaafico: Toonoco deetavo, unuusumi bu eetavonɨcɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jillɨ diibo unuunoco, Jesu uguubuuboro sihidɨ jabafiituuhi. Jaaboro diibo dojɨcutɨ ufuumoco nuubo: Miyanotɨro amɨɨhaico neehi. Paryɨ Israel cuumimɨnaafeenevɨ aivo jaanɨ miyaavogobadɨ iicamoco atyɨmetɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Amɨɨhaico neehi, ajashutɨmo saaji nijequejaagotɨ, aamɨjɨjaagotɨ icano. Jaamoro niqueje aivojɨfaño Abraham, Isaac, Jacob, icamoma acasɨɨvomoro machujimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jaanotɨnaa niqueje aivojɨfaño efeejirumo jillɨro jahisi ɨcɨvohɨgovɨro gañɨɨcafeteji tahɨgo ataacasimoro igaiñooco oojɨsujihɨgovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jaaboro Jesu ihaivojɨɨboco nuuhi: Fuucu diijajaagovɨ jaafa dicojɨmɨnaafi buheecuji ɨɨjoho imiyaavogobadɨ, nooboro. Jaasumiro tollɨ diibo unuuno tɨcovovɨ diibo buheetecuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jaadɨ Jesu Pedro iijajaago ufuubo atyɨmeuhi Pedro baabo sinafeteri iguihuvaugo acaugoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jaagoco ihusetɨ ududɨɨcɨuneriro iguihuva diigoco buuhi. Jaasumiro diigo agañiivuugoro tɨcovaugo diitoco ejeecɨvuugo. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jaanaa mihiijɨcuudɨ diibojaa sɨvaumo sihidɨ iimitɨno meimɨ ijeebɨɨfaño iicaumehejeque. Jaamoco safooro unuuneriro paryɨ famoocoro buhɨ gavaracuubo, bu tollɨro iguihuvaumoco paryɨ buheesuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jaano jillɨ icauno Moocaani iimaamɨnaafi Isaia unuuno imiyacafetequi. Jillɨ unuuno: Diibo ɨcɨhi moniinovahañoco, bu moguihuvahañoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jaanaa Jesu atyɨmeuhi diibohallɨdɨ sihidɨ miyamɨnaa emecuvuunoco. Jaanegui tajɨɨbaubo onogoomuuaivɨ ifatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jaanaa Moise tajɨɨba gaajamɨnaafi Jesujaago asaauboro diiboco noovauhi: Jɨɨbogomɨnaafi, ɨɨma uujoho feejirahi ɨɨjoho ofoohɨgovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jaanegui Jesu diiboco nuuhi: Bajɨhimɨ ihojɨnoma icahi, bu joomɨ ihiicunoma icahi icano. Jaanotɨ uujoho Miyamɨnaafibadɨ Ifiivuubo iinigaɨco conoovɨ ɨsɨucarujirumaño chahahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jaadɨ bu saafi ijɨɨbogomɨnaaototɨ diiboco nuuhi: Aivojɨɨbo, jaafahiica itɨconɨ guihirubi iguijevedɨhivɨ ɨcɨɨdɨhiica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jaanegui Jesu diiboco nuuhi: Ɨɨjoho tadyojɨcutɨ disaa. Jaanotɨ jaafa tahɨ diito ifinɨjitɨno fiivoma iicatɨmo iguijevemeque cɨɨji, nuuruubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jaaboro Jesu imeenegafaño jɨcafutuuhi ijɨɨbogomɨnaama. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jaanaaca sefano guibuhuba saauhi imuuaihallɨvɨ. Jaano ityuucari imeenega niituurahi. Jaanaa Jesu imeenegafaño cɨgahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jaanegui ijɨɨbogomɨnaa diiboco aaicusuumoro nuuhi: ¡Aivojɨɨbo, mɨɨhaico taajasu! Jino miniitucuuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jaanegui iimusuubo: ¿Collɨhi mihiguetehi? ¡Ajashucani amɨɨhai miyaavogo! nooboro. Jaadɨ agañiivuuboro iguibuhubaco ɨɨbaubo, bu imuuaico ɨɨbaubo icano. Jaasumiro sano paryɨ sɨɨcutuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jaaneri diito sihidɨ ajabafiituumoro nuumo: ¿Coyomo miyamɨnaafi fɨne jaanɨ jino guibuhuba, bu muuai icanomaryo diiboco imityagoobo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jaabo onogoomuuaivɨ Gadara jiinɨjevɨ ɨɨfutuubaaca miimɨsiicɨ gaifiimɨsi cɨɨhojɨnojaa iicahicauhɨgotɨ diibojaagovɨ saauhi, iimitɨno ɨjɨma ijeebɨɨfaño iicaumɨsi. Jaamɨsi sihidɨ jeevano sɨfiiramɨsi. Jaamaño mɨɨhaiñooba toojɨri feehicautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jaamɨsi asaaumɨsiro tɨcovauhi ocoovadiivomɨsi: ¿Collɨhi mojaago saahi, ɨɨjoho Jesu Moocaani achi idiicaabo? ¿Jaabo juu saahi mɨɨhaico ɨmegavɨro ɨdaasunisiicɨ gaifiimɨsi cɨɨhojɨnojaa iicahicauhɨgotɨ diibojaagovɨ saauhi, iimitɨno ɨjɨma ijeeo moonɨqui? noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jaamañotɨ fiitɨno icaumo sihidɨ faafaimɨ machumoro ɨɨguumo; ");
INSERT INTO bmrNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jaamoro diito iimitɨno ɨjɨmɨ Jesuco dilluuhi: Mɨɨhaico buhɨgovɨ agañɨɨjihachiijɨ, jaatyo faafaimɨfañoro mɨɨhaico gallu, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jaanegui Jesu: Jii tahɨ diitofaño mofoo, nooboro iimusuuhi. Jaanegui diito iimitɨno ɨjɨmɨ diitɨsifañotɨ ihiinuumoro ifaafaimɨfaño fuuhi. Jaasumiro diito paryɨ ifaafaimɨ ifagajɨtɨ muuaifaño aaifuumoro paryɨ macanɨuhi imuuaifaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jaamo diito ifaafaimɨ toomomɨnaa diito tollɨ iicaunoco aatyɨmeumoro jinoomoro cuumijaago ufuumoro jɨɨbugutuuhi tollɨ ifaafaimɨ iicaunoco, bu diitɨsi ɨjɨmɨma iicaumɨsi tollɨ iicaunoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jaanegui tuucuumioto paryɨ Jesujaagovɨ asaaumoro diiboco galluumo, ijiinɨjetɨ buhɨgovɨ ifeequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jaanegui Jesu meenegafaño ɨjɨcafutuuboro ufuubo ɨfutuuhi onogoomuuaivɨ iicacuumi iicauhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jahɨ diibojaago sɨvaumo saafiico idɨɨno isifañɨɨubo icɨgaiijefaño sɨucɨnɨuboco. Jaamo miyaavogoco Jesu aatyɨmeuboro iguihuvauboco nuuhi: Guihi, quehecuto, dihimitɨ ɨco imibachucafutucuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jaanoco tajɨɨba caatɨnɨmɨnaatɨ saatoho uguubuumoro ijeebɨɨfañodɨ nuuhi: ¿Mɨllɨ jaanɨ Moocaanico imitɨno moonɨhi ihiimaari? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jaanoco Jesu agaajacɨuboro nuuhi: ¿Collɨhiica imitɨcani mehesamaaihi? ");
INSERT INTO bmrNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tɨhɨɨcani jana amɨɨhaidi, dihimitɨ imibachucafutucuuhi onoono, gañiivoobo dɨɨgo onoono? ");
INSERT INTO bmrNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Eneecau bu amɨɨhaico ɨɨfusuqui uujoho Miyamɨnaafibadɨ Ifiivuubo jiinɨjehallɨvɨ imitɨ imibachu mityama iicanoco, nooboro, idɨɨno isifañɨɨuboco nuubo: Gañiivoobo dicɨgaiijeque dɨɨcɨɨbo diijajaago fuucu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jaasumiro idɨɨno isifañɨɨubo icɨgaiijeque ɨɨcɨuboro iijajaago fuucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jaanoco miyamɨnaa aatyɨmeumoro sihidɨ iguiumo. Jaamoro Moocaanico imuumo miyamɨnaafico tomityaco aacɨunohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jaamañotɨ Jesu ufuubo, atyɨmeuhi Mateo onooboco, impuestoco ajaadusuhicaumañeri gɨcɨnɨuboco. Jaaboro diiboco nuubo: Tadyojɨcutɨ disaa, nooboro. Jaanegui Mateo agañiivuuboro diibo dojɨcutɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jaanaaca bu Jesu jaahe amachuubo gɨcɨnɨubo cojɨri, bu sihidɨ saatoho impuesto jaadusumɨnaa, bu saatoho imitɨmɨnaa icamo asaaumoro Jesu ijɨɨbogomɨnaama icaubo cojɨvɨ casɨɨcamaaivauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jaanoco fariseomɨ aatyɨmeumoro ijɨɨbogomɨnaaco dilluuhi: ¿Mɨllɨ jaabo oono amɨɨhai jɨɨbogomɨnaafi machuhi impuesto jaadusumɨnaama, bu saatoho imitɨmɨnaama icano? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jaanoco Jesu uguubuuboro nuuhi: Iimimo iguihuvatɨmo, taabumɨnaafico imogotatɨhi, iguihuvamoro taabumɨnaafico imeguefihi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Eneecau mofoomoro jino Caatɨnɨhaamefaño jillɨ onoonoco magaajato: Uujoho imeguehi sitaaco mɨhɨdaasugonoco. Jaanotɨ imogotɨhi jeecɨvo asimɨco magaicaaumoro mejeecɨvonoco. Mɨɨro: Uujoho imino icahi, onoomoco cuuhuvaqui saatɨhi. Iimitɨmeguiiha saahi iimitɨ ifiico ijeevesuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jaanaaca Jua Nitɨmɨnaafi jɨɨbogomɨnaa Jesujaago asaaumoro diiboco dilluvauhi: ¿Jana mɨllɨtɨ mɨɨhai, bu fariseomɨ jɨɨbogomɨnaa icamo machutɨmo mahaiganɨcɨnaaca dita aigahicatɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jaanegui Jesu diitoco oovɨcɨuboro iimusuuhi: ¿Nacuuhu taabava jɨɨbaimojaago ucuuhuvamo ɨdaasuri machutɨmo icanɨcɨjirahi; diitofeeneri aijɨ iicanohachuta? Jaanotɨ naha icajinehiica uujoho udumɨtɨɨcɨcafotodɨhivɨ ɨdaasuno iicaneri aigajimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mɨɨro mɨɨhaiñooba bobaryuri eedeechehu gaachehuco maahunɨtatɨhi bobaryu fañovɨro iguiyacafeteneri eedeene agallivejiruneguiiha. Jaaneri toopaaje janaanɨcɨvɨro guiraatejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jaabadɨro bu mɨɨjoho bofaihu aivofaihuco eedeejutafaño ficutatɨhi. Jaanotɨ tollɨ momoonɨruva tujutaje jerucamaaijirahi. Jaaneri tujutaje, bu ihaivofaihu icano gañɨɨcafetejirahi. Jaanegui bofaihuco bujutafaño mificutahi. Jaaneri fanoocɨro icafihi, nooboro. Jillɨ Jesu nuuhi eedeejɨɨbogonoco mejeevesumoro bohono jɨɨbogoco meheetavequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jillɨ Jesu nuunaaca judiomɨ aivojɨɨbo agaseuboro diibo ɨmegavɨ ajavuvuuboro diiboco nuuhi: Aicɨgai jaachiijɨro guijevecuuhi. Jaarunaaca ɨɨjoho ofooboro diigohallɨvɨ dihuseque ificuuneri siino dojɨcuvɨro buheetejirugo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jaanegui Jesu agañiivuuboro diiboma fuubo ijɨɨbogomɨnaama. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jaanaa saafigo gaigo fahuseecɨ motɨhaitɨ mificabacɨ ɨdɨɨnohachuta tɨɨjeheri iicaugo ibujɨnaagotɨ asaaugoro Jesu gaachehujɨnibaco dudɨɨcɨvauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jillɨ igaachehujɨnibaco ududɨɨcɨneriro: Buheeji, noogoro eesamaaihicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jaarunaaca Jesu acajebeveuboro diigoco aatyɨmeuboro nuuhi: Quehecuto gaha; imiyaavogomaño buheesucafetehi, nooboro. Jaasumiro diigo buheetecuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jaanaa Jesu ihaivojɨɨbo iijafaño ɨɨfutuubo atyɨmeuhi masimɨnaaco diigoco icɨɨqui iigaiyɨɨcɨumoco, bu miyamɨnaa ataacasimo ocoovadiicɨnɨnoco icano aatyɨmeuboro ");
INSERT INTO bmrNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","diitoco nuuhi: Jahisivɨ mihiino mɨɨro guijevetɨgo bagocaja jillɨro cɨgago, nooboro. Jaaneri diibeditɨ miyamɨnaa jejebacasiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jaarunaa Jesu diitoco jahisivɨ ihiinusuuboro fañoojavɨ ufuuboro diigoco ihusetɨ agaayɨcɨuboro gañiiyɨcɨuhi. Jaasumiro diigo gañiivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jaano paryɨ toojiinɨjeri gaajacafutuuhi diibo tollɨ omoonɨuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jaabo toojatɨ ihiinuuboro Jesu ufuuboco miimɨsiicɨ aatyɨmeutɨmɨsi bucasiuhi coovadiicɨnɨmɨsiro: Mɨsico dɨdaasugo David Iyaachi, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jaanaa Jesu jaahevɨ jɨcafutuubojaago fuumɨsi. Jaamɨsico dilluubo: ¿Nacuhu amɨɨsi mimiyaaveguehi toonoco omoonɨjirunoco? nooboro. Jaanegui diitɨsi: Jɨɨhɨ Aivojɨɨbo, noomɨsiro iimusuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jaanegui Jesu diitɨsi aallɨɨnoco ududɨɨcɨuboro nuuhi: Jaafa amɨɨsi miyaavogobadɨ icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jaasumiro diitɨsico ihaallɨɨno iminutuuhi. Jaaboro Jesu diitɨsico faguuhi: Jeedɨcahi mɨɨhaiñoobaco muguubusudino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jaarunofaño ufuumɨsiro jɨɨbuguumɨsi paryɨ toojiinɨjeri Jesu omoonɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jaamo iinuumaacaro saatoho sɨvauhi Jesujaago ihiimaatɨɨbo iimitɨno ɨjɨma iicauboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jaaboco Jesu buhɨ agañɨɨudɨ jari diibo ihiimaahicautɨɨbo jari iimaauhi. Jaaneri miyamɨnaa sihidɨ ajabafiituumoro nuuhi: Aivo Israelfaño atyɨmeratatɨno jillɨ iicano, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jaarunofaño fariseomɨ neehicauhi: Jaanɨ iimitɨno ɨjɨmɨco buhɨ gañɨɨhicahi, diito aivojɨɨbo mityariro, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jaanaa Jesu fahɨgovadɨ feehicauhi faacuumivariro, bu imɨɨdɨ cuumineri icano ɨgooboro sinagogajanofaño jɨɨbogooboro. Moocaani aivojɨ iijɨco jɨɨbogooboro, bu fanoova guihuvanoco buheesuuboro, bu fanoohaivoco buheesuuboro icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jaabo miyamɨnaaco aatyɨmeuboro diitoco ɨdaasuguubo, ɨdaasuno iicaunotɨ, niinovano iicaunotɨ, bu oono ovejamɨ itoomomɨnaafima achahamo icanɨcɨbadɨ iicaumaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jaaboro itoomomɨnaaco nuubo: Miyanotɨro, imiyaavogotɨmo ajashutɨhi. Jaarunofaño idudɨcamaajemɨnaa mɨɨdɨhi diitoco ɨɨcɨjirumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jaaneguiiha ihabajaabo Moocaanico midillu dudɨcamaajemɨnaatɨ igalluuqui ihɨcɨvaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jaaboro Jesu fahuseecɨ motɨhaitɨ miimɨsiicɨ icamo ijɨɨbogomɨnaaco ucuuhuvauboro imityaco acɨubo, iimitɨno ɨjɨmɨco buhɨ igañɨɨhicaqui, bu fanoova guihuvanoco, bu fanoo aivonoco icano ibuusuhicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jaamo ijɨɨbogomɨnaa momono jino. Itɨconɨ Simon icaruuboco Pedrotɨ omomonɨubo. Jaabo nahabo Andre, bu Jacoobo onoobo, inahabo Jua icano Zebedeo seemenetɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolome, Tomas, Mateo impuesto jaadusumɨnaafi, bu Jacoobo onoobo Alfeo achi, bu Lebeo icaruuboco Tadeotɨ omomonɨubo, ");
INSERT INTO bmrNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","bu Simon onoobo cananistamɨoobo, bu Juda Iscariote onoobo Jesuco aacɨujiibo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesu iminɨsumɨnaaco jillɨ nooboro galluuhi: Judiomɨ iicatɨmo jiinɨjejaago mefeedino, bu tollɨro samaritanomɨ cuumico majaahevedino. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel cuumi miyamɨnaa ovejamɨbadɨ ɨmɨtaumojaagovɨro mofoo. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jahɨgo jɨɨbogomoro mofoo; Moocaani aivojɨ fiitɨvucuuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Iguihuvamoco buheesumoro mofoo, bu uchuumucuumoco buheetesumoro mofoo, foojohoma iicamoco imibachumoro mofoo, bu iimitɨno ɨjɨmɨco buhɨ gañɨɨmoro mofoo. Amɨɨhai jillɨ tɨcovono jino mityaco magaayɨcɨhi; jaaneri momoonɨnoco majaadusudino. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jaamo oroco, bu nɨhɨbamɨco, bu cobrebaco icano masatyedino, ");
INSERT INTO bmrNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","bu lleegucubaco jɨɨhaiguiiha masatyedino icano ɨvɨ ɨdɨɨjacoro masatyo sajaacoro caamoojaco. Bu tɨhaipaajebaco, queseibaco icano masatyedino. Mɨɨro dudɨcamaajemɨnaafi imachutaama icafihi. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jaamo amɨɨhai cuumivɨ mɨhɨfutusumi, bu allɨo cuumivɨ mɨhɨfutusumi icano, miguiino iimihusene miyamɨnaafico. Jaabo iijafañoro mihica tuucuumitɨ mofootɨnohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jaajafaño mɨjɨcafotomoro sajeebɨɨ icaco imogomoro midillu. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jaano toojamɨnaadi iimihachiijɨ diitedi mejeevesu toono sajeebɨɨ ica dilluco. Jaanotɨ iimogotɨhachiijɨ toono sajeebɨɨ ica dilluco dojɨcuvɨro mɨhɨcɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jaanotɨ bu amɨɨhaico agaayɨcɨgotɨhachiijɨ, bu uguubugotɨhachiijɨ icano, toojatɨ mihiinomoro tuucuumitɨ mihiinomoro amɨɨhai tɨhaiñoguiino jiinɨco diitojaagovɨ matatacu ɨɨbabadɨ iicano. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Miyanotɨro amɨɨhaico neehi. Jaadufucu iicadɨ aivo tuucuumi sihidɨ jeevano aamɨcafeteji Sodoma, Gomorra icaucuumije miyamɨnaa janaanɨcɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Memeecɨ, uujoho jino amɨɨhaico galluuhi oono ovejamɨ jɨcumɨfeeneri iicanɨcɨbadɨ. Jaanegui mihimibaicɨnɨcu oono jiinimo iicanɨcɨbadɨ. Jaarumo imimoro mihica nimɨihumɨ iicanɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Esɨcɨnɨno mihica, amɨɨhaico miyamɨnaa acɨji aivojɨto usenefaño. Jaamoro amɨɨhaico aamɨjimo sinagogajanofañovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jaamoro amɨɨhaico satyejimo tajɨɨbamɨnaa ɨmegavɨ, bu imiya aivojɨto ɨmegavɨ icano tahallɨtɨ. Jaamo uuditɨ mihiimaahi diito judiomɨ ɨmefeenevɨ, bu judiomɨ iicatɨmo ɨmefeenevɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jaamo amɨɨhaico aivojɨto ɨmegavɨ aacɨsumi: ¿Mɨllɨ neeji? noomoro gaihuɨba mihicadino. Mihiimaacuujino iicacuujidɨ Moocaani amɨɨhai jeebɨɨfaño mihiimaajinoco ficuji. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jaamo amɨɨhai mihiimaajino icatɨno jillɨ amɨɨhai jeebɨɨfañotɨ amɨɨhai Caani niquejefaño iicaabo Gaija iimaaji, nooboro. Jaadɨ nuubo mohɨmegavɨ iicajinehejeditɨ ");
INSERT INTO bmrNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Miyamɨnaa inahabomɨcoro moonɨsuji, bu caanimɨ iseemequere moonɨsuji. Jaabadɨro bu iseeme caanimɨjaagovɨ ɨsɨfiiratomoro chuumusujimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jaasumi faaboho miyamɨnaafi amɨɨhaico jɨɨheveji tahallɨtɨ: Jaaruno tollɨ icarunofaño ejenaauboro allɨbavɨ afatyotoobo taajaji. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jaamo saacuumifaño amɨɨhaico ubucasisumi siicuumijaagovɨ magaa. Jino miyanotɨro amɨɨhaico neehi: Uujoho Miyamɨnaafibadɨ Ifiivuubo saaji amɨɨhai paryɨ Israel jiinɨje cuumineri mofoomo tuucuumijeque mihimivotɨnaacaro. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mɨɨro cajaanɨ ijɨɨbogomɨnaafi allɨnohocɨvɨ jeevatatɨhi, bu cojeecɨvomɨnaafi ihaivojɨɨbo janaanɨcɨvɨ jeevatatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jaanegui ejeevamaaisuubo ijɨɨbogomɨnaafi tɨcovovɨ iicacuuneriro imo imo iicaqui, bu ijeecɨvomɨnaafi ihaivojɨɨbobadɨ iicacuuneri icano. Mɨɨro iijamɨnaa aivojɨɨbo icaruuboco ɨjɨmɨ aivojɨɨbo neehicamo, imi fɨ jaana, ¿mɨllɨ iyotoco? ");
INSERT INTO bmrNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jaanegui miyamɨnaaco mihiguidino mɨɨro chahano aivo otoovono agaajacɨratɨno, bu chahano afatanɨcɨnɨno gaajacɨratɨno iicano. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jino cɨvohɨgo uujoho amɨɨhaico onoonoco amɨɨhai cuuje eseseehɨgovɨ monoo. Jaanotɨ bu toovono onoonoco amɨɨhai foovono mocoovadiivo iija niibahucuvɨ mofoomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mihiguijirahana oono miyamɨnaa ifiico agaicaaufimoco. Jaarumo ijeebɨɨco gaicaaujitɨrumo. Jaanotɨ naha ɨdɨɨbocoro mihigui allɨo ifiico agaicaauboro, bu tollɨro ijeebɨɨco cɨɨjɨgaifaño iguijenɨjiruuboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mɨɨro miimɨsiicɨ jooɨmɨsico sajehegayɨriro manaajenɨcɨhi. Jaarumɨsitɨ saafiba guijevetatɨhi amɨɨhai Caani niquejefaño iicaabo onootɨmañohiica. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mɨɨro paryɨ amɨɨhai nigaɨ ijeene paryɨ oovocɨnɨcuuhi sajehesari. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jaanegui mihiguijirahana. Mɨɨro amɨɨhai janaanɨcɨ majaaducafetehi ajashutɨrumo joomɨ allɨnohocɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Paryɨ famooro miyamɨnaa ɨmefeenevɨ uuditɨ imino ihiimaamoditɨ, bu uujoho ufucu imino iimaaji niquejefaño iicaabo Guihirubi ɨmefeenevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jaanotɨ miyamɨnaa ɨmefeenevɨ uco utuunamaaimoditɨ, bu ufucu uujoho tuunamaaiji Guihirubi niquejefaño iicaabo ɨmefeenevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Uco jiinɨjehallɨvɨ sajeebɨɨ icaco sɨvaabo, noomoro mehesɨcɨnɨdino. Uujoho sajeebɨɨ icaco sɨvatɨhi moonɨcasicoro sɨvahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mɨɨro gaifiico caanima moonɨcasisuvahi, bu gaigooco seejɨma moonɨcasisuvahi, bu iiyaajaco ibaaboma moonɨcasisuvahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jaaneguiiha cuuhuva famoovaro iyotomaryo mɨnaa taavacasiji. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jaanotɨ bu tajanaanɨcɨvɨ caanico, seejɨco icano agaijɨɨbo tatyahe iicajitɨhi, bu illico, illeque icano tajanaanɨcɨvɨ agaijɨmo tatya icajitɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jaanotɨ bu ifiico sefano eesɨcɨnɨɨbo tadyojɨcutɨ ofootɨɨbo tatyahe icajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jillɨ ifiicoro ataajasugoobo ifiico mɨtasuji. Jaanotɨ tahallɨtɨ ifiico ɨmɨtasuubo ifiico taajasuji. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Moocaani iijɨ jɨɨbogomɨnaaco agaayɨcɨmo, bu uco gaayɨcɨji. Jaamo uco agaayɨcɨmo, bu uco agalluuboco gaayɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jaanotɨ bu Moocaani iimaamɨnaafico Moocaani gallumɨnaafi iicaaboco imino agaayɨcɨɨbo, Moocaani iimaamɨnaafico ajaadufiyomonoco gaayɨcɨji. Jaabadɨro bu imihuseebe asaaboco diibo iimihuseneque agaajamaño imino agaayɨcɨɨbo, diibo imihuseebeque ajaadufiyomonoco gaayɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jaanotɨ bu cajaatyohacho tatyatɨ obocɨgotɨruubo tadyojɨcutɨ ofooboco sɨɨcufaihutɨ iisumo miyanotɨro ijaadama icaji. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jaabo Jesu motɨhaitɨ miimɨsiicɨdɨmo iicaumo iminɨsumɨnaaco ɨjɨɨbeguehicaudɨ toonotɨ fuubo toojiinɨjeo cuuminovɨ jɨɨbogooboro ifeequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jaanaaca Jua cɨvojafaño iicaumañotɨ guubuuhi Cristo imino moonɨɨboro efeehicaunoco. Jaaboro saatohotɨ ijɨɨbogomɨnaatɨ galluubo Jesuco imeecɨtequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Diiboco idillutequi: ¿Naa ɨɨjoho oono Cristo asaajiibo? ¿Naacu sifiiquehiica meteemeji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jaanegui Jesu diitoco iimusuuhi: Mofoomoro Juaco mɨjɨɨbogoto mahatyɨmeneque, muguubunoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mɨjɨɨbogo mɨllɨ aatyɨmetɨmo aatyɨmeneque, ɨɨgotɨmo ɨguehi, ifoojohoma iicamo iguihuvatɨ imibachucafetehi, bu inohojɨno uguubutɨmo guubucuuhi, iguijeveme siino buheesucafetehi. Jaanotɨ ɨɨdaasumo jɨɨbogocafetehi taajasujɨɨbogoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Imicani icajiibo uuvɨ ejeevevetɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jaamo ufuunobuunatɨ miyamɨnaaco Jesu Juaditɨ neehicauhi: ¿Jinejeque nacu amɨɨhai memeecɨtuuhi sɨcaihɨgo iicahɨgo? ¿Saafi noofaijɨcuco guibuhuba iguibuhucɨnɨcɨbadɨ iicaaboco? ");
INSERT INTO bmrNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Nacu, miyamɨnaafi iminoonoco jɨɨcɨnɨuboco? Mɨɨro amɨɨhairyo magaajahi iminoono ɨjɨɨcɨnɨmo aivojɨto iijanofaño icafihi. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jɨɨ, ¿jinejeque nacu memeecɨjeuhi? ¿Nacu Moocaani iimaamɨnaafico? Jɨɨhɨ, miyaano, Moocaani iimaamɨnaafi janaanɨcɨvɨ iicaaboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Diibo Juaditɨ Caatɨnɨhaame jillɨ onoobo: Uujoho tajɨɨbogomɨnaafico tahɨmegavɨ galluuhi, dihɨmega jɨɨhaico iimibachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Miyanotɨro neehi, paryɨɨcɨno miyamɨnaa iicaumotɨ, bu iicamo Jua Nitɨmɨnaafi janaanɨcɨvɨ aivo iicamo chahahi. Jaarunofaño jisumitɨ sihidɨ ejeevatɨɨbo niqueje aivojɨfaño Jua janaanɨcɨ sihidɨ jeevahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jua Nitɨmɨnaafi asaaunobuunatɨ jisumihachuta niqueje aivojɨ iminootɨneheje icahi, bu imityariro gaayɨcɨguehicamo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mɨɨro paryɨɨcɨno Moocaani iimaamɨnaa, bu Moise tajɨɨba icano aivojɨtɨ iimaauhi Jua agaseunohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jaanoco mimiyaavogohachiijɨ, mɨɨro diibo Jua, jaadi Moocaani iimaamɨnaafi Elia saajiibo unuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Amɨɨhai nohojɨma mihicamo uco muguubu. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Jinejevɨ fɨne jisumio miyamɨnaaco oovɨcɨji? Jɨɨ, jillɨ fɨne oovɨcɨhi oono seeme anaajenɨcɨhasifaño acasɨɨcamaaimoro abañamaaimo igataavomɨnaaco ocoovadiicɨnɨfibadɨ: ");
INSERT INTO bmrNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Amɨɨhaidi siruuco miguisɨcuurahi. Jaarunaa mɨjɨɨbaimɨnɨtɨhi, bu ɨdaasu masinoco amɨɨhaidi mamasivacuurahi. Jaarunofaño mataatɨhi, noomoro iicanɨcɨbadɨ jeevamo. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mɨɨro Jua asaaubo aaigafiiboro machuutɨrahi, bu aivofaihuco adutɨrahi icano. Jaaruuboco amɨɨhai iimitɨno ɨjɨma iicaabo meneehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jaanobuunatɨ bu uujoho Miyamɨnaafibadɨ Ifiivuubo asaaboco machuubo, aduubo icano. Jaaboco amɨɨhai uco: Machufifiibo, adufifiibo imitɨmɨnaa, bu impuesto jaadusumɨnaa gataavomɨnaafi icano, meneehicahi. Jaarunofaño Moocaani gaaja ɨfusucafetehi omoonɨnofañodɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jillɨ nooboro Jesu tɨcovauhi ɨhɨɨbaabo tuucuumijevɨ aivo sihidɨ ejeevano aatyɨmerafitɨno mityaco omoonɨhicau cuuminoco, tuucuumije miyamɨnaa iimitɨco ejeevesuutɨnoma iicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡Ɨdaasucaniji ɨɨjoho Corazin cuumi! ¡Ɨdaasucaniji ɨɨjoho Betsaida cuumi! Mɨɨro Tiro, Sidon icauno cuuminovɨ, amɨɨhaifeenevɨ eheetavocafetehinɨno mitya iheetavocafuturuva, sɨɨcɨje imitɨco jeevesucuujirumo. Jaamoro ɨɨfusucuujirumo ɨdaasu gaachehunoco ɨjɨcamaaimoro, bu baiguiijɨnoco ejeemere icano iimitɨco ejeevesucunoco ɨɨfusumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jaarunofaño amɨɨhaico neehi: Ufucu jaadusufucu iicadɨ amɨɨhai aivo Tiro, Sidon icano miyamɨnaa janaanɨcɨvɨ mahaamɨcafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jaanotɨ ɨɨjoho Capernau cuumi; ¿fɨne uujoho niquejefaño gañiiyɨcɨcafeteji, noonoro deesɨcɨnɨhi? Jaarunofaño guiinovɨro niitusucafeteji guijevemɨnaa iicahɨgovɨ. Mɨɨro Sodoma cuumivɨ ɨvɨ eheetavocafutuuno aatyɨmerafitɨno mitya iheetavocafuturuva, tuucuumi jisumihachutahiica icajirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jino amɨɨhaico neehi: Jaadusufucusumi aivo amɨɨhai Sodoma jiinɨjeo miyamɨnaa janaanɨcɨ momoonɨcafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tusumi Jesu Moocaanico nuuhi: Ɨco imehi, Moocaani niqueje Aivojɨɨbo, bu jiinɨjeo Aivojɨɨbo icano idiicaaboco. Jaanaa jiijegaajamɨnaaditɨ, bu jijeohesɨcɨnɨma iicameditɨ icano afatanɨnoco, jillɨ tɨcovo jeebɨɨba iicamocoro dɨhɨfusuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jɨɨhɨ, Guihi, ɨɨjoho tollɨ idiimogobadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Guihirubi uco paryɨ fanoovaco tahusefaño ficuuhi. Miyanotɨro aivo mɨɨhaiñooba Illico gaajatɨhi. Ɨdɨɨboro Caani gaajahi. Jaabadɨro Caanico mɨɨhaiñooba aivo gaajatɨhi. Ɨdɨɨboro Illi gaajahi, bu jaanoco jaatyoco Illi imeguehi agaajasunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tajaa masaa oono paryɨɨcɨno amɨɨhai amɨɨhai dudɨcamaajeneri, amɨɨhai fiisetaneri icano miniinovatomo, amɨɨhaico uujoho jaguisɨsuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magaayɨcɨ amɨɨhaico uujoho atajɨɨbanoco. Jaamoro uutɨ magaaja, ajaabɨcɨfifinoco, bu tajeebɨɨ ɨsɨɨcunoco icano. Jaamo amɨɨhai jeebɨɨco majaguisɨsujinoco mahatyɨmehi. ");
INSERT INTO bmrNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Uujoho amɨɨhaico atajɨɨbano, sihidɨ jeevatɨhi isatyo, bu amɨɨhaihallɨvɨ ificuuno aivo ijeevesutɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Toodɨhivɨ Jesu jaguisɨfucu basutafeenedɨ ɨgooboro feehicauhi. Jaanaaca ijɨɨbogomɨnaa ajeba aivuunegui tɨcovaumo trigo noovataco ɨɨcɨmoro ifayɨɨnoco amachumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jaanoco fariseomɨ aatyɨmeumoro Jesuco nuuhi: Meecɨ, dijɨɨbogomɨnaa jaguisɨfucu eheetavusutatɨnoco dudɨcamaajeque eetavehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jaanegui diitoco nuubo: ¿Nacu amɨɨhai aamefaño memeecɨhicatɨhi safoono David inahabonɨmɨnaama aajebavausumi omoonɨunoco? ");
INSERT INTO bmrNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mɨɨro Moocaani iijafaño ufuuboro machuubo jeecɨvo imimaahunoco, mɨɨjoho amachutatɨrunoco diibo, bu igataavomɨnaa icamo amachujitɨrunoco ɨdɨɨmoro sacerdotemɨ amachufinoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Nacu bu Moise tajɨɨba aamefaño onoonoco memeecɨhicatɨhi, sacerdotemɨ Moocaani iijafaño jaguisɨfucu icarunaaca jaguisɨtɨmo iicanɨcɨnoco? Jaaruno imitɨ iicatɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mɨɨro amɨɨhaico neehi: Jineeri icano aivo toono Moocaani iija janaanɨcɨvɨ ejeevano. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mɨɨro amɨɨhai magaajatɨhi Caatɨnɨhaame jino jillɨ eneejirunoco: Uujoho imeguehi mɨhɨdaasugonoco. Jaanotɨ asimɨco magaisiraicɨmoro mejeecɨvonoco imogotɨhi, onoonoco. Mɨɨro toonoco magaajaruva oono mɨllɨ imitɨco omoonɨtɨrumoco iimitɨ meneejitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mɨɨro uujoho Miyamɨnaafibadɨ Ifiivuubo bu tollɨro jaguisɨfucuhallɨvɨ mityama icahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jaadɨ Jesu toonotɨ ufuubo sinagogajafaño jɨcafutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jahɨgo icaubo saafi miyamɨnaafi ihuse ifiigatyuubo. Jaanaa Jesuco siibadɨ iicanoco omoonɨnoco aatyɨmemere ɨɨfurumo toonohallɨtɨ diiboco imoonɨqui iimuguumoro diiboco dilluumo: ¿Naa, jaguisɨfucusumi iguihuvaabo buheesuco meheetavejirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jaanegui Jesu diitoco iimusuuhi: ¿Nacu cajaatyo amɨɨhaitɨ saatoho amɨɨhai jooɨ oveja jaguisɨfucusumi jacohojɨfaño ihacuturuva mofoomoro mɨhɨcɨtejitɨrahi? ");
INSERT INTO bmrNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Jaanotɨ mɨɨro miyamɨnaafi oveja janaanɨcɨ jaaducafetehi! Jaamaño jaguisɨfucusumi imino momoonɨnoco meheetavejirahi, ");
INSERT INTO bmrNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","nooboro ihuse ifiigatyuuboco: Dihuseque fallirihicaru, nuubo. Jaanegui diibo ihuseque afalliricaruuneri tusumiro imituuhuse saanaagohuse iicabadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jaasumiro ifariseomɨ ufuumoro iimaacasiuhi Jesuco iguijenɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jaanoco Jesu agaajacɨuboro toonotɨ sihɨgovɨ fuubo. Jaabo sihidɨ miyamɨnaa bucasiuhi. Jaamo paryɨ iguihuvamoco Jesu buheesuuboro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jaaboro diitoco: Uujoho diibo iicanoco mɨɨco mɨjɨɨbeguedino, nooboro diitoco faguehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jillɨ icauno Moocaani iimaamɨnaafi Isaia jillɨ unuuno imiyacafetequi: ");
INSERT INTO bmrNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jaanɨ tajeecɨvomɨnaafi uujoho ɨɨcɨɨbo. Jaaboco uujoho agaijɨɨboro diiberi imo imo iicaabo. Diibohallɨvɨ tagaijaco ficuji. Jaabo uujoho miyaaneri udugaacunoco cuumino miyamɨnaaco jɨɨbegueji. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jaaruubo ñaaɨjitɨɨbo, coovadiinamaaijitɨɨbo icano. Mɨɨhaiñooba ihiimaaco guubujitɨhi cuumino jɨɨhaiñovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aivo gañɨɨcafetejitɨno buiga mɨɨvɨ iquisivuruno, bu jaabadɨro jabacarurajitɨno cuugahuba jari ɨnɨfuturuno. Jarihiica iimi aivojɨco eheetavusunohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jaadɨ naha jari paryɨ jiinɨje miyamɨnaa diibocoro esɨcɨnɨcuuji, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jaanaaca Jesujaago sɨvaumo ihaallɨɨno aatyɨmetɨɨbo, ihiimaatɨɨbo icano, iimitɨno ɨjɨma iicauboco. Jaaboco Jesu buheesuuhi. Jaaneri atyɨmecuubo, bu iimaacuubo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jaaneri paryɨ miyamɨnaa ajabafiituumoro nuuhi: ¿Nacu fɨne jaanɨ David Iyaachi fɨne? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jaanoco fariseomɨ uguubuumoro nuuhi: Jillɨ jaanɨ iimitɨno ɨjɨmɨco buhɨ gañɨɨhicaabo, diito aivojɨɨbo Beelzebu mityariro, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tollɨ noomoro eesamaaiunoco Jesu agaajacɨuboro nuuhi: Sahaivojɨ minoocɨ udugaavonoro sanomɨro imoonɨcasiruva gueenene icatɨnoro goovano finɨjirumo. Jaabadɨro bu cuucuumihacho, bu sajamɨnaaro icano fahɨgovavɨ idugaavuruva gueenene icajitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jaabadɨ ¿mɨllɨ bu Satanas ifiicoro buhɨgovɨ gañɨɨjirahi? Jaanotɨ jillɨ imoonɨruva, ¿mɨllɨ bu imitya gueenene icajirahi? ");
INSERT INTO bmrNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mɨɨro amɨɨhai uco meneehicahi uujoho iimitɨno ɨjɨmɨco Beelzebu mityari buhɨ agañɨɨno meneehicahi; ¿Jaano bu tollɨ iicahachiijɨ, mɨɨjoho nacu oono amɨɨhai jɨɨbogomɨnaaco mityaco acɨhicahi diitoco buhɨ igañɨɨhicaqui? Jaamaño bu diito tollɨro omoonɨmaño imino gaajaveechuno amɨɨhai guiraano aivo mɨmɨtanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Jaanotɨ naha uujoho imitɨno ɨjɨmɨco buhɨ gañɨɨhicahi Moocaani Gaija mityafeenedɨ. Jaamaño toono gaajasuhi Moocaani aivojɨ mitya amɨɨhaivɨ agasecuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Mɨllɨ bu sifi esefaabo iijafaño ofooboro inehejeque dumɨtɨɨcɨjirahi itɨconɨ diiboco sisɨtɨɨboro? Jarihiica naha diiboco isisɨɨboro inehejeque dumɨtɨɨcɨjiruubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jaamaño tajaagodɨ iicatɨmo tamɨnaa. Jaabadɨro bu tajaagovɨ mɨsɨvatɨmo buhɨgovɨro magavaracusuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jaanegui amɨɨhaico neehi: Miyamɨnaaco paryɨ fanoova imitɨco unuuruno buusucafetejirahi. Jaanotɨ Moocaani Gaijaditɨ imitɨmo ihiimaano toono naha aivono ufucuro buusurajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jaabadɨro bu cajaatyohacho uujoho Miyamɨnaafibadɨ Ifiivuubeditɨ imitɨno ihiimaaruno buusucafeteji. Jaanotɨ Moocaani Gaijaditɨ imitɨno ihiimaamoco toono aivo buusurajitɨhi jiijehallɨvɨ, bu ufucu siijehallɨvɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Mɨɨro iimino ɨmoho, iiminocoro noovanɨcɨhi. Jaabadɨro bu iimitɨho iimitɨnocoro noovahi. Jaamaño ɨmohoco inoovatɨro magaajatahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Jiinimomɨ cuumi mihicamo! ¿Mɨllɨ bu iiminoco mihiimaajirahi, imitɨmɨnaa mihicamo? Mɨɨro iijɨ iimaanɨcɨhi ijeebɨɨfaño agahafɨcɨnɨnotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mɨɨro iimino miyamɨnaafi iiminocoro iimaanɨcɨhi iimino ijeebɨɨfaño iicanotɨ. Jaanotɨ bu iimitɨno miyamɨnaafi imitɨno iimaanɨcɨhi ijeebɨɨfaño iimitɨno iicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jaanegui amɨɨhaico neehi: Ufucu jaadusufucu iicadɨ, famooro magaajaji oono iminootɨno mihiimaahicanehejeque. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mɨɨro dihiimaariro daaducafeteji, bu dihiimaariro imiibo, bu imitɨɨbo noocafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jaanegui Jesuco nuumo saatoho fariseomɨoto, bu Moise tajɨɨba gaajamɨnaaoto icamo: Gaajamɨnaafi, mɨɨhai mihimeguehi aatyɨmerafitɨno mityaco gaajabadɨ iicanoco edeetavonoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jaanegui Jesu diitoco iimusuuhi: Jeedɨ fɨne iimitɨno miyamɨnaa saafiicoro imiyaavogotatɨmo dilluhi aatyɨmerafitɨno mityaco gaajatabadɨ iicanoco; Jaaruno gaajata acɨrajitɨhi, ɨdɨɨnoro Moocaani iimaamɨnaafi Jonas gaajata acɨcafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mɨɨro oono Jonas iguiraano taavaabo jeebɨɨfaño mifucucɨ, safucu cuujeo fucuva, bu mifucucɨ, safucu fucuo fucuva icano iicaubadɨro, bu tollɨro uujoho Miyamɨnaafibadɨ Ifiivuubo jiinɨje cɨɨdɨɨfaño icaji mifucucɨ, safucu icano cuujeo fucuva, bu mifucucɨ, safucu icano fucuo fucuva icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jaadɨ Ninive cuumiri iicaumo jaadusufucusumi gañiiveji. Jino jisumio miyamɨnaaco udugaacudɨ. Jaamoro diito ɨdaasuno iicajihɨ diitoco oovɨcɨjimo; Mɨɨro Ninive miyamɨnaa iimitɨco ejeevesuumoro imino icauhi Moocaani jɨɨbogoco agalluunoco diitoco Jonas ɨjɨɨbuguusumi. Mɨɨro Jonas janaanɨcɨ uujoho iicaabo jino jimañeri icahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tollɨro bu ufucu tehesino jiinɨje aivojɨgo gañiiveji jaadusufucusumi jino jisumio miyamɨnaa imitɨco emeecɨdɨ. Jaagoro diitoco ɨdaasuno iicajihɨgo oovɨcɨjigo; Mɨɨro diigo aivo tehesino jiinɨjetɨ saauhi, Salomon gaajaco uguubuvaugo. Mɨɨro Salomon janaanɨcɨvɨ uujoho iicaabo jino jimañeri icahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mɨɨro iimitɨno ɨjɨ miyamɨnaafitɨ ihiinooboro foonɨcɨɨbo ifihigaimañehejedɨ ijaguisɨqui guiinooboro. Jaarunoco aatyɨmetɨɨboro siino esamaaifiibo: ");
INSERT INTO bmrNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Siino dojɨcuvɨro tahɨgotɨ asaahinɨhɨgo taajajaagovɨ uumiji, nooboro. Jaabo dojɨcuvɨro agaseebe miyamɨnaafi jeebɨɨco atyɨmefihi, iija sɨcaija, imibachucɨnɨja, iguijaacɨnɨjabadɨ iicaaboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jaanegui ofooboro siino ɨcɨtefiibo sahuse juugahusetɨ miimɨsiicɨ ɨdɨɨno aivo diibo janaanɨcɨvɨ iimitɨno ɨjɨmɨco. Jaamoro paryɨ sahɨ diibofaño ofoomoro icatonɨcɨmo. Jaaneri diibo itɨconɨ iicauno janaanɨcɨ aivo imitɨno minifetefihi. Jaabadɨ icajimo jito iimitɨno miyamɨnaa. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jaabo Jesu miyamɨnaamahiica ihiimaaunaacarehiica gaseumo seejɨma inahabomɨ. Jaamo diiboma ihiimaaqui omoonɨumo jahisiro icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jaanaa saatoho diiboco jɨɨbuguuhi: Diiseejɨ, bu dinahabomɨ icamo oono jahisi icahi. Jaamo ɨɨma iimaajirahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jaanegui diibo nuuhi diiboco tollɨ nooboro ɨjɨɨbuguuboco: ¿Mɨɨjoho taaseejɨ, mɨɨjoho tañahabomɨ? ");
INSERT INTO bmrNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","nooboro ijɨɨbogomɨnaaco ɨtɨduuboro nuubo: Jito taaseejɨ, tañahabomɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mɨɨro cajaatyohacho Taacaani niquejefaño iicaabo iimogonoco omoonɨmo, diito naha tañagomɨ, tañahabomɨ, taaseejɨ icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tufucu Jesu iihatɨ ihiinuuboro muuaijɨnivɨ casɨɨvutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jaanaa diibo cojɨvɨ sihidɨ miyamɨnaa iigaivuumo iijeuneguiiha Jesu meenegafaño ɨjɨcafutuuboro imuuaifaño casɨɨvutuuhi. Jaanaa imiyamɨnaa isiro fitafutuuhi, jiinɨgaibaahohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jaaboro diitoco sihidɨ sinehejeque jɨɨbeguehicaubo siinovɨ oovɨcɨɨboro jillɨ nooboro: Basumɨnaafi fuuhi abasutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jaabo basuuboro ufuuno samañoono jɨɨhaifaño aifuuhi. Jaarunoco joomɨ asaaumoro faayɨsujenɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jaanotɨ samañoono guiisihallɨvɨ aifuuhi, miyaadɨ jiinɨ achahaumañovɨ. Jaanoro goovano iinucuuno miyaadɨ ijiinɨje afaicuvautɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jaaruno nɨhɨba aachɨcɨuneri chuumucuuno abacocoovautɨmaño fiigatyuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jaanotɨ samañoono aifuuhi jarɨɨmɨhoonofeenevɨ. Jaano ijarɨɨmɨhoono toonohallɨvɨ ujusiuneri toono macanɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jaanotɨ samañoono iimino jiinɨjehallɨvɨ aifuuhi. Jaano ujusiunoro imino noovauhi; Jaano sagahaisaro ifiivuuno noovauhi ciendɨgaiva. Jaanotɨ sagahaisa noovauhi sesentadɨgaiva. Jaanotɨ sagahaisa noovauhi treintadɨgaiva icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jinooco muguubu amɨɨhai nohojɨma mihicahachiijɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jaanegui ijɨɨbogomɨnaa diibojaagovɨ asaaumoro diiboco dilluvauhi: ¿Collɨhiica miyamɨnaaco siinovɨ oovɨcɨɨboro dɨɨbeguehicahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jaanegui iimusuubo: Amɨɨhaico naha Moocaani niquejeo aivojɨ otoovonoco imino gaajasuhicahi. Jaanotɨ diito imino gaajajitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mɨɨro sihidɨ icanoma iicaabo siino janaanɨcɨ acɨcafeteji, guiraanoma iicaqui. Jaanotɨ chahanoma iicaaboco ajashunogayɨ iicaruno dumɨtɨɨcɨcafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tooneguiiha diitoco siinovɨ oovɨcɨɨboro jɨɨbeguehicahi, atyɨmecuurumo atyɨmetɨmobadɨ iicahicaneguiiha, bu guubucuurumo gaajahicatɨhi inohojɨma achahamobadɨ iicahicaneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jaamaño diitovɨ nijequevavano Moocaani iimaamɨnaafi Isaia unuuno: Amɨɨhai fɨne muguubuji. Jaarumo magaajajitɨhi; Fɨne mahatyɨmejirahi. Jaarunoco mehesɨcɨnɨjitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Amɨɨhai jeebɨɨno ucuhufunuutucumaño, imitɨno muguubuhicahi, bu ihaallɨɨno manihicɨnɨhi, ihaallɨɨneri atyɨmetɨmo iicaqui, bu inohojɨneri guubutɨmo iicaqui, bu ijeebɨɨri gaajatɨmo iicaqui. Jaamoro tajaagovɨ uumitɨmo uujoho ubuheesujiruneguiiha, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jaanotɨ naha imicani amɨɨhai mihicahi amɨɨhai aallɨɨneri mahatyɨmemaño, bu amɨɨhai nohojɨneri muguubumaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mɨɨro jino miyanotɨro jino amɨɨhaico neehi: Ajashutɨmo Moocaani iimaamɨnaa, bu ajashutɨmo iimino miyamɨnaa icamo jino amɨɨhai mahatyɨmeneque atyɨmegueuhi, bu jino amɨɨhai muguubunoco guubuguuhi icano. Jaarumo guubuutɨmoro, bu aatyɨmetɨmoro guijevecuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Muguubu taca jino basumɨnaafivɨ ohoovɨcɨno jillɨ eneejirunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jino niqueje aivojɨ iijɨco guubucuurumo agaajatɨmo johono abasuuno jɨɨhaifaño aacotonobadɨ jeevahi. Mɨɨro ɨjɨ asaaboro ijeebɨɨfañotɨ ɨcɨcuuhi ijeebɨɨfaño jɨɨbogoco abasucuurunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jaanotɨ guiisihallɨvɨ aifuuno onoono oono jɨɨbogoco uguubumoro toonoco imo imo agaayɨcɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Jaaruno miyaadɨ abacocoovatɨmaño gueenene icatɨno. Mɨɨro diitovɨ nɨsu agasesumi, bu tobogohallɨtɨ ɨjɨɨhevesumi icano toonoco jeeveyɨɨcɨfimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jaanotɨ jarɨɨmɨhoonofeenevɨ abasuuno onoono, oono jɨɨbogoco guubucuurumo sinehejejaagovɨro ijeebɨɨno iicamoro jijeo nehejeriro nɨjɨ nɨjɨ iicamaño nɨhɨbamɨ diitoco bañɨfihi. Jaano paryɨ jinehejere tojɨɨbogoco amacanɨsumaño diitofaño toonoco noovasutatɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jaanotɨ naha iimino jiinɨjehallɨvɨ abasucafutuuno, onoono jɨɨbogoco uguubumoro agaajamo diito imino onoovasumo. Jaamo saatoho jeevahi oono ciendɨyɨva sayɨ ifiivuuno onoovabadɨ. Jaanotɨ saatoho oono sesentadɨno onoovaubadɨ jeevahi, bu saatoho treintadɨno onoovaubadɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jaadɨ bu Jesu jino siino jɨɨbuguuhi siinovɨ ohoovɨcɨuboro: Niqueje aivojɨ jeevahi oono miyamɨnaafi iimino toogaiñooco ifaguifaño abasuunobadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jaarunaaca paryɨ cɨgaumaaca diibo mɨnaafi ɨjɨcafutuuboro iimitɨno ñaavahuco abasujeuboro fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jaanaaca itrigo ifiivuunoro noovaunofeenetɨ, bu tollɨro toono iimitɨno ñaavahu fiivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jaanegui ijeecɨvomɨnaa ufuumoro abajaaboco nuutuuhi: Aivojɨɨbo mɨɨro faguifaño imino toogaiñooco basuuhi. ¿Cuucatɨ jana bu jino iimitɨno ñaavahu fiivehi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jaanegui abajaabo nuuhi: Cajaanɨhacho tamɨnaafi tollɨ moonɨhi, nooboro. Jaanegui ijeecɨvomɨnaa nuuhi: ¿Diimeguehi mofoomoro toohibaijeque magaijucɨtonoco? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Jaarunaaca diibo nuuhi: Chahano, toohibaijeque magaijucɨhɨgo, bu itrigohiibaimaryo magaijucɨjirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jaafa sano fanoocɨro jusihi. Jaadɨ dudɨcamaajemɨnaaco tajɨɨbaji itɨconɨ toono iimitɨno ñaavahuco ihɨcɨqui, jaamoro faasɨhije isisɨqui cɨɨjɨgaifaño mɨjɨgasuqui. Jaadɨ itrigoco ɨɨcɨmoro tamachuta iijafaño toonoco ificuuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jaadɨ bu Jesu siino jillɨ ohoovɨcɨɨboro nuuhi: Niqueje aivojɨ jeevahi oono miyamɨnaafi ifaguifaño mostaza tooɨco abasuno iicanɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mɨɨro jaagai paryɨ fanoova tooɨnoguiinovɨ sihajashugayɨ. Jaarugai ujusidɨ fahoova janaanɨcɨvɨ iminifotohoro ɨmohodɨho minifotonɨcɨhi. Jaaho aivo aajashutɨmaño joomɨ agahafomo asaamoro ihaafenevɨ iicuvanɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tollɨro bu siino jillɨ ohoovɨcɨuboro nuubo: Niqueje aivojɨ jeevahi oono gaigo levaduraco minoocɨ, sano icano oovodɨno harinaco ɨɨcɨgoro toonoma acaɨsenɨno toosɨhima imino acaɨsecafotonɨcɨno iicabadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu jillɨ paryɨ miyamɨnaaco siinovɨ oovɨcɨɨboro jɨɨbeguehicauhi, siinovɨ oovɨcɨtɨɨboro jɨɨbeguehicautɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jillɨ icauno Moocaani iimaamɨnaafi unuuboro acaatɨnɨuno imiyacafetequi: Siinovɨ ohoovɨcɨnofeenedɨro iimaaji; Sɨɨcɨjetɨro Moocaani jiinɨjeque ifiivusunotɨro toovono iicanehejeque, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jaadɨ Jesu miyamɨnaaco agalluuboro jaahevɨ fuubojaago ijɨɨbogomɨnaa ifiitɨvuumoro diiboco dilluuhi: Mɨɨhaico dɨɨbogo oono iimitɨno ñaavahu faguifaño iicaneditɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jaanegui Jesu diitoco nuuhi: Mɨɨro iimino toogaiñooco abasuubo oono uujoho Miyamɨnaafibadɨ Ifiivuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jaanotɨ fagui onoono jiinɨje. Jaanotɨ oono iimino toogaiño, onoono Moocaani aivojɨ seemetɨ onoono. Jaanotɨ iimitɨno ñaavahu onoono ɨjɨ seemeditɨ iicameditɨ onoono. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jaanotɨ mɨnaafi iicaabo diibo ɨjɨ. Jaanotɨ ibasutaaco ɨɨcɨjino onoono ufucu jiinɨje ifinɨjinotɨ onoono. Jaanotɨ toono ibasutaaco ɨɨcɨjimo Moocaani toomomɨnaa. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jaanotɨ oono iimitɨno ñaavahuco mɨhɨcɨmoro mɨjɨgasunɨcɨradɨ, bu tollɨro ufucu jiinɨje ifinɨdɨ icajino. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jaasumi uujoho Miyamɨnaafibadɨ Ifiivuubo itoomomɨnaaco tajɨɨbaji ihaivojɨfañotɨ inanɨqui oono sitaaco imitɨco ɨɨcɨsuhicamoco, bu imitɨco omoonɨhicamoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jaamoco cɨɨjɨgaifaño gañɨɨjimo tahɨ ataacasijihɨgo, ɨdaasuno iicaneri igaiñonoco catɨrɨrɨ oojɨsujihɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jaanotɨ Moocaani iimogonoco omoonɨhicamo nɨhɨba iicanɨcɨradɨ achɨcɨnɨji Moocaani aivojɨfaño. Amɨɨhai nohojɨma mihicahachiijɨ muguubu. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Niqueje aivojɨ oono nɨhɨbamɨ toovono jiinɨjefaño afatanɨcɨnɨbadɨ jeevahi. Jaanoco saafi miyamɨnaafi aatyɨmeebere siino dojɨcuvɨro siino toonovɨro fatanɨnɨcɨhi. Jaaboro imo imo ofooboro paryɨ inehejeque anaajeebere toono nɨhɨbamɨri tomaño jiinɨjeque naajenɨcɨhi, fanooro tomañonɨhɨbamɨ diibediro iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Bu tollɨro niqueje aivojɨ jeevahi naajemɨnaafi oono perla guiisiyɨ iimiyɨco guiinooboro ofoonɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jaayɨco aatyɨmesumi ofooboro paryɨɨcɨno inehejeque anaajeebere tooneri tooyɨco naajenɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jaabadɨro bu niqueje aivojɨ oono sinɨcuuhuco muuaifaño magañɨɨno faaboho taavaaboco ɨɨcɨnɨcɨno iicabadɨ jeevahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jaano isinɨcuuhu agahafucuudɨ ifiicɨmɨnaa jiinɨgaibaahohallɨvɨ isi guiiyɨcɨnɨcɨhi. Jaadɨ ututuuvomoro itaavaco nanɨnɨcɨmo. Jaamoro iimifiimoco jɨiibaiñofaño ficunɨcɨmo. Jaamo iimitɨmoco buhɨ gañɨɨnɨcɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jillɨ icajino ufucu jiinɨje ifinɨdɨ; Moocaani toomomɨnaa asaamoro dugaacujimo iimitɨmoco iimifiimofeenetɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jaamoro iimitɨmoco cɨɨjɨgaifaño gañɨɨjimo, tahɨgo ataacasijihɨgo, bu igaiñooco catɨrɨrɨ oojɨsujihɨgo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jaaboro Jesu diitoco dilluuhi: ¿Naa paryɨ jinooco magaajahi? nooboro. Jaanegui diito nuuhi: Jɨɨhɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jaanegui nuubo: Mɨɨro Moise tajɨɨba gaajamɨnaafi imino niqueje aivojɨ jɨɨbogoco gaajacuubo. Jaabo iija abajaabobadɨ jeevahi. Mɨɨro toojamɨnaafi fanoocoro toojafaño iicanoco gaajahi. Jaabo ɨɨcɨjiruubo eedeeneque, bu bohonoco icano. Jaabadɨro diibo niqueje aivojɨ jɨɨbogoco agaajaabo jɨɨbeguejirahi Moise unuunoco, bu jisumi uujoho ihiimaanoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jaadɨ Jesu siinovɨ oovɨcɨɨboro ɨjɨɨbeguehicaudɨ toonotɨ fuucuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jaabo ijiinɨjevɨ ɨfutuuhi. Jahɨgo paryɨ famaño sinagogajanofaño jɨɨbogooboro feehicaubo. Jaaneri miyamɨnaa ajabafiitomoro neehicauhi: ¿Cuucatɨ jaanɨ gaajahinɨhi jino jityɨgaba gaajaco? ¿Mɨllɨ jaabo jino sihidɨ ejeevanoonoco eetavehicahi? ");
INSERT INTO bmrNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mɨɨro jaanɨ ɨmohobujene dudɨcamaajemɨnaafi achi, jaanotɨ seejɨ Maria icano. Jaanotɨ bu inahabomɨ Jacoobo onoobo, Jose, Simon, bu Juda icamo. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mɨɨro bu inagomɨ mɨɨhaifeeneri icahicahi. ¿Cuucatɨ jana gaajaabo paryɨ jityɨgabajeque? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jaamaño diiboco miyaavuguutɨmo. Jaanegui Jesu diitoco nuuhi: Famoovaro Moocaani iimaamɨnaafico imino gaayɨcɨhicahi. Jaanotɨ ɨdɨɨmoro iicuumimɨnaa, bu iijamɨnaa icamo gaayɨcɨtɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jaamaño sihidɨ toonovɨ sihidɨ ejeevanehejeque eetavuutɨɨbo diito diiboco imiyaavuguutɨneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tusumi Herode onoobo Galilea aivojɨɨbotɨ icauhi. Jaabo guubuuhi Jesuditɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jaaboro iicojɨri iicaumoco nuubo: Diiboro Jua Nitɨmɨnaafi siino ubuuheteebe guijevetɨ. Jaamaño jino sihidɨ ejeevano mityama icaabo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mɨɨro diibo Herode Jua Nitɨmɨnaafico isisɨsuuboro cɨvojafaño ficusuuhi. Herodia onoogo inahabo Felipe taabaco unuuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jaabo Jua Nitɨmɨnaafi Herodeque nuuhi: Diigoco taabavadino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jaanegui Herode Juaco guijenɨujirahi. Jaaruubo miyamɨnaaco ñɨhicuguehicauhi; famooro miyamɨnaa: Juaco Moocaani iimaamɨnaafi, noomoro eneehicaunotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jaanaa ifiivu ficabavɨ ɨɨfutusumi jɨɨbaimoco Herode eheetavuuhɨgo Herodia aicɨgai diibo ucuuhuvaumo ɨmegavɨ gahaseguere fuuhi. Jaanoco aivo Iherode sihidɨ iimuguubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jaaboro diigoco Moocaanifañodɨ unuuboro acɨguubo fanooco conoocohacho diigo idilluguunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jaanegui diigo seejɨ diigoco afajɨɨnɨubadɨ, ufuugoro Herodeque nuutuuhi: Uco butajefaño Jua Nitɨmɨnaafi nigaɨco daacɨ, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jillɨ unuuno diibo aivojɨɨbo Herodeque sihidɨ ɨdaasuvusuuhi. Jaarunofaño Moocaani momofañodɨ unuucuumaño, bu diibo cojɨri iicaumo jaanoco uguubucuumaño icano, tajɨɨbaubo ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jaanegui tajɨɨbaubo Jua nigaɨco iquitɨcɨqui cɨvojafaño icauboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jaayɨco ɨsɨvaumoro tobagocajaco acɨvauhi. Jaanoco bu diigo seejɨco acɨtuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jaanoco ijɨɨbogomɨnaa uguubuumoro Jua Nitɨmɨnaafi ifiico asatyumoro cɨɨjeuhi. Jaadɨ ufuumoro Jesuco jɨɨbugutuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jaanoco Jesu uguubuuboro iinoro sihɨgovɨ tehesino fuuhi meenegari. Jaarunoco miyamɨnaa agaajacɨumoro cuuminotɨ diiboco bucasiuhi isidɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jaanaa Jesu imeenegatɨ ihiinuuhɨgo atyɨmeuhi sihidɨ miyamɨnaa iicaunoco. Jaaboro diitoco ɨdaasuguubo. Jaaboro iguihuvama iicamoco diibojaa ɨsɨvamoco buheesuhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jaanaa iijɨcuunegui ijɨɨbogomɨnaa diibojaa asaaumoro diiboco noovauhi: Aivo mihiijɨcuuhi, bu mɨɨhaiñooba jimañeri chahahi. Jaanegui miyamɨnaaco galluucu ofoomoro cuuminotɨ maahunoco anaajemere imachuqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jaanegui Jesu diitoco nuuhi: Mɨllɨ bu feejirumo amɨɨhai mahacɨ imachuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jaanegui diito nuuhi: Mɨɨro mɨɨhaima chahano, ɨdɨɨnoro jino sahusedɨbava momaahuno, bu miimɨsiicɨro taavaabomɨsi icano, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jaanegui Jesu nuuhi: Juu tajaa mɨsɨva, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jaaboro miyamɨnaaco tajɨɨbaubo ñaavahuhallɨvɨ icasɨɨcamaaiqui. Jaaboro ihusefaño ɨcɨubo toono sahusedɨbava imaahunoco, bu itaavaabomɨsico icano. Jaaboro niquejeque emeecɨuboro Moocaanico toonohallɨvɨ iimuuboro toonoco iquisicuuboro ijɨɨbogomɨnaaco acɨubo. Jaanoco diito imiyamɨnaama ɨfuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jaanoco famooro amachuumoro tuvauhi. Jaano atyuuvoco ananɨumo gahafusuuhi jɨiibaiñooco fahuseecɨ motɨhaitɨ siino miibaicɨ ɨdɨɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jaanoco amachuumo cinco mildɨmou sano gaifiimɨro. Jaanotɨ gaigoomɨ, bu seeme icano oovarautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jaaboro Jesu ijɨɨbogomɨnaaco imeenegafaño ɨjɨcuuboro galluuhi ihɨmega oonogoomuuaivɨ ifeequi, diibo miyamɨnaaco ifitacuunohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jaadɨ diitoco ifitacuuboro Jesu fuuhi ifabaɨ nigacɨvɨ Moocaanima ihiimaaqui. Jaadɨ mihiijɨcuunaaca Jesu tahɨ iinoro icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jaanaaca imeenegafeene muuairi icaunaaca sefano guibuhuba guibuhicauhi togahallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jaanaaca Jesu cuujetavɨ jari diitojaagovɨ saauhi, nɨfaihuhallɨdɨ ɨgooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jaaboco ijɨɨbogomɨnaa nɨfaihuhallɨdɨ ɨgooboro asaaunoco aatyɨmeumoro gaihivuumo iigutuumoro: ¡Ajaanɨ ɨjɨ! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jaarunofaño Jesu diitoco nuuhi: Mequehecu mihiguetedino, uujoho, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jaanegui Pedro diiboco nuuhi: Aivojɨɨbo, miyaano ɨɨjoho idiicahachiijɨ taca, tajɨɨba bu uujoho dijaa saaqui nɨfaihuhallɨdɨ ɨgooboro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jii, disaa taca, nooboro. Jaanegui Pedro imeenegatɨ iniituuboro tɨcovauhi nɨfaihuhallɨdɨ ɨɨguubo Jesujaagovɨ ifeequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Jaarunaaca guibuhuba sefano iguibuunoco aatyɨmeuboro igutuubo. Jaasumiro tɨcovaubo inɨfaihufaño iniituubo. Jaanegui gaihivuubo: ¡Aivojɨɨbo, uco taajasu! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jaasumiro Jesu diiboco ihusetɨ iguiiyɨcɨuuboro diiboco nuuhi: ¡Ajashucani dimiyaavogo! ¿Collɨhi miyaavogotɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jaadɨ diitɨsi imeenegafaño ɨjɨcafutuusumiro iguibuhuba llɨɨvɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jaanegui imeenegafaño iicaumo Jesuguiino ememuɨɨvuumoro nuuhi: Miyaano ɨɨjoho Moocaani Achi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jaamo imuuaico afatyuudɨ ɨɨfutuumo Genesare jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jaanaa toojiinɨjeo miyamɨnaa Jesu iicaunoco agaajacɨumoro paryɨ toojiinɨjeri jɨɨbohocasiumo. Jaamoro Jesujaagovɨ sɨvaumo paryɨ iguihuvamehejeque. ");
INSERT INTO bmrNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jaamoro diiboco dilluhicaumo jillɨ igaachehujɨniba nijequegayɨco idudɨɨcɨtequi. Jaanoco paryɨ famooro ududɨɨcɨudɨmo buheeuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jaadɨ fariseomɨtɨ saatoho, bu caatɨnɨmɨnaa icamo Jerusale cuumitɨ asaaumoro Jesuco dilluvauhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Mɨllɨtɨ dijɨɨbogomɨnaa moheedetemɨhai jeevamaaje iicabadɨ moonɨtɨhi? Mɨɨro momoonɨnɨcɨbadɨ moonɨtɨmoro ihuseneque nitamaaitɨmoro machuhicahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jaanegui Jesu diitoco iimusuuhi: ¿Mɨllɨtɨ bu jana amɨɨhai Moocaani tajɨɨbaco mejeevesumoro amɨɨhai jeevamaajequere momoonɨhicahi? ");
INSERT INTO bmrNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mɨɨro Moocaani jillɨ nuuhi: Diicaani, diiseejɨ icamoco bocɨgo. Jaanotɨ caanico, seejɨco icano imitɨno onoomo iguijevequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Jaaruno icanaaca amɨɨhai meneehicahi jillɨ, mɨɨno caanico, bu mɨɨno seejɨco icano meneejirahi: Ɨco acɨjitɨhi: Mɨɨro paryɨ tañehejeque uujoho Moocaanico ɨjɨbaicuuno, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jaamaño tollɨ onoomo caanimɨco, jinehejebaco acɨhicacuutɨhi. Jillɨ momoonɨmaño Moocaani tajɨɨbaco jihovonobadɨ momoonɨhicahi. Amɨɨhai jeevamaajequere moonɨmoro mihicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Amɨɨhai bañɨfiiramɨnaa mihicamo. Mɨɨro miyaanoco nuubo Moocaani iimaamɨnaafi Isaia jillɨ nooboro acaatɨnɨusumi: ");
INSERT INTO bmrNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jiicuumi uco jillɨ tɨcovono iijɨriro bocɨguehicahi. Jaarumo jeebɨɨno uuditɨ tehesino icahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jillɨ sɨcamañovɨ iigaivomoro uco imehicahi. Jillɨ amɨɨhai jɨɨbogono, tɨcovono miyamɨnaa jɨɨbogonoro iicamaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jaadɨ Jesu miyamɨnaaco ocoovauboro nuuhi: Jinooco muguubumoro imino magaaja: ");
INSERT INTO bmrNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mɨɨro miyamɨnaafi iijɨri ɨjɨcafotono diiboco mɨhɨninɨtɨhi. Jaanotɨ naha iijɨfañotɨ asaano diiboco mɨhɨninɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jaanegui ijɨɨbogomɨnaa asaaumoro diiboco nuuhi: Mee, fariseomɨ ɨɨjoho tollɨ onoonoco uguubumoro aiveguehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jaaneguiiha diitoco iimusuubo: Guihirubi niquejefaño iicaabo abasutɨhoco paryɨ ibacoconomaryo agaijuyɨcɨɨboro gañɨɨjiibo. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jaafa tahɨ iimaamo jillɨ ihaallɨɨnoma chahamo, bu sita ihaallɨɨnoma achahamoco sɨɨguehicahi. Mɨɨro ihaallɨɨnoma achahaabo sifiico isɨɨguruva faamɨsicɨro ifahojɨfaño aquetejirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jaaneguiiha Pedro Jesuco nuuhi: Toono tollɨ odoovɨcɨnoco mɨɨhaico dɨɨbogo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jaanegui Jesu iimusuuhi: ¿Nacu buunajɨ amɨɨhai tollɨro magaajatɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mɨɨro paryɨ miyamɨnaa iijɨri ɨjɨcafotono moobafaño feehi. Jaadɨ mofiitɨ inoonɨcɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jaanotɨ naha miyamɨnaafi iijɨfañotɨ asaano diiboco mɨhɨninɨhi, ijeebɨɨfañotɨ asaamaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mɨɨro ijeebɨɨfañotɨ iimitɨnoono esamaajene saanɨcɨhi, bu gaicaauneheje, bu gaigoomɨco ɨɨcɨmoro ejeevesuneheje, bu gaigoomɨma imitɨnoono iicaneheje, bu nanivaneheje, bu bañɨfiiraneheje, bu sitaaditɨ sɨcamaño jɨɨbogoneheje icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jineheje naha miyamɨnaafico mɨhɨninɨhi. Jaanotɨ nitamaajehene moonɨco eetavotɨmo amachuno miyamɨnaaco mɨhɨninɨtɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jaadɨ Jesu toonotɨ ihiinuuboro fuuhi Tiro, Sidon icano jiinɨjejaagovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jaanaaca Canaan jiinɨje miyamɨnaago toojiinɨjeri iicaugo saauhi Jesujaago coovadiicɨnɨgoro: ¡Aivojɨɨbo, David Iyaachi, uco dɨdaasugo! Aicɨgai iimitɨno ɨjɨma icago sihidɨ ɨdaasuno icahicahi, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jaarunaa Jesu diigo ajashunoba iimusuutɨhi. Jaanegui ijɨɨbogomɨnaa asaaumoro diiboco nuuhi: Ajaamoco gallu gañuhusuno modojɨcutɨ coovadiicɨnɨgoro saago, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jaanegui Jesu diitoco nuuhi: Moocaani uco Israel cuumimɨnaa ovejamɨ ɨmɨtamobadɨ iicamojaagovɨro galluuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jaarunofaño diigo asaaugoro diiboguiino ememuɨɨvovaugoro diiboco nuuhi: ¡Aivojɨɨbo, uco daamusu, noogoro! ");
INSERT INTO bmrNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jaanegui Jesu diigoco nuuhi: Imijitɨruno iseeme machutaaco udumɨtɨɨcɨmoro jɨcumɨco aacɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jaarunofaño diigo nuuhi: Miyaano Aivojɨɨbo; Jaarunofaño jɨcumɨ machufihi iguiinotɨ ihabajato amachuno suuvɨco, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jaanegui Jesu diigoco nuuhi: Gaigo, guiraacani dimiyaavogo. Jaafa ɨɨjoho idiimogobadɨ icano, nooboro. Jaanoco tollɨ diibo unuuno tɨcovovɨro diigo aicɨgai buheeteuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jaadɨ Jesu toonotɨ ihiinuuboro ufuubo fatyuuhi Galilea muuaijɨnidɨ. Jaadɨ ifabaɨhallɨvɨ ufuuboro casɨɨvutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jaabojaago sihidɨ miyamɨnaa ufuumoro ɨfutuuhi diibo iicauhɨgo. Jaamoro diibojaago sihidɨ sɨvahicauhi ɨɨgotɨmehejeque, bu ihaallɨɨno aatyɨmetɨmehejeque, bu ihiimaatɨmehejeque, bu imitɨno ihusene iicamehejeque icano, bu sihidɨ saatoho iguihuvamenejeque icano. Jaamoco buheesuhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jaaneri miyamɨnaa sihidɨ jabafiitehicauhi ihiimaahicautɨmeheje ihiimaauneri, bu imitɨno ihusene iicaumeheje imino ihusenema iicacuuneri, bu ɨɨguehicautɨmehejeque ɨɨgucuuneri, bu ihaallɨɨno aatyɨmeutɨmeheje aatyɨmecuuneri icano. Jaamoro tɨcovaumo Moocaanico Israel cuumi Dios icaaboco, iimomo. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jaadɨ Jesu ijɨɨbogomɨnaaco ucuuhuvauboro diitoco nuuhi: Jito miyamɨnaaco ɨdaasuguehi. Mɨɨro jino mifucucɨ, safucu icano icacuumo uuma jinoovɨ. Jaamo amachujirunobama chahacuuhi. Jaanegui imogotɨhi machutɨmoco iijanojaago agalluunoco ofoomo jɨɨhaivɨ nacatejirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jaaneguiiha ijɨɨbogomɨnaa diiboco nuuhi: ¿Cuucatɨ bu mɨllɨ mɨhɨcɨjirahi jino mɨɨhaiñooba iijano achahahɨgo mihicamo jityɨgaba miyamɨnaa iicamoco mutuvasuqui? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jaanegui Jesu diitoco nuuhi: ¿Nacu mɨnoodɨno amɨɨhai machutaano icahi? nooboro. Jaanegui diito nuuhi: Sahuse juugahusetɨ minoocɨ ɨdɨɨnoro momaahugayɨno icahi, bu ajashuno motaavagayɨ iicanoro, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jaanegui tajɨɨbaubo imiyamɨnaa jiinɨjehallɨvɨ icasɨɨcamaaiqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jaadɨ toono sahuse juugahusetɨ minoocɨ, bu itaavagayɨ icanoco ihusefaño agaayɨcɨuboro toonohallɨvɨ Moocaanico graciaco acɨuhi. Jaadɨ toonoco iquisicuuboro ijɨɨbogomɨnaaco acɨuhi. Jaanoco diito imiyamɨnaama ɨfuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jaanoco paryɨ famooro amachuumoro imino tuvauhi. Jaadɨ ihatyuuvoco ananɨumo gahafusuuhi sahuse bu juugahusetɨ miibaicɨ ɨdɨɨno jɨiibaiñooco. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jaanoco amachuumo cuatro mildɨmo gaifiimɨu. Jaano gaigoomɨ, bu seeme icamo oovorautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jaadɨ Jesu diitoco ifitacuuboro meenegafaño ɨjɨcafutuuboro fuuhi Magdala onoocuumi jiinɨjejaagovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jahɨgo fariseomɨ, bu saduceomɨ icamo fuuhi Jesuco emeecɨtuumo. Jaamoro diiboco ɨɨfurumo iimitɨnofaño igañɨɨsuqui dilluuhi: Mɨɨhaico niquejefañoono aatyɨmeratatɨnoco dɨhɨfusu, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jaanegui diibo diitoco iimusuuhi: Iijɨcuuvɨ niqueje tɨfaiño iicasumi amɨɨhai: Aiguejitɨno mɨɨro oono niqueje tɨfaihi, meneefihi. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jaabadɨro bu fucuro meneefihi: Jaachiijɨ imijitɨfucu, mɨɨro oono niqueje tɨfaiño niijama icahi, noomoro. Bañɨfiiramɨnaa mihicamo, amɨɨhai magaajahi niquejeque memeecɨmoro aiguejino, bu aiguejitɨno icano monoonoco. Jaarunaa magaajatɨhi mɨllɨ jisumio miyamɨnaa imitɨ eheetavoneheje ɨjɨɨbugurunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jaamo jito iimitɨno miyamɨnaa sanofañoro imiyaavogonofaño iicatatɨmo, dilluhicahi aatyɨmeratatɨneheje eetavoco. Jaarumoco acɨrajitɨno ɨvɨ ɨdɨɨnoro Jonas gaajataro ɨfusucafeteji, nooboro diitoco ejeevesuuboro fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jaanaa onoogoobavɨ afatyumo ijɨɨbogomɨnaa jabajeeveuhi pan añɨmɨnaa maahuco asatyujirumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jaanaa Jesu diitoco nuuhi: Magaihuɨnɨ fariseomɨ, bu saduceomɨ icamo juurisutaguiijɨnotɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jaanegui ijɨɨbogomɨnaa noocasiuhi: Añɨmɨnaa maahunoco mɨsɨvatɨneguiiha ollɨ noobo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jaanoco Jesu agaajacɨuboro diitoco nuuhi: ¿Collɨhi maahunoma machahanoco monoocasihi? Ajashucani amɨɨhai miyaavogo. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Nacu magaajatɨhi, mehesɨcɨnɨcuutɨhi oono cinco mildɨmoco sahusedɨbavariro amachusunoco, bu ihatyuuvoco mɨnoodɨbaiva jɨiibaiñooco magahafusuunoco icano? ");
INSERT INTO bmrNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Bu mehesɨcɨnɨtɨhi sahuse juugahusetɨ miibaacɨ ɨdɨɨneri cuatro mildɨmoco amachusunoco, bu ihatyuuvoco mɨnoodɨbaiva jɨiibaiñooco magahafusuunoco icano? ");
INSERT INTO bmrNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jaamo bu mɨllɨtɨ amɨɨhai magaajacɨtɨhi uujoho machutaatɨ onootɨnoco oono fariseomɨ, bu saduceomɨ icamo juurisutaguiijɨtɨ onoonoco? ");
INSERT INTO bmrNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jaaneri jari gaajaumo Jesu diitoco añɨmɨnaa maahuno juurisutaguiijɨtɨ unuutɨnoco, ɨvɨ jillɨ fariseomɨ, bu saduceomɨ icamo jɨɨbogotɨ mihigui unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jaanaa Jesu Cesarea de Filipo onoocuumi jiinɨjevɨ ɨɨfutuudɨ ijɨɨbogomɨnaaco dilluubo: ¿Uujoho Miyamɨnaafibadɨ Ifiivuubeditɨ, ¿nacu mɨllɨ miyamɨnaa uuditɨ neehicamo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jaanegui diito nuuhi: Saatoho: Jua Nitɨmɨnaafi, neehicahi. Jaanotɨ saatoho: Elia, neehicahi. Jaanotɨ bu saatoho: Jeremia, neehicahi. Jaanotɨ saatoho: Cajaanɨhacho sɨɨcɨjeototɨ Moocaani iimaamɨnaaɨvɨoobo, neehicahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jaanegui diitoco nuubo: Jaanaa amɨɨhai, ¿mɨɨjoho uujoho iicanoco meneehicahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jaanegui Simon Pedro diiboco nuuhi: Ɨɨjoho Cristo Moocaani iicaabo Seemene, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jaaneguiiha Jesu diiboco iimusuuhi: Imicani diicahi ɨɨjoho Simon Jona achi idiicaabo. Mɨɨro cajaanɨ miyamɨnaafi ɨco jinooco gaajasutɨhi ɨdɨɨboro Guihirubi niquejefaño iicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jaaneguiiha uujoho ɨco jino Pedrotɨ momonɨhi, guiisiyɨ eneejiruno. Jaaba jiba guiisibahallɨvɨ uujoho taajaco eetaveji. Jaajaco guijeve mitya icaruno guiinonɨjitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ɨco uujoho jino niqueje llaveneque acɨji. Jaabo ɨɨjoho jiijehallɨvɨ isisɨno, bu niquejefaño sisɨcafetejino. Jaanotɨ jiijehallɨvɨ isinaayuno, bu niquejefaño sinaayucafetejino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jaadɨ Jesu ijɨɨbogomɨnaaco faguuhi diibo Cristo iicanoco mɨɨhaiñoobaco jɨɨbogotɨmo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tusumi Jesu tɨconɨuhi ijɨɨbogomɨnaaco agaajasuubo Jerusalevɨ ofooboco quillahuto, bu sacerdotemɨ aivojɨto, bu caatɨnɨmɨnaa icamo diiboco sihidɨ ɨdaasuno omoonɨujinoco: Uco gaicaausujimo. Jaaruubo mifucucɨ, safucu icanotɨ siino buheeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jaaneguiiha Pedro sihɨ Jesuco asatyuuboro ɨɨbauhi: Jaanova Moocaani ɨco tollɨ moonɨsujitɨrahi, tollɨ icatɨɨbo diicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jaarunaaca Jesu dojɨcuvɨro acajebeveuboro Pedroco nuuhi: Uutɨ buhɨgovɨ minifoto ɨɨjoho ɨjɨ idiicaabo. Fɨne, ɨɨjoho uco acasivusuno. Dihesamaaje Moocaani esamaajebadɨ icatɨhi. Jillɨ miyamɨnaa esamaajebadɨro jeevahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Saatoho ijɨɨbogomɨnaaco nuubo: Cajaatyohacho tadyojɨcutɨ asaagomo ifiico ajabajevemere tadyojɨcutɨ isaaqui ifiico ɨdaasuno omoonɨsujinoco iguitɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mɨɨro ifiico agaijɨmo ifiico mɨtasuji. Jaanotɨ naha tahallɨtɨ ifiico ɨmɨtasumo ifiico taajasuji. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mɨɨro saafi miyamɨnaafi paryɨ jiinɨje busumijeque gaayɨcɨruubo. Jaaruubo ijeebɨɨco ɨmɨtasuruva, ¿nacu mɨllɨtɨ imijiruno? ¿Nacu mɨnoodɨno fɨne miyamɨnaafi ijeebɨɨco itaajasuqui jaadujirahi? ");
INSERT INTO bmrNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mɨɨro uujoho Miyamɨnaafibadɨ Ifiivuubo saaji Caani ovosɨɨma, bu itoomomɨnaama icano. Jaasumi paryɨ famoovaaco itɨcovocɨvɨ jaadujiibo omoonɨhicanehejeque. ");
INSERT INTO bmrNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Miyanotɨro neehi: Jino iicamotɨ saatoho guijevejitɨhi uujoho Miyamɨnaafibadɨ Ifiivuubo ihaivojɨri asaaboco aatyɨmetɨmoro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Toonobuunatɨ sajaguisɨ nijequetɨ Jesu ɨcɨuhi Pedroco, bu Jacooboco, bu diibo Jacoobo nahabo Jua icamoco. Jaaboro diitomaryo fuuhi aivo acaamovobaɨ nijequevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jaabaɨ nijequevɨ diito ɨmefeenevɨ ifi siibadɨ minifutuuhi. Ihɨme arɨcuno minifutuuhi nɨhɨbaco memeecɨbadɨ, bu igaachehu seseene minifutuuhi nɨhɨba aachɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jaanaa diibo uufocovɨ atyɨmeumo Moise, Elia icamɨsi Jesuma iimaamɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jaaneguiiha Pedro Jesuco nuuhi: Aivojɨɨbo, imicani jimañovɨ mihicano. Idiimogohachiijɨ masɨɨ nɨjeganoco migaacɨ, saga ɨdɨɨno meheetavequi, ɨɨdi saga, Moisedi saga, Eliadi saga icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Jaanaaca Pedro tollɨ nuunaaca diitoco aimuufai mibaacuuhi. Jaano ihaimuufaifañotɨ guubuvusuuno: Jaanɨ Taseemene agaijɨɨbo. Diibo onoonoco muguubunɨcɨ, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jaanoco uguubuumoro ijɨɨbogomɨnaa jiinɨjehallɨvɨ javucamaaiumo sihidɨ iguituumoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jaanegui Jesu asaauboro diitoco ududɨɨcɨuboro nuuhi: Magañiivo mihiguetedino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jaadɨ siino emeecɨurumo mɨɨhaiñoobaco atyɨmecɨutɨhi ɨdɨɨboro Jesu icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jaamoco tobaɨtɨ iniituhɨgo Jesu faguuhi: Jino mahatyɨmeneque mɨɨhaiñoobaco mɨjɨɨbeguedino jari uujoho Miyamɨnaafibadɨ Ifiivuubo iguijeveebe siino ubuheetedɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jaanegui diito diiboco dilluuhi: ¿Mɨllɨtɨ jana bu caatɨnɨmɨnaa nuuhi: Elia itɨconɨ saaji, neehicahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jaanegui Jesu iimusuuhi: Jɨɨhɨ, miyaano Elia itɨconɨ saaji. Jaaboro paryɨ fanoovaaco imibachujiibo. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jaarunofaño amɨɨhaico uujoho jino neehi Elia saahinɨcuhi. Jaaruuboco gaajacɨhinɨtɨmo. Jaamoro diiboco jillɨ iimogobadɨ moonɨhinɨmo. Jaabadɨro bu uujoho Miyamɨnaafibadɨ Ifiivuubo diito usetɨ ɨdaasuno icaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jaanotɨ ijɨɨbogomɨnaa esafutuuhi Jua Nitɨmɨnaafiditɨ Jesu unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jaadɨ miyamɨnaa iicauhɨgo ɨɨfutuumaaca saafi miyamɨnaafi asaauboro Jesuguiino ememuɨɨvuuboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aivojɨɨbo, taseemeneque dɨdaasugo, ɨdaasuno icahicaabo imimañobatɨ ochoomooboro, fiiva foova cɨɨjɨgaifaño aquetehicaabo, bu teehifaño aquetehicaabo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Jaaboco jino dijɨɨbogomɨnaajaago sɨvarahi. Jaarumo diiboco buheesutɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jaanegui Jesu iimusuuhi: Ɨɨ jeedɨ fɨne imiyaavogotɨno miyamɨnaa jito iimitɨmo, ¿mɨhachuta fɨne amɨɨhaico jaabɨcɨɨboro icaji? nooboro diiboco: Juugavɨ daachico sɨva, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jaaboro Jesu iimitɨno ɨjɨco ɨhɨɨbauboro diibeditɨ iinusuuhi. Jaasumiro diibo isɨcafefi buheetecuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jaadɨ ijɨɨbogomɨnaa ijeevadɨ Jesuma ihiimaaumoro diiboco dilluuhi: ¿Mɨllɨtɨ jana mɨɨhai diibo imitɨno ɨjɨco buhɨ magañɨɨtɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jaanegui diitoco Jesu nuuhi: Amɨɨhai miyaavogo aajashumaño. Miyanotɨro amɨɨhaico neehi, amɨɨhai miyaavogo mostaza noovata tooɨgayɨdɨno iicaruva jigajɨco meneejirahi: Jinootɨ sihɨgovɨ deene, noomoro. Jaaneri sihɨgovɨ jeenejiruno. ¿Conooba amɨɨhaidi sihidɨ jeevajitɨrahi miyaano miyaavogoma mihicaruva? ");
INSERT INTO bmrNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jaanobuunatɨ Galilea jiinɨjeri saamo ɨgomoro efeehicauhɨgo Jesu diitoco nuuhi: Uujoho Miyamɨnaafibadɨ Ifiivuubo miyamɨnaa usefaño acɨcafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jaamo uco gaicaauji. Jaaruubo mifucucɨ, safucu ɨdɨɨnotɨ siino buheeteji, nooboro. Jaanoco uguubuumoro sihidɨ ɨdaasuvuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jaanaa Jesu ijɨɨbogomɨnaama Capernau cuumivɨ ɨɨfutuunaaca templojaguiiha impuestoco ajaadusuhicaumo Pedrojaago ufuumoro diiboco dilluuhi: ¿Amɨɨhai jɨɨbogomɨnaafi templojaguiiha impuestoco jaadujitɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jaaneguiiha Pedro: Jaadujiibo, nuuhi. Jaadɨ Pedro jaahe ɨɨfutuuboco Jesu nuuhi: ¿Simon, ɨɨdi mɨllɨ jiijiinɨje aivojɨto mɨɨco impuestoco jaadusunɨcɨmo; iyotocoro nacu siicuumiotoco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jaaneguiiha Pedro iimusuuhi: Siicuumiotoco, nooboro. Jaaneguiiha Jesu nuuhi: Jaaneguiihacuva icuumioto jaadutatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jaarunofaño mɨɨhaiñooba mɨɨditɨ imitɨno eneejiruneguiiha johono caasifaño foobo difiicɨgaico gañɨɨto. Jaabo itɨconɨ uduuboco dɨɨcɨɨbo iijɨfañotɨ nɨhɨbajeque dɨɨcɨ. Jaajeri daaduto tahimpuestoco, bu diinoco icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jaasumi ijɨɨbogomɨnaa asaaumoro Jesuco dilluvauhi: ¿Cajaanɨ fɨne aivo imiyaabo icaji niqueje aivojɨfaño? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Jaanegui Jesu seemeneque ocoovauboro diitofeenevɨ ificuuboro nuuhi: Miyanotɨro amɨɨhaico neehi, amɨɨhai jeebɨɨco bohonotɨ miminiiyumoro seemenebadɨ miminifototɨhachiijɨ niqueje aivojɨfaño mefeejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mɨɨro niqueje aivojɨfaño imiyaabo iicajiibo oono guiinovɨ ifiico iminiiyuuboro jiisee seemenebadɨ iminifotoobo. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jaanotɨ bu cajaatyohacho seemeneque tamomofañodɨ agaayɨcɨmo uco gaayɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jaanotɨ seeme jino uco imiyaavogomoco imitɨco omoonɨsuvaaboco aivo imijiruno ajashutɨno guiisibatyɨgabari icodaahetɨ uduujenɨmoro muuaifaño iniitusuno. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jiinɨjemɨnaadi imitɨcani icano miyamɨnaaco imitɨfaño agañɨɨsuno. Jaano jillɨ fahiijɨvaro icajino. Jaarunofaño ɨdaasucani icajiibo diibofeenedɨ imitɨ asaabo. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jaaneguiiha dihuse, ditɨhai icano ɨco imitɨfaño agañɨɨsuhachiijɨ quitɨcɨɨbo sihɨ gañɨɨ. Imijiruno ɨɨdi ditɨhaima, dihusema chahaabo fiivofaño ɨdɨɨfotono. Jaanotɨ ɨɨdi imitɨno dihusenema, ditɨhaiñoma icano diicaabo ifinɨjitɨno cɨɨjɨgaifaño agañɨɨcafotono. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jaanotɨ bu oono dihaallɨɨ ɨco imitɨfaño agañɨɨsuhachiijɨ toohaallɨɨco buhudaruubo tehesino gañɨɨ. Imijiruno ɨɨdi sayɨɨmaryo diicaabo fiivofaño ofoono. Jaanotɨ imijitɨruno fahaallɨɨcɨmaryo diicaabo cɨɨjɨgaifaño agañɨɨcafotono. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Tollɨro bu jito seemetɨ saatohobaco mɨtɨɨmejetasudino. Mɨɨro jino amɨɨhaico neehi: Mɨɨro oono diitoco otoomomo Moocaani toomomɨnaa fahiijɨvaro Guihirubi Moocaani niquejefaño iicaabo ɨmefeeneri icahicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mɨɨro uujoho Miyamɨnaafibadɨ Ifiivuubo saahi ɨmɨtacumoco taajasuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Jinooco mɨllɨ mehesɨcɨnɨhi amɨɨhai? Saafi joomɨ ciendɨmo ovejamɨ iicamotɨ saafi imɨtaruva, ¿nacu fɨne saatoho noventa y nuevedɨmo aatyuvomoco tomañovɨ ejeevesuhinɨɨboro ɨmɨtaaboco guiinetejitɨrahi? ");
INSERT INTO bmrNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jaaboco aatyɨmeebere janaanɨcɨ aivo imo imo minifetejiruubo oono noventa y nuevedɨmo ɨmɨtatɨmo janaanɨcɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jaabadɨro amɨɨhai Caani niquejefaño iicaabo imogotɨhi jitotɨ saseba ɨmɨtanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jaanotɨ bu dinahabo ɨco imitɨno omoonɨhachiijɨ diiboma ɨɨro ijeevadɨ diimaabo diiboco gaajasu imitɨno omoonɨnoco. Jaabo ɨco uguubuhachiijɨ diiboco dimijɨɨcarucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jaanotɨ ɨco uguubutɨhachiijɨ sitatɨ cuuhuva miimɨsiicɨtɨ. Jaamo miimɨsiicɨ, saafi ɨdɨɨmo onoono imino igaajacafetequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jaamoco: Jii, onootɨhachiijɨ Moocaani iijamɨnaaco dɨɨbogo. Jaamo onoonoco bu: Jii, onootɨhachiijɨ oono Moocaanico imiyaavogotɨɨboco mihicanɨcɨbadɨ mehesɨcɨnɨ, bu impuesto jaadusumɨnaafico mehesɨcɨnɨcɨbadɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Miyanotɨro amɨɨhaico neehi jino jiinɨjehallɨvɨ mafatyusutɨno, bu tollɨro niquejefaño fatyusurajitɨhi. Jaanotɨ bu jiinɨjehallɨvɨ mafatyusuno niquejefaño fatyusucafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tollɨro bu jino amɨɨhaico neehi: Jino jiinɨjehallɨvɨ amɨɨhaitɨ miimɨsiicɨ mehesamaaimɨsiro mihimogonohallɨvɨ Moocaanico midilluhachiijɨ Guihirubi niquejefaño iicaabo acɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mɨɨro miimɨsiicɨ tamomofeenedɨ igaivomofeeneri bu uujoho icaji. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jaaneguiiha Pedro ufuuboro Jesuco dilluuhi: Aivojɨɨbo, tañahabo uco imitɨno omoonɨnoco, ¿mɨnoodɨfoova uujoho diiboco perdonahicaji, sahuse juugahusetɨ mifoocɨ ɨdɨɨno tɨcovovɨ? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jaaneguiiha Jesu diiboco iimusuuhi: Cha, toonoodɨfoova icatɨno. Janaanɨcɨ setentadɨfoova sietedɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jaamaño niqueje aivojɨ jeevahi oono saafi aivojɨɨbo ijeecɨvomɨnaama idudɨcamaajeque iimibachubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jaabo iimibachunoco jari tɨcovaubaaca diibojaa sɨvaumo saafiico ajashutɨno millones tɨcovovɨ edebeuboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jaabo diiboco ajaadujiruno achahauneguiiha ihaivojɨɨbo tajɨɨbauhi diiboco inaajequi paryɨ mogaima iseemema, bu paryɨ inehejema icano toonoco ijaaduqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jaaneguiiha ijeecɨvomɨnaafi ihaivojɨɨboguiino ememuɨɨvuuboro ihaivojɨɨboco neehicauhi: Aivojɨɨbo, uco dɨdaasugo ɨco paryɨ faneeri jaaduji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jaaneguiiha ihaivojɨɨbo diiboco ɨɨdaasuguuboro idebeque perdonauhi. Jaaboro diiboco sinaayuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jaabo diibo ijeecɨvomɨnaafi ihiinuuboro ufuubo atyɨmeteuhi saafi inahabonɨmɨnaafi diiboco mɨɨdɨno edebeuboco. Jaaboco icodaahetɨ agaayɨcɨuboro sefano dusuucɨubo: Goova daadu uco edebeneque, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jaanegui inahabonɨmɨnaafi iguiino ememuɨɨvuuboro diiboco nuuhi: Uco dɨdaasugo ɨco paryɨ jaaduji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jaarunofaño diibo: Jii, nootɨɨbo ufuuboro diiboco cɨvojafaño jɨɨhacuuhi paryɨ diiboco ajaadutɨnohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jaanoco saatoho aatyɨmeuno diitoco aivono ufuuneguiiha ufuumoro ihaivojɨɨboco paryɨ jɨɨbugutuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jaaneguiiha ihaivojɨɨbo diiboco ucuuhuvauboro nuuhi: Imitɨcani jeecɨvomɨnaafi. Ɨco uujoho didebeque paryɨ perdonahinɨhi uco idilluuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jaabadɨro bu ɨɨjoho dinahabonɨmɨnaafico dɨdaasuguejirahi ɨco uujoho iicahinɨbadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ihaivojɨɨbo sihidɨ ɨsɨfiiratuuboro tajɨɨbauhi diiboco cɨvojafaño ificusuuboro ihaamɨsuqui paryɨ idebeque ajaadutɨnohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jillɨ nooboro Jesu imivusuuhi jibogoco: Jaabadɨ jillɨ Guihirubi niquejefaño iicaabo amɨɨhaico moonɨji amɨɨhai nahaboco amɨɨhai jeebɨɨmaryo meperdonatɨhachiijɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jillɨ Jesu unuunobuunatɨ fuubo Galilea jiinɨjetɨ. Jaabo ɨfutuuhi Judea jiinɨjevɨ, Jordan teehitɨ baagovɨ iicajiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jaabo dojɨcutɨ sihidɨ miyamɨnaa fuuhi. Jahɨgo iguihuvaumoco buheesuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jaanaaca saatoho fariseomɨoto asaaumoro diiboco dilluuhi ɨɨfurumo iimitɨnofaño diiboco igañɨɨsuqui: ¿Nacu fɨne tajɨɨbabadɨ imijiruno mɨɨno taabaco jillɨ siinohallɨtɨ mejeevesuno? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jaaneguiiha diibo iimusuuhi: ¿Nacu amɨɨhai Caatɨnɨhaamefaño onoonoco memeecɨhicatɨhi? Mɨɨro itɨconɨ miyamɨnaafico ifiivusuubo fiivusuuhi gaifiico, bu gaigooco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jaaboro nuubo: Jillɨtɨ gaifi caanico, seejɨco icano jeevesuji mogaima iminifetequi. Jaamɨsi saafiibadɨro minifutucuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jaamaño miimɨsiicɨ icacuutɨno saafi ifibadɨro icacuumɨsi. Jillɨ iicamaño miyamɨnaa dugaacucuujitɨhi Moocaani agataacucuunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jaaneguiiha diiboco dilluumo: ¿Mɨllɨtɨ janabuu Moise tajɨɨbauhi mɨɨno taabaco jeevesuhaameque mahacɨmoro diigoco mejeevesuqui? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jaaneguiiha Jesu nuuhi: Etɨ bu mucuhufojeebɨɨmaño Moise tajɨɨbauhi amɨɨhai taabamɨ jeevesuco. Jaanotɨ itɨconɨ tollɨ icautɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jaanotɨ jino uujoho amɨɨhaico neehi: Mogaico sifiima icatɨgoco ejeevesuuboro sifigooco ɨɨcɨɨbo ajeva imitɨco ɨcɨhi. Jaabadɨro bu sifi ejeevesugooco ataabavaabo ajeva imitɨco ɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jaaneguiiha ijɨɨbogomɨnaa diiboco nuuhi: Jaanegui tollɨ icamaño, ¿collɨhiica bu mataabavajirahi? ");
INSERT INTO bmrNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jaaneguiiha Jesu diitoco nuuhi: Famooro jinooco gaajajitɨrahi. Ɨdɨɨmoro jaatyo Moocaani agaajasumo gaajajirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mɨɨro saatoho ifiivuunotɨro caanimɨ oovɨcɨcubadɨ taabavajitɨɨbo unuubadɨ icanɨcɨhi. Jaanotɨ saatoho iguiraacuneguiiharo tollɨ oovɨcɨnɨcɨhi. Jaanotɨ saatoho jillɨ taabavatɨmo icanɨcɨhi niqueje aivojɨguiinodɨ. Jaamaño jinooco agaayɨcɨgomo jaafa gaayɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jaanaaca Jesujaa seemeque sɨɨvaumo diitohallɨvɨ ihuseque ificuuboro Moocaanima iimaaqui. Jaarunofaño ijɨɨbogomɨnaa ɨɨbahicauhi iseemeque diibojaa ɨsɨvamoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jaarunofaño Jesu nuuhi: Jaafa seeme tajaa saahi fɨne mɨhɨɨbano. Mɨɨro niqueje aivojɨ seemebadɨ iicamono, ");
INSERT INTO bmrNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","nooboro toseehejehallɨvɨ ihuseque ficuhicaubo. Jaadɨ toonotɨ sihɨgovɨ fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jaanaaca saafi sɨcafefi Jesuco emeecɨtuuboro diiboco nuuhi: Idiimiibo Jɨɨbogomɨnaafi, ¿cono iiminoco moonɨjirahi uujoho ifinɨjitɨno fiivoma icaqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jaaneguiiha Jesu diiboco nuuhi: ¿Collɨhi uco idiimiibo neehi? Chahamo imimo ɨdɨɨboro Moocaani imiibo. Jaanotɨ ifinɨjitɨno fiivofaño ofoonoco idiimogohachiijɨ tajɨɨba onoobadɨ diica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jaaneguiiha sɨcafefi diiboco nuuhi: ¿Mɨllɨ nacu noono? nooboro. Jaaneguiiha Jesu diiboco nuuhi: Gaicaaudino, ajevaco moonɨdino, nanivadino, sitaaditɨ sɨcamañooco dɨɨbeguedino, ");
INSERT INTO bmrNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","diicaanico, diiseejɨco icano bocɨgo, sitaaco gaijɨ difiico agaijɨbadɨro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jaaneguiiha isɨcafefi nuuhi: Seemenetɨro uujoho paryɨ tonehejeque imino moonɨhicahi. ¿Cono fɨne siino tahɨme icahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jaaneguiiha Jesu diiboco nuuhi: Aivo idiiminoco idiimogohachiijɨ, foobo paryɨ dinehejeque naajeebe ɨɨdaasumoco daacɨ. Jaadɨ jari niquejefaño sihidɨ nɨihɨbamɨvaji. Jaaboro sihidɨ inɨbɨbamɨma iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jillɨ unuunoco isɨcafefi uguubuuboro ɨɨdaasuvuuboro fuuhi sihidɨ inɨhɨbamɨma iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jaanehuiiha Jesu ijɨɨbogomɨnaaco nuuhi: Miyanotɨro amɨɨhaico neehi, aivo sihidɨ jeevano sihidɨ inɨhɨbamɨma iicamo niqueje aivojɨfaño ofoono. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Siino bu jino neehi: Tɨhɨɨno aivo camello jaanutupaajeri afatyono. Jaano janaanɨcɨ aivo sitɨhɨɨ sihidɨ inɨhɨbamɨma iicaabo Moocaani aivojɨfaño ofoono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jaanoco ijɨɨbogomɨnaa uguubuumoro sihidɨ eetyeuhi. Jaamoro noocasiuhi: ¿Jana cajaatyo fɨne taajajirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jaaneguiiha Jesu diitoco emeecɨɨboro nuuhi: Miyamɨnaa toonoco moonɨjitɨrahi. Ɨdɨɨboro naha Moocaani paryɨ fanoovaaco moonɨjirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jaaneguiiha Pedro diiboco nuuhi: Aivojɨɨbo, mɨɨro paryɨ mɨɨhai monehejeque mejeevesuhinɨmoro didojɨcutɨ masaahi. ¿Jaano jaada nacu jinehejema mihicaji? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jaaneguiiha Jesu diitoco iimusuuhi: Miyanotɨro amɨɨhaico neehi ufucu paryɨ fanoova bohonotɨ eheetavocafotoodɨ uujoho Miyamɨnaafibadɨ Ifiivuubo tahimi aivojɨ icagahallɨvɨ acasɨɨvoodɨ, bu amɨɨhai tadyojɨcutɨ masaamo aivojɨ icaganohallɨvɨ macasicamaaiji, paryɨ Israel cuumimɨnaaco mudugaacuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jaamo paryɨ tahallɨtɨ inehejeque ejeevesumo iijanoco, inahabomɨco, inagomɨco, caanimɨco, seejɨmɨco, mogaimɨco, iseemeque, bu ijiinɨjenehejeque icano ejeevesumo toono jaada sihidɨ janaanɨcɨ gaayɨcɨjimo, tollɨro bu ifinɨjitɨno fiivoco gaayɨcɨjimo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jaanotɨ jisumi oono ajashutɨno sihidɨ ejeevamo iicarumo ufucu guiinovɨ minifeteji. Jaanotɨ jisumi guiinovɨ iicarumo tusumi sihidɨ ejeevamotɨ minifeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mɨɨro niqueje aivojɨ jillɨ jeevahi oono fagui abajaabo omoonɨnɨcɨbadɨ. Mɨɨro ibasutaaco ihɨcɨsuqui fucuro fuubo dudɨcamaajemɨnaaco ɨcɨtuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jaaboro diitoco nuuhi: Safucuo jaadadɨno amɨɨhaico jaaduji, nooboro diitoco ifaguifaño galluubo idudɨcamaaiqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jaanobuunatɨ siino fuubo baagotɨrehiica icaaberi. Jaabo atyɨmeuhi saatohoco tɨcovono goohasiri iicamoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jaamoco nuubo: Amɨɨhai tollɨro tafaguifaño tabasutaaco mɨhɨcɨto. Imino amɨɨhaico jaaduji, nooboro. Jaaneguiiha diito fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jaanobuunatɨ bu siino diibo fuuhi gadɨcɨɨba. Jaadɨ bu siino fuubo ɨmohonohallɨtɨ icacuuberi. Jaabo bu tollɨro moonɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jaanobuunatɨ bu siino fuubo ɨmohonofeenedɨ icacuuberi. Jaabo atyɨmeuhi saatoho tɨcovono iicamoco. Jaamoco nuubo: ¿Collɨhi amɨɨhai jinoovɨ tɨcovono dudɨcamaaitɨmo mihicahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jaaneguiiha diiboco nuumo: ¿Etɨ bu mɨɨjoho mɨɨhaico atajɨɨbatɨneguiiha? noomoro. Jaaneguiiha diitoco nuubo: Amɨɨhai bu tollɨro tafaguifaño mududɨcamaaito, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Jaanaa mihiijɨcuudɨ diibo nuuhi dudɨcamaajemɨnaa aivojɨɨboco: Paryɨ famoocoro coova. Jaaboro diitoco daadu, oono dojɨcutɨ asaamotɨ tɨconɨ. Jaaboro itɨconɨ asaahinɨmovɨ dallɨ baanɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jaaneguiiha tɨconɨubo ɨmohonofeenetɨ iicaaberi ufuumotɨ. Jaamo itɨcovoocɨvɨ gaayɨcɨuhi safucuo jaadadɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jaanobuunatɨ jaaduubo ɨmegavɨ ufuumoco. Jaamo esamaaiuhi: Mɨɨhai fɨne janaanɨcɨ magaayɨcɨji, noomoro. Jaarumo itɨcovoocɨvɨ gaayɨcɨuhi safucuo jaadadɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jaanoco agaayɨcɨumoro iimaafivumo toono abajaabeditɨ: ");
INSERT INTO bmrNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jito dojɨcutɨ agaseme sano nɨhɨba oovoro dudɨcamaaihi. Jaarumoco mɨɨhai tɨcovovɨro daaduhi, mɨɨhai sihidɨ mududɨcamaaimoro sihidɨ aiguucutaco majaabɨcɨmo tɨcovovɨro, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jaarunaa abajaabo saafiico iimusuuhi: Fañɨ, ɨco uujoho imitɨno moonɨtɨhi. Mɨɨro ɨɨjoho safucuo jaadadɨneri uuma dudɨcamaaihivahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jaaneguiiha jino dijaadaco dɨɨcɨɨbo fuucu. Jaanotɨ bu uujoho imeguehi jino dojɨcutɨ asaaboco bu tonoodɨnoro ajaadunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Nacu uujoho iimogobadɨ moonɨjitɨrahi tañɨhɨbamɨco? ¿Nacu ɨɨjoho diimogotɨhi uujoho iimihuseneque? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jaabadɨreji jisumi oono guiinovɨ iicarumo ufucu sihidɨ ejeevamotɨ minifeteji. Jaanotɨ bu sihidɨ ejeevamo jisumi iicarumo ufucu guiinovɨ minifeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jaanaaca Jesu Jerusale jɨɨhairi ufuuhɨgo ijɨɨbogomɨnaa docedɨmo iicamoco ijeevadɨ asatyuuboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Amɨɨhairyo magaajacuhi jino Jerusale cuumijaago mofoonoco. Jahɨgo uujoho Miyamɨnaafibadɨ Ifiivuubo acɨcafeteji sacerdotemɨ aivojɨto usefaño, bu caatɨnɨmɨnaa usefaño icano. Jaamo uco guijevefaño ficuji. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jaamoro siicuumiotoco acɨjimo uco idejecuqui, bu ihaamɨqui icano. Jaamoro ɨmohovɨ tetecujimo icano. Jaaruubo mifucucɨ, safucu ɨdɨɨnotɨ guijevefañotɨ siino buheeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jaanaaca Jesujaago saaugo Jacoobo, Jua icamɨsi Zebedeo seemenetɨsi seejɨ. Jaago illimɨsima asaaugoro Jesuguiino memuɨɨvovauhi siinoco diiboco idilluqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jaaneguiiha diibo nuuhi: ¿Jinejeque dimeguehi? nooboro. Jaaneguiiha diigo nuuhi: Tajɨɨba dihaivojɨfaño jitɨsi taseemenetɨsi dihufocovɨ icasɨɨvequi, saafi dimiyanaagonovɨ, bu saafi dinaninaagonovɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jaarunaa Jesu diitɨsico iimusuuhi: Amɨɨsi magaajatɨhi midillunoco. ¿Nacu amɨɨsi uujoho ɨdaasuno iicajibadɨ mihicajirahi? nooboro. Jaaneguiiha diitɨsi: Jɨɨhɨ, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jaaneguiiha diibo nuuhi: Jɨɨhɨ, miyaano amɨɨsi jino ɨɨdaasunofañodɨ mafatyeji. Jaanotɨ naha oono tamiyanaagonovɨ, tañaninaagonovɨ icano macasɨɨvejinoco, ¿mɨllɨ bu acɨjirahi? Jaatyo ɨdɨɨmocoro Guihirubi acɨji diiteguiiharo ificuhicanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jaanoco sajɨɨbogomɨnaa uguubuumoro diitɨsijaago sɨfiiratuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jaaneguiiha Jesu diitoco ocoovauboro nuuhi: Amɨɨhairyo magaajacuuhi jiinɨjemɨnaa aivojɨto iyotoco sefano atajɨɨbanɨcɨnoco, bu tollɨro saatoho obocɨfimo miyamɨnaaco ɨdaasugotɨmo moonɨfihi. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jaanotɨ amɨɨhai tollɨ mihicajitɨhi. Jillɨro ɨvɨ amɨɨhai miyaavogomɨnaafeenevɨ sihidɨ ejeevaabobadɨ diicaqui, jillɨ saatoho diitotɨ jeecɨvomɨnaafibadɨ miminifoto. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jaanotɨ bu amɨɨhaifeenevɨ imiyaabo iicagoobo saatoho jɨjovonotɨ iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mɨɨro jino uujoho Miyamɨnaafibadɨ Ifiivuubo uco ijeecɨvequi saautɨhi. Jillɨ uujoho ejeecɨvooboro saauhi tafiico aacɨqui ajashutɨmohallɨvɨ diitoco taajasuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jaamo Jerico cuumitɨ iinuumaaca sihidɨ miyamɨnaa Jesu dojɨcutɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jaanaa jɨɨhaijɨniri miimɨsiicɨ ihaallɨɨno ɨɨfuvusuutɨmɨsi gɨcɨnɨuhi. Jaamɨsi Jesu toonodɨ ufuunoco uguubuumɨsiro sefano coovadiivuumɨsi: Aivojɨɨbo, David Iyaachi, mɨsico dɨdaasugo, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jaaneguiiha miyamɨnaa diitɨsico ɨɨbauhi illɨɨvequi. Jaarunofaño janaanɨcɨvɨro sefano coovadiivuumɨsi: Aivojɨɨbo, David Iyaachi, mɨsico dɨdaasugo, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jaanegui Jesu ujulleeveuboro diitɨsico ucuuhuvauboro nuuhi: ¿Mɨllɨ amɨɨsico omoonɨnoco mihimeguehi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jaaneguiiha nuumɨsi: Aivojɨɨbo mahatyɨmeneque mihimeguehi, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jaaneguiiha Jesu diitɨsico ɨdaasuguuboro ihaallɨɨnoco dudɨɨcɨuhi. Jaasumiro aatyɨmeumɨsiro Jesu dojɨcutɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jaamo ɨfuutuuhi Olivohono iicagajɨguiino iicacuumi Betfaje cuumivɨ Jerusale cuumi fiitɨno. Jaamañotɨ Jesu galluuhi miimɨsiicɨ ijɨɨbogomɨnaatɨsico jillɨ nooboro: ");
INSERT INTO bmrNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Juucuumijaago mofoo. Jaacuumivɨ mahatyɨmeji burra duujecɨnɨgo iseemenema icagoco. Jaagoco misinaayumɨsiro uudi mɨsɨva. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jaanotɨ cajaatyohacho amɨɨsico: ¿Mɨllɨ? onoohachiijɨ, Mohaivojɨɨbo eneeneguiiha goovajino uhuumisuno monoo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jillɨ icauno johono Moocaani iimaamɨnaafi acaatɨnɨuno imiyaavequi: ");
INSERT INTO bmrNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sion cuumico jillɨ monoo: Meecɨ oono dihaivojɨɨbo dijaa saahi, oono sɨɨcujeebɨɨba icaabo, burrahallɨri gɨcɨnɨɨbo, burrogayɨhallɨri fiiseta, burro seemenehallɨri, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jaaneguiiha ijɨɨbogomɨnaatɨsi ufuumɨsiro Jesu unuubadɨpi moonɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jaamɨsi iburraco sɨvauhi iseemenema. Jaagohallɨvɨ igaachehunoco ificuumoro Jesuco casɨɨhacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jaanaa sihidɨ miyamɨnaa iicaumo igaachehuneri jɨɨhaico jeebuuhi. Jaanotɨ saatoho jaaɨneri jɨɨhaico jeebuuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jaanaa ɨmegavɨ ufuumo, bu dojɨcutɨ asaaumo icano tɨcovauhi asaagomo: ¡Aivojɨɨbo David Iyaachico mihimo! ¡Imicani Mohaivojɨɨbo memeri asaabo! ¡Moocaanico mihimo! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jaanaa Jesu Jerusale cuumifaño ɨɨfutuudɨ paryɨ tuucuumi miyamɨnaa ñaaɨvuuhi. Jaamoro dillucasihicaumo: ¿Mɨɨjoho fɨne ajaanɨ? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jaaneguiiha neehicaumo: Jesu Moocaani iimaamɨnaafi Galilea jiinɨje cuumi, Nazare cuumioobo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jaadɨ Jesu Moocaani templojafaño jɨcafutuuhi. Jaabo paryɨ toojafaño naajeteque eheetavuumoco isivɨ inuusuubo. Miyamɨnaa nɨhɨbamɨco ubuunanɨhicaumo mesanoco gavaracuubo, bu nimɨihumɨco anaajehicaumo icaganoco gavaracuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jaaboro diitoco nuubo: Mɨɨro Caatɨnɨhaamefaño noono: Taaja Moocaanima iimaajareji, noonoro. Jaarujaco amɨɨhai nanivamɨnaa iijatɨro miminiiyuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jaajafaño diibojaa saaumo aatyɨmetɨmeheje, ɨɨgotɨmeheje icano. Jaamoco buheesuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jaanoco sacerdotemɨ aivojɨto, caatɨnɨmɨnaa icamo sihidɨ ejeevanoco Jesu omoonɨhicaunoco aatyɨmeumoro, bu templojafaño seeme coovadiinamaaiuhi: ¡Aivojɨɨbo David Iyaachico mihimo! noomoro asahaguehicaunoco icano aatyɨmeumoro sihidɨ sɨfiiratuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jaamoro Jesuco nuuhi: ¿Naa guubuuhi jito jillɨ onoonoco? noomoro. Jaanegui Jesu iimusuuhi: Jɨɨhɨ, guubuhi. ¿Nacu amɨɨhai Caatɨnɨhaamefaño toonotɨ ollɨ onoonoco memeecɨtɨhi? Mɨɨro jillɨ noono: Ɨɨjoho deetavehi seeme, bu mɨfañoco aaduseheje imino cahacɨsu masico imasivaqui, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jillɨ nooboro diitoco ejeevesuuboro tuucuumitɨ fuubo Betania cuumijaago. Jaacuumivɨ cɨgaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jaano fucuro Jesu tuucuumijaago siino uhuumiuboco ajeba aivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jaabo atyɨmeuhi higuerahoco jɨɨhaijɨniri icahoco. Jaahoco meecɨturubaaca inoovatama chahauho jillɨ botɨ aamenereu. Jaaneguiiha Jesu toohoco nuuhi: Ufucuro siino noovacuujitɨhi, nooboro. Jaasumiro tooho chuumucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jaanoco aatyɨmeumoro ijɨɨbogomɨnaa sihidɨ jabafiituuhi. Jaamoro diiboco dilluumo: ¿Mɨllɨ jaaho tooho goovacani cheemehi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jaaneguiiha Jesu diitoco nuuhi: Miyanotɨro amɨɨhaico neehi, miyaano miyaavogoma mihicamoro: ¿Nacaha miyaano? nootɨmo mihicahachiijɨ jino uujoho higuerahoco omoonɨbadɨ momoonɨji. Tollɨro bu jiibaɨco meneejirahi: Jinootɨ eedeenenere muuaifaño difoo, munuuruva feejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jaabadɨro bu paryɨɨcɨno Moocaanico midillunoco mimiyaavogohachiijɨ magaayɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jaadɨ Jesu templojafaño ufuuboro jɨɨbeguehicaunaaca diibojaago saaumo sacerdotemɨ aivojɨto, judiomɨ quillahuto icano. Jaamoro diiboco dilluumo: ¿Jineje mityari ɨɨjoho jillɨ moonɨhicahi? ¿Mɨɨjoho ɨco tomityaco acɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jaaneguiiha Jesu diitoco iimusuuhi: Uujoho bu amɨɨhaico tollɨro dilluji. Jaanoco uco mihiimusuhachiijɨ amɨɨhaico neeji comityari jillɨ omoonɨhicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Mɨɨjoho nacu Juaco galluuhi initɨqui? ¿Moocaani, nacu miyamɨnaa? nooboro. Jaaneguiiha sanomɨro iimaacasiumo: Moocaani galluuhi, munuuruva, mɨɨhaico: ¿Collɨhi janabuu mimiyaavogotɨhi? neejiruubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jaanotɨ bu: Miyamɨnaa, munuuruva, mɨɨhaico miyamɨnaa moonɨjirahi. Mɨɨro paryɨ miyamɨnaa miyaaveguehi Jua Moocaani iimaamɨnaafi iicaunoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jaamaño Jesuco: Magaajatɨhi, nuumo. Jaaneguiiha diitoco nuubo: Jɨɨ, jaaneguiiha bu uujoho amɨɨhaico neejitɨhi jineje mityari jillɨ omoonɨnoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jaadɨ Jesu nuuhi: ¿Naa amɨɨhaidi jino mɨllɨ? Saafi seemenetɨsi miimɨsiicɨ icauhi. Jaamɨsitɨ saafiico caani nuuhi: Guihi, tabaacuco dɨɨcɨto, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jaarunaa illi iimusuuhi: Chahano, imogotɨhi, nooboro. Jaaruubo eesamaaiuboro fuuhi ɨɨcɨtuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jaaneguiiha bu caani saafi illijaago ufuuboro tollɨro bu nuuhi. Jaanegui diibo iimusuuhi: Jii, feeji, nooboro. Jaaruubo fuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jaaneguiiha amɨɨhaidi, ¿cajaanɨ fɨne caani iimogonoco eetavuuhi? nooboro. Jaaneguiiha diito nuuhi: Itɨconɨ unuubo, noomoro. Jaaneguiiha Jesu diitoco nuuhi: Miyanotɨro amɨɨhaico neehi, impuesto jaadusumɨnaa, bu ajeva gaigoomɨ icamo Moocaani aivojɨfaño jɨcamaaiji amɨɨhai ɨmegavɨro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mɨɨro Jua Nitɨmɨnaafi: Jillɨ imino mihica, nooboro amɨɨhaico ɨjɨɨbogovaubo. Jaaruuboco mimiyaavuguutɨhi. Jaanotɨ naha impuesto jaadusumɨnaa, bu ajeva gaigoomɨ icamo diiboco miyaavuguuhi. Jaanoco amɨɨhai mahatyɨmecuurumo amɨɨhai imitɨco mejeevesumoro mimiyaavuguutɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jino bu sibogoco muguubu: Fagui abajaabo sihidɨ baacuco abasuuborohallɨdɨ cuhufono meegueuhi, bu jaaboro imahamɨtahojɨco eetavuubo, bu torrehacɨco eetavuubo tohacɨtɨ toonoco iteemequi. Jaaboro tofaguico dudɨcamaajemɨnaaco ificuuboro sihɨ fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jaadɨ toono onoovauno anaamucuudɨ iicojɨmɨnaaco diitojaa galluubo imañoco diibojaago igalluuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jaarumoco tofagui dudɨcamaajemɨnaa diitoco agaayɨcɨumoro saafiico aamɨumo. Jaanotɨ saafiico gaicaaumo, bu saafiico guiisiri aamɨumo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jaaneguiiha ihabajaabo siino galluuhi guiraano itoomomɨnaaco. Jaarumoco idudɨcamaajemɨnaa diitoco itɨconɨomoco omoonɨubadɨro moonɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jaanoma iicaubo illico galluubo: Fɨne achico bocɨguejimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Jaaruuboco aatyɨmeumoro idudɨcamaajemɨnaa noocasiuhi: Jaanɨ paryɨ ibusumijeque agaayɨcɨjiibo. Masɨɨ magaicaauqui. Jaamoro paryɨ jinoma mihicaqui, noomoro ");
INSERT INTO bmrNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","diiboco agaayɨcɨumoro tofaguitɨ buhɨgovɨ asatyumoro gaicaaumo, ");
INSERT INTO bmrNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","nooboro. Unuudɨ Jesu diitoco dilluuhi: Fɨne jaadɨ tofagui abajaabo asaadɨ, ¿mɨllɨ fɨne diitoco moonɨjiibo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jaaneguiiha nuumo: Etɨ bu diitoco agaisiraicɨɨboro sitaaco tofaguifaño ficujiibo ibasuta noovaco onoovano tɨcovovɨ diiboco imañoco ihacɨhicaqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jaaneguiiha Jesu diitoco nuuhi: ¿Nacu amɨɨhai jillɨ Caatɨnɨhaamefaño onoonoco memeecɨhicatɨhi? Mɨɨro jillɨ noono: Guiisiri iijanoco eetavonɨcɨmo imiguiisibaco ɨtɨhɨsumoro gañɨɨhi. Jaarunofaño saafi agaajaabo tobaco dojɨcuvɨro ɨcɨhi toba iminoco agaajamaño. Jaaboro aivo imimaño ficuubo. Jinooco Aivojɨɨbo eetavehi. Jaano mɨɨhaidi aivo sihidɨ jeevahi, noono Caatɨnɨhaamefaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jaaneguiiha jino amɨɨhaico neehi: Amɨɨhaiditɨ Moocaani ihaivojɨco dumɨtɨɨcɨjiibo. Jaaboro sitaaco acɨjiibo diibedi imino iicamoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jaanotɨ bu oono guiisiba onoobatɨ neehi: Cajaatyohacho tobahallɨvɨ aacotomo gafaryunamaaiji. Jaanotɨ toba cajaatyohallɨvɨhacho aacotomoco quicheyɨɨcɨjiiba, nooboro. Jillɨ nuubo Jesu diiboco imiyaavogotɨmoco ufucu omoonɨjinoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jaanoco sacerdotemɨ aivojɨto, bu fariseomɨ icamo Jesu oovɨcɨnoco uguubuumoro gaajacɨumo diiteditɨ tollɨ unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jaamoro diiboco gaayɨcɨujirumo. Jaarumo miyamɨnaaco iguiuhi Jesu Moocaani iimaamɨnaafi iicaunoco imino agaajaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jaadɨ bu Jesu siino tɨcovauhi siinovɨ oovɨcɨɨboro diitoco ɨjɨɨbogoobo jillɨ nooboro: ");
INSERT INTO bmrNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Niqueje aivojɨ jeevahi oono aivojɨɨbo illi taabava jɨɨbaimoco eheetavuubobadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jaabo ijeecɨvomɨnaaco galluubo ɨmogaibɨco aacɨcuumoco ihɨcɨtequi. Jaarunofaño diito imuguutɨhi asaanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jaaneguiiha bu siino saafiico galluubo jillɨ nooboro: Nooto diitoco machuta paryɨ eetavocɨnɨcuuhi. Tañiivɨmɨco gaisiraicɨsucuuhi, bu saatoho ɨdɨɨrɨbasuhicamehejeque icano. Jaano paryɨ imibaicɨnɨcuuhi ijɨɨbaimɨnɨvacuuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Jaarunoco diito ihɨmuhumɨnaa: Jii, nuutɨhi. Jillɨro sihɨgueheje foocɨnɨumo, saafi ifaguinojaago. Jaanotɨ saafi inaajetejaago fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jaanotɨ sanodɨmo ihaivojɨɨbo jeecɨvomɨnaaco agaayɨcɨumoro ahaamɨumoro gaicaauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jaaneri ihaivojɨɨbo sihidɨro ɨsɨfiiratuuboro isoldaomɨco galluuhi diito gaicaaumɨnaaco agaisiraicɨmoro tuucuumije iijanoco ijɨgasuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jaadɨ ijeecɨvomɨnaaco nuubo: Paryɨ jino imibaicɨnɨcuuno mɨjɨɨbaimɨnɨqui. Jaarunofaño jaatyo ɨmuhumɨnaa imitɨmaño saatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jaaneguiiha cuumifeenedɨ imiya jɨɨhaiñeri mofoo mahatyɨmemeque jɨɨbogomoro jɨɨbaimovɨ isaaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jaaneguiiha ijeecɨvomɨnaa miya jɨɨhaiñeri ufuumo igaiyɨɨcɨuhi paryɨ aatyɨmeudɨmoco imihusemehejeque, imitɨmehejeque icano. Jaaneri tooja sihidɨ gahafuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Jaadɨ ihaivojɨɨbo fuuhi ijɨɨbaimoco emeecɨtuubo. Jaabo atyɨmeuhi saafiico, jaaruubo jɨɨbaimo gaachehuco iimogotɨɨboro jɨcafututɨɨboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jaaboro diiboco nuubo: Fañɨ, ¿mɨllɨ jaabo juuga saahi jɨɨbaimo gaachehufaño jɨcafototɨɨbo? nooboro. Jaarunaa diibo iimusuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jaaneguiiha ihaivojɨɨbo ijɨɨcavomɨnaaco nuuhi: Ajaanɨco magaayɨcɨmoro misisɨ itɨhaiñoco, ihuseneque icano. Jaamoro buhɨgo ɨcɨvohɨgo magañɨɨ. Tahɨgo ataajihɨgo, igaiñooco ojɨsujihɨgo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mɨɨro sihidɨ cuuhuvacafetejimo. Jaarumotɨ mɨɨdɨmoro ɨcɨcafeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jaanoma iicamo fariseomɨ ufuumoro iimaacasiuhi diibohallɨvɨ diiboco ɨɨfurumo imitɨno inuusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jaamoro diitoototɨ saatohoco galluumo, sano Herodeotoma. Jaamo ufuumoro Jesuco nuuhi: Jɨɨbogomɨnaafi, mɨɨhai magaajahi ɨɨjoho miyaanoco eneehifinoco, bu tollɨro miyanotɨro ɨɨjoho Moocaanijaa ofoono jɨɨhaico dɨɨbeguehicahi miyamɨnaa ihiimaanoco jeecɨvotɨɨboro. Miyamɨnaaco jillɨ jeebɨɨbatɨro, onootatɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jaaneguiiha jinootɨ mɨɨhaico dinoo: ¿Naa ɨɨdi imino romanomɨ aivojɨɨboco impuestoco majaaduno? ¿Nacu mɨllɨ? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jaarunofaño Jesu diito imitɨno eesamaaiumoro unuunoco agaajacuuboro nuuhi: ¡Bañɨfiiramɨnaa mihicamo! ¿Collɨhi uco imitɨnofaño magañɨɨsujirahi? ");
INSERT INTO bmrNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Eneecata toono impuestoco majaaduhicajeque uco mɨhɨfusu, nooboro. Jaaneguiiha sɨvaumo safucuo jaada tɨcovovɨ ijaada iicajeque. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jaajeque emeecɨuboro Jesu diitoco dilluuhi: ¿Mɨɨjoho ɨme nacu jihɨme, bu jino imomo icano? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jaanegui nuumo: Romanomɨ aivojɨɨbo ɨme, noomoro. Jaaneguiiha Jesu diitoco nuuhi: Diiboco mahacɨ diibono iicanoco. Jaanotɨ Moocaanico mahacɨ Moocaanino iicanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jaanoco diito uguubuumoro sihidɨ eetyeuhi. Jaamoro diiboco ejeevesuumoro fuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tufucuro bu saatoho saduceomɨoto fuuhi Jesuco emeecɨtuumo. Jaamo saduceomɨ uchuumucuumo siino mubuheetejino chahaji, noonɨcɨhi. Jaamaño Jesuco jillɨ nuumo: ");
INSERT INTO bmrNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Jɨɨbogomɨnaafi, Moise tajɨɨbauhi: Saafi ataabavaabo seemevatɨɨboro ochoomohachiijɨ, inahabo ifibaijɨgoco ɨɨcɨɨboro diigoma iseemevaqui inahabobuuna, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jaabadɨ mɨɨhaifeenevɨ iicaumo sahinooto sahuse juugahusetɨ miimɨsiicɨ ɨdɨɨno iicaumo. Jaamotɨ itɨconɨoobo ataabavaubo seemevatɨɨboro guijeveuhi. Jaaneguiiha inahabo ifibaijɨgoco ɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jaabo bu tollɨro icauhi. Jaano allɨvɨoobo bu diigoco ɨɨcɨuboro tollɨro icauhi. Jaabadɨro paryɨ famooro saafigomaryo imivocafutuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jaanobuunatɨ bu diigo tollɨro guijeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jaamo guijevefañotɨ siino ubuheetedɨ, ¿cajaanɨ taabaji? fɨne, paryɨ diito diigoco ataabavacuumaño, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jaaneguiiha Jesu diitoco iimusuuhi: Amɨɨhai aivo magaajatɨhi Caatɨnɨhaame onoonoco magaajatɨhi, bu Moocaani mityaco magaajatɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mɨɨro iguijevecuumo siino ubuheetedɨ taabavacujitɨmo, bu iseemeque tajenɨcɨjitɨmo icano. Jillɨro Moocaani toomomɨnaa niquejefaño iicamobadɨro jeevacujimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jaanotɨ oono uchuumucuumo siino ubuheetejinotɨ neehi: ¿Nacu amɨɨhai memeecɨtɨhi Caatɨnɨhaamefaño Moocaani amɨɨhaico onoonoco? Mɨɨro jillɨ noobo: ");
INSERT INTO bmrNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Uujoho Abraham, Isaac, Jacob icamo Aivojɨɨbo, nooboro. Jaabo Moocaani uchuumucuumo Aivojɨɨbo icatɨno, ubuheeme Aivojɨɨboro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jillɨ unuunoco miyamɨnaa uguubuumoro sihidɨro jabafiituuhi ijɨɨbegueri. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jaabo Jesu saduceomɨco ɨllɨɨnocɨunoco fariseomɨ uguubuumoro igaivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jaamotɨ saafi Caatɨnɨmɨnaafi iicaubo Jesuco ɨɨfuruubo ɨnɨsuubo dilluuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Jɨɨbogomɨnaafi, ¿cono aivo tajɨɨbatɨ aivo obocɨno? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jaaneguiiha Jesu diiboco nuuhi: Dihaivojɨɨbo Moocaanico gaijɨ paryɨ dijeebɨɨmaryo, paryɨ difiimaryo, bu paryɨ dihesamaajemaryo icano, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jino aivo ibocɨma iicano tajɨɨba, aivo imiyaano. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jaano allɨvɨono bu aivo tobadɨro jeevahi. Jano jillɨ neehi: Sitaaco gaijɨ difiico agaijɨbadɨro, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jinoocɨvɨ Moise tajɨɨba tanoocɨnɨhi, bu Moocaani iimaamɨnaa jɨɨbogo tanoocɨnɨhi icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jaamo ifariseomɨ tooneriro iicaumoco ");
INSERT INTO bmrNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesu dilluuhi: ¿Mɨllɨ amɨɨhai mehesɨcɨnɨhi Cristoditɨ? ¿Mɨɨjoho iyaachi fɨne? nooboro. Jaanegui nuumo: David iyaachi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jaaneguiiha Jesu diitoco nuuhi: ¿Jaabo bu mɨllɨ David icaruubo Moocaani Gaijafeenedɨ iimaaubo: Tahaivojɨɨbo, nuuhi? Mɨɨro bu nuubo: ");
INSERT INTO bmrNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Mohaivojɨɨbo Moocaani nuuhi Tahaivojɨɨbo Cristoco: Tamiyanaagonovɨ casɨɨvo ditɨhaiguiino dimɨnaaco uujoho ificuunohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Jaabo bu mɨllɨtɨ Cristo David iyaachi iicajirahi, David iicaruubohacho diiboco: Aivojɨɨbo, unuuno? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jaarunaa diiboco mɨɨhaiñooba ajashuno iimusuutɨhi. Toonotɨro ɨvɨ mɨɨhaiñooba diiboco ajashuno dillucuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jaaboro Jesu ijɨɨbogomɨnaaco, bu miyamɨnaaco icano nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Oono fariseomɨ, caatɨnɨmɨnaa icamo: Moise tajɨɨbaco magaajasuhicano mityama mihicahi, noomoro esɨcɨnɨhicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jaaneguiiha amɨɨhai diito onoonoco: Jii, meneehica. Jaamoro diito onoonoco paryɨ momoonɨhica. Jaarumo iicabadɨ mihicadino. Diito: Imino mihica, nuurumo imitɨno icahicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mɨɨro sihidɨ jeevanoco miyamɨnaahallɨvɨ ficuhicamo miyamɨnaa imoonɨqui. Jaarumo diitoco ajashunogayɨ amusuhicatɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jillɨ miyamɨnaa ihatyɨmequiro fanoovaaco moonɨhicamo. Mɨɨro imeguehicamo ihɨmecunohallɨdɨ, bu ihusequejenehallɨdɨ icano satyehicamo gaachehubaryunohallɨvɨ tajɨɨba onoonoco acaatɨnɨnehejeque, bu gaachehunoco jɨcamaaihicamo fanoovano janaanɨcɨvɨ ifallahino acaamovonoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jaamoro bu imeguehicamo jɨɨbaimonofaño aivo iimimañejeri iicanoco, bu sinagogajanofaño imiya icaganofaño ɨgɨcɨnɨnoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bu tollɨro cuuminofaño diitoco miyamɨnaa aivo bocɨgomoro idillunoco imeguehicamo, bu diitoco: Gaajamɨnaa, onoonoco imeguehicamo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jaanotɨ ɨvɨ amɨɨhai mihimeguedino amɨɨhaico miyamɨnaa: Gaajamɨnaa, onoonoco. Mɨɨro samɨnaaro amɨɨhai ɨdɨɨboro amɨɨhai gaajamɨnaafi Cristo. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bu jiinɨjehallɨvɨ mɨɨhaiñoobaco: Caani, meneedino, ɨdɨɨboro amɨɨhai Caani niquejefaño iicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bu mihimeguedino amɨɨhaico saatoho: Aivojɨɨbo, onoonoco. Mɨɨro ɨdɨɨboro amɨɨhai Aivojɨɨbo Cristo. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sitaaco ejeecɨvoobo amɨɨhaifeenevɨ diibo aivo sihidɨ ejeevaabo. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mɨɨro: Uujoho sihidɨ jeevahi, onoobo guiinonɨcafeteji. Jaanotɨ: Sihidɨ jeevatɨhi, onoobo sihidɨ jeevano miniiyucafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jaanotɨ ɨdaasucani amɨɨhai fariseomɨ, caatɨnɨmɨnaa icamo mihicaji. Bañɨfiiramɨnaa mihicamo. Mɨɨro amɨɨhai niqueje guhugaco cuhufono mafabaacuhicahi sita tahɨ jɨcafototɨmo iicaqui. Bu amɨɨhai mɨjɨcafetehicatɨhi, bu ɨjɨcafetejirumoco mɨjɨcafutusuhicatɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ɨdaasucani amɨɨhai fariseomɨ, caatɨnɨmɨnaa icamo mihicaji. Bañɨfiiramɨnaa mihicamo. Mɨɨro gaigoomɨ fibaijɨto iicamo iijanooco mudumɨtɨɨcɨhicahi. Jaamoro jillɨ ɨɨfurumo Moocaanima gueenene mihiimaahicahi. Jaamaño amɨɨhai aivo guiraano mahaamɨcafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ɨdaasucani amɨɨhai fariseomɨ, caatɨnɨmɨnaa icamo mihicaji, bañɨfiiramɨnaa mihicamo. Amɨɨhai jiinɨjeneri, muuaiñeri icano tehesino mɨhɨguehicahi saatohoco mɨhɨcɨmoro amɨɨhai iijɨco mɨjɨɨbeguequi. Jaamoco mahatyɨmesumi aivo diitoco amɨɨhai imitɨ janaanɨcɨvɨ meheetavehicahi cɨɨjɨgaifaño ifeequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ɨdaasucani amɨɨhai mihicaji agaajatɨno jɨɨbogomɨnaa, aatyɨmetɨmo sɨɨgomɨnaabadɨ mihicamo meneehicahi: Saatoho temploja momofañodɨ: Aivo miyaano, onoono, toono sihidɨ jeevatɨhi. Jaanotɨ naha toojao orofañodɨ: Aivo miyaano, onoono, toono naha aivo sihidɨ jeevahi, meneehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gaajatɨcanimo, amɨɨhai aallɨɨnoma machahamobadɨ mihicamo. ¿Cono nacu aivo imiyaano, oro, nacu itemploja ihoroco Moocaanidi iimibachuno? ");
INSERT INTO bmrNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tollɨro bu meneehicahi: Saatoho jeecɨvojɨcɨcɨfañodɨ: Aivo miyaano, onoono sihidɨ jeevatɨhi. Jaanotɨ naha tojɨcɨcɨfaño iicano ijeecɨvofañodɨ: Aivo miyaano, onoono toono naha sihidɨ jeevahi, meneehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gaajatɨcanimo, amɨɨhai aatyɨmetɨmobadɨ mihicamo tollɨ meneehicahi. ¿Cono nacu aivo imiyaano ijeecɨvo, nacu ifajɨcɨcɨ ijeecɨvoco Moocaanidi iimibachuno? ");
INSERT INTO bmrNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mɨɨro tojɨcɨcɨfañodɨ: Miyaano, onoobo, bu tojɨcɨcɨfaño iicanomaryo bu neehi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jaabadɨro bu templojafañodɨ: Miyaano, onoobo, bu Moocaani toojafaño iicaabofañodɨ bu neehi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jaabadɨro bu niquejefañodɨ: Miyaano, onoobo, bu toojefaño Moocaani aivojɨ icagafañodɨ neehi, bu togafaño ɨgɨcɨnɨɨbo Moocaanifañodɨ neehi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jaamaño ɨdaasucani mihicaji amɨɨhai fariseomɨ, caatɨnɨmɨnaa icamo. Bañɨfiiramɨnaa mihicamo. Amɨɨhai Moocaani onoobadɨ diiboco paryɨ mahacɨhicahi mentahiibai aamenegayɨmaryo, bu anisiibai aamenegayɨmaryo, bu cominohiibai aamenegayɨmaryo icano. Jaarumo tajɨɨbatɨ aivo imiyaano onoonobadɨ momoonɨhicatɨhi. Jaano jino toono imi ica, ɨdaasugo, miyaavogo icano. Jinooco aivo momoonɨjirahi sanoocoro momoonɨnoguiinodɨ siino jeevesutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Amɨɨhai aatyɨmetɨmobadɨ mihicamo saatohoco mɨsɨɨguehicamo jootobaco magañɨɨmoro guiraaruubo camelloma mafaayɨhicahi amɨɨhai jeebɨɨfaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ɨdaasucani mihicaji amɨɨhai fariseomɨ, caatɨnɨmɨnaa icamo: Bañɨfiiramɨnaa mihicamo, guirihillunoco, butajeneque icano allɨcoro minitɨhicahi. Jaarumo amɨɨhai jeebɨɨfaño sano nanivariro magahafɨcɨnɨhi, fanoova imogori magahafɨcɨnɨhi, icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseomɨ amɨɨhai aallɨɨnoma machahamobadɨ mihicamo amɨɨhai jeebɨɨnoco minitɨ itɨconɨ oono guirihillunoco, butajeneque icano fañooco minitɨnɨcɨbadɨ. Jaadɨ jari bu amɨɨhai allɨomo imiteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ɨdaasucani amɨɨhai mihicaji fariseomɨ, caatɨnɨmɨnaa icamo: Bañɨfiiramɨnaa mihicamo, cɨɨhojɨhallɨ imino iimibachucɨnɨbadɨ mejeevamo. Mɨɨro allɨohojɨ imino imibachucɨnɨrahi. Jaaruno fañoohojɨ ɨdicuno uchuumucuumo bacɨnoma fanoo ɨdicu gahafɨcɨnɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jaabadɨ amɨɨhai mejeevahi. Jillɨ amɨɨhai allɨotoro miyamɨnaa ɨmefeenevɨ imimobadɨ mejeevahi. Jaarunofaño amɨɨhai jeebɨɨfaño sano bañɨfiiraro gahafɨcɨnɨhi, bu sano imitɨro gahafɨcɨnɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ɨdaasucani amɨɨhai mihicaji fariseomɨ, caatɨnɨmɨnaa icamo: Bañɨfiiramɨnaa mihicamo. Amɨɨhai Moocaani iimaamɨnaaɨvɨ cɨɨhojɨnoco mihimibachumoro allɨco minicuhicahi. Jaamoro deecanoco mificuhicahi imihuseuno miyamɨnaa cɨɨhojɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jaamoro jillɨ meneehicahi: Mɨɨhai sɨɨcɨje moheedetemɨhai iicausumi mihicauruva jino Moocaani iimaamɨnaaco agaicaaumobadɨ mihicaujitɨrahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tollɨ monoomaño amɨɨhai Moocaani iimaamɨnaaco agaicaaumo iyaachimɨhai mihicanoco magaajasuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jaaneguiiha suufenɨtɨmo momoonɨ oono amɨɨhai eedeetemɨhai ɨtɨconɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Amɨɨhai jiinimomɨ, jiinimomɨ cuumiotobadɨ mihicamo. ¿Mɨllɨ mataajaji cɨɨjɨgaifaño agañɨɨjinotɨ? ");
INSERT INTO bmrNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tooneguiiha amɨɨhaijaago uujoho galluuji Moocaani iimaamɨnaaco, gaajamɨnaaco, jɨɨbogomɨnaaco icano. Jaamoco amɨɨhai saatohoco magaisiraicɨji, bu saatohoco ɨmohovɨ metetecuji. Jaanotɨ bu saatohoco sinagogajanofaño mahaamɨji. Jaamoro diitoco siicuumitɨ, siicuumitɨ icano mubucasiji. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jaamaño amɨɨhaihallɨvɨ icajino paryɨ imifiiuno miyamɨnaaco agaisiraicɨuno tɨɨjoho jaada, Abel guijevetɨ ɨtɨcovano Zacariaco Berequia achico iguijenɨunovɨ. Mɨɨro amɨɨhai diiboco magaicaauhi templojafaño iimimaño, jeecɨvomaño icanofeeneo situvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Miyanotɨro jino amɨɨhaico neehi, paryɨ diito jaada jisumio miyamɨnaahallɨvɨ minifeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusale cuumi, Jerusale cuumi, amɨɨhai Moocaani iimaamɨnaaco agaicaauficuumi, bu Moocaani amɨɨhaijaago jɨɨbogomɨnaaco agalluumoco guiisibaneri mahaamɨfihi. Jaanotɨ uujoho fahiijɨvaro imeguehicahi tuucuumi seemeque tajaagovɨ iigaiyɨɨcɨnoco oono catava iseemeque ijɨjecuguiino iigaiyɨɨcɨnɨcɨbadɨ. Jaarunoco amɨɨhai mihimeguehicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Eneecau bu magaaja amɨɨhai iijano jihovonedi fiiveteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jino amɨɨhaico neehi: Uco siino mahatyɨmecujitɨhi jari johono uco: Imicani Aivojɨɨbo momofeenedɨ asaabo, meneejifucu agasedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jaanaa Jesu templojafañotɨ ihiinuuboro ifeequi moonɨubojaago ijɨɨbogomɨnaa asaaumoro diiboco ɨfusuuhi temploja guiisibanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jaaneguiiha Jesu diitoco nuuhi: Memeecɨ paryɨ tonehejeque. Miyanotɨro amɨɨhaico neehi: Jimañeri chahajino sababa guiisiba sibahallɨdɨ, sibahallɨdɨ icano. Paryɨ faneeri finɨjino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jaadɨ fuumo Olivohono iicagajɨvɨ. Jahɨgo Jesu gɨcɨnɨubojaago ijɨɨbogomɨnaa ufuumoro toovono dillutuuhi: Mihimeguehi mɨɨhaico ɨdɨɨbogonoco ¿cusumi fɨne tollɨ icajino? ¿Mɨllɨ magaajaji ɨɨjoho siino asaajinoco, bu jiinɨje ifinɨjinoco icano? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jaaneguiiha Jesu diitoco nuuhi: Mehesɨcɨnɨ mɨɨhaiñooba amɨɨhaico bañɨdino. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ajashujitɨmo tamomofañodɨ asaano: Uujoho Cristo, noomoro. Jaamoro sihidɨ miyamɨnaaco bañɨjimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bu mɨnaano icaji juuga, jahɨgo icano. Jaarunotɨ mihiguetedino, mɨɨro tollɨ icajino. Jaaruno toono jiinɨje ifinɨjino icatɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tusumi siijiinɨjeoto siijiinɨjeotoma moonɨcasiji, bu siicuumioto siicuumiotoma moonɨcasiji icano. Jaasumi ajebano icaji, sihidɨ guihuvano icaji. Jaabadɨro bu jiinɨje maryɨbaji fahɨgovavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jaano jino ɨdaasuhiica ɨtɨcovajino. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jaasumi amɨɨhaico acɨjimo ɨdaasuno momoonɨcafetequi, bu amɨɨhaico gaicaaujimo. Paryɨ jiinɨjemɨnaa amɨɨhaico jɨɨheveji tahallɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jaasumi ajashutɨmo saatoho imiyaavogoco jeevesuji. Jaamoro jɨɨhevecasijimo, bu fahɨgovavɨ inahabomɨco ɨdaasuno moonɨsujimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bu sihidɨ bañɨmɨnaa icaji: Mɨɨhai Moocaanifañodɨ mihiimaahi, noomoro ajashutɨno miyamɨnaaco bañɨjimo. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jaano sihidɨ imitɨ iicaneri fahɨgovavɨ gaijɨcasijitɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jaarunofaño quehecuno imiyaavogofaño icaaboro nijequevɨ ɨɨfotoobo taajaji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jaanotɨ jino aivojɨ jɨɨbogo iimibogo fanoojiinɨjeriro jɨɨbogocafeteji. Jaadɨ jari jiinɨje finɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mɨɨro Moocaani iimaamɨnaafi Daniel caatɨnɨuhi: Jaadi ɨdicuno imitɨno omoonɨɨboro ifinɨsujiibeditɨ. Jaano iimimañovɨ ɨɨfutucuunoco mahatyɨmedɨ jihaamefaño onoonoco mɨhɨɨfɨnɨcɨhicamo magaaja. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jaamoro Judeari mihicamo ifabaɨjaagovɨ magaa. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jaanotɨ bu amɨɨhai iijahallɨri mihicamo fañoojavɨ mefeedino siinoco mɨhɨcɨqui. Toonotɨro magaacu. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jaanotɨ bu faguifaño iicamo muhuumidino amɨɨhai gaachehuco mɨhɨcɨvamo. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jaanotɨ ɨdaasucani icajimo gaigoomɨ tusumi oovato iicamo, bu mɨfañotɨo seehejema iicamo icano. ¿Mɨllɨ bu goovano gaajirumo? ");
INSERT INTO bmrNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jaaneguiiha Moocaanico midillu: Amɨɨhai magaajifucu jɨɨnijafucu icadino, bu jaguisɨfucu icadino icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mɨɨro jino sihidɨ ejeevano ɨdaasu icaji eedeevɨ jiinɨje ifiivuunotɨro achahanɨcɨno, bu siino ufucuro achahacujino icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jaarunoco Moocaani gueenene icasujitɨhi gueenene iicaruva tusumi iicajimotɨ mɨɨhaiñooba ataajajitɨruneguiiha. Jaanotɨ diibo ɨɨcɨcuumo gaijɨrari toono ɨdaasuno gueenene icasujitɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jaasumi amɨɨhaico saatoho neeji: Memeecɨ jaanɨ Cristo, memeecɨ jaadi Cristo, onoodɨ: Miyaano, meneedino. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mɨɨro saajimo bañɨmɨnaa: Uujoho Cristo, noomoro, bu: Uujoho Moocaani iimaamɨnaafi, noomoro. Jaamoro sihidɨ ejeevanehejeque ɨɨfusujimo miyamɨnaaco ibañɨqui, bu tollɨro Moocaani ɨɨcɨmoco bañɨjirumo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tooneguiiha jino amɨɨhaico ɨmegavɨro nuucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jaaneguiiha amɨɨhaico: Memeecɨ johono sɨcaihɨgotɨ saabo, onoodɨ memeecɨtedino. Jaanotɨ bu: Juuga jino mecufaño icaabo, onoodɨ mimiyaaveguedino. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jaanotɨ uujoho Miyamɨnaafibadɨ Ifiivuubo asaajino jillɨ jeevaji; oono sisi anamebano aamɨjɨtɨ nijequevɨ aachɨcɨnɨcɨbadɨ icajino. Jaanoco faaboho miyamɨnaafi atyɨmeji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mɨɨro chuumuhu iicahɨgo añɨmɨ igaivefihi. Jaabadɨ niinofucuuvɨ imiyaavogotɨmoco ɨdaasuno ɨfeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jaano toono ɨdaasuhicafucuje afatyonobuunatɨro cuujeo nɨhɨba jabaaveji, bu fucuo nɨhɨba achɨcɨcujitɨhi, bu meecɨrɨ niquejefañotɨ aifeji, bu niquejefaño iicano sefano maryɨbaji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jaadɨ naha jarihiica ɨɨfuvusujino uujoho Miyamɨnaafibadɨ Ifiivuubo asaajino. Jaaneri paryɨ bu jiinɨje cuuminomɨnaa ataacasimoro atyɨmejimo uujoho Miyamɨnaafibadɨ Ifiivuubo niqueje aimuufairi sihidɨ mityano, ovosɨɨno asaanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jaaboro tatyoomomɨnaaco galluuji paryɨɨcɨno fanoojiinɨjetɨ tatya iicamoco mɨriicu sefano ojɨdɨ iigaiyɨɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jaaneguiiha oono higuerahotɨro magaaja; mɨɨro ficaba ifiitɨcusumi bohono aamevafiho. Jaanotɨ magaajanɨcɨhi ficaba ifiitɨcunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jaabadɨro bu paryɨ jineheje iicacuudɨ magaajacu finɨfucu ifiitɨcunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Miyanotɨro amɨɨhaico neehi: Paryɨ jillɨ icajino tusumio miyamɨnaa guijevetɨnaacaro. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Niqueje, bu jiinɨje icano finɨji. Jaanotɨ taajɨ ufucu finɨjitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jaaruno jiinɨje ifinɨjifucuco mɨɨhaiñooba ajashuno gaajatɨhi Moocaani toomomɨnaa icarumo, bu uujoho Moocaani Seemene icaruubo icano, Ɨdɨɨboro Moocaani tufucuco gaajahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mɨɨro johono Noe iicausumi iicaubadɨro icajino uujoho Miyamɨnaafibadɨ Ifiivuubo asaano. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mɨɨro toodɨhivɨ johono nɨfaiba chahaunaacahiica miyamɨnaa machumoro, adumoro, bu taabavamoro, illemɨhaico tajenɨmoro icano icahicauhi. Jaanaaca Noemɨ imeenegafaño jɨcafutuuhi; ");
INSERT INTO bmrNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jaamo gaajacɨutɨmoco nɨfaiba macanɨsuuhi famoocoro. Jaabadɨreji bu tollɨro uujoho Miyamɨnaafibadɨ Ifiivuubo asaadɨ icajino. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jaasumi miimɨsiicɨ gaifiimɨsi bajɨfaño iicaji. Jaamɨsitɨ saafi imiyaaveguehicatɨɨbo satyocafeteji diiboco sihidɨ jeevano ɨdaasuno imoonɨqui. Jaanotɨ saafi imiyaavogoobo fitafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jaabadɨro bu miimɨfeecɨ icaji acaasumɨfe. Jaamɨfetɨ saafigo imiyaaveguehicatɨgo satyocafeteji diigoco sihidɨ ɨdaasuno imoonɨqui. Jaanotɨ saafigo imiyaavogogo fitafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jaaneguiiha amɨɨhai mehesɨcɨnɨmoro motoomo gaajaratɨno cusumihacho Aivojɨɨbo saaji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jaanegui jinooco magaaja. Iija abajaabo, nanivamɨnaafi fucu toonotɨ icaaberi asaajinoco igaajaruva cɨgatɨɨbo icajiruubo iijaco afaayɨcɨmoro nanitɨmo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaabadɨro bu amɨɨhai mihimibaicɨnɨ. Mɨɨro mehesɨcɨnɨtɨnaacaro uujoho Miyamɨnaafibadɨ Ifiivuubo saaji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jaaneguiiha imino jeecɨvomɨnaafi agaajaaboco ihaivojɨɨbo iijamɨnaaco tuumusuhinɨnɨcɨhi imino machutaaco diitoco ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jaabo imicani icajiibo ihaivojɨɨbo onoonoco imino omoonɨɨbovɨ ihaivojɨɨbo agaseebe. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Miyanotɨro amɨɨhaico neehi, diiboco ihaivojɨɨbo ficuji paryɨ inehejema iijamɨnaa toomomɨnaafitɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jaanotɨ saafi imitɨɨbo: Tahaivojɨɨbo goovajitɨno asaano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Saatohoco ahaamɨɨboro jillɨ tɨcovono guiriicavomɨnaama aaduuboro, amachuuboro icaabaaca ");
INSERT INTO bmrNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","gaajacɨratɨno ihaivojɨɨbo gaseji. ");
INSERT INTO bmrNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jaaboro diiboco sihidɨ jeevano ɨdaasuno moonɨji, bu oono bañɨmɨnaaco omoonɨjibadɨro. Jahɨgo ataacasimoro igaiñooco oojɨsujihɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mɨɨro niqueje aivojɨ jeevahi fahuseecɨdɨmo bagocajamɨ icɨɨjɨgaimeecunoco ɨɨcɨumoro fuuhi taabava jɨɨbaimojaago ataabavaaboco inahabonɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jaamotɨ sahusedɨfigova imino imibaivuutɨhi. Jaanotɨ sahusedɨfigova imino imibaivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jaamo imino iimibaivuutɨmo siino icɨɨjɨgaimeecunoco ifañonɨqui satyuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jaanotɨ imino iimibaivuumo icɨɨjɨgaimeecunofaño ifafaihunoco satyuuhi, bu botellanofaño satyuumo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jaarunaa ataabavaujiibo goovano agaseutɨmaño diitoco cɨgara aivuuneguiiha cɨgacuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jaanaaca fucufeenevɨ guubuvusuuno sefano unuuno: ¡Saacuubo taabavamɨnaafi mutuumutucu! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jaaneguiiha paryɨ tobagocajamɨ agañiivuumoro icɨɨjɨgaimeecunoco nɨfutusuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jaanaaca iimibaivuutɨfigueheje oono iimibaivuufiguehejeque nuuhi: Mɨɨhaico amɨɨhai cɨɨjɨgaifaihunotɨ ajashunogayɨ mahacɨ. Jino mocɨɨjɨgaimecuno jabaacamaaicuuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jaarunofaño iimibaivuufigueheje diitoco iimusuuhi: Chahano, mɨɨhaidi ɨɨfetejitɨruno, bu amɨɨhaidi ɨɨfetejitɨruno icano. Amɨɨhairyo mofoomoro amɨɨhaiñotɨ manaajete, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jaaneguiiha sahusedɨmo iimibaivuutɨmo cɨɨjɨgaifaihutɨ inaajequi ufuunobuujɨnaago taabavamɨnaafi gaseuhi. Jaaboma iimibaivucuumo toojafaño jɨcafutuuhi igaasequi. Jaadɨ iguhugaco fabaacucuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jaanobuunatɨ saafigova agaseumoro nuuhi: Aivojɨɨbo, aivojɨɨbo, mɨɨhaico faayɨcɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jaarunaa diibo diitoco iimusuuhi: Miyanotɨro uujoho amɨɨhaico gaajatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jaaneguiiha jino uujoho amɨɨhaico neehi: Cɨgatɨmo mehesɨcɨnɨ, gaajaratɨno uujoho Miyamɨnaafibadɨ Ifiivuubo asaajifucu. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mɨɨro niqueje aivojɨ jeevahi saafi miyamɨnaafi siijiinɨjevɨ ifeequi ijeecɨvomɨnaaco ucuuhuvauboro inɨhɨbamɨco diitoco ificusuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Diitotɨ saafiico cinco mildɨjeva acɨubo. Jaanotɨ sifiico acɨubo dos mildɨjeva. Jaanotɨ saafiico mildɨjeva acɨubo. Diitoco itɨcovoocɨvɨ acɨubo isefadɨno sahaje. Jaaboro fuucuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jaanobuuna cinco mildɨjevaaco agaayɨcɨubo tooneri naajeteque eetavuuhi. Jaaneri ɨɨcɨubo siino tonoodɨnoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jaabadɨro bu dos mildɨjevaaco agaayɨcɨubo tollɨ omoonɨuboro, bu tonoodɨnoro siino gaayɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jaanotɨ mildɨjevaaco agaayɨcɨubo ufuuboro jiinɨjeque eseediuboro ihaivojɨɨbo nɨhɨbamɨco ficuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Jaanobuunatɨ goovacuutɨnotɨ siino diito aivojɨɨbo gaseuhi. Jaaboro diitoma toonoco imibachuvaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tɨconɨubo oono cinco mildɨjeva aacɨubotɨ. Jaabo ihaivojɨɨboco acɨuhi diez mildɨjevaaco: Aivojɨɨbo, uco daacɨuhi cinco mildɨjeva. Jaaneri jino siino tonoodɨnoro ɨɨcɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jaaneguiiha ihaivojɨɨbo diiboco nuuhi: Aivo imino moonɨhi. Ɨɨjoho aivo imino jeecɨvomɨnaafi idiimihuseebe. Mɨɨdɨrunoco imino omoonɨmaño ɨco siino janaanɨcɨ acɨji. Jaaneguiiha disaa. Jaabo uuma imo imo diicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jaanobuunatɨ gaseubo dos mildɨjeva bu agaayɨcɨubo. Jaabo nuuhi ihaivojɨɨboco: Aivojɨɨbo, uco dos mildɨjeva daacɨuhi. Jino jaaneri siino tonoodɨnoro ɨɨcɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jaaneguiiha ihaivojɨɨbo nuuhi: Aivo imino moonɨhi. Ɨɨjoho aivo imino jeecɨvomɨnaafi idiimihuseebe. Mɨɨdɨrunoco imino omoonɨmaño ɨco siino sihidɨ acɨji. Jaaneguiiha disaa. Jaabo uuma imo imo diicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jaanotɨ mildɨjeva agaayɨcɨubo agaseuboro ihaivojɨɨboco nuuhi: Aivojɨɨbo, ɨɨjoho sihidɨ edeevanoco uujoho gaajahi. Mɨɨro ɨɨjoho sihinɨcɨhi abasutɨruhɨgotɨ, bu tollɨro nɨhɨbamɨco dɨɨcɨnɨcɨhi ududɨcamaaitɨruhɨgotɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jaamaño ɨco ɨñɨhicugooboro dinɨhɨbamɨco jiinɨjefaño cɨɨjehinɨhi. Jaano jino paryɨ faneeri dinɨhɨbamɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jaaneguiiha ihaivojɨɨbo diiboco iimusuuhi: Ɨɨjoho agaiquiibo idiimitɨno jeecɨvomɨnaafi, ɨɨro gaajacuuhi uujoho abasutɨruhɨgotɨ isihinɨcɨnoco, bu ududɨcamaaitɨruhɨgotɨ nɨhɨbamɨco ɨɨcɨnɨcɨnoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jaaneguiiha, ¿collɨhi jana tañɨhɨbamɨco dusisutɨhi? Jaabo uujoho asaadɨ toonohallɨvɨ janaanɨcɨvɨ siino agaayɨcɨjirunaaca, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","tooneri iicaumoco nuubo: Diibeditɨ mudumɨtɨɨcɨ inɨhɨbamɨco. Jaamoro oono diez mildɨjevama iicaaboco mahacɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mɨɨro sihidɨ iicanoma iicaaboco siino janaanɨcɨ acɨjiibo sihidɨ icanoma iicaqui. Jaanotɨ chahanoma iicaabotɨ oono mɨɨdɨno iicarunoco dumɨtɨɨcɨjiibo. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jaanotɨ ajaanɨ imitɨno jeecɨvomɨnaafico magaayɨcɨmoro buhɨgo ɨcɨvohɨgovɨ magañɨɨ. Tahɨgo ataaboro igaiñooco oojɨsujihɨgo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jaadɨ uujoho Miyamɨnaafibadɨ Ifiivuubo Moocaani toomomɨnaama Aivojɨɨbotɨ iicavaabo asaaboro tahimi aivojɨ icagahallɨvɨ casɨɨveji. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jaadɨ paryɨ jiinɨjemɨnaa tahɨmefeenevɨ igaiveji. Jaamoco uujoho dugaacuji, oono ovejamɨ toomomɨnaafi ovejamɨco cabramɨditɨ sihɨgovɨ udugaacunɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jaaboro tahovejamɨco tamiyanaagonovɨ ficuji. Jaanotɨ cabramɨco tañaninaagonovɨ ficuji. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jaadɨ uujoho Aivojɨɨbo neeji tamiyanaagotoco: Juugavɨ masaa. Amɨɨhai Guihirubi amɨɨhaico imino omoonɨmo jino tahaivojɨfaño mɨjɨcafoto sɨɨcɨje jiinɨje ifiivuunotɨro amɨɨhaidi eheetavuunofaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mɨɨro ajebavauboco uco machutaatɨ mahacɨuhi, bu adufirari iicauboco mihisuuhi, bu siicuumioobobadɨ amɨɨhaifeeneri iicausumi uco amɨɨhai iijafaño magaayɨcɨuhi, ");
INSERT INTO bmrNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","bu tagaachehuma achahauboco uco magaachehunɨuhi, bu iguihuvauboco uco memeecɨtuuhi, bu cɨvojafaño iicauboco uco memeecɨtuuhi icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jaadɨ uco iimimo dilluji: Aivojɨɨbo, ¿nacu cusumi ajebari idiicauboco ɨco mɨɨhai mamachusuuhi? ¿Bu cusumi adufirari idiicauboco ɨco mɨɨhai mihisuuhi? ");
INSERT INTO bmrNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bu cusumi nacu siicuumioobobadɨ idiicauboco ɨco mɨɨhai moojafaño magaayɨcɨuhi? ¿Bu cusumi ɨco sɨcaibo diicaaboco magaachehunɨuhi? ");
INSERT INTO bmrNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bu cusumi nacu ɨco guihuvauboco mahatyɨmeumoro mabaauhi? ¿Bu cusumi ɨco cɨvojafaño diicauboco mabaajeuhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jaamoco uujoho Aivojɨɨbo diitoco jillɨ iimusuji: Miyanotɨro, amɨɨhaico neehi: Imiyaavogomoco sihidɨ jeevatɨrumoco tollɨ momoonɨumaño, uco tollɨ momoonɨuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jaadɨ bu tañaninaagonovɨ iicamoco neeji: Uutɨ buhɨgovɨ miminifoto imitɨno monoocɨnɨcumo cɨɨjɨgaifaño mofoo Satanasguiiha, bu paryɨ ihɨjɨmɨguiiha icano eheetavunofaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mɨɨro ajebavauboco uco mamachusuutɨhi. Adufirama icauboco uco mihisuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bu siicuumioobobadɨ amɨɨhaifañodɨ ɨɨguusumi uco amɨɨhai iijafaño majaahevesutɨhi. Bu agaachehuvautɨɨboco uco gaachehutɨ mahacɨutɨhi. Bu iguihuvauboco, bu cɨvojafaño iicauboco icano uco mabaautɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jaanoco diito iimusuji: Aivojɨɨbo, ¿cusumi nacu ɨco ajebama diicaaboco, bu adufirama diicaaboco, bu siicuumioobobadɨ diicaaboco, bu gaachehuma chahaaboco, bu iguihuvaaboco, bu cɨvojafaño diicaaboco icano mahatyɨmeuhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jaaneguiiha uujoho iimusuji: Miyanotɨro, amɨɨhaico neehi: Imiyaavogomoco sihidɨ ejeevatɨmoco tollɨ momoonɨutɨmaño, uco tollɨ momoonɨutɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jaamo diito ifinɨjitɨno cɨɨjɨgaifaño feeji. Jaanotɨ iimifiimo feeji ifinɨjitɨno fiivofaño. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jaabo Jesu jillɨ unuunoco paryɨ iimivuudɨ ijɨɨbogomɨnaaco nuubo: ");
INSERT INTO bmrNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Amɨɨhairyo magaajacuhi jino mifucucɨrucu Pascua jɨɨbaimo iicajinoco. Jaasumi uujoho Miyamɨnaafibadɨ Ifiivuuboco acɨjimo, uco ɨmohovɨ itetecuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jaasumi sacerdotemɨ aivojɨto, caatɨnɨmɨnaa, bu judiomɨ quillahuto icamo igaivuuhi Caifas onoobo sacerdotemɨ aivojɨɨbo iijatyɨgaba goohasivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jaamoro iimaacasiumo Jesuco abañɨmoro, agaayɨcɨmoro igaicaauqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jaamo neehicauhi: Jɨɨbaimofeenevɨ tollɨ momoonɨjitɨhi miyamɨnaa mojaago ɨsɨfiiratomoro ñaaɨvedino, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jaanaaca Betania cuumiri foojohoma Simon iicaubo Jesuco unuuneguiiha diibo iijafaño ɨɨfutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jaanaaca gaigo diibojaago saauhi alabastro eetavotapaajefaño ifacɨcɨfaihu sihidɨ ijaadama iicano gatyuucɨ icanoma. Jaabo Jesu imachuqui mesavɨ casɨɨvuubo nigaɨhallɨvɨ tofaihuco tucaruugo. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jaanoco ijɨɨbogomɨnaa atyɨmeuhi. Jaamoro ɨsɨfiiratuumoro noocasiuhi: ¿Collɨhi jinooco bañamaaihi? ");
INSERT INTO bmrNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ajashutɨno nɨhɨbamɨri manaajemere ɨɨdaasufiimoco mahacɨtanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jaanoco Jesu uguubuuboro diitoco nuuhi: ¿Collɨhi diigoco mɨhɨɨbahi? Imino uco moonɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mɨɨro fahiijɨvaro ɨɨdaasumo amɨɨhai mihicaji. Jaanotɨ uujoho fahiijɨvaro amɨɨhaima icajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jaamo jino tahallɨvɨ facɨcɨfaihuco utucaruneri tafiico imibachugo cɨɨhojɨfaño ɨcɨcafetejino ɨmegavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Miyanotɨro amɨɨhaico neehi, fahɨgova jino taajasu jɨɨbogoco faajiinɨjeri ɨjɨɨbogohɨgo jino diigo omoonɨno jɨɨbogocafeteji, toonotɨ diigoco ihesafetehicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jaanaaca ijɨɨbogomɨnaatɨ saafi Juda Iscariote onoobo fuuhi sacerdotemɨ aivojɨtoma ihiimaatuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jaaboro jillɨ diitoco nuubo: ¿Mɨnoodɨno uco majaaduji, Jesuco amɨɨhaico aacɨhachiijɨ? nooboro. Jaaneguiiha diito diiboco jaaduuhi treintadɨjeva nɨhɨbamɨco. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jaasumitɨro Juda guiinehicauhi Jesuco diito usefaño aacɨujifucuco. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jaanaaca ijuurisutama achahano maahunoco amachujibuuno jɨɨbaimo ɨtɨcovaufucu Jesujaago ijɨɨbogomɨnaa ufuumoro diiboco dilluuhi: ¿Conoovɨ diimeguehi Pascua machutaaco meheetavonoco? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jaaneguiiha Jesu diitoco nuuhi: Mofoo cuumifaño johono amɨɨhairyo magaajacuubojaago. Jaamoro diiboco monoo: Mohaivojɨɨbo jillɨ neehi: Tahoovovɨ ɨɨfutucuuhi. Jaaneguiiha diijafaño tajɨɨbogomɨnaama Pascua machutaaco eetaveji, noobo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jaaneguiiha ijɨɨbogomɨnaa ufuumoro Jesu unuubadɨ moonɨuhi. Jaamoro toojafaño Pascua machutaaco eetavuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jaanaa mihiijɨcuudɨ Jesu docedɨmo ijɨɨbogomɨnaama mesavɨ casɨɨvuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jaamo machumaaca Jesu nuuhi: Miyanotɨro, amɨɨhaico neehi, amɨɨhaitɨ saafi uco acɨji igaicaauqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jaaneri diito sihidɨ ɨɨdaasuvuumoro diiboco dilluuhi: Aivojɨɨbo, ¿nacu fɨne uujoho? noomoro sifi idilluno, sifi idilluno icano fuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jaaneguiiha Jesu diitoco nuuhi: Sajefañoro uuma amachuubo diibo uco acɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mɨɨro uujoho Miyamɨnaafibadɨ Ifiivuubo Caatɨnɨhaamefaño onoobadɨ feehi. Jaarunaaca ɨdaasucani iicajiibo uco aacɨɨbo. Aivo imijiruno diibedi fiivuutɨɨbo icaruva, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jaaneguiiha Juda diiboco aacɨujiibo nuuhi: Aivojɨɨbo, ¿nacu fɨne uujeheji? nooboro. Jaaneguiiha Jesu nuuhi: Jɨɨhɨ, ɨɨjeheji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jaamo machuumaaca Jesu imaahuco agaayɨcɨuboro, Moocaanico graciaco aacɨudɨ tohɨcaco iquisicɨuboro ijɨɨbogomɨnaaco acɨubo: Ɨfaaji, jino tafiico mamachu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jaadɨ bu ihadufaihuco agaayɨcɨuboro Moocaanico graciaco aacɨuboro diitoco acɨuhi: Paryɨ famooro jifaihutɨ mahadu. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mɨɨro jino tatyɨɨjoho iicano bohono iimaaco imiyacaruno. Jaano jino tatyɨɨjoho gañɨɨcafetehi ajashutɨmohallɨvɨ imitɨ buusu iicano. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jino amɨɨhaico neehi, jino baacufaihuco jari ufucu siino aduji amɨɨhaima johono Moocaani aivojɨfaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jaadɨ amasivaunobuunatɨ fuumo Olivohono iicagajɨjaago. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jaadɨ Jesu diitoco nuuhi: Jifucu paryɨ amɨɨhai uco mejeevesumoro mofoocɨnɨji. Mɨɨro Caatɨnɨhaamefaño noono: Itoomomɨnaafico gaicaauji. Jaaneri ihovejamɨ fahɨgova gavaranamaaiji, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jaaruubo siino ubuheeteebere amɨɨhai ɨmega feeji Galileavɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jaaneguiiha Pedro diiboco nuuhi: Famooro ɨco jeevesurunaaca, uujoho ɨco jeevesujitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jaaneguiiha diiboco Jesu nuuhi: Miyanotɨro ɨco neehi, jaafañiinofucu catava ojɨtɨɨbaacaro mifoocɨ, safo icano: Diiboco gaajatɨhi, bu diibo jɨɨbogomɨnaafi icatɨji, neeji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Jaaneguiiha Pedro nuuhi: Jaafa ɨɨma iguijevehachiijɨ guijevehi. Jaaruubo ɨco tuunamaaijitɨhi, nooboro. Jaabadɨro bu paryɨ saatoho ijɨɨbogomɨnaa nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jaadɨ Jesu ijɨɨbogomɨnaama Getsemani onoomañovɨ ɨɨfutuudɨ diitoco nuuhi: Jinoovɨ mɨgɨcɨnɨ, uujoho johonovɨ Moocaanima ihiimaatonohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jaaboro Pedroco, bu Zebedeo achimɨsico icano asatyuuboro tɨcovauhi ɨñɨhicuguuboro sihidɨ ɨɨdaasuvuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jaaboro diitoco nuubo: Sihidɨro tajeebɨɨfaño ɨdaasu icahi miguijevejibadɨ. Jaaneguiiha jino mihica uuma cɨgatɨmo mubuhee, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jaadɨ Jesu janaanɨcɨvɨ ufuuboro jiinɨjehallɨvɨ ajavuvuuboro Moocaanima iimaauhi: Guihi, idiimogohachiijɨ uco taajasu jino ɨdaasuno iicajinotɨ. Jaaruno uujoho iimogobadɨ icatɨno, jaafa ɨɨjoho idiimogobadɨro icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jaadɨ ijɨɨbogomɨnaa iicauhɨgo asaaubo cɨgamovɨ gaseuhi. Jaaboro Pedroco nuubo: ¿Collɨhi jaabo uuma sano nɨhɨba oovo tɨcovovɨ buheetɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","¡Mubuhee! Jaamoro Moocaanima mihiimaa ɨjɨ amɨɨhaico ɨnɨsunofaño mahaquetedino. Miyanotɨro amɨɨhai jeebɨɨ imino iicanoco imogorahi. Jaarunofaño amɨɨhai allɨo ifi niinovahi, ");
INSERT INTO bmrNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","nooboro siino fuubo dojɨcuvɨro Moocaanima ihiimaatuubo. Jillɨ nooboro: Guihi, uujoho ɨdaasuno iicanoco idiimogohachiijɨ etɨ idiimogobadɨ moonɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jaabo bu siino uhuumiubo ijɨɨbogomɨnaa cɨgamoco atyɨmeuhi aivo sihidɨ cɨgarari icacuutɨneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jaamoco ejeevesuuboro siino fuubo Moocaanima ihiimaatuubo, siino tollɨro nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jaadɨ bu siino ijɨɨbogomɨnaa iicauhɨ ufuuboro diitoco nuuhi: Ɨvɨ jisumi mɨcɨgacu, majaguisɨcu. Jino gasecuuno uujoho Miyamɨnaafibadɨ Ifiivuubo imitɨmɨnaa usefaño aacɨcafetejino. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jaaneguiiha magañiivomoro masɨɨgucu mee oono uco aacɨvaabo fiitɨcuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jaanaaca tollɨ iimaaubaacaro Juda gaseuhi ijɨɨbogomɨnaa docedɨmo iicahicaurumoobo. Jaaboma saaumo sihidɨ miyamɨnaa niisuganoma, cudaahenema icano; sacerdotemɨ aivojɨto, bu judiomɨ quillahuto icamo agalluumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jaabo Juda diitoco nuuhi: Oono uujoho diibo iicaaboco ɨnɨnɨɨcɨɨboro dilluji. Jaaboco cuhufono misisɨmoro masatyo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jaaboro Jesujaago ufuuboro diiboco nuuhi: ¿Naa diicahi, Jɨɨbogomɨnaafi? nooboro Jesuco nɨnɨɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jaaneguiiha Jesu diiboco nuuhi: ¿Fañɨ, jinejefiri saahi? nooboro. Jaasumiro diito Jesuco agaayɨcɨumoro Jesuco sisɨuhi isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jaaneguiiha Jesu nahabonɨmɨnaatɨ saafi iniisugaco iguiiyɨcɨuboro sacerdotemɨ aivojɨɨbo jeecɨvomɨnaafi nɨjɨmeehuco buiyaacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jaaneguiiha Jesu diiboco nuuhi: Diniisugaco ifajutafaño dɨɨhacu. Mɨɨro oono niisugari omoonɨcasimo, bu niisugari guijeveji. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Nacu ɨɨjoho gaajatɨhi uujoho Guihirubico dilluruva jaachiijɨgayɨro tajaa galluujiruubo itoomomɨnaatɨ aivo ajashutɨmo fahuseecɨ motɨhaitɨ miihaicɨ ɨdɨɨno dɨhaivaco? ");
INSERT INTO bmrNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Jaano tollɨ iicaruva, ¿mɨllɨ bu Caatɨnɨhaamefaño jillɨ icajiibo onoono miyaavejirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jaadɨ Jesu diito miyamɨnaaco nuuhi: ¿Mɨllɨ jaamo amɨɨhai tatyɨcovodɨ masaahi cudaahenema, niisuganoma icano nanivamɨnaafico magaayɨcɨqui mihicanɨcɨbadɨ? Mɨɨro fafucuvavɨro amɨɨhaifeenevɨ uujoho templojafaño casɨɨvooboro jɨɨbeguehicahi. Jaaruuboco du uco magaayɨcɨhicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Jaarunofaño jaafa tollɨ icano johono Caatɨnɨhaamefaño Moocaani iimaamɨnaa acaatɨnɨuno imiyaavequi, nooboro. Jaasumiro ijɨɨbogomɨnaa diiboco ejeevesuumoro famooro gaacɨnɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jaamo Jesuco isisɨumoro sacerdotemɨ aivojɨɨbo Caifas onoobo ɨmefeenevɨ satyuuhi. Tahɨ caatɨnɨmɨnaa, bu judiomɨ quillahuto icamo iigaicɨnɨuhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jaanaa Pedro ɨfutuuhi sacerdotemɨ aivojɨɨbo goohasivɨ: ¿Naa mɨllɨ fɨne moonɨjimo? nooboro tehesinotɨ ɨɨfɨnɨcɨuboro ufuubo. Jaabo policiamɨ cojɨvɨ casɨɨvutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jaanaaca sacerdotemɨ aivojɨto, bu judiomɨ quillahuto, bu paryɨ imiyafagomɨnaa icamo guiinehicauhi Jesuhallɨvɨ sɨcamañooco ɨjɨɨbogonotɨ diiboco igaicaausuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jaarunofaño tonoogayɨjehallɨtɨ gaicaaujitɨrumo guiiraamo saatoho diibohallɨvɨ sɨcamañooco jɨɨbeguehicaurunaaca. Jaanofeenevɨ miimɨsiicɨ gaseuhi diibohallɨvɨ sɨcamañooco ɨjɨɨbuguumɨsi: ");
INSERT INTO bmrNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jaanɨ neehicahi: Uujoho Moocaani templojaco finɨsuji. Jaaboro siino boojatɨ mifucucɨ, safucu ɨdɨɨnotɨro eetaveji, nooboro, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jaaneguiiha sacerdotemɨ aivojɨɨbo agañiivuuboro Jesuco nuuhi: ¿Aivo ajashuno diimusutɨhi? ¿Mɨllɨ nacu jino jito dihallɨvɨ neehi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jaarunofaño Jesu diiboco iimusuutɨhi. Jaaneguiiha diibo isacerdotemɨ aivojɨɨbo Jesuco nuuhi: Moocaani momofeenedɨ miyaanocoro mɨɨhaico dinoo, ¿naa miya ɨɨjoho Cristo Moocaani Achi idiicaabo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jaaneguiiha Jesu diiboco nuuhi: Jɨɨhɨ, uujoho diibo, ɨɨjoho toono onoobadɨ. Tollɨro bu amɨɨhaico jino neehi: Ufucu mahatyɨmeji uujoho Miyamɨnaafibadɨ Ifiivuubo sihidɨ ejeevaabo Moocaani miyanaagonovɨ gɨcɨnɨɨboco, bu niqueje aimuufaifeenedɨ asaaboco icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jaaneri sacerdotemɨ aivojɨɨbo igaachehuco gallicuuhi sihidɨ ɨsɨfiiratuuboro. Jaaboro nuubo: Jaanɨ iijɨri Moocaaniditɨ aivo imitɨno iimaahi. ¿Collɨhi bu siino sita onoonoco mehesujirahi? Amɨɨhairyo muguubucuuhi imitɨno ihiimaanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nacu mɨllɨ amɨɨhaidi? nooboro. Jaaneguiiha diito nuuhi: Tollɨ ihiimaamaño guijevejiibo, ");
INSERT INTO bmrNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","noomoro Jesuco ihɨmefaño ɨjɨɨrebamaaiumoro ganɨɨcɨumo. Jaanotɨ bu saatoho diiboco ihɨmefaño agabejenɨumoro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ɨɨjoho Cristo idiicaabo ene gaajacɨ. ¿Naa mɨɨjoho ɨco gabacuuhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jaanaaca Pedro jahisi goohasifaño gɨcɨnɨunaaca sacerdotemɨ aivojɨɨbo jeecɨvomɨnaago asaaugoro diiboco nuuhi: Ɨɨjoho bu tollɨro Jesu Galileaooboma idiicahicaabo, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Jaarunofaño Pedro tuunamaaiuhi: Uujoho gaajatɨhi jinejetɨhacho toono diimaahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jaanaaca Pedro toonotɨ fuucuuboco saafigo aatyɨmeugoro tooneri iicaumoco nuuhi: Jaanɨ bu tollɨro oono Jesu Nazareooboma ɨguehicaabo, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jaarunaaca Pedro tuunamaaiuhi Moocaani momofañodɨ: Miyanotɨro uujoho diiboco gaajatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jaanobuunatɨ bu siino tooneri iicaumo Pedrojaa asaaumoro diiboco nuuhi: Miyaano jahi, ɨɨjoho diitoobo, mee oono dihiimaa diito iimaabadɨ jeevahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jaaneguiiha diibo nuuhi: Moocaani momofañodɨ neehi: Miyanotɨro, uujoho diiboco gaajatɨhi. Jaanotɨ jillɨ onoobo abañɨhachiijɨ jaafa uco Moocaani guijenɨhi, nooboro. Jaasumiro catava ojɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jaanoco uguubuuboro Pedro esafutuuhi Jesu diiboco: Catava oojɨtɨnaacaro uco mifoocɨ safo ɨdɨɨno tuunamaaiji, unuunoco. Jaaneguiiha Pedro toonotɨ ufuuboro aivono taauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jaanaaca eseseeveudɨ paryɨ famooro sacerdotemɨ aivojɨto, judiomɨ quillahuto icano sabadɨro iimaacasiuhi Jesuco igaicaauqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jaamoro diiboco sisɨcɨnɨɨboco asatyumoro toojiinɨjeo aivojɨɨbo Poncio Pilato onooboco acɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jaanaaca Juda, miyamɨnaa usefaño Jesuco aacɨuboco guijevefaño ificuunoco aatyɨmeuboro sihidɨ ɨdaasuvuuhi. Jaaboro treintadɨjeva iicaunoco inɨhɨbamɨco uumisuuhi sacerdotemɨ aivojɨtoco, bu judiomɨ quillahutoco icano jillɨ nooboro: ");
INSERT INTO bmrNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Uujoho imitɨco ɨcɨhi aivo imiiboco guijevefaño aacɨmaño, nooboro. Jaaneguiiha diito iimusuuhi: ¿Jaano mɨllɨ mɨɨhaidi? Toono diino, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jaaneguiiha Juda inɨhɨbamɨco templojafaño gavaracuuhi. Jaadɨ ufuuboro gaibaɨri icodaahetɨ uduujecafutuuboro lluhivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jaadɨ sacerdotemɨ aivojɨto inɨhɨbamɨco ɨɨcɨumoro nuuhi: Jino nɨhɨbamɨco Moocaaniguiiha ificunɨcɨnofaño mificujitɨhi tɨɨjoho jaada iicacumaño, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jaadɨ ihiimaacasiumoro tooneri nɨfaqui guirihilluno nicumɨnaafi faguico naajeumo, tomañovɨ siijiinɨjeoteheje ochoomomoco icɨɨhicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jaamaño tomaño jisumihachuta: Tɨɨjohomaño, noocɨnɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jillɨ miyaavuuno Moocaani iimaamɨnaafi Jeremia acaatɨnɨuno: Ɨcɨumo treintadɨjeva inɨhɨbamɨco Israel cuumimɨnaa diibo jaadaco ificuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Jaaneri nɨfaqui guirihilluno nicumɨnaafi faguico naajeumo, oono uco Aivojɨɨbo atajɨɨbabadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jaadɨ Jesuco aivojɨɨbo Pilato ɨmegavɨ ɨɨfutusuumo. Jaaboco dilluubo: ¿Naa ɨɨjoho oono judiomɨ Aivojɨɨbo idiicaabo? nooboro. Jaaneguiiha Jesu iimusuuhi: Jɨɨhɨ, tollɨ icano toono ɨɨjoho onoobadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jaanaaca sacerdotemɨ aivojɨto, judiomɨ quillahuto icamo diibohallɨvɨ imitɨno ɨjɨɨbeguehicaurunoco Jesu ajashuno iimusuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jaaneguiiha Pilato diiboco nuuhi: ¿Naa guubutɨhi oono dihallɨvɨ imitɨno ihiimaanoco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jaarunofaño bu Jesu diiboco ajashuno iimusuutɨhi. Jaaneri diibo Pilato sihidɨ eheetyeuboro eesamaaiujirunoco gaajautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jaasumi mɨɨro aivojɨɨbo Pilato omoonɨnɨcɨbadɨ cɨvojamɨnaafitɨ saafiico sinaayujibuuhi miyamɨnaa idilluuboco. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jaanaa icaubo saafi cɨvojafaño Barraba onoobo sihidɨ ejeevaabo iimitɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jaanaa paryɨ miyamɨnaa igaicɨnɨumoco Pilato dilluuhi: ¿Cajaanɨco mihimeguehi, amɨɨhai, uujoho isinaayunoco, Barrabaco, nacu oono Jesu Cristo onooboco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tollɨ nuubo jillɨ Jesuco ɨjɨɨheveumoro diibo usefaño aacɨunoco agaajacɨuboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jaabo Pilato ihaivojɨ icagahallɨri gɨcɨnɨunaaca diibojaago mogai saatohoco galluuhi jillɨ noogoro: Mɨllɨ moonɨdineheje diibo iimino miyamɨnaafico, fone fucu ñɨhicuno tɨgahi diibo Jesuditɨ, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jaarunofaño sacerdotemɨ aivojɨto, bu judiomɨ quillahuto icamo miyamɨnaaco fajɨɨnɨuhi Barrabaco dihiinusu. Jaanotɨ: Jesuco guijenɨ, monoo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jaanaaca bu siino miyamɨnaaco Pilato dilluuhi: ¿Diitɨsitɨ cajaanɨco isinaayunoco mihimeguehi? nooboro. Jaaneguiiha nuumo: Barrabaco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jaaneguiiha siino Pilato diitoco dilluuhi: ¿Jaanaa mɨllɨ moonɨji oono imomo Jesucristo iicaaboco? nooboro. Jaaneguiiha paryɨ famooro iimusuuhi: ¡Ɨmohobujehallɨvɨ tetecu! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jaanegui Pilato diitoco nuuhi: ¿Nacu jineje imitɨnoco moonɨɨbo? nooboro. Jaarunofaño diito siino coovadiivuuhi: ¡Ɨmohobujehallɨvɨ tetecu! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jaanegui Pilatoco diito sihidɨ ejenaauumoro janaanɨcɨvɨro aivo añaaɨvuunoco aatyɨmeuboro, tajɨɨbaubo nɨfaihuco isɨvaqui. Jaafaihufaño ihuseneque nitamaaiubo diito ɨmefeenevɨ, jillɨ nooboro: Uujoho jaanɨ iimiibo guijevefañodɨ icatɨhi. Jillɨ toono amɨɨhai iimaa, nooboro Pilato. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jaarunaaca famooro iimusuuhi: Mɨɨhai, bu paryɨ moseeme icamohallɨvɨ jaafa minifotono, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jaaneguiiha Pilato Barrabaco isinaayusuuboro Jesuco aamɨsuuhi. Jaadɨ diitoco acɨubo diiboco itetecuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jaaneguiiha ihamocasimɨnaa Jesuco satyuuhi diibo Pilato iijajaago. Jaamoro igaiyɨɨcɨumo paryɨ amocasimɨnaaco Jesuhallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jaamoro diiboco igaachehuco ujujuyaacuumoro sichehuco jɨɨhacuumo gachicohai deecano tɨfaibadɨ itɨfai iicachehuco. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jaamoro bu iinigaɨhallɨvɨ javucaruumo januutuno aafeneque chaahimɨgatɨ eheetavuumoro, bu jaamoro gaayɨcɨsuumo imiyanaagohusefaño ɨmeico icano. Jaadɨ diiboguiino ememuɨɨvomoro diiboco dejecuhicauhi: ¡Imicani ɨɨjoho judiomɨ Aivojɨɨbo! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jaadɨ bu ihɨmeico agaayɨcɨmoro tohiri diiboco iinigaɨtɨ gafucuhicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jaadɨ diiboco jillɨ omoonɨhicaudɨ jujuyaacuumo diiboco tɨfaihɨba icacheuco ɨjɨɨhacuuchehuco. Jaamoro imiyachehuco jɨɨhacuumo. Jaadɨ ɨvɨ satyucuumo diiboco itetecuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jaamo Jesuco itetecuqui ufuumo atyɨmeuhi Cirene cuumioobo Simon onooboco. Jaamoro diiboco tajɨɨbauhi Jesu ɨmohobujeque isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jaadɨ ɨɨfutuumo nigaɨpaajebaɨ onoomañovɨ; jaanotɨ hebreomɨ iijɨri Golgota onoobaɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jaabaɨhallɨvɨ Jesuco isuurumo vino aivo faafaiñooco. Jaarunoco inɨsucuuruhɨgotɨ adutɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jaaboco etetecuumoro ihamocasimɨnaa suerteque eetavuuhi Jesu gaachehuhallɨvɨ: ¿Cajaanɨ fɨne tochehuma icaji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jaamoro ifiitɨno casɨɨcamaaiumo diiboco otoomomo. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jaamoro ijɨɨbogoco ihɨmohobujetɨ iinigaɨhallɨvɨ caatɨnɨumo: JAANƗ JESU JUDIOMƗ AIVOJƗƗBO, onoono. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tollɨro bu diibo uufocovɨ tetecuumo miimɨsiicɨ nanivamɨnaatɨsico, saafiico imiyanaagonovɨ, bu saafiico inaninaagonovɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jaanaaca toonodɨ afatyomo diiboco ɨhɨɨbamoro ihuseneque gavaracumoro ɨɨbajirubadɨ iicano iinigaɨcoro garya garya moonɨhicaumo, ");
INSERT INTO bmrNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","jillɨ noomoro: ¿Naa ɨɨjoho oono templojaco acallajaruuboro siino dojɨcuvɨro mifucucɨ, safucu ɨdɨɨnotɨ boojatɨ edeetavejiruubo? ¡Eneecata ɨɨro difiico taajasu! ¡Bu miyaano Moocaani Achi idiicahachiijɨ, toono caamotɨ niito! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jaabadɨro bu sacerdotemɨ aivojɨto, bu caatɨnɨmɨnaa, bu fariseomɨ, bu judiomɨ quillahuto icamo diiboco edejecumo neehicauhi: ");
INSERT INTO bmrNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Sitaaco taajasuubo. ¿Jaaruubo cono bu inoro ifiico taajasuubova? Eneecata miyaano Israel Aivojɨɨbo iicahachiijɨ, toono ihɨmohotɨ iniitequi maatyɨmemere diiboco mimiyaaveguequi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mɨɨro Moocaanivɨro ifiico sefaabo. Eneecata jaafa jaabo asaaboro diiboco taajasuvahi iimogohachiijɨ. Jaadɨ jari magaajaji miyaano Moocaani Achi iicanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jaabadɨro bu nanivamɨnaatɨsico diibo uufocovɨ etetecuumɨsi diiboco ɨɨbahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jaadɨ ɨvɨ paryɨ jiinɨje cɨvono minifutuuhi gadɨcɨɨbatɨ. Jaano seseeteuhi ɨmohonohallɨtɨ nɨhɨba icaaberi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jaasumiro Jesu hebreo iijɨri sefano gaihivuuhi: Eli, Eli, ¿lama sabactani? nooboro. Moocaani, Moocaani, ¿collɨhi uco deevesuhi? eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jaanoco saatoho tooneri iicaumo uguubuumoro nuuhi: Memeecɨ johono Moocaani iimaamɨnaafi Eliaco cuuhuvaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jaasumiro diitotɨ saafi ijinafatyuuboro ɨcɨjeuhi faasɨhi iicanoco. Jaaboro toosɨhico vino aivo quigañofaño matyusuuhi. Jaaboro toosɨhico ɨmei nijequevɨ ificuuboro Jesu iijɨfaño cabuyaacuuhi ihaduuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jaarunaa saatoho diiboco nuuhi: Moonɨdino, jaafa Elia saahi diiboco ataajasuvaabo mahatyɨmequi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jaanaaca siino Jesu sefano agaihivuuboro chuumucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jaano tɨcovovɨ temploja ofoboocɨnɨuchehu gaachehujetuno feemene iicano gallivuuhi feenedɨ caamotɨ sano guiinovɨ. Bu jiinɨje sefano maryɨbauhi. Jaaneri guiisihacɨno dujavanamaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bu tollɨro cɨɨhojɨno faayɨcɨcafutuuhi. Jaaneri Moocaanico imiyaavuguumo iguijevecɨnɨumo ajashutɨmo siino buheeteuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jaamo Jesu siino ubuheeteunobuunatɨ icɨɨhojɨnofañotɨ ihiinuumoro iimicuumi Jerusale cuumifaño fuuhi. Jaamoco tahɨ sihidɨ miyamɨnaa diitoco aatyɨmeumoro gaajauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jaanotɨ bu ihamocasimɨnaa aivojɨɨbo ihamocasimɨnaama Jesuco utuumuumo jiinɨje amaryɨbaunoco, bu sanehejeque icano aatyɨmeumoro sihidɨro igutuuhi. Jaamoro nuuhi: Miyanotɨro, jahi jaanɨ Moocaani Achi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jaabadɨro bu sihidɨ icaumo gaigoomɨ tehesinotɨro ɨɨfɨnɨcɨumo Galileatɨ Jesu dojɨcutɨ asaaumo diiboco jeecɨvomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jaamofeeneri icaugo Maria Magdalena onoogo, bu Jacoobo, Jose icamɨsi seejɨ Maria onoogo; Zebedeo seemenemɨsi seejɨ icamɨfe. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jaanaaca mihiijɨcuudɨ saaubo sihidɨ inɨhɨbamɨma iicaubo Jose onoobo Arimatea cuumioobo, Jesu onoonoco imiyaaveguehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jaabo Pilatojaago ufuuboro Jesu ifiico diiboco dillujeuhi. Jaaneguiiha Pilato tajɨɨbauhi diiboco ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jaadɨ Jesu ifiico Jose ɨɨcɨuboro mɨhɨnivatɨno gaachehuri mibocɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jaaboro icɨɨhojɨ bohojɨ guiisigajɨfaño eheetavusuhojɨfaño jɨɨhacuuhi. Jaaboro tohojɨco guiisibatyɨgabari amaninɨuboro fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jaanaaca tohojɨ tɨcovo icaumɨfe Maria Magdalena onoogo, bu saafigo Maria icamɨfe gɨcɨnɨuhi sinaagobaɨtɨ tohojɨco ɨhɨɨfɨnɨcɨumɨfe. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jaano seseevedɨ, Pascua jɨɨbaimoguiiha iimibaivuunobuunatɨ, sacerdotemɨ aivojɨto, bu fariseomɨ icamo fuuhi Pilatoma ihiimaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jaamoro diiboco nuumo: Aivojɨɨbo, mehesafetehi oono tobañɨfiiboba ubuheeusumi: Ochoomodɨ mifucucɨ, safucu icanotɨ siino buheeteji, unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jaaneguiiha tajɨɨba icɨɨhojɨco cuhufono imoonɨqui mifucucɨ safucu ɨdɨɨno tɨcovovɨ ijɨɨbogomɨnaa fucu asaamoro ichuumuhuco ananimoro: Siino buheetecuubo, noomoro miyamɨnaaco jɨɨbeguedimo. Jaanotɨ tollɨ omoonɨhachiijɨ tobañɨ aivo itɨconɨono janaanɨcɨvɨ jeevajirahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jaaneguiiha Pilato diitoco nuuhi: Ajaatyo toomomɨnaaco mɨhɨcɨmoro amɨɨhairyo diitoma aivo imino mucuhufusuto, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jaaneguiiha ufuumoro tohojɨco cuhufutusuuhi. Jaamoro bu igaajataaco ficuumo tohojɨco ofoboocɨuba iguiisibahallɨvɨ. Jaamoro tohojɨhallɨvɨ itoomomɨnaaco ficuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jaanaaca judio jaguisɨfucu sabado icafucu afatyuno seseevedɨ fucugayɨro Maria Magdalena onoogo, bu saafigo Maria icamɨfe fuuhi icɨɨhojɨco emeecɨtuumɨfe. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jaanaaca sefano jiinɨje maryɨbauhi Moocaani toomomɨnaafi niquejefañotɨ iniituuneri. Jaaboro tohojɨ ɨmegavɨ agaseuboro tohojɨ guiisibaco buhɨgovɨ ɨɨcɨuboro tobahallɨvɨ casɨɨvuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jaabohallɨ arɨcuuhi sisi anamebano arɨcubadɨ, bu igaachehu seseene seseeuhi cuugaihallɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jaaboco amocasimɨnaa tohojɨco utuumuumo aatyɨmeumoro sihidɨro igutuumoro iñɨhicuri uchuumucumobadɨ minifutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jaaboro Moocaani toomomɨnaafi diitɨfeque nuuhi: Mihiguetejirahana uujoho gaajahi amɨɨfe Jesu etetecucafetehinɨɨboco miguiinonoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jineeri chahacuubo siino buheetecuubo unuubadɨ. Eneecau bu jino diiboco ificuhinɨmañooco memeecɨva. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jaaneguiiha goovano mofoomɨfere ijɨɨbogomɨnaaco mɨjɨɨbogoto jillɨ noomɨfere: Guijevefañotɨ siino buheetecuubo. Jaaboro amɨɨhai ɨmega sɨɨgucuubo Galileavɨ. Tahɨgo diiboco mahatyɨmeji. Jinooco amɨɨfeque neequi saahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jaaneguiiha diitɨfe toonotɨ fuucuuhi. Goovano sihidɨ igutuumɨfere, bu imo imo icano fuuhi. Jaamɨfere diitɨfe Jesu jɨɨbogomɨnaaco jɨɨbugutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jaamɨfevɨ Jesu ajafeveuboro diitɨfeque dilluuhi. Jaaneguiiha diibojaago ufuumɨfere itɨhaiñoco ihiibɨcɨmɨfere diiboco imuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jaaneguiiha diibo diitɨfeque nuuhi: Mihiguetedino. Mofoomɨfere tañahabomɨco mɨjɨɨbogoto Galileavɨ ifeequi tahɨgo uco atyɨmejimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jaanaaca diitɨfe ufuunobuunatɨ tohojɨco utuumuumotɨ saatoho amocasimɨnaa cuumifaño ufuumoro sacerdotemɨ aivojɨtoco jɨɨbuguuhi paryɨ aatyɨmeunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jaaneguiiha diito sacerdotemɨ aivojɨto judiomɨ quillahutojaago ufuumoro diitoma iimaajeuhi. Jaamoro sihidɨ nɨhɨbamɨco ihamocasimɨnaaco jaaduumo. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jillɨ diitoco noomoro: Miyamɨnaaco monoo: Mɨɨhai fucufeene mɨcɨganaaca ijɨɨbogomɨnaa asaamoro ichuumuhuco ananimoro satyehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jaanoco aivojɨɨbo uguubuuboro amɨɨhaijaago ɨsɨfiiratohachiijɨ mɨɨhai diiboma mihiimaaji amɨɨhaihɨ aivojɨto judiomɨ quiallɨvɨ. Jaamo ¿mɨllɨ icatɨmo mihicahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jaaneguiiha ihamocasimɨnaa inɨhɨbamɨco agaayɨcɨumoro diito unuubadɨ moonɨuhi. Jaabadɨ judiomɨ jɨɨbeguehicahi jisumihachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jaaneguiiha ijɨɨbogomɨnaa fahuseecɨ motɨhaitɨ sɨ aivojɨto judiomɨ quiaafi ɨdɨɨmurucu fuuhi Galileajaago Jesu diitoco unuubaɨjaagovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jahɨgo Jesuco aatyɨmeumoro diiboco imuumo. Jaarunaa saatoho miyaadɨ miyaavuguutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jaadɨ Jesu asaauboro diitoco nuuhi: Uujoho gaayɨcɨcuuhi paryɨ aivojɨ iijɨco niquejefaño, jiinɨjehallɨvɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaaneguiiha paryɨ faajiinɨjeriro mofoomoro tajɨɨbogomɨnaatɨ meheetavo. Jaamoco minitɨ Moocaani momofeenedɨ, bu Illi momofeenedɨ, bu Igaija momofeenedɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jaamoro diitoco mɨjɨɨbogo amɨɨhaico paryɨ uujoho ɨjɨɨbeguehicanoco imino imoonɨqui. Jaamoro imino magaaja uujoho amɨɨhaima fahiijɨvaro icaji jiinɨje ifinɨjinovɨ, bu janaanɨcɨ icajinovɨ, nooboro.");
INSERT INTO bmrNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jillɨ tɨcovauno Jesucristo Moocaani Achi jɨɨbogoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mɨɨro jillɨ Moocaani iimaa jɨɨbogomɨnaafi Isaia caatɨnɨcuuhi, Moocaani unuunoco: Dihɨme galluuhi tajɨɨbogomɨnaafico, dihɨme jɨɨhaico iimibachuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jaanaa guubuvusuuno sɨcaihɨgotɨ ocoovadiicɨnɨuno: Mihimibachu Mohaivojɨɨbo jɨɨhaico sano tɨcovoro meheetavo, onoonoco, Isaia caatɨnɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jillɨ saaubo Jua sɨcaihɨgovɨ miyamɨnaaco nitɨɨboro. Jaabo neehicauhi: Minitɨsuquimaje jaamoro amɨɨhai eedeehifiico mejeevesu, amɨɨhai imitɨ ibuuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jaanegui Judeao jiinɨjeoto, bu Jerusale cuumioto icamo feehicauhi diiboco uguubunɨcɨtomo. Jaamoco iimitɨco ɨjɨɨbeguehicauno bujɨnagotɨ diitoco Jua nitɨhicauhi Jorda onoohifaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jaabo Jua gaachehuhicau camello ijeene eetavotau. Jaanotɨ iniivɨgai meeheu jillɨ asi meehe. Jaabo chahacamɨcoro duuhicauhi, bu bajɨo iimɨcoro nejeecuhicaubo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jaabo jɨɨbeguehicauhi jillɨ nooboro: Taabuunatɨ saajiibo tajanaanɨcɨ sihidɨ imityaabo diibobadɨ uujoho jeevatɨhi. Jaamaño diiboguiino ɨdɨjɨɨvooboro itɨhaipaaje duujeque sinaayujitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Uujohonaha, amɨɨhaico miyaano nɨfaihuri nitɨhi. Jaanotɨ diibo amɨɨhaico Moocaani Gaijari nitɨji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jaasumivɨ Jesu fuuhi Nazare cuumitɨ Galilea jiinɨjeri iicacuumitɨ. Jaaboco Jua nitɨuhi Jorda onoohifaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jaabo Jesu iteehifañotɨ ihiinuubo atyɨmeuhi niqueje afaayɨcafutuunoco. Jaanofeenedɨ nimɨihubadɨ jeevaabo Moocaani Gaija ihallɨvɨ niitovauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jaanaa guubuvusuuno niquejefañotɨ unuuno: Ɨɨjoho agaijɨɨbo taseemene, ɨɨri sihidɨ imo imo icahi, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jaasumiro Moocaani Gaija diiboco satyuuhi sɨcaihɨgovɨ miyamɨnaa achahauhɨgovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jaabo Jesu tahɨgo icauhi sanɨhɨba, siino fahuseecɨ icano fucuva asimɨfeeneri. Jaaboco Satanas nɨsuuhi. Jaanobuunatɨ Moocaani toomonɨnaa asaaumoro diiboco jeecɨvehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jaanobuunatɨ Juaco cɨvojafaño ificuunotɨro Jesu Galileavɨ fuuhi jɨɨbogooboro taajasu jɨɨbogoco Moocaani aivojɨ iijɨco. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jaabo jillɨ neehicauhi: Tusumi mihicacuuhi, jino Moocaani aivojɨ fiitɨvucuuhi. Jaaneguiiha amɨɨhai imitɨco mejeevesucu. Jaamoro mimiyaavogo jino imino mataajajino jɨɨbogoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jaabo Galilea muuaijɨnidɨ ɨgooboro ufuuhɨgo atyɨmeubo Simon, inahabo Andre icamɨsi fiicɨmɨnaatɨsi iicaumaño muuaifaño isinɨcuuhuri sinɨhicaumɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jaamɨsico Jesu nuuhi: Tadyojɨcutɨ masaa, amɨɨsico miyamɨnaa fiicɨmɨnaatɨsitɨ eetavequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jaanegui tusumiro isinɨcuuhunoco ejeevesumɨsiro diibo dojɨcutɨ fuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jaadɨ toonotɨ janaanɨcɨvɨ afatyuubo Jacoobo, bu inahabo Jua icamɨsi Sevedeo achimɨsico tollɨro imeenegafaño isinɨcuuhuco amaahunɨumɨsico atyɨmeteuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jaamɨsico bu tollɨro coovaubo. Jaanegui caanico idudɨcamaajemɨnaama imeenegafaño ejeevesuumɨsiro Jesuma fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jaadɨ Capernau cuumivɨ ɨɨfutuudɨ, judiomɨ jaguisɨsumi Jesu sinagogajafaño ufuuboro jɨɨbeguehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jaaneri miyamɨnaa sihidɨ eetyehicauhi diibo jɨɨbegueri diitoco aivojɨɨbo iicanɨcɨbadɨ ɨjɨɨbeguehicauneri, caatɨnɨmɨnaa ɨjɨɨbogonɨcɨbadɨ iicatɨneri. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jaanaaca tooja sinagogajafaño iimitɨno ɨjɨma iicaubo icauhi. Jaabo gaihivuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ɨɨjoho Moocaani seemene idiimiibo, uujoho ɨco gaajahi. ¿Jaabo jinejeque diimeguehi ɨɨjoho mɨɨhaima Jesu Nazareoobo idiicaabo? ¿Naa mɨɨhaico finɨsuqui asaabo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jaanegui Jesu diibo iimitɨno ɨjɨco ɨhɨɨbauboro nuuhi: Llɨɨvɨ diica. Jaaboro diibotɨ diino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jaanegui ihɨjɨ diiboco baavɨ agañɨɨboro ifiico vɨvɨ vɨvɨ iminiiyuuboro sefano agaihivuuboro diibotɨ iinuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jaaneri famooro miyamɨnaa sihidɨ eetyeuhi. Jaamoro dillucasihicauhi: ¿Jineje jino bohono jɨɨbogo? Jaanɨ iijɨ aivo sefahi aivo ɨjɨmɨ iicarumoco atajɨɨbanoco: Jii, noomo, noomoro noocasihicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jaanoco Jesutɨ ɨjɨɨbocasiuno paryɨ Galilea jiinɨjeri goovano gaajacafutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jaadɨ sinagogajatɨ iinuudɨ Jesu fuuhi Jacoobo, Jua icamɨsima Simon, bu inahabo Andre icamɨsi iijafaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jaanaa Simon baabo sinafeteri sihidɨ guihuvauhi. Jaanoco Jesuco jɨɨbuguumo diigo iguihuvaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jaanegui Jesu diigojaa ufuuboro ihusetɨ diigoco agaayɨcɨuboro gañiiyɨcɨuhi. Jaasumiro diigoco iguihuva bucuuhi. Jaadɨ diitoco jeecɨvehicaugo. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jaadɨ iijɨcuuvɨ nɨhɨba jabaavucuunaaca sɨvahicaumo diibojaa paryɨ iguihuvamoco, bu emeimɨvatomejeque icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jaanaa paryɨ miyamɨnaa asaauneri guhugavɨ gahafuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jaamoco Jesu buheesuhicauhi siomoneri, bu siomoneri icano iguihuvaumehejeque. Jaabadɨro bu emeimɨvatomoco imeimɨco buhɨ gañɨɨhicaubo. Jaamo imeimɨ iimaajirumo iimaahicautɨhi diiboco agaajahicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Cuujetavɨro Jesu agañiivuuboro fuuhi tuucuumitɨ sɨcaihɨgovɨ Moocaanima ihiimaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jaaboco Simon, inahabonɨmɨnaa icano guiinutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jaamo diiboco aatyɨmeudɨ nuuhi: Famooro miyamɨnaa ɨco guiineri icahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jaanegui Jesu iimusuuhi: Masɨɨgo siicuumijaago ifiitɨcuumijaago tahɨ tollɨro jɨɨbeguequi taajasubogoco. Toonegui uujoho saauhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jaadɨ Jesu paryɨ Galilea jiinɨjeri sinagogajafaño jɨɨbogooboro feehicauhi ɨjɨmɨco gavaracuuboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jaanaa foojohoma iicaubo Jesujaa saauhi. Jaaboro iguiino ememuɨɨvuuboro nuuhi: Idiimogohachi uco buheesu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jaanegui Jesu diiboco ɨɨdaasuguuboro ihuseri dudɨɨcɨuhi: Imeguehi, buheetecu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jaasumiro diiboco ifoojoho ubuuneri buheetecuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jaadɨ Jesu diiboco afaguuboro galluuhi jillɨ nooboro: ");
INSERT INTO bmrNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Mɨɨhaiñoobaco dɨɨbeguedino. Jillɨ ofooboro sacerdoteque dɨhɨfusuto. Bu jaaboro ɨco iimibachuno jeecɨvoco asimɨco ficuuto Moise atajɨɨbaubadɨ toono jɨɨbogobadɨ iicanoco. Jaanoco miyamɨnaa aatyɨmemere igaajaqui ɨɨjoho ubuheecunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jaarunaa ufuuboro sihidɨ miyamɨnaaco jɨɨbogooboro feehicauhi diiboco Jesu ubuheesuunoco. Jaamaño Jesu foovono cuuminofañodɨ ɨgucutɨɨbo, jillɨ buhɨgueejere miyamɨnaa achahahɨguejere iicaaboro feehicauhi. Jaarunaa fahɨgovatɨ saahicaumo diiboco emeecɨvamo. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Toonobuunatɨ siino Jesu Capernau cuumivɨ fuuhi goovajɨsutɨnotɨ. Jaanoco guubuumo iijafaño iicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jaanegui miyamɨnaa diibojaago ufuumo gahafuuhi guhugamaryo gatyuucɨ. Jaamoco iimaaco jɨɨbeguehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jaanaa igueenemejedɨmo diibojaa sɨvauhi ihiibɨmoro idɨɨno isifañɨɨboco. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jaarumo miyamɨnaa agahafɨcɨnɨuneri Jesuvɨ ɨɨfutuutɨmo. Jaanegui caamotɨ tooja niibahucuco afaayɨcɨumoro Jesujaago diiboco nitusuumo icɨgaiijema. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jaanoco diito Jesuco imiyaavuguunoco agaajacɨɨboro Jesu nuuhi iguihuvaaboco: Guihi, dihimitɨ ɨco imibachucafutucuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jaarunaa saatoho caatɨnɨmɨnaa onoomo ɨgɨcɨnɨmañotɨ ijeebɨɨfañodɨ esamaaiuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Collɨhi jaanɨ jillɨ imitɨcani iimaahi? ¿Mɨɨjoho nacu imitɨco buusujirahi? Ɨdɨɨboro naha Moocaani, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Jaanoco Jesu agaajacɨuboro nuuhi: ¿Collɨhi tollɨ amɨɨhai jeebɨɨfañodɨ mehesamaaihi? Tɨhɨcani jana iguihuvaaboco: Dihimitɨ imibachucafutucuuhi, onoono; gañiivoobo dicɨgaiijema fuucu, onoono. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Jaamo magaajahi jiijehallɨ uujoho Miyamɨnaafibadɨ Ifiivuubo imitɨ imibachu mityama iicanoco, nooboro, ");
INSERT INTO bmrNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","idɨɨno isifañɨɨuboco nuubo: Ɨco neehi: Gañiivo, jaaboro dicɨgaiijeque dɨɨcɨɨbo fuucu diijajaago, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jaasumiro diibo agañiivuuboro icɨgaiijeque ɨɨcɨuboro fuucuuhi ɨɨfɨnɨcɨmofeenedɨ. Jaaneri paryɨ miyamɨnaa sihidɨ eetyeuhi. Jaamoro Moocaanico imehicaumo: Mahatyɨmetatɨhi aivo jillɨ iicanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jaanobuunatɨ siino Jesu fuuhi muuaijɨnivɨ. Jaabojaa sihidɨ miyamɨnaa saahicauhi. Jaamoco jɨɨbeguehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jaamañotɨ janaanɨcɨ afatyuhɨgo atyɨmeubo Levico Alfeo achi impuestoco ajaadusuhicajafaño gɨcɨnɨuboco. Jaaboco: Uuma difoo, nuubo. Jaanegui Levi agañiivooboro diiboma fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jaanobuunatɨ Jesu Levi iijafaño ijɨɨbogomɨnaama amachuubo gɨcɨnɨunaaca sihidɨ impuesto jaadusumɨnaa, bu iimitɨfimo icano gaseuhi. Jaamo sano diiboma machuhicauhi. Diibo dojɨcutɨ sihidɨ ufuumo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jaanaa fariseo caatɨnɨmɨnaa iicamo Jesuma diito amachunoco aatyɨmeumoro ijɨɨbogomɨnaaco nuuhi: ¿Mɨllɨ jaabo amɨɨhai jɨɨbogomɨnaafi, impuesto jaadusumɨnaama, bu saatoho iimitɨmɨnaama icano acasɨɨvooboro machuhi, aduhi icano? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jaanoco Jesu uguubuuboro diitoco nuuhi: Ubuheefiimo taabumɨnaafico imogotatɨhi. Jaanotɨ iguihuvamo taabumɨnaafico imeguefihi. Jaabadɨro uujoho: Imino icahi, onoomoco cuuhuvaqui saahinɨtɨhi. Iimifiitɨmeguiiha saahi iimitɨ ifiico ijeevesuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jaanaaca Jua jɨɨbogomɨnaa, bu fariseomɨ jɨɨbogomɨnaa icamo machutɨmo aigahicauhi. Jaanaa saatoho asaaumoro Jesuco dilluvauhi: ¿Naa, collɨhi jana fariseomɨ, Jua icamo jɨɨbogomɨnaa aaiganaa dita aigatɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jaanegui Jesu oovɨcɨuboro iimusuhi: ¿Nacu gaigooco ataabavaaboro ijɨɨbaimojaago ucuuhuvamo ɨdaasuri aigajirahi diitoma diibo iicanohachuta? Mɨɨro diitoma diibo iicanohachuta aigajitɨrumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Jaanotɨ naha icajinehiica jari uco tajɨɨbogomɨnaatɨ udumɨtɨɨcɨno. Jaadɨ jari ɨdaasuno iicaneri aigajimo. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","¿Mɨɨro mɨɨjoho eedeechehuco bobaryuri maahunɨtatɨhi? Jaanotɨ imaahunɨruva bobaryu tochehuco gallicujirahi. Jaaneri tohojɨ janaanɨcɨro guiraatejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jaabadɨro bu, ¿mɨɨjoho bohaivofaihuco eedeejutafaño ficutatɨhi? Jaanotɨ ificuruva tofaihu tujutaco ejerucarunoro fatyejirahi. Jaanegui bofaihuco bujutafaño mificutahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jaanaa judiomɨ jaguisɨsumi Jesu basutafañodɨ ɨgooboro feehicauhi. Jaanaa ijɨɨbogomɨnaa toono basuta noovataco ɨcɨmoro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jaanegui fariseomɨ diiboco nuuhi: Meecɨ ¿collɨhi dijɨɨbogomɨnaa ollɨ moonɨhi jaguisɨfucusumi momoonɨtatɨnoco? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jaanegui Jesu diitoco nuuhi: ¿Jaana nacu magaajatɨhi amɨɨhai, johono David, bu diiboma iicaumo icano ucuujɨvaachuusumi diitoco ajeba aivusuneguiiha omoonɨunoco? Mɨɨro Moocaani iija tabernaculojafaño David ufuuboro Moocaani jeecɨvo maahunoco machuuhi mɨɨjoho amachutatɨrunoco, Aviata onoobo sacerdotemɨ aivojɨɨbo iicaujiibo icaunaaca. Jaaboro bu diiboma iicaumoco acɨubo saatohoro sacerdotemɨ amachufirunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jaadɨ bu siino Jesu nuuhi: Mɨɨro jaguisɨfucu miyamɨnaadi eetavocafutuuhi. Jaanotɨ miyamɨnaa jaguisɨfucudi eetavocafutuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jaamaño uujoho Miyamɨnaafibadɨ Ifiivuubo jaguisɨfucu aivojɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jaadɨ siino Jesu sinagogajafaño fuuhi jahɨ icaubo saafi ihuse ifiigatyuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jaaboco ɨɨfɨnɨcɨmoro feehicaumo: ¿Naa jeedɨ jaguisɨsumi buheesujiibo? noomoro ɨɨfurumo diibohallɨvɨ ijɨɨbeguequi. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jaanoma iicaubo Jesu ihuse ifiigatyuuboco nuuhi: ¡Gañiivo! ¡Jaaboro feenevɨ dulleeve! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jaadɨ diitoco Jesu dilluuhi: ¿Jinejeque jaguisɨsumi moonɨsunɨcɨmo iiminoco, nacu iimitɨnoco? ¿Magaicaaunoco, nacu mubuheesunoco? nooboro. Jaarunaa diito iimusuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jaanegui diito jeebɨɨno cuhuferi ɨɨdaasuvuuboro, sɨfiirano ihuufococo emeecɨuboro ihuse ifiigatyuuboco nuubo: ¡Dihuseque fallirihicaru! nooboro. Jaanegui diibo fallirihicaruhi. Jaasumiro diibo use dojɨcuvɨro imituuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jaasumiro toonotɨ ifariseomɨ ufuumoro Herodianomɨma fitacucasiuhi Jesuco igaicaauqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jaanaa Jesu ijɨɨbogomɨnaama muuaijɨnivɨ fuuhi. Jaamoco sihidɨ miyamɨnaa bucasiuhi Galileaoto, Judeaoto, Jerusaleoto, Idumeaoto, bu Jorda oonegueehioto, bu Tiro, Sidon icano jɨninooto icamo diibo sihidɨ ejeevanoonoco omoonɨhicaunoco uguubumoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jaanegui ijɨɨbogomɨnaaco nuubo: Uco miyamɨnaa ijene eñeñejeruujiruneguiiha momeenegaco mihimibaicɨnɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jaabo Jesu miyamɨnaaco ubuheesuhicaunegui sihidɨ iguihuvanoma iicadɨmo diiboco idudɨɨcɨqui ijene ñeñejeruhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jaabadɨro bu ɨjɨmɨ diiboco aatyɨmemere diibo ɨmega baavɨ aquetehicauhi. Jaamoro gaihivehicaumo: Ɨɨjoho Moocaani Achi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jaarumoco faguehicaubo: Uco satohoco magaajasudino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jaanobuunatɨ Jesu ifabaɨvɨ fuuhi. Jahɨgo iimuguudɨmoco coovaubo. Jaanegui diibojaa saaumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jaamoco fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨmoco ɨcɨubo diiboma iicaqui, bu diitoco igalluuqui jɨɨbogoco ijɨɨbeguequi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jaamoco iijɨco acɨubo ɨjɨmɨco igañɨɨhicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jaamo jinoodɨmou fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨmo iicaumo; Simon icaruuboco Pedrotɨ omomonɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacoobo Zebedeo achi, bu Jua Jacoobo nahabo icano. Jaamɨsico momonɨubo Boaneegemɨsitɨ, sisiseememɨsi eneejirunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre, Felipe, Bartolome, Mateo, Tomas, bu Alfeo achi Jacoobo, Tadeo, Simon cananista, bu ");
INSERT INTO bmrNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Juda Iscariote diiboco aacɨujiibo igaicaauqui icamoma saaubo jaahe. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jaanaa siino sihidɨ miyamɨnaa diibojaa igaivehicauhi. Jaaneri Jesu ijɨɨbogomɨnaama ajashuno jinejebaco machuhicacutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jaanoco Jesu yoto uguubuumoro saauhi diiboco ɨɨcɨvamo, jillɨ jeegavoobo eneehicauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jaabadɨro bu caatɨnɨmɨnaa Jerusaletɨ asaaumo neehicauhi: Beelzebuma icaabo ɨjɨmɨ aivojɨɨboma. Jaamaño diibo mitya iijɨri ɨjɨmɨco buhɨ gavaracuhicaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jaanegui Jesu diitoco ocoovauboro siinovɨ oovɨcɨɨboro neehicauhi: ¿Mɨllɨ jaabo Satanas bu ifiicoro buhɨ gañɨɨjirahi? ");
INSERT INTO bmrNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mɨɨro saafi aivojɨfaño minoocɨ udugaavonoro sanomɨro imoonɨcasiruva sanomɨro finɨsucasijirahi. Jaamaño tohaivojɨ gueenene icajitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jaabadɨro bu sajaotoro sanomɨro imoonɨcasiruva gueenene icajitɨrumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jaabadɨro Satanas iinoro ifiimaryo imoonɨcasiruva, ¿mɨllɨ bu gueenene icajiruubo? Iinoro ifiico finɨsujiruubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jaabadɨro ¿mɨɨjoho esefaabo iijafaño ofoomoro inehejeque ɨcɨjitɨrahi abajaaboco sisɨtɨmoro? Jarihiicanaa abajaaboco isisɨdɨ ɨcɨjirumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Miyanotɨro jino amɨɨhaico neehi: Miyamɨnaaco paryɨɨcɨno imitɨno ihiimaaruno buusucafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jaanotɨ Moocaani Gaijatɨ imitɨno ihiimaaboco toono aivo buusuracujitɨhi ufucuro. Jillɨ tohimitɨnoma iicacujiibo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jillɨ diitoco nuubo, diiboco ɨjɨma icaabo, eneehicaunoma iicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jaanobuunatɨ Jesujaa seejɨ, inahabomɨ icamo asaaumoro jahisitɨro diiboco cuuhuvasuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jaanegui Jesuhallɨdɨ emecucɨnɨumo diiboco nuuhi: Diiseejɨ, dinahabomɨ icamo ɨco jahisitɨ cuuhuvahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jaanegui Jesu nuuhi: ¿Mɨɨjoho gaharubi? ¿Mɨɨjoho tañahabomɨ? nooboro ");
INSERT INTO bmrNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ihallɨdɨ emecucɨnɨumoco emeecɨuboro diitoco nuuhi: Jino tacojɨri iicamo gaharubimɨ, tañahabomɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jarihiicanaha jino Moocaani iijɨco omoonɨmo tañahabomɨ, gaharubimɨ, tañagomɨ icano iicajimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jaadɨ siino Jesu miyamɨnaaco jɨɨbeguehicauhi muuaijɨnivɨ. Jaabojaago sihidɨ miyamɨnaa igaivuuhi. Jaanoma iicaubo meenegafaño ɨjɨcafutuuboro diitotɨ tehesijɨsuno ufuuboro casɨɨvutuuhi. Jaanotɨ diito ijɨnivɨ jiinɨgaibaahohallɨvɨro icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jaaboro diitoco sihidɨ siinovɨ oovɨcɨɨboro jɨɨbeguehicauhi ");
INSERT INTO bmrNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","jillɨ nooboro: Jinoco muguubu: Basumɨnaafi fuuhi abasutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jaabo abasuuno samañoono jɨɨhaifaño acutuuhi. Jaanoco joomɨ asaaumoro machujeuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jaanotɨ samañoono acutuuhi guiisihallɨvɨ miyaadɨ jiinɨ achahaumañovɨ. Jaanoro goovano iinucuuno ijiinɨje miyaadɨ efeemeutɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Jaaruno nɨhɨba aachɨcɨuneri aryɨvucuuno, chuumucuuno icano abacocoovautɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jaanotɨ samañoogahaije aifuuhi jarɨɨmɨhoonofeenevɨ. Jaano toono ihallɨvɨ ujusiuno toono ihiinuurunoco macanɨsuuhi. Jaamaño noovautɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jaanotɨ samañoono acutuuhi imino jiinɨjevɨ. Jaano ihiinuunoro jusicuuno. Jaanoro imino noovacuuno saheeje treintadɨgaiva noovacuuhi, bu saheeje sesentadɨgaiva noovacuuhi, bu saheeje ciendɨgaiva noovacuuhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jaaboro neehicaubo dinohojɨma idiicaabo jinoco guubu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jaanobuunatɨ iinoro iicacuudɨ ijɨɨbogomɨnaama iicaumo diiboco dilluuhi: ¿Mɨllɨ toono eneejiruno? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jaanegui nuubo: Amɨɨhaico naha uujoho imino gaajasuhicahi Moocaani aivojɨ agaajaratɨnoco. Jaanotɨ buhɨ iicamoco jillɨ siinovɨ oovɨcɨɨboro neehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jaamo emeecɨrumo atyɨmetɨmo iicaqui, bu guubucurumo guubutɨmo iicaqui. Mɨɨro uguubumoro iimitɨco jeevesujirumo. Jaamoco bu iimitɨ buusucafetejirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jaadɨ bu ijɨɨbogomɨnaaco nuubo: ¿Nacu amɨɨhai magaajatɨhi jino jillɨ ohoovɨcɨnoco? ¿Jaana mɨllɨ magaajaji paryɨ toonoco? ");
INSERT INTO bmrNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mɨɨro basumɨnaafi, oono Moocaani iijɨco ɨjɨɨbogoobo abasuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mɨɨro jino jɨɨhaifaño aacotono onoono; mɨɨro saatoho jeebɨɨfa abasucuurunoco ɨjɨɨbugucuurunoco Satanas asaaboro ijeebɨɨfañotɨ dumɨtɨɨcɨcuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jaabadɨro bu oono guiisihallɨvɨ abasuuno onoono; mɨɨro saatoho uguubusumiro imo imo gaayɨcɨfimo. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jaaruno imino abacocoovatɨmaño gueenene icatatɨno nɨsuhifiivɨ agasesumi uhuuchuvomoro toonoco jeevesufimo. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jaanotɨ sano jarɨɨmɨhoonofeenevɨ aacutuuno tobogoco gaayɨcɨcuurumo ");
INSERT INTO bmrNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","jiije busumije jaagovɨro ijeebɨɨno nɨjɨ nɨjɨ iicamaño, bu iimitɨnocoro iimogomaño icano sanooro toono diito jeebɨɨfaño agahafonoguiinodɨ toono miyaajɨ iicarujɨco fiivusutɨmo. Jaamaño noovasutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jaanotɨ jino imino jiinɨjevɨ abasuuno onoono; oono miyanotɨro agaayɨcɨmoro imino omoonɨmofaño fiivono jaanoro noovacuuno saatohofaño treintadɨno, saatohofaño sesentadɨno, bu saatohofaño ciendɨno icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jaadɨ bu nuubo: Cɨɨjɨgaimecuco mɨnɨfutusumoro baavɨ guirihilluguiino, bu cɨgaiijeguiino icano mificutatɨhi. ¿Ɨvɨnaaca mɨnɨfutusumoro caamovɨ mificutahi foovono ihɨfuvusuqui, etɨ? ");
INSERT INTO bmrNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jaabadɨ mɨɨro chahano afatanɨcɨnɨno atyɨmeratɨno iicajino. Bu tollɨro chahano agaajaratɨno gaajacafototɨno iicajino. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jaanegui jinooco amɨɨhai nohojɨma mihicaamo muguubu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jaadɨ bu diitoco neehicaubo: Imino magaaja jino muguubunoco. Mɨɨro oono amɨɨhai mohoovɨcɨhicaneriro ufucu amɨɨhaico Moocaani oovɨcɨji. Jaaboro oono uguubumoco janaanɨcɨ acɨjiibo. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tollɨro bu iicanoma iicaaboco siino janaanɨcɨvɨ acɨjiibo. Jaanotɨ chahanoma iicaaboco mɨɨdɨno iicarunoco dumɨtɨɨcɨjiibo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jaadɨ bu tollɨro neehicaubo: Jiibadɨ Moocaani aivojɨ jeevahi; miyamɨnaafi jiinɨjefaño siino toogaico abasuuboro cɨgatoobo, ");
INSERT INTO bmrNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","bu seseevedɨ agañiivooboro icaabo cuujehachuta, fucuhachuta icano sifucu, sifucu icano fatyehi. Jaanaa toogai mɨllɨ acho ihiinogairo jusihi diibo gaajacɨtɨnaaca. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jiinɨje toohoco fiivusuhi itɨconɨ ifahooco. Jaadɨ ideecanoco. Bu jaadɨ ifagaiño ifallahifaño gahafonɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jaano ifagaiño ujusicuudɨ ɨcɨnɨcɨcuumo niisugari ihɨcɨfucu agasecusumi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jaadɨ bu neehicaubo: ¿Jinejebadɨ Moocaani aivojɨ jeevahi? ¿Jinejevɨ fɨne mohoovɨcɨji? ");
INSERT INTO bmrNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Fɨne mostaza noovata tooɨco jiinɨjefaño mabasunɨcɨyɨbadɨ jeevano. Mɨɨro tooyɨ aivo jiinɨjehallɨri iicano noovata ajashuyɨgaiyɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jaaruho abasucafutucuudɨ jusifihi guiraaho tyɨgaba. Jaahoro coohafeene lliicuvafihi. Jaaho aafeneguiino joomɨ iicuvajirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jillɨ nooboro Jesu jɨɨbeguehicauhi miyabogoco siinovɨ oovɨcɨɨboro diito agaajajidɨnoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tɨcovono nootɨɨbo, jillɨ siinovɨ oovɨcɨɨboro neehicaubo. Jaanotɨ naha ijɨɨbogomɨnaaco ijeevadɨ paryɨ imino jɨɨbeguehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jaanaa mihiijɨcuudɨ ijɨɨbogomɨnaaco nuubo: Masɨɨ onago muuaivɨ mafatyequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jaadɨ imiyamɨnaaco agalluudɨ Jesumaryo fuumo meenegari. Jaamoma bu sagaaje diito dojɨcutɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jaanaa sefano guibuhuba diitoco feene muuaivɨ ɨcɨuhi. Jaano sihidɨ tyuucai iicauneri diito meenegafaño nɨfaihu gahafehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jaanaa Jesu dojɨcuogavɨ iinigaɨ jeebutahaallɨvɨ cɨgahicauhi. Jaaboco aaicusuumoro nuuhi: Mojɨɨbogomɨnaafi, ¿naa diimeguehi miguijeveneque? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jaanegui Jesu aaicuuboro guibuhubaco ɨbauhi. Jaadɨ bu muuaico nuubo: ¡Llɨɨvɨcu toonovɨro sɨɨcuto! nuubo. Jaanegui iguibuhuba llɨɨvɨcuuhi. Jaanoro paryɨ imino sɨɨcutucuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jaadɨ ijɨɨbogomɨnaaco nuubo: ¿Collɨhi sihidɨ mihiguetehi? ¿Nacu Moocaanico mimiyaavogotɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jaaneri sihidɨ diito igutuumoro noocasihicauhi: ¿Mɨɨjoho fɨne jaanɨ jino guibuhubamaryo, muuaimaryo icano diiboco: Jii, onoono? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jaadɨ fuumo onagoo muuaivɨ Gadarenomɨ jiinɨjejaago. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jaabo Jesu imeenegafañotɨ iinuubaacaro cɨɨhojɨnojaa iicahicauhɨgotɨ emeimɨvatuubo diibojaa saauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jaabo cɨɨhojɨno iicahɨgo iicaaboro feehicauhi. Jaaboco mɨɨhaiñooba jɨgaiñehineri duujenɨcutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Fiiva foova ihuseneque, itɨhaiñoco icano jɨgaiñehineri sisɨcuurumo. Jaarunoco ihusenehonoco dubaicɨubo, bu itɨhaiñonoco ɨdɨdaheje moonɨubo icano. Jaaboco mɨɨhaiñooba guiinonɨcutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jaabo cuujehachuta, fucuhachuta icano ifagajɨneri cɨɨhojɨnohallɨdɨ coovadiicɨnɨɨboro feehicauhi. Jaabo inoro ihallɨco guiisibaneri tujaacuuboro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jaabo Jesuco tehesinotɨro aatyɨmeuboro diibojaago ijinafatyuuboro iguiino memuɨɨvutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jaaboro sefano nuuhi: ¿Jinejeque diimeguehi ɨɨjoho Jesu caamovohɨgo iicaabo Moocaani Achi? Moocaanifañodɨ ɨco neehi: Ɨdaasuno uco moonɨdino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jillɨ nuubo ɨmegavɨro Jesu diiboco: Diinucu idiimitɨno ɨjɨ, eneehicauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jaanegui Jesu diiboco dilluuhi: ¿Jineje dimomo? nuubo. Jaanegui iimusuubo: Cuumi tamomo miguiraaneguiiha, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jaaboro Jesuco jenaauhicauhi: Mɨɨhaico jiicuumitɨ buhɨ galluudino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jaanaa ifagajɨ fiitɨno sihidɨ faafaimɨ amachumo icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jaanegui paryɨ famooro ihɨjɨmɨ Jesuco nuuhi: Mɨɨhaico jaatyo faafaimɨjaa gallu diitofaño mefeequi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jaanegui Jesu nuuhi: Jii, tahɨ mofoo, nooboro. Jaanegui tohɨdicu ɨjɨmɨ diibo Gadarenomɨnaafitɨ ihiinoomoro ifaafaimɨfaño fuuhi dos mildɨmofaño. Jaamo ifagajɨtɨ imuuaifaño aaifuumoro macanɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jaanotɨ diitoco eteemehicamo agaaumoro ifaacuumifaño, bu buhɨgueeje iicajaajefaño icano jɨɨbogomoro fuuhi. Jaanegui asaaumoro meecɨvaumo jineje fɨne onoomaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jaamo Jesujaa asaaumo atyɨmeuhi meimɨ cuumima iicaubo gɨcɨnɨɨbo gaachehufaño jɨɨcɨnɨɨboco, bu imino iicacuuboco icano. Jaaboco aatyɨmeumoro sihidɨ iguiumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jaamoco toonoco aatyɨmeumo jɨɨbuguuhi ihɨjɨmɨma iicauboco omoonɨunoco, bu ifaafaimɨco omoonɨunoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jaanegui Jesuco ijiinɨjetɨ galluumo: Fuucu, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jaanoma iicaubo Jesu meenegafaño ifeequi jɨcafutuuboco ihɨjɨmɨma iicaubo neehicauhi: Ɨɨma saahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jaarunaa Jesu diiboco nuuhi: Chahano diijajaagoro fuucu. Jaaboro diyotoco dɨɨbogo guiraano Aivojɨɨbo Moocaani ɨco ɨɨdaasugooboro ubuheesunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jaanegui ufuuboro paryɨ Decapoli cuumineri jɨɨbogooboro feehicauhi Jesu diiboco ubuheesuunoco. Jaaneri paryɨ miyamɨnaa jabafiitehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jaadɨ siino Jesu meenegari onagoo muuaivɨ fatyuuhi. Jahɨgo sihidɨ miyamɨnaa iicojɨvɨ igaivuuhi muuaijɨniri icaubo cojɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jaanaa sinagogaja aivojɨɨbo Jairo onoobo, diibojaa saauhi. Jaabo Jesuco aatyɨmeuboro iguiino ememuɨɨvutuuboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aicɨgai aivo niinovacuuhi goova foobo diigoco dudɨɨcɨto ubuheeteguere iicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jaanegui diiboma ufuuboco miyamɨnaa sihidɨ ubucasiumo ijene ñeñejeruhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jaamofeenedɨ saafigo gaigo tɨɨjeheri fahuseecɨ motɨhaitɨ mificabacɨ ɨdɨɨno iicaucuugo. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jaago fiivaamo taabumɨnaa ataaburunofaño buheetɨgofañovɨro feehicaugo. Paryɨ inɨhɨbamɨco ajaaduhicauhɨgo finɨsucuugo. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jaago Jesutɨ ɨjɨɨbocasinoco uguubuugoro miyamɨnaafeenedɨ asaaugoro ibujɨnaagotɨ igaachehuco dudɨɨcɨvauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jillɨ igaachehuco ududɨɨcɨneriro buheeji, noogoro esamaaihicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jaasumiro itɨɨjoho diigoco fiigatyuuhi. Jaanotɨ gaajacɨugo ubuheetecuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jaasumiro Jesu gaajacɨuhi ififañotɨ imitya mihiinobadɨ iicaunoco. Jaanegui imiyamɨnaajaagovɨ ɨɨmeveuboro diitoco nuuhi: ¿Mɨɨjoho tagaachehuco dudɨɨcɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jaarunaa ijɨɨbogomɨnaa diiboco nuuhi: Miyamɨnaa oono ɨco ɨjɨmatajerunoco daatyɨmehi. Jaanegui ¿mɨllɨ: ¿Mɨɨjoho uco dudɨɨcɨhi? neehi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jaarunaa Jesu fahɨgovaco ɨɨfɨnɨcɨhicauhi ihatyɨmequi: ¿Mɨɨjoho fɨne dudɨɨcɨhi? onoomaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jaanegui diigo sihidɨ vɨvɨ vɨvɨ iigutuugoro ubuheeteunoco agaajacɨugoro diibojaa saauhi. Jaagoro iguiino ememuɨɨvuugoro paryɨ imino jɨɨbuguugo. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jaanegui diigoco nuubo: Ñɨba ɨco dimiyaavogo buheesuhi. Jaaneguiiha sajeebɨɨ fuucu, diguihuvatɨ buheetecuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jillɨ iimaaubaacaro sinagogaja aivojɨɨbo iijatɨ saatoho jillɨ noomoro saauhi: Daicɨgai guijevecuuhi. Fɨne Mojɨɨbogomɨnaafico acasivusuno, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jaanoco Jesu uguubuuboro isinagogaja aivojɨɨboco nuuhi: Diguetejirahana, jillɨ miyaavogo, nooboro fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jaaboro mɨɨhaiñooba diiboma ufuunoco imuguutɨɨbo ɨdɨɨmomaryo Pedro, Jacoobo, Jua Jacoobo nahabo icamomaryo fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jaamo isinagogaja aivojɨɨbo iijavɨ ɨɨfutuuhɨ atyɨmeuhi gañuhusuno omoonɨunoco, miyamɨnaa ataacasiunoco, agaibacasiunoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jaanegui Jesu ɨjɨcafutuuboro diitoco nuuhi: ¿Jinejeri guiraacani gañuhusuno mɨsɨramaaihi? ¿Collɨhi mataacasihi? Guijevetɨgo. Jillɨ cɨgago bagocaja, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jaarunaa diiboco dejecuhicaumo. Jaaneguiiha Jesu paryɨɨcɨno famoocoro jahisivɨ ihiinusuuboro caani, seejɨ iicamɨsicoro satyuubo, bu diiboma asaaumo iicamomaryo fuubo tobagocaja iicauhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jaaboro diigoco ihusetɨ agaayɨcɨuboro hebreo iijɨri nuuhi: Talita, cumi. nooboro. Jillɨ, bagocaja, ɨco neehi: Gañiivo, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jaasumiro tobagocaja agañiivuugoro ɨgucuuhi. Jaago tusumi fahuseecɨ motɨhaitɨ mificabacɨ ɨdɨɨno ficabava icacuuhi. Jaaneri miyamɨnaa sihidɨ igutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jaamoco Jesu imino faguuhi: Mɨɨco mɨjɨɨbeguedino, nooboro. Jaaboro tajɨɨbaubo: Tobagocajaco mamachusu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jaadɨ Jesu toonotɨ ufuuboro ijiinɨjejaagovɨ siino uumiubo. Jaaboma ijɨɨbogomɨnaa fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jaadɨ judiomɨ jaguisɨfucu iicacuudɨ tɨcovaubo ɨjɨɨbogoobo sinagogajafaño. Jaanoco sihidɨ miyamɨnaa uguubumo sihidɨ ajabafiituumoro neehicauhi: ¿Cuucatɨ fɨne gaajaabo paryɨ jinehejeque? ¿Mɨllɨ fɨne diibo igaajaco gaayɨcɨuhi? Mee jino agaajaratɨnehejeque moonɨɨbo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mɨɨro du jaanɨ ɨmohobujene dudɨcamaajemɨnaafi Maria achi, Jacoobo, Jose, Juda, Simon icamo nahabo, tollɨro bu jino inagomɨ mɨɨhaifeeneri icahi, noomoro diibotɨ sɨfiiratehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jaaneguiiha Jesu diitoco nuuhi: Moocaani iimaamɨnaafico fahɨgovaoto bocɨguefihi. Jaanotɨ ijiinɨjeoto, iyoto, iijaoto icano bocɨgotatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jaanoma iicaubo imityaco eetavuutɨɨbo, mɨɨdɨmocoro iguihuvaumotɨ buheesuubo ihuseque ihallɨ ificuuneri. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jaamo imiyaavuguutɨneri sihidɨ eetyehicaubo. Jaanobuunatɨ Jesu ifiitɨ cuumijeri feehicauhi jɨɨbogooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jaadɨ coovaubo ijɨɨbogomɨnaaco fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨmoco. Jaaboro diitoco galluubo miimɨsiicɨsaajeri. Jaaboro iimitɨno ɨjɨmɨco buhɨ igavaracuqui mityaco aacɨuboro ");
INSERT INTO bmrNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","diitoco nuubo: Jinejebaco masatyedino. Jɨɨhaivɨ ɨdɨɨnocoro queseico masatyo. Jaanotɨ lleegucubaco, duviricubaco, nɨhɨbamɨbaco icano masatyedino amɨɨhai niivɨgai meehevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bu saapaajequere tɨhaipaajeque mɨjɨcafoto, bu michehucɨ mɨjɨcafetedino saachehumaryo mofoo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jaamo coojaavɨhacho mɨhɨfotojafañoro mihica, siijafaño, bu siijafaño icatɨno. Jari tomañotɨ mofoodɨ toojatɨ mihiino. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jaanotɨ comañovɨ acho amɨɨhaico agaayɨcɨtɨhachiijɨ, uguubutɨhachiijɨ icano toonotɨ mihiinomoro amɨɨhai tɨhaipaajeguiino jiinɨco toonovɨ matatacu jei diito iimitɨco ijɨɨbeguequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jaanegui ufuumoro miyamɨnaaco jɨɨbogomoro feehicauhi iimitɨco ijeevesuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bu tollɨro sihidɨ buhɨ gañɨɨhicaumo iimitɨno ɨjɨmɨco, bu iguihuvamoco dɨɨrɨbari ejeesumoro buheesuhicaumo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jaanaaca toojiinɨjeo aivojɨɨbo Herode guubuuhi Jesuditɨ fahɨgovadɨ ɨjɨɨbocasihunoco. Jaanoco saatoho neehicauhi: Diiboro Jua Nitɨmɨnaafi siino ubuheeteebe. Jaamaño sihidɨ mityama icaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jaanotɨ saatoho neehicauhi: Jaanɨ Moocaani iimaamɨnaafi Elia, noomoro. Jaanotɨ saatoho neehicauhi: Jaanɨ sɨɨcɨje Moocaani iimaamɨnaa iicaubadɨ iicaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jaanoco Herode uguubuuboro nuuhi: Diiboro Jua, uujoho iinigaɨco iquitɨcɨsuubo dojɨcuvɨro siino ubuheeteebe, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mɨɨro Herodia noojɨri Herode atajɨɨbauneguiiha Juaco isisɨmoro cɨvojanɨumo. Herode inahabo Felipe taaba Herodiaco ɨcɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jaanegui Jua Herodeque: Imitɨno dinahabo taabama idiicano, neehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jaanoma iicago Herodia Juaco ɨjɨɨhegueguere gaicaausuhicaujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jaarunaa Herode Jua jeebɨɨ ɨtɨcovonoco, iiminoco icano gaajahicauhi. Jaanotɨ iigotooboro diiboco mɨllɨ moonɨhicautɨhi. Diibo onoonoco gaajatɨruubo jillɨ imino guubunɨcɨhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jaana Herodia diiboco agaicaausuujifucuvɨ ɨfutuuhi. Mɨɨro Herode ifiivu ficabavɨ ɨɨfutufucu iicauneguiiha jɨɨbaimoco eetavuuhi. Jaaboro imiyamɨnaaco cuuhuvaubo ihamocasimɨnaa aivojɨtoco, bu Galilea jiinɨje bocɨfimoco, bu tajɨɨbamɨnaaco icano diitoma imachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jaanaa Herodia aicɨgai ufuugoro diito ɨmefeenevɨ gaaseteuhi. Jaanoco Herode, bu diiboma iicaumo icano imuguuhi. Jaaneguiiha ihaivojɨɨbo Herode tobagocajaco nuuhi: Idiimogonoco uco dillu ɨco acɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Miyanotɨro Moocaani momofeenedɨ ɨco neehi: Paryɨ uco idillunoco ɨco acɨji, paryɨ tabusumije icarunotɨfeenedɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jaanegui ufuugoro seejɨco nuutugo: ¿Jinejeque dilluji? noogoro. Jaanegui seejɨ nuuhi: Jua Nitɨmɨnaafi nigaɨco dillu, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jaanegui tobagocaja ihaivojɨɨbojaa goovanogayɨ ufuugoro diiboco nuutuhi: Jisumiro imeguehi butajefaño Jua Nitɨmɨnaafi nigaɨco uco adaacɨnoco, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jaaneri Herode sihidɨ ɨdaasuvuhi. Jaarunaa diigoco Moocaani momofeenedɨ unuucuneguiiha, bu diiboma iicaumo uguubuucuneguiiha icano diigoco unuunoco bañɨsugutɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jaanegui Iherode tusumiro amocasimɨnaafico atajɨɨbauboro galluuhi Jua Nitɨmɨnaafi nigaɨco isɨvaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jaanegui ihamocasimɨnaafi ufuuboro cɨvojafaño icaubo nigaɨco iquitɨcɨuboro butajefa sɨvaaubo. Jaayɨco tobagocajaco acɨubo, bu jaayɨco diigo seejɨco acɨtuuhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jaanoco Jua jɨɨbogomɨnaa uguubuumoro saauhi. Jaamoro diibo ifiico ɨɨcɨjeumoro cɨɨhojɨfaño ficuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jaadɨ Jesujaa iminɨsumɨnaa iigaivuumoro diiboco jɨɨbeguehicauhi paryɨ omoonɨuno ɨjɨɨbuguno iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jaarunaa Jesu diitoco nuuhi: Masɨɨ majaguisɨtequi sihɨgo sɨcaihɨgovɨ, nooboro. Mɨɨro diitojaa sihidɨ miyamɨnaa asaamo, ofoomo icano feehicauhi. Jaaneri amachujiru situba chahahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jaanegui Jesu ijɨɨbogomɨnaamaryo meenegari sihɨgo sɨcaihɨgovɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jaarunaa guiraamo ufuunoco atyɨmeuhi. Jaamoro Jesumɨ iicaunoco agaajacɨumoro faacuumivaoto isidɨ diito dojɨcutɨ jinoocɨnɨuhi. Jaamo ihɨmegaro tomañovɨ ɨfutuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jaanaa Jesu imeenegafañotɨ iinuubo sihidɨ miyamɨnaaco atyɨmeuhi. Jaanoma iicaubo diitoco sihidɨ ɨdaasuguuhi ovejamɨ itoomomɨnaafima achahamobadɨ iicauneguiiha. Jaaboro fanoovaco sihidɨ diitoco jɨɨbeguehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jaanaa iijɨcuunegui ijɨɨbogomɨnaa asaaumoro diiboco nuuhi: Mihiijɨcuuhi. Jaanomaryo bu jimañovɨ mɨɨhaiñooba iijano chahahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jaaneguiiha gallucu miyamɨnaaco ifiitɨcuumijaago, bu ifiitɨjajejaago icano ofoomoro machutatɨ inaajequi. Mɨɨro imachutama chahamo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jaanegui Jesu diitoco nuuhi: Amɨɨhairyo diitoco mamachusu, nooboro. Jaanegui dilluumo: ¿Jaamo jino dosciento denarioriro maahunoco manaajeteji paryɨ diitoco mamachusuqui? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jaanegui Jesu diitoco nuuhi: ¿Mɨnoodɨno nacu amɨɨhaima maahuno icahi? Ene, memeecɨto, nooboro. Jaanegui emeecɨjeumoro nuumo: Sahuse ɨcava, bu miimɨsiicɨ taavaabomɨsi icano, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jaanegui famoocoro tajɨɨbaubo saatoho simañovɨ, saatoho simañovɨ icano icasɨcamaaiqui ñaavahuhallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jaanegui casɨɨcamaaiumo ciendɨmova saaje, cincuentadɨmova saaje icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jaadɨ Jesu gaayɨuhi ihusefaño sahusedɨno imaahuno iicaunoco, bu itaavaabomɨsico icano. Jaaboro niquejeque emeecɨɨboro toonohallɨvɨ Moocaanima iimaaubo. Jaadɨ tohɨcajeque iibacuuboro ijɨɨbogomɨnaaco acɨubo miyamɨnaama ihɨfequi. Jaadɨ bu itaavaabomɨsico tollɨro ɨɨfuumo paryɨ famoomaryo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jaanoco amachuumoro paryɨ tuvaumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jaano atyuuvoco ananɨumo jɨiibaiñoco gahafusuuhi fahuseecɨ motɨhaitɨ miibaicɨ ɨdɨɨno, bu itaavaabomɨsi atyuuvo icanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jaanoco amachuumo cinco mildɨmou gaifiimɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jaadɨ Jesu ijɨɨbogomɨnaaco galluuhi ihɨmega imeenegari onagoo muuaivɨ Betsaida cuumijaagovɨ ifatyequi miyamɨnaaco diibo ifitacuunohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jaadɨ diitoco ifitacuuboro ifagajɨjaago fuubo Moocaanima ihiimaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jaanaa cɨvucuhɨ ijɨɨbogomɨnaa imeenegari ufuumo feene muuairi icacuuhi. Jaanotɨ diibo inoro tahɨ isi icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jaabo atyɨmeuhi diitoco sefano buhudurumoco guibuhuba sihɨgovɨro ebecasuhicaunoco. Jaanaa diibo jari cuujetavɨ diitojaago saauhi nɨfaihuhallɨdɨ ɨgooboro. Jaabo diitoco fatyuujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Jaabo nɨfaihuhallɨdɨ asaaunoco paryɨ famooro aatyɨmeumoro gaibacasiuhi: Fɨne ɨjɨ, noomoro igutuuhi. Jaarunaa diitoco nuubo: ¡Mequehecu! ¡Mihiguetejirahana! Uujoho, nooboro diitojaa jɨcafutuubo imeenegafaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jaasumiro iguibuhuba sɨɨcutuuhi. Jaaneri diito sihidɨro eetyeuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jillɨ bu gaajacurumo esɨcɨnɨutɨhi maahunoco iguiraatusuunoco, jillɨ diitoco ijeebɨɨno ucuhufunuutumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jaamo imuuaico oonegueehivɨ afatyuudɨ ɨɨfutuumoro cañavutuuhi Genesare cuumi nagueehivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jaamo imeenegafañotɨ iinuumaacaro Jesuco miyamɨnaa gaajacɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jaamoro faacuumivariro jinoocɨnɨumo. Jaamoro tɨcovaumo iguihuvamoco cɨgaiijeneri acañɨmo Jesu tahɨ icahi onoohɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jaabo fahɨgovadɨ ofoohɨgo imɨɨdɨcuumijeri, iguiraacuumijeri, bu buhɨ iicajajeri icano ofoohɨgo goohasinofaño iguihuvamoco ificuumoro Jesuco neehicauhi: Jillɨ digaachehujɨnibaco dudɨɨcɨsu, noomoro. Jaamo paryɨ diibo gaachehujɨnibaco ududɨɨcɨmo buheetehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jaanaa Jerusaletɨ asaaumo fariseomɨ, bu caatɨnɨmɨnaaoto icamo Jesujaa igaivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jaamo atyɨmeuhi Jesu jɨɨbogomɨnaa mɨhɨniva usejeri nitamaaitɨmo amachuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mɨɨro jaamo fariseomɨ, bu paryɨ judiomɨ icamo sɨɨcɨjemɨnaa jeevamaajequere ɨsɨvamoro itɨconɨ iminehihiica initamaaitɨsumi machutatɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jaamo bu naajete asijaagotɨ asaamo itɨconɨ initamaaitɨsumihiica machutatɨmo. Mɨɨro jillɨ sɨɨcɨjemɨnaa jeevamaajequere sɨvamo, oono adutahilluno, bu guirihilluno, bu aarɨcuhilluneje icano nitɨnejequere moonɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jaamaño fariseomɨ, bu caatɨnɨmɨnaa icamo Jesuco dilluuhi: ¿Collɨhi dijɨɨbogomɨnaa amiyato jeevamaajebadɨ moonɨtɨmo mɨhɨniva usejeri machuhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jaanegui Jesu diitoco nuuhi: Miyaanoco jahi amɨɨhaitɨ Isaia caatɨnɨuhi amɨɨhai bañɨsumɨnaa mihicamoco. Jillɨ caatɨnɨubo: Jiicuumi uco jillɨ tɨcovono iijɨriro bocɨguehicahi. Jaarumo jeebɨɨno uuditɨ tehesino icahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jillɨ iigaivomoro uco imehicarahi. Jaarunaa uuri bañɨsuquimaaimo. Jillɨ amɨɨhai jɨɨbogono, tɨcovo miyamɨnaa jɨɨbogonoro. Jaarunoco Moocaani tajɨɨbajɨ, meneehicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mɨɨro amɨɨhai Moocaani tajɨɨbajɨco mejeevesumoro miyamɨnaa iijɨcoro magaayɨcɨhi. Oono guirihilluno, adutahilluno icano nitɨnehejequere aivo guiraano meheetavehicahi, nuubo Jesu. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jaaboro bu nuubo: Jillɨ toono amɨɨhai jeevamaajequere mɨsɨvamoro Moocaani tajɨɨbaco uufocovɨ mejeevesuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mɨɨro Moise nuuhi: Gaijɨ diicaanico, diiseejɨco icano. Jaanotɨ caanico, seejɨco icano imitɨno onooboco miyanotɨro guijevesu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jaanotɨ amɨɨhai monoonɨcɨhi miyamɨnaaco: Amɨɨhai caanimɨco monootahi: Ɨco amusujitɨhi, paryɨ uuma iicano Corban, noomoro Moocaanico ɨjɨbaicuuno eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jillɨ amɨɨhai monoomaño caanico, seejɨco icano mahamususuhicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jaamaño amɨɨhai Moocaani iijɨco majabatusuhi amɨɨhai jeevamaajequere sifiitɨ, sifiitɨ icano mafatyusumaño. Jaamo jiibadɨje iicanehejequere guiraano aivo meheetavehicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jaaboro siino Jesu miyamɨnaaco ocoovauboro nuuhi: Famooro uco muguubunɨcɨ. Jaamoro magaaja: ");
INSERT INTO bmrNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Chahano aivo isitɨ miyamɨnaafaño ofoonoro diitoco ɨmɨhɨninɨjiruno. Jaanotɨ naha ijeebɨɨfañotɨ asaano miyamɨnaaco mɨhɨninɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jinoco amɨɨhai nohojɨma mihicamo muguubu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jaadɨ imiyamɨnaaco ejeevesuuboro jaahe fuubo. Jaaboco ijɨɨbogomɨnaa toonotɨ dilluhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jaanegui diitoco nuubo: ¿Nacu bu tollɨro amɨɨhai, amɨɨhai esɨcɨnɨbama machahahi? ¿Nacu magaajatɨhi? Mɨɨro oono paryɨ isitɨ miyamɨnaafaño ofoono diitoco mɨhɨninɨtɨhi ");
INSERT INTO bmrNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ihesamaajefaño ofootɨmaño. Mɨɨro jillɨ iibafañodɨ ofoonoro miyamɨnaafañotɨ iinonɨcɨhi. Jillɨ neehicaubo, paryɨ machuta mɨhɨnivatɨhi eneejirunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jaanotɨ naha: Miyamɨnaa jeebɨɨfañotɨ ihiinono miyamɨnaaco mɨhɨninɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mɨɨro miyamɨnaa jeebɨɨfañotɨ saanɨcɨno iimitɨnoono esamaajene, ajevaneheje, nanivaneheje, gaicaauneje, ");
INSERT INTO bmrNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sifi taabama, bu sifigo tajema icaneheje, sitanoco imogoneheje, paryɨ imitɨneheje, bañɨfiirano, fanoova imitɨ imoyɨɨcɨneheje, sɨcamaño jɨɨbocasineheje, iino allɨtɨro jɨɨheveneheje, quehe quehe icaneheje, ihesɨcɨnɨbama achahaneheje icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jaano paryɨ jino imitɨ ijeebɨɨfañotɨ asaano miyamɨnaaco mɨhɨninɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jaadɨ toonotɨ Jesu fuuhi Tiro cuumijevɨ. Jahɨ saja iijafaño jɨcafutuubo: Mɨɨhaiñooba uco gaajacɨdino, nooboro. Jaarunaa tahɨ diibo iicaunoco gaajacɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bu tollɨro saafigo gaigo ille emeimɨvovatuugo Jesutɨ guubuuhi. Jaanegui diibojaa ufuugoro diiboguiino memuɨɨvutuugo. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jaago siicuumiogo griegomɨogou, sirofenicia icano jiinɨjemɨnaagou. Jaago Jesujaa asaaugoro diiboco dilluvauhi illefañotɨ ihɨjɨco iinusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jaarunaa Jesu diigoco nuuhi: Jaafahiica iseeme itɨconɨ amachumoro tuvahi imijitɨruno iseeme machutaaco mudumɨtɨɨcɨmoro jɨcumɨco mahacɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jaanegui diigo nuuhi: Jɨɨhɨ, miyaano tollɨ Aivojɨɨbo. Jaarunaaca iseeme suuvɨco guiinotɨ jɨcumɨ machufihi, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jaanegui Jesu diigoco nuuhi: Jɨɨ, miyaanoco neehi. Fuucu, daicɨgaitɨ ihɨjɨ iinucuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jaanegui ufuugo iijavɨ ɨɨfutuudɨ atyɨmeteugo illeque icɨgaiijefaño icagoco diigotɨ ihɨjɨ ihiinucunobuuna. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jaadɨ siino Jesu Tiro cuumijetɨ uhuumiubo Sidon jiinɨjefeenedɨ fatyuuhi, bu Decapoli cuuminofeenedɨ icano. Jaabo asaaubo gaseuhi Galilea muuaijɨnivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jahɨ diibojaa sɨvaumo inohojɨno uguubutɨɨbo llaallabano ihiimaauboco. Jaamoro Jesuco dilluumo ihuseque diibohallɨ ificuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jaanegui Jesu ijeevadɨ diiboco asatyuuboro inohojɨnoco ihusegaiñeri guryiinɨuhi. Jaadɨ ɨjɨɨrebamaaiuboro inejebaco dudɨɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jaaboro niquejeque emeecɨuboro sefano ajaguisɨuboro hebreo iijɨri: Efeta, nuuhi: Faayacafoto, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jaasumiro diiboco inohojɨno faayacafutuuhi, bu inejeba ɨmɨtauno sinafutuuhi icano. Jaaneri imino iimaacuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jaaboro Jesu diitoco faguuhi: Mɨɨhaiñoobaco mɨjɨɨbeguedino, nooboro. Jaarunaaca afaguurunofaño janaanɨcɨvɨro jɨɨbogomoro feehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jaaneri sihidɨ ajabafiituumoro neehicaumo: Paryɨ fanoovaco imino moonɨɨbo, uguubutɨmejeque guubusuubo, ihiimaatɨmejeque iimaasuubo icano, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jaasumi sihidɨ miyamɨnaa siino igaivuuhi. Jaarumo imachutama chahauhi. Jaanegui Jesu ijɨɨbogomɨnaaco ocoovauboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ɨdaasuguehi jito miyamɨnaaco mifucucɨ, safucu ɨdɨɨno jino uuma icacuumo. Jaamaño amachujiruno imachuta chahacuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jaamo machutɨmoco ijaanojaago galluuruva jɨɨhaivɨ ajebari nacatejirumo. Mɨɨro diitotɨ saatoho tehesinotɨ saahinɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jaanegui ijɨɨbogomɨnaa diiboco nuuhi: ¿Mɨllɨ bu mamachusujirahi jino mɨɨhaiñooba iijano achahɨgo mihicamo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jaanegui Jesu diitoco dilluuhi: ¿Nacu mɨnoodɨno amɨɨhai maahuno icahi? nooboro. Jaanegui diito nuuhi: Sahuse juugahusetɨ mihɨcacɨ ɨdɨɨno, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jaanegui tajɨɨbaubo miyamɨnaa baavɨ icasɨɨcamaaiqui. Jaaboro imaahunoco ihusefaño agaayɨcɨuboro Moocaanima tohɨcajehallɨvɨ iimaaubo. Jaadɨ tohɨcajeque iquisicuuboro ijɨɨbogomɨnaaco acɨubo. Jaanoco diito imiyamɨnaama ɨfuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jaabadɨro bu mɨɨdɨno taavatɨ iicaumoco Jesu tollɨro Moocaanima ihiimaauboro diitoco acɨuhi imiyamɨnaama ihɨfequi. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jaanoco famooro amachuumo sihidɨ tuvauhi. Jaadɨ ihatyuuvoco nanɨumo gahafusuuhi sahuse juugahusetɨ miibaicɨ ɨdɨɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jaanoco amachuumo cuatro mildɨmo janaanɨcɨ iicaumo. Jaadɨ jari diitoco Jesu galluuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jaadɨ ijɨɨbogomɨnaama meenegafaño ɨjɨcafutuumoro fuuhi Damanuta jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jaana fariseomɨ asaaumoro Jesuma iimaacasihicauhi. Jaamoro jillɨ ɨfurumo ɨnɨsumo diiboco dilluuhi: Eneecata niquejeo mityaco mɨɨhaico dɨhɨfusu, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jaanegui Jesu ijeebɨɨfañodɨ sefano ajaguisɨuboro nuuhi: ¿Collɨhi jisumio miyamɨnaa niquejeo mityaco dilluhi? Miyanotɨro, amɨɨhaico neehi: Jimiyamɨnaaco niquejeo mitya ɨɨfusurajitɨhi, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","diito ifariseomɨco ejeevesuuboro siino meenegafa ɨjɨcafutuuboro onagoo muuaivɨ ijɨɨbogomɨnaama fatyuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jaamo jabajeeveuhi machutaaco satyuutɨmo. Sahɨcagayɨro imaahuhɨca diitoma imeenegafaño icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jahɨ diitoco Jesu nuuhi: Magaihuɨnɨ icɨgusuno mihica fariseomɨ, Herode icamo juurisutaguiijɨnotɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jaaneri ijɨɨbogomɨnaa sanomɨro noocasihicauhi: Fɨne añɨmɨnaa maahunoco mɨsɨvatɨneguiiha ollɨ noobo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Onoocasinoco Jesu agaajacɨuboro diitoco nuuhi: ¿Collɨhi maahunoma machahanoco monoocasihi? ¿Nacu aivo magaajatɨhi, mehesɨcɨnɨcuutɨhi? Cuhufocani amɨɨhai jeebɨɨno fɨne. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Amɨɨhai aallɨɨnoma mihicarumo mahatyɨmetɨhi, monohojɨvarumo muguubutɨhi. Jaana mehesɨcɨnɨtɨhi sahusedɨno maahunoco cinco mildɨmoma ɨɨfuusumi. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Nacu mɨnoodɨɨbaiva ihatyuuvoco mananɨuhi? nooboro. Jaanegui diito nuuhi: Fahuseecɨ motɨhaitɨ miibaicɨ ɨdɨɨno, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jaadɨ bu nuubo: Jaana sahuse juugahusetɨ miibaicɨco cuatro mildɨmoma ɨɨfuusumi. ¿Nacu mɨnoodɨɨbaivaco mananɨumo magahafusuuhi? nooboro. Jaanegui iimusuumo: Sahuse juugahusetɨ miibaicɨ ɨdɨɨno, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jaanegui diitoco nuubo: Jaanoco jaana mehesɨcɨnɨtɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jaanobuunatɨ Betsaidavɨ ɨɨfutuumo. Jahɨ Jesujaa aatyɨmetɨɨboco sɨvaumo: Diiboco dudɨɨcɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jaanegui Jesu diiboco ihusetɨ agaayɨcɨuboro tuucuumigayɨtɨ buhɨgovɨ satyuuhi. Jaaboro ihaallɨɨcɨco ijɨɨreri amaisuuboro ihuseque ihallɨvɨ ficuuhi. Jaaboro diiboco dilluuhi: ¿Naa, mɨɨvɨgayɨ daatyɨmehi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jaanegui diibo emeecɨuboro nuuhi: Miyamɨnaaco ɨmohonobadɨ jeevamoco atyɨmehi. Jaarumo ɨguehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jaanegui Jesu siino ihuseque ihaallɨɨhallɨvɨ ficuuhi. Jaadɨ siino emeecɨuhɨgo ɨvɨ diiboco ihaallɨɨ imitucuuhi. Foovono paryɨ imino atyɨmecuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jaadɨ Jesu diiboco iijajaa agalluuboro imino faguuhi: Cuumijaa feedino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jaanobuunatɨ Jesu ijɨɨbogomɨnaama fuuhi Cesarea de Filipo cuuminojaago jahɨ jɨɨhaivɨ dilluubo ijɨɨbogomɨnaaco: ¿Nacu uuditɨ, mɨllɨ miyamɨnaa neehicamo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jaanegui nuumo: Jua Nitɨmɨnaafi, saatoho neehicahi. Jaanotɨ saatoho: Elia, neehicahi. Jaanotɨ saatoho: Cajaanɨhacho fɨne sɨɨcɨjeototɨ Moocaani iimaamɨnaafi iicaabo, neehicahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jaanegui diitoco dilluubo: ¿Jaana amɨɨhai, mɨɨjoho uujoho iicanoco meneehicahi? nooboro. Jaanegui diiboco Pedro iimusuhi: Ɨɨjoho Cristo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jaarunaa Jesu diitoco faguuhi: Mɨɨhaiñoobaco mɨjɨɨbeguedino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jaadɨ tɨconɨubo diitoco ɨjɨɨbuguubo. Uujoho Miyamɨnaafibadɨ Ifiivuubo guiraajino ɨdaasuno iicano. Quillahuto iijɨtɨ sacerdotemɨ aivojɨtotɨ, caatɨnɨmɨnaa icamo guiraano uco jɨɨheveji. Jaamoro uco gaicaausujimo. Jaaruubo uujoho mifucucɨ, safucu icanotɨ siino buheeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jillɨ diitoco foovono nuubo. Jaanegui Pedro buhɨgovɨ ijeevadɨ Jesuco asatyuuboro tɨconɨurahi ɨɨbaabo. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jaarunaa Jesu acajebeveuboro ijɨɨbogomɨnaaco emeecɨuboro Pedroco ɨɨbauhi: ¡Uutɨ buhɨgovɨ minifoto ɨɨjoho Satanas idiicaabo! Jillɨ dihesamaaje Moocaani esamaajebadɨ jeevatɨhi. Jillɨ miyamɨnaa esamaajebadɨro jeevahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesu ijɨɨbogomɨnaa, bu miyamɨnaa icamoco ocoovauboro nuuhi: Cajaanɨhacho tadyojɨcutɨ asaanoco idiimogoobo difiico guiinodɨ ficu. Jaaboro ifiico ɨdaasuno omoonɨsujinoco iguitɨɨbo tadyojɨcutɨ disaa. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mɨɨro ifiico agaijɨɨbo ifiico mɨtasuji. Jaanotɨ taajɨguiinodɨ, bu tajɨɨbogo iijɨguiinodɨ icano ifiico imɨtasuubo, ifiico taajasuji. ");
INSERT INTO bmrNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Nacu mɨllɨtɨ imijiruno miyamɨnaafi paryɨ jiinɨje busumijeque gaayɨcɨruubo ijeebɨɨco imɨtasuruva? ");
INSERT INTO bmrNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Nacu mɨnoodɨno fɨne jaadujiruubo ijeebɨɨco itaajasuqui? ");
INSERT INTO bmrNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jaabadɨ cajaanɨhacho uutɨ, tajɨɨbogojɨtɨ icano jisumio miyamɨnaa jino Moocaani jeevesumɨnaafeenevɨ unucufeveebetɨ, bu tollɨro uujoho Miyamɨnaafibadɨ Ifiivuubo nucufeveji johono Guihirubi aivojɨri itoomomɨnaama asaadɨ, nooboro neehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jaadɨ bu neehicaubo: Miyanotɨro, amɨɨhaico neehi: Jineeri jino iicamotɨ saatoho guijevejitɨhi Moocaani aivojɨ imityama asaanoco aatyɨmetɨnohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jaanobuunatɨ sajaguisɨ nijequetɨ Pedro, Jacoobo, Jua iicamomaryo Jesu fuuhi caamovo baɨ nijequevɨ. Jahɨ diito ɨmefeene siibadɨ minifutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Igaachehu arɨcuno minifutuuhi seseene nitɨmɨnaatɨ cajaatyoba aivo tollɨ eseseetesujitɨrubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jaabovɨ Elia, Moise icamɨsi jafeveuhi. Jaamɨsi diiboma iimaahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jaanegui Pedro Jesuco nuuhi: Mojɨɨbogomɨnaafi, Imicani jineeri mihicano. Masɨɨ migaacɨ, saga icano nɨjeganoco mɨnɨjeganɨqui ɨɨdi saga, Moisedi saga, Eliadi saga icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jaaneri diito ijɨɨbogomɨnaa sihidɨ igutuumoro mɨllɨ eneejiruno achahauneguiiha Pedro tollɨ nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jaasumiro aimuufai ihallɨvɨ iniituuno diitoco fabaacuuhi. Jaanaa ihaimuufaifañotɨ guubuvusuuno: Jaanɨ taseemene agaijɨɨbo. Jaabo onoonoco imino muguubunɨcɨ, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jaanegui emeecɨurumo mɨɨhaiñoobaco atyɨmecuutɨhi ɨdɨɨbocoro Jesuco atyɨmeumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jaadɨ tobaɨ nijequetɨ iniituudɨ Jesu diitoco nuuhi: Mɨɨhaiñoobaco mɨjɨɨbeguedino mahatyɨmeneque jari uujoho Miyamɨnaafibadɨ Ifiivuubo iguijeveebe siino ubuheetenehachutahiica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jaanegui mɨɨco jɨɨbuguutɨmo, jillɨ sanomɨro dillucasihicauhi: ¿Jineje fɨne oono guijevefeenetɨ siino ubuheetejino onoono? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jaamoro Jesuco dilluumo: ¿Mɨllɨtɨ jaana caatɨnɨmɨnaa: Elia itɨconɨ saaji, neehicahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jaanegui Jesu nuuhi: Jɨɨhɨ, miyaano Elia itɨconɨ saaji. Jaaboro paryɨ fanoovaaco imibachujiibo. ¿Mɨllɨ nacu Caatɨnɨhaamefaño uujoho Miyamɨnaafibadɨ Ifiivuubeditɨ noono? Mɨɨro ɨdaasuno icajiibo, jɨɨhevecafetejiibo icano noono. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mɨɨro jino amɨɨhaico neehi: Miyaano Elia saahinɨcuuhi. Jaaruuboco iimogobadɨ moonɨumo diibotɨ Caatɨnɨhaamefaño: Jillɨ icajiibo unuucuubadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jaadɨ ɨfutuumo saatoho ijɨɨbogomɨnaa iicauhɨgo. Jaamo atyɨmeuhi sihidɨ miyamɨnaa diito uufequeri iicaunoco, tollɨro bu caatɨnɨmɨnaa icauhi diitoma ejenaaucasimo. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jaanaa Jesuco miyamɨnaa aatyɨmeumoro sihidɨ jabafiituuhi. Jaamoro diibojaa jinoocɨnɨuhi idillutuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jaamoco dilluubo: ¿Jinejeque diitoma mejenaaucasihi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jaanegui diitofeenetɨ saafi iimusuuhi: Jɨɨbogomɨnaafi, dijaa taseemeneque sɨvahi iimitɨno ɨjɨma iicaabo, diiboco iimaasuhicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jillɨ fahiijɨvaro diiboco agaayɨcɨɨboro baavɨ gañɨɨhicahi. Jaaboro diiboco iijɨtɨ jɨvaasecuco iinusuuboro igaiñooco ojɨsusuhicaabo. Jaadɨ diiboco sifañɨsuhicaabo. Jaanegui dijɨɨbogomɨnaaco tajɨɨbacurahi ihɨjɨco diibotɨ buhɨ igañɨɨqui. Jaarumo fiivototɨhi agañɨɨnoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jaanegui Jesu nuuhi: Ɨɨ, jeedɨ fɨne amɨɨhai miyaavogoma machahano miyamɨnaa mihicamo. ¿Mɨhachuta fɨne, amɨɨhaima icaji? ¿Mɨhachuta fɨne, amɨɨhaico jaabɨcɨji? Ene juugavɨ sɨva tosɨcafefico, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jaanegui diibojaa sɨvaumo. Jaarunaa ihɨjɨ Jesuco aatyɨmeuboro tosɨcafefico vɨvɨ vɨvɨ miniiyɨubo. Jaaneri baavɨ cavirinamaaiboro acutuubo iijɨtɨ jɨvaasecunoco gañɨɨboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jaanegui Jesu caanico dilluuhi: ¿Mɨhachuta jillɨ icacuubo? nooboro. Jaanegui caani nuuhi: Seemenetɨro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Fiiva foova ihɨjɨ diiboco cɨɨjɨgaifaño, nɨfaihufaño icano gañɨɨsuhicahi, ɨfuruubo diiboco igaicaauqui. Jaanegui mɨɨhaico dɨdaasugoobo mɨllɨhacho mɨɨhaidi moonɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jaanegui Jesu diiboco nuuhi: Etɨ naha imiyaavogohachiijɨ. Imiyaavogobedi fanoova sihidɨ jeevatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jaanegui diibo gaihivuuhi: ¡Jɨɨhɨ, miyaaveguehi! Uco daamusu janaanɨcɨ miyaaveguequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jaanaa Jesu miyamɨnaa sihidɨ iigaivuunoco aatyɨmeuboro tohimitɨ ɨjɨco ɨbauhi jillɨ nooboro: Idiimaasutɨno ɨjɨ, uguubusutɨno ɨjɨ, ɨco uujoho tajɨɨbahi dihiino diibotɨ. Jaaboro siino diibofaño dɨcafutucuudino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jaanegui ihɨjɨ agaihivuuboro diiboco siino vɨvɨ vɨvɨ miniiyɨuhi. Jaadɨ diibotɨ iinuubo miguijevecubadɨ diiboco omoonɨhinɨuboro. Jaanoco guiraamo saatoho: Guijevecuubo, neehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jaarunaa Jesu ihusetɨ agaayɨcɨuboro diiboco gañiiyɨcɨuhi. Jaaneri diibo julleeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jaadɨ Jesu iijafa ɨjɨcafutuuhɨgo ijɨɨbogomɨnaa ijeevadɨ diiboco dilluuhi: ¿Mɨllɨtɨ jana mɨɨhai magañɨɨtɨhi tohimitɨ ɨjɨco? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jaanegui diitoco nuubo: Toyomo ɨjɨmɨ tɨcovono iinotatɨhi. Jillɨ Moocaanima mihiimaaneriro iinefimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jaadɨ toonotɨ ufuumo Galileafañodɨ fatyuuhi. Jaamoco mɨɨhaiñooba agaajacɨnoco Jesu imuguutɨhi, ");
INSERT INTO bmrNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ijɨɨbogomɨnaaco ɨjɨɨbuguumaño. Jaabo neehicauhi: Uujoho Miyamɨnaafibadɨ Ifiivuubo miyamɨnaa usefaño acɨcafeteji. Jaaboco uco guijenɨjimo. Jaaruuboco uco iguijenɨcuruubo mifucucɨ, safucu icano nijequetɨ siino buheeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jillɨ diitoco ɨjɨɨbugurunoco gaajahicautɨmo, bu idilluqui omoonɨrumo iguihicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jaadɨ Capernau cuumivɨ ɨɨfutuuhɨ jaahe iicacudɨ Jesu ijɨɨbogomɨnaaco dilluuhi: ¿Jinejeque jana jɨɨhaivɨ amɨɨhai ihiimaacasimoro masaahicahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jaarunaa diito iimusutɨhi: ¿Cajaanɨji fɨne aivo mɨɨhaitɨ imiyaabo? noomoro jɨɨhaivɨ ihiimaacasiumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jaanegui Jesu acasɨɨvuuboro fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨno iicaumoco ocoovaaboro nuuhi: Cajaanɨhacho amɨɨhaitɨ imiyaabotɨ iicagoobo, famooguiinovɨ iminifotooboro famoocoro ijeecɨvequi, ");
INSERT INTO bmrNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","nooboro seemeneque ɨɨcɨuboro diitofeenevɨ ficuuhi. Jaaboro tooseeque ihiibɨcɨuboro diitoco nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Cajaanɨhacho tamomoco imiyaavogomaño jiibadɨ seemeneque agaayɨcɨmo uco gaayɨcɨhi. Jaamo bu uco agalluuboco tollɨro gaayɨcɨhi, nuubo ijɨɨbogomɨnaaco. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jaanaa diiboco Jua nuuhi: Mojɨɨbogomɨnaafi, meecɨ, saafiico mɨɨhai mahatyɨmehi dimemeri iimitɨno ɨjɨmɨco buhɨ agavaracuuboco. Jaaruuboco mɨɨhai mɨhɨɨbahi, mɨɨhaima ɨɨgotɨneguiiha, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jaanegui Jesu diitoco nuuhi: Mɨhɨɨbajirahana. Mɨɨro saafi tamomofañodɨ niquejeo mityaco eheetavoobo goovano uuditɨ imitɨno iimaajitɨɨbehiica. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mɨɨro mojaagodɨ iicaabo momɨnaafi iicatɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jaanotɨ cajaatyohacho amɨɨhaico Cristooto mihicaneguiiha nɨfaihuco aacɨmo miyanotɨro toono jaadaco gaayɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jaanotɨ cajaatyohacho jito seeme uco jino imino imiyaavogomotɨ saseeque imitɨfaño agañɨɨsumoco aivo imijiruno guiisibatyɨgabari icodaahetɨ mudujenɨmoro muuaifaño magañɨɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jaanegui dihuse ɨco imitɨfaño agañɨɨsuhachi quitɨcɨɨbo buhɨ gañɨɨ. Mɨɨro imijiruno sahusemaryo diicaabo niquejefaño ofoono. Jaanotɨ imijitɨrumo fahuseecɨma diicaabo cɨɨjɨgaifaño ofoono tahɨ ufucuro icɨɨjɨgai ajabaavejitɨhɨgo, ");
INSERT INTO bmrNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","bu jɨɨjoho icarumo echeemejitɨhɨgo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jaanotɨ bu ditɨhai ɨco imitɨfaño agañɨɨsuhachi quitɨcɨɨbo gañɨɨ. Mɨɨro imijiruno satɨhaimaryo diicaabo niquejefaño ofoono. Jaanotɨ fatɨhaicɨma idiicaabo cɨɨjɨgaifaño gañɨɨcafetejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tahɨgo jɨɨjoho icarumo echeemejitɨhɨgo, icɨɨjɨgai ufucuro ajabaavejitɨhɨgo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jaanotɨ bu dihaallɨɨ ɨco imitɨfaño agañɨɨsuhachi buhudaruubo gañɨɨ. Imijiruno Moocaani aivojɨfaño sahɨɨmaryo diicaabo ofoono. Jaanotɨ faayɨcɨmaryo diicaabo cɨɨjɨgaifaño gañɨɨcafetejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tahɨ jɨɨjoho icarumo echeemejitɨhɨgo, icɨɨjɨgai ufucuro ajabaavejitɨhɨgo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jaabadɨ mɨɨro paryɨ famooro cɨɨjɨgairi ɨmuhunɨcafetejimo. ");
INSERT INTO bmrNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Imiruno ɨmuhu jaaruno iimo afatyucuudɨ, ¿jinejeri dojɨcuvɨro mihimutusujirahi? Jaanegui amɨɨhai imoma mihica. Jaamoro fahɨgova sabadɨro sajeebɨɨ mihicacasi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jaadɨ Jesu Capernautɨ ihiinuudɨ fuubo Judea jiinɨjevɨ Jorda onegueehi iicano jiinɨjevɨ. Jahɨ siino miyamɨnaa diibojaa igaivuuhi. Jaamoco jɨɨbeguehicaubo iicahicaubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jaanaa fariseomɨtɨ saatoho Jesujaa asaaumoro diiboco dilluvauhi ɨɨfurumo diiboco igaayɨcɨqui: ¿Naa fɨne imijiruno aijɨ mogaico ejeevesuno? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jaaneguiiha diitoco nuubo: ¿Mɨllɨ nacu Moise amɨɨhaico tajɨɨbauhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jaanegui nuumo: Mɨɨro Moise tajɨɨbauhi jeevesuhaameque mahacɨmoro amɨɨhai taabaco mejeevesuhica, nooboro, nuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jaanegui Jesu diitoco nuuhi: Mɨɨro amɨɨhaico Moise tollɨ tajɨɨbauhi amɨɨhai cuhufojeebɨɨco aatyɨmeuboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jaanotɨ itɨconɨ Moocaani paryɨ fanoovaco ifiivusuusumi gaifi, gaigo icano fiivusuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jillɨ iicamaño gaifi caanico, seejɨco icano jeevesunɨcɨhi mogaima iminifetequi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jaamɨsi saafiibadɨro icanɨcɨcuuhi. Jaamaño miimɨsiicɨ icacuutɨno saafiirucu. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jillɨ iicamaño Moocaani agataacucuunoco miyamɨnaa mudugaacucuudino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jaadɨ jaahe iicacuudɨ ijɨɨbogomɨnaa siino diiboco toonoditɨ dilluuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jaanegui Jesu diitoco nuuhi: Mogaico ejeevesuuboro sifigoco ɨɨcɨɨbo itɨconɨogohallɨvɨ ajeva imitɨco ɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jaabadɨro bu gaigo aijɨco ejeevesugoro sifiico atajevago tollɨro ajeva imitɨco ɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jaanaa seemeque sɨvaumo Jesujaago diitoco idudɨɨcɨqui. Jaarunaaca ijɨɨbogomɨnaa toseejeque ɨsɨvaumoco ɨɨbahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jaanoco Jesu aatyɨmeuboro sɨfiiratuuhi. Jaaboro diitoco nuubo: Jaafa tajaa seeme saahi fɨne mɨhɨɨbano. Mɨɨro Moocaani aivojɨ diito seemebadɨ iicamono. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Miyanotɨro amɨɨhaico neehi: Jino seemene iicabadɨ Moocaani aivojɨco agaayɨcɨtɨɨbo ufucu feejitɨhi Moocaani aivojɨfaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jaaboro toseejeque ihiibɨcɨɨboro ihallɨvɨ ihuseque ficuhicaubo. Jaaboro diitoco imino nooboro Moocaanima iimaauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jaamañotɨ Jesu fuuhi. Jaanaa saafi miyamɨnaafi itɨcovodɨ ijinafatyuuboro iguiino ememuɨɨvuuboro diiboco dilluuhi: Idiimiibo Jɨɨbogomɨnaafi, ¿jinejeque fɨne, uujoho moonɨjirahi ifinɨjitɨno fiivoma icaqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jaanegui Jesu diiboco nuuhi: ¿Mɨllɨtɨ uco idiimiibo neehi? ¿Mɨɨjoho, nacu, iimiibo? Ɨdɨɨboro saafiiro Moocaani iimiibo. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Nacu gaajahi Moocaani tajɨɨbajɨco? Sifigotɨ taabavadino, guijenɨdino, nanivadino, sitaaditɨ sɨcamañooco dɨɨbeguedino, bañɨsudino, diicaanimɨsico gaijɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jaanegui diibo nuuhi: Jɨɨbogomɨnaafi, seemenetɨro paryɨ toonoco uujoho imino moonɨnɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jaanegui Jesu emeecɨuboro diiboco gaijɨuhi. Jaaboro nuubo: Sanurucu aivo dihɨmega iicano; paryɨ dinehejeque naajete. Jaaboro ɨɨdaasumoco daacɨ. Jaadɨ jari niquejefaño sihidɨ nɨhɨbamɨvaji. Jaaboro tadyojɨcutɨ disaa, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jillɨ diiboco unuuneri sihidɨ ɨdaasuvuuboro, ɨdaasuno fuubo sihidɨ inɨhɨbamɨma iicaubo. Jaabo inɨhɨbamɨco gaijɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jaanegui Jesu ihuufococo emeecɨuboro ijɨɨbogomɨnaaco nuuhi: ¡Aivo sihidɨ jeevano inɨhɨbamɨma iicamo Moocaani aivojɨfaño ofoono! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jaaneri ijɨɨbogomɨnaa sihidɨro jabafiituuhi. Jaarunaa Jesu siino diitoco nuuhi: ¡Taseeme, tɨhɨɨcani Moocaani aivojɨfaño ofoono! ");
INSERT INTO bmrNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mɨɨro sihidɨ jeevajitɨruno camello januutupaajeri afatyono. Jaano janaanɨcɨ aivo sihidɨ jeevano inɨhɨbamɨma iicamo Moocaani aivojɨfaño ofoono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jaaneri imi janaanɨcɨ ajabafiituumoro dillucasihicaumo: ¿Jana cajaatyo fɨne taajajirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jaanegui Jesu diitoco emeecɨuboro nuuhi: Miyamɨnaadi aivo sihidɨ jeevano. Jaanotɨ Moocaanidi sihidɨ jeevatɨno. Mɨɨro diibedi jineje ɨtɨhɨɨnoba chahahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jaanegui Pedro diiboco nuuhi: Mɨɨro mɨɨhai paryɨ mubusumijeque mejeevesuhinɨmoro ɨɨma mɨhɨguehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jaanegui Jesu iimusuuhi: Miyanotɨro amɨɨhaico neehi, cajaatyohacho iijaco, inahabomɨco, inagomɨco, seejɨco, caanico, iseemeque, ijiinɨjeque icano taguiinodɨ, bu tahallɨtɨ taajasujɨɨbogoguiinodɨ icano ejeevesumo gaayɨcɨji jino jiijiinɨjehallɨvɨ ciendɨfova janaanɨcɨ iijanoco, inahabomɨhaico, inagomɨhaico, seejɨco, seemeque, jiinɨjeque icano ɨdaasuno omoonɨnofeenetɨ, bu jaadɨ ufucu asaajino niquejevɨ ifinɨjitɨno fiivoma icajimo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jaanotɨ guiraamo jisumi sihidɨ ejeevamo iicarumo guiinovɨ minifeteji. Jaanotɨ guiraamo jisumi guiinovɨ iicarumo tusumi sihidɨ ejeevamotɨ minifeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jaanaa jɨɨhairi icacuumo Jerusalejaagovɨ ufuumo. Jaanaaca Jesu ijɨɨbogomɨnaaco ɨmegavɨ sɨɨguehicauhi. Jaamo diito sihidɨ jabafiituumo. Jaarunaa saatoho diibo dojɨcutɨ ofoomo igutuumo. Jaanoma iicaubo Jesu siino diitoco fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨno iicaumoco ijeevadɨ ocoovauboro tɨcovauhi ɨjɨɨbuguubo diibo ɨdaasuno iicaujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jillɨ nooboro: Memeecɨ, jino Jerusalejaago mefeehi. Jahɨgo uujoho Miyamɨnaafibadɨ Ifiivuubo sacerdotemɨ aivojɨto usefaño, caatɨnɨmɨnaa usefaño icano acɨcafeteji. Jaamo uco guijevefaño ohoovɨcɨmoro sihɨgootoco acɨjimo. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jaaboco uco diito dejecumoro aamɨjimo, jɨɨrebamaaijimo icano. Jaadɨ uco guijenɨjimo. Jaaruubo uujoho mifucucɨ, safucu icanobuunatɨ guijevefañotɨ siino buheeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jaanaa Zebedeo achimɨsi Jacoobo, Jua icamɨsi Jesujaa asaaumɨsiro diiboco nuuhi: Mojɨɨbogomɨnaafi, mihimeguehi ɨco midillunoco mɨsico adaacɨnoco, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jaanegui Jesu diitɨsico nuuhi: ¿Mɨllɨ amɨɨsico uujoho omoonɨnoco mihimeguehi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jaanegui nuumɨsi: Mihimeguehi mɨsico dihaivojɨfaño acasɨɨacunoco saafiico dinaninaagonovɨ, saafiico dimiyanaagonovɨ icano, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jaanegui Jesu diitɨsico nuuhi: Jillɨ aivo amɨɨsi toono magaajatɨnoco midilluhi. ¿Nacu amɨɨhai uujoho ɨdaasuno iicajihillutɨ mahadujirahi? ¿Bu ɨdaasuno iicajifaihuri uujoho initɨcafotofaihuri minitɨcafetejirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jaanegui: Jɨɨhɨ, nuumɨsi. Jaarunaa Jesu diitɨsico nuuhi: Miyaano fɨne uujoho aaduhilluonotɨ mahaduji, bu uujoho initɨcafetejibadɨ minitɨcafeteji icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jaanotɨ naha oono tañaninaagonovɨ, bu tamiyanaagonovɨ icano macasɨɨvejinoco uujoho acɨjitɨrahi. Jaanotɨ jaatyo ɨdɨɨmeguiiharo iimibachucɨnɨnoco diito gaayɨcɨji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jaanoco saatoho ijɨɨbogomɨnaa uguubumoro Jacoobomɨsijaago sɨfiiratuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jaanegui Jesu diitoco ocoovauboro nuuhi: Amɨɨhairyo magaajacuuhi jiinɨjemɨnaa aivojɨto ijiinɨjeque atajɨɨbafinoco. Jaamofeeneri, bu iicamo imityafimo imityari miyamɨnaaco guiinonɨfihi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jaabadɨ amɨɨhaifaño tollɨ icajitɨno. Jaanotɨ amɨɨhaifañotɨ sihidɨ ejeevaabotɨ iicaqui, jillɨ saatoho jeecɨbomɨnaafitɨ miminifoto. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jaanotɨ bu cajaanɨhacho amɨɨhaifañotɨ imiyaabotɨ iicagoobo paryɨ amɨɨhai jeecɨvomɨnaafitɨ minifeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jaabadɨ mɨɨro uujoho Miyamɨnaafibadɨ Ifiivuubo, uco ijeecɨvequi saautɨhi. Jillɨ uujoho ejeecɨvooboro miyamɨnaahallɨvɨ tafiico aacɨnofeenedɨ guiraamoco taajasuqui saauhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jaanobuunatɨ ɨɨfutuumo Jerico cuumivɨ. Jaacuumitɨ Jesu ijɨɨbogomɨnaa, bu sihidɨ miyamɨnaa icamoma tuucuumitɨ fuunaaca Bartimeo onoobo ajashuno aatyɨmeutɨɨbo Timeo achi jɨɨhaijɨniri gɨcɨnɨuhi nɨhɨbamɨco idilluubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jaanaa Jesu Nazareoobo asaaunoco agaajacɨuboro tɨcovaubo sefano ocoovadiicuubo: ¡Jesu David Iyaachi, uco dɨdaasugo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jaanoma iicamo saatoho diiboco: Illɨɨvequi, noomoro ɨɨbauhi. Jaarunofaño janaanɨcɨvɨro coovadiivehicaubo: ¡David Iyaachi, uco jeedɨ dɨdaasugo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jaanegui Jesu ugucɨɨvuuboro: Diiboco mocoova, nuuhi. Jaanegui diiboco ocoovaumo nuuhi: Imo imo diica. Jaaboro goova gañiivo ɨco coovaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jaanegui ijeebutachehuco aganicaruuboro sefano ujulleeveuboro Jesujaago fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jaaboco Jesu dilluuhi: ¿Mɨllɨ ɨco omoonɨnoco diimeguehi? nooboro. Jaanegui aatyɨmeutɨɨbo diiboco nuuhi: Jɨɨbogomɨnaafi, aatyɨmeneque imeguehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jaanegui Jesu nuuhi: Jii, fuucu taca buheetecuuhi imiyaavogomaño, nooboro. Jaasumiro diibo imino atyɨmecuuhi. Jaaboro Jesu dojɨcutɨ jɨɨhairi fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jaadɨ Jerusale fiitɨno ɨɨfutuumo Betfaje cuumi, bu Betania cuumi icano jɨnivɨ Olivohono iicagajɨ tɨcovovɨ. Jaamañotɨ Jesu ijɨɨbogomɨnaatɨsitɨ miimɨsiicɨco galluuhi: Mofoo, oono motɨcovo iicacuumijaago. Jahɨ mahatyɨmeji burrogayɨ duujecɨnɨɨboco mɨɨhaiñooba diiberihi ɨɨgotɨɨboco. Jaaboco misinaayumɨsiro juu mɨsɨva. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jaanotɨ mɨɨhaiñooba amɨɨsico: ¿Collɨhi misinɨɨhi? onoohachi, monoo: Mohaivojɨɨbo eneeneguiiha. Jaaruuboco goovajino uhuumisuno monoo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jaanegui ufuumɨsi atyɨmeteuhi burrogayɨco guhugajɨnivɨ jahisivɨ jɨɨhaifaño duujecɨnɨɨboco. Jaamɨsiro diiboco sinaayumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jaarunaa saatoho tooneri iicaumo diitɨsico nuuhi: ¿Jinejeque toono momoonɨhi? ¿Collɨhi muburroco misinɨɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jaanegui diitɨsi diitoco Jesu unuubadɨ nuuhi. Jaanoma iicamo satyusuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jaaboco Jesujaa ɨɨfutusuudɨ igaachehunoco diibohallɨvɨ ificuudɨ Jesu ihallɨ casɨɨvuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jaanaaca bu sihidɨ saatoho igaachehuneri jɨɨhaico jeebuhicauhi. Jaanotɨ saatohosa ɨmoho jaaɨnoco iquitɨmoro jɨɨhaifa tafusuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jaanaaca ɨmegavɨ ofoomo, bu dojɨcutɨ asaamo icamo sahaguehicauhi: ¡Hosana! Imicani Mohaivojɨɨbo memeri asaabo. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Imicani aivojɨ asaano; mootadi sɨɨcɨjeobo David aivojɨbadɨ asaano. ¡Tollɨro niquejefa Hosana Moocaanico masahago! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jaabo Jesu tuucuumifaño ufuuboro Moocaani iijafaño jɨcafutuubo. Jaadɨ fanoovaco fahɨgovavɨ emeecɨhicaudɨ fuucuubo paryɨ ijɨɨbogomɨnaama Betaniavɨ mihiijɨcuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jaano seseevedɨ Betaniatɨ ufuuhɨ Jesuco ajeba aivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jaanaa tehesinotɨ atyɨmeubo higueraho sihidɨ aamevahoco. Jaanegui meecɨtuubo: Fɨne inoovatama icano, onoomaño. Jaarunaa chahauno, jillɨ botɨ aamenereu noovautɨho onoovafisumi iicautɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jaanoma iicaubo Jesu toohoco nuuhi: Mɨɨhaiñooba jee dinoovataco ufucuro gueenejitɨhi, nooboro. Jaanoco ijɨɨbogomɨnaa guubuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jaanotɨ ufuumo Jerusalevɨ ɨfutuuhi. Jaadɨ Jesu Moocaani iijafaño ufuuboro toojafaño naajeteque eheetavuumo isivɨ gavaracuubo. Jaabadɨro bu nɨhɨbamɨco uhuumisuhicaumo mesanoco baavɨ gavaracuubo, bu tollɨro nimɨihumɨco anaajehicaumo icaganoco moonɨubo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jaaboro imuguutɨɨbo mɨɨhaiñooba siinoco toojafañodɨ acañɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jaadɨ jillɨ nooboro diitoco jɨɨbeguehicauhi: Mɨɨro Caatɨnɨhaamefaño noono: Taaja Moocaanima iimaajareji paryɨ faacuumivadiro, noonoro. Jaarujaco amɨɨhai nanivamɨnaa iijatɨro miminiiyuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jaanoco sacerdotemɨ aivojɨto, bu caatɨnɨmɨnaa icamo uguubumoro diiboco toonohallɨtɨ igaicaauqui ituma ɨfehicauhi: ¿Naa fɨne, mɨllɨtɨ momoonɨji? noomoro. Jaarumo diiboco iguihicauhi paryɨ miyamɨnaa diibo ɨjɨɨbegueneri ajabafiitehicaunoma iicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jaadɨ mihiijɨcuneguiiha Jesu tuucuumitɨ fuucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jaano seseevedɨ siino fucuro tomañodɨ afatyumo atyɨmeuhi tohigueraho ibacoconomaryo uchuumucunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jaanoco Pedro esafutuuboro Jesuco nuuhi: Meecɨ mojɨɨbogomɨnaafi, mee oono higuerahoco ɨɨjoho afaijahinɨho chuumucuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jaanegui Jesu diitoco nuuhi: Moocaanico mimiyaavogo. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Miyanotɨro amɨɨhaico neehi: Cajaatyohacho jigajɨco: Jinootɨ eedeenenere muuaifaño difoo, onoomoro agalluhachiijɨ tollɨ icajino. Jaamo ijeebɨɨfañodɨ guucɨbatɨmo jino onoobadɨ iicajinoco imiyaavogohachiijɨ onoobadɨ icajino. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jaanegui amɨɨhaico neehi: Paryɨ Moocaanico midillunoco, magaayɨcɨji, noomoro midilluhachiijɨ amɨɨhaidi tollɨ icajino. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jaamo bu Moocaanima mihiimaasumi cajaatyomahacho imitɨno mihicahachiijɨ diitoma mihimibachucasihachiijɨ niquejefaño iicaabo amɨɨhai Caani amɨɨhai imitɨco buusuji. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Jaanotɨ mihimibachucasitɨhachiijɨ amɨɨhai Caani niquejefaño iicaabo amɨɨhai imitɨco buusujitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jaadɨ uumiumo Jerusalevɨ ɨfutuuhi. Jaadɨ Jesu templojafañodɨ ɨgooboro feehicaunaaca sacerdotemɨ aivojɨto, bu caatɨnɨmɨnaa, bu tomaño quillahuto icamo diibojaa asaaumoro ");
INSERT INTO bmrNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","diiboco dilluvauhi: ¿Jineje mitya iijɨri ɨɨjoho jinehejeque jillɨ moonɨhicahi? ¿Mɨɨjoho ɨco tomityaco jillɨ moonɨqui aacɨneri? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jaanegui Jesu diitoco iimusuuhi: Uujoho bu tollɨro amɨɨhaico dilluji. Jaanoco uco mihiimusuhachiijɨ, amɨɨhaico neeji comityari uujoho jino omoonɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nacu Jua nitɨhiijɨ cuucatɨojɨu? ¿Niquejejaagotɨojɨ, nacu miyamɨnaajaagotɨojɨ? mihiimusu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jaanegui sanomɨro noocasihicauhi: Niquejeojɨ munuuruva du mɨɨhaico: ¿Jaanoco bu collɨhi mimiyaavogotɨhi? neejiruubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jaanotɨ bu miyamɨnaajaagotɨojɨ munuuruva, imijitɨruno noomoro, noocasiumo miyamɨnaaco iguiumoro. Mɨɨro paryɨ famooro miyamɨnaa Juaco miyaano Moocaani iimaamɨnaafi iicaunoco agaajauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jaamoro: Magaajatɨhi, nuumo Jesuco. Jaanoma iicaabo bu Jesu diitoco iimusuhi: Jaano jeevari bu uujoho amɨɨhaico jillɨtɨ moonɨhi eneejiruno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jaadɨ Jesu tɨconɨuhi siinovɨ oovɨcɨɨboro ɨjɨɨbuguubo: Saafi miyamɨnaafi baacuco ifaguifaño abasuuboro toonocohallɨdɨ mecunɨuhi, bu ifafaihuco ɨɨcɨjinoco eetavuubo, bu tollɨro tofaguifeenetɨ torrehacɨco eetavuubo tohacɨ nijequetɨ toonoco iteemequi icano. Jaaboro dudɨcamaajemɨnaaco tofaguico utuumusuhinɨuboro sihɨ tehesino fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jaano ibaacu onoovacudɨ iicojɨmɨnaafico galluubo diito tofagui dudɨcamaajemɨnaajaago: Tamañoco dɨɨcɨto, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jaaruuboco diito agaayɨcɨumoro ahaamɨhicaudɨ botɨɨboco dojɨcuvɨro galluumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jaaneguiiha bu sifiico galluubo. Jaaruuboco tollɨro iinigaɨtɨ agafucuhicaumoro diiboco aivonoono eneehicaumoro botɨɨboco galluuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jaaneguiiha bu sifiico galluubo. Jaaruuboco gaicaaumo. Jaaneguiiha bu guiraamo saatohoco galluubo. Jaarumotɨ saatohoco aamɨumo, jaanotɨ saatohoco gaisiraicɨumo icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Jaanobuuna saafiirucu illi aatyuvuuno guiraano agaijɨubo. Jaaboco niinoonoro galluubo achico: Fɨne bocɨguejimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","8","Jaarunaa diito noocasiuhi: Jaanɨ duhu imi toonoco agaayɨcɨjiibo. Masɨɨ miguijenɨqui. Jaadɨji mɨɨhai toono abajatotɨ mihicaji, noomoro diiboco agaayɨcɨumoro guijenɨumo. Jaamoro diiboco toonotɨ buhɨgovɨ gañɨɨumo, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","diitoco Jesu dilluuhi: ¿Fɨne mɨllɨ tofagui abajaabo diitoco moonɨjirahi? Mɨɨro asaaboro diito dudɨcamaajemɨnaaco ifinɨsuuboro ifaguico sidudɨcamaajemɨnaaco acɨjirahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Nacu memeecɨtɨhiica Caatɨnɨhaamefaño jillɨ onoonoco? Guiisiri iijanoco eetavonɨcɨmo imi guiisibaco ɨtɨhɨsumoro gañɨɨhi. Jaarunofaño saafi agaajaabo tobaco dojɨcuvɨro ɨcɨhi toba iminoco agaajamaño. Jaaboro aivo imimaño ficuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jinooco Aivojɨɨbo Moocaani eetavehi. Jaano aivo mɨɨhaidi sihidɨ jeevahi, noono Caatɨnɨhaamefaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jaanoma iicamo Jesuco igaayɨcɨqui moonɨumo diitoco eneejirunoco siinovɨ oovɨcɨɨboro onoonoco agaajacɨumoro. Jaarumo miyamɨnaaco iiguiumoro diiboco ejeevesuumoro fuucuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jaanobuunatɨ Jesujaa galluumo fariseomɨoto, Herodianomɨoto iicamoco ɨɨfurumo diiboco mɨllɨhacho onoonotɨ igaayɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jaamo asaaumoro diiboco nuuhi: Jɨɨbogomɨnaafi, ɨɨjoho miyamɨnaa onoonoco jeecɨvotɨɨbo miyaabo idiicanoco mɨɨhai magaajahi, bu paryɨ miyamɨnaa sabadɨro desɨcɨnɨfinoco magaajahi icano. Jaamaño Moocaani jɨɨhaico miyanotɨro dɨɨbeguehicahi. ¿Naa ɨɨdi imino Cesar ajaadusunoco majaaduno? ¿Nacu majaadujitɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jaarunaa ibañɨfiira jeebɨɨco agaajacɨuboro diitoco nuubo: ¿Collɨhi uco mɨnɨsuhi? Ene sajeetɨ nɨhɨbajetɨ mɨsɨva meecɨqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jaanegui diibojaa sɨvaumo. Jaajeque emeecɨuboro diitoco nuuhi: ¿Nacu mɨɨjoho ɨmene jino, bu jino imomono icano? nooboro. Jaanegui diito: Cesarno, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jaanegui Jesu diitoco nuuhi: Cesarnoco Cesarco mahacɨ. Jaanotɨ Moocaaninoco Moocaanico mahacɨ, nooboro. Jaaneri sihidɨro eetyehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jaanaaca diibojaa saatoho saduceomɨ iguijevecumo siino buheetejitɨhi onoonɨcɨmo asaaumoro diiboco dilluvauhi: ");
INSERT INTO bmrNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Jɨɨbogomɨnaafi, Moise mɨɨhaidi jillɨ caatɨnɨuhi: Saafi nahabo mogai seemevatɨgo cojɨtɨ iguijevehachiijɨ inahabo ifibaijɨgoco ɨɨcɨɨboro inahabobuuna eseemevase caani momofaño icaji, nooboro Moise. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mɨɨro saatohotɨ sano nahabomɨro icauhi sahuse juugahusetɨ miimɨsiicɨ ɨdɨɨmo. Jaamotɨ saafi taabavauhi. Jaaruubo seemevatɨɨboro guijeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jaanegui saafi inahabo ifibaijɨgoco ɨcɨuhi. Jaaruubo tollɨro seemevatɨɨboro guijeveuhi. Jaaneguiiha bu allɨvɨoobo. Jaaruubo bu tollɨro icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jaamo famooro tollɨ diigoma icauhi. Jaarumotɨ saafiiba seemevautɨhi. Jaano nijequetɨ bu tollɨro diigo guijeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jaamo buheetesumi siino ubuheetedɨ, ¿cajaanɨ taabaji? fɨne famooro diigoco ataabavacuumaño, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jaaneguiiha Jesu diitoco iimusuuhi: Jillɨ amɨɨhai mɨtɨhɨɨvehi Caatɨnɨhaamefaño onoonoco, bu Moocaani gaaja iicanoco magaajatɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mɨɨro guijevetɨ siino ubuheetedɨ gaifiimɨ, gaigoomɨ icamo taabavacasicujitɨhi niquejefaño iicamo toomomɨnaabadɨro icacuujimo. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Nacu toono guijevemɨnaa ubuheetejinotɨ Moise aamefaño, onoonoco amɨɨhai memeecɨtɨhiica? ¿Mɨllɨ nacu Moocaani diiboma iimaauhi ɨmoho ɨjɨgaunofeenetɨ? Mɨɨro nuubo: Uujoho Abraham, Isaac, Jacob icamo Aivojɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jaamaño Moocaani guijeve aivojɨɨbo icatɨno. Moocaani ubuheeme Aivojɨɨboro. Jaamaño aivo amɨɨhai jillɨro guiraano mɨtɨhɨɨvehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jaanaaca saafi caatɨnɨmɨnaafi gaseuhi diitoma ihiimaacasinoco uguubuuboro. Jaabo Jesu imino diitoco iimusuunoma iicaubo diiboco dilluubo: ¿Cono aivo tajɨɨbatɨ aivo obocɨno? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jaanegui Jesu diiboco iimusuhi: Imiya tajɨɨba jino; muguubu Israel ɨdɨɨboro saafiiro Mohaivojɨɨbo Moocaani. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jaabo Moocaani Dihaivojɨɨboco gaijɨ paryɨ dijeebɨɨmaryo, paryɨ difiimaryo, paryɨ dihesamaajemaryo, bu paryɨ disefamaryo icano. Jino aivo imiya tajɨɨbajɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jaano allɨvɨono bu aivo tobadɨro jeevahi jino; sitaaco gaijɨ difiico agaijɨbadɨro, onoono. Chahano satajɨɨba aivo jino janaanɨcɨ iicano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jaanoma iicaubo icaatɨnɨmɨnaafi diiboco iimusuhi: Jɨɨhɨ jɨɨbogomɨnaafi, miyaanoco aivono neehi, saafiiro Moocaani iicanoco, chahaabo sifi diibo janaanɨcɨ iicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jaaboco magaijɨno paryɨ mojeebɨɨmaryo, mohesamaajemaryo, mosefamaryo, mofibadɨro sitaaco magaijɨno icano aivo imino. Jaabadɨro asimɨco agaicaaumoro jeecɨvonoco ifajɨcɨcɨvɨ ificuunɨcɨno tollɨ imino. Jaarunaa Moocaanico, bu sitaaco icano magaijɨno imino fanoo janaanɨcɨvɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jaanegui imino iimusuunoco Jesu aatyɨmeuboro diiboco nuuhi: Jɨɨ, tehesitɨhi ɨɨjoho Moocaani aivojɨtɨ, nooboro. Jaanotɨro mɨɨhaiñooba siino diiboma dillamaaicuutɨhi igutumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jaanaa Jesu Moocaani iijafaño ɨjɨɨbogoobo neehicauhi: ¿Mɨllɨ jaamo caatɨnɨmɨnaa Cristoco David iyaachi neehicahi? ");
INSERT INTO bmrNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mɨɨro David icaruubo Moocaani Gaijafeenedɨ ihiimaausumi nuuhi: Mohaivojɨɨbo Moocaani Tahaivojɨɨbo Cristoco nuuhi: Tamiyanaagonovɨ casɨɨvo, dimɨnaaco ditɨhaiguiino uujoho ificuunohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Mɨllɨ jaabo Cristo David iyaachi icajirahi, David bu icaruubo diiboco: Aivojɨɨbo, unuuno icanaaca? nooboro. Jaanoco sihidɨ miyamɨnaa iicaumo imono guubunɨcɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jaabo Jesu diitoco ijɨɨbogoobo neehicauhi: Icɨgusuno mihica caatɨnɨmɨnaatɨ, oono caamovonoono gaachehunoma ɨɨgomoco, goohasinofeenevɨ aivo imino idillunoco iimoyɨɨcɨfimotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bu jaamo sinagogajafa ufuusumi aivo iimiya icaganocoro ujuvicamaaifimotɨ, bu machusumi iimimañejevɨro iicafimotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bu fibaijɨto gaigoomɨ iijanoco udumɨtɨɨcɨmoro ɨfurumo, toonoco utuvuusumo caamovono Moocaanima iimaanɨcɨmo sitaaco ibañɨqui. Jaamaño guiraajino aivo cɨɨjɨgaifaño ijaadaco agaayɨcɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jaanobuunatɨ safoono Jesu Moocaani iijafaño nɨhɨbamɨco ɨjɨcuhicauno ɨmega ɨgɨcɨnɨmañotɨ ɨɨfɨnɨcɨhicauhi miyamɨnaa tobafa nɨhɨbamɨco ɨjɨcumoco. Jaamo saatoho sihidɨ inɨhɨbamɨma iicameheje guiraano jɨcuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jaanaa saafigo ɨdaasuno fibaijɨgo agaseugoro tobafa mijeegayɨɨcɨco jɨɨhacuvauhi mɨɨdɨno ijaada iicajecɨco. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jaanoco Jesu aatyɨmeuboro ijɨɨbogomɨnaaco ocoovauboro nuuhi: Miyanotɨro amɨɨhaico neehi: Ajaamo ɨdaasuno fibaijɨgo paryɨ famoova nɨhɨbamɨco tobafa ɨjɨcumo janaanɨcɨvɨ aivo ficuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mɨɨro paryɨ aacɨmo diitoma ucuujɨvaachutɨnotɨ acɨhi. Jaanotɨ diigo ihɨdaasutɨ paryɨ acɨgo tooneri amachujirunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jaabo Jesu Moocaani iija templo onoojafañotɨ inuuboco saafi ijɨɨbogomɨnaafi nuuhi: Meecɨ mojɨɨbogomɨnaafi, bañɨfiira guiisibano bañɨfiira iijanotyɨgaba, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jaarunaa Jesu diiboco iimusuuhi: Mahatyɨmehi jino iijanotyɨgabajeque. Jaaruno toonovɨ iguiisibano siibahallɨvɨ, siibahallɨvɨ icano atyuuvotɨno paryɨ sahɨ callajaavejino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Jaadɨ fuumo Olivohono iicagajɨjaago tooja Moocaani iija oonegueehivɨ. Jaanaaca Jesu gɨcɨnɨuboco Jacoobo, Jua, Andre icamo toovono dilluuhi: Mihimeguehi mɨɨhaico ɨdɨɨbogonoco cusu ɨɨjoho onoono iicaji. ¿Mɨllɨtɨ magaajacɨji paryɨ toneheje ɨtɨcovanoco? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jaanegui Jesu diitoco nuuhi: Esɨcɨnɨno mihica mɨɨhaiñooba amɨɨhaico bañɨdino. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Guiraajimo tamemeri asaano: Uujoho Cristo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jaabadɨro bu mɨnaano jɨɨbogonotɨ muguubusumi, ɨmucugai ñɨhicunejetɨ muguubusumi icano mihiguetejirahana, tollɨ icajino. Jaaruno toono inijequeevacuujino icatɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mɨɨro siijiinɨjeoto siijiinɨjeotoma moonɨcasiji, sihaivojɨ sihaivojɨma moonɨcasiji. Jaasumi fahɨgovavɨ jiinɨje maryɨbaji, ajebano iicaji icano. Jino ɨdaasu iicajino ɨtɨcovano. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jaasumi amɨɨhai ifiico magaihuɨnɨ amɨɨhaico aivojɨto iigaivomoco acɨjimo. Jaamo amɨɨhai uco mimiyaavogomo tajɨɨbamɨnaa aivojɨteje ɨmefeenevɨ masatyocafeteji. Jaamo uutɨ diitoco mɨjɨɨbeguehi. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mɨɨro jiinɨje ifinɨcuujino ɨmegavɨ taajasujɨɨbogo paryɨ faajiinɨjeriro jɨɨbogocafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jaasumi amɨɨhaico aivojɨtoco ihacɨqui diitojaa asatyusumi: ¿Mɨllɨ fɨne meneeji? noomoro mehesamaaijirahana. Tollɨ iicacuudɨ Moocaani amɨɨhai jeebɨɨfaño ificuunocoro monoo. Amɨɨhairyo mihiimaano icajitɨno jillɨ Moocaani Gaija amɨɨhaifañotɨ iimaaji. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jaasu inahaboro inahaboco igaicaauqui acɨji. Jaabadɨro bu caaniro iseemenequeji iseemere caanijaagovɨ iminifotomoro caanico acɨjimo sita igaicaauqui icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jaasumi faaboho amɨɨhaico jɨɨheveji tamomohallɨtɨ. Jaarunaa tollɨ icarunofa ejenaaubo taajaji. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mɨɨro Moocaani iimaajɨɨbogomɨnaafi caatɨnɨuhi: Johono imitɨno ɨɨdicunoco omoonɨɨboro ifinɨsufinotɨ jaano templojafaño iicamaño iimimañeri iicacuutɨnoco mahatyɨmecuudɨ, aameque mɨhɨɨfɨnɨcɨhicamo magaaja. Jaadɨ Judeao jiinɨjeri mihicamo ifagajɨnojaa magaacɨnɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jaanotɨ bu tusumi saatoho iija niibahucuri mihicahachiijɨ miniitomoro fañovɨ mɨjɨcafetedino siinobaco mɨhɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jaanotɨ bu buhɨ faguifaño mihicamo amɨɨhai gaachehuco mɨhɨcɨqui jaahevɨ muhuumidino. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jaanotɨ, ayɨ, fɨne ɨdaasucani icajimo gaigoomɨ tusumi oovato iicamo, bu imɨfañotɨ aduseejema iicamo icano. ¿Mɨllɨ bu gaajirumo? ");
INSERT INTO bmrNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jaanegui Moocaanico midillu jaamo iimitɨfucuje sɨɨcurasumi gaatɨmo mihicahi. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tusumiji sihidɨ aivo ɨdaasuno mihicaji fucuje icaji jiinɨjeque Moocaani ifiivusuunotɨro aatyɨmeratɨfucuje. Jaarunobuunatɨ siino ufucu atyɨmeracuujitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jaafucujeque Mohaivojɨɨbo ibaaresutɨruva tusumi iicajimotɨ mɨɨhaiñooba taajajitɨrahi. Jaaruubo tufucujeque baaretesujiibo itaadɨmo diibo ɨɨcɨumo toono ɨdaasunotɨ itaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jaanotɨ amɨɨhaico saatoho: Memeecɨ jaanɨ Cristo, memeecɨ jaadi Cristo, onoohachiijɨ: Miyaano meneedino. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jillɨ jihovoto saaji Cristo ifibadɨ iminifotomoro, bu Moocaani iimaajɨɨbogomɨnaabadɨ icamo. Jaamo sihidɨ ejeevanoonoco eetavejimo niqueje mitya iijɨnobadɨ iicanehejeque ɨɨfurumo miyamɨnaaco ibañɨqui, bu Moocaanita iicacuurumoco ijishɨtɨhachiijɨ bañɨjimo. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jaanegui amɨɨhai mityano mihimibaicɨnɨcu amɨɨhaico jino uujoho ɨmegavɨro jɨɨbugucuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Jaasumi toono ɨɨdaasufucujebuunatɨ nɨhɨba jabaaveji, bu fucuo nɨhɨba achɨcɨcujitɨhi, bu meecɨrɨ niquejefañotɨ aifeji, paryɨ niquejefaño iicano mitya maryɨbaji icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jaadɨ jarihiica mahatyɨmeji uujoho Miyamɨnaafibadɨ Ifiivuubo aimuufaifeenedɨ sihidɨ mityama, tahaivojɨma icano asaanoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jaaboro uujoho tatyoomomɨnaaco atajɨɨbamo tañanɨtamoco igaiyɨɨcɨjimo fahɨgovatɨ jiinɨjejɨnibaacɨtɨ, niquejejɨnibaacɨtɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jaanegui oono higuerahotɨro magaaja mɨɨro igacano afaivunusumiro ihaamene ruutunɨcɨhi. Jaanotɨ ficaba ifiitɨcunoco magaajanɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jaabadɨ amɨɨhai magaaja paryɨ fanooro jino uujoho onoono iicanoco mahatyɨmecudɨ mehesɨcɨnɨcu jiinɨje ifinɨjino ifiitɨcunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Miyanotɨro jino amɨɨhaico neehi, paryɨ jineheje icaji miyamɨnaa toonoco aatyɨmejimo guijevetɨmaacaro. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Niqueje, bu jiinɨje icano fatyeji. Jaanotɨ jino uujoho onoono sɨcamañovɨ fatyejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jaaruno tufucu ihoovo iicanoco mɨɨhaiñooba gaajatɨhi. Moocaani toomomɨnaa niquejefa iicarumo, bu uujoho Moocaani Seemene icaruubo gaajatɨhi icano ɨdɨɨboro Moocaani tufucuco gaajahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jaanegui amɨɨhai mihimibaicɨnɨcu toomomoro magaajatɨhi ihoovofucu cusumihacho iicajinoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Saafi tehesino ifeequi iicojɨmɨnaaco idudɨcamaajeque aacɨɨboro iguhugaco ofoonobuuna saafiico utuumusuuboro, diibo iicanɨcɨbadɨ uujoho feejihiica. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jaanegui mihimibaicɨnɨcu magaajatɨhi aivojɨɨbo cusumihacho agasejinoco ijɨcuuvɨbahacho, fucufeenevɨbahacho, catava ojɨɨberibachacho, fucurobahacho. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jaanegui mihimocɨsu amɨɨhaico imimañobatɨ asaaboro mɨcɨgamoco atyɨmevadiibo. ");
INSERT INTO bmrNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jino amɨɨhaico onoonoco famoocoro neehi mihimibaicɨnɨcu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jaanaaca mifucucɨrucu Pascuaco eheetavuujino iicauno, bu ijɨcutaama achahano maahuno jɨɨbaimoco eheetavuujino icano. Jaanaa sacerdotemɨ aivojɨto, caatɨnɨmɨnaa icamo guiinehicauhi mɨllɨhacho ɨɨfurumo sɨcamañooco abañɨmoro toonohallɨtɨ Jesuco igaicaauqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jaarumo neehicauhi: Jɨɨbaimofa momoonɨjitɨhi miyamɨnaa ñaaɨvotɨmo iicaqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jaanaaca Jesu Betaniari foojohoma Simon iicaubo iijafa icauhi. Jaabo imachuqui acasɨɨvuubo icaunaaca saafigo gaigo gaseuhi alabastro eetavotapaajefaño facɨcɨfaihu nardo onoofaihu gatyuucɨ sihidɨ ijaada icanoma. Jaagoro toopaajeque agasucuugoro ifacɨcɨfaihuco Jesu nigaɨhallɨvɨ tucaruugo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jaaneri saatoho tomañeri iicaumo ɨsɨfiiratuumoro noocasiuhi: ¿Collɨhi oono facɨcɨfaihu bañamaaiquifetehi? ");
INSERT INTO bmrNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tofaihuco trescientos denario janaanɨcɨvɨ manaajemere ɨɨdaasufiimoco mahacɨtanoco, noomoro diigojaa sɨfiiratuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jaanegui Jesu diitoco nuuhi: Jaafa icago. ¿Collɨhi macasivusuhi? Imino uudi moonɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ɨdaasufiimo fahiijɨvaro amɨɨhaima icaji. Jaamoco mihimugusumi imino momoonɨ. Jaanotɨ uujoho amɨɨhaima fahiijɨvaro icajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ajaamo ɨdɨɨgoro imino uco moonɨhi tafiico afacɨcɨsugo cɨɨhojɨfaño ɨcɨɨcafetejino ɨmegavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Miyanotɨro amɨɨhaico neehi: Cuucahacho fahɨgova jino taajasujɨɨbogoco faajiinɨjeri ɨjɨɨbogohɨgo tollɨro jino diigo omoonɨno jɨɨbogocafeteji, toonotɨ diigoco ihesafetehicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jaanaaca Juda Iscariote onoobo, ijɨɨbogomɨnaa fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨmoobo fuuhi sacerdotemɨ aivojɨtoco emeecɨtoobo diitoma ihiimaaboro Jesuco diito usefaño ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jaanoco diito uguubuumoro sihidɨ imo imo minifutuuhi. Jaamoro nɨhɨbamɨco diiboco acɨguumo. Jaanoma iicaabo aivo Ijuda Jesuco diito usefaño ihacɨqui moonɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jaanaaca ijuurisutama achahano maahuno jɨɨbaimo tɨcovacuuhi, bu Pascua ovejaco agaicaauhicausumi icano. Jaanegui Jesuco ijɨɨbogomɨnaa dilluuhi: ¿Conoovɨ diimeguehi Pascua machutaaco meheetavonoco. Jaabo machuhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jaanegui ijɨɨbogomɨnaatɨ miimɨsiicɨco agalluuboro nuubo: Cuumifaño mofoo. Jahɨ mahatyɨmeji gaifi ɨcɨñuuri nɨfaihuco asatyooboco. Diiboma mofoo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jaabo ɨjɨcafotojaoboco monoo: Mohaivojɨɨbo jillɨ neehi: ¿Comecufaño tajɨɨbogomɨnaama Pascua machutaaco machuji? noobo, monoo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jaadɨ amɨɨhaico ɨɨfusujiibo guiraamecu caamovohɨ iicamecu imibachucɨnɨcumecuco. Jahɨ Pascua machutaaco meheetavo mɨɨhaidi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jaanegui ijɨɨbogomɨnaatɨsi ufuumɨsi tuucuumivɨ ɨfutuuhi. Jaamɨsi atyɨmeteuhi Jesu unuubadɨ iicanoco. Jaamɨsiro tomañovɨ Ipascua machutaaco eetavucuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jaadɨ jarihiica iijɨcuuvɨ Jesu ijɨɨbogomɨnaama fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨmoma gasevauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jaamo amachumo gɨcɨnɨumaaca Jesu diitoco nuuhi: Miyanotɨro amɨɨhaico neehi: Jino amɨɨhai uuma mamachumootɨ saafi uco acɨji igaicaauqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jaaneri sihidɨ ɨɨdaasuvuumoro diiboco saafiiri dilluhicahicaumo: ¿Uujoho icatɨno, etɨ? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jaanegui Jesu diitoco iimusuuhi: Jino amɨɨhai fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨno mihicamotɨ saafi uuma butajefaño maahuco efeeyacuubo diibeji. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jaaruno jillɨ Caatɨnɨhaamefaño uutɨ onoobadɨ uujoho Miyamɨnaafibadɨ Ifiivuubo feehi. Jaarunofaño ɨdaasucani iicajiibo uco aacɨɨbo. Aivo iimijiruno diibedi fiivuutɨɨbo iicauruva, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jaamo machuumaaca Jesu imaahuco agaayɨcɨuboro Moocaanico graciaco acɨuhi. Jaadɨ iquisicɨuboro diitoco acɨubo: Ɨfaaji, mamachu. Jino tafi, taahucu icanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jaadɨ adutahilluco gaayɨcɨubo. Jaanoco tollɨro graciaco aacɨuboro ɨfuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jaanoco famooro aaduudɨ nuubo: Jino tatyɨɨjoho, jino bohono iimaaco imiyacarunoro ajashutɨnohallɨvɨ agañɨɨcafotono. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Miyanotɨro amɨɨhaico neehi: Siino aducujitɨhi jino vinofaihutɨ jari bofaihutɨ Moocaani aivojɨ iicadɨhivɨ aduji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jaadɨ Moocaani masinoco amasivaumoro fuucuumo Olivohono iicagajɨ onoohɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jaanaa Jesu diitoco nuuhi: Paryɨ amɨɨhai uco mejeevesuji. Mɨɨro Caatɨnɨhaamefaño noono: Itoomomɨnaafico gaicaaujimo. Jaaneri ihovejamɨ fahɨgova gavaranamaaiji, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jaaruubo siino ubuheetenebuunatɨ amɨɨhai ɨmega Galileavɨ feeji, nuubo Jesu. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jaanegui diiboco Pedro nuuhi: Famooro ɨco jeevesurumaaca uujoho ɨco jeevesujitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jaanegui Jesu diiboco nuuhi: Miyanotɨro ɨco neehi: Jaafañiino fucu mifoocɨ catava ojɨtɨɨbaacaro mifoocɨ, safo icano uco agaajaruubo uco tuunamaaiji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jaarunaa jenaauhicaubo: Jaafa ɨɨma iguijevehachiijɨ guijeveji. Jaaruubo ɨco tuunamaaijitɨhi, nooboro. Jaabadɨro bu famooro neehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jaadɨ gaseumo Getsemani onoomañovɨ. Jahɨ Jesu ijɨɨbogomɨnaaco nuuhi: Jinovɨ mɨgɨcɨnɨ uujoho Moocaanima ihiimaatonohachutahica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jaabo Pedro, Jacoobo, Jua icamocoro satyuubo. Jaadɨ tɨcovaubo sihidɨ ɨɨdaasuvuuboro ataafiraruhifico. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","35","Jaaboro diitoco nuubo: Tajeebɨɨ sihidɨ uco ɨdaasuhi miguijevejibadɨ esɨcɨnɨhi. Jinoovɨro mifitafotomoro mihica cɨgatɨmo mubuhee, nooboro Jesu janaanɨcɨvɨ ufuuboro jiinɨjehallɨvɨ ajavuvuuboro Moocaanico dilluubo toono ɨdaasuno iicaujineri ɨdaasuno icatɨɨbo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jaabo Moocaanima iimaabo jillɨ neehicauhi: Guihi, fanoova ɨɨdi sihidɨ jeevatɨhi. Jaanegui jino ɨdaasuno iicajinotɨ uco taajasu. Jaaruno uujoho iimogobadɨ icatɨno, jaafa ɨɨjoho idiimogobadɨ icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jaadɨ ijɨɨbogomɨnaajaa asaaubo cɨgaumoco aatyɨmevauboro Pedroco nuuhi: ¿Simon, nacu cɨgahi? ¿Jillɨ sano nɨhɨba oovo tɨcovovɨ aivo buheetɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Moocaanima mihiimaamoro mubuhee Satanas amɨɨhaico ɨnɨsunofaño jaamo aacototɨmo mihicahi. Miyaano amɨɨhai jeebɨɨ imino iicanoco imogorahi. Jaarunofaño amɨɨhai allɨo ifi niinovahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jaadɨ siino fuubo dojɨcuvɨro Moocaanima iimaatuubo siino tollɨro nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jaadɨ siino asaaubo tollɨro cɨgaumoco atyɨmevauhi, sano cɨgararo ihaallɨɨno iicacuumaño. Jaanoco iimusujirumo esɨcɨnɨhicautɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jaadɨ siino asaauboro diitoco nuubo: Ɨvɨ jisumi mɨcɨgacu, majaguisɨcu. Jino gasecuuno uujoho Miyamɨnaafibadɨ Ifiivuubo imitɨmɨnaa usefaño aacɨcafetejino. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jaaneguiiha magañiivomoro masɨɨgucu, mee oono uco aacɨvaabo fiitɨcuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu iimaaubaacaro Juda gaseuhi diito fahuseecɨ motɨhaitɨ miimɨsiicɨ icamo iicahicaurumoobo iicaabo. Jaaboma sihidɨ saaumo miyamɨnaa niisuganoma, cudaahenema icano. Jaamo sacerdotemɨ aivojɨto, caatɨnɨmɨnaa, quillahuto icamo diitoco agalluumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jaabo diibo acɨmɨnaafi iicaabo Juda diitoco imino jɨɨbuguuhi diito igaajaqui: Oono uujoho diibo iicaaboco ɨnɨnɨɨcɨɨboro dilluji. Jaaboco cuhufono misisɨmoro masatyo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jaadɨ agaseuboro: ¿Naa diicahi, Jɨɨbogomɨnaafi? nooboro Jesuco nɨnɨɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jaasumiro Jesuco gaayɨcɨumo isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jaanegui tomañeri iicaumotɨ saafi iniisugaco iguiiyɨcɨuboro sacerdotemɨ aivojɨɨbo jeecɨvomɨnaafi nɨjɨmeehuco buiyaacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jaanaa Jesu diitoco nuuhi: ¿Mɨllɨ jaamo amɨɨhai tatyɨcovodɨ masaahi niisuganoma, cudaahenema icano nanivamɨnaafico magaayɨcɨqui mihicanɨcɨbadɨ? ");
INSERT INTO bmrNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mɨɨro fafucuvaacɨvɨro amɨɨhaifeenevɨ Moocaani iijafaño icahicahi jɨɨbogooboro. Jaaruuboco du magaayɨcɨhicatɨhi. Jaarunofaño jaafa tollɨ icano johono Caatɨnɨhaamefaño onoono inijequeevaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jaasumiro ijɨɨbogomɨnaa diiboco ejeevesuumoro famooro gaacɨnɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jaanaaca saafi sɨcafefi Jesu dojɨcutɨ fuuhi gaachehubaryuriro minɨcɨnɨɨbo. Jaaboco gaayɨcɨurumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jaarunaaca igaachehuco ejeevesuhinɨuboro sɨcaibo gaaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jaamoro Jesuco satyuumo sacerdotemɨ aivojɨɨbo imiyaabo ɨmegavɨ. Jahɨ paryɨ sacerdotemɨ aivojɨto, quillahuto, caatɨnɨmɨnaa icamo igaicamaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jaanaaca Pedro tehesinotɨ ɨɨfɨnɨcɨuboro ufuubo sacerdotemɨ miya aivojɨɨbo goohasifeeneri casɨɨvuuhi sacerdote toomomɨnaama cɨɨjɨgaitɨ efeemeubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jaanaa sacerdotemɨ aivojɨto, paryɨ fagomɨnaa icamo guiinehicaurahi sɨcamañooco Jesuhallɨvɨ ibañɨqui diiboco toonohallɨtɨ iguijenɨsuqui. Jaarumo atyɨmehicautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Fiivaamo sɨcamañooco diibohallɨvɨ neehicaurumo. Jaarumo sabadɨro neehicautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jaanaaca saatoho agañiivuumoro diibohallɨvɨ sɨcamañooco bañɨuhi: ");
INSERT INTO bmrNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Mɨɨhai muguubuhi jillɨ diibo onoonoco: Uujoho jiija temploja gaifiimɨ usetɨo eetavotajaco acallajanɨɨboro mifucucɨ, safucu ɨdɨɨnotɨro boojatɨ boobanɨji useri eheetavoratɨjaco onoonoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jaarunofaño diito jɨɨbogo sabadɨro iicatɨmaño miyaavehicautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jaanegui isacerdotemɨ aivojɨɨbo famoofeenetɨ agañiivuuboro Jesuco dilluuhi: ¿Ajashuno aivo diimusutɨhi? ¿Jinejeque nacu jino ɨɨtɨ dihallɨvɨ ijɨɨbocasimo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jaarunofa Jesu iimusutɨɨbo. Jillɨ llɨɨvɨ moonɨcɨnɨhicauhi. Jaanegui bu siino isacerdotemɨ aivojɨɨbo dilluuhi: ¿Naa miyaano ɨɨjoho Cristo Moocaani Momiyaabo Achi idiicaabo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jaaneguiiha Jesu diiboco nuuhi: Jɨɨhɨ, uujoho diibo. Eneecau bu jaamo jinootɨ mohɨmegavɨ mahatyɨmeji uujoho Miyamɨnaafibadɨ Ifiivuubo sihidɨ ejeevaabo Moocaani miyanaagueneri gɨcɨnɨɨboco, bu ufucu niqueje aimuufaifeenedɨ asaaboco icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jaanoma iicaabo isacerdotemɨ aivojɨɨbo igaachehuco gallicuuhi sihidɨ ɨsɨfiiratuuboro. Jaaboro nuubo: ¿Collɨhiica bu sita diibohallɨ onoonoco mihimoyɨɨcɨcuujirahi? ");
INSERT INTO bmrNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mee, amɨɨhairyo muguubucuuhi Moocaaniditɨ aivo imitɨno ihiimaanoco; ¿Naa mɨllɨ amɨɨhaidi? nooboro. Jaanegui famooro: Diiboco guijevejiibo, noomoro fañusuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jaasumiro saatoho tɨcovauhi diiboco ɨjɨɨrebamaaimoro ihɨmeque afabaacumoro ganɨɨcɨhicaumo. Eneecata miya ɨɨjoho Moocaani jɨɨbogomɨnaafi idiicahachiijɨ gaajacɨ: ¿Naa mɨɨjoho ɨco ganɨɨcɨhi? noomoro. Jaabadɨro bu toomomɨnaa diiboco aamɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jaanaa Pedro guiino goohasiri icahicaunaa isacerdotemɨ aivojɨɨbo jeecɨvomɨnaago agaseugoro ");
INSERT INTO bmrNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","cɨɨjɨgaijɨniri efeemeebe iicauboco aatyɨmeugoro diiboco gueenene ɨhɨɨfɨnɨcɨhicaugoro nuugo: Ɨɨjoho bu tollɨro Jesu Nazareooboma ɨdɨguehicaabo, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jaarunaa Pedro tuunamaaiuhi: Diiboco uujoho gaajatɨhi, bu ¿jinejetɨhacho fɨne toono uco neehi? nooboro iinehinɨubo jahisitɨ ɨjɨcafetefi uuga ɨmegavɨ. Jaanaacaro catava ojɨcuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jaanobuunatɨ bu siino diigo diiboco emeecɨugoro tomañeri iicaumoco neehicauhi: Jaanɨ diitoobo, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Jaarunaa bu diibo siino tuunamaaiuhi. Jaanobuunatɨro bu tomañeri iicaumo siino Pedroco nuuhi: Miyaano ɨɨjoho diitotɨobo Galileaoobo idiicamaño, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jaanegui Pedro tɨcovauhi ɨɨbacasiiboro ihiimaaubo Moocaani momofañodɨ oovɨcɨɨboro: Gaajatɨhi uujoho diiboco diibotɨ toono mihiimaaboco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jaasumiro catava allɨnɨuhi mifoocɨ ojɨubo. Jaanotɨ jari Pedro Jesu diiboco catava mifoocɨ ojɨtɨɨbaacaro siino mifoocɨ, safo ɨdɨɨno uco tuunamaaiji unuunoco esafutuuboro taacuubo tusumiro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jaanaaca eseseeveudɨ siino sacerdotemɨ aivojɨto, quillahuto, caatɨnɨmɨnaa icamo igaivuuhi paryɨ fagomɨnaama iimaacasiqui. Jaamoro Jesuco sisɨcɨnɨɨboco asatyumoro Pilatoco acɨtuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jaaboco Pilato dilluhi: ¿Naa ɨɨjoho judiomɨ Aivojɨɨbo? nooboro. Jaanegui Jesu diiboco iimusuuhi: Jɨɨhɨ, ɨɨjoho toono onoobadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jaanaa sacerdotemɨ aivojɨto sihidɨ diibohallɨvɨ iimitɨnoono jɨɨbeguehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jaanegui siino Pilato diiboco dilluuhi: ¿Ajashuno aivo diimusutɨhi? Eneecau, meecɨ mɨnoodɨno jino dihallɨvɨ ɨjɨɨbocasinoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jaarunofaño Jesu ajashuno iimusutɨneri Pilato sihidɨro eetyehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jaabo Pilato jɨɨbaimosumi cɨvojamɨnaatɨ saafiico miyamɨnaa idilluuboco sinaayuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jaanaa Barraba onoobo cɨvojafa icauhi sano ihaivojɨtohallɨtɨ saatohoma omoonɨcasiuhɨgo miyamɨnaaco agaicaaunohallɨtɨ ɨcɨvojanɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jaanaa imiyamɨnaa asaaumoro Pilatoco dilluvauhi fafoova jɨɨbaimosumi omoonɨhicaubadɨ imoonɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jaanegui Pilato diitoco iimusuuhi: ¿Naa mihimeguehi judiomɨ Aivojɨɨboco amɨɨhaidi isinaayunoco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jillɨ sacerdotemɨ aivojɨto diiboco ataaquivomoro aacɨunoco Pilato agaajauboro diitoco tollɨ nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jaarunaa isacerdotemɨ aivojɨto miyamɨnaaco fajɨɨnɨuhi: Barrabacoro midillu diibocoro isinaayuqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jaanegui Pilato diitoco siino dilluuhi: ¿Jana mɨllɨ judiomɨ Aivojɨɨbo amɨɨhai meneehicaaboco moonɨji? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jaanegui diito ocoovadiivuumoro Pilatoco iimusuuhi: ¡Guijeve ɨmohobujehallɨvɨ tetecu! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Jaanegui Pilato nuuhi: ¿Nacu jineje iimitɨnoco moonɨɨbo? nooboro. Jaarunaa diito siino janaanɨcɨvɨro coovadiivuuhi: ¡Guijeve ɨmohobujehallɨvɨ tetecu! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jaanoma iicaubo Pilato miyamɨnaama imino iicanoco iimuguuboro Barrabaco sinaayusuubo. Jaaboro Jesuco niivɨgai meeheri ahaamɨsuhicaudɨ ihamocasimɨnaaco acɨubo diiboco itetecuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jaasumiro diiboco ihamocasimɨnaa satyuuhi aivojɨɨbo iijafa poetorio onoonofañovɨ. Jaamoro paryɨ ihamocasimɨnaaco iigaiyɨɨcɨumoro gachicohai deecano tɨfaibadɨ itɨfai iicachehuco jɨɨhacuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jaamoro ijanuutunoma iicanoco aafeneque chaahimɨgatɨ eheetavumoro diiboco javucaruumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jaamoro tɨcovaumo sahagomoro: ¡Imino diica judiomɨ Aivojɨɨbo! ");
INSERT INTO bmrNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","noomoro diiboco ɨmeiri iinigaɨtɨ gafucuhicaumo jɨɨrebamaaimoro iguiino ememuɨɨvomoro diiboco mihimobadɨ dejecujicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jaamoro jillɨ diiboco edejecuhicaunobuunatɨ diiboco ɨjɨɨhacuuchehuco ujujuyaacuumoro jari imiya gaachehuco ɨjɨɨhacuumoro diiboco satyucuumo itetecuqui. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jaanaa Simon Cirene cuumioobo Alejandro, bu Rufo icamɨsi caani buhɨgotɨ isitɨ asaaubo tomañodɨ fatyuuboco ocoovaumoro Jesu guijeve ɨmohobujeque satyusuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jaamoro Jesuco satyuumo Golgota onoomañovɨ, nigaɨpaajebaɨ eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jahɨgo diiboco isuurumo facɨcɨfaihuma vinoco ificuumoro. Jaarunoco Jesu adutɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jaadɨ diiboco etetecucuudɨ ihamocasimɨnaa diibo gaachehunoco sanomɨro itɨcovoocɨvɨ ɨfocasiuhi suerteque abañamaaiumoro: ¿Naa cajaanɨ cochehuco satyeji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jaasu baagotɨrehiica nɨhɨba icauberi diiboco tetecuumo iguijeve ɨmohovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jaamoro toonohallɨtɨ diiboco omoonɨunoco iguijeve ɨmohovɨ inigaɨhallɨtɨ acaatɨnɨumoro ficuumo: JAANƗ JUDIOMƗ AIVOJƗƗBO, onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jaabo uufocovɨ bu tollɨro miimɨsiicɨ nanivamɨnaatɨsico tetecuumo saafiico imiyanaagonovɨ, sifiico inaninaagonovɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jillɨ Caatɨnɨhaamefaño onoocɨnɨno nijequevauhi; iimitɨfimofeenedɨ oovocafutuubo, onoocɨnɨno. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jaanaa tomañodɨ afatyumo Jesuco ɨhɨɨbamoro ihuseneque gavaracumoro ɨɨbajirubadɨ iicano inigaɨnocoro garya, garya omoonɨhicaumoro neehicauhi: Ajaanɨvahaduhu oono templojaco acallajaruuboro siino dojɨcuvɨro mifucucɨ, safucu ɨdɨɨnotɨ boojatɨ edeetavejiruubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Eneecata ɨɨro difiico taajasu, toono diguijeve ɨmohotɨ iniitoobo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Jaabadɨro bu sacerdotemɨ aivojɨto, caatɨnɨmɨnaa icamo edejecumo noocasihicauhi: Sitaaco naha ataajasuhicaabo, ¿cono bu jaabo jisumi ifiicoro taajasunoova. Miyaano ɨɨjoho Cristo Israel Aivojɨɨbo idiicahachiijɨ jisu diguijeve ɨmohotɨ niito, maatyɨmemere ɨco mimiyaaveguequi, noomoro. Jaabadɨro bu diiboma etetecucɨnɨmɨsi diiboco gubuubusuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jaanaa gadɨcɨɨba paryɨ jiinɨje cɨvono iijɨuhi. Jaano jari sano iijɨcuuvɨ ɨmohonohallɨtɨ nɨhɨba icaabovɨ seseeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jaasumi toonotɨ nɨhɨba icauberi Jesu hebreo iijɨri gaihivuuhi: Eloi, Eloi, ¿lama sabactani? nooboro. Moocaani, Moocaani, ¿collɨhi uco deevesuhi? eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jaanoco tomañeri saatoho iicaumo uguubumoro nuuhi: Muguubu, oono Eliaco cuuhuvaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jaanegui diitotɨ saafi ijinafatyuuboro ɨcɨjeuhi faasɨhi iicanoco iimitɨno aivofaihufaño ichimayaacuuboro ɨmei nijequevɨ ificuuboro Jesu iijɨfaño cateejeruuhi. Ene, jaafa Elia saahi diiboco iniitusuvaabo mahatyɨmequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jaarunaa Jesu sefanotyɨgaba agaihivuuboro chuumucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jaasumiro Moocaani iija temploja ofoboocɨnɨu chehu gaachehujetuno feemene iicano gallivuuhi sanoodɨnoocɨro nijequetɨ sano baavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jaanaa ihamocasimɨnaa aivojɨɨbo Jesu ɨmega julleecɨnɨunaa uchuumuunoco aatyɨmeuboro: Miyanotɨro jahi jaanɨ Moocaani Achi, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jaabadɨro bu tomañeri gaigoomɨ iicaumo tehesinotɨro ɨɨfɨnɨcɨhicauhi. Jaamofeeneri icaumo Maria Magdalena onoogo, bu Salome, bu saafigo Maria icamo. Jaago Maria Jose bu iguihoobo Jacoobo icamɨsi seejɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jaamo igaigoomɨ Galileari iicahicausumi Jesuco jeecɨvomoro diibo dojɨcutɨ efeehicaumo. Jaabadɨro bu sihidɨ tomañeri saafigova icauhi Jerusalevɨ diiboma sano ufuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jaanaa mihiijɨcuunaa imibaivofucusumi judiomɨ jaguisɨfucu ɨmegavɨ iicaunegui Jose Arimatea cuumioobo fagomɨnaatɨ imiyaabo iicaubo Moocaani aivojɨco tollɨro eteemehicaubo asaauboro iguitɨɨbo Pilatojaa ufuuboro Jesu ifiico dillutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jaaneri Pilato sihidɨ Jesu uchuumucuneri eetyeuboro amocasimɨnaa aivojɨɨboco coovauhi idilluqui: ¿Naa miya chuumucuubo? onoomaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jaanoco diibo ihaivojɨɨbo ɨjɨɨbuguunegui jari Joseque Jesu ifiico Pilato acɨsuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jaanaa Jose imino gaachehuco anaajeuboro Jesu ifiico iniitusuuboro tochehuri mibocɨuhi. Jaaboro guiisigajɨfaño seedicɨnɨhojɨfaño ɨcɨuboro iguhugaco guiisibatyɨgabari fabaacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jaanoco Maria Magdalena onoogo, bu Maria Jose seejɨ icamɨfe atyɨmeuhi ɨcɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jaano judiomɨ jaguisɨfucu sabado iicafucu afatyuno seseevedɨ Maria Magdalena onoogo, bu Salome, bu Maria Jacoobo seejɨ icamo facɨcɨfaihunoco anaajeumoro fuuhi Jesu ifiico ijeesutequi. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jaamoro fucugayɨro jaguisɨ afatyuno seseevedɨ tohojɨvɨ ɨfutuumo nɨhɨba iinucuuberi. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","¿Mɨɨjoho mɨɨhaima iguiisibaco tohojɨ ɨmegatɨ faayɨcɨji? noocasimoro. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Meecɨrumaaca tobatyɨgaba iicahicaumañeri icacutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jaadɨ tohojɨfa ɨjɨcafutuumo atyɨmeuhi sɨcafefi seseechehu caamovochehufa jɨɨcɨnɨɨbo imiyanaagueneri gɨcɨnɨɨboco. Jaaneri sihidɨ igutuumo. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jaarunaa diitoco nuubo: Mihiguetejirahana, amɨɨhai Jesu Nazareoobo etetecucafetehinɨɨboco miguiinehi. Buheetecuubo chahacuubo jineeri. Eneecau, memeecɨ jino diiboco ificuhinɨmañooco. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jaanegui mofoomoro ijɨɨbogomɨnaa, Pedro iicamoco mɨjɨɨbogoto amɨɨhai ɨmegavɨ Galileavɨ fuucuubo tahɨ diiboco mahatyɨmeji amɨɨhaico unuubadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jaaneri sihidɨ iigutuumoro tohojɨtɨ gaaumo jiterere. Jaamoro ajashuno mɨɨhaiñoobaco jɨɨbuguutɨmo sihidɨ iiguiumaño. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jaanaa fucuro mɨɨhai jaguisɨfucu iicauno seseevedɨ ubuheeteubo tɨconɨuhi Maria Magdalena onoogovɨ ajafeveubo diigotɨ sahuse juugahusetɨ miimɨsiicɨ ɨdɨɨmoco ɨjɨmɨco agavaracuugovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jaago ufuugoro diiboma iicahicaumo ihɨdaasuri taajeheri iicamoco jɨɨbugutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jaano Jesu ubuheeuno diiboco diigo aatyɨmeuno iicanoco guubucuurumo miyaavuguutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jaanobuunatɨ bu siino Jesu siibadɨ jafeveuhi diitotɨ miimɨsiicɨ sihɨ buhɨgo ufuumɨsivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jaanegui uhuumiumɨsiro saatoho ijɨɨbogomɨnaaco jɨɨbugutuumɨsi. Jaarumɨsico tollɨro miyaavuguutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jaanobuunatɨ Jesu siino jafeveuhi ijɨɨbogomɨnaa fahuseecɨ motɨhaitɨ saafi icamo machumovɨ. Jaabo diitoco icuhufojeebɨɨhallɨtɨ buheetecuuboco aatyɨmeumo ɨjɨɨbuguunoco imiyaavuguutɨnohallɨtɨ ɨɨbaubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jaaboro diitoco nuubo: Faajiinɨjeriro mofoo. Jaamoro jino taajasubogoco fanoo miyamɨnaaco mɨjɨɨbogo. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jaanoco imiyaavogooboro initɨsuquimaaibo taajaji. Jaanotɨ imiyaavogotɨɨbo taajajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jaamo uco imiyaavogomoma jino toono gaajatabadɨ iicano icaji; tamemeri buhɨ ɨjɨmɨco gavaracujimo, bojɨɨjeri iimaajimo, ");
INSERT INTO bmrNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ihusenefa jiinimomɨco gaayɨcɨjimo, namitaco aadurumo mɨllɨ icajitɨhi. Jaabadɨro iguihuvamohallɨvɨ ihuseque ificuuneri buheehicajimo icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aivojɨɨbo Jesu jillɨ ijɨɨbogomɨnaama ihiimaahicauno nijequetɨ gañiivuubo niquejefaño. Jaaboro Moocaani miyanaagonovɨ casɨɨvutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jaanegui diito ufuumoro taajasubogoco faajiinɨjeri jɨɨbogomoro fuuhi. Jaamoco diiboro Ihaivojɨɨbo ahaamusuuboro tobogoco miyacaruhicauhi niqueje mitya iijɨ sihidɨ ejeevanoco omoonɨhicaunofeenedɨ.");
INSERT INTO bmrNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Fiivaamo miyamɨnaa caatɨnɨujirahi tanootɨ nijequevɨ, mofeenevɨ iicauno jɨɨbogoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jaanoco imino aatyɨmeumo mɨɨhaico jɨɨbuguuhi tanootɨ nijequevɨ. Jaamo bu tollɨro tobogotɨ ijɨɨbugumoco amusuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jaanoco uujoho imino dilluuhicahi. Jaano uudi iiminegui imino caatɨnɨhi tanootɨ nijequevɨ ɨɨdi agaijɨɨbo Teofilodi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jaabo imino gaajahi, ɨco miyabogotɨ ɨjɨɨbeguehicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jaanaa Herode Judeavɨ aivojɨɨbotɨ icauhi. Jaasumi tollɨro icaubo sacerdote Zacaria onoobo, Abia onoobojaagodɨ iicaubo. Jaabo taaba Elizabe onoogo Aaron iyaachimɨhai cuumimɨnaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jaamɨsi sabadɨro Moocaani ɨmefeenevɨ imihusene icahicaumɨsi. Jaamɨsi imino icahicaumɨsi Moocaani atajɨɨbauboro unuubadɨ. Jaamaño mɨɨhaiñooba diitɨsico mɨllɨ neehicautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jaarumɨsi iseemema chahauhi mogai Elizabe achiba iicaumaño, aivo bu famɨsicɨro amiyatɨsi iicacuumaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Safoono icacuuno Moocaani sacerdotemɨ Zacariamɨoto Moocaanico ejeecɨvefifucu iicauno. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Moocaani jeecɨvomɨnaa jeevamaaje iicanɨcɨbadɨ omoonɨjifucu Zacariavɨ ɨfutucuuhi templojafa ofooboro Aivojɨɨbo Moocaani ɨmefeenevɨ aimoguiijɨco ijɨgasuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jaanoco ɨjɨgasunohachuta paryɨ miyamɨnaa jahisi icauhi Moocaanima ihiimaaumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jaanaa Moocaani toomomɨnaafi Zacariavɨ jafeveuhi fañoojavɨ aimoguiijɨnoco ɨjɨgasufino cojɨvɨ momiyanaagonovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jaaboco Zacaria aatyɨmeuboro guucɨbauhi sihidɨ iigutuuboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jaaboco Moocaani toomomɨnaafi nuuhi: Zacaria, diiguetedino, Moocaani guubucuhi diiboma idiimaahicanoco. Tollɨro diitaaba Elizabe seemeneque ɨcɨji. Jaaseeque Juatɨ momonɨji. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jaaneri sihidɨ imo imo diicaji. Tollɨro bu saatoho sihidɨ imo imo icaji diibo ifiiveneri. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jaabo diseemene Moocaani ɨmefeene sihidɨro jeevajiibo. Jaabo fanoova aivofaihunoco adujitɨɨbo. Jaabofa Moocaani Gaija gahafɨcɨnɨji seejɨ jeebɨɨfaño icaabomaryo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jaabo Israel cuumimɨnaaco sihidɨ uumisujiibo dojɨcuvɨro Ihaivojɨɨbo Moocaanijaagovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jaabo Jua feeji Mohaivojɨɨbo Jesu asaajino ɨmegavɨ. Jaabo icaji Moocaani iimaamɨnaafi Elia imityama icaubadɨ. Jaaneri caanimɨco iseemema sajeebɨɨ ificuqui, bu tollɨro iicajɨɨsufiimoco: Jii, onoonoco igaajasuqui. Jillɨ imibachujiibo miyamɨnaaco Mohaivojɨɨboco igaayɨcɨqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jaanegui Zacaria diiboco dilluuhi: ¿Mɨllɨ jaanoco uujoho imino gaajaji? Uujoho amiyaaburucu, atyaba amiyagurucu icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jaanegui diiboco Moocaani toomomɨnaafi nuuhi: Uujoho Gabriel Moocaani atajɨɨbanoco omoonɨfiibo. Jaabo uco galluuhi ɨco jɨɨbeguequi jino imino jɨɨbogoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jaabo jino ɨco onoonoco miyaavogotɨɨbo idiicamaño dihiimaa ɨco buuji. Jaaneri iimaatɨɨbo diicaji gueenene toosee ifiivotɨnohachuta. Jillɨ nijequeevajino tusumi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jaanohachuta miyamɨnaa iicaahicauhi jahisi Zacariaco otoomomo, esamaaihicauhi toojafañotɨ diibo goovano iinutɨneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jaaruubo tahɨgotɨ ihiinuudɨ iimaacuutɨɨbo. Jaanotɨ gaajacɨumo toojafaño Zacaria gaijaco aatyɨmeunoco. Jaabo ihiimaajirubadɨ iicano ihuseriro jɨɨbeguehicaubo ihiimaacuutɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jaadɨ templojafaño Zacaria Moocaanico ejeecɨvuujifucu afatyunobuunatɨ fuucuubo iijafaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jaanobuunatɨ mogai Elizabe oovago iicacunegui sihɨ iijatɨ fuucuutɨgo sahuse nɨhɨbavahachuta toono esamaajeriro iicacuugo: ");
INSERT INTO bmrNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Jisumi fɨ miyamɨnaa uco achiba nuucutɨhi Aivojɨɨbo Moocaani jillɨ uudi omoonɨmaño, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jaano Zacariama ihiimaaunobuunatɨ sahuse juugahusetɨ sanɨhɨba icano nigacɨtɨ Moocaani siino galluuhi itoomomɨnaafi Gabrielque Galilea jiinɨje cuumi Nazare onoocuumivɨ, ");
INSERT INTO bmrNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","gaifiiquehi agaajatɨgo bagocaja Maria onoogoco imeecɨtequi. Jaago Jose onoobo David iyaachimɨhai cuumimɨnaafico itajevaqui icacuugo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jaagojaagovɨ Moocaani toomomɨnaafi ɨjɨcafutuuboro diigoco nuuhi: ¿Naa diicahi ɨco Moocaani agaijɨgo? Jaabo Aivojɨɨbo Moocaani ɨɨma icahi. Moocaani famoogaigoomɨ allɨnoocɨvɨ ɨco imino moonɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jaaboco Maria aatyɨmeugoro sihidɨ eetyeugo diibo unuuneri. Jaagoro iinoro neehicaugo: ¿Collɨhi fɨne ollɨ uco idilluuboro noobo? noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jaanegui Moocaani toomomɨnaafi diigoco nuuhi: Maria, diiguetejirahana, Moocaani ɨco agaijɨnoco daatyɨmecuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jisumi doovaji. Jaago gaifiico seemevaji. Jaaboco Jesutɨ momonɨji. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jaabo sihidɨ jeevaji. Jaabo caamovohɨ iicaabo Moocaani Achi noocɨnɨji. Jaaboco Moocaani ficuji aivojɨɨbotɨ iheedeebe Davidco iicaubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jaabo israelmɨ cuumico tajɨɨbaji. Jaano ufucuro finɨjitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jaaneguiiha diiboco Maria dilluuhi: ¿Mɨllɨ jaano icajirahi uujehehiicaduhu tajevatɨhi? noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jaanegui Moocaani toomomɨnaafi diigoco iimusuuhi: Moocaani Gaija dihallɨvɨ niiteji. Jaaneri caamovohɨ iicaabo Moocaani mitya ɨco mibaacuji aimuufaibadɨ. Jaamaño ɨɨtɨ seemene ifiivosee ijeevadɨ Moocaanidi ficucafeteji. Jaamaño Moocaani Seemene, diiboco neejimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jaabadɨro bu ditehesino nago Elizabe gaifiico seemevaji amiyago icacuurugo. Jaagoco achiba eneehicarugo sahuse juugahusetɨ sanɨhɨba ɨdɨɨno icacuuhi oovago. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Moocaanidi chahano jineje ɨtɨhɨɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jaanegui Maria nuuhi: Uujoho Mohaivojɨɨbo Moocaani jɨjovogo. Uco onoobadɨ jaafa Moocaani uco moonɨhi, noogoro. Jaanotɨro Moocaani toomomɨnaafi fuucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jaanobuunatɨ Maria fuuhi goovano Judea gajɨhallɨ iicaucuumijaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jaago Maria Zacaria iijafa ɨjɨcafutuugoro Elizabeque dillutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jaanoco Elizabe uguubuusumiro ijeebɨɨfaño iseemene maryɨbauhi. Jaasumiro diigo ififaño Moocaani Gaija gahafuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jaanegui sefano nuugo: Moocaani ɨco guiraano imino moonɨhi, famoova gaigoomɨhallɨnoocɨvɨ tollɨro diseemeneque imino moonɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Mɨllɨ jaago sihidɨ ejeevatɨgoco Tahaivojɨɨbo seejɨ uco baavahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Uco idillunoco uguubusumiro taseemene iimooboro tajeebɨɨfaño maryɨbahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Imicani ɨɨjoho diicahi imiyaavogomaño. Jaamaño Aivojɨɨbo eneehinɨbadɨ ɨɨma icajino, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jaanegui Maria nuuhi: Tajeebɨɨma Moocaanico imehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tollɨro imo imo icahi Moocaani Tatyaajasumɨnaafivɨ, ");
INSERT INTO bmrNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Moocaani uujoho ɨɨdaasugo ijɨjovogoco agaajacuuneri; Jaamaño jisumitɨro paryɨɨcɨno miyamɨnaa fahiijɨvaro iicamo uco: Imino iicago, neeji, ");
INSERT INTO bmrNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Moocaani sihidɨ ejeevaabo uudi sihidɨ jeevanoco omoonɨmaño. Jaabo Moocaani momo iimiibo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jaaboco famooro agaijɨmoco fahiijɨvaro ɨdaasugoobo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Sihidɨ jeevanoco moonɨɨbo. Guiinonɨɨbo ifiicoro: Mityahi, noomoro iicamoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Imityafiirumoco guiinovɨ niitusuubo. Jaaboro ijeebɨɨno sɨɨcuno iicamoco sihidɨ ejeevamotɨ ficuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Machuta achahaneri ajebari iicahicamoco sihidɨ sinehejeri gahafusuubo. Jaanotɨ sihidɨ ɨnɨhɨbamɨvamoco sɨcaihusejema galluubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ijeecɨvomɨnaafi Israel cuumico amusuubo. Jabajeevetɨɨbo diitoco ɨɨdaasugonoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Mootadi Abrahamco iseemema fahiijɨvareji unuucuubadɨ, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jaadɨ Maria gueenene icauhi Elizabema minɨhɨbacɨ, sanɨhɨba icano. Jaanobuunatɨ jari uumiugo iijajaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jaanobuunatɨ icacuuno Elizabe eseemevaujino. Jaago gaifiico seemevauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jaanegui ifiitɨno iicaumo, itehesino nagomɨ icamo fuuhi diigoma imo imo iicaqui Moocaani diigoco agaijɨunoma iicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jaanobuunatɨ fuumo sahuse juugahusetɨ mifucucɨ, safucu icano nigacɨtɨ toosee meehe nigacɨco iquitɨcɨqui. Jaamoro iquitɨcɨnobuunatɨ momonɨujirahi caani Zacaria momoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jaarunaa seejɨ nuuhi: Chahano, jaafa Jua imomo, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jaanegui diigoco nuumo: ¿Collɨhiica? Diyototɨ chahamo saatoho tollɨ imomo iicamo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jaanegui caanico dilluumo uguubutɨneguiihahica ihuseneri caani omomonɨnoco igaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jaanegui caani ɨmohobujeque idilluuboro caatɨnɨuhi: Jua imomo, onoonoco. Jaaneri famooro eetyeuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jaasumiro ɨvɨ Zacariaco jari siino iijɨ jafeveuhi. Jaaneri ihiimaauboro tɨcovaubo Moocaanico iimuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jaaneri paryɨ icojɨneri iicaumo sihidɨ jabafiituuhi. Jaanoco paryɨ Judea jiinɨje gajɨneri jɨɨbocasiumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jaanoco paryɨ uguubuumo esamaaihicauhi. Jaamoro sanomɨro dillucasihicauhi: ¿Mɨllɨ fɨne jusijisee? noomoro Aivojɨɨbo Moocaani miyanotɨro tooseeque imino omoonɨuneri. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Caani Zacaria Moocaani Gaija ififaño gahafɨcɨnɨɨbo iimaauhi Moocaani diibo jeebɨɨfaño ificuunoco nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Jaafa imocɨnɨɨbo israelmɨ Aivojɨɨbo Moocaani. Mɨɨhai diibo cuumimɨnaa mihicamojaa asaaboro mɨɨhaico taajasuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mɨɨhaico acɨɨbo sihidɨ jeevaabo Motaajasumɨnaafico ijeecɨvomɨnaafi David iyaachimɨhaifañotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tollɨ nuubo iimimo ihiimaamɨnaafeenedɨ sɨɨcɨjetɨro: ");
INSERT INTO bmrNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mɨɨhaico momɨnaafañotɨ, ataajasujinoco, bu paryɨ mɨɨhaico ɨjɨɨheguemetɨ icano, ");
INSERT INTO bmrNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tollɨrovaha bu moheedetemɨhaihɨvɨco: Ɨɨdaasugueji, nooboro imino unuunoco ajabajeevetɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jillɨ mootadi Abrahamco miyanotɨro Moocaani nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mɨɨhaico momɨnaatɨ ataajasujinoco, diiboco mejeecɨvequi ñɨhicugotɨmo, ");
INSERT INTO bmrNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","imino ijeevadɨ mofiino diibedi icaqui jiijehallɨvɨ mihicanohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jaanotɨ ɨɨjoho, taseemene, Moocaani caamovohɨgo iicaabo iimaamɨnaafi, noocɨnɨji. Jaamaño feeji Mohaivojɨɨbo ɨmega ijɨɨhaico iimibachuuboro, ");
INSERT INTO bmrNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","iicuumimɨnaa igaajaqui mataajajinoco, mohimitɨco ubuusujinoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jaabo Moocaani igaijɨfañodɨ ɨɨdaasugooboro mɨɨhaico acɨhi Cristoco. Diibo asaajifucuco meteemehi, imitɨfucu niija iicafucu nɨhɨbaco motoomonɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jaabo seseeque sɨvaji cɨvohɨgo iicamedi, guijeve cɨvoguiino iicamedi icano. Tollɨro bu mohɨgoco sɨɨgueji sajeebɨɨ iicano jɨɨhairi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jaanaa iseemene jusihicauhi. Jaabadɨro bu Moocaani iimogobadɨ ijeebɨɨ sefatonoro feehicauhi. Jaanobuunatɨ sɨcaihɨgovɨ icahicaubo. Jaadɨ jari Israel cuumimɨnaavɨ ifiico jafenɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tusumi aivojɨɨbo Augusto onoobo tajɨɨbauhi paryɨ jiinɨje miyamɨnaaco iheevequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jillɨ ohoovonoco tɨconɨumo, itɨconɨ Cirenio onoobo Siria aivojɨɨbotɨ icaunaaca. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jaanegui famooro fuuhi iicuumijejaago tahɨ imomonoco icaatɨnɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jaanegui Jose fuuhi Galilea jiinɨjetɨ Nazare cuumiri iicaumañotɨ Judea jiinɨjevɨ Belen cuumijaagovɨ, tuucuumivɨ David ifiivuuhɨgo, Jose diibo iyaachimɨhai cuumioobo iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jaanegui fuubo Belen cuumijaago imomoco acaatɨnɨsutuumɨsi Mariama, diigoco ataabavaujigo oovago icacuugoma. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jaamɨsi Belen cuumiri icaumaaca Maria iseemevaqui aivucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jaago itɨconɨoseeque seemevauhi. Jaagoro gaachehubaryuneri iimibocɨugoro faijɨ iibañeri ejeebunohallɨvɨ tooseeque sɨucaruuhi miyamɨnaa ɨcɨgafija diitɨsivɨ ɨɨfutucutɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jaanaa Belen cuumitɨ sihɨgovɨ icahicaumo fiitɨjɨɨsuno joomɨ toomomɨnaa fucuhachuta cɨgatɨmo icahicauhi ihovejamɨco otoomomo. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jaamovɨ imimañobatɨ Moocaani toomomɨnaafi jafeveuhi. Jaasumiro Aivojɨɨbo Moocaani imi diitohallɨdɨ arɨcuno achɨcɨuhi. Jaaneri sihidɨ iguiumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jaarunaa Moocaani toomomɨnaafi diitoco nuuhi: Mihiguidino, amɨɨhaidi imibogoco sɨvahi. Jaaneri famooro imo imo icaji. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jaachiijɨ fiivoobo amɨɨhaidi David cuumivɨ Taajasumɨnaafi Aivojɨɨbo Cristo. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jaano gaajabadɨ iicanoco mahatyɨmeji seemeneque gaachehubaryuneri minɨcɨnɨsee faijɨ iibañeri ejeebunohallɨri sɨucɨnɨseeque, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jaasumiro sihidɨ saatoho Moocaani toomomɨnaa niquejeoto diibo cojɨvɨ jafeveuhi. Jaamo Moocaanico iimomo neehicauhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Imicani Moocaani caamovohɨgo iicaaboco mihimo! Jaanotɨ jiinɨjehallɨvɨ gaifiimɨ diibo onoobadɨ imino iicamo sajeebɨɨ iicajino, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jaamoro niquejefaño ufuucuunobuunatɨ ijoomɨ toomomɨnaa sanomɨro noocasiuhi: Masɨɨgo Belenjaago jino iicanoco memeecɨtequi Aivojɨɨbo itoomomɨnaafeenedɨ mɨɨhaico ɨjɨɨbogonoco, ");
INSERT INTO bmrNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","noomoro goovano ufuumo atyɨmeteuhi Jose, Maria, bu seemene faijɨɨhuri ejeebunohallɨvɨ sɨucɨnɨseema icamɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jaanoco aatyɨmeumoro jɨɨbuguumo Moocaani toomomɨnaafi diitoco tooseetɨ ɨjɨɨbuguunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jaanoco paryɨ uguubuumo diito eneeneri eetyehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Jaarunoco llɨɨvɨ Maria ijeebɨɨfañodɨ guubunɨcɨhicauhi toonoco esamaaigoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jaanotɨ ijoomɨ toomomɨnaa dojɨcuvɨro uumicuuhi. Moocaanico agaijɨmoro, imehicauhi uguubuunotɨ aatyɨmeunoma iicamo, diitoco ɨjɨɨbuguubadɨ icauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jaanobuunatɨ sahuse juugahusetɨ mifucucɨ, safucu icanotɨ toosee meehe nigacɨco quitɨcɨsuumɨsi. Jaamɨsiro tooseeque momonɨumɨsi Jesutɨ Moocaani toomomɨnaafi Maria oovautɨgocoro unuumomoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jaanobuunatɨ Moise tajɨɨba onoobadɨ ifiico iimibachufucuva iifinɨudɨ tooseeque satyuumɨsi Jerusale cuumijaago Aivojɨɨbo Moocaanidiro ificuuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jillɨ moonɨumɨsi Moocaani tajɨɨba jillɨ noonoro acaatɨnɨcɨnɨneguiiha: Paryɨ gaifiimɨ itɨconɨ ifiivomo Moocaanidi ijeevadɨ ficucafeteji, eneeneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jaaneguiiha fuumɨsi Moocaani tajɨɨba onoobadɨ, iicanoco jeecɨvo asimɨco ficutuumɨsi: Namuduucumɨsi iicahachiijɨ, nimɨihumɨsi iicahachiijɨ onoobadɨ iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jaasumivɨ icahicaubo Jerusalevɨ Simeon onoobo imihusene miyamɨnaafi. Jaabo Moocaanico ejeecɨvoobo teemehicauhi Israel cuumimɨnaa ataajajinoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jaabo Simeonma Moocaani Gaija icahicauhi. Jaabo diiboco jɨɨbuguuhi: Moocaani agalluubo Cristo ifiivooboco aatyɨmetɨnohachuta iguijevejitɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jaabo templojafaño fuuhi Moocaani Gaija noojɨri. Jaanaa Jesuco caanimɨsi satyuuhi templojafaño tajɨɨba onoobadɨ imoonɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jaaseeque Simeon ihiibɨcɨuboro Moocaanico imuuhi jillɨ nooboro: ");
INSERT INTO bmrNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Aivojɨɨbo, ɨvɨ sajeebɨɨ jaafa chuumucuuhi. Daatyɨmesucuuhi uujoho dijeecɨvomɨnaafico unuunoco: ");
INSERT INTO bmrNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","tahaallɨɨri imino atyɨmecuuhi taajasumɨnaafico ");
INSERT INTO bmrNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","paryɨɨcɨno miyamɨnaa ɨmefeenevɨ ificuuboco. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Diibo seseehachɨcɨ. Jaabo israelmɨ iicatɨrumoco achɨcɨjiibo, iicuumimɨnaa israelmɨco cahacɨsusujiibo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jillɨ tooseetɨ eneeneri caanimɨsi Jose, Maria icamɨsi sihidɨ jabafiitehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jaadɨ Simeon caanimɨsico imino unuuboro, seejɨ Mariaco nuuhi: Meecɨ jiisee seemene icahi diibofeenedɨ Israel cuumimɨnaatɨ sanoodɨmo aaifomo finɨji. Jaanotɨ saatoho taajaji. Jaabo jɨɨbogobadɨ iicaabo. Jaaboco sihidɨ saatoho jɨɨheguejimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jillɨ gaajacafetejino paryɨ famoova ijeebɨɨnofaño esamaaino. Jaanotɨji ɨɨdi paryɨ toono aamɨgari dijeebɨɨco miquitɨcɨbadɨ jeevajino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jaanaa bu tollɨro tomañeri icaugo saafigo gaigo Moocaani onoonoco ihiimaahicaugo Ana onoogo; Famuel onoobo Aser cuumioobo aicɨgai. Jaago aivo amiyagurucuu aivo bobagocaja iicausumi atajevaugo sahuse juugahusetɨ mificabacɨ ɨdɨɨnoro aijɨma icaugo. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jaanotɨ jisumi ochenta y cuatrodɨno ficabava icacuugo fibaijɨgotɨ. Jaago templojafañotɨ iinehicautɨgo cuujehachuta, fucuhachuta icano Moocaanico jeecɨvehicaugo machuco aaigagoro Moocaanima iimaahicaugo. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jaago tahɨ iicaumojaagovɨ gataavugo. Jaagoro Moocaanico itɨconɨ iimuudɨ tɨcovaugo Jesuditɨ ɨjɨɨbuguugo paryɨ famooro Jerusale miyamɨnaa ataajajinoco eteemehicaumoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jaadɨ aivojɨɨbo Moocaani tajɨɨba onoobadɨ omoonɨhicaunoco iimivuuno nigacɨtɨ uumicuumo dojɨcuvɨro Galilea jiinɨjevɨ iicuumi Nazare cuumijaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jaanaa toosee ujusisee quehecutosere feehicauhi janaanɨcɨ gaajaseere. Jaaseeque sihidɨ Moocaani imino moonɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jaanobuunatɨ caanimɨsi fanooficaba tɨcovovɨ Jerusalejaa feehicauhi Pascua jɨɨbaimofiiri. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jaanaa Jesu fahuseecɨ motɨhaitɨ mificabacɨ iicacuudɨ famooro Jerusalejaa fuuhi fahiijɨvaro tojɨɨbaimojaa ofoonɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jaanaa tobaimo ifinɨcuunobuunatɨ uumicuumaaca Jesu Jerusalevɨro fitafutuuhi seejɨmɨsi gaajacɨutɨnaaca. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Fɨne miyamɨnaafeenedɨ saabo, noomɨsiro safucuhachuta saaumɨsi. Jaadɨ guiinuurumɨsi iyotofañodɨ, agaajamehejefañodɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jaaruumɨsi aatyɨmeutɨneguiiha dojɨcuvɨro Jerusalejaa uumiumɨsi, tahɨ diiboco iguiinutuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jaamɨsi mifucucɨ, safucu icano nijequetɨ jari atyɨmeumɨsi templojafaño, Moise tajɨɨba gaajamɨnaafeeneri gɨcɨnɨba icauboco. Jaaboco diitoco uguubunɨcɨɨboro dilluhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bu diito diiboco idillunoco gaajano iimusuhicauneri sihidɨro jabafiitehicauhi, sihidɨ diibo agaajaneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jaaboco caanimɨsi aatyɨmeumɨsiro sihidɨ guucɨbauhi. Jaanegui seejɨ nuuhi: Besha, ¿collɨhi mɨsico jillɨ moonɨhi? Diicaani, uujoho icano gaihuɨnɨmɨsiro ɨco miguiinehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jaanegui Jesu diitɨsico nuuhi: ¿Collɨhi uco miguiinehi? ¿Nacu magaajatɨhi Guihirubi iijafaño iicajinoco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jaarunoco gaajautɨmɨsi diitɨsico diibo unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jaadɨ diitɨsima fuubo Nazare cuumijaago. Jaabo diitɨsima imino icahicauhi. Jaarunoco seejɨ llɨɨvɨ ijeebɨɨfaño ficuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jaanaa Jesu jusiiboro feehicauhi ifiitɨ, ihesamaajetɨ icano. Jaaboco Moocaani, tollɨro bu paryɨ miyamɨnaa icano gaijɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jaanaa Tiberio onoobo fahuseecɨ satɨhai icano ficabava aivojɨɨbotɨ icacuunaaca, Poncio Pilato Judea aivojɨɨbotɨ icauhi. Jaanotɨ Herode onoobo Galilea aivojɨɨbotɨ icauhi. Tollɨro inahabo Felipe Iturea, Traconite onoojiinɨje aivojɨɨbotɨ icauhi. Jaanotɨ Lisania onoobo Abilinia jiinɨje aivojɨɨbotɨ icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jaanotɨ Anas onoobo, Caifas onoobo icamɨsi sacerdotemɨ aivojɨtɨsi aivo imiyamɨsi icauhi. Jaasumi Zacaria achi Juaco Moocaani ijɨɨbogoco acɨuhi sɨcaihɨgovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jaabo Jua fahɨgovadɨ fuuhi Jordan onoohijɨnidɨ miyamɨnaaco: Minitɨsuquimaje. Jaamoro amɨɨhai eedeehifiico mejeevesucu amɨɨhai imitɨco ibuusuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jillɨ icauno Moocaani iimaamɨnaafi Isaia tollɨ nooboro acaatɨnɨuno: Saafi miyamɨnaafi ico guubuvusuhi sɨcaihɨgojaagotɨ: Mihimibachu Aivojɨɨbo jɨɨhaico; tɨcovojɨ meheetavo. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ifagajɨnoco sanotɨcovoro magahafusu. Paryɨ ifabaɨno, ifagajɨno icano sanotɨcovoro moonɨcafeteji. Jɨɨhaiño cɨryu cɨryu iicajɨɨje tɨcuvusucafeteji. Iimitɨjɨje imibachucafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jaanoco paryɨ jiinɨjemɨnaa atyɨmeji taajasuco Moocaani aacɨnoco, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jaabo Jua, miyamɨnaa diibojaa ifiico initɨsuqui asaamoco neehicauhi: ¡Amɨɨhai jiinimomɨbadɨ mihicano miyamɨnaa! ¿Mɨɨjoho amɨɨhaico jɨɨbeguehi ɨñɨhicuno ifiitɨvonotɨ magaaqui? ");
INSERT INTO bmrNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Jaanegui imino mihica, amɨɨhaitɨ, amɨɨhai eedeehifiico mejeevesuno, foovono ihɨfuvusuqui. Jaamoro monoocasidino: Mɨɨhai Abraham iyaachimɨhai, noomoro. Amɨɨhaico neehi: Jiba guiisiba icarubatɨ Moocaani fiivusujirahi Abraham iyaachimɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jɨgaaje imibaicɨnɨcuuhi ɨmohonoco iquitɨqui. Jaamaño iimitɨnoco onoovaho quitɨcafeteji cɨɨjɨgaifaño ijɨgasucafetequi. Jaabadɨro iimitɨmo cɨɨjɨgaifaño jɨgasucafeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jaanegui miyamɨnaa diiboco dilluuhi: ¿Mɨllɨ jana momoonɨjirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jaanegui Jua diitoco iimusuuhi: Gaachehunoma miijaacɨ caamoojama mihicaabo sajaatɨ mahacɨ icaamoojama achahaaboco. Jaabadɨro machutaama mihicamo iinoma achahaaboma mɨhɨfocasi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jaabadɨro Impuesto jaadusumɨnaatɨ saatoho saauhi initɨsuquimaaivaumo. Jaamo Juaco dilluuhi: Jɨɨbogomɨnaafi, ¿mɨllɨ jana mɨɨhai momoonɨji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jaanegui Jua diitoco nuuhi: Tajɨɨbafaño onoonobadɨ majaadusu. Jaanotɨ toono janaanɨcɨ miyamɨnaaco majaadusudino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jaabadɨro saatoho amocasimɨnaa diiboco dilluuhi: ¿Jaanaa mɨɨhai mɨllɨ momoonɨji? noomoro. Jaanegui diitoco iimusuubo: Imitɨno momoonɨmoro, sɨcamañohallɨtɨ saatohohallɨvɨ mihiimaamoro icano. Sitaanoco ajashuno mudumɨtɨɨcɨdino. Jillɨ amɨɨhai dudɨcamaaje jaadamaryo imo imo mihica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jaanaa miyamɨnaa esamaaihicauhi sɨɨcujeebɨɨje teemehicauhi: Fɨne Jua diiburucu Cristo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jaarunaa Jua famoocoro nuuhi: Uujoho miyaano amɨɨhaico nɨfaihuri nitɨhi. Jaanotɨ saajiibo saafi Moocaani Gaijari, cɨɨjɨgairi icano initɨjiibo. Diibo tajanaanɨcɨ sihidɨ mityahi diibobadɨ uujoho jeevatɨhi. Jaamaño conovaha bu diibo tɨhaipaaje duujeque sinaayujirunova. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ihusefaño ibusuba icacuuhi trigo ñaava toogaiño meehunoco ibusuqui ijeevadɨ itoogaiñotɨ. Jaano ifagaañooco ficujiibo iijafaño. Jaanotɨ iimeehunoco ifinɨjitɨno cɨɨjɨgaifaño jɨgasujiibo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jiibadɨ, bu siibadɨje icano fajɨɨnɨɨboro Jua miyamɨnaaco jɨɨbeguehicauhi iimino jɨɨbogoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tollɨro aivojɨɨbo Herode onooboco ɨɨbaubo Herodia onoogo inahabo Felipe taabaco udumɨtɨɨcɨunohallɨtɨ, tollɨro sihidɨ iminootɨno omoonɨhicaunohallɨtɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jaarunoco Herode guubutɨɨbo janaanɨcɨ imitɨno moonɨubo. Juaco cɨvojafaño ficuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jaano ɨmega paryɨ miyamɨnaaco Jua initɨhicausumi, tollɨro bu Jesu nitɨsuquimaaiuhi. Jaabo iteehifañotɨ ihiinuuboro Moocaanima ihiimaaunaaca niqueje faayacafutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jaanofeenedɨ Moocaani Gaija foovono niituuhi diibohallɨvɨ nimɨihubadɨ jeevaabo. Jaanaa guubuvusuuno niquejefañotɨ unuuno: Ɨɨjoho Agaijɨɨbo Taseemene, Ɨɨri sihidɨ imo imo icahi, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jaadɨ Jesu saafi, siino fahuseecɨ icano ficabava iicacuudɨ idudɨcamaajeque tɨconɨubo. Jaabo Jose seemeneu tollɨ esɨcɨnɨhicaurumo. Jaabo Jose Eli seemeneu. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jaabo caani Matat onoobo Levi seemeneu. Jaabo Levi caaniu Melqui. Jaabo caaniu Janai. Jaabo caaniu Jose. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jaabo caaniu Matatias. Jaabo caaniu Amos. Jaabo caaniu Nahum. Jaabo caaniu Esli. Jaabo caaniu Nagai. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Jaabo caaniu Maat. Jaabo caaniu Matatias. Jaabo caaniu Semei. Jaabo caaniu Jose. Jaabo caaniu Juda. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jaabo caaniu Joana. Jaabo caaniu Resa. Jaabo caaniu Zorobabel. Jaabo caaniu Salatiel. Jaabo caaniu Neri. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Jaabo caaniu Melqui. Jaabo caaniu Adi. Jaabo caaniu Cosam. Jaabo caaniu Elmodam. Jaabo caaniu Er. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jaabo caaniu Josue. Jaabo caaniu Eliezer. Jaabo caaniu Jorim. Jaabo caaniu Matat. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Jaabo caaniu Levi. Jaabo caaniu Simeon. Jaabo caaniu Juda. Jaabo caaniu Jose. Jaabo caaniu Jonan. Jaabo caaniu Eliaquim. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Jaabo caaniu Melea. Jaabo caaniu Mainan. Jaabo caaniu Matata. Jaabo caaniu Natan. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jaabo caaniu David. Jaabo caaniu Isai. Jaabo caaniu Obed. Jaabo caaniu Boos. Jaabo caaniu Salmon. Jaabo caaniu Naaso. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Jaabo caaniu Aminadab. Jaabo caaniu Aram. Jaabo caaniu Esrom. Jaabo caaniu Fares. Jaabo caaniu Juda. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jaabo caaniu Jacob. Jaabo caaniu Isaac. Jaabo caaniu Abraham. Jaabo caaniu Tare. Jaabo caaniu Nacor. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Jaabo caaniu Serug. Jaabo caaniu Ragau. Jaabo caaniu Peleg. Jaabo caaniu Heber. Jaabo caaniu Salo. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jaabo caaniu Cainan. Jaabo caaniu Arfaxad. Jaabo caaniu Sem. Jaabo caaniu Noe. Jaabo caaniu Lamec. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Jaabo caaniu Matusale. Jaabo caaniu Enoc. Jaabo caaniu Jared. Jaabo caaniu Mahalaleel. Jaabo caaniu Cainan. ");
INSERT INTO bmrNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Jaabo caaniu Enos. Jaabo caaniu Set. Jaabo caaniu Adan. Jaabo Adan Moocaani seemeneu, diiboco Moocaani eheetavumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jaadɨ Moocaani Gaija Jesu ififaño gahafɨcɨnɨɨbo Jordan onoohifañotɨ uumiuhi. Jaaboco Moocaani Gaija sɨcaihɨgovɨ satyuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jahɨ icaubo sanɨhɨba, siino fahuseecɨ icano fucuva, jinejebaco amachutɨɨboco ɨjɨ nɨsuuhi. Jaadɨ jari diiboco ajeba aivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jaanegui ihɨjɨ diiboco nuuhi: Miyaano Moocaani Achi idiicahachiijɨ jiba guiisibaco dinoo, maahutɨ ifiivetequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jaanegui Jesu diiboco iimusuuhi: Caatɨnɨhaamefaño noono: Miyamɨnaafi sano maahu sefariro icajitɨhi, tollɨro bu Moocaani iijɨ sefari icajiibo, noono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jaadɨ ihɨjɨ diiboco satyuuhi caamovogajɨ nijequevɨ. Jaaboro diiboco ɨɨfusuubo goovanogayɨ paryɨ jiinɨje miyamɨnaa cuuminoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jaaboro diiboco ihɨjɨ nuuhi: Ɨco uujoho acɨji paryɨ jino mityaco. Jaabo tuucuumijeque tajɨɨbahi uujoho gaayɨcɨuhi paryɨ jinoco. Jaanoco uujoho acɨji uujoho iimogomoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jaanegui taaguiino ememuɨɨvooboro uco idiimooboro edeecɨvohachiijɨ paryɨ diinejeji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jaarunaa Jesu diiboco iimusuuhi: Uutɨ buhɨgovɨ diica Satanas, Caatɨnɨhaamefaño jillɨ noono: Aivojɨɨbo Moocaanicoro diimo. Jaaboro saafiicoro diiboco deecɨvo, noono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jaadɨ siino ihɨjɨ diiboco satyuuhi Jerusale cuumijaago. Jaaboro temploja niibahucuvɨ caamo diiboco asatyuuboro nuuhi: Miyaano Moocaani Seemene idiicahachiijɨ juugatɨ daacoto baavɨ, ");
INSERT INTO bmrNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mɨɨro Caatɨnɨhaamefaño noono: Moocaani itoomomɨnaaco tajɨɨbaji ɨco iteemequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ɨco ihusenehallɨvɨ gañiiyɨcɨjimo. Jaabo guiisiba sefavɨ nanigaivatɨɨbo diicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jaanegui Jesu diiboco nuuhi: Tollɨro bu Caatɨnɨhaame neehi: Dihaivojɨɨbo Moocaanico nɨsujirahana, noono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jaarunaa ihɨjɨ diiboco siino ɨnɨsujiruno achahacuunegui diibotɨ buhɨgovɨ minifutuubo gueenenehachuta. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jaadɨ Jesu uumiuhi Galileavɨ Moocaani Gaija mitya ififaño gatyuucɨ icaabo. Jaabotɨ paryɨ toojiinɨjemɨnaa jɨɨbocasihicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jaabo paryɨ tuucuumije sinagogajanofaño jɨɨbogooboro feehicauhi. Jaaboco famooro imehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jaanegui Jesu Nazare cuumijaa fuuhi tuucuumivɨ ifiivuuhɨgo. Jaaboro judiomɨ jaguisɨfucu sinagogajafaño jɨcafutuubo, ijeevamaje iicanɨcɨbadɨ. Jaaboro julleeveubo Caatɨnɨhaameque ihiimaasuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jaaboco Moocaani iimaamɨnaafi Isaia aameque acɨumo. Jaahaameque faayɨcɨubo jillɨ noonoco atyɨmeuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Aivojɨɨbo Gaija tahallɨvɨ icahi. Uco ijeevadɨ ficuuhi iimino jɨɨbogoco ɨɨdaasufiimoco acɨqui. Uco galluubo ijeebɨɨno ɨɨdaasufiimoco buheesuqui, cɨvojafa iicamoco taajasubogoco jɨɨbeguequi, aatyɨmetɨmo aallɨɨnoco faayɨqui, ɨɨdaasuno omoonɨmoco taajasuqui, ");
INSERT INTO bmrNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aivojɨɨbo imino omoonɨjisumico jɨɨbeguequi, onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jaaboro Jesu toohaameque afabaacuuboro sinagogaja amusumɨnaafico aacɨuboro casɨɨvuuhi. Paryɨ toojafaño iicaumo imino diiboco ɨɨfɨnɨcɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jaadɨ tɨconɨubo onoobo: Jifucu icacuuno amɨɨhai ɨmefeenevɨ Caatɨnɨhaamefaño jillɨ onoono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jaanaa paryɨ famooro Jesuditɨ iimino iimaahicauhi. Jaamoro jabafiituuhi ovosɨɨno iimaaco diitoco eneehicauneri. Jaamoro noocasihicauhi: ¿Nacu jaanɨ Jose achi icatɨno? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jaanegui Jesu diitoco nuuhi: Fɨne amɨɨhai uco meneeji onoonɨcɨbadɨ: Taabumɨnaafi idiicaabo tahɨ ɨɨro difiico buheesu, noomoro. Jaamoro uco meneeji: Capernauvɨ omoonɨunoco muguubuubadɨ jino dimiya jiinɨjevɨ moonɨ, meneeji, ");
INSERT INTO bmrNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","nooboro cuhubacafutuubo ihiimaaubo: Miyanotɨro amɨɨhaico neehi, chahaabo aivo Moocaani iimaamɨnaafi ijiinɨjevɨ imino agaayɨcɨcafotoobo. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Miyaano, aivo sihidɨ fibaijɨto gaigoomɨ icaurahi Israel cuumivɨ; Moocaani iimaamɨnaafi Elia onoobo iicausumi aiguutɨno mificabacɨ, saficaba, sificabatɨfeenedɨ icano tɨcovovɨ. Jaaneri toojiinɨjevɨ sihidɨ ajeba icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Jaarumo Israel cuumi fibaijɨtojaa Moocaani Eliaco galluutɨhi, saafigoro Sarepta cuumi Sidon cuumi fiitɨno iicaucuumiri iicaugojaa galluubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jaabadɨro bu sihidɨ icaumo Israel jiinɨjevɨ foojohori iguihuvaumo Moocaani iimaamɨnaafi Eliseo iicausumi. Jaarumotɨ saafiiba buheesurautɨhi ɨdɨɨboro Naaman onoobo Siria jiinɨjeoobo buheesucafutuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jillɨ unuunoco uguubuumoro paryɨ sinagogajafaño iicaumo sihidɨ sɨfiiratuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jaamo agañiivuumoro Jesuco tuucuumitɨ buhɨgovɨ gañɨɨuhi. Jaamoro diiboco satyuumo ifagajɨ nijequevɨ togajɨ nijequetɨ diiboco igañɨɨqui togajɨhallɨvɨ tuucuumi iicaugajɨfaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jaarunaa Jesu diitofeenedɨ afatyuuboro fuucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jaaboro Jesu fuuhi Capernauvɨ Galilea jiinɨje cuumivɨ. Jahɨ jɨɨbeguehicaubo miyamɨnaaco jaguisɨfucusumi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jaaneri eetyehicaumo diitoco mityano aivojɨɨbo iijɨbadɨ icaneri ɨjɨɨbeguehicauneri. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jaanaa sinagogajafaño icaubo saafi iimitɨno ɨjɨma iicaubo. Jaabo gaihivuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Mɨɨhaico suufenɨ. ¿Collɨhi mɨɨhaijaa saahi ɨɨjoho Jesu Nazareoobo? ¿Jaabo saahi mɨɨhaico finɨsuqui? Ɨco uujoho gaajahi. Ɨɨjoho idiimiibo Moocaani, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jaanegui diiboco Jesu ɨɨbauhi: ¡Llɨɨvɨ diica! ¡Jaaboro diiboco deevesu! nooboro. Jaanegui ihɨjɨ imiyamɨnaafico baavɨ gañɨɨuhi diito ɨmefeenevɨ. Jaaruubo diiboco mɨllɨ moonɨtɨɨbo diibotɨ iinuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jaaneri famooro iigutuumoro fahɨgova noocasihicauhi: ¿Coyomo iimaajɨno? Jaanɨ aivo mityano aivojɨɨbo iijɨri tajɨɨbahi ɨjɨmɨco. Jaaneri diito iinehicahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jaanoco Jesuditɨ jɨɨbocasicuumo fahɨgovadɨhallɨdɨ iicaucuumijeri. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jaadɨ Jesu sinagogajafañotɨ ihiinuudɨ fuubo Simon Pedro iijafaño. Jaanaa Simon Pedro baabo sihidɨ guihuvauhi sinafeteri. Jaaneguiiha Jesuma iimaaumo diigohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jaanegui Jesu diigojaagovɨ ɨdɨjɨɨvuuboro iguihuvaco ɨɨbaubo. Jaaneri iguihuva diigotɨ bucuuhi. Jaasumiro agañiivuugoro diitoco jeecɨvehicaugo. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jaanaa mihiijɨcuudɨ fanoova guihuvari iguihuvamoco Jesujaa sɨvahicaumo. Jaamohallɨvɨ ihuseque ificuuneri buheehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jaamo paryɨ iguihuvamotɨ, tollɨro saatohofañotɨ imitɨno ɨjɨmɨ ihiinomoro gaibacɨnɨmoro neehicauhi: Ɨɨjoho Moocaani Achi, noomoro. Jaarumoco Jesu ɨhɨɨbauboro iimaasuhicautɨhi, diibo Cristo iicanoco diito ihɨjɨmɨ agaajahicauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jaanaa meseseevecuudɨ Jesu fuuhi tuucuumitɨ buhɨgovɨ. Jaaruuboco miyamɨnaa iguiinuumo diibovɨ ɨfutuuhi. Jaamoro diiboco gaijɨurumo footɨɨbo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jaarunaa Jesu diitoco nuuhi: Tollɨro bu siicuumijeque acɨji Moocaani aivojɨ jɨɨbogoco, toonegui uco galluubo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jillɨ ɨguehicaubo Jesu Galilea sinagogajanofaño jɨɨbogooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Safoono Jesu icahicauhi Genesare muuaijɨniri. Jaanaa miyamɨnaa sihidɨ gaseuhi. Jaamo diiboco ijene jɨmatajeruhicauhi Moocaani jɨɨbogoco uguubunoco iimugumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jaanaa Jesu atyɨmeuhi migaacɨ meenegaacɨco jiinɨgaibaahojɨniri icanoco. Jaanaa togaje abajato fiicɨmɨnaa ihiinuumoro isinɨcuuhunoco nitɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jaanegui Jesu sagafa jɨcafutuuhi Simon meenega iicaugafaño. Jaaboro tajɨɨbaubo tehesijɨsuno imeenegaco ijɨnitɨ iminiiyuqui. Jaadɨ Jesu ifagafaño acasɨɨvuudɨ tɨconɨubo ɨjɨɨbuguubo tahɨgotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jaabo ihiimaanoco iimivuudɨ Simonco nuubo: Dimeenegaco satyo janaanɨcɨ amachimañovɨ. Jaaboro disinɨcuhunoco gañɨɨ. Jaabo taavaco dɨɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jaanegui Simon nuuhi: Jɨɨbogomɨnaafi, mɨɨhai fucuhachuta dudɨcamaaimoro mihicacuurumo ajashuno mɨhɨcɨtɨhi. Jaarunaa ɨɨjoho eneenegui gañɨɨji tasinɨcuhunoco, nooboro saatohoma ");
INSERT INTO bmrNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","gañɨɨumo. Jaabo sihidɨ taavaco baasuuhi. Jaaneri isinɨcuuhu gallicamaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jaanegui saatoho igataavomɨnaa sigafaño iicaumoco coovaumo diitoco ihamusuvaqui. Jaanegui asaaumoro fagaacɨcoro gahafusuuhi taavari. Jaaneri togaacɨ niituurahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jaanoco Simon Pedro aatyɨmeuboro Jesuguiino memuɨɨvuuhi. Jaaboro diiboco nuuhi: Aivojɨɨbo, uutɨ buhɨ difoo, uujoho imitɨmɨnaafi, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","sihidɨ taavaco ɨɨcɨuneri sihidɨ ajabafiivutuumaño. Bu tollɨro famooro igutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tollɨro bu Zebedeo seeme igutuuhi Jacoobo onoobo, bu Jua icamɨsi Simon gataavomɨnaatɨsi. Jaarunaa Jesu Simonco nuuhi: Diiguetejirahana. Jisumitɨro miyamɨnaa fiicɨmɨnaafitɨ diicaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jaadɨ imeeneneque isi asatyuudɨ fanoocoro ejeevesuumoro fuucuumo Jesu dojɨcutɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jaanaa Jesu tuucuumijeri icaunaaca saafi gaseuhi foojohoma iicaubo. Jaabo Jesuco aatyɨmeuboro memuɨɨvuubo, jiinɨjejaagovɨro dɨjɨɨcɨnɨɨboro diiboco nuuhi: Aivojɨɨbo, idiimogohachiijɨ uco buheesu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jaanegui Jesu ihuseri diiboco ududɨɨcɨuboro nuuhi: Imeguehi. Buheetecu, nooboro. Jillɨ unuusumiro ifoojoho diibotɨ buuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jaaboro Jesu tajɨɨbauhi mɨɨhaiñoobaco jɨɨbogotɨɨbo iicaqui. Jaaboco nuubo: Difoo. Jaaboro sacerdotejaa difiico dɨhɨfusuto. Jaaboro toono ɨco iimibachuno jaadabadɨ iicano asigayɨtɨ satyoobo Moocaanico deecɨvoto Moise atajɨɨbaunobadɨ iicanoco. Jaanoco miyamɨnaa aatyɨmemere igaajaqui ubuheecunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jaanaa Jesutɨ ɨjɨɨbocasiuno janaanɨcɨvɨro feehicauhi. Jaabojaa sihidɨ miyamɨnaa igaivehicauhi diiboco uguubunɨcɨvamoco iguihuvanotɨ ibuheesuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jaarunaa Jesu miyamɨnaa achahahɨ ofooboro Moocaanima iimaahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Safoono Jesu miyamɨnaaco jɨɨbeguehicauhi. Jaanaa diibo fiitɨno gɨcɨnɨumo saatoho fariseomɨoto, caatɨnɨmɨnaa icamo Galilea, Judea, Jerusale icacuumijetɨ asaacɨnɨumo. Jaamofeenevɨ Moocaani mitya ɨfusucafetehicauhi iguihuvamoco ubuheesunofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jaanaa gaseumo saatoho gaifiimɨ idɨɨno isifañɨɨuboco cɨgaiijeri ihiibɨmoro fañoojavɨ ɨjɨɨhacumoro Jesu ɨmefeene ifaduqui moonɨhicaurumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Jaarumo ijɨcafetequi imoonɨcuuruhɨ sihidɨ miyamɨnaama etetecɨnɨunegui caamo ufuumoro iniibahucuco afaayɨcɨumoro iguihuvauboco icɨgaiijema caamotɨ niitusuumo miyamɨnaa uufocodɨ. Jaamoro Jesu ɨmefeenevɨ faduumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jaano diito miyaavogoco Jesu aatyɨmeuboro iguihuvauboco nuubo: Miyamɨnaafi, dihimitɨ ɨco buusucafutucuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jaanoco uguubuumoro fariseomɨ, caatɨnɨmɨnaa icamo tɨcovauhi esamaaiumo: ¿Mɨɨjoho jaanɨ jillɨ onooboro Moocaanico ihiimaari imitɨno omoonɨɨbo? ¿Mɨɨjoho imitɨco buusujitɨrahi? Saafiiro Moocaani imitɨco buusujirahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jillɨ noomoro esamaaiunoco Jesu agaajacɨuboro nuuhi: ¿Collɨhi amɨɨhai tollɨ mehesamaaihi? ");
INSERT INTO bmrNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Fameediro ɨtɨhɨɨrunoco dihimitɨ imibachucafutucuuhi neehi, tollɨro bu gañiivoobo, dɨɨgo onoono. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Jaaneguiiha amɨɨhaico gaajasuji uujoho Miyamɨnaafibadɨ Ifiivuubo jiinɨjehallɨvɨ imitɨ imibachu mityama iicanoco, nooboro. Jaadɨ nuubo idɨɨno isifañɨɨuboco: Ɨco neehi, gañiivo. Jaaboro dicɨgaiijeque dɨɨcɨɨbo, fuucu diijajaago, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jaasumiro idɨɨno isifañɨɨubo gañiivuuhi diito ɨmefeenevɨ. Jaaboro icɨgaiijeque toonohallɨvɨ ɨsɨucɨnɨhicaunoco ɨɨcɨuboro fuucuubo iijajaago Moocaanico imooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jaaneri famooro ajabafiituumoro Moocaanico imehicaumo. Jaamoro sihidɨ iigutuumoro nuumo: Jaachiijɨ mahatyɨmehi aivo ajabafiiranoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jaanobuunatɨ Jesu fuuhi impuesto jaadusumɨnaafi Levi onoobojaago, ajaadusuhicaumañeri gɨcɨnɨba icauboco nuutuubo: Tadyojɨcutɨ disaa, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jaanegui Levi fuuhi Jesuma paryɨ fanoocoro toonovɨ ejeevesuuboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jaanegui toonobuunatɨ Levi Jesudi eetavuuhi iijafaño guiraajɨɨbaimoco. Jaanaa sihidɨ saatoho impuesto jaadusumɨnaa imachuqui gɨcɨnɨnɨcɨnɨuhi diitoma, bu sihidɨ saatoho miyamɨnaa icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jaanoma iicamo fariseomɨ, caatɨnɨmɨnaa icamo Jesu jɨɨbogomɨnaaditɨ imitɨno iimaauhi: ¿Collɨhi amɨɨhai mamachuhi, mahaduhi icano impuesto jaadusumɨnaama, bu saatoho imitɨ miyamɨnaa icamoma? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jaanegui Jesu diitoco iimusuuhi: Imimo iguihuvatɨmo taabumɨnaafico imogotatɨhi. Jaanotɨ iguihuvamoro imoyɨɨcɨfihi taabumɨnaafico. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jaabadɨro uujoho imino icahi onoomoco cuuhuvaqui saahinɨtɨhi. Iimifiitɨmegui saahi iimitɨ ifiico ijeevesuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jaanegui diito Jesuco dilluuhi: ¿Collɨhi jana Jua jɨɨbogomɨnaa, fariseomɨ jɨɨbogomɨnaa icamo machutɨmo aaigamoro sihidɨ Moocaanima iimaahicamo? ¿Jana mɨllɨtɨ dita machuhicahi, aduhicahi icano? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jaanegui Jesu oovɨcɨuboro iimusuuhi: Taabava jɨɨbaimovɨ oovɨcɨhi. ¿Nacu amɨɨhai taabava jɨɨbaimojaa mucuuhuvamoco machusutɨmo mahaigasujirahi tojaabo icanaaca? Tobadɨ tajɨɨbogomɨnaama icahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Jaanotɨ icajinehiica diiteditɨ uco udumɨtɨɨcɨjino. Jaadɨ jari ɨɨdaasuno iicaneri aigajimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jaaboro diitoco bohono Moocaani jɨɨbogoco ijɨɨbeguequi jillɨ ohoovɨcɨuboro nuubo: Mɨɨhaiñooba aivo bochehu gaachehutɨ quitɨcɨtatɨhi eedeechehuco imaahunɨqui. Jaanotɨ tollɨ imoonɨruva bochehu icaruno eedeechehubadɨ icacujiruno. Jaanomaryo bobaryu eedeechehufañotɨ imijitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jaabadɨro bofaihu aivofaihuco asimɨ meehe eetavota eedeejutafaño mificutatɨhi. Jaanotɨ tollɨ momoonɨruva tofaihu tujutaco ejerucaruneri fatyejirahi. Jaaneri tofaihu, tujuta icano gañɨɨcafetejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","anegui bofaihuco bojutafaño mificutahi. Jaano fanoocɨro imino ficucafetefihi. ");
INSERT INTO bmrNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Siino nuubehiica: Eedeefaihuco aivofaihuco aadumo, bofaihuco imogotatɨhi: Eedeefaihu aivofaihu imihi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Safoono Jesu jaguisɨfucusumi basutaanofeenedɨ ɨgooboro feehicauhi. Jaanaa ijɨɨbogomɨnaa trigo noovataco ɨcɨmoro feehicauhi. Jaamoro ifagaañooco ihuseneri iquichecɨmoro ifagaañooco machuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jaanegui saatoho fariseomɨoto diitoco dilluuhi: ¿Collɨhi amɨɨhai mududɨcamaaihi jaguisɨfucusumi momoonɨtatɨnoco? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jaanegui Jesu diitoco iimusuuhi: ¿Jana amɨɨhai magaajatɨhiica aamefa onoonoco, safoono David diiboma iicaumo ajebama icamoma omoonɨunoco? ");
INSERT INTO bmrNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mɨɨro Moocaani iijafaño ufuuboro jeecɨvo maahunoco ɨɨcɨuboro machuubo, jaaboro bu tollɨro acɨubo diiboma iicaumoco icano. Toono Moocaanico ejeecɨvucuuno maahunoco ɨdɨɨmoro sacerdotemɨ machujirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jaadɨ bu tollɨro nuubo: Jaguisɨfucuco mityano mehesɨcɨnɨhi. Miyaano tollɨru. Jaaruno janaanɨcɨ uujoho Miyamɨnaafibadɨ Ifiivuubo mityahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jaadɨ sifoo jaguisɨfucusumi Jesu sinagogajafaño ufuuboro tɨcovauhi miyamɨnaaco ɨjɨɨbogoobo. Jaanaa icaubo saafi miyamɨnaafi imiyanaagohuse ifiigatyuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jaanaa caatɨnɨmɨnaa, fariseomɨ icamo ɨɨfɨnɨcɨhicauhi Jesuco: ¿Naa jaguisɨfucusumi buheesujiibo? noomoro siibadɨ iicanohallɨtɨ diibohallɨvɨ ihiimaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jaamo tollɨ eesamaaiunoco agaajacɨuboro ihuse ifiigatyuuboco nuubo: Gañiivoobo joono diitofeenevɨ dulleeve, nooboro. Jaanegui diibo agañiivuuboro feenevɨ julleeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jaadɨ Jesu diitoco nuuhi: Ene amɨɨhaico dilluji: ¿Jinejeque Moise tajɨɨbauhi jaguisɨfucusumi momoonɨqui iiminoco, nacu iimitɨnoco? ¿Mubuheesunoco, nacu miguijenɨnoco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesu ihuufocori iicaumoco fahɨgovaco emeecɨuboro nuubo ihuse ifiigatyuuboco: Dihuseque fallirihicaru, nooboro. Jaanegui diibo afallirihicaruuneri diibo use imituuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jaaneri saatoho sihidɨ sɨfiiratuuhi. Jaamoro sanomɨro dillucasihicauhi: ¿Mɨllɨ fɨne momoonɨjirahi? noomoro Jesuditɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jaasumi Jesu fuuhi ifabaɨjaago Moocaanima ihiimaaqui. Jaabo icauhi fucuhachuta cɨgatɨɨbo Moocaanima ihiimaaboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jaanaa meseseeveudɨ coovaubo ijɨɨbogomɨnaaco. Jaamotɨ ɨcɨubo fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨmoco. Jaamoco momonɨubo minɨsumɨnaatɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jaamo momono jino Simon icaruuboco Pedrotɨ omomonɨubo, Andre onoobo Simon nahabo, Jacoobo, Jua, Felipe, Bartolome, ");
INSERT INTO bmrNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, bu Jacoobo Alfeo onoobo achi, bu Simon onoobo cananistamɨoobo, ");
INSERT INTO bmrNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacoobo achi Juda, bu sajuda Iscariote onoobo Jesuco aacɨujiibo icamo. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jaamoma Jesu togajɨ nigacɨtɨ iniituuboro nametɨje iicaumaño ijɨɨbogomɨnaama fitafutuumo, tollɨro bu sihidɨ fahɨgovao miyamɨnaa icauhi, Judea jiinɨjeo miyamɨnaa, Jerusale miyamɨnaa, Tiro, Sidon icano muuaijɨnioto icamo. Jinoodɨmo gaseuhi Jesu iijɨco uguubunɨcɨvaumo, bu diitoco iguihuvanotɨ ibuheesuqui icano asaaumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iimitɨno ɨjɨma iicaumo tollɨro buheesucafetehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jillɨ famoova Jesuco idudɨɨcɨqui moonɨhicauhi famoovaaco imityari ubuheesuhicauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jaanoma iicaabo Jesu ijɨɨbogomɨnaaco nuuhi: Imicani amɨɨhai Moocaanico mihimogomo mɨhɨdaasufimaño. Jaamaño amɨɨhai Moocaani aivojɨfaño mihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Imicani amɨɨhai jisumi Moocaanico magaajanoco aivo mihimogomo. Jaanegui ufucu imo imo mihicaji. Imicani amɨɨhai jisumi mataacasimo. Jaarumo ufucu imo imo mihicaneri mejejebacasiji. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Imicani amɨɨhai mihicahi miyamɨnaa amɨɨhaico ɨjɨɨhevesumi, buhɨ amɨɨhaico agañɨɨsumi, amɨɨhaiditɨ imitɨno ihiimaasumi, amɨɨhai momoco iimitɨnobadɨ ɨjɨɨhevesumi uujoho Miyamɨnaafibadɨ Ifiivuubo momoco imiyaavogonohallɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jaasumi mihimibaivomoro imo imo mihicacu guiraano amɨɨhai jaadama niquejefaño mihicajineguiiha. Tollɨro tuucuumijeo eedeetemɨhai Moocaani iimaamɨnaaco ɨdaasuno moonɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jaanotɨ ɨdaasucani amɨɨhai mihicaji sihidɨ mɨnɨhɨbamɨvamo, amɨɨhai imino imo imo jisumiro mihicacuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ɨdaasucani amɨɨhai jisumi mutuvacɨnɨmo, ufucu sihidɨ mahajebavajimo. Ɨdaasucani amɨɨhai jisumi mejejebacasimo, ufucu ɨdaasuri mataacasijimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ɨdaasucani amɨɨhaiji, amɨɨhaitɨ famooro miyamɨnaa iminoono ihiimaasumi. Bu tollɨro diito eedeetemɨhai imitɨ jɨɨbogomɨnaaditɨ: Imimo, noomoro iimaahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jaanotɨ amɨɨhai uco muguubunɨcɨmoco neehi: Amɨɨhai mɨnaaco magaijɨ. Imino momoonɨ amɨɨhaico ɨjɨɨheguemeque. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Imino monoo amɨɨhaico imitɨno onoomoco. Moocaanima mihiimaa amɨɨhaico imitɨno onoomohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jaanotɨ saatoho amɨɨhaico, amɨɨhai ɨme saanaago ɨmetɨ agabavacuhachiijɨ tollɨro saanaago ɨmeque mahacɨ tollɨro bu igabacuqui. Jaanotɨ saatoho amɨɨhai caamoojaco udumɨtɨɨcɨhachiijɨ, bu tollɨro amɨɨhai sacoco mahacɨ isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Jillɨ daacɨ cajaatyohacho ɨco siinoco idillumoco. Jaanotɨ bu sita diinoco ɨɨcɨcuunoco dihiimaasucuudino. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Amɨɨhaico sita imino omoonɨnoco mihimogobadɨ, sitaaco imino momoonɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Jaanotɨ amɨɨhaico agaijɨmocoro bu magaijɨhachiijɨ, ¿coyomo imi fɨne toono? Jillɨ famoova tollɨ moonɨfiihi, iimifiitɨmo bu tollɨro moonɨfiihi icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jaanotɨ bu amɨɨhaico imino omoonɨmocoro, imino momoonɨhachiijɨ, ¿coyomo imi fɨne toono? Tollɨro bu iimifiitɨmo tollɨ moonɨfiihi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jaanotɨ: Diitotɨ siinoco ɨcɨqui, noomoro siinoco mahacɨhachiijɨ, ¿coyomo imi fɨne toono? Tollɨro bu iimifiitɨmo iimitɨmoco siinoco acɨfihi; Diitotɨ siinoco mɨhɨcɨqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jaanotɨ amɨɨhai, amɨɨhai mɨnaaco magaijɨ, sinehejeque diitoco mahacɨ: Diitotɨ siinoco toono jaada mɨhɨcɨqui, nootɨmo. Jaachiijɨji guiraajino amɨɨhaico niquejefaño ajaaduno. Jaamo Moocaani caamovohɨ iicaabo seemetɨ mihicahi. Jaabo diibo tollɨro imino moonɨɨbo famoocoro, bu aacɨnohallɨvɨ cahacɨsutɨmo iicahicarumoco, iimitɨmeheje iicarumoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jaanegui amɨɨhai sitaaco mɨhɨdaasugo amɨɨhai tahe Moocaani iicabadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Sitaaditɨ imitɨno mehesɨcɨnɨmoro mihiimaadino, jaachiijɨ Moocaani amɨɨhaico tollɨro neejitɨhi. Sitaaco iimitɨco meneedino, jaachiijɨ Moocaani amɨɨhai imitɨco neejitɨhi. Sifiima mɨhɨɨbacasinoco imino mihimibachucasi amɨɨhai imitɨco Moocaani ibuusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Sitaaco siinoco mahacɨ. Jaaneguiiha amɨɨhaico bu Moocaani tollɨ acɨji; illeegucufaño imino oovɨcɨɨboro, imino gatyuucɨ cuhufono cabɨɨcɨɨboro tetecuuboro. Jaanotɨ amɨɨhai sitaaco mohoovobadɨro Moocaani amɨɨhaico eeveji, ");
INSERT INTO bmrNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","nooboro Jesu jillɨ oovɨcɨuhi: ¿Nacu ihaallɨɨma achahaaboco bu sifi ihaallɨɨma achahaabo sɨɨguejirahi? ¿Nacu famɨsicɨro ifapaajefaño aquetetejitɨrahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jaabadɨro cajaatyo miyamɨnaa ijɨɨbogomɨnaafi janaanɨcɨ jeevatatɨhi. Jari ɨjɨɨbogonoco iimivucuudɨ ijɨɨbogomɨnaafibadɨ jeevajirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Mɨllɨ jaabo dinahabo aallɨɨfaño iicano beevagayɨcoro adaatyɨmeebe, dihaallɨɨfaño cutuucɨdɨno iicanoco daatyɨmetɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Mɨllɨ jaabo dinahaboco neejirahi: Tañahabo, ene ɨco dihaallɨɨfaño iicano beevagayɨco ɨcɨqui, neejirahi dihaallɨɨfaño cutuucɨdɨno iicanoco daatyɨmetɨɨbo? Tajeebɨɨ imihi, nooboro sitaaco abañɨfiibo, itɨconɨ dihaallɨɨfaño iicatuucɨco dɨɨcɨ. Jaadɨ jari imino daatyɨmeji dinahabo aallɨɨfaño iicano beevagayɨco. Jaadɨ diiboco adaamusuubo gañɨɨji. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Chahaho ɨmoho iimiho iimitɨnoco onoovaho. Jaabadɨro chahaho iimitɨho iiminoco onoovaho. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jaamaño inoovatatɨro siyomo ɨmohonoco magaajatahi. Jarɨɨmɨho añaajebaco noovajitɨrahi. Tollɨro sisimɨcoohai baacuhico noovajitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jaabadɨ iimihuseebe iiminocoro neefihi miyaano ijeebɨɨfaño iicamaño. Jaabadɨro iimitɨɨbo imitɨno iimaanɨcɨhi, ijeebɨɨfaño iimitɨno iicamaño. Jaamaño iijɨri ihiimaano ijeebɨɨfaño agahafɨcɨnɨnotɨ saahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Collɨhi amɨɨhai uco: Aivojɨɨbo, Aivojɨɨbo, monoomoro uujoho onoonoco meheetavehicatɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Amɨɨhaico neeji: ¿Jinejebadɨ fɨne jeevaabo tajaago asaaboro uco uguubuuboro uujoho atajɨɨbanoco eheetavoobo? ");
INSERT INTO bmrNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Fɨne saafi miyamɨnaafi iijaco eheetavuubobadɨ itɨconɨ seediubo faicuvano. Jaadɨ tanooco nicuubo guiisibanohallɨvɨ. Jaanobuunatɨ teehi amachituuno inɨfaihu sefano toojaco ɨcɨhinɨurahi. Jaaruno toojaco maryɨbasuutɨhi, guiisibanohallɨvɨ cuhufono tano inicucɨnɨumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jaanotɨ uco guubucuruubo uujoho atajɨɨbarunoco omoonɨtɨɨbo jillɨ jeevahi; tɨcovono iijaco jiinɨgaibaahohallɨvɨ cahajɨno ificuubobadɨ jeevahi. Jaaja teehi amachituuneri inɨfaihu toojaco sefano ɨɨcɨhinɨuneri tooja acutuuhi. Jaaneri tooja paryɨ imivocafutuuhi ifinɨja. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jaadɨ Jesu miyamɨnaama ihiimaahicaunobuunatɨ fuucuubo Capernau cuumivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jahɨ icaubo aivojɨɨbo romanomɨoobo. Jaabo icojɨmɨnaafico sihidɨ agaijɨubo guihuvauhi. Jaabo niinovacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jaabo ihaivojɨɨbo Jesutɨ ihiimaaunoco uguubuuboro judiomɨfeenetɨ iquillahutoco galluubo Jesuco ijɨɨbeguetequi asaaboro diibo jeecɨvomɨnaafico ibuheesuvaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jaamo Jesujaa ufuumoro tɨcovauhi diiboco onoomo: Romano aivojɨɨboco daamusu, aivo imihuseebe ");
INSERT INTO bmrNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","muucuumico aivo gaijɨɨbo. Jaaboro mɨɨhaidi sinagogajaco eetavusuhinɨɨbo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jaanegui Jesu diitoma fuuhi. Jaamo fiitɨvucunaa romano aivojɨɨbo saatoho inahabonɨmɨnaaco galluuhi Jesuco ineetequi: Ɨɨjoho Aivojɨɨbo, jaafa icacuuno sihidɨ jeevahi jaabo iijafaño asaajiruno. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Cono bu uuro dijaago ɨco ɨɨcɨtoobo foonova. Jaaneguiiha saatɨɨboro tahɨgotɨro dinoo. Jaaneri tacojɨmɨnaafi buheeji. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Uujoho bu icaruubo aivojɨto tajɨɨbaguiino icahi. Jaabadɨro bu amocasimɨnaahallɨvɨ uujoho aivojɨɨbotɨ icahi. Jaamotɨ saatohoco: Difoo, unuusumi foonɨcɨmo. Jaamotɨ saatohoco: Disaa, unuusumi saanɨcɨmo, tollɨro tacojɨmɨnaafico: Siinoco deetavo, unuusumi eetavonɨcɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jaanoco Jesu uguubuuboro sihidɨ jabafiituuhi. Jaaboro diibo dojɨcutɨ sihidɨ asaaumoco emeecɨuboro nuubo: Miyanotɨro aivo Israel cuumimɨnaa icarumofaño atyɨmetɨhi jaanɨ janaanɨcɨ miyaavogoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jaamo ihaivojɨɨbo agalluumo iijajaa dojɨcuvɨro uhuumiumo atyɨmeuhi icojɨmɨnaafi ubuheetecuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jaanobuunatɨ Jesu fuuhi Nain onoocuumijaago. Jaaboma feehicaumo ijɨɨbogomɨnaa, sihidɨ miyamɨnaa icamo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jaabo tuucuumitɨ ifiitɨvuubo atyɨmeuhi chuumuhuco icɨɨtequi asatyumoco fibaijɨgo seemene ɨdɨɨboro iicaubo iguijeveuboco. Jaagoma sihidɨ tuucuumio miyamɨnaa fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jaagoco Jesu aatyɨmeuboro ɨdaasuguuhi. Jaaboro diigoco nuubo: ");
INSERT INTO bmrNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Taajirahana, nooboro ichuumuhujaa ufuuboro tuuhuco dudɨɨcɨtuubo. Jaasumiro tuuhuco ihiibɨumo julleecamaaiuhi. Jaanegui Jesu ichuumuhuco nuuhi: Sɨcafefi, ɨco neehi: ¡Gañiivo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jaasumiro uchuumucuubo agañiivuuboro casɨɨvuuhi. Jaaboro iimaacuubo. Jaaboco Jesu siino seejɨco acɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jaanoco aatyɨmeumo sihidɨro iguiumoro Moocaanico imehicauhi: Sihidɨ jeevaabo aivo Moocaani iimaamɨnaafi mɨɨhaivɨ jafevehi, noomoro. Bu neehicauhi: Moocaani saahi iicuumico itaajasuqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jaanoco guubuumo paryɨ Judea jiinɨjeri ihallɨdɨ iicaucuumineri Jesu omoonɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jaamo Juama iicahicaumo diiboco paryɨ jɨɨbugucuuhi Jesuditɨ. Jaanegui diitotɨ miimɨsiicɨtɨ ocoovauboro, ");
INSERT INTO bmrNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesujaa galluubo idillutequi: ¿Naa miyaano ɨɨjoho oono Cristo asaajiibo? ¿Jaanotɨ diibo iicatɨhachiijɨ sifiico iteemequi? ");
INSERT INTO bmrNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jaanegui Jua agalluumo Jesujaa ufuumoro nuuhi: Jua Nitɨmɨnaafi mɨɨhaico galluuhi ɨco midilluqui: ¿Naa miyaano ɨɨjoho oono Cristo asaajiibo? ¿Nacu sifiico meteemeji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jaamo diito diibovɨ ɨɨfutuunaaca Jesu buheesuuhi sihidɨ miyamɨnaaco iguihuvanotɨ, iimitɨno ɨjɨmɨtɨ icano, tollɨro aatyɨmetɨmehejeque ihaallɨɨnoco imitusuhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jaanegui Jesu diitoco iimusuuhi: Mofoo. Jaamoro Jua Nitɨmɨnaafico mɨjɨɨbogo mahatyɨmeneque, muguubunoco icano. Mɨjɨɨbogo mɨllɨ aatyɨmetɨmo atyɨmeneque, ɨɨgotɨmo ɨguehi, ifoojohoma iicamo buheesucafetehi, inohojɨno uguubutɨmo guubucuuhi, iguijeveme siino buheesucafetehi. Jaanotɨ ɨɨdaasufiimoco taajasujɨɨbogoco jɨɨbeguehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Imicani icajiibo uuvɨ iimitɨnoco aatyɨmetɨɨboro imiyaavogoobo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jaadɨ Jua Nitɨmɨnaafi agalluumo ufuunobuunatɨ Jesu miyamɨnaaco Jua Nitɨmɨnaafiditɨ nuuhi: ¿Jinejeque amɨɨhai memeecɨjeuhi sɨcaihɨgovɨ? ¿Saafi noofaijɨcuco guibuhuba ejebehinɨnobadɨ iicatɨɨboco, etɨ? ");
INSERT INTO bmrNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Nacu, jinejeque memeecɨjeuhi? ¿Saafi miyamɨnaafi iminoono gaachehunofaño jɨɨcɨnɨuboco? Jillɨ icautɨno. Amɨɨhairyo magaajahi iminoonofaño ɨjɨɨcɨnɨmo aivojɨto iijanofaño icanɨcɨhi sinehejeri imo imo iicamo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jaanotɨ ¿jinejeque nacu memeecɨjeuhi? ¿Nacu Moocaani iimaamɨnaafico? Jɨɨhɨ, miyaano, saafi janaanɨcɨ Moocaani iimaamɨnaa janaanɨcɨ ejeevaabo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Diibo Jua, diiboco tahɨmega agalluujinoco Caatɨnɨhaamefaño jillɨ onoobo: Uujoho tajɨɨbogomɨnaafico, dihɨmegavɨ galluuhi, dihɨmega jɨɨhaico iimibachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Amɨɨhaico neehi: Paryɨɨcɨno miyamɨnaafeenetɨ chahamo Moocaani iimaamɨnaa Jua Nitɨmɨnaafi janaanɨcɨ iicamo: Jaarunofaño jisumitɨ sihidɨ ejeevatɨɨbo Moocaani aivojɨfaño Jua janaanɨcɨ sihidɨ jeevahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jaanoco paryɨ miyamɨnaa impuesto jaadusumɨnaa icamo Jua nitɨco agaayɨcɨumo miyaavuguuhi Moocaani tajɨɨba miyaano iicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jaarunaa fariseomɨ, caatɨnɨmɨnaa icamo Jua nitɨco agaayɨcɨutɨmo tɨhɨsuuhi Moocaani iimuguuboro diitedi omoonɨujirunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jaanoma iicaubo Aivojɨɨbo Jesu nuuhi: ¿Jinejevɨ fɨne jisumio miyamɨnaaco oovɨcɨji? ¿Jinejebadɨ fɨne jeevamo? ");
INSERT INTO bmrNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jɨɨhɨ, jillɨ fɨne oovɨcɨji oono seeme goohasinovɨ acasɨɨvomo abañamaaimoro igataavomɨnaaco ocoovadiinamaainɨcɨmobadɨ jeevamo: Amɨɨhaidi siruuco miguisɨcuurahi. Jaarunaa mihimogotɨhi magaaseneque, noomo. Jaanegui ɨɨdaasujɨɨjeque taca mamasivaqui, noomo. Jaarunaa mihimogotɨhi, noomo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jaabadɨ iicano Jua Nitɨmɨnaafi saauhi machutɨɨboro aigafiibo, aivofaihuco adutɨɨbo icano. Jaaboco amɨɨhai iimitɨno ɨjɨma iicaabo meneehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jaanobuunatɨ saahi uujoho Miyamɨnaafibadɨ Ifiivuubo amachuubo, aaduubo icano. Jaaboco amɨɨhai uco meneehicahi machufifiibo, adufifiibo impuesto jaadusumɨnaa, imitɨmɨnaa icamo gataavomɨnaafi uco meneehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Jaarunaa Moocaani gaaja miyaano iicano gaajacɨcafetehi diiboco agaajamofañodɨ, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jaanaa saafi fariseomɨoobo Jesuco coovauhi diiboma imachuqui. Jaanegui Jesu jaahe ufuuboro imachuqui casɨɨvuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jaanaa saafigo gaigo tuucuumiogo imitɨno iicahicaugo Jesu Simon fariseomɨoobo iijajaa amachutuunoco agaajacɨugoro saaugo, alabastro paaje gatyuucɨ dɨɨrɨba imono facɨcɨsucɨnɨfaihuma. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jaago taagoro Jesu tɨhai cojɨvɨ iminifutuugoro tɨconɨugo Jesu tɨhaiñoco ihaallɨɨ tofaihuneri ejeesugo. Jaagoro imeebaiguiri ifilluugoro totɨhaijeque nɨnɨɨcɨhicaugo. Jaadɨ ifacɨcɨfaihuco toonohallɨvɨ tucaruugo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jaanoco, Jesuco ucuuhuvaubo ifariseomɨoobo aatyɨmeuboro esamaaiuhi: Jaanɨ miya, Moocaani iimaamɨnaafi iicaruva gaajajiruubo mɨɨjoho diiboco coyomo miyamɨnaago ududɨɨcɨnoco mɨɨro diigo imitɨno iicafino gaigo, nooboro ijeebɨɨfañodɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jaanegui Jesu ifariseomɨooboco nuuhi: Simon eneecau ɨco siinoco neequi, nooboro. Jaanegui ifariseomɨoobo iimusuuhi: Dinoo, jɨɨbogomɨnaafi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jaanegui Jesu nuuhi: Miimɨsiicɨco saafi nɨhɨbamɨco aacɨunoco debehicauhi. Saafi debeuhi sahuse boogava tɨcovovɨ. Jaanotɨ saafi debeuhi cincuentadɨ aameva iicano. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jaarunoco diiboco ajaaduutɨnoma iicaubo famɨsicɨcoro ideudaco jeevesucuuhi. Ene uco dinoo; ¿Naa cajaanɨ fɨne diitɨsitɨ janaanɨcɨ diiboco gaijɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jaanegui Simon diiboco iimusuuhi: Fɨne janaanɨcɨ guiraano edebeuruubo, nooboro. Jaanegui Jesu diiboco nuuhi: Jɨɨhɨ, jahi, ");
INSERT INTO bmrNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","nooboro diigoco emeecɨuboro Simonco nuuhi: ¿Naa daatyɨmehi jaamoco? Uujoho diijafa saarahi. Jaaruuboco nɨfaihutɨ daacɨtɨhi tatyɨhaico nitɨqui. Jaanotɨ jaamo gaigo uco tatyɨhaico ihaallɨɨ tofaihuri nitɨhi. Jaagoro imeebaiguiri filluugo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Uco nɨnɨɨcɨtɨhi. Jaanotɨ diigo agasenetɨro suufenɨtɨhi tatyɨhaico ɨnɨnɨɨcɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Uco deesutɨhi facɨcɨfaihuri taañigaɨco. Jaanotɨ diigo dɨɨrɨba facɨcɨnoco tatyɨhaico jeesuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jaanegui ɨco neehi: Sihidɨ iimitɨco ubuusucuuneguiiha uco sihidɨ agaijɨnofeenedɨ gaajacafotono. Jaanotɨ saafiico ajashunoco uujoho ubuusuubo ajashuno uco gaijɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jaadɨ diigoco nuubo: Dihimitɨco ɨco buusucuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jaanaa saatohoco diiboma ucuuhuvaumo ɨgɨcɨnɨumañotɨ tɨcovauhi onoocasiumo: ¿Mɨɨjoho fɨne jaanɨ imitɨ icarunoco ubuusuubo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jaarunaa Jesu diigoco nuuhi: Taajasucafutucuuhi imiyaavogomaño, sajeebɨɨ fuucu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jaanobuunatɨ Jesu faacuumivari feehicauhi jɨɨbogooboro acɨhicauhi Moocaani aivojɨ iijɨco. Jaaboma icahicaumo motɨhaitɨ miimɨsiicɨdɨmo iminɨsumɨnaa. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tollɨro bu saatoho gaigoomɨ diiboma gataavehicauhi diibo, diitoco iimitɨno ɨjɨmɨtɨ, iguihuvatɨ icano ubuheesuhicaumo. Jaamofeeneri icaugo Maria Magdalena onoogo. Jaagotɨ sahuse juugahusetɨ miimɨsiicɨ icano iimitɨno ɨjɨmɨ ihiinuugo; ");
INSERT INTO bmrNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tollɨro Chuzo Herode cojɨmɨnaafi taaba Juana onoogo, bu Susana onoogo icano, bu sihidɨ saatoho diitoco amusuhicaumo inehejema iicaumeheje. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jaasumi sihidɨ miyamɨnaa faacuumivatɨ saahicauhi Jesuco emeecɨvamo. Jaamo sihidɨ iigaivuumoma iimaahicaubo siinovɨ oovɨcɨɨboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Saafi basumɨnaafi fuuhi abasutuubo itoogaiñoco. Jaabo basuuboro ufuuno samañoono acutuuhi jɨɨhaifaño. Jaanoco quicuhicaumo, bu jaanoco joomɨ asaaumoro machuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jaanotɨ samañoono acutuuhi guiisihallɨvɨ. Jaano ihiinuuruno chuumuuhi amaiutɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jaanotɨ samañoono aifuuhi jarɨɨmɨhoonofeenevɨ. Jaaruno toonoma sano ihiinurunoco ijarɨɨmɨ macanɨsuuhi toonohallɨvɨ ujusiuneri. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jaanotɨ samañoono aifuuhi iimino jiinɨjevɨ. Jaano ifiivuuno sihidɨ noovauhi ciendɨgaiva tɨcovovɨ. Jillɨ nooboro Jesu sefano nuuhi: Amɨɨhai nohojɨma mihicahachiijɨ muguubu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jaanegui diiboco ijɨɨbogomɨnaa dilluuhi: ¿Mɨllɨ eneejirunoco tollɨ dohoovɨcɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jaanegui Jesu diitoco nuuhi: Amɨɨhaico imino Moocaani aivojɨ agaajaratɨnoco gaajasuhicahi. Jaanotɨ sitaaco siinovɨ oovɨcɨɨboro uujoho neehicahi. Jaamo emeecɨrumo aatyɨmetɨmobadɨ iicaqui. Bu oovɨcɨhi jaamo uguubucuurumo guubutɨmobadɨ iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jillɨ eneejiruno toono: Itoogaiño Moocaani iijɨ, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jɨɨhaifaño ahaacotono onoono: Saatoho uguubucuurunoco Satanas asaaboro ijeebɨɨfañotɨ ɨcɨhi imiyaavogomoro ataajajiruneguiiha, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jaanotɨ guiisihallɨvɨ aacutuuno onoono: Saatoho imo imo gaayɨcɨrumo imino abacocoovatɨmaño jihachutaro imiyaavogomo. Jaamoco ɨjɨ ɨnɨsusumi ejeevesumoro dojɨcuvɨro minifotomo, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jaanotɨ jarɨɨmɨhoonofeenevɨ aacutuuno onoono guubucuurumo gueenene icatɨno toonoco macanɨsuno sinehejejaagoro ijeebɨɨ iicamaño nɨhɨbamɨ imiguiiharo, jiinɨjemɨnaa iimogono jaagovɨro ijeebɨɨ iicamaño noovasutɨmo, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jaanotɨ iimino jiinɨjevɨ aacutuuno onoono imino jeebɨɨma iicamo imino uguubunɨcɨmoro miyaaveguehi Moocaani iijɨco. Jaamo imino ofoomo imino noovasuhi, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","¿Mɨɨjoho cɨɨjɨgai mecuco ɨnɨfutusumoro siineri fabaacutatɨhi, cɨgaiijeguiino ficutatɨhi icano? Caamo mificutahi toojaco aachɨcɨnofaño ɨjɨcafotomo ihatyɨmequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jaabadɨ chahano otoovono ɨɨfuvusutɨno iicano, jisumi agaajaratɨno ufucu paryɨ fanooro foovono gaajacafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jaanegui imino muguubu: Diito Moocaani iijɨco agaayɨcɨmoco siino janaanɨcɨ acɨji. Jaanotɨ toonoco imiyaavogotɨɨbotɨ dumɨtɨɨcɨji: Uuma icano, unuurunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jaanaaca saaumo Jesu nahabomɨ, seejɨ icamo diibo iicauhɨgo ifeequi. Jaarumo diibovɨ ɨfutuutɨhi sihidɨ miyamɨnaa iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jaanegui saatoho Jesuco jɨɨbuguuhi: Diiseejɨ, dinahabomɨ icamo jahisi icahi. Jaamo dijaa saajirahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jaanegui diitoco nuubo: Moocaani iijɨco uguubumoro omoonɨmo, diito naha gaharubi, tañahabomɨ icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Safoono Jesu ijɨɨbogomɨnaama jɨcafutuuhi muuaifaño iicauga meenegafaño. Jaaboro diitoco nuubo: Masɨɨgo onagoojɨnivɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jaanegui fuumaaca Jesu imeenegafaño cɨgauhi. Jaanaa fuumoco guibuhuba sefano ɨcɨuhi. Jaaneri imeenegafa sihidɨ nɨfaihu gahafuuhi. Jaaneri imeenega niituurahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jaanegui Jesuco aaicusuumoro nuumo: ¡Mojɨɨbogomɨnaafi, Mojɨɨbogomɨnaafi, miniituucuuhi! noomoro. Jaanegui Jesu aaicuuboro guibuhuba, tyuucai icanoco ɨɨbauhi. Jaasumiro ɨllɨɨvuunoro paryɨ sɨɨcutuuno. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jaanegui ijɨɨbogomɨnaaco nuuhi: ¿Mɨllɨ jana amɨɨhai miyaavogo icahi? nuubo Jesu. Jaarunaa diito iigutuumoro jabafiituuhi. Jaamoro dillucasiuhi sanomɨro: ¿Mɨɨjoho fɨne jaanɨ? Guibuhuba, nɨfaihu icarunoco atajɨɨbano diiboco: Jii, neehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jaanofeenevɨ ɨɨfutuumo gadarenomɨ jiinɨjevɨ Galilea jiinɨje cojɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jaabo Jesu imeenegatɨ isi iinuubaaca diibojaa saaubo tuucuumioobo, sɨɨcɨjetɨro ififaño ɨjɨmɨma iicaubo. Jaabo gaachehufaño icacuutɨɨbo, jaahe icacuutɨɨbo cɨɨhojɨno iicahɨgo iicaaboro feehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jaabo Jesuco aatyɨmeuboro diiboguiino memuɨɨvuubo gaibacɨnɨɨboro, sefano nuuhi: ¿Collɨhi tajaa saahi, ɨɨjoho Jesu Moocaani caamovohɨ iicaabo Achi? Ɨco Moocaanifañodɨ neehi: Ɨdaasuno uco moonɨdino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jillɨ nuubo Jesu ihɨjɨco: Diibotɨ dihiino, nooboro, atajɨɨbahicauneguiiha. Fiiva foova ihɨjɨ diiboco gaayɨcɨhicauhi. Jaaneguiiha miyamɨnaa diiboco agaayɨcɨmoro jɨgaiñehiri sisɨuhi ihusene, itɨhaiño icanoco sama iicaqui. Jaarunoco udubaicɨuboro ihɨjɨ diiboco gaasuhicauhi sihɨguehejevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jaaboco Jesu dilluuhi: ¿Mɨɨjoho dimomo? nooboro. Jaanegui iimusuubo: Cuumi tamomo, nooboro. Jillɨ nuubo diibofaño sihidɨ iimitɨno ɨjɨmɨ ɨjɨcafutuumaño. Jaamo ihɨjɨmɨ Jesuco dilluuhi; ");
INSERT INTO bmrNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Moocaani eheetavuuhojɨ ɨjɨmɨco igañɨɨqui iguiraahojɨfaño diitoco gañɨɨtɨɨbo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jaanaa sihidɨ faafaimɨ icauhi ifagajɨvɨ amachuumo. Jaanegui ihɨjɨmɨ Jesuco dilluuhi ifaafaimɨfaño ijɨcafetequi. Jaanegui: Jii, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jaasumiro diibotɨ ihiinuumoro ifaafaimɨfaño jɨcafutuumo. Jaaneri paryɨ ifaafaimɨ ifagajɨtɨ imuuaifaño aaifuumoro paryɨ macanɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jaanoco ifaafaimɨ toomomɨnaa aatyɨmeumoro iigutuumoro goovano fuumo ifaacuumifaño buhɨ iicameheje icamoco jɨɨbogomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jaanegui miyamɨnaa fuuhi: ¿Mɨllɨ iicano? noomoro emeecɨtuumo. Jaamo Jesu iicauhɨgo ɨɨfutuumo ɨjɨmɨma iicauboco atyɨmeuhi ihɨjɨmɨma chahacuuboco. Jaabo Jesu cojɨvɨ gɨcɨnɨubo imichehufaño jɨɨcɨnɨɨbo imino icacuuboco. Jaaneri sihidɨ miyamɨnaa iguiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jaanoco aatyɨmeumo diitoco jɨɨbuguuhi, mɨllɨ ɨjɨmɨma iicauboco ubuheesuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jaanoma iicaumo gadarenomɨnaa tɨcovauhi Jesuco agalluumo ijiinɨjetɨ ifeequi diibo tollɨ omoonɨunotɨ sihidɨ iiguiumoro. Jaanegui Jesu meenegafaño jɨcafutuuhi ifeequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jaarunaa ihɨjɨmɨ diibotɨ ihiinuubo Jesuco dilluuhi diiboma ifeequi. Jaarunaa Jesu diiboco tajɨɨbauhi ifitafetequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Jaaboro nuubo: Diijajaa duhuumi. Jaaboro paryɨ dɨɨbogo Moocaani ɨco omoonɨnoco, nooboro. Jaanegui paryɨ tuucuumiri jɨɨbogooboro fuuhi Jesu diiboco omoonɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jaanaa Jesu onagoo muuaivɨ ɨɨfutuuboco miyamɨnaa imo imo gaayɨcɨuhi, paryɨ diiboco eteemehicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jaanaa gaseubo Jairo onoobo sinagogaja aivojɨɨbo. Jaabo Jesuguiino ajavuvuuboro imino diiboco nuuhi Jesu diibo iijajaa ifeequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ɨdɨɨgoro ille fahuseecɨ motɨhaitɨ mificabacɨ ɨdɨɨno icacuurugo iguijevecuujineguiiha. Jaanegui Jesu ufuuboma sihidɨ miyamɨnaa ufuumo diiboco ijene jɨmatajeruhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jaamofeenevɨ icaugo saafigo fahuseecɨ motɨhaitɨ mificabacɨ tɨcovovɨ icacuugo tɨɨjeheri. Jaarugo buheehicautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jaago Jesu bujɨnagotɨ asaaugoro igaachehujɨnibaco dudɨɨcɨugo. Jaasumiro diigoco itɨɨjoho llɨɨvɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jaanegui Jesu nuuhi: ¿Mɨɨjoho uco dudɨɨcɨhi? nooboro. Jaarunoco famooro: Chahano, eneehicauneguiiha, Pedro inahabomɨ icamo nuuhi: Mojɨɨbogomɨnaafi, miyamɨnaa ɨco fahɨgovatɨ ɨjɨmatajerunoco; ¿mɨllɨ jaabo dilluhi: ¿Mɨɨjoho uco dudɨɨcɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jaarunaa Jesu nuuhi: Saatoho uco dudɨɨcɨhi gaajacɨhi tamityari saatoho ubuheeteneque, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Diigo omoonɨunoco agaajacɨuneguiiha sihidɨ vɨvɨvɨvɨ iigutuugoro saauhi. Jaagoro iguiino ememuɨɨvuugoro miyamɨnaa ɨmefeenevɨ jɨɨbuguugo mɨllɨtɨ ududɨɨcɨunoco, jaasumiro ubuheeunoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jaanegui Jesu diigoco nuuhi: Gaha, buheesucafutucuuhi imiyaavogomaño. Sajeebɨɨ fuucu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu ihiimaaunaaca Jairo sinagogaja aivojɨɨbo iijatɨ saafi asaauboro Jairoco noovauhi: Daicɨgai guijevecuuhi; Jɨɨbogomɨnaafico dihiimaasucuudino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jaanoco Jesu uguubuuboro Jairoco nuuhi: Diiguetedino. Jillɨ miyaavogo, daicɨgai buheeji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Toojavɨ ɨɨfutuudɨ mɨɨhaiñoobaco faño satyuutɨɨbo ɨdɨɨmoro Pedro, Jacoobo, Jua, diigo caanimɨsi icamomaryo faño fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jaanaa fañoojavɨ saatoho taacasimoro iimaafivehicauhi diigo iguijeveuneri. Jaarunaa Jesu diitoco nuuhi: Mataajirahana, guijevetɨgo. Jillɨ cɨgago, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jaarunaa diiboco dejecuumo iguijevecuunoco agaajaumoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jaanegui Jesu diigoco ihusetɨ agaayɨcɨuboro sefano nuuhi: Bagocaja, gañiivo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jaasumiro diigo ubuheeteugoro gañiivuuhi. Jaanegui Jesu tajɨɨbauhi diigoco ihobajaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jaaneri caanimɨsi sihidɨ jabafiituuhi. Jaarunaa Jesu nuuhi: Mɨɨhaiñoobaco mahatyɨmeneque mɨjɨɨbeguedino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jaanobuunatɨ Jesu fahuseecɨ motɨhaitɨ miimɨsiicɨ ɨdɨɨmo ijɨɨbogomɨnaaco igaiyɨɨcɨuhi. Jaaboro imitya, bu iijɨ icanoco acɨubo fanoohimitɨ ɨjɨmɨhallɨvɨ diitoco buhɨ igavaracuqui, tollɨro guihuvaco ibuheesuqui icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Galluubo diitoco Moocaani aivojɨ jɨɨbogoco ijɨɨbeguequi, iguihuvamoco ibuheesuqui icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jaaboro diitoco nuubo: Jinehejebaco masatyedino mofoomo queseibaco, lleegucubaco, duviricubaco, nɨhɨbamɨbaco icano. Caamoojaco miijaacɨ masatyedino. Sajaamaryo mofoo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Coojaavɨhacho mɨhɨfotojafañoro mihica, siijafaño, bu siijafaño icatɨno. Jari tomañotɨ mofoodɨ toojatɨ mihiino. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jaanotɨ amɨɨhaico agaayɨcɨtɨmañotɨ mihiinomoro amɨɨhai tɨhaipaajeguiino jiinɨco diitojaa matatacu diitohallɨvɨ toono jɨɨbogobadɨ iicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jaanegui ijɨɨbogomɨnaa fuuhi fahɨgovadɨ taajasujɨɨbogoco jɨɨbogomoro, iguihuvamoco buheesumoro icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jaasumi aivojɨɨbo Herode guubuuhi Jesu omoonɨhicaunoco. Jaaneri sihidɨ eesamaaihicauhɨgo iinigaɨ mɨtauhi. Saatoho neehicauhi: Jua Nitɨmɨnaafi siino buheetehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jaanotɨ saatoho neehicauhi: Moocaani iimaamɨnaafi Elia jafevehi, noomoro. Jaanotɨ saatoho neehicauhi: Sɨɨcɨjeototɨ Moocaani iimaamɨnaafi buheetehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Jaarunaa Herode nuuhi: Uujoho du quitɨcɨsuuhi Jua nigaɨco. Jaanegui jana, ¿mɨɨjoho jaanɨ diibeditɨ ɨjɨɨbocasinoco uguubuubo? nooboro Herode atyɨmeguehicauhi Jesuco. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jaamo iminɨsumɨnaa uhuumiumo Jesuco jɨɨbuguuhi imino moonɨmoro efeehicaunoco. Jaanegui diitoco satyuubo buhɨgovɨ Betsaida cuumi fiitɨno. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jaanoco miyamɨnaa agaajacɨumoro diito dojɨcutɨ fuuhi. Jaamoco Jesu agaayɨcɨuboro Moocaani aivojɨ iijɨco jɨɨbeguehicauhi, tollɨro iguihuvamoco buheesuhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jaanaa mihiijɨcuudɨ Jesujaago saaumo fahuseecɨ motɨhaitɨ miimɨsiicɨdɨmo iminɨsumɨnaa. Jaamoro diiboco nuumo: Miyamɨnaaco galluucu ijaguisɨtequi, jaamoro imachuqui iijano iicahɨgo jimañovɨ jinejeba chahahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jaarunaa Jesu diitoco nuuhi: Amɨɨhairyo diitoco mamachusu, nooboro. Jaanegui diito nuuhi: Mɨɨhaima chahano, ɨdɨɨnoro sahuse maahugayɨno, bu miimɨsiicɨ taavaabomɨsigayɨɨcɨ, ¿mɨllɨ fɨne mofoomoro machutaatɨ manaajeteji paryɨ jito miyamɨnaadi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jaamo igaifiimɨrou cinco mildɨmo icauhi. Jaanotɨ gaigoomɨ, bu seeme icano oovarautɨhi. Jaanegui Jesu ijɨɨbogomɨnaaco nuuhi: Monoo icasɨɨcamaaiqui cincuentadɨmova saaje, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jaanegui tollɨ omoonɨuneri famooro casɨɨcamaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jaadɨ Jesu sahuse imaahugayɨno, itaavaabomɨsi icanoco agaayɨcɨuboro niquejejaagoco emeecɨuboro toonohallɨvɨ Moocaanima iimaaubo. Jaadɨ iquisicuuboro ijɨɨbogomɨnaaco acɨubo miyamɨnaaco diito ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jaanoco paryɨ famooro amachuumo utuvaumoro imono icauhi. Jaadɨ ihatyuuvoco ananɨumo gahafusuuhi jɨiibaiñoco fahuseecɨ motɨhaitɨ miibaicɨ ɨdɨɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Safoono Jesu Moocaanima iinoro ihiimaahicaudɨ ijɨɨbogomɨnaaco dilluubo: ¿Nacu mɨɨjohova uujoho iicanoco neehicamo miyamɨnaa? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jaanegui iimusuumo: Saatoho neehicahi: Jua Nitɨmɨnaafi. Jaanotɨ saatoho: Elia neehicahi. Jaanotɨ saatoho: Cajaanɨhacho fɨne sɨɨcɨjeototɨ Moocaani iimaamɨnaafi ubuheeteebe, neehicahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jaarunaa siino dilluubo: Jaana amɨɨhai, ¿mɨɨjoho uujoho iicanoco meneehicahi? nooboro. Jaanegui Pedro diiboco nuuhi: Ɨɨjoho Cristo Moocaani agalluubo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jaarunaa Jesu diitoco imino faguuhi mɨɨhaiñoobaco jɨɨbogotɨmo iicaqui, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Uujoho Miyamɨnaafibadɨ Ifiivuubo sihidɨ ɨdaasuno icaji quillahuto, sacerdotemɨ aivojɨto, caatɨnɨmɨnaa icamo uco jɨɨheveji. Jaamoro gaicaausujimo. Jaaruubo mifucucɨ, safucu icanotɨ siino buheeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jaanobuunatɨ famoocoro nuubo: Cajaanɨhacho tadyojɨcutɨ asaagoobo difi gaijɨco ajabajeveebere tadyojɨcutɨ fafucuvaacɨvɨro isaaqui ifiico ɨdaasuno omoonɨsujinoco iguitɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jaanotɨ ifiico agaijɨɨbo, ifiico mɨtasuji. Jaanotɨ taaguiinodɨ ifiico ɨmɨtasuubo ifiico taajasuji. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mɨɨro saafi miyamɨnaafi paryɨ jiinɨje busumijeque gaayɨcɨruubo. Jaaruubo ijeebɨɨco ɨmɨtasuuboro ifinɨsuruva, ¿nacu mɨllɨtɨ imijiruno? ");
INSERT INTO bmrNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jaabadɨ cajaatyohacho uutɨ, tajɨɨbogojɨtɨ icano unucufeveebetɨ, tollɨro uujoho Miyamɨnaafibadɨ Ifiivuubo nucufeveji guihirubi aivojɨri, itoomomɨnaama aivojɨɨbobadɨ asaadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Miyanotɨro amɨɨhaico neehi: Jino mihicamotɨ icamo saatoho Moocaani aivojɨco aatyɨmetɨnohachuta guijevetɨmo iicano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jaanobuunatɨ sajaguisɨ nijequetɨ Jesu fuuhi ifagajɨjaago Moocaanima ihiimaaqui Pedro, bu Jacoobo, bu Jua icamoma. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jaabo Jesu Moocaanima iimaaunaaca ihɨme siibadɨ minifutuuhi igaachehu sisesee minifutuuhi arɨcuno. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jaabovɨ jafeveumɨsi miimɨsiicɨ gaifiimɨsi Moise, Elia icamɨsi diiboma iimaamɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jaamɨsi icauhi imino arɨcunofeeneri. Jaamɨsi iimaahicauhi Jesu Jerusalevɨ iguijeveujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jaanaa Pedro inahabomɨsima sihidɨ cɨgara aivuurunaa cɨgatɨmo icahicauhi. Jaamo atyɨmeuhi Jesu, bu icojɨri iicaumɨsi icamo imico. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jaamɨsi diitɨsi Jesutɨ fuucuunaaca Pedro diiboco nuuhi: Mojɨɨbogomɨnaafi, Imicani jimaño mihicano. Masɨɨ mɨnɨjeganɨqui migaacɨ, saga icano nɨjeganotɨ; ɨɨdi saga, Moisedi saga, Eliadi saga icano, nuubo Pedro. Jillɨ onoonoco esɨcɨnɨtɨɨbo iimaauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jaabo ihiimaaunaaca diitoco aimuufai mibaacuuhi. Jaaneri sihidɨ igutuumo ihaimuufaifaño iicauneri. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jaanaa guubuumo ihaimuufaifañotɨ unuunoco: Jaanɨ taseemene agaijɨɨbo. Diibo onoonoco muguubunɨcɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tollɨ unuunobuunatɨ Jesu iinoro icacuuboco atyɨmeumo. Jaarunoco diito mɨɨco jɨɨbogotɨmo llɨɨvɨ icaumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jaano seseevedɨ Jesu Pedromɨma togajɨtɨ niituunaaca sihidɨ miyamɨnaa Jesujaa saauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jaamofeenetɨ saafi Jesuco sefano nuuhi: Jɨɨbogomɨnaafi, taseemeneque meecɨ, ɨdɨɨboro uudi iicaaboco. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jaaboco ɨjɨ agaayɨcɨɨboro gaibasuhicahi, chuumusuhicahi, iijɨri jɨvaasecuco iinusuhicahi ɨdaasuno omoonɨɨboro suufenɨhicatɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Dijɨɨbogomɨnaaco nuucuurahi buhɨ igañɨɨqui. Jaaruuboco ɨnɨsurunofaño iinotɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jaanegui Jesu nuuhi: Ɨɨ jeedɨ fɨne imiyaavogotɨno miyamɨnaa jito iimitɨmo, ¿mɨhachuta fɨne amɨɨhaico jaabɨcɨɨboro icaji? nooboro diiboco: Juugavɨ daachico sɨva, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jaanegui ɨsɨvaabo Jesuvɨ fiitɨvuunaaca ihɨjɨ diiboco jiinɨjehallɨvɨ agañɨɨuboro diiboco chuumusuubo. Jaarunaa Jesu ihɨjɨco ɨɨbauhi. Jaaboro isɨcafefico ubuheesuuboro caanico acɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jaaneri famooro jabafiituuhi Moocaani sihidɨ ejeevauneri. Jaanaa famooro Jesu omoonɨuneri eetyeunaaca nuubo ijɨɨbogomɨnaaco: ");
INSERT INTO bmrNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Jinooco imino muguubu. Jaamoro majabajeevedino: Uujoho Miyamɨnaafibadɨ Ifiivuubo miyamɨnaa usefaño acɨcafeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jaarunoco ijɨɨbogomɨnaa gaajahicautɨhi diitoco unuurunoco diitedi toovono iicaumaño. Jaanoco diitoco ijɨɨbeguequi idillujirumo ñɨhicuguehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jaamoro ijɨɨbogomɨnaa jenaaucasihicauhi cajaanɨ fɨne diitotɨ imiyaabotɨ iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jaanoco Jesu gaajacɨuhi diito tollɨ eesamaaiunoco. Jaaboro seemeneque ɨɨcɨuboro iicojɨvɨ ficuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jaaboro diitoco nuubo: Taafeenedɨ jiisee seemeneque agaayɨcɨmo, uco gaayɨcɨhi. Jaamo uco agaayɨcɨmo, tollɨro gaayɨcɨhi uco agalluuboco. Jaanotɨ paryɨ amɨɨhaifeenetɨ sihidɨ ejeevatɨɨbo, diibo janaanɨcɨ jeevahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jaanegui Jua Jesuco nuuhi: Mojɨɨbogomɨnaafi, mɨɨhai mahatyɨmehi saafiico dimomofañodɨ ɨjɨco agañɨɨboco. Jaaruuboco mɨhɨɨbahi mɨɨhaima ɨɨgotɨneguiiha, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jaanegui Jesu diiboco nuuhi: Mɨhɨɨbajirahana. Momɨnaafi iicatɨɨbo mojaagodɨ iicaabo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesu niquejefaño ufuucuujino ifiitɨcuudɨ quehecuno iminifutuuboro Jerusalejaagovɨ fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jaaboro ihɨmega jɨɨbogomɨnaaco galluubo. Jaamo fuuhi Samaria jiinɨjeo cuumijaago diibo ɨmega ɨɨfetejimañoco iimibachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jaarunaa samaritanomɨ imuguutɨhi diiboco toonovɨ agaayɨcɨuno Jerusalevɨ ufuunoco agaajaumoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jaanoco Jacoobo, bu Jua icamɨsi aatyɨmeumɨsiro Jesuco nuuhi: Aivojɨɨbo, ¿diimeguehi niquejefañotɨ diitohallɨvɨ cɨɨjɨgaico magalluunoco diitoco ifinɨsuqui? noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jaarunaa Jesu diitɨsico emeecɨuboro diitɨsico ɨɨbauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jaadɨ fuumo siicuumijaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jaamo jɨɨhairi fuunaa saafi Jesuco nuuhi: Aivojɨɨbo, ɨɨma feejirahi fahɨgova ɨɨjoho ofoohɨgo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jaanegui Jesu diiboco iimusuuhi: Bajɨhimɨ ihojɨnoma icahi, tollɨro joomɨ ihiicunoma icahi. Jaanotɨ uujoho Miyamɨnaafibadɨ Ifiivuubo tañigaɨco conoovɨ ɨsɨucarujirumaño chahahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jaadɨ Jesu saafiico nuuhi: Tadyojɨcutɨ disaa, nooboro. Jaarunaa diibo nuuhi: Jaafahiica itɨconɨ guihirubi iguijevedɨhivɨ ɨcɨɨdɨhiica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jaanegui Jesu diiboco nuuhi: Jaafa tahɨ diito ifinɨjitɨno fiivoma iicatɨmo iguijevemeque cɨɨji. Jaanotɨ ɨɨjoho difoo. Jaaboro Moocaani aivojɨ jɨɨbogoco dɨɨbogo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jaanaa bu sifi nuuhi: Aivojɨɨbo, ɨɨma feejirahi. Jaafahi itɨconɨ taajamɨnaaco fitacuvahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jaarunaa Jesu diiboco nuuhi: Mɨɨjoho siinojaa ofoomo dojɨcujaagoco esamaaitatɨhi imijitɨruno Moocaani aivojɨdi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jaanobuunatɨ tollɨro siino Aivojɨɨbo Jesu ɨcɨuhi setentadɨmoco. Jaaboro ihɨmega galluubo miimɨsiicɨ saaje faacuumivari diibo ufuujihɨguehejedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jillɨ nooboro: Miyaano sihidɨro basuta onoovano naamucuuhi. Jaarunaa toono dudɨcamaajemɨnaa ajashuhi. Jaabadɨro sihidɨ miyamɨnaa teemehi Moocaanico agaayɨcɨjinoco. Jaanegui Moocaanico midillu, dudɨcamaajemɨnaaco igalluuqui diitojaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jaanegui amɨɨhai mofoo; Mehesɨcɨnɨ, amɨɨhaico galluuhi oveja seeme jɨcumɨfeenedɨ ofoonɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lleegucubaco masatyedino. Nɨhɨbamɨbaco, tɨhaipaaje siipaajebaco masatyedino. Mɨɨhaiñoobaco jɨɨhaivɨ midillumo mehecafetedino. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Itɨconɨ majaahevejaotoco midillu, jillɨ: Sajeebɨɨ mihica jiijaaoto, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jaajaoto sajeebɨɨma iicafimo iicahachiijɨ: Amɨɨhai sajeebɨɨ, noomoro midilluno diitoma icaji. Jaanotɨ achahahachiijɨ amɨɨhaijaagovɨro uumijino. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Saajafañoro mihicamoro mamachu, mahadu icano diito amɨɨhaico aacɨnehejeque. Jillɨ dudɨcamaajemɨnaafi ijaadaco gaayɨcɨfihi. Iijaneri siijatɨ, siijatɨ icano mefeedino. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cuucuumivɨhacho amɨɨhaico imino agaayɨcɨmañovɨ mihicamoro mamachu amɨɨhaico aacɨnehejeque. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jaamañeri iicamo iguihuvamoco mubuheesu. Jaamoro monoo: Moocaani aivojɨ amɨɨhaitɨ fiitɨcuuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jaanotɨ cuucuumivɨhacho mɨhɨfotomoco agaayɨcɨtɨmañovɨ jahisi mihiinomoro monoo: ");
INSERT INTO bmrNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Amɨɨhai cuumio jiinɨ motɨhaipaajeguiino ɨjɨvonoco matatacuhi amɨɨhai mihimitɨmo jɨɨbogobadɨ icano. Jaarunaa magaaja Moocaani aivojɨ amɨɨhaitɨ ifiitɨcurunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Amɨɨhaico neehi: Moocaani niinoono ajaadufucu iicasumi, tuucuumi janaanɨcɨ ɨdaasuno iicaji Sodoma cuumioto iicajino janaanɨcɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Ɨdaasucaniji ɨɨjoho Corazin cuumi! ¡Ɨdaasucaniji ɨɨjoho Betsaida cuumi! icano. Ɨɨvɨ iicabadɨ aatyɨmeratatɨnoco Tiro cuumivɨ, Sidon cuumivɨ icano moonɨruva sɨɨcɨje iimitɨ ifiico ejeevesumoro, ɨɨfusujirumo ɨdaasuvono gaachehuco ɨjɨcamaaimoro, baiguiijɨri ejeemere icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jaanotɨ amɨɨhai, Moocaani niinoono ajaadufucu, janaanɨcɨ ɨdaasuno iimitɨnoco magaayɨcɨji Tiro, Sidon icaucuumijeoto janaanɨcɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jaanotɨ ɨɨjoho Capernau cuumi: Fɨne uujoho niquejefaño gañiiyɨcɨcafeteji, neehi. Jaarunaa guiinovɨro gañɨɨcafeteji guijevemɨnaa iicahɨgo, nooboro ijɨɨbogomɨnaaco nuubo: ");
INSERT INTO bmrNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Amɨɨhaico uguubumo, uco guubuhi. Jaanotɨ amɨɨhaico agaayɨcɨtɨmo, uco gaayɨcɨtɨhi. Uco agaayɨcɨtɨmo tollɨro uco agalluuboco gaayɨcɨtɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jaamo setentadɨmo ufuumo imo imo uumiuhi noomoro: Aivojɨɨbo iimitɨno ɨjɨmɨ icarumomaryo mɨɨhaico mityagomo dimomofeenedɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jaanegui Jesu diitoco nuuhi: Jɨɨhɨ, ɨɨfɨnɨcɨnaaca Satanas niquejefañotɨ aquetehi sisi anamebanɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Uujoho amɨɨhaico mityaco acɨhi jiinimomɨ, juuvemɨ icamohallɨvɨ miquicuqui. Tollɨro paryɨ ɨjɨ mityaco miguiinonɨqui jaarumo mɨllɨ icatɨmo mihicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jaaruneri imo imo mihicadino. Ɨdɨɨnoro amɨɨhai momo niquejefaño iicacuuneri imo imo mihica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jaasumiro Jesu sihidɨ imo imo minifutuuhi Moocaani Gaijari. Jaaboro Moocaanico nuubo: Guihi, imino ɨɨjoho niqueje Aivojɨɨbo, jiinɨjeo Aivojɨɨbo idiicaabo. Jinooco agaajafiimotɨ, eesɨcɨnɨmotɨ icano afatanɨɨboro seemebadɨ iicamoco dɨhɨfusuhi. Jɨɨhɨ Guihi, ɨɨjoho tollɨ idiimogobadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Guihirubi uco paryɨ fanoovaco acɨhi. Mɨɨjoho gaajatɨhi Illico. Ɨdɨɨboro Caani gaajahi. Jaabadɨro mɨɨjoho gaajatɨhi Caanico. Ɨdɨɨboro Illi gaajahi. Jaaboco Illi miyamɨnaaco gaajasujirahi, ");
INSERT INTO bmrNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","nooboro ijɨɨbogomɨnaaco emeecɨuboro diitocoro nuubo: Imicani icamo amɨɨhai mahatyɨmeneque aatyɨmeme. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Amɨɨhaico neehi: Ajashutɨmo Moocaani iimaamɨnaa, bu aivojɨto icamo atyɨmeguehicauhi jino amɨɨhai mahatyɨmeneque. Jaarumo atyɨmeutɨhi. Guubuguehicaumo jino amɨɨhai muguubunoco. Jaarunoco guubuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jaanaaca saafi Moise tajɨɨba jɨɨbogomɨnaafi agañiivuuboro fuuhi Jesuma ihiimaatuubo. Jaabo ɨɨfuruubo diiboco ɨnɨsuubo dilluuhi: Jɨɨbogomɨnaafi, ¿mɨllɨ fɨne moonɨjirahi ifinɨjitɨno fiivoma icaqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jaanaaca Jesu nuuhi: ¿Mɨllɨ naa nacu Moise tajɨɨbaco caatɨnɨuhi? ¿Mɨllɨ nacu meecɨhicahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jaanegui diibo iimusuuhi: Aivojɨɨbo Moocaanico gaijɨ paryɨ diifiima, dijeebɨɨma, disefama, dihesamaajema icano: Tollɨro gaijɨ difiitɨno iicamoco difibadɨro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jaanegui Jesu diiboco nuuhi: Jɨɨhɨ, imino neehi tollɨ omoonɨhachiijɨ ifinɨjitɨno fiivoma diicaji, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jaarunaa diibo, Jesuco idilluunoco agaihuɨɨnɨuboro siino nuubo: ¿Mɨɨjoho nacu tafiitɨno iicamo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jaanegui Jesu oovɨcɨɨboro nuuhi: Safoono saafi miyamɨnaafi fuuhi Jerusaletɨ Jericojaago ofoocɨnɨjɨri. Jaaboco nanivamɨnaa ahaamɨumoro inehejeque ɨcɨumo paryɨ igaachehunoma. Jaamoro niinovacuuboco ejeevesuumoro fuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jaanaaca saafi sacerdotemɨoobo toojɨri saauhi. Jaaruubo tehesinotɨro emeecɨuboro fatyuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jaanobuunatɨ tollɨro levimɨoobo toojɨri saauhi. Jaaboco tollɨro tehesinotɨro emeecɨuboro fatyuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Jaanaa tollɨro Samaria jiinɨjeoobo toojɨri ufuubo diiboco emeecɨuboro ɨdaasuvuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jaaboro diibojaa ufuuboro itujaavonoco taabuubo dɨɨrɨbari, vinofaihuri icano. Jaaboro toonoco isisɨuboro iburrohallɨvɨ ificuuboro satyuubo ɨcɨgatonɨcɨjafaño. Jaaboro diiboco toojafaño tuumuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jaano seseevedɨ isamaritano ufuucuudɨ toojaooboco acɨubo mijeecɨ nɨhɨbajeecɨco. Jaaboro diiboco nuubo: Imino jaanɨco toomo. Janaanɨcɨ dinɨhɨbamɨco diibohallɨvɨ agañɨɨhachiijɨ uujoho ɨco jaaduji siino asaadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jillɨ oovɨcɨɨboro Jesu Moise tajɨɨba jɨɨbogomɨnaafico dilluuhi: ¿Nanivamɨnaafi ahaamɨuboco diitotɨ cajaanɨ fɨne ɨɨdi ifiitɨnomɨnaafi iicanɨcɨbadɨ aamusuubo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jaanegui nuubo: Etɨ bu diiboco ɨɨdaasuguubo, nooboro. Jaanegui Jesu diiboco nuuhi: Foobo ɨɨjoho tollɨro dɨdaasugo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jaabo Jesu efeehicaubo saacuumivɨ ɨfutuuhi. Jaaboco Marta onoogo iijafaño gaayɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jaago Marta inagoma icauhi Maria onoogoma. Jaago Maria Jesuguiino acasɨɨvuugoro guubunɨcɨhicaugo Jesu onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jaarunaa Marta sihidɨ sinehejeque omoonɨnehejeriro icahicauhi. Jaagoro Jesujaago asaaugoro diiboco nuuhi: Aivojɨɨbo, ¿nacu daatyɨmetɨhi uuro dudɨcamaainaaca tañago tɨcovono iicanoco? Tajɨɨba diigoco uco ihamusuqui, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jaarunaa Jesu diigoco nuuhi: Marta, Marta, sineheje dudɨcamaajejaagovɨro idiicamaño dijeebɨɨ ɨco mɨtahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jaarunaa icano sanooro imiyaano. Jaanoco Maria imiyaanoco gaayɨcɨhi mɨɨjoho diigotɨ udumɨtɨɨcɨjitɨnoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Safoono Jesu Moocaanima iimaauhi samañovɨ. Jaanoco iimivuudɨ saafi ijɨɨbogomɨnaafi nuuhi: Aivojɨɨbo, mɨɨhaico dɨɨbogo Moocaanima mihiimaaqui Jua ijɨɨbogomɨnaaco ɨjɨɨbuguubadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jaanegui Jesu nuuhi: Moocaanima mihiimaajisumi jillɨ meneehica: Moocaani niquejefaño idiicaabo, jaafa dimomo imino ijeevadɨ ficucafetehi. Jaafa dihaivojɨ saahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mɨɨhaico daacɨ machutaatɨ fafucuvaacɨvɨro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jaaboro mɨɨhaico mohimitɨco buusu, oono bu mɨɨhai, mɨɨhaico imitɨno omoonɨmoco toonoco mihimibachubadɨ. Jaaboro mɨɨhaico ɨjɨ ɨnɨsunofaño gañɨɨsudino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jaaboro ijɨɨbogomɨnaaco nuubo: Jillɨ mohoovɨcɨqui; Amɨɨhaitɨ saafi inahabonɨmɨnaafima icahi: Jaabo fucufeenevɨ iijajaa ofooboro neetehi: Tañahabo uco daacɨ mihɨcacɨ, sahɨca icano maahunotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Saafi tañahabo sihɨgotɨ gasehi taajajaago. Jaaruuboco aacɨjiruno achahaneguiiha, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jaanoco diibova jillɨ iimusuuhi fañoojatɨ: Llɨɨvɨ diica; cuhufono guhuga fabaacɨnɨhi, taseemema mɨcɨgacuuhi. ¿Mɨllɨ bu ɨco agañiivooboro acɨjirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jaanegui amɨɨhaico neehi: Inahabo iicaneguiiha agañiivonoco imogotɨruubo. Jaaruubo jillɨ agañiivooboro paryɨ idilluunoco diiboco acɨjiibo siino dillutɨɨbo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jaanegui amɨɨhaico neehi: Midilluhachiijɨ amɨɨhaico Moocaani acɨji. Bu tollɨro miguiinohachiijɨ mahatyɨmeji. Bu iguhugatɨ mocoova amɨɨhaico ifaayɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Idilluubo gaayɨcɨfihi. Bu tollɨro iguiinoobo atyɨmefihi. Jaabadɨro guhugatɨ ocoovaaboco faayɨcɨfiimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Nacu cajaatyo, caani iseemene maahuco idillusumi fɨne guiisibaco acɨjirahi? ¿Nacu bu taavaaboco idillusumi fɨne jiinimoco acɨjirahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Nacu bu iiyɨnoco idillusumi fɨne juuvehuco acɨjiruubo? ");
INSERT INTO bmrNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jaamo amɨɨhai mihimitɨrumo, iiminoco amɨɨhai seemeque mahacɨjirahi. Jaanegui Moocaani niquejefaño iicaabo Igaijaco acɨji diiboco idillumoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Safoono Jesu iimitɨno ɨjɨco gañɨɨuhi saafi miyamɨnaafico iimaasutɨɨbo iicauboco. Jaabo ihɨjɨ ihiinuunobuunatɨ imiyamɨnaafi iimaacuuhi. Jaaneri sihidɨ miyamɨnaa jabafiituuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Jaarunaa saatoho nuuhi: Jaanɨ iimitɨno ɨjɨmɨco gavaracuhicahi, ɨjɨmɨ aivojɨɨbo Beelzebu onoobo mityari, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jaanotɨ saatoho Jesuco ɨnɨsumo dilluhicauhi sihidɨ ejeevano niquejeonoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jaarunaa diito esamaajeque agaajacɨuboro diitoco nuuhi: Saafi aivojɨɨbo miyamɨnaa ijeevadɨ saaje udugaacamaaimoro sanomɨro imonɨcasiruva diibo aivojɨ finɨjirahi. Tollɨro saajaaoto sanomɨro igaicaaucasiruva finɨjirumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sabadɨro Satanas iyotomaryo imoonɨcasiruva, ¿mɨllɨ bu imitya gueenene icajirahi? Jillɨ neehi, ɨjɨmɨ aivojɨɨbo Beelzebu mityari buhɨ uujoho ɨjɨmɨco agañɨɨno uco meneeneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jaanegui uujoho Beelzebu mityari agañɨɨhachiijɨ, ¿nacu mɨɨjoho mityari amɨɨhai jɨɨbogomɨnaa ɨjɨmɨco buhɨ gañɨɨhicahi? Jaamaño diito amɨɨhaico gaajasuhi amɨɨhai sɨcamañooco mihiimaanoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Uujoho ɨdɨɨboro Moocaani mityari ɨjɨmɨco buhɨ gañɨɨhicahi. Jaanotɨ magaaja amɨɨhaivɨ Moocaani aivojɨ agasecuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Saafi miyamɨnaa sefano añɨjɨnoma iijaco otoomoobo iicasumi ineheje imino icahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Jaarunaa sifi janaanɨcɨ esefaabo asaaboro diiboco iguiinonɨɨboro ihañɨjɨɨnoco dumɨtɨɨcɨhi toonovɨ equehecutehicanoco. Jaadɨ inehejeque ɨɨcɨɨboro sitaama ɨfehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jaabadɨ tajaagodɨ iicatɨɨbo tamɨnaafi, bu tajaagovɨ iigaiyɨɨcɨtɨɨbo jillɨro fahɨgovavɨ gavaracusuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Iimitɨno ɨjɨ miyamɨnaafitɨ ihiinoobo foonɨcɨhi, ifiigaimañehejedɨ ijaguisɨqui guiinooboro. Jaaruubo aatyɨmecuutɨsumi esamaaihinɨcɨɨbo: Dojɨcuvɨro uumiji taajajaago toojatɨ asaahinɨhɨgovɨ, noobo. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jaabo siino uhuumiibo atyɨmehi miyamɨnaafi jeebɨɨco iija imino imibachucɨnɨja imino iguijaacɨnɨbadɨ icaaboco. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jaanegui ofoobo siino ɨcɨtefiibo sahuse juugahusetɨ miimɨsiicɨ ɨdɨɨno aivo diibo janaanɨcɨ iimitɨno ɨjɨmɨco. Jaamo paryɨ imiyamɨnaafi jeebɨɨfaño ɨjɨcafotomoro icafihi. Jaaneri imiyamɨnaafi itɨconɨ imitɨno iicauno janaanɨcɨ aivo imitɨno minifetefihi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jillɨ Jesu nuunaaca saafigo gaigo miyamɨnaafeenetɨ sefano nuuhi: ¡Imicani icago ɨco eseemevaugoro ɨco ifiivusuugo! noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jaaneguiiha Jesu nuuhi: ¡Imi janaanɨcɨ imino Moocaani onoonoco uguubumoro omoonɨmo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jaanaa sihidɨ Jesujaago miyamɨnaa igaivomoro saahicauhi. Jaanegui tɨconɨubo ihiimaabo. Jisumio miyamɨnaa aivo imitɨhi. Jaamoro dillumo sihidɨ ejeevano ɨɨfusuco. Jaaruno ɨɨfusurajitɨhi; ɨdɨɨnoro Moocaani iimaamɨnaafi Jonas ɨɨfusuta iicaubadɨreji. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jaabo Jonas Ninive cuumi miyamɨnaadi ɨɨfusubadɨ iicaubadɨ tollɨro uujoho Miyamɨnaafibadɨ Ifiivuubo jisumio miyamɨnaadi ɨɨfusubadɨ icaji. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ufucu Moocaani, niinoono ajaadufucu jisumio miyamɨnaaco Saba onoocuumi jiinɨjeo aivojɨgo agañiivogoro diitoco janaanɨcɨ guiinonɨji, diigo aivo tehesirunotɨ Salomon gaajaco iguubuqui asaaumaño. Jaarunaa jino amɨɨhaifeeneri Salomon janaanɨcɨ uujoho iicaabo icahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jaabadɨro Ninive cuumimɨnaa niino jaadufucu agañiivomoro jisumio miyamɨnaaco guiinonɨji. Mɨɨro Ninive cuumimɨnaa imitɨco jeevesuuhi Jonas diitoco Moocaani unuunoco ɨjɨɨbuguusumi. Jaabadɨro jino Jonas janaanɨcɨ uujoho iicaabo jino amɨɨhaifeeneri icahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","¿Mɨɨjoho cɨɨjɨgai mecuco ɨnɨfutusumoro otoovohɨgo ficutatɨhi, guirihilluguiino? Caamo mificutahi fañoojavɨ ɨjɨcafotomo iseseeque ihatyɨmequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mɨɨro saafi ihaallɨɨ iimitɨɨbo imino icajitɨrahi. Jaabadɨro saafi ijeebɨɨ iimitɨɨbo imihusetɨhi. Jaabo imitɨnoguiino icaji. Jaanotɨ Moocaani ijeebɨɨco iimibachuhachiijɨ imihusetejiibo. Moocaani iimogobadɨ icacujiibo. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jaanegui deesɨcɨnɨ: Uujoho imihuseebe, unuuruno dijeebɨɨfaño iimitɨno icadino. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jaanotɨ paryɨ dififaño imino, imitɨno aivo achahahachiijɨ, paryɨ difi imino ɨɨfuvusujino cɨɨjɨgaimecu ɨco ifoovori aachɨcɨnɨbadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jaabo Jesu ihiimaaunoco iimivuudɨ, saafi fariseomɨoobo Jesuco coovauhi iijajaago imachutequi. Jaanegui Jesu ufuuboro casɨɨvuuhi imachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jaarunaa ifariseomɨoobo jabafiituuhi Jesu diito tajɨɨba onoobadɨ ihuseque nitamaaitɨɨbo amachuunotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jaarunaa Aivojɨɨbo Jesu nuuhi: Amɨɨhai fariseomɨ minitɨhi guirihilluno, butajene icano allɨcoro. Jaanotɨ amɨɨhai, amɨɨhai jeebɨɨfaño gahafɨcɨnɨhi imitɨno momoonɨmoro mananivahicanehejeri. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Gaajatɨcanimo! ¿Jana nacu magaajatɨhi allɨonoco eheetavuubo tollɨro fañoonoco eheetavuunoco? ");
INSERT INTO bmrNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jaanegui amɨɨhai jeebɨɨfaño iicanotɨ ɨɨdaasufiimedi mahacɨ. Jaadɨ jari paryɨ amɨɨhai ifi imiteji. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Ɨdaasucaniji amɨɨhai fariseomɨ mihicano! Amɨɨhai Moocaanidi fahuseecɨtɨ sahaame mahacɨhi menta aametɨ, ruda aametɨ, paryɨ basuta mamachufinehejetɨ icano. Jaarumo sitaaco imino momoonɨtɨhi Moocaanico magaijɨtɨhi. Jinooco jeevesutɨmo fanoocɨcoro momoonɨjirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ɨdaasucaniji amɨɨhai fariseomɨ mihicano! Sinagogajafaño mufuusumi imiyaano icaganocoro mihimoyɨɨcɨfihi. Tollɨro jɨɨhaiñofaño imino amɨɨhaico idillunoco mihimoyɨɨcɨfimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ɨdaasucaniji amɨɨhai caatɨnɨmɨnaa, fariseomɨ icamo: Mojeebɨɨ imihi, noomoro sitaaco mabañɨfiimo! Cɨɨhojɨ toovono iicahojɨbadɨ mihicamo. Jaahojɨhallɨdɨ miyamɨnaa toojɨco gaajatɨmo toojɨhallɨdɨ ɨɨgonɨcɨbadɨ mihicamo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jaanegui caatɨnɨmɨnaatɨ saafi iimusuuhi: Jɨɨbogomɨnaafi, mɨɨhaico eneejiruno tollɨ neehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jaaneguiiha Jesu nuuhi: ¡Ɨdaasucani amɨɨhai caatɨnɨmɨnaa mihicaji! Amɨɨhai sitaaco bocɨnoco mifiisesuhicahi mɨɨhaiñooba ajaabɨcɨtɨnoco. Jaamoro amɨɨhai jillɨ usegai sagaibari mududɨɨcɨhicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ɨdaasucaniji amɨɨhai mihicaji! Moocaani iimaamɨnaa cɨɨhojɨnohallɨco mɨsumesumoro mihimibachunoco meheetavehicahi amɨɨhai eedeetemɨhairyo agaicaaumo cɨɨhojɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jaamo tollɨ momoonɨmo amɨɨhaihallɨvɨro mɨjɨɨbeguehi amɨɨhai eedeetemɨhai omoonɨunofañodɨ mihicanoco; Mɨɨro diito gaicaauhi. Jaamo cɨɨhojɨnoco amɨɨhai meheetavehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jaanegui Moocaani igaajafeenedɨ neehi: Galluuji Moocaani iimaamɨnaa, Moocaani minɨsumɨnaa icamoco. Jaamotɨ saatohoco gaicaaujimo, saatohoco ɨdaasuno moonɨjimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jaamo jisumio miyamɨnaaco Moocaani ihiimaamɨnaa tɨɨjoho jaadaco ɨcɨji jiinɨje ifiivuunotɨ jisumivɨ iicaumoco diito agaisiraicɨumo tɨɨjoho jaadaco, ");
INSERT INTO bmrNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel tɨɨjohotɨ itɨconɨɨbo Zacariaco Moocaani iijafaño, Moocaanico ijeecɨvequi asimɨco agaicaaufimañotɨ iimimecu situvɨ agaicaaubo tɨɨjohovɨ nijequeenɨjiibo. Jaanegui amɨɨhaico neehi: Jisumio miyamɨnaaco Moocaani ihiimaamɨnaaco agaisiraicɨumo jaadaco ɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ɨdaasucani amɨɨhai mihicaji caatɨnɨmɨnaa! Tuhugari ofoomoro agaajajiruno llaveque mafaatanɨmoro mɨjɨcafototɨhi, bu ɨjɨcafetejirumoco mɨjɨcafutusutɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jillɨ Jesu diitoco unuunoma iicamo fariseomɨ, caatɨnɨmɨnaa icamo sihidɨ diibojaa ɨsɨfiiratuumoro tɨcovauhi fanoovaco idillumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ɨɨfurumo diiboco siibadɨ onoonohallɨtɨ aivojɨto ɨmega diibohallɨvɨ imitɨno ijɨɨbeguequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jaanaaca aivo sihidɨ miyamɨnaa iigaivuumo ijene quicucasihicauhi. Jaanaa Jesu itɨconɨ ijɨɨbogomɨnaaco nuuhi: Mehesɨcɨnɨ fariseomɨ juurisutaguiijɨ: Imihusehi, noomoro abañɨfinotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aivo chahano afatanɨcɨnɨno, atyɨmeratɨno iicano. Jaabadɨro chahano otoovono, gaajaratɨno iicano. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jaamaño amɨɨhai fucu cɨvohɨ munuuruno cuuje seseehɨgo guubuvusuji. Jaabadɨro toovono mecufaño guhugaco mafabaacumoro jaabañogayɨ mihiimaaruno, coovano noocafeteji iija nijequetɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Tañahabomɨ, amɨɨhaico neehi: Mihiguijirahana oono miyamɨnaa ifiico agaicaaufimoco. Jaarunobuunatɨ mɨllɨ mɨɨnoco moonɨcujitɨrumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jaanotɨ naha ɨdɨɨbocoro mihigui iguijenɨnobuunatɨ tollɨro ijeebɨɨco cɨɨjɨgaifaño agañɨɨjiruubo mityama iicaaboco. Diibocoro mihigui. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mɨɨro sahusedɨmo joomɨco mijeegayɨɨcɨriro manaajenɨcɨhi. Diito iicarumotɨ Moocaani jabajeevetɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mɨɨro paryɨ amɨɨhai nigaɨ ijeene paryɨ oovocɨnɨcuuhi sajehesari. Jaanegui mihiguijirahana, mɨɨro amɨɨhai sihidɨ joomɨ guiraarumo janaanɨcɨ magaijɨcafetehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Amɨɨhaico neehi: Miyamɨnaa ɨmefeenevɨ uco: Miyaabo, onoomoco, uujoho Miyamɨnaafibadɨ Ifiivuubo tollɨro Moocaani toomomɨnaa ɨmefeenevɨ: Miyaabo, neeji. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jaanotɨ uco utuunamaaimoco tollɨro uujoho Miyamɨnaafibadɨ Ifiivuubo tuunamaaiji Moocaani toomomɨnaa ɨmefeenevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tollɨro cajaatyohacho uujoho Miyamɨnaafibadɨ Ifiivuubeditɨ imitɨno ihiimaaruno diitoco buusucafetejirahi. Jaanotɨ Moocaani Gaijaditɨ imitɨno ihiimaamoco toono aivo buusurajitɨhi jiijehallɨvɨ, bu ufucu niquejevɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Amɨɨhaico sinagogajafaño fagomɨnaa aivojɨto icanojaago asatyusumi; ¿Mɨllɨ fɨne iimusuji? ¿Mɨllɨ fɨne neeji? noomoro gaihuɨba mihicadino. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tollɨ mihicasumi Moocaani Gaija jɨɨbegueji mɨllɨ mihiimusujinoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jaanaa saafi miyamɨnaafeenetɨ Jesuco nuuhi: Jɨɨbogomɨnaafi, tañahaboco dinoo guihirubihɨɨvɨ nehejetɨ uco feenedɨ ihacɨqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jaarunaa Jesu diiboco nuuhi: ¿Nacu mɨɨjoho uco amɨɨhaihallɨvɨ ficuuhi fagomɨnaatɨ nɨhɨbamɨ dugaacumɨnaafitɨ? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Siino nuubo: Amɨɨhai ifiico magaihuɨnɨ. Jaamoro sihidɨ sinehejeque mihimoyɨɨcɨdino; Miyamɨnaafi ifi sihidɨ sinehejema iicanotɨ saatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Diitoco jillɨ oovɨcɨubo: Icaubo saafi sihidɨ sinehejema iicaubo. Jaabo ijiinɨjeque abasuuno sihidɨ noovauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jaanoco aatyɨmeuboro esamaaiubo: ¿Mɨllɨ fɨne moonɨji? Chahano aivo tabasuta noovaco ificujiruno, ");
INSERT INTO bmrNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","nooboro esamaaihicaubo. Jaadɨ nuubo: Gaajacuuhi omoonɨjinoco. Tamachutanoco ificuhicajaanoco agavaracuuboro siino coojano eetaveji. Jaaboro tojaajefaño paryɨ tabasuta noovataco ficuji paryɨ tañeheje icanoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jaaboro tajeebɨɨco neeji: Tajeebɨɨ, sihidɨ sinehejema diicahi ajashutɨno ficabano tɨcovovɨ. Jaanegui daguisɨ, machu, daadu. Jaanoro imo imo diica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Jaarunaa diiboco Moocaani nuuhi: Ɨɨjoho agaajatɨno miyamɨnaafi, jaachiijɨo fucuro guijeveji. Jaanobuuna, ¿mɨɨdiji fɨne toono paryɨ ificuuno? nuubo Moocaani. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jillɨ icafiibo miyamɨnaafi sihidɨ sinehejeque ifiguiiharo ititibanɨɨbo. Jaaruubo Moocaani ɨmefeenevɨ ɨdaasuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jaadɨ Jesu ijɨɨbogomɨnaaco nuuhi: Amɨɨhaico neehi, gaihuɨba mihicadino: ¿Jinejeque mamachuji, guijevetɨmo mihicaqui? ¿Jinejeque mɨjɨcafeteji? noomoro gaachehutɨ mehesamaaidino. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mofi machuta, gaachehu icano janaanɨcɨ jaaducafetehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Memeecɨ uuhimɨco abasumoro ɨcɨtatɨrumo imachuta iijanoma chaharumo. Jaarumoco Moocaani machutaaco acɨfihi. Jaamo diito joomɨ janaanɨcɨvɨ amɨɨhai majaaducafetehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Nacu cajaatyo fɨne gaihuɨba iicaneri ifiico janaanɨcɨ medio metro tɨcovovɨ caamuvutusujirahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jino tɨhɨɨtɨruunoco momoonɨjitɨrumo. ¿Collɨhi sinehejeque mehesamaaimoro gaihuɨba mihicahicahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Eneecau oono deecanoco mɨhɨɨfɨnɨcɨ, dudɨcamaaitɨruno jaadihunoco eetavotɨruno imino ujusinoco. Jaanotɨ aivojɨɨbo Salomon aivo sihidɨ jeevano iminoonoma icauruubo toono deecanobadɨ jeevautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jaabo Moocaani ñaavahu icarunoco imino gaachehuco mɨjɨɨhacubadɨ omoonɨɨbo safucu jahisi icano sifucu cɨɨjɨgaifaño mɨjɨgasufirunoco. Jaanegui amɨɨhai miyamɨnaa ajashuno mimiyaavogomo, ¿collɨhi mimiyaavogotɨhɨ? Jaabo ñaavahu janaanɨcɨ amɨɨhaico imino jɨcujiibo? ");
INSERT INTO bmrNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jaanegui ¿jinejeque mamachuji? ¿Jinejeque mahaduji? noomoro gaihuɨba mihicadino. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mɨɨro imiyaavogotɨmo ɨdɨɨnoro jiinɨjeonehejequere guiinefiihi. Jaanotɨ amɨɨhai Caani niquejefaño iicaabo. Jaabo gaajacuuhi amɨɨhai paryɨ tonehejeri mucuujɨvaachunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jaanegui itɨconɨ Moocaani aivojɨco miguiino. Jaadɨ jari paryɨ tonehejeque bu magaayɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mihiguijirahana amɨɨhai agaijɨmo amɨɨhai mahajashurahi. Jaarumoco Moocaani ihaivojɨco aacɨnoco imeguehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Amɨɨhai nehejeque manaajemere ɨɨdaasumoco mahacɨ; jillɨ meheetavo unuucujitɨno lleegucuco niquejefaño ifinɨjitɨnonehejeque mificu tahɨ nanivamɨnaa achahahɨgo amɨɨhai nehejeque deeɨra ifinɨsutɨhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mɨɨro amɨɨhai busumijeene iicahɨgovɨ tollɨro amɨɨhai jeebɨɨ icajirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Mihimibaivomoro mihica amɨɨhai cɨɨjɨgai mecunoco mɨnɨfutusumoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ihaivojɨɨbo ataabatoobo agaseebeque iguhugatɨ ocoovasumiro ifaayɨcɨqui iicojɨmɨnaafi otoomonɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Imicani icajimo ihaivojɨɨbo jeecɨvomɨnaa diiboco toomomovɨ agasesumi. Miyanotɨro amɨɨhaico neehi: Ihaivojɨɨboro iimibaivooboro diitoco casɨɨhacuji, jaaboro imachutaaco diitoma ɨɨfejiibo imachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jaamovɨ diibo fucufeenevɨ, cuujetavɨ icano toomomovɨ agasehachiijɨ imicani icajimo tollɨ iicano jeecɨvomɨnaa. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jinooco magaaja iija abajaabo tusumi nanivamɨnaafi asaanoco igaajaruva cɨgatɨɨbo teemejiruubo. Jaaboro iijaco faayɨcɨsujitɨruubo diibo nehejeque nanitɨɨbo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jaaneguiiha amɨɨhai mihimibaivomoro motoomo mehesɨcɨnɨtɨnaaca uujoho Miyamɨnaafibadɨ Ifiivuubo siino saaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jaanegui diiboco Pedro dilluuhi: ¿Aivojɨɨbo, jino odoovɨcɨno mɨɨhaidiro nacu fameediro? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jaanegui Aivojɨɨbo nuuhi: Cajaanɨhacho ihaivojɨɨbo cojɨmɨnaafi imino iicaabo agaajaaboco iijamɨnaaco otoomooboro machutaaco ihacɨqui ificuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Imicani icajiibo ihaivojɨɨbo agasesumi imino moonɨɨboco aatyɨmevasumi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Miyanotɨro amɨɨhaico neehi: Diiboco ihaivojɨɨbo paryɨ inehejehallɨvɨ aivojɨɨbotɨ ficuji. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jaanotɨ imitɨno ijeebɨɨfaño esamaaiboro: Fɨne tahaivojɨɨbo goovajitɨno agasene, nooboro saatoho ihaivojɨɨbo jeecɨvomɨnaaco ɨdaasuno omoonɨɨboro, tɨcovono amachuuboro, aaduuboro iguiriicavoobo. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jaanaa diibo gaajatɨnaaca cufucuhacho ihaivojɨɨbo gaseji. Jaaboro diiboco sihidɨro ahaamɨɨboro ficujiibo saatoho iimitɨmoco omoonɨbadɨ iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jaanotɨ ihaivojɨɨbo atajɨɨbanoco gaajacuruubo iimibaivooboro omoonɨtɨɨbo sihidɨro aamɨcafeteji guiraano. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jaanotɨ saafi gaajatɨɨbo imitɨnoco omoonɨhachiijɨ mɨɨdɨno aamɨcafeteji. Mɨɨro Moocaanitɨ guiraano agaayɨcɨhinɨɨboco, bu guiraajino idilluno. Jaabadɨro guiraano ificusuuboco, bu guiraajino idilluno. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Uujoho saauhi jiinɨjehallɨvɨ cɨɨjɨgaico ɨnɨfutusuvaabo; ¡Imeguehi jisumiro ɨjɨgacuunoco! ");
INSERT INTO bmrNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nitɨsubadɨ ɨdaasufañodɨhiica nɨsucafeteji. ¡Guiraacani ɨdaasuno icahi toono afatyotɨnohachuta! ");
INSERT INTO bmrNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Nacu fɨne amɨɨhai uco: Jiinɨjehallɨvɨ sajeebɨɨ icaco sɨvaabo, noomoro mehesɨcɨnɨhi? Jaarunaa amɨɨhaico: Chahano, neehi. Jillɨ uujoho miyamɨnaaco dugaacusuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jaamaño jisumitɨro sahusedɨmo sajaaoto iicamo dugaaveji miimɨsiicɨ, saafi icamo miimɨsiicɨhallɨvɨ; bu miimɨsiicɨ, dugaaveji miimɨsiicɨ, saafi icamohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Caani illima moonɨcasiji, bu illi caanima moonɨcasiji icano. Tollɨro seejɨ illehallɨvɨ, bu ille seejɨhallɨvɨ icano, tollɨro iiyaaja ibaabohallɨvɨ, bu ibaabohallɨvɨ iiyaaja dugaaveji icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tollɨro bu Jesu miyamɨnaaco nuuhi: Jimañovɨ Jerusalevɨ oestejaagotɨ niijaba asaasumi mahaigueji meneefihi. Jaabadɨ icafiino. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jaanotɨ surjaagotɨ guibuhuba asaasumi ficabavajino monoonɨcɨhi. Jaabadɨ icafiino. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Bañɨfiiramɨnaa! Niquejeguiino iicanoco, jiinɨjehallɨvɨ iicanoco icano magaajarumo. ¿Collɨhiica magaajatɨhi amɨɨhai mihicanoco? ");
INSERT INTO bmrNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Collɨhiica amɨɨhairyo mihimibachutɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Saafi ɨɨjoho ɨdɨɨhegueebe dihallɨvɨ aivojɨtoco ɨjɨɨbogotooboma ufuusumi jɨɨhaivɨ diiboma imino diimaa. Jaamɨsiro siino mihimitocasi ɨco dugaacumɨnaafijaa satyediibo. Jaabo dugaacumɨnaafi ɨco sisɨmɨnaafico acɨjirahi. Jaabo isisɨmɨnaafi ɨco cɨvojafaño jɨɨhacujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Jaanegui ɨco neehi: Tahɨgotɨ dihiinejitɨrahi niinojegayɨco adaadutɨnohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tusumi saatoho Jesujaa asaaumoro diiboco jɨɨbuguumo Pilato Galilea gaifiimɨco agaisiraicɨuboro Moocaanico ijeecɨvequi asimɨco agaisiraicɨumo tɨɨjohoma diito tɨɨjohoco acahɨɨsenɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jaanegui Jesu diitoco nuuhi: ¿Jito Galilea gaifiimɨ famoova janaanɨcɨ fɨne iimitɨmaño jillɨ icamo, noomoro fɨne mehesamaaihi? ");
INSERT INTO bmrNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Amɨɨhaico chahano neehi: Tollɨro amɨɨhai, amɨɨhai imitɨco mejeevesutɨhachiijɨ paryɨ mifinɨji. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Nacu fɨne amɨɨhai joono Siloe torrehacɨ dieciochodɨmohallɨvɨ Jerusalevɨ aacutuuneri iguijeveumotɨ: Fɨne tahɨ iicamo janaanɨcɨ imitɨmo, noomoro mehesamaaihi? ");
INSERT INTO bmrNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Amɨɨhaico chahano neehi: Tollɨro amɨɨhai, amɨɨhai imitɨco mejeevesutɨhachiijɨ paryɨ mifinɨji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jaaboro Jesu jillɨ ohoovɨcɨuboro nuuhi: Saafi miyamɨnaafi ibasutaho Higuerahoma icauhi. Jaahoco meecɨtuubo fɨne noovacuuho nooboro. Jaarunaa noovautɨho. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jaanegui ibasuta toomomɨnaafico nuubo: Meecɨ mificabacɨ, saficaba icano sanohallɨvɨ meecɨvahicarahi. Jaaruubo inoovaco atyɨmetatɨhi. Jaanegui, diillucu; ¿Collɨhi bu toonovɨ onoovatɨho icajirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jaarunaa toono toomomɨnaafi diiboco iimusuuhi: Aivojɨɨbo, jaafahi jificaba icaho; ijiinɨjeque seediibo tanusuji. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jaadɨ fɨne jari noovajiho. Jaanotɨ onoovacutɨhachiijɨ jei diillu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Safoono jaguisɨfucu Jesu sinagogajafaño jɨɨbeguehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jaanaa tahɨ icaugo saafigo gaigo dieciocho ficabano tɨcovovɨ iguihuvaugo, iimitɨno ɨjɨ omoonɨuneri iyoobai fañovɨro tejeeveuhi. Jaaneri sanotɨcovoro julleevecutɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jaagoco Jesu aatyɨmeuboro ocoovauboro nuuhi: Gaigo, diguihuvatɨ buheetecu, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ihuseneque diigohallɨvɨ ficuubo. Jaasumiro diigo sanotɨcovoro ujulleeveugoro tɨcovauhi Moocaanico iimogo. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jaarunaaca sinagogaja aivojɨɨbo Jesu jaguisɨsumi diigoco ubuheesuunoma iicaubo sihidɨ ɨsɨfiiratuuboro miyamɨnaaco nuuhi: Sahuse juugahusetɨ safucu icano icahi mududɨcamaaiqui. Jaasumi masaa amɨɨhaico ibuheesuqui jaguisɨsumi icatɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jaanegui Aivojɨɨbo Jesu diiboco iimusuuhi: Bañɨfiiramɨnaa, jaguisɨsumi icarunaaca amɨɨhai joomɨco misinɨɨmoro masatyefihi nɨfaihutɨ mihisuutomo. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Jaanegui jaamo Abraham iyaaicɨgaico Satanas guihuvari dieciochodɨno ficabava tɨcovovɨ isisɨhinɨgoco, jaguisɨfucuvɨ iicanegui nacu misinaayujitɨrahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jillɨ Jesu unuuneri, paryɨ diiboco ɨjɨɨheveumo nucufeveuhi. Jaarunaa saatoho miyamɨnaa imo imo icauhi, Jesu sihidɨ jeevanoco omoonɨnoco aatyɨmeumoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jaaboro Jesu nuuhi: ¿Jinejebadɨ fɨne jeevano Moocaani aivojɨ? ¿Jinejevɨ fɨne oovɨcɨji? ");
INSERT INTO bmrNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Fɨne mostaza noovatabadɨ jeevano. Jaano tooɨco miyamɨnaafi abasuno ujusinoro guiraaho ɨmohotɨ minifetehi. Jaahohaafenevɨ joomɨ agahafomo ihiicunoco eetavehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jaadɨ nuubo Jesu: ¿Jinejevɨ oovɨcɨjirahi fɨne Moocaani aivojɨco? ");
INSERT INTO bmrNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Fɨne juurisutaguiijɨco gaigo itacufaño minoocɨ, sano icano ohoovogoro ificuuno paryɨ iitacuco adɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jaabo Jesu Jerusale cuumijaago ofoobo jɨɨhaivɨ afatyocuumijevɨ jɨɨbogooboro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jaanaa saafi diiboco dilluuhi: Aivojɨɨbo, ¿naa mɨɨdɨmoro taajaji? nooboro. Jaanegui nuubo: ");
INSERT INTO bmrNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Miguiino jaamo ijene jɨɨhai aamɨjɨriro mɨjɨcafetehi. Jaanegui amɨɨhaico neehi: Sihidɨ miyamɨnaa imegueji ɨjɨcafotonoco. Jaarumo jɨcafetejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Iija abajaabo agañiivooboro iguhugaco afabaacunobuuna amɨɨhai jahisi mihicamo, mocoovaji: Aivojɨɨbo, mɨɨhaico faayɨcɨ, noomoro. Jaarunaa diibo amɨɨhaico iimusuji: ¿Mɨɨjoho amɨɨhai? Amɨɨhaico uujoho gaajatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jaanegui amɨɨhai mɨtɨcovaji diiboco monoomo: Ɨɨma mɨɨhai mamachuhicauhi, mahaduhicauhi icano tollɨro ɨɨjoho muucuumijefaño dɨɨbeguehicauhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jaarunaa amɨɨhaico neejiibo: Amɨɨhaico nuucuuhi, amɨɨhaico uujoho gaajatɨhi uuditɨ buhɨgovɨ miminifoto amɨɨhai iimitɨnoco momoonɨfino miyamɨnaa. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jaamo tahɨgo mataacasimoro amɨɨhai igaiñooco mohojɨsuji. Abraham, Isaac, Jacob, paryɨ Moocaani iimaamɨnaa icamo Moocaani aivojɨfaño icamoco maatyɨmemere amɨɨhaico diitotɨ buhɨgovɨ agañɨɨcuumo mihicajimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Jaanaa tollɨro fahɨgovatɨ miyamɨnaa saaji Moocaani aivojɨfaño acasɨɨvomoro imachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jaasumi miyamɨnaa jisumi guiinovɨ iicarumotɨ tusumi saatoho sihidɨ ejeevamotɨ minifeteji. Jaanotɨ jisumi sihidɨ jeevano iicarumotɨ saatoho tusumi guiinovɨ minifeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jaafucu fariseomɨ asaaumoro Jesuco nuuhi: Jinootɨ sihɨ fuucu Herode imeguehi ɨco agaicaaunoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jaanegui Jesu iimusuuhi: Mofoo, jaamoro toonaamuhuco monoo: Jaachiijɨ, cɨvohogo icano imitɨno ɨjɨmɨco buhɨ gavaracuji, iguihuvamoco buheesuji icano. Jaabo cɨvohogo seseevedɨ imiveji. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jaaruubo ofoohɨgo feeji jaachiijɨ, bu cɨvohogo, bu seseevedɨ icano. Mɨllɨtɨ bu Moocaani iimaamɨnaafi Jerusaletɨ buhɨgovɨ guijevejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusale cuumi, Jerusale cuumi, amɨɨhai Moocaani iimaamɨnaaco magaisiraicɨfiihi, tollɨro Moocaani amɨɨhaijaago jɨɨbogomɨnaaco agalluumoco guiisibaneri mahaamɨfiihicahi. Jaanotɨ uujoho imeguehicahi fahiijɨvaro tuucuumi seemeque tajaagovɨ iigaiyɨɨcɨnoco oono catava iseemeque ijɨjecuguiino ificuunɨcɨbadɨ. Jaarunoco amɨɨhai mihimeguehicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Eneecau bu magaaja amɨɨhai iijano jihovonodi fiiveteji. Jino amɨɨhaico neehi: Uco siino mahatyɨmecuujitɨhi jari johono uco: Imicani Aivojɨɨbo momofeenedɨ asaabo, meneejifucu agasetɨnohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Safoono jaguisɨsumi Jesu fariseomɨ aivojɨɨbo iijafaño fuuhi imachuqui. Jaaboco saatoho fariseomɨ ɨɨfɨnɨcɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jaanaa Jesu ɨmega icɨɨdɨɨhallɨvɨ nɨfaihu agahafuuneri iguihuvaubo icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jaanegui Jesu fariseomɨ, Moise tajɨɨba jɨɨbogomɨnaa icamoco dilluuhi: ¿Fɨne jaguisɨsumi mubuheesujirahi iguihuvaaboco, nacu mubuheesujitɨrahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jaarunaa diito iimusuutɨhi. Jaanegui iguihuvauboco ɨɨcɨuboro buheesuuhi. Jaaboro diiboco agalluuboro ");
INSERT INTO bmrNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ifariseomɨco nuuhi: ¿Cajaatyo fɨne amɨɨhaitɨ amɨɨhai jooɨ ifapaajefaño aacotooboco mɨhɨcɨjitɨrahi jaguisɨfucu iicaneguiiha? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jaarunoco mɨllɨ iimusuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jaanaa Jesu ɨɨfɨnɨcɨnaaca ucuuhuvaumo asaaumo imiyamañejevɨro casɨɨcamaaihicauhi. Jaanegui Jesu oovɨcɨfeenedɨ diitoco faguuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Saafi ɨco taabava jɨɨbaimojaago ucuuhuvasumi imiyamañovɨ casɨɨvedino, fɨne gasejiruubo sifi dijanaanɨcɨ iicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jaanegui amɨɨsico ucuuhuvaabo asaaboro ɨco neejirahi: Jahɨgovɨ diica tomañovɨ jaanɨ icasɨɨvequi, nooboro. Jaanegui ɨɨjoho unucufeveebere diito allɨbavɨ feejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tollɨ icatɨno, ɨco ucuuhuvasumi ofoobo allɨbavɨ casɨɨvo. Jaachiijɨ fañoojaoobo asaaboro ɨco neeji: Tañahabo, jahɨ imiyagahallɨvɨ casɨɨvoto, nooboro. Jillɨtɨ jari imiyaamo amachumofeeneri diicaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jaabadɨ uujoho mityahi onoobo guiinovɨ ficucafeteji. Jaanotɨ miyaabo icaruubo mityahi onootɨɨbo miyaabotɨ ficucafeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jaadɨ bu fañoojaooboco nuubo: Jɨɨbaimofaño machutaaco edeetavusumi digataavomɨnaacoro, dinahabomɨco, diyotoco, difiitɨno iica ɨnɨhɨbamɨvamoco icano cuuhuvadino, tollɨro bu diito ɨco coovajirahi. Jaamaño diitoco ocoovano jaadaco dɨɨcɨcuujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tollɨ icatɨno; jɨɨbaimoco edeetavusumi ɨɨdaasufiimoco, ifiino imitɨmehejeque, ɨɨgotɨmehejeque, aatyɨmetɨmehejeque icamocoro cuuhuva. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jaadɨ jari imo imo diicaji ɨco diito jaadujitɨrahi. Jaaruno jaadaco gaayɨcɨji ufucu jari iimifiimo siino ubuheetesumi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jillɨ Jesu unuunoco saafi ɨgɨcɨnɨumañotɨ Jesuco nuuhi: Imicani icajiibo Moocaani aivojɨfaño machutaaco amachuubo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jaanegui Jesu diiboco nuuhi: Safoono saafi eetavuuhi machuta jɨɨbaimoco. Jaaboro tajɨɨbauhi sihidɨ miyamɨnaaco icuuhuvaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jaanaa amachucuujino iicacuunegui iicojɨmɨnaafico galluubo, ucuuhuvaumoco ijɨɨbeguetequi: Masaacu paryɨ fanooro icacuuhi mamachuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jaarunaa famooro tɨcovauhi onoomo; saafi nuuhi: Jaachiijɨro jiinɨjeque naajejehi. Jaanoco meecɨteji. Jaanegui ɨco neehi: Feejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jaanotɨ bu saafi nuuhi: Jaachiijɨro fahuseecɨdɨmo bueymɨco naajejehi. Jaamoco nɨsuteji. Jaanegui ɨco neehi: Feejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jaanotɨ bu saafi nuuhi: Jaachiijɨro atyabaco ɨcɨjehi. Jaanegui ɨco neehi: Feejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jaanegui ijeecɨvomɨnaafi uhuumiuboro ihaivojɨɨboco jɨɨbogovauhi paryɨɨcɨno. Jaaneri ihaivojɨɨbo ɨsɨfiiratuuboro, ijeecɨvomɨnaafico nuubo: Goovano difoo cuumi jɨɨhaiñeri. Jaaboro sɨva ɨɨdaasufiimoco, ifiino iimitɨmehejeque, ɨɨgotɨmehejeque, aatyɨmetɨmehejeque icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jaanobuunatɨ ijeecɨvomɨnaafi nuuhi: Aivojɨɨbo, onoobadɨ moonɨcuuhi. Jaarunofaño icanehiica saatoho iicajirumañeje, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jaanegui ihaivojɨɨbo diiboco nuuhi: Siino difoo. Jaaboro buhɨgueeje jɨɨhaiñofaño iicamehejeque dɨɨcɨto taaja igahafequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Miyanotɨro amɨɨhaico neehi: Itɨconɨ ucuuhuvarumo tamachutaatɨ ajashuno itɨɨvejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jaanaa Jesu dojɨcutɨ sihidɨ miyamɨnaa feehicauhi. Jaanegui dojɨcuvɨro diitojaa ɨɨmeveuboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Saafi tadyojɨcutɨ asaanoco iimogoobo caanico, seejɨco, mogaico, iseemeque, inahabomɨco, inagomɨco, bu ifi icarunoco icano ɨjɨɨhevetɨɨbo tadyojɨcutɨ saajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tollɨro tamomohallɨtɨ ifiico iguijenɨsunoco iimogotɨɨbo tadyojɨcutɨ saajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","¿Nacu amɨɨhaitɨ saafi torrehacɨco eetavonoco iimogoobo itɨconɨ tohacɨ ajaaducafotonoco gaajajiruubo? Diiboma imino ɨɨfetejidɨno iicaruva eetavejiruubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jaanotɨ ihɨmahacɨnocoro ɨtɨconɨɨbo inɨhɨbamɨ achahaneguiiha ijeevesuruva tohacɨjeque aatyɨmeme diiboco dejecujirahi: ");
INSERT INTO bmrNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Diibo jino tɨconɨhinɨrahi eetavonoco. Jaaruubo imivehinɨtɨhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jaabadɨro saafi aivojɨɨbo siijiinɨjeo aivojɨɨboma omoonɨcasijisumi imiyamɨnaa diez mildɨmoma iicaabo. ¿Nacu fɨne veinte mildɨmoma diibojaa asaaboco guiinonɨjirahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jaarunaa diiboco sahɨgotɨro iguiinonɨjirunoco agaajaaboro tehesiibaacaro diibojaa jɨɨbogoco galluujiruubo iimitocasiqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jaabadɨ cajaanɨhacho amɨɨhaitɨ paryɨ iinoco ejeevesutɨɨbo tadyojɨcutɨ saajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ɨmuhu imihi. Jaarunaa iimo afatyusumi, ¿mɨllɨ bu siino imitejiruno? ");
INSERT INTO bmrNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jillɨ magañɨɨtacuuhi jiinɨjeguiiha imitɨno, bu abonoguiiha imitɨno icano. Amɨɨhai nohojɨma mihicamo muguubu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jaanaaca paryɨ impuesto jaadusumɨnaa, paryɨ imitɨmɨnaa icamo saahicauhi diiboco iguubunɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jaanoma iicamo fariseomɨ, caatɨnɨmɨnaa icamo diibeditɨ imitɨno neehicauhi: Jaanɨ iimitɨmehejequere agaayɨcɨɨboro diitoma machuubo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jaanegui Jesu diitoco jillɨ oovɨcɨuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","¿Nacu mɨɨjoho fɨne amɨɨhaitɨ ciendɨno ovejamɨma iicaabo saafi diitotɨ imɨtaruva noventa y nuevedɨmoco sihɨgo iimimañovɨ ificuhinɨɨboro feejitɨrahi iguiinotoobo aatyɨmetɨnohachuta? ");
INSERT INTO bmrNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jaaboco aatyɨmeebere imo imo ijɨjebaɨhallɨvɨ ficuunɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jaabo iijajaago agaseebere inahabomɨco, ifiitɨnomɨnaaco icano ocoovaaboro neehi: Uuma imo imo mihica tahoveja ɨmɨtahinɨɨboco atyɨmecuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Amɨɨhaico neehi: Tobadɨro niquejefaño iicamo aivo imo imo icanɨcɨhi saafi iimitɨɨbo iimitɨco ejeevesuuboro iicasumi. Jaanotɨ noventa y nuevedɨmo iimitɨma achahamo iicamaño jinejeque bu jeevesujirumo. Jaanegui diito janaanɨcɨvɨ imo imo iicano saafi iimitɨco ejeevesucusumi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","¿Nacu cajaamo gaigo fahuseecɨjeva inɨhɨbamɨ iicanotɨ saje imɨtaruva cuugahuco ɨnɨɨgoro guijaagoro, iminogayɨ guiinejitɨrahi aatyɨmetɨnohachuta? ");
INSERT INTO bmrNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jaajeque aatyɨmecuudɨ inagomɨ, ifiitɨnomɨnaa icamoco ocoovagoro neehi: Uuma imo imo mihica; atyɨmecuuhi tañɨhɨbaje ɨmɨtahinɨjeque, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Amɨɨhaico neehi: Tollɨro Moocaani toomomɨnaa sihidɨ imo imo icanɨcɨhi, saafi iimitɨɨbo iimitɨco ejeevesusumi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tollɨro bu Jesu nuuhi: Saafi miimɨsiicɨ iseemene mɨsima icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jaanaa iguihoobo caanico nuuhi: Guihi, jisumiro uco daacɨ dinehejetɨ ufucu uudi iicajirunoco, nooboro. Jaanegui caani diitɨsima inehejeque diitɨsima dugaacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jaanobuunatɨ iguihoobo inehejeque anaajeuboro inɨhɨbamɨco allacaruuhi. Jaaboro toonoma tehesino siijiinɨjevɨ fuuhi. Jahɨgo paryɨ inɨhɨbamɨco iimitɨnovɨ gañɨɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jaanaaca diibo inɨhɨbamɨco agañɨɨcuunobuunatɨ toojiinɨjevɨ sihidɨ ajeba icauhi. Jaaneri diibo tɨcovauhi sihidɨ ajebari iicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jaanoma iicaabo dudɨcamaajeque guiinutuubo toojiinɨjeomɨnaafijaago. Jaabo diibo ifaafaimɨco tuumusuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jaabo ifaafaimɨ machuta imitɨnotɨ imachuqui moonɨhicaurahi. Jaarunaa mɨɨhaiñooba diiboco toonotɨ acɨhicautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jaanotɨ esafutuubo: Guihirubi iijafaño sihidɨ idudɨcamaajemɨnaa machuta sihidɨ atyuuvonɨcɨnaaca, uujoho jimañovɨ ajebari nacatehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dojɨcuvɨro uumiji guihirubi iijajaago. Jaaboro diiboco neeji: Guihi, Moocaanihallɨvɨ, dihallɨvɨ icano imitɨno moonɨhicahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jaanegui uujoho iimitɨmaño diseemenebadɨ icacuutɨhi. Jillɨ didudɨcamaajeebebadɨro uco deesɨcɨnɨcu, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","dojɨcuvɨro uumicuubo caani iijajaago. Jaaboco tehesinotɨro caani aatyɨmeuboro ɨdaasuvuuhi. Jaaboro diibojaago ijinafatyuuboro diiboco ihiibɨcɨtuuboro nɨnɨɨcɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jaanegui diibo caanico nuuhi: Guihi, Moocaanihallɨvɨ, dihallɨvɨ icano imitɨno moonɨhi. Uujoho iimitɨmaño uco diseemenebadɨ icacuutɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Jaarunaa caani nuuhi ijeecɨvomɨnaaco: Goovano iimichehuco mɨhɨcɨmoro diiboco mɨjɨɨhacu. Jaamoro usegaiviicutɨ ihusefa mificu, tɨhaipaajetɨ diiboco mɨjɨɨhacu icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jaamoro niivɨgai ɨɨcavaaboco mɨhɨcɨtomoro magaicaau, muduumoro jɨɨbaimoco meheetavequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Jaanɨ taseemene uchuumucuubo siino ubuheetejirubadɨ iicaneguiiha, ɨmɨtahinɨɨboco siino mahatyɨmeneguiiha, nooboro jɨɨbaimoco eetavuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jaanaaca ihamiyaabo sihɨ ifaguifaño icauhi. Jaabo jaahe asaaubo guubuuhi agaaseme amasivanoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jaanegui saafiitɨ icojɨmɨnaafico ocoovauboro dilluubo: ¿Mɨllɨ iicano oono? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jaanegui iimusuubo: Dinahabo gasehi. Jaanegui diicaani iniivɨgai ɨɨcavaaboco gaicaausuhi mɨllɨ icatɨɨbo imino agaseneguiiha, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jaarunaa diibo ihamiyaabo sihidɨ ɨsɨfiiratuuboro jaahe fuuguutɨɨbo. Jaanegui caani asaauboro diiboco noovauhi jaahe isaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jaaboro caanico nuubo: Ɨɨro gaajahi sihidɨ ficabano ɨɨma dudɨcamaaihicahi diijɨco gañɨɨtɨɨbo. Jaaruuboco safooba diniivɨmɨtɨ saafiigayɨɨba daacɨtatɨhi, tagataavomɨnaama jɨɨbaimoobaco eheetavejirunaaca. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jaanotɨ jaanɨ daachi dinɨhɨbamɨco iimitɨno gaigoomɨma agañɨɨboro agaseebedi naha diniivɨgai ɨɨcavaaboco gaicaauhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jaanegui caani nuuhi: Besha, ɨɨjoho fahiijɨvaro uuma diicanɨcɨhi. Jaamaño paryɨ tañeheje diino. ");
INSERT INTO bmrNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jaanotɨ imino jisumi jɨɨbaimoco meheetavomoro imo imo mihicano, dinahabo uchuumucuubo siino ubuheetejirubadɨ iicaneguiiha, ɨmɨtahinɨɨboco mahatyɨmeneguiiha, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jaadɨ tollɨro Jesu nuuhi ijɨɨbogomɨnaaco: Icaubo saafi sihidɨ nɨhɨbamɨma iicaubo, guubuuhi iija toomomɨnaafi diibo nehejeque sɨcamañovɨ agañɨɨhicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jaanegui ihaivojɨɨbo ocoovauboro diiboco nuuhi: ¿Mɨllɨ iicanoco ɨɨditɨ guubuhi? nooboro didudɨcamaajetɨ paryɨ uco dɨɨbogo. Jisu tadyudɨcamaajemɨnaafitɨ diicacuujitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jaanegui iija toomomɨnaafi esamaaihicauhi: ¿Mɨllɨ fɨne icaji jisumi tahaivojɨɨbo tadyudɨcamaajetɨ uco agañɨɨdɨ? Sefatɨhi jiinɨjeque eseedijiruubo nucufeguehi sitaaco nɨhɨbamɨco idillunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jaaruubo gaajacuuhi jillɨ saatohoco aamusunotɨ diito uco iijafaño tadyudɨcamaajema achahasumi agaayɨcɨjinoco, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","coovaubo saafiiri paryɨ saatoho ihaivojɨɨboco edebeumoco. Jaaboro saafiico dilluubo: ¿Mɨnoodɨno ɨɨjoho tahaivojɨɨboco debehi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jaanegui diibo iimusuuhi: Debehi ciendɨno illuva tyɨgabaje dɨɨrɨbanoco, nooboro. Jaanegui iija toomomɨnaafi nuuhi: Jino didebehaamene, goovano casɨɨvoobo bohonotɨ deetavo cincuentadɨnoro oono aametɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jaabadɨro sifiico dilluubo: ¿Jana mɨnoodɨno ɨɨjoho tahaivojɨɨboco debehi? nooboro. Jaanegui diibo nuuhi: Trigoco ciendɨno tɨcovo tiyɨva, nooboro. Jaanegui nuubo: Jino didebehaame, bohaametɨ deetavo ochentadɨno tɨcovo tiyɨvaro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jaanoco ihaivojɨɨbo agaajacɨudɨ nuuhi: Taaja toomomɨnaafi gaajaabo aivono ɨfuuruubo, sitaama imino iicaqui omoonɨnoco. Jiinɨjeo miyamɨnaa gaajahi jiinɨjeonehejeque, miyaavogomɨnaa janaanɨcɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jaanegui amɨɨhaico neehi: Jino iimitɨno jiinɨjeonehejeri gataavomɨnaatɨ mɨhɨcɨ jiinɨjeoneheje ifinɨɨdɨ amɨɨhaico diito ufucu niquejefaño ifinɨjitɨno iijanofaño igaayɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mɨɨdɨrunoma imino omoonɨɨbo, tollɨro iguiraanoma imino moonɨhi. Jaanotɨ ajashurunoma imitɨno omoonɨɨbo, iguiraanoma tollɨro imitɨno moonɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jaamaño jino iimitɨno jiinɨjeonehejeri imitɨno momoonɨmoco, ¿mɨɨjoho bu amɨɨhaico imiyaanehejeque acɨjirahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jaanotɨ sitaano icarunoco imitɨno momoonɨhicamoco, ¿mɨɨjoho bu amɨɨhaico acɨjirahi amɨɨhaiñotɨro iicaqui? ");
INSERT INTO bmrNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Chahaabo jeecɨvomɨnaafi miimɨsiicɨ aivojɨtɨsico ejeecɨvoobo, saafiico ɨjɨɨhegueebere, saafiicoro gaijɨjiruubo. Saafiima imino iicaaboro saafiiditɨ imitɨno esamaaijiruubo. Jaabadɨro Moocaani, bu nɨhɨbamɨ icanoco sano mejeecɨvejitɨrahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jaanoco fariseomɨ nɨhɨbamɨma imoyɨɨcɨmɨnaa iicamaño jillɨ unuunoco paryɨ uguubuumoro Jesuco dejecuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jaanegui Jesu diito nuuhi: Amɨɨhai miyamɨnaa ɨmefeenevɨ iminobadɨ mihicahi. Jaarunaa Moocaani amɨɨhai jeebɨɨco gaajahi; miyamɨnaa sihidɨ jeevahibadɨ eesɨcɨnɨnoco Moocaani jɨɨheguehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sɨɨcɨjetɨ Moise tajɨɨba, Moocaani iimaamɨnaa icano icahicauhi, Jua ifiivutɨnohachuta. Toonotɨro iimi Moocaani aivojɨ iijɨ jɨɨbogocafetehi. Jaamofeenedɨ famooro sefacɨnɨhi ijɨcafetequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tɨhɨɨno niqueje, bu jiinɨje icano ifinɨno. Jaano janaanɨcɨ jeevano tajɨɨbatɨ sasitugayɨ afatyejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Saafi miyamɨnaafi mogaico ejeevesuuboro sifigoco ɨɨcɨɨbo iimitɨnoco eetavehi. Jaabadɨro ejeevesucɨnɨgoco ɨɨcɨɨbo iimitɨnoco eetavehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Safoono icaubo saafi sihidɨ inɨhɨbamɨma iicaubo. Jaabo iminoono gaachehunofaño jɨcamaaihicauhi ovosɨɨnoono. Jaaboro fafucuvaacɨvɨro jɨɨbaimoco sihidɨ ovosɨɨnoono. Jaanaa tollɨro icaubo saafi ");
INSERT INTO bmrNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ɨɨdaasuubo sihidɨ icɨɨnisinoma icaabo baavɨ gɨcɨnɨhicaubo inɨhɨbamɨma iicaabo guhugavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jaabomaje tuvaveguehicaurahi inɨhɨbamɨma iicaabo machuta usuuvɨneri. Jaaboco jɨcumɨ asaamoro itujaavonoco nejeecuhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jaanofeene iguijeveubomajeque cɨɨumo. Jaaboco Moocaani toomomɨnaa satyuuhi icojɨvɨ. Jaanaa tollɨro bu inɨhɨbamɨma iicaubo guijeveuhi. Jaaboco cɨɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jaabo inɨhɨbamɨma iicaubo ɨdaasuno icahicauhi iguijeveme iicafihɨgo. Jaabo tahɨgotɨ caamoco emeecɨubo atyɨmeuhi Abrahamco Lazaro iicojɨri icaaboma. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jaanegui coovadiivuubo: Guihi Abraham, uco dɨdaasugo. Jaaboro Lazaroco tajɨɨba ofooboro ihusegai nijequeque nɨfaihufaño amatyusuuboro tañejeba nijequeque isɨɨcusuvaqui. Jino cɨɨjɨgaifaño sihidɨ ɨdaasuno icahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jaarunaa diiboco Abraham nuuhi: Taseemene, desafoto jiinɨjehallɨri idiicahinɨsumi imino diicahinɨhi. Jaanotɨ Lazaro ɨdaasuno icauhi. Jaaruubo jisumi juuga jacusucɨnɨhi. Jaanotɨ ɨɨjoho ɨdaasuno diicahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jaanomaryo bu amɨɨhai mɨɨhaitɨ sɨcaisitu oonaagonovɨ mihicahi. Jaamaño juugatɨ tahɨ efeejirumo. ¿Mɨllɨ bu feejirahi tahɨgotɨoto? ¿Mɨllɨ bu juugavɨ fatyejirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jaanegui inɨhɨbamɨma iicaubo nuuhi: Jaaneguiiha taca Guihi Abraham, ɨco neehi: Jaabo Lazaroco galluuhi guihirubi iijajaago, ");
INSERT INTO bmrNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ofooboro sahusedɨmo tañahabomɨco ijɨɨbeguetequi. Jaanotɨ juuga jino ɨɨdaasumañovɨ tollɨro saadimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jaaruuboco Abraham nuuhi: Diitoma icano Moise acaatɨnɨuhaamene, Moocaani iimaamɨnaa acaatɨnɨuhaamene. Jaanoco iguubuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jaanegui inɨhɨbamɨma iicaubo nuuhi: Jɨɨhɨ, guihi Abraham, jaarunaa saatoho iguijevecuumotɨ diitoco ijɨɨbogoturuva iimitɨco jeevesujirumo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jaarunaa Abraham diiboco nuuhi: Moise, Moocaani iimaamɨnaa icamoco uguubutɨhachiijɨ, tollɨro bu saatoho iguijevecuumotɨ ifuuruva guubujitɨrumo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jaadɨ Jesu nuuhi ijɨɨbogomɨnaaco: Icamo iimitɨno, miyamɨnaaco imitɨnofaño agañɨɨsuno. Jaarunaa ɨdaasucani icajiibo sitaaco imitɨnofaño agañɨɨsuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Imijiruno diiboco guiisibatyɨgabari icodaahetɨ muduujenɨmoro muuaifaño magañɨɨno. Jaano janaanɨcɨ ɨdaasuno icajiruubo seemeneque imitɨnofaño agañɨɨsuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mehesɨcɨnɨ amɨɨhai nahabo amɨɨhaico imitɨno omoonɨhachiijɨ diiboco mɨhɨɨba. Jaabo iimitɨco ejeevesuhachiijɨ diiboma mihimibachucasi. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Safucuro sahuse juugahusetɨ mifoocɨ icano imitɨno omoonɨɨboro, bu tonoodɨfovaro dijaa asaaboro siino tollɨ icacuujitɨhi onoohachiijɨ, imino diiboma mihimibachucasi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jaanegui iminɨsumɨnaa Aivojɨɨbo Jesuco nuuhi: Mɨɨhaico daamusu janaanɨcɨ mimiyaaveguequi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jaanegui Aivojɨɨbo Jesu diitoco nuuhi: Amɨɨhai miyaavogo mostaza noovata toogaidɨno iicahachiijɨ jiho sicomor onoohoco meneejirahi: Jinootɨ gaijuuvoho muuaifeenevɨ dulleevete munuuruva, amɨɨhaico tooho: Jii, neejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Amɨɨhaitɨ cajaanɨhacho ijeecɨvomɨnaafima iicaruva ududɨcamaaihicaabo faguifañotɨ agaseebeque: ¿Nacu saacu, casɨɨvoobo, machucu, meneejirahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Cha, tollɨ icatɨno. Fɨne meneejirahi: Tamachutaaco deetavoobo uco dihaivojɨɨboco deecɨvo machuqui, aduqui icano. Jaadɨ jari ɨɨjoho machuji, daaduji icano, meneejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Nacu dijeecɨvomɨnaafico atajɨɨbanoco eetavonohallɨvɨ graciaco daacɨjirahi? Tollɨ icatɨno. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tollɨro amɨɨhai Moocaani atajɨɨbanoco mihimivucuudɨ monoo: Jillɨ mɨɨhai mɨhɨɨfono jeecɨvomɨnaa jillɨ atajɨɨbanocoro meheetavomaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesu Jerusalejaago ufuubo fatyuuhi Samaria jiinɨje, Galilea jiinɨje icanofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jaabo toojiinɨjeocuumi saacuumivɨ ɨɨfutuubojaago saaumo fahuseecɨ gaifiimɨ foojohoma iicaumo. Jaarumo diibotɨ tehesino ujulleecamaaivaumoro sefano nuumo: ");
INSERT INTO bmrNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jesu jɨɨbogomɨnaafi, mɨɨhaico dɨdaasugo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jaamoco Jesu aatyɨmeuboro nuubo: Mofoomoro sacerdotemɨco mɨhɨfusuto, nooboro. Jaanegui ufuumotɨ jɨɨhaivɨ ifoojoho buuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jaanegui saafi ubuheecuunoma iicaubo dojɨcuvɨro uumiubo Moocaanico imooboro sefano. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jaaboro Jesuguiino ememuɨɨvuuboro jiinɨjehallɨvɨ javuvuubo graciaco ihacɨqui. Jaabou Samaria jiinɨjeoobo. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jaanegui Jesu diiboco nuuhi: ¿Nacu famooro fahuseecɨdɨmo mubuheetɨhi? ¿Cuuca nacu saatoho nuevedɨmo? ");
INSERT INTO bmrNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Jaanɨ ɨdɨɨboro siicuumioobo uumihi Moocaanico iimequi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ifoojohoma iicauboco nuubo: Gañiivoobo, fuucu; imiyaavogomaño buheetecuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jaanaa fariseomɨ Jesuco dilluuhi: ¿Cusumi Moocaani aivojɨ gaseji? noomoro. Jaanegui diibo iimusuuhi: Moocaani aivojɨ agasene siinoco mahatyɨmenɨcɨnobadɨ jeevatɨno. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Juu icacuuno, jahɨ icacuuno noorajitɨno, Moocaani aivojɨ amɨɨhaifeeneri icacuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ijɨɨbogomɨnaaco nuubo: Ufucu amɨɨhai mihimegueji mahatyɨmeneque Miyamɨnaafibadɨ Ifiivuubo fucutɨ. Jaarumo mahatyɨmejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jaasumi amɨɨhaico saatoho neeji: Juu icacuuno, jahɨ icacuuno, noomoro. Diito dojɨcutɨ mefeedino. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Uujoho Miyamɨnaafibadɨ Ifiivuubo asaajino jillɨ jeevaji: Oono sisi niquejeguiinodɨ saanaagojetɨ siinaagojevɨ anamebanɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Jaaruubo itɨconɨ sihidɨ ɨdaasuno icaji, jisumiomiyamɨnaa uco jɨɨheveji icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mɨɨro johono Noe iicausumi iicaubadɨ icajino uujoho Miyamɨnaafibadɨ Ifiivuubo asaajino ɨmega. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mɨɨro miyamɨnaa machuhicaumo, aduhicaumo, taabavahicaumo, iseemeque tajenɨhicaumo icano. Jaanaaca Noemɨ imeenegafaño jɨcafutuuhi. Jaanaaca sihidɨ niija aaiguuneri paryɨ saatoho guijeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jaabadɨro bu Lot onoobo iicausumi icauno machuhicaumo, aduhicaumo, naajecasihicaumo, basuhicaumo, iijanoco eetavehicaumo icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Jaanaaca Lot Sodoma cuumitɨ ufuunobuunatɨ niquejefañotɨ aifuuno cɨɨjɨgaima guiisibano ɨjɨgauno. Jaaneri paryɨ tuucuumi miyamɨnaa guijeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tollɨreji uujoho Miyamɨnaafibadɨ Ifiivuubo ajafeveedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tusumi saatoho iijahallɨri mihicahachiijɨ miniitomoro iijafañotɨ amɨɨhai nehejeque mɨhɨcɨtedino. Jaanotɨ saatoho buhɨgo mihicahachiijɨ amɨɨhai iijajaago muhuumidino. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot taabatɨ mehesafoto. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mɨɨro ifiico ɨdaasuno omoonɨnotɨ ataajasugoobo ifiico mɨtasuji. Jaanotɨ ifiico Moocaanijaagodɨ ɨmɨtasuubo ifiico taajasuji. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Amɨɨhaico neehi: Tufucu miitoocɨ saabafaño cɨgaji. Jaamɨsitɨ saafi imiyaavogotɨɨbo satyocafeteji diiboco sihidɨ jeevano ɨdaasuno imoonɨqui. Jaanotɨ saafi imiyaavogoobo coovovacafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bu miimɨfeecɨ gaigoomɨfe sano garyɨɨhañɨji. Jaamɨfetɨ saafigo imiyaaveguehicatɨgo ɨcɨcafeteji diigoco sihidɨ jeevano ɨdaasuno imoonɨqui. Jaanotɨ saafigo imiyaaveguehicago jeevesucafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bu miimɨsiicɨ buhɨgo icaji. Jaamɨsitɨ saafi ɨcɨcafeteji. Jaanotɨ saafi jeevesucafeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jaanoco uguubuumoro diiboco dilluumo: ¿Aivojɨɨbo, conoovɨ fɨne tollɨ icajino? noomoro. Jaanegui diibo nuuhi: Tuucɨta iicahɨgo añɨmɨ igaivefihi, nooboro. Jaabadɨ niino jaadusufucusumi imiyaavogotɨmoco ɨdaasuno ɨfeteji. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesu oovɨcɨuhi Moocaanima ihiimaamo quehecuno iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Diitoco nuubo: Saacuumivɨ icaubo saafi fagomɨnaafi Moocaanico ɨñɨhicuguutɨɨbo. Tollɨro mɨɨhaiñoobaco gaijɨhicautɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jaacuumivɨ tollɨro fibaijɨgo icauhi. Jaago saicɨno diibojaa feehicauhi imɨnaafima imitɨno iicahicaunoco diigoma iimibachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Saicɨno diibo diigo unuurunoco: Jii, neehicautɨɨbo. Jaanofeene esafutuuboro nuubo: Moocaanico ñɨhicugotɨhi, mɨɨhaiñoobaco gaijɨtɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Jaarunaa jaamo fibaijɨgo asaagoro gañuhusuno uco moonɨhicahi. Jaanegui diigohallɨtɨ icaji siino saicɨno saacuutɨgo iicaqui tajeebɨɨco uco nɨjɨ nɨjɨ moonɨdigo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jaanoco Aivojɨɨbo Jesu nuuhi: Jillɨ nuubo iimitɨno fagomɨnaafi. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Nacu jaabadɨ Moocaani ɨɨcɨmo diibovɨ ɨɨdaasuvomo fucuhachuta, cuujehachuta icano idilluruva diitohallɨtɨ Moocaani icajitɨruubo? ¿Nacu fɨne diitoco tuumusujiruubo? ");
INSERT INTO bmrNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Amɨɨhaico neehi: Tuumusutɨɨbo diitoco goovano amusujiruubo ¿Nacu fɨne uujoho Miyamɨnaafibadɨ Ifiivuubo siino jiinɨjevɨ asaadɨ fɨne miyaavogoco atyɨmeji? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Saatoho: Mɨɨhai aivo miyaamo, noomoro sitaaco ɨtɨɨsuhicaunoma iicaubo jillɨ ohoovɨcɨuboro nuubo: ");
INSERT INTO bmrNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Safoono miimɨsiicɨ gaifiimɨsi templojafaño fuuhi Moocaanima iimaaqui. Saafiu fariseomɨoobo. Jaanotɨu saafi impuesto jaadusumɨnaafi. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jaanaaca ifariseomɨoobo julleecɨnɨɨboro Moocaanima ihiimaaubo jillɨ neehicauhi: Moocaani ɨco imehi saatoho iicabadɨ uujoho nanivamɨnaafi icatɨhi, sitaaco imitɨno moonɨtatɨhi, gaigoomɨma icatatɨhi, jaanɨ impuesto jaadusumɨnaafibadɨ icatɨhi, ");
INSERT INTO bmrNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","sajaguisɨvɨ mifoocɨ machutɨɨbo icafihi, uujoho paryɨ agaananotɨ fahuseecɨtɨ sano ɨco acɨfihi, nuuruubo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jaanotɨ jillɨ impuesto jaadusumɨnaafi tehesino icahicauhi caamo niquejejaagoco meecɨtɨɨbo, jillɨ icɨɨdɨɨ tɨcovoco aamɨhicaubo nooboro: Moocaani uujoho imitɨmɨnaafi uco dɨdaasugo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jaanotɨ amɨɨhaico neehi: Jaanɨ impuesto jaadusumɨnaafi iijajaa fuuhi ijeebɨɨ imicuubo. Jaanotɨ fariseomɨooboco Moocaani gaayɨcɨutɨhi. Jillɨ iicamaño: Uujoho sihidɨ jeevahi, onoono guiinovɨ ficucafeteji. Jaanotɨ: Sihidɨ jeevahi, onootɨɨboco sihidɨ jeevasujiibo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tollɨro bu seemegayɨmɨco Jesujaa sɨvahicaumo diitoco idudɨɨcɨqui. Jaanoco ijɨɨbogomɨnaa aatyɨmeumoro ɨsɨvaumoco ɨɨbahicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jaanegui Jesu diitoco ocoovauboro nuuhi: Jaafa tajaa seeme saahi: Mefeedino, meneejirahana. Diitobadɨ iicamedi Moocaani aivojɨ icahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Miyanotɨro amɨɨhaico neehi: Moocaani aivojɨco seemene iicabadɨ agaayɨcɨtɨɨbo, tahɨ ufucu feejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jaanaa saafi aivojɨɨbo Jesuco dilluuhi: Idiimiibo Jɨɨbogomɨnaafi, ¿mɨllɨ fɨne moonɨji ifinɨjitɨno fiivoma icaqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jaanegui Jesu diiboco nuuhi: ¿Mɨllɨtɨ: Jaabo uco iimiibo, neehi? Ɨdɨɨboro saafiiro iimiibo Moocaani. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","¿Nacu gaajahi Moocaani tajɨɨbaco? Sifigotɨ taabavadino, guijenɨdino, nanivadino, sitaaditɨ sɨcamañooco dɨɨbeguedino, diicaani, diiseejɨ icamɨsico gaijɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jaanegui diibo nuuhi: Seemenetɨro uujoho paryɨ tollɨ moonɨfihi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jaanoco uguubuuboro diiboco Jesu nuuhi: Icanehiica sano dihɨmega; Foobo dinehejeque paryɨ naajete. Jaaboro inɨhɨbamɨco ɨdaasumoco daacɨ. Jaadɨ jari niquejefaño sihidɨ dinehejema diicaji. Jaaboro tadyojɨcutɨ disaa, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jillɨ diiboco unuuneri sihidɨ ɨdaasuvuubo sihidɨ inɨhɨbamɨma iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Diibo ɨɨdaasuvuunoco Jesu aatyɨmeuboro nuuhi: Aivo jeedɨ tɨhɨɨno sihidɨ inɨhɨbamɨma iicamo Moocaani aivojɨfaño ofoono. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tɨhɨɨjitɨruno camello januutu ojɨri afatyono. Jaanotɨ sihidɨ jeevano sihidɨ inɨhɨbamɨma iicaabo Moocaani aivojɨfaño ofoono. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jaanoco uguubuumo nuuhi: ¿Jaanegui cajaatyo fɨne taajajirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jaanegui Jesu diitoco nuuhi: Miyamɨnaadi ɨtɨhɨɨno Moocaanidi tɨhɨɨtɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jaanegui Pedro diiboco nuuhi: Aivojɨɨbo mɨɨhai paryɨ monehejeque mejeevesumoro ɨɨma mɨhɨguehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jaanegui Jesu nuuhi: Miyanotɨ amɨɨhaico neehi: Cajaatyohacho iijaco, caanimɨco, inahabomɨco, mogaico, iseemeque icano ");
INSERT INTO bmrNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Moocaani aivojɨguiinodɨ ejeevesumo jiijehallɨvɨ janaanɨcɨ gaayɨcɨji. Tollɨro ufucu niquejefaño ifinɨjitɨno fiivoma icajimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jaadɨ Jesu fahuseecɨ siino miimɨsiicɨ icano icamoco ijɨɨbogomɨnaaco ijeevadɨ ocoovauboro nuuhi: Jisumi Jerusalejaago mefeehi paryɨ Moocaani iimaamɨnaa uujoho Miyamɨnaafibadɨ Ifiivuubeditɨ acaatɨnɨunobadɨ iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jaaboco uco sihɨgo miyamɨnaaco acɨjimo. Jaamoro uco dejecujimo imitɨno onoomoro jɨɨrebamaaijimo, ");
INSERT INTO bmrNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ahaamɨmoro, guijenɨjimo. Jaaruubo mifucucɨ, safucu icanobuunatɨ guijevefeenetɨ siino buheeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jaarunoco diito ajashuno gaajautɨhi jinejetɨ unuunoco diitedi toovono iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jaanaa Jesu Jerico cuumitɨ fiitɨcuunaa saafi aatyɨmetɨɨbo jɨɨhaijɨniri gɨcɨnɨuhi nɨhɨbamɨco idilluubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jaanaa sihidɨ miyamɨnaa ofoomoco uguubuuboro dilluubo: ¿Mɨllɨ iicano? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jaanegui nuumo: Jesu Nazareoobo feehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jaanegui sefano coovadiivuubo: ¡David Iyaachi, Jesu, uco dɨdaasugo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jaarunaa ɨmegavɨ ufuumo diiboco ɨɨbauhi illɨɨvequi, noomoro. Jaarunaa janaanɨcɨvɨro coovadiivuubo: ¡David Iyaachi, uco dɨdaasugo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jaanegui Jesu ujulleeveuboro tajɨɨbauhi diiboco ihɨcɨtequi. Jaanegui ɨɨcɨjeuboco Jesu nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Mɨllɨ ɨco omoonɨnoco diimeguehi? nooboro. Jaanegui aatyɨmeutɨɨbo nuuhi: Aivojɨɨbo, aatyɨmeneque imeguehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jaanegui Jesu diiboco nuuhi: ¡Jii, daatyɨme! Imiyaavogomaño buheesucafetehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jaasumiro diibo atyɨmeuhi. Jaaboro Jesu dojɨcutɨ fuubo Moocaanico imooboro. Jaanoco aatyɨmeumo paryɨ miyamɨnaa Moocaanico imehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jaadɨ Jesu Jerico cuumifeenedɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jaacuumifaño icaubo Zaqueo onoobo impuesto jaadusumɨnaa aivojɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jaabo Zaqueo Jesuco imuguuhi aatyɨmeneque. Jaaruubo atyɨmehicautɨhi baareebegayɨ iicamaño, sihidɨ miyamɨnaa iicauneri icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jaanoma iicaubo ɨmegavɨ ijinafatyuuboro ɨmoho sicomor onoohori caamo fuubo Jesu afatyujino fiitɨno iicauheri toohotɨ diiboco ihatyɨmequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jaanaa Jesu toonodɨ afatyuubo caamoco emeecɨuboro diiboco nuuhi: Zaqueo, goovano tahɨgotɨ niito jaachiijɨ diijafaño ɨfeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jaanegui Zaqueo goovano iniituuboro imo imo Jesuco gaayɨcɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jaanoco paryɨ aatyɨmeumoro imitɨno neehicaumo: Imitɨmɨnaafi iijafaño Jesu ɨfetehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jaanegui Zaqueo ujulleeveuboro Jesuco nuuhi: Meecɨ Aivojɨɨbo, tañehejetɨ feenedɨ ɨɨdaasufiimoco acɨji. Jaanotɨ saateheditɨ abañɨɨboro ananihicahachiijɨ, igueenemehejedɨno tɨcovovɨ janaanɨcɨ acɨji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jaanegui Jesu diiboco nuuhi: Jiijaavɨ jaachiijɨ taajasu gasehi jaanɨ tollɨro Abraham iyaachi iicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Uujoho Miyamɨnaafibadɨ Ifiivuubo saahi imɨtahinɨmoco iguiinooboro taajasuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jaamo miyamɨnaa Jesu jillɨ onoonoco guubunɨcɨhicaumo. Jaanegui jillɨ oovɨcɨubo Jerusaletɨ ifiitɨcuuneguiiha. Jaanaa diito esamaaihicauhi: Fɨne jisumiro Moocaani aivojɨ gaseji, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jaanegui diitoco nuubo: Safoono icaubo saafi gaifi iyotobadɨ obocɨfiibo. Jaabo fuuhi tehesino siijiinɨjevɨ tahɨ diiboco aivojɨɨbotɨ ificuudɨ dojɨcuvɨro ihuumiqui, aivojɨɨbotɨ iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Jaabo ifuucuquiro fahuseecɨdɨmoco ijeecɨvomɨnaaco coovaubo. Jaaboro diitoco acɨubo nɨhɨbajene sihidɨ ijaada iicanoco. Jaamoco nuubo: Naajeteque meheetavo jino nɨhɨbamɨri ofoobo agasenehachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jaaruuboco ijiinɨje miyamɨnaa jɨɨheguehicauhi. Jaamoro diibo dojɨcutɨ saatohoma jɨɨbogoco galluumo: Mihimogotɨhi diibo mohaivojɨɨbotɨ iicanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Jaarunaaca diiboco aivojɨɨbotɨ ficuumo. Jaadɨ diibo siino ijiinɨjevɨ uumiubo. Jaadɨ cuuhuvaubo ijeecɨvomɨnaaco nɨhɨbamɨco aacɨumoco mɨnoodɨno agaanacuunoco igaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jaanegui itɨconɨoobo asaauboro diiboco nuuhi: Aivojɨɨbo, dinɨhɨbamɨ fahuseecɨdɨno janaanɨcɨ gaanacuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jaanegui ihaivojɨɨbo diiboco nuuhi: Aivo imino, ɨɨjoho aivo iimino jeecɨvomɨnaafi ajashurunohallɨvɨ imino omoonɨmaño ɨco fahuseecɨ cuumivahallɨvɨ aivojɨɨbotɨ ficuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jaanaa saafi asaauboro nuuhi: Aivojɨɨbo, dinɨhɨbamɨ sahusedɨno janaanɨcɨ gaanahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jaaboco tollɨro iimusuubo: Ɨɨjoho sahuse cuumivahallɨvɨ aivojɨɨbotɨ diicaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jaanaa sifi asaauboro nuuhi: Aivojɨɨbo, jino dinɨhɨbamɨ filluchehufaño ificuhinɨno; ");
INSERT INTO bmrNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ɨco ñɨhicuguehi sihidɨ edeevaneguiiha. Jaabo ɨɨjoho ificutɨmañotɨ dɨɨcɨhi abasutɨrumañotɨ inoovataco dɨɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jaanegui ihaivojɨɨbo diiboco nuuhi: Imitɨno jeecɨvomɨnaafi dihiimaatɨro ɨco moonɨji, ɨɨro gaajacuuhi uujoho sihidɨ ejeevaaboro ificuutɨmañotɨ ɨɨcɨnoco abasutɨmañotɨ onoovasunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jaanegui, ¿collɨhi jana tañɨhɨbamɨco bancojafaño ficuuhinɨtɨhi uujoho uhuumiibo tañɨhɨbamɨ agaananoco fanooro agaayɨcɨjirunaaca? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iicojɨri iicaumoco nuubo: Diibeditɨ inɨhɨbamɨco mudumɨtɨɨcɨ. Jaamoro fahuseecɨdɨnoma iicaaboco mahacɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jaarunaa diito diiboco nuuhi: Aivojɨɨbo, diiboma fahuseecɨdɨno icacuuno, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jaarunaaca ihaivojɨɨbo diitoco nuuhi: Amɨɨhaico neehi: Iicanoma iicaaboco siino janaanɨcɨ acɨji. Jaanotɨ iinoma achahaabotɨ paryɨ iicarunogayɨco dumɨtɨɨcɨji. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jaanotɨ uujoho aivojɨɨbotɨ iicanoco iimeguehinɨtɨmo tamɨnaaco juuga mɨsɨvamoro tahɨmefeenevɨ magaisiraicɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jillɨ unuunobuunatɨ Jesu fuuhi Jerusale cuumijaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jaabo Betfaje, Betania icano cuuminotɨ fiitɨcuunaaca tollɨro Olivohono iicagajɨ fiitɨno iicacuudɨ miimɨsiicɨ ijɨɨbogomɨnaatɨsitɨ agalluuboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Mofoo joono ifiitɨcuumijaago. Jaamɨsi tuucuumivɨ mɨhɨfotomɨsi mahatyɨmeji burrogayɨ duujecɨnɨɨboco mɨɨhaiñooba diiberi ɨɨgotɨɨboco. Jaaboco misinaayumɨsiro mɨsɨva. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Amɨɨsico cajaatyohacho: ¿Collɨhi momoonɨhi? onoohachiijɨ, monoo: Mohaivojɨɨbo eneeneguiiha, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jaanegui diitɨsi ufuumɨsi atyɨmeteuhi paryɨ Jesu unuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jaamɨsi iburrogayɨco sinɨumɨsico abajato nuuhi: ¿Collɨhi moburroco misinɨɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jaanegui diitɨsi nuuhi: Mohaivojɨɨbo eneeneguiiha, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jaadɨ diiboco Jesujaago asatyuudɨ igaachehunoco iburrohallɨvɨ ificuumoro Jesuco diibohallɨvɨ casɨɨhacuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesu diiberi ofoobo ɨmega igaachehunoco jeebumoro feehicaumo jɨɨhaifaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jaabo Olivohono iicagajɨri guiino niituunaaca, paryɨɨcɨno miyaavogomɨnaa diibo dojɨcutɨ ufuumo tɨcovauhi sefano onoomo Moocaanico iimomo sihidɨ ejeevanoco aatyɨmeunoma iicamo ");
INSERT INTO bmrNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","neehicaumo: ¡Imicani Aivojɨɨbo, Mohaivojɨɨbo memeri asaabo! ¡Niquejefaño sajeebɨɨ! ¡Moocaanico mihimo! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jaanegui saatoho fariseomɨ diitofaño iicaumo nuuhi: Jɨɨbogomɨnaafi, didojɨcutɨ asaamoco dɨɨba, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jaanegui Jesu diitoco nuuhi: Amɨɨhaico neehi diito illɨɨvuruva guiisibano coovadiinamaaijirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jaabo Jerusale ifiitɨcuunoco aatyɨmeuboro tuucuumihallɨvɨ taaubo: ");
INSERT INTO bmrNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ɨɨjoho jaachiijɨ difucuvɨ ɨco sajeebɨɨco aacɨjirunoco gaajaruva sajeebɨɨ diicajirahi. Jaaruno ɨɨdi otoovomaño daatyɨmetɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Safucu ɨɨdi ɨdaasufucu gaseji dimɨnaa dihallɨdɨ emecuvejifucu dihallɨdɨ emecuvomoro fahɨgovatɨ ɨco moonɨji, ");
INSERT INTO bmrNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ɨco jiinɨjehallɨvɨ agañɨɨmoro dimiyamɨnaaco gaisiraicɨjimo. Jaamoro sababa dihallɨvɨ guiisibaco jeevesujitɨmo, Moocaani ɨco abaavafucuco agaajacɨtɨmaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jaaboro Jesu templojafaño ufuuboro tɨcovaubo toojafaño anaajemeque isivɨ agañɨɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jaaboro diitoco nuubo: Caatɨnɨhaamefaño jillɨ noono: Taaja Moocaanima iimaajareji, noono. Jaarujaco amɨɨhai nanivamɨnaa iijatɨro miminiiyuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jaabo Jesu fafucuvaacɨvɨro miyamɨnaaco templojafaño jɨɨbogooboro icahicauhi. Jaarunaa sacerdotemɨ aivojɨto, caatɨnɨmɨnaa, tuucuumi aivojɨto icamo diiboco iguijenɨqui ituma ɨfehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Jaarumo toonohallɨtɨ omoonɨjirunoco atyɨmehicautɨmo paryɨ miyamɨnaa diibo onoonoco uguubunɨcɨmo iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Safoono Jesu templojafaño icaubo miyamɨnaaco taajasubogoco ɨjɨɨbogoobo. Jaanaa gaseumo sacerdotemɨ aivojɨto, caatɨnɨmɨnaa, quillahuto icamo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jaamoro diiboco dilluumo: Mɨɨhaico dɨɨbogo, ¿mɨɨjoho iijɨtɨ jillɨ moonɨhi; mɨɨjoho ɨco eneeneguiiha? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jaanegui Jesu diitoco nuuhi: Uujoho tollɨro amɨɨhaico dilluji, uco mihiimusu: ");
INSERT INTO bmrNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Nacu, mɨɨjoho Juaco tajɨɨbauhi miyamɨnaaco initɨqui? ¿Moocaani, nacu miyamɨnaa? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jaarunaa diito sanomɨro noocasihicauhi: ¿Mɨllɨ fɨne meneeji? Moocaani tajɨɨbari munuuruva du: ¿Collɨhi jaanoco mimiyaavogotɨhi? mɨɨhaico neejiruubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jaanotɨ miyamɨnaa tajɨɨbari munuuruva, mɨɨhaico paryɨ miyamɨnaa guiisibaneri gaicaaujirahi, miyanotɨro Jua Moocaanifañodɨ ihiimaahicaunoco imiyaavogomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jaamoro nuumo: Magaajatɨhi. ¿Mɨɨjohohacho fɨne Juaco miyamɨnaaco initɨjinoco tajɨɨbauhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jaanegui Jesu diitoco nuuhi: Jɨɨ, tollɨro amɨɨhaico uujoho neejitɨhi mɨɨjoho tajɨɨbari omoonɨnoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jaadɨ Jesu miyamɨnaama ihiimaauboro jillɨ oovɨcɨuhi: Saafi miyamɨnaafi baacuco sihidɨ basuuhi. Jaaboro dudɨcamaajemɨnaaco toonoco utuumusuuboro. Sihɨ tehesino fuubo tahɨ gueenene iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Jaano ibaacu onoovacuudɨ iicojɨmɨnaafico galluubo diitojaago imañoonotɨ diibojaago diito igalluuqui. Jaaruuboco diito ahaamɨhicaumoro botɨɨboco dojɨcuvɨro diibojaa galluumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jaanegui toono abajaabo sifiico galluuhi. Jaaboco tollɨro ɨdicuno, unuumoro aamɨumo. Jaamoro botɨɨboco dojɨcuvɨro galluumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jaanegui siino bu sifiitɨ galluubo. Jaaruuboco ɨtɨhɨvasuumoro buhɨgovɨ gañɨɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jaanegui jari ihabajaabo nuuhi: ¿Mɨllɨ fɨne moonɨji? Agaijɨɨbo taseemeneque galluuji. Jaaboco aatyɨmemere fɨne bocɨguejimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jaaboco aatyɨmeumoro noocasiumo: Jaanɨ duhu imi toonoco agaayɨcɨjiibo. Masɨɨ miguijenɨqui. Jaadɨ jari mɨɨhai toono abajatotɨ mihicaji, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jaamoro tomañotɨ sihɨgovɨ asatyumoro diiboco guijenɨumo, nooboro Jesu diitoco dilluuhi: ¿Jaamoco mɨllɨ fɨne tofagui abajaabo diitoco fɨne moonɨji? ");
INSERT INTO bmrNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Asaaboro diito dudɨcamaajemɨnaaco ifinɨsuuboro toonoco sidudɨcamaajemɨnaaco acɨjiibo, nooboro. Jaanoco uguubuumoro nuumo: ¡Chaha, Moocaani tollɨ moonɨdino! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jaanegui diitoco Jesu emeecɨuboro nuuhi: ¿Nacu, mɨllɨ eneejiruno jino Caatɨnɨhaamefaño icahi? Jillɨ du noono: Guiisiri iijanoco eetavonɨcɨmo imiguiisibaco ɨtɨhɨsuumoro gañɨɨhi. Jaarunofaño saafi agaajaabo tobaco dojɨcuvɨro ɨcɨhi toba iminoco agaajamaño. Jaaboro aivo imimaño ficuubo, noono Caatɨnɨhaamefaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jaabahallɨvɨ aacotomo gafaryunamaaiji ɨdɨdaaheje. Jaanotɨ cajaatyohallɨvɨ toba aacotohachiijɨ diitoco quicheyɨɨcɨjiiba, nooboro. Jillɨ nuubo Jesu diiboco imiyaavogotɨmoco ufucu omoonɨjinoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jaasumiro Jesuco sacerdotemɨ aivojɨto, caatɨnɨmɨnaa icamo gaayɨcɨujirahi diitotɨ onoobo siinovɨ ohoovɨcɨɨboro eneehicaunoco agaajaumoro. Jaarumo miyamɨnaatɨ iguiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jaamoro saatohotɨ galluumo iimimobadɨ asaamoro diibo siibadɨ onoonoco uguubuumoro diiboco asatyomoro aivojɨɨbo usefaño ihacɨtequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Toonegui diito diiboco jillɨ dilluuhi: Jɨɨbogomɨnaafi, mɨɨhai magaajahi ɨɨjoho miyaanoco imino onooboro, miyaanoco ɨdɨɨbeguehicanoco; paryɨ miyamɨnaaco sabadɨro edeesɨcɨnɨɨboro Moocaani jɨɨhaitɨ imino dɨɨbeguehi. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mɨɨhaico dinoo: ¿Naa Cesar impuestoco ajaadusunoco majaaduji? ¿Nacu, majaadujitɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jaarunaa diito diibohallɨvɨ imitɨno ihiimaanoco agaajacɨuboro diitoco nuuhi: ¿Collɨhi uco mabañɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Eneecata uco saje nɨhɨbajetɨ mɨhɨfusu. ¿Nacu mɨɨjoho ɨme jana jino, jino imomo acaatɨnɨcɨnɨno icano? Jaanegui diito nuuhi: Aivojɨɨbo Cesarno, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jaanegui diitoco nuubo: Cesarno iicanoco Cesarco mahacɨ. Jaanotɨ Moocaaninoco Moocaanico mahacɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jaamaño diiboco ɨnɨsuurumo ɨcɨutɨmo mɨllɨ miyamɨnaafeenevɨ unuutɨmaño. Jaamoro sihidɨ jabafiituumo diitoco tollɨ iimusuuneri. Jaamoro llɨɨvɨ icacuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jaanobuunatɨ saatoho saduceomɨ iguijevecuumo siino buheetejitɨhi onoonɨcɨmo Jesujaago asaaumoro diiboco nuumo: ");
INSERT INTO bmrNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Jɨɨbogomɨnaafi, Moise mɨɨhaidi caatɨnɨuhi: Saafi nahabo mogai seemevatɨgo cojɨtɨ iiguijevehachiijɨ, inahabo ifibaijɨgoco ɨɨcɨɨboro diigoma iseemevaqui inahaboco ibuunanɨqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Safoono icaumo sahuse juugahusetɨ miimɨsiicɨ icamo saafi seemere. Jaamotɨ ihamiyaabo itɨconɨ taabavauhi. Jaaruubo guijeveuhi seemevatɨɨboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jaanegui saafi inahabo ifibaijɨgoco ɨcɨuhi. Jaaruubo tollɨro seemevatɨɨboro guijeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jaanegui jaano allɨvɨoobo diigoco ɨcɨurahi. Jaabadɨro famooro diigoma icauhi. Jaarumotɨ saafiiba seemevatɨmoro paryɨ guijeveumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jaanobuunatɨ bu tollɨro diigo guijeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jaamotɨ buheetefucu, ¿cajaanɨ taabaji fɨne? Famooro diigoco ataabavacuumotɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jaanegui Jesu diitoco nuuhi: Jino jiinɨjehallɨvɨ miyamɨnaa taabavacasihi. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jaanotɨ ufucu ubuheetemere siijiinɨjevɨ Moocaani eneeneri iimihusemaño ɨɨfotomo tahɨ taabavajitɨhi, iseemeque tajenɨjitɨmo icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Siino tahɨgo iguijevecuujitɨmaño Moocaani toomomɨnaabadɨro icacuujimo siino ubuheetecumaño Moocaani seemerucuuji iicamo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moise tollɨro mɨɨhaico gaajasuhi iguijevecuumo ubuheetejinoco Caatɨnɨhaamefaño ɨmohogayɨ ɨjɨgahicaumañovɨ. Jaamañovɨ noono: Aivojɨɨbo Moocaani Abraham, Isaac, Jacob icamo Aivojɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jaabo Moocaani iguijevecuumo aivojɨɨbo icatɨno ubuheeme Aivojɨɨbo. Jaabo Moocaanidi paryɨ diito buheeme, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jaanegui saatoho caatɨnɨmɨnaatɨ diiboco nuumo: Imino neehi, jɨɨbogomɨnaafi, ");
INSERT INTO bmrNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","noomoro siino diiboco dillucuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jaadɨ Jesu diitoco nuuhi: ¿Mɨllɨ jaamo Cristoco David iyaachi neehicahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mɨɨro David icaruubo Salmohaamefaño nuuhi: Mohaivojɨɨbo Moocaani Tahaivojɨɨbo Cristoco nuuhi: Tamiyanaagonovɨ casɨɨvo, ");
INSERT INTO bmrNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dimɨnaaco ditɨhaiguiino uujoho ificuunohachuta, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Mɨllɨ jaabo Cristo David iyaachi icajirahi, David bu icaruubo diiboco: Aivojɨɨbo, unuuno icanaaca? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jaanaaca famooro miyamɨnaa guubunɨcɨunaaca Jesu ijɨɨbogomɨnaaco nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Mehesɨcɨnɨ, caatɨnɨmɨnaatɨ caamovonoono gaachehunoma ɨɨgonoco iimoyɨɨcɨfiimotɨ. Bu tollɨro imoyɨɨcɨfimo naajetehasinovɨ diitoco iminoco sinagogajafaño ufuusumi imiya icaganocoro ujuvicamaaifimo machujafaño iimimañehejequere juvicamaaifimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tollɨro fibaijɨto iijanoco udumɨtɨɨcɨfiimo. Jaamo ɨɨfurumo gueenene Moocaanima iimaafimo utuvuusumo sitaaco ibañɨqui. Jaamo guiraajino cɨɨjɨgaifaño ijaadaco agaayɨcɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jaanaa Jesu templojafaño atyɨmeuhi sihidɨ inɨhɨbamɨma iicameheje Moocaanico aacɨmo ificufiinofaño ificuhicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jaabo atyɨmeuhi tollɨro ɨdaasuno fibaijɨgo mijeegayɨɨcɨco ificuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jaanegui Jesu nuuhi: Miyanotɨro amɨɨhaico neehi: Jaamo ɨdaasuno fibaijɨgo paryɨ famoova janaanɨcɨ acɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Jaanotɨ paryɨ diito, diitedi sihidɨ aatyuuvucuunotɨ acɨhi. Jaanotɨ diigo ihɨdaasutɨ iicanoco paryɨ acɨgo tooneri amachujirunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jaanaa saatoho templojatɨ iimaahicauhi iminoono guiisibano eheetavocɨnɨnotɨ, tollɨro fañoojaco Moocaanico ejeecɨvomo iminoono iimibachuhicaunotɨ icano. Jaanegui Jesu nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ufucu icajino paryɨ jino amɨɨhai mɨhɨɨfɨnɨcɨnoco ifinɨsujino, sababa guiisiba siibahallɨvɨ covovacafetejitɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jaanegui diiboco dilluumo: Jɨɨbogomɨnaafi, ¿cusumi fɨne tollɨ icajino? ¿Mɨllɨtɨ fɨne magaajaji toono ɨtɨcovacuunoco? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jaanegui Jesu diitoco nuuhi: Mehesɨcɨnɨ, amɨɨhaico sita bañɨdino, guiraajimo tamemeri asaano: Uujoho Cristo, tusumi mihicacuuhi, noomoro. Jaarumo dojɨcutɨ mefeedino. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jaamo mɨnaatɨ, sanomɨro omoonɨcasinotɨ icano muguubusumi mihiguetejirahana; itɨconɨ jillɨ icajino. Jaaruno ifinɨcuujino icatɨno, ");
INSERT INTO bmrNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","nooboro cuhubacafutuubo ihiimaaubo: Siijiinɨjeoto, siijiinɨjeotoma moonɨcasiji. Siijiinɨjeo aivojɨ, siijiinɨje aivojɨma moonɨcasiji. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jaasumi sihidɨ sefano jiinɨje maryɨbaji, ajeba icaji, sihidɨ fahɨgovavɨ guihuvano icaji, niquejefaño ñɨhicunoonoco mahatyɨmeji sihidɨ jeevanoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Jaano jillɨ iicajino ɨmega itɨconɨ amɨɨhaico agaayɨcɨmoro ɨdaasuno moonɨjimo amɨɨhaico satyejimo sinagogajanofaño imitɨno imoonɨqui amɨɨhaico ɨcɨvojaanɨmoro aivojɨto ɨmegavɨ satyejimo tamomohallɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jaamo ɨmefeenevɨ tamomoco mɨjɨɨbegueji. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jaanegui jillɨ momoonɨ, ɨmegavɨro: ¿Mɨllɨ fɨne iimusuji? noomoro mehesamaaidino. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tusumi jari amɨɨhaico uujoho gaaja iimaaco acɨji. Jaaneri amɨɨhai mɨnaa amɨɨhai iijɨco jenaaujitɨhi amɨɨhaico guiinonɨjitɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jaarunaa amɨɨhaico, amɨɨhai caanimɨ, amɨɨhai nahabomɨ, amɨɨhai yoto, amɨɨhai gataavomɨnaa icamo amɨɨhaico aivojɨtojaago satyeji. Jaamoco amɨɨhaitɨ saatohoco gaisiraicɨsujimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Paryɨ jiinɨjemɨnaa amɨɨhaico jɨɨheveji tamomohallɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jaarumo mɨllɨ mihicajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tollɨ icarunofa quehecuno mihicahachiijɨ ifinɨjitɨno fiivoma mihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jerusale cuumihallɨdɨ mɨnaa emecucɨnɨnoco mahatyɨmecuudɨ magaajacu tuucuumi ifinɨcuujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jaasumi Judea jiinɨjeri mihicamo ifagajɨnojaa magaa. Jaanotɨ Jerusale cuumiri mihicamo tuucuumitɨ buhɨgovɨ mofoo. Jaanotɨ tuucuumitɨ buhɨgovɨ mihicamo tuucuumijaa masaadino, ");
INSERT INTO bmrNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Caatɨnɨhaamefaño ɨdaasujino onoobadɨ tusumi icajino ɨdaasufucuno. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ɨdaasucani icajimo tusumi gaigoomɨ oovato iicamo, mɨfañotɨoseejema iicamo icano jiinɨjehallɨvɨ sihidɨ ɨdaasu iicajimaño jiinɨje miyamɨnaaco ñɨhicuno ahaamɨjineri. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jaanotɨ saatoho amocasifaño guijeveji. Jaanotɨ saatohoco fahɨgova jiinɨjenevɨ ɨcɨvojaanɨmoro satyejimo, tollɨro Jerusale cuumico siijiinɨje miyamɨnaa jiinɨjehallɨdɨ quicu quicu icaji diitoco Moocaani ejeevesunohachutahiica. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jaadɨ niquejeguiinodɨ jɨɨbogo icaji cuujeo nɨhɨbavɨ, fucuo nɨhɨbavɨ, meecɨrɨvɨ icano; jiinɨjehallɨvɨ paryɨ jiinɨjemɨnaaco ihesamaaje mɨtaji sihidɨ igotocɨnɨjimo muuai ñɨhicuno ojɨneri, ityuucai ñɨhicuno ojɨneri icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jaamo miyamɨnaa jiinɨjehallɨvɨ iicajinoco eesamaaimoro iñɨhicuri choomocɨnɨjimo, niquejeomitya icaruno maryɨbaji. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jaadɨ jari mahatyɨmeji uujoho Miyamɨnaafibadɨ Ifiivuubo aimuufaifeenedɨ mityama, aivojɨma icano asaanoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jineheje jillɨ iicacuudɨ caamoco memeecɨcu mataajasucafutucuujineguiiha, ");
INSERT INTO bmrNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","nooboro jillɨ oovɨcɨubo: Memeecɨ higuerahoco tollɨro paryɨ ɨmohonoco; ");
INSERT INTO bmrNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","bohono ahaamevanoco mahatyɨmesumi, amɨɨhairyo magaajafihi ficaba ifiitɨcunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jaabadɨro jino onoonoco mahatyɨmecuudɨ magaajacu Moocaani aivojɨ ifiitɨcunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Miyanotɨro amɨɨhaico neehi: Paryɨ jino iicanoco tusumioto aatyɨmeme guijevejitɨhiica, ");
INSERT INTO bmrNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","niqueje, jiinɨje icano finɨjirahi. Jaanotɨ taajɨ sɨcamañovɨ fatyejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jaanegui mehesɨcɨnɨ, iimitɨnofeenedɨ amɨɨhai jeebɨɨ cuhufetedino, guirihicavono jiinɨje busumije imoyɨɨcɨ icano guiinodɨ tufucu amɨɨhaivɨ mehesɨcɨnɨtɨnaaca gasedino, ");
INSERT INTO bmrNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","amɨɨhaihallɨvɨ tacuraba gaajacɨratɨno aacotonɨcɨbadɨ. Jillɨ tufucu gaseji fahɨgova jiinɨjehallɨri iicamohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jaanegui mihimibaicɨnɨcu. Jaamoro fahiijɨvaro Moocaanima mihiimaa, paryɨ jino iicajinotɨ mataajaji. Jaamo uujoho Miyamɨnaafibadɨ Ifiivuubo ɨmefeenevɨ mɨhɨfeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jaabo Jesu cuuje templojafaño jɨɨbeguehicaubo. Jaanotɨ mihiijɨcuudɨ Olivohono iicagajɨjaago ofooboro tahɨ icahicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jaanaa miyamɨnaa fucugayɨro templojafaño gasehicauhi diiboco iguubunɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jaanaaca ijɨcutama achahano maahunoco amachufino Pascua jɨɨbaimo fiitɨcuunaaca, ");
INSERT INTO bmrNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","sacerdotemɨ aivojɨto, caatɨnɨmɨnaa icamo moonɨhicauhi: ¿Mɨllɨtɨ fɨne magaicaauji? noomoro Jesuco igaicaauqui. Jaarumo miyamɨnaaco iguihicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jaanaa Satanas jɨcafutuuhi Juda Iscariote jeebɨɨfaño Jesu minɨsumɨnaa fahuseecɨ motɨhaitɨ miimɨsiicɨ icamoobofaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jaaboro sacerdotemɨ aivojɨto, temploja aivojɨto icamojaago ufuuboro diitoma iimaatuubo Jesuco diitoco ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jaaneri imo imo iicaumoro diibo Judaco nɨhɨbamɨco acɨguumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jaanegui: Jii, unuuboro tɨcovaubo iguiinuubo, ¿mɨllɨ fɨne diiboco diitoco acɨji, miyamɨnaa chahanaaca? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jaanaa ijuurisutama achahano maahunoco amachufino jɨɨbaimo icacuuhi Pascua ovejaco agaicaaujifucu. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jaanaa Jesu galluuhi Pedro, Jua icamɨsico: Pascua machutaaco mohɨme mihimibachuto, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jaanegui diitɨsi dilluuhi: ¿Conoovɨ diimeguehi mihimibachunoco? noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jaanegui Jesu iimusuuhi: Cuumivɨ mɨhɨfotoodɨ saafiico mahatyɨmeji ɨcɨñuuri nɨfaihuco asatyooboco. Jaabo dojɨcutɨ mofoo iijafaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jaamɨsiro toojao aivojɨɨboco monoo: Mohaivojɨɨbo jillɨ neehi: ¿Comecufaño tajɨɨbogomɨnaama Pascua machutaaco machuji? noobo, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jaadɨ amɨɨsico ɨɨfusujiibo iguiraamecu, caamovohɨ iicamecu, imibachucɨnɨcumecuco. Jaamecufaño meheetavo mamachuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jaanegui ufuumɨsi paryɨ Jesu unuubadɨ icanoco aatyɨmeumɨsiro toonovɨ Pascua machutaaco eetavuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jaanaa amachucuujidɨ Jesu iminɨsumɨnaama casɨɨvuuhi imachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jaanaa Jesu diitoco nuuhi: Guiraacani imeguehi, amɨɨhaima Pascua machutaaco amachunoco iguijevecuujino ɨmega. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Amɨɨhaico neehi: Siino Pascua jɨɨbaimo machuco machucuujitɨhi. Jari siino Moocaani aivojɨfaño meheetavoodɨ, ");
INSERT INTO bmrNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","nooboro ihadutahilluco agaayɨcɨuboro Moocaanima iimaaubo. Jaadɨ nuubo: Jinooco mɨhɨcɨmoro mɨhɨfocasi ");
INSERT INTO bmrNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","amɨɨhaico neehi: Jisumitɨro siino aducujitɨhi baacufaihuco Moocaani aivojɨ agasetɨnohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jaadɨ imaahuco agaayɨcɨuboro Moocaanima iimaaubo. Jaadɨ iquisicuuboro diitoco acɨubo jillɨ nooboro: Jino tafi amɨɨhaihallɨvɨ aacɨcafetejino jillɨ momoonɨ. Jaamo uco jabajeevetɨmo mihicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jaanaa amachuunobuunatɨ tollɨro ihadutahilluco agaayɨcɨuboro nuuhi: Jihillu bohono iijɨ iicajinoco tatyɨɨjeheri eetavono tatyɨɨjoho amɨɨhaihallɨvɨ agañɨɨcafotono. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jaarunaa jino amɨɨhaitɨ uco aacɨjiibo igaicaauqui tacojɨri icahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jaarunaa uujoho Miyamɨnaafibadɨ Ifiivuubo uuditɨ unuucuubadɨ feehi. Jaarunaa ɨdaasucani iicajiibo uco aacɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jaanegui tɨcovaumo idillucasiumo: ¿Cajaanɨ fɨne aacɨjiibo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jaanaa ijɨɨbogomɨnaa noocasihicauhi: ¿Cajaanɨji mɨɨhaitɨ imiyaabo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jaanegui Jesu diitoco nuuhi: Siicuumijeoto judiomɨ iicatɨmo aivojɨto ɨdaasugotɨmo sefano tajɨɨbanɨcɨhi. Jaamo diito aivojɨtoco imihusefiimo, noonɨcɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jaanotɨ amɨɨhai tollɨ mihicajitɨhi. Jaanotɨ siibadɨro amɨɨhai mihicaji, amɨɨhaifañotɨ imiyaabotɨ iicaqui jillɨ saatoho jeecɨvomɨnaafitɨ miminifeteji. Jaabadɨro atajɨɨbaabo jeecɨvomɨnaafitɨ minifeteji. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Nacu, mɨɨjoho imiyaabo, acasɨɨvooboro amachufiibo, nacu ejeecɨvefiibo? ¿Etɨ acasɨɨvefiibo? Jaarunaa uujoho amɨɨhaifeeneri icahi jeecɨvomɨnaafibadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Amɨɨhai uuma mihicafihi uco ɨnɨsunehejefañodɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jaanegui uujoho amɨɨhaico aivojɨco acɨji uco guihirubi aacɨhinɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jaamo mamachuhi, mahaduhi icano uuma jahɨgo tahaivojɨfaño. Jaamoro aivojɨɨbo icagafaño macasɨɨvomoro matajɨɨbahi Israel cuumino fahuseecɨ motɨhaitɨ miicuumiicɨ icanohallɨvɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jaaboro nuubo Aivojɨɨbo: Simon, Simon, mehesɨcɨnɨ jino Satanas amɨɨhaico idillunoco siinoco agañunɨcɨbadɨ ɨdaasuno amɨɨhaico igañucuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Jaarunofaño uujoho Moocaanima dihallɨvɨ iimaahi dimiyaavogo ɨɨtɨ finɨtɨno iicaqui. Jaabo ɨɨjoho siino imiyaavogodɨ dinahabomɨco quehecutusu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jaanegui Simon diiboco nuuhi: Aivojɨɨbo imibaicɨnɨcuuhi ɨɨma cɨvojafaño feequi, ɨɨma guijevequi icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jaanegui Jesu diiboco nuuhi: Pedro ɨco neehi: Jisumiro catava ojɨtɨɨbaacaro mifoocɨ, safo icano uco tuunamaaiji; uco gaajaruubo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jaadɨ Jesu diitoco nuuhi: Amɨɨhaico dureecuma, nɨhɨbamɨma, lleegucuma, tɨhaipaajema icano masatyedino, nooboro agalluusumi: ¿Nacu fanoova amɨɨhaidi cuujɨvaachuuhi? nooboro. Jaanegui diito: Chahano, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jaanegui diitoco nuubo: Jaanotɨ jisumi tollɨ icatɨno dureecuma, nɨhɨbamɨ lleegucuma icano mihicaabo masatyo. Jaanotɨ aamɨgama machahaabo amɨɨhai caamoojaco manaajemere aamɨgatɨ mɨhɨcɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Amɨɨhaico neehi: Uutɨ Caatɨnɨhaamefaño jillɨ onoono icaji: Iimitɨmofeenevɨ ficucafetejiibo, onoono, paryɨ uuditɨ onoono tollɨ icaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jaanegui diito nuuhi: Aivojɨɨbo, miigaacɨma mihicahi, noomoro. Jaanegui diibo nuuhi: Toonovɨrucu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jaadɨ Jesu toonotɨ fuuhi Olivohono iicagajɨjaago iicanɨcɨbadɨ. Jaaboma ijɨɨbogomɨnaa fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jaamo tomañovɨ ɨɨfutuudɨ diitoco nuubo: Moocaanima mihiimaa, ɨjɨ ɨnɨsunofaño mahaquetedino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jaadɨ Jesu diitotɨ sihɨgovɨ fuuhi guiisibaco maganicarunohachuta. Jaaboro memuɨɨvuubo Moocaanima ihiimaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jillɨ nooboro: Guihi, idiimogohachiijɨ jino ɨdaasuno iicajinotɨ uco taajasu. Jaaruno uujoho iimogobadɨ icatɨno, jaafa ɨɨjoho idiimogobadɨro icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jaanaaca diibojaago Moocaani toomomɨnaafi niquejefañotɨ saauhi diiboco isefatusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jaabo sihidɨro ɨɨdaasuvooboro Moocaanima quehecuno iimaahicaubo. Jaanaaca ituga jiinɨjehallɨvɨ aquetehicauhi tɨɨjoho ocooyɨnobadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jaabo Moocaanima ihiimaaunotɨ agañiivuuboro ijɨɨbogomɨnaajaago fuuhi. Jaamo ihɨdaasuri cɨgacuumoco atyɨmeteubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jaanegui diitoco nuubo: ¿Collɨhi mɨcɨgahi? Magañiivomoro Moocaanima mihiimaa ɨjɨ ɨnɨsunofaño mahaquetedino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu ihiimaaunaacaro sihidɨ miyamɨnaa gaseuhi. Jaamoco sɨɨguubo Juda onoobo Jesu jɨɨbogomɨnaatɨ fahuseecɨ motɨhaitɨ miimɨsiicɨdɨmo iicahicaurumoobo. Jaabo Jesujaago fiitɨvuuhi diiboco inɨnɨɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jaaboco Jesu nuuhi: ¿Juda, tollɨ ɨnɨnɨɨcɨɨboro Miyamɨnaafibadɨ Ifiivuuboco daacɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jaabo Jesuma iicaumo tollɨ iicanoco aatyɨmeumoro Jesuco dilluuhi: ¿Aivojɨɨbo, aamɨganeri diitoco momoonɨji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jaamotɨ saafi sacerdotemɨ jeecɨvomɨnaafico omoonɨubo buiyaacuuhi imiyanaago nɨjɨmeehuco. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jaarunaa Jesu diitoco nuuhi: Musuufenɨcu jaafa icacuumo, nooboro sacerdote jeecɨvomɨnaafi nɨjɨmeehuco ududɨɨcɨuneri buheesuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jaaboro sacerdotemɨ aivojɨto, temploja aivojɨto, quillahuto icamo igaiyɨɨcɨqui asaaumoco nuubo: Tatyɨcovodɨ amɨɨhai masaahi aamɨganoma, cudaahenema icano nanivamɨnaafico mihicanɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Amɨɨhaifeeneri fahiijɨvaro templojafaño icahicarahi. Jaaruuboco uco magaayɨcɨhicatɨhi. Jaarunaa jisumi amɨɨhai imitɨmɨnaa tollɨ momoonɨnɨcɨhi jino ɨcɨvono mityaguiino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jaasumiro Jesuco agaayɨcɨumoro satyuumo sacerdotemɨ aivojɨɨbo iijajaago. Jaabo dojɨcutɨ Pedro tehesinotɨ ɨɨfɨnɨcɨɨboro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jaamoro ihaivojɨɨbo iija goohasifeenevɨ cɨɨjɨgaico eebasuumoro casɨɨcamaaiumo. Jaamofeenevɨ tollɨro Pedro casɨɨvuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jaaboco jeecɨvomɨnaago cɨɨjɨgaijɨnivɨ gɨcɨnɨɨboco gueenene ɨhɨɨfɨnɨcɨugoro nuuhi: Jaanɨ tollɨro diiboma iicahicaabo, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Jaarunaa Pedro utuunamaaibo nuuhi: Gaigo, uujoho diiboco gaajatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Jaanobuunatɨ tollɨro saafi diiboco aatyɨmeuboro diiboco nuuhi: Ɨɨjoho tollɨro diitoobo, nooboro. Jaarunaa Pedro diiboco nuuhi: Chahano, uujoho diitoobo icatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jaadɨ sano nɨhɨba oovobuunatɨ saafi diiboco jenaauhi jillɨ nooboro: Jaanɨ miyaano diiboma iicahicahinɨɨbo Galileaoobo iicamaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Jaanegui Pedro nuuhi: Chahano, uujoho gaajatɨhi ɨɨjoho toono onoonoco, nooboro. Jaasumiro Pedro ihiimaaunaaca catava ojɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jaanegui Aivojɨɨbo Jesu Pedrojaagovɨ iminifutuuboro diiboco meecɨubo. Jaaneri Pedro esafutuuhi Aivojɨɨbo Jesu diiboco: Jaachiijɨ catava ojɨtɨnaacaro mifoocɨ, safo icano uco tuunamaaiji, nooboro unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jaaboro Pedro ufuuboro sihidɨ aivono taauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jaanaa Jesuco utuumuumo diiboco edejecuumoro aamɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ihaallɨɨnoco gaachehubaryuri isiyaacuumoro ihɨmeque gabacuhicauhi: Gaajacɨ. ¿Naa mɨɨjoho ɨco aamɨhi? noomoro ");
INSERT INTO bmrNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","famañovaje diiboco ɨɨbahicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jaanaa eseseeveudɨ igaivuumo judiomɨ quillahuto, sacerdotemɨ aivojɨto, caatɨnɨmɨnaa icamo. Jaamoro Jesuco satyuumo fagomɨnaa ɨmegavɨ. Jaamoro Jesuco dilluumo: ");
INSERT INTO bmrNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mɨɨhaico dinoo, ¿naa miya ɨɨjoho Cristo? noomoro. Jaanegui diitoco iimusuubo: ¿Amɨɨhaico jɨɨhɨ, nuuruva nacu mimiyaaveguejitɨrahi? ");
INSERT INTO bmrNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","¿Jaanotɨ amɨɨhaico nuuruva nacu uuma mihiimaanoco mihimeguejitɨrahi, uco misinaayujitɨrahi icano? ");
INSERT INTO bmrNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Jisumitɨro uujoho Miyamɨnaafibadɨ Ifiivuubo gɨcɨnɨji Moocaani imityaabo miyanaagonovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jaanegui diiboco famooro dilluumo: Jaanegui, ¿ɨɨjoho Moocaani Seemene? noomoro. Jaanegui Jesu diitoco nuuhi: Jɨɨhɨ, amɨɨhai monoobadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jaanegui diito nuuhi: ¿Collɨhi bu sita onoonoco mihimeguejirahi? Mɨɨhairyo muguubucuuhi iijɨri onoonoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jaamo famooro agañiivuumoro Jesuco satyuumo Pilato ɨmegavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jaamoro tɨcovaumo diibohallɨvɨ ihiimaamo: Jaanɨco mɨɨhai mahatyɨmehi, muucuumico ñaaɨsuuboco. Jaaboro neehicaabo: Cesarco impuestoco majaadudino uujoho Aivojɨɨbo Cristo icahi, neehicaabo, noomoro neehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jaanegui Pilato diiboco dilluuhi: ¿Naava ɨɨjoho judiomɨ Aivojɨɨbo? nooboro. Jaanegui Jesu diiboco iimusuuhi: Jɨɨhɨ, ɨɨjoho toono onoobadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jaanegui sacerdotemɨ aivojɨto, miyamɨnaa icamoco Pilato nuuhi: Jaanɨvɨ iimitɨnoco aivo atyɨmetɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jaarunaa diito janaanɨcɨ nuuhi: Paryɨ Judea jiinɨje miyamɨnaaco ñaaɨsuhicaabo ijɨɨbegueri Galileavɨ itɨconɨhinɨɨbo, juu icacuuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jaanoco Pilato uguubuuboro dilluuhi: ¿Nacu diibo Galileaoobo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jaanegui diiboco: Jɨɨhɨ, unuunegui Jesuco galluubo Galilea aivojɨɨbo Herodejaago tusumi Jerusale cuumivɨ agaseubojaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jaabo Herode Jesuco aatyɨmeuboro imo imo minifutuuhi sɨɨcɨjetɨro Jesuditɨ ihiimaanoco guubuhicaubo. Jaaboro diiboco imeguehicaubo aatyɨmeneque sihidɨ ejeevanoco Jesu omoonɨnoco ihatyɨmequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jaaboro Jesuco sihidɨ dilluhicaubo. Jaarunaa Jesu diiboco iimusuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tollɨro tomañeri icaumo sacerdotemɨ aivojɨto, caatɨnɨmɨnaa icamo diiboco iguijenɨsuqui mityano iimaahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jaanegui Herode ihamocasimɨnaama diiboco: Jillɨ mɨhɨɨfoobo, noomoro imitɨno moonɨumo. Jaamoro diiboco edejecumo aivojɨɨbo gaachehubadɨ iimichehufaño jɨɨhacuumo. Jaaboco dojɨcuvɨro Herode Pilatojaago galluuhi. Jaasumitɨ jari Herode Pilatoma imitocasiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jaanotɨ itɨconɨ jɨɨhevecasihicaumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jaanegui sacerdotemɨ aivojɨto, tuucuumi aivojɨto, miyamɨnaa icamoco Pilato igaiyɨɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jaaboro diitoco nuuhi: Amɨɨhai jaanɨco tajaa mɨsɨvahinɨhi: Miyamɨnaaco ñaaɨsuubo, noomoro. Jaaboco imino dillucuurahi amɨɨhai ɨmefeenevɨ. Amɨɨhairyo magaajacuuhi diibeditɨ: Imitɨɨbo, noomoro monoonoco aatyɨmetɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jaabadɨro bu Herode iimitɨnobaaco aatyɨmetɨɨbo siino tajaa sɨvasuuhi magaaja mɨllɨtɨ bu miguijenɨjirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jillɨ ahaamɨɨboro diiboco sinaayuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jaabo Pilato jɨɨbaimosumi saafi cɨvojamɨnaafitɨ sinaayuujirahi miyamɨnaaco imono iicasuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jaarunaa famooro sano sefano neehicauhi: ¡Diiboco guijenɨ! ¡Barrabacoro sinaayu! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jaabo Barrabaco cɨvojaanɨumo tuucuumi miyamɨnaaco aivojɨtohallɨvɨ añaaɨsuuneguiiha, tollɨro bu saatohoco agaicaauneguiiha icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jaarunaa Pilato Jesuco isinaayunoco iimuguuboro siino miyamɨnaama iimaauruubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Jaarunaa diito janaanɨcɨ sefano nuumo: ¡Ɨmohobujehallɨvɨ tetecu! ¡Tetecu! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jaarunaa siino Pilato diitoco nuuhi: ¿Nacu, jineje iimitɨnoco moonɨɨbo? Diibovɨ atyɨmetɨhi iimitɨnoco toonohallɨtɨ agaicaaujirunoco. Jillɨ ahaamɨɨboro diiboco sinaayuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Jaarunaaca diito jenaauhi idillumo sefano noomoro: Ɨmohobujehallɨvɨ itetecuqui diito sacerdotemɨ aivojɨto iicamo sihidɨ ocoovadiinamaaiumaño diito iijɨ diibohallɨvɨ fatyuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jaanegui Pilato nuuhi: Diito onoobadɨ imoonɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jaaboro sinaayusuubo cɨvojamɨnaafico diito idilluuboco añaaɨsuunotɨ, agaicaaunotɨ icano ɨcɨvojaanɨuboco. Jaaboro Jesuco diito usefaño jeevesuubo diito iimuguubadɨ imoonɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jaamoro Jesuco itetecuqui satyuumo. Jaanaaca saafi Cirene cuumioobo Simon onoobo buhɨgotɨ asaauboco agaayɨcɨumoro iguijeve ɨmohobujeque iibɨsuumo Jesu dojɨcutɨ isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jaabo dojɨcutɨ sihidɨ miyamɨnaa feehicauhi. Jaamofeenedɨ sihidɨ gaigoomɨ taamoro gaibacasimoro feehicauhi diibo ɨdaasuri. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jaamoco Jesu emeecɨuboro diitoco nuuhi: Jerusale gaigoomɨ, uuri mataajirahana. Amɨɨhaihallɨvɨro mataa, amɨɨhai seemehallɨvɨ icano ");
INSERT INTO bmrNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ufucu gasejifucu: Imicani icamo achibamɨ, eseemevatatɨno jeebɨɨno, iisutɨno mɨfañoono icano, meneejifucu. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jaasumi miyamɨnaa tɨcovaji onoomo: Ifagajɨno mohallɨvɨ daacoto, ifabaɨno mohallɨvɨ fabaavo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jaamo imihuseemeque jillɨ omoonɨno ɨdaasurahi. Jaarunofaño fɨne imitɨnoco eheetavomoco janaanɨcɨ ɨdaasuno moonɨji, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jaamo bu, tollɨro satyuumo miimɨsiicɨ nanivamɨnaatɨsico Jesuma sano igaicaauqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jaamo ɨfutuuhi nigaɨpaajebaɨ onoomañovɨ. Jaamoro tomañovɨ Jesuco tetecuumo. Tollɨro nanivamɨnaatɨsico imiyanaagonovɨ saafi, inaninaagonovɨ saafi icano tetecuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jaanaa Jesu nuuhi: Guihi, diitohallɨvɨ jino omoonɨno jaadabadɨ iicanoco ficuudino, jillɨ gaajatɨmo omoonɨmaño, nooboro. Jaanaaca amocasimɨnaa Jesu gaachehuhallɨvɨ suerteque eetavuumo: ¿Naa mɨɨjoho ɨcɨji? onoomaño. Jaadɨ ɨfocasiumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jaanaa miyamɨnaa diiboco ihaivojɨtoma ɨhɨɨfɨnɨcɨmoro dejecuhicauhi: Sitaaco taajasuubo; Eneecata jisumi jaafa iinoro taajaabo miyaano Cristo Moocaani ɨɨcɨubo iicahachiijɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tollɨro amocasimɨnaa edejecumoro diibovɨ ifiitɨvomoro ɨdicuno vinoco diiboco isuurahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jaamoro diiboco neehicaumo: Miyaano ɨɨjoho judiomɨ Aivojɨɨbo idiicahachiijɨ, ɨɨro difiico taajasu, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jaabo nigaɨhallɨvɨ ficuumo acaatɨnɨumoro JAANƗ JUDIOMƗ AIVOJƗƗBO, onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jaanaa saafi nanivamɨnaafi saanaagonovɨ etetecucɨnɨubo Jesuco ɨɨbahicauhi: Miyaano ɨɨjoho Cristo idiicahachiijɨ ɨɨro difiico taajasu, tollɨro bu mɨsico taajasu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jaarunaa saafi diiboco ɨɨbauhi: ¿Aivo ɨɨjoho Moocaanico ñɨhicugotɨhi, tobadɨro ɨco omoonɨnoco gaajatɨɨbo? ");
INSERT INTO bmrNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mɨsico naha jino miyaanohallɨtɨ jillɨ moonɨmo, miyaano imitɨno momoonɨuno jaadaco mɨhɨcɨhi. Jaanotɨ diibo aivo imitɨno moonɨtɨruubo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jaadɨ Jesuco nuubo: Jesu, dihaivojɨvɨ ɨdɨɨfotoodɨ uco desafoto, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jaanegui Jesu diiboco nuuhi: Miyanotɨro ɨco neehi: Jaachiijɨro ɨɨjoho uuma diicaji imimañovɨ Moocaanico imiyaavogomo ofoomañovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jaanaaca gadɨcɨɨba mihicacuuhi. Jaarunaa paryɨ jiinɨje cɨvono minifutuuhi; jaano jari ɨmohonohallɨtɨ nɨhɨba icaaberi seseeteuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jaano ɨcɨvutuusumi nɨhɨba jabaavuuhi. Jaanaaca temploja ofoboocɨnɨuchehu gaachehubaryu tyɨgaba feenedɨ gallivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jaanaaca Jesu gaihivuuhi: Guihi, dihusefaño tagaijaco gaayɨcɨ, nooboro chuumucuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jaanoco romanomɨ amocasimɨnaa aivojɨɨbo tonehejeque aatyɨmeuboro Moocaanico imuubo: Miyaano jahi jaanɨ imihuseebe, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jaanoco bu tollɨro miyamɨnaa aatyɨmeumoro fuuhi icɨɨdɨgameehuco aamɨmoro, sihidɨ ɨdaasuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jaanotɨ paryɨ Jesu gataavomɨnaa, tollɨro gaigoomɨ Galileatɨ diibo dojɨcutɨ asaaumo icamo icauhi tehesinotɨ tonehejeque ɨhɨɨfɨnɨcɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jaanaa icaubo saafi iimihuseebe imitɨno iicatatɨɨbo Jose Arimatea cuumioobo onoobo Judea jiinɨjeri iicacuumi. Jaabo judiomɨ fagomɨnaatɨoobou. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jaabo Jose Moocaani aivojɨ asaaujinoco teemehicaubo. Jaamaño paryɨ fagomɨnaa omoonɨunofaño icautɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jaaboro Pilatojaago ufuuboro diiboco Jesu ifiico dilluubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jaadɨ Jesu ifiico ihɨmohotɨ iniitusuuboro gaachehuri iimibocɨuboro cɨɨhojɨ guiisigajɨfaño eseediuhojɨfaño cɨɨubo bohojɨ mɨɨhaiñooba ɨcɨɨrautɨhojɨfaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jaano sifucutɨ jaguisɨ iicacuujineguiiha tufucuri imibaivucuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jaanaaca Jesuma Galileatɨ asaaumo ufuumoro Jesuco ɨcɨɨunoco meecɨtuuhi. Jaamo imino atyɨmeuhi diibo ifi aacaumañoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jaamo iijanojaa ufuumoro facɨcɨfaihuno, bu facɨcɨ dɨɨrɨbano icanoco iimibaivuumo. Jaamoro jaguisɨfucu jaguisɨumo Moise tajɨɨba onoobadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jaanaa ajaguisɨuno sifucutɨ gaigoomɨ cɨvonotɨro fuuhi Jesu cɨɨhojɨjaago ifacɨcɨnoco iimibachuunoma ");
INSERT INTO bmrNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jaamo ɨɨfutuumo atyɨmeuhi toojɨco afabaacuuba iguiisiba sihɨgovɨ icacuubaco. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jaamoro toojɨfaño ufuumo Aivojɨɨbo Jesu ifiico atyɨmecuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jaaneri iigutuumoro: ¿Mɨllɨ momoonɨji? noocasiumo. Jaamo atyɨmeuhi miimɨsiicɨ gaifiimɨsi diito cojɨvɨ julleecɨnɨmɨsico arɨcunoono gaachehunofaño jɨcucuucɨnɨmɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jaamɨsitɨ iigutuumoro guiinovɨ jiinɨjehallɨvɨ javucamaaiumo. Jaamoco diitɨsi nuuhi: ¿Collɨhi amɨɨhai ubuheetecuuboco iguijeveme iicamañoco miguiinehi? ");
INSERT INTO bmrNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jineeri chahacuubo, buheetecuubo. Mehesafoto Galileari iicausumi amɨɨhaico unuunoco: ");
INSERT INTO bmrNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Miyamɨnaafibadɨ Ifiivuubo acɨcafeteji imitɨ miyamɨnaa usefaño. Jaaboco ɨmohovɨ tetecujimo. Jaaruubo mifucucɨ, safucu icanotɨ siino buheeteji, unuunoco, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jaanegui tofigueje esafutuuhi Jesu unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jaamo icɨɨhojɨjaagotɨ uhuumiumoro paryɨ toonotɨ jɨɨbogovauhi Jesu minɨsumɨnaaco fahuseecɨ motɨhaitɨ saafi ɨdɨɨmoco, tollɨro paryɨ saatohoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jaanoco Jesu minɨsumɨnaaco jɨɨbuguumo Maria Magdalena onoogo, bu Juana, bu Maria Jacoobo seejɨ, bu saafigueje icamo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jaarunoco Jesu minɨsumɨnaa: Jillɨ fɨne jeegavomo, noomoro miyaavuguutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Jaarunaa Pedro fuuhi ijinafatyuuboro Jesu cɨɨhojɨjaago. Jaaboro ɨdɨjɨɨvuuboro toojɨfañoco emeecɨubo atyɨmeuhi tochehuri iminɨuchehu uufocori acaunoco. Jaaneri ajabafiituuboro uumiubo dojɨcuvɨro iijajaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jaanaa tufucu diitotɨ miimɨsiicɨ fuuhi Emaus onoocuumijaago; Jerusaletɨ once kilometrohachuta iicacuumijaago. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jaamɨsi ufuumɨsi paryɨ tooneri iimaamɨsiro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jaamɨsiro ihiimaamɨsiro dillucasihicauhi. Jaanaaca diiboro Jesu diitɨsijaa asaauboro diitɨsima fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jaaboco atyɨmecuurumɨsi gaajahicautɨhi Jesu iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jaanegui Jesu diitɨsico dilluuhi: ¿Jinejeque midillucasihicahi jɨɨhairi mofoomɨsi? ¿Collɨhi ɨdaasuno mihicahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jaanegui diitɨsitɨ Cleofas onoobo iimusuuhi: Paryɨ miyamɨnaa gaajahi Jerusalevɨ jisumiro iicahinɨnoco. Jaanotɨ ɨɨjoho ɨdɨɨboro tuucuumiri diicaruubo gaajatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jaanegui diitɨsico nuubo: ¿Nacu mɨllɨ icahinɨno? nooboro. Jaanegui diiboco nuumɨsi: Etɨ bu Jesu Nazareooboco omoonɨhinɨnoco; Jaabuu Moocaani iimaamɨnaafi, paryɨ miyamɨnaa ɨmefeenevɨ, bu Moocaani ɨmefeenevɨ ihiimaanotɨ, bu paryɨ omoonɨhicahinɨnotɨ icano sihidɨ ejeevahinɨɨboco. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jaaboco sacerdotemɨ aivojɨto, mohaivojɨto icamo diiboco agaayɨcɨhinɨmoro acɨhinɨhi: Imino diibo iguijevene, noomoro tetecusuumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jaanotɨ mɨɨhai meteemehicaurahi Israel jiinɨjemɨnaaco itaajasuqui. Jaarunaa paryɨ tollɨ omoonɨnobuunatɨ jino mifucucɨ, safucu icano mihicacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jaarunaaca mɨɨhaitɨ saatoho gaigoomɨ fucuro diibo cɨɨhojɨco emeecɨjeme mɨɨhaico igutusuhi, ");
INSERT INTO bmrNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","toojɨfaño diibo ifiico aatyɨmetɨneguiiha mɨɨhaico jɨɨbogovahi Moocaani toomomɨnaaco aatyɨmeme diitoco: Jesu buheehi, onoonoco mɨɨhaico ɨjɨɨbegueneri. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jaaneguiiha mɨɨhaitɨ saatoho toojɨco emeecɨjeme gaigoomɨ onoobadɨ icanoco atyɨmehi. Jaarumo Jesuco atyɨmetɨhi, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jaanegui Jesu diitɨsico nuuhi: ¡Gaajatɨcanimɨsi, fɨne amɨɨsi goovatɨcani mimiyaaveguehi Moocaani iimaamɨnaa unuunoco! ");
INSERT INTO bmrNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Nacu itɨconɨ jinehejeri ɨdaasuno icajitɨruubo Cristo ihaivojɨfaño efeejino ɨmega? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tɨconɨubo paryɨ Caatɨnɨhaamefaño diibeditɨ onoonehejeque diitɨsico ɨjɨɨbogoobo Moise aamenetɨ ɨtɨconɨubo paryɨ Moocaani iimaamɨnaa aamenevɨ imivusuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jaamo tuucuumivɨ ɨɨfutucuuneguiiha Jesu sanotɨcovoro fatyuujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Jaarunaa diitɨsi diiboco fiitɨhicauhi: Mɨsima jinoovɨro fitafoto mihiijɨcuuhi cɨvucuuno, noomɨsiro. Jaaneguiiha Jesu fitafutuuhi diitɨsima iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jaadɨ imachuqui diitɨsima acasɨɨvuuboro imaahuco agaayɨcɨuboro toonohallɨvɨ Moocaanima iimaaubo. Jaadɨ iquisicuuboro diitɨsico acɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jaasumi jari diitɨsico ihaallɨɨno imino faayacafutuuhi. Jaadɨ jari diiboco gaajacɨumɨsi. Jaarunaa diitɨsi ɨmefeenevɨ cuucahacho minifutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jaanegui diitɨsi noocasiuhi: ¿Etɨ miyaano mojeebɨɨno imono icahicahinɨhi jɨɨhairi masaasumi Caatɨnɨhaamefaño onoonehejeque mɨsico jɨɨbogooboro asaahicasumi? noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Siino gueenene icatɨmɨsiro uumicuumɨsi Jerusalejaago. Jaamɨsi atyɨmeuhi Jesu minɨsumɨnaa fahuseecɨ, siino saafi icamo saatoho igataavomɨnaama igaicɨnɨmoco. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jaamo diitɨsico nuuhi: Miyaano Aivojɨɨbo siino buheetecuuhi. Jaaboco Simon atyɨmecuuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jaanegui diitɨsi diitoco jɨɨbuguuhi jɨɨhaivɨ diitɨsima iicaunoco, diitɨsima maahunoco iquisicuhinɨsumi diiboco agaajacɨhinɨnoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jaamo tonehejeri ihiimaahicaunaaca Jesu diitofeenevɨ ujulleeveuboro diitoco dilluuhi: Sajeebɨɨ mihica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jaaneri sihidɨ iigutuumoro esamaaiuhi: Fɨne ɨjɨco mahatyɨmehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jaarunaa Jesu diitoco nuuhi: ¿Collɨhi mihiguetehi? ¿Collɨhi uco amɨɨhai jeebɨɨfañotɨ mimiyaavogotɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Eneecau tahuseneque, tatyɨhaiñooco icano memeecɨ, uujoho diiboro. Uco mududɨɨcɨmoro, memeecɨ; ɨjɨ ihuucuma, ibacɨma icano chahahi jino uujoho iicaaboco mahatyɨmebadɨ, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","diitoco ihusene, itɨhaiño icanoco ɨɨfusuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jaarunaa diito imo imo iicaumoro ajabafiituumoro imiyaavuguutɨmoco Jesu nuuhi: ¿Naa machutaama mihicahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jaanegui diiboco taavaabo gaaruhaico acɨumo ");
INSERT INTO bmrNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jaanoco agaayɨcɨuboro diito ɨmefeenevɨ duubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jaaboro diitoco nuubo: Jillɨ iicajinoco amɨɨhaima iicausumi amɨɨhaico nuuhi: Uuditɨ Moise aamefaño, Moocaani iimaamɨnaa aamenefaño, Salmo aamefaño icano onoono icaji, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jaaboro diitoco Caatɨnɨhaamefaño onoonoco gaajasuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jaaboro diitoco nuubo: Jillɨ noonoro caatɨnɨcɨnɨno, Cristo guijeveji. Jaaruubo mifucucɨ, safucu icanotɨ siino buheetejiibo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jaabo momofeenedɨ fahɨgova jiinɨje miyamɨnaaco mɨjɨɨbegueji Jerusaletɨ mɨtɨconɨmo amɨɨhai eedeehimitɨhifiico mejeevesucu amɨɨhai imitɨco ibuusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jaamo amɨɨhai maatyɨmemere jinooco mɨjɨɨbeguejimo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jaamo magaaja, uujoho amɨɨhaihallɨvɨ galluuji Guihirubi unuunoco. Jaanegui jiicuumitɨ buhɨgovɨ mefeedino niquejefañotɨ mitya asaanoco magaayɨcɨtɨnohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jaaboro Jesu diitoco tuucuumitɨ sihɨgovɨ satyuubo Betania cuumi fiitɨno. Jaaboro diitohallɨvɨ ihuseque agañiiyɨcɨubo diitoco imino nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jaasumiro diitotɨ caamovɨ diiboco satyuumo niquejefaño. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jaaboco diito iimuumoro Jerusale cuumijaago imo imo uumiumo. ");
INSERT INTO bmrNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jaamoro templojafaño icahicaumo Moocaanico imomoro. Fɨne.");
INSERT INTO bmrNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Itɨconɨ paryɨ fanoova fiivuutɨnaaca Moocaani Iimaa icacuuhi. Jaabo toono Iimaa Moocaanima icauhi Cristo. Jaabo bu diibo Moocaani. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mɨɨro itɨconɨ diibo Moocaanima icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Diibofeenedɨ Moocaani paryɨ fanoovaaco eetavuuhi; mɨɨro chahano aivo diibofeenedɨ eheetavuutɨno iicano ");
INSERT INTO bmrNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Diiboma icano fiivo. Jaano toono fiivo miyamɨnaadi aachɨcɨnɨno iicauno. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jaano cɨvonofañotɨ achɨcɨhi. Jaanoco icɨvo jabacarutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mɨɨro icaubo saafi Moocaani agalluubo Jua onoobo. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jaabo saauhi diibo aachɨcɨɨbo iicaubeditɨ ijɨɨbeguequi. Jaabo ɨjɨɨbogonofeenedɨ miyamɨnaa imiyaaveguequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jaabo diibo Jua aachɨcɨɨbo icatɨno. Jillɨ aachɨcɨɨbo iicaabo jɨɨbogomɨnaafitɨ iicaqui agalluubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jaanotɨ jino imiya achɨcɨ, miyamɨnaaco aachɨcɨnɨɨbo, jino jiinɨjehallɨvɨ gasefivucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mɨɨro jaabo johono Iimaa iicaabo jino jiinɨjehallɨri icacuuhi. Jaabofeenedɨ Moocaani jiinɨjeque eheetavehinɨrunofaño jiinɨjemɨnaa diiboco gaajautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mɨɨro ijiinɨjevɨ saauruubo. Jaaruuboco miyamɨnaa diiboco gaayɨcɨutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jaarunofaño saatoho diiboco agaayɨcɨmoro miyaaveguehi. Jaamoco ficuubo Moocaani seemetɨ iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jaano miyamɨnaatɨ saatɨhi miyamɨnaatɨ ifiivomo icatɨno, bu gaifi iimoyɨɨcɨnotɨ icatɨno jillɨ Moocaanitɨro diibo seemetɨro minifutucuumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jaabo johono Iimaa iicahinɨɨbo miyamɨnaafi ifiitɨ iminiiyuuboro mofeeneri icauhi, miyaanoma, igaijɨma icano. Jaabo imico mɨɨhai mahatyɨmeuhi, diibo ɨdɨɨboro Moocaani Seemene iicaabo imico. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mɨɨro diibeditɨ Jua ɨjɨɨbuguubo nuuhi: Jaanɨ diibo diibotɨ uujoho unuubo taabuunatɨ asaabo tajanaanɨcɨ iicaabo, uujoho chahaunaacaro iicacuumaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mɨɨro jaabotɨ paryɨ mɨɨhai diiboma sihidɨ iicanotɨ magaayɨcɨhi diibo imino aacɨnoco siino dojɨcutɨ, siino dojɨcutɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mɨɨro Moisefeenedɨ Moocaani tajɨɨba saauhi. Jaanotɨ gaijɨ, miyaano icano Jesucristofeenedɨ saahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mɨɨro mɨɨhaiñooba Moocaanico atyɨmetɨhi, ɨdɨɨboro Illi Caanifaño iicaabo, diibo mɨɨhaico Caanico gaajasuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jaanaa Jerusale cuumiri iicaumo judiomɨ sacerdotemɨco, levitamɨco icano galluuhi Juajaago diiboco: ¿Mɨɨjoho ɨɨjoho? noomoro idilluqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jaamoco diibo imino jɨɨbuguuhi: Uujoho Cristo icatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jaanegui siino diiboco dilluumo: ¿Jaanaa mɨɨjoho ɨɨjoho? ¿Nacu Moocaani iimaamɨnaafi, Elia? noomoro. Jaanegui Jua nuuhi: Chahano uujoho diibo icatɨhi, nooboro. Jaanegui diiboco nuumo: ¿Nacu ɨɨjoho oono Moocaani iimaamɨnaafi asaajiibo? noomoro. Jaanegui nuubo: Chahano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jaanegui diiboco nuumo: Jaanaa mɨɨjoho ɨɨjoho mɨɨhaico dɨɨbogo, oono mɨɨhaico agalluumoco mɨjɨɨbeguequi mɨllɨ difiitɨ ɨɨjoho neehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jaanegui Jua diitoco nuuhi: Uujoho sɨcaihɨgovɨ ocoovadiicɨnɨɨbo: Aivojɨɨbedi jɨɨhaico sanotɨcovoro mihimibachu, onoobo Moocaani iimaamɨnaafi Isaia unuubadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jaamo diito Juama ihiimaatuumou fariseomɨ agalluumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jaamo diiboco nuuhi: Jaabogahabu Cristo idiicatɨɨbo, bu Elia idiicatɨɨbo, bu johono Moocaani iimaamɨnaafi idiicatɨɨbo icano, ¿collɨhi jana nitɨhicahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jaanegui Jua diitoco nuuhi: Uujoho nɨfaihuriro nitɨhi. Jaanotɨ amɨɨhaifeeneri iicaabo saafi amɨɨhai magaajatɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jaabo taabuunatɨ asaabo tajanaanɨcɨvɨ iicaabo, diibovɨ uujoho ɨfototɨhi. Jaamaño diibo tɨhaipaaje duujeque sinaayujitɨrahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Paryɨ jino jillɨ icauhi Betabara onoomañovɨ, Jordan onoohi onegueehivɨ Jua initɨhicauhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jaano sifucutɨ Jua, Jesu diibojaa asaauboco aatyɨmeuboro nuuhi: Memeecɨ jaanɨ Moocaani Cordero, iguijevefeenedɨ jiinɨjemɨnaa imitɨco ubuusujiibo. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Johono uujoho diibotɨ ihiimaaubo: Taabuunatɨ saajiibo tajanaanɨcɨvɨ iicaabo uujoho chahaunaacaro iicacuumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Uujoho icaruubo diiboco gaajahinɨtɨhi. Jaanotɨ naha uujoho nɨfaihuri nitɨɨboro saahi Israel cuumimɨnaa diiboco igaajaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jaadɨ bu siino nuubo: Uujoho atyɨmehi Moocaani Gaijaco nimɨihubadɨ jeevaabo diibohallɨvɨ niquejefañotɨ iniitooboro iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jaaruuboco uujoho gaajahicatɨhi mɨɨjoho diibo iicanoco; jillɨ naha uco nɨfaihuri nitɨqui agalluubo nuuhi: Tagaija cajaanɨhallɨvɨhacho iniitooboro iicaabo diibo tagaijari initɨjiibo, nooboro nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jaaboco atyɨmecuuhi. Jaamaño uujoho jɨɨbeguehi diibo miyaano Moocaani Achi iicanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jaano seseevedɨ siino Jua tomañeri icauhi miimɨsiicɨ ijɨɨbogomɨnaatɨsima. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jaabo Jesu afatyunoco aatyɨmeuboro nuuhi: Memeecɨ ajaanɨ Moocaani Cordero, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jaanoco Jua jɨɨbogomɨnaatɨsi uguubuumɨsiro Jesu dojɨcutɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jaanegui Jesu dojɨcuco emeecɨuboro, diibo dojɨcutɨ ufuunoco aatyɨmeuboro diitɨsico nuuhi: ¿Jinejeque miguiinehi? nooboro. Jaanegui nuumɨsi: ¿Jɨɨbogomɨnaafi, cuuca diicafihi? noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jaanegui Jesu diitɨsico nuuhi: Juu masaa. Jaamɨsiro memeecɨva, nooboro. Jaanegui ufuumɨsi atyɨmeuhi diibo iicahicauhɨgoco. Jaamɨsiro mihiijɨcuuneguiiha tufucu diiboma icaumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jaamɨsi diitɨsi Juatɨ uguubuumɨsiro Jesuma ufuumɨsitɨ saafi momo Andre, Simon Pedro nahabo. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jaabo Andre jinejeque moonɨtɨɨboro inahabo Simonco iguiinutuuboro diiboco nuuhi: Meecɨ mahatyɨmecuuhi Mesia Cristo onooboco, nooboro. Mesia, Moocaanitɨ asaabo ihaivojɨɨsucuqui, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jaaboro Andre Simonco satyuuhi Jesu iicauhɨgo. Jaaboco Jesu aatyɨmeuboro nuuhi: Ɨɨjoho Simon Jona achi, jaaruubo jisumitɨro dimemeji Cefa, nooboro. Jaarunaa Cefa onoono jillɨ momoro, Pedro eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jaano seseevedɨ Jesu imuguuhi Galilea jiinɨjevɨ ufuunoco. Jaabo Felipeque aatyɨmeuboro diiboco nuuhi: Tadyojɨcutɨ disaa, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jaabo Felipe Betsaida cuumioobou. Jaacuumiri tollɨro Andre, Pedro icamɨsi icahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jaabo Felipe Natanaeque ɨɨcɨjeuboro nuuhi: Mɨɨhai mahatyɨmecuuhi, diibeditɨ Moise itajɨɨba aamefaño acaatɨnɨuboco. Tollɨro Moocaani iimaamɨnaa diibeditɨ acaatɨnɨɨboco. Jaabo Jesu, Jose Nazareoobo achi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jaanegui Natanae nuuhi: ¿Nacu Nazare cuumitɨ iimino saajirahi? nooboro. Jaanegui Felipe diiboco nuuhi: Eneecau maha memeecɨtequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jaanaa Jesu Natanae asaaunoco aatyɨmeuboro nuuhi: Jaadi juuga saabo miya israelmɨnaafi abañɨfitatɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jaanegui Natanae diiboco dilluuhi: ¿Mɨllɨtɨ uco gaajahi? nooboro. Jaanegui Jesu diiboco nuuhi: Mɨɨro ɨco uujoho atyɨmehi Felipe ɨco coovatɨnaacaro higuerahoguiino diicaaboco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jaanegui Natanae diiboco nuuhi: Jɨɨbogomɨnaafi ɨɨjoho Moocaani Achi, ɨɨjoho israelmɨ aivojɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jaanegui Jesu diiboco nuuhi: ¿Jillɨ ɨɨjoho uco miyaaveguehi, ɨco higuerahoguiino diicaaboco atyɨmehi eneeneguiiharo? Imi jino janaanɨcɨ icanehejeque daatyɨmeji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tollɨro bu Jesu nuuhi: Miyanotɨro amɨɨhaico neehi: Mahatyɨmeji niqueje faayɨcɨnɨnotɨ Moocaani toomomɨnaa uujoho Miyamɨnaafibadɨ Ifiivuubohallɨvɨ iniitocɨnɨmoro bu caamovɨ foocɨnɨmoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jaanobuunatɨ mifucucɨ, safucu icano taabava jɨɨbaimo icauhi Cana cuumivɨ Galilea jiinɨjevɨ. Jahɨ Jesu seejɨ diitofaño icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jahɨ tollɨro Jesuco ijɨɨbogomɨnaama cuuhuvaumo tobaimovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jaanaa diito aduta vino ifinɨcuunegui Jesuco seejɨ nuuhi: Vino finɨcuuhi, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jaanegui Jesu diigoco nuuhi: ¿Gaha, collɨhi jaanoco uco neehi? Toonovɨhi ɨfototɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jaarunaa diigo nuuhi diito jeecɨvomɨnaaco: Paryɨ diibo amɨɨhaico onoonoco momoonɨ, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jaanaa tomañeri icauno sahuse juugahusetɨ sañu icano ɨcɨñuuno. Tuñuujefaño judiomɨ iicanɨcɨbadɨ ifiinoco iimibachuqui nɨfaihunoco ificuhicauñuuje. Jaano sañufaño fɨne ɨɨfetehicauno ochenta o cien litrodɨno nɨfaihu. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jaanaa Jesu diitoco nuuhi: Paryɨ jino ɨcɨñuunoco nɨfaihuneri magahafusu, nooboro. Jaanegui diito tuñuujeque jɨti jɨti gahafusuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jaadɨ Jesu diitoco nuuhi: Fɨne ɨvɨ jisumi mɨɨdɨno mɨhɨcɨmoro mahacɨto ijɨɨbaimo toomomɨnaafico, nooboro. Jaanegui tollɨ moonɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jaafaihuco ijɨɨbaimo toomomɨnaafi nɨsuuhi vinotɨ minifutucufaihuco. Jaanoco gaajautɨɨbo cuucatɨ ɨɨcɨunoco; ɨdɨɨmoro diito ijeecɨvomɨnaa toonoco gaajauhi diito inɨfaihuco ɨɨcɨumaño. Jaanegui ijɨɨbaimo toomomɨnaafi tobaimo abajaaboco ocoovauboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Itɨconɨ famoova iimi vinoco ɨfefihi. Jaanoco ijɨɨbaimo guiraano aaducuunobuunatɨ iimijɨɨsutɨnoco ɨɨfefimo. Jaanotɨ ɨɨjoho aivo iiminoco ficuuhi jihachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jino aivo itɨconɨ Jesu sihidɨ ejeevanoco omoonɨuno Cana cuumivɨ Galilea jiinɨjevɨ, imityaco ɨɨfusuubo. Jaaneri ijɨɨbogomɨnaa diiboco miyaavuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jaanobuunatɨ seejɨ, inahabomɨ, ijɨɨbogomɨnaa icamoma fuubo Capernau cuumijaagovɨ jahɨ icaumo fiiva fucuva. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jaanaaca judiomɨ jɨɨbaimo Pascua ifiitɨcuuneguiiha Jesu Jerusale cuumijaagovɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jahɨ atyɨmeubo templojafaño bueymɨco, ovejamɨco, nimɨihumɨco icano anaajemeque. Tollɨro miyamɨnaama nɨhɨbamɨco acafaryuuacumo gɨcɨnɨmoco atyɨmeubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jaanoco aatyɨmeuboro Jesu gaaibaɨco gaicɨɨtatɨ eheetavuuboro tooneri diitoco isi gañɨɨubo, ihovejamɨ, ibueymɨ icamoma. Tollɨro nɨhɨbamɨco acafaryuuacuhicaumo nɨhɨbamɨco baavɨ fufucuubo, jaaboro imesanoco gavaracuubo icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jaaboro bu nimɨihumɨco anaajeumoco nuubo: ¡Toonoco jinotɨ buhɨgovɨ mɨɨcɨ! ¡Guihirubi iijaco naajetajatɨ meheetavedino! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jaanotɨ ijɨɨbogomɨnaa esafutuuhi Caatɨnɨhaamefaño: Diijaco agaijɨno uco finɨsuhi, onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jaanegui judiomɨ diiboco dilluuhi: Eneecata mɨɨhaico siibadɨ iicanoco dɨhɨfusu toonotɨ magaajaqui: Jɨɨ, ollɨ iicaneguiiha jahi ollɨ moonɨɨbo meneequi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jaanegui Jesu diitoco nuuhi: Jiija templojaco paryɨ magavaracu, jaajaco siino uujoho mifucucɨ, safucu icanotɨ siino boobanɨji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jaanegui judiomɨ diiboco nuuhi: Cuarenta y seisdɨno ficabava nijequetɨ jiijaaco eetavuumo. ¿Jaajaco mɨllɨ ɨɨjoho mifucucɨ, safucu icanotɨ deetavejirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jaarunaa Jesu ifiicoro unuuruubo: Temploja, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jaamaño Jesu iguijeveunofeenetɨ ubuheeteusumi ijɨɨbogomɨnaa tollɨ diibo unuunoco esafutuuhi. Jaamoro Caatɨnɨhaame onoonoco, bu Jesu iijɨco icano diitoco ɨjɨɨbuguunoco miyaavuguumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua jɨɨbaimosumi Jesu Jerusaleri iicausumi, sihidɨ miyamɨnaa diiboco miyaaveguehicauhi sihidɨ ejeevanoco omoonɨnoco aatyɨmemere. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jaarumovɨ Jesu jeevamaaihicautɨhi famoovaaco agaajahicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mɨɨhaiñooba diiboco jɨɨbeguehicautɨhi: Diito jillɨ jeevahi, noomoro miyamɨnaaco diiboro agaajahicaumaño ijeebɨɨfaño iicanoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Icaubo saafi fariseomɨoobo Nicodemo onoobo judiomɨ aivojɨtoobo. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jaabo Jesujaago fucu asaauboro diiboco nuuhi: Jɨɨbogomɨnaafi, mɨɨhai magaajahi ɨco Moocaani mɨɨhaico dɨɨbeguequi agalluunoco. Chahamo mɨɨjoho sihidɨ ejeevanoco ɨɨjoho omoonɨbadɨ iicanoco omoonɨmo Moocaani diiboma iicatɨruva, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jaanegui Jesu diiboco nuuhi: Miyanotɨro ɨco neehi, siino dojɨcuvɨro ifiivotɨɨbo Moocaani aivojɨfaño feejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jaanegui diiboco Nicodemo dilluuhi: ¿Mɨllɨ jaabo miyamɨnaafi ujusicuubo siino dojɨcuvɨro fiivejirahi? ¿Mɨllɨ jaabo siino seejɨ jeebɨɨfaño ɨjɨcafotooboro siino fiivejirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jaanegui Jesu diiboco nuuhi: Miyanotɨro ɨco neehi; nɨfaihuri, Moocaani Gaijari icano ifiivotɨɨbo Moocaani aivojɨfaño feejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Miyamɨnaafiditɨ ifiivoobo miyamɨnaafi. Jaanotɨ Moocaani Gaijatɨ ifiivomo Moocaani Gaijama icahi. Toono eneejiruno Moocaani seemetɨ iicamo. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Daabafiitedino siino fiivo ɨco onoonotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mɨɨro guibuhuba iimogohɨgotɨ asaanoco ɨɨjoho guubufihi. Jaaruubo gaajatɨhi conootɨ asaanoro conoovɨ ɨɨfotonoco. Jaabadɨ jeevamo paryɨ Moocaani Gaijari ifiivomo, mɨllɨ ifiivonoco mɨllɨ miyamɨnaa gaajajirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jaanegui Nicodemo siino dilluuhi: ¿Mɨllɨ fɨne jino? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jaanegui Jesu nuuhi: ¿Ɨɨjoho aivo sihidɨ edeevaabo israelmɨnaa jɨɨbogomɨnaafi idiicaruubo, nacu jinoco gaajatɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Miyanotɨro ɨco neehi: Mɨɨhai mihiimaahi magaajanoco. Jaamo mɨɨhai mɨjɨɨbeguehi mahatyɨmeneque. Jaarunoco amɨɨhai mimiyaaveguehicatɨhi mɨɨhai monoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jiinɨjeono icarunoco onoonoco uco mimiyaaveguehicatɨhi. Jaanequi: ¿Fɨne mɨllɨjiru niquejeonoco jɨɨbuguruva? ");
INSERT INTO bmrNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mɨɨhaiñooba niquejefaño footɨhi ɨdɨɨboro tahɨgotɨ iniitehinɨɨbo: Uujoho Miyamɨnaafibadɨ Ifiivuubo niquejefaño iicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mɨɨro Moise sɨcaihɨgovɨ jiinimoco caamovɨ agañiiyɨcɨubadɨ; tollɨro uujoho Miyamɨnaafibadɨ Ifiivuubo caamovɨ guijeve ɨmohobujehallɨvɨ gañiiyɨcɨcafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jaaboco paryɨ imiyaavogomo ifinɨjitɨno fiivoma icacuuhi ");
INSERT INTO bmrNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mɨɨro Moocaani sihidɨ jiinɨje miyamɨnaaco agaijɨɨboro ɨdɨɨboro iicaabo Illico acɨuhi. Jaaboco paryɨ imiyaavogomo mɨtajitɨhi. Jaamo ifinɨjitɨno fiivoma icaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mɨɨro Moocaani jiijehallɨvɨ Illico galluutɨhi jiinɨje miyamɨnaaco cɨɨjɨgaifaño igañɨɨsuqui. Jillɨ galluubo diibofeenedɨ jiinɨje miyamɨnaa itaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jaabo Moocaani Achico imiyaavogomo cɨɨjɨgaifaño ɨfetejitɨhi. Jaanotɨ imiyaavogotɨmo cɨɨjɨgaifaño ifeequi icacuuhi ɨdɨɨboro Moocaani Achi iicaaboco imiyaavogotɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jaamo imiyaavogotɨmo cɨɨjɨgaifaño ifeequi icacuuhi. Mɨɨro jiinɨjehallɨvɨ aachɨcɨnɨɨbo asaauboco imogotɨmo ɨcɨvonocoro imuguumo imitɨcoro omoonɨhicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mɨɨro famooro iimitɨnoco omoonɨmo aachɨcɨnoco jɨɨheguehi. Jaamaño aachɨcɨnɨnojaagovɨ fiitɨvotɨmo, iimitɨnoco omoonɨno foovoɨɨvotɨno iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jaanotɨ miyaanoco iimogomo aachɨcɨnɨjaagovɨ fiitɨvehi diito omoonɨnofaño Moocaani iicano igaajacafetequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jaanobuunatɨ Jesu fuuhi ijɨɨbogomɨnaama Judea jiinɨjevɨ. Jaabo toonovɨ gueenene icaubo miyamɨnaaco initɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jaabadɨro Jua nitɨhicauhi Enonvɨ Salim cuumi fiitɨno, tomañovɨ sihidɨ nɨfaihu iicaumaño. Jaabojaa miyamɨnaa ofoomoco nitɨhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jillɨ icaumo Jua ɨcɨvojaanɨrautɨsumi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jaanaaca Jua jɨɨbogomɨnaa jenaaucasiuhi judiomɨma ifiino imibachuhallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jaamoro Juaco nuutuumo: Mojɨɨbogomɨnaafi, meecɨ ɨɨma oono Jorda oonegueehi iicaubo icahi diibotɨ mɨɨhaico ɨdɨɨbuguubo. Jaabojaago sihidɨ miyamɨnaa ofoomoco nitɨhicaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jaanegui Jua diitoco nuuhi: Cajaatyobama chahajiruno gaaja Moocaani diitoco ihacɨtɨruva. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mɨɨro amɨɨhairyo uco muguubuhinɨcuuhi: Uujoho Cristo icatɨhi jillɨ diibo ɨmega uco agalluubo, nooboro eneehinɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mɨɨro taabava jɨɨbaimofaño mogaima iicaabo aijɨ. Jaabo cojɨri iicaabo jillɨ igataavomɨnaafi. Jaabo diibo ihiimaanoco uguubuuboro imo imo icanɨcɨɨbo. Jaabadɨ jisumi uujoho sihidɨ imo imo icahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jaabo diibo jisumitɨro janaanɨcɨvɨ bocɨtoobaaca uujoho jillɨ guiinovɨro minifeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Caamotɨ asaabo fanoohallɨvɨro icahi. Jaanotɨ jiinɨjeoobo jillɨ jiinɨjemɨnaafi. Jaabo jiinɨjenehejequere iimaanɨcɨhi. Jaanotɨ niquejefañotɨ asaabo famoohallɨvɨro icahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jaabo aatyɨmenetɨ, uguubunotɨ icano iimaahi. Jaaruubo onoonoco mɨɨhaiñooba miyaaveguehicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jaanotɨ saatoho diibo onoonoco imiyaavogomo: Moocaani Miyaabo iicanoco jɨɨbeguehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Moocaani agalluubo Moocaani iijɨco jɨɨbeguehi. Jaaboco Moocaani Igaijaco finɨtɨno acɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Moocaani Illico gaijɨhi. Jaabo usefaño Moocaani paryɨ fanooco ficuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jaamaño Moocaani Achico imiyaavogomo ifinɨjitɨno fiivoma icacuuhi. Jaanotɨ Moocaani Achico imiyaavogotɨmo fiivoma chahaji. Jillɨ ñɨhicuno Moocaani omoonɨjinofañoro icacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jaanaa fariseomɨ guubuuhi Jua janaanɨcɨ Jesu ijɨɨbogomɨnaama iicaabo initɨhicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jaarunofaño Jesu nitɨhicautɨhi ɨdɨɨmoro ijɨɨbogomɨnaa nitɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jaanoco Jesu uguubuuboro Judeatɨ fuuhi Galileajaago siino ihuumiqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jaabo imuguuhi Samaria jiinɨjefeenedɨ ufuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jaabo ufuubo ɨfutuuhi Sicar onoocuumi Samaria jiinɨje cuumivɨ Jacob illi Joseque ijiinɨjeque aacɨumaño fiitɨno. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jaamañeri icauno nɨfaihuhojɨ Jacob ojɨ onoohojɨ. Jaanaa Jesu asaaubo, iniinovatucuunegui tohojɨ cojɨvɨ casɨɨvuubo, fɨne gadɨcɨɨba nɨhɨba icacuuberi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jaanaa ijɨɨbogomɨnaa tuucuumijaago fuuhi machutaaco anaajeteumo. Jaanaa tuucuumitɨ saafigo gaigo saauhi toojɨtɨ ɨnɨfaihuvavaugo. Jaagoco Jesu nuuhi: Uco nɨfaihutɨ daacɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jaanegui diiboco samariaogo nuuhi: ¿Mɨllɨ jaabo ɨɨjoho judio idiicaabo, uujoho samariaogo iicagoco nɨfaihuco dilluuhi? noogoro. Jillɨ nuugo judiomɨ samaritanomɨma iimogocasihicautɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jaanegui Jesu diigoco nuuhi: Ɨɨjoho Moocaani aacɨnoco gaajaruva, bu mɨɨjoho jino ɨco nɨfaihuco idillunoco gaajaruva; ɨɨjoho uco dilluruva ɨco uujoho buheenɨfaihuco acɨjirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jaanegui diigo nuuhi: ¿Aivojɨɨbo, nacu jinejeri jaabo inɨfaihuco dɨɨcɨjirahi aivo faicuvahojɨ? ¿Conootɨ jaabo toono buheenɨfaihuco dɨɨcɨjirahi? ");
INSERT INTO bmrNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mɨɨro jino moheedeebe Jacob mɨɨhaidi jihojɨco ficuuhi, diibo iseeme, paryɨ ijoomɨ icano toojɨtɨ aaduhicauhojɨco. ¿Nacu jaabo ɨɨjoho diibo janaanɨcɨ deevahi? noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jaanegui Jesu diigoco nuuhi: Paryɨ jihojɨ nɨfaihutɨ aadumoco siino adufira aiveji. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jaanotɨ uujoho aacɨno nɨfaihuco aadumoco siino ufucuro adufira aivucuujitɨhi. Uujoho aacɨno nɨfaihu diitofañotɨ finɨtɨno niivaji ifinɨjitɨno fiivoco ihacɨqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jaanegui diigo diiboco nuuhi: Aivojɨɨbo, uco tofaihutɨ daacɨ uco adufira aivotɨno iicaqui, bu siino jihojɨjaago nɨfaihufiiri saatɨgo icaqui, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jaanegui Jesu diigoco nuuhi: Difo jaagoro ditajeque coovato. Jaadɨ siino disaa, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jaanegui diiboco iimusuugo: Uujoho tajevatɨhi, noogoro. Jaanegui Jesu diigoco nuuhi: Miyaanoco neehi, tajevatɨhi onoogo. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mɨɨro sahusedɨmoma diicacuuhi, jisumi bu diiboma idiicaabo ditaje icatɨɨbo. Jaanoco miyaanoco neehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jaanoco uguubuugoro diiboco nuugo: Aivojɨɨbo ɨɨjoho baacho Moocaani iimaamɨnaafi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mɨɨro moheedeete samaritanomɨ Moocaanico jigajɨhallɨvɨ imejiibuuhi. Jaarunaa amɨɨhai judiomɨ Jerusalevɨ Moocaani imomaño meneehicahi, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jaanegui Jesu nuuhi: Gaigo, uco miyaavogo, safucu icajino amɨɨhai Moocaanico mihimono. Tusumi jigajɨjaago footɨmo, bu Jerusale cuumijaago footɨmo icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mɨɨro amɨɨhai samaritanomɨ magaajatɨɨboco mihimehi. Jaanotɨ mɨɨhai magaajaaboco mihimefihi; Mɨɨro judiomɨtɨ taajasu saahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jaanotɨ safucu iicajino, jaano jino tusumi mihicacuuhi, miyanotɨro Moocaanico iimomo imeji igaijari, miyaaneri icano. Mɨɨro tollɨ iimomoco Moocaani imeguehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Moocaani Gaija jaamaño diiboco iimomo igaijari, miyaaneri icano iimequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jaanegui diigo nuuhi: Uuro gaajahi Mesia, Cristo onoobo, asaajinoco. Jaabo asaadɨ mɨɨhaico paryɨ fanoocoro jɨɨbeguejiibo, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jaanegui Jesu diigoco nuuhi: Uujoho diibo ɨɨma ihiimaabo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jaanaa ijɨɨbogomɨnaa gaseuhi. Jaamo jabafiituuhi. Jesu gaigooma ihiimaauneri. Jaarumo diiboco dilluutɨhi. ¿Jinejeque dilluhi? ¿Jinejeque mihiimaacasihi? nuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jaanegui diigo ihɨcɨñuco ejeevesuhinɨugoro fuuhi ifaacuumijaago. Jaagoro miyamɨnaaco jɨɨbugutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Eneecauhu masaamoro memeecɨva saafi gaifi, paryɨ omoonɨhicanoco uco onooboco. ¿Naa fɨne diibo Cristo icatɨɨbo? noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jaanegui diito tuucuumitɨ asaaumoro fuuhi diibojaago. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jaanaaca ijɨɨbogomɨnaa diiboco neehicauhi: Mojɨɨbogomɨnaafi, machu, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jaarunaa diitoco nuubo: Tamachuta icahi uujoho amachujino amɨɨhaima magaajatɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jaanegui ijɨɨbogomɨnaa dillucasiuhi sanomɨro: ¿Fɨne mɨɨjoho diibedi machutaaco sɨvahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jaarunaa Jesu diitoco nuuhi: Uudi tamachutabadɨ oono uco agalluubo onoobadɨ eetavono, idudɨcamaajeque iimivono. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mɨɨro amɨɨhai meneehi: Icanehiica minɨhɨbacɨ, minɨhɨbacɨ ɨdɨɨno basuta ujusijino, noomoro. Jaarunofaño amɨɨhaico uujoho neehi: Memeecɨ basutaaco, oono paryɨ tɨfaicuuhi ihɨcɨcafetequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mɨɨro basutaaco ududɨcamaaibo ijaadaco gaayɨcɨfihi. Jaabo basuta noovaco ananɨnɨcɨbadɨ miyamɨnaaco nanɨhi ifinɨjitɨno fiivoma iicaqui. Jaaneri abasuubo, bu toonoco ɨɨcɨɨbo icano sano imo imo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jinoovɨ aivo miyaano, jillɨ onoonɨcɨno: Saafi abasunoco sifi ɨcɨnɨcɨhi, onoono. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jaanegui uujoho amɨɨhaico tajɨɨbahi mɨhɨcɨqui amɨɨhai mabasuhinɨtɨnoco; sita abasuhinɨnoco amɨɨhai mequeheevehi idudɨcamaajeque, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jaaboco sihidɨ Samaria jiinɨje cuumimɨnaa miyaavuguuhi diigo ɨjɨɨbuguunotɨ paryɨ uujoho omoonɨhicano uco noobo unuunotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jaanegui samaritanomɨ diibojaa asaaumoro diiboco fiitɨuhi diitoma iicaqui. Jaanegui Jesu mifucucɨ toonovɨ diitoma icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jaamoro diiboco sihidɨ miyaavuguumo ihiimaaco uguubuumoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jaamoro diigoco nuumo: Jisumi ɨɨjoho eneeneriro mimiyaavogocuutɨhi: Mɨɨhairyo muguubucuuhi. Jaamoro magaajacuuhi miyaanoro diibo Cristo jiinɨjemɨnaa taajasumɨnaafi icanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Toonotɨ mifucucɨ iicaunotɨ fuubo Galilea jiinɨjejaagovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jaabo Jesu iinoro nuuhi: Moocaani iimaamɨnaafi ijiinɨjevɨ bocɨgoratɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jaadɨ Galileavɨ agaseuboco tomañoto imino gaayɨcɨuhi. Diito tollɨro bu fuumo Jerusalevɨ Pascua jɨɨbaimojaago. Jaamo atyɨmeuhi tahɨ tobaimovɨ Jesu fanoovaco omoonɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jaadɨ Jesu siino saauhi Cana cuumijaagovɨ Galilea jiinɨjevɨ toonovɨ nɨfaihuco aivofaihutɨ iminiiyumañovɨ. Jaanaa Capernauvɨ icaubo saafi aivojɨɨbo. Jaabo seemene guihuvauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jaabo guubuuhi Jesu Judeatɨ Galileavɨ agaseunoco. Jaanegui diibojaa ufuuboro diiboco nuubo iijajaa ofooboro iseemeneque ibuheesuqui aivo iniinovacuuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jaanegui Jesu nuuhi: Botɨ siibadɨ iicanehejeque omoonɨnoco mahatyɨmetɨhachiijɨ mimiyaaveguejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jaarunofaño diibo Jesuco nuuhi: Aivojɨɨbo goovano masɨɨgo taseemene guijevetɨnaacaro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jaanegui Jesu nuuhi: Fuucu, diseemene buheecuhi, nooboro. Jaanegui diibo Jesu unuunoco imiyaavuguuboro fuucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jaabo iijatɨ fiitɨcuuboco idudɨcamaajemɨnaa asaaumoro jɨɨbogovauhi: Diseemene buheecuuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jaanegui diitoco dilluubo: ¿Conootɨ nɨhɨba iicaaberi buheehinɨɨbo? nooboro. Jaanegui diiboco nuumo: Iijɨ dɨjɨɨveeberi iguihuva diiboco buuhinɨhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jaanotɨ caani gaajauhi toonotɨ nɨhɨba iicaaberi Jesu diiboco: Diseemene buheehi, eneehinɨnoco. Jaanoma iicaubo paryɨ iyotoma Jesuco miyaavuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jino Jesu sihidɨ ejeevanoco Galileavɨ itɨconɨ omoonɨunoco allɨnɨuhi Judeatɨ Galileavɨ siino uhuumiusumi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Toonobuunatɨ judiomɨ eetavuuhi jɨɨbaimoco. Jaanegui Jesu fuuhi Jerusalevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jahɨgo Jerusalevɨ ovejamɨ guhuga onoohuga fiitɨno icano jɨcooba nicutaaba hebreomɨ iijɨri Betesda onooba. Jaabaatɨ icano sahusedɨno iguhugano. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Jaahugaje goohasinovɨ sihidɨ iguihuvafiimo icahicauhi aatyɨmetɨmo, idɨɨno iimitɨmo, ifiino isifañɨɨneri ɨɨgotɨmeheje icamo. Jaamo teemehicauhi toba nɨfaihu amaryɨbanoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mɨɨro tobajaago Moocaani toomomɨnaafi niitehicauhi safohosa jaaboro inɨfaihuco maryɨcuvahicauhi. Jaasumiro tobafaño ɨmegavɨro aacotoobo buheehicauhi, jillɨ fanoova guihuva ");
INSERT INTO bmrNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jaamañeri icaubo saafi treinta y ochodɨno ficabano tɨcovovɨ iguihuvacuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jaabo sɨucɨnɨuboco Jesu aatyɨmeuboro gaajacɨuhi aivo gueenene iicacuunoco. Jaaboro diiboco nuubo: ¿Diimeguehi ubuheeneque? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jaanegui diibo iimusuuhi: Aivojɨɨbo, mɨɨjoho bu uco tobafaño jɨɨhacujirahi toba amaryɨbasumi fahiijɨvaro tobafaño feequi moonɨnaacaro sita tahɨmegaro feehicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jaanegui Jesu diiboco nuuhi: Gañiivo jaaboro dicɨgaiijeque dɨɨcɨɨbo fuucu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jaasumiro diibo buheeteuhi. Jaaboro icɨgaiijeque ɨɨcɨuboro ɨgucuubo. Jaafucuu judiomɨ jaguisɨfucuu. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jaanegui judiomɨ Jesu ubuheesuuboco nuuhi: Jaachiijɨ jino jaguisɨfucu. Jaanegui dicɨgaiijeque satyejitɨhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jaanegui diibo iimusuuhi: Mɨɨro uco ubuheesuubo diiboro uco neehi: Dicɨgaiijeque dɨɨcɨɨbo fuucu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jaanegui dilluumo: ¿Mɨɨjoho diibo ɨco dicɨgaiijeque dɨɨcɨɨbo dɨɨgo onoobo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jaarunofaño diibo gaajautɨhi diiboco ubuheesuuboco. Tomañeri sihidɨ miyamɨnaa iicaumo cojɨtɨ Jesu sihɨgovɨ ufucuumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jaanobuunatɨ Jesu diiboco siino templojafaño aatyɨmeuboro nuuhi: Meecɨ, jisumi jino ɨɨjoho ubuheecunoco; siino imitɨno diicacuujirahana janaanɨcɨ iicano siino dijaa saadino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jaanegui diibo ufuuboro judiomɨco jɨɨbugutuubo Jesujaahi diiboco ubuheesuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jaanoma iicaumo judiomɨ Jesuco imitɨno moonɨhicauhi, diibo jaguisɨfucuvɨ tollɨ omoonɨhicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jaanegui Jesu nuuhi: Guihirubi, jisumihachuta dudɨcamaaihi. Jaano tɨcovovɨ bu uujoho dudɨcamaaihi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jaanoma iicamo judiomɨ janaanɨcɨ imeguehicauhi diiboco agaicaaunoco. Mɨɨro toono jaguisɨfucucoro diitobadɨ teemehicautɨɨbo, tollɨro bu Moocaanico: Guihirubi, onooboro ifiico Moocaanibadɨ moonɨhicaubo icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jaanegui diitoco nuubo: Miyanotɨro, miyanotɨro amɨɨhaico neehi: Uujoho Moocaani Seemene iinoro ijeebɨɨtɨro moonɨtɨhi. Mɨɨro Caani omoonɨnoco aatyɨmeebere, bu tollɨro Illi moonɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mɨɨro Moocaani Illico agaijɨmaño fanoova moonɨnoco diiboco ɨfusuhi. Mɨɨro imi janaanɨcɨ ejeevanoco ɨɨfusujiibehiica. Jaaneri amɨɨhai majabafiiteji. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Moocaani uchuumucuumoco ubuheetesuuboro fiivoco aacɨbadɨro bu Illi iimogomoco fiivoco acɨji. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mɨɨro Moocaani mɨɨhaiñoobaco iimitɨco nootɨhi. Jaaruubo paryɨ toono imibachu mityaco Illi usefaño jeevesuubo, imitɨco iimibachuqui; ");
INSERT INTO bmrNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Toonotɨ famooro Illico ibocɨguequi Caanico iicabadɨro. Jaanotɨ Illico obocɨgotɨmo, tollɨro bu Caanico bocɨgotɨhi diiboco agalluuboco. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Miyanotɨro, miyanotɨro amɨɨhaico neehi: Uco agalluhinɨɨboco imiyaavogomoro uujoho onoonoco uguubuumo ifinɨjitɨno fiivoma icacuuhi. Jaamo cɨɨjɨgaifaño fuucuujitɨhi; Jillɨro guijevetɨ fiivofañovɨ fatyucuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Miyanotɨro, miyanotɨro neehi: Ufucu icajino, jaano jino tusumi mihicacuuhi; iimitɨfaño miguijevecubadɨhiica iicamo Moocaani Achi iijɨco uguubujino. Jaanoco uguubumo fiivoma icaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Moocaanima mitya icahi fiivoco aacɨjino. Jaabo Illico mityaco acɨɨbo tollɨro Illi sitaaco fiivoco ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tollɨro bu mitya iijɨco acɨɨbo miyamɨnaafañotɨ iimitɨno, iimino icanoco idugaacuqui, uujoho Miyamɨnaafibadɨ Ifiivuubo iicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jinotɨ meheetyedino: Ufucu icajinehiica tusumi paryɨɨcɨno cɨɨhojɨnofaño iicamo ihiimaaco uguubujino. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jaamo iiminoco omoonɨumo siino buheeteji fiivoma iicaqui. Jaanotɨ iimitɨnoco omoonɨumo buheeteji cɨɨjɨgaifaño ifeequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mɨɨro uujoho aivo, uuro tajeebɨɨtɨro moonɨjitɨrahi. Jaamaño uujoho iimitɨnoco dugaacuhi uco atajɨɨbabadɨ. Jaano uujoho udugaacuno miyaano tajeebɨɨtɨ uuro iimogonoco omoonɨtɨmaño. Jillɨ Guihirubi uco agalluhinɨɨbo iimogonocoro moonɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Uujoho uuro tafiitɨro jɨɨbuguruva tajɨɨbogo saatehedi ibocɨma chahajirahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Jaanotɨ sifi uuditɨ jɨɨbeguehi. Jaamaño uujoho gaajahi uuditɨ diibo onoono miyaano iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mɨɨro amɨɨhai saatohoco magalluuhi Juajaago diiboco idillutequi. Jaanoco diibo miyaanoco nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jaarunofaño uujoho gaayɨcɨtɨhi miyamɨnaafi ɨjɨɨbogonoco. Jaarunoco uujoho jillɨ Juatɨ amɨɨhaico neehi. Jaamo uco mimiyaavogomoro mataajaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Mɨɨro Jua cɨɨjɨgaimecu ɨjɨganoro aachɨcɨbadɨ jeevauhi. Jaabo aachɨcɨnɨunofaño amɨɨhai jihachutagayɨro imo imo mihicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jaaruno toono Jua ɨjɨɨbuguuno janaanɨcɨvɨ uujoho onoono jeevahi. Mɨɨro Moocaani uco agalluubo atajɨɨbaunoco omoonɨno. Toonoro tahallɨvɨ jɨɨbeguehi miyaano uco Moocaani agalluunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tollɨro bu Guihirubi uco agalluubo uutɨ jɨɨbeguehi. Jaaruuboco amɨɨhai safooba mahatyɨmetatɨhi, bu ihiimaaco safooba muguubutatɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tollɨro bu diibo iijɨ amɨɨhaifaño chahahi; Diibo agalluuhinɨɨboco amɨɨhai mimiyaavogotɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mɨɨro Caatɨnɨhaameque imino amɨɨhai mɨhɨɨfɨnɨcɨhicahi fiivo ifiico toohaamefaño mahatyɨmeneque mihimogomoro. Jaano mɨɨro toohaame uuditɨ ɨjɨɨbuguruhaame. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jaarumo tajaa masaanoco mihimogotɨhi fiivoma mihicajiruneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Uujoho miyamɨnaa cahacɨsuco gaayɨcɨtɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jaabadɨro uujoho gaajahi amɨɨhai Moocaanico magaijɨtɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mɨɨro uujoho Guihirubi memeri saahinɨhi; Jaaruuboco uco magaayɨcɨtɨhi. Jaanotɨ sifi jillɨ ijeebɨɨtɨro asaaboco naha amɨɨhai magaayɨcɨjirahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Mɨllɨ jaamo mimiyaaveguejirahi sanomɨro fahɨgovavɨ miyamɨnaa imihicacoro magaayɨcɨcasimo? Jaamaño toonoguiinodɨ ɨdɨɨboro iicaabo Moocaanitɨ asaano imihicaco miguiinotɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Jaanegui uuditɨ mehesamaaidino: Caani ɨmefeenevɨ mɨɨhaico imitɨno neejiibo, noomoro. Icaabo amɨɨhai imitɨco eneejiibo Moise. Jaabo tajɨɨbafeenedɨ mataajibadɨ mehesɨcɨnɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mɨɨro Moiseque mimiyaavuguruva uco tollɨro mimiyaaveguejirahi. Mɨɨro diibo uutɨ caatɨnɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Jaabo acaatɨnɨunoco mimiyaavogotɨmo, ¿mɨllɨ bu taajɨco mimiyaaveguejirahi? ");
INSERT INTO bmrNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Toonobuunatɨ Jesu fuuhi Galilea muuai onegueehivɨ. Jaaba momoro bu Tiberia onoomuuai. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jaabo dojɨcutɨ sihidɨ miyamɨnaa feehicauhi sihidɨ ejeevanoco omoonɨɨboro iguihuvamoco ubuheesunoco aatyɨmehicauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jaanegui Jesu ifabaɨhallɨvɨ ufuuboro ijɨɨbogomɨnaama casɨɨvuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jaasumi fiitɨcuuno judiomɨ jɨɨbaimo Pascua iicaujino. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jaanaa Jesu emeecɨubo atyɨmeuhi sihidɨ miyamɨnaa idojɨcutɨ asaaunoco. Jaanegui Felipeque nuubo: ¿Cuucatɨ fɨne machutaaco manaajejirahi jito imachuqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jillɨ Felipeque nuubo jillɨ diiboco ɨnɨsuubo, ¿mɨllɨ fɨne neejiibo? onoomaño jillɨ omoonɨjinoco imino agaajacuuboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jaanegui Felipe nuuhi: Fɨne doscientos denario tɨcovovɨ manaajejirahi, machutaaco. Jaaruno famoovɨro ajashuno ɨɨfetejitɨrahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jaanegui ijɨɨbogomɨnaatɨ saafi Andre Simon Pedro nahabo Jesuco nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Jineeri icase sase sahusedɨno sebada maahuno, bu miimɨsiicɨ tavaabomɨsi icanoma iicase. ¿Mɨllɨ jaano tonoodɨno jinoodɨmo miyamɨnaavɨ ɨfetejirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jaanegui Jesu nuuhi: Diitoco monoo icasɨɨcamaaiqui, nooboro. Jaamañeri sihidɨ ñaavahu icauhi. Jaanohallɨvɨ casɨɨcamaaiumo cinco mildɨno gaifiimɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jaadɨ Jesu imaahunoco ɨɨcɨuboro Moocaanico graciaco aacɨuboro, toonoco ijɨɨbogomɨnaaco acɨubo. Jaanoco diito imiyamɨnaama ɨfuuhi gɨcɨnɨumoma. Tollɨro bu itaavaco ɨɨfuumo iimuguudɨneheje. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jaanoco amachuumo utuvacuudɨ Jesu nuuhi, ijɨɨbogomɨnaaco: Paryɨ manaanɨ ihatyuuvoco gañɨɨcafototɨno iicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jaanoco ananɨumo gahafusuuhi, jɨiibaiñoco fahuseecɨ, siino miibaicɨ icanoco sahusedɨno sebada maahuno iicaunotɨ aatyuvuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jaano Jesu sihidɨ ejeevano ɨɨfusuco eheetavuunoco aatyɨmeumoro diito nuuhi: Miyaanoro jahi jaanɨ Moocaani iimaamɨnaafi jiinɨjehallɨvɨ asaaujiibo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jaamoro Jesuco ɨɨcɨumoro satyuujirumo aivojɨɨbotɨ iheetavequi. Jaanoco agaajacɨuboro iinoro fuubo siino ifabaɨjaagovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jaanaa mihiijɨcuudɨ ijɨɨbogomɨnaa muuaijaago fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jaamoro meenegafaño ɨjɨcamaaiumoro fuumo onegueehi Capernaujaagovɨ. Jaanaa cɨvucuuno. Jaarunaa Jesu diitojaa gaseutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jaanaa imuuaifa tɨcovauno sihidɨ guibuhuba asaauno. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jaamo ufuumo sahuse juugahusetɨ sano ɨdɨɨno kilometronohachuta icacuumaaca Jesu saauhi nɨfaihuhallɨdɨ ɨgooboro. Jaaboco aatyɨmeumoro sihidɨ igutuumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jaarunaa diitoco nuubo: Uujoho; mihiguetejirahana, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jaanegui diito diiboco imo imo imeenegafaño gaayɨcɨuhi. Jaadɨ goovano ɨɨfutuumo ufuuhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jaano seseevedɨ toonegueehivɨ miyamɨnaa ifitafutuumo gaajauhi sagaaro meenega iicaunoco. Jaagafaño Jesu ijɨɨbogomɨnaama footɨnaaca diito iinoro fuumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Jaanaa bu sagahaje gaseuhi Tiberia cuumitɨ asaauno, jaagahaje cañavuuhi Jesu graciaco aacɨunobuunatɨ maahunoco amachuuno fiitɨno. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jaamañovɨ Jesu, ijɨɨbogomɨnaa icano achahaunoco miyamɨnaa aatyɨmeumoro toono imeenenefaño ɨjɨcamaaiumoro fuumo Capernaujaago Jesuco guiinomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jaaboco onogoo muuaivɨ aatyɨmeumoro nuumo: Jɨɨbogomɨnaafi, ¿cusumi gasehinɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jaanegui Jesu diitoco iimusuuhi: Miyanotɨro, miyanotɨro amɨɨhaico neehi: Jillɨ mamachuhinɨmo mutuvahinɨneguiiha uco miguiinehi. Jillɨ sihidɨ ejeevanoco eheetavehinɨnoco mimiyaaveneguiiha icatɨno. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jaanegui ifinɨno machutaguiiha mududɨcamaaidino, ifinɨjitɨno fiivoco aacɨno machutaguiiharo mududɨcamaaje. Toonoco uujoho Miyamɨnaafibadɨ Ifiivuubo amɨɨhaico aacɨjino. Toonotɨ uujoho Moocaanitɨ asaanoco miyamɨnaa igaajaqui, bu uuvɨ Moocaani igaajataco ificucuuno icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jaanegui diiboco dilluumo: ¿Mɨllɨ jaanegui momoonɨji Moocaani iijɨco meheetavequi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jaanegui Jesu diitoco nuuhi: Moocaani imeguehi, diibo uco agalluuboco amɨɨhai mimiyaavogonoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jaanegui diiboco nuumo: ¿Eneecata sihidɨ ejeevanoco mɨɨhaico dɨhɨfusu maatyɨmemere ɨco mimiyaaveguequi? ");
INSERT INTO bmrNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mɨɨro moheedeetemɨhai machuuhi mana onoonoco sɨcaihɨgovɨ iicausumi, oono Caatɨnɨhaamefaño: Niquejeo maahunoco machusuubo, onoobadɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jaanegui Jesu iimusuuhi: Miyanotɨro, miyanotɨro amɨɨhaico neehi: Moise amɨɨhaico niqueje maahuco acɨtɨhi, Guihirubi amɨɨhaico jino miya maahu niqueje maahuco acɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jaano jino Moocaani maahu diibo niquejefañotɨ iniitoobo jiinɨjemɨnaaco fiivoco aacɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jaanegui nuumo: Aivojɨɨbo, fahiijɨvaro mɨɨhaico toono maahuco daacɨhiica, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jaanegui Jesu nuuhi: Uujoho fiivo maahu; tajaa asaamo ajebavacuujitɨhi, uco imiyaavogomoco ufucuro adufira aivucuujitɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mɨɨro amɨɨhaico uujoho eneehinɨcuubadɨ: Uco mahatyɨmecuurumo uco mimiyaaveguehicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mɨɨro paryɨ fanooro Guihirubi uco aacɨno tajaa saaji, tollɨro bu tajaa asaamoco uujoho buhɨ gañɨɨjitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Uujoho niquejefañotɨ niitehinɨtɨhi uuro iimogonoco moonɨqui icatɨno, jillɨ uco agalluuhinɨɨbo iimogobadɨ moonɨqui saahinɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jaano jino Guihirubi uco agalluuhinɨɨbo iimogono; Paryɨ diibo uco aacɨmoco saatohobaco jeevesutɨɨbo paryɨ famoocoro ufucu niinofucusumi buheetesuji. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jaano jino uco agalluuhinɨɨbo iimogono; Paryɨ famooro miyamɨnaa Moocaani Seemeneque aatyɨmemere imiyaavogomo ifinɨjitɨno fiivoma iicaqui. Jaamoco uujoho niinofucusumi buheetesuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jaanegui judiomɨ tɨcovauhi diiboco edejecuumo. Uujoho fiivo maahu niquejefañotɨ iniituubo, unuuneguiiha ");
INSERT INTO bmrNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","neehicauhi: ¿Nacu jaanɨ Jesu Jose achi icatɨɨbo? ¿Mɨɨro caani, seejɨ icamoco mɨɨhai magaajahi? ¿Mɨllɨ jaabo: Uujoho niquejefañotɨ niitehi, neehicahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jaanegui Jesu nuuhi: Musuufenɨ toono amɨɨhai dejecufiraco. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mɨɨhaiñooba tajaa saajitɨrahi Guihirubi uco agalluhinɨɨbo tajaa isɨvatɨruva. Jaamoco uujoho buheetesuji ufucu niinofucu. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mɨɨro, Moocaani iimaamɨnaa aamefaño jillɨ noono: Moocaani famoocoro jɨɨbegueji, noonoro. Jaabadɨ famooro Moocaanico uguubuumoro diibotɨ agaajamo tajaa saahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mɨɨhaiñooba Moocaanico atyɨmetɨhi ɨdɨɨboro uujoho Moocaanitɨ asaaubo Moocaanico atyɨmehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Miyanotɨro, miyanotɨro amɨɨhaico neehi: Uco imiyaavogomo ifinɨjitɨno fiivoma icaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Uujoho fiivo maahu. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mɨɨro amɨɨhai eedeete manaaco sɨcaihɨgovɨ amachuurumo chuumuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jaanotɨ naha jino niquejefañotɨ iniitono maahu. Jaanotɨ amachumo guijevetɨmo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Uujoho diiburucu jino fiivo maahu iicaabo niquejefañotɨ iniitehinɨɨbo. Jaamo uco agaayɨcɨmo ifinɨjitɨno fiivoma icaji. Jaano maahuco uujoho aacɨno taahucu. Jaanoco uujoho jiinɨjemɨnaahallɨvɨ aacɨjino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jaanegui judiomɨ tɨcovauhi sanomɨro iimaacasiumo: ¿Mɨllɨ jaabo jaanɨ mɨɨhaico duusujirahi ihuucuco? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jaanegui Jesu nuuhi: Miyanotɨro, miyanotɨro amɨɨhaico neehi: Uujoho Miyamɨnaafibadɨ Ifiivuubo uucuco muduutɨhachiijɨ, bu itɨɨjohoco mahadutɨhachiijɨ icano fiivoma mihicajitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jaanotɨ taahucuco amachuubo, tatyɨɨjohoco aaduubo icano ifinɨjitɨno fiivoma icaji. Jaaboco uujoho niinofucu buheetesuji. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jaano tafi miya machuta, tatyɨɨjoho miya adufaihu icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jaamo tafiico amachumo, tatyɨɨjohoco aadumo icano uuma icahi. Jaamoma bu uujoho tollɨro icahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mɨɨro Moocaani uco agalluubo ifiima icahi, jaaberi uujoho icahi icano. Jaabadɨro uco amachuubo uuri icaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jino niquejetɨ iniituuno maahu; amɨɨhai caanimɨhai manaaco amachuumo iguijeveubadɨ iicano icatɨno. Jaanotɨ jihɨcatɨ amachumo ifinɨjitɨno fiivoma icaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jillɨ nuubo Jesu Capernau cuumi sinagogajafaño ɨjɨɨbuguubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jaanoco sihidɨ saatoho ijɨɨbogomɨnaa uguubuumoro nuuhi: Aivo jihiimaa sihidɨ jeevahi. ¿Mɨɨjoho fɨne gaayɨcɨjirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jaanoco Jesu ijɨɨbogomɨnaa onoocasiunoco agaajacɨuboro nuubo: ¿Jaano nacu amɨɨhaico imitɨno moonɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Mɨllɨjiru fɨne imi, uujoho Miyamɨnaafibadɨ Ifiivuuboco caamo itɨconɨ iicauhɨgo ofooboco mahatyɨmeruva? ");
INSERT INTO bmrNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mɨɨro Moocaani Gaija mɨɨnoco fiivoco acɨhi. Jaanotɨ muuhucu jillɨ jihovono. Jaanotɨ naha jino uujoho ihiimaano amɨɨhai jeebɨɨco ifinɨjitɨno fiivoco aacɨjino. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jaarunofaño icamo amɨɨhaitɨ saatoho imiyaavogotɨmo, nooboro. Mɨɨro Jesu ɨmegavɨro gaajacuuhi imiyaaveguejitɨmoco, bu diiboco igaicaauqui aacɨujiiboco icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jaamaño nuubo: Toonegui amɨɨhaico neehinɨhi: Mɨɨhaiñooba tajaa saajitɨrahi Guihirubi tajaa isɨvatɨruva, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jaasumitɨro sihidɨ saatoho diibo dojɨcutɨ efeehicaumo diibeditɨ udugaavuumoro diiboma fuucuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jaanegui Jesu saatoho ijɨɨbogomɨnaa fahuseecɨ motɨhaitɨ miimɨsiicɨ icano iicaumoco nuubo: ¿Nacu bu amɨɨhai tollɨro diitobadɨro mefeeji? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jaanegui Simon Pedro diiboco iimusuuhi: ¿Aivojɨɨbo, mɨɨjaago bu mɨɨhai mefeejirahi? Mɨɨro ɨɨma icano ifinɨjitɨno fiivo iimaa. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mɨɨro mɨɨhai mimiyaaveguehinɨcuuhi. Jaamoro magaajahi ɨɨjoho Cristo Moocaani iicaabo Seemene idiicanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jaanegui Jesu diitoco nuuhi: Amɨɨhai docedɨmoco uujoho ɨcɨhinɨhi. Jaamo amɨɨhaifañotɨ iicaabo saafi ɨjɨ iicaabo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jillɨ nuubo Juda Iscariote Simon achiditɨ. Jaabo Juda docedɨmoobo iicaubo Jesucristoco iguijenɨqui aacɨujiibo. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jaanobuunatɨ Jesu Galilea jiinɨjeri ɨgooboro feehicauhi. Jaaboro Judea jiinɨjevɨ ofoonoco imeguehicautɨɨbo judiomɨ diiboco tahɨ agaicaauguuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jaanaa fiitɨcuuno tabernaculojano jɨɨbaimo iicaujino; tusumi judiomɨ nɨjeganofañoro icanɨcɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jaaneguiiha Jesuco inahabomɨ nuuhi: Jinootɨ difo Judeavɨ. Tahɨ iicamo didojɨcutɨ ofoonɨcɨmo edeetavonoco ihatyɨmequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mɨɨro mɨɨhaiñooba miyamɨnaaco ifiico igaajasuqui omoonɨmo toovono moonɨtatɨhi, tollɨ bu omoonɨɨbo famoo ɨmefeenevɨro moonɨhica, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jillɨ nuumo inahabomɨ icarumo diiboco imiyaaveguehicautɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jaanegui Jesu diitoco nuuhi: Tufucuvɨhiica uujoho ɨɨfototɨhiica. Jaanotɨ amɨɨhaidi naha fafucuvaro imihi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mɨɨro amɨɨhaico jiinɨjemɨnaa jɨɨheguetɨhi. Jaanotɨ uco jɨɨhegueme diito imitɨco onoonohallɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amɨɨhairyo tobaimojaago mofoo. Jaanotɨ uujoho tobaimovɨ footɨhiica tahoovofucuvɨhiica uujoho ɨfototɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Diitoco tollɨ unuuboro fitafutuubo Galileavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jaadɨ inahabomɨ tobaimojaa ufuunobuunatɨ, Jesu tollɨro bu fuuhi. Jaaruubo foovono fuutɨɨbo, toovonoro fuubo saatohoba diiboco aatyɨmeujiruneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jaaboco judiomɨ tobaimoguiino iguiinomoro neehicauhi: ¿Cuuca fɨne iicaabo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jaabeditɨ sihidɨ miyamɨnaa mɨrɨbacasihicauhi. Saatoho neehicauhi: Aivo imihuseebe, noomoro. Jaanotɨ saatoho neehicauhi: Imitɨɨbo miyamɨnaaco bañɨhicaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jaarumo mɨɨhaiñooba foovono diibeditɨ iimaahicautɨhi judiomɨ ñɨhicutɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jaanaa ijɨɨbaimo feeneveunaaca Jesu templojafaño jɨcafutuuhi. Jaaboro tɨcovaubo ɨjɨɨbuguubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jaaneri judiomɨ sihidɨ eheetyemere neehicauhi: ¿Mɨllɨ jaabo sihidɨ fanoovaco gaajahi aamenefaño icautɨruubo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jaanegui Jesu diitoco iimusuuhi: Uujoho tajeebɨɨtɨro jɨɨbogotɨhi uco agalluuhinɨɨbo jɨɨbogoco uujoho jɨɨbeguehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Cajaatyohacho Moocaani iimogonocoro omoonɨgomo, gaajaji Moocaani jɨɨbogoco ɨjɨɨbogonoco nacu tajeebɨɨtɨro uujoho onoono iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jaanotɨ ijeebɨɨtɨro ihiimaabo diiboco miyamɨnaa obocɨgonoco imeguefihi. Jaanotɨ diiboco agalluhinɨɨboco obocɨgoobo, miyaanoco iimaahi. Jaabofaño bañɨfiira chahahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mɨɨro amɨɨhaico Moise tajɨɨbaco acɨuhi. Jaarunoco amɨɨhaitɨ saatohoba imino moonɨtɨhi. ¿Collɨhi jaamo uco magaicaaujirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jaanegui miyamɨnaa iimusuuhi: Ɨɨjoho ɨjɨma diicahi. ¿Mɨɨjoho nacu ɨco gaicaaujirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jaanegui Jesu diitoco nuuhi: Sanoocoro jaguisɨfucusumi omoonɨhinɨneri famooro meheetyehinɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mɨɨro Moise amɨɨhaico tajɨɨbauhi amɨɨhai meehe nigacɨ quitɨcɨco. Jaarunoco diibo tɨconɨutɨhi omoonɨubo, amɨɨhai eedeetemɨhai toonoco tɨconɨuhi eheetavuumo. Jaanoco amɨɨhai jaguisɨfucusumi meheetavonɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jaano Moise tajɨɨba gañɨɨcafototɨno iicaqui momoonɨmoro jaguisɨfucusumi gaifi seemene meeheque miquitɨcɨnɨcɨhi. ¿Jaamo collɨhi tajaa mɨsɨfiiratehi jaguisɨfucusumi saafi miyamɨnaafico faabohocoro ubuheesuhinɨnohallɨtɨ? ");
INSERT INTO bmrNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Imino meecɨtɨmoro saatohoditɨ mihiimaadino. Jari imino magaajaadɨ mihiimaa, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jaanaa saatoho Jerusaleri iicahicaumo nuuhi: ¿Nacu jaanɨco iguijenɨqui iguiinehicaabo icatɨɨbo? ");
INSERT INTO bmrNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Memeecɨ ono famoofeenevɨro iimaaruuboco mɨɨhaiñooba mɨllɨ moonɨtɨhi: ¿Naa fɨne jisumi aivojɨto gaajacuuhi diibo Cristo iicanoco? ");
INSERT INTO bmrNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Jaanotɨ mɨɨhai magaajahi tahɨgotɨ diibo asaahɨgoco. Jaanotɨ Cristo asaadɨ mɨɨhaiñooba gaajajitɨhi cuucatɨ diibo asaanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jaanegui Jesu templojafaño ɨjɨɨbuguumañotɨ sefano nuubo: Uco naha amɨɨhai magaajahi tahɨgotɨ asaahɨgoco. Jaaruubo uujoho tajeebɨɨtɨro saatɨhi. Jaabo uco agalluuhinɨɨbo miyaabo iicaaboco amɨɨhai magaajatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jaanotɨ uujoho diiboco gaajahi diibotɨ asaahinɨmaño. Mɨɨro diibo uco galluuhinɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jaanegui diito diiboco gaayɨcɨujirahi diiboco icɨvojaanɨqui. Jaarunofaño mɨɨhaiñooba diiboco gaayɨcɨutɨhi ihoovofucuvɨ ɨɨfutuutɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jaarunofaño sihidɨ diitotɨ saatoho diiboco miyaavuguuhi. Jaamoro nuuhi: ¿Nacu Cristo asaadɨ jaanɨ sihidɨ ejeevanoco eheetavehicano janaanɨcɨ eetavejiruubo fɨne? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jaanoco fariseomɨ guubuuhi miyamɨnaa toonotɨ ɨmɨrɨbacasiunoco. Jaaneguiiha sacerdotemɨ aivojɨto, fariseomɨ icamo sisɨmɨnaaco galluuhi Jesuco igaayɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jaanegui Jesu diitoco nuuhi: Gueenenehiica amɨɨhaima icaji. Jaadɨ dojɨcuvɨro feeji uco agalluubojaago. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jaaboco miguiinejirahi. Jaarumo uco mahatyɨmejitɨhi uujoho iicahɨgo amɨɨhai mɨhɨfetejitɨmaño uco mahatyɨmejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jaanegui judiomɨ sanomɨro noocasiuhi: ¿Cuuca fɨne jaabo ofooboco mahatyɨmejitɨhi? ¿Nacu fɨne griegomɨfeenevɨ judiomɨ agavaracɨnɨmojaago feejiibo griegomɨco ijɨɨbeguequi? ");
INSERT INTO bmrNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Mɨllɨ fɨne eneejirunoco oono mɨɨhaico noobo: Uco miguiinejirahi. Jaarumo uco mahatyɨmejitɨhi uujoho iicahɨgo mɨhɨfetejitɨmaño, noobo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jaanaa niinofucu imiya jɨɨbaimofucu Jesu agañiivuuboro sefano nuuhi: Saatoho adufirari mihicahachiijɨ tajaa masaamoro, mahaduva. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Uco imiyaavogoobo, Caatɨnɨhaamefaño onoobadɨ: Dijeebɨɨfañotɨ fiivo muuai nɨfaihu cuuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jillɨ Jesu nuuhi: Diiboco imiyaavogomo Igaijaco agaayɨcɨjinoco. Tusumihiica Moocaani Gaija niituutɨhiica Jesu niquejefaño ufuutɨmañehiica. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jillɨ Jesu unuunoco diitofeenetɨ saatoho uguubuumoro nuuhi: Miyaanoro jahi jaanɨ Moocaani iimaamɨnaafi asaajiibo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jaanotɨ saatoho neehicauhi: Jaanɨ Cristo, noomoro. Jaanotɨ saatoho neehicauhi: ¿Nacu Galileatɨ Cristo saajirahi? ");
INSERT INTO bmrNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mɨɨro Caatɨnɨhaamefaño noono: Cristo saaji, Aivojɨɨbo David yotofañotɨ tollɨro Belen allɨo cuumijefañotɨ David iicauhɨgotɨ saajiibo, noono, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jaamoro miyamɨnaa fahɨgova dugaavocasiuhi Jesuhallɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jaanegui diitotɨ saatoho diiboco igaayɨcɨqui moonɨurahi. Jaarumo saatohoba mɨllɨ diiboco moonɨutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jaanaa isisɨmɨnaa tahɨgotɨ siino saauhi. Jaamoco sacerdotemɨ aivojɨto fariseomɨ icamo nuuhi: ¿Collɨhi jana jaaboco mɨsɨvatɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jaanegui isisɨmɨnaa iimusuuhi: ¡Aivo chahamo saatohoba diibobadɨ ihiimaamo! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jaanegui fariseomɨ diitoco nuuhi: ¿Tollɨro bu nacu amɨɨhai diibo abañɨnoco mimiyaaveguehi? ");
INSERT INTO bmrNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Nacu amɨɨhaidi saatoho aivojɨtotɨ, fariseomɨtɨ icano miyaaveguehi? Imiyaavogotɨmo duhu. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jaanotɨ jito miyamɨnaa tajɨɨbaco agaajatɨmo jillɨ cɨɨjɨgaifaño efeejimo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jaanegui diitoobo saafi Nicodemo onoobo safoono Jesuco fucu emeecɨjeubo, nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿Nacu mɨɨhai tajɨɨba saafi miyamɨnaafico: Iimitɨ, neejirahi, itɨconɨ diibo omoonɨnoco gaajacɨtɨmoro? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jaanegui diiboco nuumo: ¿Nacu bu ɨɨjoho Galileaoobo? Eneecau, imino Caatɨnɨhaameque dɨhɨɨfɨnɨcɨ Galileatɨ Moocaani iimaamɨnaa saatatɨhi, noomoro ");
INSERT INTO bmrNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ijeevadɨ sahaje iijanojaa foocɨnɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jaanotɨ Jesu fuuhi Olivohono iicagajɨjaago. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jaano seseevedɨ fucuro Jesu siino templojafaño saauhi. Jaabojaago sihidɨ miyamɨnaa saauhi. Jaamoco acasɨɨvuuboro tɨcovaubo ɨjɨɨbuguubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jaanaa fariseomɨ, caatɨnɨmɨnaa icamo diibojaa sɨvauhi gaigooco gaifiimɨma iicafifihicaugoco. Jaagoco diitofeenevɨ ificuumoro ");
INSERT INTO bmrNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","nuumo: Aivojɨɨbo Jesu, jaamo aijɨ icanaaca, sifiima faguifaño icagoco mahatyɨmehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mɨɨro Moise itajɨɨbafaño jillɨ mɨɨhaico neehi: Tollɨ iicagoco guiisiri mahaamɨmoro magaicaau, nooboro. ¿Jana ɨɨjoho mɨllɨ neehi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jillɨ nuumo diiboco ɨnɨsuumo, ɨɨfurumo toonohallɨtɨ diiboco icɨvojaanɨqui. Jaanegui Jesu jiinɨjehallɨvɨ ɨdɨjɨɨvuuboro tɨcovaubo ihusegairi jiinɨjeque acaatɨnɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jaarunaa suufenɨtɨmo diiboco idilluhicaunegui, agañiivuuboro diitoco nuuhi: Eneecata amɨɨhaitɨ saatoho imitɨma machahamo mɨtɨconɨ diigoco guiisibari mahaamɨmo, ");
INSERT INTO bmrNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","nooboro siino ɨdɨjɨɨvuuboro ijiinɨjeque caatɨnɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jillɨ unuunoco uguubuumoro tollɨro diito iimitɨma iicaunoco ijeebɨɨfañodɨ agaajaumoro ihamiyatotɨ tɨcovaumo safiisari ofoocɨnɨumo. Jaanaa Jesu diigo icanoro covovacafutuuhi tomañovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jaadɨ Jesu agañiivuudɨ mɨɨhaiñoobaco atyɨmecuutɨɨbo, ɨdɨɨgoro diigo toonovɨ ifitafutuugoco aatyɨmeuboro nuubo: Gaigo, ¿cuuca icamo dihallɨvɨ imitɨno ihiimaahicamo? ¿Mɨɨro saatohoba ɨco mɨllɨ moonɨtɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jaanegui nuugo: Aivojɨɨbo, saatohoba mɨllɨ uco moonɨtɨhi, noogoro. Jaanegui Jesu diigoco nuuhi: Uujoho bu icaruubo mɨllɨ ɨco moonɨtɨhi. Fuucu. Jaagoro siino imitɨno diicacuujirahana, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jaadɨ siino Jesu ihiimaauboro miyamɨnaaco nuubo: Uujoho jiinɨjemɨnaa jeebɨɨco aachɨcɨnɨɨbo, tadyojɨcutɨ asaabo cɨvohɨ icajitɨhi. Jaano ifinɨjitɨno fiivoco aacɨno foovoma icajiibo. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jaanegui fariseomɨ diiboco nuuhi: Ɨɨjoho difiitɨro dɨɨbeguehicahi. Jaano dijɨɨbogo ibocɨma chahahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jaanegui Jesu diitoco iimusuuhi: Jaaruno uujoho tahallɨvɨro ɨjɨɨbuguruno tajɨɨbogo ibocɨma icahi, uujoho asaahinɨhɨgoco, ofoohɨgoco icano agaajamaño. Jaanotɨ amɨɨhai magaajatɨhi uujoho tahɨgotɨ asaahinɨhɨgoco, ofoohɨgoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jaamo amɨɨhai miyamɨnaa imitɨco meneehi jiinɨjemɨnaa tajɨɨbafeenedɨ. Jaanotɨ uujoho mɨɨhaiñoobaco dugaacutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jaanotɨ dugaacuruva, uujoho udugaacuno miyaanejiru, saafiiro uujoho icatɨhi, Guihirubi uco agalluuhinɨɨboma mihicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mɨɨro amɨɨhai tajɨɨba aamefaño noocɨnɨno: Miimɨsiicɨ ɨjɨɨbogono ibocɨma icahi, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mɨɨro uujoho tafiitɨro jɨɨbeguehi, tollɨro bu Guihirubi uco agalluuhinɨɨbo uutɨ jɨɨbeguehi icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jaanegui diiboco nuumo: ¿Cuuca nacu diicaani icahicahi? noomoro. Jaanegui Jesu diitoco nuuhi: Uco amɨɨhai magaajatɨhi, bu tollɨro Guihirubico magaajatɨhi icano. Jaanotɨ uco magaajaruva tollɨro Guihirubico magaajajirahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jillɨ Jesu nuuhi templojafaño ɨjɨɨbuguubo nɨhɨbamɨco ɨjɨcuhicauno cojɨvɨ. Jaaruuboco mɨɨhaiñooba gaayɨcɨutɨhi, ihoovovɨ ɨɨfutuutɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Uujoho feeji. Jaaboco miguiinurumo uco aatyɨmetɨmoro amɨɨhai imitɨmaryo miguijeveji. Uujoho ofoohɨgo amɨɨhai mefeejitɨhi, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jaanegui judiomɨ nuuhi: ¿Nacu fɨne iinoro ifiico guijenɨjiibo. Jaamaño: Uujoho ofoohɨ mefeejitɨhi, noobo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jaanegui Jesu nuuhi: Amɨɨhai baaoto. Jaanotɨ uujoho caamoobo. Amɨɨhai jiijemɨnaa. Jaanotɨ uujoho jiijemɨnaafi icatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jaamaño amɨɨhaico: Amɨɨhai imitɨmaryo miguijeveji, neehi. Mɨɨro uco mimiyaavogotɨhachiijɨ amɨɨhai imitɨmaryo miguijeveji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jaanegui dilluumo: ¿Mɨɨjoho nacu ɨɨjoho? noomoro. Jaanegui Jesu diitoco nuuhi: Sɨɨcɨjetɨro amɨɨhaico neehicacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Sihidɨ icano amɨɨhaico eneejino, amɨɨhaitɨ udugaacujino icano. Jaarunofaño uco agalluubo miyaanocoro neefihi. Jaabo uujoho diibotɨ uguubuunoco jiinɨjemɨnaaco jɨɨbeguehicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jaarunoco diito gaajahicautɨhi Moocaaniditɨ ihiimaahicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jaadɨ nuubo: Jari caamovɨ Miyamɨnaafibadɨ Ifiivuuboco guijeve ɨmohobujehallɨvɨ magañiiyɨcɨdɨ magaajaji, uujoho diiboro iicanoco. Tollɨro bu tajeebɨɨtɨro uujoho omoonɨhicatɨnoco magaajaji, bu tollɨro Guihirubi uco ɨjɨɨbeguehicanocoro omoonɨhicanoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Uco agalluuhinɨɨbo uuma icahi. Jaabo Guihirubi uco jeevesutɨhi, diibo iimogonocoro omoonɨhicamaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jillɨ Jesu unuunotɨ saatoho sihidɨ diiboco miyaavuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jaanegui judiomɨ diiboco imiyaavuguudɨmoco Jesu nuuhi: Taajɨco jeevesutɨmo mihicahachiijɨ miyaano tajɨɨbogomɨnaa mihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jaachiijɨ magaajaji miyaanoco. Jaano miyaano amɨɨhaico imitɨfañotɨ sinaayuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jaanegui diito nuuhi: Mɨɨhai Abraham iyaachimɨhai mihicamo sita jɨjovoto mihicatatɨhi. ¿Mɨllɨtɨ jaabo mɨɨhaico ɨɨjoho misinaayucafeteji neehi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jaanegui Jesu diitoco nuuhi: Miyanotɨro, miyanotɨro amɨɨhaico neehi: Paryɨ famooro imitɨco omoonɨmo, imitɨ jɨjovoto. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jaamaño jɨjovoobotɨ iicaabo ihaivojɨɨbo seemefañodɨ icatatɨhi. Jaanotɨ iseemene diitofañodɨ icanɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jaamaño uujoho Moocaani Seemene amɨɨhaico isinaayuhachiijɨ miyanotɨro jɨjovoto mihicacuujitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Uujoho gaajarahi amɨɨhai Abraham iyaachimɨhai mihicanoco. Jaarumo uco magaicaauguehicahi, uujoho onoonoco muguubutɨmoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Uujoho iimaahicahi Guihirubi uco ɨjɨɨbogobadɨ. Jaanotɨ amɨɨhai momoonɨhicahi amɨɨhaico amɨɨhai caani ɨjɨɨbogobadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jaanegui diito nuuhi: Mɨɨhai caani Abraham, noomoro. Jaanegui Jesu diitoco nuuhi: Miyaano amɨɨhai caani Abraham iicaruva diibo omoonɨubadɨ momoonɨjirahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","¿Collɨhi jaamo uco magaicaaujirahi? Tollɨ iicanoco Abraham safooba moonɨutɨhi. Mɨɨro amɨɨhaico miyaanoco jɨɨbeguehicahi Moocaani uco unuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jaanotɨ amɨɨhai, amɨɨhai caani omoonɨnɨcɨbadɨ momoonɨhicahi, nooboro. Jaanegui nuumo: Mɨɨhai ajeva seeme mihicatɨhi, saafiiro mɨɨhai caani Moocaani, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jaanegui Jesu diitoco nuuhi: Amɨɨhai caani Moocaani iicaruva uco magaijɨjirahi. Uujoho diibojaagotɨ saahinɨhi, tajeebɨɨtɨro uujoho saahinɨtɨhi diibo uco agalluuhinɨnegui saahinɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Collɨhi jaamo taajɨco muguubuhicatɨhi? ¿Collɨhi tajɨɨbogoco mihimeguehicatɨhi muguubunoco? ");
INSERT INTO bmrNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amɨɨhai caani Ɨjɨ. Jaabo onoobadɨ momoonɨnoco mihimeguehicahi. Mɨɨro diibo sɨɨcɨjetɨro imoyɨɨcɨɨbo miyamɨnaaco agaicaaunoco, imoyɨɨcɨtatɨɨbo miyaanofaño iicanoco. Jaaboma miyaano chahahi, jihovoobo iicamaño sɨcamañooco iimaabo, bañɨfiira caani iicamaño bañɨfifiibo. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jaanotɨ uujoho miyaanoco unuurunoco uco mimiyaaveguehicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nacu mɨɨjoho amɨɨhaitɨ saatoho ɨfusujirahi tafifa sanogayɨba imitɨ iicanoco? Jaabo miyaanoco onoonoco; ¿Collɨhi uco mimiyaaveguehicatɨhi? ");
INSERT INTO bmrNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Moocaanitahe iicaabo, Moocaani iijɨco guubunɨcɨhi. Jaanotɨ amɨɨhai Moocaanita mihicatɨmaño Moocaani iijɨco muguubugotɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jaanegui judiomɨ iimusuuhi: Aivo miyaano ɨɨjoho samariaoobo idiicanoco ɨco monoono. Jaabo ɨjɨma diicahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jaanegui Jesu diitoco nuuhi: Uujoho ɨjɨma icatɨhi, uujoho Guihirubico bocɨguehi. Jaaruuboco uco amɨɨhai mobocɨgotɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jaaruubo uujoho tafi bocɨgoco guiinotɨhi, iicaabo saafi uco obocɨgonoco iguiinooboro udugaacuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Miyanotɨro, miyanotɨro amɨɨhaico neehi: Taajɨco imimiyaavogomo ifinɨjitɨno guijevefaño feejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jaanegui diiboco judiomɨ iimusuuhi: Jisu aivo imino magaajacuuhi ɨjɨma idiicanoco. Mɨɨro Abraham, bu paryɨ Moocaani iimaamɨnaa icamo paryɨ guijeveuhi. ¿Mɨllɨ jaabo ɨɨjoho neehi: Taajɨco uguubumo guijevetɨmo icaji? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Nacu ɨɨjoho mootadi Abraham janaanɨcɨ deevahi? Jaaruubo du guijeveuhi, bu paryɨ Moocaani iimaamɨnaa icaurumo guijeveuhi. ¿Jaanotɨ mɨɨjoho ɨɨjoho idiicaabo guijevetɨɨbo diicaji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jaanegui Jesu diitoco nuuhi: Uujoho tafiicoro bocɨgoruva, uuro obocɨgono jaaducafetejitɨrahi. Guihirubi uco bocɨguehi diiboco amɨɨhai Moocaani monoobo. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Jaaruuboco amɨɨhai magaajatɨhi. Jaanotɨ uujoho naha gaajahi. Jaanotɨ: Uujoho diiboco gaajatɨhi, nuuruva amɨɨhaibadɨ bañɨfifijirahi. Miyanotɨro uujoho diiboco agaajamaño diibo iijɨco moonɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mɨɨro Abraham amɨɨhai tyadi imo imo icauhi uco aatyɨmegueuboro. Jaabo uujoho asaajinoco agaajacuuboro imo imo icaubo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jaanegui judiomɨ diiboco nuuhi: ¿Mɨllɨ jaabo cincuentadɨno ficabano diicatɨɨbo, Abrahamco daatyɨmeuhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jaanegui Jesu diitoco nuuhi: Miyanotɨro, miyanotɨro amɨɨhaico neehi: Abraham chahaunaacaro uujoho icacuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jaanegui guiisibanoco ɨcɨumo diiboco ihaamɨqui. Jaarunaa Jesu templojafaño afataniivuuboro diitofeenedɨ ihiinehinɨuboro fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jaanaa Jesu afatyuubo atyɨmeuhi ifiivuunotɨro aatyɨmeutɨɨboco. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jaabeditɨ ijɨɨbogomɨnaa Jesuco dilluuhi: ¿Mojɨɨbogomɨnaafi, mɨɨjoho imitɨco omoonɨumaño, jaanɨ atyɨmetɨɨbo fiivuuhi, caanimɨsi nacu diibo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jaanegui Jesu diitoco nuuhi: Caanimɨsi, diibo icano imitɨco omoonɨumaño icatɨno. Jillɨ Moocaani mitya diibovɨ ihɨfusucafetequi ifiivuuno. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mɨɨro cuuje iicanohachuta uco agalluuhinɨɨbo dudɨcamaajeque eetavehi. Jaanotɨ mihiijɨcuudɨ mɨɨhaiñooba dudɨcamaaitacuutatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mɨɨro jino jiinɨjehallɨri iicanohachuta uujoho jiinɨjemɨnaaco achɨcɨnɨhi, ");
INSERT INTO bmrNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","nooboro jiinɨjehallɨvɨ ɨjɨɨreuboro toonoco jiinɨma illiheenɨuboro ijiinɨri aatyɨmeutɨɨbo aallɨɨnoco nicuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jaaboro diiboco nuubo: Foobo Galluuba jɨcooba nɨfaihuri nitɨto, nooboro. Jaaba jɨcooba momo hebreo iijɨri Siloe. Jaanegui initamaaijeuboro tahɨgotɨ atyɨmecuubo saauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jaanegui ifiitɨnomɨnaa itɨconɨ atyɨmetɨɨbo iicahicaunoco agaajaumo nuuhi: ¿Nacu jaanɨ oono acasɨɨvooboro nɨhɨbamɨco idilluhicaubo icatɨɨbo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jaanotɨ saatoho: Jɨɨhɨ, diibo, neehicauhi. Jaanotɨ saatoho: Sifi diibobadɨ ejeevaabo, neehicauhi. Jaarunofaño diibo neehicauhi: Uujoho diiboro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jaanegui diiboco nuumo: ¿Mɨllɨ jaano ɨco dihaallɨɨno faayacafetehi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jaanegui diitoco iimusuubo: Jesu onoobo jiinɨco ijɨɨrema eetavooboro uco tahaallɨɨnoco nicuhi. Jaaboro uco noobo: Foobo Siloe jɨcoobafaño nitɨto, eneenegui ofooboro nitɨjehinɨhi. Jaaneri tahaallɨɨno uco faayacafetehinɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jaanegui nuumo: ¿Cuuca jaabo icahi? noomoro. Jaarunaa diibo: Coo, gaajatɨhi, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jaadɨ diibo aatyɨmehicautɨɨboco satyuumo fariseomɨ ɨmegavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jaanaaca diiboco Jesu jiinɨbari ihaallɨɨnoco ataabuuboro ubuheetesuufucuu jaguisɨfucuu. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jaaboco siino fariseomɨ dilluuhi: ¿Mɨllɨ ɨco dihaallɨɨno faayacafetehinɨhi? noomoro. Jaanegui nuubo: Jiinɨbari uco tahaallɨɨnoco nicuhinɨɨbo. Jaanoco initamaainɨneri atyɨmehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jaanegui fariseomɨtɨ saatoho nuuhi: Diibo Moocaanitɨ saatɨhi. Jaamaño jaguisɨfucuco imino toomotɨɨbo, noomoro. Jaanotɨ saatoho neehicauhi: Imitɨmɨnaafi iicaruva jino sihidɨ ejeevano mityaco eetavejitɨruubo, noomoro. Jaamaño diito sanoodɨmo dugaacamaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jaamoro siino aallɨɨvautɨɨboco nuumo: Jaanotɨ ɨɨjoho, ¿mɨllɨ neehi dihaallɨɨnoco afaayɨcɨhinɨɨbeditɨ? noomoro. Jaanegui nuubo: Etɨ, Moocaani iimaamɨnaafi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jaarunaa judiomɨ miyaavuguutɨhi diibo ihaallɨɨnoco afaayɨcɨunoco icano. Jaamoro caanimɨsico cuuhuvaumo igaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jaadɨ diitɨsico dilluumo: ¿Naa jaanɨ amɨɨsi seemene aallɨɨvatɨɨbo ifiivuubo meneehicaabo? ¿Mɨllɨ bu jaabo oono ihaallɨɨnoma icahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jaanegui caanimɨsi nuuhi: Jɨɨhɨ, magaajahi diibo moseemene aallɨɨvatɨɨbo ifiivuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jaaruno magaajatɨhi fɨne mɨllɨhacho tahɨ atyɨmeebe, bu tollɨro magaajatɨhi mɨɨjohohacho fɨne diiboco ubuheesuhinɨnoco. Tahɨ diiboco midillu, diibo amiyaaburucu; tahɨ mɨllɨhacho amɨɨhaico jɨɨbeguejiibo, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jillɨ caanimɨsi nuuhi, judiomɨco iiguiumɨsiro, judiomɨ cajaatyohacho, Jesuco: Cristo, onoomoco sinagogajafañotɨ magañɨɨji, noomoro ifitacucasiuno ñɨhicutɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jillɨtɨ caanimɨsi: Amiyaaburucu tahɨ diiboco midillu, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jaanegui siino coovaumo ihaallɨɨnoma achahauboco. Jaamoro diiboco nuumo: Moocaanicoro dihimo. Jaanotɨ diibo imitɨmɨnaafi iicanoco mɨɨhai magaajahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jaanegui diibo iimusuhi: Coo, tahɨ fɨne imitɨmɨnaafi uujoho gaajatɨhi. Ɨdɨɨnocoro gaajahi uujoho aatyɨmeutɨruubo jisumi aatyɨmeneque, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jaanegui siino diiboco dilluumo: ¿Mɨllɨ dihaallɨɨnoco omoonɨhinɨneri daatyɨmehi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jaanegui nuubo: Amɨɨhaico jɨɨbugucuurahi. Jaarunoco mimiyaavogotɨmoro bu ¿collɨhi siino muguubujirahi? ¿Nacu bu amɨɨhai tollɨro diibo jɨɨbogomɨnaatɨ mihicajirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jaanegui diiboco ɨɨbaumoro nuumo: Ɨɨjohonaa diibo jɨɨbogomɨnaafi. Jaanotɨ mɨɨhai Moise jɨɨbogomɨnaa. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mɨɨhai magaajahi Moocaani Moisema ihiimaaunoco. Jaanotɨ magaajatɨhi diibo cuucatɨobo iicanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jaanegui diibo iimusuuhi: Toono aivo uudi sihidɨ jeevahi, cuucatɨobohacho diibo iicanoco magaajatɨno. Jaabo uco tahaallɨɨnoco atyɨmesuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mɨɨro mɨɨhairyo magaajahi imitɨmɨnaaco Moocaani uguubunɨcɨtɨnoco. Jaanotɨ diibojaagodɨ iicamoro, diibo iimogobadɨ omoonɨmoco icano guubunɨcɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sɨɨcɨjetɨro guuburatatɨno saatohoba ifiivonotɨro aatyɨmetɨɨboco atyɨmesumo onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jaanɨ Moocaanitɨ isaatɨruva mɨllɨba moonɨjitɨruubo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jaanegui diiboco nuumo: ¿Ɨɨjoho aivo sihidɨ imitɨma ifiivuubo, mɨɨhaico dɨɨbeguejira? noomoro diiboco gañɨɨumo sinagogajatɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jaanoco Jesu guubuhi diiboco agañɨɨunoco. Jaaboco atyɨmeuboro nuubo: ¿Ɨɨjoho miyaaveguehi Moocaani Achico? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jaanegui diibo iimusuuhi: Aivojɨɨbo, uco dɨɨbogo mɨɨjoho diibo miyaaveguequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jaanegui Jesu diiboco nuuhi: Ɨɨro daatyɨmecuuhi. Jino uujoho diibo ɨɨma ihiimaabo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jaanegui diibo Jesu ɨmega ememuɨɨvuuboro nuuhi: Miyaaveguehi, aivojɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jaanegui Jesu nuuhi: Uujoho jiijehallɨvɨ saahinɨhi dugaacuguiiha, atyɨmetɨmo ihatyɨmequi. Jaanotɨ atyɨmeme, atyɨmecuutɨmo iicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jaanegui saatoho fariseomɨ diiboma iicaumo jillɨ diibo unuunoco uguubuumoro diiboco dilluumo: ¿Nacu bu mɨɨhai tollɨro mahatyɨmetɨmo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jaanegui Jesu diitoco iimusuuhi: Amɨɨhai aallɨɨno ihɨfuvusutɨruva amɨɨhai imitɨma machahajirahi. Jaanotɨ: Mahatyɨmehi, monoomaño amɨɨhai imitɨma mihicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Miyanotɨro amɨɨhaico neehi: Ovejamɨ mecufaño iguhugari jɨcafototɨɨboro sinaagonodɨro ofoobo nanivamɨnaafi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jaanotɨ tomecufaño iguhugari ɨjɨcafotoobo naha diito toomomɨnaafi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jaabedi iguhuga toomomɨnaafi iguhugaco faayɨcɨfihi. Jaahugari ɨjɨcafotooboco ihovejamɨ ihiimaatɨro gaajacɨfihi. Jaamoco itɨcovocɨvɨ imomono icahi. Jaabo diitoco imemeri ocoovaaboro jahisivɨ iinusufiibo. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jaadɨ jahisivɨ famoocoro ihiinusuuboro ihɨme foonɨcɨɨbo. Jaabo dojɨcutɨ ihovejamɨ foonɨcɨhi diibo iimaaco agaajamoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jaanotɨ agaajatɨɨbo dojɨcutɨ footatɨmo. Jillɨro gaafimo diibeditɨ diibo iimaaco agaajatɨmaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jillɨ Jesu oovɨcɨuboro diitoco nuuhi. Jaarunoco diito gaajacɨutɨhi mɨllɨ eneejirunoco unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jaadɨ bu Jesu siino diitoco nuuhi: Miyanotɨro, miyanotɨro amɨɨhaico neehi: Uujoho ovejamɨ guhuga. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Itɨconɨ tahɨmegavɨ asaaumo paryɨ nanivamɨnaa. Jaamo iimaaco ovejamɨ gaajautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Uujoho guhuga, tafañodɨ ɨjɨcafotoobo taajaji. Jaabo oveja iicanɨcɨbadɨ tomecufaño ɨjɨcafotooboro siino ihiinoobo ñaavahuco aatyɨmenɨcɨbadɨ icaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jaanotɨ nanivamɨnaafi saanɨcɨhi inaniquiro, igaicaauquiro, ifinɨsuquiro icano. Jaanotɨ uujoho saahinɨhi fiivoma mihicaqui, sihidɨ janaanɨcɨ toonoma mihicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Uujoho miya toomomɨnaafi; Mɨɨro miya toomomɨnaafi iicaabo ihovejamɨhallɨvɨ ifiico acɨnɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jaanotɨ ijaadaguiiharo otoomoobo jɨcu diitojaago asaanoco aatyɨmeebere ihovejamɨco ejeevesuhinɨɨboro iicojɨtɨ gaanɨcɨhi ita iicatɨmaño. Jaanobuuna ijɨcu asaaboro diitoco buhɨgovɨ gavaracunɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jaabo diibo diitoco jeevesunɨcɨhi jillɨ ijaadaguiiharo ududɨcamaaimaño. Jaamaño diitoco jeecɨvotatɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jaanotɨ uujoho iimino toomomɨnaafi. Jaamaño taatyaco gaajahi. Jaabadɨro bu diito uco gaajahi taatya iicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Uco bu oono Guihirubi agaajabadɨ, jaaboco bu uujoho gaajahi icano. Jaamaño tahovejamɨhallɨvɨ uujoho tafiico acɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tollɨro bu saatoho tahovejamɨ icahi jimecuoto iicatɨmo. Jaamoco tollɨro sɨvaji. Jaamo tahiimaaco guubuji. Jaamo samooro icaji. Jaamo toomomɨnaafi saafiiro icaqui, ");
INSERT INTO bmrNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","uco Guihirubi gaijɨhi, tafiico diitohallɨvɨ aacɨɨboro, siino ubuheetejimaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mɨɨjoho uco guijenɨjitɨrahi, jillɨ uuro iimogobabadɨ tafiico acɨji. Jaabo iguijeveruubo siino dojɨcuvɨro buheeteji mityama iicamaño. Jillɨ moonɨqui Guihirubi uco tajɨɨbauhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jillɨ unuuneri judiomɨ siino dugaavocasiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jaabotɨ sihidɨ saatoho neehicauhi: Ɨjɨma icaabo jillɨ jeegavucuubo. ¿Collɨhi jaaboco muguubunɨcɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jaarunaa saatoho neehicauhi: Ɨjɨma iicaabo jillɨ iimaatatɨhi. ¿Nacu ɨjɨ ihaallɨɨno aatyɨmetɨmoco atyɨmesujirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jaanaa Jerusalevɨ eetavuumo jɨɨbaimoco templojaco Moocaanicoro ijeecɨvehicaqui ificuuno jɨɨbaimoco jɨɨnijadɨɨhivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jaasumi Jesu templojahallɨdɨ, Salomon goohasino onoohasijeri ɨgooboro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jaabohallɨdɨ judiomɨ emecuvovaumoro diiboco nuuhi: ¿Mɨhachuta jaabo mɨɨhaico, esamaaisuuboro diicaji? Miyaano ɨɨjoho Cristo idiicahachiijɨ mɨɨhaico foovono dɨɨbugucu, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jaanegui Jesu diitoco nuuhi: Amɨɨhaico neehicacuurahi. Jaarunoco mimiyaaveguehicatɨhi; Mɨɨro Guihirubi atajɨɨbabadɨ uujoho omoonɨno toono foovono uutɨ jɨɨbeguehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jaarunoco amɨɨhai mimiyaavogotɨhi, tahovejamɨoto mihicatɨmaño, amɨɨhaico eneehinɨcubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mɨɨro tahovejamɨ uco tahiimaatɨ gaajahi. Jaabadɨro bu diitoco uujoho gaajahi. Jaamaño tadyojɨcutɨ foonɨcɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jaamoco uujoho ifinɨjitɨno fiivoco acɨhi. Jaamo ufucuro guijevejitɨhi. Jaamoco mɨɨhaiñooba tahusefañotɨ dumɨtɨɨcɨjitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Guihirubi uco diitoco acɨubo famoohallɨnoocɨvɨro sihidɨ ejeevamaño. Jaamoco bu cajaatyooba Guihirubi usefañotɨ dumɨtɨɨcɨjitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jaamɨsi uujoho, Guihirubi icano mihicahi. Jaarumɨsi saafiiro mihicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jaanegui judiomɨ siino guiisibanoco ɨcɨuhi diiboco ihaamɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jaanegui Jesu diitoco nuuhi: Mɨɨro sihidɨ iminehejeque amɨɨhai ɨmefeenevɨ eetavehicahi Guihirubi mityari. Jaamo, ¿conohallɨtɨ uco magaicaaujirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jaanegui judiomɨ diiboco iimusuuhi: Imino omoonɨhicanohallɨtɨ ɨco momoonɨgotɨhi; Moocaaniditɨ imitɨno diimaahi miyamɨnaafi idiicaabo: Uujoho Moocaanibadɨ jeevahi, onoonohallɨtɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jaanegui Jesu diitoco nuuhi: Caatɨnɨhaamefaño Moocaani jillɨ neehi: Amɨɨhai Moocaanibadɨ mejeevamo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mɨɨro jaanoco famooro amɨɨhai magaajahi, Caatɨnɨhaamefaño onoono gañɨɨcafototɨno iicafinoco. Jaamaño mɨɨro Moocaani iijɨco agaayɨcɨumoco Moocaani nuuhi: Amɨɨhai Moocaanibadɨ mejeevamo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jaabadɨ Moocaani ijeevadɨ ɨɨcɨuboro agalluubeditɨ: ¿Mɨllɨ Moocaaniditɨ imitɨno iimaabo, meneejirahi, Moocaani Seemene uujoho, onoonoditɨ? ");
INSERT INTO bmrNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jaabo Moocaani omoonɨnoco uujoho omoonɨtɨhachiijɨ uco mimiyaaveguedino. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jaanotɨ omoonɨhachiijɨ uco mimiyaavogotɨrumo toonoco mimiyaavogo. Jaanoco magaajamoro mimiyaavogo mɨsi Moocaanima saafiiro mihicanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jaanoma iicaumo diiboco siino gaayɨcɨujirumo. Jaarunofaño diito usefañotɨ Jesu taajauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jaaboro siino fuubo Jordan oonegueehivɨ itɨconɨ Jua tomañovɨ initɨhicauhɨgo. Jaaboro tahɨ icahicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jaabojaa sihidɨ miyamɨnaa asaamoro, neerumo toonoco mimiyaavogo. Jaanoco magaajamoro mimiyaavogo mɨsi Moocaanima saafihicauhi: Miyaano Jua sihidɨ ejeevanoco moonɨhicautɨhi. Jaanotɨ diibeditɨ Jua eneehicaubadɨ paryɨ aivo miyaano, noomoro ");
INSERT INTO bmrNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","sihidɨ saatoho tomañoto Jesuco miyaavuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jaanaa saafi Betania cuumioobo guihuvauhi, Lazaro onoobo. Jaacuumiri icahicaumɨfe Maria, bu inago Marta icamɨfe. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jaanaaca diigo Maria nahabo Lazaro onoobo guihuvauhi. Jaago diigo Maria Aivojɨɨbo Jesuco facɨcɨfaihuri ejeesuugoro itɨhaiñoco imeebaiguiri ifilluhicaugo. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jaamɨfe Jesujaago jɨɨbogoco galluuhi: Aivojɨɨbo, ɨɨjoho agaijɨhicaabo guihuvahi, noomɨfere. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jaanoco Jesu uguubuuboro nuuhi: Toono guihuva guijeve icatɨno; jillɨ Moocaani mitya toonofeenedɨ ihɨfusucafetequi iicano, bu uujoho Moocaani Seemene toonofeenedɨ imityaco igaajasuqui icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jaabo Jesu Lazaromɨco gaijɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jaano Lazaro iguihuvaunoco Jesu guubucuuruubo, mifucucɨ siino tomañovɨro icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jaanobuunatɨ ijɨɨbogomɨnaaco nuubo: Masɨɨgo siino Judea jiinɨjejaagovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jaanegui diiboco diito nuuhi: Jɨɨbogomɨnaafi, tahɨgo du ɨco judiomɨ gaicaauhinɨrahi. ¿Jahɨgo bu siino feeji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jaanegui diitoco Jesu nuuhi: ¿Nacu safucu, nɨhɨba oovo fahuseecɨ motɨhaitɨ minoocɨ icano icatɨhi? Cuuje mɨhɨgomo mananigaivatatɨhi nɨhɨba foovono aachɨcɨnɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jaanotɨ fucu ɨɨgoobo nanigaivafihi, fucu eseseetɨmaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jaanobuunatɨ diitoco nuubo: Mogataavomɨnaafi Lazaro ɨcɨgaabo aaicotɨhiica. Jaanegui feeji aicusutequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jaanegui ijɨɨbogomɨnaa diiboco nuuhi: Aivojɨɨbo, ɨcɨgahicadɨ bu jei aiquejiibo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tollɨ Jesu diitoco nuuhi: Lazaro guijevecuuhi unuujirunoco tollɨ nuubo. Jaanoco diito esɨcɨnɨuhi: Miya cɨgacoro fɨne noobo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jaadɨ jari Jesu diitoco foovono nuuhi: Lazaro guijevecuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jaano amɨɨhaidi aivo imino uujoho tahɨ iicatɨno. Jaaneguiiha masɨɨgo diibojaago. Jaamo amɨɨhai mimiyaaveguehi. Jaaneri uujoho imo imo icahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jaanegui Tomas onooboco, gaatyaba eneehicaubo, inahabomɨ Jesu jɨɨbogomɨnaaco nuuhi: Masɨɨgo, tollɨro bu mɨɨhai Jesuma miguijevequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jaanaa Jesu gaseuhi Lazaroco ɨcɨɨuno mifucucɨ, mifucucɨ icanobuunatɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jaano Betania cuumi icauhi Jerusaletɨ minoocɨ, siinotɨfeenedɨ icano kilometronohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jahɨgo sihidɨ judiomɨ Martamɨfejaago fuuhi inahabo iguijeveunotɨ diitɨfeque ijacusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jaanaa Marta Jesu asaaunoco uguubuugoro fuuhi diiboco acabacutuugo. Jaanotɨ Maria jaahere fitafutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jaagoro Marta diiboco nuuhi: Aivojɨɨbo, jineeri diicahinɨruva tagaifiibo guijevehinɨjitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jaarugo uujoho gaajahi Moocaanico paryɨ idillunoco ɨco aacɨjinoco, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jaanegui Jesu diigoco nuuhi: Dinahabo siino buheeteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Jaanegui Marta nuuhi: Jɨɨhɨ, uuro gaajahi ufucu siino buheetefucuvɨ siino ubuheetejinoco, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jaanegui Jesu diigoco nuuhi: Uujoho buheetesuubo, uujoho fiivoobo; uco imiyaavogomo chuumucuurumo buheeji. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jino paryɨ iicamo uco imiyaavogomo, ifinɨjitɨno guijevefaño icajitɨhi, nooboro diigoco nuubo: ¿Naa miyaaveguehi jinooco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jaanegui nuugo: Jɨɨhɨ, Aivojɨɨbo, uujoho miyaaveguehi ɨɨjoho Cristo Moocaani Achi jiinɨjehallɨvɨ asaaguubo idiicanoco, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jillɨ unuugoro Marta fuuhi Maria inagoco toovono unuutuugo: Jɨɨbogomɨnaafi gasecuuhi. Jaabo ɨco coovahi, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jaanoco Maria uguubuugoro goovano agañiivuugoro Jesujaago fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jaanaa Jesu tuucuumifañehi ɨɨfutuutɨhiica Marta diiboco aatyɨmeumañovɨro fitafutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jaanoco judiomɨ diitɨfeque ijacusuqui asaaumo iijafaño iicaumo atyɨmeuhi Maria goovano agañiivuugoro ufuunoco. Jaamoro nuumo: Icɨɨhojɨjaago foogo tahɨ itaatequi, noomoro idojɨcutɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jaanaa Maria Jesuvɨ ɨɨfutuugoro diiboguiino ememuɨɨvuugoro diiboco nuuhi: Aivojɨɨbo, jineeri diicahinɨruva tagaifiibo guijevejitɨrahi, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jaanoco Jesu diigo taagoro asaaunoco, bu tollɨro judiomɨ diigoco anahabonɨumo taamoro asaaunoco icano aatyɨmeuboro sihidɨ ɨdaasuvuubo. Jaaneri diiboco ijeebɨɨ nɨjɨ nɨjɨ isinafutuuneguiiha, ");
INSERT INTO bmrNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","diitoco dilluubo: ¿Conoovɨ mɨcɨɨhinɨhi? nooboro. Jaanegui nuumo: Aivojɨɨbo, saabo juuga meecɨva, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jaaneri Jesu taauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jaanoco aatyɨmeumoro judiomɨ nuuhi: Memeecɨ sihidɨ fɨne diiboco gaijɨhicaubo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Jaanotɨ saatoho nuuhi: ¿Jaanɨ aatyɨmeutɨɨboco atyɨmesuubo, jineeri iicahinɨruva Lazaroco iguijevetɨ fɨne buheesuhinɨjitɨruubo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jaanaa Jesu siino aivo ɨɨdaasuvuuboro icɨɨhojɨ ɨmegavɨ fiitɨvuuhi. Jahojɨ ifaagajɨguiinojaagovɨ eseediumoro guiisibari ihɨmegaco afabaacɨhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jaaboro Jesu nuuhi: Iguiisibaco buhɨgovɨ magañɨɨ, nooboro. Jaarunaa Marta diiboɨvɨ nago nuuhi: Aivojɨɨbo, aivo fɨne usucuuno mifucucɨ, mifucucɨ icano icacuuno, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jaanegui Jesu diigoco nuuhi: ¿Nacu ɨco nootɨhi: Imiyaavogohachiijɨ Moocaani mityaco daatyɨmeji ɨco duhu neehi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jaanegui icɨɨhojɨ ɨmegatɨ iguiisibaco gañɨɨumo. Jaadɨ Jesu niquejeque emeecɨuboro nuuhi: Guihi, ɨco graciaco acɨhi uco uguubuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jaarunofaño gaajacuuhi fahiijɨvaro uco uguubuhicanoco. Jaarunofaño jito miyamɨnaa iicamedi neehi; uco ɨɨjoho agalluuhinɨnoco imiyaaveguequi, nooboro sefano nuubo: ");
INSERT INTO bmrNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","¡Lazaro, isivɨ dihiino! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jaasumiro ichuumuhu iinuuhi, itɨhaiño, ihusene icano minɨcɨnɨɨbo. Tollɨro bu ihɨme ijeevadɨobaryuri minɨcɨnɨɨbo. Jaadɨ Jesu diitoco nuuhi: Diiboco misinaayu ifeequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jaanoco judiomɨ Mariamɨfema asaaumo aatyɨmeumoro diiboco sihidɨ miyaavuguumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Jaarunaa sanoodɨmo fariseomɨjaago ufuumoro diitoco jɨɨbuguumo Jesu omoonɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jaanegui fariseomɨ, sacerdotemɨ aivojɨto icamo fagomɨnaaco iigaiyɨɨcɨumoro nuuhi: ¿Mɨllɨ fɨne momoonɨjirahi? Aivo sihidɨ ejeevanoonoco moonɨhicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mɨɨro diiboco mɨllɨ momoonɨtɨhachiijɨ famooro diiboco miyaavegueji. Jaachiijɨ romanomɨ asaamoro Moocaani iijaco finɨsuvajimo, bu tollɨro moojiinɨje miyamɨnaaco finɨsujimo icano, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Jaanegui Caifas diitoobo tusumi sacerdotemɨ aivojɨɨbotɨ iicaubo diitoco nuuhi: Amɨɨhai aivo magaajatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Nacu mehesɨcɨnɨtɨhi saafiiro famoohallɨvɨro iguijevejirunoco faacuumimɨnaaro mifinɨjirumohallɨvɨ? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ijeebɨɨtɨro tollɨ nuutɨɨbo; tusumi sacerdotemɨ aivojɨɨbotɨ iicaumaño Moocaani diibo jeebɨɨfaño eesaayunoco nuubo. Jesu tuucuumimɨnaahallɨvɨ iguijeveujinoco ɨmegavɨro jɨɨbuguubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jillɨ tuucuumimɨnaahallɨvɨro icautɨno, tollɨro bu Moocaani seeme fahɨgova iicamoco iigaiyɨɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jaamaño tusumitɨro esafutuumo Jesuco iguijenɨujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jillɨtɨ Jesu foovono ɨgucuutɨhi judiomɨfeenedɨ jillɨro toonotɨ fuucuubo sɨcaihɨgovɨ toonotɨ fiitɨno iicaucuumi Efrain onoocuumijaagovɨ. Jahɨ ijɨɨbogomɨnaama fitafutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jaanaa fiitɨcuuno Pascua judiomɨ jɨɨbaimo iicaujino. Jaacuumitɨ sihidɨ saatoho Jerusalevɨ fuuhi ɨmegavɨro ijeevamaje iicanɨcɨbadɨ ifiinoco iimibachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jaanaa Jesuco guiinehicaumo. Jaamoro templojafaño icamo noocasihicauhi: ¿Mɨllɨ mehesɨcɨnɨhi, fɨne saajiibo? ¿Nacu fɨne jino jɨɨbaimovɨ saajitɨɨbo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jaanaa fariseomɨ, sacerdotemɨ aivojɨto icamo miyamɨnaaco tajɨɨbauhi. Saatohotɨ Jesuco mahatyɨmehachiijɨ mɨɨhaico mɨjɨɨbogo, magaayɨcɨmoro diiboco mɨcɨvojaanɨcɨqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jaanaaca Pascua jɨɨbaimoco eheetavuujino sahuse juugahusetɨ safucu icano icaunaaca Jesu fuuhi Betaniavɨ tuucuumivɨ Lazaro iguijeveuboco ubuheesuubo iicauhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jahɨ diibedi eetavuumo machutaaco. Jaanoco Marta ɨfehicauhi. Jaanotɨ Lazaro amachumofeeneri icahicauhi Jesuma. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jaanaaca Maria sɨvauhi sano libra tɨcovovɨ nardo onoono facɨcɨfaihuco aivo iimino guiraano ijaada iicanoco. Jaagoro tofaihuri Jesu tɨhaiñoco ejeesuugoro imeebaiguiri filluhicauhi. Jaaneri tooja gahafuuhi ifacɨcɨfaihu usuri. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jaanegui ijɨɨbogomɨnaatɨ saafi nuuhi Juda Iscariote Simon achi Jesuco aacɨujiibo: ");
INSERT INTO bmrNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Collɨhi jana jino facɨcɨfaihuco trescientos denariori anaajemere ɨɨdaasufiimoco acɨtɨmo bañamaaihi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jillɨ nuubo ɨɨdaasufiimoco agaijɨumaño icatɨno. Jillɨ nanivamɨnaafi iicaumaño. Jaaboco diito inɨhɨbamɨ lleegucuco utuumusuunotɨ nanihicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jaanegui Jesu diiboco nuuhi: Jaafa tollɨ moonɨgo, tacɨɨhojɨ ɨmegavɨ uco jillɨ moonɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mɨɨro amɨɨhaifeenevɨ fahiijɨvaro ɨɨdaasufiimo icaji. Jaanotɨ uujoho amɨɨhaima fahiijɨvaro icajitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jaanaa ajashutɨmo judiomɨ guubuuhi Jesu Betaniari iicaunoco. Jaamoro tahɨ fuumo. Jaaruno Jesuguiiharo icatɨno, tollɨro bu Lazaroco Jesu ubuheetesuuboco ihatyɨmequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jaamoro sacerdotemɨ aivojɨto Lazarohallɨvɨ iimaacasiuhi, tollɨro bu diiboco igaicaauqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Diibotɨ sihidɨ saatoho judiomɨ Jesuco imiyaavuguumoro udugaacamaaiunoma iicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jaanaa sihidɨ miyamɨnaa Pascua jɨɨbaimovɨ Jerusalevɨ fuuhi. Jaamo, jaano seseevedɨ guubuumo Jesu tuucuumivɨ agaseujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jaamoro ɨmohono jaaɨnoco iquitɨumoro diiboco cabaacutuumo sahagomoro: ¡Hosana! ¡Jaafa imocafotoobo! Imicani Moocaani memeri asaabo; Israel miyamɨnaa aivojɨɨbo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jaanaa Jesu burroco aatyɨmeuboro diibohallɨvɨ casɨɨvuubo. Caatɨnɨhaamefaño onoobadɨ: ");
INSERT INTO bmrNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Diiguetejirahana Sion cuumi; Meecɨ oono dihaivojɨɨbo burrogayɨhallɨri gɨcɨnɨɨboro saahi, noonoro onoobadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jaarunoco ijɨɨbogomɨnaa gaajautɨhi; jari Jesu niquejefaño ufuunobuunatɨ gaajacɨumo Caatɨnɨhaamefaño onoocɨnɨubadɨ omoonɨunotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jaanaa Jesu Lazaroco ubuheetesunoco atyɨmeumo jɨɨbeguehicauhi Jesu omoonɨuboro ubuheetesunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jaanoma icamo miyamɨnaa Jesu asaauboco cabaacutuuhi sihidɨ ejeevano mityaco omoonɨunoco uguubuumoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jaanoma iicamo fariseomɨ noocasiuhi: Mahatyɨmecuhi fɨne jino mɨɨhairyo mɨllɨba momoonɨtɨnoco. Memeecɨ paryɨ miyamɨnaa diibo dojɨcutɨ ofoonoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jaanaaca Jerusalevɨ Pascua jɨɨbaimovɨ Moocaanico iimequi ufuumofeeneri, bu icaumo saatoho griegomɨoto. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jaamo Felipejaago asaaumoro diiboco nuuhi: Aivojɨɨbo, mɨɨhai mihimeguehi Jesuco mahatyɨmeneque, noomoro. Jaabo Felipeu Betsaida cuumioobo Galilea jiinɨjeri iicaucuumioobo. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jaanegui Felipe ufuuboro Andreque jɨɨbugutuuhi. Jaadɨ famɨsicɨro ufuumɨsiro Jesuco jɨɨbugutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jaanegui Jesu nuuhi: Tufucu mihicacuuhi, uujoho Miyamɨnaafibadɨ Ifiivuubo sihidɨ jeevanofaño iicajifucu. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Miyanotɨro, miyanotɨro amɨɨhaico neehi: Trigo noovatayɨ jiinɨjehallɨvɨ aacotoyɨro jiinɨjefaño ofooyɨ chuumucuyɨbadɨ icahi. Jaaruyɨ ihiinoyɨro janaanɨcɨ guiraano noovafihi. Jaanotɨ abasuratɨyɨ sayɨɨro icafihi. ¿Mɨllɨ bu guiraatejiruyɨ? ");
INSERT INTO bmrNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jaabadɨ ifiico agaijɨɨbo ifiico mɨtasuji. Jaanotɨ jiijehallɨvɨ ifiico agaijɨtɨɨbo ifinɨjitɨno fiivoguiiha ficuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Cajaatyohacho tadyojɨcutɨ asaagomo uco ijeecɨvequi. Jaamo uco ejeecɨvomo uujoho icahɨgo tollɨro icajimo, bu jaamo cajaatyohacho uco ejeecɨvomoco Guihirubi bocɨgusuji. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisumi uco tajeebɨɨ gaihuɨba icahi. ¿Jaanoco mɨllɨ fɨne uujoho neeji? ¿Fɨne Guihi uco jillɨ iicajinotɨ taajasu, neeji? Etɨ du, tooneguiiha uujoho saahinɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jaanegui Guihi dimomoco cahacɨsu, nuubo. Jaasumiro niquejefañotɨ guubuvusuuno: Cahacɨsucuuhi, bu siino cahacɨsujihica, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jaanaa iicojɨri miyamɨnaa iicaumo niquejefañotɨ unuunoco uguubuumoro: Sisi iimaahi, neehicauhi. Jaanotɨ saatoho: Moocaani toomomɨnaafi iimaahi, neehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jaanegui Jesu nuuhi: Uuguiiha jino niquejefañotɨ Moocaani iimaatɨhi, amɨɨhaiguiiha ihiimaano. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jisumi jino jiinɨjehallɨvɨ imitɨ jaadaco acɨcafeteji, bu jisumi jino Ɨjɨ jiije aivojɨɨbo icahicaabo buhɨ gañɨɨcafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jaabo uujoho guijeve ɨmohobujehallɨvɨ jiinɨjehallɨtɨ agañiivoodɨ, paryɨ famoocoro tajaagovɨ sɨvaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jillɨ neehicaubo coguijeveri fɨne iguijevejinoco diitoco agaajasuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jaanegui imiyamɨnaa iimusuuhi: Mɨɨro mɨɨhai muguubuhicahi tajɨɨbahaamefaño: Cristo asaadɨ guijevetɨɨbo icaji, onoonoco. Jaano icanaaca, ¿mɨllɨ jaabo ɨɨjoho neehicahi: Miyamɨnaafibadɨ Ifiivuubo guijeve ɨmohobujehallɨvɨ gañiiyɨcɨsucafeteji, neehicahi? ¿Nacu, mɨɨjoho diibo Miyamɨnaafibadɨ Ifiivuubo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jaanegui Jesu diitoco nuuhi: Amɨɨhai feenerihiica gueenejɨsuno icajino seseene aachɨcɨnɨno. Jaanegui mɨhɨgo amɨɨhaifeeneri jino seseene aachɨcɨnɨno iicanohachuta, amɨɨhaihallɨvɨ cɨvono iijɨtɨnaacaro. Jaanotɨ cɨvohɨ ɨɨgomo gaajatɨhi ihɨmega ofoohɨgoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jaanegui amɨɨhaifeeneri sesee iicanohachuta seseeque mimiyaavogo. Jaamo seseene aachɨcɨnɨno miyamɨnaa mihicahi, nooboro. Jillɨ Jesu ihiimaahicaudɨ ufuuboro diiteditɨ fataniivutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Diitofeenevɨ Jesu ajashutɨno sihidɨ ejeevanehejeque eetavehicacuurunaaca diiboco miyaaveguehicautɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Moocaani iimaamɨnaafi Isaia unuuno imiyaavequi iicaumaño. Mɨɨro noono: Aivojɨɨbo, ¿mɨɨjoho nacu mojɨɨbogoco miyaaveguehi? ¿Mɨɨco fɨne Moocaani imityaco ɨfusuhi? noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jillɨtɨ miyaaveguehicautɨmo. Jaaboro bu Isaia caatɨnɨuhi: ");
INSERT INTO bmrNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diito aallɨɨnoco Moocaani jabaiyɨɨtusuuhi; tollɨro ijeebɨɨnoco cuhufutusuubo ihaallɨɨneri atyɨmetɨmo iicaqui, tollɨro bu ijeebɨɨri esɨcɨnɨtɨmo iicaqui. Jaamoro tajaa asaamoco uujoho buheesudino. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jillɨ nooboro Isaia Jesuditɨ iimaauhi Jesu aivojɨco aatyɨmeuboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jaarunofaño sanoodɨmo ihaivojɨto Jesuco miyaavuguuhi. Jaarumo foovono neehicautɨhi fariseomɨ ñɨhicutɨ diitoco sinagogajatɨ gañɨɨtɨmo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Miyamɨnaa diitoco obocɨgomocoro imuguumo Moocaani obocɨgonoco imogotɨmo iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jaanaa Jesu sefano nuuhi: Uco imiyaavogomo, ucoro miyaavogotɨhi tollɨro uco agalluuboco miyaaveguehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tollɨro bu uco atyɨmeme uco agalluuboco atyɨmehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Uujoho seseene aachɨcɨnɨɨbo jiinɨjehallɨvɨ saahinɨhi uco imiyaavogomo cɨvohɨ icatɨmo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jaanotɨ taajɨco guubucuurumo imiyaavogotɨmoco uujoho: Diito imitɨco, neejitɨhi. Uujoho jiinɨjehallɨvɨ saahinɨtɨhi jiinɨje miyamɨnaaco cɨɨjɨgaifaño gañɨɨsuqui, jillɨ taajasuqui saahinɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jaanotɨ uco iimogotɨmoro taajɨco imiyaavogotɨmoco uujoho eneehicano, diitoco ufucu niinofucu cɨɨjɨgaifaño gañɨɨsuji. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Uujoho tajeebɨɨtɨro iimaahicatɨhi Guihirubi uco agalluhinɨɨbo atajɨɨbahinɨbadɨ iimaahicahi, jɨɨbeguehicahi icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jaabo uujoho gaajahi Guihirubi tajɨɨba ifinɨjitɨno fiivoco aacɨno. Jaamaño uujoho iimaahicahi Guihirubi unuubadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jaanaa safucurucu icauno ihɨmega Pascua jɨɨbaimo iicaujino. Jaanaa Jesu gaajacuuhi, jiijehallɨtɨ Caanijaagovɨ ufuujino oovovɨ ɨɨfutucuunoco. Jaabo ita jiinɨjehallɨri iicamoco gaijɨhicaubo. Jaaboro ɨɨfusuubo diitoco sihidɨ agaijɨno finɨtɨno iicajinoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jaamo niinoono amachuumo icaunaaca ɨjɨ Juda Iscariote Simon achi eesamaajefaño jɨɨhacucuuhi Jesuco aacɨujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jaanaa Jesu Caani diiboco fanoovaco ihusefaño aacɨunoco agaajauboro, bu tollɨro Moocaanitɨ asaaunoco, bu siino diibojaago ufuujinoco icano agaajauboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Amachuumañotɨ agañiivuuboro igaachehuco jujuuvuubo. Jaaboro ifillubaryuri ifeeneebeque isiyaavuuboro ");
INSERT INTO bmrNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","nɨfaihuco butajefaño ificuuboro ijɨɨbogomɨnaa tɨhaiñoco nitɨhicaubo. Jaaboro ifillubaryuri isiyɨcɨnɨuneri filluhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jaanaa Simon Pedrovɨ ɨɨfutuubo. Jaanegui Pedro diiboco nuuhi: Aivojɨɨbo, ¿mɨllɨ jaabo ɨɨjoho uco tatyɨhaiñoco nitɨji? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jaanegui Jesu diiboco nuuhi: Jino uujoho omoonɨnoco jisumihiica ɨɨjoho gaajatɨhi. Jaaruubehi ufucu gaajaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jaarunaa Pedro diiboco nuuhi: Chahano, ufucuro tatyɨhaiñoco ɨɨjoho uco nitɨjitɨhi, nooboro. Jaanegui Jesu diiboco nuuhi: Ɨco initɨtɨhachiijɨ tajaagodɨ diicajitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jaanegui Simon Pedro nuuhi: Aivojɨɨbo, tatyɨhaiñocorota nitɨdino, tollɨrota bu tahusene, tañigaɨ icanoco nitɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jaanegui diiboco Jesu nuuhi: Ejeecuubo siino faabohoro jetatɨhi itɨhaiñocoro nitɨfihi ɨmɨhɨnivatɨmaño. Jaabadɨ amɨɨhai mɨmɨhɨnivatɨhi. Jaarumo famooro icatɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tollɨ nuubo diiboco aacɨujiiboco agaajaumaño, famooro mɨmɨhɨnivatɨhi, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jaadɨ diito tɨhaiñoco Jesu initɨhicaudɨ siino igaachehuco ɨjɨcafutuuboro casɨɨvuubo. Jaaboro diitoco nuubo: ¿Magaajahi jino uujoho amɨɨhaico omoonɨnoco? ");
INSERT INTO bmrNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mɨɨro amɨɨhai uco meneehicahi jɨɨbogomɨnaafi, aivojɨɨbo icano. Etɨ, miyaanoco meneehicahi, uujoho diibo iicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jaaruubo amɨɨhai tɨhaiñoco initɨbadɨ, bu amɨɨhai sanoomɨro amɨɨhai tɨhaiñoco fahɨgovavɨ minitɨcasihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mɨɨro amɨɨhaico jɨɨbeguehicacuuhi. Jaamo uujoho omoonɨhicabadɨ momoonɨhicahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Miyanotɨro, miyanotɨro amɨɨhaico neehi: Chahaabo saafi jeecɨvomɨnaafi ihaivojɨɨbo janaanɨcɨvɨ iicaabo. Tollɨro bu chahaabo siinojaa agalluubo diiboco agalluubo janaanɨcɨ iicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jinoco magaajamoro jillɨ momoonɨhachiijɨ miyanotɨro imino mihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Fameeditɨro amɨɨhaiditɨ iimaatɨhi. Uuro gaajahi amɨɨhaico uujoho ɨɨcɨhinɨmoco. Jaarunofaño, jaafa tollɨ icano, Caatɨnɨhaamefaño onoono imiyaavequi. Uuma sano amachuhicaruubo: Tamɨnaafitɨ minifetehi, onoono. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jaanegui amɨɨhaico ɨmegavɨro jino neehi. Jaamo tollɨ iicacuudɨ magaajamoro mimiyaaveguehi uujoho diiboro iicaabo, iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Miyanotɨro, miyanotɨro amɨɨhaico neehi: Uujoho agalluuboco agaayɨcɨmo, uco bu tollɨro gaayɨcɨhi. Jaamo uco agaayɨcɨmo, tollɨro bu uco agalluuhinɨɨboco gaayɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jillɨ Jesu unuuboro gaajacɨuhi ifi ijeebɨɨfaño gaihuɨba iicaunoco. Jaaboro foovono nuubo: Miyanotɨro, miyanotɨro amɨɨhaico neehi: Amɨɨhaitɨ saafi uco acɨji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jaanegui ijɨɨbogomɨnaa fahɨgova meecɨcasiuhi: ¿Cajaanɨtɨ fɨne noobo? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jaanaa saafiico ijɨɨbogomɨnaatɨ Jesu agaijɨhicaubo diibovɨ fitocɨnɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jaaboco Simon Pedro ihaallɨɨri tajɨɨbauhi Jesuco idilluqui cajaanɨditɨ Jesu tollɨ unuunoco igaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jaanegui diibo Jesuvɨ fañogayɨ ifiitɨvuuboro diiboco dilluubo: ¿Aivojɨɨbo, cajaanɨ diibo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jaanegui nuubo: Toovotɨno uujoho diiboco maahuco amatyusuuboro acɨji, nooboro imaahuco amatyusuuboro acɨubo Juda Iscariote Simon achico. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jaanoco Juda amachuusumiro Satanas ɨjɨ diibo jeebɨɨfaño jɨcafutuuhi. Jaanegui Jesu diiboco nuuhi: Omoonɨjinoco jisumiro moonɨcu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jaarunoco diito amachuumo gaajacɨutɨhi mɨllɨtɨ diibo tollɨ unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jaanotɨ saatoho esamaaihicauhi. Juda inɨhɨbamɨ lleegucuma iicaunegui diiboco baacho, noobo: Naajecu jisumiro jɨɨbaimovɨ mucuujɨvaachujirunoco. Jaanotɨ ɨɨdaasufiimoco siinotɨ ihacɨqui noobo baacho, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jaabo Juda amachuuboro tahɨgotɨ iinuuruubaaca mihiijɨcuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jaabo Juda ufuunobuunatɨ Jesu nuuhi: Jisumi jari uujoho Miyamɨnaafibadɨ Ifiivuubo cahacɨsucafeteji. Jaabofeenedɨ Moocaani bocɨ cahacɨsucafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jaabo uujoho Miyamɨnaafibadɨ Ifiivuubo Moocaani bocɨco ɨɨfusumaño Moocaani, bu ɨfusuji Illi bocɨco. Jaanoco jisumiro ɨɨfusucuujiibo. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Taseeme amɨɨhaima uujoho gueenene icacuujitɨhi: Uco miguiinejirahi. Judiomɨco eneehinɨbadɨ. Tollɨro bu amɨɨhaico neehi: Uujoho ofoohɨgo amɨɨhai mefeejitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jaanegui amɨɨhaico bohono tajɨɨbaco uujoho acɨhi. Fahɨgova magaijɨcasi. Amɨɨhaico uujoho agaijɨbadɨ fahɨgova magaijɨcasi. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jaamo fahɨgova magaijɨcasihachiijɨ miyamɨnaa gaajaji miyaano amɨɨhai tajɨɨbogomɨnaa mihicanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jaanegui Simon Pedro diiboco nuuhi: ¿Aivojɨɨbo, cuuca feeji? nooboro. Jaanegui Jesu diiboco iimusuuhi: Uujoho jisu ofoobo dojɨcutɨ ɨɨjoho feejitɨhi, ufucu jari tadyojɨcutɨ feeji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Jaanegui diiboco Pedro nuuhi: ¿Aivojɨɨbo, mɨllɨtɨ jaabo jisumi didojɨcutɨ feejitɨrahi? Dihallɨvɨ uujoho tafiico aacɨnoco imeguehi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jaanegui Jesu diiboco nuuhi: ¿Nacu difiico ɨɨjoho tahallɨvɨ daacɨjirahi? Miyanotɨro ɨco neehi: Jaafañiino catava ojɨtɨnaacaro, uco agaajaruubo uco ɨɨjoho tuunamaaiji mifoocɨ, safo ɨdɨɨno, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Amɨɨhai jeebɨɨfañodɨ mihiguetedino. Moocaanicoro mimiyaavogo, bu tollɨro uco mimiyaavogo. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Guihirubi iijafaño mihicajimañeheje sihidɨ icahi; tollɨ iicatɨruva amɨɨhaico uujoho neejitɨrahi. Jaanegui feehi amɨɨhai ɨmega amɨɨhai mihicajimañehejeque imibachuqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jaabo jino ofoobo amɨɨhai mihicajimañehejeque iimibachuudɨ siino saaji; amɨɨhaico ɨɨcɨvaabo. Jaamo uujoho iicahɨgo amɨɨhai tollɨro mihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Amɨɨhairyo magaajacuuhi uujoho ofoohɨgoco, tollɨro bu tahɨ ofoono jɨɨhaico magaajahi icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jaanegui diiboco Tomas nuuhi: Aivojɨɨbo, magaajatɨhi ɨɨjoho efeejihɨgoco; ¿Mɨllɨ fɨne magaajajirahi toono jɨɨhaico? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jaanegui Jesu nuuhi: Uujoho toono Jɨɨhai, bu uujoho Miyaano, bu uujoho Fiivo icano. Ɨdɨɨnoro tafeenedɨ Moocaanivɨ mɨhɨfetejirahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Uco magaajahachiijɨ bu tollɨro Guihirubico magaajahi. Jaaboco jisumitɨro magaajacuuhi mahatyɨmecumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jaanegui Felipe diiboco nuuhi: Aivojɨɨbo, mɨɨhaicota dɨhɨfusu: Moocaanico maatyɨmemere siino dillucuutɨmo mihicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jaanegui Jesu diiboco nuuhi: Sɨɨcɨjetɨro amɨɨhaima icahicacuuhi. ¿Jaaruuboco nacu ɨɨjoho Felipe uco gaajatɨhiica? Mɨɨro uco aatyɨmeme bu Guihirubico atyɨmehi. ¿Mɨllɨ jaabo uco: Moocaanico dɨhɨfusu, neehi? ");
INSERT INTO bmrNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Nacu mimiyaavogotɨhi uujoho Guihirubifaño iicanoco, bu Guihirubi tafaño iicanoco icano? Mɨɨro amɨɨhaico uujoho eneehicano, jillɨ tajeebɨɨtɨro eneehicano icatɨno. Guihirubi tafaño iicaabo dudɨcamaajeque moonɨhicahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uco mimiyaavogo, uujoho Guihirubifaño, diibo tafaño icano iicanoco. Jaabadɨro bu siibadɨ omoonɨhicanotɨ uco mimiyaavogo. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Miyanotɨro, miyanotɨro amɨɨhaico neehi: Uco imiyaavogoobo bu tollɨro moonɨji uujoho omoonɨhicanoco. Jaabo imi janaanɨcɨ moonɨjiibo uujoho jimaño icacutɨɨbo Guihirubijaago efeejimaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Jaamo amɨɨhai paryɨ tamemeri Moocaanico midillunoco uujoho acɨji uujoho Illifañodɨ Moocaani sihidɨ ejeevanoco miyamɨnaa igaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jaamo siinoco tamemeri midillunoco uujoho acɨji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Uco magaijɨhachiijɨ tatyajɨɨbaco imino momoonɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jaadɨ uujoho Guihirubico dilluji amɨɨhaijaago Igaija, miya Gaija iicaaboco igalluuqui, amɨɨhaico ijacusuqui. Jaabo amɨɨhaima fahiijɨvaro icaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jaaruuboco jiinɨjemɨnaa gaayɨcɨjitɨrahi diiboco aatyɨmetɨmoro agaajatɨmaño. Jaanotɨ amɨɨhai diiboco magaajacuuhi amɨɨhaima diibo iicamaño. Jaabo amɨɨhaifaño fahiijɨvaro icajiibo. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Amɨɨhaico jeevesujitɨhi jɨjovonotɨ mihicaqui; siino saaji amɨɨhaijaago. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Fiitɨcuuno miyamɨnaa uco aatyɨmecuujitɨno: Jaanotɨ amɨɨhai uco mahatyɨmeji. Uujoho ubuheemaño, jaabadɨro bu amɨɨhai mihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jaasumi amɨɨhai magaajaji uujoho Guihirubifaño iicanoco. Jaabadɨro bu amɨɨhai tafaño mihicaji bu, uujoho amɨɨhaifaño icaji icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jaanotɨ tatyajɨɨbaco imiyaavogooboro imino omoonɨɨbo, uco agaijɨɨbo. Jaabo uco agaijɨɨboco Guihirubi gaijɨji, tollɨro bu uujoho gaijɨji icano, uujoho diitoma iicanoco igaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jaanegui saafi Juda onoobo, jaarunaa Juda Iscariote iicatɨɨbo nuuhi: ¿Aivojɨɨbo, mɨllɨ jaabo mɨɨhaicoro difiico agaajasuuboro jiinɨjemɨnaaco difiico gaajasujitɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jaanegui Jesu diiboco nuuhi: Uco agaijɨɨbo taajɨco moonɨhi. Jaaboco Guihirubi gaijɨhi. Jaabojaago masaamɨsiro diiboma sano mihicaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jaanotɨ uco agaijɨtɨɨbo, taajɨco moonɨtɨhi. Jaano jino uujoho amɨɨhaico ɨjɨɨbeguehicabogo tabogoro icatɨno Guihirubi uco agalluuhinɨɨbobogo. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Jaanoco jillɨ amɨɨhaico jɨɨbeguehicahi, jino amɨɨhaima iicanohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Jaarunaa tafañodɨ Moocaani Igaijaco agalluubo amɨɨhaico fanoovaco jɨɨbegueji, tollɨro paryɨ amɨɨhaico uujoho eneehicanoco esaayujiibo icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mɨɨro jino amɨɨhaico fitacuhi sajeebɨɨ mihicaqui. Tasajeebɨɨ ifiico amɨɨhaico acɨhi. Jaaruno jiinɨjemɨnaa isajeebɨɨco aacɨbadɨ uujoho acɨjitɨhi. Amɨɨhai jeebɨɨfañodɨ gaihuɨba mihicadino, bu mihiguidino icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Amɨɨhairyo magaajacuuhi amɨɨhaico eneehinɨnoco: Uujoho feeji. Jaaboro amɨɨhaijaago siino saaji, nooboro eneehinɨnoco. Miyaano uco magaijɨruva imo imo mihicajirahi Guihirubijaa ofoonoco magaajamoro. Mɨɨro Guihirubi tajanaanɨcɨvɨ sihidɨ jeevahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jaanoco amɨɨhaico ɨmegavɨro neehi, tollɨ iicacuudɨ jaamo mimiyaaveguehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gueenene amɨɨhaima iimaacuujitɨhi, jiije aivojɨɨbo ɨjɨ asaacumaño. Jaaruubo tahallɨvɨ mityama chahahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Uco Guihirubi atajɨɨbaubadɨ jino uujoho moonɨhi, jiinɨjemɨnaa igaajaqui uujoho Guihirubico agaijɨnoco, nooboro diitoco: Magañiivucu, jinootɨ mufuucuqui, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Uujoho imiyacoohai, añɨmɨnaa baacu coohaibadɨ iicaabo. Jaacoohai abajaabobadɨ iicaabo Guihirubi. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mɨɨro baacu coohai aafene iimitɨhaafejeque iquitɨmoro agavaracunɨcɨbadɨ, tollɨro uco gaayɨcɨcurumo imitɨno iicamoro taajɨco iguiraatusutɨmoco Guihirubi gavaracuji. Jaanotɨ iguiraatusumoco tooco aafene onoova aafejeque imibachunɨcɨbadɨ Guihirubi imibachuji janaanɨcɨ siino iguiraatusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jaanotɨ amɨɨhai mɨmɨhɨnivaficuutɨhi amɨɨhaico ɨjɨɨbeguehicacuunofañodɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jaanegui uuvɨro mihica uujoho amɨɨhaivɨ icaqui icano. Mɨɨro oono basuta aafe ifahootɨ ihiinocɨnɨtɨhaafe iinoro noovajitɨrahi. Jaabadɨro bu amɨɨhai mihicaji uutɨ mihicatɨhachiijɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mɨɨro uujoho ifacoohai. Jaanotɨ amɨɨhai ifahaafene; uuma iicaabo, bu uujoho diiboma iicaabo icano sihidɨ noovasuhi. Jaanotɨ uutɨ ijeevadɨ mihicahachiijɨ aivo mɨllɨba momoonɨjitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jaabo uutɨ icatɨɨbo buhɨ gañɨɨcafeteji iimitɨhaafeque iquitɨcɨmoro buhɨ agañɨɨnɨcɨbadɨ. Jaano ifiigatyonoco ananɨmoro cɨɨjɨgaifaño agañɨɨno nɨfetefihi. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jaanotɨ uutɨ mihicahachiijɨ taajɨ amɨɨhaima icaji. Jaachiijɨ paryɨ mihimogonoco midillu amɨɨhaico acɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mɨɨro amɨɨhai sihidɨ monoovasuhachiijɨ Moocaani cahacɨsucafeteji. Jaachiijɨ amɨɨhai miyaanoro tajɨɨbogomɨnaa mihicahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Guihirubi uco agaijɨbadɨro, bu amɨɨhaico uujoho gaijɨhi. Jaanegui amɨɨhaico agaijɨnofañoro mihica. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tatyajɨɨbaco imino momoonɨhachiijɨ amɨɨhaico agaijɨnofañoro mihicaji; Uujoho Guihirubi tajɨɨbaco imino omoonɨmaño diibo uco agaijɨnofaño iicabadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Jillɨ amɨɨhaico neehi, tahimohica amɨɨhaima iicaqui. Jaaneri jaamo imo imo mihicahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jaano jino amɨɨhaico uujoho atajɨɨbano: Fahɨgova magaijɨcasi, amɨɨhaico uujoho agaijɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Janaanɨcɨ aivo gaijɨma mihicano; mɨɨno gataavomɨnaafihallɨvɨ mofiico mahacɨno. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jaabadɨ amɨɨhai tañahabomɨ mihicaji, uujoho amɨɨhaico atajɨɨbanoco momoonɨhachiijɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Amɨɨhaico tajeecɨvomɨnaa nuucuujitɨhi, mɨɨro jeecɨvomɨnaafi gaajatatɨhi ihaivojɨɨbo omoonɨnoco. Jaaneguiiha jino amɨɨhaico tañahabomɨ neehi; paryɨ Guihirubitɨ agaajahinɨnoco amɨɨhaico agaajasumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Amɨɨhai uco mɨhɨcɨutɨhi. Jaanotɨ uujoho amɨɨhaico ɨcɨuhi. Jaaboro amɨɨhaico ficuuhi, toonoco mofoomoro sihidɨ miguiraatusuqui. Jaanoco suufenɨtɨmo mihica; Jaamo tamomofeenedɨ Moocaanico siinoco midillunoco amɨɨhaico ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jino amɨɨhaico atajɨɨbano: Fahɨgova magaijɨcasi. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jiinɨjemɨnaa amɨɨhaico ɨjɨɨhevehachiijɨ magaaja, amɨɨhai ɨmegaro uco ɨjɨɨheveneque. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Amɨɨhai jiinɨjemɨnaa mihicaruva amɨɨhaico jiinɨjemɨnaa gaijɨjirahi. Jaanotɨ uujoho jiinɨjemɨnaafeenetɨ amɨɨhaico ɨcɨuhi. Jaamaño jiinɨjemɨnaa amɨɨhaico jɨɨhevehi, jiinɨjemɨnaa mihicacuutɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mehesafoto amɨɨhaico eneehinɨnoco, mɨɨro jeecɨvomɨnaafi ihaivojɨɨbo janaanɨcɨvɨ jeevatatɨhi. Uco icaruno ɨjɨɨheveme, imi amɨɨhaico jɨɨheveji. Amɨɨhaico ɨjɨɨbeguehicanoco imino momoonɨhachiijɨ, tollɨro bu amɨɨhaiño ficucafeteji. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jillɨ tahallɨtɨ amɨɨhaico moonɨjimo, uco agalluuboco agaajatɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Uujoho saahinɨtɨruva, bu diitoco jɨɨbeguehicatɨruva icano iimitɨco gaajajitɨrumo. Jaanotɨ jisumi mɨllɨba eneejiruno chahacuhi iimitɨco agaajasucumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mɨɨro uco ɨjɨɨhegueme, bu tollɨro Guihirubico jɨɨheguehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Uujoho diitofeenevɨ mɨɨhaiñooba eheetavotɨnoco sihidɨ ejeevanoco eetavehicatɨruva iimitɨma chahajirumo. Jaanotɨ toono sihidɨ ejeevanoco atyɨmehicacuurumo uco jɨɨhevehi, bu Guihirubico jɨɨheveme icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jaaruno tɨcovono icatɨno jillɨ diito tajɨɨba aamefaño onoono imiyaavequi iicano: Sɨcamañohallɨtɨ uco jɨɨheveme, onoono. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jaarunaa Jacusumɨnaafico uujoho Guihirubifañodɨ agalluubo miyaano Gaija asaadɨ, diibo uutɨ iimaaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jaasumi tollɨro amɨɨhai uuditɨ mɨjɨɨbegueji, itɨconɨtɨro uuma mihicahicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jillɨ amɨɨhaico neehi jinejeba amɨɨhaico dugaacusutɨno iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Amɨɨhaico gañɨɨjimo sinagogajanofañotɨ. Tollɨro bu icajino cajaatyohacho amɨɨhaitɨ iguijenɨmo esamaaiji: Jillɨ omoonɨneri Moocaanidi fɨne imino moonɨhi, noomoro omoonɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jillɨ moonɨjimo Guihirubico agaajatɨmaño, uco agaajatɨmaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jaanoco jillɨ amɨɨhaico neehi. Jaamo tollɨ iicacuudɨ magaajahi uujoho toonoco amɨɨhaico eneehinɨcuunoco. Jillɨ itɨconɨ amɨɨhaico nuutɨhi, amɨɨhaima icaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jaaruubo jisumi fuucuji uco agalluubojaago. Jaaboco amɨɨhaitɨ saatohoba midillujitɨhi: ¿Cuuca feeji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jaarunaa itɨconɨ tollɨ amɨɨhaico unuuneri mɨhɨdaasuvuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jaarunaa miyaanoco amɨɨhaico neehi: Aivo amɨɨhaidi imino uujoho ofoono. Jaanotɨ footɨruva Jacusumɨnaafi amɨɨhaijaa saajitɨrahi. Jaanotɨ ofooboro amɨɨhaijaa galluuji. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jaadɨ diibo asaadɨ jiinɨjemɨnaaco gaajasujiibo imitɨmɨnaa iicanoco, bu tollɨro ɨtɨcovono jɨɨhai iicanoco, bu diitoco Moocaani udugaacujinoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jaabo: Diito imitɨmɨnaa iicanoco, neeji uco diito imiyaavogotɨmaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tollɨro bu gaajasujiibo ɨtɨcovono jɨɨhai iicanoco, uujoho Guihirubi iicahɨgo ofoomaño. Jaaboco amɨɨhai siino uco mahatyɨmecujitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tollɨro bu gaajasujiibo Moocaani udugaacujinoco, diibo jiije aivojɨɨbo iicaabo ɨjɨco cɨɨjɨgaifaño igañɨɨqui ificucuumaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Sihidɨ amɨɨhaico eneejiruno icarahi. Jaarunoco jisumi amɨɨhai magaajajitɨrahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jaanotɨ miyaano Gaija asaadɨ amɨɨhaico miyanotɨro jɨɨbeguejiibo. Jaaruno ijeebɨɨtɨro jɨɨbeguejitɨɨbo Moocaani onoonoco jɨɨbeguejiibo, tollɨro bu amɨɨhaico gaajasujiibo ufucu iicajinehejeque icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Diibo uco bocɨgusuji taaño iicanotɨ agaayɨcɨɨboro amɨɨhaico gaajasujiibo. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Guihirubima iicano paryɨ taaño. Jaamaño uujoho neehi: Moocaani Gaija taaño iicanotɨ agaayɨcɨɨboro amɨɨhaico gaajasujiibo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Goovacujino amɨɨhai uco siino atyɨmecutɨmo mihicano. Jaarunobuunatɨ goovajɨɨsutɨnotɨ siino uco mahatyɨmeji Guihirubijaago efeejimaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jaaneguiiha ijɨɨbogomɨnaatɨ saatoho noocasiuhi: ¿Mɨllɨ fɨne eneejirunoco mɨɨhaico noobo: Goovacujino uco atyɨmecutɨmo mihicano, siino bu goovajɨɨsutɨnotɨ siino uco mahatyɨmeji Guihirubijaa efeejimaño? onoono ");
INSERT INTO bmrNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","neehicaumo: ¿Mɨllɨ eneejiruno goovajɨɨsujitɨno, bu goovajɨɨsujino onoono? Magaajatɨhi ihiimaanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jaanoco Jesu diiboco diito idillujirunoco agaajacɨuboro diitoco nuubo: Sanomɨro midillucasihi, uujoho goovajɨɨsujino uco atyɨmecuutɨmo mihicano, bu toonobuunatɨ goovajɨɨsutɨnotɨ siino uco mahatyɨmeji onoonotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Miyanotɨro, miyanotɨro amɨɨhaico neehi: Mataacasimoro ɨdaasuno mihicaji. Jaaneri jiije miyamɨnaa imo imo icaji. Jaaruno amɨɨhai ɨdaasu imo icatɨ minifeteji. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mɨɨro gaigo eseemevajisumi ɨdaasuno minifotogo ihaivofucuvɨ ɨɨfotomaño. Jaarugo eseemevacuunobuunatɨ ihaivoco esɨcɨnɨcuutatɨgo jiinɨjehallɨvɨ sisee seemene ifiiveneri imo imo iicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jaabadɨ amɨɨhai jisumi mɨhɨdaasuvehi. Jaarunaaca amɨɨhai siino uco mahatyɨmeneri amɨɨhai jeebɨɨno sihidɨ imo imo minifeteji. Jaano imo icaco mɨɨhaiñooba amɨɨhaiditɨ udumɨtɨɨcɨjitɨno. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Jaasumi uco siino midillucujitɨhi. Miyanotɨro amɨɨhaico neehi: Guihirubi amɨɨhaico acɨji fanoovaco tamomofeenedɨ midillunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jisumihiica amɨɨhai jinejebaco midillutɨhiica tamomofeenedɨ: Midillu. Jaamo magaayɨcɨhi. Jaamo sihidɨ imo imo mihicahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jillɨ amɨɨhaico neehi siinovɨ oovɨcɨɨboro. Jaarunofaño tufucu gaseji siino amɨɨhaico siinovɨ oovɨcɨɨboro ɨjɨɨbugucuujitɨno. Jillɨ foovonoro amɨɨhaico Guihirubitɨ ɨjɨɨbugucujino. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jaasumi amɨɨhaihallɨvɨ Moocaanico uujoho dilluji amɨɨhaico nootɨhi: ");
INSERT INTO bmrNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Guihirubiro amɨɨhaico gaijɨhi, uco amɨɨhai magaijɨmaño, tollɨro bu uujoho Moocaanitɨ asaahinɨnoco mimiyaavogomaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Uujoho Guihirubitɨ ihiinehinɨɨboro jiijehallɨvɨ saahinɨhi. Jaaruubo siino jiinɨjeque ejeevesuuboro dojɨcuvɨro Guihirubijaago fuucuuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jaanegui ijɨɨbogomɨnaa diiboco nuuhi: Jisumi naha foovono diimaahi siinovɨ oovɨcɨtɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jisumi naha jari magaajacuuhi ɨɨjoho fanoovaco agaajanoco. Jaamaño mɨɨhaiñooba ɨco dillucujitɨrahi, bu mɨɨhai imino magaajacuuhi ɨɨjoho Moocaanitɨ asaahinɨnoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jaanegui Jesu diitoco iimusuuhi: ¿Jaanegui nacu jari jisu mimiyaaveguehi? ");
INSERT INTO bmrNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tufucu jino gasecuji; fɨne tusu mihicacuuhi, jino amɨɨhai fahɨgovavɨ safiisa amɨɨhai naagonovɨ magavaranamaaijino tacojɨtɨ uco mejeevesumoro. Jaaruubo uujoho uuro icajitɨhi Guihirubi uuma icaji. ");
INSERT INTO bmrNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jillɨ amɨɨhaico neehicahi. Jaamo uuvɨ sajeebɨɨ mihicahi. Jiinɨjehallɨvɨ sihidɨ ɨdaasuma mihicaji. Jaarunofaño ucoro mehesɨcɨnɨ, uujoho jiinɨjeque guiinonɨcuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jillɨ Jesu unuunobuunatɨ, niquejeque emeecɨuboro, nuuhi: Guihihi, tusumi mihicacuuhi; Daachico cahacɨsu, tollɨro bu Daachi ɨco icahacɨsuqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ɨɨjoho Daachico diijɨco daacɨhi paryɨ miyamɨnaahallɨvɨ. Jaamo paryɨ ɨɨjoho uco adaacɨmoco ifinɨjitɨno fiivoco acɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jaano jino ifinɨjitɨno fiivo, ɨdɨɨboro ɨɨjoho miyaabo Moocaani idiicanoco agaajano, bu tollɨro Jesucristoco ɨɨjoho agalluuhinɨɨboco agaajano icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Uujoho ɨco jiinɨjehallɨvɨ bocɨgusuhi; imivucuuhi uco atajɨɨbahinɨnoco omoonɨhicaabo. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jaaneguiiha, Guihi, uco dicojɨvɨ bocɨgusu jiinɨje fiivuutɨnaacaro dicojɨvɨ uco obocɨgusuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jiinɨjemɨnaatɨ ɨdɨɨcɨɨboro uco adacɨmoco dimomoco gaajasucuuhi. Dita iicahinɨmoco uco daacɨhinɨhi. Jaamo imino diijɨco ficuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jisumi gaajacuumo paryɨ uco adaacɨhinɨno ɨɨtɨ asaanoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Diijɨco uco adaacɨhinɨnoco diitoco acɨhicacuuhi. Jaanoco agaayɨcɨmoro gaajacuumo miyaanoro uujoho ɨɨtɨ asaahinɨnoco. Jaamoro miyaavogomo miyaanoro ɨɨjoho uco agalluuhinɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Jaamohallɨvɨ ɨco dilluhi, Famoohallɨvɨro jiinɨjemɨnaahallɨvɨ ɨco dillutɨhi, dita iicamoco uco adaacɨhinɨmohallɨvɨro dilluhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mɨɨro paryɨ taaño iicano diino, tollɨro bu diino iicano taaño icano. Jaamofañodɨ uujoho cahacɨsucafetehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Jaaruubo uujoho jiinɨjehallɨvɨ icacuujitɨhi. Jaanotɨ diito jiinɨjehallɨri icaji. Jaanotɨ uujoho dijaa feeji. Jaanegui, Guihi, ɨɨjoho idiimiibo, uco adaacɨhinɨmoco dimityari toomo, saafiibadɨro diito iicaqui ɨɨma mɨsi saafiiro mihicabadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Uujoho jiinɨjehallɨri iicahinɨsumi diitoco teemehicahinɨhi dimityari uco adaacɨhinɨmoco imino teemehinɨhi. Jaamaño saafiiba diitotɨ mɨtatɨhi; ɨdɨɨboro johono ɨmɨtacuubo Caatɨnɨhaamefaño onoono imiyaavequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Jaaruubo jisumi dijaago fuucuuji. Jillɨ neehi jino jiinɨjehallɨri iicanohachutahiica tahimohicari diito tollɨro imo imo iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mɨɨro diijɨco uujoho diitoco acɨcuuhi. Jaarumoco jiinɨjemɨnaa diitoco gaayɨcɨtɨhi jiinɨjeoto iicatɨmaño, uujoho bu jiinɨjemɨnaafi iicatɨmaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jaanegui diitoco jiinɨjehallɨtɨ dɨɨcɨqui ɨco dillutɨhi. Diitoco ɨjɨtɨ dɨhɨɨfɨnɨcɨquiro ɨco dilluhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jaamo diito jiinɨjemɨnaa icacuutɨmo uujoho jiinɨjemɨnaafi iicatɨbadɨro. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Jaamoco ɨɨguiiharo ijeevadɨ ficu miyaanofeenedɨ, dijɨɨbogo aivo miyaano. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ɨɨjoho uco jiinɨjemɨnaafeenevɨ agalluuhinɨbadɨro, bu uujoho diitoco jiinɨjemɨnaafeenevɨ galluuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jaamaño uujoho diitofañodɨ uuro tafiico ɨɨdiro ijeevadɨ ficuuhi. Tollɨro bu diito ɨɨdiro ijeevadɨ ificucafetequi miyaanofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Diitohallɨvɨro ɨco dillutɨhi, tollɨro bu diito jɨɨbogofeenedɨ uco imiyaaveguejimohallɨvɨ ɨco dilluhi, ");
INSERT INTO bmrNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","sano famooro saafiibadɨro mɨsima iicaqui; Guihi, ɨɨjoho uuma, bu uujoho ɨɨma icano mihicabadɨ iicaqui, jiinɨjemɨnaa imiyaaveguequi ɨɨjoho uco agalluuhinɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Diitoco acɨcuuhi, uco adaacɨhinɨno bocɨyomonoco, sanobadɨro iicaqui ɨɨma mɨsi sanooro mihicabadɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Uujoho diitofaño, ɨɨjoho tafaño icano mihicaqui diito sanobadɨro iminifetequi. Jaanofañodɨ jiinɨjemɨnaa igaajaqui ɨɨjoho uco agalluuhinɨnoco, bu diitoco agaijɨnoco, bu uco agaijɨnoco icano igaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Guihi, imeguehi uco adaacɨhinɨmo uujoho iicahɨgo tollɨro iicano uco bocɨco adaacɨhinɨnoco ihatyɨmequi, jiinɨje fiivuutɨnaacaro uco ɨɨjoho agaijɨumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Guihi, miyaano, ɨco jiinɨjemɨnaa agaajatɨmo. Jaanotɨ uujoho ɨco gaajahi, tollɨro bu jito gaajacuuhi ɨɨjoho uco agalluuhinɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jaamoco gaajasuhicacuuhi dimomoco. Jaarunoco janaanɨcɨhiica gaajasuji ɨɨjoho uco agaijɨno diitofaño iicaqui, bu uujoho diitoma icaqui icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jillɨ unuuboro Jesu ijɨɨbogomɨnaama fuuhi Cedro onoohigayɨ onegueehi iicaubajɨgayɨ tuhiguiino diitoma fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tollɨro bu Juda diiboco aacɨujiibo tomañoco gaajauhi fahiijɨvaro Jesu tobajɨjaago ijɨɨbogomɨnaama efeehicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jaanegui amocasimɨnaa, temploja toomomɨnaa icamoco fariseomɨ, sacerdotemɨ aivojɨto icamo agalluumoco Juda ɨɨcɨuboro satyuuhi. Jaamo fuuhi ihaamɨganoma, iniisuganoma, cuugahuneri, cɨɨjɨgaimecuneri icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jaanoco Jesu paryɨ gaajacuuhi diiboco omoonɨujinoco. Jaaboro ɨmegavɨro diitoco nuubo: ¿Mɨɨco amɨɨhai miguiinehi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jaanegui diiboco iimusuumo: Jesu Nazareooboco, noomoro. Jaanegui Jesu diitoco nuuhi: Etɨ du uujoho diibo, nooboro. Jaamofaño icaubo Juda Jesuco igaayɨcɨqui diitoco ɨsɨɨguubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jaamoco Jesu: Uujoho diibo, unuuneri diito ibujɨnaagovɨro aifuumo jiinɨjehallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jaadɨ Jesu siino diitoco dilluuhi: ¿Mɨɨco miguiinehi? nooboro. Jaanegui diito nuuhi: Jesu Nazareooboco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jaanegui Jesu nuuhi: Amɨɨhaico duhu: Uujoho diibo, nuucuuhi. Uco miguiinohachiijɨ taca jitoco mejeecɨvedino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jillɨ nuubo: Uco adaacɨhinɨmotɨ saafiiba mɨtatɨhi, unuuno imiyaavequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jaasumiro Pedro iniisugaco ifajutafañotɨ iguiiyɨcɨuboro saafiico buiyaacuuhi, jahɨ saafi Malco onoobo sacerdotemɨ aivojɨɨbo jeecɨvomɨnaafi nɨjɨmeehuco quitɨcɨsuuhi imiyanaagomeehuco. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jaanegui Jesu Pedroco nuuhi: Diniisugaco dojɨcuvɨro dɨɨhacu. ¿Nacu ɨɨjoho gaajatɨhi ɨdaasuno iicaqui uco Guihirubi atajɨɨbanoco? Jaanoco bu, ¿mɨllɨ jaabo uujoho: Chahano, neejirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jaasumiro ihamocasimɨnaa, diito aivojɨɨboma, bu judiomɨ sisɨmɨnaa icamo Jesuco agaayɨcɨumoro sisɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jaamoro tɨconɨumo Jesuco Anas onoobo Caifas baabojaago asatyumo tusumi Caifas sacerdotemɨ aivojɨɨbotɨ iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jaabo diibo Caifas judiomɨco afajɨɨnɨubo: Imino saafiiro faacuumihallɨvɨro iguijevene, nooboro unuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jaabo dojɨcutɨ fuumɨsi ijɨɨbogomɨnaatɨsi, Simon Pedro, bu saafi icano. Jaabo saafiu sacerdotemɨ aivojɨɨboco agaajacuubo. Jaamaño diibo Jesuma jɨcafutuuhi sacerdotemɨ aivojɨɨbo goohasifaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Jaarunaa Pedro iguhugavɨro fitafutuuhi. Jaanegui diibo sacerdotemɨ aivojɨɨboco agaajaubo ufuuboro iguhuga toomomɨnaagoma ihiimaauboro Pedroco fañovɨ jɨɨhacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jaanegui diigo Pedroco nuuhi: ¿Nacu ɨɨjoho tollɨro diibo jɨɨbogomɨnaafi idiicaabo? noogoro. Jaanegui diibo nuuhi: Chahano uujoho diibo icatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jaanaa ɨsɨɨcuneguiiha cɨɨjɨgaico eebasuumoro feemehicaumo jeecɨvomɨnaa, sisɨmɨnaa icano. Jaamofeeneri tollɨro bu Pedro icauhi efeemeubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jaanaa sacerdotemɨ aivojɨɨbo Jesuco dilluhicauhi ijɨɨbogomɨnaaditɨ, ijɨɨbogotɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jaanegui Jesu diiboco iimusuuhi: Uujoho foovono iimaahicahi. Fahiijɨvaro miyamɨnaa ɨmefeenevɨ sinagogajanofaño, templojafaño icano. Fahiijɨvaro jɨɨbeguehicahi famooro judiomɨ iigaivonɨcɨjahajefaño uujoho toovono iimaahicatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Collɨhi jaanoco uco dilluhi? Diitoco dillu, uujoho ihiimaahicanoco uguubuhicamoco. Diito gaajahi uujoho eneehicanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesu jillɨ diiboco unuunegui, saafi sisɨmɨnaafi Jesuco ihɨmetɨ gabacuuhi: ¿Nacu tollɨ ɨɨjoho aivo diimusuhi sacerdotemɨ aivojɨɨboco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jaanegui Jesu diiboco iimusuuhi: Imitɨno ihiimaahachiijɨ, eneecata dinoo. ¿Cono nacu imitɨno onoono? ¿Collɨhi jaabo uco daamɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jaanegui Anas Jesuco sisɨcɨnɨuboco sacerdotemɨ aivojɨɨbo Caifasjaago galluuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jaanaa Pedro julleecɨnɨɨboro feemehicauhiica diitoma. Jaaboco nuumo: ¿Nacu ɨɨjoho diibo jɨɨbogomɨnaaobo diicatɨhi? noomoro. Jaanegui Pedro tuunamaaiuhi: Chahano uujoho diitoobo icatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jaanegui sacerdotemɨ aivojɨɨbo jeecɨvomɨnaafi nuuhi: ¿Jaaruno du Olivohono iicagajɨguiino ɨco uujoho diiboma atyɨmehinɨhi? nooboro. Mɨɨro Pedro diibo yoobo nɨjɨmeehuco Olivohono iicagajɨguiino iquitɨcɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jaarunaa Pedro siino tuunamaaiuhi. Jaasumiro ɨvɨ catava ojɨcuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jaamoro Jesuco satyuumo Caifas iijatɨ tomañohaivojɨɨbo iijajaago. Jaanaa seseevecuuno. Jaanegui judiomɨ toojafaño jɨcafutuutɨmo ijeevamaje onoobadɨ imitɨri ijeebɨɨco ɨmɨhɨninɨumoro Pascua machuco amachuujitɨruneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jaanegui aivojɨɨbo Pilato ihiinuuboro diitoco nuuhi: ¿Jinejehallɨtɨ diiboco mɨsɨvahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jaanegui iimusuumo: Gaicaaumɨnaafi iicatɨruva ɨco mahacɨjitɨrahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Jaanegui diitoco nuubo: Amɨɨhairyo masatyomoro amɨɨhai tajɨɨba onoobadɨ momoonɨ, nooboro. Jaanegui judiomɨ diiboco iimusuuhi: Mɨɨhai judiomɨ, mɨɨhaiñoobaco mɨllɨtɨ magaicaaujitɨrahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jillɨ miyaavuuno, Jesu jillɨ guijeveji, nooboro eneehicauno. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jaadɨ siino Pilato fañoojavɨ ɨjɨcafutuuboro tahɨ Jesuco ocoovauboro dilluubo: ¿Ɨɨjoho naa judiomɨ Aivojɨɨbo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jaanegui Jesu iimusuuhi: ¿Dijeebɨɨtɨro nacu tollɨ uco dilluhi? ¿Nacu sita uuditɨ ɨco tollɨ neehi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jaanegui Pilato diiboco nuuhi: ¿Nacu uujoho judiomɨoobo? Chaha, siicuumioobo. Mɨɨro diijiinɨjemɨnaaro, sacerdotemɨ aivojɨtoma ɨco uco acɨhi. ¿Jinejeque jana moonɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jaanegui Jesu diiboco iimusuuhi: Jijeono tahaivojɨ icatɨhi. Jijeono tahaivojɨ iicaruva tajeecɨvomɨnaa tahallɨtɨ icajirahi judiomɨ usefaño uco acɨtɨmo iicaqui. Jaanotɨ tahaivojɨ jijeono icatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jaanegui Pilato diiboco nuuhi: ¿Jaaneguiihacuva ɨɨjoho aivojɨɨbo? nooboro. Jaaneguiiha Jesu diiboco iimusuhi: ¿Ɨɨjoho du etɨ, uco aivojɨɨbo, neehi? Tooneguiiha uujoho ifiivehinɨɨbo jiijehallɨvɨ saahinɨhi miyaanocoro neequi. Jaano miyaano iicanoco paryɨ agaajamo uujoho onoonoco guubunɨcɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jaanegui Pilato diiboco nuuhi: ¿Jineje nacu miyaano? unuuboro siino Pilato judiomɨjaago saauhi diitoma ihiimaavaubo. Jaaboro diitoco nuubo: Diibovɨ uujoho iimitɨnobaco atyɨmetɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mɨɨro amɨɨhai amɨɨhai jeevamaajefi uujoho Pascua jɨɨbaimosumi saafiitɨ cɨvojamɨnaafitɨ isinaayuno. Jaaneguiiha, ¿naa mihimeguehi judiomɨ Aivojɨɨboco isinaayunoco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jaanegui famooro sefano coovadiivuuhi: Diiboco sinaayujitɨhi, Barrabacoro sinaayu, noomoro. Jaabo Barraba nanivamɨnaafiu. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jaanegui Pilato Jesuco ɨɨcɨuboro aamɨsuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jaadɨ amocasimɨnaa januutuno coohaiñooco minɨhaitɨ eheetavuumoro iinigaɨvɨ diiboco javucaruumo. Jaamoro bu diiboco jɨɨhacuumo aivojɨɨbo gaachehubadɨ gachicohai deecano tɨfaibadɨ itɨfai iicachehuco. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jaamoro diiboco sahaguehicaumo: ¡Judiomɨ Aivojɨɨbo Diica! noomoro, diiboco ihɨmefaño ganɨɨcɨhicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jaanegui Pilato siino asaauboro diitoco nuuhi: Memeecɨ, eneecau diiboco isivɨ sɨvaqui, jaamo magaajahi diibovɨ iimitɨnobaco uujoho aatyɨmetɨnoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jaanaa Jesu iinovauhi ijanuutuno minɨhaima, igaachehu tɨfaihɨba iicachehuma icano. Jaanegui Pilato nuuhi: ¡Jaanɨ diibo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jaaboco sacerdotemɨ aivojɨto, bu isisɨmɨnaa icamo aatyɨmeumoro sefano coovadiivuumo: ¡Diiboco ɨmohobujehallɨvɨ metetecu! ¡Metetecu! noomoro. Jaanegui Pilato diitoco nuuhi: Etɨ tahɨ masatyomoro metetecu. Jaanotɨ uujoho diibovɨ iimitɨco atyɨmetɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jaarunofaño judiomɨ diiboco iimusuuhi: Mɨɨhaima icano tajɨɨba jaano onoobadɨ guijevejiibo imoonɨqui ijeebɨɨtɨro: Uujoho Moocaani Seemene, neehicaabo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jillɨ diito unuunoco Pilato uguubuuboro janaanɨcɨ aivo iguiubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jaaboro siino iijafaño ɨjɨcafutuuboro Jesuco dilluubo: ¿Cuucatɨobo ɨɨjoho? nooboro. Jaarunoco Jesu iimusucuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jaanegui diiboco Pilato nuuhi: ¿Uco diimusujitɨrahi? ¿Nacu gaajatɨhi ɨco etetecusujiruno, isinaayujiruno icano mityama iicanoco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jaanegui diiboco Jesu iimusuuhi: Tahallɨvɨ mityabama chahajirahi ɨco Moocaani ihacɨtɨruva. Jaamaño ɨco uco aacɨɨbo aivo dijanaanɨcɨ imitɨma icahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tollɨ unuunoma iicaabo Pilato diiboco isinaayuqui moonɨhicauhi. Jaarunaa judiomɨ sefano neehicauhi: ¡Diiboco isinaayuhachiijɨ aivojɨɨbo Cesar nahabonɨmɨnaafi diicatɨhi! Mɨɨro: Uujoho aivojɨɨbo, onoomo Cesarmɨnaafitɨ minifetehi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jaanegui Pilato diito tollɨ unuunoco uguubuuboro Jesuco isivɨ ɨsɨvauboro casɨɨvuubo ihaivojɨ icagahallɨvɨ. Jaano hebreomɨ iijɨri Gabata, onoono guiisibano nicuta eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jaasumi Pascua jɨɨbaimo iicaujino fiitɨcuuhi gadɨcɨɨbarucuu iicauno. Jaaboro Pilato judiomɨco nuuhi: ¡Jaanɨ amɨɨhai Aivojɨɨbo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jaarunofaño diito sefano coovadiivuuhi: ¡Jaafa guijeveebe! ¡Jaafa guijeveebe! ¡Tetecu! noomoro. Jaanegui Pilato nuuhi: ¿Amɨɨhai Aivojɨɨboco jaabo tetecuji? nooboro. Jaarunofaño sacerdotemɨ aivojɨto iimusuuhi: Mohaivojɨɨbo Cesar uufocovɨ sifi mohaivojɨɨbo chahahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jaanegui diito usefaño diiboco jeevesuubo itetecuqui. Jaaboco ɨɨcɨumoro satyuumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jaadɨ Jesu fuucuuhi icubujeque agafaiyɨɨcɨhinɨɨboro nigaɨpaajebaɨ onoomañovɨ. Jaanotɨ hebreomɨ iijɨri Golgota onoobaɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jaamañovɨ diiboco tetecuumo, tollɨro bu miimɨsiicɨco tetecuumo icano. Jaamɨsifeenevɨ Jesuco ficuumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jaabo Pilato imomoco acaatɨnɨuboro Jesu guijeve ɨmohobujevɨ ficusuuhi: JESU NAZAREOOBO JUDIOMƗ AIVOJƗƗBO onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jaanoco guiraamo saatoho judiomɨ toonoco meecɨuhi. Jesuco etetecuumaño tuucuumitɨ ifiitɨumaño. Jaano toono imomo caatɨnɨcɨnɨuhi hebreo iijɨri, griego iijɨri, latin onoojɨri icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jaanegui judiomɨ sacerdotemɨ aivojɨto Pilatoco nuuhi: Judiomɨ Aivojɨɨbo nooboro, caatɨnɨdino. Jillɨ: Judiomɨ Aivojɨɨbo uujoho, eneehicaabo nooboro, caatɨnɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Jaarunofaño diitoco Pilato iimusuuhi: Acaatɨnɨbadɨro icacuujino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jaamo ihamocasimɨnaa Jesuco etetecuunobuunatɨ Jesu gaachehuco dugaacuumo sano nahabovacasidɨno. Jaamoro sanohosa itɨcovovɨ ɨfocasiumo. Tollɨro bu icamooja falluuratɨno sadaahere caamotɨ guiinovɨ nɨɨcɨnɨujaco ɨɨcɨumoro ");
INSERT INTO bmrNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","noocasiumo: Jichehuco masɨɨ ɨfocasitɨmoro tochehuhallɨvɨ suerteque meheetavequi: ¿Naa cajaanɨ tochehuco ɨcɨji, noomoro. Jillɨ moonɨumo Caatɨnɨhaamefaño onoono imiyaavequi: Tagaachehuco ɨfocasiumo. Jaamoro tacamoojahallɨvɨ suerteque eetavuumo, onoono. Jaabadɨ jillɨ ihamocasimɨ moonɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jaanaa Jesuco etetecuuboguiino icahicaugo seejɨ, bu diigo nago Maria onoogo Cleofa taaba, bu Maria Magdalena onoogo icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jaanaa Jesu seejɨco aatyɨmeuboro, bu tollɨro aivo agaijɨhicaubo ijɨɨbogomɨnaafico ihuufocori icauboco aatyɨmeuboro seejɨco nuubo: Gaha, diiburucuji daachibadɨ ɨɨma iicajiibo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jaadɨ bu tollɨro ijɨɨbogomɨnaafico nuubo: Diigurucuji diiseejɨbadɨ ɨɨma iicajigo, nooboro. Jaasumitɨro diigoco ijɨɨbogomɨnaafi iijafaño satyuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Toonobuunatɨ Jesu idudɨcamaajeque iimivucuunoco agaajacɨuboro nuuhi: Adujirahi, nooboro Caatɨnɨhaamefaño onoono imiyaavequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jaamañeri guirihillufaño icaufaihu iquigaño aivofaihu ɨɨdicufaihu. Jaafaihufaño faatata icanoco amatyusuumoro hisopo onooho usuho. Jaaho aafeque ɨɨcɨumoro tootaataco toohaafe nijequevɨ ificuumoro diibo iijɨfaño cabuyaacuumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jaanoco Jesu aaduuboro nuuhi: Ɨvɨ paryɨ imivocafutucuuno, nooboro. Jaadɨ acanuvuuboro guijevecuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jaanaa Pascua jɨɨbaimo seseevedɨ iicacuujineguiiha. Tufucu jaguisɨfucu iicauneguiiha judiomɨ imuguutɨhi diito ifiino tubujejevɨro iicaunoco. Mɨɨro diito jaguisɨfucuvɨ jinejeba aivo eheetavorahicautɨmaño. Jaanegui Pilatoco dilluumo saatohoco itajɨɨbaqui idɨɨnoco agafaryucumoro diitoco toonotɨ sihɨgovɨ ificuuqui. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jaanegui amocasimɨ asaaumoro saafiico idɨɨnoco gafaryucuumo. Jaadɨ bu tollɨro saafiico moonɨumo Jesu cojɨvɨ etetecucɨnɨumɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jaadɨ Jesuvɨ ɨɨfutuurumaaca chuumucuubo. Jaanoma iicaumo diibo idɨɨnoco gafaryucuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jaarunaaca diitotɨ saafi Jesu mecuhuco ihaamɨgari cafatyɨcaruuhi. Jaasumiro diibofañotɨ iinuuno tɨɨjoho, nɨfaihu icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jaanoco aatyɨmeubo miyaanocoro jɨɨbeguehi. Jaabo gaajahi toono miyaano iicanoco. Jaamo amɨɨhai tollɨro bu mimiyaaveguehi. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jillɨ icauno Caatɨnɨhaamefaño: Dibacɨno quisicurajitɨhi, onoono imiyaavequi. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jaabadɨro bu samañoohaamefaño noono: Cafatyɨcarucɨnɨɨboco mahatyɨmeji, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Toonobuunatɨ Jose Arimatea cuumioobo Jesuma efeehicauruubo judiomɨ ñɨhicutɨ toovono ufuuboro Pilatoco dilluubo Jesu ifiico ihɨcɨqui. Jaaneguiiha Pilato: Jii, nuuhi. Jaaneguiiha ufuuboro Jesu ifiico ɨcɨjeubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tollɨro bu Nicodemo fuuhi itɨconɨ Jesuma fucu ihiimaajeubo. Jaabo guiraano facɨcɨfaihuco sɨvauhi treinta kilo tɨcovovɨ. Tofaihuco mirra, aloe iicaneri eetavuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jaamɨsiro gaachehubaanoco tooneri afacɨcɨsumɨsiro Jesu ifiico minɨuhi, judiomɨ jeevamaaje tollɨ ɨcɨɨnɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jaano diiboco etetecuumañeri icauno bajɨgayɨ. Jaamañeri bohojɨ cɨɨhojɨ icauhi mɨɨhaiñoobaco tohojɨfaño ɨcɨɨutɨhojɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jaahojɨfaño Jesu ifiico cɨɨumɨsi tohojɨ tomañotɨ ifiitɨumaño judiomɨ jaguisɨfucu ɨtɨcovacuuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jaanaa judiomɨ jaguisɨ iicauno seseevedɨ Maria Magdalena onoogo Jesu cɨɨhojɨjaa fuuhi fucugayɨro cɨvonaacaro. Jaago atyɨmeuhi icɨɨhojɨco afabaacuuba iguiisiba sihɨgovɨ aacaubaco. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jaanegui Simon Pedro, bu saafi Jesu agaijɨhicaubo ijɨɨbogomɨnaafi icamɨsijaa ijinafatyuugoro diitɨsico nuuhi: Aivojɨɨboco icɨɨhojɨfañotɨ cuucahacho satyucuumo. Jaanoco magaajatɨhi, ¿cuucahacho fɨne ficuumo? noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jaaneguiiha Pedromɨsi icɨɨhojɨjaago ");
INSERT INTO bmrNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","jinoomɨsiro fuuhi. Jaanaa saafi Pedro ɨmegaro icɨɨhojɨvɨ ɨfutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jaaboro tohojɨfañoco ɨdɨjɨɨvuuboro emeecɨubo atyɨmeuhi iminɨtaacoro. Jaaruubo tohojɨfaño fuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jaanobuunatɨ jari Simon Pedro gaseuhi diibo dojɨcutɨ. Jaabo tohojɨfaño ɨjɨcafutuubo atyɨmeuhi iminɨta tomañeriro acaacɨnɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tollɨro bu Jesu ɨmeque iminɨubaryu imino minɨcɨnɨubaryu ijeevadɨ acaaubaryuco atyɨmeubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jaanegui bu tollɨro saafi jɨcafutuuhi tohojɨfaño, itɨconɨ tohojɨvɨ agaseubo. Jaabo toonoco aatyɨmeuboro miyaavuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jaarumɨsi gaajautɨmɨsihiica Caatɨnɨhaamefaño: Jesu iguijeveebe siino buheeteji, onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jaadɨ Pedromɨsi siino dojɨcuvɨro iijajaago uumicuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Jaanaa Maria iinoro fitafutuuhi tohojɨ ɨmega taagoro. Jaago taagoro dɨjɨɨvuugo tohojɨfañoco emeecɨugo. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jaago atyɨmeuhi miimɨsiicɨ Moocaani toomomɨnaatɨsico seseechehunofaño icamɨsi gɨcɨnɨuhi saafi Jesu nigaɨ iicaunaagonovɨ, jaanotɨ saafi itɨhai iicaunaagonovɨ icano icaumɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jaamɨsi diigoco nuuhi: ¿Jinejeri jaago ɨɨjoho taahi? noomɨsiro. Jaanegui diigo nuuhi: ¿Cuucahacho tahaivojɨɨboco asatyomoro ificuuneri? noogoro ");
INSERT INTO bmrNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ibujɨnaagoco emeecɨugo Jesuco atyɨmeuhi. Jaarugo diibo Jesu iicaunoco gaajautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jaagoco Jesu nuuhi: ¿Jinejeri jaago taahicahi? ¿Mɨɨco guiinehi? nooboro. Jaanegui diigo tobajɨgayɨ toomomɨnaaficoro eesɨcɨnɨumaño nuugo: Aivojɨɨbo, ɨɨjoho baacho asatyooboro, ¿cuucahacho ficuuhi? Uco dɨɨbogo ɨɨcɨɨtogoro satyequi, noogoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jaanegui Jesu diigoco dilluuhi: Maria, nooboro. Jaanegui diigo diiboco emeecɨugoro hebreomɨ iijɨri nuuhi: Raboni, noogoro; Jɨɨbogomɨnaafi, eneejiruno. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jaanegui Jesu diigoco nuuhi: Uco dudɨɨcɨdino; uujoho caamo Guihirubijaago footɨhiica. Jillɨro foogo tañahabomɨco dɨɨbogoto: Guihirubi, bu tollɨro amɨɨhaitɨ amɨɨhai Caani iicaabojaago feehi. Taacaani Moocaani iicaabojaago feehi. Jillɨ noogoro dɨɨbogoto, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jaanegui Maria Magdalena onoogo fuuhi ijɨɨbogomɨnaajaago Jesuco aatyɨmeunoco, bu diibo unuunoco icano diitoco ɨjɨɨbugutuugo. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jaafucuro iijɨcuuvɨ ijɨɨbogomɨnaa igaicɨnɨuhi samecufañoro judiomɨ ñɨhicutɨ iguhuganoco cuhufono ofoboocɨumoro icauhi. Jahɨ Jesu ɨjɨcafutuuboro diitofeenevɨ ujulleeveuboro diitoco dilluubo: Sajeebɨɨ mihica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tollɨ unuuboro diitoco ɨɨfusuubo ihuseneque etetecuunopaajeneque, bu imecuhutɨ ahaamɨupaajeque icano. Jaaneri ijɨɨbogomɨnaa imo imo minifutuuhi Ihaivojɨɨboco aatyɨmeumoro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jaadɨ siino Jesu diitoco nuuhi: Sajeebɨɨma mihica; Guihirubi uco agalluubadɨro bu uujoho amɨɨhaico galluuhi, ");
INSERT INTO bmrNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","nooboro diitohallɨvɨ fuunaruubo. Jaaboro nuubo: Magaayɨcɨ Moocaani Gaijaco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jaamo cajaatyocohacho iimitɨco mubuusumo iimitɨma chahacuji. Jaanotɨ mubuusutɨmo imitɨ buusuracujitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jaarunaa Tomasco Gaatyaba eneehicaubo diitoma chahauhi Jesu diitovɨ ajafeveusumi. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jaaboco saatoho ijɨɨbogomɨnaa jɨɨbuguuhi: Aivojɨɨboco mahatyɨmehi, noomoro. Jaarunofaño Tomas diitoco nuuhi: Ihusenefaño diiboco etetecuunopaajeneque aatyɨmeebere toopaajejefaño tahusegaiñoco ɨjɨɨhacutɨnohachuta, bu tollɨro imecuhutɨ diiboco ahaamɨupaajefaño ɨjɨɨhacutɨnohachuta miyaaveguejitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jaanobuunatɨ sahuse juugahusetɨ mifucucɨ, safucu icano nigacɨtɨ siino ijɨɨbogomɨnaa igaivuuhi toojafaño. Jaasumi Tomas diitoma icauhi. Jaanaa iguhugano cuhufono foboocɨnɨrunaa Jesu ɨjɨcafutuuboro diitofeenevɨ ujulleeveuboro diitoco dilluubo: Sajeebɨɨma amɨɨhai mihica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jaaboro Tomasco nuubo: Ɨfaaji ɨvɨ jisumi dihusegaico jinofaño dɨɨhacu. Jaaboro jino tahuseneque meecɨ, bu juugavɨ saabo jino tamecuhufaño dihuseque dɨɨhacu. Jaaboro mabañɨhi nootɨɨbo, miyaavogo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jaanegui Tomas diiboco iimusuuhi: ¡Tahaivojɨɨbo Moocaani! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jaaboco Jesu nuuhi: Tomas jari uco adaatyɨmeebere miyaaveguehi. Imino icajino atyɨmetɨrumo imiyaavogomo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tollɨro bu Jesu sihidɨ ejeevanoonoco ijɨɨbogomɨnaa ɨmefeenevɨ guiraano eetavehicauhi. Jaaruno jihaamefaño paryɨ caatɨnɨcɨnɨtɨno. ");
INSERT INTO bmrNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jaanotɨ jinoocoro caatɨnɨumo amɨɨhai mimiyaaveguequi Jesu diiburucu Cristo Moocaani Seemene iicanoco. Jaaboco mimiyaavogonofañodɨ diibovɨ ifinɨjitɨno fiivoma mihicahi. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jaanobuunatɨ siino Jesu ijɨɨbogomɨnaavɨ jafeveuhi Tiberia muuaijɨnivɨ. Jillɨ diitovɨ jafeveubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jaamo samañeriro icaumo Simon Pedro, bu Tomasco Gaatyaba eneehicaubo, bu Natanae Cana de Galilea onoocuumioobo, bu Sevedeo seemenetɨsi, bu tollɨro sitɨsi diitootɨsi icamoco ");
INSERT INTO bmrNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Pedro nuuhi: Uujoho fiicɨteji, nooboro. Jaanegui diito nuuhi: Tollɨro mɨɨhai ɨɨma masaaji, noomoro fuumo meenegari. Jaarumo tufucu saafiiba ɨcɨutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jaanaa seseevecuunaaca Jesu diitovɨ jafeveuhi jiinɨgaibaahovɨ. Jaaruuboco ijɨɨbogomɨnaa gaajacɨutɨhi diibo iicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jaabo diitoco nuuhi: ¿Sɨcafe, naa saafiiba mɨhɨcɨtɨhi? nooboro. Jaanegui: Chahano, nuumo. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jaanegui Jesu diitoco nuuhi: Amɨɨhai sinɨcuuhuco amɨɨhai meenegatɨ momiyanaagonovɨ magañɨɨ. Jaamo mɨhɨcɨhi, nooboro. Jaanegui tahɨgovɨ agañɨɨumo isinɨcuuhuco guiiyɨcɨcuutɨhi itaava bocɨri sihidɨ ɨjɨvusuumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jaanegui Jesu ijɨɨbogomɨnaafico agaijɨhicaubo, Pedroco nuuhi: ¡Mohaivojɨɨbo jahi! nooboro. Jaanegui Pedro Jesu jahi iicaunoco uguubuuboro igaachehuco siyaavuubo, igaachehuco ujujuuvuumaño. Jaaboro muuaifaño acutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jaanaa sanoodɨmo ijɨɨbogomɨnaa isinɨcuuhuco meenegari guicɨmoro ijɨnijaagovɨ sɨvaumo ijɨnitɨ cien metrohachutaro iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jaamo isivɨ ihiinuumo atyɨmeuhi cɨɨjɨgaihallɨri taavaabo gaarucɨnɨɨbo aacaaboco maahuma. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jaamoco Jesu nuuhi: Toono taavaco mɨhɨcɨmotɨ juu mɨsɨva, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jaanegui Pedro imeenegafaño ufuuboro isinɨcuuhuco isivɨ guiiyɨcɨubo sihidɨ queefimo taavaco ciento cincuenta y tresdɨmo icaurumoma isinɨcuuhu gallivuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jaamoco Jesu nuuhi: Masaamoro mamachuva, nooboro. Jaaruuboco ijɨɨbogomɨnaatɨ saafiiba dilluutɨhi: ¿Mɨɨjoho ɨɨjoho? noomoro Ihaivojɨɨbo iicaunoco agaajaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jaadɨ Jesu asaauboro itaavaaboco ɨɨcɨuboro diitoco acɨubo, bu tollɨro imaahuco acɨubo icano. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Toonoma mifoocɨ, safo icano icacuuno Jesu ijɨɨbogomɨnaavɨ ajafeveuno iguijeveubo siino ubuheeteunobuunatɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jaamo amachuunobuunatɨ Jesu Simon Pedroco nuuhi: ¿Simon, Jona achi, uco gaijɨhi jino janaanɨcɨvɨ? nooboro. Jaanegui Simon Pedro iimusuuhi: Jɨɨhɨ, Aivojɨɨbo, ɨɨro gaajacuuhi ɨco agaijɨnoco, nooboro. Jaanegui Jesu diiboco nuuhi: Jaaneguiiha taca oono toomomɨnaafi ihoveja seemeque ojoobɨnɨcɨbadɨ oono uco imiyaavogomoco dɨɨbeguehica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jaadɨ bu siino diiboco dilluubo: ¿Simon, Jona achi, uco gaijɨhi? nooboro. Jaanegui Pedro iimusuuhi: Jɨɨhɨ, Aivojɨɨbo, ɨɨro gaajacuuhi ɨco agaijɨnoco, nooboro. Jaanegui diiboco nuubo: Taañocota toomo ovejamɨco otoomonɨcɨbadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jaadɨ bu siino diiboco dilluubo: ¿Simon, Jona achi, uco gaijɨhi? nooboro. Jaaneri Pedro ɨdaasuvuuhi diiboco mifoocɨ, safo icano: ¿Uco gaijɨhi? nooboro idillucuuneguiiha. Jaaboro nuubo: Aivojɨɨbo, ɨɨro paryɨ gaajacuuhi ɨco agaijɨnoco, nooboro. Jaanegui Jesu nuuhi: Taañocota dɨɨbeguehica ovejamɨco ojoobɨnɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Miyanotɨro, miyanotɨro ɨco neehi: Sɨcafefi idiicausumi digaachehuco ɨdɨcafotooboro idiimogohɨgovɨ feehicauhi. Jaanotɨ amiyaabo idiicacuudɨ dihuseque gañiiyɨcɨɨboco ɨco sita digaachehuco jɨɨhacuji. Jaamoro ɨco satyejimo idiimogotɨruhɨgovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jillɨ nuubo Jesu Pedro coyomo guijeveri iguijeveujinoco agaajasuubo neehicauhi. Tooneri Moocaani bocɨco agaajasuujinoco. Jaadɨ diiboco nuubo: ¡Tadyojɨcutɨ disaa! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jaanaaca Pedro idojɨcuco emeecɨubo atyɨmeuhi Jesu agaijɨhicaubo ijɨɨbogomɨnaafi idojɨcutɨ ufuunoco niinoono amachuusumi diibovɨ ifituuvuuboro: ¿Aivojɨɨbo, cajaanɨ ɨco aacɨjiibo? nooboro idilluubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jaaboco Pedro aatyɨmeuboro Jesuco nuuhi: ¿Aivojɨɨbo, jana jaanɨji mɨllɨ? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jaanegui Jesu nuuhi: Iimogohachiijɨ icajiibo uujoho siino uhuuminohachuta. ¿Jaaruno ɨɨdi mɨllɨ icatɨhi? Jaanotɨ ɨɨjoho tadyojɨcutɨ disaa, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jillɨ diiboco unuunoco inahabomɨ jɨɨbocasiuhi: Diibo jɨɨbogomɨnaafi fɨne guijevejitɨhi, noomoro. Jaarunofaño Jesu guijevejitɨɨbo nuutɨhi. Iimogohachiijɨ siino uhuuminohachuta icajiibo. ¿Jaaruno ɨɨdi mɨllɨ icatɨhi? nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jaabo diibo jɨɨbogomɨnaafi jinooco jɨɨbeguehicahi. Jaaboro caatɨnɨubo. Jaanoco mɨɨhai magaajahi diibo ɨjɨɨbogono miyaano iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tollɨro bu sihidɨ saneheje Jesu omoonɨhicauno icarahi. Jaanehejeque sanohosari paryɨ icaatɨnɨruva uujoho onoono fɨne paryɨ jiinɨjehallɨri iicano aamenevɨ ɨɨfetejitɨruno.");
INSERT INTO bmrNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Agaijɨɨbo Teofilo, itɨconɨ acaatɨnɨuhaamefa caatɨnɨuhi Jesu jiinɨjehallɨvɨ iicaunohachuta omoonɨuboro ɨjɨɨbeguehicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Mɨɨro niquejefa ufuucujino ɨmega, iminɨsumɨnaaco ocoovauboro Igaijafañodɨ diitoco imino jɨɨbeguehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jaabo Jesu iguijeveunobuunatɨ diitovɨ siino jafevehicaubo cuarentadɨ fucuva tɨcovovɨ diitoco imino igaajasuqui diibo ubuheeneque. Jaabo diitoco jɨɨbeguehicauhi Moocaani aivojɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jerusaletɨ mefeedino. Moocaani Gaija asaajinoco motoomo, diibo eneehinɨnoco amɨɨhaico ɨjɨɨbeguehinɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Miyaano naha Jua nɨfaihuri nitɨhicauhi. Jaanotɨ amɨɨhai goovajino Moocaani Gaijari minitɨcafotono, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jaamo toono Jesuma iicausumi diiboco dilluumo: Mohaivojɨɨbo, ¿jaanegui jisumi Israel aivojɨco siino dojɨcuvɨro gasesuji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jaanegui Jesu diitoco iimusuhi: ¿Collɨhi magaajajirahi tusumico ɨdɨɨboro Moocaani tufucuco omoonɨjiibo gaajahi? ");
INSERT INTO bmrNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jaanotɨ Moocaani Gaija amɨɨhaihallɨvɨ iniitoodɨ mityaco magaayɨcɨji. Jaadɨ uutɨ mɨjɨɨbegueji Jerusalevɨ mihicabadɨro Judea jiinɨjevɨ, Samariavɨ, paryɨ jiinɨjejɨnibaacɨdɨ icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jillɨ nooboro diito ɨɨfɨnɨcɨnaaca caamovɨ fuucuubo aimuufaifeenedɨ niquejefaño. Jaaboco atyɨmecuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jaanegui imino ɨɨfɨnɨcɨumo atyɨmeuhi miimɨsiicɨ gaifiimɨsi seseechehunofa jɨɨcɨnɨumɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Jaamɨsi diitoco nuuhi: Galilea gaifiimɨ, ¿collɨhi niquejeque mɨhɨɨfɨnɨcɨhi? Diiboro jaanɨ Jesu jino niquejefa mɨhɨɨfɨnɨcɨnaaca ofoobo siino saaji jiinɨjehallɨtɨ jino ofoobadɨro, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jaanegui dojɨcuvɨro Jerusalejaa uumiumo Olivohono iicagajɨtɨ fiitɨno jaguisɨfucuvɨ judiomɨ ɨɨgonɨcɨnohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jaamo ijɨɨbogomɨnaa dojɨcuvɨro tuucuumivɨ agaseudɨ fuumo caamovɨ iicamecufaño iicahicauhɨgo. Jaamofeeneri icaumo Pedro, Jacoobo, Jua, Andre, Felipe, Tomas, Bartolome, Mateo, Jacoobo Alfeo achi, Simon cananistamɨoobo, Juda Jacoobo nahabo icamo. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jaamo diito famooro igaivehicauhi Moocaanima ihiimaaqui Jesu nahabomɨ, seejɨ Maria, bu sihidɨ saatoho gaigoomɨ icamo. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jaasumi Pedro diito ciento veintedɨmofeenetɨ ujulleeveuboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Tañahabomɨ, Moocaani Gaija Caatɨnɨhaamefañodɨ unuucuuno miyaavucuuhi Davidfeenedɨ Judaditɨ ihiimaauno: Jesuco miyamɨnaa usefaño aacɨjiibo, unuuno. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jaabo Juda mɨɨhaiobou jino dudɨcamaajefa iicauruubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jaaboco iimitɨhallɨvɨ ajaaduuruuno nɨhɨbamɨri jiinɨjeque naajeumo. Jaaruubo Juda ufuuboro iinoro caamotɨ iinigaɨjaagotɨ acutuubo. Jaaneri paryɨ iiba isi aifuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jaanoco Jerusale cuumiri iicaumo guubuuhi toono Juda nɨhɨbamɨri anaajeumañoco Alcedamatɨ momoonɨumo tɨɨjohojɨcɨcɨ eneejirunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jaamaño Salmohaamefaño jillɨ noono: Jaafa iija sɨcaijarucu mɨɨhaiñooba toojafa iicacuutɨqui. Jaabadɨro simañovɨ noono: Sifiirucu idudɨcamaajeque gaayɨcɨji, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jaabadɨro mofeeneri icamo saatoho gaifiimɨ Mohaivojɨɨbo Jesu mɨɨhaima iicausumi, ");
INSERT INTO bmrNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jua diiboco initɨunotɨ niquejefa ufuunohachuta iicaumotɨ. Jaanegui cajaanɨhacho saafi diitotɨ mɨɨhaijaa iminifetequi Mohaivojɨɨbo ubuheeteunoco ijɨɨbeguequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jaanegui miimɨsiicɨtɨ diitotɨ coovaumo Jose Barsaba Justo onoobo, Matia icamɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jaamoro diitɨsihallɨvɨ Moocaanima iimaaumo, jillɨ noomoro: Moocaani ɨɨjoho famoojeebɨɨco agaajaabo. Mɨɨhaico gaajasu, ¿naa diitɨsitɨ cajaanɨco dɨɨcɨhi ");
INSERT INTO bmrNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judabuunavɨ iicaqui? Jaabo Juda imitɨnoco omoonɨubo inaagonovɨ fuuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jaamoro suerteque agañɨɨuno Matiavɨ ɨfutuuhi. Jaabo tusumiro diito fahuseecɨ motɨhaitɨ saafi iicaumofa minifutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jaanobuunatɨ Pentecostefucu agaseusumi famooro samañovɨro igaicɨnɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jaanaa sefano guibuhubabadɨ niquejefañotɨ guubuvusuuno ifajafañovɨ diito ɨcɨnɨuhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jaasumiro famoovahallɨvɨ niituuno cɨɨjɨgaiguiihunobadɨ jeevano. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jaamo Moocaani Gaijari paryɨ gahafuuhi. Jaamoro sijɨɨjeri iimaaumo Moocaani Gaija ihiimaasubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jaasumi Jerusalevɨ icaumo judio gaifiimɨ. Jaamo judio iijɨco imino imiyaaveguehicaumo fahɨgova jiinɨjetɨ agaseumo ");
INSERT INTO bmrNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","toonoco uguubuumoro sihidɨ miyamɨnaa igaivuuhi. Jaamo sihidɨro eetyeuhi faaboho iijɨneri ihiimaaunoco saafi sifi iijɨri, bu saafi sifi iijɨri icano ihiimaaunoco uguubuumoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jaaneri eheetyeumoro dillucasihicaumo: ");
INSERT INTO bmrNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Mɨllɨ jaamo galileamɨnaa iicarumo moojɨneri iimaamoco muguubuuhi muucuumi iijɨri ihiimaanoco? ");
INSERT INTO bmrNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Jimañovɨ icamo Partia miyamɨnaa, Media jiinɨjeo miyamɨnaa, Elam jiinɨjeo miyamɨnaa, Mesopotamia jiinɨjemɨnaa, judeamɨnaa, capadociamɨnaa, Ponto jiinɨjemɨnaa, Asia jiinɨjemɨnaa, ");
INSERT INTO bmrNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","frigiamɨnaa, panfiliamɨnaa, Egipto jiinɨjemɨnaa, Africa cuumino Cirene janaanɨcɨ iicacuumijemɨnaa, bu tollɨro romamɨnaa icahi, saatoho judiomɨ, jaanotɨ saatoho judiomɨ jɨɨbogoco agaayɨcɨcuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tollɨro bu icamo Creta miyamɨnaa, Arabia miyamɨnaa icano. Jaarumo paryɨ faajɨvari iimaanoco muguubuhi Moocaani mityatɨ ihiimaanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Famooro jaaneri ajabafiituumoro sihidɨ esamaaimoro dillucasihicauhi: ¿Mɨllɨ fɨne jino iicano? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jaarunaa saatoho dejecuhicauhi: Jillɨ guiriicavomo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jaanegui Pedro paryɨ fahuseecɨ motɨhaitɨ saafi icamoma ujulleeveeboro sefano nuuhi: Judea miyamɨnaa, Jerusale cuumiri mihicamo icano imino uco muguubu. Jaamoro magaaja, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Jito miyamɨnaa guiriicavotɨmo amɨɨhai monoobadɨ mɨɨhaiñooba fucuro guiriicavotatɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jino Moocaani iimaamɨnaafi Joel, jillɨ unuucuuno: ");
INSERT INTO bmrNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Moocaani neehi: Niinosumi paryɨ miyamɨnaahallɨvɨ Tagaijaco niitusuji. Moseeme ufucu jillɨ iicajinoco jɨɨbegueji. Sɨcafe atyɨmeji Moocaani Gaija ɨɨfusunoco. Quillahuto tɨgaji. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tagaijaco niitusuji tusumi tajeecɨvomɨnaahallɨvɨ ufucu iicajinoco ijɨɨbeguequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Caamo niquejefaño ɨfusuji jabafiiranoco, baavɨ jiinɨjehallɨvɨ ɨfusuji toono jɨɨbogoco, tɨɨjoho, cɨɨjɨgai, aimuufaiguiihu icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cuujeo nɨhɨba cɨveteji, fucuo nɨhɨba tɨɨjohobadɨ minifeteji, Moocaani fucu ɨñɨhicufucu ɨmegavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jaasumi paryɨ Moocaanico idillumo taajaji. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Muguubu jino onoonoco amɨɨhai Israel gaifiimɨ: Moocaani Jesu Nazareooboco miyaabotɨ ɨfusuhinɨcuhi amɨɨhai ɨmefeenevɨ jabafiirano mityanoco eetavonofeenedɨ amɨɨhaico ɨɨfusucuunoco magaajacubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jaarunofaño diiboco magaayɨcɨumoro mahacɨuhi Moocaani sɨɨcɨjetɨro unuucuubadɨ masatyuumoro magaicaauhi. Jaamoro ɨmoho bujevɨ metetecuusuhi iimitɨno gaifiimɨ useri. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jaaruuboco Moocaani buheetesuhi guijeve aivotɨ ataajasuubo. Jaamaño diiboco guijeve gaayɨcɨutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mɨɨro aivojɨɨbo David Jesutɨ iimaaubo nuuhi: Aivojɨɨboco uujoho fahiijɨvaro atyɨmehicauhi tahɨmefeene icaaboco. Jaabo tamiyahusenaagonovɨ icahi jineje uco maryɨbasutɨno iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jaaneri uco tajeebɨɨ imo imo minifetehi. Taajɨri imo imo iimaahi. Jaabadɨro tafi sajeebɨɨ jaguisɨji. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Jaabo ɨɨjoho tajeebɨɨco iguijevehicamo iicahɨ deevesujitɨhi. Dihimi jeecɨvomɨnaafi agaijɨɨbo ifiico tuucɨsusujitɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Uco dɨɨbeguehi fiivojaa asatyono jɨɨhaico. Jaaboro uco dihɨme ificuuneri imo imo miniiyuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Fañɨ, jaanegui jino amɨɨhaico foovono neehi: Moheedeebe David iguijeveubo cɨɨhojɨ jino mofeeneri icahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Jaabo David Moocaani iimaamɨnaafiu. Jaabo gaajacuuhi Moocaani diiboco miyanotɨro ufucu saafi Cristo diiyaachi mɨɨhaitɨ dihaivojɨfaño acasɨɨvejiibo unuucuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jaabo sɨɨcɨjetɨro mahatyɨmecubadɨ gaajacuubo Jesucristo ubuheeteujinoco. Jaamaño nuubo Cristotɨ: Tajeebɨɨco deevesujitɨhi iguijevehicamo iicahɨgo tafiico tuucɨsusujitɨhi, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jaabo jaanɨ Jesuco Moocaani guijevefañotɨ buheetesuuhi. Jaanoco paryɨ mɨɨhai magaajahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jaaboco Moocaani agañiiyɨcɨuboro imiyanaagonovɨ ficuuhi. Jaabo Caanitɨ Igaijaco gaayɨcɨuhi Caani unuubadɨ. Jaabotɨ jino jisumi muguubuno, mahatyɨmene icano saahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Jaabo David niquejefa eguejeutɨhi. Jaaruubo jillɨ nuuhi: Moocaani Mohaivojɨɨbo Cristoco nuuhi: Tamiyanaagonovɨ casɨɨvo, ");
INSERT INTO bmrNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","dimɨnaaco ditɨhaiguiino ificuunohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Jaanoco paryɨ Israel cuumimɨnaa imino magaaja, jaanɨ diibo Cristoco amɨɨhai metetecuuboco Moocaani Aivojɨɨbotɨ ificuunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jillɨ onoonoco uguubuumoro ɨdaasuvuumo ijeebɨɨfaño. Jaamoro dilluumo Pedroco, bu sajɨɨbogomɨnaaco icano: Fañɨ, ¿mɨllɨ jaanegui mihicaji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jaanegui Pedro iimusuuhi: Moocaani ɨmefeenevɨ amɨɨhai imitɨco mejeevesucu. Jaamoro Aivojɨɨbo Jesucristo momofeenedɨ minitɨsuquimaaje amɨɨhai imitɨco ibusuqui. Jaasumiro Moocaani amɨɨhaico Igaijaco acɨji. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jaano jino iimaa amɨɨhaidi, ufucu icaji amɨɨhai seemedi icano, tollɨro bu fahɨgova tehesino iicamedi, paryɨɨcɨno Aivojɨɨbo Moocaani ocoovagomedi icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jillɨ sihidɨ nooboro Pedro diitoco fajɨɨnɨuhi: Mataaja jino miyamɨnaa iimitɨmofañotɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jaamo diibo jɨɨbogoco imiyaavuguumo nitɨsuquimaaiuhi. Jaasumiro tresmildɨmo Cristojaagovɨ minifutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jaamoco minɨsumɨnaa ɨjɨɨbogobadɨ imino icahicaumo. Jaamoro sahɨ igaivehicaumo Moocaanima ihiimaamoro panco iquisicuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jaaneri famooro jabafiitehicauhi minɨsumɨnaa mityanehejeque omoonɨhicauneri. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jaamo famooro imiyaavuguudɨmo sahɨ icahicauhi. Jaamoro inehejeque ɨfocasihicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Inehejeque anaajemere inɨhɨbamɨco ucuujɨvaachudɨno saje ɨfocasihicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Fafucuvaacɨvɨro templojafa igaivehicaumo. Jaadɨ iijanofaño panco iquisicumoro machuhicaumo, sabadɨro imo imo ijeebɨɨno iicamoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Moocaanico imehicaumo. Jaamoco miyamɨnaa gaijɨhicauhi. Jaamojaagovɨ Moocaani gataacuhicaubo bohono imiyaavogomoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jaanaaca safoono Pedro, Jua icamɨsi fuuhi templojajaago ɨmohonohallɨtɨ nɨhɨba icaaberi Moocaanima ihiimaahicausumi. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jaanaa ifiivuunotɨro ɨɨgotɨɨboco asatyumoro fafucuvaacɨvɨro temploja guhuga ɨmegavɨ diiboco ficuhicaumo imomo ovosɨɨhuga iicahuga ɨmegavɨ toojafaño ofoomoco nɨhɨbamɨco idilluqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Jaabo Pedromɨsi toojafaño ofoomɨsico aatyɨmeuboro diitɨsico nɨhɨbamɨco dilluubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jaaboco diitɨsi emeecɨudɨ Pedro diiboco nuuhi: Mɨsicoro dɨhɨɨfɨnɨcɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jaanegui diibo diitɨsicoro imino ɨɨfɨnɨcɨuhi: Fɨne uco nɨhɨbamɨco acɨjimɨsi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Jaarunaa Pedro diiboco nuuhi: Nɨhɨbamɨma chahahi, oroma chahahi. Jaarunaa uuma iicanoco ɨco acɨji Nazareoobo Jesucristo momofeenedɨ gañiivoobo, dɨɨgo, ");
INSERT INTO bmrNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","nooboro diiboco Pedro imiyahusetɨ agaayɨcɨuboro caamo gañiiyɨcɨuhi. Jaasumiro irubuɨno, itɨhaiño icano diiboco imituuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jaasumiro acasiniivuuboro ujulleeveuboro ɨgucuubo. Jaaboro diitɨsima toojafa fuubo casiniinamaaiboro Moocaanico imehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jaaboco famooro miyamɨnaa atyɨmeuhi ɨgooboro Moocaanico iimehicauboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jaaneri sihidɨ ajabafiitomoro sihidɨ eetyehicaumo famooro diiboco agaajacuumaño ovosɨɨhuga imomo iicahuga ɨmega acasɨɨvooboro nɨhɨbamɨco idilluhicaubo iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jaabo Pedromɨsico jeevesutɨɨbo diitɨsima feehicauhi. Jaaneri sihidɨ miyamɨnaa eheetyeumoro goovano sihidɨ gahafuumo Salomon Portalmañovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jaanoco Pedro aatyɨmeuboro miyamɨnaaco nuuhi: Israel gaifiimɨ, ¿collɨhi mɨsico majabafiihi mɨsiro jaanɨco momityari mubuheesumɨsiro mɨhɨgusu ɨvɨbadɨ mohiimihiijɨri mihica ɨvɨbadɨ? ");
INSERT INTO bmrNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tollɨ icatɨno diiboro Moocaani, sɨɨcɨje moheedeebe Abraham, Isaac, Jacob icamo imiyaavuguubo Moocaani Illi Jesuco janaanɨcɨ miyaabotɨ miniiyuubo amɨɨhai magaayɨcɨumoro amɨɨhai aivojɨtoco mahacɨuboco. Jaaboco Pilato sinaayuujirunaa amɨɨhai mihimugutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jaabo iimitɨma iicatɨɨbo Iimiiboco mɨjɨɨheguemere iimitɨɨbocoro gaicaaumɨnaafico misinaayusuumoro, ");
INSERT INTO bmrNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","fiivoco aacɨɨboco magaicaausuhi. Jaaruuboco Moocaani guijevefañotɨ buheetesuhi. Jaanoco mɨɨhai imino magaajahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jino ɨɨgoobo Jesu momoco imiyaavegueneri buheeteebe amɨɨhai mahatyɨmehicacuubo magaajacuubo Jesuco imiyaavogono diiboco buheesuhi jino amɨɨhai mahatyɨmebadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Jaarunoco fañɨ, uujoho gaajacuuhi famooro amɨɨhai aivojɨtoma magaicaauhi esɨcɨnɨtɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Moocaani jillɨ sɨɨcɨje paryɨ iimaamɨnaafañodɨ unuucuuno miyaavucuuhi Cristo ɨdaasuno iicaujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jaanegui amɨɨhai imitɨco mejeevesucu. Jaamoro Moocaanijaagovɨ masaa amɨɨhai imitɨ ibuuqui. Jaadɨ Aivojɨɨbo amɨɨhaidi galluji buheefucuco ");
INSERT INTO bmrNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jesuco agalluunofeenedɨ sahiijɨtɨro amɨɨhaidi Cristo unuucuuboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jaarunaa Jesucristo gueenene niquejefaño icajiibo Moocaani paryɨ fanoovaco iimibachunohachuta ihiimaamɨnaa sɨɨcɨje iicaumofeenedɨ unuucuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mɨɨro Moise nuuhi: Aivojɨɨbo Moocaani galluuji ihiimaamɨnaafiico uubadɨ iicaabotɨ amɨɨhai nahabomɨfañotɨ. Jaabo Moocaani agalluujiibo amɨɨhaico paryɨ onoonoco muguubu. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jaaboco uguubutɨdɨmoco Israel cuumitɨ udugaacumoro paryɨ finɨsuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Mɨɨro famooro Moocaani iimaamɨnaa Samuel iicaunotɨ jisumivɨ iicamo paryɨ jillɨ iicajinoco jɨɨbuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Amɨɨhai jaamo Moocaani iimaamɨnaa iyaachimɨhai mihicamo. Jaamaño mootadi Abrahamco Moocaani unuunofaño amɨɨhai mihicahi. Mɨɨro Moocaani Abrahamco nuuhi: Abraham, paryɨ jiinɨjemɨnaa diiyaachimɨhaifeenedɨ imino icaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mɨɨro jaabo Moocaani Illi Cristoco ubuheetesuuboro itɨconɨ amɨɨhaijaa galluubo amɨɨhaico imino imoonɨqui. Jaamo amɨɨhai, amɨɨhai imitɨco mejeevesuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedromɨsi jillɨ miyamɨnaaco jɨɨbeguehicaunaacaro saaumo sacerdotemɨ temploja toomomɨnaafi aivojɨɨboma, saduceomɨma icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jaamoro sihidɨ sɨfiiratuumo Pedro, Jua icamɨsi miyamɨnaaco: Jesu ubuheeteunotɨ ufucu siino mubuheetejinoco magaajacuuhi, noomɨsiro ɨjɨɨbeguehicaunotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jaamoro diitɨsico agaayɨcɨumoro cɨvojafa ficuumo seseevedɨ iinusuqui mihiijɨcuuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Jaamɨsico uguubuumotɨ sihidɨ saatoho miyaavuguuhi. Jaamo imiyaavoguunoco sano gaifiimɨcoro ihoovo fɨne cinco mildɨmo ɨfutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jaano sifucu Jerusalevɨ igaivuumo judiomɨ aivojɨto, iquillahuto, caatɨnɨmɨnaa icamo. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Jaamoma bu tollɨro icaubo Anas sacerdotemɨ aivojɨɨbo, tollɨro bu Caifas, Jua, Alejandro icamo, bu paryɨ saatoho diibo yoto icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jaamoro Pedromɨsico ucuuhuvaumoro ifeenevɨ ificuumoro diitɨsico dilluumo: ¿Mɨɨjoho iijɨtɨ, mɨɨjoho momofeenedɨ icano jillɨ amɨɨsi momoonɨhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jaanegui Pedro Moocaani Gaija ijeebɨɨfaño iicaabo diitoco nuuhi: Israel cuumimɨnaa aivojɨto, quillahuto icamo ");
INSERT INTO bmrNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ɨɨgotɨɨboco fɨne mubuheesuhinɨnoco mɨsico midilluhi diibo ubuheehinɨnoco magaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jaanoco amɨɨhai ɨmefeenevɨ mɨjɨɨbegueji paryɨ Israel miyamɨnaa igaajaqui. Mɨɨro jaanɨ amɨɨhaifeeneri ujulleecɨnɨɨbo buheeteuhi Cristo Jesu Nazareoobo momofeenedɨ amɨɨhai metetecuuboco Moocaani guijevefañotɨ ubuheetesuubofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jaabo diibo Jesu guiisibaco amɨɨhai iijano eetavomɨnaa mɨtɨhɨsumoro magañɨɨubo aivo iimimañovɨ iminifutucuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jaamaño sififeenedɨ taaja chahahi; niquejeguiinovɨ simomo miyamɨnaafeenevɨ chahahi tomomofeenedɨ mataajajimomo, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jaamɨsi igototɨmɨsi Moocaanitɨ ihiimaaunoco uguubuumoro, bu aamenefaño icautɨrumɨsi sihidɨ agaajaunoco iicaneri aivojɨto eheetyeumoro gaajauhi Jesuma iicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jaanomaryo ɨɨgotɨɨboco ubuheesuubo diitɨsifeeneri julleecɨnɨuhi. Jaamaño mɨllɨ nuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jaamoro Pedromɨsico ifeenetɨ galluumo diitɨsi ofoonobuuna iinoro toonotɨ iimaacasiqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jaamoro noocasihicaumo: ¿Mɨllɨ jaamɨsico momoonɨji? Famooro Jerusale miyamɨnaa gaajacuhi sihidɨ ejeevano mityaco diitɨsi omoonɨnoco. Jaanoco ¿mɨllɨ bu mutuunamaaijirahi? ");
INSERT INTO bmrNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jaarunofaño paryɨ miyamɨnaafaño tobogo ɨfetedino masɨɨ diitɨsico mɨhɨɨbaqui. Jisumitɨro diibo Jesu momofañodɨ miyamɨnaaco mɨjɨɨbeguedino. Musuufenɨtɨhachiijɨ amɨɨsico momoonɨji, noomoro, noocasiumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jaamoro diitɨsico ocoovaumoro nuumo: Jisumitɨro saatohobaco mɨjɨɨbugucudino miyamɨnaaco diibo Jesu momofañodɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Jaarunaa Pedromɨsi diitoco iimusuuhi: Eneecata mehesamaaimoro monoo; ¿Naa imijiruno miyamɨnaa iijɨco: Jii, monoomoro, Moocaani iijɨco magañɨɨno? ");
INSERT INTO bmrNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","¿Mɨllɨ bu jɨɨbogotɨmɨsi mihicajirahi mahatyɨmeumɨsiro muguubuunoco? noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jaanegui aivojɨto diitɨsico sihidɨ ɨhɨɨbaumoro tɨcovono suufenɨuhi mɨllɨtɨ bu diitɨsico moonɨjirumo paryɨ miyamɨnaa Moocaanico imehicauhi diitɨsi omoonɨhicaunotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jaabo diitɨsi ubuheesuubo ficabano icauhi miimɨsiicɨ tɨcovovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedromɨsico isinaayuumɨsi fuuhi inahabonɨmɨnaajaago. Jaamɨsiro diitoco jɨɨbuguumɨsi sacerdotemɨ aivojɨto, quillahuto icamo diitɨsico unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jaanoco uguubuumoro sabadɨro famooro Moocaanico nuuhi: Moocaani Mohaivojɨɨbo, ɨɨjoho paryɨ niquejeque, jiinɨjeque, muuaico icano fanooco ifiivusuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ɨɨjoho Digaijafeenedɨ mootadi dijeecɨvomɨnaafi Davidfeenedɨ nuuhi: ¿Collɨhi cuumimɨnaa Moocaanijaa cajuruuvehi? ¿Jaamoro miyamɨnaa sɨcamañooco esamaaihi? ");
INSERT INTO bmrNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jiinɨjemɨnaa aivojɨto gañiivehi, bu cuumimɨnaa aivojɨto sahɨ igaivehi Moocaanihallɨvɨ, bu Cristohallɨvɨ icano, nuubo David. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Jaano miyaano. Mɨɨro Herode, Poncio Pilato icamɨsi jiicuumivɨ igaivuuhi siicuumijeotoma, israelmɨma icano iimiibo daachi Jesuco ɨɨjoho Moocaani ijeevadɨ ificuubohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jaamo tollɨ moonɨumo ɨɨjoho Moocaani edeesamaaiuboro: Jillɨ icajiibo, nooboro unuucuubadɨ diiboco moonɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jaaneguiiha ɨɨjoho Moocaani idiicaabo, jino dijeecɨvomɨnaaco omoonɨgonoco meecɨ. Jaaboro mɨɨhaico daamusu igototɨmo diijɨco miyamɨnaaco mɨjɨɨbeguequi, bu ");
INSERT INTO bmrNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","jaamoro dihuse mityari iguihuvamoco mubuheesuqui, bu ɨɨfusuco ajabafiiranehejeque momoonɨqui iimiibo daachi Jesu momofeenedɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jillɨ iimaaumoro llɨɨvɨmaacaro tomaño diito iigaicɨnɨumaño sefano maryɨbauhi. Jaasumiro paryɨ famoojeebɨɨfañoro Moocaani Gaija gahafuuhi. Jaamoro nucufeguetɨmo Moocaani jɨɨbogoco jɨɨbeguehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jaasumi sihidɨ Cristoco imiyaavuguumo jeebɨɨno sabadɨro icahicauhi, bu sabadɨro ihesamaajene jeevahicauhi icano, bu saatohoneheje iino icaruno fameedirehicau. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jaanaa minɨsumɨnaa sihidɨ Moocaani mityari Jesu ubuheeteunoco jɨɨbeguehicauhi. Jaamo Moocaani imihuseri jinejetɨ cuujɨvaachutɨmo icahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Diitofeene siinotɨ ucuujɨvaachuboba chahahicauhi. Iijanoma ijiinɨjenema iicadɨmo anaajemere nɨhɨbamɨco ɨsɨvamoro minɨsumɨnaaco acɨvahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jaanoco ɨfocasihicaumo ucuujɨvaachudɨneheje. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jaanaaca bu Jose icaruuboco minɨsumɨnaa Bernabetɨ omomonɨubo jacusumɨnaafi eneejiruno Levitamɨnaafi Chipre onoochugaivɨ ifiivuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jaabo ijiinɨjeque anaajeuno nɨhɨbamɨco ɨsɨvauboro minɨsumɨnaaco acɨvauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jaanaa saafi Anania onoobo, Safira onoogo mogaima ijiinɨjeque anaajeumɨsiro ");
INSERT INTO bmrNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","samañooco ɨɨcɨumɨsiro samañoonoco minɨsumɨnaajaago satyuuhi fanooro iicahɨvɨbadɨ. Jaanoco mogai gaajauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jaanegui Pedro diiboco nuuhi: Anania, ¿collɨhi Satanas dijeebɨɨfaño jɨcafetehi Moocaani Gaijaco ibañɨsuqui? ¿Jaaboro diijiinɨjeque anaajene nɨhɨbamɨco samañoonoco dɨɨcɨqui? ");
INSERT INTO bmrNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Nacu diije jiinɨje icahinɨtɨhi? Bu jaajeque anaajecuuno, diino inɨhɨbamɨ. ¿Collɨhi dijeebɨɨfaño deesamaaihi tollɨ omoonɨnoco? Miyamɨnaaco bañɨsutɨhi. Moocaanico bañɨsuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Unuunoco Anania uguubuuboro baavɨ aacutuuboro chuumuubo. Jaanoco paryɨ miyamɨnaa agaajaumoro sihidɨ iguiumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jaaboco sɨcafe iminɨumoro satyuuhi icɨɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jaanobuunatɨ minoocɨ, sano ɨdɨɨno nɨhɨba oovobuunatɨ mogai fuuhi aijɨ tollɨ iicaunoco gaajatɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jaagoco Pedro nuuhi: Uco dɨɨbogo, ¿naa miya tonoodɨneri amɨɨsi jiinɨjeque manaajehinɨhi? nooboro. Jaanegui diigo: Jɨɨhɨ, tonoodɨneri, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Jaanegui Pedro nuuhi: ¿Collɨhi sabadɨro mihicamɨsiro Moocaani Gaijaco mɨnɨsujirahi? Oono jahisi gasecuumo ditajeque ɨɨcɨɨjeme. Jaamo tollɨro ɨco cɨɨteji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jaasumiro diigo acutuugoro chuumucuuhi Pedroguiino. Jaamo sɨcafe faño agaseumo atyɨmeuhi diigo chuumucuugoco. Jaagoco asatyumoro itaje cojɨvɨ cɨɨjeumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jaanoco Moocaani iijamɨnaa, bu sihidɨ miyamɨnaa icano agaajaumoro sihidɨ iguiumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jaamo minɨsumɨnaafeenedɨ sihidɨ ejeevano ɨɨfusu ajabafiirano moonɨcafetehicauhi miyamɨnaafeenevɨ. Jaamoro igaivehicaumo Salomon Portal onoomañovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jaarunaa saatohoba minɨsumɨnaavɨ fiitɨvehicautɨhi. Jaarumo famooro miyamɨnaa diitoco gaijɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jaamo sihidɨ miyamɨnaa Moocaanico miyaaveguehicauhi gaifiimɨ, gaigoomɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jaamoro iguihuvamehejeque jɨɨhaiñojɨninovɨ ficuhicaumo cɨgaiijenefaño, sɨucɨnɨtajefaño icano Pedro tomañodɨ afatyoobo ɨjɨ ihallɨdɨ afatyeneri ibuheequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jaabadɨro uufocoo cuuminooto Jerusalejaa saahicauhi iguihuvamehejeque, emeimɨvatomehejeque icano ɨsɨvaumo. Jaamoco paryɨ buheesuhicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jaanoma iicamo sacerdotemɨ aivojɨɨboma saduceomɨoto iicamo diitoco sihidɨ jɨɨheveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jaamoro minɨsumɨnaaco agaayɨcɨumoro cɨvojafaño ficuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Jaarumoco Moocaani toomomɨnaafi fucu iguhuganoco afaayɨuboro diitoco iinusuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Jaaboro diitoco nuubo: Mofoo. Jaamoro Moocaani iijafaño mujulleevetemere miyamɨnaaco mɨjɨɨbogo Cristo fiivoco aacɨnoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jaanegui seseevedɨ fucuro templojafaño ufuumoro miyamɨnaaco jɨɨbeguehicaumo. Jaanohachuta sacerdotemɨ aivojɨɨbo diiboma iicaumoma, igaiyɨɨcɨumo fagomɨnaaco, paryɨ Israel cuumimɨnaa quillahutoco icamoco. Jaamoro jɨɨbogomɨnaaco cuuhuvaumo cɨvojafañotɨ isɨvaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Jaanegui sisɨmɨnaa ufuurumo sɨcaijaco emeecɨjeumoro ijɨɨbogoma saauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Cɨvoja cuhufono fabaacɨnɨjaco memeecɨjehi ɨmegari paryɨ itoomomɨnaa icarahi icano. Jaadɨ mafaayɨcɨmoro fañoco memeecɨrumo mɨɨhaiñoobaco mahatyɨmetɨhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jaanoco sacerdotemɨ aivojɨɨbo, temploja toomomɨnaa aivojɨɨbo, paryɨɨcɨno sacerdotemɨ icamo uguubumoro igutuuhi. Jaamoro noocasiumo: ¿Mɨhachuta fɨne jino jillɨ feeji? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jaanaaca saafi agaseuboro diitoco noovauhi: Amɨɨhai cɨvojafaño mificuhinɨmo Moocaani iijafaño icahi miyamɨnaaco jɨɨbogomo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jaanegui toomomɨnaa aivojɨɨbo isisɨmɨnaama ufuuboro diitoco sɨvauhi, mɨllɨ moonɨtɨɨbo, miyamɨnaaco iiguimoro diitohallɨtɨ guiisiri diitoco ahaamɨujiruneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jaamoco ɨsɨvaumoro gasesuumo fagomɨnaa ɨmefeenevɨ. Jaanoco sacerdotemɨ aivojɨɨbo nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Amɨɨhaico du aivo imino mafaguuhi tomomotɨ mɨjɨɨbeguedino, noomoro. Jaano icanaaca aivo magahafusucuuhi paryɨ Jerusale cuumico amɨɨhai jɨɨbegueri. Jaamoro mohallɨvɨ majavucarujirahi diibo Jesu tɨɨjohoco agañɨɨumoro agaicaaunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jaanegui Pedroma famooro iimusuuhi: ¿Mɨllɨ bu Moocaani iijɨco magañɨɨmoro miyamɨnaa iijɨco: Jii, meneejirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mɨɨro mootadi imiyaavuguubo Moocaani buheetesuuhi Jesuco amɨɨhai magaicaaumoro ɨmohobujevɨ metetecuuboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jaaboco Moocaani caamo imiyanaagonovɨ ficuuhi Aivojɨɨbotɨ Taajasumɨnaafitɨ Israel cuumimɨnaa diibofeenedɨ iimitɨco ijeevesuqui. Jaabo diito imitɨco ibuusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jaano gaajamɨnaa mɨɨhai tollɨro Moocaani Gaija gaajamɨnaafi. Jaaboco Moocaani acɨhi diiboco imiyaavogomoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Unuunoco fagomɨnaa, quillahuto icamo uguubuumoro sihidɨ diitojaa sɨfiiratuumo. Jaamoro diitoco gaicaaujirumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jaarunaa diito aivojɨtofeene icaubo saafi fariseoobo Gamaliel onoobo Moise tajɨɨba jɨɨbogomɨnaa aivojɨɨbo paryɨ miyamɨnaa agaijɨhicaubo. Jaabo diitofeenetɨ ujulleeveuboro iminɨsumɨnaaco diitofeenetɨ buhɨgovɨ galluubo jihachutagayɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jaaboro ihaivojɨtoco nuubo: Israel gaifiimɨ, mehesɨcɨnɨ jito gaifiimɨco momoonɨjinoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Eneecau bu mehesafoto amɨɨhai, mɨɨro safoono Teuda onoobo agañiivuuboro nuuhi: Uujoho aivo sihidɨ jeevahi, nooboro. Jaaboma minifutuumo cuatro cientodɨmova. Jaarumo paryɨ finɨuhi diiboco agaicaaunobuunatɨ imiyamɨnaa paryɨ gavaranamaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jaanobuunatɨ miyamɨnaa momonoco acaatɨnɨusumi bu gañiivuubo Juda galileaoobo. Jaaboma sihidɨ minifutuumo. Jaaboco agaicaaunobuunatɨ tollɨro diibo dojɨcutɨ efeehicaumo gavaranamaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jaanegui amɨɨhaico neehi: Diitoco mejeevesu. Jaamoro mɨllɨ momoonɨdino. Jino miyamɨnaa iijɨcoro omoonɨno iicahachiijɨ finɨjino. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Jaanotɨ Moocaani iijɨ iicahachiijɨ amɨɨhai mifinɨsujitɨhi. Mehesɨcɨnɨ, Moocaanimaryo momoonɨcasidino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jaanoco famooro miyaavuguuhi. Jaamoro minɨsumɨnaaco ucuuhuvaumoro jillɨ diitoco aamɨuhi. Jaamoro siino Jesu momofeenedɨ mɨjɨɨbeguedino, noomoro diitoco suufenɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jaamo minɨsumɨnaa aivojɨtofeenetɨ imo imo iinuuhi Moocaani diitoco agaijɨɨboro imitɨno covamomovaumo Cristo momohallɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jaamoro fafucuvaacɨvɨro suufenɨtɨmo jɨɨbogomoro iimaahicaumo Jesucristotɨ Moocaani iijafaño, bu iijanofaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jaasumi imiyaavogomo sihidɨ guiraatomoro feehicauhi. Jaamotɨ saatoho griegomɨ iijɨri ihiimaamo judiomɨ iijɨri iimaamoditɨ ɨsɨfiiratuumoro noocasiuhi: Mofibaijɨtoco imino moonɨhicatɨmo amachusumi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jaanegui motɨhaitɨ miimɨsiicɨ ɨdɨɨmo minɨsumɨnaa iicaumo, paryɨ miyaavogomɨnaaco iigaiyɨɨcɨumoro nuuhi: Imijitɨruno mɨɨhai Moocaani iijɨco mɨjɨɨbogonoco mejeevesumoro machutaaco mahacɨno. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jaaneguiiha fañɨ, amɨɨhaifeenetɨ iimihusemetɨ mɨhɨcɨ sahuse juugahusetɨ miimɨsiicɨ ɨdɨɨno Moocaani Gaija ijeebɨɨfaño agahafɨcɨnɨmotɨ. Jaamoro toonofa mificu ijeecɨvequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jaanotɨ mɨɨhai Moocaanima iimaamoro mɨjɨɨbegueji Moocaani iijɨco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jaanoco paryɨ iimuguumoro ɨcɨumo Esteba onooboco ijeebɨɨfaño miyaavogo, Moocaani Gaija icano agahafɨcɨnɨɨboco, bu Felipeque, Procoroco, Nicanoroco, Tiomooco, Parmenaco, Nicolo antioquiaobo, judiomɨ iijɨco agaayɨcɨuboco icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jaamoco sɨvaumo minɨsumɨnaajaago. Jaamohallɨvɨ ihuseneque ificuumoro Moocaanima iimaaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jaanaa Moocaani iijɨ janaanɨcɨvɨro jusinoro feehicauhi. Jaaneri Jerusalevɨ sihidɨ guiraatehicaumo miyaavogomɨnaa tollɨro sihidɨ judiomɨtɨ sacerdotemɨ Cristoco gaayɨcɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebafaño sihidɨ Moocaani mitya icahicauhi sihidɨ imiyaavogomaño Moocaani noojɨri sihidɨ mityanoco miyamɨnaafeenevɨ moonɨhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jaanaa sinagogaja momo Taajamɨnaaja onooja. Taajaoto cirenemɨnaa, bu alejandriamɨnaa, Cilicia jiinɨjemɨnaa, Asia jiinɨjemɨnaa icamo tɨcovauhi Estebama ejenaaucasiumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Jaarumo diibovɨ ɨfetehicautɨhi Moocaani Gaija diiboco sihidɨ gaajaco aacɨneri ihiimaahicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jaanoma iicamo iimitɨmoco tajɨɨbaumo ibañɨqui: Mɨɨhai muguubuuhi Moisetɨ, Moocaanitɨ icano imitɨno ihiimaaboco, noomoro ineequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jillɨtɨ Estebahallɨvɨ miyamɨnaaco sɨfiiratusumo quillahutoco, caatɨnɨmɨnaaco icano. Jaamoro asaaumoro diiboco agaayɨcɨumoro satyuumo fagomɨnaa ɨmega. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jaamoro diibohallɨvɨ saatohoco ficuuhi sɨcamañooco ibañɨqui: Jaanɨ aivo suufenɨhicatɨhi Moocaani iija templojatɨ, Moise tajɨɨbatɨ icano iminootɨno ihiimaabo. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jaabadɨrova diibo Jesu Nazareoobo toojaco ifinɨsuuboro mɨɨhaico Moise atajɨɨbauno mojeevamaajequeva buunanɨjiibo onoonoco muguubuhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jaanegui paryɨ fagomɨnaa Estebaco emeecɨumo atyɨmeuhi ihɨmeque Moocaani toomomɨnaafi ɨmebadɨ jeevahɨmeque. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jaanegui sacerdotemɨ aivojɨɨbo Estebaco dilluuhi: ¿Naava miyaano paryɨ jino diito onoono? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jaanegui diibo iimusuuhi: Amɨɨhai agaijɨno nahabomɨ, bu amɨɨhai caanimɨhai icamo, uco muguubu. Mɨɨro Moocaani ihaivojɨma buhugaavuuhi Mootadi Abrahamvɨ Mesopotamia jiinɨjeri iicausumi Haran jiinɨjevɨ fuutɨbaacaro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Jaabo diiboco nuuhi: Diijiinɨjeque deevesu paryɨ diyotoma. Jaaboro difo ɨco uujoho ɨjɨɨbeguejino jiinɨjejaagovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jaaneguiiha Abraham fuuhi Caldea jiinɨjetɨ. Jaaboro icatuubo Haran jiinɨjevɨ jahɨ caani chuumuuhi. Jaadɨ Moocaani Abrahamco sɨvauhi jino jiinɨjevɨ jino amɨɨhai jisu mihicajevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Jaaruuboco jinejebatɨ acɨutɨɨbo jiinɨjebaco itɨhaico ificujirumañobaco. Jaaruubo diiboco acɨguuhi iguijevenebuuna diseemedi iicaqui, nooboro. Jaarunaa tusumi Abraham iseemenebama chahaunaaca ");
INSERT INTO bmrNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Moocaani diiboco nuuhi: Diiyaachimɨhai sita jiinɨjehallɨvɨ icaji sitafeenevɨ. Jaamoco jɨjuvusujimo. Jaamoro imitɨno moonɨjimo cuatro cientodɨ ficabava tɨcovovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jaaboro bu nuubo Moocaani: Jaaru jiinɨjemɨnaaco uujoho moonɨji diitoco ɨjɨjuvusu jiinɨjeque. Jaadɨ tahɨgotɨ asaamoro uco jeecɨvejimo jimañovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Moocaani iijɨco acɨuhi Abrahamco iimeeheque iquitɨcɨqui Moocaani unuubadɨ. Jaaneguiiha Abraham Isaaco eseemevausumi iimeeheque quitɨcɨubo juugahusetɨ mifucucɨ, safucu icanotɨ. Jaabadɨro bu Isaac moonɨuhi Jacobco eseemevausumi. Jaabadɨro Jacob moonɨuhi iseemeque Israel cuumiva motɨhaitɨ miicuumicɨdɨmo iicajimo caanimɨhaico. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jaamo diito Jacob seeme moheedete iicamo inahabo Joseque jɨɨheveuhi. Jaamoro sitaaco naajeumo. Jaaboco Egipto jiinɨjevɨ satyuumo. Jaaruuboma Moocaani icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Jaaboro diiboco ihɨdaasutɨ ataajasuuboro sihidɨ diiboco gaajatɨ acɨuhi. Jaanoma iicaubo Egipto aivojɨɨbo diiboco sihidɨ agaijɨuboro Egipto aivojɨɨbotɨ ficuuhi, tollɨro bu iija aivojɨɨbotɨ ficuuhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Jaanobuunatɨ paryɨ ajeba icauhi Egipto jiinɨjevɨ, Canaan jiinɨjevɨ icano. Jaaneri moheedetemɨhai ɨdaasuno machutabama chahauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jaanaa Jacob guubuuhi Egiptovɨ machutaaco ucuuhunɨuno iicaunoco. Jaaboro iseemeque tahɨ galluubo moheedetemɨhai iicaumoco jillɨtɨ fuumo tahɨgo aivo itɨconɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jaanohallɨvɨ ufuumovɨ Jose inahabomɨvɨ ihɨmeque imino jafenɨuhi. Jaanotɨ jari Egipto aivojɨɨbo gaajauhi Jose yotoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jaanobuunatɨ Jose caanico cuuhuvauhi paryɨ famooro iyotoma setenta y cincodɨmoma. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jillɨtɨ Jacob icatuuhi Egipto jiinɨjevɨ jahɨgo guijeveubo. Jahɨ tollɨro moheedete paryɨ guijeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jaamo bacɨnoco buunatɨ asatyumoro cɨɨtuumo Siquem onoomañovɨ Abraham Hamor seemetɨ nɨhɨbamɨri anaajeucɨɨhojɨfaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Jaanaa Moocaani Abrahamco unuuno ifiitɨvucuudɨ Egiptovɨ Israel cuumi sihidɨro ifiivuumo guiraatucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jaasumi Egiptovɨ bohaivojɨɨbo icauhi Joseque agaajautɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jaabo muucuumiotoco abañɨuboro ɨdaasuno moonɨuhi moheedeteque atajɨɨbaubo iseemeque ijeevesuqui bohono ifiivomo iguijevequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jaasumi Moise fiivuuhi. Jaabo Moocaanidi ovosɨɨuhi. Jaaboco caanimɨ jaahe tuumuuhi minɨhɨbacɨ, sanɨhɨba icanohachuta. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jaasumi ejeevesuuboco Egipto aivojɨɨbo aicɨgai aatyɨmeugoro ɨɨcɨuboco fiivusuuhi iseemenebadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jaamaño Moiseque egiptomɨnaa paryɨ agaajanoco jɨɨbuguumo. Jaamaño mityano ihiimaaboro icahicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Jaabo cuarentadɨ ficabava iicacuudɨ imogooboro fuubo iyoto israelmɨnaaco emeecɨtoobo. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jahɨ jaabo atyɨmeuhi saafi egiptomɨnaafi Israel cuumiooboco ɨdaasuno omoonɨunoco. Jaabohallɨtɨ Moise ijaadaco ihɨcɨqui diiboco gaicaauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Jaabo esamaaihicauhi: Tayoto israelmɨnaa fɨne gaajacuumo uujohofeenedɨ Moocaani diitoco ataajasujinoco, nooboro. Jaarunoco iyoto gaajacɨutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jaano seseevedɨ Moise atyɨmeuhi samɨsi Israel cuumiotɨsi omoonɨcasiunoco. Jaamɨsico faguubo: ¿Collɨhi jaamɨsi samɨsiro mahamocasihi musuufenɨcasi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jaanegui inahaboco ahaamɨubo Moiseque ichimucaruuboro nuuhi: ¿Mɨɨjoho ɨco mohallɨvɨ aivojɨɨbotɨ, fagomɨnaafitɨ icano ficuuhi? ");
INSERT INTO bmrNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Nacu uco gaicaaujirahi iijɨ egipcioco agaicaauhinɨbadɨ? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Jillɨ diiboco onoonoco uguubuuboro Moise gaauhi. Jaaboro fuubo Madia jiinɨjevɨ. Jahɨ miseecɨco gaifiimɨsico seemevaubo siicuumifeenevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Jaabovɨ cuarentadɨ ficabavabuunatɨ sɨcaihɨgovɨ Sinai gajɨ fiitɨno Moocaani toomomɨnaafi jafeveuhi cɨɨjɨgaiguiihu ɨmohogayɨhallɨdɨ jɨganofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jaanoco aatyɨmeuboro Moise jabafiituuhi. Jaaboro faño imino ihatyɨmequi ifiitɨvuubo guubuuhi Moocaani icooco: ");
INSERT INTO bmrNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Uujoho Moocaani, dihedeete Abraham, Isaac, Jacob icamo uco ejeecɨvuubo onoonoco. Jaaneri Moise sihidɨ veveveve igutuuboro meecɨutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jaaboco Moocaani nuuhi: Ditɨhaipaajeque dujuuvo jino uujoho Moocaani iicamaño imino jiinɨje. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Uujoho atyɨmecuuhi taacuumimɨnaa ɨdaasuno Egiptovɨ iicanoco ɨdaasuno acanɨfonoco guubuucuuhi. Jaanegui niitehi diitoco taajasuqui. Jaanegui difo ɨco Egiptovɨ galluuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moiseque diito ɨtɨhɨsuumoro: ¿Mɨɨjoho ɨco aivojɨɨbotɨ, fagomɨnaafitɨ icano mohallɨvɨ ficuuhi? unuuboco Moocaani galluuhi aivojɨɨbotɨ, taajasumɨnaafitɨ, Moocaani toomomɨnaafi ɨmohogayɨhallɨdɨ cɨɨjɨgaiguiihu jɨganoco aatyɨmeunofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jaabo Moise Egiptotɨ moheedeteque iinusuuhi sihidɨ ejeevano mityaco Egipto jiinɨjevɨ Tɨfai Muuaifeenevɨ omoonɨuboro. Tollɨro sɨcaihɨgofeenevɨ cuarentadɨ ficabava tɨcovovɨ moonɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jaabo diiboro Moise israelmɨco nuuhi: Moocaani galluuji amɨɨhaidi iimaamɨnaafico amɨɨhai nahabomɨfeenetɨ uco iicabadɨ. Jaaboco: Jii, meneeji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jaabo Moise sɨcaihɨgofeenevɨ igaiyɨɨcɨumofeeneri iicaubo. Sinai gajɨvɨ Moocaani toomomɨnaafi diiboma ihiimaaubo moheedetefeeneri iicaubo. Jaabo fiivo iimaaco mɨɨhaidi agaayɨcɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Jaaruuboco moheedete: Miyaano, nootɨmo Moocaanico imuguutɨmo. Jaamoro ijeebɨɨnofañodɨ imuguumo Egiptovɨ dojɨcuvɨro uuminoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jaamoro Aaronco nuumo: Mihimeguehi mɨɨhaidi diosmɨco edeetavonoco mohɨmega isɨɨguequi. Magaajatɨhi mɨllɨhacho Moise mɨɨhaico Egipto jiinɨjetɨ ɨsɨvahinɨɨbo icahi, ");
INSERT INTO bmrNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","noomoro oroco ɨɨcɨumoro niivɨgai seemenetɨ eheetavuumoro asimɨco gaisiraicɨumo ihɨjɨnɨta jeecɨvotɨ. Jaamoro diibohallɨvɨ imo imo icaumo ihuse eetavotahallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jaanoma iicaubo Moocaani diitotɨ buhɨgovɨ minifutuuhi. Jaaboro diitoco niquejeo meecɨrɨcoro jeecɨvusuubo. Jillɨ Moocaani iimaamɨnaa aamefaño noocɨnɨno: ¿Nacu amɨɨhai Israel miyamɨnaa uco mejeecɨvequi asimɨco magaisiraicɨuhi cuarentadɨ ficabava tɨcovovɨ sɨcaihɨgovɨ? ");
INSERT INTO bmrNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tollɨ icatɨno. Jillɨ Moloc onooboco dios noomoro, magaayɨcɨuhi. Tollɨro Refan onoobo meecɨrɨgaico magaayɨcɨuhi amɨɨhairyo mɨhɨjɨnɨnehejeque mejeecɨvehicauhi. Jaanoma iicaabo uujoho amɨɨhaico amɨɨhai jiinɨjetɨ sihɨ tehesino gañɨɨji Babilonia janaanɨcɨvɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mɨɨro moheedete Egipto jiinɨjetɨ agaaumo Moocaani unuuneguiiha ijiinɨjejaagovɨ ɨmevaurumo sɨcaisituvɨro icahicaumo ɨɨgomoro. Jaamañeri Moocaani iijama iicaumo toojafaño tajɨɨba guiisiba bujeque ificuhicauja. Jaaja eetavocɨnɨuhi Moocaani Moiseque ɨɨfusuuboro: Jillɨ jei deetavo, unuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jaajaco moheedete gaayɨcɨuhi. Jaamoro Josuema ufuusumi satyuumo sita jiinɨjeneque udumɨtɨɨcɨtuusumi juvivuumo. Moocaani diito ɨmegatɨ agaasuumo jiinɨjeque. Jillɨ iicaunaa David fiivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jaabo David Moocaani ɨmefeenevɨ imihusene icauhi. Jaabo eedeebe Jacob Moocaanico miyaavuguuhi. Jaaneguiiha David Moocaani iijaco eetavuujiruubo Moocaani toojafaño iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Jaajaco Salomon eetavuuhi Moocaani iijaco. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Jaarunaa Moocaani caamovono iicaabo miyamɨnaa userio eetavotajafaño icatɨhi. Ihiimaamɨnaafi unuubadɨ: ");
INSERT INTO bmrNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Niqueje tagɨcɨnɨta jiinɨje tatyɨhai jaguisɨsuta. ¿Jineje iijaco uudi meheetaveji? noobo Moocaani. ¿Nacu comañovɨ uujoho jaguisɨji? ");
INSERT INTO bmrNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Nacu uujoho tahuseri paryɨ fanoovaco eetavehinɨtɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jaano icanaaca amɨɨhai aivo jihovoto, amɨɨhai Moocaanico agaajatɨmobadɨ, cuhufono aivo amɨɨhai jeebɨɨ, amɨɨhai nohojɨno, amɨɨhai aivo Moocaani Gaijaco mejenaauhicahi. Amɨɨhai caanimɨhai iicaubadɨro amɨɨhai momoonɨhicahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Cojɨɨbogomɨnaafico nacu amɨɨhai edeete ɨdaasuno moonɨutɨhi? Diito gaisiraicɨuhi sɨɨcɨjetɨro diibo Iimiibo asaaujinoco ɨjɨɨbuguumoco. Jaabo jino diibo asaaboco amɨɨhai mahacɨmoro magaicaausuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Amɨɨhai Moocaani toomomɨnaafeenedɨ tajɨɨbaco magaayɨcɨhinɨrumo miyaano meneehicatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jillɨ diibo unuunoco uguubuumoro sihidɨ ɨsɨfiiratumoro igaiñooco ojɨsuumo Estebajaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Jaarunaa Estebafaño Moocaani Gaija gahafɨcɨnɨɨbo caamo niquejeque emeecɨubo Moocaani imi arɨcuco atyɨmeuhi Jesu Moocaani miyanaagueneri julleecɨnɨɨboma. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jaaboro nuuhi: ¡Memeecɨ! Niqueje afaayacafotonoco atyɨmehi Miyamɨnaafibadɨ Ifiivuubo Moocaani miyanaagonovɨ icaaboma, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Jaarunaa diito inohojɨnoco cuhufono afabaacuumoro sefano coovadiivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jaamoro diiboco ɨtɨgabaacuumoro tuucuumitɨ buhɨgovɨ satyuumo. Jaamoro saafi sɨcafefi Saulo onooboco igaachehunoco utuumusumoro diiboco guiisibaneri aamɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jaabo diiboco aamɨmaaca Moocaanima iimaaubo Esteba: Aivojɨɨbo Jesu, tagaijaco gaayɨcɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jaadɨ ememuɨɨvuuboro sefano gaihivuubo: Aivojɨɨbo, jino imitɨco diitohallɨvɨ ficuudino, nooboro guijevecuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jaamo diiboco agaicaaumofañodɨ Saulo icauhi. Jaamo tufucuro tɨcovacuumo Cristoco imiyaavogomoco ɨdaasuno omoonɨumo Jerusalevɨ. Jaanotɨ gaacɨnɨumo fahɨgovavɨ Judea cuumineri, Samaria cuumineri icano ɨdɨɨmoro minɨsumɨnaa fitafutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jaanaa Estebaco saatoho iimihusene gaifiimɨ ɨcɨumoro sihidɨ taaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jaano tɨcovo Saulo Cristoco imiyaavogomoco bucasiiboro feehicauhi iijanofañodɨ feehicaubo gaifiimɨ, gaigoomɨ icamoco ɨɨcɨɨboro cɨvojafaño isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jaanaa Jerusaletɨ ofoocɨnɨumo Moocaani iijɨco jɨɨbogomoro fahɨgovadɨ feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe Samaria jiinɨjeri iicacuumivɨ ufuuboro tuucuumivɨ Cristotɨ jɨɨbeguehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jaanoco sihidɨ miyamɨnaa igaivomoro guubunɨcɨhicaumo Felipe ɨjɨɨbogonoco, sihidɨ ejeevano mityaco omoonɨnoco atyɨmemere icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bu sihidɨ ɨjɨmɨma iicamoco buheetesuhicaubo. Jaamo ihɨjɨmɨ diitotɨ iinehicauhi gaibacɨnɨmoro, bu ifiino isifañɨɨneri ɨɨgotɨmehejeque buheesuhicaubo, itɨhaiño ifilluumoco buheesuhicaubo icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jillɨtɨ tuucuumio miyamɨnaa imo imo icahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jaanaa tollɨro tuucuumiri icaubo Simon onoobo apichumɨnaafi itɨconɨ ihapichuco omoonɨɨboro Samaria miyamɨnaaco abañɨhicaubo: Aivo uujoho miyaabo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jillɨtɨ famooro diiboco guubunɨcɨhicauhi ihaivojɨtejemaryo. Jaamoro neehicaumo: Jaanɨ aivo miyaano Moocaani mitya, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jaabo onoonoco miyaano neehicaumo sɨɨcɨjetɨro ihapichuri diitoco abañɨhicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Jaarunaa Moocaani jɨɨbogoco Cristotɨ Felipe diitoco ɨjɨɨbuguunegui gaifiimɨ, gaigoomɨ icamo imiyaavuguumoro nitɨsuquimaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jaanoma iicaubo Simon imiyaavuguuboro nitɨsuquimaaiuhi. Jaaboro Felipema gataavuubo sihidɨ ejeevano mityaco, bu ɨɨfusunoco icano omoonɨhicauneri ajabafiituuboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jaanoco minɨsumɨnaa Jerusaleri iicaumo guubuuhi samariamɨnaa Moocaani jɨɨbogoco agaayɨcɨunoco. Jaanegui tahɨ Pedro, Jua icamɨsico galluumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jaamɨsi tahɨ ɨɨfutuudɨ Moocaanima iimaaumɨsi Samaria miyamɨnaa Moocaani iijɨco imiyaavuguumohallɨvɨ, Moocaani Gaijaco diito igaayɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tusumihiica saatohoba diitotɨ Moocaani Gaijaco gaayɨcɨutɨhiica; jillɨro nitɨsuquimaaiumo Aivojɨɨbo Jesu momofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jaadɨ Pedromɨsi diitohallɨvɨ ihuseneque ificuuneri jari Moocaani Gaijaco gaayɨcɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jaanoco Simon apichumɨnaafi minɨsumɨnaa miyamɨnaahallɨvɨ ihuseque ificuuneri Moocaani Gaija iniitehicaunoco aatyɨmeuboro nɨhɨbamɨco acɨguubo: ");
INSERT INTO bmrNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Uco mahacɨ toono mityaco, tollɨro uujoho tahuseque saatohohallɨvɨ ificuumo Moocaani Gaijaco igaayɨcɨhicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jaanegui Pedro diiboco nuuhi: Paryɨ dinɨhɨbamɨma ɨɨjoho finɨ; Moocaani aacɨnoco nɨhɨbamɨri magaayɨcɨhi, neehi fɨne. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɨɨdi jino icatɨno jinofaño ɨɨjoho diicatɨhi. Moocaani ɨmefeene dijeebɨɨ tɨcovotɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Toono dihimitɨco deevesu. Jaaboro Moocaanico dillu toono dijeebɨɨfaño edeesamañoco ɨco buusujirubeheje. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mɨɨro uujoho ɨco ɨɨfɨnɨcɨhi aivo sihidɨ dihimitɨ faafañofaño idiicanoco, aivo imitɨfaño cuhufono isisɨcɨnɨcuunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jaanegui Simon apichumɨnaafi iimusuuhi: Moocaanima tahallɨvɨ mihiimaa. Toono uco monoonofaño ɨdaasuno icadino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jaadɨ Pedromɨsi Jesutɨ, Moocaani iijɨtɨ icano ihiimaahicaudɨ jɨɨbeguehicaumɨsi taajasuhiijɨco Samaria jiinɨje cuuminovɨ. Jaadɨ dojɨcuvɨro uumiumɨsi Jerusalejaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jaanobuunatɨ Felipeque Moocaani toomomɨnaafi nuuhi: Gañiivoobo, difo gadɨcɨɨbahachuta Jerusaletɨ sɨcaihɨgo Gasa onoomañodɨ ofoocɨnɨjɨri, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jaanegui Felipe agañiivooboro ufuubo atyɨmeuhi gaigooco agaajatɨɨbo etiopiaoboco; aivojɨgo tajɨɨbamɨnaafi Candace onoogo, etiopiamɨnaa aivojɨgo, nɨhɨbamɨ ficumɨnaafi Jerusalevɨ Moocaanima ihiimaaqui ufuubovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jaabo dojɨcuvɨro ijiinɨjejaago uhuumiubo ijeejɨmɨ meenegafaño gɨcɨnɨɨboro ɨɨfɨnɨcɨhicauhi Moocaani iimaamɨnaafi Isaia aameque. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jaanaa Moocaani Gaija Felipeque nuuhi: Fiitɨvo diibovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Jaanegui Felipe diibovɨ ifiitɨvuubo Isaia aameque ihiimaasunoco guubuuhi. Jaanegui diiboco dilluubo: ¿Naa gaajahi toono idiimaasunoco? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jaanegui diiboco iimusuubo: ¿Mɨɨjoho bu uco ɨjɨɨbegueneri gaajajirahi? nooboro Felipeque iicojɨvɨ coovaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jaano jillɨ toohaamefaño onoonoco ɨɨfɨnɨcɨɨboro feehicaubo, jillɨ noonoco: Ovejaco igaicaauqui iicanɨcɨbadɨ satyuumo; ajashu ovejaco ijeeneque iquitɨmoguiino iimaatɨɨbo iicanɨcɨbadɨ diibo iimaautɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Diiboco guiinonɨumo, miyaano iicatɨneri. Ifiico agaicaaumoro jiinɨjehallɨtɨ gañɨɨumo. ¿Jaabo iyaachimɨhaitɨ mɨɨjoho jɨɨbeguejirahi? onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jaaboro diibo ihetiopiaobo Felipeque dilluuhi: Uco dɨɨbogo. ¿Mɨɨditɨ jillɨ iimaaubo Moocaani iimaamɨnaafi, ifiitɨro nacu sifiitɨ? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jaanegui diibo ihiimaasumañotɨ Felipe tɨconɨuhi Jesutɨ diiboco ɨjɨɨbuguubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Jaamɨsi nɨfaihu iicaumañodɨ afatyuhɨ ihetiopiaobo Felipeque nuuhi: Jimaño nɨfaihu icahi fɨne uco nitɨjitɨrahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Jaanegui Felipe diiboco nuuhi: Paryɨ dijeebɨɨmaryo imiyaavogohachiijɨ, nooboro. Jaanegui diibo iimusuuhi: Miyaaveguehi Jesucristo Moocaani Achi iicanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jaanegui imeenegaco jullehacusuubo. Jaadɨ samɨsi teehifa iniituudɨ Felipe diiboco nitɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jaanaa iteehifañotɨ ihiinuudɨ Moocaani Gaija Felipeque satyuuhi. Jaaboco ihetiopiaobo siino atyɨmecuutɨhi jillɨ imo imo fuucuubo ijɨɨhairi. ");
INSERT INTO bmrNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jaanaa Felipeque Azoto onoomañovɨ atyɨmeumo. Jaabo fuuhi tuucuumijeri taajasubogoco jɨɨbogooboro Cesareavɨ ɨɨfutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jaanohachuta Saulo suufenɨtɨɨbo Jesuco imiyaavogomoco gaicaaugooboro feehicauhi. Jaaboro fuubo sacerdotemɨ aivojɨɨbojaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Diiboco aameneque acaatɨnɨɨboro ihacɨqui Damasca sinagogajamɨnaafico ihacɨteque. Jaaboro Jesu jɨɨbogo iijɨfañodɨ iicamoco gaigoomɨ, gaifiimɨ icamoco isisɨɨboro Jerusalevɨ cɨvojafaño isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jaabo ufuubo Damascatɨ fiitɨcuuruubaaca imimañobatɨ niquejefañotɨ diiboco achɨcɨuno. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jaaneri Saulo baavɨ aacutuubo guubuuhi niquejefañotɨ diiboco unuunoco: Saulo, Saulo, ¿collɨhi uco bucasihi? unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jaanegui Saulo iimusuuhi: ¿Mɨɨjoho nacu ɨɨjoho aivojɨɨbo? nooboro. Jaanegui diiboco iimusuuno: Uujoho diiboro Jesu ɨɨjoho uco ubucasiibo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jaanegui Saulo iimusuuhi: Aivojɨɨbo, ¿nacu mɨllɨ iicanoco diimeguehi? nooboro. Jaanegui diiboco nuuno: Gañiivoobo difo tuucuumijaago tahɨ ɨco ijɨɨbeguequi omoonɨjinoco, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jaaneri Sauloma ufuumo sihidɨ igutuuhi. Tollɨ onoonoco uguubuumoro jaarumo mɨɨhaiñoobaco atyɨmeutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jaadɨ Saulo baatɨ agañiivuudɨ emeecɨuruubo atyɨmecuutɨhi. Jaanegui diiboco ihusetɨ agaayɨcɨumoro Damascajaa satyuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jahɨ icaubo mifucucɨ, safucu ɨdɨɨno jinejebaco machutɨɨbo, adutɨɨbo, atyɨmetɨɨbo icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jaanaa Damascavɨ icaubo saafi Anania onoobo Cristoco imiyaaveguehicaubo. Jaabovɨ Jesu buhugaavuhi. ¡Anania! nooboro. Jaanegui diibo iimusuuhi: Juu icahi Aivojɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jaanegui Aivojɨɨbo diiboco nuuhi: Gañiivoobo difo jɨɨhai tɨcovojɨ onoojɨri. Jaaboro Juda iijafa foobo dillu Saulo tarsoobo Moocaanima ihiimaaboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Jaabo gaijafaño Anania onooboco atyɨmehi asaaboro ihuseque ifihallɨvɨ ificuuneri siino aatyɨmeneque, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jaanegui Anania nuuhi: Aivojɨɨbo, famoova uco diibotɨ jɨɨbeguehicahi paryɨ Jerusalevɨ ɨco imiyaavogomoco imitɨno omoonɨhicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Toonegui saabo juuga sacerdotemɨ aivojɨto iijɨma paryɨ dimomoco imiyaavogomoco isisɨqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Jaarunaa Jesu diiboco nuuhi: Difo, diiboco uujoho ɨɨcɨcuubo siijiinɨjemɨnaaco ihaivojɨtoco tollɨro israelmɨ icamoco taajɨco ijɨɨbeguequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Jaaboco uujoho gaajasuji tahallɨtɨ sihidɨ ɨdaasuno iicajinoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jaanegui Anania ufuuboro Saulo iicauhɨgo jɨcafutuubo. Jaaboro ihuseque ihallɨvɨ ificuuboro diiboco nuubo: Nahabo Saulo, Aivojɨɨbo Jesu ɨɨvɨ jɨɨhaivɨ asaahinɨsu ajafevehinɨɨbo uco dijaa galluuhi, jaabo siino daatyɨmehi, jaabo Moocaani Gaijaco gaayɨcɨhi icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jaasumiro Saulo aallɨɨfañotɨ aifuuno taavaabo meehebadɨ jeevano. Jaasumiro Saulo agañiivuuboro nitɨsuquimaaiubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jaadɨ jari siino amachuudɨ sefatuubo. Jaadɨ gueenejɨsuno icaubo Damascavɨ Cristoco imiyaavogomoma. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Jaasumitɨro Saulo jɨcafutuhi sinagogajanofaño ɨjɨɨbogoobo: Jesu Moocaani Achi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jaanoco paryɨ uguubuumo ajabafiitomoro neehicauhi: ¿Nacu jaanɨ icatɨɨbo Jerusalevɨ Jesu momoco imiyaavogomoco ɨdaasuno omoonɨhicaubo icatɨno? Mɨɨro tooneguiiha juu saahinɨɨbo jimañootoco isisɨɨboro sacerdotemɨ aivojɨtojaago isatyequi. noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Jaarunaa Saulo gaajano jɨɨbeguehicauhi Jesucristo iicanoco. Jaabo Damascavɨ iicamo judiomɨco ihiimaari mɨtasuhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jaanobuunatɨ goovacuutɨnotɨ sanoomɨro judiomɨ iimaacasiuhi Sauloco igaicaauqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Jaamoro fucuhachuta, cuujehachuta icano tuucuumi guhugaco casicuhicaumo diiboco igaicaauqui. Jaanoco Saulo gaajacɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jaanegui miyaavogomɨnaa jɨiibaifaño diiboco ɨjɨɨhacuumoro fucu tuucuumi mecuhallɨdɨ baavɨ iniitusuneri taajaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jaadɨ Saulo Jerusalevɨ ɨɨfutuudɨ tomaño miyaavogomɨnaama igataavequi moonɨuruubo. Jaarunaaca diiboco ñɨhicuguumo: Fɨne miyaavogomɨnaafi icatɨɨbehiica, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Jaarunaa Bernabe diiboco minɨsumɨnaajaa saatuuhi. Jaaboro diitoco jɨɨbuguubo Saulo jɨɨhaivɨ Cristoco aatyɨmeuboro uguubuunoco, Damascavɨ Cristotɨ ñɨhicugotɨɨbo ɨjɨɨbeguehicaunoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jaadɨ jari Saulo Jerusalevɨ ifitafutuudɨ diitoma gataavuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jaabo ñɨhicugotɨɨbo Jesucristotɨ iimaahicaubo. Judiomɨ, griego iijɨri ihiimaahicaumoma jenaaucasiiboro feehicaubo. Jaanoma iicamo diiboco gaicaauguumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jaanoco inahabomɨ agaajacɨumoro Sauloco satyuumo Cesareavɨ. Jaamañotɨ diiboco Tarsovɨ galluumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jaamaño faacuumivavɨ miyaavogomɨnaa famooro imino icacuuhi, judeaoto, galileaoto, samariaoto icamo quehecutomoro feehicauhi Moocaani ñɨhicufaño icamoro, Moocaani Gaija aamusuneri guiraatomoro feehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jaasumi Pedro inahabomɨco meecɨɨboro efeehicaubo ɨfutuuhi Lidavɨ, tomañeri iicamoco emeecɨtuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jahɨ atyɨmeubo Enea onooboco ifi iniinovaneri sahuse juugahusetɨ mificabacɨ, saficaba icano tɨcovovɨ ɨgotɨɨbo iicahicauboco. Jaabo icɨgaiijefañoro sɨucɨnɨɨboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jaaboco Pedro nuuhi: Enea Jesucristo ɨco buheesuhi, gañiivoobo dicɨgaiijeque dimibachu, nooboro. Jaasumiro Enea gañiivuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jaanoco paryɨ lidamɨnaa, saromɨnaa icamo aatyɨmeumoro iheedehiijɨco ejeevesuumoro Cristoco miyaavuguumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jaasumi Jope cuumivɨ icaugo Cristo miyaavogomɨnaago Tabita imomo iicagoco griegomɨ iijɨri Dorca eneehicaugo. Jaago imino miyamɨnaaco moonɨhicauhi ɨɨdaasumehejeque sinehejeque acɨhicaugo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jaasumi Dorca iguihuvaugo guijeveuhi. Jaagoco imino ejeesuumoro caamo iicamecufaño ficuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jaanaa Jope cuumi, Lida cuumitɨ fiitɨuhi. Jaacuumiri Pedro iicaunoco miyaavogomɨnaa uguubuumoro miimɨsiicɨco galluumo diibojaago ijɨɨbeguetequi: Jopevɨ goovano disaa, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jaanegui Pedro diitɨsima fuuhi. Jaabo ɨɨfutuudɨ Dorca ifi icahɨgovɨ diiboco satyumo. Jaabohallɨdɨ paryɨ fibaijɨto gaigoomɨ meecɨguuhi taamoro igaachehunoco Dorca ubuheeusumi diitedi eheetavehicaunoco ɨfusuhicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Jaanegui Pedro paryɨ famoocoro jahisi iinusuhi. Jaadɨ ememuɨɨvuuboro Moocaanima iimaaubo. Jaaboro diigo chuumuhuco emeecɨuboro nuuhi: Tabita gañiivo, nooboro. Jaasumiro emeecɨugo Pedroco aatyɨmeugoro casɨɨvuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jaanegui ihusetɨ diigoco agaayɨcɨuboro gañiiyɨcɨubo. Jaaboro inahabomɨ, bu fibaijɨto icamoco ocoovauboro ɨɨfusuubo buheecuugoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jaanoco paryɨ Jope cuumimɨnaa uguubumoro saatoho sihidɨ Cristoco miyaavuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jaadɨ Pedro tuucuumivɨ gueenene icauhi asimɨmeehene imibachumɨnaafi Simon onoobo iijafaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Jaanaa Cesarea cuumiri icaubo Cornelio onoobo italianomɨ Amocasimɨnaa onoomo aivojɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jaabo paryɨ iijamɨnaama Moocaani ñɨhicufaño icahicauhi. Jaabo sihidɨ nɨhɨbamɨco acɨhicaubo judiomɨguiiha ɨɨdaasumoco ihamusuqui. Jaabo saicɨno Moocaanima iimaahicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jaanaa safucu ɨmohonohallɨtɨ nɨhɨba iicaaberi gaijafaño imino atyɨmeubo Moocaani toomomɨnaafi diibojaa asaaunoco. Jaabo diiboco: ¡Cornelio! noovaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jaaneri Cornelio sihidɨ iigutuuboro diiboco ɨhɨɨfɨnɨcɨuboro dilluuhi: ¿Mɨllɨ Aivojɨɨbo? nooboro. Jaanegui itoomomɨnaafi diiboco nuuhi: Moocaanima idiimaahicanoco guubuucuubo, judiomɨ ɨɨdaasumoco adaamusuhicanoco gaajacuubo icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jaanegui gallu Jope cuumivɨ saatohotɨ Simon Pedroco ihɨcɨtequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Oono Simon onoobo asimɨmeehene imibachumɨnaafi iija muuaijɨniri iicajafaño iicaaboco. Jaabo ɨco jɨɨbegueji omoonɨjinoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jaanegui itoomomɨnaafi diiboma ihiimaauboro ufuunobuunatɨ Cornelio coovauhi saafi soldaomɨoboco Moocaani iijɨmɨnaafi inahabonɨmɨnaafico, bu miimɨsiicɨ iicojɨmɨnaatɨsima. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jaaboro diitoco imino ɨjɨɨbuguuboro Jopevɨ galluubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jaano seseevedɨ diito Jopetɨ fiitɨcuunaaca Pedro caamovɨ fuuhi iijahallɨvɨ gadɨcɨɨba Moocaanima ihiimaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jaaboco sihidɨ ajeba aivuuneguiiha imachuqui diibedi eheetavuumaaca gaijaco atyɨmeubo, ");
INSERT INTO bmrNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","niqueje afaayacafotonofañotɨ niituuno baavɨ gaachehubaryutyɨgababadɨ jeevano fahɨgovatɨ duujecɨnɨno. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Jaanofaño faaboho asimɨ icauhi igueenemeheje itɨhaiño iicameheje, faaboho joomɨ, faaboho jiinimomɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jaanaa Pedro guubuuhi niquejefañotɨ diiboco unuunoco: Pedro, gañiivohɨ diitotɨ gaicaaubo diidu, onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Jaanegui Pedro iimusuuhi: Chahano Aivojɨɨbo, uujoho duutatɨhi jihovonoco ɨɨdicunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Jaanegui siino diiboco nuuno: Moocaani: Imino, onoonoco ɨɨjoho: Ɨdicuno, needino, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mifoocɨ, safo icano iniituunoro caamo niquejefaño fuucuuno. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jaano esamaajeri Pedro: ¿Mɨllɨ fɨne eneejiruno? nooboro icaunaaca Cornelio agalluumo Simon iijaco dilluumoro ufuumo iguhugavɨ ɨfutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Jaamoro sefano dilluumo: ¿Naa jiijafaño Simon Pedro onoobo icahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Jaanaa Pedro gaijaco aatyɨmeuno esamaajeri icauboco Moocaani Gaija nuuhi: Meecɨ johono miimɨsiicɨ, saafi icamo ɨco guiinehi. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gañiivo. Jaaboro niitoobo bañɨmo nootɨɨbo diitoma difo. Uujoho diitoco agalluumo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jaanegui Pedro niituuhi baavɨ Cornelio agalluumojaago. Jaaboro diitoco nuubo: Uco amɨɨhai miguiinehi. ¿Jaamo jinejefiri masaahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jaanegui diiboco nuumo: Aivojɨɨbo Cornelio agalluuneguiiha. Imihuseebe Moocaani ñɨhicufa iicaabo. Jaaboco famooro judiomɨ agaijɨɨbo. Jaaboco Moocaani toomomɨnaafi nuuhi: Pedroco cuuhuva. Jaabo iijɨco guubuuhi, eneeneguiiha masaahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jaanegui Pedro diitoco jaahevesuuhi. Jaamo tufucu toono diiboma cɨgaumo. Jaano seseevedɨ Pedro diitoma fuuhi. Jaaboma saatoho inahabomɨ gataavuuhi Joperi iicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jaano seseevedɨ ɨɨfutuumo Cesareavɨ Cornelio iyotoma igataavomɨnaaco iigaiyɨɨcɨumoma diitoco utuumuuhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jaanaa Pedro Cornelio iijavɨ ɨɨfutuuhi. Jaaboco Cornelio idilluuboro iguiino memuɨɨvuubo Pedroco iimequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Jaarunaa Pedro diiboco gañiiyɨcɨuhi: Dulleeve, uujoho tollɨro ɨɨbadɨro miyamɨnaafi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jaaboma ihiimaaboro fañoojavɨ ufuubo atyɨmeuhi sihidɨ miyamɨnaa igaicɨnɨmoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jaanegui Pedro nuuhi: Amɨɨhairyo magaajahi sacerdotemɨ neefihi imijitɨruno judiomɨoobo siicuuornelio iijavɨ ɨɨfutuuhi. Jaaboco Cornelio idilluuboro iguiino memuɨɨvuubo miooboma agataavooboro diibo iijafa ofoono onoonɨcɨnoco. Jaarunofaño uco Moocaani jɨɨbeguehi sitaaco ɨdicumo mɨhɨnivamo needino, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jaaneguiiha amɨɨhai uco mucuuhuvanoco mɨllɨ nootɨɨbo saahi. ¿Jaamo jinejeguiiha uco mucuuhuvahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Jaanegui Cornelio iimusuuhi: Igueenemeheje fucuva mihicacuuhi jisumi nɨhɨba icaaberi jaahe machutɨɨbo iijɨcuuvɨ Moocaanima iimaanaaca uuvɨ jafevehinɨɨbo gaifi arɨcuchehufa jɨɨcɨnɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jaabo uco neehinɨhi: Cornelio, Moocaani guubuuhi idiimaanoco gaajacuubo ɨɨdaasumoco adaamusuhicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jaanegui gallu Jope cuumivɨ saatohotɨ Simon Pedroco ihɨcɨtequi asimeehene imibachumɨnaafi tollɨro Simon onoobo iija muuaijɨniri iicajafa icaaboco. Jaabo asaadɨ ɨɨma iimaajiibo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jaanegui galluuhi tusumiro ɨco ihɨcɨtequi. Jaabo imino saahi. Jaanegui jino famooro Moocaani ɨmefeene mihicahi. Moocaani ɨco atajɨɨbanoco mihimeguehi muguubunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jaanegui Pedro tɨconɨuhi nooboro: Jari jisu gaajahi Moocaani sabadɨro miyamɨnaaco agaijɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sabadɨro agaayɨcɨnoco fahɨgova miyamɨnaatɨ diiboco ɨñɨhicugomoro imino iicamoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mɨɨro Moocaani iimaauhi Israel cuumimɨnaaco sajeebɨɨ icano jɨɨbogoco ɨjɨɨbuguubo Jesucristofeenedɨ. Jaabo diibo famoo Aivojɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Amɨɨhairyo imino magaajacuuhi paryɨ judiomɨ jiinɨjevɨ iicaunoco. Mɨɨro Jua jɨɨbogooboro initɨhicaunobuunatɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Galileavɨ jillɨ tɨcovauno Moocaani Jesu Nazareooboco Gaijaco imityama acɨubo. Jaaneri feehicaubo imino moonɨɨboro iimitɨno ɨjɨma iicamoco taajasuuboro feehicaubo. Jillɨ moonɨɨboro feehicaubo Moocaani diiboma iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jaanoco mɨɨhai magaajahi Jesu Jerusale cuumifaño, paryɨ Judea jiinɨjevɨ icano omoonɨhicaunoco. Jaaboco agaicaaumoro ɨmohobujevɨ tetecuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jaaruuboco Moocaani buheetesuuhi mifucucɨ, safucu icanotɨ. Jaabo mɨɨhaivɨ jafeveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jaaruno famoovɨro jafevetɨɨbo mɨɨhaivɨro jafeveubo mɨɨhaico itɨconɨtɨro Moocaani toono gaajamɨnaatɨ ɨɨcɨumovɨ. Jaaboma mɨɨhai mamachumoro mahaduhicauhi iguijeveubo ubuheeteunobuunatɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jaabo mɨɨhaico galluuhi miyamɨnaaco mɨjɨɨbeguequi Moocaani diiboco iguijevemehallɨvɨ, ubuheemehallɨvɨ icano Aivojɨɨbotɨ ificuunoco mɨjɨɨbeguequi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tollɨro famooro sɨɨcɨjetɨro Moocaani iimaamɨnaa Jesutɨ iimaauhi: Paryɨ diiboco imiyaavogomo diibofeenedɨ taajaji, noomoro. Jaanoco Pedro nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro ihiimaaunaacaro Moocaani Gaija niituuhi paryɨ diibo jɨɨbogoco uguubunɨcɨumohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jaaneri sihidɨ jabafiituumo judio miyaavogomɨnaa Pedroma asaaumo, tollɨro judiomɨ icatɨrumoco, Moocaani Igaijaco aacɨuneri, ");
INSERT INTO bmrNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","bu tollɨro sijɨɨjeri ihiimaamoro Moocaanico imehicaumo icanoco uguubuumoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jaanegui Pedro nuuhi: Jaanegui, ¿mɨɨjoho bu collɨhi neejirahi nɨfaihuri nitɨratɨmo iicaqui mɨɨhaibadɨro bu Moocaani Gaijaco agaayɨcɨcuumo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jaanegui tajɨɨbaubo diito initɨsuquimaaiqui Jesucristo momofeenedɨ. Jaadɨ Pedroco ifiitɨunegui diitoma gueenejɨsuno icaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jaanaa saatoho minɨsumɨnaa, inahabomɨ icamo Judeari iicaumo guubuuhi tollɨro siicuumioto icarumo Moocaani jɨɨbogoco agaayɨcɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jaanaa Pedro Jerusalevɨ agaseuboco saatoho judiomɨ miyaavogomɨnaa ɨtɨhɨɨsuumoro, nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","¿Collɨhi judiomɨ icatɨmojaago edeeguejeebere diitoma machuhi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jaanegui Pedro diitoco jɨɨbuguuhi fanootɨro nijequevɨ tahɨ iicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Jillɨ nooboro: Uujoho Jope cuumivɨ iicahinɨsumi Moocaanima ihiimaahinɨɨbo atyɨmehinɨhi gaijafaño gaachehubaryutyɨgababadɨ jeevanoco fahɨgovatɨ duujecɨnɨno niquejefañotɨ tajaa iniitonoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Jaanegui imino atyɨmequi emeecɨɨbo atyɨmehinɨhi fanoo asimɨ igueenemeheje itɨhaiño iicamehejeque, ɨñɨhicufiimoco, jiinimomɨco, agahafomehejeque icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jaanaa niquejefañotɨ uco onoonoco guubuuhi: Pedro gañiivo. Jaaboro diitotɨ gaisiraicɨɨbo diidu, onoonoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Jaarunaa uujoho neehinɨhi: Chahano, Aivojɨɨbo, uujoho duutatɨhi jihovono ɨɨdicunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jaanegui niquejefañotɨ siino uco noono: Moocaani iimibachucuunoco ɨɨjoho: Ɨdicuno, needino, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jaanoro mifoocɨ, safo icano niituuhi. Jaanoro niquejefa siino fuucuuno. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Jaanaaca miimɨsiicɨ, saafi icamo ɨfutuuhi uujoho iicaujavɨ uco ɨɨcɨvamo Cesarea cuumitɨ agalluumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jaanegui Moocaani Gaija uco diitoma galluuhi bañɨgotɨɨbo difo, nooboro. Jaanegui sahuse juugahusetɨ saafi icamo uuma fuuhi. Jaamoma saafi iijafa majaaheveuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jaabo mɨɨhaico jɨɨbeguehi Moocaani toomomɨnaafico aatyɨmehinɨɨbo ujulleeveebere diiboco eneehinɨnoco: Saatohotɨ Jope cuumivɨ gallu Simon Pedro onooboco ihɨcɨtequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jaabo ɨco jɨɨbegueji diijamɨnaama ataajajinoco, nooboro eneehinɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Jaanegui uujoho ihiimaabo tɨcovahinɨnaacaro Moocaani Gaija diitohallɨvɨ niitehinɨhi itɨconɨ mɨɨhaihallɨvɨ iicaubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jaanotɨ uujoho esafetehinɨhi Jesu unuunoco: Miyaano Jua nɨfaihuri nitɨuhi. Jaanotɨ amɨɨhai minitɨcafeteji Moocaani Gaijari, unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mɨɨhai Aivojɨɨbo Jesucristoco mimiyaavuguusumi aacɨcuubadɨro diitoco aacɨcuunoco. Jaanegui uujoho miyamɨnaafiro, ¿mɨllɨ Moocaanico jenaaujirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jaanoco Jerusaleri iicaumo inahabomɨ uguubuumoro llɨɨvɨuhi. Jaamoro Moocaanico imuumo: Jaanegui tollɨro Moocaani siicuumioto icarumo iheedehifiico ejeevesumoco acɨhi ifinɨjitɨno ifiico, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Esteba onooboco agaicaaunotɨro saatoho miyaavogomɨnaaco ɨdaasuno omoonɨunotɨ sanoodɨmo gaacɨnɨuhi Feniciavɨ, Chiprevɨ, Antioquiavɨ icano. Jahɨ jaamo Moocaani iijɨco jɨɨbeguehicauhi saatohocoro judiomɨco sitaaco jɨɨbogotɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jaarunaa saatoho Chipre, Cirene icano miyaavogomɨnaa Antioquia cuumivɨ ɨɨfutuumo judiomɨ icatɨrumoco jɨɨbuguuhi Jesucristo Moocaani Achi jɨɨbogoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jaamoma Moocaani mitya icahicauhi. Jaamaño sihidɨ saatoho iheedehiijɨco ejeevesuumoro Aivojɨɨbo Jesuco miyaavuguumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jaanoco Jerusaleri iicaja Moocaani iijamɨnaa uguubuumoro Bernabeque galluumo Antioquiavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jaabo Bernabe ɨɨfutuubo atyɨmeuhi Moocaani imihuseri diito imino iicanoco. Jaaneri imo imo iminifutuuboro diitoco fajɨɨnɨubo sefano ijeebɨɨco omoonɨmoro Aivojɨɨbo Jesucristo iijɨfañoro iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Jaabo Bernabe imihuseebe Moocaani Gaija ijeebɨɨfa icaabo sihidɨ miyaavogoobo. Jaamaño sihidɨ miyamɨnaaco Jesucristodi ɨcɨhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Jaanobuunatɨ Bernabe fuuhi Tarso cuumivɨ Sauloco ɨɨcɨtuubo. Jaaboro Antioquiavɨ satyuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jahɨ Cristoco imiyaavuguumoma icaumɨsi saficaba Antioquiavɨ sihidɨ miyamɨnaaco jɨɨbogomɨsiro. Jaamañovɨ itɨconɨ Antioquiavɨ momonɨumo miyaavogomɨnaaco Cristotatɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jaasumi Moocaani iimaamɨnaa Jerusaletɨ fuumo Antioquiavɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jaanaa diitotɨ saafi Agabo onoobo inahabomɨfeenetɨ ujulleeveuboro Moocaani Gaija diiboco unuunoco nuubo: Fanoo jiinɨjevɨro aivo sihidɨ ajeba icaji, nooboro. Jaano icauhi aivojɨɨbo Claudio onoobo atajɨɨbausumi. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jaanegui Antioquiari iicau miyaavogomɨnaa esamaaiumoro inahabomɨ Judeari iicaumoja nɨhɨbamɨco galluumo inehejema iicaudɨmo aacɨunehejeque icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tollɨro bu Moocaani iija quillahutojaago galluumo nɨhɨbamɨco Bernabe, Saulo icamɨsima. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jaasumi aivojɨɨbo Herode tɨconɨuhi Cristotaco ɨdaasuno omoonɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jua nahabo Jacooboco aamɨgari gaicaausuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jaano judiomɨdi iimiunegui Herode Pedroco sisɨsuubo Pascua jɨɨbaimosumi. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Jaaboco isisɨsuuboro cɨvojafaño ficusuubo. Jaaboco igueenemehejedɨhaiva icamo toomomɨnaa teemehicauhi ifahaiva tɨcovovɨ igueenemehejedɨmova icamo. Jaaboco Pascuabuunatɨ miyamɨnaa ɨmefeenevɨ iinusuguubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jaabo Pedro cɨvojafa icaaboco imino teemehicaumo. Jaarunaa Cristota diibohallɨvɨ suufenɨtɨmo Moocaanico dilluhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jaanaa Herode Pedroco miyamɨnaa ɨmega ihiinusuujino iijɨcuuvɨofucu Pedro miimɨsiicɨ soldaomɨsifeene cɨgahicauhi mihicɨ jɨgaiñehiicɨri sisɨcɨnɨɨbo tollɨro saatoho icɨvoja guhuga ɨmegaco teemehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jaanaa Moocaani toomomɨnaafi icɨvojafaño jafevevauhi. Jaaneri paryɨ icɨvojafaño achɨcɨuhi. Jaadɨ Moocaani toomomɨnaafi Pedroco imecuhutɨ ganɨɨcɨuhi ihaiquequi. Goovano gañiivo, nooboro. Jaasumiro Pedrotɨ ijɨgaiñehi ihusetɨ acutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jaaboco Moocaani toomomɨnaafi nuuhi: Diniivɨgai meeheque cuhufono siyaavoobo ditɨhaipaajeneque dɨcamaje, eneenegui Pedro jɨcamaaiuhi. Jaadɨ siino Pedroco nuubo: Simon, diijeebutachehuco gafaivoobo tadyojɨcutɨ disaa, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jaanegui Pedro idojɨcutɨ saauhi: Fɨne jillɨ tɨgahi, nooboro itoomomɨnaafi omoonɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Jaamɨsi tɨconɨuhi afatyumɨsi ɨmegari iicautoomomɨnaaco. Jaanohallɨvɨ iicaumoco icano afatyuudɨ ɨɨfutuumɨsi jɨgaiño guhuga jahisivɨ ɨɨfotocɨnɨhugavɨ jaahuga iinoro faayacafutuuhi. Jaaneri ihiinuumɨsiro jɨɨhairi fuumɨsi. Jaanaa itoomomɨnaafi diibotɨ imimañobatɨ sihɨ minifutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jaadɨ jari Pedro imino eesafutuuboro nuuhi: Jari gaajacɨhi miyaano iicanoco. Moocaani jahi itoomomɨnaafico galluuhi uco Herode usetɨ, judiomɨ omoonɨjirunotɨ icano itaajasuqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Jaanoco esamaaiboro Pedro fuuhi Maria, Jua Marco onoobo seejɨ iijajaago. Jahɨ sihidɨ miyamɨnaa igaicɨnɨuhi Moocaanima ihiimaaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Jaabo ɨɨfutuuboro jahisio guhugaco tutucutuubo. Jaanegui bagocaja Rode onoogo iinuuhi: ¿Mɨɨjoho fɨne? noogoro emeecɨtogo. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Jaago Pedro ico iicanoco uguubuugoro imo imo iminifutuugoro iguhugaco faayɨcɨutɨgoro jinafatyuugo ɨjɨɨbogotogo Pedro iguhuga ɨmegavɨ iicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Jaanegui diigoco nuumo: Jillɨ fɨne degavehi, noomoro. Jaarunaa diigo: Miyaano, noogoro jenaauhicauhi. Jaanegui nuumo: Diibo icatɨno fɨne jillɨ diibo gaija, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Jaarunaa Pedro suufenɨtɨɨbo iguhugaco tutucuhicauhi. Jaanegui iguhugaco afaayɨcɨumo diiboco aatyɨmeumoro jabafiituuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Jaanegui Pedro diitoco ihuseri faguuhi llɨɨvɨ iicaqui. Jaaboro diitoco jɨɨbuguubo Moocaani diiboco cɨvojafañotɨ ihiinusuunoco. Jaaboro jillɨ Jacooboco, saatoho monahabomɨco icano mɨjɨɨbogo, nooboro sihɨgovɨ fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Jaanaa meseseeveudɨ icɨvoja toomomɨnaa ñaaɨvocasiuhi: ¿Mɨllɨ Pedro cuuca icahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jaamoco Herode guiinusuuhi. Jaarumo aatyɨmeutɨnegui diitoco: ¿Mɨllɨ jana taajaabo? nooboro itoomomɨnaaco gaisiraicɨsuubo. Jaaboro Herode Judeatɨ ufuuboro Cesarea cuumivɨ icatuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jaabo Herode sɨfiiratuuhi Tiro, Sidon icamo miyamɨnaajaago. Jaanegui diito sabadɨro ihiimaacasiumoro saaumo Herodejaago. Itɨconɨ Herode iija aivojɨɨbo Blasto onooboco nɨhɨbamɨco jaaduumo diitohallɨvɨ ihiimaaqui. Jaabofeenedɨ Iherodeque dilluumo sajeebɨɨ iicaqui diibo jiinɨjetɨ machutaaco agaayɨcɨhicauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jaanegui Herode diitoco tufucu jei masaa unuufucu, ihaivojɨ gaachehuco ɨjɨcafutuuboro ihaivojɨ gɨcɨnɨtafa casɨɨvuubo. Jaaboro diito ɨmefeenevɨ iimaaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jaaneri miyamɨnaa coovadiinamaaiuhi: ¡Jino ihiimaabo miyamɨnaafi icatɨɨbo Moocaaniro! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Jaasumiro Moocaani toomomɨnaafi diiboco chuumusuuhi Moocaanico iimuunoco diiboro agaayɨcɨumaño. Jaasumiro guijeveubo jɨɨjoho uduuneri. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Jaano tɨcovo Moocaani iijɨ guiraatonoro feehicauhi fahɨgovadɨ ɨjɨɨbegueneri. ");
INSERT INTO bmrNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jaadɨ Bernabemɨsi idudɨcamaajeque imivuudɨ Jerusaletɨ dojɨcuvɨro uhuumiumɨsi Jua Marco onooboco satyuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jaanaa Moocaani iimaamɨnaa icauhi Antioquiari iicaja Moocaani iijafaño. Jaamou diito jɨɨbogomɨnaa Bernabe, Simon Cɨvucu onoobo, Lucio cireneobo, Manae onoobo Galilea aivojɨɨbo Herode cojɨvɨ ifiivuubo, Saulo icamo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jaamo safucu igaivuumo Moocaanima machutɨmo iimaaqui. Jaamo machutɨmo Moocaanima ihiimaaumaaca Moocaani Gaija nuuhi: Bernabe, Saulo icamɨsico ijeevadɨ uudi mudugaacu diitɨsico toono dudɨcamaajejaa ucuuhuvaunojaago, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jaanegui saatoho jɨɨbogomɨnaa machutɨmo Moocaanima ihiimaaunobuunatɨ ihuseneque diitɨsihallɨvɨ ificuumoro diitɨsico galluumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jaamɨsico Moocaani Gaija agallunegui Bernabe, Sauloma icamɨsi fuuhi Seleucia cuumivɨ. Jaamañotɨ muuairi fuumɨsi Chipre chugaivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Jaamɨsi Salamina cuumivɨ ɨɨfutuudɨ judiomɨ sinagogajanofaño Moocaani iijɨco jɨɨbeguehicaumɨsi. Jaamɨsima Jua Marco onoobo fuuhi diitɨsico ihamusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jaamo tuchugairiro efeehicamo Pafo cuumivɨ ɨfutuuhi. Jahɨ atyɨmeumo judiomɨoobo BarJesu onoobo maaimoco. Jaabo bañɨhicauhi: Uujoho Moocaani iimaamɨnaafi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jaamaaimo Sergio Paulo onoobo aivojɨɨbo fanoovaco gaajaabo cojɨri icahicauhi. Jaabo ihaivojɨɨbo cuuhuvauhi Bernabe, Saulo icamɨsico Moocaani iijɨco iguubuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Jaarunaa tomaaimo griego iijɨri Elimas onoobo diitɨsico jenaauhicauhi ihaivojɨɨbo imiyaavugujiruneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jaanegui Saulo icaruubo Pablo onoobo Moocaani Gaija ijeebɨɨfaño gahafɨcɨnɨɨbo diiboco imino ɨhɨɨfɨnɨcɨuboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","¡Bañɨfiiramɨnaafi ɨjɨ seemene idiicaabo, idiimitɨɨbo miyaano jɨɨhevemɨnaafi idiicaabo! Ɨtɨcovojɨ Moocaani jɨɨhaico, ¿collɨhi suufenɨtɨɨbo cɨryu cɨryu moonɨɨboro diicahicahi? ");
INSERT INTO bmrNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jisu ɨco Moocaani use aamɨji dihaallɨɨ ɨco ijaabavequi. Jaabo nɨhɨba seseeque atyɨmetɨɨbo diicahi gueenene, nooboro. Jaasumiro cɨvono diibedi minifutuuno aimuufaibadɨ. Jaaneri dudɨɨvɨ icaubo. Jaanegui saatohoco guiinuubo ihusetɨ agaayɨcɨmoro diiboco isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jaanoco ihaivojɨɨbo aatyɨmeuboro miyaavuguhi. Jaaboro Moocaani iijɨco ɨjɨɨbogonoco uguubuuboro eetyehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Jaadɨ Pablomɨ ɨjɨcamaaimoro Pafo cuumitɨ ufuumo ɨfutuuhi Pergevɨ Panfilia jiinɨjevɨ. Jaamañovɨ Jua Marco onoobo diitɨsico ejeevesuuboro uumiuhi dojɨcuvɨro Jerusalevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Jaanobuunatɨ diitɨsi Pergetɨ fatyuuhi Antioquiavɨ Pisidia jiinɨjevɨ. Jahɨ judiomɨ jaguisɨsumi sinagogajafaño ufuumɨsiro casɨɨvutuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jaadɨ Moise tajɨɨba aameneque, bu Moocaani iimaamɨnaa aameneque icano emeecɨudɨ sinagogaja aivojɨto atajɨɨbaunegui dilluumo: Fañɨ, fagojɨɨbogoma mihicahachiijɨ miyamɨnaadi jisu mihiimaa, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jaanegui Pablo agañiivuuboro ihuseri faguubo llɨɨvɨ iicaqui. Jaaboro nuubo: Israel miyamɨnaa muguubu; amɨɨhai tollɨro Moocaani jeecɨvomɨnaa. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Moocaanico amɨɨhai Israel cuumimɨnaa mimiyaavogoobo moheedeeteque ɨcɨuhi. Jaaboro diitotɨ ajashutɨ cuumi eetavuubo siicuumifeenevɨ Egiptori iicausumi. Jaadɨ toojiinɨjetɨ imityari diitoco iinusuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jaadɨ Moocaani miimɨsiicɨ tɨcovovɨ ficabano sɨcaihɨgo diitoco jaabɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jaaboro sahuse juugahusetɨ miicuumiicɨ icano jiinɨje miyamɨnaaco Canaan jiinɨjevɨ ifinɨsuuboro moheedeeteque ijiinɨjeneque acɨubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Jaadɨ cuatro ciento cincuentadɨ ficabavabuunatɨ diitoco fagomɨnaafeenedɨ tajɨɨbahicaubo. Jaanobuunatɨ Moocaani iimaamɨnaafi Samuel iicausumi ");
INSERT INTO bmrNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Moocaanico dilluumo aivojɨɨbotɨ diitoco ihacɨqui diitoco itajɨɨbahicaqui. Jaanegui Moocaani diitoco acɨuhi miimɨsiicɨ ficabanohachuta tɨcovovɨ aivojɨɨbotɨ Saul onooboco Sis onoobo achico, Benjamin cuumiooboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Jaadɨ Moocaani Saulco ihaivojɨtɨ gañɨɨuhi. Jaaboro aivojɨɨbotɨ Davidco ficuubo. Jaabotɨ Moocaani nuuhi: Isai achi Davidco atyɨmehi: Tajeebɨɨ onoobadɨ iicaaboco uujoho iimogobadɨ iicajiiboco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jaabo David iyaachimɨhaioobou Jesu, Moocaani Israel cuumimɨnaaco itaajasuqui ificuubo diibo unuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jaabo Jua Jesu saautɨnaacaro jɨɨbeguehicauhi paryɨ Israel cuumimɨnaaco: Minitɨsuquimaaje amɨɨhai eedeehifiico mejeevesumoro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jaabo Jua ijɨɨbogoco imivucuujino fiitɨno nuubo: Amɨɨhai uco diiborucu, noomoro mehesɨcɨnɨɨbo icatɨhi. Tabuunatɨ saajiibo tajanaanɨcɨvɨ iicaabo. Jaabovɨ ɨfototɨhi diibobadɨ sihidɨ jeevahi. Jaabou, diibo tɨhaipaaje duujeque isinaayujiruunova, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Jaamo amɨɨhai tañahabomɨ Abraham yoto seeme mihicamo, tollɨro amɨɨhaifeene siicuumioto Moocaanico mejeecɨvomo icano. Amɨɨhaidi iicano jino taajasujɨɨbogo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mɨɨro Jerusaleri iicamo paryɨ ihaivojɨtoma Jesuco gaajautɨhi, Moocaani iimaamɨnaa aameque fahiijɨvaro jaguisɨsumi ɨɨfɨnɨcɨrumo gaajahicautɨmo. Jaamoro diitoro Jesuco iguijenɨguusumi toohaamefaño onoonoco miyaavusuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Toonohallɨtɨ agaicaaujirunoco diibovɨ aatyɨmeutɨnegui Pilatoco dillumo diiboco igaicaauqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jaamoro diibotɨ aamefaño onoobadɨ iicacuusumi ihɨmohobujetɨ iniitusuumoro cɨɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Jaaruuboco Moocaani guijevefañotɨ buheetesuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jaabo gueenene fucuva jafevehicaubo diiboma Galilea jiinɨjetɨ Jerusale cuumivɨ ufuumovɨ. Jaamo diito jisumi diibotɨ miyamɨnaaco jɨɨbeguehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Jaamo mɨɨhai amɨɨhaico mɨjɨɨbeguehicahi iimino jɨɨbogoco Moocaani moheedeeteque unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Mɨɨhai diito iyaachimɨhai mihicamedi diibo unuuno miyaavehi Jesuco ubuheetesuubo Salmo onoohaamefaño capitulo dos onoobadɨ: Ɨɨjoho taseemene jifucu uubadɨro idiicaabo, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Moocaani diiboco ifi tuucɨtɨno iicaqui ubuheetesuujinoco jillɨ nuubo. Jaabo ɨco uujoho acɨji Davidco unuunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jaabadɨro bu Sisalmovɨ noono: Agaijɨɨbo dijeecɨvomɨnaafi ifiico deevesujitɨhi tuucɨtɨno iicaqui, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jaabo David isumiotoco imino moonɨubo Moocaani onoobadɨ: Jaabo iguijeveuboco iheedete cojɨvɨ cɨɨumo. Jaabo tuucɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jaanotɨ Moocaani ubuheetesuubo tuucɨutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Jaanegui fañɨ, magaaja diibo Jesufeenedɨ imitɨ buusuco amɨɨhaico mɨjɨɨbogonoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mɨɨro Moise tajɨɨbaco omoonɨrumo taajatɨmo iicahicamo paryɨ Jesuco imiyaavogomo diibofañodɨ taajaji. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Jaanegui imino mehesɨcɨnɨ; Moocaani iimaamɨnaa jillɨ unuuno amɨɨhaihallɨvɨ icadino: ");
INSERT INTO bmrNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Memeecɨ amɨɨhai dejecumɨnaa, majabafiitomoro mifinɨcɨnɨ uujoho Moocaani iicaabo amɨɨhai mihicasumi sihidɨ ejeevanoco eetaveji. Jaarunoco saatoho amɨɨhaico ɨjɨɨbogorunoco miyaano meneejitɨrahi, onoono. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jaadɨ Pablomɨsi inahabonɨmɨnaama judiomɨ sinagogajatɨ ihiinuumoco judiomɨ iicatɨmo nuuhi: Sijaguisɨvɨ jei mɨɨhaico siino mɨjɨɨbogo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jaadɨ Pablomɨsi jahisivɨ iinuucuumɨsi dojɨcutɨ fuumo sihidɨ judiomɨoto, siicuumio miyaavogomɨnaa icamo. Jaamoco diitɨsi fajɨɨnɨhicauhi: Moocaani imihiijɨguiinoro mihica, sefano noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jaadɨ sifoo jaguisɨvɨ fiitɨcuujiruno faacuumiro ufuuno Moocaani iijɨco iguubuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Jaanegui judiomɨ sihidɨ miyamɨnaa ufuunoco aatyɨmeumoro diitohallɨtɨ Pabloco jɨɨheveuhi. Jaamoro Pabloco ejenaaumoro dejecuhicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jaarunaa Pablomɨsi igototɨmɨsi nuuhi: Itɨconɨ amɨɨhai judiomɨco Moocaani iijɨco mɨjɨɨbeguejirahi. Jaarunoco magaayɨcɨtɨmoro ifinɨjitɨno ifiima mihicagotɨhi. Jaanegui amɨɨhai cojɨtɨ siicuumiotojaagovɨro mefeeji, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Jillɨ nooboro Moocaani mɨɨhaico tajɨɨbauhi: Ɨco ficuuhi faajiinɨjemɨnaahallɨvɨ judiomɨ icatɨrumoco gaajasuqui. Amɨɨhaifeenedɨ taajasujɨɨbogoco jiinɨjejɨnibaacɨvɨ galluuji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jaanoco siicuumioto uguubuumoro imo imo minifutuuhi. Jaamoro: Moocaani iijɨ aivo imihi, noomoro miyaavuguumo, paryɨ fiivo ifiima iicaqui ɨɨcɨcuudɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jillɨ paryɨ toojiinɨjevɨ Moocaani iijɨ jɨɨbogocafutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Jaarunaa judiomɨ iimaacasiuhi Moocaani iija gaigoomɨ obocɨfimoma, tuucuumio gaifiimɨ obocɨfimo icamoma. Jaamoro tɨconɨuhi Pablomɨsico ɨjɨɨhevemere ɨdaasuno omoonɨumo. Jaamoro diitɨsico toojiinɨjetɨ gañɨɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jaanoma iicaumɨsi diitohallɨvɨ itɨhaipaaje jiinɨco tatacuumɨsi toono jɨɨbogobadɨ iicano. Jaamɨsiro Iconio cuumijaa fuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jaarunaa Cristotaco ejeevesuumo imo imo icauhi Moocaani Gaija ijeebɨɨnofaño iicaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jaadɨ Iconiovɨ Pablo, Bernabe icamɨsi judiomɨ sinagogajafaño fuuhi. Jaamɨsiro jɨɨbeguehicauhi. Jaanoco sihidɨ miyaavuguumo judiomɨ griegomɨoto icamo. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Jaarunaa saatoho judiomɨ imiyaavuguutɨmo siicuumiotoco esaayusuuhi inahabomɨco ijɨɨhevequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jaarunoco igototɨmɨsi tuucuumivɨ gueenene icaumɨsi Moocaanitɨ jɨɨbogomɨsiro. Jaabo Moocaani iimihusetɨ ihiimaanoco miyaavugusuhicauhi ɨɨfusunoco, sihidɨ ejeevanehejeque icano omoonɨhicanofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Jaarunaa tuucuumio miyamɨnaa dugaacɨnɨuhi saatoho judiomɨjaagodɨ, saatoho minɨsumɨnaajaagodɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jaanoma iicamo judiomɨ, siicuumioto icano aivojɨtoma jɨcucasiuhi diitoco ɨdaasuno omoonɨmoro guiisibaneri ihaamɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Jaanoco Pablomɨsi agaajacɨumɨsiro gaauhi Listra, Derbe icanovɨ, Licaonia jiinɨje uufocono cuuminovɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Jahɨ tollɨro taajasubogoco jɨɨbeguehicaumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra cuumivɨ icaubo saafi ifiivuunotɨro ɨgotɨɨbo iicaubo. Jaabo gɨcɨnɨuhi ɨgotɨɨbo itɨhai iimiutɨneri. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Jaabo Pablo iimaanoco imino guubunɨcɨhicauhi. Jaanegui Pablo diiboco imino emeecɨubo gaajacɨuhi: Uujoho buheeji, nooboro imiyaavuguunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jaanegui Pablo sefano nuuhi: ¡Sano tɨcovoro ditɨhaihallɨvɨ dulleeve! nooboro. Jaanegui sefano casiniivuubo. Jaaboro ɨgooboro fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jaano Pablo omoonɨunoco miyamɨnaa aatyɨmeumoro sefano coovadiivuumo Licaonia iijɨri: ¡Diosmɨ, miyamɨnaa ifibadɨ ifiivotomoro mojaago niitehi! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jaamoro Bernabeque Jupiter neehicaumo. Jaanotɨ Pabloco Mercurio neehicaumo, diibo ɨjɨɨbeguehicauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jaanegui Jupiter sacerdote Jupiterque iimehicauja cuumi ɨmegari iicaja abajaabo sɨvauhi niivɨmɨco deecaneri imino iimibachuhicauboro. Jaamɨsico sihidɨ miyamɨnaa diitɨsico iimomoro jeecɨvuujirumo iniivɨmɨco agaisiraicɨumoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jaanoco iminɨsumɨnaatɨsi Bernabemɨsi agaajacɨudɨ igaachehunoco agallicumɨsiro jɨcafutuuhi miyamɨnaafeenedɨ coovadiicɨnɨmɨsiro: ");
INSERT INTO bmrNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Amɨɨhai, ¿collɨhi tollɨ momoonɨhi? Amɨɨhaibadɨro mɨsi miyamɨnaatɨsi, tooneguiiha mɨsi masaahi. Tollɨ iicaneheje jihovonehejeque mejeevesuqui. Jaamo ɨdɨɨboro Moocaani iicaabojaago miminifetequi, niquejeque, jiinɨjeque, muuaiñoco icano paryɨ faabohoco ifiivusuubojaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Sɨɨcɨjenaha Moocaani paryɨ cuumimɨnaaco ficuuhi iimogobadɨ iicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Jaaruubo fahiijɨvaro: Uujoho iicanoco igaajaqui, nooboro imino moonɨɨbo, niijabaco aigusuubo, basutaaco noovasuubo, mamachujidɨnoco acɨɨbo imo imo mihicaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jillɨ noomɨsiro diitoco faguumɨsi. Jaarunofaño suufenɨutɨrumo iniivɨmɨco agaisiraicɨmo diitɨsico ijeecɨvequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jaanaa gaseumo judiomɨ Antioquia, Iconio icanotɨ. Jaamo tomaño miyamɨnaaco diitɨsihallɨvɨ abañɨumo miyaavugusuuhi. Jaamoro Pabloco guiisibaneri aamɨuhi. Jaaboco: Fɨne guijevecuubo, noomoro tuucuumitɨ buhɨgovɨ iguiiyɨcɨumoro gañɨɨjeuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Jaabohallɨvɨ Cristota igaivuuhi. Jaanaa Pablo agañiivuuboro siino tuucuumifaño fuuhi. Jaano seseevedɨ Bernabema Derbe cuumivɨ fuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Jaacuumivɨ taajasujɨɨbogoco jɨɨbeguehicaumɨsi. Jaadɨ sihidɨ Cristota iicacuudɨ dojɨcuvɨro uumiumɨsi Listra, Iconio, Antioquia icanovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Jaacuumijevɨ Cristota iicaumoco quehecutusuumɨsi. Jaamɨsiro fajɨɨnɨhicaumɨsi quehecuno miyaavogofaño iicaqui. Moocaani aivojɨfaño mefeejimoco ɨdaasuno moonɨjimo, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jaamɨsiro Moocaani iijanohallɨvɨ iquillahutotɨ ficuumɨsi. Jaadɨ machutɨmo Moocaanima iimaahicaumo Moocaanico imiyaavuguudɨmohallɨvɨ Moocaani iteemequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Jaanobuunatɨ fatyuumɨsi Pisidia jiinɨjefeenedɨ. Jaamɨsi ɨfutuuhi Panfilia jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jaamɨsiro Perge cuumivɨ jɨɨbeguehicaumɨsi. Jaadɨ fuumɨsi Atalia cuumivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Toonotɨ ɨjɨcafutuumɨsiro muuairi fuumɨsi Antioquiavɨ itɨconɨ diitɨsico Moocaani imihiijɨfañodɨ idudɨcamaaiqui ificucuumivɨ. Jaanoco toono imivucuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jaamɨsi Antioquiavɨ agaseudɨ igaiyɨɨcɨumɨsi paryɨ Cristotaco. Jaamɨsiro jɨɨbeguehicaumɨsi paryɨ Moocaani diitɨsima omoonɨhicaunoco judiomɨ icatɨrumedi Moocaani iguhugaco faayɨcɨuhi diito imiyaaveguequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jaamañovɨ Pablomɨsi gueenene icauhi Cristotama. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jaasumi saatoho Judeatɨ Antioquiavɨ ufuumo inahabomɨco ɨjɨɨbogomo tɨconɨuhi: Mataajaqui itɨconɨ amɨɨhai meeheque miquitɨcɨji Moise atajɨɨbaubadɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jaamoma Pablomɨsi sihidɨro idillucasiumɨsiro jenaaucasihicauhi. Jaanofeenevɨ Pablomɨsico ficuumo saatoho icano Jerusalevɨ ifeequi minɨsumɨnaama, Jerusaleri iicaja Moocaani iija quillahutoma tobogoco ihiimaatequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jaamoco Antioquiari iicamo Cristota agalluumo fuuhi. Jaamo fatyuuhi Fenicia jiinɨje, Samaria jiinɨje icanofeenedɨ. Jaamo inahabomɨco jɨɨbogomoro feehicauhi siicuumioto icarumo iheedehiijɨco ejeevesuumoro Moocaanico agaayɨcɨumoco. Jaabogoco uguubuumoro sihidɨ imo imo icaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jaanaa Pablomɨsi Jerusalevɨ ɨɨfutuumɨsico paryɨ Cristota, minɨsumɨnaa, iquillahuto icamo imo imo diitɨsico gaayɨcɨuhi. Jaamoco diitɨsi jɨɨbeguehicauhi Moocaani diitoma omoonɨhicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Jaarunaa saatoho fariseomɨototɨ imiyaavuguumo ujulleeveumoro nuuhi: Imijiruno tollɨro judiomɨ iicatɨrumo imiyaavogomo meeheneque miquitɨcɨno. Jaamoro mataajɨɨbano Moise atajɨɨbaubadɨ iicaqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jaanegui igaivuumo paryɨ minɨsumɨnaa, iquillahuto icamo toonoco ihiimaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Jaanoco sihidɨ ejenaaucasihicaunobuunatɨ Pedro agañiivuuboro diitoco nuuhi: Tañahabomɨ, amɨɨhairyo magaajacuuhi itɨconɨ uco Moocaani ɨcɨuhi amɨɨhaifeenetɨ, taajasujɨɨbogoco judiomɨ iicatɨrumoco jɨɨbeguequi jaamo imiyaaveguequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Jaabo Moocaani famoo jeebɨɨnocoro agaajaabo ɨfusuuhi tollɨro diito agaayɨcɨunoco Igaijaco aacɨunofeenedɨ mɨɨhaico iicaubadɨro. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Moocaani diitoco mɨɨhaifañotɨ guiinovɨ ficuutɨhi. Jaamo jeebɨɨnoco nitɨcuubo diiboco imiyaavuguumaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jaamo ¿collɨhi amɨɨhai mimiyaavogotɨhi Moocaani omoonɨnoco? Jaamoro jito imiyaavogomohallɨvɨ obocɨtajɨɨbaco mificuuhi, moheedeete, mɨɨhai icarumo meheetavejitɨrunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Jaanoco diitobadɨro mɨɨhai mataajajinoco magaajahi Jesucristo imihiijɨfeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jaanegui famooro ɨllɨɨvuumoro Bernabemɨsi ɨjɨɨbogonoco guubunɨcɨumo gaajataco, ajabafiiranehejeque icano diitɨsifeenedɨ Moocaani omoonɨhicaunoco siicuumiotofeenevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jaanoco ihiimaaunobuunatɨ Jacoobo nuuhi: Tañahabomɨ, uco muguubunɨcɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Pedro mɨɨhaico jɨɨbeguehi, ɨtɨconɨɨbo Moocaani judiomɨ iicatɨrumotɨ iyototɨ ɨɨcɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mɨɨro jillɨ noono Moocaani iimaamɨnaa acaatɨnɨuno: ");
INSERT INTO bmrNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Jinobuunatɨ uumiji. Jaaboro siino gañiiyɨcɨji aacutuuja David iijaco. Aacutuunoco siino iimibachuuboro eetaveji. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Jaano coovooto paryɨ Moocaanico iguiinequi paryɨ jiinɨjemɨnaa tamomoco ijeecɨvequi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Jillɨ noobo Moocaani jinooco agaajasuubo sɨɨcɨjetɨro. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jaanegui uujoho amɨɨhaico neehi: Judiomɨ iicatɨmoco gañuhusuno momoonɨdino iheedehiijɨco ejeevesucuumoro Moocaanijaagovɨro iicacuumoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Imicuujino aameque macaatɨnɨhaamefaño jillɨ meneeji: Ɨjɨnɨta jeecɨvoco deetavucuudino, saatohoba ataabavatɨmo buhɨgueejedɨ gaigoomɨma icadino, bu asimɨco udusuucɨneri amacanɨsumehejeque duucuudimo, tɨɨjohoco aducuudimo. Jillɨ noomoro ");
INSERT INTO bmrNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","faacuumivariro icamo sɨɨcɨjetɨro Moise tajɨɨbaco ɨjɨɨbeguehicamo sinagogajanofaño fahiijɨvaro jaguisɨfucuva tɨcovoocɨvɨ, nuubo Jacoobo. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jaanegui minɨsumɨnaa, quillahutomɨhai, paryɨ Moocaani iijamɨnaama ihiimaacasiumoro saatohotɨ ifeenetɨ ɨcɨuhi. Juda icaruuboco Barsaba eneehicaubo, Sila onoobo aivo diitofeenetɨ imiyaamɨsi iicamɨsico ɨcɨumo Pablo, Bernabe icamɨsima Antioquiavɨ igalluuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Jaamoma aameque galluumo: Mɨɨhai minɨsumɨnaa, quillahuto, paryɨ monahabomɨ icamo moojɨco magalluuhi, monahabomɨ judiomɨ iicatɨrumo Antioquiari, Siria, Cilicia icano jiinɨjeri iicamojaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mɨɨhai muguubuhi jimañotɨ saatoho ofoomovaha amɨɨhaico ihiimaari gañuhusuno moonɨhicahi mɨɨhai matajɨɨbatɨmo. Jaamo amɨɨhaico mɨtasuhicahi: Amɨɨhai meeheque miquitɨcɨ. Jaamoro Moise atajɨɨbabadɨ mihica, eneehicamo. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jaanoma mihicamo sabadɨro monoomoro moofeenetɨ saatohotɨ mɨhɨcɨhi amɨɨhaijaa magalluuqui magaijɨno nahabomɨsi Bernabe, Pablo icamɨsima. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Jaamɨsi ñɨhicunofeenedɨ ifiico ficuuhi Jesucristo momohallɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jaanegui amɨɨhaijaago magalluuhi Juda, Sila icamɨsico. Jaamɨsi amɨɨhaima ihiimaamɨsiro imino amɨɨhaico jɨɨbeguejimɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Jillɨ Moocaani Gaijadi imino, mɨɨhaidi imino icano janaanɨcɨ siinoco amɨɨhaico matajɨɨbatɨhi. Jino ɨdɨɨnocoro amɨɨhaico meneehi: ");
INSERT INTO bmrNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ɨjɨnɨtaco ejeecɨvucuunoco meheetavucuudino. Jaabadɨro udusuucɨneri amacanɨsumehejeque muduudino, tɨɨjohoco mahaduudino, saatohoba ataabavatɨmo jahisihijedɨ gaigoomɨma icadino. Jillɨ mihicahachiijɨ imino momoonɨji. Tahɨ imino mihica, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jaamoco agalluumo fuuhi Antioquiavɨ. Jaamañootoco iigaiyɨɨcɨumoro toohaameque acɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Jaahaameque inahabomɨ emeecɨumoro sihidɨ imo imo minifutuuhi toohaamefaño diito ajacusunoco aatyɨmeumoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jaamɨsi Juda, Sila icamɨsi Moocaani iimaamɨnaatɨsi icauhi. Jaamaño inahabomɨco sihidɨ iijɨri afajɨɨnɨmɨsiro diitoco quehecutusuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Jaanobuunatɨ gueenene iicauno nijequetɨ inahabomɨ diitoco galluuhi: Sajeebɨɨma mofoo, noomoro dojɨcuvɨro diitoco agalluumojaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Jaarunaa Sila toonovɨro fitafutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Tollɨro Pablo, Bernabe icamɨsi Antioquiavɨ fitafutuuhi. Jaamo sihidɨ saatohoma jɨɨbogomoro icahicauhi Jesucristo jɨɨbogoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Jaanobuunatɨ goovacuutɨnotɨ Pablo Bernabeque nuuhi: Maha siino faacuumivavɨ monahabomɨco memeecɨtequi, ¿naa mɨllɨ iicamo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Jaanegui Bernabe satyujirahi Jua Marco onooboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Jaarunaa diibo diitɨsico Panfiliavɨ ejeevesuuboro uumiuhi diitɨsico idudɨcamaajeque amusutɨɨbo. Jaaneguiiha, Pablo diiboco imuguutɨhi asatyunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Jaanoco sihidɨ ejenaaucasiunoma iicaumɨsi dugaavocasiuhi. Bernabe Marcoma ɨjɨcafutuumɨsiro Chipre chugaivɨ fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Jaanotɨ Pablo Silaco ɨɨcɨuboma fuuhi Moocaani imihiijɨfañodɨ inahabomɨ agalluudɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Jaamɨsi fatyuuhi Siria jiinɨje, Cilicia jiinɨje icanofeenedɨ inahabomɨco quehecutusumɨsiro Cristotaco. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo, Sila icamɨsi ɨfutuuhi Derbe, Listra icano cuuminovɨ. Jahɨ atyɨmeumɨsi miyaavogomɨnaafi Timoteo onooboco miyaavogomɨnaago judiomɨogo griegooboma iicaugo achico. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jaabotɨ inahabomɨ Listrari, Iconiori icano iicaumo imino iimaahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Jaaboco Pablo imuguuhi diitɨsima igataavequi. Jaaboro iimeeheque quitɨcɨsuhi tahɨ iicaumo judiomɨ iimuguujitɨruneguiiha famooro diibo caani griegoobo iicaunoco agaajaumaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Jaamɨsi faacuumivafañodɨ ufuumɨsi inahabomɨco jɨɨbogomɨsiro feehicauhi Jerusaleri iicaumo minɨsumɨnaa, iquillahuto icamo diitɨsico unuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jaaneri paryɨ Cristota quehecumo minifutuuhi miyaavogofaño. Jaaneri Cristota fafucuvaacɨvɨro guiraatomoro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jaanaa Moocaani Gaija jɨɨbugusuutɨhi Moocaani iijɨco Asia jiinɨjevɨ. Jaanegui fatyuumo Frigia, Galacia icano jiinɨjefeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Jaamo ɨfutuuhi Misia jiinɨjejɨnivɨ. Jaamañotɨ esamaaiumo Bitinia jiinɨjevɨ ifeequi. Jaarunaa Jesu Gaija imuguutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Jaanegui Misia jiinɨjefeenedɨ sanotɨcovoro afatyumo ɨfutuuhi Troa mɨcuvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Jaamañovɨ Pablo fucu gaijafaño atyɨmeuhi macedoniamɨnaafi julleecɨnɨɨboco. Jaabo diiboco neehicauhi: Macedonia jiinɨjevɨ disaa. Jaaboro mɨɨhaico daamusu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Jaanoco Pablo aatyɨmeunegui mihimibaivo Macedoniavɨ mefeequi: Fɨne Moocaani mɨɨhaico coovahi tahɨ taajasubogoco mɨjɨɨbeguequi, munuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Jaadɨ Troa mɨcutɨ mɨjɨcafutuumoro sanotɨcovoro mufuumo mɨhɨfutuuhi Samotracia chugaivɨ. Jaano seseevedɨ mɨhɨfutuuhi Neapolis mɨcuvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Toonotɨ mufuuhi Filipovɨ Roma cuumi Macedonia jiinɨjeri iicacuumi imiyacuumivɨ. Jaamañovɨ gueenejɨsuno mihicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jaamo jaguisɨfucusumi tuucuumitɨ jahisivɨ mufuuhi muuaijɨnivɨ tomañovɨ Moocaanima ihiimaanɨcɨmañovɨ macasɨɨvuumoro Moocaani iijɨco mɨjɨɨbuguuhi gaigoomɨ igaivuumoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jaamotɨu saafigo Lidia onoogo Tiatira cuumiogo. Jaago iiminoono gaachehunoco tɨfaihɨba iicacheunoco naajehicaugo. Jaago Moocaanico ejeecɨvehicaugo mɨjɨɨbogonoco guubunɨcɨhicauhi. Jaago jeebɨɨco Moocaani faayɨcɨuhi Pablo ɨjɨɨbogonoco imino iguubunɨcɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jaago paryɨ iijamɨnaama nitɨsuquimaaiugo. Jaagoro mɨɨhaico neehicauhi: Miyaano uujoho Cristotahe iicahachiijɨ taajafa masaamoro mihicava, noogoro mɨɨhaico iijavɨ fiitɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jaanaa safoono Moocaanima ihiimaahicaumañovɨ mufuumo mahatyɨmeuhi saafigo bagocajaco. Jaagofañotɨ gaajacɨ ɨjɨ gaajacɨhicauhi. Jaaneri diigo abajato sihidɨ nɨhɨbamɨco gaayɨcɨhicauhi diigo agaajacɨnohallɨvɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Jaago mɨɨhai Pabloma mufuumo dojɨcutɨ fuugo coovadiicɨnɨgoro: Jito Moocaani caamovohɨ iicaabo jeecɨvomɨnaa. Jaamo amɨɨhaico taajasu jɨɨhaico jɨɨbeguehi, noogoro feehicaugo fahiijɨvaro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jaanofeene Pablo agañuhusuvuuboro dojɨcuvɨro diigojaa acafesaavuuboro igaajacɨ ɨjɨco nuubo: Jesucristo momofeenedɨ ɨco tajɨɨbahi. Diigofañotɨ diino, nooboro. Jaasumiro diigotɨ ihɨjɨ iinuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Jaanoco diigo abajato atyɨmeuhi diigofeenedɨ nɨhɨbamɨco ɨɨcɨhicaurumo ɨɨcɨcuujitɨnoma iicamo Pablomɨsico agaayɨcɨumoro satyuumo aivojɨtojaago naajetehasifeenevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Jaamɨsico fagomɨnaa ɨmega ɨɨfutusuumoro nuumo: Jitɨsi judiomɨsi iicamɨsi muucuumico gañuhusuno ñaaɨsuvahi ijɨɨbegueneri. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Jaanoco mɨɨhai magaayɨcɨmoro mɨnɨsugotɨhi romanomɨ mihicamaño, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jaanoma iicamo sihidɨ miyamɨnaa Pablomɨsijaa sɨfiiratuuhi. Jaanegui ifagomɨnaa tajɨɨbauhi igaachehunoco ujujuucumoro diitɨsico ɨmeiñeri ihaamɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Jaamɨsico sihidɨ ahaamɨhicaumoro cɨvojafaño ficuumo. Jaamoro itoomomɨnaafico tajɨɨbaumo imino iteemequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Jaanegui itoomomɨnaafi diitɨsico aivo fañoomecufa iicauhɨmonobafaño cuhufono jɨɨhacuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Jaafucu fucufeene Pablomɨsi Moocaanima ihiimaamɨsiro Cristo masinoco masivahicauhi. Jaanoco sacɨvojamɨnaa guubunɨcɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jaanaa imimañobatɨ sefano icɨvoja nicuta maryɨbauhi. Jaaneri paryɨ icɨvoja guhugano faayanamaaiuhi, bu icɨvojamɨnaa sisɨta ijɨgaiñehino sinanamaaiuhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Jaanaa itoomomɨnaafi aaicuuboro meecɨurunaaca paryɨ icɨvoja guhugano faayɨcɨnɨuhi. Jaanoco itoomomɨnaafi aatyɨmeuboro ihaamɨgaco guiiyɨcɨuhi ifiico iinoro igaicaauqui: Paryɨ fɨne icɨvojamɨnaa gaacuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Jaarunaa Pablo diiboco sefano nuuhi: Mɨllɨ difiico moonɨdino. Famooro mihicahi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Jaanegui itoomomɨnaafi cuugahuco dilluuhi. Jaaboro goovano jɨcafutuubo icɨvojafaño sihidɨ vɨvɨvɨ iigutuuboro Pablomɨsiguiino memuɨɨvutuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jaanegui fañoomecutɨ diitɨsico ihiinusuuboro nuubo: Aivojɨtɨsi, ¿mɨllɨ uujoho moonɨji niquejefaño taajaqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Jaanegui diitɨsi iimusuuhi: Aivojɨɨbo Jesucristoco miyaavogo. Jaabo taajahi paryɨ diijaotoma, noomɨsiro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jaamɨsiro diiboco paryɨ iijaotoma jɨɨbuguumɨsi Moocaani iijɨco. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jaafucuro itoomomɨnaafi diitɨsico ahaamɨhicauno tujaavonoco nitɨubo. Jaadɨ paryɨ iijamɨnaama nitɨsuquimaaiumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Jaadɨ diitɨsico iijajaago asatyuuboro machusuubo. Jaabo paryɨ iijamɨnaama imo imo icauhi Moocaanico imiyaavuguuneri. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Jaanaa fucuro ifagomɨnaa sisɨmɨnaaco galluuhi icɨvoja toomomɨnaafijaago diitɨsico isinaayuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jaanegui itoomomɨnaafi Pablomɨsico nuuhi: Fagomɨnaa uco tajɨɨbahi amɨɨsico sinaayuqui. Jaanegui sajeebɨɨ mihiinucu, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Jaarunaa Pablo isisɨmɨnaaco nuuhi: Mɨsi romanomɨotɨsi mihicamɨsico miyamɨnaafeenevɨ ahaamɨhicamoro. ¿Mɨsivɨ iimitɨnoco aatyɨmetɨmoro mɨsico toovono sinaayujirahi? Jaafa iinoro asaamoro mɨsico iinusuvamo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Jaanoco isisɨmɨnaa ufuumoro ifagomɨnaaco jɨɨbugutuuhi. Jaanoco romanomɨotɨsi diitɨsi iicaunoco uguubumoro sihidɨ iguutumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jaanegui ufuumoro diitɨsima toonoco iimibachujeumoro diitɨsico iinusuumo. Jaamoro diitɨsico: ¿Jiicuumitɨ collɨhi mufuucuutɨhi? nuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Jaadɨ icɨvojafañotɨ ihiinuudɨ Lidia onoogo iijajaa fuumɨsi. Jaamɨsiro inahabomɨco emeecɨjeudɨ diitoco equehecutusumɨsiro tuucuumitɨ fuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Jaanaa Pablomɨsi Silama ufuumɨsi Anfipoli, Apolonia icano cuuminofeenedɨ afatyumɨsi Tesalonica cuumivɨ ɨfutuuhi judiomɨ sinagogaja icamañovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Jaajafaño Pablo ijeevamaje iicanɨcɨbadɨ sinagogajafaño feehicauhi mijaguisɨcɨ, sajaguisɨ ɨdɨɨno fucuva diitoma iimaahicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Jaabo Caatɨnɨhaamefañodɨ diitoco jɨɨbeguehicaubo Cristo ɨdaasuno iicauboro iguijeveebe ubuheeteunoco. Jaaboro diitoco neehicaubo: Diibo jaanɨ Jesuco uujoho amɨɨhaico jɨɨbeguehicahi. Jaabo diibo Cristo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jaanoco saatoho judiomɨtɨ imiyaavuguumoro Pablo, Sila icamɨsijaa minifutuuhi, tollɨro sihidɨ griegomɨ Moocaanico ejeecɨvehicaumo miyaavuguuhi, bu sihidɨ ajashutɨno obocɨfino gaigoomɨ miyaavuguuhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Jaanoma iicamo judiomɨ imiyaavuguutɨmo ataaquivuumoro iimitɨno gaifiimɨco iigaiyɨɨcɨumoro tuucuumico gañuhusuno ñaaɨsumo. Jaamoro Jason onoobo iijaco cabocɨumo Pablo, Sila icamɨsico agaayɨcɨmoro miyamɨnaaco ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Jaarumo Pablomɨsico aatyɨmeutɨnegui toojao abajaabo Jason onooboco satyuumo saatoho inahabomɨma tuucuumi aivojɨtojaago. Jaamoro sefano coovadiivuumo Pablomɨsiditɨ: Jito faajiinɨjequere rugueenɨmoro efeehicamo juu gasecuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jaamoco Jason iijafaño ficuuhi. Jaamo famooro romano aivojɨɨbo tajɨɨbaco imino moonɨtɨmo: Sifi aivojɨɨbo icahi Jesu neehicamo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jaanoco paryɨ miyamɨnaa aivojɨto icamo uguubuumoro sihidɨ ñaaɨvuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jaanegui Jason, bu saatoho icamo fagomɨjaago inɨhɨbamɨco ificuumoro iinuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jaasumiro inahabomɨ Pablomɨsico fucu Berea cuumivɨ galluuhi. Jaadɨ tahɨ ɨɨfutuumɨsiro judiomɨ sinagogajafaño fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jaamo tomaño judiomɨ Tesalonica cuumiri iicaumo janaanɨcɨ imihuseuhi. Jaamaño Moocaani iijɨco imino agaayɨcɨumoro fafucuvaacɨvɨro Caatɨnɨhaamefaño onoonoco ɨɨfɨnɨcɨhicauhi: ¿Naa miyaanoco mɨɨhaico noomɨsi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jaamoro sihidɨ saatoho diitotɨ miyaavuguuhi. Tollɨro griegomɨtɨ sihidɨ gaigoomɨ obocɨfimo miyaavuguuhi, bu sihidɨ gaifiimɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Jaanoco Tesalonicao judiomɨ Pablo tollɨro Bereavɨ Moocaani iijɨco ɨjɨɨbogonoco uguubuumoro tahɨ fuuhi. Jaamoro tomaño miyamɨnaaco ñaaɨsutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jaarunaa Bereari iicaumo inahabomɨ Pabloco goovano galluuhi muuaijɨnivɨ ifeequi. Jaanotɨ Sila, Timoteo icamɨsi Bereavɨ fitafutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Jaamo Pabloma ufuumo diiboco satyuuhi Atena cuumivɨ. Jaamo uhuumiumoco Pablo nuuhi: Sila, Timoteo icamɨsico mɨjɨɨbogo goovano tajaa isaaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Jaabo Pablo Timoteo, Sila icamɨsico Atenatɨ otoomoobo atyɨmehicauhi faacuumifañoro ɨjɨnɨta iicanoco. Jaaneri sihidɨ ɨdaasuvehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jaanoma iicaabo judiomɨ siicuumioto Moocaanico ejeecɨvehicaumoma sinagogajafaño iimaahicaubo. Jaabadɨro fafucuvaacɨvɨro goohasinofaño iicamoma ihiimaaboro feehicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jaanotɨ saatoho gaifiimɨ epicureo onoono jɨɨbogoco nɨsuquimaaihicaumo. Jaanotɨ saatoho estoico onoono jɨɨbogoco nɨsuquimaaihicauhi. Jaamo tɨconɨuhi Pabloma ihiimaamo. Jaamoro saatoho neehicauhi: ¿Mɨllɨ fɨne mɨɨhaico neejiruubo, jaanɨ ihiimaafifiibo? noomoro. Jaanotɨ saatoho neehicauhi: Fɨne siomo diosmɨ jɨɨbogomɨnaafi, neehicauhi Pablo Jesu ubuheeteunoco ɨjɨɨbeguehicauneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Jaanoma iicaumo diiboco satyuumo Areopago onoobaɨvɨ: Mɨɨhaico dɨɨbogo jino bojɨɨbogoco ɨsɨvanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Magaajatɨnehejeque mɨɨhaico dɨɨbeguehicahi, ¿mɨllɨ iicanehejeque neehicahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Jaamo atenamɨnaa, siicuumijeoto icamo jinejebaco moonɨtɨmo toono iimaariro icahicaumo bohonoco uguubuuneriro. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Jaanegui Pablo Aeropagobaɨvɨ diitofeenetɨ ujulleeveuboro nuuhi: Amɨɨhai atenamɨnaa diosmɨ jeecɨvomɨnaa mihicamo. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mɨɨro amɨɨhai diosmɨco mejeecɨvehicamañehejedɨ afatyoobo samañovɨ atyɨmehi, jillɨ noonoro acaatɨnɨcɨnɨnoco: Dios Agaajaratɨɨboco, onoonoco. Mɨɨro diiboco gaajatɨmo mejeecɨvehicaabotɨ jino uujoho iimaahicahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Jaabo diibo Moocaani jiinɨjeque paryɨ fanoova icanoco eetavuubo. Jaabo jiinɨje, niqueje icano abajaabo. Jaabo miyamɨnaa eetavotajafaño icatɨɨbo, miyamɨnaa jeecɨvo sefari icatɨɨbo, ");
INSERT INTO bmrNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","jinejetɨ cuujɨvaachutɨɨbo icano. Jaabo mɨɨhai famoocoro fiivoco acɨɨbo, guibuhubaco majaguisɨqui acɨɨbo, fanoovaco acɨɨbo icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Jaabo miyamɨnaaco saafi tɨɨjotɨro faacuumiva miyamɨnaaco fiivusuubo fanoojiinɨjehallɨvɨro iicaqui. Jaaboro jino paryɨ mihicajisumije, mihicajimañeje icanoco ohoovooboro ficucuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Jaamo Moocaanico miguiinehi dudɨɨvɨ mahatyɨmequi famoova cojɨtɨ tehesijitɨruuboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jaabo Moocaanifeenedɨ mɨhɨguehi, mihicahi. Tollɨro amɨɨhai poeta caatɨnɨmɨnaafi: Mɨɨhai Moocaani yoto, nooboro, unuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","¿Mɨllɨ bu Moocaani yoto mihicamo mehesamaaijirahi, Moocaani oro eetavota, nɨhɨbamɨ eetavota, guiisi eetavota icano iicanoco? Jillɨ gaifiimɨ: Jillɨ fɨne jeevaabo, noomoro ijeebɨɨfañodɨ esɨcɨnɨmoro eheetavonoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Sɨɨcɨjenaha miyamɨnaa gaajatɨmo iicaunoco Moocaani aatyɨmetɨɨbobadɨ icauhi. Jaanotɨ jisumi Moocaani paryɨ fahɨgova miyamɨnaaco tajɨɨbahi iimitɨco ijeevesuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Jaabo Moocaani oovɨcɨcuuhi miyamɨnaaco ijaadaco aacɨjifucuco. Jaafucugui saafiico ificuubofeenedɨ miyamɨnaaco miyaajɨri jaadusujiibo. Jaanoco diibo guijevefeenetɨ ubuheeteunofañodɨ Moocaani gaajasucuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Jaanoco diito miguijevenebuunatɨ siino mubuheetejinoco uguubuumoro saatoho diiboco dejecuuhi. Jaanotɨ saatoho nuuhi: Jei cusumihacho siino toonotɨ muguubuji, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Jaanoma iicaabo Pablo diitoco jeevesuhinɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Jaarunaa saatoho imiyaavuguumo diibo dojɨcutɨ fuuhi. Jaamofaño icaubo Dionisio Aeropagobaɨvɨ efeefimo bocɨɨbo iicaubo, bu tollɨro saafigo gaigo Damari onoogo, bu saatoho icamo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Jaanobuunatɨ Pablo Atena cuumitɨ fuuhi Corinto cuumijaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Jahɨ atyɨmeubo saafi judiomɨoobo Aquila onoobo, Ponto jiinɨjeooboco, bohonoro mogaima Pricila onoogoma Italia jiinɨjetɨ asaaumɨsi gaseuhi. Tahɨgo aivojɨɨbo Claudio onoobo iinusuuhi paryɨ judiomɨco Roma jiinɨjetɨ ifeequi. Jaamɨsico Pablo baatuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Jaabo diitɨsi ududɨcamaaiño yomonocoro bu dudɨcamaaihicauhi carpa iijano eetavoco. Jaanegui diitɨsima fitafutuubo sano idudɨcamaaiqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Jaabo Pablo fajaguisɨvavɨro sinagogajafaño feehicaubo. Jaabo diitoma ihiimaaboro judiomɨ, griegomɨ icamoco miyaavugusuhicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Jaanaa Sila, Timoteo icamɨsi Macedonia jiinɨjetɨ asaaumɨsi gaseunaa Pablo judiomɨco ɨjɨɨbogohɨgovɨro icacuuhi diitoco foovono neehicaubo: Diiburucu Jesucristo amɨɨhai meteemehicaabo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Jaarunaa diito tɨcovauhi diiboco ɨjɨɨhevemere ɨdicunoono onoomo. Jaanoma iicaabo Pablo diitojaago igaachehuco gaivɨrɨsuubo diitoco ejeevesuno jɨɨbogobadɨ iicano. Jaaboro diitoco nuubo: Amɨɨhai tɨɨjoho amɨɨhaihallɨvɨro icaji, tahallɨvɨ icajitɨno. Jisumitɨro judiomɨ iicatɨmojaagovɨro fuucuuji, nooboro sinagogajatɨ iinuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Jaaboro Justo onoobo Moocaanico ejeecɨvehicaubo iijajaa fuubo sinagogaja uufequeriro iicaujajaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Jaarunaa Crispo onoobo sinagogaja aivojɨɨbo Jesuco miyaavuguuhi paryɨ iijari iicaumo iyotoma. Tollɨro bu sihidɨ Corinto cuumimɨnaa uguubuumoro miyaavuguumo. Jaamoro nitɨsuquimaaiuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jaanobuunatɨ Jesu, fucu gaijafeenedɨ Pabloco nuuhi: Diiguetejirahana, suufenɨtɨɨbo dɨɨbogo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ɨɨma uujoho icahi, mɨɨhaiñooba ɨco mɨllɨ moonɨjitɨhi, jiicuumiri sihidɨ tamiyamɨnaa iicamaño, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Jaanoma iicaabo Pablo fitafutuuhi Corintovɨ saficaba, sificabatɨfeenedɨ icano Moocaani iijɨco diitofeenevɨ jɨɨbogooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Jaarunaa Galion onoobo Acaya jiinɨjevɨ aivojɨɨbotɨ iicaudɨhivɨ. Judiomɨ ɨjɨcucasiumoro Pabloco satyuumo ihaivojɨɨbo itajɨɨba icagahallɨri gɨcɨnɨubojaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Jaamoro diiboco nuumo: Jaanɨ miyamɨnaaco miyaano nuusuuboro feehicahi Moocaanico siibadɨro ijeecɨvequi tajɨɨbafa onootɨbadɨ, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Jaanegui Pablo iimaacuujirunaa ihaivojɨɨbo Galion onoobo judiomɨco nuuhi: Jaanɨ imitɨno iicaaboro sitaaco imoonɨruva amɨɨhai judiomɨ monoonoco miyaano uujoho guubunɨcɨjirahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Jillɨ tɨcovo iimaano, bu tɨcovo momonoro, bu jillɨ amɨɨhai tajɨɨbaro icano iimaanoco: ¿Mɨllɨ bu uujoho moonɨjirahi? Tahɨ amɨɨhairyo mihimibachucasi imogotɨhi uujoho tonehejeri ihiimaanoco, ");
INSERT INTO bmrNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","nooboro diitoco tomañotɨ galluubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jaanoma iicamo paryɨ griegomɨ, sinagogaja aivojɨɨbo Sostene onooboco agaayɨcɨumoro aamɨumo Galion ɨmefeene. Jaarunoco Galion mɨllɨ nuutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Jaanobuunatɨ Pablo toonovɨ gueenene icauhi. Jaadɨ inahabomɨco ifitacuuboro Pricila, Aquila icamɨsima fuumo Cencrea cuumivɨ. Jahɨgo iinigaɨco cɨɨdaubo Moocaani unuunoco ihɨfutusuqui. Jaadɨ ɨjɨcafutuumoro Siria jiinɨjevɨ muuairi fuumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Jaamo Efeso cuumivɨ ɨɨfutuudɨ Aquilamɨsico ificuhinɨuboro sinagogajajaago fuubo. Jaaboro judiomɨma iimaahicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jaaboco inahabomɨ fiitɨuhi. Jaarunaa diibo imuguutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Jaaboro diitoco ifitacuubo nuuhi: Moocaani iimogohachiijɨ siino uumiji, nooboro fuucuubo Efesotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Jaabo Cesarea mɨcuvɨ ɨɨfutuudɨ Jerusalejaa fuubo Moocaani iijamɨnaaco idillutuubo. Jaadɨ Antioquiavɨ fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Jaanobuunatɨ gueenene nijequetɨ tuucuumitɨ fuubo siino dojɨcuvɨro. Jaabo Galacia, Frigia icano jiinɨje cuumineri iicamo Cristotaco quehecutusuuboro feehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jaasumi Efeso cuumivɨ gaseubo Apolo onoobo judiomɨoobo Alejandria cuumioobo iicaubo. Jaabo Caatɨnɨhaamefaño onoonoco imino agaajauboro jɨɨbeguehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jaabo imino jɨɨbogocɨnɨuhi Moocaani jɨɨhaitɨ. Jaabo imo imo foovono Jesutɨ jɨɨbeguehicauhi Jua nitɨcoro gaajauruubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Jaabo Apolo sinagogajafaño quehecuno jɨɨbeguehicauhi. Jaanoco Pricilamɨsi uguubuumɨsiro iijajaago diiboco asatyumɨsiro imino jɨɨbuguuhi Moocaani jɨɨhaitɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Jaabo Apolo Acaya jiinɨjevɨ uufuujinegui inahabomɨ aamusuumoro diibedi aameque caatɨnɨuhi. Tahɨ iicaumo Cristotaco ihacɨqui diiboco imino igaayɨcɨqui. Jaabo Acayavɨ ɨɨfutuudɨ sihidɨ amusuhicaubo Moocaani imihiijɨri imiyaavuguumoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Jaabo mityano judiomɨco miyamɨnaafeenevɨ taajahicaubo, Caatɨnɨhaamefeenedɨ diiburucu Jesu, Cristo iicanoco diitoco ɨjɨɨbogoobo. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo Corinto cuumivɨ iicaunaaca Pablo ifagajɨnofeenedɨ ofoocɨnɨjɨri fuubo Efesovɨ. Jahɨ atyɨmeubo fiivaamova Cristotaco. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Jaamoco dilluubo: ¿Amɨɨhai Moocaani Gaijaco magaayɨcɨuhi mimiyaavuguusumi? nooboro. Jaanegui diito iimusuuhi: Mɨɨhai magaajatɨhi Moocaani Gaijaco magaayɨcɨnoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Jaanegui siino Pablo diitoco dilluuhi: ¿Coyomo nitɨco jana amɨɨhai magaayɨcɨuhi? nooboro. Jaanegui iimusuumo: Etɨ bu Jua initɨunoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Jaanegui Pablo nuuhi: Jua miyamɨnaaco nitɨhicauhi iheedehifiico ejeevesuno jɨɨbogobadɨ iicanoco. Jaabo tollɨro bu neehicauhi tabuunatɨ asaaboco mimiyaavegueji neehicauhi Jesuditɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Jaanoco uguubuumoro nitɨsuquimaaiuhi Jesucristo momofeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Jaadɨ Pablo ihuseque diitohallɨvɨ ificuuneri Moocaani Gaija diitohallɨvɨ niituuhi. Jaaneri diito sijɨɨjeri iimaaumo. Jaamoro Moocaani iijɨco jɨɨbeguehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jaamo paryɨ fahuseecɨ motɨhaitɨ miimɨsiicɨdɨmou. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Jaabo Pablo toonovɨ minɨhɨbacɨ, sanɨhɨba icanohachuta sinagogajafaño feehicauhi ñɨhicugotɨɨbo miyamɨnaaco ijɨɨbeguequi. Jaabo ihiimaaboro miyamɨnaaco miyaavugusuhicauhi Moocaani aivojɨ iijɨco. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Jaarunaa saatoho mityano ifiico eesɨcɨnɨumoro miyaavuguutɨhi. Jaamoro Jesu jɨɨbogotɨ miyamɨnaafeenevɨ imitɨno iimaahicauhi. Jaanoma iicaubo diitotɨ sihɨgovɨ fuubo. Jaaboro Cristotaco ɨɨcɨuboro satyuubo Tiraano onoobo aameneque ɨjɨɨbequehicajafaño. Jaamoma fafucuvaacɨvɨro iimaahicaubo mificabacɨ tɨcovovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jaamaño paryɨ Asia jiinɨjeri iicaumo Moocaani iijɨco guubuuhi Jesutɨ ɨjɨɨbeguehicaunoco judiomɨ, bu judiomɨ iicatɨmeheje icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Jaabo Pablofeenedɨ Moocaani sihidɨ ejeevano mityaco moonɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Jaamaño filluchehuno, bu gaachehuno icaruno diibo ifiivɨ ɨjɨvonehejeque asatyeneri iguihuvameheje buheehicauhi, bu iimitɨno ɨjɨmɨ diitotɨ iinehicauhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jaarunaa saatoho judiomɨ gaifiimɨ ɨɨguefifimo: Mɨɨhai ɨjɨmɨco magañɨɨfihi, noomoro feehicauhi. Jaamoro Aivojɨɨbo Jesu momoco nɨsuumo iimitɨno ɨjɨmɨco igañɨɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jillɨ moonɨhicaumo sahuse juugahusetɨ miimɨsiicɨ ɨdɨɨmo icamo saafi Esceva onoobo seeme. Jaabo judioobo, sacerdotemɨ aivojɨɨbou. Jaanofeene safoono ɨjɨco nuumo: Ɨco matajɨɨbahi Pablo ɨjɨɨbeguehicaabo Jesu momofeenedɨ saafiitɨ dihiinequi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Jaarunaa diitoco ihɨjɨ iimusuuhi: Jesuco uujoho gaajahi, tollɨro Pabloco gaajacuuhi icano. ¿Jaanotɨ nacu mɨɨjoho amɨɨhai? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Jaasumiro ihɨjɨma iicaubo diitohallɨvɨ tɨgaifiivuuhi. Jaaboro diitoco guiinonɨubo sefano diitoco ahaamɨɨboro iijatɨ gaasuubo diitoco utujaacuuboro sɨcaimehejeque. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jaanoco paryɨ Efeso cuumiri iicaumo judiomɨ, bu judiomɨ icatɨmo icano agaajaumoro sihidɨ iguiuhi. Jaamoro Jesu momoco sihidɨ imehicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tollɨro bu sihidɨ imiyaavuguumeheje itɨconɨ imitɨno iicahicaunehejeque jɨɨbogomoro saahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Jaabadɨro bu sihidɨ apichuco ihiimaahicaumo ihapichuno aameneque ɨsɨvaumoro miyamɨnaafeenevɨ jɨgasuhicauhi ijaada cincuenta mildɨno tɨcovovɨ nɨhɨbamɨ icanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Jillɨ Moocaani iijɨ guiraatonoro feehicauhi imityafeenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Jaanobuunatɨ Pablo fuuguuhi siino Macedonia, Acaya icano jiinɨjejaago. Jaamañotɨ Jerusalevɨ fatyuguubo. Jaanobuunatɨ tollɨro Roma cuumivɨ feeji, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Jaaboro Macedoniavɨ galluubo Timoteo, Erasto icamɨsi ihamusumɨnaatɨsico. Jaanobuuna diibo Asia jiinɨjevɨ ifitafutuubo tomañovɨ gueenene icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tusumi sihidɨ ñaaɨumo Jesu jɨɨbogotɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Saafi Demetrio onoobo Jesuco iimogotɨɨboro miyamɨnaaco fajɨɨnɨubo Jesujaagodɨ iicatɨmo iicaqui. Jaabo nɨhɨbamɨri eetavehicauhi diosa Diana onoogo iija ɨjɨnɨtagayɨɨnoco. Jaaneri sahomonocoro diibobadɨ ududɨcamaaimo sihidɨ nɨhɨbamɨco gaayɨcɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Jaamoco paryɨ sano iigaiyɨɨcɨuboro nuubo: Amɨɨhairyo magaajahi jidudɨcamaajehallɨvɨ sihidɨ mɨɨhai nɨhɨbamɨco magaayɨcɨhicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Jaano icanaaca amɨɨhairyo maatyɨmemere muguubuhicacuuhi diibo Pablo: Miyamɨnaa eetavomo diosmɨ icatɨmo, nooboro efeehicanoco. Jaamaño miyamɨnaaco: Miyaano, nuusuuboro feehicaabo. Jaano jiicuumivɨro icatɨno fahɨgovavɨro jino Asia jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Jaamaño mududɨcamaaje gañɨɨcafeteji. Jaabadɨro bu sihidɨ ejeevago diosa Diana jeecɨvo iija ibocɨma chahacuuji. Jaadɨ jillɨtɨ diigoco bocɨgucuujitɨrumo paryɨ Asia jiinɨjemɨnaa, bu paryɨ jiinɨjemɨnaa icamo ejeecɨvehicarugoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Jaanoco uguubuumoro, sihidɨ sɨfiiratuuhi. Jaamoro sefano coovadiivuumo: ¡Imino diica Diana efesiomɨ aivojɨgo idiicago! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Jaaneri faacuumiro añaaɨvumoro Gayo onoobo, Aristaco onoobo icamɨsi macedoniaotɨsi Pablo gataavomɨnaatɨsico agaayɨcɨumoro satyuumo sinehejeque ihiimaaqui iigaivojafaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Jaanegui Pablo diitojaa fuujirahi miyamɨnaama iimaaqui. Jaarunaa Cristota diiboco galluutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Jaabadɨro bu saatoho Pablo nahabovamɨnaa Asia jiinɨje aivojɨto iicaumo saatohoma jɨɨbogoco galluuhi: Diitofaño feediibo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Jaanohachuta iigaivuumo coovadiicɨnɨhicauhi saatoho siibadɨ onoono, saatoho siibadɨ onoono icano ñaaɨcɨnɨhicaumo. Jaanoco sihidɨ samañooto gaajautɨmo jinejefiri fɨne iigaivuunoco. Jaamoro sɨcamañehejeque coovadiinamaaihicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jaanegui diitofeeneri iicaumo Alejandro onooboco toonotɨ imino jɨɨbuguumo. Jaamoro judiomɨ diiboco chimucumoro satyuuhi miyamɨnaama diitohallɨvɨ ihiimaaqui. Jaanegui imiyamɨnaaco ihuseri faguuruubo illɨɨvequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Jaarunaa Ihalejandro judiomɨyoobo iicaunoco agaajacɨumoro sefatuumo janaanɨcɨvɨro famooro ocoovadiinamaaiumo, siino minoocɨ nɨhɨba oovo tɨcovoocɨvɨ: ¡Imino diica Diana efesiomɨ aivojɨgo idiicago! noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Jaamo ɨllɨɨvuudɨ tuucuumio aivojɨto nahabonɨmɨnaafi miyamɨnaaco nuuhi: Efeso miyamɨnaa, mɨɨro famooro miyamɨnaa gaajahi jiicuumivɨ sihidɨ ejeevago diosa Diana caamotɨ Mercurio onoobo iicahɨgotɨ ihɨjɨ iniituugoco. Jaago iija abajacuumi Efeso. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Jaanoco bu ¿mɨɨjoho tuunamaaijirahi? Jaanegui mɨllɨvucu. Jaamoro imino esamaaitɨmoro siibadɨ momoonɨdino. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mɨɨro jiitɨsi gaifiimɨsico amɨɨhai mɨsɨvahi amɨɨhai diosa Dianatɨ imitɨno omoonɨmɨsiro ɨdicuno ihiimaatɨmɨsico. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Jaanotɨ Demetrio, bu diiboma ududɨcamaaihicamo icano sitahallɨvɨ ihiimaajihachiijɨ jaafa fagomɨnaama toneheje imibachujafaño toonoco iimaamo iimibachucasiqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Jaanotɨ sinehejeque mihigaivomoro mihiimaajihachiijɨ aivojɨto atajɨɨbanɨcɨbadɨ iminoro mihigaivomoro mihiimaa. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Jillɨ ñaaɨmoro mihicamaño jimañoo jiinɨje aivojɨɨbo mɨɨhaiditɨ imitɨno neejirahi. ¿Jaanoco mɨllɨ mɨɨhai mihiimusujirahi jino mañaaɨnotɨ? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Jillɨ nooboro diitoco llɨɨcaruubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Jaamo ɨllɨɨvuudɨ Pablo Cristotaco coovaubo ijɨɨbeguequi. Jaaboro diitoco ifitacuuboro fuucuubo Macedonia jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Jaabo paryɨ Macedonia jiinɨjeotoco emeecɨɨboro, equehecutusuuboro icano fuuhi. Jaadɨ ɨɨfutuubo Grecia jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Jahɨgo icaubo minɨhɨbacɨ, sanɨhɨba icano. Jaadɨ meenegari fuujiruubo Siria jiinɨjevɨ. Jahɨgo judiomɨ diiboco agaicaauguunoco agaajacɨuboro dojɨcuvɨro Macedoniavɨ uumiubo siino. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Jaaboma gataavuumo Sopater onoobo Berea cuumioobo, bu Aristacu, Segundo icamɨsi Tesalonica cuumiotɨsi, bu Gayo, Timoteo onoomɨsi Derbe cuumiotɨsi, tollɨro bu Tiquico, Trofimo onoomɨsi Asia jiinɨjeotɨsi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Jaamo ɨmegavɨ ufuumoro ɨɨfutuumo Troa mɨcuvɨ mɨɨhai Pablomɨma mihicaumoco iteemetequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Jaadɨ jari mɨɨhai ijɨcutaama achahano maahuno, jɨɨbaimobuunatɨ, Filipo cuumitɨ meenegari mufuuhi. Jaamo sahuse fucuvatɨ Troa mɨcuvɨ mɨhɨfutuuhi. Jahɨgo sajaguisɨ toono mihicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Jaanaa jaguisɨbuunatɨ Cristota igaivuumo panco iquisicuqui. Jaanaa Pablo ufuucujinegui jɨɨbogooboro fucuvuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Jaamo igaicɨnɨuhi caamo mecufaño sihidɨ cuugahuno aachɨcɨnɨhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Jaanaa saafi sɨcafefi Eutico onoobo gɨcɨnɨuhi iventanavɨ. Jaanaa Pablo gueenene ɨjɨɨbugumaño sihidɨ diiboco cɨgara aivuuhi. Jaaneri ɨcɨgaubo tercer pisotɨ caamotɨ acutuuhi. Jaaboco gañiiyɨcɨmo chuumucuuboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Jaanegui Pablo iniituuboro diiboco ihiibɨcɨuhi. Jaaboro nuubo inahabonɨmɨnaaco: Mihiguetedino. Jaanɨ buheebe, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Jaadɨ Pablo caamo ufuuboro ipanco iquisicuuboro ɨɨfunoco machumo. Jaanobuunatɨ siino ihiimaaboro seseeveubo. Jaadɨ fuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jaanaa isɨcafefico satyuumo buheecuuboco. Jaaneri famooro sihidɨ imo imo icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Jaanaa mɨɨhai ɨmegavɨ mufuuhi meenegari Ason cuumivɨ toonotɨ Pabloco meteemequi, diibo jɨɨhairi asaajiiboco. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Jahɨ diiboco mahatyɨmedɨ Asontɨ meenegari saano mufuucuhi. Jaamo Mitilene cuumivɨ mɨhɨfutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Jaano seseevedɨ Quio cuumi cojɨdɨ mafatyuuhi. Jaano sifucutɨ Samo mɨcuvɨ mɨhɨfutuumo majaguisɨhi Trogilio cuumivɨ. Jaano sifucutɨ mɨhɨfutuuhi Mileto cuumivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Jillɨ momoonɨuhi Pablo gueenene Asia jiinɨjevɨ icanoco iimuguutɨmaño Efeso cuumivɨ footɨɨbo iicaqui goovano Jerusalevɨ ihɨfetequi, tahɨ Pascua jɨɨbaimoco ifatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Jaabo Mileto cuumitɨ Pablo cuuhuvauhi Efesojaagovɨ Moocaani iija quillahutoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Jaamo asaaumoco Pablo nuuhi: Amɨɨhairyo magaajahi Asia jiinɨjevɨ icausumi iicahicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mɨɨro fahiijɨvaro amɨɨhaifeenevɨ icahicauhi Aivojɨɨbo Jesuco jeecɨvooboro: Uujoho sihidɨ gaajahi, nootɨɨbo. Jillɨ icahicauhi sihidɨ ɨdaasuno icahicauhi judiomɨ uco aamɨgueneri tahaallɨɨ tofaihuco filluuboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Jaarunaa suufenɨtɨɨbo jɨɨbeguehicauhi amɨɨhaidi iiminoco miyamɨnaafeenevɨ, bu tollɨro iijanofaño icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judiomɨco, bu tollɨro judiomɨ icatɨmoco icano ɨjɨɨbogooboro neehicauhi: ¡Amɨɨhai eedeehifiico mejeevesu Moocaani ɨmefeenevɨ! ¡Jaamoro Aivojɨɨbo Jesucristoco mimiyaavogo! nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Jaabo jisumi uujoho Jerusalevɨ feeji Moocaani Gaija tajɨɨbari, tahɨgo uco omoonɨjinoco gaajatɨɨboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Jaarunaa Moocaani Gaija uco faacuumivavɨ ɨjɨɨbogooboro neehicahi: Ɨɨjoho Jerusalejaago ɨdaasuno cɨvojafaño diicaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Jaarunoco uujoho esamaaitɨhi. Tafiico gaijɨtɨhi, ɨdɨɨnocoro imeguehi tajɨɨhai niquejevɨ ɨɨfotonoco, bu tollɨro uco Aivojɨɨbo Jesu imino jɨɨbogoco atajɨɨbahinɨno Moocaani imihusetɨ ɨjɨɨbogonoco imivequi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Jisumi gaajacuuhi uujoho saatohobatɨ amɨɨhaifeenevɨ Moocaani aivojɨ iijɨco ɨjɨɨbogomotɨ siino uco mahatyɨmecujitɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jaanegui jisumi uujoho amɨɨhaico neehi: Amɨɨhai imitɨ jaadaco jisu amɨɨhaihallɨvɨro icacujino, tahallɨvɨ icacujitɨno. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Jillɨ amɨɨhaico jɨɨbeguehicahi paryɨ Moocaani iijɨco tuunamaaitɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jaanegui amɨɨhairyo mehesɨcɨnɨ. Tollɨro imino motoomo igaivomɨnaaco Moocaani Gaija amɨɨhaico tajɨɨbauhi diitoco meteemequi atajɨɨbaunoco. Aivojɨɨbo Jesu imiyatɨɨjeheri diitoco ajaaducumoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Jaanotɨ bu gaajahi uujoho, ofoonobuunatɨ saatoho amɨɨhaifeenevɨ gaseji amɨɨhaico ifinɨsuqui jɨcu ovejamɨco ifinɨsunɨcɨbadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mɨɨro amɨɨhaifañotɨ saatoho agañiivomoro jɨɨbeguejimo sɨcamañehejeque miyaanobadɨ, toonoguiinodɨ amɨɨhai mimiyaavogonoco mejeevesuqui. Jaanegui mehesɨcɨnɨ, ");
INSERT INTO bmrNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","majabajeevedino mificabacɨ, saficaba icano tɨcovovɨ paryɨ amɨɨhaico fafucuvaacɨvɨro tahaallɨɨ tofaihuco gañɨɨboro ɨjɨɨbeguehicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Jaanegui jisumi tañahabomɨ Moocaanima mihica. Diibo imihiijɨ jɨɨbogoco mehesɨcɨnɨ. Jaano toonofeenedɨ sefano mihicahi, jaano amɨɨhaico Moocaanico ejeecɨvehicamofeenevɨ ificuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Uujoho saatoho nɨhɨbamɨco, gaachehuco icano imeguehinɨtɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Amɨɨhairyo magaajahi tahuseri ududɨcamaaiboro ucuujɨvaachunoco ɨɨcɨhicanoco, tollɨro bu uuma iicamedi ɨɨcɨhicanoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mɨɨro saicɨno amɨɨhaico jɨɨbeguehicahi jillɨ mududɨcamaaiqui. Jaamoro ucuujɨvaachuuboco tooneri mahamusuqui Aivojɨɨbo Jesu unuubadɨ: Imicani icaabo sitaaco aacɨɨbo, toonoco agaayɨcɨɨbo janaanɨcɨvɨ, unuubadɨ. Jaanoco mehesɨcɨnɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Jaaboro ememuɨɨvuuboro diitoma Moocaanima iimaaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Jaadɨ famooro Pabloma ihiibɨcɨcasiumoro taaumo, ");
INSERT INTO bmrNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","sihidɨ ɨɨdaasuvumoro Pablo diitoco: Ofoodɨ uco mahatyɨmecujitɨhi siino, unuuneri. Jaamoro diiboco ficujeumo meenegafaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jaamo monahabomɨco mejeevesuumoro meenegari sanotɨcovoro mufuuhi Cos onoochugaivɨ. Jaano sifucutɨ Roda cuumivɨ. Jaamañotɨ Patara cuumivɨ mɨhɨfutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pataratɨ Fenicia cuumijaa ufuugaco mahatyɨmeugari mufuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Jaamo mafatyuumo mahatyɨmeuhi Chipre onoochugaico monaninaagonovɨ iicachugaico. Jaamo mufuuhi Siria jiinɨjevɨ Tiro cuumijaago sinehejeque ificutuugari. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Jaamo tahɨ Cristotaco mahatyɨmeuhi. Jaamoma toonovɨ mihicauhi sajaguisɨ tɨcovovɨ. Jaamo diito Pabloco jɨɨbuguuhi Moocaani Gaijari: Jerusalevɨ feejirahana, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Jaadɨ tojaguisɨ ifinɨudɨ mufuumo famooro mogaimɨma, iseemema icano mɨɨhaico ficutuumo. Jaamo mɨhɨfutuhi tuucuumijɨnivɨ. Jaamoro jiinɨgaibaahohallɨvɨ mememuɨɨnamaaiumoro Moocaanima mihiimaauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Jaamoco mifitacumoro mɨjɨcafutuhi meenegafaño. Jaanotɨ diito dojɨcuvɨro uumiumo iijanojaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Jaamo Tiro cuumitɨ mufuumo mɨhɨfutuuhi Tolemaida cuumivɨ. Jahɨ monahabomɨ Cristotaco midilluhi. Jaamo diitoma mihicauhi safucu tɨcovovɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Jaano sifucutɨ mɨɨhai Pabloma mufuumoro Cesarea cuumivɨ, Felipe Cristo iijɨ jɨɨbogomɨnaafi iijafaño mɨjɨcafutuuhi, sahuse juugahusetɨ miimɨsiicɨ ɨdɨɨnomoobo diaconomɨobo iijafaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Jaabo Felipe igueenemehejedɨmo iseemema icauhi sano gaigoomɨro ataajevatɨmo. Jaafigueje Moocaani diitoco onoonoco iimaahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Jaamo mɨɨhai toono fiiva fucuva mihicaunaaca, Moocaani iimaamɨnaafi Agabo onoobo Judea jiinɨjetɨ gaseuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Jaabo mɨɨhaico emeecɨɨboro Pablo niivɨgai meeheque ɨcɨuhi. Jaaboro toomeeheri ifiico itɨhaiño, ihusene icanoco isisɨuboro nuuhi: Moocaani Gaija jillɨ neehi: Jerusalevɨ judiomɨ jimeehe abajaabo ofooboco jillɨ sisɨji. Jaamoro siicuumiotoco acɨjimo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Jaanoco muguubumoro Pabloco munuuhi, Jerusalevɨ ifootɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Jaarunaa Pablo iimusuuhi: ¿Collɨhi uuri mataahi, uco mɨhɨdaasuvusuqui? Jaarunoco uujoho iguitɨhi uco isisɨmoro agaicaaujinoco Aivojɨɨbo Jesu momohallɨtɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Jaanoco gaajacuruubo imuguuhi ofoonoco. Jaanegui mɨllɨ munuucuutɨhi. Jillɨro: Jɨɨ, munuuhi tahɨ Moocaani Aivojɨɨbo jeebɨɨ onoobadɨ diica, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Jaanobuunatɨ mihimibaivumoro Jerusalevɨ mufuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Jaamoma saatoho Cesarea cuumiri iicaumo Cristota gataavuuhi. Jaamofaño bu saafi icauhi Chipre onoochugaiobo Mnason onoobo. Jaabo iijafaño mɨhɨfutuumoro gueenene mihicahicauhi sɨɨcɨjetɨro Cristoco imiyaavuguubo iicaubo iijafaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jaamo Jerusalevɨ mɨhɨfutuudɨ monahabomɨ imo imo mɨɨhaico gaayɨcɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Jaano sifucutɨ mɨɨhaima Pablo fuuhi Jacooboco memeecɨtequi. Jahɨgo tollɨro icaumo famooro quillahuto. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Jaamoco Pablo idilluuboro jɨɨbuguhi, paryɨ Moocaani diibo jɨɨbogofeenedɨ judiomɨ iicatɨrumofeenevɨ omoonɨunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Jaanoco uguubumoro Moocaanico imuumo. Jaamoro Pabloco nuumo: Fañɨ, imiruno aivono. Jaarunaaca ɨɨro gaajacuuhi judiomɨtɨ sihidɨ ajashutɨmo, imiyaavugucuumo famooro Moise atajɨɨbaubadɨ iicaqui ejenaauhicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Jaamoro neehicahi ɨɨjohova dɨɨbeguehicahi paryɨ judiomɨ siicuumijejaa iicamoco, Moise atajɨɨbaunoco mimiyaaveguedino. Tollɨro bu seeme meeheque miquitɨcujitɨhi, siino mojeevamaajebadɨ momoonɨcujitɨhi, ɨɨjohova neehicahi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Mɨllɨ jaanoco momoonɨji? Ɨɨjoho jinovɨ agasecuunoco agaajacumoro ñaaɨvejimo. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jaanegui jillɨ moonɨ: Mɨɨhaifaño icamo igueenemehejedɨmo gaifiimɨ Moocaanico unuucuunoco omoonɨjimo. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jaanegui diitoma ofooboro sacerdotemɨ unuubadɨ amɨɨhai ifiinoco mihimibachu. Jaaboro toonoco diitedi daadu. Jaanobuunatɨ inigaɨnoco cɨɨdasujimo. Jaanotɨ famooro gaajajimo ɨɨditɨ miyaano iicatɨnoco ihiimaahicanoco. Jillɨ ɨɨjoho imihusene Moise tajɨɨbajɨco edeetavehicanoco gaajajimo. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Jaanotɨ saatoho judiomɨ iicatɨmo imiyaaveguemedi, aameneque magalluumoro matajɨɨbahi: Ɨjɨnɨtaco ejeecɨvucuunoco meheetavucuudino. Jaabadɨro tɨɨjohoco mahaduudino, bu udusuucɨmoro amacanɨsumehejeque muduudino, bu saatohoba ataabavatɨmo jahisihijedɨ gaigoomɨma icadino icano, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Jaanegui Pablo diito igueenemehejedɨmo iicamoco ɨɨcɨuboro satyuuhi. Jaano sifucutɨ diitoma ifiinoco iimibachumoro fuumo templojafaño ijɨɨbeguequi, ifiinoco iimibachuno imivocafutuujinoco. Jaadɨ ijeecɨvonoco ificujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Jaamo sajaguisɨco imivusutɨmaacaro judiomɨ Asia jiinɨjetɨ agaseumo atyɨmeuhi Pablo templojafa icaaboco. Jaamoro tuucuumio miyamɨnaaco añaaɨsumoro Pabloco gaayɨcɨumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Jaamo agaibacasimoro nuuhi: Israel miyamɨnaa, mɨɨhaico mahamusu. Jaanɨ fahɨgovadɨ feehicahi imitɨno jɨɨbogooboro israelmɨnaahallɨvɨ, bu Moise tajɨɨbajɨhallɨvɨ icano. Jaaboro jino saatoho griegomɨco jiija templojafaño sɨvaabo toojaco imɨhɨninɨqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Jillɨ neehicaumo Efeso cuumioobo Trofimo onooboco Pabloma tuucuumivɨ aatyɨmeumoro: Fɨne diiboma templojafaño foobo, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jaanoco famooro tuucuumioto imiyaavuguumoro Pablojaa saaumo jinoomoro. Jaadɨ diiboco agaayɨcɨmoro templojatɨ sihɨgovɨ sefano satyuumo. Jaamoro goovano foboocɨumo temploja guhuganoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Jaamoro diiboco gaicaaujirumo. Jaarunaa jɨɨbogo gaseuhi amocasimɨnaa aivojɨɨbojaago, famooro Jerusale cuumioto añaaɨunojɨɨbogo. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Jaanegui ihaivojɨɨbo, ihamocasimɨnaama, saatoho ihaivojɨtoco icano igaiyɨɨcɨubo. Jaamo jinoomoro fuuhi imiyamɨnaa iicauhɨgo. Jaamo miyamɨnaa imiya aivojɨɨboco, bu amocasimɨnaaco icano aatyɨmeumoro Pabloco aamɨcuutɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Jaanegui imiya aivojɨɨbo ifiitɨvuuboro tajɨɨbaubo Pabloco cɨvojamɨnaafitɨ isisɨqui mihicɨri jɨgaiñohicɨri. Jaadɨ dilluubo: ¿Mɨɨjoho diibo? ¿Jinejeque moonɨɨbo? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Jaanegui coovadiinamaaihicaumo saatoho siibadɨ onoono, bu saatoho siibadɨ onoono icano. Jaanoco imiya aivojɨɨbo guubutɨɨbo diito iimaauno toovodɨ. Jaanegui diibo galluubo esefano cɨvojano iicauhɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Jaadɨ toojafaño ɨɨfutuudɨ goovano cuuhuri, isoldaomɨ Pabloco ihiibɨmoro satyuhi miyamɨnaa diiboco agaicaaujiruneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Jaamo sihidɨ miyamɨnaa idojɨcutɨ bucasiuhi: ¡Magaicaau! noomoro sefano. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Jaabo Pabloco toojafaño ɨjɨɨhacucuuneguiiha nuubo ihaivojɨɨboco: Imeguehi ɨɨma ihiimaanoco, nooboro. Jaanegui iimusuubo: ¿Nacu ɨɨjoho gaajahi griego iijɨco? ");
INSERT INTO bmrNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Nacu ɨɨjoho egipciobo diicatɨhi? ¿Johono safoono aivojɨtojaago ɨsɨfiiratuuboro cuatro mildɨmo gaicaaumɨnaaco sɨcaihɨgovɨ asatyuubo diicatɨhi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Jaanegui Pablo nuuhi: Uujoho judiomɨnaafi Tarso cuumi, Cilicia jiinɨjeocuumi obocɨcuumiobo. Jaanegui uco musuufenɨ miyamɨnaama iimaaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jaanegui ihaivojɨɨbo Pabloco iimaasuuhi. Jaabo cuuhutɨ ujulleeveuboro ihuseri faguubo miyamɨnaa illɨɨvequi. Jaadɨ ɨllɨɨvɨudɨ iimaaubo hebreo iijɨri: ");
INSERT INTO bmrNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Caanimɨ, bu tañahabomɨ icamo muguubunɨcɨ amɨɨhaifeenevɨ jino ihiimaanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Jaanoco uguubumoro hebreo iijɨri ihiimaaunegui llɨɨvɨumo. Jaanegui Pablo janaanɨcɨvɨ ihiimaauboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Uujoho judiomɨoobo Tarso cuumi Cilicia jiinɨjevɨ ifiivoobo. Jaaruubo jusihi jino Jerusale cuumivɨ. Jaabo uco Gamaliel jɨɨbeguehicauhi imino sɨɨcɨjemɨnaa tajɨɨbajɨco. Jisumi amɨɨhai Moocaanico sefano imino mejeecɨvobadɨro uujoho jeecɨvehicahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Jaabo uujoho safoono Cristotaco ubucasiuboro gaicaauhicauhi, bu isisɨɨboro satyehicauhi gaifiimɨ, gaigoomɨ icamoco cɨvojafaño diitoco ijɨɨhacuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Jaanoco sacerdotemɨ aivojɨɨbo, famooro quillahuto iicamo miyaano iicanoco gaajahi. Jaamo aameneque uuma galluuhi monahabomɨ judiomɨdi. Jaanegui uujoho Damasca cuumivɨ ufuuboro Cristotaco sɨvaujirahi Jerusalevɨ ɨdaasuno imoonɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Jaabo uujoho jɨɨhairi fuunaaca gadɨcɨɨba Damascatɨ fiitɨcuurunaaca imimañobatɨ niquejefañotɨ uco sefano achɨcɨuno. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Jaaneri uujoho baavɨ aacutuubo guubuuhi, niquejefañotɨ uco unuunoco: Saulo, Saulo, ¿collɨhi uco bucasihi? noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Jaanegui iimusuuhi: ¿Mɨɨjoho ɨɨjoho, aivojɨɨbo? nooboro. Jaanegui uco iimusuuno: Uujoho Jesu Nazareoobo iicaaboco, ɨɨjoho bucasihi, noonoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Jaaneri uuma ufuumo sihidɨ igutuuhi, tollɨ onoonoco uguubuumoro. Jaarumo mɨɨhaiñoobaco atyɨmeutɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Jaanegui uujoho nuuhi: Aivojɨɨbo, ¿jaanegui mɨllɨ iicanoco diimeguehi? nooboro. Jaanegui Jesu uco nuuhi: Gañiivo. Jaaboro difo Damasca cuumijaago tahɨ ɨco idiicajinoco ijɨɨbeguequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Jaabo uco aachɨcɨuneri tahaallɨɨ jaabatuuhi. Jaanegui tañahabonɨmɨnaa uco tahusetɨ agaayɨcɨumoro feetuucumoro satyuuhi Damascavɨ ihɨfutusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Jaanaa tahɨ icaubo saafi Anania onoobo sihidɨ imiyaaveguehicaubo Moise tajɨɨbajɨco. Jaabeditɨ judiomɨ Damascavɨ iicamo famooro imino iimaahicaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jaabo Anania uco emeecɨvaubo tajaago ujulleeveuboro uco nuuhi: Tañahabo Saulo, imino siino daatyɨme, nooboro. Jaasumiro uujoho diiboco atyɨmecuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Jaanegui Anania uco nuuhi: Motadimɨ Dios ɨco ficuhi diibo jeebɨɨ iimogobadɨ iicanoco gaajaqui, bu Iimiiboco ihatyɨmequi, bu diibo iimaaco guubuqui icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Jaabo ɨɨjoho faabohoco dɨɨbegueji paryɨ adaatyɨmeebere uguubunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Jaanegui jisu, ¿collɨhi gañiivoobo nitɨsuquimaaitɨhi? Imino miyaavogoobo, Aivojɨɨbo Jesu memeri dihimitɨ initɨcafetequi, nooboro Anania uco nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jaadɨ Jerusalevɨ dojɨcuvɨro uhuumiudɨ fuuhi templojafaño Moocaanima iimaaqui. Jaabo iimaanaaca gaijafañodɨ Aivojɨɨboco atyɨmeuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Jaabo uco nuuhi: Goova difo Jerusaletɨ. Uutɨ ɨɨjoho onoonoco miyaaveguejitɨmo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Jaanegui Ihaivojɨɨboco nuuhi: Diito paryɨ gaajahi uujoho sinagogajafaño ofooboro ɨco imiyaavogomoco cɨvojafaño asatyooboro ahaamɨhicaunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Jaabadɨro Esteba dihiimaamɨnaafi tɨɨjohoco agañɨɨusumi uujoho ujulleecɨnɨɨboro diiboco agaicaaumofañodɨ icauhi, diito gaachehunoco utuumuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Jaaruuboco Aivojɨɨbo Jesu uco nuuhi: Difo. Ɨco galluuji tehesino judiomɨ iicatɨmojaagovɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Jaanoco jihachutaro uguubunɨcɨumoro sefano nuumo: Diiboco magaicaau. Mihimogotɨhi diibo iicanoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Jaamoro sihidɨ ocoovadiivumoro igaachehunoco sefano caamovɨ gavaracuumo, bu baiguiijɨnoco ɨɨcɨmoro gaifificɨhicaumo caamovɨ icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jaanegui ihamocasimɨnaa aivojɨɨbo tajɨɨbauhi Pabloco cɨvojafaño isatyequi. Jaaboro saatohoco tajɨɨbaubo Pabloco niivɨgai meeheri ihaamɨqui. Jaaneri ijɨɨbeguequi collɨhi diibotɨ sihidɨ miyamɨnaa añaaɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Jaaboco ihaamɨqui sisɨumo. Jaanegui Pablo sahaivojɨɨbo ifiitɨno iicauboco nuuhi: ¿Nacu ɨɨjoho niivɨgai meeheri dahaamɨjirahi romanomɨooboco, itɨconɨ mɨllɨ iicanoco gaajatɨɨboro? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Jaanoco diibo uguubuuboro imiya aivojɨɨboco jɨɨbugutuubo. Deesɨcɨnɨ omoonɨjinoco. Jaanɨ romanoobo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Jaanegui ihaivojɨɨbo Pablovɨ ifiitɨvuuboro dilluuhi: ¿Naava miyaano ɨɨjoho romanoobo? nooboro. Jaanegui Pablo: Jɨɨhɨ, nuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Jaanegui ihaivojɨɨbo nuuhi: Uujoho sihidɨ jaaduhinɨcuuhi romanoobo icaqui, nooboro. Jaanegui Pablo nuuhi: Jaanotɨ uujoho romanoobo sahiijɨtɨro fiivuuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Jaanegui aamɨtɨmoro diibeditɨ sihɨgovɨ minifutuumo. Jaanoco ihaivojɨɨbo romanooboco isisɨnoco agaajauboro ñɨhicugucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Jaanoco sifucutɨ ihamocasimɨnaa aivojɨɨbo imuguuhi agaajanoco; mɨllɨtɨ Pabloditɨ judiomɨ ihiimaahicanoco. Jaanegui sacerdotemɨ aivojɨtoco, famooro fagomɨnaaco icano tajɨɨbaubo iigaivequi. Jaadɨ Pabloco ijɨgaiñohinoco isinaayuuboro satyuhi diito ɨmefeenevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Jaabo Pablo diito judiomɨ fagomɨnaaco aatyɨmeuboro nuuhi: Amɨɨhai tayoto, uujoho imino icafihi imino tajeebɨɨco esɨcɨnɨmañovɨ sajeebɨɨ Moocaani ɨmefeenevɨ icahi jisumihachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Jaanegui Anania onoobo sacerdotemɨ aivojɨɨbo tajɨɨbauhi Pablo cojɨri iicaaboco Pabloco ihaamɨqui iijɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Jaarunaa Pablo iimusuhi: Moocaani ɨco aamɨji. Ɨɨjoho miyamɨnaa ɨmefeenevɨ imiibobadɨ difiico omoonɨhicaaboco. ¿Jaabo nacu toono gɨcɨnɨhi Moocaani tajɨɨbafañodɨ tahimitɨco daatyɨmequi? Jaamoro bu uco mahaamɨsuhi Moocaani tajɨɨba onootɨbadɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Jaanegui saatoho nuuhi: ¿Tollɨ aivo ɨɨjoho neehi obocɨɨbo Moocaani sacerdoteditɨ? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Jaanegui Pablo nuuhi: Tayoto, uujoho gaajatɨhi diibo jahi obocɨno sacerdote iicanoco. Mɨɨro Moocaani Caatɨnɨhaamefaño noono: Diicuumi aivojɨɨbotɨ imitɨno diimaajirahana, noonoro, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Jaabo Pablo, diito fagomɨnaatɨ saatoho saduceomɨ iicaumoco, bu saatoho fariseomɨ iicaumoco icano agaajauboro sefano nuuhi: Tayoto, uujoho fariseomɨoobo guihirubimɨ fariseomɨ iicaumaño. Jaaruubo uujoho uchuumuumo siino ubuheetejinoco miyaaveguehi. Jaanegui fɨne uco mocoovahi toonoco uco midilluqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Jaanoco uguubuumoro fariseomɨ, saduceomɨ iicamo jenaaucasiuhi sanoomɨro. Jaamoro ijeevadɨ dugaavocasiumo ifariseomɨ isaduceomɨtɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mɨɨro saduceomɨ noonɨcɨhi uchuumucuumo buheetecuujitɨhi, bu Moocaani toomomɨnaa chahahi, bu gaijamɨ chahahi, noonɨcɨhi. Jaanotɨ fariseomɨ fanoocoro miyaavogonɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Jaadɨ famooro sefano ocoovadiivuunobuunatɨ saatoho caatɨnɨmɨnaa gañiivuuhi fariseomɨjaagodɨ iicaumo. Jaamoro nuuhi: Jaanɨ imitɨno moonɨtɨhi. Jaabofañodɨ baacho gaija iimaahi, Moocaani toomomɨnaafi baacho iimaahi. Jaanegui Moocaanimaryo momoonɨcasidino, noomoro ");
INSERT INTO bmrNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","sefano jenaaucasihicaumo. Jaaneri ihamocasimɨnaa aivojɨɨbo ñɨhicuguuhi Pabloco fahɨgovatɨ agallicujirunotɨ. Jaaboro ihamocasimɨnaaco tajɨɨbaubo diitofeenetɨ Pabloco ɨɨcɨmoro cɨvojafaño siino isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Jaano sifucutɨ Pablojaa Aivojɨɨbo Jesu asaauboro nuuhi: Quehecuto Pablo. Uuditɨ jino Jerusalefaño idiimaabadɨ tollɨro Roma cuumijaago diimaateji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Jaanaa sifucutɨ sanoodɨmo judiomɨ iimaacasiuhi Pabloco igaicaauqui. Jaamoro imitɨno unuunofañodɨ nuumo: Mamachujitɨhi, mahadujitɨhi icano diiboco magaicaautɨnohachuta, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Jaamou tollɨ unuumo cuarentadɨmou tollɨ esamaaiumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Jaanobuunatɨ sacerdotemɨ aivojɨɨbojaago, judiomɨ quillahuto icamojaago ufuumoro diitoco nuumo: Mɨɨhai munuucuuhi iimitɨnofañodɨ Pabloco magaicaautɨnohachuta mamachujitɨhi, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Jaanegui amɨɨhai fagomɨnaama mofoomoro amocasimɨnaa aivojɨɨboco cɨvohogo midilluto diiboco isɨvaqui amɨɨhai ɨmefeenevɨ, siino imino diiboco midilluqui, noomoro. Jaabo Pablo gasetɨɨbo ɨmegaro mɨɨhai mihimibaivucuuji diiboco magaicaauqui, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Jaanoco Pablo nago achi uguubuuboro icɨvojafa fuubo Pabloco ijɨɨbeguequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Jaanegui Pablo saatohotɨ aivojɨtoco ocoovauboro nuuhi: Jaanɨco sɨcafefico masatyo imiya aivojɨɨbojaago siinoco diiboco ijɨɨbeguequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jaanegui tosɨcafefico ihaivojɨɨbojaa asatyuuboro nuuhi: Pablo cɨvojafañotɨ uco galluhi jaanɨ sɨcafefico dijaago sɨvaqui ɨcova siinoco ijɨɨbeguequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Jaanegui ihaivojɨɨbo tosɨcafefico ihusetɨ agaayɨcɨuboro sihɨgovɨ diiboco asatyuuboro dilluuhi: ¿Mɨllɨ uco neejirahi? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Jaanegui isɨcafefi nuuhi: Judiomɨ esamaaihi ɨco idilluqui cɨvohogo Pabloco satyequi fagomɨnaa ɨmefeenevɨ. Jaamo jillɨ ɨco neeji: Siino mihimeguehi imino diiboco midillunoco, noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Jaarumoco miyaaveguejirahana, sihidɨ cuarenta janaanɨcɨvɨ icamo teemeji Pabloco. Jaamo imitɨno onoonofañodɨva machujitɨmo, adujitɨmo icano Pabloco agaicaautɨnohachuta. Jaamo imibaicɨnɨcuumo ɨɨjohova: Jɨɨhɨ, Pabloco galluji, eneejinoco otoomomo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Jaanegui ihaivojɨɨbo isɨcafefico ifitacuuboro nuuhi: Dɨɨbeguedino mɨɨhaiñoobaco jino uco ɨdɨɨbogonoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Jaadɨ ihaivojɨɨbo coovauhi saatɨsi aivojɨtɨsico. Jaaboro diitɨsico nuuhi: Mihimibaivusu doscientodɨmo amocasimɨnaa baadɨ efeejimoco, bu setentadɨmo jeejɨmɨri efeejimoco, bu doscientodɨmo aamɨganoma efeejimoco icano Cesarea cuumivɨ tufucuro ifeequi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Jaamoma ihaivojɨɨbo galluhi Pabloco jeejɨri ifeequi. Imino Pablo tahɨ ihɨfetequi aivojɨɨbo Felix onoobojaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Jaaboro diitoma galluubo aameque jillɨ onoohaameque: ");
INSERT INTO bmrNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Uujoho Claudio Lisio, imino iijɨco galluuhi ɨɨjoho idiimihusene aivojɨɨbo idiicaabo Felixjaago. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jaanɨ Pabloco judiomɨ ɨcɨvojanɨmoro diiboco gaicaaujirahi. Jaarunaa romanoobo iicanoco uguubuuboro, soldaomɨma ofooboro diiboco taajasuhi judiomɨ usetɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Jaadɨ diiboco judiomɨ fagomɨnaa ɨmegavɨ satyehinɨhi jinejeque diibeditɨ ihiimaanoco gaajaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Jaarunaa judiomɨ tajɨɨbajɨhallɨtɨ idilluhicaunoco agaajauboro mɨllɨ nuutɨhi: Toonohallɨtɨ magaicaaujirunoco, mɨcɨvojaanɨjirunoco icano uujoho atyɨmetɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Jaarunaa diiboco agaicaaujinoco uguubuuboro jino galluuhi dijaago. Tollɨro bu jito diibeditɨ ihiimaahicamoco dijaa galluuhi tahɨ dihɨmefeenevɨ diibeditɨ ihiimaaqui. Tahɨ imino diica, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Jaanegui ihamocasimɨnaaco ihaivojɨɨbo unuubadɨ fucu satyumo Pabloco Antipatri cuumivɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Jaano sifucutɨ ihamocasimɨnaa baadɨ ufuumo uumiumo dojɨcuvɨro icɨvojajaago. Jaanotɨ jeejɨmɨri ufuumo Pabloma fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Jaamo Cesarea cuumivɨ ɨɨfutuudɨ aivojɨɨbo Felix onooboco acɨumo Pabloco toohaamema. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Jaahaameque emeecɨuboro ihaivojɨɨbo dilluuhi Pabloco: ¿Cuucaoobo ɨɨjoho? nooboro. Jaadɨ gaajaubo Cilicia jiinɨjeoobo iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Jaanegui nuubo: Jisumi uco ɨdɨɨbogonoco guubunɨcɨtɨhi. Jaanotɨ jarihiica ɨɨditɨ ihiimaamo asaadɨ ɨɨjoho onoonoco bu guubunɨcɨji, nooboro Pabloco ficusuubo Herode palaciojafaño, toomomɨnaa diiboco iteemequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Jaadɨ sahuse fucuvabuunatɨ Anania onoobo sacerdotemɨ aivojɨɨbo ɨfutuuhi sanoodɨmo quillahutoma Cesarea cuumivɨ. Jaamoma saafi iimaamɨnaafi Tertulo onoobo saauhi. Jaamo agaseudɨ aivojɨɨbo ɨmefeenevɨ ujulleecamaaiumoro Pablohallɨvɨ imitɨno iimaaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Jaanaa Pabloco agasesuudɨ Tertulo onoobo tɨcovauhi ihiimaaubo jillɨ nooboro: Aivojɨɨbo Felixco, imino aivo ɨɨjoho aivojɨɨbo mɨɨhaico teemehi. Jaamaño aivo sajeebɨɨ mihicahi imino mɨɨhaico atajɨɨbamaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Jaanoco fanooro aivo imino magaayɨcɨhi fahɨgova ɨɨjoho aivojɨɨbo Felix idiimihuseebe idiicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Jaabo uuchuvotɨɨbo diicatɨqui imeguehi ajashuno ɨɨma ihiimaanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Mɨɨhai jaanɨ Pabloco magaajacuhi gañuhusuno ɨsɨramaaihicanoco. Jaabo fahɨgovavɨ judiomɨco dugaacusuuboro feehicahi, nazarenomɨ dugaavomɨnaa aivojɨɨbo iicamaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Jaamaño templojaco mɨhɨninɨjiruubo. Jaarunaa mɨɨhai diiboco magaayɨcɨuhi diiboco midilluqui motajɨɨbajɨ onoobadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Jaarunaa amocasimɨnaa aivojɨɨbo Lisio onoobo asaauboro sefano dumɨtɨɨcɨuhi mɨɨhaitɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Jaabo ihamocasimɨnaa aivojɨɨbo galluuhi, Pabloditɨ ihiimaamoco, dihɨmefeenevɨ diibeditɨ ihiimaaqui. Jaabo eneecau ɨɨro diiboco dillu. Jaabo ɨɨro gaajahi mɨɨhai monoono miyaano icanoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jaanoco paryɨ judiomɨ: Aivo miyaano, neehicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Jaanegui ihaivojɨɨbo Felix Pabloco tajɨɨbauhi ihiimaaqui. Jaanegui Pablo nuuhi: Aivo imeguehi dihɨmefeenevɨ ihiimaanoco. Ɨco uujoho gaajahi sɨɨcɨjetɨro jiicuumi aivojɨɨbo idiicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Jaabo eneecahicau bu ɨɨro dilluubo gaaja uujoho Jerusalevɨ Moocaanico imequi asaahinɨɨbo agasehinɨnotɨ fahuseecɨ motɨhaitɨ mifucucɨ ɨdɨɨno fucuvaro iicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Jaaruubo uujoho ejenaaubo templojafaño, sinagogajafaño, tuucuumifeenevɨ buhɨgueeje icano ñaaɨsuuboro ofoonoco atyɨmetɨmo. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Jaamo jino uuditɨ iimaano miyaano icatɨno. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Jaanotɨ naha miyaano uujoho tadimɨhai Caani Moocaani iicaaboco jeecɨvehicahi bohono jɨɨhai onoobadɨ. Jaanoco oono diito dugaacumɨnaa neehicahi. Jaarunaa jillɨ uujoho Moocaani iimaamɨnaa aamenefaño, bu Moocaani tajɨɨbano aamenefaño iicanoco miyaaveguehi. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Jaabo uujoho tollɨro Moocaanico miyaaveguehi diitobadɨro. Jaabo teemehi paryɨ uchuumucumo iimifiimo, bu iimitɨfimo icano ubuheetejinoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Jaamaño uujoho quehecuno tajeebɨɨco ficuhicahi Moocaani ɨmefeenevɨ, bu miyamɨnaa ɨmefeenevɨ icano imino icaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Jaabo uujoho siicuumijeri ɨgooboro efeehicadɨ taacuumijaago saahinɨhi judiomɨco nɨhɨbamɨco acɨqui, Moocaanidi jeecɨvoco ficuqui icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Jaanoco uujoho eheetavuubo templojafaño icaunaaca judiomɨ Asia jiinɨjetɨ asaaumo uco templojafaño atyɨmeuhi tafiico iimibachuuboco. Jaaruubo miyamɨnaama sihidɨ igaivuutɨhi, ñaaɨsuuboro icautɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","¿Jaamo judiomɨ Asia jiinɨjeoto collɨhi saatɨhi jinoovɨ dihɨmefeenevɨ ihiimaavamo uuditɨ imitɨno iicanoco eesɨcɨnɨhachiijɨ? ");
INSERT INTO bmrNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Jaanotɨ jito asaamoco dillu ¿Naa mɨllɨ judiomɨ fagomɨnaa ɨmefeenevɨ iicahinɨsumi uco gaajacɨhinɨmo imitɨno iicanoco? ");
INSERT INTO bmrNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ɨvɨ ɨdɨɨnoro uujoho diito ɨmefeenevɨ iicahinɨsumi sefano nuuhi: Uujoho uchuumucumo ubuheetejinoco imiyaavogonoco fɨne magaajaqui uco midilluhi jaachiijɨ, ɨvɨ uujoho nuuhi diito ɨmefeenevɨ iicasumi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Jaanoco Felix uguubuuboro mɨllɨ nuutɨɨbo. Cristota imiyaavogonoco agaajauboro nuubo: Jari amocasimɨnaa aivojɨɨbo Lisio asaadɨ toonotɨ imino uujoho gaajaji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Jaaboro Felix saafi aivojɨɨboco galluuhi Pabloco palaciojafaño ijɨɨhacuqui. Jaaruubo cɨvojamɨnaafibadɨ icautɨhi. Jaabo toojafa icaunohachuta igataavomɨnaa diiboco meecɨtehicauhi diiboco siinoco ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Jaadɨ goovacutɨnotɨ Felix mogai judiomɨogo Drusila onoogoma saauhi. Jaaboro Pabloco cuuhuvauhi diibojaa asaaboro Jesucristoco mimiyaavogonotɨ diiboco ɨjɨɨbogonoco iguubuuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Jaabo Pablo ɨtɨcovono ifiitɨ, bu mofiicoro miguiinonɨnotɨ, bu ufucu Moocaani mohimitɨ jaadufucu icajinotɨ icano Pablo ɨjɨɨbuguunotɨ Felix ihigutuuboro nuuhi: Difo. Ufucu jei, ¿cusumihacho ɨco siino cuuhuvaji? nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Jaadɨ Felix esamaaihicauhi: Fɨne Pablo uco nɨhɨbamɨco acɨjiibo diiboco sinaayuqui, nooboro Pabloco fiiva foova cuuhuvahicaubo diiboma ihiimaaqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Jaadɨ mificabacɨ afatyuudɨ Felixco bohobavaubo saafi aivojɨɨbo Porcio Festo onoobo. Jaanegui Felix judiomɨma imino iicaqui Pabloco cɨvojafañoro ficuubo iinusutɨɨboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Jaabo Festo mifucucɨ, safucu ɨdɨɨno aivojɨɨbotɨ icacuudɨ fuubo Cesareatɨ Jerusalevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Jahɨgo sacerdotemɨ aivojɨto judiomɨ obocɨfimo iicamo, Pablohallɨvɨ imitɨno iimaaumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Jaamoro Festoco dillumo Pabloco Jerusalejaagovɨ ihɨcɨtequi, ɨɨfurumo Pabloco jɨɨhaivɨ igaicaausuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Jaarunaa Festo iimusuhi: Pablo Cesareavɨ cɨvojafaño icahi. Tollɨro uujoho goovano feeji tahɨgo. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Jaanegui amɨɨhai aivojɨto uuma Cesareavɨ feeji diibeditɨ imitɨno iicahicanoco ihiimaaqui. Miyaano diibo imitɨno iicahicahachiijɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Jaabo Festo Jerusalevɨ fahuseecɨ fucuva tɨcovovɨro fɨne icacuuhi. Jaadɨ siino Cesareavɨ uumiubo. Jaano sifucutɨ ihaivojɨ icagahallɨvɨ acasɨɨvuuboro Pabloco cuuhuvaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Jaabo Pablo agaseudɨ, Jerusaletɨ asaaumo judiomɨ diibojaa igaivuhi. Jaamo iimaacasiuhi siibadɨjere aivo imitɨno Pabloditɨ. Jaarunoco ɨnɨsuurunofaño miyaano icautɨno. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Jaanegui Pablo ihallɨvɨ iimaauhi: Uujoho judiomɨditɨ, templojaditɨ, bu romanomɨ aivojɨɨbo Cesarditɨ icano imitɨno iimaatatɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Jaanegui Festo Pabloco dilluhi judiomɨma imino iicanoco iimuguuboro: ¿Naa dimeguehi Jerusalevɨ ofoonoco ɨco uujoho tahɨ dilluqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Jaanegui Pablo iimusuhi: Uujoho jinoovɨ aivojɨɨbo Cesar onoobo tajɨɨbamañeri icahi imino uco idilluqui ɨɨro imino gaajacuhi imitɨno judiomɨtɨ ihiimaatɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Jaanotɨ miyaano imitɨno omoonɨhachiijɨ jaafa uco magaicaau. Jaanotɨ sɨcamañooco ihiimaahicahachiijɨ diito usefaño mɨɨhaiñooba uco acɨjitɨhi. Jaanegui imeguehi romanomɨ aivojɨɨbo Cesar onoobo uco idillunoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Jaanegui toonobuunatɨ Festo ifajɨɨnɨmɨnaama ihiimaauboro Pabloco nuuhi: Ɨco romanomɨ aivojɨɨbo ɨmefeenevɨ idillunoco dimeguehi. Jaanegui romanomɨ aivojɨɨbojaago ɨɨjoho feeji, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Jaanobuunatɨ aivojɨɨbo Agripa onoobo Berenice onoogoma ɨɨfutuhi Cesareavɨ Festoco abaatuumɨsi. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Jaamɨsi tahɨ gueene fucuva icauhi. Jaabo Agripa onooboco Festo Pabloditɨ ɨjɨɨbuguuboro nuuhi: Jineeri icaabo saafi Felix cɨvojafaño ificuhinɨɨbo. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jaabohallɨvɨ sacerdotemɨ aivojɨto, quillahuto icamo dilluuhi diiboco imitɨno imoonɨqui Jerusalevɨ uujoho iicahinɨsumi. Jaamo imuguuhi uujoho diiboco agaicaausujinoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Jaanegui uujoho nuuhi: Mɨɨhai romanomɨ mejeevamaaitɨhi tɨcovono miyamɨnaafico magaicaaunoco. Itɨconɨ diiboco diibohallɨvɨ imitɨno ihiimaano ɨmefeene ifihallɨvɨ ihiimaaqui, mificuutɨnohachuta, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Jaanegui diito jimañovɨ asaahinɨsumi uujoho gueenene icatɨɨbo sifucutɨ tatyajɨɨbamañotɨ cuuhuvauhi diibo Pabloco. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Jaabeditɨ diito iimaauno aivo iimitɨnoco nuutɨhi uujoho esamaaiubadɨ icautɨno. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ɨdɨɨnocoro diibeditɨ neehicaumo jillɨ diito iimaa iijɨtɨro, bu tollɨro Jesu uchuumuuboco Pablo buheebe eneehicaunotɨro icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Jaanoco, uujoho mɨllɨ fɨne moonɨji, onoomaño Pabloco dilluhi: ¿Naa Jerusalevɨ diimeguehi ofoonoco, tahɨ ɨco idilluqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Jaarunaa Pablo imuguuhi aivojɨɨbo Cesar Augusto onoobo diiboco idillunoco. Jaanegui uujoho diiboco cɨvojafañoro ficuuhi. ¿Cusumihacho diibo Cesar Augustojaago galluuqui? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Jaanegui Agripa onoobo Festoco nuuhi: Uujoho tollɨro diiboco uguubuunɨcɨnoco imeguehi, nooboro. Jaanegui Festo ihiimusuuboro nuuhi: Cɨvohogo diiboco jei guubuunɨcɨ, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Jaano sifucutɨ Agripa, Berenice icamɨsi atajɨɨbafimañovɨ aivo sihidɨ jeevano ɨɨfutumɨsi miyamɨnaa diitɨsico iimuunofeenedɨ. Jaamɨsima saaumo amocasimɨnaa aivojɨto, bu tuucuumio bocɨfimo icano. Jaanobuunatɨ Festo Pabloco cuuhuvauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Jaaboro Festo nuuhi: Aivojɨɨbo Agripa, famooro jino mɨɨhaima mihicamo, memeecɨ jaanɨco. Jaanɨditɨ sihidɨ judiomɨ Jerusalevɨ, bu Cesareavɨ icano uuma iimaahinɨhi. Jaafa guijeveebe, sefano noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Jaarunaa uudi jinejebaco imitɨno moonɨhicatɨɨbo. ¿Mɨllɨtɨ bu jaaboco magaicaaujirahi? Jaabo inoro imeguehinɨɨbo aivojɨɨbo Augusto diiboco idillunoco. Jaanegui diiboco diibojaago galluuji. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Jaarunaa chahano diibo aivojɨɨbojaago acaatɨnɨjiruno diibohallɨvɨ. Jaanegui tahaivojɨɨbo, Agripa, dihɨmefeenevɨ diiboco sɨvahi. Jaabo ɨɨjoho diiboco idilluudɨ fɨne diibohallɨvɨ iicanoco caatɨnɨji. ");
INSERT INTO bmrNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mɨɨro uudi imitɨno cɨvojamɨnaafico agalluuno aivojɨɨbojaago mɨllɨ diibeditɨ icanoco jɨɨbogotɨɨbo, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Jaanegui Agripa Pabloco nuuhi: Ɨɨro diimaa, nooboro. Jaanegui Pablo ihuseque agañiiyɨcɨuboro tɨcovauhi jillɨ iimaaubo: ");
INSERT INTO bmrNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Aivojɨɨbo Agripa aivo imo imo icahi dihɨmefeenevɨ tafihallɨvɨ ihiimaaboro jɨɨbeguequi famooro judiomɨ uuditɨ ihiimaahicanoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Fanoocoro ɨɨjoho imino gaajahi paryɨ judiomɨ jeevamaajeque, tollɨro fanooro mihiimaanɨcɨnoco icano. Jaanegui ɨco dilluhi uco guubunɨcɨqui sɨɨcuno. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Mɨɨro famooro judiomɨ uco seemenetɨro gaajauhi. Itɨconɨ taacuumivɨ iicahicaunoco, bu Jerusalevɨ iicahicaunoco icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Jaanoco bu diito gaajahi jaafa jaanoco iimogohachiijɨ ɨmɨɨdɨusumi fariseobadɨ iicaunoco jɨɨbogomo. Jaamo mɨɨhai fariseomɨ mihicamo Moocaanico saatoho janaanɨcɨ aivo imino mejeecɨvonɨcɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Jaanegui uujoho miyaaveguehi Moocaani uchuumucumoco siino ubuheetesujinoco. Mohɨmegaotoco Moocaani unuubadɨ. Jinohallɨtɨ jino uco sɨvamo ihaamɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Jaamaño mɨɨro Israel cuumino fahuseecɨ motɨhaitɨ miicuumiicɨ icano iicamo. Toono imiyaavejinoco otoomomo Moocaanico jeecɨvehicahi cuujehachuta, fucuhachuta icano. Jaanoco uujoho imiyaavogonohallɨtɨ uuditɨ judiomɨ jisumi imitɨno iimaahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ɨɨjoho aivojɨɨbo Agripa, ¿nacu amɨɨhai judiomɨ mimiyaavogotɨhi Moocaani uchuumucumoco ubuheetesujinoco? ");
INSERT INTO bmrNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mɨɨro uujoho itɨconɨ imino moonɨhi nooboro Jesu Nazareoobo momohallɨtɨ sihidɨ imitɨno miyamɨnaaco moonɨhicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Jillɨ uujoho moonɨhicauhi Jerusalevɨ, sacerdotemɨ aivojɨto iijɨtɨ cɨvojafaño ficuhicauhi sihidɨ Cristoco imiyaavogomoco. Jaamoco agaicaaumofañodɨ uujoho icahicauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Jaaboro Cristotaco sihidɨ aamɨhicauhi paryɨ sinagogajanofaño, imiyaavogoco jeevesusuqui, nooboro. Bu uujoho aivo sihidɨ ɨsɨfiiratooboro diitoco bucasihicauhi fahɨgova jiinɨjenedɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Jaabo tooneguiiharo fuuhi Damascavɨ sacerdotemɨ aivojɨto iijɨco uco aacɨumoro agalluuneguiiha. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Jaabo aivojɨɨbo Agripa, uujoho jɨɨhairi fuunaaca gadɨcɨɨba niquejefañotɨ uco sefano achɨcɨuno sano uuma ufuumoma, nɨhɨba aachɨcɨno janaanɨcɨ icano sefano namecuno. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Jaaneri famooro baavɨ mahaifuuhi. Jaanobuunatɨ niquejefañotɨ guubuuhi uco hebreo iijɨri unuunoco: Saulo, Saulo, ¿collɨhi uco bucasihi? Ɨɨro difiico daivuvusuhi oono Buey ihabajaabo iimogobadɨ iicanoco imogotɨɨboro iinoro fegaɨ nijequeque ɨtɨvadiivooboro iicanɨcɨbadɨ, unuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Jaanegui uujoho nuuhi: ¿Mɨɨjoho ɨɨjoho, aivojɨɨbo? nooboro. Jaanegui Aivojɨɨbo uco nuuhi: Uujoho Jesu. Jaaboco ɨɨjoho uco bucasihi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Jisumiro gañiivo. Toonegui ɨɨvɨ uujoho buhugaavehi uco deecɨvequi fanoocoro uuditɨ adaatyɨmecunoco, tollɨro adaatyɨmejinoco icano dɨɨbeguequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Jaabo ɨco uujoho taajasuji judiomɨ usetɨ, bu judiomɨ iicatɨmo usetɨ icano. Jaamojaago ɨco galluhi jisumi diito aallɨɨnoco faayɨcɨsuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Jaamo imitɨno icacutɨmo iicaqui cɨvonoguiinodɨ ɨgotɨmo seseehɨ iicacuuqui Satanasco ejeevesumoro Moocaanima iicaqui. Jaamo uco imiyaavogomoro agaayɨcɨmo imitɨco buusuji Moocaani ɨcɨumofeenevɨ iicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Jaanegui, aivojɨɨbo Agripa, uujoho niquejetɨ gaijafaño aatyɨmeunoco miyaavuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Jaaboro jɨɨbeguehicauhi itɨconɨ Damasca cuumivɨ. Jaadɨ jɨɨbeguehicauhi Jerusale cuumivɨ, bu fahɨgova Judea jiinɨjevɨ icano, bu tollɨro judiomɨ iicatɨmoco icano. Jaamo famoocoro jɨɨbeguehicauhi iimitɨco ejeevesumoro Moocaanijaagovɨro iicaqui. Jaamoro imino iicanoco toonofañodɨ ihɨfusuqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Jinohallɨtɨ judiomɨ uco templojafaño agaayɨcɨumoro gaicaaujirahi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Jaarunaa Moocaani uco aamusuneri jisu imino jɨɨbeguehi paryɨ miyamɨnaaco obocɨfitɨmoco, obocɨfimoco icano. Jaanoco tollɨro fahiijɨvaro jɨɨbeguehicahi siibadɨ jɨɨbogotɨɨbo Moocaani iimaamɨnaa, bu Moise icamo jillɨ iicajino unuubadɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Cristoditɨ nuumo Cristo asaadɨ ɨdaasuno icajiibo. Jaadɨ chuumucuruubo buheetejiibo, uchuumucumo ubuheetejinoco ɨtɨconɨɨbo. Jaanoco jillɨ jɨɨbuguubo mataajajinoco judiomɨdi, bu tollɨro judiomɨ iicatɨmedi icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Jillɨ Pablo unuunegui Festo sefano nuuhi: Pablo fɨne ɨɨjoho jillɨ deegavehi. Toono sihidɨ agaajano ɨco jeegavusuhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Jaanegui Pablo nuuhi: Idiimihuseebe Festo, uujoho jeegavotɨhi. Imino eesamaaiboro miyaanoco neehi. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Jaanɨ jino aivojɨɨbo Agripa iicaabo toonoco imino gaajahi. Jaanegui jino diibo ɨmefeenevɨ ñɨhicugotɨɨboro iimaahi. Jaanoco diibo tollɨro gaajahi fanooro toovono iicatɨnoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Jaanegui aivojɨɨbo Agripa ɨco dilluuhi: ¿Naa Moocaani iimaamɨnaa unuunoco miyaaveguehi? Fɨne miyaaveguehi, nuubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Jaanegui Agripa Pabloco nuuhi: ¿Mɨllɨ nacu ajashuno idiimaaneri uco fɨne miyaavugusuji? nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Jaanegui Pablo nuuhi: Uujoho Moocaanico dilluhi, sihidɨ ihiimaaneri, ajashuno ihiimaaneri icano mimiyaaveguequi. Jaabo ɨɨro icatɨno, paryɨ jaachiijɨ jino uco uguubuunɨcɨmo, bu tollɨro uubadɨ iicaqui. Jaarumo jillɨ uubadɨ jɨgaiñehiri sisɨcɨnɨtɨmo iicaqui, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Jillɨ Pablo unuunobuunatɨ aivojɨɨbo Agripa, bu aivojɨɨbo Festo, bu Berenice, bu famooro toono iicaumo icano agañiivuumoro ");
INSERT INTO bmrNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","fuumo sihɨgovɨ. Jaamoro toonotɨ sanoomɨro ihiimaacasimoro noocasihicaumo: Jaanɨ imitɨno moonɨhicatɨɨbo. ¿Mɨllɨtɨ bu jaaboco magaicaaujirahi? ¿Mɨllɨtɨ bu mɨcɨvojanɨjirahi? noomoro. ");
INSERT INTO bmrNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Jaanegui Agripa nuuhi Festoco: Fɨne misinaayujirahi jaanɨco inoro romano aivojɨɨbo Cesar uco idillunoco imeguehi, inuutɨruva, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Jaadɨ mɨɨhaico Italia jiinɨjevɨ igalluuqui acɨumo Pablo saatoho cɨvojamɨnaa iicamoco saafi aivojɨɨbo Julio onooboco. Jaabou Julio ijeevadɨo amocasimɨnaa Augusto onoomo amocasimɨnaa aivojɨɨbo iicaubo. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Jaamo Adramitio cuumi meenegari mufuuhi, Asia cuuminoco muuaijɨniri iicamɨcujeque emeecɨtuugari. Tollɨro Aristacu onoobo Tesalonica cuumioobo, Macedonia jiinɨjeoobo mɨɨhaima fuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Jaano seseevedɨ Sidon onoomɨcuvɨ mɨhɨfutuhi. Jaamañovɨ Julio Pabloco imino omoonɨuboro galluuhi inahabonɨmɨnaaco imeecɨtequi diiboco sinehejetɨ ihacɨqui. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Jaadɨ tomɨcutɨ mufuumo Chipre onoochugaico mafatyuhi monaninaagueneri iicachugaico sihidɨ guibuhuba mɨɨhaico sihɨgovɨro asatyuneri. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Jaadɨ Cilicia jiinɨjeque, bu Panfilia jiinɨjeque icano mafatyumoro mɨhɨfutuuhi Mira unuucuumivɨ, Licia jiinɨjevɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Jahɨgo amocasimɨnaa aivojɨɨbo Alejandria meenegaco atyɨmeuhi Italia jiinɨjevɨ ufuugaco. Jaaboro mɨɨhaico togafaño jɨcafutusuubo mefeequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Jaadɨ guiraafucuva mɨhɨguunobuunatɨ sihidɨ jeevanotɨ mɨhɨfutuuhi Gnido cuumi onegueehivɨ. Jaanaa guibuhuba sihidɨ iicaunegui sihɨgodɨ mufuumo Salmon onoocuumi onegueehidɨ, Creta onoochugaihallɨdɨ mafatyuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Jaarunaa sihidɨ jeevaneri mufuumo mɨhɨfutuuhi Imimɨcu onoomɨcuvɨ Lasea cuumi fiitɨno. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Jaamo gueenene tahɨ mihicaumaño ñɨhicucuuno muuairi mufuujino jɨɨnija guibuhubama iicacuujino ifiitɨcuumaño. Jaanegui Pablo diitoco afajɨɨnɨuboro nuuhi: ");
INSERT INTO bmrNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Amɨɨhaico gaifiimɨco neehi: Ñɨhicuno aivo sihidɨ jeevaneri mefeeji. Jaaneri meenega ifiimaaveneri sihidɨ sineheje gañɨɨcafeteji, jaabadɨro saatoho miyamɨnaa ifiino gañɨɨcafeteji icano, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Jaarunoco Pabloco ihamocasimɨnaa aivojɨɨbo miyaavugutɨhi. Jaaboro imeenega abajaabo, toga tɨcuvusumɨnaafi icano unuunocoro miyaavuguuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Jaanaa guiraamo nuuhi: Imitatɨmɨcu jɨɨnijadɨɨhivɨ. Jaanegui masɨɨgo mufuucuqui jinootɨ Creta jiinɨjevɨ Fenice mɨcuvɨ mɨhɨfetequi, noomoro. Tomañotɨ noreste, sureste icahɨgo ɨɨfuvusuhicauneguiiha, tomɨcuvɨ jɨɨnijaco mafatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Jaadɨ guibuhuba sɨɨcuɨba surjaagotɨ iguibunegui: Imino fɨne mefeeji, noomoro mufuuhi Creta chugai fiitɨnodɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Jaanobuunatɨ gueenejɨsunotɨ momeenegahallɨvɨ sefano guibuhuba saauhi, aivo esefano guibuhuba Noreste onooguibuhuba. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Jaano sefano guibuhuba mɨɨhaico agaayɨcɨnoro ɨɨgusuutɨnegui mejeevesucuuhi. Jaaneri mɨɨhaico iguibuhuba sihɨgovɨro satyucuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Jaamo mafatyuhi ajashuchugai Clauda onoochugai bujɨnaagodɨ iguibuhuba sefano achahauhɨgodɨ. Jaamoro sihidɨ jeevanotɨ imɨɨdɨ meenegaco imino mudujenɨuhi iguiraagatɨ. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Jaadɨ ihajashugaco caamo iguiraagajɨnibaavɨ duujenɨumo. Jaamoro iguiraagaco sisɨumo gaibaɨneri ifaaga agallivujiruneguiiha. Jaamoro muuaifaño jiinɨgaibaaho Sirte onoobaahohallɨvɨ ifiigatyujirunoco ɨñɨhicugumoro imeenega gaachehuco niitusuumo guibuhuba sihɨgovɨro diitoco isatyequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Jaano sifucutɨ guibuhuba icauhiica sefano. Jaanegui imeenegafañoonoco gaifificɨumo muuaifaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Jaano sifucutɨ bu famooro siino magaifificɨuhi togaonehejeque muuaifaño. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Jaamo fiiva fucuva mahatyɨmehicautɨhi nɨhɨbaco meecɨrɨ icanoco sihidɨ guibuhuba iicaumaño. Jaamoro: Mataajajitɨhi fɨne, munuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Jaamo gueenene amachucutɨnegui Pablo diitofeenevɨ ujulleeveuboro nuuhi: Imino uujoho eneehinɨnoco muguubuhinɨruva Creta chugaivɨ masaajitɨrahi. Jaarunaa masaamaño ɨdaasuno mihicahi monehejeque magaifificɨhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Jaarunaa ñɨhicugotɨmo quehecuno mihica. Saatohobatɨ miguijevejitɨhi ɨdɨgaaro meenega fiimaveji. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Jaanoco uujoho gaajacɨhi Moocaanico ejeecɨvehicaabofañodɨ uujoho icamaño. Jaabo itoomomɨnaafico tajaago agalluubo fucu uco neehi: ");
INSERT INTO bmrNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Pablo diguetejirahana, romano aivojɨɨbo ɨmefeenevɨ dɨhɨfeteji. Tollɨro difañodɨ ɨɨri Moocaani taajasuji famooro ɨɨma meenegafaño iicamoco, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Jaanegui quehecuno mihica ñɨhicugotɨmo. Uco Moocaani itoomomɨnaafifañodɨ onoobadɨ iicajinoco miyaaveguehi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Jaarunaa mɨɨhaico sachugaivɨ gañɨɨjino guibuhuba, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Jaadɨ mijaguisɨcɨhachuta mɨhɨgucuudɨ Adria muuaivɨ mɨhɨfutuuhi. Jaamañovɨ sihɨgovɨ agañɨɨno, sihɨgovɨ agañɨɨno fuuhi. Jaanaa toga dudɨcamaajemɨnaa fucufeenevɨ gaajacuuhi jiinɨjetɨ ifiitɨvuunoco. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Jaamoro uuvumo imuuai faicuvaco. Jaarunaa treinta y seis metrohachuta inɨfaihu faicuva icauhi. Jaano janaanɨcɨ siino uuvumo. Jaarunaa veintisiete metrohachuta inɨfaihu faicuva icauhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Jaanegui guiisihallɨvɨ imeenegaco agañɨɨjirunoco iiguiumoro igueenemehejedɨno obocɨnoonoco toga dojɨcuogatɨ udujenɨumoro imuuaifaño gañɨɨumo sihɨ footɨga iicaqui. Jaamoro tuumuumo iseseevequi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Jaamoro toga dudɨcamaajemɨnaa togatɨ itaajaqui moonɨuhi ihajashugaco togatɨ imuuaifaño iiniitusuumoro isivɨ ifeequi. Jaamoro ibocɨsutaco niitusumobadɨ nijequeogatɨ moonɨumo abañɨsumo. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Jaanegui Pablo ihamocasimɨnaa aivojɨɨboco nuuhi: Diito meenegatɨ ofoohachiijɨ amɨɨhai mataajajitɨhi, nooboro. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Jaanegui ihamocasimɨnaa ihajashuga sisɨtaaco iquitɨumoro togaco muuaifaño gañɨɨuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Jaadɨ Pablo cuujetavɨ diitoco nuuhi: Aivo gueenene mijaguisɨcɨ mɨcɨgacutɨhi, bu mamachucutɨhi icano. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Jaanegui amɨɨhaico neehi: Mamachuqui. Jaamo mamachumoro mataajahi. Mɨɨro saatohoba mɨllɨ icacujitɨhi, nooboro ");
INSERT INTO bmrNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pablo maahuco agaayɨcɨuboro Moocaanima iimaauhi diito ɨmefeenevɨ. Jaadɨ toonoco iquisicuuboro machuubo, ");
INSERT INTO bmrNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","bu tollɨro famooro amachumoro imo imo minifutuuhi. ");
INSERT INTO bmrNT_vpl VALUES ("AC27_37","074_27_37","ACT","2