﻿USE sofia;
DROP TABLE IF EXISTS sofia.bmo_vpl;
CREATE TABLE bmo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bmo_vpl WRITE;
INSERT INTO bmo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yei pa ndaaŋoŋ Jishɔ *Krishto mbɔ muuŋ *Devi ŋa a ni mbɔ muuŋ Abrahaŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahaŋ ni mbɔ tǎa Aiji, Aiji pɔ tǎa Jakɔ, Jakɔ pɔ tǎa Juda pugu pa lǐŋ pi. ");
INSERT INTO bmo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda pɔ tǎa Pɛrɛ pugu Shera, mǔuŋ vugu ni mbɔ Tama, Pɛrɛ pɔ tǎa Hɛshroŋ, Hɛshroŋ pɔ tǎa Raŋ. ");
INSERT INTO bmo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raŋ pɔ tǎa Aminada, Aminada pɔ tǎa Nashoŋ, Nashoŋ pɔ tǎa Shalmoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Shalmoŋ pɔ tǎa Boa, mǔuŋ vi ni mbɔ Raha, Boa pɔ tǎa Obɛ, mǔuŋ vi ni mbɔ Ru, Obɛ pɔ tǎa Jeshe. ");
INSERT INTO bmo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jeshe pɔ tǎa Fùoŋ Devi. Devi pɔ tǎa Sholomu, ni mbhi vi pi pugu miŋgwɛ yɛ ŋa a ni mbɔ ŋgwɛ Yuria nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sholomu pɔ tǎa Rehoboaŋ, Rehoboaŋ pɔ tǎa Abija, Abija pɔ tǎa Asha. ");
INSERT INTO bmo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asha pɔ tǎa Jehoshafa, Jehoshafa pɔ tǎa Joraŋ, Joraŋ pɔ tǎa Ujia. ");
INSERT INTO bmo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujia pɔ tǎa Jotaŋ, Jotaŋ pɔ tǎa Aha, Aha pɔ tǎa Hɛjɛkaya. ");
INSERT INTO bmo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hɛjɛkaya pɔ tǎa Manashɛ, Manashɛ pɔ tǎa Amo, Amo pɔ tǎa Joshaya. ");
INSERT INTO bmo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joshaya pɔ tǎa Jɛkonia pugu pa lǐŋ pi. Yei ni mbɔ pɨɨ ndɨɨ yɛ ŋa ŋgwa Babiloŋ ni ŋgwɛ̄iŋ puoŋ laʼataoŋ Ishrae ŋgə̄ɨ nɔ ghɔ laʼataoŋ pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ndɨɨ ŋa puoŋ Ishrae ni ŋguʼɔ mbɔ Babiloŋ nɛ, Jɛkonia ni mbɔ tǎa Shɛatie, Shɛatie pɔ tǎa Shɛrubabɛ. ");
INSERT INTO bmo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Shɛrubabɛ pɔ tǎa Abihu, Abihu pɔ tǎa Eliakiŋ, Eliakiŋ pɔ tǎa Asho. ");
INSERT INTO bmo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asho pɔ tǎa Shadɔ, Shadɔ pɔ tǎa Akiŋ, Akiŋ pɔ tǎa Eliu. ");
INSERT INTO bmo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliu pɔ tǎa Eliasha, Eliasha pɔ tǎa Mataŋ, Mataŋ pɔ tǎa Jakɔ. ");
INSERT INTO bmo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakɔ pɔ tǎa Joshɛ mbɔ ndaoŋ Meri ŋa a ni mbhi Jishɔ ŋa pi mɛ̄iŋ vi ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nɛnnɛ ŋguoŋ ŋgwrɛiŋoŋ llɔ thɔ Abrahaŋ ti ŋgə̄ɨ nchəɨŋ mbɨŋ Devi ni mbɔ khwɛnchrɔ, llɔ thɔ Devi ti ŋgə̄ɨ nchəɨŋ ndɨɨ ŋa pi ni ŋgwɛ̄iŋ puoŋ Ishrae ŋgə̄ɨ nɔ Babiloŋ nɛ pɔ khwɛnchrɔ, llɔ ndɨɨ ŋa pi ni ŋgwɛ̄iŋ puoŋ Ishrae ŋgə̄ɨ nɔ Babiloŋ nɛ, ti ŋgə̄ɨ nchəɨŋ ndɨɨ ŋa pi ni mbhi Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, pɔ khwɛnchrɔ. ");
INSERT INTO bmo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yei ŋkwaŋ haʼaŋ nnu phi Jishɔ Krishto ni ntɔgɔ nɛ. Pi ni ŋga nōoŋ Meri mǔuŋ vi ni Joshɛ nɔ ŋgwɛ vi, ŋkaoŋ pugu yu maa nchwīe láŋ ti nji noŋ, a kwo thi pi ni shūu ntɔgɔ pi ŋkuoŋ ghrɨ́ Jijwɛ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joshɛ ndaoŋ vi ni mbɔ ŋoŋ ndɨndɨ ki lɔ ntāʼa nu māʼaŋ lrithɔ thɔ yu, nnɛ a lɔ̄gɔ nthí mi nɔ shāaŋ nu pugu yu pi njiŋnjiŋ. ");
INSERT INTO bmo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A ni ŋga ŋguʼɔ nthɔ mbīʼi nnu yei njùʼɔ yu, ŋga njəɨ nu nɛ, *ŋgaŋ ntaoŋ Taathɔ nōoŋ noŋ yi ghɔ moŋ njə̀ɨŋ, nchhu nu ŋa, “Joshɛ, muuŋ Devi, kiʼi mbɔgɔ nɔ lɔ̄gɔ nu Meri nɔ ŋgwɛ ghɔ, nthɛ ŋa muuŋ ŋa a shūu nɛ tɔgɔ pi moŋ ghrɨ́ Jijwɛ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A shi mbhi muuŋ mimbia, ɔ chhɔ̄ ligi yi ni Jishɔ nthɛ ŋa a shi ŋkwe ŋgwa pi moŋ phɨ yugu.” ");
INSERT INTO bmo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ŋguoŋ nnu pei ni ndɔ̄gɔ lɨʼɨ nɔ chwīe nu nnu ŋa Taathɔ ni nchhu ntɔgɔ mbɨŋ pa njəɨlɨʼɨ yi nɛ pɔ nnu shini ŋa: ");
INSERT INTO bmo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Līi njəɨ, Miŋgwɛ haʼaŋ a shi yaʼa ji mimbia nɛ shi nshūu mbhi muuŋ mimbia Pi chhɔ̄ ligi yi ŋa Emanue, njiŋ yi pɔ ŋa, ‘Minnwi pɔ pia pugu kaʼa.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joshɛ ni ŋga ŋgūʼu lɔgɔ, nchwīe nɔ haʼaŋ ŋgaŋ ntaoŋ Taathɔ ghɔ chhu nɛ, ndɔ̄gɔ ŋgwɛ vi. ");
INSERT INTO bmo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ndɔ paʼa ndɔ nji vi nɔ ŋgwɛ vi ti a nuʼuŋ mbhi muuŋ mimbia, Joshɛ chhɔ̄ ligi yi ni Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ndɨɨ ŋa pi ni ŋkwo phi Jishɔ Bɛtɛlɛhɛiŋ moŋ Judia nɛ, moŋ pɨɨ ndɨɨ ŋa Hɛrɔ ni mbɔ fùoŋ nɛ, ŋga njəɨ nu nɛ, ghaŋ shiethɔ llɔ ŋgei shaʼa minaoŋ thɔ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mbie ŋa, “Ju vɛ ŋa pi phi vi mbɔ fùoŋ pa Juu nɛ hɨŋ? Nthɛ ŋa pigi ni njəɨ fɨ́nəɨ ŋa a nōoŋ ŋa pi phi vi nɛ ndɨɨ ŋa a ni ŋkuʼɔ ŋgei shaʼa minaoŋ nɛ, nthɔ lɨʼɨ ghaʼo vi.” ");
INSERT INTO bmo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Fùoŋ Hɛrɔ ni ŋga njaʼo yei, nnu ghɔ ghana vi pugu pa ŋguoŋ ŋgwa Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A mɛ̄iŋ ŋguoŋ pa *thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi, mbie vugu ni lɨʼɨ ŋa pi ni mfāʼo nɔ phi nu Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pugu ni ŋkhwɛ̄ ghɔ ŋa, “Bɛtɛlɛhɛiŋ moŋ Judia nthɛ ŋa yei yaoŋ ŋa *njəɨlɨʼɨ Minnwi ni nāʼaŋ nɛ: ");
INSERT INTO bmo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ndɔ gɔ̀ ma Bɛtɛlɛhɛiŋ shhɛ Juda, ɔ lɔ njiʼi ŋkɨgəɨ shɨna pa ŋguoŋ mmɛ laʼataoŋ moŋ Juda, nthɛ ŋa yichəɨ nthishɨ ŋgwa shi ntaoŋ laʼa ghɔ ŋkɛ̄ʼi ŋgwa paŋ puoŋ Ishrae.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nɛnnɛ Hɛrɔ mɛ̄iŋ pa ghaŋ shiethɔ pighɔ njiŋnjiŋ ntou vugu ti nji ndɨɨ ŋa fɨ́nəɨ ghɔ ni ŋkuʼɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ntaoŋ vugu Bɛtɛlɛhɛiŋ, nchhu nu ŋa, “P̂əɨ ghə̄ɨ ntāʼa muuŋ ghɔ pɔpɔrɔ, ŋga njəɨ vi, pəɨ chwīe ǹji. Nnɛ ŋa mmu ŋkaa mu nthɛ ŋ̀gə̄ɨ ŋgaʼo vi.” ");
INSERT INTO bmo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pugu ni ŋga njaʼo ŋguoŋ nnu ŋa fùoŋ Hɛrɔ ni nchhu nɛ, ŋgwɛ̄iŋ ndaoŋ ŋgə̄ɨ. Ŋga njəɨ nu nɛ, fɨ́nəɨ yɛ ŋa pugu ni njəɨ ŋgei laʼataoŋ shaʼa minaoŋ nɛ ghə̄ɨ nu shhɨ pugu ti nuʼuŋ ŋgə̄ɨ ntithi nɔ lɨʼɨ haʼaŋ muuŋ ghɔ ni mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pugu ni ŋga njəɨ fɨ́nəɨ ghɔ tithi, njùʼɔ yugu pwa ti ŋgaʼa. ");
INSERT INTO bmo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pugu ni ŋga nii nda ghɔ, njəɨ muuŋ ghɔ pugu Meri mǔuŋ vi, ntuʼu noŋ yugu ŋgɨnɔ vi, mfuʼu pa maoŋ tɨnɨnchuoŋ pìɛŋ pugu, mbɔ pa laoŋgo, ni yichəɨ ŋkwaŋ lěi pi mɛ̄iŋ ni fraŋkishɛŋ, ni laminda ŋa pi mɛ̄iŋ ni məə nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nthɛ ŋa Minnwi ni ŋkwo shūu tə́nə yugu moŋ njə̀ɨŋ ŋa kiʼi pugu nuʼuŋ ŋgə̄ɨ njəɨ Fùoŋ Hɛrɔ nɛ, pugu tɔgɔ ndaoŋ nduoŋ mbɨnɨ laʼa pugu. ");
INSERT INTO bmo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ndɨɨ ŋa ghaŋ shiethɔ pighɔ ni ŋgə̄ɨ nɛ, Joshɛ gha njəɨ nu nɛ ŋgaŋ ntaoŋ Taathɔ nōoŋ noŋ yi ghɔ moŋ njə̀ɨŋ, nchhu ghɔ ŋa, “Lɔllɔ tɔthɨ ndɔ̄gɔ muuŋ vei pugu mǔuŋ vi ntei pəɨ pugu ghə̄ɨ Ijipti, ŋkɨna fɔ ti ǹshi nuʼuŋ nchhu ni pəɨ ŋa pəɨ kwəɨ pəɨ maa ŋkwəɨ. Nthɛ ŋa Hɛrɔ shi ntāʼa muuŋ ghɔ nɔ jwi nu vi.” ");
INSERT INTO bmo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A lɔllɔ tɔthɨ, ndɔ̄gɔ muuŋ ghɔ pugu mǔuŋ vi ni tuʼu pugu tei ŋgə̄ɨ Ijipti. ");
INSERT INTO bmo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ŋkɨna fɔ ti Hɛrɔ nuʼuŋ ŋkhu. Yei ni mbɔ nɔ chwīe nu nnu ŋa Taathɔ ni nchhu ntɔgɔ pi mbɨŋ njəɨlɨʼɨ yi nɛ lɔ̄gɔ lɨʼɨ, a ni nchhu ŋa, “Mi ni mɛ̄iŋ Muuŋ a, a taoŋ Ijipti.” ");
INSERT INTO bmo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hɛrɔ ni ŋga ndugwi nji ŋa ghaŋ shiethɔ pighɔ chwīe a gū na nɛ, a lɨnaoŋ ni pɨgɨtua, mfɛ gɨ́ pa shoogɛ pi taoŋ njwi ŋguoŋ puoŋ pimbia ŋa pugu pɔ jɛ̄ moŋ paa ŋgaʼo mbɨnɨ nu njiŋ nɛ, moŋ Bɛtɛlɛhɛiŋ pugu pa ŋguoŋ lɨʼɨ ghɔ ghao. A ni nchwīe yei pi llɔ ŋkuoŋ nnu ŋa a ni njaʼo mbhɔ ghaŋ shiethɔ nɔ ndɨɨ ŋa fɨ́nəɨ ghɔ ni mfǔoŋ ŋkuʼɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yei nnu ni nchwīe nnu ŋa njəɨlɨʼɨ Minnwi Jɛrimaya ni nchhu nɛ lɔ̄gɔ lɨʼɨ. Njəɨ lɨʼɨ Minnwi ghɔ mbɔ Jɛrimaya ni nchhu ŋa: ");
INSERT INTO bmo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Pi yaʼo ŋggì kuʼɔ nu Rama mbɔ ŋggì lwillwi kə̄ɨ nu, Rashe thɔ ŋkə̄ɨ puoŋ pi ndɔ ndāa ŋa kiʼi pi māʼaŋ njùʼɔ yi nthɛ ŋa pugu lɔ nuʼuŋ mbiʼi.” ");
INSERT INTO bmo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ndɨɨ ŋa Hɛrɔ ni ŋkhu nɛ, ŋga njəɨ nu nɛ, ŋgaŋ ntaoŋ Taathɔ nōoŋ noŋ yi ni Joshɛ moŋ laʼataoŋ Ijipti. ");
INSERT INTO bmo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nchhu ghɔ ŋa, “Yrɛi shhɛ, ndɔ̄gɔ muuŋ vinɛ pugu mǔuŋ vi mbɨnɨ moŋ laʼataoŋ Ishrae nthɛ ŋa ŋgwa pɛ ŋa pugu ni ntāʼa nu njwi muuŋ ghɔ nɛ khu.” ");
INSERT INTO bmo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A lɔllɔ ndɔ̄gɔ muuŋ ghɔ pugu mǔuŋ vi mbɨnɨ laʼataoŋ Ishrae. ");
INSERT INTO bmo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","A ni ŋga njaʼo ŋa a jɨ Akɛlao njɨ nda Hɛrɔ tǎa vi nɔ fùoŋ Judia, a pɔgɔ nɔ ghə̄ɨ nu fɔ. Nthɛ ŋa pi ni ŋkwo shūu tə́nə yi moŋ njə̀ɨŋ nɛ, a pɨ̄nɨ moŋ krao ŋgei Galili. ");
INSERT INTO bmo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A ni ŋgə̄ɨ ndaʼa moŋ laʼataoŋ ŋa pi mɛ̄iŋ ni Nasharɛ nɛ, nnɛ nnu ŋa pa njəɨlɨʼɨ Minnwi ni nchhu nɛ lɔ̄gɔ lɨʼɨ: “Pi lɛ mɛ̄iŋ vi ni ŋoŋ Nasharɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Moŋ pɨɨ ndɨɨ ghɔ, Jouŋ Ŋgaŋ Fɛ Ŋkhǐ ni nthɔ, nchhɔ nchīi chrà Minnwi moŋ ŋkǔnu njó moŋ Judia, ");
INSERT INTO bmo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“P̂əɨ pāʼa ŋkǔnu yəɨ ni phɨ nthɛ ŋa Shaʼafuoŋ Po kwo para.” ");
INSERT INTO bmo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jouŋ ni mbɔ ŋoŋ ŋa njəɨlɨʼɨ Minnwi mbɔ Ishaya ni nchhu nthɛ vi ndɨɨ ŋa a ni nchhu ŋa, “Ŋoŋ chəɨ thɔ mfɛ gɛ̀ moŋ ŋkǔnu njó, nchhu nu ŋa: ‘Pīri shɛndaoŋ Taathɔ, chwīe pa lɨʼɨ tɔgɔ yi pɔ yi tithi.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jouŋ ni māʼaŋ ndhwí ŋa pi chwīe pi ni ŋgì yichəɨ ŋkwaŋ minyieŋ pi mɛ̄iŋ ni kamela, ni ŋkandaŋ ŋgrào minyieŋ nɔ ntuʼu yi. Maoŋ jɨ pi ni mbɔ ŋgwíŋ pugu pa llɔ̌ ŋkǔnu. ");
INSERT INTO bmo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ŋgwa Jerushalɛiŋ pugu pa ŋgwa llɔ moŋ ŋguoŋ Judia pugu pa ŋguoŋ laʼataoŋ ŋkɨŋ Jodaŋ taoŋ ŋgə̄ɨ mbara vi, ");
INSERT INTO bmo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","a kwe vugu ni ŋkhǐ moŋ nɨnəɨ Jodaŋ pugu yūa phɨ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ndɔ a ni ŋga njəɨ ntou pa ŋgwa *Farashi pugu pa ŋgwa *Shadushi thɔ nu ŋa a kwe vugu ni ŋkhǐ nɛ, a chhu ni pugu ŋa, “Pa Mbhɛ mitwɛʼi! A shūu gɔ̌ tə́nə yəɨ ŋa pəɨ tei pɨgɨtua Minnwi ŋa a thɔ nu nɛ? ");
INSERT INTO bmo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","P̂əɨ chwīe nnu pɛ ŋa a shi nōoŋ ŋa pəɨ pāʼa ŋkǔnu yəɨ ni pəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kiʼi pəɨ nuʼuŋ nyīeŋ mbiʼi nu ŋa pəɨ shi ndūgu nthɛ ŋa pəɨ chhu nu ŋa, ‘Abrahaŋ tǎa vigi.’ Ǹchhu ni pəɨ ŋa mimfɛ Minnwi pɨʼɨ ŋgùʼɔ pei nchwīe puoŋ nɔ ghɔ mfɛ ni Abrahaŋ. ");
INSERT INTO bmo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pi kwo pīri njiɛŋ nɔ kəʼɨ nu thɨ nɔ ghɔ llɔ ŋkuoŋ ŋǐeŋ yi, nthɛ yie ghɔ sheshe thɨ ŋa a lɔ njiʼi njuŋ ntíɛŋ shiʼi nɛ, pi shi ŋkəʼɨ māʼaŋ moŋ móŋoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ŋ̀guʼɔ ŋkwe vəɨ ni ŋkhǐ pi moŋ ŋkhǐ nɔ nōoŋ nu ŋa pəɨ pāʼa ŋkǔnu yəɨ ni phɨ. Ndɔ yichəɨ ŋoŋ thɔ nu ŋa a chaa a, ǹdɔ njiʼi ŋkāʼo fɨʼɨ ŋoŋ ŋa a nthɛ ǹtiɛŋ tra yi nɛ. A shi ŋkwe vəɨ ni ŋkhǐ moŋ Jijwɛ Minnwi pugu pa móŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A tuo yaoŋ fɨgəɨ reshi mbhɔ yu, mfɨgəɨ mfuʼu ŋkiɛŋ reshi moŋ ŋkuʼu maoŋ nūʼɔŋ shaoŋ yu, ntūoŋ ŋkuʼu maoŋ ghɔ moŋ móŋoŋ ki phɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ndɨɨ ghɔ Jishɔ chəɨŋ ŋkɨŋ nɨnəɨ Jodaŋ llɔ Galili. Nthɔ njəɨ Jouŋ ŋa a kwe vi ni ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jouŋ paʼo nɔ lāa nu, nchhu nu ŋa, “A kāʼo ŋa a kwe gɔ̀ ŋkwe a ni ŋkhǐ, ɔ pɨnɨ nuʼuŋ nthɔ nu njəɨ pi mmu ŋa ŋ̀kwe ghɔ ni ŋkhǐ?” ");
INSERT INTO bmo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ndɔ Jishɔ khwɛ̄ ghɔ ŋa, “Mieŋ a pɔ nɛnnɛ ndwɛ, nthɛ ŋa yei ŋkwaŋ haʼaŋ pia shi nchwīe ŋguoŋ nnu ŋa Minnwi tāʼa nu nɛ.” Nɛnnɛ Jouŋ piŋ kiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jishɔ ni ŋga ŋkwe ŋkhǐ, ntaoŋ moŋ ŋkhǐ chomilaoŋ ghɔ. Ŋga njəɨ po ŋaʼaŋ, a yəɨ Jijwɛ Minnwi taoŋ po nɔ mintuʼɔlibuŋ ndia mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ŋga njəɨ nu nɛ, yichəɨ ŋggì chhu po ŋa, “Yei muuŋ a ŋa ŋ̀khwā ǹja mfāʼo pwanjuʼɔ nthɛ vi.” ");
INSERT INTO bmo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nɛnnɛ Jijwɛ Minnwi lɔ̄gɔ Jishɔ ŋgə̄ɨ ni ju moŋ ŋkǔnu njó ŋa devɨ mōoŋ vi fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A ni ŋga njī ŋkhǐ nɔ khwɛ wuŋ naoŋchɨ pugu pa khwɛ wuŋ tuʼu, njì yia vi. ");
INSERT INTO bmo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nnɛ devɨ, mbɔ ŋgaŋ mōoŋ ŋoŋ thɔ nchhu ghɔ ŋa, “Ɔ̈ mbɔ Muuŋ Minnwi nɛ, ɔ fɛ nɛ gɨ́ pa ŋgùʼɔ pei kara ŋgū brɛi pia.” ");
INSERT INTO bmo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ndɔ a khwɛ̄ ghɔ ŋa, “Pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, ‘Ŋoŋmishua shiʼa ŋguʼɔ njru pi ŋkuoŋ brɛi təʼɨ vi, ndɔ a ghà mbɨnɨ njru ŋkuoŋ ŋguoŋ chrà ŋa a taoŋ nchò Minnwi nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nnɛ devɨ lɔ̄gɔ vi ŋgə̄ɨ pugu yu Jerushalɛiŋ, mbɔ mmɛ laʼataoŋ taoŋtaoŋ, ntigi vi ŋkuoŋ nchwɛrɛ *Nda Minnwi, ");
INSERT INTO bmo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nchhu ghɔ ŋa, “Ɔ̈ mbɔ Muuŋ Minnwi, ɔ thi nɛ hɛiŋ ndhi nchəɨŋ shhɛ nthɛ ŋa pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, ‘Minnwi shi mfɛ gɨ́ ni pa ghaŋ ntaoŋ pi nthɛ ghɔ, pugu jā ghɔ tɔthɨ ni mbhɔ, nnɛ ŋa kiʼi ɔ chhwi kwò yɔ ŋkuoŋ ŋgùʼɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jishɔ khwɛ̄ ŋa, “Pi pɨnɨ nuʼuŋ nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, ‘Kiʼi ma njwɛʼi Taathɔ mbɔ Minnwi yɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Devɨ lɔ̄gɔ vi ŋkamuʼɔŋ ŋkuʼɔ ni ju ŋkuoŋ thɔ ŋkiɛŋ ntaaŋ mbra, nōoŋ ŋguoŋ pa laʼataoŋ ŋkuoŋ mbhi ghɔ pugu pa ndighaʼo yugu, ");
INSERT INTO bmo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","nchhu ghɔ ŋa, “Ǹshi mfɛ ŋguoŋ yi vɛ ghao nɔ haʼaŋ ɔ̈ ŋgū shhɛ ŋgaʼo a.” ");
INSERT INTO bmo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nnɛ Jishɔ khwɛ̄ ghɔ ŋa, “Lɔllɔ shhɨ a, ma Shata! Nthɛ ŋa pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, ‘Ghaʼo Taathɔ mbɔ Minnwi yɔ, ŋguʼɔ mfāʼa pi mbhɔ yu təʼɨ vi.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nɛnnɛ devɨ mieŋ vi ŋgə̄ɨ, ŋga njəɨ nu, pa ghaŋ ntaoŋ Minnwi thɔ māʼaŋ ghrɨ́ yi. ");
INSERT INTO bmo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ndwɛ Jishɔ ni ŋga njaʼo ŋa pi kwo wɛ̄iŋ Jouŋ, a pɨ̄nɨ njiŋ nii Galili. ");
INSERT INTO bmo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A ni ndhɔ moŋ laʼataoŋ Nasharɛ, ŋgə̄ɨ nthɔ nchhɔ nu Kapanuŋ, mbɔ laʼataoŋ ŋa a ni mbɔ ŋkɨŋ ŋkhǐ, ŋgei laʼataoŋ Shɛbuluŋ pugu Naftali, ");
INSERT INTO bmo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","nɛnnɛ ŋa nnu ŋa njəɨlɨʼɨ Minnwi, mbɔ Ishaya, ni nāʼaŋ nɛ lɔ̄gɔ lɨʼɨ: ");
INSERT INTO bmo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Laʼataoŋ Shɛbuluŋ pugu laʼataoŋ Naftali, shɛndaoŋ ghə̄ɨ nu cho mmɛ ŋkhǐ, mfərə Jodaŋ, ŋgwa ŋa pugu laʼa nu krao ŋgei Galili ŋa ŋgwa taoŋ nduoŋ ni mbɔ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ŋgwa ŋa pugu chhɔ nu moŋ njiŋ nɛ yəɨ mmɛ líʼɛ. Ni ŋgwa ŋa pugu chhɔ pi moŋ miliʼi gu nɛ, líʼɛ kwo thɛ mbɨŋ pugu.” ");
INSERT INTO bmo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jɛ̄ ndɨɨ ghɔ, Jishɔ jɛ̄ nthɔ nchīi chrà Minnwi ŋa, “P̂əɨ pāʼa ŋkǔnu yəɨ ni phɨ, nthɛ ŋa Shaʼafuoŋ Po kwo para.” ");
INSERT INTO bmo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jishɔ ni ŋga nyīeŋ nu ŋkɨŋ mmɛ ŋkhǐ Galili, njəɨ paa pimbia mbɔ pa lǐŋ. Shemu, ŋa pi mɛ̄iŋ vi ni Pita nɛ, pugu Andru ndǐŋ vi, pugu thɔ māʼaŋ ndáŋ moŋ ŋkhǐ nthɛ ŋa pugu ni mbɔ pi ghaŋ ŋgunu. ");
INSERT INTO bmo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jishɔ chhu ni pugu ŋa, “P̂əɨ yōu njiŋ a, ǹchwīe pəɨ pɔ ghaŋ wɛ̄iŋ ŋgwamishua.” ");
INSERT INTO bmo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wuʼɔ ndɨɨ ghɔ, pugu mieŋ ndáŋ pugu njōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A gha ndɔllɔ fɔ ŋgə̄ɨ nu, mbɨnɨ njəɨ pichəɨ paa pa lǐŋ, Jɛiŋ mbɔ muuŋ Shebedi pugu Jouŋ ndǐŋ vi moŋ kikuoŋ pugu pa Shebedi tǎa vugu, pugu chhɔ ntaʼa pa ndáŋ yugu. A gɛ̄ vugu. ");
INSERT INTO bmo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wuʼɔ ndɨɨ ghɔ, pugu mieŋ kikuoŋ yugu pugu pa tǎa vugu njōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jishɔ nyīeŋ moŋ ŋguoŋ Galili ghao, nthɔ njɛʼi ŋgwa moŋ pa *nda luoŋ Minnwi, nthɔ nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ mbɔ yi Shaʼafuoŋ, nthɔ njɨ̄gɨ ŋguoŋ ŋkwaŋ ghɨ̌nɔ pugu pa chəɨchəɨ mbɨŋ ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nnɛ ndighaʼo yi ghə̄ɨ shhɨ nyīeŋ moŋ ŋguoŋ Shiria. Pi thɔ ni ŋguoŋ ghaŋ ghɨ̌nɔ, pa ghaŋ ŋgwa pɛ ŋa ŋguoŋ ŋkwaŋ ŋkwaŋ ghɨ̌nɔ pugu pɔ yúʼɔ pɔ mbɨŋ pugu nɛ, pa ŋgwa ŋa miŋwɛiŋ ni mfɛ ŋgəʼɨ ni pugu, ghaŋ guthɔ, pa ŋgwa ŋa pichəɨ lɨʼɨ noŋ yugu khu nɛ, a yɨ̄gɨ ghɨ̌nɔ ŋguoŋ yugu ghao. ");
INSERT INTO bmo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ŋkiɛŋ mmɛ yú ŋgwa yōu njiŋ yi llɔ moŋ ŋguoŋ Galili pugu pa moŋ Dekapoli pugu pa moŋ Jerushalɛiŋ ni Judia ti ŋgə̄ɨ ti mfərə nɨnəɨ Jodaŋ. ");
INSERT INTO bmo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jishɔ ni ŋga njəɨ ntou yú ŋgwa, ŋkuʼɔ ŋkuoŋ mbra ŋga nchɔchhɔ shhɛ, pa ghaŋ younjiŋ pi thɔ mbara vi. ");
INSERT INTO bmo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A ŋaʼaŋ nchò yi njɛʼi vugu, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mbɔrɔ yi ghaŋ pou moŋ jijwɛ, nthɛ ŋa Shaʼafuoŋ Po pɔ pi yugu. ");
INSERT INTO bmo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mbɔrɔ yi ŋgwa pɛ ŋa pugu pɔ ni tuʼuthɔ nɛ, nthɛ ŋa Minnwi shi māʼaŋ njùʼɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mbɔrɔ yi ŋgwa pɛ ŋa pugu pɔ juju nɛ, nthɛ ŋa ŋkuoŋ shhɛ lɛ mbɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mbɔrɔ yi ŋgwa pɛ ŋa pugu fāʼo njì pugu pa yaoŋ njùʼɔ nthɛ nnu ndɨndɨ nɛ, nthɛ ŋa pi shi nchwīe pugu yru. ");
INSERT INTO bmo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mbɔrɔ yi ghaŋ kwoshɨnɨ, nthɛ ŋa pi shi nōoŋ kwoshɨnɨ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mbɔrɔ yi ŋgwa pɛ ŋa njùʼɔ yugu yi taoŋtaoŋ nɛ, nthɛ ŋa pugu shi njəɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mbɔrɔ yi ghaŋ chwīe taʼaŋggi, nthɛ ŋa pi shi mɛ̄iŋ vugu ni pa puoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mbɔrɔ yi ŋgwa pɛ ŋa pi fɛ ŋgəʼɨ ni pugu nthɛ nnu ndɨndɨ nɛ, nthɛ ŋa Shaʼafuoŋ Po shi mbɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mbɔrɔ yəɨ ndɨɨ ŋa ŋgwa wɛʼi vəɨ, mfɛ ŋgəʼɨ ni pəɨ, ndɔ ndɛʼi ŋgiɛŋ nchhu ŋguoŋ ŋkwaŋ nnu pɨphɨ thɔ pəɨ nthɛ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","P̂əɨ tɛnɛ ndɔ mfāʼo pwanjuʼɔ nthɛ ŋa ŋkiɛŋ mmɛ kɨ̀nɛiŋ pɔ ni pəɨ po, nthɛ ŋa a wuʼɔ haʼaŋ pugu ni mfɛ ŋgəʼɨ ni pa njəɨlɨʼɨ Minnwi ŋa pugu ni mfǔoŋ nthɔ shhɨ pəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Pəɨ pa khí ŋkuoŋ shhɛ, ndɔ ti khí mbhɛ̌ ghrɨ́ yi nɔ chwīe nu yaoŋ pwa, ɔ pɨnɨ nuʼuŋ ŋkwəɨ ni ghrɨ́ yi ghɔ pi nɛiŋ? A lɔ nuʼuŋ mfāʼo ghɛ̀rɛ nɔ sheshe yaoŋ, ŋkiɛŋ ŋa pi mīʼaŋ vi ŋgwamishua nɨ̄ɨ ni kwò yugu. ");
INSERT INTO bmo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Pəɨ pɔ nɔ líʼɛ ni ŋguoŋ ŋgwa ŋkuoŋ mbhi. Mmɛ laʼataoŋ ŋa pi krao ŋkuoŋ mbra nɛ shiʼa njiʼi ndə̄ɨŋ noŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ŋoŋ shiʼa nchuʼu truka niʼiŋ laʼo mikuo, pi ghà ntigi pi ŋkuoŋ lɨʼɨ tigi truka, a fɛ líʼɛ ni ŋguoŋ ŋgwa ŋa pugu pɔ moŋ nda nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wuʼɔ nɛnnɛ, a pie ŋa líʼɛ yəɨ thɛ shhɨ ŋgwamishua, nnɛ ŋa a nthɛ pugu yəɨ pa fàʼa pəɨ pi shiʼi, ŋgaʼo Tǎa vəɨ ŋa a pɔ po nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kiʼi pəɨ pīʼi ŋa ǹthɔ pi nɔ lāa nu gɨ́ ki pa nnu ŋa pa njəɨlɨʼɨ Minnwi yɛʼi nɛ, ǹshini ndɔ nthɔ pi nɔ lāa nu, ŋki thɔ pi nɔ chwīe nu nnu ŋa pugu yɛʼi nu nɛ lɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nthɛ ŋa shishini ǹshwei vəɨ ŋa, nɔ haʼaŋ po pugu shhɛ wuʼɔ mbɔ nɛ, mbaʼa taʼa muuŋ mi ligi yaoŋ, ki taʼa pra ligi yaoŋ yiʼi ntɔgɔ ghagha moŋ ŋwaʼaŋlɨ gɨ́ ki lɔ ndɔ̄gɔ lɨʼɨ pi wuʼɔ nɔ haʼaŋ pi nāʼaŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nthɛ yie ghɔ, shesheŋoŋ ŋa a pəʼɨ taʼa muuŋ mi kɨ̀na shɨna pa kɨ̀na pei, ndɔ njɛʼi ŋgwa nduoŋ nɔ chwīe nu nɛnnɛ ŋkaa pugu nɛ, pi shi ma mɛ̄iŋ vi ni ndugwi muuŋ mi ŋoŋ moŋ Shaʼafuoŋ Po, ndɔ ti shesheŋoŋ ŋa a nūʼɔŋ gɨ́ pighɔ ndɔ njɛʼi ŋgwa nduoŋ ŋa pugu nūʼɔŋ nɛ, pi shi ma mɛ̄iŋ vi ni ŋoŋ ndiɛŋ moŋ Shaʼafuoŋ Po. ");
INSERT INTO bmo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nthɛ yie ghɔ, ǹshwei vəɨ ŋa n̈dɨndɨ yəɨ mieŋ ki lɔ nchaa yi pa ghaŋ yɛʼi gɨ́ Mushi pugu pa ŋgwa Farashi, paʼa pəɨ lɔ nii moŋ Shaʼafuoŋ Po. ");
INSERT INTO bmo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Pəɨ yaʼo ŋa pi ni nchhu ni ŋgwa llɛshhɨ ŋa, ‘Kiʼi pəɨ ma njwi ŋoŋ, ndɔ shesheŋoŋ ŋa a jwi ŋoŋ nɛ shi nthi sháʼa.’ ");
INSERT INTO bmo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ndɔ ǹchhu ni pəɨ ŋa shesheŋoŋ ŋa a pɨgɨtua ni ndǐŋ vi nɛ shi nthi sháʼa, ɔ̈ nchhu ni ndǐŋ ghɔ ŋa, ‘Ŋoŋ ghagha yei,’ kaŋ pi shi ŋgə̄ɨ ni gɔ nda nchaʼo, ndɔ shesheŋoŋ ŋa a chhu ni ndǐŋ vi ŋa, ‘Ɔ na,’ minthɛ a pɔ moŋ lwilwiʼi nɔ ghə̄ɨ nu moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Nthɛ yie ghɔ, ɔ̈ nthɔ nu lɨʼɨ mfɛ yaoŋ fɛ́ yɔ ŋkuoŋ *lɨʼɨ fɛʼiŋgiɛŋ ŋkwiŋ fɔ ŋa ndǐŋ ghɔ fāʼo nnu njùʼɔ yu nthɛ ghɔ, ");
INSERT INTO bmo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ɔ̂ mieŋ yaoŋ fɛ́ yɔ fɔ shhɨ lɨʼɨ fɛʼiŋgiɛŋ mfǔoŋ mbɨnɨ ŋgə̄ɨ ndugwi, nchīni ŋggì pəɨ ndǐŋ ghɔ, nnɛ mbɨnɨ kiʼɛ mfɛ yaoŋ fɛ́ yɔ. ");
INSERT INTO bmo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ŋ̈oŋ nchhu nnu thɔ ghɔ pəɨ yu fāʼo nɔ thi nu sháʼa ndashaʼa, kə̄nə pəɨ yu lūgwi ŋkaoŋ maa nchəɨŋ ndashaʼa, kaŋ a shi nchaʼa ghɔ nɛ mfɛ ni brushi pi niʼiŋ ghɔ chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Shishini, ǹshwei ghɔ, mbaʼa ɔ ma ntaoŋ ki lɔ naa mbe ŋguoŋ njɔ́ yɔ ghao. ");
INSERT INTO bmo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Pəɨ yaʼo ŋa pi ni nchhu ŋa, ‘Kiʼi ŋgaŋ láŋ kwoshuoŋ.’ ");
INSERT INTO bmo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ndɔ ǹchhu ni pəɨ ŋa, sheshe mimbia ŋa a pɛʼi miŋgwɛ nshɔ̄rɔ nūaŋ nu pugu yu nɛ, kwo nūaŋ pugu yu moŋ njùʼɔ yu. ");
INSERT INTO bmo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nɛnnɛ, ŋ̈gei ligi yɔ yi jɨ nchwīe ŋa ɔ gū moŋ phɨ, ɔ̂ fīʼa mfuʼu mīʼaŋ nthɛ ŋa a pwa ŋa a phɛ taʼa ghrà noŋ yɔ nchaa ŋa ŋguoŋ noŋ yɔ ghə̄ɨ moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ti ŋgei mbhɔ yɔ yi jɨ nchwīe ŋa ɔ chwīe phɨ, ɔ̂ yaʼa mīʼaŋ, a pwa ŋa a phɛ taʼa ghrà noŋ yɔ nchaa ŋa ŋguoŋ noŋ yɔ ghə̄ɨ moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Pi ni mbɨnɨ nchhu ŋa, ‘Shesheŋoŋ ŋa a shāaŋ láŋ pugu ŋgwɛ vi nɛ, a pie ŋa a fɛ ŋwaʼaŋlɨ shāaŋ láŋ ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ndɔ ndwɛ ǹshwei vəɨ ŋa, shesheŋoŋ ŋa a shāaŋ láŋ pugu ŋgwɛ vi nthɛ sheshe nnu ŋkiɛŋ pi nnu shúoŋ nɛ, ŋoŋ ghɔ ŋgushaʼa nɔ chwīe nu miŋgwɛ ghɔ kwo shúoŋ nɔ haʼaŋ a mbɨnɨ ndaŋ, ndɔ mimbia ŋa a laŋ miŋgwɛ ŋa a taoŋ láŋ nɛ kwo shúoŋ ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Pəɨ ni mbɨnɨ njaʼo ŋa pi ni nchhu ni pa ŋgwa llɛshhɨ ŋa, ‘Kiʼi ma shwrɛ̄i nnu ni mbe, ndɔ chwīe nnu ŋa ɔ shwrɛ̄i ni Taathɔ ŋa ɔ shi nchwīe nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ndɔ ǹchhu ni pəɨ ŋa kiʼi nshwrɛ̄i nnu kaŋ shɨgɛi, kiʼi nshwrɛ̄i po nthɛ ŋa a faaŋ Minnwi, ");
INSERT INTO bmo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ki shhɛ, nthɛ ŋa a krɨ́ tigi kwò Minnwi, ki Jerushalɛiŋ, nthɛ ŋa a laʼataoŋ Fùoŋ ndiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kiʼi njiʼi ndɔ nshwrɛ̄i pi thɔ yɔ nthɛ ŋa minthɛ paʼa ɔ lɔ nchwīe taʼa ŋgiithɔ a pɔ pi yi fhu ki yi shhi. ");
INSERT INTO bmo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ndɔ a pie ŋa, ‘Ooŋ’ yəɨ pɔ ‘Ooŋ’ ki ‘Ŋga’ yəɨ pɔ ‘Ŋga.’ Sheshe nnu nduoŋ ntɔgɔ yei llɔ pi mbhɔ ŋoŋ mbɨmbhɨ. ");
INSERT INTO bmo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Pəɨ ni njaʼo ŋa pi chhu ŋa, ‘Ŋ̈oŋ mfuʼu taʼa ligi ŋoŋ pi fuʼu ji, ti ŋoŋ nchuʼɔ taʼa shua ŋoŋ pi chuʼɔ ji.’ ");
INSERT INTO bmo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ndɔ ǹchhu ni pəɨ ŋa kiʼi nduʼu phɨ ŋoŋ ni phɨ. Ŋ̈oŋ ŋgwie ŋgei ghə̀ʼɨ yɔ yi jɨ, ɔ kara ŋgei mbhɔ ŋkwrɛi a wie ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ŋ̈oŋ mburu ghɔ ŋkwe muuŋ ndhwí yɔ, ɔ̂ mieŋ a kwe mmɛ ndhwí yɔ ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ŋ̈oŋ ŋɨ ghɔ ŋa ɔ nyīeŋ taʼa ŋkaŋ ni tiɛŋ ŋkɨɨ kwò, ɔ̂ ghə̄ɨ trɛi ŋkaŋ kwò pəɨ yu. ");
INSERT INTO bmo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ŋ̈oŋ nduoŋ yaoŋ mbhɔ ghɔ, ɔ̂ fɛ ghɔ, ŋ̈oŋ mfōo yaoŋ mbhɔ ghɔ, kiʼi ɔ lāa fɛ nu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Pəɨ ni njaʼo ŋa pi chhu ŋa, ‘Ɔ khwā taakuo yɔ, mbɨ̄na mbɨ̌na yɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ndɔ ǹchhu ni pəɨ ŋa, P̂əɨ khwā pa mbɨ̌na pəɨ, nduoŋ Minnwi mfɛ ni ŋgwa pɛ ŋa pugu fɛ ŋgəʼɨ ni pəɨ nɛ, ");
INSERT INTO bmo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","nnɛ ŋa pinthɛ pəɨ pɔ puoŋ Tǎa vəɨ ŋa a pɔ po nɛ, nthɛ ŋa a ghà nchwīe minaoŋ yi thɛ mbɨŋ pa ŋgwa pɨphɨ pugu pa ŋgwa shiʼi, mfɛ mbɨ̀ ni ŋgwa ndɨndɨ pugu pa ŋgwa təɨtəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Minnwi shi ŋkɨnɛiŋ ghɔ nthɛ pi khɔ nɔ haʼaŋ ɔ̈ ŋguʼɔ ŋkhwā pi ŋgwa pɛ ŋa pugu khwā ghɔ nɛ? Njiʼi nthɛ pi pa ŋgwɛ̄iŋ taashi ghà ŋguʼɔ nchwīe pi nnɛ. ");
INSERT INTO bmo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ti p̈əɨ ŋguʼɔ nthɔ nchrā pi ni lǐŋ pəɨ, nnu ghaghaʼa fɔ pɔ pi khɔ? Njiʼi nthɛ pi ghaŋ ki piŋ Minnwi shiʼa nchwīe nɛnnɛ? ");
INSERT INTO bmo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nthɛ yie ghɔ, p̂əɨ pɔ ŋgwa tithi nɔ haʼaŋ Tǎa vəɨ po ŋoŋ tithi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pəɨ lɨna nu nɔ fāʼa nu fàʼa ndɨndɨ yəɨ shhɨ ŋgwa pi ŋa pugu yəɨ vəɨ, nthɛ ŋa p̈əɨ nchwīe nɛnnɛ, paʼa pəɨ lɔ njiʼi mfāʼo kɨ̀nɛiŋ mbhɔ Tǎa vəɨ ŋa a pɔ po nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nɛnnɛ, ndɨɨ ŋa ɔ fɛ yaoŋ ni ghaŋ pou nɛ, kiʼi ɔ tua ntàŋ nɔ chwīe nu ŋgwa ji nɔ haʼaŋ ghaŋ mifɨɨ ghà nchwīe moŋ pa nda luoŋ Minnwi pugu pa taʼandaoŋ, nnɛ ŋa pa ŋgwamishua piŋ vugu. Shishini ǹshwei vəɨ, pugu kwo fāʼo kɨ̀nɛiŋ yugu ti a kāʼo. ");
INSERT INTO bmo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ndɔ ti ndɨɨ ŋa ɔ fɛ yaoŋ ni ghaŋ pou nɛ, kiʼi nchwīe ŋgei mbhɔ yɔ yi ŋkwrɛi yəɨ yaoŋ ŋa ŋgei mbhɔ yɔ yi jɨ chwīe nu nɛ, ");
INSERT INTO bmo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","nnɛ ŋa fɛ́ yɔ pɔ yi lə̄ɨŋ, Tǎa ghɔ ŋa a ghà njəɨ nnu ŋa pi chwīe lə̄ɨŋ nɛ shi ŋkɨnɛiŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ndɨɨ ŋa pəɨ luoŋ Minnwi nɛ, kiʼi pəɨ pɔ nɔ ghaŋ mifɨɨ, nthɛ ŋa pugu khwā nɔ thi nu nduoŋ Minnwi moŋ pa nda luoŋ Minnwi pugu pa ŋkɨŋ ndaoŋ, nnɛ ŋa ŋgwa yəɨ vugu. Shishini, ǹshwei vəɨ, pugu kwo fāʼo kɨ̀nɛiŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ndɔ ndɨɨ ŋa ɔ luoŋ Minnwi nɛ, ghə̄ɨ moŋ njiɛŋ nda yɔ, nchri chonda nduoŋ ni Tǎa ghɔ ŋa a pɔ lɨʼɨ lə̄ɨŋ nnɛ kaŋ Tǎa ghɔ ŋa a ghà njəɨ nnu ŋa pi chwīe lə̄ɨŋ nɛ shi ŋkɨnɛiŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ndɨɨ ŋa pəɨ luoŋ Minnwi nɛ, kiʼi nthɔ nchrā mbiʼi pa nnu ghagha ŋa a lɔ mfāʼo njiŋ yi ŋkwaŋ nɔ haʼaŋ pa ghaŋ ki piŋ Minnwi ghà nchwīe nɛ, nthɛ ŋa pugu pīʼi ŋa Minnwi shi ŋkhwɛ̄ luoŋ yugu nthɛ pi ntou chrà pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nɛnnɛ, kiʼi mbɔ nɔ pugu nthɛ ŋa Tǎa vəɨ ji yaoŋ ŋa pəɨ pou nu nɛ ŋkaoŋ pəɨ maa ndɔ mbie vi nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yei kiʼɛ, ŋkwaŋ haʼaŋ pəɨ shi nduoŋ nɛ: Tǎa vigi ŋa a chhɔ po nɛ, ghaʼo nu pɔ ni ligi yɔ. ");
INSERT INTO bmo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Shaʼafuoŋ yɔ thɔ, nnu ŋa ɔ tāʼa nu nɛ pɔ, ŋkuoŋ shhɛ nɔ haʼaŋ a pɔ po nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fɛ maoŋ ŋa a pie ŋa pigi yru ŋkuoŋ ghɔ shiʼa nɛ ni pigi. ");
INSERT INTO bmo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ndɔ ndīʼɛ phɨ yigi, nɔ haʼaŋ pigi ŋkaa pigi ghà ndīʼɛ phɨ ŋgwa pɛ ŋa pugu fāaŋ mbɨŋ pigi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kiʼi nchwīe pigi nii moŋ tɨtɨnɨ mōoŋ nu ndɔ kwe vigi mbhɔ ŋoŋ mbɨmbhɨ. ");
INSERT INTO bmo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nthɛ ŋa p̈əɨ ndīʼɛ phɨ ŋa ŋgwa nduoŋ chwīe mbɨŋ pəɨ nɛ, kaŋ Tǎa vəɨ ŋa a pɔ po nɛ shi ndīʼɛ yəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ndɔ ti p̈əɨ mieŋ ki līʼɛ phɨ ŋa ŋgwa nduoŋ chwīe mbɨŋ pəɨ nɛ, kaŋ mbaʼa Tǎa vəɨ po yiʼi ndīʼɛ yəɨ ŋkaa pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Sheshe ndɨɨ ŋa pəɨ jī ŋkhǐ nɛ, kiʼi pəɨ chwīe ligi yəɨ kūo nɔ pa ghaŋ mifɨɨ, nthɛ ŋa pugu ghà nchwīe ligi yugu fūŋ nnɛ ŋa shesheŋoŋ ji ŋa pugu jī ŋkhǐ. Shishini ǹshwei vəɨ, pugu kwo fāʼo kɨ̀nɛiŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ndɔ gɔ̀, ndɨɨ ŋa ɔ jī ŋkhǐ nɛ, shiri thɔ yɔ ni wru, nshɨ̄gao ligi yɔ, ");
INSERT INTO bmo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nnɛ ŋa kiʼi ŋgwa yəɨ ŋa ɔ thɔ njī ŋkhǐ, ndɔ a wuʼɔ njəɨ Tǎa ghɔ ŋa a pɔ moŋ lɨʼɨ lə̄ɨŋ nɛ, nnɛ Tǎa ghɔ ŋa a ghà njəɨ nnu ŋa ɔ chwīe nu lə̄ɨŋ nɛ shi ŋkɨnɛiŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kiʼi pəɨ lə̄ɨŋ pa fāʼo ni noŋ pəɨ ŋkuoŋ shhɛ hɛiŋ lɨʼɨ ŋa shə́ʼɨ pugu pa wrukiɛŋ shi mbɨrɨ nɛ, lɨʼɨ haʼaŋ pa ŋgɨna shi mbəʼɨ nii njōo nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ndɔ pəɨ lə̄ɨŋ pa fāʼo ni noŋ pəɨ pi po, mbɔ lɨʼɨ haʼaŋ mbaʼa shə́ʼɨ, ki wrukiɛŋ yiʼi mbɨrɨ nɛ, ndɔ mbɔ lɨʼɨ haʼaŋ mbaʼa pa ŋgɨna pəʼɨ nii njōo. ");
INSERT INTO bmo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nthɛ ŋa lɨʼɨ ŋa fāʼo yɔ pɔ nɛ, a lɨʼɨ ŋa njùʼɔ yɔ shi mbɔ ŋkaa yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ligi yɔ pɔ pi laŋ noŋ yɔ, nɛnnɛ l̈igi yɔ mbɔ shiʼi, mbɔ ŋa mbhɔ yɔ ghà ntaoŋ, ŋguoŋ noŋ yɔ lɨnaoŋ ni líʼɛ. ");
INSERT INTO bmo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ndɔ l̈igi yɔ mieŋ ki pɔ shiʼi, mbɔ ŋa ɔ ŋgaŋ ghìʼɛ, ŋguoŋ noŋ yɔ lɨnaoŋ ni njiŋnjiŋ. Ä mbɔ ŋa líʼɛ ŋa ɔ pīʼi ŋa ɔ fāʼo nɛ pɔ pi njiŋnjiŋ, kaŋ njiŋnjiŋ ghɔ ghaʼo pi ŋkwaŋ nɛiŋ! ");
INSERT INTO bmo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mbaʼa taʼa ŋoŋ pɔ muuŋ fàʼa mbhɔ paa masha, nthɛ ŋa a shi mbɨ̄na taʼa yi ŋkhwā vichəɨ, ki nɛ, a fɛ noŋ yi ni taʼa yi nchɨ̄ʼə vichəɨ. Mbaʼa pəɨ fāʼa mbhɔ Minnwi pugu mbɨŋ. ");
INSERT INTO bmo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nthɛ yie ghɔ, ǹchhu ni pəɨ ŋa kiʼi pəɨ fāʼo ghana njùʼɔ nthɛ chɔmbhi yəɨ ŋa pəɨ shi njɨ pi khɔ ki nnu khɔ, ki nthɛ ŋgrào noŋ yəɨ ŋa pəɨ shi māʼaŋ pi khɔ? Chɔmbhi lɔ nchaa maoŋ jɨ, noŋ yəɨ chaa ndhwí? ");
INSERT INTO bmo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pɛʼi pa mishi ŋa pugu ghà njei tɔthɨ njəɨ, pugu shiʼa mbhi maoŋ, ki kwōo, ki nūʼɔŋ maoŋ shaoŋ, ndɔ Tǎa vəɨ po ghà ŋkugwi vugu ghao. Pəɨ lɔ ŋgāʼo nchaa pa mishi? ");
INSERT INTO bmo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Minthɛ shesheŋoŋ vəɨ pɨnɨ mbīgi chɔmbhi yi wuʼɔ shɨgɛi nthɛ ŋa a wie noŋ yi? ");
INSERT INTO bmo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ti pəɨ fāʼo ghana njùʼɔ nthɛ ndhwí pi nɔ khɔ? Pīʼi mbɨŋ pa frawa moŋ trǔ, pugu shiʼa mfaʼa ndɔ paʼa ndɔ ntuŋ ndhwí, ");
INSERT INTO bmo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ndɔ ǹshwei vəɨ ŋa njiʼi nthɛ pi Sholomu moŋ ŋguoŋ ndighaʼo yi ghao shini ndɔ mbwa ti nchəɨŋ nɔ taʼa frawa. ");
INSERT INTO bmo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ti M̈innwi māʼaŋ fɨʼɨ ndìpwa yei mbɨŋ pa trǔ ŋa a yi maoŋ shiʼa, yua gha mbɔ nu a kwo yaoŋ ti pi tūoŋ nɛ, pəɨ pīʼi ŋa a shi ndɨna ni pəɨ pi fɨʼɨ yi nɛiŋ? Ŋgwa piŋ kikɛʼi pei? ");
INSERT INTO bmo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kiʼi pəɨ fāʼo ghana njùʼɔ, nthɔ nchhu nu ŋa, ‘Ti pigi shi njɨ pi khɔ, ki pigi shi nnu pi khɔ, ki pigi shi māʼaŋ pi khɔ?’ ");
INSERT INTO bmo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nthɛ ŋa pa ghaŋ ki piŋ Minnwi thɔ ntei pi njiŋ pa maoŋ pei, Tǎa vəɨ po ji ŋa a pie ŋa pəɨ fāʼo maoŋ pei. ");
INSERT INTO bmo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pəɨ ka shigi pi Shaʼafuoŋ Minnwi pugu pa ndɨndɨ yi, kaŋ Minnwi shi mfɛ ŋguoŋ maoŋ pei ghao ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Nthɛ yie ghɔ, kiʼi njùʼɔ yɔ ghana nthɛ llɛmbhi yua, nthɛ ŋa llɛmbhi yua fāʼo ji pa nnu nɔ ghana nu nɔ ghɔ. Sheshe llɛ́ fāʼo pa ji ghaghaʼa. ");
INSERT INTO bmo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kiʼi pəɨ shaʼa pa ŋgwa nduoŋ nnɛ ŋa kiʼi pi shaʼa vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nthɛ ŋa nɔ haʼaŋ pəɨ shaʼa ŋgwa nduoŋ nɛ, a ŋkwaŋ haʼaŋ pi shi nshaʼa vəɨ nɛ, nthɨŋkwo haʼaŋ pəɨ lɔ̄gɔ nɔ shaʼa nu ŋgwa nɔ nɛ, pi shi nshaʼa vəɨ pi wuʼɔ ni fɨʼɨ nthɨŋkwo ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“A chwīe khɔ ɔ yəɨ muuŋ ŋkuʼu thɨ ŋa a pɔ ligi ndǐŋ ghɔ, ndɔ ki lɔ mfāʼo ndɨɨ ni mmɛ mbɨɨ ŋkwɛiŋ ŋa a pɔ moŋ jɔ ligi nɛ? ");
INSERT INTO bmo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ki minthɛ ɔ kie nɛiŋ nchhu ni ndǐŋ ghɔ ŋa, ‘Naʼaŋ mfuʼu ŋkuʼu thɨ ligi ghɔ,’ ndɔ mmɛ mbɨɨ ŋkwɛiŋ lɔ mbɔ nɔ jɔ ligi? ");
INSERT INTO bmo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ŋgaŋ mifɨɨ vei, fǔoŋ mfuʼu mmɛ mbɨɨ ŋkwɛiŋ ŋa a pɔ moŋ jɔ ligi nɛ ŋkaoŋ, kaŋ ɔ shi njəɨlɨʼɨ shishiʼi nɔ fuʼu nu muuŋ ŋkuʼu thɨ ŋa a pɔ ligi ndǐŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kiʼi mfɛ yaoŋ ŋa a yi taoŋtaoŋ nɛ ni pa miŋgu, kaŋ pugu shi ŋkara nshāa ghɔ paapaa, ndɔ kiʼi pəɨ māʼaŋ pa ŋgùʼɔ tɨnɨnchuoŋ ŋa pi mɛ̄iŋ ni pəə nɛ shhɨ pa miŋkunyaŋ, kaŋ pugu shi nɛ nɨ̄ɨ ni kwò. ");
INSERT INTO bmo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“P̂əɨ pie, kaŋ Minnwi shi mfɛ ni pəɨ, p̂əɨ taʼa, kaŋ Minnwi shi nchwīe pəɨ yəɨ, p̂əɨ kwēi kaŋ Minnwi shi nchuʼɔ chonda ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nthɛ ŋa shesheŋoŋ ŋa a pie nɛ, ghà mfāʼo, ŋoŋ ŋa a tāʼa nɛ yəɨ, ni ŋoŋ ŋa a kwēi nɛ, pi shi nchuʼɔ chonda ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ki a gɔ̌ ŋoŋ shɨna pəɨ ŋa m̈uuŋ vi mbie kəɨŋ brɛi mbhɔ yu, a fɛ pi kəɨŋ ŋguʼɔ ghɔ, ");
INSERT INTO bmo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ki mbie vi ni shhu, a fɛ pi mitwɛʼi ghɔ? ");
INSERT INTO bmo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ti pəɨ kiʼɛ ŋa pəɨ ghà nchwīe phɨ nɛ nji fɛ nu maoŋ shiʼi ni puoŋ pəɨ, ti Tǎa vəɨ ŋa a chhɔ po nɛ shi mfɛ pa ŋkiɛŋ maoŋ ni ŋgwa haʼaŋ pugu pie nɛ pi fɨʼɨ yi nɛiŋ? ");
INSERT INTO bmo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nthɛ yie ghɔ, moŋ ŋguoŋ pa nnu ghao, chwīe mbɨŋ ŋgwa nduoŋ wuʼɔ nɔ haʼaŋ ɔ khwā ŋa pi chwīe mbɨŋ ghɔ nɛ, nthɛ ŋa yei nnu ŋa gɨ́ Mushi pugu pa njəɨlɨʼɨ Minnwi chhu nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Tɔgɔ pi choŋkaʼa kikɛʼi nii, nthɛ ŋa choŋkaʼa ŋa a tɔgɔ nii moŋ móŋoŋ ŋguʼɔ liɛŋ shhɛ nɛ ghaʼo ndɔ njiʼɛ, ntou ŋgwa tɔgɔ nu fɔ nii nu. ");
INSERT INTO bmo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nthɛ ŋa choŋkaʼa pugu pa ndaoŋ ŋa a tɔgɔ nii moŋ chɔmbhi nɛ yi kikɛʼi, ŋgwa pɛ ŋa pugu yəɨ ntɔgɔ fɔ nɛ pɔ shɨgɛi. ");
INSERT INTO bmo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“P̂əɨ chhɔ ndɨna pa njəɨlɨʼɨ mifɨɨ ŋa pugu thɔ ni pəɨ moŋ ŋgrào pa minjɨɨ ndɔ moŋ ghɔ pugu pɔ pa miŋaŋieŋ pɨgɛi lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pəɨ shi nji vugu ŋkuoŋ ntíɛŋ yugu. Pi shiʼa ndɨ̄ga ŋguuŋ laʼo shǐe ndɔ paʼa ndɔ ŋka chìa ŋkuoŋ mbiembie. ");
INSERT INTO bmo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nɛnnɛ sheshe thɨ ŋa a lɔ mfāʼo ghɨ̌nɔ nɛ ghà njuŋ ntíɛŋ shiʼi, ndɔ thɨ ŋa a fāʼo ghɨ̌nɔ nɛ yuŋ ntíɛŋ pɨphɨ. ");
INSERT INTO bmo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mbaʼa thɨ ŋa a lɔ mfāʼo ghɨ̌nɔ nɛ yuŋ ntíɛŋ pɨphɨ, ki thɨ ŋa a fāʼo ghɨ̌nɔ nɛ yuŋ ntíɛŋ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sheshe thɨ ŋa a lɔ njuŋ ntíɛŋ shiʼi, pi shi ŋkəʼɨ māʼaŋ shhɛ ndɔ māʼaŋ moŋ móŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nɛnnɛ, ɔ shi nji vugu ŋkuoŋ ntíɛŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“A lɔ mbɔ shesheŋoŋ ŋa a mɛ̄iŋ a ŋa, ‘Taathɔ, Taathɔ,’ nɛ ŋa a lɛ ma nii moŋ Shaʼafuoŋ Po, a wuʼɔ ŋoŋ yɛ ŋa a ghà nchwīe nnu ŋa Tǎa a po tāʼa nu nɛ ŋa a shi nii. ");
INSERT INTO bmo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Llɛmbhi ghɔ, ntou pa ŋgwa ma nchhu vəɨ ŋa, ‘Taathɔ, Taathɔ, pigi shini ndɔ njəɨ pa nnu chhu nɔ ligi yɔ, mfuʼu pa miŋwɛiŋ nɔ ligi yɔ, mfāʼa pa mɛmmɛ tɨtɨnɨ fàʼa nɔ ligi yɔ?’ ");
INSERT INTO bmo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ǹchhu kiʼɛ ni pugu ŋa, ‘Ǹshini ndɔ nji vəɨ, pəɨ lɔllɔ, pa ŋgūo nnu mbɨmbhɨ pei.’ ");
INSERT INTO bmo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Shesheŋoŋ ŋa a yaʼo pa chrà paŋ pei ndɔ nchwīe nɛ pɔ nɔ ŋgaŋ shiethɔ ŋa a ni ŋkrao nda yi ŋkuoŋ ŋkiɛŋ ŋgùʼɔ, ");
INSERT INTO bmo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","mbɨ̀ ghà ndhɔ, ŋkhǐ shwiʼi, fɨfrəɨ thɔ ntuŋ nda ghɔ, paʼa a lɔ ŋgū nthɛ ŋa pi ni krao pi ŋkuoŋ ŋkiɛŋ ŋgùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ndɔ shesheŋoŋ ŋa a yaʼo chrà a yei ki lɔ nchwīe nɛ, shi mbɔ nɔ nàna ŋa a ni ŋkrao nda yi pi ŋkuoŋ shíshhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mbɨ̀ ni ŋga ndhɔ, ŋkhǐ shwiʼi, fɨfrəɨ thɔ ntuŋ ŋkuoŋ nda ghɔ, a gū nwīʼiŋ ghao.” ");
INSERT INTO bmo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jishɔ ni ŋga mīʼɛŋ chhu nu nnu pei, pa yú ŋgwa pighɔ fɔ nɛ ghrāo ŋkwaŋ haʼaŋ a ni njɛʼi nu nɛ, ");
INSERT INTO bmo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","nthɛ ŋa a ni nthɔ njɛʼi vugu pi nɔ ŋoŋ ŋa a fāʼo ghrɨ́, ki lɔ mbɔ pi nɔ pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi. ");
INSERT INTO bmo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jishɔ ni ŋga nshwiʼi ŋkuoŋ mbra, yú ŋgwa yōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ŋga njəɨ nu nɛ, ŋgaŋ ghɨnɔmbaluŋ chəɨ thɔ njəɨ vi, ŋkwi kwɛ́rɛ yi shhɨ yu, nchhu nu ŋa, “Taathɔ, ɔ̈ ntāʼa nu, ɔ chwīe m̀bɔ yi taoŋtaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jishɔ fɛ mbhɔ yi ŋkāoŋ vi, nchhu nu ŋa, “Ǹtāʼa nu, pɔ yi taoŋtaoŋ.” Wuʼɔ chomilaoŋ ghɔ, ghɨnɔmbaluŋ mmɛ mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jishɔ chhu ghɔ ŋa, “Kiʼi nshwei shesheŋoŋ, ndɔ ghə̄ɨ nōoŋ noŋ yɔ ni *ŋgaŋ fɛʼiŋgiɛŋ Minnwi, a līi ghɔ nɔ nōoŋ nu ŋa Minnwi yɨ̄gɨ ghɨ̌nɔ yɔ. Fɛ yaoŋ fɛʼiŋgiɛŋ nɔ haʼaŋ gɨ́ Mushi chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ndɨɨ ŋa Jishɔ ni nii Kapanuŋ nɛ, yichəɨ nthishɨ pa taʼa ŋkɨɨ shoogɛ thɔ njəɨ vi ndɨ̄gəɨ vi ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Taathɔ, muuŋ fàʼa a nūaŋ kúoŋ, taʼa ŋgei noŋ yi khu, a thɔ njəɨ ŋgəʼɨ ŋkiɛŋ yie ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jishɔ khwɛ̄ ghɔ ŋa, “Ǹshi nthɔ njɨ̄gɨ ghɨ̌nɔ yi.” ");
INSERT INTO bmo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ndɔ nthishɨ ghɔ khwɛ̄ ŋa, “Taathɔ, ǹdɔ njiʼi ŋkāʼo fɨʼɨ ŋoŋ ŋa minthɛ ɔ nii nda mu nɛ, wuʼɔ fɛ pi gɨ́ ghɨ̌nɔ muuŋ fàʼa a tɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nthɛ ŋa mmu nduthɔ a, ŋ̀ga mfāʼa mbhɔ ŋgwa ndɔ nthɔ nshaʼa pa shoogɛ ŋkaa mu. Ŋ̀ga mfɛ gɨ́ ni taʼa yi ŋa, ‘Ghə̄ɨ,’ a ghə̄ɨ, mfɛ gɨ́ ni yichəɨ ŋa, ‘Thɔ,’ a thɔ. Mfɛ gɨ́ ni muuŋ fàʼa a ŋa chwīe yei, a chwīe.” ");
INSERT INTO bmo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jishɔ ni ŋga njaʼo nnu yei ŋgrāo, nchhu ni ŋgwa pɛ ŋa pugu ni nthɔ njōu njiŋ yi nɛ ŋa, “Shishini, ǹshwei vəɨ, ǹdɔ naa njəɨ ŋoŋ ni fɨʼɨ ŋkwaŋ piŋ yei moŋ laʼataoŋ Ishrae. ");
INSERT INTO bmo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ǹshwei vəɨ ŋa ntou ŋgwa shi ndhɔ ŋgei laʼataoŋ shaʼa minaoŋ ni ŋgei nii minaoŋ nchhɔ ŋkuoŋ taprɛi pugu pa Abrahaŋ ni Aiji ni Jakɔ moŋ Shaʼafuoŋ Po. ");
INSERT INTO bmo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ndɔ pi māʼaŋ puoŋ Shaʼafuoŋ mbhi moŋ njiŋnjiŋ mbɔ lɨʼɨ ŋa kə̄ɨ nu pugu pa kru nu shua shi mbɔ fɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jishɔ chhu ni nthishɨ ghɔ ŋa, “Ghə̄ɨ, nɔ haʼaŋ ɔ piŋ nɛ, a nɔ haʼaŋ a shi ndɔ̄gɔ lɨʼɨ vɛ nɛ.” Ghɨ̌nɔ muuŋ fàʼa ghɔ kāʼo ndɔ ntɔgɔtɔgɔ wuʼɔ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jishɔ ni ŋga nii nda Pita, njəɨ mǔuŋ ŋgwɛ vi nūaŋ kúoŋ nthɔ ŋgɨ̄nɔ shɨ̀gao. ");
INSERT INTO bmo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jishɔ kāoŋ mbhɔ yi shɨ̀gao ghɔ taoŋ mbɨŋ yu, a lɔllɔ nchwīe maoŋ mfɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Fanaoŋ ni ŋga mbɔ, pi thɔ ni ntou pa ŋgwa ni miŋwɛiŋ mbɨŋ pugu njəɨ vi nɔ ghɔ, a fuʼu pa jijwɛ pighɔ ni taʼa chrà, ndɔ njɨ̄gɨ ghɨ̌nɔ ŋguoŋ ŋgwa ŋa pugu ni ŋgɨ̄nɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yei ni mbɔ nɔ chwīe nu nnu ŋa njəɨlɨʼɨ Minnwi mbɔ Ishaya ni nchhu nɛ lɔ̄gɔ lɨʼɨ: “Ju nduthɔ yi ni ŋkwe pa noŋ kikie yia ndɔ nchwīe pa ghɨ̌nɔ pia tɔgɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jishɔ ni ŋga njəɨ yú ŋgwa yəɨ yu, mfɛ gɨ́ ni ghaŋ younjiŋ pi ŋa pugu shāʼa nɔ njiɛŋ ŋkhǐ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yichəɨ masha ŋgaŋ yɛʼi gɨ́ Mushi thɔ nchhu ghɔ ŋa, “Masha, ǹshi njōu njiŋ yɔ sheshe lɨʼɨ ŋa ɔ shi ŋgə̄ɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jishɔ chhu ghɔ ŋa, “Pa mimbaaŋguo fāʼo pa pùo pugu, pa mishi fāʼo pa nda pugu, ndɔ *Muuŋ Ŋoŋmishua lɔ njiʼi mfāʼo lɨʼɨ lɛ̄rɛ thɔ yi.” ");
INSERT INTO bmo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yichəɨ taʼa *ŋgaŋ younjiŋ yi chhu ghɔ ŋa, “Taathɔ, fǔoŋ mieŋ ŋgə̄ɨ ntwei tǎa a ŋkaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jishɔ chhu ghɔ ŋa, “Thɔ njōu njiŋ a, mieŋ ŋgwa ŋa pugu khu nɛ twei khu ŋgwa pugu.” ");
INSERT INTO bmo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jishɔ ni ŋga nii moŋ kikuoŋ, pa ghaŋ younjiŋ pi yōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ŋga njəɨ nu nɛ, mmɛ fiŋ gū moŋ ŋkhǐ ti kikuoŋ tāʼa nu njīe, ndɔ Jishɔ ka thɔ ndɛllɛ. ");
INSERT INTO bmo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pugu ghə̄ɨ ŋgūʼu vi lɔgɔ, nchhu nu ŋa, “Kwe vigi, ma Taathɔ, pia chhɔ nɛ ŋkukhu.” ");
INSERT INTO bmo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A chhu ni pugu ŋa, “Pəɨ chhɔ mbɔgɔ pi khɔ, ghaŋ piŋ kikɛʼi pei?” Ndɔllɔ kiʼɛ mbɨ̄ga fɨfrəɨ ghɔ pugu pa ŋkhǐ, mmɛ juju gū moŋ ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ŋgwa pighɔ ghrāo, nchhu nu ŋa, “Yei pɔ pi yəɨ ŋkwaŋ ŋoŋ nɛiŋ ŋa njiʼi nthɛ pi fɨfrəɨ pugu pa ŋkhǐ yaʼo nchò yi?” ");
INSERT INTO bmo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jishɔ ni ŋga nshāʼa ŋkhǐ ntaoŋ krao ŋgei laʼataoŋ Gadara, mbāoŋ pugu pa paa ŋgwa ŋa miŋwɛiŋ ni mbɔ mbɨŋ pugu, pugu taoŋ nu moŋ fúŋ moŋ ŋgùʼɔ, pugu ni nchɨgəɨ ti minthɛ paʼa ŋoŋ lɔ ntɔgɔ ndaoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ŋga njəɨ nu nɛ, pugu paʼo ŋgòu, nchhu nu ŋa, “Yo! Muuŋ Minnwi, pia fāʼo pi khɔ? Ɔ thɔ hɛiŋ nɔ fɛ nu ŋgəʼɨ ni pigi ki ndɨɨ lɔ naa ŋkāʼo?” ");
INSERT INTO bmo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kwíe ntou ŋkunyaŋ ni nthɔ njɨ nu ni ŋgei lɨʼɨ ghɔ yəɨ pugu. ");
INSERT INTO bmo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pa miŋwɛiŋ pighɔ jɛ̄ nthɔ ndɨ̄gəɨ vi, nchhu nu ŋa, “Ä mbɔ ŋa ɔ shi mfuʼu vigi, ɔ taoŋ vigi pigi nii mbɨŋ kwíe ŋkunyaŋ pinɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","A chhu ni pugu ŋa, “Ghə̄ɨ!” Pugu taoŋ kiʼɛ nii mbɨŋ pa ŋkunyaŋ pighɔ. Ŋga njəɨ nu nɛ, ŋguoŋ kwíe ŋkunyaŋ ghɔ tei llɔ ŋkɨŋ mbra ghɔ nshwiʼi ŋgū moŋ ŋkhǐ ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ghaŋ kɛ̄ʼi ŋkunyaŋ pighɔ tei, ŋga ŋgə̄ɨ moŋ laʼa, nshwei ŋguoŋ pa nnu ŋa a ni ndɔ̄gɔ lɨʼɨ nɛ, mīʼɛŋ mbɔ nnu ŋa a ni ndɔ̄gɔ lɨʼɨ mbɨŋ paa ŋgwa pighɔ ŋa pugu ni mfāʼo miŋwɛiŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ŋga njəɨ nu nɛ, ŋguoŋ ŋgwa moŋ laʼataoŋ ghɔ taoŋ nthɔ lɨʼɨ para Jishɔ, ŋga njəɨ vi, ndɨ̄gəɨ vi ŋa a taoŋ moŋ krao ŋgei laʼa yugu ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jishɔ nii moŋ kikuoŋ nshāʼa ntaoŋ moŋ ji laʼataoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ŋgaŋ njəɨ nu, pichəɨ ŋgwa thɔ ni yichəɨ ŋkwíni ŋkuoŋ kúoŋ. Jishɔ ni ŋga njəɨ fɨʼɨ piŋ yugu, nchhu ni ŋkwíni ghɔ ŋa, “Fāʼo tɨnɨnjuʼɔ, ma muuŋ a, pi līʼɛ pa phɨ pɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ŋga njəɨ nu, pichəɨ pa ghaŋ yɛʼi gɨ́ Mushi chhu ni noŋ pugu ŋa, “Ŋoŋ vei chrā chrà nchɨʼəshə nɔ ligi Minnwi!” ");
INSERT INTO bmo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jishɔ ni nji nnu ŋa pugu ni mbiʼi nu nɛ nchhu ŋa, “Pəɨ thɔ mbīʼi nnu pɨphɨ njùʼɔ pəɨ nthɛ khɔ? ");
INSERT INTO bmo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","A yīʼɛ yəɨ: Chhu nu ŋa, ‘Pi līʼɛ pa phɨ pɔ,’ ki chhu nu ŋa, ‘Lɔllɔ, nyieŋ’? ");
INSERT INTO bmo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ndɔ nɔ chwīe nu pəɨ ji ŋa Muuŋ Ŋoŋmishua fāʼo ghrɨ́ ŋkuoŋ shhɛ nɔ līʼɛ nu pa phɨ,” a chhu ni ŋkwíni ghɔ ŋa, “Lɔllɔ, lɔ̄gɔ kúoŋ yɔ ŋgə̄ɨ laʼa.” ");
INSERT INTO bmo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A lɔllɔ ŋgə̄ɨ laʼa. ");
INSERT INTO bmo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yú ŋgwa pighɔ ni ŋga njəɨ nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ, mbɔgɔ gu ŋgaʼo Minnwi ŋa a fɛ ŋkwaŋ ghrɨ́ ghɔ ni ŋgwamishua nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jishɔ ni ŋga ndɔllɔ fɔ, njəɨ ŋoŋ chəɨ, ligi yi pɔ Matio, a chhɔ moŋ ntǎa kwe taashi, a chhu ghɔ ŋa, “Yōu njiŋ a!” A yrɛi shhɛ njōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nɔ haʼaŋ Jishɔ ni nchhɔ yəɨ taprɛi nthɔ njɨ maoŋ nda Matio nɛ, ntou pa ghaŋ wɛ̄iŋ taashi pugu pa ghaŋ chwīe phɨ thɔ nthɔ njɨ maoŋ pugu pa Jishɔ pugu pa ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pa ŋgwa Farashi ni ŋga njəɨ nnu yei, nchhu ni ghaŋ younjiŋ pi ŋa, “A chwīe khɔ masha vəɨ jɨ yaoŋ pugu pa ghaŋ wɛ̄iŋ taashi pugu pa ghaŋ phɨ?” ");
INSERT INTO bmo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A ni ŋga njaʼo, nchhu ŋa, “Ŋgwa pɛ ŋa pugu pɔ shiʼi nɛ lɔ mfāʼo chà ŋgaŋ fhɔ̌, a fāʼo ŋgwa pɛ ŋa pugu ghɨ̌nɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pəɨ ghə̄ɨ ntāʼa njiŋ nnu yei ŋa Ŋwaʼaŋlɨ Minnwi chhu nɛ ŋa, ‘Ǹtāʼa nu ŋa ŋgwa nōoŋ kwoshɨnɨ ki lɔ ŋguʼɔ mfɛ pi yaoŋ *fɛʼiŋgiɛŋ.’ Nthɛ ŋa ǹshini ndɔ nthɔ pi nɔ gɛ̄ nu ŋgwa ndɨndɨ, ǹthɔ nthɛ pi ghaŋ phɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nnɛ pa ghaŋ younjiŋ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ thɔ njəɨ Jishɔ mbie vi ŋa, “A chwīe khɔ pigi pa ŋgwa Farashi jī ŋkhǐ, ndɔ paʼa pa ghaŋ younjiŋ pɔ lɔ njī?” ");
INSERT INTO bmo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jishɔ khwɛ̄ ni pugu ŋa, “Mimfɛ pa ghaŋ gɛ̀ lɨʼɨ láŋ pɔ ni tuʼuthɔ ndɨɨ ŋa pugu pa mimbia ŋgaŋ láŋ ghɔ wuʼɔ mbɔ kaʼa nɛ? Ndɔ pa llɛ́ pighɔ shi nthɔ ŋa pi shi mfuʼu mimbia láŋ ghɔ shɨna pugu, nɛnnɛ pugu shi njī ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mbaʼa ŋoŋ chri paʼo ŋkuoŋ ndunu ndhwí ni pra ndhwí fhi, nthɛ ŋa pra ndhwí fhi ghɔ shi ŋga ŋɨnɛiŋ, a ka mīʼɛŋ māʼaŋ pi mmɛ mbo ŋkuoŋ ndhwí ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ŋgwa shiʼa niʼiŋ làʼo fhi moŋ ndunu mikei ŋgrào, p̈i niʼiŋ, làʼo fhi ghɔ fāʼo ntūgu mikei ŋgrào ghɔ ŋkwrī shhɛ, ŋgrào ghɔ pɨrɨ. Ndɔ pi ghà niʼiŋ làʼo fhi moŋ mikei ŋgrào fhi, nɛnnɛ ŋguoŋ yi ghao pɔ shiʼi.” ");
INSERT INTO bmo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nɔ haʼaŋ Jishɔ ni ŋguʼɔ nthɔ nchhu nnu pei ni pugu nɛ, a gha njəɨ nu, yichəɨ nthishɨ pa Juu nii ŋkwi kwɛ́rɛ yi shhɨ yu, nchhu nu ŋa, “Muuŋ a yi miŋgwɛ khu wuʼɔ ndwɛ yei. Thɔ nūʼɔŋ mbhɔ yɔ mbɨŋ yu nnɛ ŋa a ywiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jishɔ lɔllɔ njōu njiŋ yi pugu pa ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ŋga njəɨ nu, yichəɨ miŋgwɛ ŋa a ni ŋkwo yəɨ ndɨɨ yi ki a lɔ ntithi nɔ paanchrɔ ŋgaʼo thɔ njiŋ yu, ŋkāoŋ po ndhwí yi. ");
INSERT INTO bmo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nthɛ ŋa a ni nchhu ni noŋ yi ŋa, “M̈i ŋguʼɔ ŋkāoŋ pi po ndhwí yi, ghɨ̌nɔ a tɔgɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ndɔ Jishɔ gha ŋkara njəɨ vi, nchhu ŋa, “Fāʼo tɨnɨnjuʼɔ, ma muuŋ a, piŋ yɔ chwīe ghɨ̌nɔ yɔ tɔgɔ.” Wuʼɔ ndɨɨ ghɔ, pi ni nchwīe ghɨ̌nɔ miŋgwɛ ghɔ tɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jishɔ ni ŋga ŋgə̄ɨ nda nthishɨ ghɔ, njəɨ pa ghaŋ tua ndua pugu pa yú ŋgwa pugu yɔ̄nɔ nu moŋ fiŋthɔ. ");
INSERT INTO bmo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A chhu ni pugu ŋa, “Ŋguoŋ vəɨ taoŋ! Muuŋ miŋgwɛ yei lɔ ŋkukhu, a chhɔ ndɛllɛ.” Pugu gwɛ̄ vi. ");
INSERT INTO bmo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ndɔ pi ni ŋga mfuʼu ŋguoŋ yú ŋgwa pighɔ mfɛ mbhi, a nii nda ŋgwɛ̄iŋ muuŋ miŋgwɛ ghɔ nɔ mbhɔ yi, a lɔllɔ. ");
INSERT INTO bmo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Shaaŋga nnu yei nyīeŋ moŋ ŋguoŋ krao laʼataoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nɔ haʼaŋ Jishɔ ni ndhɔ fɔ ŋgə̄ɨ nu nɛ, paa pa nchriligi yōu njiŋ yi, mbaʼo ŋgòu, nchhu nu ŋa, “Muuŋ Devi, fāʼo kwoshɨnɨ mbɨŋ pigi.” ");
INSERT INTO bmo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jishɔ ni ŋga nii nda, paa pa nchriligi pighɔ thɔ njəɨ vi, a pie vugu ŋa, “Pəɨ piŋ ŋa a nthɛ ǹchuʼɔ ligi yəɨ?” Pugu chhu ghɔ ŋa, “Ooŋ, ma Taathɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nnɛ Jishɔ kāoŋ ligi yugu, nchhu nu ŋa, “A pɔ ni pəɨ ŋkwaŋ nɔ haʼaŋ piŋ yəɨ pɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ligi yugu chuʼɔ. Jishɔ shūu tə́nə yugu, nchhu nu ŋa, “Kiʼi pəɨ chwīe ŋoŋ ji nnu yei.” ");
INSERT INTO bmo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ndɔ pugu taoŋ ŋgə̄ɨ nchīi pa nnu ŋa Jishɔ chwīe nɛ moŋ ŋguoŋ krao laʼataoŋ ghɔ ghao. ");
INSERT INTO bmo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nɔ haʼaŋ pugu ni ŋgə̄ɨ nu nɛ, ŋga njəɨ nu nɛ, pi thɔ nu ni ŋoŋ chəɨ ŋa miŋwɛiŋ ni mbɔ mbɨŋ yu, a pɔ fhɨncho, njəɨ vi ni ju. ");
INSERT INTO bmo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nɔ haʼaŋ pi ni mfuʼu miŋwɛiŋ ghɔ nɛ, fhɨncho ghɔ chrā. Yú ŋgwa pighɔ ghrāo, nchhu nu ŋa, “Pi lɔ naa ma njəɨ ŋkwaŋ nnu yei moŋ Ishrae!” ");
INSERT INTO bmo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ndɔ pa ŋgwa Farashi chhu ŋa, “A fuʼu miŋwɛiŋ pi ni ghrɨ́ nthishɨ pa miŋwɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jishɔ nyīeŋ moŋ ŋguoŋ pa mɛmmɛ laʼataoŋ pugu pa puoŋ mi laʼataoŋ, njɛʼi ŋgwa moŋ pa nda luoŋ Minnwi, nthɔ nchīi pwa pishaʼakhɔ mbɔ yi Shaʼafuoŋ, nthɔ njɨ̄gɨ ŋguoŋ ŋkwaŋ ghɨ̌nɔ pugu pa chəɨchəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A ni ŋga njəɨ yú ŋgwa pighɔ, mfāʼo kwoshɨnɨ mbɨŋ pugu, nthɛ ŋa pugu ni mbɔ moŋ ŋgəʼɨ ndɔ mbou ghrɨ́ nɔ ghɛ̄rɛ nu noŋ pugu nɔ pa minjɨɨ ki ŋkɛ̄ʼi yi. ");
INSERT INTO bmo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nnɛ a chhu ni pa ghaŋ younjiŋ pi ŋa, “Maoŋ kwōo yiɛŋ ndɔ ghaŋ kwōo pi kɨgəɨ, ");
INSERT INTO bmo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","nthɛ yie ghɔ, p̂əɨ luoŋ ni taʼanjuʼɔ mbhɔ Taathɔ ŋa a fāʼo maoŋ pighɔ nɛ, a taoŋ pa ghaŋ fàʼa pugu ghə̄ɨ ŋkwōo maoŋ pi.” ");
INSERT INTO bmo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jishɔ mɛ̄iŋ paanchrɔ ghaŋ younjiŋ pi, mfɛ ghrɨ́ ni pugu ŋa pugu fuʼu pa jijwɛ pɨphɨ nɔ ghɔ, ndɔ njɨ̄gɨ ŋguoŋ ŋkwaŋ ghɨ̌nɔ pugu pa chəɨchəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yei ligi paanchrɔ ghaŋ ntaoŋ pi pighɔ: fǔoŋ yi, Shemu, ŋa pi ni mɛ̄iŋ vi ni Pita nɛ, ni Andru ndǐŋ vi, ni Jɛiŋ muuŋ Shebedi, ni Jouŋ ndǐŋ vi, ");
INSERT INTO bmo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fili pugu Batolomiu, Toma ni Matio mbɔ ŋgwɛ̄iŋ taashi, ni Jɛiŋ muuŋ Afioshi, ni Tadio, ");
INSERT INTO bmo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ni Shemu mbɔ kwìni laʼa, ni Judashi Ishikario ŋa a ni mfīni vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jishɔ ni ntaoŋ paanchrɔ pei, ni ntɨ́gɨ yei, “Kiʼi pəɨ ghə̄ɨ laʼa ŋgwa taoŋ nduoŋ ki moŋ sheshe laʼa pa ŋgwa Shamaria. ");
INSERT INTO bmo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pəɨ ka ghə̄ɨ pi wuʼɔ moŋ mbaanda Ishrae, ŋa pugu pɔ nɔ minjɨɨ ŋa a kwo phɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nɔ haʼaŋ pəɨ ghə̄ɨ nu nɛ, p̂əɨ chīi nu ŋa, ‘Shaʼafuoŋ Po kwo para!’ ");
INSERT INTO bmo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","P̂əɨ yɨ̄gɨ ghɨ̌nɔ ŋgwa, njwiŋ ŋgwa ŋa pugu khu nɛ, njɨ̄gɨ ghɨ̌nɔ ghaŋ ghɨnɔmbaluŋ, mfuʼu pa miŋwɛiŋ mbɨŋ ŋgwa. Pəɨ ni ŋkwe ghrɨ́ chwīe nu nnu pei mbhɔ mu pi ki lɔ mbe, nthɛ yie ghɔ, pəɨ chwīe pa nnu pei mbɨŋ ŋgwa pi ki pugu lɔ mbe. ");
INSERT INTO bmo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Kiʼi pəɨ lɔ̄gɔ sheshe laoŋgo, ki mbɨŋ ntɨʼə ki yi kikɛʼi moŋ pìɛŋ mbɨŋ yəɨ, ");
INSERT INTO bmo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kiʼi pəɨ lɔ̄gɔ pìɛŋ kra, ki kwri ndhwí, ki tra, ki mbìe, nthɛ ŋa a pie ŋa ŋgaŋ fàʼa fāʼo maoŋ jɨ pi. ");
INSERT INTO bmo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Sheshe mmɛ laʼataoŋ ki muuŋ laʼataoŋ ŋa pəɨ nii fɔ nɛ, p̂əɨ līi ŋoŋ ŋa a kāʼo ndɔ ŋkhwā nɔ tuo nu vəɨ nɛ, ndaʼa pəɨ pugu ti shi nuʼuŋ ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nɔ haʼaŋ pəɨ nii moŋ nda ghɔ nɛ, pəɨ chrā ni pugu ŋa, ‘Ghɨghrɨ pɔ mbɨŋ pəɨ.’ ");
INSERT INTO bmo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ti ghaŋ nda pighɔ ŋkāʼo, ghɨghrɨ yəɨ kɨna nda ghɔ, ti pugu mieŋ ki kāʼo ghɨghrɨ yəɨ pɨ̄nɨ mbɨŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ti sheshe nda mieŋ ki lɔ mbiŋ vəɨ, ki mbiŋ chrà yəɨ, pəɨ krū kwò məɨ ndɨɨ ŋa pəɨ taoŋ nu nda ghɔ ki laʼataoŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Shishini, ǹshwei vəɨ ŋa a shi ndɛ njiʼɛ ni laʼataoŋ Shodoŋ pugu Gomora moŋ llɛmbhi sháʼa nchaa yie laʼataoŋ ŋa pugu lāa vəɨ nɛ! ");
INSERT INTO bmo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pəɨ līi njəɨ, ǹtaoŋ vəɨ nɔ pa minjɨɨ shɨna pa miŋaŋieŋ. Nnɛ pəɨ chhɔ ni lɨna məɨ nɔ pa mitwɛʼi ndɔ njū nɔ pa mintuʼɔlibuŋ. ");
INSERT INTO bmo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","P̂əɨ chhɔ ndɨna pichəɨ ŋgwa nthɛ ŋa pugu shi ŋgwɛ̄iŋ vəɨ nchaʼa mfɛ moŋ pa ndashaʼa, pi wie vəɨ moŋ pa nda luoŋ Minnwi yugu. ");
INSERT INTO bmo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pi shi ŋgwɛ̄iŋ vəɨ ŋgə̄ɨ nɔ shhɨ ghaŋ shaʼa ŋgwa pugu pa fùoŋ nthɛ a, p̂əɨ pɔ pa miŋkwentie shhɨ pugu, pugu pa ŋgwa taoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ndɨɨ ŋa pi wɛ̄iŋ vəɨ nchaʼa mfɛ ŋa pi shaʼa vəɨ nɛ, kiʼi njùʼɔ yəɨ ghana vəɨ ni ŋkwaŋ haʼaŋ pəɨ shi nchrā nɛ pugu pa nnu ŋa pəɨ shi nchhu nɛ. Nthɛ ŋa pi shi mfɛ yaoŋ ŋa pəɨ shi nchu nɛ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nthɛ ŋa a lɔ nchrā pəɨ, a chrā Jijwɛ Tǎa vəɨ mbɨŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ŋoŋ shi nchaʼa ndǐŋ vi mfɛ ŋa pi jwi, Tǎa fɛ muuŋ vi ŋa pi jwi, pa puoŋ kara mbara pa tǎa, pugu pa ma ni nchhɔ̀, nchwīe pi jwi vugu. ");
INSERT INTO bmo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ŋguoŋ ŋgwa shi mbɨ̄na vəɨ nthɛ a, ndɔ ŋoŋ ŋa a shi ntīi shii ti ŋgə̄ɨ ndugwi nɛ shi ndūgu. ");
INSERT INTO bmo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ndɨɨ ŋa pi fɛ ŋgəʼɨ ni pəɨ moŋ taʼa laʼataoŋ nɛ, pəɨ tei ŋgə̄ɨ moŋ yichəɨ laʼataoŋ. Nthɛ ŋa shishini ǹshwei vəɨ, mbaʼa pəɨ yiʼi mīʼɛŋ fàʼa yəɨ moŋ ŋguoŋ laʼataoŋ moŋ Ishrae ki Muuŋ Ŋoŋmishua lɔ nthɔ. ");
INSERT INTO bmo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mbaʼa ŋgaŋ younjiŋ ŋoŋ chaa masha vi, ndɔ paʼa muuŋ fàʼa lɔ nchaa ju nchaa masha vi. ");
INSERT INTO bmo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A kāʼo ni ŋgaŋ younjiŋ ŋoŋ nɔ pɔ nu nɔ masha vi, muuŋ fàʼa pɔ nɔ masha vi. Ti pi mɛ̄iŋ masha nda ni Bɛjɛbu kaŋ pi shi ŋka mɛ̄iŋ pa ŋgwa nda ghɔ pi ni ligi ŋa a pɨgɨ nchaa yie nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nnɛ kiʼi mfāʼo pɔgɔ gu nthɛ vugu, nthɛ ŋa yichəɨ yaoŋ lɔ njiʼi mbɔ fɔ ŋa pi pūoŋ ŋa mbaʼa Minnwi mieŋ ki nōoŋ páa. Paʼa yichəɨ nnu lə̄ɨŋ lɔ mbɔ ŋa mbaʼa pi yiʼi mieŋ ki ji. ");
INSERT INTO bmo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nnu ŋa ǹchhu ni pəɨ moŋ njíŋ nɛ, pəɨ chhu nthɛ minaoŋ, yaoŋ ŋa pəɨ yaʼo pi chūuŋ nɛ, pəɨ thi ŋkuoŋ pa thɔnda nchīi. ");
INSERT INTO bmo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ndɔ kiʼi pəɨ pɔgɔ ŋgwa pɛ ŋa mimfɛ pugu wuʼɔ njwi pi frɛinoŋ yəɨ, ndɔ paʼa ndɔ mfāʼo ghrɨ́ nɔ jwi nu nchə̌ɨ yəɨ nɛ. Pəɨ ka pɔgɔ pi Minnwi ŋa minthɛ a pɨrɨ frɛinoŋ pugu pa nchə̌ɨ yəɨ moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pi shiʼa fīni paa puoŋ milunu pi wuʼɔ ni taʼa muuŋ mi mbɨŋ? Ndɔ mbaʼa taʼa ŋoŋ vugu gū shhɛ ki a lɔ mbiŋ Tǎa. ");
INSERT INTO bmo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Njiʼi nthɛ pi ŋguoŋ ŋgiithɔ yɔ yi shia ghao. ");
INSERT INTO bmo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nthɛ yie ghɔ, kiʼi mfāʼo pɔgɔ gu, nthɛ ŋa ɔ ghaʼo mbhɔ Minnwi nchaa ntou milunu. ");
INSERT INTO bmo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nnɛ shesheŋoŋ ŋa a chhu shhɨ ŋgwamishua ŋa a nyaŋ nɛ, mummu ŋkaa mu shi nchhu shhɨ Tǎa a po ŋa a nyaŋ. ");
INSERT INTO bmo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ndɔ shesheŋoŋ ŋa a lāa a shhɨ ŋgwamishua, mummu shi ndāa vi shhɨ Tǎa a ŋa a chhɔ po nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kiʼi njiʼi mbīʼi ŋa ǹthɔ pi nɔ fɛ nu taʼaŋggi ŋkuoŋ shhɛ. Ǹdɔ nthɔ pi nɔ fɛ ni taʼaŋggi, ǹthɔ pi ni kafa. ");
INSERT INTO bmo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‘Ǹthɔ pi nɔ chwīe nu muuŋ mimbia kara ŋkǔnu yi ni tǎa vi, muuŋ miŋgwɛ pāʼa ŋkǔnu yi ni mǔuŋ vi, muuŋ miŋgwɛ pāʼa ŋkǔnu yi ni maŋgaoŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mbɨ̌na ŋoŋ shi ŋguʼɔ mbɔ pi pa ndǎa pi.’ ");
INSERT INTO bmo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Shesheŋoŋ ŋa a khwā tǎa vi ki mǔuŋ vi nchaa a nɛ lɔ njiʼi ŋkāʼo ŋgaŋ younjiŋ a. Ndɔ shesheŋoŋ ŋa a khwā muuŋ vi yi mimbia ki vi miŋgwɛ nchaa a nɛ lɔ njiʼi ŋkāʼo ŋgaŋ younjiŋ a. ");
INSERT INTO bmo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Shesheŋoŋ ŋa a lɔ njiʼi ntiɛŋ wáʼa yi njōu njiŋ a nɛ lɔ njiʼi ŋkāʼo ŋgaŋ younjiŋ a. ");
INSERT INTO bmo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Shesheŋoŋ ŋa a yəɨ chɔmbhi yi nɛ shi mbhɛ chɔmbhi yi ghɔ, ndɔ shesheŋoŋ ŋa a phɛ chɔmbhi yi nthɛ a nɛ shi njəɨ chɔmbhi yi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Shesheŋoŋ ŋa a piŋ ghɔ ŋa ɔ thɔ a pwa nɛ piŋ pi mmu. Shesheŋoŋ ŋa a piŋ a nɛ piŋ pi ŋoŋ ŋa a taoŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Shesheŋoŋ ŋa a piŋ njəɨlɨʼɨ Minnwi nthɛ ŋa a njəɨlɨʼɨ Minnwi nɛ shi mfāʼo ŋkwaŋ kɨ̀nɛiŋ njəɨlɨʼɨ Minnwi, wuʼɔ nɛnnɛ shesheŋoŋ ŋa a piŋ ŋoŋ ndɨndɨ nthɛ ŋa a ŋoŋ ndɨndɨ nɛ shi mfāʼo ŋkwaŋ kɨ̀nɛiŋ ŋoŋ ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Shesheŋoŋ ŋa a fɛ ndua ŋkhǐ ghɨghrɨ ni taʼa muuŋ mi ŋgaŋ younjiŋ a yei nthɛ ŋa a ŋgaŋ younjiŋ a nɛ, shishini ǹshwei vəɨ, mbaʼa a yiʼi nshiɛŋ kɨ̀nɛiŋ yi.” ");
INSERT INTO bmo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jishɔ ni ŋga ŋkwo mīʼɛŋ tɨgɨ nu paanchrɔ ghaŋ younjiŋ pi, ndɔllɔ fɔ ŋgə̄ɨ nthɔ ntɨgɨ nu ndɔ nchīi nu moŋ pa laʼa pugu. ");
INSERT INTO bmo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ndwɛ Jouŋ ni ŋga nchhɔ moŋ chə́ɨŋ njaʼo fàʼa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, ntaoŋ pa ghaŋ younjiŋ pi ni Jishɔ ");
INSERT INTO bmo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ŋa pugu ghə̄ɨ mbie vi ŋa, “A gɔ̀ mbɔ ŋoŋ vɛ ŋa a ni mbɔ ŋa a shi nthɔ nɛ, ki pigi ywɛrɛ ŋoŋ nduoŋ?” ");
INSERT INTO bmo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jishɔ khwɛ̄ ni pa ghaŋ ntaoŋ Jouŋ ŋa, “P̂əɨ pɨ̄nɨ shwei Jouŋ ni yaoŋ ŋa pəɨ yaʼo ndɔ njəɨ nɛ, ");
INSERT INTO bmo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","pa nchriligi yəɨ lɨʼɨ, pa ŋkwíni nyīeŋ, ghaŋ ghɨnɔmbaluŋ pɔ shiʼi, pa fhɨtənə yaʼo lɨʼɨ, pi pɨʼɨ pa ŋgwa khu moŋ gu, pi chīi ŋkɨ̀nɨ pwa pishaʼakhɔ ni ghaŋ pou. ");
INSERT INTO bmo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mbɔrɔ pɔ ni ŋgwa pɛ ŋa pugu lɔ njiʼi mfāʼo kɨʼɨŋgɨnɨ moŋ piŋ yugu nthɛ a nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nɔ haʼaŋ ghaŋ younjiŋ Jouŋ ni ndɔllɔ ŋgə̄ɨ nɛ, Jishɔ jɛ̄ nthɔ nchrā nu ni yú ŋgwa pighɔ nthɛ Jouŋ, “Pəɨ ni ŋgə̄ɨ moŋ ŋkǔnu njó njəɨ pi khɔ fɔ? Trǔ ŋa fɨfrəɨ chɨ̄ʼɨ nu? Ŋga! ");
INSERT INTO bmo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pəɨ ni ŋgə̄ɨ kiʼɛ njəɨ pi khɔ fɔ? Ŋoŋ ŋa a ni māʼaŋ mbwa ndhwí? Ŋga! Līi njəɨ, ŋgwa ŋa pugu ghà māʼaŋ mbwambwa ndhwí nɛ ghà mbɔ pi moŋ ntuʼɔ pa fùoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ti pəɨ ni ŋgə̄ɨ nu kiʼɛ njəɨ pi khɔ fɔ? Njəɨlɨʼɨ Minnwi? Ooŋ, ǹshwei vəɨ, ŋoŋ ŋa a chaa njəɨlɨʼɨ Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nthɛ ŋa Jouŋ ŋoŋ ŋa chrà Minnwi chrā nɔ ligi yi ŋa, ‘Līi njəɨ, ǹshi ntaoŋ ŋgaŋ ntaoŋ a, a ghə̄ɨ shhɨ pəɨ mbīri ndaoŋ ni pəɨ.’ ");
INSERT INTO bmo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Shishini, ǹshwei vəɨ, shɨna ŋguoŋ ŋgwa ŋa piŋgɛ kwo ma mbhi nɛ, yichəɨ taʼa yi lɔ mbɔ ŋa a ghaʼo nchaa Jouŋ Ŋgaŋ Fɛ Ŋkhǐ, ndɔ ŋoŋ ŋa a kɨgəɨ nchaa ŋguoŋ ŋgwa moŋ Shaʼafuoŋ Po nɛ, ghaʼo nchaa Jouŋ. ");
INSERT INTO bmo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Llɔ ndɨɨ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ ti nthɔ nchəɨŋ ndwɛ, Shaʼafuoŋ Po kwo yəɨ ŋgəʼɨ mbhɔ kɨkrɨ, ghaŋ kɨkrɨ kwe ni ghrɨ́. ");
INSERT INTO bmo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ŋguoŋ pa njəɨlɨʼɨ Minnwi pugu pa gɨ́ ni nthɔ nchrā nthɛ pi Shaʼafuoŋ Po ti nthɔ nchəɨŋ thɔ Jouŋ, ");
INSERT INTO bmo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ti ɔ̈ ŋkhwā nɔ piŋ nu ŋkɨ̀nɨ yugu, kaŋ Jouŋ nduthɔ yi Elaija ŋa a ni mfāʼo nɔ thɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Shesheŋoŋ ŋa a fāʼo tə́nə nɛ, â yaʼo! ");
INSERT INTO bmo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Mimfɛ m̀āʼaŋ fɨʼɨ ŋgwrɛiŋoŋ yei pi ni khɔ? A pɔ nɔ pa mikəʼɨ ŋa pugu chhɔ moŋ lɨʼɨ taŋ, nthɔ mɛ̄iŋ pakwo michwe pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Pigi māʼaŋ ŋkhǐ pwanjuʼɔ ni pəɨ ndɔ paʼa pəɨ lɔ mbini, pigi yrāo ŋkhǐ gu ndɔ paʼa pəɨ lɔ ŋkə̄ɨ.’ ");
INSERT INTO bmo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jouŋ ni nthɔ paʼa ndɔ njɨ maoŋ ki nnu yaoŋ pugu chhu ŋa, ‘A fāʼo miŋwɛiŋ mbɨŋ yu.’ ");
INSERT INTO bmo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Muuŋ Ŋoŋmishua nthɔ njɨ maoŋ ndɔ nnu nu pugu chhu ŋa, ‘Līi njəɨ, a njru mmɛ yaoŋ, ndɔ mbɔ mbaa làʼo, mbɨnɨ mbɔ shúoŋ ghaŋ wɛ̄iŋ taashi pugu pa ghaŋ phɨ.’ Ndɔ shiethɔ nōoŋ noŋ yi ŋa a kāʼo pi ni ŋkwaŋ ntíɛŋ ŋa a yuŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jishɔ jɛ̄ nchhɔ mbɨ̄ga ŋgwa pa laʼataoŋ pɛ ŋa a ni njiɛŋ nchwīe pa nnu ghraoghrao fɔ nɛ, nthɛ ŋa pugu shini ndɔ mbāʼa ŋkǔnu yugu ni phɨ. ");
INSERT INTO bmo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ŋgəʼɨ pɔ ni pəɨ, ma ŋgwa Korashiŋ! Ŋgəʼɨ pɔ ni pəɨ, ma ŋgwa Beshaida! Nthɛ ŋa pa nnu ghraoghrao pei ŋa a lɔ̄gɔ lɨʼɨ hɛiŋ nɛ kaŋ ni mbɔ pi Tairɛ pugu Shidoŋ, pugu kaŋ ni ŋkwo māʼaŋ ndhwí ywei gu nchhɔ moŋ phu nɔ nōoŋ nu ŋa pugu pāʼa ŋkǔnu yugu ni phɨ. ");
INSERT INTO bmo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ndɔ ǹshwei vəɨ, a shi ndɛ njiʼɛ ni ŋgwa Tairɛ pugu Shidoŋ moŋ llɛmbhi sháʼa nchaa vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ndɔ ni pəɨ, ma ŋgwa Kapanuŋ, pəɨ pīʼi ŋa Minnwi shi ndɔ̄gɔ vəɨ ŋkuʼɔ nɔ po? Ŋga! A shi nshwiʼi vəɨ moŋ lɨʼɨ ŋgwa khu. Pa nnu ghraoghrao pei ŋa ǹchwīe nu shhɨ pəɨ nɛ kaŋ ni ndɔ̄gɔ lɨʼɨ pi Shodoŋ, pugu kaŋ ni ŋkwri nnɛ ŋguʼɔ mbɔ shiʼa. ");
INSERT INTO bmo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ndɔ ǹshwei vəɨ, a shi ndɛ njiʼɛ ni ŋgwa laʼataoŋ Shodoŋ moŋ llɛmbhi sháʼa nchaa vəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Moŋ ndɨɨ ghɔ Jishɔ chhu ŋa, “Tǎa, a gɔ̀ mbɔ Taathɔ po pugu pa ŋkuoŋ shhɛ. Ǹtōo ghɔ nthɛ ŋa yaoŋ ŋa ɔ lə̄ɨŋ ni ghaŋ shiethɔ pugu pa ghaŋ lɨna nɛ, ɔ nōoŋ ni pa puoŋ fhu. ");
INSERT INTO bmo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ooŋ, ma Tǎa, yei ŋkwaŋ haʼaŋ ɔ ni ŋkhwā ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tǎa a kwo chaʼa ŋguoŋ yaoŋ mfɛ mbhɔ mu, yichəɨ ŋoŋ lɔ nji ŋoŋ ŋa Muuŋ yie ghɔ nɛ ŋkiɛŋ Tǎa, ndɔ paʼa yichəɨ ŋoŋ lɔ nji ŋoŋ ŋa Tǎa yie ghɔ nɛ ŋkiɛŋ Muuŋ pugu pa shesheŋoŋ ŋa muuŋ chuʼɔ nɔ nōoŋ nu Tǎa ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“P̂əɨ thɔ njəɨ a, ŋguoŋ vəɨ ŋa pəɨ wie noŋ pəɨ ndɔ ntiɛŋ lrì nɛ, m̀fɛ fɛrɛ noŋ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tiɛŋ shhɔ̀ a mbəʼɨ ghɔ, njɛʼi mbhɔ mu nthɛ ŋa mi ŋoŋ mbɔmbɔrɔ ndɔ mbɔ ŋoŋ juju llɔ moŋ njùʼɔ mu, nnɛ, kaŋ ǹshi mfɛ fɛrɛ ni nchə̌ɨ yɔ. ");
INSERT INTO bmo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nthɛ ŋa shhɔ̀ a yīʼɛ, lrì a pɔ yi yīʼɛ yīʼɛ ŋkaa yu.” ");
INSERT INTO bmo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Moŋ ndɨɨ ghɔ Jishɔ nyīeŋ nu *Llɛ́ Ji pa Juu moŋ nyìeŋ shíe gɛ. Njì yia ghaŋ younjiŋ pi, pugu ka shíe gɛ ŋkru nu. ");
INSERT INTO bmo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pa ŋgwa Farashi ni ŋga njəɨ, nchhu ghɔ ŋa, “Līi njəɨ, pa ghaŋ younjiŋ pɔ thɔ nchwīe nnu ŋa gɨ́ lɔ mbiŋ ŋa pi chwīe Llɛ́ Ji nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A chhu ni pugu ŋa, “Pəɨ lɔ naa mɛ̄iŋ nnu ŋa Devi ni nchwīe ndɨɨ ŋa njì ni njia vugu pa ŋgwa pi nɛ? ");
INSERT INTO bmo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ŋkwaŋ nɔ haʼaŋ a ni nii Nda Minnwi pugu pa ŋgwa pi, ndɔ̄gɔ brɛi ŋa pi ni mfɛ ni Minnwi nɛ ŋkru, mbɔ nnu ŋa gɨ́ shini ndɔ mbiŋ ŋa a kru, ki ŋa ŋgwa ŋa pugu pugu ni mbɔ nɛ kru, ŋkiɛŋ pa ghaŋ fɛʼiŋgiɛŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ki pəɨ lɔ mɛ̄iŋ moŋ ŋwaʼaŋlɨ gɨ́ ŋkwaŋ nɔ haʼaŋ ghaŋ fɛʼiŋgiɛŋ moŋ Nda Minnwi ghà mbəʼɨ Llɛ́ Ji ndɔ paʼa gɨ́ lɔ ŋgwɛ̄iŋ vugu? ");
INSERT INTO bmo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ǹshwei vəɨ, yaoŋ ŋa a chaa Nda Minnwi nɛ pɔ hɛnɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","P̈əɨ kaŋ nji njiŋ nnu yei ŋa, ‘Ǹtāʼa nu ŋa ŋgwa nōoŋ kwoshɨnɨ ki lɔ ŋguʼɔ mfɛ pi yaoŋ fɛʼiŋgiɛŋ,’ pəɨ shi kaŋ ndɔ ŋgwɛ̄iŋ ŋoŋ ŋa mbhɔ yi yi woo nɛ nɔ ŋgushaʼa. ");
INSERT INTO bmo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nthɛ ŋa Muuŋ Ŋoŋmishua Taathɔ Llɛ́ Ji pa Juu.” ");
INSERT INTO bmo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jishɔ lɔllɔ fɔ ŋgə̄ɨ nii moŋ nda luoŋ Minnwi yugu. ");
INSERT INTO bmo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ŋoŋ chəɨ ni mbɔ fɔ mbɔ ŋkwíni mbhɔ. Pugu pie Jishɔ ŋa, “Gɨ́ piŋ ŋa pi yɨ̄gɨ ghɨ̌nɔ ŋoŋ Llɛ́ Ji?” nnɛ nɔ wɛ̄iŋ nu mi. ");
INSERT INTO bmo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A chhu ni pugu ŋa, “A gɔ̌ shɨna pəɨ ŋa ä mfāʼo minjɨɨ a gū moŋ tiɛŋ llɛ́ ji, paʼa a lɔ ŋgə̄ɨ ŋgwɛ̄iŋ vi ŋkə̄rə mfuʼu? ");
INSERT INTO bmo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ŋoŋmishua ghaʼo nchaa minjɨɨ kiʼɛ pi fɨʼɨ yi nɛiŋ? Nɛnnɛ gɨ́ piŋ ŋa pi chwīe shiʼi llɛ́ Ji.” ");
INSERT INTO bmo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nnɛ a chhu ni ŋkwíni mbhɔ ghɔ ŋa, “Shwīi mbhɔ yɔ.” Ŋoŋ ghɔ shwīi mbhɔ yi, a kiʼi ndɔ mbɔ pi shiʼi nɔ yichəɨ taʼa ŋgei mbhɔ yi. ");
INSERT INTO bmo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ndɔ pa ŋgwa Farashi taoŋ mbhi ŋgə̄ɨ nyiaŋ ntáŋ nthɛ Jishɔ, ŋkwaŋ haʼaŋ pugu shi njwi vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jishɔ ni ŋga nji ntáŋ yei, nshūu mbɨnɨ njiŋ llɔ fɔ. Ntou ŋgwa younjiŋ yi, a yɨ̄gɨ ghɨ̌nɔ yugu ghao, ");
INSERT INTO bmo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ndɔ fɛ gɨ́ ni pugu ŋa kiʼi pugu chwīe pichəɨ ŋgwa ji vi. ");
INSERT INTO bmo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yei ni mbɔ nɔ chwīe nu nnu ŋa Ishaya, mbɔ njəɨlɨʼɨ Minnwi, ni nchhu nɛ lɔ̄gɔ lɨʼɨ: ");
INSERT INTO bmo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Līi njəɨ, muuŋ fàʼa a yei ŋa ǹchuʼɔ, mbɔ muuŋ yɛ ŋa ŋ̀khwā nɛ, m̀fāʼo pwanjuʼɔ mbɨŋ yu. Ǹshi nūʼɔŋ Jijwɛ a mbɨŋ yu, a shi nchīi ndɨndɨ ni ŋgwa pa taoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mbaʼa a yiʼi mfɛ̄ʼi fɛ̀ʼi ki mbaʼo ŋgòu thɔ ŋgwa, mbaʼa ŋoŋ yiʼi njaʼo ŋggì yi moŋ pa taʼandaoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mbaʼa a yiʼi mbəʼɨ kàʼa ŋa a kwo fāʼo lə̄ɨŋ nɛ, ki mbɨgɛi truka ŋa a ŋkɨɨ nu nɛ ti a shi nuʼuŋ nchwīe ndɨndɨ ghaʼa lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ŋgwa pa laʼataoŋ nduoŋ shi mfāʼo kwàʼa pi mbiŋ yu.” ");
INSERT INTO bmo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nɛnnɛ ŋgwa pichəɨ ghə̄ɨ njəɨ Jishɔ ni ŋoŋ chəɨ ŋa miŋwɛiŋ ni mbɔ mbɨŋ yu, paʼa a lɔ nthɔ njəɨ lɨʼɨ, mbɨnɨ mbɔ fhɨncho. Jishɔ chwīe a pɔ shiʼi, nnɛ mfāʼo njɨ nɔ chrā nu ndɔ mbɨnɨ njəɨ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yú ŋgwa pighɔ ni ŋgrāo nthɔ nchhu nu ŋa, “Ŋoŋ vei nthɛ a pɔ muuŋ Devi?” ");
INSERT INTO bmo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ndɔ pa ŋgwa Farashi ni ŋga njaʼo nnu yei, nchhu ŋa, “Ŋoŋ vei wuʼɔ mfuʼu miŋwɛiŋ pi ni ghrɨ́ Bɛjɛbu mbɔ nthishɨ pa miŋwɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jishɔ ni nji nnu ŋa pugu ni mbīʼi nu nɛ, nnɛ nchhu ŋa, “Sheshe laʼataoŋ ŋa ŋgwa chhɔ māʼaŋ noŋ pugu ni nchhɔ̀ fɔ nɛ shi ŋguʼɔ ŋgū, ndɔ mbaʼa sheshe laʼa ki nda ŋa a pɔ pi ni minduoŋnduoŋ yiʼi ntithi. ");
INSERT INTO bmo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ti S̈hata mfuʼu Shata, kaŋ a thi pi moŋ minduoŋnduoŋ ni noŋ yi, shaʼafuoŋ yi lara pi nɛiŋ? ");
INSERT INTO bmo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ti ä mbɔ ŋa m̀fuʼu miŋwɛiŋ pi ni ghrɨ́ Bɛjɛbu, kaŋ pa ghaŋ younjiŋ pəɨ ghà, mfuʼu yugu kiʼɛ pi ni ghrɨ́ gɔ̌? Nthɛ yie ghɔ, pugu shi mbɔ pa ŋgwa haʼaŋ pugu shi nshaʼa vəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ndɔ ä mbɔ ŋa m̀fuʼu pa miŋwɛiŋ pi ni Jijwɛ Minnwi, kaŋ Shaʼafuoŋ Minnwi thɔ shɨna pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ki minthɛ ŋoŋ kie nɛiŋ nii nda ŋgaŋ ghrɨ́ ntiɛŋ maoŋ pi ŋgə̄ɨ nɔ ghɔ ki lɔ mfǔoŋ ŋkrao ŋgaŋ ghrɨ́ ghɔ. A wuʼɔ kəʼɨ ghɔ, ŋa minthɛ a tiɛŋ maoŋ pi ntaoŋ nɔ nda yu. ");
INSERT INTO bmo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Shesheŋoŋ ŋa a lɔ mbɔ ŋgei mu nɛ mbɨ̌na a, ŋoŋ ŋa pigi yu lɔ ŋkɨrɨ nu kaʼa nɛ thɔ nshaaŋshaaŋ. ");
INSERT INTO bmo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Nthɛ yie ghɔ, ǹshwei vəɨ, pi shi ndīʼɛ sheshe phɨ pugu pa chrà nchɨʼəshə ŋa ŋgwa chrā nɛ, ndɔ ti shesheŋoŋ ŋa a shi nchrā chrà nchɨʼəshə nɔ ligi Jijwɛ Minnwi nɛ, mbaʼa pi līʼɛ phɨ yi. ");
INSERT INTO bmo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Shesheŋoŋ ŋa a shi nchrā nnu pɨphɨ nthɛ Muuŋ Ŋoŋmishua nɛ pi shi ndīʼɛ phɨ yi, ndɔ shesheŋoŋ ŋa a chrā phɨ nthɛ Jijwɛ Minnwi nɛ, mbaʼa pi līʼɛ phɨ yi moŋ yei mbhi ndwɛ ki moŋ yɛ ŋa a thɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Chwīe thɨ pwa kaŋ ntíɛŋ yi shi mbwa, ndāa nnɛ ɔ chwīe a pɔ yi pɨphɨ, ntíɛŋ yi pɔ yi pɨphɨ, nthɛ ŋa pi ghà nji thɨ pi ŋkuoŋ ntíɛŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mbhɛ mitwɛʼi pei! Pəɨ nthɛ pəɨ kie pi nɛiŋ nchrā nnu shiʼi ŋa pəɨ pɔ pi ŋgwa pɨphɨ nɛ. Nthɛ ŋa nchò ghà nchrā pi yaoŋ ŋa a pɨgəɨ llɔ moŋ njùʼɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŋoŋ shiʼi ghà nthɔ ni maoŋ shiʼi llɔ moŋ pìɛŋ maoŋ shiʼi pi, ŋoŋ mbɨmbhɨ thɔ ni maoŋ pɨphɨ llɔ moŋ pìɛŋ maoŋ pi pi pɨphɨ. ");
INSERT INTO bmo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ǹshwei vəɨ, moŋ llɛmbhi sháʼa, ŋgwa shi mfɨ̄ʼɨ sheshe muuŋ mi chrà ki tou ŋa a taoŋ nchò pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pi shi ndɔ̄gɔ chrà yɔ nshaʼa ghɔ nɔ ghɔ, nɔ nōoŋ nu ŋa ɔ tɔgɔ sháʼa ki ŋa ɔ gū sháʼa.” ");
INSERT INTO bmo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nnɛ pichəɨ pa ghaŋ yɛʼi gɨ́ Mushi pugu pa ŋgwa Farashi chhu ni Jishɔ ŋa, “Masha, pigi tāʼa nu ŋa ɔ nōoŋ lì pigi yəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A khwɛ̄ ni pugu ŋa, “Ŋgwrɛiŋoŋ pɨphɨ pugu pa ŋgwrɛiŋoŋ ŋa a lɔ ŋkɨna pugu Minnwi ghà ntāʼa pi lì, ndɔ mbaʼa pi nōoŋ kaŋ taʼa lì ghɔ ŋkiɛŋ yi njəɨlɨʼɨ Minnwi mbɔ Jona. ");
INSERT INTO bmo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nthɛ ŋa wuʼɔ nɔ haʼaŋ Jona ni mbɔ puŋ mmɛ shhu nɔ trɛi naoŋchɨ ni trɛi tuʼu nɛ, a wuʼɔ nɔ haʼaŋ Muuŋ Ŋoŋmishua shi mbɔ moŋ njùʼɔ shhɛ nɔ trɛi naoŋchɨ ni trɛi tuʼu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Moŋ llɛmbhi sháʼa, ŋgwa Nineve shi ma ntithi pugu pa ŋgwrɛiŋgwa yei ŋgwɛ̄iŋ vugu nɔ pa ŋgushaʼa, nthɛ ŋa pugu ni mbāʼa ŋkǔnu yugu ni phɨ ndɨɨ ŋa Jona ni nchu chrà Minnwi ni pugu nɛ, ndɔ ti līi njəɨ, yaoŋ ŋa a chaa Jona nɛ pɔ hɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Moŋ llɛmbhi sháʼa, Ŋgwafuoŋ llɔ mbiɛŋ shi ma ntithi pugu pa ŋgwrɛiŋoŋ yei ŋgwɛ̄iŋ vugu nɔ pa ŋgushaʼa nthɛ ŋa a ki nyīeŋ ŋkiɛŋ ntaaŋ ndaoŋ llɔ laʼataoŋ yu nthɔ njwɛrɛ ntɨ́gɨ shiethɔ mbhɔ Fùoŋ Sholomu, ndɔ līi njəɨ, yaoŋ ŋa a chaa Sholomu nɛ pɔ hɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ndɨɨ ŋa jijwɛ miŋwɛiŋ taoŋ mbɨŋ ŋoŋ nɛ, a nyīeŋ moŋ pa lɨʼɨ yó nthɔ ntāʼa lɨʼɨ fɛrɛ noŋ yi, ndɔ paʼa ndɔ njəɨ sheshe yi. ");
INSERT INTO bmo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nnɛ nchhu ŋa, ‘Ǹshi mbɨnɨ nda mu lɨʼɨ ŋa mi ni ndhɔ nɛ.’ A ghà mbɨnɨ, njəɨ moŋ nda a pɔ yi yo ki yaoŋ lɔ mbɔ fɔ, pi kwo yɨ̄gɨ ndɔ nchwīe a kāʼo. ");
INSERT INTO bmo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nɛnnɛ, a pɨ̄nɨ kiʼɛ ndɔ̄gɔ khwachəɨ pichəɨ jijwɛ haʼaŋ pugu pɨgɨ nchaa vi nɛ pugu pugu thɔ nii ndaʼa nu fɔ, chɔmbhi ŋoŋ ghɔ pɨnɨ mbɨgɨ nchaa nɔ haʼaŋ a ni fǔoŋ mbɔ nɛ. A nɔ haʼaŋ a shi mbɔ ni ŋgwrɛiŋoŋ pɨphɨ yei nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nɔ haʼaŋ Jishɔ ni ŋguʼɔ nthɔ nchrā nu ni ŋgwa pighɔ nɛ, ŋga njəɨ nu mǔuŋ vi pugu pa lǐŋ pi pi pimbia thi mbhi nthɔ ntāʼa nu nchrā pugu pugu. ");
INSERT INTO bmo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nɛnnɛ, pichəɨ pa ŋgwa ŋa pugu ni nthi fɔ nɛ chhu ghɔ ŋa, “Līi njəɨ, mǔuŋ ghɔ pugu pa lǐŋ pɔ pi pimbia pɔ nɛ mbhi ntāʼa nu ŋa pəɨ pugu chrā.” ");
INSERT INTO bmo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ndɔ Jishɔ khwɛ̄ ni ŋoŋ ghɔ ŋa a ni nchhu ghɔ nɛ ŋa, “Mǔuŋ a pɔ pi gɔ̌, pa lǐŋ paŋ pɔ pa gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mfɛ mbhɔ yi nshwɛ̄ pa ghaŋ younjiŋ pi nchhu ŋa, “Līi njəɨ, mǔuŋ a pugu pa lǐŋ paŋ pɔ nɛiŋ! ");
INSERT INTO bmo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nthɛ ŋa shesheŋoŋ ŋa a chwīe nnu ŋa Tǎa a po tāʼa nu nɛ, ndǐŋ a yi mimbia pugu yi miŋgwɛ ni mǔuŋ a.” ");
INSERT INTO bmo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wuʼɔ llɛ́ ghɔ, Jishɔ taoŋ nda ŋgə̄ɨ nchhɔ ŋkɨŋ ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mmɛ yú ŋgwa kɨrɨ yəɨ yu ti a nii pi moŋ kikuoŋ nchɔchhɔ fɔ, yú ŋgwa pighɔ thi ŋkɨŋ ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A chhu ntou pa nnu ni pugu moŋ luʼɔ chrà ŋa, “Ŋoŋ chəɨ ni ma mbɔ fɔ ŋgə̄ɨ lɨʼɨ māʼaŋ mbhɛ̌ maoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nɔ haʼaŋ a ni māʼaŋ nu nɛ, pichəɨ gū shhɛmbua, pa mishi shwiʼi ŋkru. ");
INSERT INTO bmo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pichəɨ gū moŋ shhɛ ŋkwá lɨʼɨ haʼaŋ ntou nchíʼa shi ki lɔ mbɔ nɛ, njiʼa ŋkhɛkhɛ nthɛ ŋa nchíʼa shi ki lɔ njiɛŋ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ndɔ minaoŋ ghà nthɛ ntūoŋ vugu, nthɛ ŋa pugu shini ndɔ mfāʼo ŋǐeŋ yugu nɛ, pugu kāʼo mbraoprao ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pichəɨ mbhɛ̌ gū moŋ shishaʼa, shishaʼa yīʼɛ ŋkuʼɔ mfīgi maoŋ pighɔ pugu khu. ");
INSERT INTO bmo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pichəɨ mbhɛ̌ maoŋ pighɔ gū moŋ shhɛ shiʼi, mbūgu fɔ ŋkuʼɔ nja njuŋ: pichəɨ yuŋ taʼa ŋkɨɨ yi, pichəɨ yuŋ ntɨgao wuŋ yi, pichəɨ yuŋ trɛi wuŋ. ");
INSERT INTO bmo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ŋoŋ ŋa a fāʼo tə́nə nɛ, â yaʼo.” ");
INSERT INTO bmo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nnɛ pa ghaŋ younjiŋ pi thɔ nchhu ghɔ ŋa, “A chwīe khɔ ɔ chrā nu ni pugu pi moŋ luʼɔ chrà?” ");
INSERT INTO bmo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jishɔ khwɛ̄ ni pugu ŋa, “Pi fɛ njɨ ni pəɨ ŋa pəɨ ji pa nnu lə̄ɨŋ ŋa a pɔ moŋ Shaʼafuoŋ Po nɛ, ndɔ paʼa ndɔ mfɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nthɛ ŋa ni ŋoŋ ŋa a kwo fāʼo nɛ, pi shi mbīgi ntou yi a fāʼo a yiɛŋ, ndɔ ni ŋoŋ ŋa a lɔ mfāʼo nɛ, njiʼi nthɛ pi shɨgɛi yɛ ŋa a fāʼo nɛ, pi shi ŋka kwekwe. ");
INSERT INTO bmo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","A chwīe yie ǹchrā ni pugu pi moŋ luʼɔ chrà nthɛ ŋa, Pugu shi njəɨ nu ndɔ paʼa ndɔ njəɨ, njaʼo nu ndɔ paʼa ndɔ njaʼo ki nji. ");
INSERT INTO bmo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nnɛ nnu ŋa njəɨlɨʼɨ Minnwi mbɔ Ishaya ni nchhu nɛ wɛ̄iŋ vugu, nnu ghɔ ni mbɔ ŋa, ‘Pəɨ shi nja njaʼo ndɔ paʼa ndɔ nji njiŋ yi, Pəɨ shi nja ndīi ndɔ paʼa ndɔ njəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nthɛ ŋa njùʼɔ ŋgwa pei kwo fɨ̄nɨ, tə́nə yugu chri ki lɔ nuʼuŋ njaʼo lɨʼɨ, pugu kwo kwiri ligi yugu nnɛ ŋa kiʼi pugu yəɨ ni ligi yugu, njaʼo ni tə́nə yugu, nji ni njùʼɔ yugu ŋkara mbara a, ǹchwīe pugu pɔ shiʼi.’ ");
INSERT INTO bmo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ndɔ ni pəɨ, pəɨ fāʼo mbɔrɔ, nthɛ ŋa ligi yəɨ yəɨ lɨʼɨ tə́nə yəɨ yaʼo lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nthɛ ŋa shishini ǹshwei vəɨ, ntou pa njəɨlɨʼɨ Minnwi pugu pa ŋgwa ndɨndɨ ni njūa nu nɔ yəɨ nu nnu ŋa pəɨ yəɨ nɛ, ndɔ paʼa ndɔ njəɨ, njūa nɔ yaʼo nu nnu ŋa pəɨ yaʼo nɛ, ndɔ paʼa ndɔ njaʼo. ");
INSERT INTO bmo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yaʼo nɛ njiŋ luʼɔ chrà nthɛ ŋgaŋ māʼaŋ mbhɛ̌. ");
INSERT INTO bmo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ndɨɨ ŋa shesheŋoŋ yaʼo chrà Shaʼafuoŋ Po ki lɔ nji njiŋ yi nɛ, ŋoŋ mbɨmbhɨ thɔ mfuʼu yaoŋ ŋa pi phi njùʼɔ yu nɛ. Yei pɔ nɔ yɛ mbhɛ̌ ŋa pugu ni ŋgū pi shɛmbua nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pɛ mbhɛ̌ maoŋ ŋa pugu ni ŋgū pi moŋ shhɛ ŋkwá nɛ pɔ pi pɛ ŋgwa ŋa pugu yaʼo chrà Minnwi njiʼɛ ŋkwe ni pwanjuʼɔ ");
INSERT INTO bmo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ndɔ paʼa ndɔ mfāʼo ŋǐeŋ yugu yi tɨtɨnɨ, ŋguʼɔ ntithi pi nɔ muuŋ kuo ndɨɨ, mōoŋ nu pugu pa ŋgəʼɨ gha nthɔ nthɛ chrà ghɔ ŋa pugu yaʼo nɛ, pugu pāʼa ŋkǔnu yugu ni chrà ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pɛ mbhɛ̌ ŋa pugu ni ŋgū moŋ shishaʼa nɛ, pɛ ŋgwa ŋa pugu yaʼo chrà Minnwi, ŋga ŋgə̄ɨ, pa ghaghana ŋkuoŋ mbhi yei, pugu pa mifɨɨ ŋa pa fāʼo ghà nthɔ nɔ nɛ fīgi chrà ghɔ paʼa a lɔ ma njuŋ ntíɛŋ. ");
INSERT INTO bmo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pɛ mbhɛ̌ ŋa pi ni mbhi moŋ shhɛ shiʼi nɛ pɛ ŋgwa ŋa pugu yaʼo chrà Minnwi ndɔ nji njiŋ yi, nja njuŋ ntíɛŋ, pichəɨ yuŋ ti nchəɨŋ taʼa ŋkɨɨ yi, pichəɨ pɔ ntɨgao wuŋ, pichəɨ pɔ trɛi wuŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jishɔ pɨnɨ nchhu yichəɨ luʼɔ chrà ni pugu: “A nthɛ pi māʼaŋ fɨʼɨ Shaʼafuoŋ Po ni ŋoŋ ŋa a ni māʼaŋ mbhɛ̌ maoŋ shiʼi moŋ nyìeŋ yu ");
INSERT INTO bmo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ndɔ nɔ haʼaŋ ŋgwa pi ni ndhɛ nu nɛ, mbɨ̌na vi thɔ māʼaŋ mbhɛ̌ trǔ shɨna pa shíe gɛ pighɔ ŋgə̄ɨ ni vhi. ");
INSERT INTO bmo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Maoŋ pighɔ gha ŋkhɛ̄ ti njuŋ nu, pa trǔ pighɔ khɛ̄ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Pa puoŋ fàʼa ŋoŋ ghɔ thɔ nchhu ghɔ ŋa, ‘Masha, ɔ ni māʼaŋ pi ŋkiɛŋ mbhɛ̌ moŋ nyìeŋ, ti a kie pi nɛiŋ pa trǔ pɔ moŋ ghɔ?’ ");
INSERT INTO bmo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“A khwɛ̄ ni pugu ŋa, ‘Nnu yei chwīe Mimbɨna.’ “Puoŋ fàʼa pighɔ pie vi ŋa, ‘Ɔ tāʼa nu kiʼɛ ŋa pigi ghə̄ɨ shūʼɔ pa trǔ pighɔ?’ ");
INSERT INTO bmo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ndɔ a khwɛ̄ ni pugu ŋa, ‘Ŋga! A nthɛ pəɨ gha nthɔ nshūʼɔ pa trǔ, nshūʼɔ pa shíe gɛ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pəɨ mieŋ ŋguoŋ yi ghao kuʼɔ kaʼa ti ndɨɨ kwōo nuʼuŋ nthɔ, moŋ ndɨɨ kwōo, ǹshi nshwei ni ghaŋ kwōo ŋa, p̂əɨ fǔoŋ nshūʼɔ pa trǔ, ŋkrao moŋ pa káʼa ntūoŋ, ndɔ nshūʼɔ shíe gɛ kiʼɛ nūʼɔŋ shaoŋ mu.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jishɔ pɨnɨ nuʼuŋ nchhu yichəɨ luʼɔ chrà ni pugu, “Shaʼafuoŋ Po pɔ pi nɔ mbhɛ̌ yaoŋ mbɔ ŋkiɛŋ yi gɛ, ŋa ŋoŋ lɔ̄gɔ ŋgə̄ɨ māʼaŋ moŋ nyìeŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A lɔ mbɔ ŋgɨgɛi nchaa ŋguoŋ pa pichəɨ mbhɛ̌ maoŋ, ndɔ a gha ŋkuʼɔ, mbɔ ŋkiɛŋ mmɛ yi nchaa ŋguoŋ yaoŋ moŋ nyìeŋ, ŋgū thɨ, nnɛ pa mishi thɔ ŋkrao pa nda pugu ŋkuoŋ pa mbhɔ mi.” ");
INSERT INTO bmo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A pɨnɨ nuʼuŋ nchhu yichəɨ luʼɔ chrà ni pugu ŋa, “Shaʼafuoŋ Po pɔ pi nɔ yaoŋ chwīe prupɨna kuʼɔ, haʼaŋ miŋgwɛ lɔ̄gɔ niʼiŋ moŋ taʼa brumaʼa prupɨna, a chwīe ŋguoŋ prupɨna ghɔ kuʼɔ ghao.” ");
INSERT INTO bmo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jishɔ ni nchhu ŋguoŋ nnu pei ni pa yú ŋgwa pighɔ moŋ luʼɔ chrà, a shini ndɔ nchhu kaŋ taʼa nnu ni pugu ki lɔ mbɔ pi moŋ luʼɔ chrà. ");
INSERT INTO bmo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yei ni mbɔ nɔ chwīe nu nnu ŋa njəɨlɨʼɨ Minnwi ni nchhu nɛ lɔ̄gɔ lɨʼɨ ŋa, “Ǹshi ŋaʼaŋ nchò a nchrā moŋ pa luʼɔ chrà. Ǹshi nchhu pa nnu ŋa pi shi ki lɔ nji llɔ moŋ ndɨɨ ŋa pi ni nchwīe mbhi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jishɔ ni ŋga mieŋ yú ŋgwa pighɔ nii nda, pa ghaŋ younjiŋ pi thɔ njəɨ vi, nchhu nu ghɔ ŋa, “Fɨ̄ʼɨ njiŋ luʼɔ chrà nthɛ trǔ moŋ nyìeŋ ni pigi.” ");
INSERT INTO bmo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A khwɛ̄ ni pugu ŋa, “Ŋoŋ ghɔ ŋa a māʼaŋ ŋkiɛŋ mbhɛ̌ maoŋ nɛ Muuŋ Ŋoŋmishua. ");
INSERT INTO bmo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Moŋ nyìeŋ ghɔ pɔ ŋkuoŋ mbhi, mbhɛ̌ maoŋ shiʼi pɔ ŋgwa pɛ ŋa pugu puoŋ Shaʼafuoŋ Po nɛ, pa trǔ pɔ pa puoŋ ŋoŋ mbɨmbhɨ, ");
INSERT INTO bmo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","mimbɨna ŋa a phi trǔ ghɔ nɛ pɔ devɨ, maoŋ kwōo pɔ ndɨɨ ŋa mbhi shi ndugwi nɛ, ghaŋ kwōo maoŋ pɔ pa ghaŋ ntaoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Wuʼɔ nɔ haʼaŋ pi ghà ŋkɨrɨ trǔ ntūoŋ ni móŋoŋ nɛ, a wuʼɔ nɔ haʼaŋ a shi mbɔ ndɨɨ ŋa mbhi lūgwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Muuŋ Ŋoŋmishua shi ntaoŋ ghaŋ ntaoŋ pi pugu kɨrɨ ŋguoŋ ŋgwa pɛ ŋa pugu ghà nchwīe ŋgwa chwīe phɨ ndɔ mbəʼɨ kɨna nɛ mfuʼu moŋ Shaʼafuoŋ yi, ");
INSERT INTO bmo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","māʼaŋ vugu moŋ nda móŋoŋ ŋguʼɔ liɛŋ. Moŋ lɨʼɨ ghɔ, kə̄ɨ pugu pa kru shua shi mbɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nnɛ ŋgwa ndɨndɨ thɛ nɔ minaoŋ moŋ Shaʼafuoŋ Tǎa vugu. Shesheŋoŋ ŋa a fāʼo tə́nə nɛ, â yaʼo. ");
INSERT INTO bmo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Shaʼafuoŋ Po pɔ nɔ fàʼo ŋa pi lə̄ɨŋ moŋ nyìeŋ ŋa yichəɨ ŋoŋ ghə̄ɨ njəɨ mbūoŋ. Nnɛ moŋ pwanjuʼɔ yi, a ghə̄ɨ mfīni ŋguoŋ yaoŋ ŋa a fāʼo nɛ ŋgə̄ɨ njuoŋ nyìeŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ŋkamuʼɔŋ, Shaʼafuoŋ Po pɔ nɔ ŋgaŋ piʼɛ taŋ ŋa a ni nthɔ ntāʼa ŋkiɛŋ ŋgùʼɔ tɨnɨnchuoŋ, ");
INSERT INTO bmo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ŋga njəɨ taʼa ŋkiɛŋ ŋgùʼɔ tɨnɨnchuoŋ ŋa pi mɛ̄iŋ ni pəə nɛ, a ghə̄ɨ mfīni ŋguoŋ yaoŋ ŋa a fāʼo nɛ njuoŋ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nɔ pigi nu, yei ŋkwaŋ haʼaŋ Shaʼafuoŋ Po pɔ nɛ. A pɔ nɔ ndáŋ ŋa pi māʼaŋ moŋ ŋkhǐ ŋgwɛ̄iŋ ŋguoŋ ŋkwaŋ shhu ghao. ");
INSERT INTO bmo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ndɨɨ ŋa ndáŋ ghɔ lɨnaoŋ nɛ, ŋgwa shūu ŋkuʼɔ nɔ ghɔ mbhi nchɔchhɔ ntɛrɛ pa ŋkiɛŋ shhu niʼiŋ moŋ pa mikuo mīʼaŋ pi pɨphɨ. ");
INSERT INTO bmo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","A ŋkwaŋ haʼaŋ a shi mbɔ moŋ ndugwi mbhi yei nɛ. Pa ghaŋ ntaoŋ Minnwi shi nthɔ ntɛrɛ ŋgwa pɨphɨ, mfuʼu moŋ ŋgwa ndɨndɨ, ");
INSERT INTO bmo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","māʼaŋ vugu moŋ nda móŋoŋ ŋguʼɔ liɛŋ. Moŋ lɨʼɨ ghɔ, kə̄ɨ shi mbɔ fɔ pugu pa kru shua. ");
INSERT INTO bmo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Thɔ yəɨ shie ni ŋguoŋ nnu pei?” Pugu chhu ghɔ ŋa, “Ooŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A chhu ni pugu ŋa, “Nthɛ yie ghɔ, sheshe ŋgaŋ yɛʼi gɨ́ Mushi ŋa a ŋgaŋ younjiŋ moŋ Shaʼafuoŋ Po nɛ pɔ nɔ ŋgaŋ nda ŋa a fuʼu pa maoŋ fhi pugu pa ndunu maoŋ llɔ moŋ lɨʼɨ nūʼɔŋ pugu.” ");
INSERT INTO bmo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jishɔ ni ŋga mīʼɛŋ pa luʼɔ chrà pei, ndɔllɔ fɔ ŋgə̄ɨ ");
INSERT INTO bmo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ŋga nchəɨŋ moŋ ji laʼataoŋ, nthɔ njɛʼi vugu moŋ nda luoŋ Minnwi yugu. Pa ŋgwa ŋa pugu ni njaʼo nɔ haʼaŋ a yɛʼi nu nɛ ghrāo nchhu ŋa, “Ŋoŋ vei yəɨ fɨʼɨ shiethɔ yei pugu pa ghrɨ́ pi hɨŋ nɔ fāʼa nu tɨtɨnɨ fàʼa pei nɔ ghɔ? ");
INSERT INTO bmo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yei lɔ mbɔ muuŋ kaminda? Ligi mǔuŋ vi lɔ mbɔ Meri? Jɛiŋ, Joshɛ, Shemu pugu Judashi shi lɔ mbɔ pa lǐŋ pi? ");
INSERT INTO bmo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pia pa lǐŋ pi pi piŋgɛ shi lɔ mbɔ hɛiŋ kaʼa? Ti a yəɨ shiethɔ pugu ghrɨ́ pi hɨŋ nɔ chwīe nu ŋkwaŋ nnu pei nɔ ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nnɛ pugu lāa vi. Ndɔ Jishɔ chhu ni pugu ŋa, “Pi shiʼa nchɨ̄ʼə njəɨlɨʼɨ Minnwi ŋkiɛŋ laʼa pugu shɨna ŋgwa pi.” ");
INSERT INTO bmo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A shini ndɔ nchwīe ntou pa nnu ghraoghrao fɔ nthɛ ŋa pugu ni mbɔ ghaŋ ki piŋ. ");
INSERT INTO bmo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hɛrɔ, mbɔ ŋgaŋ shaʼa Galili, ni ŋga njaʼo fɨʼɨ ndighaʼo Jishɔ, ");
INSERT INTO bmo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nchhu ni puoŋ fàʼa pi ŋa, “Yei Jouŋ Ŋgaŋ Fɛ Ŋkhǐ. Pi kuʼɔ vi llɔ moŋ gu, a chwīe yie a fāʼo ghrɨ́ nɔ chwīe nu pa nnu ghraoghrao pei.” ");
INSERT INTO bmo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nthɛ ŋa Hɛrɔ ni ŋkwo wɛ̄iŋ Jouŋ ŋkrao vi māʼaŋ moŋ chə́ɨŋ nthɛ nnu Herodia mbɔ ŋgwɛ Fili ndǐŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nthɛ ŋa nɔ yichəɨ fɨʼɨ ndɨɨ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ ni nthɔ nchhu nu ni Hɛrɔ ŋa, “A lɔ njiʼi ŋkāʼo vɛ ŋa ɔ laŋ Herodia!” ");
INSERT INTO bmo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Njiʼi nthɛ nɔ haʼaŋ Hɛrɔ ni ntāʼa nu njwi vi ndɨɨ ghɔ nɛ, a ni mbɔgɔ pa ŋgwa Juu nthɛ ŋa pugu ni ndɔ̄gɔ Jouŋ nɔ njəɨlɨʼɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pi ni ŋga nthɔ njɨ llɛ́ phi Hɛrɔ, muuŋ Herodia yi miŋgwɛ pini pini shhɨ ŋgwa, túa Hɛrɔ pwa. ");
INSERT INTO bmo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nnɛ, a kāʼa vi ndɔ nshwrɛ̄i ŋa a shi ŋkɨnɛiŋ vi ni sheshe yaoŋ ŋa a shi mbie vi nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mǔuŋ vi chwīe a pie ŋa, “Fɛ thɔ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ vəɨ hɛiŋ ŋkuoŋ pashinja yei.” ");
INSERT INTO bmo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Fùoŋ ni mbɔ ni tuʼuthɔ, ndɔ nthɛ kɨna ŋa a ni ŋkwo shwrɛ̄i shhɨ ghaŋ gɛ̀ pi nɛ, a fɛ gɨ́ ŋa pi thɔ ni thɔ Jouŋ mfɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A taoŋ ŋgwa pi yaʼa thɔ Jouŋ moŋ chə́ɨŋ, ");
INSERT INTO bmo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","nthɔ ni thɔ yi ghɔ ŋkuoŋ pashinja, mfɛ ni muuŋ miŋgwɛ ghɔ, a ghə̄ɨ njəɨ mǔuŋ vi nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pa ghaŋ younjiŋ Jouŋ thɔ ndɔ̄gɔ khu Jouŋ ŋgə̄ɨ ntwei, ndɔ ŋgə̄ɨ nshwei Jishɔ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jishɔ ni ŋga njaʼo yei nnu, ndɔllɔ fɔ moŋ kikuoŋ ŋgə̄ɨ lɨʼɨ ŋa ŋgwa lɔ mbɔ nɛ. Ndɔ pa ŋgwa ni njaʼo, njōu njiŋ yi ni kwo llɔ moŋ pa laʼa. ");
INSERT INTO bmo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","A ni ŋga ntaoŋ ŋkaoŋ mbhi, njəɨ ŋkiɛŋ mmɛ yú ŋgwa, mfāʼo kwoshɨnɨ mbɨŋ pugu, njɨ̄gɨ ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A ni ŋga mbɔ ni fanaoŋ, ghaŋ younjiŋ pi thɔ njəɨ vi nchhu ghɔ ŋa, “Yei pɔ pi lɨʼɨ ŋa ŋgwa lɔ mbɔ, ndɨɨ lɔ ŋkwo ya ŋgə̄ɨ, chhu yú ŋgwa pei ghə̄ɨ moŋ pa laʼa, njuoŋ maoŋ jɨ pugu fɔ njɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ndɔ Jishɔ khwɛ̄ ŋa, “Pugu lɔ njiʼi mfāʼo nɔ ghə̄ɨ nu, p̂əɨ fɛ yaoŋ ni pugu pugu jɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pugu chhu ghɔ ŋa, “Pigi wuʼɔ mfāʼo pi tiɛŋ kəɨŋ brɛi hɛiŋ ni paa shhu.” ");
INSERT INTO bmo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jishɔ chhu ni pugu ŋa, “P̂əɨ thɔ nɔ hɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nɛnnɛ a fɛ gɨ́ ni yú ŋgwa pighɔ ŋa pugu chɔchɔ ŋkuoŋ trǔ. A lɔ̄gɔ tiɛŋ kəɨŋ brɛi ni paa shhu pighɔ, ŋga mbɨʼɨ ligi yi ndīi po, mfɛ tōo nu ni Minnwi. Mbəʼɨ brɛi pighɔ kiʼɛ mfɛ ni pa ghaŋ younjiŋ pi. Pa ghaŋ younjiŋ pi fɛ ni yú ŋgwa pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ŋguoŋ yugu kru ti njru. Pugu ni ndɨ̄ga pa pəʼɨ pəʼɨ pɨgəɨ pi, a lɨnaoŋ paanchrɔ mikuo. ");
INSERT INTO bmo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ŋguoŋ ŋgwa pɛ ŋa pugu ni ŋkru nɛ ni mbɔ tiɛŋ ŋkaŋ pimbia maa ndɔ̄gɔ piŋgɛ pugu pa puoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wuʼɔ ndɨɨ ghɔ Jishɔ chwīe ghaŋ younjiŋ pi nii moŋ kikuoŋ ŋgə̄ɨ shhɨ nɔ shaʼa nu ntaoŋ njiɛŋ hiŋ nɔ haʼaŋ a ni nchhu nu ni kɨrɨ ghɔ ŋa pugu ghə̄ɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","A ni ŋga ŋkwo chhu ni kɨrɨ ghɔ ti pugu ghə̄ɨ, a kuʼɔ ŋkuoŋ mbra lɨʼɨ luoŋ Minnwi təʼɨ vi. Fanaoŋ ni ŋga nthɔ, Jishɔ wuʼɔ mbɔ fɔ təʼɨ vi. ");
INSERT INTO bmo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ndɔ ndɨɨ yei, kikuoŋ ghɔ ni ŋkwo ya ŋgə̄ɨ ndaoŋ shɨga moŋ ŋkhǐ, fɨfrəɨ thɔ ndɨʼɨ vi nthɛ ŋa a ni ntaoŋ pi ŋgei yɛ ŋa pugu ni ŋgə̄ɨ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","A ni ŋga mbɔ ni ndaʼa mbhi laŋ, moŋ shɨna trɛi minaoŋ pugu ntɨgao minaoŋ, a nyīeŋ nu ŋkuoŋ ŋkhǐ nthɔ nu yəɨ pugu. ");
INSERT INTO bmo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ndɔ pa ghaŋ younjiŋ pi ni ŋga njəɨ vi a nyīeŋ nu ŋkuoŋ ŋkhǐ nthɔ nu nɛ, pɔgɔ gu wɛ̄iŋ vugu pugu chhu ŋa, “A pɔ pi ŋkhushɛ!” mbaʼo ŋgòu moŋ pɔgɔ gu. ");
INSERT INTO bmo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ndɔ wuʼɔ chomilaoŋ ghɔ Jishɔ chrā ni pugu, nchhu nu ŋa, “P̂əɨ fāʼo wɛ̄iŋ njùʼɔ, a mmu, kiʼi pəɨ pɔgɔ gu.” ");
INSERT INTO bmo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita chhu ghɔ ŋa, “Taathɔ, ä mbɔ gɔ̀, ɔ fɛ gɨ́ vəɨ ŋa nthɔ ŋkuoŋ ŋkhǐ mbara ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A chhu ghɔ ŋa, “Thɔ.” Nnɛ, Pita taoŋ moŋ kikuoŋ nyīeŋ ŋkuoŋ ŋkhǐ ŋgə̄ɨ lɨʼɨ para Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ndɔ a ni ŋga njəɨ fɨfrəɨ, pɔgɔ gu wɛ̄iŋ vi, a jɛ̄ yie nu, ŋkə̄ɨ ŋa, “Taathɔ, kwe a!” ");
INSERT INTO bmo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jishɔ fɛ mbhɔ yi chomilaoŋ ghɔ ŋgwɛ̄iŋ vi, nchhu nu ghɔ ŋa, “Yo, ŋgaŋ piŋ kikɛʼi vei! A ni nchwīe khɔ ɔ fāʼo khuthɔ?” ");
INSERT INTO bmo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pugu yu gha nii moŋ kikuoŋ, fɨfrəɨ ghɔ tithi. ");
INSERT INTO bmo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ŋgwa pɛ ŋa pugu ni mbɔ moŋ kikuoŋ nɛ ghaʼo vi, nchhu nu ŋa, “Shishini, ɔ Muuŋ Minnwi!” ");
INSERT INTO bmo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pugu ni ŋga nshaʼa, ntaoŋ mbhi lɨʼɨ ŋa pi mɛ̄iŋ ni Gɛnɛsharɛ nɛ, ");
INSERT INTO bmo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","pa ŋgwa lɨʼɨ pighɔ gha nji ŋa a Jishɔ, ntaoŋ ŋgwa moŋ ŋguoŋ krao ŋgei ghɔ, pugu thɔ ni pa ghaŋ ghɨ̌nɔ njəɨ vi nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pugu lɨ̄gəɨ vi ŋa a mieŋ ghaŋ ghɨ̌nɔ wuʼɔ ŋkāoŋ pi po ndhwí yi. Ŋguoŋ ŋgwa ŋa pugu ni ŋkāoŋ ndhwí yi nɛ, noŋ yugu tɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nnɛ, a gha ndara pa ŋgwa Farashi pugu pa ghaŋ yɛʼi gɨ́ Mushi thɔ llɔ Jerushalɛiŋ njəɨ Jishɔ nchhu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“A chwīe khɔ pa ghaŋ younjiŋ pɔ pəʼɨ nùʼɔŋ pa tǎa? Pugu shiʼa njiʼi nshɨ̄gao mbhɔ yugu maa njɨ maoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A khwɛ̄ ni pugu ŋa, “Ti a chwīe khɔ pəɨ pəʼɨ kɨ̀na Minnwi nthɛ nùʼɔŋ yəɨ? ");
INSERT INTO bmo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nthɛ ŋa Minnwi fɛ gɨ́ ŋa, ‘Ghaʼo tǎa ghɔ pugu mǔuŋ ghɔ,’ ndɔ ‘Shesheŋoŋ ŋa a chrā nnu pɨphɨ nthɛ tǎa vi, ki mǔuŋ vi nɛ yiʼi ŋa pi shi njwi vi.’ ");
INSERT INTO bmo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ndɔ pəɨ chhu yəɨ ŋa, ‘Ŋ̈oŋ nchhu ni tǎa vi ki mǔuŋ vi ŋa, “Yaoŋ ŋa ŋ̀ka ni mfɛ vɛ nɛ, mfɛ ni Minnwi,” ");
INSERT INTO bmo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ŋoŋ ghɔ lɔ mfāʼo nɔ ghaʼo nu tǎa vi.’ Nnɛ nthɛ nùʼɔŋ yəɨ, pəɨ chwīe chrà Minnwi pɔ gha. ");
INSERT INTO bmo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pa ŋgwa mifɨɨ pei! Njəɨlɨʼɨ mbɔ Ishaya ni nchhu shini ndɨɨ ŋa a ni nchrā nthɛ vəɨ ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ŋgwa pei ghà ŋgaʼo a pi ni nchò yugu, ndɔ paʼa njùʼɔ yugu lɔ mbara yəɨ mu, ");
INSERT INTO bmo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ghɛ̀rɛ lɔ mbɔ ni pugu moŋ ghaʼo nu ma, nthɛ ŋa pugu yɛʼi nūʼɔŋ ŋgwamishua nɔ haʼaŋ a pɔ pi gɨ́ a!’ ” ");
INSERT INTO bmo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jishɔ mɛ̄iŋ ŋgwa pighɔ pugu thɔ njəɨ vi, a chhu ni pugu ŋa, “P̂əɨ ywɛrɛ ndɔ njaʼo. ");
INSERT INTO bmo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A lɔ njiʼi mbɔ yaoŋ ŋa a ghà nii nchò ŋoŋ nɛ ŋa a ghà mfuo vi, a pɔ pi yaoŋ ŋa a taoŋ nchò yu nɛ. A yie ghɔ mbɔ yaoŋ ŋa a ghà mfuo ŋoŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nnɛ pa ghaŋ younjiŋ pi thɔ njəɨ vi nchhu ghɔ ŋa, “Ɔ ji ŋa pa ŋgwa Farashi fāʼo pɨgɨtua ndɨɨ ŋa pugu yaʼo ɔ chhu nnu yei nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A khwɛ̄ ni pugu ŋa, “Sheshe thɨ ŋa a lɔ mbhi Tǎa a po nɛ, pi shi nshūʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kiʼi pəɨ wie noŋ yəɨ nthɛ vugu. Pugu pa nchriligi nthɔ nōoŋ ndaoŋ ni pa nchriligi. Ndɔ ti n̈chriligi nōoŋ ndaoŋ ni nchriligi, ŋguoŋ vugu gū moŋ tiɛŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ndɔ Pita chhu ghɔ ŋa, “Shwei njiŋ luʼɔ chrà ghɔ ni pigi.” ");
INSERT INTO bmo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A chhu ni pugu ŋa, “Pəɨ wuʼɔ mbou pi lɨna ŋkaa pəɨ? ");
INSERT INTO bmo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Pəɨ lɔ naa njəɨ ŋa sheshe yaoŋ ŋa a nii nchò nɛ tiri nii moŋ puŋ, ntiri ntaoŋ nii moŋ krao? ");
INSERT INTO bmo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ndɔ ti yaoŋ ŋa a taoŋ moŋ nchò nɛ, llɔ pi moŋ njùʼɔ, nchwīe ɔ pɔ yi fuo. ");
INSERT INTO bmo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nthɛ ŋa pa kwàʼa pɨphɨ, jwi nu ŋoŋ, nnu shúoŋ mbhɔ ghaŋ láŋ, ŋguoŋ ŋkwaŋ nnu kwoshuoŋ ghao, ŋgɨna, kwe nu ntie ni mbe pugu pa chrā nu phɨ nɔ ligi ŋoŋ, llɔ pi moŋ njùʼɔ ŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A pa pie ghɔ mbɔ pa maoŋ pɛ ŋa a ghà mfuo ŋoŋ nɛ. Ndɔ jɨ nu yaoŋ ki lɔ nshɨ̄gao mbhɔ shiʼa njiʼi mfuo ŋoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jishɔ lɔllɔ fɔ nshūu mbɨnɨ njiŋnjiŋ ŋgə̄ɨ moŋ krao ŋgei Tairɛ pugu Shidoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ŋga njəɨ nu nɛ, miŋgwɛ Kanaŋ chəɨ llɔ krao ŋgei ghɔ taoŋ mbaʼo ŋgòu nchhu ŋa, “Fāʼo kwoshɨnɨ mbɨŋ mu, yo Taathɔ, Muuŋ Devi, muuŋ a yi miŋgwɛ thɔ mfāʼo ŋgəʼɨ llɔ mbhɔ pa miŋwɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ndɔ paʼa Jishɔ lɔ njiʼi ŋkhwɛ̄ taʼa chrà ghɔ. Ndɔ pa ghaŋ younjiŋ pi thɔ njəɨ vi ndɨ̄gəɨ vi ŋa, “Yōu vi a ghə̄ɨ nthɛ ŋa a nyīeŋ mbaʼo ŋgòu nthɔ nu njiŋ pia!” ");
INSERT INTO bmo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jishɔ khwɛ̄ ŋa, “Pi ni ntaoŋ a pi wuʼɔ ni pa puoŋ Ishrae ŋa pugu pɔ nɔ pa minjɨɨ ŋa pugu phɛ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ndɔ miŋgwɛ ghɔ thɔ ŋkwi kwɛ́rɛ yi shhɨ yu, nchhu nu ŋa, “Taathɔ, ghɛ̄rɛ a.” ");
INSERT INTO bmo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A khwɛ̄ ŋa, “A lɔ njiʼi ŋkāʼo nɔ lɔ̄gɔ nu maoŋ jɨ puoŋ māʼaŋ ni pa miŋgu.” ");
INSERT INTO bmo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Miŋgwɛ ghɔ chhu ŋa, “Ooŋ, ma Taathɔ, ndɔ njiʼi nthɛ pi pa miŋgu ghà njɨ pa ŋkuʼu maoŋ ŋa a gū llɔ ŋkuoŋ taprɛi taathɔ vugu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jishɔ khwɛ̄ ghɔ kiʼɛ ŋa, “Yo, miŋgwɛ vei! Ɔ fāʼo mmɛ piŋ! Nnu ŋa ɔ tāʼa nu nɛ pi shi nchwīe mfɛ vɛ.” Chomilaoŋ ghɔ noŋ muuŋ vi ghɔ kiʼi ndɔ ntɔgɔtɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jishɔ lɔllɔ fɔ ŋgə̄ɨ nyīeŋ nu ŋkɨŋ ŋkhǐ Galili. Ŋkuʼɔ ŋkuoŋ mbra nchɔchhɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ŋkiɛŋ ntou yú ŋgwa thɔ njəɨ vi ni pa ŋkwíni kwo, pa nchriligi, pa sheshe ŋkwaŋ ŋkwíni, pa fhɨncho, pugu pa ntou pichəɨ ghaŋ ghɨ̌nɔ, nūʼɔŋ vugu shhɨ Jishɔ a yɨ̄gɨ ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pa yú ŋgwa pighɔ ni ŋgrāo ndɨɨ ŋa pugu ni njəɨ fhɨncho chrā nu, pa sheshe ŋkwaŋ ŋkwíni pɔ nu shiʼi, pa ŋkwíni kwò nyīeŋ nu, pa nchriligi yəɨ lɨʼɨ. Pugu ghaʼo Minnwi ŋgwa Ishrae. ");
INSERT INTO bmo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jishɔ mɛ̄iŋ pa ghaŋ younjiŋ pi yəɨ yu nchhu ni pugu ŋa, “M̀fāʼo kwoshɨnɨ mbɨŋ yú yei nthɛ ŋa pugu kwo pɔ pigi pugu ndwɛ ni trɛi llɛ́ ndɔ paʼa ndɔ mfāʼo yaoŋ njɨ. Ǹdɔ njiʼi ntāʼa nu mieŋ pugu ghə̄ɨ ni njì, kaŋ minthɛ shɔnɔ ŋgū ndaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pa ghaŋ younjiŋ pi chhu ghɔ ŋa, “Pia shi njəɨ ntou brɛi pi hɨŋ moŋ lɨʼɨ yó yei ti fɨʼɨ mmɛ yú ŋgwa pei kru njru?” ");
INSERT INTO bmo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jishɔ chhu ni pugu ŋa, “Pəɨ fāʼo pi ndigi brɛi yi khɔ?” Pugu chhu ŋa, “Yi khwachəɨ, ni shɨgɛi puoŋ mi shhu.” ");
INSERT INTO bmo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jishɔ chhu ni yú ŋgwa pighɔ ŋa pugu chɔchɔ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A lɔ̄gɔ khwachəɨ ndigi brɛi ghɔ pugu pa shhu ghɔ, ŋga ŋkwo tōo Minnwi, mbəʼɨ mfɛ ni ghaŋ younjiŋ pi, pa ghaŋ younjiŋ pi fɛ ni yú ŋgwa pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ŋguoŋ vugu ghao kru ti njru. Pa ghaŋ younjiŋ pi lɨ̄ga pa pəʼɨpəʼɨ pɨgəɨ pi, a lɨnaoŋ moŋ khwachəɨ mɛmmɛ mikuo. ");
INSERT INTO bmo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ŋguoŋ pimbia pɛ ŋa pugu ni njɨ maoŋ pighɔ nɛ ni mbɔ khwɛ ŋkaŋ yugu, ŋkaoŋ maa ndɔ̄gɔ piŋgɛ pugu pa puoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A gha ŋkwo chhu pa yú ŋgwa pighɔ ghə̄ɨ, a nii moŋ kikuoŋ ŋgə̄ɨ moŋ krao ŋgei Magadaŋ. ");
INSERT INTO bmo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pa ŋgwa Farashi pugu pa ŋgwa Shadushi thɔ njəɨ Jishɔ, ntāʼa nu mōoŋ vi, nchhu ghɔ ŋa a nōoŋ lì ni pugu llɔ po. ");
INSERT INTO bmo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A khwɛ̄ ni pugu ŋa, “A ghà ŋga mbɔ ni fanaoŋ, pəɨ chhu ŋa mbhi shi mbwa nthɛ ŋa pəɨ līi ghaa mbhi njəɨ ŋa a pie. ");
INSERT INTO bmo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A ghà mbɔ ni tutuʼu, pəɨ chhu ŋa, ‘mbɨ̀ shi ndhɔ nthɛ ŋa mbhi pie nshishini.’ Pəɨ ya nji līi nu ghaa mbhi nshwei njiŋ yi ndɔ paʼa ndɔ nji njiŋ pa lì ŋa a thɔ nōoŋ nu moŋ mbhi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ŋgwrɛiŋoŋ pɨphɨ pugu pa ŋgwrɛiŋoŋ ŋa a lɔ ŋkɨna pugu Minnwi ghà ntāʼa pi lì, ndɔ mbaʼa pi yiʼi nōoŋ kaŋ taʼa lì ghɔ ŋkiɛŋ lì Jona.” Nnɛ a mieŋ vugu ŋgə̄ɨ ni vhi. ");
INSERT INTO bmo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pa ghaŋ younjiŋ Jishɔ ni ŋga nshāʼa ntaoŋ njiɛŋ hiŋ, ndīʼɛ nɔ lɔ̄gɔ nu brɛi. ");
INSERT INTO bmo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jishɔ chhu ni pugu ŋa, “P̂əɨ lɨna yishi pa ŋgwa Farashi pugu pa ŋgwa Shadushi.” ");
INSERT INTO bmo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pugu jɛ̄ nthɔ nchrā nu ni noŋ pugu, nchhu nu ŋa, “Pia lɔ nthɔ ni brɛi, a chwīe yie a chhu nnɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ndɔ Jishɔ ni ŋga nji nnu pei, nchhu ŋa, “Yo, ghaŋ fāʼo piŋ kikɛʼi pei, A chwīe khɔ pəɨ chrā nu ni noŋ pəɨ ŋkuoŋ nnu pou brɛi? ");
INSERT INTO bmo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Thɔ yəɨ lɔ naa nshie yaʼa? Pəɨ lɔ ŋkwiŋ tiɛŋ ndigi brɛi yɛ ni tiɛŋ ŋkaŋ pimbia, ni fɨʼɨ mikuo yɛ ŋa pɨgəɨ yi ni ndɨnaoŋ nɛ? ");
INSERT INTO bmo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ki ŋkwiŋ khwachəɨ ndigi brɛi ni khwɛ ŋkaŋ pimbia, ni fɨʼɨ pa mɛmmɛ mikuo ndɨnaoŋ ŋa pəɨ ni ndɨ̄ga nɛ? ");
INSERT INTO bmo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","A pɔ pi nɛiŋ ŋa pəɨ lɔ nji ŋa ǹdɔ njiʼi nchrā nthɛ pi brɛi? P̂əɨ chhɔ ndɨna yishi pa ŋgwa Farashi pugu pa ŋgwa Shadushi.” ");
INSERT INTO bmo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nɛnnɛ thɔ yugu shie kiʼɛ ŋa a shini ndɔ nchhu pi ŋa pugu chhɔ ndɨna yishi brɛi, a ni nchhu pi ŋa pugu lɨna yaoŋ ŋa pa ŋgwa Farashi pugu pa ŋgwa Shadushi ghà ntɨgɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jishɔ ni ŋga nthɔ moŋ krao ŋgei Kaisharia Filipai, mbie ghaŋ younjiŋ pi ŋa, “Ŋgwa ghà nchhu ŋa Muuŋ Ŋoŋmishua pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pugu chhu ŋa, “Pichəɨ chhu ŋa Jouŋ Ŋgaŋ Fɛ Ŋkhǐ, pichəɨ chhu ŋa Elaija, pichəɨ ŋa Jɛrimaya ki taʼa njəɨlɨʼɨ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A chhu ni pugu ŋa, “Ti pəɨ chhu ŋa mi pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Shemu Pita khwɛ̄ ŋa, “Ɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, mbɔ Muuŋ Minnwi maoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jishɔ khwɛ̄ ghɔ ŋa, “Mbɔrɔ pɔ vɛ, ma Shemu muuŋ Jona. A lɔ njiʼi nōoŋ ŋoŋmishua nōoŋ yinɛ nnu vɛ, a nōoŋ Tǎa a ŋa a chhɔ po nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ndɔ ǹshwei ghɔ, ɔ Pita (njiŋ yi pɔ ŋa ŋgùʼɔ), ndɔ ŋkuoŋ ŋgùʼɔ yei ǹshi ŋkrao chɔshi a, ndɔ ti mbaʼa njɨ gu lɛ ŋgaʼa vi. ");
INSERT INTO bmo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ǹshi mfɛ chuʼɔ nda Shaʼafuoŋ Po vɛ, sheshe yaoŋ ŋa ɔ krao ŋkuoŋ shhɛ hɛiŋ nɛ shi mbɔ yi krao po, sheshe yaoŋ ŋa ɔ fēi ŋkuoŋ shhɛ nɛ shi mbɔ yi fēi po.” ");
INSERT INTO bmo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nnɛ, Jishɔ fɛ gɨ́ ni pa ghaŋ younjiŋ pi ŋa kiʼi pugu shwei shesheŋoŋ ŋa a Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jɛ̄ ndɨɨ ghɔ Jishɔ jɛ̄ nōoŋ nu ni ghaŋ younjiŋ pi ŋa a yiʼi ŋa a ghə̄ɨ Jerushalɛiŋ, njəɨ ŋgəʼɨ nthɛ ntou pa nnu llɔ mbhɔ pa thishɨ pugu pa thishɨ ghaŋ fɛʼiŋgiɛŋ ni pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi, pi jwi vi, a gha mbɔ trɛi llɛ́, a kuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita lɔ̄gɔ vi pugu yu ghə̄ɨ lɨʼɨ təʼɨ vugu njɛ̄ pɨ̄ga nu vi, nchhu nu ŋa, “Mbaʼa a yiʼi mbɔ nnɛ vɛ, ma Taathɔ. Mbaʼa nnu yei ma ndɔ̄gɔ lɨʼɨ mbɨŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ndɔ a kara nchhu ni Pita ŋa, “Lɔllɔ yəɨ mu, ma Shata. Ɔ pɔ pi kɨʼɨŋgɨnɨ vəɨ nthɛ ŋa ɔ lɔ njiʼi nūʼɔŋ njùʼɔ yɔ pi ŋkuoŋ pa nnu Minnwi, ɔ ka nūʼɔŋ pi ŋkuoŋ nnu ŋgwamishua.” ");
INSERT INTO bmo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nnɛ Jishɔ chhu ni ghaŋ younjiŋ pi ŋa, “Shesheŋoŋ ntāʼa nu njōu njiŋ a, a mieŋ phi nnu haʼaŋ a khwā nɛ, ntiɛŋ wáʼa yi njōu njiŋ a. ");
INSERT INTO bmo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nthɛ ŋa shesheŋoŋ ŋa a tāʼa nu ndūgu ni chɔmbhi yi nɛ shi shiɛŋ chɔmbhi yi ghɔ, ndɔ shesheŋoŋ ŋa a mīʼaŋ chɔmbhi yi nthɛ a nɛ, shi ndūgu ni chɔmbhi yi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nthɛ ŋa ŋoŋmishua nthɛ a shei pi khɔ nɔ haʼaŋ ä mfāʼo ŋguoŋ mbhi ghao nɔ ji ndɔ nshiɛŋ chɔmbhi yi, ki ŋoŋmishua nthɛ a kwri chɔmbhi yi ŋkwe pi khɔ? ");
INSERT INTO bmo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nthɛ ŋa Muuŋ Ŋoŋmishua shi nthɔ pugu pa ghaŋ ntaoŋ pi moŋ ndighaʼo Tǎa vi, ŋkɨnɛiŋ shesheŋoŋ wuʼɔ ŋkwaŋ nɔ haʼaŋ ŋoŋ ghɔ fāʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Shishini, ǹshwei vəɨ, pichəɨ ŋgwa thi hɛiŋ ŋa mbaʼa pugu yiʼi ŋkhu ŋkaoŋ maa njəɨ Muuŋ Ŋoŋmishua a thɔ nɔ fùoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ntɨgao llɛ́ ni ŋga ntɔgɔ, Jishɔ lɔ̄gɔ Pita, ni Jɛiŋ, ni Jouŋ ndǐŋ vi, pugu pugu kuʼɔ ŋkuoŋ ntaaŋ mbra mbɔ fɔ wuʼɔ pugu. ");
INSERT INTO bmo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nɔ haʼaŋ pugu ni ndīi Jishɔ nɛ, a kwri ligi pugu, miŋi mi thɛ nɔ minaoŋ, ndhwí yi fugu ti nchīa nɔ líʼɛ. ");
INSERT INTO bmo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ŋga njəɨ nu nɛ, Mushi pugu Elaija nōoŋ noŋ yugu, pugu pa Jishɔ chrā nu. ");
INSERT INTO bmo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita chhu ni Jishɔ ŋa, “Taathɔ, a pwa nɔ haʼaŋ pia pɔ hɛiŋ nɛ. Ɔ̈ ŋkhwā, ŋ̀krao trɛi ntǎa hɛiŋ, taʼa yi vɛ, taʼa yi ni Mushi, taʼa yi ni Elaija.” ");
INSERT INTO bmo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","A ni ŋguʼɔ nchrā nu ŋga njəɨ nu nɛ, lúluŋ chiachia kuru vugu, ŋggì chhu moŋ lúluŋ ghɔ ŋa, “Yei ŋkiɛŋ Muuŋ a ŋa ŋ̀khwā, m̀fāʼo pwatua nthɛ vi. P̂əɨ yaʼo mbhɔ yu.” ");
INSERT INTO bmo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pa ghaŋ younjiŋ Jishɔ ni ŋga njaʼo nnu yei, mfūŋ ni thɔ yugu shhɛ, pɔgɔ gu wɛ̄iŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ndɔ Jishɔ thɔ ŋkāoŋ vugu, nchhu nu ŋa, “Pəɨ lɔllɔ, kiʼi pəɨ fāʼo pɔgɔ gu.” ");
INSERT INTO bmo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pugu gha mbɨʼɨ thɔ yugu, paʼa ndɔ njəɨ kaŋ taʼa ŋoŋ ŋkiɛŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nɔ haʼaŋ pugu ni nthɔ nshwiʼi mbra nɛ, Jishɔ fɛ gɨ́ ni pugu ŋa, “Kiʼi pəɨ shwei ŋoŋ ni nnu ŋa pəɨ yəɨ nɛ ti Muuŋ Ŋoŋmishua shi nuʼuŋ ŋkuʼɔ moŋ gu.” ");
INSERT INTO bmo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pa ghaŋ younjiŋ pi pie vi ŋa, “Ti a ni nchwīe khɔ pa ghaŋ yɛʼi gɨ́ Mushi chhu ŋa Elaija shi fǔoŋ nthɔ?” ");
INSERT INTO bmo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A khwɛ̄ ni pugu ŋa, “Elaija thɔ nu, ndɔ shi mbīri ŋguoŋ yaoŋ ghao a kāʼo nɔ haʼaŋ a ni fǔoŋ mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ndɔ ǹshwei vəɨ ŋa Elaija kwo thɔ, ndɔ paʼa pugu lɔ nji vi, pugu fāʼa mbɨŋ yu ŋkwaŋ nɔ haʼaŋ pugu khwā nɛ. A haʼaŋ Muuŋ Ŋoŋmishua ŋkaa yu shi njəɨ ŋgəʼɨ mbhɔ pugu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Thɔ ghaŋ younjiŋ pi shie kiʼɛ ŋa a thɔ nchhu pi Jouŋ Ŋgaŋ Fɛ Ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pugu ni ŋga nthɔ njəɨ yú ŋgwa pighɔ, chəɨ ŋoŋ thɔ njəɨ vi ŋkwi kwɛ́rɛ yi shhɛ shhɨ yu, ");
INSERT INTO bmo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nchhu ŋa, “Taathɔ, fāʼo kwoshɨnɨ mbɨŋ muuŋ a, a ghà ŋgū thɔ, nthɔ njəɨ ŋgəʼɨ ŋkiɛŋ ntou yi. A ghà ŋgū moŋ móŋoŋ pugu pa moŋ ŋkhǐ ŋgɛŋgɛ. ");
INSERT INTO bmo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi ni ndɔ̄gɔ vi nthɔ njəɨ ghaŋ younjiŋ pɔ nɔ ghɔ, ndɔ pugu yɨ̄gɨ ghɨ̌nɔ yi kikie.” ");
INSERT INTO bmo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jishɔ khwɛ̄ ni pugu ŋa, “Ŋgwrɛiŋgwa ki fāʼo piŋ ndɔ mbɔ ŋgwa təɨtəɨ moŋ kwāʼa nu məɨ, mi shi mbɔ pia pi fɨʼɨ yi nɛiŋ? Mi shi mfāʼo wɛ̄iŋ njùʼɔ nthɛ vəɨ pi fɨʼɨ yi nɛiŋ? Pəɨ thɔ nu muuŋ ghɔ hɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jishɔ pɨ̄ga miŋwɛiŋ, ghɔ a taoŋ mbɨŋ muuŋ ghɔ, ghɨ̌nɔ muuŋ ghɔ mmɛ wuʼɔ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pa ghaŋ younjiŋ Jishɔ thɔ njiŋnjiŋ mbara vi mbie vi ŋa, “A ni nchwīe khɔ pigi fuʼu miŋwɛiŋ ghɔ kikie?” ");
INSERT INTO bmo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A chhu ni pugu ŋa, “Nthɛ ŋa pəɨ fāʼo pi puoŋ mi piŋ. Nthɛ ŋa shishini ǹshwei vəɨ, p̈əɨ mfāʼo piŋ, a wuʼɔ ŋkɨgəɨ ti mbɔ pi nɔ ŋkiɛŋ muuŋ mi mbhɛ̌ yaoŋ gɛ, pəɨ chhu ni mbra yei ŋa, ‘Lɔllɔ hɛiŋ nyīeŋ ŋgə̄ɨ hiŋ,’ kaŋ a shi nyīeŋ, ndɔ mbaʼa yichəɨ nnu ghaʼa vəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ndɔ yei ŋkwaŋ miŋwɛiŋ shiʼa ntaoŋ, kaŋ a nɛiŋ pi luoŋ Minnwi ni jī ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nɔ haʼaŋ pa ghaŋ younjiŋ pi ni ŋkɨrɨ nu Galili nɛ, Jishɔ chhu ni pugu ŋa, “Pi tɔthɔ nchaʼa Muuŋ Ŋoŋmishua mfɛ mbhɔ ŋgwamishua. ");
INSERT INTO bmo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pugu shi njwi vi, a gha mbɔ moŋ trɛi llɛ́, Minnwi kuʼɔ ni ju moŋ gu.” Nnu ghɔ ghana vugu ŋkiɛŋ yie ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pugu ni ŋga nthɔ nchəɨŋ Kapanuŋ, pa ghaŋ kwe taashi moŋ Nda Minnwi thɔ njəɨ Pita, nchhu ghɔ ŋa, “Masha yɔ shiʼa mbe taashi moŋ Nda Minnwi?” ");
INSERT INTO bmo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A khwɛ̄ ŋa, “A ghà mbe.” Pita ni ŋga nii nda, a fǔoŋ Jishɔ nchrā ghɔ, nchhu nu ŋa, “Ɔ pīʼi jɔ ŋa, Shemu? Pa fùoŋ ŋkuoŋ mbhi yei ghà ŋkwe shebe ki taashi pi mbhɔ pa gɔ̌? Llɔ mbhɔ puoŋ pugu ki llɔ mbhɔ pa ŋgwa nduoŋ?” ");
INSERT INTO bmo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita khwɛ̄ ŋa, “Pa ŋgwa nduoŋ.” Jishɔ chhu ghɔ ŋa, “A nōoŋ ŋa pa puoŋ lɔ mfāʼo nɔ pe nu. ");
INSERT INTO bmo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ndɔ nɔ chwīe nu ŋa kiʼi túa yugu pɨgɨ, ghə̄ɨ moŋ ŋkhǐ māʼaŋ mbaʼa. Fǔoŋ shhu ŋa ɔ wɛ̄iŋ nɛ, ŋaʼaŋ nchò yi, ɔ shi nɛ njəɨ mbɨŋ fɔ. Fuʼu ŋgə̄ɨ mbe ni pugu nɔ ligi yɔgɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ndɨɨ ghɔ, pa ghaŋ younjiŋ Jishɔ thɔ njəɨ vi mbie vi ŋa, “A gɔ̌ mbɔ ŋoŋ ndiɛŋ moŋ Shaʼafuoŋ Po?” ");
INSERT INTO bmo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nnɛ, Jishɔ gha mɛ̄iŋ muuŋ mbrɔ ntigi vi shɨna pugu ");
INSERT INTO bmo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nchhu ŋa, “Shishini, ǹshwei vəɨ, p̈əɨ mieŋ ki lɔ njiʼi ŋkara mbɔ nɔ puoŋ prɔ paʼa pəɨ lɔ ma nii moŋ Shaʼafuoŋ Po. ");
INSERT INTO bmo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Shesheŋoŋ ŋa a jū noŋ yi mbɔ nɔ muuŋ vei nɛ pɔ ju ŋoŋ ndiɛŋ moŋ Shaʼafuoŋ Po. ");
INSERT INTO bmo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Shesheŋoŋ ŋa a piŋ taʼa muuŋ nɔ yei nɔ ligi a nɛ piŋ pi mmu. ");
INSERT INTO bmo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ndɔ shesheŋoŋ ŋa a chwīe taʼa yi shɨna puoŋ mi puoŋ pei ŋa pugu piŋ a nɛ kɔ̄rɔ ŋgū moŋ phɨ nɛ, a nì mbwa ŋa pi chu mmɛ ŋgùʼɔ wuʼɔ yaoŋ mmi yu njīe vi laʼo ŋkhǐ nchaa ŋa a thi sháʼa Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Wuwuru ŋgəʼɨ pɔ ni ŋkuoŋ mbhi nthɛ ŋa pa yaoŋ ŋa a nthɛ a chwīe ŋgwa gū moŋ phɨ nɛ pɔ moŋ ghɔ. Ndɔ a yiʼi ŋa pa yaoŋ nɔ chwīe nu ŋgwa gū moŋ phɨ shi nthɔ. Ndɔ ŋgəʼɨ pɔ ni ŋoŋ ŋa pa nnu pighɔ kie pi mbhɔ yu maa nthɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ndɔ ti kwò yɔ ki mbhɔ yɔ nchwīe ɔ gū moŋ phɨ, ɔ yaʼa vi mīʼaŋ. A pwa ŋa ɔ nii moŋ chɔmbhi nɔ ŋkwíni ki ŋkwíni kwò, nchaa ŋa ɔ fāʼo paa mbhɔ yɔ pugu paa kwò yɔ, pi lɔ māʼaŋ ghɔ moŋ móŋoŋ ki ndugwi yi. ");
INSERT INTO bmo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","L̈igi yɔ nchwīe ɔ gū moŋ phɨ, ɔ fuʼu vi mbɨŋ ghɔ mīʼaŋ. A pwa ŋa ɔ nii chɔmbhi ni taʼa ligi nchaa fāʼo nu paa ligi pi lɔ māʼaŋ ghɔ moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Paʼo nɔ yəɨ nu ŋa pəɨ lɔ nchɨ̄ʼə taʼa puoŋ mi ŋgwa pei, nthɛ ŋa ǹchhu ni pəɨ ŋa ghaŋ ntaoŋ Minnwi pugu ghà ŋguʼɔ mbɔ shhɨ Tǎa a po. ");
INSERT INTO bmo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nthɛ ŋa Muuŋ Ŋoŋmishua ni nthɔ pi nɔ kwe nu ŋgwa pɛ ŋa pugu phɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Pəɨ pīʼi yəɨ ŋa? Ŋ̈oŋ mfāʼo taʼa ŋkɨɨ minjɨɨ, taʼa yi ghə̄ɨ mbhɛ, paʼa ŋoŋ ghɔ lɔ mieŋ ndipuʼu wuŋ ni ndigi ndipuʼu ŋkuoŋ ŋkǔnu, ŋgə̄ɨ nɔ tāʼa nu taʼa yi yɛ ŋa a phɛ nɛ? ");
INSERT INTO bmo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ti ä njəɨ, shishini ǹchhu ni pəɨ ŋa, a shi mfāʼo pwanjuʼɔ nɔ ghɔ nchaa ndipuʼu wuŋ ni ndigi ndipuʼu ŋa pugu lɔ njiʼi mbhɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nnɛ, a lɔ njiʼi mbɔ khwǎ njùʼɔ Tǎa a ŋa kaŋ taʼa yi shɨna puoŋ mi ŋgwa pei phɛ gha. ");
INSERT INTO bmo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“N̈dǐŋ ghɔ nchwīe phɨ mbɨŋ ghɔ, ɔ ghə̄ɨ njəɨ vi nshwei fàŋ yi ghɔ, wuʼɔ shɨna pəɨ yu pi paa. Ti a njwɛrɛ nnu ŋa a chhu nu nɛ, kaŋ ɔ ghɛ̄rɛ ndǐŋ ɔ ŋkwəɨ ni ju. ");
INSERT INTO bmo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ndɔ ä mieŋ ki lɔ njaʼo nnu ŋa ɔ chhu nɛ, ɔ lɔ̄gɔ taʼa ŋoŋ ki paa ŋgwa mbīgi mbɨŋ ghɔ nnɛ ŋa paa ŋgwa ki trɛi ŋgwa shi mbɔ pa miŋkwentie moŋ nnu ŋa pugu chhu nɛ nɔ nōoŋ nu ŋa nnu ghɔ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ndɔ ti ä ndāa ki lɔ njaʼo vugu, ɔ shwei chɔshi nɔ ghɔ. Ti ä mieŋ ki yaʼo njiʼi nthɛ pi mbhɔ chɔshi, pəɨ tuo vi nɔ haʼaŋ pi ghà ntuo ŋoŋ ŋa a lɔ mbiŋ Minnwi nɛ pugu pa ŋgwɛ̄iŋ taashi. ");
INSERT INTO bmo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Shishini, ǹshwei vəɨ, sheshe yaoŋ ŋa pəɨ krao ŋkuoŋ shhɛ hɛiŋ nɛ shi mbɔ yi krao po, sheshe yaoŋ ŋa pəɨ fēi ŋkuoŋ shhɛ nɛ shi mbɔ yi fēi po. ");
INSERT INTO bmo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ŋkamuʼɔŋ ǹshwei vəɨ, p̈əɨ pi paa mbiŋ nnu ŋkuoŋ shhɛ ŋa pəɨ luoŋ nu ŋa Minnwi chwīe nɛ, Tǎa a po shi nchwīe mfɛ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nthɛ ŋa lɨʼɨ ŋa paa ŋgwa ki trɛi ŋgwa kɨrɨ nɔ ligi a nɛ, m̀bɔ fɔ pigi pugu.” ");
INSERT INTO bmo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nnɛ Pita thɔ nchhu ghɔ ŋa, “Taathɔ, ndǐŋ a nthɛ a chwīe phɨ mbɨŋ a pi fɨʼɨ yi nɛiŋ ŋ̀guʼɔ ndīʼɛ phɨ yi liʼɛ? Khwachəɨ ŋgɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jishɔ chhu ghɔ ŋa, “Ŋga, ǹdɔ njiʼi nchhu ŋa khwachəɨ ŋgɛ. Ǹchhu pi ŋa khwachəɨ wuŋ ŋgɛ́ ti nchəɨŋ khwachəɨ lɨʼɨ! ");
INSERT INTO bmo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nthɛ yie ghɔ, minthɛ m̀āʼaŋ fɨʼɨ Shaʼafuoŋ Po pi ni yichəɨ fùoŋ ŋa a ni ntāʼa nu ŋka ŋkrù yi mbhɔ puoŋ fàʼa pi. ");
INSERT INTO bmo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ŋga njɛ̄ pīʼi nu, pi thɔ ni yichəɨ taʼa muuŋ fàʼa yi ghɔ njəɨ vi nɔ ghɔ ŋa ŋkrù taathɔ yi ghɔ ni mbɔ puŋ yu fɨʼɨ mbɨŋ ŋa m̈uuŋ fàʼa mfāʼa a tɔgɔ paa ŋkɨɨ ŋkaŋ ŋgaʼo pi pe vi nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nthɛ ŋa a kaŋ mfɛ paʼa a lɔ mbe nɛ, taathɔ yi fɛ gɨ́ ŋa pi fīni vi pugu pa ŋgwɛ vi, ni puoŋ pi pugu pa ŋguoŋ yaoŋ ŋa a ni mfāʼo nɛ nɔ kɛ̄ʼi nu ŋkrù ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Nnɛ muuŋ fàʼa ghɔ gū ni kwɛ́rɛ yi shhɨ taathɔ yi ghɔ ndɨ̄gəɨ, nchhu nu ŋa, ‘Fāʼo wɛ̄iŋ njùʼɔ mbɨŋ mu, nji ŋa ǹshi ŋkɛ̄ʼi ŋguoŋ ŋkrù yɔ ghao!’ ");
INSERT INTO bmo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nthɛ kwoshɨnɨ, taathɔ muuŋ fàʼa ghɔ, līʼɛ ŋkrù yi ghɔ mieŋ vi a ghə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ndɔ muuŋ fàʼa ghɔ gha ntaoŋ mbhi, njəɨ yichəɨ ŋoŋ ŋa ŋkrù yi ni mbɔ puŋ ŋoŋ ghɔ fɨʼɨ mbɨŋ ŋa m̈uuŋ fàʼa mfāʼa nɔ taʼa ŋkɨɨ llɛ́ pi pe vi nɔ ghɔ nɛ. Ŋgwɛ̄iŋ vi njɛ̄ kiɛŋ nu mmi yi, nchhu nu ŋa, ‘Kɛ̄ʼi ŋkrù a.’ ");
INSERT INTO bmo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ndɔ ŋoŋ ghɔ ŋa a ni mbɔ muuŋ fàʼa nɔ ju nɛ gū shhɛ, ndɨ̄gəɨ vi, nchhu nu ŋa, ‘Fāʼo wɛ̄iŋ njùʼɔ mbɨŋ mu, nji ŋa ǹshi ŋkɛ̄ʼi ŋkrù yɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","A lāa, ŋgə̄ɨ shhɨ ndɔ̄gɔ vi ŋgə̄ɨ niʼiŋ chə́ɨŋ ti a shi nuʼuŋ ŋkɛ̄ʼi ŋkrù yi. ");
INSERT INTO bmo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Pichəɨ pa puoŋ fàʼa ni ŋga njəɨ nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ, a pɨgɨ vugu nshāʼa laʼa muŋu. Pugu ghə̄ɨ mfɨ̄ʼɨ ŋguoŋ nnu ghao ŋa a lɔ̄gɔ lɨʼɨ nɛ ni fùoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nɛnnɛ, a gɛ̄ muuŋ fàʼa ghɔ, nchhu ghɔ ŋa, ‘Muuŋ fàʼa mbɨmbhɨ vei! Ǹdīʼɛ ŋguoŋ ŋkrù yɔ nthɛ ŋa ɔ lɨ̄gəɨ a. ");
INSERT INTO bmo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","A ka ni mfɛ paʼa ɔ lɔ mfāʼo kwoshɨnɨ mbɨŋ muuŋ fàʼa nɔ gɔ̀ wuʼɔ nɔ haʼaŋ ŋki fāʼo kwoshɨnɨ mbɨŋ ghɔ nɛ?’ ");
INSERT INTO bmo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Moŋ pɨgɨtua, fùoŋ ghɔ chaʼa vi mfɛ ŋa pi niʼiŋ vi chə́ɨŋ mfɛ ŋgəʼɨ ghɔ ti a shi nuʼuŋ mbe ŋguoŋ mbɨŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“A haʼaŋ Tǎa a po shi nchwīe ni shesheŋoŋ vəɨ nɔ haʼaŋ p̈əɨ mieŋ ki līʼɛ phɨ pa lǐŋ pəɨ llɔ moŋ njùʼɔ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ndɨɨ ŋa Jishɔ ni ŋkwo mīʼɛŋ chhu nu pa nnu pei nɛ, a lɔllɔ Galili ŋgə̄ɨ krao ŋgei Judia njiɛŋ ŋkhǐ Jodaŋ. ");
INSERT INTO bmo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ntou yú ŋgwa yōu njiŋ yi, a yɨ̄gɨ ghɨ̌nɔ yugu fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pa ŋgwa Farashi thɔ njəɨ vi, mōoŋ vi ni pie nu ŋa, “Gɨ́ Mushi piŋ ŋa ŋoŋ shāaŋ láŋ pugu ŋgwɛ vi nthɛ sheshe nnu?” ");
INSERT INTO bmo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A khwɛ̄ ŋa, “Pəɨ lɔ naa mɛ̄iŋ ŋa ŋoŋ vɛ ŋa a ni nchwīe vugu llɔ moŋ njɛ̄ yi nɛ ni nchwīe mimbia pugu miŋgwɛ ");
INSERT INTO bmo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","nchhu ŋa, ‘Nthɛ yie ghɔ, mimbia shi mieŋ tǎa vi pugu mǔuŋ vi nchīni mbɨŋ ŋgwɛ vi. Pugu pi paa gū taʼa frɛinoŋ’? ");
INSERT INTO bmo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nnɛ pugu lɔ nuʼuŋ mbiʼi paa ŋgwa. Pugu pɔ pi taʼa frɛinoŋ. Nthɛ yie ghɔ, yaoŋ ŋa Minnwi chīni nɛ, kiʼi ŋoŋ fɛ̄nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pugu pie vi ŋa, “Ti a ni nchwīe khɔ Mushi fɛ gɨ́ ŋa pi fɛ ŋwaʼaŋlɨ shāaŋ láŋ mbhɔ miŋgwɛ ghɔ njōu vi a ghə̄ɨ?” ");
INSERT INTO bmo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A chhu ni pugu ŋa, “Nthɛ ŋa thɔ yəɨ ni ŋkwei nɛ, Mushi ni mieŋ ŋa pəɨ shāaŋ láŋ pəɨ pa ŋgwɛ pəɨ. Ndɔ llɔ moŋ njɛ̄ yi a shini ndɔ mbɔ pi nɛnnɛ. ");
INSERT INTO bmo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ndɔ ǹshwei vəɨ ŋa shesheŋoŋ ŋa a shāaŋ láŋ pugu ŋgwɛ vi ŋkiɛŋ ŋa a kwo shúoŋ mbɨnɨ ndaŋ miŋgwɛ nduoŋ nɛ, kwo shúoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pa ghaŋ younjiŋ pi chhu ghɔ ŋa, “Shɨ̀na mimbia pugu ŋgwɛ vi mbɔ pi nɛnɛiŋ, a pwa ŋa ŋoŋ chhɔ ki laŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ndɔ Jishɔ chhu ni pugu ŋa, “Yei ntɨ́gɨ lɔ mbɔ pi ni ŋguoŋ ŋgwa ghao, a wuʼɔ mbɔ pi ni ŋgwa pɛ ŋa Minnwi fɛ ni pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nthɛ ŋa ntou pa nnu pɔ fɔ ŋa a chwīe ki ŋgwa lɔ ndaŋ, pichəɨ pɔ nthɛ ŋa pi ni mbhi vugu ŋa pugu pɔ nɛnnɛ, pichəɨ pɔ nthɛ ŋa ŋgwamishua chwīe ŋa pugu pɔ nɛnnɛ, pichəɨ chwīe noŋ yugu mbɔ nɛnnɛ nthɛ Shaʼafuoŋ Po. Ŋoŋ ŋa a nthɛ a piŋ ntɨ́gɨ yei nɛ chwīe nɛnnɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nnɛ pi thɔ ni pa puoŋ prɔ ŋa a nūʼɔŋ mbhɔ yi mbɨŋ pugu nduoŋ Minnwi mfɛ ni pugu, pa ghaŋ younjiŋ pi pɨ̄ga vugu. ");
INSERT INTO bmo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jishɔ chhu ŋa, “P̂əɨ mieŋ pa puoŋ prɔ thɔ njəɨ a, kiʼi pəɨ pɔ kɨʼɨŋgɨnɨ ni pugu nthɛ ŋa Shaʼafuoŋ Po pɔ pi ni ŋkwaŋ ŋgwa pei.” ");
INSERT INTO bmo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A gha nūʼɔŋ mbhɔ yi mbɨŋ pugu, ndɔllɔ ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yichəɨ ŋoŋ ni nthɔ njəɨ Jishɔ nchhu ŋa, “Masha, a yəɨ ŋkwaŋ nnu shiʼi ŋa minthɛ ǹchwīe nɔ fāʼo nu chɔmbhi ki mmɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A khwɛ̄ ghɔ ŋa, “A chwīe khɔ ɔ pie a ni nnu ŋa a yi shiʼi nɛ? A wuʼɔ Taʼa ŋoŋ shiʼi. Ndɔ ɔ̈ ntāʼa nu nii moŋ chɔmbhi ki mmɛ, ɔ nūʼɔŋ pa kɨ̀na.” ");
INSERT INTO bmo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nnɛ a chhu ghɔ ŋa, “Mbɔ pa pəɨ kɨna?” Jishɔ chhu ŋa, “ ‘Kiʼi njwi ŋoŋ, kiʼi ŋgaŋ láŋ kwoshuoŋ, kiʼi njōo, kiʼi ŋkwe ntie ŋoŋ ni mbe. ");
INSERT INTO bmo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ghaʼo tǎa ghɔ pugu mǔuŋ ghɔ, ŋkhwā taakuo yɔ nɔ haʼaŋ ɔ khwā noŋ yɔ nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Maʼaŋ mikhwa ghɔ chhu ghɔ ŋa, “Ŋ̀kwo nūʼɔŋ ŋguoŋ yei ghao, ti mi pou pi khɔ ŋkamuʼɔŋ?” ");
INSERT INTO bmo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jishɔ chhu ghɔ ŋa, “Ɔ̈ ntāʼa mbɔ yi kaʼokaʼo, ɔ ghə̄ɨ mfīni maoŋ pɔ mfɛ ni ghaŋ pou, kaŋ ɔ shi mfāʼo fàʼo po, ndɔ nthɔ njōu njiŋ a.” ");
INSERT INTO bmo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ndɔ maʼaŋ mikhwa ghɔ ni ŋga njaʼo nnu yei, ndɔllɔ ŋgə̄ɨ moŋ tuʼuthɔ nthɛ ŋa a ni mbɔ ŋkiɛŋ ŋgaŋ fàʼo. ");
INSERT INTO bmo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jishɔ chhu ni pa ghaŋ younjiŋ pi ŋa, “Shishini, ǹchhu ni pəɨ ŋa, a shi ŋguʼɔ ntɔgɔ pi moŋ ghaghaʼa ŋgaŋ fàʼo maa nii moŋ Shaʼafuoŋ Po. ");
INSERT INTO bmo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","M̀bɨnɨ nshwei vəɨ ŋa, a yīʼɛ ni minyieŋləɨ nɔ tɔgɔ nu moŋ mbo mitaʼa nchaa ŋgaŋ fàʼo nɔ nii nu moŋ Shaʼafuoŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pa ghaŋ younjiŋ Jishɔ ni ŋga njaʼo yei, ŋgrāo ŋkiɛŋ ntou yi nchhu ŋa, “A nthɛ a lūgu gɔ̌ kiʼɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ndɔ Jishɔ līi vugu nchhu ŋa, “Ni ŋoŋmishua, minthɛ paʼa a lɔ mfāʼa, ndɔ ni Minnwi, minthɛ a fāʼa.” ");
INSERT INTO bmo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nnɛ Pita khwɛ̄ ŋa, “Līi njəɨ, pigi mieŋ ŋguoŋ yaoŋ ghao njōu njiŋ yɔ, ti pigi shi mfāʼo pi khɔ?” ");
INSERT INTO bmo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jishɔ chhu ni pugu ŋa, “Shishini, ǹchhu ni pəɨ ŋa pəɨ ŋa pəɨ yōu njiŋ a nɛ, a shi ŋga mbɔ moŋ mbhi fhi ndɨɨ ŋa Muuŋ Ŋoŋmishua shi nchhɔ ŋkuoŋ faaŋ ndighaʼo yi nɛ, pəɨ ŋkaa pəɨ shi nchhɔ ŋkuoŋ paanchrɔ faaŋ nthɔ shaʼa paanchrɔ laʼataoŋ Ishrae. ");
INSERT INTO bmo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ŋguoŋ ŋgwa ŋa pugu mieŋ pa laʼa pugu, pa lǐŋ pugu pi pimbia pugu pa piŋgɛ, ki tǎa vugu, ki mǔuŋ vi, ki pa puoŋ pi, ki pa shhɛ pi nthɛ a nɛ, shi mbɨnɨ mfāʼo taʼa ŋkɨɨ lɨʼɨ, mbɨnɨ mfāʼo chɔmbhi ki mmɛ. ");
INSERT INTO bmo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ndɔ ntou ŋgwa ŋa pugu thi shhɨ nɛ shi mbɔ ndugwi njiŋ, pa ndugwi njiŋ thi shhɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Shaʼafuoŋ Po pɔ pi nɔ yichəɨ ŋgaŋ nyìeŋ ŋa a taoŋ ni muuŋ tutuʼu ŋgə̄ɨ lɨʼɨ tāʼa pa puoŋ fàʼa pugu fāʼa moŋ nyìeŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A ni ŋga ŋkwo chrā fɨʼɨ nchuoŋ fāʼa nu taʼa llɛ́, mbɔ fɨʼɨ mbɨŋ ŋa ŋoŋ ghà mfāʼa pi pe vi nɔ taʼa llɛ́ nɛ, ntaoŋ vugu moŋ nyìeŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“A gha ntaoŋ ŋgə̄ɨ taŋ moŋ ndipuʼu minaoŋ ni tutuʼu, njəɨ pichəɨ ŋgwa thi fɔ ki lɔ nthɔ nchwīe yaoŋ; ");
INSERT INTO bmo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","a chhu ni pugu ŋa, ‘Pəɨ ŋkaa pəɨ ghə̄ɨ moŋ nyìeŋ a, sheshe yaoŋ ŋa a kāʼo nɛ ǹshi mbe vəɨ nɔ ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nnɛ pugu ghə̄ɨ. A gha mbɨnɨ mbɔ moŋ paanchrɔ minaoŋ pugu trɛi minaoŋ, a wuʼɔ mbɨnɨ nchwīe pi nɛnnɛ. ");
INSERT INTO bmo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“A gha ŋgə̄ɨ pi tiɛŋ minaoŋ, a pɨnɨ ŋgə̄ɨ njəɨ pichəɨ ŋgwa pugu tithi moŋ taŋ, a chhu ni pugu ŋa, ‘A chwīe khɔ pəɨ thi hɛiŋ ŋguoŋ ndɨɨ ki lɔ nthɔ nchwīe yaoŋ?’ ");
INSERT INTO bmo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Pugu chhu ghɔ ŋa, ‘Nthɛ ŋa ŋoŋ lɔ mbe vigi ni fàʼa.’ “Ŋoŋ ghɔ khwɛ̄ ni pugu ŋa, ‘Pəɨ ghə̄ɨ moŋ nyìeŋ ghɔ ŋkaa pəɨ.’ ");
INSERT INTO bmo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Fanaoŋ gha nthɔ, ŋgaŋ nyìeŋ ghɔ chhu ni ŋoŋ ŋa a ghà ndɨna ni puoŋ fàʼa nɛ ŋa, ‘Mɛ̄iŋ puoŋ fàʼa mbe mbɨŋ yugu llɔ ŋkuoŋ pa ndugwi pi ŋgə̄ɨ nchəɨŋ ŋkuoŋ pa fǔoŋ pi.’ ");
INSERT INTO bmo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ŋgwa pɛ ŋa pi ni ndɔ̄gɔ vugu moŋ tiɛŋ minaoŋ ni ŋga nthɔ, pi pe vugu ni fɨʼɨ mbɨŋ ŋa ŋoŋ ghà mfāʼa taʼa llɛ́ pi pe vi nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ŋgwa pɛ ŋa pi ki fǔoŋ ndɔ̄gɔ vugu nɛ ni ŋga nthɔ, mbīʼi nu ŋa yugu pe shi njiɛŋ, ndɔ shesheŋoŋ vugu ŋkaa pugu fāʼo pi fɨʼɨ mbɨŋ ŋa ŋoŋ ghà mfāʼa taʼa llɛ́ pi pe vi nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pugu ni ŋga ŋkwe mbɨŋ yugu, nduo nu ni ŋgaŋ nyìeŋ ghɔ, ");
INSERT INTO bmo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nchhu nu ŋa, ‘Pɛ ŋgwa ŋa pugu thɔ ni njiŋ nɛ wuʼɔ mfāʼa pi nɔ taʼa awa, ɔ lɔ̄gɔ vigi pugu ŋkuoŋ taʼa nthɨŋkwo, pigi lɔ mbɔ ŋgwa pɛ ŋa pigi fāʼa nɔ taʼa llɛ́ ghɔ ghao, minaoŋ tūoŋ vigi.’ ");
INSERT INTO bmo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ndɔ ŋgaŋ nyìeŋ ghɔ khwɛ̄ ni taʼa yi ŋa, ‘Taannu a, ǹdɔ njiʼi mfāaŋ yichəɨ nnu mbɨŋ ghɔ, pɔgɔ shini ndɔ nchrā ŋa ǹshi mbe ghɔ ni fɨʼɨ mbɨŋ ŋa ŋ̈oŋ mfāʼa taʼa llɛ́ pi pe vi nɔ ghɔ nɛ? ");
INSERT INTO bmo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kwe yaoŋ ŋa a jɔ nɛ ŋgə̄ɨ. Ndɔ ŋ̀khwā nɔ fɛ nu ni ndugwi njiŋ muuŋ fàʼa wuʼɔ fɨʼɨ yaoŋ ŋa m̀fɛ vɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A lɔ ŋkāʼo vəɨ nɔ chwīe nu nnu ŋa ŋ̀khwā nɛ ni yaoŋ ŋa a nyaŋ nɛ, ki ɔ thɔ mfāʼo kighɨʼə nthɛ ŋa ǹōoŋ pwapuŋ nɛ?’ ");
INSERT INTO bmo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Nnɛ, ŋgwa ŋa pugu lūgwi njiŋ nɛ shi nthi shhɨ, pɛ ŋa pugu thi shhɨ nɛ, lūgwi njiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nɔ haʼaŋ Jishɔ ni ŋkuʼɔ nu Jerushalɛiŋ nɛ, a gɛ̄ paanchrɔ ghaŋ younjiŋ pi njiŋnjiŋ, pugu pugu gha mbɔ shɛndaoŋ a chhu ni pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pəɨ līi njəɨ, pia kuʼɔ nu nɛ Jerushalɛiŋ. Pi shi nchaʼa Muuŋ Ŋoŋmishua mfɛ mbhɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi, pugu fɛ njɔ́ gu ghɔ, ");
INSERT INTO bmo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","nchaʼa vi mfɛ mbhɔ pa ŋgwa taoŋ nduoŋ, pugu māʼaŋ vi ni kwə̀ɨŋ, ŋgwie vi ndɔ ŋkwīŋ vi ŋkuoŋ wáʼa, a gha mbɔ moŋ trɛi llɛ́ a pɨnɨ ŋkuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nnɛ, mǔuŋ Jɛiŋ pugu Jouŋ, mbɔ puoŋ Shebedi, ghə̄ɨ njəɨ Jishɔ ŋkwi kwɛ́rɛ yi shhɨ yu nduoŋ yaoŋ mbhɔ yu. ");
INSERT INTO bmo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jishɔ pie vi ŋa, “Ɔ tāʼa pi khɔ?” A chhu ghɔ ŋa, “Kāʼa ŋa paa puoŋ paŋ pei shi nchhɔ, taʼa yi ŋgei mbhɔ yɔ yi jɨ, taʼa yi ŋgei mbhɔ ŋkwrɛi, ndɨɨ ŋa ɔ thɔ nshaʼa fùoŋ yɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jishɔ khwɛ̄ ŋa, “Pəɨ lɔ njiʼi nji yaoŋ ŋa pəɨ pie nu nɛ, minthɛ pəɨ nnu ndua ŋgəʼɨ ŋa ǹshi nnu nɛ?” Pugu khwɛ̄ ghɔ ŋa, “A nthɛ pigi nnu.” ");
INSERT INTO bmo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A chhu ni pugu ŋa, “Pəɨ shi nnu llɔ moŋ ndua a, ndɔ chhɔ nu ŋgei mbhɔ a yi jɨ pugu pa ŋkwrɛi lɔ mfāʼo mmu njɨ nɔ fɛ nu, ndɔ a pɔ pi ni ŋgwa pɛ ŋa Tǎa a kwo pīri ni pugu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ndɔ pɨgəɨ wuŋ ghaŋ younjiŋ Jishɔ ni ŋga njaʼo nnu yei, mbɨgɨ túa ni paa pa lǐŋ pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ndɔ Jishɔ mɛ̄iŋ vugu, pugu thɔ njəɨ vi, a chhu ni pugu ŋa, “Pəɨ ji ŋa pa thishɨ ŋkuoŋ mbhi yei ghà nshaʼa ŋgwa pugu shaʼa, pa mɛmmɛ ŋgwa pugu nōoŋ pi nnu ghrɨ́ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ndɔ mbaʼa a yiʼi mbɔ pi nnɛ ni pəɨ. Shesheŋoŋ ŋa a tāʼa nu nɔ pɔ nu ŋoŋ ndiɛŋ shɨna pəɨ nɛ fāʼo nɔ pɔ nu muuŋ fàʼa vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Shesheŋoŋ ŋa a tāʼa nu mbɔ nthishɨ shɨna pəɨ nɛ, fāʼo nɔ pɔ nu ŋkǔna vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wuʼɔ nɔ haʼaŋ Muuŋ Ŋoŋmishua shini ndɔ nthɔ pi ŋa pi fāʼa mbhɔ yu, a ni nthɔ pi nɔ fāʼa nu ndɔ mfɛ chɔmbhi yi nɔ nchúoŋ yuoŋ thɔ ntou ŋgwa.” ");
INSERT INTO bmo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nɔ haʼaŋ Jishɔ pugu pa ghaŋ younjiŋ pi ni ntaoŋ nu Jeriko nɛ, mmɛ yú ŋgwa yōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Paa pa nchriligi ni nchhɔ ŋkɨŋ ndaoŋ, pugu ni ŋga njaʼo ŋa Jishɔ tɔgɔ nu shɛndaoŋ ghɔ, mbaʼo ŋgòu ŋa, “Taathɔ, fāʼo kwoshɨnɨ mbɨŋ pigi, ma Muuŋ Devi!” ");
INSERT INTO bmo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yú ŋgwa pighɔ pɨ̄ga vugu, nshwei vugu ŋa pugu lɛrɛ laŋ, pugu pɨnɨ nuʼuŋ mbaʼo pi ŋgòu ni njɨ ŋa, “Taathɔ, fāʼo kwoshɨnɨ mbɨŋ pigi, ma Muuŋ Devi!” ");
INSERT INTO bmo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jishɔ gha ntithi, mɛ̄iŋ vugu mbie vugu ŋa, “Pəɨ tāʼa nu ŋa ǹchwīe khɔ mbɨŋ pəɨ?” ");
INSERT INTO bmo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pugu chhu ghɔ ŋa, “Taathɔ, ŋaʼaŋ ligi yigi, pigi yəɨ lɨʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jishɔ fāʼo kwoshɨnɨ mbɨŋ pugu, ŋkāoŋ ligi yugu. Wuʼɔ chomilaoŋ ghɔ ligi yugu chuʼɔ, pugu yəɨ lɨʼɨ, njōu njiŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pugu ni ŋga mbara nu Jerushalɛiŋ, ti ŋkwo chəɨŋ Bɛfɛgɛ ŋkuoŋ Mbra pa Thɨ Olive nɛ, Jishɔ taoŋ paa pa ghaŋ younjiŋ pi shhɨ, ");
INSERT INTO bmo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nchhu nu ni pugu ŋa, “Pəɨ ghə̄ɨ moŋ laʼataoŋ yinɛ shhɨ pəɨ, pəɨ shi ŋga nchəɨŋ fɔ, pəɨ kiʼɛ njəɨ ŋkwɛ́iŋ yəɨ ni muuŋ vi yəɨ yu. Pəɨ kɨ̄gɛi vugu, nthɔ ni pugu mfɛ vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ti s̈hesheŋoŋ nchhu sheshe nnu ni pəɨ, pəɨ chhu ghɔ ŋa, ‘Taathɔ fāʼo chà nɔ ghɔ’ kaŋ a shi mieŋ vugu ni pəɨ wuʼɔ ndɨɨ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yei ni ndɔ̄gɔ lɨʼɨ nɔ chwīe nu nnu ŋa Minnwi ni nchrā ni njəɨlɨʼɨ yi nɛ lɔ̄gɔ lɨʼɨ ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Chhu ni puoŋ laʼataoŋ Shayaoŋ, ‘Līi njəɨ, fùoŋ vəɨ thɔ nu nɛ njəɨ vəɨ moŋ juju, ndɔ nchhɔ ŋkuoŋ ŋkwɛ́iŋ, mbɔ muuŋ ŋkwɛ́iŋ.’” ");
INSERT INTO bmo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pa ghaŋ younjiŋ pi ghə̄ɨ ŋguʼɔ nchwīe pi nɔ haʼaŋ Jishɔ ni nchhu ni pugu ŋa pugu chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pugu ghə̄ɨ nthɔ ni ŋkwɛ́iŋ pugu muuŋ ŋkwɛ́iŋ, nūʼɔŋ pa ndhwí pugu mbɨŋ pugu a kuʼɔ nchhɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ntou ŋgwa moŋ yú ghɔ shɛ̄iŋ pa ndhwí pugu shɛndaoŋ, pichəɨ yaʼa pa mbhɔthɨ nshɛ̄iŋ shɛndaoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yú ŋgwa pighɔ ni ŋgə̄ɨ nu shhɨ yu, pa ŋgwa ŋa pugu ni nthɔ nu njiŋ yu nɛ ni nthɔ mbaʼo ŋgòu ŋa, “Ndighaʼo pɔ ni Muuŋ Devi! Mbɔrɔ pɔ ni ju ŋa a thɔ nɔ ligi Taathɔ nɛ! Ndighaʼo pɔ ni Minnwi ti ŋgə̄ɨ nchəɨŋ fie moŋ ndugwi po!” ");
INSERT INTO bmo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","A gha nii Jerushalɛiŋ, ŋguoŋ laʼataoŋ ghɔ chɨ̄ʼɨ ghao, ŋgwa pie nu ŋa, “Yei pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yú ŋgwa pighɔ khwɛ̄ ŋa, “Yei njəɨlɨʼɨ Minnwi mbɔ Jishɔ llɔ Nasharɛ moŋ Galili.” ");
INSERT INTO bmo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jishɔ ghə̄ɨ Nda Minnwi njōu ŋguoŋ ŋgwa ŋa pugu ni nthɔ mfīni yaoŋ pugu pa ghaŋ yuoŋ yaoŋ moŋ Nda Minnwi, nshrī taprɛi ghaŋ kwri mbɨŋ pugu pa lə̌ɨ ghaŋ ŋgwa pɛ ŋa pugu ni thɔ mfīni pa mintuʼɔlibuŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nchhu ni pugu ŋa, “Pi nāʼaŋ ŋa, ‘Nda a shi mbɔ lɨʼɨ luoŋ Minnwi,’ ndɔ pəɨ lɔ̄gɔ a pɔ pùo pa ŋgɨna.” ");
INSERT INTO bmo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pa nchriligi pugu pa ŋkwíni kwò thɔ njəɨ vi moŋ Nda Minnwi, a chwīe pugu pɔ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ndɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi ni ŋga njəɨ pa mbwambwa nnu ŋa a chwīe, pugu pa mikəʼɨ ŋa pugu ni mbaʼo ŋgòu moŋ Nda Minnwi ŋa, “Ndighaʼo pɔ ni Muuŋ Devi!” nɛ, pugu pɨgɨtua. ");
INSERT INTO bmo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nchhu ni Jishɔ ŋa, “Ɔ yaʼo nnu ŋa ŋgwa pei chhu nu nɛ?” Jishɔ chhu ŋa, “Ooŋ, pəɨ lɔ naa mɛ̄iŋ ŋa, ‘Llɔ nchò pa puoŋ fhu pugu pa puoŋ prɔ ɔ pīri ndighaʼo ŋa pi ghaʼo ghɔ nɔ ghɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jishɔ mieŋ vugu ntaoŋ moŋ laʼataoŋ ghɔ ŋgə̄ɨ Betani ndaʼa fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A ni ŋga mbɔ ni tutuʼu, nɔ haʼaŋ a ni mbɨnɨ nu laʼataoŋ ghɔ nɛ, njì yia vi. ");
INSERT INTO bmo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A gha njəɨ thɨ wùnu ŋkɨŋ shɛndaoŋ, ŋgə̄ɨ fɔ ndɔ paʼa ndɔ njəɨ sheshe yaoŋ ŋkiɛŋ wuʼɔ pa fhɔthɨ. A chhu ni thɨ ghɔ ŋa, “Mbaʼa kaŋ taʼa ntíɛŋ ma nuʼuŋ njuŋ mbɨŋ ghɔ ŋkamuʼɔŋ,” thɨ wùnu ghɔ wuʼɔ mbrāo pi ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pa ghaŋ younjiŋ pi gha njəɨ, ŋgrāo, nchhu nu ŋa, “A kie pi nɛiŋ thɨ wùnu ghɔ kiʼi mbraoprao taʼa ŋgɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jishɔ khwɛ̄ ni pugu ŋa, “Shishini, ǹshwei vəɨ, p̈əɨ mfāʼo piŋ ki lɔ mfāʼo khuthɔ, paʼa pəɨ lɔ ŋguʼɔ nchwīe pi nnu ŋa pi chwīe mbɨŋ thɨ wùnu yei nɛ, p̈əɨ njiʼi nchhu pi ni mbra yei ŋa, ‘Shūʼɔ hɛiŋ ŋgə̄ɨ ŋgū moŋ ŋkhǐ,’ a wuʼɔ mbɔ pi nnɛ. ");
INSERT INTO bmo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sheshe yaoŋ ŋa pəɨ pie moŋ luoŋ nɛ, pəɨ shi ŋguʼɔ mfāʼo nɔ haʼaŋ p̈əɨ mfāʼo piŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jishɔ ni ŋga nii moŋ Nda Minnwi, pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pichəɨ thishɨ thɔ mbara vi nɔ haʼaŋ a ni njɛʼi nu nɛ nchhu ghɔ ŋa, “Ɔ thɔ nchwīe nnu pei pi ni ghrɨ́ gɔ̌, a lɔ mfɛ gɔ̌ mfɛ ghrɨ́ ghɔ vɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jishɔ khwɛ̄ ni pugu ŋa, “Mummu ŋkaa mu shi mbie vəɨ ni taʼa píe, ti p̈əɨ mfɛ khwɛ̀ vəɨ, kaŋ ǹshi nshwei vəɨ ni ghrɨ́ ŋoŋ ŋa ǹthɔ nchwīe nnu pei nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kwe ŋkhǐ Jouŋ ni ndhɔ pi hɨŋ? A ni ndhɔ pi po ki mbhɔ ŋgwamishua?” Pugu chrā nnu yei shɨna pugu, nchhu nu ŋa, “P̈ia nchhu ŋa a ni ndhɔ pi po, a chhu ni pia ŋa ti a ni nchwīe khɔ paʼa pia lɔ mbiŋ vi? ");
INSERT INTO bmo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ndɔ p̈ia nchhu ŋa a llɔ mbhɔ ŋgwamishua, pia thɔ mbɔgɔ nnu ŋa yu ŋgwa pei shi nchwīe nɛ, nthɛ ŋa ŋguoŋ vugu ji ŋa Jouŋ ni mbɔ njəɨlɨʼɨ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nnɛ pugu khwɛ̄ ni Jishɔ ŋa, “Pigi lɔ njiʼi nji.” Jishɔ chhu ni pugu ŋa, “Kaŋ mbaʼa mummu shwei vəɨ ni lɨʼɨ ŋa m̀fāʼo ghrɨ́ nthɔ nchwīe nnu pei nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Pəɨ pīʼi yəɨ ŋa? Yichəɨ ŋoŋ ni mfāʼo paa puoŋ pi mimbia, ŋgə̄ɨ njəɨ fǔoŋ yi nchhu ghɔ ŋa, ‘Muuŋ a, ghə̄ɨ mfāʼa fàʼa moŋ nyìeŋ shiʼa.’ ");
INSERT INTO bmo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Muuŋ ghɔ khwɛ̄ ŋa, ‘M̀baʼa njiʼi ŋgə̄ɨ,’ ndɔ a gha ndara shɨgɛi yi, a kwri njùʼɔ yi, nnɛ ŋgə̄ɨ moŋ nyìeŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ŋoŋ ghɔ ghə̄ɨ mbara yichəɨ muuŋ vi ŋguʼɔ nchhu pi taʼa nnu ghɔ. Muuŋ ghɔ khwɛ̄ ŋa, ‘Ǹshi ŋgə̄ɨ, ma baba,’ ndɔ paʼa ndɔ ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","A yəɨ shɨna paa puoŋ pei ŋa a chwīe nnu ŋa tǎa vi ni ntāʼa nu nɛ?” Pugu chhu ŋa, “Fǔoŋ yi.” Jishɔ chhu ni pugu ŋa, “Shishini, ǹshwei vəɨ, pa ghaŋ wɛ̄iŋ taashi pugu pa shakhɨ thɔ ŋgə̄ɨ nu moŋ Shaʼafuoŋ Minnwi shhɨ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nthɛ ŋa Jouŋ Ŋgaŋ Fɛ Ŋkhǐ ni nthɔ njəɨ vəɨ, nōoŋ ndaoŋ ndɨndɨ ŋa pəɨ tɔgɔ, ndɔ paʼa pəɨ lɔ mbiŋ vi, ndɔ pa ghaŋ wɛ̄iŋ taashi pugu pa shakhɨ piŋ vi, ndɔ njiʼi nthɛ pi ndɨɨ ŋa pəɨ ni njəɨ nnu pei nɛ, paʼa ndɔ ndaʼa ŋkwri njùʼɔ yəɨ mbiŋ vi.” ");
INSERT INTO bmo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jishɔ chhu ŋa, “Pəɨ pɨnɨ njaʼo yichəɨ luʼɔ chrà. Yichəɨ ŋgaŋ nyìeŋ ni mbɔ fɔ ŋa a ni mbhi faaŋ ntíɛŋ thɨ ŋa pi mɛ̄iŋ ni grape nɛ. A ni ŋkrao ŋkaʼa ŋgɨ̄ŋ nɔ, ndɔ ntuo ŋkuʼɔ nɨ̄ɨ ntíɛŋ thɨ ghɔ ŋkhǐ yi taoŋ nɔ chwīe nu làʼo, ndɔ ŋkrao muuŋ nda tɔthɨ nɔ chhɔ nu fɔ ŋkɛ̄ʼi nyìeŋ ghɔ. Mfɛ nyìeŋ ghɔ ni ghaŋ fàʼa ŋa pugu lɨna nu nɔ ghɔ ŋga ŋkwōo maoŋ, pugu pugu ghrā, ndɔllɔ ŋgə̄ɨ laʼataoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ndɨɨ kwōo ntíɛŋ thɨ ghɔ ni ŋga ŋkāʼo, a taoŋ puoŋ fàʼa pi ni ghaŋ fàʼa moŋ nyìeŋ ŋa pugu ghə̄ɨ ŋkwe ji ghrà ntíɛŋ thɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Pa ghaŋ fàʼa pighɔ wɛ̄iŋ puoŋ fàʼa pi pighɔ ŋa a ni ntaoŋ nɛ, ŋgwie taʼa yi, njwi taʼa yi, ntuŋ yichəɨ ni ŋgùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ŋgaŋ nyìeŋ ghɔ pɨnɨ ntaoŋ pichəɨ puoŋ fàʼa ŋa pugu yiɛŋ nchaa fǔoŋ pi pɛ ŋa a ni ntaoŋ nɛ, ghaŋ fàʼa moŋ nyìeŋ ghɔ wuʼɔ nchwīe mbɨŋ pugu pi nɛnnɛ. ");
INSERT INTO bmo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ndugwi yi ŋgaŋ nyìeŋ ghɔ taoŋ muuŋ vi, nchhu nu ŋa, ‘Pugu shi ŋgaʼo muuŋ a.’ ");
INSERT INTO bmo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ndɔ pa ghaŋ fàʼa moŋ nyìeŋ ghɔ ghà njəɨ muuŋ vi thɔ nu, pugu chhu ni noŋ pugu ŋa, ‘Yei muuŋ ŋgaŋ nyìeŋ ghɔ ŋa ŋguoŋ maoŋ shi mbɔ ji nɛ, pəɨ thɔ pia jwi vi nshīŋ maoŋ pi.’ ");
INSERT INTO bmo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pugu wɛ̄iŋ vi mfuʼu vi moŋ faaŋ ntíɛŋ thɨ ghɔ māʼaŋ vi mbhi, njwi vi. ");
INSERT INTO bmo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ndwɛ, ndɨɨ ŋa ŋgaŋ faaŋ ntíɛŋ thɨ ghɔ shi nthɔ kiʼɛ nɛ, a shi nchwīe pi nɛiŋ ni ghaŋ fāʼa moŋ nyìeŋ ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pugu khwɛ̄ ghɔ ŋa, “A shi njwi ŋgwa pɨphɨ pighɔ, mfɛ faaŋ ntíɛŋ thɨ ghɔ ni pa ghaŋ fàʼa nduoŋ ŋa pugu shi mfɛ ji ntíɛŋ thɨ ndɨɨ ŋa ndɨɨ kwōo kāʼo nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jishɔ chhu ni pugu ŋa, “Pəɨ lɔ naa mɛ̄iŋ yaoŋ ŋa Ŋwaʼaŋlɨ Minnwi nchhu nɛ yaʼa? ‘Muuŋ nchíʼa yɛ ŋa pəɨ ghaŋ krao nda ni ndāa ŋa a lɔ mfāʼo ghɛ̀rɛ nɛ, pɨnɨ nɛ ŋkara ju mbɔ muuŋ nchíʼa kwonda. Yei fàʼa llɔ mbhɔ Taathɔ, ndɔ mbɔ ŋkiɛŋ nnu pwapwa ligi pia.’ ");
INSERT INTO bmo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nthɛ yie ghɔ, ǹshwei vəɨ, pi shi ŋkwe Shaʼafuoŋ Minnwi mbhɔ pəɨ mfɛ ni ŋgwa pɛ ŋa pugu yuŋ ntíɛŋ ŋa a kāʼo nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Shesheŋoŋ ŋa a gū ŋkuoŋ ŋgùʼɔ yei shi shɨna kraokrao, ndɔ ti a ŋgū ŋgùʼɔ ghɔ mbɨŋ ŋoŋ a nwīʼiŋ vi.” ");
INSERT INTO bmo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋgwa Farashi ni ŋga njaʼo pa luʼɔ chrà pi pei, nji ŋa a ni nchrā nthɛ pi pugu. ");
INSERT INTO bmo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ndɔ njiʼi nthɛ pi nɔ haʼaŋ pugu ni nthɔ ntāʼa nu ŋgwɛ̄iŋ vi nɛ, pugu ni mbɔgɔ pa ŋgwa nthɛ ŋa ŋgwa pighɔ ni ndɔ̄gɔ Jishɔ ŋa a njəɨlɨʼɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jishɔ pɨnɨ nchrā ni pugu ŋkamuʼɔŋ moŋ pa luʼɔ chrà, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Minthɛ pi māʼaŋ fɨʼɨ Shaʼafuoŋ Po pi ni yichəɨ fùoŋ ŋa a ni mbīri jɨ nɔ nnu tini muuŋ vi yi mimbia. ");
INSERT INTO bmo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ntaoŋ puoŋ fàʼa pi ŋa pugu ghə̄ɨ mɛ̄iŋ ŋgwa pɛ ŋa pi ni ŋgɛ̄ vugu nɔ nnu jɨ tini ghɔ nɛ, ndɔ paʼa pugu lɔ ŋkhwā nɔ thɔ nu. ");
INSERT INTO bmo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“A pɨnɨ nuʼuŋ ntaoŋ pichəɨ puoŋ fàʼa, nchhu nu ŋa, ‘Pəɨ chhu ni pa ŋgwa pɛ ŋa pi gɛ̄ vugu nɛ ŋa ŋ̀kwo pīri maoŋ jɨ nɛ, ŋ̀kwo sho pa fua pugu pa naʼaŋ fuʼu, ti mbīri ŋguoŋ yaoŋ a kāʼo. Pəɨ thɔ lɨʼɨ jɨ tini ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ndɔ paʼa pugu lɔ ndīi a fhi nnu, nnɛ pugu ghə̄ɨ ni vugu, taʼa yi moŋ nyìeŋ yu, yichəɨ taʼa yi lɨʼɨ taŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pɨgəɨ yi wɛ̄iŋ puoŋ fàʼa pi pighɔ, mfɛ ŋgəʼɨ ni pugu, njwi vugu. ");
INSERT INTO bmo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Túa fùoŋ ghɔ pɨgɨ, a fɛ gɨ́ ni pa shoogɛ pi pugu ghə̄ɨ njwi ŋgwa pighɔ ŋa pugu ni njwi puoŋ fàʼa pi pighɔ nɛ ndɔ ntūoŋ laʼa muŋu mfɛ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nnɛ fùoŋ ghɔ chhu ni puoŋ fàʼa pi ŋa, ‘Maoŋ jɨ tini ghɔ kāʼo nɛ, ndɔ paʼa pa ŋgwa ŋa ŋki gɛ̄ nɛ lɔ ŋkāʼo ŋkwaŋ ŋgwa ŋa minthɛ pugu jɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nthɛ yie ghɔ, pəɨ taoŋ ŋgə̄ɨ moŋ pa taʼandaoŋ fɨʼɨ ŋgwa ŋa pəɨ yəɨ fɔ nɛ, pəɨ gɛ̄ vugu ŋa pugu thɔ lɨʼɨ jɨ tini ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nnɛ pa puoŋ fàʼa pighɔ ghə̄ɨ moŋ pa shɛndaoŋ, ŋkɨrɨ ŋguoŋ pa ŋgwa ŋa pugu ni njəɨ nɛ, ŋgwa shiʼi pugu pa pi pɨphɨ. Nnɛ nda jɨ tini ghɔ ni ndɨnaoŋ ni ŋgwa ŋa pi gɛ̄ vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ndɔ fùoŋ ghɔ gha nthɔ lɨʼɨ yəɨ pa ghaŋ gɛ̀ pighɔ, njəɨ yichəɨ ŋoŋ fɔ paʼa a lɔ mfāʼo ndhwí tini. ");
INSERT INTO bmo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A chhu ghɔ ŋa, ‘Taannu a, ɔ kie pi nɛiŋ maa nii hɛiŋ ki lɔ njiʼi mfāʼo ndhwí tini?’ Ŋoŋ ghɔ pou chrà. ");
INSERT INTO bmo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nnɛ fùoŋ ghɔ chhu ni pa ghaŋ fàʼa lɨʼɨ tini ghɔ ŋa, ‘Pəɨ krao kwò yi pugu pa mbhɔ mi māʼaŋ vi mbhi moŋ njiŋ. Moŋ lɨʼɨ ghɔ, kə̄ɨ pugu pa kru shua shi mbɔ fɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Nthɛ ŋa pi gɛ̄ ntou ŋgwa, ndɔ ŋguʼɔ ntɛrɛ pi shɨgɛi yi.” ");
INSERT INTO bmo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nnɛ pa ŋgwa Farashi nyiaŋ ntáŋ ŋkwaŋ haʼaŋ a nthɛ pugu pīri Jishɔ ŋgwɛ̄iŋ vi ŋkuoŋ chrà yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nnɛ pugu taoŋ pa ghaŋ younjiŋ pugu pugu pa ŋgwa fùoŋ Hɛrɔ, nchhu nu ŋa, “Masha, pigi ji ŋa ɔ ghà nchrā nnu shini, njɛʼi nnu ŋa Minnwi tāʼa nu nɛ moŋ nnu shini ki lɔ mbɔgɔ ligi shesheŋoŋ nthɛ ŋa ɔ shiʼa njiʼi ndīi pi ŋa ŋoŋ pɔ pi moŋ yəɨ ŋkwaŋ nthɨŋkwo. ");
INSERT INTO bmo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ndwɛ shwei vigi, ɔ pīʼi jɔ ŋa? A kāʼo ŋa pi māʼaŋ taashi ni Kaisha ki ŋga?” ");
INSERT INTO bmo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jishɔ kwo ji ntáŋ pɨphɨ ŋa pugu ni mfāʼo nɛ, nnɛ nchhu ŋa, “Pəɨ tāʼa nu njwɛʼi a ŋa pa ŋgwa mifɨɨ pei? ");
INSERT INTO bmo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pəɨ nōoŋ ndigi mbɨŋ ŋa pi ghà māʼaŋ taashi nɔ nɛ vəɨ.” Pugu thɔ ni ndigi mbɨŋ ghɔ mbɔ fɨʼɨ mbɨŋ ŋa ŋoŋ ghà mfaʼa taʼa llɛ́ pi pe vi nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jishɔ pie vugu ŋa, “Yei thɔ gɔ̌ pugu pa ligi gɔ̌ ŋkuoŋ ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pugu chhu ŋa, “A yi Kaisha.” A chhu ni pugu kiʼɛ ŋa, “Nthɛ yie ghɔ, pəɨ fɛ yaoŋ ŋa a yi Kaisha nɛ ni Kaisha, mfɛ yi Minnwi ni Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pugu ni ŋga njaʼo nnu yei, a ghrāo vugu, pugu lɔllɔ mieŋ vi ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wuʼɔ llɛ́ ghɔ, pa ŋgwa Shadushi ŋa pugu ghà nchhu ŋa ŋoŋ ghà ŋkhu paʼa ndɔ nuʼuŋ ŋkuʼɔ nɛ thɔ njəɨ vi mbie vi ni taʼa pie ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Masha, Mushi ni nchhu ŋa, ‘Ŋoŋ ŋkhu ki lɔ njiʼi mfāʼo muuŋ, a yiʼi ŋa ndǐŋ vi lɔ̄gɔ ŋkugu yi ghɔ mbhi muuŋ nɔ ghɔ nɔ ligi ndǐŋ vi ŋa a khu nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ndwɛ khwachəɨ puoŋ pimbia pichəɨ ni mbɔ shɨna pigi mbɔ taʼa puŋ. Fǔoŋ yi ni ndaŋ ŋkhu ki lɔ njiʼi mfāʼo muuŋ, nnɛ mieŋ ŋgwɛ vi ndǐŋ vi lɔ̄gɔ. ");
INSERT INTO bmo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mbra yi, pugu yichəɨ mbra yi wuʼɔ mbɔ pi nɛnnɛ ti ŋguoŋ vugu pi khwachəɨ nuʼuŋ mmɛ. ");
INSERT INTO bmo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A ni ŋga ndugwi, miŋgwɛ ghɔ khu ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ndwɛ, moŋ llɛmbhi ŋa ŋgwa lɛ mbɨnɨ ŋkuʼɔ moŋ gu nɛ, miŋgwɛ ghɔ shi mbɔ pi ŋgwɛ gɔ̌ shɨna pugu pi khwachəɨ pei, nthɛ ŋa ŋguoŋ yugu ghao ni ndaŋ vi?” ");
INSERT INTO bmo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ndɔ Jishɔ khwɛ̄ ni pugu ŋa, “Pəɨ fāaŋ nthɛ ŋa pəɨ lɔ nji Ŋwaʼaŋlɨ Minnwi ndɔ paʼa ndɔ nji njɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A lɛ ŋga mbɔ ndɨɨ ŋa ŋgwa ŋa pugu khu lɛ mbɨnɨ ŋkuʼɔ nɛ, paʼa ŋgwa lɔ ndaŋ ki ŋgə̄ɨ láŋ. Ŋgwa lɛ mbɔ pi nɔ pa ghaŋ ntaoŋ Minnwi po. ");
INSERT INTO bmo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Ndɔ nthɛ ŋgwa pɛ ŋa pugu shi ndɛ ŋkuʼɔ moŋ gu nɛ, pəɨ lɔ naa mɛ̄iŋ nnu ŋa Minnwi ni nchhu ni pəɨ nɛ: ");
INSERT INTO bmo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘A mmu mbɔ Minnwi Abrahaŋ, mbɔ Minnwi Aiji, mbɔ Minnwi Jakɔ’? A lɔ njiʼi mbɔ pi Minnwi pa ŋgwa khu, a pɔ pi yi ŋgwa maoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yú ŋgwa pighɔ ni ŋga njaʼo yei nnu, ŋgrāo ŋkwaŋ haʼaŋ a ni njɛʼi nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ndɔ pa ŋgwa Farashi ni ŋga njaʼo ŋa Jishɔ chri nchò pa ŋgwa Shadushi, ŋkɨrɨ noŋ yugu taʼa lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yichəɨ taʼa yi shɨna pugu ŋa a ni nji gɨ́ Mushi ŋgaʼa pie Jishɔ ni taʼa pie nɔ mōoŋ nu vi. ");
INSERT INTO bmo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Masha, a yəɨ mbɔ mmɛ kɨ̀na ŋa a chaa ŋguoŋ yi moŋ gɨ́ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A chhu ghɔ ŋa, “ ‘Khwā Taathɔ mbɔ Minnwi yɔ ni ŋguoŋ njùʼɔ yɔ ghao, ŋguoŋ nchə̌ɨ yɔ ghao, ni ŋguoŋ kwāʼa nu mɔ ghao.’ ");
INSERT INTO bmo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yei mmɛ kɨ̀na ndɔ mbɔ fǔoŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mbra yi pɔ nɔ yie ghɔ: ‘Khwā taakuo yɔ nɔ haʼaŋ ɔ khwā noŋ yɔ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ŋguoŋ gɨ́ Mushi ghao pugu pa yaoŋ ŋa pa njəɨlɨʼɨ Minnwi yɛʼi nɛ yɨʼə pi ŋkuoŋ paa kɨ̀na yei.” ");
INSERT INTO bmo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ndɨɨ ŋa pa ŋgwa Farashi ni ŋkɨrɨ taʼa lɨʼɨ nɛ, Jishɔ pie vugu ni taʼa pie, ");
INSERT INTO bmo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","nchhu nu ŋa, “Pəɨ pīʼi yəɨ ŋa nthɛ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ? A pɔ pi muuŋ gɔ̌?” Pugu chhu ghɔ ŋa, “Muuŋ Devi.” ");
INSERT INTO bmo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jishɔ pie vugu kiʼɛ ŋa, “Ti a ki pɔ pi nɛiŋ kiʼɛ Devi moŋ njɨ Jijwɛ Minnwi mɛ̄iŋ vi ŋa ‘Taathɔ,’ nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Taathɔ ni nchhu ni Taathɔ a ŋa, Chɔchɔ hɛiŋ ŋgei mbhɔ a yi jɨ ti ǹshi nuʼuŋ nchwīe pa mimbɨna pɔ pɔ laʼo kwò yɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ti nɔ haʼaŋ Devi mɛ̄iŋ vi ni ‘Taathɔ,’ ti a pɨnɨ ŋkie pi nɛiŋ mbɔ pi muuŋ vi?” ");
INSERT INTO bmo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kaŋ taʼa ŋoŋ shini ndɔ mfāʼo khwɛ̀ nɔ fɛ nu ghɔ, ndɔ paʼa ndɔ nuʼuŋ mbie vi ni kaŋ taʼa pie jɛ̄ llɛ́ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nnɛ Jishɔ chhu ni kɨrɨ ghɔ pugu pa ghaŋ younjiŋ pi ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa ŋgwa Farashi pɔ pi ŋgwa ŋa pi ji vugu nɔ ghaŋ tūgu gɨ́ Mushi. ");
INSERT INTO bmo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nthɛ yie ghɔ, pəɨ yaʼo nchò yugu ndɔ nchwīe ŋguoŋ nnu ŋa pugu shwei vəɨ nɔ ghɔ nɛ, ndɔ ki lɔ mbīni vugu. Nthɛ ŋa pugu ghà nchhu ndɔ paʼa ndɔ nchwīe nnu ŋa pugu chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pugu ghà ŋkrao pa lrì ŋa a ghaʼa nɔ tiɛŋ nu nɛ nūʼɔŋ mbəʼɨ ŋgwa, ndɔ paʼa ndɔ ŋkhwā nɔ fɛ nu muuŋshɨmbhɔ yugu nɔ ghɛ̄rɛ nu ŋgwa pighɔ ni lrì ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Pugu ghà mfāʼa ŋguoŋ yugu fàʼa pi ŋa ŋgwa yəɨ vugu, nthɛ ŋa yugu ŋgrào ŋa pugu ghà nāʼaŋ chrà Minnwi ŋkuoŋ ghɔ nchu nɔ pa yéi yugu pugu pa ŋgei mbhɔ yugu yi ŋkwrɛi nɛ ghaʼo ŋgaʼa ndɔ nchwīe pa yugu shɨ̌gəɨ ŋkuoŋ pa ndhwí pugu shɨga ŋgaʼa. ");
INSERT INTO bmo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pugu khwā pa lə̌ɨ chɨɨchɨɨ lɨʼɨ jɨ pugu pa lə̌ɨ ŋgwa liɛŋ moŋ pa nda luoŋ Minnwi, ");
INSERT INTO bmo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ndɔ ŋkhwā ŋa pi tuʼu noŋ nchrā ni pugu moŋ lɨʼɨ taŋ pugu pa ŋa ŋgwamishua mɛ̄iŋ vugu ŋa ‘Masha.’ ");
INSERT INTO bmo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ndɔ kiʼi pi mɛ̄iŋ vəɨ ŋa ‘Masha,’ nthɛ ŋa pəɨ fāʼo pi wuʼɔ taʼa Masha ndɔ ŋguoŋ vəɨ ghao pɔ pi pa lǐŋ. ");
INSERT INTO bmo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kiʼi pəɨ mɛ̄iŋ shesheŋoŋ ŋkuoŋ shhɛ hɛiŋ ni tǎa vəɨ, nthɛ ŋa pəɨ wuʼɔ fāʼo pi taʼa Tǎa, mbɔ ju ŋa a pɔ po nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kiʼi pi mɛ̄iŋ vəɨ ni ‘pa ghaŋ fɛ ntɨgɨ,’ nthɛ ŋa ŋgaŋ fɛ ntɨ́gɨ wuʼɔ taʼa yi, mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ndɔ ŋoŋ ndiɛŋ shɨna pəɨ shi mbɔ muuŋ fàʼa vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Shesheŋoŋ ŋa a kə̄rə noŋ yi nɛ, pi shi nshwiʼi vi shhɛ, shesheŋoŋ ŋa a shwiʼi noŋ yi nɛ, pi kə̄rə vi. ");
INSERT INTO bmo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ndɔ ŋgəʼɨ shi nii vəɨ ma pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa ŋgwa Farashi. Pəɨ ŋgwa mifɨɨ, nthɛ ŋa pəɨ fɨ̄nɨ Shaʼafuoŋ Po ni ŋgwa, ndɔ pəɨ nduthɔ yəɨ lɔ nii moŋ ghɔ, ndɔ paʼa ndɔ mieŋ ŋgwa haʼaŋ pugu nii nu nɛ ŋa pugu nii. ");
INSERT INTO bmo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ŋgəʼɨ shi nii vəɨ ma pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa ŋgwa Farashi, pa ŋgwa mifɨɨ, nthɛ ŋa pəɨ ghà nchīgi pa piŋgɛ kugu ŋkwe maoŋ pugu, ŋkuru nnu ŋa pəɨ chwīe nɛ ni pa ntaaŋntaaŋ luoŋ Minnwi lɨʼɨ kaʼa, nthɛ yie ghɔ, yəɨ sháʼa shi mbɔ yi wuwuru. ");
INSERT INTO bmo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ŋgəʼɨ shi nii vəɨ, ma pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa ŋgwa Farashi pəɨ ŋgwa mifɨɨ, nthɛ ŋa pəɨ ghà nshāʼa ŋkhǐ pugu pa ndaoŋ ntou nɔ ghə̄ɨ nu kara ŋoŋ a younjiŋ nnu Minnwi yəɨ, ndɔ a gha njōu njiŋ yəɨ, pəɨ chwīe vi a pɨnɨ mbɨgɨ nchaa vəɨ paa lɨʼɨ nɔ ghə̄ɨ nu moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ŋgəʼɨ shi nii vəɨ, ma pa ghaŋ chriligi ŋa pəɨ thɔ nōoŋ ndaoŋ ni ŋgwa nɛ, ŋa pugu chhu ŋa, ‘Ŋ̈oŋ nshwrɛ̄i ligi Nda Minnwi, paʼa nnu lɔ mbɔ, ndɔ ti ŋ̈oŋ nshwrɛ̄i pi laoŋgo ŋa a pɔ moŋ Nda Minnwi nɛ, a yiʼi vi.’ ");
INSERT INTO bmo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pa na ŋa ligi yugu yi chri! A ghaʼo yəɨ? Laoŋgo ki Nda Minnwi ŋa a chwīe laoŋgo ghɔ pɔ yi taoŋtaoŋ nɛ? ");
INSERT INTO bmo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pəɨ ghà mbɨnɨ nchhu ŋa ŋ̈oŋ nshwrɛ̄i lɨʼɨ fɛʼiŋgiɛŋ paʼa nnu lɔ mbɔ, ndɔ ŋ̈oŋ nshwrɛ̄i yaoŋ fɛʼiŋgiɛŋ ŋkuoŋ lɨʼɨ fɛʼiŋgiɛŋ, kaŋ a yiʼi vi. ");
INSERT INTO bmo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pəɨ pa ghaŋ chriligi, a ghaʼo yəɨ nchaa yichəɨ, yaoŋ fɛ́, ki lɨʼɨ fɛʼiŋgiɛŋ ŋa a ghà nchwīe yaoŋ fɛ ghɔ pɔ yi taoŋtaoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Shesheŋoŋ ŋa a shwrɛ̄i lɨʼɨ fɛʼiŋgiɛŋ nɛ, shwrɛ̄i lɨʼɨ ghɔ pugu sheshe yaoŋ ŋa a pɔ ŋkuoŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nnɛ shesheŋoŋ ŋa a shwrɛ̄i Nda Minnwi nɛ, shwrɛ̄i Nda ghɔ pugu Minnwi mbɔ ŋoŋ ŋa a pɔ Nda ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Shesheŋoŋ ŋa a shwrɛ̄i po nɛ, shwrɛ̄i faaŋ Minnwi pugu Minnwi mbɔ ŋoŋ ŋa a chhɔ ŋkuoŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ŋgəʼɨ shi nii vəɨ, ma pa ghaŋ yɛʼi gɨ́ Mushi pugu pa ŋgwa Farashi. Pəɨ pa ŋgwa mifɨɨ. Nthɛ ŋa pəɨ ghà mfɛ shwéi pa mishwrɛi pugu pa pichəɨ pa puoŋ mi mbhɛ ŋa pi ghà niʼiŋ moŋ maoŋ jɨ, ndɔ ki lɔ mfāʼo ndɨɨ nɔ nūʼɔŋ nu pa mɛmmɛ ntɨ́gɨ moŋ ŋwaʼaŋlɨ gɨ́ nɔ pa ndɨndɨ, ni kwoshɨnɨ pugu pa yaʼo nu nchò Minnwi, ndɔ yei pa nnu pɛ ŋa pəɨ kaŋ ni nchwīe ndɔ ki lɔ nchɨ̄ʼə pi ni. ");
INSERT INTO bmo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ghaŋ chri ligi pei ŋa pugu nōoŋ ndaoŋ ni ŋgwa, pəɨ ghà nde minjinji mfuʼu moŋ làʼo yəɨ, ndɔ mmi minyieŋləɨ! ");
INSERT INTO bmo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ŋgəʼɨ shi nii vəɨ, ma ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa ŋgwa Farashi. Pəɨ ghaŋ mifɨɨ! Nthɛ ŋa pəɨ shɨ̄gao ŋkuoŋ ndua pugu pa kumbu ndɔ mooŋ yi lɨnaoŋ ni pɨ̀ga pugu pa pou wɛ̄iŋ nu noŋ. ");
INSERT INTO bmo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pa ghaŋ chri ligi pei mbɔ pəɨ Farashi, pəɨ fǔoŋ nshɨ̄gao pa mooŋ ndua pugu pa mooŋ kumbu nnɛ ŋa minthɛ ŋkuoŋ yi gū yi taoŋtaoŋ ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ŋgəʼɨ shi nii vəɨ, ma pa ghaŋ yɛʼi gɨ́ Mushi pugu pa ŋgwa Farashi. Pəɨ pa ghaŋ mifɨɨ! Pəɨ pɔ nɔ fúŋ ŋa pi shini njùʼɔ ni yaoŋ fhu ŋa a pwa mbhi, ndɔ mooŋ yi lɨnaoŋ ni kwéi khu ŋgwa pugu pa ŋguoŋ ŋkwaŋ maoŋ tɔtrɔ. ");
INSERT INTO bmo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","A haʼaŋ pi līi vəɨ mbhi pəɨ pɔ nɔ ŋgwa ndɨndɨ, ndɔ mooŋ njùʼɔ yəɨ lɨnaoŋ ni nnu mifɨɨ pugu pa ŋguoŋ ŋkwaŋ phɨ. ");
INSERT INTO bmo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ŋgəʼɨ shi nii vəɨ, ma pa ghaŋ yɛʼi gɨ́ Mushi pugu pa ŋgwa Farashi. Pəɨ pa ghaŋ mifɨɨ, pəɨ krao fúŋ pa njəɨlɨʼɨ Minnwi, nchwīe fúŋ pa ŋgwa ndɨndɨ a pwa, ");
INSERT INTO bmo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nchhu nu ŋa, ‘Pigi kaŋ ni mbɔ mbhi pi ndɨɨ pa tǎa pigi, pigi shi kaŋ ndɔ nchɨ kwò pigi pugu nɔ jwi nu pa njəɨlɨʼɨ Minnwi.’ ");
INSERT INTO bmo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Nnɛ pəɨ pa miŋkwentie ni noŋ pəɨ ŋa pəɨ pa puoŋ ŋgwa pɛ ŋa pugu ni njwi pa njəɨlɨʼɨ Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pəɨ ghə̄ɨ nɛ shhɨ mīʼɛŋ nnu pɛ ŋa pa ŋkhu tǎa pəɨ ni njɛ̄. ");
INSERT INTO bmo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Pa mitwɛʼi, pa mbhɛ̌ mitwɛʼi mbɨmbhɨ pei, pəɨ shi ŋkie pi nɛiŋ maa ntei njɔ́ móŋoŋ ŋgùʼɔ liɛŋ shhɛ? ");
INSERT INTO bmo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Nthɛ yie ghɔ, ǹshi ntaoŋ pa njəɨlɨʼɨ Minnwi ni pa ghaŋ shiethɔ ni pa ghaŋ yɛʼi gɨ́ Mushi ni pəɨ. Pəɨ shi njwi pichəɨ, ŋkwīŋ pichəɨ ŋkuoŋ wáʼa, ŋgwie pichəɨ ni ŋgwàŋ moŋ pa nda luoŋ Minnwi pəɨ, mfɛ ŋgəʼɨ ni pichəɨ llɔ moŋ taʼa laʼataoŋ nii moŋ yichəɨ laʼataoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ǹshi ntaoŋ vugu nɛnnɛ, nji ŋa chhǐ ŋguoŋ ŋgwa ndɨndɨ ŋa pi ni nshrāo vugu njwi ŋkuoŋ shhɛ, llɔ thɔ Abe ŋa mbhɔ yi ni mbɔ yi woo nɛ ti ŋgə̄ɨ nchəɨŋ thɔ jwi nu Shakaria, mbɔ muuŋ Bɛrɛkia, shɨna Nda Minnwi pugu lɨʼɨ Fɛʼiŋgiɛŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Shishini ǹshwei vəɨ, ŋguoŋ nnu pei shi nshwiʼi mbɨŋ ŋgwrɛiŋoŋ yei. ");
INSERT INTO bmo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yo, Jerushalɛiŋ, Jerushalɛiŋ! Laʼataoŋ ŋa a jwi pa njəɨlɨʼɨ Minnwi, ntuŋ pa ghaŋ ntaoŋ Minnwi pɛ ŋa pi taoŋ vugu ghɔ nɛ ni ŋgùʼɔ. A fɨʼɨ yi nɛiŋ ŋa mi ni ntāʼa nu ŋkɨrɨ puoŋ pɔ taʼa lɨʼɨ nɔ haʼaŋ miŋguo ghà ŋkɨrɨ puoŋ pi laʼo prǎ yi nɛ, ndɔ paʼa pəɨ lɔ ntāʼa nu! ");
INSERT INTO bmo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Līi njəɨ, nda yəɨ kuʼɔ fùŋ. ");
INSERT INTO bmo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nthɛ ŋa ǹchhu ni pəɨ ŋa, jɛ̄ ndwɛ ŋgə̄ɨ nu shhɨ, mbaʼa pəɨ nuʼuŋ njəɨ a, ti nuʼuŋ nchəɨŋ ndɨɨ ŋa pəɨ shi nchhu ŋa, ‘Mbɔrɔ pɔ ni ju yɛ ŋa a thɔ nɔ ligi Taathɔ nɛ!’ ” ");
INSERT INTO bmo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jishɔ ni ntaoŋ Nda Minnwi ŋgə̄ɨ nu, ndɨɨ ghɔ pa ghaŋ younjiŋ pi thɔ njəɨ vi nthɔ nōoŋ pa nda ghɔ moŋ Nda Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jishɔ chhu ni pugu ŋa, “Pəɨ yəɨ ŋguoŋ maoŋ pei hɛiŋ ghao? Shishini, ǹshwei vəɨ, mbaʼa taʼa ŋgùʼɔ hɛiŋ yiʼi ŋkɨna ŋkuoŋ ndǐŋ vi ki pi lɔ mbūo mfɛ shhɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nɔ haʼaŋ Jishɔ ni nchɔchhɔ ŋkuoŋ Mbra pa Thɨ Olive nɛ, pa ghaŋ younjiŋ pi thɔ njiŋnjiŋ njəɨ vi, nchhu nu ŋa, “Shwei vigi, pa nnu pei shi ndɔ̄gɔ lɨʼɨ pi ndɨɨ khɔ? Lì thɔ nu yɔ pugu pa yi ndugwi mbhi yei shi mbɔ pi khɔ?” ");
INSERT INTO bmo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jishɔ khwɛ̄ ni pugu ŋa, “Pəɨ lɨna nu kiʼi ŋoŋ fɨ̄ɨ vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nthɛ ŋa ntou ŋgwa shi nthɔ nɔ ligi a, nchhu nu ŋa, ‘Mbɔ pi Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ,’ mfɨ̄ɨ ntou ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pəɨ shi njaʼo pa nchhɔ̀ pugu pa pishaʼakhɔ nnu nchhɔ̀. Ndɔ kiʼi pəɨ fāʼo pɔgɔ gu nthɛ ŋa pa nnu pighɔ shi ŋguʼɔ ndɔ̄gɔ lɨʼɨ, ndɔ yinɛ lɔ naa mbɔ ndugwi yi. ");
INSERT INTO bmo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pa laʼataoŋ shi ndɔllɔ māʼaŋ yichəɨ ni nchhɔ̀, ŋgwa taʼa fùoŋ māʼaŋ ŋgwa yichəɨ ni nchhɔ̀. Njì shi ŋgū moŋ pa lɨʼɨlɨʼɨ, shhɛ shi nchɨʼɨ ti shɨna moŋ pa lɨʼɨlɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ŋguoŋ nnu pei pɔ pi nɔ haʼaŋ muuŋ ghà njɛ̄ naoŋ nu miŋgwɛ shūu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nnɛ pi shi nchaʼa vəɨ mfɛ ŋa pi fɛ ŋgəʼɨ ni pəɨ ndɔ njwi vəɨ. Ŋguoŋ pa laʼataoŋ shi mbɨ̄na vəɨ nthɛ a. ");
INSERT INTO bmo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ntou ŋgwa shi ŋgū moŋ piŋ yugu, mfīni noŋ pugu, mbɨ̄na noŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ntou pa njəɨlɨʼɨ mifɨɨ shi nthɔ mfɨ̄ɨ ntou ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nthɛ ŋa phɨ shi mbīgi nɛ, khwǎ ŋa ntou ŋgwa fāʼo nɛ shi ŋkɛrɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ndɔ ŋoŋ ŋa a tīi shii ti nchəɨŋ nɔ ndugwi yi nɛ shi ndūgu. ");
INSERT INTO bmo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ndɔ pi shi nchīi pwa pishaʼakhɔ yei ŋa Minnwi shaʼa fùoŋ yi moŋ ŋguoŋ mbhi yei nnɛ ŋa ŋguoŋ pa laʼataoŋ ghao yaʼo, ndugwi yi thɔ kiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nnɛ ndɨɨ ŋa pəɨ shi njəɨ nnu wuwuru yɛ ŋa a fuo Nda Minnwi nchwīe pi tei nɛ, a thi Lɨʼɨ Taoŋtaoŋ, mbɔ nnu ŋa njəɨlɨʼɨ Minnwi mbɔ Dania ni nchhu nɛ, (shesheŋoŋ ŋa a mɛ̄iŋ yaoŋ yei nɛ pīʼi, nji ŋa a shi nji njiŋ nnu yei), ");
INSERT INTO bmo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nnɛ ŋgwa pɛ ŋa pugu pɔ moŋ Judia nɛ tei ŋkuʼɔ thɔ pa mbra. ");
INSERT INTO bmo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kiʼi ŋoŋ ŋa a chhɔ thɔnda nɛ nuʼuŋ nshwiʼi shhɛ lɨʼɨ lɔ̄gɔ yaoŋ ŋa a pɔ moŋ nda nɛ, ");
INSERT INTO bmo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","kiʼi shesheŋoŋ ŋa a pɔ moŋ nyìeŋ nɛ nuʼuŋ mbɨnɨ laʼa lɨʼɨ lɔ̄gɔ mmɛ ndhwí yi. ");
INSERT INTO bmo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ndɔ a shi mbɔ ŋkiɛŋ wuwuru ŋgəʼɨ ni pa piŋgɛ shūu pugu pa mapuoŋ haʼaŋ pugu thɔ nuʼɔŋ puoŋ nɛ moŋ llɛ́ pighɔ! ");
INSERT INTO bmo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pəɨ luoŋ ni Minnwi ŋa kiʼi nnu pei lɔ̄gɔ lɨʼɨ pi moŋ laoŋ ki llɛ́ ji. ");
INSERT INTO bmo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nthɛ ŋa moŋ pɨɨ ndɨɨ ghɔ, ŋgəʼɨ shi mbɔ ti nchəɨŋ fɨʼɨ ŋkwaŋ nɔ haʼaŋ a lɔ naa ma mbɔ, jɛ̄ ndɨɨ ŋa Minnwi ni mbuoŋ mbhi nɛ ti nthɔ nchəɨŋ ndwɛ, ndɔ paʼa ndɔ mbiʼi piʼi ma nuʼuŋ mbɔ. ");
INSERT INTO bmo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ti pi kaŋ ni mieŋ ki kɛrɛ fɨʼɨ llɛ́ pighɔ paʼa kaŋ taʼa ŋoŋ lɔ ndūgu. Ndɔ nthɛ ŋgwa pɛ ŋa Minnwi ni nchuʼɔ vugu nɛ, Minnwi shi ŋkɛrɛ fɨʼɨ llɛ́ pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nɛnnɛ s̈hesheŋoŋ nchhu ni pəɨ ŋa, ‘Līi njəɨ, Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ pɔ nɛiŋ,’ ki ŋa, ‘A pɔ ni hiŋ!’ Kiʼi pəɨ piŋ, ");
INSERT INTO bmo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","nthɛ ŋa pa mifɨɨ ŋa pugu chhu nu ŋa pi chuʼɔ vugu ntaoŋ nɔ ŋkwe nɛ, pugu pa njəɨlɨʼɨ mifɨɨ shi nōoŋ noŋ yugu, nōoŋ ntou pa mɛmmɛ lì pugu pa nnu ghraoghrao nɔ fɨ̄ɨ nu pa ŋgwa ti mfɨ̄ɨ pa ŋgwa haʼaŋ Minnwi chuʼɔ nɛ nɔ haʼaŋ a kaŋ njiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pəɨ līi njəɨ, ŋ̀kwo shwei vəɨ ŋkaoŋ ndɨɨ maa ŋkāʼo. ");
INSERT INTO bmo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nɛnnɛ, p̈ugu nchhu ni pəɨ ŋa, ‘Līi njəɨ, a pɔ nɛ moŋ ŋkǔnu njó!’ Kiʼi pəɨ ghə̄ɨ fɔ. Ti p̈ugu nchhu ŋa ‘Līi njəɨ, a pɔ nɛ hɛiŋ moŋ njiɛŋ nda,’ kiʼi pəɨ piŋ. ");
INSERT INTO bmo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nthɛ ŋa wuʼɔ nɔ haʼaŋ fiembɨ ghà nshei llɔ ŋgei shaʼa minaoŋ ŋgə̄ɨ nii ŋgei nii minaoŋ nɛ, a haʼaŋ thɔ nu Muuŋ Ŋoŋmishua shi mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sheshe lɨʼɨ ŋa khu miyaoŋ pɔ nɛ, pa mishi ŋa pugu ghà ŋkru khu miyaoŋ nɛ shi ŋkɨrɨ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pa ŋgəʼɨ pei shi ŋga ntɔgɔ, wuʼɔ chomilaoŋ ghɔ, minaoŋ shi ŋgū njiŋ, paʼa fhú lɔ nuʼuŋ mfɛ líʼɛ, pa fɨ́nəɨ gū llɔ po, Minnwi chɨ̄ʼɨ pa njɨ moŋ tɔthɨ. ");
INSERT INTO bmo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Lì Muuŋ Ŋoŋmishua shi nōoŋ noŋ yi po, nnɛ ŋguoŋ pa laʼataoŋ ŋkuoŋ shhɛ shi njūa, njəɨ Muuŋ Ŋoŋmishua a thɔ nu moŋ lúluŋ po ni ghrɨ́ pugu pa mmɛ ndighaʼo. ");
INSERT INTO bmo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pi shi ntua ntàŋ ŋggì ya ŋkuʼɔ, a taoŋ ghaŋ ntaoŋ pi pugu kɨrɨ pa ŋgwa pi ŋa a chuʼɔ nɛ moŋ ŋguoŋ mbhi moŋ khwɛ ghaa mbhi, llɔ moŋ taʼa ŋgei po ŋgə̄ɨ moŋ yichəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Yɛʼi ntɨ́gɨ llɔ ŋkuoŋ thɨ wùnu: Nɔ haʼaŋ fhɔ̌ yi nuʼuŋ njɛ̄ tua nu ŋkuoŋ mbhɔ yi nɛ, ɔ ji ŋa ŋkwəɨ mbɨ̀ para. ");
INSERT INTO bmo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wuʼɔ nɛnnɛ, ndɨɨ ŋa pəɨ ŋkaa pəɨ yəɨ ŋguoŋ nnu pei nɛ, pəɨ ji ŋa Muuŋ Ŋoŋmishua kwo para ti mbɔ chonda. ");
INSERT INTO bmo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Shishini, ǹshwei vəɨ, mbaʼa ŋgwrɛiŋoŋ yei yiʼi ŋkhu mmɛ ki ŋguoŋ nnu pei lɔ ndɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Po pugu shhɛ shi ntɔgɔ gha, ndɔ mbaʼa pa chrà paŋ yiʼi ntɔgɔ gha. ");
INSERT INTO bmo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ndɔ nɔ llɛ́ ghɔ pugu pa ndɨɨ ghɔ, ŋoŋ lɔ nji, njiʼi nthɛ pi ghaŋ ntaoŋ Minnwi po, ki nduthɔ Muuŋ ni noŋ yi. A wuʼɔ nji Tǎa təʼɨ vi. ");
INSERT INTO bmo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nɔ haʼaŋ a ni mbɔ moŋ pɨɨ ndɨɨ Noa nɛ, a haʼaŋ thɔ nu Muuŋ Ŋoŋmishua shi mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nthɛ ŋa a ni mbɔ ndɨɨ ŋa ŋkhǐ shini ndɔ naa ŋkuʼɔ mfīgi mbhi nɛ, ŋgwa ni njɨ maoŋ ndɔ nnu nu, ndaŋ nu ndɔ mfɛ ŋgwa nda láŋ, ti ŋgə̄ɨ nchəɨŋ ndɨɨ ŋa Noa ni nii moŋ mmɛ pie ŋa a pɔ nɔ nda nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pugu shini ndɔ nji ti ŋkhǐ nuʼuŋ ŋkuʼɔ mfīgi njɨ̄gɨ vugu ŋgə̄ɨ nɔ ghɔ. A haʼaŋ thɔ nu Muuŋ Ŋoŋmishua shi mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Paa ŋgwa shi mbɔ moŋ nyìeŋ, pi lɔ̄gɔ taʼa yi, taʼa yi kɨna. ");
INSERT INTO bmo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Paa piŋgɛ shi nthɔ ŋguʼɔ maoŋ, pi lɔ̄gɔ taʼa yi, taʼa yi kɨna. ");
INSERT INTO bmo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nthɛ yie ghɔ, pəɨ chhɔ ni lɨna məɨ, nthɛ ŋa pəɨ lɔ njiʼi nji llɛ́ yɛ ŋa Taathɔ vəɨ thɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ndɔ p̂əɨ ji yei nnu ŋa, ŋ̈gaŋ nda kaŋ nji ndɨɨ yɛ ŋa ŋgɨna thɔ nu ni tuʼu nɛ, a kaŋ nchhɔ ni lɨna mi, ndɨna nu ni nda yi ŋa kiʼi pi pəʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nthɛ yie ghɔ, pəɨ ŋkaa pəɨ pīri noŋ yəɨ, nthɛ ŋa Muuŋ Ŋoŋmishua thɔ nu moŋ ndɨɨ ŋa mbaʼa pəɨ yiʼi mbīʼi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“A gɔ̌ kiʼɛ mbɔ muuŋ fàʼa taʼanjuʼɔ, mfāʼo shiethɔ ŋa masha vi nūʼɔŋ vi ŋa a lɨna nu ni pichəɨ puoŋ fàʼa moŋ mbaanda yi, mfɛ maoŋ jɨ moŋ ndɨɨ kaʼokaʼo. ");
INSERT INTO bmo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mbɔrɔ shi mbɔ ni muuŋ fàʼa yɛ ŋa masha vi yəɨ vi a fāʼa nu shiʼi ndɨɨ ŋa a thɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Shishini ǹshwei vəɨ, a shi nūʼɔŋ vi a lɨna nu ni ŋguoŋ maoŋ pi. ");
INSERT INTO bmo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ndɔ ti ä mbɔ muuŋ fàʼa mbɨmbhɨ, kaŋ a shi nchhu ni noŋ yi ŋa, ‘Mbaʼa masha a yiʼa ŋkwəɨ,’ ");
INSERT INTO bmo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","njɛ̄ wie nu pichəɨ puoŋ fàʼa, njɨ maoŋ ndɔ nnu nu pugu pa mbaa làʼo. ");
INSERT INTO bmo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Taathɔ muuŋ fàʼa yei shi ŋkwəɨ moŋ llɛ́ yɛ ŋa muuŋ fàʼa ghɔ shini ndɔ mbīʼi nɛ, pugu pa ndɨɨ ŋa a lɔ njiʼi nji nɛ ");
INSERT INTO bmo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","nchrɛi vi kaoŋkaoŋ, mīʼaŋ vi lɨʼɨ ŋa pa ŋgwa mifɨɨ shi ŋgə̄ɨ nɛ. Nɔ lɨʼɨ ghɔ kə̄ɨ pugu pa kru shua shi mbɔ fɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nnɛ Shaʼafuoŋ Po shi mbɔ nɔ wuŋ puoŋ piŋgɛ ŋa pugu lɔ naa nji mimbia, ŋa pugu ni ndɔ̄gɔ pa laŋ pugu ŋgə̄ɨ lɨʼɨ para mimbia láŋ. ");
INSERT INTO bmo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yi tiɛŋ ni mbɔ pa na, yi tiɛŋ pɔ pa ndɨna. ");
INSERT INTO bmo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pɛ ŋa pugu ni mbɔ pa na nɛ ni ŋga ndɔ̄gɔ laŋ yugu paʼa ndɔ ntuo yichəɨ krashi, ");
INSERT INTO bmo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ndɔ pɛ ŋa pugu ni ndɨna nɛ lɔ̄gɔ tuʼɔ krashi yugu pugu pa laŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nɔ haʼaŋ mimbia ŋgaŋ láŋ ghɔ ni nthɔ njiyiri nɛ, lɔ̄gɔ wɛ̄iŋ vugu pugu llɛ. ");
INSERT INTO bmo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ndɔ a gha mbɔ moŋ ntuŋ mbhi pi paʼo ŋgòu ŋa, ‘Mimbia ŋgaŋ láŋ ghɔ pɔ nɛiŋ! Pəɨ taoŋ nthɔ mbara vi.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Wuŋ puoŋ piŋgɛ pighɔ lɔllɔ mbīri laŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pɛ ŋa pugu ni mbɔ pa na nɛ chhu ni pɛ ŋa pugu ni mbɔ pa ndɨna nɛ ŋa, ‘Pəɨ fɛ yichəɨ krashi yəɨ ni pigi nthɛ ŋa laŋ yigi thɔ mbɛphɛ.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ndɔ pa pi shiethɔ pighɔ khwɛ̄ ŋa, ‘Ŋa minthɛ paʼa yɛ ŋa pigi fāʼo nɛ lɔ ŋkāʼo ni pia nɛ, pəɨ ghə̄ɨ moŋ nda taŋ njuoŋ yəɨ fɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ndɨɨ ŋa pugu ni ŋgə̄ɨ lɨʼɨ yuoŋ nɛ, mimbia láŋ ghɔ thɔ, pɛ tiɛŋ piŋgɛ ŋa pugu ni mbīri noŋ yugu mbɔ fɔ nɛ ghə̄ɨ pugu pa mimbia ŋgaŋ láŋ ghɔ lɨʼɨ jɨ láŋ, pi fɨ̄nɨ nda. ");
INSERT INTO bmo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","A gha ndara pichəɨ nchǔʼɔ mbɨnɨ pighɔ thɔ ŋkaa pugu, nchhu nu ŋa, ‘Taathɔ, taathɔ, chuʼɔ nda ni pigi.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ndɔ a khwɛ̄ ŋa, ‘Shishini ǹshwei vəɨ, ǹdɔ njiʼi nji vəɨ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jishɔ lūgwi ŋa, “Nthɛ yie ghɔ, pəɨ chhɔ ni lɨna məɨ, nthɛ ŋa pəɨ lɔ nji llɛ́ ki ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ndɨɨ ghɔ, Shaʼafuoŋ Po shi ma mbɔ pi nɔ ŋoŋ ŋa a tāʼa nu ŋgə̄ɨ kra, nnɛ mɛ̄iŋ pa puoŋ fàʼa mfɛ maoŋ pi ni pugu ŋa pugu tiʼi nchhɔ ndɨna nu nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A ni mfɛ tiɛŋ pìɛŋ mbɨŋ ni taʼa yi. Taʼa pìɛŋ pɔ fɨʼɨ mbɨŋ ŋa ŋ̈oŋ mfaʼa nɔ paa wuŋ ŋgaʼombhi, pi pe vi nɔ ghɔ nɛ, ni vichəɨ, a fɛ paa pìɛŋ mbɨŋ, ni vichəɨ a fɛ taʼa pìɛŋ mbɨŋ. A ni mfɛ mbɨŋ ni shesheŋoŋ vugu nɔ fɨʼɨ njɨ yi ndɔllɔ kiʼɛ ŋgə̄ɨ kra yi. ");
INSERT INTO bmo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Chomilaoŋ ghɔ, yɛ ŋoŋ ŋa a ni ŋkwe tiɛŋ pìɛŋ mbɨŋ nɛ ghə̄ɨ ni ji mbɨŋ mbiʼɛ taŋ nɔ ghɔ nshei tiɛŋ pìɛŋ mbɨŋ mbīgi. ");
INSERT INTO bmo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wuʼɔ nɛnnɛ, yɛ ŋoŋ ŋa ji mbɨŋ ni mbɔ paa pìɛŋ nɛ shei paa pìɛŋ mbɨŋ mbīgi. ");
INSERT INTO bmo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ndɔ yɛ ŋoŋ ŋa ji mbɨŋ ni mbɔ taʼa pìɛŋ nɛ ghə̄ɨ ntou tiɛŋ ndə̄ɨŋ mbɨŋ taathɔ yi moŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“A ni ŋga ndaʼa nɔ ntaaŋ ndɨɨ, taathɔ pa puoŋ fàʼa pighɔ pɨnɨ, pugu pugu pīʼi ŋkrù yi. ");
INSERT INTO bmo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yɛ ŋoŋ ŋa a ni mfɛ tiɛŋ pìɛŋ mbɨŋ ghɔ nɛ thɔ njəɨ taathɔ vi ni tiɛŋ pìɛŋ mbɨŋ nduoŋ mbīgi, nchhu nu ŋa, ‘Taathɔ, ɔ ni mfɛ tiɛŋ pìɛŋ mbɨŋ vəɨ. Njəɨ, m̀bɨnɨ nuʼuŋ nshei tiɛŋ pìɛŋ mbīgi.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Taathɔ vi chhu ghɔ ŋa, ‘Ɔ ya mfāʼa, ma muuŋ fàʼa shishiʼi ndɔ mbɔ muuŋ fàʼa taʼanjuʼɔ. Ɔ tɔgɔ ndaoŋ ntou ni shɨgɛi yaoŋ, ǹshi mfɛ ntou yi vɛ ɔ lɨna nɔ ghɔ, thɔ pɔgɔ fāʼo pwanjuʼɔ kaʼa!’ ");
INSERT INTO bmo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Vɛ ŋkaa yu ŋa pi ni mfɛ paa pìɛŋ mbɨŋ ghɔ nɛ thɔ nchhu ŋa, ‘Taathɔ, ɔ ni mfɛ paa pìɛŋ mbɨŋ vəɨ. M̀bɨnɨ nuʼuŋ nshei paa pìɛŋ mbɨŋ mbīgi.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Taathɔ yi chhu ghɔ ŋa, ‘Ɔ ya mfāʼa, ma muuŋ fàʼa shishiʼi ndɔ mbɔ muuŋ fàʼa taʼanjuʼɔ. Ɔ tɔgɔ ndaoŋ ntou ni shɨgɛi yaoŋ, shi mfɛ ntou yi vɛ ɔ lɨna nɔ ghɔ, thɔ pɔgɔ fāʼo pwanjuʼɔ kaʼa.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Yɛ ŋkaa yu ŋa pi ni mfɛ taʼa pìɛŋ mbɨŋ ghɔ nɛ thɔ nchhu ŋa, ‘Taathɔ, ǹji ghɔ ŋa ɔ ŋoŋ tɨtɨnɨ, ŋkwōo nu lɨʼɨ haʼaŋ ɔ shini ndɔ njiʼi mbhi, ŋkɨrɨ nu lɨʼɨ haʼaŋ ɔ shini ndɔ njiʼi māʼaŋ kaŋ taʼa mbhɛ̌. ");
INSERT INTO bmo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ŋki mfāʼo pɔgɔ gu ŋgə̄ɨ ndə̄ɨŋ mbɨŋ yɔ moŋ shhɛ. Njəɨ, yaoŋ yɔ pɔ nɛiŋ.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ndɔ taathɔ yi khwɛ̄ nchhu ghɔ ŋa, ‘Muuŋ fàʼa mbɨmbhɨ, muuŋ fàʼa lɨʼəlɨʼə, ɔ ni nji ŋa ŋga ŋkwōo lɨʼɨ haʼaŋ ǹshini ndɔ njiʼi mbhi nɛ, ŋkɨrɨ lɨʼɨ haʼaŋ ǹshini ndɔ njiʼi māʼaŋ mbhɛ̌ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nɛnnɛ, ɔ ni mfāʼo nɔ niʼiŋ nu mbɨŋ a moŋ bəɨŋ, ŋ̀ga mbɨnɨ ŋ̀kwe mbɨŋ a pugu pa thɔ yi. ");
INSERT INTO bmo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nthɛ yie ghɔ, pəɨ kwe mbɨŋ ghɔ mbhɔ yu mfɛ ni ŋoŋ ŋa a ni mfāʼo wuŋ pìɛŋ mbɨŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nthɛ ŋa shesheŋoŋ ŋa a kwo fāʼo nɛ, pi shi mbīgi ntou yi ghɔ nji ŋa a shi mfāʼo a ya njiɛŋ ti ŋgaʼa, ndɔ ni ŋoŋ ŋa a lɔ njiʼi mfāʼo nɛ, njiʼi nthɛ pi shɨgɛi yɛ ŋa a pɔ mbhɔ yu nɛ, pi shi ŋkwe. ");
INSERT INTO bmo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pəɨ māʼaŋ muuŋ fàʼa ghagha yinɛ mbhi moŋ njiŋnjiŋ, moŋ lɨʼɨ ghɔ, kə̄ɨ pugu pa kru shua shi mbɔ fɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ndɨɨ ŋa Muuŋ Ŋoŋmishua shi nthɔ moŋ ndighaʼo yi, pugu pa ŋguoŋ pa ghaŋ ntaoŋ Minnwi po, kaŋ a shi nchhɔ kiʼɛ ŋkuoŋ faaŋ ndighaʼo yi. ");
INSERT INTO bmo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ŋguoŋ pa laʼataoŋ ghao shi ŋkɨrɨ shhɨ yu, a shɛrɛ vugu pugu taoŋ lɨʼɨ yi paa, wuʼɔ nɔ haʼaŋ ŋkɛ̄ʼi pa minjɨɨ ghà shɛrɛ pa minjɨɨ mfuʼu shɨna pa mimbhi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A shi nūʼɔŋ pa minjɨɨ ŋgei mbhɔ yi yi jɨ, pa mimbhi pɔ yugu ŋgei mbhɔ ŋkwrɛi. ");
INSERT INTO bmo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Nnɛ fùoŋ ghɔ shi nchhu ni pɛ ŋgwa ŋa pugu pɔ ŋgei mbhɔ jɨ nɛ ŋa, ‘Pəɨ ŋa mbɔrɔ Tǎa a pɔ mbɨŋ pəɨ nɛ thɔ, pəɨ shi nshei Shaʼafuoŋ ŋa pi ni mbīri ni pəɨ moŋ njɛ̄ mbhi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nthɛ ŋa njì ni njia a, pəɨ fɛ maoŋ jɨ vəɨ, njùʼɔ a yaoŋ pəɨ fɛ yaoŋ nnu vəɨ, ŋki pɔ ŋgɨ̀nɨ, pəɨ chuʼɔ chonda vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ŋki pɔ ntii, pəɨ gwɛ ndhwí mbɨŋ mu, ŋki ghɨ̌nɔ nu, pəɨ kra a, ŋki pɔ moŋ chə́ɨŋ, pəɨ thɔ njəɨ a.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Pa ŋgwa ndɨndɨ shi khwɛ̄ ghɔ ŋa, ‘Taathɔ, pigi ni njəɨ ghɔ pi yəɨ ndɨɨ nji yia ghɔ pigi fɛ maoŋ jɨ vɛ, ki njùʼɔ yɔ yaoŋ pigi fɛ yaoŋ nnu vɛ? ");
INSERT INTO bmo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndɔ pigi ni njəɨ ghɔ pi yəɨ ndɨɨ ɔ pɔ ŋgɨ̀nɨ pigi chuʼɔ nda yigi ŋa ɔ nii fɔ, ki ɔ pɔ ntii pigi māʼaŋ ndhwí mbɨŋ ghɔ? ");
INSERT INTO bmo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pigi ni njəɨ ghɔ pi yəɨ ndɨɨ ɔ ghɨ̌nɔ nu ki mbɔ moŋ chə́ɨŋ pigi thɔ ŋkra ghɔ?’ ");
INSERT INTO bmo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Fùoŋ ghɔ shi ŋkwe nchhu ni pugu ŋa, ‘Shishini, ǹshwei vəɨ, nɔ haʼaŋ pəɨ ni nchwīe nnɛ ni taʼa miŋkwasha shɨna pa lǐŋ paŋ pei nɛ, pəɨ ni nchwīe pi vəɨ!’ ");
INSERT INTO bmo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nnɛ a shi nchhu ni pɛ ŋa pugu pɔ ŋgei mbhɔ yi yi ŋkwrɛi nɛ ŋa, ‘Pəɨ lɔllɔ yəɨ mu, pəɨ ŋa nchɔ̀nɔ Minnwi pɔ mbɨŋ pəɨ nɛ, ŋgə̄ɨ moŋ móŋoŋ ki ndugwi yi ŋa pi ni mbīri ni Devɨ pugu pa ghaŋ ntaoŋ pi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nthɛ ŋa njì ni njia a paʼa pəɨ lɔ mfɛ maoŋ jɨ vəɨ, njùʼɔ a ni njaoŋ paʼa pəɨ lɔ mfɛ yaoŋ vəɨ ŋa ǹnu, ");
INSERT INTO bmo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ŋki pɔ ŋgɨ̀nɨ paʼa pəɨ lɔ nchuʼɔ chonda yəɨ vəɨ ŋa ǹii fɔ, ŋki pɔ ntii paʼa pəɨ lɔ māʼaŋ ndhwí mbɨŋ mu, ŋgɨ̄nɔ ndɔ mbɨnɨ mbɔ moŋ chə́ɨŋ paʼa pəɨ lɔ njiʼi ŋkra a.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Pugu ŋkaa pugu shi ŋkhwɛ̄ ŋa, ‘Taathɔ, pigi ni njəɨ ghɔ pi ndɨɨ khɔ nji yia ghɔ, ki njùʼɔ yɔ yaoŋ, ki ɔ pɔ ŋgɨ̀nɨ, ki ɔ pɔ ntii, ki ŋgɨ̄nɔ nu ki mbɔ moŋ chə́ɨŋ ki pigi lɔ ŋgɛ̄rɛ ghɔ?’ ");
INSERT INTO bmo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Nnɛ a shi ŋkhwɛ̄ ni pugu ŋa, ‘Shishini, ǹchhu ni pəɨ ŋa nɔ haʼaŋ pəɨ shini ndɔ nchwīe nɛnnɛ ni miŋkwasha shɨna ŋgwa pei nɛ, pəɨ shini ndɔ njiʼi nchwīe vəɨ.’ ");
INSERT INTO bmo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Nnɛ pi shi mfɛ pei moŋ ŋgəʼɨ ki mmɛ ndɔ pa ŋgwa ndɨndɨ, pi fɛ vugu moŋ chɔmbhi ki mmɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jishɔ ni ŋga mīʼɛŋ yɛʼi nu ŋguoŋ pa nnu pei, nchhu ni pa ghaŋ younjiŋ pi ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Pəɨ ji ŋa paa llɛ́ shi ŋga ntɔgɔ, a pɔ Jɨ *Lli Njiʼa, ndɔ pi shi nchaʼa Muuŋ Ŋoŋmishua mfɛ ŋa pi kwīŋ vi ŋkuoŋ wáʼa.” ");
INSERT INTO bmo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nnɛ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa thishɨ pa ŋgwa Juu paoŋ ntuʼɔ Kaifa, mbɔ *taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, ");
INSERT INTO bmo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ntáŋ nɔ wɛ̄iŋ nu Jishɔ njiŋnjiŋ ki ŋgwa lɔ nji ndɔ njwi vi. ");
INSERT INTO bmo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ndɔ pugu ni nchhu nu ŋa, “Kiʼi a pɔ pi ndɨɨ Jɨ Lli Njiʼa, kiɛŋ nnɛ kaŋ ŋgwa shi nsha mighei.” ");
INSERT INTO bmo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jishɔ ni ŋga mbɔ Betani nda Shemu mbɔ ŋgaŋ ghɨnɔmbaluŋ, ");
INSERT INTO bmo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nɔ haʼaŋ Jishɔ ni njɨ maoŋ ŋkuoŋ taprɛi fɔ nɛ, miŋgwɛ chəɨ thɔ njəɨ vi ni yichəɨ nchɨ́ŋ ŋa pi chwīe ni ŋgùʼɔ, laminda tɨnɨnchuoŋ lɨnaoŋ moŋ ghɔ, a shāʼo thɔ Jishɔ nɔ pɔrɔ nu vi nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ndɔ pa ghaŋ younjiŋ pi ni mbɨgɨ túa ndɨɨ ŋa pugu ni njəɨ nnu yei nɛ, nnɛ nchhu ŋa, “Láʼo yei phɛ pɔ pi ŋa? ");
INSERT INTO bmo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nthɛ ŋa a ka ni mfɛ pi fīni laminda yei ni ŋkiɛŋ ntou mbɨŋ ŋgɛ̄rɛ pa ghaŋ pou nɔ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ndɔ Jishɔ ji nnu ŋa pugu chhu nu nɛ, nnɛ, nchhu ni pugu ŋa, “Pəɨ ghana miŋgwɛ vi nɛ ŋa? A chwīe pi nnu shiʼi vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nthɛ ŋa pəɨ ghà ŋguʼɔ mfāʼo pa ghaŋ pou ŋguoŋ ndɨɨ, ndɔ mbaʼa pəɨ yiʼi mfāʼo a ŋguoŋ ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A shāʼo laminda yei mbɨŋ mu nɔ pīri nu noŋ a nɔ twei nu. ");
INSERT INTO bmo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Shishini, ǹchhu ni pəɨ ŋa sheshe lɨʼɨ ŋa pi shi nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ yei moŋ ŋguoŋ mbhi nɛ, nnu ŋa miŋgwɛ vei chwīe nɛ, pi shi nchhu nɔ kwiŋ nu vi.” ");
INSERT INTO bmo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Taʼa ŋoŋ shɨna paanchrɔ pa ghaŋ younjiŋ Jishɔ mbɔ Judashi Ishikario ghə̄ɨ njəɨ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, ");
INSERT INTO bmo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nchhu ni pugu ŋa, “Pəɨ shi mfɛ pi khɔ vəɨ nɔ haʼaŋ mi mfīni vi ni pəɨ?” Nnɛ pugu pe vi ni trɛi wuŋ ndigi mbɨŋ. ");
INSERT INTO bmo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Llɔ ndɨɨ ghɔ ŋgə̄ɨ nu shhɨ a taʼa shɨna nɔ fīni nu vi. ");
INSERT INTO bmo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A ni mbɔ fǔoŋ llɛ́ jɨ Jɨ Brɛi Ki Kuʼɔ, pa ghaŋ younjiŋ Jishɔ thɔ njəɨ vi, nchhu nu ghɔ ŋa, “Ɔ tāʼa nu ŋa pigi pīri maoŋ jɨ Lli Njiʼa vɛ pi hɨŋ?” ");
INSERT INTO bmo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A chhu ni pugu ŋa, “Pəɨ nii moŋ laʼa, nchhu ni ŋoŋ chəɨ ŋa pəɨ shi njəɨ vi nɛ ŋa, ‘Masha chhu ŋa ndɨɨ a kwo para, ǹshi njɨ Lli Njiʼa nda ghɔ pigi pa ghaŋ younjiŋ paŋ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pa ghaŋ younjiŋ pi chwīe wuʼɔ nɔ haʼaŋ Jishɔ ni nchhu ni pugu nɛ, mbīri maoŋ jɨ Lli Njiʼa ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A ni ŋga mbɔ ni fanaoŋ, a chɔchɔ yəɨ taprɛi nthɔ njɨ maoŋ pugu pa paanchrɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nɔ haʼaŋ pugu ni njɨ nu nɛ, Jishɔ chhu ŋa, “Shishini, ǹshwei vəɨ, taʼa ŋoŋ shɨna pəɨ shi mfīni a.” ");
INSERT INTO bmo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nnu ghɔ wīni vugu ŋkiɛŋ ntou yi, pugu jɛ̄ nchhu nu ghɔ pa taʼa yi taʼa yi ŋa, “Taathɔ, ŋa a lɔ mbɔ mmu?” ");
INSERT INTO bmo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A khwɛ̄ ŋa, “Ŋoŋ ŋa mbhɔ yigi yu shi mbāoŋ moŋ pɛiŋ nɛ, a ju ŋa a shi mfīni a nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Muuŋ Ŋoŋmishua shi ŋguʼɔ ŋgə̄ɨ pi nɔ haʼaŋ pi nāʼaŋ nthɛ vi nɛ, ndɔ ŋgəʼɨ shi ŋgwɛ̄iŋ ŋoŋ vɛ ŋa a fīni vi nɛ. A ni mbwa ghɔ ŋa kiʼi pi phi vi.” ");
INSERT INTO bmo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judashi, ŋa a ni mfīni vi nɛ, chhu ŋa, “Masha, ŋa a lɔ mbɔ mmu?” Jishɔ chhu ŋa, “A chhu gɔ̀ ni noŋ yɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nɔ haʼaŋ pugu ni nchhɔ njɨ nu nɛ, Jishɔ lɔ̄gɔ brɛi, ŋga ŋkwo tōo Minnwi, mbəʼɨ mfɛ ni pa ghaŋ younjiŋ pi, nchhu ŋa, “Pəɨ kwe ŋkru, yei frɛinoŋ a.” ");
INSERT INTO bmo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A lɔ̄gɔ ndua, ŋga ŋkwo tōo Minnwi mfɛ ni pugu, nchhu nu ŋa, “Ŋguoŋ yəɨ ghao nnu. ");
INSERT INTO bmo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nthɛ ŋa làʼo yei chhǐ a ŋa a krao *kɨ̀na yɛ ŋa Minnwi wrā pugu pɔ ŋgwa pi nɛ, ŋa a ni ŋkwrī nthɛ ntou ŋgwa nɔ līʼɛ nu pa phɨ. ");
INSERT INTO bmo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ndɔ ǹshwei vəɨ ŋa m̀baʼa nuʼuŋ nnu làʼo yei pia, ti ŋgə̄ɨ nchəɨŋ ndɨɨ ŋa ǹshi mbɨnɨ nnu pia kaʼa fifhi moŋ Shaʼafuoŋ Tǎa a nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pugu gha njrāo taʼa ŋkhǐ ntaoŋ kəʼɨ ghɔ ŋkuʼɔ ŋkuoŋ Mbra pa Thɨ Olive. ");
INSERT INTO bmo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nnɛ Jishɔ chhu ni pugu ŋa, “Ni tuʼu yei, pəɨ shi ntei mieŋ a nthɛ ŋa pi nāʼaŋ ŋa, ‘Ǹshi njwi ŋkɛ̄ʼi minjɨɨ, pa minjɨɨ sha.’ ");
INSERT INTO bmo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ndɔ pi shi ŋga ŋkwo kuʼɔ ni mmu moŋ gu, ŋ̀gə̄ɨ shhɨ pəɨ Galili.” ");
INSERT INTO bmo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ndɔ Pita chhu ŋa, “Njiʼi nthɛ pi nɔ haʼaŋ pi shi ntei njiŋ yɔ ghao nɛ, m̀baʼa njiʼi ntei.” ");
INSERT INTO bmo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jishɔ chhu ghɔ ŋa, “Shishini ǹshwei ghɔ ŋa ni tuʼu yei ŋkaoŋ miŋkəʼɨ maa ŋkhwɛ, ɔ shi ŋkwo lāa a ni trɛi ŋgɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita chhu ghɔ ŋa, “Ä njiʼi mbɔ pi ŋa pɔgɔ khu kaʼa, paʼa ǹdɔ ndāa ghɔ.” Ŋguoŋ pichəɨ pa ghaŋ younjiŋ pi wuʼɔ nchhu pi nnɛ. ");
INSERT INTO bmo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jishɔ lɔllɔ ŋgə̄ɨ pugu pugu lɨʼɨ chəɨ ŋa pi mɛ̄iŋ ni Geshemani, nchhu ni ghaŋ younjiŋ pi ŋa, “Pəɨ chɔchɔ hɛiŋ ŋgə̄ɨ hiŋ nduoŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A lɔ̄gɔ Pita pugu pa paa puoŋ Shebedi, njɛ̄ nthɔ mfāʼo yuʼɔ njùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nnɛ, a chhu ni pugu ŋa, “Njùʼɔ a ya mbəʼɨ ti minthɛ ŋka kukhu, pəɨ kɨna hɛiŋ pia yra nu kaʼa.” ");
INSERT INTO bmo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A chənə ŋgə̄ɨ shɨgɛi yi shhɨ, mfūŋ thɔ yi shhɛ nduoŋ Minnwi, nchhu nu ŋa, “Tǎa a, ä njiʼɛ, ɔ pəɨ ndua ŋgəʼɨ yei vəɨ, ndɔ kiʼi a pɔ pi nɔ haʼaŋ ǹtāʼa nu nɛ, a pɔ pi nɔ haʼaŋ ɔ tāʼa nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A gha nthɔ, njəɨ pa ghaŋ younjiŋ pi pugu thɔ ndɛllɛ. A chhu ni Pita ŋa, “Nnɛ minthɛ paʼa pəɨ lɔ nchhɔ tɔthɨ pia kaʼa nɔ taʼa awa? ");
INSERT INTO bmo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pəɨ chhɔ tɔthɨ nduoŋ Minnwi nnɛ ŋa kiʼi pəɨ gū moŋ mōoŋ nu. Jijwɛ yəɨ khwā nu, ndɔ frɛinoŋ yəɨ pou ghrɨ́.” ");
INSERT INTO bmo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nɔ mbra ŋgɛ, a pɨnɨ ŋgə̄ɨ nduoŋ Minnwi, nchhu nu ŋa, “Tǎa a, ä mbɔ ŋa minthɛ paʼa ndua ŋgəʼɨ yei lɔ tɔgɔ ki ǹdɔ njiʼi nnu, a pɔ nɛ nɔ haʼaŋ ɔ tāʼa nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jishɔ pɨ̄nɨ ŋkamuʼɔŋ njəɨ vugu pugu llɛ nu, nthɛ ŋa lɔ̄gɔ ni ndɨnaoŋ ligi pugu. ");
INSERT INTO bmo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A pɨnɨ nuʼuŋ mieŋ vugu ŋgə̄ɨ nduoŋ Minnwi, a pɔ trɛi ŋgɛ, ŋguʼɔ nchhu pi taʼa nnu ghɔ ŋa a ni ŋkwo fǔoŋ nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nnɛ a thɔ njəɨ pa ghaŋ younjiŋ pi nchhu ni pugu ŋa, “Pəɨ wuʼɔ nchhɔ ndhɛ nu mfɛrɛ noŋ yəɨ? Njəɨ, ndɨɨ kāʼo nɛ, pi fīni Muuŋ Ŋoŋmishua nɛ ni pa ghaŋ phɨ. ");
INSERT INTO bmo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pəɨ lɔllɔ pia ghə̄ɨ. Pəɨ līi njəɨ, ŋoŋ ŋa a fīni a nɛ pɔ nɛiŋ!” ");
INSERT INTO bmo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jishɔ ni ŋga ŋguʼɔ nchrā nu, Judashi, mbɔ taʼa ŋoŋ shɨna paanchrɔ ghaŋ younjiŋ pi chəɨŋ pugu pa ntou yú ŋgwa, pugu tuo pa kafa pugu pa wrɛ́i, llɔ mbhɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pichəɨ pa thishɨ pa ŋgwa moŋ laʼa. ");
INSERT INTO bmo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ŋoŋ ŋa a ni mfīni vi nɛ ni ŋkwo fɛ lì ni pugu, nchhu nu ŋa, “Ŋoŋ ŋa nshi mbaŋ vi nɛ, ju, pəɨ wɛ̄iŋ vi.” ");
INSERT INTO bmo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judashi kuʼɔ nthɔ mbara Jishɔ nchhu ghɔ ŋa, “Ǹchrā vɛ, ma Masha,” mbaŋ vi nɔ chrā nu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jishɔ chhu ghɔ ŋa, “Taannu a, chwīe yaoŋ ŋa ɔ ni nthɔ nɔ chwīe nu nɛ.” Nnɛ ŋgwa pighɔ thɔ ŋgwɛ̄iŋ Jishɔ nshūu vi ŋgə̄ɨ nɔ. ");
INSERT INTO bmo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ŋga njəɨ nu nɛ, yichəɨ taʼa ŋoŋ ŋa pugu pa Jishɔ ni mbɔ nu nɛ shua kafa ŋkəʼɨ muuŋ fàʼa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ nɔ ghɔ njaʼa tə́nə yi. ");
INSERT INTO bmo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jishɔ chhu ghɔ ŋa, “Pɨnɨ niʼiŋ kafa yɔ lɨʼɨ ŋa ɔ fuʼu nɛ. Ghaŋ wie ŋkrɔ̀ ndɔ njwi ŋgwa ni kafa ghà ŋguʼɔ ŋkhu ntɔgɔ pi ŋkuoŋ kafa. ");
INSERT INTO bmo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ki ɔ pīʼi ŋa minthɛ paʼa ndɔ ǹjūa ni Tǎa a ŋa a ghɛ̄rɛ a, a wuʼɔ ntaoŋ pa ghaŋ ntaoŋ po ŋa pugu ghà māʼaŋ nchhɔ̀ nɛ pugu tɔgɔ khwachəɨ wuŋ ŋkaŋ yugu ni ŋkaŋ yi paa wuʼɔ chomilaoŋ ghɔ? ");
INSERT INTO bmo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ndɔ ä mbɔ nɛnnɛ kiʼɛ, nnu ŋa Ŋwaʼaŋlɨ Minnwi chhu nɛ shi ŋkie pi nɛiŋ ndɔ̄gɔ lɨʼɨ, ŋa a yiʼi ŋa a wuʼɔ mbɔ pi nɛnnɛ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Moŋ ndɨɨ ghɔ Jishɔ chhu ni yú ŋgwa pighɔ ŋa, “M̀bɔ pi ŋgɨna minwi ŋa pəɨ thɔ nu ŋgwɛ̄iŋ a ni pa kafa pugu pa wrɛ́i? Pa lɛllɛ ŋga nchhɔ Nda Minnwi njɛʼi nu paʼa pəɨ lɔ ŋgwɛ̄iŋ a. ");
INSERT INTO bmo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ndɔ ŋguoŋ pa nnu pei lɔ̄gɔ lɨʼɨ nnɛ nɔ chwīe nu nnu ŋa pa njəɨlɨʼɨ Minnwi ni nāʼaŋ nɛ lɔ̄gɔ lɨʼɨ.” Nnɛ ŋguoŋ pa ghaŋ younjiŋ pi mieŋ vi ntei ni vugu. ");
INSERT INTO bmo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ŋgwa pɛ ŋa pugu ni ŋgwɛ̄iŋ Jishɔ nɛ lɔ̄gɔ vi ŋgə̄ɨ nɔ shhɨ Kaifa, mbɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, mbɔ lɨʼɨ ŋa pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa pichəɨ pa thishɨ ni ŋkɨrɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita ni thɔ nu njiŋ pugu ndɔ mbɔ pi fie hiŋ, mbɔ nɔ haʼaŋ yɨna taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ni mbɔ nɛ nii nchɔchhɔ pugu pa ghaŋ kɛ̄ʼi lɨʼɨ nɔ yəɨ nu nnu ŋa a shi ndɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋguoŋ pa kúŋ ghao ni nthɔ ntāʼa lɛʼiŋgiɛŋ ŋa minthɛ pugu shwiʼi thɔ Jishɔ nnɛ ŋa pugu jwi vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ndɔ pugu shini ndɔ fāʼo sheshe yi, njiʼi nthɛ pi nɔ haʼaŋ ntou pa ghaŋ piŋ nnu mbe ni ntaoŋ nthɔ nɛ. Ndugwi yi, yi paa taoŋ nthɔ shhɨ ");
INSERT INTO bmo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nchhu ŋa, “Ŋoŋ vei ni nchhu ŋa, ‘Mfāʼo ghrɨ́ nɔ shaʼa nu Nda Minnwi mfɛ shhɛ mbɨnɨ ŋkrao moŋ trɛi llɛ́.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ndɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ lɔllɔ ntithi tɔthɨ nchhu ŋa, “Ɔ lɔ mfāʼo khwɛ̀ nɔ fɛ nu? Nnu ŋa ŋgwa pei wɛ̄iŋ ghɔ ŋa ɔ chwīe nɛ pɔ pi khɔ?” ");
INSERT INTO bmo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ndɔ paʼa Jishɔ lɔ nchrā. Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ chhu ghɔ ŋa, “M̀fɛ gɨ́ vɛ nɔ ligi Minnwi maoŋ ŋa ɔ shwei vigi ŋa ɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe mbɔ Muuŋ Minnwi nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jishɔ chhu ghɔ ŋa, “Ɔ chhu nɛnnɛ. Ndɔ ǹshwei ghɔ, llɔ ndwɛ ŋgə̄ɨ nu shhɨ, pəɨ shi njəɨ Muuŋ Ŋoŋmishua a chhɔ ŋgei mbhɔ jɨ ju ŋa a fāʼo ghrɨ́ nɔ chwīe nu sheshe nnu nɛ, ndɔ nshwiʼi nu moŋ lúluŋ llɔ po.” ");
INSERT INTO bmo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ni ŋga njaʼo yei, nshāa ndhwí yi nchhu ŋa, “A chɨ̄ʼə ligi Minnwi. Pia nuʼuŋ ntāʼa pa miŋkwentie mbīgi nchwīe khɔ nɔ ndwɛ? Līi njəɨ, pəɨ yaʼo chrà nchɨʼəshə yei ni noŋ yəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Pəɨ pīʼi yəɨ ŋa?” Pugu khwɛ̄ ŋa, “A pie ŋa a khu.” ");
INSERT INTO bmo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nnɛ pugu thu thwɛ nɔ ligi yi ndɔ ŋgwie vi, pichəɨ chrə̄ɨ vi ni lrì ");
INSERT INTO bmo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nchhu ŋa, “Gɔ̀ ŋa pi Chuʼɔ ghɔ Ntaoŋ nɔ Ŋkwe nɛ, yəɨ nɛ lɨʼɨ nshwei vigi, ŋoŋ ŋa a chhwi ghɔ nɛ gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ni nchhɔ mbhi moŋ yɨna, muuŋ fàʼa chəɨ, mbɔ miŋgwɛ, thɔ njəɨ vi nchhu ghɔ ŋa, “Gɔgɔ ŋkaa ghɔ ni mbɔ pəɨ Jishɔ ŋoŋ Galili.” ");
INSERT INTO bmo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ndɔ Pita lāa shhɨ pugu ghao, nchhu nu ŋa, “Ǹdɔ njiʼi nji njiŋ nnu ŋa ɔ chhu nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A gha nchəɨŋ cho yɨna, yichəɨ muuŋ fàʼa mbɔ miŋgwɛ yəɨ vi nchhu ni ŋgwa pɛ ŋa pugu ni nthi fɔ nɛ ŋa, “Ŋoŋ vei ni mbɔ pugu Jishɔ llɔ Nasharɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A pɨnɨ nuʼuŋ ndāa ti nshwrɛ̄i ŋa, “Ndɔ nji ŋoŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A gha ndara shɨgɛi, ŋgwa haʼaŋ pugu ni nthi fɔ nɛ kuʼɔ mbara Pita nchhu ghɔ ŋa, “Shishini, ɔ taʼa pakwo pugu, nthɛ ŋa ŋkwaŋ haʼaŋ ɔ chrā nu nɛ fīni ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nnɛ a jɛ̄ chɔ̄nɔ nu noŋ yi nshwrɛ̄i nu ŋa, “Ndɔ njiʼi nji ŋoŋ ghɔ.” Ndɔ chomilaoŋ ghɔ miŋkəʼɨ khwɛ. ");
INSERT INTO bmo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nnɛ Pita kwiŋ nnu ŋa Jishɔ ni nchhu nɛ ŋa, “Ŋkaoŋ miŋkəʼɨ ma ŋkhwɛ, ɔ shi ndāa a ni trɛi ŋgɛ.” Ǹtaoŋ mbhi ŋkə̄ɨ a ghaʼa. ");
INSERT INTO bmo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A ni ŋga mbɔ ni muuŋ tutuʼu, ŋguoŋ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa thishɨ pa ŋgwa Juu nyiaŋ ŋkwaŋ haʼaŋ pugu shi njwi Jishɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pugu krao vi, ŋgə̄ɨ ni ju nchaʼa mfɛ ni Pailɛ, mbɔ ŋgaŋ shaʼa ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nnɛ ndɨɨ ŋa Judashi, ŋa a ni mfīni Jishɔ nɛ, ni njəɨ ŋa pi fɛ njɔ́ gu ni Jishɔ nɛ, a kwri njùʼɔ yi mbɨnɨ nduʼu trɛi wuŋ ndigi mbɨŋ pighɔ ni pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pichəɨ thishɨ, ");
INSERT INTO bmo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nchhu nu ŋa, “Ǹchwīe phɨ nɔ fīni nu ŋoŋ ŋa mbhɔ yi yi wo nɛ pi jwi vi.” Ndɔ pugu chhu ŋa, “Yinɛ pɔ pi khɔ ni pigi? Yinɛ yəɨ pi gɔ̀!” ");
INSERT INTO bmo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judashi māʼaŋ mbɨŋ ghɔ moŋ Nda Minnwi ndɔllɔ ŋgə̄ɨ ŋkrə̄ɨ noŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ndɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ lɔ̄gɔ mbɨŋ ghɔ nchhu ŋa, “Gɨ́ lɔ njiʼi mbiŋ ŋa pia niʼiŋ moŋ lɨʼɨ nūʼɔŋ mbɨŋ Nda Minnwi nthɛ ŋa a pɔ pi mbɨŋ chhǐ.” ");
INSERT INTO bmo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nnɛ pugu pini, njuoŋ lɨʼɨ shhɛ ŋa pi mɛ̄iŋ ni shhɛ ŋgaŋ puoŋ pa kɨ̌ŋ, ndɔ̄gɔ nɔ lɨʼɨ twei pa ghɨ̀nɨ. ");
INSERT INTO bmo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nthɛ yie ghɔ, pi mɛ̄iŋ shhɛ ghɔ ni Shhɛ Chhǐ ti nchəɨŋ thɔ pa shiʼa. ");
INSERT INTO bmo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nnɛ nnu ŋa njəɨlɨʼɨ Minnwi mbɔ Jɛrimaya ni nchhu nɛ lɔ̄gɔ lɨʼɨ ŋa, “Ndɔ pugu lɔ̄gɔ trɛi wuŋ ndigi mbɨŋ ghɔ, mbɔ fɨʼɨ nchuoŋ thɔ ju yɛ ŋa pichəɨ pa ŋgwa Ishrae ni nūʼɔŋ nɔ pe nu nɔ thɔ yi nɛ, ");
INSERT INTO bmo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mfɛ mbɨŋ ghɔ nɔ yuoŋ nu lɨʼɨ shhɛ yɛ ŋa pi ni mɛ̄iŋ ni shhɛ ŋgaŋ puoŋ yaoŋ, nɔ haʼaŋ Taathɔ ni nōoŋ vəɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jishɔ thi shhɨ ŋgaŋ shaʼa ŋgwa, ŋgaŋ shaʼa ŋgwa ghɔ pie vi ŋa, “Ɔ Fùoŋ pa Juu?” Jishɔ chhu ŋa, “A haʼaŋ ɔ chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ndɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pichəɨ pa thishɨ ni ŋga nchhu pa nnu thɔ yu, paʼa a lɔ njiʼi ŋkhwɛ̄. ");
INSERT INTO bmo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nnɛ Pailɛ chhu ghɔ kiʼɛ ŋa, “Ɔ lɔ njaʼo fɨʼɨ pa nnu ŋa pugu chhu nu thɔ ghɔ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ndɔ paʼa a lɔ njiʼi ŋkhwɛ̄ sheshe nnu ghɔ ki taʼa ndigi nnu ŋa pi chhu thɔ yu nɛ, nnɛ ti ŋgaŋ shaʼa ŋgwa ghɔ ghrāo ŋkiɛŋ ntou yi. ");
INSERT INTO bmo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A ghà mbɔ nùʼɔŋ ŋgaŋ shaʼa ŋgwa moŋ sheshe ndɨɨ Jɨ Lli Njiʼa nɔ chuʼɔ nu sheshe ŋgaŋ chə́ɨŋ ŋa ŋgwa chhu ŋa a chuʼɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A ni ŋga mbɔ ndɨɨ ghɔ, pugu fāʼo yichəɨ wuwuru ŋgaŋ nchəɨŋ ŋa pi ya nji vi, ligi yi pɔ Baraba. ");
INSERT INTO bmo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nnɛ pugu gha ŋkɨrɨ, Pailɛ chhu ni pugu ŋa, “Pəɨ tāʼa nu ŋa ǹchuʼɔ pi gɔ̌ mfɛ ni pəɨ, Baraba ki Jishɔ ŋa pi mɛ̄iŋ vi ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nthɛ ŋa a ni nji ŋa a ni nchwīe nnu kighɨʼə pugu wɛ̄iŋ vi nchaʼa mfɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nɔ pigi nu, a ni ŋga mbɔ nɔ haʼaŋ ju Pailɛ ni nchɔchhɔ ŋkuoŋ faaŋ yi nchhɔ shaʼa nu nɛ, ŋgwɛ vi taoŋ ŋkɨ̀nɨ ghɔ ŋa, “Kiʼi nchwīe nnu mbɨŋ ŋoŋ ndɨndɨ yinɛ, nthɛ ŋa ŋ̀kwo yəɨ ŋgəʼɨ shiʼa ntou yi moŋ njə̀ɨŋ nthɛ vi.” ");
INSERT INTO bmo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pichəɨ pa thishɨ kwo niʼiŋ puŋ yú ŋgwa pighɔ fɔ nɛ ŋa pugu pie pi ŋa pi fɛ Baraba ni pugu njwi Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ŋgaŋ shaʼa ŋgwa ghɔ pɨnɨ mbie vugu ŋkamuʼɔŋ ŋa, “Pəɨ tāʼa nu ŋa ǹchuʼɔ yəɨ ŋoŋ shɨna paa ŋgwa pei mfɛ ni pəɨ?” Pugu ŋa, “Baraba!” ");
INSERT INTO bmo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailɛ pie ni pugu ŋa, “Ti mi shi nchwīe pi nɛiŋ ni Jishɔ ŋa pi mɛ̄iŋ vi ni Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ.” Ŋguoŋ yugu chhu ŋa, “Pi kwīŋ vi ŋkuoŋ wáʼa!” ");
INSERT INTO bmo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A chhu ŋa, “Nthɛ khɔ? Nnu pɨphɨ ŋa a chwīe nɛ khɔ?” Ndɔ pugu pɨnɨ mbaʼo ŋgòu mbīgi ŋgə̄ɨ shhɨ ŋa, “Pi kwīŋ vi ŋkuoŋ wáʼa!” ");
INSERT INTO bmo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailɛ ni ŋga njəɨ ŋa ghɛ̀rɛ lɔ mbɔ nɔ ghə̄ɨ nu shhɨ ndōu nu, ndɔ njəɨ ŋa minthɛ ŋgwa pighɔ sha mighei nɛ, a kwe ŋkhǐ nshɨ̄gao mbhɔ mi nɔ ghɔ shhɨ yú ŋgwa pighɔ, nchhu nu ŋa, “Mbhɔ ma yi wo nɔ chhǐ ŋoŋ vei, yei pɔ pi fàʼa yəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ŋguoŋ ŋgwa pighɔ khwɛ̄ ŋa, “Chhǐ yi shi mbɔ thɔ pigi pugu pa thɔ puoŋ pigi!” ");
INSERT INTO bmo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nnɛ, a chuʼɔ Baraba mfɛ ni pugu, ŋga ŋkwo wie Jishɔ, nchaʼa vi mfɛ ŋa pi kwīŋ vi ŋkuoŋ wáʼa. ");
INSERT INTO bmo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nnɛ pa ghaŋ māʼaŋ nchhɔ̀ ŋgaŋ shaʼa ŋgwa ghɔ lɔ̄gɔ Jishɔ ŋgə̄ɨ ni ju moŋ ntuʼɔ, ŋkɨrɨ kwíe ntɨgao ŋkɨɨ pa shoogɛ yəɨ yu. ");
INSERT INTO bmo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pugu shrāo ndhwí yi māʼaŋ pɨ̀rɨ pipie mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pugu ni ŋga ŋkra ŋkie michwɛʼichwɛʼi, ŋgwɛ thɔ yu, niʼiŋ mbìe pa fùoŋ ŋgei mbhɔ yi yi jɨ, ŋkwi kwɛ́rɛ yugu shhɨ yu māʼaŋ vi ni kwə̀ɨŋ, nchhu nu ŋa, “Chrá njɨ yɔ, ma fùoŋ pa ŋgwa Juu!” ");
INSERT INTO bmo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pugu thu thwɛ mbɨŋ yu, ŋkwe mbìe ghɔ ndɔ ŋgwie vi nɔ thɔ yi. ");
INSERT INTO bmo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pugu ni ŋga ŋkwo māʼaŋ vi ni kwə̀ɨŋ, nshrāo pɨ̀rɨ pipie ghɔ mbɨŋ yu māʼaŋ ji ndhwí mbɨŋ yu, ndɔ̄gɔ vi ŋgə̄ɨ nɔ lɨʼɨ kwīŋ vi ŋkuoŋ wáʼa. ");
INSERT INTO bmo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nɔ haʼaŋ pugu ni ntaoŋ nu mbhi nɛ, njəɨ ŋoŋ chəɨ llɔ Shiriŋ, ligi yi pɔ Shemu, pugu ŋɨ vi ŋa a tiɛŋ wáʼa Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pugu ni ŋga nchəɨŋ lɨʼɨ chəɨ ŋa pi mɛ̄iŋ ni Gogota, njiŋ yi pɔ ŋa Lɨʼɨ Kwéi Thɔ. ");
INSERT INTO bmo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pugu fɛ làʼo ghɔ ŋa pi nyāaŋ ni yaoŋ lwilwi ŋa a nnu, ndɔ a gha njwɛʼi, paʼa ndɔ nnu. ");
INSERT INTO bmo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pugu ni ŋga ŋkwo kwīŋ vi ŋkuoŋ wáʼa, māʼaŋ pɛʼi nɔ ghrā nu ndhwí yi shɨna pugu. ");
INSERT INTO bmo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nnɛ pugu chɔchɔ shhɛ nchhɔ ŋkɛ̄ʼi vi fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pugu nāʼaŋ yaoŋ ŋa pi ni ŋgwɛ̄iŋ vi nɔ ghɔ nɛ ŋkuoŋ wáʼa thɔ yu ŋa, “Yei Jishɔ, mbɔ Fùoŋ pa Ŋgwa Juu.” ");
INSERT INTO bmo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pi ni ŋkwīŋ vugu pa paa ŋgɨna minwi kaʼa, taʼa yi ŋgei mbhɔ jɨ, taʼa yi ŋgei mbhɔ ŋkwrɛi. ");
INSERT INTO bmo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ŋgwa pɛ ŋa pugu ni ntɔgɔ nu fɔ nɛ ni nthɔ ŋgwɛʼi vi, nchɨʼɨ thɔ yugu, ");
INSERT INTO bmo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nchhu nu ŋa, “Gɔ̀ ŋa ɔ kaŋ ni nthɛ ɔ shāʼa Nda Minnwi mbɨnɨ ŋkrao moŋ trɛi llɛ́ nɛ, kwe nɛ noŋ yɔ pia! Ä mbɔ ŋa ɔ Muuŋ Minnwi, ɔ shwiʼi nɛ ŋkuoŋ wáʼa yinɛ pia.” ");
INSERT INTO bmo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wuʼɔ nɛnnɛ, pa thishɨ ghaŋ fɛʼiŋgiɛŋ, pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa pichəɨ thishɨ māʼaŋ vi ni kwə̀ɨŋ ŋkaa pugu, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A ni ŋkwe ŋgwa ndɔ minthɛ paʼa a lɔ ŋkwe noŋ yi. A pɔ pi Fùoŋ pa ŋgwa Ishrae, a shwiʼi nɛ ŋkuoŋ wáʼa ndwɛ pigi piŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A ni njɨʼə noŋ yi pi mbɨŋ Minnwi, Minnwi kwe nɛ vi ndwɛ nɔ haʼaŋ ä ŋkhwā vi, nthɛ ŋa a ni nchhu ŋa, ‘M̀bɔ pi Muuŋ Minnwi.’ ” ");
INSERT INTO bmo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pa ŋgɨna minwi ŋa pi ni ŋkwīŋ vugu pugu nɛ ni māʼaŋ vi ni kwə̀ɨŋ wuʼɔ nɛnnɛ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A ni ŋga mbɔ moŋ ntuŋ minaoŋ, njiŋnjiŋ gū moŋ ŋguoŋ laʼa ghao ti ŋgə̄ɨ nchəɨŋ moŋ trɛi minaoŋ ni naoŋchɨ. ");
INSERT INTO bmo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A gha mbɔ moŋ trɛi minaoŋ ghɔ, Jishɔ kə̄ɨ ŋa, “Eli, Eli, lema shabatani?” njiŋ yi pɔ ŋa, “Minnwi a, Minnwi a, ɔ mīʼaŋ a ŋa?” ");
INSERT INTO bmo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pichəɨ ŋgwa ŋa pugu ni nthi fɔ nɛ gha njaʼo, nchhu ŋa, “Ŋoŋ vei thɔ mɛ̄iŋ pi Elaija.” ");
INSERT INTO bmo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wuʼɔ ndɨɨ ghɔ, yichəɨ taʼa ŋoŋ vugu kɛ̄ʼi ntei tei ŋgə̄ɨ ndɔ̄gɔ kusha niʼiŋ làʼo chəchɨgəɨ fɔ nchwɛʼi thɔ muuŋ thɨ mfɛ ghɔ ŋa a nnu. ");
INSERT INTO bmo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ndɔ pichəɨ ŋgwa ŋa pugu ni nthi fɔ nɛ chhu ŋa, “Mieŋ vi pia yəɨ ŋa Elaija shi nthɔ ŋkwe vi.” ");
INSERT INTO bmo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ndɔ Jishɔ pɨnɨ ŋkə̄ɨ ŋkiɛŋ ni njɨ, jijwɛ yi taoŋ. ");
INSERT INTO bmo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ŋga njəɨ nu nɛ, ndhwí kɨʼɨ lɨʼɨ ŋa a ni mbɔ moŋ Nda Minnwi shāa ntaoŋ yi paa llɔ thɔ ghɔ nshwiʼi mfɛ làʼo ghɔ, shhɛ chɨ̄ʼɨ, pa ŋgùʼɔ shɨna. ");
INSERT INTO bmo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pa fúŋ moŋ ŋgùʼɔ chuʼɔ ŋkaa pugu, ntou khu ŋgwa Minnwi pi taoŋtaoŋ ŋa pugu ni ŋkwo khu nɛ kuʼɔ moŋ gu, ");
INSERT INTO bmo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ntaoŋ moŋ fúŋ moŋ ŋgùʼɔ, Jishɔ ni ŋga ŋkuʼɔ moŋ gu, pugu pugu ghə̄ɨ moŋ mmɛ laʼataoŋ taoŋtaoŋ nōoŋ noŋ yugu ni ntou ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ndɨɨ ŋa nthishɨ pa taʼa ŋkɨɨ shoogɛ, pugu pa ŋgwa ŋa pugu pugu ni mbɔ nchhɔ ŋkɛ̄ʼi Jishɔ ni njəɨ shhɛ nchɨʼɨ pugu pa nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ, pɔgɔ gu wɛ̄iŋ vugu, pugu chhu ŋa, “Shishini, ŋoŋ vei ni mbɔ Muuŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ntou pa piŋgɛ ni mbɔ fɔ ŋkaa pugu nthi fie hini nchhɔ mbɛʼi nu. Yei ni mbɔ piŋgɛ pɛ ŋa pugu ni njōu njiŋ Jishɔ llɔ Galili nchhɔ ŋgɛ̄rɛ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Shɨna pugu ni mbɔ Meri Madaliŋ, ni Meri mǔuŋ Jɛiŋ ni Joshɛ, ni mǔuŋ puoŋ Shebedi. ");
INSERT INTO bmo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A ni ŋga mbɔ ni fanaoŋ, ŋgaŋ fàʼo chəɨ llɔ Arimatia, ligi yi pɔ Joshɛ, ŋa juju ŋkaa yu ni mbɔ ŋgaŋ younjiŋ Jishɔ nɛ thɔ. ");
INSERT INTO bmo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A ni ŋgə̄ɨ mbara Pailɛ mbie vi ŋa a fɛ khu Jishɔ ghɔ. Nnɛ Pailɛ fɛ gɨ́ ŋa pi fɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joshɛ lɔ̄gɔ khu Jishɔ ndiŋ moŋ mbhɔ ndhwí fhu, mbɔ yi fhi, ");
INSERT INTO bmo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","niʼiŋ vi moŋ ji fúŋ ŋa a ni ŋguʼɔ ŋka fiʼifiʼi moŋ ŋgùʼɔ, ŋkə̄nə ŋkiɛŋ mmɛ ŋgùʼɔ nchri chofuŋ ghɔ nɔ, ŋgə̄ɨ ni vhi. ");
INSERT INTO bmo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Madaliŋ pugu yichəɨ taʼa Meri ni mbɔ fɔ nchɔchhɔ njɨna chofuŋ moŋ ŋgùʼɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mbhi ni ŋga ndaŋ, llɛ́ pīri noŋ kwo tɔgɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋgwa Farashi kɨrɨ shhɨ Pailɛ, ");
INSERT INTO bmo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nchhu ŋa, “Masha, pigi kwiŋ ŋa ŋgaŋ mifɨɨ yinɛ ni ŋga ŋguʼɔ mbɔ yi maoŋ, nchhu ŋa, ‘Trɛi llɛ́ shi ŋga ntɔgɔ, m̀bɨnɨ ŋkuʼɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nthɛ yie ghɔ, mfɛ gɨ́ pi thɔ ŋkɛ̄ʼi chofuŋ ti trɛi llɛ́ nuʼuŋ ntɔgɔ kaŋ pa ghaŋ younjiŋ pi shi nthɔ njōo khu yi ŋgə̄ɨ nɔ ghɔ nchhu ni pa ŋgwa ŋa, ‘A kuʼɔ moŋ gu.’ Ndugwi njiŋ fɨ̄ɨ nu yei wūru nchaa fǔoŋ yi.” ");
INSERT INTO bmo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailɛ chhu ni pugu ŋa, “Pəɨ lɔ̄gɔ pa shoogɛ kɛ̄ʼi lɨʼɨ ŋgə̄ɨ nchwīe pugu ya ndɨna ni fúŋ ghɔ nɔ haʼaŋ pəɨ tāʼa nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nnɛ pugu fɨ̄nɨ chofuŋ ghɔ nɔ haʼaŋ mbaʼa ŋoŋ nii fɔ ntɔgɔ pi ŋkuoŋ lēi nu pugu pa mieŋ nu ghaŋ kɛ̄ʼi lɨʼɨ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Llɛ́ ji pa Juu ni ŋga ntɔgɔ, mbhi jɛ̄ laŋ nu, mbɔ fǔoŋ llɛmbhi moŋ shwiʼi taŋ ghɔ, mbɔ Shonde, Meri Madaliŋ pugu yichəɨ taʼa Meri ghɔ ghə̄ɨ lɨʼɨ yəɨ fúŋ. ");
INSERT INTO bmo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ŋga njəɨ nu, shhɛ chɨ̄ʼɨ ŋkiɛŋ yie ghɔ nthɛ ŋa ŋgaŋ ntaoŋ Taathɔ ni nshwiʼi llɔ po ŋkə̄nə ŋguʼɔ chofuŋ mbɨnɨ nɔ njiŋ nchɔchhɔ ŋkuoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Miŋi mi ni nshei nɔ fiembɨ, ndhwí yi fugu nɔ wěi. ");
INSERT INTO bmo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pa ghaŋ kɛ̄ʼi lɨʼɨ pɔgɔ vi ŋgrū ti noŋ yugu khu. ");
INSERT INTO bmo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ndɔ ŋgaŋ ntaoŋ ghɔ chhu ni piŋgɛ pighɔ ŋa, “Kiʼi pəɨ fāʼo pɔgɔ gu, ǹji ŋa pəɨ thɔ ntāʼa pi Jishɔ ŋa pi ni ŋkwīŋ vi ŋkuoŋ wáʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A lɔ njiʼi mbɔ hɛiŋ, nthɛ ŋa a kwo kuʼɔ moŋ gu nɔ haʼaŋ a ni nchhu nɛ, pəɨ thɔ njəɨ lɨʼɨ ŋa pi ni ntwei vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nnɛ, pəɨ yiʼa ŋgəɨghəɨ nchhu ni ghaŋ younjiŋ pi ŋa a kwo kuʼɔ moŋ gu, ndɔ pəɨ līi njəɨ, a ghə̄ɨ nu nɛ shhɨ pəɨ moŋ Galili, ndɔ pəɨ shi njəɨ vi fɔ! Pəɨ kwiŋ nnu ŋa ǹshwei vəɨ nɔ ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nnɛ pugu lɔllɔ chofuŋ ni tei moŋ pɔgɔ gu pugu pa mmɛ pwanjuʼɔ, ntei ŋgə̄ɨ lɨʼɨ shwei pa ghaŋ younjiŋ pi nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ndɔ ŋga njəɨ nu nɛ, Jishɔ paoŋ pugu pugu nchhu ŋa, “Nchrā ni pəɨ!” Ndɔ pugu thɔ ŋgwɛ̄iŋ kwò yi ŋgaʼo vi. ");
INSERT INTO bmo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nnɛ Jishɔ chhu ni pugu ŋa, “Kiʼi pəɨ fāʼo pɔgɔ gu, pəɨ ghə̄ɨ nchhu ni pa lǐŋ paŋ ŋa pugu ghə̄ɨ Galili kaŋ pugu shi njəɨ a fɔ.” ");
INSERT INTO bmo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nɔ haʼaŋ piŋgɛ pighɔ ni ŋgə̄ɨ nu nɛ, ŋga njəɨ nu, pichəɨ pa ghaŋ kɛ̄ʼi fúŋ ghɔ thɔ moŋ laʼa mfɨ̄ʼɨ ŋguoŋ pa nnu ŋa a ni ndɔ̄gɔ lɨʼɨ nɛ ni pa thishɨ ghaŋ fɛʼiŋgiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pighɔ kɨrɨ pugu pa pichəɨ pa thishɨ, mbini ntaoŋ mfɛ ntou mbɨŋ ni pa shoogɛ pighɔ, ");
INSERT INTO bmo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nchhu ŋa, “Pəɨ fāʼo nɔ chhu nu pi ŋa, ‘Pa ghaŋ younjiŋ pi thɔ ni tuʼu njōo vi ŋgə̄ɨ nɔ ghɔ ndɨɨ ŋa pigi ni ndhɛ nu nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ndɔ ti ÿei nchəɨŋ tə́nə ŋgaŋ shaʼa ŋgwa, pigi ji ŋkwaŋ nɔ haʼaŋ pigi shi ŋkara vi nnɛ ŋa kiʼi pəɨ fāʼo ŋgəʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pugu kwe mbɨŋ ghɔ nchwīe nɔ haʼaŋ pi ni nchhu ni pugu nɛ. Chrà yei nyīeŋ wuʼɔ nnɛ shɨna pa Juu ti nthɔ nchəɨŋ thɔ pa shiʼa. ");
INSERT INTO bmo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Taʼanchrɔ ghaŋ younjiŋ pi pighɔ ghə̄ɨ Galili ŋkuoŋ mbra nɔ haʼaŋ Jishɔ ni nshwei vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pugu ni ŋga njəɨ vi, ŋgaʼo vi ndɔ pichəɨ fāʼo khuthɔ. ");
INSERT INTO bmo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jishɔ thɔ nchhu ni pugu ŋa, “Pi kwo fɛ ŋguoŋ ghrɨ́ po pugu pa ŋkuoŋ shhɛ vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nthɛ yie ghɔ, p̂əɨ ghə̄ɨ nchwīe ŋgwa pugu pɔ pa ghaŋ younjiŋ paŋ moŋ ŋguoŋ pa laʼataoŋ ghao nchhɔ ŋkwe vugu ni ŋkhǐ moŋ ligi Tǎa ni Muuŋ ni Jijwɛ Minnwi, ");
INSERT INTO bmo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nchhɔ njɛʼi vugu ŋa pugu nūʼɔŋ ŋguoŋ pa nnu ŋa ǹchhu ni pəɨ nɛ ghao. Pəɨ līi njəɨ, pia shi mbɔ kaʼa ŋguoŋ ndɨɨ ti mbhi shi nuʼuŋ ndugwi.” ");
INSERT INTO bmo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yei njɛ̄ pwa pishaʼakhɔ Jishɔ, mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, mbɔ Muuŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pi nāʼaŋ moŋ ŋwaʼaŋlɨ njəɨlɨʼɨ Minnwi mbɔ Ishaya ŋa, “Līi njəɨ, ǹshi ntaoŋ ŋgaŋ ntaoŋ a, a ghə̄ɨ shhɨ pəɨ mbīri ndaoŋ ni pəɨ, ");
INSERT INTO bmo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ŋoŋ chəɨ thɔ mfɛ gɛ̀ moŋ ŋkǔnu njó ŋa: ‘Pīri shɛndaoŋ Taathɔ, chwīe pa lɨʼɨ tɔgɔ yi pɔ yi tithi.’ ” ");
INSERT INTO bmo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nɛnnɛ, Jouŋ Ŋgaŋ Fɛ Ŋkhǐ ni nthɔ mbɔ moŋ ŋkǔnu njó nthɔ mfɛ ŋkhǐ ni ŋgwa, ndɔ nchīi nu ŋa, “Pəɨ pāʼa ŋkǔnu yəɨ ni phɨ, m̀fɛ ŋkhǐ ni pəɨ, Minnwi līʼɛ phɨ yəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ŋguoŋ ŋgwa moŋ laʼataoŋ Judia, pugu pa ŋguoŋ ŋgwa Jerushalɛiŋ taoŋ ŋgə̄ɨ njəɨ vi, a kwe vugu ni ŋkhǐ moŋ nɨnəɨ Jodaŋ. Pugu yūa phɨ yugu. ");
INSERT INTO bmo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jouŋ ni māʼaŋ ndhwí ŋa pi chwīe pi ni ŋgì yichəɨ ŋkwaŋ minyieŋ pi mɛ̄iŋ ni kamela, ni ŋkandaŋ ŋgrào minyieŋ nɔ ntuʼu yi, maoŋ jɨ pi ni mbɔ ŋgwíŋ pugu pa llɔ̌ ŋkǔnu. ");
INSERT INTO bmo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A ni nchīi nu ŋa, “Ŋoŋ ŋa a shi nthɔ njiŋ a nɛ ghaʼo nchaa a, paʼa ǹdɔ njiʼi ŋkāʼo ŋoŋ ŋa minthɛ ǹtuʼu noŋ a mfēi ŋkɨ̌ɨ tra yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi ni ŋkwe vəɨ pi ni ŋkhǐ, ndɔ a shi ŋkwe vəɨ pi ni Jijwɛ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A ni mbɔ moŋ llɛ́ pighɔ, Jishɔ thɔ llɔ Nasharɛ moŋ Galili, Jouŋ kwe vi ni ŋkhǐ moŋ nɨnəɨ Jodaŋ. ");
INSERT INTO bmo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jishɔ gha mbɨʼɨ noŋ yi ntaoŋ moŋ ŋkhǐ ghɔ nɛ, njəɨ po ŋaʼaŋ chomilaoŋ ghɔ, Jijwɛ Minnwi shwiʼi nu mbɨŋ yu mbɔ nɔ mintuʼɔlibuŋ. ");
INSERT INTO bmo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ŋggì taoŋ po, nchhu nu ŋa, “Ɔ muuŋ a ŋa ŋ̀khwā, ǹja mfāʼo pwatua nthɛ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wuʼɔ chomilaoŋ ghɔ, Jijwɛ ghɔ chwīe a ghə̄ɨ moŋ ŋkǔnu njó. ");
INSERT INTO bmo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A ni mbɔ moŋ ŋkǔnu njó ghɔ nɔ khwɛ wuŋ llɛ́, Shata thɔ mōoŋ vi. A ni mbɔ fɔ pugu pa mimaoŋ mooŋ trǔ, ndɔ pa ghaŋ ntaoŋ Minnwi chhɔ ŋgɛ̄rɛ vi. ");
INSERT INTO bmo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pi ni ŋga ŋkwo wɛ̄iŋ Jouŋ ti mfɨ̄nɨ, Jishɔ ghə̄ɨ Galili nthɔ nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ Minnwi, ");
INSERT INTO bmo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nchhu nu ŋa, “Ndɨɨ kwo kāʼo, Shaʼafuoŋ Minnwi kwo para, pəɨ pāʼa ŋkǔnu yəɨ ni phɨ, ŋkara mbiŋ pwa pishaʼakhɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jishɔ ni ŋga nyīeŋ nu ŋkɨŋ mmɛ ŋkhǐ Galili, njəɨ Shemu pugu Andru ndǐŋ vi, pugu thɔ māʼaŋ ndáŋ moŋ ŋkhǐ, nthɛ ŋa pugu ni mbɔ pa ghaŋ ŋgunu. ");
INSERT INTO bmo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jishɔ chhu ni pugu ŋa, “P̂əɨ yōu njiŋ a, ǹchwīe pəɨ pɔ ghaŋ wɛ̄iŋ ŋgwamishua.” ");
INSERT INTO bmo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wuʼɔ ndɨɨ ghɔ pugu mieŋ ndáŋ pugu njōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A ni ŋga nyīeŋ ŋgə̄ɨ shɨgɛi, njəɨ Jɛiŋ mbɔ muuŋ Shebedi pugu Jouŋ ndǐŋ vi, pugu pɔ moŋ kikuoŋ yugu ntaʼa pa ndáŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wuʼɔ chomilaoŋ ghɔ Jishɔ mɛ̄iŋ vugu, pugu mieŋ tǎa vugu, mbɔ Shebedi, moŋ kikuoŋ pugu pa puoŋ fàʼa, njōu njiŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pa Jishɔ ni ŋgə̄ɨ Kapanuŋ, wuʼɔ chomilaoŋ ghɔ, a gha mbɔ llɛ́ ji, a nii moŋ nda luoŋ Minnwi nthɔ njɛʼi ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pa ŋgwa pɛ ŋa pugu ni njaʼo a yɛʼi nu nɛ ghrāo ŋkwaŋ haʼaŋ a ni njɛʼi nu nɛ, nthɛ ŋa a ni njɛʼi nɔ mmɛŋoŋ ŋa a fāʼo ghrɨ́, a shini ndɔ njɛʼi pi nɔ ghaŋ yɛʼi gɨ́ Mushi. ");
INSERT INTO bmo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wuʼɔ ndɨɨ ghɔ, yichəɨ ŋoŋ ni jijwɛ pɨphɨ nii moŋ nda luoŋ Minnwi yugu, ŋkə̄ɨ nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Pia fāʼo pi khɔ Jishɔ llɔ Nasharɛ? Ɔ thɔ pi nɔ pɨrɨ nu vigi? Ǹji ŋoŋ ŋa ɔ yie nɛ, ɔ yi taoŋtaoŋ llɔ mbhɔ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jishɔ pɨ̄ga vi, nchhu nu ŋa, “Lɛrɛ laŋ ndɔ ntaoŋ mbɨŋ yu.” ");
INSERT INTO bmo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jijwɛ pɨphɨ ghɔ shwiʼi miprɨligi mbɨŋ yu, ŋga ŋkə̄ɨ ŋkiɛŋ ni njɨ, ntaoŋ mbɨŋ yu kiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ŋguoŋ ŋgwa pighɔ ghrāo ti mbie noŋ pugu ŋa, “Yei pɔ pi khɔ? A pɔ pi yichəɨ ŋkwaŋ yɛʼi yaoŋ fhi! A fɛ gɨ́ nɔ mmɛŋoŋ ni ghrɨ́, njiʼi nthɛ pi ni pa jijwɛ pɨphɨ, pugu yaʼo vi.” ");
INSERT INTO bmo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nthɛ pa nnu pei, ligi Jishɔ nɔ ŋoŋ ndiɛŋ ni nyīeŋ moŋ ŋguoŋ lɨʼɨ moŋ ŋguoŋ Galili ghao. ");
INSERT INTO bmo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wuʼɔ chomilaoŋ ghɔ Jishɔ taoŋ moŋ nda luoŋ Minnwi ŋgə̄ɨ pugu pa Jɛiŋ ni Jouŋ nda Shemu pugu Andru. ");
INSERT INTO bmo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ndɨɨ ghɔ, ŋguŋ Shemu ni nthɔ ŋgɨ̄nɔ shɨ̀gao, pi shwei Jishɔ nɔ wuʼɔ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A thɔ ŋgwɛ̄iŋ mbhɔ yi mbɨʼɨ vi tɔthɨ, shɨ̀gao ghɔ kiʼi ndɔ ntaoŋtaoŋ, ŋguŋ shemu ghɔ fɛ maoŋ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ni fanaoŋ ghɔ moŋ nii minaoŋ, pi thɔ ni ŋguoŋ ghaŋ ghɨ̌nɔ pugu pa ŋgwa ŋa pa miŋwɛiŋ ni ŋgana vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ŋguoŋ ŋgwa moŋ mmɛ laʼataoŋ ghɔ kɨrɨ chonda ŋa a ni mbɔ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A yɨ̄gɨ ghɨ̌nɔ ntou ŋgwa pɛ ŋa pugu ni nthɔ ŋgɨ̌nɔ ŋkwaŋ ŋkwaŋ ghɨ̌nɔ nɛ, mfuʼu ntou pa miŋwɛiŋ. A shini ndɔ mfɛ shɨna ni sheshe miŋwɛiŋ nɔ chrā nu nthɛ ŋa pugu ni nji vi. ");
INSERT INTO bmo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A ni ŋga mbɔ ŋkiɛŋ ni tutuʼu ki lɨʼɨ lɔ naa nja mfēi shiʼi, Jishɔ lɔllɔ ntaoŋ ŋgə̄ɨ lɨʼɨ ŋa ŋoŋ lɔ njiʼi mbɔ fɔ nɛ, nduoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Shemu pugu pa ŋgwa pɛ ŋa pugu pugu ni mbɔ kaʼa nɛ taoŋ nthɔ ntāʼa vi. ");
INSERT INTO bmo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pugu ni ŋga njəɨ vi, nchhu ghɔ ŋa, “Ŋguoŋ ŋgwa thɔ nɛ ntāʼa ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ndɔ a chhu ni pugu ŋa, “Pia ghə̄ɨ moŋ pichəɨ pa laʼataoŋ, nnɛ ŋa minthɛ ǹchīi chrà ni pugu fɔ ŋkaa pugu, nthɛ ŋa mi ni nthɔ nthɛ pi yie.” ");
INSERT INTO bmo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nnɛ, a nyīeŋ moŋ ŋguoŋ Galili ghao, nthɔ nchīi chrà Minnwi moŋ pa nda luoŋ Minnwi ndɔ mfuʼu pa miŋwɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ŋgaŋ ghɨnɔmbaluŋ thɔ njəɨ vi, ndɨ̄gəɨ vi, ŋkwi kwɛ́rɛ yi shhɛ nchhu ŋa, “Ɔ̈ ŋkhwā, ɔ chwīe mbɔ yi taoŋtaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nthɛ kwoshɨnɨ ŋa Jishɔ ni mfāʼo nɛ, Jishɔ shwīi mbhɔ yi ŋkaoŋ vi, nchhu ghɔ ŋa, “Ŋ̀khwā. Pɔ yi taoŋtaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wuʼɔ chomilaoŋ ghɔ ghɨnɔmbaluŋ mmɛ mbɨŋ yu, a gū yi taoŋtaoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nnɛ Jishɔ gha ŋkwo shūu tə́nə yi, nchhu ghɔ ŋa a ghə̄ɨ wuʼɔ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nchhu ghɔ ŋa, “Kiʼi nchhu ni shesheŋoŋ, ndɔ ghə̄ɨ nōoŋ noŋ yɔ ni ŋgaŋ fɛʼiŋgiɛŋ Minnwi a līi ghɔ, ndɔ mfɛ yaoŋ fɛʼiŋgiɛŋ nɔ haʼaŋ gɨ́ Mushi chhu nɛ, nɔ nōoŋ nu ŋa Minnwi yɨ̄gɨ ghɨ̌nɔ yɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ndɔ a taoŋ njɛ̄ chrā nu nnu pighɔ ki lɔ ŋgīʼɛ, nthɔ nchīi nnu pighɔ. Nchrā ti nchəɨŋ moŋ nthɨŋkwo ŋa Jishɔ kaŋ ni mfɛ paʼa a lɔ nuʼuŋ nii moŋ laʼa shhɛnte, a ni ŋkɨna pi moŋ pa lɨʼɨ ŋa ŋgwa shi ki lɔ mbɔ fɔ nɛ, ŋgwa llɔ moŋ ŋguoŋ ntəʼɨ ŋgə̄ɨ nthɔ njəɨ vi. ");
INSERT INTO bmo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Shɨgɛi llɛ́ ni ŋga ntɔgɔ, Jishɔ pɨ̄nɨ Kapanuŋ pa chrà nyīeŋ ŋa a pɔ laʼa. ");
INSERT INTO bmo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ntou pa ŋgwa thɔ ŋkɨrɨ ti paʼa shɨ̀na lɔ nuʼuŋ mbɔ, njiʼi nthɛ pi chonda. Jishɔ ni nthɔ nchhu chrà Minnwi ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ŋgwa chəɨŋ pugu pa ŋkwíni kwò, khwɛ pimbia tiɛŋ vi nthɔ nu ni ju lɨʼɨ yəɨ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Shɨ̀na ni ŋga mieŋ ki lɔ mbɔ ni pugu nɔ para nu yəɨ Jishɔ nthɛ yú ŋgwa pighɔ, pugu kuʼɔ thɔnda ŋaʼaŋ mbo fɔ, nshwiʼi ŋkwíni ghɔ ŋkuoŋ kúoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jishɔ ni ŋga njəɨ fɨʼɨ piŋ yugu, nchhu ni ŋkwíni ghɔ ŋa, “Muuŋ a, pi līʼɛ pa phɨ pɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pichəɨ pa ghaŋ yɛʼi gɨ́ Mushi ni nchhɔ fɔ, mbie nu moŋ njùʼɔ pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ŋoŋ vei kie nɛiŋ nchrā nɛiŋ? Yei pɔ pi chrà nchɨʼəshə! Mimfɛ a līʼɛ gɔ̌ ndīʼɛ phɨ ŋkiɛŋ Minnwi təʼɨ vi?” ");
INSERT INTO bmo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wuʼɔ ndɨɨ ghɔ, Jishɔ ni nji nnu ŋa pugu ni mbīʼi nu moŋ njùʼɔ pugu nɛ moŋ jijwɛ yi, nchhu ni pugu ŋa, “Pəɨ kie nɛiŋ nthɔ mbīʼi ŋkwaŋ nnu pei nɛiŋ njùʼɔ pəɨ? ");
INSERT INTO bmo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A yīʼɛ yəɨ, chhu nu ni ŋkwíni ŋa, ‘Pi līʼɛ pa phɨ pɔ,’ ki chhu nu ŋa, ‘Lɔllɔ, lɔ̄gɔ kúoŋ yɔ, nyīeŋ’? ");
INSERT INTO bmo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ndɔ nɔ chwīe nu pəɨ ji ŋa Muuŋ Ŋoŋmishua fāʼo ghrɨ́ ŋkuoŋ shhɛ nɔ līʼɛ nu pa phɨ.” A chhu ni ŋkwíni ghɔ ŋa, ");
INSERT INTO bmo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ǹchhu vɛ, lɔllɔ, lɔ̄gɔ kúoŋ yɔ ŋgə̄ɨ laʼa.” ");
INSERT INTO bmo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wuʼɔ ndɨɨ ghɔ, a lɔllɔ, ndɔ̄gɔ kúoŋ yi, ntaoŋ ni vhi ligi ŋguoŋ yugu ghao, nɛnnɛ, ŋguoŋ yugu ghrāo, ŋgaʼo Minnwi, nchhu nu ŋa, “Pigi lɔ naa ma njəɨ sheshe nnu nɔ yei!” ");
INSERT INTO bmo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jishɔ pɨnɨ ŋgə̄ɨ ŋkɨŋ mmɛ ŋkhǐ ŋkamuʼɔŋ, ŋguoŋ yú ŋgwa ni ŋgə̄ɨ nu lɨʼɨ yəɨ vi, a thɔ njɛʼi vugu. ");
INSERT INTO bmo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ndɔ haʼaŋ a ni nyīeŋ nu nɛ, a yəɨ Levi, muuŋ Afioshi, a chhɔ moŋ ntǎa kwe taashi, a chhu ghɔ ŋa, “Yōu njiŋ a.” A yrɛi shhɛ njōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ndɔ haʼaŋ Jishɔ ni nchhɔ yəɨ taprɛi nthɔ njɨ maoŋ nda Levi nɛ, ntou pa ghaŋ wɛ̄iŋ taashi pugu pa ghaŋ phɨ chhɔ yəɨ yu pugu pa ghaŋ younjiŋ pi, nthɛ ŋa ntou ŋgwa ni nthɔ njōu njiŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pa ghaŋ yɛʼi gɨ́ Mushi ŋa pugu ni mbɔ pa ŋgwa Farashi nɛ ni ŋga njəɨ ŋa a thɔ njɨ maoŋ pugu pa ghaŋ chwīe phɨ pugu pa ghaŋ wɛ̄iŋ taashi, nchhu ni ghaŋ younjiŋ pi ŋa, “A chwīe khɔ a jɨ maoŋ pugu pa ghaŋ wɛ̄iŋ taashi pugu pa ghaŋ phɨ?” ");
INSERT INTO bmo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jishɔ ni ŋga njaʼo yei nnu, nchhu ŋa, “Ŋgwa pɛ ŋa pugu pɔ shiʼi nɛ lɔ mfāʼo chà ŋgaŋ fhɔ̌, a fāʼo ŋgwa pɛ ŋa pugu ghɨ̌nɔ nu nɛ. Ǹdɔ njiʼi nthɔ pi nɔ gɛ̄ nu pa ŋgwa ndɨndɨ, ǹthɔ nthɛ pi ghaŋ phɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ghaŋ younjiŋ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ, pugu pa ŋgwa Farashi ni nthɔ njī ŋkhǐ. Pichəɨ pa ŋgwa thɔ mbara Jishɔ mbie vi ŋa, “A chwīe khɔ pa ghaŋ younjiŋ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ pugu pa ghaŋ younjiŋ pa ŋgwa Farashi jī ŋkhǐ, ndɔ paʼa pa ghaŋ younjiŋ pɔ lɔ njī?” ");
INSERT INTO bmo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jishɔ khwɛ̄ ni pugu ŋa, “Mimfɛ pa ghaŋ gɛ̀ lɨʼɨ láŋ jī ŋkhǐ ndɨɨ ŋa pugu pa mimbia ŋgaŋ láŋ ghɔ wuʼɔ mbɔ kaʼa nɛ? Ndɔ haʼaŋ pugu pa mimbia ŋgaŋ láŋ ghɔ wuʼɔ mbɔ kaʼa nɛ, mbaʼa pugu jī ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ndɔ pa llɛ́ pighɔ shi nthɔ ŋa pi shi mfuʼu mimbia ŋgaŋ láŋ ghɔ moŋ shɨna pugu, nɛnnɛ, pugu shi njī ŋkhǐ moŋ llɛ́ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mbaʼa ŋoŋ taʼa paʼo ŋkuoŋ ndunu ndhwí ni pra ndhwí fhi. Ä nchwīe nɛnnɛ, kaŋ ndhwí fhi ghɔ shi ŋɨnɛiŋ, nshūu ndunu ndhwí ghɔ nshāa mbɨnɨ ŋka chwīe a taoŋ pi mmɛ mbo. ");
INSERT INTO bmo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“A wuʼɔ haʼaŋ a pɔ ni mikei ŋgrào nɛ. Mbaʼa ŋoŋ niʼiŋ làʼo fhi moŋ ndunu mikei ŋgrào, ä nchwīe nɛnnɛ, làʼo ghɔ fāʼo ntūgu mikei ŋgrào ghɔ, nnɛ kaŋ làʼo ghɔ pugu pa mikei ŋgrào ghɔ shi mbɨrɨ gha. A yiʼi ŋa ŋgwa niʼiŋ làʼo fhi moŋ mikei ŋgrào fhi.” ");
INSERT INTO bmo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A ni mbɔ Llɛ́ Ji pa Juu chəɨ, Jishɔ nyīeŋ ntɔgɔ nu moŋ nyīeŋ shíe gɛ. Nɔ haʼaŋ pugu ki tɔgɔ nu nɛ, pa ghaŋ younjiŋ pi ka shíe gɛ. ");
INSERT INTO bmo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nɛnnɛ, pa ŋgwa Farashi pie ni Jishɔ ŋa, “Līi njəɨ, a chwīe khɔ pa ghaŋ younjiŋ pɔ thɔ nchwīe nnu ŋa gɨ́ lɔ njiʼi mbiŋ ŋa pi chwīe Llɛ́ Ji nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A khwɛ̄ ni pugu ŋa, “Pəɨ lɔ naa mɛ̄iŋ nnu ŋa Devi ni nchwīe ndɨɨ ŋa a ni mbou yaoŋ jɨ, njì ni njia vugu pa ŋgwa pi nɛ? ");
INSERT INTO bmo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ŋkwaŋ nɔ haʼaŋ a ni nii Nda Minnwi, ndɨɨ ŋa Abiata ni mbɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ nɛ? A ni nii ŋkru brɛi ŋa pi ni mfɛ ni Minnwi, ndɔ mbɨnɨ mfɛ yi ŋgwa pi, mbɔ yaoŋ ŋa kɨna lɔ njiʼi mbiŋ ŋa a nthɛ shesheŋoŋ kru ŋkiɛŋ ŋgaŋ fɛʼiŋgiɛŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jishɔ lūgwi ŋa, “Minnwi ni nūʼɔŋ Llɛ́ Ji nthɛ pi ŋoŋmishua, a lɔ nchwīe ŋoŋmishua nthɛ pi Llɛ́ Ji. ");
INSERT INTO bmo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nɛnnɛ, Muuŋ Ŋoŋmishua taathɔ, njiʼi nthɛ pi Llɛ́ Ji.” ");
INSERT INTO bmo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jishɔ ni mbɨnɨ ŋkamuʼɔŋ moŋ nda luoŋ Minnwi, ŋoŋ chəɨ ni mbɔ fɔ mfāʼo mbɔ kwikwi. ");
INSERT INTO bmo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pichəɨ pa ŋgwa ni mbɔ fɔ mbɛʼi vi nɔ yəɨ nu ŋa a shi njɨ̄gɨ ghɨ̌nɔ ŋoŋ ghɔ Llɛ́ Ji pa Juu, nnɛ ŋa a nthɛ pugu wɛ̄iŋ vi ŋa a chwīe nnu ŋa a lɔ ŋkāʼo. ");
INSERT INTO bmo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jishɔ chhu ni ŋoŋ ghɔ ŋa mbhɔ yi ni ŋkwikwi nɛ ŋa, “Taoŋ nthɔ hɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nɛnnɛ, a pie vugu ŋa, “Gɨ́ piŋ ŋa pi chwīe pi yəɨ Llɛ́ Ji, nnu shiʼi ki nnu pɨphɨ, kwe nu ŋoŋ ki jwi nu ŋoŋ?” Ndɔ paʼa pugu lɔ nchhu nnu. ");
INSERT INTO bmo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A kara noŋ yi mbɛʼi vugu moŋ pɨgɨtua, mfāʼo pəʼɨ njùʼɔ nthɛ tɨnɨthɔ yugu, nchhu ni ŋoŋ ghɔ ŋa, “Shwīi mbhɔ yɔ.” A shwīi, mbhɔ yi kiʼi ndɔ mbɔ pi shiʼi. ");
INSERT INTO bmo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pa ŋgwa Farashi taoŋ moŋ nda luoŋ Minnwi ghɔ ŋgə̄ɨ chomilaoŋ ghɔ nyiaŋ ntáŋ pugu pa ghaŋ younjiŋ fùoŋ Hɛrɔ, ŋkwaŋ haʼaŋ pugu shi njwi Jishɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jishɔ pugu pa ghaŋ younjiŋ pi shūʼu mbɨnɨ ŋgə̄ɨ ŋkɨŋ ŋkhǐ, mmɛ yú ŋgwa llɔ Galili yōu njiŋ yi pugu pa ŋgwa llɔ Judia, ");
INSERT INTO bmo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","pugu pa Jerushalɛiŋ pugu Idumia pugu pa llɔ njiʼa Jodaŋ pugu pa llɔ ŋgei pa laʼataoŋ Tairɛ pugu Shidoŋ. Ŋguoŋ mmɛ yú ŋgwa pei ni nthɔ lɨʼɨ yəɨ Jishɔ nthɛ ŋa pugu ni njaʼo pa nnu haʼaŋ a ni nchwīe nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A chhu ni ghaŋ younjiŋ pi ŋa pugu pīri pie ghɔ nthɛ yú ŋgwa pighɔ, kiɛŋ nɛnnɛ kaŋ pugu shi nwīʼiŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A ni ŋkwo yɨ̄gɨ ghɨ̌nɔ ntou ŋgwa, nɛnnɛ ŋguoŋ pa ŋgwa haʼaŋ pugu ni mfāʼo ghɨ̌nɔ nɛ, ni ŋɨ nu nɔ kāoŋ nu vi. ");
INSERT INTO bmo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sheshe ndɨɨ ŋa pa jijwɛ pɨphɨ ki yəɨ vi nɛ, pugu gū shhɛ shhɨ yu mbaʼo ŋgòu ŋa, “Ɔ Muuŋ Minnwi!” ");
INSERT INTO bmo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A fɛ tɨtɨnɨ gɨ́ ni pugu ŋa kiʼi pugu chwīe pi ji vi. ");
INSERT INTO bmo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jishɔ kuʼɔ ŋkuoŋ mbra, ŋgɛ̄ pa ŋgwa pɛ ŋa a ni ntāʼa nu ŋa pugu thɔ mbara vi nɛ ŋa pugu thɔ, pugu thɔ mbara vi. ");
INSERT INTO bmo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A chuʼɔ paanchrɔ ŋa a ni nchhɔ̄ ligi yugu ni ghaŋ ntaoŋ pi nɛ, ŋa pugu pugu pɔ nu, ŋa a nthɛ a shi ntaoŋ vugu pugu chīi chrà Minnwi, ");
INSERT INTO bmo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ndɔ mfāʼo njɨ nɔ fuʼu nu pa miŋwɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yei paanchrɔ ŋgwa pɛ haʼaŋ a ni nchuʼɔ nɛ: Shemu, ŋa a ni nchhɔ̄ ligi yi ni Pita nɛ, ");
INSERT INTO bmo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ni Jɛiŋ, mbɔ muuŋ Shebedi, ni Jouŋ, mbɔ ndǐŋ Jɛiŋ, ŋa a ni nchhɔ̄ ligi yugu ni Boanegeshi, njiŋ yi pɔ ŋa, “Puoŋ ŋgwara mbɨ̀” ");
INSERT INTO bmo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ni Andru, pugu Fili, ni Batolomiu, pugu Matio, ni Toma, ni Jɛiŋ mbɔ muuŋ Afioshi, ni Tadio, ni Shemu ŋa a kwìni laʼa nɛ, ");
INSERT INTO bmo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Judashi Ishikario ŋa a ni mfīni vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nɛnnɛ Jishɔ ghə̄ɨ laʼa, yú ŋgwa pɨnɨ ŋkɨrɨ ŋkamuʼɔŋ ti paʼa a lɔ mfāʼo shɨna pugu pa ghaŋ younjiŋ pi nɔ jɨ nu maoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pa ndaaŋoŋ yi ni ŋga njaʼo, ntaoŋ mbhi lɨʼɨ wɛ̄iŋ vi, nthɛ ŋa pugu ni nchhu nu ŋa, “A paapaa.” ");
INSERT INTO bmo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi ŋa pugu ni shwiʼi llɔ Jerushalɛiŋ nɛ chhu ŋa, “Bɛjɛbu pɔ mbɨŋ yu, a fuʼu pa miŋwɛiŋ pi ni ghrɨ́ nthishɨ pa miŋwɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nɛnnɛ, Jishɔ gɛ̄ vugu pugu thɔ yəɨ yu, a chrā ni pugu moŋ luʼɔ chrà, “Mimfɛ Shata kie nɛiŋ mfuʼu Shata mbɨŋ ŋoŋ? ");
INSERT INTO bmo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","T̈aʼa laʼataoŋ ŋgrā noŋ yi moŋ pa kwíe, nthɔ māʼaŋ nchhɔ̀ ni noŋ pugu, kaŋ mbaʼa laʼataoŋ ghɔ yiʼi ntithi. ");
INSERT INTO bmo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ti ẗaʼa nda mbɔ pi moŋ minduoŋnduoŋ, kaŋ mbaʼa nda ghɔ yiʼi ntithi. ");
INSERT INTO bmo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ti S̈hata ndɔllɔ nɔ māʼaŋ nu noŋ yi ni nchhɔ̀, ndɔ mbɔ moŋ minduoŋnduoŋ, kaŋ lūgwi nu mi para. ");
INSERT INTO bmo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ndɔ mbaʼa yichəɨ ŋoŋ nii nda ŋgaŋ ghrɨ́, ntiɛŋ maoŋ pi ŋgə̄ɨ nɔ ghɔ, ki lɔ mfǔoŋ ŋkrao ŋgaŋ ghrɨ́ ghɔ. A wuʼɔ kəʼɨ ghɔ ŋa minthɛ a tiɛŋ maoŋ pi ntaoŋ nɔ nda yu. ");
INSERT INTO bmo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Shishini ǹshwei vəɨ, Minnwi shi ndīʼɛ ŋguoŋ phɨ ŋa ŋgwamishua chwīe nɛ, pugu pa sheshe chrà nchɨʼəshə ŋa a taoŋ nchò pugu nɛ, ");
INSERT INTO bmo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ndɔ shesheŋoŋ ŋa a chɨ̄ʼə Jijwɛ Minnwi nɛ, mbaʼa Minnwi ma ndīʼɛ phɨ yi, nthɛ ŋa a chwīe phɨ ki līʼɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A ni nchhu nnɛ nthɛ ŋa pugu ni nchhu nu ŋa, “A fāʼo jijwɛ pɨphɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mǔuŋ Jishɔ pugu pa lǐŋ pi pi pimbia thɔ nthi mbhi ntaoŋ ŋkɨ̀nɨ ŋa pi mɛ̄iŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yú ŋgwa ni nchɔchhɔ yəɨ yu, nnɛ pugu chhu ghɔ ŋa, “Mǔuŋ ghɔ pugu pa lǐŋ pɔ pi pimbia pɔ nɛ mbhi ntāʼa nu njəɨ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jishɔ khwɛ̄ ŋa, “Mǔuŋ a pugu pa lǐŋ paŋ pɔ pi pa gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A pɛʼi pa ŋgwa pɛ ŋa pugu chɔchɔ ŋgɨ̄ŋ vi mbāoŋ nɛ, nchhu ŋa, “Mǔuŋ a pugu pa lǐŋ paŋ pi pimbia pɔ nɛiŋ hɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Shesheŋoŋ ŋa a chwīe nnu ŋa Minnwi tāʼa nu nɛ, a ndǐŋ a vi mimbia pugu pa ndǐŋ a vi miŋgwɛ ni mǔuŋ a.” ");
INSERT INTO bmo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jishɔ pɨnɨ nuʼuŋ njɛ̄ yɛʼi nu ŋkɨŋ mmɛ ŋkhǐ ŋkamuʼɔŋ, ŋkiɛŋ mmɛ yú ŋgwa kɨrɨ yəɨ yu, nnɛ a ni nii nchɔchhɔ pi moŋ kikuoŋ moŋ ŋkhǐ, yú ŋgwa pighɔ pɔ ŋkɨŋ ŋkhǐ lɨʼɨ yó. ");
INSERT INTO bmo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A ni njɛʼi vugu ni ntou pa nnu moŋ luʼɔ chrà, moŋ pa nnu haʼaŋ a ni njɛʼi nu nɛ, a ni nchhu ni pugu ŋa. ");
INSERT INTO bmo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“P̂əɨ yaʼo! Ŋoŋ chəɨ ni ma mbɔ fɔ ŋgə̄ɨ lɨʼɨ māʼaŋ mbhɛ̌. ");
INSERT INTO bmo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nɔ haʼaŋ a ni māʼaŋ nu nɛ, pichəɨ gū shhɛmbua, pa mishi shwiʼi ŋkru. ");
INSERT INTO bmo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pichəɨ gū moŋ shhɛ ŋkwá, lɨʼɨ haʼaŋ ntou nchíʼa shi ki lɔ mbɔ nɛ, njiʼa ŋkɛkhɛ nthɛ ŋa nchíʼa shi ki lɔ njiɛŋ fɔ, ");
INSERT INTO bmo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ndɔ minaoŋ ghà nthɛ, ntūoŋ vi, nthɛ ŋa a shini ndɔ mfāʼo ŋǐeŋ yi nɛ, a kāʼo mbraoprao ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pichəɨ mbhɛ̌ gū moŋ shishaʼa, shishaʼa yīʼɛ ŋkuʼɔ mfīgi vi, paʼa a lɔ ŋkuʼɔ ti njuŋ ntíɛŋ. ");
INSERT INTO bmo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ndɔ pichəɨ pa mbhɛ̌ gū moŋ shhɛ shiʼi, ŋkhɛ̄ ŋkuʼɔ njuŋ. Pichəɨ yuŋ trɛi wuŋ, pichəɨ ntɨgao wuŋ, pichəɨ taʼa ŋkɨɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jishɔ lūgwi ŋa, “Ŋoŋ ŋa a fāʼo tə́nə nɛ, â yaʼo.” ");
INSERT INTO bmo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ndɨɨ ŋa Jishɔ ni mbɔ təʼɨ vi nɛ, ŋgwa haʼaŋ pugu ni mbɔ yəɨ yu nɛ, pugu pa paanchrɔ ghaŋ younjiŋ pi thɔ njəɨ vi mbie vi ni njiŋ pa luʼɔ chrà pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A chhu ni pugu ŋa, “Minnwi tūgu pa nnu ŋa a ni mbɔ yi lə̄ɨŋ moŋ Shaʼafuoŋ yi ni pəɨ, ndɔ ni ŋgwa nduoŋ ŋa pugu lɔ njiʼi mbiŋ nɛ, ŋguoŋ nnu pɔ pi moŋ pa luʼɔ chrà, ");
INSERT INTO bmo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nnɛ ŋa, ‘Pugu shi nja ndīi ndɔ paʼa ndɔ njəɨ, Pugu shi nja njwɛrɛ, ndɔ paʼa ndɔ njaʼo nji kiɛŋ nɛnnɛ, kaŋ pugu shi mbāʼa ŋkǔnu yugu ni phɨ, Minnwi līʼɛ phɨ yugu.’ ” ");
INSERT INTO bmo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jishɔ pie vugu ŋa, “Pəɨ lɔ nji njiŋ luʼɔ chrà yei? Ti pəɨ shi ŋkie pi nɛiŋ nji njiŋ ŋguoŋ pa luʼɔ chrà? ");
INSERT INTO bmo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ŋgaŋ māʼaŋ mbhɛ̌ māʼaŋ pi chrà Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pichəɨ pa ŋgwa ŋa pugu yaʼo chrà Minnwi nɛ pɔ pi nɔ mbhɛ̌ ŋa a gū shɛmbua. Pugu gha njaʼo, Shata kāʼo ndɔ ntɔthɔ mfuʼu chrà ghɔ ŋa pi chhu ni pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wuʼɔ nɛnnɛ, pichəɨ pa ŋgwa haʼaŋ pugu yaʼo chrà Minnwi nɛ pɔ nɔ pɛ mbhɛ̌ ŋa a gū moŋ shhɛ ŋkhwā nɛ. Pugu gha njaʼo chrà Minnwi, ŋkiʼi mbiŋ piŋ ni pwatua. ");
INSERT INTO bmo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ndɔ paʼa ŋǐeŋ yugu lɔ ntɨnɨ, piŋ yugu wuʼɔ mbɔ pi nɔ kuo ndɨɨ, nnɛ ndɨɨ ŋa ŋgəʼɨ pugu pa mōoŋ nu thɔ nthɛ chrà Minnwi nɛ, pugu kāʼo mbāʼa ŋkǔnu yugu paʼa nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pichəɨ pa ŋgwa haʼaŋ pugu yaʼo chrà Minnwi nɛ pɔ nɔ pɛ mbhɛ̌ ŋa pi māʼaŋ a gu moŋ shishaʼa nɛ, ");
INSERT INTO bmo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ndɔ pa ghaghana nthɛ maoŋ nɔ yru nu moŋ yei chɔmbhi, pugu pa mifɨɨ ŋa pa fāʼo ghà nthɔ nɔ nɛ pugu pa shɔ̄rɔ nu pichəɨ pa maoŋ nduoŋ, nii njùʼɔ pugu mfīgi chrà ghɔ pugu kara mbɔ nɔ thɨ ki yuŋ ntíɛŋ. ");
INSERT INTO bmo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ndɔ pɛ mbhɛ̌ maoŋ ŋa pi ni māʼaŋ moŋ shhɛ shiʼi nɛ pɛ ŋgwa haʼaŋ pugu yaʼo chrà Minnwi, mbiŋ ndɔ njuŋ ntíɛŋ, pichəɨ trɛi wuŋ, pichəɨ ntɨgao wuŋ, pichəɨ taʼa ŋkɨɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jishɔ ghə̄ɨ shhɨ nchhu ŋa, “Yichəɨ ŋoŋ pɔ fɔ ŋa a ghà nii ni truka nda niʼiŋ laʼo mikru, ki laʼo kúoŋ, ki lɔ nūʼɔŋ pi ŋkuoŋ lɨʼɨ thi truka? ");
INSERT INTO bmo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","“Yichəɨ yaoŋ lɔ mbɔ fɔ ŋa pi lə̄ɨŋ ŋa mbaʼa pi ma mieŋ ki nōoŋ lɨʼɨ wo, ki nnu ŋa pi kuru ŋa mbaʼa a ma mieŋ ki taoŋ lɨʼɨ liʼɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jishɔ lūgwi ŋa, “S̈hesheŋoŋ mfāʼo tə́nə, â yaʼo.” ");
INSERT INTO bmo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A pɨnɨ nchhu ni pugu ŋa, “Pəɨ ywɛrɛ nnu haʼaŋ pəɨ yaʼo nɛ shiʼi. Yaoŋ ŋa pəɨ fɨʼɨ yaoŋ nɔ ghɔ mfɛ ni ŋoŋ nɛ, Minnwi shi ŋguʼɔ mfɨ̄ʼɨ pi moŋ ghɔ mfɛ ni pəɨ, ndɔ ŋguʼɔ mbɨnɨ mbīgi ntou yi ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nthɛ ŋa ni ŋoŋ ŋa a fāʼo nɛ, Minnwi shi mbīgi ntou yi, ndɔ ni ŋoŋ ŋa a lɔ mfāʼo nɛ, Minnwi shi ŋkwe shɨgɛi yɛ ŋa a fāʼo nɛ mbhɔ yu.” ");
INSERT INTO bmo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jishɔ ghə̄ɨ shhɨ nchhu ŋa, “Yei nɔ haʼaŋ Shaʼafuoŋ Minnwi pɔ nɛ. Ŋoŋ lɔ̄gɔ mbhɛ̌ yaoŋ māʼaŋ, ");
INSERT INTO bmo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ndhɛ nu ŋgūʼu nu moŋ pa tuʼu pugu pa naoŋchɨ, moŋ ŋguoŋ ndɨɨ ghɔ, mbhɛ̌ ghɔ khɛ̄ ŋkuʼɔ ndɔ paʼa a lɔ nji ŋkwaŋ haʼaŋ a kie nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Shhɛ ghɔ chwīe mbhɛ̌ ghɔ kuʼɔ njuŋ, fǔoŋ yaoŋ pɔ ŋa a tua, mbra yi pɔ ŋa ŋkwéi yi taoŋ, nɛnnɛ ntíɛŋ yuŋ ŋkuoŋ ŋkwéi yi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ndɨɨ ŋa ntíɛŋ ghɔ tɨnɨ nɛ, a kāʼo njɛ̄ pi kwōo nu nthɛ ŋa ndɨɨ kwōo kāʼo.” ");
INSERT INTO bmo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jishɔ pie ŋa, “Mimfɛ pia māʼaŋ fɨʼɨ Shaʼafuoŋ Minnwi pi ni khɔ, pia shi mfɨ̄ʼɨ pi ni yəɨ luʼɔ chrà? ");
INSERT INTO bmo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A pɔ pi nɔ mbhɛ̌ yaoŋ mbɔ ŋkiɛŋ yi gɛ, ŋa ndɨɨ ŋa pi thɔ mbhī vi nɛ, a pɔ ndugwi mbhɛ̌ ŋa a yi gɛ nɛ ŋkuoŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ndɔ ti ndɨɨ ŋa pi phi vi nɛ, a kuʼɔ ŋgū ŋkiɛŋ ndugwi mmɛ thɨ, ŋgāʼo nchaa ŋguoŋ maoŋ phi ghao moŋ nyìeŋ ghɔ, mfuʼu mɛmmɛ mbhɔ pi, nnɛ pa mishi thɔ ŋkrao nda pugu ŋkuoŋ pa mbhɔ pi.” ");
INSERT INTO bmo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jishɔ shwei chrà Minnwi ni pugu moŋ ntou pa luʼɔ chrà nɔ pei, nɔ fɨʼɨ haʼaŋ a nthɛ pugu yaʼo nji nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jishɔ ni nshwei chrà Minnwi ni yú ŋgwa wuʼɔ moŋ pa luʼɔ chrà, ndɔ ndɨɨ ŋa a ni ŋguʼɔ mbɔ pi pugu pa ghaŋ younjiŋ pi nɛ, a fɨ̄ʼɨ ŋguoŋ nnu ntūgu ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A ni ŋga mbɔ ni fanaoŋ llɛ́ ghɔ, Jishɔ chhu ni pa ghaŋ younjiŋ pi ŋa, “Pia shāʼa ntaoŋ njiɛŋ hiŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pugu mieŋ yú ŋgwa pighɔ ndɔ̄gɔ vi wuʼɔ nɔ haʼaŋ a ni mbɔ nɛ moŋ kikuoŋ pugu pugu ghə̄ɨ. Pichəɨ pa kikuoŋ nduoŋ ni mbɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mmɛ fiŋ gū moŋ ŋkhǐ, ntuŋ ŋkhǐ niʼiŋ moŋ kikuoŋ ti kikuoŋ thɔ ndɨnaoŋ lɨnaoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jishɔ ni mbɔ laʼo kikuoŋ, nūʼɔŋ thɔ yi ŋkuoŋ nuʼɔŋthɔ nthɔ ndhɛ nu, pugu thɔ ŋgūʼu vi nchhu ghɔ ŋa, “Masha, pia ŋkhu paʼa a lɔ mbɔ nnu vɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jishɔ lɔllɔ tɔthɨ mbɨ̄ga fiŋ ghɔ, nchhu ni ŋkhǐ ŋa, “Ghɨghrɨ pɔ! Tithi!” Fɨfrəɨ ghɔ tithi, lɨʼɨ ya njū. ");
INSERT INTO bmo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A chhu ni pugu ŋa, “Pəɨ pɔgɔ pi gu khɔ? Pəɨ wuʼɔ mbiʼi ki lɔ mfāʼo piŋ?” ");
INSERT INTO bmo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pɔgɔ gu nii vugu, pugu chhu ni noŋ pugu ŋa, “Ŋoŋ vei pɔ pi gɔ̌ kiʼɛ ŋa fiŋ pugu pa ŋkhǐ yaʼo nchò yi nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jishɔ pugu pa ghaŋ younjiŋ pi shāʼa ŋkhǐ Galili ntaoŋ njiɛŋ hini moŋ krao ŋgei laʼataoŋ pa ŋgwa Gerasha. ");
INSERT INTO bmo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","A ni ŋga ntaoŋ moŋ kikuoŋ ghɔ nchəɨŋ mbhi, mbāoŋ pugu ŋoŋ chəɨ chomilaoŋ ghɔ ni jijwɛ pɨphɨ mbɨŋ yu. Ŋoŋ ghɔ ni ntaoŋ moŋ pa lɨʼɨ haʼaŋ pi ghà ntwei ŋgwa nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ŋoŋ ghɔ ni ndaʼa pi moŋ lɨʼɨ twei ŋgwa. A kaŋ ni mfɛ paʼa yichəɨ ŋoŋ lɔ ŋkrao vi, njiʼi nthɛ pi ni chɛiŋ, ");
INSERT INTO bmo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","nthɛ ŋa moŋ yiɛŋ ndɨɨ pi ni nthɔ ŋkrao mbhɔ mi ni chɛiŋ, ŋgwɛ kipaʼo nɔ kwò mi, ndɔ a tɨnɨ chɛiŋ ghɔ, mbɨnɨ mbəʼɨ kipaʼo ghɔ kɨkrɨ, ndɔ paʼa yichəɨ ŋoŋ lɔ mbɔ ŋa a kaŋ ni mfɛ a wɛ̄iŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A ni nthɔ mbaʼo ŋgòu ni tuʼu pugu pa naoŋchɨ moŋ pa lɨʼɨ twei ŋgwa pugu pa ŋkuoŋ mbra, nthɔ nshe noŋ yi ni ŋgùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","A ni ŋga njəɨ Jishɔ fie hiŋ, ntei ŋgə̄ɨ ŋgū ni kwɛ́rɛ yi shhɨ yu. ");
INSERT INTO bmo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mbaʼo ŋkiɛŋ mmɛ ŋgòu nchhu ŋa, “Pia fāʼo pi khɔ, Jishɔ Muuŋ Minnwi ŋa a chaapifuoŋ nɛ, m̀baʼo mbhɔ shhɨ ghɔ ni ligi Minnwi, kiʼi niʼiŋ moŋ ŋgəʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nthɛ ŋa Jishɔ ni nthɔ nchhu nu ghɔ ŋa, “Taoŋ mbɨŋ ŋoŋ vei, ma gɔ̀ jijwɛ pɨphɨ yei.” ");
INSERT INTO bmo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jishɔ pie vi ŋa, “Ligi yɔ khɔ?” A khwɛ̄ ŋa, “Ligi a Káʼa Yi, nthɛ ŋa pigi ntou yigi.” ");
INSERT INTO bmo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A ghə̄ɨ shhɨ ndɨ̄gəɨ vi ŋkiɛŋ ntou yi ŋa kiʼi a fuʼu vugu moŋ laʼataoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ŋkiɛŋ mmɛ kwíe ŋkunyaŋ ni njɨ nu ŋkɨŋ mbra fɔ. ");
INSERT INTO bmo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nɛnnɛ, pugu lɨ̄gəɨ Jishɔ ŋa, “Ntaoŋ vigi ni pa ŋkunyaŋ pinɛ, pigi nii mbɨŋ pugu”. ");
INSERT INTO bmo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nɛnnɛ, a fɛ shɨna ni pugu, pa jijwɛ pɨphɨ pighɔ taoŋ nii mbɨŋ pa ŋkunyaŋ pighɔ. Ŋguoŋ kwíe ŋkunyaŋ pighɔ, pugu ni mbɔ yaoŋ nɔ paa ŋkaŋ yugu, ntei ntaoŋ thɔ mbra ghɔ ŋkɨŋ ŋkhǐ nɛ nshwiʼi ŋgū moŋ ŋkhǐ, ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pa ghaŋ kɛ̄ʼi ŋkunyaŋ pighɔ tei ŋgə̄ɨ nchhu moŋ laʼa pugu pa moŋ ŋgunu. Ŋgwa taoŋ lɨʼɨ thɔ njəɨ nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pugu thɔ mbara Jishɔ, njəɨ ŋoŋ ghɔ ŋa pa jijwɛ pɨphɨ pighɔ ni mbɔ mbɨŋ yu nɛ a chhɔ fɔ, māʼaŋ ndhwí, lɨna yi pɔ shiʼi, mbɔ ŋoŋ ghɔ ŋa a ni mfāʼo kaʼa jijwɛ pɨphɨ pighɔ nɛ, pugu fāʼo pɔgɔ gu. ");
INSERT INTO bmo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ŋgwa pɛ ŋa pugu ni njəɨ nnu ŋa a ni ndɔ̄gɔ lɨʼɨ nɛ fɨ̄ʼɨ nnu ŋa a ni ndɔ̄gɔ lɨʼɨ mbɨŋ ŋgaŋ miŋwɛiŋ ghɔ pugu pa ŋkunyaŋ nɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pugu jɛ̄ nthɔ ndɨ̄gəɨ Jishɔ ŋa a mieŋ krao lɨʼɨ yugu ghɔ ŋgə̄ɨ ni vhi. ");
INSERT INTO bmo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ndɔ haʼaŋ Jishɔ ni ndɔllɔ nii nu moŋ kikuoŋ nɛ, ŋoŋ ghɔ ŋa a ni mfāʼo miŋwɛiŋ nɛ lɨ̄gəɨ vi ŋa a mieŋ a thɔ pugu yu ghə̄ɨ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jishɔ lāa, nchhu ghɔ ŋa, “Ghə̄ɨ mbara pa taannu pɔ laʼa, nshwei vugu ni fɨʼɨ nnu ŋa Taathɔ chwīe mbɨŋ ghɔ nɛ, pugu pa fɨʼɨ ŋkwaŋ nɔ haʼaŋ a nōoŋ kwoshɨnɨ vɛ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ŋoŋ ghɔ lɔllɔ ŋgə̄ɨ moŋ Dekapoli nthɔ nchīi fɨʼɨ nnu ŋa Jishɔ chwīe mbɨŋ yu nɛ, ŋguoŋ ŋgwa ghrāo. ");
INSERT INTO bmo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jishɔ ni ŋga ŋkwo pɨnɨ shāʼa moŋ kikuoŋ ntaoŋ njiɛŋ hiŋ ŋkɨŋ ŋkhǐ, ŋkiɛŋ ntou yú ŋgwa kɨrɨ yəɨ yu. ");
INSERT INTO bmo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","A gha ndara, Jairu, mbɔ taʼa mmɛŋoŋ moŋ nda luoŋ Minnwi chəɨŋ. A ni ŋga njəɨ Jishɔ, ŋgū shhɛ shhɨ yu, ");
INSERT INTO bmo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ndɨ̄gəɨ vi, nchhu nu ŋa, “Muuŋ a yi miŋgwɛ chhɔ ŋkhu nu. Thɔ nūʼɔŋ mbhɔ yɔ mbɨŋ yu, nnɛ ŋa a nthɛ ghɨ̌nɔ yi mmɛ a pɔ yi maoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","A ghə̄ɨ pugu yu. Ŋkiɛŋ mmɛ yú ŋgwa yōu njiŋ yi, nthɔ mfra vi moŋ ŋguoŋ ŋgei ghao. ");
INSERT INTO bmo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Shɨna ŋgwa pei, miŋgwɛ chəɨ ni mbɔ fɔ ŋa a ki yəɨ ndɨɨ yi ni njɨ nɔ paanchrɔ ŋgaʼo. ");
INSERT INTO bmo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A ni ŋkwo yəɨ ŋgəʼɨ ntou yi mbhɔ ntou pa ghaŋ fhɔ̌, ŋkwo tūoŋ ŋguoŋ mbɨŋ yi ghao, paʼa noŋ yi lɔ njo, a ka wɛʼiwɛʼi. ");
INSERT INTO bmo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A ni ŋkwo yaʼo pa nnu nɔ ligi Jishɔ, nthɔ njiŋ Jishɔ moŋ yú ŋgwa pighɔ ŋkāoŋ ndhwí yi. ");
INSERT INTO bmo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nthɛ ŋa a ni chhu ŋa, “M̈i njiʼi ŋguʼɔ ŋkaoŋ pi ndhwí yi, noŋ a tɔgɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wuʼɔ chomilaoŋ ghɔ, ndɨɨ yi ghɔ kāʼo ti pi thi, a yaʼo moŋ noŋ yu ŋa ghɨ̌nɔ yi tɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jishɔ yaʼo moŋ noŋ yu ŋkwaŋ nɔ haʼaŋ ghrɨ́ taoŋ mbɨŋ yu nɛ, ŋkiʼi nshrī noŋ yi shrī moŋ yú ghɔ mbie ŋa, “A kāoŋ gɔ̌ ndhwí a?” ");
INSERT INTO bmo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pa ghaŋ younjiŋ pi chhu ghɔ ŋa, “Ɔ yəɨ yú ŋgwa thɔ mfra ghɔ moŋ ŋguoŋ ŋgei, ɔ pɨnɨ mbie nu ŋa, ‘A kāoŋ gɔ̌ ŋkāoŋ a?’ ” ");
INSERT INTO bmo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","A kara ligi yi ndīi nɔ yəɨ nu ŋa a chwīe gɔ̌ nnu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Miŋgwɛ ghɔ gha njaʼo nnu ŋa a lɔ̄gɔ lɨʼɨ moŋ noŋ yu nɛ, ntaoŋ nthɔ shhɨ Jishɔ moŋ pɔgɔ gu ndɔ ŋgrū nu, nshwei vi ni ŋguoŋ nnu shini ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nɛnnɛ, Jishɔ chhu ghɔ ŋa, “Muuŋ a, piŋ yɔ chwīe ghɨ̌nɔ yɔ tɔgɔ, ghə̄ɨ ni gɔ̀ moŋ ghɨghrɨ Minnwi, pi yɨ̄gɨ ghɨ̌nɔ yɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ndɔ haʼaŋ a ni ŋguʼɔ nchrā nu nɛ, ŋoŋ llɔ nda mmɛŋoŋ moŋ nda luoŋ Minnwi ghɔ thɔ nchhu ghɔ ŋa, “Muuŋ ghɔ kwo khu. Ɔ pɨnɨ nuʼuŋ ŋgana Masha ŋgə̄ɨ nu shhɨ pi ŋa?” ");
INSERT INTO bmo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ndɔ paʼa Jishɔ lɔ mfāʼo ndɨɨ ni nnu ŋa pugu chhu nɛ, ŋka chhu ni mmɛŋoŋ ghɔ moŋ nda luoŋ Minnwi nɛ pi ŋa, “Kiʼi mbɔgɔ, wuʼɔ nthɔ mfāʼo pi piŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Paʼa a lɔ mbiŋ shesheŋoŋ thɔ njiŋ yu ŋkiɛŋ Pita, ni Jɛiŋ pugu Jouŋ ndǐŋ Jɛiŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pugu ni ŋga nchəɨŋ moŋ nda mmɛŋoŋ ghɔ moŋ nda luoŋ Minnwi nɛ, Jishɔ yəɨ vuvuʼu fiŋthɔ pugu pa ŋgwa haʼaŋ pugu ŋkə̄ɨ nu ndɔ njūa nu ŋkiɛŋ ni njɨ. ");
INSERT INTO bmo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jishɔ gha nii nda, nchhu ni pugu ŋa, “A chwīe khɔ pəɨ thɔ fāʼo vuvuʼu fiŋthɔ ndɔ ŋkə̄ɨ nu, muuŋ ghɔ lɔ ŋkukhu, a lɛllɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pugu gwɛ̄ vi, ndɔ a fuʼu vugu ghao mfɛ mbhi, ndɔ̄gɔ wuʼɔ tǎa muuŋ ghɔ pugu mǔuŋ vi pugu pa trɛi ŋgwa pɛ ŋa pugu pugu ni nthɔ nɛ, pugu pugu nii moŋ njiɛŋ nda ŋa muuŋ ghɔ ni nūaŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A wɛ̄iŋ mbhɔ yi, nchhu ghɔ ŋa, “Talita kumi,” njiŋ yi pɔ ŋa, “Miyaa, ǹchhu vɛ ŋa lɔllɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wuʼɔ chomilaoŋ ghɔ, muuŋ miŋgwɛ ghɔ ŋa a ni mbɔ paanchrɔ ŋgaʼo nɛ lɔllɔ njɛ̄ nyīeŋ nu. Yei nnu ni ŋga ndɔ̄gɔ lɨʼɨ, ŋguoŋ yugu ghao ghrāo. ");
INSERT INTO bmo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ndɔ Jishɔ shūu tə́nə yugu ŋkiɛŋ yie ghɔ ŋa kiʼi pugu chwīe shesheŋoŋ ji, ndɔ nchhu ni pugu ŋa pi fɛ yaoŋ ghɔ a jɨ. ");
INSERT INTO bmo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jishɔ lɔllɔ fɔ ŋgə̄ɨ moŋ yugu laʼataoŋ, pa ghaŋ younjiŋ pi yōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","A gha mbɔ llɛ́ ji pa Juu, a jɛ̄ yɛʼi nu moŋ nda luoŋ Minnwi, ntou ŋgwa ŋa pugu ni njaʼo vi nɛ ghrāo, nchhu nu ŋa, “Ŋoŋ vei yɛʼi yei nnu pi hɨŋ? A fāʼo fɨʼɨ shiethɔ yei pi llɔ hɨŋ? A fāʼo yei ghrɨ́ pi hɨŋ nɔ chwīe nu pa nnu ghraoghrao pei nɔ ghɔ? ");
INSERT INTO bmo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yei lɔ mbɔ kaminda, mbɔ muuŋ Meri, mbɔ ndǐŋ Jɛiŋ ni Joshɛshi ni Judashi ni Shemu? Pia pa lǐŋ pi pi piŋgɛ lɔ mbɔ hɛiŋ kaʼa?” Nnɛ pugu lāa vi. ");
INSERT INTO bmo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jishɔ chhu ni pugu ŋa, “Pi shiʼa nchɨ̄ʼə njəɨlɨʼɨ Minnwi ŋkiɛŋ laʼa pugu shɨna ŋgwa pi, pugu pa ji ndaaŋoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A kaŋ ni nthɛ paʼa a lɔ njiʼi nchwīe pa nnu ghraoghrao fɔ ŋkiɛŋ ŋa a ni nūʼɔŋ mbhɔ yi mbɨŋ shɨgɛi ghaŋ ghɨ̌nɔ njɨ̄gɨ ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A ni ŋgrāo nthɛ fɨʼɨ ki piŋ ŋa pugu ni mfāʼo nɛ. A ni nyīeŋ njīŋ moŋ laʼa nthɔ njɛʼi nu. ");
INSERT INTO bmo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jishɔ gɛ̄ paanchrɔ pighɔ, ntaoŋ vugu ŋa pugu ghə̄ɨ pa pi paa, mfɛ njɨ ni pugu nɔ fuʼu nu pa jijwɛ pɨphɨ. ");
INSERT INTO bmo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mfɛ gɨ́ ni pugu ŋa, “Kiʼi pəɨ lɔ̄gɔ sheshe yaoŋ nɔ haʼaŋ pəɨ ghə̄ɨ nu nɛ, ŋkiɛŋ mbìe, kiʼi pəɨ lɔ̄gɔ brɛi, ki pìɛŋ kra, ki ntuo mbɨŋ moŋ pìɛŋ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mbɨnɨ mbīgi ŋa, “Pəɨ gwɛ tra ndɔ kiʼi pəɨ tuo kwri ndhwí.” ");
INSERT INTO bmo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A chhu ni pugu ŋa, “Sheshe nda ŋa pəɨ nii fɔ nɛ, pəɨ laʼa fɔ ti shi nuʼuŋ ntaoŋ laʼataoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sheshe lɨʼɨ ŋa pi lɔ mbiŋ vəɨ fɔ nɛ, ki njwɛrɛ nnu ŋa pəɨ chhu nu nɛ, pəɨ ŋga ntaoŋ nu fɔ, pəɨ krū kwò məɨ nɔ nōoŋ nu ni pugu ŋa Minnwi pɨ̄na nnu ŋa pugu chwīe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pugu ni ntaoŋ ŋgə̄ɨ, nchīi nu ŋa ŋgwamishua pāʼa ŋkǔnu yugu ni phɨ. ");
INSERT INTO bmo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pugu ni nthɔ mfuʼu pa miŋwɛiŋ mbɨŋ ŋgwa, njùʼɔ wru mbɨŋ ntou ghaŋ ghɨ̌nɔ, nthɔ njɨ̄gɨ ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Fùoŋ Hɛrɔ ni njaʼo nnu yei, nthɛ ŋa ligi Jishɔ ni nyīeŋ ŋguoŋ lɨʼɨ. Ŋgwa chhu nu ŋa, “Jouŋ Ŋgaŋ Fɛ Ŋkhǐ pɨnɨ nuʼuŋ ŋkuʼɔ moŋ gu, a chwīe yie a fāʼo ghrɨ́ nɔ chwīe nu pa nnu ghraoghrao pei.” ");
INSERT INTO bmo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ndɔ pichəɨ chhu nu ŋa, “A Elaija.” Pichəɨ ni nthɔ nchhu yugu ŋa, “A njəɨlɨʼɨ Minnwi, nɔ taʼa njəɨlɨʼɨ Minnwi llɛshhɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ndɔ Hɛrɔ ni ŋga njaʼo nnu pei, nthɔ nchhu nu ŋa, “Jouŋ, ŋa mi ni njaʼa thɔ yi nɛ, pɨnɨ nuʼuŋ ŋkuʼɔ!” ");
INSERT INTO bmo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nduthɔ Hɛrɔ ni ŋkwo taoŋ ŋgwa pugu ghə̄ɨ ŋgwɛ̄iŋ Jouŋ mfɨ̄nɨ moŋ chə́ɨŋ nthɛ nnu Herodia mbɔ ŋgwɛ Fili ndǐŋ vi, nthɛ ŋa Hɛrɔ ni ŋgugwɛi vi. ");
INSERT INTO bmo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jouŋ ni nthɔ shwei Hɛrɔ ŋa, “A lɔ njiʼi ŋkāʼo vɛ nɔ wugwɛi nu ŋgwɛ ndǐŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodia ni mfāʼo kipɨna njùʼɔ yu nthɛ Jouŋ, nthɔ ntāʼa shɛndaoŋ nɔ jwi nu vi, ndɔ paʼa ndɔ mfāʼo shɨna, ");
INSERT INTO bmo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","nthɛ ŋa Hɛrɔ ni mbɔgɔ Jouŋ nthɛ ŋa a ni nji ŋa Jouŋ ŋoŋ taoŋtaoŋ, nnɛ, nūʼɔŋ vi nɔ haʼaŋ mbaʼa kàʼa kēe vi nɛ. A ni ŋkhwā nɔ yaʼo nu pa nnu mbhɔ Jouŋ, njiʼi nthɛ pi nɔ haʼaŋ sheshe ndɨɨ ŋa a ni njaʼo vi nɛ, nnu pighɔ tāra vi ŋkiɛŋ ntou yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ndugwi yi shɨna taoŋ llɛ́ ŋa Hɛrɔ ni nthɔ njɨ llɛ́ phí yi pugu pa kúŋ pi, ni pa thishɨ pa shoogɛ pi, pugu pa mɛmmɛ ŋgwa moŋ Galili. ");
INSERT INTO bmo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ndɨɨ ŋa muuŋ Herodia yi miŋgwɛ ni ntaoŋ shhɨ mbini pini nɛ, a pwa Hɛrɔ pugu pa ghaŋ gɛ̀ pi, fùoŋ chhu ni muuŋ miŋgwɛ ghɔ ŋa, “Pie sheshe yaoŋ ŋa ɔ khwā nɛ vəɨ m̀fɛ vɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nshwrɛ̄i pa kɨna shhɨ yu ŋa, “Sheshe yaoŋ ŋa ɔ shi mbie nɛ, njiʼi nthɛ ä nchəɨŋ pi ghrà laʼataoŋ a ǹshi mfɛ vɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Muuŋ miŋgwɛ ghɔ taoŋ mbhi, nchhu ni mǔuŋ vi ŋa, “Mi shi mbie pi khɔ?” A chhu ghɔ ŋa, “Thɔ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A kiʼi mbɨ̄nɨ pɨ̄nɨ moŋ kɔkɔnɔ wuʼɔ ndɨɨ ghɔ njəɨ fùoŋ nchhu ghɔ ŋa, “Ǹtāʼa nu ŋa ɔ fɛ thɔ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ vəɨ wuʼɔ ndwɛ ŋkuoŋ pashinja yei.” ");
INSERT INTO bmo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Fùoŋ ni nja mbɔ ni tuʼuthɔ, ndɔ nthɛ kɨ̀na ŋa a ni ŋkwo shwrɛ̄i shhɨ ghaŋ gɛ̀ pi nɛ, a shini ndɔ ntāʼa nu mbəʼɨ chrà ŋa a ni ŋkwo fɛ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wuʼɔ chomilaoŋ ghɔ fùoŋ taoŋ taʼa ŋkɛ̄ʼi vi, mfɛ gɨ́ ghɔ ŋa a ghə̄ɨ nthɔ ni thɔ Jouŋ. A ghə̄ɨ njaʼa thɔ yi moŋ chə́ɨŋ, ");
INSERT INTO bmo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","nthɔ ni thɔ yi ghɔ ŋkuoŋ pashinja, mfɛ ni muuŋ miŋgwɛ ghɔ, muuŋ miŋgwɛ ghɔ fɛ ni mǔuŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pa ghaŋ younjiŋ Jouŋ ni ŋga njaʼo yei nnu, nthɔ ndɔ̄gɔ khu yi ŋgə̄ɨ niʼiŋ moŋ fúŋ moŋ ŋgùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pa ghaŋ ntaoŋ Jishɔ gha mbɨnɨ nɔ haʼaŋ a ni ntaoŋ vugu nɛ, ŋkɨrɨ yəɨ yu, nshwei vi ni ŋguoŋ nnu ŋa pugu ni nchwīe ndɔ ntɨgɨ. ");
INSERT INTO bmo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A chhu ni pugu ŋa, “P̂əɨ taʼa lɨʼɨ haʼaŋ ŋgwa lɔ mbɔ fɔ nɛ, pia ghə̄ɨ fɔ mfɛrɛ noŋ nɔ kuo ndɨɨ.” Nthɛ ŋa ntou ŋgwa ni nthɔ nu ndɔ ŋgə̄ɨ nu pugu shini ndɔ mfāʼo shɨna fɛrɛ noŋ ti njɨ maoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pugu nii moŋ kikuoŋ ŋgə̄ɨ nɔ lɨʼɨ haʼaŋ ŋgwa lɔ mbɔ nɛ nɔ pɔ nu fɔ təʼɨ vugu. ");
INSERT INTO bmo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ndɔ ntou ŋgwa ni njəɨ vugu nji ŋa a pugu, ntei yugu ŋkuoŋ shhɛ llɔ moŋ ŋguoŋ pa laʼataoŋ ghao, mfǔoŋ pugu nchəɨŋ fɔ shhɨ Jishɔ pugu pa ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jishɔ ni ŋga ntaoŋ ŋkaoŋ mbhi, njəɨ ŋkiɛŋ mmɛ yú ŋgwa, mfāʼo kwoshɨnɨ mbɨŋ pugu nthɛ ŋa pugu ni mbɔ nɔ pa minjɨɨ ki ŋkɛ̄ʼi yugu. Nnɛ a jɛ̄ nthɔ njɛʼi vugu ni ntou nnu. ");
INSERT INTO bmo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Njiʼa ni ŋga ntɔgɔ, pa ghaŋ younjiŋ pi thɔ njəɨ vi, nchhu ghɔ ŋa, “Yei lɨʼɨ haʼaŋ ŋgwa lɔ mbɔ, ndɨɨ lɔ ŋkwo ya ntɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chhu ŋgwa pei ghə̄ɨ, nnɛ ŋa a nthɛ pugu ghə̄ɨ moŋ pa mbàŋ mbambara pugu pa moŋ laʼa njuoŋ yaoŋ fɔ njɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ndɔ a khwɛ̄ ni pugu ŋa, “Pəɨ fɛ yaoŋ pugu jɨ.” Pugu chhu ghɔ ŋa, “Pigi shi ŋgə̄ɨ njuoŋ brɛi ni fɨʼɨ mbɨŋ ŋa mimfɛ ŋoŋ fāʼa nɔ paa ŋkɨɨ llɛmbhi nɛ nthɔ mfɛ ni pugu pugu kru?” ");
INSERT INTO bmo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A pie ni pugu ŋa, “Pəɨ fāʼo ndigi brɛi yi khɔ? Pəɨ ghə̄ɨ ndīi!” Pugu ni ŋga ndīi, nchhu ghɔ ŋa, “Ndigi yi tiɛŋ ni paa shhu.” ");
INSERT INTO bmo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jishɔ fɛ gɨ́ ŋa ŋguoŋ ŋgwa pighɔ chɔchɔ ŋkuoŋ trǔ moŋ pa kwiekwie. ");
INSERT INTO bmo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pugu chɔchɔ moŋ pa kwíe, pichəɨ pɔ taʼa ŋkɨɨ, pichəɨ pɔ tiɛŋ wuŋ. ");
INSERT INTO bmo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nɛnnɛ a lɔ̄gɔ kəɨŋ brɛi ghɔ ni paa shhu, mbɨʼɨ ligi yi ndīi po, ntōo Minnwi, mbəʼɨ brɛi ghɔ mfɛ ni pa ghaŋ younjiŋ pi ŋa pugu fɛ ni pa ŋgwa pighɔ, ŋgrā paa shhu ghɔ shɨna pugu ghao. ");
INSERT INTO bmo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ŋguoŋ yugu kru ti njru. ");
INSERT INTO bmo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pugu ni ndɨ̄ga pa pəʼɨ pəʼɨ pɨgəɨ brɛi, pugu pa shhu a lɨnaoŋ paanchrɔ mikuo. ");
INSERT INTO bmo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Fɨʼɨ pa pimbia haʼaŋ pugu ni ŋkru brɛi ghɔ nɛ ni mbɔ tiɛŋ ŋkaŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wuʼɔ ndɨɨ ghɔ Jishɔ chwīe pa ghaŋ younjiŋ pi nii moŋ kikuoŋ ŋgə̄ɨ shhɨ nɔ shāʼa nu ntaoŋ njiɛŋ hiŋ moŋ Beshaida, a lara shɨgɛi nɔ chhu nu ni yu ŋgwa pighɔ ŋa pugu ghə̄ɨ laʼa. ");
INSERT INTO bmo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A gha ŋkwo chaʼa vugu, ŋkuʼɔ ŋkuoŋ mbra lɨʼɨ luoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","A ni ŋga nchəɨŋ ni fanaoŋ, kikuoŋ ni mbɔ titri ŋkhǐ, Jishɔ ni mbɔ mbhi təʼɨ vi. ");
INSERT INTO bmo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jishɔ yəɨ ŋa pugu paʼo nu ni prǎ nɔ chhwi nu kikuoŋ a ghə̄ɨ shhɨ, nthɛ ŋa fɨfrəɨ ni ntaoŋ pi shhɨ pugu. A gha mbɔ ni ndaʼa mbhi laŋ, moŋ shɨna trɛi minaoŋ pugu ntɨgao minaoŋ, a nyīeŋ nu ŋkuoŋ ŋkhǐ nthɔ nu yəɨ pugu, ntāʼa nu mfərə vugu. ");
INSERT INTO bmo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ndɔ pugu gha njəɨ vi a nyīeŋ nu ŋkuoŋ ŋkhǐ, pugu gɛ̄ ŋa a pɔ pi ŋkhushɛ, mbaʼo ŋgòu. ");
INSERT INTO bmo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nthɛ ŋa ŋguoŋ yugu ni njəɨ vi, pɔgɔ gu wɛ̄iŋ vugu, ndɔ a chrā ni pugu nchhu ŋa, “Pəɨ fāʼo wɛ̄iŋ njùʼɔ, a mmu, kiʼi pəɨ fāʼo pɔgɔ gu.” ");
INSERT INTO bmo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nɛnnɛ, a nii moŋ kikuoŋ mbara vugu, fɨfrəɨ ghɔ tithi, nnu ghɔ llwi nchò yugu. ");
INSERT INTO bmo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nthɛ ŋa thɔ yugu shini ndɔ njiʼi nshie ni nnu kugwi nu ŋgwa ni brɛi, ndɔ pugu ni mbɔ pa fɨ̄nɨ thɔ nɔ ji nu. ");
INSERT INTO bmo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pugu ni ŋga nshāʼa, ntaoŋ mbhi lɨʼɨ ŋa pi mɛ̄iŋ ni Gɛnɛsharɛ nɛ, nchu kikuoŋ yugu ŋkɨŋ ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pugu gha ntaoŋ moŋ kikuoŋ, pa ŋgwa yəɨ vi ŋkiʼi njiji, ");
INSERT INTO bmo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ntei moŋ ŋguoŋ yie krao lɨʼɨ ghao, nthɔ nu ni ghaŋ ghɨ̌nɔ ŋkuoŋ pa kúoŋ pugu nɔ lɨʼɨ ŋa pugu ni njaʼo ŋa Jishɔ pɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sheshe lɨʼɨ ŋa a ni ŋgə̄ɨ nɛ, moŋ puoŋ mi laʼataoŋ pugu pa mɛmmɛ laʼataoŋ pugu pa mooŋ ŋgunu, pugu nūʼɔŋ pa ghaŋ ghɨ̌nɔ moŋ pa taŋ, ndɨ̄gəɨ vi ŋa a mieŋ pa ghaŋ ghɨ̌nɔ pighɔ kāoŋ pi wuʼɔ muuŋ thɔ ndhwí yi. Ŋguoŋ pa ŋgwa pɛ ŋa pugu ni ŋkāoŋ nɛ, ghɨ̌nɔ yugu tɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pichəɨ pa ŋgwa Farashi pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi ŋa pugu ni ndhɔ Jerushalɛiŋ ni ŋkɨrɨ yəɨ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pugu ni njəɨ ŋa pichəɨ ghaŋ younjiŋ Jishɔ thɔ njɨ yaoŋ ni mbhɔ ki shɨ̄gao moŋ ŋkwaŋ shɛndaoŋ haʼaŋ nùʼɔŋ chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pa ŋgwa Farashi pugu pa ŋguoŋ pa ŋgwa Juu ghao shiʼa njɨ yaoŋ ki lɔ nshɨ̄gao mbhɔ yugu ŋkwaŋ haʼaŋ a pie nɛ, nnɛ nchhɔ nūʼɔŋ nùʼɔŋ pa thishɨ pugu, ");
INSERT INTO bmo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ki njɨ sheshe yaoŋ ki lɔ nshɨ̄gao noŋ nɔ haʼaŋ nùʼɔŋ chhu nɛ ndɨɨ ŋa pugu kwəɨ taŋ nɛ. Ntou pichəɨ pa nùʼɔŋ pɔ fɔ ŋa pugu ghà nūʼɔŋ, nɔ shɨ̄gao nu pa ndua pugu pa kɨ̌ŋ pugu pa pichəɨ kɨ̌ŋ tɨ́nɨ pugu pa ŋgrào ŋa pi ghà nchhɔ ŋkuoŋ njɨ maoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pa Farashi pugu pa ghaŋ yɛʼi gɨ́ Mushi pie vi ŋa, “A ghà nchwīe khɔ paʼa pa ghaŋ younjiŋ pɔ lɔ nchhɔ chɔmbhi yugu ŋkwaŋ haʼaŋ nùʼɔŋ pa thishɨ chhu nɛ, nthɔ njɨ yaoŋ ni mbhɔ ki shɨ̄gao?” ");
INSERT INTO bmo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A khwɛ̄ ni pugu ŋa, “A ŋkiɛŋ nnu shini nɔ haʼaŋ Minnwi ni nōoŋ ni Ishaya a chhu nthɛ vəɨ ma pa ghaŋ mifɨɨ pei, wuʼɔ nɔ haʼaŋ a ni nāʼaŋ ŋa, ‘A chhu ju Minnwi ŋa, Ŋgwa pei ghà ŋgaʼo a pi ni nchò yugu ndɔ paʼa njùʼɔ yugu lɔ mbara yəɨ mu, ");
INSERT INTO bmo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ghɛ̀rɛ lɔ mbɔ ni ŋgwa pei moŋ ghaʼo nu ma, nthɛ ŋa pugu yɛʼi nùʼɔŋ ŋgwamishua, pi nɔ haʼaŋ a pɔ pi gɨ́ a.’ ");
INSERT INTO bmo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pəɨ mieŋ kɨ̀na Minnwi ŋgwɛ̄iŋ pi nùʼɔŋ ŋgwamishua.” ");
INSERT INTO bmo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A pɨnɨ nchhu ni pugu ŋa, “Pəɨ fāʼo ŋkiɛŋ shɛndaoŋ nɔ lāa nu kɨ̀na Minnwi nnɛ ŋa pəɨ nūʼɔŋ yəɨ nùʼɔŋ. ");
INSERT INTO bmo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mushi ni nchhu ŋa, ‘Yaʼo nchò tǎa ghɔ pugu mǔuŋ ghɔ,’ ndɔ ‘Ŋoŋ ŋa a wɛʼi tǎa ki mǔuŋ vi nɛ, yiʼi ŋa pi shi njwi vi.’ ");
INSERT INTO bmo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ndɔ pəɨ chhu yəɨ ŋa, ‘Ŋ̈oŋ nchhu ni mǔuŋ vi ki tǎa vi ŋa yaoŋ ŋa m̀fāʼo nɔ ghɛ̄rɛ nu ghɔ nɔ nɛ pɔ pi Kobaŋ (njiŋ yi pɔ ŋa yaoŋ fɛ́ ni Minnwi)’, ");
INSERT INTO bmo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nnɛ pəɨ lɔ nuʼuŋ mbiŋ ŋa a ghɛ̄rɛ tǎa vi ki mǔuŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nnɛ nthɔ ndāa chrà Minnwi ni nùʼɔŋ yəɨ ŋa pəɨ tɨgɨ ŋgwrɛiŋgwa pəɨ nɔ ghɔ nɛ. Pugu pa pichəɨ ntou ŋkwaŋ nnu pi nɛ ŋa pəɨ chwīe.” ");
INSERT INTO bmo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jishɔ mɛ̄iŋ ŋgwa pighɔ pugu thɔ njəɨ vi, a chhu ni pugu ŋa, “P̂əɨ ywɛrɛ nnu ŋa ǹchhu nu nɛ ndɔ njaʼo. ");
INSERT INTO bmo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yichəɨ yaoŋ lɔ mbɔ fɔ ŋa ä nii mbɨŋ ŋoŋ llɔ mbhi a fuo vi, a ka pɔ pi yaoŋ ŋa a taoŋ moŋ noŋ ŋoŋ nɛ ŋa minthɛ a fuo vi.” ");
INSERT INTO bmo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Shesheŋoŋ ŋa a fāʼo tə́nə yaʼo.” ");
INSERT INTO bmo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A ni ŋga mieŋ yu ŋgwa pighɔ nii nda, pa ghaŋ younjiŋ pi chhu ghɔ ŋa a shwei njiŋ luʼɔ chrà ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A chhu ni pugu ŋa, “Pəɨ wuʼɔ mbou pi lɨna ŋkaa pəɨ? Pəɨ lɔ naa njəɨ ŋa sheshe yaoŋ ŋa a llɔ mbhi nii mbɨŋ ŋoŋ nɛ nthɛ paʼa a lɔ mfuo vi. ");
INSERT INTO bmo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nthɛ ŋa a lɔ njiʼi ŋgə̄ɨ pi njùʼɔ yu, a ghə̄ɨ pi puŋ yu ntiri ntaoŋ nii moŋ krao.” (Nnɛ nchīi ŋa ŋguoŋ maoŋ jɨ yi taoŋtaoŋ.) ");
INSERT INTO bmo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nchhu ŋa, “A yaoŋ ŋa a taoŋ moŋ noŋ ŋoŋ nɛ ŋa a fuo vi. ");
INSERT INTO bmo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nthɛ ŋa llɔ moŋ ghɔ, moŋ njùʼɔ ŋoŋmishua, pa kwàʼa pɨphɨ ghà ntaoŋ, nɔ pa kwoshuoŋ, ŋgɨna, jwi nu ŋoŋ, ");
INSERT INTO bmo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","shúoŋ mbhɔ ghaŋ láŋ, lúa, mbha nnu pɨphɨ, mifɨɨ, pa nnu tɔtrɔ, kighɨʼə, chhu nu phɨ thɔ ŋgwa, ntitaʼo, mbha nnu na. ");
INSERT INTO bmo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ŋguoŋ pa nnu pɨphɨ pei ghà ntaoŋ pi moŋ noŋ ŋoŋ, mfuo ŋgaŋ vi.” ");
INSERT INTO bmo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jishɔ ni ndhɔ fɔ ŋgə̄ɨ krao ŋgei Tairɛ. A ni nii moŋ nda paʼa ndɔ ntāʼa nu ŋa shesheŋoŋ ji, ndɔ paʼa shɛndaoŋ lɔ mbɔ ŋa a kaŋ ni mfɛ a lɛrɛ. ");
INSERT INTO bmo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wuʼɔ ndɨɨ ghɔ, miŋgwɛ chəɨ ŋa jijwɛ pɨphɨ ni mbɔ mbɨŋ muuŋ vi yi miŋgwɛ nɛ ni njaʼo ŋa a pɔ, nthɔ ŋgū laʼo kwò Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Miŋgwɛ vei ni mbɔ miŋgwɛ taoŋ nduoŋ, llɔ krao ŋgei Fonishia moŋ Shiria. Ndɨ̄gəɨ Jishɔ ŋa a fuʼu miŋwɛiŋ mbɨŋ muuŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jishɔ khwɛ̄ ŋa, “A pie ŋa pi fǔoŋ kugwi pa puoŋ ŋkaoŋ nthɛ ŋa a lɔ njiʼi ŋkāʼo nɔ lɔ̄gɔ nu maoŋ jɨ puoŋ māʼaŋ ni pa miŋgu.” ");
INSERT INTO bmo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Miŋgwɛ ghɔ khwɛ̄ ŋa, “Ooŋ, ma Taathɔ, ndɔ njiʼi nthɛ pi pa miŋgu ghà njɨ ŋkuʼu maoŋ puoŋ laʼo taprɛi.” ");
INSERT INTO bmo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jishɔ chhu ghɔ ŋa, “Nthɛ yinɛ ndigi chrà, minthɛ ɔ ghə̄ɨ ni gɔ, miŋwɛiŋ ghɔ kwo taoŋ mbɨŋ muuŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A pɨ̄nɨ laʼa, njəɨ muuŋ ghɔ a nūaŋ kúoŋ, miŋwɛiŋ ghɔ kwo taoŋ mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A pɨ̄nɨ llɔ moŋ krao ŋgei Tairɛ, nyīeŋ ntiri moŋ Shidoŋ nchəɨŋ ŋkɨŋ ŋkhǐ Galili, moŋ krao ŋgei Dekapoli. ");
INSERT INTO bmo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pichəɨ ŋgwa lɔ̄gɔ yichəɨ ŋoŋ ŋa a ni mbɔ fhɨtənə ndɔ ki lɔ nchrā nu shiʼi, nthɔ mbara vi ni ju, ndɨ̄gəɨ vi ŋa a nūʼɔŋ mbhɔ yi mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jishɔ lɔ̄gɔ vi ŋgə̄ɨ nɔ lɨʼɨ təʼɨ vi, niʼiŋ mbhɔ yi tə́nə yu, ŋga nthu thwɛ, ŋkaoŋ lɨŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jishɔ pɨʼɨ ligi yi ndīi po, nshɔnɔ nchhu ni ŋoŋ ghɔ ŋa, “Ɛfata”, njiŋ yi pɔ ŋa, “Chuʼɔ!” ");
INSERT INTO bmo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tə́nə yi chuʼɔ, lɨŋ yi kɨ̄gɛi, a chrā ki kɔ̀rɔ. ");
INSERT INTO bmo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jishɔ fɛ gɨ́ ni pugu ŋa kiʼi pəɨ chhu ni shesheŋoŋ. Ndɔ fɨʼɨ ŋkwaŋ haʼaŋ a ni mbīgi gɨ́ ŋa kiʼi pugu chhu ni ŋgwa nɛ, wuʼɔ mbɔ fɨʼɨ ŋkwaŋ haʼaŋ pugu ni nchhu mbīgi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pa ŋgwa ni ŋgrāo ti a ghaʼa, nchhu nu ŋa, “A chwīe ŋguoŋ pa nnu ghao shishiʼi. A chwīe fhɨtənə yaʼo lɨʼɨ, fhɨncho chrā.” ");
INSERT INTO bmo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Moŋ pɨɨ ndɨɨ ghɔ, ntou yú ŋgwa ni ŋga mbɨ̄nɨ ŋkɨrɨ ki lɔ mfāʼo yaoŋ nɔ jɨ nu, Jishɔ mɛ̄iŋ ghaŋ younjiŋ pi nchhu ni pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“M̀fāʼo kwoshɨnɨ mbɨŋ ŋgwa pei nthɛ ŋa pigi pugu kwo chhɔ nɔ trɛi llɛ́ ki lɔ njiʼi mfāʼo yaoŋ nɔ jɨ nu. ");
INSERT INTO bmo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","M̈i mfɛ vugu laʼa ni njì, pugu taoŋ shɛndaoŋ njì māʼaŋ vugu, nthɛ ŋa pichəɨ llɔ a shɨga.” ");
INSERT INTO bmo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pa ghaŋ younjiŋ pi khwɛ̄ ghɔ ŋa, “Ŋoŋ shi njəɨ maoŋ jɨ pi hɨŋ moŋ ŋkǔnu njó yei nɔ kugwi nu fɨʼɨ ŋgwa pei nɔ ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jishɔ pie vugu ŋa, “Pəɨ fāʼo pi ndigi brɛi yi khɔ?” Pugu chhu ŋa, “Yi khwachəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A fɛ gɨ́ ni ŋgwa pighɔ ŋa pugu chɔchɔ shhɛ. Ndɔ̄gɔ khwachəɨ brɛi ghɔ ŋga ntōo Minnwi, mbəʼɨ mfɛ ni ghaŋ younjiŋ pi ŋa pugu fɛ ni pugu. Nnɛ pugu fɛ ni ŋgwa pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pugu ni mfāʼo shɨgɛi puoŋ mi shhu, Jishɔ gha ŋkwo tōo Minnwi nɔ ghɔ, mbɨnɨ mfɛ gɨ́ ŋa pi fɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pugu kru ti njru, pa ghaŋ younjiŋ pi lɨ̄ga pa pəʼɨ pɨgəɨ pi a lɨnaoŋ moŋ khwachəɨ mɛmmɛ mikuo. ");
INSERT INTO bmo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yaoŋ nɔ khwɛ ŋkaŋ ŋgwa ni mbɔ fɔ. Jishɔ chhu ni pugu ŋa pugu ghə̄ɨ laʼa. ");
INSERT INTO bmo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ŋkiʼi ndɔ nii nii ndɨɨ ghɔ moŋ kikuoŋ pugu pa ghaŋ younjiŋ pi nshāʼa ntaoŋ Dalmanuta. ");
INSERT INTO bmo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pa Farashi thɔ njɛ̄ lōu nu pugu pa Jishɔ, nchhu nu ghɔ ŋa a nōoŋ lì llɔ pɔ, nnɛ nɔ mōoŋ nu mi. ");
INSERT INTO bmo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A shɔnɔ ŋkiɛŋ yie ghɔ moŋ njùʼɔ yu, nchhu ŋa, “Ŋgwrɛiŋgwa pei tāʼa lì nthɛ khɔ? Shishini ǹshwei vəɨ ŋa mbaʼa pi nōoŋ taʼa lì ni pugu.” ");
INSERT INTO bmo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A mieŋ vugu ŋga mbɨnɨ nii moŋ kikuoŋ ŋkamuʼɔŋ nshāʼa ntaoŋ njiɛŋ hiŋ. ");
INSERT INTO bmo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pa ghaŋ younjiŋ Jishɔ līʼɛ nɔ lɔ̄gɔ nu brɛi, ŋguʼɔ mfāʼo pi taʼa yi mbhɔ pugu moŋ kikuoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jishɔ shūu tə́nə yugu, nchhu nu ŋa, “Pəɨ lɨna yishi llɔ mbhɔ pa ŋgwa Farashi pugu pa Hɛrɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pugu jɛ̄ nthɔ nchrā nu shɨna pugu nthɛ nnu brɛi ŋa pugu shini ndɔ mfāʼo nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jishɔ ji nnu ŋa pugu ni nchrā nu nɛ, nɛnnɛ mbie vugu ŋa, “A chwīe khɔ pəɨ chrā nu ŋkuoŋ nnu pou brɛi? Pəɨ lɔ nji, ki mfāʼo shiethɔ pa nnu yaʼa? Thɔ yəɨ kweikwei? ");
INSERT INTO bmo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pəɨ fāʼo ligi ki lɔ njəɨ lɨʼɨ, mfāʼo tə́nə ki lɔ njaʼo lɨʼɨ? Pəɨ shiʼa ŋkwiŋ nnu? ");
INSERT INTO bmo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ndɨɨ ŋa mi ni mbəʼɨ tiɛŋ brɛi ŋkugwi tiɛŋ ŋkaŋ ŋgwa nɔ ghɔ nɛ, pɨgəɨ pəʼɨ brɛi ŋa pəɨ ni ŋkɨrɨ nɛ ni mbɔ mikuo yi khɔ?” Pugu chhu ghɔ ŋa, “Paanchrɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ndɨɨ ŋa ŋki pəʼɨ yi khwachəɨ ŋkugwi khwɛ ŋkaŋ ŋgwa nɔ ghɔ nɛ, pɨgəɨ pəʼɨ brɛi ŋa pəɨ ni ŋkɨrɨ nɛ ni mbɔ njòu yi khɔ?” Pugu khwɛ̄ ghɔ ŋa, “Yi khwachəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A chhu ni pugu ŋa, “Thɔ yəɨ wuʼɔ mbiʼi ki lɔ naa nshie?” ");
INSERT INTO bmo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pugu ghə̄ɨ nchəɨŋ Beshaida, pichəɨ ŋgwa lɔ̄gɔ nchriligi nthɔ njəɨ vi ni ju ndɨ̄gəɨ vi ŋa a kāoŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A wɛ̄iŋ mbhɔ nchriligi ghɔ, ntaoŋ ni ju moŋ laʼa, ŋga kwo thu thwɛ nɔ ligi yi ndɔ mbɨnɨ nuʼuŋ nūʼɔŋ mbhɔ yi mbɨŋ yu mbie vi ŋa, “Ɔ yəɨ sheshe yaoŋ?” ");
INSERT INTO bmo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A pɨʼɨ ligi yi tɔthɨ nchhu ghɔ ŋa, “Njəɨ pa ŋgwa ndɔ pugu fhi pi pa thɨ nyīeŋ nu.” ");
INSERT INTO bmo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nnɛ Jishɔ pɨnɨ nūʼɔŋ mbhɔ mi nɔ ligi yi, a fēi ligi yi, ligi yi shie, a yəɨ ŋguoŋ yaoŋ shishiʼi. ");
INSERT INTO bmo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jishɔ chhu kiʼɛ a ghə̄ɨ nda yu, mfɛ gɨ́ ghɔ ŋa, “Kiʼi nii moŋ laʼa.” ");
INSERT INTO bmo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jishɔ pugu pa ghaŋ younjiŋ pi ghə̄ɨ moŋ pa laʼataoŋ moŋ Kaisharia Filipai. Pugu pugu ni ŋga mbɔ shɛndaoŋ, a pie pa ghaŋ younjiŋ pi ŋa, “Pa ŋgwa ghà nchhu ŋa mi pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pugu chhu ghɔ ŋa, “Jouŋ Ŋgaŋ Fɛ Ŋkhǐ, pichəɨ chhu ŋa ɔ Elaija ndɔ pichəɨ chhu ŋa ɔ yichəɨ taʼa njəɨlɨʼɨ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A ghə̄ɨ shhɨ mbie vugu ŋa, “Ti pəɨ chhu yəɨ ŋa mi pɔ pi gɔ̌?” Pita khwɛ̄ ghɔ ŋa, “Ɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nɛnnɛ Jishɔ shūu tə́nə yugu ŋa kiʼi pugu shwei shesheŋoŋ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jishɔ jɛ̄ nthɔ njɛʼi vugu ŋa a yiʼi ŋa Muuŋ Ŋoŋmishua shi njəɨ ŋgəʼɨ nthɛ ntou pa nnu, pa thishɨ pa Juu pugu pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi lāa vi, pi jwi vi, a gha ndaʼa trɛi llɛ́, a pɨnɨ ŋkuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nchwīe thɔ ghaŋ younjiŋ pi ya nshie ni yei nnu. Pita lɔ̄gɔ vi ŋgə̄ɨ njiŋnjiŋ nthɔ mbɨ̄ga vi. ");
INSERT INTO bmo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jishɔ gha ŋkara noŋ yi, mbɛʼi ghaŋ younjiŋ pi, mbɨ̄ga Pita nchhu ŋa, “Lɔllɔ yəɨ mu, ma Shata! Ɔ lɔ njiʼi nūʼɔŋ kwāʼa nu mɔ pi ŋkuoŋ nnu Minnwi, ɔ ka nūʼɔŋ pi ŋkuoŋ pa nnu ŋgwamishua.” ");
INSERT INTO bmo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jishɔ mɛ̄iŋ kɨrɨ ŋgwa pighɔ fɔ nchhu ni pugu ŋa, “S̈hesheŋoŋ ntāʼa nu njōu njiŋ a, a mieŋ phi nnu haʼaŋ a khwā nɛ, ntiɛŋ wáʼa yi, njōu njiŋ a. ");
INSERT INTO bmo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nthɛ ŋa shesheŋoŋ ŋa a tāʼa nu ndūgu ni chɔmbhi yi nɛ shi shiɛŋ chɔmbhi yi ghɔ, shesheŋoŋ ŋa a mīʼaŋ chɔmbhi yi nthɛ a pugu pa nthɛ pwa pishaʼakhɔ Minnwi nɛ shi ndūgu ni chɔmbhi yi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nthɛ ŋa ŋoŋmishua shi nshei pi khɔ nɔ haʼaŋ ä mfāʼo ŋguoŋ mbhi ghao ndɔ shiɛŋ chɔmbhi yi? ");
INSERT INTO bmo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Minthɛ ŋoŋ fɛ pi khɔ nɔ kwri nu chɔmbhi yi nɔ ghɔ? ");
INSERT INTO bmo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","S̈hesheŋoŋ mfāʼo lrithɔ nthɛ a pugu pa chrà a moŋ mbhi ŋgwrɛiŋgwa ki fāʼo pɔgɔ Minnwi, pugu pa ŋgwrɛiŋgwa pɨphɨ yei, kaŋ Muuŋ Ŋoŋmishua shi mfāʼo lrithɔ nthɛ vi ndɨɨ ŋa a thɔ moŋ ndighaʼo Tǎa vi pugu pa yi ghaŋ ntaoŋ Minnwi pi taoŋtaoŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jishɔ chhu ni pugu ŋa, “Shishini, ǹshwei vəɨ ŋa pichəɨ ŋgwa thi hɛiŋ ŋa mbaʼa pugu khu ki lɔ njəɨ Shaʼafuoŋ Minnwi thɔ moŋ ghrɨ́.” ");
INSERT INTO bmo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ntɨgao llɛ́ ni ŋga ntɔgɔ Jishɔ lɔ̄gɔ Pita, pugu Jɛiŋ ni Jouŋ, pugu pugu kuʼɔ təʼɨ vugu ŋkuoŋ mmɛ ntaaŋ mbra. Nɔ haʼaŋ pugu ni mbɛʼi vi nɛ, a kwri ligi pugu, ");
INSERT INTO bmo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ndhwí yi gu yi fufhu, nchīa ti ŋgaʼa, mfugu nchaa fɨʼɨ ŋkwaŋ nɔ haʼaŋ minthɛ shesheŋoŋ ŋkuoŋ mbhi shɨ̄gao nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Elaija pugu Mushi nōoŋ noŋ yugu ni trɛi ghaŋ younjiŋ Jishɔ pighɔ, nthɔ nchrā nu pugu pa Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita chhu ni Jishɔ ŋa, “Masha, a pwa ŋa pia pɔ hɛiŋ nɛ. Pigi shi ŋkrao trɛi ntǎa, taʼa yi vɛ, taʼa yi ni Mushi, taʼa yi ni Elaija.” ");
INSERT INTO bmo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nthɛ ŋa a shini ndɔ nji nnu ŋa a nthɛ a chhu nɛ, nthɛ ŋa pɔgɔ gu ni ŋgwɛ̄iŋ vugu ŋgaʼa. ");
INSERT INTO bmo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Lúluŋ kuru vugu, ŋggì taoŋ moŋ lúluŋ ghɔ ŋa, “Yei ŋkiɛŋ Muuŋ a ŋa ŋ̀khwā, p̂əɨ yaʼo mbhɔ yu.” ");
INSERT INTO bmo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pugu gha ndīi nɛ, ŋgwīʼi ki lɔ nuʼuŋ njəɨ shesheŋoŋ ŋkiɛŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nɔ haʼaŋ pugu ni nthɔ nshwiʼi mbra ghɔ nɛ, Jishɔ fɛ gɨ́ ni pugu ŋa kiʼi pugu shwei shesheŋoŋ ni nnu ŋa pugu yəɨ, ti ŋgə̄ɨ nchəɨŋ ndɨɨ ŋa Muuŋ Ŋoŋmishua shi ŋkuʼɔ moŋ gu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pugu wɛ̄iŋ ndigi chrà ghɔ, nthɔ nchrā nu ni noŋ pugu ŋa, “Njiŋ kuʼɔ nu moŋ gu yei pɔ pi ŋa?” ");
INSERT INTO bmo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pugu pie Jishɔ ŋa, “A chwīe khɔ pa ghaŋ yɛʼi gɨ́ Mushi chhu nu ŋa Elaija shi fǔoŋ nthɔ ŋkaoŋ?” ");
INSERT INTO bmo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A khwɛ̄ ni pugu ŋa, “Shishini Elaija shi fǔoŋ nthɔ nɔ pīri nu pa nnu a kāʼo. Ndɔ a chwīe khɔ Ŋwaʼaŋlɨ Minnwi chhu ŋa Muuŋ Ŋoŋmishua shi njəɨ ntou ŋgəʼɨ, ndɔ pi lāa vi? ");
INSERT INTO bmo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ndɔ ǹshwei vəɨ ŋa Elaija kwo thɔ ŋgwa fāʼa mbɨŋ yu nɔ haʼaŋ pugu khwā nɛ, nɔ haʼaŋ Ŋwaʼaŋlɨ Minnwi chhu nthɛ vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pugu ni ŋga mbɨnɨ, njəɨ pɨgəɨ ghaŋ younjiŋ pi pugu pa ntou yú ŋgwa pugu pa ghaŋ yɛʼi gɨ́ Mushi lōu nu. ");
INSERT INTO bmo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wuʼɔ ndɨɨ ghɔ, ŋguoŋ yú ŋgwa pighɔ gha njəɨ Jishɔ, ŋgrāo ti a ghaʼa, ntei ŋgə̄ɨ njəɨ vi nchrā ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A pie ghaŋ younjiŋ pi ŋa, “Pəɨ pugu lōu pi khɔ?” ");
INSERT INTO bmo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yichəɨ ŋoŋ moŋ yú ghɔ khwɛ̄ ŋa, “Masha, ǹthɔ ni muuŋ a, njəɨ ghɔ nɔ ghɔ, ŋa miŋwɛiŋ pɔ mbɨŋ yu, nchwīe ŋa kiʼi a chrā. ");
INSERT INTO bmo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sheshe ndɨɨ ŋa a ghà ncho vi nɛ, a ghà māʼaŋ vi shhɛ, faʼofaʼo taoŋ nu nchò yu, a kru shua yi, noŋ yi tii. Ǹchhu ni pa ghaŋ younjiŋ pɔ ŋa pugu fuʼu miŋwɛiŋ ghɔ, pugu paʼo kie.” ");
INSERT INTO bmo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A khwɛ̄ ni pugu ŋa, “Yo ŋgwrɛiŋgwa ki fāʼo piŋ, mi shi mbɔ pia pi fɨʼɨ yi nɛiŋ? Mi shi mfāʼo wɛ̄iŋ njùʼɔ ni pəɨ pi fɨʼɨ yi nɛiŋ? Pəɨ thɔ ni ju mfɛ vəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pugu thɔ ni muuŋ ghɔ njəɨ vi nɔ, jijwɛ ghɔ gha njəɨ Jishɔ ŋgwɛ̄iŋ muuŋ ghɔ ni miprɨligi, a gū shhɛ ŋkə̄nə nu faʼofaʼo taoŋ nu nchò yu. ");
INSERT INTO bmo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jishɔ pie tǎa muuŋ ghɔ ŋa, “Nnu yei kwo lɔ̄gɔ lɨʼɨ mbɨŋ yu nɔ fɨʼɨ ndɨɨ nɛiŋ?” A khwɛ̄ ghɔ ŋa, “Jɛ̄ kəʼɨ prɔ. ");
INSERT INTO bmo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A ghà njiɛŋ māʼaŋ vi kíe pugu pa mooŋ ŋkhǐ nɔ jwi nu mi. Ndɔ ä mbɔ ŋa minthɛ ɔ chwīe nnu, ɔ fāʼo kwoshɨnɨ mbɨŋ pigi ŋgɛ̄rɛ vigi!” ");
INSERT INTO bmo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jishɔ khwɛ̄ ghɔ ŋa, “Ɔ chhu vəɨ ŋa, ‘Ä mbɔ ŋa minthɛ ɔ chwīe nnu?’ Sheshe nnu yīʼɛ ni ŋoŋ ŋa a fāʼo piŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tǎa muuŋ ghɔ kiʼi ŋkəɨkəɨ ni njɨ ŋa, “Ooŋ m̀biŋ, ghɛ̄rɛ ki piŋ a!” ");
INSERT INTO bmo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jishɔ gha njəɨ ŋkwaŋ nɔ haʼaŋ ntou yú ŋgwa tei nthɔ nu taʼa lɨʼɨ nɛ, a pɨ̄ga jijwɛ ghɔ, nchhu nu ŋa, “Jijwɛ fhɨncho pugu pa fhɨtənə, taoŋ mbɨŋ yu ki lɔ ma nuʼuŋ nii mbɨŋ yu ŋkamuʼɔŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nɛnnɛ jijwɛ ghɔ kə̄ɨ ni njɨ, māʼaŋ vi moŋ ŋkiɛŋ miprɨligi, ntaoŋ mbɨŋ yu. Muuŋ ghɔ pɔ nɔ khu ŋoŋ, nnɛ ntou yugu ni nchhu ŋa, “A khu!” ");
INSERT INTO bmo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ndɔ Jishɔ wɛ̄iŋ vi ŋgɛ̄rɛ vi, a lɔllɔ tɔthɨ. ");
INSERT INTO bmo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jishɔ ni ŋga nii nda, pa ghaŋ younjiŋ pi thɔ mbie vi ŋa, “A ni nchwīe khɔ pigi fuʼu kikie?” ");
INSERT INTO bmo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A khwɛ̄ ni pugu ŋa, “Yaoŋ ŋa minthɛ a fuʼu yei ŋkwaŋ nɛ wuʼɔ luoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jishɔ pugu pa ghaŋ younjiŋ pi lɔllɔ fɔ ntiri moŋ Galili. Paʼa a lɔ njiʼi ntāʼa nu ŋa shesheŋoŋ ji, ");
INSERT INTO bmo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nthɛ ŋa a ni nthɔ njɛʼi ghaŋ younjiŋ pi, nchhu nu ŋa, “Pi shi nchaʼa Muuŋ Ŋoŋmishua mfɛ liɛŋ mbhɔ ŋgwamishua pugu njwi vi. Pi gha njwi vi, a laʼa trɛi llɛ́, a kuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ndɔ paʼa pugu lɔ njiʼi nji njiŋ chrà yei, ndɔ mbɔgɔ nɔ pie nu vi nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pugu ghə̄ɨ nchəɨŋ Kapanuŋ, a gha nii nda, mbie ghaŋ younjiŋ pi ŋa, “Pəɨ ni nthɔ nchrā pi khɔ shɛndaoŋ?” ");
INSERT INTO bmo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pugu lɛrɛ pi laŋ nthɛ ŋa pugu ni ŋga mbɔ shɛndaoŋ, ndōu nu ni noŋ pugu ŋa a gɔ̌ mbɔ ŋoŋ ndiɛŋ nchaa pichəɨ ghao. ");
INSERT INTO bmo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A chɔchɔ shhɛ, mɛ̄iŋ paanchrɔ pighɔ nchhu ni pugu ŋa, “S̈hesheŋoŋ vəɨ ntāʼa nu mbɔ nthishɨ, a pie ŋa a lɔ̄gɔ noŋ yi nɔ miŋkwasha, mbɔ nɔ muuŋ fàʼa ŋguoŋ ŋgwa ghao.” ");
INSERT INTO bmo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A lɔ̄gɔ muuŋ mbrɔ ntigi vi shɨna pugu, mbaŋ vi, nchhu ni pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Shesheŋoŋ ŋa a piŋ taʼa mikəʼɨ nɔ yei nthɛ a nɛ piŋ pi mmu, ki shesheŋoŋ ŋa a piŋ a nɛ lɔ mbiŋ pi mmu, a piŋ pi ŋoŋ ŋa a taoŋ a nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jouŋ chhu ghɔ ŋa, “Masha, pigi yəɨ yichəɨ ŋoŋ a fuʼu miŋwɛiŋ ni ligi yɔ, pigi ka nɔ lāa nu ghɔ nthɛ ŋa pigi pugu lɔ nthɔ njōu njiŋ yɔ kaʼa.” ");
INSERT INTO bmo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ndɔ Jishɔ chhu ŋa, “Kiʼi pəɨ lāa ghɔ, nthɛ ŋa mbaʼa shesheŋoŋ ŋa a chwīe nnu ghraoghrao ni ligi a nɛ pɨnɨ ŋkara nchrā nnu pɨphɨ nthɛ a. ");
INSERT INTO bmo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nthɛ ŋa ŋoŋ ŋa a lɔ ndāa via nɛ, pɔ ŋgei pia. ");
INSERT INTO bmo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Shishini, ǹchhu ni pəɨ ŋa shesheŋoŋ ŋa a fɛ ndua ŋkhǐ ŋa pəɨ nnu nthɛ ŋa pəɨ yi Krishto nɛ, nthɛ paʼa a lɔ shiɛŋ kɨ̀nɛiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Shesheŋoŋ ŋa a chwīe muuŋ mi muuŋ vei ŋa a piŋ a nɛ gū moŋ phɨ nɛ, a nì mbwa pi chu mmɛ ŋgùʼɔ wuʼɔ yaoŋ nɔ mmi yi njīe vi ŋkhǐ, nchaa ŋa a thi sháʼa shhɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ti m̈bhɔ yəɨ nchwīe pəɨ gū moŋ phɨ, pəɨ yaʼa mīʼaŋ. A pwa pəɨ nii moŋ chɔmbhi nɔ ŋkwíni nchaa fāʼo nu paa mbhɔ yɔ ndɔ ŋgə̄ɨ moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ, mbɔ móŋoŋ ki phɛ, ");
INSERT INTO bmo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","lɨʼɨ ŋa mbaʼa nthrɨshie khu, ndɔ mbaʼa móŋoŋ lɛ ma mbhɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ti k̈wo yɔ nchwīe ɔ gū moŋ phɨ, ɔ yaʼa mīʼaŋ, nthɛ ŋa a pwa ɔ nii moŋ chɔmbhi nɔ ŋkwíni nchaa ŋa pi māʼaŋ ghɔ moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ ni paa kwò yɔ, ");
INSERT INTO bmo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","lɨʼɨ ŋa mbaʼa nthrɨshie khu, ndɔ mbaʼa móŋoŋ lɛ ma mbhɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ti l̈igi yɔ nchwīe ɔ gū moŋ phɨ, ɔ fīʼa mfuʼu mīʼaŋ, a pwa nɔ nii nu moŋ Shaʼafuoŋ Minnwi ni taʼa ligi nchaa ŋa pi māʼaŋ ghɔ moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ ni paa ligi yɔ, ");
INSERT INTO bmo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","lɨʼɨ ŋa mbaʼa nthrɨshie khu, ndɔ mbaʼa móŋoŋ lɛ ma mbhɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Pi shi niʼiŋ móŋoŋ mbɨŋ shesheŋoŋ ŋkwaŋ haʼaŋ pi ghà niʼiŋ khí moŋ yaoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Khí pwa, ndɔ g̈hrɨ́ yi nɔ chwīe nu yaoŋ pwa mbhɛ, ɔ pɨnɨ ŋkwəɨ ni ghrɨ́ yi ghɔ pi nɛiŋ? A yiʼi ŋa pəɨ pɔ nɔ khí ni noŋ pəɨ, nchhɔ moŋ taʼaŋggi pəɨ pa ŋgwa.” ");
INSERT INTO bmo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jishɔ lɔllɔ Kapanuŋ ŋgə̄ɨ krao ŋgei Judia, ntiri Jodaŋ, yú ŋgwa pɨnɨ ŋkɨrɨ yəɨ yu ŋkamuʼɔŋ. Nɔ haʼaŋ nùʼɔŋ yi ni mbɔ nɛ, a jɛ̄ nthɔ njɛʼi vugu. ");
INSERT INTO bmo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pichəɨ pa ŋgwa Farashi thɔ mbara Jishɔ ntāʼa nu mōoŋ vi, mbie ŋa, “Gɨ́ Mushi piŋ ŋa ŋoŋ nthɛ a shāaŋ láŋ pugu ŋgwɛ vi?” ");
INSERT INTO bmo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A khwɛ̄ ni pugu ŋa, “Mushi ni nchhu ni pəɨ ŋa moŋ gɨ́?” ");
INSERT INTO bmo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pugu chhu, “Mushi ni mieŋ ŋa ŋoŋ nāʼaŋ ŋwaʼaŋlɨ shāaŋ láŋ mfɛ ni ŋgwɛ vi, mfuʼu vi ŋa a ghə̄ɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jishɔ chhu ni pugu ŋa, “A ni nāʼaŋ yie kɨ̀na mfɛ ni pəɨ nthɛ pi ŋa thɔ yəɨ tɨnɨ ni njɨ. ");
INSERT INTO bmo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ndɔ nɔ njɛ̄ ndɨɨ ŋa pi ni mbuoŋ mbhi nɛ, ‘Minnwi ni nchwīe pi mimbia pugu miŋgwɛ.’ ");
INSERT INTO bmo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Nthɛ yie ghɔ, mimbia shi mieŋ tǎa vi pugu mǔuŋ vi, nchīni pugu ŋgwɛ vi. ");
INSERT INTO bmo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Paa ŋgwa pighɔ chīni ŋgū taʼa frɛinoŋ.’ Nnɛ pugu lɔ nuʼuŋ mbiʼi yi paa, pugu pɔ pi taʼa yi. ");
INSERT INTO bmo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nthɛ yie ghɔ, yaoŋ ŋa Minnwi chīni nɛ, kiʼi ŋoŋ shɛ̄rɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pugu pugu gha mbɨnɨ nda pa ghaŋ younjiŋ pi pɨnɨ mbie vi ni nnu yei. ");
INSERT INTO bmo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A chhu ni pugu ŋa, “Shesheŋoŋ ŋa a shāaŋ láŋ pugu ŋgwɛ vi ndaŋ yi nduoŋ nɛ chwīe phɨ mbɨŋ ŋgwɛ vi. Mbɔ phɨ shúoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ti m̈iŋgwɛ nshāaŋ láŋ pugu ndaoŋ vi, ndaŋ ŋoŋ nduoŋ kaŋ a kwo shúoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pa ŋgwa ni nthɔ nu ni pa puoŋ ŋa a kāoŋ vugu, pa ghaŋ younjiŋ pi pɨ̄ga ŋgwa pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jishɔ gha njəɨ, mbɨgɨ túa nchhu ni pugu ŋa, “Pəɨ mieŋ puoŋ pighɔ thɔ njəɨ a, kiʼi pəɨ pɔ kɨʼɨŋgɨnɨ ni pugu nthɛ ŋa Shaʼafuoŋ Minnwi pɔ pi ni ŋkwaŋ ŋgwa pei. ");
INSERT INTO bmo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Shishini, ǹshwei vəɨ, shesheŋoŋ ŋa a lɔ njiʼi mbiŋ Shaʼafuoŋ Minnwi moŋ chɔmbhi yi nɔ muuŋ mbrɔ nɛ nthɛ paʼa a lɔ nii moŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A paŋ vugu nūʼɔŋ mbhɔ yi mbɨŋ shesheŋoŋ vugu, mfɛ mbɔrɔ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nɔ haʼaŋ Jishɔ ni ndhɔ nyìeŋ nɛ, ŋoŋ chəɨ tei ŋkuʼɔ ŋkwi kwɛ́rɛ yi shhɨ yu, mbie vi ŋa, “Ŋkiɛŋ Masha, a yiʼi ŋa ǹchwīe khɔ nɔ fāʼo nu chɔmbhi ki mmɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jishɔ pie ghɔ ŋa, “Ɔ mɛ̄iŋ a ni ŋkiɛŋ ŋoŋ nthɛ khɔ? A wuʼɔ Minnwi mbɔ ŋkiɛŋ ŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ɔ ji yaoŋ ŋa pa kɨ̀na chhu nɛ, ‘Kiʼi njwi ŋoŋ, kiʼi ŋgaŋ láŋ kwoshuoŋ, kiʼi njōo, kiʼi ŋkwe ntie ŋoŋ ni mbe, kiʼi nchīgi, yaʼo nchò tǎa ghɔ pugu muuŋ ghɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A khwɛ̄ ŋa, “Masha, ŋguoŋ kɨ̀na pei ŋ̀kwo nūʼɔŋ llɔ ndɨɨ ŋa mi ni mbɔ maʼaŋ mikhwa nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jishɔ līi vi, mfāʼo khwā mbɨŋ yu, nchhu ghɔ ŋa, “Ɔ pou taʼa yaoŋ. Ghə̄ɨ fīni ŋguoŋ maoŋ pɔ ghao ŋgrā ni ghaŋ pou, kaŋ fāʼo yɔ shi mbɔ po, nnɛ nthɔ njōu njiŋ a.” ");
INSERT INTO bmo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A ni ŋga njaʼo yei nnu, noŋ yi shwiʼi, a ghə̄ɨ moŋ pəʼɨ njùʼɔ nthɛ ŋa a ni mfāʼo ŋgaʼa. ");
INSERT INTO bmo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jishɔ kara ligi mbɛʼi pa ghaŋ younjiŋ pi, nchhu ni pugu ŋa, “A ya ŋgaʼa ni ghaŋ fàʼo nɔ mieŋ nu Minnwi shaʼa fùoŋ yi moŋ chɔmbhi yugu.” ");
INSERT INTO bmo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pa ghaŋ younjiŋ pi ghrāo pa chrà pi pei ndɔ Jishɔ ghə̄ɨ shhɨ nchhu ŋa, “Pa puoŋ paŋ, a ya ŋgaʼa nɔ nii nu moŋ Shaʼafuoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A yīʼɛ ni minyieŋləɨ nɔ tɔgɔ nu moŋ mbo mitaʼa nchaa ŋgaŋ fàʼo nɔ mieŋ nu Minnwi shaʼa fùoŋ yi moŋ chɔmbhi yi.” ");
INSERT INTO bmo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pugu ghrāo ti a ghaʼa, nchhu ghɔ ŋa, “Ti minthɛ a lūgu gɔ̌ kiʼɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jishɔ pɛʼi vugu nchhu ŋa, “Minthɛ paʼa a lɔ mfāʼa ni ŋgwamishua ndɔ paʼa ndɔ ŋgaʼa pi ni Minnwi. Ŋguoŋ pa nnu ghao yīʼɛ ni Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita jɛ̄ nthɔ nchhu nu ghɔ ŋa, “Līi njəɨ, pigi mieŋ ŋguoŋ yaoŋ ghao njōu njiŋ yɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jishɔ chhu ŋa, “Shishini, ǹchhu ni pəɨ ŋa, yichəɨ ŋoŋ lɔ njiʼi mbɔ fɔ ŋa ä mieŋ mbaanda yi, ki lǐŋ pi pi pimbia pugu pa piŋgɛ, ki mǔuŋ vi, ki tǎa vi, ki puoŋ pi, ki nyìeŋ yi, nthɛ a pugu pa nthɛ ŋkɨ̀nɨ pwa pishaʼakhɔ, ");
INSERT INTO bmo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ŋa mbaʼa a yiʼi mieŋ ki fāʼo pa nda, pa lǐŋ pi pi pimbia pugu pa piŋgɛ, pa mǔuŋ, pa puoŋ, pa nyìeŋ, a yiɛŋ ti mbɔ ŋkɨɨ ŋgɛ́ moŋ yei chɔmbhi ndɔ mbɨnɨ mfāʼo ŋgəʼɨ ŋa pi shi mfɛ ghɔ nthɛ a. Moŋ mbhi yɛ ŋa a thɔ nu nɛ, a pɨnɨ mfāʼo chɔmbhi ki mmɛ. ");
INSERT INTO bmo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ndɔ ntou ŋgwa ŋa pugu thi shhɨ nɛ shi mbɔ ndugwi njiŋ, pa ndugwi njiŋ thi shhɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pugu ni mbɔ shɛndaoŋ ŋkuʼɔ nu Jerushalɛiŋ, Jishɔ nyīeŋ ŋgə̄ɨ nu shhɨ pugu. Pa ghaŋ younjiŋ pi ghrāo, pɔgɔ gu wɛ̄iŋ ŋgwa pɛ ŋa pugu ni nthɔ nu njiŋ pugu nɛ. Ŋkamuʼɔŋ Jishɔ kɨrɨ paanchrɔ ghaŋ ntaoŋ pi lɨʼɨ təʼɨ vugu, nchhu pa nnu ŋa a shi ndɔ̄gɔ lɨʼɨ mbɨŋ yu nɛ ni pugu, ");
INSERT INTO bmo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","nchhu nu ŋa, “Pəɨ līi njəɨ, pia kuʼɔ nu Jerushalɛiŋ pi chaʼa Muuŋ Ŋoŋmishua mfɛ mbhɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi, pi fɛ njɔ́ gu ghɔ nchaʼa vi mfɛ ni ŋgwa taoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pugu lɛ māʼaŋ vi ni kwə̀ɨŋ, nthu thwɛ mbɨŋ yu, ŋgwie vi, njwi vi, a gha ndaʼa trɛi llɛ́, a pɨnɨ ŋkuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jɛiŋ pugu Jouŋ, mbɔ pa puoŋ Shebedi thɔ njəɨ Jishɔ nchhu ghɔ ŋa, “Masha, pigi tāʼa nu ŋa ɔ chwīe nnu yɛ ŋa pigi shi mbie vɛ nɛ ni pigi.” ");
INSERT INTO bmo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A pie vugu ŋa, “Pəɨ tāʼa nu ŋa ǹchwīe khɔ mfɛ ni pəɨ?” ");
INSERT INTO bmo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pugu chhu ghɔ ŋa, “Fɛ shɨna ni pigi, pigi chhɔ yəɨ ghɔ, taʼa ŋoŋ vigi ŋgei mbɔ yɔ yi jɨ, yichəɨ taʼa yi ŋgei mbɔ ŋkwrɛi yɔ, ndɨɨ ŋa ɔ pɔ moŋ ndighaʼo yɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jishɔ chhu ni pugu ŋa, “Pəɨ lɔ nji yaoŋ ŋa pəɨ pie nu nɛ. Minthɛ pəɨ nnu ndua ŋgəʼɨ ŋa shi nnu nɛ? Ki ŋkwe ŋkwaŋ kwe ŋkhǐ yɛ ŋa a yiʼi ŋa ŋkwe nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pugu khwɛ̄ ghɔ ŋa, “Ooŋ, pinthɛ pigi tɔgɔ moŋ ghɔ.” Jishɔ chhu ni pugu ŋa, “Ndua ŋgəʼɨ ŋa ǹshi nnu nɛ pəɨ shi nnu, kwe ŋkhǐ ŋa ǹshi ŋkwe nɛ pəɨ kwe. ");
INSERT INTO bmo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ndɔ nɔ chhɔ nu ŋgei mbhɔ a yi jɨ ki ŋgei ŋkwrɛi, a lɔ njiʼi mbɔ lɨʼɨ a nɔ fɛ nu. A pɔ pi ni ŋgwa pɛ ŋa Minnwi kwo pīri ni pugu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ndɔ pɨgəɨ wuŋ ghaŋ younjiŋ Jishɔ ni ŋga njaʼo nnu yei, mfāʼo pɨgɨtua mbɨŋ Jɛiŋ pugu Jouŋ. ");
INSERT INTO bmo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jishɔ gɛ̄ vugu pugu thɔ njəɨ vi, a chhu ni pugu ŋa, “Pəɨ ji ŋa ŋgwa pɛ ŋa pi ji vugu ŋa a ghaŋ shaʼa ŋgwa moŋ mbhi nɛ ghà nshaʼa ŋgwa pugu shaʼa, pa mɛmmɛ ŋgwa pugu nōoŋ pi nnu ghrɨ́ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ndɔ mbaʼa a yiʼi mbɔ pi nnɛ ni pəɨ. Shesheŋoŋ ŋa a tāʼa nu nɔ pɔ nu ŋoŋ ndiɛŋ shɨna pəɨ nɛ fāʼo nɔ pɔ nu muuŋ fàʼa vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Shesheŋoŋ ŋa a tāʼa nu mbɔ nthishɨ shɨna pəɨ nɛ fāʼo nɔ pɔ nu ŋkǔna ŋguoŋ ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nthɛ ŋa Muuŋ Ŋoŋmishua shini ndɔ njiʼi nthɔ pi ŋa pi fāʼa mbɔ yu, a ni nthɔ pi nɔ fāʼa nu mbhɔ ŋgwa, ndɔ mfɛ chɔmbhi yi nɔ nchúoŋ thɔ ntou ŋgwa.” ");
INSERT INTO bmo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pugu thɔ Jeriko, Jishɔ lɔllɔ ŋgə̄ɨ nu pugu pa ghaŋ younjiŋ pi pugu pa mmɛ yú ŋgwa, ŋgaŋ luoŋ chəɨ mbɔ nchriligi, ligi yi pɔ Batimau, muuŋ Timau, chhɔ ŋkɨŋ shɛndaoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","A ni ŋga njaʼo ŋa a Jishɔ llɔ Nasharɛ ntɔgɔ nu, a jɛ̄ paʼo nu ŋgòu, nchhu nu ŋa, “Jishɔ, Muuŋ Devi, fāʼo kwoshɨnɨ mbɨŋ mu!” ");
INSERT INTO bmo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ntou ŋgwa pɨ̄ga vi, nchhu nu ghɔ ŋa a lɛrɛ laŋ. A ka mīʼɛŋ mbaʼo pi ŋgòu ni njɨ mbīgi, “Muuŋ Devi, fāʼo kwoshɨnɨ mbɨŋ mu!” ");
INSERT INTO bmo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jishɔ tithi nchhu ŋa, “Pəɨ mɛ̄iŋ vi hɛiŋ.” Nɛnnɛ pugu mɛ̄iŋ nchriligi ghɔ, nchhu nu ghɔ ŋa, “Wɛ̄iŋ njùʼɔ yɔ, lɔllɔ tɔthɨ, a thɔ nɛ mɛ̄iŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A mīʼaŋ mmɛ ndhwí yi, ndhi tɔthɨ nthɔ njəɨ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jishɔ chhu ghɔ ŋa, “Ɔ tāʼa nu ŋa ǹchwīe nɛiŋ vɛ?” Nchriligi ghɔ chhu ghɔ ŋa, “Masha, ǹtāʼa nu mbɨnɨ njəɨ lɨʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jishɔ chhu ghɔ ŋa, “Ghə̄ɨ ni gɔ, piŋ yɔ chwīe ghɨ̌nɔ yɔ tɔgɔ.” Wuʼɔ chomilaoŋ ghɔ, ligi yi chuʼɔ a yōu njiŋ Jishɔ shɛndaoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pugu ni ŋga mbara nu Jerushalɛiŋ, ŋkɨŋ Bɛfɛgɛ pugu Betani ŋkuoŋ Mbra pa Thɨ Olive nɛ, Jishɔ taoŋ paa ghaŋ younjiŋ pi, ");
INSERT INTO bmo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nchhu ni pugu ŋa, “Pəɨ ghə̄ɨ moŋ muuŋ laʼataoŋ yinɛ shhɨ pəɨ nɛ, wuʼɔ nɔ haʼaŋ pəɨ nii nɛ, pəɨ shi njəɨ muuŋ mi ŋkwɛ́iŋ pi chu ŋa ŋoŋ shi lɔ naa nchhɔ ŋkuoŋ yu. Pəɨ fēi nthɔ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","S̈hesheŋoŋ nchhu ni pəɨ ŋa, ‘Pəɨ fēi nu ŋa?’ pəɨ chhu ŋa, ‘Taathɔ fāʼo fàʼa nɔ ghɔ, a shi mbɨnɨ nuʼuŋ nduʼu hɛnɛiŋ nɔ kuo ndɨɨ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pugu lɔllɔ ŋgə̄ɨ, njəɨ muuŋ ŋkwɛ́iŋ pi chu chonda mbhi ŋkɨŋ shɛndaoŋ, pugu fēi. ");
INSERT INTO bmo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pichəɨ ŋgwa ŋa pugu ni nthi fɔ nɛ pie ni pugu ŋa, “Pəɨ chwīe pi khɔ? Pəɨ fēi pi ŋkwɛ́iŋ yinɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pugu chhu nnu ŋa Jishɔ ni nshwei vugu nɛ ni pugu, ŋgwa pighɔ ŋa pugu ni nju fɔ nɛ mieŋ vugu pugu ghə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pugu thɔ ni muuŋ ŋkwɛ́iŋ ghɔ mfɛ ni Jishɔ, māʼaŋ pa mɛmmɛ ndhwí pugu ŋkuoŋ ŋkwɛ́iŋ ghɔ, Jishɔ chhɔ ŋkuoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ntou ŋgwa shɛ̄iŋ pa mɛmmɛ ndhwí pugu shɛndaoŋ, pichəɨ shɛ̄iŋ pa mbhɔthɨ ni fhɔthɨ ŋkuoŋ ghɔ ŋa pugu ni njaʼa moŋ pa nyìeŋ. ");
INSERT INTO bmo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pa ŋgwa pɛ ŋa pugu ni mbɔ shhɨ nɛ pugu pa pɛ ŋa pugu ni mbɔ njiŋ nɛ paʼo ŋgòu, nchhu nu ŋa, “Ndighaʼo pɔ ni Minnwi, mbɔrɔ pɔ ni ju ŋa a thɔ nɔ ligi Taathɔ nɛ! ");
INSERT INTO bmo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Minnwi nūʼɔŋ mbɔrɔ yi ŋkuoŋ Shaʼafuoŋ fùoŋ Devi tǎa via, ŋa a thɔ nu nɛ. Ndighaʼo pɔ ni Minnwi ŋa a chhɔ po nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A nii Jerushalɛiŋ, ŋgə̄ɨ moŋ Nda Minnwi, ŋga ndīi ŋguoŋ yaoŋ nɔ haʼaŋ njiʼa ni ŋkwo tɔgɔ nɛ, ntaoŋ ŋgə̄ɨ Betani pugu pa paanchrɔ ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mbhi ni ŋga ndaŋ, nɔ haʼaŋ pugu ni ŋkwəɨ nu llɔ Betani nɛ, njì yia Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A thi hini njiʼɛ njəɨ thɨ ŋa a ghà njuŋ nɛ a ya ntəʼɨ, a ghə̄ɨ nɔ yəɨ nu ŋa minthɛ a fāʼo ntíɛŋ llɔ ŋkuoŋ ghɔ. A gha nthɔ nchəɨŋ yəɨ thɨ ghɔ, paʼa ndɔ njəɨ sheshe yaoŋ ŋkiɛŋ pa fhɔthɨ, nthɛ ŋa a shini ndɔ mbɔ ndɨɨ ŋa pa thɨ ghɔ ghà njuŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A chhu ni thɨ ghɔ ŋa, “Kiʼi ŋoŋ ma nuʼuŋ njɨ ntíɛŋ llɔ mbɨŋ ghɔ.” Pa ghaŋ younjiŋ pi yaʼo. ");
INSERT INTO bmo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pugu ni ŋga nchəɨŋ Jerushalɛiŋ, Jishɔ ghə̄ɨ Nda Minnwi njōu ŋgwa pɛ ŋa pugu ni mfīni yaoŋ pugu pa ŋgwa pɛ ŋa pugu ni njuoŋ nu Nda Minnwi nɛ, nshrī taprɛi ghaŋ kwri mbɨŋ pugu pa ghaŋ fīni mintuʼɔlibuŋ, ");
INSERT INTO bmo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","paʼa ndɔ nuʼuŋ mbiŋ ŋa shesheŋoŋ mfɛ a tiɛŋ yaoŋ ntiri nɔ yɨna Nda Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A ni nthɔ njɛʼi vugu, nchhu nu ŋa, “Pi shi lɔ nāʼaŋ ŋa, ‘Pi shi mɛ̄iŋ nda a ni nda luoŋ Minnwi ni ŋguoŋ pa taoŋ taoŋ ghao,’ ndɔ pəɨ kara a gū pùo pa ŋgɨna minwi.” ");
INSERT INTO bmo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nnɛ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi yaʼo nthɔ ntāʼa shɛndaoŋ njwi vi, nthɛ ŋa pugu ni mbɔgɔ vi, nthɛ ŋa ŋguoŋ yú ŋgwa pighɔ ŋa pugu ni mbɔ fɔ nɛ ni ŋgrāo ŋkwaŋ nɔ haʼaŋ a ni njɛʼi nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Fanaoŋ ni ŋga nthɔ, pugu taoŋ moŋ laʼa. ");
INSERT INTO bmo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nɔ haʼaŋ pugu ni ntɔgɔ nu ni tutuʼu nɛ, pugu yəɨ thɨ wùnu yɛ, a kwo yaoŋ ti nshwiʼi nchəɨŋ moŋ ŋǐeŋ pi. ");
INSERT INTO bmo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita kwiŋ, nchhu ŋa, “Masha, līi njəɨ! Thɨ wùnu yɛ ŋa ɔ ni nchɔ̄nɔ nɛ kwo yaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jishɔ khwɛ̄ ni pugu ŋa, “Pəɨ fāʼo piŋ mbɨŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Shishini, ǹshwei vəɨ, shesheŋoŋ ŋa a shi nchhu ni mbra yei ŋa, ‘Lɔllɔ tɔthɨ ŋgū moŋ ŋkhǐ’, ki lɔ mfāʼo khuthɔ moŋ njùʼɔ yu nɛ, ndɔ mbiŋ ŋa nnu ŋa a chhu nɛ shi ndɔ̄gɔ lɨʼɨ nɛ, pi shi nchwīe mfɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nthɛ yie ghɔ, ǹshwei vəɨ, sheshe yaoŋ ŋa pəɨ pie moŋ luoŋ Minnwi nɛ, pəɨ mfāʼo piŋ ŋa pəɨ kwo fāʼo yaoŋ ghɔ, kaŋ a shi mbɔ yəɨ. ");
INSERT INTO bmo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ndɔ sheshe ndɨɨ ŋa ɔ tithi nduoŋ Minnwi nɛ, ɔ̈ mfāʼo sheshe yaoŋ moŋ njùʼɔ ghɔ nthɛ yichəɨ ŋoŋ, ɔ līʼɛ phɨ yi, nnɛ ŋa Tǎa ghɔ ŋa a chhɔ po nɛ ŋkaa yu nthɛ a līʼɛ jɔ phɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ndɔ p̈əɨ mieŋ ki lɔ njiʼi ndīʼɛ phɨ yichəɨ ŋoŋ, kaŋ mbaʼa Tǎa vəɨ po līʼɛ pa yəɨ phɨ. ");
INSERT INTO bmo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pugu pɨnɨ nthɔ Jerushalɛiŋ. Nɔ haʼaŋ a ni nyīeŋ nu Nda Minnwi nɛ, pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi gɨ́ Mushi thɔ mbara vi, ");
INSERT INTO bmo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nchhu ghɔ ŋa, “Ɔ fāʼo pi yəɨ ghrɨ́ nɔ chwīe nu pa nnu pei ki a fɛ gɔ̌ ghrɨ́ yei vɛ nɔ chwīe nu pa nnu pei nɔ ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jishɔ chhu ni pugu ŋa, “Ǹshi mbie vəɨ ni taʼa píe, p̈əɨ mfɛ khwɛ̀ vəɨ, ǹshwei vəɨ ni yɛ ghrɨ́ ŋa ǹchwīe nnu pei nɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pəɨ shwei a, Jouŋ ni ŋkwe ghrɨ́ nɔ fɛ nu ŋkhǐ pi llɔ mbhɔ Minnwi ki ŋgwamishua?” ");
INSERT INTO bmo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pugu chrā nnu ghɔ ni noŋ pugu, nchhu nu ŋa, “P̈ia nchhu ŋa, ‘Llɔ mbhɔ Minnwi’, a chhu ŋa, ‘Ti a ni nchwīe khɔ paʼa pəɨ lɔ mbiŋ Jouŋ?’ ");
INSERT INTO bmo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ti p̈ia nchhu ŋa, ‘A llɔ pi mbhɔ ŋgwamishua?’ ” nthɛ ŋa pugu ni nthɔ mbɔgɔ pa ŋgwa nthɛ ŋa shesheŋoŋ ni nji ŋa Jouŋ ni nja mbɔ njəɨlɨʼɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nnɛ pugu khwɛ̄ ni Jishɔ ŋa, “Pigi lɔ nji.” Jishɔ chhu ni pugu ŋa, “Kaŋ mbaʼa mummu ŋkaa mu shwei vəɨ ni lɨʼɨ ŋa ghrɨ́ a lɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nɛnnɛ Jishɔ jɛ̄ nthɔ nchrā nu ni pugu moŋ luʼɔ chrà. “Ŋoŋ chəɨ ni ma mbhī faaŋ ntíɛŋ thɨ yi, ŋkrao ŋkaʼa ŋgɨ̄ŋ nɔ ghɔ, ntou ŋkuʼɔ nɨ̄ɨ ntíɛŋ thɨ ghɔ ŋkhǐ yi taoŋ nɔ chwīe nu laʼo, ndɔ ŋkrao muuŋ nda tɔthɨ nɔ chhɔ nu fɔ ŋkɛ̄ʼi nyìeŋ. Nnɛ mfɛ ni ghaŋ fàʼa ŋa pugu lɨna nɔ ghɔ ŋga ŋkwōo maoŋ pugu pugu ghrā, ndhɔ kiʼɛ ŋgə̄ɨ laʼataoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ndɨɨ ni ŋga ŋkāʼo nɔ kwōo nu ntíɛŋ thɨ yɛ, Ŋoŋ ghɔ taoŋ muuŋ fàʼa ni pa ghaŋ fàʼa pɛ ŋa a ghə̄ɨ ŋkwe ji ghrà ntíɛŋ thɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ndɔ pa ghaŋ fàʼa pighɔ wie muuŋ fàʼa yi ghɔ nduʼu vi ni mbhɔ yó. ");
INSERT INTO bmo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“A pɨnɨ nuʼuŋ ntaoŋ muuŋ fàʼa nduoŋ, pugu wie vi nɔ thɔ yi, nchwīe nnu lrithɔ mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A pɨnɨ nuʼuŋ ntaoŋ yichəɨ pugu jwi vi, ŋguʼɔ nchwīe mbɨŋ ntou pichəɨ pi nɛnnɛ, ŋgwie pichəɨ, njwi pichəɨ. ");
INSERT INTO bmo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","A pɨnɨ mfāʼo taʼa ŋoŋ ŋa a nthɛ a taoŋ, mbɔ muuŋ vi ŋa a khwā nɛ, ndugwi yi a taoŋ vi ni pugu, nchhu nu ŋa, ‘Pugu shi mfāʼo pɔgɔ yɔ.’ ");
INSERT INTO bmo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ndɔ ghaŋ fàʼa pighɔ chhu ni noŋ pugu ŋa, ‘Yei njɨnda yi, pia chīri njwi vi maoŋ pi gū yia!’ ");
INSERT INTO bmo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pugu wɛ̄iŋ vi, njwi vi, mfuʼu khu yi moŋ nyìeŋ mīʼaŋ. ");
INSERT INTO bmo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ti ŋgaŋ nyìeŋ ghɔ shi nchwīe pi nɛiŋ kiʼɛ? A shi nthɔ njwi pa ghaŋ fàʼa pighɔ, mfɛ faaŋ ghɔ ni ŋgwa nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pəɨ lɔ naa mɛ̄iŋ lɨʼɨ Ŋwaʼaŋlɨ Minnwi yei ŋa a chhu ŋa, ‘Ŋgùʼɔ yɛ ŋa ghaŋ nūʼɔŋ nda ni ndāa ŋa a lɔ njiʼi mfāʼo ghɛ̀rɛ nɛ pɨnɨ nɛ ŋkara ju mbɔ ndugwi ŋguʼɔ shiʼi nchaa ŋguoŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yei fàʼa Taathɔ ndɔ mbɔ ŋkiɛŋ nnu ghraoghrao ligi pigi’?” ");
INSERT INTO bmo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pa thishɨ ŋgwa Juu pighɔ ni nthɔ ntāʼa shɛndaoŋ nɔ wɛ̄iŋ nu mi, nthɛ ŋa pugu ni nji ŋa a chhu luʼɔ chrà yei nthɛ pi pugu, ndɔ pugu fāʼo pɔgɔ gu nthɛ yú ŋgwa ŋa pugu ni mbɔ fɔ nɛ, nnɛ mieŋ vi ŋgə̄ɨ ni vugu. ");
INSERT INTO bmo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pugu taoŋ pa pichəɨ ŋgwa Farashi pugu pa pichəɨ pa ghaŋ younjiŋ Hɛrɔ, ŋa pugu ghə̄ɨ mbīri Jishɔ ŋgwɛ̄iŋ vi ni pa nnu ŋa a shi nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pugu thɔ nchhu ghɔ ŋa, “Masha, pigi ji ŋa ɔ ghà nchrā nnu shini ki lɔ ndīi pi nnu ŋa ŋgwa pīʼi nu nɛ, ɔ shiʼa nōoŋ shieligi ni shesheŋoŋ, ɔ ghà njɛʼi nnu ŋa Minnwi tāʼa nu ŋa ŋgwa chwīe nɛ moŋ ndɨndɨ. A kāʼo ŋa pi pe taashi ni Kaisha ki ŋga? Pigi pe ki kiʼi pigi pe?” ");
INSERT INTO bmo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ndɔ Jishɔ kwo yəɨ mbe yugu, nchhu ni pugu ŋa, “Pəɨ mōoŋ a ŋa? Pəɨ thɔ ni taʼa ndigi mbɨŋ nōoŋ njəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pugu thɔ ni taʼa yi. A chhu ni pugu ŋa, “Yei thɔ gɔ̌ pugu ligi gɔ̌ ŋkuoŋ ghɔ?” Pugu khwɛ̄ ŋa, “A yi Kaisha.” ");
INSERT INTO bmo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jishɔ chhu ni pugu ŋa, “Pəɨ fɛ yaoŋ ŋa a yi Kaisha nɛ ni Kaisha, mfɛ yi Minnwi ni Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pa ŋgwa Shadushi, ŋa pugu ni mbīʼi ŋa ŋoŋ shiʼa ŋkhu mbɨnɨ ŋkuʼɔ nɛ thɔ mbara Jishɔ, mbie vi ŋa, ");
INSERT INTO bmo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Masha, Mushi ni nāʼaŋ gɨ́ yei mfɛ ni pigi ŋa, ŋoŋ ŋkhu mieŋ ŋgwɛ vi ki lɔ mfāʼo muuŋ, a yiʼi ŋa ndǐŋ vi, yi mimbia, tiʼi ndɔ̄gɔ ŋkugu ghɔ mbhi puoŋ nɔ ghɔ nɔ ligi ndǐŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pa lǐŋ pichəɨ ni mbɔ fɔ pi khwachəɨ mbɔ pimbia, fǔoŋ yi laŋ, ŋkhu ki lɔ mfāʼo puoŋ, ");
INSERT INTO bmo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","mbra yi laŋ miŋgwɛ ghɔ, ŋkhu ki lɔ mfāʼo puoŋ. Yichəɨ mbra yi wuʼɔ nɛnnɛ. ");
INSERT INTO bmo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ti ŋguoŋ yugu pi khwachəɨ khu ki lɔ mfāʼo puoŋ. Ndugwi yi miŋgwɛ ghɔ khu ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ndwɛ, a lɛ ŋga mbɔ ndɨɨ yɛ ŋa ŋgwa lɛ mbɨnɨ ŋkuʼɔ nɛ, miŋgwɛ ghɔ pɔ pi yi gɔ̌, ŋa ŋguoŋ yugu pi khwachəɨ ni ŋkwo laŋ vi nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jishɔ khwɛ̄ ni pugu ŋa, “Yei lɔ mbɔ nnu ŋa a chwīe pəɨ fāaŋ nɛ? Nthɛ ŋa pəɨ lɔ nji Ŋwaʼaŋlɨ Minnwi ndɔ paʼa ndɔ nji ghrɨ́ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nthɛ ŋa ŋgwa ghà ŋga ŋkuʼɔ moŋ gu paʼa ndɔ ndaŋ ndɔ paʼa ndɔ ŋgə̄ɨ láŋ, mbɔ pi nɔ pa ghaŋ ntaoŋ Minnwi po. ");
INSERT INTO bmo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Ndɔ nthɛ nnu ŋgwa nɔ khu nu mbɨnɨ ŋkuʼɔ moŋ gu, pəɨ lɔ naa mɛ̄iŋ moŋ ŋwaʼaŋlɨ Mushi moŋ lɨʼɨ haʼaŋ a chrà nɔ nnu móŋoŋ thɔ muuŋ thɨ yuyuʼu nɛ, ŋkwaŋ haʼaŋ Minnwi ni nchrā ni Mushi fɔ, nchhu nu ŋa, ‘Mi Minnwi Abrahaŋ, mbɔ Minnwi Aiji, ni Minnwi Jakɔ?’ ");
INSERT INTO bmo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A lɔ njiʼi mbɔ pi Minnwi ŋgwa khu, a pɔ pi yi ŋgwa maoŋ. Pəɨ ya fāaŋ.” ");
INSERT INTO bmo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yichəɨ taʼa masha pa ghaŋ yɛʼi gɨ́ Mushi, ŋa a ni nthi fɔ njaʼo nnu ŋa pugu ni nchrā nu nɛ, gha njəɨ ŋa Jishɔ ŋkhwɛ̄ pa nnu pighɔ shiʼi, mbie vi ŋa, “A yəɨ kɨ̀na ŋa a chaa ŋguoŋ yi ghao?” ");
INSERT INTO bmo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jishɔ khwɛ̄ ŋa, “Yei kɨ̀na ŋa a chaa ŋguoŋ yi nɛ, ‘Yaʼo, ma Ishrae, Taathɔ mbɔ Minnwi yia wuʼɔ ju təʼɨ vi mbɔ Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A yiʼi ŋa ɔ khwā Taathɔ, mbɔ Minnwi yɔ, ni ŋguoŋ njùʼɔ yɔ ghao, ni ŋguoŋ nchə̌ɨ yɔ ghao, ni ŋguoŋ kwāʼa nu yɔ ghao, ni ŋguoŋ ghrɨ́ yɔ ghao.’ ");
INSERT INTO bmo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mbra yi pɔ yei, ‘Ɔ shi ŋkhwā taakuo yɔ nɔ haʼaŋ ɔ khwā noŋ yɔ nɛ.’ Yichəɨ kɨ̀na nduoŋ lɔ nuʼuŋ mbɔ fɔ ŋa a chaa pa pei.” ");
INSERT INTO bmo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ŋgaŋ yɛʼi gɨ́ Mushi chhu ghɔ ŋa, “Ɔ chhu a kāʼo, ma Masha. Ɔ ya nchhu shini ŋa Minnwi wuʼɔ ju təʼɨ vi ndɔ paʼa yichəɨ lɔ mbɔ nɔ Ju. ");
INSERT INTO bmo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A yiʼi ŋa ɔ khwā vi ni ŋguoŋ njùʼɔ yɔ pugu pa ŋguoŋ kwāʼa nu mɔ, ni ŋguoŋ ghrɨ́ yɔ ndɔ ŋkhwā taakuo yɔ nɔ haʼaŋ ɔ khwā noŋ yɔ nɛ. A pwa paa kɨ̀na yei nchaa fɛ nu minyieŋ ŋkuoŋ lɨʼɨ fɛʼiŋgiɛŋ pugu pa maoŋ fɛʼiŋgiɛŋ nduoŋ ni Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jishɔ ni ŋga njəɨ ŋa a khwɛ̄ ni shiethɔ, a chhu ghɔ ŋa, “Ɔ kwo para mieŋ nu Minnwi shaʼa fùoŋ yi moŋ chɔmbhi yɔ.” Jɛ̄ ndɨɨ ghɔ, paʼa shesheŋoŋ lɔ nuʼuŋ moŋ mbie vi ni sheshe píe. ");
INSERT INTO bmo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nɔ haʼaŋ Jishɔ ni njɛʼi nu Nda Minnwi nɛ, a ni mbie ŋa, “Mimfɛ pa ghaŋ yɛʼi gɨ́ Mushi kie pi nɛiŋ nchhu ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ pɔ pi muuŋ Devi? ");
INSERT INTO bmo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Jijwɛ Minnwi ni ŋkaoŋ njùʼɔ Devi a chhu ŋa, ‘Minnwi Taathɔ chhu ni Taathɔ a ŋa, “Chhɔ hɛiŋ ŋgei mbhɔ a yi jɨ ti ǹshi nuʼuŋ nchwīe pa mbɨ̌na pɔ gū yaoŋ tigi kwò yɔ.” ’ ");
INSERT INTO bmo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nduthɔ Devi mɛ̄iŋ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ ni Taathɔ vi, a nthɛ a kie pi nɛiŋ mbɔ muuŋ vi?” Mmɛ kɨrɨ ŋgwa pighɔ yaʼo nnu ŋa Jishɔ ni nchhu nɛ ni pwanjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Moŋ nnu ŋa Jishɔ ni njɛʼi nu nɛ, a ni nchhu ŋa, “P̂əɨ lɨna pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi a pwa, pugu khwā nɔ nyīeŋ nu moŋ pa mɛmmɛ ndrawaʼa ndɔ ŋkhwā ŋa pi tuʼu noŋ nchrā ni pugu lɨʼɨ kaʼa, ");
INSERT INTO bmo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ŋkhwā chhɔ nu nɔ pa lɨʼɨ liɛŋ moŋ pa nda luoŋ Minnwi pugu pa lɨʼɨ jɨ. ");
INSERT INTO bmo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pugu ghà nchīgi pa piŋgɛ kugu ŋkwe maoŋ pugu, luoŋ Minnwi yugu shɨga ni njɨ nnɛ ŋa ŋgwa yəɨ vugu nɔ pa ŋgwa taoŋtaoŋ. Yugu ŋgəʼɨ shi mbɔ yi wuwuru.” ");
INSERT INTO bmo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nɔ haʼaŋ Jishɔ ni nchhɔ yəɨ ŋkùŋ niʼiŋ pa yaoŋ fɛ́ Nda Minnwi nɛ, a ni chhɔ mbɛʼi ŋgwa nɔ haʼaŋ pugu niʼiŋ mbɨŋ moŋ ŋkùŋ niʼiŋ pa yaoŋ fɛ́ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ntou pa ghaŋ fāʼo ni nthɔ niʼiŋ ntou mɛmmɛ mbɨŋ moŋ ŋkùŋ ghɔ. Miŋgwɛ ŋkugu chəɨ ŋa a ki ya mbou niʼiŋ paa puoŋ mi mbɨŋ ŋa p̈i nchīri a pɔ nɔ taʼa ndola. ");
INSERT INTO bmo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","A mɛ̄iŋ pa ghaŋ younjiŋ pi yəɨ yu nchhu ni pugu ŋa, “Shishini, ǹchhu ni pəɨ ŋa, miŋgwɛ ŋkugu vei ŋa a pɔ pi mbou nɛ, fɛ nchaa ŋguoŋ ŋgwa ŋa pugu niʼiŋ pa mbɨŋ moŋ ŋkùŋ yaoŋ fɛ́ nɛ, ");
INSERT INTO bmo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nthɛ ŋa ŋguoŋ ŋgwa nduoŋ fuʼu maoŋ fɛ yugu shɨna ntou maoŋ ŋa pugu fāʼo nɛ, ndɔ miŋgwɛ vei moŋ pou yi fɛ ŋguoŋ yaoŋ ŋa a fāʼo nɔ yru nu ŋkuoŋ ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nɔ haʼaŋ Jishɔ ni ntaoŋ nu Nda Minnwi nɛ, taʼa pa ghaŋ younjiŋ pi chhu ghɔ ŋa, “Masha, līi njəɨ pa ŋgùʼɔ pwapwa pugu pa nda pwapwa njəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jishɔ chhu ni pugu ŋa, “Pəɨ yəɨ mbwambwa nda pei? Mbaʼa taʼa ŋgùʼɔ nuʼuŋ nūaŋ ŋkuoŋ ndǐŋ vi ki pi lɔ mbūo mfɛ shhɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nɔ haʼaŋ a ni nchɔchhɔ ŋkuoŋ Mbra pa Thɨ Olive njiɛŋ pɨprəɨ llɔ yəɨ Nda Minnwi nɛ, Pita ni Jɛiŋ pugu Jouŋ ni Andru pie vi njiŋnjiŋ ŋa, ");
INSERT INTO bmo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Shwei vigi pa nnu pei shi mbɔ pi ndɨɨ khɔ? Pa lì nɔ nōoŋ nu ndɨɨ ŋa nnu pei shi ndɔ̄gɔ lɨʼɨ nɛ pɔ pa khɔ?” ");
INSERT INTO bmo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jishɔ chhu ni pugu ŋa, “Pəɨ lɨna nu, kiʼi ŋoŋ fɨ̄ɨ vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ntou ŋgwa shi nthɔ nɔ ligi a, nchhu nu ŋa, ‘A mmu mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ!’ mfɨ̄ɨ ntou ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ndɨɨ ŋa pəɨ yaʼo pi thɔ māʼaŋ nchhɔ ki pa pishaʼakhɔ nnu nchhɔ̀, kiʼi pəɨ fāʼo pɔgɔ gu. A yiʼi ŋa ŋkwaŋ nnu pei shi ŋguʼɔ ndɔ̄gɔ lɨʼɨ ndɔ a lɔ naa mbɔ ndugwi mbhi yaʼa. ");
INSERT INTO bmo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pa laʼataoŋ shi ndɔllɔ māʼaŋ pichəɨ ni nchhɔ̀, ŋgwa yichəɨ taʼa fùoŋ māʼaŋ ŋgwa yichəɨ ni nchhɔ̀. Shhɛ shi nchɨʼɨ ti shɨna moŋ pa lɨʼɨlɨʼɨ, njì gū. Pa nnu pei pɔ pi nɔ haʼaŋ muuŋ ghà njɛ̄ naoŋ nu miŋgwɛ shūu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ndɔ p̂əɨ chhɔ ni lɨna məɨ. Nthɛ ŋa pi shi ŋgwɛ̄iŋ vəɨ ŋgə̄ɨ nɔ shhɨ pa kúŋ, ŋgwie vəɨ moŋ pa nda luoŋ Minnwi, ntigi vəɨ pəɨ thi sháʼa shhɨ pa ghaŋ shaʼa ŋgwa pugu pa fùoŋ nthɛ a ŋa pəɨ pɔ pa miŋkwentie paŋ shhɨ pugu. ");
INSERT INTO bmo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ndɔ pi shi ŋguʼɔ mfǔoŋ nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ ni ŋguoŋ taoŋ taoŋ ghao ndugwi mbhi ma nthɔ. ");
INSERT INTO bmo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ndɨɨ ŋa pi wɛ̄iŋ vəɨ nchaʼa mfɛ lɨʼɨ sháʼa nɛ, kiʼi njùʼɔ yəɨ ghana vəɨ ni nnu ŋa pəɨ shi nchhu nɛ, ndɔ pəɨ chhu sheshe nnu ŋa pi fɛ ni pəɨ nɛ ndɨɨ ghɔ, nthɛ ŋa a lɔ nchrā pəɨ, a chrā Jijwɛ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ŋoŋ shi nchaʼa ndǐŋ vi mfɛ ŋa pi jwi, tǎa fɛ muuŋ vi ŋa pi jwi, pa puoŋ kara mbara pa tǎa pugu pa maa ni nchhɔ̀ nchwīe pi jwi vugu. ");
INSERT INTO bmo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ŋguoŋ ŋgwa shi mbɨ̄na vəɨ nthɛ a. Ndɔ ŋoŋ ŋa a tīi shii ti ŋgə̄ɨ nchəɨŋ nɔ ndugwi yi nɛ shi ndūgu. ");
INSERT INTO bmo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ndɨɨ ŋa ɔ shi njəɨ nnu wuwuru ŋa a shi nchwīe pi tei Nda Minnwi thi lɨʼɨ haʼaŋ a shini ndɔ mfāʼo nɔ thi nu nɛ (shesheŋoŋ ŋa a mɛ̄iŋ yaoŋ yei nɛ pīʼi, nji ŋa a shi nji njiŋ nnu yei!) nnɛ ŋgwa pɛ ŋa pugu pɔ moŋ laʼataoŋ Judia nɛ tei ŋkuʼɔ thɔ mbra. ");
INSERT INTO bmo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kiʼi ŋoŋ ŋa a chhɔ thɔnda nɛ nuʼuŋ shwiʼi shhɛ ki nii nda yu nɔ lɔ̄gɔ nu sheshe yaoŋ ntaoŋ nɔ. ");
INSERT INTO bmo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kiʼi shesheŋoŋ ŋa a pɔ moŋ nyìeŋ nɛ nuʼuŋ mbɨnɨ lɨʼɨ lɔ̄gɔ mmɛ ndhwí yi. ");
INSERT INTO bmo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ndɔ a shi mbɔ ŋkiɛŋ wuwuru ŋgəʼɨ ni pa piŋgɛ shūu pugu pa mapuoŋ haʼaŋ pugu thɔ nuʼɔŋ puoŋ moŋ pɨɨ ndɨɨ ghɔ nɛ! ");
INSERT INTO bmo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pəɨ luoŋ ni Minnwi ŋa kiʼi nnu pei lɔ̄gɔ lɨʼɨ pi moŋ mbɨ̀, ");
INSERT INTO bmo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","nthɛ ŋa moŋ pɨɨ ndɨɨ pighɔ, ŋgəʼɨ shi mbɔ ti nchəɨŋ fɨʼɨ haʼaŋ a lɔ naa ma mbɔ jɛ̄ ndɨɨ ŋa Minnwi ni mbuoŋ mbhi nɛ ti nthɔ nchəɨŋ ndwɛ, ndɔ paʼa ndɔ mbiʼi piʼi ma nuʼuŋ mbɔ. ");
INSERT INTO bmo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ndɔ a kaŋ mieŋ ki pɔ ŋa Taathɔ kɛrɛ fɨʼɨ llɛmbhi pighɔ, yichəɨ ŋoŋmishua shi kaŋ ndɔ ndūgu, ndɔ, nthɛ pi pa ŋgwa pɛ ŋa a chuʼɔ vugu nɛ, a kɛrɛ llɛmbhi pighɔ. ");
INSERT INTO bmo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nɛnnɛ s̈hesheŋoŋ nchhu ni pəɨ ŋa, ‘Pəɨ līi njəɨ, Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ pɔ nɛiŋ hɛnɛiŋ!’ ki ŋa, ‘Pəɨ līi njəɨ, a pi ni hini,’ kiʼi pəɨ piŋ. ");
INSERT INTO bmo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nthɛ ŋa pa ŋgwa shi nthɔ ndɛʼi ŋgiɛŋ ŋa pugu Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, pa njəɨlɨʼɨ mifɨɨ shi nōoŋ noŋ yugu, nōoŋ ntou pa lì pugu pa nnu ghraoghrao, nɔ fɨ̄ɨ nu pa ŋgwa ti mfɨ̄ɨ pa ŋgwa haʼaŋ Minnwi chuʼɔ nɛ, nɔ haʼaŋ a njiʼɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ndɔ pəɨ chhɔ ni lɨna məɨ! Ŋ̀kwo chhu ŋguoŋ nnu ni pəɨ ŋkaoŋ ndɨɨ ghɔ ma nthɔ. ");
INSERT INTO bmo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ndɔ moŋ pɨɨ ndɨɨ ghɔ nɔ haʼaŋ ŋgəʼɨ pei shi ŋkwo tɔgɔ nɛ, ‘Minaoŋ shi ŋgū njiŋnjiŋ, ndɔ paʼa fhú lɔ nuʼuŋ nthɛ. ");
INSERT INTO bmo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Pa fɨ́nəɨ shi ŋgū nu shhɛ llɔ po, pa njɨ ŋa a pɔ moŋ tɔthɨ nɛ chɨ̄ʼɨ.’ ");
INSERT INTO bmo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Nɛnnɛ, pi shi njəɨ Muuŋ Ŋoŋmishua, a thɔ nu moŋ lúluŋ ni mmɛ ghrɨ́ pugu pa ndighaʼo. ");
INSERT INTO bmo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A shi ntaoŋ pa ghaŋ ntaoŋ Minnwi, pugu kɨrɨ pa ŋgwa pi ŋa a chuʼɔ nɛ llɔ moŋ khwɛ ghaa mbhi ti ŋgə̄ɨ nchəɨŋ moŋ ndugwi tɔthɨ. ");
INSERT INTO bmo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Yɛʼi ntɨ́gɨ llɔ ŋkuoŋ thɨ wùnu, nɔ haʼaŋ fhɔ̌ yi nuʼuŋ njɛ̄ tua nu ŋkuoŋ mbhɔ yi nɛ, ɔ ji ŋa ŋkwəɨ mbɨ̀ para. ");
INSERT INTO bmo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wuʼɔ nɛnnɛ, ndɨɨ ŋa pəɨ ŋkaa pəɨ yəɨ pa nnu pei thɔ ndɔ̄gɔ lɨʼɨ nɛ, pəɨ ji ŋa a kwo para ti mbɔ chonda. ");
INSERT INTO bmo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Shishini, ǹshwei vəɨ, mbaʼa ŋgwrɛiŋoŋ yei yiʼi ntɔgɔ ki ŋguoŋ pa nnu pei lɔ ndɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Po pugu shhɛ shi ntɔgɔ, ndɔ mbaʼa pa chrà paŋ yiʼi ntɔgɔ gha. ");
INSERT INTO bmo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ndɔ a mbɔ pi nɔ llɛ́ ghɔ pugu pa ndɨɨ ghɔ, yichəɨ ŋoŋ lɔ nji, njiʼi nthɛ pa ghaŋ ntaoŋ Minnwi po, ki Muuŋ, a wuʼɔ nji Tǎa təʼɨ vi. ");
INSERT INTO bmo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pəɨ lɨna nu, mbīri noŋ yəɨ, nthɛ ŋa pəɨ lɔ nji ndɨɨ ŋa ndɨɨ ghɔ shi nthɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“A pɔ pi nɔ ŋoŋ ŋa a chhɔ ŋgə̄ɨ kra, ŋga ndɔllɔ laʼa, nūʼɔŋ puoŋ fàʼa pi ŋa pugu tiʼi ndɨna ni pa yaoŋ, shesheŋoŋ fāʼo ji fàʼa, mfɛ gɨ́ ni ŋgaŋ lɨna ni chonda ŋa kiʼi a llɛ. ");
INSERT INTO bmo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nthɛ yie ghɔ, pəɨ pīri noŋ pəɨ, nthɛ ŋa pəɨ lɔ nji ndɨɨ ŋa ŋgaŋ nda ghɔ shi ŋkwəɨ nɛ. Ki a pɔ pi ni fanaoŋ, ki ni ntuŋ mbhi, ki moŋ ŋkhwɛmiŋkəʼɨ, ki ni tutuʼu. ");
INSERT INTO bmo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ä ŋgwīʼi nchəɨŋ, kiʼi a yəɨ ghɔ ɔ llɛ nu. ");
INSERT INTO bmo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nnu ŋa ǹchhu ni pəɨ nɛ, ǹchhu ni ŋguoŋ pa ŋgwa nduoŋ: P̂əɨ pīri noŋ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A ni mbiʼi paa llɛ́, llɛ́ Lli Njiʼa pugu llɛ́ Jɨ Brɛi ki Kuʼɔ kāʼo. Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi gɨ́ Mushi thɔ ntāʼa shɛndaoŋ nɔ wɛ̄iŋ nu Jishɔ njiŋnjiŋ njwi vi. ");
INSERT INTO bmo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pugu ni nchhu ŋa, “Mbaʼa a yiʼi mbɔ pi moŋ ndɨɨ jɨ yei kaŋ ŋgwa shi mbaʼo ŋgòu.” ");
INSERT INTO bmo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jishɔ ni ŋga mbɔ Betani nda Shemu ŋa a ni mbɔ ŋgaŋ ghɨnɔmbaluŋ nɛ, nɔ haʼaŋ a ni njɨ maoŋ ŋkuoŋ taprɛi nɛ, miŋgwɛ chəɨ nii ni nchɨ́ŋ ŋa pi chwīe ni ŋgùʼɔ, laminda taoŋtaoŋ ŋa pi mɛ̄iŋ ni nadi, mbɔ yi tɨnɨnchuoŋ lɨnaoŋ moŋ ghɔ. A pəʼɨ cho nchɨ́ŋ ghɔ, nshāʼo laminda ghɔ thɔ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pichəɨ ŋgwa chhu ni noŋ pugu fɔ moŋ pɨgɨtua ŋa, “A pɨrɨ wru laminda yei nɛnɛiŋ ŋa? ");
INSERT INTO bmo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","P̈i ka nì mfīni wru ghɔ, a tɔgɔ mbɨŋ ŋa ŋoŋ mfāʼa a tɔgɔ trɛi ŋkɨɨ llɛ́ pi pe vi nɔ ghɔ nɛ, mfɛ mbɨŋ ghɔ ni ghaŋ pou.” Nnɛ pugu fɛ̄ʼi vi. ");
INSERT INTO bmo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jishɔ chhu ni pugu ŋa, “Pəɨ mieŋ vi, pəɨ ghana vi ŋa? A chwīe pi nnu shiʼi vəɨ. ");
INSERT INTO bmo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nthɛ ŋa pəɨ pa ghaŋ pou shi ŋguʼɔ mbɔ nu kaʼa, ti sheshe ndɨɨ ŋa pəɨ khwā nɛ, pinthɛ pəɨ chwīe shiʼi ni pugu, ndɔ mbaʼa pia pɔ pi ŋguoŋ ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A chwīe nnu ŋa a kaŋ nthɛ a chwīe nɛ. A pīri noŋ a nɔ twei nu ŋkaoŋ ndɨɨ maa ŋkāʼo. ");
INSERT INTO bmo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ndɔ shishini, ǹshwei vəɨ, sheshe lɨʼɨ ŋa pi chīi ŋkɨ̀nɨ pwa pishaʼakhɔ fɔ moŋ mbhi nɛ, yaoŋ ŋa miŋgwɛ vei chwīe nɛ pi shi nchhu nɔ kwiŋ nu vi.” ");
INSERT INTO bmo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nnɛ Judashi Ishikario, ŋa a ni mbɔ taʼa ŋoŋ shɨna paanchrɔ ghaŋ younjiŋ Jishɔ nɛ, ghə̄ɨ mbara pa thishɨ ghaŋ fɛʼiŋgiɛŋ nnɛ nɔ fīni nu Jishɔ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pugu ni ŋga njaʼo mfāʼo pwatua, ŋkāʼa nɔ fɛ nu mbɨŋ ghɔ. Nnɛ a tāʼa shɨna nɔ fīni nu vi ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A ni ŋga mbɔ fǔoŋ llɛ́ Jɨ Brɛi ki Kuʼɔ, mbɔ llɛ́ ŋa pi ghà njwi muuŋ minjɨɨ Jɨ Lli Njiʼa nɛ, pa ghaŋ younjiŋ pi pie ghɔ ŋa, “Ɔ tāʼa nu ŋa pigi ghə̄ɨ mbīri maoŋ jɨ Lli Njiʼa vɛ pi hɨŋ?” ");
INSERT INTO bmo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A taoŋ paa ghaŋ younjiŋ pi, nchhu nu ni pugu ŋa, “Pəɨ ghə̄ɨ moŋ laʼa, pəɨ shi mbāoŋ pəɨ pa mimbia, a tiɛŋ kɨ̌ŋ ŋkhǐ thɔ yu, pəɨ yōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sheshe lɨʼɨ ŋa a nii nɛ, pəɨ chhu ni ŋgaŋ nda ghɔ ŋa, ‘Masha chhu ŋa, njiɛŋ nda pa ghɨ̀nɨ hɨŋ, mbɔ lɨʼɨ haʼaŋ a nthɛ ǹjɨ maoŋ Lli Njiʼa fɔ pigi pa ghaŋ younjiŋ paŋ nɛ?’ ");
INSERT INTO bmo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A shi nōoŋ mmɛ njiɛŋ nda tɔthɨ ni pəɨ pi kwo chwīe ti a kāʼo, pəɨ pīri fɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pa ghaŋ younjiŋ pi taoŋ ŋgə̄ɨ moŋ laʼa, njəɨ wuʼɔ ŋkwaŋ nɔ haʼaŋ a nì nuʼuŋ nchhu ni pugu nɛ, mbīri maoŋ jɨ Lli Njiʼa ghɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A gha mbɔ ni fanaoŋ, Jishɔ thɔ pugu pa paanchrɔ ghɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nɔ haʼaŋ pugu ni nchɔchhɔ ŋkuoŋ taprɛi njɨ maoŋ nɛ, Jishɔ chhu ni pugu ŋa, “Shishini, ǹshwei vəɨ, taʼa ŋoŋ vəɨ shi mfīni a, taʼa ŋoŋ ŋa pigi yu jɨ maoŋ kaʼa nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pugu jɛ̄ nthɔ mfāʼo pəʼɨ njùʼɔ, nchhu nu ghɔ pa taʼa taʼa ŋa, “A lɔ njiʼi mbɔ mmu, ki khɔ?” ");
INSERT INTO bmo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A chhu ni pugu ŋa, “A taʼa ŋoŋ shɨna paanchrɔ yei, yɛ ŋa pigi yu chrū brɛi moŋ pɛiŋ kaʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nthɛ ŋa Muuŋ Ŋoŋmishua shi ŋguʼɔ ŋgə̄ɨ pi nɔ haʼaŋ pi nāʼaŋ nthɛ vi nɛ, ndɔ ŋgəʼɨ shi ŋgwɛ̄iŋ ŋoŋ vɛ ŋa a fīni vi nɛ. A ni mbwa ghɔ ŋa kiʼi pi phi vi.” ");
INSERT INTO bmo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nɔ haʼaŋ pugu ni njɨ nu nɛ, a lɔ̄gɔ brɛi, ŋga ŋkwo tōo Minnwi, mbəʼɨ mfɛ ni pugu, nchhu ŋa, “Pəɨ kwe, yei frɛinoŋ a.” ");
INSERT INTO bmo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A lɔ̄gɔ ndua làʼo ŋga ŋkwo tōo Minnwi, mfɛ ni pugu, ŋguoŋ yugu nnu. ");
INSERT INTO bmo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A chhu ni pugu ŋa, “Yei chhǐ a, mbɔ yi kɨ̀na ŋa a shi ŋkwrī nthɛ ntou ŋgwa nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Shishini, ǹchhu ni pəɨ ŋa, mbaʼa ma nuʼuŋ nnu làʼo yei ŋkamuʼɔŋ ti ŋgə̄ɨ nchəɨŋ llɛ́ yɛ ŋa ǹshi nnu fifhi moŋ Shaʼafuoŋ Minnwi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pugu gha njrāo taʼa ŋkhǐ, ntaoŋ kəʼɨ ghɔ ŋkuʼɔ ŋkuoŋ Mbra pa Thɨ Olive. ");
INSERT INTO bmo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jishɔ chhu ni pugu ŋa, “Pəɨ shi ntei njiŋ a ghao nthɛ ŋa pi nāʼaŋ ŋa, ‘Ǹshi njwi ŋkɛ̄ʼi minjɨɨ, pa minjɨɨ sha.’ ");
INSERT INTO bmo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ndɔ pi shi ŋga ŋkwo kuʼɔ ni mmu moŋ gu, ŋ̀gə̄ɨ shhɨ pəɨ Galili.” ");
INSERT INTO bmo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ndɔ Pita chhu ghɔ ŋa, “Njiʼi nthɛ nɔ haʼaŋ ŋguoŋ ŋgwa shi ntei njiŋ yɔ ghao nɛ, m̀baʼa njiʼi ntei.” ");
INSERT INTO bmo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jishɔ chhu ghɔ ŋa, “Shishini, ǹshwei ghɔ, ni tuʼu yei ŋkaoŋ miŋkəʼɨ ma ŋkhwɛ̄ ni paa ŋgɛ́, ɔ shi ŋkwo lāa ni trɛi ŋgɛ́.” ");
INSERT INTO bmo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ndɔ Pita chhu tɨtɨnɨ ŋa, “Ä njiʼi mbɔ pi ŋa pɔgɔ khu paʼa ǹdɔ njiʼi ndāa ghɔ.” Ŋguoŋ yugu ghao wuʼɔ nchhu pi taʼa nnu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pugu ghə̄ɨ nɔ lɨʼɨ chəɨ pi mɛ̄iŋ ni Geshemani. Jishɔ chhu ni ghaŋ younjiŋ pi ŋa, “Pəɨ chɔchɔ hɛiŋ nɔ haʼaŋ ǹduoŋ Minnwi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A lɔ̄gɔ Pita, Jɛiŋ ni Jouŋ pugu pugu ghə̄ɨ. Ghaghana pugu pa yuʼɔ njùʼɔ shwiʼi mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A chhu ni pugu ŋa, “Njùʼɔ a ya mbəʼɨ ti minthɛ ŋka kukhu. Pəɨ kɨna hɛiŋ njra nu.” ");
INSERT INTO bmo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nchənə noŋ yi ŋgə̄ɨ shɨgɛi shhɨ, nshāoŋ ni puŋ yi shhɛ nduoŋ Minnwi ŋa a njiʼɛ, ndɨɨ ŋgəʼɨ ghɔ tɔgɔ vi. ");
INSERT INTO bmo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nchhu ŋa, “Baba, Tǎa a, ŋguoŋ nnu yīʼɛ mbhɔ ghɔ. Pɨʼɨ ndua ŋgəʼɨ yei ki ǹdɔ nnu. Ndɔ ti kiʼi a pɔ pi nɔ haʼaŋ ǹtāʼa nu nɛ, a pɔ nɔ haʼaŋ ɔ tāʼa nu ŋa a pɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nthɔ njəɨ vugu pugu llɛ nu, a chhu ni Pita ŋa, “Shemu, ɔ lɛllɛ? A nthɛ paʼa ɔ lɔ nchhɔ tɔthɨ nɔ taʼa awa? ");
INSERT INTO bmo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pəɨ chhɔ tɔthɨ nduoŋ Minnwi nnɛ ŋa kiʼi pəɨ gū moŋ mōoŋ nu. Jijwɛ yəɨ khwā nu ndɔ frɛinoŋ yəɨ pou ghrɨ́.” ");
INSERT INTO bmo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mbɨnɨ ndɔllɔ ŋgə̄ɨ nduoŋ Minnwi, ŋguʼɔ mbiʼi pi nnu yɛ ŋa a ŋkwo luoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A gha mbɨnɨ ŋkamuʼɔŋ njəɨ vugu pugu llɛ nu, nthɛ ŋa lɔgɔ ni ndɨnaoŋ ligi pugu, paʼa pugu lɔ nji nnu ŋa minthɛ pugu khwɛ̄ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A gha mbɨnɨ nthɔ ndɨɨ ghɔ nɔ trɛi ŋgɛ, nchhu ni pugu ŋa, “Pəɨ wuʼɔ nthɔ ndhɛ nu mfɛrɛ noŋ yəɨ? A kāʼo, ndɨɨ ghɔ kāʼo nɛ. Pi fīni Muuŋ Ŋoŋmishua liɛŋ mbhɔ pa ghaŋ phɨ. ");
INSERT INTO bmo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pəɨ lɔllɔ pia ghə̄ɨ. Pəɨ līi njəɨ, ŋoŋ ŋa a fīni a nɛ pɔ nɛiŋ!” ");
INSERT INTO bmo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wuʼɔ chomilaoŋ ghɔ, nɔ haʼaŋ a ni ŋguʼɔ nchrā nu nɛ, Judashi, mbɔ taʼa ŋoŋ shɨna paanchrɔ ghɔ thɔ pugu pa yú ŋgwa, pugu tuo kafa pugu pa wrɛ́i llɔ mbhɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, pugu pa ghaŋ yɛʼi gɨ́ Mushi pugu pa pichəɨ thishɨ. ");
INSERT INTO bmo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ŋoŋ ŋa a ni mfīni vi nɛ ni ŋkwo fɛ lì ni pugu, nchhu nu ŋa, “Ŋoŋ ŋa ǹshi mbaŋ vi nɛ, ju. Pəɨ wɛ̄iŋ vi, ŋkɛ̄ʼi vi ŋgə̄ɨ ni ju.” ");
INSERT INTO bmo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judashi ni ŋga nthɔ nchəɨŋ, ŋkuʼɔ mbara vi wuʼɔ ndɨɨ ghɔ, nchhu ŋa, “Masha!” Mbaŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nɛnnɛ pugu wɛ̄iŋ Jishɔ, nshīŋ vi ŋgə̄ɨ ni ju. ");
INSERT INTO bmo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ndɔ yichəɨ taʼa ŋoŋ ŋa a ni nthi fɔ nɛ shua kafa yi, nchhwi muuŋ fàʼa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ nɔ ghɔ, nche tə́nə yi. ");
INSERT INTO bmo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jishɔ chhu ni pugu ŋa, “M̀bɔ pi ŋgɨna minwi ŋa pəɨ thɔ nu ŋgwɛ̄iŋ ni pa kafa pugu pa wrɛ́i? ");
INSERT INTO bmo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pa lɛllɛ pia ghà ŋguʼɔ mbɔ Nda Minnwi, ǹjɛʼi nu, ndɔ paʼa pəɨ lɔ ŋgwɛ̄iŋ a. Ndɔ nnu pei lɔ̄gɔ lɨʼɨ nɔ chwīe nu chrà Minnwi thi nɔ haʼaŋ a ni nchhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ndɔ pa ghaŋ younjiŋ pi kwiɛŋ ghao ntei. ");
INSERT INTO bmo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Muuŋ chəɨ pɔrɔ njōu njiŋ yi ki lɔ māʼaŋ sheshe yaoŋ ŋkiɛŋ mbhɔ ndhwí ŋa a ni ŋgwara mbɨŋ yu, pugu wɛ̄iŋ vi. ");
INSERT INTO bmo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","A shrāo mbhɔ ndhwí ghɔ mieŋ mbhɔ pugu ntei ntontii. ");
INSERT INTO bmo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pi lɔ̄gɔ Jishɔ ŋgə̄ɨ nɔ shhɨ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ. Ŋguoŋ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa thishɨ ni pa ghaŋ yɛʼi gɨ́ Mushi kɨrɨ. ");
INSERT INTO bmo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ni njōu njiŋ yi mbɔ fie hini, nii moŋ yɨna taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ. Nchhɔ pugu pa ghaŋ kɛ̄ʼi lɨʼɨ nthɔ njɨgɔ móŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋguoŋ pa kúŋ ghao thɔ ntāʼa thɔ nnu haʼaŋ minthɛ pugu wɛ̄iŋ Jishɔ nɔ nnɛ ŋa minthɛ pugu jwi vi, ndɔ paʼa ndɔ mfāʼo. ");
INSERT INTO bmo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nthɛ ŋa ntou pa ŋgwa ni nthɔ nchhu pa nnu mbe thɔ yu. Ndɔ pa nnu pighɔ ŋa pugu ni nchhu nɛ taoŋ pi nduoŋnduoŋ. ");
INSERT INTO bmo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pichəɨ ŋgwa lɔllɔ ndɛʼi ŋgiɛŋ yei thɔ yu, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Pigi ni njaʼo a chhu ŋa, ‘Ǹshi nshāʼa Nda Minnwi yei ŋa pi chwīe pi ni mbhɔ nɛ, ndɔ̄gɔ trɛi llɛ́ ŋkrao yi nduoŋ, ki lɔ mbɔ yi krao ni mbhɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ndɔ njiʼi nthɛ pi nɔ yei nnu, paʼa nchò yugu lɔ mbɔ taʼa yi. ");
INSERT INTO bmo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ lɔllɔ ntithi shhɨ mbie Jishɔ ŋa, “Ɔ lɔ ŋkhwɛ̄ nnu pei ŋa ŋgwa pei chhu nthɛ ghɔ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jishɔ wuʼɔ ndɛrɛ pi laŋ ki lɔ nchrā kaŋ taʼa nnu. Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ghɔ pɨnɨ mbie vi ŋa, “A gɔ̀ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, mbɔ Muuŋ Ŋoŋ ŋa pigi ghà ŋgaʼo nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jishɔ chhu ŋa, “MI JU! Pəɨ shhi njəɨ Muuŋ Ŋoŋmishua pi chərə vi ŋgei mbhɔ jɨ Ŋoŋ ŋa a Fāʼo Ŋguoŋ Ghrɨ́ nɛ, a thɔ nu pugu pa lúluŋ po.” ");
INSERT INTO bmo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ shāa ndhwí yi nchhu ŋa, “Pia nuʼuŋ ntāʼa pa miŋkwentie nchwīe khɔ nɔ? ");
INSERT INTO bmo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pəɨ yaʼo chrà nchɨʼəshə yei. Nthí məɨ pɔ pi ŋa?” Pugu kwaʼa nchhu ŋa, “A ŋgushaʼa, mbie ŋa pi jwi vi.” ");
INSERT INTO bmo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pichəɨ jɛ̄ thu nu thwɛ mbɨŋ yu, mbūoŋ ligi yi nchwi vi, nchhu nu ŋa, “Tha ŋa a chhwi gɔ̌ nchhwi ghɔ.” Pa ghaŋ kɛ̄ʼi lɨʼɨ lɔ̄gɔ vi nchrə̄ɨ lrì thɔ yu. ");
INSERT INTO bmo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ni ŋguʼɔ mbɔ mbɛmbiɛŋ moŋ yɨna. Yichəɨ taʼa muuŋ fàʼa, mbɔ miŋgwɛ mbɔ muuŋ fàʼa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ thɔ, ");
INSERT INTO bmo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","njəɨ Pita thɔ njɨgɔ móŋoŋ. Mbɛʼi Pita nchhu ŋa, “Gɔgɔ ŋkaa ghɔ ni mbɔ pəɨ Jishɔ llɔ Nasharɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ndɔ a lāa, nchhu nu ŋa, “Ǹdɔ nji, ndɔ paʼa thɔ a lɔ nshie ni nnu ŋa ɔ chhu nu nɛ.” Ndɔ Pita ghɔ lɔllɔ ŋgə̄ɨ ŋkuoŋ shɛndaoŋ ŋa a taoŋ choŋkaʼa nɛ. Wuʼɔ ndɨɨ ghɔ miŋkəʼɨ khwɛ. ");
INSERT INTO bmo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Muuŋ fàʼa ghɔ pɨnɨ njəɨ vi njɛ̄ chhu nu ni ŋgwa pɛ ŋa pugu ni nthi fɔ nɛ ŋa, “Ŋoŋ vei taʼa ŋoŋ vugu.” ");
INSERT INTO bmo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ndɔ a pɨnɨ nuʼuŋ ndāa ŋkamuʼɔŋ. A gha ndara shɨgɛi, ŋgwa pighɔ ŋa pugu ni nthi fɔ nɛ jɛ̄ chhu nu ni Pita ŋa, “Shishini, ɔ taʼa ŋoŋ vugu. Ɔ ŋoŋ Galili.” ");
INSERT INTO bmo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A jɛ̄ chɔ̄nɔ nu noŋ yi nshwrɛ̄i nu ŋa, “Ndɔ nji ŋoŋ vei ŋa pəɨ chrā nu nthɛ vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wuʼɔ ndɨɨ ghɔ, miŋkəʼɨ pɨnɨ nuʼuŋ ŋkhwɛ. Pita kwiŋ ŋkwaŋ nɔ haʼaŋ Jishɔ ni nchhu ghɔ ŋa, “Ŋkaoŋ miŋkəʼɨ ma ŋkhwɛ̄ ni paa ŋgɛ, ɔ shi ndāa a ni trɛi ŋgɛ.” Pita wɛ̄iŋ noŋ yi kie nshaʼa ni kə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A ni ŋga mbɔ ŋkiɛŋ ni tutuʼu, pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pichəɨ thishɨ pugu pa ghaŋ yɛʼi gɨ́ Mushi ni ŋguoŋ pa kúŋ ghao paoŋ mbini. Ŋkrao Jishɔ ndɔ̄gɔ vi ŋgə̄ɨ nchaʼa vi mfɛ ni Pailɛ. ");
INSERT INTO bmo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailɛ pie vi ŋa, “Ɔ fùoŋ pa Juu?” A khwɛ̄ ghɔ ŋa, “A haʼaŋ ɔ chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ tigi ntou pa nnu thɔ yu. ");
INSERT INTO bmo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailɛ pɨnɨ mbie vi ŋa, “Ɔ lɔ njiʼi mfāʼo khwɛ̀ nɔ fɛ nu? Līi njəɨ fɨʼɨ pa nnu ŋa pugu chhu nthɛ ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ndɔ paʼa Jishɔ lɔ nuʼuŋ ŋkhwɛ̄ sheshe nnu, nnɛ Pailɛ ghrāo. ");
INSERT INTO bmo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A ghà mbɔ llɛ́ Jɨ Lli Njiʼa, Pailɛ chuʼɔ taʼa ŋgaŋ chəɨŋ ŋa ŋgwa pie ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ŋoŋ chəɨ ni mbɔ moŋ chə́ɨŋ shɨna pa ghaŋ tɨnɨthɔ pɛ ŋa pugu ni njwi ŋoŋ ndɨɨ ŋa minduoŋnduoŋ ni ŋgū moŋ laʼa nɛ, ligi yi pɔ Baraba. ");
INSERT INTO bmo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pa yú ŋgwa pighɔ ghə̄ɨ mbara Pailɛ, mbie vi ŋa a chwīe nɔ haʼaŋ a ghà mbīgi nchwīe nɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A khwɛ̄ ni pugu ŋa, “Pəɨ tāʼa nu ŋa nchuʼɔ ‘Fùoŋ pa Juu’ mfɛ ni pəɨ?” ");
INSERT INTO bmo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nthɛ ŋa a ni nji ŋa pa thishɨ ghaŋ fɛʼiŋgiɛŋ ni ŋgwɛ̄iŋ vi nthɔ mfɛ ghɔ nthɛ pi kighɨʼə. ");
INSERT INTO bmo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ndɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ kāoŋ yú ŋgwa pighɔ ŋa pugu pie ŋa Pailɛ chuʼɔ pi Baraba. ");
INSERT INTO bmo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailɛ pɨnɨ nchhu ŋa, “Ti mi shi mbɔ pi nɛiŋ ni ŋoŋ ŋa pəɨ mɛ̄iŋ vi ni Fùoŋ pa Juu nɛ?” ");
INSERT INTO bmo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pugu paʼo ŋgòu ni njɨ ŋa, “Kwīŋ vi ŋkuoŋ wáʼa!” ");
INSERT INTO bmo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailɛ pie ŋa, “Nthɛ khɔ? Nnu pɨphɨ ŋa a chwīe nɛ pɔ pi khɔ?” Ndɔ pugu pɨnɨ mbaʼo ŋgòu mbīgi ŋgə̄ɨ shhɨ, “Kwīŋ vi ŋkuoŋ wáʼa!” ");
INSERT INTO bmo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nnɛ Pailɛ tāʼa nu nchwīe ŋa túa yú ŋgwa pighɔ pwa, nchuʼɔ Baraba mfɛ ni pugu, ŋga ŋkwo wie Jishɔ, nchaʼa vi mfɛ ŋa pi kwīŋ vi ŋkuoŋ wáʼa. ");
INSERT INTO bmo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pa shoogɛ lɔ̄gɔ Jishɔ nii nɔ moŋ yɨna ntuʼɔ ŋgaŋ shaʼa ŋgwa, mɛ̄iŋ ŋguoŋ kwíe ntɨgao ŋkɨɨ shoogɛ ghao lɨʼɨ muʼɔŋ. ");
INSERT INTO bmo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pugu māʼaŋ pɨ̀rɨ mbɨŋ yu, mbaʼa ŋkie ni pa michwɛʼichwɛʼi shhɔ̄ thɔ yu. ");
INSERT INTO bmo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pugu jɛ̄ nthɔ ŋgɨnɔ vi, nchhu nu ŋa, “Nduunya! Ma Fùoŋ pa Juu!” ");
INSERT INTO bmo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nthɔ ŋkwāʼa thɔ yi ni muuŋ thɨ, nthɔ nthu thwɛ mbɨŋ yu, ŋkwi kwɛ́rɛ yugu ŋgaʼo vi. ");
INSERT INTO bmo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pugu ni ŋga ŋkwo māʼaŋ vi ni kwə̀ɨŋ ti mīʼɛŋ, nshrāo pɨ̀rɨ ghɔ mbɨŋ yu, māʼaŋ ji ndhwí mbɨŋ yu, ŋgə̄ɨ ni ju lɨʼɨ kwīŋ ŋkuoŋ wáʼa. ");
INSERT INTO bmo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pugu ŋɨ ŋoŋ chəɨ ŋa ligi ni mbɔ Shemu llɔ Shiriŋ ŋa tiɛŋ wáʼa yi. Ŋoŋ ghɔ ni mbɔ tǎa Alɛshanda pugu Rufushi, ŋa a ni nii nu moŋ tri laʼa llɔ moŋ ŋgunu. ");
INSERT INTO bmo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pugu lɔ̄gɔ Jishɔ ŋgə̄ɨ lɨʼɨ haʼaŋ pi mɛ̄iŋ ŋa Gogota. Njiŋ yi pɔ ŋa, “Lɨʼɨ Kwéi Thɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pugu fɛ làʼo ghɔ ŋa pi nyāaŋ ni yichəɨ fhɔ̌ yúʼɔ pi mɛ̄iŋ ni məə, ndɔ a lāa ki lɔ nnu. ");
INSERT INTO bmo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pugu kwīŋ vi ŋkuoŋ wáʼa, ŋgrā ndhwí yi shɨna pugu, māʼaŋ yaoŋ nɔ pɛʼi, nɔ yəɨ nu ŋa shesheŋoŋ vugu shi njɨ pi yəɨ pra ndhwí yi. ");
INSERT INTO bmo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A ni mbɔ ndipuʼu minaoŋ ni tutuʼu ŋa pugu ni ŋkwīŋ vi ŋkuoŋ wáʼa. ");
INSERT INTO bmo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pi nāʼaŋ nnu ŋa pugu ni ŋgwɛ̄iŋ vi nɔ ŋkwīŋ vi ŋkuoŋ wáʼa nɛ ŋa, “Fùoŋ pa Juu.” ");
INSERT INTO bmo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pi kwīŋ vi pugu pa paa ŋgɨna. Taʼa yi ŋgei mbhɔ jɨ, taʼa yi ŋgei mbhɔ ŋkwrɛi. ");
INSERT INTO bmo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nɛnnɛ chrà Minnwi yɛ ŋa pi ni nāʼaŋ ŋa pi ni shia vi shɨna ghaŋ chwīe phɨ nɛ ni ndɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ŋgwa pɛ ŋa pugu ni ntɔgɔ nu nɛ ni nthɔ ŋgwɛʼi vi, nchɨʼɨ thɔ yugu, nchhu nu ŋa, “Hoho! Ɔ ni ntāʼa nu shāʼa Nda Minnwi mbɨnɨ ŋkrao moŋ trɛi llɛ́. ");
INSERT INTO bmo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kwe nɛ noŋ yɔ nshwiʼi ŋkuoŋ wáʼa pia.” ");
INSERT INTO bmo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wuʼɔ nɛnnɛ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi gɨ́ Mushi māʼaŋ vi ni kwə̀ɨŋ shɨna pugu ni noŋ yugu nchhu ŋa, “A ni ŋkwe ŋgwa nduoŋ, ndɔ minthɛ paʼa a lɔ ŋkwe noŋ yi. ");
INSERT INTO bmo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe, mbɔ Fùoŋ ŋgwa Ishrae, shwiʼi nɛ ŋkuoŋ wáʼa, nnɛ ŋa minthɛ pigi yəɨ mbiŋ vi.” Ŋgwa pɛ ŋa pi ni ŋkwīŋ vugu pugu kaʼa nɛ māʼaŋ vi ni kwə̀ɨŋ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A ni ŋga mbɔ moŋ ntuŋ minaoŋ, njiŋnjiŋ gū moŋ ŋguoŋ laʼa ghao ti ŋgə̄ɨ nchəɨŋ moŋ trɛi minaoŋ ni naoŋchɨ. ");
INSERT INTO bmo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A gha mbɔ moŋ trɛi minaoŋ ghɔ, Jishɔ chhu ŋkiɛŋ ni njɨ ŋa, “Eloi, Eloi, lema shabatani?” njiŋ yi pɔ ŋa, “Minnwi a, Minnwi a, ɔ mīʼaŋ a ŋa?” ");
INSERT INTO bmo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pichəɨ ŋgwa ŋa pugu ni nthi fɔ nɛ gha njaʼo nnu ghɔ nchhu ŋa, “Līi njəɨ, a chhɔ mɛ̄iŋ pi Elaija.” ");
INSERT INTO bmo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yichəɨ ŋoŋ tei ŋgə̄ɨ niʼiŋ kusha moŋ làʼo chəchɨgəɨ, nchwɛʼi thɔ muuŋ thɨ, mfɛ ghɔ ŋa a nnu, nchhu nu ŋa, “Pəɨ tithi pia yəɨ ŋa Elaija shi nthɔ nshwiʼi vi shhɛ!” ");
INSERT INTO bmo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jishɔ paʼo ŋgòu ndɔ ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ndhwí kɨʼɨ lɨʼɨ Nda Minnwi shāa ntaoŋ yi paa, llɔ tɔthɨ nshwiʼi mfɛ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nthishɨ pa taʼa ŋkɨɨ shoogɛ ŋa a ni nthi fɔ nthɔ mbɛʼi vi nɛ, gha njəɨ ŋa yei ŋkwaŋ haʼaŋ a khu nɛ, nchhu ŋa, “Shishini, ŋoŋ vei ni mbɔ Muuŋ Minnwi!” ");
INSERT INTO bmo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pichəɨ piŋgɛ ni nthi hini njiʼɛ mbɛʼi nu. Shɨna piŋgɛ pighɔ ni mbɔ Meri Madaliŋ pugu Meri mǔuŋ Jɛiŋ mikəʼɨ pugu Joshɛshi, ni Shalome. ");
INSERT INTO bmo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ndɨɨ ŋa a ni mbɔ Galili nɛ, pugu yōu njiŋ yi ŋgɛ̄rɛ vi. Ntou pa piŋgɛ nduoŋ ŋa pugu pa Jishɔ ni ŋkuʼɔ Jerushalɛiŋ kaʼa ni mbɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Fanaoŋ ni ŋkwo thɔ nu, yichəɨ ŋoŋ ligi yi pɔ Joshɛ llɔ Arimatia chəɨŋ. A ni mbɔ ŋkiɛŋ ŋoŋ nda pa kúŋ, ni nthɔ njwɛrɛ Shaʼafuoŋ Minnwi ŋa a thɔ. A ni mbɔ llɛ́ pīri nu noŋ (mbɔ llɛ́ ŋa a fɛ ni llɛ́ Ji pa Juu nɛ). Joshɛ wɛ̄iŋ njùʼɔ yi, ŋgə̄ɨ shhɨ Pailɛ nduoŋ khu Jishɔ mbhɔ yu. ");
INSERT INTO bmo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailɛ ni ŋgrāo nɔ yaʼo nu ŋa Jishɔ kwo khu. Mɛ̄iŋ nthishɨ pa taʼa ŋkɨɨ shoogɛ mbie vi ŋa Jishɔ kwo khu. ");
INSERT INTO bmo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","A ni ŋga njaʼo mbhɔ nthishɨ pa taʼa ŋkɨɨ shoogɛ ghɔ ŋa a kwo khu, mfɛ khu yi ni Joshɛ. ");
INSERT INTO bmo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joshɛ yuoŋ mbhɔ ndhwí fhu, nshwiʼi khu Jishɔ shhɛ, ndiŋ vi moŋ ndhwí fhu ghɔ, niʼiŋ moŋ fúŋ ŋa pi fīʼi moŋ ŋgùʼɔ nɛ. Ŋkə̄nə ŋgùʼɔ nchri chofuŋ ghɔ nɔ. ");
INSERT INTO bmo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Madaliŋ, ni Meri mǔuŋ Joshɛshi yəɨ lɨʼɨ ŋa pi ni ntwei vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Llɛ́ Ji ni ŋga ntɔgɔ, Meri Madaliŋ pugu Meri muuŋ Jɛiŋ ni Shalome yuoŋ pa wru laminda, nɔ ghə̄ɨ nu nshāʼo mbɨŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","A gha mbɔ ŋkiɛŋ ni muuŋ tutuʼu ndɨɨ ŋa minaoŋ ni ŋkwo shaʼa moŋ fǔoŋ llɛmbhi, mbɔ Shonde, pugu ghə̄ɨ chofuŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pugu chhu nu ni noŋ pugu ŋa, “A shi ŋkə̄nə gɔ̌ ŋgùʼɔ mbɨʼɨ chofuŋ mfɛ ni pia?” ");
INSERT INTO bmo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ŋga ndīi nu nɛ, njəɨ pi kwo ŋkə̄nə ŋgùʼɔ ghɔ. A ni mbɔ ŋkiɛŋ mmɛ ŋgùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pugu gha nii moŋ fúŋ ghɔ, njəɨ yichəɨ maʼaŋ mikhwa chhɔ fɔ ŋgei mbhɔ jɨ, māʼaŋ shalaoŋ fhu, pugu ghrāo. ");
INSERT INTO bmo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A chhu ni pugu ŋa, “Kiʼi pəɨ nuʼuŋ ŋgrāo, pəɨ tāʼa pi Jishɔ llɔ Nasharɛ ŋa pi ni ŋkwīŋ vi ŋkuoŋ wáʼa nɛ. A kwo kuʼɔ, a lɔ njiʼi mbɔ hɛiŋ. Līi njəɨ, yei lɨʼɨ yɛ ŋa pi ni nūʼɔŋ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ndɔ pəɨ ghə̄ɨ nchhu ni ghaŋ younjiŋ pi, pugu pa Pita ŋa, ‘A ghə̄ɨ nu nɛ shhɨ pəɨ moŋ Galili. Pəɨ shi njəɨ vi fɔ, wuʼɔ nɔ haʼaŋ a ni nshwei vəɨ nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Thɔ yugu ni fiŋ, pugu wrū nu nthɛ pɔgɔ gu, ntaoŋ moŋ fúŋ ghɔ ntei. Pugu shini ndɔ nchhu kaŋ taʼa nnu ni shesheŋoŋ nthɛ ŋa pɔgɔ gu ni ŋgwɛ̄iŋ vugu. Pichəɨ pa fǔoŋ ndunu Ŋwaʼaŋlɨ Minnwi llɛshhɨ lɔ njiʼi mfāʼo jɛ̄ moŋ ghrà ndipuʼu ti ŋgə̄ɨ nchəɨŋ nɔ ndugwi yi. ");
INSERT INTO bmo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ndɨɨ ŋa Jishɔ ni ŋkwo kuʼɔ ŋkiɛŋ ni muuŋ tutuʼu ni Shonde nɛ, mfǔoŋ nōoŋ noŋ yi pi ni Meri Madaliŋ, mbɔ miŋgwɛ yɛ ŋa a ni mfuʼu khwachəɨ miŋwɛiŋ mbɨŋ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","A ghə̄ɨ nshwei ŋgwa pɛ ŋa pugu pa Jishɔ ni mbɔ nu kaʼa nɛ, ŋa pugu ni nthɔ ŋkə̄ɨ nu ndɔ njūa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pugu ni ŋga njaʼo ŋa Jishɔ yi maoŋ, Meri Madaliŋ ghɔ kwo yəɨ vi nɛ, paʼa ndɔ mbiŋ. ");
INSERT INTO bmo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pa nnu pei ni ŋga ntɔgɔ, Jishɔ nōoŋ noŋ yi moŋ shɛndaoŋ nduoŋ ni paa ghaŋ younjiŋ pi ndɨɨ ŋa pugu ni mbɔ shɛndaoŋ ŋgə̄ɨ nu moŋ laʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pugu pɨnɨ nchhu ni pichəɨ, ndɔ paʼa pugu lɔ mbiŋ nnu ŋa pugu ni nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pa nnu pei gha ntɔgɔ, Jishɔ nōoŋ noŋ yi ni taʼanchrɔ ghaŋ ntaoŋ pi ndɨɨ ŋa pugu ni njɨ maoŋ nɛ, mbɨ̄ga vugu nthɛ pou piŋ yugu pugu pa tɨnɨthɔ nɔ piŋ nu nnu ŋa ŋgwa pɛ ŋa pugu yəɨ vi a pɔ yi maoŋ chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A chhu ni pugu ŋa, “Pəɨ ghə̄ɨ moŋ ŋguoŋ mbhi ghao, nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ ni ŋguoŋ ŋgwamishua ghao. ");
INSERT INTO bmo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Shesheŋoŋ ŋa a piŋ ndɔ ŋkwe ŋkhǐ nɛ shi ndūgu. Ndɔ shesheŋoŋ ŋa a lɔ mbiŋ nɛ shi mfāʼo njɔ́ nɔ ŋgushaʼa. ");
INSERT INTO bmo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pa lì pei shi njōu njiŋ ŋgwa pɛ ŋa pugu piŋ nɛ. Ni ligi a pugu shi mfuʼu pa miŋwɛiŋ, nchrā moŋ pa chrà fhi. ");
INSERT INTO bmo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pugu shi ŋgwɛ̄iŋ pa mitwɛʼi, ti p̈ugu nnu sheshe njɨʼɨ, paʼa kàʼa lɔ ŋkēe vugu. Pugu shi nūʼɔŋ mbhɔ yugu ŋkuoŋ pa ghaŋ ghɨ̌nɔ, noŋ yugu tɔgɔ.” ");
INSERT INTO bmo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nɛnnɛ Jishɔ Taathɔ ni ŋga mīʼɛŋ chrā nu ni pugu, pi lɔ̄gɔ vi ŋkuʼɔ nɔ po, nchərə ŋgei mbhɔ Minnwi yi jɨ. ");
INSERT INTO bmo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pugu taoŋ chhu chrà Minnwi ŋguoŋ lɨʼɨ, Taathɔ fāʼa pugu pugu nōoŋ ŋa chrà ŋa pugu chhu nu nɛ yi shini ntɔgɔ pi ŋkuoŋ pa lì.");
INSERT INTO bmo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ndɔ haʼaŋ ntou ŋgwa paʼo nɔ nāʼaŋ nu pa nnu pɛ ŋa a lɔ̄gɔ lɨʼɨ shɨna pia nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","wuʼɔ ŋkwaŋ haʼaŋ pia nuʼuŋ njaʼo mbhɔ ŋgwa haʼaŋ pugu ni mbɔ nɔ njɛ̄ yi, njəɨ mbɨnɨ nuʼuŋ nchīi chrà Minnwi, ");
INSERT INTO bmo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","nthɛ ŋa ŋ̀kwo ya ntou ŋguoŋ pa nnu shishiʼi ŋkwaŋ haʼaŋ a ki kie llɔ nɔ njɛ̄ yi nɛ, a pwa ŋa ǹāʼaŋ nnu pighɔ mfɛ vɛ ŋkwaŋ haʼaŋ a ki ya ntɔgɔ nɛ, ma Tiofilu ŋoŋ ndiɛŋ, ");
INSERT INTO bmo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","nɛnnɛ ŋa mimfɛ ɔ ya nji shishiʼi pa nnu haʼaŋ pi shwei ghɔ nɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A ni mbɔ thɔ Hɛrɔ, mbɔ fùoŋ Judia, yichəɨ ŋgaŋ fɛʼiŋgiɛŋ Minnwi ni mbɔ fɔ, ligi yi pɔ Shakaria. A ni ndhɔ moŋ ghrà ghaŋ fɛʼiŋgiɛŋ Minnwi, llɔ moŋ ndaaŋoŋ Abija. A ni mfāʼo ŋgwɛ vi llɔ moŋ ŋgwrɛiŋoŋ Ɛroŋ, ligi yi ni mbɔ Ɛlishabe. ");
INSERT INTO bmo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ŋguoŋ vugu ni mbɔ ŋgwa ndɨndɨ shhɨ Minnwi, nthɔ nūʼɔŋ ŋguoŋ kɨ̀na pugu pa gɨ́ Taathɔ ndɔ ki lɔ mfāʼo ntəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ndɔ paʼa pugu lɔ njiʼi fāʼo muuŋ, nthɛ ŋa Ɛlishabe ni mbɔ pi ŋkhwɛ̄, ndɔ pugu ni ŋkwo ya ndunu. ");
INSERT INTO bmo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A ni ŋga mbɔ llɛ́ chəɨ, a pɔ ndɨɨ ghrà pa Shakaria nɔ fāʼa nu nɔ ghaŋ fɛʼiŋgiɛŋ Minnwi, Shakaria fɛ̄ʼi nu, ");
INSERT INTO bmo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ŋkwaŋ haʼaŋ nùʼɔŋ ghaŋ fɛʼiŋgiɛŋ Nda Minnwi ni mbɔ nɛ, pugu māʼaŋ yaoŋ nɔ yəɨ nu ŋoŋ ŋa Minnwi chuʼɔ ŋa a tūoŋ *lěi nɛ. A gū mbɨŋ yu ŋa a nii ju Nda Minnwi lɨʼɨ tūoŋ yichəɨ ŋkwaŋ lěi nɔ ghaʼo nu Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ntou ŋgwa ni mbɔ mbhi nchhɔ nduoŋ Minnwi moŋ ndɨɨ ghɔ ŋa pi ni nthɔ ntūoŋ lěi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ŋgaŋ ntaoŋ Taathɔ nōoŋ noŋ yi yəɨ yu, nthi ŋgei mbhɔ jɨ lɨʼɨ fɛʼiŋgiɛŋ ŋa pi ni ntūoŋ lěi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Shakaria ni ŋga njəɨ vi, njùʼɔ yi taoŋ, pɔgɔ gu wɛ̄iŋ vi. ");
INSERT INTO bmo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ndɔ ŋgaŋ ntaoŋ ghɔ chhu ŋa, “Kiʼi mfāʼo pɔgɔ gu, ma Shakaria. Minnwi yaʼo luoŋ yɔ. Ɛlishabe ŋgwɛ ghɔ shi mbhi muuŋ mimbia ɔ chhɔ̄ ligi yi ni Jouŋ. ");
INSERT INTO bmo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Muuŋ vei shi mbɔ pwanjuʼɔ ni pwatua vɛ, ntou ŋgwa pɨnɨ mfāʼo pwanjuʼɔ ŋa pi phi vi. ");
INSERT INTO bmo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","A shi mbɔ mmɛŋoŋ shhɨ Taathɔ. Kiʼi a ma nnu làʼo ki sheshe làʼo tɨtɨnɨ. A shi ndɨnaoŋ ni Jijwɛ Minnwi llɔ ndɨɨ ŋa a pɔ moŋ puŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A shi nchwīe ntou puoŋ Ishrae pɨ̄nɨ mbara Taathɔ vugu, mbɔ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A shi ŋgə̄ɨ ju nɔ likiɛŋ Taathɔ moŋ jijwɛ pugu pa ghrɨ́ nɔ yi njəɨlɨʼɨ Minnwi mbɔ Elaija, nɔ chīni nu njùʼɔ pa tǎa pugu pa yi puoŋ, ŋkara pa ntɨnɨthɔ pugu kwəɨ ŋkuoŋ mbha shiethɔ ŋgwa ndɨndɨ nɛnnɛ nɔ nchwīe nu ŋgwa ŋa pugu pīri noŋ yugu ni Taathɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Shakaria pie ni ŋgaŋ ntaoŋ ghɔ ŋa, “Mi shi ŋkie pi nɛiŋ mfāʼo tɨnɨnjuʼɔ ni nnu pei ŋa ŋ̀kwo lulunu ŋgaʼa, ŋgwɛ a kwo lulunu ŋkaa yu nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ŋgaŋ ntaoŋ ghɔ khwɛ̄ ghɔ ŋa, “Mi Gabreya. Ǹthi shhɨ Minnwi, ŋa a taoŋ a ŋa ǹchrā vɛ ndɔ nshwei ghɔ ni pwa pishaʼakhɔ yei. ");
INSERT INTO bmo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Līi njəɨ, nthɛ ŋa ɔ lɔ njiʼi mbiŋ chrà a nɛ, ɔ shi ŋgū fhɨncho ti ŋgə̄ɨ nchəɨŋ llɛ́ yɛ ŋa nnu pei shi ndɔ̄gɔ lɨʼɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pa ŋgwa ni nchhɔ njwɛrɛ Shakaria, nthɔ ŋgrāo nu ŋkwaŋ nɔ haʼaŋ a yiyiri Nda Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","A gha ntaoŋ mfɨfhɨ, pugu yəɨ kiʼɛ ŋa a yəɨ pi nnu Nda Minnwi, a thɔ nōoŋ nnu pi ni mbhɔ ŋkɨna mbɔ fhɨncho. ");
INSERT INTO bmo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ndɨɨ ŋa ndɨɨ fàʼa yi Nda Minnwi ni mmɛ nɛ, a pɨ̄nɨ laʼa. ");
INSERT INTO bmo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pa llɛ́ gha ntɔgɔ, Ɛlishabe ŋgwɛ vi shūu, ndə̄ɨŋ noŋ yi nɔ tiɛŋ nàoŋ, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yei nnu ŋa Taathɔ fāʼa mbɨŋ mu, Taathɔ līi a ni pwapuŋ nɔ pɨʼɨ nu lrithɔ mbɨŋ mu shɨna ŋgwamishua.” ");
INSERT INTO bmo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A ni ŋga mbɔ ndɨɨ ŋa Ɛlishabe ni ŋkwo shūu nɔ ntɨgao nàoŋ nɛ, Minnwi taoŋ ŋgaŋ ntaoŋ vi, mbɔ Gabreya, ŋa a ghə̄ɨ Nasharɛ, mbɔ yichəɨ lɨʼɨ Galili, ");
INSERT INTO bmo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","njəɨ muuŋ miŋgwɛ chəɨ, ligi yi pɔ Meri, ŋa a shi yaʼa ji mimbia nɛ. Pi ni nōoŋ vi ni Joshɛ nɔ ŋgwɛ vi. Joshɛ ni mbɔ ŋoŋ llɔ moŋ ndaaŋoŋ fùoŋ Devi. ");
INSERT INTO bmo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ŋgaŋ ntaoŋ ghɔ ghə̄ɨ nchhu ni Meri ghɔ ŋa, “Ǹchrā vɛ, ma mbrɔthɔ miŋgwɛ, Taathɔ pɔ pəɨ yu kaʼa!” ");
INSERT INTO bmo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri fāʼo fiŋthɔ, mbɨnɨ ŋgrāo ŋa yei pɔ pi yəɨ ŋkwaŋ chrā nu nɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ŋgaŋ ntaoŋ ghɔ chhu ghɔ ŋa, “Kiʼi mfāʼo pɔgɔ gu, ma Meri, Minnwi lɔ̄gɔ nthi mi nɔ nōoŋ nu pwapuŋ vɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Līi njəɨ, ɔ shi nshūu mbhi muuŋ mimbia nchhɔ̄ ligi yi ni Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A shi mbɔ ŋkiɛŋ mmɛŋoŋ ndiɛŋ, pi mɛ̄iŋ vi ni Muuŋ Minnwi ŋa a Chaapifuoŋ nɛ. Minnwi Taathɔ shi nchərə vi ŋkuoŋ faaŋ tǎa vi, mbɔ Devi. ");
INSERT INTO bmo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A shi nshaʼa ŋgwrɛiŋoŋ Jakɔ nɔ ŋguoŋ ndɨɨ, mbaʼa ndugwi Shaʼafuoŋ yi ma njiʼi mbɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri pie ŋgaŋ ntaoŋ ghɔ ŋa, “Mimfɛ a kie pi nɛiŋ mbɔ nnɛ, ŋa ǹdɔ naa nji mimbia nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ŋgaŋ ntaoŋ khwɛ̄ ghɔ ŋa, “Jijwɛ Minnwi shi nshwiʼi mbɨŋ ghɔ. Njɨ ju ŋa a Chaapifuoŋ nɛ kuru ghɔ. Nthɛ yie ghɔ, muuŋ ŋa ɔ shi mbhi nɛ, shi mbɔ yi taoŋtaoŋ. Pi mɛ̄iŋ vi ŋa Muuŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Līi njəɨ, ndǐŋ ghɔ Ɛlishabe pɔ ni shūu muuŋ mimbia ŋkaa yu nɔ ntɨgao nàoŋ moŋ ndilunu, mbɔ ju ŋa pi ni mɛ̄iŋ vi ni ŋkhwɛ̄ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nthɛ ŋa yichəɨ nnu shiʼa ŋgaʼa Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri chhu ŋa, “M̀bɔ nɛiŋ, mbɔ muuŋ fàʼa Taathɔ, a pɔ vəɨ ŋkwaŋ haʼaŋ ɔ chhu nɛ.” Nɛnnɛ ŋgaŋ ntaoŋ ghɔ ghə̄ɨ ni vhi. ");
INSERT INTO bmo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A gha ndaʼa shɨgɛi llɛ́, Meri lɔllɔ ŋkɔnɔ ŋgə̄ɨ moŋ yichəɨ laʼataoŋ moŋ Juda, laʼataoŋ ntou mbra. ");
INSERT INTO bmo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A ghə̄ɨ nii nda Shakaria nchrā ni Ɛlishabe. ");
INSERT INTO bmo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ɛlishabe ni ŋga njaʼo chrà Meri, muuŋ ŋāna ni njɨ moŋ puŋ yu. Ɛlishabe ni ndɨnaoŋ ni Jijwɛ Minnwi, ");
INSERT INTO bmo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nɛnnɛ nchhu ni njɨ ŋa, “Ɔ mbrɔthɔ shɨna ŋguoŋ piŋgɛ ghao, ndɔ mbrɔthɔ pɔ muuŋ ŋa ɔ shi mbhi nɛ! ");
INSERT INTO bmo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mi pɔ pi gɔ̌, ŋa yei ŋkwaŋ nnu chwīe a, ŋa mǔuŋ Taathɔ a thɔ ŋkra a? ");
INSERT INTO bmo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nthɛ ŋa ndɨɨ ŋa mi nì njaʼo ɔ chrā vəɨ nɛ, muuŋ ŋa a pɔ puŋ mu nɛ ŋāna ni njɨ nthɛ pwatua. ");
INSERT INTO bmo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mbɔrɔ pɔ vɛ nthɛ ŋa ɔ piŋ nnu ŋa Taathɔ chhu vɛ nɛ!” ");
INSERT INTO bmo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meri khwɛ̄ ŋa, “Ǹchhu ni ŋguoŋ njùʼɔ a ŋa ndighaʼo pɔ ni Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mbɨnɨ mfāʼo pwanjuʼɔ nthɛ Minnwi mbɔ ŋkwe a, ");
INSERT INTO bmo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","nthɛ ŋa a kwiŋ muuŋ fàʼa yi, yi juju. Līi njəɨ, llɔ ndwɛ ŋgə̄ɨ nu shhɨ ŋguoŋ ŋgwrɛiŋgwa shi mɛ̄iŋ a ni mbrɔthɔ. ");
INSERT INTO bmo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nthɛ ŋa ju ŋa a tɨnɨ ŋgaʼa nɛ, chwīe pa mɛmmɛ nnu vəɨ, ligi yi pɔ Ŋoŋ Ki Fhi Yi. ");
INSERT INTO bmo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Llɔ ŋkuoŋ ŋgwrɛiŋoŋ nshwiʼi ŋkuoŋ ŋgwrɛiŋoŋ, a nōoŋ kwoshɨnɨ ni ŋgwa pɛ ŋa pugu pɔgɔ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A chwīe pa nnu tɨtɨnɨ ni mbhɔ mi, nshāaŋ pa ghaŋ ntitaʼo moŋ pa kwāʼa nu muŋu. ");
INSERT INTO bmo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A shwiʼi pa mɛmmɛ fùoŋ llɔ ŋkuoŋ faaŋ yugu, ŋkə̄rə pa ŋgwa pɛ ŋa yugu lɔ mbɔ nɛ tɔthɨ. ");
INSERT INTO bmo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A nɨʼɨŋ pa ghaŋ njì ni pa maoŋ shiʼi, njōu pa ghaŋ fāʼo pugu ghə̄ɨ ni mbhɔ yó. ");
INSERT INTO bmo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A ghɛ̄rɛ muuŋ fàʼa vi mbɔ Ishrae, nthɔ ŋkwiŋ pi kwoshɨnɨ yi, ");
INSERT INTO bmo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ŋkwaŋ haʼaŋ a ni ŋkāʼa ni pa tǎa pia, ni Abrahaŋ pugu pa mbhɛ̌ ŋoŋ yi nɔ ŋguoŋ ndɨɨ ghao nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri chhɔ pugu Ɛlishabe nɔ trɛi nàoŋ, maa mbɨnɨ kiʼɛ laʼa yu. ");
INSERT INTO bmo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ndɨɨ phi Ɛlishabe ni ŋga ŋkāʼo, a phi muuŋ mimbia. ");
INSERT INTO bmo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pa taakuo pi pugu pa ndaaŋoŋ yi ni ŋa njaʼo fɨʼɨ ntou kwoshɨnɨ ŋa Taathɔ nōoŋ ni Ɛlishabe nɛ, pugu pugu fāʼo pwanjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Fúoŋ llɛmbhi ni ŋga ŋkāʼo, pi thɔ lɨʼɨ niʼiŋ vi ŋgunu mbrɛi, ntāʼa nu nchhɔ̄ ligi yi ni Shakaria, mbɔ ligi tǎa vi. ");
INSERT INTO bmo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mǔuŋ vi lāa, nchhu ŋa, “Pi fāʼo nɔ mɛ̄iŋ nu vi pi ŋa Jouŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ndɔ pugu chhu ghɔ ŋa, “Yichəɨ ndaaŋoŋ yɔ lɔ mbɔ fɔ ŋa pi mɛ̄iŋ vi ni ligi yi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nɛnnɛ, pugu nōoŋ ni mbhɔ nɔ pie nu tǎa vi ni ligi ŋa a khwā ŋa muuŋ ghɔ fāʼo nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Shakaria chhu pi thɔ ni yaoŋ nāʼaŋ yaoŋ, a nāʼaŋ ŋkuoŋ ghɔ ŋa, “Ligi yi Jouŋ.” Nnu ghɔ ghrāo vugu. ");
INSERT INTO bmo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wuʼɔ ndɨɨ ghɔ, nchò Shakaria chuʼɔ, lɨŋ yi kɨ̄gɛi, a chrā, njɛ̄ ghaʼo nu Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pɔgɔ gu wɛ̄iŋ pa taakuo pugu. Shaaŋga nnu pei nyīeŋ moŋ ŋguoŋ laʼataoŋ moŋ ŋguoŋ Judia, mbɔ laʼataoŋ mbra. ");
INSERT INTO bmo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Shesheŋoŋ ŋa a ni njaʼo nnu yei nɛ ywɛrɛ moŋ njùʼɔ yu, nchhu nu ŋa, “Muuŋ vei ma mbɔ pi ŋkwaŋ khɔ? Nthɛ ŋa mbhɔ Taathɔ ni nja mbɔ mbɨŋ yu.” ");
INSERT INTO bmo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Shakaria tǎa Jouŋ ni ndɨnaoŋ ni Jijwɛ Minnwi, nɛnnɛ nchhu nnu ŋa Minnwi nōoŋ ghɔ nɛ: ");
INSERT INTO bmo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ghaʼo Taathɔ mbɔ Minnwi Ishrae, nthɛ ŋa a kra ŋgwa pi nɔ njaʼandiʼi yugu, ");
INSERT INTO bmo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mfɛ tɨtɨnɨ Ŋkwe ni pia llɔ moŋ nda Devi muuŋ fàʼa vi. ");
INSERT INTO bmo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wuʼɔ ndɔ haʼaŋ a ni mfɛ kàʼa yi ni pa njəɨlɨʼɨ pi pi taoŋtaoŋ llɔ llɛshhɨ ŋa pugu chīi ni ŋgwa, ");
INSERT INTO bmo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ŋa pia shi ndūgu mbhɔ pa mimbɨna pia pugu pa ŋguoŋ pa ŋgwa haʼaŋ pugu pɨ̄na via nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A ni ŋkāʼa ŋa a shi nōoŋ kwoshɨnɨ ni pa tǎa pia ndɔ mbɨnɨ ŋkwiŋ kɨ̀na yi yi taoŋtaoŋ, ");
INSERT INTO bmo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","kɨ̀na ŋa a ni nshwrɛ̄i ni tǎa via Abrahaŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A ni ŋkāʼa ŋa a shi ŋkwe via mbhɔ pa mimbɨna pia, nɛnnɛ ŋa mimfɛ pia fāʼa fàʼa yi ki lɔ mfāʼo pɔgɔ gu, ");
INSERT INTO bmo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","moŋ taoŋtaoŋ pugu pa ndɨndɨ shhɨ yu moŋ ŋguoŋ chɔmbhi yia ghao. ");
INSERT INTO bmo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ndɔ gɔ̀, muuŋ a, ɔ shi mbɔ njəɨlɨʼɨ Minnwi ŋa a Chaapifuoŋ nɛ, nthɛ ŋa ɔ shi ŋgə̄ɨ shhɨ Taathɔ mbīri ndaoŋ yi. ");
INSERT INTO bmo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ɔ shi nshwei ŋgwa pi, mbɔ ŋgwa Juu ŋkwaŋ haʼaŋ mimfɛ pugu kie ndūgu nɛ, ŋa Minnwi shi ndīʼɛ phɨ yugu. ");
INSERT INTO bmo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nthɛ pi juju kwoshɨnɨ Minnwi ni pia, ndɨɨ ŋa líʼɛ llɔ tɔthɨ shi nthɛ mbɨŋ pia, ");
INSERT INTO bmo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nɔ fɛ nu líʼɛ ni ŋgwa pɛ ŋa pugu chhɔ moŋ njiŋnjiŋ pugu pa miliʼi gu nɛ, ŋkɛ̄ʼi via ŋgə̄ɨ nɔ shɛndaoŋ ghɨghrɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jouŋ muuŋ ghɔ ni ŋkuʼɔ ntɨnɨ moŋ jijwɛ, ndaʼa pi moŋ pa ŋkǔnu njó ti nchəɨŋ ndɨɨ ŋa a ni njɛ̄ chīi nu chrà Minnwi ni ŋgwa Ishrae nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A ni ŋga mbɔ moŋ pɨɨ ndɨɨ ghɔ, Kaisha Agɔshtu pɔ fùoŋ moŋ ŋguoŋ mbhi Roma, mfɛ gɨ́ ŋa pi nāʼaŋ ligi ŋguoŋ ŋgwa Roma ghao nɔ nnu shia ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yei ni mbɔ fǔoŋ nāʼaŋ nu ligi nɔ nnu shia ŋgwa ndɨɨ ŋa Kwirinu ni nthɔ shaʼa Shiria nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Shesheŋoŋ ni mbɨnɨ moŋ ji laʼataoŋ nɔ nāʼaŋ nu ligi yi nɔ nnu shia ŋgwa ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nthɛ ŋa Joshɛ ni mbɔ pi ŋgwrɛiŋoŋ fùoŋ Devi nɛ, a kuʼɔ llɔ Nasharɛ moŋ Galili, ŋgə̄ɨ Bɛtɛlɛhɛiŋ moŋ Judia mbɔ laʼataoŋ Devi. ");
INSERT INTO bmo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A ghə̄ɨ fɔ lɨʼɨ nāʼaŋ ligi yugu Meri ŋa pi ni nōoŋ vi ghɔ nɔ ŋgwɛ vi, a ni mbɔ ni shūu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nɔ haʼaŋ pugu ni mbɔ fɔ nɛ, muuŋ kāoŋ vi. ");
INSERT INTO bmo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A phi fǔoŋ muuŋ vi, mbɔ muuŋ mimbia, mbara vi moŋ ndhwí, niʼiŋ moŋ ŋkuʼɔ jɨ khí pa minjɨɨ, nthɛ ŋa lɨʼɨ shi ki lɔ mbɔ ni pugu moŋ nda ghɔ ŋa pa ghɨ̀nɨ ghà nthɔ ndaʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Moŋ ŋkǔnu moŋ laʼataoŋ ghɔ pa ŋkɛ̄ʼi minjɨɨ ni mbɔ fɔ nthɔ ŋkɛ̄ʼi pa minjɨɨ pugu ni tuʼu. ");
INSERT INTO bmo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ŋgaŋ ntaoŋ Taathɔ nōoŋ noŋ yi shɨna pugu, ndighaʼo Taathɔ thɛ ŋgɨ̄ŋ vugu, pɔgɔ gu wɛ̄iŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ŋgaŋ ntaoŋ ghɔ chhu ni pugu ŋa, “Kiʼi pəɨ fāʼo pɔgɔ gu, ǹthɔ ni ŋkɨ̀nɨ pwa pishaʼakhɔ pwatua, mbɔ yi ŋguoŋ ŋgwa ghao. ");
INSERT INTO bmo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Shiʼa moŋ laʼataoŋ Devi pi phi ŋkwe vəɨ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe, ŋa a Taathɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yei shi mbɔ lì ni pəɨ: Pəɨ shi njəɨ muuŋ pi para vi moŋ ndhwí, a nūaŋ moŋ ŋkuʼɔ jɨ khí pa minjɨɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wuʼɔ ndɨɨ ghɔ, yú pichəɨ shoogɛ llɔ po wīʼi nchəɨŋ, pugu pa yie ghɔ jɛ̄ nthɔ ŋgaʼo Minnwi, nchhu nu ŋa: ");
INSERT INTO bmo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ndighaʼo pɔ ni Minnwi ti ŋgə̄ɨ nchəɨŋ fie moŋ ndugwi po, ghrɨnjuʼɔ pɔ ni ŋgwa pɛ ŋkuoŋ shhɛ ŋa pwapuŋ Minnwi pɔ mbɨŋ pugu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ndɨɨ ŋa pa ghaŋ ntaoŋ pighɔ mieŋ vugu mbɨnɨ po nɛ, pa ghaŋ kɛ̄ʼi minjɨɨ pighɔ chhu ni noŋ pugu ŋa, “Pia ghə̄ɨ Bɛtɛlɛhɛiŋ njəɨ nnu yei ŋa a lɔ̄gɔ lɨʼɨ Taathɔ chwīe pia ji nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nnɛ pugu kɔnɔ ŋgə̄ɨ njəɨ Meri ni Joshɛ, ni muuŋ ghɔ a nūaŋ moŋ ŋkuʼɔ jɨ khí pa minjɨɨ. ");
INSERT INTO bmo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pugu ni ŋga njəɨ muuŋ vei nchīi nnu ŋa ghaŋ ntaoŋ pighɔ ni nchhu nthɛ muuŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Shesheŋoŋ ŋa a ni njaʼo nnu ghɔ nɛ ghrāo nnu ŋa ghaŋ kɛ̄ʼi minjɨɨ pighɔ ni ǹchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meri lə̄ɨŋ ŋguoŋ nnu pei njùʼɔ yu nthɔ njwɛrɛ nu. ");
INSERT INTO bmo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pa ghaŋ kɛ̄ʼi minjɨɨ pɨ̄nɨ ni vugu, nthɔ ŋgaʼo Minnwi ndɔ mbɨnɨ ntōo vi nthɛ ŋguoŋ nnu pɛ ŋa pugu yaʼo ndɔ njəɨ wuʼɔ nɔ haʼaŋ pi shwei vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Fúoŋ llɛmbhi ni ŋga ŋkāʼo, pi niʼiŋ muuŋ ghɔ ŋgunu mbrɛi nchhɔ̄ ligi yi ni Jishɔ, mbɔ ligi ŋa ŋgaŋ ntaoŋ Minnwi ni mfɛ ŋkaoŋ pi maa nshūu vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ndɨɨ ŋa fɨʼɨ llɛmbhi ŋa a ni mbie ŋa Joshɛ pugu Meri chwīe mbɔ yi taoŋtaoŋ ŋkwaŋ haʼaŋ ŋwaʼaŋlɨ gɨ́ Mushi chhu nɛ ni ŋkāʼo nɛ, pugu kuʼɔ ni Jishɔ Jerushalɛiŋ lɨʼɨ fɛ vi ni Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yei ni mbɔ wuʼɔ nɔ haʼaŋ pi nāʼaŋ moŋ gɨ́ Taathɔ nɛ, “Sheshe fǔoŋ phi ŋa a mimbia nɛ, pi nūʼɔŋ vi lɨʼɨ təʼɨ vi ni Taathɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ndɔ mbɨnɨ nuʼuŋ fɛʼiŋgiɛŋ ŋkwaŋ nɔ haʼaŋ gɨ́ Taathɔ chhu nɛ, “mbɔ paa minthɔ ki paa puoŋ mintuʼɔlibuŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Moŋ ndɨɨ ghɔ, ŋoŋ chəɨ ni mbɔ Jerushalɛiŋ, ligi yi pɔ Shimioŋ. A ni mbɔ ŋkiɛŋ ŋoŋ ndɨndɨ ndɔ mbɔgɔ Minnwi. A ni nthɔ njwɛrɛ nu ŋa lūgu nu thɔ ni puoŋ laʼataoŋ Ishrae, Jijwɛ Minnwi ni mbɔ mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jijwɛ Minnwi ni ŋkwo nōoŋ ghɔ ŋa mbaʼa a yiʼi ŋkhu ki lɔ njəɨ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe, ŋa Taathɔ ni ŋkāʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jijwɛ Taathɔ kāoŋ vi ŋa a ghə̄ɨ Nda Minnwi ndɨɨ ŋa Meri pugu Joshɛ ni nthɔ ni muuŋ ghɔ fɔ nɔ chwīe nu nùʼɔŋ mbɨŋ yu ŋkwaŋ haʼaŋ gɨ́ ni nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Shimioŋ kwe muuŋ ghɔ ntuo mbhɔ yu, ntōo Minnwi, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ndwɛ, Taathɔ, ɔ mieŋ nu ŋa muuŋ fàʼa yɔ khu ndwɛ moŋ ghɨghrɨ ŋkwaŋ haʼaŋ chrà yɔ chhu nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","nthɛ ŋa ligi a yəɨ ŋoŋ ŋa ɔ taoŋ vi ŋa a thɔ ŋkwe ŋgwa nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ŋa ɔ pīri vi ŋa ŋguoŋ ŋgwa yəɨ nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","mbɔ líʼɛ nɔ nōoŋ nu nnu ŋa ɔ tāʼa nu nɛ ni pa taoŋ nduoŋ, mbɨnɨ nthɔ ni ndighaʼo ni ŋgwa pɔ, mbɔ puoŋ Ishrae.” ");
INSERT INTO bmo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tǎa Jishɔ ghɔ pugu mǔuŋ vi ghrāo pa nnu ŋa Shimioŋ chhu nthɛ Jishɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Shimioŋ fɛ mbɔrɔ ni pugu, nchhu ni Meri mǔuŋ vi ŋa, “Līi njəɨ, Minnwi chuʼɔ muuŋ vei ŋa nthɛ vi, ntou ŋgwa shi mbhɛ gha ntou pi lūgu Ishrae, ndɔ mbɔ lì ŋa mbaʼa pi piŋ nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","nɛnnɛ nɔ nōoŋ nu pa nnu haʼaŋ ŋgwa pīʼi nu njùʼɔ pugu nɛ. Ndɔ ni gɔ̀, ɔ shi mfāʼo yuʼɔ njùʼɔ nɔ haʼaŋ pi she njùʼɔ yɔ pi ni kafa.” ");
INSERT INTO bmo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ndunu miŋgwɛ ŋkugu chəɨ ni mbɔ fɔ, ligi yi pɔ Ana, ni mbɔ njəɨlɨʼɨ Minnwi, mbɔ muuŋ Fanue, llɔ moŋ ŋgwrɛiŋoŋ Asha. A ni ndaŋ nchwīe khwachəɨ ŋgaʼo ndaoŋ vi khu, a kɨna ŋkugu ti ŋgə̄ɨ nchəɨŋ fúoŋ wuŋ ŋgaʼo ni yi khwɛ ndɨɨ ŋa a ni njəɨ Jishɔ nɛ. Nɔ ŋkugu, a shi ki lɔ nchaʼa nu Nda Minnwi lɨʼɨ ghaʼo Minnwi moŋ jī ŋkhǐ pugu pa luoŋ nu, ni tuʼu pugu pa naoŋchɨ. ");
INSERT INTO bmo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wuʼɔ chomilaoŋ ghɔ, a chənə mbara yəɨ Joshɛ pugu Meri, nthɔ ntōo Minnwi, ndɔ nthɔ nchhu pa nnu nthɛ muuŋ ghɔ ni pa ŋgwa pɛ ŋa pugu ni nchhɔ njwɛrɛ nu ŋa Minnwi taoŋ njaʼandiʼi ŋa a thɔ ŋkwe Jerushalɛiŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joshɛ pugu Meri ni ŋga mīʼɛŋ ŋguoŋ pa nnu ŋkwaŋ nɔ haʼaŋ gɨ́ Taathɔ chhu nɛ, mbɨnɨ laʼa pugu Nasharɛ moŋ Galili. ");
INSERT INTO bmo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Muuŋ ghɔ ni ŋkuʼɔ ntɨnɨ, ndɨnaoŋ ni shiethɔ, mbhɔ Minnwi pɔ nu mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sheshe ŋgaʼo pa tǎa Jishɔ ghà ŋgə̄ɨ Jerushalɛiŋ nɔ nnu jɨ Lli Njiʼa. ");
INSERT INTO bmo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jishɔ ni ŋga mbɔ paanchrɔ ŋgaʼo, pugu kuʼɔ nɔ haʼaŋ nùʼɔŋ yugu chhu nɛ lɨʼɨ jɨ Lli Njiʼa. ");
INSERT INTO bmo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jɨ ghɔ gha ndugwi ti pugu chhɔ mbɨnɨ nu, Jishɔ kɨna njiŋ Jerushalɛiŋ ki pugu lɔ nji. ");
INSERT INTO bmo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pugu ni mbīʼi ŋa a pɔ shɨna pa ŋgwa ŋa pugu pugu ni mbɨnɨ nu nɛ, nyīeŋ nɔ taʼa llɛmbhi njɛ̄ tāʼa nu vi shɨna ndaaŋoŋ yugu pugu pa shuoŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pugu ni ŋga mieŋ ki yəɨ vi, mbɨnɨ kiʼɛ Jerushalɛiŋ nchhɔ ntāʼa vi. ");
INSERT INTO bmo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ŋga ntāʼa vi nɔ trɛi llɛ́, ŋgə̄ɨ njəɨ vi Nda Minnwi, a chhɔ shɨna pa ghaŋ yɛʼi ŋgwa nthɔ njwɛrɛ nnu haʼaŋ pugu chhu nu nɛ, ndɔ mbie vugu ni pa píe. ");
INSERT INTO bmo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ŋguoŋ pa ŋgwa haʼaŋ pugu ni njaʼo vi nɛ ni ŋgrāo fɨʼɨ ŋkwaŋ haʼaŋ a ji nnu nɛ pugu pa khwɛ̀ ŋa a ni mfɛ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pa tǎa pi ni ŋga njəɨ vi, nja ŋgrāo. Mǔuŋ vi chhu ŋa, “Muuŋ vei, ɔ kie nɛiŋ mfāʼa mbɨŋ pigi nɛiŋ? Līi njəɨ, pigi tǎa ghɔ nì nthɔ ntāʼa ghɔ ni shǐgi.” ");
INSERT INTO bmo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A chhu ni pugu ŋa, “Pəɨ nì nthɔ ntāʼa a ŋa? Pəɨ shi ki lɔ nji ŋa m̀fāʼo nɔ pɔ nu nda Tǎa a?” ");
INSERT INTO bmo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ndɔ paʼa pugu lɔ nji njiŋ chrà ghɔ ŋa a ni nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nɛnnɛ pugu pa Jishɔ pɨ̄nɨ Nasharɛ a ya njaʼo nchò yugu. Mǔuŋ vi lə̄ɨŋ ŋguoŋ nnu pei ghao njùʼɔ yu. ");
INSERT INTO bmo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jishɔ ni ŋkuʼɔ nu ŋgū mmɛŋoŋ moŋ shiethɔ pugu pa fɨʼɨ noŋ yi. Minnwi pugu pa ŋgwamishua piŋ vi mbīgi ŋgə̄ɨ shhɨ. ");
INSERT INTO bmo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ndɨɨ ŋa Tiberu Kaisha ni ŋkwo pɔ fùoŋ Roma nɔ tiɛŋnchrɔ ŋgaʼo nɛ, Pontiu Pailɛ thɔ shaʼa krao Roma ŋa pi mɛ̄iŋ ni Judia nɛ, Hɛrɔ ni nthɔ shaʼa yichəɨ krao, mbɔ Galili. Ndǐŋ vi, mbɔ Fili, ni nthɔ shaʼa yichəɨ krao, pi mɛ̄iŋ ni Iturea pugu Trakoniti, Lishania ni nshaʼa ji pi Abilɛnɛ. ");
INSERT INTO bmo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ndɨɨ ghɔ, Anaŋ pugu Kaifa ni mbɔ pa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ Minnwi. Ndɨɨ ghɔ, chrà Minnwi ni nthɔ ni Jouŋ, muuŋ Shakaria moŋ ŋkǔnu njó. ");
INSERT INTO bmo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A ghə̄ɨ moŋ ŋguoŋ ŋkɨŋ Jodaŋ nchhɔ nchīi nu ŋa, “Pəɨ pāʼa ŋkǔnu yəɨ ni phɨ, m̀fɛ ŋkhǐ ni pəɨ, Minnwi līʼɛ phɨ yəɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A ni ŋga nchhɔ nchhu yei, nthɔ nchwīe pi nnu ŋa Ishaya nāʼaŋ moŋ ŋwaʼaŋlɨ njəɨlɨʼɨ Minnwi, mbɔ ŋwaʼaŋlɨ Ishaya ŋa, “Ŋoŋ chəɨ thɔ mfɛ gɛ̀ moŋ ŋkǔnu njó, nchhu nu ŋa, ‘Pīri shɛndaoŋ ni Taathɔ, Chwīe pa lɨʼɨ tɔgɔ pi pɔ pi tithi. ");
INSERT INTO bmo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pi shi māʼaŋ ŋguoŋ wə́ɨŋ ghao nshə̄rə ŋguoŋ puoŋ mi mbra pugu pa mɛmmɛ pi, njuʼu ŋguoŋ ndaoŋ təɨtəɨ, Ndwēe ŋguoŋ ndaoŋ chəɨŋchəɨŋ. ");
INSERT INTO bmo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ŋguoŋ ŋgwa shi njəɨ ŋa Minnwi ghà ŋkwe ŋgwa moŋ phɨ pugu.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yú ŋgwa taoŋ nthɔ ŋa a fɛ ŋkhǐ ni pugu. A chhu ni pugu ŋa, “Pa Mbhɛ mitwɛʼi! A shūu gɔ̌ tə́nə yəɨ ŋa pəɨ tei pɨgɨtua Minnwi ŋa a thɔ nu nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pəɨ chwīe pa nnu pɛ ŋa a kāʼo nɛ, nɔ nōoŋ nu ŋa pəɨ kwri, ki lɔ nuʼuŋ nyīeŋ nchhu nu ŋa, ‘Abrahaŋ tǎa vigi.’ Ǹchhu ni pəɨ ŋa mimfɛ Minnwi pɨʼɨ ŋgùʼɔ pei nchwīe puoŋ nɔ ghɔ mfɛ ni Abrahaŋ. ");
INSERT INTO bmo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pi kwo pīri njiɛŋ nɔ kəʼɨ nu thɨ nɔ ghɔ, llɔ ŋkuoŋ ŋǐeŋ yi, nthɛ yie ghɔ, sheshe thɨ ŋa a lɔ njiʼi njuŋ ntíɛŋ shiʼi nɛ, pi shi ŋkəʼɨ māʼaŋ moŋ móŋoŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yú ŋgwa pighɔ pie vi ŋa, “Ti pigi shi nchwīe pi nɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A khwɛ̄ ni pugu ŋa, “Ŋoŋ ŋa a fāʼo paa ndhwí fɨgəɨ nɛ fɛ taʼa yi ni ŋoŋ ŋa a lɔ njiʼi mfāʼo nɛ, ŋoŋ ŋa a fāʼo maoŋ jɨ nɛ, fɛ yi pichəɨ ŋgwa.” ");
INSERT INTO bmo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pa ghaŋ wɛ̄iŋ taashi thɔ ŋkaa pugu ŋa a fɛ ŋkhǐ ni pugu, nchhu ghɔ ŋa, “Masha, pigi shi nchwīe pi nɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A chhu ni pugu ŋa, “Kiʼi pəɨ nuʼuŋ ŋkwe mbɨŋ taashi a tɔgɔ fɨʼɨ ŋkwaŋ haʼaŋ a kāʼo ŋa pəɨ kwe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pichəɨ shoogɛ pie vi ŋa, “Ti pigi nɛ?” A khwɛ̄ ni pugu ŋa, “Kiʼi pəɨ kwe mbɨŋ ŋoŋ ni nchei. Kiʼi pəɨ nuʼuŋ ndɛʼi ŋgiɛŋ thɔ ŋgwa nɔ fāʼo nu mbɨŋ. Pəɨ yru ni fɨʼɨ yaoŋ ŋa pi ghà mbe vəɨ nɔ ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pa ŋgwa ni nchhɔ njwɛrɛ nu ndɔ mbīʼi thɔ yugu ŋa kəʼɨchəɨ a pɔ nɛnnɛ a pɔ Jouŋ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jouŋ khwɛ̄ ni pugu ŋa, “Ŋ̀guʼɔ mfɛ pi ŋkhǐ ni pəɨ, ndɔ yichəɨ ŋoŋ thɔ nu ŋa a chaa a, ǹdɔ njiʼi ŋkāʼo nɔ fēi nu ŋkɨ̌ɨ tra yi, a shi ŋkwe vəɨ ni ŋkhǐ moŋ Jijwɛ Minnwi, pugu pa móŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A tuo yaoŋ fɨgəɨ reshi mbhɔ yu, mfɨgəɨ mfuʼu ŋkiɛŋ reshi moŋ ŋkuʼu maoŋ nūʼɔŋ shaoŋ yu, ntūoŋ ŋkuʼu maoŋ ghɔ moŋ móŋoŋ ki phɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Moŋ ntou puoŋ shɛndaoŋ, Jouŋ ghə̄ɨ shhɨ nthɔ nchhu pwa pishaʼakhɔ ni pugu, ŋkaa nu ŋa pugu piŋ. ");
INSERT INTO bmo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jouŋ ni mbɨ̄ga Hɛrɔ, mbɔ fùoŋ Galili, ŋa a wugwɛi Herodia ŋgwɛ ndǐŋ vi pugu pa pichəɨ nnu pɨphɨ nduoŋ ŋa ju Hɛrɔ ni ŋkwo chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hɛrɔ pɨnɨ mbīgi phɨ yi nɔ fɨ̄nɨ nu Jouŋ. ");
INSERT INTO bmo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ŋkaoŋ Jouŋ maa ŋgə̄ɨ chə́ɨŋ, ndɨɨ ŋa ŋguoŋ ŋgwa ni ŋkwo kwe ŋkhǐ nɛ, Jishɔ kwe ŋkaa yu, ŋga nchhɔ nduoŋ Minnwi, po ŋaʼaŋ, ");
INSERT INTO bmo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jijwɛ Minnwi shwiʼi mbɨŋ yu mbɔ nɔ mintuʼɔlibuŋ, ŋggì taoŋ po, nchhu nu ŋa, “Ŋkiɛŋ muuŋ ŋa ŋ̀khwā, m̀fāʼo pwatua nthɛ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jishɔ ni ŋga njɛ̄ fàʼa yi, mbɔ trɛi wuŋ ŋgaʼo. Ŋgwa ni mbiʼi ŋa a muuŋ Joshɛ, ŋa a ni mbɔ muuŋ Heli, ");
INSERT INTO bmo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mbɔ muuŋ Matate, mbɔ muuŋ Levi, mbɔ muuŋ Mɛlɛki, mbɔ muuŋ Janai, mbɔ muuŋ Joshɛ, ");
INSERT INTO bmo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mbɔ muuŋ Matatia, mbɔ muuŋ Amo, mbɔ muuŋ Nahuŋ, mbɔ muuŋ Eshu, mbɔ muuŋ Nagai, ");
INSERT INTO bmo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mbɔ muuŋ Maa, mbɔ muuŋ Matatia, mbɔ muuŋ Shɛmɛiŋ, mbɔ muuŋ Joshɛke, mbɔ muuŋ Joda, ");
INSERT INTO bmo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mbɔ muuŋ Joanaŋ, mbɔ muuŋ Resha, mbɔ muuŋ Shɛrubabɛ, mbɔ muuŋ Shɛatie, mbɔ muuŋ Neri, ");
INSERT INTO bmo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mbɔ muuŋ Mɛlɛki, mbɔ muuŋ Adi, mbɔ muuŋ Koshaŋ, mbɔ muuŋ Elemadaŋ, mbɔ muuŋ Erɛ, ");
INSERT INTO bmo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mbɔ muuŋ Joshua, mbɔ muuŋ Eliɛja, mbɔ muuŋ Joriŋ, mbɔ muuŋ Matate, mbɔ muuŋ Levi, ");
INSERT INTO bmo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mbɔ muuŋ Shimioŋ, mbɔ muuŋ Juda, mbɔ muuŋ Joshɛ, mbɔ muuŋ Jonaŋ, mbɔ muuŋ Eliakiŋ, ");
INSERT INTO bmo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mbɔ muuŋ Melea, mbɔ muuŋ Mɛna, mbɔ muuŋ Matata, mbɔ muuŋ Nataŋ, mbɔ muuŋ Devi, ");
INSERT INTO bmo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mbɔ muuŋ Jeshe, mbɔ muuŋ Obɛ, mbɔ muuŋ Boa, mbɔ muuŋ Shamoŋ, mbɔ muuŋ Nashoŋ, ");
INSERT INTO bmo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mbɔ muuŋ Aminada, mbɔ muuŋ Adamiŋ, mbɔ muuŋ Ani, mbɔ muuŋ Hɛshroŋ, mbɔ muuŋ Pɛrɛ, mbɔ muuŋ Juda, ");
INSERT INTO bmo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mbɔ muuŋ Jakɔ, mbɔ muuŋ Aiji, mbɔ muuŋ Abrahaŋ, mbɔ muuŋ Tera, mbɔ muuŋ Nahɔ, ");
INSERT INTO bmo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mbɔ muuŋ Shɛru, mbɔ muuŋ Ruu, mbɔ muuŋ Pɛlɛ, mbɔ muuŋ Eba, mbɔ muuŋ Shela, ");
INSERT INTO bmo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mbɔ muuŋ Kainaŋ, mbɔ muuŋ Arafaka, mbɔ muuŋ Shɛiŋ, mbɔ muuŋ Noa, mbɔ muuŋ Lame, ");
INSERT INTO bmo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mbɔ muuŋ Metushela, mbɔ muuŋ Enoke, mbɔ muuŋ Jarɛ, mbɔ muuŋ Mahalale, mbɔ muuŋ Kainaŋ, ");
INSERT INTO bmo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mbɔ muuŋ Ɛnoshe, mbɔ muuŋ Shhɛnte, mbɔ muuŋ Adaŋ, mbɔ muuŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jishɔ ni ndhɔ Jodaŋ ndɨnaoŋ ni Jijwɛ Minnwi. Jijwɛ ghɔ lɔ̄gɔ vi ŋgə̄ɨ nɔ moŋ ŋkǔnu njó. ");
INSERT INTO bmo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Shata mōoŋ vi fɔ nɔ khwɛ wuŋ llɛmbhi. Moŋ ŋguoŋ ndɨɨ ghɔ, a shini ndɔ njɨ sheshe yaoŋ, nɛnnɛ njì ni njia vi ndɨɨ ŋa yie ndɨɨ ni mmɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Devɨ chhu ghɔ ŋa, “Ɔ̈ mbɔ Muuŋ Minnwi, ɔ chhu ŋgùʼɔ yei kara ŋgū brɛi.” ");
INSERT INTO bmo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jishɔ khwɛ̄ ghɔ ŋa, “Pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, ‘Ŋoŋmishua shiʼa ŋguʼɔ njru pi ŋkuoŋ brɛi təʼɨ vi.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Devɨ lɔ̄gɔ vi ŋkuʼɔ nɔ tɔthɨ nōoŋ ŋguoŋ pa laʼataoŋ ŋkuoŋ mbhi ghɔ taʼa ŋgɛ́ ŋa ŋməɨŋ! ");
INSERT INTO bmo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Nchhu ghɔ ŋa, “Ǹshi mfɛ njɨ vɛ nɔ shaʼa nu ŋguoŋ taoŋ, fàʼo yugu pɔ jɔ ti ɔ̈ ŋgaʼo a, m̀fɛ vɛ, nthɛ ŋa pi kwo fɛ vəɨ, ti m̈i ŋkhwā m̀fɛ ni shesheŋoŋ ŋa ŋ̀khwā nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jishɔ khwɛ̄ ghɔ ŋa, “Pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, ‘Ghaʼo Taathɔ mbɔ Minnwi yɔ, ŋguʼɔ mfāʼa pi mbhɔ yu təʼɨ vi.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Shata lɔ̄gɔ vi kəʼɨ ghɔ ŋgə̄ɨ pugu yu Jerushalɛiŋ, ntigi vi ŋkuoŋ nchwɛrɛ Nda Minnwi, nchhu ghɔ ŋa, “Ɔ̈ mbɔ Muuŋ Minnwi, ɔ thi hɛiŋ ndhi nchəɨŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nthɛ ŋa pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, ‘Minnwi shi mfɛ gɨ́ ni pa ghaŋ ntaoŋ pi nthɛ ghɔ nɔ kɛ̄ʼi nu ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mbɨnɨ nāʼaŋ ŋa, ‘Pugu shi njā ghɔ tɔthɨ ni mbhɔ, nnɛ ŋa kiʼi ɔ chhwi kwò yɔ ŋkuoŋ ŋgùʼɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jishɔ khwɛ̄ ghɔ ŋa, “Ŋwaʼaŋlɨ Minnwi chhu ŋa, ‘Kiʼi ma njwɛʼi Taathɔ mbɔ Minnwi yɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ndɨɨ ŋa devɨ ni mīʼɛŋ mōoŋ nu Jishɔ moŋ ŋguoŋ puoŋ shɛndaoŋ nɛ, a mieŋ vi, nchēi shɨna nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jishɔ pɨ̄nɨ Galili moŋ ghrɨ́ Jijwɛ Minnwi. Pa chrà nɔ ligi yi nyīeŋ ŋkwe ŋguoŋ lɨʼɨ ghɔ ghao. ");
INSERT INTO bmo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A yɛʼi nu moŋ pa nda luoŋ Minnwi. Ŋguoŋ ŋgwa ghaʼo vi ghao. ");
INSERT INTO bmo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nɛnnɛ Jishɔ ghə̄ɨ Nasharɛ, mbɔ lɨʼɨ ŋa a ni ŋkuʼɔ nɛ. A gha mbɔ Llɛ́ Ji pa Juu, a ghə̄ɨ nda luoŋ Minnwi wuʼɔ nɔ haʼaŋ a ghà mbīgi nchwīe nɛ. Ndɔllɔ ntithi tɔthɨ lɨʼɨ mɛ̄iŋ Ŋwaʼaŋlɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pi ni mfɛ ŋwaʼaŋlɨ ŋa njəɨlɨʼɨ Minnwi, mbɔ Ishaya, ni nāʼaŋ nɛ. A ŋaʼaŋ ŋwaʼaŋlɨ ghɔ, njəɨ lɨʼɨ ŋa pi ni nāʼaŋ fɔ ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Jijwɛ Taathɔ pɔ mbɨŋ mu, nthɛ ŋa, a chuʼɔ a ŋa ǹchīi pwa pishaʼakhɔ ni ghaŋ pou. A taoŋ a ŋa ǹchīi lūgu nu ni ghaŋ chə́ɨŋ, ŋa pa nchriligi shi njəɨ lɨʼɨ, nchwīe ŋgwa pɛ ŋa pi fɛ vugu ni ŋgəʼɨ nɛ lūgu, ");
INSERT INTO bmo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ndɔ mbɨnɨ nchīi ŋa, ndɨɨ thɔ ŋa Taathɔ shi ŋkwe ŋgwa pi.” ");
INSERT INTO bmo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jishɔ gha mīʼɛŋ, ŋkra ŋwaʼaŋlɨ ghɔ, mfɛ ni muuŋ fàʼa moŋ nda ghɔ, nchɔchhɔ shhɛ, ligi ŋguoŋ ŋgwa nda luoŋ Minnwi chu mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A jɛ̄ nthɔ nchhu nu ni pugu ŋa, “Shiʼa, chrà Minnwi yei lɔ̄gɔ lɨʼɨ ligi pəɨ!” ");
INSERT INTO bmo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ŋgwa ni nchrā nnu shiʼi nthɛ vi. Pugu ghrāo pa ŋkwaŋ chrà shiʼi ŋa a ni ntaoŋ nu nchò yu nɛ, mbie nu ŋa, “Yei shi lɔ mbɔ muuŋ Joshɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A chhu ni pugu ŋa, “Ndɔ njiʼi mfāʼo khuthɔ ŋa pəɨ shi nchhu yei luʼɔ chrà vəɨ ŋa, ‘Ŋgaŋ njɨ̄gɨ ghɨ̌nɔ, ghɛ̄rɛ noŋ yɔ pia. Ŋguoŋ pa nnu ŋa pigi yaʼo ŋa ɔ chwīe Kapanuŋ nɛ, pɨnɨ nɛ nuʼuŋ nchwīe hɛiŋ shhɛ laʼa pəɨ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jishɔ pigi ŋa, “Shishini, pi shiʼa ma mbiŋ sheshe njəɨlɨʼɨ Minnwi laʼa pugu. ");
INSERT INTO bmo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Ndɔ, moŋ nnu shini, ǹchhu ni pəɨ ŋa ntou pa ŋkugu ni mbɔ Ishrae moŋ ndɨɨ Elaija, ndɨɨ ŋa Minnwi ni mfɨ̄nɨ po nɔ trɛi ŋgaʼo ni ntɨgao nàoŋ, ndɨɨ ŋa ŋkiɛŋ mmɛ njì ni ŋgū moŋ ŋguoŋ laʼa ghao. ");
INSERT INTO bmo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ndɔ paʼa Minnwi lɔ njiʼi ntaoŋ Elaija ni kaŋ taʼa ŋoŋ vugu, ŋkiɛŋ miŋgwɛ ŋkugu chəɨ Sharafa moŋ laʼataoŋ Shidoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ntou pa ghaŋ ghɨnɔmbaluŋ ni mbɔ Ishrae moŋ ndɨɨ njəɨlɨʼɨ Minnwi Elaisha, ndɔ paʼa Minnwi lɔ njɨ̄gɨ ghɨ̌nɔ kaŋ taʼa yi, ŋkiɛŋ Nemaŋ mbɔ ŋoŋ Shiria.” ");
INSERT INTO bmo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ŋguoŋ ŋgwa moŋ nda luoŋ Minnwi ni ŋga njaʼo yei, ndɨnaoŋ ni pɨgɨtua, ");
INSERT INTO bmo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","njrɛi shhɛ nshūu vi ntaoŋ nɔ moŋ laʼa, ŋkuʼɔ ni ju thɔ nchwɛrɛ mbra ghɔ ŋa pugu ni ŋkrao laʼa muŋu fɔ nɛ, ntāʼa nu māʼaŋ vi moŋ wə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ndɔ a shoo shɨna yú ŋgwa pighɔ ŋgə̄ɨ ni vi. ");
INSERT INTO bmo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jishɔ shwiʼi Kapanuŋ, mbɔ yichəɨ laʼataoŋ Galili, nthɔ njɛʼi vugu Llɛ́ Ji pa Juu. ");
INSERT INTO bmo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pugu ni ŋgrāo ŋkwaŋ haʼaŋ a ni njɛʼi nu nɛ, nthɛ ŋa a ni njɛʼi ni ghrɨ́. ");
INSERT INTO bmo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ŋoŋ chəɨ ni mbɔ moŋ nda luoŋ Minnwi ghɔ, mfāʼo jijwɛ miŋwɛiŋ, a ni mbaʼo ŋgòu ni njɨ ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yo! Pia fāʼo pi khɔ, Jishɔ llɔ Nasharɛ? Ɔ thɔ pi nɔ pɨrɨ nu vigi? Ǹji ŋoŋ ŋa ɔ yie nɛ, ɔ yi taoŋtaoŋ llɔ mbhɔ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jishɔ pɨ̄ga vi, nchhu nu ŋa, “Lɛrɛ laŋ ndɔ ntaoŋ mbɨŋ yu!” Miŋwɛiŋ ghɔ gha māʼaŋ vi shhɛ shɨna pugu, ntaoŋ mbɨŋ yu kiʼɛ, ndɔ paʼa ndɔ ndəɨŋ vi. ");
INSERT INTO bmo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ŋguoŋ ŋgwa pighɔ ghrāo nchhu ŋa, “Yei pɔ pi yəɨ ŋkwaŋ chrà nɛiŋ? A fɛ gɨ́ ni pa jijwɛ pɨphɨ ni ghrɨ́ pugu pa njɨ pugu taoŋ!” ");
INSERT INTO bmo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pi fɨ̄ʼɨ pa nnu nthɛ vi njīŋ ŋguoŋ ŋgei laʼataoŋ ghɔ ghao. ");
INSERT INTO bmo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jishɔ taoŋ moŋ nda luoŋ Minnwi ghɔ ŋgə̄ɨ laʼa Shemu. Ndɨɨ ghɔ, mǔuŋ ŋgwɛ Shemu thɔ ŋgɨ̄nɔ shɨ̀gao ndiɛŋ, pugu shwei Jishɔ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A ghə̄ɨ ntithi yəɨ yu mbɨ̄ga shɨ̀gao ghɔ, a taoŋ mbɨŋ yu. Wuʼɔ chomilaoŋ ghɔ a lɔllɔ, nchwīe maoŋ, mfɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A ni ŋga mbɔ ni fanaoŋ, ŋguoŋ ŋgwa ŋa pugu ni mfāʼo ŋgwa, pugu ghɨ̌nɔ ŋkwaŋ ŋkwaŋ ghɨ̌nɔ nɛ thɔ ni pugu, a nūʼɔŋ mbhɔ yi mbɨŋ pugu njɨ̄gɨ ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pa miŋwɛiŋ taoŋ mbɨŋ pichəɨ ŋgwa, mbaʼo ŋgòu ŋa, “Ɔ Muuŋ Minnwi!” A pɨ̄ga vugu paʼa ndɔ njiʼi mieŋ ŋa pugu chrā, nthɛ ŋa pugu ni nji ŋa a Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mbhi ni ŋga ndaŋ, Jishɔ taoŋ moŋ laʼa ŋgə̄ɨ moŋ ŋkǔnu njó, ŋgwa jɛ̄ nthɔ ntāʼa vi, ŋga njəɨ vi nthɔ ndɨʼɨ vi ŋa kiʼi a mieŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ndɔ a chhu ni pugu ŋa, “A pie ŋa ǹchīi pwa pishaʼakhɔ nthɛ Shaʼafuoŋ Minnwi ni pichəɨ pa laʼataoŋ ŋkaa pugu, nthɛ ŋa a nnu ŋa Minnwi taoŋ a ŋa ǹthɔ nchwīe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A ni nthɔ nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ ghɔ moŋ pa nda luoŋ Minnwi Judia. ");
INSERT INTO bmo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A ni mbɔ llɛ́ chəɨ, Jishɔ thi ŋkɨŋ ŋkhǐ chəɨ, pi mɛ̄iŋ ni Gɛnɛsharɛ, ŋgwa thɔ fra nu mbɨŋ yu nɔ yaʼo nu chrà Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A yəɨ paa kikuoŋ a kaoŋ ŋkɨŋ ŋkhǐ, ghaŋ ŋgunu pighɔ kwo taoŋ moŋ ghɔ ŋgə̄ɨ nthɔ shɨ̄gao ndáŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jishɔ nii moŋ taʼa kikuoŋ ghɔ, mbɔ yi Shemu, nchhu ghɔ ŋa a tūʼɔ a nii moŋ ŋkhǐ shɨgɛi. A chhɔ pi moŋ kikuoŋ ghɔ nthɔ njɛʼi ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jishɔ gha mīʼɛŋ chrā nu, nchhu ni Shemu ŋa, “Chhwi kikuoŋ a pɨnɨ nii lɨʼɨ shishhi. Pəɨ māʼaŋ ndáŋ yəɨ ŋkhǐ nɔ kwo nu shhu.” ");
INSERT INTO bmo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Shemu khwɛ̄ ŋa, “Masha, pigi kwo ya māʼaŋ ŋguoŋ tuʼu paʼa ndɔ ŋgwɛ̄iŋ yaoŋ, ndɔ nɔ haʼaŋ a chhu gɔ̀ nɛ, ǹshi māʼaŋ ndáŋ pighɔ ŋkhǐ.” ");
INSERT INTO bmo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pugu ni ŋga māʼaŋ ndáŋ yugu, ŋgwɛ̄iŋ ŋkiɛŋ ntou shhu ti pa ndáŋ yugu jɛ̄ shāa nu. ");
INSERT INTO bmo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pugu krao pichəɨ pakwo ŋgunu pugu ŋa pugu thɔ ŋgɛ̄rɛ vugu. Pugu thɔ mfuʼu shhu niʼiŋ moŋ paa kikuoŋ ghɔ, a lɨnaoŋ ti ntāʼa nu njīe. ");
INSERT INTO bmo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Shemu Pita ni ŋga njəɨ yei nnu, ŋgū ni kwɛ́rɛ yi shhɨ Jishɔ, nchhu nu ŋa, “Lɔllɔ shhɨ a, ma Taathɔ, m̀bɔ pi ŋgaŋ nchwīe phɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nduthɔ Shemu pugu pa ŋguoŋ ŋgwa ŋa pugu pugu ni mbɔ nɛ ghrāo nthɛ fɨʼɨ ntou shhu ŋa pugu ni ŋgwɛ̄iŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jɛiŋ pugu Jouŋ mbɔ puoŋ Shebedi ni ŋgrāo ŋkaa pugu, mbɔ pakwo ŋgunu Shemu. Jishɔ chhu ni Shemu ŋa, “Kiʼi nuʼuŋ mbɔgɔ, jɛ̄ ndwɛ ŋgə̄ɨ nu shhɨ, ɔ shi ŋgwɛ̄iŋ pi ŋgwamishua.” ");
INSERT INTO bmo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pugu ni ŋga ntaoŋ ŋkaoŋ pa kikuoŋ yugu mbhi, mieŋ ŋguoŋ yaoŋ ghao njōu njiŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jishɔ ni ŋga mbɔ moŋ laʼataoŋ chəɨ, ŋga njəɨ nu, ŋoŋ chəɨ ghɨnɔmbaluŋ kwo kru vi ti ŋgaʼa yəɨ vi, ŋgū ni puŋ yi shhɛ ndɨ̄gəɨ vi ŋa, “Taathɔ, ɔ̈ ŋkhwā, ɔ chwīe m̀bɔ yi taoŋtaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jishɔ fɛ mbhɔ yi ŋkāoŋ vi, nchhu nu ŋa, “Ǹtāʼa nu, pɔ yi taoŋtaoŋ!” Chomilaoŋ ghɔ, ghɨnɔmbaluŋ mmɛ mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jishɔ fɛ gɨ́ ghɔ ŋa, “Kiʼi nshwei ŋoŋ, ndɔ ghə̄ɨ nōoŋ noŋ yɔ ni ŋgaŋ fɛʼiŋgiɛŋ Minnwi a līi ghɔ nɔ nōoŋ nu ŋa Minnwi yɨ̄gɨ ghɨ̌nɔ yɔ, ndɔ mfɛ yaoŋ fɛʼiŋgiɛŋ nɔ haʼaŋ gɨ́ Mushi chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ndɔ pa pishaʼakhɔ nthɛ vi ka mīʼɛŋ nyieŋnyieŋ mbīgi moŋ ntou lɨʼɨ, ntou yú ŋgwa kɨrɨ nɔ yaʼo nu pa nnu llɔ mbhɔ yu, a lɔ mbɨnɨ njɨ̄gɨ pa ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ndɔ a thɔ mfuʼu noŋ yi, ŋgə̄ɨ nu lɨʼɨ ŋa ŋoŋ shi ki lɔ mbɔ nɛ, nthɔ nduoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Llɛ́ chəɨ ni ŋga mbɔ Jishɔ thɔ njɛʼi nu nɛ, pa ŋgwa Farashi pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ chhɔ yəɨ yu. Pugu ni ndhɔ moŋ ŋguoŋ pa laʼataoŋ Galili, ni Judia, ni Jerushalɛiŋ. Ghrɨ́ Taathɔ ni mbɔ mbɨŋ Jishɔ nɔ yɨ̄gɨ nu ghɨ̌nɔ. ");
INSERT INTO bmo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wuʼɔ ndɨɨ ghɔ, pichəɨ pa ŋgwa tiɛŋ ŋkwíni ŋkuoŋ kúoŋ nthɔ nu nɔ ghɔ, mbaʼo nɔ nii nu ni ju nda, nūʼɔŋ vi shhɨ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nthɛ ŋa ŋgwa ni njiɛŋ ni njɨ nɛ, paʼa pugu lɔ mfāʼo shɛndaoŋ nɔ nii nu ni ju. Nɛnnɛ pugu tiɛŋ vi ŋkuʼɔ nɔ thɔnda, ŋaʼaŋ mbo fɔ, nshwiʼi vi ŋkuoŋ kúoŋ ghɔ tri kɨrɨ shhɨ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ndɨɨ ŋa Jishɔ ni njəɨ fɨʼɨ piŋ ŋa pugu fāʼo nɛ, a chhu ni ŋkwíni ghɔ ŋa, “Taannu a, pi līʼɛ pa phɨ pɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pa ghaŋ yɛʼi gɨ́ Mushi pugu pa ŋgwa Farashi jɛ̄ nchhu nu ni noŋ pugu ŋa, “Yei pɔ pi gɔ̌ ŋa a nūʼɔŋ noŋ yi nɔ lɨʼɨ Minnwi? Mimfɛ a līʼɛ gɔ̌ ndīʼɛ phɨ ŋkiɛŋ Minnwi təʼɨ vi?” ");
INSERT INTO bmo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jishɔ ni nji nnu ŋa pugu ni mbīʼi nu nɛ mbie vugu ŋa, “Pəɨ kie nɛiŋ nthɔ mbīʼi ŋkwaŋ nnu pei nɛiŋ? ");
INSERT INTO bmo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A yīʼɛ yəɨ, chhu nu ŋa, ‘Ǹdīʼɛ phɨ yɔ’, ki chhu nu ŋa, ‘Lɔllɔ nyieŋ’? ");
INSERT INTO bmo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yei pɔ nɔ chwīe nu ŋa pəɨ ji ŋa Muuŋ Ŋoŋmishua fāʼo ghrɨ́ nɔ līʼɛ nu pa phɨ.” A chhu ni ŋkwíni ghɔ ŋa, “Ǹchhu vɛ ŋa lɔllɔ, lɔ̄gɔ kúoŋ yɔ ŋgə̄ɨ laʼa.” ");
INSERT INTO bmo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wuʼɔ ndɨɨ ghɔ, a lɔllɔ ligi pugu, ndɔ̄gɔ yaoŋ ŋa a ni nūaŋ ŋkuoŋ ghɔ nɛ, ŋgə̄ɨ laʼa nchhɔ ŋgaʼo Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ŋguoŋ yugu ni ŋgrāo, wiwini wɛ̄iŋ vugu, pugu ghaʼo Minnwi, nchhu nu ŋa, “Pigi yəɨ ŋkiɛŋ nnu ghraoghrao shiʼa!” ");
INSERT INTO bmo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ŋguoŋ nnu pei ni ŋga ntɔgɔ, Jishɔ taoŋ mbhi njəɨ ŋgwɛ̄iŋ taashi chəɨ, ligi yi pɔ Levi, a chhɔ moŋ ntǎa kwe taashi, Jishɔ chhu ghɔ ŋa, “Thɔ njōu njiŋ a.” ");
INSERT INTO bmo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A mieŋ ŋguoŋ yaoŋ ghao, ndɔllɔ njōu njiŋ yi. ");
INSERT INTO bmo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi pīri mmɛ jɨ nda yu nɔ ghaʼo nu Jishɔ. Ntou pa ŋgwɛ̄iŋ taashi pugu pa ŋgwa nduoŋ ni nthɔ jɨ ghɔ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pa ŋgwa Farashi pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi luo nu ni pa ghaŋ younjiŋ Jishɔ, nchhu nu ŋa, “A chwīe khɔ pəɨ jɨ yaoŋ ndɔ nnu nu pəɨ pa ghaŋ wɛ̄iŋ taashi pugu pa ghaŋ phɨ?” ");
INSERT INTO bmo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jishɔ khwɛ̄ ni pugu ŋa, “Ŋgwa ŋa pugu pɔ shishiʼi nɛ lɔ mfāʼo chà ŋgaŋ fhɔ̌, a fāʼo ŋgwa haʼaŋ pugu ghɨ̌nɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ǹdɔ njiʼi nthɔ pi nɔ gɛ̄ nu ŋgwa ndɨndɨ, ǹthɔ nthɛ pi ghaŋ phɨ, ŋa pugu pāʼa ŋkǔnu yugu ni phɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pa thishɨ Nda Minnwi pie vi ŋa, “Pa ghaŋ younjiŋ Jouŋ ghà njiɛŋ njī ŋkhǐ nduoŋ Minnwi, ghaŋ younjiŋ pa ŋgwa Farashi wuʼɔ nchwīe pi nɛnnɛ. Ti a chwīe khɔ pa jɔ jɨ maoŋ ndɔ nnu nu?” ");
INSERT INTO bmo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jishɔ khwɛ̄ ni pugu ŋa, “Mimfɛ ɔ lāa maoŋ jɨ ni ghaŋ gɛ̀ lɨʼɨ láŋ ndɨɨ ŋa mimbia ŋgaŋ láŋ ghɔ wuʼɔ mbɔ pugu pugu nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Llɛ́ shi nthɔ ŋa pi shi mfuʼu mimbia láŋ ghɔ moŋ shɨna pugu, nɛnnɛ, pugu shi njī ŋkhǐ moŋ llɛ́ pighɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jishɔ chhu luʼɔ chrà yei ni pugu, “Mbaʼa ŋoŋ shāa ndhwí fhi nchri paʼo ŋkuoŋ ndunu ndhwí nɔ ghɔ. Ä nchwīe nɛnnɛ, kaŋ a pɨrɨ ndhwí fhi ghɔ ndɔ mbaʼa pra ndhwí fhi ghɔ yiʼi nyīeŋ ŋkāʼo pugu yi ndunu. ");
INSERT INTO bmo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A wuʼɔ haʼaŋ a pɔ ni mikei ŋgrào nɛ. Mbaʼa ŋoŋ niʼiŋ laʼo fhi moŋ ndunu mikei ŋgrào. Ä nchwīe nɛnnɛ làʼo fhi ghɔ fāʼo ntūgu mikei ghɔ nthɛ ŋa minthɛ paʼa a lɔ nuʼuŋ shwīi mbīgi, kaŋ làʼo ghɔ shi ŋkwrī, mikei ŋgrào ghɔ pɨrɨ gha. ");
INSERT INTO bmo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A lɔ njiʼi ŋkāʼo nnɛ. Pəɨ wuʼɔ fāʼo nɔ niʼiŋ nu làʼo fhi moŋ mikei ŋgrào fhi. ");
INSERT INTO bmo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yichəɨ ŋoŋ lɔ mbɔ fɔ ŋa a ghà ŋga ŋkwo nnu ndunu làʼo mbɨnɨ ntāʼa làʼo fhi. Nthɛ ŋa a shi nchhu ŋa a pwa ndunu làʼo.” ");
INSERT INTO bmo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A ni mbɔ Llɛ́ Ji pa Juu chəɨ, Jishɔ nyīeŋ ntɔgɔ nu moŋ nyìeŋ shíe gɛ, pa ghaŋ younjiŋ pi ka shíe gɛ, nchiʼi ŋkrù nu. ");
INSERT INTO bmo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pichəɨ pa ŋgwa Farashi pie ŋa, “A kie pi nɛiŋ pəɨ thɔ nchwīe nnu ŋa gɨ́ lɔ njiʼi mbiŋ ŋa pi chwīe Llɛ́ Ji nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jishɔ khwɛ̄ ŋa, “Pəɨ lɔ naa mɛ̄iŋ nnu ŋa Devi ni nchwīe ndɨɨ ŋa njì ni njia vugu pa ŋgwa pi nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A ni nii Nda Minnwi, ndɔ̄gɔ brɛi ŋa pi ni mfɛ ni Minnwi ŋkru ndɔ mbɨnɨ fɛ ni ŋgwa pi, mbɔ nnu ŋa gɨ́ shini ndɔ mbiŋ ŋa minthɛ shesheŋoŋ kru, ŋkiɛŋ ŋgaŋ fɛʼiŋgiɛŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jishɔ lūgwi nchhu ŋa, “Muuŋ Ŋoŋmishua taathɔ Llɛ́ Ji pa Juu.” ");
INSERT INTO bmo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A ni mbɔ yichəɨ Llɛ́ Ji pa Juu, Jishɔ nii nda luoŋ Minnwi njɛʼi nu. Ŋoŋ chəɨ ni mbɔ fɔ ŋgei mbhɔ yi yi jɨ pɔ yi kwikwi. ");
INSERT INTO bmo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa ŋgwa Farashi ni nthɔ ntāʼa shɨna nɔ wɛ̄iŋ nu Jishɔ ŋa a chwīe nnu ŋa a lɔ njiʼi ŋkāʼo nɛ. Nthɛ yie ghɔ, pugu pɛʼi vi, njəɨ ŋa a shi njwiŋ mbhɔ ŋoŋ ghɔ Llɛ́ Ji. ");
INSERT INTO bmo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ndɔ a ni nji nnu ŋa pugu ni mbīʼi nu nɛ, nchhu ni ŋoŋ ghɔ ŋa mbhɔ yi ni kwikwi nɛ ŋa, “Lɔllɔ ntithi shhɨ ŋguoŋ ŋgwa.” A lɔllɔ ntithi. ");
INSERT INTO bmo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jishɔ pɨnɨ nchhu ni pugu ŋa, “Mfāʼo píe yei ni pəɨ. Gɨ́ piŋ ŋa pi chwīe pi yəɨ Llɛ́ Ji, nnu shiʼi ki nnu pɨphɨ? Kwe nu ŋoŋ ki jwi nu mi?” ");
INSERT INTO bmo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jishɔ kara noŋ yi mbɛʼi ŋguoŋ yugu ghao, nchhu ni ŋgaŋ ŋɨnɛiŋ mbhɔ ghɔ ŋa, “Shwīi mbhɔ yɔ.” A shwīi, mbhɔ yi kiʼi ndɔ mbɔ pi shiʼi. ");
INSERT INTO bmo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Túa ghaŋ yɛʼi gɨ́ Mushi pighɔ pugu pa ŋgwa Farashi pɨgɨ ŋkiɛŋ ntou yi, pugu jɛ̄ nthɔ ŋkri nnu ŋa mimfɛ pi chwīe mbɨŋ Jishɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Moŋ llɛ́ pighɔ, Jishɔ taoŋ ŋkuʼɔ ŋkuoŋ mbra lɨʼɨ luoŋ Minnwi. Ŋkɨna fɔ nduoŋ Minnwi ŋguoŋ tuʼu ghao. ");
INSERT INTO bmo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mbhi ni ŋga ndaŋ, a gɛ̄ ghaŋ younjiŋ pi, ntɛrɛ paanchrɔ shɨna pugu, mɛ̄iŋ vugu ni ghaŋ ntaoŋ pi; ");
INSERT INTO bmo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Shemu, ŋa a ni nchhɔ̄ ligi yi ni Pita, ni Andru ndǐŋ vi, ni Jɛiŋ, pugu Jouŋ, ni Fili, ni Batolomiu, ");
INSERT INTO bmo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni Matio, pugu Toma, ni Jɛiŋ mbɔ muuŋ Afioshi, ni Shemu ŋa pi ni mɛ̄iŋ vi ni kwìni laʼa nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ni Judashi, mbɔ muuŋ Jɛiŋ, ni Judashi Ishikario ŋa a ni mfīni vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jishɔ shwiʼi pugu pa ghaŋ ntaoŋ pi moŋ pɨprəɨ pugu pa ŋkiɛŋ mmɛ yú ghaŋ younjiŋ pi pugu pa ntou ŋgwa llɔ Judia ni Jerushalɛiŋ, ni ŋgwa llɔ ŋkɨŋ mmɛ ŋkhǐ Tairɛ pugu Shidoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pugu ni nthɔ lɨʼɨ yaʼo pa nnu mbhɔ yu, a lɔ mbɨnɨ njɨ̄gɨ ghɨ̌nɔ yugu. Ŋgwa ŋa jijwɛ miŋwɛiŋ ni ŋgana vugu nɛ ni nthɔ ŋkaa pugu a kwe vugu. ");
INSERT INTO bmo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ŋguoŋ ŋgwa pighɔ ni mbaʼo nu nɔ kāoŋ nu vi nthɛ ŋa njɨ ni ntaoŋ nu mbɨŋ yu nthɔ njɨ̄gɨ ghɨ̌nɔ yugu ghao. ");
INSERT INTO bmo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A kə̄rə ligi yi mbɛʼi ghaŋ younjiŋ pi nchhu ni pugu ŋa, “Mbɔrɔ yəɨ mbɔ ghaŋ pou, nthɛ ŋa shaʼafuoŋ Minnwi shi mbɔ yəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mbɔrɔ yəɨ ŋa njì yia vəɨ ndwɛ nɛ, nthɛ ŋa pəɨ lɛ njru. Mbɔrɔ pɔ ni pəɨ ŋa pəɨ kə̄ɨ nu nɛ, nthɛ ŋa pəɨ lɛ ŋgwɛ̄. ");
INSERT INTO bmo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mbɔrɔ yəɨ ndɨɨ ŋa ŋgwa pɨ̄na vəɨ, mfuʼu vəɨ shɨna pugu ndɔ ŋgwɛʼi vəɨ, ndɔ mɛ̄iŋ ligi yəɨ ŋa pəɨ ŋgwa pɨphɨ nthɛ Muuŋ Ŋoŋmishua. ");
INSERT INTO bmo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Pəɨ fāʼo pwanjuʼɔ moŋ ndɨɨ ghɔ ndɔ ndhi ni pwatua nnɛ nthɛ ŋa kɨ̀nɛiŋ yəɨ yiɛŋ po. A wuʼɔ ŋkwaŋ nɔ haʼaŋ pa tǎa pugu ni nchwīe ni pa njəɨlɨʼɨ Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ndɔ ŋgəʼɨ pɔ ni pəɨ ŋa pəɨ ghaŋ fàʼo nɛ, nthɛ ŋa pəɨ kwo fāʼo yəɨ nchhɔ́ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ŋgəʼɨ pɔ ni pəɨ ŋa pəɨ yru ndwɛ nɛ, nthɛ ŋa njì lɛ njia vəɨ, Ŋgəʼɨ pɔ ni pəɨ ŋa pəɨ gwɛ̄ nu ndwɛ nɛ, nthɛ ŋa pəɨ lɛ ŋkə̄ɨ ndɔ njūa. ");
INSERT INTO bmo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ŋgəʼɨ pɔ ni pəɨ ndɨɨ ŋa ŋguoŋ ŋgwa piŋ vəɨ piŋ nɛ, nthɛ ŋa a wuʼɔ ŋkwaŋ nɔ haʼaŋ pa tǎa pugu ni mbiŋ pa njəɨlɨʼɨ mifɨɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ndɔ ni gɔ̀ ŋa ɔ yaʼo nnu ŋa ǹchhu nu nɛ, khwā mbɨ̄na yɔ, nchwīe shiʼi mbɨŋ ŋgwa ŋa pugu pɨ̄na ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Luoŋ mbɔrɔ mbhɔ Minnwi mfɛ ni ŋgwa pɛ ŋa pugu chɔ̄nɔ ghɔ nɛ, nduoŋ Minnwi mfɛ ni ŋgwa haʼaŋ pugu fɛ ŋgəʼɨ vɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ŋ̈oŋ ŋgwie ghɔ nɔ ghə̀ʼɨ yɔ, ɔ nōoŋ ŋgei nduoŋ ghɔ a pɨnɨ ŋgwie, ŋ̈oŋ nshiri mmɛ ndhwí fɨgəɨ yɔ ŋkwe, ɔ mieŋ fɔ a kwe muuŋ ndhwí yɔ ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ŋ̈oŋ nduoŋ yaoŋ mbhɔ ghɔ, ɔ fɛ ghɔ, ti ŋ̈oŋ nshiri yaoŋ yɔ ŋkwe, ɔ mieŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chwīe mbɨŋ ŋgwa nduoŋ nnu haʼaŋ ɔ tāʼa nu ŋa pugu chwīe mbɨŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ä mbɔ ŋa ɔ wuʼɔ ŋkhwā pi ŋgwa ŋa pugu khwā ghɔ nɛ, ɔ fāʼo mbɔrɔ kiʼɛ nthɛ pi khɔ? Nthɛ ŋa njiʼi nthɛ pi pa ghaŋ phɨ ghà ŋkhwā pa ŋgwa pɛ ŋa pugu khwā vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ä mbɔ ŋa ɔ wuʼɔ nchwīe shiʼi pi mbɨŋ ŋgwa ŋa pugu chwīe shiʼi mbɨŋ ghɔ nɛ, ɔ fāʼo mbɔrɔ kiʼɛ nthɛ pi khɔ? Njiʼi nthɛ ghaŋ nchwīe phɨ ghà ŋguʼɔ nchwīe pi nɛnnɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ɔ̈ ŋguʼɔ fōo yaoŋ pi ni ŋgwa ŋa pugu shi mbɨnɨ nduʼu nɛ, ɔ fāʼo mbɔrɔ nthɛ pi khɔ? Njiʼi nthɛ ghaŋ chwīe phɨ ghà mfōo pichəɨ ghaŋ chwīe phɨ ni yaoŋ, nji nu ŋa pugu lɛ nduʼu. ");
INSERT INTO bmo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Ndɔ khwā ŋgwa ŋa pugu pɨ̄na ghɔ nɛ, nchwīe shiʼi mbɨŋ pugu, mfōo ŋoŋ ni yaoŋ ki lɔ njwɛrɛ nu ŋa a pɨnɨ nduʼu, nnɛ kaŋ kɨ̀nɛiŋ yɔ shi njiɛŋ, a lɔ nōoŋ ŋa ɔ muuŋ Minnwi ŋa a Chaapifuoŋ nɛ, nthɛ ŋa a ghà nōoŋ pwapuŋ ni ŋgwa ŋa pugu lɔ nji shiʼi nɛ pugu pa ghaŋ phɨ. ");
INSERT INTO bmo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Fāʼo kwoshɨnɨ wuʼɔ nɔ haʼaŋ Minnwi Tǎa ghɔ fāʼo kwoshɨnɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kiʼi nshaʼa ŋgwa nduoŋ nnɛ ŋa kiʼi pi shaʼa ghɔ. Kiʼi ntuo ŋoŋ nɔ ŋgushaʼa, kaŋ mbaʼa ŋoŋ tuo ghɔ nɔ ŋgushaʼa. Līʼɛ phɨ ŋgwa, kaŋ pi shi ndīʼɛ jɔ. ");
INSERT INTO bmo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fɛ yaoŋ ni ŋgwa nduoŋ, kaŋ pi shi mbɨnɨ mfɛ jɔ. Yaoŋ ŋa ɔ fɛ nɛ shi mbɨnɨ mbɨnɨ mbhɔ ghɔ pi niʼiŋ ti mfrɛ̄i, nchɨʼɨ ŋa a lɨnaoŋ ti ŋkwrī. Yaoŋ ŋa ɔ fɨ̄ʼɨ yaoŋ moŋ ghɔ mfɛ nɛ, ki a ghaʼo ki a kɨgəɨ, pi shi ŋguʼɔ mfɨ̄ʼɨ pi moŋ ghɔ nduʼu vɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jishɔ shwei luʼɔ chrà yei ni pugu: “Mbaʼa nchriligi nōoŋ shɛndaoŋ ni yichəɨ nchriligi, ä nōoŋ, kaŋ ŋguoŋ vugu shi ŋgū moŋ tiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mbaʼa ŋgaŋ younjiŋ ŋoŋ chaa masha vi, ndɔ ndɨɨ ŋa ŋoŋ mīʼɛŋ yɛʼi nu yaoŋ nɛ, a fhi Masha vi. ");
INSERT INTO bmo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“A chwīe khɔ ɔ yəɨ muuŋ ŋkuʼu thɨ ŋa a pɔ ligi ndǐŋ ghɔ, ndɔ ki lɔ mfāʼo ndɨɨ ni mmɛ mbɨɨ ŋkwɛiŋ ŋa a pɔ moŋ jɔ ligi nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ki minthɛ ɔ kie nɛiŋ nchhu ni ndǐŋ ghɔ ŋa, ‘Ǹaʼaŋ mfuʼu ŋkuʼu thɨ ŋa a pɔ ligi ghɔ nɛ’, ndɔ paʼa ndɔ njəɨ mmɛ mbɨɨ ŋkwɛiŋ ŋa a pɔ moŋ jɔ ligi nɛ. Ŋgaŋ mifɨɨ yei, fǔoŋ mfuʼu mmɛ Kuo thɨ ŋa a pɔ ligi ghɔ nɛ, nnɛ kaŋ ɔ shi njəɨ lɨʼɨ shishiʼi nɔ fuʼu nu ŋkuʼu thɨ ŋa a pɔ ligi ndǐŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nthɛ ŋa thɨ shiʼi shiʼa njuŋ ntíɛŋ thɨ pɨphɨ, ndɔ paʼa thɨ pɨphɨ lɔ njuŋ ntíɛŋ thɨ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pi ghà nji ŋkiɛŋ thɨ pi ŋkuoŋ ntíɛŋ yi. Pi shiʼa ndɨ̄ga ŋguuŋ laʼo shǐe, ndɔ paʼa ndɔ ŋka chìa ŋkuoŋ mbiembie. ");
INSERT INTO bmo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ŋoŋ shiʼi ghà nchrā nnu shiʼi llɔ shɨna pa nnu shiʼi ŋa a lɨnaoŋ njùʼɔ yu nɛ, ŋoŋ pɨphɨ chrā nnu pɨphɨ llɔ shɨna pa nnu pɨphɨ ŋa a lɨnaoŋ njùʼɔ yu nɛ, nthɛ ŋa njùʼɔ ghà ŋga ndɨnaoŋ, nchò chrā. ");
INSERT INTO bmo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“A chwīe khɔ ɔ thɔ mɛ̄iŋ a ŋa, ‘Taathɔ, Taathɔ,’ ndɔ paʼa ndɔ nchwīe nnu ŋa ǹchhu vɛ nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Shesheŋoŋ ŋa a thɔ njəɨ a njaʼo nchrā a nchwīe ndɔ haʼaŋ ǹchhu nɛ, ǹshi nshwei ghɔ ni ŋkwaŋ yaoŋ ŋa a fhi nɛ. A pɔ nɔ ŋoŋ ŋa a gha nthɔ ŋkrao nda, nja ntou kwò yi a shhi, a nūʼɔŋ ŋkuoŋ ŋgùʼɔ. Nɨnəɨ gha mbɨ̄gəɨ, ŋkhǐ thɔ mbɨŋ nda ghɔ ndɔ paʼa ndɔ nchɨʼɨ vi nthɛ ŋa pi ni nja ŋkrao vi shiʼi. ");
INSERT INTO bmo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ndɔ ti ŋoŋ ŋa a yaʼo chrà a ki lɔ nchwīe nɛ pɔ nɔ ŋoŋ ŋa a krao nda shhɛ ndɔ ki lɔ nūʼɔŋ kwò yi, nɨnəɨ gha mbɨ̄gəɨ, ŋkhǐ thɔ mbɨŋ nda ghɔ, a gū wuʼɔ ndɨɨ ghɔ nwīʼiŋ ghao.” ");
INSERT INTO bmo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jishɔ ni ŋga mīʼɛŋ chhu nu ŋguoŋ pa nnu pei ni ŋgwa pighɔ, ŋgə̄ɨ Kapanuŋ. ");
INSERT INTO bmo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nthishɨ taʼa ŋkɨɨ pa shoogɛ Roma ni mfāʼo muuŋ fàʼa vi ŋa a ni nja ŋkhwā vi. Muuŋ fàʼa vi ghɔ ni nja ŋgɨ̄nɔ nu ti mbiʼi shɨgɛi ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ndɨɨ ŋa a ni njaʼo pa nnu nɔ ligi Jishɔ nɛ, a taoŋ pa thishɨ ŋgwa Juu ghɔ ŋa a thɔ njɨ̄gɨ ghɨ̌nɔ muuŋ fàʼa vi. ");
INSERT INTO bmo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pugu ni ŋga nthɔ mfɨ̄ʼɨ ni Jishɔ, ndɨ̄gəɨ vi ŋkiɛŋ yie ghɔ, nchhu nu ŋa, “Ŋoŋ vei kāʼo ŋoŋ ŋa a pie ŋa ɔ ghɛ̄rɛ vi, ");
INSERT INTO bmo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nthɛ ŋa a khwā ŋgwa pia, ŋkrao ju nda luoŋ Minnwi yia.” ");
INSERT INTO bmo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nɛnnɛ Jishɔ ghə̄ɨ pugu pugu. A ni ŋga nthɔ ti mbara chonda, nthishɨ ghɔ taoŋ taannu pi ŋa pugu chhu ghɔ ŋa, “Taathɔ, kiʼi ŋgwie noŋ yɔ, ǹdɔ njiʼi ŋkāʼo nɔ ŋoŋ ŋa mimfɛ ɔ nii nda a nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Ndɔ paʼa ǹdɔ njiʼi ŋkāʼo nɔ thɔ nu njəɨ ghɔ nduthɔ a. Wuʼɔ fɛ pi gɨ́ noŋ muuŋ fàʼa a tɔgɔ. Nthɛ ŋa mmu nduthɔ a, ŋ̀ga mfāʼa mbhɔ ŋgwa, ndɔ nthɔ nshaʼa pa shoogɛ ŋkaa mu. Ŋ̀ga mfɛ gɨ́ ni yei ŋa, ‘Ghə̄ɨ!’ a ghə̄ɨ. Mfɛ gɨ́ ni vini ŋa, ‘Thɔ!’ a thɔ. Mfɛ gɨ́ ni muuŋ fàʼa a ŋa, ‘Chwīe yei!’ a chwīe.” ");
INSERT INTO bmo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jishɔ ni ŋga njaʼo nnu yei, ŋgrāo, nchhu ni yú ŋgwa pɛ ŋa pugu ni njōu njiŋ yi nɛ ŋa, “Njiʼi nthɛ pi Ishrae ǹdɔ naa njəɨ ŋoŋ a fāʼo fɨʼɨ piŋ yei.” ");
INSERT INTO bmo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ndɨɨ ŋa ŋgwa pɛ ŋa pi ni ntaoŋ vugu ni mbɨnɨ nda nthishɨ pa shoogɛ ghɔ nɛ, pugu yəɨ muuŋ fàʼa ghɔ, ghɨ̌nɔ yi kwo tɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A gha ndara, Jishɔ lɔllɔ ŋgə̄ɨ laʼataoŋ chəɨ pi mɛ̄iŋ ni Naiŋ. Pa ghaŋ younjiŋ pi pugu pa mmɛ yú ŋgwa pɔ njiŋ yu. ");
INSERT INTO bmo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","A ni ŋga mbara nu choŋkaʼa laʼataoŋ ghɔ, ŋga njəɨ nu pi tiɛŋ khu ŋoŋ ntaoŋ nu nɔ, mbɔ fiɛŋ muuŋ mimbia mbhɔ mǔuŋ vi, ndɔ mbɔ miŋgwɛ ŋkugu. Yú ŋgwa, llɔ laʼataoŋ ghɔ, pɔ pugu pa miŋgwɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Taathɔ ni ŋga njəɨ miŋgwɛ ghɔ, mfāʼo kwoshɨnɨ mbɨŋ yu nchhu ghɔ ŋa, “Kiʼi nuʼuŋ ŋkə̄ɨ,” ");
INSERT INTO bmo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ŋgə̄ɨ ŋkaoŋ ŋkuŋkhu ghɔ, ŋgwa pɛ ŋa pugu ni ntiɛŋ nɛ tithi. A chhu ŋa, “Maʼaŋ mikhwa, ǹchhu vɛ ŋa, lɔllɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ŋkukhu ghɔ lɔllɔ nchɔchhɔ njɛ̄ chrā nu, Jishɔ fɛ vi ni mǔuŋ vi. ");
INSERT INTO bmo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pɔgɔ gu wɛ̄iŋ ŋguoŋ yugu ghao, pugu ghaʼo Minnwi, nchhu nu ŋa, “Mmɛ njəɨlɨʼɨ Minnwi chəɨŋ shɨna pia.” Mbɨnɨ nchhu ŋa, “Minnwi thɔ nɔ kwe nu ŋgwa pi.” ");
INSERT INTO bmo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pishaʼakhɔ yei nɔ ligi Jishɔ nyīeŋ moŋ ŋguoŋ Judia ghao pugu pa laʼataoŋ ŋkɨŋ Judia. ");
INSERT INTO bmo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Pa ghaŋ younjiŋ Jouŋ ni ŋga shwei vi ni ŋguoŋ pa nnu ŋa Jishɔ ni nchwīe nɛ, a mɛ̄iŋ yi paa shɨna pugu ");
INSERT INTO bmo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ntaoŋ vugu ni Taathɔ ŋa pugu pie vi ŋa, “A gɔ̀ mbɔ ŋoŋ vɛ ŋa a ni mbɔ ŋa a shi nthɔ nɛ, ki pigi ywɛrɛ ŋoŋ nduoŋ?” ");
INSERT INTO bmo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Paa ŋgwa pighɔ gha ŋgə̄ɨ njəɨ Jishɔ, nchhu ghɔ ŋa, “Jouŋ Ŋgaŋ Fɛ Ŋkhǐ taoŋ vigi vɛ ŋa pigi pie ŋa ‘A gɔ̀ mbɔ ŋoŋ vɛ ŋa a ni mbɔ ŋa a shi nthɔ nɛ, ki pigi ywɛrɛ ŋoŋ nduoŋ?’ ” ");
INSERT INTO bmo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wuʼɔ ndɨɨ ghɔ, Jishɔ yɨ̄gɨ ghɨ̌nɔ ntou ŋgwa pugu pa ŋgwa pɛ ŋa jijwɛ pɨphɨ ni mbɔ mbɨŋ pugu nɛ, ŋaʼaŋ ligi pa nchriligi. ");
INSERT INTO bmo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A khwɛ̄ ni pa ghaŋ ntaoŋ Jouŋ ŋa, “Pəɨ pɨ̄nɨ shwei Jouŋ ni yaoŋ ŋa pəɨ yəɨ ndɔ njaʼo nɛ, pa nchriligi yəɨ lɨʼɨ, pa ŋkwíni nyīeŋ, ghaŋ ghɨnɔmbaluŋ pɔ shiʼi, pa fhɨtənə yaʼo lɨʼɨ, pi pɨʼɨ pa ŋgwa khu moŋ gu, pi chīi ŋkɨ̀nɨ pwa pishaʼakhɔ ni ghaŋ pou. ");
INSERT INTO bmo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mbɔrɔ pɔ ni ŋgwa pɛ ŋa pugu lɔ njiʼi mfāʼo kɨʼɨŋgɨnɨ moŋ piŋ yugu nthɛ a nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pa ghaŋ ntaoŋ Jouŋ ni ŋga ŋkwo ghə̄ɨ, Jishɔ jɛ̄ nthɔ nchrā nu ni yú ŋgwa pighɔ nthɛ Jouŋ, “Pəɨ ni ŋgə̄ɨ moŋ ŋkǔnu njó njəɨ pi khɔ fɔ? Trǔ ŋa fɨfrəɨ chɨ̄ʼɨ nu? Ŋga! ");
INSERT INTO bmo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ti pəɨ ni ŋgə̄ɨ kiʼɛ njəɨ pi khɔ fɔ? Ŋoŋ ŋa a ni māʼaŋ ŋkiɛŋ ndhwí chɨgəɨ nchuoŋ? Ŋga! Līi njəɨ, ŋgwa ŋa pugu ghà māʼaŋ ŋkwaŋ ndhwí pighɔ nɛ ndɔ mbɔ moŋ nchhɔ shiʼi nɛ ghà mbɔ pi moŋ ntuʼɔ pa fùoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Shwei a nɛ, ti pəɨ ni ŋgə̄ɨ nu kiʼɛ njəɨ pi khɔ fɔ? Njəɨlɨʼɨ Minnwi? Ooŋ, ǹshwei vəɨ, ŋoŋ ŋa a chaa njəɨlɨʼɨ Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nthɛ ŋa Jouŋ ŋoŋ ŋa chrà Minnwi chrā nɔ ligi yi ŋa, ‘Līi njəɨ, ǹshi ntaoŋ ŋgaŋ ntaoŋ a, a ghə̄ɨ shhɨ pəɨ mbīri ndaoŋ ni pəɨ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jishɔ pɨnɨ mbīgi ŋa, “Ǹshwei vəɨ ŋa Jouŋ ghaʼo nchaa ŋguoŋ ŋgwa ŋa piŋgɛ kwo ma mbhi nɛ, ndɔ ŋoŋ ŋa a kɨgəɨ nchaa ŋguoŋ ŋgwa moŋ Shaʼafuoŋ Minnwi nɛ ghaʼo nchaa Jouŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ŋguoŋ ŋgwa pugu pa ghaŋ wɛ̄iŋ taashi ni ŋga njaʼo yei nnu, mbiŋ ŋa nnu ŋa Minnwi chwīe nɛ yi ndɨndɨ, mbɔ ŋgwa ŋa Jouŋ ni mfɛ ŋkhǐ ni pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ndɔ pa ŋgwa Farashi pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ lāa nnu ŋa Minnwi ni ŋkāʼa nthɛ vugu nɛ, nnɛ ki lɔ ntɔgɔ moŋ kwe ŋkhǐ Jouŋ. ");
INSERT INTO bmo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jishɔ ghə̄ɨ shhɨ nchhu ŋa, “Mi nthɛ m̀āʼaŋ fɨʼɨ ŋgwa mbhi shiʼa pi ni khɔ? Pugu fhi pi khɔ? ");
INSERT INTO bmo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pugu pɔ nɔ pa mikəʼɨ ŋa pugu chhɔ taŋ, taʼa kwíe chhu nu ni vichəɨ ŋa, ‘Pigi māʼaŋ ŋkhǐ pwanjuʼɔ ni pəɨ, ndɔ paʼa pəɨ lɔ mbini, pigi yrāo ŋkhǐ gu ndɔ paʼa pəɨ lɔ ŋkə̄ɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jouŋ Ŋgaŋ Fɛ Ŋkhǐ ni nthɔ, ki lɔ ŋkru brɛi ndɔ paʼa ndɔ nnu làʼo pəɨ chhu ŋa ‘a fāʼo miŋwɛiŋ mbɨŋ yu.’ ");
INSERT INTO bmo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Muuŋ Ŋoŋmishua thɔ njɨ maoŋ ndɔ nnu nu, pəɨ ŋa, ‘a njru mmɛ yaoŋ ndɔ mbɔ mbaa làʼo, mbɨnɨ mbɔ taannu ghaŋ wɛ̄iŋ taashi pugu pa ghaŋ phɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ndɔ ŋguoŋ ŋgwa ŋa pugu piŋ shiethɔ Minnwi nɛ nōoŋ ŋa shiethɔ ghɔ yi shini.” ");
INSERT INTO bmo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yichəɨ taʼa Farashi ni mɛ̄iŋ Jishɔ ŋa a thɔ pugu yu jɨ maoŋ, a ghə̄ɨ nda Farashi ghɔ nchɔchhɔ lɨʼɨ jɨ maoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Miŋgwɛ chəɨ ni mbɔ moŋ laʼataoŋ ghɔ, mbɔ nchwīe phɨ, ŋga njaʼo ŋa Jishɔ pɔ nda ŋoŋ Farashi ghɔ lɨʼɨ jɨ maoŋ, a thɔ ni yichəɨ nchɨ́ŋ ŋa pi chwīe ni ŋgùʼɔ, laminda tɨnɨnchuoŋ lɨnaoŋ moŋ ghɔ, ");
INSERT INTO bmo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","nthi njiŋ Jishɔ, yəɨ kwò yu ŋkə̄ɨ nu, ŋkwrī ŋkhǐ ligi yi nɔ kwò yi, njɨ̄gɨ ni ŋgiithɔ yi, nthɔ nuaŋ kwò yi, mbɔrɔ kwò yi ni laminda ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ŋoŋ Farashi ghɔ ni ŋga njəɨ yei nnu nchhu ni noŋ yi ŋa, “Ŋ̈oŋ vei kaŋ nja mbɔ njəɨlɨʼɨ Minnwi, a kaŋ nji ŋkwaŋ ŋoŋ ŋa miŋgwɛ vei ŋa a chhɔ ŋkāoŋ vi yie ghɔ nɛ, ŋkwaŋ chɔmbhi pɨphɨ ŋa a ghà nchhɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nɔ khwɛ̄ nu Jishɔ chhu ŋa, “Shemu, m̀fāʼo nnu nɔ chhu nu vɛ.” Shemu pie ŋa, “Mbɔ khɔ, ŋgaŋ yɛʼi ŋgwa?” ");
INSERT INTO bmo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Yichəɨ ŋgaŋ fōo ŋgwa ni mbɨŋ ni mbɔ fɔ mfāʼo paa ghaŋ ŋkru pi. Ŋkrù yi pɔ puŋ taʼa yi mbɔ fɨʼɨ mbɨŋ ŋa ŋ̈oŋ mfāʼa nɔ tiɛŋ ŋkɨɨ llɛ́ pi pe vi nɔ nɛ, yichəɨ pɔ fɨʼɨ mbɨŋ ŋa ŋ̈oŋ mfāʼa nɔ tiɛŋ wuŋ llɛ́, pi pe vi nɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Paʼa kaŋ taʼa ŋoŋ vugu lɔ mfāʼo mbɨŋ ghɔ nɔ pe nu ni ŋoŋ ghɔ, nthɛ yie, a chiʼi ŋkrù yugu ghɔ. A yəɨ shɨna pugu ŋa a shi ŋkhwā vi nchaa vichəɨ?” ");
INSERT INTO bmo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Shemu khwɛ̄ ŋa, “M̀bīʼi ŋa a yɛ ŋa ji ŋkrù ni njiɛŋ nɛ.” Jishɔ chhu ghɔ ŋa, “Ɔ chhu a kāʼo.” ");
INSERT INTO bmo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nɛnnɛ Jishɔ kara ndīi miŋgwɛ ghɔ, nchhu ni Shemu ŋa, “Ɔ yəɨ miŋgwɛ vei? Mi nì nii nda ghɔ paʼa ɔ lɔ mfɛ ŋkhǐ shɨ̄gao kwò vəɨ, ndɔ miŋgwɛ vei shɨ̄gao kwò ma ni ŋkhǐ ligi yi, ndɔ njɨ̄gɨ ni ŋgiithɔ yi. ");
INSERT INTO bmo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɔ shini ndɔ nchhu ŋa ǹthɔ a pwa ni paŋ nu ma, ndɔ jɛ̄ nɔ haʼaŋ ǹthɔ hɛiŋ nɛ, a lɔ naa mieŋ nuaŋ nu kwò ma yaʼa. ");
INSERT INTO bmo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɔ shini ndɔ njiʼi mbɔrɔ thɔ a ni wru, ndɔ ti a pɔrɔ kwò ma ni laminda chɨgəɨ nchuoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nthɛ yie ghɔ, ǹchhu vɛ ŋa fɨʼɨ ntou khwǎ ŋa a nōoŋ nɛ, nōoŋ ŋa pi līʼɛ phɨ yi ŋa a yiɛŋ nɛ. Ndɔ ŋoŋ ŋa a wuʼɔ nchwīe pi shɨgɛi phɨ, pi līʼɛ nɛ, nōoŋ khwā pi shɨgɛi yi.” ");
INSERT INTO bmo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jishɔ chhu kiʼɛ ni miŋgwɛ ghɔ ŋa, “Ǹdīʼɛ phɨ yɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pichəɨ ŋgwa ŋa pugu pugu ni mbɔ ŋkuoŋ taprɛi nɛ, jɛ̄ nchhu nu ni noŋ pugu ŋa, “Yei pɔ pi gɔ̌ ŋa a pɔ ti ndīʼɛ pi phɨ ŋoŋ?” ");
INSERT INTO bmo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A chhu ni miŋgwɛ ghɔ ŋa, “Piŋ yɔ chwīe ɔ lūgu, ghə̄ɨ ni gɔ moŋ ghɨghrɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A ni ŋga ndaʼa, Jishɔ nyīeŋ moŋ pa mɛmmɛ laʼataoŋ pugu pa puoŋ mi laʼataoŋ, nthɔ nshwei pwa pishaʼakhɔ mbɔ yi Shaʼafuoŋ Minnwi. A ni mbɔ pugu pa paanchrɔ ghaŋ ntaoŋ pi, ");
INSERT INTO bmo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","pugu pa pichəɨ piŋgɛ, ŋa a ni mfuʼu jijwɛ pɨphɨ mbɨŋ pugu, mbɨnɨ njɨ̄gɨ pa ghɨ̌nɔ mbɨŋ pugu. Piŋgɛ pighɔ ni mbɔ Meri, ŋa pi ni mɛ̄iŋ vi ni Madaliŋ, ŋa khwachəɨ miŋwɛiŋ ni ntaoŋ mbɨŋ yu nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ni Joana, mbɔ ŋgwɛ Kusha, mbɔ muuŋ fàʼa Hɛrɔ, ni Shushana, pugu pa ntou pichəɨ piŋgɛ ŋa pugu ni nthɔ ŋgɛ̄rɛ Jishɔ pugu pa ghaŋ younjiŋ pi llɔ moŋ yugu ŋkaa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ndɨɨ ŋa ntou yú ŋgwa ni nthɔ ŋkɨrɨ nu, pichəɨ llɔ moŋ ntou pa lɨʼɨ nyīeŋ ŋgə̄ɨ nu yəɨ Jishɔ nɛ, a chhu yei luʼɔ chrà ni pugu: ");
INSERT INTO bmo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ŋoŋ chəɨ ni ma mbɔ fɔ, ŋgə̄ɨ lɨʼɨ māʼaŋ mbhɛ̌ maoŋ. Nɔ haʼaŋ a ni māʼaŋ nu nɛ, pichəɨ gū shɛmbua, ŋgwa tie ni kwò yugu, pa mishi llɔ tɔthɨ shwiʼi kru. ");
INSERT INTO bmo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pichəɨ gū moŋ shhɛ ŋkwá, ŋga ŋkhɛ̄, ŋkiʼi ndɔ njaoŋ yaoŋ nthɛ ŋa a lɔ njiʼi mfāʼo ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pichəɨ gū moŋ shishaʼa, shishaʼa yīʼɛ ŋkuʼɔ mfīgi maoŋ pighɔ pugu khu. ");
INSERT INTO bmo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pichəɨ mbhɛ̌ maoŋ pighɔ ni ŋgū moŋ shhɛ shiʼi mbūgu fɔ ndɔ nja njuŋ, nchaa mbhɛ̌ yi ni ŋkɨɨ ŋgɛ.” Jishɔ ghà ŋga nchhu nnu pei mīʼɛŋ, mfɛ gɛ̀ ŋa, “Ŋoŋ ŋa a fāʼo tə́nə nɛ, â yaʼo.” ");
INSERT INTO bmo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pa ghaŋ younjiŋ pi pie vi ŋa, “Njiŋ luʼɔ chrà ghɔ pɔ pi ŋa?” ");
INSERT INTO bmo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A khwɛ̄ ŋa, “Minnwi chwīe pəɨ ji pa nnu lə̄ɨŋ moŋ Shaʼafuoŋ yi. Ndɔ ni pichəɨ ŋgwa, a pɔ pi moŋ luʼɔ chrà nnɛ ŋa: ‘Pugu shi ndīi, ndɔ paʼa ndɔ njəɨ; Njwɛrɛ ndɔ paʼa, ndɔ njaʼo nji.’ ");
INSERT INTO bmo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Yei njiŋ luʼɔ chrà ghɔ: Mbhɛ̌ yaoŋ ghɔ chrà Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pɛ mbhɛ̌ ŋa a ni ŋgū shɛmbua thɔ nōoŋ pi ŋgwa pɛ ŋa pugu yaʼo chrà Minnwi, ndɔ devɨ thɔ fuʼu chrà ghɔ njùʼɔ pugu, nnɛ ŋa mbaʼa pugu piŋ ndɔ ndūgu. ");
INSERT INTO bmo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pa mbhɛ̌ pɛ ŋa pugu ni ŋgū moŋ shhɛ ŋkwá nɛ pɛ ŋgwa ŋa pugu yaʼo chrà ghɔ, mbiŋ ni pwatua ndɔ paʼa ŋǐeŋ yugu lɔ ntɨnɨ. Pugu piŋ nɔ kuo ndɨɨ, mōoŋ nu gha nthɔ pugu pāʼa ŋkǔnu yugu. ");
INSERT INTO bmo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pa mbhɛ̌ ŋa pugu ni ŋgū moŋ shishaʼa nɛ, ŋgwa ŋa pugu piŋ chrà Minnwi, mbiŋ, ŋga ŋgə̄ɨ pa ghaghana, pa fāʼo, ni nchhɔ́ shiʼi ŋkuoŋ ŋgrào mbhi yei fīgi vugu, paʼa ntíɛŋ yugu lɔ ma ntɨnɨ. ");
INSERT INTO bmo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ndɔ ti mbhɛ̌ moŋ shhɛ shiʼi pɛ ŋgwa ŋa pugu yaʼo chrà Minnwi ni ŋkiɛŋ njùʼɔ shiʼi, ndɔ ŋgwɛ̄iŋ a tɨnɨ, ŋgwɛ̄iŋ njùʼɔ ti njuŋ ntíɛŋ. ");
INSERT INTO bmo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ŋoŋ shiʼa nchuʼu truka ŋkuru ni mikru ki niʼiŋ laʼo kúoŋ, ŋoŋ ghà nchuʼu ntigi pi lɨʼɨ thi truka, nnɛ ŋa ŋgwa ŋa pugu nii nu nda nɛ yəɨ liʼɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yichəɨ yaoŋ lɔ mbɔ fɔ ŋa pi lə̄ɨŋ ŋa mbaʼa pi ma mieŋ ki nōoŋ lɨʼɨ wo, ki nnu ŋa pi kuru ŋa mbaʼa pi ma mieŋ ki ji a lɔ mbɨnɨ ntaoŋ lɨʼɨ liʼɛ. ");
INSERT INTO bmo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lɨna nu kiʼɛ ŋkwaŋ nɔ haʼaŋ ɔ ywɛrɛ nnu nɛ, nthɛ ŋa ŋoŋ ŋa a fāʼo nɛ, pi shi mbīgi ntou yi ghɔ, ndɔ ŋoŋ ŋa a lɔ njiʼi mfāʼo nɛ, pi shi ŋkwe shɨgɛi yɛ ŋa a pīʼi ŋa a fāʼo nɛ mbhɔ yu.” ");
INSERT INTO bmo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mǔuŋ Jishɔ pugu pa lǐŋ pi pi pimbia thɔ lɨʼɨ yəɨ vi, ndɔ paʼa ndɔ mfāʼo shɨna nthɛ yú ŋgwa yəɨ yu. ");
INSERT INTO bmo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yichəɨ ŋoŋ chhu ni Jishɔ ŋa, “Mǔuŋ ghɔ pugu pa lǐŋ pɔ pi pimbia pɔ nɛ mbhi ntāʼa nu njəɨ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jishɔ khwɛ̄ ni pugu ŋa, “Mǔuŋ a pugu pa lǐŋ paŋ ŋgwa pɛ ŋa pugu yaʼo chrà Minnwi ndɔ nchwīe nnu ŋa chrà ghɔ chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Llɛ́ chəɨ, Jishɔ nii moŋ kikuoŋ pugu pa ghaŋ younjiŋ pi nchhu ŋa, “Pia shāʼa ntaoŋ njiɛŋ hiŋ.” Nnɛ pugu wɛ̄iŋ ndaoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nɔ haʼaŋ pugu ni nchwi kikuoŋ ghɔ ŋgə̄ɨ nu nɛ, lɔgɔ wɛ̄iŋ Jishɔ. Mmɛ fiŋ gū moŋ ŋkhǐ, ŋkhǐ jɛ̄ lɨnaoŋ nu moŋ kikuoŋ yugu, ti pugu thi pi moŋ gu. ");
INSERT INTO bmo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pugu ghə̄ɨ ŋgūʼu Jishɔ, nchhu nu ŋa, “Masha! Masha! Pia khu nu nɛ ma!” A wūʼu, mbɨ̄ga fɨfrəɨ ghɔ pugu pa fiŋ moŋ ŋkhǐ, ŋguoŋ yi tithi, moŋ ŋkhǐ ju. ");
INSERT INTO bmo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A chhu ni ghaŋ younjiŋ pi ŋa, “Piŋ yəɨ pɔ pi hɨŋ?” Pugu pɔgɔ ndɔ ŋgrāo, nchhu ni noŋ pugu ŋa, “Yei pɔ pi yəɨ ŋkwaŋ ŋoŋ, ŋa a fɛ gɨ́ ni fɨfrəɨ pugu pa fiŋ ŋa pugu tithi pugu yaʼo nnɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jishɔ pugu pa ghaŋ younjiŋ pi shāʼa ŋkhǐ llɔ Galili ntaoŋ krao ŋgei Gerasha. ");
INSERT INTO bmo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nɔ haʼaŋ Jishɔ taoŋ moŋ kikuoŋ nɛ, mbāoŋ pugu yichəɨ ŋoŋ a fāʼo pa miŋwɛiŋ, a shini ndɔ māʼaŋ ndhwí nɔ ntaaŋ ndɨɨ, paʼa ndɔ ndaʼa nu nda, ŋka laʼa pi moŋ lɨʼɨ twei ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","A ni ŋga njəɨ Jishɔ, mūʼuŋ ŋgòu, ŋgū shhɛ shhɨ yu, nchhu ni njɨ ŋa, “Pɔgɔ fāʼo pi khɔ, Jishɔ Muuŋ Minnwi ŋa a chaa ŋguoŋ ŋgwa nɛ? M̀baʼo mbhɔ shhɨ ghɔ, kiʼi niʼiŋ a moŋ ŋgəʼɨ!” ");
INSERT INTO bmo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A ni nchhu yei nthɛ ŋa Jishɔ ni ŋkwo fɛ gɨ́ ni miŋwɛiŋ ghɔ ŋa a taoŋ mbɨŋ yu. Yiɛŋ ndɨɨ miŋwɛiŋ ghɔ ni nthɔ ncho vi, njiʼi nthɛ nɔ haʼaŋ pi ni ŋkrao mbhɔ mi, ŋgwɛ kipaʼo nɔ kwò mi nthɔ ŋkɛ̄ʼi vi nɛ, a shi ŋguʼɔ njaʼa maoŋ pighɔ yaʼa, miŋwɛiŋ ghɔ fra vi ŋgə̄ɨ nɔ moŋ ŋkǔnu njó. ");
INSERT INTO bmo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jishɔ pie vi kiʼɛ ŋa, “Ligi yɔ khɔ?” A ŋa, “Ligi a Káʼa Yi,” nthɛ ŋa ntou miŋwɛiŋ ni nii mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pa miŋwɛiŋ pighɔ lɨ̄gəɨ Jishɔ ŋa kiʼi a fɛ vugu moŋ lɨʼɨ ŋgəʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ŋkiɛŋ mmɛ kwíe ŋkunyaŋ ni nthɔ njɨ nu fɔ ŋkɨŋ mbra, pugu lɨ̄gəɨ vi ŋa a mieŋ pugu nii moŋ pa ŋkunyaŋ pighɔ, a mieŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pugu taoŋ kiʼɛ mbɨŋ ŋoŋ ghɔ, nii mbɨŋ pa miŋkunyaŋ pighɔ. Ŋguoŋ kwíe ŋkunyaŋ pighɔ tei llɔ ŋkɨŋ mbra ghɔ, nshwiʼi ŋkɨŋ ŋkhǐ, ŋgū moŋ ghɔ ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ghaŋ kɛ̄ʼi ŋkunyaŋ pighɔ ni ŋga njəɨ nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ, ntaoŋ tei ŋgə̄ɨ nchhu moŋ laʼa pugu pa moŋ nyìeŋ. ");
INSERT INTO bmo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ŋgwa taoŋ nɔ ghə̄ɨ nu njəɨ nnu haʼaŋ a lɔ̄gɔ lɨʼɨ nɛ. Ŋga nthɔ njəɨ Jishɔ, njəɨ ŋoŋ ghɔ ŋa miŋwɛiŋ pighɔ ni ntaoŋ mbɨŋ yu nɛ, a chɔchɔ yəɨ yu ni ndhwí mbɨŋ yu ndɔ mbɔ shishiʼi, pɔgɔ gu wɛ̄iŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pa ŋgwa pɛ ŋa pugu ni njəɨ nnu ghɔ nɛ, shwei vugu ŋkwaŋ haʼaŋ pi kwe ŋoŋ ghɔ ŋa pa miŋwɛiŋ ni mbɔ mbɨŋ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nɛnnɛ ŋguoŋ pa ŋgwa moŋ krao ŋgei Gerasha yōu Jishɔ ŋa a ghə̄ɨ, nthɛ ŋa ŋkiɛŋ pɔgɔ gu ni ŋgwɛ̄iŋ vugu. Nɛnnɛ Jishɔ nii moŋ kikuoŋ ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ŋoŋ ŋa miŋwɛiŋ pighɔ ni ntaoŋ mbɨŋ yu lɨ̄gəɨ Jishɔ ŋa, “Mieŋ ǹthɔ pɔgɔ ghə̄ɨ kaʼa.” Jishɔ lāa, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pɨnɨ laʼa, nshwei ŋgwa pɔ fɨʼɨ ŋkwaŋ haʼaŋ Minnwi fāʼa mbɨŋ ghɔ nɛ.” Ŋoŋ ghɔ nyīeŋ moŋ ŋguoŋ laʼa nthɔ mfɨ̄ʼɨ nnu ŋa Jishɔ chwīe mbɨŋ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ndɔ haʼaŋ Jishɔ ni mbɨnɨ nɛ, pa ŋgwa ni nchhu ghɔ ŋa a thɔ a pwa, nthɛ ŋa ŋguoŋ vugu ni nchhɔ njwɛrɛ vi. ");
INSERT INTO bmo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ŋoŋ chəɨ ŋa ligi yi Jairu, yɨ̄ga nchəɨŋ. A ni mbɔ mmɛŋoŋ moŋ nda luoŋ Minnwi, ŋgū shhɛ shhɨ Jishɔ nchhɔ ndɨ̄gəɨ vi ŋa a thɔ nda yu, ");
INSERT INTO bmo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","nthɛ ŋa fiɛŋ muuŋ vi yi miŋgwɛ ŋa a ni mfāʼo, mbɔ muuŋ paanchrɔ ŋgaʼo, ni nthɔ ŋkhu nu. Ndɔ haʼaŋ Jishɔ wɛ̄iŋ ndaoŋ nɛ, yú ŋgwa ni nthɔ mfra vi moŋ ŋguoŋ ŋgei ghao. ");
INSERT INTO bmo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Shɨna ŋgwa pei, miŋgwɛ chəɨ ni mbɔ fɔ ŋa a ki yəɨ ndɨɨ yi ni njɨ nɔ paanchrɔ ŋgaʼo, ŋkwo tūoŋ ŋguoŋ mbɨŋ yi ghao mbhɔ pa doktɔ, ndɔ paʼa pi lɔ nchwīe ndɨɨ yi yaʼa. Kaŋ taʼa ŋoŋ shi ki lɔ njiʼi mbɔ ŋa a kaŋ ni mfɛ a chwīe ghɨ̌nɔ yi mmɛ. ");
INSERT INTO bmo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nɛnnɛ, a ni nthɔ njiŋ Jishɔ ŋkāoŋ po ndhwí yi. Ndɨɨ yi ghɔ lɔ ŋkiʼɛ njaʼa yaʼa chomilaoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jishɔ pie ŋa, “A kāoŋ gɔ̌ ŋkāoŋ a?” Ŋguoŋ ŋgwa ni ŋga ndāa noŋ yugu, Pita chhu ŋa, “Taathɔ, yú ŋgwa thɔ ŋkɨrɨ nu ndɔ mfra ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jishɔ chhu ŋa, “Yichəɨ ŋoŋ kāoŋ a, mi nì njaʼo ŋkwaŋ haʼaŋ njɨ ntaoŋ mbɨŋ mu.” ");
INSERT INTO bmo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ndɨɨ ŋa miŋgwɛ vei ni njəɨ ŋa yichəɨ shɛndaoŋ lɔ mbɔ ŋa mimfɛ a lɛ̄rɛ nɛ, a wrū nthɔ nu, ŋgū shhɛ ni puŋ yi shhɨ Jishɔ ndɔ mfɨ̄ʼɨ shhɨ ŋguoŋ ŋgwa nnu haʼaŋ a ni nchwīe vi a kāoŋ Jishɔ nɛ, pugu pa ŋkwaŋ haʼaŋ ghɨ̌nɔ yi mmɛ chomilaoŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nɛnnɛ, Jishɔ chhu ghɔ ŋa, “Muuŋ a, piŋ yɔ chwīe ghɨ̌nɔ yɔ tɔgɔ, ghə̄ɨ ni gɔ moŋ ghɨghrɨ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ndɔ haʼaŋ Jishɔ wuʼɔ nchhɔ nchrā nu nɛ, yichəɨ ŋoŋ llɔ nda Jairu, mmɛŋoŋ moŋ nda luoŋ Minnwi, nthɔ nchhu ghɔ ŋa, “Muuŋ ghɔ kwo khu, kiʼi nuʼuŋ ŋgana masha ghagha.” ");
INSERT INTO bmo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ndɨɨ ŋa Jishɔ ni njaʼo nnu yei nɛ, a chhu ni Jairu ŋa, “Kiʼi nuʼuŋ mbɔgɔ gu, wuʼɔ nchhɔ mfāʼo pi piŋ, nnɛ kaŋ muuŋ ghɔ shi ndūgu.” ");
INSERT INTO bmo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ndɨɨ ŋa Jishɔ ni nchəɨŋ nda Jairu nɛ, a shini ndɔ mbiŋ ŋa ŋoŋ nduoŋ nii nda ŋkiɛŋ Pita pugu Jouŋ ni Jɛiŋ, ni tǎa muuŋ miŋgwɛ ghɔ pugu mǔuŋ vi. ");
INSERT INTO bmo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ŋguoŋ ŋgwa ni nthɔ ŋkə̄ɨ nu ndɔ njūa vi, Jishɔ ka chhu pi ŋa, “Kiʼi pəɨ nuʼuŋ ŋkə̄ɨ, nthɛ ŋa a lɔ ŋkhu, a lɛllɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pugu gwɛ̄ vi nthɛ ŋa pugu ni nji ŋa a kwo khu. ");
INSERT INTO bmo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jishɔ ka wɛ̄iŋ pi mbhɔ yi, mɛ̄iŋ nchhu ni njɨ ŋa, “Miyaa, lɔllɔ!” ");
INSERT INTO bmo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A ywiŋ, ndɔllɔ jijwɛ yi pɨnɨ, a lɔllɔ tɔthɨ wuʼɔ ndɨɨ ghɔ. Jishɔ chhu ni pugu ŋa pugu fɛ maoŋ ghɔ a jɨ. ");
INSERT INTO bmo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A ni ŋgrāo tǎa vi pugu mǔuŋ vi. Jishɔ chhu ni pugu ŋa kiʼi pugu shwei shesheŋoŋ ni nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jishɔ gɛ̄ paanchrɔ pighɔ lɨʼɨ muʼɔŋ mfɛ njɨ pugu pa ghrɨ́ ni pugu nɔ fuʼu nu pa miŋwɛiŋ ndɔ njɨ̄gɨ pa ghɨ̌nɔ, ");
INSERT INTO bmo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ntaoŋ vugu ŋa pugu ghə̄ɨ nchīi Shaʼafuoŋ Minnwi ndɔ mbɨnɨ njɨ̄gɨ ghɨ̌nɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nchhu ni pugu ŋa, “Kiʼi pəɨ lɔ̄gɔ sheshe yaoŋ nɔ haʼaŋ pəɨ ghə̄ɨ nyìeŋ ghɔ nɛ. Kiʼi pəɨ lɔ̄gɔ mbìe, ki pìɛŋ kra, ki maoŋ jɨ, ki mbɨŋ, ki ŋgə̄ɨ ni pa kwri ndhwí. ");
INSERT INTO bmo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sheshe nda ŋa pəɨ nii fɔ nɛ, pəɨ laʼa fɔ ti shi nuʼuŋ ntaoŋ laʼataoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sheshe lɨʼɨ ŋa pi lɔ mbiŋ vəɨ fɔ nɛ, pəɨ krū kwò məɨ, ntaoŋ ni vəɨ laʼataoŋ ghɔ nɔ nōoŋ nu ni pugu ŋa Minnwi pɨ̄na nnu ŋa pugu chwīe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pa ghaŋ ntaoŋ pi pighɔ taoŋ, nyīeŋ moŋ ŋguoŋ puoŋ mi laʼataoŋ ghao, nthɔ nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ ghɔ ndɔ njɨ̄gɨ ghɨ̌nɔ ŋguoŋ lɨʼɨ ghao. ");
INSERT INTO bmo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ndɨɨ ŋa Hɛrɔ, mbɔ fùoŋ Galili, ni njaʼo ŋguoŋ nnu pei nɛ, thɔ yi fiŋ nthɛ ŋa pichəɨ ŋgwa ni nthɔ nchhu nu ŋa Jouŋ Ŋgaŋ Fɛ Ŋkhǐ ni ŋgwa pɨnɨ ŋkuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pichəɨ chhu yugu ŋa Elaija nōoŋ noŋ yi, pichəɨ chhu yugu pi ŋa yichəɨ taʼa ndunu njəɨlɨʼɨ Minnwi pɨnɨ ŋkuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hɛrɔ chhu ŋa, “Ŋki yaʼa thɔ Jouŋ, ndɔ yei pɨnɨ mbɔ pi gɔ̌ ŋa njaʼo pa nnu nɔ ligi yi nɛ?” Mbaʼo nɔ yəɨ nu Jishɔ vei. ");
INSERT INTO bmo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ghaŋ ntaoŋ Jishɔ pighɔ ni ŋga mbɨnɨ, nshwei vi ni ŋguoŋ nnu ŋa pugu ni nchwīe nɛ. Jishɔ lɔ̄gɔ vugu pugu pugu fuʼu noŋ yugu shɨna ŋgwa, ŋgə̄ɨ Beshaida. ");
INSERT INTO bmo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yú ŋgwa ni ŋga njaʼo, njōu njiŋ yi. Jishɔ gha nchhu ni pugu ŋa pugu thɔ a pwa, nthɔ nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ Shaʼafuoŋ Minnwi ni pugu, njɨ̄gɨ ghɨ̌nɔ ŋgwa pɛ ŋa pugu ni ŋgɨ̄nɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Minaoŋ ni ŋga njɛ̄ nii nu, paanchrɔ ghaŋ ntaoŋ pighɔ thɔ njəɨ Jishɔ nchhu ghɔ ŋa, “Chhu ŋgwa pei ghə̄ɨ, nji ŋa minthɛ pugu ghə̄ɨ moŋ pa laʼa pugu pa mooŋ mbàŋ mbambara, ntāʼa lɨʼɨ laʼa pugu pa maoŋ jɨ, nthɛ ŋa lɨʼɨ yei pɔ pi ŋkǔnu njó.” ");
INSERT INTO bmo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jishɔ khwɛ̄ ni pugu ŋa, “Pəɨ ŋkaa pəɨ fɛ maoŋ pugu jɨ.” Pugu chhu ŋa, “Ŋguoŋ yaoŋ ŋa pigi fāʼo nɛ wuʼɔ tiɛŋ brɛi pugu paa shhu. Ɔ taʼa nu ŋa pigi ghə̄ɨ njuoŋ maoŋ jɨ ni mbalaŋ ŋgwa pei?” ");
INSERT INTO bmo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pimbia ni mbɔ fɔ nchəɨŋ nɔ tiɛŋ ŋkaŋ yugu. Jishɔ chhu ni ghaŋ younjiŋ pi pighɔ ŋa, “Pəɨ chhu ni pugu ŋa pugu chɔchɔ shhɛ, taʼa kwíe pɔ nɔ tiɛŋ wuŋ ŋgwa.” ");
INSERT INTO bmo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pugu wuʼɔ nuʼuŋ njaʼo pi nɛnnɛ, nchwīe ŋguoŋ ŋgwa chɔchɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A gha ndɔ̄gɔ tiɛŋ kəɨŋ brɛi ghɔ ni paa shhu ghɔ, mbɨʼɨ ligi yi ndīi po ntōo Minnwi, mbəʼɨ, mfɛ ni pa ghaŋ younjiŋ pi ŋa pugu ghrā ni ŋgwa pighɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ŋguoŋ yugu kru ti njru, ti pugu lɨ̄ga pa pəʼɨ pi ŋa a ni mbɨgəɨ nɛ, a lɨnaoŋ paanchrɔ mikuo. ");
INSERT INTO bmo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Taʼa llɛ́ chəɨ ni mbɔ, Jishɔ thɔ nduoŋ Minnwi təʼɨ vi, pa ghaŋ younjiŋ pi thɔ mbara vi. A pie vugu ŋa, “Pa ŋgwa ghà nchhu ŋa mi pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pugu khwɛ̄ ŋa, “Pichəɨ ŋgwa ghà nchhu ŋa ɔ Jouŋ Ŋgaŋ Fɛ Ŋkhǐ, pichəɨ ŋa ɔ Elaija, pichəɨ ŋa ɔ taʼa njəɨlɨʼɨ Minnwi llɛshhɨ ŋa a pɨnɨ nuʼuŋ ŋkuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A pie vugu ŋa, “Ti pəɨ nɛ? Pəɨ chhu yəɨ ŋa mi gɔ̌?” Pita khwɛ̄ ŋa, “Ɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, llɔ mbhɔ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jishɔ fɛ tɨtɨnɨ gɨ́ ni pugu ŋa kiʼi pugu shwei nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ ni shesheŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mbɨnɨ nchhu ni pugu ŋa, “Muuŋ Ŋoŋmishua shi ŋguʼɔ njəɨ ŋgəʼɨ nthɛ ntou pa nnu, pa thishɨ pa Juu pugu pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi lāa vi, pi jwi vi, a gha ndaʼa trɛi llɛ́ a kuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mbɨnɨ nchhu ni ŋguoŋ vugu ŋa, “S̈hesheŋoŋ ntāʼa nu njōu njiŋ a, â mieŋ phi nnu haʼaŋ a khwā nɛ, ntiɛŋ wáʼa yi sheshe llɛ́ ndɔ njōu njiŋ a. ");
INSERT INTO bmo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nthɛ ŋa shesheŋoŋ ŋa a tāʼa nu ndūgu ni chɔmbhi yi nɛ shi nshiɛŋ chɔmbhi yi ghɔ, ti ŋoŋ yɛ ŋa a mīʼaŋ chɔmbhi yi nthɛ a nɛ, shi ndūgu ni chɔmbhi yi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ŋoŋmishua nthɛ a shei pi khɔ nɔ haʼaŋ ä mfāʼo ŋguoŋ yaoŋ moŋ mbhi hɛiŋ ndɔ mbhɛ chɔmbhi yi? ");
INSERT INTO bmo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nthɛ ŋa shesheŋoŋ ŋa a fāʼo lrithɔ mbɨŋ mu, ki ni chrà a nɛ, Muuŋ Ŋoŋmishua shi mfāʼo lrithɔ mbɨŋ yu ndɨɨ ŋa a thɔ moŋ ndighaʼo yi nɛ, pugu pa ndighaʼo Tǎa, ni pa ghaŋ ntaoŋ taoŋtaoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ndɔ ǹchhu pi nnu shini ni pəɨ ŋa pichəɨ ŋgwa thi hɛiŋ ŋa mbaʼa pugu khu ki lɔ njəɨ Shaʼafuoŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","A ni ŋga nchhu nnu pei ti ndaʼa taʼa taŋ, ndɔ̄gɔ Pita, ni Jouŋ, ni Jɛiŋ pugu pugu kuʼɔ ŋkuoŋ mbra lɨʼɨ luoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ndɔ haʼaŋ a ni nthɔ nduoŋ Minnwi nɛ, miŋi mi kwri mbɔ ŋkwaŋ nduoŋ, ndhwí pi fugu, nchīa ŋa ŋmɛiŋ nɔ fiembɨ. ");
INSERT INTO bmo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ŋga njəɨ nu nɛ, paa ŋgwa chrā nu pugu yu, pugu ni mbɔ Mushi pugu Elaija, ");
INSERT INTO bmo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","nōoŋ noŋ yugu moŋ ndighaʼo pa po, nthɔ nchrā nu ŋkuoŋ nnu gu yi ŋa ju Jishɔ ni nthɔ nchwīe nu ŋa a lɔ̄gɔ lɨʼɨ Jerushalɛiŋ, ŋkwaŋ nɔ haʼaŋ Minnwi ni nūʼɔŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ndɔ lɔgɔ ni njiɛŋ mbɨŋ Pita pugu pa ŋgwa ŋa pugu pugu ni mbɔ nɛ. Pugu gha nja ŋgūʼu, njəɨ líʼɛ ndighaʼo Jishɔ, pugu pa paa ŋgwa pɛ ŋa a ni nthi pugu pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ndɨɨ ŋa ŋgwa pighɔ ni mieŋ Jishɔ ŋgə̄ɨ nu nɛ, Pita chhu ghɔ ŋa, “Masha, a pwa nɔ haʼaŋ pia pɔ hɛiŋ kaʼa nɛ, pigi shi ŋkrao trɛi ntǎa! Taʼa yi vɛ, taʼa yi ni Mushi, taʼa yi ni Elaija.” Ndɔ a shini ndɔ njiʼi nji nnu ŋa a ni chhu nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A ni ŋga ŋguʼɔ nchrā nu, lúluŋ shwiʼi ŋkuru vugu, pɔgɔ gu wɛ̄iŋ vugu nɔ haʼaŋ lúluŋ ghɔ ni ŋkuru vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yichəɨ ŋggì chhu moŋ lúluŋ ghɔ ŋa, “Yei Muuŋ a ŋa ǹchuʼɔ vi, p̂əɨ yaʼo mbhɔ yu.” ");
INSERT INTO bmo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ŋggì ghɔ ni ŋga nchrā ti mīʼɛŋ, pugu yəɨ Jishɔ pi təʼɨ vi, nūʼɔŋ nnu pei shɨna pugu, ki lɔ njiʼi nshwei shesheŋoŋ ni nnu ŋa pugu yəɨ nɛ wuʼɔ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mbhi ni ŋga ndaŋ, Jishɔ pugu pa trɛi ghaŋ ntaoŋ pi pighɔ shwiʼi llɔ ŋkuoŋ mbra ghɔ, ŋkiɛŋ mmɛ kɨrɨ ŋgwa thɔ mbara Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ŋga njəɨ nu, yichəɨ ŋoŋ paʼo ŋgòu moŋ kɨrɨ ghɔ, nchhu ŋa, “Masha, m̀baʼo mbhɔ vɛ, līi muuŋ a vei njəɨ, ndɔ mbɔ fiɛŋ yi. ");
INSERT INTO bmo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yichəɨ miŋwɛiŋ ghà ncho vi, a wīʼi mbaʼo ŋgòu, miŋwɛiŋ ghɔ māʼaŋ vi shhɛ, a kwēi nu, faʼofaʼo taoŋ nu nchò yu, nja nchhɔ nwīʼiŋ vi nwīʼiŋ ndɔ paʼa ndɔ mieŋ vi! ");
INSERT INTO bmo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi ni ndɨ̄gəɨ pa ghaŋ younjiŋ pɔ ŋa pugu fuʼu miŋwɛiŋ ghɔ mbɨŋ yu, pugu fuʼu kie.” ");
INSERT INTO bmo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jishɔ khwɛ̄ ŋa, “Pəɨ ŋgwa ki fāʼo piŋ, ŋgwa pɨphɨ, mi shi nchhɔ pia pi fɨʼɨ ndɨɨ nɛiŋ, mfāʼo fɨʼɨ wɛ̄iŋ njùʼɔ nɛiŋ nthɛ vəɨ? Thɔ ni muuŋ ghɔ hɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nɔ haʼaŋ muuŋ ghɔ ni nthɔ nu nɛ, miŋwɛiŋ ghɔ māʼaŋ vi shhɛ, a kwēi nu, faʼofaʼo taoŋ nu nchò yu. Jishɔ pɨ̄ga miŋwɛiŋ ghɔ, njɨ̄gɨ ghɨ̌nɔ yi, mfɛ vi ni tǎa vi. ");
INSERT INTO bmo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ŋguoŋ ŋgwa ni ŋgrāo fɨʼɨ ghrɨ́ ŋa Minnwi fāʼo nɛ. Ŋgwa ni ŋga ŋguʼɔ nthɔ ŋgrāo ŋguoŋ nnu ŋa Jishɔ ni nchwīe nɛ, a chhu ni ghaŋ younjiŋ pi ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“P̂əɨ yaʼo nnu yei ŋa ǹtāʼa nchhu ni pəɨ nɛ shishiʼi! Pi tɔthɔ nchaʼa Muuŋ Ŋoŋmishua mfɛ liɛŋ mbhɔ ŋgwamishua.” ");
INSERT INTO bmo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ndɔ paʼa ghaŋ younjiŋ pi lɔ nji njiŋ nnu ghɔ. Pi ni ndə̄ɨŋ vugu nɔ nnɛ ŋa kiʼi thɔ yugu shie ni nnu ghɔ, ndɔ pugu pɔgɔ nɔ pie nu vi ni nnu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mindoundou gū shɨna ghaŋ younjiŋ pi ŋa a gɔ̌ mbɔ ŋoŋ ndiɛŋ nchaa pichəɨ? ");
INSERT INTO bmo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jishɔ ni nji nnu ŋa pugu ni mbīʼi nu njùʼɔ pugu nɛ, ndɔ̄gɔ muuŋ mbrɔ nūʼɔŋ yəɨ yu, ");
INSERT INTO bmo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nchhu ni pugu ŋa, “Ŋoŋ ŋa a piŋ muuŋ vei nɔ ligi a nɛ piŋ pi mmu, ti shesheŋoŋ ŋa a piŋ a nɛ, piŋ pi ŋoŋ ŋa a taoŋ a nɛ. Nthɛ ŋa ŋoŋ ŋa a kɨgəɨ shɨna pəɨ nchaa ŋguoŋ ŋgwa nɛ, a ju mbɔ ŋoŋ ndiɛŋ nchaa ŋguoŋ yəɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jouŋ khwɛ̄ ŋa, “Masha, pigi yəɨ ŋoŋ a fuʼu miŋwɛiŋ mbɨŋ ŋoŋ ni ligi yɔ, pigi lāa ghɔ nthɛ ŋa pigi pugu shiʼa njōu njiŋ yɔ kaʼa.” ");
INSERT INTO bmo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jishɔ chhu ghɔ ŋa, “Kiʼi nuʼuŋ ndāa ghɔ nthɛ ŋa ŋoŋ ŋa a lɔ ndāa ghɔ nɛ pɔ ŋgei ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pa llɛ́ ni ŋga mbara nu ŋa pi shi ndɔ̄gɔ Jishɔ po nɛ, a lɔ̄gɔ nthi mi tɨtɨnɨ nɔ ghə̄ɨ nu Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A taoŋ ghaŋ ntaoŋ shhɨ, pugu ghə̄ɨ nii moŋ yichəɨ laʼataoŋ moŋ Shamaria nɔ pīri nu ŋguoŋ pa yaoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ndɔ paʼa ŋgwa pighɔ lɔ mbiŋ vi nthɛ ŋa a shini ndɔ nuʼuŋ mbɔ pi nnu khuthɔ ŋa a ghə̄ɨ pi Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ndɨɨ ŋa ghaŋ younjiŋ pi, Jɛiŋ pugu Jouŋ, ni njəɨ nnu pighɔ nɛ, pugu pie vi ŋa, “Taathɔ, ɔ tāʼa nu ŋa pigi mɛ̄iŋ móŋoŋ po, a shwiʼi njɨ̄gɨ vugu?” ");
INSERT INTO bmo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jishɔ shrī mbɨ̄ga vugu. ");
INSERT INTO bmo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pugu pugu kara kiʼɛ ŋgə̄ɨ laʼataoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nɔ haʼaŋ pugu ni ŋgə̄ɨ nu shɛndaoŋ nɛ, yichəɨ ŋoŋ chhu ni Jishɔ ŋa, “Ǹshi njōu njiŋ yɔ sheshe lɨʼɨ ŋa ɔ shi ŋgə̄ɨ nɛ”. ");
INSERT INTO bmo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jishɔ chhu ghɔ ŋa, “Pa mimbaaŋguo fāʼo pa pùo pugu, pa mishi fāʼo pa nda pugu, ndɔ Muuŋ Ŋoŋmishua lɔ njiʼi mfāʼo lɨʼɨ lɛ̄rɛ thɔ yi.” ");
INSERT INTO bmo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jishɔ kara nchhu ni yichəɨ ŋoŋ ŋa, “Thɔ njōu njiŋ a.” Ŋoŋ ghɔ chhu ŋa, “Taathɔ, fǔoŋ mieŋ ŋ̀gə̄ɨ ntwei tǎa a ŋkaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jishɔ khwɛ̄ ghɔ ŋa, “Mieŋ ŋgwa ŋa pugu khu nɛ twei khu ŋgwa pugu. Ndɔ ni gɔ̀ ghə̄ɨ nchīi shaʼa nu fùoŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yichəɨ ŋoŋ pɨnɨ nchhu ŋa, “Ǹshi njōu njiŋ yɔ, ma Taathɔ, ndɔ fǔoŋ mieŋ ŋ̀gə̄ɨ nchāʼa ŋgwa laʼa pigi.” ");
INSERT INTO bmo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jishɔ chhu ghɔ ŋa, “Ŋoŋ ŋa a wɛ̄iŋ ŋkɨɨ naʼaŋ fāʼa nyìeŋ ŋa a fāʼa nyìeŋ, mbɨnɨ ŋkara nthɔ ndīi njiŋ nɛ, lɔ njiʼi mfāʼo ghɛ̀rɛ moŋ Shaʼafuoŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pa nnu pei ni ŋga ntɔgɔ, Taathɔ pɨnɨ ntɛrɛ khwachəɨ wuŋ ŋgwa ni yi paa ntaoŋ vugu pa pi paa ŋa pugu ghə̄ɨ shhɨ yu moŋ ŋguoŋ pa laʼataoŋ pɛ ŋa a tāʼa nu ŋgə̄ɨ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A ni nchhu ni pugu ŋa, “Maoŋ kwōo yiɛŋ ndɔ ghaŋ kwōo pi kɨgəɨ. Nthɛ yie ghɔ, pəɨ luoŋ ni taʼanjuʼɔ mbhɔ Taathɔ ŋa a fāʼo maoŋ pighɔ nɛ ŋa a taoŋ pa ghaŋ fàʼa pugu ghə̄ɨ ŋkwōo maoŋ pi. ");
INSERT INTO bmo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","P̂əɨ ghə̄ɨ! Ǹtaoŋ vəɨ nɔ pa puoŋ minjɨɨ shɨna pa miŋaŋieŋ. ");
INSERT INTO bmo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kiʼi ntuo pìɛŋ mbɨŋ, ki pìɛŋ maoŋ jɨ, ki kwri tra. Kiʼi nchrā ni ŋoŋ shɛndaoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Sheshe nda ŋa pəɨ nii fɔ nɛ, fǔoŋ nchhu ŋa, ‘Ghɨghrɨ pɔ moŋ nda hɛiŋ.’ ");
INSERT INTO bmo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ti ŋ̈oŋ mbɔ fɔ ŋa a khwā ghɨghrɨ, kaŋ ghɨghrɨ yɔ shi nshwiʼi mbɨŋ yu. Ŋkiɛŋ nɛnnɛ, kaŋ ghɨghrɨ yɔ shi mbɨnɨ mbhɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kɨna moŋ yie nda nthɔ njɨ nu ndɔ nnu sheshe yaoŋ ŋa pi fɛ vɛ nɛ, nthɛ ŋa a pie ŋa ŋgaŋ fàʼa fāʼo pe yi. Kiʼi nyīeŋ pi nda nda. ");
INSERT INTO bmo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Sheshe laʼataoŋ ŋa pəɨ nii fɔ pi piŋ vəɨ fɔ nɛ, pəɨ jɨ sheshe yaoŋ yɛ ŋa pi fɛ ni pəɨ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pəɨ yɨ̄gɨ ghɨ̌nɔ pa ŋgɨ̌nɔ fɔ, nchhu ni pugu ŋa, ‘Shaʼafuoŋ Minnwi thɔ nɛ ti mbara yəɨ pəɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ndɔ ti p̈əɨ nii moŋ sheshe laʼataoŋ ki pugu lɔ mbiŋ vəɨ, pəɨ ghə̄ɨ taʼandaoŋ pugu nchhu fɔ ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ti mfɛ pi ni pru laʼataoŋ yəɨ ŋa a kuʼɔ nɔ kwò miŋi nɛ, pigi yɨ̄gɨ nɛ mfɛ thɔ pəɨ. Ndɔ pəɨ kwiŋ ŋa Shaʼafuoŋ Minnwi thɔ nɛ ti mbara.’ ");
INSERT INTO bmo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Shishini, ǹshwei vəɨ, moŋ llɛmbhi sháʼa, a shi njiʼɛ ni laʼataoŋ Shodoŋ nchaa yie laʼataoŋ ŋa pugu lāa vəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ŋgəʼɨ pɔ ni pəɨ, ma ŋgwa Korashiŋ! Ŋgəʼɨ pɔ ni pəɨ, ma ŋgwa Beshaida! Nthɛ ŋa pa nnu ghraoghrao pei ŋa a lɔ̄gɔ lɨʼɨ hɛiŋ nɛ, kaŋ ni mbɔ pi Tairɛ pugu Shidoŋ, pugu kaŋ ni ŋkwo māʼaŋ ndhwí ywei gu nchhɔ moŋ phu nɔ nōoŋ nu ŋa pugu pāʼa ŋkǔnu yugu ni phɨ. ");
INSERT INTO bmo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mbapa nɛnnɛ, a shi ndɛ njiʼɛ ni laʼataoŋ Tairɛ pugu Shidoŋ moŋ llɛmbhi sháʼa nchaa vəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ndɔ ni pəɨ, ma ŋgwa Kapanuŋ, pəɨ pīʼi ŋa Minnwi shi ndɔ̄gɔ vəɨ ŋkuʼɔ nɔ po? Ŋga! A shi nshwiʼi vəɨ moŋ lɨʼɨ ŋgwa khu.” ");
INSERT INTO bmo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jishɔ chhu ni ghaŋ younjiŋ pi ŋa, “Shesheŋoŋ ŋa a yaʼo nnu ŋa pəɨ chhu nɛ, yaʼo pi mmu, shesheŋoŋ ŋa a lāa nnu ŋa pəɨ chhu nɛ lāa pi mmu. Ndɔ shesheŋoŋ ŋa a lāa a nɛ lāa pi ŋoŋ ŋa a taoŋ a nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Khwachəɨ wuŋ ŋgwa ni yi paa pighɔ pɨ̄nɨ moŋ pwanjuʼɔ, nchhu ŋa, “Taathɔ, pa miŋwɛiŋ yaʼo nchò yigi ndɨɨ ŋa pigi fɛ gɨ́ ni pugu ni ligi yɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jishɔ chhu ni pugu ŋa, “Mi nì njəɨ Shata gū llɔ po nɔ fiembɨ. ");
INSERT INTO bmo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Līi njəɨ, m̀fɛ njɨ ni pəɨ ŋa pəɨ nyīeŋ ŋkuoŋ pa mitwɛʼi pugu pa ŋíeŋ pugu pa ŋguoŋ ghrɨ́ mimbɨna ki kàʼa lɔ ŋkēe vəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mbapa nɛnnɛ, kiʼi pəɨ fāʼo pwanjuʼɔ nthɛ pi ŋa pa miŋwɛiŋ yaʼo nchò yəɨ. Pəɨ ka fāʼo pwanjuʼɔ nthɛ pi ŋa Minnwi nāʼaŋ ligi yəɨ po.” ");
INSERT INTO bmo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Moŋ ndɨɨ ghɔ, Jishɔ fāʼo pwanjuʼɔ moŋ Jijwɛ Minnwi nchhu ŋa, “Tǎa, a gɔ̀ mbɔ Taathɔ po pugu pa ŋkuoŋ shhɛ. Ǹtōo ghɔ nthɛ ŋa yaoŋ ŋa ɔ lə̄ɨŋ ni ghaŋ shiethɔ pugu pa ghaŋ lɨna nɛ, ɔ nōoŋ ni pa puoŋ fhu. Ooŋ, ma Tǎa, yei ŋkwaŋ haʼaŋ ɔ ni ŋkhwā ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tǎa a kwo chaʼa ŋguoŋ yaoŋ mfɛ mbhɔ mu, yichəɨ ŋoŋ lɔ nji ŋoŋ ŋa Muuŋ yie ghɔ nɛ ŋkiɛŋ Tǎa, ki nji ŋoŋ ŋa Tǎa yie ghɔ nɛ ŋkiɛŋ Muuŋ pugu pa shesheŋoŋ ŋa Muuŋ chuʼɔ nɔ nōoŋ nu Tǎa ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jishɔ kara nchhu ni pa ghaŋ younjiŋ pi njiŋnjiŋ ŋa, “Pəɨ fāʼo ntou prɔthɔ nɔ yəɨ nu pa nnu pɛ ŋa pəɨ yəɨ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ǹshwei vəɨ ŋa ntou pa njəɨlɨʼɨ Minnwi pugu pa fùoŋ ni ŋkhwā nɔ yəɨ nu pa nnu ŋa pəɨ yəɨ nu nɛ, ndɔ paʼa ndɔ njəɨ. Ki nɔ yaʼo nu pa nnu ŋa pəɨ yaʼo nu nɛ, ndɔ paʼa ndɔ njaʼo.” ");
INSERT INTO bmo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yichəɨ taʼa ŋgaŋ yɛʼi ŋgwa ni gɨ́ lɔllɔ tɔthɨ lɨʼɨ mōoŋ Jishɔ, mbie vi ŋa, “Masha, a yiʼi ŋa ǹchwīe nɛiŋ nɔ fāʼo nu chɔmbhi ki mmɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jishɔ khwɛ̄ ŋa, “Ŋwaʼaŋlɨ Minnwi chhu pi ŋa? Njiŋ yi pɔ pi ŋa vɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ŋoŋ ghɔ khwɛ̄ ŋa, “Khwā Taathɔ mbɔ Minnwi yɔ ni ŋguoŋ njùʼɔ yɔ ghao, pugu pa nchə̌ɨ yɔ, pugu pa ŋguoŋ njɨ yɔ, pugu pa ŋguoŋ pīʼi nu yɔ, ndɔ mbɨnɨ nuʼuŋ ŋkhwā taakuo yɔ ndɔ haʼaŋ ɔ khwā noŋ yɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jishɔ chhu ghɔ ŋa, “Ɔ khwɛ̄ a kāʼo. Chwīe nɛnnɛ mfāʼo chɔmbhi.” ");
INSERT INTO bmo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ŋgaŋ yɛʼi ŋgwa ni gɨ́ ghɔ tāʼa nu nɔ nōoŋ nu ŋa a ŋoŋ ndɨndɨ, nɛnnɛ mbie Jishɔ ŋa, “Taakuo a pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jishɔ khwɛ̄ ŋa, “Ŋoŋ Juu ni ndhɔ Jerushalɛiŋ nshwiʼi nu Jeriko, ŋgwīʼi mbɨŋ pa ŋgɨna minwi. Pugu wie vi, ŋkwe ndhwí yi pugu pa mbɨŋ yi, ŋgə̄ɨ ni vugu mieŋ vi a piʼi shɨgɛi ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“A ni ŋga mbɔ nɛnnɛ, ŋgaŋ fɛʼiŋgiɛŋ Minnwi, mbɔ ŋoŋ Juu, ni shwiʼi nu shɛndaoŋ ghɔ ŋga njəɨ vi, mbəɨ ntɔgɔ po ndaoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wuʼɔ nɛnnɛ, ŋoŋ Levi ni nshwiʼi nu shɛndaoŋ ghɔ ŋkaa yu, ŋga njəɨ vi, mbəɨ ntɔgɔ po ndaoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ndɔ ŋoŋ Shamaria ŋa a ni ŋgə̄ɨ kra taoŋ ŋgwīʼi mbɨŋ yu, ŋga njəɨ vi, mfāʼo kwoshɨnɨ mbɨŋ yu, ");
INSERT INTO bmo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","nshwiʼi ŋgə̄ɨ mbara ŋoŋ vei, nshāʼo wru pugu pa làʼo ŋkuoŋ fɨ́ yi ndɔ ŋkrao. Ntiɛŋ vi nūʼɔŋ ŋkuoŋ ŋkwɛ́iŋ yi, ŋgə̄ɨ ni ju moŋ nda pa ghɨ̀nɨ, nchhɔ ndɨna nu ni ju fɔ. ");
INSERT INTO bmo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mbhi ni ŋga ndaŋ ŋoŋ Shamaria vei fuʼu mbɨŋ mfɛ ni taathɔ moŋ nda yei, nchhu ghɔ ŋa, ‘Lɨna nu ni ju ti ǹshi mbɨnɨ. Mbɨŋ ŋa a shi mbīgi nɛ, ǹshi mbe vɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jishɔ pie ŋa, “A yəɨ shɨna trɛi ŋgwa pei ŋa a taakuo ŋoŋ vei ŋa pa ŋgɨna minwi ni ŋgwɛ̄iŋ vi ŋgwie vi ndəɨŋ vi nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ŋgaŋ yɛʼi gɨ́ Minnwi khwɛ̄ ŋa, “Ŋoŋ ŋa a ki nōoŋ kwoshɨnɨ nɛ.” Jishɔ chhu ŋa, “Ghə̄ɨ ŋguʼɔ nchwīe pi nɛnnɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jishɔ pugu pa ghaŋ younjiŋ pi ni ŋga nyīeŋ nu, a ghə̄ɨ nii moŋ yichəɨ laʼataoŋ. Miŋgwɛ chəɨ, ligi yi pɔ Mata, chhu ghɔ ŋa a thɔ a pwa nda yu. ");
INSERT INTO bmo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A ni mfāʼo ndǐŋ vi, ligi yi pɔ Meri. Meri chhɔ shhɛ laʼo kwò Taathɔ nthɔ njaʼo ntɨ́gɨ yi. ");
INSERT INTO bmo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Njùʼɔ Mata ni ŋgana vi nthɛ ntou pa maoŋ jɨ ŋa a ni mfāʼo nɔ pīri nu nɛ. A pie Jishɔ ŋa, “Taathɔ, a lɔ ŋgana ghɔ ŋa ndǐŋ a mieŋ a ŋa mbīri ŋguoŋ pa maoŋ təʼɨ a? Chhu nɛ ghɔ a thɔ ŋgɛ̄rɛ a.” ");
INSERT INTO bmo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ndɔ Taathɔ ka khwɛ̄ ghɔ pi ŋa, “Mata, Mata, njùʼɔ yɔ ghana nu, ɔ wie noŋ yɔ nthɛ ntou pa nnu, ");
INSERT INTO bmo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","a wuʼɔ taʼa yaoŋ mbɔ mmɛ nnu. Meri kwo tɛrɛ ŋkiɛŋ yi ghɔ, mbɔ yɛ ŋa mbaʼa pi ma ŋkwe mbhɔ yu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Llɛ́ chəɨ ni mbɔ, Jishɔ thɔ nduoŋ Minnwi lɨʼɨ chəɨ, ŋga mīʼɛŋ, yichəɨ taʼa ŋgaŋ younjiŋ yi thɔ nchhu ghɔ ŋa, “Taathɔ, yɛʼi vigi ni luoŋ nu Minnwi ŋkwaŋ haʼaŋ Jouŋ ni njɛʼi ghaŋ younjiŋ pi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jishɔ chhu ni pugu ŋa, “Ndɨɨ ŋa pəɨ luoŋ Minnwi nɛ, pəɨ chhu ŋa, ‘Minnwi Tǎa vigi, ghaʼo nu pɔ ni ligi yɔ, shaʼafuoŋ yɔ thɔ. ");
INSERT INTO bmo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fɛ maoŋ ni pigi ŋa pigi shi njru ŋkuoŋ ghɔ sheshe llɛ́ nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ndɔ ndīʼɛ phɨ yigi, nthɛ ŋa pigi ghà ndīʼɛ phɨ ŋguoŋ ŋgwa pɛ ŋa pugu fāaŋ mbɨŋ pigi nɛ. Kiʼi nchwīe pigi nii moŋ tɨtɨnɨ mōoŋ nu!’ ” ");
INSERT INTO bmo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nnɛ a pɨnɨ nchhu ni ghaŋ younjiŋ pi ŋa, “Lɔ̄gɔ ŋa taʼa ŋoŋ vəɨ ghə̄ɨ nda taannu vi moŋ ntuŋ mbhi nchhu ghɔ ŋa, ‘Taannu a, fōo a ni trɛi ndigi brɛi, ");
INSERT INTO bmo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nthɛ ŋa taannu a ŋa a chhɔ ŋgə̄ɨ kra, chəɨŋ nda mu, paʼa ǹdɔ mfāʼo maoŋ jɨ nɔ fɛ nu ghɔ!’ ");
INSERT INTO bmo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Lɔ̄gɔ ŋa taannu yɔ ghɔ khwɛ̄ nda ŋa, ‘Kiʼi ŋgana a! Ŋ̀kwo chri nda ti pigi pa puoŋ paŋ kwo nanuaŋ. Minthɛ paʼa ǹdɔ nuʼuŋ ndɔllɔ mfɛ yaoŋ vɛ.’ ");
INSERT INTO bmo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ǹchhu vɛ ŋa, njiʼi nthɛ nɔ haʼaŋ mbaʼa a yiʼi ndɔllɔ mfɛ vɛ nthɛ ŋa a taannu yɔ nɛ, ndɔ ti a shi ndɔllɔ mfɛ vɛ nthɛ ŋa ɔ lɔ njiʼi ndrithɔ nɔ pie nu ki jwɛ. ");
INSERT INTO bmo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ndɔ ti ǹshwei vəɨ, p̂əɨ pie, kaŋ Minnwi shi mfɛ ni pəɨ, p̂əɨ tāʼa, kaŋ Minnwi shi nchwīe pəɨ yəɨ, p̂əɨ kwēi kaŋ Minnwi shi nchuʼɔ chonda ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nthɛ ŋa shesheŋoŋ ŋa a pie nɛ ghà mfāʼo, ŋoŋ ŋa a tāʼa nɛ yəɨ, ni ŋoŋ ŋa a kwēi nɛ pi shi nchuʼɔ chonda ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“A gɔ̌ shɨna pəɨ ŋa m̈uuŋ vi mbie shhu ghɔ, a fɛ pi mitwɛʼi ghɔ? ");
INSERT INTO bmo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ki mbie vi ni mbāoŋ, a fɛ pi ŋíeŋ ghɔ? ");
INSERT INTO bmo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ti p̈əɨ kiʼɛ ŋa pəɨ ghà nchwīe phɨ nɛ nji fɛ nu pi pa maoŋ shiʼi ni puoŋ pəɨ, ti Tǎa vəɨ ŋa a chhɔ po nɛ shi mfɛ Jijwɛ Minnwi pi fɨʼɨ yi nɛiŋ ni ŋgwa pɛ ŋa pugu pie vi nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yichəɨ ndɨɨ, Jishɔ ni nthɔ mfuʼu miŋwɛiŋ mbɨŋ ŋoŋ ŋa a ni nchwīe ŋoŋ ghɔ pɔ pi fhɨncho. Miŋwɛiŋ ghɔ ni ŋga ntaoŋ, fhɨncho ghɔ chrā, ŋgwa pighɔ ghrāo. ");
INSERT INTO bmo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ndɔ pichəɨ ŋgwa pighɔ chhu ŋa, “A fuʼu miŋwɛiŋ ni ghrɨ́ Bɛjɛbu, mbɔ nthishɨ pa miŋwɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pichəɨ tāʼa nu mōoŋ vi, nnɛ nchhu ghɔ ŋa â chwīe taʼa lì nɔ nōoŋ nu ŋa njɨ yi llɔ pi mbhɔ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jishɔ ni nji nnu ŋa pugu ni mbīʼi nu nɛ, nnɛ nchhu kiʼɛ ni pugu ŋa, “Mbaʼa sheshe laʼa ŋa ŋgwa chhɔ māʼaŋ noŋ pugu ni nchhɔ̀ nɛ mieŋ ki gū, ndɔ ti sheshe nda ŋa a pɔ pi ni minduoŋnduoŋ nɛ shi ŋgū nshāaŋ. ");
INSERT INTO bmo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nnɛ ti S̈hata nthi pi moŋ minduoŋnduoŋ ni noŋ yi, shaʼafuoŋ yi lara pi nɛiŋ? Nthɛ ŋa ɔ chhu ŋa m̀fuʼu miŋwɛiŋ pi ni ghrɨ́ Bɛjɛbu. ");
INSERT INTO bmo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti ä mbɔ ŋa m̀fuʼu miŋwɛiŋ pi ni ghrɨ́ Bɛjɛbu, kaŋ pa ghaŋ younjiŋ pəɨ ghà mfuʼu pi ni ghrɨ́ gɔ̌? Nthɛ yie ghɔ, pugu shi mbɔ ŋgwa haʼaŋ pugu shi nshaʼa vəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ndɔ ä mbɔ ŋa m̀fuʼu pa miŋwɛiŋ pi ni mbhɔ Minnwi, kaŋ yie nōoŋ ŋa Shaʼafuoŋ Minnwi kwo nyīeŋ ti mbara vəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ndɨɨ ŋa ŋgaŋ ghrɨ́ tuo maoŋ nchhɔ̀ pi nthɔ ŋkɛ̄ʼi laʼa yi nɛ, kaŋ maoŋ pi pighɔ pɔ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ndɔ ti ndɨɨ ŋa ŋoŋ ŋa a pɨnɨ mfāʼo ghrɨ́ nchaa vi, nii vi ŋgaʼa vi nɛ, kaŋ a shi ŋkwe maoŋ nchhɔ̀ pi ŋa a yɨʼə noŋ yi ŋkuoŋ ghɔ nɛ, ndɔ̄gɔ maoŋ pi pighɔ ŋgə̄ɨ nɔ ŋgra. ");
INSERT INTO bmo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Shesheŋoŋ ŋa a lɔ mbɔ ŋgei mu nɛ mbɨ̌na a, ŋoŋ ŋa pigi yu lɔ ŋkɨrɨ nu kaʼa nɛ thɔ nshaaŋshaaŋ. ");
INSERT INTO bmo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ndɨɨ ŋa jijwɛ miŋwɛiŋ taoŋ mbɨŋ ŋoŋ nɛ, a nyīeŋ moŋ pa lɨʼɨ yó nthɔ ntāʼa lɨʼɨ fɛrɛ noŋ yi. Ŋga mieŋ ki yəɨ sheshe lɨʼɨ, nchhu ŋa, ‘Ǹshi mbɨnɨ nda mu, lɨʼɨ ŋa mi ni ndhɔ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A ghà mbɨnɨ, njəɨ moŋ nda pi kwo yɨ̄gɨ ndɔ nchwīe a kāʼo. ");
INSERT INTO bmo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A pɨnɨ kiʼɛ ndɔ̄gɔ khwachəɨ pichəɨ jijwɛ ŋa pugu pɨ̄nɨ mbɨgɨ nchaa vi nɛ, pugu pugu thɔ nii ndaʼa nu fɔ, chɔmbhi ŋoŋ ghɔ pɨnɨ mbɨgɨ nchaa nɔ haʼaŋ a ni fǔoŋ mbɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jishɔ ni ŋga nchhu nnu yei, yichəɨ miŋgwɛ shɨna yú ŋgwa pighɔ kə̄rə ŋggì yi nchhu ghɔ ŋa, “Mbɔrɔ yi puŋ yɛ ŋa a phi ghɔ nɛ, pugu pa yi pɨnɨ yɛ ŋa a nuʼɔŋ ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ndɔ a khwɛ̄ ŋa, “Mbɔrɔ ka pɔ pi yi ŋgwa pɛ ŋa pugu yaʼo chrà Minnwi ndɔ nchwīe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nɔ haʼaŋ yú ŋgwa ni mbīgi nu nɛ, a jɛ̄ nchhu nu ŋa, “Ŋgwrɛiŋoŋ yei ŋgwrɛiŋoŋ pɨphɨ, a taʼa lì llɔ mbhɔ Minnwi ndɔ mbaʼa pi nōoŋ kaŋ taʼa lì ni pugu ŋkiɛŋ nnu ghraoghrao Jona. ");
INSERT INTO bmo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wuʼɔ nɔ haʼaŋ Jona ni mbɔ lì ni ŋgwa Nineve nɛ, a wuʼɔ ŋkwaŋ haʼaŋ Muuŋ Ŋoŋmishua shi mbɔ lì ni ŋgwrɛiŋoŋ yei nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Moŋ llɛmbhi sháʼa, Ŋgwafuoŋ Sheba shi ma ntithi pugu pa ŋgwrɛiŋoŋ yei ŋgwɛ̄iŋ vugu nɔ pa ŋgushaʼa nthɛ ŋa a ki nyīeŋ ŋkiɛŋ ntaaŋ ndaoŋ llɔ laʼataoŋ yu nthɔ njwɛrɛ ntɨ́gɨ shiethɔ mbhɔ Fùoŋ Sholomu, ndɔ līi njəɨ, yaoŋ ŋa a chaa Sholomu nɛ pɔ hɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Moŋ llɛmbhi sháʼa, ŋgwa Nineve shi ma ntithi ŋgwɛ̄iŋ vəɨ nɔ pa ŋgushaʼa, nthɛ ŋa pugu ni mbāʼa ŋkǔnu yugu ni phɨ ndɨɨ ŋa Jona ni nshwei chrà Minnwi ni pugu nɛ, ndɔ ti līi njəɨ, yaoŋ ŋa a chaa Jona nɛ pɔ hɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ŋoŋ shiʼa nchuʼu truka ndɔ ndə̄ɨŋ, ki niʼiŋ laʼo mikru, ŋoŋ ghà nchuʼu ntigi pi ŋkuoŋ ntigi, nnɛ ŋa ŋgwa gha nii nu pugu yəɨ líʼɛ. ");
INSERT INTO bmo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ligi yɔ pɔ pi laŋ noŋ yɔ. Ndɨɨ ŋa ɔ yəɨ fàʼa Minnwi mbiŋ shiʼi nɛ ŋguoŋ noŋ yɔ lɨnaoŋ ni líʼɛ. Ndɨɨ ŋa ɔ yaʼo ŋgīʼɛ piŋ nu nɛ, noŋ yɔ lɨnaoŋ ni njiŋnjiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nthɛ yie ghɔ, lɨna nu ŋa kiʼi yaoŋ ŋa ɔ pīʼi ŋa a líʼɛ mbɨŋ ghɔ nɛ pɔ pi njiŋnjiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ti ŋguoŋ noŋ yɔ ndɨnaoŋ pi ni líʼɛ ki yichəɨ ghrà lɔ mbɔ njiŋ, kaŋ ŋguoŋ noŋ yɔ shi ndiʼɛ, wuʼɔ nɔ haʼaŋ truka ghà ndiʼɛ shiʼi ɔ yəɨ ŋguoŋ noŋ yɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jishɔ ni ŋga mīʼɛŋ chrā nu, ŋoŋ Farashi gɛ̄ vi ŋa pugu yu jɨ maoŋ, nnɛ a nii nda nchɔchhɔ nɔ jɨ nu maoŋ pighɔ. ");
INSERT INTO bmo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ŋoŋ Farashi ghɔ ni ŋgrào ndɨɨ ŋa a ni njəɨ Jishɔ jɨ nu ki lɔ njiʼi nshɨ̄gao mbhɔ yi nɔ haʼaŋ nùʼɔŋ yugu ni nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Taathɔ chhu ghɔ ŋa, “Pəɨ Farashi ghà nshɨ̄gao ŋkǔnu ndua pugu pa mikru, ndɔ ndɨnaoŋ ni pɨ̀ga pugu pa mbha nnu pɨphɨ. ");
INSERT INTO bmo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pa na pei! Minnwi ŋa a chwīe ŋkuoŋ yi nɛ, lɔ ŋguʼɔ nchwīe ju nchwīe mooŋ yi? ");
INSERT INTO bmo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ndɔ lɔ̄gɔ maoŋ pɛ ŋa a pɔ moŋ ndua pugu pa mikru nɛ ŋgɛ̄rɛ ghaŋ pou nɔ ghɔ, kaŋ ŋguoŋ yaoŋ shi mbɔ yi taoŋtaoŋ nɔ haʼaŋ nùʼɔŋ yəɨ chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ndɔ ŋgəʼɨ shi ŋgwɛ̄iŋ vəɨ, ma ŋgwa Farashi, nthɛ ŋa pəɨ fɛ shwéi pa mishwrɛi pugu pa laoŋ, ni pa trǔ kru, ndɔ paʼa ndɔ ntuʼɔshə nɔ pɔ nu ŋgwa ndɨndɨ ni ŋgwamishua ndɔ mbɨnɨ ŋkhwā Minnwi. Pəɨ chwīe nnu pei ndɔ ki lɔ mieŋ pichəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ŋgəʼɨ shi ŋgwɛ̄iŋ vəɨ, ma ŋgwa Farashi, nthɛ ŋa pəɨ khwā nɔ chhɔ nu ŋkuoŋ lə̌ɨ pa ŋgwa ndiɛŋ moŋ nda luoŋ Minnwi pugu pa ŋa pi chrā ni pəɨ ni ndighaʼo moŋ pa lɨʼɨ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ŋgəʼɨ shi ŋgwɛ̄iŋ vəɨ, nthɛ ŋa pəɨ pɔ nɔ fúŋ ŋa pi lɔ nūʼɔŋ lì yi, ŋgwa nyīeŋ nu ŋkuoŋ ghɔ ki lɔ nji.” ");
INSERT INTO bmo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yichəɨ taʼa ŋgaŋ yɛʼi ŋgwa ni gɨ́ chhu ghɔ ŋa, “Masha, ɔ ghà ŋga nchhu nɛiŋ ŋgwɛʼi vigi wɛʼi.” ");
INSERT INTO bmo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jishɔ khwɛ̄ ghɔ ŋa, “Ŋgəʼɨ shi ŋgwɛ̄iŋ vəɨ ŋkaa pəɨ, ma ghaŋ yɛʼi ŋgwa ni gɨ́, nthɛ ŋa pəɨ ghà mfrɛ̄i ŋgwa ni lrì ŋa a ghaʼa nɔ tiɛŋ nu, ndɔ paʼa ndɔ mfɛ muuŋshɨmbhɔ yəɨ ŋkaa pəɨ ndrɨ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ŋgəʼɨ shi ŋgwɛ̄iŋ vəɨ, nthɛ ŋa pəɨ ghà ŋkrao pa ŋkiɛŋ fúŋ ni pa njəɨlɨʼɨ Minnwi, nɔ kwiŋ nu vugu, ŋguʼɔ mbɔ pa njəɨlɨʼɨ Minnwi pɛ ŋa tǎa pəɨ ni njwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pəɨ ŋkaa pəɨ nōoŋ nu ŋa pəɨ piŋ nnu ŋa pa tǎa pəɨ ni nchwīe nu nɛ, pugu ni njwi pa njəɨlɨʼɨ Minnwi, pəɨ krao fúŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nthɛ yie ghɔ, shiethɔ Minnwi chhu ŋa, ‘Ǹshi ntaoŋ pa njəɨlɨʼɨ Minnwi pugu pa ghaŋ ntaoŋ, pi jwi pichəɨ ndɔ mfɛ ŋgəʼɨ ni pichəɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Nɛnnɛ chhǐ ŋguoŋ pa njəɨlɨʼɨ Minnwi ŋa pi jwi jɛ̄ ndɨɨ ŋa Minnwi ni mbaʼo mbhi nɛ shi nthi thɔ ŋgwa mbhi shiʼa. ");
INSERT INTO bmo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Llɔ ŋkuoŋ jwi nu Abe ti ŋgə̄ɨ nchəɨŋ ŋkuoŋ jwi nu Shakaria, ŋa pi ni njwi vi shɨna lɨʼɨ fɛʼiŋgiɛŋ pugu lɨʼɨ Taoŋtaoŋ Nda Minnwi nɛ. A yie, ǹchhu ni pəɨ ŋa chhǐ yugu shi nthi thɔ pəɨ. Shishini, pəɨ mbhi shiʼa fāʼo njɔ́ nɔ thɔ yugu ghao. ");
INSERT INTO bmo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ŋgəʼɨ shi nii vəɨ, ma pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi, pəɨ lə̄ɨŋ chuʼɔ nda yɛ ŋa shiethɔ pɔ moŋ ghɔ nɛ, pəɨ ŋkaa pəɨ lɔ njiʼi mbiŋ nɔ nii nu moŋ ghɔ, ndɔ paʼa ndɔ mieŋ ŋgwa ŋa pugu tāʼa nu nii fɔ nɛ ŋa pugu nii.” ");
INSERT INTO bmo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jishɔ ni ŋga ndɔllɔ fɔ, pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa ŋgwa Farashi thɔ ndāa chrà yi ŋkiɛŋ ntou yi, nthɔ mfra vi ni ntou pie ŋa a chrā ntou nnu. ");
INSERT INTO bmo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nnɛ nthɔ ŋkuʼɔ puŋ yi ŋa a chrā nnu ŋa a lɔ njiʼi ŋkāʼo nɛ, pugu wɛ̄iŋ vi. ");
INSERT INTO bmo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ndɨɨ nɔ haʼaŋ pa ŋkaŋŋkaŋ ŋgwa ni ŋkɨrɨ nu taʼa lɨʼɨ nɛ ti pichəɨ kuʼɔ nu mbɨŋ pichəɨ nɛ, Jishɔ fǔoŋ njɛ̄ chrā nu pi ni ghaŋ younjiŋ pi, nchhu nu ŋa, “Pəɨ lɨna yishi pa ŋgwa Farashi mbɔ nnu mifɨɨ. ");
INSERT INTO bmo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yichəɨ yaoŋ lɔ njiʼi mbɔ fɔ ŋa pi pūoŋ ŋa mbaʼa Minnwi mieŋ ki nōoŋ páa. Paʼa yichəɨ nnu lə̄ɨŋ lɔ mbɔ fɔ ŋa mbaʼa pi yiʼi mieŋ ki ji. ");
INSERT INTO bmo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nɛnnɛ, sheshe nnu ŋa ɔ chhu moŋ njíŋ nɛ, pi lɛ njaʼo lɨʼɨ líʼɛ, sheshe nnu ŋa ɔ chūuŋ moŋ njiɛŋ nda nɛ, pi lɛ nchīi mbhi. ");
INSERT INTO bmo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ǹchhu ni pəɨ, ma pa taannu paŋ, kiʼi pəɨ pɔgɔ ŋgwa pɛ ŋa mimfɛ pugu wuʼɔ njwi pi frɛinoŋ ndɔ paʼa ndɔ nuʼuŋ mfāʼo ghrɨ́ nɔ chwīe nu nnu ŋa a pɨgɨ nchaa yie nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ndɔ ǹshi nshwei vəɨ ni ŋoŋ ŋa a pie ŋa pəɨ pɔgɔ vi nɛ, pəɨ pɔgɔ pi ŋoŋ ŋa a pɨnɨ mfāʼo ghrɨ́ nɔ māʼaŋ nu moŋ móŋoŋ ŋgùʼɔ liɛŋ shhɛ ndɨɨ ŋa a kwo jwi nɛ. Pəɨ piŋ nnu ŋa ǹchhu ni pəɨ nɛ, a ju mbɔ ŋoŋ ŋa a pie ŋa pəɨ pɔgɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Pi shiʼa fīni tiɛŋ puoŋ milunu pi wuʼɔ ni paa puoŋ mi mbɨŋ? Ndɔ ti Minnwi shiʼa ndīʼɛ kaŋ taʼa yi shɨna pugu. ");
INSERT INTO bmo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kiʼi mfāʼo pɔgɔ gu, ɔ ghaʼo mbhɔ Minnwi nchaa ntou milunu. Minnwi shia ŋguoŋ ŋgiithɔ yɔ ghao. ");
INSERT INTO bmo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ndɔ ǹshwei vəɨ ŋa shesheŋoŋ ŋa a chhu shhɨ ŋgwamishua ŋa a nyaŋ nɛ, Muuŋ Ŋoŋmishua shi nchhu ŋkaa yu ŋa a ji shhɨ pa ghaŋ ntaoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ndɔ shesheŋoŋ ŋa a lāa a shhɨ ŋgwamishua nɛ, Muuŋ Ŋoŋmishua shi ndāa vi shhɨ ghaŋ ntaoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Shesheŋoŋ ŋa a shi nchhu nnu pɨphɨ nɔ ligi Muuŋ Ŋoŋmishua nɛ, Minnwi shi ndīʼɛ phɨ yi, ndɔ ti shesheŋoŋ ŋa a shi ŋgwɛʼi Jijwɛ Minnwi nɛ, mbaʼa Minnwi līʼɛ phɨ yi. ");
INSERT INTO bmo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ndɨɨ ŋa pi lɔ̄gɔ ghɔ ŋgə̄ɨ nɔ nda luoŋ Minnwi ki shhɨ ghaŋ sháʼa, ki shhɨ pa mɛmmɛ ŋgwa nɛ, kiʼi ŋgwie noŋ yɔ ni nnu ŋa ɔ shi nchhu nɛ ki ŋkwaŋ haʼaŋ ɔ shi ntaa noŋ yɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nthɛ ŋa Jijwɛ Minnwi shi ntɨgɨ ghɔ ndɨɨ ghɔ ni nnu ŋa a kāʼo ŋa ɔ chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yichəɨ ŋoŋ moŋ kɨrɨ ŋgwa pighɔ chhu ni Jishɔ ŋa, “Masha, chhu ni ndǐŋ a ŋa a ghrā maoŋ pɛ ŋa tǎa mieŋ ni pigi nɛ, mfɛ nyaŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jishɔ khwɛ̄ ghɔ ŋa, “Taannu a, a nūʼɔŋ gɔ̌ nūʼɔŋ a nɔ ŋgaŋ shaʼa sháʼa ki ŋgaŋ ghrā maoŋ shɨna pəɨ ndǐŋ ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jishɔ chhu ni pugu ŋa, “Pəɨ ywɛrɛ thɔ yəɨ, nthɔ ndɨna nu ŋa kiʼi pəɨ fāʼo sheshe ŋkwaŋ pɨ̀ga nthɛ ŋa chɔmbhi ŋoŋ lɔ njiʼi mbɔ pi moŋ ntou maoŋ ŋa a fāʼo nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jishɔ shwei yei luʼɔ chrà ni pugu: “Ŋgaŋ fàʼo chəɨ ni mbɔ fɔ, maoŋ pwa moŋ nyìeŋ yu ŋgaʼa. ");
INSERT INTO bmo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A pīʼi nu moŋ njùʼɔ yu ŋa, ‘Mi shi nchwīe pi nɛiŋ yo? Nthɛ ŋa ǹdɔ mfāʼo lɨʼɨ ŋa minthɛ ǹūʼɔŋ ŋguoŋ maoŋ paŋ pei fɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nɛnnɛ a chhu ŋa, ‘Yei nnu ŋa ǹshi nchwīe nɛ, ǹshi mbɨnɨ nshāʼa lɨʼɨ nūʼɔŋ maoŋ paŋ, ŋkrao pi nduoŋ mbɔ pi ghaʼoghaʼo, nūʼɔŋ maoŋ jɨ paŋ pugu pa pichəɨ maoŋ paŋ moŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nchhu ni noŋ a ŋa, “Mbrɔthɔ ŋoŋ! Ɔ fāʼo ŋguoŋ maoŋ shiʼi ŋa a pie ŋa ɔ fāʼo nɔ ntou ŋgaʼo nɛ, fɛrɛ noŋ yɔ, njɨ, nnu, mfāʼo pwanjuʼɔ.” ’ ” ");
INSERT INTO bmo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ndɔ Minnwi chhu ghɔ ŋa, ‘Yaoŋ na yei! Ni tuʼu yei ǹshi ŋkwe chɔmbhi yɔ. A shi ŋga mbɔ nɛnnɛ, maoŋ pinɛ ŋa ɔ kɨrɨ nɛ pɔ yi gɔ̌?’ ” ");
INSERT INTO bmo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jishɔ lūgwi ŋa, “Yei ŋkwaŋ haʼaŋ a shi mbɔ ni ŋgwa pɛ ŋa pugu kɨrɨ fāʼo ni noŋ pugu ki lɔ mfāʼo ligi Minnwi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jishɔ chhu ni ghaŋ younjiŋ pi ŋa, “Nthɛ yie ghɔ, ǹshwei vəɨ ŋa kiʼi pəɨ wie noŋ yəɨ nthɛ chɔmbhi yəɨ, ŋa pəɨ shi njɨ pi khɔ ki nthɛ ŋgrào noŋ yəɨ, ŋa pəɨ shi māʼaŋ pi khɔ. ");
INSERT INTO bmo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nthɛ ŋa chɔmbhi chaa maoŋ jɨ, noŋ yɔ chaa ndhwí. ");
INSERT INTO bmo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pīʼi mbɨŋ pa mishi, pugu shiʼa mbhi, ndɔ paʼa ndɔ ŋkwōo, paʼa ndɔ mfāʼo shaoŋ ki lɨʼɨ nūʼɔŋ maoŋ, ndɔ Minnwi kugwi vugu ghao. Ndɔ ɔ ghaʼo mbhɔ Minnwi nchaa pa mishi. ");
INSERT INTO bmo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Minthɛ shesheŋoŋ vəɨ pɨnɨ mbīgi chɔmbhi yi wuʼɔ shɨgɛi nthɛ ŋa a wie noŋ yi? ");
INSERT INTO bmo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ŋa mimfɛ paʼa ɔ lɔ njiʼi nchwīe muuŋ mi nnu nɔ yinɛ nɛ, ɔ nuʼuŋ ŋgwie noŋ yɔ ni pichəɨ pa nnu nthɛ khɔ? ");
INSERT INTO bmo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pīʼi mbɨŋ pa frawa ŋkwaŋ haʼaŋ pugu ghà ŋkuʼɔ nɛ, pugu shiʼa mfāʼa ndɔ paʼa ndɔ ntuŋ ndhwí, ndɔ ǹshwei ghɔ ŋa njiʼi nthɛ pi Sholomu moŋ ŋguoŋ ndighaʼo yi ghao shini ndɔ mbwa ti mbɔ nɔ taʼa frawa. ");
INSERT INTO bmo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ti M̈innwi māʼaŋ fɨʼɨ ndìpwa yei mbɨŋ pa trǔ ŋa a yi maoŋ shiʼa, yua gha mbɔ nu a kwo yaoŋ ti pi tūoŋ nɛ, pəɨ pīʼi ŋa a shi ndɨna ni pəɨ pi fɨʼɨ yi nɛiŋ? Ŋgwa piŋ kikɛʼi pei! ");
INSERT INTO bmo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nɛnnɛ kiʼi pəɨ wuʼɔ nthɔ ŋgwie noŋ yəɨ pi lɨʼɨ taʼa yaoŋ ŋa pəɨ shi njɨ ki nnu nɛ, ki mfāʼo ghaghana moŋ njùʼɔ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pa ghaŋ ki piŋ Minnwi ŋkuoŋ mbhi yei thɔ ntei pi njiŋ maoŋ pei, ndɔ ni pəɨ, Minnwi Tǎa vəɨ ji ŋa a pie ŋa pəɨ fāʼo maoŋ pei. ");
INSERT INTO bmo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pəɨ ka shigi pi Shaʼafuoŋ Minnwi moŋ chɔmbhi yəɨ, nɛnnɛ kaŋ Minnwi shi mfɛ ŋguoŋ maoŋ pei ghao ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Njiʼi nthɛ nɔ haʼaŋ pəɨ, ghaŋ younjiŋ paŋ pɔ pi shɨgɛi nɔ muuŋ kwíe minjɨɨ nɛ, kiʼi pəɨ fāʼo pɔgɔ gu ŋa mbaʼa pəɨ yiʼi mfāʼo yaoŋ ŋa a pie ŋa pəɨ yru ŋkuoŋ ghɔ nɛ, nthɛ ŋa Tǎa vəɨ Minnwi lɔ̄gɔ nthi Mi moŋ khwǎ njùʼɔ yi ŋa pəɨ pugu shi nshaʼa fùoŋ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Pəɨ fīni maoŋ pəɨ, mfɛ mbɨŋ ghɔ ni ghaŋ pou, mbaʼo nɔ fāʼo nu pìɛŋ mbɨŋ ŋa mbaʼa a yiʼi mbɨrɨ nɛ, pugu pa fàʼo po ŋa mbaʼa a ma mmɛ, lɨʼɨ ŋa mbaʼa ŋgɨna chəɨŋ fɔ, ndɔ mbaʼa shə́ʼɨ kru. ");
INSERT INTO bmo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nthɛ ŋa lɨʼɨ ŋa fàʼo yɔ pɔ nɛ, a lɨʼɨ ŋa njùʼɔ yɔ shi mbɔ ŋkaa yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Pəɨ pīri noŋ yəɨ ni sheshe nnu ŋa a shi nthɔ nɛ, ŋkrao ŋkandaŋ yəɨ a tɨnɨ, nchuʼu laŋ yəɨ a kɨɨ nu, ");
INSERT INTO bmo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nɔ ŋgwa ŋa pugu ywɛrɛ taathɔ vugu a kwəɨ lɨʼɨ jɨ láŋ, nɛnnɛ ŋa a shi ŋga ŋkwəɨ ŋkwēi nda, pugu kiʼi nchuʼɔ chuʼɔ taʼa ŋgɛ. ");
INSERT INTO bmo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pwatua pɔ ni pɛ puoŋ fàʼa ŋa taathɔ vugu kwəɨ njəɨ vugu pugu wuʼɔ mbiʼi tɔthɨ nɛ. Shishini, ǹshwei vəɨ, a shi mbīri noŋ yi nshwei vugu ŋa pugu chhɔ ŋkuoŋ taprɛi, a thɔ ŋgrā maoŋ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pwatua shi mbɔ ni puoŋ fàʼa pɛ ŋa taathɔ vugu gha njəɨ vugu pugu kwo pīri noŋ yugu nɔ sheshe ndɨɨ ŋa a shi nthɔ nɛ. Ki a thɔ pi moŋ ntuŋ mbhi, ki ni ndaʼambilaŋ. ");
INSERT INTO bmo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ndɔ mimfɛ ɔ fāʼo tɨnɨnjuʼɔ ŋa ŋ̈gaŋ nda kaŋ nji ndɨɨ ŋa ŋgɨna shi nthɔ nɛ, a shi kaŋ ndɔ mieŋ nda yi a pəʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pəɨ ŋkaa pəɨ pīri noŋ yəɨ, nthɛ ŋa Muuŋ Ŋoŋmishua thɔ nu moŋ ndɨɨ ŋa mbaʼa pəɨ yiʼi mbīʼi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita pie ŋa, “Taathɔ, ɔ chrā yei luʼɔ chrà pi ni pigi ki ni ŋguoŋ ŋgwa?” ");
INSERT INTO bmo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Taathɔ khwɛ̄ ŋa, “A gɔ̌ kiʼɛ mbɔ muuŋ fàʼa tithi ndɔ mfāʼo shiethɔ, ŋa taathɔ shi nūʼɔŋ vi a lɨna nu ni nda yi ndɔ ŋgrā maoŋ jɨ ni pichəɨ ghaŋ fàʼa ndɨɨ ŋa ndɨɨ kāʼo nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mbɔrɔ shi mbɔ ni muuŋ fàʼa yɛ ŋa masha vi yəɨ vi a thɔ fāʼa nu shiʼi ndɨɨ ŋa a thɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Shishini, ǹshwei vəɨ, a shi nūʼɔŋ vi a thɔ ndɨna ju ni ŋguoŋ maoŋ pi. ");
INSERT INTO bmo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ndɔ ti m̈uuŋ fàʼa ghɔ mbīʼi moŋ njùʼɔ yu ŋa mbaʼa taathɔ vi yīʼɛ mbɨnɨ, nchhɔ ŋgwie pichəɨ ghaŋ fàʼa, mbɔ pi pimbia pugu pa pi piŋgɛ, nthɔ njɨ maoŋ ndɔ nnu mbaa nu, ");
INSERT INTO bmo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kaŋ taathɔ vi shi nɛ ŋkwəɨ pi llɛ́ yɛ ŋa a shi lɔ mbīʼi nɛ pugu pa ndɨɨ ŋa a shi lɔ nji nɛ, ndɔ nchrɛi vi kaoŋkaoŋ. A yəɨ ŋkwaŋ ŋgəʼɨ ghaŋ fàʼa mbe. ");
INSERT INTO bmo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ŋgaŋ fàʼa ŋa a ji nnu ŋa taathɔ vi tāʼa nu ŋa a chwīe nɛ, ki lɔ njiʼi mbīri noŋ yi, ki nchwīe nnu ghɔ ŋa taathɔ vi tāʼa nu nɛ, shi mfāʼo ŋkiɛŋ tɨtɨnɨ wie. ");
INSERT INTO bmo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ndɔ ti ŋoŋ ŋa a shini ndɔ nji, ndɔ nchwīe nnu ŋa a pie wie nɛ, shi ŋkwe shɨgɛi wie. Ŋoŋ ŋa pi fɛ ntou yi ghɔ nɛ, pi shi mbie ntou yi mbhɔ yu. Ndɔ ŋoŋ ŋa pi fɛ ŋkiɛŋ ntou yi ghɔ nɛ, pi shi mbie vi pi ni ŋkiɛŋ ntou yi. ");
INSERT INTO bmo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ŋki thɔ pi nɔ māʼaŋ nu móŋoŋ ŋkuoŋ mbhi, ǹjūa ŋa a kaŋ ni ŋkwo kɨɨ nu. ");
INSERT INTO bmo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ndɔ, m̀fāʼo kwe ŋkhǐ nɔ tɔgɔ nu moŋ ghɔ, mbɔ ŋgəʼɨ pugu pa gu. M̀fāʼo yuʼɔ njùʼɔ ti a shi nthɔ ntɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pəɨ pīʼi ŋa ǹthɔ pi nɔ fɛ nu taʼaŋggi ŋkuoŋ mbhi hɛiŋ? Ŋga, ǹthɔ pi ni minduoŋnduoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nthɛ ŋa jɛ̄ ndwɛ ŋgə̄ɨ nu shhɨ, moŋ nda ŋa tiɛŋ ŋgwa pɔ fɔ nɛ, pugu shi nchhɔ kikie, trɛi ŋgwa pɔ ni taʼa kwò, pi paa pɔ ni taʼa kwò. ");
INSERT INTO bmo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pugu shi nthi pi nduoŋnduoŋ, tǎa pugu muuŋ vi yi mimbia pɔ kikie, maa pugu muuŋ vi yi miŋgwɛ pɔ kikie, maŋgaoŋ pugu ŋgwɛ muuŋ vi chhɔ kikie, ŋgwɛ muuŋ chhɔ kikie pugu maŋgaoŋ vi.” ");
INSERT INTO bmo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jishɔ pɨnɨ nchhu ni yú ŋgwa pighɔ ŋa, “Ndɨɨ ŋa pəɨ yəɨ mbɨ̀ kuʼɔ nu ŋgei nii minaoŋ nɛ, pəɨ kiʼi nchuchu taʼa ŋgɛ́ ŋa, ‘Mbɨ̀ shi ndhɔ.’ Ndɔ a wuʼɔ mbɔ pi nɛnnɛ. ");
INSERT INTO bmo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ndɨɨ ŋa pəɨ yəɨ fɨfrəɨ laoŋ llɔ mbiɛŋ nɛ, pəɨ kiʼi nchuchu ŋa, ‘Minaoŋ shi ntūoŋ.’ Ndɔ a wuʼɔ mbɔ pi nɛnnɛ. ");
INSERT INTO bmo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pa ŋgwa mifɨɨ pei, mimfɛ pəɨ līi ŋkwaŋ haʼaŋ po pugu shhɛ pɔ nɛ nchhu ŋkwaŋ haʼaŋ yie llɛmbhi shi mbɔ nɛ, ti a chwīe khɔ paʼa pəɨ lɔ nji njiŋ pa nnu ŋa a thɔ ndɔ̄gɔ lɨʼɨ ndwɛ nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“A chwīe khɔ paʼa ɔ lɔ mbīʼi ni noŋ yɔ nnu ŋa a kāʼo nɛ ndɔ nchwīe? ");
INSERT INTO bmo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nɔ haʼaŋ ɔ ghə̄ɨ nu pəɨ ŋoŋ haʼaŋ a puru ghɔ shhɨ ŋgaŋ sháʼa nɛ, kāa nɔ lūgwi nu pəɨ yu shɛndaoŋ. Ɔ̈ mieŋ ki chwīe nɛnnɛ, kaŋ a shi ndɔ̄gɔ ghɔ ŋgə̄ɨ nɔ shhɨ ŋgaŋ sháʼa mfɛ ghɔ ni pa brushi, pugu niʼiŋ ghɔ chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ǹshwei ghɔ, mbaʼa ɔ ma ntaoŋ ki lɔ naa mbe ŋguoŋ njɔ́ yɔ ghao.” ");
INSERT INTO bmo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pichəɨ pa ŋgwa ni mbɔ fɔ ndɨɨ ghɔ ŋa pugu ni nshwei Jishɔ ŋkwaŋ haʼaŋ Pailɛ ni njwi pichəɨ ŋgwa Galili ndɨɨ ŋa pugu thɔ fɛ yaoŋ fɛʼiŋgiɛŋ ni Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jishɔ khwɛ̄ ni pugu ŋa, “Pəɨ pīʼi ŋa ŋgwa Galili pei chwīe phɨ nchaa ŋguoŋ ŋgwa Galili nduoŋ nthɛ ŋa pi jwi vugu nnɛ nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ǹshwei vəɨ ŋa ŋga! Ndɔ ti p̈əɨ mieŋ ki pāʼa ŋkǔnu yəɨ ni phɨ kaŋ pəɨ shi ŋkhu ghao ŋkaa pəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ki pəɨ pīʼi ŋa fuoŋnchrɔ ŋgwa laʼataoŋ Shiloaŋ, ŋa nda tɔthɨ ni ŋgū njwi vugu nɛ, ni mbɔ pi pa ŋgwo nnu mbɨmbhɨ nchaa ŋguoŋ pa ŋgwa ŋa pugu ni nchhɔ Jerushalɛiŋ nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ǹshwei vəɨ ŋa ŋga! Ndɔ ti p̈əɨ mieŋ ki pāʼa ŋkǔnu yəɨ ni phɨ, kaŋ pəɨ ghao shi ŋkhu ŋkaa pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jishɔ chhu yei luʼɔ chrà ni pa ghaŋ younjiŋ pi: “Yichəɨ ŋoŋ ni mbhi wùnu moŋ nyìeŋ yu, nthɔ lɨʼɨ ka ntíɛŋ ŋkuoŋ ghɔ paʼa a lɔ mbɔ. ");
INSERT INTO bmo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nnɛ, a chhu ni ŋgaŋ fàʼa yi ŋa, ‘Līi njəɨ, nɔ trɛi ŋgaʼo ǹthɔ nthɔ nu hɛiŋ nɔ thɔ nu ntāʼa ntíɛŋ thɨ ndɔ paʼa ndɔ njəɨ sheshe yi. Kəʼɨ māʼaŋ shhɛ, kiʼi a nuʼuŋ nthɔ njɨ shhɛ gha.’ ");
INSERT INTO bmo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Muuŋ fàʼa yi ghɔ khwɛ̄ ghɔ ŋa, ‘Taathɔ, pɨnɨ mieŋ fɔ nɔ taʼa ŋgaʼo, ntou laʼo yi niʼiŋ khí fɔ. ");
INSERT INTO bmo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ti ä njuŋ ntíɛŋ ŋgaʼo yini, a pwa, ti ä nchhɔ ki yuŋ, ɔ kəʼɨ vi māʼaŋ shhɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yichəɨ taʼa Llɛ́ Ji pa Juu ni mbɔ, Jishɔ thɔ njɛʼi nu moŋ nda luoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ŋga njəɨ nu, yichəɨ miŋgwɛ chəɨŋ fɔ, mfāʼo jijwɛ pɨphɨ ŋa a ni nchwīe a ghɨ̄nɔ nu nɔ fuoŋnchrɔ ŋgaʼo. A ni ntuʼutuʼu, ti mimfɛ paʼa a lɔ ntithi tɔthɨ ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jishɔ gha njəɨ vi, mɛ̄iŋ vi, nchhu ghɔ ŋa, “Miŋgwɛ, ɔ lūgu moŋ ghɨ̌nɔ yɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nūʼɔŋ mbhɔ mi mbɨŋ yu, a pɨʼɨ ntithi ndɨndɨ chomilaoŋ ghɔ, ŋgaʼo Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mmɛŋoŋ moŋ nda luoŋ Minnwi pɨgɨtua ŋa Jishɔ yɨ̄gɨ ghɨ̌nɔ Llɛ́ Ji. Nchhu ni pa ŋgwa ŋa, “Pi fāʼo nɔ fāʼa nu nɔ ntɨgao llɛmbhi, nthɛ yie ghɔ, p̂əɨ thɔ pi moŋ shɨna llɛ́ pighɔ pi yɨ̄gɨ ghɨ̌nɔ yəɨ, kiʼi a pɔ pi Llɛ́ Ji.” ");
INSERT INTO bmo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Taathɔ khwɛ̄ ghɔ ŋa, “Ghaŋ mifɨɨ pei, shesheŋoŋ shɨna pəɨ shiʼa mfēi fua yi pugu ŋkwɛ́iŋ yi moŋ nda ŋa pugu ghà ndaʼa nɛ, ŋgə̄ɨ ni ju choŋkhi mfɛ ŋkhǐ ghɔ Llɛ́ Ji? ");
INSERT INTO bmo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ti ndwɛ, m̀baʼa ŋkwe miŋgwɛ vei Llɛ́ Ji, muuŋ Abrahaŋ, ŋa Shata ŋkrao vi nɔ fuoŋnchrɔ ŋgaʼo nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A ni ŋga nchhu nnu yei, lrithɔ wɛ̄iŋ pa mbɨ̌na pi, ndɔ ŋguoŋ pichəɨ pa ŋgwa nduoŋ fāʼo pwanjuʼɔ nthɛ ŋguoŋ pa mɛmmɛ nnu ŋa a chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nɛnnɛ Jishɔ pie ŋa, “Shaʼafuoŋ Minnwi pɔ pi nɔ khɔ? Mimfɛ m̀āʼaŋ fɨʼɨ yi pi ni khɔ? ");
INSERT INTO bmo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","A pɔ pi nɔ mbhɛ̌ yaoŋ mbɔ ŋkiɛŋ yi gɛ, ŋa ŋoŋ lɔ̄gɔ ŋgə̄ɨ māʼaŋ moŋ nyìeŋ yu, a kuʼɔ ŋgū thɨ, pa mishi thɔ ŋkrao nda pugu ŋkuoŋ pa mbhɔ pi.” ");
INSERT INTO bmo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A pɨnɨ nuʼuŋ mbie ŋa, “Mimfɛ m̀āʼaŋ fɨʼɨ nɔ Shaʼafuoŋ Minnwi pi ni khɔ? ");
INSERT INTO bmo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A pɔ pi nɔ yaoŋ chwīe prupɨna kuʼɔ haʼaŋ miŋgwɛ lɔ̄gɔ niʼiŋ moŋ taʼa brumaʼa prupɨna, a chwīe ŋguoŋ prupɨna ghɔ kuʼɔ ghao.” ");
INSERT INTO bmo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jishɔ ni nyīeŋ ntɔgɔ moŋ pa mɛmmɛ laʼataoŋ pugu pa puoŋ mi puoŋ pi, nthɔ njɛʼi nu nɔ haʼaŋ a ni ntɔgɔ ŋgə̄ɨ nu Jerushalɛiŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yichəɨ ŋoŋ pie vi ŋa, “Taathɔ, a wuʼɔ shɨgɛi ŋgwa haʼaŋ pugu shi ndūgu?” Jishɔ chhu ghɔ ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ǹshwei vəɨ, pəɨ paʼo nɔ nii nu pi moŋ muuŋ chonda, nthɛ ŋa ntou ŋgwa shi mbaʼo nɔ nii nu ndɔ a ghaʼa vugu. ");
INSERT INTO bmo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ndɨɨ ŋa ŋgaŋ nda shi nuʼuŋ ndɔllɔ mfɨ̄nɨ chonda nɛ, pəɨ tithi mbhi nthɔ ŋkwēi chonda, nchhu nu ŋa, ‘Taathɔ, chuʼɔ chonda ni pigi.’ A shi ŋkhwɛ̄ nchhu ni pəɨ ŋa, ‘Ǹdɔ njiʼi nji vəɨ ki lɨʼɨ haʼaŋ pəɨ llɔ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nɛnnɛ, pəɨ shi nchhu ŋa, ‘Pia ni njɨ ndɔ nnu kaʼa, ndɔ ɔ ni njɛʼi shɛndaoŋ laʼataoŋ pigi.’ ");
INSERT INTO bmo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ndɔ a shi nchhu ni pəɨ ŋa, ‘Ǹdɔ njiʼi nji vəɨ ki lɨʼɨ haʼaŋ pəɨ llɔ nɛ. Pəɨ lɔllɔ, ŋguoŋ vəɨ pa ŋgūo nnu mbɨmbhɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Pəɨ shi ŋkə̄ɨ ndɔ ŋkru shua məɨ fɔ ndɨɨ ŋa pəɨ yəɨ Abrahaŋ, ni Aiji, ni Jakɔ, ni ŋguoŋ pa njəɨlɨʼɨ Minnwi, pugu pɔ moŋ ntuʼɔ fùoŋ Minnwi ndɔ, pi māʼaŋ vəɨ mbhi. ");
INSERT INTO bmo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ŋgwa shi ma ndhɔ ŋgei laʼataoŋ shaʼa minaoŋ, ni yi ŋgei nii minaoŋ pi ma ndhɔ khwi pugu pa mbiɛŋ, nchhɔ yəɨ taprɛi moŋ ntuʼɔ fùoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Līi njəɨ, pichəɨ pa ŋgwa ŋa pugu pɔ ndugwi njiŋ nɛ ma mbɔ shhɨ, pichəɨ ŋa pugu pɔ shhɨ lūgwi njiŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wuʼɔ ndɨɨ ghɔ, pichəɨ pa ŋgwa Farashi thɔ mbara Jishɔ nchhu ghɔ ŋa, “Kwiɛŋ ŋkiʼɛ ŋgəɨghəɨ, nthɛ ŋa Hɛrɔ tāʼa nu njwi ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jishɔ khwɛ̄ ni pugu ŋa, “Ghə̄ɨ nshwei mimbaaŋguo ghɔ fɛ a nɔ ghɔ ŋa ǹthɔ nɛ mfuʼu pa miŋwɛiŋ ndɔ njɨ̄gɨ pa ghɨ̌nɔ shiʼa pugu pa yua, ndɔ a gha mbɔ moŋ trɛi llɛ́ m̀īʼɛŋ fàʼa a. ");
INSERT INTO bmo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ndɔ a kāʼo vəɨ ŋa shiʼa, ni yua, pugu pa yua vini, m̀bɔ shɛndaoŋ ŋgə̄ɨ nu, nthɛ ŋa mimfɛ paʼa pi lɔ njwi njəɨlɨʼɨ Minnwi ki a lɔ mbɔ pi Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerushalɛiŋ, Jerushalɛiŋ, laʼataoŋ ŋa pugu jwi pa njəɨlɨʼɨ Minnwi ndɔ ntuŋ pa ŋgwa ŋa pi taoŋ vugu vɛ nɛ ni ŋgùʼɔ, a ŋgɛ́ yi khɔ ŋa ǹtāʼa nu ŋkɨrɨ puoŋ pɔ taʼa lɨʼɨ ŋkwaŋ haʼaŋ miŋguo ghà ŋkɨrɨ puoŋ pi laʼo prǎ yi nɛ, ndɔ paʼa ɔ lɔ ntāʼa nu. ");
INSERT INTO bmo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Līi njəɨ, nda yəɨ kɨna ŋkuʼɔ fùŋ. Ndɔ ǹchhu ni pəɨ ŋa mbaʼa pəɨ nuʼuŋ njəɨ a, kaŋ a nɛiŋ ndɨɨ thɔ ŋa pəɨ shi nchhu ŋa, ‘Mbɔrɔ pɔ ni ŋoŋ ŋa a thɔ nɔ ligi Taathɔ nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yichəɨ Llɛ́ Ji ni mbɔ, Jishɔ ghə̄ɨ nda yichəɨ nthishɨ pa ŋgwa Farashi lɨʼɨ jɨ maoŋ, pa ŋgwa thɔ mbɛʼi vi. ");
INSERT INTO bmo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ŋga njəɨ nu, yichəɨ ŋoŋ ŋa a ni mfāʼo ghɨ̌nɔ mikuʼɔ kwò pugu pa mbhɔ chəɨŋ. ");
INSERT INTO bmo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jishɔ pie ni pa ghaŋ yɛʼi ŋgwa ni gɨ́ pugu pa ŋgwa Farashi ŋa, “Gɨ́ piŋ ŋa pi yɨ̄gɨ ghɨ̌nɔ ŋoŋ Llɛ́ Ji ki ŋga?” ");
INSERT INTO bmo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Paʼa pugu lɔ ŋkhwɛ̄, Jishɔ lɔ̄gɔ ŋgaŋ ghɨ̌nɔ ghɔ njɨ̄gɨ ghɨ̌nɔ yi mieŋ vi kiʼɛ ŋa a ghə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nɛnnɛ a chhu ni pugu ŋa, “A yəɨ ŋoŋ shɨna pəɨ ŋa m̈uuŋ vi ki fua yi ŋgū moŋ tiɛŋ ŋkhǐ shishhi, paʼa a lɔ ŋkiʼi nshūu vi shūu mfuʼu Llɛ́ Ji?” ");
INSERT INTO bmo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pugu pou khwɛ̀. ");
INSERT INTO bmo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jishɔ jɛ̄ nthɔ nchrā luʼɔ chrà ni pa ghaŋ gɛ̀ pi ndɨɨ ŋa a yəɨ ŋkwaŋ nɔ haʼaŋ pugu chhɔ ntɛrɛ pa lɨʼɨ liɛŋ yəɨ taprɛi nɛ, nchhu nu ni pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ndɨɨ ŋa pi gɛ̄ ghɔ lɨʼɨ jɨ láŋ nɛ, kiʼi ndɔ̄gɔ lɨʼɨ liɛŋ, nthɛ ŋa kəʼɨchəɨ pi gɛ̄ ŋoŋ ŋa a chɨ̄ɨ nchaa ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nnɛ ŋa ŋoŋ ŋa a gɛ̄ vəɨ nɛ shi nthɔ nchhu vɛ ŋa, ‘Fɛ lɨʼɨ yɔ ni ŋoŋ vei!’, kaŋ ɔ shi ŋgə̄ɨ kiʼɛ moŋ shhunoŋ ndɔ̄gɔ ndugwi njiŋ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ndɔ ndɨɨ ŋa pi gɛ̄ ghɔ lɨʼɨ nɛ, ghə̄ɨ nchhɔ nɔ ndugwi njiŋ lɨʼɨ, nɛnnɛ ŋa ndɨɨ ŋa ŋoŋ vɛ ŋa a gɛ̄ ghɔ thɔ nɛ, kəʼɨchəɨ a chhu vɛ ŋa, ‘Taannu a, kuʼɔ nɔ lɨʼɨ liɛŋ’. Nɛnnɛ ɔ shi nchɨɨ ligi ŋguoŋ pa ŋgwa ŋa pəɨ pugu pɔ ŋkuoŋ taprɛi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nthɛ ŋa shesheŋoŋ ŋa a kə̄rə noŋ yi nɛ, pi shi nshwiʼi vi shhɛ. Shesheŋoŋ ŋa a shwiʼi noŋ yi shhɛ nɛ, pi shi ŋkə̄rə vi tɔthɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jishɔ chhu ni ŋoŋ ghɔ ŋkaa yu ŋa a ni ŋgɛ̄ vi nɛ ŋa, “Ndɨɨ ŋa ɔ pīri ŋkiɛŋ maoŋ jɨ nɛ, kiʼi mɛ̄iŋ pi taannu pɔ, ki lǐŋ pɔ, ki ndaaŋoŋ yɔ, ki taakuo pɔ, mbɔ ghaŋ fàʼo, nthɛ ŋa pugu shi ma ŋgɛ̄ ghɔ ŋkaa pugu nnɛ a pɔ ŋa ɔ kwo fāʼo pe yɔ ni nnu ŋa ɔ ni nchwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ndɨɨ ŋa ɔ pīri jɨ nɛ, gɛ̄ pi pa mbou, pa ŋkwíni, pa nchriligi, ");
INSERT INTO bmo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nnɛ, kaŋ ɔ shi mfāʼo mbɔrɔ nthɛ ŋa mimfɛ paʼa pugu lɔ ma nduʼu vɛ. Minnwi shi nduʼu shiʼi yɔ ndɨɨ ŋa pa ŋgwa shiʼi lɛ ŋkuʼɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ndɨɨ ŋa yichəɨ taʼa ŋgaŋ gɛ̀ ŋa a ni nchhɔ ŋkuoŋ taprɛi ni njaʼo yei nnu nɛ, nchhu ni Jishɔ ŋa, “A fɨʼɨ pwatua nɛiŋ ni ŋoŋ ŋa a shi mbɔ ŋgia jɨ moŋ ntuʼɔ fùoŋ Minnwi?” ");
INSERT INTO bmo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jishɔ khwɛ̄ ŋa, “Yichəɨ ŋoŋ ni ma mbīri mmɛ jɨ ŋgɛ̄ ntou ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ndɨɨ jɨ ghɔ ni ŋga ŋkāʼo, a taoŋ muuŋ fàʼa vi ŋa a chhu ni ghaŋ gɛ̀ pi ŋa, ‘Pəɨ thɔ, ŋguoŋ yaoŋ kwo kāʼo!’ ");
INSERT INTO bmo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ŋguoŋ yugu ghao jɛ̄ nthɔ njūa shwieshwie. Fǔoŋ yi chhu ni muuŋ fàʼa ghɔ ŋa, ‘Ǹjuoŋ shhɛ, a pie ŋa ŋ̀guʼɔ ŋgə̄ɨ njəɨ, m̀baʼo mbhɔ ŋa a mieŋ a ǹduʼu.’ ");
INSERT INTO bmo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yichəɨ chhu ji ŋa, ‘Ŋ̀kwo yuoŋ wuŋ fua fāʼa nyìeŋ ŋgə̄ɨ nu lɨʼɨ ywɛʼi vugu, nthɛ yie ghɔ, ǹduoŋ ŋa a līʼɛ fàŋ a.’ ");
INSERT INTO bmo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Vichəɨ chhu ji ŋa, ‘Ŋ̀guʼɔ ŋka laŋlaŋ. Nthɛ yie ghɔ, minthɛ paʼa ǹdɔ nthɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Muuŋ fàʼa ghɔ pɨ̄nɨ nshwei taathɔ vi ni pa nnu pei. Ŋgaŋ nda ghɔ chhu ni muuŋ fàʼa vi ghɔ moŋ pɨgɨtua ŋa, ‘Taoŋ ŋgə̄ɨ moŋ pa laʼa, pugu pa fra, nchhu ni pa ghaŋ pou, pa ŋkwíni, pa nchriligi ŋa pugu thɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","A gha ndara muuŋ fàʼa ghɔ chhu ŋa, ‘Taathɔ, ŋ̀kwo fāʼa ŋkwaŋ haʼaŋ ɔ chhu nɛ, ndɔ shɨna wuʼɔ mbiʼi ni pichəɨ ŋgwa moŋ nda.’ ");
INSERT INTO bmo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nɛnnɛ, taathɔ pɨnɨ nchhu ghɔ ŋa, ‘Taoŋ ŋgə̄ɨ shɛndaoŋ ntou, pugu pa ndaoŋ mooŋ trǔ, nɨŋɨ ŋa ŋgwa thɔ nii nnɛ ŋa nda a lɨnaoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ndɔ ǹshwei vəɨ, mbaʼa kaŋ taʼa ŋoŋ ŋa mi ni ŋgɛ̄ vugu nɛ ywɛʼi sheshe yaoŋ jɨ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndwɛ, yú ŋgwa ni nthɔ njōu njiŋ Jishɔ, a kara nchhu ni pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ŋ̈oŋ nthɔ njiŋ a ki lɔ mbɨ̄na tǎa vi, pugu pa mǔuŋ vi, ni ŋgwɛ vi, pugu pa puoŋ pi, ni lǐŋ pi pi pimbia, pugu pa pi piŋgɛ, ooŋ, pugu pa chɔmbhi yi, kaŋ minthɛ paʼa a lɔ mbɔ ŋgaŋ younjiŋ a. ");
INSERT INTO bmo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Shesheŋoŋ ŋa a lɔ njiʼi ntiɛŋ wáʼa yi nthɔ njiŋ mu nɛ, nthɛ paʼa a lɔ njōu njiŋ a. ");
INSERT INTO bmo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“A yəɨ ŋoŋ shɨna pəɨ ŋa ä ntāʼa nu ŋkrao nda tɔthɨ, paʼa a lɔ mfǔoŋ nchɔchhɔ shhɛ ndīi fɨʼɨ nchuoŋ yi, nɔ yəɨ nu ŋa a fāʼo fɨʼɨ mbɨŋ ŋa mimfɛ a krao nɔ ghɔ mīʼɛŋ nɛ? ");
INSERT INTO bmo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kiɛŋ nɛnnɛ, kaŋ a shi ŋga mbɔ ndɨɨ ŋa a nūʼɔŋ kwonda tɔthɨ ghɔ ki lɔ mīʼɛŋ nda tɔthɨ ghɔ nɛ, shesheŋoŋ gha njəɨ, māʼaŋ vi ni kwə̀ɨŋ, ");
INSERT INTO bmo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nchhu nu ŋa, ‘Ŋoŋ vei ni njɛ̄ ŋkrao nu nda ki lɔ njiʼi mīʼɛŋ.’ ");
INSERT INTO bmo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ki a yəɨ fùoŋ ŋa minthɛ a ghə̄ɨ nu māʼaŋ yichəɨ fùoŋ ni wuŋ ŋkaŋ ghaŋ māʼaŋ nchhɔ̀, yie fùoŋ lɔ fāʼo pi paa wuŋ ŋkaŋ ghaŋ nchhɔ̀, ki a lɔ fǔoŋ nchɔchhɔ shhɛ ndīi ŋa mimfɛ a māʼaŋ vi ni wuŋ ŋkaŋ ghaŋ nchhɔ̀ pighɔ. ");
INSERT INTO bmo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ti a nchɔchhɔ njəɨ ŋa mimfɛ paʼa a lɔ māʼaŋ vi, a taoŋ ghaŋ ntaoŋ ŋa pugu ghə̄ɨ mbie vie fùoŋ ŋa, ‘Pigi chwīe nɛiŋ nji ŋa mimfɛ pia fāʼo taʼaŋggi.’ ");
INSERT INTO bmo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wuʼɔ nɛnnɛ, shesheŋoŋ vəɨ nthɛ paʼa a lɔ njōu njiŋ a ki lɔ mīʼaŋ ŋguoŋ nnu pi nthɛ a. ");
INSERT INTO bmo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Khí pwa, ndɔ ghrɨ́ yi nɔ chwīe nu yaoŋ pwa mbhɛ, ɔ pɨnɨ ŋkwəɨ ni ghrɨ́ yi ghɔ pi nɛiŋ? ");
INSERT INTO bmo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nthɛ ŋa mbaʼa a yiʼi nuʼuŋ mfāʼo ghɛ̀rɛ shhɛ, ki nɔ gwí ŋkuʼu maoŋ chwīe yaoŋ pwa. Pi ghà mīʼaŋ khí yɛ ŋa a lɔ nuʼuŋ mfāʼo ghɛ̀rɛ nɛ mīʼaŋ. Ywɛrɛ, ŋoŋ ŋa a fāʼo tə́nə nɛ, â yaʼo!” ");
INSERT INTO bmo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Llɛ́ chəɨ, ghaŋ wɛ̄iŋ taashi pugu pa pichəɨ ghaŋ chwīe phɨ thɔ yəɨ Jishɔ nɔ yaʼo nu nnu ŋa a ni njɛʼi nu nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","pa ŋgwa Farashi pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi jɛ̄ luo nu, nchhu nu ŋa, “Ŋoŋ vei piŋ pa ghaŋ chwīe phɨ ti nthɔ njɨ maoŋ jɨ pugu pugu.” ");
INSERT INTO bmo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nɛnnɛ, Jishɔ ni nchhu yei luʼɔ chrà ni pugu: ");
INSERT INTO bmo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“A yəɨ ŋoŋ shɨna pəɨ ŋa ä mfāʼo taʼa ŋkɨɨ minjɨɨ, taʼa yi shɨna pugu phɛ, paʼa a lɔ mieŋ ndipuʼu wuŋ ni ndigi ndipuʼu moŋ ŋkǔnu, ŋgə̄ɨ njiŋ yɛ ŋa a phɛ nɛ, ntāʼa vi ti njəɨ? ");
INSERT INTO bmo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ndɨɨ ŋa a yəɨ vi nɛ, a tiɛŋ vi ŋkambəʼɨ yu, mbɨnɨ nɔ moŋ pwatua. ");
INSERT INTO bmo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ndɨɨ ŋa a pɨ̄nɨ laʼa nɛ, a gɛ̄ pa taannu pi, pugu pa taakuo pi, nchhu ni pugu ŋa, ‘Pia fāʼo pwatua nthɛ ŋa ǹjəɨ minjɨɨ a yɛ ŋa a ni mbhɛ nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nɛnnɛ Jishɔ lūgwi ŋa, “Wuʼɔ nɛnnɛ, ǹchhu nu vɛ ŋa ntou pwatua shi mbɔ po nthɛ taʼa ŋgaŋ phɨ ŋa a pāʼa ŋkǔnu yi ni phɨ nɛ, nchaa ndipuʼu wuŋ ni ndigi ndipuʼu ŋgwa shiʼi ŋa pugu pīʼi ŋa pugu lɔ mfāʼo nɔ paʼa nu ŋkǔnu yugu ni phɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ki a yəɨ miŋgwɛ ŋa a mfāʼo wuŋ ndigi mbɨŋ, taʼa yi phɛ, a mieŋ ki lɔ nchuʼu laŋ, njɨ̄gɨ ŋguoŋ nda ghao, ntāʼa pɔpɔrɔ ti nuʼuŋ njəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ŋga njəɨ, mɛ̄iŋ taannu pi, pugu pa taakuo pi, nchhu ni pugu ŋa, ‘P̂ia fāʼo pwatua, nthɛ ŋa ǹjəɨ ndigi mbɨŋ a yɛ ŋa a ni mbhɛ nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nɛnnɛ, Jishɔ lūgwi ŋa, “Wuʼɔ nɛnnɛ, ǹchhu nu vɛ ŋa, pwatua shi mbɔ shɨna pa ghaŋ ntaoŋ Minnwi nthɛ taʼa ŋgaŋ phɨ ŋa a pāʼa ŋkǔnu yi ni phɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jishɔ ghə̄ɨ shhɨ, nchhu nu ŋa: “Ŋoŋ chəɨ ni mbɔ fɔ mfāʼo paa puoŋ pimbia. ");
INSERT INTO bmo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Vi mikəʼɨ chhu ni tǎa vugu ŋa, ‘Ghrā maoŋ mfɛ nyaŋ, mbɔ maoŋ pɛ ŋa a kaŋ mbɔ nyaŋ ndɨɨ ŋa ɔ khu nɛ.’ Tǎa ghɔ ghrā maoŋ pi ni pugu. ");
INSERT INTO bmo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“A ni ŋga ndaʼa shɨgɛi llɛ́, vi mikəʼɨ kɨrɨ ŋguoŋ maoŋ pi ghao, ŋgwɛ̄iŋ ndaoŋ ŋgə̄ɨ fie moŋ yichəɨ laʼataoŋ, nshāaŋ fɔ ghao moŋ jɨ ki tou. ");
INSERT INTO bmo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","A ni ŋga njɨ ŋguoŋ mbɨŋ yi ghao, nji gū moŋ laʼataoŋ ghɔ, a jɛ̄ pɔ nu moŋ pou. ");
INSERT INTO bmo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A ghə̄ɨ mfɛ noŋ yi ni ŋoŋ laʼataoŋ ghɔ nɔ ŋgaŋ fàʼa, ŋgaŋ vi taoŋ vi moŋ nyìeŋ yu ŋa a ghə̄ɨ nthɔ ŋkugwi ŋkunyaŋ. ");
INSERT INTO bmo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A khwā nɔ kugwi nu noŋ yi ni maoŋ ŋa pa ŋkunyaŋ ni njɨ nu nɛ, ndɔ paʼa ŋoŋ lɔ mfɛ sheshe yaoŋ ŋa a jɨ. ");
INSERT INTO bmo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ndugwi yi, lɨna yi gha ŋkwəɨ, a chhu ni noŋ yi ŋa, ‘A fāʼo ghaŋ fàʼa tǎa a pi khɔ mfāʼo maoŋ jɨ ti a ka yiɛŋyiɛŋ ntɔrɔ, ǹthɔ ŋkhu njì hɛiŋ? ");
INSERT INTO bmo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ǹshi ndɔllɔ ŋgə̄ɨ njəɨ tǎa a, njūa ghɔ ŋa, “Tǎa, m̀fāaŋ mbɨŋ Minnwi, mbɨnɨ mfāaŋ mbɨŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ǹdɔ nuʼuŋ ŋkāʼo nɔ pɔ nu muuŋ ghɔ, lɔ̄gɔ a pi nɔ taʼa ŋgaŋ fàʼa yɔ.” ’ ");
INSERT INTO bmo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Nnɛ a lɔllɔ ŋgə̄ɨ lɨʼɨ yəɨ tǎa vi, ŋga ŋguʼɔ mbɔ fie hiŋ, tǎa vi yəɨ vi, mfāʼo kwoshɨnɨ mbɨŋ yu, ntaoŋ ntei ŋgə̄ɨ mbaŋ vi, nchrā ghɔ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Muuŋ ghɔ chhu ni tǎa vi ŋa, ‘Tǎa, m̀fāaŋ mbɨŋ Minnwi, mbɨnɨ mfāaŋ mbɨŋ ghɔ. A lɔ nuʼuŋ ŋkāʼo ŋa pi mɛ̄iŋ a ŋa muuŋ ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ndɔ tǎa ghɔ chhu ni pa ghaŋ fàʼa pi ŋa, ‘Pəɨ kɔnɔ nthɔ ni ŋkiɛŋ ndhwí māʼaŋ mbɨŋ yu, ŋgwɛ krɛ́i nɔ mbhɔ yi, mbɨnɨ ŋgwɛ tra nɔ kwò yi. ");
INSERT INTO bmo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nthɔ ni muuŋ nàʼaŋ fuʼu njwi pia fāʼo jɨ, ");
INSERT INTO bmo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","nthɛ ŋa muuŋ a vei ni ŋkwo khu, mbɨnɨ njwiŋ! A ni mbhɛ, m̀bɨnɨ njəɨ vi!’ Pugu jɛ̄ jɨ nu kiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ndɨɨ ghɔ muuŋ shhɨ vi ni mbɔ moŋ nyìeŋ. Ŋga ŋkwəɨ nu ti mbara laʼa, njaʼo lōu pugu pa pini. ");
INSERT INTO bmo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mɛ̄iŋ yichəɨ taʼa muuŋ fàʼa mbie vi ŋa, ‘A lɔ̄gɔ khɔ, ndɔ̄gɔ lɨʼɨ?’ ");
INSERT INTO bmo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A chhu ghɔ ŋa, ‘Ndǐŋ ghɔ pɨnɨ, tǎa vəɨ jwi muuŋ nàʼaŋ tutru, nthɛ ŋa a kwəɨ laʼa shishiʼi.’ ");
INSERT INTO bmo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“A pɨgɨtua ndāa ŋa mbaʼa a yiʼi nii nda. Tǎa vi taoŋ ndɨ̄gəɨ vi. ");
INSERT INTO bmo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A luʼu ghɔ ŋa, ‘Līi njəɨ, m̀fāʼa mbhɔ ghɔ nɔ ntou ŋgaʼo paʼa ndɔ ma nchɨ̄ʼə nchò yɔ, ndɔ paʼa ɔ lɔ ma mfɛ muuŋ mimbhi vəɨ ŋa ŋ̀gwrā pigi pa taannu paŋ mfāʼo jɨ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ndɔ ti yaoŋ muuŋ ghɔ vei, ŋa a shāaŋ maoŋ pɔ ghao ŋkuoŋ pa shakhɨ, gha ŋkwəɨ, ɔ jwi muuŋ nàʼaŋ tutru ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“A khwɛ̄ ghɔ ŋa, ‘Muuŋ a, pɔgɔ ghà ŋguʼɔ mbɔ kaʼa, sheshe yaoŋ ŋa a nyaŋ nɛ, a jɔ. ");
INSERT INTO bmo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ndɔ a kāʼo nɔ jɨ nu, ndɔ mfāʼo pwatua, nthɛ ŋa ndǐŋ ghɔ vei ni ŋkhu mbɨnɨ njwiŋ, a ni mbhɛ m̀bɨnɨ njəɨ vi.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jishɔ ghə̄ɨ shhɨ nchhu ni ghaŋ younjiŋ pi ŋa: “Ŋgaŋ fàʼo chəɨ ni mbɔ fɔ mfāʼo nthishɨ pa puoŋ fàʼa pi, ŋgwa thɔ ntūgu ghɔ ŋa muuŋ fàʼa yi ghɔ thɔ nshāaŋ mbɨŋ yi shāaŋ. ");
INSERT INTO bmo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nthɛ yie ghɔ, a mɛ̄iŋ vi nchhu ghɔ ŋa, ‘Yei khɔ ŋa ǹthɔ njaʼo nu nthɛ ghɔ? Fɨ̄ʼɨ vəɨ ŋkwaŋ nɔ haʼaŋ ɔ thɔ ntuo maoŋ paŋ nɛ, nthɛ ŋa mbaʼa ɔ nuʼuŋ mbiʼi nthishɨ pa puoŋ fàʼa paŋ.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Nthishɨ pa puoŋ fàʼa ghɔ chhu ni noŋ yi ŋa, ‘Mi shi nchwīe pi nɛiŋ ndwɛ ŋa masha a tāʼa nu mfuʼu a fuʼu moŋ fàʼa a nɛ. Ǹdɔ njiʼi mfāʼo ghrɨ́ fāʼa nu nyìeŋ pi pe a, ndɔ thɔ a lilri nɔ luoŋ nu. ");
INSERT INTO bmo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ǹji nnu ŋa ǹshi nchwīe nɛ ndwɛ, nji ŋa ŋgwa shi mbiŋ a nda pugu ndɨɨ ŋa pi fuʼu a moŋ fàʼa nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nnɛ a gɛ̄ ŋguoŋ ghaŋ ŋkrù masha vi pa taʼa yi taʼa yi, ŋa pugu thɔ njəɨ vi. A pie ni fǔoŋ yi ŋa, ‘Ŋkrù masha a pɔ puŋ ghɔ yi khɔ?’ ");
INSERT INTO bmo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A khwɛ̄ ŋa, ‘Taʼa ŋkɨɨ jo wru.’ A chhu ghɔ ŋa, ‘Chɔchɔ ŋkwe ŋwaʼaŋlɨ ŋkrù yɔ ŋkɛrɛ nāʼaŋ ŋa a tiɛŋ wuŋ jo puŋ ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“A pɨnɨ nchhu ni yichəɨ ŋa, ‘Jɔ ŋkrù yi khɔ?’ A chhu ŋa, ‘Taʼa ŋkɨɨ pìɛŋ pilei.’ A chhu ghɔ ŋa, ‘Kɛrɛ nāʼaŋ fúoŋ wuŋ pìɛŋ.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nthɛ yie ghɔ, masha nthishɨ pa puoŋ fàʼa yei piŋ vi nthɛ nnu shiethɔ yei ŋa a ni nchwīe nɛ. Nthɛ ŋa ghaŋ ŋkuoŋ mbhi yei fāʼo shiethɔ ni ŋkwaŋ haʼaŋ pugu ghà nchwīe nnu pugu nchaa ŋgwa ŋa pugu pɔ moŋ líʼɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ndɔ ǹshwei ghɔ, lɔ̄gɔ maoŋ ŋkuoŋ mbhi yei mbwa puŋ nɔ ghɔ, nji ŋa maoŋ pighɔ shi ŋga mieŋ ki lɔ nūʼɔŋ mbɔ, Minnwi fɛ laʼa vɛ po. ");
INSERT INTO bmo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ŋoŋ ŋa a tɔgɔ ndaoŋ ntou moŋ puoŋ mi nnu nɛ shi ntɔgɔ ndaoŋ ntou moŋ mɛmmɛ nnu. Wuʼɔ nɔ haʼaŋ ŋoŋ ŋa a chwīe nnu fifiri moŋ puoŋ mi nnu nɛ, shi nchwīe fifiri moŋ mɛmmɛ nnu. ");
INSERT INTO bmo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ti p̈əɨ mieŋ ki tɔgɔ ndaoŋ ntou ni ŋkwaŋ haʼaŋ pəɨ tuo fàʼo ŋkuoŋ mbhi yei nɛ, Minnwi kie pi nɛiŋ mfɛ ŋkiɛŋ fàʼo llɔ po ni pəɨ, ŋa pəɨ lɨna nɔ ghɔ? ");
INSERT INTO bmo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ti p̈əɨ mieŋ ki tɔgɔ ndaoŋ ntou ni yaoŋ ŋa a yi ŋoŋ nduoŋ nɛ, Minnwi kie pi nɛiŋ mfɛ fàʼo ŋa a shi mbɔ yəɨ nɛ ni pəɨ? ");
INSERT INTO bmo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Mbaʼa taʼa muuŋ fàʼa fāʼa mbhɔ paa masha. A shi ŋguʼɔ mbɨ̄na taʼa yi ŋkhwā vichəɨ, a shi njaʼo taʼa yi, nchɨ̄ʼə nchò vichəɨ. Mbaʼa pəɨ fāʼa mbhɔ Minnwi pugu mbɨŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pa Farashi ni ŋga njaʼo nnu yei, māʼaŋ Jishɔ ni kwə̀ɨŋ nthɛ ŋa pugu ni ŋkhwā mbɨŋ. ");
INSERT INTO bmo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ndɔ a chhu ni pugu ŋa, “Pəɨ pa ŋgwa haʼaŋ pəɨ ghà nchwīe ŋa ŋgwamishua līi vəɨ nɔ pa ŋgwa tithi, ndɔ Minnwi ji njùʼɔ yəɨ. Nthɛ ŋa yaoŋ ŋa ŋgwamishua līi a pɔ mmɛ yi nɛ, pɔ pi yaoŋ pɨphɨ ligi Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Gɨ́ Mushi pugu pa nnu ŋa pa njəɨlɨʼɨ Minnwi ni nāʼaŋ nɛ ni nthɔ fāʼa nu ti ŋgə̄ɨ nchəɨŋ moŋ ndɨɨ Jouŋ. Jɛ̄ ndɨɨ ghɔ, pi chīi pwa pishaʼakhɔ Shaʼafuoŋ Minnwi, ŋgwa ŋa pugu piŋ nɛ chhɔ mfra nu nii moŋ ghɔ ni pri. ");
INSERT INTO bmo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A yīʼɛ ni po pugu shhɛ nɔ pɨrɨ nu nchaa ŋa taʼa muuŋ mi nnu ŋa a pɔ moŋ ŋwaʼaŋlɨ gɨ́ mieŋ ki lɔ ndɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Shesheŋoŋ ŋa a shāaŋ láŋ pugu ŋgwɛ vi ndáŋ miŋgwɛ nduoŋ nɛ kwo shúoŋ, ŋoŋ ŋa a laŋ miŋgwɛ ŋa a taoŋ láŋ nɛ kwo shúoŋ ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ŋgaŋ fàʼo chəɨ ni mbɔ fɔ nthɔ māʼaŋ pa ndhwí tɨnɨnchuoŋ, nchhɔ njɨ ŋkiɛŋkiɛŋ maoŋ jɨ ŋguoŋ llɛ́ ghao. ");
INSERT INTO bmo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ŋgaŋ pou chəɨ ni mbɔ fɔ, ligi yi pɔ Lasharɔ, ŋa pi ni nūʼɔŋ vi choŋkaʼa ŋgaŋ fàʼo yei, noŋ yi ni ŋguʼɔ mbɔ pi fɨfɨ ghao. ");
INSERT INTO bmo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A ni ŋkhwā nu njɨ pa ŋkuʼu maoŋ pɛ ŋa a gū llɔ ŋkuoŋ taprɛi ŋgaŋ fàʼo ghɔ nɛ. Nɔ pigi nu, pa miŋgu ni nthɔ nchhɔ ndra fɨ́ yi. ");
INSERT INTO bmo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ŋgaŋ pou ghɔ khu, ghaŋ ntaoŋ Minnwi thɔ ndɔ̄gɔ vi ŋgə̄ɨ nūʼɔŋ shoyəɨ Abrahaŋ. Ŋgaŋ fàʼo ghɔ khu ŋkaa yu, pi twei vi, ");
INSERT INTO bmo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","a ghə̄ɨ lɨʼɨ haʼaŋ ghaŋ phɨ ghà ŋkhu ŋgə̄ɨ nɛ, nchhɔ njəɨ ŋgəʼɨ fɔ, ŋga mbɨʼɨ ligi yi, njəɨ Abrahaŋ fie hiŋ pugu Lasharɔ shoyəɨ yu. ");
INSERT INTO bmo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Ŋgaŋ fàʼo ghɔ yūa ni Abrahaŋ ŋa, ‘Tǎa, fāʼo kwoshɨnɨ mbɨŋ mu, ntaoŋ Lasharɔ ŋa a chrū thɔ muuŋshɨmbhɔ yi moŋ ŋkhǐ nthɔ ŋgrɨ túa a nɔ ghɔ, nthɛ ŋa m̀bɔ moŋ tɨtɨnɨ yúʼɔ moŋ móŋoŋ yei.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ndɔ Abrahaŋ chhu ghɔ ŋa, ‘Muuŋ a, kwiŋ ŋa moŋ chɔmbhi yɔ pi ni mfɛ pa maoŋ shiʼi vɛ, Lasharɔ fāʼo ji pi pɨphɨ. Ndɔ ti ndwɛ, a pɔ moŋ nchhɔ́ shiʼi hɛiŋ, ɔ pɔ hɛnɛ moŋ tɨtɨnɨ ŋgəʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mbapa nɛnnɛ, pi nūʼɔŋ mmɛ wə́ɨŋ, a fɛ̄nɛ via, nɛnnɛ ŋa shesheŋoŋ ŋa a tāʼa nu nshāʼa hɛnɛ nɛ nthɛ paʼa a lɔ nshāʼa, wuʼɔ nɔ haʼaŋ mbaʼa ŋoŋ llɔ ŋgei pəɨ nthɔ njəɨ vigi nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ŋgaŋ fàʼo ghɔ chhu ŋa, ‘Mbaʼo mbhɔ nɛ shhɨ ghɔ, ma tǎa, ŋa ɔ taoŋ nɛ Lasharɔ puŋ nda pigi. ");
INSERT INTO bmo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nthɛ ŋa m̀fāʼo lǐŋ paŋ pi pimbia pi tiɛŋ, nɛnnɛ ŋa a ghə̄ɨ shūu tə́nə yugu, kiɛŋ nɛnnɛ, kaŋ pugu ŋkaa pugu shi nii moŋ lɨʼɨ ŋgəʼɨ yei.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abrahaŋ khwɛ̄ ŋa, ‘Pugu fāʼo gɨ́ Mushi pugu pa nnu ŋa pa njəɨlɨʼɨ Minnwi nāʼaŋ nɛ, pugu yaʼo pie ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“A chhu ŋa, ‘Ŋga, ma tǎa vigi Abrahaŋ, ŋoŋ ŋa a khu nɛ mbɨnɨ ŋkuʼɔ ŋgə̄ɨ nchrā ni pugu, pugu kwri.’ ");
INSERT INTO bmo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abrahaŋ chhu ghɔ ŋa, ‘P̈ugu mieŋ ki yaʼo gɨ́ Mushi pugu pa nnu ŋa pa njəɨlɨʼɨ Minnwi nāʼaŋ nɛ, kaŋ mbaʼa pugu yiʼi mbiŋ nɔ haʼaŋ a njiʼi nthɔ ŋoŋ ŋa a khu mbɨnɨ ŋkuʼɔ nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jishɔ chhu ni ghaŋ younjiŋ pi ŋa, “Pa nnu ŋa a nthɛ a chwīe ŋgwa gū moŋ phɨ nɛ shi ŋguʼɔ nthɔ. Ndɔ ti wuwuru ŋgəʼɨ yi ŋoŋ yɛ ŋa a kie pi mbhɔ yu maa nthɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A kaŋ ni mbwa ŋa pi chu mmɛ ŋgùʼɔ wuʼɔ yaoŋ mmi yu māʼaŋ vi moŋ ŋkhǐ, nchaa ŋa a chwīe sheshe taʼa puoŋ mi puoŋ paŋ pei gū moŋ phɨ. ");
INSERT INTO bmo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pəɨ lɨna ni noŋ pəɨ! “N̈dǐŋ ghɔ nchwīe phɨ, ɔ fɛ̄ʼi vi, ndɔ ti a mbāʼa ŋkǔnu yi, ɔ līʼɛ phɨ yi. ");
INSERT INTO bmo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ndɔ ti a nchwīe phɨ mbɨŋ ghɔ ni khwachəɨ ŋgɛ́ moŋ taʼa llɛ́, sheshe ŋgɛ́ a pɨnɨ nchhu vɛ ŋa a pāʼa ŋkǔnu yi nɔ ghɔ, a yiʼi ŋa ɔ līʼɛ phɨ yi.” ");
INSERT INTO bmo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pa ghaŋ ntaoŋ Jishɔ chhu ghɔ ŋa, “Taathɔ, pigi luoŋ ŋa ɔ pigi piŋ yigi.” ");
INSERT INTO bmo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Taathɔ khwɛ̄ ŋa, “P̈əɨ mfāʼo piŋ ti a wuʼɔ mbɔ pi nɔ fɨʼɨ mbhɛ̌ frushɨga, kaŋ a nthɛ pəɨ chhu ni thɨ wuŋ ŋa, ‘Mūʼuŋ ŋgə̄ɨ mbhi noŋ yɔ moŋ ŋkhǐ!’, a yaʼo nchò yəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Lɔ̄gɔ ŋa taʼa ŋoŋ vəɨ fāʼo ŋkǔna ŋa a chhɔ mfāʼa nyìeŋ, ki ŋkɛ̄ʼi minjɨɨ, a nthɛ a gha ŋkwəɨ moŋ nyìeŋ a chhu ghɔ pi ŋa, ‘Thɔ nchhɔ hɛiŋ taʼa ŋgɛ́ njɨ maoŋ?’ ");
INSERT INTO bmo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ŋga! A shi ŋka chhu ghɔ pi ŋa, ‘Nyiaŋ maoŋ jɨ vəɨ, mbīri noŋ yɔ, nthɔ mfɛ vəɨ ti ŋ̀ga njɨ ndɔ nnu, ɔ ghə̄ɨ kiʼɛ njɨ jɔ ndɔ nnu.’ ");
INSERT INTO bmo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mbaʼa a yiʼi ntōo ŋkǔna ghɔ nthɛ ŋa a chwīe fàʼa ŋa a chhu ghɔ ŋa a chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A haʼaŋ a pɔ ni pəɨ nɛ, ndɨɨ ŋa pəɨ kwo chwīe ŋguoŋ nnu ŋa Minnwi chhu ŋa pəɨ chwīe nɛ, pəɨ chhu ni noŋ pəɨ ŋa, ‘Pigi wuʼɔ mbɔ pi pa ŋkǔna, pigi wuʼɔ nchwīe pi yaoŋ ŋa a ni ŋkwo pɔ fàʼa yigi nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jishɔ ni ŋgə̄ɨ nu Jerushalɛiŋ, ntɔgɔ nu shɨna Shamaria pugu Galili. ");
INSERT INTO bmo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ŋga nii moŋ yichəɨ muuŋ laʼataoŋ, wuŋ ghaŋ ghɨnɔmbaluŋ paoŋ pugu pugu. Pa ghaŋ ghɨ̌nɔ pighɔ ni nthi pi fie hini, ");
INSERT INTO bmo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mɛ̄iŋ ni njɨ ŋa, “Jishɔ! Taathɔ! Fāʼo kwoshɨnɨ mbɨŋ pigi!” ");
INSERT INTO bmo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jishɔ ni ŋga njəɨ vugu, nchhu ni pugu ŋa, “Pəɨ ghə̄ɨ nōoŋ noŋ yəɨ ni ghaŋ fɛʼiŋgiɛŋ Minnwi, pugu līi vəɨ njəɨ ŋa ghɨ̌nɔ yəɨ mmɛ.” Pugu ni ŋga ŋgə̄ɨ nu, Jishɔ yɨ̄gɨ ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yichəɨ taʼa ŋgaŋ ghɨnɔmbaluŋ ghɔ ni ŋga njəɨ ŋa ghɨ̌nɔ yi mmɛ nɛ, mbɨnɨ nchhɔ ŋgaʼo Minnwi ŋkiɛŋ ni njɨ, ");
INSERT INTO bmo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","nthɔ gū shhɨ Jishɔ ni puŋ yi nthɔ ntōo vi. Ŋoŋ vei ni mbɔ ŋoŋ Shamaria. ");
INSERT INTO bmo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jishɔ pie ni ŋgwa ŋa pugu ni mbɔ fɔ nɛ ŋa, “Mi nì njɨ̄gɨ pi ghɨ̌nɔ wuŋ ŋgwa, pichəɨ ndipuʼu hɨŋ? ");
INSERT INTO bmo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","A chwīe khɔ a wuʼɔ nthɔ ŋgɨ̀nɨ vei nɔ tōo nu Minnwi?” ");
INSERT INTO bmo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nchhu ghɔ kiʼɛ ŋa, “Lɔllɔ ŋgə̄ɨ ni gɔ! Piŋ yɔ chwīe ɔ lūgu.” ");
INSERT INTO bmo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pichəɨ ŋgwa Farashi ni ŋga mbie Jishɔ ni ndɨɨ ŋa Minnwi shi njɛ̄ shaʼa nu fùoŋ yi nɛ, Jishɔ khwɛ̄ ŋa, “Shaʼafuoŋ Minnwi shiʼa njiʼi nthɔ pi ŋkwaŋ nɔ haʼaŋ mimfɛ ɔ thɔ njəɨ yəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mbaʼa yichəɨ kaŋ taʼa ŋoŋ yiʼi nchhu ŋa, ‘Līi njəɨ, a pɔ nɛiŋ hɛiŋ!’ ki ŋa, ‘A pɔ ni hini!’, nthɛ ŋa, līi njəɨ, Minnwi thɔ nshaʼa fùoŋ yi shɨna pəɨ!” ");
INSERT INTO bmo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jishɔ chhu ni ghaŋ younjiŋ pi ŋa, “Ndɨɨ chhɔ nthɔ nu ŋa pəɨ shi ŋkhwā nɔ yəɨ nu taʼa llɛ́ moŋ llɛmbhi Muuŋ Ŋoŋmishua, ndɔ mbaʼa pəɨ yəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pichəɨ ŋgwa shi nchhu ni pəɨ ŋa, ‘Līi njəɨ, a pɔ ni, līi njəɨ, a pɔ nɛiŋ!’ Ndɔ kiʼi mbiŋ nnu ŋa pugu chhu nu nɛ ki njōu njiŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ǹchhu nɛiŋ nthɛ ŋa ndɨɨ ŋa Muuŋ Ŋoŋmishua shi mbɨnɨ nɛ, a shi mbɔ po nɔ fiembɨ ŋa a shēi llɔ moŋ taʼa ŋgei po ti ŋgə̄ɨ nchəɨŋ moŋ yichəɨ, shesheŋoŋ yəɨ nji. ");
INSERT INTO bmo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ndɔ a shi ŋguʼɔ mfǔoŋ njəɨ ŋgəʼɨ, ŋgwa mbhi shiʼa lāa vi. ");
INSERT INTO bmo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ŋkwaŋ nɔ haʼaŋ a ni mbɔ mbhi ŋoŋ ŋa ligi yi ni mbɔ Noa nɛ, a nɔ haʼaŋ a shi mbɔ ndɨɨ ŋa thɔ nu Muuŋ Ŋoŋmishua kaoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ŋgwa ni nchhɔ njɨ maoŋ, ndɔ nnu nu, ndaŋ nu, ndɔ ŋgə̄ɨ nu nda láŋ ti ŋgə̄ɨ nchəɨŋ llɛ́ yɛ ŋa Noa ni nii moŋ mmɛ pie ŋa a pɔ nɔ nda nɛ. Ŋkhǐ thɔ kiʼɛ njwi ŋguoŋ yugu ghao. ");
INSERT INTO bmo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Wuʼɔ ŋkwaŋ nɔ haʼaŋ a ni mbɔ moŋ mbhi ŋoŋ ŋa ligi yi ni mbɔ Lɔti nɛ. Pugu ni nthɔ njɨ maoŋ ndɔ nnu nu, nchwīe taŋ, nthɔ mbhi maoŋ pugu, ŋkrao laʼa muŋu. ");
INSERT INTO bmo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ndɔ ti a ni ŋga mbɔ llɛ́ yɛ ŋa Lɔti ni ntaoŋ ni vhi Shodoŋ nɛ, móŋoŋ pugu móŋoŋ ŋgùʼɔ mikaŋ llɔ vugu, njwi vugu ghao. ");
INSERT INTO bmo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","A ŋkwaŋ haʼaŋ a lɛ mbɔ llɛ́ yɛ ŋa Muuŋ Ŋoŋmishua shi mbɨnɨ nōoŋ noŋ yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“A mbɔ llɛ́ ghɔ, kiʼi ŋoŋ ŋa a pɔ mbhi, maoŋ pi pɔ nda nɛ, pɨnɨ nii nda lɨʼɨ lɔ̄gɔ maoŋ pighɔ. Wuʼɔ nɛnnɛ kiʼi ŋgwa pɛ ŋa pugu pɔ moŋ nyìeŋ nɛ pɨnɨ mbɨnɨ laʼa lɨʼɨ lɔ̄gɔ sheshe yaoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kwiŋ nnu ŋa a ni mfɨ̄ʼɨ ŋgwɛ Lɔti nɛ! ");
INSERT INTO bmo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Shesheŋoŋ ŋa a tāʼa nu ŋkwe chɔmbhi yi nɛ shi nshiɛŋ chɔmbhi yi ghɔ, ndɔ ti ŋoŋ yɛ ŋa a mīʼaŋ chɔmbhi yi nɛ shi ŋkwe chɔmbhi yi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ǹshwei vəɨ, a lɛ ŋga mbɔ ni tuʼu ghɔ, paa ŋgwa nūaŋ kúoŋ, pi lɔ̄gɔ taʼa yi, vichəɨ kɨna. ");
INSERT INTO bmo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Paa piŋgɛ lɛ nthɔ ŋgūʼɔ shíe kaʼa, pi lɔ̄gɔ taʼa yi, taʼa yi kɨna. ");
INSERT INTO bmo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","“Paa pimbia shi mbɔ moŋ nyìeŋ, pi lɔ̄gɔ taʼa yi, taʼa yi kɨna.” ");
INSERT INTO bmo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pa ghaŋ younjiŋ pi pie vi ŋa, “Ɔ shi mbɨnɨ pi hɨŋ, Taathɔ?” Jishɔ khwɛ̄ ŋa, “Lɨʼɨ ŋa khu miyaoŋ pɔ nɛ, pa mishi pɛ ŋa pugu gha ŋkru khu miyaoŋ nɛ shi ŋkɨrɨ fɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jishɔ ni nshwei ghaŋ younjiŋ pi ni yei luʼɔ chrà nɔ tɨgɨ nu vugu ŋa pugu fāʼo nɔ luoŋ nu Minnwi ŋguoŋ ndɨɨ ghao ki lɔ mfāʼo lɨʼənoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A ni nchhu ŋa, “Laʼataoŋ chəɨ, ŋgaŋ shaʼa sháʼa chəɨ ni mbɔ fɔ ŋa a lɔ njiʼi mbɔgɔ Minnwi ndɔ paʼa ndɔ fāʼo ndɨɨ ŋoŋmishua. ");
INSERT INTO bmo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Miŋgwɛ ŋkugu chəɨ ni mbɔ laʼataoŋ ghɔ ŋa a ni ŋguʼɔ nthɔ ŋgana ŋgaŋ shaʼa sháʼa ghɔ ghana, nchhu nu ghɔ ŋa, ‘Ghɛ̄rɛ a nshaʼa sháʼa yigi mbɨ̌na a yei moŋ ndɨndɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ŋgaŋ shaʼa sháʼa vei ni ndāa nɔ kuo ndɨɨ. A ni ndugwi nchhu ni noŋ yi ŋa, ‘Njiʼi nthɛ pi ndɔ haʼaŋ ǹdɔ mbɔgɔ Minnwi ki mfāʼo ndɨɨ ŋoŋmishua nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ndɔ ti nthɛ fɨʼɨ ghaghana ŋa miŋgwɛ ŋkugu vei fɛ nu vəɨ nɛ, ǹshi nshaʼa sháʼa yi moŋ ndɨndɨ, kiɛŋ nɛnnɛ, kaŋ a shi nshiɛŋ a moŋ thɔ nu ŋgana a ŋguoŋ ndɨɨ ghao.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Taathɔ ghə̄ɨ shhɨ nchhu ŋa, “Pəɨ yaʼo nnu haʼaŋ ŋgaŋ shaʼa sháʼa ni mbe chhu njaʼo. ");
INSERT INTO bmo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mbaʼa Minnwi shaʼa sháʼa ŋgwa pi ŋa a tɛrɛ nɛ moŋ ndɨndɨ, ŋgwa haʼaŋ pugu yūa ghɔ moŋ tuʼu pugu pa naoŋchɨ nɛ? Pəɨ pīʼi ŋa a shi ŋguʼɔ nchhɔ njīri nu nɔ ntaaŋ ndɨɨ? ");
INSERT INTO bmo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ǹshwei vəɨ ŋa Minnwi shi nshaʼa sháʼa yugu moŋ ndɨndɨ pi ni tei. Mbapa nɛnnɛ, ndɨɨ ŋa Muuŋ Ŋoŋmishua shi nthɔ nɛ, pəɨ pīʼi ŋa a shi ma njəɨ ŋgwa ŋkuoŋ mbhi pugu fāʼo piŋ?” ");
INSERT INTO bmo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jishɔ chhu yei luʼɔ chrà ni pichəɨ ŋgwa ŋa pugu ni mbīʼi ŋa pugu pɔ shiʼi shhɨ Minnwi, ndɔ nchɨ̄ʼə pichəɨ ŋgwa nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Paa ŋgwa pichəɨ ni mbɔ fɔ ŋgə̄ɨ Nda Minnwi lɨʼɨ luoŋ Minnwi. Taʼa yi ni mbɔ ŋoŋ Farashi, vichəɨ pɔ ŋgaŋ wɛ̄iŋ taashi. ");
INSERT INTO bmo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ŋoŋ Farashi ghɔ thi təʼɨ vi nduoŋ ŋa, ‘Ǹtōo ghɔ, ma Minnwi, ŋa ǹdɔ mbɔ ŋoŋ mbembe nɔ pichəɨ ŋgwa. Ǹshiʼa nchīgi ŋoŋ, paʼa ndɔ mbɔ ŋgaŋ mbe, ndɔ paʼa ndɔ mbɔ ŋkwoshuoŋ, ki mbɔ nɔ ŋgwɛ̄iŋ taashi yini hini nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ŋga njī ŋkhǐ paa ŋgɛ́ moŋ taʼa taŋ, mfɛ shwéi ŋguoŋ yaoŋ ŋa ŋga mfāʼo nɛ ghao.’ ");
INSERT INTO bmo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ŋgaŋ wɛ̄iŋ taashi thi fie hini, paʼa ndɔ mbɨʼɨ ligi yi ndīi po, mbɔ ni tuʼuthɔ, nchhu nu ŋa, ‘Minnwi, fāʼo kwoshɨnɨ mbɨŋ mu, nchwīe phɨ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jishɔ chhu ŋa, “Ǹshwei ghɔ, ŋoŋ vei ni mbɔ shiʼi shhɨ Minnwi nchaa ŋoŋ Farashi. Nthɛ ŋa shesheŋoŋ ŋa a kə̄rə noŋ yi nɛ, pi shi nshwiʼi vi shhɛ, ŋoŋ ŋa a shwiʼi noŋ yi shhɛ nɛ, pi kə̄rə vi.” ");
INSERT INTO bmo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pichəɨ ŋgwa ni nthɔ ni pa puoŋ prɔ njəɨ Jishɔ nɔ ghɔ ŋa a nūʼɔŋ mbhɔ yi thɔ pugu nɔ fɛ nu mbɔrɔ ni pugu. Pa ghaŋ younjiŋ pi gha njəɨ, mbɨ̄ga ŋgwa pighɔ. ");
INSERT INTO bmo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jishɔ mɛ̄iŋ puoŋ pighɔ pugu thɔ yəɨ yu, a chhu nu ŋa, “P̂əɨ mieŋ puoŋ prɔ thɔ njəɨ a, kiʼi pəɨ pɔ kɨʼɨŋgɨnɨ ni pugu nthɛ ŋa Shaʼafuoŋ Minnwi pɔ pi ni ŋgwa pɛ ŋa pugu pɔ nɔ puoŋ prɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Shishini, ǹshwei vəɨ, mbaʼa shesheŋoŋ ŋa a lɔ njiʼi mbiŋ Shaʼafuoŋ Minnwi nɔ muuŋ mbrɔ nɛ, yiʼi nii moŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yichəɨ nthishɨ pa Juu pie ŋa, “Ŋkiɛŋ masha, mimfɛ ǹchwīe pi nɛiŋ mfāʼo chɔmbhi ki mmɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jishɔ pie ŋa, “Ɔ mɛ̄iŋ a ni ŋkiɛŋ ŋoŋ nthɛ khɔ? A wuʼɔ Minnwi mbɔ ŋkiɛŋ ŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ɔ ji yaoŋ ŋa pa kɨ̀na chhu nɛ: ‘Kiʼi ŋgaŋ láŋ kwoshuoŋ, kiʼi njwi ŋoŋ, kiʼi njōo, kiʼi ŋkwe ntie ŋoŋ ni mbe, yaʼo nchò tǎa ghɔ pugu muuŋ ghɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A khwɛ̄ ŋa, “Ŋguoŋ kɨ̀na pei ŋ̀kwo nūʼɔŋ llɔ ndɨɨ ŋa mi ni mbɔ maʼaŋ mikhwa nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jishɔ gha njaʼo nnu yei, nchhu ghɔ ŋa, “Ɔ wuʼɔ mbɨnɨ mbou yichəɨ taʼa nnu. Fīni ŋguoŋ maoŋ pɔ ghao ŋgrā ni ghaŋ pou, kaŋ fàʼo yɔ shi mbɔ po, nnɛ nthɔ njōu njiŋ a.” ");
INSERT INTO bmo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A ni ŋga njaʼo nnu yei noŋ yi shwiʼi nthɛ ŋa a ni mfāʼo ŋgaʼa. ");
INSERT INTO bmo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jishɔ pɛʼi vi ŋkwaŋ haʼaŋ noŋ yi shwiʼi nɛ, nchhu ŋa, “A ya ŋgaʼa ni ghaŋ fàʼo nɔ mieŋ nu Minnwi shaʼa fùoŋ yi moŋ chɔmbhi yugu. ");
INSERT INTO bmo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A yīʼɛ ni minyieŋləɨ nɔ tɔgɔ nu moŋ mbo mitaʼa nchaa ŋgaŋ fàʼo nɔ mieŋ nu Minnwi shaʼa fùoŋ yi moŋ chɔmbhi yi.” ");
INSERT INTO bmo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ŋgwa pɛ ŋa pugu ni njaʼo nnu yei ŋa Jishɔ ni nchhu nɛ chhu ŋa, “Ti ŋoŋ ŋa mimfɛ a lūgu nɛ pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jishɔ khwɛ̄ ŋa, “Nnu ŋa mbaʼa ŋoŋmishua chwīe nɛ yīʼɛ ni Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita chhu ŋa, “Līi njəɨ! Pigi mieŋ pa laʼa miŋi nthɔ njōu njiŋ yɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jishɔ chhu ni pugu ŋa, “Shishini, ǹshwei vəɨ, yichəɨ kaŋ taʼa ŋoŋ lɔ mbɔ ŋa a mieŋ nda yi, ki ŋgwɛ vi, ki ndǐŋ vi, ki tǎa vi pugu mǔuŋ vi, ki puoŋ, nthɛ pi Shaʼafuoŋ Minnwi nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ŋa a shi mieŋ ki fāʼo ntou yi moŋ yei chɔmbhi ndɔ shi mfāʼo chɔmbhi ki mmɛ ndɨɨ ŋa ǹshi ndɛ mbɨnɨ nthɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A mɛ̄iŋ paanchrɔ ghaŋ younjiŋ pi, nchhu ni pugu ŋa, “Pəɨ līi njəɨ, pia kuʼɔ nu Jerushalɛiŋ, ŋguoŋ nnu ŋa pa njəɨlɨʼɨ Minnwi ni nāʼaŋ thɛ Muuŋ Ŋoŋmishua nɛ lɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pichəɨ ŋgwa shi nchaʼa vi mfɛ mbhɔ ŋgwa pɛ ŋa pugu lɔ njiʼi mbɔ ŋgwa Juu, pi māʼaŋ vi ni kwə̀ɨŋ, ŋgwɛʼi vi, nthu thwɛ mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pi shi ŋgwie vi ni ŋgwàŋ, njwi vi, a gha ndaʼa trɛi llɛ́, a pɨnɨ ŋkuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Thɔ ghaŋ younjiŋ pi shi ki lɔ njiʼi nshie ni nnu pei, pi ni ndə̄ɨŋ vugu ni njiŋ nnu pighɔ, paʼa pugu lɔ nji nnu ŋa a ni nchhu nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","A ni ŋga nyīeŋ mbara Jeriko, nchriligi chəɨ chhɔ ŋkɨŋ shɛndaoŋ nduoŋ nu. ");
INSERT INTO bmo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nchriligi ghɔ gha njaʼo yú ŋgwa tɔgɔ nu, a pie ŋa, “A lɔ̄gɔ khɔ ndɔ̄gɔ lɨʼɨ?” ");
INSERT INTO bmo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pi shwei vi ŋa, “A Jishɔ llɔ Nasharɛ ntɔgɔ nu.” ");
INSERT INTO bmo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A mɛ̄iŋ ni njɨ ŋa, “Jishɔ! Muuŋ Devi! Fāʼo kwoshɨnɨ mbɨŋ mu!” ");
INSERT INTO bmo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ŋgwa pɛ ŋa pugu ni mbɔ shhɨ nɛ pɨ̄ga vi, nchhu ghɔ ŋa, “Lɛrɛ laŋ!” A pɨnɨ mɛ̄iŋ pi ni njɨ ŋa, “Muuŋ Devi, fāʼo kwoshɨnɨ mbɨŋ mu!” ");
INSERT INTO bmo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jishɔ tithi, mfɛ gɨ́ ŋa pi thɔ ni ju. A gha nthɔ mbara yəɨ yu, a pie vi ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ɔ tāʼa nu ŋa ǹchwīe pi nɛiŋ vɛ?” A khwɛ̄ ŋa, “Taathɔ, ǹtāʼa nu mbɨnɨ njəɨ lɨʼɨ!” ");
INSERT INTO bmo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jishɔ chhu ghɔ ŋa, “Pɨnɨ nɛ njəɨ lɨʼɨ! Piŋ yɔ chwīe ghɨ̌nɔ yɔ tɔgɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wuʼɔ chomilaoŋ ghɔ, ligi yi chuʼɔ a yōu njiŋ Jishɔ, nchhɔ ŋgaʼo Minnwi. Yú ŋgwa pighɔ fɔ nɛ gha njəɨ, mfɛ ndighaʼo ni Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jishɔ nii ntiri nu moŋ Jeriko. ");
INSERT INTO bmo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ŋoŋ chəɨ ni mbɔ fɔ, ligi yi pɔ Shakio, mbɔ mmɛŋoŋ pa ghaŋ wɛ̄iŋ taashi, mbɔ ŋgaŋ fàʼo. ");
INSERT INTO bmo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A ni mbaʼo nu nɔ yəɨ nu ŋoŋ ŋa Jishɔ yie nɛ, nthɛ ŋa ŋgwa ni njiɛŋ fɔ nɛ, paʼa a lɔ njiʼɛ ghɔ nthɛ ŋa a ni mbɔ ŋoŋ kwikwiʼi. ");
INSERT INTO bmo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nthɛ yie ghɔ, a tei ŋgə̄ɨ shhɨ ŋkuʼɔ ŋkuoŋ thɨ shikamoo nnɛ ŋa a yəɨ Jishɔ, nthɛ ŋa Jishɔ shi ntɔgɔ pi ŋgei ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jishɔ gha nthɔ nchəɨŋ nɔ lɨʼɨ ghɔ, ndīi tɔthɨ nchhu ŋa, “Shakio, kɔnɔ nshwiʼi shhɛ, nthɛ ŋa a yiʼi ŋa ndaʼa nda ghɔ shiʼa.” ");
INSERT INTO bmo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A kɔnɔ nshwiʼi shhɛ, mbɔ ni pwanjuʼɔ nɔ chhu nu ghɔ ŋa a thɔ a pwa. ");
INSERT INTO bmo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ŋguoŋ pa ŋgwa pɛ ŋa pugu ni njəɨ nɛ jɛ̄ luo nu, nchhu nu ŋa, “Ŋoŋ yei ghə̄ɨ nu mbɔ ŋgaŋ kra nda nchwīe phɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Shakio tithi tɔthɨ nchhu ni Taathɔ ŋa, “Līi njəɨ, Taathɔ, ǹshi mfɛ ghrà ndɨndɨ maoŋ paŋ ni ghaŋ pou, ti shesheŋoŋ ŋa mi ni nchīgi vi nɛ, ǹshi nduʼu ghɔ khwɛ lɨʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jishɔ chhu ghɔ ŋa, “Shiʼa, lūgu nu thɔ nda hɛiŋ nthɛ ŋa ŋoŋ vei ŋkaa yu muuŋ Abrahaŋ. ");
INSERT INTO bmo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nthɛ ŋa Muuŋ Ŋoŋmishua ni nthɔ nɔ tāʼa nu ndɔ ŋkwe ŋgwa pɛ ŋa pugu phɛ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nɔ haʼaŋ pugu ni nthɔ njwɛrɛ chrà yei nɛ, Jishɔ ghə̄ɨ shhɨ nɔ chhu nu luʼɔ chrà ni pugu. Nthɛ ŋa a ni ŋkwo para Jerushalɛiŋ nɛ, pugu pa ŋa ŋgwa pighɔ ni mbiʼi ŋa Minnwi shi nshaʼa nɔ fùoŋ chomilaoŋ ghɔ nɛ ");
INSERT INTO bmo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","a chhu kiʼɛ ŋa, “Ŋoŋ ndiɛŋ chəɨ ni ŋgə̄ɨ fie laʼataoŋ chəɨ, ŋgə̄ɨ njɨ lə̌ɨ fùoŋ ŋkwəɨ shaʼa laʼa yugu. ");
INSERT INTO bmo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ŋkaoŋ a ni maa ŋgə̄ɨ, a mɛ̄iŋ wuŋ puoŋ fàʼa pi, mfɛ ŋkiɛŋ ntou mbɨŋ ni pugu nchhu ni pugu ŋa, ‘Pəɨ tiʼi nthɔ mbiʼɛ taŋ nɔ ghɔ ti ǹshi nuʼuŋ ŋkwəɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ndɔ ŋgwa pi pɨ̄na vi pɨ̄na. Nthɛ yie ghɔ, pugu taoŋ ghaŋ ntaoŋ njiŋ yu ŋa pugu ghə̄ɨ nchhu ŋa, ‘Pigi lɔ njiʼi ntāʼa nu ŋa ŋoŋ vei pɔ fùoŋ vigi.’ ");
INSERT INTO bmo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ndɔ pi wuʼɔ nchərə vi chərə nɔ fùoŋ. A gha mbɨ̄nɨ, ŋgɛ̄ puoŋ fàʼa pi pɛ ŋa a ni mfɛ mbɨŋ ni pugu ŋa pugu piʼɛ taŋ nɔ nɛ, nnɛ ŋa a nthɛ a ji fɨʼɨ shéi yɛ ŋa pugu fāʼo nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Fǔoŋ muuŋ fàʼa thɔ nchhu ŋa, ‘Taathɔ, mbɨŋ yɛ ŋa ɔ ni mfɛ vəɨ nɛ shei wuŋ lɨʼɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ŋoŋ ndiɛŋ ghɔ chhu ghɔ ŋa, ‘Ɔ ya mfāʼa, ma muuŋ fàʼa a yi shishiʼi, nthɛ ŋa ɔ tɔgɔ ndaoŋ ntou moŋ puoŋ mi nnu nɛ, m̀fɛ ghrɨ́ vɛ ŋa ɔ shaʼa wuŋ laʼataoŋ a.’ ");
INSERT INTO bmo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Mbra yi thɔ nchhu ŋa, ‘Taathɔ, mbɨŋ yɛ ŋa ɔ ni mfɛ vəɨ nɛ shei tiɛŋ lɨʼɨ.’ ");
INSERT INTO bmo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Taathɔ vi ghɔ khwɛ̄ ghɔ ŋa, ‘Kwe tiɛŋ laʼataoŋ nshaʼa nu.’ ");
INSERT INTO bmo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nɛnnɛ, yichəɨ muuŋ fàʼa thɔ, nchhu nu ŋa, ‘Taathɔ, mbɨŋ yɔ pɔ nɛiŋ, ŋki krao moŋ pra ndhwí nūʼɔŋ, ");
INSERT INTO bmo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","nthɛ ŋa ŋki pɔgɔ, nthɛ ŋa ɔ ŋkiɛŋ ŋoŋ tɨtɨnɨ. Ɔ ghà ndɔ̄gɔ lɨʼɨ ŋa ɔ shi ki lɔ nūʼɔŋ, ŋkwōo lɨʼɨ ŋa ɔ shi ki lɔ mbhi.’ ");
INSERT INTO bmo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Taathɔ vi chhu ghɔ ŋa, ‘Muuŋ fàʼa mbɨmbhɨ vei! Ǹshi ndɔ̄gɔ chrà yɔ ŋkrao ghɔ nɔ ghɔ! Ɔ ya nji ŋa mi ŋoŋ tɨtɨnɨ, ŋkwe yaoŋ ŋa a lɔ mbɔ nyaŋ nɛ, ŋkwōo lɨʼɨ ŋa ǹshi ki lɔ mbhī nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","A ni nchwīe khɔ kiʼɛ paʼa ɔ lɔ niʼiŋ mbɨŋ a moŋ bəɨŋ? Nji ŋa ǹshi ŋga ŋkwəɨ, ŋ̀kwe pugu pa thɔ yi?’ ");
INSERT INTO bmo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nɛnnɛ nchhu ni ŋgwa pɛ ŋa pugu ni nthi fɔ nɛ ŋa, ‘Pəɨ kwe mbɨŋ ghɔ mbhɔ yu, mfɛ ni muuŋ fàʼa yɛ ŋa a ni nshei wuŋ lɨʼɨ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ndɔ pugu chhu ghɔ ŋa, ‘Taathɔ, kwaʼa a kwo shei wuŋ lɨʼɨ?’ ");
INSERT INTO bmo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Fùoŋ ghɔ khwɛ̄ ŋa, ‘Ǹshwei vəɨ, shesheŋoŋ ŋa a kwo fāʼo nɛ, pi shi mbīgi ntou yi ghɔ, ndɔ ti ni ŋoŋ yɛ ŋa a lɔ njiʼi mfāʼo nɛ pi shi ŋkwe shɨgɛi yɛ ŋa a fāʼo nɛ mbhɔ yu. ");
INSERT INTO bmo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ndɔ ndwɛ pa mbɨ̌na paŋ pɛ ŋa pugu shini ndɔ ntāʼa nu ŋa m̀bɔ fùoŋ vugu nɛ, pəɨ wɛ̄iŋ vugu nthɔ nsho vugu ligi mu.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jishɔ ni ŋga nchhu yei nnu ti mīʼɛŋ, ŋgwɛ̄iŋ ndaoŋ ŋgə̄ɨ nu shhɨ, ŋkuʼɔ nu Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","A ni ŋga nyīeŋ ti mbara Bɛfɛgɛ pugu Betani ŋkuoŋ mbra ŋa pi mɛ̄iŋ ni Olive nɛ, ntaoŋ paa ghaŋ younjiŋ pi, ");
INSERT INTO bmo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nchhu nu ŋa, “Pəɨ ghə̄ɨ moŋ muuŋ laʼataoŋ yini shhɨ pəɨ nɛ, pəɨ shi njəɨ muuŋ ŋkwɛ́iŋ ŋa ŋoŋ lɔ naa ma ŋkuʼɔ nɛ, pi chu fɔ, pəɨ kɨ̄gɛi nthɔ nɔ hɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","S̈hesheŋoŋ mbie vəɨ ŋa, ‘Pəɨ kɨ̄gɛi nu ŋa?’ pəɨ chhu ŋa, ‘Taathɔ fāʼo fàʼa nɔ ghɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nɛnnɛ ŋgwa pighɔ ŋa a ni ntaoŋ vugu nɛ ghə̄ɨ ŋguʼɔ njəɨ ŋguoŋ nnu pi ŋkwaŋ haʼaŋ a ni nshwei vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nɔ haʼaŋ pugu ni nthɔ mfēi muuŋ ŋkwɛ́iŋ ghɔ nɛ, ŋgwa pɛ ŋa minyieŋ ghɔ ni mbɔ yugu nɛ pie ŋa, “Pəɨ fēi nu ŋa?” ");
INSERT INTO bmo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pugu khwɛ̄ ŋa, “Taathɔ fāʼo fàʼa nɔ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pugu lɔ̄gɔ muuŋ ŋkwɛ́iŋ ghɔ ŋgə̄ɨ fɛ ni Jishɔ, ŋga nshɛ̄iŋ ndhwí pugu ŋkuoŋ ghɔ, ŋgɛ̄rɛ Jishɔ a kuʼɔ nchhɔ ŋkuoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nɔ haʼaŋ a ni nchhɔ ŋkuoŋ ghɔ nyīeŋ ŋgə̄ɨ nu nɛ, pa ŋgwa shɛ̄iŋ pa mɛmmɛ ndhwí pugu shɛndaoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ndɨɨ ŋa a ni nyīeŋ mbara Jerushalɛiŋ nɛ, nɔ lɨʼɨ ŋa shɛndaoŋ shwiʼi laʼo Mbra pa Thɨ Olive nɛ, mmɛ kɨrɨ ghaŋ younjiŋ pi jɛ̄ nthɔ ntōo Minnwi ni njɨ moŋ pwanjuʼɔ nthɛ ŋguoŋ pa nnu ghraoghrao ŋa pugu ni njəɨ nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","nchhu nu ŋa, “Mbɔrɔ pɔ ni Fùoŋ ŋa a thɔ nɔ ligi Taathɔ nɛ, Ghɨghrɨ pɔ po, ndighaʼo pɔ ni Minnwi ti ŋgə̄ɨ nchəɨŋ fie moŋ ndugwi po!” ");
INSERT INTO bmo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pichəɨ pa ŋgwa Farashi moŋ yú ŋgwa pighɔ chhu ni Jishɔ ŋa, “Masha, pɨ̄ga pa ghaŋ younjiŋ pɔ ŋa pugu lɛrɛ laŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jishɔ khwɛ̄ ŋa, “Ǹshwei vəɨ, ŋgwa pei ndɛrɛ laŋ, kaŋ pa ŋgùʼɔ shi nchrā ni njɨ!” ");
INSERT INTO bmo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jishɔ ni ŋga nyīeŋ mbara ti njəɨ moŋ Jerushalɛiŋ ghɔ, ŋkə̄ɨ nthɛ vi, ");
INSERT INTO bmo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nchhu nu ŋa, “Ǹjūa ŋa ɔ kaŋ ni nji shiʼa yaoŋ ŋa a ghà nthɔ ni ghɨghrɨ nɛ, ndɔ ndwɛ, Minnwi chwīe ŋa kiʼi ɔ yəɨ, ");
INSERT INTO bmo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","nthɛ ŋa yichəɨ ndɨɨ thɔ nthɔ nu ŋa pa mbɨ̌na pɔ shi ŋgɨ̄ŋ ghɔ ni ŋkaʼa mbāoŋ, nshwiʼi mbɨŋ ghɔ moŋ ŋguoŋ ŋgei ghao. ");
INSERT INTO bmo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pugu shi nshiʼi ghɔ pəɨ pa mbaanda yɔ. Mbaʼa kaŋ taʼa yaoŋ yiʼi mbɨgəɨ mbhɔ ghɔ, nthɛ ŋa ɔ shini ndɔ nji ndɨɨ ŋa Minnwi ni nthɔ nɔ kwe nu ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jishɔ nii Nda Minnwi, njɛ̄ yōu nu ŋgwa pɛ ŋa pugu ni nthɔ mfīni yaoŋ fɔ nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","nchhu nu ni pugu ŋa, “Pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, ‘Nda a shi mbɔ pi nda luoŋ Minnwi,’ ndɔ pəɨ kara a gū pùo pa ŋgɨna.” ");
INSERT INTO bmo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ŋguoŋ llɛ́ ghao Jishɔ thɔ njɛʼi ŋgwa Nda Minnwi. Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi gɨ́ Mushi pugu pa pichəɨ thishɨ taʼa shɛndaoŋ nɔ jwi nu vi. ");
INSERT INTO bmo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ndɔ paʼa ndɔ mfāʼo shɛndaoŋ, nthɛ ŋa pa ŋgwa ni mfɛ ŋguoŋ tə́nə yugu nthɔ njaʼo ŋguoŋ nnu ŋa a ni nchhu nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Llɛ́ chəɨ, Jishɔ gha mbɔ Nda Minnwi nthɔ njɛʼi nu ndɔ nthɔ nshwei pa pwa pishaʼakhɔ, pa thishɨ ghaŋ fɛʼiŋgiɛŋ Minnwi ni pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa thishɨ thɔ, ");
INSERT INTO bmo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nchhu ghɔ ŋa, “Shwei vigi, ɔ fāʼo pi yəɨ njɨ nɔ chwīe nu pa nnu pei, ki a fɛ gɔ̌ mfɛ njɨ yei vɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jishɔ khwɛ̄ ŋa, “Mummu ǹshi mbie vəɨ ni taʼa nnu. Ndwɛ, pəɨ shwei a, ");
INSERT INTO bmo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","a ni mfɛ Minnwi mfɛ njɨ ni Jouŋ ŋa a fɛ ŋkhǐ ni ŋgwa ki a ni mfɛ ŋgwamishua?” ");
INSERT INTO bmo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pugu pini nnu ghɔ shɨna pugu, nchhu nu ŋa, “P̈ia nchhu ŋa a ni ndhɔ mbhɔ Minnwi, a pie via ŋa, ‘Ti a ni nchwīe khɔ paʼa pia lɔ mbiŋ vi?’ ");
INSERT INTO bmo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ndɔ p̈ia nchhu ŋa, ‘A ni mfɛ ŋoŋmishua njɨ ghɔ’, kaŋ ŋguoŋ pa ŋgwa pei shi ntuŋ via ni ŋgùʼɔ nthɛ ŋa pugu ya nji ni tɨnɨnjuʼɔ ŋa Jouŋ ni mbɔ njəɨlɨʼɨ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nɛnnɛ, pugu chhu ghɔ ŋa, “Pigi lɔ njiʼi nji lɨʼɨ ŋa a ni ndhɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nɛnnɛ Jishɔ chhu ni pugu kiʼɛ ŋa, “Kaŋ m̀baʼa mummu shwei vəɨ ni lɨʼɨ ŋa njɨ ŋa ǹchwīe nnu pei nɔ llɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nɛnnɛ, Jishɔ chhu yei luʼɔ chrà ni pa ŋgwa pɛ ŋa pugu ni ŋkɨrɨ yəɨ yu nɛ: “Ŋoŋ chəɨ ni ma mbhi kèi ntíɛŋ thɨ yi mfɛ ni ghaŋ fàʼa ŋa pugu lɨna nɔ ghɔ, ŋga ŋkwōo, pugu pugu ghrā. Nɛnnɛ, ŋgə̄ɨ kra ndaʼa ntaaŋ ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ndɨɨ ni ŋga ŋkāʼo nɔ kwōo nu ntíɛŋ thɨ ghɔ, mmɛŋoŋ yɛ taoŋ muuŋ fàʼa vi ni pa ghaŋ fàʼa pɛ, ŋa a ghə̄ɨ ŋkwe ji ghrà ntíɛŋ thɨ ghɔ. Pa ghaŋ fàʼa pighɔ wie muuŋ fàʼa vi ghɔ nduʼu vi ni mbhɔ yó. ");
INSERT INTO bmo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A pɨnɨ nuʼuŋ ntaoŋ muuŋ fàʼa nduoŋ, pugu wie vi ŋkaa yu, nshhū vi, ndɔ nduʼu vi ni mbhɔ yó. ");
INSERT INTO bmo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A nuʼuŋ ntaoŋ yichəɨ muuŋ fàʼa vi, a pɔ yi trɛi, pugu lə̄ɨŋ vi, mfuʼu vi moŋ nyìeŋ ghɔ māʼaŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Nɛnnɛ, ŋgaŋ nyìeŋ ghɔ chhu ŋa, ‘Mi shi nchwīe pi nɛiŋ? Ǹshi ntaoŋ taʼa muuŋ a ŋa ŋkhwā nɛ, kəʼɨchəɨ pugu fāʼo pɔgɔ mbɨŋ yu.’ ");
INSERT INTO bmo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ndɔ ndɨɨ ŋa pa ghaŋ fàʼa pighɔ ki yəɨ vi, pugu chhu ni noŋ pugu ŋa, ‘Yei ya muuŋ ŋgaŋ nyìeŋ ghɔ, p̂ia jwi vi nnɛ ŋa a nthɛ nyìeŋ ghɔ gū yia!’ ");
INSERT INTO bmo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pugu fuʼu vi ntaoŋ nɔ moŋ nyìeŋ ghɔ njwi vi.” Jishɔ lūgwi mbie vugu ŋa, “Ti ŋgaŋ nyìeŋ ghɔ shi nchwīe pi khɔ mbɨŋ pa ghaŋ fàʼa pei? ");
INSERT INTO bmo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A shi nthɔ njwi pa ghaŋ fàʼa pei, mfɛ kèi ntíɛŋ thɨ ghɔ ni ŋgwa nduoŋ.” Pa ŋgwa pɛ ŋa pugu ni njwɛrɛ nu nɛ ni ŋga njaʼo nnu yei, nchhu ŋa, “Kiʼi Minnwi ma mieŋ ŋkwaŋ nnu yei.” ");
INSERT INTO bmo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jishɔ tigi ligi yi mbɨŋ pugu nchhu ŋa, “Ti njiŋ chrà Minnwi yei pɔ pi ŋa? ‘Ŋgùʼɔ yɛ ŋa ŋgaŋ nūʼɔŋ nda ni ndāa ŋa a lɔ mfāʼo ghɛ̀rɛ nɛ, pɨnɨ nɛ ŋkara ju mbɔ ndugwi ŋgùʼɔ shiʼi nchaa ŋguoŋ yi.’ ");
INSERT INTO bmo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Shesheŋoŋ ŋa a gu ŋkuoŋ ŋguʼɔ yei shi shɨna kraokrao. Ndɔ ti ä ŋgū ŋgùʼɔ ghɔ mbɨŋ ŋoŋ, a nwīʼiŋ vi.” ");
INSERT INTO bmo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi ni pa thishɨ ghaŋ fɛʼiŋgiɛŋ paʼo nɔ wɛ̄iŋ nu Jishɔ ndɨɨ ghɔ, nthɛ ŋa pugu ni nji ŋa Jishɔ chhu yei luʼɔ chrà pi ni pugu, ndɔ pugu pɔgɔ nnu haʼaŋ pa ŋgwa shi nchwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nɛnnɛ pugu tāʼa shɨ̀na, ntaoŋ pa miyra, ŋa pugu ni mfɨ̄ɨ ŋa pugu ŋgwa ndɨndɨ nɛ, nɛnnɛ ŋa pugu wɛ̄iŋ vi ŋkuoŋ chrà yi, nɔ chaʼa nu vi mfɛ ni ŋoŋ ŋa Roma ni mfɛ ŋa a shaʼa yie ŋgei lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pa miyra pighɔ pie Jishɔ ŋa, “Masha, pigi ji ŋa ɔ ghà nchrā ndɔ njɛʼi nnu ndɨndɨ ki lɔ mbiŋ mbe, ndɔ njɛʼi pi nnu ndɨndɨ ŋa Minnwi tāʼa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Shwei vigi, a kāʼo ŋa pi pe taashi ni Kaisha ki ŋga?” ");
INSERT INTO bmo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jishɔ kwo yəɨ mbe yugu nchhu ni pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“P̂əɨ nōoŋ ndigi mbɨŋ vəɨ. Yei pɔ pi thɔ gɔ̌ pugu ligi gɔ̌ ŋkuoŋ ghɔ?” Pugu khwɛ̄ ŋa, “A yi Kaisha.” ");
INSERT INTO bmo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nɛnnɛ, a khwɛ̄ ni pugu ŋa, “Fɛ yaoŋ Kaisha ni Kaisha. Mfɛ yi Minnwi ni Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Fɔ shhɨ pa ŋgwa, pugu shi ki lɔ mfāʼo sheshe yaoŋ llɔ ŋkuoŋ chrà yi nɔ wɛ̄iŋ nu vi nɔ ghɔ. Nɛnnɛ pugu lɛrɛ laŋ, nja ŋgrāo ŋkwaŋ nɔ haʼaŋ a khwɛ̄ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pa ŋgwa Shadushi, ŋa pugu ni ŋkwāʼa ŋa mbaʼa ŋoŋ khu mbɨnɨ nuʼuŋ ŋkuʼɔ nɛ, thɔ mbara Jishɔ mbie vi ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Masha, Mushi ni nāʼaŋ gɨ́ yei mfɛ ni pigi ŋa, ‘Ndǐŋ ŋoŋ ndaŋ miŋgwɛ ŋkhu ki lɔ mbhi puoŋ, ŋoŋ ghɔ lɔ̄gɔ ŋkugu ndǐŋ vi ghɔ ŋa a khu nɛ mbhi puoŋ nɔ ghɔ nɔ ligi ndǐŋ vi ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pimbia pichəɨ ni mbɔ puŋ nda pugu pi khwachəɨ. Vi shhɨ laŋ ŋkhu ki lɔ mbhi muuŋ, ");
INSERT INTO bmo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","mbra yi lɔ̄gɔ ŋkugu ghɔ ŋguʼɔ ŋkukhu ki lɔ mbhi muuŋ, ");
INSERT INTO bmo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ŋiaŋ mbra yi lɔ̄gɔ ŋkaa yu ŋguʼɔ ŋkukhu, wuʼɔ nnɛ ti ŋguoŋ vugu pi khwachəɨ nuʼuŋ mmɛ ndɔ paʼa kaŋ taʼa ŋoŋ vugu lɔ mbhi puoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A ni ŋga ndugwi nu, miŋgwɛ ghɔ khu ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ndwɛ, moŋ llɛmbhi ŋa ŋgwa ŋa pugu khu ma mbɨnɨ ŋkuʼɔ nɛ, miŋgwɛ vei shi mbɔ pi ŋgwɛ gɔ̌, nɔ haʼaŋ ŋguoŋ vugu pi khwachəɨ ki lɔ̄gɔ vi nɔ ŋgwɛ vugu nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jishɔ chhu ni pugu ŋa, “Ŋgwa mbhi shiʼa laŋ nu ndɔ ŋgə̄ɨ nu nda láŋ. ");
INSERT INTO bmo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ndɔ ŋgwa pɛ ŋa pugu shi ŋkāʼo nɔ pɨnɨ nu nuʼuŋ ŋkuʼɔ ndɨɨ ŋa pugu khu nɛ ndɔ fāʼo chɔmbhi moŋ yɛ mbhi ŋa a shi nthɔ nɛ, mbaʼa pugu ma nuʼuŋ ndaŋ ki ŋgə̄ɨ nda láŋ. ");
INSERT INTO bmo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nthɛ ŋa minthɛ paʼa pugu lɔ ma nuʼuŋ ŋkhu ŋkamuʼɔŋ, nthɛ ŋa pugu pɔ pi nɔ pa ghaŋ ntaoŋ Minnwi ndɔ mbɔ puoŋ Minnwi, mbɔ pa ŋgwa ŋa Minnwi kwo kuʼɔ ni pugu moŋ gu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nɔ pīgi nu, Mushi ni nja nōoŋ ŋa ŋgwa ghà ŋkhu mbɨnɨ nuʼuŋ ŋkuʼɔ. Moŋ lɨʼɨ Ŋwaʼaŋlɨ Minnwi ŋa a chrā nu nthɛ móŋoŋ thɔ muuŋ thɨ yuyuʼu nɛ, Mushi gɛ̄ Taathɔ fɔ ŋa a Minnwi Abrahaŋ, Minnwi Aiji, ni Minnwi Jakɔ. ");
INSERT INTO bmo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Minnwi lɔ mbɔ pi Minnwi ŋgwa haʼaŋ pugu khu nɛ. A pɔ pi Minnwi pa ŋgwa haʼaŋ pugu pi maoŋ nɛ, nthɛ ŋa ni Minnwi, ŋguoŋ ŋgwa pi maoŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pichəɨ pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi khwɛ̄ ŋa, “Masha, ɔ ya nɛ nchrā shishiʼi.” ");
INSERT INTO bmo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nthɛ ŋa pugu shi ki lɔ nuʼuŋ njwɛʼi nɔ pie nu vi ni sheshe nnu. ");
INSERT INTO bmo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jishɔ pie vugu ŋa, “A nthɛ pi kie nɛiŋ nchhu ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, pɔ muuŋ Devi? ");
INSERT INTO bmo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nthɛ ŋa nduthɔ Devi chhu moŋ Ŋwaʼaŋlɨ Ŋkhǐ ŋa, ‘Minnwi Taathɔ chhu ni Taathɔ a ŋa, “Chhɔ hɛiŋ ŋgei mbhɔ a yi jɨ, ");
INSERT INTO bmo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ti ǹshi nuʼuŋ nchwīe pa mbɨ̌na pɔ gū krɨ́ tigi kwò yɔ.” ’ ");
INSERT INTO bmo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ti nɔ haʼaŋ Devi ni mɛ̄iŋ Krishto ghɔ pi ni Taathɔ vi nɛ, a nthɛ a kie pi nɛiŋ Krishto pɨnɨ mbɔ pi muuŋ vi?” ");
INSERT INTO bmo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jishɔ chhu ni ghaŋ younjiŋ pi shhɨ ŋguoŋ ŋgwa ghao ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pəɨ lɨna pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi a pwa. Pugu khwā nɔ nyīeŋ nu moŋ pa mɛmmɛ ndrawaʼa, ndɔ ŋkhwā ŋa pi tuʼu noŋ nchrā ni pugu lɨʼɨ kaʼa, ŋkhwā chhɔ nu nɔ pa lɨʼɨ liɛŋ moŋ nda luoŋ Minnwi pugu pa lɨʼɨ jɨ. ");
INSERT INTO bmo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pugu ghà nchīgi pa piŋgɛ kugu ŋkwe maoŋ pugu, luoŋ Minnwi yugu shɨga ni njɨ nnɛ ŋa ŋgwa yəɨ vugu nɔ pa ŋgwa taoŋtaoŋ. Yugu ŋgəʼɨ shi mbɔ yi wuwuru.” ");
INSERT INTO bmo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jishɔ pɨʼɨ ligi yi njəɨ ŋkwaŋ nɔ haʼaŋ pa ghaŋ fàʼo thɔ niʼiŋ pa maoŋ fɛ pugu moŋ mikuo yaoŋ fɛ́ Nda Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A yəɨ miŋgwɛ ŋkugu chəɨ haʼaŋ a ki ya mbou niʼiŋ paa puoŋ mi mbɨŋ moŋ mikuo. ");
INSERT INTO bmo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nɛnnɛ, Jishɔ chhu ŋa, “Shishini, ǹshwei vəɨ, miŋgwɛ ŋkugu vei ŋa a pɔ pi mbou nɛ fɛ nchaa ŋguoŋ ŋgwa ghao. ");
INSERT INTO bmo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nthɛ ŋa ŋguoŋ ŋgwa nduoŋ fuʼu yaoŋ fɛ́ yugu pi shɨna ntou maoŋ haʼaŋ pugu fāʼo nɛ, ndɔ miŋgwɛ vei moŋ pou yi fɛ ŋguoŋ yaoŋ ŋa a ni mfāʼo nɔ yru nu ŋkuoŋ ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pichəɨ ghaŋ younjiŋ Jishɔ ni nchrā nu nthɛ Nda Minnwi, ŋkwaŋ haʼaŋ pi ni nchwīe vi ni pa ŋgùʼɔ pwapwa pugu pa maoŋ fɛ haʼaŋ pi ki fɛ fɔ nɛ. Jishɔ khwɛ̄ ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ŋguoŋ pa maoŋ pei ŋa pəɨ yəɨ nu nɛ, ndɨɨ thɔ nu ŋa mbaʼa taʼa ŋgùʼɔ yiʼi nuʼuŋ nūaŋ ŋkuoŋ ndǐŋ vi. Pi shi mbūo ghao mfɛ shhɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pa ghaŋ younjiŋ Jishɔ pie vi ŋa, “Masha, yei nnu shi ndɔ̄gɔ lɨʼɨ pi ndɨɨ khɔ? Lì ŋa a shi nōoŋ ŋa ndɨɨ kāʼo ni nnu yei nɔ lɔ̄gɔ nu lɨʼɨ nɛ pɔ pi khɔ?” ");
INSERT INTO bmo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jishɔ chhu ŋa, “Lɨna nu, kiʼi ŋoŋ fɨ̄ɨ vəɨ, nthɛ ŋa ntou ŋgwa lɛ nthɔ nɔ ligi a, nchhu nu ŋa, ‘a mmu mbɔ Krishto ghɔ’, pugu pa ŋa ‘ndɨɨ kāʼo nɛ’, kiʼi njōu njiŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kiʼi pəɨ pɔgɔ ndɨɨ ŋa pəɨ yaʼo ŋa nchhɔ̀ pɔ ki pa yɔ̀yɔnɔ, nthɛ ŋa ŋkwaŋ nnu pinɛ shi ŋguʼɔ ndɔ̄gɔ lɨʼɨ ndɔ paʼa mbhi lɔ ndugwi pi ndɨɨ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nɛnnɛ, Jishɔ chhu ŋa, “Pa laʼataoŋ shi māʼaŋ nchhɔ̀ pugu pa pichəɨ, ŋgwa taʼa fùoŋ māʼaŋ nchhɔ̀ pugu pa ŋgwa vichəɨ fùoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Shhɛ shi nchɨ̄ʼɨ ti shɨna, pa ghɨ̌nɔ pɨphɨ gū lɨlɨʼɨ, pa njì gū, pa nnu wuwuru lɔ̄gɔ lɨʼɨ, pi yəɨ pa mɛmmɛ lì llɔ po. ");
INSERT INTO bmo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ndɔ ŋkaoŋ ŋguoŋ pa nnu pei ma ndɔ̄gɔ lɨʼɨ, pi shi ŋgwɛ̄iŋ vəɨ ŋgūo ŋgəʼɨ mbɨŋ pəɨ. Pi shi ŋɨ vəɨ ŋgə̄ɨ nɔ moŋ pa nda luoŋ Minnwi pugu pa chə́ɨŋ, pi shi ŋgə̄ɨ ni pəɨ shhɨ pa fùoŋ pugu pa ghaŋ sháʼa lɨʼɨ nthɛ ligi a. ");
INSERT INTO bmo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yei shi mfɛ shɨna ni pəɨ nɔ shwei nu pwa pishaʼakhɔ a ni pugu. ");
INSERT INTO bmo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pəɨ nūʼɔŋ moŋ njùʼɔ pəɨ ŋa pəɨ lɔ mfāʼo nɔ wie nu noŋ, ŋkwaŋ nɔ haʼaŋ pəɨ shi ŋkwe thɔ yəɨ nɛ, ŋkaoŋ ndɨɨ maa ŋkāʼo nu. ");
INSERT INTO bmo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nthɛ ŋa ǹshi mfɛ chrà pugu pa shiethɔ ni pəɨ ŋa mbaʼa kaŋ taʼa mbɨ̌na pəɨ yiʼi ŋkāʼo nɔ pəʼɨ nu ki ndāa chrà ghɔ pugu pa shiethɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pa tǎa pəɨ pugu pa lǐŋ pəɨ, ni pa ndaaŋoŋ pəɨ pugu pa taannu pəɨ shi mfīni vəɨ, pi jwi pichəɨ shɨna pəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ŋguoŋ ŋgwa shi mbɨ̄na vəɨ nthɛ a ");
INSERT INTO bmo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ndɔ mbaʼa taʼa ŋgiithɔ yəɨ phɛ. ");
INSERT INTO bmo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Moŋ thi nu a tɨnɨ, pəɨ shi ndūgu. ");
INSERT INTO bmo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ndɨɨ ŋa ɔ yəɨ pa ghaŋ māʼaŋ nchhɔ̀ ghɨ̄ŋ Jerushalɛiŋ mbāoŋ nɛ, ɔ ji ŋa shiʼi nu mi para. ");
INSERT INTO bmo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nɛnnɛ pa ŋgwa ŋa pugu pɔ Judia nɛ tei ŋkuʼɔ ŋkuoŋ pa mbra, pɛ ŋgwa ŋa pugu pɔ moŋ tri laʼa nɛ tei ntaoŋ, pɛ ŋgwa ŋa pugu lɔ njiʼi mbɔ moŋ ghɔ nɛ kiʼi pugu nuʼuŋ nii. ");
INSERT INTO bmo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nthɛ ŋa yei llɛmbhi ŋgəʼɨ ni ŋgwa Ishrae, nɔ chwīe nu nnu haʼaŋ pi ni nāʼaŋ moŋ chrà Minnwi nɛ lɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","A shi mbɔ ŋkiɛŋ wuwuru ŋgəʼɨ ni pa piŋgɛ shūu pugu pa mapuoŋ haʼaŋ pugu thɔ nuʼɔŋ puoŋ moŋ ndɨɨ ghɔ nɛ. Wuwuru ŋgəʼɨ shi mbɔ moŋ laʼataoŋ yei, pɨgɨtua Minnwi shwiʼi mbɨŋ ŋgwa pei. ");
INSERT INTO bmo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pi shi njwi pichəɨ ni kafa, ŋgwɛ̄iŋ pichəɨ ŋgə̄ɨ nɔ moŋ pa chə́ɨŋ nɔ pɔ nu ŋkǔna nchhɔ̀ moŋ pa laʼataoŋ, pa ghɨ̀nɨ shi ŋkie ŋkuoŋ Jerushalɛiŋ ti yugu ndɨɨ ŋa Minnwi nūʼɔŋ nɛ kāʼo. ");
INSERT INTO bmo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Pa lì shi nōoŋ moŋ minaoŋ pugu pa fhú ni fɨ́nəɨ. Ŋgwa pa laʼalaʼa taoŋ shi mbɔ ni fiŋthɔ nthɛ mbaʼaŋkhi ŋa a thɔ ŋgwara nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pɔgɔ gu shi nchwīe njùʼɔ ŋgwa shāna nthɛ pa nnu ŋa pugu ywɛrɛ nu ŋa a thɔ nu ndɔ̄gɔ lɨʼɨ ŋkuoŋ mbhi nɛ, nthɛ ŋa pi shi nchɨ̄ʼɨ pa njɨ haʼaŋ a pɔ moŋ tɔthɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nɛnnɛ, pi shi njəɨ Muuŋ Ŋoŋmishua thɔ shwiʼi nu moŋ tɔthɨ ni njɨ pugu pa mmɛ ndighaʼo. ");
INSERT INTO bmo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ndɨɨ haʼaŋ nnu pei jɛ̄ nthɔ ndɔ̄gɔ lɨʼɨ nɛ, lɔllɔ fēi noŋ yɔ, nthɛ ŋa lūgu nu yɔ para.” ");
INSERT INTO bmo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jishɔ chhu luʼɔ chrà yei ni pugu: “Līi thɨ wùnu pugu pa ŋguoŋ pa thɨ nduoŋ, ");
INSERT INTO bmo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","nɔ haʼaŋ fhɔ̌ yugu nuʼuŋ njɛ̄ tua nu nɛ, ɔ pɛʼi ni noŋ yɔ nji ŋa ŋkwəɨ mbɨ̀ para. ");
INSERT INTO bmo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wuʼɔ nɛnnɛ, ndɨɨ haʼaŋ ɔ shi njəɨ nnu pei lɔ̄gɔ lɨʼɨ nɛ, ɔ ji ŋa Shaʼafuoŋ Minnwi para. ");
INSERT INTO bmo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Shishini, ǹshwei vəɨ, mbaʼa ŋgwrɛiŋoŋ yei yiʼi ntɔgɔ nnu pei maa ndɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Po pugu shhɛ shi ntɔgɔ, ndɔ mbaʼa chrà a ma ntɔgɔ gha. ");
INSERT INTO bmo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pəɨ lɨna nu, kiʼi pəɨ nūʼɔŋ njùʼɔ yəɨ ŋkuoŋ pa jɨ pugu pa nnu nu mbaa ni pa maoŋ ŋkuoŋ ŋgrào mbhi yei pugu fɨ̄ɨ vəɨ, nnɛ ŋa kɛ̄ʼi llɛmbhi ghɔ lɛ ŋgwīʼi vəɨ nɔ haʼaŋ minyieŋ ghà ŋgwīʼi ŋkuoŋ shiʼi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nthɛ ŋa llɛmbhi ghɔ shi nthɔ ŋkuoŋ ŋguoŋ ŋgwa ŋa pugu pɔ ŋkuoŋ shhɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ndɔ lɨna nu ŋguoŋ ndɨɨ, nduoŋ nu ŋa ɔ fāʼo ghrɨ́ nɔ ləʼɨ nu ŋguoŋ nnu pei ŋa a shi ndɔ̄gɔ lɨʼɨ nɛ, nnɛ ŋa mimfɛ ɔ thi shhɨ Muuŋ Ŋoŋmishua.” ");
INSERT INTO bmo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jishɔ ni njɛʼi nu ŋguoŋ llɛmbhi ghao moŋ Nda Minnwi, ndɔ tuʼu gha mbɔ, a kuʼɔ ŋkuoŋ mbra ŋa pi mɛ̄iŋ ni Olive nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ŋkiɛŋ ni muuŋ tutuʼu, ŋguoŋ ŋgwa kɨrɨ yəɨ yu moŋ Nda Minnwi nɔ yaʼo nu ntɨ́gɨ mbhɔ yu. ");
INSERT INTO bmo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ndɨɨ jɨ mmɛ llɛ́ brɛi ki kuʼɔ ni ŋga mbara nu, mbɔ mmɛ llɛ́ ŋa pi mɛ̄iŋ ni Lli Njiʼa nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi thɔ ntāʼa shɛndaoŋ nɔ jwi nu Jishɔ njiŋnjiŋ nthɛ ŋa pugu ni nchhɔ mbɔgɔ nnu ŋa ŋgwa shi nchwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Judashi, ŋa pi ni mɛ̄iŋ vi ni Ishikario nɛ, ŋa a ni mbɔ taʼa ŋoŋ shɨna paanchrɔ ghaŋ younjiŋ Jishɔ nɛ, mieŋ noŋ yi Shata nii nùʼɔŋ yu. ");
INSERT INTO bmo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A ghə̄ɨ mbara pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ kɛ̄ʼi Nda Minnwi, nchrā pugu pugu ŋkwaŋ haʼaŋ minthɛ a fɛ Jishɔ ni pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Túa yugu ni mbwa. Pugu chrā ŋa pugu shi mfɛ mbɨŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nɛnnɛ, a piŋ nthɔ ntāʼa shɨna kiʼɛ ŋkwaŋ haʼaŋ minthɛ a fīni vi ni pugu lɨʼɨ haʼaŋ ntou ŋgwa lɔ njiʼi mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Llɛ́ jɨ brɛi ki kuʼɔ ni ŋga nthɔ, mbɔ llɛ́ ŋa a ki pie ŋa pi jwi minjɨɨ jɨ Lli Njiʼa nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jishɔ taoŋ Pita pugu Jouŋ, nchhu nu ni pugu ŋa, “Pəɨ ghə̄ɨ mbīri yia maoŋ jɨ Lli Njiʼa nnɛ ŋa minthɛ pia jɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pugu pie vi ŋa, “Ɔ tāʼa nu ŋa pigi pīri pi hɨŋ?” ");
INSERT INTO bmo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A chhu ni pugu ŋa, “Ndɨɨ ŋa pəɨ shi nii moŋ laʼa Jerushalɛiŋ nɛ, pəɨ shi njəɨ mimbia, a tiɛŋ ŋkhǐ moŋ kɨ̌ŋ nchíʼa. Pəɨ yōu njiŋ yi, pəɨ pugu ghə̄ɨ nda ŋa a shi nii fɔ nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","nchhu ni ŋgaŋ nda ghɔ ŋa, ‘Masha chhu ŋa pi pie ghɔ ŋa, “Njiɛŋ nda pa ghɨ̀nɨ pɔ pi hɨŋ, ŋa minthɛ pigi pa ghaŋ younjiŋ paŋ jɨ Lli Njiʼa fɔ?” ’ ");
INSERT INTO bmo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A shi nōoŋ mmɛ njiɛŋ nda tɔthɨ ni pəɨ ŋa pi kwo chwīe, pəɨ pīri jɨ Lli Njiʼa ghɔ fɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pugu lɔllɔ ŋgə̄ɨ, njəɨ ŋguoŋ yaoŋ wuʼɔ ŋkwaŋ haʼaŋ a ni nshwei vugu nɛ, mbīri maoŋ jɨ Lli Njiʼa ghɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ndɨɨ ni ŋga nthɔ, Jishɔ chɔchɔ yəɨ taprɛi pugu pa ghaŋ ntaoŋ pi, ");
INSERT INTO bmo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","nchhu ni pugu ŋa, “Mi ni ŋkwo ya nthɔ ntāʼa nu nɔ jɨ nu Lli Njiʼa yei pia ŋkaoŋ maa njəɨ ŋgəʼɨ. ");
INSERT INTO bmo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mbaʼa ǹjiʼi nuʼuŋ mbɨnɨ njɨ maoŋ pei pia ti ŋgə̄ɨ nchəɨŋ ndɨɨ ŋa njiŋ yi lɔ̄gɔ lɨʼɨ nɛ, ndɨɨ ŋa Minnwi shi nshaʼa fùoŋ yi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A lɔ̄gɔ ndua làʼo, ŋga ntōo Minnwi, nchhu ŋa, “Pəɨ kwe yei ŋgrā shɨna pəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Shishini, ǹchhu ni pəɨ ŋa jɛ̄ ndwɛ ŋgə̄ɨ nu shhɨ, m̀baʼa nuʼuŋ nnu làʼo yei, ti Shaʼafuoŋ Minnwi thɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A lɔ̄gɔ brɛi, ŋga ntōo Minnwi, mbəʼɨ, mfɛ ni pugu, nchhu nu ŋa, “Yei frɛinoŋ a ŋa pi fɛ ni pəɨ. Pəɨ chwīe nɛiŋ nɔ kwiŋ nu ma.” ");
INSERT INTO bmo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wuʼɔ nɛnnɛ, a pɨnɨ ndɔ̄gɔ ndua ndɨɨ ŋa pugu ni ŋkwo kru nɛ, nchhu nu ŋa, “Ndua làʼo yei nōoŋ kɨ̀na fhi ŋa Minnwi wrā moŋ chhǐ a ŋa pi shi ŋkwrī nthɛ vəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ndɔ līi njəɨ, ŋoŋ ŋa a shi mfīni a nɛ, mbhɔ yigi yu pɔ ŋkuoŋ taprɛi. ");
INSERT INTO bmo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nthɛ ŋa Muuŋ Ŋoŋmishua shi ŋguʼɔ ŋgə̄ɨ pi ŋkwaŋ haʼaŋ Minnwi ni nūʼɔŋ nɛ, ndɔ ŋgəʼɨ wuwuru shi nii ŋoŋ ŋa a fīni vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pa ghaŋ younjiŋ pi jɛ̄ mbie noŋ pugu ŋa a yəɨ ŋoŋ shɨna pugu ŋa a shi nchwīe yei nnu. ");
INSERT INTO bmo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mindoundou gū shɨna pugu ŋa a gɔ̌ ŋa minthɛ pi līi vi nɔ ŋoŋ ndiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jishɔ chhu ni pugu ŋa, “Pa fùoŋ ŋkuoŋ mbhi hɛiŋ ghà nshaʼa ŋgwa pugu shaʼa, ndɔ pa ŋgwa pei wuʼɔ mɛ̄iŋ pa fùoŋ pighɔ pi ni tǎa ghaŋ ghɛ̄rɛ vugu. ");
INSERT INTO bmo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ndɔ ni pəɨ, a lɔ njiʼi mbɔ pi nnɛ, a ka pie pi ŋa ŋoŋ ndiɛŋ shɨna pəɨ gɛ mi pɔ nɔ mikəʼɨ, nthishɨ pɔ nɔ muuŋ fàʼa. ");
INSERT INTO bmo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A gɔ̌ mbɔ ŋoŋ ndiɛŋ, ŋoŋ ŋa a chɔchɔ ŋkuoŋ taprɛi nɛ ki muuŋ fàʼa? A lɔ mbɔ pi ŋoŋ ŋa a chhɔ ŋkuoŋ taprɛi nɛ? Ndɔ m̀bɔ shɨna pəɨ pi nɔ muuŋ fàʼa. ");
INSERT INTO bmo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pəɨ lɔ njiʼi mīʼaŋ a moŋ ndɨɨ ŋa mōoŋ nu thɔ vəɨ nɛ, ");
INSERT INTO bmo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","wuʼɔ nɔ haʼaŋ Tǎa a fɛ ghrɨ́ vəɨ nɔ shaʼa nu nɛ, m̀fɛ ni pəɨ ŋkaa mu, ");
INSERT INTO bmo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nɛnnɛ ŋa pəɨ shi njɨ ndɔ nnu ŋkuoŋ taprɛi a moŋ Shaʼafuoŋ a, ndɔ nchhɔ ŋkuoŋ pa faaŋ nshaʼa ŋgwa paanchrɔ taoŋ Ishrae. ");
INSERT INTO bmo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Shemu, Shemu, līi njəɨ! Shata kwo luoŋ shɨna mbhɔ Minnwi nɔ krū nu vəɨ nɔ haʼaŋ pi ghà ŋkrū prupɨna nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ndɔ ŋ̀kwo luoŋ Minnwi mfɛ vɛ, ma Shemu, ŋa kiʼi piŋ yɔ chɨ̄ʼɨ. Ndɨɨ ŋa ɔ pɨnɨ ŋkwəɨ njəɨ a nɛ, ɔ māʼaŋ ghrɨ́ lǐŋ pɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita khwɛ̄ ŋa, “Taathɔ, m̀bīri noŋ a ŋa pɔgɔ shi ŋguʼɔ ŋgə̄ɨ chə́ɨŋ kaʼa, ŋkhu kaʼa.” ");
INSERT INTO bmo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jishɔ khwɛ̄ ghɔ ŋa, “Pita, ǹshwei ghɔ, mbaʼa miŋkəʼɨ khwɛ shiʼa ki ɔ lɔ nchhu ni trɛi ŋgɛ́ ŋa ɔ lɔ njiʼi nji a.” ");
INSERT INTO bmo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jishɔ pɨnɨ nchhu ni pugu ŋa, “Ndɨɨ ŋa mi ni ntaoŋ vəɨ ki pəɨ lɔ ntuo pìɛŋ mbɨŋ, ki lɔ ntuo pìɛŋ, ki tra, pəɨ ni mbou yaoŋ?” Pugu ŋa, “Ŋga.” ");
INSERT INTO bmo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A pɨnɨ nchhu ŋa, “Ndɔ ti ndwɛ, ŋoŋ ŋa a fāʼo mbɨŋ nɛ lɔ̄gɔ pugu pìɛŋ. Ŋoŋ ŋa a lɔ njiʼi mfāʼo kafa nɛ, fīni ndhwí fɨgəɨ yi njuoŋ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nthɛ yie ghɔ, ǹchhu ni pəɨ ŋa chrà Minnwi yei ŋa pi nāʼaŋ ŋa, ‘pi shia vi shɨna ghaŋ chwīe phɨ nɛ,’ shi ŋguʼɔ ndɔ̄gɔ lɨʼɨ mbɨŋ mu nthɛ ŋa pa nnu pɛ ŋa pi nāʼaŋ nthɛ a nɛ thɔ ŋguʼɔ ndɔ̄gɔ lɨʼɨ ŋkwaŋ haʼaŋ pi ni nāʼaŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pa ghaŋ younjiŋ pi chhu ghɔ ŋa, “Taathɔ, līi njəɨ paa kafa pɔ nɛiŋ.” A chhu ni pugu ŋa, “Yinɛ chrà lūgwi nnɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jishɔ taoŋ moŋ laʼa ŋkwaŋ haʼaŋ a ghà mbīgi ntaoŋ nɛ, ŋgə̄ɨ ŋkuoŋ Mbra pa Thɨ Olive pugu pa ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ŋga nchəɨŋ fɔ, nchhu ni ghaŋ younjiŋ pi ŋa, “Pəɨ luoŋ Minnwi nnɛ ŋa kiʼi pəɨ gū moŋ mōoŋ nu.” ");
INSERT INTO bmo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nchənə ndɔllɔ ti ŋgə̄ɨ nchəɨŋ fɨʼɨ lɨʼɨ ŋa ŋoŋ māʼaŋ ŋgùʼɔ a chəɨŋ nɛ, ŋkwi kwɛ́rɛ yi shhɛ nduoŋ Minnwi ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tǎa a, a mbɔ khwatua yɔ,ɔ pəɨ ndua ŋgəʼɨ pɨphɨ yei ki ǹdɔ nnu. Ndɔ ti kiʼi a pɔ pi nɔ haʼaŋ ǹtāʼa nu nɛ, a pɔ nɔ haʼaŋ ɔ tāʼa nu ŋa a pɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yichəɨ ŋgaŋ ntaoŋ Minnwi llɔ po nthɔ māʼaŋ ghrɨ́ yi moŋ yúʼɔ ghɔ, ");
INSERT INTO bmo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","a luoŋ Minnwi ni njɨ ti lie yi taoŋ mbɔ nɔ chhǐ nchəɨŋ nu shhɛ. ");
INSERT INTO bmo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A gha mīʼɛŋ luoŋ nu, ŋgə̄ɨ mbara pa ghaŋ younjiŋ pi pugu llɛ nu nthɛ yuʼɔ njùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A pie vugu ŋa, “Pəɨ llɛ pi khɔ? Pəɨ lɔllɔ tɔthɨ nduoŋ Minnwi nnɛ ŋa kiʼi pəɨ gū moŋ mōoŋ nu.” ");
INSERT INTO bmo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","A gha ŋguʼɔ nchrā nu nɛ, yú ŋgwa chəɨŋ, ŋoŋ chəɨ, ligi yi pɔ Judashi, ŋa a ni mbɔ taʼa ŋoŋ shɨna paanchrɔ ghɔ, pɔ ju shhɨ. Nchənə nthɔ yəɨ Jishɔ mbaŋ vi nɔ chrā nu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ndɔ Jishɔ chhu ghɔ ŋa, “Judashi, ɔ shi mfīni a, Muuŋ Ŋoŋmishua, ni paŋ nu ma nɔ chrā nu?” ");
INSERT INTO bmo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pa ŋgwa pɛ ŋa pugu ni mbɔ yəɨ yu nɛ gha njəɨ nnu ŋa a tāʼa nu ndɔ̄gɔ lɨʼɨ nɛ, nchhu ghɔ ŋa, “Taathɔ, p̂igi shua kafa nshāaŋ vugu nɔ?” ");
INSERT INTO bmo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yichəɨ taʼa yi shɨna pugu che tə́nə ŋgei mbhɔ jɨ muuŋ fàʼa taʼa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jishɔ chhu ŋa, “Kiʼi pəɨ nuʼuŋ nchwīe!” Ŋkāoŋ tə́nə muuŋ fàʼa ghɔ, a tɨnɨ. ");
INSERT INTO bmo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nɛnnɛ, Jishɔ chhu ni pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ kɛ̄ʼi Nda Minnwi pugu pa thishɨ ŋa pugu ni nthɔ nu ŋgwɛ̄iŋ vi nɛ ŋa, “M̀bɔ pi ŋgɨna minwi ŋa pəɨ thɔ nu ŋgwɛ̄iŋ ni pa kafa pugu pa wrɛ́i? ");
INSERT INTO bmo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ŋguoŋ llɛ́ ghao pia pɔ nu moŋ Nda Minnwi, paʼa pəɨ lɔ mbaʼo nɔ wɛ̄iŋ nu ma. Ndɔ yei ndɨɨ yəɨ pugu pa yi njɨ moŋ njiŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nɛnnɛ, pa ghaŋ kɛ̄ʼi Nda Minnwi wɛ̄iŋ vi ŋgə̄ɨ ni ju nda taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ. Pita yōu njiŋ yugu ndɔ mbɔ pi fie njiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pugu ni ŋga mfrəɨ móŋoŋ moŋ titri yɨna, ti ŋkɨrɨ nchɔchhɔ kaʼa, Pita chhɔ shɨna pugu. ");
INSERT INTO bmo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Taʼa muuŋ fàʼa mbɔ miŋgwɛ, ni ŋga njəɨ Pita a chhɔ yəɨ móŋoŋ ghɔ, a ya ligi yi mbiŋ yu, nchhu ŋa, “Ŋoŋ vei ni mbɔ pugu Jishɔ ŋkaa yu.” ");
INSERT INTO bmo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","A lāa, nchhu nu ŋa, “Maa, ǹdɔ njiʼi nji vi!” ");
INSERT INTO bmo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A gha ndara, yichəɨ ŋoŋ pɨnɨ nuʼuŋ njəɨ vi, nchhu ŋa, “Ɔ taʼa pakwo pi!” Pita chhu ŋa, “Tǎa, ǹdɔ njiʼi mbɔ taʼa ŋoŋ vugu!” ");
INSERT INTO bmo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A ni ŋga nuʼuŋ njunu, yichəɨ ŋoŋ pɨnɨ nuʼuŋ njəɨ vi, ntīi nu ŋa, “Shishini, ŋoŋ vei ni mbɔ pugu Jishɔ nthɛ ŋa, a llɔ Galili ŋkaa yu!” ");
INSERT INTO bmo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ndɔ Pita khwɛ̄ ŋa, “Tǎa, ǹdɔ njiʼi nji nnu haʼaŋ ɔ thɔ nchhu nu nɛ!” Nɔ haʼaŋ Pita ni ŋguʼɔ nchrā nu nɛ, miŋkəʼɨ khwɛ. ");
INSERT INTO bmo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Taathɔ kara mbɛʼi Pita. A kwiŋ chrà Taathɔ, ŋkwaŋ haʼaŋ a ni nchhu ghɔ ŋa, “Ŋkaoŋ miŋkəʼɨ maa ŋkhwɛ̄ shiʼa, ɔ shi ndāa a ni trɛi ŋgɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nɛnnɛ, Pita taoŋ mbhi ŋkə̄ɨ a ghaʼa. ");
INSERT INTO bmo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pa ŋgwa ŋa pugu ni ŋkɛ̄ʼi Jishɔ nɛ ni njɛ̄ māʼaŋ nu vi ni kwə̀ɨŋ ndɔ mbɨnɨ nthɔ ŋgwie vi. ");
INSERT INTO bmo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pugu ni ŋkrao ligi yi ni ndhwí, mbie vi ŋa, “Nɔ njəɨlɨʼɨ, shwei vigi ni ŋoŋ ŋa a wie ghɔ nɛ!” ");
INSERT INTO bmo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pugu ni nthɔ mbɨnɨ nchhu pichəɨ ntou pa nnu, ŋgwɛʼi vi. ");
INSERT INTO bmo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mbhi ni ŋga ndaŋ, pi lɔ̄gɔ Jishɔ ŋgə̄ɨ nɔ shhɨ kɨrɨ pa thishɨ, mbɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi. Pugu chhu ghɔ ŋa, ");
INSERT INTO bmo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ɔ̈ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, ɔ chhu ni pigi.” Jishɔ khwɛ̄ ŋa, “M̈i nshwei vəɨ paʼa pəɨ lɔ mbiŋ, ");
INSERT INTO bmo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ndɔ mi mbie vəɨ ni taʼa nnu, paʼa pəɨ lɔ mfāʼo khwɛ̀. ");
INSERT INTO bmo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ndɔ llɔ ndwɛ ŋgə̄ɨ nu shhɨ pi shi nchərə Muuŋ Ŋoŋmishua ŋgei mbhɔ jɨ Minnwi ŋa a fāʼo ŋguoŋ ghrɨ́ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nɛnnɛ ŋguoŋ yugu pie vi ŋa, “Yie nōoŋ ŋa ɔ pɔ Muuŋ Minnwi?” A chhu ŋa, “Pəɨ chhu ŋa mi yie.” ");
INSERT INTO bmo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nɛnnɛ, pugu chhu ŋa, “Pia nuʼuŋ ntāʼa pi khɔ ndwɛ njaʼo, pia yaʼo ni noŋ yia llɔ mbhɔ yu.” ");
INSERT INTO bmo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ŋguoŋ kɨrɨ pa thishɨ pighɔ yrɛi ndɔ̄gɔ Jishɔ ŋgə̄ɨ nɔ shhɨ Pailɛ, ");
INSERT INTO bmo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","nchhu pa nnu thɔ yu ŋa, “Ŋoŋ yei thɔ nthɔ nu ni tɨtɨnɨ minduoŋnduoŋ shɨna ŋgwa pigi, ndāa nu ŋa kiʼi pigi māʼaŋ taashi ni Kaisha, ndɔ nchhu nu ŋa ju nduthɔ yi, Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, mbɔ fùoŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailɛ pie vi ŋa, “Ɔ fùoŋ pa Juu?” A khwɛ̄ ghɔ ŋa, “A haʼaŋ ɔ chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailɛ chhu ni pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa yú ŋgwa pighɔ ŋa, “Ǹdɔ njəɨ fàŋ ŋoŋ vei.” ");
INSERT INTO bmo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pugu wuʼɔ mfrafra, nchhu nu ŋa, “A niʼiŋ puŋ ŋgwa ni yaoŋ ŋa a yɛʼi nu nɛ moŋ ŋguoŋ Judia, llɔ Galili ti nthɔ nchəɨŋ hɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailɛ ni njaʼo mbie ŋa, “Ŋoŋ vei llɔ pi Galili?” ");
INSERT INTO bmo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A ni ŋga njaʼo ŋa Jishɔ llɔ pi moŋ yɛ lɨʼɨ ŋa a shaʼa fùoŋ Hɛrɔ nɛ, a taoŋ vi ghɔ. Hɛrɔ ni mbɔ Jerushalɛiŋ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ndɨɨ ŋa Hɛrɔ ni njəɨ Jishɔ nɛ, mfāʼo ntou pwatua, nthɛ ŋa a ni ŋkwo thɔ njaʼo ntou pa nnu nɔ ligi yi ŋkhwā nu nɔ yəɨ nu vi. A ni ŋkhwā nu nɔ yəɨ nu, a chwīe pa nnu ghraoghrao. ");
INSERT INTO bmo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nthɛ yie ghɔ, a tou vi ŋkiɛŋ ntou yi, ndɔ paʼa Jishɔ lɔ ŋkhwɛ̄. ");
INSERT INTO bmo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi taoŋ shhɨ ntigi ntou pa nnu thɔ yu. ");
INSERT INTO bmo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hɛrɔ pugu pa ghaŋ nchhɔ̀ pi ni ŋga nshhū vi ndɔ māʼaŋ vi ni kwə̀ɨŋ, ndɔ̄gɔ pɨ̀rɨ māʼaŋ mbɨŋ yu mbɨnɨ nduʼu vi ni Pailɛ. ");
INSERT INTO bmo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hɛrɔ pugu Pailɛ gū pa taannu yua ghɔ nthɛ ŋa pugu ni mfǔoŋ mbɔ pi ni kipɨna. ");
INSERT INTO bmo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailɛ kɨrɨ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ sháʼa, ni pa ŋgwa gha, ");
INSERT INTO bmo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nchhu ni pugu ŋa, “Pəɨ thɔ ni ŋoŋ vei hɛiŋ nchhu ŋa a thɔ nchwīe nu ŋgwa tɨnɨthɔ, ŋ̀ga ntou vi shhɨ pəɨ, paʼa ndɔ njəɨ a fàŋ sheshe nnu moŋ ŋguoŋ pa nnu ŋa pəɨ wɛ̄iŋ vi nɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ndɔ paʼa Hɛrɔ lɔ njəɨ ŋkaa yu, nnɛ a pɨnɨ nduʼu vi ni pia. Nɔ haʼaŋ pəɨ yəɨ nɛ, a lɔ njiʼi nchwīe yichəɨ nnu ŋa a pie ŋa pi jwi vi, ");
INSERT INTO bmo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","nthɛ yie ghɔ, ǹshi ŋguʼɔ ŋgwie vi wie, mieŋ vi a ghə̄ɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sheshe llɛ́ jɨ Lli Njiʼa Pailɛ ghà nchuʼɔ taʼa ŋgaŋ chə́ɨŋ nɔ ligi yugu. ");
INSERT INTO bmo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ŋguoŋ kɨrɨ ŋgwa paʼo ŋgòu ŋa, “Jwi vi, nchuʼɔ Baraba mfɛ ni pigi!” ");
INSERT INTO bmo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba ni mbɔ ŋoŋ ŋa pi ni niʼiŋ vi chə́ɨŋ nthɛ ŋa tɨtɨnɨ minduoŋnduoŋ ni ŋgū moŋ laʼa pi jwi ŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailɛ chrā ni pugu ŋkamuʼɔŋ nthɛ ŋa a ni ntāʼa nu mieŋ vi a ghə̄ɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pugu paʼo ŋgòu ŋa, “Kwiŋ vi ŋkuoŋ wáʼa, kwīŋ vi ŋkuoŋ wáʼa!” ");
INSERT INTO bmo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nɔ ŋgɛ́ yi trɛi, Pailɛ pie ni pugu ŋa, “Nthɛ khɔ, phɨ ŋa ŋoŋ vei chwīe nɛ pɔ pi khɔ? Ǹdɔ njəɨ sheshe fàŋ mbɨŋ yu ŋa a pie ŋa pi jwi vi jwi nɛ, nthɛ yie ghɔ, ǹshi ŋguʼɔ ŋgwie vi wie, nchuʼɔ vi a ghə̄ɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ndɔ pugu lɨʼɨ, njɔ̄nɔ nu ŋkiɛŋ ni njɨ, nchhu nu ŋa pi kwīŋ vi ŋkuoŋ wáʼa. Pugu yɔ̄nɔ ti yugu chəɨŋ. ");
INSERT INTO bmo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nɛnnɛ, Pailɛ shaʼa ŋa pi jwi Jishɔ nɔ haʼaŋ pugu taʼa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A chuʼɔ ŋoŋ ŋa pugu tāʼa nu nɛ, mbɔ ŋoŋ vɛ ŋa pi ni niʼiŋ vi chə́ɨŋ nthɛ tɨtɨnɨ minduoŋnduoŋ ŋa a ni nchwīe a gū moŋ laʼa pi jwi ŋoŋ nɛ, mfɛ Jishɔ ni pugu ŋa pugu jwi vi, mbɔ nnu haʼaŋ pugu ni ntāʼa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pa ghaŋ māʼaŋ nchhɔ Roma wɛ̄iŋ Jishɔ ŋgə̄ɨ nɔ. Nɔ haʼaŋ pugu ni ŋgə̄ɨ nu nɛ, pugu wɛ̄iŋ ŋoŋ chəɨ, ligi yi pɔ Shemu, mbɔ ŋoŋ laʼataoŋ Shiriŋ ŋa a ni ndhɔ moŋ yichəɨ lɨʼɨ laʼataoŋ ghɔ nthɔ nu. Pugu nūʼɔŋ wáʼa mbəʼɨ yu, ŋɨ vi ŋa a tiɛŋ ŋgə̄ɨ nɔ njiŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mmɛ kɨrɨ ŋgwa yōu njiŋ Jishɔ pugu pa piŋgɛ ŋa pugu ni nthɔ ŋkə̄ɨ vi ni njɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ndɔ Jishɔ kara nchhu ni pugu ŋa, “Piŋgɛ Jerushalɛiŋ, kiʼi pəɨ kə̄ɨ a, pəɨ kə̄ɨ noŋ pəɨ pugu pa puoŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nthɛ ŋa yichəɨ llɛ́ thɔ nthɔ nu ŋa pi shi nchhu ŋa, ‘Mbrɔthɔ miŋgwɛ ŋa a ŋkhwɛ̄ nɛ, ni pa puŋ pɛ ŋa muuŋ shi yaʼa taoŋ fɔ nɛ, ni pa pɨnɨ pɛ ŋa pugu shi yaʼa nuʼɔŋ muuŋ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nɛnnɛ, ŋgwa njɛ̄ nchhu nu ni mɛmmɛ mbra ŋa, ‘Gū mbɨŋ pigi,’ nchhu ni puoŋ mi mbra ŋa, ‘Kuru vigi!’ ");
INSERT INTO bmo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","P̈i mfɛ ŋgəʼɨ ni ŋoŋ ŋa mbhɔ yi yi wo nɛ fɨʼɨ yei, kaŋ a shi mbɔ pi nɛiŋ ni ŋoŋ ŋa a fāaŋ nnu nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pa ghaŋ māʼaŋ nchhɔ Roma lɔ̄gɔ pichəɨ paa ŋgwa ŋa pugu ni mbɔ pa ŋgushaʼa ŋkaa pugu, ŋgə̄ɨ nɔ lɨʼɨ jwi vugu pugu pa Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ŋga nthɔ nchəɨŋ lɨʼɨ chəɨ ŋa pi mɛ̄iŋ ni “Kwéi Thɔ”, ŋkwīŋ Jishɔ fɔ ŋkuoŋ wáʼa pugu pa ŋgushaʼa pighɔ, taʼa yi ŋgei mbhɔ jɨ, taʼa yi ŋgei mbhɔ ŋkwrɛi. ");
INSERT INTO bmo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jishɔ chhu ŋa, “Tǎa, līʼɛ phɨ yugu nthɛ ŋa pugu lɔ nji nnu haʼaŋ pugu chwīe nu nɛ.” Nɛnnɛ, pugu māʼaŋ yaoŋ nɔ pɛʼi nɔ yəɨ nu ŋa a shi njɨ gɔ̌ ndhwí yi shɨna pugu. ");
INSERT INTO bmo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pa ŋgwa thi fɔ mbɛʼi nu, pa thishɨ māʼaŋ vi ni kwə̀ɨŋ ŋa, “A ni nthɔ ŋkwe ŋgwa, a kwe nɛ noŋ yi pia nɔ haʼaŋ a mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe, llɔ mbhɔ Minnwi, yɛ ŋa Minnwi chuʼɔ vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pa ghaŋ māʼaŋ nchhɔ māʼaŋ vi ni kwə̀ɨŋ ŋkaa pugu mfɛ làʼo chəchɨgəɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nchhu nu ghɔ ŋa, “Ɔ̈ mbɔ fùoŋ pa Juu, ɔ kwe nɛ noŋ yɔ pia! Pigi yəɨ!” ");
INSERT INTO bmo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pi ni nāʼaŋ yaoŋ ŋkwīŋ ŋkuoŋ thɔ wáʼa thɔ yu ŋa, “Yei fùoŋ pa ŋgwa Juu.” ");
INSERT INTO bmo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yichəɨ taʼa ŋgushaʼa ghɔ ŋa pi ni ŋkwīŋ vugu pugu nɛ wɛʼi vi, nchhu nu ŋa, “Ɔ lɔ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ? Kwe nɛ noŋ yɔ, mbɨnɨ ŋkwe vigi.” ");
INSERT INTO bmo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Vichəɨ taʼa ŋgushaʼa ghɔ pɨ̄ga vi, nchhu nu ŋa, “Ɔ lɔ ndou ti mbɔgɔ Minnwi, nthɛ ŋa pi yaʼa taʼa fɨʼɨ njɔ́ ni pia, mbɔ gu? ");
INSERT INTO bmo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yɔgɔ njɔ́ kāʼo nthɛ ŋa pɔgɔ khu nɔ nnu ŋa pɔgɔ tāʼa, ndɔ ti ŋoŋ vei lɔ njiʼi mfāaŋ kaŋ taʼa nnu.” ");
INSERT INTO bmo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nchhu kiʼɛ ŋa, “Jishɔ, kwiŋ a ndɨɨ ŋa ɔ nii moŋ Shaʼafuoŋ yɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jishɔ luʼu ghɔ ŋa, “Shishini, ǹshwei ghɔ, shiʼa pɔgɔ shi mbɔ moŋ nchhɔ shiʼi Po.” ");
INSERT INTO bmo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A ni mbɔ moŋ ntuŋ minaoŋ ŋa njiŋnjiŋ ni gū moŋ ŋguoŋ lɨʼɨ ghao fɔ ti ŋgə̄ɨ nchəɨŋ moŋ trɛi minaoŋ ni naoŋchɨ, ");
INSERT INTO bmo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","nthɛ ŋa minaoŋ shi ki lɔ nuʼuŋ nthɛ nu. Ndhwí kɨʼɨ lɨʼɨ ŋa a ni mbɔ moŋ Nda Minnwi shāa ntaoŋ yi paa. ");
INSERT INTO bmo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jishɔ gha ŋkə̄ɨ ni njɨ nchhu ŋa, “Tǎa a, m̀fɛ jijwɛ a mbhɔ ghɔ!” A ni ŋga nchhu nɛnnɛ, jijwɛ yi taoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nthishɨ pa taʼa ŋkɨɨ shoogɛ ni ŋga njəɨ nnu haʼaŋ a lɔ̄gɔ lɨʼɨ nɛ, ŋgaʼo Minnwi nchhu ŋa, “Shishini, ŋoŋ vei ni mbɔ ŋoŋ ndɨndɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ndɨɨ ŋa ŋgwa ŋa pugu ni ŋkɨrɨ fɔ nɔ yəɨ nu nnu ŋa a shi ndɔ̄gɔ lɨʼɨ ni njəɨ nnu ŋa a ni ndɔ̄gɔ lɨʼɨ nɛ, pugu wie njùʼɔ yugu mbɨnɨ laʼa moŋ tuʼuthɔ. ");
INSERT INTO bmo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ndɔ ŋguoŋ ŋgwa pɛ ŋa pugu ni nji Jishɔ, mbīgi pugu pa piŋgɛ ŋa pugu ni njōu njiŋ yi llɔ Galili nɛ, thi fie hiŋ nthɔ njəɨ nnu pei. ");
INSERT INTO bmo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ŋoŋ chəɨ ni mbɔ fɔ, ligi yi pɔ Joshɛ, llɔ yichəɨ lɨʼɨ Judia ŋa pi mɛ̄iŋ ni Arimatia, mbɔ ŋoŋ shiʼi ndɔ mbɔ ŋoŋ ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Njiʼi nthɛ pi nɔ haʼaŋ a ni mbɔ ŋgia pa thishɨ pighɔ nɛ, a shi ki lɔ njiʼi mbiŋ nnu ŋa pi ni ŋkāʼa ndɔ nchwīe mbɨŋ Jishɔ nɛ, ni nthɔ njwɛrɛ Shaʼafuoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A ni ŋgə̄ɨ mbara Pailɛ ŋa a fɛ khu Jishɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A shwiʼi khu yi shhɛ, mbara vi moŋ mbhɔ ndhwí fhu, niʼiŋ vi moŋ mbo ŋa pi fīʼi ŋkuoŋ ŋgùʼɔ nɔ fúŋ, mbɔ yɛ ŋa pi shi ki lɔ naa ma ntwei ŋoŋ fɔ. ");
INSERT INTO bmo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A ni mbɔ llɛ́ pīri nu noŋ nɔ Llɛ́ Ji. Llɛ́ Ji ghɔ kwo tāʼa nu njɛ̄. ");
INSERT INTO bmo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Piŋgɛ ŋa pugu pa Jishɔ ni ndhɔ Galili nɛ yōu njiŋ Joshɛ ŋgə̄ɨ njəɨ fúŋ ndɔ njəɨ ŋkwaŋ haʼaŋ pi ni nūʼɔŋ khu Jishɔ moŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ŋgə̄ɨ kiʼɛ laʼa mbīri laminda pugu pa pichəɨ pa mbwa wru nūʼɔŋ, mfɛrɛ noŋ Llɛ́ Ji nɔ haʼaŋ kɨ̀na chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Moŋ fǔoŋ llɛmbhi mbɔ Shonde moŋ shwiʼi taŋ ghɔ, ŋkiɛŋ ni muuŋ tutuʼu, piŋgɛ pɛ lɔ̄gɔ laminda ŋa pugu ni mbīri nɛ, ŋgə̄ɨ nɔ chofuŋ. ");
INSERT INTO bmo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ŋga nchəɨŋ fɔ, njəɨ ŋa pi kwo kə̄nə ŋgùʼɔ haʼaŋ a ni nchri chofuŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pugu ni ŋga nii moŋ ghɔ, paʼa ndɔ njəɨ khu Taathɔ mbɔ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nɔ haʼaŋ thɔ yugu ni nthɔ mfiŋ nu ni nnu haʼaŋ a lɔ̄gɔ lɨʼɨ nɛ, paa ŋgwa wīʼi nthi yəɨ pugu ndhwí yugu thɔ sheishei nɔ fiembɨ. ");
INSERT INTO bmo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pɔgɔ gu ni ŋga ŋgwɛ̄iŋ vugu, pugu tuʼu thɔ yugu shhɛ, pa ŋgwa pighɔ pie ŋa, “Pəɨ kie nɛiŋ nthɔ ntāʼa ŋoŋ maoŋ shɨna pa ŋgwa khu? ");
INSERT INTO bmo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A lɔ njiʼi mbɔ hɛiŋ, a kuʼɔ llɔ moŋ gu! Kwiŋ nnu ŋa a ni nchhu ni pəɨ ndɨɨ ŋa a ni mbɔ Galili nɛ: ");
INSERT INTO bmo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Pi shi nchaʼa Muuŋ Ŋoŋmishua mfɛ mbhɔ ghaŋ phɨ, pi kwīŋ vi ŋkuoŋ wáʼa. A gha ndaʼa trɛi llɛ́, a pɨnɨ ŋkuʼɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Piŋgɛ pighɔ kwiŋ chrà yi, ");
INSERT INTO bmo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ŋkwəɨ llɔ chofuŋ ghɔ, nshwei ŋguoŋ nnu pei ni taʼanchrɔ pa ghaŋ ntaoŋ pi pugu pa ŋguoŋ pichəɨ ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Piŋgɛ pighɔ ni mbɔ Meri Madaliŋ, Joana, ni Meri mǔuŋ Jɛiŋ, pugu pa pichəɨ pa piŋgɛ nduoŋ ŋa pugu ni nshwei pa nnu pei ni pa ghaŋ ntaoŋ pi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pugu līi a pɔ nɔ nnu na, nɛnnɛ paʼa ndɔ mbiŋ nnu pighɔ. ");
INSERT INTO bmo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ndɔ Pita yrɛi ntei ŋgə̄ɨ chofuŋ, ŋga ntuʼu noŋ yi mbɛʼi moŋ fúŋ, njəɨ ndhwí fhu fɔ ki yaoŋ nduoŋ lɔ mbɔ fɔ. A pɨ̄nɨ laʼa, nchhɔ ŋgrāo nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wuʼɔ llɛ́ ghɔ, paa ghaŋ younjiŋ Jishɔ ghə̄ɨ nu lɨʼɨ chəɨ, pi mɛ̄iŋ ni Emao, wuŋ ŋkaŋ kwò llɔ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pugu ni nthɔ nshāa Shaaŋga ŋkuoŋ ŋguoŋ nnu pɛ ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nɔ haʼaŋ pugu ni nchrā nu ndɔ nshāa nu nɛ, Jishɔ nyīeŋ mbara vugu, pugu pugu nyīeŋ nu kaʼa. ");
INSERT INTO bmo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yaoŋ chri ligi yugu, pugu yəɨ vi ndɔ paʼa ndɔ nji ŋgaŋ vi. ");
INSERT INTO bmo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A pie vugu ŋa, “Pəɨ gha nyīeŋ nu, nthɔ nchrā pi khɔ?” Pugu tithi ŋkuokuo. ");
INSERT INTO bmo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Taʼa ŋoŋ shɨna pugu, ligi yi pɔ Kleopa, chhu ghɔ ŋa, “A wuʼɔ gɔ̀ təʼɨ ghɔ mbɔ ŋgaŋ kra Jerushalɛiŋ ŋa a lɔ nji nnu pɛ ŋa a lɔ̄gɔ lɨʼɨ fɔ moŋ llɛ́ pei nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jishɔ pie vugu ŋa, “Mbɔ pa khɔ?” Pugu chhu ghɔ ŋa, “Pa nnu nɔ ligi Jishɔ llɔ Nasharɛ, a ni mbɔ njəɨlɨʼɨ Minnwi, ntɨnɨ moŋ ŋguoŋ nnu ŋa a ni nchhu ndɔ nchwīe nɛ, nōoŋ nu ŋa Minnwi ni mbiŋ vi, ŋgwamishua ghaʼo vi. ");
INSERT INTO bmo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pichəɨ pa mɛmmɛ ŋgwa pia fɛ vi ŋa pi fɛ njɔ́ gu ghɔ pi kwīŋ vi ŋkuoŋ wáʼa. ");
INSERT INTO bmo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pigi ni ŋkwāʼa ŋa a ju mbɔ ŋoŋ ŋa a shi ŋkwe puoŋ Ishrae nɛ. Mbapa nɛnnɛ, a trɛi llɛ́ shiʼa ndɔ haʼaŋ nnu pei lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nɔ pīgi nu ŋkuoŋ ghɔ, pichəɨ piŋgɛ pigi chhu nnu ghraoghrao ni pigi. Pugu ni mbɔ chofuŋ ni tutuʼu, ");
INSERT INTO bmo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ndɔ paʼa ndɔ njəɨ khu yi, mbɨnɨ nchhu nu ŋa pugu yəɨ ghaŋ ntaoŋ Minnwi, pugu chhu ŋa a yi maoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pichəɨ pa ŋgwa ŋa pigi pugu ni mbɔ nɛ ghə̄ɨ chofuŋ ghɔ ŋguʼɔ njəɨ pi ŋkwaŋ haʼaŋ piŋgɛ pighɔ ni nchhu nɛ, ndɔ paʼa ndɔ njəɨ vi fɔ.” ");
INSERT INTO bmo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jishɔ chhu ni pugu ŋa, “Pəɨ kiʼi na pi nɛiŋ, a lɔ ŋkɛ̄ʼi ŋgaʼa vəɨ pi nɛiŋ nɔ piŋ nu pa nnu haʼaŋ pa njəɨlɨʼɨ Minnwi ni nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A shi ki lɔ mbie ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, yəɨ ŋgəʼɨ pei nii moŋ ndighaʼo yi?” ");
INSERT INTO bmo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A jɛ̄ moŋ ŋwaʼaŋlɨ Mushi ti ŋgə̄ɨ nii moŋ pa ŋwaʼaŋlɨ pichəɨ pa njəɨlɨʼɨ Minnwi, ntɛrɛ ni pugu ŋguoŋ yaoŋ ŋa Ŋwaʼaŋlɨ Minnwi ni nchhu nthɛ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nɔ haʼaŋ pugu ni mbara nu laʼataoŋ ghɔ nɛ, Jishɔ chwīe nɔ haʼaŋ a fəfərə. ");
INSERT INTO bmo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pugu wɛ̄iŋ vi ŋa a kɨna, nchhu nu ghɔ ŋa, “Pia laʼa kaʼa, llɛmbhi kwo thɔ mɛmmɛ, lɨʼɨ lɔ ŋkwo shini nu.” Nɛnnɛ, a nii nda nɔ laʼa nu pugu pugu. ");
INSERT INTO bmo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ndɨɨ ŋa pugu pugu ni mbɔ ŋkuoŋ taprɛi lɨʼɨ jɨ maoŋ nɛ, a lɔ̄gɔ brɛi mfɛ tōo nu, mbəʼɨ ŋgrā ni pugu. ");
INSERT INTO bmo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ligi yugu ŋaʼaŋ, pugu ji vi, ndɔ a phɛ ligi pugu. ");
INSERT INTO bmo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pugu chhu ni noŋ pugu ŋa, “Njùʼɔ yɔgɔ lɔ ŋguʼɔ nthɔ ŋkɨɨkɨɨ moŋ ghɔ nɔ haʼaŋ a ni nthɔ ntūgu Ŋwaʼaŋlɨ Minnwi ni pɔgɔ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pugu yrɛi shhɛ ndɨɨ ghɔ mbɨnɨ Jerushalɛiŋ njəɨ taʼanchrɔ pa ghaŋ ntaoŋ Jishɔ pugu kɨrɨ fɔ pugu pa pichəɨ pi nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pugu chhu ni paa ŋgwa pɛ ŋa, “Taathɔ kuʼɔ shini. A nōoŋ noŋ yi ni Shemu.” ");
INSERT INTO bmo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Paa ŋgwa pighɔ fɨʼɨ pa nnu ŋa a lɔ̄gɔ lɨʼɨ shɛndaoŋ Emao nɛ ni pugu, pugu pa ŋkwaŋ haʼaŋ pugu ni nji Taathɔ ndɨɨ ŋa a pəʼɨ brɛi nɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nɔ haʼaŋ paa ŋgwa pighɔ ni nthɔ nshwei vugu ni nnu pei nɛ, Jishɔ wīʼi nthi shɨna pugu, nchhu ni pugu ŋa, “Ghɨghrɨ Minnwi pɔ mbɨŋ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Noŋ ŋguoŋ yugu wīni, pɔgɔ gu wɛ̄iŋ vugu, pugu gɛ̄ ŋa pugu yəɨ pi ŋkhushɛ. ");
INSERT INTO bmo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A chhu ni pugu ŋa, “Pəɨ kie nɛiŋ mbɔgɔ gu nɛiŋ? A chwīe khɔ pəɨ thɔ mfāʼo yei fɨʼɨ khuthɔ? ");
INSERT INTO bmo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Līi mbhɔ ma pugu pakwo ma, njəɨ ŋa a lɔ mbɔ mmu? Kāoŋ njaʼo, nthɛ ŋa ŋkhushɛ shiʼa mfāʼo frɛ̀i pugu pa kwéi nɔ haʼaŋ pəɨ yəɨ mfāʼo nɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A ni nchhu nnu yei, nōoŋ mbhɔ mi pugu pakwo mi ni pugu. ");
INSERT INTO bmo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pugu ni mfāʼo pwanjuʼɔ ndɔ ŋgrāo ti a fhi ni pugu pi nɔ haʼaŋ a pɔ pi njə̀ɨŋ. Nɛnnɛ, Jishɔ pie vugu ŋa, “Pəɨ fāʼo sheshe yaoŋ jɨ hɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pugu fɛ nyiʼaŋ tūoŋ ghɔ, ");
INSERT INTO bmo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a kwe ŋkru shhɨ pugu. ");
INSERT INTO bmo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nchhu ŋa, “Yei pa nnu ŋa ŋki chhu ni pəɨ ndɨɨ ŋa pia ni ŋguʼɔ mbɔ kaʼa nɛ, ŋa ŋguoŋ pa nnu ŋa pi ni nāʼaŋ nɔ ligi a moŋ gɨ́ Mushi ni yi pa njəɨlɨʼɨ Minnwi pugu pa Ŋwaʼaŋlɨ Ŋkhǐ nɛ shi ŋguʼɔ ndɔ̄gɔ lɨʼɨ pi nɛnnɛ.” ");
INSERT INTO bmo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nɛnnɛ, a ŋaʼaŋ lɨna yugu ŋa pugu ji chrà Minnwi. ");
INSERT INTO bmo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nchhu ni pugu ŋa, “Pi ni nāʼaŋ ŋa, ‘Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ shi njəɨ ŋgəʼɨ ndɔ ŋkhu a gha mbɔ moŋ trɛi llɛmbhi, a kuʼɔ.’ ");
INSERT INTO bmo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pugu pa ŋa moŋ ligi Krishto ghɔ, pi shi nchīi ni pa ŋguoŋ ŋgwa ŋkuoŋ mbhi ŋa pugu pāʼa ŋkǔnu yugu ni phɨ, Minnwi liʼɛ mfɛ ni pugu, p̂əɨ jɛ̄ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pəɨ yəɨ pa nnu pei, pəɨ ghə̄ɨ nshwei ŋgwa nduoŋ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Ǹshi ntaoŋ kàʼa Tǎa a ni pəɨ. Ndɔ pəɨ chɔchɔ Jerushalɛiŋ hɛiŋ ti njɨ llɔ tɔthɨ shi nshwiʼi mbɨŋ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nɛnnɛ, Jishɔ lɔ̄gɔ vugu llɔ Jerushalɛiŋ ŋgə̄ɨ ti nchəɨŋ mbɨŋ laʼataoŋ Betani, mbɨʼɨ mbhɔ mi tɔthɨ nduoŋ mbɔrɔ Minnwi mfɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ndɔ haʼaŋ a fɛ mbɔrɔ ni pugu nɛ, mieŋ vugu, Minnwi lɔ̄gɔ vi ŋkuʼɔ nɔ po. ");
INSERT INTO bmo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nɛnnɛ, pugu ghaʼo vi, mbɨnɨ Jerushalɛiŋ ni ntou pwanjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pugu ni ŋkɨna moŋ Nda Minnwi ŋguoŋ llɛ́ nthɔ ntōo Minnwi.");
INSERT INTO bmo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ŋkaoŋ pi maa nchwīe mbhi, Chrà ghɔ ni ŋkwo pɔ, Chrà ghɔ pɔ pugu Minnwi, Chrà ghɔ pɔ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","A ni mbɔ pugu Minnwi kaʼa nɔ njɛ̄ yi. ");
INSERT INTO bmo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sheshe yaoŋ ŋa pi pūoŋ nɛ tɔgɔ pi mbhɔ yu. A kaŋ ni ŋkiɛŋ paʼa sheshe yaoŋ ŋa pi pūoŋ nɛ lɔ mbɔ yi pūoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Chɔmbhi ni ndhɔ pi mbhɔ Chrà ghɔ, chɔmbhi ghɔ pɔ líʼɛ ŋgwamishua. ");
INSERT INTO bmo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Líʼɛ ghɔ thɛ moŋ njiŋnjiŋ ndɔ paʼa njiŋnjiŋ lɔ ŋgaʼa vi. ");
INSERT INTO bmo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Minnwi ni ntaoŋ yichəɨ ŋoŋ, ligi yi pɔ Jouŋ. ");
INSERT INTO bmo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A ni nthɔ nɔ miŋkwentie nɔ chrà nu nthɛ líʼɛ ghɔ, nnɛ ŋa ŋguoŋ ŋgwa nthɛ pugu piŋ ntɔgɔ pi ŋkuoŋ chrà yi. ");
INSERT INTO bmo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A shini ndɔ mbɔ ju mbɔ líʼɛ ghɔ. A ni ŋguʼɔ mbɔ pi miŋkwentie nɔ chrà nu nthɛ líʼɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ŋkiɛŋ líʼɛ ghɔ ni nthɔ nu ŋkuoŋ mbhi, mbɔ líʼɛ ŋa a thɛ mfɛ líʼɛ ni ŋguoŋ ŋgwa nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A ni mbɔ ŋkuoŋ mbhi ndɔ pi tɔgɔ pi mbhɔ yu nchwīe mbhi, ndɔ paʼa mbhi lɔ nji vi. ");
INSERT INTO bmo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A ni nthɔ nthɛ ji, ndɔ paʼa ŋgwa pi pighɔ lɔ ŋaʼaŋ njùʼɔ yugu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ndɔ ni ŋguoŋ ŋgwa pɛ ŋa pugu ni ŋaʼaŋ njùʼɔ yugu ghɔ nɛ, ŋa pugu ni mbiŋ vi nɛ, a fɛ ghrɨ́ ni pugu nɔ gū nu puoŋ Minnwi, ");
INSERT INTO bmo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","mbɔ puoŋ ŋa pi lɔ mbhi vugu pi ŋkwaŋ haʼaŋ ŋgwamishua ghà mbhi nɛ, mbɔ ŋgwa ŋa pi shi lɔ mbhi vugu pi ni khwā nu ŋgwamishua, ki ni pīʼi nu mimbia ŋa a laŋ nɛ. Minnwi nduthɔ yi chwīe pi phi vugu. ");
INSERT INTO bmo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chrà ghɔ ni ŋgū ŋoŋmishua nshwiʼi nchhɔ shɨna pia. Pia yəɨ ndighaʼo yi, mbɔ ndighaʼo yɛ ŋa a wuʼɔ fāʼo ju nɔ taʼa fiɛŋ Muuŋ Tǎa nɛ. A ni ndɨnaoŋ ni pwapuŋ pugu pa nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jouŋ ni mbɔ miŋkwentie yi, nchhu ni njɨ ŋa, “Yei ni mbɔ ju ŋa mi ni nchrā nthɛ vi ŋa, ‘Ju ŋa a thɔ nu njiŋ a nɛ, nthɨŋkwo yi chaa nyaŋ, nthɛ ŋa a ni ŋkwo pɔ ŋkaoŋ m̀aa mbɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Llɔ moŋ lɨnaoŋ nu mi ni pwapuŋ, a fɛ mbɔrɔ ŋkuoŋ mbɔrɔ ni pia. ");
INSERT INTO bmo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nthɛ ŋa pi ni mfɛ gɨ́ ntɔgɔ pi mbhɔ Mushi, ndɔ pwapuŋ pugu pa nnu shini thɔ ntɔgɔ pi mbhɔ Jishɔ Krishto. ");
INSERT INTO bmo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yichəɨ kaŋ taʼa ŋoŋ lɔ naa njəɨ Minnwi, ndɔ fiɛŋ taʼa Minnwi ŋa a pɔ yəɨ Tǎa nɛ, chwīe pi ji Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pa ŋgwa Juu llɔ Jerushalɛiŋ ni ŋga ntaoŋ pa ghaŋ fɛʼiŋgiɛŋ Minnwi pugu pa ŋgwa Levi ŋa pugu pie Jouŋ Ŋgaŋ Fɛ Ŋkhǐ ŋa, “Ɔ pɔ pi gɔ̌?” yei pɔ nnu ŋa Jouŋ ni nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jouŋ shini ndɔ ndāa khwɛ̄ nu, a ni nja nchrā lɨʼɨ wo ki lɔ njiʼi nchiɛŋ nchò yi, nchhu nu ŋa, “Ǹshi lɔ njiʼi mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pugu pie vi ŋa, “Ti ɔ pɔ pi gɔ̌? Ɔ Elaija?” Jouŋ khwɛ̄ ŋa, “Ŋga, ǹdɔ mbɔ ju.” “Ɔ njəɨlɨʼɨ Minnwi ghɔ?” Jouŋ khwɛ̄ ŋa, “Ŋga.” ");
INSERT INTO bmo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nɛnnɛ, pugu chhu ghɔ ŋa, “Ɔ gɔ̌? Pigi fāʼo nɔ pɨ̄nɨ nu ni khwɛ̀ nshwei ŋgwa haʼaŋ pugu taoŋ vigi nɛ. Ɔ chhu pi ŋa nthɛ noŋ yɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jouŋ khwɛ̄ ŋa, “Mi ŋggì ŋoŋ ŋa a kə̄ɨ nu moŋ ŋkǔnu njó. ‘Pəɨ pīri Shɛndaoŋ tithi ni Taathɔ ŋa a tɔgɔ fɔ nɔ haʼaŋ njəɨlɨʼɨ Minnwi mbɔ Ishaya ni nchhu nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pichəɨ pa ŋgwa Farashi ŋa pugu ni mbɔ shɨna ghaŋ ntaoŋ pighɔ nɛ ");
INSERT INTO bmo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","pie vi ŋa, “Ti ɔ̈ mieŋ ki lɔ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe, ki lɔ mbɔ Elaija, ki lɔ mbɔ njəɨlɨʼɨ Minnwi ghɔ, ɔ thɔ kwe ŋgwa ni ŋkhǐ kiʼɛ ŋa?” ");
INSERT INTO bmo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jouŋ khwɛ̄ ni pugu ŋa, “Ŋ̀ga ŋkwe ŋgwa ni ŋkhǐ pi moŋ ŋkhǐ, ndɔ yichəɨ taʼa ŋoŋ thi shɨna pəɨ ŋa pəɨ shi lɔ nji vi, ");
INSERT INTO bmo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","a thɔ nu njiŋ a, ndɔ ǹdɔ njiʼi ŋkāʼo nɔ ŋoŋ ŋa mimfɛ m̀fēi ŋkɨ̌ɨ tra yi.” ");
INSERT INTO bmo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ŋguoŋ nnu pei ghao ni nthɔ ndɔ̄gɔ lɨʼɨ Betani, njiɛŋ nɨnəɨ Jodaŋ lɨʼɨ ŋa Jouŋ ni ŋkwe ŋgwa ni ŋkhǐ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mbhi gha ndaŋ, Jouŋ yəɨ Jishɔ a thɔ nu yəɨ yu, a chhu ŋa, “Līi njəɨ! Muuŋ Minjɨɨ Minnwi ŋa a kwe phɨ ŋgwa ŋkuoŋ mbhi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yei pɔ pi ŋoŋ yɛ ŋa mi ni nchrā nu nthɛ vi ndɨɨ ŋa ŋki chhu ŋa, ‘Ju ŋa a thɔ nu njiŋ a nɛ nthɨŋkwo yi chaa nyaŋ, nthɛ ŋa a ni ŋkwo pɔ ŋkaoŋ m̀aa mbɔ.’ ");
INSERT INTO bmo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mmu nduthɔ a shini ndɔ nji vi. Ndɔ ŋki thɔ, nchhɔ mfɛ ŋkhǐ ni ŋgwa nnɛ ŋa ŋgwa Ishrae ji vi.” ");
INSERT INTO bmo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jouŋ kwe ntie yi, nchhu nu ŋa, “Mi ni njəɨ Jijwɛ Minnwi shwiʼi nu mbɨŋ yu nɔ mintuʼɔlibuŋ llɔ po, nshwiʼi ŋkɨna mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mmu nduthɔ a shini ndɔ njiʼi nji vi, ndɔ ju ŋa a ni ntaoŋ a ŋa ŋ̀kwe ŋgwa ni ŋkhǐ moŋ ŋkhǐ nɛ ni nchhu vəɨ ŋa, ‘Ŋoŋ ŋa ɔ shi njəɨ Jijwɛ shwiʼi ŋkɨna mbɨŋ yu nɛ, a ju ŋa kwe nu ŋkhǐ ŋa a shi mfɛ ni ŋgwa nɛ shi mbɔ pi moŋ Jijwɛ Minnwi.’ ");
INSERT INTO bmo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ndɔ ǹjəɨ, ndɔ mbɔ miŋkwentie ŋa yei Muuŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mbhi ni ŋga ndaŋ, Jouŋ pɨnɨ ntithi pugu pa paa ghaŋ younjiŋ pi, ");
INSERT INTO bmo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","mbɛʼi Jishɔ nɔ haʼaŋ a ni ntɔgɔ nu nɛ nchhu ŋa, “Līi njəɨ, Muuŋ Minjɨɨ Minnwi!” ");
INSERT INTO bmo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Paa ghaŋ younjiŋ pi pighɔ ni ŋga njaʼo nnu yei, ndɔllɔ njōu njiŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jishɔ kara noŋ yi njəɨ vugu pugu thɔ nu njiŋ yu, a pie vugu ŋa, “Pəɨ taʼa pi khɔ?” Pugu khwɛ̄ ŋa, “Rabai” (njiŋ yi pɔ ŋa “Masha”), “Ɔ laʼa pi hɨŋ?” ");
INSERT INTO bmo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A chhu ni pugu ŋa, “Pəɨ thɔ nɛ njəɨ.” A ni mbɔ yaoŋ nɔ khwɛ minaoŋ ni naoŋchɨ ŋa pugu pugu ni ŋgə̄ɨ njəɨ lɨʼɨ ŋa a ni ndaʼa nu nɛ, pugu pugu laʼa llɛ́ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Taʼa ŋoŋ shɨna paa ŋgwa pighɔ ŋa pugu ni njaʼo Jouŋ chrā, pugu yōu njiŋ Jishɔ nɛ, ni mbɔ Andru, mbɔ ndǐŋ Shemu Pita. ");
INSERT INTO bmo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru ghə̄ɨ ntāʼa ndǐŋ vi, mbɔ Shemu, nchhu ghɔ ŋa, “Pigi yəɨ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ” (njiŋ yi pɔ ŋa “Krishto”). ");
INSERT INTO bmo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A lɔ̄gɔ vi pugu yu ghə̄ɨ njəɨ Jishɔ. Jishɔ pɛʼi vi nchhu ŋa, “Ɔ Shemu, muuŋ Jouŋ, pi shi mɛ̄iŋ ghɔ ndwɛ pi ŋa, ‘Kefa’ njiŋ yi pɔ ŋa Pita.” ");
INSERT INTO bmo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mbhi ni ŋga ndaŋ, Jishɔ lɔ̄gɔ nthí mi ŋa a shi ŋgə̄ɨ Galili. Njəɨ Fili nchhu ghɔ ŋa, “Thɔ njōu njiŋ a.” ");
INSERT INTO bmo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fili ni ndhɔ Beshaida mbɔ laʼataoŋ pa Andru pugu Pita. ");
INSERT INTO bmo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fili yəɨ Natania nchhu ghɔ ŋa, “Pigi yəɨ ŋoŋ vɛ ŋa Mushi ni nāʼaŋ nthɛ vi moŋ Ŋwaʼaŋlɨ Gɨ́, pa njəɨlɨʼɨ Minnwi pɨnɨ nāʼaŋ nthɛ vi ŋkaa pugu nɛ. A Jishɔ llɔ Nasharɛ, mbɔ muuŋ Joshɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natania chhu ghɔ ŋa, “A nthɛ nnu shiʼi taoŋ Nasharɛ?” Fili chhu ghɔ ŋa, “Thɔ nɛ njəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jishɔ yəɨ Natania thɔ nu yəɨ yu, a chhu ghɔ ŋa, “Līi njəɨ, yei ŋkiɛŋ ŋoŋ Ishrae shishini, ŋa a lɔ mbɔ ŋgaŋ mifɨɨ nɛ!” ");
INSERT INTO bmo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natania pie vi ŋa, “Ɔ kie nɛiŋ nji a?” Jishɔ khwɛ̄ ghɔ ŋa, “Ŋkaoŋ Fili maa mɛ̄iŋ ghɔ ndɨɨ ŋa ɔ ni mbɔ laʼo muuŋ thɨ wùnu nɛ, mi nì njəɨ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nnɛ Natania khwɛ̄ ŋa, “Masha, Ɔ Muuŋ Minnwi, Ɔ fùoŋ pa ŋgwa Ishrae.” ");
INSERT INTO bmo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jishɔ khwɛ̄ ghɔ ŋa, “Ɔ wuʼɔ mbiŋ nthɛ pi ŋa ǹshwei ghɔ ŋa mi nì njəɨ ghɔ laʼo muuŋ thɨ wùnu nɛ? Ɔ shi njəɨ pa nnu a chaa yei.” ");
INSERT INTO bmo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A chhu ghɔ ŋa, “Shishini, ǹshwei vəɨ ŋa, pəɨ shi njəɨ po ŋaʼaŋ, pəɨ yəɨ pa ghaŋ ntaoŋ Minnwi kuʼɔ nu ndɔ nshwiʼi nu mbɨŋ Muuŋ Ŋoŋmishua.” ");
INSERT INTO bmo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Paa llɛ́ ni ŋga ntɔgɔ, pi thɔ njɨ yichəɨ tini Kanaŋ moŋ Galili, mǔuŋ Jishɔ pɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pi ni ŋgɛ̄ Jishɔ ŋkaa yu lɨʼɨ tini ghɔ pugu pa ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Làʼo ni ŋga mmɛ, mǔuŋ Jishɔ chhu ghɔ ŋa, “Pugu lɔ mfāʼo làʼo.” ");
INSERT INTO bmo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jishɔ chhu ghɔ ŋa, “Ma! Yinɛ fāʼo pi khɔ nɔ chwīe nu vəɨ? Ndɨɨ a lɔ naa ŋkāʼo yaʼa.” ");
INSERT INTO bmo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ndɔ mǔuŋ vi chhu ni pa ghaŋ fàʼa ŋa, “Pəɨ chwīe sheshe nnu ŋa a chhu ni pəɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ntɨgao ndigi kɨ̌ŋ niʼiŋ ŋkhǐ ŋa pi chwīe ni ŋgùʼɔ nɛ ni nthi fɔ nnɛ nɔ wɛ̄iŋ nu ŋkhǐ mbɔ yi taoŋtaoŋ ŋkwaŋ haʼaŋ nùʼɔŋ pa Juu nɔ kie nu mbɔ yi taoŋtaoŋ chhu nɛ. Taʼa yi lɔ̄gɔ jɛ̄ ŋkuoŋ khwɛ jo ŋgə̄ɨ pi ntɨgao jo. ");
INSERT INTO bmo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jishɔ chhu ni pugu ŋa, “Pəɨ niʼiŋ ŋkhǐ moŋ pa kɨ̌ŋ pighɔ a lɨnaoŋ.” Pugu niʼiŋ a lɨnaoŋ ti njwɛ̄ cho ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","A chhu ni pugu ŋa, “Pəɨ ŋwaa yichəɨ fɔ ŋgə̄ɨ mfɛ ni ŋoŋ ŋa a lɨna nu ni ŋgwa lɨʼɨ jɨ tini yei nɛ.” Pugu ŋwaa. ");
INSERT INTO bmo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ŋoŋ ŋa a ni ndɨna nu ni pa ŋgwa lɨʼɨ jɨ tini ghɔ nɛ ni ŋga njwɛʼi ŋkhǐ ghɔ ŋa pi kara a gū làʼo nɛ, paʼa ndɔ nji lɨʼɨ ŋa a llɔ nɛ (ndɔ pa ghaŋ fàʼa lɨʼɨ tini ghɔ ŋa pugu ni ŋwaa ŋkhǐ ghɔ nɛ ni nji) ŋgaŋ lɨna ni ŋgwa lɨʼɨ jɨ tini ghɔ mɛ̄iŋ mimbia ŋgaŋ tini ghɔ, ");
INSERT INTO bmo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nchhu ghɔ ŋa, “Shesheŋoŋ ghà fǔoŋ ŋgrā pi làʼo shiʼi ti ŋgwa gha nja nnu shiʼi a maa nthɔ ni yɛ ŋa a lɔ nja mbwa nɛ. Ndɔ ɔ nūʼɔŋ làʼo shiʼi ti nthɔ nchəɨŋ ndwɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yei ni mbɔ fǔoŋ lì ŋa Jishɔ ni nōoŋ Kanaŋ moŋ Galili, nōoŋ ndighaʼo yi, pa ghaŋ younjiŋ pi piŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tini ghɔ ni ŋga ntɔgɔ, Jishɔ shwiʼi Kapanuŋ pugu pa mǔuŋ vi ni pa lǐŋ pi pugu pa ghaŋ younjiŋ pi ndaʼa fɔ nɔ shɨgɛi llɛ́. ");
INSERT INTO bmo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ndɨɨ jɨ Lli Njiʼa pa Juu ni ŋkwo para nu, nnɛ Jishɔ kuʼɔ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","A yəɨ ŋgwa Nda Minnwi, pugu chhɔ mfīni pa fua, pa minjɨɨ, pa mintuʼɔlibuŋ, ni pa ghaŋ kwri mbɨŋ pugu chhɔ ŋkuoŋ pa taprɛi pugu. ");
INSERT INTO bmo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jishɔ chwīe ŋgwàŋ ni ŋkɨɨ njōu vugu nɔ ghao Nda Minnwi mfɛ mbhi pugu pa minjɨɨ, pugu pa fua, ŋkwrī mbɨŋ ghaŋ kwri mbɨŋ ŋkara taprɛi yugu ŋkuru. ");
INSERT INTO bmo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nɛnnɛ, nchhu ni ŋgwa pɛ ŋa pugu ni mfīni mintuʼɔlibuŋ nɛ ŋa, “P̂əɨ pei maoŋ pei ntaoŋ nɔ ghɔ hɛiŋ, kiʼi pəɨ lɔ̄gɔ Nda Tǎa a, a gū nda taŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pa ghaŋ younjiŋ pi kwiŋ ŋa pi ni nāʼaŋ ŋa, “Niʼiŋ njùʼɔ nthɛ Nda yɔ shi njɨ a.” ");
INSERT INTO bmo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nnɛ pa Juu chhu ghɔ ŋa, “Ɔ nōoŋ pi yəɨ lì ni pigi nɔ nōoŋ nu ŋa ɔ fāʼo ghrɨ́ nɔ chwīe nu nnu pei?” ");
INSERT INTO bmo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jishɔ chhu ni pugu ŋa, “Pəɨ shāʼa Nda Minnwi yei, m̀bɨnɨ nuʼuŋ ŋkrao moŋ trɛi llɛ́.” ");
INSERT INTO bmo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pa Juu chhu ŋa, “Khɔ nya! A lɔ̄gɔ khwɛ wuŋ ŋgaʼo ni ŋgaʼo yi ntɨgao nɔ krao nu Nda Minnwi yei, ɔ ŋa ɔ shi mbɨʼɨ tɔthɔ nɔ trɛi llɛ́ nya?” ");
INSERT INTO bmo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ndɔ Nda Minnwi yɛ ŋa Jishɔ ni chrà nu nthɛ vi nɛ ni mbɔ pi noŋ yi. ");
INSERT INTO bmo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","A ni ŋga mbɔ ndɨɨ yɛ ŋa Jishɔ ni mbɨnɨ nuʼuŋ ŋkuʼɔ moŋ gu nɛ, pa ghaŋ younjiŋ pi kwiŋ ŋa a ni nchhu yei nnu, mbiŋ chrà Minnwi pugu pa chrà ŋa Jishɔ ni nchrā nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ndɨɨ ŋa a ni mbɔ Jerushalɛiŋ lɨʼɨ jɨ Lli Njiʼa nɛ, ntou ŋgwa piŋ vi nɔ haʼaŋ pugu ni njəɨ ntou pa lì ŋa a ni nōoŋ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ndɔ Jishɔ shini ndɔ njɨʼə noŋ yi mbɨŋ pugu nthɛ ŋa a ni nji vugu ghao. ");
INSERT INTO bmo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yichəɨ ŋoŋ shini ndɔ mfāʼo nɔ shwei nu vi ni yaoŋ ŋa ŋoŋmishua yie ghɔ nɛ, nthɛ ŋa ju nduthɔ yi ni nji njùʼɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yichəɨ nthishɨ pa Juu ni mbɔ fɔ, mbɔ ŋoŋ Farashi, ligi yi pɔ Nikodemu. ");
INSERT INTO bmo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ŋoŋ vei thɔ njəɨ Jishɔ ni tuʼu nchhu ghɔ ŋa, “Masha, pigi ji ŋa ɔ ŋgaŋ yɛʼi ŋgwa llɔ mbɔ Minnwi, nthɛ ŋa a nthɛ paʼa ŋoŋ lɔ nōoŋ pa lì pei ŋa ɔ nōoŋ nɛ ki Minnwi lɔ mbɔ pugu yu kaʼa.” ");
INSERT INTO bmo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jishɔ khwɛ̄ ghɔ ŋa, “Shishini, ǹshwei ghɔ, ŋ̈oŋ mieŋ ki lɔ mbɔ phi ŋkamuʼɔŋ, paʼa Minnwi lɔ nshaʼa fùoŋ yi moŋ chɔmbhi yi.” ");
INSERT INTO bmo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu chhu ghɔ ŋa, “Mimfɛ pi pɨnɨ mbhi ŋoŋ pi nɛiŋ ndɨɨ ŋa a kwo pɔ mmɛŋoŋ nɛ? A nthɛ a pɨnɨ nii moŋ puŋ mǔuŋ vi pi pɨnɨ mbhi vi?” ");
INSERT INTO bmo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jishɔ khwɛ̄ ghɔ ŋa, “Shishini, ǹchhu vɛ ŋa pi mieŋ ki phi ŋoŋ ni ŋkhǐ pugu pa Jijwɛ, paʼa a lɔ nii moŋ Shaʼafuoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yɛ ŋa a phi frɛinoŋ mbhi vi nɛ frɛinoŋ, yɛ ŋa a phi Jijwɛ mbhi vi nɛ, pɔ jijwɛ. ");
INSERT INTO bmo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kiʼi ŋgrāo nɔ haʼaŋ ǹchhu vɛ ŋa a yīʼi ŋa pi phi vəɨ ŋkamuʼɔŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fɨfrəɨ ghà ntɔgɔ ŋgə̄ɨ nu lɨʼɨ ŋa a khwā nɛ, ɔ yaʼo ŋkaoŋ yi ndɔ paʼa ndɔ nji lɨʼɨ ŋa a llɔ nɛ, ki lɨʼɨ ŋa a ghə̄ɨ nu nɛ. A haʼaŋ a pɔ ni shesheŋoŋ ŋa a phi Jijwɛ Minnwi mbhi vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu pie ŋa, “Pa nnu pei nthɛ a lɔ̄gɔ lɨʼɨ pi nɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jishɔ khwɛ̄ ghɔ ŋa, “Ɔ ŋgaŋ yɛʼi ŋgwa Ishrae ki lɔ nji nnu pei? ");
INSERT INTO bmo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Shishini, ǹchhu vɛ ŋa pigi ghà nchrā pi nnu ŋa pigi ji nɛ, ŋkwe ntie yaoŋ ŋa pigi yəɨ nɛ, ndɔ paʼa pəɨ lɔ mbiŋ nnu ŋa pigi chhu nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","M̈i nshwei vəɨ ni pa nnu ŋkuoŋ mbhi yei ki pəɨ lɔ mbiŋ, pəɨ shi mbiŋ ndɨɨ ŋa ǹshwei vəɨ ni pa nnu po nɛ pi ŋkwaŋ nɛiŋ? ");
INSERT INTO bmo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yichəɨ kaŋ taʼa ŋoŋ lɔ naa ŋkuʼɔ po ŋkiɛŋ ŋoŋ ŋa a llɔ po nshwiʼi shhɛ nɛ, mbɔ Muuŋ Ŋoŋmishua. ");
INSERT INTO bmo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ndɔ nɔ haʼaŋ Mushi ni ŋkə̄rə mitwɛʼi tɔthɨ moŋ ŋkǔnu njó nɛ, wuʼɔ nɛnnɛ, a yiʼi ŋa pi shi ŋkə̄rə Muuŋ Ŋoŋmishua tɔthɨ, ");
INSERT INTO bmo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nnɛ ŋa shesheŋoŋ ŋa a piŋ vi nɛ, shi mfāʼo chɔmbhi ki mmɛ. ");
INSERT INTO bmo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Nthɛ ŋa Minnwi ni ŋkhwā ŋgwa ŋkuoŋ mbhi yei ntou yi ti mfɛ taʼa fiɛŋ muuŋ vi, ŋa shesheŋoŋ ŋa a piŋ vi nɛ, mbaʼa a yiʼi ŋkhu, a shi mfāʼo chɔmbhi ki mmɛ. ");
INSERT INTO bmo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nthɛ ŋa Minnwi shini ndɔ ntaoŋ muuŋ vi ŋkuoŋ mbhi pi ŋa a thɔ nshaʼa mbhi shaʼa, a ni ntaoŋ vi pi ŋa a thɔ nnɛ ŋa ŋgwa ŋkuoŋ mbhi hɛiŋ kie mbɨŋ yu ndūgu. ");
INSERT INTO bmo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Mbaʼa pi yiʼi nshaʼa ŋoŋ ŋa a piŋ vi nɛ. Ndɔ ŋoŋ ŋa a lɔ mbiŋ vi nɛ kwo pɔ ŋgushaʼa nthɛ ŋa a lɔ mbiŋ fiɛŋ taʼa Muuŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yei ŋkwaŋ haʼaŋ sháʼa ghɔ pɔ nɛ: ŋa líʼɛ thɔ ŋkuoŋ mbhi, ŋgwa mieŋ líʼɛ ghɔ ŋkhwā pi njiŋnjiŋ nthɛ ŋa mbha nnu pugu pɔ pi pa pi pɨphɨ. ");
INSERT INTO bmo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Shesheŋoŋ ŋa a ghà nchwīe pa nnu pɨphɨ nɛ pɨ̄na líʼɛ, nnɛ paʼa ndɔ nthɔ mbara yəɨ líʼɛ ghɔ nthɛ ŋa mbha nnu pi pi pɨphɨ shi ntaoŋ páa. ");
INSERT INTO bmo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ndɔ shesheŋoŋ ŋa a ghà nchwīe nnu shini nɛ ghà nthɔ moŋ líʼɛ, nnɛ ŋa a nthɛ pi yəɨ ŋa nnu ŋa a chwīe nu nɛ a yaʼo pi nchò Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nnu pei ni ŋga ntɔgɔ, Jishɔ pugu pa ghaŋ younjiŋ pi ghə̄ɨ moŋ shhɛ Judia, nchhɔ fɔ pugu pugu, ŋkwe ŋgwa ni ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jouŋ ŋkaa yu ni nthɔ ŋkwe ŋgwa moŋ ŋkhǐ Aenoŋ ŋkɨŋ Shaliŋ, nthɛ ŋa ŋkhǐ ni njiɛŋ fɔ, ŋgwa thɔ nu fɔ ŋkwe ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Yei ni mbɔ ndɨɨ ŋa pi shini ndɔ naa niʼiŋ Jouŋ chə́ɨŋ nɛ.) ");
INSERT INTO bmo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mindoundou ni ŋgū shɨna pa ghaŋ younjiŋ Jouŋ pugu pa yichəɨ ŋoŋ Juu ŋkuoŋ nnu shɨ̄gao nu noŋ mbɔ yi taoŋtaoŋ nɔ haʼaŋ nùʼɔŋ chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pugu thɔ mbara Jouŋ nchhu ghɔ ŋa, “Masha, līi njəɨ, ŋoŋ yɛ ŋa pəɨ yu ni mbɔ njiɛŋ ŋkhǐ Jodaŋ, ɔ chrà nɔ ligi yi nɛ thɔ nɛ mfɛ ŋkhǐ, ŋguoŋ ŋgwa ghə̄ɨ mbara vi.” ");
INSERT INTO bmo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jouŋ khwɛ̄ ŋa, “Mbaʼa ŋoŋ fāʼo kaŋ taʼa yaoŋ kaŋ a nɛiŋ pi fɛ fɛ ghɔ llɔ po. ");
INSERT INTO bmo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pəɨ ŋkaa pəɨ pa miŋkwentie paŋ ŋa ŋki nchhu ŋa, ‘Ǹdɔ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, ndɔ pi taoŋ a ŋa ŋ̀gə̄ɨ shhɨ yu.’ ");
INSERT INTO bmo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ŋoŋ ŋa a laŋ miŋgwɛ fhi nɛ, ju mbɔ mimbia láŋ. Ndɔ taannu mimbia ŋgaŋ láŋ ghɔ gha ntithi njaʼo ŋggì mimbia ŋgaŋ láŋ ghɔ, mfāʼo pwanjuʼɔ ntou yi. Nthɛ yie ghɔ, pwanjuʼɔ a lɨnaoŋ ndwɛ. ");
INSERT INTO bmo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A shi ŋguʼɔ ŋkuʼɔ kuʼɔ mbɔ ŋoŋ ndiɛŋ, ŋ̀guʼɔ nshwishwiʼi mbɔ ŋoŋ kikɛʼi. ");
INSERT INTO bmo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ju ŋa a llɔ pi tɔthɨ nɛ ghaʼo nchaa ŋguoŋ ŋgwa, ju ŋa a llɔ pi ŋkuoŋ shhɛ nɛ pɔ ŋoŋ ŋkuoŋ shhɛ, nchrā pi nnu ŋkuoŋ shhɛ, ndɔ ju ŋa a llɔ pi po nɛ chaa ŋguoŋ ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A chhu nnu pɛ ŋa a yəɨ ndɔ njaʼo nɛ, ndɔ paʼa kaŋ taʼa ŋoŋ lɔ mbiŋ ŋkɨ̀nɨ yi. ");
INSERT INTO bmo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ndɔ shesheŋoŋ yɛ ŋa a piŋ ŋkɨ̀nɨ yi nɛ frɛ̄i mbhɔ yi ŋkuoŋ yei nnu, ŋa Minnwi ŋgaŋ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nthɛ ŋa ŋoŋ ŋa Minnwi taoŋ nɛ chrā pi chrà Minnwi nthɛ ŋa Minnwi fɛ Jijwɛ yi ghɔ ki fɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tǎa khwā Muuŋ vi, mfɛ ŋguoŋ yaoŋ liɛŋ mbɔ yu ghao. ");
INSERT INTO bmo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Shesheŋoŋ ŋa a piŋ Muuŋ nɛ fāʼo chɔmbhi ki mmɛ, ndɔ shesheŋoŋ ŋa a lɔ njaʼo nchò Muuŋ nɛ, mbaʼa a lɛ mfāʼo ŋkiɛŋ chɔmbhi ndɔ ŋgəʼɨ pɨgɨtua Minnwi shi ŋkɨna mbɨŋ yu.” ");
INSERT INTO bmo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jishɔ ni nji ŋa pa ŋgwa Farashi kwo yaʼo ŋa a thɔ mfāʼo ntou ghaŋ younjiŋ pi ndɔ ŋkwe vugu ni ŋkhǐ nchaa Jouŋ. ");
INSERT INTO bmo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ndɔ Jishɔ nduthɔ yi shini ndɔ nthɔ ŋkwe ŋgwa ni ŋkhǐ, a ni ŋkwe ghaŋ younjiŋ pi ŋkwe ŋgwa ni ŋkhǐ.) ");
INSERT INTO bmo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","A ni ŋga nji nɛnnɛ, ndɔllɔ Judia mbɨnɨ Galili. ");
INSERT INTO bmo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","A pie ŋa a tɔgɔ Shamaria. ");
INSERT INTO bmo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nnɛ a thɔ nchəɨŋ moŋ yichəɨ mmɛ lɨʼɨ Shamaria ŋa pi mɛ̄iŋ ni Shaika, ŋkɨŋ nyìeŋ ŋa Jakɔ ni mfɛ ni Joshɛ muuŋ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tiɛŋ ŋkhǐ Jakɔ ni mbɔ fɔ. Jishɔ ni ŋkwo kɨna nthɛ fɨʼɨ nyīeŋ nu ŋa a ni ŋkwo nyīeŋ nɛ, nnɛ, nchɔchhɔ ŋkɨŋ ŋkhǐ ghɔ. Ndɨɨ ghɔ ni mbɔ moŋ ntuŋ minaoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Miŋgwɛ Shamaria thɔ lɨʼɨ shūu ŋkhǐ, Jishɔ chhu ghɔ ŋa, “Fɛ ŋkhǐ vəɨ nnu.” ");
INSERT INTO bmo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Pa ghaŋ younjiŋ pi ni ŋgə̄ɨ moŋ laʼa lɨʼɨ yuoŋ maoŋ jɨ. ");
INSERT INTO bmo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Miŋgwɛ Shamaria ghɔ chhu ŋa, “A kie pi nɛiŋ, gɔ̀ mbɔ ŋoŋ Juu, pie yaoŋ nnu llɔ mbhɔ a mbɔ miŋgwɛ Shamaria?” (Nthɛ ŋa pa ŋgwa Juu shini ndɔ nthɔ mbɔ nu ni pra pugu pa ŋgwa Shamaria.) ");
INSERT INTO bmo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jishɔ khwɛ̄ ghɔ ŋa, “Ɔ kaŋ nji fɛ́ Minnwi, ki nji ŋoŋ yɛ ŋa a thɔ nchhu nu ŋa, ‘Fɛ ŋkhǐ nnu nɛ’, ɔ kaŋ mbie vi, a fɛ ŋkhǐ ŋa a ghà mfɛ chɔmbhi nɛ vɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Miŋgwɛ ghɔ chhu ŋa, “Masha, ɔ lɔ njiʼi mfāʼo yaoŋ nɔ shūu nu ŋkhǐ nɔ ghɔ, tiɛŋ ŋkhǐ ghɔ lɔ nja nshīi. Ti ɔ shi mfāʼo ŋkhǐ fɛ chɔmbhi yei pi hɨŋ? ");
INSERT INTO bmo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A ni mfɛ ŋkhu tǎa vigi Jakɔ mfɛ tiɛŋ ŋkhǐ yei ni pigi. Ju nduthɔ yi pugu pa puoŋ pi pugu pa minyieŋ pi ni ŋguʼɔ nnu ŋkhǐ pi llɔ fɔ. Ɔ tāʼa nu nchhu ŋa ɔ ghaʼoghaʼo nchaa Jakɔ tǎa vigi ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jishɔ khwɛ̄ ghɔ ŋa, “Njì ŋkhǐ shi ŋguʼɔ mbɨnɨ njia ŋgwa pɛ ŋa pugu nnu yei ŋkhǐ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ndɔ ŋoŋ ŋa a nnu yɛ ŋkhǐ ŋa ǹshi mfɛ nɛ, mbaʼa njì ŋkhǐ ma nuʼuŋ njia vi. Ŋkhǐ ŋa ǹshi mfɛ nɛ shi ŋgū shaʼashhɛ moŋ noŋ yu ŋkuʼɔ nu mfɛ chɔmbhi ki mmɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Miŋgwɛ ghɔ chhu ghɔ ŋa, “Masha, fɛ ŋkhǐ yei vəɨ nji ŋa m̀baʼa ma nuʼuŋ mfāʼo njì ŋkhǐ, ki nthɔ hɛiŋ lɨʼɨ shūu ŋkhǐ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jishɔ chhu ghɔ ŋa, “Ghə̄ɨ mɛ̄iŋ ndaoŋ ghɔ pəɨ yu thɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Miŋgwɛ ghɔ khwɛ̄ ghɔ ŋa, “Ndɔ njiʼi mfāʼo ndaoŋ a.” Jishɔ chhu ghɔ ŋa, “Ɔ chhu a kāʼo ŋa, ‘Ǹdɔ mfāʼo ndaoŋ a’, ");
INSERT INTO bmo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","nthɛ ŋa ɔ kwo laŋ tiɛŋ pimbia, ndɔ ti yɛ ŋa pəɨ yu pɔ ndwɛ nɛ lɔ njiʼi mbɔ ndaoŋ ghɔ, nnu ŋa ɔ chhu nɛ nnu shini.” ");
INSERT INTO bmo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Miŋgwɛ ghɔ chhu ghɔ ŋa, “Masha, ǹjəɨ ŋa ɔ pɔ pi njəɨlɨʼɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pa tǎa pigi ni nthɔ ŋgaʼo Minnwi pi ŋkuoŋ mbra yei, ndɔ pəɨ chhu ŋa a pie ŋa ŋgwa wuʼɔ ŋgaʼo Minnwi pi Jerushalɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jishɔ chhu ghɔ ŋa, “Ma! Piŋ nnu ŋa ǹchhu nu nɛ, ndɨɨ thɔ nu ŋa mbaʼa pi yiʼi ŋgaʼo Tǎa pi ŋkuoŋ mbra yei ki Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pəɨ ghaʼo yaoŋ ŋa pəɨ lɔ nji nɛ, pigi ghaʼo yaoŋ ŋa pigi ji. Nthɛ ŋa lūgu nu tɔgɔ pi mbhɔ ŋgwa Juu. ");
INSERT INTO bmo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ndɔ ndɨɨ chhɔ thɔ nu, ndɔ ŋkwo pɔ hɛiŋ, ŋa ŋkiɛŋ ghaŋ ghaʼo Minnwi shi ŋgaʼo Tǎa moŋ Jijwɛ pugu pa nnu shini. Nthɛ ŋa Tǎa tāʼa pi ŋkwaŋ ŋgwa pighɔ ŋa pugu ghaʼo vi. ");
INSERT INTO bmo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Minnwi pɔ pi Jijwɛ, a pie ŋa ŋgwa haʼaŋ pugu shi ŋgaʼo vi nɛ, ghaʼo moŋ jijwɛ pugu pa nnu shini.” ");
INSERT INTO bmo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Miŋgwɛ ghɔ chhu ghɔ ŋa, “Ǹji ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ thɔ nu (mbɔ ju ŋa pi mɛ̄iŋ ni Krishto nɛ). A shi ŋga nthɔ, kaŋ a shi nshwei vigi ni ŋguoŋ nnu.” ");
INSERT INTO bmo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jishɔ chhu ghɔ ŋa, “Mmu ŋa ǹchrā nu vɛ nɛ ju.” ");
INSERT INTO bmo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wuʼɔ ndɨɨ ghɔ pa ghaŋ younjiŋ pi pɨnɨ, ŋgrāo ŋa a chrā nu pugu miŋgwɛ, ndɔ paʼa kaŋ taʼa ŋoŋ vugu lɔ mbie vi ŋa, “Ɔ tāʼa pi khɔ?” ki ŋa, “Pəɨ yu chrā nu nthɛ khɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nnɛ miŋgwɛ ghɔ mieŋ kɨ̌ŋ ŋkhǐ yi, ŋgə̄ɨ moŋ laʼa nchhu ni pa ŋgwa ŋa, ");
INSERT INTO bmo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“P̂əɨ thɔ njəɨ ŋoŋ ŋa a shwei a ni ŋguoŋ pa nnu ŋa mi ni ŋkwo ma nchwīe nɛ. A nthɛ yei pɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pa ŋgwa pighɔ mieŋ moŋ laʼa nthɔ nu lɨʼɨ yəɨ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ndɨɨ ghɔ pa ghaŋ younjiŋ pi lɨ̄gəɨ Jishɔ, nchhu nu ŋa, “Masha, jɨ maoŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ndɔ a chhu ni pugu ŋa, “M̀fāʼo maoŋ jɨ nɔ jɨ nu ŋa pəɨ shi lɔ njiʼi nji.” ");
INSERT INTO bmo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nnɛ pa ghaŋ younjiŋ pi chhu nu ni noŋ pugu ŋa, “Yichəɨ ŋoŋ ni nthɔ ni maoŋ jɨ mfɛ ghɔ ŋa a jɨ?” ");
INSERT INTO bmo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jishɔ chhu ni pugu ŋa, “Maoŋ jɨ paŋ pɔ pi nɔ chwīe nu nnu ŋa ŋoŋ ŋa a taoŋ a khwā nɛ, ti mīʼɛŋ fàʼa yi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pəɨ lɔ nchhu ŋa a wuʼɔ mbiʼi khwɛ nàoŋ pi maa ŋkwōo maoŋ? Līi njəɨ, ǹshwei vəɨ, pəɨ pɨʼɨ ligi yəɨ ndīi pa moŋ nyìeŋ. Pa maoŋ kwo tɨnɨ ŋkāʼo kwōo nu. ");
INSERT INTO bmo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ŋoŋ ŋa a kwōo maoŋ nɛ kwo nthɔ mfāʼo pe yi, nthɔ nu ni maoŋ kwōo pighɔ ŋa pugu fāʼo chɔmbhi ki mmɛ, nnɛ ŋa ŋoŋ haʼaŋ a phi nɛ pugu ŋoŋ haʼaŋ a kwōo nɛ fāʼo pwanjuʼɔ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nthɛ ŋa chrà yei nnu shini ŋa, ‘Yichəɨ ŋoŋ phī, ŋoŋ nduoŋ kwōo.’ ");
INSERT INTO bmo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ǹtaoŋ vəɨ ŋa pəɨ ghə̄ɨ ŋkwōo yaoŋ ŋa pəɨ shini ndɔ mfāʼa. Ŋgwa nduoŋ fāʼa, pəɨ shei nɔ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ntou pa ŋgwa Shamaria moŋ laʼataoŋ ghɔ piŋ vi nthɛ chrà miŋgwɛ ghɔ ŋa, “A shwei a ni ŋguoŋ nnu ŋa mi ni ŋkwo ma nchwīe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pa ŋgwa Shamaria ni ŋga nthɔ njəɨ vi, ndɨ̄gəɨ vi ŋa a laʼa pugu pugu. A laʼa fɔ nɔ paa llɛ́. ");
INSERT INTO bmo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ntou pa ŋgwa pɨnɨ mbīgi mbiŋ vi ntɔgɔ ŋkuoŋ chrà yi. ");
INSERT INTO bmo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nchhu ni miŋgwɛ ghɔ ŋa, “A lɔ ŋguʼɔ mbɔ nthɛ pi pa nnu pɛ ŋa ɔ chhu nɛ ŋa pigi piŋ. Pigi yaʼo ni noŋ yigi llɔ mbhɔ yu, ndɔ nji ŋa a ju shini mbɔ Ŋkwe mbhi.” ");
INSERT INTO bmo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Paa llɛ́ gha ntɔgɔ, a lɔllɔ ŋgə̄ɨ Galili. ");
INSERT INTO bmo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Nthɛ ŋa nduthɔ yi ni nchhu ŋa, “Pi shiʼa ma ŋgaʼo pa njəɨlɨʼɨ Minnwi laʼa pugu.”) ");
INSERT INTO bmo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nnɛ, a gha ŋgə̄ɨ Galili, pa ŋgwa Galili piŋ vi nthɛ ŋa pugu ni ŋga ŋgə̄ɨ lɨʼɨ jɨ Lli Njiʼa Jerushalɛiŋ, njəɨ fɨʼɨ nnu pɛ ŋa a ni nchwīe lɨʼɨ jɨ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nnɛ, a pɨnɨ nuʼuŋ nthɔ ŋkamuʼɔŋ Kanaŋ moŋ Galili, lɨʼɨ ŋa a ni ŋkara ŋkhǐ a gū làʼo nɛ. Mmɛŋoŋ ndiɛŋ chəɨ ni mbɔ Kapanuŋ ŋa muuŋ vi yi mimbia ni ŋgɨ̄nɔ nu. ");
INSERT INTO bmo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","A ni ŋga njaʼo ŋa Jishɔ lɔllɔ Judia nthɔ Galili, a ghə̄ɨ ndɨ̄gəɨ vi ŋa a shwiʼi Kapanuŋ njɨ̄gɨ ghɨ̌nɔ muuŋ vi nthɛ ŋa a ni ŋkwo chhɔ ŋkhukhu. ");
INSERT INTO bmo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nnɛ Jishɔ chhu ghɔ ŋa, “P̈əɨ mieŋ ki yəɨ pa lì pugu pa nnu ghraoghrao paʼa pəɨ lɔ mbiŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mmɛŋoŋ ndiɛŋ ghɔ chhu ghɔ ŋa, “Masha, thɔ ŋkaoŋ muuŋ a maa ŋkhu.” ");
INSERT INTO bmo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jishɔ chhu ghɔ ŋa, “Ghə̄ɨ, muuŋ ghɔ shi mbɔ yi maoŋ.” Ŋoŋ ghɔ piŋ chrà Jishɔ ndhɔ nyìeŋ. ");
INSERT INTO bmo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nɔ haʼaŋ a ni nshwiʼi nu nɛ, puoŋ fàʼa pi para vi nchhu ghɔ ŋa muuŋ ghɔ yi maoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nnɛ a pie vugu ni ndɨɨ ŋa noŋ yi ni njɛ̄ yo nu nɛ. Pugu chhu ghɔ ŋa, “A yua moŋ taʼa minaoŋ ni naoŋchɨ ŋa shɨ̀gao ghɔ ni ntaoŋ mbɨŋ yu.” ");
INSERT INTO bmo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tǎa ghɔ ji kiʼɛ ŋa a ndɨɨ yɛ ŋa Jishɔ ni nchhu ghɔ ŋa, “Muuŋ ghɔ shi mbɔ yi maoŋ nɛ.” Ju nduthɔ yi pugu pa mbaanda yi gū pa ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yei ni mbɔ mbra lì ŋa Jishɔ ni nōoŋ ndɨɨ ŋa a ni ntaoŋ moŋ Judia ŋgə̄ɨ Galili nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pa nnu pei ni ŋga ntɔgɔ, yichəɨ jɨ pa Juu thɔ ndɔ̄gɔ lɨʼɨ Jerushalɛiŋ, Jishɔ kuʼɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yichəɨ ŋkhǐ ni mbɔ Jerushalɛiŋ nɔ lɨʼɨ ŋa pi ni mɛ̄iŋ ni Choŋkaʼa Minjɨɨ nɛ, pi mɛ̄iŋ moŋ chrà Hibru ŋa Bɛjata, ŋa a ni mfāʼo tiɛŋ lɨʼɨ fɛrɛ noŋ ŋkɨŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ntou pa ghaŋ ghɨ̌nɔ ni nuaŋ fɔ: pa nchriligi, pa kwíni kwò ni pa ŋgwa ŋa ŋgei noŋ yugu khu. Pugu ni nthɔ njwɛrɛ nu ŋa pi chɨ̄ʼɨ ŋkhǐ ghɔ ");
INSERT INTO bmo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","nthɛ ŋa ŋgaŋ ntaoŋ Taathɔ ni nthɔ nshwiʼi nu moŋ ŋkhǐ ghɔ pichəɨ ndɨɨ nchɨʼɨ nu. Fǔoŋ ŋoŋ ŋa a nii moŋ ghɔ ndɨɨ ŋa pi kwo chɨ̄ʼɨ nɛ, sheshe ŋkwaŋ ghɨ̌nɔ ŋa a ghana vi nɛ tɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ŋoŋ chəɨ ni mbɔ ŋa a ni ŋkwo ghɨ̌nɔ nɔ trɛi wuŋ ŋgaʼo ni yi fúoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jishɔ ni ŋga njəɨ vi a nūaŋ fɔ, ndɔ nji ŋa ghɨ̌nɔ ghɔ ni ŋkwo laʼa mbɨŋ yu nɔ ntaaŋ ndɨɨ, mbie vi ŋa, “Ɔ tāʼa nu mbɔ shiʼi?” ");
INSERT INTO bmo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ŋgɨ̌nɔ ghɔ khwɛ̄ ghɔ ŋa, “Masha, ǹdɔ njiʼi mfāʼo shesheŋoŋ nɔ niʼiŋ nu ma moŋ ŋkhǐ ndɨɨ ŋa pi chɨ̄ʼɨ nɛ. Ndɨɨ ŋa ŋ̀ga mbaʼo nu nɔ nii nu nɛ, ŋoŋ nduoŋ kwo fǔoŋ nii moŋ ghɔ shhɨ a.” ");
INSERT INTO bmo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jishɔ chhu ghɔ ŋa, “Lɔllɔ tɔthɨ, lɔ̄gɔ kúoŋ yɔ ndɔ nyieŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wuʼɔ ndɨɨ ghɔ, ŋoŋ ghɔ pɔ shiʼi, ndɔ̄gɔ kúoŋ yi njɛ̄ nyīeŋ nu! Llɛ́ ŋa nnu yei ni ndɔ̄gɔ lɨʼɨ nɛ ni mbɔ llɛ́ ji. ");
INSERT INTO bmo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nɛnnɛ pa ŋgwa Juu chhu ni ŋoŋ ghɔ ŋa pi yɨ̄gɨ ghɨ̌nɔ yi nɛ ŋa, “Shiʼa llɛ́ ji, paʼa gɨ́ yia lɔ mbiŋ ŋa ɔ tiɛŋ kúoŋ yɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ndɔ a khwɛ̄ ni pugu ŋa, “Ŋoŋ ŋa a ni njɨ̄gɨ ghɨ̌nɔ a nɛ ni nchhu ŋa, ‘Lɔ̄gɔ kúoŋ yɔ nyieŋ.’ ” ");
INSERT INTO bmo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pugu pie vi ŋa, “Ŋoŋ ghɔ gɔ̌ ŋa a chhu vɛ ŋa lɔ̄gɔ kúoŋ yɔ nyīeŋ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ndɔ ŋoŋ ghɔ ŋa pi ni njɨ̄gɨ ghɨ̌nɔ yi nɛ shini ndɔ nji vi. Nthɛ ŋa yú ŋgwa ni mbɔ fɔ Jishɔ kwo phɛ shɨna pugu ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yichəɨ ndɨɨ ni ŋga mbɔ, Jishɔ yəɨ vi moŋ Nda Minnwi nchhu ghɔ ŋa, “Līi njəɨ ŋa ɔ pɔ shiʼi. Kiʼi nuʼuŋ nchwīe phɨ ŋkamuʼɔŋ nnɛ ŋa kiʼi nnu wuwuru nchaa yie lɔ̄gɔ lɨʼɨ mbɨŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ŋoŋ ghɔ ghə̄ɨ ni vhi, nshwei pa ŋgwa Juu ŋa a ni njɨ̄gɨ Jishɔ njɨ̄gɨ ghɨ̌nɔ yi. ");
INSERT INTO bmo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yei nnu ŋa a ni nchwīe pugu fɛ ŋgəʼɨ ni Jishɔ, nthɛ ŋa a ni nchwīe nnu yei llɛ́ ji. ");
INSERT INTO bmo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ndɔ Jishɔ khwɛ̄ ni pugu ŋa, “Tǎa a wuʼɔ nthɔ mfāʼa fāʼa ti nchəɨŋ ndwɛ. Nnɛ, mummu fāʼa nu.” ");
INSERT INTO bmo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yei nnu ŋa a ni nchwīe pa thishɨ ŋgwa Juu mīʼɛŋ ntāʼa nu njwi vi nɛ, nthɛ ŋa a lɔ ŋguʼɔ mbəʼɨ pi llɛ́ ji. A pɨnɨ nthɔ mɛ̄iŋ Minnwi ŋa a Tǎa vi, nchwīe noŋ yi mbɔ taʼa fɨʼɨ pugu Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nnɛ Jishɔ chhu ni pugu ŋa, “Shishini, ǹchhu ni pəɨ ŋa, minthɛ paʼa Muuŋ lɔ nchwīe nnu ni thɔ yi, a wuʼɔ nchwīe pi nnu ŋa a yəɨ Tǎa vi chwīe nu nɛ. Nthɛ ŋa sheshe nnu ŋa Tǎa ghà nchwīe nɛ, Muuŋ ghà ŋguʼɔ nchwīe pi yie ghɔ ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nthɛ ŋa Tǎa khwā Muuŋ nōoŋ ŋguoŋ nnu ŋa ju nduthɔ yi chwīe nu nɛ ghɔ. Ndɔ ti Tǎa shi nōoŋ mɛmmɛ fàʼa ŋa a chaa pei nɛ ghɔ, nɛnnɛ ŋa pəɨ ghrāo. ");
INSERT INTO bmo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nthɛ ŋa wuʼɔ nɔ haʼaŋ Tǎa pɨʼɨ ŋgwa khu mfɛ chɔmbhi ni pugu nɛ, a haʼaŋ Muuŋ fɛ chɔmbhi ni pa ŋgwa pɛ ŋa a khwā nɔ fɛ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tǎa shiʼa njiʼi nshaʼa shesheŋoŋ. A fɛ ŋguoŋ ghrɨ́ shaʼa nu ŋgwa pi ni Muuŋ, ");
INSERT INTO bmo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","nnɛ ŋa minthɛ ŋguoŋ ŋgwa ghaʼo Muuŋ nɔ haʼaŋ pugu ghaʼo Tǎa nɛ. Ŋoŋ ŋa a lɔ njiʼi ŋgaʼo Muuŋ nɛ lɔ njiʼi ŋgaʼo Tǎa ŋa a taoŋ Muuŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Shishini, ǹchhu ni pəɨ ŋa ŋoŋ ŋa a yaʼo chrà a mbiŋ ŋoŋ ŋa a taoŋ a nɛ, fāʼo chɔmbhi ki mmɛ, mbaʼa pi nuʼuŋ nshaʼa vi. A kwo tɔgɔ moŋ gu nii moŋ chɔmbhi. ");
INSERT INTO bmo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Shishini, ǹchhu ni pəɨ ŋa ndɨɨ chhɔ nthɔ nu, ŋkwo thɔ ti nchəɨŋ, ŋa ŋgwa khu shi njaʼo ŋggì Muuŋ Minnwi, ŋgwa pɛ ŋa pugu yaʼo mbiŋ nɛ fāʼo chɔmbhi. ");
INSERT INTO bmo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nthɛ ŋa nɔ haʼaŋ Tǎa nduthɔ yi ŋoŋ ŋa chɔmbhi llɔ mbhɔ yu nɛ, a wuʼɔ haʼaŋ a chwīe ŋa Muuŋ vi pɔ ŋoŋ ŋa chɔmbhi shi ndhɔ mbhɔ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A fɛ ghrɨ́ ghɔ nɔ shaʼa nu ŋgwa nthɛ ŋa a Muuŋ Ŋoŋmishua. ");
INSERT INTO bmo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kiʼi ŋgrāo nnu yei, nthɛ ŋa ndɨɨ chhɔ nthɔ nu ŋa ŋguoŋ ŋgwa pɛ ŋa pugu pɔ moŋ fúŋ nɛ shi njaʼo ŋggì yi, ");
INSERT INTO bmo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ndɔ ntaoŋ moŋ fúŋ ghɔ. Pɛ ŋa pugu ni nchwīe pa nnu shiʼi nɛ, pugu kuʼɔ moŋ chɔmbhi ki mmɛ, ŋgwa pɛ ŋa pugu chwīe phɨ nɛ kuʼɔ pi wɛ̄iŋ vugu nɔ pa ŋgushaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Minthɛ paʼa ǹdɔ nchwīe yichəɨ nnu pi ni nyaŋ ghrɨ́. Ŋ̀ga nshaʼa pi wuʼɔ nɔ haʼaŋ Minnwi chhu vəɨ ŋa ǹshaʼa nɛ, nnɛ shaʼa nu ma pɔ pi yi ndɨndɨ, nthɛ ŋa ǹchwīe pi nnu ŋa ŋoŋ haʼaŋ a taoŋ a tāʼa nu nɛ. Ǹdɔ njiʼi nchwīe pi nnu ŋa ǹtāʼa nu. ");
INSERT INTO bmo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","M̈i ŋkwe ntíe noŋ a ni noŋ a paʼa pi lɔ ndīi nnu ŋa ǹchhu nu nɛ ŋa a nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ndɔ yichəɨ ŋoŋ pɔ fɔ mbɔ miŋkwentie a, ǹji ŋa nnu ŋa a chhu nu nthɛ a nɛ, nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jouŋ, ŋoŋ ŋa pəɨ ni ntaoŋ ghaŋ ntaoŋ pəɨ ghɔ nɛ, a chhu nnu shini nthɛ a. ");
INSERT INTO bmo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","A lɔ mbɔ pi ŋa a ŋoŋmishua mbɔ miŋkwentie a. Ǹchrā pei nnu pi ŋa minthɛ pəɨ kie nnɛ ndūgu. ");
INSERT INTO bmo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jouŋ ni mbɔ nɔ laŋ ŋkɨɨ nu ndɔ ndiʼɛ nu. Pəɨ ni mfāʼo pwanjuʼɔ nɔ kuo ndɨɨ moŋ líʼɛ yi. ");
INSERT INTO bmo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ndɔ m̀fāʼo yichəɨ miŋkwentie ŋa a chaa pɛ nnu ŋa Jouŋ ni nchhu nthɛ a nɛ. Nthɛ ŋa pa fàʼa ŋa Tǎa fɛ vəɨ ŋa m̀fāʼa nɛ, mbɔ fàʼa pɛ ŋa m̀fāʼa nu nɛ, kwe ntie a ŋa a taoŋ Tǎa ntaoŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tǎa ŋa a taoŋ a nɛ, kwe ntie a. Pəɨ lɔ naa ma njaʼo ŋggì yi moŋ sheshe ndɨɨ, ki njəɨ vi ŋkwaŋ haʼaŋ a pɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pəɨ lɔ nūʼɔŋ chrà yi moŋ njùʼɔ pəɨ nthɛ ŋa pəɨ lɔ njiʼi mbiŋ ŋoŋ ŋa a taoŋ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Pəɨ tāʼa moŋ Ŋwaʼaŋlɨ Minnwi nthɛ ŋa pəɨ pīʼi ŋa pəɨ shi ma mfāʼo chɔmbhi ki mmɛ moŋ ghɔ. Ndɔ Ŋwaʼaŋlɨ Minnwi yei chrā nthɛ pi mmu. ");
INSERT INTO bmo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ndɔ pəɨ lāa thɔ nu njəɨ a nnɛ ŋa pəɨ fāʼo chɔmbhi. ");
INSERT INTO bmo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ǹdɔ njiʼi ntāʼa ndighaʼo pi llɔ mbhɔ ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ǹji ŋkwaŋ ŋgwa ŋa pəɨ yie ghɔ nɛ, ŋa pəɨ lɔ njiʼi mfāʼo khwǎ Minnwi mbɨŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ǹthɔ moŋ ligi Tǎa a ndɔ paʼa pəɨ lɔ mbiŋ a. Yichəɨ ŋoŋ nthɔ moŋ ji ligi pəɨ piŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pinthɛ pəɨ kie pi nɛiŋ mbiŋ ŋa pəɨ tāʼa ndighaʼo pi mbhɔ noŋ pəɨ nɛ. Ndɔ paʼa ndɔ ntāʼa ndighaʼo ŋa a llɔ mbhɔ fiɛŋ taʼa Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Kiʼi pəɨ pīʼi ŋa ǹshi ŋgwɛ̄iŋ vəɨ shhɨ Tǎa. A taʼa ŋoŋ ŋa a shi ŋgwɛ̄iŋ vəɨ shhɨ Tǎa, mbɔ Mushi ŋa pəɨ nūʼɔŋ kwàʼa yəɨ mbɨŋ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nthɛ ŋa pəɨ kaŋ ni mbiŋ Mushi, pəɨ kaŋ mbiŋ a, nthɛ ŋa a ni nāʼaŋ nthɛ pi mmu. ");
INSERT INTO bmo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ti pəɨ mieŋ ki piŋ pa nnu haʼaŋ a nāʼaŋ, pəɨ kie pi nɛiŋ mbiŋ chrà a?” ");
INSERT INTO bmo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pa pei nnu ni ŋga ntɔgɔ, Jishɔ lɔllɔ ŋgə̄ɨ shāʼa ntaoŋ nɔ yini njiɛŋ ŋkhǐ Galili, ŋa pi mɛ̄iŋ ni ŋkhǐ Tiberia nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ŋkiɛŋ ntou yu ŋgwa yōu njiŋ yi nthɛ ŋa pugu ni njəɨ fɨʼɨ pa lì ŋa a nōoŋ nu, mbɔ yɨ̄gɨ nu ghɨ̌nɔ ghaŋ ghɨ̌nɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jishɔ kuʼɔ ŋkuoŋ mbra nchɔchhɔ fɔ pugu pa ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ndɨɨ jɨ Lli Njiʼa, mbɔ jɨ pa Juu ni ŋkwo para. ");
INSERT INTO bmo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nthɛ yie ghɔ, Jishɔ gha ŋkə̄rə ligi yi, njəɨ ŋkiɛŋ ntou yú ŋgwa thɔ nu yəɨ yu, a chhu ni Fili ŋa, “Pia shi njuoŋ brɛi pi hɨŋ nnɛ ŋa a nthɛ fɨʼɨ ŋgwa pei kru?” ");
INSERT INTO bmo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A ni nchhu yei pi nɔ ywɛʼi nu Fili nthɛ ŋa ju nduthɔ yi ni nji nnu ŋa a shi nchwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fili khwɛ̄ ŋa, “Pi njiʼi njuoŋ brɛi pi ni fɨʼɨ mbɨŋ ŋa ŋoŋ nthɛ a fāʼa nɔ paa ŋkɨɨ llɛ́ nɛ, paʼa a lɔ njiʼi ŋkāʼo nɔ fɨʼɨ brɛi ŋa a nthɛ shesheŋoŋ fāʼo shɨgɛi fɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yichəɨ taʼa ŋgaŋ younjiŋ yi mbɔ Andru ndǐŋ Shemu Pita chhu ghɔ ŋa, ");
INSERT INTO bmo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Muuŋ mimbia chəɨ pɔ hɛiŋ ŋa a fāʼo tiɛŋ brɛi ŋa pi chwīe ni balɛ nɛ, ni paa shhu. Ndɔ yie pɔ pi khɔ ni fɨʼɨ ntou ŋgwa pei.” ");
INSERT INTO bmo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jishɔ chhu ŋa, “Chwīe ŋgwa chɔchɔ shhɛ.” Ntou trǔ ni mbɔ nɔ lɨʼɨ ghɔ. Ŋguoŋ ŋgwa pighɔ chɔchɔ shhɛ, pimbia ni mbɔ nɔ tiɛŋ kaŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jishɔ lɔ̄gɔ brɛi ghɔ ŋga ŋkwo tōo Minnwi, ŋgrā ni ŋgwa ŋa pugu pi nchhɔ shhɛ nɛ. Ŋguʼɔ nchwīe pi nnɛ ni shhu ghɔ, shesheŋoŋ fāʼo fɨʼɨ ŋkwaŋ haʼaŋ a khwā nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pugu ni ŋga njru, a chhu ni ghaŋ younjiŋ pi ŋa, “Pəɨ kɨrɨ pa pɨgəɨ kuo pi, kiʼi sheshe yaoŋ phɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nɛnnɛ pugu kɨrɨ, a lɨnaoŋ paanchrɔ mikuo pa kuo brɛi llɔ ŋkuoŋ tiɛŋ ndigi brɛi ghɔ ŋa ŋgwa pighɔ kru a pɨgəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ŋgwa pighɔ ni ŋga njəɨ yei lì ŋa a ni nōoŋ nɛ, nchhu ŋa, “Yei ya mbɔ njəɨlɨʼɨ Minnwi shini ŋa a ni mfāʼo nɔ thɔ nu moŋ mbhi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jishɔ ni ŋga nji ŋa pi tāʼa nu nthɔ ŋgwɛ̄iŋ vi mfra vi nūʼɔŋ vi nɔ fùoŋ, a pɨ̄nɨ njiŋnjiŋ ŋgə̄ɨ ŋkuoŋ mbra mbɔ fɔ təʼɨ vi. ");
INSERT INTO bmo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","A ni ŋga mbɔ ni fanaoŋ, pa ghaŋ younjiŋ Jishɔ shwiʼi ŋkɨŋ ŋkhǐ, ");
INSERT INTO bmo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","nii moŋ kikuoŋ, njɛ̄ shāʼa nu ntaoŋ Kapanuŋ. Tuʼu ni ŋkwo shini, ndɔ paʼa Jishɔ lɔ naa nthɔ mbara vugu yaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ŋkiɛŋ tɨtɨnɨ fɨfrəɨ ni ntɔgɔ nu thɔ ŋkhǐ, moŋ ŋkhǐ gū pa ŋgwanyieŋ. ");
INSERT INTO bmo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nɛnnɛ pugu ni ŋga ŋkwo chhwi pie ŋgə̄ɨ yaoŋ nɔ tiɛŋ ŋkaŋ ki ntɨgao ŋkaŋ kwò moŋ ŋkhǐ, njəɨ Jishɔ a nyīeŋ ŋkuoŋ ŋkhǐ nthɔ nu yəɨ kikuoŋ ghɔ, pɔgɔ gu wɛ̄iŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ndɔ a chhu ni pugu ŋa, “A mmu, kiʼi pəɨ pɔgɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nnɛ pugu ni ŋkhwā ŋa a nii moŋ kikuoŋ, wuʼɔ ndɨɨ ghɔ, pugu kaoŋ pie yugu nɔ lɨʼɨ ŋa pugu ni ŋgə̄ɨ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mbhi ni ŋga ndaŋ, yú ŋgwa pɛ ŋa pugu ni ŋkɨna nɔ yini njiɛŋ ŋkhǐ nɛ yəɨ ŋa pichəɨ pa puoŋ mi kikuoŋ shini ndɔ njiʼi mbɔ fɔ ŋkiɛŋ taʼa yi ndɔ paʼa Jishɔ lɔ nii kikuoŋ pugu pa ghaŋ younjiŋ pi ŋgə̄ɨ kaʼa, pugu ni ŋgə̄ɨ pi təʼɨ vugu. ");
INSERT INTO bmo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pichəɨ pa kikuoŋ llɔ Tiberia ni nthɔ mbara nɔ lɨʼɨ haʼaŋ pugu ni ŋkru brɛi ghɔ ndɨɨ ŋa Taathɔ ni ŋkwo fɛ tōo nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nɛnnɛ yú ŋgwa pighɔ ni ŋga njəɨ ŋa Jishɔ shi lɔ mbɔ fɔ, ki pa ghaŋ younjiŋ pi nɛ, pugu ni nduthɔ yugu nii moŋ pa kikuoŋ nshāʼa Kapanuŋ nthɔ ntāʼa Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pugu ni ŋga njəɨ vi moŋ yini njiɛŋ ŋkhǐ, mbie vi ŋa, “Masha, ɔ ni nthɔ hɛiŋ pi ndɨɨ khɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jishɔ khwɛ̄ ni pugu ŋa, “Shishini, ǹshwei vəɨ, pəɨ lɔ ntāʼa a nthɛ pi ŋa pəɨ yəɨ pa lì, pəɨ tāʼa a nthɛ pi ŋa pəɨ ni ŋkru brɛi ti njru. ");
INSERT INTO bmo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kiʼi pəɨ wie noŋ yəɨ pi nɔ maoŋ jɨ pɛ ŋa a ghà mbɨrɨ nɛ, pəɨ wie noŋ yəɨ pi nɔ maoŋ jɨ ŋa a ghà kɨna mfɛ chɔmbhi ki mmɛ nɛ, ŋa Muuŋ Ŋoŋmishua shi mfɛ ni pəɨ nɛ, nthɛ ŋa Minnwi mbɔ Tǎa kwo nūʼɔŋ lì yi mbɨŋ yu ŋa a piŋ vi.” ");
INSERT INTO bmo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nnɛ pugu chhu ghɔ ŋa, “Pigi shi nchwīe pi nɛiŋ nɔ thɔ nu fāʼa fàʼa Minnwi?” ");
INSERT INTO bmo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jishɔ khwɛ̄ ni pugu ŋa, “Yei fàʼa Minnwi, ŋa pəɨ piŋ ju ŋa Minnwi taoŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nnɛ pugu chhu ghɔ ŋa, “Ti ɔ nōoŋ pi yəɨ lì nnɛ ŋa pigi yəɨ mbiŋ ghɔ? Nnu ŋa ɔ shi nchwīe nɛ khɔ? ");
INSERT INTO bmo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pa tǎa pigi ni njɨ maoŋ jɨ ŋa pi mɛ̄iŋ ni mana nɛ moŋ ŋkǔnu njó wuʼɔ nɔ haʼaŋ Ŋwaʼaŋlɨ Minnwi chhu ŋa, ‘A ni mfɛ brɛi llɔ po ŋa pi kru.’ ” ");
INSERT INTO bmo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jishɔ chhu kiʼɛ ni pugu ŋa, “Shishini, ǹchhu ni pəɨ, a shi ki lɔ mfɛ Mushi mfɛ brɛi llɔ po ni pəɨ, ndɔ Tǎa a fɛ ŋkiɛŋ brɛi ŋa a llɔ po nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nthɛ ŋa brɛi Minnwi Ju ŋa a llɔ po nshwiʼi shhɛ mfɛ chɔmbhi ni ŋgwa ŋkuoŋ mbhi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pugu chhu ghɔ ŋa, “Masha, fɛ brɛi yei ni pigi ŋguoŋ ndɨɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jishɔ chhu ni pugu ŋa, “A mmu mbɔ brɛi chɔmbhi, shesheŋoŋ ŋa a thɔ njəɨ a nɛ, mbaʼa nji ma nuʼuŋ njia vi, ndɔ shesheŋoŋ ŋa a piŋ a nɛ, mbaʼa njùʼɔ yi ma nuʼuŋ njaoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ndɔ nchu ni pəɨ ŋa pəɨ lɔ mbiŋ a, njiʼi nthɛ nɔ haʼaŋ pəɨ yəɨ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ŋguoŋ ŋgwa ŋa Tǎa fɛ vəɨ nɛ shi nthɔ njəɨ a, ndɔ shesheŋoŋ ŋa a shi nthɔ njəɨ a nɛ, m̀baʼa njiʼi ndāa vi. ");
INSERT INTO bmo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nthɛ ŋa ǹdɔ njiʼi nshwiʼi llɔ po pi nɔ chwīe nu nyaŋ nnu ŋa ǹtāʼa nu nɛ, ǹshwiʼi pi nɔ chwīe nu nnu ŋoŋ ŋa a taoŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yei nnu ŋa Minnwi ŋoŋ ŋa a taoŋ a nɛ tāʼa nu nɛ, ŋa kiʼi m̀bhɛ sheshe yaoŋ shɨna ŋguoŋ yi yɛ ŋa a fɛ vəɨ nɛ, ŋa m̂bɨʼɨ vugu tɔthɨ moŋ ndugwi njiŋ llɛ́. ");
INSERT INTO bmo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yei nnu ŋa Tǎa a tāʼa nu nɛ, ŋa shesheŋoŋ ŋa a pɨʼɨ ligi yi ndīi Muuŋ ndɔ mbiŋ vi nɛ, fāʼo chɔmbhi ki mmɛ, ǹshi mbɨʼɨ vi tɔthɨ moŋ ndugwi njiŋ llɛ́.” ");
INSERT INTO bmo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nnɛ pa ŋgwa Juu jɛ̄ luo nu nthɛ vi, nthɛ ŋa a chhu ŋa, “A mmu mbɔ brɛi ŋa a llɔ po nshwiʼi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pugu chhu ŋa, “Yei lɔ mbɔ Jishɔ muuŋ Joshɛ, ŋa pigi ji tǎa vi pugu mǔuŋ vi nɛ? A nthɛ a kie pi nɛiŋ nchhu ndwɛ ŋa, ‘Ndhɔ pi po nshwiʼi?’ ” ");
INSERT INTO bmo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jishɔ khwɛ̄ ni pugu ŋa, “Kiʼi pəɨ luo nu shɨna pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Minthɛ paʼa kaŋ taʼa ŋoŋ lɔ nthɔ njəɨ a ki Tǎa ŋa a taoŋ a nɛ lɔ nshūu vi nthɔ nɔ. Ndɔ ǹshi mbɨnɨ mbɨʼɨ vi moŋ gu nɔ ndugwi njiŋ llɛ́. ");
INSERT INTO bmo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pa njəɨlɨʼɨ Minnwi ni nāʼaŋ ŋa, ‘A lɛ njɛʼi Minnwi njɛʼi vugu.’ Shesheŋoŋ ŋa a kwo yaʼo ndɔ njɛʼi yaoŋ mbhɔ Tǎa nɛ shi nthɔ njəɨ a. ");
INSERT INTO bmo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yei lɔ mbɔ pi ŋa yichəɨ ŋoŋ kwo yəɨ Tǎa, Ju ŋa a llɔ mbhɔ Minnwi nɛ wuʼɔ fiɛŋ ŋoŋ ŋa a yəɨ Tǎa nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Shishini, ǹshwei vəɨ, shesheŋoŋ ŋa a piŋ nɛ fāʼo chɔmbhi ki mmɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A mmu mbɔ brɛi chɔmbhi. ");
INSERT INTO bmo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pa tǎa pəɨ ni njɨ mana moŋ ŋkǔnu njó, ndɔ ŋguoŋ yugu wuʼɔ ŋkhukhu. ");
INSERT INTO bmo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yei yɛ brɛi ŋa a shwiʼi llɔ po, nɛnnɛ ŋa mimfɛ ŋoŋ kru ki lɔ ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","A mmu mbɔ brɛi maoŋ ŋa a shwiʼi llɔ po. S̈hesheŋoŋ ŋkru brɛi yei, kaŋ a shi mfāʼo chɔmbhi ki ndugwi yi. Ndɔ brɛi yɛ ŋa ǹshi mfɛ nɔ chɔmbhi ŋgwa ŋkuoŋ mbhi yei nɛ, pɔ pi frɛinoŋ a.” ");
INSERT INTO bmo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nnɛ pa Juu jɛ̄ mindoundou shɨna pugu, nchhu nu ŋa, “Mimfɛ ŋoŋ vei kie nɛiŋ mfɛ frɛ̀i yi ŋa pia kru?” ");
INSERT INTO bmo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nthɛ yie, Jishɔ chhu ni pugu ŋa, “Shishini, ǹshwei vəɨ, p̈əɨ mieŋ ki kru frɛ̀i Muuŋ Ŋoŋmishua, mbɨnɨ nnu chhǐ yi, nthɛ paʼa pəɨ lɔ mfāʼo chɔmbhi mbɨŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Shesheŋoŋ ŋa a kru frɛinoŋ a ndɔ nnu chhǐ a nɛ fāʼo chɔmbhi ki mmɛ, ǹdɔ mbɨnɨ mbɨʼɨ vi moŋ gu moŋ ndugwi njiŋ llɛ́. ");
INSERT INTO bmo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nthɛ ŋa frɛinoŋ a ya ŋkiɛŋ maoŋ jɨ, chhǐ a pɔ ya ŋkiɛŋ maoŋ nnu. ");
INSERT INTO bmo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Shesheŋoŋ ŋa a kru frɛinoŋ a ndɔ nnu chhǐ a nɛ ghà ŋkɨna mbɨŋ mu, ŋ̀kɨna mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nɔ haʼaŋ Tǎa ŋa a yi maoŋ taoŋ a, m̀fāʼo chɔmbhi nthɛ pi Tǎa ghɔ nɛ, nɛnnɛ, shesheŋoŋ ŋa a kru frɛinoŋ a nɛ, ju ŋkaa yu shi mbɔ yi maoŋ nthɛ a. ");
INSERT INTO bmo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yei brɛi ŋa a ni nshwiʼi llɔ po nɛ, a lɔ mbɔ pi nɔ yɛ ŋa pa tǎa ni ŋkru ndaʼa ŋguʼɔ ŋkukhu nɛ. Shesheŋoŋ yɛ ŋa a kru frɛinoŋ a yei nɛ shi nchhɔ mbhi ki ndugwi yi.” ");
INSERT INTO bmo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jishɔ ni nchhu pa nnu pei moŋ nda luoŋ Minnwi nɔ haʼaŋ a ki yɛʼi nu Kapanuŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ndɨɨ ŋa ntou pa ghaŋ younjiŋ pi ni njaʼo yei nɛ, pugu chhu ŋa, “Yei chrà tɨnɨ ŋgaʼa, a nthɛ a ywɛrɛ gɔ̀ chrà ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ndɔ Jishɔ ni nji ŋa pa ghaŋ younjiŋ pi thɔ nduo nu nthɛ nnu yei, nnɛ a chhu ni pugu ŋa, “Nnu yei pɨgɨ vəɨ? ");
INSERT INTO bmo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ti a kaŋ ni mīʼɛŋ mbɔ pəɨ yəɨ Muuŋ Ŋoŋmishua kuʼɔ nu lɨʼɨ ŋa a ni fǔoŋ mbɔ nɛ? ");
INSERT INTO bmo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A ghà mfɛ Jijwɛ chɔmbhi, frɛinoŋ lɔ mfāʼo ghɛ̀rɛ kaŋ shɨgɛi. Chrà pɛ ŋa ǹchrā ni pəɨ nɛ pɔ pi jijwɛ pugu chɔmbhi. ");
INSERT INTO bmo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ndɔ pichəɨ shɨna pəɨ lɔ njiʼi mbiŋ.” (Nthɛ ŋa Jishɔ ni nji llɔ nɔ njɛ̄ yi pɛ ŋgwa ŋa pugu shini ndɔ mbiŋ nɛ, ndɔ nji ŋoŋ vɛ ŋa a shi mfīni vi nɛ.) ");
INSERT INTO bmo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A chhu ŋa, “Yei nnu ŋa a ni nchwīe nchhu ni pəɨ ŋa mbaʼa ŋoŋ thɔ njəɨ a, kaŋ a nɛ a fɛ Tǎa ghrɨ́ ghɔ nɔ thɔ nu.” ");
INSERT INTO bmo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jɛ̄ ndɨɨ yei ntou pa ghaŋ younjiŋ pi pɨ̄nɨ ki lɔ nuʼuŋ nyīeŋ pugu pugu. ");
INSERT INTO bmo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nnɛ Jishɔ pie paanchrɔ ghaŋ younjiŋ pi ŋa, “Pəɨ tāʼa nu ŋgə̄ɨ ŋkaa pəɨ?” ");
INSERT INTO bmo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Shemu Pita khwɛ̄ ghɔ ŋa, “Taathɔ, pigi shi ŋgə̄ɨ njəɨ pi gɔ̌? Ɔ fāʼo chrà chɔmbhi ki mmɛ, ");
INSERT INTO bmo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ndɔ pigi kwo piŋ, ndɔ nji ŋa ɔ Yi Taoŋtaoŋ Llɔ Mbhɔ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nnɛ Jishɔ chhu ni pugu ŋa, “A lɔ nchuʼɔ mmu nchuʼɔ vəɨ Paanchrɔ? Ndɔ taʼa ŋoŋ shɨna pəɨ pɔ devɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","A ni nchhu pi Judashi, mbɔ muuŋ Shemu Ishikario, nthɛ ŋa a taʼa ŋoŋ shɨna Paanchrɔ ghɔ nɛ, ni mbɔ nɔ fīni nu vi. ");
INSERT INTO bmo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nnu pei ni ŋga ntɔgɔ, Jishɔ nyīeŋ nu moŋ Galili. A shini ndɔ ntāʼa nu nyīeŋ moŋ Judia nthɛ ŋa pa thishɨ ŋgwa Juu ni ntāʼa nu njwi vi. ");
INSERT INTO bmo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A ni mbiʼi shɨgɛi ndɨɨ jɨ pa ŋgwa Juu ŋa pi mɛ̄iŋ ni jɨ pa ntǎa nɛ kāʼo. ");
INSERT INTO bmo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Pa lǐŋ pi chhu ghɔ ŋa, “Lɔllɔ hɛiŋ ŋgə̄ɨ Judia nji ŋa pa ghaŋ younjiŋ pɔ shi njəɨ pa fàʼa ŋa ɔ chwīe nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nthɛ ŋa ŋoŋ ŋa a tāʼa nu ŋa pi ji vi nɛ ghà fāʼa pi lɨʼɨ wo. Ŋa ɔ thɔ nchwīe pa nnu pei nɛ, chwīe ŋkuoŋ mbhi ji ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nthɛ ŋa njiʼi nthɛ pa lǐŋ pi shini ndɔ mbiŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jishɔ khwɛ̄ ni pugu ŋa, “Ndɨɨ a lɔ naa ŋkāʼo yaʼa. Ni pəɨ, sheshe ndɨɨ kaʼokaʼo. ");
INSERT INTO bmo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mbaʼa ŋkuoŋ mbhi pɨ̄na vəɨ ndɔ a pɨ̄na a nthɛ ŋa ǹchhu pa nnu nthɛ vi ŋa mbha fàʼa pi, pi pɨphɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pəɨ kuʼɔ lɨʼɨ jɨ ghɔ. Ǹdɔ njiʼi ŋkuʼɔ nu lɨʼɨ jɨ ghɔ nthɛ ŋa ndɨɨ a lɔ naa nja ŋkāʼo yaʼa.” ");
INSERT INTO bmo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A ni ŋga nchhu yei nnu, ŋkɨna Galili. ");
INSERT INTO bmo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pa lǐŋ pi ni ŋga ŋkwo kuʼɔ lɨʼɨ jɨ ghɔ, juju kuʼɔ ŋkaa yu, ki lɔ mbɔ pi lɨʼɨ wo, mbɔ pi njiŋnjiŋ. ");
INSERT INTO bmo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pa thishɨ ŋgwa Juu ni nthɔ ntāʼa vi lɨʼɨ jɨ ghɔ, mbie nu ŋa, “A pɔ pi hɨŋ?” ");
INSERT INTO bmo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ntou pa nchǔŋ ni mbɔ nu shɨna pa ŋgwa nthɛ vi, pichəɨ ni ŋga nchhu nu ŋa, “A ŋkiɛŋ ŋoŋ,” pichəɨ ŋa, “Ŋga, a thɔ nchwīe nu ŋgwa fāaŋ ndaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ndɔ paʼa kaŋ taʼa ŋoŋ lɔ nchrā nthɛ vi shhɛnte, nthɛ ŋa pugu ni nthɔ mbɔgɔ pa thishɨ ŋgwa Juu. ");
INSERT INTO bmo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jɨ ghɔ ni ŋga ŋgə̄ɨ ti nchəɨŋ titri, Jishɔ kuʼɔ moŋ Nda Minnwi njɛ̄ yɛʼi nu. ");
INSERT INTO bmo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pa thishɨ pa ŋgwa Juu ghrāo, nchhu nu ŋa, “A kie pi nɛiŋ ŋoŋ vei ji fɨʼɨ yaoŋ yei, ndɔ ki lɔ naa ma ŋgə̄ɨ shiku?” ");
INSERT INTO bmo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nnɛ Jishɔ khwɛ̄ ni pugu ŋa, “Yaoŋ ŋa njɛʼi nu nɛ lɔ mbɔ pi nyaŋ, a pɔ pi yi ŋoŋ ŋa a taoŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sheshe n̈nu ŋa ŋoŋ tāʼa nu nchwīe nɛ mbɔ pi nnu ŋa Minnwi tāʼa nu nɛ, kaŋ a shi nji ŋa yaoŋ ŋa ǹjɛʼi nu nɛ llɔ pi mbhɔ Minnwi ki mi chrā pi ni nyaŋ ghrɨ́? ");
INSERT INTO bmo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ŋoŋ ŋa a ghà nchrā pi ni ji ghrɨ́ nɛ ghà ntāʼa pi ji ndighaʼo ni noŋ yi. Ndɔ ŋoŋ ŋa a ghà ntāʼa pi ndighaʼo ŋoŋ ŋa a taoŋ vi nɛ, ŋgaŋ nnu shini paʼa ndɔ mfāʼo kaŋ taʼa nnu mifɨɨ. ");
INSERT INTO bmo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mushi lɔ ŋkwo fɛ gɨ́ ni pəɨ? Ndɔ kaŋ taʼa ŋoŋ vəɨ shiʼa nūʼɔŋ. Pəɨ tāʼa nu njwi a ŋa?” ");
INSERT INTO bmo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kɨrɨ ghɔ khwɛ̄ ŋa, “Ɔ fāʼo miŋwɛiŋ! A tāʼa gɔ̌ njwi ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jishɔ khwɛ̄ ni pugu ŋa, “Ŋki chwīe taʼa fàʼa, ŋguoŋ yəɨ ghrāo nthɛ taʼa fàʼa ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mushi ni mfɛ gɨ́ ŋa pəɨ niʼiŋ puoŋ pəɨ ŋgunu mbrɛi (a lɔ njiʼi mbɔ ŋa a ni ndhɔ pi mbhɔ Mushi, a ni ndhɔ pi mbhɔ pa tǎa), nnɛ pəɨ niʼiŋ ŋoŋ ŋgunu mbrɛi llɛ́ ji. ");
INSERT INTO bmo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ti p̈əɨ niʼiŋ ŋoŋ ŋgunu mbrɛi llɛ́ ji nnɛ ŋa a pɔ ŋa pəɨ lɔ mbəʼɨ gɨ́ Mushi, pəɨ pɨnɨ mbɨgɨ túa vəɨ ŋa ǹchwīe ŋguoŋ noŋ ŋoŋ ya tɔgɔ shiʼi llɛ́ ji nthɛ khɔ? ");
INSERT INTO bmo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kiʼi pəɨ shaʼa ŋgwa pi ŋkwaŋ haʼaŋ a fhi nɔ haʼaŋ a kāʼo ligi pəɨ nɛ, pəɨ shaʼa ŋgwa pi ŋkwaŋ haʼaŋ a kāʼo ŋa pi shaʼa nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pichəɨ pa ŋgwa Jerushalɛiŋ chhu ŋa, “Yei shi lɔ mbɔ ŋoŋ ŋa pi tāʼa vi njwi nɛ? ");
INSERT INTO bmo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A pɔ nɛiŋ hɛiŋ nchrā nu shhɛnte. Ndɔ paʼa pugu lɔ nchhu nnu ghɔ! Pinthɛ a pɔ ŋa pa thishɨ ji ŋa a Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ? ");
INSERT INTO bmo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ndɔ ndɨɨ ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe thɔ nɛ, mbaʼa ŋoŋ ji lɨʼɨ ŋa a llɔ nɛ. Ndɔ pia ji lɨʼɨ ŋa vei ŋoŋ llɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nɔ haʼaŋ Jishɔ ni njɛʼi nu moŋ Nda Minnwi nɛ, a ni nchhu ni njɨ ŋa, “Pəɨ ji a, ndɔ nji lɨʼɨ haʼaŋ ǹdhɔ nɛ? Ǹdɔ njiʼi nthɔ pi ni thɔ a. Ju ŋa a taoŋ a nɛ ŋgaŋ chrà nnu shini, ndɔ pəɨ lɔ nji vi. ");
INSERT INTO bmo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ǹji vi nthɛ ŋa ǹdhɔ pi mbhɔ yu, a taoŋ a.” ");
INSERT INTO bmo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nɛnnɛ pugu ni nthɔ ntāʼa shɛndaoŋ nɔ wɛ̄iŋ nu mi, ndɔ paʼa ŋoŋ lɔ ŋkāoŋ vi nthɛ ŋa ndɨɨ yi shini ndɔ naa nthɔ yaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ndɔ ntou ŋgwa ka piŋ vi piŋ nchhu ŋa, “Ndɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, shi ŋga nthɔ, a nōoŋ lì a yiɛŋ nchaa yi ŋoŋ vei?” ");
INSERT INTO bmo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pa Farashi yaʼo yú ŋgwa pighɔ thɔ nchūŋ nnu pei nthɛ Jishɔ. Nɛnnɛ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋgwa Farashi taoŋ pa ghaŋ kɛ̄ʼi Nda Minnwi ŋa pugu ghə̄ɨ ŋgwɛ̄iŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jishɔ chhu kiʼɛ ŋa, “Pia shi mbɨnɨ mbɔ kaʼa nɔ kuo ndɨɨ, ŋ̀gə̄ɨ kiʼɛ njəɨ ŋoŋ ŋa a taoŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pəɨ shi ntāʼa a ndɔ mbaʼa pəɨ yiʼi njəɨ a. Lɨʼɨ haʼaŋ ŋ̀gə̄ɨ nu fɔ nɛ mbaʼa pəɨ thɔ fɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pa thishɨ ŋgwa Juu chhu ni noŋ pugu ŋa, “Ŋoŋ vei tāʼa ŋgə̄ɨ pi hɨŋ ŋa mbaʼa pigi yiʼi njəɨ vi? A tāʼa nu ŋgə̄ɨ moŋ laʼataoŋ nduoŋ lɨʼɨ haʼaŋ ŋgwa pia pɔ nɛ, njɛʼi pa ŋgwa nduoŋ pighɔ? ");
INSERT INTO bmo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A chhu ŋa, ‘Pəɨ shi ntāʼa a ndɔ mbaʼa pəɨ yiʼi njəɨ a’, pugu pa ŋa, ‘Lɨʼɨ haʼaŋ ŋgə̄ɨ nu fɔ nɛ mbaʼa pəɨ thɔ fɔ.’ Njiŋ nnu pighɔ pɔ pi ŋa?” ");
INSERT INTO bmo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Moŋ ndugwi njiŋ llɛmbhi jɨ ghɔ, mbɔ mmɛ llɛ́, Jishɔ lɔllɔ ntithi tɔthɨ nchhu ni njɨ ŋa, “Njùʼɔ ŋoŋ njaoŋ, a thɔ mbara a nnu yaoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Shesheŋoŋ ŋa a piŋ a nɛ, pa nɨnəɨ ŋkhǐ fɛ chɔmbhi shi ŋkhī ntaoŋ nu njùʼɔ yu, nɔ haʼaŋ Ŋwaʼaŋlɨ Minnwi chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A ni nchhu yei nthɛ pi Jijwɛ Minnwi ŋa ŋgwa pɛ ŋa pugu piŋ vi shi mfāʼo nɛ. A ni ŋga mbɔ ndɨɨ ghɔ paʼa pi lɔ naa mfɛ Jijwɛ Minnwi nthɛ ŋa Jishɔ shini ndɔ naa nii moŋ ndighaʼo yi. ");
INSERT INTO bmo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pugu ni ŋga njaʼo pa chrà pei, pichəɨ pa ŋgwa pighɔ chhu ŋa, “Yei ya mbɔ pi njəɨlɨʼɨ Minnwi shini.” ");
INSERT INTO bmo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pichəɨ chhu ŋa, “Yei Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ.” Ndɔ pichəɨ chhu yugu ŋa, “Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe ni mbɔ nɔ llɔ nu pi Galili? ");
INSERT INTO bmo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ŋwaʼaŋlɨ Minnwi lɔ nchhu ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ shi ndhɔ pi moŋ ŋgwrɛiŋoŋ fùoŋ Devi, pi phi vi Bɛtɛlɛhɛiŋ mbɔ laʼataoŋ fùoŋ Devi?” ");
INSERT INTO bmo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nnɛ minduoŋnduoŋ gū shɨna ŋgwa pighɔ nthɛ vi. ");
INSERT INTO bmo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pichəɨ shɨna pugu ni ntāʼa nu ŋgwɛ̄iŋ vi ndɔ paʼa ŋoŋ lɔ ŋkāoŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pa ghaŋ kɛ̄ʼi Nda Minnwi ni ŋga mbɨnɨ, pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋgwa Farashi pie vugu ŋa, “A chwīe khɔ paʼa pəɨ lɔ ŋkwəɨ ni ju?” ");
INSERT INTO bmo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pa ghaŋ kɛ̄ʼi Nda Minnwi pighɔ khwɛ̄ ŋa, “Yichəɨ ŋoŋ lɔ naa ma nchrā nɔ ŋoŋ vei.” ");
INSERT INTO bmo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pa Farashi pie vugu ŋa, “Pi fɨ̄ɨ vəɨ ŋkaa pəɨ? ");
INSERT INTO bmo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Sheshe pa thishɨ pugu pa ŋgwa Farashi piŋ vi? ");
INSERT INTO bmo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yú ŋgwa pei ŋa pugu lɔ nji gɨ́ Mushi nɛ, nchɔ̀nɔ Minnwi pɔ mbɨŋ pugu.” ");
INSERT INTO bmo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemu ŋa a ni mbɔ taʼa ŋoŋ vugu nɛ, ni ŋkwo ghə̄ɨ njəɨ vi ŋgɛ́ chəɨ nɛ, chhu ni pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Gɨ́ yia ghà ŋgwɛ̄iŋ ŋoŋ ŋa a ŋgushaʼa ki lɔ fǔoŋ mfɛ shɨ̀na ghɔ ŋa a chrā? Ndɔ mbɨnɨ nuʼuŋ ndīi nnu haʼaŋ a chwīe nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pugu khwɛ̄ ŋa, “Ɔ llɔ pi Galili ŋkaa ghɔ? Taʼa nɛ moŋ Ŋwaʼaŋlɨ Minnwi njəɨ ŋa yichəɨ njəɨlɨʼɨ Minnwi ni ŋkwo ma ndɔ Galili?” ");
INSERT INTO bmo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Shesheŋoŋ vugu ghə̄ɨ moŋ ji laʼa. ");
INSERT INTO bmo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ndɔ Jishɔ kuʼɔ ŋkuoŋ Mbra pa Thɨ Olive. ");
INSERT INTO bmo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ŋkiɛŋ ni muuŋ tutuʼu a pɨnɨ nthɔ moŋ Nda Minnwi ŋguoŋ ŋgwa thɔ njəɨ vi, a chɔchɔ shhɛ nthɔ njɛʼi vugu. ");
INSERT INTO bmo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi pugu pa ŋgwa Farashi thɔ ni miŋgwɛ láŋ chəɨ ŋa pi ni ŋgwɛ̄iŋ vugu mimbia moŋ shúoŋ, nthɔ ni ju ntigi vi shhɨ ŋguoŋ ŋgwa ghao. ");
INSERT INTO bmo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pugu chhu ni Jishɔ ŋa, “Masha, pigi ya ŋgwɛ̄iŋ miŋgwɛ láŋ vei pugu mimbia. ");
INSERT INTO bmo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moŋ gɨ́ Mushi, a chhu ŋa pi tuŋ ŋkwaŋ miŋgwɛ vei ni ŋgùʼɔ a khu. Ɔ chhu jɔ ŋa?” ");
INSERT INTO bmo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pugu ni nchhu yei nɔ mōoŋ nu Jishɔ nnɛ ŋa pinthɛ pugu fāʼo nnu nɔ wɛ̄iŋ nu mi nɔ ghɔ. Ndɔ Jishɔ tuʼu noŋ yi nāʼaŋ yaoŋ ni muuŋshɨmbhɔ yi shhɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nɔ haʼaŋ pugu ni ŋgə̄ɨ shhɨ ŋguʼɔ mbie vi nɛ, a lɔllɔ tɔthɨ nchhu ni pugu ŋa, “Ŋoŋ ŋa a lɔ njiʼi nchwīe phɨ shɨna pəɨ nɛ, fǔoŋ ju ntuŋ vi ni ŋgùʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mbɨnɨ nuʼuŋ ntuʼu noŋ yi ŋkamuʼɔŋ nthɔ nāʼaŋ yaoŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ndɔ ndɨɨ ŋa pugu ni njaʼo nɛ, ŋgə̄ɨ ghao pa taʼa taʼa, jɛ̄ ŋkuoŋ pa mɛmmɛ ŋgwa. Jishɔ kɨna fɔ təʼɨ vi, ni miŋgwɛ ghɔ, a thi shhɨ yu. ");
INSERT INTO bmo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jishɔ lɔllɔ tɔthɨ, nchhu ghɔ ŋa, “Má, pugu hɨŋ? Ŋoŋ lɔ ŋgwɛ̄iŋ ghɔ nɔ ŋgushaʼa?” ");
INSERT INTO bmo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A chhu ŋa, “Kaŋ taʼa yi, ma Taathɔ!” Jishɔ chhu ghɔ ŋa, “Mummu ŋkaa mu shi lɔ ŋgwɛ̄iŋ ghɔ nɔ ŋgushaʼa, ghə̄ɨ, ndɔ jɛ̄ ndwɛ ŋgə̄ɨ nu shhɨ kiʼi nuʼuŋ nchwīe phɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jishɔ pɨnɨ nchrā ni pugu ŋkamuʼɔŋ, nchhu nu ŋa, “A mmu mbɔ líʼɛ ŋkuoŋ mbhi. Mbaʼa shesheŋoŋ ŋa a thɔ njiŋ a nɛ nuʼuŋ nyīeŋ moŋ njiŋ. A shi mfāʼo líʼɛ ŋa a ghà mfɛ chɔmbhi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nɛnnɛ pa ŋgwa Farashi chhu ghɔ ŋa, “Ɔ thɔ ŋkwe pi ntie noŋ yɔ. Chrà yɔ lɔ mbɔ nnu shini.” ");
INSERT INTO bmo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jishɔ khwɛ̄ ŋa, “Ŋga, njiʼi nthɛ pi nɔ haʼaŋ ŋ̀kwe ntie noŋ a nɛ, nnu ŋa ǹchrā nu nɛ nnu shini. Nthɛ ŋa ǹji lɨʼɨ ŋa ǹdhɔ nɛ pugu pa lɨʼɨ haʼaŋ ŋ̀gə̄ɨ nu nɛ. Ndɔ pəɨ lɔ nji lɨʼɨ haʼaŋ ǹdhɔ nɛ ki lɨʼɨ haʼaŋ ŋ̀gə̄ɨ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pəɨ shaʼa pi ni nthɨŋkwo ŋgwamishua. Ndɔ ǹdɔ njiʼi nshaʼa ŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ä njiʼi ndɔ mbɔ pi ŋa ǹshaʼa, kaŋ shaʼa nu ma yi ndɨndɨ, nthɛ ŋa ǹdɔ njiʼi nshaʼa pi təʼɨ a. Pigi Tǎa ŋa a taoŋ a nɛ pɔ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pi nāʼaŋ moŋ ŋwaʼaŋlɨ gɨ́ yəɨ ŋa p̈aa ŋgwa mbɔ miŋkwentie, kaŋ nnu ŋa pugu chhu nu nɛ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","A kwe mmu ŋkwe ntie noŋ a, Tǎa ŋa a taoŋ a nɛ kwe ntie a ŋkaa yu.” ");
INSERT INTO bmo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nthɛ yie, pugu chhu ghɔ ŋa, “Tǎa ghɔ ghɔ hɨŋ?” Jishɔ khwɛ̄ ni pugu ŋa, “Pəɨ lɔ njiʼi nji a ki Tǎa a, pəɨ kaŋ ni nji a, pəɨ kaŋ nji Tǎa a ŋkaa yu.” ");
INSERT INTO bmo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A ni nchrā nnu pei nɔ haʼaŋ a ni njɛʼi nu nɔ lɨʼɨ ŋa ŋkùŋ niʼiŋ mbɨŋ Nda Minnwi ni nthi nɛ, ndɔ paʼa ŋoŋ lɔ ŋgwɛ̄iŋ vi nthɛ ŋa ndɨɨ yi shini ndɔ naa ŋkāʼo yaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mbɨnɨ nchhu ni pugu ŋkamuʼɔŋ ŋa, “Ǹthɔ ŋgəɨghəɨ ni ŋwa, ndɔ pəɨ shi ntāʼa a, ndɔ ŋkhu moŋ phɨ yəɨ. Lɨʼɨ haʼaŋ ŋgə̄ɨ nu fɔ nɛ mbaʼa pəɨ thɔ fɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nnɛ pa thishɨ pa ŋgwa Juu pighɔ chhu ŋa, “A shi njwi noŋ yi nthɛ ŋa a chhu pi ŋa, ‘Lɨʼɨ ŋa ŋgə̄ɨ nu nɛ mbaʼa pəɨ thɔ fɔ nɛ?’ ” ");
INSERT INTO bmo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jishɔ chhu ni pugu ŋa, “Pəɨ llɔ pi ŋkuoŋ mbhi yei mbɛmbiɛŋ, ndɔ ǹdhɔ nyaŋ pi tɔthɨ. Pəɨ llɔ pi ŋkuoŋ mbhi hɛiŋ, ǹdɔ njiʼi ndhɔ pi ŋkuoŋ mbhi hɛiŋ, ");
INSERT INTO bmo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ŋki chhu ni pəɨ ŋa pəɨ shi ŋkhu moŋ phɨ yəɨ, nthɛ ŋa p̈əɨ mieŋ ki piŋ ŋa, ‘A Mmu mbɔ Ju,’ pəɨ khu moŋ phɨ yəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nnɛ pugu chhu ghɔ ŋa, “Ɔ pɔ pi gɔ̌?” Jishɔ chhu ni pugu ŋa, “Wuʼɔ yaoŋ ŋa mi ni nthɔ nchhu nu ni pəɨ nɔ njɛ̄ yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","M̀fāʼo ntou nnu nɔ chhu nu nthɛ vəɨ, pugu pa ntou nnu nɔ shaʼa nu vəɨ nɔ ghɔ, ndɔ Ju ŋa a taoŋ a nɛ ŋgaŋ nnu shini, ndɔ nnu ŋa ǹjaʼo mbhɔ yu nɛ, ǹchīi ni ŋkuoŋ mbhi.” ");
INSERT INTO bmo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Thɔ yugu shini ndɔ shie ŋa a ni nchrā nu ni pugu nthɛ pi Tǎa ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nnɛ Jishɔ chhu ni pugu ŋa, “Pəɨ shi ŋga ŋkwo ŋkə̄rə Muuŋ Ŋoŋmishua, pəɨ ji kiʼɛ ŋa ‘A Mmu mbɔ ju,’ pugu pa ŋa ǹshiʼa nchwīe sheshe nnu ni nyaŋ njɨ, ŋ̀guʼɔ chhu pi nnu yɛ ŋa Tǎa tɨgɨ a nɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ndɔ ju ŋa a taoŋ a nɛ pɔ pigi yu, a lɔ njiʼi mieŋ a təʼɨ a nthɛ ŋa ŋ̀ga ŋguʼɔ nchwīe pi pa yaoŋ ŋa a khwā nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nɔ haʼaŋ a ni nthɔ nchrā pa nnu pei nɛ, ntou ŋgwa piŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nnɛ Jishɔ chhu ni pa Juu pɛ ŋa pugu ni mbiŋ vi nɛ ŋa, “P̈əɨ ŋkɨna ŋkuoŋ chrà a kaŋ pəɨ ghaŋ younjiŋ paŋ shishini. ");
INSERT INTO bmo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ndɔ pəɨ shi nji nnu shini, nnu shini shi ŋkɨ̄gɛi ŋkɨɨ mbɨŋ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Pugu khwɛ̄ ghɔ ŋa, “Pigi pɔ pi puoŋ Abrahaŋ, paʼa ndɔ naa ma mfāʼa ŋkǔna mbhɔ ŋoŋ. Ti a kie pi nɛiŋ ɔ chhu ŋa, ‘Pi shi ŋkɨ̄gɛi ŋkɨɨ mbɨŋ pəɨ’?” ");
INSERT INTO bmo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jishɔ khwɛ̄ ni pugu ŋa, “Shishini, ǹshwei vəɨ, shesheŋoŋ ŋa a ghà nchwīe phɨ nɛ ŋkǔna phɨ. ");
INSERT INTO bmo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ŋkǔna shiʼa njiʼi ŋkɨna mbɔ ŋgia ndaaŋoŋ nɔ ŋguoŋ ndɨɨ ndɔ muuŋ pɔ pi nɔ ŋguoŋ ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nɛnnɛ ti m̈uuŋ ŋkɨ̄gɛi ŋkɨɨ mbɨŋ pəɨ, kaŋ pəɨ ya ntaoŋ moŋ ŋkɨɨ shishini. ");
INSERT INTO bmo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ǹja nji ŋa pəɨ puoŋ Abrahaŋ, ndɔ pəɨ tāʼa nu njwi a nthɛ ŋa pəɨ lɔ mbiŋ chrà a. ");
INSERT INTO bmo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ǹchrā nthɛ pi pa nnu ŋa Tǎa a nōoŋ vəɨ ndɔ pəɨ chwīe pi nnu ŋa tǎa vəɨ chhu ni pəɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Pugu khwɛ̄ ghɔ ŋa, “Abrahaŋ tǎa vigi!” Jishɔ chhu ni pugu ŋa, “P̈əɨ kaŋ mbɔ puoŋ Abrahaŋ, pəɨ kaŋ nthɔ nchwīe pi pa nnu haʼaŋ Abrahaŋ ni nchwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ndɔ ndwɛ pəɨ ka tāʼa nu njwi a jwi, mbɔ ŋoŋ ŋa a shwei vəɨ ni nnu shini ŋa a yaʼo llɔ mbhɔ Minnwi nɛ. Yei lɔ mbɔ nnu haʼaŋ Abrahaŋ ni nchwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pəɨ chwīe pi nnu ŋa tǎa vəɨ ni nchwīe nɛ.” Pugu chhu ghɔ ŋa, “Pi shini ndɔ mbhi vigi pi moŋ shúoŋ, Minnwi nduthɔ yi Tǎa vigi.” ");
INSERT INTO bmo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jishɔ chhu ni pugu ŋa, “M̈innwi kaŋ mbɔ Tǎa vəɨ, pəɨ kaŋ ŋkhwā a, nthɛ ŋa ǹdhɔ mbhɔ Minnwi ndɔ mbɔ hɛiŋ. Ǹdɔ njiʼi nthɔ pi ni nyaŋ thɔ, a taoŋ Ju ntaoŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","A chwīe khɔ paʼa thɔ yəɨ lɔ nshie ni nnu ŋa ǹchhu nɛ? A chwīe nthɛ ŋa minthɛ paʼa pəɨ lɔ njaʼo chrà a. ");
INSERT INTO bmo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Pəɨ pɔ pi puoŋ tǎa vəɨ mbɔ Shata, khwā njùʼɔ yəɨ pɔ nɔ chwīe nu nnu ŋa tǎa vəɨ tāʼa nu nɛ. A ni mbɔ njwi ŋoŋ llɔ nɔ njɛ̄ yi, paʼa ndɔ ma mbɔ ni pra pugu pa nnu shini nthɛ ŋa nnu shini lɔ mbɔ mbɨŋ yu. A ghà ŋga ndɛʼi ŋgiɛŋ, kaŋ a wuʼɔ nchwīe pi nùʼɔŋ yi nthɛ ŋa a ndɛʼiŋgiɛŋ ndɔ mbɔ tǎa pa lɛʼiŋgiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ndɔ nthɛ ŋa ǹchhu pi nnu shini nɛ, a chwīe yie paʼa pəɨ llɔ mbiŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Pinthɛ a nōoŋ gɔ̌ shɨna pəɨ shishini ŋa ǹchwīe phɨ? Ti m̈i nthɔ nchhu pi nnu shini, a pɔ khɔ paʼa pəɨ lɔ mbiŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ŋoŋ ŋa a yi Minnwi nɛ ghà njaʼo chrà Minnwi. Pəɨ lɔ njiʼi mbɔ yi Minnwi a chwīe yie ghɔ paʼa pəɨ lɔ njaʼo chrà Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pa thishɨ ŋgwa Juu pighɔ pie Jishɔ ŋa, “Pigi lɔ nchhu a kāʼo ndɨɨ ŋa pigi chhu ŋa ɔ ŋoŋ Shamaria mfāʼo miŋwɛiŋ mbɨŋ ghɔ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jishɔ khwɛ̄ ŋa, “Ǹdɔ njiʼi mfāʼo miŋwɛiŋ, ŋ̀gaʼo pi Tǎa a, ndɔ paʼa pəɨ lɔ ŋgaʼo a. ");
INSERT INTO bmo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ndɔ ǹdɔ njiʼi ntāʼa pi ndighaʼo ni noŋ a. A taʼa ŋoŋ ŋa a tāʼa ndighaʼo a nɛ, mbɔ ju mbɔ ŋgaŋ shaʼa sháʼa. ");
INSERT INTO bmo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Shishini, ǹchhu ni pəɨ ŋa, s̈hesheŋoŋ njaʼo chrà a nchwīe, paʼa a lɔ ma ŋkhu.” ");
INSERT INTO bmo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pa thishɨ ŋgwa Juu chhu ghɔ ŋa, “Ndwɛ pigi ya njəɨ ŋa ɔ fāʼo miŋwɛiŋ! Abrahaŋ ni ŋkhu, wuʼɔ nɔ haʼaŋ pichəɨ pa njəɨlɨʼɨ Minnwi ni ŋkhu nɛ, ndɔ ɔ chhu ŋa, ‘S̈hesheŋoŋ njaʼo chrà a nchwīe, paʼa a lɔ ma ŋkhu.’ ");
INSERT INTO bmo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ɔ pɔ pi ŋoŋ ndiɛŋ nchaa Abrahaŋ tǎa vigi ŋa a ni ŋkhu nɛ, Pa njəɨlɨʼɨ Minnwi khu ŋkaa pugu nɛ? Ɔ pīʼi ŋa ɔ pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jishɔ khwɛ̄ ŋa, “M̈i ŋgaʼo noŋ a, kaŋ ndighaʼo a pɔ pi gha. ‘A Tǎa a ŋa a ghaʼo a,’ mbɔ ju ŋa pəɨ chhu ŋa, ‘A Minnwi yigi’ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ndɔ pəɨ lɔ nji vi, ǹji vi. Ŋka ni nchhu ŋa ǹdɔ njiʼi nji vi, kaŋ mbɔ pi ndɛʼiŋgiɛŋ nɔ pəɨ. Ndɔ ǹji vi, ndɔ nchwīe nnu ŋa chrà yi chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tǎa vəɨ mbɔ Abrahaŋ ni mfāʼo pwanjuʼɔ ŋa a shi njəɨ ndɨɨ ŋa ǹshi nthɔ nɛ, a ni njəɨ mfāʼo pwanjuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pa Juu chhu ghɔ ŋa, “Ɔ lɔ naa nchəɨŋ tiɛŋ wuŋ ŋgaʼo nchhu ŋa ɔ yəɨ Abrahaŋ pi nɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jishɔ chhu ni pugu ŋa, “Shishini, ǹchhu ni pəɨ ŋa, ŋkaoŋ Abrahaŋ maa mbɔ, A Mmu!” ");
INSERT INTO bmo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nnɛ pugu lɔ̄gɔ pa ŋgùʼɔ nɔ tuŋ nu vi nɔ ghɔ. Jishɔ lɛ̄rɛ, ntaoŋ moŋ Nda Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nɔ haʼaŋ Jishɔ ni nyīeŋ ntɔgɔ nu nɛ, njəɨ ŋoŋ chəɨ ŋa a ni mbɔ nchriligi jɛ̄ ndɨɨ ŋa pi ni mbhi vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pa ghaŋ younjiŋ pi pie vi ŋa, “Masha, a chwīe gɔ̌ phɨ, ŋoŋ vei ki tǎa vi pugu mǔuŋ vi, ŋa a chwīe pi phi vi a taoŋ nchriligi?” ");
INSERT INTO bmo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jishɔ khwɛ̄ ŋa, “A shini ndɔ nchwīe phɨ ŋoŋ vei ki yi tǎa vi pugu mǔuŋ vi. A ni mbɔ nɛnnɛ pi ŋa fàʼa Minnwi nōoŋ mbɨŋ yu pi yəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pigi shi ŋguʼɔ mfāʼa fàʼa ŋoŋ yɛ ŋa a taoŋ a nɛ nɔ haʼaŋ minaoŋ wuʼɔ nthɛ nu nɛ. Tuʼu chhɔ nthɔ nu ŋa mbaʼa ŋoŋ nuʼuŋ mfāʼa fàʼa. ");
INSERT INTO bmo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nɔ haʼaŋ m̀bɔ ŋkuoŋ mbhi nɛ, a mmu mbɔ líʼɛ ŋkuoŋ mbhi.” ");
INSERT INTO bmo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","A ni ŋga kwo chhu nnu pei, nthu thwɛ shhɛ, ntrao titwrɛi ni thwɛ ghɔ. Njuʼɔ titwrɛi ghɔ nɔ ligi nchriligi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nchhu ghɔ ŋa a ghə̄ɨ moŋ ŋkhǐ ŋa pi mɛ̄iŋ ni Shiloaŋ nɛ. (Njiŋ Shiloaŋ pɔ ŋa taoŋ.) Nɛnnɛ a ghə̄ɨ nshɨ̄gao, mbɨnɨ, nthɔ njəɨ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pa taakuo pugu pa ŋgwa pɛ ŋa pugu ni ŋkwo yəɨ vi nɔ ŋgaŋ luoŋ nɛ chhu nu ŋa, “Yei lɔ mbɔ ŋoŋ yɛ ŋa a ni nthɔ nchɔchhɔ nduoŋ nu nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pichəɨ ŋa, “A ju,” pichəɨ chhu ŋa, “Ŋga, ndɔ a fhi vi.” Ndɔ ŋoŋ ghɔ wuʼɔ nthɔ nchhu nu ŋa, “A mmu mbɔ ju.” ");
INSERT INTO bmo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nnɛ pugu chhu ghɔ ŋa, “Ti ligi yɔ kie pi nɛiŋ nchuʼɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A khwɛ̄ ŋa, “Ŋoŋ yɛ ŋa pi mɛ̄iŋ vi ŋa Jishɔ nɛ trao titwrɛi njuʼɔ ligi a nɔ ghɔ nchhu vəɨ ŋa, ‘Ghə̄ɨ moŋ ŋkhǐ Shiloaŋ nshɨ̄gao ligi yɔ fɔ.’ Nɛnnɛ ŋ̀gə̄ɨ nshɨ̄gao ligi a, njəɨ lɨʼɨ kiʼɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pugu chhu ghɔ ŋa, “A hɨŋ?” A khwɛ̄ ŋa, “Ǹdɔ njiʼi nji.” ");
INSERT INTO bmo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ŋgwa pighɔ lɔ̄gɔ ŋoŋ ghɔ ŋa a ni mfǔoŋ mbɔ nchriligi nɛ, ŋgə̄ɨ nɔ shhɨ pa ŋgwa Farashi. ");
INSERT INTO bmo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Llɛ́ ŋa Jishɔ ni nchwīe titwrɛi nchuʼɔ ligi ŋoŋ ghɔ nɔ nɛ ni mbɔ llɛ́ ji. ");
INSERT INTO bmo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nnɛ pa ŋgwa Farashi pɨnɨ mbie vi ŋkwaŋ haʼaŋ a kie ŋkaoŋ maa njəɨ lɨʼɨ nɛ. A chhu ni pugu ŋa, “A yuʼɔ titwrɛi nɔ ligi a, nshɨ̄gao, ǹjəɨ lɨʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pichəɨ pa ŋgwa Farashi chhu ŋa, “Ŋoŋ vei lɔ njiʼi ndhɔ pi mbhɔ Minnwi nthɛ ŋa a shiʼa nūʼɔŋ Llɛ́ Ji.” Ndɔ pichəɨ chhu ŋa, “Pinthɛ ŋoŋ mbɨmbhɨ kie pi nɛiŋ nōoŋ ŋkwaŋ lì pei?” Minduoŋnduoŋ gū shɨna pugu. ");
INSERT INTO bmo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nnɛ pugu pɨnɨ mbie ŋoŋ ghɔ ŋa, “Ɔ chhu ŋa a chuʼɔ ligi yɔ. Ti ɔ khwɛ̄ jɔ ŋa nthɛ vi?” Ŋoŋ ghɔ khwɛ̄ ŋa, “A njəɨlɨʼɨ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pa Juu shini ndɔ mbiŋ ŋa ŋoŋ ghɔ ni mbɔ nchriligi ŋkaoŋ maa mbɨnɨ njəɨ lɨʼɨ. Mɛ̄iŋ tǎa vi pugu mǔuŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mbie vugu ŋa, “Yei muuŋ vəɨ ŋa pəɨ chhu ŋa pi ni mbhi vi a pɔ pi nchriligi nɛ? Ti a kie pi nɛiŋ ndwɛ ma njəɨlɨʼɨ?” ");
INSERT INTO bmo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tǎa vi pugu mǔuŋ vi khwɛ̄ ŋa, “Pigi ji ŋa yei muuŋ vigi, pugu pa ŋa pi ni mbhi vi a taoŋ nchriligi. ");
INSERT INTO bmo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ndɔ ti ŋkwaŋ haʼaŋ a kie ŋkaoŋ maa njəɨ lɨʼɨ ndwɛ nɛ pigi lɔ njiʼi nji, ki nji ŋoŋ ŋa a chuʼɔ ligi yi nɛ. Pie vi a ntɨnɨmmɛ. A shi nchrā ni noŋ yi.” ");
INSERT INTO bmo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pa tǎa pi ni nchhu nnu pei nthɛ ŋa pugu ni nthɔ mbɔgɔ pa thishɨ pa Juu. Nthɛ ŋa pugu ni ŋkwo taoŋ ni taʼa nchò ŋa shesheŋoŋ mbiŋ ŋa Jishɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, pi fuʼu vi nda luoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nthɛ yie ghɔ, tǎa vi pugu mǔuŋ chhu ŋa, “A ŋoŋ ntɨnɨmmɛ, pəɨ pie vi.” ");
INSERT INTO bmo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nɔ mbra ŋgɛ́ pugu pɨnɨ mɛ̄iŋ ŋoŋ ghɔ ŋa a ni mbɔ nchriligi nɛ nchhu ghɔ ŋa, “Chhu nnu mbɔgɔ ligi Minnwi. Pigi ji ŋa ŋoŋ vei nchwīe phɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A khwɛ̄ ŋa, “Ki a pɔ pi nchwīe phɨ ǹshi lɔ nji! Taʼa nu ŋa ǹji nɛ pɔ ŋa mi ni mbɔ nchriligi, ndɔ ndwɛ ǹthɔ njəɨ lɨʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pugu chhu ghɔ ŋa, “A ni nchwīe pi nɛiŋ mbɨŋ ghɔ? A ni nchuʼɔ ligi yɔ pi nɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A khwɛ̄ ni pugu ŋa, “Ŋ̀kwo shwei vəɨ paʼa pəɨ lɔ ntāʼa nu njaʼo. Pəɨ tāʼa nu mbɨnɨ njaʼo nthɛ pi khɔ? Pəɨ ŋkaa pəɨ tāʼa nu ŋgū pa ghaŋ younjiŋ pi?” ");
INSERT INTO bmo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pugu wɛʼi vi, nchhu ŋa, “Ɔ ŋgaŋ younjiŋ ŋoŋ yinɛ, ndɔ pigi pɔ pi pa ghaŋ younjiŋ Mushi. ");
INSERT INTO bmo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Pigi ji ŋa Minnwi ni nchrā ni Mushi. Ndɔ ni ŋoŋ vei pigi lɔ nji lɨʼɨ ŋa a llɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ŋoŋ ghɔ khwɛ̄ ŋa, “Nthɛ khɔ, yei nnu ghraoghrao! Pəɨ lɔ njiʼi nji lɨʼɨ haʼaŋ a llɔ nɛ, ndɔ a chuʼɔ ligi a. ");
INSERT INTO bmo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pia ji ŋa Minnwi shiʼa njiʼi njaʼo pa ghaŋ nchwīe phɨ ndɔ s̈hesheŋoŋ mbɔ ŋgaŋ ghaʼo Minnwi, nchwīe nnu ŋa Minnwi ghɔ tāʼa nu nɛ, a yaʼo vi. ");
INSERT INTO bmo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fie nɔ haʼaŋ mbhi ni njɛ̄ nɛ pi lɔ naa njaʼo ŋa yichəɨ ŋoŋ chuʼɔ ligi ŋoŋ ŋa pi phi vi a pɔ nchriligi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ŋoŋ vei kaŋ mieŋ ki llɔ pi mbhɔ Minnwi, nthɛ paʼa a lɔ nchwīe sheshe yaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pugu khwɛ̄ ghɔ ŋa, “Ɔ ya mbɔ pi ŋgaŋ phɨ llɔ ndɨɨ ŋa pi ni mbhi ghɔ nɛ, ɔ tāʼa nu njɛʼi vigi?” Pugu wɛ̄iŋ vi mfuʼu māʼaŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jishɔ yaʼo ŋa pi wɛ̄iŋ vi māʼaŋ mbhi, ŋga njəɨ vi, nchhu ghɔ ŋa, “Ɔ piŋ Muuŋ Ŋoŋmishua?” ");
INSERT INTO bmo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A khwɛ̄ ŋa, “Masha, Muuŋ Ŋoŋmishua pɔ pi gɔ̌, nnɛ ŋa minthɛ m̀biŋ vi?” ");
INSERT INTO bmo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jishɔ chhu ghɔ ŋa, “Ɔ kwo yəɨ vi, a ju ŋa a chrà nu vɛ nɛ!” ");
INSERT INTO bmo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ŋoŋ ghɔ chhu ŋa, “Taathɔ, m̀biŋ!” Ndɔ ŋgaʼo vi. ");
INSERT INTO bmo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jishɔ chhu ŋa, “Mi ni nthɔ moŋ mbhi yei pi nɔ shaʼa nu, ŋa ŋgwa pɛ ŋa pugu pa nchriligi nɛ nthɛ pugu yəɨ lɨʼɨ, ŋgwa pɛ ŋa minthɛ pugu yəɨ lɨʼɨ nɛ gū nchriligi.” ");
INSERT INTO bmo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pichəɨ pa ŋgwa Farashi ŋa pugu ni mbara yəɨ yu, njaʼo nnu pei nɛ chhu ghɔ ŋa, “Pigi pa nchriligi ŋkaa pigi?” ");
INSERT INTO bmo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jishɔ chhu ni pugu ŋa, “Pəɨ kaŋ ni mbɔ pa nchriligi paʼa pəɨ lɔ mbɔ pa ŋgushaʼa ndɔ ndwɛ ŋa pəɨ chhu ŋa, ‘Pigi yəɨ lɨʼɨ nɛ,’ pəɨ kɨna mbɔ pa ŋgushaʼa.” ");
INSERT INTO bmo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jishɔ chhu ŋa, “Shishini, ǹchhu ni pəɨ ŋa, ŋoŋ ŋa a nii moŋ ŋkaʼa minjɨɨ ki lɔ ntɔgɔ pi choŋkaʼa nɛ, ŋkuʼɔ ntɔgɔ pi lɨʼɨ nduoŋ nii nɛ, ŋoŋ ghɔ ŋgɨna, mbɨnɨ mbɔ ŋgɨna minwi. ");
INSERT INTO bmo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ndɔ ti ŋoŋ ŋa a nii pi choŋkaʼa nɛ, a ŋkɛ̄ʼi minjɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ŋgaŋ lɨna ni choŋkaʼa ghà chuʼɔ choŋkaʼa ghɔ. Pa minjɨɨ ghà njaʼo ŋggì yi, a gɛ̄ pa phí minjɨɨ ni ligi yugu, ŋkɛ̄ʼi vugu ntaoŋ nɔ ghɔ mbhi. ");
INSERT INTO bmo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ŋga ntaoŋ ni ŋguoŋ ji minjɨɨ mbhi ŋgə̄ɨ nu shhɨ pugu, pa minjɨɨ pighɔ younjiŋ yi nthɛ ŋa pugu ji ŋggì yi. ");
INSERT INTO bmo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ti a mbɔ ŋgɨ̀nɨ, paʼa pugu lɔ njōu njiŋ yi, pugu tei vi tei nthɛ ŋa pugu lɔ njiʼi nji ŋggì pa ghɨ̀nɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jishɔ ni nchrā luʼɔ chrà yei ni pugu, ndɔ paʼa thɔ yugu lɔ nshie ni nnu ŋa a chhu nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nnɛ Jishɔ pɨnɨ nchhu ni pugu ŋa, “Shishini, a mmu mbɔ choŋkaʼa pa minjɨɨ. ");
INSERT INTO bmo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ŋguoŋ pa ŋgwa ŋa pugu ni nthɔ shhɨ a nɛ pɔ pi pa ŋgɨna pugu pa ŋgɨna minwi, ndɔ paʼa pa minjɨɨ lɔ njaʼo vugu. ");
INSERT INTO bmo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","A mmu mbɔ chonda. S̈hesheŋoŋ ntɔgɔ mbɨŋ mu nii a lūgu, ndɔ nii mbɨnɨ ntaoŋ nu mfāʼo ŋkiɛŋ trǔ ŋkru. ");
INSERT INTO bmo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ŋgɨna ghà nthɔ pi nɔ yōo nu, njwi ndɔ mbɨrɨ. Mi ni nthɔ nnɛ ŋa minthɛ pugu fāʼo chɔmbhi. Ndɔ nja mfāʼo chɔmbhi lɔlɨnaoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“A mmu mbɔ ŋkiɛŋ ŋkɛ̄ʼi minjɨɨ shiʼi. Ŋkiɛŋ ŋkɛ̄ʼi minjɨɨ shiʼi ghà mfɛ chɔmbhi yi nthɛ minjɨɨ pi. ");
INSERT INTO bmo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ŋoŋ yɛ ŋa pi pe vi pe ki a lɔ mbɔ ŋkɛ̄ʼi minjɨɨ ki minjɨɨ ghɔ lɔ mbɔ pi ji nɛ gha njəɨ miŋaŋieŋ a thɔ nu, a mieŋ pa minjɨɨ ntei ni vhi, miŋaŋieŋ ghɔ wɛ̄iŋ vugu ndɔ nshāaŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A tei nthɛ ŋa a fāʼa pi pe, paʼa ndɔ njiʼi mfāʼo ndɨɨ ni pa minjɨɨ. ");
INSERT INTO bmo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“A mmu mbɔ ŋkiɛŋ ŋkɛ̄ʼi minjɨɨ shiʼi, ǹji pa minjɨɨ paŋ pugu ji a, ");
INSERT INTO bmo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","wuʼɔ nɔ haʼaŋ Tǎa ji a ŋkaa yu mummu ji Tǎa nɛ. M̀fɛ chɔmbhi a nthɛ pa minjɨɨ. ");
INSERT INTO bmo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","M̀fāʼo pichəɨ pa minjɨɨ ŋa pugu lɔ mbɔ moŋ yei ŋkaʼa. Ǹshi ŋguʼɔ nthɔ ni pugu ŋkaa pugu, pugu yaʼo ŋggì a. Nnɛ pugu chīri mbɔ taʼa kwíe, mfāʼo taʼa ŋkɛ̄ʼi vugu. ");
INSERT INTO bmo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yei nnu ŋa a chwīe Tǎa a khwā a nɛ, ŋa m̀fɛ chɔmbhi a nɔ khu nu, nnɛ ŋa mimfɛ m̀bɨnɨ nɔ ghɔ ŋkamuʼɔŋ. ");
INSERT INTO bmo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","A lɔ njiʼi ŋkwe yichəɨ ŋoŋ ŋkwe chɔmbhi a mbhɔ mu. M̀fɛ pi khwatua a, m̀fāʼo ghrɨ́ nɔ fɛ nu ndɔ mbɨnɨ mfāʼo ghrɨ́ nɔ pɨ̄nɨ nu nuʼuŋ ŋkwe. A nnu ŋa Tǎa fɛ gɨ́ ŋa ǹchwīe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Minduoŋnduoŋ ni ŋgū shɨna pa Juu nthɛ pa chrà pei. ");
INSERT INTO bmo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ntou yugu chhu ŋa, “A fāʼo miŋwɛiŋ, ndɔ mbaa paa, pəɨ ywɛrɛ pi khɔ mbhɔ yu?” ");
INSERT INTO bmo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pichəɨ chhu yugu ŋa, “Yei lɔ mbɔ ŋkwaŋ chrà ŋoŋ ŋa miŋwɛiŋ thɔ fɛ ŋgəʼɨ ghɔ nɛ. Mimfɛ miŋwɛiŋ chuʼɔ ligi pa nchriligi?” ");
INSERT INTO bmo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Moŋ ndɨɨ ghɔ, jɨ fɛ nu Nda Minnwi ni Minnwi ni ndɔ̄gɔ lɨʼɨ Jerushalɛiŋ. A ni mbɔ moŋ ndɨɨ laoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jishɔ ni nthɔ nyīeŋ nu moŋ Varinda Sholomu moŋ Nda Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nnɛ pa Juu kɨrɨ yəɨ yu mbie vi ŋa, “Ɔ shi ntigi vigi moŋ mititri pi fɨʼɨ yi nɛiŋ, ɔ̈ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, ɔ shwei vigi thɔ yigi shie.” ");
INSERT INTO bmo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jishɔ khwɛ̄ ni pugu ŋa, “Mi ni ŋkwo shwei vəɨ ndɔ paʼa pəɨ lɔ mbiŋ. Pa fàʼa ŋa m̀fāʼa nu ni ligi Tǎa nɛ kwe ntie a ni yaoŋ ŋa mi yie nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ndɔ paʼa pəɨ lɔ mbiŋ nthɛ ŋa pəɨ shi lɔ mbɔ ghrà minjɨɨ paŋ. ");
INSERT INTO bmo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Pa minjɨɨ paŋ ghà njaʼo ŋggì a, ǹji vugu, pugu younjiŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","M̀fɛ chɔmbhi ki mmɛ ni pugu, mbaʼa pugu lɛ ma ŋkhu. Ndɔ mbaʼa kaŋ taʼa ŋoŋ fīʼa vugu mfuʼu liɛŋ mbhɔ mu. ");
INSERT INTO bmo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tǎa a ŋa a fɛ vugu vəɨ nɛ, chaa vugu ghao, ti minthɛ paʼa shesheŋoŋ llɔ mfīʼa vugu mfuʼu liɛŋ mbhɔ Tǎa ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mmu pigi Tǎa a pɔ pi taʼa yi.” ");
INSERT INTO bmo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pa ŋgwa Juu lɨ̄ga pa ŋgùʼɔ shhɛ ŋkamuʼɔŋ lɨʼɨ tuŋ vi nɔ. ");
INSERT INTO bmo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jishɔ khwɛ̄ ni pugu ŋa, “Ŋ̀kwo nōoŋ ntou fàʼa shiʼi ni pəɨ llɔ mbhɔ Tǎa, ti pəɨ tāʼa nu ntuŋ a nthɛ pi yəɨ shɨna fàʼa pei?” ");
INSERT INTO bmo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Pa Juu pighɔ khwɛ̄ ghɔ ŋa, “Pigi lɔ njiʼi ntāʼa nu ntuŋ ghɔ nthɛ pi fàʼa shiʼi, pigi tāʼa nu ntuŋ ghɔ nthɛ pi nchɨʼəshə. Nthɛ ŋa ɔ wuʼɔ mbɔ pi ŋoŋmishua ntāʼa nu ndɔ̄gɔ noŋ yɔ mbɔ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jishɔ khwɛ̄ ni pugu ŋa, “Pi lɔ nāʼaŋ moŋ ŋwaʼaŋlɨ gɨ́ yəɨ ŋa, Minnwi chhu ŋa, ‘Pəɨ pa nnwi!’ ");
INSERT INTO bmo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ti a mɛ̄iŋ vugu ŋa chrà Minnwi ni nthɔ mbhɔ pugu nɛ ni pa nnwi, ndɔ pia ji ŋa mbaʼa pi pəʼɨ chrà ‘minnwi’, ");
INSERT INTO bmo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","pəɨ kie nɛiŋ nchhu ni ju yɛ ŋa Tǎa chuʼɔ vi nɔ thɔ fàʼa ntaoŋ vi moŋ mbhi nɛ ŋa, ‘Ɔ fāʼo nchɨʼəshə’ nthɛ ŋa mi ni nchhu ŋa, ‘Mi Muuŋ Minnwi’ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ä mbɔ ŋa ǹdɔ njiʼi nchwīe pi fàʼa Tǎa a, kiʼi pəɨ piŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ndɔ m̈i nchwīe pi fàʼa yi, njiʼi nthɛ pi nɔ haʼaŋ pəɨ lɔ njiʼi mbiŋ a nɛ, pəɨ piŋ nɛ fàʼa pighɔ, nnɛ ŋa pəɨ shi nji, thɔ yəɨ lɔ nshie ŋa Tǎa pɔ mbɨŋ mu, m̀bɔ mbɨŋ Tǎa.” ");
INSERT INTO bmo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pugu pɨnɨ nuʼuŋ ntāʼa nu ŋgwɛ̄iŋ vi ŋkamuʼɔŋ a lərə ntaoŋ mbhɔ pugu. ");
INSERT INTO bmo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jishɔ pɨnɨ mbɨnɨ njiɛŋ ŋkhǐ Jodaŋ, lɨʼɨ ŋa Jouŋ ni mfǔoŋ nthɔ ŋkwe ŋgwa ni ŋkhǐ nɛ, ŋkɨna fɔ. ");
INSERT INTO bmo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ntou ŋgwa thɔ njəɨ vi nchhu ŋa, “Jouŋ shini ndɔ nōoŋ sheshe lì, ndɔ ŋguoŋ nnu ŋa Jouŋ ni nchhu nthɛ ŋoŋ vei nɛ nnu shini.” ");
INSERT INTO bmo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ntou ŋgwa piŋ vi fɔ. ");
INSERT INTO bmo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ŋoŋ chəɨ ni ŋgɨ̄nɔ nu ligi yi pɔ Lasharɔ llɔ Betani, mbɔ laʼataoŋ Meri pugu ndǐŋ vi Mata. ");
INSERT INTO bmo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meri vei ni mbɔ ŋoŋ yɛ ŋa a ni nshāʼo wru laminda mbɨŋ Taathɔ, njɨ̄gɨ kwò yi ni ŋgiithɔ yi nɛ, ŋa ndǐŋ vi Lasharɔ ni ŋgɨ̄nɔ nu. ");
INSERT INTO bmo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Piŋgɛ pighɔ ŋa pugu ni mbɔ pa lǐŋ nɛ taoŋ ŋkɨ̀nɨ ni Jishɔ ŋa, “Taathɔ, ŋkiɛŋ taannu yɔ ŋa ɔ khwā vi ŋgaʼa nɛ ghɨ̄nɔ nu.” ");
INSERT INTO bmo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ndɔ Jishɔ ni ŋga njaʼo, nchhu ŋa, “Ghɨ̌nɔ ghɔ lɔ mbɔ yi gu. A pɔ pi nɔ fɛ nu ndighaʼo ni Minnwi nnɛ ŋa Muuŋ Minnwi tɔgɔ ŋkuoŋ ghɔ mfāʼo ndighaʼo.” ");
INSERT INTO bmo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jishɔ ni ŋkhwā Mata pugu Meri ndǐŋ vi, ni Lasharɔ. ");
INSERT INTO bmo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nnɛ, ni ŋga njaʼo ŋa Lasharɔ ghɨ̄nɔ nu, mbɨnɨ ndaʼa paa llɛ́ mbīgi lɨʼɨ ŋa a ki pɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nnɛ, nchhu ni pa ghaŋ younjiŋ pi ŋa, “Pia pɨnɨ ŋgə̄ɨ Judia.” ");
INSERT INTO bmo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pa ghaŋ younjiŋ pi chhu ghɔ ŋa, “Masha, a lɔ njiʼi shɨga nɔ haʼaŋ ŋgwa Juu ni ntāʼa nu ntuŋ ghɔ ni ŋgùʼɔ nɛ, ɔ kwo pɨnɨ ŋgə̄ɨ nu fɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jishɔ khwɛ̄ ŋa, “A lɔ mbɔ paanchrɔ awa ŋa pi ghà mfāʼo líʼɛ? S̈hesheŋoŋ nyīeŋ moŋ liʼɛ paʼa a lɔ njiʼi ŋkɔ̄rɔ, nthɛ ŋa a thɔ njəɨ liʼɛ ŋkuoŋ mbhi yei. ");
INSERT INTO bmo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ndɔ ti s̈hesheŋoŋ nyīeŋ pi ni tuʼu, a kɔ̄rɔ nthɛ ŋa a lɔ njiʼi mfāʼo liʼɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jishɔ ni ŋga nchhu nnu pei mīʼɛŋ, nchhu ni pugu ŋa, “Lasharɔ taannu via gū lɔ̄gɔ, ǹshi ŋgə̄ɨ ŋgūʼu vi.” ");
INSERT INTO bmo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pa ghaŋ younjiŋ pi chhu ghɔ ŋa, “Taathɔ, A ŋgū moŋ lɔ̄gɔ, kaŋ noŋ yi shi ntɔgɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jishɔ ni ŋga nchhu nnɛ, njiŋ yi pɔ pi ŋa a kukhu, pugu pīʼi yugu ŋa a pɔ pi wuʼɔ lɔgɔ gha nɔ fɛrɛ nu. ");
INSERT INTO bmo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nnɛ, Jishɔ shiethɔ yugu ŋa, “Lasharɔ kwo khu! ");
INSERT INTO bmo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ndɔ, nthɛ vəɨ, m̀fāʼo pwanjuʼɔ ŋa ǹshini ndɔ mbɔ fɔ, nnɛ ŋa pəɨ shi mbiŋ. Ndɔ pia ghə̄ɨ njəɨ vi.” ");
INSERT INTO bmo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nnɛ, Toma ŋa pi ni mɛ̄iŋ vi ni kəʼɨ nɛ chhu ni pɛ ghaŋ younjiŋ ŋa pugu pugu ni njōu njiŋ Jishɔ kaʼa nɛ ŋa, “Pia ghə̄ɨ ŋkaa pia, nnɛ ŋa minthɛ pia pa Masha khu kaʼa.” ");
INSERT INTO bmo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jishɔ ni ŋga nchəɨŋ, njəɨ ŋa Lasharɔ kwo pɔ moŋ fúŋ nɔ khwɛ llɛmbhi. ");
INSERT INTO bmo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A shini ndɔ njiʼi nchəɨŋ khwɛ ŋkaŋ kwò nɔ llɔ nu Betani ŋgə̄ɨ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ntou pa ŋgwa Juu ni ŋgə̄ɨ lɨʼɨ kra Mata pugu Meri nɔ māʼaŋ nu njùʼɔ yugu nthɛ gu ndǐŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nnɛ Mata gha njaʼo ŋa Jishɔ thɔ nu, ntaoŋ ŋgə̄ɨ njəɨ vi, ndɔ Meri kɨna nchɔchhɔ nda. ");
INSERT INTO bmo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata chhu ni Jishɔ ŋa, “Taathɔ, ɔ kaŋ ni mbɔ hɛiŋ, ndǐŋ vigi shi kaŋ ndɔ ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ndɔ njiʼi nthɛ pi ndwɛ, ǹji ŋa sheshe yaoŋ ŋa ɔ shi mbie mbhɔ Minnwi nɛ, Minnwi shi mfɛ vɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jishɔ chhu ghɔ ŋa, “Ndǐŋ ghɔ shi mbɨnɨ ndɔllɔ mfāʼo chɔmbhi.” ");
INSERT INTO bmo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata chhu ghɔ ŋa, “Nji ŋa a shi mbɨnɨ ndɔllɔ moŋ ndɨɨ ŋa ŋgwa lɛ ŋkuʼɔ moŋ ndugwi llɛ́ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jishɔ chhu ghɔ ŋa, “A mmu mbɔ ŋgaŋ kuʼɔ moŋ gu ndɔ mbɔ chɔmbhi. Shesheŋoŋ ŋa a piŋ a nɛ, njiʼi nthɛ pi nɔ haʼaŋ a shi ŋkhu nɛ, a shi mfāʼo chɔmbhi. ");
INSERT INTO bmo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ndɔ ti shesheŋoŋ ŋa a yi maoŋ ndɔ mbiŋ a nɛ, mbaʼa a yiʼi ma ŋkhu. Ɔ piŋ nnu yei?” ");
INSERT INTO bmo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata ghɔ chhu ghɔ ŋa, “Ooŋ, ma Taathɔ, m̀biŋ ŋa ɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, mbɔ Muuŋ Minnwi ŋa a ni mfāʼo nɔ thɔ nu moŋ mbhi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","A ni ŋga nchhu nnu yei, ŋgə̄ɨ mɛ̄iŋ Meri ndǐŋ vi, nchhu ghɔ njiŋnjiŋ ŋa, “Masha pɔ hɛiŋ nthɔ mɛ̄iŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","A gha njaʼo, njiʼa ndɔ pi llɔ ŋgə̄ɨ njəɨ vi. ");
INSERT INTO bmo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jishɔ shini ndɔ naa nchəɨŋ moŋ laʼa yaʼa. A ni ŋguʼɔ mbiʼi lɨʼɨ haʼaŋ Mata ni mbara vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndɨɨ ŋa pa Juu pɛ ŋa pugu pugu ni mbɔ nda pugu nthɔ māʼaŋ njùʼɔ yi yəɨ Meri lɔllɔ ni njɨ ntaoŋ mbhi nɛ, pugu younjiŋ yi, mbīʼi yugu ŋa a tāʼa ŋgə̄ɨ chofuŋ ŋkə̄ɨ fɔ. ");
INSERT INTO bmo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri ni ŋga nthɔ nɔ lɨʼɨ ŋa Jishɔ ni mbɔ nɛ njəɨ vi, ŋgū ni puŋ yi shhɨ yu, nchhu nu ŋa, “Taathɔ, ɔ̈ kaŋ ni ŋkwo pɔ hɛiŋ, ndǐŋ a shi kaŋ ndɔ ŋkhu!” ");
INSERT INTO bmo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jishɔ ni ŋga njəɨ a kə̄ɨ nu, mbɨnɨ njəɨ pa Juu ŋa pugu pugu ni mbɔ nɛ kə̄ɨ nu ŋkaa pugu, nnu ghɔ pɨgɨ vi, njùʼɔ yi ghana vi ntou yi. ");
INSERT INTO bmo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A pie ŋa, “Fúŋ ŋa pəɨ nūʼɔŋ vi fɔ nɛ pɔ pi hɨŋ?” Pugu chhu ghɔ ŋa, “Taathɔ, thɔ ŋgə̄ɨ njəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jishɔ ni ŋkə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nnɛ pa ŋgwa Juu chhu ŋa, “Pəɨ līi fɨʼɨ ŋkwaŋ haʼaŋ a khwā vi njəɨ!” ");
INSERT INTO bmo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ndɔ pichəɨ chhu yugu ŋa, “A kaŋ ni mfɛ paʼa Ju ŋa a ni nchuʼɔ ligi pa nchriligi nɛ lɔ nchwīe ki a lɔ njiʼi ŋkhu?” ");
INSERT INTO bmo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nɛnnɛ, nnu ghɔ pɨnɨ mbɨgɨ Jishɔ, a ghə̄ɨ chofuŋ ghɔ. A ni mbɔ llù, pi nūʼɔŋ ŋgùʼɔ cho ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jishɔ chhu ŋa, “Pəɨ pɨʼɨ ŋgùʼɔ ghɔ.” Mata, ndǐŋ ŋkuŋkhu ghɔ, chhu ŋa, “Taathɔ, yɨ́ga yi shi ŋgaʼa a kwo pɔ khwɛ llɛ́ nɔ haʼaŋ pi twei vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jishɔ chhu ghɔ ŋa, “Ǹshi nì ndɔ nchhu vɛ ŋa ɔ̈ mbiŋ, kaŋ ɔ shi njəɨ ndighaʼo Minnwi?” ");
INSERT INTO bmo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nnɛ, pugu pɨʼɨ ŋgùʼɔ ghɔ. Jishɔ kə̄rə ligi yi tɔthɨ nchhu ŋa, “Tǎa, ǹtōo ghɔ ŋa ɔ yaʼo a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ǹji ŋa ɔ ghà ŋguʼɔ njaʼo a, ndɔ ǹchhu yei nthɛ pi ŋgwa pei ŋa pugu thi hɛiŋ nɛ, nnɛ ŋa pinthɛ pugu piŋ ŋa a taoŋ gɔ̀ ntaoŋ a.” ");
INSERT INTO bmo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","A ni ŋga nchhu pei nnu, mbaʼo ŋgòu ni njɨ ŋa, “Lasharɔ, taoŋ mbhi hɛiŋ!” ");
INSERT INTO bmo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ŋoŋ ghɔ ŋa a ni ŋkwo khu taoŋ mbhi, pa mbhɔ mi ni kwò mi pɔ yi liŋ ni ndhwí fhu, ligi yi wuʼɔ mbɔ yi liŋ ni ndhwí. Jishɔ chhu ni pugu ŋa, “Pəɨ fēi vi mieŋ vi a ghə̄ɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nthɛ yie ghɔ, ntou pa Juu ŋa pugu ni nthɔ lɨʼɨ kra Meri, njəɨ nnu ŋa Jishɔ chwīe nɛ, piŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ndɔ pichəɨ ghə̄ɨ njəɨ pa ŋgwa Farashi nshwei vugu ni nnu ŋa Jishɔ chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nnɛ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋgwa Farashi kɨrɨ pa kúŋ nchhu ŋa, “Pia shi nchwīe pi nɛiŋ? Nthɛ ŋa ŋoŋ vei thɔ nōoŋ ntou pa lì! ");
INSERT INTO bmo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","P̈ia mieŋ vi a ghə̄ɨ nu shhɨ nɛnnɛ, ŋguoŋ ŋgwa piŋ vi, pa ŋgwa Roma thɔ nshāʼa Nda Minnwi yia pugu pa laʼataoŋ yia.” ");
INSERT INTO bmo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ndɔ taʼa ŋoŋ vugu, ligi yi pɔ Kaifa, mbɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ŋgaʼo ghɔ, chhu ni pugu ŋa, “Pəɨ lɔ nji kaŋ taʼa nnu. ");
INSERT INTO bmo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Pəɨ lɔ nji ŋa, a pwa ni pəɨ ŋa taʼa ŋoŋ khu nthɛ ŋguoŋ ŋgwa nchaa ŋa ŋguoŋ laʼataoŋ shiʼi.” ");
INSERT INTO bmo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A shini ndɔ nchhu yei nnu pi ni thɔ yi, ndɔ nɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ŋgaʼo ghɔ, a ni nchhu nɔ njəɨlɨʼɨ Minnwi ŋa Jishɔ shi ŋkhu nɔ thɔ pa ŋgwa laʼataoŋ pa Juu, ");
INSERT INTO bmo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ki lɔ ŋguʼɔ mbɔ pi ŋgwa laʼataoŋ pa Juu təʼɨ vugu, mbɔ nɔ kɨrɨ nu ŋguoŋ pa puoŋ Minnwi ŋa pugu sha moŋ ghaa mbhi nɛ pugu pɔ taʼa yi. ");
INSERT INTO bmo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nnɛ, jɛ̄ yua ghɔ, pa thishɨ pa ŋgwa Juu pīri ŋkwaŋ nɔ haʼaŋ pugu shi njwi Jishɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nthɛ yie ghɔ, paʼa Jishɔ lɔ nuʼuŋ nyīeŋ lɨʼɨ wo shɨna pa Juu. A lɔllɔ fɔ ŋgə̄ɨ moŋ krao laʼataoŋ yɛ ŋa a para moŋ ŋkǔnu njó nɛ, moŋ laʼataoŋ Ɛfrɛiŋ ndaʼa fɔ pugu pa ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ndɨɨ jɨ Jɨ Lli Njiʼa pa Juu ni ŋkwo para nu, ntou ŋgwa kuʼɔ llɔ moŋ laʼa ŋgə̄ɨ Jerushalɛiŋ nɔ chwīe nu noŋ yugu mbɔ yi taoŋtaoŋ nɔ haʼaŋ nùʼɔŋ chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pugu ni nchhɔ ntāʼa Jishɔ, nchhu nu ni noŋ pugu nɔ haʼaŋ pugu ni nthi Nda Minnwi nɛ ŋa, “Pəɨ pīʼi ŋa? Pəɨ pīʼi ŋa mbaʼa a yiʼi ndɔ nthɔ lɨʼɨ jɨ ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋgwa Farashi ni ŋkwo fɛ gɨ́ ŋa s̈hesheŋoŋ nji lɨʼɨ ŋa a pɔ nɛ, a chwīe pugu ji nnɛ ŋa minthɛ pugu wɛ̄iŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A ni ŋga mbiʼi ntɨgao llɛ́ ŋkaoŋ llɛ́ jɨ Lli Njiʼa maa ŋkāʼo, Jishɔ thɔ Betani, mbɔ lɨʼɨ ŋa Lasharɔ mbɔ ŋoŋ ŋa Jishɔ ni mbɨʼɨ vi moŋ gu ni mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pugu pīri jɨ fɔ nɔ ligi Jishɔ. Mata ghɛ̄rɛ ŋgrā maoŋ pighɔ. Lasharɔ ni mbɔ taʼa ŋoŋ ŋa pugu pa Jishɔ ni nchhɔ ŋkuoŋ taprɛi lɨʼɨ jɨ maoŋ pighɔ kaʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Meri lɔ̄gɔ nchɨ́ŋ laminda tɨnɨnchuoŋ ŋa pi chwīe ni yichəɨ ŋkwaŋ yaoŋ ŋa pi mɛ̄iŋ ni nadi, mbɔrɔ kwo Jishɔ nɔ ghɔ njɨ̄gɨ ni ŋgiithɔ yi. Mooŋ nda ghɔ lɨnaoŋ ni mbwa luŋ laminda ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ndɔ Judashi Ishikario, taʼa ŋgaŋ younjiŋ yi, mbɔ yɛ ŋa a ni mbɔ nɔ fīni nu vi nɛ chhu ŋa, ");
INSERT INTO bmo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“A ni mbɔ khɔ paʼa pi lɔ mfīni laminda yinɛ mfɛ mbɨŋ ghɔ ni ghaŋ pou? Pi kaŋ ni nthɛ pi fīni ni fɨʼɨ mbɨŋ ŋa ŋoŋ mfāʼa nɔ trɛi ŋkɨɨ llɛmbhi pi pe vi nɔ ghɔ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A ni nchhu yei paʼa ndɔ mbɔ pi ŋa a ni ŋkhwā lɨna nu ni ghaŋ pou. A ni nchhu nthɛ pi ŋa a ni mbɔ ŋgɨna, ni nthɔ ntuo ju ntuo pìɛŋ mbɨŋ. Ni nthɔ ŋiʼaŋ mfuʼu pichəɨ moŋ ghɔ ŋgɛ̄rɛ noŋ yi nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jishɔ chhu ŋa, “Mieŋ vi təʼɨ vi, nji ŋa mimfɛ a nūʼɔŋ laminda ghɔ nɔ llɛmbhi ŋa pi shi ntwei a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ä mbɔ pi ni pa ghaŋ pou, pəɨ pugu shi ŋguʼɔ mbɔ kaʼa, ndɔ mbaʼa pəɨ wuʼɔ fāʼo a ŋguoŋ ndɨɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ndɨɨ ŋa mmɛ yú pa ŋgwa Juu ni njaʼo ŋa Jishɔ pɔ fɔ nɛ, pugu thɔ paʼa ndɔ ŋguʼɔ nthɛ pi ju, pugu thɔ nɔ yəɨ nu Lasharɔ, ŋa Jishɔ ni mbɨʼɨ vi moŋ gu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nnɛ pa thishɨ ghaŋ fɛʼiŋgiɛŋ taaŋ nɔ jwi nu Lasharɔ ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nthɛ ŋa a ni mbɔ nthɛ pi Lasharɔ ŋa ntou pa Juu ni ndāa vugu ndɔ ŋgə̄ɨ nu nthɔ mbiŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mbhi ni ŋga ndaŋ, mmɛ yú ŋgwa pɛ ŋa pugu ni mbɔ lɨʼɨ jɨ ghɔ nɛ yaʼo ŋa Jishɔ thɔ nu Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nnɛ pugu lɔ̄gɔ pa ghia taŋ ntaoŋ ŋgə̄ɨ mbara vi nɔ ghɔ, mbaʼo ŋgòu ni njɨ ŋa, “Ndighaʼo pɔ ni Minnwi! Minnwi fɛ mbɔrɔ ni ju ŋa a thɔ nɔ ligi Taathɔ nɛ! Minnwi fɛ mbɔrɔ ni fùoŋ pa ŋgwa Ishrae!” ");
INSERT INTO bmo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jishɔ yəɨ muuŋ ŋkwɛ́iŋ chəɨ ŋkuʼɔ nchɔchhɔ ŋkuoŋ, wuʼɔ nɔ haʼaŋ pi nāʼaŋ ŋa, ");
INSERT INTO bmo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kiʼi fāʼo pɔgɔ gu, ma laʼataoŋ Shayaoŋ. Fùoŋ yɔ pɔ nɛiŋ ŋkuʼɔ muuŋ ŋkwɛ́iŋ nthɔ nu.” ");
INSERT INTO bmo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Thɔ ghaŋ younjiŋ pi shini ndɔ mfǔoŋ nshie nɔ nnu pei, ndɔ a gha mbɔ ndɨɨ ŋa Jishɔ nii moŋ ndighaʼo yi nɛ, pugu kwiŋ ŋa Ŋwaʼaŋlɨ Minnwi ni nchhu nnu pei nthɛ pi ju ndɔ pi kwo chwīe mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yú ŋgwa pɛ ŋa pugu pugu ni mbɔ ndɨɨ ŋa a ni mɛ̄iŋ Lasharɔ a taoŋ moŋ fúŋ a ywiŋ vi moŋ gu nɛ wuʼɔ ŋgə̄ɨ shhɨ nthɔ mbɔ pa miŋkwentie pi. ");
INSERT INTO bmo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","A ni nchwīe lì yei ŋa a ni nōoŋ nɛ, yú ŋgwa pighɔ ghə̄ɨ mbara vi. ");
INSERT INTO bmo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nnɛ pa ŋgwa Farashi chhu ni noŋ pugu ŋa, “Pəɨ yəɨ ŋa pəɨ lɔ nthɔ nshei yichəɨ yaoŋ. Pəɨ pɛʼi njəɨ, ŋguoŋ mbhi ghə̄ɨ njiŋ yu.” ");
INSERT INTO bmo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pichəɨ pa ŋgwa Gri ni mbɔ shɨna ŋgwa pɛ ŋa pugu ni ŋgə̄ɨ Jerushalɛiŋ nɔ ghaʼo nu Minnwi lɨʼɨ jɨ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pichəɨ ŋgwa pighɔ thɔ mbara Fili ŋa a ni ndhɔ Beshaida moŋ Galili nɛ, mbie vi ŋa, “Masha, pigi tāʼa nu njəɨ Jishɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fili ghə̄ɨ nchhu ni Andru, Andru ghɔ pugu Fili ghə̄ɨ nchhu ni Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jishɔ khwɛ̄ ni pugu ŋa, “Ndɨɨ kāʼo ni Muuŋ Ŋoŋmishua nɔ fāʼo nu mmɛ ndighaʼo. ");
INSERT INTO bmo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Shishini, ǹchhu ni pəɨ, m̈bia shíe gɛ mieŋ ki gū shhɛ ŋkhu, a kɨna taʼa yi, ndɔ ti ä ŋkhu, a khɛ̄ ŋkuʼɔ njuŋ ntou ntíɛŋ. ");
INSERT INTO bmo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ŋgwa pɛ ŋa pugu khwā chɔmbhi yugu nɛ shi nshiɛŋ chɔmbhi yugu ghɔ, ndɔ ti ŋgwa pɛ ŋa pugu pɨ̄na chɔmbhi yugu moŋ mbhi yei nɛ, shi nūʼɔŋ chɔmbhi yugu ghɔ mfāʼo chɔmbhi ki ndugwi yi. ");
INSERT INTO bmo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","S̈hesheŋoŋ mfāʼa mbhɔ mu, a yiʼi ŋa a yōu njiŋ a, nnɛ ŋa lɨʼɨ ŋa m̀bɔ nɛ, muuŋ fàʼa a shi mbɔ fɔ ŋkaa yu. S̈hesheŋoŋ mfāʼa mbhɔ mu, kaŋ Tǎa a shi ŋgaʼo vi. ");
INSERT INTO bmo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ndwɛ njùʼɔ a ghana a. Ti mi shi nchhu pi ŋa? Tǎa, kwe a moŋ pɨɨ ndɨɨ yei? Ndɔ ǹthɔ ŋkuoŋ mbhi yei nthɛ pi tɔgɔ nu moŋ ŋgəʼɨ yei. ");
INSERT INTO bmo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tǎa ghaʼo ligi yɔ.” Ŋggì taoŋ po ŋa, “Ŋ̀kwo ghaʼo, ndɔ shi mbɨnɨ ŋgaʼo ŋkamuʼɔŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Yú ŋgwa pɛ ŋa pugu ni nthi fɔ njaʼo ŋggì ghɔ nɛ chhu ŋa mbɨ̀ wara. Pichəɨ chhu ŋa, “Ŋgaŋ ntaoŋ Minnwi chrā ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jishɔ khwɛ̄ ŋa, “Ŋggì yei thɔ nthɛ pi pəɨ, a lɔ njiʼi mbɔ nthɛ pi mmu. ");
INSERT INTO bmo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ndwɛ ndɨɨ ŋa pi shi nshaʼa ŋkuoŋ mbhi yei nɛ. Ndwɛ pi shi mbɨʼɨ ŋoŋ ŋa a shaʼa ŋkuoŋ mbhi yei ŋkuoŋ faaŋ. ");
INSERT INTO bmo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ndɔ ni mmu, pi shi ŋga ŋkə̄rə a tɔthɨ llɔ ŋkuoŋ shhɛ, ǹshūu ŋguoŋ ŋgwa nthɔ nɔ ghɔ mbɨŋ mu.” ");
INSERT INTO bmo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A ni nchhu yei pi nɔ nōoŋ nu ŋkwaŋ gu ŋa a shi ŋkhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nnɛ yú ŋgwa pighɔ khwɛ̄ ghɔ ŋa, “Pigi yaʼo moŋ ŋwaʼaŋlɨ gɨ́ ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ ma ŋkɨna mbhi ki ndugwi yi. Ti ɔ kie pi nɛiŋ nchhu ŋa pi shi ŋkə̄rə Muuŋ Ŋoŋmishua ŋkwiŋ vi ŋkuoŋ wáʼa? Yie Muuŋ Ŋoŋmishua pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jishɔ chhu ni pugu ŋa, “Líʼɛ shi mbɔ shɨna pəɨ wuʼɔ nɔ kuo ndɨɨ mbīgi. P̂əɨ nyīeŋ ndɨɨ ŋa líʼɛ pɔ nɛ nnɛ ŋa kiʼi njiŋnjiŋ ghaʼa vəɨ. Nthɛ ŋa ŋoŋ ŋa a nyīeŋ moŋ njiŋ nɛ lɔ njiʼi njəɨ lɨʼɨ ŋa a ghə̄ɨ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nɔ haʼaŋ pəɨ fāʼo liʼɛ nɛ, pəɨ piŋ liʼɛ ghɔ, nji ŋa pəɨ shi mbɔ pa ŋgwa líʼɛ.” Jishɔ ni ŋga nchrā pei nnu ti mīʼɛŋ, ndɔllɔ ŋgə̄ɨ ndɛrɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Njiʼi nthɛ nɔ haʼaŋ Jishɔ ni nōoŋ ntou pa lì shɨna pa Juu pighɔ nɛ, pugu shini ndɔ mbiŋ vi. ");
INSERT INTO bmo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yei ni mbɔ nɔ chwīe nu yaoŋ ŋa njəɨlɨʼɨ Minnwi mbɔ Ishaya ni nāʼaŋ nɛ lɔ̄gɔ lɨʼɨ ŋa, “Taathɔ, a piŋ gɔ̌ mbiŋ chrà yigi, ndɔ ti Taathɔ nōoŋ ghrɨ́ yi pi ni gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nthɛ yie ghɔ, pugu kaŋ ni nthɛ paʼa pugu lɔ mbiŋ, nthɛ ŋa Ishaya pɨnɨ nchhu ŋa, ");
INSERT INTO bmo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Minnwi chri ligi yugu, mfɨ̄nɨ njùʼɔ yugu, nnɛ ŋa kiʼi pugu yəɨ lɨʼɨ ni ligi yugu, nji ni njùʼɔ yugu ŋkara, ǹchwīe pugu pɔ shiʼi.” ");
INSERT INTO bmo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya ni nchhu pa nnu pei nthɛ ŋa a ni njəɨ ndighaʼo Jishɔ, nchrā pa nnu nthɛ vi. ");
INSERT INTO bmo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Njiʼi nthɛ nɛnnɛ, ntou pa thishɨ ni mbiŋ vi ndɔ paʼa ndɔ nchwīe pi ji nthɛ ŋa pugu ni mbɔgɔ nu ŋa pa ŋgwa Farashi shi fuʼu vugu nda luoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nthɛ ŋa pugu khwā ndighaʼo ŋa a llɔ mbhɔ ŋgwamishua nchaa yɛ ŋa a llɔ mbhɔ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jishɔ chhu ni njɨ ŋa, “Shesheŋoŋ ŋa a piŋ nɛ lɔ ŋguʼɔ mbiŋ pi mmu. A piŋ pi ŋoŋ ŋa a taoŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Shesheŋoŋ ŋa a yəɨ a nɛ yəɨ ŋoŋ ŋa a taoŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ǹthɔ moŋ mbhi nɔ líʼɛ, nnɛ ŋa mbaʼa shesheŋoŋ ŋa a piŋ a nɛ kɨna moŋ njiŋnjiŋ. ");
INSERT INTO bmo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","S̈hesheŋoŋ njaʼo chrà a, ndɔ ki lɔ chwīe, paʼa ǹdɔ nshaʼa vi, nthɛ ŋa ǹshini ndɔ njiʼi nthɔ pi nɔ shaʼa nu ŋgwa ŋkuoŋ mbhi. Ŋki thɔ pi nɔ kwe nu vugu. ");
INSERT INTO bmo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ŋoŋ yɛ ŋa a lāa a ki lɔ njiʼi mbiŋ chrà a nɛ fāʼo yaoŋ ŋa a shi nshaʼa vi. Chrà ŋa ǹchrā nɛ shi nshaʼa vi moŋ ndugwi llɛ́. ");
INSERT INTO bmo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nthɛ ŋa ǹdɔ njiʼi nchrā pi ni nyaŋ njɨ. Ndɔ ti Tǎa ŋa a taoŋ a nɛ fɛ gɨ́ vəɨ ni nnu ŋa ǹshi nchrā ndɔ nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ǹji ŋa gɨ́ yi pɔ pi chɔmbhi ki mmɛ, nnɛ yaoŋ ŋa ǹchhu nɛ, a yaoŋ ŋa Tǎa chhu vəɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ŋkaoŋ llɛ́ jɨ Lli Njiʼa maa ŋkāʼo, Jishɔ ni ŋkwo ji ŋa ndɨɨ yi kāʼo nɔ llɔ nu ŋkwo shhɛ hɛiŋ ŋgə̄ɨ mbara Tǎa. A ni ŋkhwā pa ghaŋ younjiŋ pi ŋkuoŋ mbhi hɛiŋ ndɔ ŋkhwā vugu ti ŋgə̄ɨ nchəɨŋ nɔ ndugwi yi. ");
INSERT INTO bmo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","A ni ŋga mbɔ ndɨɨ jɨ maoŋ, devɨ kwo kāoŋ njùʼɔ Judashi Ishikario muuŋ Shemu, ŋa a fīni Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jishɔ gha nji ŋa Tǎa kwo fɛ ŋguoŋ ghrɨ́ ghɔ ndɔ mbɨnɨ nji ŋa ju nduthɔ yi llɔ pi mbhɔ Minnwi ŋguʼɔ mbɨnɨ pi mbhɔ Minnwi ghɔ, ");
INSERT INTO bmo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ndɔllɔ tɔthɨ moŋ lɨʼɨ jɨ maoŋ nshrāo mmɛ ndhwí yi nūʼɔŋ, ndɔ̄gɔ tawrɛi ndǐŋ laʼo ntuʼu yu ");
INSERT INTO bmo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","nshāʼo ŋkhǐ moŋ pɛiŋ shɨ̄gao yaoŋ njɛ̄ shɨ̄gao nu kwò ghaŋ younjiŋ pi njɛ̄ yɨ̄gɨ nu ni tawrɛi ŋa a ni ndǐŋ láʼo ntuʼu yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A ni ŋga nchəɨŋ mbɨŋ Shemu Pita, a chhu ŋa, “Taathɔ, ɔ tāʼa nu nshɨ̄gao kwò ma?” ");
INSERT INTO bmo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jishɔ khwɛ̄ ghɔ ŋa, “Thɔ yɔ lɔ naa nchuʼɔ ŋkuoŋ nnu ŋa ǹchwīe nu nɛ yaʼa, ndɔ a shi ŋga ndaʼa, thɔ yɔ chuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita chhu ghɔ ŋa, “Mbaʼa ɔ ma nshɨ̄gao kwò ma!” Jishɔ khwɛ̄ ghɔ ŋa, “M̈i mieŋ ki shɨ̄gao ghɔ, paʼa pɔgɔ lɔ nuʼuŋ mbɔ ni pra.” ");
INSERT INTO bmo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Shemu Pita chhu ghɔ ŋa, “Taathɔ, kiʼi ŋguʼɔ nshɨ̄gao pi kwò ma, shɨ̄gao pa mbhɔ ma pugu pa thɔ a!” ");
INSERT INTO bmo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jishɔ chhu ghɔ ŋa, “Ŋoŋ ŋa a kwo shɨ̄gao noŋ nɛ lɔ mbie ŋa a pɨnɨ nuʼuŋ nshɨ̄gao noŋ ŋkiɛŋ kwò mi nthɛ ŋa a kwo pɔ yi taoŋtaoŋ. Ndɔ pəɨ pi taoŋtaoŋ, ndɔ paʼa ndɔ mbɔ pi ŋguoŋ yəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nthɛ ŋa a ni nji ŋoŋ ŋa a shi mfīni vi nɛ, a ni nchwīe yie a chhu ŋa, “A lɔ mbɔ ŋguoŋ yəɨ mbɔ yi taoŋtaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","A ni ŋga ŋkwo shɨ̄gao kwò yugu ti mbɨnɨ māʼaŋ mmɛ ndhwí yi, nchɔchhɔ nɔ lɨʼɨ yi, nchhu ni pugu ŋa, “Thɔ yəɨ chuʼɔ ni nnu ŋa nchwīe ni pəɨ nɛ? ");
INSERT INTO bmo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pəɨ ghà mɛ̄iŋ a ni ‘Masha’ pugu ‘Taathɔ,’ ndɔ nchhu shini nthɛ ŋa mi yie. ");
INSERT INTO bmo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ndɔ ti ä mbɔ mmu Taathɔ vəɨ mbɨnɨ mbɔ masha vəɨ nshɨ̄gao kwò yəɨ, pəɨ ŋkaa pəɨ wuʼɔ mfāʼo nɔ shɨ̄gao nu kwò noŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ŋ̀kwo nōoŋ lì ni pəɨ, ŋa pəɨ ŋkaa pəɨ chwīe wuʼɔ nɔ haʼaŋ ǹchwīe ni pəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Shishini, ǹshwei vəɨ, muuŋ fàʼa lɔ ŋgāʼo nchaa masha vi, ndɔ paʼa ŋoŋ ŋa pi taoŋ vi nɛ lɔ ŋgāʼo nchaa ŋoŋ ŋa a taoŋ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ŋa pəɨ ji nnu pei nɛ, mbɔrɔ shi mbɔ yəɨ nɔ haʼaŋ p̈əɨ nchwīe. ");
INSERT INTO bmo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ǹdɔ nchrā nthɛ pi ŋguoŋ yəɨ ghao, ǹji ŋgwa pɛ ŋa ǹchuʼɔ vugu nɛ. Ndɔ nnu ŋa Ŋwaʼaŋlɨ Minnwi chhu nɛ shi ndɔ̄gɔ lɨʼɨ ŋa, ‘Ŋoŋ ŋa pigi yu jɨ maoŋ kaʼa nɛ kara māʼaŋ a ni nchhɔ̀.’ ");
INSERT INTO bmo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ǹthɔ nchhu yei nnu ni pəɨ ndwɛ ŋkaoŋ a maa ndɔ̄gɔ lɨʼɨ, nji ŋa a shi ŋga ndɔ̄gɔ lɨʼɨ, pəɨ piŋ ŋa A mmu mbɔ Ju. ");
INSERT INTO bmo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Shishini, ǹshwei vəɨ, shesheŋoŋ ŋa a piŋ ŋoŋ ŋa ǹtaoŋ nɛ piŋ a, shesheŋoŋ ŋa a piŋ a nɛ piŋ ŋoŋ ŋa a taoŋ a nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jishɔ ni ŋga ŋkwo chhu nnu yei ti mīʼɛŋ, njùʼɔ yi ghana vi ntou yi, a chhu ŋa, “Shishini, ǹchhu ni pəɨ ŋa taʼa ŋoŋ vəɨ shi mfīni a!” ");
INSERT INTO bmo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pa ghaŋ younjiŋ pi līi noŋ pugu, ŋgrāo nu ŋa a nthɛ a chhu pi gɔ̌. ");
INSERT INTO bmo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yichəɨ taʼa ŋgaŋ younjiŋ yi ŋa Jishɔ ni ŋkhwā vi nɛ ni nchhɔ ŋkuoŋ taprɛi yəɨ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nnɛ Shemu Pita nōoŋ ghɔ ni mbhɔ ŋa a pie Jishɔ ŋa a chhu nthɛ pi gɔ̌. ");
INSERT INTO bmo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nnɛ, yie taʼa ŋgaŋ younjiŋ yi yɨʼə noŋ yi minjiŋnjiŋ mbɨŋ Jishɔ nchhu ghɔ ŋa, “Taathɔ, yie pɔ pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jishɔ khwɛ̄ ŋa, “A yɛ ŋoŋ ŋa ǹshi mfɛ brɛi ŋa ǹchrū moŋ kumbu nɛ ghɔ.” A gha nchru brɛi ghɔ, mfɛ ni Judashi, mbɔ muuŋ Shemu Ishikario. ");
INSERT INTO bmo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judashi ni ŋga ŋkwe brɛi ghɔ, Shata nii mbɨŋ yu. Jishɔ chhu ŋa, “Nnu ŋa ɔ tāʼa nu nchwīe nɛ, yiʼa kɔkɔnɔ nchwīe.” ");
INSERT INTO bmo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kaŋ taʼa ŋoŋ ŋa pugu pugu ni nchhɔ ŋkuoŋ taprɛi nɛ shini ndɔ nji nnu ŋa a ni nchwīe a chhu ghɔ nnɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pichəɨ ni mbīʼi ŋa, nthɛ ŋa Judashi ni ntuo pìɛŋ mbɨŋ nɛ, Jishɔ ni nchhu nu ghɔ pi ŋa, “Yuoŋ pa maoŋ ŋa a pie ŋa pia fāʼo nɔ nnu jɨ ghɔ nɛ”, ki ŋa a fɛ yaoŋ ni ghaŋ pou. ");
INSERT INTO bmo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nnɛ, Judashi gha ŋkwo kru brɛi ghɔ, ŋkiʼi ntaoŋtaoŋ mbhi. Tuʼu ni ŋkwo shini. ");
INSERT INTO bmo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judashi ni ŋga ŋkwo taoŋ, Jishɔ chhu ŋa, “Ndɨɨ kāʼo ni Muuŋ Ŋoŋmishua nɔ nii nu moŋ ndighaʼo yi, Minnwi fāʼo ndighaʼo nthɛ vi. ");
INSERT INTO bmo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ndɔ M̈innwi mfāʼo ndighaʼo yi nthɛ muuŋ, kaŋ Minnwi nduthɔ yi shi ŋgaʼo muuŋ ŋkaa yu moŋ nduthɔ ju Minnwi. Ndɔ a shi ŋgaʼo vi wuʼɔ ndwɛ. ");
INSERT INTO bmo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Pa puoŋ mi puoŋ paŋ, a wuʼɔ mbɔ pi nɔ muuŋ kuo ndɨɨ ŋa pia shi mbɔ kaʼa. Pəɨ shi ntāʼa a ndɔ nɔ haʼaŋ mi ni nchhu ni thishɨ pa Juu nɛ, a haʼaŋ m̀bɨnɨ nchhu nu ni pəɨ ndwɛ, ŋa, ‘Lɨʼɨ haʼaŋ ŋ̀gə̄ɨ nu fɔ nɛ mbaʼa pəɨ thɔ fɔ.’ ");
INSERT INTO bmo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","M̀fɛ kɨ̀na fhi ni pəɨ ŋa pəɨ khwā noŋ pəɨ. P̂əɨ khwā noŋ pəɨ wuʼɔ nɔ haʼaŋ ŋ̀khwā vəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ŋguoŋ ŋgwa shi nji ŋa pəɨ ghaŋ younjiŋ paŋ nɔ haʼaŋ p̈əɨ mfāʼo khwǎ noŋ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Shemu Pita chhu ghɔ ŋa, “Taathɔ, ɔ ghə̄ɨ pi hɨŋ?” Jishɔ khwɛ̄ ghɔ ŋa, “Lɨʼɨ ŋa ŋ̀gə̄ɨ nu nɛ minthɛ paʼa ɔ lɔ njōu njiŋ a nthɔ fɔ ndwɛ, ndɔ ɔ shi njōu njiŋ a nthɔ fɔ ndɨɨ nduoŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita khwɛ̄ ŋa, “Taathɔ, minthɛ paʼa ǹdɔ njōu njiŋ yɔ pɔgɔ ghə̄ɨ fɔ kaʼa nthɛ khɔ? Ǹshi ŋkhu nthɛ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jishɔ khwɛ̄ ghɔ ŋa, “Ɔ shi ŋkhu nthɛ a nyaŋ? Shishini, ǹshwei ghɔ, mbaʼa miŋkəʼɨ yiʼi ŋkhwɛ̄ shiʼa ki ɔ lɔ naa ndāa a ni trɛi ŋgɛ!” ");
INSERT INTO bmo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Kiʼi njùʼɔ yəɨ ghana vəɨ, p̂əɨ piŋ Minnwi, mbɨnɨ mbɨŋ a ŋkaa mu. ");
INSERT INTO bmo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ntou njiɛŋ nda pɔ moŋ nda Tǎa a. A kaŋ mieŋ ki pɔ nnɛ, ŋkaŋ ŋkwo shwei vəɨ, nthɛ ŋa ŋ̀gə̄ɨ lɨʼɨ pīri lɨʼɨ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ǹshi ŋga ŋkwo pīri lɨʼɨ ni pəɨ nɛ, ǹthɔ ndɔ̄gɔ vəɨ pia ghə̄ɨ, nnɛ ŋa lɨʼɨ ŋa m̀bɔ nɛ, pia shi ŋguʼɔ mbɔ fɔ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Pəɨ ji shɛndaoŋ lɨʼɨ ŋa ŋ̀gə̄ɨ nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma chhu ghɔ ŋa, “Taathɔ, pigi lɔ njiʼi nji lɨʼɨ ŋa ɔ ghə̄ɨ nu nɛ. Ti minthɛ pigi kie pi nɛiŋ nji shɛndaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jishɔ chhu ghɔ ŋa, “A mmu mbɔ shɛndaoŋ, mbɔ nnu shini mbɔ chɔmbhi. Yichəɨ ŋoŋ nthɛ paʼa a lɔ ŋgə̄ɨ njəɨ Tǎa ki lɔ ntɔgɔ pi mbhɔ mu. ");
INSERT INTO bmo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","P̈əɨ ŋkwo ji a, kaŋ pəɨ shi ŋkwo ji Tǎa a ŋkaa yu. Llɔ ndwɛ ŋgə̄ɨ nu shhɨ, pəɨ ji vi ndɔ njəɨ vi.” ");
INSERT INTO bmo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fili chhu ghɔ ŋa, “Taathɔ, nōoŋ Tǎa ghɔ ni pigi, a ŋguoŋ nnu ŋa pigi tāʼa nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jishɔ chhu ghɔ ŋa, “Pia kwo pɔ nɔ fɨʼɨ ntaaŋ ndɨɨ yei, pəɨ wuʼɔ mbiʼi ki lɔ nji a, Fili? Ŋoŋ ŋa a kwo yəɨ a nɛ kwo yəɨ Tǎa. Ti minthɛ ɔ kie pi nɛiŋ nchhu ŋa, ‘Nōoŋ Tǎa ghɔ ni pigi?’ ");
INSERT INTO bmo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɔ lɔ mbiŋ ŋa m̀bɔ moŋ Tǎa, Tǎa pɔ moŋ noŋ mu? Pa chrà ŋa ǹchrā nu nɛ, ǹdɔ njiʼi nchrā pi ni thɔ a, ndɔ Tǎa ŋa a chhɔ moŋ noŋ mu nɛ thɔ nchwīe fàʼa yi. ");
INSERT INTO bmo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Piŋ a nɔ haʼaŋ ǹchhu nu ŋa m̀bɔ moŋ Tǎa, Tǎa pɔ moŋ noŋ mu nɛ, ndāa nɛ nnɛ, ɔ piŋ nthɛ fàʼa pɛ ŋa m̀fāʼa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Shishini, ǹshwei vəɨ, shesheŋoŋ ŋa a piŋ a nɛ shi mfāʼa fàʼa ŋa m̀fāʼa nu nɛ, ndɔ ǹshi mfāʼa fàʼa ŋa a chaa yie ghɔ nɛ, nthɛ ŋa ŋ̀gə̄ɨ nu njəɨ pi Tǎa. ");
INSERT INTO bmo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sheshe yaoŋ ŋa ɔ shi mbie pi nɔ ligi a nɛ, ǹshi nchwīe nnɛ ŋa Tǎa fāʼo ndighaʼo yi ntɔgɔ pi mbhɔ muuŋ. ");
INSERT INTO bmo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","P̈əɨ mbie a ni sheshe yaoŋ nɔ ligi a, kaŋ ǹshi nchwīe. ");
INSERT INTO bmo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“P̈əɨ ŋkhwā a, kaŋ pəɨ shi nūʼɔŋ pa kɨ̀na paŋ. ");
INSERT INTO bmo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nnɛ kaŋ ǹshi mbie Tǎa a, a fɛ yichəɨ ŋgaŋ ghɛ̀rɛ ni pəɨ, pəɨ pugu chhɔ ki ndugwi yi, ");
INSERT INTO bmo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","mbɔ Jijwɛ nnu shini ŋa mbaʼa ŋgwa ŋkuoŋ mbhi piŋ vi, nthɛ ŋa pugu shi lɔ njəɨ ki nji vi, ndɔ pəɨ ji vi nthɛ ŋa pəɨ pugu chhɔ kaʼa ndɔ shi mbɔ moŋ chɔmbhi yəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","M̀baʼa njiʼi mieŋ vəɨ nɔ puoŋ minthi, ǹshi mbɨnɨ nthɔ njəɨ vəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ndɔ nɔ muuŋ kuo ndɨɨ, mbaʼa ŋgwa ŋkuoŋ mbhi yei nuʼuŋ njəɨ a, ndɔ pəɨ shi njəɨ a. Nthɛ ŋa mi yi maoŋ nɛ, pəɨ ŋkaa pəɨ shi mbɔ yi maoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A shi ŋga mbɔ llɛ́ ghɔ, pəɨ ji ŋa m̀bɔ moŋ Tǎa, pəɨ pɔ mbɨŋ mu, mummu pɔ mbɨŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ŋoŋ yɛ ŋa a piŋ pa kɨ̀na paŋ ndɔ nūʼɔŋ nɛ, a ju mbɔ ŋoŋ ŋa a khwā a nɛ. Ndɔ ti ju ŋa a khwā a nɛ, Tǎa a shi ŋkhwā vi ŋkaa yu, mummu khwā vi nōoŋ noŋ a ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judashi (ki lɔ mbɔ pi Judashi Ishikario) chhu ghɔ ŋa, “Taathɔ, a pɔ pi nɛiŋ ŋa ɔ shi nōoŋ noŋ yɔ ni pigi, ki lɔ nōoŋ ni ŋgwa ŋkuoŋ mbhi?” ");
INSERT INTO bmo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jishɔ khwɛ̄ ghɔ ŋa, “S̈hesheŋoŋ ŋkhwā a, kaŋ a shi njaʼo nchò a, Tǎa a khwā vi, pigi thɔ njəɨ vi, nchhɔ pigi pugu. ");
INSERT INTO bmo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Shesheŋoŋ ŋa a lɔ njiʼi ŋkhwā a nɛ shiʼa nūʼɔŋ chrà a. Ndɔ chrà ŋa pəɨ yaʼo ǹchrā nu nɛ lɔ mbɔ pi nyaŋ. A yi Tǎa ŋa a taoŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ŋ̀ki nchrā nnu pei ni pəɨ ndɨɨ ŋa pia wuʼɔ mbɔ kaʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ndɔ ŋgaŋ ghɛ̀rɛ, mbɔ Jijwɛ Minnwi, ŋa Tǎa shi ntaoŋ nɔ ligi a nɛ, shi njɛʼi vəɨ ni ŋguoŋ yaoŋ ghao ndɔ mbɨnɨ nuʼuŋ ŋkwiŋ vəɨ ni ŋguoŋ yaoŋ ŋa ǹchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","M̀ieŋ ghɨghrɨ ni pəɨ; m̀fɛ ghɨghrɨ a ni pəɨ. Ǹdɔ njiʼi mfɛ ni pəɨ pi ŋkwaŋ haʼaŋ ŋkuoŋ mbhi fɛ nɛ. Kiʼi njùʼɔ yəɨ ghana vəɨ, ndɔ kiʼi pəɨ fāʼo pɔgɔ gu. ");
INSERT INTO bmo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Pəɨ ni njaʼo a nɔ haʼaŋ ŋki chhu ni pəɨ ŋa ǹthɔ ŋgə̄ɨ ghə̄ɨ ndɔ mbɨnɨ nthɔ njəɨ vəɨ nɛ. P̈əɨ kaŋ ni nja nthɔ ŋkhwā a, p̂əɨ fāʼo pwanjuʼɔ nthɛ ŋa ŋ̀gə̄ɨ njəɨ pi Tǎa, nthɛ ŋa Tǎa lɔ mbɨnɨ ŋgāʼo nchaa a. ");
INSERT INTO bmo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ndɔ ndwɛ ŋ̀kwo shwei vəɨ ŋkaoŋ a maa ndɔ̄gɔ lɨʼɨ, nnɛ ŋa ndɨɨ ŋa a lɔ̄gɔ lɨʼɨ nɛ, a nthɛ pəɨ piŋ. ");
INSERT INTO bmo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","M̀baʼa nuʼuŋ nchrā ntou yi pia, nthɛ ŋa ŋgaŋ shaʼa ŋkuoŋ mbhi yei thɔ nu. A lɔ njiʼi mfāʼo ghrɨ́ mbɨŋ mu. ");
INSERT INTO bmo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ndɔ ŋ̀ga nchwīe pi nɔ haʼaŋ Tǎa a fɛ gɨ́ vəɨ ŋa ǹchwīe nɛ, nnɛ ŋa ŋgwa ŋkuoŋ mbhi ji ŋa ŋ̀khwā Tǎa. “Pəɨ lɔllɔ, p̂ia ghə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“A mmu mbɔ ŋkiɛŋ ndǎa grape, Tǎa a pɔ ŋgaŋ nyìeŋ. ");
INSERT INTO bmo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sheshe fɨ̀ga mbhɔ ma ŋa a lɔ njiʼi njuŋ nɛ a yaʼa mīʼaŋ. Ti sheshe mbhɔ ŋa a yuŋ ntíɛŋ nɛ, a fēe ŋa a pɨnɨ njuŋ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ndɔ pəɨ kwo pɔ yi taoŋtaoŋ nthɛ chrà ŋa mi ni nchrā ni pəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","P̂əɨ kɨna mbɨŋ mu, ŋ̀kɨna mbɨŋ pəɨ. Minthɛ paʼa fɨ̀ga ndǎa grape lɔ njuŋ ntíɛŋ ni noŋ yi ki lɔ ŋguʼɔ ŋkɨna pi ŋkuoŋ ndǎa grape ghɔ. Wuʼɔ nɔ haʼaŋ mbaʼa pəɨ ŋkaa pəɨ yuŋ ntíɛŋ kaŋ a nɛiŋ pəɨ kɨna mbɨŋ mu. ");
INSERT INTO bmo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“A mmu mbɔ ndǎa grape, pəɨ pɔ pa fɨ̀ga mbhɔ ma. Shesheŋoŋ ŋa a kɨna mbɨŋ mu, ŋ̀kɨna mbɨŋ yu nɛ, a ju ŋa a shi njuŋ ntou ntíɛŋ. Nthɛ ŋa m̈i ŋkiɛŋ, paʼa pəɨ lɔ nchwīe sheshe nnu. ");
INSERT INTO bmo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","S̈hesheŋoŋ mieŋ ki kɨna mbɨŋ mu, pi mīʼaŋ vi nɔ fɨ̀ga mbhɔ, a yaoŋ, pi kɨrɨ pa mbhɔ mi pighɔ māʼaŋ moŋ móŋoŋ pugu kɨɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","P̈əɨ ŋkɨna mbɨŋ mu, chrà a kɨna mbɨŋ pəɨ, pəɨ pie sheshe yaoŋ ŋa pəɨ tāʼa nu nɛ, kaŋ pi shi nchwīe mfɛ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ntɔgɔ pi ŋkuoŋ yei nnu Tǎa a ghà mfāʼo ndighaʼo yi, ŋa pəɨ yuŋ ntou ntíɛŋ, nnɛ nōoŋ ŋa pəɨ ghaŋ younjiŋ paŋ. ");
INSERT INTO bmo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Nɔ haʼaŋ Tǎa khwā a nɛ, a haʼaŋ ŋ̀khwā vəɨ nɛ. P̂əɨ kɨna moŋ khwǎ a. ");
INSERT INTO bmo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","P̈əɨ nūʼɔŋ pa kɨ̀na paŋ, kaŋ pəɨ shi ŋkɨna moŋ khwǎ a, wuʼɔ nɔ haʼaŋ mummu nūʼɔŋ kɨ̀na Tǎa a nnɛ ŋkɨna moŋ khwǎ yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ŋ̀ki chrà nnu pei ni pəɨ nnɛ ŋa pwanjuʼɔ a pɔ mbɨŋ pəɨ, pwanjuʼɔ yəɨ lɨnaoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yei kɨ̀na a, ŋa pəɨ ŋkhwā noŋ pəɨ nɔ haʼaŋ ŋkhwā vəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yichəɨ mmɛ khwǎ lɔ mbɔ ntɔgɔ yei, ŋa ŋoŋ fɛ chɔmbhi yi nthɛ taannu pi. ");
INSERT INTO bmo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pəɨ pa taannu paŋ, nɔ haʼaŋ p̈əɨ nūʼɔŋ kɨ̀na a. ");
INSERT INTO bmo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ǹdɔ nuʼuŋ mɛ̄iŋ vəɨ pi ni puoŋ fàʼa paŋ, nthɛ ŋa muuŋ fàʼa shiʼa nji yaoŋ ŋa Taathɔ vi chwīe nu nɛ. Ndɔ m̀ɛ̄iŋ vəɨ pi ni taannu paŋ nthɛ ŋa ŋguoŋ nnu ŋa ǹjaʼo mbhɔ Tǎa nɛ, ǹchwīe pəɨ ji. ");
INSERT INTO bmo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Pəɨ shi ki lɔ nchuʼɔ a, a ni nchuʼɔ mmu nchuʼɔ vəɨ, nūʼɔŋ vəɨ ŋa pəɨ ghə̄ɨ njuŋ ntíɛŋ, ntíɛŋ yəɨ kɨna, nnɛ ŋa sheshe yaoŋ ŋa pəɨ shi mbie Tǎa nɔ ghɔ ni ligi a nɛ, a nthɛ a fɛ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","M̀fɛ kɨ̀na pei ni pəɨ, nnɛ ŋa pəɨ khwā noŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Pa ŋ̈gwa ŋkuoŋ mbhi mbɨ̄na vəɨ, pəɨ ji ŋa pugu kwo fǔoŋ mbɨ̄na a ŋkaoŋ maa mbɨ̄na vəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pəɨ kaŋ ni mbɔ pi yi ŋgwa ŋkuoŋ mbhi, ŋgwa ŋkuoŋ mbhi kaŋ ŋkhwā vəɨ nɔ yugu. Ndɔ nthɛ ŋa pəɨ lɔ njiʼi mbɔ yi ŋgwa ŋkuoŋ mbhi, ndɔ a chuʼɔ mmu nchuʼɔ vəɨ ŋa pəɨ taoŋ shɨna ŋgwa ŋkuoŋ mbhi nɛ, a chwīe yie ghɔ ŋgwa ŋkuoŋ mbhi pɨ̄na vəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pəɨ kwiŋ chrà ŋa mi ni nchrā ni pəɨ nɛ, ‘Muuŋ fàʼa shiʼa nchaa Taathɔ vi.’ P̈ugu mfɛ ŋgəʼɨ vəɨ, kaŋ pugu shi mfɛ ŋgəʼɨ ni pəɨ ŋkaa pəɨ. Pugu kaŋ ni nūʼɔŋ chrà a, kaŋ pugu shi nūʼɔŋ yəɨ ŋkaa pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ndɔ pugu shi nchwīe ŋguoŋ nnu pei ghao mbɨŋ pəɨ nthɛ ligi a, nthɛ ŋa pugu lɔ njiʼi nji ŋoŋ ŋa a taoŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ŋka ni mieŋ ki lɔ nthɔ nchrā ni pugu, pi shi kaŋ ndɔ ŋgwɛ̄iŋ vugu nɔ pa ghaŋ phɨ. Ndɔ ndwɛ pugu lɔ nuʼuŋ mfāʼo la nɔ māʼaŋ nu nthɛ phɨ yugu. ");
INSERT INTO bmo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Shesheŋoŋ ŋa a pɨ̄na a nɛ, pɨ̄na Tǎa a ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ŋka ni mieŋ ki chwīe pa nnu shɨna pugu ŋa yichəɨ ŋoŋ lɔ naa nchwīe nɛ, pi shi kaŋ ŋgwɛ̄iŋ vugu nɔ pa ghaŋ phɨ. Ndɔ ndwɛ pugu yəɨ ndɔ mbɨ̄na vigi Tǎa a. ");
INSERT INTO bmo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ndɔ chrà yei ŋa pi nāʼaŋ moŋ gɨ́ yugu ŋa, ‘Pugu pɨ̄na a ki laʼo yi’, shi ŋguʼɔ ndɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ndɔ ndɨɨ ŋa ŋgaŋ ghɛ̀rɛ, mbɔ Jijwɛ nnu shini ŋa ǹshi ntaoŋ llɔ mbhɔ Tǎa shi nthɔ nɛ, kaŋ a shi ŋkwe ntie a. ");
INSERT INTO bmo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pəɨ ŋkaa pəɨ shi ŋkwe ntie a nthɛ ŋa pia pɔ kaʼa llɔ nɔ njɛ̄ yi. ");
INSERT INTO bmo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ŋ̀kwo chhu ŋguoŋ nnu pei ni pəɨ nɔ chwīe nu kiʼi pəɨ gū moŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pi shi mfuʼu vəɨ moŋ pa nda luoŋ Minnwi. Shishini, ndɨɨ chhɔ nthɔ nu ŋa ŋgwa ŋa pugu shi njwi vəɨ nɛ shi mbīʼi ŋa pugu fāʼa pi mbhɔ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Pugu shi nchwīe pa nnu pei nthɛ ŋa pugu lɔ nji Tǎa, ki nji a. ");
INSERT INTO bmo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ndɔ nchhu nnu pei ni pəɨ nnɛ ŋa ndɨɨ yugu gha ŋkāʼo, minthɛ pəɨ kwiŋ ŋa mi ni ŋkwo shwei vəɨ. “Ǹshini ndɔ nchhu nnu pei ni pəɨ nɔ njɛ̄ yi, nthɛ ŋa pia ni mbɔ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ndɔ ndwɛ ǹthɔ ŋgə̄ɨ nu njəɨ ŋoŋ ŋa a ni ntaoŋ a nɛ, ndɔ paʼa kaŋ taʼa ŋoŋ vəɨ lɔ mbie a ŋa, ‘Ɔ ghə̄ɨ pi hɨŋ?’ ");
INSERT INTO bmo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ndɔ pəɨ fāʼo yuʼɔ njùʼɔ nthɛ ŋa ǹchhu nnu pei ni pəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mbapa nɛnnɛ, ǹshwei vəɨ ni nnu shini. A pɔ pi shéi ni pəɨ ŋa ŋ̀gə̄ɨ. Nthɛ ŋa m̈i mieŋ ki ghə̄ɨ, paʼa ŋgaŋ ghɛ̀rɛ lɔ nthɔ njəɨ vəɨ. Ndɔ m̈i ŋgə̄ɨ, kaŋ ǹshi ntaoŋ vi ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A shi ŋga nthɔ, kaŋ a shi nshrā ŋgwa ŋkuoŋ mbhi paa nthɛ phɨ yugu, pugu pa nnu ndɨndɨ pugu pa nnu sháʼa. ");
INSERT INTO bmo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A shi nshrā vugu paa nɔ nnu phɨ, nthɛ ŋa pugu lɔ njiʼi mbiŋ a, ");
INSERT INTO bmo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","nɔ nnu ndɨndɨ nthɛ ŋa ǹthɔ ŋgə̄ɨ nu njəɨ Tǎa, ndɔ mbaʼa pəɨ nuʼuŋ njəɨ a ŋkamuʼɔŋ ndwɛ, ");
INSERT INTO bmo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","nɔ nnu sháʼa, nthɛ ŋa pi shaʼa ŋgaŋ shaʼa mbhi yei. ");
INSERT INTO bmo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ŋ̀guʼɔ mbɨnɨ mfāʼo ntou nnu nɔ chhu nu ni pəɨ, ndɔ a chaa ghrɨ́ yəɨ nɔ yaʼo nu ndwɛ. ");
INSERT INTO bmo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ndɔ ndɨɨ ŋa Jijwɛ nnu shini thɔ nɛ, a shi nōoŋ ŋguoŋ nnu shini ghao ni pəɨ, nthɛ ŋa mbaʼa a yiʼi nchrā pi ni thɔ yi, sheshe nnu ŋa a yaʼo nɛ a shi nchhu, ndɔ shwei vəɨ ni pa nnu ŋa a shi nthɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A shi ŋgaʼo a nthɛ ŋa a shi ndɔ̄gɔ pa yaoŋ ŋa a nyaŋ nɛ nshwei vəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ŋguoŋ yaoŋ ŋa Tǎa fāʼo nɛ pɔ pi nyaŋ. Nthɛ yie ghɔ, ǹchhu ŋa a shi ndɔ̄gɔ pa yaoŋ ŋa a nyaŋ nɛ nchhu ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Nɔ muuŋ kuo ndɨɨ, mbaʼa pəɨ nuʼuŋ njəɨ a, a gha nuʼuŋ ndara muuŋ kuo ndɨɨ ŋkamuʼɔŋ pəɨ pɨnɨ njəɨ a.” ");
INSERT INTO bmo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nɛnnɛ pichəɨ pa ghaŋ younjiŋ pi chhu ni noŋ pugu ŋa, “A chhu pi ŋa ni pia, ‘Nɔ muuŋ kuo ndɨɨ mbaʼa pəɨ nuʼuŋ njəɨ a, a gha nuʼuŋ ndara muuŋ kuo ndɨɨ ŋkamuʼɔŋ pəɨ pɨnɨ njəɨ a,’ ndɔ mbɨnɨ nchhu ŋa, ‘Nthɛ ŋa ŋ̀gə̄ɨ nu njəɨ pi Tǎa’?” ");
INSERT INTO bmo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nnɛ, pugu chhu nu ŋa, “A gha nchhu ŋa, ‘Nɔ muuŋ kuo ndɨɨ,’ njiŋ yi pɔ pi ŋa? Pigi lɔ nji nnu ŋa a chhu nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jishɔ ni nji ŋa pugu tāʼa nu mbie vi, nnɛ a chhu ni pugu ŋa, “Yei nnu ŋa pəɨ pie noŋ pəɨ nɔ ghɔ nɛ mbɔ njiŋ nnu ŋa ǹchhu ŋa, ‘Nɔ muuŋ kuo ndɨɨ mbaʼa pəɨ nuʼuŋ njəɨ a, a gha nuʼuŋ ndara muuŋ kuo ndɨɨ ŋkamuʼɔŋ pəɨ pɨnɨ njəɨ a?’ ");
INSERT INTO bmo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Shishini, ǹchhu ni pəɨ ŋa, pəɨ shi ŋkə̄ɨ ndɔ njwei ndɔ ŋkuoŋ mbhi fāʼo pwanjuʼɔ. Pəɨ shi mfāʼo yuʼɔ njùʼɔ, ndɔ yuʼɔ njùʼɔ yəɨ kara mbɔ pwanjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Miŋgwɛ ghà ŋga mbhi nu, mfāʼo yuʼɔ njùʼɔ nthɛ ŋa ndɨɨ yi kāʼo, ndɔ ti ndɨɨ ŋa a kwo phi muuŋ ghɔ nɛ, a līʼɛ yúʼɔ ghɔ nthɛ pwanjuʼɔ ŋa pi phi ŋoŋmishua ŋkuoŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nthɛ yie ghɔ, pəɨ fāʼo yuʼɔ njùʼɔ ndwɛ ndɔ ǹshi mbɨnɨ njəɨ vəɨ pəɨ fāʼo pwanjuʼɔ, ndɔ mbaʼa shesheŋoŋ pɨnɨ mfuʼu pwanjuʼɔ yəɨ ghɔ mbɨŋ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Moŋ llɛ́ ghɔ, mbaʼa pəɨ nuʼuŋ mbie sheshe yaoŋ mbhɔ mu, shishini, ǹshwei vəɨ, sheshe yaoŋ ŋa pəɨ pie mbhɔ Tǎa nɔ ligi a nɛ, a shi mfɛ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ndɔ ti nchəɨŋ ndwɛ, pəɨ shi lɔ mbie sheshe yaoŋ yaʼa nɔ ligi a. P̂əɨ pie kaŋ pəɨ shi mfāʼo nnɛ ŋa pwanjuʼɔ yəɨ lɨnaoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ŋ̀ki kwo chhu nnu pei ni pəɨ pi moŋ chrà luʼɔ, ndɨɨ chhɔ thɔ nu ŋa mbaʼa nuʼuŋ nchrā ni pəɨ pi moŋ chrà luʼɔ, ndɔ shi nchrā chrà shieshie nthɛ Tǎa. ");
INSERT INTO bmo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Moŋ llɛ́ ghɔ, pəɨ shi mbie pa nnu nɔ ligi a, ndɔ ǹdɔ njiʼi nchhu ni pəɨ ŋa ǹshi mbie mbhɔ Tǎa nthɛ vəɨ, ");
INSERT INTO bmo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nthɛ ŋa nduthɔ Tǎa ŋkaa yu khwā vəɨ nthɛ ŋa pəɨ khwā a, ndɔ ni mbiŋ ŋa ǹdhɔ mbhɔ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi ni ndhɔ pi mbhɔ Tǎa nthɔ ŋkuoŋ mbhi, ndwɛ ǹdhɔ nu mieŋ ŋkuoŋ mbhi mbɨnɨ nu njəɨ Tǎa.” ");
INSERT INTO bmo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pa ghaŋ younjiŋ pi chhu ghɔ ŋa, “Yo! Ndwɛ ɔ ya nchrā a shie nu ki lɔ mbɔ pi chrà luʼɔ! ");
INSERT INTO bmo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ndwɛ, pigi ji ŋa ɔ ji ŋguoŋ nnu ghao, paʼa ndɔ nuʼuŋ nchēi nu ŋa ŋoŋ pie ghɔ ni pie, a chwīe yie ghɔ pigi piŋ ŋa ɔ llɔ mbhɔ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jishɔ khwɛ̄ ŋa, “Pəɨ piŋ ndwɛ? ");
INSERT INTO bmo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pəɨ līi njəɨ, ndɨɨ chhɔ nthɔ nu, ndɔ ŋkwo thɔ ŋa pi shi nshāaŋ vəɨ, shesheŋoŋ ghə̄ɨ laʼa yu mieŋ a təʼɨ a. Ndɔ ǹdɔ mbɔ pi təʼɨ a, nthɛ ŋa Tǎa pɔ pigi yu kaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ǹchhu nnu pei ni pəɨ nnɛ ŋa pəɨ shi mfāʼo ghɨghrɨ ntɔgɔ pi ŋkuoŋ pɔ nu taʼa yi pia kaʼa. Moŋ mbhi yei, pi shi mfɛ wuwuru ŋgəʼɨ ni pəɨ. Ndɔ pəɨ fāʼo māʼaŋ ghrɨ́, nthɛ ŋa ŋ̀kwo ghaʼa ŋkuoŋ mbhi yei.” ");
INSERT INTO bmo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jishɔ ni ŋga ŋkwo chrā pa nnu pei, mbɨʼɨ ligi yi ndīi po nchhu ŋa, “Tǎa, ndɨɨ ghɔ kāʼo, ghaʼo muuŋ ghɔ nnɛ ŋa muuŋ ghaʼo ghɔ, ");
INSERT INTO bmo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ŋa ɔ fɛ ghrɨ́ ghɔ mbɨŋ ŋguoŋ ŋgwa nɛ, ŋa a fɛ chɔmbhi ki mmɛ ni ŋguoŋ ŋgwa ŋa ɔ fɛ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ndɔ yei pɔ chɔmbhi ki mmɛ, ŋa pugu ji ghɔ mbɔ fiɛŋ taʼa Minnwi shini, ndɔ mbɨnɨ nji Jishɔ Krishto ŋa ɔ taoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi ni mfɛ ndighaʼo vɛ ŋkuoŋ shhɛ hɛiŋ ndɨɨ ŋa mi ni ŋkwo mīʼɛŋ fàʼa ŋa ɔ ni mfɛ vəɨ ŋa m̀fāʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ndɔ ndwɛ, ma Tǎa, ghaʼo a shhɨ ghɔ ni ŋkwaŋ ndighaʼo ŋa mi ni mfāʼo pɔgɔ ŋkaoŋ mbhi maa mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mi ni nchwīe ŋgwa pɛ ŋa ɔ ni mfɛ vəɨ moŋ mbhi nɛ ji ghɔ. Pugu ni mbɔ jɔ, ɔ fɛ vugu vəɨ, pugu nūʼɔŋ chrà yɔ. ");
INSERT INTO bmo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ndwɛ, pugu ji ŋa ŋguoŋ yaoŋ ŋa ɔ ni mfɛ vəɨ nɛ llɔ pi mbhɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mi ni māʼaŋ ŋkɨ̀nɨ yɛ ŋa ɔ ni mfɛ vəɨ nɛ ni pugu, pugu piŋ ŋkɨ̀nɨ ghɔ, ndɔ nji shishini ŋa ǹdhɔ pi mbhɔ ghɔ ndɔ mbiŋ ŋa a taoŋ gɔ̀ ntaoŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ǹthɔ nduoŋ mfɛ nu ni pugu, ǹdɔ njiʼi nduoŋ pi ni ŋkuoŋ mbhi, ǹduoŋ pi ni ŋgwa pɛ ŋa ɔ ni mfɛ vugu vəɨ nɛ, nthɛ ŋa pugu jɔ. ");
INSERT INTO bmo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ŋguoŋ yaoŋ ŋa m̀fāʼo nɛ jɔ, ŋguoŋ yaoŋ ŋa ɔ fāʼo nɛ pɔ nyaŋ, pi yəɨ ndighaʼo a ntɔgɔ pi mbɨŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ndɔ ndwɛ, ǹthɔ mbɨnɨ nu njəɨ ghɔ, ǹdɔ nuʼuŋ mbiʼi ŋkuoŋ mbhi, a pugu ŋkuoŋ mbhi. Tǎa ŋa a pɔ taoŋtaoŋ nɛ, nūʼɔŋ vugu ki kàʼa lɔ ŋkēe vugu ni ghrɨ́ ligi yɔ ŋa ɔ fɛ vəɨ nɛ, nnɛ ŋa pugu pɔ taʼa yi wuʼɔ nɔ haʼaŋ pɔgɔ taʼa yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nɔ haʼaŋ pigi pugu ni mbɔ nɛ, mi ni ndɨna ni pugu ntɔgɔ pi ŋkuoŋ ghrɨ́ ligi yɔ ŋa ɔ fɛ vəɨ nɛ. Ŋ̀kɛ̄ʼi vugu ti paʼa kaŋ taʼa ŋoŋ vugu lɔ mbhɛ, ŋkiɛŋ yɛ ŋoŋ ŋa a ni njīʼi ŋa a phɛ nɛ, nnɛ ŋa nnu ŋa Ŋwaʼaŋlɨ Minnwi ni ŋkwo chhu nɛ lɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ndɔ ndwɛ, ǹthɔ mbɨnɨ nu njəɨ ghɔ, ǹchhu nnu pei ŋkuoŋ mbhi nnɛ ŋa pugu fāʼo pwanjuʼɔ a njùʼɔ pugu ti a lɨnaoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ŋ̀kwo māʼaŋ ŋkɨ̀nɨ yɔ ni pugu, ŋkuoŋ mbhi pɨ̄na vugu nthɛ ŋa pugu lɔ mbɔ yi ŋkuoŋ mbhi wuʼɔ nɔ haʼaŋ mummu lɔ mbɔ yi ŋkuoŋ mbhi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ǹdɔ njiʼi nchhu pi ŋa ɔ fuʼu vugu moŋ mbhi, ǹchhu pi ŋa ɔ kɛ̄ʼi vugu mbhɔ ŋoŋ mbɨmbhɨ. ");
INSERT INTO bmo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Pugu lɔ njiʼi mbɔ yi ŋkuoŋ mbhi yei wuʼɔ nɔ haʼaŋ mummu lɔ njiʼi mbɔ yi mbhi yei nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Chuʼɔ vugu nūʼɔŋ nɔ fàʼa yɔ ntɔgɔ pi ŋkuoŋ nnu shini yɔ, chrà yɔ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nɔ haʼaŋ ɔ ni ntaoŋ a moŋ mbhi nɛ, a wuʼɔ haʼaŋ mummu taoŋ vugu moŋ mbhi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ǹchuʼɔ noŋ a nūʼɔŋ nɔ fàʼa yɔ nthɛ pi pugu, nnɛ ŋa pinthɛ pi chuʼɔ vugu ŋkaa pugu nūʼɔŋ nɔ fàʼa yɔ ntɔgɔ pi ŋkuoŋ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ǹdɔ ŋguʼɔ nduoŋ pi ni pei təʼɨ vugu, m̀bɨnɨ nuʼuŋ nduoŋ ni pɛ ŋa pugu shi mbiŋ ntɔgɔ ŋkuoŋ chrà yugu nɛ, ");
INSERT INTO bmo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","nnɛ ŋa ŋguoŋ yugu shi nchīri mbɔ taʼa yi, wuʼɔ nɔ haʼaŋ gɔ̀ Tǎa pɔ mbɨŋ mu, mmu nduthɔ a pɔ mbɨŋ ghɔ nɛ, nnɛ ŋa pugu pɔ mbɨŋ pɔgɔ, nnɛ ŋa minthɛ ŋkuoŋ mbhi piŋ ŋa a taoŋ gɔ̀ ntaoŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Ndighaʼo ŋa ɔ fɛ vəɨ nɛ m̀fɛ ni pugu, nnɛ ŋa pugu pɔ taʼa yi wuʼɔ nɔ haʼaŋ pɔgɔ taʼa yi nɛ, ");
INSERT INTO bmo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","M̀bɔ mbɨŋ pugu ɔ pɔ mbɨŋ mu, nnɛ ŋa pugu ya mbɔ taʼa yi shiʼi, nnɛ ŋa ŋkuoŋ mbhi ji ŋa ɔ taoŋ a ndɔ ŋkhwā vugu wuʼɔ nɔ haʼaŋ ɔ khwā a nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tǎa, ŋ̀khwā ŋa pugu ŋkaa pugu ŋa ɔ fɛ vəɨ nɛ nshi mbɔ pigi pugu kaʼa lɨʼɨ ŋa m̀bɔ nɛ, nɔ yəɨ nu ndighaʼo a ŋa ɔ fɛ vəɨ nthɛ ŋa ɔ khwā a ŋkaoŋ pi maa nchwīe mbhi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Yo Tǎa ndɨndɨ, njiʼi nthɛ pi nɔ haʼaŋ ŋkuoŋ mbhi lɔ njiʼi nji ghɔ nɛ, ǹji ghɔ, pa ghaŋ younjiŋ pei ji ŋa a taoŋ gɔ̀ ntaoŋ a. ");
INSERT INTO bmo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi ni nchwīe pugu ji ghɔ, ndɔ shi ŋguʼɔ ŋgə̄ɨ shhɨ nchwīe nu, nnɛ ŋa khwǎ ŋa ɔ khwā a nɔ ghɔ nɛ, pugu shi mfāʼo, mummu ŋkaa mu pɔ mbɨŋ pugu.” ");
INSERT INTO bmo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jishɔ ni ŋga ŋkwo mīʼɛŋ lúoŋ yei, ntaoŋ pugu pa ghaŋ younjiŋ pi ŋgə̄ɨ nshāʼa Pɨprəɨ Kidroŋ. Nyìeŋ chəɨ ni mbɔ fɔ, Jishɔ pugu pa ghaŋ younjiŋ pi nii fɔ. ");
INSERT INTO bmo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judashi, ŋa a ni mfīni Jishɔ nɛ, ni nji lɨʼɨ ghɔ nthɛ ŋa Jishɔ ni njiɛŋ mbāoŋ nu fɔ pugu pa ghaŋ younjiŋ pi. ");
INSERT INTO bmo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nnɛ Judashi lɔ̄gɔ kwíe pa shoogɛ Roma, ni pa ghaŋ kɛ̄ʼi Nda Minnwi ŋa pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ŋgwa Farashi ni ntaoŋ nɛ, pugu pugu ghə̄ɨ moŋ nyīeŋ ghɔ. Pugu ni ntuo truka, pugu pa ŋkiʼa pugu pa maoŋ nchhɔ̀. ");
INSERT INTO bmo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jishɔ gha ŋkwo ji ŋguoŋ nnu ŋa a shi ndɔ̄gɔ lɨʼɨ mbɨŋ yu nɛ, ntaoŋ nthɔ shhɨ nchhu ni pugu ŋa, “Pəɨ tāʼa pi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pugu khwɛ̄ ŋa, “Jishɔ llɔ Nasharɛ.” Jishɔ chhu ni pugu ŋa, “A mmu mbɔ ju.” Judashi, ŋa a ni mfīni vi nɛ, ni nthi fɔ pugu pugu. ");
INSERT INTO bmo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ndɨɨ ŋa Jishɔ ni nchhu ni pugu ŋa, “A mmu mbɔ ju nɛ,” pugu pɨ̄nɨ njiŋnjiŋ ŋgū shhɛ. ");
INSERT INTO bmo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nnɛ Jishɔ pɨnɨ mbie vugu ŋa, “Pəɨ tāʼa pi gɔ̌?” Pugu chhu ŋa, “Jishɔ llɔ Nasharɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jishɔ khwɛ̄ ŋa, “Mi ni ŋkwo chhu ŋa a mmu mbɔ ju. Nnɛ ti p̈əɨ ntāʼa a, pəɨ mieŋ ŋgwa pei ghə̄ɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yei nnu ni mbɔ nɔ chwīe nu nnu ŋa a ni ŋkwo chhu nɛ lɔ̄gɔ lɨʼɨ: “Shɨna ŋguoŋ ŋgwa pɛ ŋa ɔ ni mfɛ vəɨ nɛ, ǹshi lɔ mbhɛ kaŋ taʼa yi fɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nnɛ Shemu Pita, ŋa a ni mfāʼo kafa nɛ, shua nche tə́nə muuŋ fàʼa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, tə́nə muuŋ fàʼa ghɔ yaʼa. (Ligi muuŋ fàʼa ghɔ ni mbɔ Maakushi.) ");
INSERT INTO bmo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nnɛ Jishɔ chhu ni Pita ŋa, “Niʼiŋ kafa yɔ moŋ m̀baʼa yi. Ɔ pīʼi ŋa m̀baʼa njiʼi nnu ndua ŋgəʼɨ yɛ ŋa Tǎa fɛ vəɨ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nnɛ kwíe pa shoogɛ pighɔ pugu pa thishɨ pugu ni pa ghaŋ kɛ̄ʼi Nda Minnwi pa ŋgwa Juu wɛ̄iŋ Jishɔ ŋkrao vi, ");
INSERT INTO bmo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","fǔoŋ ndɔ̄gɔ vi ŋgə̄ɨ nɔ njəɨ Anaŋ, nthɛ ŋa a ni mbɔ tǎa ŋgwɛ Kaifa ŋa a ni mbɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ŋgaʼo ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A ni mbɔ Kaifa ŋa a ni ntɨgɨ pa ŋgwa Juu ŋa, “A pwa ŋa taʼa ŋoŋ khu nɔ ligi ŋguoŋ ŋgwa.” ");
INSERT INTO bmo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Shemu Pita pugu yichəɨ ŋgaŋ younjiŋ Jishɔ ghə̄ɨ njiŋ Jishɔ. Nthɛ ŋa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ni nja nji yie taʼa ŋgaŋ younjiŋ Jishɔ shiʼi nɛ, a nii moŋ yɨna Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ndɔ Pita thi pi chonda mbhi. Nnɛ yɛ ŋgaŋ younjiŋ Jishɔ ŋa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ni nji vi nɛ taoŋ mbhi nchrā pugu yɛ muuŋ miŋgwɛ ŋa a ni mbɔ choŋkaʼa nɛ, ndɔ̄gɔ Pita nii ni ju. ");
INSERT INTO bmo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Muuŋ miŋgwɛ ghɔ ŋa a ni mfāʼa nu choŋkaʼa nɛ chhu ni Pita ŋa, “Gɔ̀ ŋkaa ghɔ lɔ mbɔ taʼa ŋgaŋ younjiŋ ŋoŋ yinɛ?” Pita chhu ŋa, “Ndɔ mbɔ taʼa yi.” ");
INSERT INTO bmo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ndwɛ puoŋ fàʼa pugu pa ghaŋ kɛ̄ʼi Nda Minnwi ni frə̄ɨ móŋoŋ nthi fɔ njɨgɔ nu nthɛ ŋa fɨgəɨ ni mbɔ. Pita ni mbɔ pugu pugu nthi fɔ nthɔ njɨgɔ nu ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pie Jishɔ ni pa pie nthɛ pa ghaŋ younjiŋ pi pugu pa nnu ŋa a ni njɛʼi nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jishɔ khwɛ̄ ghɔ ŋa, “Ŋ̀ga ŋguʼɔ nchrā pi lɨʼɨ wo ni ŋguoŋ ŋgwa ghao. Ŋ̀ga ŋguʼɔ njɛʼi moŋ pa nda luoŋ Minnwi pugu pa Nda Minnwi lɨʼɨ haʼaŋ ŋguoŋ pa Juu ghà ŋkɨrɨ nɛ. Ǹdɔ njiʼi nchrā sheshe nnu pi lə̄ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ti ɔ pie a pi ŋa? Pie ni ŋgwa haʼaŋ pugu ni njaʼo nnu ŋa mi ni njɛʼi nu nɛ, pugu ji nnu ŋa mi ni nchhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","A ni ŋga nchhu nnu pei, yichəɨ taʼa ŋgaŋ kɛ̄ʼi Nda Minnwi wie Jishɔ ni mbhɔ yi, nchhu nu ŋa, “Yinɛ haʼaŋ pi ghà ŋkhwɛ̄ nnu ni taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jishɔ khwɛ̄ ghɔ ŋa, “Nnu ŋa ǹchhu nu nɛ mieŋ ki kāʼo, ɔ chhu nɛ ntəɨ ghɔ ni ŋguoŋ ŋgwa pei hɛiŋ. Ndɔ ti ä mbɔ ŋa nnu ŋa ǹchhu nɛ kāʼo, ɔ wie kiʼɛ ŋa?” ");
INSERT INTO bmo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anaŋ taoŋ vi kiʼɛ, a wuʼɔ mbɔ moŋ ŋkɨɨ, ni Kaifa mbɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Shemu Pita ni ŋguʼɔ ntithi fɔ nthɔ njɨgɔ móŋoŋ. Nnɛ pugu chhu ghɔ ŋa, “Gɔ̀ ŋkaa ghɔ lɔ mbɔ taʼa ŋgaŋ younjiŋ ŋoŋ vinɛ?” A lāa nchhu ŋa, “Ndɔ mbɔ taʼa yi.” ");
INSERT INTO bmo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yichəɨ taʼa muuŋ fàʼa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, mbɔ ndaaŋoŋ ŋoŋ vɛ ŋa Pita ni njaʼa tə́nə yi nɛ pie ŋa, ǹshini ndɔ njəɨ ghɔ moŋ nyìeŋ pəɨ yu? ");
INSERT INTO bmo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita pɨnɨ nuʼuŋ ndāa ŋkamuʼɔŋ. Wuʼɔ ndɨɨ ghɔ, miŋkəʼɨ khwɛ. ");
INSERT INTO bmo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ŋkiɛŋ ni muuŋ tutuʼu, pugu lɔ̄gɔ Jishɔ llɔ nda Kaifa ŋgə̄ɨ nɔ ntuʼɔ mmɛ ŋgaŋ shaʼa lɨʼɨ. Nduthɔ yugu shini ndɔ nii ntuʼɔ mmɛ ŋgaŋ shaʼa lɨʼɨ ghɔ nnɛ ŋa kiʼi pugu fuo noŋ yugu nji ŋa mimfɛ pugu jɨ Lli Njiʼa. ");
INSERT INTO bmo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nnɛ Pailɛ taoŋ mbhi njəɨ vugu mbie ŋa, “Pəɨ wɛ̄iŋ ŋoŋ vei ŋa a fāaŋ pi khɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pugu khwɛ̄ ghɔ ŋa, “Ŋoŋ vei kaŋ mieŋ ki thɔ nchwīe pi phɨ, pigi shi kaŋ ndɔ ndɔ̄gɔ vi nthɔ mfɛ vɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailɛ chhu ni pugu ŋa, “Pəɨ lɔ̄gɔ vi ni noŋ yəɨ nshaʼa vi ŋkwaŋ nɔ haʼaŋ gɨ́ yəɨ chhu nɛ.” Pa Juu chhu ghɔ ŋa, “Pi lɔ njiʼi mbiŋ ŋa pigi jwi shesheŋoŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yei nnu ni ndɔ̄gɔ lɨʼɨ nɔ nōoŋ nu ŋa nnu ŋa Jishɔ ni nchhu nɛ nnu shini ndɨɨ ŋa a ni nshwei ŋkwaŋ gu ŋa a shi ŋkhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nnɛ Pailɛ pɨnɨ nii ntuʼɔ yu, mɛ̄iŋ Jishɔ mbie ghɔ ŋa, “Ɔ fùoŋ pa Juu?” ");
INSERT INTO bmo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jishɔ khwɛ̄ ŋa, “Yei pie llɔ pi mbɔ ghɔ ki a chhu pichəɨ ŋgwa vɛ nnɛ nthɛ a?” ");
INSERT INTO bmo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailɛ khwɛ̄ ŋa, “Ɔ pīʼi ŋa m̀bɔ pi ŋoŋ Juu? Ŋgwa laʼa pəɨ pugu pa thishɨ ghaŋ fɛʼiŋgiɛŋ chaʼa ghɔ mfɛ vəɨ. Ɔ chwīe pi nɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jishɔ khwɛ̄ ŋa, “Shaʼafuoŋ a lɔ njiʼi mbɔ pi yi ŋkuoŋ mbhi yei. Shaʼafuoŋ a kaŋ ni mbɔ pi yi ŋkuoŋ mbhi yei, pa ghaŋ younjiŋ paŋ kaŋ nthɔ ŋgwie ŋkrɔ̀, nnɛ ŋa kiʼi pi chaʼa a mfɛ ni thishɨ pa ŋgwa Juu. Njɨ a nɔ shaʼa nu lɔ ndhɔ pi ŋkuoŋ mbhi hɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nnɛ Pailɛ chhu ghɔ kiʼɛ ŋa, “Yie nōoŋ ŋa ɔ fùoŋ?” Jishɔ khwɛ̄ ŋa, “Ɔ chhu ŋa a mmu mbɔ fùoŋ. Yei nnu ŋa pi ni mbhi a nɔ nɛ, yei nnu ŋa ǹthɔ ŋkuoŋ mbhi yei nɔ nɛ, nɔ pɔ nu miŋkwentie nɔ nnu shini. Shesheŋoŋ ŋa a yi nnu shini nɛ ghà njwɛrɛ nnu ŋa ǹchhu nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailɛ pie ghɔ ŋa, “Nnu shini pɔ pi khɔ?” Pailɛ ni ŋga nchhu nnu yei, ntaoŋ mbhi mbara pa ŋgwa Juu nchhu ni pugu ŋa, “Ndɔ njəɨ fàŋ ŋoŋ vei. ");
INSERT INTO bmo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ndɔ pəɨ fāʼo nùʼɔŋ ŋa ŋ̀ga ŋguʼɔ nchuʼɔ taʼa ŋgaŋ chə́ɨŋ mfɛ ni pəɨ ndɨɨ Lli Njiʼa. Nnɛ pəɨ tāʼa nu ŋa nchuʼɔ fùoŋ pa ŋgwa Juu mfɛ ni pəɨ?” ");
INSERT INTO bmo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pugu chhu ni njɨ ŋa, “Paʼa ndɔ mbɔ pi ŋoŋ vei, mbɔ pi Baraba.” Baraba ni mbɔ ŋgɨna minwi. ");
INSERT INTO bmo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nnɛ Pailɛ lɔ̄gɔ Jishɔ ŋgwie vi ni ŋgwàŋ. ");
INSERT INTO bmo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pa shoogɛ paʼa ndiʼi minduandua nɔ ŋkie, nūʼɔŋ thɔ yu, māʼaŋ pɨ̀rɨ mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Pugu thɔ njəɨ vi, nchhu nu ŋa, “Pigi ghɨnɔ ghɔ ma fùoŋ pa Juu!” Ndɔ ŋgwie vi ni mbhɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailɛ pɨnɨ ntaoŋ mbhi ŋkamuʼɔŋ nchhu ni pugu ŋa, “Njəɨ, ǹtaoŋ nu ni ju mbhi mfɛ ni pəɨ nnɛ ŋa pəɨ ji ŋa ǹdɔ njiʼi njəɨ sheshe fàŋ ŋa a chwīe.” ");
INSERT INTO bmo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nɛnnɛ Jishɔ taoŋ mbhi ni ŋkie minduandua thɔ yu ni pɨ̀rɨ mbɨŋ yu. Pailɛ chhu ni pugu ŋa, “Pəɨ līi njəɨ, ŋoŋ ghɔ pɔ nɛiŋ!” ");
INSERT INTO bmo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa ghaŋ kɛ̄ʼi Nda Minnwi ni ŋga njəɨ vi, mbaʼo ŋgòu ni njɨ ŋa, “Kwīŋ vi ŋkuoŋ wáʼa, kwīŋ vi ŋkuoŋ wáʼa!” Pailɛ chhu ni pugu ŋa, “Pəɨ lɔ̄gɔ vi ni noŋ yəɨ ŋkwiŋ vi ŋkuoŋ wáʼa nthɛ ŋa ǹdɔ njiʼi njəɨ sheshe nnu ŋa a fāaŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pa ŋgwa Juu khwɛ̄ ghɔ ŋa, “Pigi fāʼo gɨ́, ŋkwaŋ haʼaŋ gɨ́ ghɔ chhu nɛ, a nōoŋ ŋa a fāʼo nɔ khu nu nthɛ ŋa a nūʼɔŋ noŋ yi ŋa a Muuŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailɛ ni ŋga njaʼo yei nnu, mbɨnɨ ŋkaa pɔgɔ pɔgɔ mbīgi. ");
INSERT INTO bmo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mbɨnɨ nii moŋ ntuʼɔ mbie Jishɔ ŋa, “Ɔ llɔ pi hɨŋ?” Ndɔ paʼa Jishɔ lɔ ŋkhwɛ̄. ");
INSERT INTO bmo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nnɛ Pailɛ chhu ghɔ ŋa, “Ɔ lɔ ntāʼa nu nchrā vəɨ, ɔ lɔ nji ŋa m̀fāʼo ghrɨ́ nɔ chuʼɔ nu ghɔ, mfāʼo ghrɨ́ nɔ kwīŋ nu ghɔ ŋkuoŋ wáʼa?” ");
INSERT INTO bmo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jishɔ khwɛ̄ ghɔ ŋa, “Ɔ fāʼo ghrɨ́ mbɨŋ mu ŋguʼɔ nthɛ pi ŋa a fɛ Minnwi vɛ. Nthɛ yie ghɔ, ŋoŋ yɛ ŋa a chaʼa a mfɛ vɛ nɛ fāʼo ju mmɛ phɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jɛ̄ ndɨɨ ghɔ, Pailɛ taʼa pa shɛndaoŋ nɔ chuʼɔ nu vi. Ndɔ pa Juu paʼo ŋgòu ŋa, “Ɔ̈ nchuʼɔ vi, kaŋ ɔ lɔ mbɔ taannu Kaisha. Shesheŋoŋ ŋa a nūʼɔŋ noŋ yi ŋa a fùoŋ nɛ tɨnɨ pi thɔ ni Kaisha.” ");
INSERT INTO bmo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nnɛ ndɨɨ ŋa Pailɛ ni njaʼo yei chrà nɛ, a lɔ̄gɔ Jishɔ ntaoŋ nɔ mbhi, nchɔchhɔ ŋkuoŋ faaŋ sháʼa yi nɔ lɨʼɨ ŋa pi mɛ̄iŋ ni lɨʼɨ nūʼɔŋ ni ŋgùʼɔ nɛ (mbɔ moŋ chrà Hibru ŋa Gabata). ");
INSERT INTO bmo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A ni mbɔ llɛ́ pīri nu noŋ nɔ jɨ nu Lli Njiʼa. A ni mbɔ moŋ ntuŋ minaoŋ. Pailɛ chhu ni pa Juu ŋa, “Pəɨ līi njəɨ, fùoŋ vəɨ pɔ nɛiŋ!” ");
INSERT INTO bmo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pugu paʼo ŋgòu ni njɨ ŋa, “Jwi vi jwi, kwīŋ vi ŋkuoŋ wáʼa!” Pailɛ pie vugu ŋa, “Ŋ̀kwīŋ fùoŋ vəɨ ŋkuoŋ wáʼa?” Pa thishɨ ghaŋ fɛʼiŋgiɛŋ khwɛ̄ ŋa, “Pigi lɔ njiʼi mfāʼo yichəɨ fùoŋ ŋkiɛŋ Kaisha.” ");
INSERT INTO bmo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nnɛ, a chaʼa vi mfɛ ni pugu ŋa pi kwīŋ vi ŋkuoŋ wáʼa. Nnɛ pugu lɔ̄gɔ Jishɔ, ");
INSERT INTO bmo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","a taoŋ mbhi ntiɛŋ wáʼa yi ŋgə̄ɨ nu nɔ lɨʼɨ ŋa pi mɛ̄iŋ ŋa Lɨʼɨ Kwéi Thɔ, ŋa pi mɛ̄iŋ moŋ chrà Hibru ŋa Gogota nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pugu kwīŋ vi fɔ ŋkuoŋ wáʼa pugu pa pichəɨ paa ŋgwa, taʼa yi nɔ sheshe ŋgei mbhɔ yi, Jishɔ pɔ titri pugu. ");
INSERT INTO bmo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailɛ nāʼaŋ yaoŋ ŋkwiŋ ŋkuoŋ wáʼa yi. Yaoŋ ghɔ ni mbɔ ŋa, “Jishɔ lɔ Nasharɛ, mbɔ Fùoŋ pa Juu.” ");
INSERT INTO bmo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ntou pa ŋgwa Juu ni mɛ̄iŋ yaoŋ yei, nthɛ ŋa lɨʼɨ ŋa pi ni ŋkwīŋ Jishɔ nɛ ni mbara moŋ laʼa ndɔ pi ni nāʼaŋ moŋ chrà Hibru ni chrà Latiŋ ni chrà Gri. ");
INSERT INTO bmo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nnɛ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pa Juu chhu ni Pailɛ ŋa, “Kiʼi nāʼaŋ ŋa, ‘Fùoŋ pa Juu,’ ka nāʼaŋ pi ŋa, ‘Ŋoŋ vei ni nchhu ŋa, A mmu mbɔ Fùoŋ pa Juu.’ ” ");
INSERT INTO bmo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailɛ khwɛ̄ ŋa, “Yaoŋ ŋa ŋ̀kwo nāʼaŋ nɛ, ŋ̀kwo nāʼaŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pa shoogɛ ni ŋga ŋkwīŋ Jishɔ ŋkuoŋ wáʼa, ndɔ̄gɔ mmɛ ndhwí fɨgəɨ yi nshāa a taoŋ khwɛ lɨʼɨ, sheshe taʼa shoogɛ fāʼo taʼa pra yi. Mbɨnɨ ndɔ̄gɔ ndhwí ŋa a ni māʼaŋ moŋ ghɔ nɛ, paʼa lɨʼɨ yōu lɔ mbɔ ŋkuoŋ ghɔ, pi ni ntuŋ a pɔ pi taʼa pra yi llɔ thɔ ghɔ nshwiʼi fɛ nɔ laʼo yi. ");
INSERT INTO bmo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nɛnnɛ pugu chhu ni noŋ pugu ŋa, “Kiʼi pia shāa, pia ka māʼaŋ pi yaoŋ nɔ yəɨ nu ŋa a shi mbɔ yi gɔ̌?” Yei ni mbɔ nɔ chwīe nu Ŋwaʼaŋlɨ Minnwi lɔ̄gɔ lɨʼɨ ŋa a chhu ŋa, “Pugu ni ŋgrā mmɛ ndhwí fɨgəɨ a shɨna pugu, māʼaŋ yaoŋ shhɛ nɔ jɨ nu muuŋ ndhwí a,” nnɛ pa shoogɛ pighɔ chwīe nnu pei. ");
INSERT INTO bmo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ndɔ mǔuŋ Jishɔ pugu ndǐŋ mǔuŋ vi, ni Meri ŋgwɛ Klopa, Meri Madaliŋ ni nthi fɔ yəɨ wáʼa Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jishɔ ni ŋga njəɨ mǔuŋ vi, pugu ŋgaŋ younjiŋ yi yɛ ŋa ju Jishɔ ni ŋkhwā vi nɛ thi fɔ. A chhu ni mǔuŋ vi ŋa, “Ma, līi njəɨ, a muuŋ ghɔ!” ");
INSERT INTO bmo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nnɛ nchhu ni ŋgaŋ younjiŋ yi ghɔ ŋa, “A mǔuŋ ghɔ.” Jɛ̄ ndɨɨ ghɔ ŋgaŋ younjiŋ yi ghɔ lɔ̄gɔ vi ŋgə̄ɨ nɔ nda yu. ");
INSERT INTO bmo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jishɔ ni nji ndwɛ ŋa ŋguoŋ nnu kwo mmɛ, nchhu ŋa (nɔ chwīe nu chrà Minnwi pɔ nnu shini), “Njùʼɔ a yaoŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mikei làʼo chəchɨgəɨ ni nthi fɔ, nnɛ pugu lɔ̄gɔ kusha nchru moŋ làʼo ghɔ, nshhɔ̄ thɔ muuŋ thɨ ŋa pi mɛ̄iŋ ni haisho nɛ, ŋkə̄rə nūʼɔŋ nɔ nchò yi. ");
INSERT INTO bmo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jishɔ gha nnu làʼo chəchɨgəɨ ghɔ, nchhu ŋa, “A mmɛ nɛ!” Ntuʼu thɔ yi shhɛ Jijwɛ yi taoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nthɛ ŋa a ni mbɔ Llɛ́ pīri nu noŋ nɛ, nɔ yəɨ nu ŋa khu yugu lɔ ŋkɨna ŋkuoŋ wáʼa llɛ́ Ji (mbɔ ŋkiɛŋ mmɛ Llɛ́ Ji nthɛ ŋa a ni mbɔ Llɛ́ jɨ Lli Njiʼa) nɛ, pa Juu pie Pailɛ ŋa pi pəʼɨ kwò muŋu, nshwiʼi khu yugu ŋkuoŋ wáʼa. ");
INSERT INTO bmo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nnɛ pa shoogɛ thɔ mbəʼɨ kwò fǔoŋ yi pugu vichəɨ ŋa pi ni ŋkwīŋ vugu pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pugu ni ŋga nchəɨŋ mbɨŋ Jishɔ, njəɨ ŋa a kwo khu, paʼa ndɔ nuʼuŋ mbəʼɨ kwò yi. ");
INSERT INTO bmo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ndɔ taʼa ŋoŋ shɨna pa shoogɛ pighɔ chwɛ̄ʼi mbru yi ni khwǎ, chhǐ pugu pa ŋkhǐ taoŋ wuʼɔ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ŋoŋ ŋa a ni njəɨ nnu yei lɔ̄gɔ lɨʼɨ nɛ ni nchrā nthɛ nnu ghɔ, nnɛ ŋa pəɨ ŋkaa pəɨ nthɛ pəɨ piŋ. Nnu ŋa a ni nchhu nɛ nnu shini, a ji ŋa a chrā pi nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pa nnu pei ni ndɔ̄gɔ lɨʼɨ ŋa chrà Minnwi pɔ yi nnu shini ŋa: “Mbaʼa pi yiʼi mbəʼɨ kaŋ taʼa kwéi yi.” ");
INSERT INTO bmo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yichəɨ lɨʼɨ moŋ Ŋwaʼaŋlɨ Minnwi pɨnɨ nchhu ŋa, “Pugu shi ndīi ŋoŋ ŋa pugu chwɛ̄ʼi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pa nnu pei ni ŋga ntɔgɔ, Joshɛ llɔ Arimatia, ŋa a ni mbɔ taʼa ŋgaŋ younjiŋ Jishɔ moŋ njiŋ nthɛ ŋa a ni mbɔgɔ pa Juu nɛ, luoŋ ni Pailɛ ŋa a lɔ̄gɔ khu Jishɔ. Pailɛ piŋ ŋa a lɔ̄gɔ. Nnɛ a thɔ ndɔ̄gɔ khu Jishɔ ŋgə̄ɨ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemu ŋkaa yu, ŋa a ni ŋkwo fǔoŋ nthɔ njəɨ Jishɔ ni tuʼu nɛ, thɔ ni laminda ŋa pi nyaŋ ni yichəɨ yaoŋ ŋa pi mɛ̄iŋ ni məə pugu aloe nɛ, a pou yaoŋ mbɔ ghrà kilu. ");
INSERT INTO bmo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nnɛ pugu lɔ̄gɔ khu Jishɔ, ndiŋ moŋ mbhɔ ndhwí fhu ni laminda ghɔ nɔ haʼaŋ nùʼɔŋ pa Juu pɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yichəɨ nyìeŋ ni mbɔ moŋ lɨʼɨ ŋa pi ni ŋkwīŋ Jishɔ fɔ ŋkuoŋ wáʼa nɛ, chəɨ fúŋ fhi ŋa pi fīʼi moŋ ŋguʼɔ ni mbɔ fɔ, ŋa pi lɔ naa ma ntwei ŋoŋ fɔ. ");
INSERT INTO bmo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nnɛ nthɛ nnu Pīri nu noŋ pa Juu, ndɔ mbɨnɨ mbɔ ŋa fúŋ ghɔ ni mbɔ fɔ nɛ, pugu twei vi fɔ. ");
INSERT INTO bmo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Moŋ fǔoŋ llɛ́ moŋ shwiʼi taŋ ghɔ mbɔ Shonde ni muuŋ tutuʼu, mbhi wuʼɔ njo shini nu, Meri Madaliŋ ghə̄ɨ chofuŋ njəɨ ŋa pi kwo kə̄nə ŋgùʼɔ chofuŋ ghɔ mbɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nɛnnɛ a tei ŋgə̄ɨ njəɨ Shemu Pita pugu yichəɨ taʼa ŋgaŋ younjiŋ Jishɔ ŋa Jishɔ khwā nɛ, nchhu ni pugu ŋa, “Pi fuʼu khu Taathɔ moŋ fúŋ, paʼa pigi lɔ nji lɨʼɨ yɛ ŋa pi nūʼɔŋ vi nɛ!” ");
INSERT INTO bmo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nnɛ Pita taoŋ mbhi pugu yichəɨ ŋgaŋ younjiŋ Jishɔ ghɔ, ŋgə̄ɨ nu chofuŋ. ");
INSERT INTO bmo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ŋguoŋ vugu pi paa ni ntei nu, ndɔ yichəɨ taʼa ŋgaŋ younjiŋ Jishɔ ghɔ tei mfərə Pita fǔoŋ ju nchəɨŋ chofuŋ. ");
INSERT INTO bmo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A ni ŋga ntuʼu noŋ yi mbɛʼi moŋ fúŋ, njəɨ ndhwí fhu ghɔ nūaŋ fɔ ndɔ paʼa ndɔ nii moŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nɛnnɛ Shemu Pita thɔ mbara vi nii moŋ fúŋ. A ni njəɨ ndhwí fhu ghɔ nūaŋ fɔ, ");
INSERT INTO bmo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","pugu pa ndhwí pūoŋ ligi ŋa a ni mbɔ nɔ thɔ Jishɔ nɛ, paʼa lɔ nūaŋ pi pugu pa ndhwí fhu ghɔ, pi para vi para nūʼɔŋ lɨʼɨ təʼɨ vi. ");
INSERT INTO bmo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nnɛ yichəɨ taʼa ŋgaŋ younjiŋ yɛ ŋa a ni fǔoŋ ju nchəɨŋ chofuŋ nɛ nii moŋ ghɔ ŋkaa yu. Njəɨ ndɔ mbiŋ, ");
INSERT INTO bmo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ndɔ paʼa thɔ yugu lɔ naa nshie ni chrà Minnwi yɛ ŋa a chhu ŋa a shi ŋguʼɔ ŋkuʼɔ moŋ gu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pa ghaŋ younjiŋ Jishɔ pighɔ pɨ̄nɨ laʼa pugu. ");
INSERT INTO bmo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ndɔ Meri tithi chofuŋ ŋkə̄ɨ nu, nɔ haʼaŋ a ni ŋkə̄ɨ nu nɛ, ntuʼu noŋ yi ndīi moŋ fúŋ ");
INSERT INTO bmo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","njəɨ paa ghaŋ ntaoŋ Minnwi, pugu māʼaŋ ndhwí fhu, pugu chhɔ nɔ lɨʼɨ ŋa pi ni nūʼɔŋ khu Jishɔ nɛ, taʼa yi nɔ thɔ yi, taʼa yi nɔ kwò yi. ");
INSERT INTO bmo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pugu pie vi ŋa, “Ma, ɔ kə̄ɨ pi khɔ?” A chhu ni pugu ŋa, “Pi lɔ̄gɔ Taathɔ a ŋgə̄ɨ nɔ ghɔ, ndɔ paʼa ǹdɔ nji lɨʼɨ ŋa pi nūʼɔŋ vi nɛ!” ");
INSERT INTO bmo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A gha ŋkwo chhu yei nnu, ŋkara njəɨ Jishɔ a tithi, ndɔ paʼa a lɔ nji ŋa a Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jishɔ chhu ghɔ ŋa, “Ma, ɔ kə̄ɨ pi khɔ? Ɔ tāʼa pi gɔ̌?” A pīʼi nu ŋa a ŋgaŋ nyìeŋ ghɔ nchhu ghɔ ŋa, “Masha, a mbɔ ŋa ɔ fuʼu vi ŋgə̄ɨ nɔ ghɔ, ɔ shwei a ni lɨʼɨ ŋa ɔ nūʼɔŋ vi nɛ, kaŋ ǹshi ndɔ̄gɔ vi ŋgə̄ɨ nɔ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jishɔ chhu ghɔ ŋa, “Meri.” A kara nchhu ghɔ moŋ chrà Hibru ŋa, “Raboni.” (Njiŋ yi pɔ ŋa Masha.) ");
INSERT INTO bmo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jishɔ chhu ghɔ ŋa, “Kiʼi nuʼuŋ mbaŋ a, nthɛ ŋa ǹdɔ naa ŋkuʼɔ njəɨ Tǎa a yaʼa. Ndɔ ghə̄ɨ njəɨ pa lǐŋ paŋ nchhu ni pugu ŋa ǹchhɔ ŋkuʼɔ nu njəɨ Tǎa a mbɨnɨ mbɔ Tǎa vəɨ, Minnwi a mbɨnɨ mbɔ Minnwi yəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Meri Madaliŋ ghə̄ɨ nchīi ni pa ghaŋ younjiŋ pi ŋa, “Ǹjəɨ Taathɔ!” -pugu pa ŋa a ni nchhu nnu pei ghɔ. ");
INSERT INTO bmo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A ni mbɔ ni fanaoŋ, moŋ fǔoŋ llɛ́ moŋ shwiʼi taŋ ghɔ, pa ghaŋ younjiŋ pi kɨrɨ taʼa lɨʼɨ moŋ nda fɨ̄nɨ nthɛ ŋa pugu ni nthɔ mbɔgɔ pa thishɨ ŋgwa Juu. Jishɔ thɔ nthi shhɨ pugu nchhu ni pugu ŋa, “Ghɨghrɨ pɔ mbɨŋ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A ni ŋga ŋkwo chhu yei, nōoŋ mbhɔ mi pugu pa mbru yi ni pugu. Nnɛ pa ghaŋ younjiŋ pi fāʼo pwanjuʼɔ ndɨɨ ŋa pugu ni njəɨ Taathɔ vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jishɔ pɨnɨ nuʼuŋ nchhu ni pugu ŋkamuʼɔŋ ŋa, “Ghɨghrɨ pɔ mbɨŋ pəɨ. Nɔ haʼaŋ Tǎa taoŋ a nɛ, nɛnnɛ ǹtaoŋ vəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A ni ŋga kwo chhu yei nnu, njwɛ̄ mbɨŋ pugu nchhu ŋa, “Pəɨ kwe Jijwɛ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","P̈əɨ ndīʼɛ phɨ shesheŋoŋ, kaŋ pi liʼɛ. Ti pəɨ mieŋ ki liʼɛ, kaŋ pi lɔ njiʼi ndīʼɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Taʼa paanchrɔ ghɔ, ligi yi pɔ Toma, ŋa pi ni mɛ̄iŋ vi ŋa kəʼɨ nɛ, shini ndɔ mbɔ pugu pugu ndɨɨ ŋa Jishɔ ni nthɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nnɛ pichəɨ ghaŋ younjiŋ Jishɔ shwei vi ŋa, “Pigi yəɨ Taathɔ.” Ndɔ a chhu ni pugu ŋa, “M̈i mieŋ ki lɔ njəɨ chhɨ nthɨ nɔ mbhɔ yi ti niʼiŋ muuŋshɨmbhɔ a nɔ chhɨ nthɨ pighɔ mbɨnɨ nūʼɔŋ mbhɔ a nɔ mbru yi paʼa ǹdɔ ma mbiŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A gha ndaʼa fúoŋ llɛ́, pa ghaŋ younjiŋ pi pɔ moŋ nda ŋkamuʼɔŋ Toma pɔ pugu pugu. Njiʼi nthɛ nɔ haʼaŋ chonda ni mbɔ yi fɨ̄nɨ nɛ, Jishɔ thɔ nthi shɨna pugu nchhu ŋa, “Ghɨghrɨ pɔ mbɨŋ pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nnɛ nchhu ni Toma ŋa, “Niʼiŋ muuŋshɨmbhɔ yɔ hɛiŋ ndɔ ndīi mbhɔ a njəɨ, fɛ mbhɔ yɔ nūʼɔŋ nɔ mbru a. Mieŋ fāʼo nu khuthɔ fɔ, mfāʼo piŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma khwɛ̄ ŋa, “Taathɔ a, ndɔ mbɔ Minnwi a!” ");
INSERT INTO bmo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jishɔ chhu ghɔ ŋa, “Ɔ piŋ nthɛ ŋa ɔ yəɨ a nɛ? Mbɔrɔ yi ŋgwa pɛ ŋa pugu piŋ ndɔ ki lɔ njəɨ yəɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jishɔ ni nōoŋ ntou pichəɨ pa lì shhɨ ghaŋ younjiŋ pi, ŋa pi lɔ nāʼaŋ moŋ ŋwaʼaŋlɨ yei; ");
INSERT INTO bmo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ndɔ pi nāʼaŋ pei nnɛ ŋa mimfɛ pəɨ piŋ ŋa Jishɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, mbɔ Muuŋ Minnwi pugu pa ŋa moŋ piŋ nu mi minthɛ pəɨ fāʼo chɔmbhi. ");
INSERT INTO bmo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pa nnu pei ni ŋga ntɔgɔ, Jishɔ nōoŋ noŋ yi ni pa ghaŋ younjiŋ pi ŋkɨŋ ŋkhǐ Tiberia. Yei ŋkwaŋ haʼaŋ a ni nōoŋ noŋ yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Shemu Pita pugu Toma (ŋa pi ni mɛ̄iŋ vi ni kəʼɨ nɛ), ni Natania llɔ Kanaŋ moŋ Galili mbɔ puoŋ Shebedi, pugu pa pichəɨ paa ghaŋ younjiŋ pi ni mbɔ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Shemu Pita chhu ni pugu ŋa, “Ŋgə̄ɨ pi ŋgunu.” Pugu chhu ghɔ ŋa, “Pia shi ŋgə̄ɨ kaʼa.” Pugu taoŋ ŋgə̄ɨ nii moŋ kikuoŋ, ndɔ ni tuʼu ghɔ paʼa pugu lɔ ŋgwɛ̄iŋ yaoŋ. ");
INSERT INTO bmo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wuʼɔ nɔ haʼaŋ mbhi ni ndaŋ nu nɛ, Jishɔ thi ŋkɨŋ ŋkhǐ. Ndɔ paʼa pa ghaŋ younjiŋ pi lɔ njiʼi nji ŋa a ni mbɔ pi Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jishɔ chhu ni pugu ŋa, “Pa puoŋ paŋ, pəɨ fāʼo sheshe shhu?” Pugu khwɛ̄ ghɔ ŋa, “Ŋga.” ");
INSERT INTO bmo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A chhu ni pugu ŋa, “Pəɨ māʼaŋ ndáŋ nɔ ŋgei mbhɔ jɨ kikuoŋ, kaŋ pəɨ shi ŋgwɛ̄iŋ pichəɨ.” Nɛnnɛ, pugu māʼaŋ, a shini ndɔ njiʼi njiʼɛ nɔ shūu nu ndáŋ ghɔ niʼiŋ moŋ kikuoŋ nthɛ fɨʼɨ shhu ŋa a ni mbɔ moŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yie ŋgaŋ younjiŋ Jishɔ ŋa Jishɔ ni ŋkhwā vi nɛ chhu kiʼɛ ni Pita ŋa, “A Taathɔ!” Shemu Pita ni ŋga njaʼo ŋa a Taathɔ, ndɔ̄gɔ mmɛ ndhwí yi māʼaŋ nthɛ ŋa a ni nshrāo nɔ fāʼa nu fàʼa, a ni ndhi nchəɨŋ ŋkhǐ ntaoŋ nu mbhi. ");
INSERT INTO bmo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pichəɨ ghaŋ younjiŋ nduoŋ taoŋ yugu mbhi pi moŋ kikuoŋ, nthɔ nshūu ndáŋ yɛ ŋa a ni ndɨnaoŋ ni shhu nɛ, nthɛ ŋa lɨʼɨ ŋa pugu ni mbɔ nɛ shini ndɔ nshɨga nɔ nchəɨŋ nu mbhi. A ni mbɔ yaoŋ nɔ taʼa ŋkɨɨ kwo. ");
INSERT INTO bmo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pugu ni ŋga ntaoŋ nchəɨŋ mbhi, njəɨ móŋoŋ ŋa pi frə̄ɨ ni shhu ŋkuoŋ ghɔ pugu pa brɛi. ");
INSERT INTO bmo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jishɔ chhu ni pugu ŋa, “Pəɨ thɔ ni pichəɨ shhu ŋa pəɨ wuʼɔ ŋka wɛ̄iŋ wɛ̄iŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nnɛ Shemu Pita kuʼɔ moŋ pie, nshūu ndáŋ ghɔ ntaoŋ nɔ mbhi, mɛmmɛ shhu lɨnaoŋ moŋ ghɔ. Pa shhu pighɔ ni mbɔ taʼa ŋkɨɨ ni tiɛŋ wuŋ ni ndigi yi trɛi. Njiʼi nthɛ pi nɔ haʼaŋ pa shhu pighɔ ni njiɛŋ, ndáŋ ghɔ shini ndɔ nshāa. ");
INSERT INTO bmo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jishɔ chhu ni pugu ŋa, “Pəɨ thɔ njɨ maoŋ.” Ndɔ paʼa yichəɨ kaŋ taʼa ŋgaŋ younjiŋ yi lɔ mōoŋ mbie vi ŋa, “Ɔ pɔ pi gɔ̌?” Nthɛ ŋa pugu ni nji ŋa a Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jishɔ thɔ ndɔ̄gɔ brɛi ghɔ pugu pa shhu mfɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ndwɛ ni mbɔ ŋgɛ́ yi trɛi ŋa Jishɔ ni nōoŋ noŋ yi ni ghaŋ younjiŋ pi ndɨɨ ŋa a ni ŋkwo kuʼɔ moŋ gu nɛ. ");
INSERT INTO bmo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pugu ni ŋga mīʼɛŋ jɨ nu maoŋ, Jishɔ chhu ni Shemu Pita ŋa, “Shemu, muuŋ Jouŋ, ɔ khwā a nchaa nɔ haʼaŋ pei ŋgwa khwā a nɛ?” A chhu ghɔ ŋa, “Ooŋ, ma Taathɔ, ɔ ji ŋa ŋ̀khwā ghɔ.” Jishɔ chhu ghɔ ŋa, “Kugwi puoŋ minjɨɨ paŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","A pɨnɨ nuʼuŋ nchhu ghɔ mbra ŋgɛ́ ŋa, “Shemu, muuŋ Jouŋ, ɔ khwā a?” A chhu ghɔ ŋa, “Ooŋ, ma Taathɔ, ɔ ji ŋa ŋ̀khwā ghɔ.” Jishɔ chhu ghɔ ŋa, “Kɛ̄ʼi minjɨɨ paŋ.” ");
INSERT INTO bmo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A pɨnɨ nchhu ghɔ a pɔ trɛi ŋgɛ́ ŋa, “Shemu, muuŋ Jouŋ, ɔ khwā a?” Njùʼɔ Pita pəʼɨ nthɛ ŋa a chhu ghɔ a pɔ trɛi ŋgɛ́ ŋa, “Ɔ khwā a?” A chhu ghɔ ŋa, “Taathɔ, ɔ ji ŋguoŋ nnu ghao, ɔ ji ŋa ŋ̀khwā ghɔ.” Jishɔ chhu ghɔ ŋa, “Kugwi minjɨɨ paŋ. ");
INSERT INTO bmo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Shishini, ǹchhu vɛ ŋa, ndɨɨ ŋa ɔ ni mbɔ mikəʼɨ nɛ, ɔ ni nthɔ māʼaŋ ndhwí yɔ ŋgə̄ɨ sheshe lɨʼɨ ŋa ɔ tāʼa nu nɛ. Ndɔ ndɨɨ ŋa ɔ lūnu nɛ, ɔ shwīi mbhɔ yɔ ŋoŋ nduoŋ māʼaŋ ndhwí yɔ, ndɔ̄gɔ ghɔ ŋgə̄ɨ nɔ lɨʼɨ ŋa ɔ lɔ ntāʼa nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(A ni nchhu yei nɔ nōoŋ nu ŋkwaŋ gu ŋa a shi ŋkhu nɔ ghaʼo nu Minnwi nɛ.) Jishɔ ni ŋga nchhu yei mīʼɛŋ nchhu ŋa, “Yōu njiŋ a.” ");
INSERT INTO bmo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita kara ligi yi njəɨ yɛ taʼa ŋgaŋ younjiŋ ŋa Jishɔ ni ŋkhwā nɛ thɔ nu njiŋ pugu. Mbɔ yɛ ŋa a ni nchhɔ njɨ maoŋ yəɨ yu ŋkuoŋ taprɛi, ni nchhu ŋa, “Taathɔ, a gɔ̌ ŋa a shi fīni ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ni ŋga njəɨ vi, nchhu ni Jishɔ ŋa, “Taathɔ, ti ŋoŋ vei nɛ?” ");
INSERT INTO bmo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jishɔ khwɛ̄ ghɔ ŋa, “M̈i ntāʼa nu ŋa a kɨna yi maoŋ ti ǹshi nuʼuŋ mbɨnɨ, ɔ fɛ̄ʼi khɔ yɔ nɔ ghɔ? Ndɔ ni gɔ̀, thɔ njōu njiŋ a!” ");
INSERT INTO bmo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nnɛ pa chrà nyīeŋ nu shɨna pa lǐŋ ŋa, mbaʼa taʼa ŋgaŋ younjiŋ yi vei khu. Ndɔ ti Jishɔ shini ndɔ nchhu ŋa mbaʼa a yiʼi ŋkhu. A ni nchhu pi ŋa, “M̈i ŋkhwā ŋa a kɨna yi maoŋ ti ǹshi nuʼuŋ nthɔ ɔ fɛ̄ʼi khɔ yɔ nɔ?” ");
INSERT INTO bmo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yei ni mbɔ ŋgaŋ younjiŋ Jishɔ yɛ ŋa a thɔ nchhu nnu pei nɛ, ndɔ nāʼaŋ nnu pei nɛ, ndɔ pia ji ŋa nnu ŋa a chhu nɛ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ntou pa pichəɨ nnu ni mbɔ fɔ ŋa Jishɔ ni nchwīe. A kaŋ mbɔ ŋa pi nāʼaŋ pa nnu pighɔ pa taʼa taʼa, paʼa ŋkuoŋ mbhi lɔ mfāʼo lɨʼɨ nūʼɔŋ ŋwaʼaŋlɨ yɛ ŋa pi shi nāʼaŋ moŋ ghɔ nɛ.");
INSERT INTO bmo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Moŋ fǔoŋ ŋwaʼaŋlɨ, ma Tiofilu, ŋki nāʼaŋ ŋguoŋ pa nnu ŋa Jishɔ ni nchwīe ndɔ ntɨgɨ nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ti ŋgə̄ɨ nchəɨŋ ndɨɨ ŋa Minnwi ki lɔ̄gɔ vi ŋkuʼɔ nɔ po nɛ. Ŋkaoŋ pi maa ŋkuʼɔ ni ju po, moŋ njɨ Jijwɛ Minnwi, a fɛ gɨ́ ni pa ghaŋ ntaoŋ pi ŋa a ni nchuʼɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A ni ŋga ŋkwo yəɨ ŋgəʼɨ ti ŋkhu ŋkuʼɔ moŋ gu, nōoŋ noŋ yi ni pugu nɔ khwɛ wuŋ llɛmbhi ntou ndɨɨ moŋ pa shɛndaoŋ ŋa a ni nōoŋ ki khuthɔ lɔ mbɔ ŋa a yi maoŋ. Pugu ni njəɨ vi, a chrà ni pugu nthɛ Shaʼafuoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pugu pugu ni ŋga mbɔ taʼa lɨʼɨ, a fɛ gɨ́ ni pugu ŋa, “Kiʼi pəɨ lɔllɔ Jerushalɛiŋ, pəɨ kɨna fɔ njwɛrɛ fɛ́ yɛ ŋa ŋki shwei vəɨ nɔ nɛ, fɛ́ ŋa Tǎa a ni ŋkāʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kwe ŋkhǐ Jouŋ ni mbɔ pi yi moŋ ŋkhǐ, ndɔ nɔ kuo ndɨɨ, pəɨ shi mfāʼo kwe ŋkhǐ moŋ Jijwɛ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pa ghaŋ ntaoŋ Jishɔ ni ŋga mbɔ taʼa lɨʼɨ pugu pa Jishɔ, pugu pie vi ŋa, “Taathɔ, ɔ shi nduʼu shaʼafuoŋ ndwɛ mbhɔ Ishrae?” ");
INSERT INTO bmo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jishɔ khwɛ̄ ni pugu ŋa, “Pəɨ lɔ mfāʼo nɔ ji nu ndɨɨ ki llɛ́ ŋa Tǎa nūʼɔŋ pi ni ji njɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ndɔ pəɨ shi mfāʼo ghrɨ́ ndɨɨ ŋa Jijwɛ Minnwi shwiʼi mbɨŋ pəɨ nɛ. Pəɨ shi mbɔ pa miŋkwentie paŋ llɔ Jerushalɛiŋ, pugu pa moŋ Judia ni Shamaria, ti ŋgə̄ɨ nchəɨŋ moŋ ndugwi mbhi.” ");
INSERT INTO bmo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A ni ŋga mīʼɛŋ chhu nu nnu pei, Minnwi lɔ̄gɔ vi ŋkuʼɔ ni ju po, ti a nuʼuŋ mbhɛ ligi pugu moŋ lúluŋ. ");
INSERT INTO bmo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nɔ haʼaŋ pugu ni ŋguʼɔ mbɛʼi po nɔ haʼaŋ a ni ŋgə̄ɨ nu nɛ, ŋga njəɨ nu, paa ŋgwa thi yəɨ pugu moŋ ndhwí fhu, ");
INSERT INTO bmo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","nchhu ni pugu ŋa, “Ŋgwa Galili, pəɨ thi hɛiŋ mbɛʼi pi khɔ po? Jishɔ vei ŋa pi lɔ̄gɔ vi ligi pəɨ ŋkuʼɔ nɔ po nɛ, shi ndɛ mbɨnɨ wuʼɔ nɔ haʼaŋ pəɨ nuʼuŋ njəɨ vi a ghə̄ɨ po nɛ!” ");
INSERT INTO bmo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pa ghaŋ ntaoŋ Jishɔ pɨ̄nɨ Jerushalɛiŋ lɔ ŋkuoŋ mbra ŋa pi mɛ̄iŋ ni Olive nɛ, mbɔ nɔ taʼa ŋkaŋ kwò llɔ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pugu ni ŋga nii fɔ, ŋkuʼɔ moŋ njiɛŋ nda tɔthɨ lɨʼɨ haʼaŋ pugu ni ndaʼa nu nɛ. Pugu ni mbɔ: Pita ni Jouŋ ni Jɛiŋ ni Andru, Fili pugu Toma, Batolomiu pugu Matio, Jɛiŋ muuŋ Afioshi ni Shemu, mbɔ kwìni laʼa, ni Judashi, mbɔ muuŋ Jɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ŋguoŋ pa ghaŋ ntaoŋ Jishɔ pei ni mbɔ ni taʼaŋggi nthɔ nduoŋ Minnwi pugu pa pichəɨ piŋgɛ ŋa pugu ni ŋgɛ̄rɛ Jishɔ nɛ, ni Meri mǔuŋ Jishɔ pugu pa lǐŋ pi pi pimbia. ");
INSERT INTO bmo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Moŋ llɛ́ pighɔ Pita lɔllɔ ntithi shɨna taʼa ŋkɨɨ ni pa wuŋ ghaŋ piŋ, nchhu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Lǐŋ paŋ! A ni mbie ŋa nchò Ŋwaʼaŋlɨ Minnwi chəɨŋ ŋkwaŋ haʼaŋ Jijwɛ Minnwi ni ŋkāoŋ Devi a nāʼaŋ nthɛ Judashi ŋa a ni ŋgə̄ɨ nōoŋ Jishɔ ni ŋgwa pɛ ŋa pugu ni nthɔ nu ŋgwɛ̄iŋ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judashi ni mbɔ taʼa ŋoŋ via, nthɛ ŋa pi ni nchuʼɔ vi ŋkaa yu ŋa a fāʼa pia pugu.” ");
INSERT INTO bmo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","A ni njuoŋ shhɛ ni pe ŋa pi ni mfɛ ghɔ nthɛ mbha nnu pɨphɨ yi nɛ, ndhɔ tɔthɨ ŋgū mfūŋ ni thɔ yi, nshɨna titri, maoŋ puŋ pi taoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ŋguoŋ ŋgwa Jerushalɛiŋ ni njaʼo nnu ghɔ, nɛnnɛ mɛ̄iŋ shhɛ ghɔ moŋ chrà laʼa yugu ŋa Hakɛldama njiŋ yi pɔ ŋa, “Shhɛ Chhǐ.” ");
INSERT INTO bmo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita chhu ŋa, “Nthɛ ŋa pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Ŋkhǐ ŋa, ‘Nda yi kuʼɔ fùŋ. Kiʼi ŋoŋ ma ndaʼa fɔ.’ Pi pɨnɨ nāʼaŋ ŋa, ‘Ŋoŋ nduoŋ lɔ̄gɔ lɨʼɨ yi.’ ");
INSERT INTO bmo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nnɛ, a pie ŋa pia chuʼɔ taʼa ŋoŋ mbīgi mbɨŋ pia, mbɔ ŋoŋ ŋa a ni mbɔ pia pugu jɛ̄ ndɨɨ ŋa pia pa Jishɔ Taathɔ ni nyīeŋ nu kaʼa nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","mbɔ ŋoŋ ŋa pia pugu ni mbɔ jɛ̄ ndɨɨ ŋa Jouŋ ni nthɔ mfɛ ŋkhǐ ni ŋgwa nɛ, ti ŋgə̄ɨ nchəɨŋ ndɨɨ ŋa Minnwi ni mfuʼu Jishɔ ghɔ shɨna pia ŋkuʼɔ nɔ po nɛ. Pia pa ŋoŋ vei pɔ pa ghaŋ kwentie ŋa Jishɔ ni mbɨnɨ ŋkuʼɔ moŋ gu.” ");
INSERT INTO bmo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nnɛ pugu tɛrɛ Joshɛ, mbɔ Bashaba ŋa pi ni mɛ̄iŋ vi ni Jushitu nɛ, mbɨnɨ ntɛrɛ Matia. ");
INSERT INTO bmo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nduoŋ Minnwi nchhu ŋa, “Taathɔ, ɔ ji njùʼɔ shesheŋoŋ. Nōoŋ yɛ ŋoŋ ŋa ɔ chuʼɔ shɨna paa ŋgwa pei nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ŋa a lɔ̄gɔ fàʼa Judashi nɔ ŋgaŋ ntaoŋ Jishɔ ŋa a ni ŋkhu mieŋ ŋgə̄ɨ lɨʼɨ ŋa a ni mbie ŋa a ghə̄ɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pugu māʼaŋ yaoŋ nɔ ji nu ŋoŋ ŋa Minnwi chuʼɔ nɛ, a gū mbɨŋ Matia, nnɛ pugu pigi vi mbɨŋ pa taʼanchrɔ *ghaŋ ntaoŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Llɛ́ jɨ ŋa pi mɛ̄iŋ ni Pentekɔ nɛ ni ŋga nthɔ, ŋguoŋ pa ghaŋ piŋ kɨrɨ taʼa lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","A gha ndara yichəɨ yɔ̀yɔnɔ llɔ po mbɔ nɔ ŋggì ŋkiɛŋ mmɛ fiŋ, nthɔ ndɨnaoŋ ŋguoŋ nda ŋa pa ghaŋ piŋ pighɔ ni nchhɔ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pugu ni njəɨ pa yaoŋ ŋa a ni mbɔ nɔ pa lɨŋ móŋoŋ, pugu taoŋ nshɛrɛ noŋ yugu nthi mbɨŋ sheshe taʼa ŋoŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pugu ni ndɨnaoŋ ni Jijwɛ Minnwi, njɛ̄ chrà nu moŋ pa ŋkwaŋ chrà taoŋ nduoŋ nɔ haʼaŋ Jijwɛ ghɔ ni nchuʼɔ nchò yugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Moŋ pɨɨ ndɨɨ ghɔ, pa ŋgwa Juu ŋa pugu ni mfāʼo pɔgɔ Minnwi nɛ ni ndaʼa nu Jerushalɛiŋ llɔ moŋ ŋguoŋ mbhi ghao. ");
INSERT INTO bmo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pugu ni ŋga njaʼo yɔ̀yɔnɔ ghɔ, yú ŋgwa kɨrɨ, ŋgrāo nthɛ ŋa shesheŋoŋ ni njaʼo pugu chrā pi chrà laʼa yugu. ");
INSERT INTO bmo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pugu ni ŋgrāo ti a ghaʼa mbie ŋa, “Ŋguoŋ ŋgwa pei ŋa pugu chrà nu nɛ lɔ mbɔ pi ŋgwa Galili? ");
INSERT INTO bmo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ti a kie pi nɛiŋ pia yaʼo nnu ŋa pugu chhu nu nɛ pi moŋ yia chrà laʼa? ");
INSERT INTO bmo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pia llɔ pi Patia, Media ni Elaŋ, pugu pa ŋgwa llɔ Meshopotemia, Judia, ni Kapadoshia, pugu pa ŋgwa llɔ Pontu ni Eshia, ");
INSERT INTO bmo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","pugu pa ŋgwa llɔ Fragia, Pamfilia, Ijipti pugu pa pichəɨ lɨʼɨ Libia yəɨ Shiriŋ. Pichəɨ pia llɔ pi Roma nthɔ ŋkra Jerushalɛiŋ, ");
INSERT INTO bmo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","pichəɨ pɔ ŋgwa Juu, pichəɨ pɔ ŋgwa nduoŋ ŋa pugu piŋ nnu Minnwi pa Juu nɛ. Pichəɨ pia llɔ Krɛtɛ, pichəɨ llɔ Arabia. Ndɔ pia yaʼo pugu chhɔ mfɨ̄ʼɨ ghraoghrao nnu Minnwi moŋ pa chrà laʼa pia.” ");
INSERT INTO bmo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ŋguoŋ yugu ghao ni ŋgrào, ndɔ mbɔ ni fiŋthɔ, nchhu nu ni noŋ pugu ŋa, “Njiŋ yei pɔ pi ŋa?” ");
INSERT INTO bmo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pichəɨ ka māʼaŋ ghaŋ piŋ pighɔ pi ni kwə̀ɨŋ, nchhu nu ŋa, “Pugu paa pi làʼo!” ");
INSERT INTO bmo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nɛnnɛ Pita taoŋ nthɔ shhɨ pugu pa pichəɨ taʼanchrɔ ghaŋ ntaoŋ Jishɔ, ŋkə̄rə ŋggì yi nchhu ŋa, “Ŋgwa Juu pugu pa ŋguoŋ ŋgwa ŋa pugu laʼa nu Jerushalɛiŋ nɛ, pəɨ ywɛrɛ shishiʼi, ǹshwei vəɨ ni njiŋ nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ŋgwa pei lɔ njiʼi mbaa pi làʼo ŋkwaŋ haʼaŋ pəɨ pīʼi nɛ, nthɛ ŋa ndwɛ wuʼɔ ndipuʼu minaoŋ ni tutuʼu. ");
INSERT INTO bmo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yei pɔ pi nnu ŋa njəɨlɨʼɨ Minnwi Joɛ ni nchhu nu nɛ: ");
INSERT INTO bmo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Minnwi chhu ŋa yei nnu ŋa ǹshi nchwīe moŋ pa ndugwi llɛ́ nɛ. Ǹshi nshāʼo Jijwɛ a mbɨŋ shesheŋoŋ. Puoŋ pəɨ pi pimbia pugu pa piŋgɛ shi nchīi ŋkɨ̀nɨ a, pa maʼaŋ mikhwa yəɨ pa nnu, pa lulunu ŋgwa pəɨ fāʼo pa njə̀ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ooŋ, ǹshi nshāʼo Jijwɛ a mbɨŋ puoŋ fàʼa paŋ pi pimbia pugu pa piŋgɛ, moŋ llɛ́ pighɔ, pugu chīi ŋkɨ̀nɨ a. ");
INSERT INTO bmo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ǹshi nchwīe pa nnu ghraoghrao po, nōoŋ pa lì ŋkuoŋ shhɛ. Chhǐ, móŋoŋ, ni gwí ndindhi shi mbɔ. ");
INSERT INTO bmo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Minaoŋ shi ŋkara ŋgū njiŋnjiŋ, fhú kara mbie nɔ chhǐ, ŋkaoŋ ŋkiɛŋ mmɛ llɛ́ Taathɔ maa nthɔ. ");
INSERT INTO bmo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","A shi mbɔ ŋa shesheŋoŋ ŋa a gɛ̄ ligi Taathɔ nɛ shi ndūgu.’ ");
INSERT INTO bmo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ŋgwa Ishrae, pəɨ yaʼo chrà yei! Jishɔ llɔ Nasharɛ, ŋoŋ ŋa Minnwi ni nōoŋ ŋa a taoŋ ju ntaoŋ vi, ŋkie pi ŋkuoŋ pa nnu ghraoghrao pugu pa lì ŋa a ni mfɛ ghrɨ́ ghɔ a chwīe nɔ ghɔ shɨna pəɨ nɔ haʼaŋ pəɨ ŋkaa pəɨ ji nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Minnwi ni ŋkwo ji ndɔ nūʼɔŋ ŋa pi shi kwīŋ vi ŋkuoŋ wáʼa, njwi vi ŋkie pi ŋkuoŋ chaʼa nu vi mfɛ mbhɔ ŋgwa pɨphɨ. ");
INSERT INTO bmo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ndɔ Minnwi pɨʼɨ vi moŋ gu, ŋkwe vi mbhɔ ghrɨ́ gu, nthɛ ŋa a kaŋ ni mfɛ paʼa gu lɔ ŋgwɛ̄iŋ vi a kɨna nɔ ŋgaŋ chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nthɛ ŋa Devi chhu nthɛ vi ŋa, ‘Ǹjəɨ Minnwi Taathɔ shhɨ mu ŋguoŋ ndɨɨ ghao. A pɔ yəɨ mu ŋguoŋ ndɨɨ, nnɛ mbaʼa njiʼi mbɔgɔ nnu ŋa ŋoŋmishua tāʼa nu nchwīe mbɨŋ mu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nthɛ yie ghɔ, ǹdɨnaoŋ ni pwatua, chrà a pɔ chrà pwanjuʼɔ. Nɔ pīgi nu, ŋguoŋ noŋ ghao yɨʼə mbɨŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nthɛ ŋa mbaʼa ɔ yiʼi mieŋ a ŋkɨna yi khu, mbaʼa ɔ yiʼi mieŋ Muuŋ Fàʼa yɔ yi Taoŋtaoŋ fɔ̄rɔ moŋ fúŋ. ");
INSERT INTO bmo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɔ nōoŋ shɛndaoŋ chɔmbhi vəɨ. Ɔ shi nchwīe ndɨnaoŋ ni pwanjuʼɔ nthɛ ŋa pɔgɔ pɔ kaʼa.’ ");
INSERT INTO bmo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Lǐŋ paŋ, minthɛ ǹchhu ni pəɨ ni tɨnɨnjuʼɔ nthɛ fàʼo via Devi. A ni ŋkhu pi twei vi, fúŋ yi pɔ shɨna pia ti nchəɨŋ shiʼa. ");
INSERT INTO bmo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ndɔ, a ni mbɔ njəɨlɨʼɨ Minnwi, nji ŋa Minnwi ni ŋkwo kāʼa vi ti nshwrɛ̄i ŋa a shi nchərə taʼa mbhɛ̌ yaoŋ yi ŋkuoŋ faaŋ ju Devi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Minnwi ni nōoŋ nnu ŋa a shi ndɛ ndɔ̄gɔ lɨʼɨ nɛ ni Devi, nɛnnɛ a chrà ŋkuoŋ khu nu mbɨnɨ ŋkuʼɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, ŋa pi shi ki lɔ mieŋ vi a kɨna yi khu moŋ fúŋ, ki mieŋ a fɔ̄rɔ. ");
INSERT INTO bmo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Minnwi ni mbɨnɨ nuʼuŋ mbɨʼɨ Jishɔ vei moŋ gu, ŋguoŋ yigi pɔ pa miŋkwentie. ");
INSERT INTO bmo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Minnwi Tǎa vi ni ŋkə̄rə vi nchərə ŋgei mbhɔ yi yi jɨ, mfɛ Jijwɛ yi ghɔ ŋkwaŋ nɔ haʼaŋ a ni ŋkāʼa nɛ. Nnu ŋa pəɨ yəɨ nu ndɔ njaʼo nu ndwɛ nɛ pɔ pi fɛ́ yi ŋa a shāʼo mbɨŋ pigi ");
INSERT INTO bmo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","nthɛ ŋa a shini ndɔ ŋkuʼɔ Devi po. Ju, Devi, ka chhu pi ŋa, ‘Taathɔ chhu ni Taathɔ a ŋa, “Chhɔ ŋgei mbhɔ a yi jɨ hɛiŋ ");
INSERT INTO bmo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ti ǹshi nuʼuŋ nchwīe pa mbɨ̌na pɔ pɔ krɨ́ tigi kwò yɔ.” ’ ");
INSERT INTO bmo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nthɛ yie, ŋguoŋ ŋgwa Ishrae fāʼo nɔ ji nu ni tɨnɨnjuʼɔ ŋa Minnwi chwīe vi a pɔ Taathɔ, mbɨnɨ mbɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, mbɔ Jishɔ vei ŋa pəɨ ni ŋkwīŋ vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pugu ni njaʼo nnu pei a kāoŋ njùʼɔ yugu ŋkiɛŋ yie, pugu chhu ni Pita pugu pa pichəɨ ghaŋ ntaoŋ Jishɔ ŋa, “Pa lǐŋ pigi, pigi shi nchwīe pi nɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita chhu ni pugu ŋa, “Pəɨ pāʼa ŋkǔnu yəɨ ni phɨ, ŋkwe ŋkhǐ ni ligi Jishɔ Krishto, Minnwi līʼɛ phɨ yəɨ, mfɛ fɛ́ yi ni pəɨ, mbɔ Jijwɛ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Minnwi kāʼa vəɨ ni kàʼa yei pəɨ pa ŋgwrɛiŋgwa pəɨ, pugu pa ŋgwa pɛ ŋa pugu pɔ fie hini nɛ, ni shesheŋoŋ ŋa Taathɔ, mbɔ Minnwi via, chuʼɔ vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita pɨnɨ ŋgə̄ɨ shhɨ nchrā ntou pa chrà nduoŋ mfra vugu ni njɨ, nchhu nu ŋa, “P̂əɨ kwe noŋ yəɨ nnɛ ŋa kiʼi pəɨ fāʼo ŋgəʼɨ ŋa Minnwi shi mfɛ ni ŋgwrɛiŋoŋ pɨphɨ yei nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nɛnnɛ, ŋgwa haʼaŋ pugu ni mbiŋ chrà yi nɛ ni ŋkwe ŋkhǐ. Taʼa llɛ́ ghɔ, yaoŋ nɔ trɛi ŋkaŋ ŋgwa pigi mbɨŋ ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Pugu ni mfɛ ndɨɨ yugu nthɔ njɛʼi yaoŋ mbhɔ ghaŋ ntaoŋ Jishɔ, ŋkɨrɨ nu ŋguoŋ ndɨɨ ghao ni taʼanjuʼɔ, njɨ pa maoŋ kaʼa mbɨnɨ ndɔ nduoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Minnwi ni ntɔgɔ njiŋ pa ghaŋ ntaoŋ Jishɔ mfāʼa pa nnu ghraoghrao ndɔ nōoŋ pa lì. Nɛnnɛ, shesheŋoŋ fāʼo pɔgɔ gu. ");
INSERT INTO bmo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ŋguoŋ ŋgwa pɛ ŋa pugu ni mbiŋ Minnwi nɛ ghə̄ɨ shhɨ mbɔ nu taʼa lɨʼɨ ni taʼanjuʼɔ, maoŋ pugu pɔ taʼa yi. ");
INSERT INTO bmo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pugu jɛ̄ nthɔ mfīni kiɛŋ shhɛ pugu, pugu pa pichəɨ pa maoŋ, nthɔ ŋgrā mbɨŋ ghɔ ni ŋguoŋ ŋgwa wuʼɔ nɔ haʼaŋ chà yugu nuʼuŋ mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pa lɛllɛ, pugu kɨrɨ nu Nda Minnwi ni taʼaŋggi, njɨ pa maoŋ kaʼa moŋ pa nda nda. Pugu ni njɨ maoŋ pugu ni pwatua pugu pa pwapuŋ, ");
INSERT INTO bmo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ŋgaʼo Minnwi, ŋguoŋ ŋgwa piŋ vugu. Pa lɛllɛ Taathɔ pigi vugu ni pa ŋgwa ŋa a ni ŋkwe vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Llɛ́ chəɨ Pita pugu Jouŋ ni ŋgə̄ɨ nu Nda Minnwi moŋ trɛi minaoŋ ni naoŋchɨ, mbɔ ndɨɨ luoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pi tiɛŋ ŋoŋ chəɨ ŋa pi ni mbhi vi, a taoŋ ŋkwíni llɔ puŋ, ŋgə̄ɨ nu nɔ choŋkaʼa ŋa a ghə̄ɨ Nda Minnwi, pi mɛ̄iŋ ni Pwapwa nɛ. Pi ghà ŋguʼɔ ŋgə̄ɨ ni ju nūʼɔŋ vi lɛllɛ choŋkaʼa ghɔ ŋa a luoŋ ghɛ̀rɛ mbhɔ ŋgwa ŋa pugu ghə̄ɨ nu Nda Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","A gha njəɨ Pita pugu Jouŋ nii nu Nda Minnwi, a jɛ̄ nthɔ nduoŋ ghɛ̀rɛ mbhɔ pugu. ");
INSERT INTO bmo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ndɔ Pita pugu Jouŋ tigi ligi yugu mbɨŋ yu nchhu ŋa, “Līi vigi!” ");
INSERT INTO bmo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A jɛ̄ nthɔ ndīi vugu, mbīʼi nu ŋa a shi mfāʼo yaoŋ mbhɔ pugu. ");
INSERT INTO bmo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ndɔ Pita chhu ŋa, “Ǹdɔ njiʼi mfāʼo dere, ndɔ yaoŋ ŋa m̀fāʼo nɛ ǹshi mfɛ vɛ. Moŋ ligi Jishɔ Krishto llɔ Nasharɛ, lɔllɔ nyieŋ!” ");
INSERT INTO bmo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ŋgwɛ̄iŋ vi nɔ ŋgei mbhɔ yi yi jɨ ŋkə̄rə vi tɔthɨ, wuʼɔ ndɨɨ ghɔ, kwò mi pugu pa mbiʼi kwò mi shwīi. ");
INSERT INTO bmo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A lli ntithi, njɛ̄ nyīeŋ nu. Nii moŋ Nda Minnwi pugu pugu, nyīeŋ nu, ndhi nu, ndɔ ŋgaʼo Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ŋguoŋ pa ŋgwa yəɨ vi nɔ haʼaŋ a nyīeŋ nu nthɔ ntōo Minnwi, ");
INSERT INTO bmo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","nji vi ŋa a ŋoŋ ŋa a ni nchhɔ nduoŋ ghɛ̀rɛ choŋkaʼa yɛ Nda Minnwi ŋa pi mɛ̄iŋ ni Pwapwa nɛ. Wiwini wɛ̄iŋ vugu, pugu ghrāo nnu ŋa a lɔ̄gɔ lɨʼɨ mbɨŋ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nɔ haʼaŋ ŋoŋ ghɔ ni ndia mbɨŋ Pita pugu Jouŋ moŋ lɨʼɨ ŋa pi mɛ̄iŋ ni Varinda Sholomu nɛ, ŋguoŋ ŋgwa ni ŋgrāo ntei nthɔ mbara vugu fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita gha njəɨ ŋgwa pighɔ, nchhu ni pugu ŋa, “Ŋgwa Ishrae, a chwīe khɔ pəɨ ghrāo nnu yei nɛiŋ? A chwīe khɔ pəɨ chaoŋ ligi yəɨ mbɨŋ pigi nɔ haʼaŋ pigi chwīe ŋoŋ vei nyīeŋ pi ni yigi njɨ ki ni yigi pɔgɔ Minnwi? ");
INSERT INTO bmo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Minnwi Abrahaŋ, Aiji ni Jakɔ, mbɔ Minnwi pa ŋkhu tǎa pia, ghaʼo muuŋ fàʼa yi mbɔ Jishɔ, mbɔ ju ŋa pəɨ ni nchaʼa vi mfɛ ni pa thishɨ, ndāa vi shhɨ Pailɛ ndɨɨ ŋa Pailɛ ni ntāʼa nu mieŋ vi ŋa a ghə̄ɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ndɔ pəɨ lāa vi, mbɔ ŋoŋ taoŋtaoŋ ndɔ mbɔ ŋkiɛŋ ŋoŋ, ŋka chhu pi ŋa pi chuʼɔ njwi ŋoŋ mfɛ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pəɨ jwi ŋgaŋ fɛ chɔmbhi, ndɔ Minnwi pɨʼɨ vi moŋ gu, pigi pɔ pa miŋkwentie nnu pei! ");
INSERT INTO bmo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“A tɔgɔ pi ŋkuoŋ piŋ moŋ ligi Jishɔ ŋa ŋoŋ vei pɔ shishiʼi, ŋoŋ vei ŋa pəɨ yəɨ ndɔ nji nɛ. A piŋ moŋ ligi Jishɔ ŋa a chwīe a ya mbɔ shiʼi shhɨ pəɨ ghao. ");
INSERT INTO bmo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ndwɛ, lǐŋ paŋ, ǹji ŋa pəɨ ni nchwīe nnu yei moŋ ki ji, pəɨ pa thishɨ pəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yaoŋ haʼaŋ Minnwi ni nōoŋ ni pa njəɨlɨʼɨ pi fie ma ŋgaʼo pugu chhu nɛ, ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ shi njəɨ ŋgəʼɨ, Minnwi chwīe a lɔ̄gɔ lɨʼɨ wuʼɔ nɛnnɛ. ");
INSERT INTO bmo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nthɛ yie ghɔ, pəɨ pāʼa ŋkǔnu yəɨ ni phɨ mbɨnɨ mbara Minnwi, nnɛ ŋa a līʼɛ phɨ yəɨ. P̈əɨ nchwīe nɛnnɛ, kaŋ māʼaŋ nu ghrɨ́ moŋ jijwɛ yəɨ shi nthɔ ni pəɨ lɔ mbɔ Taathɔ, ");
INSERT INTO bmo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","a lɔ mbɨnɨ ntaoŋ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ, mbɔ Jishɔ ŋa a ni ŋkwo chuʼɔ vi nɛ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","A shi ŋkɨna po ti ndɨɨ nuʼuŋ nthɔ ŋa pi shi nchwīe ŋguoŋ pa nnu pɔ pi fhi nɔ haʼaŋ ju Minnwi ni nchhu ntɔgɔ pi mbhɔ pa njəɨlɨʼɨ pi pi taoŋtaoŋ llɛshhɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mushi ni nchhu ŋa, ‘Minnwi Taathɔ shi nchuʼɔ njəɨlɨʼɨ yi mfɛ ni pəɨ llɔ shɨna pəɨ wuʼɔ nɔ haʼaŋ a ni nchuʼɔ a nɛ. Pəɨ shi nchwīe ŋguoŋ pa nnu ŋa a chhu ŋa pəɨ chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Shesheŋoŋ ŋa mbaʼa a yiʼi njaʼo nchò njəɨlɨʼɨ ghɔ nɛ, pi shi mfuʼu vi shɨna ŋgwa Minnwi, ndɔ nshiʼi vi.’ ");
INSERT INTO bmo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Wuʼɔ nɛnnɛ, ŋguoŋ pa njəɨlɨʼɨ Minnwi llɔ mbɨŋ Shamuɛ ŋgə̄ɨ nu shhɨ ni nchīi pa nnu pei ŋa a thɔ ndɔ̄gɔ lɨʼɨ moŋ llɛ́ pei nɛ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pa kàʼa Minnwi ŋa a ni mfɛ ntɔgɔ pi mbhɔ pa njəɨlɨʼɨ pi nɛ ni mbɔ pi ni pəɨ. Pəɨ fāʼo shɨna moŋ kɨ̀na ŋa Minnwi ni ŋgwrā pugu pa ŋkhu tǎa pəɨ nɛ. A ni nchhu ni Abrahaŋ ŋa, ‘Ntɔgɔ pi mbhɔ mbhɛ̌ yaoŋ yɔ, ǹshi fɛ mbɔrɔ ni ŋguoŋ ndaaŋoŋ ŋkuoŋ shhɛ ghao.’ ");
INSERT INTO bmo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nɛnnɛ, Minnwi chuʼɔ muuŋ fàʼa vi mfǔoŋ ntaoŋ vi pi ni pəɨ, ŋa a fɛ mbɔrɔ ni pəɨ moŋ chwīe nu ŋguoŋ vəɨ ghao ntaoŋ moŋ mbha nnu pɨphɨ.” ");
INSERT INTO bmo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita pugu Jouŋ ni ŋga ŋguʼɔ nchrā nu ni ŋgwa pighɔ nɛ, pa ghaŋ fɛʼiŋgiɛŋ Minnwi pugu pa thishɨ ghaŋ kɛ̄ʼi Nda Minnwi pugu pa ŋgwa Shadushi thɔ mbara vugu, ");
INSERT INTO bmo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","mfāʼo pɨgɨtua ntou yi nthɛ ŋa Pita pugu Jouŋ ni nthɔ njɛʼi ŋgwa ndɔ nchīi nu ŋa Jishɔ ni ŋkhu mbɨnɨ ŋkuʼɔ nōoŋ nu ŋa ŋgwa lɛ ŋkhu mbɨnɨ ŋkuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pugu wɛ̄iŋ Pita pugu Jouŋ niʼiŋ vugu chə́ɨŋ ti mbhi nuʼuŋ ndaŋ nthɛ ŋa tuʼu ni ŋkwo shini nu. ");
INSERT INTO bmo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ndɔ ntou ŋgwa pɛ ŋa pugu ni njaʼo chrà Minnwi nɛ piŋ. Fɨʼɨ pimbia ŋa pugu ni mbiŋ Minnwi nɛ kuʼɔ nchəɨŋ tiɛŋ ŋkaŋ yi. ");
INSERT INTO bmo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mbhi ni ŋga ndaŋ, pa thishɨ pa Juu pugu pa kúŋ, pugu pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi kɨrɨ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anaŋ, mbɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, pugu Kaifa, ni Jouŋ, ni Alɛshanda, ni pa ndaaŋoŋ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, ");
INSERT INTO bmo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","fuʼu pa ghaŋ ntaoŋ Jishɔ pighɔ nthigi shhɨ pugu njɛ̄ tou nu vugu ŋa, “Pəɨ chwīe yei nnu pi ni ghrɨ́ gɔ̌, ki ni ligi gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita, lɨnaoŋ ni Jijwɛ Minnwi, nchhu ni pugu ŋa, “Thishɨ pugu pa kúŋ moŋ laʼa, ");
INSERT INTO bmo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","p̈i nthɔ nshaʼa vigi shiʼa nthɛ pi nnu shiʼi ŋa pigi chwīe mbɨŋ ŋkwíni vei, ŋkwaŋ haʼaŋ a kie ŋkaoŋ maa mbɔ shiʼi nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kaŋ a pie nɛ ŋa ŋguoŋ yəɨ ghao pugu pa ŋguoŋ ŋgwa Ishrae ji ŋa ŋoŋ vei ti shhɨ pəɨ nja mbɔ shishiʼi ntɔgɔ pi ŋkuoŋ njɨ Jishɔ Krishto llɔ Nasharɛ, ŋa pəɨ ni ŋkwīŋ vi ŋkuoŋ wáʼa, Minnwi pɨʼɨ vi llɔ moŋ gu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jishɔ vei, ju ŋa Ŋwaʼaŋlɨ Minnwi chhu nthɛ vi ŋa, ‘Muuŋ nchíʼa yɛ ŋa pəɨ ghaŋ krao nda ni ndāa ŋa a lɔ mfāʼo ghɛ̀rɛ nɛ, pɨnɨ ŋkara ju mbɔ muuŋ nchíʼa kwonda.’ ");
INSERT INTO bmo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Lūgu nu wuʼɔ mbɔ pi mbhɔ yu təʼɨ vi! Moŋ ŋguoŋ mbhi, yichəɨ ŋoŋ lɔ mbɔ fɔ shɨna ŋgwamishua ŋa Minnwi fɛ ŋa minthɛ a kwe via.” ");
INSERT INTO bmo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pa thishɨ pighɔ ni ŋga njəɨ fɨʼɨ tɨnɨnjuʼɔ ŋa Pita pugu Jouŋ fāʼo nɛ, ndɔ nji ŋa pugu lɔ njiʼi nchəɨŋ nthɨŋkwo kəkərə moŋ ŋwaʼaŋlɨ, ŋa pugu wuʼɔ mbɔ pi ŋgwa gha pugu ghrāo, nji kiʼɛ ŋa pugu pa Jishɔ ni mbɔ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ndɔ pugu ni ŋga njəɨ ŋoŋ ŋa pi ni nchwīe vi a pɔ shiʼi nɛ thi yəɨ Pita pugu Jouŋ, paʼa pugu lɔ nuʼuŋ mfāʼo nnu nɔ chhu nu. ");
INSERT INTO bmo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nɛnnɛ, pugu fɛ gɨ́ ni pugu ŋa pugu taoŋ nda pa kúŋ. Nnɛ pugu pini shɨna pugu, ");
INSERT INTO bmo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","nchhu nu ŋa, “Pia shi nchwīe pi nɛiŋ ni ŋgwa pei? Nthɛ ŋa shesheŋoŋ Jerushalɛiŋ ji ŋa mmɛ nnu ghraoghrao yei chwīe pugu. Yichəɨ shɛndaoŋ lɔ mbɔ ŋa mimfɛ pia puoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ndɔ nɔ chwīe nu ŋa kiʼi nnu yei nuʼuŋ nyīeŋ mbīgi ŋgə̄ɨ shhɨ, pia shūu tə́nə yugu ŋa kiʼi pugu nuʼuŋ nchhu sheshe nnu ni ŋoŋ nɔ ligi Jishɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nɛnnɛ, pugu mɛ̄iŋ vugu, mfɛ gɨ́ ni pugu ŋa kiʼi pugu nuʼuŋ nchhu nnu ki ntɨgɨ nɔ ligi Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ndɔ Pita pugu Jouŋ khwɛ̄ ni pugu ŋa, “Pəɨ ŋkaa pəɨ ywɛrɛ ni thɔ yəɨ ŋa a kāʼo yəɨ ligi Minnwi, yaʼo nu nchò yəɨ ki yaʼo nu nchò Minnwi, ");
INSERT INTO bmo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","nthɛ ŋa mimfɛ paʼa pigi lɔ mieŋ shwei nu nnu ŋa pigi yaʼo ndɔ njəɨ ni noŋ yigi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pa thishɨ pugu pa kúŋ pighɔ gha ŋgūru vugu mbīgi ŋa pugu shi mfɛ ŋgəʼɨ ni pugu, mieŋ vugu ŋa pugu ghə̄ɨ. Pugu ni njəɨ ŋa mimfɛ paʼa pugu lɔ mfɛ ŋgəʼɨ ni pugu nthɛ ŋa pa ŋgwa ni nchhɔ ŋgaʼo Minnwi nthɛ nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","nthɛ ŋa ŋoŋ ŋa pi ni nchwīe nnu ghraoghrao yei mbɨŋ yu, noŋ yi mmɛ nɛ, ni ntɔgɔ khwɛ wuŋ ŋgaʼo. ");
INSERT INTO bmo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Wuʼɔ ndɨɨ ghɔ ŋa pi ni nchuʼɔ vugu nɛ, pugu ghə̄ɨ njəɨ ŋgwa pugu, mfɨ̄ʼɨ nnu ŋa pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa thishɨ ni nchhu ni pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ndɨɨ ŋa pugu ni njaʼo nnu pighɔ nɛ, ŋkə̄rə ŋggì yugu tɔthɨ moŋ taʼanjuʼɔ nduoŋ Minnwi. Pugu ni nduoŋ nu ŋa, “Taathɔ ŋa a fāʼo ŋguoŋ njɨ, nchwīe po pugu pa shhɛ ni ŋkhǐ pugu pa ŋguoŋ maoŋ ŋa a pɔ moŋ ghɔ nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ntɔgɔ pi mbhɔ Jijwɛ Minnwi, Ɔ ni nchhu ni ŋkhu tǎa vigi Devi, mbɔ muuŋ fàʼa yɔ ŋa, ‘Pa ŋgwa taoŋ nduoŋ ni ndɨnaoŋ ni pɨgɨtua ŋa, pa ŋgwa Ishrae kāʼa pa nnu pɨphɨ ŋa a lɔ fāʼo ghɛ̀rɛ nɛ nthɛ a ŋa? ");
INSERT INTO bmo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pa fùoŋ ŋkuoŋ mbhi hɛiŋ pugu pa pichəɨ pa thishɨ paoŋ mbīri noŋ pugu nɔ māʼaŋ nu Minnwi Taathɔ pugu *Meshaya yi ŋa a taoŋ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Shishini, Hɛrɔ pugu Pontiu Pailɛ paoŋ moŋ laʼataoŋ yei pugu pa ŋgwa laʼataoŋ nduoŋ ni pa ŋgwa Ishrae nɔ nyiaŋ nu ntáŋ nthɛ muuŋ fàʼa yɔ yi taoŋtaoŋ, mbɔ Jishɔ ŋa ɔ ni nchuʼɔ vi ŋa a pɔ Meshaya nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pugu paoŋ nɔ chwīe nu ŋguoŋ pa nnu haʼaŋ ɔ ni ŋkwo kāʼa nūʼɔŋ ŋa a shi ŋguʼɔ ndɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nɛnnɛ ndwɛ, ma Taathɔ, ywɛrɛ ŋkwaŋ nɔ haʼaŋ pugu kāʼa ŋa pugu shi mfɛ ŋgəʼɨ ni pigi nɛ. Ghɛ̄rɛ vigi mbɔ pa puoŋ fàʼa nɔ chrà nu chrà yɔ ni tɨnɨnjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nɔ haʼaŋ Ɔ chwīe yei nɛ, ghə̄ɨ mbɨʼɨ mbhɔ yɔ njɨ̄gɨ ghɨ̌nɔ nɔ ghɔ, mbɨnɨ nchwīe pa nnu ghraoghrao, ndɔ nōoŋ pa lì pɔ ntɔgɔ pi nɔ ligi muuŋ fàʼa yɔ yi taoŋtaoŋ mbɔ Jishɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pugu ni ŋga nduoŋ Minnwi ti mīʼɛŋ, lɨʼɨ ŋa pugu ni ŋkɨrɨ fɔ nɛ chɨ̄ʼɨ, pugu lɨnaoŋ ni Jijwɛ Minnwi nshwei chrà Minnwi ni tɨnɨnjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pa ghaŋ piŋ ni mfāʼo taʼaŋggi njùʼɔ pugu, pugu pa kwāʼa nu muŋu. Paʼa shesheŋoŋ vugu lɔ nchhu ŋa yaoŋ ŋa a fāʼo nɛ pɔ pi ji təʼɨ vi, yaoŋ yugu ghao pɔ pi taʼa yi. ");
INSERT INTO bmo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ntɔgɔ moŋ njɨ Jijwɛ Minnwi, pa ghaŋ ntaoŋ Jishɔ ni nchīi ni pa ŋgwa ŋa Jishɔ, mbɔ Taathɔ, khu mbɨnɨ nuʼuŋ ŋkuʼɔ, Minnwi nōoŋ ntou pwapuŋ yi ni pugu ghao. ");
INSERT INTO bmo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Taʼa ŋgaŋ chà shini ndɔ mbɔ shɨna pugu, nthɛ ŋa nɔ haʼaŋ ndɨɨ ni ntɔgɔ nu nɛ, pa ŋgwa ŋa pugu ni mfāʼo pa shhɛ ki pa laʼa nɛ fīni, nthɔ ni mbɨŋ ghɔ ŋa pugu fīni nɔ ghɔ nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nūʼɔŋ shhɨ pa ghaŋ ntaoŋ Jishɔ, pugu ghrā ni ŋgwa wuʼɔ nɔ haʼaŋ chà yugu nuʼuŋ mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nnɛ, Joshɛ ŋa pa ghaŋ ntaoŋ Jishɔ ni nthɔ mɛ̄iŋ vi ni Banaba nɛ (njiŋ yi pɔ ŋa “Ŋgaŋ Māʼaŋ Ghrɨ́”), mbɔ ŋoŋ Levi ŋa pi ni mbhi vi Shaipru, ");
INSERT INTO bmo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","fīni nyìeŋ ŋa a ni mfāʼo ndɔ̄gɔ mbɨŋ ghɔ nthɔ nūʼɔŋ shhɨ pa ghaŋ ntaoŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ndɔ ŋoŋ chəɨ ni mbɔ fɔ, ligi yi pɔ Anania. Pugu ŋgwɛ vi, Shafira, ni mfīni yaoŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A lə̄ɨŋ pɨgəɨ mbɨŋ ŋa pugu ni mfīni yaoŋ ghɔ nɔ nɛ, ŋgwɛ vi ji, ŋguʼɔ nthɔ pi ni ghrà yi nūʼɔŋ shhɨ pa ghaŋ ntaoŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ndɔ Pita chhu ŋa, “Anania, a chwīe khɔ ɔ mieŋ Shata nii njùʼɔ ghɔ, ɔ lɛʼiŋgiɛŋ ni Jijwɛ Minnwi, ndə̄ɨŋ pɨgəɨ mbɨŋ ŋa ɔ fīni shhɛ yɔ ghɔ nɔ nɛ? ");
INSERT INTO bmo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndɨɨ ŋa ɔ shini ndɔ naa mfīni nɛ, a lɔɔ mbɔ jɔ? Ndɨɨ ŋa ɔ ni ŋkwo fīni nɛ, a lɔɔ ŋguʼɔ mbɔ jɔ? Ti a chwīe khɔ ɔ pīʼi chwīe nu ŋkwaŋ nnu yei? Ɔ lɔ ndɛʼi ŋgiɛŋ pi ni ŋgwamishua, ɔ lɛʼi pi ni Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania ni ŋga njaʼo nnu yei, ŋgū shhɛ ŋkhu, pɔgɔ gu wɛ̄iŋ ŋguoŋ ŋgwa pɛ ŋa pugu ni njaʼo nnu yei nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pa maʼaŋ mikhwa lɔllɔ ndiŋ vi moŋ ndhwí, ntiɛŋ vi ntaoŋ nɔ mbhi ŋgə̄ɨ ntwei. ");
INSERT INTO bmo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A ni ŋga njo njunu, ŋgwɛ vi nii ndɔ ki lɔ nji nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita chhu ghɔ ŋa, “Shwei a, yei fɨʼɨ mbɨŋ ŋa pəɨ ndaoŋ ghɔ fīni shhɛ ghɔ nɔ nɛ?” A khwɛ̄ ŋa, “Ooŋ, a yie.” ");
INSERT INTO bmo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ndɔ Pita chhu ghɔ ŋa, “A chwīe khɔ pəɨ taaŋ nɔ mōoŋ nu Jijwɛ Taathɔ? Ŋgwa haʼaŋ pugu twei ndaoŋ ghɔ nɛ pɔ nɛ chonda, pugu shi ntiɛŋ ghɔ ntaoŋ nɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wuʼɔ ndɨɨ ghɔ, a gū shhɛ shhɨ yu ŋkhu, pa maʼaŋ mikhwa pighɔ nii njəɨ ŋa a kwo khu. Pugu tiɛŋ vi ntaoŋ nɔ mbhi, ntwei vi yəɨ ndaoŋ vi. ");
INSERT INTO bmo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Pɔgɔ gu wɛ̄iŋ ŋguoŋ ŋgwa moŋ chɔshi ghɔ pugu pa ŋguoŋ ŋgwa ŋa pugu ni njaʼo nnu pei nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pa ghaŋ ntaoŋ Jishɔ ni nōoŋ pa lì ndɔ nchwīe ntou pa nnu ghraoghrao. Ŋguoŋ pa ghaŋ piŋ ni mbɔ moŋ Varinda Sholomu. ");
INSERT INTO bmo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Shesheŋoŋ ŋa a shini ndɔ njiʼi mbɔ ŋgia yugu nɛ shini ndɔ njiʼi mōoŋ nɔ tūru nu pugu pugu njiʼi nthɛ nɔ haʼaŋ pugu ni ndīi vugu nɔ pa ŋkiɛŋ ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ndɔ ntountou ŋgwa haʼaŋ pugu ki piŋ Taathɔ nɛ ka mīʼɛŋ mbīgi pīgi ŋgə̄ɨ shhɨ, mbia pugu pa piŋgɛ. ");
INSERT INTO bmo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nthɛ pa nnu haʼaŋ pa ghaŋ ntaoŋ Jishɔ ni nchwīe nu nɛ, pi tiɛŋ pa ghaŋ ghɨ̌nɔ ntaoŋ nɔ ghɔ nɔ pa shɛndaoŋ, nūʼɔŋ vugu ŋkuoŋ pa kúoŋ pugu pa ŋgrào nnɛ ŋa kəʼɨchəɨ miliʼi Pita gū mbɨŋ pugu nɔ haʼaŋ a ni ntɔgɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ntou yú ŋgwa pɨnɨ ŋkɨrɨ llɔ moŋ pa laʼataoŋ ŋkɨŋ Jerushalɛiŋ nthɔ nu ni pa ghaŋ ghɨ̌nɔ pugu pa ŋgwa pɛ ŋa pa jijwɛ pɨphɨ ni nthɔ ŋgana vugu nɛ, pi yɨ̄gɨ ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ndɔ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pakwo pi, mbɔ pa ŋgwa Shadushi, lɨnaoŋ ni kighɨʼə nthɛ ghaŋ ntaoŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nnɛ pugu wɛ̄iŋ ghaŋ ntaoŋ Jishɔ niʼiŋ moŋ chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ndɔ, a gha mbɔ ni tuʼu, ŋgaŋ ntaoŋ Taathɔ chuʼɔ cho chə́ɨŋ mfuʼu vugu mbhi nchhu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Pəɨ ghə̄ɨ nthi moŋ Nda Minnwi, nshwei ŋguoŋ chrà chɔmbhi fhi yei ni ŋgwa.” ");
INSERT INTO bmo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pa ghaŋ ntaoŋ Jishɔ pighɔ yaʼo nchò yugu, a gha mbɔ ni tutuʼu pugu nii Nda Minnwi njɛ̄ yɛʼi nu. Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ thɔ pugu pa pakwo pi mɛ̄iŋ ŋguoŋ pa thishɨ ŋgwa Juu ghao nnɛ ŋa a nthɛ pugu fāʼo kɨrɨ pa kúŋ. Mfɛ gɨ́ moŋ chə́ɨŋ ŋa pi thɔ ni ghaŋ ntaoŋ Jishɔ lɔ moŋ chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pa shoogɛ gha ŋgə̄ɨ moŋ chə́ɨŋ paʼa ndɔ njəɨ vugu fɔ, mbɨnɨ kiʼɛ mfɨ̄ʼɨ ni pugu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Pigi yəɨ cho chə́ɨŋ pi ya mfɨ̄nɨ shiʼi, pa ghaŋ kɛ̄ʼi pi thi nɔ pa cho pi, ndɔ pigi gha nchuʼɔ, paʼa ndɔ njəɨ ŋoŋ moŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ndɨɨ ŋa mmɛŋoŋ pa shoogɛ ghaŋ kɛ̄ʼi Nda Minnwi pugu pa thishɨ ghaŋ fɛʼiŋgiɛŋ ni njaʼo nnu yei nɛ, pugu ghrāo ŋa a nthɛ yei ŋkwaŋ nnu shi ndugwi pi hɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Yichəɨ ŋoŋ thɔ nchhu ni pugu ŋa, “Pəɨ līi njəɨ! Ŋgwa pɛ ŋa pəɨ ni niʼiŋ chə́ɨŋ nɛ thi Nda Minnwi nthɔ njɛʼi ŋgwa.” ");
INSERT INTO bmo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nnɛ mmɛŋoŋ shoogɛ pugu pa ŋgwa pi ghə̄ɨ nthɔ ni pugu ndɔ ki lɔ nchwīe pi nnu kɨkrɨ nthɛ ŋa pugu ni mbɔgɔ nu ŋa minthɛ pa ŋgwa tuŋ vugu ni ŋgùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pugu ni ŋga nthɔ ni ghaŋ ntaoŋ Jishɔ pighɔ ntigi vugu shhɨ pa kúŋ. Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ tou vugu, ");
INSERT INTO bmo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","nchhu nu ŋa, “Pigi ni ŋkwo ya mfɛ tɨtɨnɨ gɨ́ ni pəɨ ŋa kiʼi pəɨ nuʼuŋ njɛʼi ŋgwa ni ligi ŋoŋ vinɛ ndɔ pəɨ līi njəɨ, pəɨ kwo yɛʼi ŋgwa moŋ Jerushalɛiŋ ŋkwe lɨʼɨ ghao, nthɔ nchwīe nu a pɔ ŋa a jwi pigi njwi vi.” ");
INSERT INTO bmo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ndɔ Pita pugu pa pichəɨ ghaŋ ntaoŋ Jishɔ khwɛ̄ ŋa, “A yiʼi ŋa pigi yaʼo nchò Minnwi nchaa nchò ŋgwamishua. ");
INSERT INTO bmo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Minnwi pa tǎa pia ni mbɨʼɨ Jishɔ llɔ moŋ gu, mbɔ Jishɔ ŋa pəɨ ni ŋkwīŋ vi ŋkuoŋ wáʼa njwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Minnwi kə̄rə vi, nchərə ŋgei mbhɔ yi yi jɨ nɔ Nthishɨ mbɨnɨ mbɔ Ŋkwe, nɔ fɛ nu shɨ̀na ni pa Ishrae nɔ pāʼa nu ŋkǔnu yugu ni phɨ, Minnwi līʼɛ phɨ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Pigi pa miŋkwentie nnu pei, Jijwɛ Minnwi ŋa Minnwi fɛ ni ŋgwa pɛ ŋa pugu yaʼo vi nɛ pɔ yichəɨ.” ");
INSERT INTO bmo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pugu ni ŋga njaʼo yei nnu, a pɨgɨ vugu nshāʼa laʼa muŋu nnɛ pugu tāʼa nu njwi vugu. ");
INSERT INTO bmo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ndɔ yichəɨ taʼa ŋoŋ Farashi shɨna ŋgwa pighɔ, ligi yi pɔ Gamalia, mbɔ ŋgaŋ yɛʼi gɨ́, ŋa ŋgwa līi vi nɔ ŋoŋ chɨɨchɨɨ, lɔllɔ tɔthɨ mfɛ gɨ́ ŋa pi lɔ̄gɔ pa ghaŋ ntaoŋ Jishɔ pighɔ ntaoŋ nɔ mbhi nɔ kuo ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pi gha ntaoŋ ni pugu, a chhu kiʼɛ ni pa kúŋ pighɔ ŋa, “Ŋgwa Ishrae, pəɨ lɨna nu ni nnu haʼaŋ pəɨ chwīe nu mbɨŋ ŋgwa pei nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pəɨ kwiŋ nu ŋa yichəɨ ndɨɨ ni ma mbɔ Tioda taoŋ, nchhu nu ŋa a mmɛŋoŋ ndiɛŋ. Yaoŋ nɔ khwɛ ŋkɨɨ ŋgwa younjiŋ yi. Ndɔ pi ni njwi vi, ŋgwa ŋa pugu ni njōu njiŋ yi nɛ shāaŋ, nnu ŋa a ni nthi nɔ nɛ shāna gha. ");
INSERT INTO bmo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","A ni ŋga ntɔgɔ ji, ŋoŋ chəɨ, ligi yi pɔ Judashi, mbɔ ŋoŋ llɔ Galili moŋ ŋgaʼombhi shia ŋgwa, nuʼuŋ ntaoŋ ji, nshūu ntou ŋgwa pugu younjiŋ yi. Pi jwi vi ŋkaa yu, ghaŋ younjiŋ pi shāaŋ. ");
INSERT INTO bmo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Nnɛ, moŋ yei nnu ŋa a pɔ shhɛ nɛ, kiʼi pəɨ chwīe nnu mbɨŋ ŋgwa pei, p̂əɨ mieŋ vugu təʼɨ vugu. Nnu ŋa pugu kāʼa ndɔ nchwīe nɛ, m̈bɔ ŋa a llɔ pi mbɔ ŋoŋmishua, kaŋ a shi nshāna mmɛ gha. ");
INSERT INTO bmo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ndɔ a ndhɔ pi mbhɔ Minnwi, kaŋ minthɛ, paʼa pəɨ lɔ ŋgaʼa vugu. Pəɨ ka yəɨ noŋ pəɨ ŋgwie ŋkrɔ̀ pi pəɨ pa Minnwi.” Pa kúŋ pighɔ lɔ̄gɔ ntɨ́gɨ Gamalia. ");
INSERT INTO bmo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pugu mɛ̄iŋ ghaŋ ntaoŋ Jishɔ pighɔ, pugu nii nda, pugu wie vugu, mfɛ gɨ́ ni pugu ŋa kiʼi pugu nuʼuŋ nchrā nu ni ligi Jishɔ, nnɛ mieŋ vugu pugu ghə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nɛnnɛ, pa ghaŋ ntaoŋ Jishɔ taoŋ nda pa kúŋ nthɔ mfāʼo pwanjuʼɔ ŋa Minnwi shia vugu shɨna pa ŋgwa ŋa mimfɛ pugu yəɨ ŋgəʼɨ pi shhū vugu nɔ ligi Jishɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ŋguoŋ llɛ́ ghao moŋ Nda Minnwi pugu pa laʼa pa ŋgwa, pugu ghə̄ɨ nchhɔ ntɨgɨ nu ndɔ nchīi nu ŋa, “Jishɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A ni ŋga ndaʼa shɨgɛi pa ghaŋ younjiŋ Jishɔ pigi nu nɛ, fɛ̀ʼi gū shɨna pa ghaŋ piŋ mbɔ ŋgwa Juu pɛ ŋa pi ni mbhi vugu pugu kuʼɔ taoŋ nduoŋ nchrā pi Gri nɛ, pugu pa pɛ ŋa pi ni mbhi vugu pugu kuʼɔ laʼa nchrā pi Hibru nɛ. Pɛ ŋa pugu ni ŋkuʼɔ mbhi nɛ, ni mfɛ̄ʼi nu ŋa pi lɔ ndīi pa kugu pugu shiʼi moŋ nnu ghrā maoŋ lɛllɛ. ");
INSERT INTO bmo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nnɛ paanchrɔ ghaŋ ntaoŋ Jishɔ pighɔ mɛ̄iŋ ŋguoŋ ghaŋ younjiŋ Jishɔ lɨʼɨ muʼɔŋ nchhu ŋa, “A lɔ njiʼi ŋkāʼo ŋa pigi mieŋ chīi nu chrà Minnwi fɔ nthɔ pi lɨʼɨ ghrā maoŋ jɨ. ");
INSERT INTO bmo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nthɛ yie ghɔ, lǐŋ paŋ, pəɨ tɛrɛ khwachəɨ ŋkiɛŋ ŋgwa, ŋa pugu lɨnaoŋ ni Jijwɛ Minnwi pugu pa shiethɔ nɛ, pigi nūʼɔŋ vugu nɔ fàʼa yei. ");
INSERT INTO bmo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pigi shi mfɛ noŋ yigi pi nɔ luoŋ nu Minnwi pugu pa fāʼa chīi nu chrà Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nnu ŋa pugu ni nchhu nɛ pwa ŋguoŋ kɨrɨ ghɔ. Pugu chuʼɔ Shitifiŋ ŋa a ni ntɨnɨ moŋ piŋ ndɔ ndɨnaoŋ ni Jijwɛ Minnwi nɛ, ni Fili, ni Prokoru, ni Nikano, ni Taimoŋ, ni Pamena, ni Nikola lɔ Antiɔ ŋa a ni mbiŋ Minnwi pa Juu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pugu lɔ̄gɔ vugu ŋgə̄ɨ ntigi shhɨ pa ghaŋ ntaoŋ Jishɔ, pugu nūʼɔŋ mbɔ yugu mbɨŋ pugu nduoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nɛnnɛ, chrà Minnwi pɨnɨ nyīeŋ ŋgə̄ɨ shhɨ, fɨʼɨ ghaŋ younjiŋ Jishɔ Jerushalɛiŋ pɨnɨ njiɛŋ mbīgi ŋkiɛŋ yie, pa ntou ghaŋ fɛʼiŋgiɛŋ Minnwi gū ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Shitifiŋ, ŋa mbɔrɔ pugu pa njɨ Minnwi ni ndɨnaoŋ mbɨŋ yu nɛ, chwīe ntou pa nnu ghraoghrao ndɔ nōoŋ pa lì shɨna ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ndɔ pichəɨ ŋgwa ni ndāa vi, mbɔ ŋgwa ŋa pugu ni mbɔ ŋgia ghaŋ nda luoŋ Minnwi ŋa pi ni mɛ̄iŋ ni yi ŋgwa ŋa pugu lɔ nuʼuŋ mbiʼi pa kǔna nɛ, ŋa ŋgwa Juu ni mbɔ moŋ ghɔ llɔ Shiriŋ pugu Alɛshandria, pugu pa pichəɨ Juu nduoŋ llɔ krao ŋgei Shilishia, ni Eshia. Pugu jɛ̄ lōu nu pugu pa Shitifiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ndɔ Jijwɛ Minnwi fɛ shiethɔ ni Shitifiŋ, fɨʼɨ ŋkwaŋ haʼaŋ a ni nchrā nɛ, lāa nu chrà yi ghaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nnɛ, pugu ŋiʼaŋ niʼiŋ puŋ ŋgwa, pugu chhu ŋa, “Pigi yaʼo a chrā chrà nchɨʼəshə nthɛ ligi Mushi pugu Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nnɛ pugu chwīe pa ŋgwa pighɔ, pugu pa thishɨ pugu pa ghaŋ yɛʼi gɨ́ Mushi, pugu wɛ̄iŋ Shitifiŋ ŋgə̄ɨ nɔ shhɨ pa kúŋ, ");
INSERT INTO bmo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ndɔ nthɔ ni pa ŋgwa nchhu ŋa pugu lɛʼiŋgiɛŋ thɔ yu ŋa, “Ŋoŋ vei wuʼɔ nthɔ nchrā pi nnu pɨphɨ nthɛ Nda Minnwi yia yi taoŋtaoŋ pugu pa gɨ́ Mushi, ");
INSERT INTO bmo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","nthɛ ŋa pigi yaʼo a chhu ŋa, ‘Jishɔ vei llɔ Nasharɛ shi nshāʼa Nda Minnwi yei ŋkwri pa nùʼɔŋ ŋa Mushi ni mfɛ ni pia nɛ.’ ” ");
INSERT INTO bmo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ŋguoŋ ŋgwa pɛ ŋa pugu ni mbɔ nda pa kúŋ nɛ chaoŋ ligi yugu mbɨŋ Shitifiŋ ghɔ, njəɨ ŋa miŋi mi pɔ pi nɔ yi ŋgaŋ ntaoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pie Shitifiŋ ŋa, “Yei nnu shini?” ");
INSERT INTO bmo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Shitifiŋ khwɛ̄ ŋa, “Lǐŋ paŋ pugu pa tǎa paŋ, pəɨ ywɛrɛ nnu ŋa ǹchhu nu nɛ. Minnwi ndighaʼo ni nōoŋ noŋ yi ni tǎa via Abrahaŋ ndɨɨ ŋa a ni mbɔ Meshopotemia nɛ ŋkaoŋ a maa ŋgə̄ɨ ndaʼa Haraŋ, ");
INSERT INTO bmo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","nchhu ghɔ ŋa, ‘Taoŋ mieŋ laʼa yəɨ pugu pa ndaaŋoŋ yɔ ŋgə̄ɨ moŋ laʼataoŋ yɛ ŋa ǹshi nōoŋ vɛ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Nnɛ, a taoŋ kiʼɛ laʼa pugu, mbɔ laʼa pa Chadiɛŋ, ŋgə̄ɨ nchhɔ Haraŋ. Tǎa vi ni ŋga ŋkhu, Minnwi fuʼu vi fɔ nthɔ ni ju laʼataoŋ yei ŋa pəɨ chhɔ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Minnwi shi ki lɔ njiʼi mfɛ, njiʼi nthɛ pi muuŋ pra shhɛ ghɔ nɔ ji. Ndɔ Minnwi kāʼa vi kāʼa ŋa a shi mfɛ shhɛ ghɔ a pɔ ji pugu pa ŋgwrɛiŋoŋ yi, njiʼi nthɛ nɔ haʼaŋ a shi ki lɔ mfāʼo muuŋ ndɨɨ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Minnwi ni nchhu ŋa, ‘Ŋgwrɛiŋoŋ yɔ shi ndaʼa nɔ pa ghɨ̀nɨ laʼataoŋ ŋgwa nduoŋ, ŋgū pa kǔna fɔ, pi fɛ ŋgəʼɨ ni pugu nɔ khwɛ ŋkɨɨ ŋgaʼo.’ ");
INSERT INTO bmo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Minnwi pɨnɨ nchhu ŋa, ‘Ndɔ ǹshi nshaʼa ŋgwa pighɔ, ŋa pəɨ shi fāʼa mbhɔ pugu nɔ ŋkǔna nɛ, mfɛ njɔ́ ni pugu, yei gha ntɔgɔ pugu taoŋ laʼataoŋ ghɔ nthɔ ŋgaʼo a shhɛ hɛiŋ.’ ");
INSERT INTO bmo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Minnwi pɨnɨ ŋgwrā kɨ̀na pugu Abrahaŋ ŋa a niʼiŋ pimbia ŋgunu mbrɛi nɔ nōoŋ nu ŋa pugu pɔ pi yi Minnwi ndɔ nshi nchwīe nnu ŋa a chhu ni Abrahaŋ nɛ. Nnɛ, pi ni ŋga mbhi Aiji, a laʼa taʼa taŋ, Abrahaŋ niʼiŋ vi ŋgunu mbrɛi, Aiji niʼiŋ ji muuŋ mbɔ Jakɔ ŋgunu mbrɛi, Jakɔ niʼiŋ paanchrɔ puoŋ pi ŋgunu mbrɛi, mbɔ pa tǎa pia. ");
INSERT INTO bmo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Pa tǎa pia pighɔ fāʼo kɨghɨʼə nthɛ Joshɛ ndǐŋ vugu, mfīni vi laʼataoŋ Ijipti, ndɔ Minnwi pɔ pugu yu kaʼa, ");
INSERT INTO bmo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ŋkwe vi moŋ ŋguoŋ pa ŋgəʼɨŋgəʼɨ pi. Joshɛ ni ŋga ŋgə̄ɨ shhɨ Fɛrɔ, Minnwi chwīe a fāʼo mbha nnu shiʼi ligi Fɛrɔ mbɔ fùoŋ Ijipti, ndɔ mfɛ shiethɔ ghɔ. Fùoŋ chwīe Joshɛ pɔ mmɛŋoŋ nthɔ nshaʼa Ijipti pugu pa ntuʼɔ yi. ");
INSERT INTO bmo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Nnɛ, njì gū moŋ ŋguoŋ Ijipti pugu pa Kanaŋ, njì ghɔ chwīe ŋgwa yəɨ ŋgəʼɨ ntou yi, ti paʼa pa tǎa pia lɔ mfāʼo yaoŋ nɔ jɨ nu. ");
INSERT INTO bmo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jakɔ gha njaʼo ŋa maoŋ jɨ pɔ Ijipti a fǔoŋ ntaoŋ pi pa tǎa pia fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A gha mbɔ moŋ mbra ŋgɛ, Joshɛ chwīe pa lǐŋ pi ji vi, Fɛrɔ ji ndaaŋoŋ Joshɛ kiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Joshɛ māʼaŋ ŋkɨ̀nɨ mɛ̄iŋ Jakɔ tǎa vi, ŋa a thɔ Ijipti pugu pa ŋguoŋ mbaanda yi ghao mbɔ khwachəɨ wuŋ ŋgwa ni yi tiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nɛnnɛ, Jakɔ shwiʼi Ijipti mbɔ lɨʼɨ haʼaŋ a ni ŋkhu pugu pa tǎa pia. ");
INSERT INTO bmo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pi ni ntiɛŋ khu yugu mbɨnɨ nɔ ghɔ Shɛkɛŋ ntwei vugu fɔ moŋ fúŋ ŋa Abrahaŋ ni njuoŋ mbhɔ puoŋ Hamoŋ ni yichəɨ fɨʼɨ mbəʼɨ mbɨŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nɔ haʼaŋ ndɨɨ kàʼa ŋa Minnwi ni ŋkāʼa Abrahaŋ nɔ ghɔ ni nchənə mbara nu nɛ, pa ŋgwa pia pɨnɨ njiɛŋ mbīgi Ijipti. ");
INSERT INTO bmo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ndugwi yi, yichəɨ fùoŋ ŋa a shini ndɔ nji Joshɛ nɛ jɛ̄ nthɔ nshaʼa Ijipti ");
INSERT INTO bmo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A kuʼɔ thɔ pa tǎa pia, nchwīe ŋgəʼɨ mbɨŋ pugu, mfra vugu ŋa pugu nūʼɔŋ puoŋ pugu mbhi, nnɛ ŋa pugu khu. ");
INSERT INTO bmo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“A ni mbɔ pi moŋ yei pɨɨ ndɨɨ ŋa pi ni mbhi Mushi. Mushi ni mbɔ ŋkiɛŋ muuŋ pwapwa. Pi ni nūʼɔŋ vi nda wuʼɔ nɔ trɛi nàoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pi ni ŋga mfuʼu vi nūʼɔŋ mbhi, muuŋ Fɛrɔ yi miŋgwɛ lɔ̄gɔ vi nɔ muuŋ vi ŋkuʼɔ ni ju nɔ muuŋ vi. ");
INSERT INTO bmo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Pi ni njɛʼi Mushi ni ŋguoŋ shiethɔ pa ŋgwa Ijipti. A ni ŋgū ŋkiɛŋ mmɛŋoŋ ndiɛŋ moŋ chrà yi pugu pa nchwīe nu nnu mi. ");
INSERT INTO bmo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“A ni ŋga ŋkwo pɔ khwɛ wuŋ ŋgaʼo, a thɔ njùʼɔ yu ŋa a kra lǐŋ pi mbɔ puoŋ Ishrae. ");
INSERT INTO bmo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A ni ŋga njəɨ ŋoŋ Ijipti thɔ mfɛ ŋgəʼɨ ni muuŋ Ishrae, a ghə̄ɨ lɨʼɨ ghɛ̄rɛ vi njwi ŋoŋ Ijipti ghɔ nɔ luʼu nu ŋgəʼɨ yɛ ŋa a chwīe mbɨŋ vie ŋoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A ni ŋkwāʼa ŋa pa lǐŋ pi shi nji ŋa Minnwi taoŋ vi nɔ kwe nu vugu, ndɔ paʼa pugu lɔ njiʼi nji. ");
INSERT INTO bmo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Mbhi ni ŋga ndaŋ, a yəɨ paa puoŋ Ishrae pugu wie ŋkrɔ̀, a paʼo nu ŋa pugu chīni ŋggì, nchhu ŋa, ‘Lǐŋ paŋ, pəɨ pa lǐŋ, pəɨ wie pi ŋkrɔ̀ khɔ nɛiŋ?’ ");
INSERT INTO bmo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ndɔ yɛ ŋoŋ ŋa a ni nthɔ ŋgwie ndǐŋ vi nɛ tūʼɔ Mushi mfɛ hini, mbie vi ŋa, ‘A nūʼɔŋ gɔ̌ nūʼɔŋ ghɔ ŋa ɔ shaʼa vigi? ");
INSERT INTO bmo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɔ tāʼa nu njwi a ŋkwaŋ nɔ haʼaŋ ɔ ni njwi ŋoŋ Ijipti yua nɛ?’ ");
INSERT INTO bmo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","A ni ŋga ŋkhwɛ̄ nɛiŋ, Mushi tei ŋgə̄ɨ mbɔ ŋgɨ̀nɨ laʼataoŋ Midia, ndaŋ mbhi paa puoŋ pimbia. ");
INSERT INTO bmo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ndwɛ Mushi ni ŋga ŋkwo laʼa Midia nɔ khwɛ wuŋ ŋgaʼo, ŋgaŋ ntaoŋ Minnwi nōoŋ noŋ yi ghɔ nɔ lɨŋ móŋoŋ ŋkɨɨ nu ŋkuoŋ muuŋ thɨ yuyuʼu moŋ ŋkǔnu njó ŋkuoŋ mbra Shinai. ");
INSERT INTO bmo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mushi ni ŋgrāo yaoŋ ŋa a ni njəɨ nɛ, nchənə mbara yəɨ ghɔ nɔ yəɨ nu shiʼi, ŋga mbara njaʼo ŋggì Taathɔ: ");
INSERT INTO bmo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mi Minnwi pa tǎa pɔ, Minnwi Abrahaŋ, Aiji ni Jakɔ.’ Mushi wrū nthɛ pɔgɔ gu ki lɔ nuʼuŋ ntāʼa nu mbɛʼi. ");
INSERT INTO bmo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Minnwi Taathɔ chhu ghɔ ŋa, ‘Shrāo tra yɔ, nthɛ ŋa lɨʼɨ ŋa ɔ thi nɛ pɔ pi shhɛ taoŋtaoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ǹjəɨ fɨʼɨ ŋkwaŋ ŋgəʼɨ ŋa pi fɛ nu ni ŋgwa paŋ laʼataoŋ pa Ijipti nɛ, ǹjaʼo kə̄ɨ yugu nshwiʼi shhɛ nɔ kwe nu vugu. Thɔ ndwɛ ǹtaoŋ ghɔ laʼataoŋ Ijipti.’ ");
INSERT INTO bmo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mushi vei ŋa ŋgwa Ishrae ni ndāa vi, nchhu nu ŋa, ‘A nūʼɔŋ gɔ̌ nūʼɔŋ ghɔ ŋa ɔ shaʼa vigi?’ A ju ŋa Minnwi chuʼɔ ntɔgɔ pi ŋkuoŋ ŋgaŋ ntaoŋ vi ŋa a ni nōoŋ noŋ yi ghɔ ŋkuoŋ muuŋ thɨ yuyuʼu ŋa a shaʼa puoŋ Ishrae ndɔ ŋkwe vugu moŋ ŋgəʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","A ni mfuʼu pa puoŋ Ishrae laʼataoŋ Ijipti. A ni nthɔ nchwīe pa nnu ghraoghrao ndɔ nōoŋ pa lì moŋ laʼataoŋ Ijipti pugu pa mooŋ mmɛ ŋkhǐ ŋa pi mɛ̄iŋ ni Ŋkhǐ Pipie nɛ, pugu pa mooŋ ŋkǔnu njó nɔ khwɛ wuŋ ŋgaʼo. ");
INSERT INTO bmo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Yei Mushi yɛ ŋa a ni nchhu ni ŋgwa Ishrae ŋa, ‘Minnwi shi nchuʼɔ njəɨlɨʼɨ yi mfɛ ni pəɨ llɔ shɨna pəɨ wuʼɔ nɔ haʼaŋ a ni nuʼuŋ nchuʼɔ a nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mushi yei, ju yɛ ŋa a ni mbɔ pugu pa kɨrɨ ŋgwa Ishrae moŋ ŋkǔnu njó, a ni mbɔ hɛiŋ pugu pa ŋkhu tǎa pia pugu pa ŋgaŋ ntaoŋ Minnwi, ŋa a ni nchrā ghɔ ŋkuoŋ mbra Shinai, a kwe chrà maoŋ ghɔ, mbɔ chrà Minnwi nɔ fɛ nu ni pia. ");
INSERT INTO bmo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pa tǎa pia ni ndāa nɔ yaʼo nu nchò yi, ŋka lāa vi lāa ŋkhwā njùʼɔ pugu nɔ pɨ̄nɨ nu laʼataoŋ Ijipti, ");
INSERT INTO bmo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","nchhu nu ni Ɛroŋ ŋa, ‘Puoŋ yaoŋ mfɛ ni pigi nɔ Minnwi ŋa a shi mbɔ nthishɨ vigi, a mbɔ pi Mushi vei ŋa a ni mfuʼu vigi Ijipti nɛ, pigi llɔ nji nnu ŋa a chwīe vi nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","A ndɨɨ ghɔ ŋa pugu ni nchwīe yaoŋ puoŋ a pɔ nɔ muuŋ nàʼaŋ mimbia, pugu fɛʼiŋgiɛŋ ghɔ, mfāʼo mmɛ jɨ nɔ ghaʼo nu yaoŋ ŋa pugu chwīe ni mbhɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nthɛ yie ghɔ, Minnwi pāʼa ŋkǔnu yi ni pugu, mfɛ vugu ŋa pugu thɔ ŋgaʼo pi pa maoŋ moŋ tɔthɨ nɔ pa fɨ́nəɨ, fhú, ni minaoŋ, nɔ haʼaŋ pi nāʼaŋ moŋ ŋwaʼaŋlɨ pa njəɨlɨʼɨ Minnwi ŋa, ‘Ŋgwa Ishrae, ŋguoŋ pa minyieŋ ŋa pəɨ ni ŋgwrā nɔ yaoŋ fɛʼiŋgiɛŋ nɔ khwɛ wuŋ ŋgaʼo moŋ ŋkǔnu njó nɛ shini ndɔ njiʼi mbɔ pi vəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","A ni mbɔ ntǎa nnwi Molokɛ ŋa pəɨ ni ntiɛŋ nyīeŋ nu nɔ ghɔ, pugu chwīe yaoŋ nɔ fɨ́nəɨ nɔ ligi nnwi ŋa pəɨ ni mɛ̄iŋ ni Refaŋ. Pie ghɔ ni mbɔ pa nnwi ŋa pəɨ ni nchwīe ŋgaʼo nu nɛ, nthɛ yie ghɔ, ǹshi njōu vəɨ moŋ pa laʼa pəɨ, pəɨ ghə̄ɨ ti mfərə Babiloŋ.’ ");
INSERT INTO bmo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Pa tǎa pia ni mfāʼo Ntǎa ŋa a nōoŋ ŋa Minnwi pɔ pugu pugu nɛ moŋ ŋkǔnu njó. Pi ni nchwīe Ntǎa ghɔ nɔ haʼaŋ Minnwi ni nchhu ni Mushi ŋa a chwīe ŋkwaŋ haʼaŋ a ni nōoŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","A ni ŋga ndaʼa, pa tǎa pia ŋa pa tǎa pugu ni mfɛ ntǎa ghɔ ni pugu nɛ tiɛŋ ŋgə̄ɨ nɔ ghɔ ndɨɨ ŋa pugu pa Joshua ni ŋgə̄ɨ ŋkwe shhɛ mbhɔ pa laʼataoŋ ŋa Minnwi ni mfuʼu pa laʼataoŋ pighɔ fɔ nɛ. A ni ŋkɨna fɔ ti nthɔ nchəɨŋ thɔ Devi. ");
INSERT INTO bmo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Devi ŋa Minnwi ni nōoŋ pwapuŋ yi ghɔ nɛ, a luoŋ ni Minnwi ŋa a mieŋ a krao lɨʼɨ chhɔ ni Minnwi Jakɔ. ");
INSERT INTO bmo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ndɔ a ni ŋkrao Sholomu ŋkrao Nda ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mbapa nɛnnɛ, Minnwi ŋa a Chaapifuoŋ nɛ shiʼa nchhɔ moŋ nda ŋa a krao ŋoŋmishua ni mbhɔ mi nɛ nɔ haʼaŋ njəɨlɨʼɨ Minnwi chhu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Taathɔ chhu ŋa, “Po pɔ pi faaŋ a, shhɛ pɔ krɨ́ tigi kwò a. Ti a yəɨ ŋkwaŋ nda ŋa minthɛ ɔ krao vəɨ? Mimfɛ ndaʼa pi moŋ yəɨ ŋkwaŋ lɨʼɨ? ");
INSERT INTO bmo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ǹshini ndɔ nchwīe ŋguoŋ pa maoŋ pei ghao pi ni mbhɔ ma?” ’ ");
INSERT INTO bmo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Pa kwéi thɔ pei, ŋgwa ŋa mbaʼa pugu piŋ chrà Minnwi ki njaʼo. Pəɨ ghà nchɨ̄ʼə nchò Jijwɛ Minnwi ŋguoŋ ndɨɨ ghao wuʼɔ nɔ haʼaŋ pa tǎa pəɨ ni nchwīe nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","A yəɨ njəɨlɨʼɨ Minnwi ŋa pa tǎa pəɨ shini ndɔ mfɛ ŋgəʼɨ ni pugu? Pugu ni njwi pa ghaŋ māʼaŋ ŋkɨ̀nɨ Minnwi, ŋa pugu ni nchīi thɔ nu muuŋ fàʼa vi yi tithi nɛ. Ndwɛ pəɨ fīni vi njwi vi. ");
INSERT INTO bmo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Pəɨ ni ŋkwe gɨ́ Minnwi nɔ haʼaŋ ghaŋ ntaoŋ Minnwi ni mfɛ ni pəɨ nɛ, ndɔ ki lɔ njiʼi nūʼɔŋ gɨ́ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nɔ haʼaŋ pa ŋgwa nda pa kúŋ ni njaʼo nnu ŋa Shitifiŋ ni nchhu nɛ, a shāʼa laʼa muŋu pugu kru shua muŋu moŋ pɨgɨtua. ");
INSERT INTO bmo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ndɔ Shitifiŋ lɨnaoŋ ni Jijwɛ Minnwi, mbɨʼɨ ligi yi ndīi po njəɨ ndighaʼo Minnwi, ndɔ njəɨ Jishɔ a thi ŋgei mbhɔ Minnwi yi jɨ. ");
INSERT INTO bmo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Shitifiŋ ghɔ chhu ŋa, “Njəɨ! Ǹjəɨ po ŋaʼaŋ, ǹjəɨ Muuŋ Ŋoŋmishua a thi ŋgei mbhɔ Minnwi yi jɨ!” ");
INSERT INTO bmo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pa ŋgwa pighɔ fɔ paʼo ŋgòu, nchri tə́nə yugu ni mbhɔ muŋu, ntei nchò vi, ");
INSERT INTO bmo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","mfuʼu vi ntaoŋ nɔ moŋ laʼa, tuŋ vi ni ŋguʼɔ, pa ŋgwa pɛ ŋa pugu ni ntigi pa nnu thɔ yu nɛ ni mieŋ pa mmɛ ndhwí pugu ni maʼaŋ mikhwa chəɨ ligi yi pɔ Shɔɔ. ");
INSERT INTO bmo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nɔ haʼaŋ pugu ni nthɔ ntuŋ Shitifiŋ nɛ, a luoŋ Minnwi nchhu ŋa, “Jishɔ Taathɔ, kwe jijwɛ a.” ");
INSERT INTO bmo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","A kwiŋ kwɛ́rɛ yi shhɛ, ŋkə̄ɨ ni njɨ ŋa, “Taathɔ, kiʼi ŋgwɛ̄iŋ vugu nthɛ nnu pɨphɨ yei ŋa pugu chwīe nɛ.” A ni nchhu nɛnnɛ ŋkhu. ");
INSERT INTO bmo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shɔɔ ni mbiŋ ŋa pi jwi Shitifiŋ ghɔ. Llɛ́ ghɔ ŋgwa yrɛi nthɔ mfɛ ŋkiɛŋ ŋgəʼɨ ni chɔshi Jerushalɛiŋ, pugu sha moŋ ŋguoŋ Judia pugu pa Shamaria, a twiʼa pa ghaŋ ntaoŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pa ŋkiɛŋ tɨtɨnɨ ghaŋ piŋ twei Shitifiŋ ŋkə̄ɨ vi a wūru. ");
INSERT INTO bmo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ndɔ Shɔɔ jɛ̄ nthɔ nshāaŋ chɔshi, nii nda nda nthɔ mfuʼu mbia pugu pa piŋgɛ mbɔ ghaŋ piŋ nthɔ māʼaŋ vugu chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ndwɛ, ŋguoŋ ŋgwa pɛ ŋa pi shāaŋ vugu nɛ ghə̄ɨ ŋguoŋ lɨʼɨ nthɔ nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Fili llɔ nshwiʼi moŋ laʼa Shamaria, nchīi ligi Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yú ŋgwa pighɔ fɔ nɛ ya njwɛrɛ nnu ŋa Fili ni nchhu nɛ, nɔ haʼaŋ pugu ni njəɨ pa nnu ghraoghrao ŋa a ni nchwīe nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pa jijwɛ pɨphɨ paʼo ŋgòu ntaoŋ mbɨŋ ntou ŋgwa ŋa pugu ni mbɔ mbɨŋ pugu nɛ. Ntou pa ŋgwa ŋa pəʼɨ noŋ yugu ni ŋkhu nɛ pugu pa ŋkwíni pɨnɨ mbɔ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nnɛ ntou pwanjuʼɔ pɔ moŋ laʼataoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ŋoŋ chəɨ, ligi yi pɔ Shemu, ŋa a ni mbɔ ntouŋgaŋ, ni nchwīe ŋgwa Shamaria ghrāo vi ni nnu ŋgaŋ, a ni nchhu nu ŋa juju ŋkaa yu ŋoŋ ndiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ŋguoŋ ŋgwa moŋ laʼa, ŋgwa kikɛʼi pugu pa pi liɛŋ yaʼo vi, nchhu nu ŋa, “Ŋoŋ vei pɔ pi njɨ Minnwi yɛ ŋa pi mɛ̄iŋ ni yi Liɛŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Pugu ni mfɛ ndɨɨ yugu ghɔ nɛnnɛ nthɛ ŋa nɔ ntaaŋ ndɨɨ a ni ŋgwīni vugu ni ŋgáŋ yi ŋa a ni ntou nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ndɔ pugu ni ŋga mbiŋ ŋkɨ̀nɨ pwa pishaʼakhɔ Shaʼafuoŋ Minnwi pugu pa Jishɔ Krishto ŋa Fili ni nchīi ni pugu nɛ, ŋkwe ŋkhǐ mbia pugu pa piŋgɛ. ");
INSERT INTO bmo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Shemu piŋ ŋkaa yu, ŋga ŋkwe ŋkhǐ, nyīeŋ nu pugu Fili. A ni ŋga njəɨ pa lì pugu pa mɛmmɛ nnu ghraoghrao ŋa Fili ni nchwīe nu nɛ, ŋgrào. ");
INSERT INTO bmo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ndwɛ, pa ghaŋ ntaoŋ Jishɔ Jerushalɛiŋ ni ŋga njaʼo ŋa ŋgwa Shamaria piŋ chrà Minnwi, ntaoŋ Pita pugu Jouŋ, ");
INSERT INTO bmo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","pugu shwiʼi nduoŋ Minnwi mfɛ ni pugu nnɛ ŋa mimfɛ pugu kwe Jijwɛ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nthɛ ŋa a shini ndɔ naa nshwiʼi mbɨŋ shesheŋoŋ vugu, pugu ni ŋguʼɔ ŋkwe ŋkhǐ pi nɔ ligi Jishɔ Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pita pugu Jouŋ nūʼɔŋ mbhɔ yugu mbɨŋ pugu, pugu kwe Jijwɛ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ndwɛ, Shemu ni ŋga njəɨ ŋa ghaŋ ntaoŋ Jishɔ nūʼɔŋ mbhɔ mbɨŋ ŋgwa pugu fāʼo Jijwɛ Minnwi, a fɛ mbɨŋ ni Pita pugu Jouŋ, ");
INSERT INTO bmo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nchhu nu ni pugu ŋa, “Fɛ ghrɨ́ yei vəɨ ŋkaa mu, nnɛ ŋa shesheŋoŋ ŋa ǹūʼɔŋ mbhɔ a mbɨŋ yu nɛ shi mfāʼo Jijwɛ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ndɔ Pita khwɛ̄ ghɔ ŋa, “Pəɨ pa mbɨŋ yɔ ghɔ shiʼi, nthɛ ŋa ɔ pīʼi ŋa minthɛ ɔ yuoŋ fɛ́ Minnwi ni mbɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɔ lɔ njiʼi fāʼo shɨ̀na moŋ fàʼa yigi nthɛ ŋa njùʼɔ yɔ lɔ njiʼi mbɔ yi tithi ligi Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nthɛ yie ghɔ, pāʼa ŋkǔnu yɔ ni mbha nnu pɨphɨ yei nduoŋ ni Taathɔ ŋa minthɛ a līʼɛ phɨ yɔ ni pīʼi nu yei ŋkwaŋ nnu. ");
INSERT INTO bmo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nthɛ ŋa ǹjəɨ ŋa ɔ lɨnaoŋ ni kɨghɨʼə pɨphɨ mbɨnɨ mbɔ ŋgaŋ chə́ɨŋ mbhɔ phɨ.” ");
INSERT INTO bmo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Shemu khwɛ̄ ŋa, “Pəɨ luoŋ ni Taathɔ mfɛ vəɨ nnɛ ŋa kiʼi sheshe nnu yei ŋa pəɨ chhu nthɛ a nɛ fɨʼɨ a!” ");
INSERT INTO bmo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita pugu Jouŋ chhu pa nnu ŋa nduthɔ yugu ji nthɛ Jishɔ nɛ, ndɔ nchīi chrà Taathɔ, njɛ̄ pɨ̄nɨ nu kiʼɛ Jerushalɛiŋ. Pugu ni ŋga mbɔ shɛndaoŋ mbɨnɨ nu, nthɔ nchīi chrà Minnwi moŋ ŋguoŋ puoŋ mi laʼataoŋ moŋ Shamaria. ");
INSERT INTO bmo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ndɔ ŋgaŋ ntaoŋ Taathɔ chhu ni Fili ŋa, “Lɔllɔ nshwiʼi mbiɛŋ shɛndaoŋ ŋa a llɔ Jerushalɛiŋ ŋgə̄ɨ Gasha nɛ.” (Yei ndaoŋ ŋa pi lɔ nuʼuŋ ntɔgɔ nu fɔ shiʼa.) ");
INSERT INTO bmo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Fili lɔllɔ ŋgə̄ɨ, ŋga njəɨ nu, yichəɨ ŋoŋ llɔ Itiopia, ni mbɔ ŋoŋ ndiɛŋ ndɨna nu ni mbɨŋ ŋgwafuoŋ Itiopia, thɔ Jerushalɛiŋ lɨʼɨ ghaʼo Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","A ni ŋga ŋkwəɨ nu, nchhɔ moŋ yaoŋ ŋa pi mɛ̄iŋ ni kalɨ nɛ nthɔ mɛ̄iŋ ŋwaʼaŋlɨ njəɨlɨʼɨ Minnwi mbɔ Ishaya. ");
INSERT INTO bmo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jijwɛ Minnwi chhu ni Fili ŋa, “Kuʼɔ mbara vi yəɨ kalɨ.” ");
INSERT INTO bmo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nnɛ, Fili tei ŋgə̄ɨ mbara vi, njaʼo a thɔ mɛ̄iŋ ŋwaʼaŋlɨ njəɨlɨʼɨ Minnwi mbɔ Ishaya. A pie vi ŋa, “Ɔ lɔ njaʼo nnu ŋa ɔ mɛ̄iŋ nu nɛ?” ");
INSERT INTO bmo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A khwɛ̄ ŋa, “Mimfɛ ŋ̀kie pi nɛiŋ nji ki ŋoŋ lɔ mfɨ̄ʼɨ vəɨ?” Ŋgɛ̄ Fili ŋa a kuʼɔ nchhɔ pugu yu moŋ kalɨ. ");
INSERT INTO bmo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yɛ lɨʼɨ Ŋwaʼaŋlɨ Minnwi ŋa a ni mɛ̄iŋ nu nɛ ni mbɔ yei lɨʼɨ ŋa, “A ni mbɔ nɔ minjɨɨ ŋa pi lɔ̄gɔ vi ŋgə̄ɨ nɔ ghɔ ŋgwrā, wuʼɔ ŋkwaŋ haʼaŋ muuŋ minjɨɨ shiʼa ŋkə̄ɨ ndɨɨ ŋa pi kiri ŋgì yi nɛ, a shini ndɔ nchhu nnu. ");
INSERT INTO bmo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pi ni nshhū vi ndɔ ndāa ki lɔ nshaʼa vi ni ndɨndɨ. Mimfɛ paʼa ŋoŋ lɔ nchhu nnu nthɛ ŋgwrɛiŋoŋ yi Nthɛ ŋa chɔmbhi yi ŋkuoŋ shhɛ hɛiŋ kwo lūgwi.” ");
INSERT INTO bmo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mmɛŋoŋ ghɔ pie Fili ŋa, “Shwei a, njəɨlɨʼɨ Minnwi yei thɔ nchrā yei nnu pi nɔ ligi gɔ̌? A chrā pi nɔ ji ligi ki ŋoŋ nduoŋ?” ");
INSERT INTO bmo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nnɛ Fili jɛ̄ chrā nu kəʼɨ ghɔ, llɔ ŋkuoŋ lɨʼɨ ŋwaʼaŋlɨ yei, nshwei vi kəʼɨ ghɔ ni pwa pishaʼakhɔ nthɛ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pugu ni ŋga nyīeŋ nshwiʼi nu shɛndaoŋ ghɔ ntaoŋ yichəɨ lɨʼɨ ŋkhǐ pɔ fɔ, mmɛŋoŋ ghɔ chhu ŋa, “Līi njəɨ, ŋkhǐ pɔ nɛiŋ, a shi mbɨnɨ ntāra khɔ ntāra a ŋa kiʼi ŋ̀kwe ŋkhǐ?” ");
INSERT INTO bmo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fili khwɛ̄ ŋa, “Minthɛ ɔ kwe, nɔ haʼaŋ ɔ̈ mbiŋ ni ŋguoŋ njùʼɔ yɔ.” Ŋoŋ ghɔ khwɛ̄ ŋa, “Mbiŋ Jishɔ Krishto Muuŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mfɛ gɨ́ ni Kalɨ ghɔ ŋa a tithi, pugu Fili shwiʼi kiʼɛ moŋ ŋkhǐ, Fili fɛ ŋkhǐ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pugu ni ŋga ntaoŋ moŋ ŋkhǐ, Jijwɛ Taathɔ lɔ̄gɔ Fili ŋgə̄ɨ nɔ ghɔ. Mmɛŋoŋ ghɔ shi ki lɔ nuʼuŋ njəɨ Fili jɛ̄ ndɨɨ ghɔ, mbɔrɔ ŋgə̄ɨ nu ni vhi ndɨnaoŋ ni pwanjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fili yəɨ noŋ yi laʼataoŋ Ashotu. A ni nyīeŋ ŋgə̄ɨ Kaisharia, nɔ haʼaŋ a ni ŋgə̄ɨ nu nɛ, nthɔ nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ moŋ ŋguoŋ lɨʼɨ ghao ti nuʼuŋ ŋgə̄ɨ nchəɨŋ Kaisharia. ");
INSERT INTO bmo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ndɔ ndɨɨ yei Shɔɔ wuʼɔ nthɔ ŋgə̄ɨ nu shhɨ nchhu nu ŋa a shi njwi ghaŋ younjiŋ taathɔ. Ŋgə̄ɨ mbara taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ");
INSERT INTO bmo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nchhu ghɔ ŋa a nāʼaŋ pa ŋwaʼaŋlɨ mfɛ ghɔ, nɔ shwei nu ŋoŋ ŋa ju, Shɔɔ, yie ghɔ nɛ ni ŋgwa moŋ pa nda luoŋ Minnwi Damashiku, nnɛ ŋa ä njəɨ ŋgwa ŋa pugu pɔ pi ŋgwa Shɛndaoŋ ŋa Jishɔ ni nōoŋ nɛ, mbia ki piŋgɛ, kaŋ a shi ŋgwɛ̄iŋ vugu mbɨnɨ ni pugu Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nɔ haʼaŋ Shɔɔ ni nyīeŋ mbara nu Damashiku nɛ, líʼɛ wīʼi shɛiŋ mbɨŋ yu llɔ po. ");
INSERT INTO bmo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A gū shhɛ njaʼo yichəɨ ŋggì chhu nu ghɔ ŋa, “Shɔɔ! Shɔɔ! Ɔ fɛ ŋgəʼɨ vəɨ ŋa?” ");
INSERT INTO bmo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shɔɔ pie ŋa, “Ɔ pɔ pi gɔ̌, Taathɔ?” Ŋggì ghɔ khwɛ̄ ŋa, “Mi Jishɔ ŋa ɔ thɔ fɛ ŋgəʼɨ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ndɔ lɔllɔ nii moŋ laʼa, kaŋ pi shi nshwei ghɔ ni nnu ŋa ɔ shi nchwīe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndɔ ŋgwa pɛ ŋa pugu pugu ni mbɔ nɛ tithi, nchò yugu llwī, njaʼo ŋggì, ndɔ paʼa ndɔ njəɨ ŋgaŋ vi. ");
INSERT INTO bmo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shɔɔ lɔllɔ shhɛ, mfēi ligi yi, ndɔ paʼa ndɔ njəɨ lɨʼɨ. Nthɛ yie ghɔ, pi wɛ̄iŋ pi mbhɔ yi nii nɔ ghɔ Damashiku. ");
INSERT INTO bmo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ndɔ a shini ndɔ njəɨ lɨʼɨ nɔ trɛi llɛ́ ndɔ paʼa ndɔ njɨ yaoŋ ki nnu sheshe yaoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ŋgaŋ younjiŋ Jishɔ chəɨ ni mbɔ fɔ Damashiku, ligi yi pɔ Anania, Taathɔ chwīe a yəɨ nnu, nchhu ghɔ moŋ nnu ghɔ ŋa, “Anania!” A khwɛ̄ ŋa, “Līi njəɨ! Mbɔ nɛiŋ, ma Taathɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Taathɔ chhu ghɔ ŋa, “Pīri noŋ yɔ ŋgə̄ɨ shɛndaoŋ ŋa pi mɛ̄iŋ ni Ndɨndɨ nɛ, nda Judashi, ndīi ŋoŋ chəɨ llɔ Tashɔ, ligi yi pɔ Shɔɔ. A chhɔ nɛ nduoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Minnwi kwo chwīe a yəɨ nnu, ŋoŋ chəɨ, ligi yi pɔ Anania, thɔ nūʼɔŋ mbhɔ yi mbɨŋ yu nnɛ ŋa a pɨnɨ njəɨ lɨʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ndɔ Anania khwɛ̄ ŋa, “Taathɔ, ntou ŋgwa kwo fɨ̄ʼɨ ntou pa nnu vəɨ nthɛ ŋoŋ vei, fɨʼɨ pa nnu wuwuru ŋa a chwīe mbɨŋ ŋgwa pɔ pi taoŋtaoŋ Jerushalɛiŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ndɔ a ni ŋkwe ghrɨ́ mbhɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ nɔ thɔ nu Damashiku hɛiŋ ŋgwɛ̄iŋ ŋgwa pɛ ŋa pugu ghà njɨʼə noŋ yugu mbɨŋ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ndɔ Taathɔ chhu ghɔ ŋa, “Ghə̄ɨ, nthɛ ŋa a yaoŋ fàʼa ŋa ǹchuʼɔ ŋa a chwīe pa ŋgwa taoŋ nduoŋ pugu pa fùoŋ ni pa ŋgwa Ishrae ji a nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nthɛ ŋa mmu nduthɔ a, shi nōoŋ ghɔ fɨʼɨ ŋkwaŋ nɔ haʼaŋ a pie ŋa a yəɨ ŋgəʼɨ nthɛ a nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nnɛ, Anania lɔllɔ ŋgə̄ɨ nii nda ghɔ, ŋga nūʼɔŋ mbhɔ yi mbɨŋ yu, nchhu ŋa, “Ndǐŋ a Shɔɔ, Jishɔ Taathɔ ŋa a nōoŋ noŋ yi vɛ shɛndaoŋ ŋa ɔ nì ntɔgɔ fɔ nthɔ nɛ, taoŋ a nnɛ ŋa minthɛ ɔ pɨnɨ nuʼuŋ njəɨ lɨʼɨ ndɔ ndɨnaoŋ ni Jijwɛ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wuʼɔ ndɨɨ ghɔ, pichəɨ yaoŋ nɔ ghrǎo shadi paʼa ntaoŋ nɔ ligi yi a pɨnɨ nuʼuŋ njəɨ lɨʼɨ. Ndɔllɔ kiʼɛ pi kwe vi ni ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","A jɨ maoŋ mfāʼo ghrɨ́ kiʼɛ. Shɔɔ ni mbɔ pugu pa ghaŋ younjiŋ Jishɔ Damashiku nɔ ntou llɛ. ");
INSERT INTO bmo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Shɔɔ yrɛi taʼa ŋgɛ́ ŋgə̄ɨ moŋ pa nda luoŋ Minnwi njɛ̄ chīi nu chrà Minnwi fɔ, ŋa Jishɔ muuŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ŋguoŋ ŋgwa ŋa pugu ni njaʼo a thɔ nchīi nu nɛ ni ŋgrào, mbie ŋa, “Yei shi lɔ mbɔ ŋoŋ ŋa a ni nthɔ mfɛ wuwuru ŋgəʼɨ ni ŋgwa pɛ Jerushalɛiŋ, ŋa pugu ghà njɨʼə noŋ yugu mbɨŋ ŋoŋ ghɔ ŋa pi mɛ̄iŋ ni Jishɔ nɛ? A shini ndɔ ŋguʼɔ nthɔ hɛiŋ pi nɔ wɛ̄iŋ nu ŋgwa pighɔ ŋgə̄ɨ mfɛ vugu ni pa thishɨ ghaŋ fɛʼiŋgiɛŋ?” ");
INSERT INTO bmo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ndɔ chīi nu chrà Minnwi Shɔɔ pɨnɨ ntɨnɨ ŋgaʼa, a llwī nchò pa Juu Damashiku nɔ nōoŋ nu ki khuthɔ ŋa Jishɔ pɔ pi Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ shini. ");
INSERT INTO bmo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ntou llɛ́ ni ŋga ntɔgɔ, pa Juu paoŋ ntaŋ nɔ jwi nu vi. ");
INSERT INTO bmo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ndɔ pi tūgu ntáŋ yugu ghɔ ni Shɔɔ. Pugu ni nthɔ mbɛʼi pa choŋkaʼa ŋa pi ghà ntɔgɔ fɔ nii moŋ laʼa nɛ ni naoŋchɨ pugu pa tuʼu nɔ jwi nu vi. ");
INSERT INTO bmo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ndɔ ni tuʼu chəɨ, pa ghaŋ younjiŋ Shɔɔ lɔ̄gɔ vi niʼiŋ vi moŋ mikuo nshwiʼi vi moŋ mbo mbɨŋ nda, a taoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Shɔɔ ni ŋga ŋgə̄ɨ Jerushalɛiŋ, ŋkaa nu nɔ tūru nu pugu pa ghaŋ younjiŋ Jishɔ. Ndɔ paʼa pugu lɔ njiʼi mbiŋ ŋa a taʼa ŋgaŋ younjiŋ Jishɔ, ŋka pɔgɔ vi pɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ndɔ Banaba thɔ nɔ ghɛ̄rɛ nu vi, ŋgwɛ̄iŋ mbhɔ yi ŋgə̄ɨ ni ju njəɨ pa ghaŋ ntaoŋ Jishɔ, nshwei vugu ŋkwaŋ haʼaŋ a ni njəɨ Taathɔ shɛndaoŋ, Taathɔ ghɔ chhu pa nnu ghɔ. Mbɨnɨ mfɨ̄ʼɨ ni pugu ŋkwaŋ haʼaŋ Shɔɔ ni nshwei chrà Minnwi nɔ ligi Jishɔ ni tɨnɨnjuʼɔ Damashiku nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nnɛ Shɔɔ ni nyīeŋ nu pugu pugu kaʼa Jerushalɛiŋ, nthɔ nchīi chrà Minnwi ni tɨnɨnjuʼɔ moŋ ligi Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A ni nchrā nu ndɔ ndōu nu pugu pa ŋgwa Juu pɛ ŋa pugu ni nchrā pi chrà Gri nɛ, ndɔ ŋgwa Juu pighɔ tāʼa nu njwi vi jwi. ");
INSERT INTO bmo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pa pichəɨ ghaŋ piŋ ni ŋga nji ŋa pi tāʼa nu njwi vi, ndɔ̄gɔ vi nshwiʼi nɔ Kaisharia ntaoŋ vi Tashɔ. ");
INSERT INTO bmo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nnɛ, chɔshi moŋ ŋguoŋ Judia, ni Galili, ni Shamaria fāʼo ghɨghrɨ. Jijwɛ Minnwi ghɛ̄rɛ chɔshi pɨnɨ ntɨnɨ mbīgi ndɔ mbɨnɨ njiɛŋ mbīgi nɔ haʼaŋ pugu chhɔ chɔmbhi yugu ni pɔ́gɔ Taathɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ni nyīeŋ ŋguoŋ lɨʼɨ ghao, nɔ yichəɨ ŋgɛ́ a ghə̄ɨ lɨʼɨ kra ŋgwa Minnwi pi taoŋtaoŋ Lida, ");
INSERT INTO bmo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ŋga nchəɨŋ fɔ njəɨ yichəɨ ŋoŋ, ligi yi pɔ Aenia, ŋa pəʼɨ noŋ yi ni ŋkwo khu, a kwo nūaŋ kúoŋ nɔ fúoŋ ŋgaʼo. ");
INSERT INTO bmo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita chhu ghɔ ŋa, “Aenia, Jishɔ Krishto yɨ̄gɨ ghɨ̌nɔ yɔ, lɔllɔ nchwīe kúoŋ yɔ.” Wuʼɔ ndɨɨ ghɔ a lɔllɔ. ");
INSERT INTO bmo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ŋguoŋ ŋgwa ŋa pugu ni ndaʼa nu Lida pugu Sharoŋ nɛ, yəɨ vi ŋkara mbiŋ Taathɔ ghao. ");
INSERT INTO bmo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ndɨɨ ghɔ moŋ laʼataoŋ Jopa, ŋgaŋ younjiŋ Jishɔ chəɨ ni mbɔ fɔ, ligi yi pɔ Tabita, mbɔ moŋ chrà Gri ŋa Dɔka. A ni ndɔ̄gɔ ŋguoŋ ndɨɨ yi ghao nthɔ nchwīe shiʼi ndɔ ŋgɛ̄rɛ ghaŋ pou. ");
INSERT INTO bmo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Moŋ llɛ́ pighɔ a gū ghɨ̌nɔ ndɔ ŋkhu. Pi ni ŋga nshɨ̄gao vi, ndɔ̄gɔ vi ŋkuʼɔ nūʼɔŋ moŋ njiɛŋ nda tɔthɨ. ");
INSERT INTO bmo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nthɛ ŋa Lida ni mbara Jopa nɛ, pa ghaŋ younjiŋ Jishɔ gha njaʼo ŋa Pita ni mbɔ Jopa, ntaoŋ paa ŋgwa ghɔ, māʼaŋ ghrɨ́ yi nchhu nu ŋa, “Pigi paʼo mbhɔ, kɔnɔ nthɔ njəɨ vigi ki lɔ nuʼuŋ njīri.” ");
INSERT INTO bmo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita yrɛi ŋgə̄ɨ pugu pugu, ŋga nchəɨŋ fɔ pi lɔ̄gɔ vi ŋkuʼɔ ni ju moŋ nda tɔthɨ. Ŋguoŋ pa ŋkugu ni ŋkɨrɨ yəɨ Pita ŋkə̄ɨ ndɔ nthɔ nōoŋ pa puoŋ mi ndhwí pugu pa pichəɨ mɛmmɛ ndhwí fɨgəɨ yugu ŋa Dɔka ni nchwīe ndɨɨ ŋa pugu pugu ni mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita chhu ŋguoŋ yugu taoŋ moŋ njiɛŋ nda ghɔ, â ŋkwi kwɛ́rɛ yi nduoŋ Minnwi, ŋkara mbɛʼi khu ŋoŋ ghɔ nchhu ŋa, “Tabita, lɔllɔ!” A fēi ligi yi ŋga njəɨ Pita, ndɔllɔ nchɔchhɔ. ");
INSERT INTO bmo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita fɛ mbhɔ yi ŋgɛ̄rɛ vi a lɔllɔ tɔthɨ. Nnɛ, a mɛ̄iŋ ŋguoŋ ŋgwa Minnwi pi taoŋtaoŋ, pugu pa ŋkugu, mfɛ vi yi maoŋ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nnu pei ni nyīeŋ ŋkwe ŋguoŋ Jopa, ntou ŋgwa kara mbiŋ Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita laʼa Jopa nɔ ntou llɛ́ pugu yichəɨ ŋoŋ, ligi yi pɔ Shemu, mbɔ ŋgaŋ chwīe ŋgrào. ");
INSERT INTO bmo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ŋoŋ chəɨ ni mbɔ Kaisharia ligi yi pɔ Kɔniliu. A ni mbɔ nthishɨ taʼa ŋkɨɨ pa shoogɛ moŋ kwíe ntɨgao ŋkɨɨ pa shoogɛ llɔ Itali. ");
INSERT INTO bmo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","A ni mbɔ ŋkiɛŋ ŋoŋ Minnwi. Nduthɔ yi pugu pa ŋguoŋ ndaaŋoŋ yi ni nthɔ ŋgaʼo Minnwi. A ni nthɔ ŋgɛ̄rɛ ntou pa ghaŋ pou, ndɔ nduoŋ Minnwi ki jwɛ. ");
INSERT INTO bmo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","A ni mbɔ moŋ trɛi minaoŋ ni naoŋchɨ, Minnwi nōoŋ nnu ghɔ, a yəɨ ŋgaŋ ntaoŋ Minnwi, a chhu ghɔ ŋa, “Kɔniliu!” ");
INSERT INTO bmo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A līi ŋgaŋ ntaoŋ Minnwi ghɔ ni pɔgɔ gu, mbie ŋa, “A khɔ, Taathɔ?” Ŋgaŋ ntaoŋ Minnwi khwɛ̄ ŋa, “Minnwi kwiŋ luoŋ yɔ pugu pwapuŋ yɔ ni pwatua. ");
INSERT INTO bmo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ndwɛ, taoŋ ŋgwa Jopa, pugu ghə̄ɨ mɛ̄iŋ ŋoŋ chəɨ ligi yi pɔ Shemu Pita. ");
INSERT INTO bmo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A laʼa nu pugu Shemu mbɔ ŋgaŋ chwīe ŋgrào, ŋa nda yi pɔ ŋkɨŋ mmɛ ŋkhǐ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ŋgaŋ ntaoŋ Minnwi ghɔ ŋa a ni nchrā ghɔ nɛ gha ŋkwo ghə̄ɨ nɛ, Kɔniliu gɛ̄ paa ŋgwa haʼaŋ pugu ni mfāʼa nu mbhɔ yu nɛ, ni taʼa shoogɛ mbɔ ŋoŋ Minnwi shɨna pa shoogɛ ŋa a ni nthɔ nshaʼa vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ŋga mfɨ̄ʼɨ ŋguoŋ nnu pighɔ ni pugu, ntaoŋ vugu Jopa. ");
INSERT INTO bmo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mbhi ni ŋga ndaŋ, pugu pɔ shɛndaoŋ ŋgə̄ɨ nu ti ŋkwo para moŋ laʼa. Pita kuʼɔ thɔnda lɨʼɨ luoŋ Minnwi moŋ ntuŋ minaoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Njì yia vi, a tāʼa yaoŋ njɨ, pi gha nthɔ nyiaŋ maoŋ, a yəɨ nnu. ");
INSERT INTO bmo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Njəɨ po ŋaʼaŋ, a yəɨ yaoŋ shwiʼi nu shhɛ nɔ mmɛ pra mbhɔ ndhwí, pi wɛ̄iŋ vi ŋkuoŋ khwɛ ghaa pi, a shwiʼi nu. ");
INSERT INTO bmo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ŋguoŋ ŋkwaŋ pa minyieŋ pugu pa mimaoŋ shatei pugu pa mishi moŋ ŋgunu ni mbɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yichəɨ ŋggì taoŋ po nchhu ghɔ ŋa, “Pita, lɔllɔ, jwi ŋkru.” ");
INSERT INTO bmo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita khwɛ̄ ŋa, “Ŋga, ma Taathɔ! Ǹdɔ naa ma mfuo noŋ a ni maoŋ fuo ki maoŋ nchhí.” ");
INSERT INTO bmo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ŋggì ghɔ pɨnɨ nchhu ghɔ mbra ŋgɛ́ ŋa, “Kiʼi mɛ̄iŋ yaoŋ ŋa Minnwi chwīe a pɔ yi taoŋtaoŋ nɛ ŋa a yaoŋ nchhí.” ");
INSERT INTO bmo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yei nnu ni ndɔ̄gɔ lɨʼɨ nɔ trɛi ŋgɛ, nnɛ pi lɔ̄gɔ maoŋ pighɔ mbɨnɨ nɔ po. ");
INSERT INTO bmo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita ni ŋga nthɔ ŋgrāo njiŋ nnu ŋa a yəɨ nɛ, ŋgwa pɛ ŋa Kɔniliu ni ntaoŋ nɛ kwo pie ti njəɨ nda Shemu, nthɔ nthi choŋkaʼa, ");
INSERT INTO bmo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","mɛ̄iŋ nu ndɔ mbie nu ŋa Shemu ŋa ligi yi Pita nɛ laʼa pi fɔ? ");
INSERT INTO bmo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nɔ haʼaŋ Pita ni ŋguʼɔ nthɔ mbīʼi njiŋ nnu ŋa a yəɨ nɛ, Jijwɛ Minnwi chhu ghɔ ŋa, “Līi njəɨ, trɛi ŋgwa thɔ nɛ ndīi ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ndwɛ, lɔllɔ, nshwiʼi shhɛ, ŋgə̄ɨ pəɨ pugu ki lɔ ndōu nthɛ ŋa a taoŋ mmu ntaoŋ vugu.” ");
INSERT INTO bmo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita shwiʼi ŋgə̄ɨ mbara ŋgwa pighɔ, nchhu ŋa, “Mi ŋoŋ ŋa pəɨ līi nu nɛ, pəɨ thɔ pi khɔ?” ");
INSERT INTO bmo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Pugu chhu ŋa, “Ŋgaŋ ntaoŋ Minnwi yi taoŋtaoŋ chhu ni Kɔniliu, mbɔ nthishɨ taʼa ŋkɨɨ pa shoogɛ, mbɔ ŋoŋ ndɨndɨ, mbɔgɔ Minnwi, ŋguoŋ ŋgwa Juu nchrā shiʼi nɔ ligi yi, ŋa a gɛ̄ ghɔ nda yu, nji ŋa a shi nji nnu ŋa ɔ fāʼo nɔ chhu nu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita chhu ni ŋgwa pighɔ ŋa pugu nii nda pugu pugu laʼa. Mbhi ni ŋga ndaŋ a pīri noŋ yi, pugu pugu ghə̄ɨ. Pichəɨ pa ghaŋ piŋ llɔ Jopa yōu njiŋ yi pugu pugu ghə̄ɨ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mbhi ni ŋga ndaŋ a chəɨŋ Kaisharia, lɨʼɨ ŋa Kɔniliu ni nthɔ njwɛrɛ vi pugu pa lǐŋ pi, pugu pa taannu pi ŋa a ni ŋgɛ̄ vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ndɨɨ ŋa Pita ni ntāʼa nu nii nda nɛ, Kɔniliu paoŋ pugu yu ŋgū shhɨ yu, ŋgaʼo vi. ");
INSERT INTO bmo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ndɔ Pita pɨʼɨ vi tɔthɨ, nchhu nu ŋa, “Lɔllɔ tɔthɨ mummu wuʼɔ ŋoŋmishua ŋkaa mu.” ");
INSERT INTO bmo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita gha nchrā pugu yu nɛ, nii nda njəɨ ntou ŋgwa kɨrɨ fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita chhu ni pugu ŋa, “Pəɨ ji ni noŋ yəɨ ŋa a lɔ mbie ŋa ŋoŋ Juu kra, ki nchīri pugu pa ŋgwa taoŋ nduoŋ. Ndɔ Minnwi nōoŋ vəɨ ŋa kiʼi ǹdīi yichəɨ ŋoŋ ŋa a lɔ njiʼi mbɔ yi taoŋtaoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nthɛ yie ghɔ, ndɨɨ ŋa ɔ ni māʼaŋ ŋkɨ̀nɨ mɛ̄iŋ a nɛ, ǹthɔ ki lɔ njiʼi ŋkɔ̄rɔ, nɛnnɛ, m̀bie vəɨ nɛ ndwɛ ŋa ti pəɨ ni mɛ̄iŋ a pi ŋa?” ");
INSERT INTO bmo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔniliu khwɛ̄ ŋa, “A khwɛ llɛmbhi shiʼa wuʼɔ moŋ ndɨɨ yei ŋa mi ni nthɔ nduoŋ Minnwi nda mu moŋ trɛi minaoŋ ni naoŋchɨ. Ŋga njəɨ yichəɨ ŋoŋ thi shhɨ mu ndhwí yi thɔ nchiachia, ");
INSERT INTO bmo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","nchhu ŋa, ‘Kɔniliu, Minnwi yaʼo luoŋ yɔ ndɔ ŋkwiŋ pwapuŋ yɔ. ");
INSERT INTO bmo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Fɛ ntaoŋ Jopa ŋgɛ̄ Shemu ŋa pi mɛ̄iŋ vi ŋa Pita, ŋa a thɔ ndaʼa nu nda ŋoŋ chəɨ, ligi yi pɔ Shemu, ŋkɨŋ mmɛ ŋkhǐ, mbɔ ŋgaŋ chwīe ŋgrào nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nɛnnɛ, ǹtaoŋ ŋoŋ vɛ wuʼɔ ndɨɨ ghɔ, ɔ ya ndɔ nchwīe a pwa nɔ haʼaŋ ɔ thɔ nɛ. Nɛnnɛ, pigi kɨrɨ hɛiŋ ndwɛ shhɨ Minnwi nɔ yaʼo nu ŋguoŋ pa nnu ŋa Taathɔ chhu vɛ ŋa ɔ chhu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita jɛ̄ chrà nu nchhu ŋa, “Shishini, ǹja njəɨ ndwɛ ŋa Minnwi shiʼa nōoŋ shieligi ");
INSERT INTO bmo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","A ghà mbiŋ shesheŋoŋ ŋa a pɔgɔ vi ndɔ nchwīe nnu ŋa a kāʼo nɛ, ki lɔ ndīi ŋa a llɔ pi moŋ yəɨ laʼataoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Pəɨ ji ŋkɨ̀nɨ ŋa a ni ntaoŋ ni ŋgwa Ishrae nɛ, nthɔ nchīi pwa pishaʼakhɔ taʼaŋggi, ntɔgɔ pi mbhɔ Jishɔ Krishto ŋa a Taathɔ ŋguoŋ ŋgwa nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Pəɨ ji mmɛ nnu ŋa a ni ndɔ̄gɔ lɨʼɨ moŋ ŋguoŋ Judia, jɛ̄ Galili, ndɨɨ ŋa Jouŋ ni ŋkwo jɛ̄ chīi nu chrà Minnwi ŋa ŋgwa pāʼa ŋkǔnu yugu ni phɨ a kwe vugu ni ŋkhǐ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pəɨ ji Jishɔ llɔ Nasharɛ, ŋkwaŋ haʼaŋ Minnwi ni nshwiʼi Jijwɛ yi pugu pa ghrɨ́ mbɨŋ yu nɛ. A ghə̄ɨ ŋguoŋ lɨʼɨ nchhɔ nchwīe pa nnu shiʼi nchhɔ njɨ̄gɨ ghɨ̌nɔ ŋgwa pɛ ŋa Shata ni nthɔ mfɛ ŋgəʼɨ ni pugu nɛ, nthɛ ŋa Minnwi ni mbɔ pugu yu. ");
INSERT INTO bmo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Pigi pɔ pi pa miŋkwentie ŋguoŋ nnu pei ghao ŋa a ni nchwīe moŋ laʼataoŋ pa ŋgwa Juu pugu Jerushalɛiŋ nɛ. Pi jwi vi ntɔgɔ pi nɔ kwīŋ nu vi ŋkuoŋ wáʼa. ");
INSERT INTO bmo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ndɔ a gha ndaʼa trɛi llɛ́, Minnwi pɨnɨ mbɨʼɨ vi moŋ gu, nchwīe a nōoŋ noŋ yi, ");
INSERT INTO bmo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ndɔ ki lɔ nōoŋ pi ni ŋguoŋ ŋgwa, ŋkiɛŋ pigi mbɔ pa miŋkwentie ŋa Minnwi ni nchuʼɔ vigi, mbɔ pigi yɛ ŋa pigi pugu ni njɨ maoŋ ndɔ nnu nu kaʼa ndɨɨ ŋa a ni ŋkwo kuʼɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","A fɛ gɨ́ ni pigi ŋa pigi chīi ŋkɨ̀nɨ pwa pishaʼakhɔ ni ŋgwa, ndɔ nchhu ni pugu ŋa a ju mbɔ ŋoŋ ŋa Minnwi chuʼɔ vi nɔ ŋoŋ ŋa a lɛ nshaʼa ŋgwa maoŋ pugu pa ŋgwa khu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ŋguoŋ pa njəɨlɨʼɨ Minnwi ghao ni nchrā nthɛ vi, nchhu nu ŋa, ‘Ŋguoŋ ŋgwa ŋa pugu piŋ vi nɛ, Minnwi shi ndīʼɛ phɨ yugu ntɔgɔ pi ŋkuoŋ ghrɨ́ Jishɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ni ŋga ŋguʼɔ nchrā nu, Jijwɛ Minnwi shwiʼi mbɨŋ ŋguoŋ ŋgwa pɛ ŋa pugu ni nthɔ njaʼo ŋkɨ̀nɨ yei nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pa ŋgwa Juu llɔ Jopa ŋa pugu ni mbiŋ Minnwi ŋa pugu ni nthɔ pugu pa Pita nɛ ghrāo ŋa Minnwi shwiʼi fɛ́ yi, mbɔ Jijwɛ yi, mbɨŋ ŋgwa taoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nthɛ ŋa pugu yaʼo pugu chrā nu moŋ pa chrà taoŋ nduoŋ nthɔ ŋgaʼo Minnwi. Nnɛ Pita chhu kiʼɛ ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Yichəɨ ŋoŋ nuʼuŋ mbɔ ŋa mimfɛ a lāa ŋa kiʼi ŋgwa pei kwe ŋkhǐ, haʼaŋ Jijwɛ Minnwi shwiʼi mbɨŋ pugu wuʼɔ nɔ haʼaŋ a ni nshwiʼi mbɨŋ pia nɛ?” ");
INSERT INTO bmo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","A fɛ gɨ́ ŋa pi kwe vugu ni ŋkhǐ moŋ ligi Jishɔ Krishto. Nnɛ, pugu chhu ghɔ ŋa pugu laʼa nɔ shɨgɛi llɛ́. ");
INSERT INTO bmo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ndwɛ, pa ghaŋ ntaoŋ Jishɔ pugu pa pichəɨ ghaŋ piŋ moŋ Judia yaʼo ŋa pa ŋgwa taoŋ nduoŋ piŋ chrà Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita ni ŋga ŋgə̄ɨ Jerushalɛiŋ, pichəɨ ŋgwa Juu ŋa pugu ni mbiŋ Jishɔ nɛ chhu ŋa Pita chwīe paʼa a lɔ ŋkāʼo ");
INSERT INTO bmo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","mbie nu ŋa, “A ni nchwīe khɔ ɔ ghə̄ɨ nda ŋgwa haʼaŋ pi lɔ niʼiŋ vugu ŋgunu mbrɛi nɛ, ti njɨ pi maoŋ pəɨ pugu?” ");
INSERT INTO bmo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ndɔ Pita jɛ̄ fɨ̄ʼɨ nu ni pugu ŋguoŋ nnu ŋa a ni ndɔ̄gɔ lɨʼɨ nɛ moŋ lɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mi ni mbɔ Jopa nthɔ nduoŋ Minnwi, Minnwi nduthɔ yi nōoŋ nnu vəɨ, njəɨ yaoŋ, a shwiʼi nu shhɛ nɔ mbhɔ ndhwí nshwiʼi nu ni khwɛ ghaa llɔ po, nthɔ ntithi yəɨ mu. ");
INSERT INTO bmo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ŋ̀ga ndīi moŋ ghɔ shiʼi, njəɨ pa mimaoŋ mooŋ laʼa pugu pa mimaoŋ mooŋ trǔ, pa mimaoŋ shatei pugu pa mishi mooŋ ŋgunu. ");
INSERT INTO bmo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ǹjaʼo yichəɨ ŋggì chhu ŋa, ‘P̂ita, lɔllɔ njwi ŋkru.’ ");
INSERT INTO bmo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ndɔ ŋ̀khwɛ̄ ŋa, ‘Ŋga, ma Taathɔ! Pa maoŋ fuo ki maoŋ nchhí lɔ naa ma nii nchò mu yaʼa.’ ");
INSERT INTO bmo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ŋggì ghɔ pɨnɨ nchrā mbara ŋgɛ́ nchhu ŋa, ‘Kiʼi mɛ̄iŋ yaoŋ ŋa Minnwi chwīe a pɔ yi taoŋtaoŋ nɛ ŋa a yaoŋ nchhí.’ ");
INSERT INTO bmo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yei nnu ni ndɔ̄gɔ lɨʼɨ nɔ trɛi ŋgɛ, pi pɨnɨ nshūu ŋguoŋ maoŋ pighɔ ŋkuʼɔ nɔ ghɔ po. ");
INSERT INTO bmo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Wuʼɔ ndɨɨ ghɔ trɛi ŋgwa chəɨŋ nda ŋa pigi ni mbɔ nɛ, pi taoŋ vugu vəɨ llɔ Kaisharia. ");
INSERT INTO bmo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jijwɛ Minnwi chhu vəɨ ŋa pigi pugu ghə̄ɨ kaʼa, kiʼi ǹjiʼi ndōu. Pigi pa ntɨgao ghaŋ piŋ pei ghə̄ɨ nda ŋoŋ ghɔ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","A chhu ni pigi ŋkwaŋ haʼaŋ a ni njəɨ ŋgaŋ ntaoŋ Minnwi, a thi nda yu, nchhu nu ghɔ ŋa, ‘Taoŋ ŋgwa Jopa mɛ̄iŋ Shemu ŋa pi mɛ̄iŋ vi ni Pita nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A shi māʼaŋ ŋkɨ̀nɨ vɛ ŋa ɔ shi ŋkie fɔ ndūgu, pəɨ pa mbaanda yɔ.’ ");
INSERT INTO bmo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Nɔ haʼaŋ mi ni njɛ̄ chrà nu nɛ, Jijwɛ Minnwi shwiʼi mbɨŋ pugu wuʼɔ ŋkwaŋ haʼaŋ a ni nshwiʼi mbɨŋ pia nɔ njɛ̄ yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nnɛ ŋ̀kwiŋ chrà Taathɔ, ŋkwaŋ haʼaŋ a ni nchhu ŋa, ‘Kwe ŋkhǐ Jouŋ ni mbɔ pi moŋ ŋkhǐ, ndɔ pəɨ shi mfāʼo kwe ŋkhǐ moŋ Jijwɛ Minnwi.’ ");
INSERT INTO bmo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ti ä mbɔ ŋa Minnwi wuʼɔ mfɛ pi taʼa fɛ́ ghɔ ni pugu nɔ haʼaŋ a ni mfɛ ni pia ndɨɨ ŋa pia ni mbiŋ Jishɔ Krishto mbɔ Taathɔ nɛ, m̀bɔ nyaŋ pi gɔ̌ ŋa ŋ̀kaŋ ni nthɛ m̀bɔ kɨʼɨŋgɨnɨ ni Minnwi?” ");
INSERT INTO bmo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pugu ni ŋga njaʼo yei nnu, nchò yugu chri pugu ghaʼo Minnwi, nchhu nu ŋa, “Minnwi fɛ shɨ̀na ni ŋgwa taoŋ nduoŋ ŋkaa pugu ŋa pugu pāʼa ŋkǔnu yugu ni phɨ mfāʼo chɔmbhi.” ");
INSERT INTO bmo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ndwɛ pa ghaŋ piŋ pɛ ŋa pugu ni nsha nthɛ ŋgəʼɨ ŋa pi ni mfɛ nu ni ghaŋ piŋ ndɨɨ ŋa pi ni njwi Shitifiŋ nɛ, ghə̄ɨ ti nchəɨŋ Fonishia, Shaipru ni Antiɔ, nthɔ nshwei chrà Minnwi wuʼɔ ni pa Juu. ");
INSERT INTO bmo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ndɔ pichəɨ ghaŋ piŋ llɔ Shaipru pugu Shiriŋ ghə̄ɨ Antiɔ nshwei chrà pwa pishaʼakhɔ nthɛ Jishɔ Taathɔ ni pa ŋgwa taoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mbhɔ Taathɔ ni mbɔ mbɨŋ pugu, ŋkiɛŋ ntou ŋgwa piŋ ŋkara mfɛ noŋ yugu ni Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pishaʼakhɔ pei nyīeŋ nchəɨŋ moŋ chɔshi Jerushalɛiŋ, nnɛ pugu taoŋ Banaba Antiɔ. ");
INSERT INTO bmo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","A ni ŋga nthɔ njəɨ fɨʼɨ ŋkwaŋ nɔ haʼaŋ Minnwi nōoŋ pwapuŋ yi ni pugu nɛ, mfāʼo pwatua māʼaŋ ghrɨ́ yugu ŋa pugu ghə̄ɨ shhɨ ŋkɨna ni taʼanjuʼɔ moŋ mieŋ nu noŋ yugu ni Taathɔ, ");
INSERT INTO bmo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","nthɛ ŋa Banaba ghɔ ni mbɔ pi ŋkiɛŋ ŋoŋ ndɨnaoŋ ni Jijwɛ Minnwi ndɔ ntɨnɨ moŋ piŋ. Nnɛ, ntou ŋgwa piŋ Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nnɛ, Banaba ghə̄ɨ Tashɔ nɔ līi nu Shɔɔ, ");
INSERT INTO bmo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ŋga njəɨ vi, ndɔ̄gɔ vi ŋgə̄ɨ nɔ Antiɔ, nɔ ŋguoŋ taʼa ŋgaʼo ghɔ, pugu pi paa paoŋ pugu pa ghaŋ chɔshi ghɔ, njɛʼi ŋkiɛŋ mmɛ kɨrɨ ŋgwa fɔ. A ni mbɔ pi Antiɔ ŋa pi fǔoŋ mɛ̄iŋ ghaŋ piŋ ni Krishitɛŋ. ");
INSERT INTO bmo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Moŋ pɨɨ ndɨɨ ghɔ, pichəɨ pa njəɨlɨʼɨ Minnwi llɔ Jerushalɛiŋ ŋgə̄ɨ Antiɔ. ");
INSERT INTO bmo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Taʼa ŋoŋ shɨna pugu, ligi yi pɔ Agabu, lɔllɔ, Jijwɛ Minnwi nōoŋ ghɔ a chhu ŋa, ŋkiɛŋ mmɛ njì shi ŋgū moŋ ŋguoŋ mbhi. Njì ghɔ ni ŋgū ndɨɨ ŋa Klaudiu ni nthɔ nshaʼa ŋguoŋ mbhi Roma nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pa ghaŋ younjiŋ Jishɔ lɔ̄gɔ nthi muŋu ŋa pugu shi ntaoŋ ghɛ̀rɛ fɨʼɨ ŋkwaŋ haʼaŋ shesheŋoŋ vugu fāʼo nɛ, nɔ ghɛ̄rɛ nu pichəɨ ghaŋ piŋ nɔ moŋ Judia. ");
INSERT INTO bmo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nɛnnɛ, nchuʼɔ ghɛ̀rɛ ghɔ ntaoŋ ni Banaba pugu Shɔɔ ŋa pugu fɛ ni pa thishɨ chɔshi ghɔ Judia nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Moŋ pɨɨ ndɨɨ ghɔ, fùoŋ Hɛrɔ jɛ̄ nthɔ mfɛ ŋgəʼɨ ni pichəɨ ghaŋ chɔshi. ");
INSERT INTO bmo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A ni njwi Jɛiŋ, mbɔ ndǐŋ Jouŋ, ni kafa. ");
INSERT INTO bmo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ni ŋga njəɨ ŋa nnu ghɔ pwa ŋgwa Juu, a ghə̄ɨ ŋgwɛ̄iŋ Pita ŋkaa yu. Yei ni mbɔ moŋ ndɨɨ jɨ Jɨ Brɛi ki Kuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A ni ŋga ŋgwɛ̄iŋ vi, niʼiŋ chə́ɨŋ, mfɛ vi fɔ ni khwɛ kwíe pa khwɛ shoogɛ ŋa pugu thɔ ŋkɛ̄ʼi vi. Hɛrɔ ni ŋkāʼa nu nɔ shaʼa nu vi shhɛnte ndɨɨ ŋa Jɨ Lli Njiʼa tɔgɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nnɛ, pi ni niʼiŋ Pita chə́ɨŋ, chɔshi luoŋ Minnwi ki jwɛ mfɛ nu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A gha mbɔ ni tuʼu yɛ ŋa Hɛrɔ ni mbɔ nɔ fuʼu nu vi nɛ, Pita ni nūaŋ shɨna paa shoogɛ, pi krao vi ni paa chɛiŋ, pa ghaŋ kɛ̄ʼi chə́ɨŋ thi choŋkaʼa chə́ɨŋ nthɔ ŋkɛ̄ʼi nu. ");
INSERT INTO bmo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ŋga njəɨ nu, ŋgaŋ ntaoŋ Taathɔ nōoŋ noŋ yi moŋ chə́ɨŋ ghɔ, líʼɛ thɛ moŋ njiɛŋ chə́ɨŋ ghɔ. Ŋgaŋ ntaoŋ Minnwi kwaʼa Pita nɔ mbru yi, mbɨʼɨ vi tɔthɨ nchhu ghɔ ŋa, “Kɔnɔ ndɔllɔ!” Wuʼɔ ndɨɨ ghɔ pa chɛiŋ pighɔ taoŋ nɔ mbhɔ Pita. ");
INSERT INTO bmo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nnɛ ŋgaŋ ntaoŋ Minnwi ghɔ chhu ghɔ ŋa, “Krao ŋkandaŋ yɔ, ŋgwɛ tra yɔ.” Pita chwīe nnɛ. Ŋgaŋ ntaoŋ Minnwi pɨnɨ nchhu ŋa, “Māʼaŋ mmɛ ndhwí yɔ nthɔ pɔgɔ ghə̄ɨ.” ");
INSERT INTO bmo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita lɔllɔ ntaoŋ njōu njiŋ yi, a shini ndɔ nji ŋa nnu ŋa ŋgaŋ ntaoŋ Minnwi ghɔ ni nchwīe nu nɛ ni mbɔ pi ŋkiɛŋ nnu, a ni ŋgɛ̄ ŋa a thɔ njəɨ pi nnu. ");
INSERT INTO bmo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pugu ni ŋga ntaoŋ ti mfərə fǔoŋ ŋgaŋ kɛ̄ʼi lɨʼɨ pugu mbra yi, ŋgə̄ɨ nchə́ɨŋ choŋkaʼa tɨ́nɨ ŋa a ni nii moŋ laʼa nɛ, choŋkaʼa ghɔ chuʼɔ ni nōoŋ yi. Pugu taoŋ nyīeŋ shwiʼi nu shɛndaoŋ chəɨ, ndɨɨ ghɔ ŋgaŋ ntaoŋ Minnwi ghɔ mieŋ vi. ");
INSERT INTO bmo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Lɨna Pita kwəɨ kiʼɛ a chhu ni noŋ yi ŋa, “Ndwɛ, ǹji shini ŋa Taathɔ taoŋ ŋgaŋ ntaoŋ yi ŋa a thɔ ŋkwe a mbhɔ Hɛrɔ pugu pa ŋguoŋ nnu pɛ ŋa ŋguoŋ ŋgwa Juu ni mbīʼi nu ŋa a shi ndɔ̄gɔ lɨʼɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Thɔ yi ni ŋga nja nshie ni nnu yɛ ŋa a lɔ̄gɔ lɨʼɨ mbɨŋ yu nɛ, a ghə̄ɨ laʼa Meri mǔuŋ Jouŋ Maaku, lɨʼɨ ŋa ntou ŋgwa ni ŋkɨrɨ nchhɔ nduoŋ Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","A ni ŋkwēi chonda ŋkaʼa mbhi, muuŋ fàʼa nda ghɔ mbɔ Rɔda thɔ lɨʼɨ chuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ŋga njaʼo a pɔ ŋggì Pita, a fāʼo ntou pwatua ki lɔ nuʼuŋ nchuʼɔ choŋkaʼa, ntei mbɨnɨ nda, nshwei ŋgwa ŋa Pita thi nɛ mbhi. ");
INSERT INTO bmo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pugu chhu ghɔ ŋa, “Ɔ ya mbɔ pi lɨ̀lɨŋ.” A tīi ŋa nnu ŋa a chhu nu nɛ yie ghɔ, pugu chhu kiʼɛ ŋa, “Kaŋ a pɔ pi ŋgaŋ ntaoŋ Minnwi ŋa a ghà ŋkɛ̄ʼi vi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ndɔ Pita wuʼɔ nchhɔ ŋkwēi kwēi, pugu gha nchuʼɔ njəɨ a pɔ ju nɛ, pugu ghrāo pɨphɨ. ");
INSERT INTO bmo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","A nōoŋ ni mbhɔ yi ŋa p̂ugu lɛrɛ laŋ, mfɨ̄ʼɨ ni pugu ŋkwaŋ haʼaŋ Taathɔ mfuʼu vi moŋ chə́ɨŋ nɛ, ndɔ nchhu ni pugu ŋa, “Pəɨ shwei Jɛiŋ pugu pa pichəɨ ghaŋ piŋ ni nnu pei.” A lɔllɔ kiʼɛ ŋga ntaoŋ mbhi ŋgə̄ɨ lɨʼɨ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mbhi ni ŋga ndaŋ, thɔ ŋguoŋ ghaŋ kɛ̄ʼi chə́ɨŋ vuʼu ni nnu ŋa a lɔ̄gɔ lɨʼɨ mbɨŋ Pita nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hɛrɔ fɛ gɨ́ ŋa pi taʼa vi, ndɔ pi tāʼa vi kie. Nthɛ yie ghɔ, a tou pa ghaŋ kɛ̄ʼi chə́ɨŋ pighɔ, mfɛ gɨ́ ŋa pi jwi vugu. Nnɛ Hɛrɔ ghɔ lɔllɔ Judia ŋgə̄ɨ ndaʼa Kaisharia nɔ yichəɨ fɨʼɨ ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hɛrɔ ni mfāʼo pɨgɨtua mbɨŋ pa ghaŋ Tairɛ pugu Shidoŋ. Ŋgwa pei chrà ntaoŋ ni taʼaŋggi ŋa pugu ghə̄ɨ njəɨ Hɛrɔ, mfǔoŋ ŋgə̄ɨ ndɨ̄gəɨ Blashitu mbɔ taʼa mmɛŋoŋ shɨna pa ŋgwa ŋa pugu ni nthɔ ndɨna nu ni ntuʼɔ nɛ ŋa a ghɛ̄rɛ vugu. Nɛnnɛ pugu ghə̄ɨ mbara Hɛrɔ ndɨ̄gəɨ vi ŋa pugu pugu lūgwi nthɛ ŋa laʼa yugu ghà mfāʼo maoŋ pi llɔ laʼataoŋ fùoŋ Hɛrɔ. ");
INSERT INTO bmo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A ni ŋga mbɔ llɛ́ ŋa pi ni ntigi ŋa pugu pugu paoŋ nɛ, Hɛrɔ māʼaŋ pɨ̀rɨ yi, nchhɔ ŋkuoŋ faaŋ yi, mfɛ chrà ni ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ŋgwa paʼo ŋgòu ŋa, “A lɔ njiʼi mbɔ pi ŋggì ŋoŋmishua, a pɔ pi ŋggì nnwi!” ");
INSERT INTO bmo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wuʼɔ ndɨɨ ghɔ ŋgaŋ ntaoŋ Taathɔ wie vi a gū shhɛ nthɛ ŋa a shini ndɔ mfɛ ndighaʼo ni Minnwi. Pa ŋgɨŋgɨɨ ni ŋkru vi, a khu. ");
INSERT INTO bmo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ndɔ chrà Minnwi nyīeŋ mbīgi ŋgə̄ɨ nu shhɨ ŋgwa piŋ mbīgi nu. ");
INSERT INTO bmo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba pugu Shɔɔ ni ŋga mīʼɛŋ fàʼa yugu, ndɔ̄gɔ Jouŋ Maaku pugu pugu pɨ̄nɨ llɔ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Moŋ chɔshi Antiɔ, pa pichəɨ pa njəɨlɨʼɨ Minnwi pugu pa masha ni mbɔ fɔ. Ɔ ni mfāʼo Banaba, Shimioŋ, ŋa pi ni mɛ̄iŋ vi ni Yishhi nɛ, Lushiɔ llɔ Shiriŋ, Maneŋ, ŋa a ni ŋkuʼɔ pugu Hɛrɔ ŋa a shaʼa krao Roma nɛ, ni Shɔɔ. ");
INSERT INTO bmo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ndɨɨ ŋa pugu ni nthɔ ŋgaʼo Taathɔ ndɔ njī ŋkhǐ nɛ, Jijwɛ Minnwi chhu ni pugu ŋa, “Chuʼɔ Banaba pugu Shɔɔ nūʼɔŋ vugu nɔ chwīe nu fàʼa ŋa ŋ̀gɛ̄ vugu ŋa pugu chwīe nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pugu jī ŋkhǐ ndɔ nduoŋ Minnwi, nūʼɔŋ mbhɔ yugu mbɨŋ pugu, ntaoŋ vugu kiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jijwɛ Minnwi gha ŋkwo taoŋ vugu, pugu ghə̄ɨ Shɛlushia, nshāʼa ŋkhǐ ntaoŋ Shaipru. ");
INSERT INTO bmo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pugu ni ŋga nchəɨŋ Shalami, nchīi chrà Minnwi moŋ pa nda luoŋ Minnwi pa Juu. Pugu ni ndɔ̄gɔ Jouŋ Maaku ŋa a ghɛ̄rɛ vugu ni fàʼa ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pugu ni ŋga nyīeŋ ŋguoŋ lɨʼɨ moŋ muuŋ ŋkǔnu ghɔ tri ŋkhǐ nɛ, ti nchəɨŋ Pafɔ, mbāoŋ pugu pa ŋgaŋ fhɔ̌ chəɨ, ligi yi pɔ Baa-Jishɔ, mbɔ ŋoŋ Juu ŋa a ni mbɔ njəɨlɨʼɨ mifɨɨ. ");
INSERT INTO bmo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A ni mbɔ nuʼɔŋthɔ Shɛgiu Pɔɔ, ŋa a ni nthɔ shaʼa Shaipru nɛ, ndɔ mbɔ ŋgaŋ lɨna nɛ. Ŋoŋ vei ni ŋgɛ̄ Shɔɔ pugu Banaba nthɛ ŋa a ni ntāʼa nu njaʼo chrà Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ndɔ Elima, mbɔ ntouŋgaŋ (nthɛ ŋa a njiŋ ligi yi), tāra vugu mbaʼo nu ŋa kiʼi ŋgaŋ shaʼa ŋgwa ghɔ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ndɔ Shɔɔ, ŋa pi ni mɛ̄iŋ vi ni Pɔɔ nɛ, ni ŋga ŋkwo lɨnaoŋ ni Jijwɛ Minnwi, nchaoŋ ligi yi mbɨŋ yu, ");
INSERT INTO bmo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nchhu ghɔ ŋa, “Ɔ muuŋ Shata, mbɔ mbɨ̌na ŋguoŋ nnu ŋa a yi ndɨndɨ nɛ. Ɔ lɨnaoŋ ni ŋguoŋ ŋkwaŋ mifɨɨ pugu pa nnu pɨphɨ. Ɔ ghà ŋguʼɔ ŋkɨna nchhɔ ŋkāa nu nɔ kara nu nnu shini Taathɔ a pɔ nɔ lɛʼiŋgiɛŋ! ");
INSERT INTO bmo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ndɔ līi njəɨ, mbhɔ Taathɔ gū nɛ mbɨŋ ghɔ, ɔ shi ŋgū nchriligi, ki lɔ nuʼuŋ njəɨ liʼɛ nɔ yichəɨ fɨʼɨ ndɨɨ.” Wuʼɔ ndɨɨ mbaʼa pugu pa njiŋnjiŋ gū mbɨŋ Elima, a nyīeŋ nthɔ ntāʼa ŋoŋ ŋa a wɛ̄iŋ mbhɔ yi nōoŋ ndaoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nɛnnɛ, ŋgaŋ shaʼa ŋgwa ghɔ piŋ Minnwi ndɨɨ ŋa a ni njəɨ nnu ŋa a lɔ̄gɔ lɨʼɨ nɛ, nthɛ ŋa a ni ŋgrāo pa nnu ŋa pi yɛʼi nɔ ligi Taathɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔ pugu pa pakwo pi shāʼa llɔ Pafɔ ntaoŋ Pega, mbɔ yichəɨ mmɛ lɨʼɨ Pamfilia. Jouŋ Maaku mieŋ vugu hɛnɛiŋ kəʼɨ ghɔ, mbɨ̄nɨ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ndɔ pugu tɔgɔ llɔ Pega ŋgə̄ɨ Antiɔ moŋ Pishidia. A gha mbɔ llɛ́ ji pa Juu, pugu ghə̄ɨ moŋ nda luoŋ Minnwi nchɔchhɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ndɨɨ ŋa pi ni ŋkwo mɛ̄iŋ Ŋwaʼaŋlɨ Gɨ́ ŋa Mushi ni nāʼaŋ nɛ, pugu pa yɛ ŋa pa Njəɨlɨʼɨ Minnwi ni nāʼaŋ nɛ, pa thishɨ moŋ nda luoŋ Minnwi māʼaŋ ŋkɨ̀nɨ ni pugu, nchhu nu ŋa, “Lǐŋ paŋ, p̈əɨ mfāʼo sheshe chrà nɔ māʼaŋ nu ghrɨ́ ŋgwa nɔ ghɔ, pəɨ chrā.” ");
INSERT INTO bmo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nɛnnɛ, Pɔɔ lɔllɔ tɔthɨ, nōoŋ ni mbhɔ yi nchhu ŋa, “Ŋgwa Ishrae pugu pa ŋgwa taoŋ nduoŋ ŋa pugu pɔgɔ Minnwi nɛ, pəɨ yaʼo nnu ŋa ǹchhu nu nɛ! ");
INSERT INTO bmo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","“Minnwi ŋgwa Ishrae ni nchuʼɔ pa tǎa pia nchwīe pugu yiɛŋ ndɔ ntɨnɨ ndɨɨ ŋa pugu ni ndaʼa nu Ijipti nɔ pa ghɨ̀nɨ nɛ, ndɔ Minnwi fuʼu vugu fɔ ni mbhɔ tɨtɨnɨ. ");
INSERT INTO bmo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","A ni ŋgwɛ̄iŋ njùʼɔ yi, ndɨna ni pugu nɔ khwɛ wuŋ ŋgaʼo moŋ ŋkǔnu njó. ");
INSERT INTO bmo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","A ni nchwīe pi pɨgɛi khwachəɨ taoŋ moŋ laʼataoŋ Kanaŋ, mfɛ shhɛ ghɔ ni ŋgwa pi nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ŋguoŋ nnu pei ni ndɔ̄gɔ lɨʼɨ nɔ khwɛ ŋkɨɨ ni tiɛŋ wuŋ ŋgaʼo. “Ndɨɨ yei ni ŋga ntɔgɔ, Minnwi chuʼɔ pa thishɨ mfɛ ni pugu ti ŋgə̄ɨ nchəɨŋ ndɨɨ njəɨlɨʼɨ Minnwi, mbɔ Shamuɛ. ");
INSERT INTO bmo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nɛnnɛ, pugu pie Minnwi ŋa a fɛ fùoŋ ni pugu, a fɛ Shɔɔ, muuŋ Kishi, ŋoŋ llɔ moŋ ŋgwrɛiŋoŋ Bɛnjamɛiŋ, a shaʼa nɔ fùoŋ vugu nɔ khwɛ wuŋ ŋgaʼo. ");
INSERT INTO bmo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Minnwi ni ŋga mbɨʼɨ vi, nūʼɔŋ Devi nɔ fùoŋ vugu. Yei pɔ nnu haʼaŋ Minnwi ni nchhu nthɛ Devi nɛ, ‘Ǹjəɨ ŋa Devi, muuŋ Jeshe ŋoŋ ŋa a ghà nchwīe njùʼɔ a pwa nɛ, mbɔ ŋoŋ ŋa a shi nchwīe ŋguoŋ nnu haʼaŋ ǹtāʼa nu ŋa a chwīe nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Wuʼɔ llɔ moŋ ŋgwrɛiŋoŋ Devi yei, Minnwi fɛ ŋkwe ni Ishrae mbɔ Jishɔ wuʼɔ nɔ haʼaŋ a ni ŋkāʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ŋkaoŋ Jishɔ maa njɛ̄ fàʼa yi, Jouŋ ni nchīi chrà Minnwi ni ŋguoŋ ŋgwa Ishrae ŋa pugu pāʼa ŋkǔnu yugu ni phɨ, a fɛ ŋkhǐ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nɔ haʼaŋ Jouŋ ni nthɔ mīʼɛŋ fàʼa yi nɛ, a pie ŋa, ‘Pəɨ pīʼi ŋa mi pɔ pi gɔ̌? Ǹdɔ njiʼi mbɔ ŋoŋ ŋa pəɨ ywɛrɛ nu nɛ. Vie ŋoŋ wuʼɔ mbɔ njiŋ nthɔ nu, paʼa ǹdɔ njiʼi ŋkāʼo nɔ kɨ̄gɛi nu ŋkɨɨ tra yi, mfuʼu nɔ kwò yi.’ ");
INSERT INTO bmo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Lǐŋ paŋ, mbɔ ndaaŋoŋ Abrahaŋ, pugu pa ŋguoŋ ŋgwa taoŋ nduoŋ ŋa pugu pɔgɔ Minnwi nɛ, pi taoŋ ŋkɨ̀nɨ yei ni pia ŋa a fɨʼɨ ŋkwaŋ haʼaŋ Minnwi kwe ŋgwa pi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nthɛ ŋa pa ŋgwa pɛ ŋa pugu laʼa nu Jerushalɛiŋ, pugu pa thishɨ pugu, shini ndɔ nji ŋa a Jishɔ vei mbɔ ŋkwe, ndɔ ki lɔ mfāʼo shiethɔ ŋkuoŋ chrà pa njəɨlɨʼɨ Minnwi ŋa pi ni mɛ̄iŋ nu ŋguoŋ llɛ́ ji nɛ, moŋ fɛ nu njɔ́ gu ghɔ, pugu ka chwiechwie chrà pa njəɨlɨʼɨ Minnwi pighɔ chəɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ti mfɛ pi nɔ haʼaŋ pugu shini ndɔ njəɨ sheshe fàŋ mbɨŋ yu ŋa a pie ŋa pi jwi vi nɛ, pugu wuʼɔ nchuchu ni Pailɛ ŋa a chwīe pi jwi vi. ");
INSERT INTO bmo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Pugu ni ŋga ŋkwo chwīe ŋguoŋ pa nnu haʼaŋ chrà Minnwi ni nchhu nthɛ vi nɛ ti mīʼɛŋ, nshwiʼi vi ŋkuoŋ wáʼa, niʼiŋ vi moŋ fúŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ndɔ Minnwi kuʼɔ ni ju moŋ gu, ");
INSERT INTO bmo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","nɔ pa ntou llɛ́, a nōoŋ noŋ yi ni pa ŋgwa pɛ ŋa pugu pugu ni ndhɔ Galili nthɔ Jerushalɛiŋ nɛ, mbɔ pa ŋgwa pɛ ŋa pugu pa miŋkwentie pi ndwɛ ni ŋgwa Ishrae nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Pigi thɔ ndwɛ ni ŋkɨ̀nɨ pwa pishaʼakhɔ ni pəɨ, ŋa nnu ŋa Minnwi ni ŋkāʼa ni pa ŋkhu tǎa pigi ŋa a shi nchwīe nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","a chwīe nɛ ni pigi, mbɔ pa puoŋ pugu, ŋkie pi ŋkuoŋ kuʼɔ nu ni Jishɔ moŋ gu. Wuʼɔ nɔ haʼaŋ pi nāʼaŋ moŋ mbra njiɛŋ Ŋwaʼaŋlɨ Ŋkhǐ ŋa, ‘Ɔ Muuŋ a, shiʼa ŋ̀gū Tǎa ghɔ.’ ");
INSERT INTO bmo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yei pɔ pi nnu ŋa Minnwi chhu nthɛ kuʼɔ nu ni ju moŋ gu ki a lɔ njiʼi mfɔ̄rɔ moŋ fúŋ nɛ: ‘Ǹshi mfɛ mbɔrɔ taoŋtaoŋ, mbɔ yi kàʼa ki fɨ̄ɨ, ŋa ŋki ŋkāʼa Devi nɔ nɛ vɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Wuʼɔ nɛnnɛ, a chhu moŋ yichəɨ lɨʼɨ Ŋwaʼaŋlɨ Ŋkhǐ ŋa, ‘Mbaʼa ɔ yiʼi mieŋ Muuŋ Fàʼa yɔ yi Taoŋtaoŋ fɔ̄rɔ moŋ fúŋ.’ ");
INSERT INTO bmo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nthɛ ŋa Devi ni ŋga mfāʼa fàʼa ŋa Minnwi ni nūʼɔŋ ŋa a fāʼa nɛ, moŋ ndɨɨ ŋa a ni mbɔ ŋkuoŋ mbhi nɛ ti mīʼɛŋ nɛ, ŋkhu, pi twei vi lɨʼɨ haʼaŋ pi ni ntwei pa tǎa pi nɛ, a fɔ̄rɔ moŋ fúŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ndɔ ju ŋa Minnwi ni ŋkuʼɔ nɔ moŋ gu nɛ shini ndɔ mfɔ̄rɔ. ");
INSERT INTO bmo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Nthɛ yie ghɔ, ma lǐŋ paŋ, a pie ŋa pəɨ ji ŋa ntɔgɔ njiŋ Jishɔ vei, pi chīi ŋkɨ̀nɨ līʼɛ phɨ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ndɔ ntɔgɔ pi mbhɔ yu, shesheŋoŋ ŋa a piŋ nɛ shi ndūgu moŋ ŋguoŋ phɨ ŋa a kaŋ ni nthɛ paʼa gɨ́ Mushi lɔ ndūgu ni ju moŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pəɨ lɨna nu nɛ ŋa kiʼi pa nnu haʼaŋ pa njəɨlɨʼɨ Minnwi ni nchhu nɛ lɔ̄gɔ lɨʼɨ mbɨŋ pəɨ: ");
INSERT INTO bmo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Līi njəɨ, pa ghaŋ nchɨʼəshə, p̂əɨ ghrāo ndɔ ŋkhu, nthɛ ŋa nnu haʼaŋ ǹchwīe nu shiʼa, a kaŋ ni fɛ paʼa pəɨ lɔ mbiŋ nɔ haʼaŋ pi kaŋ ni ndɔ nchuchu ni pəɨ ŋa a shi mbɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nɔ haʼaŋ Pɔɔ pugu Banaba ni ntaoŋ nu moŋ nda luoŋ Minnwi nɛ, pa ŋgwa pighɔ lɨ̄gəɨ vugu ŋa pugu pɨnɨ mbɨnɨ llɛ́ ji kaʼashiʼa, mfɨ̄ʼɨ mooŋ nnu pei ni pugu ŋgə̄ɨ shhɨ. ");
INSERT INTO bmo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ndɨɨ ŋa pi ni nshāaŋ moŋ nda luoŋ Minnwi nɛ, ntou pa ŋgwa Juu pugu pa ŋgwa taoŋ nduoŋ, ŋa pugu ni ŋkara mbiŋ nnu Minnwi pa Juu nɛ, yōu njiŋ Pɔɔ pugu Banaba. Pɔɔ pugu Banaba chrā ni pugu nthɔ ŋkwɛ̄nɛ vugu ŋa pugu ghə̄ɨ shhɨ nthɔ njɨʼə noŋ yugu ŋkuoŋ pwapuŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mbra llɛ́ ji nduoŋ ni ŋga nthɔ, a piʼi shɨgɛi yi ŋguoŋ ŋgwa moŋ laʼataoŋ ghɔ thɔ lɨʼɨ yaʼo chrà Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pa ŋgwa Juu ni ŋga njəɨ yú ŋgwa pighɔ, ndɨnaoŋ ni kighɨʼə, ndāa nnu ŋa Pɔɔ ni nchhu nu nɛ ndɔ ŋgwɛʼi vi. ");
INSERT INTO bmo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ndɔ Pɔɔ pugu Banaba chrā ni tɨnɨnjuʼɔ, nchhu nu ŋa, “A ni mbie ŋa pi fǔoŋ nchhu chrà Minnwi pi ni pəɨ. Ndɔ ndwɛ ŋa pəɨ lāa, ki lɔ ndīi noŋ pəɨ ŋa pəɨ kāʼo nɔ fāʼo nu chɔmbhi ki mmɛ nɛ, pigi shi mieŋ vəɨ ŋkara nchhu ni ŋgwa taoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nthɛ ŋa a haʼaŋ Taathɔ fɛ gɨ́ ni pigi nɛ, nchhu nu ŋa, ‘Ǹūʼɔŋ vəɨ ŋa pəɨ pɔ líʼɛ ni pa ŋgwa taoŋ nduoŋ, nɛnnɛ ŋa a nthɛ pəɨ ghə̄ɨ ni lūgu nu ti nchəɨŋ ŋguoŋ lɨʼɨ ghao ŋkuoŋ mbhi.’ ” ");
INSERT INTO bmo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pa ŋgwa taoŋ nduoŋ ni ŋga njaʼo yei, mfāʼo pwanjuʼɔ, ŋgaʼo chrà Taathɔ. Nnɛ, pa ŋgwa pɛ ŋa Minnwi ni ŋkwo chuʼɔ vugu ŋa pugu fāʼo chɔmbhi ki mmɛ nɛ, gu pa ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chrà Taathɔ nyīeŋ moŋ ŋguoŋ yie ŋgei lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ndɔ pa Juu niʼiŋ puŋ pa mɛmmɛ piŋgɛ pugu pa thishɨ pimbia moŋ laʼataoŋ ghɔ, pugu jɛ̄ nthɔ mfɛ ŋgəʼɨ ni Pɔɔ pugu Banaba, njōu vugu moŋ yugu lɨʼɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ndɔ pugu krū pru nɔ kwò muŋu nɔ fɛ nu nduoŋ yugu thɔ pugu, ŋgə̄ɨ kiʼɛ Ikoniuŋ. ");
INSERT INTO bmo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pa ghaŋ piŋ moŋ Antiɔ ni ndɨnaoŋ ni pwanjuʼɔ pugu pa Jijwɛ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pa nnu ni ndɔ̄gɔ lɨʼɨ Ikoniuŋ wuʼɔ nɔ haʼaŋ a ni mbɔ Antiɔ nɛ, Pɔɔ pugu Banaba nii moŋ nda luoŋ Minnwi nja nchrā ni pugu shishiʼi, nnɛ, ŋkiɛŋ ntou ŋgwa Juu pugu pa ŋgwa taoŋ nduoŋ gū ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ndɔ pa ŋgwa Juu ŋa pugu ki lāa ki lɔ mbiŋ nɛ niʼiŋ puŋ pa ŋgwa taoŋ nduoŋ, nnɛ pugu fāʼo kipɨna mbɨŋ pa ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nɛnnɛ, pugu kɨna fɔ nɔ ntaaŋ ndɨɨ nthɔ nshwei chrà Taathɔ ni tɨnɨnjuʼɔ. Taathɔ nōoŋ ŋa ŋkɨ̀nɨ yugu nthɛ pwapuŋ yi nnu shini, ntɔgɔ pi ŋkuoŋ pa lì, pugu pa nnu ghraoghrao ŋa a ni mfɛ njɨ ni pugu pugu chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ndɔ pa ŋgwa laʼataoŋ ghɔ thi pi nduoŋnduoŋ, pichəɨ thi yugu njiŋ pa ŋgwa Juu ŋa pugu shini ndɔ mbiŋ nɛ, pichəɨ thi yugu njiŋ paa pa ghaŋ ntaoŋ Jishɔ pighɔ. ");
INSERT INTO bmo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nɛnnɛ, pichəɨ pa ŋgwa taoŋ nduoŋ pugu pa pichəɨ ŋgwa Juu chīri pugu pa thishɨ yugu ntaaŋ ŋa pi fɛ ŋgəʼɨ ni ghaŋ ntaoŋ Jishɔ ndɔ ntuŋ vugu ni ŋgùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pugu ni ŋga njaʼo, ntáŋ yugu ntei ŋgə̄ɨ Lishtra pugu Debi moŋ laʼataoŋ Likaonia pugu pa pichəɨ laʼataoŋ ŋkɨŋ lɨʼɨ ghɔ, ");
INSERT INTO bmo_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","nchīi ŋkɨ̀nɨ pwa pishaʼakhɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yichəɨ ŋkwíni ni mbɔ laʼataoŋ Lishtra ŋa pi ni mbhi vi kwò yi fāʼo ŋgəʼɨ paʼa a lɔ naa ma nyīeŋ. ");
INSERT INTO bmo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A ni nthɔ njwɛrɛ nnu ŋa Pɔɔ ni nchhu nu nɛ. Pɔɔ līi vi, njəɨ ŋa a fāʼo piŋ ŋa a nthɛ a chwīe a pɔ shiʼi nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","a chhu ghɔ ni njɨ ŋa, “Lɔllɔ ntithi tɔthɨ.” A lli ntithi, njɛ̄ nyīeŋ nu. ");
INSERT INTO bmo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Yú ŋgwa pighɔ ni ŋga njəɨ nnu ŋa Pɔɔ chwīe nɛ, ŋkə̄rə ŋggì yugu nchhu moŋ chrà Likaonia ŋa, “Pa nnwi gū nɛ shɨna pia, mbɔ nɔ ŋgwamishua!” ");
INSERT INTO bmo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Pugu mɛ̄iŋ Banaba ni Yeu, mɛ̄iŋ Pɔɔ ŋa Hemeshi, nthɛ ŋa a ni nthi ju shhɨ nchrā nu. ");
INSERT INTO bmo_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ŋgaŋ fɛ̄ʼi shhɨ nnwi Yeu ŋa nda nnwi ghɔ ni mbɔ mbara mbɨŋ moŋ laʼa nɛ, thɔ ni pa nàʼaŋ pimbia pugu pa frawa choŋkaʼa nthɛ ŋa pugu pa yú ŋgwa pighɔ ni ntāʼa nu fɛʼiŋgiɛŋ ni pa ghaŋ ntaoŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ndɔ pa ghaŋ ntaoŋ Jishɔ, mbɔ Banaba pugu Pɔɔ, ni ŋga njaʼo nnu ŋa pugu tāʼa nu nchwīe nɛ, nshāa ndhwí muŋu, ntei nii tri yú ŋgwa pighɔ mbaʼo ŋgòu, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Lǐŋ paŋ, pəɨ chwīe nɛiŋ nthɛ khɔ? Pigi ŋkaa pigi wuʼɔ pa ŋgwamishua nɔ pəɨ! Pigi pɔ hɛiŋ nɔ chīi nu pwa pishaʼakhɔ ni pəɨ, nɔ fuʼu nu vəɨ moŋ ŋguoŋ maoŋ mbɔmbɔnɔ pei, nnɛ ŋa pəɨ kara njəɨ Minnwi maoŋ, ŋa a chwīe po pugu shhɛ, ni ŋkhǐ pugu pa ŋguoŋ maoŋ ŋa a pɔ moŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Llɛshhɨ, a ni mieŋ ŋa pa taoŋ taoŋ chhɔ ŋkwaŋ nɔ haʼaŋ pugu ywɛrɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ndɔ a ghà ŋguʼɔ nōoŋ ŋa a pɔ fɔ ntɔgɔ pi ŋkuoŋ pa nnu shiʼi ŋa a ghà nchwīe nɛ, a ghà mfɛ mbɨ̀ llɔ po pugu pa maoŋ kwōo moŋ ndɨɨ haʼaŋ a kāʼo, mfɛ pa maoŋ jɨ ni pəɨ, ndɨnaoŋ njùʼɔ yəɨ ni pwatua.” ");
INSERT INTO bmo_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ni ŋguoŋ chrà pei, pa ghaŋ ntaoŋ Jishɔ wuʼɔ ntɔgɔ pi moŋ ghaghaʼa nɔ lɨʼɨ nu vugu ŋa kiʼi pugu fɛʼiŋgiɛŋ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ndɔ pichəɨ ŋgwa Juu llɔ Antiɔ moŋ Pishidia pugu pɔ Ikoniuŋ thɔ fɨ̄ɨ ŋgwa pighɔ pugu piŋ vugu, pugu pugu chīri ntuŋ Pɔɔ ni ŋgùʼɔ, nshūu vi ntaoŋ nɔ moŋ laʼataoŋ ghɔ ŋkwāʼa ŋa a khu. ");
INSERT INTO bmo_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ndɔ pa ghaŋ piŋ ni ŋga nthɔ ŋkɨrɨ yəɨ yu, a lɔllɔ tɔthɨ mbɨnɨ nii moŋ laʼataoŋ ghɔ. Mbhi gha ndaŋ, pugu Banaba ghə̄ɨ Debi. ");
INSERT INTO bmo_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔɔ pugu Banaba chīi pwa pishaʼakhɔ moŋ laʼataoŋ Debi ntou pa ŋgwa piŋ Jishɔ. Nnɛ pugu pɨ̄nɨ Lishtra, ndhɔ fɔ mbɨnɨ Ikoniuŋ ŋkaoŋ maa mbɨnɨ Antiɔ kiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pugu māʼaŋ ghrɨ́ pa ghaŋ piŋ nchwīe nu ŋa pugu wɛ̄iŋ yaoŋ ŋa pugu piŋ nɛ tɨtɨnɨ, nchhu nu ŋa, “A yiʼi ŋa pia shi ŋguʼɔ ntɔgɔ moŋ ntou pa ŋgəʼɨ nɔ nii nu moŋ Shaʼafuoŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pugu ni ŋga ŋkwo chuʼɔ pa thishɨ moŋ sheshe chɔshi, moŋ luoŋ pugu pa jī ŋkhǐ, mieŋ vugu liɛŋ mbhɔ Taathɔ ŋa pugu ni mbiŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ntɔgɔ kəʼɨ ghɔ moŋ Pishidia ŋgə̄ɨ Pamfilia. ");
INSERT INTO bmo_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ŋga nshwei chrà Minnwi Pega, ntɔgɔ shwiʼi Atalia. ");
INSERT INTO bmo_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Llɔ fɔ kəʼɨ ghɔ, pugu shāʼa ŋkhǐ ntaoŋ Antiɔ. Yei lɨʼɨ ŋa pa ghaŋ piŋ ni nduoŋ ni Minnwi ŋa a nōoŋ pwapuŋ yi ni pugu nthɛ fàʼa ŋa pugu mīʼɛŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pugu ni ŋga nchəɨŋ Antiɔ, ŋkɨrɨ ŋguoŋ ŋgwa chɔshi taʼa lɨʼɨ, nshwei vugu ni ŋguoŋ nnu ŋa Minnwi fāʼa mbɨŋ pugu nɛ, pugu pa ŋkwaŋ nɔ haʼaŋ a chuʼɔ shɛndaoŋ ni pa ŋgwa taoŋ nduoŋ ŋa pugu piŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pugu kɨna fɔ nɔ ntaaŋ ndɨɨ pugu pa ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pichəɨ ŋgwa ni ndhɔ Judia nthɔ Antiɔ, njɛʼi pa ghaŋ piŋ ŋa, “P̈əɨ mieŋ ki lɔ nii ŋgunu mbrɛi ŋkwaŋ haʼaŋ gɨ́ Mushi chhu nɛ, paʼa pəɨ lɔ ndūgu.” ");
INSERT INTO bmo_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔɔ pugu Banaba nii moŋ ŋkiɛŋ tɨtɨnɨ mindoundou pugu pugu nthɛ yei nnu, nɛnnɛ, pugu taoŋ ni taʼancho ŋa Pɔɔ pugu Banaba pugu pa pichəɨ ŋgwa llɔ Antiɔ ghə̄ɨ Jerushalɛiŋ njəɨ pa ghaŋ ntaoŋ Jishɔ pugu pa thishɨ nthɛ nnu yei. ");
INSERT INTO bmo_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Chɔshi taoŋ vugu, pugu tɔgɔ Fonishia pugu Shamaria nthɔ nshwei fɨʼɨ ŋkwaŋ nɔ haʼaŋ ŋgwa taoŋ nduoŋ piŋ Minnwi nɛ. Pishaʼakhɔ yei thɔ ni pwanjuʼɔ ni ŋguoŋ pa ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pugu ni ŋga nchəɨŋ Jerushalɛiŋ, chɔshi pugu pa ghaŋ ntaoŋ Jishɔ, ni pa thishɨ chhu ni pugu ŋa pugu thɔ a pwa, pugu fɨ̄ʼɨ ŋguoŋ pa nnu ŋa Minnwi fāʼa ntɔgɔ mbhɔ pugu nɛ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ndɔ pichəɨ pa ghaŋ piŋ ŋa pugu ni ndhɔ moŋ shɨna pa ŋgwa Farashi lɔllɔ tɔthɨ nchhu ŋa, “A pie ŋa pi niʼiŋ vugu ŋgunu mbrɛi, mfɛ gɨ́ pugu nūʼɔŋ gɨ́ Mushi.” ");
INSERT INTO bmo_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pa ghaŋ ntaoŋ Jishɔ pugu pa thishɨ paoŋ nɔ līi nu nnu yei. ");
INSERT INTO bmo_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pugu ni ŋga ŋkwo lōu nɔ ntaaŋ ndɨɨ, Pita lɔllɔ tɔthɨ nchhu ni pugu ŋa, “Lǐŋ paŋ, pəɨ ji ŋa fie moŋ pɨɨ ndɨɨ chəɨ, Minnwi ni nchuʼɔ a shɨna pəɨ nɔ māʼaŋ nu ŋkɨ̀nɨ pwa pishaʼakhɔ ni ŋgwa taoŋ nduoŋ, nnɛ ŋa a nthɛ pugu yaʼo ndɔ mbiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ndɔ Minnwi ŋa a ji njùʼɔ shesheŋoŋ nɛ, ni nōoŋ ŋa a piŋ vugu ntɔgɔ pi ŋkuoŋ fɛ nu Jijwɛ yi ni pugu, pi wuʼɔ ŋkwaŋ nɔ haʼaŋ a ni mfɛ ni pia nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","A shini ndɔ nōoŋ ŋa kwrí pɔ shɨna pia pugu. A ni ŋka shɨ̄gao njùʼɔ yugu shɨ̄gao nthɛ ŋa pugu ni mbiŋ vi. ");
INSERT INTO bmo_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ti ndwɛ yei, pəɨ pɨnɨ nuʼuŋ ntāʼa nu njwɛʼi Minnwi nɔ khɔ, ni nūʼɔŋ nu lrì thɔ pa ghaŋ piŋ ŋa pa ŋkhu tǎa pia ki nduthɔ yia shini ndɔ ŋkāʼo nɔ tiɛŋ nu nɛ? ");
INSERT INTO bmo_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ndɔ pia piŋ ŋa pia lūgu ntɔgɔ pi moŋ pwapuŋ Taathɔ, mbɔ Jishɔ, wuʼɔ nɔ haʼaŋ pugu ŋkaa pugu lūgu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ŋguoŋ kɨrɨ ghɔ ni ndɛrɛ laŋ njwɛrɛ nu ŋkwaŋ haʼaŋ Banaba pugu Pɔɔ thɔ mfɨ̄ʼɨ pa lì pugu pa nnu ghraoghrao haʼaŋ Minnwi ni nchwīe ntɔgɔ pi mbhɔ pugu shɨna pa ŋgwa taoŋ nduoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pugu ni ŋga mfɨ̄ʼɨ ti mīʼɛŋ, Jɛiŋ khwɛ̄ ŋa, “Lǐŋ paŋ, p̂əɨ yaʼo vəɨ! ");
INSERT INTO bmo_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Shemu wuʼɔ ŋka fɨ̄ʼɨ fɨ̄ʼɨ ni pia ŋkwaŋ haʼaŋ Minnwi ni fǔoŋ ŋkra ŋgwa taoŋ nduoŋ nɔ fuʼu nu ŋgwa haʼaŋ pugu shi mbɔ ji nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ndɔ chrà pa njəɨlɨʼɨ Minnwi piŋ nnu ŋa Shemu chhu nɛ, wuʼɔ nɔ haʼaŋ pi nāʼaŋ moŋ chrà Minnwi ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘A shi ŋga ndaʼa, m̀bɨnɨ mbɨnɨ ŋkrao lɨʼɨ chhɔ Devi ŋa a kuʼɔ fùŋ nɛ. Ǹshi mbɨnɨ ŋkrao nda shaʼoshaʼo ghɔ, mbɨnɨ nchwīe vi, a thi tɔthɨ ŋkamuʼɔŋ, ");
INSERT INTO bmo_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","nnɛ ŋa pɨgəɨ ŋgwamishua shigi Taathɔ, ŋguoŋ pa ŋgwa taoŋ nduoŋ haʼaŋ pi gɛ̄ vugu ŋa pugu pɔ ŋgwa paŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yei nnu ŋa Taathɔ, ŋa a ni nchwīe ŋgwa ji yei nnu fie llɛshhɨ, chhu nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Nthɛ yie ghɔ, m̀bīʼi nyaŋ ŋa kiʼi pia fɛ ŋgəʼɨ ni ŋgwa taoŋ nduoŋ yɛ ŋa pugu kara mbiŋ Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pia ka nāʼaŋ pi ŋwaʼaŋlɨ ni pugu, nshwei vugu ŋa kiʼi pugu jɨ sheshe maoŋ jɨ ŋa pi fɛ̄ʼi pa nnwi nɔ nɛ, ŋa pugu ləʼɨ shúoŋ, ki lɔ ŋkru minyieŋ ŋa pi nɨ̄naoŋ mmi yi a khu ki chhǐ lɔ ntaoŋ mbɨŋ yu nɛ, ndɔ ndəʼɨ jɨ nnu chhǐ. ");
INSERT INTO bmo_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nthɛ ŋa llɔ llɛshhɨ Mushi fāʼo ŋgwa ŋa pugu gha mɛ̄iŋ gɨ́ yi moŋ ŋguoŋ laʼataoŋ ghao, pi ghà mɛ̄iŋ chrà yi ŋguoŋ llɛ́ ji ghao moŋ pa nda luoŋ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nnɛ, pa ghaŋ ntaoŋ Jishɔ pugu pa thishɨ ni ŋguoŋ chɔshi ni njəɨ ŋa a pwa ŋa pugu chuʼɔ ŋgwa shɨna pugu ntaoŋ vugu pa Pɔɔ ni Banaba pugu ghə̄ɨ Antiɔ. Pugu ni nchuʼɔ Judashi, ŋa pi mɛ̄iŋ vi ŋa Bashaba, pugu Shaila, mbɔ pa ŋgwa chɨɨchɨɨ shɨna pugu. ");
INSERT INTO bmo_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ntaoŋ vugu ni yei ŋwaʼaŋlɨ, ŋwaʼaŋlɨ ghɔ chhu ŋa, “Pigi, mbɔ pa ghaŋ ntaoŋ Jishɔ pugu pa thishɨ, mbɔ pa lǐŋ pəɨ, nchrā ni pəɨ, mbɔ pa ghaŋ piŋ llɔ laʼataoŋ nduoŋ nchhɔ nu moŋ Antiɔ, pugu pa Shiria ni Shilishia nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Pigi yaʼo ŋa pichəɨ ŋgwa llɔ shɨna pigi ghana vəɨ ni pichəɨ pa chrà, mvūʼu thɔ yəɨ. Ndɔ nɛ, chrà ghɔ shini ndɔ nɛ ndhɔ pi mbhɔ pigi. ");
INSERT INTO bmo_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pigi paoŋ nɛ, njwɛrɛ ntaoŋ ni taʼaŋggi ŋa a pwa ŋa pigi chuʼɔ pa ŋgwa, ntaoŋ vugu ŋa pugu thɔ njəɨ vəɨ. Pugu shi nthɔ pugu pa ŋkiɛŋ pa lǐŋ pia, mbɔ Banaba pugu Pɔɔ, ");
INSERT INTO bmo_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","mbɔ ŋgwa ŋa pugu mīʼaŋ chɔmbhi yugu nthɛ ligi Taathɔ via, mbɔ Jishɔ Krishto. ");
INSERT INTO bmo_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nɛnnɛ, pigi taoŋ Judashi pugu Shaila ŋa pugu thɔ nshwei vəɨ ni nchò yugu ni nnu haʼaŋ pigi nāʼaŋ moŋ ŋwaʼaŋlɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Pigi pa Jijwɛ Minnwi pɔ ni taʼa nchò ŋa a pwa ŋa kiʼi pigi nuʼuŋ nūʼɔŋ yichəɨ sheshe lrì mbɨŋ pəɨ, ŋkiɛŋ ŋa pəɨ nūʼɔŋ pa mɛmmɛ nnu pei: ");
INSERT INTO bmo_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kiʼi pəɨ jɨ maoŋ ŋa pi fɛ̄ʼi pa nnwi nɔ ghɔ nɛ, kiʼi pəɨ jɨ chhǐ, kiʼi pəɨ kru minyieŋ ŋa pi nɨ̄naoŋ mmi yi a khu ki chhǐ lɔ ntaoŋ mbɨŋ yu nɛ, kiʼi pəɨ kwoshuoŋ. P̈əɨ ndɨna pa nnu pei, kaŋ pəɨ shi mbɔ shiʼi. P̂əɨ chhɔ shiʼi.” ");
INSERT INTO bmo_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pi ni ŋga ntaoŋ vugu, pugu shwiʼi Antiɔ ŋkɨrɨ pa ghaŋ piŋ taʼa lɨʼɨ mfɛ ŋwaʼaŋlɨ ghɔ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pugu ni ŋga mɛ̄iŋ, mbɔ ni ntou pwatua nthɛ chrà māʼaŋ ghrɨ́ ghɔ moŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ndɔ Judashi pugu Shaila, ŋa pugu ni mbɔ pa njəɨlɨʼɨ Minnwi, fɛ ntou chrà ntɨ́gɨ ni pugu nthɔ māʼaŋ ghrɨ́ yugu ndɔ ntɨʼɨ vugu. ");
INSERT INTO bmo_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pugu ni ŋga ndaʼa fɔ nɔ yichəɨ fɨʼɨ ndɨɨ, pa ghaŋ piŋ pighɔ chaʼa vugu ŋa pugu nyīeŋ shiʼi, pugu pɨ̄nɨ kəʼɨ ghɔ mbhɔ ŋgwa haʼaŋ pugu ni ntaoŋ vugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ndɔ Shaila khwā nɔ kɨna nu fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ndɔ Pɔɔ pugu Banaba kɨna Antiɔ, nthɔ njɛʼi nu ndɔ nchīi chrà Taathɔ pugu pa pichəɨ ntou ŋgwa nduoŋ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","A ni ŋga ndaʼa, Pɔɔ chhu ni Banaba ŋa, “Pɔgɔ pɨnɨ mbɨ̄nɨ ŋkra pa ghaŋ piŋ moŋ ŋguoŋ pa laʼataoŋ ŋa pɔgɔ ni nchīi chrà Taathɔ fɔ nɛ, njəɨ ŋa pugu thɔ mbɔ pi ŋkwaŋ nɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba ni ntāʼa nu ndɔ̄gɔ Jouŋ Maaku pugu pugu ghə̄ɨ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pɔɔ ni njwɛrɛ ŋa a lɔ njiʼi ŋkāʼo nɔ lɔ̄gɔ nu vi nthɛ ŋa a ki tei njiŋ yugu Pamfilia ki pugu pugu lɔ mīʼɛŋ fàʼa kaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mindoundou ni nja ntɨnɨ shɨna pugu ti ndugwi yi pugu fɛ̄nɛ noŋ, Banaba lɔ̄gɔ Jouŋ Maaku, pugu shāʼa ŋkhǐ ŋgə̄ɨ Shaipru. ");
INSERT INTO bmo_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔɔ lɔ̄gɔ Shaila, pugu yu ghə̄ɨ, pa ghaŋ piŋ luoŋ ŋa Taathɔ nōoŋ pwapuŋ yi ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nnɛ, a ghə̄ɨ moŋ Shiria pugu Shilishia, nthɔ māʼaŋ ghrɨ́ pa chɔshi fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔɔ ghə̄ɨ Debi pugu Lishtra, njəɨ yichəɨ ŋgaŋ younjiŋ Jishɔ fɔ, ligi yi pɔ Timoti. Mǔuŋ Timoti ni mbɔ ŋoŋ Juu, mbɔ ŋgaŋ piŋ ŋkaa yu, ndɔ tǎa vi pɔ pi ŋoŋ Gri. ");
INSERT INTO bmo_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Pa ghaŋ piŋ ŋa pugu ni mbɔ Lishtra pugu Ikoniuŋ nɛ, ni nchrā pa nnu shiʼi nthɛ vi. ");
INSERT INTO bmo_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔɔ ni ntāʼa nu ŋa pugu Timoti ghə̄ɨ kaʼa, nthɛ yie ghɔ, a niʼiŋ vi ŋgunu mbrɛi. A ni nchwīe nnɛ nthɛ ŋa ŋguoŋ pa ŋgwa Juu ŋa pugu ni mbɔ moŋ lɨʼɨ pighɔ nɛ ni nji ŋa tǎa Timoti pɔ pi ŋoŋ Gri. ");
INSERT INTO bmo_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nɔ haʼaŋ pugu ni nyīeŋ nu moŋ pa laʼataoŋ pighɔ nɛ, pugu shwei pa ghaŋ piŋ ni pa nthi ŋa pa ghaŋ ntaoŋ Jishɔ pugu pa thishɨ Jerushalɛiŋ ni ndɔ̄gɔ nɛ, nchhu ni pugu ŋa pugu wɛ̄iŋ nthi pighɔ a pwa. ");
INSERT INTO bmo_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nnɛ, pa chɔshi pighɔ ni ntɨnɨ nu moŋ piŋ, fɨʼɨ ghaŋ piŋ pigi nu sheshe llɛ́. ");
INSERT INTO bmo_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pugu nyīeŋ ntɔgɔ krao ŋgei Fragia pugu Galashia nthɛ ŋa Jijwɛ Minnwi ni ŋkwo lāa ni pugu ŋa kiʼi pugu chīi chrà Minnwi Eshia. ");
INSERT INTO bmo_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pugu ni ŋga nchəɨŋ Mishia, ntāʼa nu ŋgə̄ɨ Bitinia, ndɔ paʼa Jijwɛ Jishɔ lɔ mbiŋ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nnɛ, pugu tiri moŋ Mishia ŋgə̄ɨ Troa. ");
INSERT INTO bmo_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pɔɔ ni njəɨ nnu ni tuʼu ghɔ, a ni njəɨ ŋoŋ Mashedonia tithi nthɔ ndɨ̄gəɨ vi ŋa, “Shāʼa Mashedonia ŋgɛ̄rɛ vigi!” ");
INSERT INTO bmo_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wuʼɔ nɔ haʼaŋ Pɔɔ ni nuʼuŋ njəɨ nnu yei nɛ, pigi pīri noŋ yigi nɔ llɔ nu ŋgə̄ɨ Mashedonia nthɛ ŋa pigi ni njəɨ ŋa Minnwi gɛ̄ vigi ŋa pigi chīi ŋkɨ̀nɨ pwa pishaʼakhɔ ni pa ŋgwa lɨʼɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pigi shāʼa moŋ pie llɔ Troa ntuŋ ntaoŋ Shomatrashe, mbhi gha ndaŋ pigi ghə̄ɨ Neapoli. ");
INSERT INTO bmo_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Llɔ fɔ, pigi ghə̄ɨ Filipai mbɔ mmɛ laʼataoŋ ŋaʼaŋŋaʼaŋ moŋ krao ŋgei Mashedonia mbɔ lɨʼɨ ŋa ntou ŋgwa Roma ni nchhɔ nu nɛ. Pigi ni ndaʼa fɔ nɔ ntou llɛmbhi. ");
INSERT INTO bmo_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","A gha mbɔ llɛ́ ji, pigi taoŋ moŋ tri laʼa ŋgə̄ɨ ŋkɨŋ nɨnəɨ, mbɔ lɨʼɨ ŋa pigi ni mbīʼi ŋa ŋgwa Juu ghà ŋkɨrɨ fɔ nɔ luoŋ nu Minnwi nɛ. Pigi ni nchɔchhɔ shhɛ nchrā ni pa piŋgɛ ŋa pugu ni ŋkɨrɨ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Taʼa ŋoŋ ŋa a ni njaʼo vigi nɛ ni mbɔ Lidia llɔ Tiatira, mbɔ ŋgaŋ fīni pa ndhwí tɨnɨnchuoŋ mbɔ miŋgwɛ ŋa a ni nthɔ ŋgaʼo Minnwi. Taathɔ ŋaʼaŋ njùʼɔ yi ŋa a tigi thɔ yi ni nnu ŋa Pɔɔ ni nthɔ nchhu nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","A ni ŋga ŋkwe ŋkhǐ, pugu pa mbaanda yi, ŋgɛ̄ vigi, nchhu nu ŋa, “Pəɨ thɔ ndaʼa nda mu nɔ haʼaŋ pəɨ nja njəɨ ŋa ǹja mbiŋ Taathɔ shini.” Nthɔ ndɨ̄gəɨ vigi ti pigi piŋ ŋa pigi pugu ghə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","A ni mbɔ llɛ́ chəɨ pigi gha ŋgə̄ɨ nu nɔ lɨʼɨ luoŋ Minnwi, mbāoŋ pigi pa muuŋ miŋgwɛ chəɨ mbɔ ŋkǔna ŋa a ni mfāʼo jijwɛ pɨphɨ, jijwɛ pɨphɨ ghɔ ni nthɔ nchwīe a yəɨ pa nnu ŋa a shi ndɔ̄gɔ lɨʼɨ nɛ. Ŋgwa pɛ ŋa pugu ni mfāʼo vi nɛ ni nthɔ mfāʼo ntou mbɨŋ nthɛ ŋa a ni nthɔ njəɨ pa nnu nchhu nu. ");
INSERT INTO bmo_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","A yōu njiŋ yigi pa Pɔɔ mbaʼo ŋgòu, nchhu nu ŋa, “Ŋgwa pei ya mbɔ pi puoŋ fàʼa Minnwi ŋa a Chaapifuoŋ nɛ! Pugu thɔ nchīi nu ni pəɨ ŋkwaŋ haʼaŋ mimfɛ pəɨ kie ndūgu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A ni nchwīe nɛnnɛ nɔ ntou llɛ́ ti Pɔɔ pɨgɨtua, ŋkara nchhu ni jijwɛ pɨphɨ ghɔ ŋa, “M̀fɛ gɨ́ vɛ moŋ ligi Jishɔ Krishto ŋa ɔ taoŋ mbɨŋ yu!” A wuʼɔ ntaoŋ pi chomilaoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ŋgwa pɛ ŋa pugu ni mfāʼo ŋkǔna ghɔ nɛ, ni ŋga njəɨ ŋa mbaʼa pugu nuʼuŋ mfāʼo shéi llɔ mbhɔ ŋkǔna ghɔ nɛ, pugu wɛ̄iŋ Pɔɔ pugu Shaila, ŋgə̄ɨ ni pugu moŋ taŋ shhɨ pa kúŋ, ");
INSERT INTO bmo_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ŋga nthɔ ni pugu shhɨ pa mɛmmɛ ŋgwa ghaŋ shaʼa sháʼa, nchhu ŋa, “Ŋgwa pei pɔ pi ŋgwa Juu, nchhɔ nthɔ nu ni mintantara moŋ laʼa pia. ");
INSERT INTO bmo_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Pugu thɔ ntɨgɨ pa nùʼɔŋ ŋa a lɔ ŋkāʼo ŋa pia piŋ ki nchwīe nthɛ ŋa pia pɔ pi ŋgwa Roma.” ");
INSERT INTO bmo_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yú ŋgwa pighɔ fɔ nɛ chīri pugu pugu nii nu ligi Pɔɔ pugu Shaila. Pa ghaŋ shaʼa sháʼa pighɔ shāa ndhwí Pɔɔ pugu Shaila mfɛ gɨ́ ŋa pi wie vugu. ");
INSERT INTO bmo_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pi ni ŋgwie vugu ŋkiɛŋ yie ghɔ, māʼaŋ vugu chə́ɨŋ, mfɛ gɨ́ ni ŋgaŋ kɛ̄ʼi chə́ɨŋ ŋa a kɛ̄ʼi vugu shishiʼi. ");
INSERT INTO bmo_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ŋgaŋ kɛ̄ʼi chə́ɨŋ gha njaʼo gɨ́ yei, niʼiŋ vugu moŋ ŋkiɛŋ chə́ɨŋ tɨtɨnɨ, mfɨ̄nɨ kwò muŋu ni kipaʼo. ");
INSERT INTO bmo_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","A ni ŋga mbɔ moŋ ntuŋ mbhi, Pɔɔ pugu Shaila luoŋ Minnwi njrāo ŋkhǐ pa ghaŋ chə́ɨŋ ywɛrɛ nu. ");
INSERT INTO bmo_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Shhɛ wīʼi nchɨʼɨ, ti kwonda chə́ɨŋ ghɔ chɨ̄ʼɨ wuʼɔ ndɨɨ ghɔ, ŋguoŋ chonda chuʼɔ, ŋguoŋ chɛiŋ kɨ̄gɛi mbɨŋ ŋguoŋ ghaŋ chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ŋgaŋ kɛ̄ʼi chə́ɨŋ ghɔ gha ndɔllɔ njəɨ ŋa cho chə́ɨŋ yi wo, nshūa kafa yi ntāʼa nu njwi nōoŋ yi, ŋgɛ̄ nu ŋa ghaŋ chə́ɨŋ kwo taoŋ ntei. ");
INSERT INTO bmo_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pɔɔ paʼo ŋgòu ni ŋguoŋ ŋggì yi ŋa, “Kiʼi njwi noŋ yɔ, pigi pɔ hɛiŋ ghao.” ");
INSERT INTO bmo_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ŋgaŋ kɛ̄ʼi chə́ɨŋ ghɔ mɛ̄iŋ ŋa pi thɔ ni laŋ, ntei nii moŋ chə́ɨŋ ghɔ, ŋgrū nu, ŋgū nɔ kwò Pɔɔ pugu Shaila, ");
INSERT INTO bmo_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","mfuʼu vugu ntaoŋ nɔ mbhi nchhu ŋa, “Pa masha mi shi nchwīe pi nɛiŋ ndūgu?” ");
INSERT INTO bmo_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pugu khwɛ̄ ŋa, “Piŋ Jishɔ Taathɔ, kaŋ ɔ shi ndūgu, pəɨ pa mbaanda yɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pugu shwei chrà Taathɔ ghɔ pugu pa ŋgwa ŋa pugu ni mbɔ nda yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Wuʼɔ ndɨɨ ghɔ ni tuʼu ghɔ, a lɔ̄gɔ vugu ŋgə̄ɨ nshɨ̄gao fɨ́ yugu. Ŋgaŋ kɛ̄ʼi chə́ɨŋ ghɔ pugu pa ndaaŋoŋ yi kwe ŋkhǐ wuʼɔ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ŋkɛ̄ʼi chə́ɨŋ ghɔ lɔ̄gɔ Pɔɔ pugu Shaila ŋkuʼɔ nɔ nda yu mfɛ maoŋ pugu jɨ. Ŋoŋ ghɔ fāʼo pwatua pugu pa ndaaŋoŋ yi nthɛ ŋa pugu piŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mbhi ni ŋga ndaŋ, pa ghaŋ shaʼa sháʼa taoŋ pa brushi, nchhu nu ŋa, “P̂əɨ chuʼɔ ŋgwa pɛ pugu ghə̄ɨ!” ");
INSERT INTO bmo_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ŋgaŋ kɛ̄ʼi chə́ɨŋ pɨnɨ, nchhu ni Pɔɔ ŋa, “Pa ghaŋ shaʼa sháʼa māʼaŋ ŋkɨ̀nɨ ŋa pi chuʼɔ vəɨ, pəɨ ghə̄ɨ nɛ ni vəɨ shiʼi.” ");
INSERT INTO bmo_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ndɔ Pɔɔ khwɛ̄ ŋa, “Pugu wie vigi shɨna ŋgwa, ndɔ niʼiŋ vigi chə́ɨŋ ki lɔ naa nshaʼa vigi yaʼa pigi lɔ mbɔ pi ŋgwa Roma. Ti ndwɛ pugu tāʼa nu mfuʼu vigi pi njiŋnjiŋ? Ŋga! Pugu thɔ ni noŋ yugu mfuʼu vigi.” ");
INSERT INTO bmo_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pa brushi pɨnɨ māʼaŋ ŋkɨ̀nɨ ghɔ ni ghaŋ shaʼa sháʼa pighɔ. Pugu gha njaʼo ŋa Pɔɔ pugu Shaila ni mbɔ pi ŋgwa Roma, mbɔgɔ a ghaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nɛnnɛ pugu thɔ mbiŋ fàŋ ni pugu. Mfuʼu vugu moŋ chə́ɨŋ, nchhu ŋa pugu taoŋ ni vugu moŋ laʼa. ");
INSERT INTO bmo_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nnɛ pugu taoŋ moŋ chə́ɨŋ, ŋgə̄ɨ nda Lidia. Ŋga ŋgə̄ɨ fɔ, mbāoŋ pugu pa ghaŋ piŋ, māʼaŋ ghrɨ́ yugu ŋgə̄ɨ kiʼɛ ni vugu. ");
INSERT INTO bmo_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔɔ pugu Shaila ni nyīeŋ ntɔgɔ Amfipoli pugu Apolonia nthɔ nchəɨŋ Teshalonika lɨʼɨ haʼaŋ nda luoŋ Minnwi pa Juu ni mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔɔ nii moŋ nda luoŋ Minnwi ghɔ ndɔ haʼaŋ a ghà mbīgi nchwīe nɛ, nnɛ nɔ trɛi taŋ moŋ pa Llɛ́ ji, nthɔ mbīʼi chrà Minnwi pugu pugu. ");
INSERT INTO bmo_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","A fɨ̄ʼɨ nu ni pugu ndɔ nōoŋ nu llɔ moŋ ghɔ ŋa a ni ŋguʼɔ mbie ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ yəɨ ŋgəʼɨ ndɔ ŋkhu mbɨnɨ ŋkuʼɔ, nchhu nu ŋa, “Jishɔ yei, ŋa ǹthɔ nchrā nu nthɛ vi nɛ pɔ pi ju ghɔ ŋa Minnwi chuʼɔ vi ntaoŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pichəɨ pa ŋgwa ni mbiŋ njōu njiŋ Pɔɔ pugu Shaila, ntou pa ŋgwa Gri ŋa pugu pɔgɔ Minnwi nɛ, pugu pa ntou mɛmmɛ piŋgɛ piŋ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ndɔ pichəɨ ŋgwa Juu fāʼo kighɨʼə, nnɛ, ŋkɨrɨ pa mbɨgɨ puŋ, mbɔ pa ŋgwa ghagha pugu taoŋ ni mmɛ yú, nchwīe yɔ̀yɔnɔ kuʼɔ moŋ laʼa, pugu ghə̄ɨ nii laʼa Jashoŋ nɔ wɛ̄iŋ nu Pɔɔ pugu Shaila mfɛ ni ŋgwa pugu. ");
INSERT INTO bmo_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pugu ni ŋga mieŋ ki lɔ njəɨ vugu fɔ, ŋgwɛ̄iŋ Jashoŋ pugu pa pichəɨ pa ghaŋ piŋ ŋgə̄ɨ ni pugu shhɨ pa thishɨ moŋ laʼa, nchhu nu ŋa, “Ŋgwa pei haʼaŋ pugu thɔ fɛ ŋgəʼɨ ŋguoŋ lɨʼɨ nɛ chəɨŋ nɛ hɛiŋ, ");
INSERT INTO bmo_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jashoŋ lɔ̄gɔ vugu niʼiŋ nda yu. Pugu thɔ nchɨ̄ʼə ŋguoŋ gɨ́ ŋa Kaisha fɛ nɛ, nchhu nu ŋa yichəɨ fùoŋ pɔ fɔ, ligi yi pɔ Jishɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pa ŋgwa pugu pa thishɨ moŋ laʼa ni ŋga njaʼo yei nnu, a ghana vugu. ");
INSERT INTO bmo_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pugu chwīe Jashoŋ pugu pa pakwo pi nūʼɔŋ mbɨŋ, nnɛ pi mieŋ vugu pugu ghə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tuʼu ni ŋga nshini, pa ghaŋ piŋ kiʼi mfɛ Pɔɔ pugu Shaila fɛ Bɛria. Pugu gha ŋgə̄ɨ ti nchəɨŋ, ŋgə̄ɨ moŋ nda luoŋ Minnwi pa Juu. ");
INSERT INTO bmo_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pa ŋgwa Juu fɔ ni mbɔ ŋkiɛŋ ŋgwa nchaa pi Teshalonika, nthɛ ŋa pugu ni mbiŋ chrà Minnwi ni ntou niʼiŋ njùʼɔ, ntou mooŋ yi ŋguoŋ llɛ́ nɔ yəɨ nu ŋa a nnu shini. ");
INSERT INTO bmo_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nthɛ yie ghɔ, ntou yugu ni mbiŋ Minnwi, ntou pa mɛmmɛ piŋgɛ ni mɛmmɛ nthɨŋkwo llɔ Gri, pugu pa ntou mbia, piŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pa ŋgwa Juu ŋa pugu ni mbɔ Teshalonika gha njaʼo ŋa Pɔɔ shwei chrà Minnwi Bɛria ŋkaa yu nɛ, pugu ghə̄ɨ fɔ, niʼiŋ puŋ ŋgwa, ndɔ ŋkāoŋ vugu ŋa pugu tāra. ");
INSERT INTO bmo_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wuʼɔ ndɨɨ ghɔ pa ghaŋ piŋ Bɛria fɛ Pɔɔ ŋkɨŋ ŋkhǐ ndɔ Shaila pugu Timoti kɨna Bɛria. ");
INSERT INTO bmo_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pa ŋgwa pɛ ŋa pugu ni ndɔ̄gɔ Pɔɔ nɔ ghə̄ɨ nu ntiʼi vi nɛ, ghə̄ɨ ti nchəɨŋ Atɛŋ maa mbɨnɨ mbɨ̄nɨ Bɛria ni ŋkɨ̀nɨ ŋa pugu chhu ni Shaila pugu Timoti ŋa pugu para vi wuʼɔ chomilaoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pɔɔ ni ŋga nchhɔ njwɛrɛ Shaila pugu Timoti Atɛŋ, njùʼɔ yi ghana vi moŋ ghɔ ŋkiɛŋ yie, nthɛ ŋa laʼataoŋ ghɔ ni ndɨnaoŋ ni pa nnwi. ");
INSERT INTO bmo_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nnɛ a shwei chrà Minnwi moŋ nda luoŋ Minnwi ni pa Juu pugu pa ŋgwa taoŋ nduoŋ ŋa pugu ni nthɔ ŋgaʼo Minnwi nɛ. Mbɨnɨ nchhu moŋ taŋ ŋguoŋ llɛ́ ni pa ŋgwa ŋa pugu ni mbɔ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pichəɨ ŋgwa ŋa pugu ni nthɔ njōu njiŋ Ɛpikuru nɛ, pugu pa ŋgwa ŋa pugu ni ntɨgɨ ŋgwa ni yaoŋ ŋa Shitoi ni ntɨgɨ nu nɛ, lōu nu pugu pa Pɔɔ. Pichəɨ chhu ŋa, “Yei ŋgaŋ wie nchò chhu pi ŋa?” Pichəɨ khwɛ̄ ŋa, “A fhi nɔ haʼaŋ a chrā nu nɔ ligi nnwi taoŋ nduoŋ.” Pugu ni nchhu yei nthɛ ŋa Pɔɔ ni nthɔ nchīi chrà pi nɔ ligi Jishɔ pugu pa nnu khu nu mbɨnɨ ŋkuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nɛnnɛ, pugu lɔ̄gɔ Pɔɔ ŋgə̄ɨ ni ju shhɨ pa kúŋ Areopagushi nchhu ghɔ ŋa, “Pigi tāʼa nu nji yaoŋ ŋa nnu fhi yei ŋa a yɛʼi nu yie ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Pichəɨ pa nnu ŋa pigi yaʼo ɔ yɛʼi nu nɛ ghrāo vigi, nthɛ yie ghɔ, pigi tāʼa nu ŋa ɔ ya mbɨnɨ mfɨ̄ʼɨ nnu pei pigi ji.” ");
INSERT INTO bmo_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pugu ni nchhu nɛiŋ nthɛ ŋa ŋguoŋ pa ŋgwa Atɛŋ pugu pa ghɨ̀nɨ ŋa pugu laʼa nu fɔ nɛ ghà ndɔ̄gɔ ŋguoŋ ndɨɨ yugu nɔ chhu nu ki nɔ yaʼo nu pa pishaʼakhɔ fhi. ");
INSERT INTO bmo_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nɛnnɛ, Pɔɔ tithi shhɨ pa kúŋ Areopagushi nchhu ŋa, “Ŋgwa Atɛŋ, ǹjəɨ ŋa moŋ ŋguoŋ puoŋ shɛndaoŋ ghao pəɨ ghà ŋgaʼo pa nnwi. ");
INSERT INTO bmo_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nthɛ ŋa nɔ haʼaŋ ǹtɔgɔ moŋ laʼa pəɨ nɛ, nthɔ mbɛʼi pa shhɨ nnwi pəɨ haʼaŋ pəɨ ghaʼo nu nɛ, ǹjəɨ yichəɨ lɨʼɨ fɛʼiŋgiɛŋ pi nāʼaŋ fɔ ŋa, ‘Ni nnwi ŋa pigi lɔ nji vi nɛ.’ Yaoŋ yɛ ŋa pəɨ ghaʼo pi ki lɔ nji nɛ, a yie ghɔ ŋa ǹchrā nu ni pəɨ nthɛ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Minnwi ŋa a chwīe mbhi pugu pa ŋguoŋ yaoŋ moŋ ghɔ nɛ, a ju mbɔ Taathɔ po pugu pa shhɛ. A shiʼa njiʼi nchhɔ pi moŋ pa Nda Minnwi haʼaŋ a krao ŋoŋmishua ni mbhɔ mi nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ki mbɔ ni chà yichəɨ yaoŋ haʼaŋ a nthɛ a fàʼa ŋoŋmishua mfɛ ghɔ nɛ, ŋa a ju nduthɔ yi ŋa a fɛ chɔmbhi pugu pa jijwɛ pugu pa ŋguoŋ pa maoŋ nduoŋ ni shesheŋoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ntɔgɔ pi mbɨŋ taʼa ŋoŋmishua, a chwīe ŋguoŋ pa ŋgwa taoŋ taoŋ ŋkuoŋ mbhi, nchwīe ŋa pugu nchhɔ moŋ ŋguoŋ ŋkuoŋ mbhi ghao. Ni ŋkwo nūʼɔŋ pa fiɛŋ yugu pugu pa fɨʼɨ ndɨɨ yɛ ŋa pugu shi nchhɔ ŋkuoŋ mbhi hɛiŋ, ŋkaoŋ pugu maa mbɔ. ");
INSERT INTO bmo_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“A ni nchwīe yei nnɛ ŋa a nthɛ pugu tāʼa vi ndɔ njəɨ vi nɔ haʼaŋ pugu mɔnɔ ntāʼa vi nɛ. Ndɔ nɛ, a lɔ njiʼi mbɔ pi fie hiŋ ni shesheŋoŋ via. ");
INSERT INTO bmo_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nthɛ ŋa pia chhɔ chɔmbhi, nyīeŋ nu ndɔ mbɔ nu pi mbhɔ yu, wuʼɔ nɔ haʼaŋ pichəɨ ghaŋ shiethɔ shɨna pəɨ chhu nɛ ŋa, ‘Shishini ŋguoŋ via pa puoŋ pi.’ ");
INSERT INTO bmo_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nthɛ ŋa pia púoŋ Minnwi nɛ, kiʼi pia pīʼi ŋa Minnwi pɔ pi nɔ yaoŋ ŋa ŋoŋ chwīe ni laoŋgo, ki ni yaoŋ tɨ́nɨ ki ni ŋgùʼɔ, mbɔ pi yaoŋ ŋa a chhɔ ŋoŋmishua mbīʼi nchwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Minnwi funu ndɨɨ ŋa ŋgwa ni nchwīe phɨ ki ji nɛ, ndɔ ndwɛ, a fɛ gɨ́ ŋa ŋguoŋ ŋgwa moŋ ŋguoŋ lɨʼɨ pāʼa ŋkǔnu yugu ni phɨ. ");
INSERT INTO bmo_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nthɛ ŋa a chwīe taʼa llɛ́ nūʼɔŋ ŋa a shi ndɛ nshaʼa ŋguoŋ mbhi ghao moŋ ndɨndɨ ntɔgɔ pi mbɨŋ taʼa ŋoŋ ŋa a chuʼɔ vi nɛ. A nōoŋ lì yei ni shesheŋoŋ ntɔgɔ pi ŋkuoŋ kuʼɔ nu ni ŋoŋ vei llɔ moŋ gu.” ");
INSERT INTO bmo_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ndɨɨ ŋa pugu ni njaʼo Pɔɔ kāoŋ nnu khu nu mbɨnɨ ŋkuʼɔ nɛ, pichəɨ māʼaŋ vi ni kwə̀ɨŋ, ndɔ pichəɨ chhu ŋa, “Pigi tāʼa nu mbɨnɨ njaʼo ɔ chrà nnu yei ŋgɛ́ nduoŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nɛnnɛ, Pɔɔ lɔllɔ mieŋ vugu ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ndɔ pichəɨ yōu njiŋ yi mbiŋ Minnwi. Dionishio mbɔ taʼa ŋkúŋ, ni yichəɨ miŋgwɛ, ligi yi pɔ Damarishi, ni mbɔ shɨna ŋgwa pei, pugu pa pichəɨ ŋgwa nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pɔɔ ni ŋga mīʼɛŋ shhɨ pa kúŋ, ndhɔ Atɛŋ ŋgə̄ɨ Koriŋ. ");
INSERT INTO bmo_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A ni njəɨ yichəɨ ŋoŋ Juu fɔ, ligi yi pɔ Akwila, ŋa pi ni mbhi vi Pontu, a wuʼɔ ŋka llɔ pi llɔ Itali pugu ŋgwɛ vi, ligi yi pɔ Prishila, nthɛ ŋa Fùoŋ Klaudiu ni mfɛ gɨ́ ŋa ŋguoŋ ŋgwa Juu ntaoŋ moŋ Roma. Pɔɔ ghə̄ɨ nɔ yəɨ nu vugu. ");
INSERT INTO bmo_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ndaʼa pugu pugu ndɔ mfāʼa pugu pugu kaʼa nthɛ ŋa ŋguoŋ vugu ni mbɔ pa ghaŋ chwīe ntǎa mfīni nu. ");
INSERT INTO bmo_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","A ni nshwei chrà Minnwi moŋ nda luoŋ Minnwi ŋguoŋ llɛ́ ji ghao, ŋkaa nu ŋa ŋgwa Juu pugu pa ŋgwa Gri piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Shaila pugu Timoti ni ŋga ndhɔ Mashedonia nthɔ, Pɔɔ fɛ ŋguoŋ ndɨɨ yi ghao nɔ chīi nu chrà Minnwi, nthɔ nshwei ŋgwa Juu ŋa Jishɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pugu ni ŋga ndāa vi nchhu pa nnu pɨphɨ nthɛ vi, a krū pru ŋkuoŋ ndhwí pi nchhu ŋa, “Noŋ yəɨ pɔ nɛ mbhɔ pəɨ! Mbhɔ ma yi wo nɛ, llɔ ndwɛ ŋgə̄ɨ nu shhɨ, ǹshi ŋgə̄ɨ nshwei chrà Minnwi ni pa taoŋ nduoŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A mieŋ vugu ŋgə̄ɨ nda ŋoŋ chəɨ, ligi yi pɔ Titiu Jushitu, mbɔ ŋoŋ ŋa a ni nthɔ ŋgaʼo Minnwi. Nda yi ni mbɔ mbɨŋ nda luoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krishpu, mbɔ nthishɨ nda luoŋ Minnwi piŋ Taathɔ pugu pa mbaanda yi. Pichəɨ pa ntou ŋgwa laʼataoŋ Koriŋ yaʼo chrà Minnwi mbiŋ ndɔ ŋkwe ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","A ni ŋga mbɔ ni tuʼu chəɨ, Pɔɔ yəɨ nnu Taathɔ chhu ghɔ ŋa, “Kiʼi mbɔgɔ gu, chrā ni tɨnɨnjuʼɔ, ki lɔ ŋkɨna chrā nu, ");
INSERT INTO bmo_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","nthɛ ŋa pɔgɔ pɔ kaʼa. Mbaʼa yichəɨ ŋoŋ yiʼi mfɛ ŋgəʼɨ vɛ nthɛ ŋa ntou ŋgwa moŋ lɨʼɨ yei ŋgwa paŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nɛnnɛ, Pɔɔ laʼa fɔ nɔ taʼa ŋgaʼo ni ghrà yi nthɔ njɛʼi ŋgwa pighɔ ni chrà Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ndɔ ndɨɨ ŋa pi ni nūʼɔŋ Galio ŋa a shaʼa krao Roma ŋa pi mɛ̄iŋ ni Akaya nɛ, pa ŋgwa Juu pɔ ni taʼaŋggi ŋgə̄ɨ ŋgwɛ̄iŋ Pɔɔ ŋgə̄ɨ ni ju shhɨ ghaŋ shaʼa sháʼa. ");
INSERT INTO bmo_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Pugu chhu ŋa, “Ŋoŋ vei thɔ nɨŋɨ nu ŋkara njùʼɔ ŋgwa, pugu ghaʼo Minnwi moŋ shɛndaoŋ ŋa gɨ́ lɔ mbiŋ nɛ!” ");
INSERT INTO bmo_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ndɔ Pɔɔ ni ŋga ntāʼa ŋaʼaŋ nchò yi lɨʼɨ chrà, Galio chhu ni ŋgwa Juu ŋa, “Yei kaŋ ni mbɔ pi yichəɨ nnu pɨphɨ, ki fàŋ haʼaŋ ŋoŋ vei chwīe, ŋ̀ka ni mfāʼo thɔ nnu nɔ wɛ̄iŋ nu njùʼɔ njaʼo vəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ndɔ, nthɛ ŋa a pɔ pi mindoundou ŋkuoŋ pa chrà, pugu pa ligi, pugu pa yəɨ gɨ́ nɛ, a nthɛ a wuʼɔ ndugwi pəɨ. Mimfɛ paʼa ǹdɔ nshaʼa ŋkwaŋ nnu yinɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nnɛ, a yōu vugu nda sháʼa. ");
INSERT INTO bmo_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ŋguoŋ vugu wɛ̄iŋ Shoshtene, mbɔ nthishɨ moŋ nda luoŋ Minnwi, ŋgwie vi moŋ ndashaʼa sháʼa ghɔ. Ndɔ paʼa a lɔ mfhi nnu ni Galio. ");
INSERT INTO bmo_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔ chhɔ pugu pa ghaŋ piŋ Koriŋ nɔ ntou llɛ́ mieŋ vugu kiʼɛ nshāʼa ŋkhǐ pugu Prishila ni Akwila ŋgə̄ɨ Shiria. A ni ŋga mbɔ Keŋkria, ŋkuoŋ thɔ yi nthɛ kɨ̀na ŋa a ni ŋgwrā. ");
INSERT INTO bmo_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pugu gha nchəɨŋ Ɛfɛshɔ, Pɔɔ mieŋ Prishila pugu Akwila fɔ. Ŋkaoŋ a maa mieŋ vugu, a ni ŋgə̄ɨ nda luoŋ Minnwi mbīʼi pa nnu pugu pa ŋgwa Juu fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Pugu ni nchhu ghɔ ŋa pugu pugu laʼa nɔ ntaaŋ ndɨɨ, a lāa. ");
INSERT INTO bmo_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ndɔ a gha ŋgə̄ɨ nu, nchhu ni pugu ŋa, “M̈innwi mbiŋ, kaŋ ǹshi mbɨnɨ mbɨ̄nɨ.” Ndhɔ kiʼɛ Ɛfɛshɔ, nii moŋ pie ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","A ni ŋga ŋkaoŋ Kaisharia, ŋgə̄ɨ Jerushalɛiŋ nchrā ni chɔshi, nshwiʼi kiʼɛ Antiɔ. ");
INSERT INTO bmo_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A ni ŋga mbɔ fɔ nɔ yichəɨ fɨʼɨ ndɨɨ, ndɔllɔ nyīeŋ pa lɨʼɨlɨʼɨ moŋ Galashia, pugu pa Fragia, nthɔ māʼaŋ ghrɨ́ ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ndɨɨ ghɔ, ŋoŋ Juu chəɨ, ligi yi pɔ Apolo, llɔ Alɛshandria thɔ Ɛfɛshɔ. A ni mbɔ ŋoŋ ŋa a ni nja nji chrà, ndɔ nja nji Ŋwaʼaŋlɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A ni mfāʼo ntɨ́gɨ moŋ Shɛndaoŋ Taathɔ. A ni ǹchrā ndɔ njɛʼi pa nnu ki ntəɨ nthɛ Jishɔ ni ŋguoŋ niʼiŋ njùʼɔ ghao, njiʼi nthɛ pi nɔ haʼaŋ a ni ŋguʼɔ nji pi kwe ŋkhǐ Jouŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","A jɛ̄ nthɔ nchrā nu ni tɨnɨnjuʼɔ moŋ nda luoŋ Minnwi. Prishila pugu Akwila ni ŋga njaʼo vi, ndɔ̄gɔ vi ŋgə̄ɨ nɔ nda pugu mfɨ̄ʼɨ Shɛndaoŋ Minnwi ghɔ shishiʼi. ");
INSERT INTO bmo_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","A ni ŋga ntāʼa nu nshāʼa Akaya, pa ghaŋ piŋ fɔ ghɛ̄rɛ nāʼaŋ ŋwaʼaŋlɨ mfɛ ni ghaŋ piŋ Akaya, nchhu nu ŋa pi tuo vi a pwa. A ni ŋga nchəɨŋ Akaya, ŋgɛ̄rɛ ŋgwa pɛ ŋa pugu ni ntɔgɔ moŋ pwapuŋ Minnwi mbɔ ghaŋ piŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","A ni ndōu pi tɨtɨnɨ ti ŋgaʼa pa Juu shhɛnte nɔ nōoŋ nu ni pugu moŋ Ŋwaʼaŋlɨ Minnwi ŋa Jishɔ Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ shini. ");
INSERT INTO bmo_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo ni ŋga ŋguʼɔ mbɔ Koriŋ, Pɔɔ tɔgɔ krao khwi ŋgei ghɔ, nchəɨŋ Ɛfɛshɔ, njəɨ pichəɨ ghaŋ younjiŋ Jishɔ fɔ, ");
INSERT INTO bmo_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","mbie vugu ŋa, “Pi ni mfɛ Jijwɛ Minnwi ni pəɨ ndɨɨ ŋa pəɨ ni mbiŋ nɛ?” Pugu khwɛ̄ ŋa, “Ŋga! Pigi lɔ naa ndɔ njaʼo sheshe yaoŋ ŋa Jijwɛ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","A chhu ŋa, “Ti pəɨ ni ntɔgɔ pi moŋ yəɨ kwe ŋkhǐ?” Pugu ŋa, “Moŋ kwe ŋkhǐ Jouŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔɔ chhu ŋa, “Kwe ŋkhǐ Jouŋ ni mbɔ pi ni ŋgwa pɛ ŋa pugu pāʼa ŋkǔnu yugu ni phɨ nɛ, Jouŋ ghɔ ni nthɔ nchhu nu ni ŋgwa ŋa pugu piŋ ŋoŋ ŋa a thɔ nu njiŋ yu nɛ, mbɔ Jishɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pugu ni ŋga njaʼo yei, ŋkwe ŋkhǐ moŋ ligi Jishɔ Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔɔ gha nūʼɔŋ mbhɔ mi mbɨŋ pugu, Jijwɛ Minnwi shwiʼi mbɨŋ pugu, pugu chrà moŋ pa chrà taoŋ nduoŋ, ndɔ njəɨ pa nnu llɔ mbhɔ Minnwi nchhu. ");
INSERT INTO bmo_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ŋguoŋ pa pimbia ni mbɔ nɔ paanchrɔ. ");
INSERT INTO bmo_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔɔ ghə̄ɨ moŋ nda luoŋ Minnwi nchrā pugu pa ŋgwa fɔ ni tɨnɨnjuʼɔ nɔ trɛi nàoŋ nchrā nu ndɔ nthɔ ndɨ̄gəɨ vugu ŋa pugu piŋ Shaʼafuoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ndɔ pichəɨ tɨnɨthɔ ki lɔ mbiŋ, nchrā pa nnu pɨphɨ nthɛ Shɛndaoŋ Taathɔ shhɨ ŋguoŋ ŋgwa. Nthɛ yie ghɔ, Pɔɔ mieŋ vugu ndɔ̄gɔ pa ghaŋ younjiŋ Jishɔ pugu pugu ghə̄ɨ, sheshe llɛ́ a thɔ fāʼo chrà moŋ nda yɛʼi yaoŋ Tiranu. ");
INSERT INTO bmo_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Yei ni ŋgə̄ɨ shhɨ nɔ paa ŋgaʼo, nnɛ ti ŋguoŋ ŋgwa ŋa pugu ni nchhɔ pi Eshia nɛ ni njaʼo chrà Taathɔ, pa ŋgwa Juu pugu pa ŋgwa taoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Minnwi ni ntɔgɔ mbɨŋ Pɔɔ nthɔ nchwīe mɛmmɛ nnu ghraoghrao. ");
INSERT INTO bmo_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nɛnnɛ pi lɔ̄gɔ pra ndhwí pugu pa ndhwí fàʼa ŋa a ni ŋkwo fāʼa nɔ nɛ, ŋgə̄ɨ nɔ ŋkāoŋ pa ghaŋ ghɨ̌nɔ, pa ghɨ̌nɔ pugu mmɛ, pa jijwɛ pɨphɨ taoŋ mbɨŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pichəɨ ŋgwa Juu, ŋa pugu ni nthɔ nyīeŋ njōu pa jijwɛ pɨphɨ nɛ, mōoŋ nɔ yōu nu pa jijwɛ pɨphɨ ni ligi Jishɔ Taathɔ, nchhu nu ŋa, “M̀fɛ gɨ́ vɛ nɔ ligi Jishɔ ŋa Pɔɔ ghà nchīi nɛ, ŋa ɔ taoŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Khwachəɨ puoŋ pimbia, mbɔ puoŋ yichəɨ taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pa ŋgwa Juu, ligi yi pɔ Shikeva, ni nthɔ nyīeŋ nchwīe nnu yei. ");
INSERT INTO bmo_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ndɔ jijwɛ pɨphɨ ghɔ khwɛ̄ ni pugu ŋa, “Ǹji Jishɔ, nji pa nnu nthɛ Pɔɔ, ndɔ pəɨ pɔ yəɨ pi pa gɔ̌?” ");
INSERT INTO bmo_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ŋgaŋ jijwɛ pɨphɨ ghɔ lli nchəɨŋ mbɨŋ pugu ni pri, ŋgaʼa vugu ghao. Pugu tei ntaoŋ nda yu ntii ni pa lə̄ɨŋ mbɨŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ŋguoŋ pa Juu pugu pa ŋgwa taoŋ nduoŋ ŋa pugu ni ndaʼa nu Ɛfɛshɔ nɛ ni njaʼo yei nnu, pɔgɔ gu wɛ̄iŋ vugu, pi ghaʼo ligi Jishɔ Taathɔ mbīgi ŋgə̄ɨ shhɨ. ");
INSERT INTO bmo_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ntou pa ghaŋ piŋ thɔ shhɛnte mbiŋ fàŋ yugu ndɔ ntūgu pa nnu lə̄ɨŋ ŋa pugu ni nchwīe nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ntou pa ŋgwa ŋa pugu ni mbɔ pa ghaŋ shhɛ̌ nɛ thɔ ni pa ŋwaʼaŋlɨ shhɛ̌ pugu pi tūoŋ shhɛnte. Pi pīʼi nchuoŋ ŋwaʼaŋlɨ pighɔ a taoŋ tiɛŋ wuŋ ŋkaŋ yichəɨ ŋkwaŋ mbɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nɛnnɛ chrà Taathɔ nyīeŋ ŋgə̄ɨ shhɨ ŋkiɛŋ tɨtɨnɨ. ");
INSERT INTO bmo_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pa nnu pei ni ŋga ntɔgɔ, Pɔɔ lɔ̄gɔ nthi mi moŋ Jijwɛ nɔ tɔgɔ nu Mashedonia pugu Akaya ŋgə̄ɨ Jerushalɛiŋ. A ni nchhu nu ŋa, “Ǹshi ŋga ŋgə̄ɨ fɔ, ŋ̀guʼɔ ŋgə̄ɨ ti nchəɨŋ njəɨ laʼataoŋ Roma ŋkaa yu.” ");
INSERT INTO bmo_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pɔɔ ni ŋga ŋkwo taoŋ Timoti pugu Erashitu, mbɔ paa ghaŋ ghɛ̀rɛ pi Mashedonia, nduthɔ yi kɨna Eshia nɔ yichəɨ fɨʼɨ ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A ni mbɔ pi moŋ yei pɨɨ ndɨɨ ŋa ŋkiɛŋ tɨtɨnɨ lwilwiʼi ni ŋgū Ɛfɛshɔ nthɛ Shɛndaoŋ Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ŋgaŋ shūgu lìɛŋ chəɨ, ligi yi pɔ Demetriu, līɛŋ pa yaoŋ pugu fhi nda nnwi Atɛmi, pa ghaŋ fàʼa pi fāʼo ŋkiɛŋ ntou shéi ŋkuoŋ fàʼa yugu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetriu kɨrɨ pichəɨ ghaŋ fàʼa pighɔ pugu pa pichəɨ ghaŋ ŋkwaŋ fàʼa pighɔ, nchhu ni pugu ŋa, “Ŋgwa paŋ, pəɨ ji ŋa ŋguoŋ fàʼo pia llɔ pi ŋkuoŋ yei chofaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pəɨ yəɨ ndɔ njaʼo ni noŋ pəɨ, nnu ŋa ŋoŋ vei ŋa pi mɛ̄iŋ ni Pɔɔ, chwīe nu nɛ. A chhu ŋa pa nnwi ŋa pi chwīe ni mbhɔ nɛ lɔ njiʼi mbɔ pa nnwi kaŋ tɨgəɨ yi, ŋkwo ya mbaʼo ti ŋkara ntou ŋgwa hɛiŋ Ɛfɛshɔ pugu ŋguoŋ krao Eshia. ");
INSERT INTO bmo_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nnu wuwuru moŋ ghɔ lɔ ŋguʼɔ mbɔ pi ŋa yia fàʼa yei shi ŋgū shhɛ. A pɨnɨ mbīgi ŋa nda nnwi Atɛmi shi ŋgū nnu gha, nduthɔ Atɛmi ghɔ, ŋa ŋguoŋ Eshia pugu pa ŋguoŋ mbhi ghà ŋgaʼo nɛ, shiɛŋ ndighaʼo yi.” ");
INSERT INTO bmo_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pugu ni ŋga njaʼo yei nnu, ndɨnaoŋ ni pɨgɨtua, njɛ̄ paʼo nu ŋgòu, nchhu nu ŋa, “Atɛmi pa ŋgwa Ɛfɛshɔ, yi ndiɛŋ!” ");
INSERT INTO bmo_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mooŋ laʼa lɨnaoŋ ni fiŋthɔ ghao. Pugu tei ŋgə̄ɨ nii moŋ mmɛ lɨʼɨ ŋa ŋgwa ghà ŋkɨrɨ fɔ nɛ, nshūu Gayu pugu Arishtaku, mbɔ ŋgwa Mashedonia ŋa pugu pa Pɔɔ ni nyīeŋ nu kaʼa nɛ, nii nɔ moŋ lɨʼɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔɔ ni ntāʼa nu nii shɨna kɨrɨ ghɔ, ndɔ paʼa ghaŋ younjiŋ Jishɔ lɔ mieŋ vi ŋa a nii. ");
INSERT INTO bmo_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pichəɨ pa thishɨ Eshia ŋkaa pugu ŋa pugu ni mbɔ pa taannu Pɔɔ nɛ, lɨ̄gəɨ vi ŋa kiʼi a lɨ̄ɨ moŋ kɨrɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kɨrɨ ghɔ thɔ mbaʼo ŋgòu, pichəɨ chhu yei nnu, pichəɨ chhu yini nnu nthɛ ŋa fiŋthɔ ni mbɔ shɨna pugu. Paʼa ntou yi lɔ nji nnu ŋa pugu ni ŋkɨrɨ nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pichəɨ pa ŋgwa moŋ Kɨrɨ ghɔ fɛ ntɨgɨ ni Alɛshanda, ŋa pa Juu ni ntuʼɔ pi ju ntigi shhɨ, nnɛ, Alɛshanda nōoŋ ni mbhɔ yi ŋa ŋgwa lɛrɛ laŋ, ŋkaa nɔ fɨ̄ʼɨ nu mooŋ nnu pighɔ. ");
INSERT INTO bmo_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pugu gha njəɨ ŋa a pɔ pi ŋoŋ Juu, pugu mūʼuŋ yɔ̄nɔ nu nɔ paa awa, nchhu nu ŋa, “Atɛmi pa ŋgwa Ɛfɛshɔ, yi ndiɛŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ndugwi yi, ŋgaŋ nāʼaŋ ŋwaʼaŋlɨ laʼataoŋ ghɔ paʼo ndɛrɛ vugu, nchhu ni pugu ŋa, “Ŋgwa Ɛfɛshɔ! Shesheŋoŋ ji ŋa a tuo Ɛfɛshɔ ntuo nda nnwi ndiɛŋ Atɛmi pugu pa ŋgùʼɔ yi yei, ŋa a llɔ po ŋgū nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ŋa yei lɔ mbɔ nnu ŋa mimfɛ shesheŋoŋ lāa nɛ, a pie ŋa pəɨ lɛrɛ laŋ, ki lɔ nchwīe sheshe nnu tɨtɨnɨ. ");
INSERT INTO bmo_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nthɛ ŋa pəɨ thɔ ni ŋgwa pei hɛiŋ, mbɔ ŋgwa pɛ ŋa pugu lɔ njiʼi njōo yaoŋ nda nnwi ki nchrā chrà pɨphɨ nthɛ vi. ");
INSERT INTO bmo_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ä mbɔ ŋa Demetriu pugu pa ghaŋ fàʼa pi fāʼo pɨgɨ njùʼɔ nthɛ shesheŋoŋ, pia fāʼo pa thishɨ pia, pa ndashaʼa pia pɔ fɔ, a nthɛ pugu ghə̄ɨ mburu fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ndɔ ti ɔ mbɨnɨ mfāʼo nnu nduoŋ pi shaʼa nda nchaʼo. ");
INSERT INTO bmo_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nthɛ ŋa p̈ia shi nchwīe, pi shi ŋgwɛ̄iŋ via ŋa pia thɔ ni yɔ̀yɔnɔ shiʼa moŋ laʼa ki ŋkiɛŋ laʼo yi lɔ mbɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","A ni mīʼɛŋ chhu nu nnu yei, nchhu ŋgwa ghə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Yɔ̀yɔnɔ ni ŋga mmɛ, Pɔɔ gɛ̄ pa ghaŋ younjiŋ Jishɔ taʼa lɨʼɨ, ŋga māʼaŋ ghrɨ́ yugu, mieŋ vugu ndɔllɔ ŋgə̄ɨ Mashedonia. ");
INSERT INTO bmo_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A ni ŋga ntɔgɔ moŋ ŋguoŋ pa lɨʼɨ pighɔ ghao, ŋkwo māʼaŋ ghrɨ́ ghaŋ piŋ fɔ, ŋgə̄ɨ laʼataoŋ Gri. ");
INSERT INTO bmo_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","A ni ndaʼa fɔ nɔ trɛi nàoŋ, nɔ haʼaŋ a ni mbīri noŋ yi nɔ shāʼa nu ntaoŋ Shiria nɛ, njaʼo ŋa pa Juu thɔ nyiaŋ ntáŋ nthɛ vi nɛ, a lɔ̄gɔ nthí mi nɔ tɔgɔ nu Mashedonia mbɨ̄nɨ. ");
INSERT INTO bmo_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Shopata mbɔ muuŋ Pairu llɔ Bɛria ghə̄ɨ pugu pugu kaʼa, pugu pa Arishtaku ni Shɛkɔndɔ llɔ Teshalonika, ni Gayu llɔ Debi, ni Timoti ŋkaa yu pugu Taikiku ni Trɔfimu llɔ krao ŋgei Eshia. ");
INSERT INTO bmo_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pugu ni ŋgə̄ɨ shhɨ nchēi vigi Troa. ");
INSERT INTO bmo_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Llɛ́ Jɨ Brɛi ki kuʼɔ ni ŋga ntɔgɔ, pigi shāʼa llɔ Filipai, ŋga ndaʼa tiɛŋ llɛ́ pigi para vugu Troa, ndaʼa fɔ nɔ khwachəɨ llɛ́. ");
INSERT INTO bmo_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A ni ŋga mbɔ fǔoŋ llɛ́ moŋ shwiʼi taŋ, pigi kɨrɨ nɔ kru nu brɛi, Pɔɔ chrà ni pugu, mbīʼi nu nɔ ghə̄ɨ nu yua, nthɛ yie ghɔ, a wuʼɔ nchrachra ti mīʼɛŋ ni ntuŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ntou laŋ ni nthɔ ŋkɨɨ nu moŋ njiɛŋ nda tɔthɨ ŋa pigi ni ŋkɨrɨ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Yichəɨ maʼaŋ mikhwa, ligi yi pɔ Ɛutiku, ni nchhɔ nchò windu. Pɔɔ gha ŋguʼɔ nchrachra mbīgi ŋgə̄ɨ nu shhɨ nɛ, lɔgɔ ghaʼa maʼaŋ mikhwa ghɔ, a gū shhɛ llɔ moŋ trɛi yɛrɛ nda tɔthɨ, pi pɨʼɨ vi shhɛ a kwo khu. ");
INSERT INTO bmo_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔɔ shwiʼi shhɛ, mbaŋ vi nchhu ŋa, “Kiʼi pəɨ fāʼo yuʼɔ njùʼɔ, a wuʼɔ mbiʼi yi maoŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mbɨnɨ ŋkuʼɔ moŋ njíɛŋ nda tɔthɨ kiʼɛ, mbəʼɨ brɛi ŋkru. A ni ŋga nchrā pugu pa ghaŋ younjiŋ Jishɔ nɔ ntaaŋ ndɨɨ ti mbhi ya ndaŋ, ndɔllɔ ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Pa ghaŋ younjiŋ Jishɔ lɔ̄gɔ maʼaŋ mikhwa ghɔ pugu pugu pɨ̄nɨ laʼa, a wuʼɔ mbɔ yi maoŋ, pugu fāʼo ntou ghrɨnjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pigi lɔllɔ ŋgə̄ɨ shhɨ nii mitu ŋkhǐ nshāʼa ntaoŋ Ashoshi, lɨʼɨ tiɛŋ Pɔɔ nɔ haʼaŋ a ni ŋkwo chhu ni pigi nɛ, nthɛ ŋa a ni nyīeŋ pi shhɛ ŋgə̄ɨ nu fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pigi pugu ni ŋga mbāoŋ Ashoshi, pigi tiɛŋ vi moŋ mitu ŋkhǐ pigi pugu ghə̄ɨ Mitulɛnɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Pigi nyīeŋ llɔ fɔ mbhi gha ndaŋ pigi chəɨŋ mbɨŋ Kiou, yichəɨ mbra llɛ́ pigi shāʼa Shamo, mbhi gha mbɨnɨ ndaŋ pigi chəɨŋ Milɛtu. ");
INSERT INTO bmo_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔɔ lɔ̄gɔ nthí mi nɔ nyīeŋ nu moŋ ŋkhǐ mfərə Ɛfɛshɔ, nnɛ ŋa kiʼi a mīʼaŋ ndɨɨ Eshia, nthɛ ŋa a ni ŋkɔnɔ nu ŋgə̄ɨ Jerushalɛiŋ llɛ́ jɨ ŋa pi mɛ̄iŋ ni Pentekɔ nɛ, nɔ haʼaŋ a njiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pɔɔ ni ŋga mbɔ Milɛtu, ntaoŋ ŋkɨ̀nɨ Ɛfɛshɔ ŋa pa thishɨ moŋ chɔshi ghɔ thɔ njəɨ vi. ");
INSERT INTO bmo_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pugu ni ŋga nthɔ njəɨ vi, a chhu ni pugu ŋa, “Pəɨ ŋkaa pəɨ ji ŋkwaŋ haʼaŋ mi ni nchhɔ chɔmbhi a shɨna pəɨ jɛ̄ nɔ fǔoŋ llɛ́ ŋa mi ni ntigi kwò a Eshia nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mfāʼa mbhɔ Taathɔ ni ŋguoŋ junoŋ ghao, ni ŋkhǐ ligi pugu pa mōoŋ nu ŋa a ni nthɔ vəɨ llɔ ŋkuoŋ pa ntáŋ ŋa pa Juu ni ntaaŋ a nɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pəɨ ji ŋa ǹshini ndɔ ndə̄ɨŋ vəɨ ni sheshe yaoŋ ŋa a nthɛ a ghɛ̄rɛ vəɨ nɛ. Mi ni nchhu chrà Minnwi, ndɔ njɛʼi vəɨ shhɛnte pugu pa nda nda. ");
INSERT INTO bmo_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi ni nshūu tə́nə pa Juu pugu pa ŋgwa taoŋ nduoŋ ŋa pugu pāʼa ŋkǔnu yugu ni phɨ mbiŋ Minnwi, niʼiŋ njùʼɔ yugu mbɨŋ Jishɔ Krishto mbɔ Taathɔ. ");
INSERT INTO bmo_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ndɔ ndwɛ, līi njəɨ, ŋ̀gə̄ɨ nu nɛ Jerushalɛiŋ, nɔ haʼaŋ Jijwɛ Minnwi yiʼi a ŋa ŋ̀gə̄ɨ nɛ, ǹdɔ njiʼi nji nnu ŋa a shi nchwīe a fɔ nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ŋkiɛŋ ŋa Jijwɛ Minnwi kwo shūu tə́nə a ŋa moŋ sheshe laʼataoŋ, chə́ɨŋ pugu pa ŋgəʼɨ thɔ njwɛrɛ a. ");
INSERT INTO bmo_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ǹdɔ ndīi chɔmbhi a, a pɔ yichəɨ nnu vəɨ, ki a fāʼo pi yichəɨ ghɛ̀rɛ vəɨ. Ŋ̀guʼɔ ntāʼa nu mīʼɛŋ pi nnu ŋa Jishɔ Taathɔ ni mɛ̄iŋ a nɔ ŋkuoŋ mbhi nɛ, mbɔ chīi nu ŋkɨ̀nɨ pwa pishaʼakhɔ pwapuŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Līi njəɨ, ndwɛ, ǹji ŋa mbaʼa kaŋ taʼa ŋoŋ vəɨ nuʼuŋ njəɨ a ŋkamuʼɔŋ, mbɔ pəɨ ŋa ǹyīeŋ nthɔ nchīi Shaʼafuoŋ Minnwi shɨna pəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nɛnnɛ, ǹchhu ni pəɨ shiʼa yei ŋa s̈hesheŋoŋ vəɨ mbhɛ gha, kaŋ mbhɔ ma lɔ nɛ njiʼi mbɔ nɔ, ");
INSERT INTO bmo_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","nthɛ ŋa ǹshini ndɔ njiʼi ndə̄ɨŋ nɔ chhu nu ŋguoŋ pa nnu ŋa Minnwi lɔ̄gɔ nthi mi nɔ chwīe nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Nɛnnɛ, p̂əɨ lɨna ni noŋ pəɨ ndɔ mbɨnɨ ndɨna ni pa ŋgwa Minnwi ŋa Jijwɛ Minnwi nūʼɔŋ vəɨ ŋa pəɨ tigi ligi yəɨ mbɨŋ pugu nɛ, nɔ lɨna nu ni chɔshi Minnwi ŋa a yuoŋ ni chhǐ Muuŋ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ǹji ŋa ǹshi ŋga ŋgə̄ɨ, pa ŋgwa pɨphɨ nii shɨna pəɨ ŋgūo mbɨŋ pəɨ wuʼɔ nɔ haʼaŋ miŋaŋieŋ chɨgəɨchɨgəɨ ghà nchwīe ni pa minjɨɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ndɨɨ thɔ nu ŋa pichəɨ ŋgwa llɔ shɨna pəɨ shi ndɛʼi ŋgiɛŋ nɔ fɨ̄ɨ nu pichəɨ pa ghaŋ piŋ pugu yōu njiŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nthɛ yie ghɔ, pəɨ chhɔ ni lɨna məɨ, ŋkwiŋ nu ŋa nɔ trɛi ŋgaʼo, ǹshini ndɔ njiʼi ŋkɨna nɔ yɛʼi nu vəɨ moŋ tuʼu pugu pa naoŋchɨ ni ŋkhǐ ligi. ");
INSERT INTO bmo_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ndwɛ, ǹchāʼa vəɨ mfɛ mbhɔ Minnwi pugu pa chrà pwapuŋ yi ŋa a nthɛ a chwīe pəɨ kuʼɔ moŋ piŋ pugu pa mbɔrɔ ŋa Minnwi fɛ ni ŋguoŋ ŋgwa pi pi taoŋtaoŋ ghao nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Ǹshini ndɔ njiʼi nshɔ̄rɔ mbɨŋ ŋoŋ ki laoŋgo yi, ki ndhwí yi. ");
INSERT INTO bmo_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Pəɨ ŋkaa pəɨ ji ŋa mbhɔ ma mei yru ju ni mmu pigi pa pakwo paŋ. ");
INSERT INTO bmo_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ǹōoŋ ni pəɨ moŋ ŋguoŋ pa nnu ghao ŋa moŋ fāʼa nu ki jwɛ, pia ghɛ̄rɛ ŋgwa pɛ ŋa pugu lɔ mfāʼo nɛ nthɔ ŋkwiŋ pi chrà Jishɔ Taathɔ ŋa a ki chhu ŋa, ‘Ntou mbɔrɔ pɔ moŋ fɛ nu nchaa kwe nu.’ ” ");
INSERT INTO bmo_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","A ni ŋga nchrā ti mīʼɛŋ, ŋkwi kwɛ́rɛ yi shhɛ nduoŋ Minnwi pugu pugu ghao. ");
INSERT INTO bmo_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ŋguoŋ yugu ghao kə̄ɨ, mbaŋ vi, nɔ chaʼa vi ŋa a nyīeŋ shiʼi. ");
INSERT INTO bmo_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Njùʼɔ yugu lrī ŋkiɛŋ ntou yi nthɛ pa nnu ŋa a ni nchrā nɛ, ŋa mbaʼa pugu shi nuʼuŋ njəɨ vi ŋkamuʼɔŋ nɛ. Pugu lɔ̄gɔ vi ŋgə̄ɨ ntiʼi yəɨ mitu ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pigi ni ŋga nchāʼa vugu, nii moŋ mitu ŋkhǐ nchuʼɔ shhɛ, ntuŋ ndɨndɨ ntaoŋ Koshi, mbhi gha ndaŋ pigi ghə̄ɨ Rodeshi, ndhɔ fɔ ŋgə̄ɨ Patara. ");
INSERT INTO bmo_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pigi gha nchəɨŋ fɔ njəɨ mitu ŋkhǐ a ghə̄ɨ nu Fonishia, pigi nii moŋ ghɔ ŋgə̄ɨ. ");
INSERT INTO bmo_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pigi ni ŋga nthɔ ti njəɨ Shaipru, nchhwi nshwiʼi mbiɛŋ ntaoŋ Shiria, ntaoŋ ŋkaoŋ pie Tairɛ, nthɛ ŋa a lɨʼɨ ŋa mitu ŋkhǐ ghɔ ni mfāʼo nɔ fuʼu nu pa kaku fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ŋga njəɨ pa ghaŋ younjiŋ Jishɔ, ndaʼa fɔ pigi pugu nɔ khwachəɨ llɛmbhi. Ntɔgɔ mbhɔ njɨ Jijwɛ Minnwi, pugu chhu ni Pɔɔ ŋa kiʼi a ghə̄ɨ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Fɨʼɨ llɛmbhi ŋa a ni mbie ŋa pigi laʼa fɔ nɛ ni ŋga mmɛ, pigi lɔllɔ ŋgwɛ̄iŋ ndaoŋ ŋgə̄ɨ nu ŋguoŋ vugu ghao pugu pa ŋgwɛ pugu ni puoŋ pugu ghə̄ɨ ntiʼi vigi ti ntaoŋ moŋ laʼa, pigi kwi kwɛ́rɛ yigi ŋkɨŋ ŋkhǐ nduoŋ Minnwi, ");
INSERT INTO bmo_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","nchāʼa noŋ. Nɛnnɛ pigi nii mitu ŋkhǐ ŋgə̄ɨ, pugu pɨ̄nɨ yugu laʼa. ");
INSERT INTO bmo_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Pigi ni ŋga mīʼɛŋ nyìeŋ llɔ Tairɛ, nchəɨŋ Tolɛmai, nchrā ni pa ghaŋ piŋ ndaʼa fɔ nɔ taʼa llɛ́. ");
INSERT INTO bmo_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mbhi gha ndaŋ pigi lɔllɔ ŋgə̄ɨ Kaisharia, ŋgə̄ɨ nda Fili ŋgaŋ chīi pwa pishaʼakhɔ, mbɔ taʼa ŋoŋ shɨna pa khwachəɨ ŋgwa pɛ ŋa pi ni nchuʼɔ vugu Jerushalɛiŋ nɔ nnu ghɛ̄rɛ ŋgwa nɛ, ndaʼa pigi pugu. ");
INSERT INTO bmo_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A ni mfāʼo khwɛ puoŋ piŋgɛ ŋa pugu shi yaʼa laŋ nɛ, Minnwi nōoŋ nnu ni pugu pugu chhu. ");
INSERT INTO bmo_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nɔ haʼaŋ pigi ni ndaʼa nɔ yichəɨ fɨʼɨ llɛ́ nɛ, njəɨlɨʼɨ Minnwi chəɨ, ligi yi pɔ Agabu, llɔ Judia nshwiʼi. ");
INSERT INTO bmo_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","A ni nthɔ mbara vigi, ndɔ̄gɔ ŋkandaŋ Pɔɔ, ŋkrao kwò nduthɔ yi nɔ ghɔ pugu pa mbhɔ mi nchhu ŋa, “Yei nnu ŋa Jijwɛ Minnwi chhu nɛ, ‘Yei haʼaŋ pa Juu Jerushalɛiŋ shi ŋkrao ŋgaŋ ŋkandaŋ yei nchaʼa vi mfɛ mbhɔ ŋgwa taoŋ nduoŋ.’ ” ");
INSERT INTO bmo_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Pigi ni ŋga njaʼo nnu yei, pigi pa ŋgwa haʼaŋ pugu ni mbɔ fɔ nɛ, ndɨ̄gəɨ vi ŋa kiʼi a kuʼɔ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nɛnnɛ Pɔɔ khwɛ̄ ŋa, “Pəɨ chwīe pi nɛiŋ, ŋkə̄ɨ nu nthɔ mbəʼɨ njùʼɔ a? Nthɛ ŋa ǹdɔ ŋguʼɔ mbīri noŋ a pi nɔ ghə̄ɨ nu chə́ɨŋ, a njiʼi mbɔ pi gu ŋ̀guʼɔ ŋkukhu Jerushalɛiŋ nɔ ligi Jishɔ Taathɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pigi ni ŋga ndɨ̄gəɨ vi kikie, mieŋ vi fɔ nchhu ŋa, “Nnu ŋa Taathɔ tāʼa nu nɛ pɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Llɛ́ pei ni ŋga ntɔgɔ, pigi pīri noŋ yigi ŋkuʼɔ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Pigi pa pichəɨ ghaŋ younjiŋ Jishɔ llɔ Kaisharia pugu lɔ̄gɔ vigi ŋgə̄ɨ ni pigi nda Nashoŋ llɔ Shaipru mbɔ pa fǔoŋ ghaŋ piŋ, nnɛ ŋa pigi pugu laʼa kaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Pigi ni ŋga nthɔ nchəɨŋ Jerushalɛiŋ, pa ghaŋ piŋ shwiʼi pìɛŋ pigi ni pwanjuʼɔ. ");
INSERT INTO bmo_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mbhi gha ndaŋ, pigi pa Pɔɔ ghə̄ɨ njəɨ Jɛiŋ. Ŋguoŋ pa thishɨ ni mbɔ fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔɔ ni ŋga nchrā ni pugu, mfɨ̄ʼɨ ŋguoŋ nnu ŋa Minnwi chwīe shɨna pa ŋgwa taoŋ nduoŋ ntɔgɔ mbhɔ yu nɛ, pa taʼa yi pa taʼa yi. ");
INSERT INTO bmo_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pugu ni ŋga njaʼo, ŋgaʼo Minnwi. Nchhu ghɔ kiʼɛ ŋa, “Ɔ yəɨ nu ndǐŋ vigi, fɨʼɨ ŋkaŋŋkaŋ ŋgwa Juu haʼaŋ pugu piŋ Minnwi, ndɔ mfāʼo ŋkiɛŋ ntou niʼiŋ njùʼɔ ŋkuoŋ gɨ́ Mushi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Pi kwo chhu pa nnu ni pugu nthɛ ghɔ ŋa ɔ yɛʼi ŋguoŋ pa Juu ŋa pugu laʼa nu shɨna ŋgwa taoŋ nduoŋ nɛ, ŋa kiʼi pugu nūʼɔŋ gɨ́ Mushi, nchhu nu ni pugu ŋa kiʼi pugu niʼiŋ puoŋ pugu ŋgunu mbrɛi, ki nchwīe nùʼɔŋ pa ŋgwa Juu. ");
INSERT INTO bmo_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ti pi shi nchwīe pi nɛiŋ? Nthɛ ŋa pugu shi njaʼo ŋa ɔ thɔ. ");
INSERT INTO bmo_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“Yei nnu ŋa pigi tāʼa nu ŋa ɔ chwīe nɛ. Khwɛ ŋgwa pɔ hɛiŋ haʼaŋ pugu kwo lɔ̄gɔ kàʼa shhɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ghə̄ɨ pəɨ pugu kaʼa, nchwīe pa nùʼɔŋ nɔ pɔ nu yi taoŋtaoŋ, ɔ lɔ mbe yaoŋ ŋa a pie ŋa pugu fɛ nɔ chwīe nu nùʼɔŋ ghɔ nnɛ ŋa mimfɛ pi kiri thɔ yugu. Nnɛ kaŋ pugu ŋkaa pugu shi nji ŋa nnu shini lɔ mbɔ moŋ pa nnu haʼaŋ pi chhu nthɛ ghɔ, ŋa gɔ̀ nduthɔ yɔ ghà nūʼɔŋ gɨ́. ");
INSERT INTO bmo_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Ndɔ ni ŋgwa taoŋ nduoŋ ŋa pugu piŋ Minnwi nɛ, pigi kwo nāʼaŋ ŋwaʼaŋlɨ mfɛ ni pugu ŋa kiʼi pugu jɨ maoŋ ŋa pi fɛ̄ʼi pa nnwi nɔ ghɔ nɛ, kiʼi pugu jɨ chhǐ, kiʼi pəɨ kru minyieŋ ŋa pi nɨ̄naoŋ mmi yi a khu ki chhǐ lɔ ntaoŋ mbɨŋ yu nɛ, kiʼi pugu kwoshuoŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nnɛ, Pɔɔ ghə̄ɨ pugu pa ŋgwa pighɔ. Mbhi gha ndaŋ pugu pugu chwīe noŋ yugu mbɔ yi taoŋtaoŋ, ŋgə̄ɨ Nda Minnwi, nɔ chhu nu llɛmbhi ŋa a piʼi pugu lūgwi chwīe nu nùʼɔŋ nɔ pɔ nu yi taoŋtaoŋ, ndɔ shi nthɔ ni maoŋ fɛʼiŋgiɛŋ nɔ fɛ nu nɔ thɔ shesheŋoŋ vugu. ");
INSERT INTO bmo_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Khwachəɨ llɛ́ ghɔ ni ŋga ŋkwo mmɛ nu, pichəɨ ŋgwa Juu llɔ Eshia gha njəɨ Pɔɔ Nda Minnwi, niʼiŋ puŋ yú ŋgwa pɛ ŋa pugu ni mbɔ fɔ nɛ ndɔ ŋgwɛ̄iŋ vi nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","mbaʼo ŋgòu ŋa, “Ŋgwa Ishrae pəɨ kwe vigi! Yei ŋoŋ yɛ ŋa a nyīeŋ ŋguoŋ lɨʼɨ nthɔ njɛʼi ŋgwa ni nnu pɨphɨ nthɛ ŋgwa Ishrae pugu pa gɨ́ Mushi pugu pa Nda Minnwi yei. Nɔ pīgi nu, a lɔ̄gɔ pa ŋgwa taoŋ nduoŋ nthɔ mfuo lɨʼɨ taoŋtaoŋ yei.” ");
INSERT INTO bmo_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Pugu ni nchhu nnɛ nthɛ ŋa pugu ni ŋkwo fǔoŋ njəɨ vi pugu Trɔfimu mbɔ ŋoŋ llɔ Ɛfɛshɔ moŋ laʼa, nthɔ mbīʼi nu ŋa ju, Pɔɔ, ntiɛŋ vi nthɔ nɔ Nda Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Fiŋthɔ gū moŋ ŋguoŋ laʼa ghao, pa ŋgwa pighɔ tei ŋgə̄ɨ ŋgwɛ̄iŋ Pɔɔ nshūu vi ntaoŋ nɔ Nda Minnwi, nchri choŋkaʼa wuʼɔ ndɨɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nɔ haʼaŋ pugu ni mbaʼo nu nɔ jwi nu Pɔɔ nɛ, ŋkɨ̀nɨ chəɨŋ mbhɔ taathɔ pa ghaŋ māʼaŋ nchhɔ̀ Roma ŋa ŋguoŋ Jerushalɛiŋ pɔ moŋ fiŋthɔ. ");
INSERT INTO bmo_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Wuʼɔ ndɨɨ ghɔ a lɔ̄gɔ pa shoogɛ pugu pa thishɨ taʼa ŋkɨɨ shoogɛ, pugu pugu tei ŋgə̄ɨ njəɨ ŋgwa pighɔ. Pa ŋgwa pighɔ ni ŋga njəɨ vi pugu pa shoogɛ pighɔ, mieŋ wie nu Pɔɔ. ");
INSERT INTO bmo_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Taathɔ ghɔ ghə̄ɨ ŋgwɛ̄iŋ Pɔɔ, mfɛ gɨ́ ŋa pi krao vi ni paa ndigi chɛiŋ. Ndɔ mbie kiʼɛ ŋa, “Ŋoŋ vei pɔ pi gɔ̌? A lɔ nchwīe pi nɛiŋ?” ");
INSERT INTO bmo_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Pichəɨ ŋgwa moŋ kɨrɨ ghɔ paʼo ŋgòu nchhu yei nnu, pichəɨ chhu yini. A gha mieŋ ki yaʼo laʼo nnu pighɔ, nthɛ ntou yɔ̀yɔnɔ a fɛ gɨ́ ŋa pi niʼiŋ vi moŋ lɨʼɨ ŋa pa shoogɛ ghà nchhɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ndɨɨ ŋa pi ni nchəɨŋ ni ju ni mbɨŋ nchwi nda nɛ, pa shoogɛ pighɔ ya ntiɛŋ vi tiɛŋ nthɛ fɨʼɨ kɨkrɨ ŋa yú ŋgwa pighɔ ni nthɔ nu nɔ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yú ŋgwa pighɔ wuʼɔ nthɔ nu njiŋ yu mbaʼo ŋgòu ŋa, “Pəɨ mīʼɛŋ ni ju!” ");
INSERT INTO bmo_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nɔ haʼaŋ pi ni ntāʼa nu nii ni Pɔɔ moŋ lɨʼɨ ŋa pa shoogɛ ghà mbɔ nɛ, a chhu ni taathɔ pa shoogɛ pighɔ ŋa, “N̂chhu nnu vɛ?” A pie vi ŋa, “Ɔ ji chrà Gri? ");
INSERT INTO bmo_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","A lɔ mbɔ gɔ̀ mbɔ ŋoŋ Ijipti ŋa a ni nthɔ ni tɨnɨthɔ ndɔ̄gɔ khwɛ ŋkaŋ mikija pəɨ pugu nii moŋ ŋkǔnu njó nɛ?” ");
INSERT INTO bmo_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔɔ khwɛ̄ ŋa, “M̀bɔ pi ŋoŋ Juu llɔ Tashɔ moŋ Shilishia, ŋoŋ llɔ moŋ mmɛ laʼataoŋ. Ǹdɨ̄gəɨ ghɔ mieŋ ǹchhu nnu ni ŋgwa pei.” ");
INSERT INTO bmo_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nthishɨ pa shoogɛ ghɔ piŋ, nnɛ Pɔɔ thi ŋkuoŋ pa nchwi nda pighɔ nōoŋ ni mbhɔ yi ŋa ŋgwa pighɔ lɛrɛ laŋ. Pugu ni ŋga ndɛrɛ laŋ, Pɔɔ chrà ni pugu moŋ chrà Hibru, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Lǐŋ paŋ pugu pa tǎa paŋ, pəɨ yaʼo ŋkwaŋ nɔ haʼaŋ ǹshi ntaa noŋ a ndwɛ shhɨ pəɨ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pugu gha njaʼo a chrà pi moŋ chrà Hibru, pugu pɨnɨ nja ndɛrɛ laŋ. Pɔɔ ghə̄ɨ shhɨ nchhu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mi ŋoŋ Juu, pi phi a Tashɔ moŋ Shilishia ndɔ ŋ̀kuʼɔ pi hɛiŋ moŋ Jerushalɛiŋ mbhɔ Gamalia mbɔ masha a. M̀fāʼo ŋkiɛŋ tɨtɨnɨ ntɨ́gɨ moŋ gɨ́ pa tǎa pia, mfɛ noŋ a ni Minnwi wuʼɔ nɔ haʼaŋ ŋguoŋ vəɨ haʼaŋ pəɨ thi hɛiŋ shiʼa fɛ noŋ yəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ŋki fɛ ŋgəʼɨ ni ŋgwa ŋa pugu younjiŋ Shɛndaoŋ yei nɛ, ti pichəɨ khu. Ŋki wɛ̄iŋ mbia pugu pa piŋgɛ niʼiŋ vugu chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pa taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa kúŋ nthɛ pugu kwe ntie a ŋa ǹchhu pi nnu shini. Pugu ni nāʼaŋ pa ŋwaʼaŋlɨ mfɛ vəɨ ŋ̀gə̄ɨ mfɛ ni pa ŋgwa Juu Damashiku, nɛnnɛ, ŋ̀gə̄ɨ fɔ nɔ wɛ̄iŋ nu ŋgwa ŋa pugu ni mbɔ fɔ nɛ ŋkrao vugu mbɨnɨ ni pugu Jerushalɛiŋ pi fɛ njɔ́ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nɔ haʼaŋ ŋki nyīeŋ ŋgə̄ɨ nu ti mbara mbɨŋ Damashiku nɛ, nnu ni ntuŋ minaoŋ, líʼɛ llɔ po wīʼi nshei yəɨ mu. ");
INSERT INTO bmo_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ŋ̀gū shhɛ, njaʼo yichəɨ ŋggì chhu nu vəɨ ŋa, ‘Shɔɔ, Shɔɔ, ɔ thɔ mfɛ ŋgəʼɨ vəɨ nɔ khɔ?’ ");
INSERT INTO bmo_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ŋ̀khwɛ̄ ŋa, ‘Ɔ pɔ pi gɔ̌, Taathɔ?’ “A chhu ŋa, ‘Mi Jishɔ llɔ Nasharɛ ŋa ɔ thɔ mfɛ ŋgəʼɨ ghɔ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ŋgwa haʼaŋ pigi pugu ni mbɔ kaʼa nɛ, ni njəɨ líʼɛ ghɔ ndɔ paʼa ndɔ njaʼo nji ŋggì ŋoŋ ŋa a ni nchrā nu vəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Nchhu ŋa, ‘Mi shi nchwīe pi nɛiŋ, Taathɔ?’ “Taathɔ chhu vəɨ ŋa, ‘Lɔllɔ ŋgə̄ɨ Damashiku, pi shi nshwei ghɔ fɔ ni ŋguoŋ nnu ŋa Minnwi nūʼɔŋ ŋa ɔ chwīe nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ligi ma nchri nthɛ fɨʼɨ ŋkwaŋ nɔ haʼaŋ líʼɛ ghɔ ni nthɛ nɛ, nthɛ yie ghɔ, pakwo paŋ wɛ̄iŋ mbhɔ a ŋgə̄ɨ ni mu moŋ Damashiku. ");
INSERT INTO bmo_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ŋoŋ chəɨ ni mbɔ moŋ laʼataoŋ Damashiku, ligi yi pɔ Anania, mbɔ ŋkiɛŋ ŋgaŋ pɔgɔ Minnwi ndɔ nūʼɔŋ ŋguoŋ gɨ́ ghao, ŋguoŋ pa ŋgwa Juu līi vi ŋa a ŋkiɛŋ ŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","A thɔ ntithi yəɨ mu nchhu ŋa, ‘Ndǐŋ a Shɔɔ, pɨnɨ njəɨ lɨʼɨ,’ wuʼɔ chomilaoŋ ghɔ, ligi a chuʼɔ ǹjəɨ vi. ");
INSERT INTO bmo_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“A chhu ŋa, ‘Minnwi pa ŋkhu tǎa pia chuʼɔ ghɔ ŋa ɔ ji nnu ŋa a kāʼa nɔ chwīe nu nɛ, nɔ yəɨ nu Muuŋ Fàʼa vi yi Ndɨndɨ, ndɔ njaʼo ŋggì yi a chrà nu. ");
INSERT INTO bmo_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ɔ shi mbɔ miŋkwentie yi ni ŋguoŋ ŋgwa nɔ nchhu nu pa nnu pɛ ŋa ɔ yəɨ ndɔ njaʼo nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ɔ nuʼuŋ nchēi pi khɔ ndwɛ, yrɛi shhɛ, ŋkwe ŋkhǐ nduoŋ Minnwi a shɨ̄gao phɨ yɔ.’ ");
INSERT INTO bmo_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“M̀bɨnɨ Jerushalɛiŋ ŋga nthɔ nduoŋ Minnwi moŋ Nda Minnwi, njəɨ nnu. ");
INSERT INTO bmo_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Moŋ nnu ghɔ ǹjəɨ Taathɔ a chhu vəɨ ŋa, ‘Kɔnɔ ntaoŋ Jerushalɛiŋ ni njɨ, nthɛ ŋa mbaʼa ŋgwa pei piŋ nnu ŋa ɔ shi nchhu nthɛ a nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ŋ̀khwɛ̄ ŋa, ‘Taathɔ, pugu ni noŋ pugu ji ŋa ŋki nyīeŋ moŋ sheshe nda luoŋ Minnwi ŋgwɛ̄iŋ pa ŋgwa ŋa pugu piŋ ghɔ nɛ, niʼiŋ vugu chə́ɨŋ ndɔ ŋgwie pichəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ndɨɨ ŋa pi ni nchhɔ njwi miŋkwentie yɔ mbɔ Shitifiŋ nɛ, mmu nduthɔ a ni mbɔ fɔ, mbiŋ nu ŋa pi jwi vi, ndɨna nu ni ndhwí ŋgwa pɛ ŋa pugu ni thɔ njwi vi nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Taathɔ chhu vəɨ ŋa, ‘Ghə̄ɨ! Nthɛ ŋa ǹshi ntaoŋ ghɔ fie hini ni ŋgwa laʼataoŋ nduoŋ.’” ");
INSERT INTO bmo_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ŋgwa pighɔ ni ŋguʼɔ njwɛrɛ nu ti ŋga njaʼo yei, ŋkə̄rə ŋggì yugu nchhu ŋa, “Pəɨ mīʼɛŋ ni ju, a lɔ mfāʼo nɔ chhɔ nu mbhi!” ");
INSERT INTO bmo_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ndɔ haʼaŋ pugu ni mbaʼo ŋgòu, nshrāo ndhwí yugu mfiri nu, ndɔ māʼaŋ pru moŋ tɔthɨ nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","taathɔ pa shoogɛ Roma fɛ gɨ́ ŋa pi lɔ̄gɔ Pɔɔ ŋgə̄ɨ ni ju moŋ lɨʼɨ ŋa pa shoogɛ ghà nchhɔ nɛ, ndɔ nchhu pugu wie vi nɔ tāʼa nu laʼo nnu ŋa a chwīe pa ŋgwa Juu thɔ mbaʼo ŋgòu thɔ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ndɔ pugu ni ŋga ŋkwo krao vi nɔ wie nu, Pɔɔ pie ni taʼa nthishɨ pa taʼa ŋkɨɨ shoogɛ ŋa a ni nthi fɔ nɛ ŋa, “Gɨ́ piŋ ŋa pi wie ŋoŋ Roma ki lɔ naa nshaʼa vi njəɨ ŋa a gū sháʼa?” ");
INSERT INTO bmo_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ndɨɨ ŋa nthishɨ pa taʼa ŋkɨɨ shoogɛ ghɔ ni njaʼo nnu yei nɛ, ŋgə̄ɨ nchhu ni taathɔ pa shoogɛ ŋa, “Ɔ tāʼa nchwīe pi nɛiŋ? Nthɛ ŋa ŋoŋ vei pɔ pi ŋoŋ Roma.” ");
INSERT INTO bmo_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Taathɔ pa shoogɛ pighɔ ghə̄ɨ mbie vi ŋa, “Shwei a, ɔ ŋoŋ Roma?” Pɔɔ khwɛ̄ ŋa, “Ooŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Taathɔ pa shoogɛ pighɔ chhu ŋa, “Njuoŋ pi ni ŋkiɛŋ ntou mbɨŋ maa mbɔ ŋoŋ Roma.” Pɔɔ khwɛ̄ ji ŋa, “Pi phi a phi nɔ ŋoŋ Roma.” ");
INSERT INTO bmo_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nnɛ ŋgwa pɛ ŋa pugu ni mbɔ nɔ tou nu mi nɛ kāʼo mbɨ̄nɨ pɨ̄nɨ ndɨɨ ghɔ. Taathɔ pa shoogɛ ghɔ pɔgɔ nthɛ ŋa a ni nji ndɨɨ ghɔ ŋa Pɔɔ pɔ pi ŋoŋ Roma a kwo lɔ ŋkrao vi. ");
INSERT INTO bmo_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ndɔ mbhi ni ŋga ndaŋ, taathɔ pa shoogɛ pighɔ tāʼa nu nja nji nnu ŋa a chwīe pa ŋgwa Juu paʼo ŋgòu thɔ yu nɛ, ŋkɨ̄gɛi vi, ŋgɛ̄ pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa kúŋ, nshwiʼi ni Pɔɔ kiʼɛ ntigi vi shhɨ pugu. ");
INSERT INTO bmo_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔɔ chaoŋ ligi yi mbɨŋ pa kúŋ nchhu ŋa, “Lǐŋ paŋ, ŋgaŋthɔ a lɔ njiʼi ŋkhu moŋ ŋkwaŋ haʼaŋ ǹchhɔ chɔmbhi a shhɨ Minnwi ti nthɔ nchəɨŋ shiʼa nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ mbɔ Anania fɛ gɨ́ ni ŋgwa haʼaŋ pugu ni nthi mbara yəɨ Pɔɔ nɛ ŋa pugu chrə̄ɨ lrì thɔ Pɔɔ. ");
INSERT INTO bmo_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nɛnnɛ, Pɔɔ chhu ghɔ ŋa, “Minnwi shi nchrə̄ɨ ghɔ ŋkaa ghɔ, ma ŋgaŋ mbe vei. Ɔ chhɔ hɛnɛ nɔ shaʼa nu ma ŋkwaŋ haʼaŋ gɨ́ chhu nɛ, ndɔ mbəʼɨ gɨ́ ghɔ ŋkaa ghɔ nɔ chhu nu ŋa pi chrə̄ɨ a?” ");
INSERT INTO bmo_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ŋgwa haʼaŋ pugu ni nthi yəɨ Pɔɔ nɛ chhu ŋa, “Ɔ kie nɛiŋ ŋgwɛʼi taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ Minnwi?” ");
INSERT INTO bmo_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔɔ khwɛ̄ ŋa, “Lǐŋ paŋ ǹshini ndɔ nji ŋa a taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ, nthɛ ŋa pi nāʼaŋ ŋa kiʼi nchrā nnu pɨphɨ nthɛ ghaŋ shaʼa ŋgwa pəɨ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ndɔ Pɔɔ ni ŋga njəɨ ŋa taʼa ghrà kɨrɨ ghɔ pa ŋgwa Shadushi yichəɨ taʼa pɔ Farashi, a paʼo ŋgòu nda pa kúŋ ŋa, “Lǐŋ paŋ, mi ŋoŋ Farashi, a phi ŋoŋ Farashi mbhi a. Pi shaʼa a hɛiŋ shiʼa nthɛ ŋa ǹjwɛrɛ nu ni tɨnɨnjuʼɔ ŋa ŋgwa ŋa pugu ŋkhu nɛ shi mbɨnɨ ŋkuʼɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","A ni ŋga nchhu yei nnu, mindoundou gū shɨna pa ŋgwa Farashi pugu pa ŋgwa Shadushi, kɨrɨ ghɔ shɨna ntaoŋ nduoŋnduoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nthɛ ŋa pa ŋgwa Shadushi ghà nchhu ŋa ŋoŋ shiʼa ŋkhu mbɨnɨ ŋkuʼɔ, paʼa pa ghaŋ ntaoŋ Minnwi lɔ mbɔ, ndɔ paʼa pa Jijwɛ lɔ mbɔ, ndɔ ŋgwa Farashi piŋ ŋguoŋ pa nnu pei ghao. ");
INSERT INTO bmo_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Mmɛ yɔ̀yɔnɔ mūʼuŋ, pichəɨ pa ghaŋ yɛʼi ŋgwa ni gɨ́ Mushi ŋa pugu ni mbɔ moŋ taʼa ghrà pugu pa ŋgwa Farashi nɛ tithi ndōu nu ŋa, “Pigi lɔ njəɨ fàŋ ŋoŋ vei, pəɨ ji nɛiŋ ŋa yichəɨ jijwɛ, ki ŋgaŋ ntaoŋ Minnwi chrà ghɔ?” ");
INSERT INTO bmo_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Minduoŋnduoŋ ghɔ ni ŋga nchəɨŋ móŋoŋ, taathɔ pa shoogɛ pighɔ pɔgɔ ŋa pi shi nshāa Pɔɔ prapra, mfɛ gɨ́ ni pa shoogɛ ŋa pugu shwiʼi mfuʼu vi ni ghrɨ́ shɨna ŋgwa pighɔ nthɔ nɔ lɨʼɨ haʼaŋ pa shoogɛ ghà nchhɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tuʼu gha shini, Taathɔ thi yəɨ yu nchhu ŋa, “Fāʼo tɨnɨnjuʼɔ, wuʼɔ ŋkwaŋ haʼaŋ ɔ chīi ligi a Jerushalɛiŋ nɛ, a wuʼɔ ŋkwaŋ haʼaŋ ɔ shi nchīi moŋ laʼataoŋ Roma nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mbhi ni ŋga ndaŋ, pichəɨ pa ŋgwa Juu nyiaŋ ntáŋ, ŋgwrā kɨ̀na ŋa mbaʼa pugu njɨ yaoŋ, ki nnu sheshe yaoŋ, kaŋ a nɛ pugu jwi Pɔɔ. ");
INSERT INTO bmo_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ŋgwa ŋa pugu ni nyiaŋ ntáŋ ghɔ nɛ ni ntɔgɔ khwɛ wuŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Pugu lɔllɔ ŋgə̄ɨ mbara pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa pichəɨ pa thishɨ nchhu ŋa, “Pigi wrā kɨ̀na ŋa mbaʼa pigi jɨ sheshe yaoŋ ti nuʼuŋ njwi Pɔɔ. ");
INSERT INTO bmo_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nthɛ yie ghɔ, pəɨ pa pichəɨ pa kúŋ taoŋ ŋkɨ̀nɨ ni taathɔ pa shoogɛ Roma ŋa a taoŋ Pɔɔ ni pəɨ. Pəɨ chwīe nɔ haʼaŋ pəɨ tāʼa nu ntou pi mooŋ nnu ghɔ shiʼi nɔ ji nu pa nnu nthɛ vi. Pigi kwo pīri noŋ yigi nɔ jwi nu vi ŋkaoŋ a maa ndɔ nchəɨŋ hɛiŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ndɔ muuŋ mimbia mbɔ muuŋ ndǐŋ Pɔɔ yi miŋgwɛ ni njaʼo ntáŋ yei, ŋgə̄ɨ lɨʼɨ haʼaŋ pa shoogɛ ghà nchhɔ nɛ nshwei Pɔɔ nɔ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Nɛnnɛ, Pɔɔ mɛ̄iŋ taʼa nthishɨ pa taʼa ŋkɨɨ shoogɛ nchhu ghɔ ŋa, “Lɔ̄gɔ muuŋ vei ŋgə̄ɨ nɔ ghɔ shhɨ taathɔ pa shoogɛ nthɛ ŋa a fāʼo nnu nɔ chhu nu ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nɛnnɛ, nthishɨ ghɔ lɔ̄gɔ vi pugu yu ghə̄ɨ njəɨ taathɔ pa shoogɛ nchhu ŋa, “Pɔɔ, yichəɨ taʼa ŋgaŋ chə́ɨŋ, mɛ̄iŋ a nchhu vəɨ ŋa ǹdɔ̄gɔ muuŋ vei nthɔ njəɨ ghɔ nɔ, nthɛ ŋa a fāʼo nnu nɔ chhu nu vɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Taathɔ pa shoogɛ ghɔ wɛ̄iŋ mbhɔ yi pugu yu ghə̄ɨ lɨʼɨ haʼaŋ ŋgwa lɔ mbɔ nɛ, a pie vi njiŋnjiŋ ŋa, “Nnu ŋa ɔ tāʼa nu nchhu vəɨ nɛ pɔ pi khɔ?” ");
INSERT INTO bmo_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Muuŋ ghɔ khwɛ̄ ŋa, “Pa Juu taaŋ ŋa pugu shi nchhu vɛ ŋa ɔ taoŋ Pɔɔ ni pa kúŋ yua nɔ haʼaŋ pugu tāʼa nu ntou vi tou nji pa nnu nthɛ vi shishiʼi. ");
INSERT INTO bmo_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ndɔ kiʼi njaʼo nnu ŋa pugu chhu nu nɛ, nthɛ ŋa pugu tɔgɔ khwɛ wuŋ yugu ŋa pugu kwo taaŋ ti ŋgwrā kɨ̀na ŋa mbaʼa pugu jɨ ki nnu sheshe yaoŋ ki lɔ naa njwi vi, ŋkwo lɛrɛ nthɔ njwɛrɛ vi. Ti ndwɛ, pugu kwo pīri noŋ yugu nthɔ njwɛrɛ khwɛ̀ pi mbhɔ ghɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nɛnnɛ, taathɔ pa shoogɛ chhu ni muuŋ ghɔ ŋa a ghə̄ɨ ni vhi ndɔ mfɛ gɨ́ ghɔ ŋa, “Kiʼi nchwīe shesheŋoŋ ji ŋa ɔ kwo chhu nnu yei vəɨ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Taathɔ pa shoogɛ ghɔ mɛ̄iŋ paa nthishɨ pa taʼa ŋkɨɨ shoogɛ nchhu ŋa, “Pəɨ pīri paa ŋkɨɨ pa shoogɛ nɔ ghə̄ɨ nu Kaisharia pəɨ pa khwachəɨ wuŋ ghaŋ māʼaŋ nchhɔ̀ ni minyieŋləɨ pugu pa paa ŋkɨɨ ghaŋ māʼaŋ nchhɔ̀ ni khwǎ, mbīri nɔ llɔ nu moŋ ndipuʼu minaoŋ ni tuʼu. ");
INSERT INTO bmo_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Fɛ pichəɨ pa ŋkwɛ́iŋ ni Pɔɔ a kuʼɔ pəɨ ghə̄ɨ ni ju mfɛ vi ni Feli, mbɔ mmɛ ŋgaŋ shaʼa ŋgwa shiʼi, ki kàʼa lɔ ŋkēe vi.” ");
INSERT INTO bmo_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Taathɔ pa shoogɛ ghɔ nāʼaŋ ŋwaʼaŋlɨ, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ŋwaʼaŋlɨ yei nāʼaŋ mmu Klaudiu Lishia vɛ, ma Feli ŋoŋ ndiɛŋ, ǹchrā vɛ. ");
INSERT INTO bmo_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Pa ŋgwa Juu ni ŋgwɛ̄iŋ ŋoŋ vei ntāʼa nu njwi vi. Ŋ̀ga nthɔ mbara vi pigi pa shoogɛ ŋkwe vi, njaʼo ŋa a pɔ pi ŋoŋ laʼataoŋ Roma. ");
INSERT INTO bmo_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ŋki tāʼa nu nji nnu ŋa pugu ni ŋgwɛ̄iŋ vi nɔ nɛ, nɛnnɛ, ŋ̀gə̄ɨ ni ju nda pa kúŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ŋki gha ntāʼa, njəɨ ŋa pa nnu haʼaŋ pi ni ŋgwɛ̄iŋ vi nɔ ghɔ nɛ lɔ mbɔ pa nnu haʼaŋ a nthɛ pi jwi vi, ki niʼiŋ vi chə́ɨŋ nɔ ghɔ, pa nnu pighɔ pɔ pi ŋkuoŋ pa pie nthɛ nnu gɨ́ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pi ni ŋga ntūgu vəɨ ŋa pi thɔ nyiaŋ ntáŋ nthɛ vi, ǹtaoŋ vi vɛ taʼa ŋgɛ, mfɛ gɨ́ ni ŋgwa haʼaŋ pugu wɛ̄iŋ vi nɛ ŋa pugu shwei nnu haʼaŋ pugu wɛ̄iŋ vi nɔ ghɔ nɛ vɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nɛnnɛ, pa shoogɛ lɔ̄gɔ Pɔɔ wuʼɔ ŋkwaŋ nɔ haʼaŋ pi ni mfɛ gɨ́ ni pugu nɛ, ŋgə̄ɨ ni ju ti nchəɨŋ Antipatri ni tuʼu. ");
INSERT INTO bmo_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mbhi gha ndaŋ pugu pɨ̄nɨ lɨʼɨ haʼaŋ ghaŋ māʼaŋ nchhɔ̀ ghà nchhɔ nɛ, mieŋ vi pugu pa ghaŋ Minyieŋləɨ ŋa pugu pugu ghə̄ɨ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pugu ni ŋga nchəɨŋ Kaisharia, mfɛ ŋwaʼaŋlɨ ghɔ ni Feli mmɛ ŋgaŋ shaʼa ŋgwa, mbɨnɨ nchaʼa Pɔɔ mfɛ mbhɔ yu. ");
INSERT INTO bmo_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Feli mɛ̄iŋ ŋwaʼaŋlɨ ghɔ mbie vi ŋa a llɔ moŋ yəɨ lɨʼɨ, ŋga njaʼo ŋa a llɔ pi Shilishia, ");
INSERT INTO bmo_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","a chhu ghɔ ŋa, “Ǹshi njaʼo chrà yɔ ndɨɨ ŋa ŋgwa ŋa pugu wɛ̄iŋ ghɔ thɔ nɛ.” Nɛnnɛ, mfɛ gɨ́ ŋa pi chhɔ ŋkɛ̄ʼi Pɔɔ ntuʼɔ fùoŋ Hɛrɔ. ");
INSERT INTO bmo_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tiɛŋ llɛ́ ni ŋga ntɔgɔ, taathɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ mbɔ Anania shwiʼi pugu pa pichəɨ pa thishɨ ni taʼa ŋoŋ ŋa a shi nchrā nɔ lɨʼɨ yugu, ligi yi pɔ Tetulu. Pugu fɨ̄ʼɨ nnu ŋa pugu wɛ̄iŋ Pɔɔ nɔ nɛ ni Feli ŋoŋ ndiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pi ni ŋga mɛ̄iŋ Pɔɔ a nii nda, Tetulu jɛ̄ nthɔ ntigi pa nnu thɔ yu, nchhu nu ŋa, “Nthɛ ŋa ɔ shaʼa nu ni shiethɔ nɛ, pigi fāʼo ntou ghɨghrɨ nɔ ntaaŋ ndɨɨ nɛ, pugu pa ŋa ntou pa kwrí thɔ moŋ laʼataoŋ yei ntɔgɔ pi mbhɔ ghɔ nɛ, ma Feli ŋoŋ ndiɛŋ, ");
INSERT INTO bmo_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","moŋ ŋguoŋ shɛndaoŋ moŋ ŋguoŋ lɨʼɨ ghao, pigi piŋ ŋguoŋ nnu pighɔ ni ntou tōo nu vɛ, ma Feli ŋoŋ ndiɛŋ. ");
INSERT INTO bmo_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ndɔ nɔ mieŋ nu ki lɔ nuʼuŋ njwi ndɨɨ yɔ, ǹdɨ̄gəɨ ghɔ moŋ pwanjuʼɔ yɔ ŋa ɔ yaʼo vigi nɔ kuo ndɨɨ. ");
INSERT INTO bmo_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Pigi yəɨ ŋa ŋoŋ vei ya mbɔ pi ŋkiɛŋ ŋgaŋ ndàŋ, a thɔ ni minduoŋnduoŋ shɨna pa Juu moŋ ŋguoŋ mbhi ghao, mbɔ nthishɨ pa ŋgwa kɨrɨ yɛ ŋa pi mɛ̄iŋ ni Nashariŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","A ni ntāʼa nu mfuo Nda Minnwi, pigi wɛ̄iŋ vi. Pigi kaŋ ni nshāʼa vi ŋkwaŋ nɔ haʼaŋ gɨ́ yigi chhu nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ndɔ Lishia mbɔ nthishɨ pa taathɔ pa shoogɛ thɔ ni ghrɨ́ ŋkwe vi mbhɔ pigi ŋgə̄ɨ ni ju, ");
INSERT INTO bmo_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","nchhu nu ni pa ŋgwa ŋa pugu ni ntigi nnu thɔ yu nɛ ŋa pugu thɔ shhɨ ghɔ. Ɔ shi ŋga ntou vi ni noŋ yɔ, kaŋ ɔ shi nji ŋguoŋ pa nnu ŋa pigi wɛ̄iŋ vi nɔ nɛ mbhɔ yu.” ");
INSERT INTO bmo_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Pa ŋgwa Juu nii moŋ ghɔ ŋkaa pugu, nchhu nu ŋa ŋguoŋ pa nnu haʼaŋ pi wɛ̄iŋ vi nɔ nɛ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Feli mmɛ ŋgaŋ shaʼa ŋgwa nōoŋ ni mbhɔ yi ŋa Pɔɔ chrà. Pɔɔ chhu ŋa, “Ǹji ŋa ɔ kwo shaʼa laʼataoŋ yei nɔ ntou ŋgaʼo. Nthɛ yie ghɔ, m̀fāʼo pwatua nɔ taa nu nchò a shhɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nɔ haʼaŋ ɔ nthɛ ɔ yəɨ ni noŋ yɔ nɛ, a lɔ njiʼi ntɔgɔ paanchrɔ llɛ́ nɔ haʼaŋ ŋki kuʼɔ Jerushalɛiŋ lɨʼɨ ghaʼo Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Pa Juu shi ki lɔ njəɨ nthɔ ndōu nu pigi shesheŋoŋ ki niʼiŋ puŋ ŋgwa moŋ Nda Minnwi ti mfɛ pi ni mooŋ sheshe nda luoŋ Minnwi, ki pi moŋ laʼa. ");
INSERT INTO bmo_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ndɔ minthɛ paʼa pugu lɔ nōoŋ vɛ ŋa nnu ŋa pugu tigi nu thɔ mu nɛ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Ndɔ m̀biŋ yei vɛ, ŋa ŋ̀ga ŋgaʼo Minnwi pa ŋkhu tǎa pigi njōu pi njiŋ Shɛndaoŋ ŋa pugu chhu ŋa a lɔ kāʼo nɛ. Ndɔ m̀bɨnɨ mbiŋ ŋa ŋguoŋ yaoŋ ŋa pi nāʼaŋ moŋ ŋwaʼaŋlɨ gɨ́ Mushi pugu pa yi njəɨlɨʼɨ Minnwi nɛ, yi ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","M̀fāʼo kwàʼa mbɨŋ Minnwi ŋa pugu ŋkaa pugu fāʼo nɛ, ŋa ŋguoŋ ŋgwa ghao, ŋgwa shiʼi pugu pa pi pɨphɨ shi ndɛ mbɨnɨ ŋkuʼɔ moŋ gu. ");
INSERT INTO bmo_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nɛnnɛ, ŋ̀ga mbaʼo ŋa ŋgaŋthɔ a pɔ yi shishie shhɨ Minnwi pugu pa ŋgwamishua. ");
INSERT INTO bmo_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Mi ni ŋga ŋkwo pɔ mbhi nɔ ntou ŋgaʼo, mbɨnɨ mbɨ̄nɨ laʼa pigi nɔ ghɛ̄rɛ nu ŋgwa paŋ ni mbɨŋ ndɔ mbɨnɨ fɛʼiŋgiɛŋ ni Minnwi. ");
INSERT INTO bmo_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","A ni mbɔ pi ndɨɨ ŋa ŋki thɔ nchwīe nnu pei Nda Minnwi nɛ, ndɨɨ ŋa ŋki kwo mīʼɛŋ nùʼɔŋ ŋa pi ghà nchwīe nɔ pɔ nu yi taoŋtaoŋ nɛ, ŋa pugu ni njəɨ a. Pigi pa yú ŋgwa shini ndɔ mbɔ kaʼa, ndɔ paʼa minduoŋnduoŋ lɔ mbɔ. ");
INSERT INTO bmo_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ndɔ pichəɨ pa ŋgwa Juu llɔ Eshia ni mbɔ fɔ ŋkaa pugu, a pie ŋa pugu thɔ ŋkaa pugu nɔ fɨ̄ʼɨ nu sheshe nnu ŋa ǹchwīe ki a lɔ ŋkāʼo nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ndāa nɛnnɛ nɛ, pei ŋgwa ŋa pugu pɔ hɛiŋ nɛ fɨ̄ʼɨ nɛ nnu ŋa ŋki chwīe ki a lɔ ŋkāʼo ndɨɨ ŋa ŋki thi shhɨ pa kúŋ nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ŋkiɛŋ yei taʼa nnu ŋa ŋki paʼo ŋgòu nɔ ndɨɨ ŋa ŋki thi shɨna pugu nɛ, ‘Ǹthi sháʼa nɛ shiʼa shhɨ pəɨ nthɛ ŋa m̀biŋ ŋa ŋgwa ghà ŋga ŋkhu, shi mbɨnɨ ŋkuʼɔ.’ ” ");
INSERT INTO bmo_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ndɔ Feli ŋa a ni nja nji pa nnu nthɛ nnu Shɛndaoŋ shiʼi nɛ, chi sháʼa mfɛ shhɨ, nchhu ŋa, “Ndɨɨ ŋa Lishia mbɔ taathɔ pa shoogɛ shi nchəɨŋ nɛ, ǹdūgwi sháʼa yɔ.” ");
INSERT INTO bmo_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nɛnnɛ a fɛ gɨ́ ni nthishɨ pa taʼa ŋkɨɨ shoogɛ ŋa a chhɔ ŋkɛ̄ʼi vi, ndɔ mfɛ shɨ̀na ghɔ nɔ haʼaŋ minthɛ pa shuoŋ pi thɔ ŋgɛ̄rɛ vi ki lɔ mfāʼo kɨʼɨŋgɨnɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pichəɨ pa llɛ́ ni ŋga ntɔgɔ Feli thɔ pugu ŋgwɛ vi, ligi yi pɔ Drushila, mbɔ ŋoŋ Juu, nchhu pi thɔ ni Pɔɔ, a ywɛrɛ ŋkwaŋ haʼaŋ Pɔɔ thɔ nchrā nu nthɛ nnu piŋ mbɨŋ Jishɔ Krishto nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nɔ haʼaŋ Pɔɔ ni nchrā nu ŋkuoŋ pa nnu ndɨndɨ, pa nnu wɛ̄iŋ nu noŋ pugu pa llɛmbhi sháʼa ŋa a thɔ nu nɛ, pɔgɔ gu wɛ̄iŋ Feli a chhu ghɔ ŋa, “Ɔ nthɛ ɔ ghə̄ɨ ndwɛ, ǹshi mbɨnɨ mɛ̄iŋ ghɔ ndɨɨ ŋa m̀fāʼo shɨ̀na nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Wuʼɔ moŋ ndɨɨ ghɔ, a kwāʼa nu ŋa Pɔɔ shi mfɛ mbɨŋ ghɔ, nthɛ yie ghɔ, a thɔ mɛ̄iŋ vi ŋgɛŋgɛ pugu yu chrā nu. ");
INSERT INTO bmo_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Paa ŋgaʼo ni ŋga ntɔgɔ, Pokiu Feshitu lɔ̄gɔ lɨʼɨ Feli. Feli ni ntāʼa nu nōoŋ pwapuŋ ni pa Juu, nnɛ, mieŋ Pɔɔ moŋ chə́ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Trɛi llɛ́ ni ŋga ntɔgɔ Feshitu chəɨŋ moŋ krao lɨʼɨ ghɔ, ndhɔ Kaisharia ŋkuʼɔ Jerushalɛiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa thishɨ ŋgwa Juu chhu pa nnu thɔ Pɔɔ, ndɨ̄gəɨ Feshitu, ");
INSERT INTO bmo_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","mbie vi ŋa a nthɛ a chwīe shiʼi ni pugu nɔ taoŋ nu Pɔɔ a shwiʼi Jerushalɛiŋ. Pugu ni nchhu nnɛ nthɛ ŋa pugu ni ŋkwo taŋ nɔ nūʼɔŋ nu ŋgwa pugu lɛrɛ njwi Pɔɔ shɛndaoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Feshitu khwɛ̄ ŋa, “Pi nūʼɔŋ Pɔɔ nɔ ŋgaŋ chə́ɨŋ Kaisharia, mbaʼa a nuʼuŋ ndaʼa ŋkaoŋ mmu nduthɔ a maa ŋgə̄ɨ fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Pəɨ chwīe pigi pa thishɨ pəɨ ghə̄ɨ Kaisharia, a mbɔ ŋa ŋoŋ ghɔ fāaŋ sheshe nnu, pugu chhu nthɛ vi.” ");
INSERT INTO bmo_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Feshitu chhɔ fɔ nɔ fúoŋ llɛ́ ŋgə̄ɨ pi wuŋ, ndɔllɔ kiʼɛ ŋgə̄ɨ Kaisharia. Mbhi gha ndaŋ a chɔchɔ moŋ lɨʼɨ shaʼa sháʼa, mfɛ gɨ́ ŋa pi thɔ ni Pɔɔ. ");
INSERT INTO bmo_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pɔɔ ni ŋga nchəɨŋ, pa ŋgwa Juu ŋa pugu ni ndhɔ Jerushalɛiŋ nɛ, ghɨ̄ŋ vi, nthɔ nchhu ntou pa nnu thɔ yu, ndɔ paʼa ndɔ nōoŋ ŋa sheshe nnu pighɔ nnu shini. ");
INSERT INTO bmo_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ndɔ Pɔɔ taa noŋ yi, nchhu nu ŋa, “Ǹdɔ njiʼi nchwīe kaŋ taʼa fàŋ nthɛ gɨ́ pa ŋgwa Juu ki nthɛ Nda Minnwi, ki mbɨŋ Kaisha mbɔ fùoŋ pa Roma.” ");
INSERT INTO bmo_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ndɔ Feshitu ni ntāʼa nu nɔ nōoŋ nu pwapuŋ ni pa ŋgwa Juu, nɛnnɛ a chhu ni Pɔɔ ŋa, “Ɔ khwā nɔ ghə̄ɨ nu Jerushalɛiŋ pi shaʼa ghɔ fɔ nthɛ nnu pei ŋa pi chhu vəɨ hɛiŋ nthɛ ghɔ nɛ?” ");
INSERT INTO bmo_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔɔ khwɛ̄ ŋa, “Ǹthi hɛiŋ moŋ taʼa lɨʼɨ shaʼa sháʼa Kaisha mbɔ lɨʼɨ ŋa a pie ŋa pi shaʼa a nɛ. Gɔ̀ nduthɔ yɔ ji ŋa ǹdɔ njiʼi fāaŋ kaŋ taʼa nnu mbɨŋ pa Juu. ");
INSERT INTO bmo_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ŋ̀kaŋ ni mbɔ pi ŋgushaʼa, nchwīe sheshe nnu ŋa a pie ŋa ŋ̀khu nɛ, paʼa ǹdɔ njiʼi ntei tei. Ndɔ a mbɔ ŋa kaŋ taʼa nnu shini lɔ njiʼi mbɔ moŋ nnu ŋa pugu chhu nthɛ a nɛ, kaŋ mbaʼa yichəɨ ŋoŋ fɛ a mbhɔ pugu. Ǹdɔ̄gɔ sháʼa a nda sháʼa Kaisha.” ");
INSERT INTO bmo_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Feshitu ni ŋga mbini pugu pa kúŋ pi, ŋkhwɛ̄ ŋa, “Ŋa ɔ chhu ŋa Kaisha shaʼa sháʼa yɔ nɛ, ɔ shi ŋgə̄ɨ shhɨ yu.” ");
INSERT INTO bmo_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","A ni ŋga ndaʼa, Fùoŋ Agripa pugu Benishi ghə̄ɨ Kaisharia nɔ kra nu Feshitu, nchhu ghɔ ŋa a thɔ a pwa. ");
INSERT INTO bmo_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nɔ haʼaŋ pugu ni ndaʼa fɔ nɔ ntou llɛ́ nɛ, Feshitu nūʼɔŋ sháʼa Pɔɔ ghɔ shhɨ fùoŋ, nchhu nu ŋa, “Yichəɨ ŋgaŋ chə́ɨŋ pɔ hɛiŋ ŋa Feli ni ŋga ndɔllɔ mieŋ. ");
INSERT INTO bmo_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ŋki gha ŋgə̄ɨ Jerushalɛiŋ, pa thishɨ ghaŋ fɛʼiŋgiɛŋ pugu pa thishɨ pa ŋgwa Juu chhu pa nnu nɔ ligi yi, nchhu nu ŋa, ŋoŋ vei ŋgushaʼa. ");
INSERT INTO bmo_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ndɔ ǹchhu ni pugu ŋa, pigi, mbɔ ŋgwa Roma shiʼa njiʼi ndɔ̄gɔ ŋoŋ nɔ ŋgushaʼa ki a lɔ ntithi shhɨ pa ŋgwa ŋa pugu chhu nnu thɔ yu nɛ ntaa nchò yi nthɛ nnu pɛ ŋa pi chhu thɔ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Pugu ni ŋga nthɔ hɛiŋ kəʼɨ ghɔ, paʼa ǹdɔ nuʼuŋ mbɨrɨ fɨʼɨ, ndɔ mbhi gha ndaŋ ŋ̀kiʼɛ chhɔ pi chhɔ lɨʼɨ sháʼa nchhu ŋa pi thɔ ni ŋoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Pa ŋgwa pɛ ŋa pugu ni nchhu pa nnu thɔ yu nɛ lɔllɔ ntithi tɔthɨ ndɔ paʼa ndɔ nchhu kaŋ taʼa nnu pɨphɨ haʼaŋ ŋki ywɛrɛ nu ŋa pugu chhu thɔ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ndɔ ŋguoŋ yaoŋ ŋa pugu ni nchhu nu nɛ pɔ pi mindoundou nthɛ nnu Minnwi yugu pugu pa ligi yichəɨ ŋoŋ pi mɛ̄iŋ vi ni Jishɔ ŋa a ni ŋkwo khu, Pɔɔ chhu nu ŋa a yi maoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ǹshini ndɔ nji ŋkwaŋ haʼaŋ a nthɛ ǹtāʼa mooŋ ŋkwaŋ nnu pei nɛ, nthɛ yie ghɔ, m̀bie Pɔɔ ŋa a shi ŋkhwā nɔ ghə̄ɨ nu Jerushalɛiŋ pi shaʼa vi fɔ nthɛ nnu pighɔ. ");
INSERT INTO bmo_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ndɔ Pɔɔ ni ŋga ntāʼa nu ŋa a shaʼa fùoŋ Roma nshaʼa sháʼa yi, pi nūʼɔŋ vi hɛiŋ. Nɛnnɛ, m̀fɛ gɨ́ ŋa pi chhɔ ŋkɛ̄ʼi vi ti shi nuʼuŋ ntaoŋ vi ni Kaisha, mbɔ fùoŋ Roma.” ");
INSERT INTO bmo_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa chhu ni Feshitu ŋa, “Ǹshi ŋkhwā nɔ yaʼo nu mbhɔ ŋoŋ vei nduthɔ a.” Feshitu khwɛ̄ ŋa, “Ɔ shi njaʼo vi yua.” ");
INSERT INTO bmo_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Mbhi gha ndaŋ Agripa pugu Benishi thɔ moŋ ndighaʼo ntintaʼo pugu pa thishɨ pa taʼa ŋkaŋ shoogɛ ni pichəɨ pa mɛmmɛ ŋgwa moŋ laʼataoŋ ghɔ ŋgə̄ɨ nii moŋ mmɛ fāʼo ŋa ŋgwa ghà nthɔ nchhɔ nɛ. Feshitu fɛ gɨ́ pi thɔ ni Pɔɔ faʼo ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Feshitu chhu ŋa, “Fùoŋ Agripa pugu pa ŋguoŋ pa ŋgwa ŋa pugu pɔ hɛiŋ shiʼa pigi pugu nɛ, pəɨ yəɨ ŋoŋ vei, ŋguoŋ pa ŋgwa Juu ŋa pugu pɔ hɛiŋ pugu pa pɛ ŋa pugu pɔ Jerushalɛiŋ chhu pa nnu thɔ yu. Pugu paʼo ŋgòu ŋa a lɔ nuʼuŋ mfāʼo nɔ chhɔ nu mbhi. ");
INSERT INTO bmo_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ndɔ paʼa ǹdɔ njəɨ ŋa a chwīe sheshe nnu ŋa a pie ŋa pi fɛ njɔ́ gu ghɔ, nɔ haʼaŋ nduthɔ yi chhu ŋa a shaʼa fùoŋ Roma nshaʼa vi nɛ, ǹchuʼɔ nɔ taoŋ nu vi. ");
INSERT INTO bmo_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","“Ndɔ, ǹdɔ njiʼi mfāʼo ŋkiɛŋ thɔ nnu nɔ nāʼaŋ nu nthɛ vi mfɛ ni fùoŋ Roma. Nthɛ yie ghɔ, ǹthɔ ni ju hɛiŋ shhɨ pəɨ, mīʼɛŋ mbɔ shhɨ ghɔ, ma Fùoŋ Agripa, nnɛ ŋa pia shi ŋga ntou mooŋ sháʼa yi ghɔ, kaŋ a nthɛ m̀fāʼo nnu nɔ nāʼaŋ nu. ");
INSERT INTO bmo_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nthɛ ŋa m̀bīʼi a pɔ nnu na nɔ lɔ̄gɔ nu ŋgaŋ chə́ɨŋ ntaoŋ, ki lɔ nja mfɛ thɔ nnu ŋa pi wɛ̄iŋ vi nɔ ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa chhu ni Pɔɔ ŋa, “A nthɛ ɔ chrà nthɛ noŋ yɔ.” Pɔɔ shwīi mbhɔ yi njɛ̄ taa nu nchò yi, nchhu nu ŋa, ");
INSERT INTO bmo_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Fùoŋ Agripa, ǹjəɨ noŋ a nɔ mbrɔthɔ nɔ thi nu shhɨ ghɔ shiʼa nɔ taa nu noŋ a shhɨ ghɔ nthɛ ŋguoŋ pa nnu ŋa pa ŋgwa Juu chhu thɔ mu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mīʼɛŋ nthɛ ŋa ɔ ya nji nùʼɔŋ pugu pa mindoundou ŋa a pɔ shɨna pa ŋgwa Juu nɛ, nthɛ yie ghɔ, ǹduoŋ ŋa ɔ wɛ̄iŋ njùʼɔ yɔ njwɛrɛ nnu ŋa ǹshi nchhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ŋguoŋ pa ŋgwa Juu ji ŋkwaŋ haʼaŋ ŋki chhɔ chɔmbhi a llɔ nɔ haʼaŋ ŋki pɔ maʼaŋ mikhwa nɛ, llɔ nɔ njɛ̄ yi laʼa pigi ti ŋgə̄ɨ fɛ ni ndɨɨ ŋa ŋki pɔ Jerushalɛiŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Pugu ji nɔ ntaaŋ ndɨɨ nɔ haʼaŋ pugu ŋkhwā nɔ fɨ̄ʼɨ nu, llɔ nɔ njɛ̄ yi, ǹchhɔ chɔmbhi a nɔ taʼa ŋoŋ shɨna pa ŋgwa haʼaŋ pugu ghà nūʼɔŋ kɨ̀na Minnwi yigi tɨtɨnɨ, mbɔ pa ŋgwa Farashi. ");
INSERT INTO bmo_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ndwɛ, ǹthi hɛnɛiŋ pi thɔ nshaʼa a nthɛ ŋa ǹūʼɔŋ njùʼɔ a ŋkuoŋ kàʼa ŋa Minnwi ni mfɛ ni pa tǎa pigi nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Mbɔ yaoŋ ŋa paanchrɔ laʼataoŋ ŋgwa pigi kwāʼa nu nɔ haʼaŋ pugu ghaʼo Minnwi ni taʼanjuʼɔ yugu moŋ tuʼu pugu pa naoŋchɨ nɛ. A chwīe nthɛ kwàʼa yei ŋa m̀fāʼo nɛ ŋa pa ŋgwa Juu pei tigi pa nnu thɔ mu, ma Fùoŋ Agripa. ");
INSERT INTO bmo_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","A chwīe khɔ a ghaʼa ni pəɨ ŋa pəɨ thi hɛiŋ nɛ nɔ piŋ nu ŋa Minnwi ghà ŋkuʼɔ ni ŋgwa haʼaŋ pugu khu nɛ? ");
INSERT INTO bmo_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Mmu nduthɔ a ni mbīʼi ŋa m̀fāʼo nɔ chwīe nu ntou nnu nɔ yəɨ nu ŋa kiʼi ligi Jishɔ llɔ Nasharɛ nuʼuŋ ŋgə̄ɨ shhɨ. ");
INSERT INTO bmo_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yinɛ nnu ŋa ŋki chwīe Jerushalɛiŋ. Pa thishɨ ghaŋ fɛʼiŋgiɛŋ ni mfɛ njɨ vəɨ paʼa ǹdɔ ŋguʼɔ niʼiŋ ntou pa ŋgwa Minnwi pi taoŋtaoŋ niʼiŋ chə́ɨŋ, pi ni ŋga njwi vugu, mummu piŋ. ");
INSERT INTO bmo_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mfɛ ŋgəʼɨ ni pugu moŋ ntou ndɨɨ moŋ pa nda luoŋ Minnwi, mbaʼo nu nɔ yəɨ nu ŋa pugu chrā chrà pɨphɨ nthɛ nnu Minnwi. Njùʼɔ a ni mbɨgɨ mbɨŋ pugu ti nchəɨŋ fɨʼɨ ŋa ŋki ghə̄ɨ moŋ pa laʼataoŋ nduoŋ nɔ fɛ nu ŋgəʼɨ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Nnɛ, mi ni ŋkwe ghrɨ́, pugu pa ŋwaʼaŋlɨ ŋa a nōoŋ ŋa pi fɛ ghrɨ́ vəɨ nɛ mbhɔ pa thishɨ ghaŋ fɛʼiŋgiɛŋ ŋgə̄ɨ nɔ Damashiku ŋguʼɔ nthɛ pi yie ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","A gha mbɔ moŋ ntuŋ minaoŋ, ma chaapifuoŋ, ŋ̀ga mbɔ shɛndaoŋ ŋgə̄ɨ nu nɛ, njəɨ líʼɛ ŋa a thɛ nchaa minaoŋ llɔ po thɛ ŋgɨ̄ŋ a pigi pa ŋgwa ŋa pigi pugu ni nyīeŋ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ŋguoŋ yigi gha ŋgū shhɛ, njaʼo yichəɨ ŋggì chhu nu vəɨ moŋ chrà ŋgwa Hibru ŋa, ‘Shɔɔ, Shɔɔ, ɔ thɔ mfɛ ŋgəʼɨ vəɨ ŋa? A lɔ mbwa ŋa ɔ tuŋ kwò yɔ ŋkuoŋ thɔ muuŋ thɨ pɨ̄ga ŋa a tūʼɔ ghɔ ŋgə̄ɨ nu nɔ shhɨ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Nchhu ŋa, ‘Ɔ pɔ pi gɔ̌, Taathɔ?’ “Taathɔ khwɛ̄ ŋa, ‘Mi Jishɔ, ŋa ɔ thɔ mfɛ ŋgəʼɨ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ndɔ lɔllɔ ntithi ŋkuoŋ kwò mɔ, nthɛ ŋa ǹōoŋ noŋ a vɛ nthɛ yei nnu, ǹchuʼɔ ghɔ nɔ muuŋ fàʼa a. Ɔ shi nshwei pichəɨ pa ŋgwa nduoŋ ni yaoŋ ŋa ɔ yəɨ shiʼa nɛ, pugu pa nnu ŋa ǹshi nōoŋ vɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ǹshi ŋkwe ghɔ mbhɔ pa ŋgwa Ishrae pugu pa ŋgwa taoŋ nduoŋ ŋa ǹshi ntaoŋ ghɔ ni pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ɔ shi nchuʼɔ ligi yugu, ŋa pugu kara ntaoŋ moŋ njiŋ nthɔ moŋ líʼɛ, pugu taoŋ moŋ ghrɨ́ Shata nthɔ njəɨ Minnwi, nnɛ ŋa pi līʼɛ phɨ yugu, pugu lɔ mfāʼo shɨ̀na, shɨna ŋgwa pɛ ŋa Minnwi kwo chuʼɔ vugu nɔ ji ntɔgɔ pi ŋkuoŋ piŋ ŋa pugu fāʼo mbɨŋ mu nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Nthɛ yie ghɔ, ma Fùoŋ Agripa, ǹshini ndɔ ntɨnɨthɔ ni nnu yei ŋa mi ni njəɨ llɔ po nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ŋki jɛ̄ Damashiku pugu Jerushalɛiŋ ni ŋguoŋ krao ŋgei Judia pugu pa laʼataoŋ nduoŋ, nchīi nu ŋa pugu fāʼo nɔ wuʼɔ nu mbāʼa ŋkǔnu yugu ni phɨ nthɔ njiŋ Minnwi, ndɔ nchwīe pa nnu pɛ ŋa a shi nōoŋ ŋa pugu pāʼa ŋkǔnu yugu ni phɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yei nnu ŋa a ni nchwīe pa Juu pei wɛ̄iŋ a ndɨɨ ŋa ŋki pɔ Nda Minnwi nɛ, mbaʼo nu nɔ jwi nu ma. ");
INSERT INTO bmo_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nchəɨŋ shiʼa, a Minnwi ŋa a thɔ ŋgɛ̄rɛ a, ǹthi hɛiŋ shiʼa nɔ shwei nu ni ŋguoŋ ŋgwa, llɔ mbɨŋ pa miŋkwasha ti ŋkuʼɔ nchəɨŋ mbɨŋ pa ŋgwa ndiɛŋ paʼa ndɔ nchhu pi nnu nduoŋ ŋkiɛŋ pa nnu ŋa pa Njəɨlɨʼɨ Minnwi pugu pa Mushi ni nchhu ŋa a shi ndɛ ndɔ̄gɔ lɨʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Pugu ni nchhu ŋa Ju ŋa Minnwi Chuʼɔ Ntaoŋ nɔ Ŋkwe nɛ shi ŋguʼɔ njəɨ ŋgəʼɨ, ndɔ mbɔ ju fǔoŋ ŋoŋ nɔ pɨnɨ nu ŋkuʼɔ moŋ gu. A shi nchīi líʼɛ lūgu nu ni ŋgwa Juu pugu pa ŋgwa taoŋ nduoŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nɔ haʼaŋ Pɔɔ thi fɔ nthɔ ntaa nchò yi nɛ, Feshitu paʼo ŋgòu ni njɨ ŋa, “Pɔɔ, ɔ ya mbaa paa ntou yɛʼi yaoŋ chwīe ɔ ŋgū lɨ̀lɨŋ!” ");
INSERT INTO bmo_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ndɔ Pɔɔ khwɛ̄ ŋa, “Ǹdɔ njiʼi mbaa paa, ma Feshitu ŋoŋ ndiɛŋ, ǹchrā pi ŋkiɛŋ nnu shini ndɔ mbɔ chrà lɨna. ");
INSERT INTO bmo_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ndɔ Fùoŋ Agripa ji nnu pei minthɛ ǹchrā pa nnu pei ghɔ ni tɨnɨnjuʼɔ nthɛ ŋa a ji ŋguoŋ pa nnu pei ghao nthɛ ŋa pi shini ndɔ nchwīe nnu pei pi lə̌ɨŋ. ");
INSERT INTO bmo_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Fùoŋ Agripa, ɔ piŋ pa njəɨlɨʼɨ Minnwi? Ǹji ŋa ɔ piŋ.” ");
INSERT INTO bmo_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa khwɛ̄ ŋa, “Moŋ kuo ndɨɨ yei ɔ pīʼi ŋa ɔ shi nchwīe ŋ̀gū Krishitɛŋ?” ");
INSERT INTO bmo_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔɔ khwɛ̄ ŋa, “Ki mi shi ndɔ̄gɔ pi kuo ndɨɨ ki ntaaŋ ndɨɨ, luoŋ Minnwi a pɔ ŋa kiʼi a wuʼɔ mbɔ pi gɔ̀, ŋguoŋ ŋgwa pei ŋkaa pugu kara mbɔ nɔ haʼaŋ m̀bɔ nɛ, ŋkiɛŋ chɛiŋ yei ŋa pi krao mbhɔ ma nɔ ghɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nnɛ fùoŋ pugu pa Feshitu, ni Benishi pugu pa ŋguoŋ pichəɨ ŋgwa yrɛi shhɛ. ");
INSERT INTO bmo_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ŋga ŋkwo yīri, nchhu ni noŋ pugu ŋa, “Ŋoŋ vei lɔ njiʼi nchwīe sheshe nnu ŋa a pie ŋa a khu ki pi niʼiŋ vi chə́ɨŋ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa chhu ni Feshitu ŋa, “Ndɔ pi kaŋ ni nchuʼɔ ŋoŋ vei mieŋ vi a ghə̄ɨ ndɔ haʼaŋ a kaŋ ni mieŋ ki naa ndɔ̄gɔ sháʼa yi shhɨ Kaisha.” ");
INSERT INTO bmo_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Pi ni ŋga ŋkwo chhu ŋa pigi nii mitu ŋkhǐ ŋgə̄ɨ Itali, Feshitu chaʼa Pɔɔ pugu pa pichəɨ ghaŋ chə́ɨŋ mfɛ ni Julioŋ mbɔ nthishɨ taʼa ŋkɨɨ shoogɛ moŋ kwíe ntɨgao ŋkɨɨ shoogɛ ŋa pugu ni ŋkɛ̄ʼi fùoŋ Roma nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Pigi nii moŋ mitu ŋkhǐ llɔ Adramitiuŋ, ŋa a ni ŋkwo tithi nɔ ghə̄ɨ nu moŋ lɨʼɨ kaoŋ pa mitu ŋkhǐ Eshia nɛ. Nchuʼɔ kiʼɛ njɛ̄ ghə̄ɨ nu, pigi pa Arishtaku, mbɔ ŋoŋ Mashedonia lɔ Teshalonika. ");
INSERT INTO bmo_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Mbhi gha ndaŋ pigi chəɨŋ Shidoŋ. Julioŋ ni nōoŋ pwapuŋ ni Pɔɔ, mieŋ vi ŋa a ghə̄ɨ njəɨ pa taannu pi, nji ŋa pugu shi mfɛ pa yaoŋ ŋa a pou nɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Pigi lɔllɔ fɔ, ndɔ nthɛ ŋa fɨfrəɨ ni nthɔ nu pi llɔ ŋgei ŋa pigi ni ŋgə̄ɨ nu fɔ nɛ, pigi nyīeŋ ni pie pi ŋgei ŋkhǐ yɛ ŋa ŋkǔnu Shaipru ni ŋkɨʼɨ fɨfrəɨ ki a lɔ nchəɨŋ fɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Pigi shāʼa ntiri ŋkɨŋ Shilishia pugu Pamfilia nchəɨŋ Mura moŋ Lishia. ");
INSERT INTO bmo_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ŋga nchəɨŋ fɔ, nthishɨ pa taʼa ŋkɨɨ shoogɛ ghɔ yəɨ mitu ŋkhǐ a llɔ Alɛshandria ŋgə̄ɨ nu Itali, a niʼiŋ vigi moŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Pigi nyīeŋ pɔpɔrɔ nɔ yichəɨ fɨʼɨ llɛ, ntɔgɔ moŋ ghaghaʼa nchəɨŋ Kinidu. Fɨfrəɨ shini ndɔ mieŋ vigi ŋa pigi nuʼuŋ ŋguʼɔ mbīgi nyīeŋ ŋgə̄ɨ nu ŋgei ghɔ, nthɛ yie ghɔ, pigi nyīeŋ ŋgei ŋkǔnu yɛ ŋa ŋkǔnu Krɛtɛ ni ŋkɨʼɨ fɨfrəɨ nɔ chəɨŋ nu fɔ nɛ, ntɔgɔ yəɨ Shalmone. ");
INSERT INTO bmo_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Pigi wuʼɔ nyīeŋ pi ŋkɨŋ wéi, nyīeŋ ni ghaghaʼa ti ŋgə̄ɨ nchəɨŋ lɨʼɨ ŋa pi mɛ̄iŋ ni Lɨʼɨ Kaoŋ Pie Juju, yəɨ mmɛ laʼataoŋ ŋa pi mɛ̄iŋ ni Lashia nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Pigi ni nchhɔ fɔ nɔ ŋkiɛŋ ntaaŋ ndɨɨ, ti ŋgə̄ɨ nchəɨŋ yichəɨ fɨʼɨ ndɨɨ ŋa nyīeŋ nu moŋ ŋkhǐ ya ŋgaʼa, nthɛ ŋa njiʼi nthɛ pi mmɛ llɛ́ jī ŋkhǐ pa Juu ni ŋkwo tɔgɔ. Nnɛ Pɔɔ fɛ ntɨ́gɨ ni pugu, ");
INSERT INTO bmo_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","nchhu nu ŋa, “Mmɛ ŋgwa, ǹjəɨ ŋa nyìeŋ yia llɔ hɛiŋ ŋgə̄ɨ nu shhɨ shi mfɛ ŋgəʼɨ. Ntou phɛ shi mbɔ, ki lɔ ŋguʼɔ mbɔ pi ni pa maoŋ ŋa pia tiɛŋ nɛ, pugu pa mitu ŋkhǐ, ti mfɛ ni chɔmbhi yia.” ");
INSERT INTO bmo_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ndɔ nthishɨ pa taʼa ŋkɨɨ shoogɛ ghɔ, yaʼo pi nnu yɛ ŋa ŋgaŋ shūgu mitu ŋkhǐ ghɔ, pugu ŋgaŋ mitu ŋkhǐ ghɔ chhu nɛ, paʼa ndɔ njaʼo pi yɛ ŋa Pɔɔ chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Lɨʼɨ kaoŋ pie ghɔ shini ndɔ njiʼi mbɔ ŋkiɛŋ lɨʼɨ chhɔ moŋ laoŋ, nthɛ yie ntou ŋgwa ni ŋkhwā yugu ŋa pi lɔllɔ fɔ nnɛ ŋa pugu paʼo nshāʼa ŋkhǐ ntaoŋ Foniti nɔ haʼaŋ ä njiʼɛ, nnɛ ŋa minthɛ pugu chhɔ fɔ moŋ laoŋ. Foniti lɨʼɨ kaoŋ pie moŋ laʼataoŋ Krɛtɛ ŋa a nūaŋ ŋgə̄ɨ ni ŋgei mbhɔ ŋkwrɛi pugu pa ŋgei mbhɔ jɨ ŋgei nii minaoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Muuŋ fɨfrəɨ ni ŋga njɛ̄ ntɔgɔ nu llɔ mbiɛŋ, pa ghaŋ shūgu mitu ŋkhǐ pīʼi ŋa minthɛ pugu paʼo ti ŋgə̄ɨ nchəɨŋ nɔ haʼaŋ pugu ki pīʼi nɛ, nnɛ pugu fuʼu ŋgùʼɔ wɛ̄iŋ pie moŋ ŋkhǐ, nchhwi ti nja mbara ŋkɨŋ ŋkhǐ Krɛtɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ndɔ a ni ŋga ndara, mmɛ fɨfrəɨ ŋa a ghà ntaoŋ ŋgei mbhɔ ŋkwrɛi shaʼa minaoŋ tiri llɔ ŋkuoŋ ŋkǔnu Krɛtɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Mmɛ fɨfrəɨ ghɔ ni ŋga ŋgwɛ̄iŋ mitu ŋkhǐ, a ghaʼa ni pigi nɔ yɨna nu fɨfrəɨ ghɔ ni mitu ŋkhǐ yigi, nnɛ, pigi mieŋ fɔ fɨfrəɨ ghɔ tiɛŋ vigi ŋgə̄ɨ nu nɔ. ");
INSERT INTO bmo_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Pigi ni ŋga nchəɨŋ mbiɛŋ njiŋ muuŋ ŋkǔnu Kauda, ŋkǔnu ghɔ kɨʼɨ fɨfrəɨ ghɔ ni pigi. Pigi paʼo fɔ moŋ puoŋ pimbia ti ŋkaa ŋkwe muuŋ pie ŋa mmɛ mitu ŋkhǐ ghɔ ni nshūu nu nɛ ki a lɔ mbɨrɨ. ");
INSERT INTO bmo_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Pugu shūu muuŋ pie ghɔ niʼiŋ moŋ mmɛ mitu ŋkhǐ, ŋkrao mitu ŋkhǐ ghɔ ni ŋkɨ̌ɨ ŋa kiʼi a shɨna. Nthɛ ŋa pugu ni mbɔgɔ ŋa pie shi ntei ni njɨ ŋgə̄ɨ ŋkuʼɔ ŋkuoŋ gwí ni ŋgei ŋkɨŋ ŋkhǐ Libia nɛ, pugu shwiʼi ŋgùʼɔ lɨʼɨ mitu ŋkhǐ moŋ ŋkhǐ. Mieŋ mitu ŋkhǐ ghɔ kəʼɨ ghɔ fɨfrəɨ ghə̄ɨ nu ni ju pɔpɔrɔ. ");
INSERT INTO bmo_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nɔ haʼaŋ fiŋ tɨtɨnɨ ghɔ ni ŋguʼɔ nthɔ ŋgə̄ɨ nu shhɨ nɛ, mbhi gha ndaŋ pugu fuʼu pa maoŋ pugu moŋ mitu ŋkhǐ ghɔ māʼaŋ nu ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A gha mbɔ trɛi llɛ́, nɔ haʼaŋ fɨfrəɨ ghɔ ni njɛ̄ nɛ, pugu fuʼu pa maoŋ mitu ŋkhǐ ghɔ ni yugu mbhɔ māʼaŋ nu ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nɔ ntou llɛmbhi, paʼa pigi lɔ njəɨ ligi minaoŋ ki pa fɨ́nəɨ, fɨfrəɨ ghɔ wuʼɔ mbīgi pigi ntɨnɨ nu. Ndugwi yi, pigi khɛ noŋ yigi ki lɔ nuʼuŋ mbīʼi ŋa pigi shi ndūgu. ");
INSERT INTO bmo_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nthɛ ŋa pugu ni ŋkwo pɔ nɔ ntaaŋ ndɨɨ ki lɔ mfāʼo maoŋ jɨ nɛ, Pɔɔ lɔllɔ kiʼɛ nthithi tɔthɨ nchhu ŋa, “Ŋgwa paŋ, pəɨ kaŋ ni njaʼo nnu ŋa mi ni nchhu nɛ, ki lɔ nuʼuŋ nshūgu mitu ŋkhǐ ŋgə̄ɨ nɔ Krɛtɛ, yei phɛ shi kaŋ nì nuʼuŋ nii via. ");
INSERT INTO bmo_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","P̂əɨ fāʼo tɨnɨnjuʼɔ ndwɛ nthɛ ŋa mbaʼa thɔ ŋoŋ nuʼuŋ mbhɛ, a shi ŋguʼɔ mbhɛ mitu ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nthɛ ŋa ni tuʼu yɛ ŋa a tɔgɔ nɛ, ŋgaŋ ntaoŋ Minnwi ŋa m̀bɔ pi ji ndɔ ŋgaʼo vi nɛ thɔ vəɨ, ");
INSERT INTO bmo_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","nchhu ŋa, ‘Kiʼi fāʼo pɔgɔ gu, ma Pɔɔ, ɔ shi ŋguʼɔ nthi sháʼa shhɨ Kaisha. Minnwi kwo kwe ŋguoŋ ŋgwa ŋa pəɨ pugu nyīeŋ nu kaʼa moŋ mitu ŋkhǐ nɛ.’ ");
INSERT INTO bmo_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nɛnnɛ, p̂əɨ fāʼo wɛ̄iŋ njùʼɔ, ma ŋgwa paŋ, nthɛ ŋa m̀fāʼo tɨnɨnjuʼɔ mbɨŋ Minnwi ŋa a shi ŋguʼɔ mbɔ pi nɔ haʼaŋ pi shwei a nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Fɨfrəɨ shi ŋguʼɔ ndɔ̄gɔ via ŋgə̄ɨ ŋkaoŋ ŋkuoŋ gwí ŋkɨŋ muuŋ ŋkǔnu titri ŋkhǐ.” ");
INSERT INTO bmo_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Pigi ni ŋga ŋkwo pɔ moŋ ŋkhǐ nɔ khwɛnchrɔ tuʼu nthɔ nshāʼa ŋkhǐ ŋa pi mɛ̄iŋ ni Adria nɛ, pa ghaŋ shūgu mitu ŋkhǐ tha ŋa pi chhɔ mbara nu mbhi. ");
INSERT INTO bmo_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Pugu chu ŋgùʼɔ ŋkuoŋ ŋkɨɨ, māʼaŋ moŋ ŋkhǐ, njəɨ ŋa nthi ŋkhǐ paa wuŋ mbhɔ, nɔ ŋkāoŋ nu shhɛ. Ŋga mbɨnɨ ŋgə̄ɨ shɨgɛi, māʼaŋ njəɨ ŋa nthi ŋkhǐ tiɛŋnchrɔ mbhɔ nɔ kāoŋ nu shhɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Pɔgɔ gu wɛ̄iŋ vugu ŋa mitu ŋkhǐ shi nchhwi ŋgùʼɔ, nthɛ yie ghɔ, pugu māʼaŋ khwɛ ŋgùʼɔ lɨ̄ʼɨ pie moŋ ŋkhǐ llɔ njiŋ mitu ŋkhǐ, nduoŋ Minnwi ŋa mbhi laŋ. ");
INSERT INTO bmo_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Pa ghaŋ shūgu mitu ŋkhǐ ni ŋga ntāʼa nu ntei ntaoŋ moŋ mitu ŋkhǐ ghɔ, pugu shwiʼi muuŋ kikuoŋ moŋ ŋkhǐ mfɨ̄ɨ nu ŋa pugu ghə̄ɨ pi thɔ mitu ŋkhǐ lɨʼɨ chu ŋgùʼɔ lɨ̄ʼɨ pie fɔ. ");
INSERT INTO bmo_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ndɔ Pɔɔ chhu ni nthishɨ pa taʼa ŋkɨɨ shoogɛ pugu pa pichəɨ shoogɛ ŋa, “Ŋgwa pei mieŋ ki kɨna moŋ mitu ŋkhǐ, kaŋ mbaʼa pəɨ lūgu.” ");
INSERT INTO bmo_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Nnɛ, pa shoogɛ pighɔ yaʼa ŋkɨɨ kikuoŋ ghɔ mieŋ. ");
INSERT INTO bmo_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ŋkaoŋ mbhi maa ndaŋ, Pɔɔ kɔnɔ ŋguoŋ yugu ghao ŋa pugu jɨ maoŋ, nchhu nu ŋa, “A khwɛnchrɔ llɛ́ shiʼa ŋa pəɨ ywɛrɛ nu moŋ fiŋthɔ, ki lɔ njɨ maoŋ ki njwɛʼi yaoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nthɛ yie ghɔ, ŋ̀kɔnɔ vəɨ ŋa pəɨ jɨ maoŋ nɛnnɛ ŋa a shi ŋkwe vəɨ nthɛ ŋa njiʼi nthɛ pi taʼa ŋgiithɔ yəɨ, mbaʼa a phɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔɔ ni ŋga nchhu nnu yei, ndɔ̄gɔ brɛi, ŋga ntōo Minnwi shhɨ ŋguoŋ yugu ghao, mbəʼɨ njɛ̄ kru nu. ");
INSERT INTO bmo_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Njùʼɔ ŋguoŋ yugu gū, pugu jɛ̄ jɨ nu maoŋ. ");
INSERT INTO bmo_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ŋguoŋ yigi ghao moŋ mitu ŋkhǐ ghɔ ni mbɔ paa ŋkɨɨ ni khwachəɨ wuŋ ni ndigi yi ntɨgao. ");
INSERT INTO bmo_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Pugu ni ŋga njɨ ti njru, ŋkɛrɛ pichəɨ pa pìɛŋ maoŋ jɨ māʼaŋ moŋ ŋkhǐ nnɛ ŋa pie yīʼɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Mbhi ni ŋga ndaŋ, paʼa pugu lɔ nji lɨʼɨ ŋkɨŋ ŋkhǐ ghɔ, ndɔ pugu ni njəɨ muuŋ loo ŋkhǐ ni gwí fɔ nthɔ njwɛrɛ nu ŋa ä njiʼɛ pugu kuʼɔ ni mitu ŋkhǐ fɔ ŋkuoŋ shhɛ. ");
INSERT INTO bmo_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nnɛ pugu yaʼa ŋkɨɨ ŋgùʼɔ lɨ̄ʼɨ pie, mieŋ a yie moŋ ŋkhǐ. Wuʼɔ ndɨɨ ghɔ pugu pɨnɨ njaʼa ŋkɨɨ ŋkuoŋ yaoŋ shūgu mitu ŋkhǐ laʼo mitu ŋkhǐ, ŋkuʼɔ mmɛ kaoŋ ndhwí fɨfrəɨ tɔthɨ, fɨfrəɨ chi vugu kiʼɛ pugu ghə̄ɨ nu ŋkɨŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ndɔ mitu ŋkhǐ ghɔ chhwi ŋkuoŋ gwí ŋkwá, ndɨʼɨ ntithi ki lɔ nchəɨŋ ŋkɨŋ mbhi. Thɔ mitu ŋkhǐ lɨʼɨ, mmɛ fiŋ ghɔ nwīʼiŋ laʼo mitu ŋkhǐ kraokrao. ");
INSERT INTO bmo_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Pa shoogɛ kāʼa nɔ jwi nu pa ghaŋ chə́ɨŋ nnɛ ŋa kiʼi kaŋ taʼa ŋoŋ vugu paʼo ŋkhǐ ntei. ");
INSERT INTO bmo_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ndɔ nthishɨ pa taʼa ŋkɨɨ shoogɛ tāʼa nu ŋkwe Pɔɔ nnɛ ndāa ŋa kiʼi pugu chwīe nnu ŋa pugu ni ŋkāʼa nu nɛ. A ka fɛ pi gɨ́ ni pɛ ŋa pugu ji paʼo nu ŋkhǐ nɛ, ŋa pugu lli nchəɨŋ moŋ ŋkhǐ mbaʼo ŋkhǐ ntaoŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Pɨgəɨ ŋgwa younjiŋ yugu: pichəɨ taoŋ ŋkuoŋ pa krao pilaŋ, pichəɨ taoŋ pi ŋkuoŋ krao mitu ŋkhǐ, nɛnnɛ, ŋguoŋ yugu ghao chəɨŋ mbhi ki kàʼa. ");
INSERT INTO bmo_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Pigi ni ŋga ntaoŋ ti nchəɨŋ mbhi shiʼi, njaʼo ŋa ligi muuŋ ŋkǔnu ghɔ Malta. ");
INSERT INTO bmo_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Pa ŋgwa taoŋ pighɔ nōoŋ ŋkiɛŋ pwapuŋ ni pigi, mfrəɨ móŋoŋ ŋa pigi yɨgɔ nthɛ ŋa mbɨ̀ ni ŋkwo jɛ̄ llɔ nu, lɨʼɨ ya ŋgrɨ. ");
INSERT INTO bmo_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔɔ ni ŋkɨrɨ puoŋ mi ŋkwɛiŋ, ŋga ntūoŋ nu kie, fifhi taoŋ moŋ ghɔ nthɛ laoŋlaoŋ móŋoŋ, naoŋ vi nchu nɔ mbhɔ yi. ");
INSERT INTO bmo_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Pa ŋgwa taoŋ pighɔ ni ŋga njəɨ miyaoŋ ghɔ a chu nɔ mbhɔ Pɔɔ, nchhu ni nōoŋ pugu ŋa, “Ŋoŋ vei njwi ŋoŋ shini, njiʼi nthɛ nɔ haʼaŋ a lūgu ki lɔ ŋkhu moŋ ŋkhǐ nɛ, shhɛ chhu ŋa mbaʼa a lūgu.” ");
INSERT INTO bmo_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pɔɔ mīŋi fifhi ghɔ māʼaŋ moŋ móŋoŋ ndɔ paʼa kàʼa lɔ ŋkēe ju Pɔɔ. ");
INSERT INTO bmo_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Pugu tithi nchēi nu ŋa noŋ yi kuʼɔ ki ŋa a gū shhɛ ŋkhu. Ndɔ pugu ni nchēi nɔ ntaaŋ ndɨɨ ki lɔ njəɨ sheshe nnu, nnɛ pugu kwri njùʼɔ yugu, nchhu nu ŋa Pɔɔ pɔ pi nnwi. ");
INSERT INTO bmo_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Pa nyīeŋ ni mbɔ ŋkɨŋ lɨʼɨ ghɔ mbɔ yi taathɔ moŋ muuŋ ŋkǔnu ghɔ ligi yi pɔ Publiu. Taathɔ ghɔ ni ndɔ̄gɔ vigi ntuo vigi shiʼi nɔ ghaŋ kra pi nɔ trɛi llɛ́. ");
INSERT INTO bmo_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tǎa Publiu ni nūaŋ kúoŋ nthɔ ŋgɨ̄nɔ shɨ̀gao pugu pa nchə̀ɨ. Pɔɔ ghə̄ɨ njəɨ vi nduoŋ Minnwi ghɔ nūʼɔŋ mbhɔ yi mbɨŋ yu noŋ yi tɔgɔ. ");
INSERT INTO bmo_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Yei nnu ni ŋga ndɔ̄gɔ lɨʼɨ pɨgəɨ ŋgwa ŋkuoŋ muuŋ ŋkǔnu ghɔ ŋa pugu ni mfāʼo pa ŋgɨ̌nɔ nɛ thɔ ni pugu, pi yɨ̄gɨ ghɨ̌nɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Pugu ni mfɛ ntou pa maoŋ ni pigi, pigi gha ŋgə̄ɨ nu pugu niʼiŋ ŋguoŋ pa maoŋ ŋa a ni mbie ŋa pigi fāʼo nɛ moŋ mitu ŋkhǐ. ");
INSERT INTO bmo_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Trɛi nàoŋ ni ŋga ntɔgɔ, pigi nii mitu ŋkhǐ ŋa a ni ndhɔ Alɛshandria, pi mɛ̄iŋ ni pa “nnwi kəʼɨ” ŋa a ni ndaʼa fɔ moŋ ndɨɨ laoŋ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Pigi ni nchəɨŋ laʼataoŋ Shirakushɛ ndaʼa fɔ nɔ trɛi llɛ́. ");
INSERT INTO bmo_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Llɔ fɔ, pigi nii pie njīŋ ŋgə̄ɨ Regiuŋ. Taʼa llɛ́ gha ntɔgɔ fɨfrəɨ llɔ mbiɛŋ jɛ̄ thɔ nu, a gha mbɔ mbra llɛ́ pigi nchəɨŋ Puteoli. ");
INSERT INTO bmo_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Pigi gha nchəɨŋ fɔ nɛ, njəɨ pichəɨ ghaŋ piŋ, pugu chhu ni pigi ŋa pigi pugu laʼa nɔ khwachəɨ llɛ́. Nɛnnɛ, yei ŋkwaŋ haʼaŋ pigi kie nchəɨŋ Roma nɛ. ");
INSERT INTO bmo_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Pa ghaŋ piŋ Roma ni njaʼo ŋkaoŋ yigi, ntaoŋ nthɔ nchəɨŋ moŋ laʼataoŋ ŋa pi mɛ̄iŋ ni Taŋ Apiu pugu lɨʼɨ yɛ ŋa pi mɛ̄iŋ ni Trɛi lɨʼɨ Pe Ndaʼa nɛ, nɔ para nu miŋi. Pɔɔ gha njəɨ vugu, ntōo Minnwi, njùʼɔ yi pɨnɨ nja ŋgū. ");
INSERT INTO bmo_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Pigi ni ŋga nchəɨŋ Roma, pi mieŋ Pɔɔ ŋa a laʼa təʼɨ vi pugu taʼa shoogɛ ŋa a ni ŋkɛ̄ʼi vi. ");
INSERT INTO bmo_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Trɛi llɛ́ ni ŋga ntɔgɔ, Pɔɔ mɛ̄iŋ kɨrɨ pa thishɨ pa Juu moŋ laʼa. Pugu ni ŋga ŋkɨrɨ, a chhu ni pugu ŋa, “Pa lǐŋ paŋ, njiʼi nthɛ nɔ haʼaŋ ǹdɔ njiʼi nchwīe sheshe nnu mbɨŋ pa ŋgwa pia ki ŋkuoŋ nùʼɔŋ yia nɛ, ndɔ pugu ni nchaʼa a mfɛ nɔ ŋgaŋ chə́ɨŋ Jerushalɛiŋ ni ŋgwa Roma. ");
INSERT INTO bmo_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Pugu ni ŋga ntou a, ntāʼa nu mieŋ ŋ̀gə̄ɨ nthɛ ŋa pugu shi ki lɔ njəɨ sheshe yaoŋ ŋa ǹchwīe ŋa a pie ŋa pi fɛ njɔ́ gu vəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Pa ŋgwa Juu ni ŋga ndāa, a yīʼi ŋa ǹdɔ̄gɔ sháʼa a ŋgə̄ɨ nɔ shhɨ Kaisha, ndɔ ki lɔ mfāʼo pi sheshe nnu nɔ chhu nu thɔ ŋgwa paŋ. ");
INSERT INTO bmo_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","A chwīe yie ŋ̀gɛ̄ vəɨ, ntāʼa nu nɔ yəɨ nu vəɨ pia chrà, ŋa pi krao a ni chɛiŋ nɛiŋ nthɛ pi ŋoŋ ŋa ŋgwa Ishrae fāʼo kwàʼa mbɨŋ yu nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Pugu chhu ghɔ ŋa, “Pi lɔ njiʼi mfɛ ŋwaʼaŋlɨ ni pigi llɔ Judia nɔ ligi yɔ. Ndɔ paʼa ŋgwa pia ŋa pugu thɔ nu hɛiŋ nɛ lɔ nchrā sheshe nnu ki nchhu sheshe nnu pɨphɨ nthɛ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ndɔ pigi khwā nɔ yaʼo nu mbhɔ ghɔ, jɔ nnu ŋa ɔ pīʼi nɛ. Nthɛ ŋa pigi ji ŋa pi chrà pa nnu pɨphɨ moŋ ŋguoŋ lɨʼɨ ghao nthɛ yɛ kɨrɨ ŋa ɔ pɔ fɔ nɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Pugu ni ntigi llɛ́, a gha mbɔ llɛ́ ghɔ ntou yugu thɔ lɨʼɨ haʼaŋ Pɔɔ ni ndaʼa nu nɛ, a tɛrɛ nnu pighɔ ni pugu jɛ̄ ni tutuʼu ŋgə̄ɨ nchəɨŋ ni fanaoŋ, nthɔ mfɨ̄ʼɨ nnu Shaʼafuoŋ Minnwi ni pugu, ŋkaa nu nɔ nōoŋ nu ni pugu llɔ moŋ gɨ́ Mushi pugu pa ŋwaʼaŋlɨ pa njəɨlɨʼɨ Minnwi ŋa pugu piŋ Jishɔ. ");
INSERT INTO bmo_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Pichəɨ ni mbiŋ nnu ŋa a ni nchhu nu nɛ, paʼa pichəɨ lɔ mbiŋ. ");
INSERT INTO bmo_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Pugu lɔllɔ ŋgə̄ɨ, ndōu nu ni noŋ pugu ndɨɨ ŋa Pɔɔ ni ŋkwo chhu yei taʼa nnu nɛ, “Jijwɛ Minnwi ni nchhu shini ndɨɨ ŋa a ni nchhu ni pa tǎa pəɨ ntɔgɔ pi njiŋ njəɨlɨʼɨ Minnwi mbɔ Ishaya nɛ: ");
INSERT INTO bmo_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Ghə̄ɨ nchhu ni ŋgwa pei ŋa, Shishini, pəɨ shi njaʼo ndɔ paʼa ndɔ nji njiŋ yi, pəɨ shi nja ndīi ndɔ paʼa ndɔ njəɨ. ");
INSERT INTO bmo_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Nthɛ ŋa njùʼɔ ŋgwa pei kwo fɨ̄nɨ, tə́nə yugu chri ki lɔ nuʼuŋ njaʼo lɨʼɨ, pugu kwo kwiri ligi yugu, Nnɛ ŋa kiʼi pugu yəɨ ni ligi yugu, njaʼo ni tə́nə yugu, nji ni njùʼɔ yugu Ŋkara mbara a, ǹchwīe pugu pɔ shiʼi.’ ");
INSERT INTO bmo_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","P̂əɨ ji nɛ ŋa lūgu nu yei llɔ mbhɔ Minnwi ghə̄ɨ nɛ mbhɔ ŋgwa taoŋ nduoŋ, ndɔ ŋgwa taoŋ nduoŋ shi njwɛrɛ.” ");
INSERT INTO bmo_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pɔɔ ni ŋga kwo chhu nɛiŋ, ŋgwa Juu pighɔ taoŋ ŋgə̄ɨ nu, ndōu nu ni noŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔɔ ni ndaʼa fɔ nɔ paa ŋgaʼo moŋ nda ŋa a ni mbe nu llɔ pìɛŋ yu. A mbiŋ ŋguoŋ ŋgwa ŋa pugu thɔ fɔ nɔ yəɨ nu vi nɛ, ");
INSERT INTO bmo_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","nthɔ nchīi Shaʼafuoŋ Minnwi, nthɔ njɛʼi pa nnu nthɛ Jishɔ Krishto mbɔ Taathɔ ni tɨnɨnjuʼɔ ki ŋoŋ lɔ ntāra vi.");
INSERT INTO bmo_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ŋwaʼaŋlɨ yei llɔ mbhɔ mu Pɔɔ, mbɔ muuŋ fàʼa Krishto Jishɔ. Pi gɛ̄ a ŋa m̀bɔ ŋgaŋ ntaoŋ Krishto, Minnwi chuʼɔ a ŋa ǹchīi pwa pishaʼakhɔ yi, ");
INSERT INTO bmo_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ŋa a ni ŋkāʼa fie ndɨɨ ntɔgɔ pi mbhɔ pa njəɨlɨʼɨ pi moŋ Ŋwaʼaŋlɨ Minnwi yi taoŋtaoŋ. ");
INSERT INTO bmo_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Pwa pishaʼakhɔ ghɔ pɔ nthɛ Muuŋ vi, ŋa moŋ frɛinoŋ pi ni mbhi vi moŋ ndaaŋoŋ Fùoŋ Devi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ntɔgɔ pi mbhɔ Jijwɛ taoŋtaoŋ, pi ni nōoŋ vi ni mmɛ ghrɨ́ ŋa a Muuŋ Minnwi ntɔgɔ pi moŋ kuʼɔ nu mi moŋ gu, mbɔ ju Jishɔ Krishto mbɔ Taathɔ via. ");
INSERT INTO bmo_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Pia tɔgɔ mbhɔ Krishto mfāʼo shɨ̀na mbɨnɨ mbɔ ghaŋ ntaoŋ, nɔ chwīe nu ŋguoŋ ŋgwa taoŋ nduoŋ yaʼo nchò llɔ moŋ piŋ nthɛ ligi yi, ");
INSERT INTO bmo_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","pugu pa pəɨ ŋa pi gɛ̄ vəɨ ŋa pəɨ pɔ yi Jishɔ Krishto nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ǹāʼaŋ pi ni ŋguoŋ vəɨ ghao ŋa pəɨ pɔ laʼataoŋ Roma nɛ, ŋa Minnwi khwā vəɨ ndɔ ŋgɛ̄ vəɨ ŋa pəɨ pɔ ŋgwa pi pi taoŋtaoŋ nɛ. Pwapuŋ pugu pa ghɨghrɨ llɔ mbhɔ Minnwi mbɔ Tǎa via pugu Jishɔ Krishto mbɔ Taathɔ pɔ ni pəɨ. ");
INSERT INTO bmo_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","M̀fǔoŋ ntōo Minnwi a ntɔgɔ mbhɔ Jishɔ Krishto nthɛ vəɨ, nthɛ ŋa pi chīi piŋ yəɨ moŋ ŋguoŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nthɛ ŋa Minnwi ŋa m̀fāʼa mbhɔ yu ni ŋguoŋ njùʼɔ a ghao moŋ pwa pishaʼakhɔ Muuŋ vi nɛ miŋkwentie a ŋa ŋga ŋguʼɔ ŋkwiŋ vəɨ, ");
INSERT INTO bmo_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ŋguoŋ ndɨɨ ghao moŋ luoŋ Minnwi a, nduoŋ nu ŋa M̈innwi mbiŋ, kaŋ minthɛ ndūgu nthɔ nɔ yəɨ nu vəɨ. ");
INSERT INTO bmo_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nthɛ ŋa ŋ̀khwā nu nɔ yəɨ nu vəɨ, nnɛ nɔ ghrà nu pichəɨ fɛ́ llɔ mbhɔ Jijwɛ Minnwi ni pəɨ nɔ māʼaŋ nu ghrɨ́ yəɨ. ");
INSERT INTO bmo_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Yie pɔ nɔ chhu nu ŋa minthɛ pia māʼaŋ ghrɨ́ noŋ pia ntɔgɔ pi ŋkuoŋ piŋ yia, mbɔ piŋ yəɨ pugu pa nyaŋ. ");
INSERT INTO bmo_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ǹtāʼa nu pəɨ ji, ma pa lǐŋ paŋ, ŋa ŋ̀kwo pīʼi nɔ thɔ nu njəɨ vəɨ ŋgɛŋgɛ ndɔ pa nnu wuʼɔ ndɨʼɨ a lɨʼɨ nɔ thɔ nu, nnɛ ŋa minthɛ fàʼa a ghɛ̄rɛ ŋkara pichəɨ ŋgwa shɨna pəɨ wuʼɔ nɔ haʼaŋ a lɔ̄gɔ lɨʼɨ shɨna pa pichəɨ ŋgwa taoŋ nduoŋ. ");
INSERT INTO bmo_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","M̀fāʼo ŋkrù chīi nu pwa pishaʼakhɔ ni pa ŋguoŋ taoŋtaoŋ ghao, ni pa ghaŋ shieligi pugu pa ghaŋ mooŋ trǔ, ni pa ghaŋ shiethɔ pugu pa na. ");
INSERT INTO bmo_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nnɛ kiʼɛ ǹthɔ ŋkhwā nu nɔ chīi nu ŋkɨ̀nɨ pwa pishaʼakhɔ ni pəɨ ŋkaa pəɨ ŋa pəɨ pɔ moŋ laʼataoŋ Roma nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ǹdɔ njiʼi mfāʼo lrithɔ nthɛ ŋkɨ̀nɨ pwa pishaʼakhɔ, nthɛ ŋa a njɨ Minnwi nɔ kie nu ndūgu ni shesheŋoŋ ŋa a piŋ nɛ, fǔoŋ yi pɔ ŋgwa Juu, ni pa ŋgwa taoŋ nduoŋ kiʼɛ. ");
INSERT INTO bmo_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Moŋ ŋkɨ̀nɨ pwa pishaʼakhɔ ghɔ, pia yəɨ ŋkwaŋ haʼaŋ Minnwi fāʼa nɔ chwīe nu ŋgwa kāʼo ligi yu nɛ, llɔ moŋ piŋ, ndugwi ŋkuoŋ piŋ. Nɔ haʼaŋ pi nāʼaŋ ŋa, “Ŋoŋ ndɨndɨ shi mfāʼo chɔmbhi ntɔgɔ pi ŋkuoŋ piŋ.” ");
INSERT INTO bmo_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nthɛ ŋa mmɛ pɨgɨtua Minnwi nōoŋ noŋ yi llɔ po nthɛ ŋguoŋ ki pɔgɔ Minnwi pugu pa mbha nnu təɨtəɨ ŋgwamishua, ŋa pugu tɔgɔ moŋ phɨ yugu mfrɛ̄i nnu shini. ");
INSERT INTO bmo_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nthɛ ŋa yaoŋ ŋa minthɛ pi ji nthɛ Minnwi nɛ, yi shieshie ni pugu nthɛ ŋa Minnwi nōoŋ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Nthɛ ŋa jɛ̄ ndɨɨ ŋa pi ni nchwīe mbhi nɛ, pi kwo ya nji mbha nnu Minnwi ŋa minthɛ paʼa pi lɔ njəɨ nɛ, nɔ njɨ yi ki ndugwi yi, ni púoŋ yi nɔ Minnwi, pi ya nji shishiʼi ntɔgɔ pi ŋkuoŋ pa yaoŋ ŋa a chwīe nɛ. Nthɛ yie ghɔ, mbaʼa pugu nuʼuŋ nchu ŋa, “Mi ni nji ni khɔ!” ");
INSERT INTO bmo_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Nthɛ ŋa njiʼi nthɛ nɔ haʼaŋ pugu ni nji Minnwi nɛ, pugu shini ndɔ ŋgaʼo vi nɔ Minnwi ki mfɛ tōo nu ghɔ, pugu gū pa ŋgwa ghagha moŋ mbīʼi nu nnu yugu, nnɛ njùʼɔ nàna ŋa pugu fāʼo nɛ lɨnaoŋ ni njiŋnjiŋ. ");
INSERT INTO bmo_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Pugu chhu nu ŋa pugu ghaŋ shiethɔ, ntaoŋ pa na. ");
INSERT INTO bmo_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Fie ŋa pugu ka ni ŋgaʼo pi Minnwi ŋa a shiʼa ma ŋkhu nɛ, pugu kara ŋgaʼo pi pa maoŋ kúoŋ ŋa a fhi ŋoŋmishua ŋa a ghà ŋkhu nɛ, pugu pa mishi, ni pa minyieŋ pugu pa mimaoŋ shatei. ");
INSERT INTO bmo_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nthɛ yie, Minnwi chaʼa vugu mfɛ ni shɔ̄rɔ nu pa nnu tɔtrɔ ŋa njùʼɔ yugu khwā nu nɛ, pugu chwīe pa nnu fɛfhɛ shɨna pugu. ");
INSERT INTO bmo_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Nthɛ ŋa pugu kwri nnu shini nthɛ Minnwi ni lɛʼiŋgiɛŋ, ŋkara ŋgaʼo ndɔ mfāʼa mbhɔ yaoŋ ŋa pi chwiechwie nɛ mieŋ ŋoŋ ŋa a chwīe ju maoŋ pighɔ nɛ, mbɔ ŋoŋ ŋa a pie ŋa pi ghaʼo vi ki ndugwi yi nɛ. A yie. ");
INSERT INTO bmo_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nthɛ yie ghɔ, Minnwi chaʼa vugu mfɛ ni shɔ̄rɔ nu pa nnu tɔtrɔ. Njiʼi nthɛ pi piŋgɛ pugu kara ŋkwaŋ haʼaŋ a pie ŋa miŋgwɛ yəɨ mimbia nɛ mbɨnɨ njəɨ pi nōoŋ pugu. ");
INSERT INTO bmo_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Pimbia ŋkaa pugu kara ki lɔ nji noŋ pi pugu pa piŋgɛ ŋkwaŋ haʼaŋ a pie nɛ, ŋka fāʼo pi tɨtɨnɨ shɔ̄rɔ nu nɔ ji nu pichəɨ pimbia, nthɛ yie ghɔ, pugu fāʼo njɔ́ ŋa a kāʼo nɛ nthɛ fàŋ yugu. ");
INSERT INTO bmo_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ndɔ nɔ haʼaŋ pugu shini ndɔ mbīʼi a kāʼo nɔ ji nu Minnwi nɛ, Minnwi chaʼa vugu mfɛ ni mbīʼi nu nnu pa ŋgwa pɨphɨ ŋa pugu chwīe pa nnu pɛ ŋa a pie ŋa kiʼi pugu chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Pugu ni ndɨnaoŋ ni ŋguoŋ ŋkwaŋ mbha nnu təɨtəɨ, phɨ, lúa, kipɨna. Pugu lɨnaoŋ ni kighɨʼə, mbɔ pa njwi ŋgwa, minduoŋnduoŋ, mifɨɨ, mbha nnu pɨ̄na ŋgwa. Pugu pa ghaŋ nchhú, ");
INSERT INTO bmo_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ghaŋ chhu nnu phɨ thɔ ŋgwa, ghaŋ pɨ̌na Minnwi, ghaŋ nchɨʼəshə, ghaŋ māʼaŋ ntintaʼo, ghaŋ kwēi njùʼɔ, ghaŋ paʼo pa phɨ, ghaŋ chɨ̄ʼə nchò pa tǎa, ");
INSERT INTO bmo_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","pa na, ki piŋ, ghaŋ ki khwǎ ŋgwa nduoŋ, ghaŋ ki nōoŋ kwoshɨnɨ. ");
INSERT INTO bmo_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Njiʼi nthɛ pi nɔ haʼaŋ pugu ji pa gɨ́ Minnwi ŋa ŋgwa pɛ ŋa pugu chwīe ŋkwaŋ nnu pighɔ pie ŋa pugu khu nɛ, paʼa pugu lɔ ŋguʼɔ nchwiechwie, pugu piŋ ŋgwa pɛ ŋa pugu chwīe ŋkwaŋ nnu pighɔ nɛ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nthɛ yie ghɔ, gɔ̀ haʼaŋ ɔ tuo pa ŋgwa nduoŋ nɔ pa ŋgushaʼa nɛ lɔ njiʼi mfāʼo shɨna nɔ chhu nu ŋa ɔ shi lɔ njiʼi nji. Nthɛ ŋa moŋ tuo nu ŋgwa nduoŋ nɔ pa ŋgushaʼa, ɔ nōoŋ noŋ yɔ nɔ ŋgushaʼa, nthɛ ŋa gɔ̀ ŋa ɔ wɛ̄iŋ ŋgwa nɔ pa ŋgushaʼa nɛ wuʼɔ nthɔ nchwīe pi pa ŋkwaŋ nnu haʼaŋ pugu chwīe nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Pia ji ŋa Minnwi chwīe a kāʼo ndɨɨ ŋa a shaʼa pa ŋgwa haʼaŋ pugu chwīe ŋkwaŋ nnu pei nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Shuoŋ a, ɔ pīʼi ŋa ɔ shi ntei sháʼa Minnwi, mbɔ gɔ̀ ŋa ɔ tuo ŋgwa nɔ pa ŋgushaʼa nthɛ pa nnu haʼaŋ pugu chwīe, ndɔ nchwīe pi pa nnu pighɔ ŋkaa ghɔ nɛ? ");
INSERT INTO bmo_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ki ɔ chɨ̄ʼə mmɛ pwapuŋ yi pugu pa tiishii, ni wɛ̄iŋ njùʼɔ yi ki lɔ nji nu ŋa pwapuŋ Minnwi fāʼo nɔ chwīe nu ɔ pāʼa ŋkǔnu yɔ ni phɨ? ");
INSERT INTO bmo_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ndɔ nthɛ tɨnɨthɔ yɔ pugu pa njùʼɔ yɔ haʼaŋ ɔ lɔ ntāʼa nu ŋkwri nɛ, ɔ thɔ ŋkɨrɨ pɨgɨtua Minnwi a lɛ nshwiʼi mbɨŋ ghɔ moŋ llɛmbhi ŋa Minnwi ma nōoŋ pɨgɨtua yi pugu pa ŋkwaŋ haʼaŋ a ghà nshaʼa ŋgwa moŋ ndɨndɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Minnwi ma ŋkɨnɛiŋ shesheŋoŋ wuʼɔ nɔ fɨʼɨ fàʼa yi. ");
INSERT INTO bmo_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","A shi mfɛ chɔmbhi ki mmɛ ni ŋgwa pɛ ŋa pugu wɛ̄iŋ njùʼɔ yugu nthɔ nchwīe nnu shiʼi, nthɔ ntāʼa pi ndighaʼo pugu pa liɛŋ ni chɔmbhi ki ndugwi yi ŋa Minnwi ghà mfɛ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ndɔ ni ŋgwa pɛ ŋa pugu wuʼɔ ntāʼa pi yugu nnu ki lɔ mbiŋ nnu shini nɛ, nthɔ nchwīe pi pa nnu haʼaŋ a lɔ njiʼi ŋkāʼo nɛ, a shi mfɛ wuwuru ŋgəʼɨ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ŋgəʼɨ pugu pa yúʼɔ shi mbɔ ni ŋguoŋ ŋgwa pɛ ŋa pugu chwīe phɨ nɛ, fǔoŋ yi ni pa ŋgwa Juu mbra kiʼɛ ni pa ŋgwa taoŋ nduoŋ ŋkaa pugu. ");
INSERT INTO bmo_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ndɔ Minnwi shi mfɛ ndighaʼo pugu pa liɛŋ pugu pa ghɨghrɨ ni ŋguoŋ pa ŋgwa ŋa pugu chwīe shiʼi nɛ, fǔoŋ yi ni pa ŋgwa Juu mbra kiʼɛ ni pa ŋgwa taoŋ nduoŋ, ");
INSERT INTO bmo_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","nthɛ ŋa Minnwi shiʼa nōoŋ shieligi. ");
INSERT INTO bmo_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Nthɛ ŋa ŋguoŋ ŋgwa haʼaŋ pugu chwīe phɨ ki lɔ mfāʼo gɨ́ shi ŋguʼɔ ŋkhu pi ki lɔ ntɔgɔ pi ŋkuoŋ gɨ́, ndɔ ŋguoŋ pa ŋgwa ŋa pugu fāʼo gɨ́ ndɔ nchwīe phɨ nɛ, pi shi nshaʼa vugu ni gɨ́ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Nthɛ ŋa a lɔ njiʼi mbɔ pi pa ghaŋ yaʼo gɨ́ ŋa pugu pa ŋgwa ndɨndɨ ligi Minnwi, a ghà mbɔ pi ŋgwa ŋa pugu chwīe nnu haʼaŋ gɨ́ chhu nɛ ŋa Minnwi shi nshaʼa ŋa pugu pa ŋgwa ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ndɨɨ ŋa njùʼɔ ŋgwa taoŋ nduoŋ ŋa pugu lɔ njiʼi mfāʼo gɨ́ naʼaŋ ni pugu, pugu chwīe nnu haʼaŋ gɨ́ chhu nɛ, njiʼi nthɛ pi nɔ haʼaŋ pugu lɔ njiʼi mfāʼo gɨ́ nɛ, nōoŋ ŋa a gɨ́ ni pugu. ");
INSERT INTO bmo_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Mbha nnu pugu nōoŋ ŋa pi nāʼaŋ nnu ŋa gɨ́ tāʼa nu ŋa pi chwīe nɛ moŋ njùʼɔ pugu, ŋgaŋthɔ yugu wɛ̄iŋ vugu ŋa pugu chwīe ntəɨ ki ŋkwe ntie yugu ŋa pugu chwīe a kāʼo. ");
INSERT INTO bmo_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Nnɛ, nɔ haʼaŋ pwa pishaʼakhɔ ŋa ŋ̀ga nchīi chhu nɛ, yei ŋkwaŋ haʼaŋ a lɛ mbɔ moŋ llɛ́ ghɔ, ndɨɨ ŋa Minnwi ma ntɔgɔ mbɨŋ Jishɔ Krishto nshaʼa ŋguoŋ pa nnu lə̄ɨŋ haʼaŋ ŋgwa pīʼi nu njùʼɔ pugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ndɔ ni gɔ̀ ɔ mɛ̄iŋ noŋ yɔ ni ŋoŋ Juu njɨʼə noŋ yɔ ŋkuoŋ gɨ́ Mushi mfāʼo titɛnɛ nthɛ shɨna yəɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ɔ ji nnu haʼaŋ a tāʼa nu ŋa ɔ chwīe nɛ, ndɔ njɛʼi llɔ moŋ gɨ́ ŋkwaŋ haʼaŋ minthɛ ɔ tɛrɛ nnu ŋa a kāʼo nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ɔ ya fāʼo tɨnɨnjuʼɔ ni noŋ yɔ ŋa gɔ̀ nduthɔ yɔ ŋgaŋ nōoŋ shɛndaoŋ ni pa nchriligi, mbɔ liʼɛ ni pa ŋgwa pɛ ŋa pugu pɔ moŋ njiŋnjiŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ɔ pīʼi ŋa ɔ ŋgaŋ yuʼu pa na, ŋgaŋ yɛʼi pa mikəʼɨ. Nthɛ ŋa ɔ fāʼo tɨnɨnjuʼɔ ŋa gɨ́ Mushi fɛ ŋguoŋ lɨna pugu pa nnu shini vɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Gɔ̀ kiʼɛ ŋa ɔ yɛʼi ŋgwa nduoŋ nɛ, a pɔ khɔ paʼa ɔ lɔ njɛʼi noŋ yɔ? Nɔ haʼaŋ ɔ chīi nu ŋa kiʼi pi yōo nɛ, ɔ ghà njōo? ");
INSERT INTO bmo_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Gɔ̀ ŋa ɔ chhu ŋa kiʼi ŋgaŋ láŋ kwo shúoŋ nɛ, ɔ ghà ŋkwo shúoŋ? Gɔ̀ ŋa ɔ pɨ̄na pa nnwi nɛ, ɔ ghà njōo yaoŋ moŋ nda pa nnwi? ");
INSERT INTO bmo_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Gɔ̀ ŋa ɔ tɛnɛ nu ni gɨ́ nɛ, chɨ̄ʼə Minnwi ntɔgɔ pi ŋkuoŋ pəʼɨ nu gɨ́. ");
INSERT INTO bmo_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nɔ haʼaŋ pi nāʼaŋ moŋ Ŋwaʼaŋlɨ Minnwi ŋa, “Pi wɛʼi ligi Minnwi shɨna pa ŋgwa taoŋ nduoŋ nthɛ vəɨ.” ");
INSERT INTO bmo_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nthɛ ŋa ɔ̈ nchwīe nnu ŋa gɨ́ chhu nɛ, kaŋ nii nu mɔ ŋgunu mbrɛi fāʼo ghɛ̀rɛ. Ndɔ ɔ̈ mieŋ ki chwīe nnu ŋa gɨ́ chhu nɛ, kaŋ nii nu mɔ ŋgunu mbrɛi lɔ mfāʼo ghɛ̀rɛ vɛ, nnɛ ɔ pɔ nɔ ŋgwa taoŋ nduoŋ ŋa pugu lɔ njiʼi nii ŋgunu mbrɛi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nɛnnɛ, ŋoŋ ŋa a lɔ njiʼi nii ŋgunu mbrɛi nɛ n̈chwīe nnu haʼaŋ gɨ́ chhu nɛ, paʼa Minnwi lɔ ndīi vi nɔ haʼaŋ a pɔ pi ŋoŋ ŋa pi niʼiŋ vi ŋgunu mbrɛi? ");
INSERT INTO bmo_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Shishini, pa ŋgwa taoŋ nduoŋ haʼaŋ pugu shi lɔ nii ŋgunu mbrɛi, ndɔ nūʼɔŋ gɨ́ Minnwi nɛ, shi ŋgwɛ̄iŋ vəɨ mbɔ pa ŋgwa Juu, ŋa pəɨ fāʼo gɨ́ Minnwi ŋa pi nāʼaŋ nɛ, mbɨnɨ nii ŋgunu mbrɛi, ndɔ ŋguʼɔ mbɨnɨ ŋkara mbəʼɨ gɨ́ ghɔ nɛ nɔ pa ŋgushaʼa. ");
INSERT INTO bmo_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nthɛ ŋa yichəɨ ŋoŋ lɔ mbɔ fɔ ŋa a ŋoŋ Juu ŋguʼɔ nthɛ pi ŋa pa tǎa pi ni mbɔ pa ŋgwa Juu ndɔ paʼa nnu nii ŋgunu mbrɛi lɔ mbɔ pi yi frɛinoŋ haʼaŋ a nthɛ pi yəɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ndɔ ŋkiɛŋ ŋoŋ Juu pɔ pi moŋ ghɔ, ndɔ nii nu ŋgunu mbrɛi pɔ pi nnu moŋ njùʼɔ, ntɔgɔ pi mbhɔ Jijwɛ Minnwi, ki lɔ ntɔgɔ pi ŋkuoŋ gɨ́ ŋa pi nāʼaŋ nɛ. Ŋkwaŋ ŋoŋ ghɔ shiʼa mfāʼo ndighaʼo yi pi llɔ mbhɔ ŋoŋmishua, a ghà mfāʼo pi llɔ mbhɔ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ti ghɛ̀rɛ pɔ nu ŋoŋ Juu kiʼɛ pɔ pi khɔ? Ki ghɛ̀rɛ nii nu ŋgunu mbrɛi pɔ pi khɔ? ");
INSERT INTO bmo_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","A yiɛŋ moŋ ŋguoŋ puoŋ shɛndaoŋ. Fǔoŋ yi pɔ ŋa Minnwi ni mfɛ ŋkɨ̀nɨ yi pi ni pugu. ");
INSERT INTO bmo_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ti ä mbɔ ŋa pichəɨ shini ndɔ nchwīe nnu ŋa pugu fāʼo nɔ chwīe nu nɛ, mieŋ nu yugu ki lɔ nchwīe nnu ŋa pugu fāʼo nɔ chwīe nu nɛ shi ndɨʼɨ Minnwi nɔ chwīe nu nnu haʼaŋ a kāʼa nɛ? ");
INSERT INTO bmo_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Minthɛ paʼa a lɔ njiʼi mbɔ nɛnnɛ! Minnwi shi ŋguʼɔ mbɔ ŋgaŋ nnu shini, njiʼi nthɛ pi nɔ haʼaŋ ŋguoŋ pa ŋgwamishua pa ndɛʼi ŋgiɛŋ nɛ. Wuʼɔ nɔ haʼaŋ Ŋwaʼaŋlɨ Minnwi chhu ŋa, “Ŋa minthɛ pi yəɨ ghɔ nɔ ŋoŋ ndɨndɨ moŋ chrà yɔ, ndɔ ndɨɨ ŋa pi shaʼa ghɔ nɛ, jɔ chəɨŋ.” ");
INSERT INTO bmo_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","“Ndɔ,” yichəɨ ŋoŋ nthɛ a chhu ŋa, “ti ä mbɔ ŋa pa ntəɨ pia ghɛ̄rɛ nɔ nōoŋ nu ndɨndɨ Minnwi kaŋ minthɛ pia chhu pi ŋa? Ŋa Minnwi fāaŋ ndɨɨ ŋa a fɛ njɔ́ ni pia nɛ?” (Ǹchrā yei pi nɔ ŋoŋmishua). ");
INSERT INTO bmo_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Minthɛ paʼa a lɔ njiʼi mbɔ nɛnnɛ! Nthɛ ŋa a mbɔ nɛnnɛ, Minnwi kie pi nɛiŋ nshaʼa mbhi kiʼɛ? ");
INSERT INTO bmo_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Yichəɨ ŋoŋ nthɛ a pɨnɨ nchhu ŋa, “Ndɔ, ti ä ntɔgɔ pi ŋkuoŋ lɛʼiŋgiɛŋ a nnu shini Minnwi ya ntaoŋ páa nɔ fɛ nu ntou ndighaʼo ghɔ, pi pɨnɨ nuʼuŋ nshaʼa a nɔ nchwīe phɨ pi ŋa?” ");
INSERT INTO bmo_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","A pɔ khɔ kiʼɛ paʼa ɔ lɔ nchhu ŋa, “Pia chwīe phɨ nnɛ ŋa minthɛ a thɔ ni shiʼi?” Pichəɨ pa ŋgwa wɛʼi a ntɔgɔ pi ŋkuoŋ tigi nnu thɔ mu ŋa yei nnu ŋa ǹchhu nɛ. Pi shi mfɛ njɔ́ ni pugu nɔ haʼaŋ a pie nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Pia chhu ŋa kiʼɛ? Pia ŋa pia ŋgwa Juu nɛ pɔ shiʼi nchaa vugu? Ŋga! Pia lɔ mbɔ shiʼi nchaa vugu kaŋ shɨgɛi. Nthɛ ŋa pia kwo nōoŋ ŋa pa ŋgwa Juu pugu pa ŋgwa taoŋ nduoŋ ghao pɔ mbhɔ phɨ. ");
INSERT INTO bmo_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nɔ haʼaŋ pi nāʼaŋ nɛ: “Ŋoŋ ndɨndɨ lɔ mbɔ njiʼi nthɛ pi taʼa yi, ");
INSERT INTO bmo_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ŋoŋ ŋa a ji nnu nɛ lɔ njiʼi mbɔ fɔ. Paʼa yichəɨ ŋoŋ lɔ mbɔ ŋa a shigi Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ŋguoŋ ŋgwa shrī ŋkǔnu yugu ni Minnwi, pugu fāaŋ ndaoŋ ghao, yichəɨ ŋoŋ lɔ njiʼi nchwīe nnu ŋa a pwa, Njiʼi nthɛ pi taʼa yi.” ");
INSERT INTO bmo_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Chrà yugu luŋ nɔ fúŋ khu ŋoŋ haʼaŋ pi fīʼi. Pugu lɔ̄gɔ lɨŋ yugu nɔ fɨ̄ɨ nu ŋgwa nɔ ghɔ.” “Ŋgò pa mikwiŋ pɔ laʼo ghrāo nchò yugu.” ");
INSERT INTO bmo_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Nchò yugu lɨnaoŋ ni nchɔ̀nɔ pugu pa lwilwi chrà shāaŋ lɨʼɨ.” ");
INSERT INTO bmo_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Kwo yugu chɨgəɨ nɔ ghə̄ɨ nu njwi ŋoŋ. ");
INSERT INTO bmo_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Pɨrɨ nu pugu pa ŋgəʼɨ nūaŋ nɔ pa paʼo pugu sheshe lɨʼɨ haʼaŋ pugu ghə̄ɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Pugu lɔ njiʼi nji ŋkwaŋ haʼaŋ pi ghà ntɔgɔ nchhɔ ni taʼaŋggi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Pugu lɔ njiʼi njəɨ ŋa pugu fāʼo nɔ fāʼo nu pɔ́gɔ Minnwi.” ");
INSERT INTO bmo_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ndwɛ pia ji ŋa sheshe nnu ŋa gɨ́ Mushi chhu nɛ, a chhu pi ni ŋgwa pɛ ŋa a thɔ shaʼa vugu nɛ, nnɛ ŋa minthɛ nchò ŋguoŋ ŋgwa chri, Minnwi shi shaʼa ŋguoŋ ŋkuoŋ mbhi. ");
INSERT INTO bmo_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nthɛ ŋa minthɛ paʼa shesheŋoŋ lɔ ŋkāʼo ligi Minnwi ntɔgɔ pi ŋkuoŋ chwīe nu nnu haʼaŋ gɨ́ tāʼa nu nɛ, nthɛ ŋa gɨ́ wuʼɔ mbɔ pi nɔ chwīe nu pia ji phɨ yia. ");
INSERT INTO bmo_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ndɔ ndwɛ, Minnwi nōoŋ shɛndaoŋ haʼaŋ mimfɛ ŋgwa kie fɔ mbɔ ŋgwa ndɨndɨ shhɨ yu nɛ. A lɔ mfāʼo sheshe nnu nɔ chwīe nu ni nūʼɔŋ nu yaoŋ haʼaŋ gɨ́ tāʼa nu ŋa pi chwīe nɛ. Ndɔ gɨ́ Mushi pugu pa nnu pɛ ŋa pa njəɨlɨʼɨ Minnwi ni nāʼaŋ nɛ ni nchrā nthɛ shɛndaoŋ yei. ");
INSERT INTO bmo_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Pi chwīe pia pɔ ŋgwa ndɨndɨ ligi Minnwi ntɔgɔ pi ŋkuoŋ yɨʼə nu noŋ mbɨŋ Jishɔ Krishto ni shesheŋoŋ ŋa a piŋ nɛ. Nthɛ ŋa kwrí shi lɔ mbɔ, ");
INSERT INTO bmo_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","nthɛ ŋa ŋguoŋ ŋgwa chwīe phɨ nnɛ ki lɔ nuʼuŋ nchəɨŋ nthɨŋkwo ndighaʼo Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ndɔ pi chwīe pia pɔ ŋgwa ndɨndɨ pi nɔ fɛ́ llɔ ŋkuoŋ pwapuŋ Minnwi ntɔgɔ pi mbhɔ Krishto Jishɔ ŋa a yuoŋ via mfuʼu moŋ ŋkɨɨ phɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Minnwi fɛ Jishɔ pi nɔ yaoŋ fɛʼiŋgiɛŋ ŋa a fuʼu pɨgɨtua ju Minnwi nthɛ phɨ ntɔgɔ pi moŋ chhǐ yi. Minnwi līʼɛ phɨ ŋgwa ndɨɨ ŋa pugu fāʼo piŋ mbɨŋ Jishɔ Krishto nɛ. Minnwi ni nchwīe yei nɔ nōoŋ nu ŋa a ŋoŋ ndɨndɨ, nthɛ ŋa moŋ wɛ̄iŋ njùʼɔ ŋa a ni mfāʼo ni ghaŋ phɨ nɛ, a ni mieŋ ki lɔ mfɛ njɔ́ phɨ ŋa pi ni ŋkwo chwīe nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","A ni mbɔ nnɛ pi nɔ nōoŋ nu ndɨndɨ yi moŋ ndɨɨ yei, nnɛ ŋa a pɔ ŋoŋ ndɨndɨ ndɔ mbɔ ju mbɔ ŋgaŋ ŋoŋ ŋa a chwīe shesheŋoŋ ŋa a piŋ Jishɔ nɛ, pɔ ŋoŋ ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Minthɛ kiʼɛ pia nōoŋ noŋ yia pi ni khɔ? Yichəɨ yaoŋ lɔ mbɔ! Yei pɔ nthɛ pi khɔ? A pɔ nthɛ pi ŋa pia chwīe nnu ŋa gɨ́ chhu nɛ? Ŋga! A pɔ nthɛ pi ŋa pia piŋ. ");
INSERT INTO bmo_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nthɛ ŋa pia lūgwi ŋa ŋoŋ ghà ŋkāʼo mbɔ ŋoŋ ndɨndɨ ligi Minnwi ntɔgɔ pi ŋkuoŋ piŋ, ki lɔ ntɔgɔ pi ŋkuoŋ chwīe nu nnu haʼaŋ gɨ́ chhu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ki Minnwi wuʼɔ mbɔ pi Minnwi pa ŋgwa Juu təʼɨ vugu? A lɔ mbɔ Minnwi pa ŋgwa taoŋ nduoŋ ŋkaa pugu? Ooŋ, a Minnwi ŋgwa taoŋ nduoŋ ŋkaa pugu, ");
INSERT INTO bmo_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","nthɛ ŋa shishini, Minnwi taʼa yi, mbɔ ŋgaŋ ŋoŋ ŋa a shi nchhu ŋa pa ŋgwa Juu, mbɔ ghaŋ nii ŋgunu mbrɛi pa ŋgwa ndɨndɨ ntɔgɔ pi ŋkuoŋ piŋ. Pa ŋgwa taoŋ nduoŋ ŋkaa pugu, mbɔ ghaŋ ki nii ŋgunu mbrɛi wuʼɔ mbɔ ŋgwa ndɨndɨ ntɔgɔ pi ŋkuoŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yei nōoŋ ŋa ntɔgɔ pi ŋkuoŋ piŋ pia pɨgɛi gɨ́? Minthɛ paʼa a lɔ njiʼi mbɔ nɛnnɛ! Pia ka chwiechwie nnu ŋa gɨ́ chhu nɛ lɔ̄gɔ lɨʼɨ. ");
INSERT INTO bmo_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ti pia shi nchhu kiʼɛ ŋa Abrahaŋ ŋkhu tǎa via ni nshei pi khɔ moŋ frɛinoŋ? ");
INSERT INTO bmo_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nthɛ ŋa Abrahaŋ kaŋ ni mbɔ yi ndɨndɨ shhɨ Minnwi ntɔgɔ pi ŋkuoŋ pa fàʼa, a kaŋ ni mfāʼo nnu nɔ kwēi nu njùʼɔ yi nɔ ghɔ, ndɔ paʼa ndɔ mbɔ pi shhɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ŋwaʼaŋlɨ Minnwi chhu pi ŋa, “Abrahaŋ ni mbiŋ Minnwi, nthɛ piŋ yi, Minnwi lɔ̄gɔ vi nɔ ŋoŋ ndɨndɨ.” ");
INSERT INTO bmo_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ndwɛ, ni ŋoŋ ŋa a fāʼa, pi shiʼa mɛ̄iŋ pe yi pi ni kɨ̀nɛiŋ, a pɔ pi yaoŋ ŋa a fāʼa fàʼa mfāʼo. ");
INSERT INTO bmo_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ndɔ ni ŋoŋ ŋa a lɔ njiʼi mfāʼa, mbiŋ pi ŋoŋ ŋa a ghà nchwīe ŋgwa ki pɔgɔ Minnwi pɔ ŋgwa ndɨndɨ nɛ, pi lɔ̄gɔ piŋ yi nɔ ndɨndɨ shhɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Wuʼɔ nɔ haʼaŋ Devi ni nchrā nthɛ mbɔrɔ ŋa a pɔ mbɨŋ ŋoŋ ŋa Minnwi lɔ̄gɔ nɔ ŋoŋ ndɨndɨ ki lɔ nthɛ pi sheshe yaoŋ ŋa ŋoŋ ghɔ chwīe: ");
INSERT INTO bmo_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Mbɔrɔ yi pa ŋgwa pɛ ŋa pi līʼɛ pɨphɨ yugu nɛ, ŋa pi kuru phɨ yugu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Mbɔrɔ pɔ ni ŋoŋ yɛ ŋa Taathɔ lɔ njiʼi ndɔ̄gɔ pi phɨ yi nɛ.” ");
INSERT INTO bmo_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Mbɔrɔ yei wuʼɔ mbɔ pi ni pa ŋgwa haʼaŋ pi niʼiŋ vugu ŋgunu mbrɛi nɛ, ki a pɔ ni ghaŋ ki nii ŋgunu mbrɛi ŋkaa pugu? Pigi chhu ŋa pi ni ndɔ̄gɔ piŋ Abrahaŋ nɔ ndɨndɨ shhɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Pi ni ndɔ̄gɔ ŋa a ŋoŋ ndɨndɨ pi ndɨɨ khɔ? A ni mbɔ pi ndɨɨ ŋa a ni nii ŋgunu mbrɛi nɛ, ki ŋkaoŋ a maa nii ŋgunu mbrɛi? A ni mbɔ pi ndɨɨ ŋa a shini ndɔ naa nii ŋgunu mbrɛi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","A ni mfāʼo lì nii nu ŋgunu mbrɛi nɔ nōoŋ nu ŋa a ŋoŋ ndɨndɨ ntɔgɔ pi ŋkuoŋ piŋ moŋ ndɨɨ ŋa a shini ndɔ naa nii ŋgunu mbrɛi nɛ. Láʼo yi ni mbɔ nɔ chwīe nu a pɔ tǎa ŋguoŋ ŋgwa ŋa pugu piŋ ki lɔ nii ŋgunu mbrɛi nɛ, nnɛ ŋa minthɛ pi lɔ̄gɔ vugu nɔ ŋgwa ndɨndɨ ŋkaa pugu, ");
INSERT INTO bmo_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ndɔ mbɨnɨ nchwīe a pɔ tǎa pa ŋgwa ŋa pugu nii ŋgunu mbrɛi nɛ, ki lɔ mbɔ pi ŋgwa pɛ ŋa pugu wuʼɔ nii nii ŋgunu mbrɛi nɛ, mbɨnɨ mbɔ ŋgwa pɛ ŋa pugu chhɔ chɔmbhi ŋkwaŋ piŋ yɛ ŋa Abrahaŋ tǎa via ni nchhɔ ŋkaoŋ maa nii nu ŋgunu mbrɛi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Nthɛ ŋa kàʼa yɛ ŋa a ni mbɔ ni Abrahaŋ pugu pa ndaaŋoŋ yi ŋa ŋkuoŋ mbhi shi mbɔ ji nɛ shini ndɔ nthɔ ntɔgɔ pi ŋkuoŋ gɨ́, a ni nthɔ nthɛ pi ŋa a ni fāʼo piŋ, Minnwi lɔ̄gɔ vi ŋa a ŋoŋ ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Nthɛ ŋa a mbɔ ŋa Minnwi shi mfɛ yaoŋ ŋa a kāʼa nɛ pi ni pa ŋgwa haʼaŋ pugu fāʼo gɨ́ Mushi nɛ, a nōoŋ ŋa piŋ lɔ njiʼi mfāʼo ghɛ̀rɛ, ndɔ kàʼa Minnwi pɔ nnu ghagha. ");
INSERT INTO bmo_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Nthɛ ŋa gɨ́ thɔ ni pɨgɨtua Minnwi, ndɔ lɨʼɨ haʼaŋ gɨ́ shi lɔ mbɔ nɛ, pəʼɨ nu gɨ́ shi lɔ mbɔ ŋkaa yu. ");
INSERT INTO bmo_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","A chwīe yie kàʼa ghɔ yɨʼə pi ŋkuoŋ piŋ, nnɛ ŋa minthɛ kàʼa ghɔ yɨʼə pi ŋkuoŋ pwapuŋ Minnwi. Ŋguoŋ ndaaŋoŋ Abrahaŋ fāʼo tɨnɨnjuʼɔ nɔ fāʼo nu, ki lɔ ŋguʼɔ mbɔ pi pa ŋgwa pɛ ŋa pugu fāʼo gɨ́ Mushi nɛ, a pɨnɨ mbɔ ni ŋgwa pɛ ŋa pugu fāʼo ŋkwaŋ piŋ Abrahaŋ, mbɔ tǎa ŋguoŋ via ghao. ");
INSERT INTO bmo_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Wuʼɔ nɔ haʼaŋ pi nāʼaŋ nɛ, “Ǹchwīe ghɔ ŋa ɔ pɔ tǎa ntou pa laʼataoŋ,” shhɨ Minnwi ŋa a piŋ nɛ, ŋa a ghà mfɛ chɔmbhi ni ŋgwa pɛ ŋa pugu khu nɛ, chrà yi chwīe pa yaoŋ ŋa a lɔ njiʼi mbɔ nɛ, pɔ. ");
INSERT INTO bmo_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Njiʼi nthɛ pi ndɨɨ ŋa láʼo fāʼo nu kwàʼa shini ndɔ njiʼi mbɔ nɛ, Abrahaŋ kɨna nthɔ mfāʼo kwàʼa, mbiŋ nu ŋa a shi ŋgū tǎa ntou pa laʼataoŋ nthɛ ŋa Minnwi ni nchhu ghɔ ŋa, “Yinɛ fɨʼɨ ŋgwrɛiŋoŋ ŋa ɔ shi mfāʼo nɛ!” ");
INSERT INTO bmo_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Piŋ yi shini ndɔ njiʼi nchɨʼɨ njiʼi nthɛ pi ndɨɨ ŋa a ni ndīi noŋ yi a pɔ nɔ haʼaŋ a kwo kukhu, nnɛ nthɛ ŋa a ni ŋkwo pɔ nɔ taʼa ŋkɨɨ ŋgaʼo, ki ndɨɨ ŋa a ni ndīi njəɨ ŋa minthɛ paʼa Shera lɔ nuʼuŋ mbhi muuŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Abrahaŋ shini ndɔ mfāʼo khuthɔ moŋ piŋ yi nthɛ kàʼa ŋa Minnwi ni ŋkwo fɛ ghɔ nɛ. A ni ŋkuʼɔ ntɨnɨ moŋ piŋ yi nɔ haʼaŋ a ni mfɛ ndighaʼo ni Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Nja nji nu ŋa Minnwi fāʼo ghrɨ́ nɔ chwīe nu nnu haʼaŋ a kāʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","A ni nchwīe yie ghɔ, pi lɔ̄gɔ piŋ yi nɔ ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ndɔ chrà ghɔ ŋa, “Pi ni ndɔ̄gɔ vi nɔ ŋoŋ kakaʼo,” pi shini ndɔ nāʼaŋ nthɛ pi ju təʼɨ vi, ");
INSERT INTO bmo_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","a ni mbɨnɨ mbɔ nthɛ via ŋkaa pia. Pi shi ndɔ̄gɔ via nɔ ŋgwa ndɨndɨ, pia ŋa pia piŋ vi ŋa a ni mbɨʼɨ Jishɔ Taathɔ via moŋ gu nɛ, ");
INSERT INTO bmo_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","mbɔ ju ŋa pi ni mfɛ vi ŋa a khu nthɛ phɨ yia nɛ, pi pɨʼɨ vi moŋ gu nnɛ ŋa pia pɔ ŋgwa ndɨndɨ shhɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nthɛ yie ghɔ, nɔ haʼaŋ pia pɔ ŋgwa ndɨndɨ ligi Minnwi ntɔgɔ pi ŋkuoŋ piŋ nɛ, pia fāʼo taʼaŋggi pia pa Minnwi ntɔgɔ pi mbhɔ Jishɔ Krishto mbɔ Taathɔ via. ");
INSERT INTO bmo_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ntɔgɔ pi mbhɔ yu, pia pɨnɨ nuʼuŋ mfāʼo shɨ̀na ntɔgɔ ŋkuoŋ piŋ nɔ nii nu moŋ pwapuŋ Minnwi ŋa pia thi fɔ nɛ, mfāʼo pwanjuʼɔ moŋ kwàʼa ŋa pia fāʼo nɔ ghrā nu moŋ ndighaʼo Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ki lɔ ŋguʼɔ mbɔ pi yei, pia pɨnɨ nuʼuŋ mfāʼo pwanjuʼɔ moŋ ŋgəʼɨ, nji nu ŋa ŋgəʼɨ ŋa pia yəɨ nu nɛ shi nthɔ ni wɛ̄iŋ njùʼɔ, ");
INSERT INTO bmo_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","wɛ̄iŋ njùʼɔ thɔ ni mbha nnu shiʼi, mbaa nnu shiʼi thɔ ni kwàʼa ");
INSERT INTO bmo_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ndɔ kwàʼa shiʼa njiʼi njɨrɨ ŋoŋ, nthɛ ŋa Minnwi shāʼo khwǎ yi moŋ njùʼɔ pia ntɔgɔ pi ŋkuoŋ Jijwɛ yi ŋa a ni mfɛ ni pia nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Nthɛ ŋa nɔ ndɨɨ ŋa pia ni ŋguʼɔ ŋkɨ̄ʼɨ nɛ, ndɨɨ ni ŋga ŋkāʼo, Krishto khu nthɛ ghaŋ ki pɔgɔ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nthɛ ŋa a ghaʼa ni ŋoŋ nɔ khu nu nthɛ ŋoŋ ndɨndɨ, njiʼi nthɛ pi nɔ haʼaŋ minthɛ ŋoŋ fāʼo tɨnɨnjuʼɔ nɔ tāʼa nu ŋkhu nthɛ ŋkiɛŋ ŋoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ndɔ Minnwi nōoŋ khwǎ yi ni pia ntɔgɔ pi ŋkuoŋ taoŋ nu Krishto a thɔ ŋkhu nthɛ via ndɨɨ haʼaŋ pia ni ŋguʼɔ mbɔ pa nchwīe phɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Nthɛ yie ghɔ, nɔ haʼaŋ pia pɔ pi ŋgwa ndɨndɨ ligi Minnwi ntɔgɔ pi ŋkuoŋ chhǐ Jishɔ nɛ, a fɨʼɨ yi nɛiŋ ŋa a shi ndūgu ni pia mbhɔ pɨgɨtua Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nthɛ ŋa ä mbɔ ŋa ndɨɨ ŋa pia ni mbɔ ni kipɨna pia pa Minnwi nɛ, pi ni nchīni via pia pa Minnwi ntɔgɔ pi ŋkuoŋ gu Muuŋ vi, ndwɛ ŋa pia kwo chīni ŋggì nɛ, pia shi ndūgu pi fɨʼɨ yi nɛiŋ ntɔgɔ pi ŋkuoŋ chɔmbhi yi. ");
INSERT INTO bmo_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ndɔ yinɛ lɔ mbɔ ŋguoŋ yi, pia pɨnɨ mfāʼo pwanjuʼɔ ntɔgɔ pi mbɨŋ Taathɔ via, mbɔ Jishɔ Krishto, mbɔ ŋoŋ ŋa pia tɔgɔ mbhɔ yu mfāʼo chīni ŋggì pia pa Minnwi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nthɛ yie ghɔ, wuʼɔ nɔ haʼaŋ phɨ ni nii ŋkuoŋ mbhi ntɔgɔ pi mbɨŋ taʼa ŋoŋ nɛ, gu tɔgɔ mbɨŋ phɨ nii nɛ, nnɛ, gu shɛ̄rɛ ŋgwɛ̄iŋ ŋguoŋ ŋgwa ghao nthɛ ŋa ŋguoŋ ŋgwa ghao chwīe phɨ. ");
INSERT INTO bmo_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Nthɛ ŋa shishini, phɨ ni mbɔ moŋ mbhi Minnwi ma mfɛ gɨ́, ndɔ pi shiʼa nshia phɨ lɨʼɨ haʼaŋ gɨ́ lɔ mbɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ndɔ gu ni nshaʼa nɔ fùoŋ llɔ ŋkuoŋ Adaŋ ti ŋgə̄ɨ nchəɨŋ ndɨɨ Mushi, njiʼi nthɛ pi ŋgwa pɛ ŋa phɨ yugu shini ndɔ njiʼi mbɔ pi nɔ yi Adaŋ, ŋa a ni mbɔ mifhi ŋoŋ yɛ ŋa a thɔ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ndɔ kwrí pɔ shɨna yi paa ghɔ, nthɛ ŋa phɨ Adaŋ lɔ njiʼi mbɔ pi nɔ fɛ́ pwapuŋ Minnwi. Nthɛ ŋa ä mbɔ ŋa ntou ŋgwa ni ŋkhu ntɔgɔ pi ŋkuoŋ phɨ taʼa ŋoŋ, kaŋ pwapuŋ Minnwi pugu pa fɛ́ pwapuŋ ŋa taʼa ŋoŋ ghɔ mbɔ Jishɔ Krishto, fɛ ni ntou ŋgwa nɛ ghaʼo nchaa yie ghɔ. ");
INSERT INTO bmo_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kwrí pɔ shɨna fɛ́ Minnwi pugu nnu ŋa a llɔ ŋkuoŋ phɨ taʼa ŋoŋ ghɔ, mbɔ Adaŋ nɛ. Adaŋ ni ŋga nchwīe taʼa phɨ ghɔ, yie ghɔ chwīe pi shaʼa ŋguoŋ ŋgwa pugu gū sháʼa, ndɔ fɛ́ ŋa a ni thɔ ndɨɨ ŋa pi ni ŋkwo chwīe ntou phɨ nɛ ni nchwīe ŋgwa pugu taoŋ ŋgwa ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Nthɛ ŋa phɨ taʼa ŋoŋ vei ni nchwīe, gu jɛ̄ shaʼa nu nɔ fùoŋ ntɔgɔ pi ŋkuoŋ taʼa ŋoŋ ghɔ. Ndɔ pwapuŋ Minnwi pugu pa fɛ́ yi, mbɔ ndɨndɨ ka chaa yie ghɔ chaa nthɛ ŋa ŋguoŋ ŋgwa pɛ ŋa pugu kwe nɛ shi nchhɔ chɔmbhi yugu moŋ shaʼa nu nɔ fùoŋ ntɔgɔ pi mbhɔ taʼa ŋoŋ vei, mbɔ Jishɔ Krishto. ");
INSERT INTO bmo_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nthɛ yie ghɔ, nɔ haʼaŋ taʼa phɨ ni nchwīe ŋguoŋ ŋgwa gū sháʼa nɛ, wuʼɔ nɛnnɛ, taʼa nnu ndɨndɨ nchwīe ŋgwa gū ŋgwa ndɨndɨ shhɨ Minnwi mbɨnɨ nthɔ ni chɔmbhi ni ŋguoŋ ŋgwa. ");
INSERT INTO bmo_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Wuʼɔ nɔ haʼaŋ taʼa ŋoŋ ni nchɨ̄ʼə nchò ntou ŋgwa gū ghaŋ phɨ nɛ, nɛnnɛ yaʼo nchò taʼa ŋoŋ chwīe ŋa ntou ŋgwa shi ŋgū ŋgwa ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Ndwɛ gɨ́ Mushi ni nthɔ pi nɔ pigi nu phɨ, ndɔ lɨʼɨ haʼaŋ phɨ pigi nɛ, pwapuŋ Minnwi pɨnɨ mbīgi njiɛŋ ŋgaʼa. ");
INSERT INTO bmo_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nnɛ ŋa nɔ haʼaŋ phɨ ni shaʼa nu nɔ fùoŋ ntɔgɔ pi ŋkuoŋ gu nɛ, pwapuŋ Minnwi ŋkaa yu nthɛ a shaʼa nɔ fùoŋ ntɔgɔ pi ŋkuoŋ ndɨndɨ nthɔ ni chɔmbhi ki mmɛ ntɔgɔ pi mbɨŋ Jishɔ Krishto mbɔ Taathɔ via. ");
INSERT INTO bmo_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Pia shi nchhu pi ŋa ndwɛ? Pia shi ŋgə̄ɨ shhɨ moŋ phɨ nnɛ ŋa pwapuŋ Minnwi pigi ŋgə̄ɨ shhɨ ŋgaʼa? ");
INSERT INTO bmo_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Minthɛ paʼa a lɔ njiʼi mbɔ nɛnnɛ! Pinthɛ pia ŋa pia kwo khu nɔ chwīe nu phɨ nɛ kie pi nɛiŋ mbɨnɨ nthɔ nchhɔ chɔmbhi yia pi moŋ phɨ? ");
INSERT INTO bmo_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ki pəɨ lɔ nji ŋa ŋguoŋ yia ŋa pia ni ŋkwe ŋkhǐ mbɔ taʼa yi pia pa Krishto Jishɔ nɛ, kwe ŋkhǐ ghɔ ni nchwīe pia pugu pɔ taʼa yi moŋ gu yi? ");
INSERT INTO bmo_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Nthɛ yie ghɔ, pi ni ntwei via pugu ntɔgɔ pi ŋkuoŋ kwe ŋkhǐ. Nnɛ ŋa wuʼɔ nɔ haʼaŋ pi ni ŋkuʼɔ ni Krishto llɔ moŋ gu ntɔgɔ pi ŋkuoŋ ndighaʼo Tǎa nɛ, minthɛ pia ŋkaa pia chhɔ moŋ chɔmbhi fhi. ");
INSERT INTO bmo_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nthɛ ŋa p̈ia pugu mbɔ taʼa yi moŋ ŋkwaŋ gu yi, kaŋ shishini pia pugu shi mbɔ taʼa yi moŋ ŋkwaŋ kuʼɔ nu mi moŋ gu. ");
INSERT INTO bmo_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Pia ji ŋa pi kwo jwi ndunu noŋ yia pia pa Krishto kaʼa ŋkuoŋ wáʼa yi, nnɛ ŋa minthɛ paʼa phɨ lɔ nuʼuŋ mfāʼo ghrɨ́ mbɨŋ pia, ki pia lɔ nuʼuŋ mbɔ ŋkǔna mbhɔ nduthɔ phɨ ghɔ. ");
INSERT INTO bmo_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Nthɛ ŋa ŋoŋ ŋa a khu nɛ, pi fuʼu vi mbhɔ phɨ. ");
INSERT INTO bmo_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ndwɛ, ä mbɔ ŋa pia pa Krishto khu kaʼa, pia fāʼo piŋ ŋa pia pugu shi mbɔ yi maoŋ kaʼa. ");
INSERT INTO bmo_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Pia ji ŋa, moŋ kuʼɔ nu ni Krishto moŋ gu, mbaʼa a ma nuʼuŋ ŋkhu ŋkamuʼɔŋ, gu lɔ nuʼuŋ mfāʼo ghrɨ́ mbɨŋ yu. ");
INSERT INTO bmo_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Nthɛ ŋa gu ŋa a ni ŋkhu taʼa ŋgɛ́ ndɔ mbɔ ndugwi yi nɛ, a khu pi nɔ nnu chwīe phɨ, ndɔ chɔmbhi ŋa a chhɔ nu nɛ, a chhɔ pi nɔ pɔ nu pugu Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Nɛnnɛ p̂əɨ ŋkaa pəɨ lɔ̄gɔ noŋ yəɨ ŋa pəɨ ŋgwa khu nɔ nnu chwīe phɨ, mbɔ ŋgwa maoŋ pi nɔ tɔgɔ nu mbɨŋ Krishto Jishɔ mbɔ kaʼa pəɨ pa Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kiʼi pəɨ nuʼuŋ mieŋ phɨ shaʼa nu nɔ fùoŋ moŋ noŋ yəɨ, ŋa minthɛ a khu nɛ, nɔ chwīe nu pəɨ yaʼo pi nchò pa nnu tɔtrɔ ŋa a tāʼa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kiʼi pəɨ nuʼuŋ nchaʼa pa ghrà noŋ pəɨ mfɛ ni phɨ nɔ pa yaoŋ chwīe pa nnu təɨtəɨ, ndɔ p̂əɨ chaʼa noŋ pəɨ mfɛ ni Minnwi nɔ pa ŋgwa pɛ ŋa pi kwo fuʼu vugu moŋ gu nii nɔ ghɔ moŋ chɔmbhi, mfɛ pa ghrà noŋ pəɨ ni Minnwi nɔ pa maoŋ fàʼa nnu tithi. ");
INSERT INTO bmo_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nthɛ ŋa mbaʼa phɨ nuʼuŋ nshaʼa vəɨ, nthɛ ŋa pəɨ lɔ nuʼuŋ nchhɔ chɔmbhi njaʼo pi mbhɔ gɨ́, pəɨ chhɔ chɔmbhi yəɨ ntɔgɔ pi mbhɔ pwapuŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Yie pɔ kiʼɛ ŋa? A pɔ ŋa pia chhɔ nthɔ nchwīe pi phɨ nthɛ ŋa pia lɔ njiʼi nchhɔ chɔmbhi yia njaʼo pi mbhɔ gɨ́, pia chhɔ chɔmbhi yia pi mbhɔ pwapuŋ Minnwi nɛ? Minthɛ paʼa a lɔ njiʼi mbɔ nɛnnɛ! ");
INSERT INTO bmo_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Pəɨ lɔ nji ŋa pəɨ nchaʼa noŋ yəɨ mfɛ ni shesheŋoŋ nɔ pa ŋkǔna yaʼo nchò, kaŋ pəɨ ŋkǔna ŋoŋ ghɔ ŋa pəɨ chhɔ njaʼo nchò yi nɛ? Ki pəɨ pɔ pi yi phɨ, ndugwi yi pɔ gu, ki yi yaʼo nchò, ndugwi yi pɔ fāʼo nu chɔmbhi ndɨndɨ? ");
INSERT INTO bmo_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ndɔ pia tōo Minnwi ŋa pəɨ ŋa pəɨ ni mfǔoŋ mbɔ ŋkǔna phɨ nɛ gū pa ghaŋ yaʼo nchò yaoŋ yɛʼi pɛ ŋa pi ni mfɛ ni pəɨ nɛ llɔ njùʼɔ pəɨ, ");
INSERT INTO bmo_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ndɔ pi ni ŋga kwo fuʼu vəɨ moŋ phɨ, pəɨ gū pa ŋkǔna mbhɔ nnu ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ǹthɔ nchrā nu ni pəɨ, māʼaŋ fɨʼɨ pi nɔ ŋoŋmishua nthɛ ŋa ŋoŋmishua fāʼo kɨʼɨŋgɨnɨ nɔ ji nu pichəɨ nnu. Nthɛ ŋa wuʼɔ nɔ haʼaŋ a ni mbɔ yichəɨ ndɨɨ pəɨ fɛ pa ghrà noŋ pəɨ nɔ ŋkǔna pa nnu tɔtrɔ pugu nnu pɨphɨ nɛ, a chwīe pəɨ nii moŋ pɨphɨ mbīgi nɛ, nnɛ ndwɛ pəɨ chaʼa pa ghrà noŋ pəɨ mfɛ nɔ ŋkǔna mbhɔ nnu ndɨndɨ ŋa a shi nchwīe pəɨ pɔ yi taoŋtaoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Nthɛ ŋa ndɨɨ ŋa pəɨ ni mbɔ pa ŋkǔna mbhɔ phɨ nɛ, a shini ndɔ mbɔ pi yiʼi ni pəɨ nɔ chwīe nu nnu ndɨndɨ. ");
INSERT INTO bmo_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ndɔ pəɨ ni nshei pi khɔ ndɨɨ ghɔ llɔ ŋkuoŋ pa maoŋ pɛ ŋa pəɨ fāʼo lrithɔ ŋkuoŋ ghɔ ndwɛ nɛ? Ŋguoŋ nnu pighɔ ni nthɔ pi ni gu, ");
INSERT INTO bmo_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ndɔ ndwɛ ŋa pi kwo fuʼu vəɨ mbhɔ phɨ nɛ, pəɨ gū pa kǔna mbhɔ Minnwi nɛ, shéi ŋa pəɨ fāʼo nɛ a chhɔ nu mbɔ yi taoŋtaoŋ nchwīe pəɨ fāʼo chɔmbhi ki mmɛ. ");
INSERT INTO bmo_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nthɛ ŋa pa pe llɔ mbhɔ phɨ pɔ pi gu, ndɔ fɛ́ Minnwi pɔ chɔmbhi ki mmɛ moŋ pɔ nu taʼa yi pəɨ pa Krishto Jishɔ Taathɔ via. ");
INSERT INTO bmo_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Pa lǐŋ paŋ, ǹthɔ nchrā pi ni ŋgwa pɛ ŋa pugu ji gɨ́ nɛ, pəɨ shi lɔ njiʼi nji ŋa gɨ́ ghà ŋguʼɔ ŋkrao ŋoŋ pi ndɨɨ ŋa a yi maoŋ nɛ? ");
INSERT INTO bmo_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Gɨ́ krao láŋ shɨna miŋgwɛ pugu ndaoŋ vi pi ndɨɨ haʼaŋ ndaoŋ vi wuʼɔ mbiʼi yi maoŋ nɛ, ndɔ n̈daoŋ vi ŋkhu, kaŋ gɨ́ láŋ lɔ nuʼuŋ ŋkrao vi. ");
INSERT INTO bmo_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Nɛnnɛ kiʼɛ, n̈daoŋ vi mbɔ yi maoŋ a ji mimbia nduoŋ, kaŋ pi shi mɛ̄iŋ vi ni miŋkwoshuoŋ, ndɔ ti n̈daoŋ vi ŋkhu, kaŋ gɨ́ lɔ nuʼuŋ ŋkrao vi, nnɛ ŋa mbaʼa a yiʼi nuʼuŋ mbɔ miŋkwoshuoŋ njiʼi nthɛ pi nɔ haʼaŋ a laŋ mimbia nduoŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Wuʼɔ nɛnnɛ, ma pa lǐŋ paŋ, pəɨ ŋkaa pəɨ kwo khu nthɛ nnu gɨ́ ntɔgɔ pi moŋ noŋ Krishto, nnɛ ŋa pəɨ pɔ yi ŋoŋ nduoŋ, mbɔ ju ŋa pi pɨʼɨ vi moŋ gu nɛ, nnɛ ŋa minthɛ pia yuŋ ntíɛŋ ni Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nthɛ ŋa ndɨɨ ŋa pia ni ŋguʼɔ nchhɔ pi moŋ frɛinoŋ nɛ, shɔ̄rɔ nu pa nnu pɨphɨ, ŋa gɨ́ chwīe pia fāʼo nɛ, ni nthɔ mfāʼa nu moŋ noŋ pia nthɔ nu ni gu. ");
INSERT INTO bmo_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ndɔ ndwɛ, pi kɨ̄gɛi via mbhɔ gɨ́, ntɔgɔ pi moŋ khu nu mbhɔ ju ŋa a ni ŋgwɛ̄iŋ via nɔ ŋkǔna nɛ, nnɛ ŋa minthɛ pia fāʼa moŋ shɛndaoŋ fhi, mbɔ yi Jijwɛ, ki lɔ mbɔ pi yi moŋ ndunu shɛndaoŋ, mbɔ yi kɨna ŋa pi nāʼaŋ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Pia shi nchhu pi ŋa kiʼɛ? Ŋa gɨ́ Mushi pɔ pi phɨ? Minthɛ paʼa a lɔ njiʼi mbɔ nɛnnɛ. Ndɔ gɨ́ kaŋ ni ŋkiɛŋ ǹshi kaŋ nji yaoŋ ŋa phɨ yie ghɔ nɛ. Ǹshi kaŋ ndɔ nji yaoŋ ŋa shɔ̄rɔ nu yie ghɔ nɛ nɔ haʼaŋ gɨ́ kaŋ ni mieŋ ki chhu ŋa, “Kiʼi nshɔ̄rɔ yaoŋ ŋoŋ nduoŋ.” ");
INSERT INTO bmo_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ndɔ phɨ lɔ̄gɔ shɨna ntɔgɔ pi ŋkuoŋ kɨna, nchwīe m̀fāʼo ŋguoŋ ŋkwaŋ shɔ̄rɔ nu moŋ noŋ a ghao. Nthɛ ŋa gɨ́ kaŋ mieŋ ki kiɛŋ phɨ, kaŋ mbɔ pi yaoŋ khu. ");
INSERT INTO bmo_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ŋ̀ki pɔ yi maoŋ ndɨɨ ŋa gɨ́ shini ndɔ naa mbɔ nɛ, ndɔ ndɨɨ ŋa kɨna ni nthɔ nɛ, phɨ gū yi maoŋ, ŋ̀khu. ");
INSERT INTO bmo_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ya kɨ̀na ghɔ ŋa a ni ŋkāʼa fɛ nu chɔmbhi vəɨ ni ŋka thɔ pi ni gu vəɨ. ");
INSERT INTO bmo_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nthɛ ŋa phɨ ni mfɨ̄ɨ a, ntɔgɔ pi moŋ lɔ̄gɔ nu shɨ̀na mbhɔ kɨ̀na, ntɔgɔ moŋ ghɔ njwi a. ");
INSERT INTO bmo_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nnɛ gɨ́ yi taoŋtaoŋ, kɨ̀na pɔ yi taoŋtaoŋ, mbɔ yi ndɨndɨ ndɔ mbwa. ");
INSERT INTO bmo_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Yie ghɔ nōoŋ pi ŋa yaoŋ ŋa a yi shiʼi nɛ pɨnɨ nthɔ pi ni gu vəɨ? Minthɛ paʼa a lɔ njiʼi mbɔ nɛnnɛ! A phɨ ŋa a thɔ ni gu vəɨ ntɔgɔ ŋkuoŋ yaoŋ ŋa a pwa nɛ, nnɛ ŋa minthɛ pi nōoŋ ŋkiɛŋ ŋgwrà phɨ nɔ haʼaŋ a pɔ nɛ, ndɔ ntɔgɔ ŋkuoŋ kɨ̀na minthɛ pia yəɨ fɨʼɨ ŋkwaŋ haʼaŋ phɨ pɨgɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nthɛ ŋa pia ji ŋa gɨ́ Mushi llɔ pi mbhɔ Jijwɛ Minnwi, ndɔ m̀bɔ pi yi frɛinoŋ, pi fīni a nɔ ŋkǔna ni phɨ. ");
INSERT INTO bmo_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nthɛ ŋa ǹdɔ njiʼi nji nnu haʼaŋ ǹthɔ nchwīe nu nɛ, nthɛ ŋa ǹdɔ nthɔ nchwīe pi pa nnu pɛ haʼaŋ ŋ̀khwā nɔ chwīe nu nɛ, ndɔ ǹchwīe pi ya wuʼɔ pa nnu pɛ ŋa m̀bɨ̄na nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ndɔ ti m̈i nchwīe ya wuʼɔ nnu haʼaŋ ǹdɔ njiʼi ntāʼa nu nchwīe nɛ, pigi gɨ́ pɔ ni taʼa nchò, ǹthɔ mbiŋ nu ŋa gɨ́ pwa. ");
INSERT INTO bmo_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Nɛnnɛ, a lɔ njiʼi nthɔ nchwīe mmu nchwīe ntəɨ ghɔ, a thɔ nchwīe phɨ haʼaŋ a chhɔ mbɨŋ mu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nthɛ ŋa ǹji ŋa sheshe yaoŋ shiʼi lɔ njiʼi nchhɔ mbɨŋ mu, mbɔ moŋ frɛinoŋ a, nthɛ ŋa m̀fāʼo khwǎ nɔ chwīe nu nnu haʼaŋ a yi kaʼokaʼo nɛ, ndɔ paʼa njɨ chwīe nu nnu kaʼokaʼo ghɔ lɔ mbɔ. ");
INSERT INTO bmo_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Nthɛ ŋa ǹdɔ njiʼi nchwīe nnu shiʼi haʼaŋ ǹtāʼa nu nɛ, ndɔ phɨ ŋa ǹshi lɔ njiʼi ntāʼa nu nɛ ka pɔ ju yaoŋ haʼaŋ ǹthɔ nchwīe nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ndɔ ti m̈i nthɔ nchwīe ya wuʼɔ nnu haʼaŋ ǹdɔ njiʼi ntāʼa nu nɔ chwīe nu nɛ, kaŋ a lɔ njiʼi mbɔ mmu mbɔ ŋoŋ ŋa ǹthɔ nchwīe nnu ghɔ nɛ, ndɔ a ka thɔ nchwīe phɨ haʼaŋ a chhɔ mbɨŋ mu nɛ nchwīe nnu ghɔ. ");
INSERT INTO bmo_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Nnɛ, ǹjəɨ ŋkwaŋ haʼaŋ gɨ́ yei chhɔ mfāʼa nu nɛ: Ŋa ndɨɨ haʼaŋ ǹtāʼa nu nchwīe nnu haʼaŋ a kāʼo nɛ, phɨ wuʼɔ mbɔ pi ŋkiɛŋ yəɨ mu. ");
INSERT INTO bmo_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nthɛ ŋa fie moŋ njùʼɔ mu, m̀fāʼo pwanjuʼɔ ni gɨ́ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ndɔ ǹjəɨ gɨ́ nduoŋ fāʼa nu moŋ pa ghrà noŋ a, a thɔ māʼaŋ nchhɔ̀ pugu gɨ́ yɛ ŋa thɔ a shwei a ŋa a kāʼo nɛ, nchwīe m̀bɔ ŋgaŋ chə́ɨŋ mbhɔ gɨ́ phɨ haʼaŋ a fāʼa nu moŋ noŋ a nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Mi pɔ pi yəɨ ŋkwaŋ ŋoŋ gha nɛiŋ! A shi ŋkwe gɔ̌ ŋkwe a moŋ noŋ gu yei? ");
INSERT INTO bmo_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ndɔ pia tōo Minnwi ntɔgɔ mbhɔ Jishɔ Krishto mbɔ Taathɔ via! Nɛnnɛ kiʼɛ, mmu nduthɔ a fāʼa mbhɔ gɨ́ Minnwi ni pīʼi nu ma, ndɔ ni frɛinoŋ a m̀fāʼa pi mbhɔ gɨ́ phɨ. ");
INSERT INTO bmo_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nthɛ yie ghɔ, gū nu sháʼa lɔ nuʼuŋ mbɔ ndwɛ ni pa ŋgwa pɛ ŋa pugu taʼa yi pugu pa Krishto Jishɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Nthɛ ŋa moŋ pɔ nu taʼa yi pəɨ pa Krishto Jishɔ, gɨ́ Jijwɛ chɔmbhi kwo fuʼu ghɔ, ɔ lūgu mbhɔ gɨ́ phɨ pugu gu. ");
INSERT INTO bmo_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nthɛ ŋa yaoŋ ŋa a kaŋ ni nthɛ paʼa gɨ́ lɔ nchwīe nthɛ ŋa frɛinoŋ ni nchwīe a pou ghrɨ́ nɛ, Minnwi ni nchwīe ntɔgɔ pi ŋkuoŋ taoŋ nu Muuŋ vi moŋ púoŋ frɛinoŋ ŋoŋmishua nɔ yaoŋ fɛʼiŋgiɛŋ nthɛ phɨ, nnɛ ŋgwɛ̄iŋ phɨ nɔ ŋgushaʼa moŋ frɛinoŋ, ");
INSERT INTO bmo_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","nnɛ ŋa nnu ndɨndɨ ŋa gɨ́ tāʼa nu nɛ pɔ yi nūʼɔŋ moŋ chɔmbhi yia, mbɔ pia ŋa pia chhɔ chɔmbhi yia, ki lɔ mbɔ pi ŋkwaŋ haʼaŋ frɛinoŋ tāʼa nu nɛ, mbɔ pi ŋkwaŋ haʼaŋ Jijwɛ tāʼa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Nthɛ ŋa ŋgwa pɛ ŋa pugu chhɔ chɔmbhi yugu pi ŋkwaŋ haʼaŋ frɛinoŋ tāʼa nu nɛ ghà nūʼɔŋ njùʼɔ yugu pi ŋkuoŋ pa maoŋ frɛinoŋ ndɔ pa ŋgwa pɛ ŋa pugu chhɔ chɔmbhi yugu pi ŋkwaŋ haʼaŋ Jijwɛ tāʼa nu nɛ, ghà nūʼɔŋ njùʼɔ yugu pi ŋkuoŋ pa maoŋ moŋ Jijwɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Nthɛ ŋa ŋ̈gwa nūʼɔŋ njùʼɔ yugu ŋkuoŋ pa nnu frɛinoŋ a nthɔ pi ni gu, ndɔ nūʼɔŋ nu njùʼɔ ŋkuoŋ Jijwɛ, ghà nthɔ pi ni chɔmbhi pugu pa ghɨghrɨ. ");
INSERT INTO bmo_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Nthɛ ŋa ŋgwa pɛ ŋa pugu nūʼɔŋ njùʼɔ yugu pi ŋkuoŋ pa nnu frɛinoŋ nɛ pɔ ni kipɨna pugu pa Minnwi nthɛ ŋa pugu lɔ mfɛ noŋ yugu ni gɨ́ Minnwi, shishini, minthɛ paʼa pugu lɔ ndɔ mfɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ŋgwa pɛ ŋa pugu ghà njaʼo pi mbhɔ frɛinoŋ yugu nɛ, nthɛ paʼa pugu lɔ nchwīe túa Minnwi pwa. ");
INSERT INTO bmo_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ndɔ ni pəɨ, pəɨ lɔ njiʼi njaʼo pi mbhɔ frɛinoŋ yəɨ, pəɨ yaʼo pi mbhɔ Jijwɛ nɔ haʼaŋ ä nja mbɔ ŋa Jijwɛ Minnwi chhɔ njùʼɔ pəɨ. Shesheŋoŋ ŋa a lɔ njiʼi mfāʼo Jijwɛ Krishto moŋ chɔmbhi yi nɛ lɔ njiʼi mbɔ yi Krishto. ");
INSERT INTO bmo_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ndɔ ti K̈rishto mbɔ moŋ chɔmbhi yəɨ, njiʼi nthɛ pi nɔ haʼaŋ noŋ yəɨ yi khu nthɛ phɨ nɛ, Jijwɛ Minnwi fɛ chɔmbhi ni pəɨ nthɛ ŋa pi kwo chwīe pəɨ pɔ yi ndɨndɨ shhɨ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Jijwɛ ju ŋa a ni mbɨʼɨ Jishɔ moŋ gu nɛ n̈chhɔ mbɨŋ ghɔ, kaŋ ju ŋa a ni mbɨʼɨ Krishto llɔ moŋ gu shi mbɨnɨ mfɛ chɔmbhi ni frɛinoŋ yəɨ ŋa a ghà ŋkhu nɛ ntɔgɔ pi ŋkuoŋ Jijwɛ yi ŋa a chhɔ mbɨŋ ghɔ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nthɛ yie ghɔ, ma lǐŋ paŋ, pia fāʼo yaoŋ ŋa a yīʼi via, ki lɔ mbɔ pi ni frɛinoŋ nɔ chhɔ nu chɔmbhi yia ŋkwaŋ haʼaŋ frɛinoŋ tāʼa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Nthɛ ŋa pəɨ nchhɔ chɔmbhi yəɨ pi ŋkwaŋ haʼaŋ frɛinoŋ tāʼa nu nɛ, kaŋ pəɨ shi ŋkhu, ndɔ ti pəɨ ntɔgɔ mbɨŋ Jijwɛ Minnwi njwi mbha nnu noŋ, pəɨ fāʼo chɔmbhi. ");
INSERT INTO bmo_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Nthɛ ŋa ŋguoŋ ŋgwa pɛ ŋa a nōoŋ Jijwɛ nōoŋ ŋkwaŋ haʼaŋ pugu shi nchhɔ chɔmbhi yugu nɛ pɔ pi puoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nthɛ ŋa Jijwɛ ŋa Minnwi ni mfɛ ni pəɨ nɛ lɔ njiʼi mbɔ pi Jijwɛ ŋkǔna ŋa a shi nchwīe pəɨ pɨnɨ mbɔgɔ gu, a pɔ pi Jijwɛ ŋa a chwīe pəɨ gū puoŋ Minnwi, mbɔ Jijwɛ ŋa pia tɔgɔ mbhɔ yu ŋkə̄ɨ ni Minnwi ŋa, “Baba, Tǎa via!” ");
INSERT INTO bmo_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Jijwɛ Minnwi nduthɔ yi pɔ pi miŋkwentie ni jijwɛ yia ŋa pia pɔ pi puoŋ Minnwi. ");
INSERT INTO bmo_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ŋa pia puoŋ pi nɛ, nnɛ pia shi mfāʼo pa yaoŋ ŋa a nūʼɔŋ ni puoŋ pi nɛ, mbɨnɨ mfāʼo yaoŋ ŋa ju, Minnwi, nūʼɔŋ ni Krishto nɛ, pia pa Krishto kaʼa, nɔ haʼaŋ p̈ia pa Krishto njəɨ ŋgəʼɨ kaʼa nnɛ ŋa pia pugu fāʼo ndighaʼo kaʼa. ");
INSERT INTO bmo_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ǹja mfāʼo tɨnɨnjuʼɔ ŋa ŋgəʼɨ ŋa a pɔ ndwɛ nɛ lɔ njiʼi mbɔ yichəɨ yaoŋ nɔ haʼaŋ ɔ mbīʼi fɨʼɨ ndighaʼo yɛ ŋa Minnwi thɔ nu nōoŋ ni pia nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ŋguoŋ maoŋ pɛ ŋa Minnwi ni mbuoŋ nɛ thɔ njūa nu njwɛrɛ ndɨɨ ŋa Minnwi shi nōoŋ puoŋ yi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Nthɛ ŋa ŋguoŋ yaoŋ ŋa pi ni mbuoŋ nɛ shini ndɔ mfāʼo ghɛ̀rɛ, paʼa ndɔ mbɔ pi khwatua yugu, mbɔ nthɛ pi ŋoŋ ŋa a ni nchwīe pugu pɔ nnɛ nɛ. Ndɔ pugu ni ŋguʼɔ mfāʼo kwàʼa, ");
INSERT INTO bmo_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ŋa nduthɔ maoŋ pɛ ŋa pi puoŋ puoŋ nɛ, pi shi mfuʼu vugu moŋ ŋkɨɨ fɔ̄rɔ nu pugu nii mbara puoŋ Minnwi moŋ ndighaʼo pɔ nu ni thɔ yugu. ");
INSERT INTO bmo_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nthɛ ŋa pia ji ŋa ŋguoŋ maoŋ ŋa Minnwi puoŋ nɛ chhɔ nshɔnɔ nu kaʼa moŋ yúʼɔ ti nchəɨŋ ndwɛ nɔ yi miŋgwɛ ŋa muuŋ naoŋ vi nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","A lɔ ŋguʼɔ mbɔ pi pa maoŋ ŋa Minnwi puoŋ nɛ ŋa pugu shɔnɔ nu, njiʼi nthɛ pi nduthɔ yia ŋa pia fāʼo Jijwɛ Minnwi nɔ fǔoŋ fɛ nɛ shɔnɔ nu moŋ njùʼɔ pia nɔ haʼaŋ pia ywɛrɛ nu ŋkiɛŋ yie ghɔ ŋa Minnwi lɔ̄gɔ via nɔ puoŋ pi, ŋkɨ̄gɛi noŋ yia mfuʼu moŋ ŋkɨɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Nthɛ ŋa a ni ntɔgɔ pi ŋkuoŋ kwàʼa yei ŋa pia lūgu. Ndɔ ti kwàʼa ŋa pi yəɨyəɨ nɛ lɔ njiʼi mbɔ kwàʼa, nthɛ ŋa ŋoŋ shiʼa mbɨnɨ mfāʼo pi kwàʼa ŋkuoŋ yaoŋ ŋa a yəɨ nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ndɔ p̈ia mfāʼo kwàʼa nthɛ yaoŋ ŋa pia lɔ njiʼi njəɨ nɛ, pia ywɛrɛ yaoŋ ghɔ ni wɛ̄iŋ njùʼɔ. ");
INSERT INTO bmo_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Wuʼɔ nɛnnɛ, Jijwɛ Minnwi ghà ŋgɛ̄rɛ via moŋ pa ndɨɨ ŋa pia lɔ njiʼi ntɨnɨ nɛ. Nthɛ ŋa pia lɔ njiʼi nji pa nnu ŋa pia fāʼo nɔ luoŋ nu Minnwi nɔ ghɔ ŋkwaŋ haʼaŋ a ni mbie ŋa pia ji nɛ, ndɔ Jijwɛ Minnwi nduthɔ yi ghà ŋgɛ̄rɛ ndɨ̄gəɨ Minnwi mfɛ via nɔ ghɔ ni luo nu ŋa minthɛ paʼa chrà lɔ mfɨ̄ʼɨ nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ndɔ ti Minnwi ŋa a ghà njəɨ njùʼɔ yia nɛ, ji yaoŋ ŋa a pɔ moŋ njùʼɔ Jijwɛ nɛ, nthɛ ŋa Jijwɛ ghɔ ghà ndɨ̄gəɨ nthɛ ŋgwa Minnwi pi taoŋtaoŋ pi ŋkwaŋ nɔ haʼaŋ ju, Minnwi, tāʼa nu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ndɔ pia ji ŋa Minnwi ghà mfāʼa moŋ ŋguoŋ nnu ghao pi ŋa a pɔ shiʼi ni ŋgwa pɛ ŋa pugu khwā vi nɛ, ŋa pi gɛ̄ vugu ŋa pugu fāʼa ŋkwaŋ nɔ haʼaŋ Minnwi kāʼa nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Nthɛ ŋa ni ŋgwa pɛ ŋa Minnwi ni ŋkwo ji fie ndɨɨ ŋa pugu shi mbiŋ vi nɛ, a pɨnɨ ndɔ̄gɔ nthí mi ntɛrɛ vugu nchwīe pugu pɔ fhi Muuŋ vi, nnɛ ŋa minthɛ Muuŋ pɔ fǔoŋ phi shɨna ntou pa ghaŋ piŋ. ");
INSERT INTO bmo_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ŋgwa pɛ ŋa a ni ndɔ̄gɔ nthí mi nchuʼɔ vugu nūʼɔŋ nɛ, a ni mbɨnɨ ŋgɛ̄ vugu, ŋgwa pɛ ŋa a gɛ̄ vugu nɛ, a pɨnɨ nchwīe pugu pɔ yi tithi shhɨ yu, ŋgwa pɛ ŋa a chwīe pugu pɔ yi tithi shhɨ yu nɛ, a pɨnɨ nchwīe pugu fāʼo ŋkwaŋ ndighaʼo yi. ");
INSERT INTO bmo_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ti pia shi nchhu pi ŋa nthɛ ŋguoŋ nnu pei ghao? Ti M̈innwi mbɔ pia pugu kaʼa, a ghaʼa gɔ̌ ŋgaʼa via? ");
INSERT INTO bmo_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ju ŋa a shini ndɔ ŋgīʼɛ Muuŋ vi ni mfɛ vi nɔ yaoŋ fɛʼiŋgiɛŋ nthɛ via ghao nɛ, a shi ŋkie pi nɛiŋ mieŋ ki fɛ ŋguoŋ yaoŋ ghao ni pia ki lɔ ŋgīʼɛ, pugu pa Muuŋ vi ghɔ? ");
INSERT INTO bmo_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","A gɔ̌ ŋa minthɛ a wɛ̄iŋ ŋgwa ŋa Minnwi chuʼɔ nɛ ŋa pugu chwīe ntəɨ? Ŋoŋ lɔ mbɔ. A Minnwi mbɔ ŋoŋ ŋa a chwīe vugu pugu pɔ ŋgwa ndɨndɨ shhɨ yu nɛ. ");
INSERT INTO bmo_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ti minthɛ a wɛ̄iŋ gɔ̌ ŋgwɛ̄iŋ vugu nɔ pa ŋgushaʼa? Ŋoŋ lɔ mbɔ! Nthɛ ŋa Krishto Jishɔ ni ŋkhu, nɔ pigi nu ŋgə̄ɨ shhɨ, pi ni mbɨnɨ ŋkuʼɔ ni ju a pɔ yi maoŋ, a chhɔ ŋgei mbhɔ Minnwi yi jɨ nthɔ ndɨ̄gəɨ Minnwi nɔ ligi yia. ");
INSERT INTO bmo_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Minthɛ a fɛ̄nɛ gɔ̌ mfɛ̄nɛ via moŋ khwǎ Krishto? Minthɛ a pɔ mmɛ pa ŋgəʼɨŋgəʼɨ ki mmɛ yúʼɔ, ki ŋgəʼɨŋgəʼɨ ŋ