﻿USE sofia;
DROP TABLE IF EXISTS sofia.bmk_vpl;
CREATE TABLE bmk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bmk_vpl WRITE;
INSERT INTO bmk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Weni na Yesu Keriso, Meimeituwa natuna, Varana Beibeina ikarei. ");
INSERT INTO bmk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ivi karei, Meimeituwa ina kikiverena* Aisaiya kununa kava igirugirumi na Meimeituwa ina buka kamonai, evavavo bo, “Ke kitai, kununa aku wasawasa ana ki tawayei ma am keta ina vo kavikaviyei. ");
INSERT INTO bmk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wasawasa edimadima dobututu wai evavavo bo, ‘Bada ina piti kubina ko vokavikaviyana, ina keta kovo manimaniniya ma ina yawara.’” ");
INSERT INTO bmk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Vagheina ma wasawasa Jon ipiti rava ivivi towasamaghisi* dobututu wai ma Meimeituwa varana ivivi debei rava kurisi ivavavo bo, “Kota viremi ami berabero wai ma ami bera bero Meimeituwa ina nota kuputemi. Nuke taku ani towasamaghimi* na ini matakira da ami bera bero kone kuputei.” ");
INSERT INTO bmk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma rava tupasi yavu dobu Jiudia ma Jerusalem sinenai ikasibau Jon iti yanei. Maranai asi bera bero ivi debei, touna ivi towasamaghisi* Jodan yokowinai. ");
INSERT INTO bmk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ma Jon kana gara ikoteni na kamel* munimuninai iwouri ma ina bori saghira borinai isaghiri nana ghamoghamo kwapirina ma touna na keitupisi ikamkam ma manigewa imuma. ");
INSERT INTO bmk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma rava iki kisi ma ivavavo bo, “Muriku wai sago epitipiti, touna na ighe sasara iya taku nuke. Taku na iya kovokovoghina da ana tepika kana kae vopapara ghuravina ana vo tariya. ");
INSERT INTO bmk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taku na yokowai ai towasamaghimi*, ma touna na Kanuma Vokuwayinai ini towasamaghimi*!” ");
INSERT INTO bmk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Touna maranai, Yesu Nazaret yai ipiti Galili sinenai ma ipiti Jon kurina, ma Jon ivi towasamaghi Jodan yokowinai. ");
INSERT INTO bmk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma maranai yokowai igheghe tawayei, ikita da kunuma itamotaweyana, ma Kanuma Vokuwayina kitana kama gabubu isoru ku tepana. ");
INSERT INTO bmk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma pona kunuma yai ikasibau Meimeituwa ivi sisiya ivavo bo, “Tam na natuku, aku nuwa yuyuna ma ai gheghena kiraki yem.” ");
INSERT INTO bmk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mara sago kava touna murinai Meimeituwa Kanumina Yesu ivo tawayei ku dobututu irui. ");
INSERT INTO bmk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mara foti dobututu wai imake ma Seitan ivovo rubui. Touna na ghamoghamo kwakokwakosi sanasi yai imakemake nani dobunai, ma Meimeituwa ina aneya iruru koyaghi. ");
INSERT INTO bmk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Keivavo Herod, Jon Touvitowasamagha* ku dibura itawana runi, ma murinai Yesu inae ku Galili ma Meimeituwa varana idimedimei rava kurisi. ");
INSERT INTO bmk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ivavavo bo, “Meimeituwa mara itereterei na isegha! Meimeituwa ina Koyaga Yawasa Kuvouna ina rava kubisi na namada weni. Tami ami bera bero kone kuputesi ma varana beibeina ko tumetumei.” ");
INSERT INTO bmk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mara sago maranai Galili yawawina magaminai iyawayawara, ma tiya touyebayebaghisi* ruwa ikitasi, Saimon ma teina kiki Anduru, yawawai* iweiweito. ");
INSERT INTO bmk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ivi sisiya kurisi ma ivavo bo, “Ko piti, ko wagise ku. Ma ani beyemi da rava kona konasi da ina tumetumeku kama iki makava tiya ko konakonasi na nuke.” ");
INSERT INTO bmk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mara sago kava asi weito ivoteresi ma iwagisei. ");
INSERT INTO bmk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma nuke berokikina ine riya magamai kava, Sebedi natunatuna Jems ma Jon asi waga kamonai asi weito iwouwoura munamunagha na ikitasi. ");
INSERT INTO bmk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma, mara sago kava ighore kurisi ivavo bo, “Ko wagiseku.” Vagheina ma asi mamai waga kamonai ina toubagibagi meiteni ine kuyowesi ma iwagisei. ");
INSERT INTO bmk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Vagheina ma Yesu ma ina touvotaghotagho dobu ku Kapaniam isegha, ma maranai Sabati* isegha, Yesu dam Jiu asi vibeyebeyena ku numana irui ma giu ivi karei Meimeituwa varana rava kurisi. ");
INSERT INTO bmk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Igiugiu na kama rava sago ere maragasina, iya kama Mosese ina vigheiyena touvibeyebeyena* nuke, touna kubina rava ina giu ivi deiyei. ");
INSERT INTO bmk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Igiugiu maranai dam Jiu asi vibeyebeyena numana sinenai koroto sago kanuma berona itowai na igarara rukwatu. ");
INSERT INTO bmk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ma ivavo bo, “Am kayowana avai gwabiki yai, Yesu koto Nazaret? Ku piti wike kwa pupuniki bo? Asakovi da tam iyai, tam na Meimeituwa ina Vokuwayina.” ");
INSERT INTO bmk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma, Yesu ikawarupotei “Kevi yasamim! Koroto ke kasibu kuyowei.” ");
INSERT INTO bmk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Vagheina ma kanuma berona koroto ivo kirokiroroi ma ere gararina ikasibu kuyowei. ");
INSERT INTO bmk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma rava tupasi yavu ivi deiyena sasarei ma tousi mani ivi tupa vivirana meyesi ma ivavo bo, “Wena avai? Weni na giu vouna ere maragasina! Weni korotona na ina maragata imake da kanuma berosi, ina kawa rupotesi ma ivo teketekei!” ");
INSERT INTO bmk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mara sago kava Yesu varana ivi turawasei Galili dobuna inunui. ");
INSERT INTO bmk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ma mara sago kava tousi dam Jiu asi vibeyebeyena numana ikasibu kuyowei ma inae Saimon ma Anduru asi ku numa ma Jems ma Jon meiteni ine yavuyavu. ");
INSERT INTO bmk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon rawananaki wavinena igubaga ikenakena, muyamuya iveiya ma mara sago kava Yesu ivi seghei. ");
INSERT INTO bmk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ineru kuriya, imana iveiya ma ivowagui da ivo meiri. Mara sago kava muyamuya ivoterei ma kasi vavai ivo kavikaviyei. ");
INSERT INTO bmk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Namada ivivi kuririsi, ma yabodiri inene make maranai, rava gubagubagisi ma kanuma berosi itowatowasi na ipiti yesi Yesu kurina. ");
INSERT INTO bmk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma meiteni rava tupasi yavu nani ku dobuna iriyei ma matamkwetai ivi damnisi. ");
INSERT INTO bmk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma Yesu rava ipesari kirakai ivi yawasisi kasi gubaga bogeibogei ma kanuma berosi ipesari sasara ivi kasibunisi rava sinesi yai. Yesu kanuma berosi iya iti vagheinesi da ini sisiya, isakovi da touna na Meimeituwa natuna kubina. ");
INSERT INTO bmk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Boiboighi nubanubanai, dididibarinai, Yesu ikena vomeiri, numa ikasibu kuyowei ma ine seirana touna maniduma ivivi kawavenoveno. ");
INSERT INTO bmk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Murinai Saimon ma ina rava ivo meira inegwanegwai. ");
INSERT INTO bmk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma maranai ipananai, ma ivavo, “Rava tupasi yavu itarakasiyanem!” ");
INSERT INTO bmk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu, ikipotesi ma ivavo bo, “Ta nae ku meyagi gwabigwabitai, ma taku Meimeituwa varana rava ana giunisi. Iyamna na touna kubina apiti.” ");
INSERT INTO bmk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Vagheina ma Galili ine bouni Meimeituwa varana ivi debei dam Jiu asi vibeyebeyena numasi sinesi yai ma kanuma berosi ipesari sasara ivi kasibunisi rava gwabisi yai. ");
INSERT INTO bmk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mara sago koroto sago gubaga bero tomatomana lepera* iveiya. Ipiti Yesu kurina ma kae tupina iru tonai maghinonai ma ivi weno kuriya ma ivavavo bo, “Tam na kovokovoghina kwa beraku da ana seyaseya, mike da am kayowana.” ");
INSERT INTO bmk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Vagheina ma Yesu iru nuwayakapowei, imana ivo roroni ma ivotovoni ma ivavavo bo, “Vagheina, aku kayowana. Tam ku seyaseya!” ");
INSERT INTO bmk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma mara sago kava koroto nininai gubaga ikovi, ma ibeibai meme. ");
INSERT INTO bmk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bade Yesu ikikiraki yei, “Ke nae. ");
INSERT INTO bmk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Rava iya kwi seghesi da taku avai aberai. Ke nae maninina prist*kurina ma kwi beye meyem. Ma banuwara ina suwaghi ku yawasa kubina, Mosese ina vigheiyena nuke evavavo da touna rava ini matakiresi da tam ku seyaseya kubina.” ");
INSERT INTO bmk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Touna Yesu ponana iya iti yanei, ma ikasibau rava ivi segheseghesi avai itupuwa kurina ma varana dobu yavu inununui. Touna berana kubina Yesu iya kovokovoghina debanai ita rurui ku meyagi, bade inene seiseirana touna maniduma ma rava dobu tupana yavu ipitipiti kuriya. ");
INSERT INTO bmk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu ma ina touvotaghotagho ivovira meme ku Kapaniam. Mara visa murinai rava ivi yanei da Yesu na numai, ");
INSERT INTO bmk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ma rava ipesari sasara nake iriyei, da wasa kegha numa sinenai bo matamkwetai. Yesu Meimeituwa varana igiugiunisi. ");
INSERT INTO bmk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Korokoroto asi vi ruwamaruwa koroto bakobakona nigharai ikavari ipiti yei Yesu kurina. ");
INSERT INTO bmk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Numaduba irakata sasara da iya kovokovoghina korotona ita piti yei Yesu kurina, vagheina ma wawanai itu tete ighai ku vovo ma vovo ivo rikarikai. Yesu vovonai ma imakemake na. Gavogavo vovo wai iberai ikovi, koroto bakobakona nigharai ghuravai ivi soruni, Yesu ku dogarina. ");
INSERT INTO bmk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu asi tumetume ikitai, ma ivavo koroto bakobakona kurina, “Natuku, am bera bero anota kuputei.” ");
INSERT INTO bmk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mosese ina vigheiyena touvibeyebeyena* nani dobusi yai imakemake. Tousi mani asi notai ivivi tupavireyana meyesi: ");
INSERT INTO bmk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Meimeituwa kava bera bero ina nota kuputei. Avikubina weni korotona weni nuke isisiya? Touna Meimeituwa igibowei*, evavavo touna Meimeituwa nuke!” ");
INSERT INTO bmk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mara sago kava Yesu ina kanuma ikasi beyei da tousimani avai ivivi nuwatetei, ma ikisi bo, “Avikubina nuke koi nuwatete? ");
INSERT INTO bmk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Meni itekateka: Mike da ata vavo koroto bakobakona kurina, ‘Am berabero anota kuputei,’ bo mike da ata vavo, ‘Ke vomeiri ma am nighara ke kavari ma keyawara’? ");
INSERT INTO bmk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ani beyemi da kona kitai da taku na Koroto Keimatana*, ma maragata gwabikuwai da berabero ana nota kuputesi.” Bade koroto bakobakona ikiya, ");
INSERT INTO bmk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Akim, ‘Ke vo meiri! Am nighara ke kavari ma am ku numa ke nae!’” ");
INSERT INTO bmk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Koroto ivo meiri, ma mara sago kava ina nighara ikavari, ma inae, numaduba matasi yai. Tupasi yavu ivi deiyei, ma Meimeituwa ivo epaepae ma ivavavo bo, “Iya meyana bera sago weni nuke kata kitai!” ");
INSERT INTO bmk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu Kapaniam ine kuyowei ma ina touvotaghotagho meiteni yawawa* magami nai kava iyawara ine nae. Numaduba ipiti kuriya Meimeituwa varana igiugiunisi. ");
INSERT INTO bmk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ineriya maranai koroto sago kana wava Livai, Alfias natuna, ikitai. Ina makemake yai imakemake ma taks* iragaragau Rom asi gabeman kubina. Yesu ikiya, “Ke wagiseku ma kwi aku vi touvotaghotagho.” Vagheina ma ivo meiri da ine yavuyavu. ");
INSERT INTO bmk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Touna murinai, Yesu ma ina touvotaghotagho Livai ina numai ikamkam, taks* touragunisi ma bera bero ravasi meiteni, bade tousi Yesu iwagiwagisei nake ma wike. ");
INSERT INTO bmk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mosese ina vigheiyena touvibeyabeyena* ruwamtousi, tousi na Parisi*. Yesu ikitai taks* touragunina* ma bera bero ravasi meiteni ikamkam yavuyavu. Touna kubina Parisi* ina touvotaghotagho ikisi, “Avikubina taks* touragunisi* ma bera bero ravasi ruwamtousi meiteni ekamkam?” ");
INSERT INTO bmk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu touna ivi yanei, ma ivi sisiya kurisi, “Bunama ravana na iya rava yawayawasisi kubisi ita piti. Kegha, bunama ravana na rava gubagubagisi kubisi ipiti.” Ma ivi sisiya kurisi, “Taku iya ata piti da rava beibeisi ani yawasisi ma apiti da bera bero ravasi kubisi.” ");
INSERT INTO bmk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mara sago Jon ina touvotaghotagho ma Parisi* ruwamtousi asi dam ivivi siya. Rava ruwamtousi ipiti Yesu kurina ma ivi sisiya kurina, “Jon ina touvotaghotagho ma Parisi* asi touvotaghotagho isiya. Ma am touvotaghotago avikubina iya ita vivi siya?” ");
INSERT INTO bmk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ivavo kurisi, “Maranai tavine vouvou korotona, ina rava meiteni na kara iya ini siya, tousi nuke bo? Maranai tousi meiteni, tousi iya kovokovoghina ini siya tousi inuwa beibai sausau kubina. ");
INSERT INTO bmk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma maranai mara ina segha, tavine vouvou korotona ina vei tawayei, ma nani maranai ini siya, tousi ini nuwaboya kubina.” ");
INSERT INTO bmk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bade ivavo, “Taku bera vouna apiti yei, ma iya iti kovokovoghana ami bera wadubosi meiteni. Rava iya iyai gara vouna ina veiya ma gara wadubona tamo sikana ina popopotai, mike da nuke ina berai na gara vouna ini teiteinana na gara wadubona ina ta sikai, ina berai na ina ta sika nabanabai. ");
INSERT INTO bmk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bade nuke, iya iyai wain vouna ku wainkwapira* katamanina ina terei. Mike da touna ina berai, na nani wainkwapirina ini kwata. Iya kovokovoghina ita ta nabai maranai wain ipuropuroi. Avai ina tupuwa na wain ma wainkwapira* ini bero ruwasi! Kegha, rava wain vouna na ku wainkwapira* vouna ku sinena ina terei!” ");
INSERT INTO bmk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mara sago Sabati* yai Yesu ma ina touvotaghotagho vavai ere poposi rovuna* sananai iyawayawara. Maranai iyawara ine nae ma ina touvotaghotagho poposi ivuvuvu ita kam. ");
INSERT INTO bmk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisi* ruwamtousi ivi sisiya kurina maranai ikitasi nuke iberabera, “Ke kitai! Aki vigheiyena bagibagi Sabati* yai ivi ghaiyei. Avikubina tousi evovo bagibagi?” ");
INSERT INTO bmk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ikipotesi ma ivavo bo, “Tami kade meyana ko siyavi bo kegha Devida avai iberai maranai ina yaraga meiteni kam isiraghe ma ivoyadagha? Touna ko siyavi na, avikubina iyamna iya koti nuwa vitetei? ");
INSERT INTO bmk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Devida Meimeituwa ina numa iruni maranai Abaiatar nana prist* gheghena ma ivi bagha da parawa kubina. Prist gheghena parawa visana iverei. Nani parawina na parawa tarapaparina. Prist kava nani parawina ina kaniya, bade Devida visana ikaniya. Ma nuke parawa ruwamtousi ina yaraga iveresi. Bade nuke Meimeituwa iya ita notai da touna ita bero!” ");
INSERT INTO bmk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu ivi sisiya kurisi iteretupe meyei, “Meimeituwa Sabati* iterei na rava vowagusi kubina! Ma iya rava ita yamonisi da Sabati* kubina! ");
INSERT INTO bmk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Vagheina notana weni nuke: Touna kubina ina Koroto Keimatana* nana Bada, bade Sabati* badana!” ");
INSERT INTO bmk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mara sago Yesu dam Jiu asi vi beyebeyena ku numana irui meme, ma koroto ima sirasiraghena na imakemake na ikitai. ");
INSERT INTO bmk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Parisi* ruwamtousi asi kayowana da iti waroi, ma ikitakita nunura bubuni da ita kitai koroto ima sirasiraghena iti yawasi Sabati* yai. ");
INSERT INTO bmk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma Yesu koroto ima sirasiraghena ikiya, “Ke meira riya rava maghinosi yai kwa meiri.” ");
INSERT INTO bmk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bade nani ravasi ivi taraviresi ivavo bo, “Avai ita vigheiyena ivagheineta da Sabati* yai ta berai: Bera beibina ta berai bo bera berona ta berai? Bo ti yawasa bo ti siraghena?” Bade iya iyai ita ki potei. ");
INSERT INTO bmk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ma ere nuwaghisina ikita kwavikwavivirosi. Tousi nuwanuwasi ibagibagi sasara, ma touna kubina Yesu nuwanuwana ibero. Bade ivavo koroto ima sirasiraghena kurina, “Imam keta roroni.” Ma imana ita roroni ma iyawasa. ");
INSERT INTO bmk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Vagheina ma Parisi* mara sago kava ivomeiri ma inae Herod ina dam* kurisi ma sausau keta inegwai da Yesu iti waroi ma iti siragheni. ");
INSERT INTO bmk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu ma ina touvotaghotagho meiteni ine seirana yawawa* ku magamina, ma numaduba Galili yai iwagisei. Rava ipesari sasara Yesu bera iberaberai na varana ivi yanei, ma vagheina ma rava ipiti kuriya Jiudiai, Jerusalem yai, Idumeai, ma dobu tupana yavu idamana Jodan nevaneva nai ma ighae Taiya ma Saidon ririvisi yai. ");
INSERT INTO bmk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Rava ipesari sasara ivi yawasisi, ma nuke rava gubagubagisi ivivi vo duduwana da ita votovoni kubina. Vagheina ma rava igugugu sasarei kubina ina touvotaghotagho ikisi da waga sago ita kitai da iti yapakei. ");
INSERT INTO bmk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Meni dobunai kanuma berosi ikitakitai na kae kunukununai itawatawayesi ma iruru kwatu kurina, “Tam na Meimeituwa natuna!” ");
INSERT INTO bmk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bade Yesu iki kikiraki yesi da iya ini sisiya da touna iyai. ");
INSERT INTO bmk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ighe koya ku tepana ma ina kayowana korokorotosi ighoresi ipiti kuriya, ma ipiti kurina. ");
INSERT INTO bmk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Korokoroto asi vi 12 ivinesi da ita ta gwabiya ma ivi wavasi aposol*. Ivavo kurisi, “Aku kayowana da tami kona ta gwabiku, ma muriyai ana kitawayemi kona ka sibau da varaku rava kona ki veresi.” ");
INSERT INTO bmk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma maragata iveresi da kanuma berosi rava itowatowasi na ini ka sibunisi. ");
INSERT INTO bmk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Asi vi 12 ivinesi na kasi wava na weni: Saimon (iyai Yesu ighorei na Pita) ");
INSERT INTO bmk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi natunatuna Jems ma teina kiki Jon, Yesu ivi wavasi Boanejas (touna iyamna na ‘warikeyakeya natunatuna,’) ");
INSERT INTO bmk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduru, Pilip, Batolomiu, Matiu, Tomas, Jems, Alfius natuna, Tadius, Saimon na Selot ");
INSERT INTO bmk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iskariot iyai Yesu ivi benabenamei. ");
INSERT INTO bmk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma bade Yesu ma ina touvotaghotagho ku numa sinena irui, ma bade numaduba iriyei, ma tousi iya kovokovoghina da ita kam. ");
INSERT INTO bmk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Maranai ina dam nuke ivi yanei kubina na ivavo, “Isanene bo,” ma ivo meira da ita nae matepona ita vowai ma ita ruteni. ");
INSERT INTO bmk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Touvibeyebeyena Mosese ina vigheiyena yai ruwamtousi Jerusalem yai isoru ma ivavo bo, “Touna na kanuma berosi asi bada Bielsibab ibadebadei! Touna ina maragatai Yesu eberaberai da kanuma berosi ikasibunisi.” ");
INSERT INTO bmk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ma Yesu ighoresi ma meibai ivi sisiya kurisi, ivavo bo, “Ikimakava Seitan ita berai da Seitan iti kasibuni? ");
INSERT INTO bmk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mike da keivavo touna mani ita meiri tavirei ma touna mani iti ghaviya meyei nana nani keivavona iya kovokovoghina da ita meiri. ");
INSERT INTO bmk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma nuke bade dam ita meiri tavirei ma iti ghaviya meyei nana nani dam na iya kovokovoghina da ita meiri. ");
INSERT INTO bmk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma mike da Seitan ina dam tousi mani ita yaraghisi ma iti ghaviya meyesi kara iya kovokovoghina da ita meiri. ");
INSERT INTO bmk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Weni na meiba sago Seitan ina bera: Iya iyai kara ina rui koroto maragasina ina ku numa ma ina purapura ina yapi. Kegha da kununa ina patuma kikini ina kenakena ma muriyai da ina numai ina yapi. ");
INSERT INTO bmk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Weni na sisiya keimatana akiki bubunimi. Meimeituwa kara kovokovoghina rava avai eberaberai, isisiya wapawapa bo igibowa rava kurisi na ina nota kuputei. ");
INSERT INTO bmk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma bade rava iyai Kanuma Vokuwayina ini gibowei, Meimeituwa kara iya kovokovoghina ina nota kuputei ma ina bera bero ina make vaghata.” ");
INSERT INTO bmk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu weni nuke ivi sisiya kanuma berosi ivivi ka sibunisi na Kanuma Vokuwayina ina maragatai, ma tousi na ivivi sisiya wapawapa ma Kanuma Vokuwayina ivivi gibowei* kubina rava ivavavo bo, “Kanuma berona itowai.” ");
INSERT INTO bmk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma bade Yesu ina maduwa ma teiteina yoghoyogho isegha ma matarai ivivi meiriyana, ma rava sago ikitawa yei da Yesu ita kiya da ita kasibau kurisi. ");
INSERT INTO bmk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Numaduba irakata sasara Yesu imake garigariya, ma nani ravasi ikiya, “Am maduwa ma teiteim yoghoyogho matarai ma enegwanegwam.” ");
INSERT INTO bmk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iki potesi ma ivavo, “Aku maduwa ma teiteiku yoghoyogho na iyavo?” ");
INSERT INTO bmk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bade ikita kwa viviro rava kae kunukunu nai imakeni, ma ivavo bo, “Kovi yana! Weni na aku maduwa ma varevaresiku! ");
INSERT INTO bmk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iyavo Meimeituwa ina keta ekivikivini na varesiku, novuku, ma aku maduwa.” ");
INSERT INTO bmk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu giu ivi kare meyei Galili yawawina ririvinai. Rava damsi inae ina giu ivivi yanei, numaduba irakata sasara kubina da ku waga ivo geru da kamonai imake yawawa* tepanai, ma rava yawawa* kawa ririvinai imeirini. ");
INSERT INTO bmk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu meibai ivi sisiya, bera tupana yavu igiugiunisi. ");
INSERT INTO bmk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Yesu meibai ikisi. Ivavo bo, “Weni kovi yanei. Koroto sago, ina dowa ina kupurai iuwata yavui, ma pesi ivo suwasuwaghisi. ");
INSERT INTO bmk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pesi ruwamtousi na ketaki yai iririgha, da kiu ipiti da ikam yavusi. ");
INSERT INTO bmk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pesi ruwamtousi na dowa kimakimarinai iririgha, ma nani pesisi mara sago kava igogo, ");
INSERT INTO bmk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","bade ramramsi na itukemakema wota, maranai yabodiri iraranisi, na iberasi da isiraghe. ");
INSERT INTO bmk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pesi ruwamtousi inamona tonatonasi yai iririgha, ma inamona igogo ighae da iruputanisi ma iya iti yam. ");
INSERT INTO bmk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bade pesi ruwamtousi na dowa beibeinai iririgha na iru titi ma igogo bubuna ighai ma tupasi ivi yam bubuna. Ruwamtusi ivi yam na 30 ma ruwamtousi ivi yam na 60, ma ruwamtousi ivi yam na 100 kovokovoghina.” ");
INSERT INTO bmk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma ikisi, “Mike da tinimi emakemake na avai akikimi na kovi yanei.” ");
INSERT INTO bmk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mara sago, Yesu ina touvotaghotagho* asi vi 12 ma rava ruwamtousi kava meiteni ma ivi taravirei meiba kubisi. ");
INSERT INTO bmk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu ikipotesi ma ivavo, “Tami kava avi vagheinemi da Meimeituwa ina kasibeyemi da vara kena gavugavuna koni seghani Meimeituwa ikarei da rava ina koyaghisi yawasa vounai. Touna rava wapawapa kara iyamna iya ina sakovi, meibai kava ana vivi sisiya. ");
INSERT INTO bmk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nuke ana berai da tousi sisiya katakatamanisi Meimeituwa ina kikiverena* kununa kava igirumi na ina tupuwa, ‘Tousi ina kita ma ina kita ma kara iya ina vo modiya, Ini yana ma ini yana ma kara iya ina sakovi, Bo mike da asi bera bero ina ne kuputei na ana nota kuputesi.’” ");
INSERT INTO bmk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu ivi tarakasi yanesi, “Avai? Iya kota sakovi da meiba iyamna avai. Mike da weni meibina kovi pupuwei na kara iya meiyana meiba sago kona sakovi. ");
INSERT INTO bmk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Koroto pesi ivo suwasuwagha na touna iyai Meimeituwa varana rava ekikiveresi. ");
INSERT INTO bmk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Rava ruwamtousi na bagibagisi kama ketaki nuke. Vara ivi yanei, ma kegha da Seitan ipiti da nai varana iveitawayei. ");
INSERT INTO bmk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Rava ruwamtousi na kama dowa kimakimarina nuke. Ere nuwa beibeisi sisiya ivi yanei. ");
INSERT INTO bmk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mike da ramramsi kegha, na iya ina make guri. Maranai nuwaboya bo berabero ipiti iyamna nani varana kubina, mara sago kava ina basara. ");
INSERT INTO bmk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Rava ruwamtousi na kama dowa meni dobunai inamona tonatonasi igogo. Weni ravasi vara ivi yanei, ");
INSERT INTO bmk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bade tousi weni yawasina ivi nuwaboyei, mane ma purapura nuwanuwasi iveiya ma nani purapurasi varana iruputanisi, ma iya iti yam. ");
INSERT INTO bmk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma dowa beibeina na kama rava iyavo vara ivi yanei ma iveiya ma ivi yam bubuna, ruwamtousi 30, ruwamtousi 60 ma ruwamtousi na 100.” ");
INSERT INTO bmk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ivi sisiya kurisi, “Rava tapa ipiti yei da siripu gaburinai bo vatara gaburinai ita terei, bera nuke bo? Kegha. Tapa kana makemake tepanai iterei. ");
INSERT INTO bmk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bera tupasi tere gavugavusi na nuke nana kara Meimeituwa ina kasi beyesi. Ma bera kasi gavugavusi nuke na touna ina kasi gigirisi. ");
INSERT INTO bmk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mike da tinimi emakemake na avai akikimi na kovi yanei.” ");
INSERT INTO bmk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma ivi sisiya kurisi, “Kovi yana bubuna avai kovi yanei. Kovi yana kamowa ma kona sakova bubuni ma bade nuke, ipesari sasara kona sakovi. ");
INSERT INTO bmk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Touna kubina mike da aku sisiya ko vomodiya na, Meimeituwa ina vere kirakiyemi. Ma iyavo ivivi yanei ma iya ita vomodiya na tupana ini wapai.” ");
INSERT INTO bmk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ivavo, “Weni sisiyakutukutuna na Meimeituwa ikarei da ikimakava ina rava ina koyaghisi: Touna kama pesi egogogo, maranai koroto ina kupurai iyasiri. ");
INSERT INTO bmk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Didibarai na ekenakena ma marai na esupisupi, ma pesisi na nonowa egogogo, bade koroto iya ita sakovi da ikimakava egogogo. ");
INSERT INTO bmk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Touna mani tano eberaberasi na egogogo, kununa na erurutiti, muriyai na egogogo egheghae, bade ini yam sasara. ");
INSERT INTO bmk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Maranai da vavai imagura, koroto ivi karei da ina yabai.” ");
INSERT INTO bmk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu ivavo, “Vagheina ma meibina sago ana kimi ikimakava Meimeituwa ikarei da ina rava ina koyaghisi. ");
INSERT INTO bmk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Touna kama mastad* pesina nuke. Touna na pesi gisigisi vaghasina rava eyasiyasiri. ");
INSERT INTO bmk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bade maranai igogo ighae na keyama gubugubusi ighe kuyowesi, ma kovokovoghina rogunai na kiu ina runuma.” ");
INSERT INTO bmk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu sisiyakutukutu damsi nuke meibai ivi sisiya rava kurisi, da tousi ivi yana da inunusi. ");
INSERT INTO bmk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Meibai kava ivivi sisiya kurisi, bade maranai ina touvotaghotagho kava meiteni, na bera tupana yavu iyamna ikiki sakovisi. ");
INSERT INTO bmk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nani maranai, kuririsi yai, Yesu ina touvotahgotagho* ivi sisiya kurisi, “Ta damana yawawa* ku nevana.” ");
INSERT INTO bmk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Touna namada waga sinenai imakemake, ma tousi muriyai igeru. Numaduba ine kuyowesi ma idamana, waga ruwamtousi meiteni. ");
INSERT INTO bmk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma yanunu ghamanakina ivomeira, tovava waga iraraviya, ma yokowa waga iruruni da berokikina kava ita wounu. ");
INSERT INTO bmk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu na waga murinai ivi kunuwana ma ikenakena. Ina touvotaghotagho ikasi mataki ma ivavo, “Bada, berokikina kava da ta siraghe. Am nota nuke bo?” ");
INSERT INTO bmk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ivomeiri ma yanunu ikiya, “Ke tutuwa!” Ma tovava ikiya, “Kevi yasamim!” Yanunu ikovi ma beimara ikena. ");
INSERT INTO bmk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Touna ivi sisiya kurisi, “Avikubina ko yabumana?” Kara kava da kona tumetumeku bo?” ");
INSERT INTO bmk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iyabumana sasara, ma ivi ki daguwana, “Weni na koroto iyai? Ina maragata imake, da yanunu ma tovava ikisi da ita voterei, ma ivo teketekei!” ");
INSERT INTO bmk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu ina touvotaghotagho meiteni ipiti Galili yawawina ku nevanevana dobu Gerasa ravasi imakemake yeina. ");
INSERT INTO bmk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Maranai Yesu waga ikasibu kuyowei, mara sago kava koroto sago karawagai* ine kasibau. Weni korotona na kanuma berona ivivi badebadei. ");
INSERT INTO bmk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","Iya rava sago kovokovoghina da iti badei — mara ipesari kirakai imana ma kaena kiramai ipatumisi, nuke marana patapatana ipatupatumisi, ma ivivi kasi yaraghanesi, ma iya iyai kovokovoghina da iti votani ma ita patumi. Marai ma didibarai inene wapawapa, irurukiwara ma wakimai ivivi kasi teveyanei, karawagai* ma koyai imeimeira yawara. ");
INSERT INTO bmk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nokoma naki Yesu ikitai ma ivuru da maghinonai itawayei, ");
INSERT INTO bmk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ma irukiwara, “Yesu, Meimeituwa gheghena natuna! Am kayowana avai taku gwabiku wai? Meimeituwa wava nai, ai bagham iya kovogha kwa vereku!” ");
INSERT INTO bmk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Weni ivavo yei na namada Yesu ivavo kuriya, “Kanuma berona, weni korotona ke kasibu kuyowei!” ");
INSERT INTO bmk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu ivi taravirei, “Kam wava iyai?” Ikipote ma ivavo, “Taki na ka pesari sasara kubina taku kaku wava na Dam.”” ");
INSERT INTO bmk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma Yesu ivi bagha tupetupei da iya ina ki tawayesi weni dobuna ina kasibu kuyowei. ");
INSERT INTO bmk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Iya uwamai, koya ririvinai poro damsi ikarakarayaba. ");
INSERT INTO bmk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kanuma berosi Yesu ivi baghai, “Keki tawayeki poro kurisi, da ku sinesi kana rui.” ");
INSERT INTO bmk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ivi vagheinesi, ma kanuma berosi koroto ikasibu kuyowei ma poro ku sinesi irui. Poro asi pesara 2,000 nuke — ivi vuruvuruwana dagi iyoyowi da ku yawawa* ma iumabuta. ");
INSERT INTO bmk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Poro toughamosi ivi vuruwana inae ku meyagi ghamanakina ma meyagi yoghoyogho da rava ivi segheseghesi. Rava inae ita kita da avai itupuwa. ");
INSERT INTO bmk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Maranai ipiti Yesu kurina, ma koroto ikitai iyai kununa kanuma berosi itowai, na imakemake, gara ikotesi, ina nota beibeinai, ma tupasi yavu na iyabumana. ");
INSERT INTO bmk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Rava iyavo nani berana ikitai rava ruwamtousi ivi seghesi avai itupuwa koroto kanuma berosi itowai ma poro kurisi. ");
INSERT INTO bmk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Touna kubina Yesu ikiya da nani dobuna ina kasibu kuyowei. ");
INSERT INTO bmk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Maranai Yesu ku waga igerugeru, koroto kununa kanuma berosi itowai na Yesu ivi baghai da ita neyavuyavu. ");
INSERT INTO bmk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma Yesu iya iti vagheinei, bade ikiya, “Ke vovira am ku numa, ma bera tupana yavu Bada iberai kubim ma ina aga beibai kurim na kevi seghesi. ");
INSERT INTO bmk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Vagheina ma koroto ivomeira Dekapolis* yai ine rui ma ine kasibau ivi segha da Yesu avai kurina iberai. Ma iyavo ivi yanei na ivi deiyei. ");
INSERT INTO bmk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu ivovira meme, wagai yawawa* idamani. Touna kara kava yawawa* ririvinai ma numaduba iriyei kurina. ");
INSERT INTO bmk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Koroto sago ipiti kuriya, kana wava na Jairus, dam Jiu asi vibeyebeyena numana kana toukoyagha. Maranai Yesu ikitai na kae kunukununai isoru kai tupunai ");
INSERT INTO bmk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma ivi weno kuriya, “Natuku esirasiraghe. Ke piti da imam ku tepana kwa terei da ini damiya ma ina yawasa.” ");
INSERT INTO bmk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Vagheina ma Yesu meiteni inae. Numaduba na iwagisei ma ivivi vo duduwana. ");
INSERT INTO bmk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wavine sago nani, nawaravi iveiya da madegha 12 ikovi. ");
INSERT INTO bmk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ina mane bunama ravasi kurisi ine yavu, ma nuke ivovo kwarakwara make iya kovokovoghina da kana gubaga iti yawasi, ma kana gubaga na irakarakata. ");
INSERT INTO bmk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Yesu ipitipiti na varana ivi yanei ma touna mani ivavo, “Mike da ana nae ma kana gara kava ana votovonisi na ana yawasa.” Vagheina ma numaduba pousi yai itasonagha ighe da kana gara ivo tovonisi. ");
INSERT INTO bmk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mara sago kava tara vuru ivoterei ma damina iveiya da kana gubaga ikovi. ");
INSERT INTO bmk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mara sago kava Yesu damina iveiya da maragata ikasibu kuyowei ma numaduba sanasi yai imeira tavirei ma ivavo, “Iyai kaku gara ivotovonisi?” ");
INSERT INTO bmk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ina touvotaghotagho ikiya, “Ku kitai da numaduba ivo duduwana ma ku vavo da ‘Iyai ivo tovoniku?’” ");
INSERT INTO bmk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bade Yesu ikita negwanegwa, da ita kitai iyai ivo tovoni. ");
INSERT INTO bmk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wavine iyabumana ma ikirokiroro, bade isakovi da avai itupuwa kuriya. Nuke ma ipiti Yesu maghinonai kaetupina irutonai ma bera tupana yavu iki bubuni. ");
INSERT INTO bmk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bade Yesu ivavo ikiya, “Natuku, ku tumetumeku, kubina na kuyawasa. Kam gubaga ikovi. Ere nuwa beibeim ke nae.” ");
INSERT INTO bmk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kara kava ivivi sisiya, ma wasawasa Jairus ina numai isegha ma ivi sisiya kurina, “Natum kana mara ikovi. Avikubina Bada ki teina viravirai?” ");
INSERT INTO bmk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu asi sisiya ivi yana kuyowei ma ikiya, “Am nota iya ina soruwei, ke tumetumeku.” ");
INSERT INTO bmk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pita, Jems ma varesina Jon, Yesu ikasiveinisi — rava iya iyai iti vagheinei da tousi meiteni ita nae. ");
INSERT INTO bmk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairus ina ku numa isegha, ma Yesu rava damsi ikitasi ivivi toutouwana ma ighaghagharisi, ");
INSERT INTO bmk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ine rui ma ivi sisiya kurisi, “Avai kovi nuwaboyei na koi toutouwanei? Pipiya kiki iya ita siraghe — ekenakena wota.” ");
INSERT INTO bmk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tousi ivi namei, touna kubina ivi kitawayanesi ikasibau ma pipiya kiki ina maduwa, ina mamai ma ina touvotaghotagho asi vi aroba kava iveinisi, ma ku papayaragha irui pipiya kiki ma ikenakena. ");
INSERT INTO bmk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Imana iveiya ma ivi sisiya kurina, “Talitha, koum!” iyamna na, “Wavine kiki, akim, kevo meiri!” ");
INSERT INTO bmk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mara sago kava ivomeiri ma yawara ivi karei. Kana madegha na 12. Tousi ivi deiyena kavakavai. ");
INSERT INTO bmk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu iki kiraki yesi da iya rava sago ina kiya, ma ikisi, “Vavai ko verei ina kam.” ");
INSERT INTO bmk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ma ina touvotaghotagho nani dobuna ine kuyowei ma ivovira meme ina ku meyagi Nasaret. ");
INSERT INTO bmk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabati* yai touna giu dam Jiu asi vibeyebeyena numanai ivi karei. Rava damsi nani, maranai ivi yanei na ivi deiyei. Tousi mani ivi tupavire yana vivira, “Touna nuwasuyasuya ma iveiya? Ma ikimakava da inuwasuyasuya sasara? Ma, ikimakava aniba berasi eberaberasi?” ");
INSERT INTO bmk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ivi ki daguwana vivira, ma ivavo, “Touna na kamda kava, ta vavo bubuna bo? Mary natuna, ma varevaresina Jems, Joseph, Judas ma Saimon. Ma novunovuna na wa ta makemake yavuyavu, ta bo?” Nuke kubina inuwakapi yei ma iya ita tumetumei. ");
INSERT INTO bmk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ivi sisiya kurisi, “Rava Meimeituwa ina kikiverena* dobu yavu sinesi yai na ivo vivirei, ma ina meyagi wosinai, ina tupuwa ma ina dam asi vivira gwabinai na kegha.” ");
INSERT INTO bmk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Touna kubina iya kovokovoghina da aniba berasi nani dobunai ita berasi, imana kava rava visana gubagubagisi ku tepasi iterei ma ivi yawasisi. Yesu ivi deiyena sasaresi da asi nota soruwana kubina. Ma touna ine rui ma ine kasibau meyagi nununai rava igiugiunisi. ");
INSERT INTO bmk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu ina touvotaghotagho asi vi 12 ivi ruriyeriyesi ma ivi kita weyanesi ruweruwei yeta ikasibau ku meyagi bogeibogei yeta. Kanuma berosi kurisi vi badana iveresi, ");
INSERT INTO bmk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ma sisiya bagibagina iveresi, “Ami yawarai iya avai sago kona veiya ami diwona kava — vavai kegha, koutu kegha, ma mane kegha ami kikiru kamosi yai. ");
INSERT INTO bmk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kae vopapara ko kote, ma iya gara ruwa kona kotei.” ");
INSERT INTO bmk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bade ivavo, “Meni ku meyagisi kona segha, ina ru woremi ma ina koyagha bubunimi, nani numanai kava ko runuma da nani meyagina kona kasibu kuyowei. ");
INSERT INTO bmk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ku meyagi sago kona segha mike da rava ina kayo beromi bo iya ini yanemi, ko ne kuyowesi ma kaemi yapoyapo ko kasi sabusabui. Touna na ini mata kitekitesi, da tousi vara viyanina ibasarei. Meimeituwa tousi ini wavusi, vara viyanina ibasarei kubina!” ");
INSERT INTO bmk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nuke ma ikasibau rava ikikisi, “Ami bera bero ko tukuyowei ma Meimeituwa kurina kona taviremi.” ");
INSERT INTO bmk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kanuma berosi ipesari sasara ivi kasibunisi, ma oliv* monamonanai rava gubagubagisi ipesari sasara imumusi ma ivi yawasisi. ");
INSERT INTO bmk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Rava yavu na Yesu ivivi sisiyei, ma yavana itete. Rava ruwamtousi ivavavo, “Aniba berasi ibera berasi na vagheina touna Jon Touvitowasamagha*, rava sirasiraghesi sanasi yai iru yawasa meme.” Rava ruwamtousi ivavo, “Touna Elaija — ivoviri meme.” Rava ruwamtousi ivavo, “Touna Meimeituwa ina kikiverena*, kama Meimeituwa ina kikiverena* kununa kava nuke.” Keivavo Herod weni sisiyisi ivi yanesi, ma ivavo, “Jon Touvitowasamagha* na iwana akasi yaraghi, ma iru yawasa meme.” ");
INSERT INTO bmk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Weni sisiyakutukutu nana Herod Jon kamyona ikasiyaraghi. Touna itupuwa ma muriyai Yesu ina noya ivi karei. Herod varesina Pilip, kawana isaroi. Nani wavinena kana wava na Herodias. Nani berana murinai, Jon, Herod ikiya vigheiyena evavavo da, “Varesim kawana iya kwa ravaghi,” touna kubina Herod ina toughavighaviya iki tawayesi, ma Jon ikou patupatumi ma ku dibura itawana runi. Herod, Jon ikikiya da ipitipiti ivivi sisiya kuriya, ma bade ivivi nuwa ragharagha kiraki yei, ma ina sisiya viyanina ikayowana kiraki yei. Nani wavinena, Herodias, nuwanuwana ighisi kiraki yei Jon kurina, ma ina kayowana da iti siragheni, ma Herod isakovi da Jon na rava maninina ma vokuwayina, touna kubina na iyabumanei ma ivi tarapaparana kiraki yei. Iyamna touna kubina, nani wavinena iya kovokovoghina Jon iti siragheni. ");
INSERT INTO bmk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ina gavogavo ipananai maranai Herod ina tupuwa marana ivivi nuwa bibiyei. Gabeman keikeivavosi, touvighavighaviya babadisi ma Galili keikeivavosi asi kam iberai. ");
INSERT INTO bmk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias natuna weivine yoghoyoghona irui da ivi saka, ma Herod kana yopeyope meiteni ivi nuwa beibei kiraki yesi. Kubina na keivavo wavinena ikiya, “Am kayowana avai kwi bagheku? Na ana verem.” ");
INSERT INTO bmk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iki nuwaghani ma ivavo, “Aki nuwaghanim avai kwi bagheku na ana verem, mike da, namanaki da aku keivavo nevanevana na ana verem!” ");
INSERT INTO bmk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Vagheina wavinena ikasibau ma ina maduwa ivi baghai, “Avai ani baghei?” Ina maduwa ikipotei ma ivavo, “Jon Touvitowasamagha* tepapuna.” ");
INSERT INTO bmk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mara sago kava wavinena ita virei, yaghiyaghina kavakava irui keivavo kurina ma ikiya ma ivavo, “Aku kayowana na karako tete wosina Jon Touvitowasamagha* tepapuna dabirai kwa vereku.” ");
INSERT INTO bmk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Maranai da keivavo nuke ivivi yanei na ivi nuwaboya sasarei, ma kegha da kinuwaghana namada iberai kana yopeyope matasi yai, touna kubina iya kovokovoghina ina vibagha ita basarei, ");
INSERT INTO bmk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","vagheina ma ina toughavighaviya iki tawayei, ikiya da Jon tepapuna ina piti yei. Koroto ikasibau, dibura ku numana irui, Jon iwana ikasi yaraghi, ");
INSERT INTO bmk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma dabirai tepapuna ipiti yei da wavinena iverei, ma ina maduwa iverei. ");
INSERT INTO bmk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Maranai Jon ina touvotaghotagho varana ivi yanei, ipiti da tupuwina ikavari ine yei da ku guba* iterei. ");
INSERT INTO bmk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu ina aposol ivovira meme kurina ma iki vereverei avai tupana yavu iberai ma rava igiunisi. ");
INSERT INTO bmk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Rava ipesari sasara ivivi vuruvira kurisi touna kubina Yesu ina touvotaghotagho meiteni asi gavogavo iya ita makemake da ita kam. Touna kubina Yesu ivi sisiya kurisi, “Tami maniduma ko piti. Numaduba tane kuyowesi ma ta nae ku dobu makemake nuwatauna ma ti yamroverove.” ");
INSERT INTO bmk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Vagheina ma tousi mani wagai ikasibau da inae ku dobu makemake nuwatauna. ");
INSERT INTO bmk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bade rava ipesari kirakai ikitasi ma ivo modisi vagheina ma rava meyagi nununai ikei vuruvuru magamai kava da nani ku dobuna isegha yaghinina, muriyai ma Yesu ina touvotaghotagho meiteni isegha. ");
INSERT INTO bmk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Maranai Yesu wagai ine soru, numaduba ikitasi, kama sipusipu kasi toukoyagha kegha, touna kubina iru wayakapowesi ma ivi karei da bera ipesari kirakai igiunisi. ");
INSERT INTO bmk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yabodiri itata virei ma ina touvotaghotagho ipiti kuriya ma ivavo, “Wena dobututu ma yabodiri eyoriyori. ");
INSERT INTO bmk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Rava ke kitawayesi ina nae ku kwanatu ma meyagi gwabigwabitai kasi vavai ina gimara.” ");
INSERT INTO bmk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bade ikipotesi ma ivavo, “Ko kitasi da avi kona veresi da ina kam.” Ma, ivavo kuriya, “Ku kayokayowei da taki kana nae parawa 200 denarii ruvana kana gimari da weni numadubana kani kanisi bo?” ");
INSERT INTO bmk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma ivi taraviresi, “Parawa meni patana gwabimi yai? Mede kone kona kitai.” Maranai ipananai, na ivavo, “Parawa meikovi ma tiya ruwa.” ");
INSERT INTO bmk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Vagheina ma Yesu numaduba ikisi, “Ko make pikami gidagida tepanai damdam nununai.” ");
INSERT INTO bmk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Vagheina ma damdam nunusi yai imakeni, ruwamtousi 50 ma ruwamtousi 100. ");
INSERT INTO bmk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma Yesu parawa meikovi ma tiya ruwa iveiya ma ku kunuma itapae, Meimeituwa ivi kaikaiwei ma parawa ivo gimagimasi. Muriyai ina touvotaghotagho parawa ma tiya iveresi ma rava iveresi. ");
INSERT INTO bmk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tupasi yavu ikam da ikam siyouwa, ");
INSERT INTO bmk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ma ina touvotaghotagho kamtutura ivi siyasiyago da siripu asi vi 12 ivi tuposi. ");
INSERT INTO bmk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nani vavina na rava 5,000 ivi kaniya. ");
INSERT INTO bmk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mara sago kava Yesu ina touvotaghotagho ivo tawayesi ivi nau idamana yawawa* ku nevanevana ku Betsaida ma bade numaduba ikitakitasi da itavo tawayesi. ");
INSERT INTO bmk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ikitasi ine nae, ma muriyai ighe ku koya da iti kawavenoveno. ");
INSERT INTO bmk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nani didibarinai, ina touvotaghotagho wagai yawawa* pounai ma Yesu na tano wai tounamani kava. ");
INSERT INTO bmk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma ikita da ina touvotaghotagho ikitasi yare ivivi bagei ma ivivi baga, yanunu da tovava ivovo potepotesi. Dididibarinai, muriyai da mara ita tom, ine kasibau kurisi yawawa* tepanai iyawara inenae da ita ne vouresi. ");
INSERT INTO bmk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma ikitai, inotai na kama aruwaruwa ma ivi garagarare yana, ");
INSERT INTO bmk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ma ivi kaekirorosi. Bade mara sago kava Yesu ivi sisiya kurisi ma ivavo, “Nuwanuwami etora. Wena taku. Iya kona yabumana!” ");
INSERT INTO bmk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Ma ku waga igeru, yanunu inuba ma beimara ikena. Maghitepasi ibagibagi ma bera iya ita vomodiya, aniba parawai ikitai ma karakava ina sakovi da ikimakava iberai da parawa ipesari. Touna kubina ivi deiyena sasarei. ");
INSERT INTO bmk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yawawa idamani ma ipiti ku dobu Genasaret ma nani dobunai asi waga isaghiri. ");
INSERT INTO bmk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Waga ine kuyowei inenae ma rava mara sago kava ivomodiya. ");
INSERT INTO bmk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tousi dobu ivuruvuru bouni, ma meni dobunai ivivi yanei na gubagubagisi nigharai ipitipiti yesi kurina. ");
INSERT INTO bmk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu dobu ine yavui, ku kwanatu, meyagi ghamanakisi ma kitikitisi, rava gubagubagisi nani ku dobuna ipitipiti yesi, ma debakei nai itereteresi ma Yesu ivivi baghai, “Ke votereki da kam gara damona kava kana votovoni.” Ma iyavo ivotovoni na ina maragatai iyawasa. ");
INSERT INTO bmk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Parisi* ma vigheiyena touvibeyebeyena ruwamtousi, ma dam Jiu ipesari sasara asi bera wadubosi ipesari sasara irururusi asi imakiki ma kaekiki yai. Asi purapura tupana yavu, asi muma, asi yokowa siusiu ma asi nau, na ivovo yoyowa bubuna, da weni purapurasi Meimeituwa matanai na beibeina kavakava. Maranai vigimagimara dobunai evovovira, imasi ina vo nura vo yoyowa bubuna kirakiyei ma muriyai ina kam. Marana patapatana kununa imasi kava ina samagha ma muriyai da ina kam, asi imakiki ma kaekiki asi bera wadubosi irururusi. Mara sago Parisi* ma touvibeyebeyena* Mosese ina vigheiyenai Jerusalem yai isoru, ma Yesu imeiri viviri da iti yanei. Ikitai da ina touvotaghotagho ruwamtousi kasi vavai ikamkam ere ima dowadowasi. ");
INSERT INTO bmk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bade ivavo kuriya, “Am touvotaghotagho ere ima dowadowasi ekamkam, Meimeituwa matanai na iya ita beibai. Avikubina aki imakiki ma kaekiki asi bera wadubosi iya ita vovo nunuri?” ");
INSERT INTO bmk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ikipotesi, “Tami meira vireviremi, ko berabera meyemi da tami beibeimi! Kununa kava Meimeituwa ina kikiverena* Aisaiya igiruma na vagheina ivavo bubuna tami kubimi. Weni nuke igirumi, Meimeituwa ivavo, ‘Weni ravasi na ponasi yai kava evovo vivireku, ma nuwanuwasi iya taku gwabiku wai, ma ivi uwama taweyena. ");
INSERT INTO bmk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma tousimani asi bera wadubosi ibeyebeyena ma nuke evavavo tousi berasi na Meimeituwa ina vigheiyena. Touna kubina asi rudune na iyamna kegha.’” ");
INSERT INTO bmk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bade Yesu ivavo, “Tami na Meimeituwa ina vigheiyena ko tutu kuyowei ma tamimani ami bera ko rururunisi.” ");
INSERT INTO bmk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma meiteni ivavo kurisi, “Ko notanotai da ko berabera bubuni maranai Meimeituwa ina vigheiyena ko meimeiri kuputei ma ami bera wadubosi ko rururu bubunisi ami imakiki ma kaekiki yai. ");
INSERT INTO bmk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Weni na keta sago, ikimakava kwa berai. Mosese igiruma Meimeituwa ina vigheiyena kamonai, ‘Am mamai ma am maduwa kwa vo viviresi,’ ma ‘Iyaiyai ina mamai bo ina maduwa kurina ini sisiya bero, nani ravana na ina siraghe.’ ");
INSERT INTO bmk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bade tami ko vavavo touna vagheina da rava ina vavo asi maduamau ma mamimau kurisi, ‘Iya kovokovoghina da ana vowagumi. Taku namada avavonuwaghana da Meimeituwa kubina avai tami ata veremi.’ ");
INSERT INTO bmk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ko berasi da asi maduwamau ma mamimau ivi nota wapasi. ");
INSERT INTO bmk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Maranai nuke ko berai na tami Meimeituwa ina vigheiyena ko gasiya ma ami bera katamanisi ko rururusi. Ma touna na notanura kava. Ma bera nuke ipesari sasara ko berasi na Meimeituwa ina vigheiyena ko gasiya. ");
INSERT INTO bmk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu rava iwore meyesi da ipiti kuriya ma ivi sisiya kurisi, “Tupami yavu, aku sisiya ko viyana keimatani ma iyamna kona sakovi. ");
INSERT INTO bmk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Iya vavai sago rava ekanikaniya erurui ku kawana na ita beraberai da ita dowadowa Meimeituwa matanai. Bade avai sinenai ma avai kawanai ekasi kasibau touna nana eberaberai da rava edowadowa Meimeituwa matanai.” ");
INSERT INTO bmk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bade Yesu rava ine kuyowesi ma ku numa sinena irui ma ina touvotaghotagho ivi taravirei, “Meiba iyamna nana avai karakotete wosina kuvi sisiyei na?” ");
INSERT INTO bmk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ikipotesi, “Tami meiteni aku sisiya iyamna iya kota sakovi bo? Iya kota sakovi da maranai rava vavai ikaniya, nani vavina na iya ku nuwanuwana ita rui ma irui rava ku kamokamona ma bade tupuwina ina kasibu kuyowei. Touna iya ita berai da ita dowadowa Meimeituwa matanai.” Maranai Yesu touna ivi sisiyei, Touna ivi beyena da vavai bogeibogei na beibeisi Meimeituwa matanai. Iya vavai sago ina berata da ta dowadowa. ");
INSERT INTO bmk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma bade ivavo meme, “Avai rava sinenai ikasibau touna ina berai da ina dowadowa Meimeituwa matanai. ");
INSERT INTO bmk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Weni purapurasi na rava nuwa sinesi yai ekasi kasibau — nota bero, madawara, yapi, visiraghena, virikam, ");
INSERT INTO bmk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kam panikowa ma vikwina, aga bero, vibedabeda, viyaraga (ikenei), nuwakapi, viyanuwe, tura ghegheyana, ma kokara. ");
INSERT INTO bmk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Weni berasi tupasi yavu rava nuwa sinesi yai ekasi kasibau na rava ebera berasi da edowadowa Meimeituwa matanai.” ");
INSERT INTO bmk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Vagheina ma Yesu nani meyagina ine kuyowei ma inae dobu Taiya ririvinai ma nani dobunai ku numa sago irui. Iya ina kayowana da rava ita sakovi da touna nani ma iya kovokovoghina da ita kena gavu. ");
INSERT INTO bmk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Wavine sago ivi yanei da touna nani numa nai ma ipiti kuriya. Weni wavinena na iya Dam Jiu ma touna na dam viruwa. Touna na Fonisiya yai itupuwa, Siriya sinenai. Kanuma berona natuna wavinena ivivi badebadei touna kubina ipiti Yesu kurina maghinonai kaetupinai isoru ma ivivi weno kuriya da kanuma berona natuna sinenai iti kasibuni. ");
INSERT INTO bmk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu isakovi da touna na iya Dam Jiu ma touna kubina ivavo kuriya, “Iya ita beibai da didiyoghoyogho kasi vavai kata veiya ma kata tawayei koukou kurisi, kegha da kununa didayoghoyogho ina kam da ina kam siyowa.” ");
INSERT INTO bmk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bade wavinena iki pote, “Bada, ku vavo bubuna, bade kegha, da koukou kepakepa gaburinai kam ririgha ina kam, touna kubina vagheina kwa vowaguku.” ");
INSERT INTO bmk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bade ivavo kuriya, “Ere tumetumem ku kipoteku kubina, kanuma berona natum wai avi kasibuni. Ke vovira am ku numa.” ");
INSERT INTO bmk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Vagheina ma ivovira ina ku numa natuna ina kepanai ikenakena na ikitai. Kanuma berona namada ikasibu kuyowei. ");
INSERT INTO bmk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu dobu Taiya ine kuyowei ma ighai dobu Saidon ku pouna. Bade inae ku Galili yawawina ma Dekapolis* ineneni. ");
INSERT INTO bmk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma nani dobunai rava koroto teina potapotana ma iyai iya ita vivi sisiya bubuna, iru teina piti yei ma Yesu ivi baghai da imana ku tepana ita terei da iti yawasi. ");
INSERT INTO bmk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu, korotona ikasivei seirei ma asi viruwa rava ine seiresi ma ima kivinai koroto ku teinina isusuri ma bade imana isovai ma koroto pepana ivotovoni. ");
INSERT INTO bmk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ku mara itepa, koroto iru wayakapo wei iyayagha vutuwa ma ivavo bo, “Efata!” Iyamna ‘Ke tamo taweyana!’ ");
INSERT INTO bmk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mara sago kava koroto teinina irubouni, pepana papara ivi karei ma ivivi sisiya kamowa. ");
INSERT INTO bmk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bade Yesu ivi ghaiyesi da iya rava ruwamtousi ina kisi avai itupuwa. Ma touna nuke iki kiraki yesi, ma Yesu ponana iya iti yanei, tousi rava ipesari kirakai ivivi segheseghesi ikimakava koroto teina potapotana ma kawa potapotana ivi yawasi. ");
INSERT INTO bmk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Maranai rava sisiya nuke ivi yanei tousi ivi deiyena sasarei ma ivavo bo, “Touna bera tupana yavu eberaberai na beibeina kavakava. Rava tina potapotasi iyawasisi da iyana ma rava kawa potapotasi na ini sisiya.” ");
INSERT INTO bmk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nani maranai, rava ipesari sasara iriye meyesi. Numaduba nana iya ere vavisi, touna kubina Yesu ina touvotaghotagho ighoresi kurina ipiti, ma ivi sisiya kurisi, ");
INSERT INTO bmk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Numaduba na taku meiteni ka make yavuyavu da mara aroba ikovi, ma tousi na vavai kegha, touna kubina avi nuwaboyesi. ");
INSERT INTO bmk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mike da ana kitawayesi asi ku numa ere kam siraghesi, kara ketaki yai matanenerina ina pananai. Ma bade ruwamtousi na uwamai ipiti.” ");
INSERT INTO bmk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ina touvotaghotagho ikipotei ma ivavo bo, “Weni dobunai na rava iya ita makemake, touna kubina parawa meni dobunai ta veiya ruvaruvana da weni ravasi ina kam siyowa?” ");
INSERT INTO bmk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bade Yesu ivi taraviresi, “Parawa visa gwabimi yai?” Tousi ivavo bo, “Parawa meikovi ma kumaneva ruwa.” ");
INSERT INTO bmk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Vagheina ma Yesu numaduba ikisi da imake pikasi. Parawa meikovi ma kumaneva ruwa iveiya ma Meimeituwa ivi kaikaiwei, bade parawa ivo gimagima, ma ina touvotaghotagho iveresi da numaduba ita rereghisi, ma ina touvotaghotagho rava irereghisi. ");
INSERT INTO bmk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bade nuke tousi tiya yoghoyogho visana kava gwabisiyai, ma touna Meimeituwa ivi kaikaiwei tiya kubina ma ina touvotaghotagho ikisi da numaduba ina veresi. ");
INSERT INTO bmk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vagheina ma rava tupasi yavu ikam, da ikam siyowa. Ma bade nuke kam toutoura irakata kirakai imake terei; touvotaghotagho siripu asi vi 7 kam toutoura ivi tuposi. ");
INSERT INTO bmk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nama rava 4000 nuke. Muriyai Yesu ivotawayesi asi ku numa inae. ");
INSERT INTO bmk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mara sago kava, Yesu ku waga igeru ina touvotaghotagho meiteni, ma inae ku dobu Dalmanuta. ");
INSERT INTO bmk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi ruwamtousi ipiti ma Yesu ivivi ghe viravirai. Asi kayowana da Yesu ita rubui, touna kubina ivi taravirei da matakira Meimeituwai iti beyesi, da tousi iti tumetumei da aniba berasi Meimeituwai epitipiti. ");
INSERT INTO bmk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu nuwa sinenai kanumina isoruwana sasarei, ma ivavo bo, “Avikubina tami weni damna karako koi taravira matakira Meimeituwai? Akimi, kara iya meyana da tami matakira ana berai da kona kitai.” ");
INSERT INTO bmk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bade Yesu ma ina touvotaghotagho meiteni Parisi* ine kuyowesi ma ku waga igeru, idamana Galili yawawina ku nevana. Bade Yesu ma ina touvotaghotagho meiteni Parisi* ine kuyowesi ma ku waga igeru, idamana Galili yawawina ku nevana. Kubina. ");
INSERT INTO bmk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma touvotaghotagho nuwanuwasi iwapa da parawa ita veiya, ma parawa sago kava wagayai ma iya avai sago. ");
INSERT INTO bmk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu iki kiraki yesi ivavo bo, “Ko kita ruvami da Parisi* ma Herod asi ist iya ina waromi.” ");
INSERT INTO bmk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Touvotaghotagho ivitarapiri vivira nani sisiyina Yesu ivavavoweina, “Touta parawa iya kata pitiyei kubina na ist isisiyei.” ");
INSERT INTO bmk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu namada isakovi da tousi avai ivivi sisiyei kubina ivi tarakasiyanesi, “Avai koi nuwaboyei ma ko vavavo da parawa kegha? Agunai tami karakavanaki kona sakova kamowiku. Maghitepami ibagibagi ghagha! ");
INSERT INTO bmk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matami emakemake ma iya kota kitakita bubuna! Tinimi emakemake ma iya kota viviyana bubuna! ");
INSERT INTO bmk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Konotai bo kegha ikimakava parawa asi vi meikovi avogimagimasi ma arereghisi rava 5000 kubisi? Ma nani imakemake teresi na siripu asi vivisa kovi tuposi?” Ma ikipotei, “Siripu asi vi-12.” ");
INSERT INTO bmk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma Yesu ivi taravira meyesi, “Ma maranai parawa meikovi ma kumaneva ruwa avogimagimasi ma arereghisi rava 4000 kubisi ma maketeresi siripu visa kovi tuposi?” Ma ikipotei, “Siripu meikovi ma kumaneva ruwa.” ");
INSERT INTO bmk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu ivavo bo, “Tami karakava da kona sakoviku bo?” ");
INSERT INTO bmk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Maranai Yesu ma ina touvotaghotagho ipiti ku Betsaida meyagina, nani dobunai rava ruwamtousi koroto matapotapotana ikasiveiya ipiti yei Yesu kurina ma ivi baghai da ita votovoni ma iti yawasi. ");
INSERT INTO bmk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu koroto matapotapotana imana iveiya ma iruteni da meyagi ikasibu kuyowei. Vagheina ma koroto matana isovai ma imana ku matana iterei ma ivi taravirei, “Avai kekitakitai bo kegha?” ");
INSERT INTO bmk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Koroto ikita, ma ivavo bo, “Rava akitakitasi na kama keyama ita vivi yawayawareyana.” ");
INSERT INTO bmk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bade Yesu imana koroto ku matana itere meyei ma ikita uwara ma iyawasa ma bera tupana yavu iruyaghari. ");
INSERT INTO bmk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu ikiya bo, “Iya ku meyagi kwavovira meme, maninina kenai am ku numa.” ");
INSERT INTO bmk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Vagheina Yesu ma ina touvotaghotagho inae ku meyagi ruwamtousi Sisiriya Pilipai meyagina ghamanakina ririvinai. Ketaki yai iyawara inenae ma Yesu ina touvotaghotagho ivi taraviresi, “Rava ikima inuwanotenotei, da taku na iyai?” ");
INSERT INTO bmk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tousi ikipotei, “Rava ruwamtousi evavavo da tam na Jon Touvitowasamagha, rava sirasiraghesi sanasi yai ivovira meme, ruwamtousi evavavo da tam na kikiverena Elaija ivovira meme, ma ruwamtousi evavavo tam na Meimeituwa ina kikiverena kununa kava nuke.” ");
INSERT INTO bmk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bade ivi taraviresi, “Ma tami, kovavavo da taku iyai?” Pita ikipotei, “Tam na Keriso, Meimeituwa ina vinevine, Touviyawasa!” ");
INSERT INTO bmk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bade Yesu ikisi da iya iyai ina kiya da touna Keriso. ");
INSERT INTO bmk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bade Yesu ivi karei da ina touvotaghotagho ini beyebeyesi. Ivavo bo, “Taku, Koroto Keimatana*, kara ana keivowavowa sasara. Ma babada, Prist babadisi, Mosese ina vigheiyena touvibeyebeyena* ravasi ina basareku. Kaku ghaviya ini siragheniku ma mara aroba murinai ma ana vomeiri meme.” ");
INSERT INTO bmk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu weni berasi yagharinai ivivi sisiyesi touna kubina Pita Yesu irutenaviviri ma yeghana ivikarei. ");
INSERT INTO bmk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bade Yesu itavirei ina touvotaghotagho ikitasi ma Pita iyeghai, “Seitan kene kuyoweku! Tam iya kuta vivi nuwanotanota Meimeituwa ina ku nota ma rava asi ku nota kenotanota.” ");
INSERT INTO bmk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bade Yesu numaduba ma ina touvotaghotagho iworesi ipiti kurina ma ivi sisiya kurisi, “Mike da rava sago ina kayowei ina wagiseku na ina kayowana tupana yavu kumurina ina terei ma kana korosi ina kavari ma ina wagiseku. ");
INSERT INTO bmk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iyai ina kayowana ina yawasa ina votani, touna yawasa keimatana ini wapai, bade iyai ina kayowana ina yawasa ina basarei taku ma varaku beibeina kubina, na touna yawasa keimatana ina pananai. ");
INSERT INTO bmk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mike da rava iyai weni dobuna yawasina beibeina ina votani, ma yawasa keimatana ini wapai, nani berasi tupasi yavu kara iya ina vowagui. ");
INSERT INTO bmk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mike da rava ina yawasa keimatana ini wapai na kara iya kovokovoghina ina gimara meyei. ");
INSERT INTO bmk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Rava iyavo karako emakemake na kama rava iya patupatutusi ma tousi bera berosi eberaberasi. Iyai karako taku ma varaku ini pupuwei, nuke taku, Koroto Keimatana*, touna ani pupuwei. Weni touna ina tupuwa maranai ana vovira meme ku dobu aku mamai ina borumai ma ina aneya vokuwayisi meiteni.” ");
INSERT INTO bmk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bade Yesu ivavo kurisi, “Taku sisiya keimatana akikimi, tami ruwamtumi weni, na kununa Meimeituwa epitipiti ina rava ina koyaghisi ere maragasina na kona kitai ma muriyai kona siraghe.” ");
INSERT INTO bmk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mara meikovi ma kumaneva sago murinai Yesu Pita, Jems, ma Jon tousi kava ikasi veinisi ighae koya gheghena ku tepana, ma na Yesu kitakitana itawanavirei tousi matasi yai. ");
INSERT INTO bmk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kana gara na ivi mata kamokamota sasara. Iya iyai weni dobunai gara ina tinasuwaghi na ina ghavora nuke. ");
INSERT INTO bmk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Vagheina Elaija ma Mosese iruseghana ma Yesu meiteni ivivi sisiya. ");
INSERT INTO bmk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Touvotaghotagho asi viaroba na iyabumana sasara, ma Pita iya ita sakovi da avai ini sisiyei, touna kubina Yesu kurina weni nuke ivi sisiya, ivavo bo, “Bada, ibeibai da touta weni dobunai. Taki vada asi viaroba kana yamoni, sago tam kubim, sago Mosese kubina ma sago Elaija kubina.” ");
INSERT INTO bmk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bade ghuva iruseghana ma iruputanisi ma ghuva sinenai Meimeituwa ivi sisiya, ivavo bo, “Wena natuku aku nuwayuyuna. Koviyanei!” ");
INSERT INTO bmk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mara sago kava touvotaghotagho ikita kwavikwaviviro ma iyaiyai sago ita kitai, Yesu kava. ");
INSERT INTO bmk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Maranai Yesu ma ina touvotaghotagho asi viaroba koyai isorusoru, ma Yesu iki yapakesi, “Avai kokitai na iya rava sago kona kiya. Taku Koroto Keimatana* siragheyai ina vomeiri ma muriyai da rava kona kisi.” ");
INSERT INTO bmk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Vagheina ma tousi iya rava sago ita kiya ma tousi mani ivi tupa vireyana meyesi, “Bade siragheyai ina vomeiri meme isisiyei na iyamna avai?” ");
INSERT INTO bmk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bade Yesu ivi taravirei, “Avikubina da touvibeyebeyena* Mosese ina vigheiyenai evavavo da Elaija kununa ina vovira meme, bade Keriso muriyai ina piti?” ");
INSERT INTO bmk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu ikipote, “Elaija kununa ina piti bera tupana ina vokavikaviyei Keriso ina piti kubina. Meimeituwa varana bade evavavo taku, Koroto Keimatana*, ana keivowavowa ma rava ina basareku. ");
INSERT INTO bmk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sisiya keimatana akikimi da Elaija namada ipiti ma rava asi kayowanai iberai kurina. Kununa kava Meimeituwa varanayai ikimakava igirumi touna kubina na nuke itupuwa.” ");
INSERT INTO bmk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu ma ina touvotaghotagho asi viaroba ivovira ma inae touvotaghotagho ruwamtousi kurisi, ma ikita da numaduba ghamanakina imeiri kwavikwavivirosi, ma touvotaghotagho vigheiyena touvibeyebeyena* ruwamtousi meiteni ivivi ghaseyana. ");
INSERT INTO bmk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Maranai rava Yesu ikitai na tousi irusakwara ma ivi nuwabeibai ma ivivi vuruwana da inepotei. ");
INSERT INTO bmk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ivi tarakasiyanesi, “Avai koi ghaseyanei tousi meiteni?” ");
INSERT INTO bmk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Koroto sago numaduba sanasiyai iki potei, “Bada, kanuma berona natuku itowai ma iberai da ivi kawa potai, touna kubina apitiyei kurim. ");
INSERT INTO bmk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maranai kanuma berona evovomeira kuriya, na ku dowa etawatawayei, kawana epuropuroi, okena ekarakarakikini, ma ibadobadowana. Am touvotaghotagho avi baghasi da iti kasibuni, ma iya kovokovoghina ita berai.” ");
INSERT INTO bmk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu ikipotesi ma ivavo, “Te-e-e, dam keitumetumemi! Tami rorovani kava taku tami meiteni! Ma mara visa tami kubimi ana meiri? Koroto kiki kopitiyei kuriku!” ");
INSERT INTO bmk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Vagheina ma koroto kiki Yesu kurina ipitiyei. Mara sago kava kanuma berona Yesu ikitakitai, na koroto kiki ikayo sirasiragheni, ma koroto kiki ku dowa isoruwei, ivisuvirevirei, ma kawapurona ikasibau. ");
INSERT INTO bmk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu koroto kiki ina mamai ivi taravirei, “Mara avai weni gubagina idagui?” Touna ikipotei ma ivavo, “Touna meyameyana maranai. ");
INSERT INTO bmk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mara patapatana ku keyama karakarasina ma ku yokowa itawatawayei, da iti siragheni kubina. Mike da tam kovokovoghim, keru wayakapoweki ma ke vowaguki.” ");
INSERT INTO bmk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ivavo kuriya, “Avi kubina kuvavo, ‘Mike da tam kovokovoghim’? Iyai etumetume, Meimeituwa kovokovoghina bera tupana yavu ina berai kubina!” ");
INSERT INTO bmk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mara sago kava koroto kiki ina mamai ponana ghamanakinai ivavo, “Atumetume. Ma aku tumetume iya itarakata, touna kubina ke vowaguku da ina rakata!” ");
INSERT INTO bmk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu ikitai da numaduba iriyeriye kousisi, vagheina ma kanuma berona ikikirakiyei, ivavo bo, “Tam kanumim rava ki tina potasi ma ki kawa potasi, akiki kirakiyem da koroto kiki ke kasibu kuyowei ma iya meyana kwaru meme ku sinena!” ");
INSERT INTO bmk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kanuma berona irukwatu, koroto kiki ikasi sirasiragheni ma koroto kiki ikasibu kuyowei. Koroto kiki kitana kama rava sirasiraghena ikenakena, rava ipesara sasara nani dobunai ivavo bo, “Isiraghe!” ");
INSERT INTO bmk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bade Yesu imanai ivotani ma iteinapaini ma ivomeiri. ");
INSERT INTO bmk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muriyai Yesu ku numa sinena irui, tousimani duma ma ina touvotaghotagho ivi taravirei ivavo bo, “Avikubina taki iya kovokovoghina da kanuma berona kati kasibuni?” ");
INSERT INTO bmk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ivi sisiya kurisi, “Weni nuke kanuma berona na touta iya kovokovoghina tikasibuni, kegha da vi kawavenoveno wai kava.” ");
INSERT INTO bmk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yesu ina touvotaghotagho meiteni nani dobuna ine kuyowei ma dobu Galili yai itu yaragha inenae. Ina touvotaghotagho ivivi beyebeyesi touna kubina iya ina kayowana da rava ina sakovi da touna nani dobunai. Weni nuke ivi sisiya kurisi, “Kaku ghaviya taku, Koroto Keimatana*, ina veiniku da rava kuimasi ina tereku da ini siragheniku, bade mara aroba ina kovi na ana vomeiri meme.” ");
INSERT INTO bmk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bade tousi ina sisiya iya ita vomodiya kubina, na iyabumana da iya iti taravirei. ");
INSERT INTO bmk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu ma ina touvotaghotagho ku Kapaniam isegha ma ku numa sinena irui, ma ivi taraviresi, “Ketakiyai na avai ko vivi ghaseyanei?” ");
INSERT INTO bmk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ketakiyai tousimani ivivi ghaseyana da sanasiyai na iyai bada, touna kubina na ivi yasamisi. ");
INSERT INTO bmk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Imake pikai, ma asi vi 12 ighoresi da itariyesi kurina, ma ivi sisiya kurisi, “Iyai ina kayowana da ini bada, touna ina tere soruwana meyei ma ini muri tawayena ma touna ini toubigabiga rava kubisi.” ");
INSERT INTO bmk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesu pipiya kiki iveiya ma pousiyai ivi meirini. Itarasaghavui ma ivi sisiya kurisi, ");
INSERT INTO bmk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Iyai weni pipiya kikina nuke ini kaikaiwei taku wavakuai, na taku ikaikaiweku, ma iyai ikaikaiweku, iya taku kava iti kaikaiweku, ma iyai ikitawayeku na meiteni ikaikaiwei.” ");
INSERT INTO bmk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon Yesu kurina ivi sisiya, “Bada, koroto sago kakitai kam wavai kanuma berosi ivivi kasibunisi. Touna na iya touta ita yaraga, touna kubina kavigheiyei da iya ina bera meyei.” ");
INSERT INTO bmk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ivavo, “Iya koni gheiyei. Rava sago aniba berasi kaku wavai ina berai na iya kovokovoghina da mara sago kava ini vara beroweku. ");
INSERT INTO bmk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iyai iya iti ghaviyeta touna na kata gwani. ");
INSERT INTO bmk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Vagheina sisiya keimatana akikimi, rava sago yokowa ina veremi ko numai taku kaku wavai ma ko kivikiviniku kubina, touna kana maiya ina veiya kara iya meyana da ini kegha. ");
INSERT INTO bmk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mike da rava sago rava kiki iyai itumetumeku na ku berabero ina terei, rava kiki kama weni pipiya kikina nuke, Meimeituwa ina kovogha kirakiyei. Ibeibai mike da nani ravana kamyonai wakima ghamanakina ina saghiri ma ku neyagha ina tawayei, ma touna kovoghina na iya itarakata. ");
INSERT INTO bmk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mike da imam ina beram da berabero kwa berai, ke kasiyaragha tawayei. Ibeibai da imam sago kava ma ku yawasa keimatana kwa rui, iya ita beibai da imam ruwa meiteni ku keyama karakara vaghasina kwa rui. ");
INSERT INTO bmk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mike da kaim ina beram da berabero kwaberai, ke kasiyaragha tawayei. Ibeibai da kaim sago kava ma ku yawasa keimatana kwarui, iya ita beibai da kaim ruwa meiteni ku keyama karakara vaghasina ina tawana runimu. ");
INSERT INTO bmk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mike da matam ina beram da berabero kwaberai, ke tupa tawayei. Ibeibai da matam sago kavai ma Meimeituwa ina Koyaga Yawasa Kuvouna kwarui, iya ita beibai da matam ruwa meiteni ku keyama karakara vaghasina ina tawana runimu. ");
INSERT INTO bmk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nani dobunai, ‘motamota rava ekanikanisi na kara iya ina siraghe, ma keyama karakarasina iya meyana ina siraghe.’ ");
INSERT INTO bmk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Aku touvotaghotagho tupasi vorubu vitana ina pananai damina kama keyama karakarasina nuke, ma nani keyamina karakarasina ina berasi da Meimeituwa matanai tousi na seyaseyasi, kama neyagha ku banuwara etereterei ma ekapukapuni na nuke.” ");
INSERT INTO bmk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Neyagha na purapura beibeina, ma mike da ina dagisa ina kovi, touna iya kovokovoghina taberai da ina dagisa meme. Ko berai da tami kama vavai neyagha meiteni etavatava na nuke — tupami yavu kwamaru yai komake.” ");
INSERT INTO bmk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu Kapaniam meyagina ine kuyowei, inae Jiudia ku dobuna ma Jodan yokowina idamani. Rava damsi ivivi ruriyena meme kurina, ma ivivi beyebeyesi kama marana patapatana ikimakava iberaberai na nuke. ");
INSERT INTO bmk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi* ruwamtousi ikayokayowei da ita rubui, ma ipiti kurina, ma ivi taravirei, “Kade ita vigheiyena ivagheineta da koroto kovokovoghina kawana ina basarei?” ");
INSERT INTO bmk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ikipotesi ma ivavo, “Mosese vigheiyena iveremi, na ikimakava evavavo?” ");
INSERT INTO bmk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tousi ivavo, “Mosese ina vigheiyena ivi vagheina da koroto vibasabasarana pepana ina girumi, ma kawana ina verei ma muriyai ina kitawayei.” ");
INSERT INTO bmk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bade Yesu ikipotesi ma ivavo, “Tami na kami vibeyebeyena ibagibagi ma ko kawaghaseghase kirakai, touna kubina Mosese ina vigheiyena igirumi nana tami kubimi. ");
INSERT INTO bmk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bade konotai karenai, maranai Meimeituwa bera tupana ivi tupuwisi, touna ‘rava iyamonisi koroto ma wavine.’ ");
INSERT INTO bmk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ma nuke itupuwa kubina, na vagheina korokoroto asi mamimau ma maduwamau inane kuyowesi ma kakawasi meiteni ini siyagosi, ");
INSERT INTO bmk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","da tousi sago kava.’ Vagheina tousi iya ruwa ma sago. ");
INSERT INTO bmk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Meimeituwa ivi siyagosi, na iya rava sago ini yamonesi.” ");
INSERT INTO bmk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tousi ivovira meme ku numa, bade Yesu ina touvotaghotagho ivi taravirei weni touna kubina. ");
INSERT INTO bmk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu ikipotesi ma ivavo, “Mike da koroto sago kawana ina basarei ma ta wavine ina ravaghi, na iya iti patutu kawana kurina na imadawara. ");
INSERT INTO bmk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bade nuke, mike da wavine sago kawana ina basarei ma ta koroto ina ravaghi, nani wavinena na iya iti patutu na imadawara. ");
INSERT INTO bmk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Rava ruwamtousi didayoghoyogho irutenisi ipitiyesi Yesu kurina da imana ku tepasi ita terei, ma ina touvotaghotagho rava iyeghasi. ");
INSERT INTO bmk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu weni nuke ikitai na ivi nuwaghisi ma ivavo kurisi, “Didayoghoyogho ko voteresi ina piti kuriku, iya koni ghaiyesi, iyamna Meimeituwa ina Koyagha na kama rava weni didayoghoyoghosi nuke na kubisi. ");
INSERT INTO bmk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sisiya kamowa akikimi, mike da rava sago iya ere nuwabeibeina Meimeituwa ina Koyagha ita vivi vagheinei kama didayoghoyogho ita vivi vagheina na nuke, nani ravana kara iya Meimeituwa ina Koyagha ina runi.” ");
INSERT INTO bmk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma didayoghoyogho ivopewasi ma ku marorona iteresi, ma imana sagosagoweta ku tepasi iterei ma ivi beibeinisi. ");
INSERT INTO bmk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bade, nani maranai Yesu ivomeira ina yawara ivi karei inenai, ma koroto sago ivuru kuriya ma maghinonai kaetupinai isoru ma ivi baghai, “Bada beibeim, avai ana berai da yawasa makemake vaghasina ana veiya?” ");
INSERT INTO bmk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu ivavo kuriya, “Avikubina kuvavo da taku beibeiku? Iya iyai beibeina, Meimeituwa touna kava beibeina. ");
INSERT INTO bmk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Am vi taravira kubina, tam namada Meimeituwa ina vigheiyena ku sakovi: Iya kwi siraghena; Iya kwa madawara; Iya kwa yapi; Iya kwi wavu wapawapa; Iya kwi bedabeda da rava asi purapura kwi tuwakare yei; Am mamai ma am maduwa kwa vo viviresi.” ");
INSERT INTO bmk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma koroto ivavo kuriya, “Bada, meyameyakuwai da karako, weni vigheiyenisi avoteketeke bubuna yavusi.” ");
INSERT INTO bmk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ma Yesu ikita nuwa yuyunei ma ivavo kuriya, “Bera sago kava karakava kwa berai. Kenae ma am purapura tupana yavu kwi gimagimarei ma manena rava keikayokayosi kwa veresi, ma kam maiya Meimeituwa kunumai ina verem. Bade touna kwa berai ina kovi ma kwa piti kwa wagiseku.” ");
INSERT INTO bmk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Touna imoura sasara kubina, maranai nuke iviyanei na maghighina ibero ma ere nuwaboyana inae. ");
INSERT INTO bmk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bade Yesu ikita kwavikwaviviro ma ina touvotaghotagho kurisi ivi sisiya ma ivavo bo, “Ipiripiri sasara da rava moumourisi arui Meimeituwa ina Koyaga Yawasa Kuvouna.” ");
INSERT INTO bmk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Touvotaghotagho iru sakwasakwaresi ma ikeinotanota sasara maranai ina sisiya weni nuke ivi yanei. Bade Yesu ivavo meme kurisi, “Natunatuku, rui Meimeituwa ina Koyagha ku sinena na ibagibagi sasara. ");
INSERT INTO bmk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ipiripiri da ghamoghamo ghamanakina kana wava kamel* ighoma mata bonaghinai ina sonagha, ma ibagibagi sasara da rava moumourina Meimeituwa ina Koyagha Yawasa Kuvouna ina rui.” ");
INSERT INTO bmk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tousi irusakwara sasara ma ivi tupavireyana meyesi, “Mike da nuke, na meni ravana yawasa makemake vaghasina ina pananai?” ");
INSERT INTO bmk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ikitasi ma ivi sisiya, “Iya kovokovoghina da rava ini yawasa meyesi, ma Meimeituwa kovokovoghina ina berai, iyamna Meimeituwa touna kovokovoghina kavakava bera tupana yavu ina berai.” ");
INSERT INTO bmk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bade Pita ivi sisiya Yesu kurina, “Bada, kekitai, taki ikimakava? Taki aki bera tupana yavu kane kuyowesi ma ka wagisem.” ");
INSERT INTO bmk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu ivavo, “Sisiya kamowa akikimi, mike da rava ina numa, varevaresina, novunovuna, ina maduwa, ina mamai, natunatuna bo ina dowa ina nekuyowesi da taku ina wagiseku ma varaku beibeina ini seghani rava kurisi, ");
INSERT INTO bmk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kanamaiya Meimeituwa ina kasi tepatepani weni yawasinai. Touna numa, varevaresina, novunovuna, maduwamau, didayoghoyogho ma dowa ina veiya. Bade rava bera berona ina berai kurina taku varaku beibeina kubina, bade mara muriyai epitipiti, yawasa makemake vaghasina ina pananai. ");
INSERT INTO bmk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma ipesari sasara karako ibada na ina soru taweyana ma ipesari sasara karako isoru taweyana na ini bada.” ");
INSERT INTO bmk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tousi ketaki yai iyawara igheghai ku Jerusalem, ma Yesu ivi nau, maghinosi yai. Ina touvotaghotagho ivi deiyei, ma rava ruwamtousi murinai ipitipiti na iyabumana. Bade Yesu asivi 12 iteina vivirisi, ma ivi karei da ikikisi avai ina tupuwa kurina Jerusalem yai, ");
INSERT INTO bmk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ma ivavo bo, “Ko kitai, karako na touta ta gheghai ku Jerusalem. Nani dobunai rava sago ina make vivira da Koroto Keimatana, ini benabenameku prist babadisi ma touvibeyebeyena Mosese ina vigheiyenai ku imasi ina tereku. Kaku siraghe ini ogatarei ma dam viruwa ku imasi ina tereku. ");
INSERT INTO bmk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Dam viruwa ini giboweku ma ina sovaku. Ina wudiku ma ini siragheniku. Bade mara aroba murinai ana vomeira meme.” ");
INSERT INTO bmk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Iya uwamina murinai Jems ma Jon, Sebedi natunatuna ipiti Yesu kurina ma ivavo bo, “Bada, avai kani bagham kwa berai, taki aki kayowana kwa berai kubiki.” ");
INSERT INTO bmk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma ivitaraviresi, “Ami kayowana vai ana berai kubimi?” ");
INSERT INTO bmk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tousi ikipotei, ivavo bo, “Maranai da am mara ina segha da vikeivavo kubina kwi vagheineki da tamake yavuyavu, kataiyam wai sago ina make ma sago dugem wai da rava takoyaghisi.” ");
INSERT INTO bmk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bade Yesu ivavo kurisi, “Tami iya kota sakovi da avai koi baghei. Kovokovoghimi da ini vavana keyakina anumei na kara konumei bo, kade vagheina da keivowavowa towasamaghina taku ana towei na muriyai kona towei?” ");
INSERT INTO bmk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma ikipotei, “Taki kovokovoghina.” Ma Yesu ivi sisiya, “Taku keyaka amumei na tami konumei, ma ini towasamaghimi kama ini towasamaghiku na nuke. ");
INSERT INTO bmk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bade iya taku aku vibadana da iyai ana vinei da mara murinai meiteni kani bada, make kataiyaku wai ma dukeku wai makena na iya taku aku vibadana. Tousi iyavo Meimeituwa ina vinevine kava kasi wasa.” ");
INSERT INTO bmk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Maranai touvotaghotagho asivi imaruwa ikovi Jems ma Jon asi vi bagha ivi yanei, ivi nuwaghisi kurisi. ");
INSERT INTO bmk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma tupasiyavu Yesu ighoresi ivi siyagosi ma ivi sisiya kurisi ivavo bo, “Tami kosakovi da dam viruwa keikeivavosi rava ivi badebadesi nake ma wike. Ma dam viruwa babadisi rava iberaberasi da ivovo teketekesi. ");
INSERT INTO bmk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bade tami iya kona berai da kama tousi nuke. Mike da iyai sanamiyai ina kayowana da ini bada touna ravana na ini toubigabiga tami sanami yai. ");
INSERT INTO bmk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mike da am kayowana kwi nau na tam kwi yaragagimara rava yavu kurisi. ");
INSERT INTO bmk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bade ketakina sago, taku Koroto Keimatana, iya ata piti da rava ina bigeku ma apiti da rava ana bigesi, ma ana siraghe da rava yavu kubisi kovoghina ana veiya. ");
INSERT INTO bmk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bade Yesu ma ina touvotaghotagho ipiti ku Jeriko meyagina ghamanakina. Maranai Jeriko ikasikasibu kuyowei numaduba ghamanakina iwaghisesi. Koroto sago matapotapotana kana wava Batimeiyasi, Timeiyasi natuna, ketaki ririvinai imakemake ma mane kubina ibenibeni. ");
INSERT INTO bmk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Maranai rava iviyanesi ivivi sisiya da Yesu koto Nasaret epitipiti, ma ivavo rukwatu, “Yesu Devida Natuna keru nuwayakapoweku!” ");
INSERT INTO bmk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Rava damsi iyeghai ivavo bo, “Kawam epota!” Ma bade ponana ghamanakinai irukwatu, “Yesu Devida Natuna, keru nuwayakapoweku!” ");
INSERT INTO bmk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma bade Yesu itu meira ma rava kurisi ivavo bo, “Ko kiya ina piti kuriku.” Vagheina ma iru wore koroto matapotapotana kurina, “Ke vinuwa beibai! Ke vomeiri! Yesu eworeworem.” ");
INSERT INTO bmk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ina rupu nake iru tawayei ma ivi sukapoka imeiri ma inai Yesu kurina. ");
INSERT INTO bmk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ivi taravirei, “Avai ku kayokayowei ana berai kubim?” Ma koroto matapotapotana ivavo bo, “Bada, aku kayowana da ana kita meme.” ");
INSERT INTO bmk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ivavo kuriya, “Ku tumetumeku, kubina ku yawasa, kenae.” Mara sago kava ikita, ma Yesu ketaki yai inenai na iwagisei. ");
INSERT INTO bmk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Maranai Yesu ma ina touvotaghotagho iseghasegha ku Jerusalem, ipiti ku meyagi Betpage ma Beteni Oliv Keyamisi Koyana tetenai. Yesu ina touvotaghotagho ruwa iki tawayesi ivi nau ");
INSERT INTO bmk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma weni nuke ikisi ivavo bo, “Ko nae nani meyagina maghinotai kona rui. Maranai kona segha na donki natuna nigonigorina kona pananai nani dobunai isaghiri. Iya meyana rava ita geru tovoni. Ko votariya ma kona pitiyei. ");
INSERT INTO bmk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mike da rava iyai ina vivi taraviremi, ‘Avikubina ko taritariya?’ Ko kipotei kona vavo bo, ‘Bada ekayokayowei ma iya uwamina ma ini vovirei.’” ");
INSERT INTO bmk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma asi viruwa inae, ku meyagi irui ma donki natuna ikitai, ketaki yai imeimeiri, saghisaghirina numa matamkwetana ririvinai, maranai ivovotariya, ");
INSERT INTO bmk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","rava ruwamtousi ririvinai ivivi meiriyana na ivitaraviresi, ivavo bo, “Avi kubina donki natuna ko taritariya?” ");
INSERT INTO bmk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Vagheina ma rava ikipotesi Yesu ikimakava ikikisi na nuke, ma rava ivi vagheinesi da donki natuna ina veiya. ");
INSERT INTO bmk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Vagheina itariya ma iruteina pitiyei Yesu kurina ma asi rupu ivi votawayena da tepanai ikebani, ma Yesu imake. ");
INSERT INTO bmk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma Yesu donki natuna tepanai igeru ma ketaki yai inenai. Ma rava tupasi yavu asi rupu ivi votawayena ma ketaki yai ikebana ma ruwamtousi na keyama rugurugusi igasi ma ketaki yai ikebana. ");
INSERT INTO bmk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Rava maghinonai inenai ma murinai ipitipiti iyogoyogo ma ikwatukwatu, “Housana! Voepaepa iyai Bada kana wavai epitipiti. ");
INSERT INTO bmk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Voepaepa ita mamai Devida natuna iyai epitipiti ini Keivavo! Housana kunuma ghe numonumonai!” ");
INSERT INTO bmk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu ku Jerusalem irui ma inae ku tempol. Bera tupana ine kitakita bububuna nani dobunai. Namada ivi kuririsi, touna kubina asivi 12 meiteni ivovira meme ku Betani. ");
INSERT INTO bmk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mara itom, Yesu ma ina touvotaghotagho Beteni ikasibu kuyowei ivovovira meme ku Jerusalem, ketaki yai Yesu kam isiraghe. ");
INSERT INTO bmk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uwamai ikita da keyama, kana wava fig, irurugurugu na ikitai, ma ighe ku ririvina ita kita, da ivi yam bo kegha. Ma iya fig kasi mara da iti yam. Maranai ipiti ku ririvina, na ipananai da rugurugu kava. ");
INSERT INTO bmk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma Yesu keyama ikiya, “Iya meyana rava iyamu ina kaniya!” Ma Yesu avai ivavowei na, ina touvotaghotagho ivi yanei. ");
INSERT INTO bmk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Maranai ina touvotaghotagho meiteni ku Jerusalem isegha, Yesu irui tempol ku garina ma rava iyavo ivivi gimagimara, na ivi kasibunisi ma mane vi uneunesi asi kepakepa ivi suviresi ma gabubu ivivi gimagimara ravasi asi makemake meiteni, ");
INSERT INTO bmk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ma ivi gheiyesi da iya rava sago ina purapura ina kavara ruesi ma ina tu yaraga tempol garina sinenai. ");
INSERT INTO bmk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma touna ivivi beyebeyena ivavo kurisi, “Ko sakovi bo kegha, Meimeituwa varanai evavavo, ‘Aku numa na eghoreghorei vi kawavenoveno numana damdam tupasiyavu kubisi’, ma bade, tami ko beraberai kama ‘yapiyapi asi kenakena gavu dobuna’ nuke!” ");
INSERT INTO bmk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nuke ivi sisiya, na prist babadisi ma Mosese ina vigheiyena touvibeyebeyenai iviyanei. Numaduba Yesu ina vibeyebeyena ivi deiyei, touna kubina nani babadisi Yesu iyabumanei, ma tousi keta inegwanegwai da iti siragheni. ");
INSERT INTO bmk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ivivi kuririsi maranai, Yesu ma ina touvotaghotagho Jerusalem ikasibu kuyowei. ");
INSERT INTO bmk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mara itom meme tousi inenai ku Jerusalem ma ketaki yai, fig keyamina ikitai Yesu ikawapasiri na ipoki tepanai da isoru ku kunukuna. ");
INSERT INTO bmk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita Yesu ina sisiya ivi nuwanotenotei ma ikiya bo, “Bada, kekitai! Keyama ku pasiri na ipoki!” ");
INSERT INTO bmk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu ikipotesi ma ivi sisiya kurisi, “Meimeituwa ko tumetumei! ");
INSERT INTO bmk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sisiya keimatana akikimi, mike da rava sago weni koyana ina kiya, ina vavo bo, ‘Ke rukoim ma ku neyagha ke tawayem,’ ma iya nuwa ragharagha gwabinai ma ina tumetume da avai berana ivavowei na ina tupuwa, bade nuke Meimeituwa ina berai kubina. ");
INSERT INTO bmk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Touna kubina akikimi: Bera tupana yavu kubina kwi kawavenoveno ma Meimeituwa kwi baghai, ke tumetumei da namada ku veiya, ma ina berai kubim. ");
INSERT INTO bmk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ma maranai kwa vivi kawavenoveno Meimeituwa kurina, kununa rava avai ibera beroi kurim na ke nota kuputesi, ma bade nuke am Mamai kunumai am bera bero ina nota kuputei.” ");
INSERT INTO bmk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu ma ina touvotaghotagho ku Jerusalem isegha meme, ma maranai touna tempol garina kamonai iyawayawara, prist babadasi ma touvibeyebeyena Mosese ina vigheiyenai ma babada ruwamtousi ipiti kuriya ");
INSERT INTO bmk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ma Yesu ivi taravirei ivavo bo, “Avai vaivainai weni berasi keberaberasi? Iyai weni vaivaina nuke iverem?” ");
INSERT INTO bmk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Bade Yesu ikipotesi ivavo bo, “Vitaravira sago ani taraviremi ma kona kipoteku, na ana kimi avai vaivainai weni berasi aberaberasi. ");
INSERT INTO bmk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ko kiku! Iyai Jon Touvitowasamagha vaivai iverei, da ini towasamagha, Meimeituwa bo rava?” ");
INSERT INTO bmk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tousi ivi tupavireiyana meyesi ma ivavo bo, “Touta iya ta kipote, ‘Meimeituwa’. Yesu kara ina vavo, ‘Nuke na avikubina Jon iya kota tumetumei?’ ");
INSERT INTO bmk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma, iya kovokovoghina da tavavo rava vi vagheina Jon iverei da ini towasamagha. (Rava inotai Jon na Meimeituwa ina kikiverena, touna kubina numaduba iyabumanesi.) ");
INSERT INTO bmk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma tousi Yesu ikipotei, “Iya kata sakovi.” Ma Yesu ivi sisiya kurisi, ivavo bo, “Bade iya ana kimi avai vaivainai weni berasi aberaberasi.” ");
INSERT INTO bmk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bade Yesu meibai ivi sisiya kurisi, “Koroto wain kupurina ivouni, ma gari iyamoni. Touna wain iyamna kana vorovoro wasana iyamoni ma viyavayava numana iyamoni. Bade toukoyagha iveinisi da ina kupura ita noyei, ma inae ku dobu viruwa. ");
INSERT INTO bmk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Maranai yaba kana mara isegha, kupura tuwakarena ina yaraga sago iki tawayei da kana reregha ita veiya. ");
INSERT INTO bmk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma maranai isegha na kupura toukoyaghisi ivotani, igudai ma iki tawayei imana kava ivovira. ");
INSERT INTO bmk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kupura tuwakarena yaraga sago iki tawaye meyei, bade tepapuna iraviya ma ikayo beroi. ");
INSERT INTO bmk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ma bade ina yaraga sago ikitawaye meyei, ma ikasimunui. Ma yaraga ipesari sasara ivi kitawayanesi ma kupura toukoyaghisi bade nuke iberasi, ruwamtousi imunuwisi ma ruwamtousi ivi siraghenisi. ");
INSERT INTO bmk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kupura tuwakarena iya iyai sago ita make terei da ita kitawayei, natuna sago kava nuwanuwana ivei sasarei. Vagheina ma damona, natuna iki tawayei ma ivavo bo, “Tousi natuku ina vivirei.” ");
INSERT INTO bmk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bade tousi ivi sisiya vivira meyesi, “Tuwakare natuna wa ipitiyai, ina budere tou veinina. Ko vomeiri ti siragheni ma kupura touta ti tuwakareyei.” ");
INSERT INTO bmk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Vagheina ma tuwakare natuna ivotatani ma ivi siragheni. Ma tupuwina kupurai itawanakasibuni.” ");
INSERT INTO bmk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu ivi taraviresi ma ivavo bo, “Ami nota avai? Kupura tuwakarena avai ina berai? Ana kimi. Touna ina piti ma toukoyagha ini siraghenisi, ma ina kupura toukoyagha viruwa ku imasi ina terei. ");
INSERT INTO bmk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sisiya kamowa bo, tami Meimeituwa ina buka kosiyavi na ikimakava evavavo, ‘Wakima numa touvowasi ibasarei touna wakimina na karako ibonugwagwara.’ ");
INSERT INTO bmk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Weni berana na Bada iberai, ma touta tavi deiyei.’” ");
INSERT INTO bmk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dam Jiu babadisi isakovi da Yesu ivi meiba na tousi ivivi sisiyesi ma keta inegwanegwai da ita paniya. Ma numaduba iyabumanesi kubina ivoterei ma ine kuyowei. ");
INSERT INTO bmk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muriyai dam Jiu babadisi Parisi* ruwamtousi ma Herod ina dam* ruwamtousi iki tawayesi Yesu kurina da ivivi kai teini da sisiya ita vavo berowei bo kegha. ");
INSERT INTO bmk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ipiti kurina ma ivavo bo, “Bada, ka sakovi da tam vara keimatana kisisiyei. Tam iya kuta veiveiya da rava gheghena bo rava kiki ma ke beraberasi da tousi na sago, ma rava asi pona iya kuta vi viyanei ma Meimeituwa ina keta keimatana ki beyebeyena bubuni. Vagheina bo kegha da touta taks ti maiya Sisa kurina? Ti maiya bo kegha?” ");
INSERT INTO bmk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bade Yesu, asi vi kaiteina ikita bouni ma ivavo kurisi, “Avikubina ko kayokayowei da koni waroku? Dinari sago ko pitiyei ana kitai!” ");
INSERT INTO bmk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma iveiya ipitiyei kurina ma ikisi, “Iyai gubagubana ma kana wava weni mane nai?” Iki potei ivavo bo, “Sisa.” ");
INSERT INTO bmk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bade Yesu ivavo bo, “Meni touna Sisa rapenai na Sisa koverei ma meni touna Meimeituwa rapenai na Meimeituwa ko verei.” Ma tousi ina sisiya ivi deiyei. ");
INSERT INTO bmk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi asi tumetume rava siraghe yai iya ita vo meimeiri meme. Bade ruwamtousi ipiti Yesu kurina ivivi kaiteini, ivi taravirei ivavo bo, ");
INSERT INTO bmk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bada, Mosese igiruma Meimeituwa ina vigheiyenai kubita weni nuke evavavo, mike da koroto ina siraghe ma kawana ina ne kuyowei iya itituwa, bade varesina kwapurina ina ravaghi ma ini tuwa, pipiyisi na ina tuwa sirasiraghena natunatuna. ");
INSERT INTO bmk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Namani tuwanateina asivi meikovi ma kumaneva ruwa. Tutuwaghina wavine iravaghi, iya itituwa ma korotona isiraghe. ");
INSERT INTO bmk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bade murimurina kwapurina iravaghi, iya itituwa ma korotona isiraghe. Ma kana vi aroba nuke ma isiraghe. ");
INSERT INTO bmk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tuwanateina meikovi ma kumaneva ruwa wavinena sago kava iravaghi, iya itituwa ma tupasiyavu isiraghe. Muriyai nani kwapurina, meiteni isiraghe. ");
INSERT INTO bmk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Korokoroto meikovi ma kumaneva ruwa wavinena sago kava iravaghi touna kubina rava siraghe yai ina vo meiri meme maranai, iyai kawana?” ");
INSERT INTO bmk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu ikipote, “Tami Meimeituwa varana ma ina maragata iya kota sakovi, touna kubina ami nota ibero. ");
INSERT INTO bmk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maranai rava siraghe yai ina vo meimeiri meme, korokoroto iya ita tatavine ma weivine iya ita vivi tavinesi ma bade nuke ina make kama Meimeituwa ina aneya kunumai emakemake na nuke. ");
INSERT INTO bmk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma bade Meimeituwa ikimakava rava siraghe yai ina vo meimeirinisi, kade ko siyavi bo kegha Mosese ina bukai igirumi, ikimakava ivavo keyama kiki ikarakarasina maranai? Meimeituwa ivavo bo, “Taku Abraham, Aisak ma Jeikapu asi Meimeituwa.” ");
INSERT INTO bmk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Touna na iya rava sirasiraghesi asi Meimeituwa ma rava yawayawasisi asi Meimeituwa. Touna ibeyeta da Abraham, Aisak ma Jeikapu isiraghe ma Meimeituwa matanai na tousi yawayawasisi. Touna kubina ami nota na ibero tawayena maranai ko vavavo da rava siraghe yai iya ina vo meimeiri!” ");
INSERT INTO bmk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bade touvibeyebeyena sago Mosese ina vigheiyenai ipiti na Yesu ma Sadusis weni nuke ivivi tupavireyana na ivi yanesi. Ma ivi yanei da Yesu ikipote bubunisi, bade ivi taravirei, “Meni vigheiyenina ighe sasara Meimeituwa ina vigheiyenai?” ");
INSERT INTO bmk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ikipote, “Vigheiyena ghe kirakinina na weni nuke: ‘Dam Israel, keviyana! Bada ita Meimeituwa na touna kava Bada. ");
INSERT INTO bmk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ma nuwanuwam tupana, kanumim tupana, am nota tupana ma am rewapana tupana Meimeituwa kwi nuwayuyunei.’ ");
INSERT INTO bmk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma vigheiyena gheghena kana viruwa na weni nuke: ‘Kam gwani kevi nuwayuyunei kama tamani kinuwayuyunem na nuke.’ Weni vigheiyenasi asi viruwa na ighe sasara iya kama ruwamtousi nuke.” ");
INSERT INTO bmk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Vigheiyena touvibeyebeyenina Yesu ivavo kuriya, “Bada, kuvi sisiya bubuna! Sisiya keimatana, ita Meimeituwa na sago kava, ma iya meimeituwa sago ma touna kava. ");
INSERT INTO bmk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma nuwanuwata tupana, ita nota tupana ma ita rewapana tupana Meimeituwa ti nuwayuyunei. Ma kata gwani ti nuwayuyunei kama touta mani tai nuwayuyuneta na nuke. Weni vigheiyenisi ruwa vo teketekesi na irakata kirakai iya kama ghamoghamo ta kapukapuna ma banuwara ta beraberasi Meimeituwa kurina na nuke.” ");
INSERT INTO bmk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu iviyanei da ikipote bubuna sasara, touna kubina ivavo kuriya, “Tam iya kuti uwama Meimeituwa ina koyagha yawasa kuvouna.” Vagheina ma iya rava sago iti ghapa da iti taravira meyei. ");
INSERT INTO bmk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu ivivi beyebeyena tempol garina sinenai ma ivavo bo, “Avikubina touvibeyebeyena Mosese ina vigheiyenai evavavo da Keriso na Keivavo Devida pesina? ");
INSERT INTO bmk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kanuma Vokuwayina Devida ivi beyei na weni nuke igiruma, ‘Meimeituwa ivavo, aku Bada kurina, “Kataiyaku wai ke make ma kam ghaviya ana vo nubasi ma kai gaburim wai ana teresi.’” ");
INSERT INTO bmk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nani giruminai, Devida ivavo da Keriso na ina Bada, bade ikimakava na Keriso na Devida pesina?” Ma numaduba ere nuwa beibeisi ina sisiya ivivi yanei. ");
INSERT INTO bmk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu na rava ivivi beyeyesi ma bera sago ivi beyebeyesi na weni, weni nuke ikisi “Ko kita ruvami da touvibeyebeyena Mosese ina vigheiyenai iya ini nuwa teinimi. Asi kayowana da gara gurinakisi ina kote ma ina yawayawara, ma asi kayowana rava ere vi viranisi ini kaikaiwesi vigimagimara dobusi yai. ");
INSERT INTO bmk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bade asi kayowana makemake beibeisi vi beyebeyena numanai ma debai na keikeivavo kasi wasai ina make kam marasi yai. ");
INSERT INTO bmk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Asi vi kawavenoveno na gurinakisi da rava ini gheghenisi, ma kwapukwapura ikai teinisi ma asi numa eyapiyapisi. Tousi ravasi na mara muriyai Meimeituwa ina kovogha kirakiyesi!” ");
INSERT INTO bmk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu Tempol kana puyo kabomina kana meimeiri nevanevanai imake ma rava ikitakitasi asi puyo ku kaboma itereterei. Rava moumourisi ipesari mane ghamanakisi itoutoura. ");
INSERT INTO bmk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bade kwapura keikayokayona ipiti da ina mane gisigisina ipuyowei, kama toyatoya ruwa kava nuke. ");
INSERT INTO bmk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Vagheina ma ina touvotaghotagho ighoresi ipiti kuriya ma ikisi bo, “Sisiya keimatana akikimi, weni kwapurina keikayokayona ina puyo na rava yavu asi puyo ighe kuyowesi. ");
INSERT INTO bmk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iyamna na weni, nani ravasi moumourisi asi moura nevapaina kava iverena ma asi moura na ghamanakina emakemake, bade nani wavinena ivi keikayokayo sasara ma kegha da mane tupana yavu gwabinai na iverenei, iya mane sago ita make terei da ina kam wei.” ");
INSERT INTO bmk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bade Yesu ma ina touvotaghotagho Tempol ikasikasibu kuyowei, ma ina touvotaghotagho sago ivavo kuriya bo, “Bada, weni vowasi beibeisi ke kitasi, ibeibaighagha! Weni wakimisi ghamanakisi yai ivowasi!” ");
INSERT INTO bmk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu ivavo bo, “Weni vowasi ghamanakisi ko kitasi! Mara muriyai Dam Jiu kasi ghavighaviya ini bero yavusi. Iya wakima sago tepantepanai ina make.” ");
INSERT INTO bmk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bade Yesu ighae Oliv Keyamisi Koyanai imake, ma ikitakita damana ku Tempol. Pita, Jems, Jon ma Anduru, tousi mani duma ma ivi taravirei, ");
INSERT INTO bmk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ke kiki weni berasi tupana yavu mara avai ina tupuwa. Avai ini matakira da weni berasi na ina tupuwa?” ");
INSERT INTO bmk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ivavo bo, “Ko kita ruva da iya rava sago ini bedebedemi ma nuwanuwami ina teina virasi. ");
INSERT INTO bmk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muriyai rava ipesari ina piti kaku wavai. Ma ina vavo bo, ‘Taku Keriso!’ ma rava ipesari ini bedebedesi ma nuwanuwasi ina teina virasi. ");
INSERT INTO bmk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Maranai vighavighaviya varana koni yanei ma ghaviya sisiyisi ipesari sasara koni yanesi, iya kona yabumana. Weni berasi kununa ina tupuwa, bade touna na iya damona. ");
INSERT INTO bmk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Damdam ini ghaviya vivira meyesi, keivavo ma keivavo ini ghaviya vivira meyesi. Ma nukenuke dobu ipesari sasara ina nukesi ma bade gomara. Weni touna na karena kava, maranai kama wavine manamanawina vituwa kubina ini vavanina damina nuke. ");
INSERT INTO bmk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ko kita ruva bubuna meyemi! Kami ghaviya meyagi babadisi ku imasi ina teremi ma bade vibeyebeyena numasi yai ina gudami. Ko tumetumeku touna kubina ina veinimi ma asi babada maghinusi yai ini taraviremi, ma varaku kona kisi. ");
INSERT INTO bmk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kununa aku touvotaghotagho varaku beibeina ini debei damdam yavu kurisi, ma muriyai damona ina segha. ");
INSERT INTO bmk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Ma maranai kami ghaviya ina panimi ma ina vivi taraviremi iya ami nota ina ragharagha da avai koni sisiyei. Iya tamimani ami notai koni sisiya ma Kanuma Vokuwayina kubimi ini sisiya, bade avai Meimeituwa iveremi na nuke kovi sisiya. ");
INSERT INTO bmk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Koroto varesina wosina ghaviya ku imasi ina terei da ini siragheni, ma mamai natuna ina verenei da ini siragheni. Ma pipiya avo meira da asi maduwa mau ma asi mami mau ini ghaviyesi ma ghaviya ku imasi ina teresi da ini siraghenisi. ");
INSERT INTO bmk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tami ko tumetumeku kubina rava tupana yavu ina basaremi. Bade rava iyai nuke ina meiri kikina da ku damona, touna na Meimeituwa ini yawasi.” ");
INSERT INTO bmk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Bade ivavo bo, “Maranai bera bero tomatoma vaghasina bera kasi vivi bero kona kitai meni dobunai iya vagheina da ita make (iyavo weni bukana ko siyasiyavi kobera tovoni da kona sakovi da avai aisisiyei), vagheina rava iyavo dobu Jiudiai, ko kisi ku koya ini vuruwana. ");
INSERT INTO bmk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iyai ina numa vovonai, ko kiya da iya ina soru ina ku numa sinena ina purapura ina ragau, ina vuru yaghina wota inanae. ");
INSERT INTO bmk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bade nuke iyai ina kupurai enoyanoya, ko kiya da iya ina vovira ina rupu ina veiya, ina vuru yaghina wota inanae. ");
INSERT INTO bmk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nani maranai vo kwarakwara ina rakata sasara weivine iyavo manamanawisi ma isusu na ina pananai. ");
INSERT INTO bmk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kovi kawavenoveno Meimeituwa kurina da ami vivuru gavuwana maranai na iya bodu wai. ");
INSERT INTO bmk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vo kwarakwara ina rakata kirakai nani maranai. Maranai Meimeituwa dobu iyamoyamoni na vo kwarakwara iya sago nuke ita tupuwa, ma muriyai na iya nuke ina tupuwa meme. ");
INSERT INTO bmk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bade Bada nani marana ina berai da ina tupo. Mike da iya ini tupoi, rava tupana yavu ina siraghe. Bade ina kayowana da rava ivinesi touna rapenai, na ini yawasisi, touna kubina nani marana ini tupoi. ");
INSERT INTO bmk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Bade Keriso vi bedabedasi ma kikiverena vi bedabedasi kara ina piti ma matakira ma aniba ina berasi da rava ini bedebedesi ma nuwanuwasi ina teina virasi. Ina bera tovoni da Meimeituwa ina vinevine ravasi meiteni ini bedebedesi ma nuwanuwasi ina teina virasi, kade kovokovoghina ina berai. Touna kubina mike da rava ina piti ma ina vavo kurimi, ‘Ko kita, Keriso na weni!’ bo ‘Nokoni!’, nani sisiyina iya kona tumetumei. ");
INSERT INTO bmk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ko kita ruva bubuna! Weni sisiyisi karako akikimi da avai ina tuputupuwa na kovi yapaka. ");
INSERT INTO bmk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bade vo kwarakwara ghamanakina marana ina kovi, ‘bera maragata kirakinisi marai na ina nukesi ma yabodiri ini nubakutuvi ma siyamtapa meiteni iya ina neira. ");
INSERT INTO bmk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gwamegwame marai ina ririgha.’ ");
INSERT INTO bmk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Bade rava, Koroto Keimatana ina kitai ina pitipiti ghuvai ina maragata tupana ma boruma meteni. ");
INSERT INTO bmk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bade ina aneya ina kitawayesi inanae dobu tupana yavu, namanaki da dobu ivi uwama tawayena ina rava vinevinesi ini ruriyesi. ");
INSERT INTO bmk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kovi nuwanotanota ikimakava keyama fig enumonumoi ma touna notana ko veiya. Maranai ragharaghana emadimadighi ma enumonumoi, bade ko sakovi da keinumo kana mara eseghasegha. ");
INSERT INTO bmk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ketakina sago, maranai kona kitai weni berasi ina tuputupuwa, ko sakovi da Koroto Keimatana eseghasegha. ");
INSERT INTO bmk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sisiya keimatana akikimi weni berasi kununa ina tupuwa, ma weni kimtana emakemake na ruwamtousi ina kitai ma muriyai ina siraghe. ");
INSERT INTO bmk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mara ma dobu ina kovi ma ponaku na iya ina kovi. ");
INSERT INTO bmk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Iya rava sago ita sakovi mara ma madegha avai ana vovira. Aneya kunumai iya ita sakovi, Natuna iya ita sakovi ma Mamai kava isakovi. ");
INSERT INTO bmk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Iya kota sakovi da marana avai, touna kubina kovi yavayava ma kovi yapaka! ");
INSERT INTO bmk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Touna na kama maranai koroto ina numa ina ne kuyowei ku dobu uwama vi yopeyope kubina. Ina bera tupana yavu ina yaraga ku imasi iterei ma asi noya sagosagoweta iveresi. Bade matamkweta toukoyaghina ikiya da ina kita yavayava. ");
INSERT INTO bmk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ketakina sago, ko kita yavayava iya kota sakovi mara avai numa badana ina vovira kubina. Mike da kuririsi yai, bo didibara pounai, bo kokorereko ina raraviya, bo yabodiri ina gheghe tawayei. ");
INSERT INTO bmk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kovi yapaka da iya ina piti kenakenami ma ini ru sakwaremi. ");
INSERT INTO bmk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Weni sisiyina akikimi, na rava yavu kurisi avavavo, da kovi yavayava!” ");
INSERT INTO bmk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mara ruwa kava emakemake da kam ruwa ghamanakisi ita berai, Sovona Voura* ma Parawa Ist Kegha*. Prist babadisi ma touvibeyebeyena Mosese ina vigheiyenai keta inegwanegwai da gavugavunai Yesu ita paniya ma iti siragheni. ");
INSERT INTO bmk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ivavo bo, “Iya kam maranai ta berai, memara da rava ina kayaya.” ");
INSERT INTO bmk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu Beteni yai Saimon ina numai, iyai kununa lepera iveiya. Ikamkam ma wavine, alabasta deudeuna iveiya ipitiyei, sinenai monagha ghabughabuna nad yai iyamoni, maiyana irakata kirakai. Deudeu kamyona ibogai ma Yesu ku tepapuna isuwaghi. ");
INSERT INTO bmk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rava ruwamtousi na ivi nuwaghisi ma ivi ki daguwana, “Avikubina monagha ghabughabuna ivi rekwei? ");
INSERT INTO bmk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iti gimagimarei na mane ghamanakina ita pananai ma manena ita verenei rava keikayokayosi kurisi.” Ma rava wavinena iyeghai. ");
INSERT INTO bmk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma, Yesu ivavo kurisi, “Ko kita kuyowei! Avikubina koi kayokayoi? Bera beibeina kuriku iberai. ");
INSERT INTO bmk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Rava keikayokayosi na tami meiteni ko makemake yavuyavu mara patapatana ma mara avai ami kayowanai na kona vowagusi, ma taku na iya meiteni mara patapatana kata makemake yavuyavu. ");
INSERT INTO bmk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Avai inotanotai ita berai, na iberai; monagha ghabughabuna ku ininiku isuwaghi na ivo kavikaviyeku kaku karawaga kubina. ");
INSERT INTO bmk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sisiya keimatana akikimi, rava yavu dobu tupana varaku beibeina ina vivi yanei, na weni wavinena avai kubiku iberai na sisiya kutukutuna rava ini yanei. Rava weni wavinena ina bera ina notai.” ");
INSERT INTO bmk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Touna murinai Judas Iskariot, touvotaghotagho kasi vi 12, inae prist babadisi kurisi ikisi da ikimakava ku imasi ina terei. ");
INSERT INTO bmk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nuke ivi yanei maranai na ivi nuwa beibai sasara ma ivavo kuriya, “Mane kana verem.” Ma ina gavogavo inegwanegwai da ku imasi ita terei. ");
INSERT INTO bmk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Parawa Ist Kegha* Kamna marana isegha, touna maranai sipu metemetewisi emunumunuwa Sovona Voura* kamna kubina, touvotaghotagho Yesu ivi tarakasiyanei, “Am kayowana meni ku dobuna kana nae da Sovona Voura kamna kana vo kavikaviyei kubim?” ");
INSERT INTO bmk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ina touvotaghotagho ruwa iki tawayesi, ma ikisi bo, “Ko nae ku Jerusalem ma koroto yokowa kibubuna ghamanakina ikavari ma enenae na kona kitai. Kone yavuyavu, ");
INSERT INTO bmk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ma, ma ina nenerui na ko rui, ma numa tuwakarena kurina kovi sisiya, “Bada ivavo, ‘Meni papayaraghinai aku touvotaghotagho meiteni Sovona Voura* vavina kana kaniya?’” ");
INSERT INTO bmk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bade papayaragha ghamanakina ini beyemi tepanai, vovo kavikaviyanina, ma makemake wasana meiteni, nani dobunai bera tupana yavu kona vo kavikaviyana kubita.” ");
INSERT INTO bmk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ma touvotaghotagho ivo meira, inae ku Jerusalem, avai ikikisi na bera tupana yavu nuke ipananai, ma Sovona Voura* kamna vavina ivo kavikaviyei. ");
INSERT INTO bmk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ivivi kuririsi maranai, ina touvotaghotagho asivi 12 meiteni ipiti. ");
INSERT INTO bmk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ikamkam ma Yesu ivavo bo, “Sisiya keimatana akikimi da sanamiyai sago ini benabenameku — ravana meiteni takamkam yavuyavu.” ");
INSERT INTO bmk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tupasi yavu ivi nuwaboya kirakai ma sagosagoweta ivi karei da ivivi taravirei, “Iyai? Iya taku bo?” ");
INSERT INTO bmk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ikipotesi, “Ami vi 12, parawa ku kaboma ta tupatupa kutuva yavuyavu, sanami yai sago na ini benabenameku. ");
INSERT INTO bmk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Taku Koroto Keimatana kubiku, ina tupuwa na kununa kikiverena igiruma na nuke. Bade rava iyai ina berai da ina tupuwa ma ini benabenameku, wayakapo, touna na ku berona ghamanakina ina rui. Ibeibai sasara da ina maduwa iya meyana itituwei.” ");
INSERT INTO bmk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ikamkam ma Yesu parawa iveiya, Meimeituwa ivi kaikaiwei, ivo gimai, ma ina touvotaghotagho iveresi. Ivavo bo, “Ko veiya, touna tupuwiku.” ");
INSERT INTO bmk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bade wain keyakina iveiya, Meimeituwa ivi kaikaiwei, ma iveresi, ma sagosagoweta iumei. ");
INSERT INTO bmk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ivavo, “Touna taraku. Taraku ina suwagha rava ipesari sasara kubisi, tara na Meimeituwa ina kinuwaghana tousi meiteni ini bagibagiya. ");
INSERT INTO bmk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sisiya keimatana akikimi, iya meyana weni wain na anuma meyei da maranai Meimeituwa ina koyagha yawasa ku vouna na wain vouna anumai. ");
INSERT INTO bmk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yevo sago iraviya murinai na Jerusalem ikasibu kuyowei inae Oliv Keyamisi ku Koyana. ");
INSERT INTO bmk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ivavo kurisi, “Meimeituwa varana buka sinenai weni nuke evavavo: ‘Sipu toukoyaghina ani siragheni, ma sipu ini vuru seiseirana.’ Nuke tupamiyavu kona vuru kuyoweku, ");
INSERT INTO bmk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","bade Meimeituwa ina vo meimeira meyeku ku yawasa, na ani nau ku Galili.” ");
INSERT INTO bmk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bade Pita ivavo kuriya, “Namanaki da tousi tupasi yavu ina ne kuyowem, ma iya taku!” ");
INSERT INTO bmk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ivavo kuriya, “Sisiya keimatana akikim, weni didibarinai muriyai da kokorereko mara ruwa ina garara, tam kara mara aroba kwa vavo, ‘Avi pupuwei.’” ");
INSERT INTO bmk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bade Pita ivavavo tupetupeyana, “Namanaki da ta siraghe yavuyavu, iya meyana ana vavo, ‘Avi pupuwei!’”Ma tupasi yavu sisiyina sago ivavavo wei. ");
INSERT INTO bmk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tousi ipiti ku dobu kana wava Getsemani, ma Yesu ivi sisiya ina touvotaghotagho kurisi, “Wa ko make ma ana nae ani kawavenoveno.” ");
INSERT INTO bmk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Vagheina ma Pita, Jems ma Jon, ikasi veinisi ma inae, ma nuwanuwana ipukana potei, ");
INSERT INTO bmk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ma ivavo kurisi, “Avi nuwaboya sasara ma damiku na berokikina kava ini siragheniku. Wa ko make ma ko vi yavayava.” ");
INSERT INTO bmk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ine riya berokina ma, ku dowa itawayei ma ivivi kawavenoveno da kade kovokovoghina keivowavowa ita nevourei. ");
INSERT INTO bmk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ivavo, “Mamai, Aku Mamai, kovokovoghina bera tupana yavu kwa berai, weni keivowavowana keyakina kevei tawayei ma iya anumei, ma iya taku aku kayowanai ma tam am kayowanai.” ");
INSERT INTO bmk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bade ivovira meme ma ina touvotaghotagho asi vi aroba ipananasi ikenakena. Pita kurina ivavo, “Saimon, tam ke kenakena bo? Kade vagheina bo kegha da kota mae guriguri?” ");
INSERT INTO bmk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma ivavo kurisi, “Kanumimi na darudaru da ina kayowana kota berai, ma tupuwimi ina maragata iya kovokovoghina da kona berai. Bade kovi yavayava ma kovi kawavenoveno da ruweyara kona meira potesi.” ");
INSERT INTO bmk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ine meme ma ivivi kawavenoveno, sisiyina sago kava ivavavowei. ");
INSERT INTO bmk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bade ivovira meme ma ikitasi da ikenakena. Iya kovokovoghina da ita kita uwara. Ma ivi pupu da avai ita kipotei. ");
INSERT INTO bmk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Inae, ma mara kana vi aroba ivovira meme ma ivi sisiya kurisi, “Tami karakava ko kenakena ma iyami ko roverovei? Vagheina! Marana isegha! Ko kita, Koroto Keimatana bera bero ravasi ku imasi etereterei. ");
INSERT INTO bmk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kovo meiri, ma tanae. Ko kita, kaku vi benabenama ravana na isegha!” ");
INSERT INTO bmk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Karakava ivivi sisiya ma Judas, kasi vi 12, isegha. Numaduba meiteni ipiti yavuyavu ere wudisi ma ere serisi. Prist babadisi, touvibeyebeyena Mosese ina vigheiyenai, ma Dam Jiu babadisi, iki tawayesi inae. ");
INSERT INTO bmk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ine nae ma touvibenabenama ikisi da ikimakava ini matakiresi. Ivavo kurisi, “Koroto ana yususuri na, korotona touna. Ko votani, ko paniya ma ko ruteina neyei.” ");
INSERT INTO bmk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas isegha ma mara sago kava ine kuriya ma ivavo, “Bada!” ma ivi iyususuri. ");
INSERT INTO bmk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Vagheina ma ivotani ma ivokikini. ");
INSERT INTO bmk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Rava sago na imeimeiri na kepata iteina yavui ma itatara da Prist Gheghena ina yaraga sago teinina ikasiyaraghi. ");
INSERT INTO bmk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Yesu ikisi, “Marana nununai taku na tami meiteni Tempol garina sinenai rava agiugiunisi! Avikubina nani dobunai iya kota votaniku? Taku na kama yapiyapi, na ere kapiyimi ko piti kona votaniku, bo? Bade weni berana na sisiya kikiverena igirumi na etuputupuwa.” ");
INSERT INTO bmk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Vagheina ma ina touvotaghotagho tupasi yavu ine kuyowei ma ivi vuruwana. ");
INSERT INTO bmk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Koroto yaragina garai ikasi rupui ma Yesu iwagiwaghisei, ma ravasi ibera tovoni da ita votani, ");
INSERT INTO bmk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ma kana gara kava ivotani ma iyamkovekovena ivokavari. ");
INSERT INTO bmk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Numaduba Yesu ikasi veiya inae Prist Gheghena ina ku numa, bade prist babadisi, Dam Jiu babadisi ma Mosese ina vigheiyena touvibeyebeyena tupasi yavu nake ivi ruriyesi. ");
INSERT INTO bmk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita uwamai itu kamota inae da Prist Gheghena ina numa ku garina irui. Na, inemake touviyavayava ruwamtousi meiteni, keyamai ivivi muya. ");
INSERT INTO bmk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Prist babadisi ma Sanhidiren* tupasi yavu ibera tovoni avai vi wavuna Yesu ku tepana ita terei da iti siragheni, bade iya avai ita pananai. ");
INSERT INTO bmk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Matamata vi bedabedasi ipesari sasara Yesu kurina itawayei, ma asi sisiya tupana yavu na bogeibogei. ");
INSERT INTO bmk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Rava ruwamtousi ivomeiri sisiya vi bedabedasi itawayei kurina. ");
INSERT INTO bmk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Tousi ivavo, “Kaviyanei weni nuke ivavo bo, ‘Weni Tempol na rava imasi yai iyamoni, na ani beroi, ma mara aroba murinai sago vouna ana vowai, ma iya rava imasiyai ina yamoni.’” ");
INSERT INTO bmk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bade weni ravasi meiteni asi sisiya na bogeibogei yeta. ");
INSERT INTO bmk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Prist Gheghena maghinosi yai imeira ma Yesu ivi taravirei, “Weni vi wavuna itawayei kurim, avikubina iya kuta kipote?” ");
INSERT INTO bmk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bade Yesu ivi yasami ma iya avai ita vavowei. Prist Gheghena ivi taravire meyei, “Tam Keriso bo? Meimeituwa ka Vovo epaipai na Natuna bo?” ");
INSERT INTO bmk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ivavo, “Taku touna, ma kona kitaku, ‘Koroto Keimatana, Meimeituwa Maragata Kirakinina kataiyanai ana makemake ma ghuvanai ana vovovira.’” ");
INSERT INTO bmk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Prist Gheghena nuwanuwana ighisi sasare kana gara iteinasikai ma ivavo bo, “Matamata pesara iya kata kayokayowana meyei! ");
INSERT INTO bmk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Meimeituwa ivivi gibowei na ko viyanei bo? Ami nota avai?” Tupasi yavu ivavo, “Touna vigheiyena igasiya kubina ina siraghe.” ");
INSERT INTO bmk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bade ruwamtousi Yesu isovai, ma matana garai isaghira gavugavui ma iraviya. Ma ivi taravirei, “Mike da tam na Meimeituwa ina Kikiverena, ke kiki iyai iravim!” Ma touviyavayava iru nevanevai. ");
INSERT INTO bmk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita karakava gaburinai, gari sinenai, maranai Prist Gheghena ina yaraga wavinena iyawara ipiti. ");
INSERT INTO bmk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita ikitai ivivi muya, ma maninina ikita tupei ma ikiya bo, “Tam sago, Yesu koto Nasaret meiteni.” ");
INSERT INTO bmk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma ivavo da ivi pupuwei. Iki potei, “Iya ata sakovi da avai ki sisiyei,” ma ine kasibau ku ketamatana. Nani maranai kokorereko igarara. ");
INSERT INTO bmk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yaraga wavinena nani dobunai ikita meyei ma ivavo meme rava ivivi meiri yana kurisi, “Ravana sago weni touna meiteni!” ");
INSERT INTO bmk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bade Pita ivavo meme da ivi pupuwei. Iya uwamina murinai rava na ivivi meiri yana na Pita iki meyei, “Vagheina tam na sago, tam meiteni na koto Galili.” ");
INSERT INTO bmk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma, ivavo bo, “Tepa vovomi yai avavavo da sisiya kamowa akikimi! Mike da kegha na Meimeituwa ina kovoghiku! Koroto tami koi sisiyei na iya ata sakovi!” ");
INSERT INTO bmk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mara sago kava kokorereko mara vi ruwina igarara, ma Pita ina nota ivo vira da ikimakava Yesu ivi sisiya kurina, “Muriyai da kokorereko mara ruwa ina garara, mara aroba kwa vavo da kuvi pupuweku.” Nuwanuwana itamoguda ma itou. ");
INSERT INTO bmk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Boiboighi nubanubanai prist babadisi, Dam Jiu babadisi, touvibeyebeyena Mosese ina vigheiyenai, ma Sanhedrien tupana ivi boru, ivi vagheina da avai ita berai Yesu kurina. Imana ipatumi ma ikasi veiya ineyei Pailat kurina. ");
INSERT INTO bmk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat ivi taravirei, “Tam na Dam Jiu Keivavona bo?” Ma Yesu ikipotei ivavo bo, “Vagheina kuvavo.” ");
INSERT INTO bmk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Prist babadisi vi wavuwavu ipesari sasara Yesu ivivi wavui, ");
INSERT INTO bmk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","touna kubina Pailat ivi taravira meyei, “Kade kwa kipotesi bo kegha? Asi vi wavuwavu ku viyanei!” ");
INSERT INTO bmk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bade nuke iya sisiya sago ita vavo meyei ma Pailat ivi deiyei. ");
INSERT INTO bmk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sovona Voura kamna nununai, maranai Pailat ina bera nuke imakemake, da panipani sago iyai rava ivivi bagheiya na ivovo tariya. ");
INSERT INTO bmk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nani koroto kana wava Barabas dibura numanai korokoroto ruwamtousi meiteni, rava ivi siraghenisi, maranai Rom gabemanina meiteni ivivi ghaviya, na ipanisi. ");
INSERT INTO bmk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Maranai numaduba ivi siyagosi, ma ivi karei da Pailat ini baghai, ikimakava marana nununai ivivi nuwa beibeinisi na nuke. ");
INSERT INTO bmk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pailat isakova kirakiyei da prist babadisi Yesu inuwakapiyei kubina ivo riyei ku imana. Vagheina ma numaduba ivi taraviresi, “Ami kayowana kubimi da Dam Jiu Keivavona ana tariya?” ");
INSERT INTO bmk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bade prist babadisi numaduba isunasi da iti baghai, epaiyana, na Pailat Barabas ina tariya kubisi. ");
INSERT INTO bmk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat numaduba ivi taravira meyesi, “Bade avai, ko kayokayoweku da ravana sago ko woreworei Dam Jiu Keivavona kurina ana berai?” ");
INSERT INTO bmk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iru kwatu potei, “Ke tututani!” ");
INSERT INTO bmk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma Pailat ivi taraviresi, “Avai berana berona iberai?” Iru kwatukwatu kirakai ponasi keidamonai, “Ke tututani!” ");
INSERT INTO bmk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat ikayowei da numaduba iti nuwabeibeinisi, touna kubina Barabas itariya kubisi. Touvighavighaviya ikisi da Yesu ita wudiya ma ita ru teinaneyei da ita tututani. ");
INSERT INTO bmk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Touvighavighaviya Yesu iruteina ruwei Pailat ina numa ku garina, ma touvighavighaviya asi rava tupasi yavu iworesi da ivi siyagosi. ");
INSERT INTO bmk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gara yebara dumadumana Yesu ivi kotei ma vadara keyama raghana tonatonanai ikou pipini, ma ku tepapuna ivo tupei. ");
INSERT INTO bmk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma ivi karei da ivivi namei, “Enosaire! Dam Jiu asi Keivavo!” ");
INSERT INTO bmk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wudi yai tepapuna iraraviya ma isovasovai. Maghinonai kaitupisi yai isorusoru ma irurudunei kama keivavo nuke, ma iberai da ivivi inimayamayai. ");
INSERT INTO bmk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Maranai ivi namei ikovi, gara yebara dumadumana ivo tawayei ma kana gara wosina ivi kotei. Ma iruteina kasibuwei da ita tututani kubina. ");
INSERT INTO bmk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Inenae ma ketaki yai koroto kana wava Saimon, meyagi yoghoyogho wai, irurui ku meyagi ghamanakina na inepotei, ma touvighavighaviya idarui da Yesu kana korosi ita kavari. (Saimon na koto Sairini, Aleksanda ma Rufas asi mamai.) ");
INSERT INTO bmk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesu iruteina neyei ku dobu sago eworeworei Golgata, (iyamna na “Teuteu dobuna.”) ");
INSERT INTO bmk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nani dobunai wain ma me itupavirai ini vavana bunamina ma ibera tovoni da ita verei da itumai, ma umana ibasarei. ");
INSERT INTO bmk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nani dobunai itututani. Ma kana gara, ituparereghi, ma dais ivi rekwei da ita kitai da iyai mike garana ita veiya. ");
INSERT INTO bmk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Boiboghi kana madeghapu wai na itututani. ");
INSERT INTO bmk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Giruma vi wavu ki sakovina Yesu vovonai itutui kana korosi tepanai na ivavo, “Dam Jiu Keivavo.” ");
INSERT INTO bmk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Yapiyapi ravasi asi viruwa kasi korosi yai itututanisi Yesu meiteni, sago kataiyanai ma sago dugenai. ");
INSERT INTO bmk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Rava ine nae ma itatapai, ivivi kunu weiweina ma ivivi namei, “Aa! Kuvavo da tempol kuta rikai ma mara aroba sinenai kuta vowa meyei! ");
INSERT INTO bmk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Karaweni na korosi yai ke soru ma kwi yawasa meyem!” ");
INSERT INTO bmk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma bade nuke prist babadisi ma touvibeyebeyena Mosese ina vigheiyenai Yesu ivivi namei, ma ivivi sisiya vivirana, “Rava ruwamtousi ivi yawasisi ma iya kovokovoghina ini yawasa meyei! ");
INSERT INTO bmk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ivavo da touna Keriso, Meimeituwa ina vinevine Touviyawasa, Israel asi Keivavo, karaweni korosi yai ina soru, ta kitai ma ta tumetumei!” Ma asi viruwa Yesu nevanevanai itututanisi na meiteni ivivi varaberowanei. ");
INSERT INTO bmk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Madeghapu wai dobu tupana nubakutuva iruputani, inae da yabodiri itavira. ");
INSERT INTO bmk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yabodiri itatavira ma Yesu igarara rukwatu ponana ghamanakinai, “Eloi, Eloi, lema sabatani?” Iyamna na, “Aku Meimeituwa, Aku Meimeituwa, avikubina ku ne kuyoweku?” ");
INSERT INTO bmk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Rava ruwamtousi na ivivi meimeiriyana ma igayogayo na ivi yanei ma ivi pupuwei kubina, ivavo bo, “Koviyana, Elaija eworeworei!” ");
INSERT INTO bmk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ravasi sago ivuru ma purapura ponuponuna iveiya ku wain damidamisina itupakutuvi ma siu damonai itupe susuri. Ma ivopaini Yesu ku mutu kwapirina ma ivavo, “Ko koyaghi mede ta kitai Elaija epitipiti korosi yai ina teresoru wei!” ");
INSERT INTO bmk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu ponana ghamanakinai igarara ma isiraghe. ");
INSERT INTO bmk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gara nabanabana tempol sinenai irororoke, wasa vokuwaya kirakinina ipapayaraghi, na itamosika tepanai da isoru ku gaburina. ");
INSERT INTO bmk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Touvighavighaviya badana korosi maghinonai imeimeiri na Yesu ikimakava isiraghe na ikitai ma ivavo bo, “Weni korotona na vagheina Meimeituwa natuna!” ");
INSERT INTO bmk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Weivine ruwamtousi na nani, uwamai imeiri ma ikitakita. Sanasiyai na Meri Magadalin, Meri, Jems kiki ma Joses asi maduwa, ma Salome. ");
INSERT INTO bmk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Maranai Yesu Galili yai, weni weivinesi iwagiwagisei ma ivo vowagui. Nani dobunai na bade weivine ipesari sasara iyavo ipiti yavuyavu ku Jerusalem. ");
INSERT INTO bmk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ivivi kuririsi na tura kayokayowana marana (touna marana na Sabati maghinonai.) Josepa koto Arimatiya isegha. Touna Sanhedrien vovo viviranina sago ivivi koyakoyagha Meimeituwa ina Koyagha ipitipiti kubina. Vagheina ma ere maghitepatorana inerui Pailat kurina ma ivi baghai Yesu tupuwina kubina. ");
INSERT INTO bmk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat irusakwara, maranai ivi yanei da Yesu namada isiraghe. Touvighavighaviya badana ighorei ipiti ma ivi taravirei mike da namadani kava isiraghe, touvighavighaviya badana ivi segha da isiraghe. ");
INSERT INTO bmk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Vagheina ma Pailat Josepa ivi vagheinei da Yesu tupuwina ina veiya. ");
INSERT INTO bmk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josepa gara ghavoghavorina kavakavana ma gurinakina igimari, tupuwina itere soruwei, garai igerei ma ku guba itere runi. Wakima bagibaginai ibouni ma ipapai. Muriyai wakima ghamanakina benabenana ma dubidubina itabiri da guba kana nenerui ikasi potai. ");
INSERT INTO bmk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Magadalin ma Meri, Josepa ina maduwa, ikitai Yesu tupuwina ma iterei. ");
INSERT INTO bmk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabati ikovi ma murinai, Meri Magadalin, Meri Jems ina maduwa ma Salome bunama ghabughabusi igimara da Yesu tupuwina iti monaghi. ");
INSERT INTO bmk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande boiboghi nubanuba nai muriyai da yabodiri ita ghetawa yei, inae ku guba. ");
INSERT INTO bmk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ine nae ketaki yai ma tousimani ivivi kidaguwana, “Iyai guba kana nenerui wakimina ina tabira tawayena vereta?” ");
INSERT INTO bmk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bade itapae ita kita da wakima ghamanakina guba kana neneru wai, namada itabira tawayei. ");
INSERT INTO bmk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vagheina ma ku guba inerui, ma koroto yaraga yoghoyoghona ku kataiya imakemake na ikitai, gara ghavoghavorina ikotei. Ma nuwanuwasi ikara yaguri, ");
INSERT INTO bmk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ma ivavo kurisi “Nuwanuwami iya ina karayaguri! Asakovi Yesu koto Nasaret ko negwanegwai, itututani na touna iya weni — ivomeiri meme! Ma iterei na wasana weni, ko kitai. ");
INSERT INTO bmk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Karaweni ko nae ma weni varana ina touvotaghotagho kona ki veresi, ma Pita meiteni, ‘Touna ini nau ku Galili, ma nani dobunai kona kitai, kununa ikikimi na nuke.’” ");
INSERT INTO bmk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Vagheina ma ere yabumanisi ma ere kirorosi ine kasibau ma guba ivuru kuyowei. Ma, iyabumana kubina iya rava sago ita kiya avai koroto yaragina ikikisi na nuke. ");
INSERT INTO bmk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande boiboghinai Yesu siraghe yai ivo meiri murinai, iruseghana yaghina Meri Magadalin kurina. (Kununa kanuma berosi asi vi meikovi ma kumaneva ruwa gwabinai ivi kasibunisi.) ");
INSERT INTO bmk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Avai ikitai na inae ma ina dam sausau yawayawara yavuyavu na ivi seghesi. Tousi na imogumogu ma iruru matadoga. ");
INSERT INTO bmk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma maranai Meri ikisi, “Yesu siraghe yai ivo meiri meme, akitai.” Ina sisiya iya ita tumetumei. ");
INSERT INTO bmk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Weni berana murinai, Yesu iru seghana touvotaghotagho asi viruwa kurisi na kana kita bogai, maranai iyawara ku meyagi yoghoyogho ikasikasibau. ");
INSERT INTO bmk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Avai ikitai na ivovira asi rava ivi seghesi, bade asi sisiya iya ita tumetumei. ");
INSERT INTO bmk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma touna murinai, asi vi 11 ikamkam maranai ma Yesu iru seghana. Ivo meira kurisi, asi nota soruwana ma asi nuwa bagibagi kubina, “Mike da rava namada ikitaku ma ivi seghemi da siraghe yai avomeira meme, avikubina asi sisiya iya kota tumetumei?” ");
INSERT INTO bmk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma ikisi bo, “Ko kasibau kona nae dobu tupana yavu ma varaku beibeina kona dimei rava yavu kurisi. ");
INSERT INTO bmk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma rava iyai ina tumetumeku ma ina towasamagha na ina yawasa, ma rava iyai iya ina tumetumeku na kovoghina ina veiya. ");
INSERT INTO bmk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Rava itumetumeku na aniba maragata kirakinisi ina berasi, kanuma berosi kaku wavai rava gwabisiyai ini kasibunisi ma pona viruwai ini sisiya. ");
INSERT INTO bmk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mike da mota ina veiya, bo gegura berosi inumai na iya ina siraghe. Imasi rava gubagubagisi ku tepasi ina terei na ini damisi ma ina yawasa.” ");
INSERT INTO bmk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bada Yesu ivi sisiya kurisi ikovi murinai, na Meimeituwa iveiya ighae ku kunuma ma kataiyanai imake. ");
INSERT INTO bmk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Vagheina ma touvotaghotagho ikasibau inae dobu yavu sinesi yai iruguguya rava yavu kurisi, ma Bada sanasi yai inoya yavuyavu, ma ina maragatai iki nuwaghanisi na vagheina nuke iruseghana asi ruguguyai ma aniba berasi iberaberasi matakirasi na rava ivi matamatei. ");
ALTER TABLE bmk_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
