﻿USE sofia;
DROP TABLE IF EXISTS sofia.bmh_vpl;
CREATE TABLE bmh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bmh_vpl WRITE;
INSERT INTO bmh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","E Yesus Kristus gonugau asagul bagegul goagal wanimag, go Yesus go Devit nugau ug, go han Abraham nugau ug. ");
INSERT INTO bmh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6","Abraham go agal memeag eiman betei Devit gumaraneun du, goagal wanimag sikut e wai memen, dareu: go Abraham, Abraham nugau nag Aisak, Aisak nugau nag Zekop, Zekop nugau nag Zuda, gonugau amagul abai, Zuda nugau nag Peres, go Sera dual goagal anaiag Tamar, Peres nugau nag Hesron, Hesron nugau nag Ram, Ram nugau nag Aminadap, Aminadap nugau nag Nason, Nason nugau nag Salmon, Salmon nugau nag Boas, gonugau anag Rahap, Boas nugau nag Obet, gonugau anag Rut, Obet nugau nag Zesi, Zesi nugau nag, gumaraneun du King Devit. ");
INSERT INTO bmh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Devit dareun ziwas ebu, Israel duailel Babilon uzan hiacaranem imarai wanemen, go asagul bagegul goagal wanimag: go Devit, Devit nugau nag Solomon, go Uria nugau wau nugau nag, Solomon nugau nag Rehoboam, Rehoboam nugau nag Abia, Abia nugau nag Asa, Asa nugau nag Zehosapat, Zehosapat nugau nag Zehoram, Zehoram nugau nag Usia, Usia nugau nag Zotam, Zotam nugau nag Ahas, Ahas nugau nag Hesekia, Hesekia nugau nag Manase, Manase nugau nag Emon, Emon nugau nag Zosaia, Zosaia nugau nag Zehoiakin, gonugau amagul abai. ");
INSERT INTO bmh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Babilon uzan Israel duailel betei daremen ziwas ebu, betei Yesus usaleun ziwas ebu, e asagul bagegul goagal wanimag: go Zehoiakin, Zehoiakin nugau nag Sealtiel, Sealtiel nugau nag Serubabel, Serubabel nugau nag Abiut, Abiut nugau nag Eliakim, Eliakim nugau nag Asor, Asor nugau nag Sadok, Sadok nugau nag Akim, Akim nugau nag Eliut, Eliut nugau nag Eleasar, Eleasar nugau nag Matan, Matan nugau nag Zekop, Zekop nugau nag Zosep, go gonugau wau Maria, go Yesus nugau anag. Yesus go Kristus. Wanib go bigeg ‘Uwait nug palautoroun, koli imaigabun du’. ");
INSERT INTO bmh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gonun, go asagul bagegul 14 goagal ug eiman ag Abraham daneun ziwas eiman, zoizoi Devit dareun ziwas ebu daremen. Asagul bagegul ipal ag 14 goagal ug eiman, Devit dareun ziwas eiman zoizoi Babilon uzan hiacaranem daremen ebu daremen. Zoizoi, asagul bagegul 14 goagal ug eiman hiacaranem daremen eiman, zoizoi Yesus Kristus usaleun ziwas ebu daremen. ");
INSERT INTO bmh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kristus erunai usaleun? Gonugau usaleun igul enai. Gonugau anag Maria go Zosep wabun tapai memen. Bo, getal du go air dual i igarau ebu, Maria go abe meun Uwait nugau Ah Wes nug go enib a meun. ");
INSERT INTO bmh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zosep go igul unum naliu macaneu. Gonun, go duailel ameag ebu Maria utaba, Maria ougab eg wamau. Guzenaimai, go wage wageimai Maria utabun dabeleun. ");
INSERT INTO bmh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bo, Zosep go air utabun dabeleu una una, Uwait nugau tibur nug wabil eiman guzenai aureun, “Zosep. Devit nugau asag, Uwait nugau Ah Wes gonugtal Maria enib a meun. Gonun, na air go wabun iboin, go nait air. ");
INSERT INTO bmh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mogoi go soligwaba, na gonugau wanib Yesus men. Wanib go bigeg ‘gonug gonugau duailel agal igul eg zilagai maraimai, ag koli imaramau’.” ");
INSERT INTO bmh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Go ziwas ebu, igul go unum Dubanou Ban nug Uwait nugau ze doimai, awaraneun du, Aisaia, aureun sultal go petak usaleu. Aisaia nug eneun, ");
INSERT INTO bmh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Air magun tub go du dual ninab tam, go enib a maimai, go mogoi soligwamau, mogoi go wanib Emanuel amam. Go bigeg enai, ‘Uwait ig ibaig dareu’.” ");
INSERT INTO bmh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Guzenaimai, Zosep go asaimai, Uwait nugau tibur nug aureun sultal gonugau air Maria koli oun. ");
INSERT INTO bmh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bo, Zosep air go dual ninab tam gaul dai dai, betei Maria go mogoi soligweun. Mogoi soligwina, Zosep nug mogoi go wanib Yesus meun. ");
INSERT INTO bmh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus go anag nug Betlehem uzan Zudia agaig ebu nanag soligweun. Ziwas go ebu, Herot go gue emgasag gumaraneun du banou king dareun. Maria mogoi soligwai darena, am zuaneun ebuan abiu macanemen dudu ipal go ureb awau usalina, uligaimai, ag go ureb sesamorai Zerusalem ban uzan alemen. ");
INSERT INTO bmh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Go alaimai, goagenag dudu go ebuan guzenai kanabai awaremen, “Zuda agal gumarabun mogoi awau usaleun, go erueim dareu? Ig gonugau ureb am zuaneun eiman usalina, uligaimai, ig go ulagwag murabun alem.” ");
INSERT INTO bmh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Emgasag gumaraneun du Herot ze go doimai, go ougab eg weun, duailel Zerusalem uzanan unum go ereg oiagab eg wemenin. ");
INSERT INTO bmh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Gonun, Herot nug Uwait ula dacanemen dudu banban mui kasai ze tapaimaranemen dudu mui go unum ze palautai marena, alina, kanabai awareun, “Kristus, Uwait nug go palautaba, alamau, go du go eru ebu zoi dareu?” ");
INSERT INTO bmh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Goagen koli go auremen, “Betlehem uzan Zudia agaig ebu. Getal Uwait nugau ze doimai, awaraneun du nug guzenai sikut wai meun: ");
INSERT INTO bmh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, na uzan ginampet Zudia agaig ebu, na uzan ipal piagsal i damam. Tam pet. Nait du banou tub usalamau. Du go usalamau go izal Israel duailel gumaramau.’ Gonun, go Betlehem uzan usalamau.” ");
INSERT INTO bmh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Guzenai aurina, Herot nug wage wageimai, dudu go am zuaneun ebuan kanabai awareun, “Go ureb ein ziwas ebu usaleun?” Goagal ze koli doimai, ");
INSERT INTO bmh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","go Betlehem uzan palautaraimai, guzenai ze awareun: “Ag beteiban, mogoi go suban itanai betei peiban, iz koli alai ailan. Guzenebi, izaban beteimai ulagwag murai.” Go mogoi go betei wai hiabun aimai guzenai polu ze go awareun. ");
INSERT INTO bmh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Gonun, ureb nanalanemen dudu go Herot nugau ze doimai, utei wanemenin. Go abu bete betei, ureb go getal am zuaneun eiman uligemen. Ureb go amegai betei mogoi go dareun zau ebu wag dareun uligaimai, ag oiagab naliu usalina, siksikemenin. ");
INSERT INTO bmh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ag betei zaueim go simai, mogoi go gonugau anag dual dareun uligaraimai, taubib waimai, mogoi go ulagwag moromen. Guzenaimai, ag ecesab ipal wanib aiwag gol mui, garai ipal mui, a ilau nugau sous naliu mui, unum oimai, mogoi go gotulai moromen. ");
INSERT INTO bmh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ag mogoi go ece moroimai, daren daren, Uwait nug wabil eiman ze guzenai awareun, “Ag koli Herot waugab i bitamamen.” Gonun, dudu go abu tub eiman goagal uzan koli wanemenin. ");
INSERT INTO bmh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ureb nanalanemen dudu utei wanena, Uwait nugau tibur tub nug zoimai, wabil eiman Zosep guzenai aureun, “Herot nug mogoi wai hiabun itanai dareu. Gonun, na pigai asaiba, mogoi anag dual imaraiba, Izip emgasag betei dacan. Aiu ses, izanag koli aizemin, ag koli alamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Go umaumtal, Zosep go asaimai, mogoi anag dual Izip emgasag imarai beteun. ");
INSERT INTO bmh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Go, go ebu betei darena, Herot noumeun. Guzenaimai, ze go getal Uwait Ban nug gonugau ze doimai, awaraneun du eiman aneun go petak usaleun, ‘Izal mogoi Izip emgasag ebuan ulina, aleun.’ ");
INSERT INTO bmh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Zosep go Izip emgasag wanena, Herot go ureb nanalanemen dudu agen polu moroimai, wanemen ze doimai, go aigsisileun. Gonun, gonugau malai dudu awarina, go Betlehem uzan mui, uzan ipal Betlehem uzan waugab daremen mui, ag go uzanan mogoi ginaginamul ap zanemen, wai aliag a mui, ulisan mogoi ginaginamul mui, unum wagarina, noumemenin. Einen, ureb nanalanemen dudu go agen ziwas go ebu ureb go usaleun auremen. ");
INSERT INTO bmh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Igul go Uwait nugau ze doimai, awaraneun du Zeremaia nug ze meun ulis petak usaleu: ");
INSERT INTO bmh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Go guzeneun, ‘Rama uzan weinemen saiu domenin. Resel go gonugau gelegul en manil mai dareu. Ailel ipal agen gonugau ougab naliu usalabun ze aurina, go agal ze duab tam. Go koli manil mai dareun. Gonugau gelegul i daremen, unum noumemenin.’ ");
INSERT INTO bmh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dai dai, Herot noumina, Uwait nugau tibur nug Zosep Izip emgasag dareun wabil eiman zoimai aureun, ");
INSERT INTO bmh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Na asaiba, mogoi gonugau anag dual koli Israel agal em ebu imarai bitamam. Einen, dudu go ag mogoi wai hiabun emen go noumemen.” ");
INSERT INTO bmh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gonun, Zosep go asaimai, mogoi go anag dual koli Israel goagal em ebu imarai beteun. ");
INSERT INTO bmh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herot go noumina, Arkelaus go gonugau memeg nugau empip zoi oimai, Zudia agaig gumeun. Zosep go ze go doimai, go ebu bitabun umineun. Go uminina, Uwait nug wabil eiman ze asiu suban morona, go Zudia agaig siab tam, Galili agaig beteun. ");
INSERT INTO bmh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Go betei Nasaret uzan em oun. Guzenaimai, Uwait nugau ze doimai, awarenemen dudu agen ze memen go petak usaleun: ‘Go Nasaret uzanan du.’ ");
INSERT INTO bmh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yesus go ban mina, ziwas go ebu, Zon, ze ziwaraneun du, go du tamacag uzan Zudia agaig em ula ebu salau bigegweun. ");
INSERT INTO bmh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Zon nug duailel go waugab alina, awareun, “Ag agal igul eg ebuan koli kekulan. Einen, Uwait ag gumarabun ziwas aleu!” ");
INSERT INTO bmh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zon nugen Uwait nugau ze doimai, awaraneun du Aisaia nug getal dabeleimai, ze meun: “Du tub, go du tamacag uzan em ula ebu ulai dareu. ‘Dubanou Ban nugau abu suban kalai moron. Gonugau abu tuguiai moron!’” ");
INSERT INTO bmh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zon nugau tibur galau egun kamel ulig oimai, tibur galau patai meun, go egun tub galau oimai, let sul tuageun. Go ta mui, guap ze ilau mui, zaneun. ");
INSERT INTO bmh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Zerusalem uzanan duailel mui, duailel ipal unum Zudia agaig ebu darem mui, Zordan Ze gasag danemen duailel mui, unum go waugab alemen. ");
INSERT INTO bmh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ag agal igul eg Uwait aurina, Zon nug Zordan Ze ebu ze ziwareun. ");
INSERT INTO bmh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Zon go Parisi Sadiusi dudu asiu ze ziwabun alemen uligaraimai, gonug awareun, “Ag man nugau ug sul, agal igul eg pet Uwait nugau aigsisilaba, wagarai hiabun ziwas ebu ag eru uminai unamamen? ");
INSERT INTO bmh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ag agal igul eg semoroiban, oiagab kekulan. Go dudu ipal abiu mamamen agal igul eg ebuan koli kekulemen. ");
INSERT INTO bmh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ag agal dabeleu eim guzenai ze i macan, ‘Abraham go igual asanig. Gonun, Uwait nug ig isanigaba, ig naliu damam.’ Iz ag petak pet awarem e aiwag em ebu darem Uwait nug oimai, Abraham nugau asagul sul usalai marabun iboin. ");
INSERT INTO bmh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Uwait nugau ebeg nug man pataimai, a dulu ebu mai dareu. A dab ipal suban i useg maneu, man nug go a kuataimai, oi ab unig oug hiba, ilamau. ");
INSERT INTO bmh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iz ulis ze sil ag ze ziwaranem, go agal igul eg ebuan kekulabun guzenemin. Bo, du tub ses alai dareu, gonugau gusig nug izal gusig zilacuramau, gonug Uwait nugau Ah Wes ab mui eiman ze ziwaramau. Iz go zilacurabun iborain tam, iz du naliu tam. Gonun, iz gonugau arab galau gamai murabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Go savol ebeg sil patai dareu, go savol sil wit uleimai, wag hina, wol nug wit sog go puaicina, wit useg naliu oimai, gonugau zaueim gotulai mamau, sog oimai, ab i noumaneu ebu agamau.” ");
INSERT INTO bmh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ziwas go ebu, Yesus go Galili agaig uteimai, betei, Zordan Ze ebu go Zon nug ze zioramaun en aleun. ");
INSERT INTO bmh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bo, Zon nug Yesus gonugau dabeleu koli kekulabun aimai aureun. “Na igul go i men. Nagen iz ze ziwilabun iboin. Na einen izan ze ziwizabun en aimai alem?” ");
INSERT INTO bmh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesus nug koli aureun, “Erunamau, ulis nagen guzenen! Uwait nugau igul ig unum mamam. Ig guzenemun, Uwait uligigeimai, enamau, igul go tuguianau.” Gonun, Yesus nug Zon aureun sultal Zon guzeneun. ");
INSERT INTO bmh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zon nug Yesus ze ziorena, go pigai ze uteimai, gasag zoun. Go gasag zoimai, Uwait nug Mesgai im oitina uligeun, go Uwait nugau Ah Wes meg kurumuk sul go ziwas alaimai, gagalig wag hei dareun uligeun. ");
INSERT INTO bmh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Uwait Ban nug du tub nugau zeu sul eiman Mesgai wag eim ulina, doun, “E izal naguai pet go en izal oiab nug noumanem. Izal oiab nug go en naliu usalai dareu.” ");
INSERT INTO bmh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Guzenaimai, Uwait nugau Ah Wes nug Yesus du tamacag uzan em ula ebu Satan nug bimag piabun imai beteun. ");
INSERT INTO bmh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Gil 40 Yesus go ee tamacag we dareun. ");
INSERT INTO bmh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ziwas go ebu, Satan nug go waugab zoimai, aureun, “Na Uwait nugau Nag aba, na aiwag e auremen, bret kekulaba, zenen.” ");
INSERT INTO bmh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bo, Yesus nug koli gusig ze aureun, “Ei, Uwait nugau ze eim guzeneu, ‘Du bret sag zaimai, awau i damau, Uwait nugau ze tutak sesamoraimai, petak awau damau.’” ");
INSERT INTO bmh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Guzenaimai, Satan nug Yesus Zerusalem ban uzan imai beteimai, Uwait ecesab muranemen zau banou wag meun. ");
INSERT INTO bmh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Guzenaimai, aureun, “Na Uwait nugau Nag aba, nagtal go eiman em ebu kuanai nonen? Uwait nugau ze eim guzeneu, ‘Uwait nug gonugau tibur na en awaramau: Goagen nait eben tubaim tubaim pataimai, imaizei numam. Guzenebi, aiwag tub nug nait aram i wamau.’” ");
INSERT INTO bmh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus nug koli gusig ze aureun, “Ei, bo, Uwait nugau ze nug guzeneu, ‘Na nait Uwait Ban bimag i pen.’” ");
INSERT INTO bmh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan nug Yesus em manam banou pet wag imai simai, ece unum gusig mui em e ebu dareu abai moroun. ");
INSERT INTO bmh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Satan nug aureun, “Na iz en taubib waiba, na iz ulapwag milemen, e ece na uligai darem go unum na mizai.” ");
INSERT INTO bmh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Guzenina, Yesus nug aureun, “Satan, na utei alien! Uwait nugau ze nug eneu, ‘Na nait Uwait Ban tutak ulagwag moren. Na Uwait nugau salau sag oi muramam.’” ");
INSERT INTO bmh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Guzenai aurina, Satan go Yesus utei waneun. Uwait nugau tibur agen alaimai, Yesus isanoromen. ");
INSERT INTO bmh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ziwas go ebu, Yesus go Zon hiacaranem zau oug hemen ze doimai, uzan go utei Galili agaig ebu beteun. ");
INSERT INTO bmh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Go Nasaret uzan sag i dareun, go betei Kapaneam uzan dareun, uzan go Galili Ze Unig pezoroi, Sebulun zaug Naptali goagal ug agal em be ebu betei dareun. ");
INSERT INTO bmh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Guzenaimai, igul go Uwait nugau ze doimai, awaraneun du Aisaia nug getal ze meun sultal petak usaleu. ");
INSERT INTO bmh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Sebulun nugau em mui, Naptali nugau em mui, ban abu ibut ze gasag em dareu mui, Zordan Ze gasag tubaim, Galili agaig ebuan duailel mui ipal uzanan duailel mui agal oiagab Uwait en petak i anemen go danemen. ");
INSERT INTO bmh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Go ebuan duailel ag umus oug daremen, ag al banou pimamen! Duailel ipal ag unum em umus oug pet nuaporoi daremen ag han al hilanau pimamen.’ ");
INSERT INTO bmh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ziwas go ebu, Yesus gonugau salau bigegwaimai, guzenai aneun: “Uwait ag gumarabun ziwas aleu. Gonun, agal igul eg ebuan koli kekulan!” ");
INSERT INTO bmh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesus go Galili Ze Unig gasageim ai dai dai bete betei, karuk wanemen dudu aliag piareun. Du tub Saimon, (gonugau wanib tub Pita) gonugau amag wanib Andru, go karuk wabun zo ban ze oug hei daremen. ");
INSERT INTO bmh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus nug guzenai awareun, “Ag alan, iz sesamilebi, izan ag duailel imarabun igul abai marai.” ");
INSERT INTO bmh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yesus nug guzenai awarinatal, zaug dual goagal karuk wanemen zo mui, ecesab ipal tebil ebu uteimai, pigai Yesus sesamorai wanemen. ");
INSERT INTO bmh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Go betei, du aliag piareun. Du go Zems, gonugau amag Zon dual, go Zebedi nugau gelegul aliag. Go agal memeag Zebedi dual goagal tebil ebu daremen, go agal karuk wanemen zo bigageun, gonun, suban kasai daremen. Yesus nug dudu aliag go ulareun. ");
INSERT INTO bmh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Go pigai goagal tebil mui, goagal memeag mui, uteimai, Yesus dual wanemen. ");
INSERT INTO bmh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus go Galili agaig ai dai dai beteimai, Uwait nugau ze naliupet Zuda duailel agal gotulanemen zaueim simai, awareun, “Uwait go alai koli duailel imaramau.” Yesus go ze guzenai awaraimai, duailel ipal suiag mui, ebeu mui, wes eg a mui, kasareun. ");
INSERT INTO bmh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Duailel gonugau igul uligaimai, zeze mai betena, Siria agaig unum doi bitenar. Gonun, go ebuan dudu agen ipal ebeu dudu asiu mui, dudu mu banou a mui, dudu wes eg goagal oiagab oug dareu mui, ebeu patai hamaracaneun mui, aramag ebeag noumeun dudu mui, Yesus waugab imarai alina, gonug unum kasareun. ");
INSERT INTO bmh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Duailel asiu asiu Galili agaig ebuan mui uzan ginaginam houhou wanib banou Dekapolis ebuan mui, Zerusalem uzanan mui, Zudia agaig ebuan, em Zordan Ze tubaim mui, go unum Yesus sesamorai wanemen. ");
INSERT INTO bmh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus go duailel asiu uligaraimai, betei em manam tub ebu hoboi dareun. Guzenina, gonugau tapaimaraneu dudu agen go waugab alemen. ");
INSERT INTO bmh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Go guzenina, Yesus go ein igul memen goagal oiagab naliu usalamau aimai awareun. Go guzenai awareun: ");
INSERT INTO bmh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Duailel inen ag abiu agtal agal doropag isanurabun iborain tam, agtal igul naliu mabun iborain tam, gonun go agal oiagab naliu damau. Uwait nug ag gumaramau. ");
INSERT INTO bmh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Duailel inen ag weinai dacanemen, go agal oiagab naliu damau. Uwait nug duailel go agal oiagab eg koli suban maraba, damamen. ");
INSERT INTO bmh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Duailel inen agal wanimag agtal wag i macanemen, go agal oiagab naliu damau. Uwait nug ag ece marabun awareun, go unum agal umamen! ");
INSERT INTO bmh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Duailel inen ag Uwait nugau igul naliu wabun salau gusig mamamen, go agal oiagab naliu damau. Einen, Uwait nug agal salau memen uligaraimai, isanaramau. ");
INSERT INTO bmh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Duailel inen ag duailel ipal en bisomagar piaranemen, go agal oiagab naliu damau. Uwait nug guzental ag en bisomag pimau! ");
INSERT INTO bmh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Duailel inen ag oiagab oug unu tamacag, go agal oiagab naliu damau. Ag Uwait pimamen. ");
INSERT INTO bmh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Duailel inen agal salau go dudu ipal alalebi, gaul dabun kuatai aidanemen, go agal oiagab naliu damau. Uwait nug ag izal gelear alear awaramau! ");
INSERT INTO bmh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Duailel inen ag igul naliu mui, Uwait nugau salau morobi, dudu ipal agen uligaraimai, aiag sisilaimai, uhu ipal ag ebalagab mebi, go agal oiagab naliu damau. Dudu go aiu ses Uwait nugau uzan simam. ");
INSERT INTO bmh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ag iz sesamilai aidabi, dudu ipal ag uligaraimai, polu ze enimag ebu maimai, ze biabial kuaimai, wagebi, ag oiagab eg i umau, ag oiagab naliu damau. ");
INSERT INTO bmh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ag oiagab naliu damau, einen, Uwait nug ece naliu ipal tapai mareun Mesgai wag dareu aiu ses umamen. Igul go getal igual embigeg ipal agen Uwait nugau ze doimai, awarenemen dudu wagaremenin sultal dudu goagen han ulis ag guzenaramam.” ");
INSERT INTO bmh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesus nug koli awareun, “Duailel agal oiagab petak emen unum ag siu sul. Bo, siu go kel tamacag usalaba, koli siu go kel usalabun iborain tam. Go unum eg weun, ag hamacina, duailel agen aramag sil tapai hiacanemen! ");
INSERT INTO bmh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Duailel agal oiagab petak emen go ag emgasag agal al sul. Ban uzan em tabag ebu zau macanemen go wagemabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Du tub nug gonugau al usaimai, mis oug i macaneu. Go al usaimai, wag araog asai mina, duailel unum gonugau hilanau ebu dacanemen. ");
INSERT INTO bmh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Igul go sul agal al hilanau duailel go agal ameag ebu maramamen. Guzenaimai, goagen ag ein igul naliu guzenemenin go uligaimai, agal memeag Mesgai wag dareu go gonugau wanib ulagwag mamam.” ");
INSERT INTO bmh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesus nug kolital duailel awareun, “Ag iz Moses nugau kasai ze mui Uwait nugau ze doimai, awarenemen dudu agal ze maremenin go oi hiabun alem ta ag guzenai i dabilan. Bo, iz ze go oiabun alab tam, iz agal ze go iborabun alem. ");
INSERT INTO bmh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iz petak pet awarem, Mesgai mui em mui daremen ziwas ebu kasai ze ginampet tub i wagemamau. Goagal ze tutak tutak unum petak pet usalamau, ziwas go ebu petak, agal kasai ze poamau. ");
INSERT INTO bmh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Guzenaimai, du in nug kasai ze go ginampet pet i sesamoramau, gonug dudu ipal gonugau igul abai maramau, gonugau wanib Uwait nugau amegwab ginampet pet damau. Ze tub go enai, na du in nugau kasai ze ginampet go unum sesamoramau, na han dudu ipal igul go abai maramam nait wanim go Uwait nugau amegwab banou damau. ");
INSERT INTO bmh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iz ag petak awarem, agal oiagab Uwait en petak aimai, agal igul naliu abiu macanemen dudu mui, Parisi dudu agal ze tapaimaranemen dudu mui, zilacarab tam, ag petak, Uwait nugau gumarabun uzan simai dabun iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesus nug kolital awareun, “Ag ze e getal asanagar agen awarina, duanemen, ‘Na du tub wemen, i noumamau. Du in nug du tub waba, noumamau go ze sisiaranemen dudu ameagab ebu imai bitamam.’ ");
INSERT INTO bmh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bo, ulis iz ag awarem, du in go gonugau zaug dual iwai mamau, go ze sisiaranemen dudu waiagab imai bitamam. Du in go gonugau zaug ze biabial kuai auramau, go Zuda agal kaunsel ebu imai bitamam. Du in go gonugau zaug auramau ‘Na kar niwaneu du’ ai auramau, du go gue Satan nugau ab unig oug numau. ");
INSERT INTO bmh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Gonun, na nait egun ta, ee ta oimai, Uwait nugau ece murabun biz ebu mabun oi alamam, bo, koli dabilamam nait zaun na ibaiz ze a auremen, na utei koli beteiba, nait egun ta, ee ta biz go waugab men. Beteiba, nait zaun dual ze maimai, agal oiagab tutak maiban, na koli alaiba, nait ece oimai, biz go ebu maimai, Uwait muramam. ");
INSERT INTO bmh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Bo, na du tub dual ze sisianemen dudu waiagab bitabun ag abu ebu bete beteimai, ziwas go betei betemen ebutal agal ze koli oiagab naliu usalabun suban zeze mamamen. Guzenamamen, go na ze sisianemen dudu waiagab imaiz i bitamau. Na igul go i guzenamam, gonug na ze sisiaraneu du nugau ebeg ebu mizaba, gonug na polis nugau ebeg ebu mizaba, polis nug hiacaranem zau oug heizamau. ");
INSERT INTO bmh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gonun, na go zau eiman koli uzaneim nuabun gaul i palautizamam. Bo, na aiwag banou mabun aizeun guzental unum maremen, petak na uzaneim palautizebi, numam.” ");
INSERT INTO bmh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesus nug kolital awareun, “Ag ze getal guzenai ze mina, domenin. ‘Na air omen du ailel ipal abai wal igul i men.’ ");
INSERT INTO bmh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bo, iz guzenai awarem, du tub go air tub uligaimai, gonugau ougab asaba, eg murai aimai dabeleun, du go gonugau ougab oug air go dual igul eg meun. ");
INSERT INTO bmh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Gonun, na nait amen naliu eiman igul eg mabun nait bimag piba, amen go eseiceiba, amamam! Go amen ginampet amacen, nait enim unum mui Satan nugau ab banou muzmuz ilaneu uzan i heizamam. ");
INSERT INTO bmh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nait eben naliu eiman igul eg mabun nait bimag piba, go eben naliu eiman kuataiba, amacen. Na eben hogu damau, go iboi, nait enim unum Satan nugau ab banou muzmuz ilaneu uzan i heizamam.” ");
INSERT INTO bmh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesus nug koli awareun, “Getal go guzenai ze memenin, ‘Du in go gonugau air utaba, unamaun en go agau ginampet tub ebu sikut waimai, air moroimai, air go utaba, unamau.’ ");
INSERT INTO bmh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bo, iz ag awarem, du tub gonugau wau wal igul eg mab tam, gaul utamau, du go nug igul eg pet gonugau wau ebu meu. Go gonugau wau uhu muraneu, einen, wau go koli du tub uba, go duair egarabun agal kasai ze etuborou. Du tub air go umau, du go han kasai ze go etuborou.” ");
INSERT INTO bmh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Go koli eneun, “Ag getal duailel guzenai awaremen domenin, ‘Na ein baib Uwait dual memenin go i utamam, bo, na ein baib Uwait Ban dual memen guzental, go guzental sesamoramam.’ ");
INSERT INTO bmh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bo, ulis iz ag awarem, na ze tub maimai, ze go baib mui aimai i gusig men. Na ze maimai, na Mesgai nugau wanib i paten, einen, Mesgai go Uwait nugau hoboi dacaneun biz. ");
INSERT INTO bmh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na em gaul i wanib paten, einen, go ebu Uwait gonugau arab maimai, i mai dacaneu. Na Zerusalem wanib i paten, einen, go go Uwait igual gumiganeun du banou gonugau ban uzan. Buk Song 48:2 ");
INSERT INTO bmh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na ze tub maimai, na gagalin pataib, ze go dabeleimai, i gusig men, einen, nait gagalin ulig tub auremen, ausiau ta, mutuanau ta, i usalamau. ");
INSERT INTO bmh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Na gaul guzenai ze mamam, ‘io’ ta, ‘tam’ ta, amam. Na ein ze tub maranem, ze go Satan nug eiman alaneu.” ");
INSERT INTO bmh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesus nug koli eneun, “Getal ag guzenai ze mina, domenin, ‘Du tub nug nait amen eg wai mizaba, nagen han koli gonugau ameg eg wai muramam, du tub nug nait ain kuaba, nagen han gonugau aceg kuai muramam.’ ");
INSERT INTO bmh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bo, ulis iz ag awarem, du tub nug niwaba, na koli go i wen. Du tub nug nait siben naliu eiman niwaba, koli kekulaiba, siben nanai eiman moromena, niwamau. ");
INSERT INTO bmh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ze tub enai, du tub nug na ze sisiaranemen du ebu imaiz bitamoroi nait tibur galau huia uba, na kuatai ze i auren. Utemen, nait tibur galau tub han umau. ");
INSERT INTO bmh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ze tub enai, malai du tub nug gonugau zo oimai, abu huia imailei beten aizaba, nagen han du go imai aimai, abu ginam huia pet imai bitamam. ");
INSERT INTO bmh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ziwas tub ebu, du tub nug nait ecesab wabun aizaba, na kuatai ze i auren, na go moren. Du tub nug mui nait ee ta, ecesab ipal ta oimai, ‘Koli ameg mizai aimai aizaba, na i galinen, na go moren.’” ");
INSERT INTO bmh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gonug koli eneun, “Getal ag ze guzenai memen domenin, ‘Nait ounab nug nait zaun en sag noumanem, bo, na nait iwai zaunar en ounab nug i noumanem.’ ");
INSERT INTO bmh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bo, ulis iz ag awarem, agal iwai zaiagar en oiagab nug noumaiban, dudu go en ag wagaremenin en ag Uwait nug isanarabun auramamen. ");
INSERT INTO bmh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Gonun, ag agal memeag Mesgai wag dareu nugau gelegul alegul usalamamen. Uwait nug am usalai maimai, al hilanau duailel eg mui, duailel naliu mui, al go maraneu. Ze han guzental duailel naliu mui, Satan nugau igul eg macanemen dudu mui, ereg ze hei maraneu. ");
INSERT INTO bmh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dudu ipal agenag ag en oiagab noumanem, agenag han koli dudu go en sag oiagab noumamamen. Guzenamamen, Uwait nug ag ece naliu tub maramau ta? Dudu go igul eg mui goagenag han guzental guzenanemen. ");
INSERT INTO bmh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ag agal zaiagar tutak “Io” awaremen, ag dudu ipal “Io” i awaramamen. Agal igul nug duailel ipal agal igul i zilaramau. Einen, Uwait nugau ze i duanemen dudu agen han guzental guzenanemen. ");
INSERT INTO bmh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Agal memeag Mesgai wag dareu gonugau igul naliupet pet. Gonun, ag han go sul igul naliupet pet mui damamen.” ");
INSERT INTO bmh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus nug kolital awareun, “Ag suban dabilan. Ag agal igul naliu naliu duailel ipal agal ameagab ebu i macan. Einen, ag igul go duailel ameagab ebu guzenamamen, agal memeag Mesgai wag dareu, gonug ag ece tub i maramau. ");
INSERT INTO bmh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ag ecesab tamacag du tub ece moroimai, ag duailel ipal ularebi, i alai pimam. Polumanemen dudu agen Zuda duailel agal gotulanemen zaueim, abu ebu agal igul guzenai marena, duailel agen uligaraimai, igual wanimig wag migamam aimai guzenanemen sul, ag i guzenan. Iz ag petak pet awarem, polumanemen dudu go agal ece unum omenin. Aiu ses Uwait nug dudu go ece i maramau. ");
INSERT INTO bmh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ziwas tub ebu, na ecesab tamacag du ece murabun, wage wageimai moren. Guzenemen, nait zaunar na wautab darem agen i peizaimai, abe mamamen. ");
INSERT INTO bmh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na guzenamam, go nait igul wageimai damau. Na igul go wageimai guzenemen nait Memen nug tutak peizaimai, gonug na du naliu aizaimai, aiu ses na ece mizamau.” ");
INSERT INTO bmh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ag Uwait auranemen ziwas ebu, polumanemen dudu agen guzenanemen sul i guzenan! Ag duailel agen uligaraimai, wanimag wag maraimai, Nou Zaueim mui, ban abu gasag tapai daimai mui, Uwait ze muranemen sul, ag i guzenan. Iz ag petak pet awarem, go dudu agal ece unum omenin. Aiu ses Uwait ag ece tub i maramau. ");
INSERT INTO bmh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bo, na Uwait aurabun nait ninanem zau oug sieiba, im gebeiba, nait Memen wageimai dareu piabun, auramam. Na guzenemen, nait Memen nug nait auremen dabeleu uligaimai, aiu ses ece tub mizamau. ");
INSERT INTO bmh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ag Uwait aurabun ziwas ebu, ze gau gaul i auran. Duailel Uwait en oiagab petak ab tam, goagenag agal polu tibur auraimai, ze asi asiu dumau en aimai guzenanemen sul ag go i guzenan. ");
INSERT INTO bmh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ag dudu go sul i usalan. Ag Uwait i aurau ebu, go agal dabeleu get abe meun. ");
INSERT INTO bmh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ag Uwait guzenai auran, ‘Igual memenig, na Mesgai wag darem. Nait wanim noupet ig ulapwag mizem. ");
INSERT INTO bmh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nait gumiganem ziwas em e unum alai iboramau. Nait onsau Mesgai wag sesamoranemen sul, ig han em e ebu han ereg sesamoramam. ");
INSERT INTO bmh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ulis na ig ee migamam. ");
INSERT INTO bmh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Iguanag dudu ipal agal igul eg ig ebiligeb miganemen zilagai maranem sul, nagen han igual igul eg zilagai migen. ");
INSERT INTO bmh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na ig ece abu eg ebu i amaigamam. Na ig utigemen, igul eg nug i imaigamau.’ ");
INSERT INTO bmh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Guzenaimai, ag agal zaiagar agen igul eg ag ebalagab maranem, agen agal igul eg go zilagai marebi, agal memeag Mesgai wag dareu gonug han agal igul eg macanemenin zilagai maramau. ");
INSERT INTO bmh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bo, ag agal zaiagar agal igul eg i zilagai marebi aba, agal memeag nug han agal igul eg i zilagai maramau.” ");
INSERT INTO bmh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesus nug koli awareun, “Ag Uwait aurabun ee ur macanemen, go polumanemen dudu agenag ee ur maimai, bisomag a sul dacanemen sul i guzenan. Ag we aidarena, dudu ipal agen uligaraimai, dudu goagen ze mamam, ‘Dudu go ag ee ur maimai, guzenai darem.’ amam. Iz ag petak pet awarem, dudu go ag agal ece unum omenin. Aiu ses Uwait nug ece tub i maramau. ");
INSERT INTO bmh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na ee ur maiba, ze ziuaimai, gagalin salanaib, nait tibur galau naliu tuagen. ");
INSERT INTO bmh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Na igul go guzenemen, dudu ipal agen na ee utemen i abe mizamam. Nait memen wageimai dareu, go sag abiu mamau. Na igul go wageimai guzenemen, nait memen nug uligizeimai, gonug na du naliu aizaimai, aiu ses gonug na ece mizamau.” ");
INSERT INTO bmh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesus nug kolital awareun, “Ag em e ebu agal ece naliu asi asiu i gotulai macan. Ag go guzenamamen, umum nug ece ipal eg wai maraneun, ipal agal ece unum eg wab tam, zob dudu ipal agen agal zau bigagaimai, ece go zob umam. ");
INSERT INTO bmh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bo, ag agal ece naliu Mesgai wag gotulai macan. Go ebu, umum nug i eg umau. Zob dudu agen go ebu agal zau i bigagaimai, agal ece unum mui i umam. ");
INSERT INTO bmh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gonun, ein uzan nait ece gotulai macanem ebu nait ounab han uzan go dareu.” ");
INSERT INTO bmh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Gonug koli eneun, “Agal ameag go enimag ebuan al. Agal ameag naliu damau go agal enimag al sul elei damau. ");
INSERT INTO bmh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bo, nait amen eg umau, nait ounab oug han unum umusamau. Gonun, nait ounab oug al hilanau tamacag go umuteu, go petak umutai banou pet dareu!” ");
INSERT INTO bmh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Gonug koli eneun, “Salau du tub nug du aliag ebu salau wabun iborain tam. Einen, go du tub en ougab nug noumaimai, du tub en ougab nug i noumamau. Go du tub nugau ze suban sesamoraimai, salau naliu moroimai, du tub semoroimai, gonugau ze suban i sesamoraneu. Ag Uwait nugau salau mui aiwag asiu wabun salau mui ereg gotulai wabun iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesus nug koli awareun, “Gonun, iz ag petak pet awarem. Ag awau dabun dabeleu asiu oimai, guzenai ze i macan, ‘Ig ein ee mui ze mui zaimai, damam?’, ‘Ig ein tibur galau tugamam?’ guzenai ze i macan. Doropag go banou pet, ee go banou tam. Agal enimag banou pet, tibur galau go banou tam. ");
INSERT INTO bmh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ag meg inain piaran! Go ee ug i banemen, go ee egeimai, betei zaueim i gotulai macanem. Agal memeag Uwait nug meg inain ee maraneu. Agen Uwait nugau amegwab meg inain unum zilarai daremen. ");
INSERT INTO bmh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Du in ag ula ebu gonugau dabeleu asi asiu mui em e ebu ziwas huia dabun iboin? Go guzenabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ag einen tibur galau en dabeleu asiu oi daremen? Ag gaian a sisil pian. Go salau i macanem, tibur galau han agtal i patai macanem. ");
INSERT INTO bmh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bo, iz ag petak pet awarem, getal gumaraneun du Solomon go gonugau tibur galau naliu macaneun, tibur galau go a sisil naliu sul tam. ");
INSERT INTO bmh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gaian gig gaugaul go Uwait nug tibur galau maraneu. Gig go ulis damau, go tuaba ab nug unum ilamau. Go gig gaugaul dacanemen go Uwait nug tibur galau maraneu. Agal oiagab petak emen go ginampet! Ag abe macan, Uwait nug ag han gumaraneu. ");
INSERT INTO bmh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Gonun, ag dabeleu asiu oiban, guzenai ze i macan, ‘Izal ee eru eiman alamau? Ze eru eiman alamau? Izal tibur galau eru eiman alamau?’ ");
INSERT INTO bmh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Go Uwait nugau ze i duanemen dudu agenag em e ebuan ece wabun dabilanemen. Bo, agal memeag Mesgai wag dareu go abiu meun, ece go salau a, gonun, gonug ag maramau. ");
INSERT INTO bmh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ag Uwait nugau uzan siabun amegai dabeleimai, gonugau igul naliu sesamoramamen, gonug koli ece go unum ag maramau. ");
INSERT INTO bmh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gonun, ag tuaba en dabeleu ulis i on. Ulisan uhu go gonugau atai. Tuaba en han uhu a. Ag ulisan uhu sag dabilan.” ");
INSERT INTO bmh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesus nug kolital awareun, “Ag dudu ipal agal igul i sisiai maran. Ag guzenebi, Uwait nug han agal igul i sisiaramau. ");
INSERT INTO bmh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ag duailel ipal agal ein ze sisiai maramamen, Uwait nug han guzental agal ze sisiai maramau. Ag dudu ipal ebalagab ein igul eim sisiaranemen, Uwait nug ag ebalagab han guzental sisiaramau. ");
INSERT INTO bmh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na einen nait zaun nugau ameg ebu esues ginampet oi hiabun uligem? Nait amen ebu a tatau dareu na piabun iborain tam ta? ");
INSERT INTO bmh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nait amen ebu a tatau banou darena, na erunai nait zaun nugau ameg ebu esues oi hiabun aurem, ‘Zai, iz nait amen ebu esues oi ai em.’ ");
INSERT INTO bmh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Na polumaranem du, amegai a tatau banou nait amen ebu dareu oi heiba, koli naliu abu uligaiba, petak zaun nugau esues ameg ebu dareu oi amam. ");
INSERT INTO bmh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ag ein ece naliu Uwait murabun tapai memenin go bau inain i maran. Ag galoloi naliu naliu bo sigual ebu i amaican. Bau bo agen ece go i zaimai, go koli kekulaimai, agal aramag ebu ece go tapai hiacaraimai, koli ag kaluaramam.” ");
INSERT INTO bmh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesus nug koli eneun, “Ag ein ece wabun Uwait aurebi, gonug ece maramau. Ag ein ece itanamamen, ag pimamen. Ag im korukoru amamen, Uwait nug im oitai maramau. ");
INSERT INTO bmh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Duair in go ece wabun Uwait auramau, go ece umau. Duair in ece itanamau, go pimau. Duair in go Uwait nugau im korukoru amau, Uwait nug go im oitai muraba, zaueim simau. ");
INSERT INTO bmh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bo, du tub nugau nag nug memeg auramau, ‘Mekai, iz ma zai,’ auraba, memeg nug aiwag em ebuan oi muraneu ta? ");
INSERT INTO bmh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ziwas tub ebu, gonugau nag nug, ‘Mekai, iz karuk zai,’ auraba, memeg nug man eg tub oi muraneu ta? ");
INSERT INTO bmh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iz ag petak pet awarem, dudu igul eg macanemen agen goagal gelear ein ece naliu marabun abe macanemen, sultal agal Memeag Mesgai wag dareu aurebi, gonug ag ece naliupet pet maramau. ");
INSERT INTO bmh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Go ze go Moses nugau kasai ze mui, Uwait nugau ze doimai, awarenemen dudu agal ze mui, goagal bigeg, einen go ein igul naliu duailel agen ag ebalagab mabun guzenebi, ag han igul go sag ebalagab macan.” ");
INSERT INTO bmh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Guzenaimai, koli eneun, “Ag abuog agiug pet sian. Ab unig nuabun abu banou gereua pet, duailel asiu ag abu go ebu pigai sesamoranemen. ");
INSERT INTO bmh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bo, awau dabun abuog go agiug pet. Duailel go asiu siabun iborain tam. Duair tutak tutak go abuog go pianemen.” ");
INSERT INTO bmh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesus nug duailel guzenai awareun, “Ag polu ze doimai, awaranemen dudu suban piaran. Dudu go piaraimai, go sipsip sul darem aimai dabilanemen, bo, go gaian bau zag sul darem. ");
INSERT INTO bmh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Polu ze awaranemen dudu agal igul erunanem eim ag petak abe mamamen. Dudu ag wain dab us kulam ebuan wanemen ta? Dudu ag sabug dab ebulig ziu ebuan wanemen ta? Tam pet tam. ");
INSERT INTO bmh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Guzenaital, ein a naliu go dab naliu useg macaneu. Ein a eg go dab useg eg macaneu. ");
INSERT INTO bmh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A naliu go dab eg i macaneu. A eg go dab naliu i useg macaneu. ");
INSERT INTO bmh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","A go unum dab naliu i useg macanemen, go unum kasaimai, ab oug hiacaramam. ");
INSERT INTO bmh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Igul go guzenamam, gonun, polu ze awaranemen dudu go agal igul erunanem eim ag abe mamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yesus nug koli awareun, “Duailel unum izal wanim pataimai, enanem, ‘Dubanou Ban, Dubanou Ban,’ duailel go Uwait nugau gumaneu uzan i simam. Bo, du in izal mekai Mesgai wag dareu gonugau ze sesamoraneu du tutak go petak simau. ");
INSERT INTO bmh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aiu ses sisiarabun ziwas zumau ebu, duailel asiu agen alaimai, guzenai ailamamen, ‘Dubanou Ban, Dubanou Ban, ig nait wanim ebu ig Uwait nugau ze oimai, duailel ipal betei abai maranemun, ig nait wanim ebu dudu ipal go wes eg a dacanemen kasaremun, nait wanim ebu ig gugeg beu beu macanemun.’ ");
INSERT INTO bmh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ziwas go ebu iz ag guzenai awarai, ‘Ag igul eg macanemen duailel, ag enan! Iz ag en i abiu.’” ");
INSERT INTO bmh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Gonug koli eneun, “Gonun, du in go izal ze doimai, sesamoraneu du, go du dabeleu naliu a. Gonugau zau aiwag asiu ebu gusig tapai macaneu sul. ");
INSERT INTO bmh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ze nuna, zewei banou noimai, wol banou zoimai, zau go suai heun, bo, suai hina, alai nuab tam, einen, zau sanag aiwag gusig ebu tapai meun, gonun, zau gusig pet dareu. ");
INSERT INTO bmh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bo, du in go izal ze doimai, sesamorab tam, go dudu ipal kar wageun dabeleu tamacag sul, gonugau zau us nogoug ebu tapai meun. ");
INSERT INTO bmh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ze nuna, zewei banou noimai, wol banou zoimai, zau go us nogoug ebu tapai meun unum suai hina, asolaimai, unum alai noun.” ");
INSERT INTO bmh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus nug gonugau ze unum duailel marai mazicina, go gonugau ze atai abai mareun doimai, esilakemenin. ");
INSERT INTO bmh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gonugau ze kasai ze tapaimaranem dudu agal ze sul tam. Go du tub wanib a sul ze mareun. ");
INSERT INTO bmh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus go em manam wag eim utei nuna, duailel asiu go sesamorai betemenin. ");
INSERT INTO bmh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Du tub ebeu eg leprosi mui gonug Yesus waugab alaimai, taubib waimai, aureun, “Dubanou Ban, na, izal sui eg zilagai milabun iboin, aba, nait dabeleu eim guzenen. Na iz kasilemen, iz naliu usalai.” ");
INSERT INTO bmh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus gonugau ebeg nug du go pataimai, aureun, “Izan aizem. Na naliu usalamam.” Ziwas go ebutal, Yesus nug du go leprosi mui kasai meun. ");
INSERT INTO bmh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Guzenaimai, Yesus nug aureun, “Iz igul e guzenem na betei duailel ipal i awaren. Bo, na Uwait ula dacaneu du waugab beteimai, nait enim naliu usaleun abai moromen, peizamau. Peizaimai, na Moses nugau kasai ze sesamoreiba, egun oiba, Uwait ulagwag moromen, go petak duailel unum abiu mamam, na koli naliu usalemen.” ");
INSERT INTO bmh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ziwas go ebu, Yesus go Kapaneam uzan beteimai, Rom malai dudu agal du banou nug zoimai, gonugau salau du kasurabun aimai Yesus aureun, ");
INSERT INTO bmh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Dubanou Ban, izal salau du go ebeu banou oimai, go mu banou mui aidabun iborain tam, go zaueim biz ebu gabuai dareu.” ");
INSERT INTO bmh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus nug koli aureun, “Iz beteimai, du go kasai mai.” ");
INSERT INTO bmh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Malai dudu go agal du banou nug koli Yesus aureun, “Dubanou Ban, iz igul eg macanem du, gonun, na izal zaueim i beten. Bo, na onsau eim sag ze memen, izal salau du go naliu usalamau. ");
INSERT INTO bmh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iz han dudu banban agal piagsal danem. Malai dudu ipal go izal pisal dacanem. Izal malai du tub auranem, ‘Na e alen,’ aurina, alaneu. Tub auranem, ‘Na ulib go beten,’ aurina, bitaneu. Izal salau du go ‘Na salau e men,’ aurina, salau macaneu.” ");
INSERT INTO bmh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus go malai dudu agal du banou gonugau ze doimai, go esilakaimai, duailel sesamorai betemen go guzenai awareun, “Iz petak pet awarem, iz Israel du tub du e sul gonugau ougab petak eun sul i pemin. ");
INSERT INTO bmh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iz ag petak pet awarem, duailel am zuaneun ebuan mui, am nuaneun ebuan mui, alaimai, Abraham, Aisak, Zekop mui alai Uwait nugau gumaraneun uzan gotulaimai, Uwait nug dual hoboimai, ereg ee zai damamen. ");
INSERT INTO bmh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bo, dudu ipal ag Uwait nugau ameg ebu ze a daremen, ag oi hiacaraba, umaum damamen, duailel go ag agal aiag kititkatitai, weinai damamen.” ");
INSERT INTO bmh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Guzenaimai, Yesus nug malai dudu agal du banou aureun, “Na nait uzan beten! Iz nait ounab petak emen uligizem. Go petak zumau.” Ziwas go ebutal, malai dudu agal du banou nugau salau du naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesus go Pita nugau zaueim simai, go Pita nugau tanau air ebeu enib zabeg mui, biz ebu gabuai dareun uligeun. ");
INSERT INTO bmh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus nug air gonugau ebeg patena, ebeu air go ebu dareun utei waneun. Air go asaimai, Yesus nugau ee zabun suban kasai moroun. ");
INSERT INTO bmh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Umusig mina, duailel ipal agen duailel asiu wes eg go agal oiagab oug daremen Yesus waugab imarai alemen. Yesus nug duailel go wes eg mui, ogusau eim awarina, wes eg go duailel oiagab an utarai wanemen. Yesus nug duailel ipal ebeu mui han kasareun. ");
INSERT INTO bmh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Go igul go guzenina, go ze go Uwait nugau ze doimai, awaraneun du, Aisaia nug ze mareun, ‘Du go nugtal igual ebeu mui, wes eg mui, zilagai migeimai, oi waneun.’ Ze go petak usaleu. ");
INSERT INTO bmh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Dudu asiu go Yesus waugab gotulaimai, tali talioroi darena, gonug uligaraimai, gonugau tapaimaraneu dudu Galili Ze Unig tubaim bitabun aimai awareun. ");
INSERT INTO bmh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kasai ze tapaimaraneu du tub nug Yesus waugab alaimai, Yesus aureun, “Du Banou, na eru unamam, iz na umkoskos sesamizai bitai.” ");
INSERT INTO bmh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus nug koli aureun, “Gaian egun zag inain go ninabun empip a, meg inain go ninabun teu mui, bo, Du Nugau Nag go ninabun empip tamacag.” ");
INSERT INTO bmh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesus nugau tapaimaraneu du tub nug Yesus aureun, “Dubanou Ban, amegai na iz utileben, betei izal mekai ob oug heimai, koli alai, na sesamizai.” ");
INSERT INTO bmh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesus nug koli aureun, “Na iz ulis sesamilen. Noumemen dudu agtal goagal zaiagar noumemen ob oug hiacaramam.” ");
INSERT INTO bmh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesus go gonugau tapaimaraneu dudu abai tebil ebu ereg simai, betemenin. ");
INSERT INTO bmh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wol banou zoimai, ze isacasoi ina, tebil ibut ze unig oug nuamoroi eun. Bo, Yesus go gabuai dareun. ");
INSERT INTO bmh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gonugau tapaimaraneu dudu agen beteimai, go asoroimai, auremen, “Dubanou Ban, na ig isanigen. Ig ze nug oigai zamoroi!” ");
INSERT INTO bmh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus nug koli awareun. “Ag einen uminai daremen? Agal oiagab petak eun go ginampet!” Guzenaimai, go asaimai, wol mui, ibut ze mui, gusig ze awarina, saipag socemen. Ibut ze gonugau dareun go sultal iau dareun. ");
INSERT INTO bmh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Guzenina, dudu unum dabeleu asiu oimai, agzozou enemen, “E du ein du eneneg? Wol mui ibut ze mui gonugau ze sesamoranem!” ");
INSERT INTO bmh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ziwas go ebu Yesus go Gadara duailel agal em ebu, ban ze tubaim gasag beteun. Uzan tub dudu noumanemen ob oug hiacaranemen empip eim du aliag go ob dareun eim, zoimai, abu ebu Yesus tuloromen. Du zaug dual go wes eg mui, kar wagareun. Duailel unum go kar wageun dudu aliag uminaraimai, abu go eiman i bitanemen. ");
INSERT INTO bmh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Dudu aliag go Yesus gusig uloroimai, guzenai auremen, “Na Uwait nugau Nag, na ig erunigabun alem? Na ig uhu migabun alem ta? Igual sisicigabun ziwas ulis tam, aiu ses alamau.” ");
INSERT INTO bmh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dudu aliag go dacanemen ebu, bo asiu go ebu tubaiman eim ee zai daremen. ");
INSERT INTO bmh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gonun, wes eg go agen Yesus gusig ze auremen, “Na ig palautigeben, ig ulib e, bo inain darem goagal oiagab oug palautigemen, numam.” ");
INSERT INTO bmh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus nug wes eg awareun, “Ag alian!” Guzenina, wes eg go bo agal oiagab oug utei siemen. Bo go pigai uminaimai, em eg eiman betei ban ze oug noi beteimai, ze zaimai, noumemenin. ");
INSERT INTO bmh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bo gumaranemenin dudu go igul go uligaimai, pigai goagal ban uzan uminai beteimai, dudu aliag go wes eg mui erunaremen ze unum duailel ipal awaremen. ");
INSERT INTO bmh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gonun, uzanan duailel go unum Yesus piabun betemen, go betei uligaimai, goagal em uteimai, uzan tub bitabun aimai gusig ze auremen. ");
INSERT INTO bmh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus go koli tebil ebu simai, Galili Ze Unig matelai, gonugau uzan Kapaneam beteun. ");
INSERT INTO bmh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dudu ipal agen ebeu du tub gonugau arab ebeg egugweun mui biz ebu maimai, Yesus waugab imai alemen. Dudu go agal oiagab Yesus en petak emen uligaraimai, du go arab ebeg egugweun mui aureun, “Nagwai, nait ounab iau damau, iz nait igul eg zilagai mizem.” ");
INSERT INTO bmh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Guzenai aurina, kasai ze tapaimaranem dudu ipal agen go agal oiagab eim agzozou guzenai dabilemenin, “Du go gue Uwait ze biabial kuai aureu.” ");
INSERT INTO bmh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus go dudu go agal dabeleu abe maimai, awareun, “Ag einen agal oiagab eim go dabeleu eg oi daremen? ");
INSERT INTO bmh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Iz ein ze mabun iboin, ein ze mabun iborain tam? ‘Nait igul eg zilagai mizem,’ iz guzenai ze mai ta, ‘Na asaiba, alien,’ iz guzenai ze mai ta? Iz ein ze mai, ag agal oiagab iz en petak amamen? ");
INSERT INTO bmh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bo, ag Du Nugau Nag go wanib a, go em e ebuan igul eg zilagabun iboin abe mabun en iz guzenai.” Guzenai ze maimai, gonug ebeu du go aureun, “Na asaiba, nait biz oiba, nait uzan beten!” ");
INSERT INTO bmh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Guzenina, du go asaimai, gonugau uzan waneun. ");
INSERT INTO bmh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Duailel go igul go uligaimai, go Uwait nugau wanib ulagwag memenin. Einen, gonug Yesus gusig morona, gonug dudu asai maraneun. ");
INSERT INTO bmh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus go Kapaneam uzan uteimai, abu ebu betei, du tub gonugau wanib Matiu go takis aiwag waneun du gonugau salau macaneun zaueim hoboi dareun uligeun. Go Matiu guzenai aureun, “Na alai, iz sesamilen.” Guzenai aurina, Matiu go asaimai, Yesus sesamorai waneun. ");
INSERT INTO bmh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesus go Matiu nugau zaueim ee zina zina, aiwag wanemen dudu ipal mui, igul eg macanemen dudu abai zoimai, Yesus gonugau tapaimaraneu dudu abai hoboi dacanemen eebiz ebu zoimai, ereg hoboi mai ee zemen. ");
INSERT INTO bmh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi dudu ipal agen dudu go uligaraimai, Yesus nugau tapaimaraneu dudu kanabai awaremen, “Agal tapaimaraneun du go einen go aiwag wanemen dudu mui, igul eg macanemen dudu abai ereg ee zai dareu?” ");
INSERT INTO bmh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus go ze go doimai, awareun, “Duailel ebeu tamacag go ebeu kasaraneun du waugab i bitanemen, duailel ebeu mui sag petak go ebeu kasaraneun du waugab bitamamen. ");
INSERT INTO bmh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ag ze go Uwait nug aneun ag betei bigeg itanaiban, abe mamamen. ‘Egun agaimai, iz milamamen go iz oiab i naliu mamau.’ Ag igul go i guzenan, ag dudu ipal en bisomagar piaraiban, isanaramamen go izal oiab naliu mamau. Iz duailel igul naliu macanemen ularabun alab tam. Iz duailel igul eg macanemen ularabun alemin.” ");
INSERT INTO bmh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ziwas go ebu Zon, ze ziwaraneun du nugau tapaimaraneu dudu agen Yesus waugab alaimai, guzenai kanabemen, “Ig Parisi dudu abai ziwas ipal ebu ee ur macanem. Nait tapaimaremen dudu einen ee ur i macanem?” ");
INSERT INTO bmh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus nug koli awareun, “Du tub go air awau wabun aimai, gonugau zaugul abai daimai, goagal oiagab eg mui dacanemen ta? Tam! Dudu ipal agen du go air oun gusig pataimai, imai wanebi, go ag abai i daba, ziwas go ebu, ag oiagab eg waimai, ee ur damamen. ");
INSERT INTO bmh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Du tub nug gonugau tibur galau bigageun, tibur galau zig awau oimai, tibur galau muzinan ebu i galia mamau. Tibur galau go ze ulusabun ziwas ebu, tibur galau awau ginampet usalaimai, gonugau tibur galau koli bigagaimai, biag banou usalamau. ");
INSERT INTO bmh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Du tub nug wain ze awau meme galau muzinan ebu i goriai macaneu. Go guzenamau, wain ze awau go siwalkuk aimai, muzinan meme galau bigagaimai, wain ze em ebu esikai numau. Go meme galau han ereg zilagamau. Wain ze awau go meme galau awau ebu goriai memen, go naliu damau.” ");
INSERT INTO bmh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus go duailel ze go mare marena, Zuda du tub banou gonug Yesus waugab zoi taubib waimai, aureun, “Izal ainag ulis noumeun, bo, na beteib, nait eben go ebu memen, go koli usamau.” ");
INSERT INTO bmh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Guzenai aurina, Yesus go asaimai, du go sesamorai beteun. Gonugau tapaimaraneu dudu han go ereg betemenin. ");
INSERT INTO bmh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Air tub go geil ebeu umkoskos waneu, ebeu gonugau wai begurug dareun. Yesus go bete betena, go Yesus seugab zoimai, Yesus nugau tibur galau siu pateun. ");
INSERT INTO bmh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Air go gonugau ougab eim dabeleun, ‘Iz gonugau tibur galau sag patai, iz koli naliu usalai.’ ");
INSERT INTO bmh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus go koli kekulaimai, air go uligeun, gonug guzenai ze meun, “Aleguai, nait ounab iau selanau mui damau. Na iz en ounab petak emen, gonun, na naliu usalamam.” Ziwas go ebutal, air go koli naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Guzenaimai, Yesus go du banou nugau zaueim beteun. Duailel go gonugau aleg noumina, dudu ipal go balau huai daremen, duailel ipal go weinai daremen picareun. ");
INSERT INTO bmh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gonug awareun, “Ag duailel unum uzaneim non! Ainag go go noumab tam, go gaul gabuai dareu!” Yesus nug guzenai ze mina, duailel agen go peimai, welemen. ");
INSERT INTO bmh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Duailel go unum uzaneim utei nuna, Yesus go ainag gonugau zau empip oug simai, gonugau ebeg aliag patena, ainag go koli aseun. ");
INSERT INTO bmh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Go igul go meun ulag go emgasag unum iboreun. ");
INSERT INTO bmh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus go uzan go uteimai, abu ebu betei beteimai, du ameag kumi aliag agen go sesamorai beteimai, gusig ulemen. “Devit nugau Nag, na ig en bisomig peiba, na ig isanigen.” ");
INSERT INTO bmh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus go zau tub simai, dudu aliag agen go waugab sina, gonug kanabai awareun, “Agal oiagab iz ag isanarabun en petak eu ta?” Zaug dual agen koli guzenai auremen, “Dubanou Ban, io, na iboin, guzenai igul mamam.” ");
INSERT INTO bmh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesus nug goagal ameag pataimai, enai ze meun, “Agal oiagab iz en petak emenin, gonun, agal ameag waipamau!” ");
INSERT INTO bmh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus nug guzenai ze mina, dudu aliag go agal ameag waipeun. Yesus nug koli guzenai gusig ze awareun, “Ag betei, duailel i awaran!” ");
INSERT INTO bmh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bo, dudu aliag go uzaneim noimai, Yesus nug kasareun en ze emgasag unum ze betei maremen. ");
INSERT INTO bmh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesus gonugau tapaimaraneu dudu abai unabun ina, duailel ipal agen du tub ogusau tapeleun wes eg mui Yesus waugab imai alemen. ");
INSERT INTO bmh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Guzenina, Yesus nug wes eg go ogusau tapeleun du dual dacaneun oi heun. Guzenina, du go ze meun, duailel go dabeleu asiu oimai, guzenai ze memen, “Ig igul go getal Israel duailel ula ebu piab tam.” ");
INSERT INTO bmh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bo, Parisi dudu agen guzenai ze memen, “Go wes eg goagal du banou nug go gusig morona, go wes eg oi hiacaraneu.” ");
INSERT INTO bmh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus go ban uzan mui, uzan ginampet mui, unum beteimai, goagal gotulanemen zaueim duailel ze mareun. Uwait nug duailel gumarabun en alamau Ze Naliupet gusig mareun. Go duailel ebeu beu beu mui kasaraneun. ");
INSERT INTO bmh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Go duailel asiu alai go tulina, uligaraimai, bisomagar piareun, einen, ag du tub nug i isanaraneu, ag agal dabeleu beu beu daremen igul go ag sipsip gumarabun dudu tamacag sul. ");
INSERT INTO bmh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gonun, Yesus nug gonugau tapaimaraneu dudu guzenai awareun, “Go ougem ee asiu iboin usalai dareu, ougem go ee egeimai, gotulabun salau dudu asiu tam. ");
INSERT INTO bmh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ag ougem atag du go aurebi, gonug salau dudu ipal palautaraba, goagen betei ee go gotulai mamam.” ");
INSERT INTO bmh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus nug gonugau tapaimaraneu dudu begurug ularena, alina, wes eg oiabun mui, duailel ebeu beu beu mui, kasarabun mui gusig mareun. ");
INSERT INTO bmh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Yesus nugau tapaimaraneu dudu begurug Uwait nugau ze oi aidanemen dudu agal wanimag enai: Saimon gonugau wanib tub Pita, gonugau amag nugau wanib Andru, Zems gonugau amag Zon dual, go Zebedi nugau gelegul aliag. Pilip, Bartolomiu, Tomas, Matiu go takis aiwag waneun du, Zems go Alpius nugau nag, Tadias, tub Saimon go ug tub wanib Serot ebuan, Zudas Iskariot gonug Yesus gonugau iwai zaugul ebeagab mareun. ");
INSERT INTO bmh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus nug dudu begurug go palautaraimai, awareun, “Ag ipal emgasag ebuan duailel agal uzan uzan mui, Samaria agal ban uzan ipal mui, i bitan. ");
INSERT INTO bmh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bo, ag Israel duailel sipsip sul wageimai darem waiagab bitan. ");
INSERT INTO bmh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ag beteimai, guzenai awaramamen, ‘Uwait nug duailel gumarabun ziwas waiagab zoi dareu.’ ");
INSERT INTO bmh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ag betei guzenamamen, duailel ebeu mui kasaramamen, noumemen duailel koli usarai mamamen, duailel ebeu suiag gusig (leprosi) mui kasaramamen, wes eg duailel ebalagab darem oi hiacaramamen. Ag salau go mamamen, guzenai dabeleimai, enan, ‘Ig gusig go gaul omun, gonun, iguan dudu ipal en ig ece migabun i awaramam.’ ");
INSERT INTO bmh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ag aiwag ipal agal zo nag oug zulagai mamamen, i oi unamamen. ");
INSERT INTO bmh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ag abu unaporoi, du tub nug gonugau zo ta, tibur galau ta, arab galau ta, taru tub ta, i oi unamamen. Salau macaneu du gonug ece go petak waneu. ");
INSERT INTO bmh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Bo, ag ban uzan tub ta, uzan ginampet tub siceiban aba, ag duailel agal igul suban uligamamen. Du in gonugau igul naliu, du in gonugau igul eg piaramamen. Ag dudu naliu go abai suban daiban, betei ag, koli uzan go utarai unamamen. ");
INSERT INTO bmh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ag go dudu agal zaueim simai aba, ag guzenai ze mamamen, ‘Igual oigeb ag abai naliu dareu.’ ");
INSERT INTO bmh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Go zauan du nug ag imaraimai, suban gumaraba, agal suban dabun en ze du go dual damau. Bo, du in go ag gonugau zaueim i imarai siba, agal suban dabun en ze go dual i damau. ");
INSERT INTO bmh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Dudu ipal agen agal ze duabun uteimai, suban i gumarebi aba, ag uzan go uteiban, agal igul eg abai marabun en agal aramag ebuan emwaibul kueian. ");
INSERT INTO bmh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iz ag petak pet awarem, sisiarabun ziwas ebu Sodom mui Gomora duailel uhu banou ginam umam, bo, go uzanan duailel ag uhu banou petpet umam.” Yesus nug gonugau ze oi aidanemen dudu guzenai awareun. ");
INSERT INTO bmh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesus nug kolital guzenai awareun, “Ag go don, iz ag sipsip sul bau zag inain darem ula ebalagab palautaremin, betei damamen. Gonun, ag man sul iau betei daimai, abu suban pimamen, ag meg kurumuk agal igul sesamoraiban, ag iau dan. ");
INSERT INTO bmh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ag dudu ipal subantal piaran. Dudu ipal agenag gusig pataraimai, sisiarabun du waugab imarai bitamam. Ag gusig pataraimai, agal gotulanemen zaueim beu beu imarai beteimai, esalau sul ugaramam. ");
INSERT INTO bmh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ag izal wanim ebu salau mebi, uligaraimai, dudu ipal goagen hiacaranem zau oug hiacarabun agal gumaranemenin dudu banban waiagab imarai bitamam. Guzenebi, ziwas go ebu agenag mui emgasag ipal ebuan dudu mui, izal ze awaramamen. ");
INSERT INTO bmh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Dudu ipal agenag hiacaranem zau oug hiacarabun imarai betebi, ag uminaimai, ‘Ig erunai ze mab’, ‘Ig ein ze koli awarab’, guzenai dabileiban, ag oiagab eg i umau. Ziwas go ebu, ag Uwait nug dabeleu maraba, ag ze awaramamen. ");
INSERT INTO bmh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ag ze go agal oiagsau ebu agtal i ze mamamen. Agal memeag nugau Ah Wes nugtal dabeleu maraba, ag ze maramamen. ");
INSERT INTO bmh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ipal dudu agtal agal apanagar, amanagar abai, agal iwai zaiagar agal ebeag ebu marebi, go iwai zaiagar goagen ugarebi, noumamam. Memeagar agen agal geleagar aleagar guzental guzenarebi, ugaramam, guzenebi, geleagar aleagar agen han koli kekulaimai, agal memeagar guzental guzenaramam. ");
INSERT INTO bmh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bo, ag izal salau oi milanemen, gonun, dudu agen ag en aiagsisilaimai, gasag eim hiacaramam. Du in go izal salau i utamau, go umkoskos gusig mai damau, aiu ses sisiarabun ziwas ebu, Uwait nug go koli imacamau. ");
INSERT INTO bmh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bo, ag go ban uzanan dudu agen ag ebalagab igul eg marebi, ag koli ban uzan tub uminai unamamen. Iz ag petak pet awarem ag Israel agal uzan banban salau unum i poau ebu Du Nugau Nag koli alamau. ");
INSERT INTO bmh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Abiu mogoi tub nug gonugau tapaimoroun du zilacurabun iborain tam, salau du tub nug gonugau gumaneu du zilacurabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Gonun, mogoi go gonugau dabeleu gonugau tapaimoroun du sul usalaimai, go petak gonugau ougab naliu usalamau. Salau du han guzental, go gonugau gumaneun du sul usalaimai, gonugau ougab naliu usalamau. Iz agal gumaranemin du, dudu ipal agen Belsebul nugau wanib iz ebilab milamam, ag izal tapaimaremin dudu ebalagab goagen wanimag eg pet maramam.” ");
INSERT INTO bmh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesus nug kolital awareun, “Gonun, ag dudu ipal i uminaran. Ein ece ulis kulai wageimai dareu, go araog zumau. Ein ze wageimai dareu, dudu ag go abe mamam. ");
INSERT INTO bmh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Izal ze umaum awarai darem agen han amban ze maramamen. Iz ag ein ze agtal iau awaremin, agen han duailel ameagab ebu asaimai, tapai daimai, ze araog awaramamen. ");
INSERT INTO bmh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ag dudu ipal agen dudu ugarina noumanemenin, dudu go en ag i uminaran, goagen ag ugaraimai, agal doropag eg wai marabun iborain tam. Ag Uwait tutak uminuramamen, gonug petak agal enimag mui, doropag mui, unum ab banou oug hiacarabun iboin. ");
INSERT INTO bmh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Na aiwag ginampet sil meg supikiau aliag gau macanem. Nait memen nug meg unum gumaraneu. Meg tub nugtal i nuaneu, gonug ze mina, meg go em ebu utena, nuaneu. Uwait nug meg inain naliu gumaraneu, gonun, gonug ag han subantal gumaramau. ");
INSERT INTO bmh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gonug agal gagaliag ulig tutak tutak go unum nanaleun dareu. ");
INSERT INTO bmh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Gonun, ag i uminan, Uwait nugau amegwab ag dudu naliu, agen meg inain zilarai daremen.” ");
INSERT INTO bmh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesus nug kolital eneun, “Du in nug iz en duailel ameagab ebu ‘Iz gonugau zaug’ amau, izan han izal mekai Mesgai wag dareu gonugau amegwab du go en ‘Go izal zai’ anai. ");
INSERT INTO bmh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bo, du in nug iz en ‘Iz gonugau zaug’ duailel ameagab ebu i ze mamau, izan han izal Mekai Mesgai wag dareu gonugau amegwab du go en ‘Go izal zai’ i anai.” ");
INSERT INTO bmh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesus nug koli awareun, “Ag guzenai i dabilan, go emgasag e ebu duailel oiagab siksikanau mui dabun aleu aimai i ze macan. Iz ag abai oiagab siksikanau mui dabun alab tam, bo, ag abai alalabun iz malai oi alemin. ");
INSERT INTO bmh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Iz geleagar aleagar agal oiagab kekularemin, goagal memeagar abai iwai damam. Ainagul han anaiagar abai iwai damam. Ailel han goagal buziagar abai iwai damam. ");
INSERT INTO bmh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Duailel ag ug tutak koli agzozou iwai damam. ");
INSERT INTO bmh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","In mogoi ainag, go gonugau memeg, anag en ougab nug noumaimai, go iz en ougab nug i noumamau, go izal tapaimaranem du i damau. Du in go gonugau mogoi, ainag en ougab nug noumaimai, go iz en ougab nug i noumamau, go izal tapaimaranem du i damau. ");
INSERT INTO bmh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Du in go gonugau a gegeulanau gamai aimai, iz sesamilab tam, du go gue izal tapaimaranem du tam. ");
INSERT INTO bmh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bo, du in nugtal gonugau dorog awau dabun salau mamau, du go gonugau dorog eg umau. Bo, du in go iz en dabeleimai, gonugau enib utaneu, du go gonugau dorog awau muzmuz damau. Go i noumamau.” ");
INSERT INTO bmh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Gonug guzenai awareun, “Du in nug ag imaraimai, suban gumaraneu, du go nug iz han imailaneu. Du in nug iz imailaneu, du go gue Uwait han imaneu. Go guzenabun Uwait nug iz palautilena, alemin. ");
INSERT INTO bmh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Du in go du tub Uwait nugau ze doimai, awaraneun du abiu maimai, go du imaneu, aiu ses Mesgai wag go ece ze doimai, awaraneun du go oun sul umau. Du in go du tub tuguiai aidaneun abiu maimai, go du go imaneu, aiu ses go ece du tuguiai go oun sul umau. ");
INSERT INTO bmh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Du in nug du tub wanib banou tamacag, go izal igul sesamoraneu abiu maimai, go du go ze ule muramau, iz ag petak pet awarem, du go Uwait nug i semuramau, aiu ses Mesgai wag ece naliu go petak umau.” ");
INSERT INTO bmh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus nug gonugau tapaimaraneu dudu begurug salau mabun ze awaraimai, go uzan go uteimai, uzan ipal uzan go waiagabtal betei Uwait nugau Ze duailel mareun. ");
INSERT INTO bmh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ze ziwaraneun du, Zon go hiacaranem zau oug daimai, Kristus nug eruneun go ze go doimai, gonugau tapaimaraneu dudu Yesus waugab palautarena, betemen. ");
INSERT INTO bmh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Gonug ag Yesus guzenai kanababun awareun, “Ig abiu du banou tub alamau emen. Na du go ta, ta, ig du tub aiu ses alamaun gumamam ta?” ");
INSERT INTO bmh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesus nug dudu go koli awareun, “Ag ein ze domen, agal ameag nug ein igul uligemen go unum, koli betei Zon auran. ");
INSERT INTO bmh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ameag kumi dudu go koli ametem. Aramag eg dudu go koli abu aidarem. Dudu ebeu suiag gusig (leprosi) mui go koli naliu usalemen. Dabuiag utub dudu go koli ze suban domen. Noumemen dudu go koli awau asem. Ecesab tamacag dudu go Uwait nugau Ze Naliupet domen. ");
INSERT INTO bmh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Du in go iz en ougab petak aimai, go gusig tapai damau, du go gonugau ougab naliu usalamau.” ");
INSERT INTO bmh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zon nugau tapaimaraneu dudu go utei wanena, Yesus nug Zon nugau ze duailel gotulai daremen ebu awareun. Go guzenai kanabarai awareun, “Ag du tamacag uzan em ula ebu Zon waugab ein piabun betemenin? Ag waliwal tub wol nug patena piabun betemenin ta? ");
INSERT INTO bmh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ag ein betei pemenin? Ag du tub tibur galau naliu iweiu arugai dareun betei pemenin ta? Guzeneneg dudu ag tibur galau naliu naliu mui iweiu arugaimai, ag gumaranemen dudu banban agal zau naliu ebu dacanemen. ");
INSERT INTO bmh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bo, ag ein piabun betemenin, iz ailan. Ag Uwait nugau ze tub doimai, awaraneun du piabun betemenin ta? Go petak pet. Iz petak awarem, go Uwait nugau ze doimai, awaraneu du. Gonug Uwait nugau ze doimai, awaranem dudu ipal zilarai dareu. ");
INSERT INTO bmh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uwait nugau ze nug Zon en guzenai ze meun, ‘Uwait nug eneun, “Ag go don, izal ze oi awarabun du palautemin, amegai alai, nait abu tuguiai kalai mizamau.” ’ ");
INSERT INTO bmh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iz ag petak pet awarem, Zon nug em e ebuan duailel unum zilarai dareu. Bo, du in go Uwait nugau ameg ebu wanib banou tamacag, gonug eneu, ‘Uwait izal gumilaneu du banou, iz gonugau pigsal darem’ du go nug Zon zilauroi dareu. ");
INSERT INTO bmh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ze ziwaraneun du, Zon nugau ze maraneun ziwas, zoi zoi ulis, uteu, dudu gusig mui ipal agen Uwait agal Dubanou Ban sul ag gumarabun gusig patai moroi emenin. Gonun, ag Uwait nugau gumarabun igul naliu eg memenin. ");
INSERT INTO bmh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Zon i usalau ebu, getal Uwait nugau ze doimai, awaranemen dudu mui, Moses nugau kasai ze mui, agenag Uwait ig gumigabun alamau aimai ze macanemen. ");
INSERT INTO bmh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dudu go agenag guzenai ze memen, ‘Elaiza koli alamau.’ Ag go dudu agal ze doimai, agal oiagab petak emenin, ag abiu Zon gotal go Elaiza, alamau emenin. ");
INSERT INTO bmh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Duailel dabuiag a, ag ze go don! ");
INSERT INTO bmh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Bo, iz ulisan duailel ag erunai pet awarai? Ag mogoi ginaginamul agen em nogoug ebu hoboi daimai, mogoi ipal abai onabun guzenai ularanem. ");
INSERT INTO bmh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ig duair igarabun en pulel huemun, bo, ag ilanab tam.’ ‘Ig eb noumanemenin kabal wemun, bo, ag manil mab tam.’ ");
INSERT INTO bmh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Zon go zoimai, ziwas ipal ebu go ee mui wain ze mui ur macaneun. Guzenina, duailel agen guzenai ze memenin, ‘Du go gue wes eg go ebu dareu.’ ");
INSERT INTO bmh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bo, Du Nugau Nag aleun, go ee mui wain ze mui zina, duailel agen guzenai ze memenin, ‘Du go uligan! Go ee mui wain ze asi asiu zaneu. Go takis aiwag wanemen dudu mui, igul eg macanemen dudu mui goagal zaiag!’ Ag guzenai ze memenin. Bo, Uwait nugau dabeleu naliu ag aiu ses uligaimai, abe mamamen gonugau igul naliupet pet.” ");
INSERT INTO bmh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Uzan ipal duailel go ebuan, Yesus nug gonugau gugeg beu beu go abai mareun. Go, go uligaimai, goagal igul eg uteimai, go oiagab kekulab tam. Guzenina, Yesus nug uzanan duailel go gusig ze awareun. ");
INSERT INTO bmh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Go eneun, “Korasin uzanan duailel, iz ag bisomagar pem! Betsaida uzanan duailel, ag han bisomagar pem! Iz go gugeg banou beu beu Tair uzanan duailel mui, Saidon uzanan duailel mui, ag gugeg go abai maremin sul zob, go Umus ougan duailel ag oiagab eg ugaba, pigai tibur galau muz tugaimai, waibul ebu hoboi darem zob. Igul go guzenemenin, go agal igul eg ebuan koli oiagab kekulemen! ");
INSERT INTO bmh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Iz ag petak pet awarem, aiu ses Uwait nug koli alai duailel sisiarabun ziwas ebu, Tair mui, Saidon duailel mui, ag uhu banou ginam umam, bo, ulisan duailel ag uhu banou pet umamen! ");
INSERT INTO bmh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ag Kapaneam duailel, ag agtal Mesgai wag simamen ta? Petak pet, ag i simamen. Uwait nug ag ob oug ab banou oug hiacaramau. Gugeg e ag abai marem sul Sodom uzanan duailel ag han guzenai gugeg abai maremin zob, go ulis darem zob! ");
INSERT INTO bmh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Guzenaimai, iz ag awarem, ag guzenai dabilan, Uwait nug koli alai duailel sisiarabun ziwas ebu, Sodom uhu banou ginam umam, bo, ulisan duailel uhu banou pet umam” ");
INSERT INTO bmh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ziwas go ebu Yesus nug eneun, “Mekai, na tutak Mesgai mui, em mui, agal Banou, iz nait wanim ulapwag mizem, einen, na nait igul naliu abiu macanemen duailel mui, abiu mabun betemen duailel agal ameagab ebu wagememen. Bo, na igul naliu go abiu tamacag duailel unum abai maremen. ");
INSERT INTO bmh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mekai igul go petak nagtal nait dabeleu eim guzenemen. ");
INSERT INTO bmh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Izal Mekai nug ece unum izal ebe ebu meun. Du tub nug gonugau Nag i abe macaneu, memeg nugtal go abiu. Du tub nug nag gonugau memeg abe mabun iborain tam, gonugau nag nug sag memeg abiu. Go nag nug duailel gonugtal tapai maraimai, gonugau memeg abai maraba, go han go abe muramam. ");
INSERT INTO bmh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Duailel, ag salau gusig maimai, uhu banou umkoskos gamai aidanemen, ulis ag unum iz waiab alaimai, i mai damamen. ");
INSERT INTO bmh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ag ze e izan ag abai maremin oiban, sesamoramamen. Go a tatau dudu bulumakau beu ebu maimai, ece keuai bitanemen sul. Einen, iz i aisisilaneu, iz duailel suban isanaranem. Guzenemin, agal oiagab iau selai damau. ");
INSERT INTO bmh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ag izal ze sesamoramamen, go uhu banou tam, ag sesamorabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Zuda agal imanem gil tub ebu, Yesus gonugau tapaimaraneu dudu abai go wit ougem ula betemenin. Gonugau tapaimaraneu dudu go we wagena, ougem go ebuan wit dab oimai, zemenin. ");
INSERT INTO bmh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisi dudu ipal agen igul go guzenemen en uligaimai, goagen Yesus auremen, “Na go uligen! Nait tapaimaranemen dudu agen igual imabun gil ebu igul eg go guzenem. Go igual kasai ze etuburacanem.” ");
INSERT INTO bmh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesus nug koli awareun, “Devit gonugau dudu abai we wagena, ein igul minar? Ag ze go nanalemenin ta? ");
INSERT INTO bmh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit gonugau dudu abai we wagena, Uwait nugau Nou Zaueim simai, bret go Uwait moromenin oimai, zinar. Go kasai ze sesamorab tam, bret go dudu gaugaul agen i zanemen, Uwait ula dacanemen dudu sag go zanemen. ");
INSERT INTO bmh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ag Moses nugau kasai ze agau nanalanemen ta, imabun gil ebu Uwait ula dacanemen dudu agen Uwait ecesab muranemen zau banou oug agal salau macanemen. Dudu go ag imabun gil ebu kasai ze suban i sesamoranem, bo, ag Uwait nugau amegwab ze tamacag. ");
INSERT INTO bmh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iz ag petak pet awarem, du tub e dareu gonug Uwait nugau ecesab muranemen zau zilauroi dareu. ");
INSERT INTO bmh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Uwait nugau ze nug guzenai aneu, ‘Ag egun agaimai, iz milamamen, go iz oiab i siksikeu. Ag igul go i guzenan. Dudu ipal ag en bisomag piaraimai, isanaramamen, go petak iz oiab siksikamau.’ Ag ze go bigeg abe maiban, ag dudu ipal igul eg i macanemen goagal enimag ebu guzenai polumaraimai, ag igul eg memenin aimai i awaran. ");
INSERT INTO bmh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Einen, Du Nugau Nag go sag imabun gil gumaneu.” ");
INSERT INTO bmh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus uzan go uteimai, go Zuda agal gotulanemen zaueim sieun. ");
INSERT INTO bmh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Zaueim go du tub go ebeg eg mui dareun. Dudu ipal agen Yesus igul eg tub maba, piabun aimai, go kanabai ze auremen, “Igual kasai ze sesamoraimai, ig igual imabun gil ebu dudu ebeu mui kasarabun iboin ta, tam ta?” ");
INSERT INTO bmh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus nug koli guzenai awareun, “Du tub nugau sipsip imabun gil ebu ob oug numau, ag erunamamen? Ag sipsip go ob ougan i mai umamen ta? ");
INSERT INTO bmh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Du go dorog mui, go sipsip zilauroi dareu, gonun, igual kasai ze nug io aigeun, ig dudu ipal imabun gil ebu isanaramam.” ");
INSERT INTO bmh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Gonug du go ebeg eg mui aureun, “Nait eben henen.” Guzenai aurina, du go nug gonugau ebeg hina, ebeg naliu tub dareu sul, gonugau ebeg naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Guzenina, Parisi dudu go utei beteimai, Yesus wai hiabun en ze patemenin. ");
INSERT INTO bmh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesus go wabun en ze mina doimai, go uzan go utei waneun. Duailel asiu go sesamorai betena, gonug ebeu duailel unum kasareun. ");
INSERT INTO bmh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yesus nug duailel go gusig ze awareun, “Ag iz en duailel ipal i awaran.” ");
INSERT INTO bmh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Go ze go guzenai awareun, go Uwait nugau ze doimai, awaraneun du Aisaia nug ze sikut weun ze go ulis petak usaleu. ");
INSERT INTO bmh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Uwait nug eneun, ‘E izal salau du, go izanag tapai memin, go en izal oiab nug noumeun, go en izal oiab naliu usaleun. Izal Ah Wes go ebu palautemin, gonug koli alai emgasag ipal ebuan duailel sisiarai en ze unum awaramau. ");
INSERT INTO bmh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Go gusig ze i mamau, go abu ebu ze banban ze ze mai i aidamau. ");
INSERT INTO bmh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gonug dudu ipal gusig tamacag darem isanaramau, dudu ipal agen goagal zaiagar gusig tamacag isanaranemen gonug isanaramau. Gonugau salau go meun nug aiu ses gonugau sisiarabun igul naliu sil igul naliu ipal unum zilacaramau. ");
INSERT INTO bmh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Em gasag duailel unum go en goagal oiagab petak aimai, go gumei damam’ ");
INSERT INTO bmh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ziwas go ebu, dudu ipal agen du tub wes eg nug ameg kumi usalaimai, ogusau tapelai meun Yesus waugab imai alemen. Yesus nug wes eg go du go ebuan oi hina, du go ze maimai, go koli ameg ameiteun. ");
INSERT INTO bmh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yesus nug igul guzenina, duailel agen uligaimai, esilakaimai, go enai ze memenin, “Go Devit nugau Mogoi ta, go tam ta?” ");
INSERT INTO bmh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisi dudu ze go doimai, go agen duailel guzenai awaremen, “Go Belsebul, wes eg agal gumaraneu du banou, nug gusig morona, go wes eg oi hiacaneu,” guzenai ze memenin. ");
INSERT INTO bmh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesus goagal dabeleu abe maimai, guzenai ze meun, “Emgasag tub ebuan duailel ag agzozou alalaimai, agzozou doun damamen, ag ziwas huia i damamen. Uzan tub duailel ag han agzozou alalaimai, agzozou doun damamen, ag eg umamen. Ug tub han guzental guzenamam. ");
INSERT INTO bmh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Gonun, wes eg go Satan nugau uzan darem, agal zaiagar abai agzozou alalaimai, agzozou doun damam, ag erunai damamen? ");
INSERT INTO bmh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Agen iz en guzenai ze memenin, ‘Go Belsebul nug gusig morona, go wes eg oi hiacaneun.’ Igul go guzenanem zob, in nug agal tapaimaranemen dudu gusig marena, goagen wes eg oi hiacaranem? Agal tapaimaranemen dudu agen agal ze go iboin tam anem! ");
INSERT INTO bmh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bo, iz Belsebul nug gusig i milaneu, Uwait nugau Ah Wes nug iz gusig milena, iz wes eg oi hiacaranemin. Gonun, ag go abe mamamen Uwait nugau gumarabun ziwas ag waiagab ulis alai dareu. ");
INSERT INTO bmh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Du tub nug du gusig tub nugau zaueim bigagai simai, amegai go zau atag du go ebeg arab us sil kiai maimai, gonugau zauan ece unum umau. ");
INSERT INTO bmh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Duair in izal zai tam, go izal iwai zai. Duair in iz isanileimai, dudu ipal iz waiab imarai alab tam, go duailel zamarina, go wane anemen. ");
INSERT INTO bmh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Gonun, iz ag petak pet awarem, du in go igul eg macaneu mui, ze eg maraneu, Uwait nug igul eg go zilagai imau, bo, du in go Uwait nugau Ah Wes ze biabial kuai auramau, Uwait nug du go nugau igul eg i zilagai muramau. ");
INSERT INTO bmh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Duair in go Du Nugau Nag enib ebu ze eg muraba, Uwait nug go gonugau igul eg zilagai muramau, bo, go Uwait nugau Ah Wes ebu ze eg muramau, Uwait nug ze go ulis i zilagai muramau, aiu ses han i zilagai muramau. Du gonugau igul eg meun go ze a, go guzental muzmuz damau.” ");
INSERT INTO bmh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesus nug koli awareun, “A naliu pianemen, go gonugau dab han naliu. A eg go gonugau dab han eg. Dudu ag a gonugau dab uligaimai, ag abiu macanemen go a naliu ta, eg acanemen. ");
INSERT INTO bmh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ag go don, ag dudu eg, man abau inain sul. Agal oiagab oug igul eg kapai dareu? Agal oiagsau eim ze naliu erunaimai, ze macanemen? ");
INSERT INTO bmh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Du naliu go gonugau dabeleu naliu mui, go ze naliu gonugau ougab oug zuna, ze macaneu. Du eg go gonugau dabeleu eg mui, go ze eg macaneu. Ein dabeleu gonugau ougab oug dareu, go gonugau ogusau eim ze macaneu. ");
INSERT INTO bmh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Uwait nug koli alai em e ebuan duailel sisiaramaun ziwas ebu, ag ein ze gau gaul macanemen, Uwait amegwab erunai ze macanemen ag guzental auramamen. ");
INSERT INTO bmh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Agal ein ze macanemen, go ze nugtal koli ag sisiaramau. Ag ze naliu macanemen, Uwait guzental sisiaraimai, ag duailel naliu amau. Ag ze eg macanemen guzental sisiaraimai, ag duailel igul eg macanemen amau.” ");
INSERT INTO bmh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ziwas go ebu kasai ze tapaimaranem dudu ipal mui, Parisi dudu ipal mui, goagen Yesus auremen. “Abai maranemen du, ulis, nait gugeg tub abai migemen, ig pimam.” ");
INSERT INTO bmh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesus nug koli awareun, “Ag ulisan duailel, ag igul eg macanemen. Ag Uwait nugau ze i sesamoranemen. Agen iz gugeg tub memin, piabun aimai kanabai ailemen ta? Tam pet tam! Iz Uwait nugau ze doimai, awaraneun du Zona nugau gugeg sag go petak abai maremin, ag go petak pimamen. ");
INSERT INTO bmh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zona go amban ainarai, umaum ainarai, go karuk banou nugau ougab oug dareun sul, Du Nugau Nag han guzental, amban ainarai, umaum ainarai mui, go ob oug damau. ");
INSERT INTO bmh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aiu ses, Uwait nug koli alai em e ebuan duailel sisiaramaun ziwas ebu Niniwe uzanan duailel noumemenin koli asaimai, Uwait nugau amegwab ulisan duailel abai ereg tapai daimai, auramam, ‘Ulisan duailel ag igul eg macanemen’. Einen, Niniwe uzanan duailel ag Zona nug Uwait nugau ze mareun, agal igul eg uteimai, koli oiagab kekulaimai, Uwait en agal oiagab petak emen. Iz ag petak pet awarem, ulis e ebu du tub dareu go banou, gonug Zona zilauroi dareu. Ag du banou gonugau ze duabun utemen. ");
INSERT INTO bmh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aiu ses Uwait nug koli alai em e ebuan duailel sisiaramaun ziwas ebu, Siba emgasag gumaraneun air go noumeun koli asaimai, go Uwait nugau amegwab tapai daimai, auramau, ‘Ulisan duailel ag igul eg macanemen’. Einen, go air go abu ebu abu pulig alaimai, gumaraneun du Solomon nugau ze duabun aleun. Iz ag petak pet awarem, e ebu du tub dareu, go banou, gonug Solomon zilauroi dareu. Ag du banou gonugau ze duabun utemen!” ");
INSERT INTO bmh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Yesus nug koli eneun, “Wes eg du enib ougan oi hina, go beteimai, du tamacag uzan imai dabun empip itanamau. Go betei imabun empip i peimai, wes eg go go koli dabeleimai, eneun, ‘Iz koli izal zau muz oug bitai.’ Guzenaimai, go koli betei zau go em kalai suban memenin, gaul dareun peun. ");
INSERT INTO bmh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Peimai, go betei wes eg kwali goagal igul eg pet mui, imaraimai, koli zau oug go ereg dabun alemenin. Gonun, wes eg inain go agen du go ebu igul eg pet mina, go, go gonugau getal eg dareun sul tam, go ulis eg pet pet dareu. Igul go guzental ulisan duailel ebalagab zumau.” ");
INSERT INTO bmh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus go duailel abai zaueim ze marai darena, gonugau anag amagul abai alemen. Go uzaneim alai tapai daimai, guzenai ze memen, “Ig Yesus dual ze mabun alem.” ");
INSERT INTO bmh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gonun, du tub nug piaraimai, gonug simai Yesus aureun, “Nait anan amaiar abai na peizabun go alai uzaneim tapai darem, go na ibaiz ze mabun darem.” ");
INSERT INTO bmh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus nug koli du go aureun, “Izal anikai in? Izal magite inen?” ");
INSERT INTO bmh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Guzenaimai, Yesus nug gonugau tapaimaraneu dudu ebeg sil abai maraimai, awareun, “Ag uligaran, duailel e darem, go izal anikai te magi te! ");
INSERT INTO bmh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Duair in go izal Mekai Mesgai wag dareu gonugau dabeleu sesamoraneu, duair go petak go izal anikai, izal abi, izal magi.” ");
INSERT INTO bmh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yesus go nineun zau uteimai, betei Galili Ze Unig gasag eim hoboi daimai, duailel Uwait nugau Ze mareun. ");
INSERT INTO bmh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Duailel asiu pet alai go waugab gotulaimai kapatotuai darena, go tebil tub wag simai hoboi darena, duailel go ze gasageim tapai daremen. ");
INSERT INTO bmh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Go tatau ze eimantal igul asiu awaraneun. Go guzenai awareun, “Ziwas tub ebu du tub ee ug hiacabun gonugau ougem beteun. ");
INSERT INTO bmh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Go ee ug go ougem eim hiacabun oi betei betena, ee ug ipal abu ebu ululai noun. Guzenina, meg agen zoi oi zemen. ");
INSERT INTO bmh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ee ug ipal ai em ebu nomenin. Em naliu asiu tam, gonun, ee ug go pigai walu zoimai, gau mui usalemen. ");
INSERT INTO bmh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bo, am gusig zoimai, ee ug go walu zomenin unum elareun. Goagal ginib em oug suban nuab tam, gonun, unum gulaleun. ");
INSERT INTO bmh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ee ug ipal eb geleu kulam ziu oug noimai, walu zomenin. Kulam nug oi zina, suban simai useg suban mabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bo, ee ug ipal em naliu ebu nomenin, ee ug go walu zoimai, suban useg memenin. Useg ipal asi asiu pet memenin, useg ipal asiu memenin, useg ipal tutak tutak memenin.” ");
INSERT INTO bmh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesus nug tatau ze go awaraimai, go guzenai ze meun, “Duailel ag dabuiag a aba, ag tatau ze go doimai, bigeg abiu mamamen!” ");
INSERT INTO bmh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesus nugau tapaimaraneu dudu go waugab alaimai, kanabai ze auremen. “Na einen tatau ze eiman duailel ze awaranem?” ");
INSERT INTO bmh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus nug koli guzenai awareun, “Uwait nug duailel gumarabun igul getal wageimai dareun. Ulis ag izal tapaimaranem dudu, gonun, bigeg go abai marem. Bo, duailel ipal go bigeg go abai marab tam. ");
INSERT INTO bmh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Du tub go dabeleu naliu ipal mui, du go Uwait nug dabeleu naliu ipal han muramau. Guzenaba, go dabeleu naliupet pet umau. Bo, du in go dabeleu naliu tamacag, Uwait nug gonugau dabeleu ginampet patai dareu go unum koli ebegalaumau. ");
INSERT INTO bmh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iz tatau ze eim duailel ipal awaranem, iz go guzenemin, ag ein ece agal ameag nug pianemen, bo, ag suban i pianemen, ag ein ze agal dabuiag nug duaneu, bo, ag suban i doimai, bigeg abiu i mamamen. ");
INSERT INTO bmh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gonun, Uwait nugau ze doimai, awaraneun du Aisaia, go dudu go en ze maraneun, ulis petak usaleu. Uwait guzenai ze meu, ‘Ag ze agal dabuiag nug duaneu, bo, ag suban i doimai, bigeg abiu macanemen, ag ece ameag nug pianeu, bo, ag suban i pianemen. ");
INSERT INTO bmh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Duailel go ag suban i dabilanemen, go agal dabuiag utub, ameag kumi dacanemen, Ag igul go i guzenamamen, agal ameag nug ein igul pimamen, agal dabuiag nug ein ze dumamen, agal dabeleu naliu zuba, ag bigeg go abe mamamen, ag agal igul eg uteimai, koli oiagab kekulebi, iz agal igul eg zilagai marai.’ Uwait nug guzenai ze meu. ");
INSERT INTO bmh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ulis, ag izal ze tapaimaranemin dudu, ag agal oiagab naliu usalamau! Agal ameag nug ece pimamen, agal dabuiag nug ze dumamen. ");
INSERT INTO bmh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iz ag petak pet awarem, getal Uwait nugau ze doimai, awaranemen dudu mui, dudu ipal Uwait nugau amegwab naliu dacanemen mui, ag ece go ag ulis uligemen sul piabun en guzenemen, ag i pemen. Ze ulis ag domen sul getalan dudu ag duabun en guzenemen, ag i domen.” ");
INSERT INTO bmh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Guzenaimai, Yesus nug gonugau ze tapaimaraneu dudu guzenai awareun, “Ag du tub nug ougem ee ug heun, tatau ze go gonugau bigeg enai ag go don. ");
INSERT INTO bmh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Dudu asiu ag Uwait nug gonugau duailel gumarabun ze awarina, duanem, gonugau bigeg ag suban i abiu, duailel ag ee ug abu ebu nomenin sul. Guzenina, Satan go pigai ag ebalagab zoimai, Uwait nug gonugau ze agal oiagab oug meun pigai oi hiacaneu. ");
INSERT INTO bmh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ee ug ipal ai em ebu noimai, walu zomenin, go gonugau bigeg enai, duailel ipal ag Uwait nugau ze doimai, pigai siksikanemen. ");
INSERT INTO bmh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bo, ze naliu go agal oiagab oug umkoskos i daneu. Gonun, ze naliu go igul ipal en agal oiagab eg wina, Uwait nugau ze go unum utanemen. ");
INSERT INTO bmh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Duailel ipal ag ee ug eb geleu kulam ziu oug walu zomenin, go gonugau bigeg enai, duailel ipal ag Uwait nugau ze duanemen, bo, ag em e ebuan igul dabeleimai, ece asi asiu en agal oiagab nug noumaimai, Uwait nugau ze utanemen. Ze naliu go ag omenin go eb geleu kulam nug ee ug oi zaneu sul suban i useg macaneu. ");
INSERT INTO bmh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ee ug ipal em naliupet ebu noimai, walu zomenin, go gonugau bigeg enai, duailel ipal ag ze doimai, agal oiagab oug memenin. Ag Uwait nugau ze go bigeg suban abe memenin, ze naliu go omenin ee asi asiu useg macaneu sul, useg ipal asiu pet 100 macaneu, ipal 60 macaneu, ipal tutak tutak 30 macaneu.” ");
INSERT INTO bmh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nug tatau ze tub gonugau ze tapaimaraneu dudu guzenai awareun, “Uwait nugau duailel gumarabun igul enai, du tub nug wit ug naliu gonugau ougem heun. ");
INSERT INTO bmh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Guzenina, umtabag umaum tub duailel unum ninena, du go nugau iwai zaug nug zoimai, gonugau wit ug heun ougem eb geleu ug eg heimai, go utei waneun, ");
INSERT INTO bmh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dai dai, go wit ug walu zoimai, eb geleu eg mui ereg walu zuna, uligemen. ");
INSERT INTO bmh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Go ougem gumanemen salau dudu agen ougem atag du waugab beteimai, guzenai auremen, ‘Banou, ig na ee ug naliu nait ougem hemen aimai dabilanemun. Eb geleu eg go nait ougem erunai usalai dareu?’ ");
INSERT INTO bmh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gonug koli guzenai awareun, ‘Go igual iwai zaicig tub nug go guzeneun.’ Gonugau salau dudu agen koli ougem atag du guzenai auremen, ‘Ig betei go eb geleu eg ulei hemam ta?’ ");
INSERT INTO bmh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Du go nug guzenai awareun, ‘Tam, ag eb geleu eg uleimai, wit mui uleicamamen, gonun, go i guzenan. ");
INSERT INTO bmh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ag eb geleu utebi, wit mui eregtal damam. Aiu ses wit wabun ziwas ebu, ag amegai eb geleu eg oi aimai, sisiaimai, agamamen, wit naliu sag oimai, izal ee macanem zaueim betei mamamen!’” ");
INSERT INTO bmh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus nug gonugau tapaimaraneu dudu tatau ze tub guzenai awareun, “Uwait nug duailel gumaraneu igul enai. Du tub nug a tub wanib paipai dab ginampet pet oimai, gonugau ougem beun. ");
INSERT INTO bmh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Go paipai dab go ginampet pet, ee dab ipal sul tam, bo, go paipai dab walu zoimai, ipal ougeman ee ug unum zilaraneu, go a banou pet usalamau. A go bigeg banou usalina, meg inain go alai a ebeg go ebu teu macanemen.” ");
INSERT INTO bmh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus nug gonugau tapaimaraneu dudu tatau ze tub guzenai awareun. “Uwait nug duailel gumaraneu igul go marasin tub wanib zis sul. Air tub nug zis ginampet oimai, plaua gap 40 ulei oimai, tulaimai, ipulaimai, plaua go neleimai, suai banou zuaneu.” ");
INSERT INTO bmh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ze asiu go Yesus nug duailel tatau ze eim awaraneu, go ze tub araog awarab tam, go tatau ze eim sag awaraneu. ");
INSERT INTO bmh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Go tatau ze maraneu go Uwait nugau ze doimai, awaraneun du nug duailel awaraneun, ze go ulis petak usaleu. Gonug guzenai sikut weun, ‘Iz tatau ze eim duailel ze awaranem. Ze, em e usalai meun ziwas ebu, zoizoi ulis wageimai dareun, iz ag awarem.’ ");
INSERT INTO bmh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesus go dudu asiu utaraimai, go zaueim sieun, gonugau tapaimaraneu dudu agen zoimai, guzenai auremen, “Na ig eb geleu ug eg ougem walu zoun nugau tatau ze bigeg en aigamam.” ");
INSERT INTO bmh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus nug koli guzenai awareun, “Du ee ug naliu heun, go Du Nugau Nag. ");
INSERT INTO bmh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ougem go em e, ee ug naliu go Uwait nug gumaraneu duailel, eb geleu eg go ag Satan nugau duailel. ");
INSERT INTO bmh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Eb geleu ug eg ougem heun du, go igual iwai zaicig, Satan. Ougem nugau ee ug wabun ziwas igual Uwait nug koli alai duailel sisiaramau, ee wabun dudu go Uwait nugau tibur. ");
INSERT INTO bmh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Eb geleu eg sisiaimai, ab ebu agamam, aiu ses Uwait nug sisiaramaun ziwas ebu, em e ebu guzental guzenaramam. ");
INSERT INTO bmh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Du Nugau Nag nug gonugau tibur palautaraba, alaimai, goagen Uwait nugau duailel ula ebu duailel ipal igul eg mabun emen mui, dudu ipal ereg igul eg macanemen abai unum oi hiacaramau. ");
INSERT INTO bmh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Duailel go ab banou elei dareu, oug hiacaramam, go ab oug noi weinaimai, goagal aiag katutai damam. ");
INSERT INTO bmh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ziwas go ebu, Uwait agal memeag nug duailel gumarabun igul araog zuba, duailel oiagab petak emen ag am nugau al sul hilamamen. Duailel ag dabuiag a, go ze doimai, bigeg abiu mamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus nug guzenai ze meun, “Em ebuan duailel ag Uwait nugau duailel usalabun go enai, du tub nug gonugau aiwag asiu ot oug maimai, gonugau ougem wageimai meun. Du go noumina, du tub nug aiwag ot go uligaimai, gonug koli wageimai meun. Go siksikaimai, gonugau ece unum dudu ipal marena, gau mina, gonug aiwag go oimai, betei ougem go gau meun. Guzenaimai, aiwag ot oug dareun, gonugau usaleun.” ");
INSERT INTO bmh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus nug koli eneun, “Uwait nug duailel gumaraneu igul tub go enai. Du tub go aiwag naliu wanib kelek, aiwag banou sil gau mabun itanai ai dareun. ");
INSERT INTO bmh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Go aiwag wanib kelek naliupet pet tub uligaimai, go koli betei gonugau ece unum dudu ipal marena, gau mina, gonug han aiwag go oimai, betei go aiwag kelek naliu gau meun. Guzenaimai, go aiwag kelek gonugau pet usaleun.” ");
INSERT INTO bmh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus nug kolital eneun, “Uwait nug duailel gumaraneu gonugau igul tub go enai. Karuk wanemen dudu ipal agen karuk wabun zo ze unig oug heimai, karuk asiu eg mui, naliu mui, gaul omenin. ");
INSERT INTO bmh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Karuk asiu nug zo kapina, go karuk zo mui patai keuina, gasageim alina, go hoboimai, karuk sisiaremen. Karuk naliu go agal tebil oug memen, karuk eg hamaremen. ");
INSERT INTO bmh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Tatau ze go gonugau bigeg enai, Uwait nug koli alai duailel sisiaramaun ziwas ebu, gonugau tibur agen Satan nugau duailel go Uwait nugau duailel abai ereg gotulai darem ebuan sisiai imaraimai, ab banou muzmuz elei dacaneu ebu betei, ab unig oug hiacaraba, goagal aiag kititkatitai, weinai damam.” ");
INSERT INTO bmh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus nug gonugau tapaimaraneu dudu kanabarai awareun, “Ag ze go bigeg ag abiu ta?” Goagen koli go auremen, “Io, ig abiu.” ");
INSERT INTO bmh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesus nug guzenai awareun, “Ze go gonugau bigeg enai. Kasai ze tapaimaraneu du go Uwait nugau gumarabun igul abiu maimai, go izal tapaimaranem du usalabun, go simai, zauan go ece muzin mui awau mui oi alaneu.” ");
INSERT INTO bmh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus go, go tatau ze awaraimai, uzan go utei waneun. ");
INSERT INTO bmh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Guzenaimai, gonugau muz uzan koli beteun. Go duailel goagal gotulanemen zaueim simai, Uwait nugau ze mareun. Duailel agen gonugau ze doimai, esilakemenin. Guzenaimai, goagen guzenai ze memenin, “Du go dabeleu naliu mui, igul go eruan oun? ");
INSERT INTO bmh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Go gugeg beu beu mabun gusig eruan oun? Go igual zau macaneun du nugau nag tam ta? Maria go gonugau anag ta? Zems, Zosep, Saimon, Zudas go gonugau amagul ta? ");
INSERT INTO bmh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gonugau abiagul e ebu darem ta? Go igul go eruan oun?” ");
INSERT INTO bmh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Go guzenai ze maimai, Yesus semoromenin. Guzenina, Yesus nug guzenai awareun, “Uzan ipal Uwait nugau ze doimai, awaraneun du, go wanib ulagwag a, duailel agen goagal oiagab eim go en petak anemen, bo, nug nugau uzan wanib ulagwag tamacag, gonun, gonugau duailel mui, gonugau ug mui agenag go semoromenin.” ");
INSERT INTO bmh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Go ebuan duailel agal oiagab petak ab tam, gonun, go uzan go igul ipal asiu abai mab tam. ");
INSERT INTO bmh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","12","Ziwas go ebu, Herot-Antipas go Galili agaig gumaneun du banou. Getal Herot nug gonugau amag Pilip nugau wau Herodias ebegalacoun. Guzenina, ze ziwaraneun du, Zon nug Herot guzenai aureun, “Na nait amai nugau air Herodias omen. Go na kasai ze etuboromen!” Zon nug guzenai aurina, Herot go Zon wai hiabun dabeleun, bo, go Zuda duailel agen Zon go Uwait nugau ze doimai, awaraneun du tub anemen. Guzenaimai, Herot go, go darena, uligaraimai, uminareun. Uminaimai, go dudu ipal awarina, beteimai, Zon ebegarab durub waimai, ebeg us sil kiaimaimai, hiacaranemen zau oug hemen. Herot gonugau anag nug soligweun gil zuna, duailel asiu gotulaimai, go dual oiagab siksikai mui ee zai daremen. Gil go ebu, Herodias gonugau aleg go duailel ameagab ebu zoi ilanai dareun. Guzenina, Herot go ainag magun guzenai uligaimai, gonugau ougab naliu meun. Go ainag magun go dual baib maimai, gonug guzenai aureun, “Iz petak pet aizem, na ein ece wabun iz ailemenag, izan na unum mizai.” Go ainag nug gonugau anag kanabai auraimai, go anag nugau dabeleu oimai, koli alai Herot guzenai aureun, “Na ze ziwaraneun du, Zon nugau beu kuataiba, gonugau gagalig kuatemen tebil tub oug maimai, oi alai milen.” Ainag gonug Herot guzenai aurina, go doimai, go ougab uhu usaleun. Bo, duailel go dual hoboi ee zai daremen goagal ameagab ebu ainag go dual baib maimai, petak ze meun ze dabeleimai, go utabun iborain tam. Guzenaimai, go ainag gonugau ze sesamoraimai, gonugau salau du aureun, “Na beteiba, Zon nugau beu kuaten.” Gonugau salau du tub guzenai aurina, go betei Zon hiacaranemen zau oug an ebu beu kuatai heun. Zon nugau gagalig kuatai heun tebil tub oug maimai, oi alaimai, ainag go morona, gonug han oi betei gonugau anag moroun. Zon gonugau tapaimaraneun dudu agen gonugau enib sag oimai, betei ob oug hemen. Dai dai, Herot nug Yesus nugau salau meun ze doimai, gonug gonugau salau dudu guzenai awareun, “Go ze ziwaraneun du, Zon go noumeun koli ob ougan koli asai zoun, gonun, go gugeg beu beu mabun gusig a.” ");
INSERT INTO bmh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus go Zon noumeun ze doimai, go tebil oimai, uzan go uteimai, nugtal du tamacag uzan em ula ebu waneun. Guzenina, duailel go Yesus waneun ze doimai, goagal uzan uteimai, abu eim go sesamorai betemen. ");
INSERT INTO bmh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesus go gasageim betei i maimai, tebil ougan noimai, duailel asiu daremen uligaraimai, go en bisomag piaraimai, duailel ipal ebeu a kasareun. ");
INSERT INTO bmh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yesus nugau tapaimaraneu dudu agen umusig ee zabun ziwas ebu go zoimai guzenai auremen, “Em umuteu, du tamacag uzan e darem. Na duailel palautaremen, goagal uzan beu beu betei ee gau maimai, zimam.” ");
INSERT INTO bmh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Guzenai aurina, Yesus nug koli gonugau tapaimaraneu dudu guzenai awareun, “Duailel go eru eim unamam? Agenag ee zabun maran.” ");
INSERT INTO bmh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Goagen koli go guzenai auremen, “Ig ee asiu oi alab tam, bret tabkuai mui, karuk aliag mui, oi alemun dareu.” ");
INSERT INTO bmh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesus nug gonugau tapaimaraneu dudu awareun, “Ee go oi alai iz milan.” ");
INSERT INTO bmh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Go duailel awarina, go gig ebu hoboi darena, gonug bret tabkuai go mui, karuk aliag mui oimai, Mesgai wag ameitaimai, Uwait ‘Ese-e’ aureun. Go bret go kikakaraimai, gonugau tapaimaraneu dudu marena, goagen oimai, duailel marena, zemenin. ");
INSERT INTO bmh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Duailel unum ee go zaimai, biguiag zoun. Ee ogog go darena, Yesus nugau tapaimaraneu dudu agen gom gau zo begurug oimai, zulagai mina, go gom gau zo unum kapeun. ");
INSERT INTO bmh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ee zemenin dudu tausen tabkuai (5,000), ailel, geleagar aleagar abai, go ee zemenin nanalab tam. ");
INSERT INTO bmh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Guzenaimai, Yesus nug gonugau tapaimaraneu dudu awarina, “Go tebil wag simai, Galili Ze Unig tubaim amegai bitamam.” Awaraimai, nug daimai, duailel palautarena, goagal uzan unamamen aimai awareun. ");
INSERT INTO bmh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Go duailel palautarena, wanena, go nugtal em manam wag simai, Uwait aurai dareun. Umusig, em umutai alina alina, Yesus nugtal go ebu darena, tebil go gonugau tapaimaraneu dudu agen oi betemen go ze unig ban ula ebu betena, wol banou zoimai, tebil go patena, ze nug tebil go kulai mamoroi eun. ");
INSERT INTO bmh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Umaseu, em hilai zuna zuna, am ameg ainarai betei, am ameg wasolig ebu sul, Yesus go koli gonugau tapaimaraneu dudu daremen ebu ze unig wag ebu tapai tapai aleun. ");
INSERT INTO bmh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gonugau tapaimaraneu dudu agen go ze wag tapai tapai alina, uligaimai, go banban uminemen. Guzenai ze memen, “Go eb dorog!” Guzenaimai, go banban uminaimai, eg pet piecemenin. ");
INSERT INTO bmh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pigai Yesus nug awareun, “Ag gusig dan. E izanag. Ag i uminan!” ");
INSERT INTO bmh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita nug koli guzenai aureun, “Dubanou Ban, go petak na darem aba, iz ailemen, ze wag na darem ebu bitai.” ");
INSERT INTO bmh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus nug koli aureun, “Io, na alen!” Guzenai aurina, Pita go tebil wag an silikai noimai, ze wag Yesus dareun ebu beteun. ");
INSERT INTO bmh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Guzenina, Pita go wol banou nug ze ban oug kulai mamoroi ina, uligaimai, go banban uminaimai, uleun, “Dubanou Ban, na iz isanilen!” ");
INSERT INTO bmh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus nug gonugau ebeg pigai pataimai, guzenai aureun, “Nait ounab petak emen go ginampet pet. Na einen dabeleu aliag omen?” ");
INSERT INTO bmh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesus go Pita dual koli betei tebil ebu sina, wol maziceun. ");
INSERT INTO bmh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yesus nugau tapaimaraneu dudu go tebil oug daremen go gonugau wanib ulagwag moromen. Go guzenai ze memen, “Petak pet, na Uwait nugau Nag.” ");
INSERT INTO bmh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesus gonugau tapaimaraneu dudu abai, go Galili Ze Unig hei beteimai, Genesaret em gasag betemen. ");
INSERT INTO bmh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Go ebuan duailel go abe memen go Yesus aleu. Guzenaimai, goagen ze palautina, em go ebuan duailel ipal ebeu mui Yesus waugab imarai alemen. ");
INSERT INTO bmh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Duailel ipal agen Yesus guzenai gusig auremen, “Na ebeu duailel go utaremen, goagen alai nait tibur galau siugal patamam.” Guzenaimai, ebeu duailel agal ebeag nug Yesus nugau tibur galau patena, unum naliu usalemen. ");
INSERT INTO bmh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisi dudu ipal, kasai ze tapaimaranem dudu mui, go Zerusalem uzanan alaimai, Yesus guzenai kanabai ze auremen, ");
INSERT INTO bmh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Einen nait tapaimaranem dudu agen igual asaniger agal kasai ze i sesamoranem? Ag ee zabun agal ebeag kasai ze meun sul i ulusanemen.” ");
INSERT INTO bmh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesus nug koli awareun, “Ag einen Uwait nugau ze i sesamoranemen, ag agal asanagar agal igul sag sesamoranemen? ");
INSERT INTO bmh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Uwait nug eneun, ‘Na nait memen anan nugau ze sesamoren.’ Go koli eneun, ‘Du in go gonugau memeg anag ze biabial kuai auramau, dudu ipal agen go webi, noumamau.’ ");
INSERT INTO bmh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bo, ag guzenai ze macanemen, ‘Du in go ece mui, gonugau memeg anag dual isanarabun iboin, bo, go ag awaraneu. “Iz ece go Uwait murabun sag tapai memin dareu. Guzenaimai, iz ag isanarabun iborain tam.” ’ ");
INSERT INTO bmh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ag Parisi dudu guzenai ze macanemen, ‘Go iboi, go gonugau memeg anag i isanaramau.’ Go igul ebu ag Uwait nugau ze tonoi maimai, agal asanagar agal ze sag petak sesamoranemen. ");
INSERT INTO bmh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ag polumanemen dudu! Uwait nugau ze doimai, awaraneun du, Aisaia nug ag en petak ze meun. Go guzenai sikut weun, ");
INSERT INTO bmh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Uwait nug eneun, “Duailel go agen gaul oiagsau nug izal wanim ulapwag macanem, bo, agal oiagab nug iz en noumab tam. Ag izal ze awaranem ag suban i sesamoranem. ");
INSERT INTO bmh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ag du tub nugau kasai ze sesamoraimai, ag guzenai ze macanem go Uwait nugau ze. Ag polu ze sesamoraimai, ag izal wanim gaul ulapwag macanem!” ’” ");
INSERT INTO bmh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesus nug duailel asiu ularena, go waugab alina, guzenai awareun, “Ag ze e awarai doiban, suban abe macan! ");
INSERT INTO bmh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Du tub go ee zaneu gonug Uwait nugau amegwab unu i muraneu. Dabeleu eg ougab oug dareu asina, gonugau ogusau nug ze maneu gonug petak go unu muraneu.” ");
INSERT INTO bmh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ziwas go ebu, gonugau tapaimaraneu dudu agen go waugab alaimai, guzenai auremen, “Na ze go ze memen en Parisi dudu ze go doimai, goagal oiagab eg weun, na go abiu ta?” ");
INSERT INTO bmh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesus nug koli gonugau tapaimaraneu dudu awareun, “Izal Mekai go Mesgai wag dareu, go ougem a. Ee ug, ebeg sil bab tam, go unum goagal ginib mui silaicamau. ");
INSERT INTO bmh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ag dudu go utarebi, damam. Dudu go ameag kumi, ag zaiagar ipal ameag kumi abu abai marabun iborain tam. Du ameg kumi tub gonug ameg kumi zaug tub abu abai morom aimai, go zaug dual ereg alanoimai, ob oug numam.” ");
INSERT INTO bmh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Guzenai ze mina, Pita nug Yesus guzenai aureun, “Na tatau ze go bigeg ig aigemen, dumam.” ");
INSERT INTO bmh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus nug awareun, “Iz ag ze asiu abai maremin, bo, agal dabeleu naliu usalab tam. ");
INSERT INTO bmh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ag igul go i abiu ta? Ein ee zanemen go biguiag oug noi daneu, go koli biguiag ougan alaimai, nuaneu. ");
INSERT INTO bmh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bo, dabeleu eg oiagab oug daneu asina, oiagsau eim zuaneu, dabeleu gonug sag duailel petak unu maraneu. ");
INSERT INTO bmh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Oiagab eim, duailel go dabeleu eg guzenai wanemen: Ag duailel ugarina, noumabun dabilanemen, ag du omenin ailel eg marabun dabilanemen, ag igul eg pet ipal mabun en dabilanemen, ag ece zob wabun dabilanemen, ag ece uligaimai, ameag nug alaneu, ag polu ze mabun, duailel enimag ebu ze mabun mui dabilanemen. ");
INSERT INTO bmh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Igul eg go gonug duailel unu maraneu. Bo, ag ebeag ze ulusab tam, ee zanemen gonug duailel Uwait nugau amegwab unu i maraneu.” ");
INSERT INTO bmh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus gue uzan go uteimai, emgasag tub Tair ban uzan mui Saidon ban uzan ula ebu beteun. ");
INSERT INTO bmh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanan air tub go uzan go dacaneun, go zoimai, Yesus aureun, “Du banou, na Devit nugau Ug, na iz en bisom peiba, iz isanilen! Izal ainag wes eg nug unum eg wai moroun dareu.” ");
INSERT INTO bmh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bo, Yesus nug air go koli ze tub aurab tam. Gonugau tapaimaraneu dudu agen go waugab zoimai, guzenai auremen, “Air gue, go ig sesamigai alaimai, ul mui alai dareu, gonun, na go palautemen, koli unamau!” ");
INSERT INTO bmh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Guzenina, gonug koli awareun, “Israel duailel ag sipsip sul gumarabun du tamacag. Izal mekai nug go Israel duailel ag en sag iz palautilena, gumarabun alemin.” ");
INSERT INTO bmh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Guzenai awarina, air go gue Yesus waugab zoimai, patai weinaimai, guzenai aureun, “Du banou, na iz isanilen.” ");
INSERT INTO bmh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesus nug koli guzenai aureun, “Ig mogoi agal ee oimai, bau hamacai i maranem. Go igul eg.” ");
INSERT INTO bmh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Guzenina, air gonug Yesus guzenai aureun, “Du banou, na petak ze mem, bo, bau agal memeagar eebiz ebu ee zina, ee sibsib em ebu nuna, goagal bau agen go ee sibsib oi zanemen.” ");
INSERT INTO bmh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Guzenina, Yesus nug air go aureun, “Air, nait ounab petak emen go banou pet! Nait ein igul iz na isanizabun ailem, go isanizai.” Yesus air go guzenai aurinatal, air gonugau aleg go koli naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus go uzan go uteimai, Galili Ze Unig gasageim beteun. Go em manam tub ebu simai, hoboi dareun. ");
INSERT INTO bmh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Duailel ipal agen duailel asiu, ameag kumi, aramag eg, oiagsau tapeleun, ebeu dudu ipal mui, go Yesus waugab imarai alai memenin. Gonug duailel go ebeu mui unum kasareun. ");
INSERT INTO bmh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Guzenina, go igul go meun uligaimai, go dabeleu asiu omenin. Oiagsau tapeleun dudu go koli suban ze memenin, aramag ilueun dudu go koli tuguiai tapemenin, ameag kumi dudu go ametaimai, ece pemenin, i aidanemen aramag eg dudu go koli aidanemenin, dudu ipal go ebeu beu beu mui go naliu memenin. Guzenina, duailel goagen Israel agal Uwait wanib ulagwag moromenin. ");
INSERT INTO bmh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus nug gonugau tapaimaraneu dudu ularena, alina, guzenai awareun, “Iz duailel e gil ainarai ee tamacag ig ibaig ereg gaul daremen uligaraimai, bisomag pem. Go abu ebu betei we en noumamam. Gonun, iz gaul goagal uzan palautaremin, i unamam.” ");
INSERT INTO bmh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gonugau tapaimaraneu dudu agen koli guzenai auremen, “Ig du tamacag uzan e darem, duailel e asiu, ig ee eruan oimai, duailel maremun, zimam?” ");
INSERT INTO bmh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesus nug koli awareun, “Ag bret eiceisab dareu?” Goagen koli auremen, “Ig ee asiu oi alab tam, bret kwali mui, karuk ipal ginaginam mui dareu.” ");
INSERT INTO bmh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Guzenina, Yesus nug koli duailel em ebu hubamam aimai awarina, go hobomen. ");
INSERT INTO bmh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Gonug bret kwali mui, karuk mui oimai, Uwait ‘Ese-e’ aureun. Guzenaimai, gonugau tapaimaraneu dudu marena, goagen han duailel go marena, zemenin. ");
INSERT INTO bmh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Duailel go ee go zaimai, unum biguiag zoun. Ee ogog ipal utemenin Yesus nugau tapaimaraneu dudu agen gom gau zo kwali oimai, ee zemenin ogog go zulagai mina, kapeun. ");
INSERT INTO bmh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ee zemenin dudu go tausen iwanarai (4,000), bo, ailel geleagar aleagar abai go nanalab tam. ");
INSERT INTO bmh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Gonun, Yesus nug duailel go palautarena, goagal uzan wane anena, go tebil wag simai, Magadan em ebu beteun. ");
INSERT INTO bmh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi dudu ipal, Sadiusi dudu mui, goagen Yesus polumurabun alemenin. Goagen Yesus auremenin, “Na gugeg tub abai migen. Guzenemen, ig abiu mamam, na Uwait Mesgai wag dareu nugtal gusig go mizaneu.”  ");
INSERT INTO bmh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bo Yesus nug koli guzenai awareun, “Ag umusig am noimai, emes epelina, uligaimai, ag guzenai ze macanemen, ‘Tuaba gil naliu.’ ");
INSERT INTO bmh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Umaseu ag emes epelaneu mui, pi mutuaneu mui, uligaimai, guzenai ze macanemen, ‘Ze numau.’ anemen. Ag emes uligaimai, igul go ag petak abiu macanemen. Bo, ein igul ulis zou, ag bigeg go i abiu. ");
INSERT INTO bmh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ag duailel eg, ag Uwait nugau igul naliu i sesamoranemen! Agen iz gugeg tub memin, piabun kanabai ailemen ta? Bo, iz ag gugeg go i abai marai! Zona nugau gugeg tutak abai maremin, go petak ag pimamen.” Guzenai awaraimai, Yesus go utarai waneun. ");
INSERT INTO bmh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus nugau tapaimaraneu dudu go dabuiag sikena, bret ipal i omen, go gaul Galili Ze Unig heimai, tubaim betemenin. ");
INSERT INTO bmh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus nug gonugau tapaimaraneu dudu guzenai awareun, “Ag Parisi, Sadiusi dudu, goagal bret agena, neleimai suaizuaneun marasin wanib zis go suban uligan.” ");
INSERT INTO bmh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Agzozou guzenai ze maimai, enemen, “Ig bret oi alab tam, gonun, go ze go aigeu.” ");
INSERT INTO bmh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesus goagal ze ze mai daremen abiu maimai, gonug guzenai kanabai awareun, “Ag einen guzenai ze mai daremen? ‘Ig bret oi alab tam.’ Agal oiagab petak emen go ginampet! ");
INSERT INTO bmh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bo, ag dabeleu naliu tamacag ta? Iz bret tabkuai oimai, kikakaraimai, dudu tausen tabkuai (5,000) marena, zemenin, ag go en dabelab tam ta? Ag gom gau zo eiceisab oimai, bret ogog zulagai mina, kapeun? ");
INSERT INTO bmh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","11","Ziwas tub ebu, iz bret kwali oimai, dudu tausen iwanarai (4,000) marena, zemenin ag go en dabeleu omen ta? Ag gom gau zo eiceisab oimai, bret ogog oi zulagai mina, kapeun? Ag einen go dabelab utemen? Ulis iz ag bret en awarab tam. Iz ag Parisi, Sadiusi dudu mui, agal zis go suban piabun aimai iz ag awarem!” ");
INSERT INTO bmh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Guzenina, gonugau tapaimaraneu dudu go koli abe memenin. Yesus go bret agena, neleimai suaizuaneun marasin wanib zis go en awarab tam, bo, go Parisi, Sadiusi dudu mui, goagal ze tapaimaranemen suban sisiarabun en awareun. ");
INSERT INTO bmh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus gonugau tapaimaraneu dudu abai go Sisaria-Pilipai agaig ebu beteimai, gonugau tapaimaraneu dudu guzenai kanabai awareun, “Duailel agen Du Nugau Nag go in anem?” ");
INSERT INTO bmh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Go koli auremen, “Duailel ipal agen guzenai ze macanem, ‘Go ze ziwaraneun du, Zon.’ Duailel ipal agen guzenai ze macanem, ‘Go Elaiza.’ Duailel ipal agen enanem, ‘Go Zeremaia ta, go Uwait nugau ze doimai, awaraneun du tub ta.’” ");
INSERT INTO bmh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Guzenai aurina, Yesus nug gonugau tapaimaraneu dudu awareun, “Agenag iz en in anemen?” ");
INSERT INTO bmh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon-Pita nug koli aureun, “Na Kristus, na Uwait, awau muzmuz dacaneu, gonugau nag.” ");
INSERT INTO bmh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus nug Saimon koli guzenai aureun, “Saimon, Zona nugau nag, na siksiken! Em ebuan du tub nug ze go na aizab tam, bo, nait ze go izal mekai Mesgai wag dareu, nugtal na abai mizeun. ");
INSERT INTO bmh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Gonun, iz na aizem, na Pita, aitabag sul. Iz izal duailel aitabag go wag gotularai, bo, noumabun igul nug duailel go i zilaramau. ");
INSERT INTO bmh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iz nait wanim banou mizem. Na duailel sisiaraimai, du tub guzenai auramam, ‘Na igul go guzenabun iboin.’ Na du tub guzenai auren, ‘Na igul go i guzenen.’ Duair in na em ebu auramam, ‘Na igul go i guzenen,’ Uwait nug han Mesgai wag guzental auramau. Duair in na em ebu auramam, ‘Na igul go guzenabun iboin.’ Uwait nug han Mesgai wag guzental auramau.” ");
INSERT INTO bmh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Guzenaimai, Yesus nug gonugau tapaimaraneu dudu ze guzenai awareun, “Ag duailel ipal guzenai i awaran, ‘Yesus go Kristus.’” ");
INSERT INTO bmh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ziwas go ebu, Yesus nug gonugau tapaimaraneu dudu araog ze mareun, “Iz Zerusalem uzan betemin, go ebuan dudu banban mui, Uwait ula dacanemen dudu banban mui, kasai ze tapaimaranem dudu go, agen iz mu banou milamam. Iz mu banou mileimai, goagen iwebi, noumanai, bo, gil ainarai ebu, iz koli asanai.” ");
INSERT INTO bmh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita nug Yesus wage wageimai gasageim ze gusig aurabun imai waneun. Pita nug guzenai ze gusig aureun, “Tam pet! Igul go na ebizab i zumau!” ");
INSERT INTO bmh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Guzenina, Yesus nug koli kekulaimai, Pita guzenai aureun, “Satan, na iz seiab beten! Na izal ame zoi i tapelai dan, iz abu piamoroi. Na dudu agal dabeleu sag sesamoranem, na Uwait nugau dabeleu naliu i sesamoranem.” ");
INSERT INTO bmh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Go Pita guzenai auraimai, go gonugau tapaimaraneu dudu awareun, “Du in iz sesamilai zuabun, go nug en i dabilamau, go gonugau a gegeulanau nugtal gamacaimai, iz sesamilamau. ");
INSERT INTO bmh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Du in go gonugau dorog awau dabun dabilaneu, go gonugau dorog eg umau. Bo, du in gonugau dorog iz en noumaneu, du go gonugau dorog muzmuz suban naliu damau. Go naliu dabun abu itanamau. ");
INSERT INTO bmh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Du tub em ebuan ece unum umau, go noumamau. Ece gonug gonugau dorog awau dabun erunai isanuramau? Go ein ece oimai, koli gonugau dorog awau dabun gau mamau? Tam, go koli nugtal gonugau dorog gau mabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bo, Du Nugau Nag gonugau memeg nugau al mui, gonugau tibur inain abai ereg alaimai, duailel sisiaramau. Duailel inen ag igul naliu macanemen, go ece naliu maramau. Duailel inen ag igul eg macanemen, go ece i maramau. Go duailel unum sisiaramau. ");
INSERT INTO bmh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iz ag petak pet awarem, dudu ipal ag ulis em e ebu daremen, ipal noumabun uhu unum i pimamen, bo, ag dabi dabi, Du Nugau Nag gumaraneun du banou sul alaba, ag pimamen.” ");
INSERT INTO bmh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gil wasolig uteimai, Yesus nug Pita, zaug Zems, gonugau amag Zon mui go sag gonug imaraimai, em tabag banou tub wag siemen. ");
INSERT INTO bmh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Go agal ameag ebu, Yesus nugau enib kekulaimai, ataipet usaleun uligemen. Gonugau siameg am ameg sul uligemen, gonugau tibur galau han am nugau hilaneu sul. ");
INSERT INTO bmh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Guzenina, Moses, zaug Elaiza dual zoimai, Yesus dual ze ze mai darena, uligaremen. ");
INSERT INTO bmh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Guzenaimai, Pita nug Yesus guzenai aureun, “Dubanou Ban, ig e ebu dabun naliu! Na ze memen, iz e ebu agal zau ainarai manai, tub nait, tub Moses nugau, tub Elaiza nugau.” ");
INSERT INTO bmh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Go guzenai zeze mai darena, pi tub ausiau pet alai kularena, Uwait nug ze tub pi go oug guzenai ze mareun, “Go mogoi go petak izal nagwai pet, iz go en izal oiab nug noumaneu, iz gonugau igul uligaimai, izal oiab naliu meu. Ag gonugau ze dumamen!” ");
INSERT INTO bmh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ziwas go ebu, Yesus gonugau tapaimaraneu dudu agen zeu go doimai, go banban uminaimai, em ebu gabuai mai oiag tonoi eim daremen. ");
INSERT INTO bmh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Guzenina, Yesus go waiagab zoimai, pataraimai, gonug guzenai awareun, “Ag asan. Ag i uminan!” ");
INSERT INTO bmh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Guzenina, go asaimai, goagal ameag nug uligemen, go du tub piab tam, Yesus nugtal dareun uligemen. ");
INSERT INTO bmh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yesus gonugau tapaimaraneu dudu abai em tabag utei noi noimai, go guzenai ze awareun, “Ag igul e ag ameagab ebu usaleun uligemen ag betei duair i awaran, bo, Du Nugau Nag noumaimai, koli ob ougan usaba, ziwas go ebu ag ein igul uligemen go petak duailel awaran.” ");
INSERT INTO bmh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bo, Yesus nugau tapaimaraneu dudu agen go guzenai kanabai ze auremen, “Kasai ze tapaimaranem dudu agen einen Elaiza go amegai alamau aimai ze manem?” ");
INSERT INTO bmh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus nug koli guzenai awareun, “Ag go petak ze macanemen, Uwait nugau ze nug guzenai ze meun, Elaiza go amegai alaimai, go koli ece unum suban mamau. ");
INSERT INTO bmh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bo, iz ag petak awarem, Elaiza go amegai aleun, duailel ag go suban abe mab tam, agen agal dabeleu eim igul eg beu beu go ebu memenin. Ag go guzenai daremen sultal agal igul eg Du Nugau Nag ebu guzenamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Go guzenai ze mina, gonugau tapaimaraneu dudu go abe memen, go ze ziwaraneun du, Zon nug en ze meu aimai ze memen. ");
INSERT INTO bmh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Yesus gonugau tapaimaraneu dudu abai duailel asiu gotulai daremen ebu betena, du tub nug Yesus waugab zoimai, taubib aimai, eneun, “Dubanou Ban, na izal nagwai bisou peiba, kasen! Go ebeu eg oimai, siloisiloianeu. Go guzenina, umkoskos ab oug nuaneu. Ipal ziwas ebu, ze oug nuaneu. ");
INSERT INTO bmh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iz nait tapaimaranem dudu go waiagab imai alemin, bo, goagen go kasurabun iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus nug duailel en acegsisilaimai, awareun, “Ei, einen agal oiagab petak ab tam! Ag gagaliag gusig macanemen. Gil eiceisab iz koli ag abai danai? Gil eiceisab iz ag en koli agal uhu gamahai. Ag mogoi go iz waiab imai alan.” ");
INSERT INTO bmh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Go mogoi go imai alina, Yesus nug wes eg go mogoi go ebu dareun gusig ze aurina, ziwas go ebutal wes eg mogoi go utei waneun. Mogoi go koli naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Go guzenina, Yesus nugau tapaimaraneu dudu agen wage wageimai zoimai, Yesus guzenai kanabai ze auremen, “Ig einen wes eg go oiabun iborain tam?” ");
INSERT INTO bmh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus nug koli awareun, “Ag agal oiagab petak emen go ginampet pet. Gonun, ag iborain tam. Iz ag petak awarem, agal oiagab petak emenin paipai a ug ginampet go sul, agen em tabag e guzenai auramamen, ‘Na e eiman asaiba, ulib e beten,’ guzenai aurebi, go bitamau. Agal oiagab petak pet anemen, ag ein salau mabun go mamamen. ");
INSERT INTO bmh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Bo, abu tub eiman wes eg go oiabun iborain tam. Uwait auraimai, ee ur maimai, go eim sag petak guzenamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ziwas tub ebu, Yesus gonugau tapaimaraneu dudu abai ereg Galili bitabun bete betei, gonug guzenai awareun, “Dudu ipal agen Du Nugau Nag ebegarab durub waimai, dudu ipal agal ebeag ebu mamam. ");
INSERT INTO bmh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Dudu go agen go webi, noumamau. Guzenebi, gil ainarai ebu go koli ob ougan usamau.” Gonugau tapaimaraneu dudu go ze go doimai, goagal oiagab uhu pet usaleun. ");
INSERT INTO bmh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ziwas go ebu Yesus gonugau tapaimaraneu dudu abai Kapaneam uzan betena, Nou zaueim aiwag wanemen dudu agen alai Pita kanabai ze auremen, “Agal tapaimaraneu du go aiwag Nou Zaueim macaneu ta?” ");
INSERT INTO bmh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita nug eneun, “Io, go macaneu.” Guzenaimai, Pita go zaueim sinai, Yesus nug amegai go kanabai aureun, “Saimon na einai dabelem? E emgasag gumaranemenin dudu banban agen dudu inen ebuan aiwag wanemen? Goagal emgasag ebuan dudu ta, emgasag ipal ebuan dudu?” ");
INSERT INTO bmh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Guzenai aurina, Pita nug koli Yesus aureun, “Emgasag tub ebuan dudu agen aiwag mamam!” Yesus nug koli go guzenai aureun, “Guzenaimai, emgasag e ebuan dudu ag aiwag i mamamen, ag gaul damamen. ");
INSERT INTO bmh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bo, ig dudu go abai i alalamam. Gonun, na nait karuk wabun kuai oiba, betei ze unig ebu karuk wabun kuai heiba, karuk amegai umam. Go karuk gonugau ogusau oug aiwag tub dareu uligaimai, umam. Go iboin, nagen aiwag go oi betei Nou Zaueim maremen, aiwag go igual ereg tutak.” ");
INSERT INTO bmh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ziwas tub ebu, Yesus nugau tapaimaraneu dudu agen, go waugab alaimai, go guzenai kanabai ze auremen. “Du in go Uwait nugau duailel ula banou pet abai dareu?” ");
INSERT INTO bmh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Guzenaimai, Yesus nug mogoi ginampet tub aurina, alina, mogoi go dudu ameagab ebu ula tapai maimai, awareun, ");
INSERT INTO bmh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Iz ag petak pet awarem. Bo, ag agal oiagab koli kekulaimai, mogoi ginampet e sul usalab tam, go ag Uwait nugau duailel i usalamamen. ");
INSERT INTO bmh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Du in nugtal gonugau wanib ulagwag i mamau, koli e mogoi ginampet sul usalamau, du go petak gonug dudu ipal zilacaraimai, Uwait nugau amegwab du banou usalamau. ");
INSERT INTO bmh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Du in nug iz en dabeleimai, go mogoi tub e mogoi ginampet sul imai aimai, suban gumaneu, go iz imailaneu.” ");
INSERT INTO bmh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesus nug koli awareun, “Mogoi ginampet tub iz en gonugau ougab petak eun du tub nug igul eg abai muraba aba, go igul egonou pet. Dudu ipal agen aiwag uhu ban oimai, du gonugau beu ebu us sil kiai maimai, ze unig oug hamacebi, numau, go iboi, uhu go ginampet. Tam aba, aiu ses Mesgai wag, go uhu banou pet umau. ");
INSERT INTO bmh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bisoua pet, em ebuan dudu ipal agen igul eg maimai, igul gonug duailel ipal naliu agal oiagab petak emen utanem. Igul eg go petak zuaneu, bo, du go igul eg go macaneu, bisou pet, go aiu ses uhu banou pet umau. ");
INSERT INTO bmh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Bo, nait eben ta aram ta, gonug igul eg mabun keuizaba, nait eben go ta, aram ta, kuataiba, hamaramam, go iboi. Na muzmuz naliu awau damam. Na i guzenamam na go eben aliag ta, aram aliag mui unum ab i noumaneu oug heizamam. ");
INSERT INTO bmh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bo, nait amen tub nug igul eg mabun keuizaba, amen go gue oi esei heib amen tutak go iboi. Na muzmuz awau damam. Na i guzenamam, na amen aliag go mui unum ab muzmuz elaneu oug heizamam.” ");
INSERT INTO bmh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesus nug kolital awareun, “Ag suban go don, ag guzenai i dabilan e mogoi ag gaul mogoi ginaginam aimai i ze macan. Tam! Iz ag petak awarem, Mesgai wag e agal gumaraneun tibur darem, go muzmuz izal Mekai Mesgai wag dareu gonugau amegwab tapai dacanemen. ");
INSERT INTO bmh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Go einen, Du Nugau Nag go duailel abu egecemenin koli imarabun aleun. ");
INSERT INTO bmh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Du tub gonugau sipsip handret tutak (100), bo, go gonugau sipsip tutak wagemaba, ag dabilemen, go erunamau? Go i itanamau ta? Tam. Go sipsip ipal 99 em manam ebu utaraba, gig zai dabi dabi, go sipsip tub wagemeun betei itanamau. ");
INSERT INTO bmh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iz ag petak pet awarem, go du go betei sipsip wagemeun go itanai betei peimai, go ougab naliu maimai, siksikeun. Go 99 sipsip ipal en banban siksikab tam, einen, go kaiab tam. ");
INSERT INTO bmh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Go igul guzenenegtal, agal Memeag go Mesgai wag dareu nug e mogoi ginaginam utaraba, i abu egecamam.” ");
INSERT INTO bmh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus nug koli awareun, “Bo, nait zaun nug na ebizab igul eg maba, nagen go waugab beteiba, gonugau igul eg meun en auramam. Bo, ag sag wage wageimai go guzenamamen. Guzenemen, gonug nait ze duba, go iboi, nagen nait zaun koli go imacem. ");
INSERT INTO bmh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bo, go nait ze duabun utaba, na du tutak ta, du aliag imaraiba, ag go dual alai hoboiban, gonugau ougab koli kekulabun en auramamen. Guzenaimai, du aliag agen gonugau ze tuguiai ebi uligamamen. ");
INSERT INTO bmh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Guzenebi, go agal ze duabun utaba, ag duailel oiagab petak emen du gonugau igul eg meun gonugau ze awarebi, goagen han go isanuramam. Bo, go duailel agal ze guzental duabun utaba, aba ag go guzenai auramamen, ‘Na ounab petak ab tam du sul, na takis aiwag waneu du sul, na ig ibaig i tulai damam.’” ");
INSERT INTO bmh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yesus nug koli eneun, “Iz ag petak pet awarem, em ebu, duair in ag auramamen, ‘Na igul go i guzenen’ Uwait nug han Mesgai wag guzental auramau. Em ebu, duair in ag auramamen, ‘Na igul go iboi guzenen,’ Uwait nug han Mesgai wag guzental auramau. ");
INSERT INTO bmh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Iz ag kolital awarem, e em ebu ziwas tub ebu, du aliag agen goagal oiagab tutak maimai, go ze pataimai, ein ece wabun Uwait auramamen, izal Mekai go Mesgai wag dareu gonug ag ece go maramau. ");
INSERT INTO bmh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Einen, du aliag ta, ainarai agen iz en dabeleimai, izal wanim ebu tulai dacanemen, go iz ag abai danai.” ");
INSERT INTO bmh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ziwas go ebu Pita nug Yesus waugab alaimai, guzenai kanabai aureun, “Dubanou Ban, izal zai nug umkoskos iz ebilab igul eg maba, ziwas eiceisab iz gonugau igul eg zilagai murai? Ziwas kwali ta?” ");
INSERT INTO bmh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus nug koli guzenai aureun, “Iz guzenai i aizem. Bo, iz ziwas houhou kwali (70) mui guzenenegtal ziwas kwali mui go na aizem. ");
INSERT INTO bmh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ag go don, Uwait nugau gumaraneu igul go sul: Ziwas tub ebu emgasag tub gumaraneun du banou nug gonugau salau dudu agal aiwag ameg wabun betei kanabareun. ");
INSERT INTO bmh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Go ece ameg wabun igul go guzenina guzenina, ziwas go ebutal dudu ipal agen du tub, go du banou nugau aiwag asiu milion houhou (10,000,000) oun imai aimai, alemen. ");
INSERT INTO bmh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Salau du gonug aiwag go ameg koli murabun iborain tam. Guzenina, du banou gonug go guzenai aureun, ‘Iz na mui, nait air mui, nait gelenar alenar mui, unum iz ag aiwag i wanemen salau dudu sul usalai maremin, nait ece mui unum dudu ipal agen go gau marebi, iz aiwag go ameg koli go ebuan milebi, wai.’ ");
INSERT INTO bmh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Salau du gonug gumaraneun du banou go waugab zoimai, bisou a ze guzenai aureun, ‘Na iz en bisom pen. Iz nait aiwag omin unum koli na mizai.’ ");
INSERT INTO bmh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Em gasag gumaraneun du banou nug du go en bisou peimai, gonug du go guzenai aureun, ‘Na izal aiwag omen go iz koli i milen. Iz aiwag go dabui sikeun.’ Go guzenai aurina, salau du go utei waneun. ");
INSERT INTO bmh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Bo, salau du gue go utei beteimai, abu ebu salau du tub zaug gonugau aiwag ameg ginampet oun tuloroimai, gonug gonugau zaug beu patai suoraimai, guzenai aureun, ‘Na izal aiwag ipal gaul omen koli ameg unum pigai milen.’ ");
INSERT INTO bmh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Guzenina, salau zaug gonug em ebu alai noimai, bisou a ze mui salau zaug go aureun. ‘Na iz bisom peben, iz nait aiwag ameg koli mizai.’ ");
INSERT INTO bmh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bo, gonug gonugau salau zaug nugau ze duab tam, gonug du go aureun. ‘Bo, na izal aiwag gaul omen koli milab tam, gonun, iz na hiacaranem zau oug heizai. Na izal aiwag ameg go koli mileben, petak na utei unamam.’ Guzenai auraimai, du go hiacaranem zau oug heun. ");
INSERT INTO bmh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Guzenina, gonugau salau zaugul ipal agenag igul go uligaimai, goagal oiagab eg wina, goagal gumaraneun du banou ze go unum betei auremen. ");
INSERT INTO bmh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Guzenaimai, gumaraneun du nug gonugau salau du eg uloron, waugab alina, gonug guzenai aureun, ‘Na salau du eg pet. Na izal aiwag gaul mizena, omen, na iz aiwag tamacag ailina, iz petak aimai izal aiwag ameg na ebuan koli wab tam. ");
INSERT INTO bmh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Izan na en bisom pemin, na nait salau zaun bisou piab utemen. Izan na en guzenemin sul, na han go en guzenabun utemen. Na igul eg mem.’ ");
INSERT INTO bmh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gonun, emgasag go gumaraneun du go aigsisilaimai, salau du go hiacaranem zau oug heimai, go salau banou pet moroimai, go guzenai aureun, ‘Na koli izal aiwag ameg unum milamam.’” ");
INSERT INTO bmh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesus nug ze go poaimai, koli guzenai awareun, “Agal oiagab gusig maiban, agal zaiagar en igul eg memenin unum zilagai maramamen. Ag i guzenamamen, emgasag gumaraneun du gonug gonugau salau du guzeneu sul, igul go guzental izal Mekai go Mesgai wag dareu gonug han ag unum, igul go guzenaramau.” ");
INSERT INTO bmh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nug duailel ze go marai poaimai, go Galili agaig uteimai, Zudia agaig Zordan Ze tubaim dareu ebu beteun. ");
INSERT INTO bmh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Betena, duailel asiu ebeu mui go sesamorai betena, gonug go ebu duailel ipal ebeu mui kasareun. ");
INSERT INTO bmh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi dudu ipal agen Yesus polumurabun en go waugab alaimai, guzenai kanabai ze auremen. “Igual kasai ze nug eneu, air tub igul eg i meun, gonugau gamu nug gonugau dabeleu eim utabun iboin ta, tam?” ");
INSERT INTO bmh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus nug koli guzenai awareun, “Ag Uwait nugau ze enai dareu i nanalanemen ta? ‘Amegai Uwait nug du mui, air mui, patarai meun.’ ");
INSERT INTO bmh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Igul go en, du gonugau wau dual eregtal atai daimai, agal enimag tutak tulamam.’ ");
INSERT INTO bmh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gonun, du go air dual goagal enimag beu beu aliag i dareu, bo, goagal enimag tutak sul usalai damau. Guzenaimai, Uwait nug ag tutak enimag sul tulareun, gonun, duair tub nug koli i atalaramau.” ");
INSERT INTO bmh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Guzenina, Parisi dudu agen Yesus guzenai auremen, “Nait ze petak zob, Moses nugau kasai ze nug einen guzenai aigeun, du tub gonugau air utaba, unabun en sikut tub waimai, gonugau wau muramau, go guzenaimai, petak gonugau wau utaba, unamau? Go einen guzenai ze meun?” ");
INSERT INTO bmh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus nug koli awareun, “Moses nug agal oiagab gusig mina, uligaraimai, dudu ag ailel omenin, utarebi, unabun iboin awareun. Bo, getal du air dual patarai meun ziwas ebu, igul go enai i dareu. ");
INSERT INTO bmh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Iz ag petak awarem, du in gonugau wau wal igul i meun, du gonug gonugau wau gaul uteimai, go air tub umau, go go nugtal gonugau air uteimai, go nugtal duailel egaranemenin kasai ze etuburacamau.” ");
INSERT INTO bmh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Parisi dudu go wanena, Yesus nugau tapaimaraneu dudu agen go guzenai auremen, “Air mui dabun igul enai, gonun, igual dabeleu enai dudu ag air i umamen gaul damamen, igul go naliu.” ");
INSERT INTO bmh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Guzenina, Yesus nug koli guzenai awareun, “Gaul dabun en ze go duailel unum sesamorabun iborain tam. Bo, Uwait nug sag duailel ipal gusig marena, go ze gosag sesamoranem. ");
INSERT INTO bmh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ag go don! Dudu ipal ag air i egaranemen, gonugau bigeg enai: dudu ipal agal anaiagar agen ebeu eg mui soliag wemen, gonun, ag mogoi patabun iborain tam. Bo, dudu ipal agen dudu ipal eg maremenin, gonun, ag air wabun iborain tam. Dudu ipal ag Uwait nugau salau oimai, ag air i egaranemen. Du in go ze e doimai, sesamorabun go sesamoramau.” ");
INSERT INTO bmh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ziwas go ebu, duailel agen goagal geleagar aleagar Yesus nug goagal gagaliag pataba, Uwait nug go gusig marabun en aurabun go waugab imarai alemen. Bo, gonugau tapaimaraneu dudu agen duailel go zamaremenin. ");
INSERT INTO bmh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Guzenina, Yesus nug gonugau tapaimaraneu dudu awareun, “Ag go mogoi ainagul utarebi, iz waiab alamam. Ag kuatai ze i awaran. Duailel ag mogoi ainagul ginaginam e sul, ag abiu Uwait go agal gumaraneu du banou.” ");
INSERT INTO bmh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Go gonugau ebeg go mogoi ainagul goagal gagaliag ebu maimai, Uwait go auraimai, utei waneun. ");
INSERT INTO bmh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Silin mogoi tub go Yesus waugab alaimai, aureun, “Du Banou, iz ein igul naliu memin, izal dorop muzmuz awau damau?” ");
INSERT INTO bmh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Guzenai aurina, Yesus nug aureun, “Na einen igul naliu mabun iz ailem? Du tub tutak go naliu. Bo, na awau dabun aiba, kasai ze unum sesamoramam.” ");
INSERT INTO bmh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Du go nug koli Yesus aureun, “Ein kasai ze?” Guzenai aurina, Yesus nug koli du go aureun, “Kasai ze enai, ‘Na du tub weben, i noumamau’, ‘Na du tub nugau air dual wal igul i men’, ‘Na dudu ipal agal ece zob i on’, ‘Na du tub nugau enib ebu polu ze i men’, ");
INSERT INTO bmh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Na nait memen anan agal ze unum sesamoren,’ ‘Na nag en ounab nug noumanem sul, dudu ipal en guzental guzenamam.’” ");
INSERT INTO bmh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Silin mogoi gonug koli guzenai aureun, “Is kasai ze go unum sesamoranem. Bo, ein igul naliu iz mab tam?” ");
INSERT INTO bmh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus nug du go koli guzenai aureun, Na du naliupet pet usalabun aba, na beteiba, nait ece unum dudu ipal mareben, goagen ece go gau mebi, aiwag go oiba, dudu ecesab tamacag aiwag go dou maramam. Na guzenemen, nait ece asiu pet Mesgai wag damau. Guzenaimai, na alaib iz sesamilen.” ");
INSERT INTO bmh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Silin mogoi go ze go doimai, gonugau ougab uhu mina, go utei waneun. Einen, go ece asiu mui, gonun, igul go guzenabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Guzenaimai, Yesus nug gonugau tapaimaraneu dudu awareun, “Iz ag petak pet awarem. Dudu ece asiu mui ag Uwait nugau duailel usalabun anmamamen. ");
INSERT INTO bmh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iz ze go koli awarem. Egun tub kamel go tibur galau sopwanem kulam nugau biag ougeim siabun anmamau. Bo, duailel ece asiu mui ag Uwait nugau duailel usalabun banban anmamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gonugau tapaimaraneu dudu agen ze go doimai, go esilakaimai, enemen, “Guzenaba, Uwait nug du in imaba, go dual ereg muzmuz damau?” ");
INSERT INTO bmh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus nug uligaraimai, awareun, “Dudu agen igul go guzenabun iborain tam. Bo, Uwait nug sag igul go unum guzenabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Go guzenai ze mina, Pita nug koli aureun. “Na ig uligigen, ig igual ece unum uteimai, na sesamizai alemun. Ig ein ece umam?” ");
INSERT INTO bmh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus nug koli awareun, “Iz ag petak pet awarem, em awau usalaba, Du Nugau Nag go wanib banou mui gumaraneu du nugau biz ebu hubaba, ziwas go ebu ag iz sesamilanemen dudu ag han gumaranem dudu agal biz begurug ebu hoboimai, agal salau Israel agal ug tutak tutak begurug agal igul sisiaramamen. ");
INSERT INTO bmh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Duair in izal wanim ulapwag mabun dabeleimai, go gonugau zau, gonugau apag, gonugau amag, gonugau abiag, gonugau memeg, gonugau anag, gonugau gelegul, gonugau alegul, gonugau em uteimai, izal igul sesamoreun, aiu ses Uwait nug ece go utei aleun sul, handret tutak muraba, go muzmuz naliu awau damau. ");
INSERT INTO bmh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ag go don, dudu asiu ag ulis wanimag banou a daremen, aiu ses ag wanimag tamacag gaul du sul damamen. Bo, dudu ulis gaul daremen, aiu ses ag wanimag banou a damamen.” ");
INSERT INTO bmh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesus nug koli eneun, “Uwait nugau gumaraneun igul enai dareu. Ziwas tub umaseu pet, wain ougem atag du nug gonugau ougem ebu salau mabun dudu ipal ee ig wanem empip ebu daremen itanarai beteun. ");
INSERT INTO bmh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Go betei dudu ipal tularaimai, guzenai awareun, ‘Ag izal wain ougem ebu, betei salau oi milebi, iz ag aiwag gil tutak ebuan aiwag guzental marai.’ Guzenina, dudu goagen io aurina, go palautarena, gonugau ougem ebu salau mabun betemenin. ");
INSERT INTO bmh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Go ougem atag du go koli am ameg sai naliu sul ee ig wanem empip ebu koli beteimai, dudu ipal gaugaul tapai daremen uligareun. ");
INSERT INTO bmh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Guzenaimai, gonug dudu go awareun, ‘Ag han betei izal wain ougem ebu salau oi milebi, iz ag aiwag marai.’ ");
INSERT INTO bmh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Guzenina, dudu go salau mabun wanena, go koli am ameg begurug ebu guzental guzeneun. Dai dai, go am ameg ainarai guzental guzeneun. ");
INSERT INTO bmh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Du go gue am ameg tabkuai mazicina, koli ee ig wanem empip ebu beteimai, go dudu ipal go ebu gaugaul daremen uligareun. Gonug awareun, ‘Ag einen e ebu gaugaul daremen?’ ");
INSERT INTO bmh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Dudu go agen koli go guzenai auremen, ‘Ig du tub nug salau migab tam, gonun, ig gaugaul darem.’ Goagen guzenai aurina, gonug koli dudu go awareun, ‘Ag betei izal wain ougem ebu salau macan.’ ");
INSERT INTO bmh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Guzenaimai, umusig mina, ougem atag du nug salau dudu gumaraneun du banou aureun, ‘Na salau dudu ularemen, alebi, goagal aiwag maren. Ses betei salau memen dudu, go aiwag amegai maraib, aiu ses, amegai betei salau memen dudu, koli aiwag maramam.’ ");
INSERT INTO bmh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dudu go beu beu go ulistal betei, salau memen gil tutak ebuan aiwag omen. ");
INSERT INTO bmh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Guzenina, amegai betei salau memen dudu agen ‘Ig aiwag asiu pet umam’ aimai dabilemenin, bo, ag han guzental gil tutak ebuan aiwag omenin. ");
INSERT INTO bmh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Go aiwag go oimai, ougem atag du mui gonogonocaimai, go guzenai auremen, ‘Dudu go ag ulistal betei, salau ginampet memen. Ig umaseutal betei, salau memun, am nug atai pet heligeun. Bo, ig aiwag banou migab tam. Dudu go aiwag omenin sul ig han guzental migem.’ ");
INSERT INTO bmh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Guzenai ze mina, ougem atag du gonug salau du tub guzenai aureun, ‘Zai, iz na polu ze aizab tam. Iz na ibaiz ze pataimai, aizemin, na e gil tutak ebu salau meben, iz gil tutak ebuan aiwag mizai, guzenai aizemin, na io aimai ailemen. ");
INSERT INTO bmh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ulis na nait aiwag oiba, nait uzan utei beten. Du go gue ses alai salau meun go han na omen sul muramoroi. ");
INSERT INTO bmh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","E izal aiwag, gonun, izaseu dabeleimai, igul go guzenem. Iz igul naliu go guzenem, na einen ounab eg wem?’” ");
INSERT INTO bmh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Guzenaimai, Yesus nug eneun, “Dudu go ag wanimag banou tam ses daremen ag amegai damamen. Amegai daremen dudu ag wanimag a, ag ses pet damamen.” ");
INSERT INTO bmh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesus gonugau tapaimaraneu dudu begurug go ereg Zerusalem uzan betei beteimai, gonug ze wageimai awareun, ");
INSERT INTO bmh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ag izal ze go don! Ulis ig Zerusalem uzan betemun, go ebuan dudu agen Du Nugau Nag Uwait ula dacanemen dudu banban mui, kasai ze tapaimaranem dudu mui, goagal ebeag ebu mamam. Go dudu banban agen uzanan dudu agal ze doimai, webi, noumabun en ze patamam. ");
INSERT INTO bmh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Goagen emgasag ipal ebuan dudu agal ebeag ebu mebi, dudu goagen go ze biabial kuai ze auraimai, esalau sul oimai, a gegeulanau ebu asai mebi, noumamau. Bo, gil ainarai ebu Uwait nug go koli usai mamau.” ");
INSERT INTO bmh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ziwas go ebu, Zebedi nugau wau nug gonugau gelegul aliag Yesus waugab imarai alaimai, go ece tub en kanabai aurabun eun. ");
INSERT INTO bmh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus nug air go aureun, “Na ein ece umam?” Air gonug koli guzenai aureun, “Na iz ibail baib guzenai mamam. Izal mogoi aliag e aiu ses na gumarabun du banou usalemen, izal nagwai tub nug eben naliu eiman hubamau, nagwai tub nug eben nanai eiman hubamau, go na ibaiz damam.” ");
INSERT INTO bmh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Go guzenai ze mina, Yesus nug koli awareun, “Ze go kanabai ailemen gonugau bigeg ag abiu mab tam. Iz ze gap tub ebu dareu zai, ag ze go zabun iboin ta?” Mogoi aliag goagen koli auremen, “Ig ze go zabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesus nug mogoi aliag go koli awareun, “Go petak, ag izal gap ebuan ze zamamen, bo, du in go izal ebe naliu eiman simai hubamau, du in go ebe nanai eiman simai hubamau, go izal salau tam. Izal Mekai nug dudu ipal agal empip suban mareun dareu.” ");
INSERT INTO bmh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesus nugau tapaimaraneu dudu ipal houhou agen ze go doimai, go mogoi aliag go en aiag sisileun. ");
INSERT INTO bmh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus nug gonugau tapaimaraneu dudu awarina, go alai unum gotulina, gonug guzenai awareun, “Ag abiu em ebuan dudu agal gumaranem dudu banban agen agal wanimag wag maimai, agal duailel gumaranem. Duailel agal dudu banban agen duailel agal ze sesamorabun gusig ze awaranem. ");
INSERT INTO bmh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ag izal duailel ag igul go i guzenan. Bo, duair tub nug agal banou dai aba, go iboi, amegai go agal salau duair damau. ");
INSERT INTO bmh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Duair tub nug ‘iz wanim banou a amegai dai’ aba, go iboi, amegai go agal salau duair (slev) sul damau. ");
INSERT INTO bmh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Go sul, Du Nugau Nag duailel ipal agen go isanurabun en alab tam. Tam! Go duailel ipal isanarabun en aleun. Go noumaimai, duailel asiu koli Uwait nug waugab imarai simau.” ");
INSERT INTO bmh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus gonugau tapaimaraneu dudu abai Zeriko uzan betena, duailel asiu agen sesamarai betemen. ");
INSERT INTO bmh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Du aliag ameag kumi go abu gasag eim hoboi daremen. Go Yesus zoi zilarai bitabun ina, ze doimai, go agen guzenai ul emen, “Dubanou Ban, na Devit nugau Ug, na ig en bisomig peiba, ig isanigen.” ");
INSERT INTO bmh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Duailel asiu agen du aliag go en acegsisilaimai, ul emen utamam aimai gusig pet awaremen. Bo, go agal ze duab tam, go ulai ban pet ul aimai, guzenai ul emen, “Dubanou Ban, na Devit nugau Ug. Na ig en bisomig peiba, ig isanigen.” ");
INSERT INTO bmh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesus go tapai daimai, dudu aliag go ularaimai, awareun, “Iz ag erunarabun ailemen?” ");
INSERT INTO bmh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dudu aliag ag en koli auremen, “Dubanou Ban, na igual amecig waipai migemen, ig em uligamam.” ");
INSERT INTO bmh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus go du aliag bisomagar peimai, goagal ameag ebeg sil patena, ziwas go ebutal goagal ameag waipina, koli abu pemenin. Guzenaimai, go sesamorai wanemenin. ");
INSERT INTO bmh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Yesus go gonugau tapaimaraneu dudu abai, Zerusalem ban uzan bitabun bete betei, Betpage uzan Oliv em manam ebu beteimai, Yesus nug gonugau tapaimaraneu du aliag palautaraimai, awareun, “Ag ulibe uzan ginampet ebu beteiban, egun donki gonugau nag dual, us sil kiarai memen darem uligaiban, us waipaiban, donki go gonugau nag dual iz waiab imarai alan. ");
INSERT INTO bmh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bo, du tub nug ag kanabai ze awaraba, go donki atag du guzenai auran, ‘Go donki gonugau nag dual igual Dubanou Ban, go ag abai salau a.’ Guzenaimai, go pigai ag palautaraba, alamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Igul go Uwait nugau ze doimai, awaraneun du tub nug ze aneun go unum usaleu. ");
INSERT INTO bmh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ag Saion duailel guzenai awaramamen, ‘Agal emgasag gumarabun du banou aleu. Go nugtal gonugau wanib i ulagwag macaneu, go donki ebu hoboimai, aleu.’” ");
INSERT INTO bmh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Guzenaimai, Yesus nugau tapaimaraneu du aliag agen gonugau ze awareun sultal guzenemenin. ");
INSERT INTO bmh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Guzenaimai, go donki nag Yesus waugab imai alaimai, goagal tibur galau huia donki nugau bugazig ebu duei mina, Yesus nug wag simai hoboun. ");
INSERT INTO bmh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Duailel ipal asiu agen goagal tibur galau oimai, abu ebu duei betemenin. Duailel ipal agen nun gau kuataraimai, abu ebu duei betemenin. ");
INSERT INTO bmh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Guzenaimai, duailel ipal agen Yesus ula maimai, amegai betemenin. Duailel ipal agen ses sesamoraimai, guzenai ul ai betemenin, “Devit nugau Ug gonugau wanib wag murab. Du go gue Uwait Ban nugau wanib ebu aleu, ulagwag murab, Uwait nugau wanib sag ulagwag pet murab.” ");
INSERT INTO bmh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesus go Zerusalem ban uzan simai, uzanan duailel go agen go uligaimai, esilakaimai, guzenai ze memen, “Du go in?” ");
INSERT INTO bmh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Go dual ereg betemenin duailel agen guzenai awaremenin, “Go Yesus, Uwait nugau ze doimai, awaraneu du. Go Nasaret uzan Galili agaigan.” ");
INSERT INTO bmh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesus go Uwait ecesab muranemen zau banou tempel zau oug simai, duailel go ecesab palautaraimai, gaugau mai darena Yesus nug zamarina, unum wanemenin. Go dudu goagal aiwag ig wai wanemen biz mui, meg palautaimai daremen nugau biz mui oimai, hamareun. ");
INSERT INTO bmh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gonug dudu go awareun, “Uwait nugau ze sikut wai memen dareu, ‘Izal ecesab milanemen zau banou duailel goagen iz ibail ze mabun zau anem.’ Bo, ulis goagen zob dudu agal wageimai dabun empip sul usalai mem.” ");
INSERT INTO bmh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesus go Uwait ecesab muranemen zau banou zaueim darena, dudu ipal ameag kumi mui aramag eg mui go waugab alina, gonug kasareun. ");
INSERT INTO bmh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","Mogoi agen zaueim go daimai, guzenai ul emen, “Devit nugau Ug gonugau wanib wag macan.” Uwait ula dacanemen dudu banban mui kasai ze tapaimaranem dudu mui go Yesus nug gugeg ipal atai meun uligaimai, mogoi go agal ze doimai, oiagab eg wina, goagen Yesus guzenai kanabai ze auremen, “Na ze go zememen dom ta?” Yesus nug koli awareun, “Io. Iz dom. Bo, ag Uwait nugau ze go i nanalanemen ta? ‘Na mogoi mui, mogoi ginampet ap zanemen ipal mui, go nugtal ze abai marena, go agen nait wanim naliupet wag mizamam.’” ");
INSERT INTO bmh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesus go dudu go utaraimai, ban uzan utei betei, go Betani uzan nineun. ");
INSERT INTO bmh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesus go gonugau tapaimaraneu dudu abai go umaseu pet koli ban uzan alabun alalai, Yesus go we weun. ");
INSERT INTO bmh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Go abu gasag sabug a uligaimai, waugab beteun. Bo, go a dab useg tamacag, go gau sag darena, uligeun. Guzenaimai, gonug a go aureun. “Na dab kolital i mamam. Tam pet.” Gonug guzenai aurinatal, a go pigai meu meun. ");
INSERT INTO bmh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gonugau tapaimaraneu dudu agen igul go uligaimai, esilakaimai, goagen guzenai ze memen, “A go erunai pigai meu meun?” ");
INSERT INTO bmh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus nug koli gonugau tapaimaraneu dudu awareun, “Iz ag petak pet awarem, agal oiagab petak aimai, ag dabeleu aliag i umamen, iz a go guzenem sul, ag han guzenamamen. Bo, ag igul go sag i guzenamamen. Tam pet! Ag ulibe em tabag auramamen, ‘Na asaiba, ze unig oug kuanai numam!’ aurebi, go guzenamau. ");
INSERT INTO bmh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gonun, ag agal oiagab petak aimai, ein igul Uwait nug mabun auramamen, go igul go guzenamau.” ");
INSERT INTO bmh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus go koli Uwait ecesab muranemen zau banou zaueim simai, duailel Uwait nugau ze abai marai daren daren, Uwait ula dacanemen dudu banban mui, ze tapaimaranemen dudu ipal mui, go go waugab alaimai, go kanabai ze auremen, “Na ein gusig oimai, igul go guzenanem? In nug gusig go na mizeun?” ");
INSERT INTO bmh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus nug koli dudu go awareun, “Izan han ze tub kanabaramoroi. Agen amegai izal ze bigeg go kanabaramoroi ailebi, izan han iz ein gusig eiman igul go guzenanem bigeg go ag awarai. ");
INSERT INTO bmh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ze ziwaraneun du, Zon, gonugau gusig eru eiman aleun? Gusig go Uwait nug moroun ta, ta du tub nug gusig go moroun ta?” Go ze go doimai, agzozou ze maimai, enemen, “Ig go ein ze aurab? Ig go Uwait nugau gusig eiman ze ziwaraneun emun, gonug aigamau, ‘Gonun, ag einen agal oiagab petak abun utemenin?’ ");
INSERT INTO bmh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bo, ‘Gonugau gusig go du nug moroun,’ guzenai auremun, duailel agen ig ein igul ig ebiligeb mamam aimai uminaremen. Einen, ag Zon go Uwait nugau ze doimai, awaraneun du guzenai gusig dabilanem.” ");
INSERT INTO bmh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Gonun, goagen Yesus koli auremen, “Ig i abiu.” Gonug koli dudu go awareun, “Iz han, inug iz gusig milena, igul go guzenanem ag i awarai.” ");
INSERT INTO bmh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus nug koli awareun, “Agal dabeleu erunai dareu? Du tub go mogoi aliag a. Du go nug gonugau nag kaman betei, aureun, ‘Nagwai, ulis na wain ougem betei salau men.’ ");
INSERT INTO bmh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nag nug koli memeg aureun, ‘Iz ougem unabun utem.’ Guzenai ze meun, go koli dabeleu oimai, ougem betei salau meun. ");
INSERT INTO bmh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Du gonug gonugau amag ginam guzental betei, aureun, ‘Na han wain ougem betei salau men.’ Gonug koli aureun, ‘Io, mekai, iz bitai.’ Bo, go guzenai auraimai, go ougem bitab tam. ");
INSERT INTO bmh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ziwas go ebu, nag in nug gonugau memeg nugau ze sesamoreu?” Duailel agen guzenai ze memen, “Mogoi kamam nug gonugau memeg nugau ze sesamoreun.” Guzenaimai, Yesus nug dudu go awareun, “Iz ag petak pet awarem, takis aiwag wanemen dudu mui, abu ebuan ailel mui, ag amegai Uwait nugau duailel usalamamen. ");
INSERT INTO bmh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ze ziwaraneun du, Zon go waiagab alaimai, abu naliu abai mareun, ag go en agal oiagab petak ab tam. Guzenina, aiwag wanemen dudu mui, abu ebuan ailel mui, goagal oiagab go en petak emen. Ag duailel go agal igul uligaraimai, agen agal igul eg ebuan koli kekulab tam gonun, Zon en oiagab petak i eu.” ");
INSERT INTO bmh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus nug awareun, “Ag tatau ze tub don. Du tub go em banou mui, go wain ougem maimai, wain ug baimai, gilan otoi meun. Go wain ougem ebu dab pasiabun ob eleimai, ougem gumabun zau huia wag meun. wai unum suban darena, dudu ipal gonugau ougem salau mabun gau maraimai, salau mina mina, ougem atag du nug go uzan tub pulig waneun. ");
INSERT INTO bmh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wain dab useg mina, wabun ziwas alina, ougem atag du gonug gonugau salau dudu ipal awarina, ‘Wain dab ipal wabun ougem gumanemen dudu go darem ebu beten,’ guzenai awarina, betemen. ");
INSERT INTO bmh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","36","Wain ougem gumanemen dudu agen salau dudu ainarai go gusig pataraimai, du tub wina, waneun, du tub wina, noumeun, du tub go aiwag sil wina, noumeun. Go guzenina, ougem atag du gonug koli gonugau salau dudu asiu palautarena, go wain ougem gumanemen dudu waiagab betemen. Dudu go agen salau dudu ainarai amegai ugaremenin sultal, salau dudu asiu go han guzental ugaremenin. ");
INSERT INTO bmh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Guzenina, du gonug nug nugau nag pet palautina, dudu go daremen waiagab beteun. Memeg nug guzenai dabeleun, ‘Go izal nagwai nugau ze doimai, eg i muramam.’ ");
INSERT INTO bmh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bo, wai gumanemen dudu go agen ougem atag du nugau nag alina, uligaimai, go guzenai ze memen, ‘Gonug gonugau memeg noumaba, gonugau ecesab unum umau. Ig go wemun, noumaba, gonugau wain ougem ig umam. Go ig guzenamam.’ ");
INSERT INTO bmh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Guzenaimai, go mogoi go wain ougem ebu imai noimai, ougem gasageim wai hina, noumeun.” ");
INSERT INTO bmh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus nug dudu daremen awareun, “Agal dabeleu erunai dareu? Wai atag du go wain ougem alaimai, wai gumanemen dudu go erunaramau?” ");
INSERT INTO bmh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Goagen auremen, “Gonug, dudu eg go unum ugarai heimai, go koli dudu ipal go wain ougem gumabun imaramau. Aiu ses go wain useg maba, wabun ziwas ebu, wain ougem gumamam dudu goagen ougem atag du wain dab ipal muramam.” ");
INSERT INTO bmh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesus nug koli awareun, “Ag Uwait nugau ze go ze meu nanalanemen ta? Zau sanag go zau macanemen dudu agen eg aimai, gasag memen. Ulis, zau sanag go ula ebuan zau sanag gusig naliu usaleun. Uwait Ban nugtal sanag go salau banou moroun, go naliupet pet ig uligem.” ");
INSERT INTO bmh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesus nug dudu go awareun, “Getal Uwait nug ag gumaraneun, ulis Uwait nug ag utaraimai, duailel ipal go gonugau salau suban macanem gonug duailel go gumaramau.  ");
INSERT INTO bmh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Duair in sanag go ebu titou amau, duair go unum kitkuataba, sibsib mamau. Zau sanag gonug du tub ebu nuba, du go gue waibul sul usalamau.’” ");
INSERT INTO bmh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Uwait ula dacanemen dudu banban mui, Parisi dudu mui, go agen Yesus nugau tatau ze doimai, go abiu memen, go goagal igul en ze meu. ");
INSERT INTO bmh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gonun, goagen go ebutal Yesus gusig pataporoi dabilemenin. Bo, go abiu duailel agen Yesus go Uwait nugau ze doimai, awaraneu du aimai dabilemenin, gonun, go duailel uminaraimai, utemen. ");
INSERT INTO bmh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus nug tatau ze eiman duailel guzenai awareun, ");
INSERT INTO bmh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Uwait nug gumaraneu igul go enai. Ziwas tub ebu gumaraneun du banou king nug gonugau nag air wabun ina, ee agabun meun. ");
INSERT INTO bmh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Gonun, gonugau salau dudu palautarena, betei dudu go gonug getal awareun, awaraimai, imarai alai ag gonugau ee agamau ebu alamam. Bo, go dudu go awaremen alab utem. ");
INSERT INTO bmh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Guzenina, gonug gonugau salau dudu ipal gusig ze mui palautaraimai, awareun, ‘Iz ulis ee agaimai darem. Izal bulumakau zawai mui egun sirag mui unum waimai, mis memin. Ag air wabun ee agemin ebu alan.’ ");
INSERT INTO bmh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bo, gonugau salau dudu palautarena, go betei ze go awarina, dudu goagen goagal ze duab tam, go goagal salau ebu beu beu wanemen. Du tub go gonugau ougem beteun. Du tub go gonugau ee palautaneu zau beteun. ");
INSERT INTO bmh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Dudu ipal agen gonugau salau dudu gusig pataraimai, ze biabial kuai ze awaraimai, ugarina, noumemen. ");
INSERT INTO bmh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Guzenina, gumaraneu du banou king go aigsisilaimai, gonugau malai dudu palautina, betei dudu go unum ugaraimai, agal ban uzan ab sil agemen. ");
INSERT INTO bmh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","9","Guzenaimai, gonug gonugau salau dudu ipal awareun, ‘Iz air wabun ee agemin. Bo, iz duailel awaremin go alai ee zabun utem, gonun, ag ban abu ebu beteiban, duailel asiu uligaraimai, awarebi, ee agemin ebu alamam.’ ");
INSERT INTO bmh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Gonug guzenai ze mina, gonugau salau dudu agen abu ebu unum betei duailel naliu mui eg abai ereg awarina, gonugau ee zabun zaueim unum alai kapai daremen. ");
INSERT INTO bmh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Guzenina, gumaraneu du banou go zaueim go simai, du tub go tibur galau naliu i arugeun uligeun. ");
INSERT INTO bmh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Emgasag gumaraneu du banou gonug du go guzenai aureun. ‘Zai, na einen tibur galau naliu arugab tam, na e zaueim zomen?’ Bo, du go go aurab tam, go ze tamacag a dareun. ");
INSERT INTO bmh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Guzenina, du banou go nug gonugau salau dudu awareun, ‘Ag du gonugau arab ebeg mui, us sil kiaiban, uzaneim oi hamacebi, go umaum weinai daimai, acig kititkatitai damau.’” ");
INSERT INTO bmh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesus nug guzenai ze meun, “Uwait nug duailel asiu go waugab alabun ulareu, bo, go duailel asiu i tapai maraneu.” ");
INSERT INTO bmh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ze go meun doimai, Parisi dudu agen uzaneim noimai, agzozou Yesus polumorabun ze patemen. ");
INSERT INTO bmh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Guzenaimai, goagen goagal tapaimaranemen dudu ipal mui Herot nugau ze sesamoranemen dudu mui go Yesus waiagab palautarena, alemen. Go alaimai, guzenai auremen, “Du Banou, ig abiu na petak ze ze macanem du. Na dudu agal dabeleu i duanem. Wanimag a dudu sag na i piaranem. Na Uwait nugau ze petak pet ig abai miganem. ");
INSERT INTO bmh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Guzenaimai, na einai dabelem? Ig aiwag Sisar muramam ta utamam? Nagen ig aigamam.” ");
INSERT INTO bmh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesus go nug polumurabun en ze memen abiu maimai, gonug koli awareun, “Ag polumanemen dudu, ag einen iz ame patemen? ");
INSERT INTO bmh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ag aiwag macanemen tub oi abai milebi, iz piai!” Goagen aiwag go oi alai moromen. ");
INSERT INTO bmh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Gonug kanabai awareun, “Aiwag e ebu wanib dorog mui inugau?” ");
INSERT INTO bmh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Goagen koli auremen, “Sisar nugau.” Guzenai aurina, Yesus nug koli awareun, “Guzenaimai, ag Sisar nugau ece go Sisar muramamen. Uwait nugau ece, go Uwait muramamen.” ");
INSERT INTO bmh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Go ze go doimai, dabeleu asiu oimai, utei wanemenin. ");
INSERT INTO bmh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gil go ebutal, Sadiusi dudu agal dabeleu enai, dudu noumamam, koli i asamam aimai ze macanem, goagen Yesus waugab zoimai, guzenai kanabai ze auremen, ");
INSERT INTO bmh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Du Banou, getal Moses nug guzenai ze meun, ‘Du tub go air oimai, gonugau wau mogoi tamacag noumai utei unaba, gonugau amag nug han apag nugau wab air oimai, mogoi muramau, mogoi go apag noumeun nugau mogoi sul usalamau.’ ");
INSERT INTO bmh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bo, umtabag du tub gonugau gelegul kwali a. Mogoi kaman air oimai, go mogoi tamacag noumeun. Guzenaimai, amag tub nug gonugau wab air oun. ");
INSERT INTO bmh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Go han mogoi tamacag noumeun. Guzenaital betei, dudu kwali go agen air go omen, unum nanag tamacag gaul noumemen. ");
INSERT INTO bmh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Guzenaimai, wab air go dareun nug, ses noumeun. ");
INSERT INTO bmh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Air go dudu kwali agen omenin, aiu ses noumemen duailel koli asamam ziwas ebu, air go in nugau tuguiai damau? Em ebu, go dudu kwali noumemen goagen air tutak omenin.” ");
INSERT INTO bmh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Guzenai aurina, Yesus nug koli guzenai awareun, “Ag Uwait nugau ze mui gonugau gusig mui ag i abiu. Gonun, ag polumanemen dudu pet! ");
INSERT INTO bmh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Duailel noumemen koli asamam, gue Uwait nugau tibur Mesgai wag darem sul damam. Ag i egaramam. ");
INSERT INTO bmh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Uwait nugtal noumemen dudu go koli asamam aimai ze meun. Ag ze go nanalanem ta? ");
INSERT INTO bmh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iz Abraham, Aisak, Zekob goagal Uwait.’ Uwait go dudu noumemen agal Uwait tam, go dudu muzmuz awau dacanemen agal Uwait.” ");
INSERT INTO bmh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Guzenai awarina, duailel go gonugau ze naliu doimai, esilakemenin. ");
INSERT INTO bmh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesus nug ze go Sadiusi dudu awarina, go koli ze mabun iborain tam. Guzenina, Parisi dudu go ze go doimai, gotulaimai, ");
INSERT INTO bmh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Parisi du kasai ze tapaimaraneu du tub nug Yesus polumurabun en guzenai kanabai aureun, ");
INSERT INTO bmh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Du Banou, ein kasai ze go banou pet?” ");
INSERT INTO bmh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Guzenina, Yesus nug koli aureun, “‘Na nait ounab mui nait dorop mui nait dabeleu mui nait Uwait Ban nug en unum noumen.’ ");
INSERT INTO bmh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Go kasai ze petak banou pet, amegai dareu. ");
INSERT INTO bmh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kasai ze banou tub go bigeg enai. ‘Na nag en noumanem sul, nait zaun en guzental noumen.’ ");
INSERT INTO bmh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ag kasai ze banou aliag go sesamoramamen, ag Moses nugau kasai ze mui Uwait nugau ze doimai, awaranemen dudu agal ze mui unum sesamoramamen.” ");
INSERT INTO bmh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yesus nug Parisi dudu ipal go waugab alai gotulai darena, gonug kanabai awareun, ");
INSERT INTO bmh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Agal dabeleu eim Kristus go in anemen? Go in nugau nag?” Goagen koli go auremen, “Go Devit nugau Nag.” ");
INSERT INTO bmh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus nug koli awareun, “Erunai Ah Wes nug Devit dabeleu morona, gonug Kristus gonugau Dubanou Ban aneun? ");
INSERT INTO bmh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Devit nug eneun, ‘Uwait Banou nug izal Dubanou Ban aureun, “Na izal ebe naliu eiman hobomen, izan nait iwai zaunar unum zilacaraimai, nait aramab maremin, nait pinsal damam.” ’ ");
INSERT INTO bmh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit nugtal ‘Kristus go izal Dubanou Ban’ aneun. Guzenaimai, erunai ag Kristus go gonugau nag anemen?” ");
INSERT INTO bmh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Guzenaimai, gil go ebu betei, du tub nug Yesus ze ipal aurab tam, go go gusig uminaimai, ze tub kanabai aurab tam. ");
INSERT INTO bmh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Guzenaimai, Yesus nug duailel mui gonugau tapaimaraneu dudu mui ze mareun. ");
INSERT INTO bmh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Go guzenai awareun, “Parisi dudu mui agal tapaimaranem dudu mui goagen go agal kasai ze tapaimaranemen, go Moses nugau kasai ze sul. ");
INSERT INTO bmh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Guzenaimai, ag ze go awaremen ag doimai, unum sesamoran. Bo, agal igul guzenanemen, ag go i sesamoran. Einen? Ag gaul ze asiu macanemen, bo, ag ze go i sesamoranemen. ");
INSERT INTO bmh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Agen uhu asiu duailel marena, ag uhu go oi abun iborain tam. Bo, uhu go duailel maranemen ag koli i isanaranemen. ");
INSERT INTO bmh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ag ein igul guzenanemen, go unum guzenebi, duailel agen peigamam aimai guzenanemen. Ag dudu uligarabun aimai, ag Uwait nugau Ze ipal agau ginampet tub ebu sikut waimai, agal aipag, ebeag ebu us sil kiai macanemen. Ag agal Uwait aurabun tibur galau ebu ilig inain naliupet mai mamamen. ");
INSERT INTO bmh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Guzenaimai, ag ee zanem zaueim mui gotulanemen zaueim mui empip naliu naliu ebu amegai hubabun agal oiagab noumanem. ");
INSERT INTO bmh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ag agal dabeleu dudu agen ee ig wanem empip ebu, ‘Amban,’ awaraimai, ebeag pataimai, ‘Tapaimaranemen dudu,’ guzenai ag awarebi, agal oiagab naliu usalanemen. ");
INSERT INTO bmh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bo, ag izal tapaimaranemin dudu, dudu ipal agen ag tapaimaranemen dudu aimai guzenai i awaramam. Ag unum ug tutak. Agal tapaimaraneu du tutak, go Kristus. ");
INSERT INTO bmh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Gonun, ag em ebuan du tub ‘Mekai’ aimai i auran. Agal Memeag tutak go Mesgai wag dareu. ");
INSERT INTO bmh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dudu ipal agen ag ‘igual gumiganemen dudu’ guzenai i ze mamam. Agal gumarabun du go iz sag Kristus. ");
INSERT INTO bmh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ag ula ebu, du in banou usalabun go agal salau du sul damau. ");
INSERT INTO bmh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Du in nugtal gonugau wanib ulag zamau gonugau wanib Uwait nugau ameg ebu banou i usalamau. Du in go nugtal gonugau wanib ulagwag i mamau, du go gonugau wanib ulagwag damau.” ");
INSERT INTO bmh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesus nug koli eneun, “Ei! Ag kasai ze tapaimaranemen dudu, Parisi dudu abai. Ag bisomagar! Ag polumanemen dudu! Uwait nugau duailel gumarabun abu agen tapelanemen. Ag agtal go ebu i sianem. Bo, duailel go ebu siabun ebi, agen goagal abu siabun tapelai daremen.  ");
INSERT INTO bmh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ei! Ag kasai ze tapaimaranemen dudu, Parisi dudu abai, ag bisomagar! Ag polumanemen dudu. Ag wab ailel polumaraimai, agal zauan ece gaul oi unanemen. Dudu ipal agal ameagab ebu han ag Uwait auraimai, ze huia macanemen. Gonun, aiu ses Uwait nug alai sisiaramaun ziwas ebu, ag uhu banou pet umamen. ");
INSERT INTO bmh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ei! Ag kasai ze tapaimaranemen dudu, Parisi dudu abai, ag bisomagar, ag polumanemen dudu. Ag ibut ze waugab mui em ebu mui unum aidaimai, du tub agal igul sesamorabun aimai itanemenin. Ag du go agal igul sesamorabun itanemen, go agal igul eg unum sesamoraimai, go ab i noumaneu oug numau, ag numamen sul numau. ");
INSERT INTO bmh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ei! Bisomagar! Ag ameag kumi dudu. Agen dudu ipal abu abai maranemen. Guzenaimai, agen guzenai ze maranemen, ‘Dudu ipal ze awaraimai, agen Uwait ecesab muranemen zau banou nugau wanib patanemen, ze go gusig tam. Bo, ag aiwag gol zaueim go dareu nugau wanib patanemen, ze go petak gusig a, ag ze go suban sesamoranemen.’ ");
INSERT INTO bmh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ag kar wageun dudu, ag ameag kumi dudu! Ein ece go banou pet? Uwait ecesab muranemen zau go banou ta, aiwag gol zaueim dareu go banou ta? ");
INSERT INTO bmh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ze tub go guzenai ze macanemen. ‘Bo, du tub nug ze maraimai, egun aganem biz nugau wanib patamau, ze go gusig tam, go i sesamoran. Bo, du tub go egun aganemen, biz ebu ece tub wag daba, gonugau wanib patamau, ze go petak gusig damau.’ ");
INSERT INTO bmh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ag ameag kumi dudu! Ein ece go Uwait nugau amegwab banou? Uwait nugau egun aganem biz ta, ece go biz ebu dareu ta? Ece egun aganem biz ebu dareu, go biz go nug ece naliu usalai maneu. ");
INSERT INTO bmh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Guzenaimai, du tub gonugau ze nug gusig maimai, go egun aganem biz nugau wanib patamau, go ece unum biz ebu dareu agal wanimag unum pataneu. ");
INSERT INTO bmh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Bo, du tub go Uwait ecesab muranemen zau banou nugau wanib pataimai, gonugau ze go gusig mamau, go go zau nugau wanib mui Uwait zaueim dareu nugau wanib mui ereg pataneu. ");
INSERT INTO bmh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bo, du tub nug Mesgai wanib pataimai, gonugau ze gusig mamau, go Uwait nugau hubaneu biz mui Uwait nug biz ebu hoboi dareu agal wanimag ereg pataneu. ");
INSERT INTO bmh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ei! Ag kasai ze tapaimaranemen dudu, Parisi dudu abai, ag bisomagar! Ag polumanemen dudu! Agal ougeman eg ginampet tutak tutak houhou dou mizanaraimai, doumaraimai, tutak sul oi Uwait muranemen. Bo, ag ipal kasai ze banou go uteimai, i sesamoranemen. Kasai ze go ag sesamorab tam igul go enai: ag dudu ipal mui igul naliu i macanemen. Ag dudu ipal agen bisomag i piaranemen. Ag dudu ipal suban i gumaranemen. Ag igul naliu banou go unum sesamoraimai, petak ag igul ipal ginaginam ereg sesamoramamen. ");
INSERT INTO bmh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ag ameag kumi dudu! Ag guzenemen, eb guabur nug agal ee il oug nuabunina, ag go zamoranemen. Bo, egun kamel banou ag ee il mui gulutanemen. Ag kasai ze ginaginam sesamoranemen, bo, ag kasai ze banou i sesamoranemen. ");
INSERT INTO bmh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ei! Bisomagar! Ag kasai ze tapaimaranemen dudu, Parisi dudu abai, ag polumanemen dudu! Guzenaimai, ag agal gap mui tebil mui oi seiugab ze ulusanemen. Bo, ag igul eg asiu macanemen, gonun, agal oiagab oug unu asiu dareu, ag go i ulusanemen. ");
INSERT INTO bmh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ag Parisi dudu, ag ameag kumi! Ag amegai agal gap ougab oug unu dareu go ulusaimai, koli uzaneim an enib ebu ulusebi, go unu tamacag naliu usalamau! ");
INSERT INTO bmh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ei! Bisomagar! Ag kasai ze tapaimaranemen dudu Parisi dudu abai, ag petak polumanemen dudu! Ag eb ob ebalagab iweu naliu arugai muranemen sul, iweu go dudu agen pianemen go naliupet pet. Bo, ob oug eb beleimai, sous eg dareu. ");
INSERT INTO bmh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Go guzeneu sul agal igul han guzenenegtal, duailel agen uligaraimai, ‘ag dudu naliu’ anem. Bo, agal oiagab oug ag igul eg pet macanemen, polu ze maranemen.” ");
INSERT INTO bmh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yesus nug kolital awareun, “Ag kasai ze tapaimaranemen dudu Parisi dudu mui, ag bisomagar! Ag polumanemen dudu. Einen, ag Uwait nugau ze doimai, awaranemen dudu agal ob ebu biz naliu gugai macanemen. Ag dudu agal oiagab petak emen, agal ob ebu iweu naliu arugai maranemen. ");
INSERT INTO bmh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bo, ag guzenai ze macanemen, ‘Ig igual asanagar abai getal ereg daremun sul darem zob, ig dudu go i ugaremun noumem zob.’ ");
INSERT INTO bmh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Agal ze nugtal go koli awaranem araog mareu, ag agal memeagar agen getal Uwait nugau ze doimai, awaranemen dudu ugarina, noumemen ag goagal geleagar. ");
INSERT INTO bmh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Guzenaimai, agal memeagar agen guzenemen sul, ag han guzental Uwait nugau ze doimai, awaranem dudu ipal ugarebi, noumamam. ");
INSERT INTO bmh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ag man eg nugau geleagar! Uwait nug ab i usecaneu ebu hiacaraba, ag erunai uminai unamamen? ");
INSERT INTO bmh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iz petak pet awarem, ag dumamen, izan Uwait nugau ze doimai, awaranemen dudu mui ze tapaimaranemen dudu mui palautaremin, ag daremen ebu alamam. Agen dudu ipal ugarebi, noumamam. Dudu ipal a gegeulanau ebu asarai mebi, noumamam. Dudu ipal agal gotulanemen zaueim esalau sul igaramam. Dudu ipal agen zamarebi, uminai betei ban uzan tub betebi, koli go ebuan zamarebi, ban uzan tub bitamamen. Ag guzenai guzenai ai damamen. ");
INSERT INTO bmh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Guzenaimai, dudu ipal agen getal dudu oiagab petak emen ugarina, noumemen, uhu go ag ebalagab zumau. Abel go igul naliu macaneun du wina, noumeun, guzental zoizoi Sekaraia, go Berekia nugau nag guzental guzenemen. Ag Sekaraia Uwait ecesab muranemen zau banou mui ulagwag macanemen biz ula ebu wina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iz ag petak pet awarem. Igul go getal agal asanagar agen guzenemen en ag ulisan duailel ag go uhu banou umamen!” ");
INSERT INTO bmh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesus nug Zerusalem uzan uligaimai, eneun, “O, Zerusalem, Zerusalem! Agen Uwait nugau ze doimai, awaranemen dudu ugarina, noumemen. Ag dudu ipal ze oi aidanemen dudu Uwait nug palautareun, aiwag sil ugarina, noumemen. Iz gil asi asiu, toi anag nug gonugau gelegul sausil kularai daneu sul, izal ebesil duailel gumarai anemin. Bo, duailel agen iz ag guzenabun i utilemen. ");
INSERT INTO bmh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ag go don, Uwait gonugau ecesab muranemen zau utei unaba, zau go unum eg umau. ");
INSERT INTO bmh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iz ag petak pet awarem, ulis iz wanemin, ag iz koli i peilamamen, betei aiu ses, agtal guzenai ze mamamen, ‘Uwait nugtal du go tapai mamau, go Banou nugau wanib ebu alamau.’” ");
INSERT INTO bmh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus go Uwait ecesab muranemen zau banou wanib tempel zaueim dareun, utei noi unabun dabilena, gonugau tapaimaraneu dudu agen alaimai, auremen, “Na zau e suban uligaiba, alien.” ");
INSERT INTO bmh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Gonug koli guzenai awareun, “Go iboi, ag ece unum pemen. Bo, iz ag petak pet awarem, iwai zaiagar agen alaimai, zau go unum eg wai mamau. Zau go memenin aiwag unum ulagai numau. Aiwag tub gonugau empip i damau.” ");
INSERT INTO bmh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Guzenaimai, Yesus go Oliv em manam ebu betei hoboi darena darena, gonugau tapaimaraneu dudu agtal go waugab alaimai, goagen go guzenai kanabai ze auremen, “Eisab go igul zumau? Na ig aigemen, dumam, ein igul amegai zuba, ig go ziwas abiu mamam?” ");
INSERT INTO bmh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Gonug koli awareun, “Ag gusig tapai dan. Dudu ipal agen alaimai, ag polu ze awaramam. Ag, goagal ze i don. ");
INSERT INTO bmh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Dudu ipal agen alaimai, izal wanim pataimai, guzenai ze mamam. ‘Iz Kristus iz ag koli imarabun du zom.’ Dudu asiu agen guzenai ze doimai, petak amam. Ag, izal tapaimaranem dudu, ag go dudu agal ze sesamarian. ");
INSERT INTO bmh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bo, ag amegai malai alamau ze mui malai saiu mui waiagab alaba, doimai, ag esilakian. Igul go petak amegai zumau. Bo, sisiarabun ziwas go pigai i zumau. ");
INSERT INTO bmh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Emgasag tub ebuan duailel agen asaimai, emgasag tub ebuan duailel abai iwai maimai, malaininamau. Emgasag ipal ebu mim zumau. Emgasag ipal ebu duailel we ziwas huia damamen. ");
INSERT INTO bmh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Igul go unum zumau go gonugau igul enai, air tub go mogoi wabun amegai mu banou wanem sul. ");
INSERT INTO bmh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Guzenaital, ziwas go ebu ag izal tapaimaranemin dudu agal iwai zaiagar agen gusig pataraimai, uhu banou maraimai, ugarebi, noumamamen. Em ebuan duailel unum agen ag en aiag sisilaimai, gasag hiacaramam. Ag izal tapaimaranemin dudu, gonun, ag duailel agen guzenaramam. ");
INSERT INTO bmh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Duailel asiu goagal oiagab petak emen, ziwas go ebu goagal oiagab petak emen utamamen. Guzenaimai, agzozou agal zaiagar abai iwai maimai, ag imaraimai, agal iwai zaiagar agal ebeagab maramam. ");
INSERT INTO bmh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ag guzenebi guzenebi, Satan nugau ze doimai, awaranemen dudu agen zoimai, duailel asiu polumarebi, go agal ze sesamoramam. ");
INSERT INTO bmh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ag igul go banou usalaba, duailel asiu agal zaiagar go en bisomag piaramamen, ag igul naliu go utamamen. ");
INSERT INTO bmh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bo, du in izal salau i utanem, go umkoskos gusig mai damau aiu ses sisiarabun ziwas ebu, Uwait nug go koli imaiamau. ");
INSERT INTO bmh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Duailel agen Uwait nugau Ze Naliupet emgasag duailel unum awarebi, duailel go ze go abiu maimai, doi dabi dabi, petak go sisiarabun ziwas alamau.” ");
INSERT INTO bmh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus nug koli eneun, “Ag ece eg pet tub go getal Uwait nugau ze doimai, awaraneun du Daniel nug ze meun usalamau pimamen. Ece eg pet go zoimai, Uwait nugau empip naliupet ebu zoimai tapai damau. (Ag ze go nanalanemen aba, suban dabilan.) ");
INSERT INTO bmh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ziwas go ebu duailel ag Zudia agaig ebu daremen ag em tabag ebu uminai simamen. ");
INSERT INTO bmh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Du tub go zau wag damau, go noimai, gonugau ece zaueim dareu i simai umau. Go pigai gaul uminai unamau. ");
INSERT INTO bmh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Du tub ougem salau mai damau, go gonugau iweu naliu zaueim dareu alai i umau. ");
INSERT INTO bmh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ziwas go ebu, ailel ag enimag a mui, ailel geleagar ap zai darem mui, ag bisomagar pet. ");
INSERT INTO bmh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ag Uwait auramamen, ‘Ze numau ziwas ebu ta, igual i mabun ziwas ebu, ece eg go alamau i uminamamen.’ ");
INSERT INTO bmh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ag uhu banou go getal i wanemen. Em awau usaleun ziwas ebu zoizoi ulis dareu, aiu ses han uhu guzenai koli i zumau. ");
INSERT INTO bmh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bo, Uwait nugau ziwas huia pigai hogu usaleun, einen, go igul go i guzeneu zob, duailel asiu i darem zob. Go duailel ipal imarabun isanarai meun, gonun, igul go pigai guzeneun. ");
INSERT INTO bmh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Du tub nug zoimai, guzenai awaramau, ‘Kristus e zoimai dareu!’ ta, ‘Go ulib e dareu!’ aimai, awaraba, ag gonugau ze doimai, oiagab petak i an. ");
INSERT INTO bmh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Dudu ipal agen alaimai, polumaimai, guzenai ze mamam, ‘Iz Kristus.’ Dudu ipal agen ze mamam, ‘Iz Uwait nugau ze doimai, awaranem du.’ Ag guzenemen, ag gugeg banban mui salau ipal beu beu mamamen. Ag duailel ipal Uwait nug nugau tapai mareun, polumaraimai, agal ameagab ebu igul go guzenamam. Polu ze awarebi, ag Uwait nugau duailel agal igul sesamoraimai, ag Uwait nugau igul utabun aimai guzenamam. Bo, agen igul go guzenarabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iz ag ze go awaremin suban don. Ein igul aiu ses zuabun dareu mui ulis mui iz ag awarem. ");
INSERT INTO bmh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Gonun, dudu ipal agen alaimai, guzenai awaramam, ‘Du Nugau Nag go du tamacag uzan alai dareu.’ Guzenai awarebi, ag betei i pian. Dudu go agen koli awaramam, ‘Go aleun ulibe zaueim wageimai dareu.’ Guzenai awarebi, ag goagal ze doimai, oiagab petak i an. ");
INSERT INTO bmh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Du Nugau Nag alamau ziwas pigai zumau, am zuaneu eiman amilaimai, noi betei am nuaneu ebu nuaneu sul guzental alamau. ");
INSERT INTO bmh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Egun noumaimai, belei damau go ebu, tumui asiu egun go beleu zabun betei gotulamam.” ");
INSERT INTO bmh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesus nug kolital eneun, “Uhu banou pet go unum zoimai unaba, am go umaum sul usalamau, geil go suban i hilamau, ureb emes wageim sisilai numam. Guzenebi, emes wagan ece gusig daremen unum iloialoiamau. ");
INSERT INTO bmh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Igul go guzenaba, esab tub Mesgai wag eiman aba, ag guzenai dabilan go Du Nugau Nag alamau. Duailel em ebu darem ag uminai manil mai dabi dabi, Du Nugau Nag Mesgai wag pi eiman gusig banou mui al eiman alaba, pimamen. ");
INSERT INTO bmh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Guzenaimai, gonug Uwait nugau tibur tub auraba, pulel huaba, saiu banou usalamau. Gonug Uwait nugau tibur ipal palautaraba, emgasag unum beteimai, Uwait nug gonugau duailel tapai mareun, imarai alai gotularai mamam.” ");
INSERT INTO bmh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesus nug koli awareun, “A gair nug ag am tapamau igul abai maramau. Guzenaimai, gair gau unum nuanina, a gau awau koli walu zuna, ag abiu mamamen, go am banou zuabun ziwas. ");
INSERT INTO bmh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Guzenai sul aiu ses igul go beu beu zuba, ag guzenai dabilan, Du Nugau Nag alabun ziwas hogu mai dareu. ");
INSERT INTO bmh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iz petak pet awarem, duailel em e ebu darem ag i noumamamen ebu igul go guzenai zumau ag pimamen. ");
INSERT INTO bmh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Emes em mui dareu go unum tamamau. Bo, izal ze i tamamau, muzmuz damau.” ");
INSERT INTO bmh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesus nug koli eneun, “Du tub nug Du Nugau Nag alamau gil i abiu mamau. Uwait nugau tibur han go en i abiu. Gonugau nag nug han go i abiu. Izal mekai nug sag go gil abiu. ");
INSERT INTO bmh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Getal Noa dareun ziwas ebu, duailel agen goagal igul beu beu guzenai daremen sul, Du Nugau Nag koli alamau ziwas ebu duailel guzental guzenai damamen. ");
INSERT INTO bmh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Zewei banou i usalau ebu duailel go ee zai daren, ze zai daren, du air egarai daremen, go guzenai daren daren, Noa go tebil oug sieun. ");
INSERT INTO bmh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bo, go igul zuabun i doi daren. Zewei banou zoimai, duailel unum igarai zeun. Igul go guzenemen sul ag guzenebi, Du Nugau Nag koli alamau. ");
INSERT INTO bmh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ziwas go ebu, du aliag ougem salau mai damamen ebu tibur agen alai du tub imai aimai, du tub utei unamam. ");
INSERT INTO bmh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ailel aliag ma sakai damam ebu, air tub alai imai aimai, air tub utei unamam. ");
INSERT INTO bmh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Guzenamau, gonun, ag awau tapai dan. Einen, ag agal Dubanou Ban nugau alamau gil ag han i abiu. ");
INSERT INTO bmh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bo, zau atag du gonug zob du tub ein ziwas umaum zoimai gonugau zau bigacaimai, zaueim siabun abiu maimai, go i ninamau, go awau tapai daneu. Go du go ulagzaba, gonugau zaueim i ulagai simau. ");
INSERT INTO bmh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ag han guzental umkoskos suban gumei dan. Einen? Du Nugau Nag go i abiu wag alamau, gonugau alamau gil ag han i abiu.” ");
INSERT INTO bmh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesus nug koli awareun, “Salau du in go dabeleu naliu a go ze sesamoraneu? Du go sag gonugau gumaneu du nug tapai mina, gonug salau duailel ipal gumaraimai, goagal ee marai damau. ");
INSERT INTO bmh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Salau du go gue guzenamau, gonugau gumaneu du alaba, go siksikamau. ");
INSERT INTO bmh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iz petak pet awarem, salau du go gue gonugau du banou nug gonugau ece unum gumabun tapai muramau. ");
INSERT INTO bmh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bo, salau du tub go dabeleu naliu tam, go guzenai dabilamau, ‘Izal gumilaneu du go pigai alab tam.’ ");
INSERT INTO bmh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Guzenaimai, gonug salau zaugul ipal, ugaraimai, ze gusig zaimai, ameg kualilai damau. ");
INSERT INTO bmh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Go guzenaba aba, gonugau gumaneu du i abiu wag alaimai, busil higwag aimai, zamoraba, polumanemen dudu abai betei daimai, aceg kititkatutai, damau.” ");
INSERT INTO bmh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesus nug koli awareun, “Uwait nug duailel gumarabun ziwas zumau go gonugau igul enai. Ailel magun houhou agen agal al oimai, du tub air awau oun go betei abu ebu peimai, imabun betemen. ");
INSERT INTO bmh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ailel go magun houhou tubaim tabkuai go goagal dabeleu naliu tam, tubaim tabkuai agal dabeleu naliu a. ");
INSERT INTO bmh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ailel go dabeleu naliu tamacag agen goagal al oi alemen, bo, goagal al ze banou tam. ");
INSERT INTO bmh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bo, ailel dabeleu naliu a agen goagal al ebuan ze dalim mui kapeun oimai alemen. ");
INSERT INTO bmh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Air go du oun go pigai alab tam. Guzenina, ailel houhou go ameswagena, ninemen. ");
INSERT INTO bmh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Go nine ninen, umaum du tub nug guzenai ul eun, ‘Air du awau oun du go aleu! Ag abu ebu betei peiban, imai alan!’ ");
INSERT INTO bmh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ailel houhou ag go ul doimai, asaimai, goagal al suban memen. ");
INSERT INTO bmh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gonun, ailel go tabkuai go dabeleu naliu tamacag agen zaiagar dabeleu naliu a awaremen, ‘Ig agal al ebuan ze tub daba ig goriai migen. Igual al ze tamacag, gonun, noumamoroi.’ ");
INSERT INTO bmh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bo, ailel go dabeleu naliu a agen koli guzenai awaremen, ‘Tam, igual ze e ag abai iborain tam, igual al ebuan sag dareu. Ag awau betei beu, gau macan.’ ");
INSERT INTO bmh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Guzenaimai, ailel go dabeleu naliu tamacag, go ee palautanem zau ze gau mabun wanen wanen, air du oun go aleun. Ailel dabeleu naliu a ag go alina, uligaimai, go dual ee zabun zaueim ereg siemenin. Guzenina, im gebei memenin. ");
INSERT INTO bmh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Guzenina, ailel tabkuai dabeleu naliu tamacag go koli alaimai, guzenai ze menen, ‘Dubanou Ban, Dubanou Ban, na ig im oitai migen.’” ");
INSERT INTO bmh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aurina, du go nug koli guzenai awareun, “Petak pet, iz ag i abiu.” ");
INSERT INTO bmh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Guzenaimai, Yesus tatau ze go awaraimai, go duailel koli guzenai awareun, “Du Nugau Nag go alamau gil ag i abiu, gonun, ag awau tapai dan.” ");
INSERT INTO bmh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Uwait nug duailel gumarabun ziwas zumau go gonugau igul enai. Du tub gonugau zau utei uzan tub pulig unabunaimai, gonugau salau dudu awarina, go alina, gonugau ece unum goagal ebeagab meun. ");
INSERT INTO bmh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Go goagal igul uligaimai, aiwag ata atai guzental mareun. Go du tub aiwag tausen tabkuai moroun, du tub go tausen aliag moroun, du tub go tausen tutak moroun. Guzenaimai, go utarai waneun. ");
INSERT INTO bmh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Guzenaimai, go wane wanena, du go aiwag tausen tabkuai oun go aiwag go sil salau maimai, koli tub tausen tabkuai salau go ebuan oun. ");
INSERT INTO bmh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Du tub go guzental aiwag tausen aliag oun go han salau maimai, koli tub tausen aliag oun. ");
INSERT INTO bmh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bo, du tub go aiwag tausen tutak oun, go gue em eleimai, ob oug wageimai mina, dareun. ");
INSERT INTO bmh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ziwas asiu wanena, go gumaraneu du gonugau salau dudu aiwag mareun, go aiwag en ze kasabun koli aleun. ");
INSERT INTO bmh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Salau du tub go aiwag tausen tabkuai oun go waugab zoimai, guzenai aureun, “Banou, getal na iz aiwag tausen tabkuai milemen, iz go aiwag sil salau maimai, koli tub tausen tubkuai omin. E na pen!” ");
INSERT INTO bmh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Guzenina, gonugau gumaneu du nug koli guzenai aureun, “Na salau du naliu. Na salau ginampet suban gumemen, gonun, iz na salau banou ebu mizemina, na salau gumamam. Gonun, na iz ibail beteimai, siksikai damam.” ");
INSERT INTO bmh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Guzenina, salau du tub go aiwag tausen aliag oun, go han zoimai, guzenai aureun, “Banou, nagen iz aiwag tausen aliag milemen. Na e pen. Iz koli salau maimai, tub tausen aliag omin.” ");
INSERT INTO bmh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Guzenina, go gumaraneu du nug aureun, “Na salau du naliu. Na salau ginampet suban gumemen, gonun, iz na salau banou ebu mizemina, na salau gumamam. Guzenaimai, na iz ibail beteimai, siksikai damam.” ");
INSERT INTO bmh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Guzenina, salau du tub aiwag tausen tutak (1,000) oun du go han zoimai, guzenai aureun, “Banou, iz abiu na pigai ainsisilaneun du. Guzenaimai, du tub nug gonugau ougem ee ug beun, na gonun ee silai wacanem. Na du tub nug gonugau ougem ee ug hiacaneun, na gonun ee tulai wacanem. ");
INSERT INTO bmh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gonun, iz uminaimai, nait aiwag tausen tutak milemen, iz aiwag go oi betei em eleimai, em oug memin. Nait aiwag e na pen.” ");
INSERT INTO bmh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Guzenai aurina, gonugau gumaneu du nug salau du go guzenai aureun, “Na salau du egonou! Na wasig pag du. Du tub nug gonugau ougem ee ug beun, iz gonugau ee silai wacanem ta? ");
INSERT INTO bmh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Gonun, na izal aiwag aiwag zau ebu mabun einen utemen. Iz koli guzenai alemin, aiwag go mui aiwag ipal mui wai.” ");
INSERT INTO bmh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Guzenai auraimai, gonug salau dudu ipal awareun, “Ag go ebuan aiwag tausen tutak ebegalau oimai, du aiwag tausen houhou (10,000) a muramamen.” ");
INSERT INTO bmh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gonug koli awareun, “Iz petak pet awarem, du in go ece asiu a, go salau macaneu, go du go Uwait nug ece ipal asiu pet muramau. Guzenaba, du go ece asiu a damau. Bo, du in go ece ginampet a salau i macaneu, gonugau ece unum ebegalau umau. ");
INSERT INTO bmh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wasig du go egonou, ag go imaiban, seseim hamacebi, umut oug noi damau. Go dudu wein aimai, aiag katutai daremen abai ereg damam.” ");
INSERT INTO bmh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ziwas go ebu Du Nugau Nag go gumaraneu du banou king sul, go alaba, Uwait nugau tibur abai ereg alamam. Guzenaimai, go gonugau biz ebu hoboimai, duailel sisiaramau. ");
INSERT INTO bmh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Em ebuan duailel emgasag gasag darem, go unum go waugab alebi gonug duailel ipal tubaim dou maraimai, duailel ipal tubaim dou maramau. Dudu agen sipsip meme mui gumaraimai, dou maranemen sul, sipsip tubaim dou maraimai, meme tubaim dou maranemen sul guzenamau. ");
INSERT INTO bmh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Gonug duailel oiagab petak emen ag gonugau ebeg naliu eiman maramau, duailel ipal ag oiagab petak ab tam go ag ebeg nanai eiman maramau. ");
INSERT INTO bmh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Guzenaimai, gumaraneu du banou king nug guzenai awaramau, “Duailel izal ebe naliu eiman darem, ag izal Mekai nug tapai mareun. Getal em usalab tam ebu, izal Mekai nug nugau gumaraneu uzan agal tapai mareun, ag umamen.” ");
INSERT INTO bmh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gonug guzenai awaramau, ‘Iz we daremin, agen iz ee milena, zemin. Iz ze usegiwena, agen iz ze milena, zemin. Iz uzan tuban du sul alemin, agen agal zaueim imailei siemenin. ");
INSERT INTO bmh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Iz tibur galau tamacag, gaul daremin, agen tibur galau milena, tuagemin. Iz ebeu daremin, agen alai gumilemen. Iz hiacaranem zau oug daremin, agen betei peilemenin.’ ");
INSERT INTO bmh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Gonug guzenai awaraba, dudu naliu agen koli go guzenai auramam, ‘Banou, eisab na we daremen, ig na ee mizemun? Eisab na ze usegniwena, ig na ze mizemun? ");
INSERT INTO bmh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ig ein ziwas ebu na uzan tuban du sul peizaimai, igual zaueim imaiz betemun? Eisab ig na tibur galau tamacag daremen peizaimai, tibur galau mizemun? ");
INSERT INTO bmh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na ein ziwas ebu ebeu daremen ta hiacaranem zau oug daremen, ig betei uligizemun?’ ");
INSERT INTO bmh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Go guzenai aurebi, go gumaraneu du banou king nug koli awaramau, ‘Ag petak pet awarem, ag izal du tub gonugau wanib banou tamacag, ag go isanoromen, du go sag isanurab tam, ag go iz isanilemen.’ ");
INSERT INTO bmh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Guzenaimai, gonug duailel go gonugau ebeg nanai eiman daremen, guzenai awaramau, ‘Ag enan, Uwait nugau amegwab ag ze asiu enimag ebu mui. Ag ab i noumaneu ebu beten. Ab go izal mekai nug Satan gonugau tibur abai ereg tapai mareun go ebu ag ereg noi damamen. ");
INSERT INTO bmh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Go einen, iz getal we daremin ag iz ee milab tam, iz ze usegiwena, ag iz ze milab tam. ");
INSERT INTO bmh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Iz uzan tuban du sul alemin, agen agal zaueim imailei bitab tam. Bo, iz tibur galau tamacag daremin, agen tibur galau tub milab tam. Iz ebeu a daremin agen gumilai dab tam. Iz hiacaranem zau oug daremin ag iz betei peilab tam.’ ");
INSERT INTO bmh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Guzenai awaraba, agen go koli auramamen, ‘Banou, na eisab we daremen ig uligizemun, na eisab ze usegniwena, na eisab na uzan tuban du sul alemen, na eisab na tibur galau tamacag daremen, na eisab ebeu a daremen, na eisab hiacaranem zau oug betei daremen, ig na isanizab tam?’ ");
INSERT INTO bmh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Go gumaraneu du banou king nug koli ag guzenai awaramau, ‘Iz ag petak pet awarem, ag izal du tub gonugau wanib banou tam, ag go isanorab tam, go ag iz isanilab tam.’ ");
INSERT INTO bmh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Gonun, duailel go ag ab banou i noumaneun ebu noi damamen, bo, duailel naliu ag sag petak muzmuz awau damamen.” ");
INSERT INTO bmh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus nug ze go awaraimai, gil go ebutal gonugau tapaimaraneu dudu awareun, ");
INSERT INTO bmh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ag abiu imabun ziwas gonugau wanib Pasowa gil aliag bitaba, ziwas go zumau. Du Nugau Nag ziwas go ebu gonugau iwai zaugul agen eg moroimai, a gegeulanau ebu asai mamam.” ");
INSERT INTO bmh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Go ziwas ebutal Uwait ula dacanemen dudu banban ipal mui, uzan gumanemen dudu banban mui agen Uwait ula dacanemen dudu agal gumaraneu du banou, gonugau wanib Kaiapas nugau zaueim betei gotulemen. ");
INSERT INTO bmh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Guzenaimai, go Yesus gusig pataimai, webi, noumabun ze wage wageimai patemenin. ");
INSERT INTO bmh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bo, go enemen, “Ig go imabun ziwas go ebu i wab, duailel agen asaimai, ig ibaig banban alalamam.” ");
INSERT INTO bmh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betani uzan du tub, gonugau wanib Saimon, getal go ebeu gusig sug (leprosi) mui dacaneun, Yesus simai gonugau zaueim dareun. ");
INSERT INTO bmh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Guzenaimai, go zaueim hoboimai, ee zina zina, salau air tub nug dalim naliu a ilau sous naliu mui oi zoimai, Yesus nugau gagalig ebu esikeun. Air go getal aiwag banou sil a ilau go gau meun. ");
INSERT INTO bmh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesus nugau tapaimaraneu dudu agen igul go uligaimai, aicag sisilai zuna, guzenai ze menen, “Air go nug einen a ilau sous naliu mui gaul sakeu? ");
INSERT INTO bmh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ig a ilau go dudu ipal maremun, gau mebi, gonun aiwag banou oimai, duailel ecesab tamacag marabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Guzenina, Yesus goagal dabeleu abiu maimai, gonug guzenai awareun, “Ag einen air go ougab eg moroimai, uhu moromen? Go igul naliu pet go iz ebilab guzeneu. ");
INSERT INTO bmh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Duailel ecesab tamacag go ag abai umkoskos damamen. Bo, iz ag abai umkoskos ban i danai. ");
INSERT INTO bmh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Air go a ilau sous naliu mui izal enim ebu esikeun, go iz noumemin, ob heilabun enim tabug suban uluseu. ");
INSERT INTO bmh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iz ag petak pet awarem, dudu agen Uwait nugau Ze Naliupet e em e ebu duailel unum awarai aidaimai, igul go air e nug meun go han awaramam. Guzenaimai, duailel ag go en dabilamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Yesus nugau tapaimaraneu dudu begurug ebuan du tub, gonugau wanib Zudas Iskariot, go Uwait ula dacanemen dudu banban waiagab beteimai, gonug guzenai kanabarai awareun, “Iz Yesus agal ebeagab memin, agen iz ein ece milamamen?” Guzenina, goagen aiwag houhou ainarai (30) nanalaimai, go moromen. ");
INSERT INTO bmh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ziwas go ebu Zudas go Yesus gonugau iwai zaugul ebeagab mabun abu itanai dareun. ");
INSERT INTO bmh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bret zis tamacag agaimai zanemen gil go amegai zuna, Yesus nugau tapaimaraneu dudu agen go guzenai kanabai ze auremen, “Ig nait Pasowa gil ebu ee zabun empip eru ebu kasai mizamam?” ");
INSERT INTO bmh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Guzenina, gonug gonugau tapaimaraneu dudu guzenai awareun, “Ag Zerusalem ban uzan sieiban, go ebu du go guzenai auran. ‘Igual Dubanou Ban nug, guzenai aigeun, “Izal utarai unabun gil waiagab go zou, gonun, iz izal tapaimaranem dudu abai Pasowa gil ebu nait zaueim alai ee zamam.” ’” ");
INSERT INTO bmh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Guzenina, Yesus nug gonugau tapaimaraneu dudu ze go awareun sul, go betei, Pasowa gil ebu ee zabun empip kasai memenin. ");
INSERT INTO bmh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Umusig mina, Yesus gonugau tapaimaraneu dudu abai zaueim go ee zabun hobemen. ");
INSERT INTO bmh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Go hoboimai, ee zai zai darena, gonug guzenai awareun, “Iz ag petak pet awarem, du tub ag ula dareu gonug iz izal iwai zaiar agal ebeagab mamau.” ");
INSERT INTO bmh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Go guzenai ze mina, goagal oiagab uhu usaleun. Go tutak tutak agen go guzenai kanabai ze auremen, “Dubanou Ban, na iz en anem ta? Iz tam ta?” ");
INSERT INTO bmh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus nug koli awareun, “Du go iz ibail ereg tebil tutak ebu gonugau bret il oug maimai, oimai zimau, gonug iz izal iwai zaiar agal ebeagab mamau. ");
INSERT INTO bmh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Uwait nugau ze nug eneun sul, Du Nugau Nag unamau, bo, du gonug gonugau iwai zaugul agal ebeagab mareun, du go gue bisoua. Du go anag nug soligweun ziwas ebu noumeun zob, go uhu ginampet. Guzenab tam, gonun, aiu ses Mesgai wag go uhu banou pet umau.” ");
INSERT INTO bmh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Du go Yesus gonugau iwai zaugul ebeagab marabun du, Zudas gonug guzenai ze meun, “Abai maranemun du, petak izan na igul go ebitab mai ta?” Guzenai aurina, Yesus nug koli aureun, “Io, nagtal go anem.” ");
INSERT INTO bmh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yesus gonugau tapaimaraneu dudu abai hoboi ee zai zai daren, go bret oimai, Uwait ‘Ese-e’ auraimai, ebeg sil kikakaraimai, gonugau tapaimaraneu dudu maraimai, eneun, “Ag oiban, zan. E izal enim tabug.” ");
INSERT INTO bmh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Guzenaimai, go koli wain ze gap mui oimai, Uwait auraimai, gonugau tapaimaraneu dudu maraimai, awareun, “Ag unum e gap ebuan ze zan. ");
INSERT INTO bmh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","E izal esep, Uwait nug izal esep sil ag abai baib awau meu. Izal esep esikaba, gonug duailel asiu agal igul eg zilagai maramau. ");
INSERT INTO bmh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iz ag petak pet awarem, iz koli e wain dab ebuan ze i zai, betei iz wain ze awau tub go izal Mekai nugau gumarabun uzan ag abai koli zai.” ");
INSERT INTO bmh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Guzenaimai, go kabal tub waimai, uzaneim noimai, Oliv em manam ebu betemenin. ");
INSERT INTO bmh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesus nug gonugau tapaimaraneu dudu awareun, “Ulis e umaum igul tub iz ebilab zuba, ag uligaimai, ag iz utilaimai, uminai unamamen. Uwait nugau ze nug guzenai ze meu. ‘Sipsip gumaneu du go izan wemin, sipsip inain go uminai beu beu teliteliamam.’ ");
INSERT INTO bmh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Go guzenamam, bo, iz noumaimai, koli usaimai, amegai Galili agaig ebu betemin, ag sesamilai bitamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita nug Yesus koli aureun, “Igul eg na ebizab zuba, uligaimai, go unum na utizai unamam. Iz tutak na i utizai.” ");
INSERT INTO bmh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus nug koli guzenai aureun, “Iz na petak pet aizem, ulis umaum toi i ulau ebu nagen izal wanim wagemaimai, ‘Iz go i abiu’ aimai ziwas ainarai ze mamam.” ");
INSERT INTO bmh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita nug koli aureun, “Petak pet, iz guzenai ze i mai. Bo, iz na ibaiz ereg noumanai.” Guzenina, tapaimaraneu dudu ipal agen han guzental auremenin. ");
INSERT INTO bmh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus gonugau tapaimaraneu dudu abai em tub wanib Getsemani beteimai, guzenai awareun, “Ag e ebu hoboi dan, iz ulib e Uwait aurabun betem.” ");
INSERT INTO bmh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Gonug Pita mui Zebedi nugau gelegul aliag abai imarai waneun. Gonugau ougab eg pet wina, go siksikab tam. ");
INSERT INTO bmh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yesus nug dudu ainarai go awareun, “Izal oiab uhu pet mina, wauiag kuatina, noumamoroi. Ag iz ibail e ebu awau tapai dan.” ");
INSERT INTO bmh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Go empip go uteimai, nugtal betei wageimai daimai, go ougab uhu mina, em ebu alai noimai, Uwait guzenai aureun. “O Mekai, nagen iz ebilab ebuan uhu oi amam go iboi. Bo, na izal dabeleu i sesamoren, na nait dabeleu tutak sesamoren.” ");
INSERT INTO bmh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Guzenaimai, go gonugau tapaimaraneu dudu ainarai go gabuai daremen zoi uligaraimai, asareun. Go Pita aureun, “Ag iz gumilaimai, awau dab einen utemen? ");
INSERT INTO bmh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ag i gabuan, awau daiban, Uwait auran. Guzenebi, Satan nug bimaiag i pimau. Iz abiu ag igul naliu guzenaporoi, bo, agal enimag gusig tam.” ");
INSERT INTO bmh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Guzenaimai, go kolital Uwait aurabun beteimai, Uwait guzenai aureun, “O Mekai, iz e noumabun gap nagen i oi hen, iz go zaimai, iboin nait igultal sesamorai.” ");
INSERT INTO bmh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Go koli zoi gonugau tapaimaraneu dudu go kolital guzental gabuai daremen uligareun. Go ames wagena, awau dabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Gonun, go koli utarai Uwait aurabun waneun. Go amegai Uwait aureun sultal ze gotal koli aureun. ");
INSERT INTO bmh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bo, go koli zoimai, gonugau tapaimaraneu dudu gabuai daremen uligaraimai, asaraimai, guzenai awareun, “Ag gabuaimai, i mai darem ta? Ag go don! Du Nugau Nag ebegarab durub waimai, dudu igul eg macanemen agal ebeag ebu mabun ziwas aleu. ");
INSERT INTO bmh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ag uligan! Du ulibe nug iz izal iwai zaiar ebeag ebu marabun go aleu. Ag asan! Ig betei go tulorabun unab.” ");
INSERT INTO bmh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus nug gonugau tapaimaraneu dudu ze go awarina awarina, gonugau tapaimaraneu dudu begurug ebuan du tub gonugau wanib Zudas nug go waugab aleun. Uzanan dudu banban mui, Uwait ula dacanemen dudu banban mui agen dudu asiu Yesus gusig patabun palautarena, Zudas sesamorai betemen. Go malaimanem maulzag mui malai hog mui patai alemen. ");
INSERT INTO bmh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zudas nug getal dudu go guzenai awareun, “Iz du go betei sibeg zukemina, ag guzenai dabilan du gotal ag gusig patamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gonun, Zudas go pigai Yesus waugab beteimai, guzenai aureun, “Umaseu, tapaimiganeu du!” auraimai, sibeg zukeun. ");
INSERT INTO bmh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Guzenina, Yesus nug koli aureun, “Zai, na erunabun alemen aiba na pigai guzenen.” Go guzenai ze mina, dudu goagen pigai zoimai, Yesus gusig patemen. ");
INSERT INTO bmh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Guzenina, du tub Yesus dual dareun nug, gonugau maulzag huia oimai, Uwait ula dacanemen dudu agal gumaranem du banou nugau salau du wai aimai gonugau dabug gau kuatai heun. ");
INSERT INTO bmh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Guzenina, Yesus nug du go aureun, “Nait maulzag oiba, koli gonugau zo oug zulagai men. Dudu ag siag sil malaimanemen ag siag sil ugarebi, noumamamen. ");
INSERT INTO bmh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bo, na i abiu ta? Iz izal Mekai auremin, gonug iz isanileimai, gonugau tibur asiu emgasag begurug eiman agal malai dudu sul zilaramau go palautarabun iboin. ");
INSERT INTO bmh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bo, izal Mekai nug isanilaba, gonugau ze agau ebu dareu go petak i zumau. Gonun, igul go nugtal iz ebilab zuabun eun zumau.” ");
INSERT INTO bmh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Guzenaimai, Yesus nug gonugau iwai zaugul awareun, “Ag malai mabun malai hog mui maulzag mui oimai, iz zob du sul gusig patilaimai, iwabun alemen ta? Iz gil umkoskos Uwait ecesab muranemen zau banou zaueim duailel tapaimaranemin, ag go ebu gusig patilabun utanemen. ");
INSERT INTO bmh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bo, ag igul go guzenina, Uwait nugau ze doimai, awaranemen dudu agen gonugau ze sikut wai memen go petak zoun.” Guzenina, ziwas go ebu gonugau tapaimaraneu dudu unum uminai wanemenin. ");
INSERT INTO bmh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dudu go agen Yesus gusig pataimai, Uwait ula dacaneu du banou pet gonugau wanib Kaiapas nugau zaueim imai betemen. Go ebu kasai ze tapaimaranem dudu mui uzanan dudu banban abai ereg go tulai daremen. ");
INSERT INTO bmh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Dudu go agen Kaiapas nugau zaueim Yesus imai siena, Pita go sesamarai, wage wageimai holoi holoi beteun. Guzenina, Pita simai, go ebu em gumaneu dudu abai hoboimai, Yesus erunaimai, koli imai numam, piabun aimai dareun. ");
INSERT INTO bmh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Uwait ula dacanemen dudu banban mui Zuda dudu banban ipal mui agen polu ze ipal Yesus enib ebu moroimai, erunai webi, noumabun aimai guzenemenin. ");
INSERT INTO bmh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dudu asiu zoimai, go enib ebu polu ze memen. Bo, go gonugau igul sisiai uligemen, go igul eg tub i meun. Dudu asiu ze mina, dudu aliag zoimai tapai daremen. ");
INSERT INTO bmh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Goagen guzenai ze memen, “Du go nug guzenai ze meun, ‘Iz go Uwait ecesab muranemen zau banou tigalaimai, gil ainarai ebu koli mai,’ gonug guzenai ze meun.” ");
INSERT INTO bmh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Guzenina, Uwait ula dacaneu du banou pet, Kaiapas nug goagal ameagab ebu tapai daimai, koli Yesus guzenai kanabai aureun, “Na einen go dudu agal ze aizemen koli awarabun utem? Na erunemen, gonun, na enim ebu ze mem.” ");
INSERT INTO bmh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bo, Yesus go ze mab tam. Gonun, Kaiapas nug kolital aureun, “Na Uwait, go muzmuz awau daneu, nugau wanib pataimai, nait ze gusig maimai, na ig aigen, na Kristus, Uwait nugau Nag ta, tam?” ");
INSERT INTO bmh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Guzenai aurina, Yesus nug koli aureun, “Io, nagen anem sul. Iz ag unum petak pet awarem, ziwas go ebu, Du Nugau Nag go Uwait, go gusig banou mui nugau ebeg naliu eiman hoboimai, Mesgai wag pi eiman koli alamau, pimamem.” ");
INSERT INTO bmh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kaiapas go ze go doimai, gonugau tibur galau bigagaimai, guzenai ze meun, “Du go gue Uwait ze biabial kuai ze aureu! Ig einen dudu ipal awaremun, alai gonugau enib ebu ze ipal mamam? Go Uwait ze biabial kuai ze aureun, ag domenin. ");
INSERT INTO bmh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ke, ag pen, agal dabeleu go erunamamen?” Go agen koli ze memen, “Go ze a, gonun, webi, noumamau.” ");
INSERT INTO bmh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Guzenaimai, goagen Yesus ebu sinocoroimai, ebeag sil wemen. Dudu ipal agen sibeg waimai, goagen go auremen, “Na Kristus, na ze doimai, awaranemen du aba, na ig aigen, io aigen, in nug na niweu?” ");
INSERT INTO bmh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita go Uwait ula dacanemen dudu agal gumaraneu du banou, Kaiapas nugau zau go gasageim hoboi darena, salau air tub nug zoimai, aureun. “Na Galili agaigan du, Yesus nugau zaug.” ");
INSERT INTO bmh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Guzenai aurina, Pita nug dudu go ameagab ebu Yesus nugau wanib wageimai maimai, eneun, “Na ze go anem go gonugau bigeg iz i abiu.” ");
INSERT INTO bmh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Guzenaimai, go koli zau og eiman tapai darena, salau air tub nug zoimai, duailel awareun, “Du e han go Nasaret uzanan, Yesus dual aidaneun du.” ");
INSERT INTO bmh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Guzenina, Pita nug ebeg wag maimai, koli eneun, “Petak pet, iz du go i abiu.” ");
INSERT INTO bmh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dai dai, dudu ipal pulig daremen, Pita waugab zoimai, guzenai auremen, “Petak pet, na Yesus nugau tapaimizaneu du tub. Nait ze mem zep nug na araog mizeu.” ");
INSERT INTO bmh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bo, Pita nug ebeg wag maimai, kolital eneun, “Petak pet, iz ag awarem! Iz polu ze mai uhu tub iz ebilab zumau. Iz du go i abiu!” Go guzenai ze mina mina, toi ul eun. ");
INSERT INTO bmh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Guzenina, Pita go Yesus nug ze getal aureun, koli dabeleun. “Toi i ulau ebu, na izal wanim wagemaimai, ‘iz go i abiu’ aimai ainarai ziwas ze mamam.” Gonun, Pita go uzaneim noimai, banban weineun. ");
INSERT INTO bmh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Em wagena, umaseu, Uwait ula dacanemen dudu banban mui uzanan ipal dudu banban mui, agen Yesus webi, noumabun ze patemenin. ");
INSERT INTO bmh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gonun, go us sil ebeg kiai maimai, Rom agal gumaraneu du Pailot ebeg ebu mabun imai betemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudas go, Yesus gonugau iwai zaugul ebeagab mareun, go Pailot nug Yesus waba, noumabun uligaimai, go koli Yesus en bisou peimai, koli betei Uwait ula dacanemen dudu banban mui dudu banban ipal mui go aiwag 30 go oun koli marabun beteun. ");
INSERT INTO bmh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Go betei, dudu go awareun, “Iz igul eg memin go du gue igul eg tub mab tam, izan gonugau iwai zaugul ebeagab memin, gonun, go wina, noumamoroi.” Goagen koli auremen, “Igul go iguan guzenemun ta? Nagtal guzenemen!” ");
INSERT INTO bmh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Guzenai aurina, Zudas go aiwag go Uwait ecesab muranemen zau banou zaueim hamaraimai, utei betei nugtal beu us waimai, noumeun. ");
INSERT INTO bmh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Uwait ula dacanemen dudu banban agen aiwag go oimai, enemen, “Go ee og esab memun aiwag, go igual kasai ze nug eneun, go unu a, gonun, ig Uwait ecesab muranemen zau banou ebuan aiwag mui i gotulai mab.” ");
INSERT INTO bmh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Go aiwag go oimai, mis patai macanemen dudu agal em tub gau maimai, uzan tuban duailel noumina, go ebu ob hiaranemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Gonun, em go wanib ‘Es em’ anem. Em go ulis han wanib patemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Getal Uwait nugau ze doimai, awaraneun du Zeremaia nug ze go mareun go petak usaleu. ‘Goagen aiwag 30 go Israel duailel agen go ee ogog esab memen aiwag oimai, go mis patai macanemen dudu agal em gau memen. Go Uwait nug iz aileun sultal.’ ");
INSERT INTO bmh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesus Pailot amegwab tapai mina, Pailot nug kanabeun. “Na Zuda duailel agal gumaranemen du banou king ta?” Yesus nug koli aureun, “Io, na anem guzental.” ");
INSERT INTO bmh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bo, Uwait ula dacanemen dudu banban mui, uzanan ipal dudu banban mui, agen Yesus enib ebu ze polumorona, gonug koli ze tub awarab tam. ");
INSERT INTO bmh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Guzenina, Pailot nug aureun, “Bo, ze go nait enim ebu memen, na duab tam ta?” ");
INSERT INTO bmh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Guzenai aurina, Yesus nug ze ginampet tub koli aurab tam. Guzenina, Pailot go dabeleu asiu oun. ");
INSERT INTO bmh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Agal i mabun ziwas wanib Pasowa ebu, Rom agal gumaraneu du banou nug wai tutak tutak ziwas go ebu du tub hiacaranem zau oug daneu utena, unaneu. Duailel agtal alai gotulaimai, du tub utena, unabun aurina, gonug du go utena, unaneu. ");
INSERT INTO bmh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ziwas go ebu du tub gonugau wanib Barabas gonugau igul egonou wanib mui, go hiacaranem zau oug daneu. ");
INSERT INTO bmh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gonun, duailel alai gotulina, Pailot nug awareun. “Ag dabileimen du in utemin, go unamau? Barabas ta, Yesus go Kristus em ta?” ");
INSERT INTO bmh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailot go abiu Zuda duailel go Yesus nugau igul naliu en acagsisilai usalemen, gonun, go waugab imai alemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Guzenina, Pailot go ze sisiaraneu biz ebu hoboi darena, gonugau wau nug ze tub palautai moroimai, aureun, “Nagen igul eg tub du go ebu i men. Go du go igul naliu macaneu. Iz umaum nineimai, wabil ebu go pemin, gonun, izal oiab uhu pet meu.” ");
INSERT INTO bmh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Uwait ula dacanemen dudu banban mui dudu banban ipal agen duailel dabuiag pataimai, awaremen, “Pailot auran, Barabas utaba, unamau. Yesus waba, noumamau.” ");
INSERT INTO bmh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailot nug kolital duailel kanabarai awareun, “Agal dabeleu du e aliag, iz du in utemin, unamau?” Goagen koli auremen, “Barabas utemen, unamau.” ");
INSERT INTO bmh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Guzenina, Pailot nug koli awareun, “Yesus, go Kristus emen, iz go erunai?” Goagen oiagsau tutak maimai, auremen, “Go a gegeulanau ebu asai men!” ");
INSERT INTO bmh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailot nug awareun, “Einen? Go ein igul eg meun?” Agen koli go a gegeulanau ebu asai memun, noumabun aimai gusig ze memen. ");
INSERT INTO bmh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Go duailel uligareun go malaininabun sul usalina, Pailot go ze tub marabun iborain tam, gonug, ze tebil mui oimai, duailel ameagab gonugau ebeg uluseun. Gonug eneun, “E izal uhu tam, izan du go wemin, i noumamau. Agenag guzenabun guzenan!” ");
INSERT INTO bmh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Duailel agen koli auremen, “Erunamau go noumaba, uhu go igual geleiger abai ereg umam.” ");
INSERT INTO bmh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Guzenina, Pailot nug Barabas utena, waneun. Guzenaimai, gonug gonugau malai du tub aurina, gonug Yesus esalau sul oimai, malai dudu ipal marena, agen a gegeulanau ebu asai mabun imai betemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Malai dudu agen Yesus Pailot nugau zau wanib Pretoriam zaueim imai betena, malai dudu ipal zaueim daremen ereg alai go tali talioroi daremen. ");
INSERT INTO bmh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Guzenaimai, malai dudu agen gonugau tibur galau zilagai moroimai, tibur galau tub epeu go ebu kulai moromen. ");
INSERT INTO bmh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Guzenaimai, go us kulam mui oimai, kukotoimai, gonugau gagalig ebu kulai memen. Ait kabit tub oimai, gonugau ebeg naliu eiman memen. Guzenaimai, go go waugab taubib waimai, ze biabial kuai auremen. “Na Zuda agal gumaranemen du banou, king, ig nait wanim ulapwag mem.” ");
INSERT INTO bmh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Goagen sino oroimai, ebeg ebuan ait kabit ebegalau oimai, go ait kabit gotal oimai gagalig poai memen. ");
INSERT INTO bmh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ag go ze biabial kuai unum aurai heimai, tibur galau go go ebuan zilagai oimai, koli gonugau tibur galau arugai moromen. Guzenaimai, go imai aimai, a gegeulanau ebu asai mabun imai betemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Rom agal malai dudu agen Yesus a gegeulanau ebu wabun abu ebu imai betena betena, du tub go Sairini uzanan koli ban uzan siabun aleun. Gonugau wanib Saimon, go abu ebu peimai, gusig pataimai, Yesus nugau a gegeulanau oimai, Saimon gamai morona, go Yesus sesamorai beteun. ");
INSERT INTO bmh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Go em tub wanib Golgota betemen. Go em wanib bigeg enai ‘eb gagalig gulam’. ");
INSERT INTO bmh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Guzenaimai, goagen wain ze gubugub munug sul mui kekulaimai, Yesus zabun aimai moromen. Bo, go wain ze go minob sil helwaipeun munugina, go i zeun. ");
INSERT INTO bmh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Guzenaimai, malai dudu agen Yesus a gegeulanau ebu asai maimai, go gonugau tibur galau ata atai wabun aimai, aiwag oimai, onemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Guzenaimai, go Yesus a gegeulanau ebu asai maimai, go ebu gumei daremen. ");
INSERT INTO bmh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ag go asai maimai, tabaugab dudu ipal agen ze tub enib ebu memen go guzenai sikut wai memen. ‘Du e Yesus, go Zuda duailel agal gumaraneu du banou, king.’ ");
INSERT INTO bmh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Guzenaimai, Yesus a gegeulanau ebu asai maimai, goagen igul eg memen du aliag imaraimai, du tub Yesus nugau ebeg naliu eiman asai memen, tub ebeg nanai eiman asai memen. ");
INSERT INTO bmh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Guzenina, duailel agen abu eiman beten alan ai daremen, go uligaimai, tabaiag kunkunaimai, ze biabial kuai aurai aurai wane anemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Goagen guzenai ze menen, “Nagen guzen anemen, na Uwait ecesab muranemen zau banou tigalaimai, gil ainarai ebu koli zau awau mai anemen. Guzenaimai, na Uwait nugau Nag zob, nagtal koli nait enim isanoroimai, a gegeulanau ebuan utei non.” ");
INSERT INTO bmh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Uwait ula dacanemen dudu banban mui kasai ze tapaimaranem dudu mui agen han guzental ze biabial kuai auremen. ");
INSERT INTO bmh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Go guzenai ze memen, “Go duailel ipal isanareun, nugtal koli enib isanorabun iborain tam! Zuda duailel agal gumarabun du banou king zob, go a gegeulanau ebuan utei nuba, ig go uligaimai, igual oigeb go en petak amam. ");
INSERT INTO bmh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Gonugau ougab Uwait nug en petak aimai, en aneu, ‘Iz Uwait nugau Nag aneu.’ Gonun, Uwait nug go isanuramau ta, ig uligai damam.” ");
INSERT INTO bmh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Igul eg memen dudu aliag goagen han go guzental ze biabial kuai auremen. ");
INSERT INTO bmh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Am gusig ban ula, am ilab tam, em unum umaum sul usalai betei am ameg ainarai umusig. ");
INSERT INTO bmh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Guzenai daren daren, am ameg ainarai waugab usalina, Yesus nug guzenai uleun, “Eloi, eloi, lama sabaktani.” Ze go bigeg enai. ‘Izal Uwait, izal Uwait, na einen iz utilem?’ ");
INSERT INTO bmh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Guzenina, duailel ipal go ebu tapai daremen agen go ul doimai, enemen, “Go du go Elaiza ulorou!” ");
INSERT INTO bmh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Guzenaimai, du tub nug pigai betei ecesab tub ambig sul oimai, wain ze munug, ait kabit ebu maimai, Yesus zabun muramoroi dabeleun. ");
INSERT INTO bmh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bo, duailel ipal agen du go auremen, “Ig gumei damun, Elaiza nug alai, isanuramau ta, ig uligai damam!” ");
INSERT INTO bmh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus nug kolital gusig pet ulaimai, gonugau dorog utei waneun. ");
INSERT INTO bmh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ziwas go ebutal, laplap Uwait ecesab muranemen zau banou zaueim asai memen dareun, wag eiman bigagai noi betei, aliag usaleun. Guzenina, mim banou zoimai, aitabag banban ula ebutal gugai heicareun. ");
INSERT INTO bmh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Guzenaimai, eb ob han oitina, getalan duailel go goagal oiagab Uwait en petak emen, noumemen, go koli unum wasemenin. ");
INSERT INTO bmh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesus go koli wasena, go noumemen duailel wasemenin go Zerusalem ban uzan betena, duailel asiu agen piaremen. ");
INSERT INTO bmh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Malai dudu agal du banou go gonugau malai dudu abai go Yesus gumei daremen, mim zoimai, igul beu beu zuna, uligaimai, go banban uminaimai, enemen, “Petak pet, go du go Uwait nugau Nag.” ");
INSERT INTO bmh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ailel asiu getal Galili agaig eiman Yesus isanorabun sesamorai alemen, go ereg tubaiman tapai daimai, Yesus erunamam aimai uligai daremen. ");
INSERT INTO bmh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ailel go ula, air tub gonugau wanib Maria go Magdala uzanan, air tub gonugau wanib Maria go Zems amag Zosep goagal anaiag, air tub go Zebedi nugau wau, mui, daremen. ");
INSERT INTO bmh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Umusig usalina, du tub aiwag asiu a du aleun. Gonugau wanib Zosep, go Arimatea uzanan, go han Yesus nugau tapaimaraneun du tub. ");
INSERT INTO bmh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Go Pailot waugab beteimai, Yesus nugau noumeun enib wabun kanabai aureun. Guzenina, Pailot nug gonugau malai dudu awarina, goagen Yesus nugau noumeun enib oi moromen. ");
INSERT INTO bmh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Guzenina, Zosep nug Yesus nugau noumeun enib oimai, tibur galau awau naliu ausiau sil kulai meun. ");
INSERT INTO bmh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Go gonugau ob awau nugtal nug nugau enib mabun outai meun, Yesus nugau noumeun enib aizau ob go oug meun. Guzenaimai, aitabag banou oimai, aizau ogusau tapelai maimai, utei waneun. ");
INSERT INTO bmh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria go Magdala uzanan, air tub gonugau wanib Maria, go ob waugab hoboimai, uligai daremen. ");
INSERT INTO bmh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nineimai, umaseu, imabun gil ebu Uwait ula dacanemen dudu banban mui kasai ze tapaimaranem dudu mui go Pailot dual alai gotulemen. ");
INSERT INTO bmh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Goagen guzenai auremen, “Du banou, ig ze tub getal du go polu ze meun, du gonug guzeneun domun dabelem, ‘Aiu ses gil ainarai ebu uteimai, iz koli asanai’ eun. ");
INSERT INTO bmh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Guzeneun, gonun, na nait malai dudu awaremun, goagen eb ob suban gumei damam, betei gil ainarai utamam. Guzenemun, gonugau tapaimaraneun dudu agen gonugau noumeun enib i zob umam. Na go i guzenab, goagen gonugau noumeun enib zob umam. Guzenaimai, duailel guzenai awaramam, ‘Go noumaimai, koli ob oug eiman waseun.’ Getal go guzenai polu ze meun, ‘Iz Kristus.’ Go ulis guzenai polumamam, ‘Go noumaimai, koli waseun.’ Go ulisan polu ze nug getal polu ze mareun zilauramau.” ");
INSERT INTO bmh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Guzenai aurina, doimai, Pailot nug dudu banban go awareun, “Malai dudu ipal imaraiban, betei go ob suban gusig gumamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Guzenaimai, go betei ob ebu aitabag banou us sil kiai maimai, seg maimai, malai dudu ipal agen go ob gumei daremen. ");
INSERT INTO bmh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Imabun ziwas mazicina, umaseu Ban Zobu ebu Magdala uzanan Maria mui, Maria tub dual go Yesus nugau ob piabun betemen. ");
INSERT INTO bmh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pigai mim banou zuna, Uwait Ban nugau tibur tub Mesgai utei noimai, aitabag banou ob ogusau tapelai memen ebuan ilacil betei maimai, go go ebu hoboi dareun. ");
INSERT INTO bmh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Gonugau siameg amel nugau hilanau sul. Gonugau tibur galau pi ausiau sul. ");
INSERT INTO bmh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Malai dudu ob gumei daremen, ag go uligaimai, esilakaimai, banban uminaimai, go dudu noumemen sul ninemen. ");
INSERT INTO bmh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Go guzenina, Uwait nugau tibur nug ailel aliag go awareun, “Ag i uminan. Iz abiu ag go du Yesus a gegeulanau ebu asai memen noumeun piabun itanemen. ");
INSERT INTO bmh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Go e ebu i dareu. Getal go ze meun sultal go koli waseun. Go gabuai memen empip alai pian. ");
INSERT INTO bmh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ag guzenaiban, pigai beteiban, gonugau tapaimaraneun dudu awaramamen. Yesus go ob ebuan koli waseun, go amegai Galili agaig beteu, ag sesamorai bitamamen. Ag go ebu betei pimamen. Izal ze e awarem subantal dabilamamen.” ");
INSERT INTO bmh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ailel aliag go uminemen, bo, pigai ob uteimai, siksikaimai, gonugau tapaimaraneun dudu awarabun betemen. ");
INSERT INTO bmh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","10","Abu ebu betena, Yesus nug pigai zoi piaraimai, awareun, “Zaug dual.” Guzenai awarina, goagen waugab zoimai, gonugau arab pataimai, gonugau wanib ulagwag morona, Yesus nug ailel aliag go awareun, “Ag i uminan. Ag betei izal tapaimaranemin dudu awarebi, Galili betei peilamam.” ");
INSERT INTO bmh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ailel aliag go abu ebu bete betena, ob gumemen malai dudu ipal agen ban uzan beteimai, Uwait ula dacanemen dudu igul banban go zoun unum awaremen. ");
INSERT INTO bmh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Uwait ula dacanemen dudu banban mui, uzanan dudu banban mui, agzozou ze pataimai, aiwag asiu oimai, malai dudu maremen. ");
INSERT INTO bmh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Goagen malai dudu guzenai awaremen. “Ag guzenai ze mamamen, ‘Ig umaum ninena, gonugau tapaimaraneun dudu agen zoimai, gonugau noumeun enib zob oi wanemen.’ guzenai awaran. ");
INSERT INTO bmh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Guzenina, Pailot go ze go duba, iguan go guzenai auramam, go igul eg tub i meun, gonun, ag go igul en oiagab eg i umau.” ");
INSERT INTO bmh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Guzenina, malai dudu agen aiwag go oimai, ze awaremen sultal sesamoremenin. Guzenina, ze go nug Zuda agal emgasag unum betei iboreun. Ze go Zuda duailel ulis guzental ze mai darem. ");
INSERT INTO bmh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesus nugau tapaimaraneun dudu nigbasig agen Galili beteimai, Yesus nug getal awareun em tabag go ebu betemen. ");
INSERT INTO bmh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Go ebu, go uligaimai, ulagwag moromen. Bo, tapaimaraneun dudu ipal go dabeleu aliag mui. ");
INSERT INTO bmh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus go waiagab zoimai, guzenai awareun, “Uwait nug Mesgai mui, em mui, gumabun gusig go unum iz mileun. ");
INSERT INTO bmh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gonun, ag emgasag unum beteiban, duailel go izal ze abai marebi, goagal oiagab kekulebi, izal tapaimaranem dudu usalebi, agen betei, Mekai nugau wanib mui, Nag nugau wanib mui, Ah Wes nugau wanib ebu, duailel ze ziwaramamen. ");
INSERT INTO bmh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ag ze go abai maremin agen mui koli duailel abai maramamen. Guzenamamen, iz ag abai muzmuz dai, guzental betei sisiarabun ziwas alamau.” ");
INSERT INTO bmh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uwait nugau Nag, Yesus Kristus, gonugau Ze Naliupet guzenai bigegwar. ");
INSERT INTO bmh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Getal Uwait nugau ze doimai, awaraneun du Aisaia, Uwait nugau ze guzenai sikut waimai, aneun, “Go don, izal ze oi aidaneun du palautemin, amegai alai, nait abu tuguiai kalai mizamau. ");
INSERT INTO bmh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Du tub go du tamacag uzan em ula ebu ulai dareu, ‘Dubanou Ban nugau abu suban kalai moron. Gonugau abu tuguiai moron.’” ");
INSERT INTO bmh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ze ziwaraneun du, Zon go du tamacag uzan usaleun. Usalaimai, duailel ze awarar, “Ag oiagab kekulan, agal igul eg semoron, alebiag, izan ze ziwaremin, Uwait nug agal igul eg zilagai maramau.” ");
INSERT INTO bmh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zudia agaigan duailel asiu mui Zerusalem uzanan duailel asiu mui Zon waugab betemen. Betemai, agal igul eg Uwait aurina, Zon nug Zordan ze oug ze ziwaranar. ");
INSERT INTO bmh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zon go egun kamel ulig oimai, tugaimai, go egun tub galau, let sul, gonugau bigug ebu tuageun. Gonugau iweiu naliu tam. Go ee naliu i zaneu, gonugau ee ta mui guap aug mui gosag zaneu. ");
INSERT INTO bmh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Gonug guzenai awareun, “Du tub ses aleu. Gonugau gusig izal gusig zilaoramau. Iz du naliu tam, gonun, gonugau arab galau han oi abun iz iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Izan ag ze sag ebu ze ziwaranem, bo, gonug Uwait nugau Ah Wes ab mui ze ziwaramau.” ");
INSERT INTO bmh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ziwas go ebu, Yesus Nasaret uzan Galili agaig uteimai, alaimai, Zon nug Zordan Ze oug Yesus ze zioreun. ");
INSERT INTO bmh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesus ze utei gasag eiman zondai, pei darendai, pigai Mesgai oitina, Uwait nugau Ah Wes meg kurumuk sul go ebu tabaugab nuna uliginar. ");
INSERT INTO bmh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Guzenaimai, du tub nugau zeu sul nug Mesgai wag guzenai ulanar, “Na izal mogoi pet, izal oiab nug na en noumeun. Izal oiab na en naliupet usaleu.” ");
INSERT INTO bmh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ziwas go ebutal, Uwait nugau Ah Wes nug Yesus go du tamacag uzan em ula ebu palautendai, bitar. ");
INSERT INTO bmh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Go du tamacag uzan em ula ebu, gil 40 darendai darendai, Satan nug bimag piar. Yesus go egun abai darendai. Uwait nugau tibur agen alaimai, go isanoronar. ");
INSERT INTO bmh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dudu agen Zon hiacaranem zau oug hina, Yesus nug Galili agaig beteimai, Uwait nugau Ze Naliupet duailel awaranar. ");
INSERT INTO bmh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesus nug guzenai awareun, “Ag go don, ulis, ziwas Uwait nug duailel gumarabun kalai meun ulis aleun dareu, gonun, agal igul eg uteiban, agal oiagab kekulan, Uwait nugau Ze Naliupet en oiagab petak an.” ");
INSERT INTO bmh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ziwas tub ebu, Yesus go Galili Ze Unig gasag eiman beteimai, Saimon gonugau amag Andru dual piareun. Go karuk wabun zo ze unig oug hei daremen. Einen, goagal karuk salau wanemen dudu. ");
INSERT INTO bmh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus nug piaraimai, guzenai awaranar, “Ag alai iz sesamilebi, izan ag duailel imarabun igul abai marai.” ");
INSERT INTO bmh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pigai goagal karuk wanemen zo uteimai, Yesus sesamorai betenar. ");
INSERT INTO bmh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesus go kolital aidaidai beteimai, Zebedi nugau gelegul aliag Zems zaug Zon dual piarar. Go tebil oug hoboi daremen, agal karuk wabun zo bigageun, gonun, pipiai daremen. ");
INSERT INTO bmh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Go han guzental Yesus nug ularen, goagal memeag Zebedi, gonugau salau dudu abai ereg tebil oug darendai, utaraimai, Yesus sesamorai betenar. ");
INSERT INTO bmh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Go Kapaneam uzan Zuda agal Imabun Ziwas Zobu ebu betenar. Go ebu, ag Zuda agal gotulanemen zaueim simai, Yesus nug duailel ze naliu abai mareun. ");
INSERT INTO bmh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Duailel go gonugau ze doimai, esilakinar. Einen, goagal kasai ze tapaimaranem dudu agen awaranem sul awarab tam. Go du tub wanib a nug ze meun sul donar. ");
INSERT INTO bmh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ziwas go ebu, du tub go wes eg mui go gotulanemen zaueim dareun. ");
INSERT INTO bmh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Wes eg go guzenai uleun, “Nasaret uzanan Yesus, na ig ein zegun alem? Na ig eg migabun alem ta? Iz abiu, na du tuguianau, Uwait waugaban alemen.” ");
INSERT INTO bmh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bo, Yesus nug wes eg go gusig ze auraimai, eneun, “Na soen, du go utei alien!” ");
INSERT INTO bmh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Guzenai aurina, go wes eg nug du go patai hiloiaimai, banban ulaimai, utei unar. ");
INSERT INTO bmh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Guzenina, duailel ag unum igul go uligaimai, esilakaimai, agzozou kanabinar, “Go ein igul pem? Ze awau ta? Du gue go wanib mui sul, go nug wes eg inain gusig ze awarendai, go gonugau ze doimai, sesamoranem.” ");
INSERT INTO bmh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Guzenina, pigai Galili agaigan duailel go Yesus ein salau mai aleun, unum domen. ");
INSERT INTO bmh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus go Zuda agal gotulanemen zau uteimai, Zems zaug Zon al Saimon zaug Andru goagal zaueim ereg siemen. ");
INSERT INTO bmh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","31","Saimon nugau tanau air go ebeu enib zabeg mui biz ebu gabuai daren, duailel agen pigai Yesus go en aurina, Yesus nug air go waugab simai tapai daimai, gonugau ebeg patai asai mina, ebeu go pigai utei wanena, go dudu agal ee mis marar. ");
INSERT INTO bmh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Am nondai, umusig duailel agen agal zaiagar ebeu mui ipal wes eg nug agal oiagab oug dareun mui, imarai Yesus waugab alinar. ");
INSERT INTO bmh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","34","Ban uzanan duailel alaimai, gonugau zau ogeim gotulaimai darenar. Gonug duailel asiu ebeu ata atai mui kasareun. Gonug wes eg asiu zamareun. Wes eg go ag Yesus abiu, gonun, Yesus nug ag soan awareun. ");
INSERT INTO bmh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Em suban i ilau, umaseu pet, Yesus asaimai, go uzan tub du zepag tamacag ebu beteimai, Uwait auranar. ");
INSERT INTO bmh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Saimon gonugau zaugul abai ereg go itanai betenar. Betei waugab beteimai, aurinar, “Duailel agen na itanizei darem.” ");
INSERT INTO bmh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Guzenina, Yesus nug awaranar, “Ig ag e ebu ipal uzan e uzan waugab darem ebu bitab. Iz go ebu han Uwait nugau ze awaranai. Einen, iz go gonugun Uwait nug palautilen, alemin.” ");
INSERT INTO bmh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Guzenaimai, go Galili agaig unum aidaimai, Zuda agal gotulanemen zaueim ata atai ebu Uwait nugau ze marai marai, wes eg mui zamaranar. ");
INSERT INTO bmh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Du tub ebeu leprosi mui Yesus waugab alaimai, taubibi aimai, ze gusig auranar, “Banou, na izal sui eg zilagai milabun iboin, bo, nait dabileu eiman sag guzenen. Na iz kasilemen, iz naliu manai.” ");
INSERT INTO bmh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus nug du gue bisou peimai, gonugau ebeg du go nugau enib ebu maimai, aureun, “Izan aizem, na naliu mamam.” ");
INSERT INTO bmh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Go ebeu leprosi pigai utei wanendai, go naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesus nug go gusig auranar, “Iz igul e guzenem na betei duailel ipal i awaren. Bo, na Uwait nugau ula dacaneun du waugab beteimai, nait enim naliu usaleun aba maremen, peizamam. Peizaimai, na Moses nugau kasai ze sesamorai, egun oimai, Uwait ulagwag moromen, go petak duailel unum abiu mamam, na koli naliu usalamam.” ");
INSERT INTO bmh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Du go gue Yesus nugau ze sesamorab tam, go beteimai, duailel ze unum areun. Guzenina, Yesus go ban uzan araog siabun iboi tam. Go uzan gasageim du tamacag ebu dareun. Bo, duailel asiu uzan tubaim tubaim unum go waugab alemen. ");
INSERT INTO bmh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ziwas ipal mazicina, duailel go Yesus Kapaneam uzan koli alaimai zaueim si dareu ze go domen. ");
INSERT INTO bmh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Duailel asiu alaimai go zaueim gotulaimai, pip unum oi poaimai, zau og han unum zoimai abu og tapelemenin. Guzenina, Yesus nug duailel ze naliu abai mareun. ");
INSERT INTO bmh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dudu ipal agen ebeu du tub gonugau ebeg arab egugweun aidabun iborain tam, dudu iwanarai agen gamai alemen. ");
INSERT INTO bmh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Duailel asiu agen abu tapelai darendai, du go Yesus waugab imai siabun iborain tam, gonun, go a gatugat ebu zau zagatag wag simai, Yesus dareun tabauguab zau zagatag buliaimai, go biag oug ebeu du biz mui Yesus waugab palautina, nuar. ");
INSERT INTO bmh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus nug goagal oiagab goen petak emen uligaimai, ebeu du go ebeg arab egugweun guzenai aureun, “Nagwai, iz nait igul eg zilagai mizem.” ");
INSERT INTO bmh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Guzenai aurina, kasai ze tapaimaranem dudu ipal hoboi daremen agal oiagab eim guzenai dabilemen, “Du gue einen guzenai aneu? Go Uwait ze biabial kuai aureu. Emenan du tub nug go igul eg zilagabun iborain tam. Uwait nugtal petak go igul eg zilagai marabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ziwas go ebutal, Yesus gonugau ougab eiman ein dabeleu go oiagab oug dareu abe maimai, guzenai awareun, “Ag einen agal oiagab oug go dabeleu oi daremen? ");
INSERT INTO bmh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Iz ein ze mabun iboin, ein ze mabun iboin tam? Iz arab egugweun du guzenai aurai, ‘Nait igul eg zilagai mizem’ ta? Iz arab egugweun du guzenai aurai, ‘Na asaimai, nait biz oimai, unamam.’ aurai ta? Iz ein ze anai, ag agal oiagab iz en petak amamen? ");
INSERT INTO bmh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Bo, Du Nugau Nag, go wanib a, go em e ebuan igul eg zilagai marabun iboin aimai abe mabun iz go guzenai.” Guzenai awaraimai, go nug ebeu du arab egugweun aureun, “Izan na aizem, asaimai, nait biz oiba, nait zau beten!” ");
INSERT INTO bmh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Du gue asaimai, duailel ameagab ebu pigai gonugau biz oimai, waneun. Duailel go igul go uligaimai, esilakaimai, Uwait nugau wanib ulagwag moroimai, enemen, “Getal ig guzenai igul i uliganemun.” ");
INSERT INTO bmh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus ze unig Galili gasag koli noi beteun. Duailel asiu alai go waugab gotulina, go nug Uwait nugau ze naliu abai marabun bigegweun. ");
INSERT INTO bmh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesus aidaidai beteimai, Alpius nugau nag gonugau wanib Liwai, go aiwag wanem zaueim hoboi daren uligaimai, aureun, “Na alai, iz sesamilen.” Guzenai aurina, Liwai asaimai, sesamorai waneun. ");
INSERT INTO bmh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesus nug takis aiwag wanemen dudu mui, igul eg macanemen dudu ipal abai ereg, Yesus sesamorai alemen mui, gonugau tapaimaraneun dudu mui, go ereg Liwai nugau zau gotulaimai ee zai hoboi daremen. ");
INSERT INTO bmh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Guzenina, Parisi ipal agen kasai ze tapaimaranem dudu banban, goagen Yesus igul eg go macanemen dudu mui, aiwag wanemen dudu abai ereg ee zai darendai, uligaimai, goagen Yesus nugau tapaimaraneun dudu awaremen, “Go einen igul eg macanemen dudu mui, takis aiwag wanemen dudu abai ereg ee zeu?” ");
INSERT INTO bmh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus nug ze go doimai, koli awareun, “Duailel ebeu tamacag ag ebeu kasaraneun du waugab i bitanemen, duailel ebeu a sag petak ebeu kasaraneun du waugab bitanemen. Go sul, iz duailel igul naliu macanemen ularabun alab tam. Iz duailel igul eg macanemen ularabun alemin.” ");
INSERT INTO bmh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ziwas tub ebu, Zon ze ziwaraneun du nugau tapaimaraneun dudu mui, Parisi dudu mui, agen ee ur dacanemen. Dudu ipal agen alaimai, Yesus kanabemen, “Zon nugau tapaimaraneu dudu mui, Parisi dudu mui, ee ur macanemen. Einen nait tapaimaranem dudu go ee i ur macanem?” ");
INSERT INTO bmh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus nug kolital awareun, “Du tub go air awau wabun aimai, gonugau zaugul abai, ag ee ur mabun iboi ta? Tam, ag ee i ur mamam. ");
INSERT INTO bmh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bo, ziwas tub ebu, dudu ipal agen du go air oun imai wanebi, go go abai i daba, ziwas go ebu ag oiagab eg uba, ee ur mamamen. ");
INSERT INTO bmh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Du tub gonugau tibur galau bigageun go tibur galau zig awau oimai, tibur galau muz ebu i galauai macaneu. Go guzenamau, ze ulusabun ziwas ebu, go tibur galau zig awau ginampet usalaba, gonugau tibur galau muz koli bigagaimai, biag banou usalamau. ");
INSERT INTO bmh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Du tub nug wain ze awau meme galau muz ebu i goriai macaneu. Go guzenamau, wain ze awau go siwalkuk aimai, meme galau muz bigagaimai, wain ze em ebu esikai numau. Go meme galau han ereg zilagamau. wain ze awau go meme galau awau ebu goriai memen, naliupet damau.” ");
INSERT INTO bmh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Zuda go agal Imabun Ziwas Zobu ebu, Yesus gonugau tapaimaraneu dudu abai wit wai ulaceman betemen. Betei daren, gonugau tapaimaraneu dudu agen ipal wit dab patai oimai, ugai, zemen. ");
INSERT INTO bmh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisi dudu ipal agen igul go guzenai uligaimai, Yesus auremen, “Uligen! Imabun Ziwas Zobu ebu, einen nait tapaimaranemen dudu agen igul go guzenemen? Igual kasai ze eim eneu Imabun Ziwas ebu igul go nou.” ");
INSERT INTO bmh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus nug koli awareun, “Ag Devit gonugau dudu abai we wagendai, erunemen ag sikut go nanalemenin ta? ");
INSERT INTO bmh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Uwait ula daneun du banou, Abiatar darena, Devit nug Uwait nugau zaueim simai, bret go Uwait moromen oi zeun. Bret go nou, Uwait ula danemen dudu agen sag bret go zabun iboin. Bo, Devit nug bret go zaimai, gonugau dudu marendai, go han zemen.” ");
INSERT INTO bmh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesus nug koli awareun, “Uwait nug amegai duailel patarai meun. Go ag en dabeleimai, Imabun Ziwas Zobu meun. Imabun Ziwas Zobu ebu, duailel naliu damamen, ag eg i umamen. ");
INSERT INTO bmh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Guzenaimai, Du Nugau Nag, go tutak nug Imabun Ziwas Zobu gumamau.” ");
INSERT INTO bmh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus go koli Zuda agal gotulanem zaueim sieun. Go zaueim du tub gonugau ebeg egweun mui dareun. ");
INSERT INTO bmh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Duailel ipal agen Yesus nug Imabun Ziwas Zobu ebu du go kasuramau ta, tam ta piabun gumei darenar. Einen, agal dabeleu go Imabun Ziwas Zobu ebu du go kasuraba, ag go enibwag ze mabun aimai, uligai darenar. ");
INSERT INTO bmh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus nug go dudu agal dabeleu abe maimai, du go ebeg egweun mui auranar, “Na duailel ameagab asaimai, alen!” ");
INSERT INTO bmh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yesus nug dudu banban kanabareun, “Igual kasai ze nug ein eu? Ig Imabun Ziwas Zobu ebu, igul naliu mai ta, igul eg mai ta? Ig dudu koli abai wabun ta, ta ugaremun, noumamam ta?” Gonug guzenai awarina, agen koli ze tub aurab tam. ");
INSERT INTO bmh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus nug go dudu uligaraimai, aigsisileun. Einen, goagal oiagab eg wina, uligaimai, go ougab uhu usaleun. Gonug du go ebeg egweun mui guzenai aureun, “Nait eben henen!” Go ebeg hina, gonugau ebeg pigai naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Guzenina, Parisi dudu go pigai zauan utei uzaneim noimai, Herot nugau dudu abai tulaimai, Yesus wabun ze patenar. ");
INSERT INTO bmh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus gonugau tapaimaraneun dudu abai go uzan uteimai, Galili Ze Unig waugab nunar. Galili agaigan duailel asiu ereg betenar. ");
INSERT INTO bmh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Duailel asiu Yesus nugau salau meun doimai, go waugab alemen. Zudia agaigan duailel mui, Zerusalem ban uzanan duailel mui, Idumia agaigan duailel mui, Zordan Ze gasag danemen duailel mui, duailel Tair uzan tubaiman mui, Saidon uzan tubaiman mui, danemen unum go waugab alinar. ");
INSERT INTO bmh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesus nug go duailel asiu uligaraimai, gonugau tapaimaraneun dudu awareun, “Duailel asiu iz suilem, gonun, ag tebil tub oi alebi, suban mebi damau, iz suilebi, go ebu simai hobai.” ");
INSERT INTO bmh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Getal Yesus nug duailel asiu kasareun, gonun, go en ebeu duailel agen agal ebeag sil Yesus patai auremen. ");
INSERT INTO bmh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Duailel ipal agal oiagab oug wes eg go agenag daremenin. Duailel go agenag Yesus uligaimai, go taubibaimai, gusig ulinar, “Petak, na Uwait nugau Nag.” ");
INSERT INTO bmh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bo, Yesus nug gusig ze areun, “Ag iz en duailel ipal i awaran!” ");
INSERT INTO bmh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus go em manam ebu sieun. Go dudu ipal go dual dabun igarabun ularena, go dudu gue Yesus waugab sinar. ");
INSERT INTO bmh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Gonug dudu begurug igareun. Go ‘Yesus nugau ze oi aidabun dudu’ wanimag mareun. Go duailel ipal Uwait nugau ze naliu marabun palautareun. ");
INSERT INTO bmh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yesus nug nugau gusig gue wes eg duailel goagal oiagab oug darem zamarabun go mareun. ");
INSERT INTO bmh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Go nug dudu begurug sag igareun. Goagal wanimag enai: Saimon (gonugau wanib tub awau Yesus nug meun Pita), Zems (Zebedi nugau nag), gonugau amag Zon (goagal wanimag awau mareun, Boanerges, go wanimag zebigeg ‘em guruaneu nugau nag aliag’), Andru, Pilip, Bartolomiu, Matiu, Tomas, Zems (go Alpius nugau nag), Tadias, tub Saimon (go ug tub wanib Serot ebuan), Zudas-Iskariot (go nug Yesus gonugau iwai zaugul ebeagab mareun). ");
INSERT INTO bmh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus go koli zaueim sina, duailel asiu koli go ebu alai gotulai darendai, Yesus gonugau tapaimaraneun dudu abai ereg go ee zabun iboin tam. ");
INSERT INTO bmh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesus nugau atagul, go Yesus nug igul go guzenina, ze doimai, goagen enemen, “Go kar weu,” aimai, go dual oimai, koli gonugau uzan imai unabun alemen. ");
INSERT INTO bmh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kasai ze tapaimaranemen dudu banban ipal go Zerusalem uzan an alaimai, noimai, ze guzenai awaremen, “Belsebul, gonugau wanib tub Satan, go tibur eg nugau wes Yesus nugau ougab oug simai gumei dareu. Belsebul go ipal tibur eg gumaraneu go nug Yesus gusig morona, wes eg zamaraneu.” ");
INSERT INTO bmh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Guzenina, Yesus nug ularena, waugab alina, tatau ze tub guzenai awareun, “Satan nug erunai koli Satan wai zamoraneu? ");
INSERT INTO bmh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Em gasag tutak ebuan duailel ag agzozou alalaimai, agzozou atelaimai, ag ziwas huia i damamen. ");
INSERT INTO bmh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Zau tutakan duailel ag han agzozou alalaimai, agzozou atelaimai, ag eg umamen. ");
INSERT INTO bmh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan, gumaraneu tibur eg nugau ug ag agzozou alalaimai, agzozou atelaimai, ag gusig i damamen. Ag unum tamamamen. ");
INSERT INTO bmh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Du tub nug du gusig tub nugau zaueim zau bigagai simai, esab gaul i umau. Amegai go zau atag du ebeg arab us sil kiai maimai, gonugau zauan esab unum umau. ");
INSERT INTO bmh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iz petak pet awarem, Uwait nug duailel agal igul eg mui, agal ze biabial kuai mui unum zilagai mamau. ");
INSERT INTO bmh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bo, du in go Uwait nugau Ah Wes ze biabial kuai auramau, Uwait nug du go nugau igul eg i zilagai muramau. Go igul eg go ebu muzmuz damau.” ");
INSERT INTO bmh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus nug guzenai awareun. Goagen getal anemenin, “Wes eg nug gonugau ougab oug si dareu,” gonun, Yesus nug guzenai awareun. ");
INSERT INTO bmh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ziwas go ebu, Yesus nugau anag amagul ereg alemen. Go uzaneim tapai daimai, du tub go Yesus dareun, aurabun palautemen. ");
INSERT INTO bmh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Duailel asiu agen Yesus talioroi daremen, Yesus auremen, “Nait anan amaiar go uzaneim tapai darem, itanizei darem.” ");
INSERT INTO bmh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Guzenai aurina, Yesus nug koli du go aureun, “Izal anikai in? Izal magiter inen?” ");
INSERT INTO bmh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Guzenaimai, duailel go waugab alai hoboi darem, ameg nug uligaraimai, awareun, “Uligaran, duailel e darem, go izal anikai magite! ");
INSERT INTO bmh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Duair inen go Uwait nugau dabeleu sesamoraneu, go duair petak go izal anikai, izal abi, izal magi.” ");
INSERT INTO bmh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus nug bigeg waimai, duailel Galili Ze Unig gasageim ze tapaimareun. Duailel asiu pet alai go waugab gotulina, go tebil tub wag simai hoboi dareun. Duailel go unum ze gasageim tapai daremen. ");
INSERT INTO bmh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Yesus nug tatau ze eimantal igul asiu tapaimareun. Go ze guzenai awareun, “Ag don. Du tub ee ug hiabun gonugau ougem beteun. ");
INSERT INTO bmh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ee ug hina, ipal abu ebu alai noun. Guzenendai, meg agenag zoimai oi zemen. ");
INSERT INTO bmh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ipal ee ug ai em ebu noun. Em naliu asiu tam, gonun, ee ug go pigai walu zoimai, gau mui usaleun. ");
INSERT INTO bmh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Am gusig zoimai, ee ug go walu zoun unum elareun. Ginib em ougab oug suban nuabun tam, gonun, unum gulaleun. ");
INSERT INTO bmh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ipal ee ug ebgeleu kulam ziu oug noimai, walu zoun. Kulam nug oi zendai, suban tapabun iboi tam. ");
INSERT INTO bmh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ipal ee ug em naliu ebu alai noun. Ee ug ipal walu zoimai, banou maimai, useg asiu memen. Ipal useg tutak tutak 30 mamau. Ipal useg asiu 60 mamau. Ipal useg asiu pet 100 mamau.” ");
INSERT INTO bmh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesus nug tatau ze go awaraimai, go guzenai awareun, “Duailel ag dabuiag a aba, ag ze go doimai, zebigeg abiu mamamen!” ");
INSERT INTO bmh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Duailel Yesus utei wanena, gonugau tapaimaraneun dudu begurug mui dudu ipal Yesus al ereg danemen agen tatau ze go zebigeg ein sulai aimai Yesus auremen. ");
INSERT INTO bmh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gonug koli guzenai awareu, “Uwait nug duailel gumarabun igul getal wageimai dareun. Ulis ag, izal tapaimaranem dudu, gonun, go zebigeg abai marai. Bo, duailel ipal uzaneim darem, iz ag gaul tatau ze eiman sag awarai. ");
INSERT INTO bmh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Guzenina, Uwait nugau ze doimai, awaraneun du Aisaia nug getal sikut weun ulis petak usaleu. Go guzenai aneun, ‘Ag ein esab agal amiag nug pianeu, bo, ag suban i pianemen. Ag ein ze agal dabuiag nug duaneu, bo, ag suban i doimai, zebigeg abiu I mamamen. Ag zebigeg abiu memen zob, agal oiagab kekulaba, Uwait nug agal igul eg unum zilagai mareu zob.’ Aisaia nug guzenai sikut weun.” ");
INSERT INTO bmh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Guzenaimai, Yesus nug gonugau tapaimaraneun dudu guzenai awareun: “Tatau ze go zebigeg ag abiu ta, tam ta? Iz tatau ze ipal awarem ag erunai abiu mamamen? ");
INSERT INTO bmh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ee ug tub du tub nug ougem heun, go Uwait nugau Ze. ");
INSERT INTO bmh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Duailel ipal ag ee ug go abu ebu noun sul. Ag Uwait nugau Ze domen. Gaul dabuiag nug doimai, pigai Satan nug zoimai, agal oiagab ougan ze oi hianeu. ");
INSERT INTO bmh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Duailel ipal ag ee ug ai em ebu noun sul. Ag ze doimai, oimai, pigai siksikanemen. ");
INSERT INTO bmh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bo, ze go agal oiagab oug noimai, ziwas ban i dacaneu, einen, dudu ipal agen ag ze go omen abiu maimai, uhu maramam. Guzenaimai, agal oiagab eg maimai, Uwait nugau Ze doimai, omen pigai unum utanem. ");
INSERT INTO bmh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Duailel ipal ag ee ug ebgeleu kulam ziu oug walu zoun, go gonugau igul enai, duailel ipal ag Uwait nugau Ze duacanem, bo, dai dai, ag em e ebuan igul dabeleimai, esab asiu go agal oiagab nug noumaimai, Uwait nugau Ze utanem. Go ze naliu omen kulam nug ee ug oi zacaneu sul suban i mamau. ");
INSERT INTO bmh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Duailel ipal ag ee ug em naliupet ebu noun sul, ag Uwait nugau Ze domen, agal oiagab oug maimai, suban sesamoranemen. Ag ze go naliu omen, ee useg asiu mamau. Useg ipal tutak tutak 30 mamau, useg ipal asiu 60 mamau, ipal dab asiu 100 mamau.” ");
INSERT INTO bmh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus nug awareun, “Ag al usaimai, mis oug ta, biz piu wageimai macanem ta? Tam, go al usaimai, wag asai macanem. Go petak. ");
INSERT INTO bmh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Guzenai, ein esab agal oiagab oug wageimai dacaneu, unum araog zumau. Ein esab dudu agen kulai macanem, aiu ses unum al hilanau ebu zuba, duailel pimam. ");
INSERT INTO bmh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Duailel ag dabuiag a, ag ze go doimai, zebigeg abiu mamamen!” ");
INSERT INTO bmh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesus nug kolital awareun, “Ag ze go domen suban dabilan. Ag dudu ipal esab maranemen sul, Uwait nug han ag esab maramau. Ag dudu esab asiu marebi, Uwait nug han ag kolital esab asiu maramau. Petak, gonug ag esab asiu maramau. Guzenaital, ag dudu ipal ibalagab ein igul macanem sul, Uwait nug ag ibalagab han guzenaital guzenamau. ");
INSERT INTO bmh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Du tub go dabeleu naliu ipal mui, du go Uwait nug dabeleu naliu ipal muramau. Bo, du in go dabeleu naliu tamacag, Uwait nug gonugau dabeleu ginampet patai dareu go unum koli ebegalaumau.” ");
INSERT INTO bmh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus nug ze tub awareun, “Uwait nug duailel gumaraneu igul go enai: du tub gonugau em ebu ee ug heun. ");
INSERT INTO bmh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Umaum du gue ninaneu, amban asaimai, gonugau salau ipal macaneu ebu waneun. Ee ug tub walu zuna, erunai ban meun du go i abiu. ");
INSERT INTO bmh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Em nug salau mina, ee ug walu zoimai, simai, useg meun. ");
INSERT INTO bmh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ee useg naliu mina, ougem atag du nug maulzag pataimai, kuatamau. Einen, ee wabun ziwas zoun.” ");
INSERT INTO bmh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus nug koli awareun, “Uwait nug duailel gumaraneu igul ein sulai dareu awarai? Iz tatau ze tub awaremin, don! ");
INSERT INTO bmh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Igul gue a paipai ug tub sul, a ug go ipal sul tam, go ginampet pet. ");
INSERT INTO bmh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Agen a ug go em nogoug ebu bina, go nug zaugul zilarai, go a banou pet usaleu. A go banou usalina, meg agen a ebeg go ebu saum dabun teu mamam.” ");
INSERT INTO bmh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus nug duailel Uwait nugau zebigeg mui i awaraneu go tatau ze eiman sag agal dabeleu dareu sul awaraneun. ");
INSERT INTO bmh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Go zebigeg tub mui duailel awarab tam. Go tatau ze eiman sag awaraneun. Bo, gonugau tapaimaraneun dudu nug al ereg darendai, go nug ag sag ze zebigeg unum abai mareun. ");
INSERT INTO bmh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ziwas go ebutal, em mazicina, Yesus nug gonugau tapaimaraneun dudu awareun, “Ig ze unig tubaiman bitab.” ");
INSERT INTO bmh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Go duailel asiu utaraimai, gonugau tapaimaraneun dudu ag tebil go Yesus getal simai dareun ebu simai, ereg wanemen. Tebil ipal han mui ereg wanemen. ");
INSERT INTO bmh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wol banou zoimai, ze kibikabor aimai, ze tebil oug noimai, kapeun. ");
INSERT INTO bmh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus go tebil seseim gagalig keket maimai, gabuai dareun. Gonugau tapaimaraneun dudu agen asoroimai, auremen, “Igul abai miganem du, ig ze nug oigamoroi! Na ig en i dabelem ta?” ");
INSERT INTO bmh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus nug asaimai, wol mui ze mui, go gusig ze aureun, “Iboi! Na uten!” Wol mazicina, ze ameg kuataimai, iautal toai daren. ");
INSERT INTO bmh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesus nug gonugau tapaimaraneu dudu awareun, “Ag einen uminai daremen? Ag izal igul asiu pemenin, bo, ag iz en oiagab petak ab tam ta?” ");
INSERT INTO bmh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ag gusig uminaimai, agzozou enemen, “Ein du eneneg? Wol ibut ze mui gonugau ze sesamoraneu.” ");
INSERT INTO bmh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus gonugau tapaimaraneun dudu abai tebil oimai, ze unig tubaiman gasageim, Gerasa duailel agal em ebu betemen. ");
INSERT INTO bmh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesus go tebil uteimai, em ebu silikai nuna, du tub wes eg mui go eb ob darem eiman dareun, alaimai, Yesus peun. ");
INSERT INTO bmh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Go eb hiaranemen agal aizau oug ninaneu. Du tub nug go gusig patabun pet iboi tam. Go us gusig sil arab ebeg kiai macanem, bo, go nug us gusig go kuataneun. ");
INSERT INTO bmh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dudu agen go umkoskos ebeg arab sen gusig sil kiai macanemen. Bo, gonug sen go unum kitkuat aneun. Du gue gusig pet, gonun, du tub nug go zilacurabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Go umkoskos umaum, amban, eb macanem aizau mui em manam wag mui daimai, gusig ulaimai, nugtal go aiwag sil nug nugau enib kitkuataneun. ");
INSERT INTO bmh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","7","Gonug Yesus pulig eim uligaimai, pigai alaimai, Yesus nugau arab waugab taubibi aimai, go en gusig uleun, “Yesus, na Uwait wag dareu nugau nag. Na iz erunilamam? Iz Uwait nugau wanib gusig pataimai, aizem, na iz uhu i milen.” ");
INSERT INTO bmh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Du go nug enai aureun, einen, Yesus nug amegai aureun, “Wes eg, na du go utei, alien!” ");
INSERT INTO bmh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesus nug go enai aureun, “Na wanim in?” Gonug koli aureun, “Izal wanim Asiu. Einen, ig wes eg asiu du gonugau ougab oug darem.” ");
INSERT INTO bmh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Guzenendai, wes eg agen ig em tub ebu i palautigen aimai Yesus gusig ze auremen. ");
INSERT INTO bmh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bo agen asiu em manam tub tubaiman ee zai daremen. ");
INSERT INTO bmh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gonun, wes eg go agen Yesus gusig ze aurinar, “Ig palautigemen, bo go daremen agal oiagab oug simam.” ");
INSERT INTO bmh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Guzenai aurina, Yesus nug awareun, “Iboi, ag alian!” Guzenai awarina, wes eg asiu du gue uteimai, bo goagal oiagab oug sinar. Bo gue asiu tausen aliag (2,000) sag. Go uminaimai, pigai em eg eiman beteimai, ze unig oug noimai, ze zaimai, nouminar. ");
INSERT INTO bmh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bo gumaranemen dudu go igul go uligaimai, pigai uminai beteimai, goagal uzan mui, ipal go uzan waugaban duailel unum awarinar. Awarina, doimai, duailel unum ein igul usaleun piabun aimai betemenin. ");
INSERT INTO bmh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Goagen Yesus waugab alaimai, du go getal wes eg mui dareun ulis go tibur galau tugaimai, dabeleu naliu mui hoboi darendai, pemen. Duailel ag go uligaimai, umininar. ");
INSERT INTO bmh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Duailel go Yesus nug go igul guzeneun uligaimai, agen betei, duailel ipal bo gue erunemen ze mui, du getal wes eg asiu gonugau ougab oug dareun go naliu usaleun ze mui unum awareun. ");
INSERT INTO bmh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Duailel ze go doimai, Yesus goagal uzan uteimai, uzan tub unabun aimai gusig ze aurinar. ");
INSERT INTO bmh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Guzenina, Yesus nug gonugau tebil wag siabun aimai, du go getal wes eg mui dareun naliu usaleun gonug Yesus gusig aureun, “Iz na ibaiz unai, na iz io ailamam ta?” ");
INSERT INTO bmh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Guzenai aurina, Yesus nug koli go io aurab tam. Gonug du go enai aureun, “Na nait uzan beteiba, Uwait nug na en bisom peimai, igul e ebitab meun nait ug unum awaramam.” ");
INSERT INTO bmh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Guzenai aurendai, du gonug beteimai, ban uzan houhou sag, wanib Dekapolis, go ebuan duailel Yesus nug go erunena, usaleun ze awareun. Duailel unum go ze go doimai, esilakaimai, dabeleu asiu unar. ");
INSERT INTO bmh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus go tebil ebu simai, Galili Ze Unig tubaim gasag koli beteun. Go ze gasageim us nogoug ebu nuna, duailel asiu alaimai gotulinar. ");
INSERT INTO bmh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Zuda agal gotulanemen zau gumaneun du tub, gonugau wanib Zairus, go alaimai, Yesus peimai, waugab zoimai taubibi aimai, gusig ze aureun, “Izal alegwai noumamoroi. Na alaiba, nait eben go ebu memen, go koli naliu usalamau.” ");
INSERT INTO bmh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesus ze uteimai, go du dual ereg beteun. Guzenina, duailel asiu go ereg Yesus sesamorai betemen. ");
INSERT INTO bmh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Duailel ula ebu, air tub dareun. Go geil ebeu umkoskos waneu, ebeu go gonugau wai begurug (12) sag dareun. ");
INSERT INTO bmh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ebeu kasaranemen dudu asiu agen go kasai maimai, mu asiu muranemen. Gonugau aiwag go ebeu kasaranemen dudu ebalagab poaneun. Bo, gonugau ebeu maziab tam, go ebeu banou oi dareun. ");
INSERT INTO bmh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Go dudu ipal agen Yesus en ze mina, doimai, go ula daimai, go Yesus seugab zoimai, Yesus nugau tibur galau patar. ");
INSERT INTO bmh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Go enai dabeleun, “Iz gonugau tibur galau sag pataimai, iz koli naliu manai.” ");
INSERT INTO bmh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Guzenaimai, go tibur galau patena, gonugau ebeu mazianar. Go doun, gonugau enib ebu ebeu tam eun. Go naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus nug gonugau gusig wanena, abe maimai, kekulaimai, awareun, “Inugau ebeg nug izal tibur galau pateu?” ");
INSERT INTO bmh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Gonugau tapaimaraneu dudu agen auremen, “Duailel asiu gotulaimai gagizem, na einen ‘Inugau ebeg nug iz patileu’ aimai awaremen?” ");
INSERT INTO bmh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bo, Yesus nug inug guzenileun aimai ameg nugtal itaneun. ");
INSERT INTO bmh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Air go ein igul go ebu usaleun abiu maimai, go banban uminaimai, Yesus waugab taubibi aimai, gonugau ze unum petak aureun. ");
INSERT INTO bmh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Guzenina, Yesus nug aureun, “Ainag, nait ounab petak eun, gonun, nait enim naliu usaleun. Na ounab selai mui alien. Nait ebeu unum maziamau.” ");
INSERT INTO bmh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus nug zemai daren, dudu ipal Zuda agal gotulanemen zau gumaneun du Zairus nugau zauan alaimai, Zairus auremen, “Zairus, nait alen noumeun. Na einen tapaimaraneun du salau muramam?” ");
INSERT INTO bmh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesus nug ze go doimai, Zairus aureun, “Na umin ien, nait ounab petak en!” ");
INSERT INTO bmh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Go guzenai auraimai, duailel asiu imarab tam. Pita, Zems zaug Zon (Zems nugau amag) go sag Yesus sesamorai betemen. ");
INSERT INTO bmh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Go Zairus nugau zaueim alina, duailel asiu agen manil maimai, saipag hei daremen. Yesus nug uligaraimai, awareun, “Ag einen saipag hei daremen? Ag einen manil mai daremen? Ainag go noumab tam, go gaul gabuai dareu.” ");
INSERT INTO bmh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yesus guzenina, go peimai, weloronar. Gonug duailel uzaneim nuabun palautaren, nondai, ainag nugau memeg anag abai ereg gonugau tapaimaraneu dudu ainarai mui, ag sag ainag nugau zau empip oug imarai siar. ");
INSERT INTO bmh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Simai, gonug ainag nugau ebeg pataimai, Zuda ze eiman guzenai aureun: “Talita kum”, ze go bigeg enai, ‘Ainag, izan aizem, na asen.’ ");
INSERT INTO bmh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Guzenina, ainag go pigai asaimai, kolital aidareun. Ainag go gonugau wai 12 sag. Duailel daremen go igul go uligaimai, banban esilakinar. ");
INSERT INTO bmh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesus nug ze gusig awareun, “Ag igul go pemen duailel ipal i awaran. Ulis ag ainag go ee ipal moron.” ");
INSERT INTO bmh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus uzan go uteimai, gonugau tapaimaraneu dudu abai ereg gonugau muz uzan wanemen. ");
INSERT INTO bmh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Imabun Ziwas Zobu ebu, Zuda agal gotulanemen zaueim simai, Uwait nugau Ze bigegwai tapaimareun. Duailel asiu gonugau ze doimai, esilakaimai, enemen, “Du gue ze eruan oun? Inug go dabeleu naliu morondai, go nug igul ata atai macaneu? ");
INSERT INTO bmh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Du gue igual zau macaneu du ta? Go Maria nugau nag ta? Gonugau amagul Zems, Zosep, Zudas (Zut), Saimon, gonugau abiagul abai ereg ag e ebu danem ta?” Ag guzenai ze maimai, ag go semuranem. ");
INSERT INTO bmh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Guzenina, Yesus nug goagal ze abe maimai, awareun, “Uzan ipal Uwait nugau Ze doimai awaraneu du, wanib go ulagwag mui, duailel agen agal oiagab go en petak anem, bo, nug nugau uzan pet wanib go ulagwag i macanem, gonun, nug nugau duailel mui, nug nugau ug mui, agen go semuranem.” ");
INSERT INTO bmh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Guzenina, go uzan go igul ipal mabun iboin tam. Go gonugau ebeg ebeu duailel tutak tutak ebalagab mina, naliu usalemen. ");
INSERT INTO bmh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesus nug duailel gonugau ze en oiagab petak ab tam, uligaimai, dabeleu asiu oun. Guzenaimai, Yesus gonugau uzan uteimai, uzan ipal beteimai, duailel Uwait nugau Ze tapaimaraneun. ");
INSERT INTO bmh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ziwas go ebu, Yesus nugau tapaimaraneu dudu begurug sag ularendai, waugab alina, wes eg oiabun gusig maraimai, du alia alia palautareun. Go alia alia salau mabun awareun. ");
INSERT INTO bmh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Guzenaimai, go nug ag guzenai awareun, “Ag abu ebu bitabun esab tub i on. Bo, ag taru tutak oi alian. Ag ee ipal ta, agal zo ta, aiwag ipal esab gau mabun ta, i oi unamamen. ");
INSERT INTO bmh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ag agal aramag galau sag maiban, tibur galau alia i oi unamamen. ");
INSERT INTO bmh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ag uzan tub betebi, go ebuan duailel agen imarebi aba, go dudu agal zau sag damamen. Aiu ses zau go uteimai, uzan tub bitamamen. ");
INSERT INTO bmh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Gonun, duailel agen imarabun utebiag, agal ze duabun utebi aba, ag go agal zau i simamen. Ag uzan go utei unabun aimai, agal igul eg abai marabun, agal aramag ebuan esues kueian.” ");
INSERT INTO bmh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Go guzenai awarina, gonugau tapaimaraneu dudu agen uzan ata atai beteimai, Uwait nugau Ze duailel abai maraimai, awaremen, “Ag agal igul eg uteiban, oiagab kekulan.” ");
INSERT INTO bmh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Go wes eg asiu zamaraimai, a dab ebuan ze oimai, ebeu duailel asiu agal enimag ebu mina, kasarena, naliu usalemen. ");
INSERT INTO bmh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Emgasag tub ebuan duailel unum Yesus nugau igul abiu memen, gonun, em gasag gumaraneun du King Herot-Antipas go han doun. Duailel ipal agen guzenemen, “Go ze ziwaraneun du Zon, go noumeun kolital ob ougan usai zoun, gonun, go igul go ata atai mabun gusig mui.” ");
INSERT INTO bmh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ipal agen enem, “Go Elaiza.” Ipal enem, “Go Uwait nugau Ze doimai, awaraneu du tub. Go Uwait nugau Ze doimai awaranemen muz duailel sul.” ");
INSERT INTO bmh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bo, Herot nug ze go doimai, aneun, “Getal, iz Zon nugau beu kuatai hemin, bo, go noumeun koli usalai zoun.” ");
INSERT INTO bmh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Go umineun, einen, getal Herot gonugtal gonugau amag, Pilip, nugau wau, wanib Herodias, ebegalacoun. Ziwas go ebu, Zon nug Herot aureun, “Na nait amai nugau air omen, go na kasai ze etuboromen.” Gonun, Herot nug dudu awarina, beteimai, Zon gusig pataimai, ebeg us sil kiaimaimai, hiacaranem zau oug heun. ");
INSERT INTO bmh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herodias nug Zon en ougab eg wina, waba, noumabun eun, bo, Herot go Zon uminoroun. Go abiu Zon go Uwait nugau Ze duacaneu du. Go igul naliu macaneun, gonun, Herot nug Zon suban gumendai, Herodias nug Zon wai mabun iborain tam. Herot nug Zon nugau ze doimai, dabeleu asiu oimai, go Zon nugau ze koli koli suban duabun aneun. ");
INSERT INTO bmh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dai dai, Herodias nug Zon wai abun abu tub peun. Herot go anag nug soligweun ziwas ebu, gonug gonugau zau gumanemen dudu banban mui, gonugau malai dudu banban mui, Galili agaig agal dudu banban abai ereg, ee mis banou mai zabun imareun. ");
INSERT INTO bmh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ziwas go ebu, Herodias nugau aleg magun alaimai, go dudu banban amiagab ebu ilanina, Herot gonugau zaugul abai peimai, agal oiagab naliu memen. Guzenaimai, Herot nug ainag go aureun, “Nait dabeleu, ein esab na wabun ailamam, iz na mizai. ");
INSERT INTO bmh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iz ze petak aizem, iz na ibaiz baib mai, na ein esab wabun ailamam, iz na mizai. Na izal em gasag gumanem tubaim mizabun ailamam, go iboi, iz na tubaim mizai.” ");
INSERT INTO bmh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Guzenai aurina, ainag go seseim noimai, anag kanabeun, “Iz ein wabun aurai?” Anag nug koli aureun, “Na enai auren. Ze ziwaraneun du, Zon nugau gagalig sag wabun auramam.” ");
INSERT INTO bmh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Guzenaimai, go nug pigai koli du banou waugab zoimai, aureun, “Na ulis, ze ziwaraneun du, Zon nugau gagalig sag tebil tub ebu maiba, iz milamam.” ");
INSERT INTO bmh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Guzenai aurina, Herot nugau ougab uhu meun. Bo, gonugau zaugul mui, duailel ipal go abai hoboi ee zai daremen amiagab ebu ainag go dual baib meun, gonun, go baib go meun ze utabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Guzenaimai, go nug pigai gonugau malai du tub palautina, gonug Zon waugab beteimai, Zon nugau beu kuataimai, gonugau gagalig sag oi alabun aureun. Guzenai aurina, du go hiacaranem zau beteimai, Zon nugau beu kuateun. ");
INSERT INTO bmh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Gonug go gagalig sag tebil tub ebu maimai, oi alaimai, ainag go morona, go nug koli oi betei gonugau anag moroun. ");
INSERT INTO bmh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zon nugau tapaimaraneun dudu agen ze go doimai, alaimai, gonugau enib oi betei ob oug hinar. ");
INSERT INTO bmh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Getal Yesus nug gonugau ze oi aidanemen dudu gonug uzan ata atai palautareun, koli nug waugab alemen. Go betei ein salau mui, ein ze duailel abai maremen mui, unum go alai auremen. ");
INSERT INTO bmh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bo, duailel asiu agen beten alen, beten alen aidarena, gonun, Yesus gonugau dudu abai ee zabun iborain tam. Guzenina, Yesus nug awareun, “Iguatal uzan tub du tamacag ebu imabun unab.” ");
INSERT INTO bmh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Guzenaimai, go agtal tebil oimai, uzan tub du tamacag ebu betemen. ");
INSERT INTO bmh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bo, duailel asiu go uzan go utena, uligaraimai, unum go uzan uteimai, eneg aramag ebu pigai go sesamarai betemen. ");
INSERT INTO bmh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Guzenina, Yesus nug tebil utei noimai, duailel asiu gotulai daremen uligaraimai, go en bisomag peun. Einen, gonugau dabeleu, duailel go sipsip sul, go gumaraneu du tamacag. Guzenaimai, go nug go ze asiu bigegwai abai mareun. ");
INSERT INTO bmh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Dai dai, am nuabunina, gonugau tapaimaraneu dudu agen waugab alaimai, auremen, “Uzan e du tamacag, am nuamaneu, gonun, na duailel palautaremen, uzan ata atai beteimai, go ee gau mai zimam.” ");
INSERT INTO bmh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Uteimai, Yesus nug koli awareun, “Ag agtal ee zabun maran.” Goagen koli kanabemen, “Du ban, duailel unum ee ginaginam zabun aiwag asiu, du tub go handret aliag gil salau maimai, aiwag omau sul oimai, betei bret gau mabun. Ig aiwag asiu go maimai, ee gau maimai, marabun, iboin ta?” ");
INSERT INTO bmh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus nug awareun, “Ee ecesab dareu? Beteiban, pen!” Go abe maimai, koli auremen, “Bret tabkuai sag mui, karuk aliag mui darem.” ");
INSERT INTO bmh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Guzenai aurina, Yesus nug koli gonugau tapaimaraneu dudu awareun, “Duailel awarebiag, sisi sisiai, gig naliu ebu hoboi bitamam!” ");
INSERT INTO bmh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Guzenina, duailel go unum hobomen. Dudu ipal handret tutak (100) sag hobomen, dudu ipal houhou tabkuai (50) sag hobomen. ");
INSERT INTO bmh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Guzenina, Yesus nug bret tabkuai sag mui karuk aliag mui oimai, Mesgai wag ameitaimai, Uwait ‘Izal oiab naliupetpet’ aureun. Auraimai, bret kuaraimai, gonugau tapaimaraneu dudu agen duailel marabun mareun. Karuk aliag kuaraimai, han guzental guzeneun. ");
INSERT INTO bmh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Duailel go unum ee go zaimai, biguiag zondai, Yesus nugau tapaimaraneu dudu agen duailel agen ee zemen ee ogog utemen gom gau zo begurug sag oimai, zulagarai memen. Gom gau zo go unum og zoun. ");
INSERT INTO bmh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Dudu ee go zemen tausen tabkuai. ");
INSERT INTO bmh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ziwas go ebutal, Yesus nug gonugau tapaimaraneu dudu palautarendai, tebil ebu simai, ze unig tubaim Betsaida uzan amegai betena, Yesus nugtal duailel agal uzan palautarabun dareun. ");
INSERT INTO bmh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Go duailel palautaren, wanen, go nugtal em baru ebu Uwait aurabun sieun. ");
INSERT INTO bmh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Umusig, em umutai zuna zuna, tebil ze unig ban ula daren, Yesus nugtal ze gasageim dareun. ");
INSERT INTO bmh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","Yesus gonug gonugau tapaimaraneu dudu salau banou maimai, tebil nugau aumag keuina unabun iborain tam, wol nug zoimai, piareun. Em ilai zuna zuna, Yesus nug ze unig wag ebu aleun. Yesus nug gonugau tapaimaraneu dudu zalarai bitamoroi, bo, ag go ze wageim ai dareun uligaimai, go agen eb aimai dabeleimai, piecemen. ");
INSERT INTO bmh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Go banban uminemen. Guzenina, gonug pigai awareun, “Ag oiagab gusig dan! E izanag, ag umin ian!” ");
INSERT INTO bmh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Guzenai awaraimai, Yesus nug tebil ebu simai, go abai ereg darena, wol mazieun. Go esilakaimai, dabeleu asiu omen. ");
INSERT INTO bmh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bo, go Yesus nug dudu bret mareun igul go guzeneun gonugau zebigeg suban abe i memen, gonun, goagal oiagab gusig mina, go gonugau igul abe murabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesus gonugau tapaimaraneu dudu abai ereg go ze unig matelai beteimai, Genesaret em gasageim beteimai, go ebu tebil us sil kiai memen. ");
INSERT INTO bmh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Tebil uteimai, duailel go ebu Yesus abe moroimai, go em go ebu ata atai uzan beteimai, duailel ipal Yesus eru ebu dareu aimai awarina, ebeu duailel biz ebu maraimai, imarai alemen. ");
INSERT INTO bmh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ban uzan ta, uzan ginampet ta, abu ebu ta, go eru ebu aidaneun ebu go ebeu duailel Yesus waugab mina, daremen. Go Yesus guzenai gusig auremen, “Na ebeu duailel go utaremen, alai goagen nait tibur galau siu patamam.” Go io awarina, ebeu duailel agal ebeag nug Yesus nugau tibur galau pataimai, go unum naliu memen. ");
INSERT INTO bmh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","2","Parisi dudu ipal mui, kasai ze tapaimaranem dudu ipal abai Zerusalem ban uzan uteimai, alaimai, Yesus waugab gotulaimai, Yesus nugau tapaimaraneu dudu ipal go Parisi agal kasai ze sesamoraimai, goagal ebeag ze ulusab tam, go gaul ee zai daren uligaremen. ");
INSERT INTO bmh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisi dudu, Zuda dudu banban abai, goagal embigeg agal kasai ze suban sesamoraimai, goagal ebeag ze ulusaimai, go ag ee zanem. Bo, ag ebeag i ulusaimai, go ee go i zanem. ");
INSERT INTO bmh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iguanem empip ebuan koli zaueim alaimai, go pigai ze ziwamam, tam aba, go ee i zimam. Goagal embigeg agal kasai ze ipal asiu sesamoranemen. Go ze go aneu sul agal gap, tebil, biz mui, unum ze ebu ulusanemen.) ");
INSERT INTO bmh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Guzenina, Parisi dudu mui kasai ze tapaimaranem dudu go agen Yesus guzena kanabemen, “Nait tapamaranemen dudu agen einen goagal embigeg agal igul i sesamoranem? Ag einen ee zabun ziwas agal ebeag i ulusanemen?” ");
INSERT INTO bmh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesus koli awareun, “Getal, Uwait nugau ze doimai, awaraneun du, Aisaia nug go polumanemen dudu en petak aneun. Go guzenai sikut weun, ‘Uwait nug aneun, “Duailel go agen gaul oiagsau nug izal wanim ulapwag macanem, bo, agal oiagab nug iz en noumab tam. Ag izal ze awaranem bo, ag suban i sesamoranemen. ");
INSERT INTO bmh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ag du tub nugau kasai ze sesamoraimai, ag guzenai anemen, ‘Go Uwait nugau Ze.’ Ag polu ze sesamoraimai, ag izal wanim gaul ulapwag macanemen!” ’ ");
INSERT INTO bmh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ag Uwait nugau kasai ze uteimai, agal embigeg agal igul gusig pataimai, sesamoranemen.” ");
INSERT INTO bmh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesus nug koli guzenai awareun, “Ag Uwait nugau Ze bo, agal embigeg agal ze sesamoraimai, agtal agal dabeleu sesamoranemen. ");
INSERT INTO bmh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses nug getal awareun, ‘Na nait memen anan nugau ze sesamoren.’ ‘Du in gonugau memeg anag ze eg muramau, dudu ipal agen go webi, noumamau.’ ");
INSERT INTO bmh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","‘Du in go esab mui, gonugau memeg anag al isanaramau go iboi. Bo, go awaraimai, “Iz esab go Uwait murabun sag wageimai memin dareu. Gonun, iz ag isanarabun iboin tam.” ");
INSERT INTO bmh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Guzenaimai, ulis go gonugau memeg anag al i gumaraneu. Go igul naliu go auranem. ");
INSERT INTO bmh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Guzenina, goagal embigeg agal igul sesamoraimai, Uwait nugau Ze tonoi macanem. Ag igul ipal enai asiu guzenanem.’ ");
INSERT INTO bmh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus nug duailel koli ularena, alina, awareun, “Ag unum izal ze doimai, suban dabeleu oimai, zebigeg abe mamamen. ");
INSERT INTO bmh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ecesab tub uzaneim dareun du tub nugau ougab oug sianeu, go ecesab nug Uwait nugau ameguab du unu i muraneu. Bo, du go nugau dabeleu eg ougab oug dareu usalina, gonugau ogusau nug ananeu go petak go unu muraneu.  ");
INSERT INTO bmh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Duailel ag dabuiag mui aba, ag ze go doimai, gonugau zebigeg abiu mamamen!” ");
INSERT INTO bmh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus go gue duailel utaraimai, zaueim simai, gonugau tapaimaraneu dudu agen ze go aneun zebigeg en kanabemen. ");
INSERT INTO bmh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Guzenina, Yesus nug koli awareun, “Agal dabeleu naliu tam ta? Ag igul go i abiu ta, ece uzaneim dareun du tub nugau ougab oug nuaneu, ece go nug Uwait nugau ameguab du unu i macaneu. ");
INSERT INTO bmh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ee go zanem go ougab oug i daneu, go bi abu eiman, koli bizau oug nuaneu.” Ze gonun, Yesus nug ee unum zabun go erunamau eun. Ee ipal nou abun tam. ");
INSERT INTO bmh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesus nug koli awareun, “Dabeleu eg duailel agal oiagab oug daneu, asaimai, oiagsau eiman zuaneu, dabeleu gonug sag petak unu muraneu. ");
INSERT INTO bmh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Oiagab ougeiman duailel ag go dabeleu eg guzenai wanemen; ag wal igul eg mabun dabilanemen, ag zaiagar agal ecesab zob wabun dabilanemen, ag duailel ugarebi, noumabun dabilanemen, ag dudu ipal agal ailel eg marabun dabilanemen, ag ecesab asiu alaraimai, wabun dabilanemen, ag duailel ipal ebalagab igul eg asiu mabun dabilanemen, ag polu ze mabun dabilanemen, ag duailel ipal en i dabilaranemen, ag gaul igul eg mabun dabilanemen, ag zaiagar agal ecesab uligaimai, alaranemen, ag zaiagar agal enimag ebu polu ze mabun dabilanemen, ag dudu ipal agal ze duabun utanemen, ag kar igul macanemen. ");
INSERT INTO bmh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Igul go eg unum agal oiagab oug daimai, uzaneim nuaneu, go Uwait nugau ameg ebu ag unu maraneu.” ");
INSERT INTO bmh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus nug ze go maimai, uzan go uteimai, Tair uzan waugab beteun. Go zau tub simai darena, du tub nug go zaueim dareu abe murabun iborain tam aimai dabeleun, bo, go wagemabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Guzenina, ziwas go ebutal, air tub gonugau aleg wes eg ougab oug dareun, go nug Yesus go ebu dareu ze doimai, pigai alaimai, Yesus waugab taubib weun. ");
INSERT INTO bmh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Air go Zuda air tam. Go Grik air, gonugau uzan Ponisia, Siria agaig ebuan. Go Kanan air tub. Gonug Yesus guzenai gusig aureun, “Wes eg izal alegwai nugau ougab oug dareu, nagen oi hen.” ");
INSERT INTO bmh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Guzenina, Yesus nug koli aureun, “Amegai ig Zuda agal geleagar ee marai. Geleagar agal ee oimai, bau i he maranem. Igul go eg.” ");
INSERT INTO bmh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Air gonug koli aureun, “Du banou, go petak, bo, bau agen eebiz pigsal daimai, geleagar agal ee sib nuna, oi zanem.” ");
INSERT INTO bmh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Guzenai aurina, Yesus nug koli aureun, “Na naliu ze ailem. Na koli unamam. Wes eg go nait alen nugau ougab oug dareun go utei waneun.” ");
INSERT INTO bmh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Air go gonugau zaueim beteimai, uligeun gonugau aleg biz ebu gabuai dareun, wes eg ougab oug dareun utei waneun. ");
INSERT INTO bmh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus go Tair uzan uteimai, Saidon uzan zilaoroi, ban uzan houhou goagal wanimag banou Dekapolis em ula ebu Galili Ze Unig waugab beteun. ");
INSERT INTO bmh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Duailel ipal agen du tub dabug utub mui ogusau gebeun mui dareun Yesus waugab imai alemen. Go Yesus gusig auremen, “Nait eben du go ebu men.” ");
INSERT INTO bmh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Guzenina, Yesus nug duailel utaraimai, go imai holoi beteun. Agtal daimai, Yesus gonugau ebeg hum du gonugau dabug aliag oug meun. Gonugau sinou oimai, du gonugau minob ebu meun. ");
INSERT INTO bmh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gonug Mesgai ametai uligaimai, gonugau ougab uhu usalaimai, bisou peimai, Zuda ze eiman du go guzenai aureun, “Epata!” Ze go zebigeg enai ‘Na oiten!’ ");
INSERT INTO bmh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Guzenai aurina, du gonugau dabug naliu usalina, go ze suban duabun iboin. Gonugau ogusau naliu usalina, go ze suban bigegwaimai, ze meun. ");
INSERT INTO bmh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ziwas go ebu, Yesus nug duailel gusig awareun. “Ag igul go pemen gue betei duailel ipal i awaran.” Yesus nug koli koli go gusig ze guzenai awareun, bo, go gonugau ze sesamorab tam, go ze go hegei hemen. ");
INSERT INTO bmh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Duailel agal ze doimai, go unum esilakaimai, enemen, “Go ein igul macaneu unum igul naliupet pet. Gonug duailel dabuiag utub kasaren, ze duanem, oiagsau tapelai mui koli ze suban macanem. Gonug guzenaneu.” ");
INSERT INTO bmh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Ziwas go ebu, duailel asiu alai gotulemen. Go ee tamacag daren, Yesus nug gonugau tapaimaraneu dudu ularen, alina, awareun, “Iz duailel go en bisomag pem. Go iz ibail gil ainarai daremen, gonun, ulis ee tamacag darem. ");
INSERT INTO bmh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Iz duailel go palautaremin, goagal uzan bitamam, bo ipei abu ebu betei ameag kualil, amau. Ipal go abu pulig alemen.” ");
INSERT INTO bmh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Guzenai awarina, gonugau tapaimaraneu dudu agen koli auremen, “Ig du tamacag em e ebu darem. Ig ee eruan oimai, duailel maremun, zimam?” ");
INSERT INTO bmh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus nug kanabareun, “Ag bret eiceisab dareu?” Goagen koli auremen, “bret kwali sag.” ");
INSERT INTO bmh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Guzenina, Yesus nug duailel em ebu hubabun awarina, go hobolilemen. Gonug bret kwali sag oimai, Uwait ‘Izal oiab naliupetpet’ auraimai, bret kakaraimai, gonugau tapaimaraneu dudu maren, goagen duailel maren, zemen. ");
INSERT INTO bmh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Go karuk ginaginam mui, gonun, Yesus nug go oimai, Uwait auraimai, gonugau tapaimaraneu dudu maren, goagen duailel marenar. ");
INSERT INTO bmh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Duailel ee go zaimai, unum biguiag zoun. Ipal ee ogog utemen daren, Yesus nugau tapaimareu dudu agen gom gau zo kwali sag oimai, ee zemen ogog zulagai mina, og zoun. ");
INSERT INTO bmh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Ee go zemen duailel go tausen iwanarai Yesus nug go agal uzan palautaren, wanen, go gonugau tapaimaraneu dudu abai tebil ebu simai, Dalmanuta em ebu betenar. ");
INSERT INTO bmh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi dudu ipal agen alaimai, Yesus bimag piabun doimai, auremen, “Na gugeg tub abai migemen, go petak ig abe mamam, na Uwait Mesgai wag dareu gonugtal gusig go mizaneu.” ");
INSERT INTO bmh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Gonugau ougab uhu mina, awareun, “Ulisan duailel einen iz gugeg tub abai marabun ailanem? Iz ag petak pet awarem, ziwas e ebu iz gugeg tub i abai maremin, pimamen.” ");
INSERT INTO bmh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Guzenai awaraimai, Parisi dudu utaraimai, tebil ebu koli simai, ze unig tubaim beteun. ");
INSERT INTO bmh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus nugau tapaimaraneu dudu go dabuiag siken, bret ipal i omen, go gaul wanenar. Tebil ebu bret ginam tub sag dareun oi betemenin. ");
INSERT INTO bmh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus nug go gusig ze guzenai awareun, “Parisi dudu mui, Herot nugau dudu mui ereg, bret agena, neleimai suazuaneun marasin wanib zis go, ag suban pimamen.” ");
INSERT INTO bmh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","17","Gonugau tapaimaraneu dudu agen agzozou ze maimai, enemen, “Ig bret i oialem, gonun, ze go aigeu.” Yesus nug goagal ze abe maimai kanabareun, “Ag bret tamacag en einen zememen? Iz ag abai ziwas huia daimai, gugeg asiu abai maremin, einen ag gugeg go suban dabelab utemen? Ag izal igul i abiu ta? Agal oiagab gusig mai dareu ta? ");
INSERT INTO bmh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ag ameag nug pemen, bo, ag ecesab suban i pemen ta? Ag dabuiag nug duanemen, bo, ag ze suban i domen ta? Ag getalan gugeg koli dabelabun iboin tam ta? ");
INSERT INTO bmh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Iz bret tabkuai sag oimai, kakaraimai, dudu tausen tabkuai maremin, zemen, ag ee ogog eisasab zo oug zulagai memenin?” Goagen koli auremenin, “Zo begurug sag.” ");
INSERT INTO bmh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus nug koli kanabareun, “Ziwas tub ebu iz bret kwali oimai, kakaraimai, dudu tausen iwanarai maremin, zemen, agen ee ogog eisasab zo oug zulagai memenin?” Goagen auremenin, “Zo kwali sag.” ");
INSERT INTO bmh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Guzenina, go nug awareun, “Ag ulis izal igul abe i memen ta?” ");
INSERT INTO bmh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Go Betsaida uzan alina, dudu ipal agen du tub ameg kumi imai alaimai, ze gusig Yesus guzenai auremen, “Nait eben du e ebu men.” ");
INSERT INTO bmh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus nug du go ameg kumi nugau ebeg pataimai, uzan geseg imai waneun. Du gonugau ameg oug sino heimai, gonugau ebeg sil du gonugau ameg ebu maimai, kanaboroun, “Na ece tub piabun iboin ta?” ");
INSERT INTO bmh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Du go nug ametaimai, aureun, “Iz duailel uligarem. Go a sul ai darem.” ");
INSERT INTO bmh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus nug koli gonugau ebeg du gonugau ameg ebu maimai, go gusig aurina, go suban ametaimai, koli ece unum suban uligareun. ");
INSERT INTO bmh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesus nug du go gonugau zau palautaimai, aureun, “Na koli uzan i simam.” ");
INSERT INTO bmh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus gonugau tapaimaraneu dudu abai ereg Sisaria-Pilipai uzan ata atai betemen. Abu ebu bete beteimai, go nug gonugau tapaimaraneu dudu kanabareun, “Duailel agen, iz en in anem?” ");
INSERT INTO bmh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Goagen koli auremen, “Duailel ipal agen guzenai anem, ‘Go ze ziwaraneun du, Zon.’ Ipal agen enanem, ‘Go Elaiza.’ Ipal agen enanem, ‘Go Uwait nugau Ze doimai, awaraneun du tub.’ anem.” ");
INSERT INTO bmh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Guzenai aurina, Yesus nug koli go kanabareun, “Agenag iz en in anemen?” Pita nug koli aureun, “Na Kristus, Uwait nug palautizeun, gonugau duailel koli imarabun, alemen.” ");
INSERT INTO bmh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pita nug guzenai aurina, Yesus nug go gusig awareun, “Go petak, bo, ze go ag duailel ipal i awaran.” ");
INSERT INTO bmh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ziwas go ebu, Yesus nug bigegwai ze abai maraimai, gonugau tapaimaraneu dudu guzenai awareun, “Du Nugau Nag, mu asiu oimai, Zuda dudu banban mui, Uwait ula danemen dudu mui, kasai ze tapaimaranem dudu abai ereg, agen izal ze duabun uteimai, semilem. Goagen iz iwebiag, noumai. Bo, gil ianai ainarai ebu iz koli asanai.” ");
INSERT INTO bmh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Gonug ze go araog marena, Pita nug go gasag imai beteimai, ze gusig aureun, “Tam pet tam! Igul go na ebizab i usalamau!” ");
INSERT INTO bmh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bo, Yesus nug kekulaimai, gonugau tapaimaraneu dudu uligaraimai, Pita guzenai ze gusig aureun, “Satan, na iz seiab alien! Na Uwait nugau dabeleu naliu i sesamorem, na dudu agal dabeleu sag sesamorem.” ");
INSERT INTO bmh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Guzenina, go duailel asiu mui gonugau tapaimaraneu dudu mui ularen, alina, guzenai awareun, “Du in iz sesamilai zuabun, go nugen i dabilamau, gonugau a gegeulanau go nugtal gamacaimai, iz sesamilamau. ");
INSERT INTO bmh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Du in go gonugau dorog awau dabun dabeleu go gue gonugau dorog eg umau. Bo, du in go iz en mui Uwait nugau Ze Naliupet en noumamau, du go gonugau dorog muzmuz suban naliu damau. ");
INSERT INTO bmh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Du tub em ebuan ecesab unum umau, go noumamau. Go esab nug gonugau dorog awau dabun erunai abu kalamau? ");
INSERT INTO bmh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Go ein ecesab oimai, koli gonugau dorog awau dabun gau mamau? Tam, go koli nugtal gonugau dorog gau mabun iboin tam. ");
INSERT INTO bmh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Du in ulisan duailel gue igul eg macanemen agal ameagab iz sesamilabun uminaimai, gonug iz en i abiu aimai, izal ze wageimai mamau, iz Du Nugau Nag, aiu ses izal mekai nugau al banou mui tibur naliu inain ereg alai, izan han du go i abe murai.” ");
INSERT INTO bmh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesus nug koli awareun, “Iz ag petak awarem, dudu ipal ag em e ebu daremen, ipal i noumamam, ag dabi dabi, Uwait nugau gumarabun igul gusig mui araog zumau pimamen.” ");
INSERT INTO bmh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gil wasolig sag uteimai, Yesus nug Pita, Zems zaug Zon abai ereg imarai, em baru banou wag simai, agtal daremen. Go ameagab Yesus nugau enib kekulaimai, atai pet usaleun pemenin. ");
INSERT INTO bmh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gonugau tibur galau am nugau hilanau sul eleimai, ausiau pet usaleun. Em ebu du tub nugau tibur galau ausiau pet guzeneneg tam. ");
INSERT INTO bmh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Guzenina, Elaiza zaug Moses dual zoimai, Yesus dual ze ze mai darena, uligaremen. ");
INSERT INTO bmh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita nug Yesus aureun, “Igul abai miganem du, ig e ebu dabun naliu. Na ze memen, ig agal zau ainarai mamam, tub nait, tub Moses nugau, tub Elaiza nugau.” ");
INSERT INTO bmh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","7","Go uminaimai, Pita nug ein ze mabun abiu tam, gonun, go gaul guzenina, pi banou emes wageiman alaimai kularai meun. Ogusau tub nug pi go ougeiman, eneun, “Go izal nagwai pet, iz go en izal oiab nug noumanem. Ag gonugau ze suban don!” ");
INSERT INTO bmh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Guzenina, goagal ameag nug pemen, go du tub i pemen, Yesus tutak go abai ereg dareun pemen. ");
INSERT INTO bmh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Go em baru utei noimai, Yesus nug gusig ze guzenai awareun, “E igul ag ameag nug peun ag bete duailel ipal i awaran. Du Nugau Nag, noumaimai, koli ob oug eiman asamau, ziwas go ebu ein igul pemen go petak duailel awaramamen.” ");
INSERT INTO bmh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Guzenina, go ze go wage wageimai, ze pataimai, ag agzozou enemen, “Ob oug eiman koli usabun, go ein igul ena?” ");
INSERT INTO bmh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Goagen Yesus kanabai auremen, “Zuda agal kasai ze tapaimaranem dudu agen einen Elaiza go amegai alamau anemen?” ");
INSERT INTO bmh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus nug koli awareun, “Ag go petak anemen, Elaiza go amegai alaimai, ecesab unum suban mai damau. Bo, Uwait nugau Ze sikut wai memen dareu, einen guzeneu, ‘Du Nugau Nag mu asiu oimai, duailel agen go semoromam’? ");
INSERT INTO bmh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bo, iz ag petak awarem, Elaiza go amegai aleun, duailel agen agal dabeleu nug igul eg ata atai go ebu guzenemen. Ag igul gue, go ebu guzenamamen en getal Uwait nugau Ze sikut wai memen dareu.” ");
INSERT INTO bmh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus gonugau tapaimaraneu dudu ainarai abai alaimai, gonugau tapaimaraneu dudu ipal tulareun. Go ebu alaimai, duailel asiu gotulemen ebu, kasai ze tapaimaranem dudu ipal agen go abai zezemai, daren piaremen. ");
INSERT INTO bmh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Duailel agen Yesus alina, uligaimai, esilakaimai, pigai go waugab beteimai, ‘Umaseu,’ ze auremen. ");
INSERT INTO bmh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus nug kanabareun, “Goagen einen ag abai ze ebu alalemen?” ");
INSERT INTO bmh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Du tub, duailel ula dareu gonug koli aureun, “Igulabai miganem du, izal nagwai wes eg ougab oug daren, ogusau gebeun daren, na wautab imai alem. ");
INSERT INTO bmh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Go wes eg nug go gusig pataimai, oi em ebu hamacendai, ogusau siwalkuk aimai, aceg katutaimai, enib tiai macaneu. Iz nait tapaimaranem dudu wes eg oi abun aimai awaremin. Bo, go oi abun iboin tam.” ");
INSERT INTO bmh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus nug duailel en acegsisilaimai, koli aneun, “Duailel ulis daremen, agal dabeleu ein sulai? Ag oiagab petak ab tam pet. Ziwas eisab iz koli ag abai ereg dai? Ziwas eisab iz koli agal uhu gamahai? Mogoi go iz waiab imai alan.” ");
INSERT INTO bmh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Guzenina, go mogoi go imai Yesus waugab alina, wes eg nug Yesus uligaimai, pigai mogoi go patai hiloiaimai, hamacendai, em ebu alainoimai, siloisiloi aimai, ogusau siwalkuk heun. ");
INSERT INTO bmh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus nug mogoi gonugau memeg kanabai aureun, “Ziwas eceisab go guzenai dareun?” Memeg nug koli aureun, “Mogoi ginampet ebutal guzeneun. ");
INSERT INTO bmh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Go wes eg nug umkoskos ab unig oug ta, ze unig oug hamaicina, noumabun guzenaneu. Bo, na igul tub guzenabun iboi abague, na ig en bisomig peiba, ig isanigamam.” ");
INSERT INTO bmh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Guzenina, Yesus nug aureun, “Na einen guzenai anem, ‘Na igul tub mabun iboi ta?’ ailem. Du tub iz en ougab petak aneu, go nug igul unum guzenabun iboi.” ");
INSERT INTO bmh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Guzenai auraimai, mogoi go memeg nug pigai ulaimai, eneun, “Iz na en oiab petak eun, bo, izal oiab petak eun, go ginampet, gonun, na iz isanilen.” ");
INSERT INTO bmh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus nug duailel asiu pigai go waugab alina, uligaraimai, wes eg gusig aureun, “Na, wes ogusau tapeleun, dabug utub, iz na aizem, na mogoi go ulis uteimai, alien. Na koli gonugau ougab oug i simam.” ");
INSERT INTO bmh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Guzenai aurina, wes eg go ulaimai, mogoi gusig patai hiloiaimai, utei wanen, mogoi eb siameg sul gabuai dareun. Duailel asiu agen uligaimai, enemen, “Go noumeun.” ");
INSERT INTO bmh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bo, Yesus nug gonugau ebeg pataimai, asai meun. ");
INSERT INTO bmh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Guzenaimai, Yesus go utei zau simai, gonugau tapaimaraneu dudu abai agtal daimai, goagen kanabemen, “Ig einen wes eg go oiabun iboin tam?” ");
INSERT INTO bmh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Gonug koli awareun, “Ag Uwait tutak aurai damamen, igul go tutak nug petak wes eg zamoramau. Igul tub eiman go iboin tam.” ");
INSERT INTO bmh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Go uzan go uteimai, Galili agaig ula betemenin, Go, einen gonugau tapaimaraneu dudu ze abai maraneu, gonun, Yesus du tub nug go eru ebu dareu abun uteun. Gonug guzenai awareun, “Duailel ipal agen Du Nugau Nag ebegarab durub waimai, dudu agal ebeag ebu mamam. Go webi, noumaimai, gil ianai ainarai ebu koli ob oug an asamau.” ");
INSERT INTO bmh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Go ze go zebigeg abiu tam. Bo, go uminaimai, go ze tub en kanaborab tam. ");
INSERT INTO bmh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Go Kapaneam uzan alaimai, zau tub ebu simai, Yesus nug kanabareun, “Ag abu ebu alaimai, ein ze memen?” ");
INSERT INTO bmh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Goagen ze tub koli aurab tam, einen, abu ebu, agzozou guzenemen, “Du in banou pet wanib mui, go dudu ipal zilareu?” ");
INSERT INTO bmh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Guzenina, Yesus nug hoboimai, gonugau dudu 12 sag ularen, alina, awareun, “Inug du wanib banou mui usalabun, go wanib tamacag du sul daimai, dudu ipal agal salau du sul usalaimai, duailel unum isanaramau.” ");
INSERT INTO bmh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Guzenai awaraimai, mogoi ginampet tub imai zoimai, go daremen ula ebu tapai maimai, waugab darena, awareun, “Du in nug iz en dabeleimai, mogoi tub e mogoi ginampet sul imai zoimai, suban gumamau, go iz imaileu. Du in nug iz imaileu, go iz tutak i imaileu, go izal mekai iz palautilen, alemin, han imamau.” ");
INSERT INTO bmh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zon nug Yesus aureun, “Igulabai miganem du, ig du tub nait wanim ebu wes eg oi hina, pemun. Go igual zaicig tam, gonun, ig du go igul go i guzenamau aimai auremun.” ");
INSERT INTO bmh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesus nug koli awareun, “Ag go i ze kuatai auran. Du tub nug gugeg tub izal wanim ebu macaneu, go nug iz pigai ze eg i milamau. ");
INSERT INTO bmh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Du in go igual iwai zaicig tam, go igual zaicig. ");
INSERT INTO bmh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iz ag petak pet awarem, du in nug ag izal zaiar darem abe maimai, ze zabun ze maramau, du go Uwait nug i semuramau, aiu ses go petak Mesgai wag ecesab naliu umau.” ");
INSERT INTO bmh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mogoi ginampet tub iz en ougab petak eun du tub nug go zigulin abai murabun aba, zigulin go eg pet. Dudu ipal agen aiwag uhu banou ban oimai, du gonugau beu ebu us sil otoi maimai, go ze unig oug hamacebiag, numau, go iboi, go uhu ginampet. Tam aba, aiu ses Mesgai wag, go uhu banou pet umau. ");
INSERT INTO bmh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nait eben nug zigulin meu aba, nait eben tub kuatai hamacemam, go iboi. Guzenaimai, eben tutak mui na muzmuz naliu awau damam. Na go i guzenamam gue eben aliag mui unum ab i noumaneun oug heizamam.  ");
INSERT INTO bmh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Uzan tub salik asiu mui duailel agal enimag tugarai daimai, go i noumamam, ab go i usecamau. ");
INSERT INTO bmh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nait aram nug zigulin meu aba, aram tub kuataimai, hamacemam. Guzenaimai, aram tutak mui na muzmuz naliu awau damam. Na i guzenamam aram aliag nug na uzan go ab banou i noumaneun oug hamai heizamam.  ");
INSERT INTO bmh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Uzan tub salik asiu mui duailel agal enimag tugarai daimai, go i noumamam, ab go i usecamau. ");
INSERT INTO bmh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nait amen tutak nug zigulin maimai, keuizaba, amen go gue esei hamacemam, amen tutak go iboi. Na muzmuz naliu awau damam. Na go i guzenamam gue, na han amen aliag mui ab banou muzmuz elaneu uzan heizamam. ");
INSERT INTO bmh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Uzan tub salik asiu mui duailel agal enimag tugarai daimai, go i noumamam, ab go i usecamau. ");
INSERT INTO bmh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Siu ee ebu hianem ee go i belaneu sul, Uwait nug gonugau duailel patai piarabun uhu maraneu, gonun, ag gusig usalebi, i tamamamen. ");
INSERT INTO bmh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Siu naliu, ee i belaneu. Bo, siu nugau kel wanena gue, kel go koli erunai umau? Igul naliu siu kel a sul, agal oiagab oug maimai, go enegun ag zaiagar abai i malai mamamen, ag oiagab tutak mui naliu damamen.” ");
INSERT INTO bmh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus uzan go uteimai, Zudia agaig ebu Zordan Ze gasageim beteun. Duailel asiu koli alaimai, gotulaimai, Yesus nug gonugau igul sesamoraimai, Uwait nugau Ze abai mareun. ");
INSERT INTO bmh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi dudu ipal alaimai, go polumurabun guzenai kanabemen, “Igual kasai ze eiman eneu, du gonugau wau utabun iboi ta, tam?” ");
INSERT INTO bmh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus nug koli awareun, “Moses nug ein kasai ze gusig awareun?” ");
INSERT INTO bmh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Goagen koli auremen, “Moses nug guzenai aigeun, du tub gonugau wau utaba, unabun go sikut tub waimai, gonugau wau muramau. Guzenaimai, petak go wau utaba, unamau.” ");
INSERT INTO bmh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus nug koli awareun, “Moses nug agal oiagab gusig mina, piareun, gonun, kasai ze go sikut wai mareun. ");
INSERT INTO bmh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bo, getal Uwait nug em e meun ziwas ebu, go du air mui patai meun. ");
INSERT INTO bmh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Go enegun, du gonugau memeg anag utaraimai, gonugau wau al eregtal atai daimai, agal enimag tutak tulamam. Gonun, du go air al goagal enimag ata atai aliag dab tam, goagal enimag tutak sul damau. ");
INSERT INTO bmh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Guzenaimai, Uwait nug ag enimag tutak sul tularai mareun, gonun, duair tub nug koli i atalaramau.” ");
INSERT INTO bmh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesus guzenai awaraimai, koli zaueim simai, gonugau tapaimaraneu dudu agen ze go en kanabemen. ");
INSERT INTO bmh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Gonug koli awareun, “Du in gonugau wau atalaimai, go air tub umau, go, du air egarabun agal kasai ze etuboroimai, wal igul gonugau wau ebu mamau. ");
INSERT INTO bmh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Go guzenaital, wau nug gonugau gamu atalaimai, go du tub betei umau, air go nug kasai ze etuboroimai, igul eg gonugau gamu ebu mamau.” ");
INSERT INTO bmh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","14","Duailel ipal agen goagal geleagar Yesus nug gonugau ebeg goagal gagaliag pataimai, gusig marabun aimai, abai alemen. Bo, gonugau tapaimaraneu dudu agen duailel go gusig awarina, Yesus nug igul go uligaimai, go ougab eg wina, gonugau tapaimaraneu dudu guzenai awareun, “Ag geleagar utarebi, iz waiab alamam. Ag i pataran. Duailel ag geleagar e sul, ag abiu Uwait go agal gumaraneu du banou, gonun, go suban damam. ");
INSERT INTO bmh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iz ag petak pet awarem, duair inen go geleagar e sul kekulab tam, go Uwait nugau duair tuguiai i damau.” ");
INSERT INTO bmh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Guzenai awaraimai, Yesus nug geleagar imarai oi waugab gotularaimai, gonugau ebeg goagal gagaliag ebu maimai, Uwait nug go suban gumaramaun awareun. ");
INSERT INTO bmh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus uzan go utei unabun nuna, du tub nug go waugab pigai alaimai, taubibi waimai, kanabeun, “Igulabai miganem du naliu, iz ein igul naliu guzenaimai, izal dorop awau muzmuz suban damau?” ");
INSERT INTO bmh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus nug koli aureun, “Na einen iz du naliu ailem. Du tub tutak go naliu. Go Uwait tutak. ");
INSERT INTO bmh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na igual kasai ze abiu. ‘Na du tub wemenag, i noumamau, na wal igul i men, na dudu ipal agal ecesab i zob on, na du tub nugau enibwag polu ze i men, na nait zaun nugau ecesab gaul wabun i polumoren, na nait memen anan agal ze unum sesamoren,’ go na abiu.” ");
INSERT INTO bmh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Du go nug koli aureun, ‘Du banou, getal iz ginampet ebu kasai ze go unum sesamorai alai, ulis han guzental darem.” ");
INSERT INTO bmh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus ze go doimai, du go en ougab noumaimai, ameg nug uligaimai, aureun, “Go iboi, igul tub tutak na zilaize dareu. Na betei, nait ecesab unum dudu ipal mareben, goagen ecesab go gau mebiag, aiwag go oiba, dudu ecesab tamacag aiwag go dou maramam. Na go guzenemen, aiu ses Mesgai wag ecesab asiu umam. Na betei, igul go guzenaib, alai iz sesamilen.” ");
INSERT INTO bmh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Du go gue ecesab asiu mui, gonun, ze go doimai, go ougab uhu usalina, ougab eg wina, utei waneun. ");
INSERT INTO bmh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Guzenina, Yesus nug gonugau tapaimaraneu dudu ameg nug uligaraimai, awareun, “Dudu ecesab asiu mui ag empip go Uwait nug gumaneu oug siabun anmamamen.” ");
INSERT INTO bmh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Gonugau tapaimaraneu dudu ze go doimai, esilakina, Yesus nug koli awareun, “Izal gelear, em ebuan du tub empip go Uwait nug gumaneu oug siabun go salau gusig ban umau. ");
INSERT INTO bmh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Egun tub kamel go tibur galau sopwanem kulam nugau biag ougeiman siabun anmamau. Bo, duailel ecesab asiu mui ag empip go Uwait nug gumaneu oug siabun go salau gusig banban mamamen.” ");
INSERT INTO bmh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Guzenai awarina, gonugau tapaimaraneu dudu go banban esilakaimai, enai auremen, “Guzenaba, Uwait nug du in imai aimai, go al ereg muzmuz damau?” ");
INSERT INTO bmh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus nug uligaraimai, awareun, “Dudu agen igul tub guzenabun iboin tam, Uwait nugtal igul go guzenabun iboin. Uwait nug ein igul guzenabun dabeleimai, unum guzenabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Go guzenina, Pita nug aureun, “Na go don! Ig igual ecesab unum uteimai, na sesamizai alemun!” ");
INSERT INTO bmh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus nug koli aureun, “Iz na petak pet aizem, du in iz en dabeleimai, Uwait nugau Ze Naliupet marabun, gonugau uzan, apagul, amagul, abiagul, anag, memeg, gelegul, em mui ereg uteimai, aleun, aiu ses Uwait nug ecesab go utei aleun sultal asiu, handret tutak mui sultal, koli muramau. Go ulis em e ebu, zau asiu, apagul, abiagul, anagul, gelegul, mui em asiu go oimai, damam. Bo, ziwas go ebutal, dudu ipal agen go igul eg muramam. Bo, aiu ses go muzmuz naliu damau. ");
INSERT INTO bmh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dudu asiu ag ulis wanimag banban mui daremen, aiu ses ag wanimag tamacag du sul damamen. Dudu ulis gaul daremen, aiu ses ag wanimag banou mui damamen.” ");
INSERT INTO bmh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus nug gonugau tapaimaraneu dudu abai Zerusalem ban uzan siabun betena, Yesus nug amegai beteun. Gonugau tapaimaraneu dudu agen go uzan gue siabun aimai, dabeleu asiu omen. Duailel agen sesamarai alina, uminemen. Yesus nug gonugau tapaimaraneu dudu begurug sag koli imaraimai, ein igul go ebu zumau en awareun. ");
INSERT INTO bmh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Gonug guzenai awareun, “Ag don. Ig ulis Zerusalem uzan betemun, dudu ipal agen Du Nugau Nag Uwait ula dacanemen dudu banban mui, kasai ze tapaimaranem dudu mui, goagal ebeag ebu mamam. Guzenebi, go dudu agen goagal ze doimai, webi, noumabun ze pataimai, emgasag ipal ebuan dudu agal ebeagab ebu mamam. ");
INSERT INTO bmh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Goagen ze biabial kuai auraimai, enib ebu sino horoimai, esalau sul oimai, webiag, noumamau. Bo, gil ianai ainarai ebu, go koli usamau.” ");
INSERT INTO bmh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Guzenai awarina, Zems zaug Zon, Zebedi nugau gelegul aliag, agen Yesus waugab alaimai, guzenai kanabemen, “Igulabai miganem du, ig na ig isanigabun aizem na ze go sesamorabun aizem.” ");
INSERT INTO bmh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Guzenina, Yesus nug koli awareun, “Agen iz ein igul ag isanarabun ailemen?” ");
INSERT INTO bmh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Goagen koli guzenai auremen, “Na ig ibaig baib guzenai mamam, aiu ses na gumarabun du banou usalaimai, ig han imaigeimai, tub nug nait eben naliu eiman hubamau, tub nug nanai eiman hubamau. Na igul go guzeneben, ig na ibaiz damam.” ");
INSERT INTO bmh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus nug koli awareun, “Ze go en kanabilemen gonugau zebigeg ag abe i memen. Iz ze gap tub ebu dareu zai, ag ze go zabun iboin ta? Iz ze ziweimai, mu banou wai, ag go sul wabun iboin ta?” ");
INSERT INTO bmh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","40","Goagen koli auremen, “Io, ig iboin.” Guzenina, Yesus nug awareun, “Go petak. Ze gap tub ebu dareu iz zai, ag han zimamen. Iz ze ziweimai, mu wai, ag han guzental ze ziwamamen, bo, in nug izal ebe naliu eiman simai hubamau, in nug izal ebe nanai eiman hubamau, go izal salau tam. Uwait nugtal duailel ipal egaraimai, agal pip suban mareun dareu.” ");
INSERT INTO bmh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesus nugau tapaimaraneu dudu houhou sag agen ze go doimai, go Zems zaug Zon al en aiag sisileun. ");
INSERT INTO bmh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Guzenina, Yesus nug go ularena, waugab alina, awareun, “Ag abiu, em e ebuan dudu agal gumaraneun dudu banban ipal agen goagal wanimag wag maimai, agal duailel gumaranem. Duailel agal dudu banban agen duailel agal ze sesamorabun gusig ze awaranem. ");
INSERT INTO bmh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ag izal duailel, ag igul go i guzenan. Bo, du tub nug agal du banou danai amau, go iboi amegai go agal salau du sul damau. ");
INSERT INTO bmh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Du tub nug iz wanim banou mui danai amau, amegai go duailel unum agal salau du (slev) sul damau. ");
INSERT INTO bmh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ag don, Du Nugau Nag duailel ipal agen go isanorabun alab tam. Tam pet, tam! Go duailel ipal isanarabun aleun. Go noumaimai, duailel asiu koli Uwait nug waugab imarai simau.” ");
INSERT INTO bmh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus gonugau tapaimaraneu dudu abai Zeriko uzan beteun. Goagen duailel asiu abai koli uzan go utei nuna, ameg kumi du tub wanib Bartimeas, Timeas nugau nag, go abu gasageim hoboi dareun. Gonug duailel esab en nugaraneun. ");
INSERT INTO bmh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Go Nasaret uzanan du, Yesus aleu ina, doimai, go nug ulabun bigegwaimai, eneun, “Yesus, Devit nugau Ug, na iz en bisom peiba, iz isanilen.” ");
INSERT INTO bmh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Duailel asiu agen gusig ze, auremen, “Na soen!” Bo, go gusig uleun, “Devit nugau Ug, na iz en bisom peiba, iz isanilen!” ");
INSERT INTO bmh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Guzenina, Yesus nug tapai daimai, duailel awareun, “Go aurebi, alamau.” Go du ameg kumi uloroimai, auremen, “Gonug na ulizeu, gonun, na ounab naliu maiba, na asaiba, alen.” ");
INSERT INTO bmh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Guzenina, go nug gonugau tibur galau huia ama aimai, pigai asaimai, Yesus waugab aleun. ");
INSERT INTO bmh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Guzenina, Yesus nug aureun, “Izan na erunizai en ailem?” Guzenina, du ameg kumi gonug aureun, “Igulabai miganem du, iz koli ame waipemen, abu piai.” ");
INSERT INTO bmh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus nug koli aureun, “Iboi, na alien. Nait ounab petak emen, gonun, na koli amen waipaba, abu pimam.” Ziwas go ebutal, gonugau ameg waipina, koli abu peimai, go Yesus sesamorai abu bitar. ");
INSERT INTO bmh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Yesus go gonugau tapaimaraneu dudu abai Zerusalem ban uzan bitabun bete betei, Betpage mui Betani uzan ula em manam wanib Oliv ebu beteimai, Yesus nug gonugau tapaimaraneu du aliag palautaraimai, awareun, “Ag ulibe uzan uligem en ebu beteiban, donki nag tub us sil asai memen dareu, us waipaimai, donki nag tub imai alan. ");
INSERT INTO bmh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bo, du tub nug ag donki nag go einen omen aimai kanababa, agen koli auran, ‘Igual Banou nug donki e salau murabun aneun. Salau maziaimai, koli pigai palautemun, alamau,’ guzenai auran.” ");
INSERT INTO bmh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Go beteimai, donki nag tub abu gasageim zau og eiman us sil asai memenin, pemen. Go us waitulena, dudu ipal go ebu tapai daremen, agen awaremen, “Ag einen us donki nag ebuan waitulemen?” ");
INSERT INTO bmh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Goagen Yesus nug ze awareun guzenaital ze go koli awaremen. Dudu agen io ina, go donki oimai, alemen. ");
INSERT INTO bmh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Guzenaimai, go donki nag Yesus waugab imai alaimai, goagal tibur galau huia donki nugau bobou ebu kuloromina, Yesus nug wag simai hoboun. ");
INSERT INTO bmh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Duailel asiu agen goagal tibur galau ipal abu ebu tapai bitabun duei memen. Duailel ipal gue ougem abu waugaban beteimai, nun gau kuatarai egei alaimai, abu ebu duei betemen. ");
INSERT INTO bmh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Duailel agen Yesus ula maimai, ipal amegai betena, ipal ses sesamorai, go unum guzenai ul ai ai betenar, “Uwait nugau wanib ulagwag murab. Du go gue Ban nugau wanib eiman aleun, ");
INSERT INTO bmh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Devit, igual embigeg, nugau gumarabun ziwas zoidareu. Go gumarabun ziwas zumau ebu ig suban damam. Uwait nugau wanib tutak ulagwag mab.” ");
INSERT INTO bmh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Guzenina, Yesus nug Zerusalem uzan simai, Uwait ecesab muranemen zau banou, wanib tub Nou Zau (tempel), nugau gilan og eiman sieun. Go ecesab unum suban uligeun. Bo, ziwas go umusig, am nuabunina, gonun, gonugau tapaimaraneu dudu begurug sag abai Zerusalem uzan uteimai, koli Betani uzan betemen. ");
INSERT INTO bmh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yesus go gonugau tapaimaraneu dudu abai go umaseu pet koli Betani uzan uteimai, abu ebu bete betei, Yesus go we war. ");
INSERT INTO bmh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sabug a gau mui tubaiman uligaimai, sabug dab dareu aimai piabun waugab beteun. Sabug a go dab mabun ziwas tam, gonun, go a dab piabun waugab beteimai, dab ameitai peun. A gau sag daren, peun. ");
INSERT INTO bmh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Guzenaimai, Yesus nug a guzenai aureun, “Du tub nug nait dab koli i oi zimau. Na dab kolital i mamam.” Gonugau tapaimaraneu dudu go ze go donar. ");
INSERT INTO bmh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Go Zerusalem uzan zoimai, Yesus go Uwait ecesab muranemen zau banou, Nou Zau, wanib tempel zaueim simai, duailel ecesab gau maimai, aiwag igwai daremen, gonun, Yesus nug zamarendai, unum uminai wanenar. Gonug dudu agal aiwag igwanemen biz mui meg mai daremen aiwag tebil mui oimai, esikai heun. ");
INSERT INTO bmh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Gonug duailel ecesab gau mabun tempel zaueim oi alanem go i zuaneun. ");
INSERT INTO bmh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Gonug duailel ze abai maraimai, awareun, “Uwait nugau Ze sikut wai memen guzenai dareu, ‘Izal zau duailel go emgasag ata atai eiman alaimai, agen iz ibail ze mabun zau amam.’ Uwait nugau ze guzenai dareu ta, tam? Bo, agen zau e zob dudu agal wageimai dabun empip sul usalai memen.” ");
INSERT INTO bmh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Guzenai awarina, Uwait ula dacanemen dudu banban ipal mui kasai ze tapaimaranem dudu mui go ze go doimai, go webi, noumabun abu bigegwai itanemen. Duailel unum gonugau ze naliu doimai, esilakemen, einen, go dudu banban agen Yesus uminoromen. ");
INSERT INTO bmh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Umusig, em mazicina, Yesus gonugau tapaimaraneu dudu abai ereg go Zerusalem ban uzan utei betenar. ");
INSERT INTO bmh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Betei nineimai, umaseu, go abu ebu bete beteimai, a sabug ginib gau mui unum meumeun, pemen. ");
INSERT INTO bmh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Guzenina, Pita nug Yesus nug um igul go guzeneun koli dabeleimai, Yesus aureun, “Igulabai miganem du, na e pen! Um, na a go eg umau auremen. Ulis go meumeun.” ");
INSERT INTO bmh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus nug koli aureun, “Na Uwait en ounab petak en! ");
INSERT INTO bmh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iz ag petak pet awarem, du tub nug go em manam auraimai, ‘Na asaiba, ze unig oug kuanai numam!’ Guzenai auraba, go ougab aliag i mamau, gonugau ougab petak eun gusig mamau, go em manam gonugau ze sesamoramau. ");
INSERT INTO bmh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Guzenaimai, iz ag awarem, ag ein igul Uwait nug guzenabun aimai aurabun, agal oiagab petak mui auramamen. Gonug agal ze sesamoraimai, go igul gue guzenamau. ");
INSERT INTO bmh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ag Uwait aurabun tapai dabi, du tub nug ag eg mareun ze dabileiban, agen du go nugau igul eg zilagai muramamen. Ag guzenebi, agal memeag Mesgai wag dareu gonug han agal igul eg zilagai maramau.  ");
INSERT INTO bmh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ag du tub nugau igul eg i zilagai muramamen, agal memeag Mesgai wag dareu go nug han agal igul eg i zilagai maramau.” ");
INSERT INTO bmh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Go guzenai awaraimai, go beteimai, Zerusalem uzan koli siemen. Yesus go nug Uwait ecesab muranemen zau banou betei daren, Uwait ula dacanemen dudu banban mui, kasai ze tapaimaranem dudu mui, dudu banban ipal mui, Yesus waugab alemen. ");
INSERT INTO bmh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Go alaimai, Yesus guzenai kanabai auremen, “Na ein gusig oimai, igul go guzenanem? Inug na gusig go mizeun?” ");
INSERT INTO bmh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus nug koli awareun, “Izan han ag ze tub kanabem. Agen amegai izal ze zebigeg go kanabem ailebi, izan mui iz ein gusig eiman igul go guzenanem zebigeg ag awarai. ");
INSERT INTO bmh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Zon, ze ziwaraneun du, go Uwait nug gusig moroun ta, atai, dudu agen gusig moromen ta? Agen iz go zebigeg ailan.” ");
INSERT INTO bmh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Guzenaimai, ag agzozou ze maimai, enemen, “Ig go ein ze aurab? Ig go Uwait nugau gusig eiman ze ziwaraneun emun, go nug aigamau, ‘Guzenaimai, ag einen agal oiagab petak ab tam’. ");
INSERT INTO bmh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bo, ig go du ebuan gusig eiman emun, go han iboin tam.” (Duailel agal dabeleu Zon Uwait petak nugau ze doimai, awaraneun du tub, gonun, dudu banban go duailel goagen ein igul go ebalagab guzenamamen aimai dabeleimai, uminemenin.) ");
INSERT INTO bmh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Guzenaimai, go koli Yesus auremen, “Ig i abiu.” Guzenina, Yesus nug koli awareun, “Iz han, inug iz gusig milen, igul go guzenanem ag i awarai.” ");
INSERT INTO bmh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus nug go tatau ze eiman abai maraimai, awareun, “Du tub go wain wai maimai, wain ug baimai, gilan otoi meun. Gonug wain wai ebu dab pasiabun ob eleimai, wai gumabun zau huia wag meun. wai unum suban daren, dudu ipal gonugau wai salau mabun gau maraimai, salau mina mina, nug emgasag tub pulig betei dareun. ");
INSERT INTO bmh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain dab mazicina, wabun ziwas zuna, go wai atag du nug gonugau salau du tub go wain wai ebu salau mai daremen dudu darem a bitabun aurina, wain dab ipal oi morobi oi alabun aimai, palautina, beteun. ");
INSERT INTO bmh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bo, wai gumei daremen dudu go agen salau du go gusig pataimai, waimai, gaul palautoron, beteun. ");
INSERT INTO bmh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Guzenina, go koli salau du tub palautina, beten, go han guzental gonugau gagalig pouai heimai, eg moroimai, gaul palautoron, beteun. ");
INSERT INTO bmh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Guzenina, gonug kolital salau du tub palautina, beteun. Go han wina, noumeun. wain wai atag du nug gonugau salau dudu asiu palautaren, beten, ipal gaul wagaremen, ipal wagarina, noumemen. ");
INSERT INTO bmh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Guzenina, du tutak dareu go palautabun iboin. Go gonugau nag pet gonugau ougab go en noumeun. Guzenaimai, go nug gonugau nag ses palautabun, dabeleun, ‘Go izal nagwai nugau ze doimai, eg i muramam,’ eun. ");
INSERT INTO bmh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bo, wai gumanemen dudu go agen go alina, peimai, enemen, ‘Wai atag du go gonugau nag aleu. Gonugau memeg noumaba, go nug gonugau memeg nugau ecesab unum umau. Ig go wemun, noumaba, gonugau wain wai ig umam. Ig go guzenamam.’ ");
INSERT INTO bmh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Guzenaimai, go mogoi go gusig pataimai, wina, noumeun. Guzenaimai, gonugau enib wai gasageim hamacemen.” ");
INSERT INTO bmh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesus nug dudu daremen kanabareun, “Agal dabeleu wai atag du nug go salau dudu erunaramau? Go alaimai, wai gumanemen dudu go wagaraimai, noumebi, gonugau wain wai dudu ipal ebeagab ebu mamau. ");
INSERT INTO bmh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Go Uwait nugau Ze sikut wemen ag nanalab tam ta? ‘Go zau sanag zau macanemen dudu agen eg auraimai, geseg eim memen. Ulis, zau go sanag ula ebuan zau sanag gusig naliupet usaleun, Uwait nugtal go sanag salau banou moroun, go naliupet pet ig uligem,’ sikut guzenai dareu. ");
INSERT INTO bmh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesus nug guzenai awarina, Zuda dudu banban agen go ebutal gusig pataimai, auremen, einen, go abiu go gue tatau ze agal igul sul awareun. Go duailel uminaraimai, go go gusig patabun iborain tam. Guzenaimai, go uteimai, wanemen. ");
INSERT INTO bmh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Zuda dudu banban ipal Parisi dudu mui, Herot nugau ze sesamoranem dudu mui, Yesus en ze bimag piabun palautaren, alemen. ");
INSERT INTO bmh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Alaimai, Yesus auremen, “Du banou, ig abiu na petak ze maranem du. Na du tub nugau dabeleu i duanem. Wanimag a dudu tutak sag na i piaranem. Na Uwait nugau igul petak ig abai miganem. Nait dabeleu erunai pet? Aiwag Sisar murabun igul go naliu ta, tam? ");
INSERT INTO bmh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Iguanag go aiwag muramam ta, tam?” Yesus go ameg pataimai, ze memenin abiu maimai, koli awareun, “Ag einen iz ame patemen? Ag aiwag macanemen aiwag tutak oi alai abai milebi, iz piai.” ");
INSERT INTO bmh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Goagen aiwag tutak oi alai moron, Yesus nug awareun, “E aiwag wanib dorog mui in nugau dareu?” Goagen koli auremen, “Sisar nugau.” ");
INSERT INTO bmh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Guzenina, Yesus nug koli awareun, “Guzenaital, ag Sisar nugau ecesab go Sisar muramamen. Uwait nugau ecesab, go Uwait muramamen.” Go ze go naliu doimai, dabeleu asiu omen. ");
INSERT INTO bmh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Zuda dudu banban ipal, goagal wanimag Sadiusi, agen enanem, dudu noumanem koli i asamam anem. Ziwas go ebutal, Sadiusi dudu ipal alaimai, Yesus guzenai kanabemen, “Du Banou, getal Moses nug ig nanalabun guzenai sikut waren, ‘Du tub go go noumina, gonugau wau mogoi tamacag noumina, gonugau amag nug apag nugau wau oimai, mogoi muramau. Mogoi go usalaba, du noumeun nugau nag sul usalamau.’ ");
INSERT INTO bmh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ziwas go ebutal, du tub gonugau gelegul kwali. Mogoi kaman air oimai, go mogoi i moroimai noumeun. ");
INSERT INTO bmh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Guzenaimai, amag tub nug gonugau wau oun. Go han mogoi i murau noumeun. Guzenaimai, amag tub nug air go oimai, guzenaital noumeun. ");
INSERT INTO bmh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Guzenaital betei, go dudu kwali air go omen, unum mogoi i murau gaul noumemen. Guzenina, wab air go daimai, ses noumeun. ");
INSERT INTO bmh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Air go dudu kwali agen omenin, aiu ses noumemen duailel asamam ziwas go ebu asebiag, go in nugau air pet damau? Em ebu, go dudu kwali noumemen agen air tutak omen.” ");
INSERT INTO bmh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus nug koli awareun, “Ag Uwait nugau Ze mui gonugau gusig mui i abiu. Guzenaimai, ag polumanemen dudu pet! ");
INSERT INTO bmh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Duailel noumemen koli asamam, ziwas go ebu, go duair i igaramamen. Ag unum Uwait nugau tibur Mesgai wag dareu sul damamen. ");
INSERT INTO bmh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Moses nug dudu noumemen, asamam en sikut weun. Ze go ulis araog dareu. Ag gonugau ze guzenai nanalab tam ta? Getal ab al a ginampet ebu eleimai, Uwait nug gonugau wanib guzenai meun, Moses aureun, ‘Iz Abraham, Aisak, Zekob agal Uwait.’ ");
INSERT INTO bmh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uwait go dudu noumemen agal Uwait tam. Go dudu muzmuz awau damam agal Uwait. Agal ze go naliu tam.” ");
INSERT INTO bmh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kasai ze tapaimaraneun du tub go Yesus nug ze go naliu Sadiusi dudu awareun doimai, go nug alaimai, Yesus kanabai aureun. “Igual kasai ze unum ula ebu, ein kasai ze go banou pet?” ");
INSERT INTO bmh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Guzenina, Yesus nug koli awareun, “Ein kasai ze banou pet amegai dareu, ‘O, Israel duailel, ag go don. Uwait igual Banou, nug tutak go igual Banou. ");
INSERT INTO bmh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Na nait ounab mui, nait dorop mui, nait dabeleu mui, nait gusig mui, nait Banou, Uwait en sag noumen.’ ");
INSERT INTO bmh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kasai ze banou dareu go gonugau igul guzenai, ‘Na nag en noumem sul, nait zaun en guzenai noumen.’ Kasai ze aliag go banou. Kasai ze tub nug ze aliag e zilaharabun iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Guzenina, kasai ze tapaimaraneu du gonug Yesus koli aureun, “Du banou, na anem go petak. Uwait nug tutak go petak igual Banou. Em wait tub Uwait sul i dareu. ");
INSERT INTO bmh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ig egun waimai, agaimai, Uwait murabun igul go naliu. Bo, ig igual oigeb mui, igual dabeleu mui, igual gusig mui, Uwait nug en noumaimai, ig igua en noumem sul, igual zaiger waigeb darem duair en guzental noumabun, igul aliag go naliu banou pet.” ");
INSERT INTO bmh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus nug du gonugau dabeleu naliu aneun, doimai, go aureun, “Em ziwas pulig tam, na Uwait nugau gilan oug damam.” Gonug guzenai aurina, duailel agen Yesus koli ze tub kanababun uminemenin. ");
INSERT INTO bmh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus nug Uwait ecesab muranemen zau banou, tempel zaueim duailel abaimarai daimai, kanabareun, “Einen kasai ze tapaimaranem dudu agen Kristus go Devit nugau Ug anem? ");
INSERT INTO bmh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devit go Ah Wes nug dabeleu morona, aneun, ‘Uwait Banou nug, izal Banou aureun, “Na izal ebenaliu eiman hoboi damenag, izan nait iwai zaunar unum zilacaraimai, nait aram pinsal damam.” ");
INSERT INTO bmh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit go nugtal “Kristus go izal Banou” aneun, gonun, erunaimai, agen go gonugau ug emen?” ’ Guzenina, duailel asiu go gonugau ze doimai, daremen goagal oiagab naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus nug ze abai maraimai, awareun, “Ag kasai ze tapaimaranem dudu darem suban pian. Dudu go tibur galau naliupet maimai, siksikai aidanemen. Duailel agen go dudu igwanem empip ebu zoi uligaraimai, ‘umaseu’ awaraimai, ebeag paten, dudu go agal oiagab naliu usalanemen. ");
INSERT INTO bmh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Zuda duailel agal gotulanemen zaueim ta, ee zabun zaueim ta zoimai, ag hubabun pip naliu wanemen. ");
INSERT INTO bmh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dudu go agen wab ailel polumaraimai, goagal zauan ecesab gaul oi unanemen. Dudu ipal ameagab han ag Uwait aurabun, ze asiu macanemen. Aiu ses, Uwait nug alai sisiarabun ziwas ebu, dudu go uhu banban pet umam.” ");
INSERT INTO bmh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus go Uwait ecesab muranemen zau banou zaueim aiwag tebil waugab hoboi dareun. Duailel asiu agen aiwag Uwait muranemen aiwag tebil oug memenin, piareun. Duailel aiwag asiu mui goagen aiwag banou memenin. ");
INSERT INTO bmh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bo, wab air tub go ecesab asiu tamacag, gonug zoimai, aiwag ginampet aliag, 2 toia sul, aiwag tebil oug meun. ");
INSERT INTO bmh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus nug gonugau tapaimaraneu dudu ularen, waugab alina, awareun, “Iz petak pet awarem, wab air e go ecesab asiu tam, gonug aiwag banou pet meun. Gonug duailel ipal unum zilarai dareu. ");
INSERT INTO bmh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Duailel e unum ag agal aiwag asiu dareu, aiwag tutak oimai, Uwait moromen. Bo, air e go tam pet. Go gonugau aiwag unum Uwait morou, go ee gau mabun aiwag tub i dareu.” ");
INSERT INTO bmh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus go Uwait ecesab muranemen zau banou zaueim dareun, utei noi bitabun ina, gonugau tapaimaraneu du tub nug guzenai aureun, “Igulabai miganem du, na zau e memen uligen! Aiwag banban sil zau naliu naliu memen dareu suban uligen.” ");
INSERT INTO bmh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus nug koli aureun, “Go iboi, bo, na zau e unum uligem aiu ses iwai zaiagar agen alaimai, zau go unum eg wai mamam. Go zau memen aiwag unum ulagai numam. Aiwag tub gonugau pip i damau.” ");
INSERT INTO bmh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Guzenaimai, Yesus go Oliv em manam ebu simai, hoboimai, Uwait ecesab muranemen zau banou uzaneim pei daren daren, Pita, Zems zaug Zon, Andru, ag sag Yesus al ereg daimai, guzenai kanabemen, “Igul go ein ziwas zumau? Ein igul amegai zuba, ig ziwas go abiu mamam?” ");
INSERT INTO bmh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus nug awareun, “Ag gusig tapai dan. Dudu ipal agen zoimai, ag polu ze awaramam. Ag goagal ze i don. ");
INSERT INTO bmh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aiu ses dudu asiu agen alaimai, izal wanim pataimai, guzenai ze mamam, ‘Iz sag iz Kristus, ag koli imarabun zom.’ Duailel asiu agen guzenai ze doimai, petak amam. ");
INSERT INTO bmh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ag malai aleu ze mui malai saiu mui waiagab alaba, doiban, ag esilakian. Igul go petak amegai zumau. Bo, sisiarabun ziwas go pigai i zumau. ");
INSERT INTO bmh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Emgasag tub ebuan duailel agen asaimai, emgasag tub ebuan duailel abai ereg iwai maimai, malaininamau. Emgasag ipal ebu mim banban zumau. Emgasag ipal ebu duailel we banou damau. Igul go unum zumau igul go enai, air tub go mogoi soligwabun amegai mu banou waneu sul. ");
INSERT INTO bmh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ziwas go ebu, ag gusig tapai dan. Dudu ipal agen ag gusig pataraimai, goagal dudu banban agal ameagab ebu imarai beteimai, Zuda agal gotulanemen zaueim ag esalau sul ugaramam. Ag, izal tapaimaranemin dudu, gonun, agen em ebuan emgasag gumanemen dudu banban ameagab izal ze awarabun gusig tapai damamen. ");
INSERT INTO bmh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Duailel agen Uwait nugau Ze Naliupet emgasag unum duailel awarebi, duailel ag ze go abiu mai dabi dabi, petak go sisiarabun ziwas alamau. ");
INSERT INTO bmh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Dudu ag gusig patarebi, agen dudu banban ameagab ze mebiag, ein ze marai aimai dabeleu asiu i on. Ziwas go ebutal Uwait nug ze awarabun maramau. Uwait nugau Ah Wes nug agal oiagsau eiman anamau. ");
INSERT INTO bmh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dudu ipal agal apanagar, amanagar, agen agal iwai zaiagar agal ebeagab ebu marebi, goagen wagarebi, noumabun hiaramam. Memeagar ipal agen agal geleagar guzental guzenaramam. Geleagar agen han goagal memeagar anaiagar semaraimai, goagal iwai zaiagar agal ebeagab ebu marebi, goagen wagarebi, noumamam. ");
INSERT INTO bmh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ag, izal tapaimaranemin dudu, gonun, duailel unum ag en aiag sisilai zoimai, ag gasag eim hiacaramam. Bo, du in go izal salau i utanem go umkoskos gusig mai damau, aiu ses sisiarabun ziwas ebu, Uwait nug go koli imamau.” ");
INSERT INTO bmh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus nug koli awareun, “Ag ece eg pet tub go getal Uwait nugau Ze doimai, awaraneun du Daniel nug zemeun zumau pimamen. Ece eg pet go Uwait nugau empip naliupet ebu em e ebu zoimai, tapai damau. (Ag ze go nanalanemen aba, suban dabilan.) Ziwas go ebu, duailel ag Zudia agaig ebu daremen ag em manam ebu uminai simamen. ");
INSERT INTO bmh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Du tub go zau wag damau, go noimai, gonugau ecesab zaueim dareu i simai umau. Go pigai gaul uminai teliamau. ");
INSERT INTO bmh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Du tub ougem salau mai damau, go gonugau iweiu naliu zaueim dareu alai i umau. ");
INSERT INTO bmh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ziwas go ebu, ailel enimaga mui, ailel mogoi ap zai darem mui, ag bisomagar pet. ");
INSERT INTO bmh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ag Uwait auramamen, ‘Ze numau ziwas, igul eg go i zumau.’ ");
INSERT INTO bmh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ag getal go uhu banou i wanemen. Uwait nug em patai meun ziwas ebu alai ulis dareu uhu guzenai tub i zoun, aiu ses han uhu guzenai koli i zumau. ");
INSERT INTO bmh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bo, Dubanou Ban nug ziwas huia pigai hogu meun, einen, go igul go guzenab tam zob, duailel asiu i darem zob. Go duailel ipal imarabun isanarai meun, gonun, igul go pigai guzeneun. ");
INSERT INTO bmh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ziwas go ebu, du tub nug zoimai, guzenai awaramau, ‘Kristus e zoimai dareu!’ ta, ‘Go ulibe dareu!’ aimai, awaraba, ag gonugau ze doimai, oiagab petak i an. ");
INSERT INTO bmh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dudu ipal agen alaimai, polumaimai, guzenamam, ‘Iz Kristus.’ Dudu ipal agen enamam, ‘Iz Uwait nugau ze doimai, awaranem du.’ Guzenaimai, go igul banban mui salau ipal ata atai mamam. Go duailel ipal Uwait nug nugtal egareun, polumaraimai, agal ameagab igul go guzenamam. Uwait nugau duailel agal igul eg sesamoraimai, ag Uwait nugau igul utabun aimai polumaramam. Bo, agen igul go guzenabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Guzenaimai, ag gusig tapai dan. Ein igul aiu ses zuabun iz unum ag awaremin.” ");
INSERT INTO bmh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Yesus nug koli eneun, “Uhu banou pet go unum zo unaba, ‘am go umaum sul usalamau, geil go i hilamau, ureb emes wageim zilagai alamam. Guzenaimai, emes wagan ecesab gusig daremen unum iloialoiamam.’ ");
INSERT INTO bmh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Igul go guzenaba, duailel agen Du Nugau Nag Mesgai wag pi oug gusig banban mui al ban eiman alaba, pimamen. ");
INSERT INTO bmh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Guzenaimai, gonug Uwait nugau tibur palautaraba, emgasag unum mui emes wag mui unum beteimai, Uwait nug gonugau duailel egareun, imarai alai tularai mamau.” ");
INSERT INTO bmh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus nug koli awareun, “Ag a gair nugau igul suban dabilan. A gair nug ag am tapamau igul abai maramau. Gair gau unum nuanina, agau awau koli ileu usalina, ag go abiu maimai, go am banou zuabun ziwas. ");
INSERT INTO bmh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Go sultal, aiu ses igul go ata atai zuba, ag abiu maimai, Du Nugau Nag koli alabun ziwas hogu usalai nineu. ");
INSERT INTO bmh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iz petak pet awarem, duailel e ulis daremen ag i noumamamen ebu igul go guzenai zumau ag pimamen. ");
INSERT INTO bmh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Emes mui, e em mui dareu go unum tamamau. Bo, izal ze i tamamau, muzmuz damau.” ");
INSERT INTO bmh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus nug kolital eneun, “Du tub nug Du Nugau Nag alabun ziwas i abiu mamau. Uwait nugau tibur han go i abiu. Gonugau nag han go i abiu. Memeg tutak go sag abiu. ");
INSERT INTO bmh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Guzenai igul dareu, gonun, ag subantal tapai dan. Ziwas go eisab alamau ag i abiu. ");
INSERT INTO bmh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Go guzenai, du tub go gonugau zau uteimai, uzan tub pulig unamau. Gonug gonugau zau utei unabun aimai, gonugau salau dudu gonugau zau gumabun awareun. Goagal salau ata atai marena, zau ogeim gumaneu du gusig aureu, ‘Suban gumei dan.’ ");
INSERT INTO bmh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Guzenai igul, gonun, ag, izal duailel, suban gumaramamen. Ag i abiu, zau atag du ein ziwas koli alamau. Go umusig alamau ta, umaum alamau ta, toi ulaba, alamau ta, em ugaba alamau ta? Ag i abiu. ");
INSERT INTO bmh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ag suban gumei i dabi ziwas go ebu, go pigai alaimai, ag gabuai dabi, alai piaramau. ");
INSERT INTO bmh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gonun, iz ag ze e awarem. Go petak, iz duailel unum ze e awarem. Ag subantal gumei dan.” ");
INSERT INTO bmh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gil aliag mazicina, zobu tub ebu duailel bret zis tamacag zacanem, wanib Pasowa zuna, Uwait ula dacanemen dudu banban mui, kasai ze tapaimaranem dudu mui, agen Yesus gusig pataimai, webi, noumamau en wage wageimai ze patemen. ");
INSERT INTO bmh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bo, go enemen, “Ig go Imabun Ziwas Zobu go ebu i wabun, duailel agen asaimai, ig ibaig ban malai mamam.” ");
INSERT INTO bmh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betani uzan, du tub wanib Saimon, getal go ebeu leprosi mui dacaneun, Yesus nug gonugau zaueim simai daimai, ee zabun eebiz waugab hoboi dareun. Ee zina zina, air tub nug dalim naliu a ilau sous naliu wanib nar mui oi zoun. Air go gue getal aiwag banou sil go a ilau sous naliu gau meun. Gonug dalim go outaimai, a ilau sous naliu mui Yesus nugau gagalig ebu esikeun. ");
INSERT INTO bmh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dudu ipal daremen go igul uligaimai, goagal oiagab eg wina, agzozou enemen, “Einen air go nug a ilau sous naliu mui gaul sakeu? ");
INSERT INTO bmh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ig ze go dudu maremun, gau mebi, gonun aiwag banou, wai tutak ebuan aiwag sul, oimai, duailel ecesab tamacag marabun iboin.” Guzenina, go air go gusig ze auremen. ");
INSERT INTO bmh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesus nug goagal dabeleu abiu maimai, awareun, “Ag air go utebi, damau. Ag go einen ougab eg moroimai, uhu moromen? Go igul naliu pet go iz ebilab meu. ");
INSERT INTO bmh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Duailel ecesab tamacag ag abai umkoskos daren, agen umkoskos go isanarabun iboin. Bo, iz ag abai umkoskos ban i dai. ");
INSERT INTO bmh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Gonug ein igul guzenabun guzeneun. Go a ilau sous naliu mui izal enim tabug ebu esikeun, go iz noumemin, ob oug noumabun enim tabug suban uluseun. ");
INSERT INTO bmh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iz ag petak pet awarem, dudu agen Uwait nugau Ze Naliupet e em gasag unum duailel awarai aidaimai, igul go air e nug meun go han awaramam. Guzenaimai, duailel ag go en dabilamam.” ");
INSERT INTO bmh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Guzenaimai, Yesus nugau tapaimaraneu dudu begurug sag ebuan du tub, gonugau wanib Zudas Iskariot, go Uwait ula dacanemen dudu banban waiagab Yesus goagal ebeagab ebu mabun beteun. ");
INSERT INTO bmh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Go ze go doimai, siksikaimai, aiwag murabun baib memenin. Guzenina, Zudas go Yesus goagal ebeagab ebu mabun abu itanai dareun. ");
INSERT INTO bmh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bret zis tamacag agaimai zanemen ziwas tutak amegai zoun. Ziwas go ebu Zuda duailel ag agal Pasowa sipsip nag waimai, agaimai, zanemen. Guzenaimai, Yesus nugau tapaimaraneu dudu agen Yesus auremen, “Ig nait Pasowa ziwas ebu ee zabun pip eru ebu betei suban kasai mizamam?” ");
INSERT INTO bmh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Guzenai aurina, gonug gonugau tapaimaraneu dudu aliag palautaraimai, awareun, “Ag uzan go bitabun ebu, du tub go ze uleimai, zumau, ag tularamau. Ag go sesamorai beten. ");
INSERT INTO bmh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Go zaueim siba, ag zauan zau atag du go auran, ‘Igual tapaimigeu du eneun, “Iz izal tapaimaranem dudu abai Pasowa ee zabun zau empip eru ebu dareu?” guzenai ze meun.’ ");
INSERT INTO bmh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Go zau tub empip banou ecesab suban meun wag ginam dareu abai maramau. Ag go ebu igual ee zabun empip suban kasan.” ");
INSERT INTO bmh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Go beteimai, ban uzan simai, Yesus nug awareun sul uligaimai, zaueim go Pasowa ee zabun empip suban kasemen. ");
INSERT INTO bmh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Umusig mina, Yesus nug gonugau tapaimaraneu dudu begurug sag abai aleun. ");
INSERT INTO bmh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Go hoboimai, ee zai daren, go nug guzenai awareun, “Iz ag petak pet awarem, du tub ag ula dareu go nug izal iwai zaiar agal ebeagab ebu milamau. Du go gue ulis iz ibail ee zai dareu.” ");
INSERT INTO bmh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Go guzenina, go goagal oiagab uhu usalemen. Go tutak tutak agen guzenai kanabemen, “Na iz en anem ta? Iz tam ta?” ");
INSERT INTO bmh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus nug koli awareun, “Du go gue izal dudu begurug sag abai dareu. Go iz ibail ereg tebil tutak ebu gonugau bret il ebu maimai, oimai zimau. ");
INSERT INTO bmh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Uwait nugau ze eim aneun sul, Du Nugau Nag noumamau, bo, du go nug gonugau iwai zaugul agal ebeagab ebu mareun, du go gue bisou a. Du go gue anag nug soligweun ziwas ebu noumeun zob, go uhu ginampet. Guzenab tam, gonun, aiu ses Mesgai wag go uhu banou pet umau.” ");
INSERT INTO bmh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Go ee zai daren, Yesus nug bret oimai, Uwait auraimai, ebeg sil kuaraimai, gonugau tapaimaraneu dudu maraimai, eneun, “Ag oiban, zan. E izal enim tabug.” ");
INSERT INTO bmh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Guzenaimai, go koli gap wain ze mui oimai, Uwait auraimai, gonugau tapaimaraneu dudu maren, go unum e gap ebuan ze zemen. ");
INSERT INTO bmh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Gonug awareun, “E izal esep, Uwait nug esep gonug ag abai baib awau meu. Izal esep go goricina, duailel asiu isanaramau. ");
INSERT INTO bmh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iz ag petak pet awarem, iz koli e wain dab ebuan ze i zai, betei iz wain ze awau tub go izal Mekai nugau gumarabun uzan koli zai.” ");
INSERT INTO bmh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Guzenaimai, go kabal tub waimai, uzaneim noimai, Oliv em manam ebu betemenin. ");
INSERT INTO bmh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus nug gonugau tapaimaraneu dudu guzenai awareun, “Ag iz utilaimai, uminai teliamamen. Uwait nugau Ze guzenai sikut wai memen dareu, eneu, ‘Sipsip gumamau du go izan wemin, sipsip inain go uminaimai, ata atai teliteliamam.’ ");
INSERT INTO bmh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bo, iz noumaimai, koli asaimai amegai Galili agaig ebu beteimin, ag sesamilai bitamamen.” ");
INSERT INTO bmh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita nug aureun, “Go unum na utizai, telecebi, iz tutak na i utizanai.” ");
INSERT INTO bmh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus nug koli guzenai aureun, “Iz na petak pet aizem, ulis umaum toi aliag i ulau ebu, na izal wanim wagemaimai, ziwas ainarai ebu, ‘Iz du go i abiu’ amam.” ");
INSERT INTO bmh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bo, Pita nug gusig aureun, “Petak pet, iz guzenai ze i manai. Iz na ibaiz ereg noumai.” Yesus nugau tapaimaraneu dudu agen han guzental anemen. ");
INSERT INTO bmh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesus gonugau tapaimaraneu dudu abai ereg em tub wanib Getsemani beteimai, go nug awareun, “Ag e ebu hoboi dabi, iz Uwait auramoroi.” ");
INSERT INTO bmh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Gonug Pita, Zems zaug Zon abai imarai beteimai, gonugau ougab eg wina, go nugtal nug en bisou maimai, guzenai awareun, “Izal oiab uhu pet mina, wauiag kuatina, noumamoroi. Ag e ebu awau dan.” ");
INSERT INTO bmh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Go holoi beteimai, em nogoug ebu ou tonoi nineimai, Uwait nug go uhu go ebu i zuabun aimai Uwait aureun. ");
INSERT INTO bmh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Gonug aureun, “O Mekai, na ein salau guzenabun iboi. Na iz ebilab ebuan gap tub uhu mui oi himam. Bo, na izal dabeleu i sesamoren, na nait dabeleu tutak sesamoren.” ");
INSERT INTO bmh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Guzenai auraimai, go gonugau tapaimaraneu dudu gabuai daremen ebu zoimai piaraimai, asareun. Go Pita aureun, “Saimon, na gabuem ta? Na iz gumilaimai, iz ibail ban awau ginam dabun iboin tam ta? ");
INSERT INTO bmh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ag i gabuan, awau daiban, Uwait auran. Guzenebi, Satan nug i polumaramau. Iz abiu ag igul naliu guzenabun dabelenemen, bo, agal enimag gusig dabun iboi tam.” ");
INSERT INTO bmh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Guzenaimai, go beteimai, koli Uwait ze go getal aureun guzental aureun. ");
INSERT INTO bmh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Go koli alaimai, gonugau dudu koli gabuai daren, piareun. Go ames wagarina, awau dabun iboin tam. Goagen ein ze aurabun i abiu. ");
INSERT INTO bmh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesus nug koli Uwait aurabun utarai waneun. Gonug kolital ziwas ainarai alaimai, asaraimai, awareun, “Ag gabuai daimai, imai daremen ta? Go iboi! Uligan! Du Nugau Nag ebegarab durub waimai, dudu igul eg macanemen agal ebeagab ebu mabun ziwas aleu. ");
INSERT INTO bmh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ulib e du nug iz izal iwai zaiar ebeagab ebu milabun go aleu. Ag asan! Ig betei go tularabun unab.” ");
INSERT INTO bmh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus nug gonugau tapaimaraneu dudu ze go awa awarina, gonugau tapaimaraneu dudu begurug sag ebuan du tub gonugau wanib Zudas, go waugab aleun. Zuda dudu banban mui, Uwait ula dacanemen dudu banban mui, kasai ze tapaimaranem dudu agen dudu asiu Yesus gusig patabun palautaren, Zudas sesamorai betemenin. Goagal malaimanem maulzag mui, malai hog mui patai alemen. ");
INSERT INTO bmh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zudas nug getal go dudu guzenai awareun, “Iz du go betei sibeg zukeminag, ag abe mamamen du go tutak ag gusig pataimai, go malai dudu agal ebeagab ebu mebi, imai unamam.” ");
INSERT INTO bmh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Guzenaimai, Zudas nug pigai Yesus waugab beteimai, guzenai aureun, “Umaseu, tapaimiganem du!” auraimai, sibeg zukzukeun. ");
INSERT INTO bmh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dudu ag go abe maimai, Yesus gusig patemen. ");
INSERT INTO bmh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Du tub ag ula tapai dareun, go nug gonugau maulzag huia oimai, Uwait ula dareu du banou nugau salau du waimai, gonugau dabug gau kuatai heun. ");
INSERT INTO bmh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Guzenina, Yesus nug dudu awareun, “Ag malai mabun malai hog mui maulzag mui oimai, iz zob du sul ebe aram durub waimai, iwabun alemen ta? ");
INSERT INTO bmh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Iz ziwas umkoskos Uwait ecesab muranemen zau banou zaueim duailel tapaimaremin, ag go ebu ebe aram durub waimabun utanemen. Bo, ag igul go guzenina, Uwait nugau Ze doimai, awaranemen dudu agen gonugau ze sikut wai memen go petak usaleun.” ");
INSERT INTO bmh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ziwas go ebutal, gonugau tapaimaraneu dudu unum uminaimai teliemen. ");
INSERT INTO bmh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Mogoi awau tub ninaneun tibur galau tutak tuageun, Yesus sesamorai beteun. Dudu goagen gusig paten, go gonugau ninaneun tibur galau agal ebeagab ebu uteimai, burum uminaimai telieun. ");
INSERT INTO bmh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gumaranemen dudu go Yesus gusig patemen, goagen Uwait ula dacaneu du banou pet nugau zaueim imai betemenin. Go ebu Uwait ula dacanemen dudu banban mui, kasai ze tapaimaranem dudu mui, Zuda dudu banban abai ereg gotulai daremen. ");
INSERT INTO bmh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita go wage wageimai sesamarai, holoi holoi beteun. Guzenaimai, Pita zaueim simai, go zau gumanemen dudu abai hoboimai, ab ugei dareun. ");
INSERT INTO bmh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Uwait ula dacanemen dudu banban mui, Zuda dudu banban ipal mui, agen ze ipal Yesus enib ebu mabun, erunai webi, noumabun aimai guzenemen, bo, go ze guzenabun ze tub itananem iborain tam. ");
INSERT INTO bmh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dudu asiu zoimai, polu ze go enib ebu memenin, bo, go ze tub mab tam. ");
INSERT INTO bmh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Guzenina, dudu ipal zo tapai daimai, go polu ze memenin. ");
INSERT INTO bmh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ig Yesus nug ze go meun, domun. Gonug guzenai aneun, ‘Iz go Uwait ecesab muranemen zau banou dudu agen ebeag sil memenin, tigalaimai, gil ainarai sag maziaba, iz zau tub awau mai. Dudu agen zau go i mamam.’ Go guzenai ze meun, ig domun.” ");
INSERT INTO bmh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bo, goagal ze go unum iborain tam, go ze ata atai memen. ");
INSERT INTO bmh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Guzenina, Uwait ula dacanemen dudu banban agal ameagab ebu tapai daimai, Yesus kanaboroun, “Na einen go dudu ze aizemen koli awarab utem? Na erunemen, gonun, na enim ebu ze mem.” ");
INSERT INTO bmh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bo, Yesus go soai daimai, go ze tub mab tam. Uwait ula dacaneun du banou pet nug kolital kanabeun, “Na Kristus, du go Uwait nug duailel koli imarabun palautizen, alemen ta? Na Uwait Banou nugau Nag ta?” ");
INSERT INTO bmh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus nug koli aureun, “E iz sag. Iz ag petak pet awarem, Du Nugau Nag go Uwait gusig banou mui, nugau ebeg naliu eiman hoboimai, Mesgai wag pi ougeiman alamau, ag pimamen.” ");
INSERT INTO bmh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Uwait ula dacaneu du banou pet go ze doimai, gonugau tibur galau bigagaimai, dudu daremen kanabareun, “Ig einen dudu ipal awaremun, alai gonugau enib ebu ze ipal mamam? ");
INSERT INTO bmh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Go Uwait ze biabial kuai aureun, ag domenin. Agal dabeleu erunamamen?” Goagen koli enemen, “Go ze mui, gonun, webi, noumamau.” ");
INSERT INTO bmh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Guzenaimai, go Yesus enib ebu sino oroimai, gonugau ameg tibur galau sil kiai maimai, ebeag sil waimai, auremen, “Na ze doimai, maranem du aba, na ig aigen, go in nug na niweu?” Guzenina, Yesus gumanemen dudu goagen imai aimai, wemen. ");
INSERT INTO bmh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita go zau gasageim hoboi daren, Uwait ula dacaneu du banou pet nugau salau air tub zoun. ");
INSERT INTO bmh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Gonug Pita ab ugei dareun peimai, gusig uligaimai, aureun. “Na Nasaret uzanan du, Yesus al dacanemen.” ");
INSERT INTO bmh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bo, Pita nug koli aureun, “Na ze go anem go gonugau zebigeg iz i abiu.” guzenai ze maimai, go zau og waugab beten, toi tub uleun. ");
INSERT INTO bmh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Salau air go gue zau ogeiman tapai dareun peimai, go nug duailel waugab tapai daremen, awareun, “Go du go Yesus nugau tapaimorou du tub.” ");
INSERT INTO bmh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita nug koli awareun, “Iz gonugau tapaimorou du tam.” Dai dai, dudu ipal Pita waugab tapai daremen, agen auremen, “Na petak go dual aidanem, einen, na han Galili agaigan du.” ");
INSERT INTO bmh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bo, Pita nug ebeg wag maimai, kolital eneun, “Petak pet iz ag awarem! Iz polu ze mai uhu tub iz ebilab zumau. Iz du go i abiu!” ");
INSERT INTO bmh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Go guzenina ina, toi koli uleun. Pita go Yesus nug getal ze aureun koli dabeleun. “Toi ziwas aliag ulamau ebu, na izal wanim wagemaimai, ‘iz go i abiu,’ ziwas ainarai ze mamam”. Guzenaimai, Pita go banban weineun. ");
INSERT INTO bmh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Em wagena, umaseu, Uwait ula dacanemen dudu banban, Zuda dudu banban, kasai ze tapaimaranem dudu, kaunsel dudu unum abai ereg agen Yesus webi, noumabun ze patemen. Go Yesus us sil ebeg kiai maimai, Pailot nugau ebeg ebu mabun imai betemen. ");
INSERT INTO bmh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Betena, Pailot nug Yesus kanabai aureun “Na Zuda agal gumarabun du banou ta?” Yesus nug koli aureun “Go na anem gotal.” ");
INSERT INTO bmh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Uwait ula dacanemen dudu banban agen gonugau enib ebu polu ze asiu memen. ");
INSERT INTO bmh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Guzenina, Pailot nug kolital kanabai aureun, “Na koli ze mabun einen utem? Na ze go nait enim ebu mem, na duab tam ta?” ");
INSERT INTO bmh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bo, Yesus nug ze tub koli aurab tam. Guzenina, Pailot go dabeleu asiu oun. ");
INSERT INTO bmh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Agal Imabun Ziwas Zobu wanib Pasowa ebu, Rom agal gumaraneu du banou nug wai tutak tutak ziwas go ebu du tub hiacaranem zau oug dacaneu utena, unaneu. Duailel agtal alai gotulaimai, du tub utena, unabun aurina, go du utena, unacaneu. ");
INSERT INTO bmh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ziwas go ebu, du tub gonugau wanib Barabas go hiacaranem zau oug dareun. Getal uzan go dudu agal gumaraneun du banou abai alalina, Barabas nug du tub wina, noumeun. Guzenaimai, go hiacaranem zau oug hina dareun. ");
INSERT INTO bmh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Duailel asiu agen zoimai, Pailot guzenai kanabemen “Na Pasowa imabun ziwas umkoskos du tub hiacaranem zau oug dareun utena, unaneu. Ulis na igul go guzental guzenamam.” ");
INSERT INTO bmh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Guzenai aurina, Pailot nug koli awareun, “Iz Zuda agal gumaraneu du banou utemin, ag abai bitamau en dabelemen ta?” ");
INSERT INTO bmh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailot go abiu Uwait ula dacanemen dudu banban go Yesus nugau igul naliu en aiag sisilina, gonun, go waugab imai alemen. Guzenaimai, gonug ze go kanabareun. ");
INSERT INTO bmh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bo, Uwait ula dacanemen dudu banban agen duailel dabuiag pataimai, awaremen, “Pailot auran, ‘Barabas utemen, unamau.’ guzenai auran.” ");
INSERT INTO bmh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Guzenina, Pailot nug kolital kanabareun, “Du e go Zuda agal gumaraneu du banou anem, iz erunai?” ");
INSERT INTO bmh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Goagen gusig ulemen “Go a gegeulanau ebu noumabun asai men.” ");
INSERT INTO bmh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailot nug awareun, “Einen? Go ein igul eg meun?” Goagen kagagai, ulaimai, enemen, “Go a gegeulanau ebu asai men!” ");
INSERT INTO bmh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Duailel agal oiagab naliu usalabun Pailot nug Barabas utena, waneun. Guzenaimai, go nug Yesus malai dudu agal ebeagab ebu mina, goagen esalau sul oimai, malai dudu ipal maren, agen mui go a gegeulanau ebu asai mabun imai betemen. ");
INSERT INTO bmh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Malai dudu agen Yesus Pailot nugau zaueim, wanib Pretoriam, imai beteimai, malai dudu ipal zaueim dacanemen ereg ularen, alai gotulemen. ");
INSERT INTO bmh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Guzenaimai, malai dudu agen tibur galau epeu pet tub tugai moroimai, kulam us huiau tub oimai, kukotoimai, gonugau gagalig ebu mai moromen. ");
INSERT INTO bmh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Goagen gusig auremen, “Na Zuda agal gumaranem du banou, ig nait wanim ulapwag mem.” ");
INSERT INTO bmh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Goagen kabit sil gonugau gagalig koli koli waimai, enib ebu sino oromen. Go go waugab taubib waimai, du banou sul gonugau wanib wag pet memen. ");
INSERT INTO bmh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Go guzenai ze biabial kuai auraimai, koli tibur galau epeu go ebuan oi heimai, gonugau tibur galau koli arugai moromen. Guzenaimai, go go a gegeulanau ebu asai mabun imai betemen. ");
INSERT INTO bmh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Rom agal malai dudu agen Yesus a gegeulanau ebu wai mabun abu ebu imai bete betena, du tub go Sairini uzanan, Aleksanda zaug Rupus al go agal memeag, ban uzan siabun aleun. Gonugau wanib Saimon. Go go abu ebu tuloroimai, gusig pataimai, Yesus nugau a gegeulanau oimai, Saimon gamai morona, go Yesus sesamorai beteun. ");
INSERT INTO bmh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Go Yesus em tub wanib Golgota imai betemen. Go em wanib zebigeg enai ‘eb gagalig gulam’. ");
INSERT INTO bmh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Guzenaimai, goagen wain ze tub marasin munug wanib ‘mair’ mui, maimai, kekulaimai, Yesus zimaun aimai murabun emen. Bo, Yesus go zab uteun. ");
INSERT INTO bmh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Guzenaimai, goagen Yesus a gegeulanau ebu asai memen. Gonugau tibur galau ecesab mui go doumai wabun aimai onanem aiwag oimai, onemen. ");
INSERT INTO bmh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Am zuna, amameg sai naliu (9) sul, go go a gegeulanau ebu noumabun asai memen. ");
INSERT INTO bmh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ze go duailel agen getal gonugau wanib ebu ze memen, gonugau gagalig tabaugab guzenai sikut wai memen, ‘Zuda agal gumaraneu du banoug.’ ");
INSERT INTO bmh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Goagen dudu aliag go igul eg memen imaraimai, du tub Yesus nugau ebeg naliu eiman asai memen, tub ebeg nanai eiman asai memen. ");
INSERT INTO bmh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Guzenaimai, Uwait nugau Ze getal sikut weun go iboreun, “Goagen dudu eg abai ereg tularai memen.” Ze go petak usaleun. ");
INSERT INTO bmh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Duailel agen abu eiman beten zonen aimai, go uligaimai, gagaliag kunkunaimai, ze biabial kuai auraimai, enemen, “A! Na guzenai anem, na Uwait ecesab muranemen zau banou tigalaimai, ziwas ainarai sag koli zau awau mai. ");
INSERT INTO bmh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Guzenanem, nagtal koli nait enim isanoroimai, a gegeulanau ebuan utei non!” ");
INSERT INTO bmh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Uwait ula dacanemen dudu banban mui, kasai ze tapaimaranem dudu mui, agen han guzental ze biabial kuai auremen, “Go duailel ipal isanareun, go nugtal koli gonugau enib isanorabun iborain tam! ");
INSERT INTO bmh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Go Kristus, Zuda agal gumaraneu du banou king zob, go a gegeulanau ebuan utei nuba, ig go peimai, igual oigeb go en petak mamam zob.” Zob dudu aliag go han go guzental ze biabial kuai awaremen. ");
INSERT INTO bmh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Am ban, am ameg ula ebu, am ilab tam, em unum umutai sul usalai betei amameg ainarai una una umusig meun. ");
INSERT INTO bmh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Guzenai daren daren, am ameg ainarai mabun ina, Yesus nug guzenai uleun, “Eloi, Eloi, lama sabaktani.” Ze go bigeg enai ‘Izal Uwait, izal Uwait, na einen iz utilem?’ ");
INSERT INTO bmh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Guzenina, duailel ipal go ebu tapai daremen, goagen ul go doimai, enemen “Ag go don! Du gue go Elaiza ulorou.” ");
INSERT INTO bmh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Guzenaimai, du tub nug pigai beteimai, e tub ambig sul oimai, wain ze munug oug maimai, ait kabit ebu maimai, Yesus zimau en aimai murabun dabeleimai, duailel awareun, “Ig gumei damun, Elaiza nug alai, go a gegeulanau ebuan imai numau ta, uligai dab.” ");
INSERT INTO bmh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ziwas go ebutal, Yesus nug gusig ulaimai, go nugtal gonugau dorog utei wanena, noumeun. ");
INSERT INTO bmh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Guzenina, laplap Uwait ecesab muranemen zau banou zaueim asai memen dareun, ulatal bigagai noi betei, aliag usaleun. ");
INSERT INTO bmh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Malai gumaraneu du banou go Yesus waugab eregtal tapai daimai, gonugau ul eun doimai, go noumeun igul uligaimai, gonug eneun, “Petak pet, du go gue Uwait nugau Nag!” ");
INSERT INTO bmh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ailel ipal agen tubaiman tapai daimai, uligai daremen. Go ailel ula, air tub gonugau wanib Maria go Magdala uzanan, air tub gonugau wanib Maria go Zems zaug Zosep goagal anaiag, (Zems go ginampet ananem), air tub gonugau wanib Salome mui, daremen. ");
INSERT INTO bmh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ailel go getal Yesus Galili agaig daren, go isanorabun sesamorai bitanemen. Ailel ipal asiu go Yesus dual ereg Zerusalem uzaneim alemen, go han ereg daremen. ");
INSERT INTO bmh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Go Fraide, ecesab kasarabun ziwas. Ginam Zobu go Zuda agal imabun ziwas. Guzenaimai, umusig mina, du tub gonugau wanib Zosep go Arimatea uzanan, go Zuda gumaraneun dudu banban agal salau zaiag, go nug Uwait em e gumabun koli alamau aimai gumei dacaneun. Go Pailot uminurab tam, waugab beteimai, Yesus nugau noumeun enib oimai, aizau ob oug hiabun kanabeun. ");
INSERT INTO bmh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailot nug Yesus pigai noumeun ze doimai, go esilakeun. Go dudu ipal palautaren, malai gumaraneu du banou alai aurina, go alina, Pailot nug kanabeun, “Yesus noumeun ta?” ");
INSERT INTO bmh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Malai du gonug io aurina, Pailot nug Zosep aureun, “Iboi, na eb noumeun enib oi unamam.” ");
INSERT INTO bmh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Guzenina, Zosep nug tibur galau ipal ausiau gau maimai, Yesus nugau noumeun enib a gegeulanau ebuan oimai, tibur galau sil kuloroi maimai, aizau ob oug meun. Guzenaimai, aiwag banou oimai, aizau ob ogusau tapelai meun. ");
INSERT INTO bmh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria go Magdala uzanan, Maria go Zosep nugau anag dual go Aramatia uzanan Zosep nug Yesus go aizau ob oug meun pemenin. ");
INSERT INTO bmh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Imabun ziwas mazicina, Maria go Magdala uzanan, tub Maria go Zems nugau anag, Salome mui go a ilau nugau sous naliu pet mui gau maimai, oi alaimai, Yesus nugau noumeun enib ebu ziorai muraporoi. ");
INSERT INTO bmh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Ban Zobu ebu, umaseutal pet, ag go aizau ob piabun abu ebu bete betei, agzozou enemen, “Inug go aiwag banou aizau ob ogusau tapelai memen oi ilacilamau?” ");
INSERT INTO bmh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bo, go suban uligaimai, aiwag banou go oi hemen go uligemen. ");
INSERT INTO bmh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Guzenaimai, ag go aizau ob oug simai, mogoi awau tibur galau ausiau mui aizau ob oug ebeg naliu eiman hoboi dareun peimai, esilakemen. ");
INSERT INTO bmh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Go nug awareun, “Ag i uminan. Ag Yesus Nasaret uzanan, a gegeulanau ebu noumabun asai memen, itanabun alemen. Go koli waseun! Go e ebu i dareu. Go empip go gabuai memen ag uligan. ");
INSERT INTO bmh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ag beteiban, gonugau tapaimaraneun dudu mui Pita mui auran, ‘Yesus go amegai Galili agaig bitamau, go sesamorai bitamam. Ag go getal awareun sultal go ebu pimamen,’ go guzenai awaran.” ");
INSERT INTO bmh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Go guzenai awarina, ailel go esilakaimai, dabeleu asiu oimai, aizau ob go uteimai, uminai wanenar. Go banban uminaimai, du tub ze aurab tam. ");
INSERT INTO bmh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ban Zobu ebu, umaseutal, Yesus koli wasaimai, go amegai Maria go Magdala uzanan, getal air go wes eg kwali (7) sag zamareun waugab betena, gonug go uligeun. ");
INSERT INTO bmh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Guzenaimai, Maria beteimai, go dudu getal Yesus dual dacanemen, oiagab eg wina, weinai daremen awareun. ");
INSERT INTO bmh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria nug guzenai awareun, “Yesus awau darena, iz go pemin.” Ag gonugau ze doimai, agal oiagab petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ziwas tub ebu, Yesus nugau tapaimaraneun dudu aliag go ban uzan uteimai, unabun bete betei abu ebu Yesus pemen. ");
INSERT INTO bmh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Goagen koli beteimai, tapaimaraneun dudu ipal awaremen, “Ig Yesus abu ebu uligemun!” Bo, goagal ze doimai, agal oiagab petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ziwas tub ebu, gonugau tapaimaraneun dudu nigbasig sag ee zina zina, Yesus nug go waiagab zuna, goagen uligemen. Go acegsisilina, awareun, “Ag einen agal oiagab petak i eu? Ag einen oiagab gusig dareu? Iz koli wasemin, dudu iz uligilemen goagal ze doimai, ag einen oiagab petak i eu? Igul go naliu tam.” ");
INSERT INTO bmh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Guzenaimai, go nug go awareun, “Ag emgasag gasag unum beteimai, izal Ze Naliupet e duailel unum abaimaran. ");
INSERT INTO bmh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Duair in ze go doimai, gonugau ougab petak amau, go ze sil ziorebi, go Uwait nug koli imamau. Duair in gonugau ougab petak i eu, go du utamamen, go ze mui damau. ");
INSERT INTO bmh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Duailel agal oiagab petak aba, ag gugeg go guzenabun iboin. Agen izal wanim pataimai, wes eg zamaramamen. Agen emgasag tub ebuan ze getal i abiu daremen maramamen. ");
INSERT INTO bmh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Agen man eg ebeag sil patarebi, man go agen go eg i maramam. Ze eg zaimai noumanem sul ag zaimai, ag i noumamamen. Agen agal ebeag ebeu duailel ebalagab mebi, duailel go ameag pasamau.” ");
INSERT INTO bmh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesus Dubanou Ban gonun ze go awarina, Uwait nug imai aimai, Mesgai wag sieun. Go Uwait nugau ebeg naliu eiman hoboi dareu, guzenaimai, go mui duailel unum gumarai dareu. ");
INSERT INTO bmh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Guzenina, gonugau tapaimaraneun dudu go emgasag gasag unum beteimai, Yesus nugau ze duailel unum awaremen. Dubanou Ban nug go abai ereg salau una, goagen gugeg go getal awareun sul guzenina, dudu ipal gugeg go uligaimai, gonugau ze getal aneun petak go abe memen. ");
INSERT INTO bmh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiopilus, na Uwait en ounab nug noumanem du. Muz dudu banban agen getal Yesus nugau igul abai migeun. Go sikut wemen. ");
INSERT INTO bmh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Getal ipal dudu agen go igul uligaimai, anena sikut wemen. Guzenaimai, iz mui ereg ze go doimai, na sikut wai mizem. ");
INSERT INTO bmh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Iz Luk, getal iz guzental ze go duabun kanabai aidaremin, iz unum doimai, sikut wai mizem. ");
INSERT INTO bmh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Guzenaimai, na abiu mamam, ze koli mizem go petak pet. ");
INSERT INTO bmh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ziwas go ebu Herot go Zuda du uzan gumaneun du banou, go ebu, du tub go Uwait ula dacaneun du gonugau wanib Sekaraias, gonugau wau wanib Elizabet, go mui Uwait ula dacanemen dudu agal zaiagar. ");
INSERT INTO bmh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Go du gonugau wau dual Uwait nugau ameg ebu naliupet dacanem, gonugau ze unum sesamoranemen go igul eg tamacag. ");
INSERT INTO bmh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Go mogoi tamacag, einen, Elizabet go mogoi i pataneun. Guzenaimai, Elizabet Sekaraias dual, ereg ureg pet memen. ");
INSERT INTO bmh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ziwas tub ebu Sekaraias gonugau salau mabun ziwas zuna, go Uwait ulagwag murabun nou zau simai Uwait nugau ameg ebu salau mai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Uwait ula dacanem dudu agal igul enai, go aiwag onaimai, Sekaraias nug Uwait ecesab muranemen zau banou zaueim salau mabun sieun. Guzenaimai, ecesab itu naliupet mui agarabun go moromen. ");
INSERT INTO bmh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ziwas go ebu, Sekaraias go Uwait nugau ece itu naliupet agabun ebu, duailel asiu uzaneim tapai daimai, go Uwait aurai daremen. Go Uwait nugau zaueim ulagwag murabun sieun. ");
INSERT INTO bmh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Uwait nugau tibur go waugab zoimai, ebeg naliu eiman abmuk itu naliupet zoi dareun ebu zoimai tapai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraias go Uwait nugau tibur uligaimai, esilakaimai, umineun. ");
INSERT INTO bmh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Uwait nugau tibur nug aureun, “Na umin ien. Uwait nait ze auremen doun. Gonun, nait wat Elizabet go mogoi tub soligwamau. Na gonugau wanib Zon mamam. ");
INSERT INTO bmh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mogoi go usalaba, na han ipal dudu ailel banban asiu abai oiagab siksikamamen. Agal oiagab naliu pet usalamau. ");
INSERT INTO bmh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Go Uwait nugau ameg ebu du banou damau. Go wain ze, gusig ze mui ereg i zimau. Go anag ougab oug daba daba, Uwait nugau Ah Wes go mogoi dual mui damau. ");
INSERT INTO bmh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Gonug Israel duailel asiu agal oiagab kekulaimai, kolital goagal Uwait Ban waugab imarai bitamau. ");
INSERT INTO bmh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Go du banou amegwab amegai bitamau. Go du gusig mui Elaiza sul damau. Gonug mogoi ginaginamul mui agal memeagar abai kolital ereg gotularamau. Gonug duailel agal dabeleu eg wanemen kolital dabeleu naliupet usalai maramau. Gonug Banou nugau duailel suban kasaramau.” ");
INSERT INTO bmh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraias nug Uwait nugau tibur kolital aureun, “Go igul petak zuba, iz erunai abe mai? Iz ureg pet usalem, izal air han ureg pet usaleun, go igul erunai usalamau?” ");
INSERT INTO bmh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Uwait nugau tibur nug aureun, “Iz Gabriel. Iz Uwait nugau ameg ebu tapai danem. Iz Uwait nugtal palautilen, go ze naliupet aizabun alemin. ");
INSERT INTO bmh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bo, na izal ze sesamorab uteimai, na go igul guzenem, gonun, go baib mizem usalaba, na i zemamam, onsau utub usalai damam.” ");
INSERT INTO bmh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Uwait ulagwag murabun zaueim go guzenina guzenina, duailel go uzaneim daimai, Sekaraias zaueim salau mai dareu en dabeleu asiu omen. ");
INSERT INTO bmh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Go kolital uzaneim noimai, go ze zemabun iborain tam. Guzenina, duailel go abe mem go Nou zaueim igul tub usalina, uligeun. Go ze zemarabun iborain tam, gonun, go ein ze awarabun ebeg abai marena, uligemen. ");
INSERT INTO bmh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraias, gonugau salau pataneun ziwas mazicina, go gonugau uzan waneun. ");
INSERT INTO bmh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ginam dai dai, gonugau wau Elizabet eniba maimai, go geil tabkuai gonugau uzan utei unab tam. ");
INSERT INTO bmh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Gonug enai ze meun, “Ulis, Uwait nug isanileimai, go izal uhu zilagai mileun.” ");
INSERT INTO bmh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabet go eniba darena, geil wasolig mazicina, Uwait nug kolital gonugau tibur Gabriel, Galili agaig tub uzan wanib Nasaret palautendai, beteun. ");
INSERT INTO bmh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Uwait nugau tibur nug air tub magun, gonugau wanib Maria, piabun palautendai, beteun. Maria go du tub, wanib Zosep, wabun ze usalai moromen. Zosep go Devit nugau ug oug. ");
INSERT INTO bmh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Uwait nugau tibur go gue air Maria waugab zoimai, aureun, “Umaseu, Maria, Uwait na ibaiz dareu. Uwait na en ougab naliupet usaleun.” ");
INSERT INTO bmh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria go ze doimai, esilakaimai, dabeleu asiu oun. ");
INSERT INTO bmh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Uwait nugau tibur nug kolital aureun, “Maria, na umin ien. Uwait na ibaiz dareu. ");
INSERT INTO bmh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na aiu ses enima maimai, mogoi tub soligumam. Go mogoi wanib Yesus mamam. ");
INSERT INTO bmh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Go du banou maimai, Uwait wag dareu nugau mogoi damau. Uwait nug duailel gumarabun palautamau. Gonugau embigeg Devit dareun sul damau. ");
INSERT INTO bmh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Go Zekob nugau zaugul gumarabun du banou muzmuz damau. Gonugau duailel i utaramau.” ");
INSERT INTO bmh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria nug kolital Uwait nugau tibur aureun, “Iz du tub dual ninab tam, gonun, go igul erunai iz ebilab usalamau?” ");
INSERT INTO bmh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Uwait nugau tibur nug Maria kolital aureun, “Uwait nugau Ah Wes na ebizab alamau. Uwait nugau gusig na ibaiz damau. Guzenaimai, mogoi go Uwait nugau Mogoi amam. ");
INSERT INTO bmh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Maria, getal nait zinap Elizabet go ureg meun mogoi i soligwamau anemen, go ulis eniba dareu. Gonugau geil wasolig mazieun. ");
INSERT INTO bmh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ein igul Uwait nug mabun amau, go igul mamau.” ");
INSERT INTO bmh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria nug kolital Uwait nugau tibur aureun, “Iz Uwait nugau salau air, go igul na anem sul iz ebilab zumau.” ");
INSERT INTO bmh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Guzenaimai, Uwait nugau tibur nug Maria utei waneun. Ziwas go ebu, Maria asaimai, Elizabet piabun Zudia agaig manam ebu gonugau zinau piabun beteun. ");
INSERT INTO bmh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maria go Sekaraias nugau zau simai, Elizabet aureun, “Umaseu.” ");
INSERT INTO bmh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Elizabet go Maria nug ‘Umaseu’ aurina, go mogoi gonugau ougab oug dareun esilakaimai, aseun. Uwait nugau Ah Wes Elizabet ebu kapina, Elizabet go Uwait ulagwag moroimai, Maria aureun, “Na air gusig mui, nagen ailel unum e em ebuan na tutak wanim ulapwag ban mizamam. Na mogoi go soligwamam naliupet damau. ");
INSERT INTO bmh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Einen, go igul naliupet iz ebilab zou? Izal Dubanou Ban nugau anag go iz darem a aleu. ");
INSERT INTO bmh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iz nagen ‘Umaseu.’ ailina, izal mogoi oiab oug dareu esilakaimai, ougab siksikaimai, aseun. ");
INSERT INTO bmh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na air nait ounab petak pet usaleun, gonun, nait ounab siksikamam. Uwait nugtal aizeun sultal nait ounab petak pet usalamau.” ");
INSERT INTO bmh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria nug Uwait ulagwag moroimai, eneun, “Iz dorop mui unum Ban ulagwag morom. ");
INSERT INTO bmh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Izal oiab naliu meu, einen, Uwait nug iz isanileimai, imaileu. ");
INSERT INTO bmh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iz, gonugau salau air wanim banou tamacag, ulis iz wag mileu. Ulis betei aiu ses mui duailel unum e em ebuan zemamam, go air gonugau ougab siksikai dareu. ");
INSERT INTO bmh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Einen, go igul Uwait ban gusig mui nugtal guzeneun. Uwait nugau wanib naliupet. ");
INSERT INTO bmh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Getalan duailel mui ulisan duailel mui go Uwait ulagwag muramam, gonugau bisou go abai damau. ");
INSERT INTO bmh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Gonugau gusig banou nug go dudu goagal wanimag wag macanemen, go nug agal wanimag piu maramau. Dudu goagal wanimag wag manem, go utarebi, ata atai waneanamam. ");
INSERT INTO bmh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Uwait nug gumaranem dudu banban agal hubabun pip ebuan oi amaraba, nobi, gonug kolital dudu wanimag tamacag isanaraimai, goagal wanimag wag maimai, pip naliu ebu maramau. ");
INSERT INTO bmh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Uwait nug we daremen dudu ee naliu maramau. Go dudu ece asiu mui palautaraba, gaul unamam. ");
INSERT INTO bmh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Getal Uwait nug igual embigeg abai baib mareun. Gonug Abraham gonugau zaugul abai aneun ag isanarai. Guzeneun, gonun, go ig Israel gonugau salau duailel usalemun. ");
INSERT INTO bmh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Go ig Israel duailel getal igual embigeg Abraham mui gonugau ug mui baib mareun ulis gonugau ougab naliu maimai aleu.” Maria guzenai ze meun. ");
INSERT INTO bmh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria go geil ainarai Elizabet dual daimai, kolital gonugau uzan waneun. ");
INSERT INTO bmh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabet mogoi soligwabun ziwas alina, go mogoi soligweun. ");
INSERT INTO bmh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Gonugau uzanan duailel mui gonugau ug han go ze go doimai, go beteimai, go dual ereg oiagab siksikemen. Einen, Uwait nug ougab naliu usalai moroun. ");
INSERT INTO bmh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Israel agal igul, mogoi gil gugen mazicina, gonugau enib galau kuatanemen. Go mogoi gil gugen mazicina, gonugau enib galau kuatabun gonugau ug abai ereg imai Nou zaueim siemen. Gil go ebu, gonugau ug agen memeg nugau wanib Sekaraias wanibsalai mabun emen. ");
INSERT INTO bmh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Gonugau anag nug kolital awareun, “Go tam. Gonugau wanib Zon.” ");
INSERT INTO bmh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Gonugau ug agen kolital Elizabet auremen, “Nait ug tub wanib Zon i dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Gonugau ug agen kolital gonugau memeg kanaboromen, go ogusau tapeleun zemabun iborain tam, gonun, gonugau ug agen gonugau mogoi wanib mabun ebeag sil abai moromen. ");
INSERT INTO bmh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraias nug gonugau ebeg sil agau ebu sikut wabun awarendai, agau tub oi morona, oimai, sikut guzenai weun, ‘Gonugau wanib Zon’. Duailel ag go wanib uligaimai, go esilakem. ");
INSERT INTO bmh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ziwas go ebu Sekaraias go ogusau tapelai dareun, go kolital zemeun. Go siksikaimai, Uwait nugau wanib ulagwag moroun. ");
INSERT INTO bmh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gonugau zaugul go waugab danemen go ze unum doimai, go uminaimai, go ze unum Zudia agaig manam ebu ulag iboreun. ");
INSERT INTO bmh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Duailel go ze doimai, ipal kanabai awarinar, “Go mogoi aiu ses go ein salau mamau? Go mogoi Uwait nugau dabeleu mui gonugau gusig banou go dual dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zon nugau memeg, Sekaraias go Uwait nugau Ah Wes gonugau ougab oug danarai, go Uwait nugau wanib guzenai ulagwag moroun, ");
INSERT INTO bmh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ig Israel agal Uwait Banou nugau wanib ulagwag murab. Gonug alaimai, ig gonugau duailel isanigeimai, kolital gau migeun. ");
INSERT INTO bmh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Gonug gonugau salau du Devit nugau ug ebuan du tub ig kolital gau migabun palautendai, aleun. ");
INSERT INTO bmh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Getal Uwait nug nugau ze doimai, awarenemen dudu agal oiagsau eiman ze meun. ");
INSERT INTO bmh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Go eneun, gonug igual iwai zaiger mui ipal dudu ig eg miganem ebuan kolital imaigamau. ");
INSERT INTO bmh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Gonug eneun, go igual zaiger suban gumaraimai, isanaraimai, gonugau baib getal meun dabeleu. ");
INSERT INTO bmh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Go igual asanig Abraham petak pet aureun. Go ze ulis ig ebiligeb petak zou. ");
INSERT INTO bmh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ig go igual iwai zaiger agal ebeagab ebuan imaigamau. Ig umin i ab, ig Uwait nugau salau i utab. ");
INSERT INTO bmh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Guzenaimai, ig em ebu dacab, ig gonugau ameguab umkoskos gonugau salau naliu tuguiai sesamorai mamam. ");
INSERT INTO bmh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na, izal mogoi, aiu ses nait wanim Uwait wag dareu nugau ze doimai, awaraneun du sul aizamau. Na Dubanou Ban nugau abu kalai moroimai, amegai bitamam. ");
INSERT INTO bmh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na duailel abai maremen, go abiu mebi, gonug agal igul eg zilagaimai, go kolital igaramau. ");
INSERT INTO bmh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Igual Uwait Banou go ig en ougab nug noumaimai, go guzenamau. Go Mesgai wagan em hilanau ig ebiligeb palautamau. Go hilanau nug ig kolital imaigamau. ");
INSERT INTO bmh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Go hilanau nug, dudu umus oug darem mui, noumabun abu ebu darem mui, hilanau ebalagab hilamau. Gonugau ougab naliu maimai, abu abai migamau.” ");
INSERT INTO bmh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mogoi go Uwait nugau gusig mui ban meun. Go du tamacag uzan betei dareun. Go dai dai, Israel duailel agal amiagab zoimai, Uwait nugau ze tapaimareun. ");
INSERT INTO bmh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ziwas go ebu Elizabet go Zon soligweun ebu, du banou tub Sisar-Ogastas go gue go ziwas ebu em go ebuan duailel unum wanimag wabun ze palaut mareun. ");
INSERT INTO bmh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Uzan gonun du tub, gonugau wanib Sairinias, go Siria agaig gumaneun. ");
INSERT INTO bmh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Duailel unum agal embigeg ebu usalemen, go tutak tutak wanimag agau ebu wabun betemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zosep go Nasaret uzanan asaimai, Galili agaig eiman betei Betlehem uzan, Zuda agaig beteun. Go Devit nugau embigeg, gonun, go go ebu gonugau wanib wabun beteun. ");
INSERT INTO bmh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Zosep go gonugau wau Maria wabun ze usalai moromen eniba mui, wanib ereg wabun imai beteun. ");
INSERT INTO bmh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bete Betlehem uzan daren daren, Maria go mogoi soligwabun ziwas usaleun. ");
INSERT INTO bmh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maria gonugau kaman mogoi soligweun. Tibur galau sil kulai maimai, bulumakau agal ee zanemen tebil oug meun. Go uzan zau tub empip gaul dab tam, empip unum egemen. Einen, duailel go uzan wanimag wabun betemen agen empip unum egemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ziwas go ebu, go uzan gasag ipal sipsip gumaranemen dudu, go umaum agal sipsip gumarai ninemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Uwait nugau tibur go waiagab usalina, Uwait nugau al banou go dudu ebalagab hilanau hileun. Dudu goagen go al banou peimai uminemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Uwait nugau tibur nug awareun, “Ag umin ian, einen, iz ag ze naliupet marabun oi alem. E ze en, duailel unum siksikamam. ");
INSERT INTO bmh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ulis umaum agal embigeg Devit nugau uzan, du tub ag isanarabun soligweun. Go Kristus Dubanou Ban. ");
INSERT INTO bmh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ag go igul abe mamamen. Ag beteimai, mogoi gonugau anag nug bulumakau ee zanemen tebil ebu gabuai meun, tibur galau sil kulai meun dareu, ag betei pian.” ");
INSERT INTO bmh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Guzenai awarina awarina, Mesgai wagan Uwait nugau tibur asiu usalaimai, Uwait nugau wanib ulagwag maimai, kabal wemen. Go guzenai kabal wemen, “Uwait go gusig mui, go Mesgai wag dareu. Em ebuan duailel ag igul naliu mina, Uwait nugau ougab naliu meu, agal oiagab iau damau.” ");
INSERT INTO bmh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Uwait nugau tibur go wanena, sipsip gumaranemen dudu agzozou zeminar, “Ke, ig Betlehem uzan beteimai, ig go ein igul usaleun Uwait nug aigeun betei piab.” ");
INSERT INTO bmh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Guzenaimai, sipsip gumaranemen dudu agen pigai beteimai, Maria gamu Zosep dual betei piaremen, mogoi go bulumakau agal tebil oug dareun pemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sipsip gumaranemen dudu mogoi uligaimai, gonugau memeg anag abai Uwait nugau tibur nug ze awareun sultal go ze unum awaremen. ");
INSERT INTO bmh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dudu go ebu daremen go ze doimai, esilakemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria go ze go doimai, gonugau ougab oug unum mai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Guzenaimai, sipsip gumaranemen dudu kolital goagal uzan beteimai, Uwait ulagwag moroimai, kabal wemen. Einen, agagal amiag nug go mogoi uligemen, Uwait nugau tibur nug awareun guzenaital betei uligemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Gil gugen mazicina, mogoi go enib galau kuataimai, gonugau wanib Yesus memen. Go wanib getal Uwait nugau tibur nug Maria eniba tam ebu go wanib moromen. ");
INSERT INTO bmh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maria Zosep dual gil 40 mazicina, anag mogoi dual ereg kolital naliu usalabun, Uwait nugau zaueim siemen. Einen, getal Moses nug aneun, ‘Anaiagar, memeagar agen agal geleagar Uwait nugau ameg ebu imarai betei Uwait muramamen.’ ");
INSERT INTO bmh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Go Uwait nugau kasai ze ebu dareu. ‘Go geleagar kaman ag amegai numam, go geleagar ag Uwait Banou muran.’ ");
INSERT INTO bmh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Go Uwait ulagwag murabun meg kurumuk aliag kasai ze eim aneun guzenai oi siemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ziwas go ebu du tub Zerusalem uzan dareun. Gonugau wanib Simeon. Go Uwait nugau amegwab du naliu daneun. Go umkoskos Uwait ulagwag muraneun du. Go du tub Israel duailel kolital imarabun alamau gumei dareun. Uwait nugau Ah Wes nug Simeon dual dareun. ");
INSERT INTO bmh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Uwait nugau Ah Wes nug Simeon aureun, “Na pigai i noumamam. Na go du Banou nug palautamau, gonugau wanib Kristus peimai, petak na noumamam.” ");
INSERT INTO bmh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Guzenaimai, Uwait nugau Wes nug du go palautendai, Nou zaueim sieun. Yesus nugau memeg anag dual agal mogoi imai aimai, Nou zaueim getal agal asanagar agen guzenanem sul guzenai siemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Simeon nug Yesus Maria ebeg ebuan oimai, Uwait nugau wanib wag guzenai ulagwag moroun. Go eneun, “Banou, ulis nait salau du utilemen, oiab selanau mui noumanai. Izal oiab selanau damau. Getal na iz baib milemen, ulis petak zou. ");
INSERT INTO bmh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Izal ame nug na ig imaigabun baib memen usaleun pem. ");
INSERT INTO bmh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Na e duailel amiagab e baib suban maremen pem. ");
INSERT INTO bmh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Go mogoi gonug, gonugau al tub em ebuan dudu ebalagab al maramau. Gonug nait Israel duailel agal wanimag banou maramau.” ");
INSERT INTO bmh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Zosep Maria dual Simeon nug ze awareun go doimai, esilakaimai, dabeleu asiu omen. ");
INSERT INTO bmh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon nug suban dabun ze awaraimai, Yesus nugau anag Maria guzenai aureun, “Na e don, e mogoi go Israel duailel asiu agen gonugau ze i sesamoramam, agen go eg muramamen. Duailel asiu agen gonugau ze sesamoramam, gonug ag kolital igaramau. Mogoi go Uwait nugau ziwas zuabun eun, duailel asiu agen gonugau wanib ebu ze eg muramam. ");
INSERT INTO bmh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Guzenaimai, duailel agal dabeleu araog usalamau. Aiu ses na ounab eg wai mamau, go siag tub sulai nait waunag kuatamau.” ");
INSERT INTO bmh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ziwas go ebu, Uwait nugau ze doimai, awaraneun air tub, go gue Nou zaueim daneun. Gonugau wanib Ana. Go du tub gonugau wanib Panuel nugau ainag, go Asa nugau zaug. Go ureg meun. Getal go du oun ebu, wai kwali sag gonugau gamu dual daremen. ");
INSERT INTO bmh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Dai, dai, gonugau gamu noumeun, go du tamacag gaul dareun. Gonugau wai 84 sag. Go Nou zau banou oug Uwait ulagwag murabun i utaneu, go umkoskos sianeu. Go ee urmaimai, Uwait aurai daneu. Go Uwait nugau salau umaum amban mui macaneu. ");
INSERT INTO bmh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ziwas go ebu, go Uwait ulagwag murabun sieun. Gonug Zerusalem uzanan duailel gotulemen ebu go mogoi nugau ze kolital duailel imarabun go gumei daremen awareun. ");
INSERT INTO bmh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ag go igul Uwait nugau kasai ze eim aneun unum guzenaimai, kolital Galili agaig, Nasaret uzan bitemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yesus go gusig mui go banou maimai, gonugau dabeleu asiu mui. Uwait nug gonugau ougab naliu mui go umkoskos isanoroun. ");
INSERT INTO bmh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesus nugau memeg anag dual wai tutak tutak ebu, Zerusalem uzan zobu tub wanib Pasowa, go ulagwag murabun bitanem. ");
INSERT INTO bmh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesus gonugau wai begurug sag usalina, gonugau memeg anag dual ereg zobu piabun bitanem guzenaital Zerusalem uzan ereg wanemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Go zobu wanib Pasowa. Go zobu maziaimai, go kolital Nasaret uzan alemen. Yesus go mogoi magun. Go Zerusalem uzan dareun. Gonugau memeg anag dual ereg Yesus Nou zaueim dareun ag go i abiu. ");
INSERT INTO bmh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Goagal dabeleu enemen, Yesus go ipal duailel abai ereg waneu aimai, utei wanemen. Go gil betemen ebu, go Yesus piab tam. Guzenaimai, memeg anag dual go beteimai, Yesus nugau zaugul daremen wag itanai bitemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Go Yesus itanemen, itanemen. Piab tam gonun, kolital Zerusalem uzan itanai bitemen. ");
INSERT INTO bmh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Zaug dual go itanai betei, gil ianai ainarai ebu, mogoi go Uwait nugau ecesab muranemen zau banou zaueim betei dareun pemen. Go kasai ze tapaimaranemen dudu banban abai ereg ula hoboi dareun. Go betei hoboi daimai, go dudu zeze mina, doi daimai, gonug kolital zeze kanabarai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Go dudu gonugau ze doimai, go esilakemen. Gonugau igul naliu, gonun, gonug ze kolital awareun. ");
INSERT INTO bmh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Gonugau memeg anag dual go Nou zaueim dareun betei uligaimai, esilakinar. Anag nug gonugau mogoi aureun, “Izal mogoi, na einen ig guzenai igul migem? Ig memen dual na en oigeb uhu mina, ig na itanize gil huia ai daremun.” ");
INSERT INTO bmh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus nug kolital awareun, “Ag einen iz itanile aidaremen? Ag go i abiu, iz izal mekai nugau zaueim darem” ");
INSERT INTO bmh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bo, memeg anag dual go ze zebigeg gonug awareun ag go i abiu. ");
INSERT INTO bmh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Guzenaimai, go kolital gonugau memeg anag dual Nasaret uzan sesamarai beteun. Memeg anag dual agen Yesus ein salau ze auranemen unum sesamoraneu. Gonugau anag nug go ze unum gonugau ougab oug mai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus go dabeleu naliu mui ban meun. Uwait mui, duailel mui, go go uligaimai, goagal oiagab oug hemen. ");
INSERT INTO bmh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ziwas go ebu, em ebuan du banou Sisar-Taibirias go em go wai 15 sag gumeun. Pontias-Pailot go Zudia agaig gumaraneu du. Herot-Antipas go Galili agaig gumaraneu du, gonugau apag Pilip go Ituria mui Trakonitis agaig han gumaraneu du. Laisenias go Abilena agaig gumaraneu du. ");
INSERT INTO bmh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas zaug Kaiapas dual, go Uwait ula danemen dudu banban pet. Ziwas go ebu, Zon, Sekaraias nugau mogoi du tamacag uzan em ula ebu darendai, Uwait nugau ze go ebu aleun. ");
INSERT INTO bmh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Guzenaimai, Zon nug Zordan Ze gasag go em ebu unum betei awaraimai, Uwait nugau ze duailel maraimai, awareun, “Agal oiagab kekulaiban, agal igul eg semoroiban, alebiag, izan ze ziwaremin, Uwait nug agal igul eg zilagai maramau.” ");
INSERT INTO bmh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","E ze getal du tub Uwait nugau ze doimai, awaraneun du Aisaia nug gonugau agau ebu guzenai sikut weun, “Du tub go du tamacag uzan em ula ebu ulai dareu, ‘Dubanou Ban nugau abu suban kalai moron. Gonugau abu tuguiai moron. ");
INSERT INTO bmh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Go manam dareu em unum suban solai mamau. Go abu iluai dareu, tuguiai kalan. ");
INSERT INTO bmh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Duailel ag abe mamamen, go Uwait nug agal igul eg zilagai maraimai, imaigabun alamau, pimamen.’” ");
INSERT INTO bmh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Guzenaimai, duailel asiu Zon nug ze ziwarabun alina, Zon nug awareun, “Ag man nugau ug sul, agal igul eg pet. Uwait ag wagarabun alamau ziwas ebu, ag erunai uminai unamamen? ");
INSERT INTO bmh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ag agal igul eg semoroiban, agal oiagab kekulan. Go ipal dudu abe mamam agal igul eg ebuan kolital kekulemen. Ag agal dabeleu guzenai i oiban, enan, ‘Abraham go igual asanig. Guzenaimai, Uwait nug ig isanigaba, ig suban damam.’ Uwait go e aiwag ulis oimai, Abraham nugau zaugul patai mabun iboi. ");
INSERT INTO bmh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Uwait nugau ebeg sil sapol pataimai, a dulu ebu mai dareu. A dab tub useg naliu i mamau, Uwait nug sapol go oimai, a useg naliu i mamau kuataimai, ab unig oug amaciba, elamau.” Zon nug guzenai awareun. ");
INSERT INTO bmh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Guzenaimai, duailel agen kolital kanaboromen, “Ig erunaimai, suban damam?” ");
INSERT INTO bmh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Zon nug koli awareun, “Inen duair go iweiu aliag mui damau, tub oimai, du tub go iweiu tamacag du muramau. In du go ee asiu mui, go guzental guzenamau.” ");
INSERT INTO bmh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ipal aiwag wanemen dudu, go ze ziwabun en alaimai, Zon kanaboromen, “Du banou, ig erunamam?” ");
INSERT INTO bmh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Zon nug kolital awareun, “Agal gumaraneu du nug aiwag wabun awareun guzenaital on. Ag polumaimai, duailel agal aiwag asiu gaul i zob on.” ");
INSERT INTO bmh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ipal malai dudu agen mui alaimai, go kanaboromen, “Ig erunamam?” Gonug kolital awareun, “Ag ipal dudu gaul waganemen, ze polumaraimai, goagal aiwag i zob on. Ag agal salau ebuan aiwag tutak on.” ");
INSERT INTO bmh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Duailel goagal oiagab oug dabeleu asiu oimai, enemen, “Zon go du go Kristus ta, go tam ta?” ");
INSERT INTO bmh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Guzenaimai, Zon nug duailel unum awareun, “Iz ag petak ze sil ze ziwaranem. Du tub ses alai dareu, gonugau gusig izal gusig zilaoramau. Iz du naliu tam, gonun, iz gonugau arab ebuan arab galau oi abun iborain tam. Gonug ag Uwait nugau Ah Wes ab sil ze ziwaramau. ");
INSERT INTO bmh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Go savol ebeg nug patai dareu, go savol sil wit epelaba, wag maba, wol nug go wit sog utaba, wit useg oimai, gonugau zaueim gotulai mamau, sog beu oimai, ab i noumaneun ebu agamau.” ");
INSERT INTO bmh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zon nug Uwait nugau ze mui ipal ze naliu asiu duailel oiagab kekulabun en mui awareun. ");
INSERT INTO bmh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Duailel unum Zon nug ze ziwarina, daren daren, Yesus go han, Zon nug ze zioreun. Yesus ze ziwaimai, go Uwait aurina aurina, Mesgai im oiteun. Oitina, Mesgai wag eiman Uwait nugau Ah Wes meg kurumuk sul go ebu alaimai, tabaugab noun. Mesgai wag eiman du tub nugau zeu sul eneun, “Na izal mogoi pet. Izal oiab nug na en noumaneu. Izal oiab na en naliu pet usaleu.” Dai dai, Zon nug Herot, Galili agal gumaraneun du banou, duailel amiagab iwai ze aureun. Einen, go gonugau amag nugau air wanib Herodias, Pilip nugau air oun, mui ipal igul eg meun aureun. Aurina, Herot nug aigsisilaimai, igul eg pet maimai, Zon hiacaranem zau oug heun. ");
INSERT INTO bmh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus go wai 30 ban maimai, salau bigegweun. Duailel agal dabeleu eim enai ze memen Yesus go Zosep nugau mogoi, emen. Zosep go Eli nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli go Matat nugau nag, Matat go Liwai nugau nag, Liwai go Melki nugau nag, Melki go Zamoi nugau nag, Zamoi go Zosep nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zosep go Matatias nugau nag, Matatias go Emos nugau nag, Emos go Naum nugau nag, Naum go Esli nugau nag, Esli go Nagai nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai go Mat nugau nag, Mat go Matatias nugau nag, Matatias go Semen nugau nag, Semen go Zosek nugau nag, Zosek go Zoda nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda go Zoanan nugau nag, Zoanan go Resa nugau nag, Resa go Serubabel nugau nag, Serubabel go Sealtiel nugau nag, Sealtiel go Neri nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri go Melki nugau nag, Melki go Adi nugau nag, Adi go Kosam nugau nag, Kosam go Elmadam nugau nag, Elmadam go Er nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er go Zosua nugau nag, Zosua go Eliesa nugau nag, Eliesa go Zorim nugau nag, Zorim go Matat nugau nag, Matat go Liwai nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai go Simeon nugau nag, Simeon go Zuda nugau nag, Zuda go Zosep nugau nag, Zosep go Zonam nugau nag, Zonam go Eliakim nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim go Melea nugau nag, Melea go Mena nugau nag, Mena go Matata nugau nag, Matata go Natan nugau nag, Natan go Devit nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit go Zesi nugau nag, Zesi go Obet nugau nag, Obet go Boas nugau nag, Boas go Salmon nugau nag, Salmon go Nason nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason go Aminarap nugau nag, Aminarap go Atmin nugau nag, Atmin go Hesron nugau nag, Hesron go Peres nugau nag, Peres go Zuda nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zuda go Zekob nugau nag, Zekob go Aisak nugau nag, Aisak go Abraham nugau nag, Abraham go Tera nugau nag, Tera go Nahor nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor go Seruk nugau nag, Seruk go Reu nugau nag, Reu go Pelek nugau nag, Pelek go Eber nugau nag, Eber go Sela nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela go Kainan nugau nag, Kainan go Arpaksat nugau nag, Arpaksat go Sem nugau nag, Sem go Noa nugau nag, Noa go Lamek nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek go Metusela nugau nag, Metusela go Enok nugau nag, Enok go Zaret nugau nag, Zaret go Makalalel nugau nag, Makalalel go Kenan nugau nag, ");
INSERT INTO bmh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan go Enos nugau nag, Enos go Set nugau nag, Set go Adam nugau nag, Adam go Uwait nugau nag. ");
INSERT INTO bmh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus go Zon nug ze ziorena, Zordan Ze eiman Ah Wes mui gasag zondai, Ah Wes nug go du tamacag uzan em ula ebu imai, beteun. ");
INSERT INTO bmh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Go du tamacag uzan em ula ebu, gil 40 go ee tamacag dareun daren daren, Satan nug Yesus bimag peun. Ziwas go ebu go ee tub zab tam. Go we banou weun. ");
INSERT INTO bmh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan go Yesus dareun ebu zoimai, aureun, “Na, Uwait nugau Nag aba, na aiwag e auremen, bret kekulaba, zen.” ");
INSERT INTO bmh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus nug kolital Satan aureun, “‘Uwait nugau ze eim eneu, ‘Du bret sag zaimai, awau i damau.’” ");
INSERT INTO bmh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","7","Guzenaimai, Satan nug kolital Yesus imai aimai, em baru ebu wag imai simai, em unum abai moroimai, aureun, “Na iz ulapwag milemen, na e em ebuan gusig mui, e em han, go ece naliu unum na mizai. Na iz ulapwag milemen, e em Uwait nug iz mileun na uligem, ulis izan go unum na mizai.” ");
INSERT INTO bmh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesus nug kolital Satan aureun, “Uwait nugau ze eneu, ‘Na nait Banou tutak ulagwag moren. Na Uwait nugau salau tutak muramam.’” ");
INSERT INTO bmh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Guzenaimai, Satan nug kolital Yesus imai aimai, Zerusalem Nou zau banou wag simai maimai, aureun, “Ke, na Uwait nugau Nag aba, nagaces go eiman kuanai nonen. ");
INSERT INTO bmh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Uwait nugau ze eim eneu, ‘Uwait nug gonugau tibur na en awaraba, na iau imaiz numam. ");
INSERT INTO bmh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Go agen nait eben tubaim tubaim patizaimai, ibaiz numam. Guzenebiag aiwag tub nug na aram i wamau.’” ");
INSERT INTO bmh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus nug kolital aureun, “Go don, Uwait nugau ze eim eneu, ‘Na nait Banou, Uwait i bimag pen.’” ");
INSERT INTO bmh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Guzenaimai, Satan go Yesus utei waneun. Unum utei unab tam, go aiu ses Yesus kolital bimag piabun gumei dareun. ");
INSERT INTO bmh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Guzenaimai, Yesus go Uwait nugau Ah Wes gusig ban mui Galili agaig koli beteun. Duailel gonugau salau meun ze awarina, unum em unum donar. ");
INSERT INTO bmh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Go umkoskos duailel agal gotulanemen zaueim Uwait nugau ze awarina, duailel unum gonugau ze doimai, Yesus nugau wanib wag muranem. ");
INSERT INTO bmh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Guzenaimai, Yesus go getal Nasaret uzan daimai ban meun, Imabun gil zobu ebu, gonugau igul guzenaneun sul, go gotulanemen zaueim sieun. Go asaimai, Uwait nugau ze duailel amiagab nanalabun beteun. ");
INSERT INTO bmh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Uwait nugau ze doimai, awaraneun du Aisaia nugau agau oi moromen. Gonug go agau olineun memen, waipaimai, sikut guzenai dareun nanalai mareun. ");
INSERT INTO bmh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Uwait nugau wes iz ibail dareu, einen, nugtal iz duailel eg wemen mui ece tamacag duailel han Uwait nugau Ze Naliupet awarabun palautilen, alemin. Ag hiacaranem zau oug danemen dudu ag hiacaranem zau oug ute, alian. Ag ameag tapeleun dudu ag ulis suban abu pian. Uwait nugtal iz palautilen, dudu salau eg mai daremen kolital imarabun, alemin. ");
INSERT INTO bmh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ziwas go ebu Uwait Banou nug gonugau duailel igul eg ebuan imarabun zou.” ");
INSERT INTO bmh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Guzenai nanalaimai, koli go agau olinaimai, gumaneun du moroimai, go betei hoboun. Go gotulai daremen duailel unum goagal amiag nug Yesus sag uligemen. ");
INSERT INTO bmh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gonug awareun, “Ag ulis doi darena, iz e ze nanalai marem domen. Go ze ulis petak zou.” ");
INSERT INTO bmh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Duailel go Yesus ogusau ebuan ze naliu doimai, gonugau wanib wag moroimai, go ze naliu awareun, dabeleu asiu omen. Guzenaimai, agzozou zemenar, “Go Zosep nag ta?” ");
INSERT INTO bmh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesus nug kolital awareun, “Petak pet, ag iz go ze guzenai ailamamen, ‘Na ebeu kasaranem du, na nagtal koli nait enim suban kasen.’ Ag iz guzenai ailamamen. ‘Go igul Kapaneam uzan igul ata atai guzenemen sul, go ig domun sul nait uzan guzenaital guzenen.’ ");
INSERT INTO bmh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iz ag petak pet awarem, duailel go Uwait nugau ze doimai, awaraneun du gonugau uzan ebu gonugau ze i duanem. ");
INSERT INTO bmh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ag suban don, getal Israel agal em ebu, Elaiza dareun ziwas ebu, ipal wab ailel asiu daremen. Ziwas go ebu wai ainarai geil wasolig ze tub emes wageiman nuab tam, go ziwas ebu we ziwas banou em unum iboreun. ");
INSERT INTO bmh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Guzenaimai, Uwait nug Elaiza Israel air tub ebu palautab tam, go Elaiza uzan tub wanib Sarepat, Saidon em go ebu, wab air tub dareun ebu palautoroun. ");
INSERT INTO bmh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Guzenaimai, go ziwas ebu Uwait nugau ze doimai, awaraneun du Elisa dareun ebu, Israel duailel asiu go ebeu leprosi mui eg mareun daremen, go du tub naliu mab tam. Neaman go tutak, Siria agaig ebuan du tutak suban meun.” Yesus nug guzenai awareun. ");
INSERT INTO bmh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Duailel go unum gotulai daremen, go ze go doimai, aiag sisileun. ");
INSERT INTO bmh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Goagen asaimai, Yesus suebi, uzan eiman em anegwa ebu gelez nuabun suoroi betemen. Go uzan tub em manam waugab imai betemen. Go eiman suebi, gelez nuabun aimai, imai betemen. ");
INSERT INTO bmh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Goagen go guzenina, gonug goagal unig oug zilaraimai, waneun. Goagen go uligemen, go gusig mui, gonun, gaul pei darena, waneun. ");
INSERT INTO bmh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesus Galili agaig Kapaneam uzan betei dareun. Zobu tub ebu, go gonun duailel Uwait nugau ze go ebu marai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Gonun duailel gonugau ze doimai, esilakinar. Einen, go du tub wanib mui guzenai ze awarendai, donar. ");
INSERT INTO bmh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Gotulanemen zau, gonun, du tub go wes egonou ougab dareun. Go banban pie aimai, eneun, “Nasaret uzanan Yesus, na ig erunigabun alem? Na ig eg migabun alem ta? Iz na en abiu, na du naliupet tuguianau pet Uwait nug eiman alemen.” ");
INSERT INTO bmh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesus nug wes eg gusig ze aureun, “Na soen, du go utei, alien.” Wes eg go du go ougab oug dareun, utei unabun aimai, duailel amiagab du gue em ebu amaicaimai, go eg murab tam, gaul utei unar. ");
INSERT INTO bmh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Duailel ag go igul meun uligaimai, esilakaimai, agzozou guzenai zeminar, “Go ein ze? Go du gonugau gusig em ebuan wes eg asiu gusig ze awarendai, go gonugau ze doimai, dudu agal oiagab dacanemen utarai unanem.” ");
INSERT INTO bmh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Guzenaimai, Yesus nugau salau meun ze em unum iboreun. ");
INSERT INTO bmh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus go duailel abai agal gotulanemen zaueim daremen utaraimai, du tub Saimon nugau zau beteun. Saimon nugau tanau air go ebeu enib zabeg mui, gabuai dareun. Duailel go Yesus air go kasurabun auremen. ");
INSERT INTO bmh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus nug Saimon nugau tanau air ebeu mui gabuai dareun waugab simai tapai daimai, go ebeu gusig ze aureun. Aurina, go ebeu pigai utei waneun. Air ebeu go uteimai waneun, air go gue asaimai, ipal dudu agal ee mis maimai, gumarai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Am nondai, dudu goagal zaiagar ebeu eg mui Yesus waugab imarai alina, Yesus nug ebeg sil ebeu dudu tutak tutak goagal gagaliag ebu minarai, agal ebeu eg kasarena, naliu memen. ");
INSERT INTO bmh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wes eg go ebeu dudu asiu ebalagab danemen, go unum utei wanemen. Wes eg go agen pieaimai, enemen, “Petak, na Uwait nugau Nag.” Yesus nugau gusig ze nug wes eg agal oiagsau tapelai maren, goagen koli aurabun iborain tam. Einen, go abiu Yesus go Uwait nugau Nag. ");
INSERT INTO bmh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Umaseu pet, Yesus dareun uzan uteimai, uzan tub du zepag tamacag ebu beteun. Duailel ag go itanemen. Itanai betei uligaimai, go go waugab betemen. Go go waugab beteimai, goagen go utebi, unabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gonug kolital awareun, “Iz ipal uzan Uwait nugau ze betei abai marai. Go bigegun Uwait nug iz palautilen, alemin.” ");
INSERT INTO bmh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Guzenaimai, Zudia agaig gotulanemen zaueim unum, Uwait nugau ze betei abaimareun. ");
INSERT INTO bmh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gil tub ebu, Yesus go Galili Ze Unig, (go ze unig gonugau wanib tub Genesaret) go go ze gasag tapai darena, duailel go Uwait nugau ze marena, duabun, Yesus susuorona, go holoi holoi ze gasag beteun. ");
INSERT INTO bmh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesus go tebil aliag go ze gasag us nogoug ebu daremen uligeun. Go tebil atag dudu go tebil wageiman nuanaimai, goagal karuk wanemen zo ulusai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesus nug Saimon nugau tebil wag simai, Saimon aureun, tebil ze unig ebu suoraba, betabun aureun. Guzenaimai, go gue tebil go eiman simai hoboimai, duailel Uwait nugau ze marai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesus nug duailel Uwait nugau ze marai daimai, Saimon aureun, “Tebil ze unig ban ula oi beteiban, nait zaunar abai koli karuk wanemen zo amahaimai, karuk umamen.” ");
INSERT INTO bmh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon nug Yesus kolital aureun, “Dubanou Ban, ulis umaum ig karuk wanemen zo hemun hemun, ig karuk ginam tub wab tam. Ulis na anem, gonun, iz kolital hiai.” ");
INSERT INTO bmh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yesus nugau ze sesamorai, goagal karuk wanemen zo hina, nuna, karuk asiu go zo oug kameun, wabun iborain tam, agal zo bigag amoroi eun. ");
INSERT INTO bmh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Guzenina, goagen zaiagar tebil tub ebu daremen ularena, alemen. Go zo karuk asiu mui patai keuina, go tebil aliag ebu karuk asiu pet usaleun, karuk agal uhu nug go tebil ze unig oug nuamoroi eun. ");
INSERT INTO bmh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Saimon-Pita go karuk go uligaimai, banban umineun. Gonug go igul uligaimai, go Yesus waugab zoimai, taubibiaimai, Yesus aureun, “Dubanou Ban, na iz utilai, alien. Einen, iz igul eg manem du.” Gonugau zaugul ereg daremen, go mui ereg go igul uligaimai, banban uminemen. ");
INSERT INTO bmh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedi nugau gelegul aliag, Zems zaug Zon dual, go Saimon dual ereg aidanemen, go igul uligaimai, esilakinar. Yesus nug Saimon-Pita aureun, “Na umin ien, na e karuk ulis om sul, aiu ses na duailel guzenai imaramam.” ");
INSERT INTO bmh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Guzenaimai, go goagal tebil go ze gasag oi betei maimai, go ecesab unum uteimai, go Yesus sesamorai wanemen. ");
INSERT INTO bmh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ziwas tub ebu, Yesus go ban uzan tub beteun. Go uzan du tub ebeu eg leprosi mui dareun. Go du go alai Yesus peimai, taubibiaimai, Yesus aureun, “Dubanou Ban, na izal sui eg oiai milabun iboin, bo, nait dabeleu eiman guzenen. Na iz kasilemen, iz naliu manai.” ");
INSERT INTO bmh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus nug bisou peimai, du gonugau gagalig pataimai, aureun, “Izan aizem, na naliu mamam.” Ziwas go ebutal, du gonugau leprosi sug unar. ");
INSERT INTO bmh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesus nug du go gusig ze aureun, “Iz e igul guzenem na betei ipal duailel i awaren. Bo, na Uwait ula dacaneun du waugab beteimai, nait enim naliu usaleun abai moromen, peizamau. Peizaba, na Moses nugau kasai ze sesamoraiba, egun oimai, Uwait ulagwag moromen, go petak duailel unum abiu mamam, na koli naliu usalemen. ");
INSERT INTO bmh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Du go Yesus nug ze aureun sesamorab tam, go beteimai, duailel unum awareun. Duailel asiu go ze go doimai, go Yesus gonugau ze duabun mui, agal ebeu kasarabun han, alemen. ");
INSERT INTO bmh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesus nug Uwait aurabun go em duailel i dacanemen ebu beteimai, Uwait auraneu. ");
INSERT INTO bmh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gil tub ebu, Yesus go Uwait nugau ze duailel marena marena, Parisi dudu banban ipal mui kasai ze tapaimaranemen dudu mui, go unum Galili agaig ebuan mui, Zudia agaig ebuan han, Zerusalem ban uzanan mui ereg alaimai, go go ebu hoboi daremen. Banou nugau gusig Yesus ebu dareun, go duailel ebeu mui, kasarabun iboin. ");
INSERT INTO bmh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Guzenendai, ipal dudu agen du tub biz ebu maimai, Yesus waugab gamacaimai alemen. Go du gonugau enib unum noumeun, go usai unabun iborain tam. Go du go gamacaimai, Yesus zaueim dareun ebu waugab si maporoi. ");
INSERT INTO bmh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Zaueim duailel asiu darena, go zau og eiman siabun iborain tam. Guzenaimai, dudu goagen zau zag pazawa wag simai, go zau zag bigacaimai, go wageiman ebeu du go Yesus tapai dareun ebu waugab mina, noun. ");
INSERT INTO bmh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus nug agal oiagab petak emen uligaimai, go ebeu du go aureun, “Zai, nait igul eg zilagai mizem.” ");
INSERT INTO bmh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Go Parisi dudu mui kasai ze tapaimaranemen dudu han agzozou dabilemenin, “E ein igul? E ein du nug Uwait nugau pip ou? Em ebuan du tub nug go igul eg zilagai abun iborain tam. Uwait nugtal petak go igul eg zilagai marabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesus goagal dabeleu oiagab oug abiu maimai, awareun, “Ag agal oiagab oug einen go dabeleu oi daremen? ");
INSERT INTO bmh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Iz ein ze mabun iboin, ein ze mabun iborain tam? ‘Nait igul eg zilagai mizem,’ iz guzenai zemai ta, ‘Na asaimai, unamam,’ iz guzenai zemai ta? Iz ein ze zemai, ag agal oiagab iz en petak amamen? ");
INSERT INTO bmh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bo, ag Du Nugau Nag go wanib mui, go e em ebuan igul eg zilagabun iboin abiu mabun iz guzenai.” Guzenaimai, gonug go du gonugau ebeg arab noumeun aureun, “Izan aizem, na asaimai, nait biz oiba, nait uzan alien!” ");
INSERT INTO bmh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yesus nug du go guzenai aurina, go pigai asaimai, duailel unum gotulai daremen amiagab go gonugau biz oimai, Uwait ulagwag moroimai, gonugau uzan unar. ");
INSERT INTO bmh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Go wanena, go duailel go unum esilakaimai, uminaimai, go Uwait nugau wanib wag maimai, enemen, “Ig ulis igul tub atai uligem.” ");
INSERT INTO bmh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Go igul guzenaimai, Yesus go beteimai, du tub wanib Liwai go duailel agal takis aiwag waneun, gonugau salau pataneun zaueim hoboi darena, uligeun. Yesus nug Liwai aureun, “Na alai, iz sesamilen.” ");
INSERT INTO bmh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Guzenai aurina, Liwai asaimai, esab unum uteimai, Yesus sesamorai unar. ");
INSERT INTO bmh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ziwas tub ebu, Liwai go Yesus dual gonugau zaueim beteimai, ee zai daremen. Gonugau zaueim gonugau salau zaugul mui ipal dudu abai mui gotulaimai, Yesus dual ee zemen. ");
INSERT INTO bmh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ipal Parisi dudu mui kasai ze tapaimaranemen dudu goagen ze asiu maimai, Yesus nugau tapaimaraneun dudu kanabaremen, “Ag einen aiwag wanemen dudu mui dudu igul eg macanemen abai ereg ee zemen?” ");
INSERT INTO bmh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus go ze doimai, go nug kolital awareun, “Dudu go ebeu tamacag, go ebeu kasaraneun du waugab i bitanemen. Du in go ebeu a sag go ebeu kasaraneun du waugab bitaneu. ");
INSERT INTO bmh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Guzenai sul, iz duailel igul naliu macanemen ularabun alab tam. Iz duailel igul eg macanemen goagal oiagab ailabun alemin.” ");
INSERT INTO bmh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dudu ipal agen Yesus kanaboromen, “Zon nugau tapaimaraneun dudu go umtabag ee i zanem. Go ebu Uwait sag aurai dacanem. Parisi agal tapaimaranemen dudu, mui go guzental guzenanem. Bo, nait tapaimaranemen dudu go ee mui ze mui asiu zanem. Go einen guzenanemen?” ");
INSERT INTO bmh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus nug kolital awareun, “Air tub du wabun ziwas ebu, du daba, gonugau zaugul alai dabiag, ee ur maneu ta? Iz petak awarem, Go igul i guzenamau. ");
INSERT INTO bmh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bo, aiu ses go du air wabun, go dudu ipal agen go ebalagab imai wanebiag, go petak go ziwas ebu, go ee ur mamam.” ");
INSERT INTO bmh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Guzenaimai, go nug tub tatau ze awareun, “Du tub nug gonugau tibur galau muz bigagaba, go gonugau tibur galau awau ebuan tibur galau zig ginampet kuataimai, muz ebu i sopuai macaneu. Du tub nug go igul guzenamau, gonugau tibur galau awau egwaimai, go tibur galau zig awau ginampet, tibur galau muz dual naliu i usalamau. ");
INSERT INTO bmh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Du tub nug wain ze awau meme galau muz ebu i goriai mahaneu. Go guzenamau, wain ze awau go siwalkuk aimai, muz meme galau bigagaimai, wain ze em ebu esikai numau. Meme galau go mui zilagamau. ");
INSERT INTO bmh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wain ze awau go meme galau awau ebu goriai memen, naliupet damau. ");
INSERT INTO bmh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Du tub go wain ze muzin zaneu, go awau utaneu. Go enanem, ‘Muzin go naliupet.’” ");
INSERT INTO bmh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ginam Zobu tub Imanem Ziwas ebu, Yesus go gonugau tapaimaraneu dudu abai ereg, wit wai ula eiman betemen. Gonugau tapaimaraneu dudu agen wit dab oimai, ugaimai, zai zai betemen. ");
INSERT INTO bmh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisi dudu ipal agen uligaraimai, enemen, “Ag einen Imabun Ziwas ebu salau memen? Go ag Moses nugau kasai ze eg wai memen.” ");
INSERT INTO bmh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus nug kolital awareun, “Ag Devit gonugau alalanemen dudu abai ereg we wagarina, Uwait ulagwag macanemen ebuan bret zemen, ag abiu ta, ag go i abiu? ");
INSERT INTO bmh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Go Uwait nugau zaueim simai, go bret Uwait ulagwag muranemen biz ebu dareun oimai, gonugau dudu abai ereg zemen. Go gaul dudu agen zabun iboin tam. Uwait ula danemen dudu agen sag zanemen. Bo, Devit nug gonugau dudu abai ereg zemen. Ag go sikut nanalab tam ta?” ");
INSERT INTO bmh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Guzenaimai, Yesus nug awareun, “Du Nugau Nag, nugtal go imabun ziwas gumaneu, go ein igul guzenabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ginam Zobu Imabun Ziwas tub ebu, Yesus go gotulanemen zaueim simai, Uwait nugau ze duailel marai dareun. Du tub gonugau ebeg tubaim noumeun mui go gue gotulanemen zaueim dareun. ");
INSERT INTO bmh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Darena, ipal Parisi dudu mui kasai ze tapaimaranemen dudu abai ereg Yesus enibwag ze mabun go du kasaba, piabun en gumei daremen. ");
INSERT INTO bmh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesus go dudu goagal dabeleu abiu maimai, go ebeg noumeun du aureun, “Na usaiba, duailel amiagab alen” Go du usaimai, duailel amiagab alai tapai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Guzenina, Yesus nug Parisi dudu awareun, “Iz ag en kanabem, igual kasai ze nug Imabun Ziwas ebu igul naliu mabun emen ta, igul eg marabun emen? Du tub kasurai ta, eg murai?” ");
INSERT INTO bmh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Guzenaimai, Yesus nug duailel unum uliag araimai, du go aureun, “Nait eben henen.” Du go aureun sul guzenina, gonugau ebeg naliu kolital getal naliu dareun sul usaleun. ");
INSERT INTO bmh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bo, Yesus nug go guzenina, uligaimai, dudu banban go aiag sisil ina, agzozou Yesus webiag, noumabun ze patemen. ");
INSERT INTO bmh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ziwas tub ebu, umaum Yesus go Uwait aurabun manam ebu simai Uwait aurai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Umaseu, gonugau tapaimaraneun dudu ularena, alina, dudu begurug sag egareun. Guzenai egaraimai, Uwait nugau ze emgasag oi aidabun dudu wanimag mareun. ");
INSERT INTO bmh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Dudu go egareun, goagal wanimag gue: Saimon (Yesus nug go wanib tub Pita meun), gonugau amagul Andru, Zems, gonugau amag Zon mui, Pilip, Bartolomiu, Matiu, Tomas, tub Zems (Alpius nugau nag), tub Saimon (go ug tub wanib Serot ebuan), Zudas (Zems nugau nag), tub Zudas Iskariot gonug Yesus gonugau iwai zaugul agal ebeagab mareun. ");
INSERT INTO bmh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Yesus gonugau ze oi aidabun dudu egaraimai, go noi, em urun ebu gonugau tapaimaraneun duailel asiu abai ereg ipal duailel asiu, Zudia agaig ebuan mui, Zerusalem uzanan mui, Tair uzanan han, Saidon uzanan mui, go em unum gonun alai gotulai daremen ebu noun. Go duailel go gonugau ze duabun alemen, ipal duailel ebeu eg mui, wes eg mui unum Yesus nug kasareun. ");
INSERT INTO bmh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Duailel goagen gonugau tibur galau pataimai, naliu usalanem. Gonugau gusig go eiman beteimai, duailel ebeu mui naliu usalanem. ");
INSERT INTO bmh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus nug gonugau tapaimaraneun dudu uligaraimai, awareun, “Inen duailel ag abiu agtal agal doropag gusig mab tam, agtal igul naliupet mab tam, ag oiagab naliupet damamen. Uwait nug ag gumaraneu. ");
INSERT INTO bmh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ei, ag go don, inen duailel ag Uwait nugau igul naliupet wabun salau gusig macanemen ag oiagab naliupet damamen. Einen, Uwait agal salau memen uligaimai, isanaramau. Ei, ag go don, ulis ag weinai daremen, ag agal oiagab naliu usalai dareu. Aiu ses ag siksikamamen. ");
INSERT INTO bmh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aiu ses, ag Du Nugau Nag sesamorai aidaremen, duailel agen ag en aiagsisilaimai, agal wanimag eg wai mamam, go guzenebi, ag agal oiagab naliu usalamau. ");
INSERT INTO bmh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Go igul ag ebalagab guzenebi, ag oiagab eg i umau, oiagab naliu maimai, siksikamamen. Einen, ag go igul guzenamamen, Uwait nug ece ipal naliupet usalai mareun Mesgai wag dareu aiu ses umamen. Getal agal embigeg Uwait nugau ze doimai, awaranemen dudu go igul eg go ebalagab guzenaital guzenemen.” ");
INSERT INTO bmh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yesus nug kolital eneun, “Ag duailel ag ulis esab asiu mui, ag ulis suban siksik an, aiu ses ag tamacag damamen. ");
INSERT INTO bmh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ag duailel ag ulis ee asiu zemen, biguiag zuaneu, aiu ses ag we ugaramau. Ag duailel ag ulis siksikaimai daremen, aiu ses ag oiagab weinai mui damamen. ");
INSERT INTO bmh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ag ulis suban daremen. Dudu ipal go Uwait nugau ze doimai, awaranemen dudu darem anem. Go polu ze maranem. Bo, agal embigeg agen agal ze petak aimai dabilaimai, goagal wanimag wag maranemen. Ulis, duailel agen agal wanimag wag macanem, go naliu tam. Ag bisomagar, aiu ses ag uhu banou umamen.” ");
INSERT INTO bmh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesus nug kolital eneun, “Ag go don, agal iwai zaiagar abai i iwaiman. Duailel agen agal enimag ebu polu ze mebiag, agen igul naliu go duailel ebalagab mamamen. ");
INSERT INTO bmh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ag go dudu agen ag eg marabun aidanem, agen suban dabun ze awaran. Ag go dudu agen ag eg marabun aidabi, agen Uwait auran, Uwait nug go dudu isanaramau. ");
INSERT INTO bmh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bo, du tub nug nait siben naliu eiman waba, koli kekulemen, siben nanaceiman moromena, wamau. Du tub nug nait tibur galau wagan uba, na galinien. Utemen, nait tibur galau tub mui umau. ");
INSERT INTO bmh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Du tub nug nait esab wabun aba, na i galinen. Na go moren. Du tub nug nait esab oi unaba, koli mizabun i auren. ");
INSERT INTO bmh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ein igul naliu dudu ipal agen ag ebalagab mabun dabelebiag, agen go igul naliu dudu ipal ebalagab guzental guzenaramamen. ");
INSERT INTO bmh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Dudu ipal agen, ag en oiagab noumebiag, agen mui koli go dudu en sag oiagab noumamau. Guzenamamen, Uwait nug ag tub ece naliu maramau ta? Igul eg macanemen dudu mui ag guzental guzenanemen. ");
INSERT INTO bmh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ag dudu ipal igul naliu tub ag ebalagab mebiag, agen mui ag naliu gumaramamen, ein ece naliu umamen? Dudu igul eg macanemen ag mui go igul guzental guzenanemen. ");
INSERT INTO bmh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ag du tub agal ece muranemen, agal dabeleu go gue esab kolital maramau, anemen ein ece naliu Uwait nug ag maramau? Igul eg macaneu du mui go du tub esab muraneu, gonugau dabeleu, du go nug esab koli murabun en dabilaneu. ");
INSERT INTO bmh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ag go igul uteiban, agal iwai zaiagar en oigab noumaimai, suban isanaramamen. Ag igul naliu agal iwai zaiagar ebalagab macan. Ag dudu esab maraiban, kolital goagen agal esab koli marabun en i dabilan. Ag guzenamamen, aiu ses ag ece banou umamen, ag Uwait Ban nugau gelegul pet damamen. Uwait go dudu ece gaul maraneun, agen go i auranemen. Dudu naliu mui, dudu eg abai ereg, Uwait nugtal subantal gumiganeu. ");
INSERT INTO bmh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Agal memeag, Uwait nug ipal duailel en ougab siksikaneu pet, ag mui dudu ipal en oiagab siksikaba, isanaramau.” ");
INSERT INTO bmh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus nug kolital eneun, “Ag dudu ipal agal igul i sisiamamen. Ag guzenamamen, Uwait nug mui agal igul i sisiamau. Ag du tub nugau igul eg i pian. Ag guzenamamen, Uwait nug mui agal igul eg i pimau. Ag du tub nugau igul eg utebi, Uwait nug agal igul eg utei maramau. ");
INSERT INTO bmh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ag dudu ipal esab maranemen sul, Uwait nug ag esab maramau. Ag dudu esab asiu marebi, Uwait nug mui ag kolital esab asiu maramau. Gonug agal zo oug kolital esab asiu zulagaba, zo kapaba, kolital esab asiu zo oug zulagaba, agal zo kapamau. Ag esab asiu umamen. Ag dudu ipal ebalagab ein igul macanemen sultal, Uwait nug ag ebalagab mui guzental guzenamau.” ");
INSERT INTO bmh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus nug tatau ze tub awareun. “Du tub ameg tapeleun, gonug du tub ameg tapeleun zaug abu abai murabun iboin ta, tam ta? Go dudu aliag amiag tapeleun zaug zaug auramau, zaug dual eregtal ob oug alai numam. ");
INSERT INTO bmh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mogoi tub go gonugau tapaimoroun du zilaorabun iborain tam. Go aiu ses ze unum doimai, suban sesamoramau, petak go gonugau tapaimoroun du sul usalamau. ");
INSERT INTO bmh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Na einen zaun nugau ameg ebu esues ginampet oi abun uligem? Nait amen ebu a tatau dareu na piab tam ta? ");
INSERT INTO bmh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nait amen ebu a tatau banou darendai, na erunai nait zaun nugau ameg ebu esues oi abun aurem. Na polumaranemen du, amegai a tatau banou nait amen ebu dareu oi heiba, kolital naliu abu uligaimai, petak zaun nugau ameg ebu esues dareu go oi hei moren.” ");
INSERT INTO bmh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus nug awareun, “A naliu dacaneu, go dab eg i useg macaneu. A eg go dab naliu i useg macaneu. ");
INSERT INTO bmh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A unum dareu, goagal dab ata atain useg macaneu. Wain dab go gaen zabub ebu i useg macaneu. Dudu ag sabug dab ebulig ziu ebuan wanemen ta? Tam pet tam. ");
INSERT INTO bmh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Du naliu go gonugau dabeleu naliu mui go ze naliu gonugau ougab oug usalai zuna, ze macaneun. Du eg go gonugau dabeleu eg mui go ze eg macaneu. Ein dabeleu gonugau ougab oug daneu, go usalai zuna, gonugau ogusau eiman ze macaneu.” ");
INSERT INTO bmh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesus nug kolital eneun, “Ag einen, iz ‘Dubanou Ban, Dubanou Ban.’ ailanemen? Ag einen izal ze i sesamoranemen? ");
INSERT INTO bmh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ag go don! Du tub go iz waiab alaimai, izal ze doimai, sesamoraneu. Iz gonugau igul ag ebalagab abai maremin, pimamen. ");
INSERT INTO bmh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Go du izal ze doimai, sesamoraneu, go igul go enai. Du tub go zau mabun aimai, amegai ob elei noi beteimai, aiwag peimai, zau sanag gusig eun. Ze banou noimai, zewei banou noun, go zau go gusig dareun. Einen, go aiwag ebu zau sanag heun. ");
INSERT INTO bmh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Du tub go izal ze doimai, sesamorab tam, go enai, go zau us nogoug ebu zau ob eleimai, zau sanag heun, go zau gusig hiab tam. Ze banou noimai, zewei banou noun, zau go unum zewei nug oi waneun. Du go Uwait nugau ze doimai, i sesamoraneu.” ");
INSERT INTO bmh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus go Uwait nugau ze duailel unum marai poaimai, go Galili ze gasag Kapaneam uzan beteun. ");
INSERT INTO bmh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Go uzan du tub, go malai dudu agal gumaraneun du banou, nugau salau du go ebeu mui. Gonugau salau du gonugau salau ze aurina, suban sesamoraneu. Gonun, gonugau du banou go en ougab noumeun. Go du ebeu banou oimai, noumabun ina, go du banou go gonugau salau du en bisou peun. ");
INSERT INTO bmh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Guzenaimai, go du banou go Yesus Kapaneam uzan zoimai dareun ze doimai, gonug ipal Zuda agal dudu banban palautarendai, alai gonugau salau du kasabun aurabun betemen. ");
INSERT INTO bmh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dudu goagen Yesus waugab simai, ze gusig auremen, “Du gonug ig suban gumiganeu gonugau salau du noumamoroi, gonun, na beteimai, kasoren. ");
INSERT INTO bmh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Go ig Zuda duailel suban isaniganeu. Gonugtal igual gotulaimai, Uwait nugau ulagwag murabun zau mai migeun.” ");
INSERT INTO bmh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Guzenaimai, Yesus go du banou nugau salau dudu sesamarai beteun. Uzan go waugab betena, go du banou nug, Yesus ze guzenai palautai moroun, “Dubanou Ban, iz igul eg macanem du, gonun, na izal zaueim i alen. ");
INSERT INTO bmh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iz du eg, gonun, iz na wautab bitabun iborain tam. Bo, na onsau eim sag ze memen, izal salau du go naliu usalamau. ");
INSERT INTO bmh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iz mui dudu banban agal piagsal dacanem. Ipal malai dudu go izal pisal dacanemen. Izal malai du tub auranem, ‘Na e alen,’ aurina, alaneu, tub auranem, ‘Na ulib e beten,’ aurina, bitaneu. Izal salau du ‘Na e salau men,’ aimai aurina, salau macaneu.” ");
INSERT INTO bmh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus go ze go doimai, go esilakeun. Go koli kekulaimai, go duailel go sesamorai betemen awareun, “Iz petak pet awarem, iz Israel du tub e du sul gonugau ougab petak eun i pemin.” ");
INSERT INTO bmh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Go dudu goagal banou nug palautareun go koli betemen, salau du go naliu usaleun pemen. ");
INSERT INTO bmh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ziwas mazicina, Yesus uzan tub wanib Nein, go uzan beteun. Gonugau tapaimaraneun dudu abai ereg ipal duailel asiu abai ereg betemen. ");
INSERT INTO bmh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesus go uzan gilan og waugab go darena, du tub noumeun imai alemen, Du noumeun gonugau anag, mogoi tub tamacag, gonugau mogoi go tutak, gonugau gamu mui getal noumeun. Go uzanan duailel asiu go air dual ereg sesamorai alemen. ");
INSERT INTO bmh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dubanou Ban go air go uligaimai, bisou peun. Go air go aureun, “Na i manilmen.” ");
INSERT INTO bmh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesus go du go noumeun waugab beteimai, du noumeun biz ebu ebeg meun. Guzenina, du noumeun go dudu agen biz mui gamacai alemen go ebu tapai daremen. Yesus nug eneun, “Mogoi, iz aizem, na asen.” ");
INSERT INTO bmh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Go du noumeun koli usaimai, gonugau biz ebu hoboi daimai, go zeze meun. Guzenina, Yesus nug mogoi go imai aimai, gonugau anag moroun. ");
INSERT INTO bmh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Guzenina, duailel unum uminaimai, Uwait nugau wanib ulagwag moroimai, goagen enemen, “Uwait nugau ze doimai, awaraneun du tub ig ula aleun. Uwait gonugau duailel isanarabun aleun.” ");
INSERT INTO bmh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Duailel go Zudia agaigan mui ipal em Zudia pezoroan mui uzan ata atai wanemen, agen go igul Yesus nug salau meun ze marai marai aidarenar. ");
INSERT INTO bmh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Zon nugau tapaimaraneun dudu agen Yesus nugau igul unum Yesus nug meun uligaimai, Zon alai auremen. Aurina, Zon nug gonugau tapaimaraneun du aliag, Yesus waugab palautarena, guzenai kanabai awaremen, “Dudu agen du tub banou alamau emen. Na go du ta, ta, ig du tub aiu ses alamau gumamam ta?” ");
INSERT INTO bmh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Go dudu agen Yesus waugab alaimai, kanabemen, “Ze ziwaraneun du, Zon nug ig na en kanabizabun palautigeun, ‘Na alai Israel duailel imarabun alemen ta, ig du tub alamau gumamam?’” ");
INSERT INTO bmh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ziwas go ebu Yesus nug duailel asiu ebeu eg mui kasareun. Wes eg mui dudu unum kasareun. Dudu ipal ameag tapeleun mui amiag oiteun, go koli em pemen. ");
INSERT INTO bmh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Guzenaimai, Yesus nug koli go dudu aliag awareun, “Ag ein ze domen, agal amiag nug ein igul pemenin go unum, koli betei Zon auran. Ameag tapeleun dudu go kolital ameag oitaba, em pimamen. Aramag egugweun dudu ag abu aidamamen. Dudu ebeu leprosi mui ag kolital naliu usalem. Dabuiag utub dudu ag kolital ze suban dom. Noumemen dudu ag kolital awau asamam. Aunagul dudu ag Uwait nugau Ze Naliupet dom. ");
INSERT INTO bmh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","In du go iz en ougab petak anem, go gusig tapai damau, go du gonugau ougab naliu usalamau.” ");
INSERT INTO bmh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yesus nug Zon nugau ze duailel gotulai daremen ebu awareun, “Ag du tamacag uzan em ula ebu Zon waugab ein esab piabun betemenin? Ag waliwal tub wol nug patena piabun betemenin ta? ");
INSERT INTO bmh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ag ein betei pemenin? Ag du tub naliu maimai dareun betei pemenin ta? Dudu ag tibur galau tibur galau naliu mui, ag ecesab asiu mui han, ag uzan zau naliu ebu danemen. ");
INSERT INTO bmh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ag iz ailan, ag ein piabun betemenin? Uwait nugau ze doimai, awaraneun du tub ta? Go petak pet. Iz petak awarem go Uwait nugau ze doimai, awaraneun du. Gonug ipal Uwait nugau ze doimai, awaranemen dudu zilarai dareu. ");
INSERT INTO bmh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Zon go du getal Uwait nugau ze nug aneun, ‘Uwait nug eneun “Iz izal ze oi awarabun du palautem, amegai alai, nait abu tuguiai kalai mizamau.” ’ ");
INSERT INTO bmh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iz ag petak pet awarem, Zon nug e em ebuan duailel unum zilarai dareu. Bo, du in go Uwait nugau ameg ebu wanib ulagwag tamacag, gonug eneu, ‘Uwait izal gumilaneu du banou, iz go pigsal darem’ go du nug Zon zilacoroi dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Duailel unum go ze doimai, ipal duailel abai ereg, ipal aiwag wanemen dudu abai ereg, agen enemen, “Petak Uwait nugau igul tuguianau pet.” Getal, ag Zon nug ze ziwareun, gonun, ag guzen anemen. ");
INSERT INTO bmh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parisi dudu mui, kasai ze tapaimaranemenin dudu abai ereg, ag Uwait nugau igul naliu sesamorabun utanemen. Guzenaimai, Zon nug ze ziwabun awarina, utemen. ");
INSERT INTO bmh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus nug duailel awareun, “Iz ulisan duailel ein sul anai? Iz agal igul ein sul anai? ");
INSERT INTO bmh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ag geleagar ginaginam agen em nogoug ebu hoboi daimai, ipal geleagar abai ereg onaimai guzenai agag ularamam, ‘Ig air wanemen pulel huemun, bo, ag ilanab tam.’ ‘Ig du noumaneun kabal wemun, bo, ag manilmab tam.’ ");
INSERT INTO bmh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ze ziwaraneun du, Zon zoimai, ipal ziwas ebu, go ee mui wain ze mui i zaneu. Guzenina, goagen auremen, ‘Zon go wes eg mui,’ emen. ");
INSERT INTO bmh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Du Nugau Nag alaimai, go wain ze ee mui zinarai, agen enemen, ‘E du uligan, go bo sul ee asiu zaneu. Go aiwag wanemen dudu mui igul eg macanemen dudu abai ereg, ee zaneu.’ ");
INSERT INTO bmh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Uwait nugau Ah Wes omen duailel ag petak Uwait nugau dabeleu naliu go abiu mamamen.” ");
INSERT INTO bmh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi du tub nug, Yesus gonugau zaueim ee zabun imai beteun. Yesus go zaueim go beteimai, ee zabun hoboun. ");
INSERT INTO bmh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Go uzanan air tub go igul eg mui daneun. Gonug Yesus Parisi du nugau zaueim ee zaizai dareu ze doimai, go gunip tub naliu ze sous naliu zoun oimai, aleun. ");
INSERT INTO bmh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Air go zoimai, Yesus waugab tapai daimai, weinai dareun. Gonugau ameg ilau nug Yesus nugau arab ebu noun. Nuna, gonugau gagalig ulig uiaban sil go ameg ilau Yesus nugau arab ebu gules aimai, gonugau arab zukzukaimai, ze sous go oimai, Yesus nugau arab ebu esikeun. ");
INSERT INTO bmh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Guzenina, go Parisi du go peimai, dabeleun, ‘E du go Uwait nugau ze doimai, awaraneun du zob, go abe meu zob, air go inug go pateu. Go abiu mamau air go gue abu ebuan air.’ ");
INSERT INTO bmh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesus nug go Parisi du nugau dabeleu abiu maimai, eneun, “Saimon, iz ze tub aizamoroi.” Saimon nug koli Yesus aureun, “Dubanou Ban nait ze ailemen, duai.” ");
INSERT INTO bmh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus nug guzenai aureun, “Du aliag go beteimai, du tub ebu aiwag oimai, auremen ‘Nait aiwag ameg aiu ses koli mizamam.’ Du tub go aiwag handret tabkuai (500) sag oun, du tub nug mui guzental go aiwag houhou tabkuai (50) sag oun. ");
INSERT INTO bmh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Goagen koli gonugau aiwag murabun iborain tam, gonun, go aiwag atag pateun du nug awareun, ‘Ag go aiwag en i dabelen, iz gaul patem.’ Go dudu aliag, inug go go du en ougab banou noumeun?” ");
INSERT INTO bmh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon nug koli guzeneun, “Izal dabeleu go du go aiwag asiu handret tabkuai (500) sag oun.” Yesus nug koli Saimon aureun, “Na go ze petak pet anem.” ");
INSERT INTO bmh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Guzenaimai, Yesus nug air go dareun eiman kekulaimai, Saimon aureun, “Na e air amen nug uligem ta? Iz nait zaueim zomin, na izal aram ulusabun ze i milem, bo, e air go ameg ilau nug izal aram ulusaimai, gonugau gagalig uligsil guleseun. ");
INSERT INTO bmh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","46","Na iz nait zaueim imailai zomen na iz zukzuk ilab tam, e air nug iz zuna, go nug izal aram zukzukaimai, utilab tam. Na ze sous izal gagali ebu esikab tam, bo, e air nug izal aram ze sous naliu sil unum ziwileun. ");
INSERT INTO bmh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gonun, ulis iz aizem, gonugau igul eg asiu macaneu, izan gonugau igul eg unum zilagai morom. Einen, gonugau ougab iz en noumeun. Bo, du in go igul eg ginampet meun, izan gonugau igul eg zilagai moromin. Gonug iz en ougab oug ginamtal noumeun.” ");
INSERT INTO bmh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Guzenaimai, Yesus nug abu ebuan air go aureun, “Izan nait igul eg unum zilagai mizem.” ");
INSERT INTO bmh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dudu ipal go ereg go dual ee zai daremen go ze doimai, agzozou zeminar, “E du in, go igul eg zilagai marabun, iborain ta?” ");
INSERT INTO bmh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesus nug air go aureun, “Nait ounab iz en petak emen, gonun, na koli naliu usalemen. Gonugun, ulis nait ounab iau holanau mui alien.” ");
INSERT INTO bmh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ziwas tub ebu, Yesus go gonugau tapaimaraneun dudu begurug go ban uzan mui uzan ginaginam mui beteimai, Uwait nugau ze duailel maremenin. ");
INSERT INTO bmh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ziwas go ebu, wes eg ipal ailel agal oiagab oug dareun Yesus nug oi aleun. Air tub gonugau wanib Maria go Magdala uzanan Yesus nug wes eg kwali oi ai moroun. ");
INSERT INTO bmh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Du tub gonugau wanib Kusa, go Herot nugau zau gumaneun du. Herot go gue emgasag gumaneun du banou. Go du nugau wau gonugau wanib Zoana mui, air tub wanib Susana mui, ailel ipal han, go Yesus nugau tapaimaraneun dudu abai ereg sesamaraimai, wanemen. Go ailel agen agal aiwag mui, ecesab mui, oimai, Yesus nugau tapaimaraneun dudu abai ereg isanarai wanemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","Duailel uzan ata atai ebuan Yesus waugab alemen unum alai gotulina, Yesus nug tatau ze tub awareun, “Du tub ee ug iabun gonugau ougem beteun. Ee ug ipal abu ebu alai noun. Guzenina, dudu agen tapaimemen, meg asiu zoimai egei zemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ee ug ipal em ai ebu alai noun. Go ee ug walu zoun. Go em ze tamacag. Guzenaimai, go ee ug walu zoimai, noumemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ee ug ipal ebgeleu kulam ziu oug noimai, walu zoun. Kulam nug oi zendai, suban tapabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ee ug ipal em naliupet ebu alai noun. Ee ug go em naliu ebu alai noun, go ee ug naliupet walu zoun. Walu zoimai, go useg asiu manar, ipal useg 100 manar.” Yesus guzenaimai, duailel awareun, “Duailel ag dabuig a aba, ag go tatau ze doimai, zebigeg abiu mamamen!” ");
INSERT INTO bmh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesus nugau tapaimaraneun dudu agen tatau ze zebigeg go erunai ina. ");
INSERT INTO bmh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Gonug koli awareun, “Uwait nug duailel gumarabun igul getal wageimai dareun. Ulis ag izal tapaimaranemin dudu, gonun, zebigeg go i marem. Ipal duailel ag tatau ze sag duanemen Gonugun, ag amiag nug piab piab emen, bo, suban i pemen. Ag ze dabuiag nug duaneu duaneu, bo, ag go zebigeg i abiu.” ");
INSERT INTO bmh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesus nug guzeneun, “Go tatau ze gonugau zebigeg enai Go ee ug, go Uwait nugau ze. ");
INSERT INTO bmh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ipal ee ug abu ebu noun, go enai duailel go Uwait nugau ze doimai, Wes eg nug zoimai, agal oiagab an ze oi waneun. Gonugau dabeleu, go guzenai, ag oiagab petak i mebiag, Uwait nug ag kolital i igaramau. ");
INSERT INTO bmh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ipal ee ug aimar ebu noun, go enai, duailel ze doimai, siksikinar. Ee ug ginib em oug nuab tam. Gonugau zebigeg enai, agal oiagab petak emen, gue ginampet. Uhu ziwas tub ebu, ag Uwait nugau ze utamamen. ");
INSERT INTO bmh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ipal ee ug ebgeleu kulam ziu oug noun, go enai, duailel ze doimai, betei betei beteimai, uhu ata atai oimai, oiagab eg uba ta, em ebuan esab mui ereg, em ebuan igul mui ereg, uligaimai, siksikaimai, Uwait nugau ze dabuiag sikamau. Guzenaimai, go ee ug salau naliu tam. Tam. Ag Uwait nugau ze unum utamamen. ");
INSERT INTO bmh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Go ee ug em naliupet ebu noun, go gonugau zebigeg enai, duailel ze doimai, gusig patemen, goagal oiagab petak eun. Ag gusig damamen. Go guzenai, ag ee ug useg naliu maneu sul asiu mamamen.” ");
INSERT INTO bmh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesus nug koli eneun, “Du tub nug al usaimai, mis oug ta, biz pigsal i macaneu. Go al usaimai, wag asai mina, dudu ipal zaueim alaimai, al go pianem. ");
INSERT INTO bmh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ein ece agal oiagab oug wageimai dareu unum araog zumau. Ein ece dudu agen kulai macanemen unum al hilanau ebu zuba, dudu pimam. ");
INSERT INTO bmh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ag suban danemen, ze go don. Bo, du tub go ipal dabeleu naliu mui, go du Uwait nug ipal dabeleu naliu morou. Bo, du in go dabeleu naliu tamacag, gonugau dabeleu izatal dabeleu naliu mui aneu, Uwait nug gonugau dabeleu ginampet patai dareu go unum koli ebegalaumau.” ");
INSERT INTO bmh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ziwas go ebu, Yesus nugau anag, amagul abai ereg, Yesus piabun alemen. Go ebu duailel asiu gotulai daremen, gonun, go Yesus waugab siabun iborain tam. Gonun, goagen zau og tapai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dudu ipal agen piaraimai, betei, Yesus auremen, “Nait anan, amaiar abai ereg, na peizabun alemen, uzaneim tapai darem.” ");
INSERT INTO bmh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Go guzenai aurina, Yesus nug koli go duailel awareun, “Inen duailel ag Uwait nugau dabeleu sesamoranemen, go duailel ag petak izal anikai magite.” ");
INSERT INTO bmh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ziwas tub ebu Yesus go gonugau tapaimaraneun dudu abai ereg tebil ginampet ebu simai, awareun, “Igag tubaiman matelai bitab.” Awarina, betemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ula betena betena, Yesus go gabueun. Gabuai darena, wol banou zoimai, go tebil ze nug oi zabuneun. Guzenina, dudu unum uminemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yesus nugau tapaimaraneun dudu agen beteimai, Yesus asoroimai, auremen, “Dubanou Ban, ig ze nug oigai zamoroi.” Gonug asaimai, go wol ze mui kagagai awarendai, iautal so eun. ");
INSERT INTO bmh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Gonug koli gonugau tapaimaraneun dudu awareun, “Agal oiagab petak emen eruab?” Goagen uminaimai, dabeleu asiu oimai, enemen, “Ein du eneneg? Gonug wol mui, ze mui awarina, go gonugau ze doimai, sesamoranem.” ");
INSERT INTO bmh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Go guzenaimai, Yesus nug mui gonugau tapaimaraneun dudu abai go tebil ebu Gerasa uzan, Galili agaig tubaiman betemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tebil betei gasageim imena, Yesus kuanai noun. Go uzan du tub go wes eg mui dareun. Go Yesus waugab zoun. Ziwas getgetal, go tibur galau i tuganeu go burum daneu. Go zaueim i ninaneu. Tam, go eb ob hiacanemen pip ninaneu. ");
INSERT INTO bmh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Go du nug Yesus peimai, piecaimai, alai Yesus nugau arab waugab taubibieun. Gonug gusig ulaimai, Yesus aureun, “Yesus, na Uwait wag dareu nugau nag. Na iz erunilamam? Iz Uwait nugau wanib gusig pataimai, aizem, na iz uhu i milen.” ");
INSERT INTO bmh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Go guzenai aureun, einen, getal Yesus nug go wes eg go du ebu alien aureun. Go ebu, go wes eg nug pie eun. Umkoskos go wes eg nug go du ougab oug daneu. Dudu ipal agen go du umkoskos gumei danem. Goagen go sen mui arab ebeg otoi macanemen. Gonug us gusig mui, sen mui, kitkuat aneun. Wes eg gonug go du imai aimai, du tamacag uzan macaneu. ");
INSERT INTO bmh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus nug kanabeun, “Nait wanim in?” Gonug koli aureun, “Izal wanim Asiu.” Go einen, wes eg asiu go du nugau ougab oug dareu. ");
INSERT INTO bmh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Go ebu, go wes eg agen Yesus auremen, “Ig ab banou ebu i palautigen.” ");
INSERT INTO bmh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ipal bo asiu em manam tubaiman ee zai daremen. Go ebu, go wes eg agen Yesus gusig ze auremen, “Ig utigemen, bo, go darem agal oiagab oug numam.” Guzenai aurina, Yesus nug awareun, “Iboi, ag alian!” ");
INSERT INTO bmh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Guzenai awarendai, wes eg goagen du go uteimai, bo agal oiagab oug nomen. Go bo agen pigai beteimai, em eg ebu silikaimai nomen. Go noimai, ze unig oug noimai, ze zaimai, noumemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Guzenina, bo gumaranemen dudu go igul go uligaimai, pigai uminai wanemen. Goagen beteimai, go ze go uzan mui, emgasag mui, unum awaremen. ");
INSERT INTO bmh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gonun duailel go ze go doimai, goagen alai Yesus waugab alaimai, go du wes eg oi hai moroun pemen. Goagen du go dabeleu naliu mui tibur galau tugaimai, Yesus nugau arabugab hoboi darena, pemen. Peimai, duailel go uminemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Go dudu go Yesus nug go du kasoroun uligaimai, goagen dudu ipal i abiu daremen, go igul meun unum betei awaremen. ");
INSERT INTO bmh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Go ebu, go em nogoug Gerasa uzan waugab gonun duailel agen Yesus auremen, “Na ig utigaib, alien.” Go uminaimai, Yesus guzenai auremen. Guzenina, Yesus gonugau tapaimaraneun dudu abai tebil wag simai, agal uzan koli wanemen. ");
INSERT INTO bmh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Go du go getal wes eg mui dareun naliu usaleun, gonug beteimai, Yesus gusig aureun, “Dubanou Ban, iz na ibaiz unai, na iz io ailamam ta?” Bo, Yesus nug koli go du aureun, “Na nait uzan beteib, Uwait nug e igul na ebizab meun betei duailel awaren.” Guzenai aurina, go du gue gonugau uzan beteimai, Yesus nug gonugau wes eg oi hai moroun, gonugau uzanan duailel unum awareun. ");
INSERT INTO bmh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus gonugau tapaimaraneun dudu abai ereg kolital tubaim alina, duailel ag go uligaimai, go siksikemen. Einen go Yesus gonugau tapaimaraneun dudu abai go gumarai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Du tub gonugau wanib Zairus, go Zuda agal gotulanemen zau gumaneun du tub. Gonug Yesus nugau arab waugab zoimai, taubibiaimai, Yesus gonugau zau bitabun aureun. ");
INSERT INTO bmh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Einen, gonugau aleg tutak sag gonugau wai begurug sag go noumamoroi. Yesus du go sesamorai betei betena, duailel asiu unum tubaim tubaim sesamorai betemenin. ");
INSERT INTO bmh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Go ula ebu, air tub go geil ebeu umkoskos waneu, gonugau ebeu go wai begurug sag dareun. Du tub nug go kasabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Go air go Yesus waugab zoimai, Yesus nugau tibur galau siu patena, go ebeu eg waneun. ");
INSERT INTO bmh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus nug duailel kanabai awareun, “Inug iz gagileu?” Duailel agen enemen, “Ig i abiu.” Pita nug aureun, “Dubanou Ban, duailel asiu na wautab daremen, nait tibur galau gagorom.” ");
INSERT INTO bmh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesus nug eneun, “Du tub nug iz gagileun. Iz abiu, einen, izal gusig ipal waneun.” ");
INSERT INTO bmh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Go air go igul meun wagemabun iborain tam, gonun, duailel amiagab zoimai, Yesus nugau arab waugab taubib weun. Air gonug gonugau ze unum Yesus aureun. ");
INSERT INTO bmh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus nug air go aureun, “Ainag, nait ounab petak eun, gonun, nait ebeu waneun, nait ounab iau dabun a alien.” ");
INSERT INTO bmh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus go air go aurina aurina, du tub Zairus nugau zauan alaimai, Zairus aureun, “Zairus, nait ainag noumeun, na tapaimaraneu du salau i moren.” ");
INSERT INTO bmh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesus nug go ze doimai, Zairus aureun, “Na umin ien. Nait ounab petak en. Go ainag awau dareu, go noumab tam.” ");
INSERT INTO bmh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesus go du gonugau zaueim beteimai, Pita, Zon, Zems abai ereg, ainag nugau memeg anag abai sag imarai sieun. Gonug im gebena, ipal duailel uzaneim daremen. ");
INSERT INTO bmh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Gonun duailel ainag go en oiagab egwina, weinai daremen. Yesus nug awareun, “Ag einen weinai daremen? Go ainag noumab tam. Go gabuai dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Guzenai ze mina, gonun duailel go Yesus nugau ze doimai, go welemen. Goagal dabeleu go gaul polumai dareu emen. Einen, go abiu go ainag noumeun. ");
INSERT INTO bmh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesus nug ainag nugau ebeg pataimai, uloroimai, aureun, “Ainag, na asen.” ");
INSERT INTO bmh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Guzenina, go ainag noumeun gonugau dorog koli zuna, waseun. Yesus nug ainag go ee morobi, zabun, en awareun. ");
INSERT INTO bmh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gonugau memeg anag agen igul go uligaimai, esilakinar. Bo, Yesus nug go igul meun, dudu ipal i awarabun en gusig awareun. ");
INSERT INTO bmh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus nug gonugau tapaimaraneu dudu begurug sag awarina, alina, go wes eg oiabun mui ebeu eg kasarabun han gusig mareun. ");
INSERT INTO bmh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Maraimai, gonug Uwait nug duailel gumarabun alamau ze naliu marabun mui, ebeu eg kasarabun han palautareun. ");
INSERT INTO bmh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesus nug gonugau tapaimaraneun dudu awareun, “Ag abu ebu bitabun ecesab tub i on. Ag taru ta, zo ta, ipal ee ta, aiwag i oi unamamen. Tibur galau mui i oi unamamen. ");
INSERT INTO bmh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ag uzan go betebi, gonun, dudu agen imarebiag, go dudu agal zaueim sag dan, Uwait nugau ze duailel maran. Uwait nugau ze awaraiban, koli go zaueim sag alai damamen. ");
INSERT INTO bmh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dudu ipal agen agal ze duabun uteimai, suban i gumarebiag, ag go uzan uteimai, agal igul eg abai marabun agal aramag ebuan em esues kueian.” ");
INSERT INTO bmh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Go tapaimaraneun dudu uzan go uteimai, uzan ata atai unum betemenin. Uwait nugau Ze Naliupet marai marai, duailel ebeu mui kasararai, uzan ata atai ereg iboremenin. ");
INSERT INTO bmh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ziwas go ebu, Herot go Galili agaig gumaraneun du, go igul ata atai Yesus nug meun auremen doimai, go dabeleu asiu oun. Einen, dudu ipal agen enemen, “Go ze ziwaraneun du Zon, go noumeun kolital ob ougeiman usai zoun.” ");
INSERT INTO bmh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","9","Dudu ipal agen dabeleimai, enemen, Elaiza kolital usaleun. Ipal agen enemen, Uwait nugau ze doimai, awaraneun muz du tub kolital waseun, Guzenai dabeleimai, Herot nug eneun, “Iz Zon nugau beu kuatai hemin, go in du pemen?” Herot nug Yesus piabun unai aimai dabeleun. ");
INSERT INTO bmh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesus nugau ze oi aidanemen dudu go uzan ata atai Uwait nugau ze oi aidaremen, koli alemen. Agen Yesus ein igul memen unum auremen. Yesus nug imarai betei, agtal uzan tub wanib Betsaida, betemen. ");
INSERT INTO bmh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Duailel asiu goagen go betemen doimai, sesamarai betemen. Gonug beteimai, duailel Uwait nug gumarabun aleu ze awaranar, ipal duailel suiag eg mui, ebeu mui kasareun. ");
INSERT INTO bmh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Umusig mina, Yesus nugau tapaimaraneun dudu agen Yesus waugab beteimai, guzenai aurem, “Du Banou Ban, e duailel palautaremen, unamam, goagal uzan waugab beteimai, ee gau maimai, zai zai goagal uzan unamam, Einen, e uzan du tamacag.” ");
INSERT INTO bmh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesus nug koli awareun, “Agenag ee zabun maran.” Go agen koli enem, “Ee asiu tam. Ig bret tabkuai mui, karuk aliag sag dareu. Na ein dabelem? Ig uzan beteimai, dudu asiu e agal ee gau mamam ta?” ");
INSERT INTO bmh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Go dudu go tausen tabkuai. Gonun, Yesus nug gonugau tapaimaraneun dudu awareun, “Go duailel go houhou tabkuai, houhou tabkuai sisiai hobolilai, hoboi bitamam.” ");
INSERT INTO bmh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Gonugau tapaimaraneun dudu agen gonugau ze sesamoraimai, guzenemen. ");
INSERT INTO bmh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesus nug bret tabkuai go mui, karuk aliag mui oimai, Mesgai wag ameitaimai, Uwait ‘Ese-e’ auraimai, kikakaraimai, gonugau tapaimareun dudu agen duailel dou marabun mareun. ");
INSERT INTO bmh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Go duailel unum go ee zaimai, go biguiag zuna, Yesus nugau tapaimaraneu dudu agen gom gau zo begurug oimai, duailel agen ee zemen ee ogog utemen zulagai memen. ");
INSERT INTO bmh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ziwas tub Yesus go nugtal Uwait aurai dareun, gonugau tapaimaraneu dudu go waugab betena, Yesus nug kanabeun, “Duailel agen, iz in anem?” ");
INSERT INTO bmh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","20","Go agen koli auremen, “Ipal duailel agen guzenem, ‘Go ze ziwaraneun du, Zon.’ Ipal duailel agen guzenem, ‘Go Elaiza.’ Ipal duailel agen en anem, ‘Go Uwait nugau ze doimai, awaraneun du tub noumeun kolital waseun.’” Guzenai aurina, Yesus nug gonugau tapaimaraneu dudu kanabareun, “Agen iz in anemen?” Pita nug eneun, “Na Kristus, Uwait nugau Nag pet. Ig koli imaigabun gonug na palautizena, alemen.” ");
INSERT INTO bmh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Guzenaimai, Yesus nug gonugau tapaimaraneu dudu gusig ze go ipal duailel i awarabun en awareun. ");
INSERT INTO bmh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Gonug kolital gonugau tapaimaraneu dudu awareun, “Iz, Du Nugau Nag, mu asiu oimai, Zuda dudu banban mui, Uwait ula danemen dudu mui, kasai ze tapaimaranemenin dudu abai ereg, agen izal ze duabun uteimai, semilem. Go agen iz iwebiag, noumai. Bo, gil ianai ainarai ebu, Uwait nug iz koli usai milamau.” ");
INSERT INTO bmh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gonug dudu unum awareun, “Duailel inen iz sesamilai zuabun, nug en i dabilamau, ziwas bete betei nugtal gonugau a gegeulanau gamacaimai, iz sesamilamau. ");
INSERT INTO bmh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Du in gonugau dorog awau dabun dabeleu go gonugau dorog eg wamau. Bo, du in gonugau dorog iz en noumeun, go du gonugau dorog muzmuz suban naliupet damau. ");
INSERT INTO bmh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Du tub em ebuan esab unum umau, go noumamau, go esab nug gonugau dorog awau dabun erunai abu kalamau? Esab gonug i isanaramau. ");
INSERT INTO bmh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Du in iz sesamilabun uminamau, go nug iz en i abiu aimai, izal ze wageimai mamau, iz, Du Nugau Nag, aiu ses izal al banouban mui, mekai nugau al mui, tibur naliupet agal al mui, go oug alaimai, izan mui zemai, ‘Iz go du i abiu’ anai. ");
INSERT INTO bmh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iz ag petak pet awarem, dudu ipal ag e em ebu daremen, ipal i noumamamen, bo, ag dabi dabi, Uwait nugau gumarabun igul araog zumau pimamen.” ");
INSERT INTO bmh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus go ze unum gonugau tapaimaraneu dudu awar aimai, gil gugen mazicina, go nug Pita, Zon, Zems abai ereg imarai, em manam wag Uwait aurabun siemen. ");
INSERT INTO bmh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesus nug Uwait aurina aurina, gonugau enib kekulaimai, du tub sul usaleun. Gonugau tibur galau ausiau pet usaleun. ");
INSERT INTO bmh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Usalina, pigaital dudu aliag zoimai, Yesus dual ereg ze ze mai daremen. Go dudu aliag Moses zaug Elaiza dual. ");
INSERT INTO bmh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Go Mesgai wageiman Uwait nugau al banou ebu alaimai, go Yesus dual ze ze mai daremen. Go Uwait nugau dabeleu ulis go Zerusalem uzan simai, noumabun guzenai zemenar. ");
INSERT INTO bmh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita gonugau zaugul aliag abai ereg go unum ninemen, koli asaimai, Yesus nugau al banou mui go du aliag go abai ereg tapai daremen piaremen. ");
INSERT INTO bmh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Go dudu aliag Yesus utei Mesgai wag sina sina, Pita nug Yesus aureun, “Dubanou Ban, ig e ebu dabun naliu. Na ze meben, ig e ebu zau ainarai mamam. Tub nait, tub Moses nugau, tub Elaiza nugau.” Pita suban dabeleimai, ze go mab tam. ");
INSERT INTO bmh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Go guzenai ze ze mai daren daren, pi alaimai, kulareun. Go tapaimaraneun dudu ainarai go uminai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pi ougeiman du ogusau tub nug guzenai ze meun, “Go izal nagwai pet. Go izanag palautoromin. Ag gonugau ze suban don.” ");
INSERT INTO bmh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Go du ogusau ze meun mazicina, Yesus nugtal dareun. Yesus nugau tapaimaraneu dudu go zemab tam. Go dabeleu asiu oimai, soai daremen. Yesus nug gonugau tapaimaraneu dudu guzenai awareun, ag go igul ulis pemen, ipal duailel i awarabun en awareun. ");
INSERT INTO bmh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Go nineimai, umaseu, Yesus nug mui go dudu ainarai Yesus sesamorai wanemen. Em manam wag uteimai, alina, duailel asiu agen piaraimai, alai piaremen. ");
INSERT INTO bmh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Du tub go duailel ula dareun ulaimai, eneun, “Dubanou Ban iz na aizem, izal mogoi tutak, gonun, na piabun aizem. ");
INSERT INTO bmh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wes eg go ebu darem, pieaimai, guarguaraimai, betei, ogusau siwalkuk aneu. Wes eg go gue utabun iborain tam, gonun, gonugau enib eg usalaneu. ");
INSERT INTO bmh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iz nait tapaimaranemen dudu go wes eg oi abun awaremin go oi abun iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus nug duailel en aegsisilaimai, koli awareun, “Ag ulisan duailel, agal dabeleu erunai pet, ag oiagab petak abun iborain tam, ag gagaliag gusig macanemen. Iz ag abai ereg ban i dai.” Guzenai awaraimai, Yesus nug go du aureun, “Nait mogoi e ebu imai alen.” ");
INSERT INTO bmh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Go mogoi alina alina, go wes eg nug mogoi go suai amacendai, Yesus nug go wes eg go mogoi utei unabun gusig aureun. Wes eg go utei wanena, go mogoi go naliu mina, gonugau memeg koli moroun. ");
INSERT INTO bmh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Duailel go ereg gotulai daremen, Uwait nugau gusig uligaimai, go esilakemen. Duailel go Yesus nug go igul meun uligaimai, dabeleu asiu omen. ");
INSERT INTO bmh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Guzenina, Yesus nug gonugau tapaimaraneu dudu awareun, “Ag izal ze ulis awarem i amahan. Iz, Du Nugau Nag, ebe aram durub waimai, dudu agal ebeagab ebu milamam.” ");
INSERT INTO bmh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yesus nug go ze awareun, gonugau tapaimaraneu dudu ag go ze bigeg i abiu. Guzenaimai, go uminaimai, go kanaborab tam. ");
INSERT INTO bmh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesus nugau tapaimaraneun dudu go agzozou ze alalaimai, enemen, “Ig ula du in banou dareu?” ");
INSERT INTO bmh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Yesus nug go agal dabilemen abiu maimai, mogoi ginampet tub imai aimai, nug waugab tapai maimai, go nug awareun, “Du in go iz en dabeleimai, e mogoi imai aimai, suban gumamau, go iz han ereg imailamau. Du inug iz imailamau, go du go iz palautilen, alemin go mui ereg imacamau. Du in go ulis ag ula ebu wanib banou tam, go du go banou usalamau.” ");
INSERT INTO bmh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zon nug Yesus aureun, “Dubanou Ban, ig du tub nug nait wanim ebu wes eg oi hena, pemun. Ig go igul i guzenabun aimai auremun, einen, go igual zaig tam.” ");
INSERT INTO bmh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesus nug aureun, “Ag go i kuatai ze auran, einen, du in go agal iwai zaiag tam, go agal zaiag.” ");
INSERT INTO bmh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus go em uteimai, Mesgai wag siabun ziwas hogu usalina, abiu maimai, Zerusalem uzan siabun dabeleun. ");
INSERT INTO bmh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Guzenaimai, gonugau ipal tapaimaraneu dudu amegai palautarendai, betei Samaria uzan tub waugab gonugau ninabun empip suban mabun betemen. ");
INSERT INTO bmh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Go Zuda agal Zobu Ban piabun ziwas ebu, Yesus go Zerusalem uzan bitabun aleun. Guzenaimai, gonun dudu agen Yesus imab utemen. ");
INSERT INTO bmh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Gonugau tapaimaraneu du aliag Zems zaug Zon dual ag go ze doimai, enemen, “Dubanou Ban, ig Uwait auremun, Mesgai wagan ab uloromun, alai e uzanan dudu unum alai agaramaun iboin ta?” ");
INSERT INTO bmh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesus nug koli kekulaimai, gusig ze awareun. ");
INSERT INTO bmh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Guzenaimai, go gonugau tapaimaraneu dudu abai ereg uzan tub wanemen. ");
INSERT INTO bmh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesus gonugau tapaimaraneu dudu abai ereg Zerusalem uzan betena betena, du tub nug Yesus aureun, “Na eru ebu unamam, iz na ibaiz ereg sesamizai unai.” ");
INSERT INTO bmh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus nug koli aureun, “Gaian egun zag inain go ninabun zau mui, meg inain go ninabun teu mui, bo, Du Nugau Nag go ninabun pip tamacag.” ");
INSERT INTO bmh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesus nug du tub aureun, “Na sesamilen.” Du gonug koli go aureun, “Dubanou Ban, iz utileben, betei izal mekai ob oug heimai, kolital alai na sesamizai bitai.” ");
INSERT INTO bmh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesus nug aureun, “Noumemen dudu agtal goagal zaiagar noumemen ob oug hiacaramam. Na beteiba, Uwait nug e em unum gumarabun aleu, go ze naliu duailel betei awaren.” ");
INSERT INTO bmh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Du tub nug Yesus aureun, “Iz izal ataiar betei ‘wanem aimai’ awaraimai, kolital alaimai, na sesamizai.” ");
INSERT INTO bmh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesus nug koli go du aureun, “Du in go abu tuguiai kalai unamau, koli kekulabun amau, go abu tuguianau i kalai unamau. Guzeneneg du go Uwait nug gumaraneu duailel ula ebu salau du naliu i damau.” ");
INSERT INTO bmh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yesus nug dudu 72 sag egaraimai, du aliag aliag amega uzan ata atai Yesus nug bitabun en palautareun. ");
INSERT INTO bmh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gonug go dudu guzenai awareun, “Go ougem ee asiu anabun iboin usalai dareu, bo, go ougem ee anabun salau dudu asiu tam. Ag go wai atag du go aurebi, gonug ipal salau dudu palautaraba, goagen betei go ee gotulai mamam. ");
INSERT INTO bmh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bitan, iz ag sipsip sul bau eg ebu palautarem. ");
INSERT INTO bmh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ag agal zo mui, aiwag zo mui, aramag galau mui i oi bitan. Ag abu ula dudu ipal gotularaiban, ag i zemaran. ");
INSERT INTO bmh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ag dudu ipal agal zaueim siabun gaul i sian, amegai siabun, ‘Uwait go abai ereg dareu,’ darem awareminag, zaueim sian. ");
INSERT INTO bmh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Go zauan du nug ag imaraimai, suban gumaraba, agal suban dabun ze go dual damau. Bo, du in go ag gonugau zaueim i imarai simau, agal suban dabun ze go dual i damau. ");
INSERT INTO bmh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Inen dudu agen ag agal zaueim dabun imaramau, ag go zaueim sag damamen. Ag go zauan ein ee mui ze mui marebiag, zan. Einen, go salau dudu agal salau memen go aiwag umam. Ag ipal zaueim i bitan, go zaueim sag damamen. ");
INSERT INTO bmh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ag ban uzan betebiag, in du nug ag gonugau zaueim imarai simai, ee marebiag, zan. ");
INSERT INTO bmh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Go uzan duailel ebeu mui kasaraiban, gonun duailel guzenai awaran, ‘Uwait, e em ebuan gumarabun du banou ag waiagab zou.’ ");
INSERT INTO bmh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Bo, ag uzan tub betebiag, gonun duailel agen ag i imarebiag ag abu ula beteimai, awaran, ‘Ag agal uzan em esues igual aramig ebu dareu kuecemun, agal uzan koli numau, go ag abiu mamamen agal igul naliu tam.’ Iz ag petak awarem, Uwait nug duailel gumarabun ziwas waiagab zoimai dareu. ");
INSERT INTO bmh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iz ag petak pet awarem, e em sisiarabun ziwas ebu duailel Sodom uzan getal igul eg mai daremen ab nug go uzan elareun, gonun duailel ag mu ginampet sag umamen, go uzanan duailel ulis darem go izal ze doimai, i sesamoranemen ag aiu ses mu banou pet umamen.” ");
INSERT INTO bmh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus nug koli awareun, “Korasin uzanan duailel, iz ag piaraimai bisomag pem. Betsaida uzanan duailel, ag mui piaraimai bisomag pem. Iz go igul banou ata atai Tair uzanan duailel mui, Saidon uzanan duailel mui, ag igul go abai maremin sul zob, haiden duailel ag oiagab eg waba, pigai tibur galau muz tugaimai, waibul ebu hoboi daremen zob. Go igul guzenemen go agal igul eg ebuan koli oiagab kekulemen! ");
INSERT INTO bmh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Iz ag petak pet awarem, aiu ses Uwait nug koli alai duailel sisiarabun ziwas ebu Tair uzanan mui, Saidon uzanan duailel mui ag uhu ginampet sag umamen, bo, ulisan duailel ag uhu banou pet umamen! ");
INSERT INTO bmh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ag Kapaneam uzanan duailel, ag agtal Mesgai wag simamen ta? Petak pet, ag i simamen. Uwait nug ag ob oug ab banou ebu amacaramau.” ");
INSERT INTO bmh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesus nug gonugau tapaimaraneu dudu awareun, “Inen duailel agen agal ze dumam, go ag izal ze mui dumam. Inen duailel agen agal ze duabun utanem, go ag izal ze mui i dumam. Duailel inen izal ze doimai, sesamorabun utanem, go du in nug iz palautilen, alemin gonugau ze mui i sesamoramau. Yesus nug go ze awaraimai, palautarendai, wanemen.” ");
INSERT INTO bmh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Go tapaimaraneu dudu 72 koli agal oiagab siksikai mui alaimai, Yesus auremen, “Dubanou Ban, iguan nait wanim ebu duailel wes eg mui daremen awarina, wes eg go igual ze doimai, utei wanemen.” ");
INSERT INTO bmh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesus nug koli awareun, “Iz pei darena, Satan go Mesgai wageiman amilaneu sul noun. ");
INSERT INTO bmh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ag go don, izal gusig ag maremin. Man eg mui, on eg mui, ag go ebalagab aidabun iboin. Goagen ag i kaluaramam. Satan igual iwai zaig nugau gusig unum zilacurabun, gusig iz ag maremin. Einab tub nug ag eg i maramau. ");
INSERT INTO bmh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bo, wes eg agal ze sesamoremenin go en ag i siksikan. Uwait nug agal wanimag Mesgai wag sikut wai meun en ag siksikamamen.” ");
INSERT INTO bmh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Go ziwas ebu Yesus go Ah Wes mui gonugau ougab siksikaimai, eneun, “Mekai, na tutak Mesgai mui, em mui agal Banou, iz nait wanim ulapwag mem, einen, na nait igul naliu abiu wacanem duailel mui, abiu wabun betemen duailel mui goagal amiagab wageimai memen. Bo, na go igul naliu i abiu duailel unum abai maremen. Mekai go igul petak nagtal nait dabeleu ebu guzenemen.” ");
INSERT INTO bmh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Izal Mekai nug ece unum izal ebe ebu meun. Du tub nug gonugau Mogoi i abiu macaneu, Memeg nug tutak abiu. Du tub nug Mogoi gonugau Memeg abiu mabun iborain tam, gonugau Mogoi nug tutak Memeg abiu. Mogoi gonug duailel nugtal egaraimai, gonugau Memeg abai maraba, ag mui go abiu mamamen. ");
INSERT INTO bmh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Guzenaimai, Yesus nug kekulaimai, gonugau tapaimaraneu dudu ze wageimai guzena awareun, “Ag esab go agal amiag nug pemen agal oiagab siksikai damamen. ");
INSERT INTO bmh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iz petak pet ag awarem, getal Uwait nugau ze doimai, awaranemen dudu mui, emgasag gumaraneun dudu asiu mui ag go ece ag ulis pemen sul piabun emen, go piab tam. Ze ulis ag domen sul muz dudu go duabun emen, go duab tam.” ");
INSERT INTO bmh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kasai ze tapaimaraneun du tub go Yesus bimag piabun zoimai, Yesus guzenai aureun, “Du Banou, Iz erunaimai, dorop awau muzmuz dabun wai?” ");
INSERT INTO bmh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus nug kolital go du aureun, “Agal kasai ze agau ebu ein sikut wemen, agal dabeleu ze bigeg go erunai?” ");
INSERT INTO bmh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Du gonug Yesus kolital aureun, “Na nait ounab mui, nait dorop mui, nait dabeleu mui, nait gusig mui nait Banou, Uwait en unum noumen. Na nag en noumem sul, nait zaun en guzenai noumen.” ");
INSERT INTO bmh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus nug aureun, Petak pet na go guzenamam, na muzmuz awau damam.” ");
INSERT INTO bmh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Du go nugtal gonugau wanib wag mamoroi, go zoimai, Yesus kolital kanabeun, “Kasai ze eiman izal zai inen en aneu?” ");
INSERT INTO bmh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus nug koli aureun, “Du tub go Zerusalem uzanan Zeriko uzan noun. Go abu ula ipal zob dudu agen waimai, eg moroimai, gonugau esab unum egeimai, utei wanemen. Du go noumabun aimai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Du go wemen abu ebu daren daren, du tub Uwait ula dacaneu du go mui go abu eiman noun. Go, go du peimai, uminaimai, abu tubaiman waneun. ");
INSERT INTO bmh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Abu go ebutal Liwai du tub, go Uwait ula dacanemen dudu isanaraneun du, go han abu go eiman aleun. Go noimai, du go abu ebu dareun peimai, go mui abu tubaiman waneun. ");
INSERT INTO bmh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","iwai zaug tub go Samaria uzanan, go han abu go eiman aleun. Du go abu ebu darena, bisou banou peun. ");
INSERT INTO bmh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Du go waugab beteimai, a dab ebuan ze wain ze mui oimai, du gonugau sug ebu maimai, sug tibur galau zig otoi moroimai, du go gamacaimai oi gonugau donki ebu maimai, zau tub abu go pezai dareu ebu imai beteimai, suban gumei nineun. ");
INSERT INTO bmh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nineimai, umaseu, Samaria du tub nug aiwag oimai, zau atag du moroimai, aureun, ‘Na du e suban gumei dan, nait ein ece du e ebu utamam, iz kolital alaimai, na gau mizai.’” ");
INSERT INTO bmh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus nug go ze poaimai, kasai ze tapaimaraneu du tub aureun, “Nait dabeleu, go dudu ainarai du in go zob dudu agen wemen gonugau zaug sul usaleun?” ");
INSERT INTO bmh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Go kasai ze tapaimaraneun du nug Yesus koli aureun, “Du go zob dudu agen abu ebu wemen en bisou peun du.” Yesus nug aureun, “Na beteimai, igul go guzenaital menen.” ");
INSERT INTO bmh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus go gonugau tapaimaraneu dudu abai ereg go ze marai maziaimai, go uzan tub alina, air tub gonugau wanib Marta, nug gonugau zaueim imai beteun. ");
INSERT INTO bmh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Gonugau apag wanib Maria go zoimai, Yesus waugab hoboi daimai, Yesus nugau ze doi dareun. ");
INSERT INTO bmh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta go nugtal salau maimai, ougab eg wina, alai Yesus aureun, “Dubanou Ban, iz izaseu salau oi darem, izal apai auremen, alai iz isanilamau.” ");
INSERT INTO bmh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesus nug koli Marta aureun, “Na salau wabun, ece asiu en dabeleu om. ");
INSERT INTO bmh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Igul tutak sag na zilaize dareu. Maria go igul naliu go wabun gugeg sisiaimai meun. Du tub nug go ebuan i oi himau.” ");
INSERT INTO bmh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ziwas tub ebu, Yesus nugtal Uwait aurai dareun. Go Uwait aurai maziaimai, gonugau tapaimaraneu du tub nug aureun, “Dubanou Ban, Zon go gonugau tapaimaraneu dudu Uwait aurabun abai mareun, sul, na han ig Uwait aurabun abai migen.” ");
INSERT INTO bmh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesus nug kolital awareun, “Ag Uwait guzenai auran, Igual Memenig, nait wanim naliupet ig ulapwag mizem. Nait gumiganem ziwas e em unum alai iboramau. Nait onsau Mesgai wag sesamoranemen sul, ig em ebu han ereg sesamoramam. ");
INSERT INTO bmh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ulis na ig ee migamam. ");
INSERT INTO bmh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Iguanag dudu ipal agal igul eg ig ebiligeb miganemen zilagai maranem sul, nagen han igual igul eg zilagai migen. Na ig ece abu eg ebu i hamaigamam.” ");
INSERT INTO bmh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Gonug koli awareun, Ag ula du tub go zaug alaba, go gonugau zaug nugau zau umaum beteimai, aureu, ‘Zai, iz ee tub milen. ");
INSERT INTO bmh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Izal zai tub awau ulis aleun, ig ee unum zianemun, ig ee tub murabun tam.’ ");
INSERT INTO bmh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Du go zau eiman daimai, guzenai aureu, ‘Iz im gebemin. Izal gelear abai ereg ninem. Na iz salau i milen. Iz i asanai, ee mizabun iborain tam.’ ");
INSERT INTO bmh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iz petak pet awarem, du go zau dareun go asaimai, gonugau zaug nugau dabeleu uteu. Bo, go gonugau zaug, gonun, koli koli asoroun, asaimai, ee moroun. ");
INSERT INTO bmh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Guzenaimai, iz petak pet awarem, ag ein ece wabun Uwait auran, go nug ece maramau. Ag ein ece itanemen, ag pimamen. Ag im korukoruan, Uwait nug im oitai maramau. ");
INSERT INTO bmh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Duair in go ece wabun Uwait aureu, go ece umau; duair in ece itanem, go pimam; duair in go Uwait nugau im korukoru eu, go Uwait nug im oitai moroba, zau simau. ");
INSERT INTO bmh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Du tub nugau nag nug memeg aureu, ‘Mekai, iz karuk zai,’ aurina, memeg nug man eg tub oi muramau ta? ");
INSERT INTO bmh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Gonugau nag nug ‘Mekai, iz toi wag zai,’ aurina, memeg nug on oi muramau ta? ");
INSERT INTO bmh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ag dudu zigulin mui, agen goagal geleagar ee naliupet maranem abiu macanemen. Igual memenig Mesgai wag dareu, go igul naliupet mui, agen go Ah Wes maraneu auran, gonug ag maramau.” ");
INSERT INTO bmh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ziwas go ebu Yesus nug du tub wes eg mui ogusau tapelai dareun kasai meun. Wes eg go wanena, du go koli ze meun. Duailel go ebu gotulai daremen go igul uligaimai, esilakinar. ");
INSERT INTO bmh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dudu ipal agen enemen, “Go Belsebul go ipal tibur eg gumaraneu gonug Yesus gusig murona, wes eg oi araneu.” ");
INSERT INTO bmh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dudu ipal agen polumorobi, gonug igul ata atai maba, piabun auremen. ");
INSERT INTO bmh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesus nug goagal dabeleu abiu maimai, awareun, “Emgasag tub go agzozou alalaimai, agzozou bigagaimai, ag ban i dacanemen. Ag unum eg umamen. Atanagar tutak ag agzozou alalaimai, agzozou bigagaimai, ag suban i dacanemen. ");
INSERT INTO bmh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Guzenai sul, Satan nugau atagul tutak agzozou alalaimai, agzozou bigagaimai, ag erunai gusig damamen? Agen iz Belsebul nugau gusig eiman wes eg oi hiaranem ailanemen. ");
INSERT INTO bmh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bo, iz Belsebul nugau gusig eiman wes eg oi hiaranem, inug agal geleagar wes eg oi hiarabun gusig maraneun? Agal geleagar agtal go igul sisiamam. ");
INSERT INTO bmh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Petak pet tam, iz go Uwait nugau gusig ebu wes eg oi hiaranem. Go petak abiu mamam, Uwait nugau gumarabun ziwas ag waiagab ulis alai dareu. ");
INSERT INTO bmh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ag go don. Du tub go gusig mui go kemzet pataimai, gonugau zau gumaneu, go gonugau esab i zob umam. ");
INSERT INTO bmh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bo, du tub go gusig banou pet mui zoimai, du go waimai, go nug du gonugau kemzet ebegalau oimai, gonugau esab unum egeimai, dudu ipal dou maramau. ");
INSERT INTO bmh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Duair in izal zai tam, go izal iwai zai. Duair in iz isanilaneun, dudu ipal iz waiab imarai alab tam, go duailel zamarendai, wane anem.” ");
INSERT INTO bmh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus nug koli eneun, “Wes eg tub du enib ebuan oi ina, go beteimai, du tamacag uzan imabun en pip itanamau. Go betei imabun pip tam gonun, go guzenai aneu, ‘Iz kolital izal muz zaueim bitai.’ ");
INSERT INTO bmh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Guzenaimai, go koli betei go zau em kasai suban memen, gaul dareun uligeun. ");
INSERT INTO bmh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Peimai, go betei ipal wes eg kwali agal zigulin eg pet mui imaraimai, koli go zaueim ereg dabun alemen. Guzenina, go wes eg asiu agen go du ebu zigulin eg pet mina, getal go du go eg daneu, ulis go unum eg pet dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus nug duailel gotulai daremen ebu go ze maraimai, air tub nug go ula daimai, ulaimai, aureun, “Go air inug na solin waimai, gumizeun go petak ougab siksikamau.” ");
INSERT INTO bmh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus nug koli eneun, “Tam. Inen duailel ag Uwait nugau ze unum doimai, sesamoranemen, ag petak siksikamamen.” ");
INSERT INTO bmh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Duailel alai gotulai darena darena, Yesus nug awareun, “Ag ulisan duailel ag eg pet. Ag igul ata atai memina, piabun en, dabilemen. Iz igul ata atai asiu i abai marai. Uwait nugau ze doimai, awaraneun du, Zona nugau igul tutak go petak abai marai. ");
INSERT INTO bmh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Getal Uwait nug Zona ebu go igul go Niniwe uzanan duailel abai mareun sul, ulis iz, Du Nugau Nag, iz, igul go ulisan duailel tutak abai marai. ");
INSERT INTO bmh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aiu ses Uwait nug sisiarabun ziwas ebu, Siba emgasag gumaraneun air go noumeun koli usaimai, ulisan duailel abai ereg alaimai, agal zigulin araog maramau. Einen, air go uzan go tubaiman Solomon nugau ze naliu duabun aleun. Ulis iz petak pet awarem, du tub banou Solomon zilacoroi dareu. Iz ulis e darem, bo, ag mui izal ze duab utemen. ");
INSERT INTO bmh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aiu ses, Uwait nug koli alai e em ebuan duailel sisiarabun ziwas ebu Niniwe uzanan duailel noumemen koli usaimai, Uwait amegwab ulisan duailel abai ereg tapai daimai, auramam, ‘Ulisan duailel ag zigulin eg macanemen’. Einen, Niniwe uzanan duailel go Zona nug Uwait nugau ze mareun, goagal zigulin eg uteimai, koli oiagab kekulaimai, Uwait en agal oiagab petak emen. Iz ag petak pet awarem, ulis e ebu du tub dareu go banou, gonug Zona zilacoroi dareu. Ag go du banou nugau ze duab utemen.” ");
INSERT INTO bmh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus nug koli eneun, “Dudu ag al usaimai, mis oug ta, zau oug i wageimai macanemen. Ag al usaimai, wag asai macanemen. Guzenina, duailel ag zaueim siabun go al hilanau uligaimai, go zaueim sianemen. ");
INSERT INTO bmh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nait amen go enim nugau al. Nait amen naliu damau, go agal enimag al sul ele damau. Bo, nait amen eg usalamau, nait ounab oug mui unum umutamau. ");
INSERT INTO bmh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gonun ag suban dacan, tam aba, go al oiagab oug dareu useamau. ");
INSERT INTO bmh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bo, agal enimag nugau al naliu umkoskos elei damau, go al zaueim eleimai, hilai dareu sul.” ");
INSERT INTO bmh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus nug duailel Uwait nugau ze unum marai betei poaimai, Parisi du tub nug Yesus gonugau zaueim ee zabun aureun. Guzenina, Yesus go dual ee zabun beteun. ");
INSERT INTO bmh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Go Parisi du nug ee zabun ziwas ebu Yesus go Uwait nugau amegwab naliu usalabun gonugau ebeg ze ebu ulusab tam, uligaimai, esilakeun. ");
INSERT INTO bmh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Guzenina, Yesus nug du go aureun, “Ag Parisi dudu agal tebil, gap mui bobou ebu suban ulusanemen, unu tamacag, bo, ag zigulin asiu macanemen, gonun, agal oiagab oug unu banou dareu. ");
INSERT INTO bmh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Agal dabeleu naliu tam. Ag i abiu ta? Uwait nug agal oiagab patai meun, agal enimag mui gonugtal patai meun. ");
INSERT INTO bmh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ag go ee agal tebil oug dareu go dudu ece tamacag dudu maran. Ag guzenebi, ag unum unupag tamacag damamen. ");
INSERT INTO bmh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ag Parisi dudu, ag suban don. Ag ougem an ee unum banou mui, ginampet mui houhou ata atai dou mizanaraimai, tutak sul oi Uwait muranemen. Go igul naliu guzenemen, bo, ag Uwait en oiagab petak i anemen. Ag go igul naliu mui ipal igul naliu mabun i uten. ");
INSERT INTO bmh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ag Parisi dudu, ag duailel gotulanemen zaueim ag hubabun pip naliu wanemen. Ag ig wanem empip ebu duailel agen ipal duailel amiagab umaseu awaraimai, agal ulapag wag mina, ag siksikanemen. ");
INSERT INTO bmh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bisomagar, ag ob ougan dudu agen ilig inain i bizanarai manem sul. Duailel ag go i pianemen, ag go ebu tapai aidamamen ag unupag mui damamen.” ");
INSERT INTO bmh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kasai ze tapaimaraneu du tub nug go ze doimai, aureun, “Dubanou Ban, na go ze anem, go ig mui oigab eg weu.” ");
INSERT INTO bmh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Guzena aurina, Yesus nug eneun, “Ag kasai ze tapaimaranemen dudu mui, ag kasai ze go esab uhu pet duailel agal enimag ebu gamahai maranemen. Bo, agen go uhu gamabun i isanaranemen. ");
INSERT INTO bmh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bisomagar. Agen Uwait nugau ze doimai, awaranemen dudu agal ob oug biz naliu gugai macanemen. Go dudu agal embigeg agen wagarina, noumemen. ");
INSERT INTO bmh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ag go ob oug biz naliu gugai marebiag, ag ipal duailel abai maranemen, agal dabeleu agal embigeg agal igul naliu anemen. ");
INSERT INTO bmh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Go igul Uwait nugau dabeleu naliu nug eneun, ‘Iz ag waiagab Uwait nugau ze doimai, awaranemen dudu mui, ze oi aidaneun dudu mui palautarai. Ipal eg maramam, ipal wagarebiag, noumamam.’ ");
INSERT INTO bmh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gonun, ulisan duailel ag agal embigeg agal uhu umamen. Uwait nug koli go dudu wagaraba, noumemen agen isanarebi, ulisan duailel uhu umam. ");
INSERT INTO bmh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Go petak getal dudu agen em mui Mesgai usalai meun ziwas ebu ag Abel wina, noumeun zo zo, agen Sekaraias go Uwait ulagwag muranemen biz, Uwait nugau zau naliu ula ebu wina noumeun. Agen go duailel naliu unum wagarina, noumemen. Iz petak pet awarem, ulisan duailel ag go uhu unum umamen. ");
INSERT INTO bmh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kasai ze abai maranem dudu, bisomagar, ag Uwait nugau ze dudu ipal ebalagab wageimai macanemen. Ag agtal suban i sesamoranemen. Dudu ipal sesamorai siabun anem agen daimai, abu tapelanemen.” ");
INSERT INTO bmh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesus go zaueim go dareun utei uzaneim nuna, kasai ze tapaimaranem dudu mui Parisi dudu mui agen go seugab polu ze asiu maimai, gusig zeze kanabenar. ");
INSERT INTO bmh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Gonug koli ein ze maramau, go agen uhu murabun en suban ogusau pei daremen. ");
INSERT INTO bmh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yesus go ze mina mina, duailel asiu gotulaimai, agzozou suarai suarai inar. Yesus nug amegai gonugau tapaimaraneu dudu awareun, “Ag Parisi dudu agal bret agena, nelaneun marasin wanib zis suban pimamen. Ag goagal ze naliu kel mui doiban, suban sisian. Go ze unum petak tam, gonun, suban don. ");
INSERT INTO bmh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Einen, esab kulai dacanemen go unum araog zumau, ein esab wageimai mamam duailel abiu macanemen. ");
INSERT INTO bmh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Guzenai sultal, ag ein ze wageimai ze macanemen, araog al ebu dumamen. Ag ein ze iauiau zaueim im gebeimai, awaranem go zau wageiman simai gusig ze mamam.” ");
INSERT INTO bmh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus nug koli eneun, “Izal zaiar, iz petak awarem, ag go dudu, dudu ipal wagarebiag, noumabun go i uminaran. Aiu ses, dudu goagen ag koli erunaramam. ");
INSERT INTO bmh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Iz ag in uminabun abai marai. Ag Uwait Banou tutak uminoron. Go gusig banou mui. Gonug ag aiu ses wagaraimai, ab banou oug amacarabun iboin. Go petak awarem, ag go tutak uminoron. ");
INSERT INTO bmh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ig wanem empip ebu, meg sipikiau tabkuai aiwag toia ainarai mui gau macanemen. Uwait nug meg tutak tutak suban gumaraneu. ");
INSERT INTO bmh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Guzenaital go agal gagaliag ulig tutak tutak unum nanaleun dareu. Ag umin ian, Uwait nugau amegwab agen go meg ginaginam zilarai daremen. Uwait ag gumaramau.” ");
INSERT INTO bmh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesus kolital awareun, “Iz petak awarem, in duair go nug duailel em ebu, ‘Iz Yesus gonugau zaug’ awaraba, iz Du Nugau Nag iz han guzental Uwait nugau salau tibur agal amiagab ‘Du go gue izal zai’ anai. ");
INSERT INTO bmh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Du in nug duailel em ebu izal zai aimai i awaramau, izan han guzental Uwait nugau salau tibur agal amiagab ‘Du go gue izal zai’ aimai i anai. ");
INSERT INTO bmh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bo, du in nug ze eg Du Nugau Nag nugau wanib ebu mamau, Uwait nug go zigulin zilagai muramau. Bo, du in nug Uwait nugau Ah Wes nugau enibwag ze biabial kuamau, Uwait nug du gonugau zigulin i zilagai muramau. ");
INSERT INTO bmh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Du in nug ag gotulanemen zaueim, dudu banban amiagab imarai betebiag, ag ein ze marabun dabeleu asiu i on. ");
INSERT INTO bmh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gusig tapai dan. Uwait nugau Ah Wes nug go ziwas ebutal ag ein ze marabun abai maramau.” ");
INSERT INTO bmh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Du tub nug go duailel unum gotulai daremen ebu usaimai, Yesus aureun, “Dubanou Ban, na izal apai, auremen, go esab igual memenig nug noumaimai, utemige waneun dou migemen umam.” ");
INSERT INTO bmh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus nug koli aureun, “Iz agal esab apan dual dou marabun alab tam.” ");
INSERT INTO bmh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Guzenaimai, gonug duailel awareun, “Ag suban tapai dan, ag e em ebuan esab wabun en dabeleu i on. Du in go esab asiu mui go esab go ebuan dorog awau dabun i umau.” ");
INSERT INTO bmh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gonug koli tatau ze awareun, “Du tub go ece asiu mui, du gonugau ougem ee asiu daneu. ");
INSERT INTO bmh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Du go gonugau ougab ougeiman dabeleimai, eneu, iz erunaimai, iz e esab gotulai mabun zau tamacag. ");
INSERT INTO bmh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Guzenaimai, nugtal dabeleimai, eneun, ‘Izal zau ginampet e unum tigalaimai, zau tub banou maimai, go zaueim esab unum oug mai.’ ");
INSERT INTO bmh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Guzenaimai, gonug eneu, ‘Ulis, iz ee asiu mui, gonun, iz e ee wai asiu mui zaimai, siksikai dai. Iz salau koli koli i mai, gaul dai, ee ze mui sag za za dai.’ ");
INSERT INTO bmh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Uwait nug du go aureun, ‘Na dabeleu tamacag du. Ulis umaum na noumemena, e esab unum inug umau?’ ");
INSERT INTO bmh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Du in go esab asiu gotulai macaneu, go igul go guzenamau, go Uwait nugau ameg ebu tamacag du damau.” ");
INSERT INTO bmh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Guzenaimai, Yesus nug gonugau tapaimaraneu dudu awareun, “Ag agal enimag en dabeleimai, ‘Ig ein ee zaimai, dab?’ ‘Ig ein tibur galau tugabun?’ guzenai i dabilan. Doropag go banou pet, ee banou tam. Agal enimag banou pet, tibur galau go banou tam. ");
INSERT INTO bmh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ag meg inain piaran. Go ee ug i banemen, go ee gotulaimai, betei zaueim i gotulai macanemen. Go Uwait nugtal ee marena, zanem. Agen go meg inain zilarai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Du in ag ula ebu gonugau dabeleu asiu mui e em ebu ziwas huia dabun iboin? Go guzenabun iborain tam pet. ");
INSERT INTO bmh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ag igul ginampet guzenabun iborain tam gonun, ag einen igul banou guzenabun dabilemen? ");
INSERT INTO bmh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ag gaian a sisil uligan. Go salau i macanemen, tibur galau mui agtal i patai macanemen. Bo, iz ag petak pet awarem, getal gumaraneun du Solomon go gonugau tibur galau naliupetpet pataneun, go tibur galau a sisil zilaurab tam pet. ");
INSERT INTO bmh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gaul gig gaian go Uwait nug tibur galau maraneun. Go gig ulis damau, go tuaba ab nug unum elamau. Go gig gaul dacanemen go Uwait nug tibur galau maraneun. Agal oiagab petak eun go ginampet! Ag go abe macan, Uwait nug ag mui gumaraneu. ");
INSERT INTO bmh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Guzenaimai, ag oiagab eg i umau, ag dabeleu asiu ee zabun i on. ");
INSERT INTO bmh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Uwait nugau ze i duanem dudu go em e ebuan esab wabun dabilanemen. Igual memenig go abiu esab salau mui, gonun, gonug ag maramau. ");
INSERT INTO bmh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ag Uwait nugau uzan siabun amegai dabilan, gonug kolital go esab unum ag maramau.” ");
INSERT INTO bmh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesus nug kolital eneun, “Ag uminian, gelear igual memenig Uwait nug go esab usalai meun dareu duailel agal gumaraneu du banou go dabeleimai, enan, go nug esab maramau. ");
INSERT INTO bmh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Agal esab unum dudu ipal maraimai, aiwag oimai, aiwag go dudu esab tamacag maran. Ag agal oiagab suban damau, ag ece Mesgai wagan asiu gotulabun dabilan. Go ebu ece tub i itanamamen. Einen, go ebu zob du tub nug zob wabun iborain tam pet. Umum tub i zamau, ece go i eg wamau. ");
INSERT INTO bmh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Guzenaimai, ein uzan nait ece gotulai macanem ebu nait ounab mui go uzan dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesus nug koli awareun, “Ag ein igul zumau suban gumei dacan. Ag iweiu maiban, al usaiban, abu pei dan. ");
INSERT INTO bmh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Du tub go gonugau wau dual zuabun ina, gonugau salau du nug gumei daneu sul guzenan. Gonugau du banou zoimai im korukoruina, gonugau salau dudu agen agal du banou pigai betei im oitai muranem. ");
INSERT INTO bmh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Du banou gue gonugau salau dudu uligaraimai, banou siksikamau. Einen, go ninab tam. Iz petak pet awarem, gonugau tibur galau awau oi duei maimai, duailel hubabun awaraimai, ee maramau. ");
INSERT INTO bmh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Go dudu go agal du banou uligaimai, siksikamam, go umaum zumau mui go siksikamamen. ");
INSERT INTO bmh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ag abiu, zau atag du tub go zob du go gonugau zaueim zob wabun ziwas abiu zob, go i ninamau, go awau tapai dacaneu zob. Go du go ulagzaba, gonugau zaueim i ulagai simau. ");
INSERT INTO bmh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ag mui guzental suban gumei dacan. Einen, Du Nugau Nag go i abiu wag alamau, gonugau alamau ziwas go i abiu.” ");
INSERT INTO bmh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita nug Yesus aureun, “Dubanou Ban, e tatau ze go ig aigem ta, duailel unum awarem?” ");
INSERT INTO bmh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesus nug koli aureun, “Salau du in go dabeleu naliu mui ze sesamoraneu? Du tutak gue, gonugau gumaneu du nug usalai mina, go nug ipal salau duailel gumaraimai, goagal ee marai damau. ");
INSERT INTO bmh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Go salau du guzenai damau, gonugau gumaneu du alaba, go siksikamau. ");
INSERT INTO bmh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iz petak pet awarem, go salau du go gonugau du banou gonugau esab unum gumabun usalai muramau. ");
INSERT INTO bmh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bo, salau du tub go dabeleu naliu tam, go guzenai dabelaneu, ‘Izal gumilaneu du go pigai alab uteu.’ Guzenaimai, go nug ipal salau zaugul, wagaraimai, go ze gusig zaimai, ameg kualilai damau. ");
INSERT INTO bmh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Go guzenai guzenai daba, gonugau gumaneu du i abiu wag alaimai, go du busil higwag araimai, oiagab petak ab tam dudu agal uzan ses amaramau. ");
INSERT INTO bmh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Go salau du go abiu, gonugau du banou nug salau wabun palautoroun, go salau du pigai i salau umau, go salau du mu banou umau. ");
INSERT INTO bmh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bo, salau du tub go du banou nugau dabeleu abiu tam, salau naliu i maba, go du mu ginampet umau. Bo, Uwait nug du tub gonugau ebeg ebu esab gumabun macaneu, aiu ses go du ebuan koli esab asiu wai aimai aureu. Go du tub esab asiu pet gumabun macaneu, du go ebuan koli esab ebegalaumau.” ");
INSERT INTO bmh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus nug eneun, “Iz e em ebu ab zorabun alemin. Izal dabeleu go ab ele betei daba, go naliu. ");
INSERT INTO bmh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Iz amegai mu banou wai. Go mu gumei darem, izal oiab oug uhu banou mai dareu. ");
INSERT INTO bmh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Agal dabeleu iz e em ebuan duailel oiagab siksikai dabun alemin emen. Tam pet iz petak awarem, iz e em ebuan duailel ata atai kakarabun alemin. ");
INSERT INTO bmh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ulis ug tub ebuan duailel tabkuai kakaraimaimai, duailel ainarai tubaiman atelaimai, damamen, duailel aliag go tubaiman damamen. ");
INSERT INTO bmh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Guzenai sul dudu ag agal naiagar abai iwai mai damamen, naiagar agen agal memeagar abai iwai mai damamen. Ailel ag agal ainagul abai iwai mai damamen. Ainagul ag agal anaiagar abai iwai mai damamen. Ailel ag agal buziagar abai iwai mai damam, Buziagar agen han guzental guzenamamen.” ");
INSERT INTO bmh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus nug duailel awareun, “Ag pi umus banou alai tulaba, uligaimai, agen dabilanemen, ‘Go ze numau.’ Go ag petak anemen, ze nuaneu. ");
INSERT INTO bmh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ag wol malalai mui zuba abe maimai, agen ‘Go am gusig zuabun ziwas’, amamen. Go petak pet zuaneu. ");
INSERT INTO bmh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ag polu macanemen dudu, ag emes uligaimai, go ein ziwas zuabun abiu wanemen. Ag erunaimai, ziwas ulis ein zou go ag i abiu?” ");
INSERT INTO bmh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesus koli guzenai aneun, “Agenag suban dabeleimai, ze suban i sisianemen. ");
INSERT INTO bmh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ag go don. Na du tub nug, na sisiaraneun du nugau amegwab imaiz bitabun aba, ag abu ebu bete betei, oiagab tutak ze suban patan. Tam aba, gonug na sisiaraneun du ebu imaiz bitaimai, gonug na polis nugau ebeg ebu mizebiag, gonug hiacaranem zau oug heizamau. ");
INSERT INTO bmh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na go zau eiman koli uzaneim nuabun gaul i palautizamau. Bo, na aiwag banou mabun aizeun guzental unum maremen, petak na uzaneim palautizebi, unamam.” ");
INSERT INTO bmh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ziwas go ebu, ipal Galili dudu Uwait ulagwag morona, Pontias-Pailot nug wagarina, noumemen. Guzenaimai, dudu ipal agen Yesus auremen. ");
INSERT INTO bmh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus nug awareun, “Go Galili dudu Pailot nug wagarina, noumemen agal dabeleu go dudu noumemen agal zigulin eiman noumemen ta? Go Galili dudu ipal ulis darem agal igul naliu, gonun, ag i noumamam ta? ");
INSERT INTO bmh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tam pet, petak tam. Ag unum zigulin mui. Iz petak awarem, ag agal oiagab i kekulai daremen, ag go dudu noumemen sul ag han guzental noumamamen. ");
INSERT INTO bmh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Go dudu 18 getal Siloam uzan zau ulagai noimai, wagarina, noumemen, agal dabeleu go dudu ze asiu enimag ebu mui noumemen ta? Dudu ipal Zerusalem uzan daremen, ag ze enimag ebu tam ta? ");
INSERT INTO bmh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iz petak pet awarem. Go petak tam. Bo, agal oiagab i kekulebi, ag go dudu noumemen sul noumamamen.” ");
INSERT INTO bmh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Guzenai awaranar, Yesus nug tatau ze tub mareun, “Du tub go wain ougem weli ug beun. Go umkoskos go weli dab useg mamau aimai betei pianeu, useg i maneu. ");
INSERT INTO bmh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Guzenaimai, go nug go ougem gumaneun du aureun, ‘Iz wai ainarai e weli dab useg mamau aimai piabun alemin, go useg mab tam, gonun, iz kuatai. Go einen em nugau sirag gaul poai dareu?’ ");
INSERT INTO bmh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Go salau du nug koli aureun, ‘Duban, wai tutak sag utemen, daba, iz em naliu go a bigeg ebu hemina hemina, betei dab useg mamau ta piai. ");
INSERT INTO bmh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Go wai ebu, i useg maba petak na alaib kasai hen. Useg maba gue, go naliupet, damau.’” ");
INSERT INTO bmh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Zobu tub ebu, Yesus go duailel gotulanemen zaueim Uwait nugau ze duailel marai dareun. ");
INSERT INTO bmh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Go ebu air tub go wes eg mui wai 18 dareun go tuguiai usai tapai aidabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus nug air go bisou peimai, ulorondai, go waugab sina, aureun, “Air, nait ebeu eg zilagai mizem.” ");
INSERT INTO bmh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Gonug gonugau ebeg go air nugau gagalig patena, air go gue tuguiai usaimai, Uwait ulagwag moroun. ");
INSERT INTO bmh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Gotulanemen zau gumaneun du nug Yesus go igul guzeneun, peimai, aigsisileun. Einen, Yesus nug zobu ebu air go kasai meun. Guzenaimai, du gonug duailel awareun, “Ziwas wasolig ebu, go salau mabun ziwas, go ziwas ebu kasarabun iboin. Zobu ebu go i kasarabun.” ");
INSERT INTO bmh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dubanou Ban nug koli go du aureun, “Ag polumanemen dudu! Ag zobu ebu agal bulumakau ta donki ebuan us waipaimai, imarai betei ze maranemen. ");
INSERT INTO bmh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","E air go Abraham nugau atagul ebuan, Satan nug wai 18 imai aimai, gusig pataimai, dareun. Petak gonugau uhu zobu ebu zilagai murabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Gonug guzenina, gonugau iwai zaugul ag aipag noun. Ipal duailel go zaueim gotulai daremen ag go igul naliu uligaimai, ulagwag moromen. ");
INSERT INTO bmh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Guzenaimai, Yesus nug duailel kanabareun, “Iz Uwait nug duailel gumaraneu igul ein sulai dareu awarai? ");
INSERT INTO bmh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Go gonugau igul guzenai, du tub nug go paipai ug oimai, ougem beun. Go a ug ginampet walu zoimai, a banou usalaneu. Guzenina, meg agen alaimai, go a ebeg ebu teu memen. Go sul, amegemen duailel tutak tutak Uwait nugau ze sesamoranemen, aiu ses duailel asiu agen sesamoramam.” ");
INSERT INTO bmh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus nug koli eneun, “Iz Uwait nugau gumaraneun igul ein sul abai marai? ");
INSERT INTO bmh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Igul go guzenai, air tub nug zis ginampet oimai, plaua banou mui esikai oimai, gotularaimai, ipulina, go plaua neleimai, suai banouban pet usalaneu.” ");
INSERT INTO bmh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","24","Yesus go Zerusalem uzan betei daimai, ban uzan mui uzan ginaginam mui, Uwait nugau ze duailel mara marai, beteun. Du tub nug kanabeun, “Dubanou Ban, Uwait alai sisiarabun ziwas ebu dudu eiceisab eiceisab abu naliu ebu simam? Izal dabeleu asiu tam.” Yesus nug koli awareun, “Ag gusig maimai, abu ginampet eiman simamen. Einen, dudu asiu ag abu go ginampet eiman siabun amamen, bo, ag i simamen pet. ");
INSERT INTO bmh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Go zau og gumaneu du nug im gebaba, ag simai, uzaneim daimai, im patai korukoruaimai, en amamen, ‘Dubanou Ban, ig im oitai migen’ auramamen. Gonug ag koli awaramau, ‘Iz ag i abiu, getal ag i piaranem.’ ");
INSERT INTO bmh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Guzenaba, agen koli auramamen, ‘Ig na ibaiz daimai, ee mui, ze mui ereg zanem, na igual uzan Uwait nugau ze aiganem.’ ");
INSERT INTO bmh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Gonug koli awaramau, ‘Ag eruan zomen iz i abiu. Ag zigulin macanemen dudu, ag alian!’ ");
INSERT INTO bmh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Go ebu mu banban muzmuz oi damamen. Uwait nugau gumarabun igul araog zuba, agen Abraham, Aisak, Zekop mui Uwait nugau ze doimai, awaranemen dudu mui Uwait dual dabiag, piaramamen. Bo, ag uzan eg tub atai daimai, agal aiag kititkatitaimai, weinai damamen. ");
INSERT INTO bmh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ziwas go ebu, am zuaneun eiman duailel mui am nuaneun eiman duailel mui duailel e em eiman unum zoimai, Uwait nugau gumaraneun uzan gotulaimai, Uwait dual ereg ee zai damamen. ");
INSERT INTO bmh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dudu ag wanimag banou tam ses daremen, ag amegai damamen. Amegai daremen dudu ag wanimag mui, ag ses damamen.” ");
INSERT INTO bmh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ziwas go ebu, Parisi dudu ipal agen zoimai, Yesus auremen, “Na e uzan i damam, uteiba, uzan tub alien. Einen, Herot go na niweiabun guzenai dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus nug koli awareun, “Agen beteimai, go polubirag du betei auran, iz ulis, tuaba mui, duailel wes eg mui, ebeu eg mui kasai marai, gil ainarai ebu alinaba iz izal salau maziaimai, imai. ");
INSERT INTO bmh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bo, iz ulis, tuaba, alinaba salau mai Zerusalem uzan bitai. Einen, Uwait nugau ze doimai, awaraneun du Zerusalem uzan tutak webiag, noumamau.” ");
INSERT INTO bmh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O, Zerusalem, Zerusalem! Agen Uwait nugau ze doimai, awaranemen dudu wagarina, noumemen. Ag dudu ipal ze oi aidanemen dudu Uwait nug palautareun, aiwag sil wagarina, noumemen. Iz ziwas asiu, toi anag nug gonugau gelegul sausil kularai, dacaneu sul, izal ebe sil duailel gumarai dabun emin. Bo, duailel agen iz guzenabun i utilemen. ");
INSERT INTO bmh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ag go don, Uwait nug gonugau Nou zau utei unaba, agtal go zau gumamamen. Iz petak pet awarem, Ag iz koli i peilamamen. Iz ag petak pet awarem, ulis iz wanemin, ag iz koli i peilamamen, betei aiu ses, agtal guzen amamen, ‘Uwait nugtal du go usalai mamau, go Banou, nugau wanib eiman alamau.’” ");
INSERT INTO bmh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zobu tub ebu, Yesus go Parisi du banou tub nugau zaueim ee zabun beteun. Dudu agen go erunamau aimai suban pei daremen. ");
INSERT INTO bmh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Du tub go gonugau ebeg arab unum neleun, go du Yesus waugab siena, Yesus nug peimai, gonug kasai ze tapaimaranem dudu mui Parisi dudu kanabareun, “Du tub zobu ebu kasai mabun iboin ta tam?” ");
INSERT INTO bmh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Go dudu agen koli ze tub murab tam. Guzenina, Yesus nug go ebeu du kasai maimai, palautendai, gonugau uzan waneun. ");
INSERT INTO bmh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Guzenina, gonug awareun, “Ag agal mogoi ta donki ta zobu ebu ze ob oug eiman alainuba, ag erunamamen? Go ziwas ebu betei imamamen.” ");
INSERT INTO bmh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Go agen koli ze tub aurab tam. ");
INSERT INTO bmh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus nug dudu ee zabun zoimai, empip hubabun naliu una, uligaimai, gonug go dudu tatau ze tub mareun. ");
INSERT INTO bmh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Du tub nug na ee banou zabun ulizaba, na beteimai, empip hubabun naliu ebu i hoben. Go du nug du tub banou na mui ereg ulareun go empip hubabun naliu ebu zoimai hubamau. ");
INSERT INTO bmh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Du gue na ulizeun gonug zoimai, aizamau, ‘Go empip hubabun hoboi darem, du banou e moromena, hubamau.’ Guzenaba, na dudu wanimag tamacag abai betei hubabun aip numau. ");
INSERT INTO bmh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bo, na du tub nug ee zabun ulizaba, beteiba, dudu ipal ses hoboi darem ebu simai hoben. Guzenemen, go ee atag du zoimai, aizamau, ‘Zai, na wag empip hubabun naliu ebu simai hoben.’ Guzenaba, dudu ipal hoboi darem agen nait ulapwag mamam. ");
INSERT INTO bmh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Einen, du in go nugtal gonugau wanib ulag zeu, du gonugau wanib Uwait nugau amegwab banou i usalamau. Du in go nugtal gonugau wanib i ulag zeu, du go wanib go ulagwag mui damau.” ");
INSERT INTO bmh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Guzenaimai koli, Yesus nug ze maraimai, du go ee atag du aureun, “Na ee mis banou maiba, nait zaunar ta, nait amaiar apanar ta, nait atanar i ularen. Einen, go dudu agen na koli ee ameg wabun ulizamam. Na ein igul guzenemen, go agen mui koli guzental guzenamam. ");
INSERT INTO bmh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bo, na ee mis banou maiba, dudu esab tamacag mui, dudu aramag ebeag eg mui, amiag kumi mui dudu ee zabun ularen. ");
INSERT INTO bmh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Go igul guzenemen, nait ounab naliu usalamau. Go dudu agen na kolital ulizabun iborain tam. Guzenemen, dudu naliu go noumaimai, koli wasebiag, Uwait nug na suban gumizamau.” ");
INSERT INTO bmh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Du tub gue, go ebu hoboi dareun go ze go doimai, Yesus aureun, “Du in go Uwait nugau gumiganeun igul araog zumau ziwas ebu Uwait dual hoboimai, ee zaimai, go siksikaimai, naliu damau.” ");
INSERT INTO bmh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Guzenina, Yesus nug koli aureun, “Du tub go ee mis banou maimai, dudu asiu go ee alai zabun ze palauteun. ");
INSERT INTO bmh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ee mis banou unum mazi elena, ee zabun ziwas ebu gonugau salau du palautoron, go dudu gonug getal awareun, alai ee zabun betei awareun, ‘Ag alan, ee zabun ziwas meu.’ ");
INSERT INTO bmh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Go dudu tutak tutak agen koli go salau du auremen. Du tub nug go salau du aureun, ‘Iz em ulis gau memin, iz piabun bitamoroi. Nait du banou betei auren go ougab eg i umau.’ ");
INSERT INTO bmh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tub nug eneun, ‘Iz ulis bulumakau houhou gau memin, gonun, go suban salau mamam ta, tam ta, en piabun bitamoroi. Iz ee zabun i bitai. Nait du banou betei auren. Go ougab eg i umau.’ ");
INSERT INTO bmh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tub nug eneun, ‘Iz air ulistal omin, gonun, iz i bitai.’ ");
INSERT INTO bmh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Guzenina, go salau du koli beteimai, gonugau du banou go dudu agen auremen ze unum aureun. Du banou go aigsisilena, gonugau salau du aureun, ‘Na pigai ban uzanan gilan ogeiman mui abu ebuan mui beteiba, dudu esab tamacag mui, ameag kumi mui, aramag eg mui dudu izal zaueim imarai alen.’ ");
INSERT INTO bmh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Salau du gonug go ze sesamoraimai, koli zoimai, eneun, ‘Du banou, iz nait ze ailemen unum sesamoromin, bo, hubabun pip asiu gaul dareu.’ ");
INSERT INTO bmh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Guzenaimai, salau du koli gonugau du banou nug palautaimai, aureun, ‘Na abu gasag beteiba, dudu unum gusig ze awaremen, alebiag, go hubabun pip dareu unum iboramam. ");
INSERT INTO bmh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Einen, iz petak pet awarem, go dudu amegai ee zabun awaremin, ag izal eebiz ebu ee i zamam.’” ");
INSERT INTO bmh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Ziwas tub, duailel asiu Yesus sesamorai betena, gonug koli kekulaimai, duailel guzenai awareun, Du in izan tapaimoromin du usalabun gonugau memeg anag mui, gonugau wau mui, gonugau gelegul abai, nug mui ereg en umkoskos dabilamau, go izal tapaimoromin du i damau. Go iz tutak en ougab noumamau. ");
INSERT INTO bmh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","In du iz sesamilabun amau, go gonugau a gegeulanau gamahab tam, go izal tapaimoromin du i usalamau. ");
INSERT INTO bmh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Du tub go zau mabun, go hoboi daimai, suban dabilaneu. Go zau poabun iboin ta, tam ta aimai dabilaneu. ");
INSERT INTO bmh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Go igul go dabelab tam, go zau pigai i poamau, dudu ipal agen go zau i poaba uligaimai, weloromam. ");
INSERT INTO bmh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Goagen enamam, ‘Du gue zau meun go pigai pet salau poab tam,’ guzenamam. ");
INSERT INTO bmh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Emgasag ebuan gumaraneu du tub go gonugau malai dudu mui, emgasag tub ebuan gumaraneun du tub mui gonugau malai dudu asiu mui malaininabun, du banou go suban hoboi daimai, du banou tub go dual erunai malaininabun suban dabilaneu. Gonugau malai dudu mui ipal malai dudu mui malaininabun iboin ta, tam ta, guzenai dabilaneu. ");
INSERT INTO bmh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Gonugau dabeleu go dudu ipal abai malaininabun iboin tam, gonun, gonugau iwai zaug pulig dabi dabi, gonugau salau du tub palautaba, betei du tub peimai, auramau, ‘Ig ag abai alalab utem.’” ");
INSERT INTO bmh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesus go ze go awaramai, awareun, “Abu tutak sag. Du in go izal tapaimoromin du dabun amau, go gonugau esab unum semoroi maimai, go esab en dabeleu asiu i umau, go izal tapaimoromin du tuguiai damau.” ");
INSERT INTO bmh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesus nug koli eneun, “Siu naliu go kel a. Bo, gonugau kel betei munug usalaba, koli kel a usalabun sul iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Go siu ougem mui ipal salau mui mabun sul iborain tam. Ig gaul oi amanem. Ag dabuiag mui aba, ag go ze don.” ");
INSERT INTO bmh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ziwas tub ebu, aiwag wanemen dudu mui, ipal zigulin eg macanemen dudu mui Yesus nugau ze duabun alemen. ");
INSERT INTO bmh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi dudu ipal mui, kasai ze tapaimaranem dudu mui, agen go uligaimai, enemen, “E du go zigulin eg macanemen dudu abai ereg ee zaneu. Go igul naliu tam.” ");
INSERT INTO bmh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Guzenina, Yesus nug tatau ze eiman awareun, Du tub go gonugau sipsip 100 mui. Sipsip tutak kaiaba, go du erunamau? Go sipsip 99 sag utaraba, gig zai dabi dabi, beteimai, go sipsip tutak kaieun, itanai betei uligaimai, imai alamau. ");
INSERT INTO bmh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Go sipsip go betei itanai oimai, siksikaimai, abalag ebu gamacaimai, gonugau uzan bitamau. Guzenaimai, gonugau zaugul unum ularaba, alebiag, awaramau, ‘Ag iz ibail ereg alai siksikan, einen, izal sipsip tutak kaieun itanaimai pem, gonun, ulis naigag ee mis banou mab.’ ");
INSERT INTO bmh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Go igul sulai iz petak pet awarem, dudu 99 sag, go igul tuguiai naliu macanemen Mesgai wag go siksikamam. Bo, du tub gonugau zigulin meun semoroimai, gonugau ougab kekulaimai, ougab petak aneu, Mesgai wag go banban pet siksikamam.” ");
INSERT INTO bmh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesus nug koli awareun, Air tub gonugau aiwag naliupet houhou sag, tutak kaiaba, go erunamau? Go al usai oimai, gonugau zaueim es kalaimai, empip unum suban pimau. ");
INSERT INTO bmh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Go aiwag tutak itanai peimai oimai, gonugau zaugul ularaba, alai gotulebi, awaramau, ‘Izal aiwag kaieun itanai peimai om, gonun, ag iz ibail ereg siksikan.’ ");
INSERT INTO bmh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Go igul enai, iz petak pet awarem, du tub go zigulin macaneu go gonugau ougab koli kekulaimai, ougab petak aba, Uwait nugau salau tibur agen Mesgai wag guzental banban siksikamam.” ");
INSERT INTO bmh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus nug koli tatau ze tub guzenai awareun, “Du tub go mogoi aliag a sag. ");
INSERT INTO bmh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amag ginam nug zoimai, gonugau memeg guzenai aureun, ‘Mekai, na izal esab kakaiba, iz milen!’ Guzenina, memeg nug gonugau esab kakaimai, gonugau gelegul aliag ata atai doumareun. ");
INSERT INTO bmh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Dai dai, go amag ginam gonugau esab unum dudu ipal aiwag en marena, go ebuan aiwag oimai, uzan tub pulig dabun utei waneun. Go uzan tub pulig go beteimai, gonugau aiwag unum zigulin eg ebu amareun. ");
INSERT INTO bmh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Gonugau esab dareun unum poina, ziwas go ebu uzan tub ebu we banban pet zoun. Go esab tub tamacag. ");
INSERT INTO bmh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","16","Guzenina, mogoi go uzan du tub waugab betei salau go wabun asoroun, du gonug go mogoi gonugau bo gumarabun palautoroun. Go we banban wina, bo ee zena, go bo abai ereg zabun dabeleun, einen, du tub nug go ee zabun murab tam. ");
INSERT INTO bmh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dai dai, gonugau dabeleu naliu zuna, eneun, ‘Izal mekai nugau salau dudu ee naliu asiu zaidarem, e ebu ee tamacag dai dai, iz noumamanem. ");
INSERT INTO bmh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Izal mekai waugab beteimai, aurai, “Mekai, iz Uwait nugau amegwab mui, nait amenab iz zigulin eg memin. ");
INSERT INTO bmh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na iz nait mogoi aimai i ailen, nait salau du sul milen.” ’ ");
INSERT INTO bmh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Guzenai dabeleimai, go usaimai, gonugau uzan memeg waugab beteun. Go pulig alina alina, gonugau memeg nug pulig eiman peimai, gonugau mogoi en bisou peimai, pigai betei kuanaimai, moletoroimai, imai aleun. ");
INSERT INTO bmh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gonugau nag nug memeg aureun, ‘Mekai, iz Uwait nugau amegwab mui nait amenab iz zigulin eg pet memin, gonun, na iz nait mogoi aimai i ailen.’ ");
INSERT INTO bmh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bo, gonugau memeg nug gonugau salau dudu ularaimai, awareun, ‘Tibur galau naliupet pigai oi zoiban, tugai moron. Sai tub oimai, gonugau ebeg ebu macan. Arab galau oimai, gonugau arab ebu macan. ");
INSERT INTO bmh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Guzenaiban, beteimai, izal bulumakau nag naliu waiban, mis macan. Ig go mui ereg ee zaimai, siksikab. ");
INSERT INTO bmh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Izal mogoi e, go noumeun dabelemin go koli alai peileu, go unum waneu emin, iz koli go pem.’ Guzenaimai, go ee mis banou memen. ");
INSERT INTO bmh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Guzenai darena, mogoi kaman go ougem dareun, uzan esunap zoimai, zaueim kabal waimai, siksikai daren saipag doun. ");
INSERT INTO bmh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Guzenina, gonug salau du tub uloron, nondai, kanabeun, ‘Go zaueim ein erunai saipag hem?’ ");
INSERT INTO bmh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Salau du gonug koli aureun, ‘Nait amai koli uzan aleun, gonun, nait memen nug siksikaimai, gonugau bulumakau nag naliu waimai, go dual hubabun ee mis banou mai darem, einen, gonugau mogoi utei waneun koli aleun.’ ");
INSERT INTO bmh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mogoi kaman go banban aigsisilina, go zaueim siabun uteun. Guzenina, memeg nug alaimai, gonugau ougab naliu usalabun ze aureun. ");
INSERT INTO bmh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bo, gonug memeg aureun, ‘Iz wai asiu iz nait salau du sul salau asiu mai daremin, nait ze suban sesamoranem. Izal zaiar abai ee mis mabun meme nag ginampet tub i milanem. ");
INSERT INTO bmh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bo, nait mogoi go nait esab unum oi betei go amaharaimai, alina, nait bulumakau nag naliu wai morom.’ ");
INSERT INTO bmh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Memeg nug koli aureun, ‘Izal mogoi, na iz ibail umkoskos dacanem, izal esab dareu go unum nait. ");
INSERT INTO bmh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Igag ereg siksikab igual oigab naliu usalamau, einen, nait amai e go noumeun aimai dabelemin, ulis go koli alai dareu. Go unum waneun dabelemin, ulis koli imai emin alai dareu.’” ");
INSERT INTO bmh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ziwas tub ebu, Yesus nug gonugau tapaimaraneu dudu tatau ze guzenai awareun, “Du tub go esab asiu mui gonug, salau du tub gonugau esab gumabun zeze moroun. Go salau du go salau mina mina, dudu ipal agen go esab atag du auremen, ‘Nait salau du go aiwag gaul gaul amareun.’ ");
INSERT INTO bmh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Go ze doimai, gonugau salau du uloron, alina, aureun. ‘Iz dudu agen na en guzenai ailina, domin. Go petak ta? Go ze petak aba na izal salau du i damam. Na beteimai, inen agen izal esab gaul omen wanimag sikut wai oiba, alai milemen, piai.’ ");
INSERT INTO bmh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Salau du gonug dabilaimai, gonugau ougab eiman eneun, ‘Izal gumilaneu du go iz koli salau mabun i imailamau. Iz em abigabun gusig tamacag, iz dudu ipal ee nugarabun, aip numau. ");
INSERT INTO bmh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ulis iz abiu iz erunai, izal banou iz salau ebu koli i imailamau, izal zaiar agen go agal zau imailei bitamam.’ ");
INSERT INTO bmh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Guzenai dabeleimai, gonug dudu getal gonugau banou nugau esab gaul marena, omen, ularena, alina, gonug du tub guzenai aureun, ‘Na izal du banou gonugau esab eiceisab eiceisab omen?’ ");
INSERT INTO bmh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Du gonug koli aureun, ‘Iz ze sous mis handret tutak sag mis mabun goriai omin.’ Go salau du nug aureun, ‘Na pigai hoboiba, go getalan handret tutak sag sikut dareu hamacaiba, ulis agau awau ebu mis houhou tabkuai (50) sag sikut wai men.’ ");
INSERT INTO bmh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Guzenaimai, gonug koli du tub aureun, ‘Na esab eiceisab eiceisab omen?’ Gonug guzena aureun, ‘Iz usikekel zo handret tutak sag omin.’ Go salau du nug koli aureun, ‘Na agau awau e oimai, pigai hoboiba, zo houhou gugen (80) sag sikut wai men.’ ");
INSERT INTO bmh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Go salau du gonugau dabeleu naliu guzenaimai, gonugau du banou nug du eg gonugau wanib wag moroun. Go salau du go dabeleu naliu pet, guzeneun. E em ebuan duailel ag agtal ag isanarabun dabeleu naliu mui salau mabun iboin. Ag dudu Uwait nugau al hilanau naliu ebu daremen zilarai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iz petak pet awarem, ag agal aiwag tamacag duailel isanarabun, marebiag, go duailel ag goagal zaiagar pet damamen. Aiu ses aiwag go poaba, Uwait nug ag gonugau uzan naliu ebu imarai simau. ");
INSERT INTO bmh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Du in go esab ginampet suban gumamau, go esab banou han gumamau. Du in go salau ginampet suban i gumaneu, go salau banou han suban i gumamau. ");
INSERT INTO bmh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ag em ebuan esab eg suban gumab tam, inug ag esab naliu suban gumabun maramau? ");
INSERT INTO bmh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ag dudu ipal agal esab suban gumab tam, inug esab naliu tub agal sul dabun maramau? Du tub nug i maramau. ");
INSERT INTO bmh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Salau du tutak nug, du aliag ebalagab salau wabun iborain tam. Einen, go du tub en ougab noumaimai, du tub en ougab i noumamau. Go du tub nugau ze suban sesamoraimai, salau naliu maimai, tub semoroimai, gonugau ze suban i sesamoraneu. Ag Uwait nugau salau mui, aiwag en salau mui ereg gotulai wabun iborain tam pet.” ");
INSERT INTO bmh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisi dudu ipal go aiwag en oiagab noumemen. Guzenaimai, ag go ze doimai, goagen Yesus weloromen. ");
INSERT INTO bmh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus nug go uligaraimai, koli awareun, “Ag agal dabeleu, ag dudu ipal agal amiagab dudu naliu anemen, Bo, Uwait go agal dabeleu oiagab eiman dareu abiu mareun. Dudu goagal dabeleu esab banou wabun dabeleu, go esab Uwait nugau ameg ebu eg pet. ");
INSERT INTO bmh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Getal duailel agen Moses nugau kasai ze nanalanem mui Uwait nugau ze doimai, awaranemen dudu agal ze umkoskos maranem. Go guzenina guzenina, Zon zoun. Zon zondai, ulis izan Uwait nugau gumaraneun ze marai aidarena, duailel asiu Uwait nugau duailel usalabun gusig macanemen. ");
INSERT INTO bmh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","E em Mesgai mui tamamau, bo, Uwait nugau kasai ze ginampet tub i kaiamau.” ");
INSERT INTO bmh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Du gonugau air uteimai, air tub umau go du duair egarabun agal kasai ze etuborou. Du in go air tub gonugau gamu nug uteun, umau, go mui guzenai go kasai ze etuborou.” ");
INSERT INTO bmh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Du tub go esab asiu mui dacaneun, go tibur galau naliu naliu maneu, umkoskos suban siksikaneu. ");
INSERT INTO bmh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Du tub esab tamacag gonugau wanib Lasarus, gonugau enib ebu sug asiu mina, eg wai dareun. Go du go aiwag asiu mui nugau zau og daneu. ");
INSERT INTO bmh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Go du go aiwag asiu mui du ee zendai, ee sib eebiz pigsal nondai, uligaimai, go ee sib zabun dacaneu. Bau alaimai, gonugau sug helwanem. ");
INSERT INTO bmh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Esab tamacag du noumeun ziwas ebu, gonugau dorog Uwait nugau tibur agen imai aimai, Abraham dareu ebu Mesgai wag imai siemen. Dai dai, du banou go mui noumina, ob oug hemen. ");
INSERT INTO bmh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Gonugau dorog ab banban ele dareun ebu noun. Go eiman go Lasarus Abraham dual naliu atai pulig darena, uligareun. ");
INSERT INTO bmh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Guzenaimai, du gonug uleun, ‘Mekai Abraham, iz e ab ebu mu asiu oi darem, iz en bisom peiba, Lasarus auremen, alai gonugau ebeg sil ze pataimai, izal minom ebu mamau.’ ");
INSERT INTO bmh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham nug koli go du aureun, ‘Izal mogoi, na getal em ebu daimai, esab asiu unum oimai, siksikai daremen, na go dabelen. Lasarus go esab tamacag gaul bisoua dareun, gonun, ulis go e uzan siksikai dareu. Na mu banban oi darem. ");
INSERT INTO bmh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ig e ula emgelez banou dareu, dudu e ebu daremen ag go emgelez kuanai bitabun iborain tam, agen mui e ebu kuanai alabun iborain tam.’ ");
INSERT INTO bmh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Du gonug koli Abraham aureun, ‘Guzenaba, iz na aizem. Mekai Abraham, koli Lasarus palautemen, noimai, izal ataiar awaraba, oiagab kekulabun awaramau. ");
INSERT INTO bmh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Go ebu izal magite apaiter tabkuai sag darem ebu noimai, awaraba, go mui iz mu oi darem ebu i alamam’ ");
INSERT INTO bmh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham nug koli go du go aureun, ‘Nait atanar getal Moses nugau kasai ze mui Uwait nugau ze doimai, awaranemen dudu agen ze sikut wai memen go uligaimai, sesamorianemen. ");
INSERT INTO bmh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Du gonug koli Abraham aureun, ‘Mekai Abraham, go iboin tam, go ze i sesamoramam, bo, du tub noumeun usaimai, betei go awaraba, go petak goagal zigulin macanemen ebuan koli goagal oiagab kekulamau.’ ");
INSERT INTO bmh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham nug koli eneun, Ag Moses nugau ze mui, Uwait nugau ze doimai, awaranemen dudu agal ze i sesamoranemen, du tub noumeun, koli usamau mui uligaimai, agal oiagab i kekulamau.’” ");
INSERT INTO bmh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ziwas tub ebu, Yesus nug gonugau tapaimaraneu dudu awareun, “Igul ata atai duailel zigulin marabun zumau. Du go inug go zigulin oi alamau, go du go bisoua pet. Uwait nug go du eg muramau. ");
INSERT INTO bmh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Du tub nug mogoi ginampet tub zigulin abai murabun aba, go zigulin eg pet. Dudu ipal agen aiwag uhu oimai, du gonugau beu ebu us sil otoi maimai, go ze unig oug hamacebiag, numau, go iboi, go uhu ginampet. Tam aba, aiu ses go uhu banou pet umau. ");
INSERT INTO bmh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ag ein igul macanemen, suban dabelen. Nait zaun go zigulin maba, nagen go zigulin mem auren. Go koli gonugau ougab kekulaimai, alaba, nagen gonugau zigulin go zilagai moren. ");
INSERT INTO bmh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bo, gonug na gil tutak ebu zigulin kwali mizeimai, gonug koli na wautab koli koli alaimai, aizaimai, ‘Zai, iz bisom pen,’ guzenaba, na gonugau zigulin unum zilagai moren.” ");
INSERT INTO bmh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesus nugau ze oi aidanemen dudu agen Dubanou Ban auremen, “Na igual oigab petak abun gusig migen.” ");
INSERT INTO bmh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesus nug koli awareun, “Agal oiagab petak eun, go ag a ug ginampet paipai sulai, ag e weli a bigeg auraimai, ‘Na silacaib, ibut ze unig banou ebu betei tapai dan.’ auremen, gonug agal ze sesamoramau.” ");
INSERT INTO bmh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Du tub ag ula abai dareu go salau du tub mui. Go salau du go ougem salau macaneu du ta, sipsip gumaneun du dacaneu ta, umusig salau poaimai, zaueim zondai, nagen ‘Na pigai zoimai, biz ebu zo hoboiba, nait ee zen’ guzenai auranemen ta? ");
INSERT INTO bmh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tam pet. Na go guzenai auramam, ‘Na izal ee mis men. Na tibur galau naliu tugaiba, iz ee zemin, gumilai dacan. Iz ee zeminag, aiu ses na ee zamam.’ ");
INSERT INTO bmh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Salau du gonug gonugau du banou nugau ze sesamoraimai, gonugau salau tutak pataneun. Du banou gonug koli gonugau salau du salau macaneu gonugau wanib wag i maneu. ");
INSERT INTO bmh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Agen mui guzental guzenan, Dudu ipal agen ag salau mabun awarebi, salau maimai, enan, ‘Iz salau du wanim banou tamacag, iz gaul salau oi darem an.’” ");
INSERT INTO bmh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus go Zerusalem ban uzan betei daimai, go Samaria agaig mui, Galili agaig ula beteun. ");
INSERT INTO bmh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Go uzan tub simai, dudu houhou go ebeu leprosi mui atai tubaiman sul tapai daremen tulareun. ");
INSERT INTO bmh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Go agen ulaimai, enemen, “Yesus, du banou, ig bisomig peiba, ig isanigen.” ");
INSERT INTO bmh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus nug uligaraimai, awareun, “Ag beteimai, Uwait ula dacanemen dudu ameagab go ebu agal enimag abai maran.” Go beten beten, go ebeu leprosi wanemen. ");
INSERT INTO bmh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Du tutak go uligeun gonugau ebeu eg wanena, go koli alaimai, gusig ulaimai, Uwait ulagwag moroun. ");
INSERT INTO bmh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Alaimai, em ebu Yesus nugau arab ebu taubib aimai, ulagwag moroun. Du go Samaria agaigan. ");
INSERT INTO bmh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Guzenina, Yesus nug eneun, “Dudu houhou kasaremin, dudu nigbasig go eru wanemen? ");
INSERT INTO bmh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","E Samaria du go tubwagan. Einen nugtal alaimai, Uwait ulagwag morou?” ");
INSERT INTO bmh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesus nug go du aureun, “Na asaimai, alien. Na nait ounab petak emen, gonun, na naliu usalem.” ");
INSERT INTO bmh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi dudu ipal agen Yesus kanabai aureun, “Uwait koli gumigabun eisab alamau?” Gonug koli awareun, “Uwait koli ag gumarabun alaba, ag go amiag nug i pimamen. ");
INSERT INTO bmh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Du tub nug i aizamau, e zou alai pian, ulib go zou pian. Bo, ag go don, Uwait ag gumarabun ulis ag waiagab zoi dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Guzenai awaraimai, gonug gonugau tapaimaraneu dudu awareun, “Ziwas tub zumau go ebu agal dabeleu go Du Nugau Nag piabun amamen, bo, ag go i pimamen. ");
INSERT INTO bmh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dudu ipal agen awaramam, ‘Ulibe pian!’ ‘E ebu pian!’ Ag go dudu agal ze doimai, petak aimai i sesamarai bitan. ");
INSERT INTO bmh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Du Nugau Nag alamau ziwas ebu, emes kulalaimai, amilaimai, tuba tuba eim bitaneu sulai, Du Nugau Nag alamau ziwas ebu, go igul pet guzenai alamau. ");
INSERT INTO bmh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bo, amegai go mu asiu oimai, e em ebuan dudu banban agen go webiag, noumamau. ");
INSERT INTO bmh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Getal Noa dareun ziwas ebu, duailel agen guzenemen sul, ulis mui Du Nugau Nag alamau ziwas ebu guzental guzenamamen. ");
INSERT INTO bmh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Duailel ag ee zai daremen, ze zai daremen, duair egarai daremen, go guzenai darena darena, Noa go tebil oug sina, zewei banou nug alaimai, duailel unum egarai zendai, noumemen. ");
INSERT INTO bmh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot dareun ziwas ebu mui guzental guzenemen, duailel unum ze ee mui zaimai, siksikai daremen. Ee gau maimai, esab koli aiwag en maraimai, ougem ee ug bai darem, zau awau mai mai, siksikai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ziwas go ebu, Lot go uzan utei wanena, ab banou salpa mui Mesgai wageman alaimai, gonun duailel unum elarena, noumemen. ");
INSERT INTO bmh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ag guzenai daremen pet, ulis mui guzental guzenebi, guzenebi, Du Nugau Nag go araog alamau. ");
INSERT INTO bmh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ziwas go ebu, du go zau wag damau, gonugau esab zaueim dareu wabun i numau. Du tub go ougem damau, koli gonugau iweiu naliu wabun uzan i bitamau. ");
INSERT INTO bmh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ag Lot nugau air en dabilan. ");
INSERT INTO bmh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Du in go gonugau dorog iz en i noumeun, du go gonugau dorog unum tamamau. Du in go gonugau dorog iz en noumamau, gonugau dorog muzmuz awau damau. ");
INSERT INTO bmh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iz petak pet awarem, go ziwas ebu umaum, du aliag go biz tutak ebu ninamam, Uwait nugau tibur agen tub imai aimai, tub utei unamam. ");
INSERT INTO bmh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Air aliag go ma sakai damam ebu, air tub alai imai aimai, air tub utei unamam.  ");
INSERT INTO bmh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Du aliag go ougem salau mai damam, tub imai aimai, tub utei unamam.” ");
INSERT INTO bmh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Go ze doimai, gonugau tapaimaraneu dudu agen kanabai aurem, “Dubanou Ban, go igul erueim zumau?” Yesus nug koli awareun, “Eru ebu egun noumaimai, beleimai damau, go ebu tumui asiu go egun beleu zabun betei gotulamam.” ");
INSERT INTO bmh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus nug tatau ze tub gonugau tapaimaraneu dudu go umkoskos Uwait aurebi, gonug ag pigai i isanaraba, agal oiagab eg i umau aimai awareun. ");
INSERT INTO bmh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Gonug eneun, “Ban uzan tub, ze sisiaraneun du tub go Uwait nugau ze i sesamoraneu. Dudu ipal agal ze doimai, suban i isanaraneu. ");
INSERT INTO bmh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Go uzanan wab air tub go umkoskos du go ebu alaimai, auraneu, ‘Izal iwai zai nug iz eg milamoroi na iz isanilen.’ ");
INSERT INTO bmh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Du gonug pigai air go isanurab tam. dai dai, gonugau ougab ougeiman dabilaimai, eneun, ‘Iz Uwait nugau ze i sesamoranem, ipal duailel en i dabilanem. Iz abiu go petak, bo, e wab air go iz salau banou milaneu, gonun, iz go isanurai. Go i isanoromin, umkoskos iz waiab alaba, iz wasig ilamau.’” ");
INSERT INTO bmh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesus nug koli eneun, “Ag go, ze sisianeun du eg nugau ze go don. ");
INSERT INTO bmh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Uwait nug gonugau duailel egareun, agen ziwas umkoskos amban, umaum isanarabun weinebi, gonug ag isanarabun iboin ta? Ziwas huia dai dai isanaramau ta? ");
INSERT INTO bmh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iz petak pet awarem, goagal weinemen doimai, pigai isanaramau. Aiu ses Du Nugau Nag koli alamau ziwas ebu, go e em ebuan duailel agal oiagab petak emen pimam ta, tam ta?” ");
INSERT INTO bmh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus nug duailel ipal agtal enanem go dabeleu goagal igul unum naliupet anem, du ipal agal zigulin eg en tatau ze mareun. ");
INSERT INTO bmh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ziwas tub ebu, du aliag Uwait aurabun Nou zau oug siemen. Du tub go Parisi du, du tub go takis aiwag waneun du. ");
INSERT INTO bmh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi du go nugtal tapai daimai, Uwait auraimai, eneun, ‘Uwait, iz na “Izal oiab naliupetpet” aizem. Iz ipal dudu sul tam. Iz polu i maranem, esab gaul i wanem, kasai ze i utanem. Iz ipal agal ailel i imarai aidanem. Guzenaimai, iz na “Izal oiab naliupetpet” aizem. Iz go aiwag wanem du ulib tapai dareu sul tam. ");
INSERT INTO bmh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iz Zobu tutak ebu gil aliag na wanim wag maimai, ee urmanem. Na wanim wag mizanem, izal esab unum houhou doun mizanaraimai, tutak sul na mizanem.’ ");
INSERT INTO bmh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aiwag waneu du go tubaiman tapai daimai, gonugau aiu Mesgai wag i meun, go ougab bisolilai eneun, ‘O, Uwait Banou, iz zigulin eg mui, na iz isanilen.’ ");
INSERT INTO bmh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iz petak pet awarem, go aiwag waneun du, go Uwait nugau ameg ebu naliupet usaleun, Parisi du go tam. Einen, du in go nugtal gonugau ulag zaneu, du gonugau wanib Uwait amegwab banou i damau. Du in go nugtal gonugau wanib ulag i zaneu, du go wanib wag damau.” ");
INSERT INTO bmh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Duailel ipal agal geleagar Yesus nug gonugau ebeg go agal gagaliag ebu, gonugau gusig marabun imarai alemen. Gonugau tapaimaraneun dudu agen go duailel piaraimai, zamaremen. ");
INSERT INTO bmh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Guzenina, Yesus nug go geleagar go igul guzenemen uligaimai, ularen, alina, gonugau tapaimaraneun dudu guzenai awareun, “Agal geleagar utarebiag, iz waiab zumam, ag i pataran. Duailel ag geleagar e sulai kekulan, go abiu Uwait agal gumaraneu du banou. ");
INSERT INTO bmh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iz petak pet awarem, duair inen go mogoi ginam sulai kekuliem, Uwait nug gonugau gumabun du banou i damau.” ");
INSERT INTO bmh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Zuda agal gumaraneun du banou tub zoimai, Yesus kanabai aureun, “Du naliu, iz erunaimai, izal dorop awau muzmuz damau?” ");
INSERT INTO bmh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus nug du go koli aureun, “Na einen iz du naliu ailem? E em ebuan du tub go naliu tam. Uwait tutak naliu. ");
INSERT INTO bmh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na kasai ze abiu, ‘Na du tub nugau air i imai aidan, na du tub webenag, i noumamau, na dudu ipal agal esab i zob on, na du tub nugau enibwag polu ze i men, nait memen anan agal ze unum sesamoren.’” ");
INSERT INTO bmh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Du gonug koli aureun, “Getal iz ginampet ebu, go kasai ze unum sesamorai alai, ulis mui guzental darem.” ");
INSERT INTO bmh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus go ze go doimai, koli aureun, “Go iboi, igul tutak na zilaize dareu. Na betei, nait esab unum dudu ipal mareben, goagen esab gau mebiag, aiwag go oiba, dudu esab tamacag aiwag go dou maren. Na go guzenamam, aiu ses na Mesgai wag esab asiu umam. Go igul guzenaimai, na alai iz sesamilen.” ");
INSERT INTO bmh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Du go gue esab asiu mui. Gonun, go ze doimai, gonugau ougab uhu meun. ");
INSERT INTO bmh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus nug du gonugau ougab uhu mina peimai, eneun, “Dudu esab asiu mui ag Uwait nugau gumarabun en, salau gusig umamen. ");
INSERT INTO bmh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Egun tub kamel go tibur galau sopwanem kulam nugau biag ougeiman siabun anmamau. Du aiwag asiu mui go Uwait nugau du pet usalabun go salau gusig ban umau’ ");
INSERT INTO bmh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dudu go ze doimai, goagen kanabemen, “Go petak aba, Uwait nug du in imai aimai, go dual ereg muzmuz damau?” ");
INSERT INTO bmh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus nug awareun, “Ein igul dudu agen guzenabun iborain tam, Uwait nugtal guzenabun go iboin.” ");
INSERT INTO bmh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Guzenina, Pita nug eneun, “Ig igual uzanan igual esab unum uteimai, na sesamizai alemun.” ");
INSERT INTO bmh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Yesus nug eneun, “Iz petak awarem, du in go Uwait nugau duailel kekulabun en dabeleimai, gonugau uzan, wau, amagul, apagul, memegul unum utarai, aleun, Uwait nug ulis em e ebu go esab utei aleun sul asiu kolital muramau. Gonug koli go dorog awau muzmuz dabun gusig muramau.” ");
INSERT INTO bmh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus nug gonugau tapaimaraneu dudu begurug gasag imarai beteimai, guzenai awareun, “Ag go don, igag Zerusalem uzan siab. Go ze getal Uwait nugau ze doimai, awaranemen dudu agen Du Nugau Nag en anemen, go ze unum ulis petak zumau. ");
INSERT INTO bmh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Zerusalem uzanan dudu agen go emgasag tub ebuan dudu banban agal ebeagab ebu muramam. Goagen go du ze biabial kuai auraimai, igul eg moromai, enib ebu sino uramam. ");
INSERT INTO bmh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Goagen du go esalau sul oimai, webiag, noumamau. Bo, gil ianai ainarai ebu, go koli usamau.” ");
INSERT INTO bmh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Gonugau tapaimaraneu dudu go ze go doimai, gonugau zebigeg ag abiu mab tam. Go ze, zebigeg go ebalagab wageimai dareun. Go Yesus nug go ze awareun suban dabelab tam. ");
INSERT INTO bmh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus go Zeriko uzan zoimai, du tub ameg kumi go abu ebu hoboi daimai, esab en nugacaraneu. ");
INSERT INTO bmh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Go duailel abu ebu aidarena, doimai, gonug kanabeun, “Go ein erunem?” ");
INSERT INTO bmh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Goagen koli auremen, “Nasaret uzanan Yesus aleu.” ");
INSERT INTO bmh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Gonug ulaimai, eneun, “Yesus, Devit nugau Mogoi, na iz en bisom peiba, iz isanilen.” ");
INSERT INTO bmh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dudu ipal amegai go waugab betemen agen kagagai, auremen, “Na soen.” Bo, go du nug koli banou uleun, “Yesus, Devit nugau Mogoi, na iz isanilen.” ");
INSERT INTO bmh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Guzenina, Yesus nug eneun, du go ameg kumi go waugab imai alabun awareun. Go waugab imai alina, Yesus nug aureun, “Izan na erunizai en ailem?” Gonug koli eneun, “Banou, iz koli ame waipemen, abu piai.” ");
INSERT INTO bmh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Guzenina, Yesus nug aureun, “Nait ounab petak emen, gonun, na koli amen waipaba, abu pen.” ");
INSERT INTO bmh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Go guzenina, pigai ameg waipina, go koli em uligeun. Guzenaimai, go Uwait ulagwag moroimai, Yesus sesamor beteun. Duailel go igul uligaimai, go unum Uwait ulagwag moromen. ");
INSERT INTO bmh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus go Zeriko uzan simai, Zerusalem uzan unabun waneun. ");
INSERT INTO bmh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Go uzan du tub go takis aiwag waneun du, gonugau wanib Sakias, go aiwag asiu mui. ");
INSERT INTO bmh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesus go du ein sul, alai dareu piabun beteun. Sakias go du paiwa tam, go hogupet. Guzenaimai, duailel asiu agen Yesus tapelorona, go piabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gonun, go pigai amegai beteimai, a tub huia peimai, go a wag sieun, Go abiu Yesus go a go waugab alamau. ");
INSERT INTO bmh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus go a go waugab zoimai, go a wag Sakias dareun uligaimai, aureun, “Sakias, na a wageiman pigai non. Iz ulis umaum nait zau ninai.” ");
INSERT INTO bmh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Guzenai aurina, Sakias go a wageiman pigai noimai, go siksikaimai, Yesus gonugau zaueim imai beteun. ");
INSERT INTO bmh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dudu ag go igul uligaimai, aiag sisilaimai, enemen, “Du go zigulin macaneu du gonugau zau ee zabun beteu.” ");
INSERT INTO bmh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakias nug go ze doimai, asaimai, Yesus aureun, “Banou, izal esab unum ianaimai, dudu ipal esab tamacag bisomagar mui darem marai. Iz getal dudu ipal polumaraimai, goagal esab gaul zob omin, koli go esab omin mui esab ipal asiu mui marai.” ");
INSERT INTO bmh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus nug koli eneun, “E du e mui go ig sul, Abraham nugau ug. Petak, ulis duailel e zauan Uwait nug koli imareu. ");
INSERT INTO bmh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Du Nugau Nag go dudu kaiemen itanaraimai, imarabun aleun.” ");
INSERT INTO bmh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Duailel go ze duna duna, Yesus nug tatau ze tub mareun. Go Zerusalem uzan waugab dareun. Guzenina, dudu agal dabeleu Uwait nug ulis gonugau duailel gumarabun aleu anem. ");
INSERT INTO bmh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Guzenaimai, gonug awareun, “Du tub go gumaraneu du gonugau ug. Go emgasag pulig gonugau ban uzan gumabun wanib wabun beteimai, koli alabun dabeleun. ");
INSERT INTO bmh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Go unabunaimai, gonugau salau dudu houhou ul araimai, go waugab betena, tutak tutak aiwag tausen aliag sag maraimai, awareun, ‘Ag e aiwag marem salau moron. Iz koli alaimai, wai.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Gonugau uzanan dudu agen agal oiagab go en noumab tam. Guzenaimai, dudu agen dudu ipal palautarena, beteimai, emgasag tub go beteun ebuan dudu awaremen, ‘Ig du go gue ig gumigabun tapai murab tam.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Du go gonugau emgasag gumarabun wanib oimai, koli aleun. Go koli alaimai, salau dudu go aiwag marai waneun, salau maimai, ipal aiwag om ta, tam ta darem abiu mabun ularena, go waugab zomen. ");
INSERT INTO bmh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Du tub amegai zoimai, eneun, ‘Banou, aiwag go tausun aliag sag milemen salau maimai, koli aiwag tausen aliag sag omin.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Du banou go siksikaimai, aureun, ‘Go naliu, na salau du naliu, na esab ginampet suban gumemen, gonun, na uzan houhou gumamam.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Salau du tub zoimai, eneun, ‘Banou, aiwag go tausen alaig sag milemen salau maimai, aiwag tausen tutak sag omin.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Du banou gonug aureun, ‘Na go uzan tabkuai gumamam.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Salau du tub zoimai, eneun, ‘Banou, nait aiwag milemen tibur galau zig sil otwaimai, wageimai mizemin, e dareu. ");
INSERT INTO bmh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Iz na uminizeimai, guzenemin, einen, na du pigai ainsisilaneu. Dudu ipal agen esab mina, dacaneu, na gaul wanem. Dudu ipal agen ee ug bemen, na ee gaul wanem. Guzenaimai, iz na uminizeimai, go igul guzenemin.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Gonug koli aureun, ‘Na salau du eg, nait ze nugtal koli nag sisicizamau. Na abiu, iz pigai aisisilaneu, ein esab izal tam iz gaul wanem, gonun, na einen izal aiwag, aiwag zau ban ebu milab utemen? Iz koli guzenai alemin, aiwag go mui, ipal aiwag mui ereg wai.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Gonug gonugau gumaneu dudu waugab tapai darem awareun, ‘Go aiwag gonugau ebeg ebuan ebegalau oimai, go salau du aiwag tausen iwanarai sag go moron.’ ");
INSERT INTO bmh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Go agen koli du go auremen, ‘Banou, du go gue aiwag tausen iwanarai mui!’” ");
INSERT INTO bmh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Gonug koli awareun, “Iz petak pet awarem, du in go esab asiu mui, go salau macaneu, du go gue Uwait nug esab ipal asiu pet muramau. Bo, du in go esab tamacag go ginampet mui, go salau i macaneu, Uwait nug du go ebuan esab unum ebegalau umau. ");
INSERT INTO bmh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ulis, go dudu getal iz e ban uzan i gumai aimai, iwai milemen, go dudu imarai alaimai, iz ameab wagarebiag, noumamam.” ");
INSERT INTO bmh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus go tatau ze go awaraimai, amegai Zerusalem uzan siabun beteun. ");
INSERT INTO bmh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Go em tub wanib Betpage mui Betani uzan em manam wanib Oliv ebu zoimai, gonugau tapaimaraneu du aliag amegai palautaraimai, awareun, “Ag uzan tubaiman dareu ebu beteiban, donki nag tub asai memen dareu, imai alan. ");
INSERT INTO bmh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Du tub nug ag go donki nag einen omen aimai kanababa, agen koli auran, ‘Igual Banou nug e donki salau mui eun.’” ");
INSERT INTO bmh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Go beteimai, Yesus nug ze awareun sultal pemen. Go beteimai, go donki nag us sil asai memen us waitulena waitulena, go donki atag du zoimai, awareun, “Ag us donki ebuan einen waipemen?” ");
INSERT INTO bmh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","(-) ");
INSERT INTO bmh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Goagen koli du go auremen, “Igual Banou nug go donki salau murabun eun.” ");
INSERT INTO bmh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Go donki nag go Yesus waugab imai beteimai, goagal ipal tibur galau wagan go donki nugau bugazig ebu kuloromina, Yesus nugau ebeg patena, go donki wag simai hoboun. ");
INSERT INTO bmh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Go donki eiman bete betena, duailel agen goagal tibur galau abu ebu tapai bitabun duei betemenin. ");
INSERT INTO bmh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Go Zerusalem uzan waugab, em manam Oliv nugau abu waugab beteun. Gonugau tapaimaraneu dudu mui duailel unum go igul ata atai gonug getal meun pemen, gonun, siksikaimai, Uwait nugau wanib ulagwag moroimai, betemenin. ");
INSERT INTO bmh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Goagen enemen, “Ig e gumigabun du banou, Uwait Banou nugau wanib ebu aleu ulagwag murab. Mesgai wag agal oiagab iau selai damau. Uwait nugau wanib wag pet ulagwag murab.” ");
INSERT INTO bmh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Goagen go igul guzenina, ipal Parisi dudu agen Yesus auremen, “Du banou, nait tapaimaranemen dudu awaremen, soamam.” ");
INSERT INTO bmh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesus nug koli awareun, “Iz petak pet awarem, ag go soamam gue, e aiwag abu ebu darem agtal ulaimai, Uwait nugau wanib ulagwag muramam.” ");
INSERT INTO bmh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Yesus go Zerusalem uzan uligaimai, bisou banou peimai, eneun, “Ag ulis ein igul oiagab iau selai dabun abiu mamamen, go naliu. Bo, e igul wageimai dareu, ag piabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ipal ziwas zumau, nait iwai zaunar agen aiag sisilaimai, zoi unum eg mizamam. Goagen aiwag sil gilan kolilai manem sul, tubaim tubaim kualilaimai katizamam. ");
INSERT INTO bmh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Goagen zoimai, na unum eg mizeimai, nait duailel go ebu darem unum wagarebi, noumamam. Aiwag tub go ebu dareu gonugau pip utebi, i damau. Uwait nug ag imarabun aleun, ag abiu i memen. Guzenemen, go uhu umamen.” ");
INSERT INTO bmh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus nug go ze maziaimai, Zerusalem uzan sieun. Yesus go Nou zaueim simai, dudu esab gau mai daremen zamarendai, unum uminai wanemen. ");
INSERT INTO bmh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Gonug awareun, “Getal Uwait nugau ze sikut wai memen, ‘Uwait nug eneun, “Izal zau go duailel agen iz ibail ze mabun zau,” ’ bo, agen ‘e zob dudu agal wageimai dabun zau sul’ usalai memen.” ");
INSERT INTO bmh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ziwas betei betei, Yesus go Nou zaueim go simai daimai, Uwait nugau ze duailel tapaimareun. Uwait ula dacanemen dudu banban mui, kasai ze abai maranem dudu mui, duailel gumaranem dudu banban agen Yesus wabun en ze patai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bo, ag go igul guzenabun abu tub piab tam. Einen, duailel go umkoskos Yesus nugau ze duanem. Goagen gonugau ze tub utabun sul iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Ziwas tub ebu, Yesus go Nou zaueim duailel ze tapaimaraimai, Uwait nugau Ze Naliupet marai dareun. Uwait ula dacanemen dudu banban mui, kasai ze abai maranem dudu mui, gumaranem dudu banban ipal, agen alaimai, Yesus auremen, “Na ein gusig oimai, go igul guzenanem? Inug na gusig mizeun? Na ig aigen.” ");
INSERT INTO bmh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Yesus nug koli guzenai awareun, “Izan mui ag en kanabem. Iz ailan, Zon go ze ziwaraneun du, go Uwait nug gusig moroun ta, atai, dudu agen gusig moromen?” ");
INSERT INTO bmh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Guzenina, agzozou ze maimai, enemen, “Ig go ein ze aurab? Go Uwait nugau gusig ebu ze ziwaraneun emun, gonug aigamau, “Guzenaimai, ag einen agal oiagab petak ab tam.” ");
INSERT INTO bmh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bo, ig go du nugau gusig ebu emun, e duailel agen ig aiwag sil iguebiag, noumab, einen, ag Zon go Uwait nugau ze doimai, awaraneun du aimai gusig dabilanem.” ");
INSERT INTO bmh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Guzenaimai, goagen enemen, “Zon inug gusig moroun ig i abiu.” ");
INSERT INTO bmh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus nug koli awareun, “Iz han, inug iz gusig milena, go igul guzenanem ag i awarai.” ");
INSERT INTO bmh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesus nug go tatau ze duailel maraimai, awareun, “Du tub go wain wai maimai, dudu ipal go wai ebu salau mabun gau maraimai, salau mina mina, nug emgasag pulig betei ziwas asiu dareun. ");
INSERT INTO bmh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wain dab wabun ziwas zuna, go wai atag du nug gonugau salau du tub go wain wai ebu salau mai daremen dudu waiagab ipal wain dab oi morobi, oi alabun en, palautendai, beteun. Bo, go wai gumei daremen dudu agen go salau du waimai, wain dab tamacag mui gaul palautoron, beteun. ");
INSERT INTO bmh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Guzenina, koli salau du tub palautendai, beteun. Go mui guzental waimai, eg moroimai, gaul palautoron, beteun. ");
INSERT INTO bmh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Guzenina, gonug koli tub palautendai, beteun. Go mui guzental guzenemen. Goagen go mui waimai, uzaneim hamacina, noun. ");
INSERT INTO bmh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Guzenina, go wain wai atag du nug eneun, ‘Iz erunai? Izal nagwai tutak izal oiab nug go en noumanem palautanai. Go gonugau ze doimai, i eg muramam.’ ");
INSERT INTO bmh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Guzenaimai, gonugau nag tutak palautendai, beteun. Go dudu agen gonugau mogoi uligaimai, agzozou enemen, ‘Go wai atag du nugau nag aleu. Gonugau memeg noumaba, gonug gonugau memeg nugau esab unum umau, gonun, ig go wemun, noumaba, e wain wai igual usalamau. Ke, ig guzenab.’ ");
INSERT INTO bmh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Guzenaimai, goagen go mogoi wain wai ebuan imai noimai, wai gasageim wina, noumeun. Yesus nug kanabareun, ‘Go wain wai atag du nug go salau dudu erunaramau? ");
INSERT INTO bmh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Go alaimai, go salau dudu unum wagaraba, noumebi, go wain wai dudu ipal agal ebeagab ebu mamau.’” Duailel go tatau ze doimai, enemen, “Go igul i guzenamau.” ");
INSERT INTO bmh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus nug go gusig uligaraimai, kanabareun, “Go ze Devit nug getal sikut weun, gonugau zebigeg ein eu? ‘Go zau sanag zau macanemen dudu agen eg aimai, gasag memen. Ulis, go zau sanag ula ebuan zau gusig naliupet usaleun.’ ");
INSERT INTO bmh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Du in go zau sanag ebu arab tuaimai ebu alai numau, go duair unum kitkuatarai sibsib mamau. Go zau sanag nug du tub enib ebu numau, du go gue emwaibul pet usalamau.’” ");
INSERT INTO bmh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kasai ze abai maranem dudu mui Uwait ula dacanemen dudu banban agen mui Yesus go ebutal gusig pataimai, auremen, einen, ag abiu go tatau ze goagal go igul en awareun. Goagen duailel uminaraimai, ag go ebu gusig patab tam. ");
INSERT INTO bmh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Guzenaimai, go dudu ipal gau maraimai, palautarena, alemen. Go dudu agen ig dudu naliu abun aimai polumaimai, Yesus pei daremen. Go ein ze polumaba, gusig pataimai, emgasag agal du banou ebu imai betabun aimai guzenemen. ");
INSERT INTO bmh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Go gau maremenin dudu agen alaimai, Yesus kanabai auremen, “Banou, ig abiu nait ze abai miganem, go petak. Ig abiu na dudu banban i uminaranem, na Uwait nugau igul tutak petak abai miganem. ");
INSERT INTO bmh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nait dabeleu erunai pet? Moses nugau kasai ze ebu, ig Rom agal gumarabun du banou aiwag murabun iboin ta, tam ta?” ");
INSERT INTO bmh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Yesus nug koli goagal polu ze abiu maimai, awareun, “Iz aiwag tub abai milan. E aiwag ebu inugau dorog wanib mui dareu?” Go agen koli auremen, “Sisar nugau.” ");
INSERT INTO bmh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesus nug awareun, “Ein esab Sisar nugau go Sisar moron, ein esab Uwait nugau go Uwait muramamen.” ");
INSERT INTO bmh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Go duailel agal amiagab gonugau ze doimai gusig patabun iborain tam, ag gonugau ze awareun doimai, dabeleu asiu oi daremen. ");
INSERT INTO bmh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Ipal Zuda agal dudu banban, wanimag Sadiusi, agen enanem, dudu noumanem koli i usamam anem. Sadiusi dudu ipal agen alaimai, Yesus auremen, “Banou, Moses nugau kasai ze ebu guzenai sikut weun, ‘Du tub gonugau wau mogoi i morou noumai utei unaba, gonugau amag nug apag nugau wau oimai, mogoi muramau. Go mogoi go du noumeun nugau sul usalamau.’ ");
INSERT INTO bmh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bo, ziwas tub du tub gonugau gelegul kwali a. Mogoi kaman air oimai, go mogoi i morou noumeun. ");
INSERT INTO bmh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Guzenina, gonugau amag nug air go oun. Go mui mogoi i morou noumeun. ");
INSERT INTO bmh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Guzenina, amag tub nug go air oun, go mui mogoi i morou noumeun. Guzenaital betei go dudu kwali go air tutak omen unum mogoi i morou, noumemen. ");
INSERT INTO bmh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Go dudu unum noumina, go air ses noumeun. ");
INSERT INTO bmh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Go air tutak dudu kwali agen omen, aiu ses noumemen duailel usamam ziwas ebu wasebi, go in nugau air damau? Em ebu, go dudu kwali noumemen agen air go tutak omen.” ");
INSERT INTO bmh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus nug kolital awareun, “Ulis duailel awau daimai, ag petak duair egaramamen. ");
INSERT INTO bmh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Go duailel naliu ag noumaimai, aiu ses awau muzmuz dabun usamamen, ag koli i duair egaramamen. ");
INSERT INTO bmh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ag Uwait nugau tibur sul usalaimai, koli i noumamamen. Ag noumaimai, usamamen ebu, ag Uwait nugau gelegul awau muzmuz damamen. ");
INSERT INTO bmh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses nug dudu noumemen, usamam en aneun. Ulis go ze araog dareu. Getal ab al a ginampet ebu elena, Moses go Banou wanib guzenai maimai, eneun, “Abraham, Aisak, Zekop agal Uwait.” ");
INSERT INTO bmh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gonugau ze nug ig abai migeun go enai, Banou go dudu noumemen agal Uwait tam, dudu muzmuz awau damamen agal Uwait. Gonugau ameg ebu go embigeg noumemen go unum awau darem.” ");
INSERT INTO bmh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ipal kasai ze abai maranemen dudu agen enemen, “Du banou, go ze anem naliu.” ");
INSERT INTO bmh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Guzenaimai, du tub nug Yesus ze tub koli kanababun uminemen. ");
INSERT INTO bmh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesus nug duailel awareun, “Einen duailel agen Kristus go Devit nugau Nag anemen? ");
INSERT INTO bmh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Devit go nugtal Buk Song ebu guzenai sikut waimai, eneun, ‘Uwait Banou nug, izal Banou aureun, “Na izal ebe naliu eiman hoboi damenag, izan nait iwai zaunar unum zilacaraimai, nait aram ebu pinsal damam.” ’ ");
INSERT INTO bmh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit go nugtal eneun, ‘Kristus go izal Banou’ gonun, erunaimai, agen go gonugau nag emen?” ");
INSERT INTO bmh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Duailel go unum ze doi darena darena, Yesus nug gonugau tapaimaraneu dudu awareun, “Ag kasai ze abai maranem dudu agal igul suban pian. Go dudu go tibur galau naliu maimai, siksikai aidanem. Duailel agen go dudu abu ebu ta, igwanem empip ebu ta zoi piarena, ameagab taubib wanem, go dudu agen siksikanem. Go Zuda duailel agal gotulanemen zaueim ta, ee zabun zaueim ta zoimai, hubabun pip naliu wanem. ");
INSERT INTO bmh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bo, go dudu goagen wab ailel polumaraimai, goagal zauan esab gaul oi unanem. Dudu ipal agal amiagab ebu mui go Uwait aurabun, ze asiu macanemen. Aiu ses, Uwait nug alai sisiarabun ziwas ebu, go dudu go uhu banou pet umam.” ");
INSERT INTO bmh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus go Nou zaueim daren daren, dudu esab asiu mui agen aiwag Uwait muranemen Nou zauan aiwag tebil oug mina, picareun. ");
INSERT INTO bmh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wab air tub zoimai, aiwag ginaginam aliag, Uwait moroun. ");
INSERT INTO bmh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesus go peimai, eneun, “Iz petak pet awarem, e wab air go aiwag banou pet meun. Gonug duailel ipal unum zilarai dareu. ");
INSERT INTO bmh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","E duailel unum go agal aiwag asiu dareu, ipal aiwag tutak oimai, Uwait moromen. Bo, e air go aiwag tamacag pet. Go gonugau aiwag unum Uwait morou, go ee gau mabun aiwag tub i dareu.” ");
INSERT INTO bmh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesus nugau tapaimaraneu dudu ipal agen enemen, “Aiwag naliu sil zau patai memen mui, iweu naliu dudu agen Uwait moromen mui uligan.” ");
INSERT INTO bmh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesus nug koli awareun, “Go ag esab ulis pemen, ziwas zumau ebu iwai zaiagar agen alaimai, go zau unum eg wai mamam. Go zau memen aiwag unum ulagai numam. Aiwag tub gonugau pip i damau.” ");
INSERT INTO bmh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesus nugau tapaimaraneu dudu agen koli kanabai auremen, “Dubanou Ban, go igul eisab zumau? Ein igul amegai zuba, go ig abiu mamam?” ");
INSERT INTO bmh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Gonug koli awareun, “Ag suban ameitai dacan. Dudu ipal agen ag polumaramam. Dudu asiu agen alaimai, izal wanim patamam, enai zemamam, ‘Iz Yesus, kolital imarabun du zoimai darem.’ ‘Ziwas ulis zou,’ amam. Ag go dudu betei sesamarian. ");
INSERT INTO bmh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ag malai aleu ze mui, malai saiu waiagab alaba, doiban, ag esilakian. Go igul petak amegai zumau. Sisiarabun ziwas go pigai i zumau.” ");
INSERT INTO bmh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Guzenaimai, gonug kolital awareun, “Emgasag tub ebuan duailel agen asaimai, emgasag tub ebuan duailel abai iwai maimai, malaininamau. ");
INSERT INTO bmh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Em e ebu mim banban emgasag ata atai ebu zumau. Ipal emgasag we banou pet zumau. Ipal emgasag ebeu banban ata atai zumau. Mesgai wag uminabun igul ata atai zumau ag pimamen. ");
INSERT INTO bmh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bo, go igul pigai i zumau. Amegai agal iwai zaiagar agen ag gusig pataraimai, eg maramam. Ag izal tapaimaranemin dudu izal ze, ze ze maranemen, gonun, ag gotulanemen zaueim agal ze doimai, hiacaranem zau oug hiacaramam. Ag imaraimai, emgasag gumaraneu dudu banban agal ebeagab maramam. ");
INSERT INTO bmh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ag igul go ebalagab guzenebi, agen izal ze naliu awaramamen. ");
INSERT INTO bmh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Go ziwas pigai i zumau ebu, agal oiagab iau daimai, ein ze marabun dabeleu asiu i on. ");
INSERT INTO bmh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Einen, izanag go ze mui dabeleu naliu ag marai. Guzenemin, agal iwai zaiagar agen ag polu ze mai darem aimai i awaramam. ");
INSERT INTO bmh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Agal memeagar, anaiagar, apanagar, amanagar mui agal atanagar mui agal zaiagar agtal, ag agal iwai zaiagar agal ebeagab ebu maramam, ipal ag wagarebiag, noumamamen. ");
INSERT INTO bmh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ag izal tapaimaranemin dudu, gonun, duailel unum ag en aiag sisil aba zoimai, gasageim hiacaramam. ");
INSERT INTO bmh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bo, ag suban damamen, agal gagaliag ulig unum naliu damau, tutak i silai numau. ");
INSERT INTO bmh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ag gusig tapai dacan. Guzenebi, agal doropag muzmuz awau damau.” ");
INSERT INTO bmh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesus nug koli eneun, “Ag Zerusalem gonugau iwai zaugul agen zoimai kolilai katorobi, uligaiban, ag abiu mamamen go Zerusalem uzan ulis unum eg wai mamam. ");
INSERT INTO bmh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Guzenebi, duailel ag Zuda agaig daremen em manam wag uminai unamamen. Dudu ag Zerusalem uzan dacanemen, go uzan utei uzaneim uminai unamamen. Zerusalem uzan gasag dacanemen dudu, go uzan i simamen. ");
INSERT INTO bmh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ziwas go ebu, uhu banban zumau, go Uwait nug dudu agal zigulin macanemen koli ameg maramau. Getal Uwait nugau ze maranemen dudu agen sikut wemen, go petak zumau. ");
INSERT INTO bmh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ziwas go ebu, ailel enimaga mui, ailel geleagar ap zai darem mui ag bisomagar pet. Uhu banban e em ebu zumau. Uwait nug aigsisilaba, go dudu eg maramau. ");
INSERT INTO bmh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dudu ipal alalaimai, siag sil wagarebi, noumamam. Dudu ipal hiacaranem zau oug hiacarabun imaraimai, emgasag tub bitamam. Guzenai, emgasag tub ebuan duailel agen e uzan zo oi dabi dabi, betei Uwait go nugtal agal ziwas mazieu amau.” ");
INSERT INTO bmh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesus nug koli eneun, “Aiu ses am, geil, ureb ebu igul ata atai ninamau. E em ebu wol banban, ibut ze ebu usaba, duailel ag go doimai, unum uminamamen. ");
INSERT INTO bmh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Duailel ag go igul em ebu zumau gumei daremen, dabeleu asiu oimai, agal oiagab banban uminamamen. Ameag kualilamau, einen, Mesgai wagan igul gusig dareun unum iloialoiamau. ");
INSERT INTO bmh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Go igul guzenaimai, duailel agen Du Nugau Nag Mesgai wag pi oug gusig banban mui al eiman alaba, pimamen. ");
INSERT INTO bmh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Go igul zuba zuba, ag gusig tapai dacan, uminian, ag Mesgai wag ametai dacan, einen, Uwait ag imarabun ziwas go aleu.” ");
INSERT INTO bmh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesus nug koli gonugau tapaimaraneu dudu tatau ze tub awareun, “Ag a gair mui, a ipal dabilan. ");
INSERT INTO bmh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","A gair gau nuaneu ebu, go ag abiu macanemen, go am tapamau ziwas zoi dareu. ");
INSERT INTO bmh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Guzenai sul, ag go igul ata atai zuba, ag abiu mamamen, Uwait gumarabun ziwas zoi dareu. ");
INSERT INTO bmh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iz petak pet awarem, e dudu ulis daremen ag i noumamamen ebu, go ena igul zumau, ag pimamen. ");
INSERT INTO bmh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Emes mui, e em mui unum tamamau, bo, izal ze i poamau, muzmuz damau.” ");
INSERT INTO bmh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ag suban tapai dacan. Tam aba, ag ee banban agaimai, ag ze gusig umkoskos zamamen go dabuiag gugamau. Ag e em ebuan esab en dabeleu asiu umamen. Go igul nug ag eg marai daba daba, go ziwas ebu Uwait Banou nug pigai alai ag piaramau. Go malai heimai, egun wanem sul guzenaramau. ");
INSERT INTO bmh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Go igul, dudu unum e em daremen ebu zumau. ");
INSERT INTO bmh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ag ziwas umkoskos suban gusig tapai daremen, Uwait nug ag gusig marabun en umkoskos auramamen. Guzenamamen, go igul ag ebalagab zuba, ag eg i maramau. Ag Du Nugau Nag amegwab suban tapai damamen.” ");
INSERT INTO bmh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ziwas umkoskos, Yesus nug duailel Uwait nugau ze Nou zaueim abai maraneu. Umaum go em manam wanib Oliv go ebu ninabun bitaneu. ");
INSERT INTO bmh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Duailel go Yesus nugau ze duabun umkoskos umaseutal bitanemen. ");
INSERT INTO bmh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Zobu tub wanib Pasowa, duailel bret zis tamacag mui zanem ziwas zoi darena, Uwait ula dacanemen dudu banban mui. Kasai ze abai maranem dudu mui agen duailel uminaraimai, Yesus webiag, noumamau en dabeleu wageimai omen. ");
INSERT INTO bmh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Zudas Iskariot go Yesus nugau tapaimoroun du tub. Satan nug Zudas ougab oug sieun. ");
INSERT INTO bmh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Guzenina, Zudas go Yesus mui ipal tapaimaraneu dudu daremen utaraimai, Uwait ula dacanemen dudu banban mui, dudu Nou Zau gumanemen mui waiagab betei Yesus erunai go agal ebeagab ebu marabun awareun. ");
INSERT INTO bmh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Goagen ze go doimai, siksikaimai, goagen aiwag murabun en ze patemen. ");
INSERT INTO bmh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zudas go io aimai, go erunai Yesus, dudu banban agal ebeagab ebu marabun abu itanai dareun. Guzenaimai, tub ziwas duailel asiu i gotulanemen ebu, go ebeagab ebu marabun gumei dareun. ");
INSERT INTO bmh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Go ziwas bret zis tamacag zanem ziwas zoun. Ziwas go ebu, Zuda duailel go sipsip zawai nag waimai, Uwait ulagwag manem biz ebu aganem, ");
INSERT INTO bmh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Guzenaimai, go ziwas zuna, Yesus nug Pita zaug Zon dual palautaraimai, guzenai awareun, “Ag beteiban, zobu wanib Pasowa ebu ee zabun empip suban kasan.” ");
INSERT INTO bmh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Go agen koli auremen, “Ig eru ebu ee kasai mamam?” ");
INSERT INTO bmh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Gonug koli awareun, “Ag go uzan bitabun ebu, du tub go ze uleimai, zumau, ag piaramau. Du go zaueim simau ebu sesamorai sian. ");
INSERT INTO bmh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sieiban, zau atag du auran, ‘Igual Banou nug na aizeu, izal tapaimaranemin dudu mui zobu ebu ee zabun zau empip eru ebu dareu?’ ");
INSERT INTO bmh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Guzenai aurebi, go nug zau empip tub banou wag dareu abai maraba, ag go ebu igag ee zabun empip kasai macan.” ");
INSERT INTO bmh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Go beteimai, Yesus nug awareun guzental uligaimai, go zaueim ee zabun empip suban kasemen. ");
INSERT INTO bmh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasowa ee zabun ziwas zuna, Yesus nugau ze oi aidanemen dudu begurug sag abai ee zabun hobomen. ");
INSERT INTO bmh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Gonug awareun, “Izal oiab nug ag abai ereg iz amegai e ee zaimai, petak aiu ses mu banou pet oimai, noumai. ");
INSERT INTO bmh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iz petak pet awarem. Iz go Pasowa ee koli i zai. Uwait e em gumabun araog alamau ziwas ebu go petak koli zai.” ");
INSERT INTO bmh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Guzenaimai, Yesus nug gap oimai, Uwait ‘Ese-e’ auraimai, eneun, “E ze wain gap mui oiban, agtal agzozou zai zai tubmoro tubmoro han. ");
INSERT INTO bmh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Iz petak awarem, iz koli e wain dab ebuan ze i zai. Aiu ses Uwait e em gumabun araog alamau, go petak iz koli zai.” ");
INSERT INTO bmh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Guzenaimai, go bret oimai, Uwait ‘Ese-e’ auraimai, ebeg sil kakaimai, gonugau tapaimaraneu dudu maraimai, eneun, “Ag oiban, zan. E izal enim tabug. Iz e igul guzenem pemen ag aiu ses iz en dabileiban, izal wanim ebu guzental betei guzenan.” ");
INSERT INTO bmh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ag ee zaimai, bret oun sultal, wain ze gap mui oimai, eneun, “E wain ze go izal esep, Uwait nugau baib awau go ebu pezai dareu, go ag marem, zan. ");
INSERT INTO bmh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bo, du in iz izal iwai zaiar ebeagab ebu milamau, du go iz ibail go ereg hoboi dareu. ");
INSERT INTO bmh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Du Nugau Nag go abu getal Uwait nug tapai moroun sesamorai unamau. Bo, go du nug gonugau iwai zaugul goagal ebeagab ebu mareun du go bisoua.” ");
INSERT INTO bmh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Go guzenina, gonugau tapaimaraneu dudu agzozou enemen, “Go igul du inug guzenamau?” ");
INSERT INTO bmh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesus nugau tapaimaraneu dudu agzozou ze alalaimai, enemen, “In go ig ula ebu du banou?” ");
INSERT INTO bmh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus nug awareun, “Em e ebuan gumaranem dudu go duailel goagal salau dudu sul gumaranem. Go dudu banban agen enanem, ‘Ig igual duailel suban gumaranemun.’ ");
INSERT INTO bmh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ag izal duailel, ag go igul guzenian. Du ag ula ebu banou dareu go mogoi ginampet pet damau. Agal gumarabun du banou go salau du sul damau. ");
INSERT INTO bmh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Du in go banou? Du go hoboi daimai, ee zabun ulaneu. Go du banou ta? Du ee waimai, oi alaneu. Go du banou ta? Du go hoboi daimai, ee zabun ulaneu go petak du banou. Bo, iz agal du banou iz ag ula salau du sul isanarem. ");
INSERT INTO bmh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Iz ebilab uhu banou zuaneun, ag iz ibail umkoskos dacanemen, iz i utilai unanemen. ");
INSERT INTO bmh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ag guzenemen, izal mekai nug ag gumarabun gusig mileun sul izan han ag duailel ipal gumarabun gusig marem. ");
INSERT INTO bmh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Aiu ses ag izal uzan hoboimai, izal eebiz ebuan ee mui, ze mui zamamen. Ag han gumaranem dudu agal biz ebu hoboimai, agtal Israel agal ug begurug agal igul sisiaramamen.” ");
INSERT INTO bmh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesus nug eneun, “Saimon, Saimon. Satan nug ag wit dab wol ebu mina, wol nug wa hilaraneu sul na patai ulinizabun, Uwait nug aureun guzental igul mamau. ");
INSERT INTO bmh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iz nait ounab gusig mabun en Uwait auremin. Nait ounab koli iz en kekulaba, iz waiab alen, nagen koli nait salau zaunar agal oiagab gusig maren.” ");
INSERT INTO bmh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita nug koli Yesus aureun, “Dubanou Ban, iz na ibaiz hiacaranem zau oug beteimai, noumabun darem.” ");
INSERT INTO bmh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesus nug Pita koli aureun, “Iz petak pet aizem, Ulis umaum, toi i ulau ebu, nagen izal wanim wagemaimai, ziwas ainarai ebu, ‘Iz go du i abiu’ amam.” ");
INSERT INTO bmh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesus nug gonugau tapaimaraneu dudu awareun, “Ziwas tub ebu iz ag Uwait nugau ze duailel awarabun palautaremin ebu, ag aiwag tub ta, zo nag ta, aramag galau ta i oi wanemenin, ag esab tub wabun en dabilemenin ta?” Goagen koli enemen, “Ig esab tub en dabelab tam.” ");
INSERT INTO bmh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesus nug koli awareun, “Ulis go igul atai, du in go aiwag mui ta, zo nag mui go umau. Du in go maulzag huia tamacag, go gonugau tibur galau tub dudu ipal maraba, gau mebi, go ebuan aiwag oimai, maulzag huia tub gau mamau. ");
INSERT INTO bmh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iz petak awarem, getal sikut waimai, enemen, ‘Goagen du go igul eg macanemen duailel mui tularai mamam.’ ");
INSERT INTO bmh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Gonugau tapaimaraneu dudu agen koli enemen, “Dubanou Ban, maulzag huia aliag e dareu.” Gonug koli awareun, “Ag ze go ban i macan, soan iboi.” ");
INSERT INTO bmh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus uzan go uteimai, em manam tub wanib Oliv go ebu umkoskos bitaneun ebu beteimai, gonugau tapaimaraneu dudu agen go sesamor betemenin. ");
INSERT INTO bmh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Go uzan beteimai, gonug guzenai awareun, “Ag umkoskos Uwait auran, Satan nug ag i polumaramau.” ");
INSERT INTO bmh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Guzenaimai, go utaraimai, du tub nug ai oimai aiwag pulig amacendai, bitaneu sul ebu beteimai, gonug taubibuaimai, Uwait aureun. ");
INSERT INTO bmh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Gonug eneun, “Mekai, nagental e uhu iz ebilab dareu zilagai en. Bo, na izal dabeleu i sesamoren, nait dabeleu tutak sesamor.”  ");
INSERT INTO bmh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Guzenina, Uwait nugau tibur nug Mesgai wageman alaimai, go gusig moroun. ");
INSERT INTO bmh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus go uhu banou wabun dabeleimai, Uwait gusig aureun. Guzenina guzenina, gonugau sibigel eseu sul nug em ebu noun. ");
INSERT INTO bmh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Go Uwait aurai mazicaimai, asaimai, betei gonugau tapaimaraneu dudu daremen ebu beteun. Go oiagab eg waimai, unum ninemen picareun. ");
INSERT INTO bmh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Gonug asaraimai, awareun, “Ag einen gabuai daremen? Asaiban, Uwait auran. Guzenebi, Satan nug ag i polumaramau.” ");
INSERT INTO bmh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus nug gonugau tapaimaraneun dudu ze ze marena marena, dudu banban asiu, Zudas sesamorai betei Yesus gusig patabun betemen. Zudas go Yesus nugau tapaimorou du. Gonug amegai Yesus waugab beteimai, sibeg zukzukeun. ");
INSERT INTO bmh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesus nug kanabeun, “Zudas, na Du Nugau Nag gonugau iwai zaugul agal ebeagab ebu marabun alai sibeg zukzukem ta?” ");
INSERT INTO bmh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gonugau tapaimaraneu dudu agen go igul guzenemen uligaimai, enemen, “Dubanou Ban, ig go abai malai mabun iboin ta?” ");
INSERT INTO bmh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Guzenina, tub nug maulzag huia oimai, Uwait ula dacaneun du banou pet nugau salau du waimai gonugau dabug naliu eiman kuatai heun. ");
INSERT INTO bmh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesus nug go igul uligaimai, awareun, “Go igul i guzenan.” Guzenaimai, gonug du gonugau dabug gau patai oi mina, koli gonugau dareun sul usaleun. ");
INSERT INTO bmh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Guzenaimai, Yesus nug Uwait ula dacanemen dudu mui, dudu banban mui, Nou Zau gumanemen dudu mui awareun, “Ag malai mabun malai hog mui maulzag mui oimai, iz zob du sul ebe aram durub waimai, iwabun alemen ta? ");
INSERT INTO bmh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Iz Nou Zaueim umkoskos ag abai ereg dacanemin, ag go ebu patilabun utanemen. Bo, ulis go agal ziwas. Em e ebuan umutanau go gusig aleu ");
INSERT INTO bmh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Guzenaimai, Yesus gusig patai oimai, Uwait ula dacaneu du banou pet nugau zaueim imai betemenin. Pita go sesamarai, wagei wageimai holoi holoi beteun. ");
INSERT INTO bmh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dudu ipal agen ab uzaneim zoromen, Pita go duailel ipal go ab ugei daremen ebu beteimai, ereg ab uge dareun. ");
INSERT INTO bmh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Salau air tub nug ab al ebu gonugau siugual suban uligaimai, eneun, “Iz abiu du e go Yesus dual aidaneun du.” ");
INSERT INTO bmh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita nug koli eneun, “Iz du go i abiu.” ");
INSERT INTO bmh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Dai dai, du tub nug gonugau siugual uligaimai, eneun, “Na mui gonugau tapaimizeun du.” Gonug koli eneun, “Iz gonugau tapaimileun du tam.” ");
INSERT INTO bmh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kolital dai dai du tub nug eneun, “E du go Yesus dual aidaneun. Iz gonugau zeu abemem, gonun, iz abiu go Galili agaigan du.” ");
INSERT INTO bmh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Gonug gusig maimai, eneun, “Na go ze zemem go iz i abiu.” Go guzenina ina, toi uleun. ");
INSERT INTO bmh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Guzenina, Dubanou Ban nug kekulaimai, Pita uligoroun. Pita go Yesus nug getal aureun ze koli dabeleun. ‘Ulis umaum toi i ulau ebu, na izal wanim wagemaimai, iz go i abiu aimai ainarai ziwas ze mamam.’ ");
INSERT INTO bmh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Go ze go dabilaimai, uzaneim noimai, bisou wina, banban weineun. ");
INSERT INTO bmh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Go dudu Yesus gumei daremen agen go ze biabial kuai auraimai, busil esalausul omen. ");
INSERT INTO bmh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Gonugau ameg tibur galau zig sil kulaimaimai, sibeg ebu waimai, kanabai auremen, “Na zemen, in nug na niweu?” ");
INSERT INTO bmh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Goagen ze biabial kuaimai, ipal eg ze auremen. ");
INSERT INTO bmh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Em wagena, umaseu, dudu banban mui, Uwait ula danemen dudu banban mui, kasai ze abai maranem dudu abai ereg tulaimai, ze sisiaranemen dudu banban ebu Yesus imai betemenin. ");
INSERT INTO bmh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Goagen kanabai auremen, “Na Kristus, Uwait nug palautizena, alemen ta?” Gonug koli awareun, “Bo, iz Kristus awaremin, agal oiagab petak i amau. ");
INSERT INTO bmh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Izan koli ag kanabaremin, agen izal ze koli i ailamamen. ");
INSERT INTO bmh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ulis betei, aiu ses Du Nugau Nag go Uwait gusig banou mui gonugau ebeg naliu eiman hoboi damau.” ");
INSERT INTO bmh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Goagen koli auremen, “Guzenaimai, na Uwait nugau Nag ta?” Gonug koli awareun, “Io, ag zememen gotal, iz Uwait nugau Nag.” ");
INSERT INTO bmh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Guzenina, go agen enemen, “Ig dudu ipal gumarai damun, goagen alai gonugau enibwag ze tub i mamam. Ein ze gonugau ogusau nug ze meun, domun. Gonugau ze gonugtal nug sisiai muramau.” ");
INSERT INTO bmh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","2","Dudu banban go unum asaimai, Yesus Pailot nugau ameg ebu imai beteimai, gonugau enib ebu ze polumaimai, enemen, “E du gonug igual duailel agal dabeleu eg wai maimai, awareun, ag Sisar aiwag i marabun ina, duanemun. Gonug eneu, iz Kristus, duailel gumarabun du banou aimai awaraneu. Guzenina, ig na wautab imai alem.” ");
INSERT INTO bmh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailot nug Yesus kanabai aureun, “Na Zuda, agal gumarabun du banou ta?” Yesus nug eneun, “Go na anem gotal.” ");
INSERT INTO bmh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailot nug Uwait ula dacanemen dudu mui duailel tulai daremen mui awareun, “Iz e du nug igul eg tub meun i pem.” ");
INSERT INTO bmh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Go agen koli ze gusig maimai, guzenemen, “Gonug duailel amiagab igul eg abai maraneu. Go Zudia agaig uzan unum guzeneun. Go Galili agaig ebu bigegwaimai, ulis Zerusalem uzan guzenabun aleu.” ");
INSERT INTO bmh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailot go ze go doimai, kanabareun, “E du go Galili agaig ebuan ta?” ");
INSERT INTO bmh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Go agen go Galili agaig ebuan emen doimai, go nug Herot waugab palautoroun. Herot go Galili agaig gumaneun du banou. Ziwas go ebu, go gonugau uzan uteimai, Zerusalem uzan betei dareun. ");
INSERT INTO bmh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yesus go Herot waugab imai betena, Herot go Yesus uligaimai, banban siksikeun, Go einen Yesus nugau wanib duaneu, ziwas asiu go erunai piai aimai dareun. Go Yesus nug ipal igul ata atai guzeneun, piabun dabeleun. ");
INSERT INTO bmh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Guzenaimai, go nug Yesus ze asiu kanaboroun, Yesus nug ze tub koli aurab tam. ");
INSERT INTO bmh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Uwait ula dacanemen dudu agen simai, Yesus nugau enib ebu polu ze asiu memen. ");
INSERT INTO bmh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot gonugau malai dudu abai ereg, agen Yesus ir moroimai, ze biabial kuai asiu auremen. Guzenaimai, Herot nug gonugau malai dudu awarendai, gonugau tibur galau naliu Yesus arugai moroimai, koli Pailot waugab palautina, beteun. ");
INSERT INTO bmh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herot zaug Pailot dual go getal iwai daremen, ulis go ziwas ebu go baib memen. ");
INSERT INTO bmh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Herot nug Yesus koli Pailot waugab palautina, go nug Uwait ula dacanemen dudu banban mui, gumaranem dudu banban mui, duailel unum mui ularena, alai gotulina, Pailot nug awareun, “Agen du e koli iz waiab imai alaimai, duailel igul eg abai maraneu aimai ailemen. Iz agal amiagab kanabemin, iz gonug igul eg tub meun piab tam. ");
INSERT INTO bmh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot go mui guzental guzeneun. Yesus go nug igul eg meun uligeun zob, gonug iz sikut wai milaba, pem zob. E du go igul eg tub i meun, go einen gaul webi, noumamau? ");
INSERT INTO bmh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Izal malai dudu awaremin, busil esalausul oimai, utebi, unamau.”  ");
INSERT INTO bmh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Agal igul, Pasowa zobu ebu umkoskos Pailot nug hiacaranem zauan du tub utena, unaneu. ");
INSERT INTO bmh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dudu unum agen ulaimai, enemen, “Barabas gaul utemen, unamau. Yesus wemen, noumamau.” ");
INSERT INTO bmh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Getal go uzan dudu agal gumaraneun du banou al alalaimai, Barabas nug du tub wina, noumeun. Guzenina, go hiacaranem zau oug hina, dareun.) ");
INSERT INTO bmh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailot nug koli Yesus utebi, unabun duailel awareun. ");
INSERT INTO bmh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Duailel agen koli ulaimai, ze gusig memen, “Go a gegeulanau ebu wai memen, noumamau.” ");
INSERT INTO bmh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailot nug koli awareun, “Go ein igul eg meun? Iz go nug igul eg tub meun i pem. Go gaul wemun, i noumamau. Iz izal malai dudu awaremin, busil esalausuloimai, utebi, unamau.” ");
INSERT INTO bmh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Go agen koli kagagai ulaimai, enemen, “Go a gegeulanau ebu wai mebi, noumamau.” ");
INSERT INTO bmh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Guzenina, Pailot nug duailel agal ze sesamoreun. ");
INSERT INTO bmh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pailot nug Barabas du tub wina, noumeun utena, go wanena, Yesus go malai dudu agal ebeagab ebu mareun. ");
INSERT INTO bmh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Rom agal malai dudu agen Yesus a gegeulanau ebu wabun abu ebu imai betena betena, du tub go Sairini uzanan ban uzan siabun aleun. Gonugau wanib Saimon. Abu ebu tuloroimai, gusig pataimai, Yesus nugtal gonugau a gegeulanau gamacai beteun go oimai, Saimon gamacai morona, Yesus sesamorai beteun. ");
INSERT INTO bmh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Duailel asiu Yesus sesamorai betemen. Go ula ipal ailel go uligaimai, oiagab eg wai mina, go en weinemen. ");
INSERT INTO bmh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus nug koli kekulaimai, awareun, “Zerusalem ailel. Ag iz en oiagab egwaba, i manilman, ag agal geleagar en agtal en mui petak manilman. ");
INSERT INTO bmh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ag e suban don, aiu ses go ziwas zumau ebu ag zemamamen, ‘Up ailel ag siksikamamen. Ailel ag mogoi i patemenin ag han siksikamamen. Ailel ag mogoi ap i zanem ag han siksikamamen.’ ");
INSERT INTO bmh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Go ziwas ebu, duailel agen em manam banban awaramamen, ‘Ig alai, tonigai men.’ Ag em manam ginaginam mui awaramamen, ‘Ig alai, wagem migen.’ ");
INSERT INTO bmh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ag du naliu guzental eg maranemen, ag du eg ebalagab ein igul guzenaranemen?” ");
INSERT INTO bmh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Du aliag go getal igul eg memen han Yesus mui noumabun go uzan ereg imaraimai betemenin. ");
INSERT INTO bmh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Go uzan wanib Golgota, wanib zebigeg go enai, ‘Eb gagalig gulam’. Go ebu zoimai, Yesus mui du aliag igul eg memen ereg a gegeulanau ainarai ebu asarai memen. Du tub Yesus nugau ebeg naliu eiman asai memen, tub ebeg nanai eiman asai memen.  ");
INSERT INTO bmh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus nug eneun, “Mekai, go igul guzenem, go i abiu, nagen go zigulin zilagai maren.” Go ziwas ebu, malai dudu agen onanem aiwag oimai, onaimai, gonugau ipal tibur galau ag doumai wabun guzenemen. ");
INSERT INTO bmh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Duailel go tapai daremen Yesus pei darena darena, gumaranem dudu banban agen go ir moroimai, ze biabial kuai auremen, “Go duailel ipal isanareun. Go Kristus du go Uwait nug palautendai, aleun zob, nugtal nug isanorou zob.” ");
INSERT INTO bmh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Rom agal malai dudu agen han go zoimai ze biabial kuai auraimai, wain ze munug moroimai, auremen, “Na petak Zuda duailel agal gumaranem du banou aba, na a gegeulanau uteiba, nonen.” ");
INSERT INTO bmh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Gonugau a gegeulanau tabagwab guzenai sikut wai memen, ‘E du go Zuda duailel agal gumaraneu du banou.’ ");
INSERT INTO bmh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Du eg aliag go ereg a gegeulanau ebu asarai memen, tub nug Yesus ze biabial kuai guzenai aureun, “Na Kristus aba, nagtal nait enim isanoroib, ig isanigen.” ");
INSERT INTO bmh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Du tub nug zaug kagagai aureun, “Na Uwait uminorom ta? Ig unum uhu tutak om. ");
INSERT INTO bmh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Naigana go uhu om, go iboi, einen, naigana igul eg memun, naigana noumabun go iboi. E du go igul eg tub mab tam, go du naliupet go gaul ena noumabun iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Guzenaimai, go nug koli Yesus aureun, “Yesus, aiu ses na ig gumigabun alamam ziwas ebu na iz en dabelen.” ");
INSERT INTO bmh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus nug du go aureun, “Iz na petak baib mizem, ulis na iz ibail ereg Mesgai wag damam.” ");
INSERT INTO bmh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Am gusig am ban ula, am elab tam, em unum umutai bete, amameg ainarai umusig. ");
INSERT INTO bmh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Am elab tam ebu, go laplap Nou Zau banou zaueim asai memen dareun ulatal bigaga noi betei aliag usaleun. ");
INSERT INTO bmh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesus nug ulaimai, eneun, “Mekai, ulis izal awau wes nait eben ebu mizem.” Go guzenaimai, go nugtal gonugau awau wes uteimai, go noumeun. ");
INSERT INTO bmh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Malai dudu agal gumaraneu du banou gue igul go uligaimai, Uwait nugau wanib ulagwag moroimai, eneun, “Petak pet, du e go igul eg i macaneu.” ");
INSERT INTO bmh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Duailel ag ein igul zuna, uligabun alai gotulemen, go igul go uligaimai, go agal oiagab banban eg wina, koli agal uzan utei wanemen. ");
INSERT INTO bmh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesus nugau zaugul mui ailel Galili agaig eiman Yesus sesamorai alemen go ereg tubaiman tapai darem, igul go guzenemen pei daremen. ");
INSERT INTO bmh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Du tub gonugau wanib Zosep go Arimatea uzanan, Zudia agaig dacaneu. Go duailel amiagab du naliu dacaneu. Go Zuda gumaraneun dudu banban agal salau zaiag. ");
INSERT INTO bmh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Go dudu banban ipal agal dabeleu Yesus webi, noumabun emen agal ze sesamorab tam. Go Uwait e em gumabun koli alamau en gumei dacaneun. ");
INSERT INTO bmh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Du go, go Pailot waugab beteimai, Yesus nugau noumeun enib go oimai, aizau ob oug hiabun kanabeun. ");
INSERT INTO bmh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Guzenaimai, go nug Yesus nugau noumeun enib a gegeulanau ebuan oimai, tibur galau ausiau sil kuloroi moroimai, aizau ob oug memen. Aizau go aiwag banou oug kolilai elemen. Go oug getal du tub noumeun enib go aizau ob oug hiab tam. ");
INSERT INTO bmh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Fraide go, esab kasarabun ziwas ebu guzenemen. Ginam Zobu, go Zuda agal imabun ziwas. ");
INSERT INTO bmh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Go ailel getal Galili agaigan Yesus sesamorai alemen, go ereg Zosep sesamorai beteimai, go aizau ob oug Yesus nugau noumeun enib erunai mamau aimai uligai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Guzenaimai, go ailel agen koli agal uzan beteimai, a nugau ilau sous naliu ziwabun kasai maimai, Zobu ziwas gonun, go kasai ze sesamoraimai, imemen. ");
INSERT INTO bmh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ban zobu ebu, umaseutal pet ailel ag go a nugau ilau sous naliu go kasai memen oimai, Yesus nugau enib ebu ziorai murabun betemen. ");
INSERT INTO bmh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Beteimai, aiwag banou sil Yesus nugau aizau ob ogusau tapelai memen go ililai memen. ");
INSERT INTO bmh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Go peimai, go agen aizau ob oug simai, Yesus nugau noumeun enib i pemen. ");
INSERT INTO bmh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Goagen igul go guzeneun uligaimai, dabeleu asiu oi darena darena, Uwait nugau tibur aliag agal tibur galau ausiau pet pigaital, waiagab alai tapai daremen. ");
INSERT INTO bmh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Al hilanau banou nug go agal tibur galau ebu hilai darena, ailel go uminaimai, go agal doropag wanena, go em pei darena darena, tibur goagen awaremen, “Ag einen du awau dareu, dudu noumemen agal uzan itanai daremen? ");
INSERT INTO bmh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Go e ebu i dareu, go usaimai waneun. Ag ze go getal Galili agaig ebu daimai, awareun dabilan. ");
INSERT INTO bmh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Du Nugau Nag gusig pataimai, igul eg macanemen dudu agal ebeagab ebu marebiag, go agen go a gegeulanau ebu webi, noumamau. Gil ianai ainarai ebu go koli usamau.’” ");
INSERT INTO bmh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Guzeneun, ag ze go Yesus nug getal aneun dabelen. ");
INSERT INTO bmh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Guzenina, go ailel agen aizau ob uteimai, go gugeg uligemen unum dudu ipal mui gonugau tapaimaraneun dudu sai naliu gotulai daremen ebu beteimai awaremen. ");
INSERT INTO bmh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Go ailel agal wanimag go, Maria go Magdala uzanan, Zoana, Zems nugau anag Maria, ailel ipal abai ereg betemenin, agen gugeg go uligemen, Yesus nugau ze oi aidanemen dudu awaremen. ");
INSERT INTO bmh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bo, dudu go agal dabeleu go ailel eruab polu ze mem aimai, goagal oiagab petak i eun.  ");
INSERT INTO bmh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bo, Pita go ze doimai, usaimai, pigaital go aizau ob ebu beteimai, go aizau ob oug tibur galau ausiau sag aizau ob oug dareun uligeun. Go koli zau beteimai, gugeg go uligeun, dabeleu asiu oi dareun. ");
INSERT INTO bmh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Go ziwas ebu, Yesus nugau tapaimaraneun dudu aliag go em tub wanib Emaus uzan betemen. Go uzan eiman Zerusalem uzan betabun pulig tam. ");
INSERT INTO bmh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Agtal abu ebu beteimai, gugeg go usaleun ze zemai betemen. ");
INSERT INTO bmh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Zaug dual ze zemai bete beten, Yesus nug seiagab zoimai, sesamarai ereg betemenin. ");
INSERT INTO bmh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Go agen gonugau siameg suban abe murabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesus nug kanabeun, “Ag ein ze mai betemen?” Gonug guzenai kanabena, go goagal oiagab oug uhu meun. ");
INSERT INTO bmh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Du tub nugau wanib Kliopas nug koli aureun, “Na tub uzanan du ulis Zerusalem uzan alemen, gonun, na gugeg go alin usaleun na i abiu ta?” ");
INSERT INTO bmh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Gonug koli kanabeun, “Ein gugeg alin usaleun?” Go agen koli auremen, “Go igul Nasaret uzanan Yesus ebu guzenemen. Go Uwait nugau ze doimai, awaraneun du banou. Uwait nugau amegwab mui, duailel unum agal ameagab gonugau salau mui ze mui gusig pet. ");
INSERT INTO bmh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Igual Uwait ula dacanemen dudu banban mui, gumiganemen dudu banban agen gusig pataimai, a gegeulanau ebu wina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Igual dabeleu go gonug ig Israel duailel imaigabun aleu emun. Ulis umaseu gil ianai ainarai ebu igul tub usaleun. ");
INSERT INTO bmh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ailel ipal ig ibaig ereg dacanem agen ig aigena, ig esilakemun. Goagen umaseu pet aizau ob ebu betemen. ");
INSERT INTO bmh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Go gonugau enib piab tam. Go agen koli alaimai, ig aigemen, Uwait nugau tibur agen, Yesus go koli waseun aigemen. ");
INSERT INTO bmh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Guzenina, igual dudu ipal go aizau ob ebu beteimai, ailel agen awaremen sultal uligemen. Go gonugau enib i pemen.” ");
INSERT INTO bmh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Guzenina, Yesus nug awareun, “Agal dabeleu naliu huia tamacag. Getal Uwait nugau ze doimai, awarememen dudu agen ze go memen, ag agal oiagab petak i eun. ");
INSERT INTO bmh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ag i abiu ta? Kristus mu banou go oimai, aiu ses koli Uwait nugau gusig go umau.” ");
INSERT INTO bmh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Gonug Moses nugau ze eiman bigegwai awaraimai, Uwait nugau ze doimai, awaranemen dudu ipal agal ze mui awareun. Gonug nug en sikut wemen ze zebigeg unum awareun. ");
INSERT INTO bmh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Go Emaus uzan waugab zoimai, Yesus go i imeu, go abu tub eiman bitabuneun. ");
INSERT INTO bmh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Go agen go dual ereg dabun gusig pataimai, auremen, “Em mazieu, gonun, na igag ereg noi ninab, na i unamam.” Guzenina, go simai, go abai ereg dareun. ");
INSERT INTO bmh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ee zabun ziwas, Yesus nug bret oimai, Uwait ‘Ese-e’ auraimai, bret peliaimai, go dudu aliag mareun. ");
INSERT INTO bmh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Go igul guzeneun, uligaimai, go abiu memen go Yesus sag. Guzenaimai, goeimantal kaieun. ");
INSERT INTO bmh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Guzenendai, agzozou enemen, “Ig abu ebu alemun, go nug ze go zebigeg Uwait nugau ze outaimai aigeun, go ziwas ebutal igual oigeb aseun.” ");
INSERT INTO bmh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Zaug dual ze go ze maimai, go ziwas ebutal asaimai, Zerusalem uzan koli betemen. Beteimai, Yesus nugau tapaimaraneun dudu sai naliu mui, zaiagar ipal abai ereg zaueim gotulai daremen ebu betei piaremen. ");
INSERT INTO bmh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Go zaueim daremen dudu agen go dudu aliag awaremen, “Petak pet, Dubanou Ban go koli waseun. Saimon-Pita go uligeun.” ");
INSERT INTO bmh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Guzenaimai, du go agen koli igul go abu ebu usaleun unum awaremen. Go agen enemen, “Gonug bret peliaimai migena, ig go abe moromun.” ");
INSERT INTO bmh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dudu go agen igul go pemen ze mina mina, Yesus nugtal go daremen ula ebu zoimai, awareun, “Agal oiagab iau selai damau.” ");
INSERT INTO bmh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Go agen esilakaimai, uminemen, einen, goagal dabeleu go eb uligem emen. ");
INSERT INTO bmh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Gonug koli awareun, “Ag einen, esilakaimai, uminemen? Einen ag dabeleu asiu oi daremen? ");
INSERT INTO bmh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ag izal ebe aram e uligan, e izan zoi darem. Ag izal ebe pataimai, ag abe mamamen. Eb agal enimag iz peilemen sul tam.”  ");
INSERT INTO bmh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Go guzenai awaraimai, gonugau ebeg arab mui abai mareun. ");
INSERT INTO bmh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Go gaul siksikemen. Bo, goagal oiagab petak ab tam, go dabeleu asiu oi daremen. Gonug kanabeun, “Ag ee ipal zabun dareu ta?” ");
INSERT INTO bmh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Go agen karuk eleun oi alai moromen. ");
INSERT INTO bmh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Go nug karuk go oimai, go agal ameagab ebu zena, uligemen. ");
INSERT INTO bmh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Gonug awareun, “Iz e igul getal ag abai ereg daimai, ze go awaremin. Go igul getal iz en Moses nugau kasai ze sikut mui, Uwait nugau ze doimai, awaranemen dudu agal ze mui, Buk Song ebu sikut wemen usalamaun awaremin, ulis petak usaleu.” ");
INSERT INTO bmh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Gonug goagal dabeleu outai maren Uwait nugau ze awareun go abiu memen. ");
INSERT INTO bmh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Gonug awareun, “Ze go ebu guzenai sikut wemen, ‘Kristus go mu banou oimai, noumaimai, koli gil ianai ainarai ebu usamau.’ ");
INSERT INTO bmh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Gonugau wanib ebu gonugau ze duailel marebi, agal oiagab kekulaba, Uwait nug agal zigulin zilagai maramau. Ag go salau Zerusalem uzan bigegumamen. ");
INSERT INTO bmh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ag e igul ameag nug pemen, emgasag unum betei awaran. ");
INSERT INTO bmh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Go Ah Wes izal Mekai nug ag marabun baib mareun, go izan palautai, ag ebalagab alamau. Ag Zerusalem uzan dabi dabi, go Ah Wes nug alai ag gusig maramau.” ");
INSERT INTO bmh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Yesus nug gonugau tapaimaraneun dudu imarai, Betani uzan beteun. Go ebu gonugau ebeg wag maimai, gonugau tapaimaraneun dudu suban dabun en ze awa awarai utarai waneun. Uwait nug go Mesgai wag imai sieun. ");
INSERT INTO bmh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Guzenina, gonugau tapaimaraneun dudu oiagab siksikai mui, koli Zerusalem uzan betemenin. ");
INSERT INTO bmh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Go umkoskos Nou zaueim daimai, Uwait auraimai, ulagwag moroi daremen. ");
INSERT INTO bmh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Get get pet, Uwait go em e patai mab tam ebu, Ze dareun. Ze go gue Yesus. Ze go Uwait nug dual dareun. Ze nug go Uwait. ");
INSERT INTO bmh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Go getal pet Uwait nug dual muzmuz dacaneun. ");
INSERT INTO bmh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ze go nug ece unum usalai meun. Ece ipal go abu tub eiman zuab tam. Ece unum zoun Ze nugtal patai meun. ");
INSERT INTO bmh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Awau dabun gusig go ebu umkoskos dareu, awau dabun gusig go sil al duailel marena, pianem. ");
INSERT INTO bmh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Al gonug umaum hilai hina, hilanau usalaneu. Umaum nug al go zilacurabun iboin tam. ");
INSERT INTO bmh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Du tub usaleun. Gonugau wanib Zon. Go Uwait nug palautina, aleun. ");
INSERT INTO bmh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Gonug duailel al go en awarabun aleun. Guzenina, duailel unum go ze go doimai, goagal oiagab ze go en petak abun awareun. ");
INSERT INTO bmh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zon nug go al tam. Go gaul al go ses zoidareu, gonugau ze amegai em e ebu duailel al go en awarabun aleun. ");
INSERT INTO bmh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Al go petak. Al go zoi dareu nug em e ebuan duailel unum al hilaraba, goagal oiagab oug hilai amau. ");
INSERT INTO bmh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gonugtal em e patai meun. Go em e ebu alai dareun, bo, em e ebuan duailel ag go abe i memen. ");
INSERT INTO bmh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Go gonugau ban meun uzan beteun, bo, go ebu gonugau ug agen siksikaimai, go imab tam. ");
INSERT INTO bmh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Guzenina, duailel ipal agal oiagab petak emen agen go imaiemen. Guzenina, go nug duailel go agal oiagab go en petak emenin imaraimai, Uwait nugau gelegul alegul tapai mareun. ");
INSERT INTO bmh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ag Uwait nugau gelegul usalabun ag em e ebuan memeagar agal esepag sil patarai mab tam. Uwait nugau Ah Wes nug patarai meun, gonun, Uwait nug tutak agal memeag. ");
INSERT INTO bmh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ze go du sul alaimai, ig ula ebu alai dareun. Gonug gonugau ougab naliu mui eiman, ig isanigeimai, gonugau petak igul abai migeun. Go gonugau memeg, Uwait, nugau nag tutakpaiu. Guzenaimai, memeg nugau gusig banou oi alina, ig gusig go pemun. ");
INSERT INTO bmh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zon nug go en eneun. Gonug duailel guzenai awareun, “Iz du go en getal guzenai awaranemin, ‘Du tub go iz seiab ses zoi dareu, go izal Dubanou Ban. Izal anikai nug iz zoliwau tam ebu go dareun.’” ");
INSERT INTO bmh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ig duailel naliu tam, bo, gonugau ougab naliu mui eiman ig umkoskos isanigeimai, suban gumiganeu. ");
INSERT INTO bmh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Uwait nug gonugau kasai ze Moses nugau ebeg ebu mina, go nug duailel kasai ze go sesamorabun awaraneun, bo, Uwait nug Yesus Kristus palautina, gonugau ougab naliu mui eiman isanigena, gonugau nag nug gonugau igul petak mui, gonugau ougab naliu mui, abai migeun. ");
INSERT INTO bmh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Du tub Uwait nugau enib piab tam. Uwait nugau nag tutak go han Uwait, gonun, go memeg waugab daimai, go nug ig memeg abai miganeu. ");
INSERT INTO bmh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Zuda dudu banban agen Zerusalem uzanan Uwait ula dacanemen dudu ipal mui, Liwai dudu ipal abai ereg palautarena, betei Zon kanabemen, “Na du in?” ");
INSERT INTO bmh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Guzenina, Zon nug ze go wagemab tam, go nug duailel unum darena ze araog awareun, “Iz Kristus tam.” ");
INSERT INTO bmh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Goagen koli kanabemen, “Guzenem aba, na in? Na Uwait nugau ze doimai, awaraneun du Elaiza ta?” Gonug koli awareun, “Tam.” Goagen koli kanabemen, “Na Uwait nugau ze doimai, awaraneu du Uwait nugtal tapai mizeun ig gumei daremun du ta?” Gonug awareun, “Tam.” ");
INSERT INTO bmh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Goagen kolital guzenai kanabemen, “Guzenaimai, nagen ig aigen, na du in? Ig dudu banban agen palautigena, alemun, ig ze koli oi betei awaramam, gonun, na du in aba nagtal aigamam.” ");
INSERT INTO bmh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Zon nug guzen eun, “Getal Uwait nugau ze doimai, awaraneun du Aisaia nug guzenai sikut weun, ‘Du tub nugau zeu nug du tamacag uzan em ula ebu ulaimai, guzeneu, “Dubanou Ban nugau abu suban kalai moron. Gonugau abu tuguiai moron.” eun. ");
INSERT INTO bmh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Parisi dudu ipal agen dudu go palautarena, betemen. ");
INSERT INTO bmh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Goagen koli go guzenai kanabemen, “Na Kristus Uwait nug gonugau duailel koli imarabun tapai mizab tam, na Elaiza tam, na go Uwait nugau ze doimai, awaraneu du han tam aba, na einen duailel ze ziwaranem?” ");
INSERT INTO bmh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Zon nug koli guzenai awareun, “Iz duailel ze sil ze ziwaranem. Bo, du tub ag ula tapai dareu, ag du go i abiu, go iz seiab ses alai dareu, bo, go du banou, iz du naliu tam, gonun, iz gonugau arab ebuan arab galau oi habun go iboin tam.” ");
INSERT INTO bmh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betani uzan, Zordan ze gasag tubaim, am zuaneun eiman go ebu, Zon nug duailel ze ziwaraneun ebu, igul go unum usaleun. ");
INSERT INTO bmh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nineimai, umaseu, Zon go Yesus alina, peimai, eneun, “Ag uligan, ulibe du go Uwait nugau sipsip nag pet. Gonug em e ebuan duailel agal igul eg macanemen zilagai marabun aleu. ");
INSERT INTO bmh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iz du go en getal ze maraimai, awaremin, ‘Du tub go iz seiab ses zoi dareu, go izal du banou awaremin, einen, izal anikai iz i soliwau ebu, go dareun.’ ");
INSERT INTO bmh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Izaseu sag go du go in iz i abiu, bo, iz alai Israel duailel go abai marabun ze ziwaranem.” ");
INSERT INTO bmh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Zon nug kolital eneun, “Iz Uwait nugau Ah Wes Emes ulagaimai, meg kurumuk sul, alaimai, go al dareun pemin. ");
INSERT INTO bmh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Iza han iz go i abiu, bo, Uwait nug duailel agal igul eg ebuan ailabun ze sil ze ziwarabun salau mileun. Gonug aileun, ‘Izal Ah Wes alai du tub al daba, na abiu mamam, du go tutak go nug duailel Ah Wes sil ze ziwaramau.” ");
INSERT INTO bmh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Zon nug kolital eneun, “Iz igul go guzeneun izatal pemin. Iz petak pet awarem, go Uwait nugau Nag pet.” ");
INSERT INTO bmh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nineimai, umaseu, Zon nugau tapaimareu dudu aliag Zon nug al koli go ebu tapai daremen. ");
INSERT INTO bmh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Go Yesus betena, peimai, eneun, “Ag uligan, go Uwait nugau sipsip nag pet.” ");
INSERT INTO bmh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tapaimareu dudu aliag go Zon nug ze go awareun doimai, go Yesus sesamorai betemen. ");
INSERT INTO bmh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus nug dudu aliag go agen sesamorai betemen kekulai piaraimai, kanabareun, “Ag ein itanemen?” Goagen koli auremen, “Du banou, tapaimiganem du, na eru ebu dacanem?” ");
INSERT INTO bmh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Guzenina, go nug koli awareun, “Ag piabun e zon.” Guzenaimai, go sesamorai beteimai, gonugau dacaneu zau pemen. Peimai, go al betei ninemen. Einen? Ziwas go umusig pet, em umutabun ena. ");
INSERT INTO bmh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andru go Saimon-Pita nugau amag, go zaug al alemen. Go Zon ze ziwaraneun du nugau ze doimai, zaug al Yesus sesamoremen. ");
INSERT INTO bmh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Umaseu, Yesus nugau zau go uteimai, amegai beteimai, gonugau apag Saimon tuloroimai, aureun, “Ig Mesaia pemun.” (Wanib go Mesaia Hibru ze, Grik ze eiman Kristus anem. Go du go Uwait nug gonugau duailel koli imarabun tapai meun.) ");
INSERT INTO bmh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andru nug Saimon Yesus waugab imai betena, Yesus nug peimai, eneun, “Na Saimon, Zon nugau nag. Aiu ses nait wanim Sipas damau.” (Wanib go Sipas kekulaimai, Pita amam. Wanib gonugau zebigeg go ‘aiwag’.) ");
INSERT INTO bmh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yesus nineimai, umaseu, go Galili agaig ebu bitabun dabeleun. Go beteimai, du tub wanib Pilip tuloroimai, aureun, “Na zoimai, iz sesamilen.” ");
INSERT INTO bmh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip go Betsaida uzanan. Go Andru zaug Pita dual agal uzan. ");
INSERT INTO bmh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Guzenina, Pilip betei, Nataniel tuloroimai, aureun, “Ig du tub tuloromun. Getal Moses nug kasai ze agau ebu du go en sikut weun mui, Uwait nugau ze doimai awaranemen dudu ipal agen han go en sikut wemen. Gonugau wanib Yesus, Nasaret uzanan, Zosep nugau nag.” ");
INSERT INTO bmh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel nug eneun, “Nasaret uzan go ginampet. Ece naliu tub Nasaret uzan eiman alamau ta?” Guzenina, Pilip nug koli aureun, “Na zoiba, uligen.” ");
INSERT INTO bmh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataniel go Yesus waugab bete betena, Yesus nug peimai, eneun, “Ag uligan! Du e aleu, go Israel du tuguianau pet. Go polu ze tub i macaneu.” ");
INSERT INTO bmh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel nug koli Yesus go kanabeun, “Na iz erunai abe milem?” Yesus nug koli aureun, “Pilip na i ulizau ebu, iz na a sabug waugab hoboi daremen peizemin.” ");
INSERT INTO bmh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel gue ze go doimai, aureun, “Du banou, tapaimiganem du, na Uwait nugau Nag, na Israel duailel gumarabun du banou.” ");
INSERT INTO bmh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus nug koli aureun, “Iz na a sabug waugab hoboi daremen aizemin en na ounab petak em ta? Aiu ses nait amen nug gugeg banban beu beu pimam.” ");
INSERT INTO bmh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesus nug kolital aureun, “Iz na petak pet aizem, aiu ses Mesgai im oitaba, Uwait nugau tibur inain Du Nugau Nag dareu sinen nonen, sinen nonen, ai dabi, na piaramam.” ");
INSERT INTO bmh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Gil aliag mazicina, Yesus nug Pilip Nataniel dual ulareun, uzan tub wanib Kana, Galili agaig ebu, du tub gil ainarai ebu, air oun. Yesus nugau anag gue duair go agal egarabun agal zaueim dareun. ");
INSERT INTO bmh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Go Yesus gonugau tapaimareu dudu han ereg duair go agal egarabun zaueim alabun ularena, alai daremen. ");
INSERT INTO bmh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Go wain ze unum poina, Yesus nugau anag nug Yesus guzenai aureun, “Duailel wain ze poemen.” ");
INSERT INTO bmh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesus nug koli aureun, “Anikai, iz na ein igul mabun i ailen. Izal salau mabun ziwas i zuau dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Gonugau anag nug koli wain ze gumanem salau dudu awareun, “Gonug ag ein ze awaraba, ag ze go sesamoran.” ");
INSERT INTO bmh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Zaueim go mis banban wasolig dareun. Go Zuda agal igul ebeag ulusabun guzenanemen. Mis banban tutak tutak, go dram banou sul. ");
INSERT INTO bmh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus nug salau dudu awareun, “Mis e oug ze unum kapai macan.” Goagen gonugau ze doimai, go mis oug ze goriemen. ");
INSERT INTO bmh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Guzenina, go nug awareun, “Ze ipal goriaiban oimai, betei, ee gumaneu du go muran.” Guzenaimai, goagen ze go goriaimai, oi betei moromen. ");
INSERT INTO bmh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Ee gumaneu du gue go ze oi betemen zeun. Ze go wain kekuleun. Go i abiu wain ze go eruan omen. Salau dudu go tutak eruan omen go abiu. Guzenaimai, ee gumaneu du go nug air awau oun du uloron, alina, guzenai aureun, “Dudu ag amegai wain naliu marena, zanem, wain naliu go unum zina, aiu ses wain naliu tam marena, zanem. Bo, na wain naliu e mina, dareun, ulis oi alem!” ");
INSERT INTO bmh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Go gugeg amegai, Yesus nug Kana uzan, Galili agaig ebu, gonugau gusig banou abai marena, gonugau tapaimareu dudu go en goagal oiagab petak emen. ");
INSERT INTO bmh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Go guzenaimai, Yesus gonugau anag amagul abai gonugau tapaimareu dudu mui, Kana uzan utei, Kapaneam uzan beteimai, go ebu ziwas asiu daremenin. ");
INSERT INTO bmh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ziwas go ebu, Zuda duailel agal zobu ziwas Izip emgasag utei alemen dabilanemen zobu, wanib Pasowa ziwas zoi darena, Yesus go Zerusalem ban uzan beteun. ");
INSERT INTO bmh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Go Uwait ecesab muranemen zau banou oug simai, dudu agen bulumakau, sipsip, meg inain oimai, Nou Zaueim go aiwag en dudu ipal marena, goagen gau mina, aiwag oi daremen ebu simai piareun. Dudu ipal aiwag ameg wanem han ereg simai daremen piareun. ");
INSERT INTO bmh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Guzenaimai, go nug us ipal oimai, wakum maimai, egun go inain unum zobu zauan zamarendai, wanemen. Dudu aiwag ameg wanem dudu go agal biz unum esikai marena, goagal aiwag unum hilarai heun. ");
INSERT INTO bmh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dudu go agen meg inain aiwag en dudu ipal marabun daremen go nug gusig ze awareun, “Ecesab go unum oi alian! Ag izal mekai nugau zau go igwanem empip mabun uzan sul i usalai macan.” ");
INSERT INTO bmh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Gonugau tapaimareu dudu agen Yesus nug ze go aneun doimai, ze tub Uwait nugau agau ebu dareu koli dabilemen. Ze go nug guzeneu, ‘Iz nait zau tuguianau suban naliu dabun en oiab oug ab sul elena, gonun, iz salau gusig oi darem.’ ");
INSERT INTO bmh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Zuda dudu banban agen Yesus nug igul go meun uligaimai, koli kanabemen, “Na ig ein gugeg abai migemen, ig abe mamam, na Uwait nug gusig go mizeun?” ");
INSERT INTO bmh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesus nug koli awareun, “Bo, agen Uwait ecesab muranemen zau banou e tigalebi, izan gil ianai ainarai ebu sag koli asai mai.” ");
INSERT INTO bmh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Goagen koli kanabemen, “Nait dabeleu, na Nou Zau banou tub gil ainarai mabun iboi ta? Dudu ag zau e memen wai 46 sag mazicina, poemen.” ");
INSERT INTO bmh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bo, Yesus zobu zau go en anab tam, go gonugau enib en aneun. ");
INSERT INTO bmh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Guzenaimai, Uwait nug Yesus noumeun koli usai morona, ziwas go ebu, gonugau tapaimaraneun dudu agen ze go gonug getal awareun ze go koli dabilemen. Uwait nugau ze go nug en sikut wemen dareun mui, Yesus nug awareun ze en mui, goagal oiagab petak emenin. ");
INSERT INTO bmh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesus go Pasowa ziwas ebu, Zerusalem ban uzan daimai, gugeg beu beu guzenina, duailel asiu go uligaimai, goagal oiagab go en petak emen. ");
INSERT INTO bmh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bo, Yesus go ag en gonugau ougab petak ab tam, einen, agal oiagab oug agal dabeleu abe meun. ");
INSERT INTO bmh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Go nugtal duailel go agal oiagab oug erunai pet dareu abe mareun, gonun, du tub nug duailel go agal igul en aurabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Du tub wanib Nikodemus, go Zuda duailel agal du banou tub. Go Parisi du. ");
INSERT INTO bmh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Umaum tub, go Yesus dareun zaueim beteimai, guzenai aureun, “Du banou, ig abiu na tapaimiganem du banou. Uwait nugtal na palautizena, alemen. Na gugeg beu beu memen sul du tub nug mabun iborain tam. Uwait nugtal du go al daba, petak go gugeg go mamau.” ");
INSERT INTO bmh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus nug koli aureun, “Iz petak pet aizem. Du in go koli awau i usalamau, du go gue Uwait nugau gumarabun uzan i pimau.” ");
INSERT INTO bmh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus nug koli Yesus kanabeun, “Du go banou usaleun erunai koli nanag ginampet usalamau? Go koli anag ougab oug simai, koli awau usalaimai, nuabun iboin ta?” ");
INSERT INTO bmh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus nug koli eneun, “Iz petak pet aizem. Du in go ze mui Uwait nugau Ah Wes mui ze ziwab tam, go Uwait nugau gumarabun empip i simau. ");
INSERT INTO bmh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dudu ag agal enimag memeagar anaiagar eiman wanemen, bo, Uwait nugau Ah Wes nug igual doropig awau muzmuz dabun gusig miganeu. ");
INSERT INTO bmh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na ze e aizem en dabeleu asiu i on. Ag koli awau usalan. ");
INSERT INTO bmh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wol nugtal go zoimai, waneu. Na gonugau saiu sag duanem, bo, go eru eiman zoimai, waneu, na i abiu. Go sul, duailel unum ag Uwait nugau Ah Wes nug awau usalai mareun ag guzental guzenamamen.” ");
INSERT INTO bmh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus nug koli aureun, “Igul go erunai zumau?” ");
INSERT INTO bmh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus nug aureun, “Na Israel emgasag e ebuan duailel tapaimaranem du banou, na erunai igul go abe i mem? ");
INSERT INTO bmh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iz na petak pet aizem. Ig ze go ulis aizai darem go ig unum abe maimai, uligemun. Bo, ag ze go duabun utemen. ");
INSERT INTO bmh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iz ag em e ebuan igul awaremin oiagab petak i amau, gonun, Mesgai wagan igul awaranai, han oiagab petak i amau. ");
INSERT INTO bmh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Em e ebuan du tub Mesgai wag i simai dareu. Tam, Du Nugau Nag sag go Mesgai utei aleun. ");
INSERT INTO bmh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Getal Moses nug du tamacag uzan, em ula ebu, man dorog aumag ebu, asai meun sul, dudu agen Du Nugau Nag han guzental guzenamamen. ");
INSERT INTO bmh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Guzenaimai, duailel inen ag goen agal oiagab petak anemen agal doropag awau muzmuz damau. ");
INSERT INTO bmh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Uwait nug em e ebuan duailel en ougab noumaimai, gonugau nag tutakpaiu palautina, aleun. Go igul go guzenina, duair inen go en oiagab petak amau, go i noumamau, gonugau dorog muzmuz awau damau. ");
INSERT INTO bmh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Einen, Uwait nug gonugau nag em e ebu duailel sisiarabun du sul Uwait nugau ameg ebu ag ze awarabun palautab tam, bo, go duailel agal igul eg ebuan imarabun palautoroun. ");
INSERT INTO bmh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Duair inen go gonugau nag en oiagab petak emen go Uwait nugau ameg ebu ze tamacag. Bo, duair inen go en oiagab petak ab tam, go ze a. Einen, go Uwait nugau Nag tutakpaiu en ougab petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uwait nug em e ebuan duailel guzenai sisiaramau; Uwait nugau al hilanau em e ebu aleun, bo, em e ebuan duailel ag unum em e ebuan igul eg maimai, umaum dabun oiagab noumanem. Agal oiagab oug igul eg mabun sag guzenanem. Guzenaimai, ag Uwait nugau al go en oiagab noumab tam. ");
INSERT INTO bmh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Duailel inen igul eg macanem, go Uwait nugau al hilanau wabun utanem. Al go hilanau nug go igul eg macaneu araog muramoroi ina, uminaimai, al go hilanau ebu i alamau. ");
INSERT INTO bmh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Duair in go igul naliu mamau, go al hilanau ebu zuaneu. Einen, go duair salau mina, go dudu ipal agen go pianem.” ");
INSERT INTO bmh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Go guzenaimai, Yesus go gonugau tapaimareu dudu mui Zerusalem ban uzan uteimai, Zudia agaig ebu betei ziwas asiu daimai, duailel ze ziwareun. ");
INSERT INTO bmh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Zon go han ze tub wanib Ainon, Salim uzan waugab duailel ze ziwarai dareun. Uzan go pezoroi ze asiu dareu, duailel asiu go waugab nuna, go nug ze ziwarai dareun. ");
INSERT INTO bmh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ziwas go ebu, Herot nug Zon hiacaranem zau oug hiab tam ebu, go guzenai dareun.) ");
INSERT INTO bmh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Zon nugau tapaimareu dudu mui Zuda du tub mui ag Uwait nugau ameg ebu naliu usalabun ze ziwanem igul en ze alalemen. ");
INSERT INTO bmh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Guzenaimai, Zon nugau tapaimareu dudu ipal agen beteimai, Zon guzenai auremen, “Igul abai miganem du, na getal du go en anemen Zordan ze gasag am zuaneun eiman na ibaiz dareun koli go en dabelen. Ulis, duailel unum go waugab betena, go nug ze ziwarai dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zon nug koli awaraimai, eneun, “Du tub nugtal go igul tub guzenai mabun iborain tam, bo, Uwait nug gusig muraba, petak igul go mamau. ");
INSERT INTO bmh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ag getal ‘awaremin Iz Kristus tam’ ag domen, bo, Uwait nug iz amegai palautilena, alemin. ");
INSERT INTO bmh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Du tub nug air uba, air go gonugau wau. Ag go don, du go nugau zaugul agal zaiag gonugau air wabun alai dareu doimai, siksikanem. Guzenaital du go alina, iz siksikem. ");
INSERT INTO bmh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Gonugau wanib banou usalamau, izal wanim ginampet usalamau. ");
INSERT INTO bmh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Du go gue Mesgai wageim aleun go nug dudu ipal unum zilarai dareu. Em e ebuan duailel ag em e ebuan ecesab en zeze macanemen. Du go gue Mesgai wageim aleun, go nug em e ebuan duailel unum zilarai dareu. ");
INSERT INTO bmh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Go nugtal gonugau ameg nug ecesab uligeun mui ze ipal dabug nug doun mui duailel awaraneu, bo, dudu asiu gonugau ze doimai, oiagab petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Du in gonugau ze suban doimai, sesamoramau, go ein ze Uwait nug aneu go petak pet araog zumau. ");
INSERT INTO bmh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Du go gue Uwait nug palauteun, go Uwait nugau ze naliu macaneu, einen, Uwait nug gonugau Ah Wes unum muraneu. ");
INSERT INTO bmh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Memeg nug gonugau nag en ougab noumaimai, gonugau gusig unum gonugau ebeg ebu meun. ");
INSERT INTO bmh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Duair in go gonugau nag en ougab petak aimai, gonugau ze suban sesamoraba, goagal doropag muzmuz awau damau. Bo, duair in go gonugau ze sesamoraba, gonugau dorog muzmuz dabun gusig i umau. Uwait nug go en muzmuz aigsisilai zuna, uhu muraneu.” ");
INSERT INTO bmh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesus nug Zon zilacoroimai, duailel asiu ze ziwarena, go sesamorai daremen go dudu ipal agen Parisi dudu awaremen. ");
INSERT INTO bmh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Bo, Yesus nug duailel ze ziwarab tam, gonugau tapaimaraneu dudu agen ze ziwaranemen.) ");
INSERT INTO bmh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Guzenaimai, Dubanou Ban nug ze go doimai, go Zudia agaig uteimai, koli Galili agaig beteun, ");
INSERT INTO bmh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Go abu go sesamorai, Samaria agaig eiman beteun. ");
INSERT INTO bmh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Guzenaimai, go Samaria agaig ebu, uzan tub wanib Sikar (wanib tub Sekem) zoun. Uzan tub, em tub getal Zekop nug gonugau nag Zosep utei moroun waugab dareun. ");
INSERT INTO bmh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Uzan tub ze ulanemen ob tub getal Zekop nug eriai mina dareun. Yesus go abu pulig alaimai, enib uhu usaleun. Am ban ula, gonun, go zoimai, ze go ob waugab hoboun. ");
INSERT INTO bmh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Gonugau tapaimaraneu dudu go unum ban uzan ee gau mabun wanena, Yesus nugtal go ebu dareun. Darena, Samaria air tub go ze ulabun nuna, Yesus nug air go aureun, “O abi, iz ze usegiweu, na ze ule milemen, zai.” ");
INSERT INTO bmh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Guzenina, air go nug koli aureun, “Na Zuda du, iz Samaria air, na einen iz ze mizabun ailem?” Zuda duailel ag Samaria agaig ebuan duailel mui ag go iwai abai dacanemen, ag oiagab tutak i dacanemen. ");
INSERT INTO bmh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus nug koli aureun, “Abi, na Uwait nug ein ecesab mizabun baib mizamau, go iz mui abe milem zob, na iz ailamam, ‘Na iz ze milemen, zai.’ Guzenemen, iz na muzmuz awau dabun ze mizai.” ");
INSERT INTO bmh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Air gonug koli aureun, “Du banou, ze ob e oug unig banou dareu, na ze ulabun mis tamacag. Guzenaimai, na ze go muzmuz awau dabun anem eruan ulai? ");
INSERT INTO bmh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ze ob e igual embigeg Zekop nug utemigeun. Go gonugau gelegul mui gonugau egun inain mui go unum ze go ule zanemen. Nait dabeleu Zekop go du ginampet, na du banou ta?” ");
INSERT INTO bmh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus nug koli aureun, “Duailel ag ze e zaimai, koli ze useg wagaramau. ");
INSERT INTO bmh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bo, duair in izan ze moromin, zimau, go koli ze useg i umau. Ze go izan murai, go gonugau ougab oug, ban ze kapai dacaneu sul, daba, go muzmuz awau damau.” ");
INSERT INTO bmh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Air gonug koli Yesus aureun, “Du banou, iz ze go milemen, zai. Guzenemen, iz koli ze i usegiwamau. Ze ulabun koli i alai.” ");
INSERT INTO bmh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus nug koli aureun, “Na beteiba, nait gamut imaiba, koli alen.” ");
INSERT INTO bmh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Air gonug koli aureun, “Iz du tamacag.” Yesus nug aureun, “Na du tamacag em, go petak pet ailem. ");
INSERT INTO bmh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Einen, getal na dudu tabkwai egaremen. Du tub ulis na ibaiz dareu, go nait gamut pet tam. Na ze go ailem, go petak.” ");
INSERT INTO bmh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Air gonug koli aureun, “Du banou, ulis iz na abe mizem, na Uwait nugau ze doimai, awaranem du. ");
INSERT INTO bmh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Igual embigeg ag em manam e ebu tulaimai, Uwait ulagwag muranemen. Bo, go Zuda duailel agen Zerusalem ban uzan tutak Uwait ulagwag murabun anemen.” ");
INSERT INTO bmh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Guzenaimai, Yesus nug air go aureun, “Abi, na izal ze en nait ounab petak emen. Ziwas tub zumau ziwas ebu, duailel ag igual memenig em manam e ebu ta, Zerusalem ban uzan ta, ulagwag i muramamen. ");
INSERT INTO bmh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Bo, ag Samaria duailel, ag Uwait ulagwag muranemen, bo, ag go suban abe i memen. Ig Zuda duailel ig go abe maimai, ulagwag muranem. Einen, Uwait nug amegai Zuda duailel eiman em e ebuan duailel imarabun baib meun. ");
INSERT INTO bmh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ziwas tub zumau, duailel agal oiagab petak pet emen, ag petak abu tuguiai sesamorebi, Ah Wes nug isanaraba, ag mekai suban ulagwag muramamen. Petak, ziwas go ulis zoi dareu. Izal mekai nug duailel ag igul go eiman ulagwag morona, uligaimai, gonugau ougab naliu usalamau. ");
INSERT INTO bmh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Uwait go wes. Gonun, duailel agen go ulagwag murabun gonugau Ah Wes tutak nug ag isanaraba, ag petak igul sesamoraimai, go ulagwag muramamen.” ");
INSERT INTO bmh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Air gonug Yesus aureun, “Iz abiu Kristus alamau. Gonug alaimai, igul unum abai migamau.” ");
INSERT INTO bmh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Guzenina, Yesus nug koli eneun, “Go iz sag. Ulis iz na ibaiz zeze mai darem.” ");
INSERT INTO bmh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Go ze go aurina aurina, gonugau tapaimaraneu dudu koli alaimai, air go al ze ze mai dareun uligaimai, esilakemen. Bo, du tub nug enai i kanabeun, ‘Na ein ecesab wabun aimai, zeze mai darem? Na einen air go al zeze mai darem?’ ");
INSERT INTO bmh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Guzenaimai, air go nug gonugau ze ulabun mis go ebu uteimai, uzan beteimai, duailel awareun, “Ag du tub piabun alan. Gonug iz ein igul getal guzenemin unum araog ilai aileun. Agal dabeleu go Kristus ta?” ");
INSERT INTO bmh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Guzenaimai, duailel go agen goagal ban uzan uteimai, Yesus piabun betemenin. ");
INSERT INTO bmh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ziwas go ebutal, gonugau tapaimaraneu dudu agen Yesus ee zabun aimai gusig auremen, “Dubanou Ban, na ee zen.” ");
INSERT INTO bmh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bo, go nug koli awareun, “Iz ee a, bo, ee go ag i abiu.” ");
INSERT INTO bmh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Guzenina, tapaimaraneu dudu agzozou ze maimai, enemen, “Du tub nug go ee oialai moroun ta?” ");
INSERT INTO bmh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesus nug guzenai awareun, “Izal ee go Uwait nugau salau em e ebu mabun palautilena, alemin, gonugau salau poabun dabeleu sesamorem. ");
INSERT INTO bmh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Dudu ipal agen guzen anemen, ‘Geil iwanarai mazicina, ee awau ougeman wabun,’ bo, iz ag petak pet awarem, ougem suban ameag nug uligan! Ougeman awau ee naliu usalaba, naliu usaleun wabun iboi. ");
INSERT INTO bmh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Du in gue ougeman go ee waneu, Uwait nug dorog muzmuz awau dabun gusig go muramau. Guzenaimai, du in ee ug baneu mui, du in ee naliu ougeman waneu mui, ag ereg siksikamamen. ");
INSERT INTO bmh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ze go ananem petak pet, ‘du tub nug ee ug bena, du tub nug awau ougeman ee waneu.’ ");
INSERT INTO bmh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iz ag palautaremin, ougem go ag salau i macanemen ebu gaul betei ee umamen. Dudu ipal agen salau banou memen ebuan, ag goagal ee umamen.” ");
INSERT INTO bmh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria agaig ebuan duailel asiu goagal ban uzan daremen go Yesus en goagal oiagab petak emen, einen, air go nug Yesus nug gonugau igul getal guzeneun ze unum aureun en awarina, domen. ");
INSERT INTO bmh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Guzenaimai, Samaria duailel Yesus waugab alaimai, go abai dabun auremen. Guzenaimai, go abai gil aliag dareun. ");
INSERT INTO bmh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","42","Duailel asiu gonugau ze doimai, goagal oiagab petak aimai, air go auremen, “Ig na ze aigemen domun go en igual oigeb petak ab tam, einen, iguatal gonugau ze doimai, igual oigeb petak amau. Ig abiu go sag petak em e ebuan duailel igul eg macanemen ebuan koli imarabun du alai dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesus gonugau tapaimaraneu dudu abai uzan go gil aliag daremen uteimai, koli Galili agaig betemen. ");
INSERT INTO bmh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesus nugtal eneun, “Uwait nugau ze doimai, awaraneu du go nugau emgasag ebu gonugau wanib ulagwag tamacag, gonun, gonugau ze sesamorab utem.” ");
INSERT INTO bmh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bo, go Galili betemai, duailel go ebuan siksikaimai imaiemen, einen, go Pasowa ziwas ebu Zerusalem ban uzan simai, gugeg beu beu maba, piabun guzenemen. ");
INSERT INTO bmh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Guzenaimai, Yesus Kana uzan getal ze wain kekuleun uzan koli beteun. Gavman du banou tub Kapaneam uzan gonugau nag ebeu mui dareun. ");
INSERT INTO bmh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Go Yesus Zudia agaig an Galili aleun doimai, go beteimai, gonugau nag Kapaneam uzan noumabun ina, kasamau aimai kanababun beteun. ");
INSERT INTO bmh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus nug duailel daremen awareun, “Ag, oiagab petak i anemen duailel. Ag gugenag beu beu uligaimai, ziwas go tutak agal oiagab petak anemen.” ");
INSERT INTO bmh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Du banou go nug aureun, “Du banou, na iz ibail i alamam aba, izal nagwai noumamau.” ");
INSERT INTO bmh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Guzenina, Yesus nug aureun, “Na umin ien, na koli beten, nait nan i noumamau, awau damau.” Du go gue Yesus nugau ze en ougab petak aimai, beteun. ");
INSERT INTO bmh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Go abu ebu, betei betena, gonugau salau dudu agen pigai alaimai, auremen, “Nait nan noumab tam, naliu dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Gonug kanabareun, “Ein ziwas ebu, go naliu usaleun?” Goagen koli auremen, “Um amban, am ulawag, gonugau ebeu utei waneun.” ");
INSERT INTO bmh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Guzenaimai, memeg nug ziwas go ebutal Yesus nug ‘Nait nan awau damau’ aureun koli dabeleun. Guzenaimai, nug mui gonugau ug abai ereg goagal oiagab Yesus en petak emenin. ");
INSERT INTO bmh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Getal Yesus nug Zudia agaig uteimai, Galili agaig alaimai, gugeg tub meun. Ziwas go ebu, go kolital alaimai, gugeg guzenaital meun. ");
INSERT INTO bmh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Guzenaimai, Yesus go Zuda duailel agal zobu banou tub piabun ziwas mina, go Zerusalem ban uzan sieun. ");
INSERT INTO bmh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Uzanan gilan og, wanib Sipsip agal abuog waugab, ban ze tub wanib, Betesda dareun. (Wanib go Hibru ze eim.) Ze go gasag zau huia tabkwai daremen. ");
INSERT INTO bmh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Zaueim go ebeu duailel asiu, ameag kumi duailel mui, aramag eg duailel mui, duailel aramag noumeun abai ereg daremen. Go ze go ameg hiloialoiabun gumei dacanemen. ");
INSERT INTO bmh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Go gue guzenanem, einen, ziwas ipal ebu, Uwait Banou nugau tibur ze go unig oug nuna, ze ameg hiloialoiena, uligaimai, in ebeu du amegai ze go oug nuna, gonugau ebeu poaneu. ");
INSERT INTO bmh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Go ebu, du tub wai 38 sag asai aidabun iborain tam dareun. ");
INSERT INTO bmh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus gue du go dareun uligeun. Go du gonugau ebeu wai asiu mui dareun abe maimai, du go kanabeun, “Nait dabeleu na koli naliu usalabun iboin ta?” ");
INSERT INTO bmh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ebeu du go nug koli aureun, “Du banou, e ebu ze ameg hiloialoianeu ebu du tub nug iz isanileimai, imailei noi ze ebu heilabun du tam. Iz nuamoroi emintal, du tub nug pigai nuaneu.” ");
INSERT INTO bmh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Guzenina, Yesus nug aureun, “Na asaib, nait biz oiba, utei alien.” ");
INSERT INTO bmh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ziwas go ebutal du go nugau ebeu utei wanena, go pigai asaimai, gonugau biz oimai, waneun. Ziwas go Zuda agal imabun ziwas, wanib Sabat. ");
INSERT INTO bmh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Guzenaimai, Zuda dudu banban agen ebeu du go naliu mina, auremen, “Imabun Ziwas Zobu e, igual kasai ze eiman eneu ‘Na nait biz Imabun Ziwas Zobu ebu i gamai aidanen.’” ");
INSERT INTO bmh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ebeu du go nug koli awareun, “Du go iz kasileun, nug ‘Na nait biz oiba, alien’, aimai aileun, gonun, iz guzenemin.” ");
INSERT INTO bmh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Goagen koli kanabemen, “Du go in nug aizena, na igul go guzenemen? Ig du go abai migen.” ");
INSERT INTO bmh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bo, du go naliu usaleun go in nug kasai meun go han i abiu. Duailel asiu go ebu daremen, gonun, Yesus gue go ula eiman waneun. ");
INSERT INTO bmh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ziwas tub ebu, Yesus nug du go Nou Zau banou zaueim peimai, aureun, “Na donen, na ulis naliu usalem, gonun, na koli koli zigulin i men. Na guzenamam koli uhu banou pet umam.” ");
INSERT INTO bmh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Guzenina, du go nug Yesus abe moroimai, beteimai, Zuda dudu banban Yesus nug go kasai meun aimai betei awareun. ");
INSERT INTO bmh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesus go Imabun Ziwas Zobu ebu igul go meun, gonun, Zuda dudu banban go Yesus eg murabun dabilemenin. ");
INSERT INTO bmh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesus nug awareun, “Izal mekai go muzmuz salau mai dareu, gonun, iz han salau mai darem.” ");
INSERT INTO bmh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Guzenaimai, ze go en Zuda dudu banban asai marena, go aiag sisilena, Yesus webi, noumabun dabilemen. Go Imabun Ziwas Zobu nugau kasai ze zilacoroun, mui nugtal awareun, ‘Uwait izal mekai’. Go ze go guzeneun, gonun, go nug iza Uwait sul eun. Agal dabeleu go igul eg aliag meun, gonun, ag go webi, noumabun gusig dabilemenin. ");
INSERT INTO bmh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Guzenaimai, Yesus nug goagal dabeleu abe maimai, koli guzenai awareun, “Iz ag petak pet awarem, Nag go igul tub gonugau dabeleu eiman mab tam, go gonugau Memeg nug ein igul mina peimai, gonugau Nag nug guzental macaneu. Ein igul Memeg nug mina, gonugau Nag nug han macaneu. ");
INSERT INTO bmh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Memeg nug gonugau Nag en ougab noumaimai, ein igul nug macaneu sul gonugau Nag abai muraneu. Go gonugau Nag igul naliu pet abai morona, ag go igul go mamau uligaimai, esilakamamen. ");
INSERT INTO bmh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Memeg nug noumanem dudu asai maraimai, doropag awau muzmuz dabun maraneu sul, gonugau Nag nug han gonugau dabeleu eiman dudu ipal guzental guzenaramau. ");
INSERT INTO bmh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Memeg nug duailel i sisiaramau. Salau go unum gonugau Nag moroun. ");
INSERT INTO bmh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Guzenaimai, duailel unum Memeg nugau wanib ulagzanemen sul, gonugau Nag nugau wanib han ulagzan. Memeg nug Nag palautina, aleun, gonun, du in go Nag nugau wanib i ulagzaneu, Memeg nugau wanib han i ulagzimau. ");
INSERT INTO bmh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Iz petak pet awarem, du in go izal ze doimai, iz palautilena, alemin du go en gonugau ougab petak amau, gonugau dorog muzmuz awau damau. Gonug du go nugau igul i sisiai muramau. Gonug noumabun igul zilacoroun, ulis awau muzmuz dareu. ");
INSERT INTO bmh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iz ag petak pet awarem, ziwas zumau anemen ulis e zoi dareu, noumemen dudu ag Uwait nugau Nag nugau ze dumamen. Gonugau ze dumamen dudu agal doropag asaimai, muzmuz awau damamen. ");
INSERT INTO bmh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mekai go nugtal awau dabun gusig mui. Gonug Nag gusig go moroun. Guzenina, go han nugtal awau dabun gusig mui. ");
INSERT INTO bmh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Go Du Nugau Nag, gonun, Memeg nug duailel sisiarabun gusig moroun. ");
INSERT INTO bmh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ag ze go doiban, dabeleu asiu i on. Ziwas zumau ebu noumemen duailel ag gonugau ze doimai, go asamai, ob oug eiman alamam. Duailel ag igul naliu macanemen, ag koli asaimai, agal doropag muzmuz awau dabun umamen. Duailel go ag igul eg macanemen go asebi, sisiarabun du nug agal igul eg uligaimai, ag unum igul eg macanemen awaramau.” ");
INSERT INTO bmh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesus nug koli awareun, “Iz izal dabeleu eiman igul tub i macanem. Izal mekai nug iz erunai duailel sisiarabun ailina, iz guzental sisiaranem. Guzenaimai, izal sisiaranem igul naliu, einen, iz izatal izal dabeleu eiman i macanem. Iz Mekai nugtal duailel sisiarabun dabeleu milena, macanem. Iz izal oiab siksikabun i macanem, iz du go iz palautilena, alemin nugau ougab siksikabun manem. ");
INSERT INTO bmh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ag go don, iz iza en ze maremin, dudu ipal ag izal ze en agal oiagab petak i amamen. ");
INSERT INTO bmh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","Bo, du tub nug iz en ze maraba, ag gonugau ze doimai, agal oiagab petak abun iboi. Zon go ze ziwaraneun du, go izal wanim araog mai aidaneun. Ag unum gonugau ze duabun aimai betemen. Iz ag petak pet awarem, du go gue iz en ze meun go petak pet. ");
INSERT INTO bmh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Em ebuan dudu ag izal wanim araog mai aidanemen dudu en ban i dabilan, bo, izal dabeleu Uwait nug agal igul eg ebuan imarabun, iz ag ze e go en awarem. ");
INSERT INTO bmh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zon go al sul, duailel al mareun. Ag gonugau al uligaimai, siksikaimai, ziwas hogu al go ebu dacanemen. ");
INSERT INTO bmh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ze tub iz en eneu. Go Zon nugau ze zilacorou. Salau go izal mekai nug iz mabun mileun, iz ulis mai darem. Ag salau go uligaimai, abe mamamen go iz palautilena, alemin. Gonun, salau e ulis mai darem Zon nug aneun araog mileu. ");
INSERT INTO bmh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mekai nugtal iz palautilena, alemin, nugtal izal wanim araog mileun. Ag gonugau zeu duab tam. Ag go piab tam. ");
INSERT INTO bmh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ag izal mekai nug iz palautilena, alemin, go en agal oiagab petak ab tam, gonun, gonugau ze han agal oiagab oug dab tam. ");
INSERT INTO bmh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ag umkoskos Uwait nugau ze nanalanemen, go agal dabeleu Uwait nugau sikut nug ag awau muzmuz dabun aimai guzenanemen. Sikut go wemen go iz en anemen. ");
INSERT INTO bmh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bo, ag iz waiab awau muzmuz dabun alab utemen. ");
INSERT INTO bmh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Iz dudu agen izal wanim ulapwag milabun aimai i awarem. ");
INSERT INTO bmh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bo, iz agal igul abiu. Ag Uwait en oiagab i noumanemen. ");
INSERT INTO bmh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iz mekai nugau gusig mui alemin. Ag izal ze duabun utemen, bo, du tub go nugau gusig mui alina, ag gonugau ze duanemen. ");
INSERT INTO bmh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ag agal zaiagar agen agal wanimag wag marabun guzenanemen. Bo, wanimag banou go Uwait nug eiman tutak alaneu, ag go wabun utei daremen. Ag igul go sesamoraimai, iz en agal oiagab erunai petak amamen? ");
INSERT INTO bmh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Iz ag izal mekai nugau ameg ebu agal enimag ebu ze mai darem aimai i dabilan. Tam pet tam. Du go Moses getal agal dabeleu ‘go ig isanigamau’ aimai, go ulagwag moromen, go nug agal enimag ebu ze mamau. ");
INSERT INTO bmh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ag Moses nugau ze doimai, agal oiagab petak emen zob, ag izal ze han doimai, oiagab petak emen zob. Einen, go nug ze go iz en sikut weun. ");
INSERT INTO bmh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bo, ag ze go gonug sikut weun doimai, agal oiagab petak ab tam, gonun, erunai izal ze han ag doimai, oiagab petak amamen?” ");
INSERT INTO bmh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesus go duailel ze ze maraimai, tebil wag silikaimai, gonugau tapaimaraneu dudu abai Galili Ze Unig tubaim betemen. Ze unig go wanib tub Tiberias. ");
INSERT INTO bmh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gonug duailel ebeu mui go kasarena, duailel asiu go gugeg go meun uligaimai, go sesamorai betemen. ");
INSERT INTO bmh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesus go em manam ebu simai, gonugau tapaimaraneu dudu abai hoboun. ");
INSERT INTO bmh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Go Zuda agal zobu pemen ziwas ebu, Zuda agal embigeg Moses dual getal Izip emgasag utei alemen dabilanemen zobu, wanib Pasowa, ziwas hogu zoi dareu. ");
INSERT INTO bmh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus go ameg heun, duailel asiu go waugab alina, uligaraimai, go nug gonugau tapaimoroun du Pilip guzenai kanabeun, “Ig ee eruan gau maimai, duailel e maremun, zimam?” ");
INSERT INTO bmh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesus go ein igul nugtal mabun abe maimai, Pilip nugau dabeleu piabun kanabeun. ");
INSERT INTO bmh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip nug koli eneun, “Bo, duailel asiu darem, gonun, ig aiwag handret aliag kina oimai bret gau maimai, duailel unum tutak tutak ee ginaginam maremun, zimam. Go han iboin tam.” ");
INSERT INTO bmh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Yesus nugau tapaimaraneu du tub Andru, go Pita nugau amag, go nug Yesus aureun, “Mogoi tub gonugau bret tubkwai mui, karuk aliag mui patai dareu. Bo, duailel asiu ee go marabun sul iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Gig hubabun naliu dareun. Gonun, Yesus nug gonugau tapaimaraneu dudu awareun, “Ag duailel awarebi, hubamam.” Guzenina, tapaimaraneu dudu agen duailel hubabun awarina, go unum hoboi betemen. Hobomen dudu go asiu, tausen tabkwai sag. ");
INSERT INTO bmh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Go hobona, Yesus nug mogoi gonugau bret oimai, Uwait ‘Ese-e’ auraimai, kikakarena, gonugau tapaimaraneu dudu agen duailel go hoboi daremen unum marai betemen. Karuk han oimai, guzental igul mina, duailel zaimai, go biguiag zoun. ");
INSERT INTO bmh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Duailel go unum biguiag zuna, Yesus nug gonugau tapaimaraneu dudu awareun, “Ag ee ogog utemen i sakaran, unum gotulaiman.” ");
INSERT INTO bmh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Goagen ee duailel agen ogog utemen gotulaimai, gom gau zo begurug sag kapai memen. ");
INSERT INTO bmh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Duailel gugeg go Yesus nug meun uligaimai, enemen, “Petak pet, du e go Uwait nugau ze doimai, awaraneu du getal Uwait nug em e ebu palautena, alabun eun.” ");
INSERT INTO bmh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Go Yesus gusig pataimai, goagal gumaraneu du banou king usalai mabun dabilei daremen. Yesus goagal dabeleu abe maimai, go nugtal go utarai em manam wag simai, dareun. ");
INSERT INTO bmh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Umusig mina mina, Yesus nugau tapaimaraneu dudu Galili Ze Unig gasag noimai, tebil wag simai, koli Kapaneam uzan bitabun betemen. Em umut gitacena, Yesus go waiagab alab tam. ");
INSERT INTO bmh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wol gusig banou pet zoimai, ibut ze asai meun. ");
INSERT INTO bmh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","20","Yesus nugau tapaimaraneu dudu ban ze ula betei darena, Yesus go ban ze go wageiman tapai tapai, tebil go beteun eiman aleun. Go uligaimai, banban uminina, gonug awareun, “E izanag. Ag umin ian.” ");
INSERT INTO bmh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Guzenina, go oiagab siksikaimai, tebil go ebu imai aimai, simai, tebil uzan go bitabun emen ebu pigai betemenin. ");
INSERT INTO bmh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nineimai, umaseu, duailel asiu go ban ze tubaim daremen go abiu um tebil tutak dareun uligemen. Go abiu Yesus go gonugau tapaimaraneu dudu abai tebil go wag eiman bitab tam. Tapaimaraneu dudu agtal wanemen. ");
INSERT INTO bmh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tebil ipal Tiberias uzan uteimai, ban ze gasag beteimai, getal Dubanou Ban nug Uwait ‘Ese-e’ auraimai, duailel bret marena, zemen ebu zomen. ");
INSERT INTO bmh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Duailel go Yesus gonugau tapaimaraneu dudu abai piarab tam, gonun, goagen tebil ipal wag simai, Yesus itanai Kapaneam uzan betemenin. ");
INSERT INTO bmh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Duailel goagen betei, Yesus ze gasag tubaiman tuloroimai, kanabemen, “Du banou, na e ebu eisab alemen?” ");
INSERT INTO bmh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesus nug koli awareun, “Iz petak pet awarem, ag iz gugeg beu beu abai maremin en itanilab tam, ag bret go maremin biguiag zoun, gonun, sesamilai alemen. ");
INSERT INTO bmh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ag ee go pigai belaneu en i salau gusig macan, ag ee awau muzmuz dabun en salau macan. Ee go Du Nugau Nag nug maramau, einen, memenig Uwait nug gonugau ougab siksikaimai, gusig moroun.” ");
INSERT INTO bmh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Guzenaimai, goagen koli Yesus kanabemen, “Ig ein salau maimai, Uwait nugau dabeleu sesamoramam?” ");
INSERT INTO bmh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Guzenina, Yesus nug koli guzenai awareun, “Uwait nugau salau enai, ag du go Uwait nug palautina, aleun en agal oiagab petak amau.” ");
INSERT INTO bmh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Go ze go doimai, goagen koli kanabemen, “Na ein gugeg memena, ig uligaimai, igual oigeb petak amau? Na erunamam? ");
INSERT INTO bmh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Igual embigeg getal du tamacag uzan em ula ebu ee tub wanib mana zemen. Getal Uwait nugau ze eim guzeneun, ‘Gonug ag Mesgai wagan bret marena, zemen.’” ");
INSERT INTO bmh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesus nug kolital awareun, “Iz petak pet awarem, Moses nug Mesgai wagan bret marab tam. Izal mekai nug petak Mesgai wagan bret maraneu. ");
INSERT INTO bmh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bret go Uwait nug maraneu, go Mesgai wageiman alaimai, em e ebuan duailel awau muzmuz dabun gusig maraneu.” ");
INSERT INTO bmh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Guzenaimai, goagen Yesus auremen, “Du banou, na ig umkoskos bret go migamam.” ");
INSERT INTO bmh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus nug kolital awareun, “Iztal iz go awau muzmuz dabun bret. Duair in iz waiab alaimai, gonugau ougab iz en petak amau, duair go gue we i wamau, go ze i usegwamau. ");
INSERT INTO bmh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bo, iz getal awaremin, ag iz uligilemen, bo, agal oiagab iz en petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Izal mekai nug duailel iz mileun, ag unum iz waiab alamamen. Duair in go iz waiab alamau, izan go i zamorai. ");
INSERT INTO bmh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Einen, iz izal dabeleu eiman salau mabun Mesgai utei alab tam, palautileun du gonugau salau oi murabun palautilena, alemin. ");
INSERT INTO bmh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Palautileun du go nugau dabeleu eiman palautilena, alemin, gonun, go nug duair tub iz milamau izan go i utai. Aiu ses em tamabun ziwas ebu, koli go awau muzmuz dabun asai murai. ");
INSERT INTO bmh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Duair in nag peimai, gonugau ougab petak amau go awau muzmuz damau. Petak, go izal mekai nugau dabeleu. Izan em e tamabun ziwas ebu duair go koli asai murai.” ");
INSERT INTO bmh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zuda dudu banban go Yesus nug gosag Mesgai wagan bret eun doimai, go aiag sisilina, gonugau enib ebu ze asiu memen. ");
INSERT INTO bmh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Guzenaimai, goagen agzozou ze maimai, enemen, “Du e go Yesus, Zosep nugau nag. Gonugau memeg anag go ig abiu. Erunaimai, go ulis eneu ‘Iz Mesgai wageiman alemin’ eu?” ");
INSERT INTO bmh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesus nug awareun, “Ag agzozou ze i alalan. ");
INSERT INTO bmh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Du tub go nugtal gonugau dabeleu eiman iz waiab alabun iborain tam, mekai nugtal gonugau dabeleu asai moroimai, iz waiab imai alamau. Noumaba, aiu ses tamabun ziwas ebu, izan koli go asai murai. ");
INSERT INTO bmh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Uwait nugau ze doimai, awaranemen dudu ipal agen guzenai sikut wemen, ‘Duailel unum Uwait nug abai maramau.’ Duair in memeg nugau ze doimai sesamoramau go iz waiab alamau. ");
INSERT INTO bmh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Du tub nug Memenig i pei dareu. Du go gue Uwait al dareun, aleun go tutak Memenig peun. ");
INSERT INTO bmh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iz petak pet awarem, duair in gonugau ougab iz en petak amau, duair go gue muzmuz awau damau. ");
INSERT INTO bmh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iztal awau muzmuz dabun bret. ");
INSERT INTO bmh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Getal agal asanagar du tamacag uzan em ula ebu ee tub wanib ‘mana’ zemen, go unum noumemenin. ");
INSERT INTO bmh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bo, bret go Mesgai uteimai, aleun, du in bret go zimau go i noumamau. ");
INSERT INTO bmh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iz go awau muzmuz dabun bret Mesgai wageiman alemin, du in gue bret go zimau, go awau muzmuz damau. Bret go moromin, zimau, go izal tabui. Em go ebuan duailel izal tabui maremin, ag awau muzmuz damamen.” ");
INSERT INTO bmh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Go guzenai awarina, Zuda duailel agzozou ze eiman alalaimai, enemen, “Du go nugtal gonugau tabug ig zabun erunai migamau?” ");
INSERT INTO bmh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesus nug koli guzenai awareun, “Iz petak pet awarem, duair in go Du Nugau Nag gonugau tabug eseu mui i zimau duair go gue awau muzmuz i damau. ");
INSERT INTO bmh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Duair in go izal tabui esep mui zimau, gonugau dorog awau muzmuz damau. Aiu ses em tamabun ziwas ebu izan go koli awau dabun asai murai. ");
INSERT INTO bmh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Izal tabui go ee pet pet, izal esep go ze pet pet. ");
INSERT INTO bmh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Duair in go izal tabui esep mui zimau, gonugau dorog iz ibail pezile damau, izal dorop han go al pezai dai. ");
INSERT INTO bmh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Izal mekai muzmuz awau dareu nug iz palautileun. Iz gonugau gusig eiman awau darem, gonun, duair in izal tabui zimau go awau muzmuz damau. ");
INSERT INTO bmh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bret e Mesgai uteimai, aleun, bret go agal asanagar agen zaimai, noumemen sul tam. Duair in go bret e zimau go awau muzmuz damau.” ");
INSERT INTO bmh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus nug Kapaneam uzan, Zuda duailel agal gotulanemen zaueim, ze go mareun. ");
INSERT INTO bmh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesus nugau tapaimaraneu dudu asiu go gonugau ze doimai, enemen, “Ze go uhu ban, du in go sesamorabun iboin?” ");
INSERT INTO bmh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesus nug gonugau tapaimaraneu dudu agal dabeleu eg omen abe maimai, awareun, “Ze go nug agal dabeleu eg wai meu ta? ");
INSERT INTO bmh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ag Du Nugau Nag getal dareun uzan koli simai, uligaimai, ag erunamamen? ");
INSERT INTO bmh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ah Wes nug du awau dabun gusig muramau. Igual enimig nug ig i isanigamau. Ze go iz awarem, go Ah Wes nug mileun. Ag ze go doimai, ag awau damamen. ");
INSERT INTO bmh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bo, duailel ipal ag abai daremen, goagal oiagab petak ab tam.” Dudu go agal oiagab petak ab tam, Yesus go getal abe meun. Go nug du go iwai zaugul ebeagab ebu maramau du, go han abe meun. ");
INSERT INTO bmh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Guzenaimai, go nug eneun, “Gonun iz awaremin, bo, izal mekai nug du iz waiab alabun gusig i muraba du go iz waiab i alamau.” ");
INSERT INTO bmh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesus nug ze go aneun en, gonugau tapaimaraneu dudu ipal go utei wanemen. Ag go koli sesamorai aidab tam. ");
INSERT INTO bmh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Guzenina, Yesus nug gonugau tapaimaraneu dudu begurug sag kanabareun, “Ag han iz utilai unamamen ta?” ");
INSERT INTO bmh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon-Pita nug koli ze meun, “Dubanou Ban, ig in waugab bitamam? Nait ze go awau muzmuz dabun ze aigem. ");
INSERT INTO bmh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ulis ig igual oigeb na en petak ze migem, na du tuguianau pet, na Uwait nug eiman alemen abe mizem.” ");
INSERT INTO bmh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesus nug koli awareun, “Izanagtal ag begurug sag tapai maremin. Bo, du tutak go ag ula dareu gonugau ougab oug wes eg mui dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Go Saimon-Iskariot nugau nag, Zudas en aneun. Go Yesus nugau tapaimaraneu du, bo, go nug aiu ses Yesus gonugau iwai zaugul agal ebeagab ebu mamau.) ");
INSERT INTO bmh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesus gue ze go awaraimai, go Galili agaig uzan tutak tutak peipei beteun. Go koli Zudia agaig bitab tam, einen, Zuda dudu banban agen webi, noumamau en abu itanai daremen. ");
INSERT INTO bmh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Go Zuda duailel agal zobu go wain ougem salap zau ebu dacanemen ziwas zoi dareu. ");
INSERT INTO bmh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Guzenaimai, Yesus nugau amagul agen auremen, “Na uzan e uteiba, Zudia agaig beten. Guzenamam, nait tapaimaranem dudu na gugeg beu beu memen, go uligizamam. ");
INSERT INTO bmh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Du tub wanib go ulagwag murabun gonugau salau i wageimai macaneu. Na duailel agal ameagab ebu nait salau manem, Guzenemen, em e ebuan duailel unum abe mizamam.” ");
INSERT INTO bmh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gonugau amagul ze go memen, einen, go han go en goagal oiagab petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesus nug koli awareun, “Izal bitabun ziwas zuab tam. Bo, ag ein ziwas bitabun go iboi. ");
INSERT INTO bmh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Em e ebuan duailel ag gasageim i hiacaranemen, ag iz gasageim heilanemen. Izan ag em e ebuan igul eg macanemen awaranem, gonun, ag go en iz gasageim heilanemen ");
INSERT INTO bmh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Izal ziwas zuab tam, gonun, iz ziwas go zobu piabun i bitai, agtal bitan.” ");
INSERT INTO bmh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Go guzenai awaraimai, go Galili agaig dareun. ");
INSERT INTO bmh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Gonugau amagul unum go zau ginampet ebu dacanemen zobu piabun Zerusalem ban uzan sina, go wage wageimai ses sesamarai sieun. Go araog bitab tam. ");
INSERT INTO bmh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Zobu go ebu Zuda dudu banban agen go itanaimai, enemen, “Du go gue eru dareu?” ");
INSERT INTO bmh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Duailel asiu go ula agzozou ze sisiaimai, Yesus en ze memen, “Go du naliu.” Guzenina, ipal agen ze memen, “Tam, go duailel polumaraneu.” ");
INSERT INTO bmh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bo, du tub nug ze araog mabun iborain tam, einen, go Zuda dudu banban uminaremen. ");
INSERT INTO bmh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Zobu go ulagzanemen ziwas ula ebu darena, Yesus nug Nou Zau banou zaueim simai, duailel araog Uwait nugau ze mareun. ");
INSERT INTO bmh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Zuda dudu banban go Yesus nug ze mareun doimai, esilakaimai, enemen, “Du e go abiu banou ebu bitab tam, go erunai ze go abe macaneu?” ");
INSERT INTO bmh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus nug goagal ze doimai, awareun, “Iz ze e awarem go izal dabeleu eiman tam, go Uwait nugau ze, nugtal iz palautilena, alemin. ");
INSERT INTO bmh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Du in go Uwait nugau dabeleu tuguiai sesamorabun damau du, iz ze e mai darem Uwait nug ebuan ta, izal dabeleu eiman mai darem ta, go abe mamau. ");
INSERT INTO bmh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Du in go gonugau dabeleu eiman ze maneu, go gonugau wanib ulagwag mabun guzenaneu. Du in gonugau palautoroun du nugau wanib ulagwag murabun ze macaneu, go i polumaneu, go du go tuguianau. ");
INSERT INTO bmh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Getal Moses nug kasai ze awareun, ag unum abiu. Ag kasai ze go suban sesamorab tam. Ag einen iz iwabun guzenai daremen?” ");
INSERT INTO bmh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Duailel asiu daremen agen enemen, “Wes eg nait ounab oug dareu. Inen agen na niwaporoi?” ");
INSERT INTO bmh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus nug koli awareun, “Iz gugeg tutak memin ag uligaimai, esilakemen. ");
INSERT INTO bmh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ag go don, Moses nug agal geleagar agal enimag galau kuatabun kasai ze mareun. Gonun, ag Imabun Ziwas Zobu ebu agal enimag galau kuatanemen. Enimag galau kuatabun igul go Moses eiman alab tam, go embigeg Abraham eiman aleun. ");
INSERT INTO bmh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Go ag Moses nugau kasai ze sesamorabun agal geleagar agal enimag galau Imabun Ziwas Zobu ebu kuatanemen. Izan du tub nugau enib Imabun Ziwas Zobu ebu unum kasai memin en agen iz ibail einen iwai daremen? ");
INSERT INTO bmh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ag agal ameag nug ein ece naliu i sisian. Ag igul naliu eiman ece unum subantal sisian.” ");
INSERT INTO bmh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zerusalem duailel ipal agen Yesus nug ze go awareun doimai, enemen, “Du e go Zuda agal dudu banban agen webi, noumabun ze mai darem ta? ");
INSERT INTO bmh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ag uligan, go duailel ameagab ebu ze araog ze meu. Du tub nug go enib ebu ze i meun. Dudu banban agal dabeleu go petak Kristus ta? ");
INSERT INTO bmh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ig du e nugau uzan abiu, bo, Kristus zuba, go eru eiman zoun du tub nug i abe mamau.” ");
INSERT INTO bmh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus Nou Zau banou oug duailel ze maraimai, gusig awareun, “Ag iz en mui izal uzan mui petak abiu ta? Iz izal dabeleu eiman alab tam, du go nug palautileun go petak pet dareu. Ag go i abiu. ");
INSERT INTO bmh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bo, iz go abiu. Iz go al daremin, go nug palautilena, alemin.” ");
INSERT INTO bmh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Guzenai ze mina, doimai, dudu go agen go gusig pataporoi. Du tub nug gusig patab tam, einen, gonugau gusig patabun ziwas zuab tam. ");
INSERT INTO bmh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bo, duailel ipal go ula daremen goagal oiagab petak emen, einen, goagen ze memen, “Kristus alaba, du e nugau gugeg beu beu macaneu go nug zilaorou ta? Igual dabeleu go tam.” ");
INSERT INTO bmh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Duailel agen Yesus nug gugeg beu beu meun en ze asiu ze sisicina, Parisi dudu agen doimai, Uwait ula dacanemen dudu banban abai gotulaimai, goagal malai dudu Yesus gusig patabun palautarena, betemen. ");
INSERT INTO bmh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Guzenina, Yesus nug awareun, “Iz ag abai ban i dai. Iz du go nug palautilena, alemin go waugab koli siai. ");
INSERT INTO bmh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ziwas go ebu, ag iz itanilamamen, bo, ag iz i peilamamen. Iz uzan danai ag i alamamen.” ");
INSERT INTO bmh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Go guzenai awarina, Zuda dudu banban agzozou zemenar, “Du e eru ebu unabun aimai, ig go i pimam aigeu? Go Grik emgasag igual duailel ipal daremen ebu beteimai, go ebu Grik duailel abiu marabun ze meu ta? ");
INSERT INTO bmh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Go ein en aimai, ‘Ag iz itanilamamen, bo, ag iz i peilamamen. Iz uzan danai ag i alamamen,’ eu, ze go zebigeg erunai?” ");
INSERT INTO bmh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Salap zaueim dacanemen zobu go poabun ziwas ebu, go gonugau ziwas banou pet. Ziwas go ebu Yesus asaimai, araog guzenai ze meun, “Ag go don, duair in go ze useguba, go iz waiab alaimai, ze zimau. ");
INSERT INTO bmh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Getal Uwait nugau ze nug eneun, ‘Duair in iz en ougab petak amau, gonugau ougab oug muzmuz dabun ze kapai og zoimai, esikai numau.’” ");
INSERT INTO bmh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Go Uwait nugau Ah Wes en aneun, ‘Du in go en ougab petak amau go Ah Wes umau,’ eun. Ziwas go, Yesus go Mesgai i siau ebu, gonun, Uwait nug Ah Wes palautina, alab tam. ");
INSERT INTO bmh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Duailel agen ze go doimai, enemen, “Petak pet, du go gue Uwait nugau ze doimai, awaraneu du. Uwait nug palautina, alabun eun.” ");
INSERT INTO bmh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ipal agen enemen, “Go Kristus, Uwait nug gonugau duailel koli imarabun palautina, aleun.” Bo, ipal agen enemen, “Kristus go Galili eiman zumau ta? Tam pet tam. ");
INSERT INTO bmh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Uwait nugau ze nug eneun, ‘Kristus go Devit nugau ug eiman usalamau, go Betlehem uzan getal Devit dareun ebu zumau.’” ");
INSERT INTO bmh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Guzenaimai, duailel go Yesus en dabeleu asiu oimai, agzozou atalaimai, ug aliag usalemen. ");
INSERT INTO bmh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Dudu ipal agen go gusig pataporoi emen, bo, du tub nug go gusig patab tam. ");
INSERT INTO bmh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Guzenaimai, go Nou zobu zauan malai dudu go koli Uwait ula dacanemen dudu banban mui, Parisi dudu mui, waiagab betena, goagen guzenai awaremen, “Ag go einen imai alab utemen?” ");
INSERT INTO bmh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Guzenina, malai dudu agen koli awaremen, “Go ze mai dareu sul, du tub nug guzenai ze i macaneu.” ");
INSERT INTO bmh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Guzenaimai, Parisi dudu agen koli awaremen, “Gonug ag han polumareu ta? ");
INSERT INTO bmh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ig dudu banban mui, Parisi dudu ula ebu, du tub go en ougab petak eun ta? Tam. ");
INSERT INTO bmh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bo, duailel e ag kasai ze i abiu, ag go en oiagab petak emen, ag Uwait nug unum eg maramau.” ");
INSERT INTO bmh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Nikodemus du go gue getal Yesus waugab beteun, go dudu banban go agal salau zaiag, go nug guzenai awareun, “Igual kasai ze eim du tub nugau ze gaul sisiai murab, ze meu ta? Tam pet tam. Ig gonugau ogusau nug ze aigena, gonugau ze erunai pet mamau doimai, petak gonugau ze sisiai murab.” ");
INSERT INTO bmh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Goagen koli auremen, “O, na han, na Galili du ta? Na Uwait nugau ze suban nanalaib, abe men, Uwait nugau ze doimai, awaraneun du tub go Galili agaig eiman i zumau.” ");
INSERT INTO bmh_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Guzenaimai, duailel go agal uzan beu beu wanena, Yesus go Oliv em manam ebu sieun. ");
INSERT INTO bmh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesus go Oliv em manam ebu sieun. ");
INSERT INTO bmh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nineimai, umaseu pet, asaimai, koli Nou Zaueim sieun. Duailel unum go waugab alai gotulina, go hoboimai, Uwait nugau ze mareun. ");
INSERT INTO bmh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kasai ze tapaimaranemen dudu mui, Parisi dudu mui, goagen air tub go du tub al wal igul meun gusig pataimai, alai duailel agal ameagab ebu tapai memen. ");
INSERT INTO bmh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Goagen alaimai, Yesus auremen, “Du banou, air e go du tub al wal igul meun pemun. ");
INSERT INTO bmh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Igual kasai ze Moses nug migeun nug guzeneu, ‘Guzenanemen air gue go aiwag sil wemun, noumamau.’ Nait dabeleu erunai pet?” ");
INSERT INTO bmh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Goagen Yesus ze go ameg pataimai, gusig patabun aimai guzenemen. Yesus go waulai noimai, ebeg sil em ebu sikut wai dareun. ");
INSERT INTO bmh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Goagen go gusig kanabai darena, go nug go uligaraimai, awareun, “Du in go getal igul eg i macaneu, go nug amegai air go aiwag sil waba, noumamau.” ");
INSERT INTO bmh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Guzenaimai, go kolital waulai noimai, em ebu sikut weun. ");
INSERT INTO bmh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Go ze go aurina, doimai, dudu banban go tutak tutak unum amegai utei wanena, dudu ipal ses wanemen. Yesus go nugtal em ebu sikut wai wai darena, air go waugab tapai dareun guzenaital dareu. ");
INSERT INTO bmh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Gonug air go peimai, aureun, “Dudu go eru wanem? Na igul eg memen abun du tub i dareu ta?” ");
INSERT INTO bmh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Air gonug aureun, “Du banou, du tub i dareu.” Guzenina, Yesus nug koli aureun, “Go iboi, iz han na igul eg memen aimai i aizai. Bo, na beteiba, igul eg go kolital i guzenen.” ");
INSERT INTO bmh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ziwas tub ebu, Yesus nug duailel awareun, “Iz sag, iz em e ebuan duailel agal al. Duair in iz sesamilamau, go umusot oug i aidamau, gonugau dorog al ebu muzmuz damau.” ");
INSERT INTO bmh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisi dudu agen ze go doimai, Yesus koli auremen, “Na ze go en anem, go petak tam, go nait dabeleu eiman zeze mai darem.” ");
INSERT INTO bmh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus nug awareun, “Tam, go petak. Iz ze e iz en anem, ze e awarem go petak pet. Iz eru eiman alemin, koli eru eiman unai, iz abiu. Iz eru eiman alemin, koli eru eiman unai, ag i abiu. ");
INSERT INTO bmh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Agen em e ebuan igul eim duailel ze sisiaranemen. Izan duair tub nugau igul i sisiai muranem. ");
INSERT INTO bmh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bo, izan duailel sisiaranemin zob, iz suban sisiarem zob. Einen, iz izaseu i darem, izal mekai palautileun du, nug iz ibail dareu. ");
INSERT INTO bmh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Agal kasai ze ebu ze guzenai sikut wemen dareu, ‘du aliag agal ze tutak macanemen ze go petak pet’. ");
INSERT INTO bmh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Iz iza en awaranem, izal mekai go nug iz palautileun go han iz en ananeu.” ");
INSERT INTO bmh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Goagen koli kanabemen, “Nait memen go erueim dareu?” Yesus nug koli awareun, “Ag iz, izal mekai al i abe migemen. Ag iz abe milemen zob, izal mekai han abe moromen zob.” ");
INSERT INTO bmh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesus Nou Zau banou zaueim, aiwag macanemen pip waugab daimai, ze go unum awareun. Du tub nug go gusig patabun iborain tam, einen, gonugau gusig patabun ziwas zuab tam. ");
INSERT INTO bmh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus nug koli awareun, “Iz wanemin, agen iz itanilamamen. Bo, ag iz i peilamamen. Ag igul eg umkoskos memen, noumamamen. Uzan go iz unai ag i unamamen.” ");
INSERT INTO bmh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Guzenaimai, Zuda dudu banban agen ze go doimai, enemen, “Go eru unabun guzeneu, ‘Uzan go iz unai ag i unamamen’? Go nugtal nug enib waimai, noumamau ta?” ");
INSERT INTO bmh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesus nug guzenai awareun, “Ag em e ebuan ug. Iz Mesgai wagan. Ag em e ebuan, bo, iz em e ebuan tam. ");
INSERT INTO bmh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gonun, iz awarem, ag agal igul eg umkoskos memen, noumamamen. Ag iz Uwait nug palautilena, alemin en oiagab petak ab tam, gonun, ag unum agal igul eg mui noumamamen.” ");
INSERT INTO bmh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Goagen koli kanabemen, “Guzenem, na in?” Yesus nug awareun, “Iz ze go getal awaremin, go sag. ");
INSERT INTO bmh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iz agal igul macanemen ze asiu awaraimai, agal igul ze sisiabun iboin. Bo, du go iz palautilena, alemin, gonugau igul petak pet. Gonugau ze unum domin, ze go em e ebuan duailel maranem.” ");
INSERT INTO bmh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Go gonugau memeg wag dareu en awareun, ag i abiu. ");
INSERT INTO bmh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Guzenina, gonug awareun, “Aiu ses agen Du Nugau Nag a gegeulanau ebu asai mebi, ziwas go ebu, Uwait nug iz palautilena, alemin, ag abe mamamen. Guzenaimai, ag abe mamamen, iz izal dabeleu eiman igul tub i macanem, bo, izal mekai nugtal ailina, iz ze macanem. ");
INSERT INTO bmh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Palautilena alemin du gue, go iz ibail dareu, go iz utilina, izaseu i darem, einen, iz ein igul mina, go ougab siksikeu.” ");
INSERT INTO bmh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Duailel asiu gonugau ze doimai, go en goagal oiagab petak emen. ");
INSERT INTO bmh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesus nug Zuda duailel ziwas go ebutal gonugau ze doimai, go en oiagab petak emen guzenai awareun, Ag izal ze suban sesamoramamen, go ag izal tapaimaremin dudu pet usalamamen. ");
INSERT INTO bmh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Go ag Uwait nugau petak ze abe mamamen. Petak ze e nug ag igul eg ebuan imaramau.” ");
INSERT INTO bmh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Goagen koli go auremen, “Ig igual embigeg Abraham nugau ug, ig ziwas tub ebu, dudu ipal agal salau dudu i daremun. Nait dabeleu erunai pet, gonun, ig salau eg ebuan koli imaigamam aigem?” ");
INSERT INTO bmh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Guzenai aurina, Yesus nug koli awareun, “Iz petak pet awarem, duair in go igul eg macaneu, go igul eg gonugau salau du. ");
INSERT INTO bmh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Salau du go, gonugau du banou gonugau zaueim ban i dacaneu, nag petak gonugau memeg nugau zaueim umkoskos dacaneu. ");
INSERT INTO bmh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Guzenaimai, Uwait nugau Nag nug agal igul eg zilagai maraba ag igul eg nugau salau dudu i damamen. ");
INSERT INTO bmh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iz abiu ag Abraham nugau ug, bo, ag izal ze sesamorab utemen, iz iwebiag, noumabun guzenemen. ");
INSERT INTO bmh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iz izal mekai nug abai mileun sultal ze maranem, bo, ag agal memeag nug awaraneun sultal igul macanemen.” ");
INSERT INTO bmh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Zuda dudu agen Yesus nugau ze doimai, enemen, “Abraham go igual memenig.” Yesus nug koli awareun, “Abraham go agal memeag zob, gonugau igul naliu guzenaneu sultal memen zob. ");
INSERT INTO bmh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Iz petak ze Uwait nug aileun awaranem, bo, ulis agen iz iwabun aimai guzenemen. Abraham gue igul go i guzenaneun. ");
INSERT INTO bmh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ag agal memeag nug guzenaneu sultal guzenanemen.” Goagen koli auremen, “Igual anaiger go dudu ipal abai wal igul maimai, ig soligiwab tam. Uwait nug sag go igual memenig. Ig gonugau gelegul pet.” ");
INSERT INTO bmh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesus nug koli awareun, “Uwait go agal memeag zob, ag agal oiagab nug iz en noumemen zob, einen, iz Uwait nug dual daimai, alemin e darem. Iz izal dabeleu eiman alab tam, gonugtal iz palautilena, alemin. ");
INSERT INTO bmh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bo, ag einen izal ze gonugau zebigeg suban i abiu? Gonun, ag izal ze suban duabun utemen. ");
INSERT INTO bmh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Agal memeag Satan, gonun, ag gonugau ze sesamorabun guzenanemen. Go getal, dudu wagarina noumanem du, go petak ze duabun utaneu, einen, go umkoskos polumaraneu. Go polu ze maimai, go gonugau igul go nugtal sesamoraneu, einen, go polu ze maneun du. Go polu ze manem dudu agal memeag. ");
INSERT INTO bmh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Iz petak ze maranem, gonun, ag izal ze nug agal oiagab petak ab utemen. ");
INSERT INTO bmh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Agal dabeleu iz igul eg mai darem aimai dabilanemen, ag izal igul eg go araog macan. Bo, iz petak ze mem aba, ag einen izal ze en oiagab petak ab utemen? ");
INSERT INTO bmh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Uwait nugau gelegul, go Uwait nugau ze duanemen. Bo, ag Uwait nugau gelegul tam, gonun, ag gonugau ze duabun utemen.” ");
INSERT INTO bmh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Zuda dudu agen koli Yesus auremen, “Na Samaria agaig ebuan du, na wes eg mui.” ");
INSERT INTO bmh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus nug koli awareun, “Wes eg iz ebilab i dareu. Tam pet, iz izal mekai nugau wanib ulagwag tutak muranem, bo, agen izal wanim i ulagzanemen. ");
INSERT INTO bmh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iz izal wanim i ulapwag manem. Du tub dareu, go nug izal igul uligaimai, sisiaraimai, gonugtal izal wanim ulapwag milamau. ");
INSERT INTO bmh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iz ag petak pet awarem, duair in go izal ze doimai, sesamoraneu, go i noumamau. Tam pet, tam.” ");
INSERT INTO bmh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Goagen ze go doimai, koli auremen, “Ig ulis abe mem, wes eg na ebizab dareu. Abraham mui, Uwait nugau ze doimai, awaranemen dudu mui, go noumemen. Na nagtal guzenem, duair in go izal ze doimai, sesamoramau, go i noumamau. ");
INSERT INTO bmh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na go donen, igual embigeg Abraham go noumeun. Nait dabeleu na du banou, Abraham zilacoroi darem ta? Uwait nugau ze doimai, awaranemen dudu han noumemen. Nait dabeleu na in du sul usalaimai, ze mem?” ");
INSERT INTO bmh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus nug koli awareun, “Iz izatal izal wanim ulapwag maimai, wanim go eiman esab tub i wai. Izal mekai nug tutak izal wanim ulapwag macaneu. Go Uwait tutak. Agen go igual Uwait anemen. ");
INSERT INTO bmh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bo, ag go i abiu. Iz tutak go abiu. Bo, iz go i abiu awarem zob, go iz polumanemen dudu sul usalem zob, bo, iza go abiu, gonun, gonugau ze unum sesamoranem. ");
INSERT INTO bmh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Getal agal embigeg Abraham go izal alabun ziwas zuba, piabun dabeleimai, siksikeun. Gonug petak peimai, banban siksikeun.” ");
INSERT INTO bmh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Goagen koli auremen, “Nait wai houhou tabkwai (50) sag tam. Erunai na iz Abraham pemin em?” ");
INSERT INTO bmh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus nug koli awareun, “Iz ag petak pet awarem, Abraham go i usalau tam ebu iz daremin.” ");
INSERT INTO bmh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Guzenina, goagen aiwag oimai, Yesus wabun ina, go wage wageimai zobu zau banou go zauan utei waneun. ");
INSERT INTO bmh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus go aidaidai beteimai, du tub gonugau anag nug ameg kumi soligweun uligeun. ");
INSERT INTO bmh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gonugau tapaimaraneu dudu agen kanabemen, “Du banou, inug igul eg meun, gonun, du go anag nug ameg kumi soligweun? Nugtal igul eg meun ta, gonugau memeg anag al agen igul eg memen ta?” ");
INSERT INTO bmh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus nug koli awareun, “Du go ameg kumi go nug igul eg i meun, gonugau memeg anag, go han igul eg tub i memen. Go Uwait nugau gusig araog zuba, piabun guzenai meun dareu. ");
INSERT INTO bmh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ulis, em ileu, am banou eu, iz inug palautilena, alemin nugau salau mai murab. Umut aba, ig salau mabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Iz em e ebu daminag, iz tutak em e ebuan duailel agal al pet.” ");
INSERT INTO bmh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Yesus ze go ze ze maziaimai, em ebu sinou heun. Go sinou kau oug ipuleun oimai, du go nugau ameg kumi ebu pezaimai aureun, “Na beteiba, Siloam Ze Unig ebu nait amen ze sil ulusen.” Go Siloam gonugau wanib zebigeg ‘palautina, waneun.’ Guzenina, du go beteimai, ban ze go ebu gonugau ameg ze zil ulusina, ameg oitina, em naliu uligeun. ");
INSERT INTO bmh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Guzenina, go waugab daremen duailel mui, duailel ipal go getal abu ebu hoboi daimai, duailel ee nugaraneun pemen mui, agen go naliu usalina, uligaimai, agzozou ze memen, “Du e go getal abu ebu hoboi daimai, duailel ee nugaraneun du ta?” ");
INSERT INTO bmh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ipal agen enemen, “Petak, du e gotal.” Ipal agen enemen, “Tam, du e go tam. Du e tub sul.” Guzenina, du go nugtal eneun, “Iz getal duailel ee nugaranemin, go iztal.” ");
INSERT INTO bmh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Goagen kanabemen, “Nait amen erunai naliu meun?” ");
INSERT INTO bmh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Gonug koli awareun, “Du go Yesus anem, go nug kau ze mui ipulaimai oimai, izal ame ebu zioraimai, betei Siloam Ze Unig ebu amen ze ebu ulusen aileun. Iz gonugau ze sesamorina, izal ame naliu meun.” ");
INSERT INTO bmh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Goagen koli kanabemen, “Du go gue eru dareu?” Gonug koli awareun, “Go eru ebu dareu, iz i abiu.” ");
INSERT INTO bmh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dudu go agen getal ameg kumi dareun du imai aimai, Parisi dudu waiagab betemen. ");
INSERT INTO bmh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesus nug kau oimai, du go nugau ameg kumi kasoromeun Imabun Ziwas Zobu go ebu guzeneun. ");
INSERT INTO bmh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Parisi dudu agen go getal ameg kumi dareun du erunai ameg naliu meun aimai kanabemen. Du go nug awareun, “Gonug kau ze mui oimai, izal ame ebu mina, iz betei ame ze ebu ulusaimai, ame naliu mina, em pemin.” ");
INSERT INTO bmh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi dudu ipal agen enemen, “Du go gue igul go guzeneun, go Uwait eiman alab tam, einen, go Imabun Ziwas Zobu ebuan kasai ze sesamorab tam.” Guzenina, ipal agen enemen, “Du igul eg macaneu, go nug erunai gugeg beu beu e guzeneu sul guzenamau?” Guzenaimai, agzozou bigagemen. ");
INSERT INTO bmh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Guzenaimai, Parisi dudu agen du go kolital kanabemen, “Na gonug nait amen kumi koli suban kasizeun em, bo, nait dabeleu du go in?” Du go nug koli awareun, “Go Uwait nugau ze doimai, awaraneu du.” ");
INSERT INTO bmh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Zuda dudu banban du gonugau ameg naliu meun nugau ze aneun en goagal oiagab petak i eun, gonun, du gonugau memeg anag agal ze suban duabun aimai ularemen. ");
INSERT INTO bmh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Guzenaimai, goagen gonugau memeg anag dual kanabaremen, “E agal nanag ta? Goagen anag nug go ameg kumi soligweun emen. Guzenina, ulis erunai gonugau ameg naliu meun?” ");
INSERT INTO bmh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Gonugau memeg anag agen enemen, “Ig abiu go igual naig, go ameg kumi soligwemun. ");
INSERT INTO bmh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bo, erunai gonugau ameg naliu meun, go ig i abiu. Du in nug gonugau ameg oitai moroun go han ig i abiu. Go ban meun, nugtal kanaboron. Nugtal ze mabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Gonugau memeg anag dual go guzenemen, einen, Zuda dudu banban agen gotulanemen zauan zamaramam aimai uminemen. Du in nug Yesus go Kristus aba, Zuda dudu agen du go gotulanemen zaueim i damau aimai ze memen, gonun, go uminemen. ");
INSERT INTO bmh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gonun, gonugau memeg anag agen, go ban meun nugtal ze mamau aimai awaremen. ");
INSERT INTO bmh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Goagen kolital du go uloroimai, auremen, “Na Uwait nugau ameg ebu petak ze men. Ig abiu du go nug nait amen kasaimeun, go igul eg macaneu du.” ");
INSERT INTO bmh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Du go nug koli awareun, “Du go gue igul eg macaneu ta, tam ta, iz i abiu. Bo, iz getal ame kumi daremin. Ulis em pem. Iz go tutak abiu.” ");
INSERT INTO bmh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Goagen koli kanabemen, “Gonug na erunizeun? Nait amen kumi erunai oitai mizeun?” ");
INSERT INTO bmh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Gonug koli awareun, “Izal ze getal awaremin, ag einen izal ze duabun uteimai, koli duabun kanabemen? Ag han gonugau tapaimaraneu dudu usalabun aimai guzenemen ta?” ");
INSERT INTO bmh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Goagen ze biabial kuaimai, auremen, “Na tutak na du gonugau tapaimizaneu du. Bo, ig Moses nugau tapaimiganeu dudu. ");
INSERT INTO bmh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ig abiu Uwait nug Moses aureun. Ig i abiu du go gue eru eiman zoun.” ");
INSERT INTO bmh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Du go nug koli awareun, “Iz agal ze doimai, esilakem! Ag i abiu, go eru eiman zoun, bo, go nug izal ame kumi kasai mileun. ");
INSERT INTO bmh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ig abiu Uwait go dudu igul eg macanemen agal ze i duaneu. Dudu go ulagwag moroimai, gonugau ze sesamoranemen tutak agal ze duaneu. ");
INSERT INTO bmh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Getal em patai meun ziwas ebu, alai ulis, du tub nug du tub ameg kumi kasai meun ina i duanem, ulis tutak. ");
INSERT INTO bmh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Du go gue Uwait eiman i aleun zob, go gugeg go guzenabun iboin tam.” ");
INSERT INTO bmh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Parisi ag du go nugau ze mareun doimai, agen koli guzenai auremen, “Na anan nug solinweun ziwas ebu igul eg mui ban memen guzenem na ulis ig tapaimigamoroi ta?” Guzenai auraimai, du go zauan zamorina, waneun. ");
INSERT INTO bmh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus go igul go guzenemen ze doimai, go betei du go tuloroimai, kanabeun, “Nait ounab Du Nugau Nag en petak em ta, tam?” ");
INSERT INTO bmh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Du gonug koli aureun, “Du banou, go du in ab? Ailemen, iz go en izal oiab petak ai.” ");
INSERT INTO bmh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Guzenina, Yesus nug aureun, “Na du go amen nug pemen, du go nug ulis na ze ze mizei dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Du gonug aureun, “Dubanou Ban, izal oiab petak eu.” Guzenaimai, du go nug Yesus nugau arabugab taubib waimai, ulagwag moroun. ");
INSERT INTO bmh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus nug eneun, “Iz em e ebu duailel agal igul sisiarabun alemin. Dudu ag ameag kumi mui ag ameag naliu mamamen, dudu ameag ametai daremen, ag ameag kumi usalamamen.” ");
INSERT INTO bmh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Guzenina, Parisi dudu ipal ag go waugab daremen ze go doimai, kanabemen, “Ig han amecig kumi ta?” ");
INSERT INTO bmh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesus nug koli awareun, “Ag ameag kumi mui zob, ag ze tamacag, bo, agen ig amecig naliu darem emen, gonun, ag ze mui daremen.” ");
INSERT INTO bmh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus nug kolital eneun, “Iz petak pet awarem, du tub go sipsip ninanem gilan og eiman i sianeu, go gilan etuboroi sianeu, du guzeneneg, go zob du. ");
INSERT INTO bmh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gilan og eiman sianeu du, go sipsip go gumaraneu du pet. ");
INSERT INTO bmh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Go gilan og gumaneun du nug im oitai muraneu, sipsip gumaraneun du go nug gonugau sipsip tutak tutak agal wanimag patena, go sipsip inain go gonugau zeu doimai, go sesamorai unanem. ");
INSERT INTO bmh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Go uzaneim imarai noimai, nug amegai betena, sipsip go ses sesamorai bitanem, einen, go gonugau zeu abe macanem. ");
INSERT INTO bmh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Go dudu ipal i sesamaranemen. Go dudu ipal agen ularena, uminaraimai unanemen, einen, go agal zepag i abiu.” ");
INSERT INTO bmh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus nug tatau ze go awareun, bo, go tatau ze go gonugau zebigeg i abiu. ");
INSERT INTO bmh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesus nug koli eneun, “Iz petak pet awarem, Iz sag iz sipsip agal gilan og. ");
INSERT INTO bmh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dudu ipal ag amegai zomen ag zob dudu. Sipsip inain agal ze duab tam. ");
INSERT INTO bmh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iz sag iz gilan og pet. Du in izal zau og eiman zumau iz go suban gumai. Go zaueim simai, koli betei ee zabun em naliu peimai, umau. ");
INSERT INTO bmh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Zob du go zoi, zob oimai, eg marabun zuaneu. Iz ag doropag muzmuz dabun gusig marabun alemin. Guzenaimai, ag ece tub en i tamacag a damamen, muzmuz suban damamen. ");
INSERT INTO bmh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Iz sag iz sipsip gumaranem du naliu. Sipsip gumaraneu du naliu go nug gonugau sipsip en noumabun dareu. ");
INSERT INTO bmh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Du tub aiwag en salau maimai, go sipsip gumarabun du sul tam. Go egun zag alina, peimai, sipsip go utaraimai, uminai wanena, egun zag go nug zoimai, sipsip ipal tugarai zina, ipal uminai wane anamam, einen, du go gue gaul aiwag en salau macaneu, gonugau sipsip en i dabilaneu. ");
INSERT INTO bmh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Iz sag iz sipsip gumaranem du naliu. Izal mekai nug iz abe milaneu, izan han mekai abe manem sul, iz izal sipsip abe maranem, goagen han iz abe milanemen. Ag izal sipsip, gonun, iz ag en noumabun guzenem. ");
INSERT INTO bmh_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Izal sipsip ipal ag e gilan oug i daremen. Iz ag han imaraimai, gilan e oug maremin, ag izal ze doimai, ereg tutak ug dabi, iz ag unum gumarai. ");
INSERT INTO bmh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Izal mekai nug iz en ougab noumaneu, einen, iz izal sipsip en noumaimai, koli asanai. ");
INSERT INTO bmh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Izal enim tabug utemin, du tub nug unum iwei heabun sul iboin tam, iz gusig ban mui, izal dabeleu eiman iztal izal enim tabug uteimai, iztal izal enim tabug koli wabun iz iboin. Du tub nug iz ze i kuatai i ailamau. Izal mekai nug iz go guzenabun aileun guzental guzenai.” ");
INSERT INTO bmh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Zuda duailel go ze go doimai, tubaim tubaim bigagemen. ");
INSERT INTO bmh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dudu asiu agen enemen, “Wes eg gonugau ougab oug simai, go dabug utub usalaneu. Ig einen gonugau ze duabun dabuig mab?” ");
INSERT INTO bmh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bo, dudu ipal agen enemen, “Wes eg mui du go ze naliu guzenai i maramau. Wes eg mui du nug erunai dudu ameag kumi kasarai mamau?” ");
INSERT INTO bmh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ziwas go ebu, Zerusalem ban uzan zobu tub piabun ziwas banou zoun. Ziwas banou go getal Uwait ecesab muranemen zobu zau banou usalai moromai, im oitabun koli dabelabun ziwas banou. Ziwas go ebu, ut malalai banou pet zuaneu. ");
INSERT INTO bmh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus gue go Nou Zaueim, getal Solomon dacaneun empip anem ebu simai, ai dareun. ");
INSERT INTO bmh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Guzenaimai, Zuda duailel go waugab zoi tuloroimai, kanaboromen, “Eisab na aigamam, na Kristus? Na ulis araog aigamam.” ");
INSERT INTO bmh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesus nug koli awareun, “Iz getal ag awaremin, bo, agal oiagab petak ab tam. Gugeg e beu beu unum mekai nugau wanib eiman mai darem, go izal wanim araog mai dareu. ");
INSERT INTO bmh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bo, ag izal sipsip tam, gonun, agal oiagab iz en petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Izal sipsip ag izal ze duanemen. Iz ag abe marem, ag iz sesamilanemen. ");
INSERT INTO bmh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Iz ag doropag awau muzmuz dabun gusig maremin, ag i noumamamen. Du tub nug ag izal ebe ebuan i imarai unamau. ");
INSERT INTO bmh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Duailel go izal mekai nug mileun. Go banou pet duailel ipal unum zilarai dareu, gonun, du tub nug ag mekai nugau ebeg ebuan oi habun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Iz izal mekai dual ig tutak.” ");
INSERT INTO bmh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Guzenina, Zuda dudu agen koli ai oimai, go waporoi hemen. ");
INSERT INTO bmh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Bo, Yesus nug awareun, “Iz agal ameagab ebu, izal mekai nugau gugeg beu beu guzenemin, agal dabeleu iz ein gugeg beu beu memin en iwaporoi?” ");
INSERT INTO bmh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zuda dudu agen auremen, “Na gugeg beu beu go guzenemen en ig i niwamam, bo, na ze biabial kuai memen. Na gaul du, na izal Uwait aimai, Uwait nugau empip wabun emen, gonun, go en ig na niwaporoi.” ");
INSERT INTO bmh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesus nug koli awareun, “Agal kasai ze ebu sikut wai memen dareu, Uwait nug aneun, ‘Ag uwait iz sul.’ ");
INSERT INTO bmh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Uwait nugau ze go polu mab tam, petak pet ze meun. Getal Uwait nug dudu awareun, ‘Ag uwait iz sul.’ ");
INSERT INTO bmh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Gonun, mekai nugtal tapai maraimai, palautilena, alemin, agal dabeleu iz en ein emen? Izan iz Uwait nugau nag darem emin, ag einen iz ze biabial kuai mem ailemen? ");
INSERT INTO bmh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Iz izal mekai nugau salau i oi murai, ag izal ze en oiagab petak i an. ");
INSERT INTO bmh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bo, iz gonugau salau memin, gonun ag izal ze en oiagab petak i emen aba, ag izal gugeg memin en oiagab petak an. Guzenaimai, ag petak abiu izal Mekai iz ibail darena, iz go dual ereg darem.” ");
INSERT INTO bmh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Go ze go doimai, ag koli go gusig pataporoi emen, bo, go zilarai waneun. ");
INSERT INTO bmh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","41","Yesus go koli uzan go Zordan Ze gasageim getal Zon nug duailel ze ziwareun ebu beteun. Go ziwas ipal go ebu darena, duailel asiu go waugab alemen. Goagen enemen, “Zon nug gugeg tub mab tam, bo, gonugau ze unum du go en aneun go petak.” ");
INSERT INTO bmh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Uzan tub, duailel asiu agal oiagab go en petak emenin. ");
INSERT INTO bmh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Du tub ebeu mui gonugau wanib Lasarus, go Betani uzan dacaneun. Uzan tub Maria gonugau amag Marta dual dacanemen. ");
INSERT INTO bmh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Go Maria gonugtal getal ze sous naliu Yesus nugau arab ebu esikaimai, gonugau gagalig ulig sil gulesai moroun. Air gonugau abiag Lasarus go ebeu mui. ");
INSERT INTO bmh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ailel go agen Yesus ze palautai moroimai, enemen, “Dubanou Ban, nait zaun go en ounab noumanem go ebeu mui dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesus go ze go doimai, eneun, “Ebeu gonug du i noumamau. Gonugun duailel ag Uwait nugau gusig uligaimai, gonugau wanib wag macanemen. Abu go ebu Uwait nugau Nag wanib ulagwag banou umau.” ");
INSERT INTO bmh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus go Marta, gonugau apag Maria, Lasarus dual ereg agen gonugau ougab noumeun. ");
INSERT INTO bmh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Go Lasarus ebeu dareu ze doun, bo, go dareun uzan gil aliag dareun. ");
INSERT INTO bmh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Gil aliag go mazicina, gonugau tapaimaraneu dudu awareun, “Ig koli Zudia agaig bitacab.” ");
INSERT INTO bmh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Guzenina, gonugau tapaimaraneu dudu agen auremen, “Dubanou Ban, Zuda duailel agen na ai sil niwabun ina, alemun, ziwas asiu maziab tam, na koli uzan go bitabun dabelem ta?” ");
INSERT INTO bmh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesus nug koli awareun, “Gil tutak ebu salau wabun go aua begurug sag, umaseu betei umusig go petak. Gonun, du in go amban aidaneu go aiwag ebu i titou amau, einen, go em ebuan al pianeu. ");
INSERT INTO bmh_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bo, du in go umaum aidaneu, go aiwag ebu titou amau, einen, go al tamacag.” ");
INSERT INTO bmh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesus ze go koli, awareun, “Igual zaicig Lasarus go gabuai dareu, iz beteimai, go asai murai.” ");
INSERT INTO bmh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Gonugau tapaimaraneu dudu agen auremen, “Go gabuai dareu aba, go koli naliu usalamau.” ");
INSERT INTO bmh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesus go tatau ze maimai, Lasarus gabuai dareu awareun, bo, go abiu Lasarus noumeun. Tapaimaraneu dudu agal dabeleu go petak gabuai dareu aimai dabelemen. ");
INSERT INTO bmh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Guzenina, Yesus nug koli araog awareun, “Lasarus go noumeun. ");
INSERT INTO bmh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bo, iz ag en dabeleimai, go al betei dab tam, einen, iz agal oiagab petak abun aimai guzenemin. Ig go piabun bitacab.” ");
INSERT INTO bmh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yesus guzenaimai, Tomas nugau wanib tub Didimus nug gonugau salau zaugul awareun, “Ke, ig ereg go al noumabun bitacab.” ");
INSERT INTO bmh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesus go gonugau tapaimaraneu dudu abai Betani uzan waugab zuna, dudu ipal agen Lasarus noumeun, ob oug memun gil iwanarai sag mazieun aimai auremen. ");
INSERT INTO bmh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Uzan tub Zerusalem waugab, ");
INSERT INTO bmh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","gonun, Zuda duailel asiu go Marta zaug Maria dual agal abianag noumeun oiagab naliu usalabun aimai waiagab alai daremen. ");
INSERT INTO bmh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta go Yesus alai dareu ze doimai, go Yesus abu ebu tulurabun beteun. Maria go zaueim dareun. ");
INSERT INTO bmh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta nug betei Yesus tuloroimai, aureun, “Dubanou Ban, na e ebu daremen zob, izal abi i noumeu zob. ");
INSERT INTO bmh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bo, ulis han iz abiu na ein ece wabun Uwait auremen, go nug na mizamau.” ");
INSERT INTO bmh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesus nug koli Marta aureun, “Nait abian koli asamau.” ");
INSERT INTO bmh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta nug koli eneun, “Io, iz abiu, aiu ses duailel unum koli asamam ziwas ebu, go han asamau.” ");
INSERT INTO bmh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus nug koli aureun, “Dudu noumemen asaimai, awau dabun zebigeg go iz tutak. Duair in go iz en ougab petak aimai, noumamau, go awau damau. ");
INSERT INTO bmh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dudu unum awau daremen, agal oiagab iz en petak amamen, ag i noumamamen. Ag awau muzmuz damamen. Na ze go en ounab petak eu ta?” ");
INSERT INTO bmh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Gonug koli eneun, “Dubanou Ban, petak pet, izal oiab na en petak eu. Na Kristus, Uwait nugau Nag, na em e ebu gonugau duailel koli imarabun tapai mizena, alemen.” ");
INSERT INTO bmh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta gue ze go ze ze maziaimai, koli zaueim beteimai, Maria uloroimai, aureun, “Igual tapaimiganeu du zoimai, go na peizai eu.” ");
INSERT INTO bmh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria ze go doimai, pigai asaimai, Yesus tulorabun beteun. ");
INSERT INTO bmh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesus go uzan siab tam, go Marta tuloroun empip dareun. ");
INSERT INTO bmh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zuda duailel go Maria al alai daremen, Maria go pigai asaimai, uzaneim nuna, uligaimai, goagal dabeleu go ob ebu manil mabun beteu aimai sesamorai betemen. ");
INSERT INTO bmh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria go Yesus dareun ebu betei tuloroimai, gonugau arabugab taubib waimai, aureun, “Dubanou Ban, na e ebu daremen zob, izal abiagwai i noumeu zob.” ");
INSERT INTO bmh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maria go gonugau abiag en ougab eg waimai, manil mina, duailel ipal go al ereg betemen go han oiagab eg wina, manil mina, Yesus go uligaraimai, go han ougab eg wina, weina moroi. ");
INSERT INTO bmh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Gonug kanabareun, “Ag go eru ebu ob oug hemen?” Goagen auremen, “Dubanou Ban, na piabun zon.” ");
INSERT INTO bmh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesus go ougab eg wina, weineun. ");
INSERT INTO bmh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Guzenina, duailel agen enemen, “Ag uligan, go Lasarus en gonugau ougab petak noumeun.” ");
INSERT INTO bmh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bo, duailel ipal agen enemen, “Du e nug du tub ameg kumi mui kasai mina, ameiteun. Go einen Lasarus isanurabun utena, noumeun?” ");
INSERT INTO bmh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus go koli ougab eg wina, Lasarus aizau ob oug memen waugab beteun. Go aizau og ai banou sil tapelai memen. ");
INSERT INTO bmh_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesus nug awareun, “Ai go oi han.” Du noumeun, gonugau abiag Marta nug eneun, “Dubanou Ban, go ob oug hemun gil iwanarai mazieun, gonun, sous eg pet zumau.” ");
INSERT INTO bmh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesus nug aureun, “Iz na getal aizemin, nait ounab iz en petak emen, Uwait nugau gusig banou pimam.” ");
INSERT INTO bmh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Guzenina, goagen ai go og tapelai memen ebuan oi hina, Yesus nug Mesgai wag ameitaimai, eneun, “Mekai, na izal ze umkoskos duanemen, gonun, iz na ‘Ese-e’ aizem. ");
INSERT INTO bmh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iz abiu na izal ze umkoskos duanemen iz duailel e darem en anem, ig gugeg go guzenemen, goagal oiagab na iz palautilena, alemin petak amam.” ");
INSERT INTO bmh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesus go guzenai aurai maziaimai, banban ulaimai, eneun, “Lasarus, na uzaneim alen.” ");
INSERT INTO bmh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Noumeun du go asaimai, uzaneim aleun. Gonugau arab ebeg siameg enib unum tibur galau sil kularai memen. Yesus nug awareun, “Tibur galau go ulagacebi, unamau.” ");
INSERT INTO bmh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zuda duailel asiu go Maria piabun alemen, Yesus nug gugeg go meun uligaimai, goagal oiagab go en petak emen. ");
INSERT INTO bmh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bo, dudu ipal go Yesus nug gugeg go meun uligaimai, beteimai, Parisi dudu awaremen. ");
INSERT INTO bmh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Guzenina, Parisi dudu agen Uwait ula dacanemen dudu banban mui, dudu banban ipal ularena, go alai go tulaimai, enemen, “Du go ig erunab? Go gugeg beu beu mai dareu. ");
INSERT INTO bmh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ig du go utemun, igul go guzental guzenai aidaba, duailel unum goagal oiagab go en petak amam. Guzenebi, Rom agal dudu banban agen zoimai, ig eg wai migeimai, igual emgasag mui, Nou Zau banou mui, unum eg wai mamam.” ");
INSERT INTO bmh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Du tub gonugau wanib Kaiapas gue wai go ebu Uwait ula dacaneu du banou pet, go nug awareun, “Ag dabeleu tub dabuiag oug i dareu. ");
INSERT INTO bmh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ag i abiu ta? Du tutak nug duailel agal empip oimai, noumabun iboin. Igual duailel unum eg wamam go igul naliu tam.” ");
INSERT INTO bmh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas go gonugau dabeleu eiman igul go guzenabun anab tam, go Uwait ula dabun du banou pet, gonun, Uwait nug igul go guzenabun dabeleu morona, go aiu ses Yesus noumaimai, Zuda duailel e isanarabun aimai ze meun. ");
INSERT INTO bmh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Zuda duailel tutak ag en go noumab tam. Go noumaimai, Uwait nugau duailel em e ebu unum gotularaimai, Uwait waugab imarai alamau. ");
INSERT INTO bmh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaiapas guzenina, ziwas go ebutal, Zuda dudu banban agen Yesus erunai webi, noumabun aimai bigegwai, ze patemenin. ");
INSERT INTO bmh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Guzenina, Yesus go Zudia agaig ebu koli araog aidab tam. Go uzan go uteimai, betei, du tamacag em waugab uzan tub wanib Epraim, gonugau tapaimaraneu dudu abai dareun. ");
INSERT INTO bmh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Imabun Ziwas Zobu tub Pasowa waugab zuna, duailel Zerusalem ban uzan waugab han unum Uwait nugau ameg ebu naliu usalabun goagal igul beu beu mabun ban uzan siemen. ");
INSERT INTO bmh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Go Yesus Nou Zaueim zuna, piabun aimai simai gumei daimai, agzozou enemen, “Agal dabeleu erunai dareu? Go Imabun ziwas e zumau ta, i zumau?” ");
INSERT INTO bmh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Uwait ula dacanemen dudu banban go Parisi dudu abai agen duailel awaremen, “Yesus erueim daba, ag uligaimai, ig alai aigebi, betei gusig patamam.” ");
INSERT INTO bmh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Zuda agal zobu piabun ziwas, wanib Pasowa, gil wasolig sag darena, Yesus go Lasarus nugau uzan Betani sieun. Uzan tub getal Yesus nug Lasarus noumeun asai meun. ");
INSERT INTO bmh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Go go ebu simai, go go al ee zabun mis memen. Marta go ee salanina ina, Lasarus go dudu ipal abai go Yesus al ereg eebiz ebu hoboi daremen. ");
INSERT INTO bmh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Guzenina, Maria nug ze sous naliu wanib ‘nar’, aiwag banou sil gau mabun sul oimai, Yesus nugau arab ebu esikaimai, gonugau gagalig ulig sil gulesai moroun. Ze sous go zaueim go unum iboreun. ");
INSERT INTO bmh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Guzenina, Yesus nugau tapaimaraneu du tub Zudas Iskariot, go nug aiu ses Yesus iwai zaugul agal ebeagab ebu maramau, go nug eneun, “Go ze aiwag banou, wai tutak ebuan aiwag sul, wabun iboin pet. Ig dudu ipal maremun, gau mebi, aiwag oimai, duailel ecesab tamacag isanarabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Go ze go eneun, duailel ecesab tamacag en dabelab tam, einen, go zob du. Go Yesus nugau tapaimaraneu dudu agal aiwag zo gumeimai, go zo go ougan aiwag zob waneun. ");
INSERT INTO bmh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesus nug ze go doimai, eneun, “Utebi, damau. Go iz ob oug heilamamen ziwas ebu, igul e guzeneu aiu ses dabilamau. ");
INSERT INTO bmh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Duailel ecesab tamacag go ag abai umkoskos damamen, bo, iz ag abai umkoskos ban i dai.” ");
INSERT INTO bmh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","10","Zuda duailel asiu, go Yesus Betani uzan dareu ze doimai, go eim betemen. Go Yesus tutak piabun bitab tam, go Lasarus noumeun Yesus nug ob ougan asai meun han piabun bitemenin, Guzenina, Uwait ula dacanemen dudu banban agen Lasarus han webi, noumabun en ze patemen. ");
INSERT INTO bmh_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Einen, go en Zuda duailel asiu go semaraimai, Yesus en oiagab petak emenin. ");
INSERT INTO bmh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nineimai, umaseu, duailel asiu go zobu wanib Pasowa piabun zomen go Yesus Zerusalem ban uzan alai dareu ze domen. ");
INSERT INTO bmh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Guzenaimai, goagen nun gau sul kuataraimai, Yesus alamau abu ebu tulorabun beteimai, guzenai ulwemen, “Uwait nugau wanib uligwag murab. Du go Banou nugau wanib ebuan aleu, ulagwag murab. Go Israel agal gumarabun du banou, king.” ");
INSERT INTO bmh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus go donki nag tub uligaimai, go wag ebu beteun. Getal Uwait nugau ze nug aneun sul petak zou. ");
INSERT INTO bmh_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ze go nug guzeneun, ‘Ag Saion ban uzanan duailel, ag uminian. Agal gumarabun du banou go donki nag ebu hoboi, aleu.’ ");
INSERT INTO bmh_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Gonugau tapaimaraneu dudu igul go amegai guzenemen ze go zebigeg go i abiu. Bo, aiu ses Yesus Mesgai wag simau ziwas ebu, go ze go Uwait nugau ze dareu en dabeleimai, anemen, go Yesus en aneun. Go duailel agen Zerusalem uzan guzenemen koli go en dabilemen. ");
INSERT INTO bmh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Duailel ag Yesus nug Lasarus asai meun ziwas ebu, go al daremen, ag aidaimai ze go duailel ipal awaranemenin. ");
INSERT INTO bmh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Igul go en, duailel go Yesus tulorabun betemen. Einen, go nug gugeg go meun domen. ");
INSERT INTO bmh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Guzenaimai, Parisi dudu agzozou enemen, “Ag uligan, ig go kuatai ze mabun iborain tam. Emgasag e ebuan duailel unum go sesamorem.” ");
INSERT INTO bmh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grik emgasag ebuan dudu ipal agen, dudu ipal go Imabun ziwas, Zerusalem ban uzan, Uwait nugau wanib ulagwag mabun sina, ereg sesamarai siemen. ");
INSERT INTO bmh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik dudu go agen Pilip, go Betsaida uzanan du, uligaimai, auremen, “Ig Yesus piaporoi.” ");
INSERT INTO bmh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Guzenina, Pilip nug betei Andru aurina, zaug dual beteimai, Yesus auremen. ");
INSERT INTO bmh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus nug awareun, “Du Nugau Nag wanib ulagwag banou wabun ziwas ulis zou. ");
INSERT INTO bmh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iz ag petak pet awarem, wit dab em ebu nuab tam, go tutak tapai damau. Bo, go em ebu numau, koli walu zoimai, dab asiu mamau. ");
INSERT INTO bmh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Du in go gonugau dorog en ougab noumaimai, em e ebuan ecesab en dabilamau, go eg wamau. Bo, du in em e ebuan ecesab semoroimai, gonugau dorog en ougab i noumamau, gonugau dorog awau muzmuz dabun gusig umau. ");
INSERT INTO bmh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Du in go izal salau mamau, go iz sesamilamau. Uzan tub iz betei dai ebu izal salau du han ereg iz ibail betei damau. Du in go izal salau mamau, izal mekai nug gonugau wanib wag muramau.” ");
INSERT INTO bmh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesus nug eneun, “Ulis izal oiab uhu usalina, dabeleu asiu om. Mekai, na go mu wabun ziwas utemen, iz ebilab i zumau aimai, anai ta? Tam. Iz ziwas go mu banou wabun en alemin. ");
INSERT INTO bmh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mekai, nagtal nait wanim ulapwag banou men.” Guzenina, ogusau tub nug Mesgai wag eiman eneun, “Iz getal izal wanim ulapwag banou memin, kolital ulapwag banou mai.” ");
INSERT INTO bmh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Duailel asiu go ebu gotulai daremen ze go doimai, enemen, “Go em kulalaneu nug ze mai dareu.” Ipal agen enemen, “Uwait nugau tibur nug alai ze moroi dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Bo, Yesus nug awareun, “Ze go ulis ag domen, iz isanilabun tam, go ag isanarabun. ");
INSERT INTO bmh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ulis, Uwait nug em e ebuan duailel sisiarabun zoi dareu. Guzenaimai, go nug em e gumaneu du banou oi amaicamau. ");
INSERT INTO bmh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iz dudu agen wag heilebi, izan duailel unum egaremin, iz waiab alamam.” ");
INSERT INTO bmh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Go erunai noumamau en ze meun. ");
INSERT INTO bmh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Duailel agen koli auremen, “Ig getal igual kasai ze ebu enai domun, Kristus go zumau, i noumamau, go muzmuz damau. Na Du Nugau Nag wag heizamam einen guzenem? Du Nugau Nag go in?” ");
INSERT INTO bmh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesus nug koli awareun, “Al go ag ula ziwas asiu i damau. Al hilanau darena, ag abu piabun iboin ebu aidan, umaum usalaba, ag iboin tam. Dudu go umaum aidanemen go em suban i pianemen. ");
INSERT INTO bmh_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Go al go hilanau oimai, go en agal oiagab petak an. Guzenebi, ag al ebuan duailel usalamamen.” Yesus go ze go awaraimai, go utarai beteimai, wagemeun. ");
INSERT INTO bmh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesus nug gugeg beu beu goagal ameagab ebu meun, bo, go en goagal oiagab petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Getal Uwait nugau ze doimai, awaraneun du Aisaia nugau ogusau nug ze meun petak zou, in nug igual ze en ougab petak eun? Uwait nug in gonugau gusig abai moroun?’ ");
INSERT INTO bmh_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Igul go en goagal oiagab petak ab utem. Einen, Aisaia nug han aneun, ");
INSERT INTO bmh_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Uwait nug goagal ameag kumi usalai maraimai, goagal dabeleu tapelai mareun. Guzenaimai, goagal ameag nug suban i pianemen, ag suban i dabilanemen. Tub, ag agal igul eg uteiban, koli oiagab kekulebi, iz agal igul eg zilagai marai.’ Uwait nug guzeneun. ");
INSERT INTO bmh_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia nug Yesus nugau gusig peimai, go en ze meun. ");
INSERT INTO bmh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dudu asiu mui, Zuda dudu banban ipal ereg go Yesus en oiagab petak emen. Bo, ag Parisi dudu uminaraimai, agal oiagab petak emen anab tam. Agal gotulanemen zauan zamarebi, unamamen aimai dabeleimai, guzenemen. ");
INSERT INTO bmh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ag Uwait nug agal wanimag wag maramau en uteimai, ag dudu agen agal wanimag wag maramam en aimai guzenanemen. ");
INSERT INTO bmh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesus nug ulwaimai, guzeneun, “Duair in iz en gonugau ougab petak aneu, go iz tutak en ougab petak ab tam, go izal Mekai iz palautileun go en ereg ougab petak aneu. ");
INSERT INTO bmh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Du in go iz peileu, go izal mekai iz palautilena, alemin han peu. ");
INSERT INTO bmh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iz em e ebuan al pet alemin. Duailel go iz en goagal oiagab petak amam, go umaum i damamen. ");
INSERT INTO bmh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Duair in izal ze doimai, sesamorab tam, iz go i sisiai. Iz em e ebuan duailel sisiarabun alab tam. Iz duailel igul eg macanemen ebuan koli imarabun alemin. ");
INSERT INTO bmh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bo, duair in go iz semileimai, izal ze sesamorab utamau, go ze gonugtal go petak sisiuramau. Iz ze e awarem, go ze gonugtal ag aiu ses sisiaramau. ");
INSERT INTO bmh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iz ze e izal dabeleu eiman mab tam, mekai nug iz palautilena, alemin, gonugtal ze go unum ailina, awarem. ");
INSERT INTO bmh_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iz abiu du in mekai nugau ze sesamoramau, go muzmuz awau damau. Gonun, ze unum e awarem, go mekai nug aileun guzental awarem.” ");
INSERT INTO bmh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasowa, Zobu go pianemen ziwas, getal Israel dudu agal embigeg Izip emgasag utei alemen dabilanemen ziwas zuna, Yesus go abiu go em e uteimai, gonugau memeg waugab Mesgai wag siabun ziwas go mazi hogu zoi dareu. Yesus go gonugau duailel em e ebu daremen go en ougab noumeun. Go guzental daimai, betei, gonugau enib ag isanarabun noumeun. ");
INSERT INTO bmh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesus gonugau tapaimaraneu dudu abai umaum ee zina zina, Satan nug Zudas, go Saimon-Iskariot nugau nag, Yesus dudu banban agal ebeagab ebu maraba, webi, noumabun dabeleu moroun. ");
INSERT INTO bmh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus go abiu memeg nug gusig unum gonugau ebeg ebu meun. Go abiu Uwait nug go palautina, aleun, koli Uwait waugab simau. ");
INSERT INTO bmh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Gonun, Yesus nug ee zai daremen ebu asaimai, gonugau tibur galau huia oi aimai, tibur galau enimag gulesanem tub oimai, gonugau bigug ebu kieun. ");
INSERT INTO bmh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ee tebil ebu ze esikai maimai, gonugau tapaimaraneu dudu tutak tutak agal aramag ulusai maraimai, go tibur galau bigug ebu kieun go sil goagal aramag ebuan ze gulesai mareun. ");
INSERT INTO bmh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesus nug goagal aramag unum ulusai marai marai betei, Pita waugab alina, Saimon-Pita nug Yesus aureun, “Dubanou Ban, na izal aram ulusamoroi ta?” ");
INSERT INTO bmh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus nug koli Pita aureun, “Igul e ulis guzenem na i abiu, aiu ses petak na abe mamam.” ");
INSERT INTO bmh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita nug koli aureun, “Na izal aram i ulusamam. Tam pet tam!” Yesus nug koli aureun, “Iz nait aram i ulusai, na izal tapaimizanem du i damam.” ");
INSERT INTO bmh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yesus nug guzenai aurina, Pita nug koli aureun, “Dubanou Ban, guzenaba, na izal aram sag i ulusen, izal ebe mui gagali mui ereg ze sil ulusai milen!” ");
INSERT INTO bmh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus nug koli aureun, “Du in go ze ziweun, go unu tamacag, go koli ze i ziwamau. Go gonugau arab sag ze sil ulusamau, einen, arab go em eg tapai aidaneu. Ag unum agal oiagab oug unu tamacag, naliu daremen. Bo, du tub, go sag gonugau ougab oug unu mui dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus go Zudas nug nug nugau iwai zaugul ebeagab ebu maramau abe maimai, eneun, “Ag unum agal oiagab oug unu tamacag. Du tub go sag gonugau ougab oug unu mui.” ");
INSERT INTO bmh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesus nug goagal aramag ulusai maraimai, gonugau tibur galau huia koli oimai, arugaimai, gonugau hubabun pip betei hoboun. Yesus nug go hoboi daremen kanabareun, “Ag izal tapaimaranem dudu, iz ulis agal aramag ze sil ulusem, ag zebigeg go abiu ta? Iz ulis igul go guzenem, gonugau zebigeg awaramoroi. ");
INSERT INTO bmh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ag iz ibail ze maimai, ailanemen, ‘Dubanou Ban, tapaimiganem du.’ Ag go petak anemen, go iz sag agal tapaimaranem du, agal Dubanou Ban. ");
INSERT INTO bmh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iz, agal Dubanou Ban, izan agal aramag ulis ulusem pemen igul go guzenem sul, aiu ses agen han zaiagar agal aramag guzental ulusai maran. ");
INSERT INTO bmh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iz ag igul go abai marem pemen, iz salau du sul usalaimai, ag isanaremin, agen han igul go sesamoran. ");
INSERT INTO bmh_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iz petak pet awarem, em e ebu, salau du tub nug gonugau gumaneu du zilacurabun iboin tam. Du go gue gonugau du banou nug salau mabun palautina, go nug beteimai, gonugau palautoroun du banou i zilauramau. ");
INSERT INTO bmh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ulis ag ze e marem domen, go petak. Ag ze e awarem doiban, ag sesamoraimai, iza guzenem sul guzenaimai, ag umkoskos siksikai damamen.” ");
INSERT INTO bmh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yesus koli awareun, “Iz ag unum unu mui awarab tam. Tutak du en anemin. Dudu inen izanag tapai maremin, go iz abiu. Bo, ze go getal Uwait nugau ze doimai, awaranemen dudu agen anemen ulis petak zou. Go guzenemen, ‘Du go gue iz ibail ee zai dareu, go nug iz iwai milamau.’ ");
INSERT INTO bmh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iz ulis ze e awarem aiu ses petak zuba, agal oiagab petak aimai, ag iz petak abei milamamen. Iz du go dudu go agen sikut wemen ulis e ze mai dacanem. ");
INSERT INTO bmh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iz petak pet awarem, du in nug dudu izal ze oi aidabun palautaremin imaraimai, suban gumaramau, go iz mui ereg imailamau. Du in nug iz imailamau, go du gue iz palautilena, alemin go han ereg imacamau.” ");
INSERT INTO bmh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus nug ze go gonugau tapaimaraneu dudu awaraimai, gonugau ougab uhu usalina, ze wagemabun iborain tam, gonun, araog maimai, eneun, “Iz petak pet awarem, du tub ag ula dareu go nug iz izal iwai zaiar agal ebeagab ebu mamau.” ");
INSERT INTO bmh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Go ze go awarina, go esilakaimai, ameag nug agzozou piapiar aimai, dabeleimai, enemen, “Go du in en aneu?” ");
INSERT INTO bmh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesus nugau tapaimaraneu du tub Yesus nug go en ougab noumaneu, go Yesus waugab hoboi dareun. ");
INSERT INTO bmh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Gonun, Saimon-Pita nug gagalig sil, aureun, “Nagen kanaben, go du in en aneu.” ");
INSERT INTO bmh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Du tub Yesus waugab hoboi dareun, Yesus kanababun holoi beteimai, kanabeun, “Dubanou Ban, na in en anem?” ");
INSERT INTO bmh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus nug koli aureun, “Izal bret ogog il ebu maimai, du go moromin, ziba, du go nug tutak iz iwai milamau.” Guzenai ze maimai, gonugau bret ogog oimai, il ebu maimai, Zudas, Saimon-Iskariot nugau nag moroun. ");
INSERT INTO bmh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zudas go Yesus nug bret oi morona, Satan nug Zudas gusig pataimai, gonugau dabeleu unum gumeun. Yesus nug Zudas aureun, “Na einen ban darem. Na ein igul guzenabun aba pigai guzenen.” ");
INSERT INTO bmh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gonugau tapaimaraneu dudu ipal hoboi daremen Yesus nug ze go Zudas aureun, go ze meun ze go zebigeg i abiu. ");
INSERT INTO bmh_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Zudas go goagal aiwag gumaneu du, gonun, goagal dabeleu Yesus nug go betei ee gau mabun ze moroi dareu, ta, ecesab tamacag dudu ipal aiwag marabun ze moroi dareu ta, emen. ");
INSERT INTO bmh_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Guzenaimai, Yesus nug Zudas bret ogog morona, oimai, umaum uzaneim noimai, waneun. ");
INSERT INTO bmh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Go uzaneim noimai, wanena, Yesus nug gonugau tapaimaraneu dudu awareun, “Ulis, Du Nugau Nag nugau wanib ulagwag oi dareu. Duailel go uligaimai, Uwait nugau wanib ulagwag banou mamam. ");
INSERT INTO bmh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Duailel agen Yesus nugau wanib ulagwag mui dareu uligaimai, go Uwait nugau wanib ulagwag muramam aimai, ziwas go ebutal Uwait nug gonugau mogoi nugau wanib gonugau gusig nug wag muramau. ");
INSERT INTO bmh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Izal gelear, iz ban ag abai i dai. Iz getal Zuda dudu banban awaremin sul ulis ag han awarem, ag iz itanilamamen, bo, ag iz eru eiman unai ag bitabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Iz ulis ag kasai ze awau tub awaranai, ‘Ag agzozou agal zaiagar en oiagab nug noumamamen. Iz ag en oiab nug noumanemin sul agen han zaiagar en oiagab nug noumamamen.’ ");
INSERT INTO bmh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ag zaiagar en oiagab nug noumaimai, isanaramamen, dudu go agen ag petak abe maramam ag izal tapaimaranem dudu pet.” ");
INSERT INTO bmh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pita nug Yesus kanabeun, “Dubanou Ban, na eru utigai unabun aigem.” Yesus nug Pita koli aureun, “Pita, ulis na iz uzan go bitamoroi na sesamilai unabun iborain tam. Aiu ses petak iz sesamilamam.” ");
INSERT INTO bmh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Guzenina, Pita nug koli aureun, “Dubanou Ban, na iz einen na bitamam ebu i sesamizabun aimai ailem? Iz na isanizei noumai.” ");
INSERT INTO bmh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesus nug koli aureun, “Na petak iz isanileimai noumamam ta? Pita, iz petak pet aizem, ulis umaum, toi i ulwau ebu, zoi kanabizebi, na izal wanim wagemaimai, ‘iz go i abiu’ ziwas ainarai ze guzenai mamam.” ");
INSERT INTO bmh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus nug gonugau tapaimaraneu dudu awareun, “Ag dabeleu asiu oimai, oiagab uhu i mamau. Uwait en agal oiagab petak aiban, iz en han oiagab petak an. ");
INSERT INTO bmh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Izal mekai nugau zaueim zau empip asiu dareu. Iz agal dabun empip kasabun unamoroi. Go petak tam zob, iz ag i awarem zob. ");
INSERT INTO bmh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Iz simai ag dabun empip suban kasai maimai, koli alaimai, ag imaraimai, simai, iza ibail ereg damamen. ");
INSERT INTO bmh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Iz uzan go unamoroi uzan gonugau abu ag abiu.” ");
INSERT INTO bmh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas nug aureun, “Dubanou Ban, nait uzan unamoroi ig i abiu. Ig erunai nait uzan gonugau abu abe mamam?” ");
INSERT INTO bmh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus nug koli aureun, “Iz sag iz abu, iz sag iz petak ze zebigeg, iz sag iz doropag awau muzmuz dabun zebigeg. Du in go mekai dareu siabun abu tub eiman siabun iborain tam, izal wanim eiman tutak simau. ");
INSERT INTO bmh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ag ulis iz abe milemen aba, izal mekai han abe muramamen. Ulis ag go abe maimai, ameag nug go pemen.” ");
INSERT INTO bmh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip nug aureun, “Dubanou Ban, ig memenig abai migemen, go igual oigeb petak amam.” ");
INSERT INTO bmh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesus nug aureun, “Pilip, ziwas asiu pet iz ag abai daremin, na iz abe milab tam ta? Du in go iz peileun, go izal mekai peun. Guzenaimai, na einen mekai abai migen em? ");
INSERT INTO bmh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilip, iz mekai al darem, mekai go iz ibail dareu, go nait ounab petak ab tam ta?” Yesus nug gonugau tapaimaraneu dudu awareun, “Iz ag ze e ulis awarem, go izal dabeleu eiman awarab tam. Izal mekai go iz ibail daimai, gonugau salau mai dareu. ");
INSERT INTO bmh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Iz Mekai al darem, Mekai han iz ibail dareu en agal oiagab petak an. Tam aba, iz gugeg manem pianemen dabilan. Go agal oiagab petak abun asai maramau. ");
INSERT INTO bmh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iz ag petak pet awarem, duailel inen iz en oiagab petak emen duailel go ag iz gugeg macanem sul mamamen. Iz mekai dareu wag siai, gonun, petak pet, agen iz zilacileimai, gugeg banban pet mamamen. ");
INSERT INTO bmh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ag izal duailel, gonun, ein igul mabun ailamamen iz igul go mai. Guzenebi, nag nug gonugau memeg nugau gusig abai maramau. ");
INSERT INTO bmh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ag izal duailel, gonun, ein ece wabun, ailebi, izan ag marai.” ");
INSERT INTO bmh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesus nug kolital awareun, “Ag agal oiagab iz en noumanemen aba, ag izal kasai ze go sesamoramamen. ");
INSERT INTO bmh_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iz izal mekai auremin, go nug ag isanarabun Ah Wes maramau. Go ag abai muzmuz damau. ");
INSERT INTO bmh_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ah Wes gue go petak ze maneu. Em e ebuan duailel ag go i uminamamen, einen, ag go i pianemen, ag go i abe macanemen. Bo, ag izal zaiar, ag go abe memen, einen, go ag abai dacaneu, gonun, ag abai damau. ");
INSERT INTO bmh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Iz ag utaremin, aunagul sul agtal i damamen, iz ag waiagab koli alai. ");
INSERT INTO bmh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ziwas hogu dai dai, em e ebuan duailel ag iz koli i peilamamen. Bo, ag izal tapaimaranem dudu tutak agen iz peilamam. Iza awau darem sul, ag han awau damamen. ");
INSERT INTO bmh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ziwas go zumau ziwas ebu, ag abe mamamen, mekai iz ibail dareu, iz ag abai darem, ag han iz ibail daremen. ");
INSERT INTO bmh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Du in go izal kasai ze doimai, suban sesamoraneu, du go gue iz en ougab noumeu. Gonun, izal mekai nug han du go en ougab noumamau. Iza han izal oiab nug du go en noumemin, iz iza en go abai murai.” ");
INSERT INTO bmh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Go guzenina, tapaimaraneu du tub wanib Zudas, go Zudas-Iskariot tam, go nug aureun, “Dubanou Ban, einen ig nait tapaimiganem dudu nagtal abai migemen, abe mizamam, bo, em e ebuan duailel na i peizamam?” ");
INSERT INTO bmh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesus nug koli aureun, “Duair in gonugau ougab iz en noumeu, izal ze sesamoramau, izal mekai nug du go en ougab noumamau. Iz mekai dual du go waugab alaimai, go al muzmuz damam. ");
INSERT INTO bmh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Du in go iz en ougab noumab tam, go izal ze i sesamoraneu. Ze e ag doi daremen, ze go izal tam, go Mekai nugtal iz palautilena, alemin nugau ze. ");
INSERT INTO bmh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Iz ag abai em e ebu daimai, ze go unum awaremin. ");
INSERT INTO bmh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Izal mekai nug gonugau Ah Wes izal empip oimai, ag isanarabun palautaba, alamau. Gonug alaimai, igul unum abai maramau. Gonug agal dabeleu asai maraba, ag getal awaremin ze koli dabilamamen. ");
INSERT INTO bmh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Iz ag utarai unamoroi, gonun, izan ag oiab selai dabun ze awaramoroi. Iz oiagab selai dabun igul ag marem. Izal oiagab selai dabun igul go em e ebuan duailel agen ag maranemen sul tam. Ag esilakaimai, oiagab eg usalaba, uminian. ");
INSERT INTO bmh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Iz utarai unabun ze e awaremin domen. Iz unaimai, koli ag waiagab alai. Agal oiagab iz en noumanemen, go nug agal oiagab siksikamau, einen, iz izal mekai dareu wag siai. Go banou pet, go nug iz unum zilacile dareu. ");
INSERT INTO bmh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iz ze e ulis awarem, ziwas go i zuau dareu, ag awarem, aiu ses igul go zuba, agal oiagab petak amamen. ");
INSERT INTO bmh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Iz ag abai ze ban i marai, einen, em e gumaneu du aseu. Gonug iz zilacilabun gusig tamacag, bo, em e ebuan duailel abe mamam izal oiab nug mekai en noumaimai, ein igul mekai nug ailina, iz guzenanem. Asebiag, ig utei unab.” ");
INSERT INTO bmh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus nug en eneun, “Iza wain a sul. Izal mekai go wain wai atag du. ");
INSERT INTO bmh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Izal a ebeg ebu dab naliu i macaneu, go mekai nug kuatai hiacaneu. Ein a ebeg dab naliu macaneu, go nug itaraimai, a ebe ipal oi hiacaraimai, hogu hogu kitkuataba, dab naliu asiu mamam. ");
INSERT INTO bmh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ag ze e marena, domen, gonun, go nug agal unu unum uluseun, ag unu tamacag. ");
INSERT INTO bmh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ag iz ibail zoi pezile damamen, iz han ag abai pezarai dai. A ebeg tub go nugtal dab mabun iborain tam, go a bigeg ebu pezai daimai, petak dab macaneu. Igul go sul, ag iz ibail pezile damamen, ag salau naliu mebi, Uwait ougab siksikamau. ");
INSERT INTO bmh_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Iza wain a, ag wain ebeg. Duair in go iz ibail pezile damau, izan han go al dai. Go dab asiu mamau. Ag iz ibail i pezile damamen, ag igul tub mabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Du in iz ebilab ibail pezile i damau, go a ebeg kuatanem sul kuatebi, meu maba, ebeg go oimai, ab ebu hamacebi, ilaramau. ");
INSERT INTO bmh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Agen iz pezilebi, izal ze ag ebalagab pezarai damau, agal dabeleu eiman ein ece wabun kanabamamen, go ag umamen. ");
INSERT INTO bmh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Izal tapaimaranem du naliu, go izal ze duailel awaramau, go izal mekai gonugau wanib ulagwag banou mamau. Go guzenamamen, ag izal tapaimaranem duailel pet usalebi, Uwait nugau ougab siksikamau. ");
INSERT INTO bmh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mekai nug iz en ougab noumeu sul izan han ag en oiab noumanem, gonun, ag iza waiab dabi, iz ag en oiab noumai. ");
INSERT INTO bmh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Iz izal mekai nugau kasai ze sesamoremin, go muzmuz gonugau ougab iz en noumeu sul, ag izal kasai ze sesamorebi, izal oiab ag en muzmuz noumai. ");
INSERT INTO bmh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iz ag en izal oiab siksikai dareu. Iz ze go agal oiagab, izal oiab sul usalabun awaremin. Gonug, agal oiagab banban pet siksikamau. ");
INSERT INTO bmh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Izal kasai ze enai, iz ag en oiab noumem sul, agen han duailel ipal en oiagab nouman. ");
INSERT INTO bmh_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Du tub nug gonugau zaug isanurabun gonugau enib dudu ipal marena, goagen webi, noumaba ig abiu go petak go gonugau zaug en ougab noumeun. Oiagab noumabun igul go nug oiagab noumabun igul ipal unum zilacorou. ");
INSERT INTO bmh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ag izal kasai ze awaremin sultal sesamoramamen, go ag izal zaiar. ");
INSERT INTO bmh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ulis izan ag salau dudu aimai i awarai. Salau du go gonugau gumaneu du gonugau dabeleu i abiu. Bo, ein ze izal mekai nug aileun, go ag unum awaremin, gonun, ag izal zaiar awarem. ");
INSERT INTO bmh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Agen iz ag abai dabun aimai tapai milab tam, izanag ag izal tapaimaranem dudu tapai maremin. Agen beteiban, ee ug bebi, ee asiu mabun tapai maremin. Ee go muzmuz damau. Ag izal tapaimaranem dudu, gonun, ein ece wabun mekai aurebi, go nug ag maramau. ");
INSERT INTO bmh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Guzenaimai, iz ag kasai ze go gusig awarem sesamoran. Ag tutak tutak agal zaiagar en oiagab nouman.” ");
INSERT INTO bmh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesus nug koli eneun, “Bo, em e ebuan duailel agen ag gasag marebi ag koli dabilan, igul go amegai iza guzental gasag milemen sul ag ebalagab han guzental guzenamam. ");
INSERT INTO bmh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ag em ebuan duailel pet zob, duailel go agen ag en oiagab noumem zob. Bo, ag duailel go sul tam. Einen, izan ag em e ebuan tapai maremin, gonun, em e ebuan duailel agen ag semaramam. ");
INSERT INTO bmh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ze tub amegai awaremin dabilan ‘Salau du go gonugau gumaneu du zilacurabun iborain tam’. Ag iz eg milemen sul ag han eg maramam. Bo, duailel go agen izal ze sesamoremenin zob, agal ze han sesamorem zob. ");
INSERT INTO bmh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ag izal duailel, gonun, igul go ag ebalagab guzenamam. Em e ebuan dudu, du go nug palautilena, alemin ag go i abiu. ");
INSERT INTO bmh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Iz alai, dudu go agal igul eg en i awaremin zob, ag igul eg guzenemen en ze mui i daremen zob. Agal igul eg macanemen, go ag iz gasag heilemen. Bo, ulis ag abiu, ag iz gasag heilemen, gonun, agal igul eg wagemabun iborain tam. Gonun, ag ze mui damamen. ");
INSERT INTO bmh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Duailel inen agen iz gasag milamam ag izal mekai han gasag himamen. ");
INSERT INTO bmh_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iz ag ula igul ipal dudu agen mabun iborain tam memin. Ag izan gugeg go memin i pemen zob, ag ze mui i daremen zob. Bo, izan salau memin uligaimai, agen ig mekai dual gasag heigemen. ");
INSERT INTO bmh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Igul go agal kasai ze ebu sikut wai memen petak zou. ‘Duailel ag iz gaul gasag heilemen.’ ");
INSERT INTO bmh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ah Wes izal duailel isanarabun mekai al dareu, izan ag waiagab palautemina, alamau. Go Wes nug Uwait en petak ze macaneu. Go mekai al dareu alamau. Gonug alaimai, izal ze araog mamau. ");
INSERT INTO bmh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ag han iz salau bibegwemin ebu iz ibail daremen, gonun, agen izal ze oimai, duailel ipal awaramamen.” ");
INSERT INTO bmh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesus nug gonugau tapaimaraneu dudu koli awareun, “Iz agal oiagab petak emen i utabun aimai ze e awaremin. ");
INSERT INTO bmh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dudu agen ag igul eg mai daremen aimai, agal gotulanemen zauan zamaramam. Ziwas zumau ziwas ebu, dudu agen ag ugarebi, noumamamen. Ag igul go guzenamam, agen ig Uwait nugau salau naliu moroi darem aimai ze mamam. ");
INSERT INTO bmh_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Igul eg go ag ebalagab guzenamam dudu ag iz izal mekai dual i abe migemen. ");
INSERT INTO bmh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iz ze e awarem, aiu ses ziwas igul tub zumau go ebu guzenebi, ag ze e koli dabilamamen. Iz ze go getal awarab tam, einen, iz ag abai daremin.” ");
INSERT INTO bmh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yesus nug koli eneun, “Ulis iz du go nug palautilena, alemin gonugau uzan koli unamoroi, ag ula, du tub nug na erueim unamau aimai ailab tam. ");
INSERT INTO bmh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ulis iz ze go awarem, go nug agal oiagab eg pet mareu. ");
INSERT INTO bmh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Iz ze e awaremin go petak pet. Iz utarai unai, go ag isanaramau. Iz i unai, ag isanarabun du i alamau. Iz wanemin, izan ag isanarabun Ah Wes palautemin, alamau. ");
INSERT INTO bmh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Go alaba, go nug em e ebuan duailel agal igul eg macanemen araog maraba, tuguiai dabun igul mui, Uwait nugau sisiarabun igul mui, suban abai maramau. ");
INSERT INTO bmh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gonug agal igul eg macanemen araog maramau, einen, ag iz en oiagab petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Gonug ag tuguiai dabun bigeg abai maramau, einen, iz izal mekai dareu wag siai, ag iz koli i peilamamen. ");
INSERT INTO bmh_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Sisiarabun igul han abai maramau, einen, em e gumaneu du, Satan, go mekai nug gonugau igul eg unum sisiai moroimai, go ze mui eu. ");
INSERT INTO bmh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Iz ze asiu awarabun iboin, bo, ag ulis ze unum abe mabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aiu ses Ah Wes go alaba, go nug Uwait nugau petak ze ag araog abai maramau. Gonugau dabeleu eiman ze i awaramau. Gonug ze Uwait nug ebuan alaneu ag awaramau. Gonug han ein igul aiu ses zumau ag awaramau. ");
INSERT INTO bmh_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Izan go ein ze auremin, oimai, ag awaramau, gonun, go nug izal wanim ulapwag milamau. ");
INSERT INTO bmh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ein ece mekai nugau ebeg ebu dareu go izal, go en iz awarem, ein ze izan Ah Wes moromin, go nug ag awaramau.” ");
INSERT INTO bmh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesus nug koli eneun, “Ziwas ipal dai dai, ag iz koli i peilamamen. Ziwas ipal maziaba, ag kolital iz peilamamen.” ");
INSERT INTO bmh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tapaimaraneu dudu ipal agzozou enemen, “Ze go aneun, zebigeg einen aneu? Gonug ig aigaimai, ‘Ziwas ipal dai dai, ig go i pimam eu, ziwas ipal maziaba, ig go kolital pimam’ aigeu. Kolital aigeun, ‘Go einen, iz izal mekai dareu wag unai.’” ");
INSERT INTO bmh_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Go koli koli kanabemen, “Go ein ze aigamoroi aimai, ‘Ziwas ipal’ eu. Ig gonugau ze meu bigeg abe mab anmem.” ");
INSERT INTO bmh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus nug gonugau tapaimaraneu dudu agen ze go en kanabai auraporoi abe maimai, awareun, “Iz enai ze memin, ‘Ziwas ipal dai dai, ag iz koli i peilamamen, ziwas ipal maziaba, ag iz kolital peilamamen,’ ze go en agzozou kanabemen ta? ");
INSERT INTO bmh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Iz petak pet awarem, ag oiagab eg waba, ag weinamamen. Guzenebi, em e ebuan duailel go siksikamam. Ag, izal duailel, oiagab eg wamau, bo, agal oiagab koli naliu usalaba, siksikamamen. ");
INSERT INTO bmh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Air tub go mogoi soligwabun go ougab eg waneu. Einen, go mu banou wabun ziwas waugab zoimai dareu. Bo, go mogoi soligwaimai, go koli mu go en i dabilaneu. Mogoi go en siksikaneu. ");
INSERT INTO bmh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Igul go sul, ag ebalagab zumau. Ulis ag oiagab eg weu, bo, iz ag koli uligaremin, agal oiagab naliu usalaba, siksikamamen. Siksikamamen go du tub nug agal oiagab ougan oi heiabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ziwas go zumau ziwas ebu, agen iz ece tub en i ailamamen. Iz petak pet awarem, ag izal duailel, ein ece wabun mekai auramamen, go nug maramau. ");
INSERT INTO bmh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Getal daremun alai alai ulis, ag izal wanim pataimai, ece tub wabun i auremen. Ulis ag aurebi, go nug maraba, umamen. Guzenaimai, ag banban siksikamamen.” ");
INSERT INTO bmh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesus nug koli gonugau tapaimaraneu dudu awareun, “Iz ulis tatau ze eim awarem. Ziwas petak zumau ziwas ebu, tatau ze eim i awarai. Mekai en araog awarai. ");
INSERT INTO bmh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ziwas go ebu, ag izal wanim pataimai, ece tub wabun mekai auramamen. Iz gusig mui, gonun, agen izal wanim pataimai, mekai aurebi, go nug doimai, agal ze sesamoramau. Guzenebi, izan ag en go i aurai. ");
INSERT INTO bmh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Iz Uwait al daimai, alemin en agal oiagab petak emen. Ag han agal oiagab iz en noumemen, gonun, mekai nug han ag en ougab noumeu. ");
INSERT INTO bmh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iz izal mekai dual daimai, em e ebu alemin. Guzenaimai, ulis iz em e uteimai, koli izal mekai dareu wag siai.” ");
INSERT INTO bmh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Guzenai awarina, Yesus nugau tapaimaraneu dudu agen auremen, “Ulis, na araog ze mem, tatau ze eim migab tam. ");
INSERT INTO bmh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ulis ig abe mem na ece unum abiu, na du tub nugau dabeleu unum abe macanem, gonun, na gonugau ze i kanabamam. Go en igual oigeb petak eu, na Uwait nug al daimai, alemen.” ");
INSERT INTO bmh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesus nug koli awareun, “Ag ulis agal oiagab petak eu! ");
INSERT INTO bmh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bo, ziwas waigeb zoi dareu, petak pet, ulis zoi dareu, dudu ipal agen ag unum zamarebi, beu beu agal uzan uminai teliteliamamen. Ag iz utilai wanebi, izaseu tutak tapai dai. Bo, iz tutak i dai, einen, izal mekai go iz ibail dareu. ");
INSERT INTO bmh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iz ag ze go agal oiagab oug selai dabun awarem. Em e ebu ag uhu banban oimai, oiagab eg wamau. Bo, ag gusig tapai dacan, einen, iza em e ebuan gusig unum zilacoromin.” ");
INSERT INTO bmh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus ze go gonugau tapaimaraneu dudu awaraimai, Mesgai wag ameitaimai, Uwait auraimai, eneun, “Mekai, ziwas ulis zou, nait mogoi nugau wanib ulagwag banou moren, guzenemen, nan nug han nait wanim ulapwag banou mizamau. ");
INSERT INTO bmh_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Na duailel e unum gumarabun gusig go moromen guzenaimai, nagen duailel go moromen go nug awau muzmuz dabun gusig maramau. ");
INSERT INTO bmh_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Awau muzmuz dabun zebigeg go, duailel agen Yesus Kristus na ibaiz ereg abe marem. Na tutak, na Uwait, na Yesus Kristus palautina, aleun abe memen. ");
INSERT INTO bmh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iz em e ebuan duailel nait gusig, wanim ulapwag mui ereg abai maremin. Iz na nait salau mabun palautilemen go unum poemin. ");
INSERT INTO bmh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mekai, getal em e usalab tam ebu, iz na ibaiz daimai, wanim ulapwag mui daremin. Ulis nait amen ebu wanib go ulapwag mui koli milemen, iz na ibaiz dai. ");
INSERT INTO bmh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Iz nagtal em e ebuan duailel tapai maraimai, iz milemen, nait gusig abai maremin. Getal duailel go nait tapai maremen daremen, na iz milemen, goagen nait ze sesamoranem. ");
INSERT INTO bmh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Go ulis abe memen ece unum iz milemen, go na eiman aleun. ");
INSERT INTO bmh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nait ze ailemen, unum awarina omen. Go abiu go petak iz na ibaiz daimai, alemin. Na palautilena, alemin en goagal oiagab petak eu. ");
INSERT INTO bmh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iz go en na aizem, iz em e ebuan duailel en aizab tam. Bo, duailel e nagtal iz milemen en aizem, einen, duailel go nait. ");
INSERT INTO bmh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Izal duailel go nait, nait duailel go izal. Duailel ipal go izal duailel agal igul uligaimai, go abe mamam izal wanim ulapwag mui. ");
INSERT INTO bmh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iz em e ebu ban i dai. Ulis iz na darem wag siabun darem, bo, go em e ebu damam. O mekai, nait igul naliu pet, na duailel go gumaraimai, nait gusig iz milemen gusig go nug, go gusig maremen, damam. Guzenemen, igual oigeb tutak darem sul, go han oiagab tutak mai damam. ");
INSERT INTO bmh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Iz go abai daimai, gusig go na iz milemen eiman gumaranem. Iz suban gumaremin, du tub utab tam. Tapaimaranem du go tutak nagen go oi abun abu daba, go oi amam. Go nait ze getal ananem petak zou. ");
INSERT INTO bmh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Iz ulis na darem wag siamoroi. Em e ebu, iz ze go ag duabun anem, einen, izal oiab unum siksikeu sul go agal oiagab oug han guzental siksikamam. ");
INSERT INTO bmh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Iz nagen ze milemen awaremin. Go en em e ebuan duailel agen go gasag maremenin. Einen, iz em e ebuan tam. Izal duailel go han em e ebuan tam. ");
INSERT INTO bmh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Iz na go em e ebuan imarai wag siabun aizab tam, na go isanarabun en iz aizem. Guzenemen, du eg Satan nug go eg i maramau. ");
INSERT INTO bmh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Iz em e ebuan tam, gonun, go han em e ebuan tam. ");
INSERT INTO bmh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nait ze unum petak pet. Nagtal nait petak ze nug goagal oiagab oug gusig maraba, go nait duailel tuguiai usalamam. ");
INSERT INTO bmh_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Na iz em e ebu duailel ula ebu palautilena, alemin sul, izan han go em e ebuan duailel ula palautaremin. ");
INSERT INTO bmh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iz go isanarabun izal enim unum na mizem. Guzenemin, go nait duailel tuguianau pet damam. ");
INSERT INTO bmh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Iz go en tutak aizab tam, duailel inen izal tapaimaranem dudu agen ze go awarina, doimai, goagal oiagab petak ai darem go han isanarabun en na aizem. ");
INSERT INTO bmh_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Izal dabeleu duailel e unum goagal oiagab tutak mai damam. Mekai, na iz ibail darem, iz han na ibaiz darem sul guzenamam. Guzenaimai, go ig ibaig dabun iz aizem. Guzenebi, em e ebuan duailel agen nagen iz palautilena, alemin en goagal oiagab petak amam. ");
INSERT INTO bmh_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na iz wanim go ulapwag milemen sul, izan han go wanimag wag maremin, gonun, ig tutak darem sul go han oiagab tutak mai damam. ");
INSERT INTO bmh_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iz go abai pezarai darem sul na iz ibail pezile darem. Guzenaimai, em e ebuan duailel abe mamam, nagtal iz palautileimai, nait ounab iz en noumanem sul, na han izal duailel en ounab nug guzental noumamam. ");
INSERT INTO bmh_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O mekai, nagtal duailel go iz milemen iz na aizem, iz simai dai ebu go han iz ibail ereg si damam. Guzenaimai, getal em e patai mab tam ebu, na nait ounab iz en noumaimai, wanim go ulapwag milemen go pimam. ");
INSERT INTO bmh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O mekai, na igul naliu macanemen du, em e ebuan duailel go na abe mizab tam. Duailel e na iz palautilemen abe milemen, go sag petak iza eiman na abe mizem. ");
INSERT INTO bmh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Izan nait wanim go ebalagab araog mizemin kolital araog mizai. Guzenemen, na iz en ounab nug noumanem sul, goagen han dudu ipal en goagal oiagab nug noumaba, iz go abai dai.” ");
INSERT INTO bmh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus go Uwait aurai maziaimai, gonugau tapaimaraneu dudu abai ze tub wanib Kidron eiman betemen. Ze go gasag gonugau tapaimaraneu dudu abai wai tub wanib Oliv wai ebu betemen. ");
INSERT INTO bmh_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zudas go Yesus gonugau iwai zaugul ebeagab ebu mabun du, go abiu Yesus wai go umkoskos gonugau tapaimaraneu dudu abai bitaneu. ");
INSERT INTO bmh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Guzenaimai, Zudas nug Uwait ula dacanemen dudu banban ipal agal salau dudu mui, Parisi dudu agal salau dudu mui, Rom agal malai dudu mui imarai, ougem go betemen. Go al ipal mui, malaimanemen ecesab mui, oimai alemen. ");
INSERT INTO bmh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus gue igul go zuabun unum abe meun, gonun, go nug go waiagab beteimai, kanabareun, “Ag in itanai daremen?” ");
INSERT INTO bmh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Goagen enemen, “Ig Nasaret uzanan Yesus itanem.” Gonug awareun, “Go iz sag.” Zudas gue go abai ereg tapai dareun. ");
INSERT INTO bmh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesus nug ‘Go iz sag’ awarina, go esilakaimai, uminaimai, em ebu alai nomen. ");
INSERT INTO bmh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Go nug kolital awareun, “Ag in itanai alemen?” Goagen enemen, “Nasaret uzanan Yesus.” ");
INSERT INTO bmh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesus nug awareun, “Iz amegai awaremin, go iz sag. Ag iz itanilemen aba, dudu e iz ibail darem utarebi, unamam.” ");
INSERT INTO bmh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ze go, go getal aneun guzental petak zuabun en awareun. Go getal ze meun, ‘Mekai, iz dudu e nagtal milemen du tub utab tam.’ ");
INSERT INTO bmh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon-Pita nug gonugau maulzag huia oimai, Uwait ula dacaneu du banou pet nugau salau du wai aimai gonugau dabug gau naliu eiman kuatai heun. Salau du gonugau wanib Malkus. ");
INSERT INTO bmh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesus nug Pita gusig aureun, “Nait maulzag koli gonugau zo oug zulagai memen numau. Mu go mekai nug mileun, nait dabeleu iz mu go i wai em ta?” ");
INSERT INTO bmh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","Guzenaimai, Rom agal malai dudu mui, goagal gumaraneu du banou mui, Zuda dudu banban agal salau dudu mui, goagen Yesus gusig pataimai, ebeg us sil kiaimai, amegai Anas waugab imai betemen. Anas go Kaiapas nugau tanau. Kaiapas gue wai go ebu Uwait ula dacabun du banou pet dacabun moromen. ");
INSERT INTO bmh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Go Kaiapas nug getal Zuda dudu banban enai awareun, ‘Du tutak nug duailel unum agal empip oimai, noumabun iboin’ aimai awareun. ");
INSERT INTO bmh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon-Pita zaug Yesus nugau tapaimaraneu du tub al go Yesus sesamorai betemen. Uwait ula dacaneu du banou pet nug tapaimaraneu du tub go abe meun, gonun, go Yesus sesamoraimai, zaueim sieun. ");
INSERT INTO bmh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita go uzaneim zau ogeiman tapai dareun. Tapaimaraneu du tub go nug koli uzaneim noimai, zau go og gumaneu air go nug Pita zaueim imai siabun aurina, imai sieun. ");
INSERT INTO bmh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Guzenina, air go nug Pita aureun, “Na han du go nug tapaimizeun du ta?” Pita nug koli aureun, “Tam, iz gonugau tapaimaraneu du tam.” ");
INSERT INTO bmh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ziwas go ebu ut malalai, gonun, go ebuan dudu mui, zau gumanemen dudu go ab zoroimai, ab ugei daremen. Pita go han beteimai, go abai ereg ab ugei dareun. ");
INSERT INTO bmh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ziwas go ebutal, Anas nug Yesus gonugau tapaimaraneu dudu en mui gonugau ze duailel maraneun en mui, kanabeun. ");
INSERT INTO bmh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesus nug aureun, “Iz duailel agal gotulanemen zaueim mui, Nou Zau banou zaueim mui, ze maranemin. Go ebu, Zuda duailel unum alai gotulanemen, iz ze tub wage wageimai awarab tam. ");
INSERT INTO bmh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na einen iz ailem? Duailel go izal ze domen na go awaren. Iz ein ze awaremin go abiu.” ");
INSERT INTO bmh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesus nug ze go aurina, malai du tub nug Yesus sibeg ebu waimai, eneun, “Na Uwait ula dacaneu du banou enai auranemen em ta?” ");
INSERT INTO bmh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus nug koli du go aureun, “Iz ze polumaremin zob, ein polu ze memin aba duailel e awaren. Bo, iz petak ze mem aba, na iz einen sibe ebu iwem?” ");
INSERT INTO bmh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Guzenaimai, Anas nug Yesus ebeg us mui Uwait ula dacaneun du banou pet, Kaiapas waugab palautina, beteun. ");
INSERT INTO bmh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon-Pita go tapai dareun empiptal tapai daimai, ab ugei dareun. Dudu ipal agen koli kanabemen, “Petak pet, na du go nug tapaimizeun ta?” Gonug polumaimai, eneun, “Iz gonugau tapaimaraneu du tam.” ");
INSERT INTO bmh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Guzenina, Uwait ula dacaneun du banou pet nugau salau du tub zoun. Du go Pita nug dabug kuateun du Malkus nugau zaug nug zoimai, kanabeun, “Na du go mui ougem ereg daremen peizemin ta?” ");
INSERT INTO bmh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita nug koli eneun, “Tam pet tam. Iz du go i abiu.” Go guzenina ina, toi uleun. ");
INSERT INTO bmh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Malai dudu agen Yesus Kaiapas nugau zau eiman imai aimai, emgasag go gumaneu du banou nugau zaueim imai betemen. Du go gue Rom emgasag ebuan. Go umaseu pet betemen. Zuda dudu banban agen du banou go nugau zaueim siab tam, einen, dabilemen go gonugau zaueim simam, Uwait nugau ameg ebu unu mui usalaimai, Pasowa ee i zimam aimai guzenemen. ");
INSERT INTO bmh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Guzenaimai, go gue uzaneim gumei darena, Pailot nug uzaneim noimai, dudu kanabareun, “Du e nug ein igul meun ag uligaimai, imai alemen?” ");
INSERT INTO bmh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Goagen koli enemen, “Go igul eg mab tam zob, ig go na wautab i imai alem zob.” ");
INSERT INTO bmh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailot nug awareun, “Ag go imai beteiban, agal kasai ze sesamoraiban, gonugau igul eg meun uligan.” Guzenina, Zuda agal dudu banban agen koli enai auremen, “Igual ebeig nug du tub wemun, noumabun iboin tam. Igul go Rom agal.” ");
INSERT INTO bmh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Getal Yesus nug nugen noumabun ze maimai, igul go eiman noumabun aneun. Gonugau ze ulis petak zuamoroi. ");
INSERT INTO bmh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Guzenaimai, Pailot go koli zaueim simai, Yesus ulorona, sina, kanabeun, “Na Zuda duailel agal gumarabun du banou king ta?” ");
INSERT INTO bmh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus nug koli aureun, “Ze go anem nait dabeleu eiman ta, dudu ipal agen na aizemen iz ailem ta?” ");
INSERT INTO bmh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailot nug koli aureun, “Na iz Zuda du dabelem ta? Na erunemen ze iz i abiu. Nait duailel mui, Uwait ula dacanemen dudu banban mui, agtal na iz waiab imaiz alemen. Na erunemen? Iz ailen.” ");
INSERT INTO bmh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus nug eneun, “Izal gumabun uzan em e ebu i dareu. Tam pet tam. Izal gumabun uzan em e ebu dareu zob, izal sesamilanemen dudu agen izal eiman isanileimai, alalebi, iz Zuda dudu agal ebeagab i milem zob. Bo, izal gumabun uzan em e ebuan tam.” ");
INSERT INTO bmh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Guzenina, Pailot nug koli kanabeun, “Guzenaimai, na uzan tub eiman gumarabun du banou petak ta?” Yesus nug koli aureun, “Ze go nait dabeleu ebu zou go petak. Izal anikai nug em e ebu go enegun soliciweun. Iz petak ze mem, go izal salau. Duair in petak ze sesamoraneu, go izal ze duacaneu.” ");
INSERT INTO bmh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailot nug Yesus aureun, “Petak ze, go ein ze pet?” Pailot nug ze go auraimai, go koli uzaneim Zuda dudu daremen ebu noimai, awareun, “Iz du e nug igul eg tub meun piab tam. ");
INSERT INTO bmh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bo, ag abiu igual igul, iz umkoskos wai tutak tutak ebu, Pasowa Imabun Ziwas Zobu ebu, du tutak hiacaranem zau oug dareu utena, unaneu. Gonun, ag dabelen iz ‘Zuda duailel agal gumarabun du banou’ utei maremin, unamau ta?” ");
INSERT INTO bmh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Goagen koli Pailot gusig kagagai ulaimai, enemen, “Tam pet tam. Go tam. Barabas utemigemen, unamau.” (Barabas go zob du eg tub.) ");
INSERT INTO bmh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Guzenai aurina, Pailot nug gonugau malai dudu Yesus imai busil esalausul wabun awarina, busil esalausul omen. ");
INSERT INTO bmh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Malai dudu agen us kulam mui oimai, kukotoimai, gonugau gagalig ebu kulai moromen. Guzenaimai, tibur galau naliu king nugau sul oimai, arugai moromen. ");
INSERT INTO bmh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Go waugab alaimai, koli koli ze biabial kuai auremen, “Na Zuda duailel gumarabun du banou king umkoskos damam!” Guzenai auraimai, sibeg pouai hemen. ");
INSERT INTO bmh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailot nug koli uzaneim noimai, duailel awareun, “Ag uligan. Iz go uzaneim ag ameagab ebu imai alem, go ag abe mamamen iz du e nugau igul eg tub meun piab tam.” ");
INSERT INTO bmh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Guzenaimai, Yesus us kulam king nugau hat sul mui, tibur galau gulin mui arugaimai, uzaneim nuna, Pailot nug awareun, “Ag anemen du e uligan.” ");
INSERT INTO bmh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Guzenai awarina, Uwait ula dacanemen dudu banban mui, Nou Zau banou gumanemen dudu mui, goagen Yesus uligaimai, Pailot gusig ze auremen, “A gegeulanau ebu wai memen, noumamau. A gegeulanau ebu wai memen, noumamau.” Guzenina, Pailot nug awareun, “Agenag oiban, a gegeulanau ebu asai macan. Iz go wemin, noumabun igul eg tub go nug meun i pem.” ");
INSERT INTO bmh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bo, goagen koli Pailot auremen, “Igual kasai ze nug guzeneu, du go noumamau, einen, nugtal ‘Iz Uwait nugau Nag’ aimai ze meun.” ");
INSERT INTO bmh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailot gue ze go doimai, banban umineun. ");
INSERT INTO bmh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Guzenaimai, Pailot nug koli zaueim simai, Yesus kanabeun, “Na eru uzanan?” Go guzenai aureun, bo, Yesus nug ze tub koli aurab tam. ");
INSERT INTO bmh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailot nug Yesus koli aureun, “Na einen iz ze milab utem? Na abiu tam ta? Dudu banban agen iz gusig milemen. Iz na utizemin, unabun iboin. Na a gegeulanau ebu niwemin, noumabun iboin.” ");
INSERT INTO bmh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus nug koli aureun, “Na iz a gegeulanau ebu asai heilabun anem, go Uwait nugtal gusig go mabun mizeun. Bo, du in nug iz imaileimai, nait eben ebu mizeun, du go nugau igul eg nug nait igul eg unum zilacoroi dareu.” ");
INSERT INTO bmh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailot go Yesus nug ze go mina, doimai, ein abu eiman Yesus utemin, unabun aimai dabeleun. Bo, duailel agen koli guzenai ulwemen, “Na du go utemen, unamau, na Sisar nugau zaug i damam. Du in nugtal go iz gumarabun du banou eu, go Sisar nugau iwai zaug.” ");
INSERT INTO bmh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailot gue ze go doimai, Yesus imai aimai, noi ze sisiaranemen biz ebu hoboun. Empip go Hibru ze eim Gabata anemen. (Ze zebigeg ‘ai biz’.) ");
INSERT INTO bmh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pasowa zobu piabun gil tuaba zumau, gonun, go ulis sul goagal ece suban macanemen. Am ban ula ebu, Pailot nug duailel awareun, “Agal gumarabun du banou uligan.” ");
INSERT INTO bmh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Goagen koli ulwemen, “Webi, noumamau! Webi, noumamau! A gegeulanau ebu webi, noumamau!” Pailot nug awareun, “Ag dabilan izan agal gumaraneu du banou a gegeulanau ebu wemin, noumamau ta?” Uwait ula dacanemen dudu banban agen enemen, “Ig gumiganeu du tub i dareu. Sisar tutak go igual gumiganeu du banou.” ");
INSERT INTO bmh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Go guzenina, Pailot nug Yesus a gegeulanau ebu webi, noumabun malai dudu ebeagab mareun. ");
INSERT INTO bmh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Go Yesus imai betena, nugtal gonugau a gegeulanau gamai aimai, ban uzan uteimai, em tub wanib ‘Eb Gagalig Gulam’ em manam ebu sieun. Hibru ze eiman uzan go Golgota anem. ");
INSERT INTO bmh_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Guzenaimai, uzan go ebu, a gegeulanau ebu asai memen. Dudu aliag go han Yesus al ereg a gegeulanau beu beu tubaim tubaim asarai memen. Yesus gue dudu go ula asai memen. ");
INSERT INTO bmh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailot nug sikut tub guzenai wai meun, ‘Nasaret uzanan Yesus. Zuda duailel agal gumaraneu du banou, king.’ Guzenai sikut waimai, a gegeulanau ebu asai memen gonugau tabauguab wai meun. ");
INSERT INTO bmh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Go ban uzan waugab, Yesus asai memen. Guzenina, duailel asiu agau go sikut weun Yesus nugau tabaugwab wai meun nanalemen. Sikut go Hibru ze, Rom ze mui, Grik ze eiman mui, weun. ");
INSERT INTO bmh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Guzenina, Uwait ula dacanemen dudu banban agen Pailot auremen, “Na einen du go gue Zuda duailel gumaraneu du banou king aimai sikut wai memen? Nugtal ‘Iz Zuda duailel gumaranem du banou, king’, eun. Na einen guzenai sikut wai mab utem.” ");
INSERT INTO bmh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Guzenina, Pailot nug koli awareun, “Izan ein ze sikut wai memin go iboi, guzental damau.” ");
INSERT INTO bmh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Malai dudu agen Yesus a gegeulanau ebu asai maimai, gonugau tibur galau iwanarai sag doumaimai, tutak tutak omen. Gonugau tibur galau huia arugeun han omen. Tibur galau tutak go huia unum sopwemen. ");
INSERT INTO bmh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Malai dudu agen agzozou enemen, “Tibur galau go i bigagan. Ig onanem aiwag oimai, onaimai, piabun in nug umau.” Guzenaimai, ze go getal sikut wemen petak usaleun. ‘Agen izal tibur galau agzozou doumai omen. Izal tibur galau huia en onanem aiwag onaimai, omen.’ ");
INSERT INTO bmh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesus nugau a gegeulanau waugab gonugau anag mui, gonugau anagiag Klopas nugau wau wanib Maria mui, Magdala uzanan Maria ereg, go go ebu tapai daremen. ");
INSERT INTO bmh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesus nug gonugau anag mui gonugau tapaimaraneun du go en ougab noumaneu abai piaraimai, anag guzenai aureun, “Anikai, du e, go nait nan pet.” ");
INSERT INTO bmh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Guzenaimai, koli tapaimaraneun du go aureun, “Air e, go nait anan.” Guzenina, ziwas go ebutal, Yesus nugau anag tapaimaraneun du go nug gonugau zaueim imai betei mina dareun. ");
INSERT INTO bmh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus go abiu ulis Uwait nug em e ebu salau mabun aureun, salau unum mazieun. Guzenaimai, Yesus nug eneun, “Iz ze usegiweu.” Guzenina, ze go getal Uwait nugau agau ebu aneun guzental go petak zou. ");
INSERT INTO bmh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ee tebil tub wain ze munug mui waugab dareun, gonun, go ece tub ambig sul oimai, wain ze munug go oug suaimai, a umag ebu maimai, gonugau ogusau ebu memen. ");
INSERT INTO bmh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesus gue wain ze munug go zaimai, eneun, “Ulis salau go maziai dareu.” Guzenaimai, go gonugau dug kuai nuna, gonugau wes utei waneun. ");
INSERT INTO bmh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Guzenina, Zuda agal gumaranem dudu banban agen a gegeulanau ebu asarai memenin dudu aramag kikikukarebi, pigai noumebi, imarai unabun Pailot auremen. Ziwas go ece suban macanemen ziwas, gonun, go guzenai kanabemen. Goagal Imabun Ziwas Zobu tuaba, gonun, dudu goagal enimag utarebi, ziwas go ebu a gegeulanau ebu dabun iboin tam dabilemen, gonun, guzenemen. ");
INSERT INTO bmh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Guzenaimai, malai dudu agen beteimai, dudu aliag go Yesus dual asarai memen aramag kikikukaremen. ");
INSERT INTO bmh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bo, Yesus go noumina, uligaimai, gonugau arab kukalab tam. ");
INSERT INTO bmh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bo, malai du tub nug gonugau malai sil Yesus nugau gasag ebu wina, pigai eseu ze mui nuna, pemenin. ");
INSERT INTO bmh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Du nugtal igul go guzenemen peimai, eneun, “Igul go petak usaleun.” Go nugtal abiu go petak ze sag macaneu. Gonun, ag han agal oiagab petak an.) ");
INSERT INTO bmh_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Igul go guzenemen go getal Uwait nugau agau ebu aneun, petak usaleu. Guzeneun, ‘Goagen gonugau arab tub i kuamam.’ ");
INSERT INTO bmh_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ze tub getal Uwait nugau agau ebu han eneun, ‘Duailel du go malai sil wemen sug gul mui pimamen.’ ");
INSERT INTO bmh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Go guzenina, du tub gonugau wanib Zosep, go Arimatea uzanan, go Yesus nugau noumeun enib a gegeulanau ebuan oi unabun zoimai Pailot aureun. Zosep go han Yesus nugau tapaimaraneun du, bo, go Zuda agal gumaranemen dudu banban uminaraimai, go Yesus en ougab petak eun wageimai meun. Pailot nug ‘io’ aurina, go betei, Yesus nugau noumeun enib a gegeulanau ebuan oun. ");
INSERT INTO bmh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus du gue go getal Yesus piabun umaum beteun, go han alaimai, Zosep al Yesus nugau noumeun enib wabun beteun. Go a ze tub sous naliu zuaneu oimai, beteun. A ze go gonugau uhu houhou ainarai 30 kilo sag. ");
INSERT INTO bmh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dudu aliag go agen Yesus nugau noumeun enib oimai, a ze sous naliu zior aimai, tibur galau sil gonugau noumeun enib kulaimai, otoi memen. Igul go Zuda agal dudu noumanem ob oug hiacarabun igul sul guzenemenin. ");
INSERT INTO bmh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesus a gegeulanau ebu asai memen waugab, ekakai ougem tub dareun. Ougem go aizau ob awau tub elemen. Go oug getal du tub i memen. ");
INSERT INTO bmh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ziwas go ebu, Zuda duailel agal Imabun Ziwas Zobu zuna, aizau ob go waugab dareun, gonun, go Yesus imai betei aizau ob go oug hemenin. ");
INSERT INTO bmh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ban Zobu ebu, umaum em ilai alina alina, Magdala uzanan Maria go Yesus ob ebu piabun beteun. Go beteimai, ai banou sil im go tapelai memen oi hemen uligeun. ");
INSERT INTO bmh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Go koli pigai, Saimon-Pita zaug Yesus nug gonugau tapaimaraneu du tub go en ougab noumaneu mui go waiagab beteimai, awareun, “Dudu ipal agen Dubanou Ban nugau noumeun enib ob ougan imai wanemen. Go eru ebu betei wageimai memen dareu ig i abiu.” ");
INSERT INTO bmh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Guzenina, Pita zaug tapaimaraneun du go al asaimai, ob ebu betemen. ");
INSERT INTO bmh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Du go Pita dual ereg pigai betemen. Du go nug Pita zilacoroimai, pigai go in amegai ob ebu beteun. ");
INSERT INTO bmh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Go beteimai, ob waugab waulai noimai, aizau oug amet eun. Go tibur galau Yesus nugau noumeun enib kulai memen dareun peun. Go ob oug siab tam. ");
INSERT INTO bmh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon-Pita go ses zoimai, aizau oug simai, tibur galau go dareun peun. ");
INSERT INTO bmh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tibur galau tub gagalig ebu otoi memen han dareun uligeun. Tibur galau go beu beu i dareu, go du tub nug suban maneu sul guzenai mina, dareun. ");
INSERT INTO bmh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Guzenina, du go gue amegai ob ebu zoun go han aizau oug sieun. Go ecesab go peimai, gonugau ougab petak eun. ");
INSERT INTO bmh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ziwas go ebu, ag ze go Uwait nugau agau ebu go koli asamau aimai aneun suban abe mab tam. ");
INSERT INTO bmh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gonun, tapaimaraneun dudu aliag go koli uzan utei betemenin. ");
INSERT INTO bmh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria gue ob go waugab tapai daimai, manil mai dareun. Go manil mai daimai, waulai noimai, ob go oug ameg heun. ");
INSERT INTO bmh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Uwait nugau tibur aliag tibur galau ausiau mui go Yesus nugau noumeun enib gabuai memen ebu hoboi daremen. Tub gagalig eiman hoboi dareun, tub nug arab eiman hoboi dareun uligeun. ");
INSERT INTO bmh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Goagen Maria guzenai kanabemen, “Air, na ein en ounab eg wina manil mai darem?” Gonug koli awareun, “Izal Dubanou Ban nugau enib oi wanemen. Iz i abiu eru ebu memen ab!” ");
INSERT INTO bmh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Go guzenaimai, kekulaimai, Yesus tapai dareun uligeun. Air go gue Yesus nugau siameg uligaimai, abe mabun iborain tam, go ougab alia meun. ");
INSERT INTO bmh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Guzenaimai, Yesus nug kanabeun, “Na ein itanaimai, manil mai darem?” Maria gonugau dabeleu go wai gumaneun du nug guzeneu aimai, aureun, “Du banou, na gonugau noumeun enib oi betemen aba, gonugau noumeun enib eru ebu oi betei memen ailemenag, betei imai.” ");
INSERT INTO bmh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus nug aureun, “Maria.” Guzenina, Maria gonugau zeu doimai, kekulaimai, Yesus suban uligaimai, abe moroimai, Hibru ze eim eneun, “Rabonai.” Ze go zebigeg enai, ‘Igul abai miganem du’. ");
INSERT INTO bmh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus nug koli aureun, “Iz izal mekai dareu wag i siau darem, gonun, na iz i patilen. Bo, na beteiba, izal tapaimaranemin dudu awaren, ‘Iz izal mekai dareu wag siamoroi. Go han agal memeag. Go izal Uwait, agal Uwait ereg.’” ");
INSERT INTO bmh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Guzenai aurai mazicina, Maria nug beteimai, Yesus nugau tapaimaraneun dudu awareun, “Iz Dubanou Ban koli ob ougan waseun pemin.” Yesus nug aureun ze go tapaimaraneun dudu unum awareun. ");
INSERT INTO bmh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yesus nugau tapaimaraneun dudu go Zuda agal dudu banban uminaraimai, goagal dacanemen zaueim im gusig gebeimai, daremen. Ban Zobu ebu, umaum, Yesus nug gonugau tapaimaraneun dudu ula zoi tapai daimai, awareun, “Ag agal oiagab selai damau.” ");
INSERT INTO bmh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Go guzenai awaraimai, gonugau ebeg wemen mui gonugau gasag eiman malai sil wemen sug gul abai mareun. Gonugau tapaimaraneun dudu go Dubanou Ban uligaimai, oiagab siksikemenin. ");
INSERT INTO bmh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesus nug koli awareun, “Ag agal oiagab selai damau. Izal mekai nug iz palautilena, alemin sul izan han guzental ag palautarem.” ");
INSERT INTO bmh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Guzenai awaraimai, gonugau ogusau wes go ebalagab huaimai, eneun, “Agal oiagab oug Ah Wes on. ");
INSERT INTO bmh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Agen dudu ipal agal igul eg zilagai marebi Uwait nug han dudu go agal igul eg unum zilagai maramau. Bo, agen dudu ipal agal igul eg i zilagai marebi Uwait nug han goagal igul eg i zilagai maramau.” ");
INSERT INTO bmh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesus gonugau tapaimaraneun dudu ameagab ebu zoun ziwas ebu, gonugau tapaimaraneun du tub gonugau wanib Tomas, gonugau wanib tub Didimus, gue go abai dab tam. ");
INSERT INTO bmh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Go koli zuna, gonugau zaugul agen auremen, “Ig Dubanou Ban uligemun.” Tomas nug koli awareun, “Bo, izal ame nug gonugau ebeg sug gul peimai, izal ebesil gonugau gasag oug malai sil wemen sug gul ebu maimai, go petak izal oiab petak anai.” ");
INSERT INTO bmh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Zobu tutak mazicina, ziwas tub Yesus nugau tapaimaraneun dudu go unum koli zaueim im gusig gebeimai, gotulai daremen. Ziwas go ebu, Tomas al ereg daremen. Im gusig gebemen, bo, Yesus go koli zoimai, gonugau tapaimaraneun dudu ula zoi tapai daimai, awareun, “Ag agal oiagab selai damau.” ");
INSERT INTO bmh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Guzenaimai, go nug Tomas aureun, “Nait eben izal gisan ebu maiba, izal ebe uligen. Na dabeleu asiu uteiba, nait ounab petak en.” ");
INSERT INTO bmh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Guzenina, Tomas nug Yesus aureun, “Na izal Uwait iz ulapwag mizanem, na izal Dubanou Ban.” ");
INSERT INTO bmh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesus nug aureun, “Na iz uligileimai, nait ounab petak em ta? Dudu ipal go iz peilab tam, goagal oiagab petak emen dudu go agal oiagab banban siksikamam.” ");
INSERT INTO bmh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus nug gonugau tapaimaraneun dudu ameagab ebu gugeg beu beu meun, agau e ebu unum sikut wai mab tam. ");
INSERT INTO bmh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bo, Yesus go Kristus, du go Uwait nug gonugau duailel koli imarabun palautina, aleun, go han Uwait nugau Nag pet en agal oiagab petak abun aimai sikut wemin. Guzenaimai, ag go en agal oiagab petak amamen, ag awau muzmuz damamen. ");
INSERT INTO bmh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ziwas ipal mazicina, Yesus nugtal koli Galili Ze Unig waugab gonugau tapaimaraneun dudu ameagab ebu zoun. ");
INSERT INTO bmh_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Go ebu gonugau tapaimaraneun dudu guzenai daremen, goagal wanimag Saimon-Pita, Tomas (gonugau wanib tub Didimus), Nataniel (Nataniel go Kana uzanan Galili agaig ebuan), Zebedi nugau gelegul aliag mui, Yesus nugau tapaimaraneun dudu aliag han mui go ereg daremen. ");
INSERT INTO bmh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon-Pita nug gonugau zaugul guzenai awareun, “Iz karuk wabun bitamoroi.” Guzenina, gonugau zaugul agen auremen, “Ig ereg na ibaiz karuk wabun bitamam.” Guzenaimai, dudu go unum go tebil ebu simai, wanemen. Umaum go ebu go karuk tub wab tam. ");
INSERT INTO bmh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Em ilai alina, Yesus go Galili Ze Unig gasag tapai dareun pemen. Bo, gonugau tapaimaraneun dudu agen Yesus du in dareu aimai, abe mab anmemen. ");
INSERT INTO bmh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Guzenina, go nug kanabareun, “O, Zaiar, ag karuk ipal omen ta?” Goagen koli auremen, “Tam pet tam. Ig karuk tub wab tam.” ");
INSERT INTO bmh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Go nug koli awareun, “Agal karuk wanemen zo oiban, tebil gasag ebeag naliu eiman amacaimai, karuk ipal umamen.” Guzenina, goagen Yesus nugau ze sesamoraimai, goagal karuk wanemen zo ebeag naliu eiman heimai, koli patai keuina, tebil wag zuabun iborain tam, einen, karuk asiu kapai dareun. ");
INSERT INTO bmh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Guzenaimai, Yesus nug gonugau tapaimaraneun du tub go en ougab nug noumeu go nug Pita aureun, “Du go us nogoug ebu tapai dareu, go igual Dubanou Ban!” Saimon-Pita go agal Dubanou Ban us nogoug ebu tapai dareu aureun doimai, go gonugau tibur galau oi maimai, salau mai dareun pigai oi arugaimai, ban ze oug silikai noimai, ze asai beteun. ");
INSERT INTO bmh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tapaimaraneun dudu ipal go tebil ebu karuk zo kapai zoun mui, keuai ze gasag alemen, einen, us nogoug pulig tam. ");
INSERT INTO bmh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Go gasag alaimai, ab elei dareun pemen. Ab go ebu, karuk ipal ab gel wag dareun mui, bret ab gasag dareun pemen. ");
INSERT INTO bmh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Guzenina, Yesus nug awareun, “Ag karuk ipal ulis omen oi alan.” ");
INSERT INTO bmh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon-Pita nug pigai tebil wag simai, karuk zo mui keiuai gasageim aleun. Karuk banban asiu, 153 sag daremen. Karuk asiu zo kapai zoun, bo, zo karuk nug bigagab tam. ");
INSERT INTO bmh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus nug awareun, “Ag ee zabun e zon.” Guzenina, gonugau tapaimaraneun du tub nug gusig maimai, ‘Na du in’ aimai kanaburab tam. Einen, go abiu go Dubanou Ban nug. ");
INSERT INTO bmh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Guzenaimai, Yesus nug ab gasag zoimai, bret oimai, mareun. Go karuk han guzental mareun. ");
INSERT INTO bmh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesus noumaimai, koli ob oug eiman waseun ziwas ebu amegai gonugau tapaimaraneun dudu zaueim daremen ebu ziwas aliag ameagab ebu usaleun. Ulis e guzeneun go ziwas ainarai ameagab ebu usaleun. ");
INSERT INTO bmh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yesus gonugau tapaimaraneun dudu abai ee zaimai, Yesus nug Saimon-Pita kanaboroun, “Saimon, Zon nugau nag, na dudu e darem zilacaraimai, nait ounab iz en noumem ta?” Gonug koli aureun, “Io, Dubanou Ban, na abiu. Na izal apai sul. Iz na en oiab siksikeu.” Yesus nug aureun, “Na izal sipsip gelegul ee maren.” ");
INSERT INTO bmh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kolital Yesus nug kanaboroun, “Saimon, Zon nugau nag, na petak nait ounab iz en noumem ta?” Gonug aureun, “Io, Dubanou Ban, na abiu. Iz na izal apai sul en oiab siksikeu.” Yesus nug aureun, “Na izal sipsip suban gumaren.” ");
INSERT INTO bmh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kolital, Yesus nug kanaboroun, “Saimon, Zon nugau nag, na iz nait apan sul en ounab siksikeu ta?” Pita go Yesus nug kolital ziwas ainarai kanaborona, gonugau ougab uhu ban usalina, aureun, “Dubanou Ban, igul unum na nagtal abiu. Na abiu iz na izal apai sul en oiab siksikeu.” Yesus nug aureun, “Na izal sipsip gelegul ee maren. ");
INSERT INTO bmh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iz na petak pet aizem, na mogoi magun ebu, na eru ebu unabun dabeleimai, unanem. Aiu ses na ureg usalamam ebu, nait eben hemen, dudu ipal agen us sil kicizeimai, na uzan tub bitabun utamam ebu imaiz bitamam.” ");
INSERT INTO bmh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesus gue ze go aneun ein igul eiman Pita noumaimai, Uwait nugau wanib wag mabun aneun.) Guzenaimai, Yesus nug Pita aureun, “Na iz sesamilen.” ");
INSERT INTO bmh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita nug kekulaimai, Yesus nug tapaimaraneun du tub go en ougab nug noumeu, ses go waiagab zoi tapai darena, peun. (Getal Yesus dual ee zemen ziwas ebu du go nug waugab hoboi daimai, kanabeun, “Dubanou Ban, du in nug na iwai zaunar ebeagab ebu mizamau?”) ");
INSERT INTO bmh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita nug du go peimai, Yesus kanaboroun, “Dubanou Ban, du e go erunamau?” ");
INSERT INTO bmh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus nug koli aureun, “Bo, izal dabeleu iz go utemin daba, iz koli alai, na einen go en dabeleu asiu om? Na, iz sesamilen.” ");
INSERT INTO bmh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Guzenina, tapaimaraneun du go i noumamau aimai ze unum Yesus en oiagab petak emen duailel ebalagab betena unum domen. Bo, Yesus nug go i noumamau aimai anab tam. Go guzeneun, “Bo, izal dabeleu iz go utemin, daba, iz koli alai, na einen go en dabeleu asiu om?” ");
INSERT INTO bmh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yesus nugau tapaimaraneun du gotal go nug ulis igul go en ze maimai, gonugtal ze e sikut weun. Ig abiu gonugau ze e aneun, go petak pet. ");
INSERT INTO bmh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus nug igul ipal asiu han meun. Bo, iz go igul ipal en ze tutak tutak agau ebu sikut unum wemin zob, izal dabeleu agau go asiu em e ebu dabun pip tamacag. ");
INSERT INTO bmh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","O zai, Tiopilus, na Uwait alanem du. Iz amegai Yesus nug igul naliu guzeneun mui go nug salau meun betei, go Mesgai wag sieun mui, ze go unum sikut wai mizeimai, aizemin. Yesus go Uwait nug Mesgai wag imai i sieun ebu, go Uwait nugau Ah Wes nugau gusig mui eiman gonugau ze oi aidanemen dudu tapai mareun, gonugau ze suban awareun. ");
INSERT INTO bmh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesus go noumeun, koli awau asaimai, gonugau tapaimaraneun dudu ameagab umkoskos zuaneu. Gil 40 go guzenina, go abiu memen petak gonugtal go gue noumab tam, go koli waseun. Gonug ag Uwait nug koli alai gumarabun ze awareun. ");
INSERT INTO bmh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ziwas tub ebu go ereg ag abai zoi daimai, awareun, “Ag Zerusalem ban uzan i utei alian. Ag gumei dabi, Ah Wes getal mekai nug ag marabun baib mareun go en awaranem go gonug maramau. ");
INSERT INTO bmh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Getal Zon nug duailel ze sil ze ziwaraneun. Bo, ziwas huia tam, Uwait nug nugau Ah Wes sil ag ze ziwaramau.” ");
INSERT INTO bmh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ziwas tub ebu, Yesus nugau ze oi aidanemen dudu unum Yesus dual koli gotulaimai, go agen Yesus kanabemen, “Dubanou Ban, ziwas go ebu na igual iwai zaiger zamaraimai, Israel duailel e Zudia agaig koli maramam ta?” ");
INSERT INTO bmh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Guzenina, Yesus nug koli awareun, “Go agal salau tam. Izal mekai gonugtal gonugau gusig sil ziwas go izan em e gumarabun tapai meun. Ag ziwas go abe mabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bo, Uwait nugau Ah Wes ag ebalagab zuba, ziwas go ebu ag gusig go eiman Zerusalem ban uzan mui Zudia agaig mui Samaria agaig mui, emgasag gasag unum beteimai, izal wanim duailel awaramamen.” ");
INSERT INTO bmh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Go ze go awarina, Uwait nug go Mesgai wag imai sieun. Go pei daren daren, pi tub nug zoimai, go kulai meun, goagen piabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Go mazi wanena, go emes wag piab aimai ameitai darena, dudu aliag goagal tibur galau ausiau mui pigai go waiagab zoi tapai daimai, enemen, “Galili agaig an dudu, ag einen e ebu tapai daimai, emes wag ameitai daremen? Go Yesus go, ulis Uwait nug ag ebuan imai aimai, Mesgai wag sieu pemen sul, aiu ses koli guzental alamau pimamen.” ");
INSERT INTO bmh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Guzenaimai, Yesus nugau ze oi aidanemen dudu go Oliv em manam uteimai, koli Zerusalem ban uzan siemen. Go em manam Zerusalem uzan waugab dareu. ");
INSERT INTO bmh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Go ban uzan simai, goagal zau empip wag dacanemen ebu siemen. Dudu goagal wanimag go Pita, Zon, Zems, Andru, Pilip, Tomas, Bartolomiu, Matiu, Zems go Alpius nugau nag, Saimon go ug tub wanib Serot ebuan, Zudas go Zems nugau nag. ");
INSERT INTO bmh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dudu go Yesus en oiagab tutak maimai, Uwait aurina, ailel ipal mui Yesus nugau anag Maria mui gonugau amagul abai ereg go han umkoskos gotulaimai, Uwait auranemen. ");
INSERT INTO bmh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Ziwas tub ebu duailel goagal oiagab Yesus en petak emen 120 sag gotulai daremen ebu, Pita nug goagal ameagab ebu asaimai, eneun, “O zaiar, Zudas nug, Yesus malai dudu agal ebeagab ebu meun. Go en getal Uwait nugau Ah Wes Devit nugau ogusau ebu aneun go ulis petak zou. ");
INSERT INTO bmh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zudas go getal igual salau zaicig, Yesus nug ig ibaig ereg salau mabun tapai migeun. ");
INSERT INTO bmh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Zudas du go igul eg maimai, aiwag oimai, go aiwag sil em ginampet gau meun. Go ebu nugtal a ebeg ebu nug enib asanaimai, noumaimai, gonugau bigug pouaimai, big unum useai em ebu esikeun. ");
INSERT INTO bmh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Duailel unum Zerusalem uzan daremen go ze go doimai, goagen em go wanib Akeldama memen. Ze go gonugau zebigeg Esa em.) ");
INSERT INTO bmh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ze go getal Buk Song ebu guzenai sikut weun, ‘Gonugau zau gaul damau, du tub zau go i umau.’ Ze tub Buk Song ebu han dareu, guzeneun, ‘Du tub nug gonugau salau umau.’ ");
INSERT INTO bmh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Guzenaimai, ig ulis du tub igua ula ereg aidaneu, ziwas go ebu Yesus Dubanou Ban ig ibaig ereg darena, du go gue ereg dareun tapai mamau. ");
INSERT INTO bmh_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Getal Zon nug duailel ze ziwareun ziwas ebu alai, Yesus salau bigegweun betei ziwas go ebu Uwait nug Yesus koli Mesgai wag imai sieun. Du tub go igul go unum gonugau ameg nug peun ig go tapai mab. Go ig ibaig salau ereg maimai, Yesus koli waseun ze duailel maramau.” ");
INSERT INTO bmh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita nug guzenina, goagen dudu aliag taparai memen. Du tub Zosep, Sabas nugau nag, gonugau wanib tub Zastus. Du tub gonugau wanib Matias. ");
INSERT INTO bmh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Guzenaimai, ag Uwait guzenai auremen, “Banou, na dudu agal dabeleu oiagab oug abiu. Guzenaimai, nagen dudu aliag e darem, du in nait salau mizabun tapai memen abai migen. ");
INSERT INTO bmh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Go Zudas nugau empip oimai, salau mamau. Zudas go salau Yesus nugau ze oi marabun uteimai, go em eg ebu waneun.” ");
INSERT INTO bmh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Guzenaimai, goagen dudu aliag ula in tapai mabun onemen. Matias nugau aiwag naliupet zoun. Guzenaimai, Matias tapai memen. Guzenaimai, ze oi aidanemen dudu nagbasig sag daremen mui betei tulareun. ");
INSERT INTO bmh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ziwas tub, wanib Pentikos zuna, duailel agal oiagab Yesus en petak emen tutak zaueim gotulai daremen. ");
INSERT INTO bmh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Daren daren, saiu tub wol gusig sul nug pigai Mesgai wageiman alina, duailel zaueim go daremen go unum saiu banou go domen. ");
INSERT INTO bmh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Guzenaimai, go ab al minob sul nug alai kikakaraimai, dudu tutak tutak goagal gagaliag ebu iboreun pemen. ");
INSERT INTO bmh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dudu go unum Uwait nugau Wes nug goagal dabeleu unum gumaraimai, gusig marena, go ze ata atai emgasag ipal agal ze eiman zememenin. ");
INSERT INTO bmh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Go ebu, Zuda duailel go Zerusalem uzan daremen. Ipal Zuda duailel Uwait ulagwag muranemen emgasag ata atai ebuan alemen mui ereg daremen. ");
INSERT INTO bmh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Go saiu doimai, duailel asiu zau go waugab gotulemen. Duailel goagal oiagab petak emen goagal uzanan ze eiman ata atai zememenin doimai, go unum esilakemenin. ");
INSERT INTO bmh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Go esilakaimai, dabeleu asiu oimai, enemen, “Dudu gue guzenai zememen go unum Galili agaig an dudu. ");
INSERT INTO bmh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bo, igag unum tutak tutak igual uzanan ze ze mina, dom. ");
INSERT INTO bmh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Igag unum emgasag ata atai ebuan, Partia, Midia, Elam, Mesapotemia, Zudia, Kapadosia, Pontus, Esia agaig ebuan mui ipal Prigia, Pampilia, Izip mui Libia Sairini uzan waugab mui ipal Rom ban uzan ebuan alai darem. ");
INSERT INTO bmh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ig Zuda dudu ipal mui emgasag tub ebuan dudu Zuda agal igul sesamoremenin dudu ipal mui ig Krit waug uzan ipal mui Arebia agaig ebuan alai darem. Bo, Galili dudu ag Uwait nug gugeg ata atai maraba, igual ze ata atai ein ze mina, ig unum dom.” ");
INSERT INTO bmh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ag guzenai ze maimai, esilakaimai, dabeleu asiu oimai, agzozou kanabinar, “Go ein bigegun guzenem?” ");
INSERT INTO bmh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Guzenina, dudu ipal agen ze biabial kuai awaraimai, enemen, “Dudu go ze gusig zaimai, guzenem.” ");
INSERT INTO bmh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita nug mui Yesus nugau ze oi aidanemen dudu nigbasig sag ereg asaimai, go nug ze duailel guzenai awareun, “Ag Zuda duailel, duailel ipal unum Zerusalem ban uzan alemen, ag go don. Ag izal ze maramoroi igul e zoun gonugau zebigeg awaranai ag suban don. ");
INSERT INTO bmh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Agal dabeleu dudu e ze gusig zaimai, dabuiag guageu aigemen. Bo, ulis e amameg sai naliu (9) umaseutal guzeneu. Guzenaimai, dudu e ze gusig zab tam. ");
INSERT INTO bmh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ag go don! Uwait nugau Ze doimai, awaraneun du Zoel nug igul go en aneun. ");
INSERT INTO bmh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Uwait nug eneun, ‘Em tamabun ziwas waugab, iz izal Ah Wes unum duailel ebalagab palautai. Guzenemin, agal geleagar aleagar ein igul aiu ses zumau ze mamam, iz agal silin dudu igul ata atai abai maremin, pimam. Ureg dudu wabil aimai pimam. ");
INSERT INTO bmh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Petak pet ziwas go ebu iz izal Ah Wes gusig mui izal salau duailel ebalagab palautanai. ");
INSERT INTO bmh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gugeg ata atai emes mui em mui ebu macanai. Ziwas go ebu emes wageiman es mui, ab al mui, abmuk mui alamau. ");
INSERT INTO bmh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Am i ilamau, umut banou usalamau. Geil es sul epeu usalamau. Eisab igul go zuba, Uwait nugau ziwas gusig banou zumau. Ziwas go al banou mui zumau. ");
INSERT INTO bmh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","In duair Dubanou Ban guzenai auramau, “Dubanou Ban, izal igul eg ebuan imailen,” guzenai auraba, duair go Dubanou Ban nug imaramau.’ Zoel nug guzenai sikut weun. ");
INSERT INTO bmh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel duailel! Ag ze e don! Uwait nug Yesus Nasaret uzanan du tapai maimai, palautina, aleun. Uwait nugau gusig ebu du go salau gusig ban meun. Go ag ula salau go mina, ag salau go pemenin. ");
INSERT INTO bmh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Getal Uwait gonugtal Yesus ag ebeag ebu marabun abu kaleun. Guzenaimai, agen igul eg macanemen dudu agal ebeagab ebu marena, goagen a gegeulanau ebu asai maimai, wina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bo, Uwait nug du go koli asai meun. Go gonugau noumeun mu go e ebu uteimai, imai waneun. Yesus go eb ob oug dabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Go en Devit nug eneun, ‘Banou go iz waiab muzmuz dacaneu. Go iz waiab daimai, gusig milaneu. Guzenaimai, ecesab tub nug iz i zilailamau. ");
INSERT INTO bmh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Guzenaimai, izal oiab selina, siksikabun ze mem. Iz abiu iz noumabun iboi, bo, iz ece naliu go wabun gumei darem. ");
INSERT INTO bmh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Einen, na iz utilina, duailel noumemen agal uzan i dai. Nait salau du naliu utemen, ob oug i bilamau. ");
INSERT INTO bmh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Na awau muzmuz dabun abu abai milanem. Na iz ibail damen, go nait amen ebu iz siksikaimai, suban dai.’ ");
INSERT INTO bmh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","O Zaiar, Israel duailel, iz igual embigeg Devit en petak awaramoroi. Go noumina, duailel agen ob oug hemen. Gonugau ob ulis e dareu. ");
INSERT INTO bmh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Go Uwait nugau Ze doimai, awaraneun du go abiu Uwait nug baib moroun. Uwait nug ze gusig mui aureun, ‘Aiu ses nait bagen tub usalamau. Go duailel nagen gumarem sul go nug han gumaramau.’ ");
INSERT INTO bmh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit go aiu ses Uwait nug erunamau go abiu maimai, Kristus koli asamau en guzeneun, ‘Na du go utemen, duailel noumemen agal uzan i damau. Go Uwait nugau Ze awaraneun du, go Uwait nug baib moroun abiu Uwait nug utena, gonugau enib i bilamau.’ ");
INSERT INTO bmh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Guzenaimai, Uwait nug go Yesus asai meun, gonun, petak ig unum igual ameig nug uligaimai, abe maimai, gonugau ze awarem. ");
INSERT INTO bmh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ulis gonugau memeg Uwait nug go wag imai simai, gonugau ebeg naliu eiman hoboi meun dareu. Gonug getal aureun sultal Yesus gonugau Ah Wes moroun. Guzenaimai, ag igul e uligaimai, don. Yesus go nug gonugau Ah Wes ig ebiligeb palauteu. ");
INSERT INTO bmh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Devit go Mesgai wag siabun tam. Bo, go gonugtal eneun, ‘Uwait nug izal Banou aureun, “Na izal ebe naliu eiman hoboi damen, izan nait iwai zaunar zilacaraimai, nait aramebu maremin, nait pinsal damam.” ");
INSERT INTO bmh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Go guze guzeneun, gonun, ag Israel duailel unum ag ze go abe macan, Yesus tutak go agenag a gegeulanau ebu asai mina, noumeun, Uwait nug gonugau wanib Kristus meun, go igual Dubanou Ban tapai moroun dareu.’” ");
INSERT INTO bmh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Duailel ze go doimai, go oiagab eg wina, Pita mui Yesus nugau ze oi aidanemen dudu ipal mui awaremen, “O Zaiger, ig ulis erunamam?” ");
INSERT INTO bmh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","39","Pita nug guzenai awareun, “Ag unum tutak tutak agal igul eg macanemen uteiban, oiagab kekulaiban, Yesus Kristus nugau wanib ebu ze ziwen. Guzenebi, Uwait nug agal igul eg zilagai maraimai, gonugau Ah Wes maramau. Getal Uwait nug gonugau Ah Wes agal geleagar mui emgasag ipal ebuan duailel abai ereg marabun baib meun. Gonug eneun, ‘In duair izan ularai, go izal Ah Wes murai.’” ");
INSERT INTO bmh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita gusig ze asiu awaraimai, eneun, “Ag subantal tapai dacan! Guzenaimai, ag dudu eg abai eg i umamen.” ");
INSERT INTO bmh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Duailel ipal go Pita nugau ze doimai, oiagab petak aimai, ze ziwemen. Ziwas go ebu duailel tausen ainarai (3,000) sag ze ziwemen. ");
INSERT INTO bmh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Duailel agal oiagab petak emenin umkoskos Yesus nugau ze oi aidanemen dudu abai gotulaimai, goagal ze duabun zobu pianemen. Go zaiagar go isanaranemen. Go agal zauan ee zabun gotulanemen. Go Uwait nugau ee han zabun gotulanemen. Go ziwas umkoskos Uwait auranemen. ");
INSERT INTO bmh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uwait nug gonugau ze oi aidanemen dudu goagal ebeagab ebu gugeg ata atai guzenina, duailel unum go uligaimai, uminemenin. ");
INSERT INTO bmh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Duailel goagal oiagab petak emenin sag gotulaimai, goagal esab go zaiagar abai ereg tutak sag. ");
INSERT INTO bmh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Duailel esab asiu mui, goagal em mui go agal esab mui dudu ipal maraimai, aiwag oimai, aiwag go dou maimai, duailel esab tamacag maranemen. ");
INSERT INTO bmh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Go unum oiagab tutak maimai, ziwas umkoskos Uwait esab muranemen zau banou zaueim simai, gotulanemenin. Goagal zaueim beu beu gotulaimai, ee zai zai aidanemenin. Go oiagab petak aimai, oiagab siksikai ee zanem. ");
INSERT INTO bmh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Go umkoskos Uwait nugau wanib ulagwag muranemen. Duailel ipal agen go uligaraimai, goagal oiagab naliu usalaimai, ziwas umkoskos Dubanou Ban nug duailel ipal koli imarena, go duailel oiagab petak emenin abai ereg gotulai daremen. ");
INSERT INTO bmh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ziwas tub ebu umusig, Pita zaug Zon al Uwait aurabun Uwait esab muranemen zau banou zaueim siaporoi. ");
INSERT INTO bmh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Go ebu, zau og tub wanib Naliupet anem ebu dudu agen du tub gonugau arab eg aidabun iborain tam, gamacaimai, go ebu zoi memenin. Du gue anag nug arab eg guzental soligweun. Du go nug ziwas umkoskos duailel esab muramam aimai nugtal awaraneu. ");
INSERT INTO bmh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ziwas go ebu, Pita zaug Zon al Nou Zau go siaporoi aimai, du go nug piaraimai, aiwag murabun en awareun. ");
INSERT INTO bmh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita zaug Zon al go gusig uligaimai, Pita nug aureun, “Na ig peigen!” ");
INSERT INTO bmh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Guzenina, arab eg du go Pita zaug Zon al esab tub milamam aimai piarai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Guzenina, Pita nug aureun, “Iz aiwag tamacag. Iz petak esab tub e mizamoroi. Iz Nasaret uzanan Yesus Kristus nugau gusig ebu aizem, na asaib, aidan!” ");
INSERT INTO bmh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Guzenaimai, Pita nug du go nugau ebeg naliu eiman pataimai, asai mina, pigai du go nugau arab gusig naliu usaleun. ");
INSERT INTO bmh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Go asaimai, tapai aidaneun. Guzenaimai, go ereg Nou Zau sesamarai simai, silik silikaimai, Uwait nugau wanib ulagwag meun. ");
INSERT INTO bmh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Duailel Nou Zau oug daremen go unum du go usai aidaimai, Uwait nugau wanib ulagwag morona, uligemen. ");
INSERT INTO bmh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ag abiu du go getal Nou Zau nugau zau og wanib Naliupet waugab hoboi daimai, duailel esab nugaraneun. Igul go en esilakaimai, dabeleu asiu omenin. ");
INSERT INTO bmh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Du go getal arab eg meun go Pita zaug Zon al waiagab tapai daren, duailel unum esilakaimai, pigai alaimai, empip go wanib Solomon nugau zau nogoug memen go waiagab alai gotulemen. ");
INSERT INTO bmh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita go igul go peimai, duailel awareun, “Israel duailel, ag einen gugeg go uligaimai, go en dabeleu asiu oi daremen? Agal dabeleu igual igul naliu pet, gonun, igual gusig sil gugeg e guzenem aimai gusig peigemen ta? Tam pet tam! ");
INSERT INTO bmh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Igual embigeg agal Uwait mui Abraham, Aisak, Zekop goagal Uwait nug gonugau gusig banou gonugau salau du Yesus morona, gonugau wanib wag pet meun. Du go agenagtal gonugau iwai zaugul agal ebeagab ebu memenin. Pailot nug go utena, unabun aneun, bo agen gonugau ze duab tam. Ag go semoromenin. ");
INSERT INTO bmh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Du go gue Uwait nug palautina, aleun. Go igul naliu mui. Bo, agen go semoromenin. Ag Pailot uloroimai, auremenin, ‘Na du go gonug du tub wina, noumeun utemen, unamau.’ Pailot nug go palautina, waneun. ");
INSERT INTO bmh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Muzmuz awau dabun abu abai maraneu du agen wina, noumeun. Bo, Uwait nug go koli asai meun. Du go dudu agen wina, noumeun koli waseun igual ameig nug uligeun, gonun, ag ulis awarem. ");
INSERT INTO bmh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesus nugau gusig sil du arab eg e kasai meun. Ag du e ulis pemen, go Yesus en ougab petak eun, gonun, du go gusig moroun. Ag go peimai, abe macan. Ig abiu Yesus nugau gusig petak, gusig go eiman du e kasai memun. Ag unum go pemenin. ");
INSERT INTO bmh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","O zaiger, ig abiu ag mui, agal dudu banban mui, gumaranemenin dudu mui, Yesus go in ag i abiu, gonun, ag go guzenemenin. ");
INSERT INTO bmh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Uwait nug getal igul go en gonugau ze doimai, awaranemen dudu goagal oiagsau ebu enemenin, ‘Kristus go mu banou umau.’ Ze go anemen petak usaleun. ");
INSERT INTO bmh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Guzenaimai, ag agal dabeleu mui igul eg mui uteimai, agal oiagab Uwait en kekulan. Ag guzenebi, go nug agal igul eg zilaigai maramau. ");
INSERT INTO bmh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ag igul go guzenebi, Uwait nug ag gusig awau maramau. Gonug Kristus palautaba, ag waiagab alamau. Du go getal Uwait nug tapai meun gonugau wanib Yesus. ");
INSERT INTO bmh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ulis go Mesgai wag koli sieun dareu. Go ziwas go Uwait nug esab unum koli awau tapai mabun gumei dareu. Go gonugau ze getal gonugau ze doimai, awaranemen dudu awarina, goagen duailel awaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses nug goen guzeneun, ‘Uwait Banou nug iz palautileun sul aiu ses gonugau ze doimai, awaraneu du tutak palautamau. Du go agal zaiag pet. Ag gonug ze awaraba doiban, gonugau ze unum sesamoran. ");
INSERT INTO bmh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Duair in go Uwait nugau ze doimai, awaraneu du nugau ze sesamorab tam aba, go Uwait nugau duailel abai i damau. Go Uwait nug eg muramau.’ ");
INSERT INTO bmh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","25","Uwait nug getal Abraham al baib pataimai, eneun, ‘Nait ug eiman em e ebuan duailel suban dabun gusig marai.’ Gonug gonugau ze doimai, awaranemen dudu abai baib meun. Gonugau ze doimai awaranemen dudu getal zomenin Samuel dai betei ulis zomenin, goagen han igul go ulis zou en anemenin. Guzenaimai, ulis baib go petak zoun, agenagtal pemenin. ");
INSERT INTO bmh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Guzenaimai, Uwait nug gonugau salau du ag tutak tutak suban dabun mui igul eg ebuan kekulan aimai, awarabun tapai maimai, amegai ag Israel duailel waiagab palautina, aleun.” ");
INSERT INTO bmh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita zaug Zon al duailel ze awarina, ipal Uwait nugau ula dacanemen dudu mui Uwait esab muranemen zau gumacanemen dudu banou mui, ipal Sadiusi dudu han ereg go waiagab alemen. ");
INSERT INTO bmh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pita zaug Zon al Uwait nug Yesus noumeun, koli asai meun, awau dareu aimai, duailel awaremenin. Go ze go doimai, aiag silanina zomenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Guzenaimai, dudu go agen Pita zaug Zon dual ze piabun gusig patemenin. Bo, go umusig pet mina, uligaimai, hiacaranem zau oug hiacaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bo, duailel asiu go ebu daremen goagal ze doimai, goagal oiagab petak emen. Duailel goagal oiagab petak emen go tausen tabkwai sag usalemen. ");
INSERT INTO bmh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Umaseu, Zuda duailel, dudu banban mui, gumaranemenin dudu banban mui, kasai ze tapaimaranemen dudu mui, go Zerusalem ban uzan alai gotulemenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dudu go beteimai, Uwait ula dacaneu du banou pet, wanib Anas, Kaiapas, Zon, Aleksanda mui, Anas nugau ug ipal abai gotulemenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Zon zaug Pita dual goagal ameagab ebu zoi taparai maimai, kanabaremenin, “Du arab eg go erunai kasorona, em tapai waneu? Ag ein gusig sil igul go guzenemenin? Ag in nugau wanib ebu guzenemenin?” ");
INSERT INTO bmh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Pita go Uwait nugau Ah Wes nug gusig morona, dudu go awareun, “Ag duailel gumaranemenin dudu banban, ag ulis ig du arab eg kasai memun en kanabigemen. Ag erunai du e naliu usaleun aimai kanabigemen. ");
INSERT INTO bmh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Guzenaimai, ag unum Israel duailel abai abe mamamen, Yesus Kristus, Nasaret uzanan gonugau gusig sil du go nugau arab kaseun. Guzenina, go ulis ag ameagab ebu tapai dareu. Agen du go a gegeulanau ebu wemenin. Go noumina, Uwait nug go koli ob ougan asai meun. ");
INSERT INTO bmh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus go en getal Uwait nugau ze eim enemenin, ‘Zau sanag go zau macanemen dudu agen eg anemenin, ulis zau sanag go naliu pet usaleun.’ ");
INSERT INTO bmh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Go nug tutak ag imarabun iboin. Gonugau wanib tutak gusig mui. Duailel gonugau wanib ebu ulebi, imaramau. Du tub nug em e ebuan imaigabun iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dudu banban go Pita zaug Zon al agen ze gusig marena, uminab tam, uligaraimai, dabeleu asiu omenin. Ag abiu dudu aliag go abiu asiu unab tam, go uzanan dudu sag. Guzenaimai, ag abiu zaug al go getal Yesus sesamorai aidanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Du go gonugau arab naliu usaleun go zaug dual abai tapai dareun pemenin, gonun, go ze tub marabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Guzenaimai, goagen zauan palautarena, uzaneim nuna, agzozou ze guzenai patemen, “Ig du aliag go erunarab? Zerusalem uzanan duailel go unum gugeg goagen guzenina abe memenin, ig wage mabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bo, gugeg go emgasag ebuan duailel awarebi, dumam, gonun, ig du aliag go Yesus nugau wanib ebu duailel ipal i abai marabun aimai gusig awaramam.” ");
INSERT INTO bmh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Guzenaimai, dudu banban agen Zon zaug Pita dual koli ularena, zaueim sina, gusig awaremenin, “Ag koli koli Yesus nugau wanib ebu duailel ipal ze i awaran.” ");
INSERT INTO bmh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita zaug Zon al koli awaremenin, “Ag agtal agal ze sisian. Uwait nugau dabeleu erun neneg, ig agal ze sesamoramam ta, Uwait nugau Ze sesamoramam? Go agtal dabilan. ");
INSERT INTO bmh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ig igul go igual ameig nug unum uligaimai, domun, gonun, gonugau ze i utamam. Ig duailel unum awaramam.” ");
INSERT INTO bmh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Guzenaimai, dudu banban agen kolital Yesus nugau ze duailel awarebi, ugarabun en, ze gusig awaraimai, utarina, wanemenin. Du gonugau arab eg kasai memen, gonugau wai 40 sag zilaoroun. Duailel unum uligaimai, Uwait nugau wanib ulagwag moromai, Uwait nug gugeg go guzeneun en agal oiagab petak emenin. Guzenaimai, dudu banban go duailel uminaraimai, go du aliag go gusig awarabun abu tamacag. ");
INSERT INTO bmh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Dudu banban agen Pita zaug Zon al palautarena, wanena, go koli goagal zaiagar goagal zaueim gotulai daremen ebu betemenin. Go dudu banban agen ze go unum awaremen goageban betei, zaiagar awaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Go ze go doimai, go unum oiagab tutak maimai, gotulaimai, Uwait guzenai auremenin, “O Uwait Banou, em mui, emes mui, ibut ze mui, ece unum nagen zemina, usaleun. ");
INSERT INTO bmh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Getal nait Ah Wes igual embigeg, nait salau du Devit nugau ogusau eiman guzeneun, ‘Emgasag ipal ebuan duailel einen aiag silanina zoi darem? Duailel go einen goagal dabeleu beu beu oi darem? ");
INSERT INTO bmh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Em e ebuan du banban ag agal malai mabun esab suban maimai, Uwait Banou mui gonugau nag ig imaigabun tapai meun Kristus al iwaimabun guzenemen.’ ");
INSERT INTO bmh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Petak pet, Herot mui, Pontias-Pailot mui, emgasag ipal ebuan duailel mui, Israel duailel go abai ereg Zerusalem ban uzan gotulaimai, Yesus, nait salau du nugau wanib tonoi mabun guzenemenin. Nagtal go tapai memen. ");
INSERT INTO bmh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Go salau unum, getal nagtal nait gusig dabeleu ebu tapai memen, petak zuabun sesamoremenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Banou, na ulis dudu go agen ze eg ig ebiligeb mai darem don! Ig nait salau duailel en dabeleu oimai, isanigemen, ig nait ze duailel gusig maraimai, i uminamam. ");
INSERT INTO bmh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na nait eben ebeu duailel ebu memen, go koli naliu damam. Na nait salau mogoi naliu Yesus nugau wanib ebu gugeg beu beu men.” ");
INSERT INTO bmh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Go Uwait aurai maziaimai, zaueim go darena, mim sul zoun. Guzenaimai, duailel go unum Uwait nugau Ah Wes nug gusig marena, Uwait nugau Ze ze maimai, uminab tam. ");
INSERT INTO bmh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Dudu goagal oiagab Yesus en petak emen go unum oiagab tutak maimai, dabeleu tutak memenin. Du tub nugau esab gonugau sag aimai anab tam. Ein esab tub nugau unum gotularaimai, ereg wanemen. ");
INSERT INTO bmh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yesus nugau ze oi aidanemen dudu go Yesus Kristus noumaimai, koli waseun en gusig ze maimai, uminab tam. Guzenina, Uwait nug gonugau ougab naliu mui eiman go isanarena, go suban daremenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ziwas go ebu, du tub go esab tub en tamacag dab tam. Duailel ipal agen goagal em inain, zau inain, dudu ipal marena, go ebuan aiwag omenin. ");
INSERT INTO bmh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Go aiwag oi alaimai, goagen Yesus nugau ze oi aidanemen dudu alai marena, goagen han aiwag go doumaraimai, goagal zaiagar ecesab tamacag dueneg maremen. ");
INSERT INTO bmh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ziwas go ebu, du tub gonugau wanib Zosep go Liwai nugau ug ebuan go Saiprus em waug uzanan du dareun. Yesus nugau ze oi aidanemen dudu agen Barnabas auranem. Zebigeg go wanib, dudu agal oiagab selai dabun ze maraneu du. ");
INSERT INTO bmh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Go han gonugau em ginampet tub du tub morona, gau meun. Go em ebuan aiwag oimai, Yesus nugau ze oi aidanemen dudu alai mareun. ");
INSERT INTO bmh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Bo, du tub gonugau wanib Ananaias, gonugau wau nugau wanib Sapiria al dareun. Goagal em dudu ipal maraimai, aiwag omen. ");
INSERT INTO bmh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Gonugau wau al ze pataimai, aiwag ipal goagal zaueim wageimai memen. Go polumaimai, goagal aiwag unum oi alemen mabun aimai, aiwag oi betei Yesus nugau ze oi aidanemen dudu maremen. ");
INSERT INTO bmh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Guzenaimai, Pita igul go guzenemenin abe maimai, Ananaias aureun, “Na Satan einen utena, nait dabeleu unum gumena, Uwait nugau Ah Wes polumorona go em ebuan aiwag ipal wagemaimai, ipal oi alem? ");
INSERT INTO bmh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Go em getal dudu ipal agen gau mab tam ebu go em nait. Ulis dudu ipal go em maremen gau maimai, aiwag mizemen go nait aiwag. Na ein dabeleu oimai, igul eg go guzenem? Na du polumorab tam, na Uwait polumorom.” ");
INSERT INTO bmh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias ze go doimai, em nogoug ebu alai noimai, noumeun. Duailel go go ebu daremen ze go doimai, esilakaimai, banban uminemenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Guzenina, silin dudu ipal agen zoimai, go noumeun du tibur galau sil kulai maimai, gamai beteimai, ob oug hemen. ");
INSERT INTO bmh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ginam dai daimai, Ananaias nugau wau Sapiria go igul go guzeneun i abiu, zaueim zoun. ");
INSERT INTO bmh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita nug air go aiwag abai moroimai, kanabeun, “Na iz ailen, ag gamut al agal em ebuan aiwag omen e sag ta?” Air gonug aureun, “Io, aiwag em ebuan omun go sag.” ");
INSERT INTO bmh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Guzenina, Pita nug koli aureun, “Na einen gamut al ze pataimai, Uwait nugau Ah Wes polumoromen? Dudu go nait gamut gamai betei ob oug hemen sul, ulis na noumemen, na han imaiz betei, ob oug heizabun zau og ebu tapai darem.” ");
INSERT INTO bmh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pita nug guzenina, pigai air go gonugau arabugab alai noimai, noumeun. Dudu go zaueim zoimai, air noumeun uligaimai, gonugau enib gamacaimai, betei gonugau gamu ob oug hemen waugab betei ob oug hemenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Guzenaimai, duailel oiagab petak emen mui uzanan duailel go mui unum igul go guzenemen doimai, esilakaimai, banban pet uminemenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesus nugau ze oi aidanemen dudu agen duailel agal ameagab ebu gugeg ata atai guzenemenin. Duailel agal oiagab Yesus en petak emen oiagab tutak maimai, alai getal Solomon nugau hoboi dacaneun zau gotulemenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Duailel ipal agen go agal salau uligaimai, goagal wanimag wag macanemen, bo, goagen go abai ereg gotulabun uminemenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bo, duailel asiu pet goagal oiagab Dubanou Ban en petak emen, go abai ereg alai gotulemenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Guzenina, duailel agen duailel ipal ebeu mui biz ebu imarai alai abu ebu gabuarai memenin. Goagal dabeleu, am zuba, Pita bitaba, gonugau ilwal nug ebeu duailel ipal ebalagab nuba, go naliu usalabun aimai guzenemenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Guzenaimai, duailel asiu Zerusalem ban uzan waugab an goagal zaiagar ebeu mui abai duailel wes eg mui imarai zuna, go naliu usalemen. ");
INSERT INTO bmh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Guzenaimai, Uwait ula dacaneu du banou pet gonugau salau zaugul abai ereg daremen, go unum Sadiusi dudu. Go Yesus nugau ze oi aidanemen dudu en aiag sisilina, eg marabun dabilemen. ");
INSERT INTO bmh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Guzenaimai, goagal malai dudu agen Yesus nugau ze oi aidanemen dudu gusig pataraimai, hiacaranem zau oug dudu gaul ipal hiacaremen ebu ereg betei hiacaremen. ");
INSERT INTO bmh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Bo, umaum go Uwait nugau tibur tub zoimai, go hiacaranem zau og oitaimai, Uwait nugau ze oi aidanemen dudu imarai, uzaneim noimai, awareun, “Ag Nou zaueim beteiban, go ebuan duailel awau muzmuz dabun ze awaran.” ");
INSERT INTO bmh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yesus nugau ze oi aidanemen dudu ze go sesamoraimai, em ilai ina, Nou zaueim simai, go ebu duailel Uwait nugau Ze marai daremenin. Uwait ula dacaneu du banou pet nug gonugau salau zaugul mui Zuda agal dudu banban mui ularena, alai ereg gotulemenin. Ze tutak pataimai, goagal malai dudu agen Yesus nugau ze oi aidanemen dudu hiacaranem zauan go waiagab imarai alabun palautaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Guzenaimai, malai dudu gue dudu go hiacaranem zauan imarabun betemenin. Go zaueim simai dudu go piarab tam, gonun, koli beteimai, dudu banban awaremen, “Ig hiacaranem zau oug beteimai, im gusig tapelemen pemun. Go hiacaranem zau gumemen dudu go zau gusig gumei daremen piaremun. Bo, ig im oitai, zaueim simai, dudu go piarab tam.” ");
INSERT INTO bmh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uwait ula dacanemen dudu banban mui, Nou Zau gumaranem dudu agal du banou go ze go doimai, Uwait nugau Ze oi aidanemen dudu ein erunarab aimai dabeleu asiu omenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Guze guzenina, du tub nug zoimai, awareun, “Ag don, dudu go agen hiacaranem zau oug hiacaremenin, go beteimai, igual Nou Zaueim Uwait nugau Ze duailel marai darem.” ");
INSERT INTO bmh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Guzenai awarina, Nou Zau gumaneun du banou nug gonugau malai dudu mui goagen Yesus nugau ze oi aidanemen dudu betei imarai alemen. Bo, duailel agen go aiwag sil ugaramam aimai uminaraimai, go ugarab tam, go gaul imarai alemen. ");
INSERT INTO bmh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Goagen imarai alaimai, dudu banban agal ameagab ebu taparai mina, Uwait ula dacanemen dudu goagal banou nug kanabareun. ");
INSERT INTO bmh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ig ag du gonugau wanib duailel koli i awarabun en gusig awaremun, bo, ag igual ze sesamorab tam. Agal ze nug Zerusalem ban uzan unum iboreun. Guzenaimai, goagen enemen, iguan du go wemun, noumeun emen aimai agen ze go polu migemen.” ");
INSERT INTO bmh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita mui Yesus nugau ze oi aidanemen dudu ipal agen koli enemen, “Ig Uwait nugau Ze tutak sesamoramam. Ig dudu agal ze i sesamoramam. ");
INSERT INTO bmh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Agen Yesus a gegeulanau ebu asai mina, noumeun. Igual embigeg agal Uwait nug Yesus go noumemen dudu agal empip ebuan koli asai meun. ");
INSERT INTO bmh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uwait nug go imai aimai, wag simai, gonugau ebeg naliu eiman meun. Yesus go ulis igual gumigabun du go igual igul eg ebuan imaigabun koli asai meun. Ig, Israel duailel, igual oigeb kekulina, go igual igul eg ebuan zilagai migabun guzeneun. ");
INSERT INTO bmh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Igul go guzeneun ig igual ameig nug pemun, gonun, ze e marai darem. Uwait nugau Ah Wes nug han ze e aneu. Inen duair Uwait nugau Ze suban sesamoraneu Uwait nug gonugau Ah Wes maraneu.” ");
INSERT INTO bmh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Duailel banban ze go doimai, go ag oiagab zabeg zuna, dudu go apiparebi, noumamam aimai dabilemenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","35","Guzenina, Parisi du banou tub gonugau wanib Gamaliel, go han kasai ze tapaimaraneu du banou go ebu dacaneu, duailel ipal go gonugau ze suban sesamoranem. Gonug du banban ameagab ebu asaimai, Yesus nugau ze oi aidanemen dudu go uzaneim imarai nuabun awareun. Uzaneim imarai noimai, go nug awareun, “O zaiar, Israel dudu, ag ein igul dudu e ebalagab guzenabun, ag suban dabileiban, guzenan. ");
INSERT INTO bmh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ag abiu, wai asiu tam ebu, du tub gonugau wanib Teudas nug zoimai, iz sag du banou aimai, nugtal gonugau wanib ulagwag mai awaraneu. Guzenina, dudu handret iwanarai sag go sesamoremenin. Dudu ipal goagen wai mina, noumina, gonugau sesamoranemen dudu go unum uminai beu beu wanemen. Gonugau salau unum noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Dai dai, dudu banban agen duailel agal wanimag agau banou ebu wabun ziwas, du tub gonugau wanib Zudas, go Galili agaig ebuan zuna, duailel asiu go uligaimai, sesamoremenin. Go han dudu agen wai hina, noumina, gonugau sesamoranem dudu go han unum uminai beu beu wanemen. ");
INSERT INTO bmh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Guzenaimai, iz gonun ag awarem, ag dudu go en oiagab zabeg pigai i mamau. Goagal ein igul guzenanem dudu goagal dabeleu nug go abai ban i damau, dai dai, tamamau, gonun, utarebiag, damam. Utaraiban, piarai dacan. ");
INSERT INTO bmh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bo, dabeleu go Uwait nug eiman aleun aba ig tapelabun iborain tam. Ig igul go guzenamam, go ig Uwait al iwai mamam.” ");
INSERT INTO bmh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dudu banban go Gamaliel nugau dabeleu naliu mareun doimai, sesamoremenin. Guzenaimai, goagen gonugau ze sesamoraimai, Yesus nugau ze oi aidanemen dudu ularena, zuna, us kulam sil esalau sul ugaraimai, go Yesus nugau wanib koli duailel i awarabun en gusig awaraimai, utarina, wanemen. ");
INSERT INTO bmh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Guzenina, Yesus nugau ze oi aidanemen dudu, go dudu banban utaraimai, uzaneim noimai, oiagab banban siksikemen. Einen, Uwait go dabeleun go iboi Yesus nugau wanib ebu mu omenin. ");
INSERT INTO bmh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Gil umkoskos, go Uwait esab muranemen zau banou zaueim mui, duailel agal zau beu beu beteimai, goagen Yesus Kristus nugau Ze Naliu duailel abai maranemen. ");
INSERT INTO bmh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ziwas go ebu, dudu asiu Yesus en goagal oiagab petak aimai, Zuda dudu ipal Grik ze macanemen agen Zuda dudu go Hibru ze macanemen aiagsisilaimai, awaremen, “Ziwas umkoskos ag agal wab ailel isanaranemen. Bo, ag igual wab ailel i isanaranemen.” ");
INSERT INTO bmh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Guzenina, Yesus nugau ze oi aidanemen dudu agen, dudu go agal oiagab Yesus en petak emen unum ularena, alai gotulina, awaremen, “Ig Uwait nugau Ze duailel awarabun salau uteimai, duailel umkoskos ee marabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Guzenai, gonun, agtal igual zaiger kwali sag ag ula tapai maran. Dudu go Uwait nugau Ah Wes mui, dabeleu naliu mui, tapai maran. Salau go dudu go ebalagab marebi, salau goagen mamam. ");
INSERT INTO bmh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Igua ziwas umkoskos Uwait auraimai, gonugau ze duailel awarai aidamam.” ");
INSERT INTO bmh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Duailel goagal oiagab petak emen goagal ze doimai, siksikaimai, goagen dudu guzenai tapai maremen: Stiven, gonugau ougab petak pet eun, Uwait nugau Ah Wes nug gonugau dabeleu unum gumaneun, Pilip, Prokorus, Nikanor, Timon, Parmenas, Nikolas. Go Nikolas go emgasag tub ebuan du, Antiok uzanan, getal gonugau ougab kekulaimai, Uwait nugau Ze sesamoraimai, alai Zuda duailel abai wanib oun. ");
INSERT INTO bmh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dudu go kwali sag tapai maremen go Yesus nugau ze oi aidanemen dudu goagal ameagab ebu zoi taparai maremenin. Guzenina, goagen Uwait auraimai, salau gusig mabun goagal ebeag dudu go agal tabaiag patemenin. ");
INSERT INTO bmh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Guzenaimai, Uwait nugau Ze Zerusalem uzan unum oi betemen. Duailel asiu uzan go daremen goagal oiagab Yesus en petak aimai, go sesamoremenin. Uwait ula dacanemen dudu ipal asiu go han goagal oiagab Yesus en petak emenin. ");
INSERT INTO bmh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Du go Stiven, Uwait nug gonugau ougab naliu mui eiman go isanoroimai, gusig morona, go nug duailel ameagab ebu gugeg beu beu mina, pemenin. ");
INSERT INTO bmh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bo, Zuda dudu ipal agen igul go peimai, aiag sisilina, go al ze ze eim alalinar. Dudu go goagal zaueim beu gotulanemen. Goagal gotulanemen zau wanib Salau Dudu Tam agal zau anem. (Zebigeg go wanib, dudu go getal salau dudu (slev) dacanemen, ulis salau go utemenin.) Ipal go Sairini uzanan, ipal Aleksandria uzanan, ipal Silisia em ebuan, ipal Esia agaig ebuan duailel go ebu gotulanemen. ");
INSERT INTO bmh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Uwait nugau Ah Wes nug Stiven dabeleu naliu morona, du tub nug gonugau ze zilaurabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Guzenaimai, goagen gonugau wanib ebu ze polumai, dudu ipal aiwag maraimai, goagal oiagab asai maraimai, awaremen, “Petak pet, go nug Moses Uwait al ze biabial kuai duailel awareun domun.” ");
INSERT INTO bmh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Guzenaimai, go polu ze doimai, duailel uzanan mui, dudu banban mui kasai ze tapaimaranemen dudu go aiag sisilina, Stiven betei gusig pataimai, dudu banban ameagab ebu suoroi betemen. ");
INSERT INTO bmh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Guzenaimai, dudu ipal go enib ebu polu ze mabun ereg sesamarai beteimai, enemen, “Du e go umkoskos Uwait esab muranemen zau banou mui, Moses nugau kasai ze eg i sesamorab aimai duailel awaraneu.” ");
INSERT INTO bmh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gonug eneun, “Go Nasaret uzanan Yesus nug igual Nou Zau banou tub tigalamau. Gonug igual igul Moses nug abai migeun uteiban, igul awau sesamoran awareun.” Gonug guzenina, domun. ");
INSERT INTO bmh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dudu banban go ebu daremen goagen Stiven gusig pemen, gonugau siameg Uwait nugau tibur nugau siameg am ilaneu sul eleun pemenin. ");
INSERT INTO bmh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Guzenaimai, Uwait ula dacaneu du banou pet nug goagal ze doimai, Stiven kanabeun, “Ze go anem petak ta?” ");
INSERT INTO bmh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Stiven nug koli eneun, “O zaiar, mekaite, ag don! Getal igual emginib zaicig Abraham go Haran emgasag i bitau ebu, Uwait go al gusig mui eiman Mesapotemia emgasag go waugab zoimai, aureun, ‘Na nait em mui nait zaunar mui utaraiba, em tub na abai mizamoroi go ebu beten.’ ");
INSERT INTO bmh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Guzenina, Abraham go Mesapotemia emgasag uteimai, Haran emgasag ebu betei dareun. Emgasag go betei daren daren, gonugau memeg noumina, Uwait nug palautina, em e ig ulis darem ebu alai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Uwait nug Abraham em tub gonugau pet usalabun murab tam. Tam pet tam. Go em ginampet tub han murab tam. Bo, Uwait nug go em e en dual baib maimai, aureun, ‘Aiu ses na noumemen, nait asanar em e marai.’ Ziwas go ebu Abraham go nag tamacag darena, Uwait nug go dual baib meun. ");
INSERT INTO bmh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Uwait nug guzenai aureun, ‘Nait asanar go emgasag ipal ebu betei damam. Go em ebu betei damam go agal em pet tam. Guzenina, emgasag tub ebuan dudu agen nait ug wai handret ainarai sag salau dudu (slev) sul usalai maraimai, eg maramam. ");
INSERT INTO bmh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bo, aiu ses izan emgasag go ebuan duailel eg maremin, go koli em e ebu alaimai, izal wanim ulapwag milamam.’ ");
INSERT INTO bmh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Guzenaimai Uwait nug baib awau wanib enimag galau kuatabun’ Abraham aureun. Uwait nug guzenai aurina, Abraham nugau nag Aisak usalina, gil 8 ebu nag nugau enib galau kuateun. Dai dai, Aisak nugau nag Zekop usaleun. Mogoi go gue igual bageiger begurug sag agal memeag. ");
INSERT INTO bmh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Zekop nugau gelegul, igual emginib zaiger agen goagal amanag Zosep en aiag sisilina, emgasag ipal ebuan dudu aiwag en marena, goagen gau mina, aiwag omenin. Dudu go goagen Izip emgasag imai betemenin. Bo, Uwait go Zosep utab tam. Go al ereg daimai, go isanoroimai, gonugau uhu unum zilagai moroun. Zosep go Izip agal gumaraneun du banou al dacaneu ziwas ebu, Uwait nug dabeleu naliu moroun. Gumaraneun du nug Zosep du naliu uligaimai, go nug Zosep emgasag go mui gonugau zauan esab mui gumabun salau moroun. ");
INSERT INTO bmh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Guzenaimai, ziwas go ebu Izip emgasag mui Kenan emgasag mui ze nuab tam, gonun, wen ziwas mina, duailel go uhu banou omen. Igual embigeg ee wabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Zekop nug ee Izip emgasag dareu ze doimai, gonugau gelegul bigegwai palautarena, Izip emgasag ee gau mabun betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ee go mazicina, go koli ee wabun Izip emgasag betena, Zosep nug gonugau apagul guzenai awaranar, ‘Iz Zosep, agal amanag.’ Guzenina, Izip gumaraneun du go Zosep nugau ug abe mareun. ");
INSERT INTO bmh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Guzenaimai, Zosep gonugau apagul palautarena, betei gonugau memeg Zekop mui gonugau ug 75 sag alai go al Izip emgasag dabun ze palauteun. ");
INSERT INTO bmh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Guzenina, Zekop gonugau ug mui Izip emgasag betei daimai, nug mui igual embigeg begurug abai unum noumemenin. ");
INSERT INTO bmh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Guzenaimai, dudu ipal goagal enimag koli imarai alai, Sekem uzan getal go em Abraham nug Hamor nugau ug ebuan gau meun ebu alai ob oug hiacaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Getal Uwait nug Abraham al go emgasag utei unabun baib moroun, baib go petak zuabun ziwas waugab zuna zuna, igual embigeg go Izip emgasag ebu daremen goagal ug asiu usalemen. ");
INSERT INTO bmh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Guzenaimai, ziwas go ebu du tub Izip agal gumaraneun du usaleun. Du go gue Zosep nugau wanib i abiu. ");
INSERT INTO bmh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Du banou gonug igual emginib zaiger polumaraimai, igul eg maraimai, goagal geleagar uzaneim oi amarina, noumamam aimai, ze gusig mareun. ");
INSERT INTO bmh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ziwas go ebu, Moses usaleun. Mogoi go pemen gonugau siameg naliu pet. Guzenaimai, memeg anag dual agen goagal naiag goagal zaueim wageimai mina, geil ainarai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dai dai, go uzaneim imai noi mina, gumaraneun du nugau aleg nug imai aimai, gonugau nag sul gumeun. ");
INSERT INTO bmh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Dudu agen Moses Izip agal igul naliu unum abai moromen. Go wanib banou mui usaleun. Ein salau mabun mui ze marabun mui go iboin. ");
INSERT INTO bmh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses go wai houhou iwanarai (40) sag usalina, gonugau atagul Israel duailel erunai salau mai darem aimai betei, piarabun en dabeleun. ");
INSERT INTO bmh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ziwas tub ebu, go Izip du tub nug Israel du tub waimai, eg moroun, uligaimai, go nug Israel du isanoroimai, go Izip du wina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses nugau dabeleu go gonugau atagul guzenai dabilamam, ‘Uwait go Moses nugau ebeg eiman ig isanigamoroi.’ Bo, go guzenai dabelab tam. ");
INSERT INTO bmh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kolital ziwas tub ebu, Moses Israel du tub gonugau zaug al agzozou alalai darena piareun. Go alalai darena betei malai kuataimai, awareun, ‘Ei, ag einen zaun dual agzozou alalemen?’ ");
INSERT INTO bmh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Zaug eg moroi dareun du nug Moses suor aimai, aureun, ‘Na in nug ig gumigaimai, sisicigabun du tapai mizeun? ");
INSERT INTO bmh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Um nagen Izip du tub wai hina, noumeun sul, ulis han iz iwamoroi ta?’ ");
INSERT INTO bmh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses go ze go doimai, gonugau dabeleu Izip agal du banou ze go doimai, gusig patilaimai, iwebi, noumai aimai, go uminai Midian emgasag beteun. Go ebu betei, go gelegul aliag patarai meun. ");
INSERT INTO bmh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Wai houhou iwanarai (40) sag mazicina, Sainai em tabag waugab, du tamacag dareun em, Uwait gonugau tibur tub nug Moses waugab zoun. Tibur go gai ginampet. nogoug ebu ab al oug dareun go peun. ");
INSERT INTO bmh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses gue igul go usalina, peimai, dabeleu asiu oimai, suban piabun waugab betena, Uwait nug guzenai aurina doun. ");
INSERT INTO bmh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Uwait nug eneun, ‘Iz Uwait nait embigeg agal Uwait. Abraham, Aisak, Zekop iz agal Uwait.’ ");
INSERT INTO bmh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Guzenina, Banou nug aureun, ‘Na nait aram ebuan aram galau oi moiten. Einen, go empip na tapai darem go em nou pet. ");
INSERT INTO bmh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Izip emgasag ebuan dudu agen izal duailel ebalagab igul eg maremen iz uligaimai, ag isanarabun weinemen domin. Iz ulis go uhu ebuan imarabun em. Guzenaimai, ulis iz na Izip emgasag koli palautizemin, bitamam.’ ");
INSERT INTO bmh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Getal Israel duailel agen auremen, ‘Na in nug ig gumigaimai, sisicigabun du tapai mizeun?’ Moses goagal ze doimai, uminaimai waneun. Ulis gotal Uwait nugtal dudu go gumarabun palautina, betei koli imarai alabun du tapai moroun. Uwait go gue tibur gai ginampet nogoug ebu usaleun gonugau ebeg eiman Moses gusig moroun. ");
INSERT INTO bmh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Guzenaimai, Moses nug Israel duailel imarai alaimai, gugeg beu beu Izip emgasag ebu gugeg maimai, betei, ibut ze es a ebu gugeg guzenaimai, betei, du tamacag uzan guzenaital guzeneun. Wai 40 go guzeneun. ");
INSERT INTO bmh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Go Moses gotal Israel duailel awareun, ‘Uwait Banou nug iz palautileun sul aiu ses gonugau ze doimai, awaraneun du tub palautamau. Du go agal baib icanag pet.’ ");
INSERT INTO bmh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Du go Moses gotal duailel abai ereg du tamacag uzan gotularai dareun. Go Sainai em tabag ebu Uwait nugau tibur nug naliu dabun ze aurina, Moses nug igual embigeg ze go awareun. ");
INSERT INTO bmh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Bo, igual embigeg go gonugau ze duabun utemen. Goagal oiagab kekulaimai, Izip emgasag dabun koli dabilemenin. ");
INSERT INTO bmh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Guzenaimai, duailel agen Aron auremen, ‘Na ig Uwait tub patai migemen, amegai ig ibaig bitamau. Moses go ig Izip emgasag ebuan imaigei aleun, go eru eiman waneun, ig i abiu.’ ");
INSERT INTO bmh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ziwas go ebutal, go bulumakau nag nugau dorog patai maimai, go polu Uwait go ebu egun agaimai, gonugau wanib ulagwag moromen. Go esab goagal ebeag siltal patai maimai, goagal oiagab siksikemenin. ");
INSERT INTO bmh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Guzenina, Uwait nug go semareun. Go am, geil mui, ureb mui goagal wanimag ebu zobu pianemen. Uwait nugau Ze doimai, awaraneun du, Amos nug guzenaital sikut weun, “Uwait nug guzeneun, ‘Ag Israel duailel ag getal wai houhou iwanarai sag du tamacag uzan daremen, ag bulumakau mui sipsip mui waimai, agaimai, zobu peimai, ag izal wanim ulapwag murab tam. ");
INSERT INTO bmh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ag Molek nugau zobu zau salap mui agal wes Repan nugau ureb dorog mui ag gamai betemenin. Esab go dorog getal agen patai maimai, goagal wanimag wag maremenin. Ag guzenemen, gonun, iz ag utaraimai, palautaremin, Babilon emgasag ebu betei damamen.’ ");
INSERT INTO bmh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Getal igual embigeg go du tamacag uzan daremen, goagal zobu zau salap memen. Uwait nug Moses go salap zau gonugau dorog abai morona, peun. Uwait nug go zau guzenai menen aimai aureun. ");
INSERT INTO bmh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Dai dai, go Uwait nugau salap zau silin dudu agen oimai, gamacaimai, Zosua, duailel ipal abai Uwait nug isanaraimai, em go ebuan duailel zamarina, go em go oimai, salap zau go memenin. Igual embigeg agen em go ebu goagal zobu zau salap zau oi alai mina, dareun, betei Devit usaleun ziwas ebu. ");
INSERT INTO bmh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Uwait nug Devit nugau igul naliu uligaimai, go ougab naliu usaleun. Devit nug Uwait aureun, ‘Getal Zekop nug na ulapwag mizaneun. Ulis iz zobu zau tub gusig mizabun aimai aizem.’ ");
INSERT INTO bmh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bo, Uwait nug i mamam aurina, gonugau nag Solomon nug zobu zau go mai moroun. ");
INSERT INTO bmh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","49","Bo, Uwait Banou go duailel agen zau macanem zaueim i dacaneu. Uwait nugau ze doimai, awaraneu du Aisaia nug sikut weun, ‘Banou nug guzeneun, “Mesgai wag go izal hubabun biz. Em go izal aram mai dacanemin empip. Izal zau eruneneg sul milamamen? Izal imabun uzan eru ebu dareu? ");
INSERT INTO bmh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Izal ebesil ecesab go unum patai memin.” ’ ");
INSERT INTO bmh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","O, ulisan duailel, ag agal asanagar dacanemen sul. Agal oiagab dudu go ag Uwait nugau Ze petak i duacanemen sul, ag han gonugau ze i duanemen. Ag agal asanagar sul. Ag Uwait nugau Ah Wes nugau ze i sesamoranemen. ");
INSERT INTO bmh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Agal embigeg agen Uwait nugau ze doimai, awaranemen dudu unum wagarina, noumemenin. Ag dudu go Uwait nugau salau du naliu aleu emen han ugarina, noumemenin. Ulis han, agen salau du naliu go gonugau iwai zaugul agal ebeagab ebu marena, wina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Getal Uwait nugau tibur agen ag Zuda duailel Uwait nugau kasai ze maremen, bo, ag go sesamorab tam.” ");
INSERT INTO bmh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Go ze go doimai, aiag mutitaimai, Stiven en aiag sisileun. ");
INSERT INTO bmh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bo, Uwait nugau Ah Wes nug Stiven go gusig morona, go Mesgai wag gusig ameitaimai, Uwait nugau al gusig banou mui, Yesus go Uwait nugau ebeg naliu eiman tapai dareun, go peun. ");
INSERT INTO bmh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Go peimai, eneun, “Ag go don, Mesgai wag iz Du Nugau Nag nug Uwait nugau ebeg naliu eiman tapai dareu pem.” ");
INSERT INTO bmh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Guzenina, goagal ebeag sil dabuiag gebei maimai, go koli gusig ulaimai, unum asaimai, pigai betei Stiven gusig patemen. ");
INSERT INTO bmh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Go empip go ebuan patai keuai noi uzan gasageim oi amacina, nuna, go aiwag sil wemenin. Stiven wabun dudu agen goagal tibur galau huia oi aimai, du tub wanib Sol waugab gotulai mina, gumei dareun. ");
INSERT INTO bmh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Go Stiven aiwag sil wina wina, gonug guzenai aureun, “Yesus, Dubanou Ban, na izal dorop onen!” ");
INSERT INTO bmh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Go taubib waimai, koli gusig ulaimai, eneun, “Dubanou Ban, na dudu go agal igul eg zilagai mareun.” Go guzenaimai, noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol go Stiven wina, noumeun uligaimai, gonugau ougab siksikeun. Ziwas go ebutal, go Zuda dudu Zerusalem uzanan duailel goagal oiagab petak emen bigegwai eg marai darena, go unum Zudia agaig ebu mui, Samaria agaig ebu uminai wane anemenin. Yesus nugau ze oi aidanemen dudu sag go Zerusalem uzan daremen. ");
INSERT INTO bmh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dudu ipal goagal oiagab petak emen goagen Stiven en oiagab eg wai mina, manil banban maimai, ob oug hemenin. ");
INSERT INTO bmh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Bo, Sol go duailel oiagab petak emen eg maraimai, goagal zau tutak tutak simai, duailel goagal oiagab petak emen keuaraimai, imarai hiacaranem zau oug alai hiacaraneun. ");
INSERT INTO bmh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Duailel go uminai wanemen go uzan ipal beteimai, Uwait nugau Ze duailel ipal maremen. ");
INSERT INTO bmh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip go ban uzan tub Samaria agaig ebu beteimai, duailel Kristus nug en ze mareun. ");
INSERT INTO bmh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Duailel go Pilip nugau ze doimai, gonug Yesus nugau wanib eiman gugeg beu beu meun uligaimai, go gonugau ze suban doi daremen. ");
INSERT INTO bmh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Duailel ipal asiu go wes eg goagal oiagab oug dareun, go nug Yesus nugau wanib ebu oi hicarina, piecaimai, wanemen. Duailel asiu goagal enimag noumeun aidabun iboi tam mui, duailel ipal aramag eg mui, go nug kasareun. ");
INSERT INTO bmh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Guzenaimai, Samaria agaig ebuan duailel goagal oiagab oug banban siksikemenin. ");
INSERT INTO bmh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Du tub go gue uzan dacaneu, gonugau wanib Saimon. Go umkoskos oz ze eim gugeg beu beu mina, Samaria agaigan duailel uligaimai, petak aimai goagal oiagab petak emenin. Gonug enaneu, “Iz du banou”. ");
INSERT INTO bmh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Duailel unum, dudu banban mui, dudu ipal wanimag banou tamacag mui, go gonugau ze suban doi dacanemen. Goagen go wes wanib ‘Gusig Banou’ em ebu zoimai, gonug Saimon alaloun anem. ");
INSERT INTO bmh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Go gonugau oz ze eim ziwas umkoskos gugeg beu beu macaneu, gonun, go sesamoranemen. ");
INSERT INTO bmh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bo, Pilip nug Uwait alai gumarabun en ze mui, Yesus Kristus nugau ze mui, duailel awareun. Ziwas go ebu duailel goagal oiagab kekulina, ze ziwaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon han gonugau ougab petak eun. Go ze ziweimai, Pilip al aidaimai, Pilip nug gugeg go beu beu meun uligaimai, dabeleu asiu oun. ");
INSERT INTO bmh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yesus nugau ze oi aidanemen dudu ipal go Zerusalem uzan dacanemen, Samaria agaig ebuan duailel go Uwait nugau Ze doimai, goagal oiagab petak emen doimai, goagen Pita zaug Zon al Samaria agaig palautarena, betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Dudu aliag go Samaria agaig noimai, dudu goagal oiagab petak emen Uwait nugau Ah Wes wabun aimai Uwait auremen. ");
INSERT INTO bmh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Go Yesus nugau wanib ebu sag ze ziwemenin, gonun, Uwait nugau Ah Wes agal oiagab oug nuab tam. ");
INSERT INTO bmh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Guzenaimai, Pita zaug Zon dual ebeag, duailel go agal oiagab petak emen, goagal tabaiag patendai, Uwait nugau Ah Wes go ebalagab ebu noun. ");
INSERT INTO bmh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Saimon go Yesus nugau ze oi aidanemen dudu aliag goagen duailel goagal tabaiag patena, Uwait nugau Ah Wes omen uligaimai, aiwag oimai, alaimai, awareun, “Ag gusig go iz unum milan. Guzenebi, du in izal ebe gonugau gagalig ebu memin, go han Uwait nugau Ah Wes umau.” ");
INSERT INTO bmh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita nug koli aureun, “Uwait nug gusig go gaul miganeu, nait dabeleu Uwait nugau wes go aiwag sil gau macanem aimai dabelem ta? Tam pet tam. Na guzenai dabelem, nait aiwag mui ab banou oug numam. ");
INSERT INTO bmh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Salau e ig memun go nait salau tam. Uwait nugau ameg ebu nait ounab oug naliu tam. ");
INSERT INTO bmh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gonun, nait ounab koli kekulaiba, igul eg go semoroiba, Uwait auremen, nait dabeleu eg go zilagai mizamau. ");
INSERT INTO bmh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na ecesab asiu wabun dabeleu banou wanem. Nait ounab oug igul eg nug na gusig patizai dareu uligizem.” ");
INSERT INTO bmh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon nug koli Pita guzenai aureun, “Agen Uwait Banou iz isanilabun auran. Guzenebi, igul go zaunal agen ailemenin iz ebilab i zumau.” ");
INSERT INTO bmh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yesus nugau ze oi aidanemen dudu aliag go Yesus nugau ze duailel marai maziaimai, go koli Zerusalem ban uzan beteimai, abu ebu Samaria uzan uzan Yesus nugau Ze Naliupet marai marai betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Uwait nugau tibur tub nug zoimai, Pilip aureun, “Na asaiba, abu Zerusalem uzanan Gasa uzan bitanemen ebu beten. Abu go du tamacag uzan go eiman beten.” ");
INSERT INTO bmh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Guzenaimai, Pilip go asaimai, beteun. Abu go ebu du tub uligeun. Du go gue Itiopia emgasag gumaneun air wanib Kandasi nugau aiwag gumaneu. Go Zerusalem uzan Uwait ulagwag moroimai, karis ebu koli gonugau uzan bitabun beteun. ");
INSERT INTO bmh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kolital gonugau uzan betei beteimai, gonugau karis ebu hoboimai, agau tub getal Uwait nugau ze doimai, awaraneun du tub nug sikut weun, nanalai nanalai beteun. ");
INSERT INTO bmh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Uwait nugau Ah Wes nug Pilip aureun, “Na karis go waugab si peib, ereg beten.” ");
INSERT INTO bmh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Guzenaimai, Pilip go pigai waugab simai, ze go Uwait nugau Ze doimai, awaraneun du Aisaia nug sikut weun nanalai beteun go doun. Guzenaimai, Pilip nug du go kanabai aureun, “Na ze go nalalai darem zebigeg na abe mem ta?” ");
INSERT INTO bmh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Du go nug koli Pilip aureun, “Du tub nug ze go zebigeg abai milaba, go petak iz zebigeg abe mai. Iz erunai ze go zebigeg abe mai?” Guzenina, go nug Pilip aureun, “Na karis wag zoib, iz waiab hoben.” ");
INSERT INTO bmh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sikut go nanaleun gue Uwait nugau ze doimai, awaraneun du nug guzenai sikut weun, ‘Goagen go sipsip sul webi, noumabun en gusig patai alemen. Go sipsip nag sul gonugau enib ulig kuatina, go pieab tam. Du go gue ze tub marab tam. ");
INSERT INTO bmh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dudu agen gonugau wanib tonoi mai, go gonugau ze suban sisiai murab tam. Du tub nug gonugau ug wanib araog mab tam. Ag go wina, noumeun, gonun, go em e ebu dab tam.’ ");
INSERT INTO bmh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Du banou gonug Pilip aureun, “Na iz ailen Uwait nugau ze doimai, awaraneun du go inen anem? Nug en aneu ta, du tub en aneu ta?” ");
INSERT INTO bmh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Guzenina, Pilip nug ze go zebigeg eiman Yesus nugau ze naliu aureun. ");
INSERT INTO bmh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Go abu ebu beteimai, ze ban tub waugab usalemen. Go ze ban peimai, eneu, “Ze e dareu, na iz ze ziwilabun iboi ta?” ");
INSERT INTO bmh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilip nug aureun, “Nait ounab petak pet emen aba, iz na ze ziwizabun iboin.” Gonug koli Pilip aureun, “Izal oiab petak em, Yesus go Kristus, Uwait nugau nag pet.” ");
INSERT INTO bmh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Guzenina, go nug gonugau salau dudu awarina, goagen karis patendai, Pilip du go al ze ebu nomenin. Go ebu Pilip nug du banou go ze zioreun. ");
INSERT INTO bmh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Go guzenaimai, ze uteimai, abu ebu zoimai, pigai Uwait nugau Ah Wes nug Pilip imai beteun. Du banou go gue koli Pilip piab tam. Du go gue ougab siksikaimai, gonugau uzan koli beteun. ");
INSERT INTO bmh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilip go Asdot uzan betei usalaimai, ipal uzan uzan Uwait nugau Ze duailel awarai awarai beteimai, go Sisaria uzan beteun. ");
INSERT INTO bmh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Sol nug Yesus nugau ze sesamoranemen dudu apiparabun ze gusig meun. Guzenaimai, gonug Uwait ula dacanemen dudu goagal banou waugab betena, sikut wai morona, Damaskus uzan betei Zuda duailel goagal gotulanemen zau beteimai, duair inen goagal oiagab Yesus en petak emen gotularaimai, gusig pataraimai, Zerusalem uzan imarai alabun awareun. ");
INSERT INTO bmh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Guzenaimai, Sol go Damaskus uzan bete betei, go ban uzan waugab sina, pigai al banou tub amelaneu sul emes wageim go ebu amel heun. ");
INSERT INTO bmh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Guzenina, Sol go em nogoug ebu alai nuna, du tub nugau zeu sul nug guzenai aurina, doun, “Sol, Sol, na iz einen igul eg milei darem?” ");
INSERT INTO bmh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Gonug koli eneun, “Banou, na in?” Zeu go nug koli eneun, “Iz Yesus na iz igul eg milei darem. ");
INSERT INTO bmh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na asaiba, ban uzan sinen. Aiu ses, du tub nug alaimai, na einab igul mabun aizamau.” ");
INSERT INTO bmh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dudu go Sol al betemen go esilakaimai, ze tamacag soai daremen. Go zeu go domen, du tub piab tam. ");
INSERT INTO bmh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Guzenaimai, Sol go asaimai, ameiteun, bo, ameg kumi mina, abu piabun iborain tam. Guzenina, gonugau ebeg pataimai Damaskus ban uzan imai siemen. ");
INSERT INTO bmh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Go gil ainarai ameg kumi dareun. Ziwas go ebu go ougab eg wina, ee mui, ze mui zab tam. ");
INSERT INTO bmh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yesus nugau ze sesamoraneun du tub go Damaskus uzan dareun gonugau wanib Ananaias, go Dubanou Ban nug wabil aimai, aureun, “Ananaias.” Gonug koli eneun, “Dubanou Ban, iz e darem.” ");
INSERT INTO bmh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dubanou Ban nug aureun, “Na asaiba, abu go wanib Tuguianau ebu beteiba, Zudas nugau zaueim du tub gonugau wanib Sol, go Tarsus ban uzanan betei kanabareun. Du go gue Uwait aurai dareu. ");
INSERT INTO bmh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sol nug wabil aimai, du tub gonugau wanib Ananaias nug zoimai, gonugau ameg patena, koli abu piabun abai moroun.” ");
INSERT INTO bmh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias nug koli aureun, “Dubanou Ban, iz du go Zerusalem uzan nait duailel eg mareun ze asiu ailina, domin. ");
INSERT INTO bmh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Uwait ula dacanemen dudu banban agen igul eg go mabun gusig moromen. Uzanan duailel e na ulapwag mizanem gonug Zerusalem uzan imarai beteimai, hiacaranem zau oug hiacarabun zoun.” ");
INSERT INTO bmh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bo, Dubanou Ban nug koli aureun, “Na izan aizem beten. Du go izal ze oi aidabun salau du tapai macanai. Gonug emgasag ipal ebuan duailel mui, goagal gumarabun dudu banban mui, Israel duailel mui, izal ze awaramau. ");
INSERT INTO bmh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Izanagtal go iz en uhu banou wabun go abai murai.” ");
INSERT INTO bmh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Guzenaimai, Ananaias go Sol dareun zaueim beteimai, gonugau ebeg Sol ebu maimai, aureun, “Zai Sol, Yesus Dubanou Ban gonugtal na abu alemen ebu usaleun. Gonugtal iz na darem ebu palautilina, alem. Na koli ameitamam, Uwait nugau Ah Wes na onab oug kapamau.” ");
INSERT INTO bmh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Guzenina, pigai ece kabunam sul Sol nugau ameg ebu dareun zilagai nuna, go koli ameiteun. Guzenaimai, go asina, dudu ipal agen ze zioremen. ");
INSERT INTO bmh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Guzenaimai, Sol go ee zaimai, go koli gonugau gusig oun. Sol go ziwas ipal Yesus nugau ze sesamoremen dudu abai Damaskus uzan dareun. ");
INSERT INTO bmh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Go asaimai, betei Zuda duailel agal gotulanemen zaueim beteimai, duailel Uwait nugau Ze maraimai, eneun, “Yesus Kristus go Uwait nugau nag pet.” ");
INSERT INTO bmh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Duailel unum go gonugau ze doimai, esilakemen, goagen enemen, “Du e gonug Zerusalem uzanan duailel Yesus nugau wanib patai ulagwag mina, gonug eg maraneu. Go e uzan in duailel goagal oiagab Yesus en petak emen imaraimai, Zerusalem uzan betei eg marabun aleun.” ");
INSERT INTO bmh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bo, Sol nugau ze mareun gusig banou pet usalina, Zuda duailel Damaskus uzan daremen gonugau ze doimai, esilakemen, gonug gusig awaraimai, eneun, “Yesus go Kristus, du go Uwait nug ig koli imaigabun palautina, aleun.” Guzenina, duailel gonugau ze polumai dareu aimai, aurabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ziwas asiu mazicina, Zuda du banban gotulaimai, Sol webi, noumamau aimai ze patemen. ");
INSERT INTO bmh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dudu ipal agen Sol webi, noumamau aimai ze doimai, Sol aurina, doun. Dudu uzan go gilan zau og unum gumeimai, Sol uzaneim nuba, wemun, noumamau aimai umaum amban umkoskos gumei dacanem. ");
INSERT INTO bmh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Umaum tub ebu, gonugau sesamoranem dudu agen imai aimai, betei zau biag eiman gom gau zo banou tub oug mina, gilan seseim palautina, noimai, waneun. ");
INSERT INTO bmh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Zerusalem uzan beteimai, Yesus nugau tapaimaraneun dudu ipal abai gotulabun beteun. Bo, dudu go unum go uligaimai, uminemen. Goagal dabeleu go polumeu emen. Uminaimai, gonugau ze goagal oiagab nug petak ab tam. ");
INSERT INTO bmh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Guzenaimai, Barnabas nug Sol isanoroimai, Yesus nugau ze oi aidanemen dudu waiagab imai sieun. Gonug dudu ipal, Sol go Yesus abu ebu usalina, Dubanou Ban nug aureun unum awareun. Barnabas nug dudu ipal Sol nug Damaskus uzan Uwait nugau Ze gusig mareun han unum awareun. ");
INSERT INTO bmh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Guzenaimai, Sol duailel go abai Zerusalem uzan daimai, uzan ipal Zerusalem uzan waugab unum beteimai, Yesus nugau ze gusig marai ai dareun. Go uminab tam. ");
INSERT INTO bmh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Zuda dudu ipal go Grik ze macanemen goagen Pol al ze eim alalaimai, dudu go aiag sisilina, Sol webi, noumamau en dabilemen. ");
INSERT INTO bmh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Dudu ipal goagal oiagab petak emen goagen dudu go agal dabeleu abe maimai, Sol Sisaria uzan imai beteimai, gonugau uzan Tarsus palautemen. ");
INSERT INTO bmh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Guzenaimai, Zudia agaig mui, Galili agaig mui, Samaria agaig ebuan duailel oiagab petak emen go oiagab selanau mui daremen. Go iwai dab tam, gonun duailel goagal oiagab petak emen, Uwait Banou mui, gonugau Ah Wes mui goagen gusig marena, oiagab selanau mui daimai, asiu usalemen. ");
INSERT INTO bmh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita go uzan unum Uwait nugau Ze marai aidareun. Ziwas tub ebu, go uzan tub wanib Lida uzanan duailel goagal oiagab petak emen piarabun beteun. ");
INSERT INTO bmh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Uzan tub ebu, du tub gonugau wanib Ainias uligeun. Du go gonugau ebegarab unum noumeun, go wai gugen biz ebu sag gabuai dacaneun aidabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita nug du go uligaimai, aureun, “Ainias, ulis, Yesus nug na kasizamau. Na asaiba, nait biz suban men.” Guzenina, du go gue pigai aseun. ");
INSERT INTO bmh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida uzanan duailel go mui, Saron uzanan duailel mui, go igul go uligaimai, Dubanou Ban en goagal oiagab ailemen. ");
INSERT INTO bmh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yesus nugau ze sesamoremen air tub go Zopa uzan dacaneun, gonugau wanib Tabita. Grik ze eim Dorkas anem. Go umkoskos igul naliu duailel ipal esab tamacag go nug isanaraneu. ");
INSERT INTO bmh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ziwas go ebu, go ebeu banou oimai, noumeun. Gonugau enib ze sil ulusaimai, zau empip wag mina, dareun. ");
INSERT INTO bmh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida uzan go Zopa uzan waugab dareu. Guzenaimai, Yesus sesamoranem du Pita go Lida uzan dareu ze doimai, goagen dudu aliag palautarena, betei Pita guzenai auremen, “Na ig waigeb pigai alen.” ");
INSERT INTO bmh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Guzenaimai, Pita go asaimai, dudu aliag go abai beteun. Go uzan go betena, goagen imai aimai, zau go empip ebu imai siemen. Wab ailel go unum Pita waugab alai gotulaimai, patai weinemen. Goagen tibur galau go mui, esab ipal Dorkas nug patai maimai, mareun Pita abai moromen. ");
INSERT INTO bmh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita nug duailel unum uzaneim palautarena, nuna, go taubib aimai, Uwait aureun. Guzenaimai, go nug kekulaimai, air go gabuai memen ebu ametai peimai, eneun, “Tabita, na asen.” Guzenina, air go gue koli ameg oitina, Pita uligaimai, asaimai, gonugau biz ebu hoboun. ");
INSERT INTO bmh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita nug go waugab beteimai, gonugau ebeg pataimai, asai mina, air noumeun go waseun. Pita nug duailel Uwait en oiagab petak emen mui, wab ailel mui, ularena, zuna, gonug Dorkas abai mareun. ");
INSERT INTO bmh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ze go Zopa uzanan duailel agen oi unum betei awarina, duailel asiu goagal oiagab Dubanou Ban en petak emen. ");
INSERT INTO bmh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita go Zopa uzan ziwas asiu dareun. Go du tub bulumakau nugau galau sil ecesab patai macaneun du wanib Saimon al dareun. ");
INSERT INTO bmh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Du tub go Sisaria uzan dacaneun, gonugau wanib Kornilius. Kornilius go Rom agal malai dudu handret tutak agal gagaliag a gumaraneu du banou. Go malai dudu gue Itali emgasag ebuan. ");
INSERT INTO bmh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Go Uwait nugau Ze sesamoraneu. Go gonugau gelegul mui Uwait ulagwag muranemen. Gonug Zuda duailel ecesab tamacag isanaraneu. Go ziwas umkoskos Uwait auraneu. ");
INSERT INTO bmh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ziwas tub umusig ebu, Uwait nugau tibur tub nug wabil ebu go waugab zoimai, aureun, “Kornilius.” ");
INSERT INTO bmh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Gonug go Uwait nugau tibur gusig peimai, uminaimai, eneun, “Ban, iz ailen.” Uwait nugau tibur nug koli aureun, “Uwait nait auranem mui, salau naliu macanem mui, peimai, go na en ougab siksikeu. ");
INSERT INTO bmh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Guzenaimai, na ulis nait dudu ipal Zopa uzan palautaremen, betei du tub gonugau wanib Saimon-Pita imai alamam. ");
INSERT INTO bmh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Go du tub gonugau wanib Saimon go bulumakau nugau galau sil esab patai macaneu gonugau zau ibut ze gasag eim dareu.” ");
INSERT INTO bmh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Uwait nugau tibur go wanena, Kornilius nug gonugau salau dudu aliag mui, malai du tub go Uwait nugau Ze sesamoraneu du mui, ularina, go waugab alina, gonug Uwait nugau tibur nug ein ze aureun, unum awaraimai, Zopa uzan palautarena, wanemen. ");
INSERT INTO bmh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Betei nineimai, ziwas tub ebu, dudu go Zopa uzan abu ebu betena betena, am ula ebu, Pita go Uwait aurabun zau zag wag sieun. Go we wina, ee zabun dabeleun. Go ee mis memen suban mina mina, go wabil eiman sul e tub uligeun. ");
INSERT INTO bmh_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Go Emes im oiteun uligeun, go ebuan e tub ninanem tibur galau banou sul noun. Ipal ece agen tubaim tubaim patena, iau iau em ebu noun uligeun. ");
INSERT INTO bmh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Esab go ninanem tibur galau sul oug egun beu beu asiu, man, zamai, meg inain mui uligareun. ");
INSERT INTO bmh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Guzenaimai, du tub nugau zeu sul nug aureun, “Pita, na asaiba, egun go agai, zen.” ");
INSERT INTO bmh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita nug koli eneun, “Ban, iz go i guzenai. Iz egun unu mui i zanem.” ");
INSERT INTO bmh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Guzenaimai, du gonugau zeu nug koli aureun, “Ein ece Uwait nug naliu usalaimeun, na unu mui aib i zemen.” ");
INSERT INTO bmh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Du gonugau zeu nug ze go ziwas ainarai guzenai aurina, ece go ninanem tibur galau sul koli Emes wag sieun. ");
INSERT INTO bmh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita go gue wabilai uligeun bigeg erunai bo aimai dabeleu asiu oi dareun. Ziwas go ebutal, Kornilius nug gonugau dudu palautarena, betei, Pita imabun go ein zau dareun abe maimai, betei, gonugau zau gilan og eiman tapai daremen. ");
INSERT INTO bmh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Goagen alaimai, go ebuan dudu kanabai awaremen, “E ebu du tub nugau wanib Saimon-Pita dareu ta?” ");
INSERT INTO bmh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita go gue gabuai wabil eiman sul uligeun bigeg abe mabun dabilei darena, Uwait nugau Ah Wes nug aureun, “Pita, dudu ainarai na peizabun uzaneim zoi tapai darem. ");
INSERT INTO bmh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Guzenaimai, na dabeleu asiu i on, nait esab suban maiba, go sesamarai beten. Dudu go izan na imaizabun palautarena, alemen.” ");
INSERT INTO bmh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Guzenaimai, Pita go uzaneim noimai, dudu go uligaraimai, awareun, “Du go ag itanai alemen go iz sag. Ag einen alemen?” ");
INSERT INTO bmh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Go ageban koli Pita auremen, “Kornilius go Rom agal malai dudu gumaraneu du banou nug ig palautigen, alemun. Go Uwait nugau Ze sesamoraneu, go Uwait umkoskos ulag zaneu. Zuda duailel agen go en oiagab noumanem. Uwait nugau tibur tub nug na gonugau zau imaiz bitabun aneun. Guzenaimai, nait ze memen, dumau.” ");
INSERT INTO bmh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Guzenaimai, Pita nug dudu go zaueim imarai simai, ee marena, zina, nineimai, umaseu, asaimai, go Zopa uzanan dudu ipal oiagab petak emen imaraimai, go Sisaria uzanan dudu alemen sesamarai beteun. ");
INSERT INTO bmh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Go beteimai, ula nineimai, umaseu, Sisaria uzan siemen. Kornilius go gonugau gelegul mui, dudu go waugab darem mui, gonugau zaueim alai gumei daremen. ");
INSERT INTO bmh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Gumei daren, Pita go Kornilius nugau zau zuna, Kornilius nug beteimai, Pita wanib wag murabun taubib weun. ");
INSERT INTO bmh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Guzenina, Pita nug ebeg patai asai maimai, aureun, “Na asen! Iz Uwait tam, iz gaul du.” ");
INSERT INTO bmh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita go Kornilius al ze zemai, gonugau zaueim simai, duailel asiu gotulai daremen uligareun. ");
INSERT INTO bmh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Guzenaimai, Pita nug awareun, “Ag abiu, Zuda agal kasai ze eneu, ‘Zuda duailel ag emgasag ipal ebuan duailel agal zaueim i simamen, go unupag mui,’ Bo, Uwait nug iz ulis araog abai mileimai, eneun, ‘Emgasag ipal ebuan duailel unupag mui i awaran, ag naliu sag, unupag tamacag.’ ");
INSERT INTO bmh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Guzenaimai, iz imailabun betemen iz asaimai, ze tub kanabai awarab tam, sesamarai alemin. Iz ag ulis kanabarem. Ag iz einen dudu palautarena, betei imailei alemen?” ");
INSERT INTO bmh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","31","Kornilius nug koli aureun, “Gil ainarai mazieun ebu, iz umusig izal zaueim Uwait aurai daremin ebu, pigai du tub go tibur galau ausiau mui izal amei ebu zoi tapai daimai, aileun, ‘Kornilius, Uwait go nait auremen ze doun. Nait salau duailel ipal isanaranem gonug na en ougab siksikeu. ");
INSERT INTO bmh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na dudu ipal Zopa uzan palautaremen, betei du tub wanib Saimon-Pita imai alamam. Go du tub gonugau wanib Saimon go bulumakau nugau galau ebu esab patai macaneu du gonugau zau, ibut ze gasag eim dareu.’ ");
INSERT INTO bmh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Guzenaimai, iz ziwas go ebutal na imaizabun dudu palautarena, betei na imaiz alemen. Na igul naliu maimai, go abai alem. Ig ulis Uwait nugau ameg ebu Uwait nug ein ze aigabun aneun duabun gotulaimai, na gumizai darem.” ");
INSERT INTO bmh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita nug koli eneun, “Iz ulis petak abe mem, Uwait go du tutak en ougab i alacaneu, go duailel unum en ougab alaracaneu. ");
INSERT INTO bmh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Du in go Zuda du, emgasag tub ebuan du ta, go Uwait uminaimai, igul naliu mamau, Uwait nug goen ougab noumamau. ");
INSERT INTO bmh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ag ze go abiu, Uwait nug Yesus Kristus nugau Ze naliu amegai ig Israel duailel migeun. Ig Uwait al oigab selanau mui tulai dabun en Yesus migeun, Yesus go em ebuan duailel unum igual Dubanou Ban. ");
INSERT INTO bmh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ag abiu, getal Zon nug ze ziwabun ebu awareun, ze go, ziwas go ebu, Galili agaig ebu bigegwai zoimai, Zudia agaig unum beteun. ");
INSERT INTO bmh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ag abiu Yesus Kristus go Nasaret uzanan, Uwait nugau gusig mui, Ah Wes mui moroun. Go emgasag unum aidai dai beteimai, Uwait nugau Ze maraimai, duailel ebeu eg mui kasaraimai, wes eg duailel goagal oiagab oug daremen go nug oi higarai heun. Uwait nugau gusig go al dareun, gonun, go guzenaneun. ");
INSERT INTO bmh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ig igual ameig nug go Israel em e mui, Zerusalem uzan mui, guzeneun pemun, gonun, awarem. Dudu agen a gegeulanau ebu asai mina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bo, gil ainarai ebu, Uwait nug go koli awau asai mina, duailel agen pemen. ");
INSERT INTO bmh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Go duailel unum goagal ameagab ebu zuab tam. Dudu gonugau gusig piabun tapai mareun goagal ameagab ebu usalaneun, dudu go ig sag. Go asaimai, ig ibaig zoi ereg ee zaimai, ze zeun. ");
INSERT INTO bmh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Gonug ig duailel ebalagab Uwait nugau Ze naliu awaraiban, araog maran aimai ze gusig migeimai, guzenan aigeun. Go Uwait nug duailel noumemenin mui, awau darem mui, sisiarabun tapai moroun. ");
INSERT INTO bmh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Uwait nugau ze doimai, awaranemen dudu agen han getal goen ze maimai, enemen. Duailel ag unum go en oiagab petak amau, Uwait nug Yesus nugau wanib ebu agal igul eg zilagai maramau.” ");
INSERT INTO bmh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita go gue Uwait nugau Ze maren maren, Uwait nugau Ah Wes duailel gonugau ze doi daremen ebu noun. ");
INSERT INTO bmh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Zuda dudu goagal oiagab petak emen, go Pita al Zopa uzanan ereg alemen, go Uwait nugau Ah Wes emgasag ipal ebuan dudu ebu han nuna, peimai, esilakaimai, dabeleu asiu omenin. ");
INSERT INTO bmh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Zuda dudu go dudu go ze ata atai eim Uwait ulagwag morondai domen. Guzenaimai, Pita nug eneun, “Duailel e ag Uwait nugau Ah Wes ig omun sul ag han guzenaital ulis omen, gonun, du tub nug ag ze ziwabun kuatai ze i awaramau.” ");
INSERT INTO bmh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Guzenaimai, gonug Yesus nugau wanib ebu duailel go ze ziwareun. Guzenaimai, goagen Pita ziwas ipal go abai dabun aimai auremen. ");
INSERT INTO bmh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesus nugau ze oi aidanemen dudu mui dudu ipal goagal oiagab petak emen go emgasag ipal ebuan duailel Uwait nugau Ze doimai, oiagab ailina domenin. ");
INSERT INTO bmh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Guzenaimai, Pita go Zerusalem uzan koli betena, go Zuda dudu oiagab petak emen go Zuda agal igul sesamorai, goagal enimag galau kuatemenin agen Pita kagagai, auremen, “Na emgasag ipal ebuan dudu agal enimag galau kuatab tam, goagal uzan beteimai, go abai ee zemen.” ");
INSERT INTO bmh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Guzenai aurina, Pita nug ein igul unum go ebu usaleun awaraimai, eneun, ");
INSERT INTO bmh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ziwas tub, iz Zopa uzan daimai, Uwait aurai daina, pigai esab tub ninanem tibur galau banou sul wabil eiman, Emes wag eiman esab tub nug tubai tubaim patena, iz waiab noun pemin. ");
INSERT INTO bmh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","7","E go ninanem tibur galau sul oug egun asiu daremen, egun ipal zag, zamai ipal, meg ipal beu beu uligaremin, Guzenaimai, iz du tub nugau zeu sul nug aileun domin, ‘Pita, na asaiba, go egun uligarem ugareiba, zen.’ ");
INSERT INTO bmh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Guzenina, izan koli auremin, ‘Ban, iz go egun unupag mui iz zabun iborain tam.’ ");
INSERT INTO bmh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Go du nugau zeu sul nug Emes wag eiman koli aileun, ‘Ein esab Uwait nug naliu usalaimeun nagen go unupag mui i en.’ ");
INSERT INTO bmh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","11","Igul go ziwas ainarai sag guzenina, esab go koli Emes wag sieun. Ziwas go ebutal dudu ainarai go Sisaria uzanan, iz zaueim go daremin ebu palautarena, siemen. ");
INSERT INTO bmh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Uwait nugau Ah Wes nug na dabeleu asiu i wabun aimai ailina, zaiar wasolig sag e go Zopa uzanan iz ibail ereg Sisaria uzan beteimai, Kornilius nugau zaueim ereg siemun. ");
INSERT INTO bmh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kornilius nugau zaueim sina, go nug Uwait nugau tibur gonugau zaueim zoimai tapai daimai, aureun, ‘Na dudu ipal Zopa uzan palautaremen, betei du tub gonugau wanib Saimon-Pita imai alamamen. ");
INSERT INTO bmh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Gonug na mui, nait gelenar abai zaueim go darem, alai Uwait nugau Ze awaraba, Uwait nug ag imaramau.’ ");
INSERT INTO bmh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Guzenina, iz betei Uwait nugau Ze awaremin, Uwait nugau Ah Wes amegai ig ebiligeb noun sul, go ebalagab han guzenaital noun. ");
INSERT INTO bmh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Guzenaimai, iz igul go ebu Banou nugau ze aneun petak abe memin. Zon nug duailel ze sil ze ziwaraneun, bo, agen Uwait nugau Ah Wes sil ze ziwaramamen aimai aneun dabelemin. ");
INSERT INTO bmh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Igul go araog, Uwait nug go emgasag ipal ebuan dudu agal enimag galau kuatab tam, gusig go igual oigeb petak eun gusig omun sul, ag han guzenaital omen. Iz ein gusig nug Uwait nugau salau tapelamau?” ");
INSERT INTO bmh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Go Pita nugau ze doimai, goagal oiagab siksikaimai, Uwait nugau wanib ulagwag muranemen, ‘Guzenaimai, emgasag ipal ebuan dudu han go Zuda duailel sul, Uwait nug muzmuz dabun oiagab kekulabun iboin.’ ");
INSERT INTO bmh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiven wina, noumeun ziwas ebu, oiagab petak emen dudu go emgasag unum uminai wanemen. Dudu ipal Ponisia agaig ebu wanemenin. Dudu ipal Saiprus em waug mui, Antiok uzan mui, wanemenin. Go beteimai, Zuda duailel sag Yesus nugau ze marai aidanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bo, Saiprus mui Sairini uzanan dudu ipal agen Antiok uzan beteimai, duailel Grik emgasag ebuan goagal enimag galau kuatab tam, Yesus nugau ze maremen. ");
INSERT INTO bmh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Uwait nugau gusig go abai darena, duailel asiu goagal oiagab ailaimai, Yesus en oiagab petak emenin. ");
INSERT INTO bmh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Zerusalem uzanan oiagab petak emenin dudu go goagal ze doimai, Barnabas Antiok uzan palautina beteun. ");
INSERT INTO bmh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Go beteimai, Uwait nug gonugau ougab naliu eiman go isanareun uligaimai, gonugau ougab siksikeun. Guzenaimai, gonug duailel goagal oiagab petak emenin gusig mabun dabeleu asai mareun. ");
INSERT INTO bmh_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas du naliupet gue, go Uwait nugau Ah Wes mui gonugau ougab gusig petak eun. Guzenaimai, duailel asiu goagal oiagab ailaimai, Dubanou Ban en oiagab petak emenin. ");
INSERT INTO bmh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Guzenaimai, Barnabas go Sol Tarsus uzan dareun tulorabun waneun. ");
INSERT INTO bmh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Go betei tuloroimai, koli Antiok uzan imarai aleun. Wai go ebu, zaug dual go ebu daimai, oiagab petak emenin duailel asiu Uwait nugau Ze marai daremen. Uzan tub duailel agen amegai duailel goagal oiagab petak emenin wanimag Kristen maremen. Wanimag go zebigeg ‘Kristus sesamoranem duailel.’ ");
INSERT INTO bmh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ziwas go ebu, oluol ananemen dudu ipal go Zerusalem uzaneim Antiok uzan nomen. ");
INSERT INTO bmh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Du tub nugau wanib Agabus, Uwait nugau gusig mui asaimai, awareun, ‘Aiu ses em e ebu we banou pet zumau. We banou go Rom nugau gumaneun emgasag unum zumau.’ (Sisar-Klodius emgasag gumaneun du dareun ebu go petak zoun.) ");
INSERT INTO bmh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Gonun, Yesus nugau ze sesamoremen dudu agen duailel goagal oiagab petak emenin Zudia agaig darem isanaraporoi en aiwag palautai marabun ze patemenin. Unum goagal aiwag uligaimai, ipal palautai maremenin. ");
INSERT INTO bmh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Guzenaimai, go aiwag gotulai maimai, Barnabas Sol dual goagal ebeagab ebu mina, oiagab petak emenin duailel go Zudia agaig goagal gumaranem dudu banban marabun oi betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ziwas go ebu dudu go Yesus sesamoremenin, Herot nug eg maraimai, ipal gusig pataremen. ");
INSERT INTO bmh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Gonug gonugau malai dudu awarina, goagen Zon nugau amag Zems maulzag uiaban sil wina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herot go igul go guzeneun, Zuda duailel go siksikemenin uligaimai, dudu ipal palautarena, betei Pita han gusig patabun guzenemenin. ");
INSERT INTO bmh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ziwas go Pasowa ebu, Pita betei gusig pataimai hiacaranem zau oug maimai, malai dudu 16 sag go gumabun tapai maremen. Amegai dudu iwanarai sag gumei daremen, betei uminina, dudu iwanarai ipal alemen, guze guzenai betei dudu 16 agen gumemenin. Herot nugau dabeleu Pasowa ziwas go maziaba, duailel goagal ameagab ebu imai beteimai, webi, noumamau aimai dabeleun. ");
INSERT INTO bmh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Guzenaimai, Pita go hiacaranem zau oug heimai, malai dudu agen go suban gumei daremen. Duailel goagal oiagab petak emenin Zerusalem uzanan Pita isanorabun en umaum Uwait umkoskos aurai daremenin. ");
INSERT INTO bmh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tuaba sul, Herot nug Pita uzaneim imai nuabunina, Pita gonugau ebeg us sil kiai memen, malai dudu aliag go Pita ula maimai, gumei darena, Pita gabueun. Malai dudu aliag go tub nug, zau og eiman gumei tapai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pigaital, Uwait nugau tibur zoi zaueim ula tapai darena, al banou nug zaueim go unum hilai heun. Uwait nugau tibur nug Pita nugau abalag sau bigeg pataimai, asai maimai, aureun, “Na pigai asen.” Guzenina, us ebeg ebu kiai memen nugtal golosaceun. ");
INSERT INTO bmh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Guzenaimai, Uwait nugau tibur nug aureun, “Nait tibur galau hogu tugaiba, nait aram ebu aram galau men. Na tibur galau huia kulaiba, iz sesamilen.” ");
INSERT INTO bmh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Guzenai aurina, Pita nug Uwait nugau tibur sesamorai uzaneim noun. Pita gue igul go Uwait nugau tibur nug guzenina, go gabuaimai, wabilem aimai dabeleun. ");
INSERT INTO bmh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Go malai du aliag zau og eiman tapai daremen mui, ipal uzaneim tapai daremen unum, zilarai noi uzaneim ban uzan unabun gilan waugab betena, go zau og im nugtal oitina go uzaneim nomenin. Go noi, abu sesamorai unacanemen ebu, Uwait nugau tibur nug Pita utena waneun. ");
INSERT INTO bmh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Guzenina, Pita gue igul go guzeneun abe maimai, eneun, “Iz ulis abe mem, igul go petak pet. Uwait nug gonugau tibur palautina, Herot nugau gusig ebuan mui, igul go Zuda duailel agen iz igul eg milabun ebuan koli imaileu.” ");
INSERT INTO bmh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Go igul go abe maimai, go Zon-Mak nugau anag, Maria nugau zau beteun. Duailel asiu go zaueim gotulai daimai, Uwait aurai daremen. ");
INSERT INTO bmh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita go beteimai, zau nugau gilan zau og korukorueun. Guzenina, salau air tub, gonugau wanib Roda, eneu inug go zau og korukorueu aimai piabun aleun. ");
INSERT INTO bmh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Go Pita nugau zeu doimai, siksikaimai, go zau im oitab tam, go koli pigai beteimai, duailel ipal Pita uzaneim tapai dareu aimai awareun. ");
INSERT INTO bmh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Goagen koli auremen, “Na polumem.” Gonug awareun, “Iz petak awarem, Pita uzaneim tapai dareu.” Guzenina, goagen koli auremen, “Uwait nugau tibur go dareu.” ");
INSERT INTO bmh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Go ze mina, Pita go koli koli zau og korukoru ai darena, zauan dudu agen betei zau im oitaimai, Pita pemenin. Go, go peimai, esilakemenin. ");
INSERT INTO bmh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita gonugau ebeg sil soabun awarina, go ze soina, go Uwait nug erunai uzaneim imai noi meun ze go suban awareun. Go guzenai awaraimai, kolital awareun, “Ze go Yesus nugau amag Zems mui, dudu ipal goagal oiagab petak emenin mui, awaran.” Go guzenai awaraimai, utaraimai, uzan tub waneun. ");
INSERT INTO bmh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Go malai dudu go Pita gumei ninemen umaseu Pita i peimai, agzozou banban uminaimai, dabeleu asiu omenin. Agzozou enemen, “Pita eru waneun?” ");
INSERT INTO bmh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Guzenaimai, Herot nug Pita waneun ze doimai, go aigsisil ina, malai dudu Pita itanabun palautareun. Go Pita itanemen, itanaimai i peimai, go nug Pita gumemen malai dudu suban kanabaraimai, malai dudu ipal agen go malai dudu ugarebi, noumamam awarina, go gonugau ze sesamoremenin. Dai dai, Herot go Zudia agaig eiman Sisaria uzan beteimai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot go Tair uzan mui, Saidon uzanan duailel go en aigsisileun. Guzenina, go gotulaimai, go al zemabun alemen. Du tub wanib Blastus, go Herot nugau zau gumaneun du, go amegai go al oiagab tutak mabun zememenin. Goagal ee Herot nugau emgasag ebuan wanemen, gonun, go Herot waugab beteimai, gonugau aigsisileun oiagab tutak mabun aimai auremenin. ");
INSERT INTO bmh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herot nugtal ziwas tub tapai macaneu ebu, gonugau tibur galau naliu maimai, gonugau biz ebu hoboimai, duailel ze mareun. ");
INSERT INTO bmh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Duailel goagen koli koli gusig ulemen, “Du go nug aurab tam, em uwait banou tub nug ze meu.” ");
INSERT INTO bmh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herot go gue polu ze aimai awarab tam, go Uwait nugau wanib ulagwag murab tam, gonun, Uwait nugau tibur nug pigai noimai, eg moroun. Go ebeu banou oimai, salik nug gonugau ougab oug daimai, tugei zina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Duailel asiu Uwait nugau Ze doimai, goagal oiagab ailemen. ");
INSERT INTO bmh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas zaug Sol dual, goagal salau maziaimai, koli Zerusalem uzan utei betemenin. Zon-Mak ereg imai wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok uzan ebu, dudu oiagab petak emenin go ula oug oluol ananemen dudu ipal mui, Uwait nugau Ze tapaimaranemen dudu ipal mui, daremen. Go ebu Barnabas mui, Simeon (go du mutuanau anem), Lusius (go Sairini uzanan), Manain, (go Herot nugau aunag mogoi begeun) mui, Sol ereg daremen. ");
INSERT INTO bmh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ziwas tub ebu, Uwait nugau wanib ulagwag maimai, ee ur maimai, daren daren, Uwait nugau Ah Wes nug goagal dabeleu ebu zoimai, awareun, “Barnabas zaug Sol dual ag izal salau mabun tapai marem.” ");
INSERT INTO bmh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Guzenai awarina, go ee ur maimai, Uwait auraimai, goagal ebeag dudu aliag go agal tabaiag pataimai, palautarena, wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas zaug Sol dual Uwait nugau Ah Wes nug palautarena, Selusia uzan utei tebil ebu Saiprus em waug ebu betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Go Salamis uzan beteimai, Zuda duailel goagal gotulanemen zaueim simai, Uwait nugau Ze maremenin. Zon-Mak nug go salau isanaraneu. ");
INSERT INTO bmh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Go Saiprus em waug unum betei, uzan tub wanib Papos beteimai, uzan go Zuda du tub go oz ze asiu macaneu gonugau wanib Barzisas betei tuloromen. Gonug iz Uwait nugau Ze doimai, awaranem du aimai polumaraneu. ");
INSERT INTO bmh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Du go gue em go gumaneun du Sergius-Paulus nugau salau du. Sergius-Paulus go du dabeleu naliu mui Du banou gonug Barnabas zaug Sol dual Uwait nugau Ze mina, duabun ularena, gonugau zau betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bo, go eten du, gonugau wanib tub Elimas (Grik ze eim Elimas anem, ‘eten du’) gonug goagal ze tunarai mareun. Du go nug gonugau du banou nugau ougab petak eun, eg wai mabun en guzeneun. ");
INSERT INTO bmh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Guzenaimai, Sol gonugau wanib tub Pol, go Uwait nugau Ah Wes mui gonug eten du go gusig pei daimai, aureun, “Na Satan nugau nag. Na dudu igul naliu macanemen agal iwai zaiag daimai, dudu polumarabun igul nait dabeleu ebu kapai og zoi dareu. Na Uwait nugau Ze petak umkoskos go polu ze aimai awaranem. ");
INSERT INTO bmh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Uwait nugau gusig nug ulis na ebizab nuba, nait amen kumi usalamau. Na al hilanau i pimam, betei Uwait nugtal nait amen outai mizaba, petak koli em pimam.” Ziwas go ebutal, Elimas ameg kumi usaleun. Guzenina, go dudu ipal agen ebeg pataimai, abu abai moroimai, dual ai daremen. ");
INSERT INTO bmh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Du banou go nug gugeg go peimai, banban esilakaimai, Uwait Banou nugau ze doimai, gonugau ougab petak eun. ");
INSERT INTO bmh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol gonugau zaugul abai Papos uzan uteimai, tebil oimai Perga uzan Pampilia agaig ebu zomen. Zon-Mak go gue uzan utaraimai, koli Zerusalem uzan beteun. ");
INSERT INTO bmh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Go Perga uzan uteimai, ban uzan tub wanib Antiok, Pisidia agaig ebu betemen. Ziwas go ebu Imabun Ziwas, gonun, go beteimai, Zuda duailel goagal gotulanemen zaueim betei hobomenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Gotulanemen zau go gumanemen dudu banban Moses nug kasai ze sikut weun mui. Uwait nugau ze doimai, awaranemen dudu agal sikut wemen mui, nanalaimai, goagen Pol Barnabas dual awaremen, “Zaiger, ag igual duailel ze tuguianau ipal isanarabun dareu aba, igual duailel awaran.” ");
INSERT INTO bmh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Guzenaimai, Pol nug asaimai, duailel ze soan awarina, ze soina, awareun, “Israel duailel mui, emgasag ipal ebuan duailel ag e ebu daremen Uwait ulagwag muranemen, ag izal ze don. ");
INSERT INTO bmh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel duailel e agal Uwait Banou nug igual embigeg tapai maraimai, isanarena, Izip emgasag ebu asiu pet usalemen. Uwait nugau gusig banou nug igual ataniger Izip emgasag ebu salau eg bisomag mui mai daremen, ebuan imarai aleun. ");
INSERT INTO bmh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wai houhou iwanarai (40) sag dudu tamacag uzan em ula ebu goagen igul eg asiu macanemen, bo, gonug go suban gumareun. ");
INSERT INTO bmh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Gonug Kenan emgasag ebuan uzan banban kwali sag goagal duailel unum eg maraimai, em go gonugau duailel goagal pet usalabun mareun. ");
INSERT INTO bmh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ziwas go Zekop gonugau ug abai, Izip emgasag si daimai, betei, Kenan emgasag eiman alemen, go unum wai 450 sag daremen. Kenan emgasag ebu Uwait nug duailel gumarabun dudu tapai mareun. Go eiman betei Uwait nug gonugau ze doimai, awaraneun du Samuel usalaimeun. ");
INSERT INTO bmh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Duailel agen emgasag gumarabun du banou king tapai mabun Samuel aurina, Uwait nug Sol, Kis nugau nag, Benzamin nugau ug ebuan tapai moroun. Go wai houhou iwanarai sag, duailel gumarai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bo, Uwait nug king Sol oi heimai, Devit go gumarabun tapai mina, go gumaraneu du banou dareun. Du e Uwait nug go en aneun. ‘Devit go Zesi nugau nag, uligaimai, izal oiab go en noumem. Ein igul go guzenabun auranem go ze unum sesamoraneu.’ ");
INSERT INTO bmh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yesus go Devit nugau ug ebuan, Israel duailel agal igul eg ebuan imarabun Uwait gonugau baib meun guzenaital aleun. ");
INSERT INTO bmh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesus go salau mab tam ebu, amegai Zon nug duailel goagal igul eg ebuan kekulaimai, alina, go nug ze ziwareun. ");
INSERT INTO bmh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Zon go abiu gonugau salau poabun ziwas zuna, duailel guzenai awareun, ‘Ag iz in dabilemen? Iz du go ag koli agal igul eg ebuan imarabun gumei daremen ta? Iz du go tam, go ses zoi dareu. Iz du gaul, iz go waugab beteimai, gonugau arab galau us aitulabun iborain tam.’ ");
INSERT INTO bmh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","O zaiar, ag Abraham nugau ug ebuan mui, emgasag ipal ebuan dudu ag Uwait ulagwag muranemen, Uwait nugau imaigabun ze go Uwait nug ig ebiligeb palautina, aleun. ");
INSERT INTO bmh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Zerusalem uzan daremen duailel mui, goagal gumaranemen dudu banban mui, go Yesus koli imaigabun du go i abiu. Goagen Yesus wina, noumeun. Guzenaimai, ag Uwait nugau ze doimai, awaranemen dudu agal ze Imabun Ziwas ebu umkoskos nanalanem unum iboreun. ");
INSERT INTO bmh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Goagen go igul eg tub meun, gonun, go webi, noumabun sul piab tam, bo, go gaul wina, noumabun Pailot gusig aurina, wina, noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Go igul go getal Uwait nugau ze awaranemen dudu agen anemen unum sesamoremenin. Goagen a gegeulanau ebuan oi noimai, aizau ob tub oug memen. ");
INSERT INTO bmh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bo, Uwait nug noumeun ebuan koli awau asai meun. ");
INSERT INTO bmh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ziwas asiu gonugau salau dudu getal Galili agaig eiman Zerusalem uzan bitanemen ebu, go abai ai dareun, goagen pemenin. Goagal ameag nug peimai, go igual duailel awaranem. ");
INSERT INTO bmh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ig ulis Uwait nugau ze naliu Uwait nug igual embigeg abai baib mareun awarem. ");
INSERT INTO bmh_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Baib go ulis Uwait go nug Yesus asai morona, ig agal geleagar abai petak pet abai migeu. Ze go Buk Song ebu sikut wemen petak usaleun. ‘Na izal nagwai, ulis iz nait memen usalem.’ ");
INSERT INTO bmh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Go petak Uwait nug go noumeun ebuan asai meun, gonugau enib i bilamau. Go Uwait nug getal eneun, suban dabun ze Devit murabun baib moromin, ze go en agal oiagab petak amamen.’ ");
INSERT INTO bmh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Guzenaimai, Buk Song ebu sikut guzenai dareu, ‘Na nait salau du naliu utena, eb ob oug i bilamau.’ ");
INSERT INTO bmh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ig abiu, Devit go duailel ameagab Uwait en ougab noumaimai, gonugau ze unum sesamorai dareun. Dai dai go noumina, gonugau embigeg agal eb ob oug waugab eb ob oug hina, gonugau enib beleun. ");
INSERT INTO bmh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bo, du go Uwait nug asai meun gonugau enib beleun tam. ");
INSERT INTO bmh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Izal zaiar, ag don, ag ze go petak abiu mabun awarem. Yesus nug petak agal igul eg zilagai maramau. ");
INSERT INTO bmh_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moses nugau kasai ze tutak sesamoraimai, Uwait nug agal igul eg i zilagai maramau. Du in Yesus en ougab petak eun gonugau igul eg unum zilagai moroimai, go du tuguiai usalai muramau. ");
INSERT INTO bmh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","O zaiar, ag suban tapai damamen. Ag guzenebi, igul e agen anemen ag ebalagab ebu i usalamau. ");
INSERT INTO bmh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Uwait nugau ze doimai, awaranemen dudu ipal agen enemen, ‘Ag don, ag eg ze macanemen dudu, ag Uwait nugau Ze duabun uteimai, ag dabeleu asiu oimai, gaul gaul noumamamen. Salau e ulis ag darena, iz guzenai, bo agal oiagab petak i amamen. Dudu ipal agen ag suban awaramam han, bo ag oiagab petak i amamen.’” ");
INSERT INTO bmh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ze go duailel maraimai, Pol zaug Barnabas dual uzaneim nuabun dabilena, duailel agen Imabun Ziwas tub ebu ze guzenai koli marabun awaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Guzenaimai, Zuda duailel mui, emgasag ipal ebuan duailel mui unum, go Uwait ulagwag moroimai, Pol zaug Barnabas dual abu ebu sesamarai nuna, dudu aliag agen Uwait nug gonugau ougab naliu mui eiman go isanarena, gonugau igul naliu sesamorabun awaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Zobu tub ebu, go uzanan dudu asiu Uwait nugau Ze duabun alai gotulemenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zuda duailel ipal go duailel asiu Uwait nugau Ze duabun alai gotulina, piaraimai, oiagab eg wina, aiag sisileun. Ag Pol nugau enib ebu ze macanemen, ‘Pol go polumeu, emen.’ ");
INSERT INTO bmh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Guzenina, Pol zaug Barnabas dual ze gusig awaremen, “Uwait nugau Ze go Zuda duailel amegai marena, duabun iboi, bo, go gonugau ze duabun utena, go gonugun agtal enanem, ‘Ig awau muzmuz dabun gusig wabun iboi tam.’ Ig ulis ag utaraimai, emgasag ipal ebuan duailel betei Uwait nugau ze maramam. ");
INSERT INTO bmh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Einen, Banou nug getal ze gusig guzenai aigeun, ‘Iz ag emgasag ipal ebuan duailel agal al sul marem. Unum emgasag ebuan duailel agen isanarebi, Uwait nug koli imaramau.’” ");
INSERT INTO bmh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Emgasag ipal ebuan duailel go ze go doimai, go siksikaimai, Uwait nugau Ze ulagwag moromenin. Duailel go Uwait nug muzmuz awau dabun tapai mareun goagal oiagab ailaimai, petak emenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Uwait nugau Ze emgasag go unum oi wanemen. ");
INSERT INTO bmh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Guzenaimai, Zuda duailel agen go uzanan ailel ecesab asiu Uwait ulagwag muranemen mui, dudu banban ipal mui, goagal oiagab asai marena, go Pol zaug Barnabas dual goagal uzanan zamarina, wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Go igul go guzena, Pol zaug Barnabas dual goagal igul eg abai marabun goagal aramag galau oimai, emwaibul aramag ebuan kueaimai, Aikoniam uzan wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Go utei wanena, Yesus nugau ze sesamoremen dudu go Antiok uzan darem Uwait nugau Ah Wes nug gumarina, go siksikai daremenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol zaug Barnabas dual Aikoniam uzan Zuda duailel agal gotulanemen zaueim simai, Antiok ban uzan guzenemen sul, duailel Uwait nugau Ze gusig marena, duailel asiu, Zuda duailel mui, emgasag ipal ebuan duailel mui, go goagal oiagab Yesus en petak emenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bo, Zuda duailel ipal goagal oiagab petak ab tam, goagen emgasag ipal ebuan duailel agal oiagab asai marena, go Kristen duailel en aiag sisilemen. ");
INSERT INTO bmh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bo, Pol zaug Barnabas dual go Aikoniam uzan ziwas huia daimai, Uwait nugau Ze duailel gusig maremenin. Guzenaimai, Uwait nug gonugau ougab naliu mui eiman go isanaraimai, gusig marena, gugeg beu beu memenin. Go guzenina, Uwait nug duailel gonugau ze petak pet tapaimareun. ");
INSERT INTO bmh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Uzanan duailel go unum atalaimai, Yesus nugau ze oi aidanemen dudu ipal sesamaremenin, duailel ipal go Zuda duailel agal igul sesamoremenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Guzenaimai, Zuda duailel ipal mui, emgasag ipal ebuan duailel mui, goagal dudu banban ereg gotulaimai, goagen Yesus nugau ze oi aidanemen dudu eg maraimai, aiwag sil ugarebi, noumamam aimai dabilemenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Yesus nugau ze oi aidanemen dudu go ze go doimai, Likonia agaig agal ban uzan aliag wanimag Listra mui Derbe mui ipal em uzan go waugab uminai wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Go ebu go Yesus nugau Ze Naliupet duailel maremenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra uzanan du tub go gonugau arab ubuneun mui dareun. Go anag nug arab ubuneun mui soligweun, gonun, go aidabun iborain tam. ");
INSERT INTO bmh_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Go hoboi daimai, Pol nug Uwait nugau Ze mareun doi dareun. Pol gue du gonugau ougab petak eun abe maimai, go naliu usalabun iboin, gusig uligaimai, duailel ameagab ebu aureun, “Na asaib, em e tapen.” Pigai, du go gonugau arab ubuneun silikaimai, em tapeun. ");
INSERT INTO bmh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Duailel gugeg go Pol nug meun uligaimai, goagal ze eiman gusig ulaimai, enemen, “Igual em Uwait go du sul alaloimai, ig ebiligeb alemen.” ");
INSERT INTO bmh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Guzenaimai, goagen Barnabas wanib go Sus emenin. Pol go ze maraneun du, gonun, gonugau wanib Hermes emenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Go em Uwait Sus nugau ula dacaneun du, gonugau zobu zau uzan go uzaneim dareu, go ze go doimai, bulumakau zawai ipal mui, a sisil iweiu naliu mui oimai, uzan gilan waugab zoun. Gonugau duailel mui Yesus nugau ze oi aidanemen dudu go agal wanimag ebu agaimai, ulagwag marabun zomenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Yesus nugau ze oi aidanemen dudu Barnabas zaug Pol dual, go igul go mabun dabilei daimai, goagal oiagab eg waimai, goagal tibur galau bigagaimai, pigai duailel go ula beteimai, awaremen, “Igual zaiger, ag igul go einen mabun dabilemen? Ig du ag sul, ig em Uwait tam. Ig e ebu Uwait nugau Ze naliu awarabun alemun. Ag polu wes go semoroiban, Uwait go awau dacaneu, go nug emes mui, em mui, ibut ze mui, ece unum patai meun, goen tutak agal oiagab petak an. ");
INSERT INTO bmh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Getal gonug duailel ein igul guzenabun tapelab tam. ");
INSERT INTO bmh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bo, Uwait go wagemab tam, gonug ig igul naliu abai miganeu. Gonug ze palautina, nuna, agal ougem ee ug naliu walu zuna, ee zaimai, ag siksikanemen.” ");
INSERT INTO bmh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yesus nugau ze oi aidanemen dudu aliag agen duailel go egun biz ebu agaimai, ig ulapigwag i migen aimai awaremenin. Bo, duailel go igul guzenina, agen go kuatai ze awarabun salau gusig pet mina, go igul go utemenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Guze guzenina, Zuda dudu ipal Antiok ban uzan Pisidia agaig ebuan mui, Aikoniam uzanan alaimai, duailel goagen goagal oiagab tutak mabun ze maraimai, goagal dabeleu koli kekulai maraimai, guzenai awaremenin, “Ag dudu go aiwag sil wagaran.” Guzenai awarina, goagen Pol aiwag sil wemenin. Guzenaimai, goagen go noumeu dabeleimai, go uzaneim patai keuai noimai hamacemen. ");
INSERT INTO bmh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bo, duailel goagal oiagab petak emen go Pol waugab zoimai, talioroi katai darena, Pol gue asaimai, uzan go koli sieun. Nineimai, umaseu, Barnabas zaug Pol dual go Derbe uzan wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol zaug Barnabas dual go Derbe uzan daimai, Uwait nugau Ze Naliupet marena, duailel asiu goagal oiagab ailaimai, Yesus sesamoremenin. Guzenaimai, Pol zaug Barnabas dual go koli Listra uzan beteimai, go eiman koli Aikoniam uzan beteimai, go eiman Antiok ban uzan Pisidia agaig betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Guzenaimai, go duailel goagal oiagab gusig maraimai, goagal oiagab petak emen i utabun aimai dabeleu gusig maremenin. Goagen awaremen, “Ig unum Uwait nugau gumigabun uzan siabun uhu asiu oimai simam.” ");
INSERT INTO bmh_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Go uzan tutak tutak ebu beteimai, duailel oiagab petak emen abai ereg gotulaimai, duailel goagen gumarabun dudu tapai maremenin. Go ziwas ipal ebu, ee ur maimai, Uwait auraimai, go Uwait nugau ebeg ebu maremenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia agaig go unum aidaimai, go koli Pampilia agaig ebu alemenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Uwait nugau Ze Perga uzanan duailel maraimai, Atalia uzan nomen. ");
INSERT INTO bmh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Go uzanan tebil wag koli Antiok uzan betemenin. Uzan tub getal duailel goagen Uwait nugau ougab naliu mui eiman go isanarabun aurina, Yesus nugau ze duailel marabun palautaremen, salau go ag ulis unum poemenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Go Antiok ban uzan alaimai, duailel goagen oiagab petak emen go igul unum guzenemenin mui erunai Uwait nug emgasag ipal ebuan duailel oiagab petak abun abu abai mareun en awaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Go ziwas huia, duailel goagal oiagab petak emen go abai daremenin. ");
INSERT INTO bmh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Dudu ipal agen Zudia agaig eiman Antiok ban uzan alaimai, oiagab petak emenin duailel awaremenin. “Go Moses nug kasai ze sikut weun goagal enimag galau kuatina, abu tutak go eiman sag Uwait nug go muzmuz dabun imaramau.” ");
INSERT INTO bmh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol zaug Barnabas dual ze go doimai, oiagab eg wina, dudu go abai ze ebu alalemenin. Guzenaimai, go ebuan dudu agen dudu banban ipal mui, Pol zaug Barnabas dual mui, ze go Yesus nugau ze oi aidanemen dudu mui, dudu banban Zerusalem uzan darem simai awarabun tapai maremenin. ");
INSERT INTO bmh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Duailel agen palautarena, go Ponisia mui, Samaria agaig beteimai, emgasag ipal ebuan duailel goagal oiagab ailemenin, emgasag go ebuan duailel goagal oiagab petak emen awaremenin. Go ze go doimai, goagal oiagab siksikemenin. ");
INSERT INTO bmh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Go Zerusalem uzan sina, dudu go oiagab petak emen mui, Yesus nugau ze oi aidanemen dudu mui, dudu banban mui, goagen uligaraimai, siksikemenin. Pol zaug Barnabas dual agen Uwait nug go abai salau meun unum awaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bo, Parisi dudu ipal oiagab petak emen agen asaimai, enemen, “Emgasag ipal ebuan dudu ag Uwait nugau Ze sesamorabun, agal enimag galau kuataimai, Moses nugau kasai ze unum sesamoramam.” ");
INSERT INTO bmh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Guzenina, Yesus nugau ze oi aidanemen dudu mui, dudu banban mui, gotulaimai, ze go suban sisiai piabun guzenemenin. ");
INSERT INTO bmh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ze go marai mai, Pita nug asaimai, awareun, “Izal zaiar, ag abiu, getal Uwait nug ag ula iz emgasag ipal ebuan duailel gonugau ze marabun tapai mileun. Guzenaimai, ag han Uwait nugau Ze Naliupet doimai, agal oiagab ailabun iboin pet. ");
INSERT INTO bmh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Uwait go duailel agal oiagab oug abiu. Guzenaimai, go nug agal oiagab petak emenin peimai, ig Ah Wes migeun sul ag han guzenaital maramau. ");
INSERT INTO bmh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Go nug ig ag beu beu siwei igab tam, go agal oiagab petak emenin, gonun, go nug agal oiagab oug igul eg zilagai mareun. ");
INSERT INTO bmh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Guzenaimai, ag einen Uwait polumurabun uhu banou duailel agal oiagab petak emenin goagal enimag ebu memen? Getal igual ataniger mui, ig mui, uhu go gamacabun iborain tam pet. ");
INSERT INTO bmh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ag go don, Yesus nug gonugau ougab naliu mui eiman ig isanigena, igual oigeb petak emun, gonug ig imaigabun guzenemun sul, go han imarabun guzenaital guzenamau.” ");
INSERT INTO bmh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Duailel unum soai darena, Barnabas zaug Pol dual, agen goagal ebeag sil Uwait nug gugeg beu beu emgasag ipal ebuan duailel ebu mareun ze awarina, doi daremen. ");
INSERT INTO bmh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Go unum ze mai poina, Zems, Yesus nugau amag, nug koli eneun, “Zaiar, ag izal ze go don. ");
INSERT INTO bmh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon-Pita nug go ulis Uwait nug amegai emgasag ipal ebuan duailel go en dabilaneu awareun, gonun duailel ipal gonugau tapai mareun. ");
INSERT INTO bmh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","16","Getal Uwait nugau ze doimai, awarenemen dudu agen guzenaital anemen. Ag guzenemen, ‘Uwait nug eneun, “Aiu ses koli alaimai, Devit nugau zau go koli mai. Iz zau go unum eg wai meun koli suban mai. ");
INSERT INTO bmh_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Guzenaimai, emgasag ipal ebuan duailel go han Dubanou Ban sesamoraimai, duailel go izanag tapai maremin.” ");
INSERT INTO bmh_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Go getal duailel ze go awareun, go domenin.” ");
INSERT INTO bmh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Guzenaimai, Zems nug ze mai beteimai, eneun, “Go izal dabeleu, ig emgasag ipal ebuan duailel agal oiagab Uwait waugab alabun uhu i marab. ");
INSERT INTO bmh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bo, ig go sikut wai maraimai, guzenai awarab, ag ee em Uwait nugau wanib eiman ulagwag moroimai, ee maramam go i zan. Einen, ee go unu mui. Ag egun dudu ipal agen beguranag olinaranemen egun go i zan. Ag eseu han i zan. Ag wal igul i mabun aimai sikut wai marab. ");
INSERT INTO bmh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ig abiu uzan tutak tutak Moses nugau kasai ze ziwas umkoskos zobu ziwas ebu gotulanemen zaueim nanalai marena, duanem. Guzenaimai, emgasag ipal ebuan duailel unum abiu igul go iwanarai sag Zuda duailel ameagab ebu eg pet. Gonun, ig ze go sikut wai marab.” ");
INSERT INTO bmh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Guzenaimai, go ebuan Yesus nugau ze oi aidanemen dudu mui, dudu banban mui, uzanan duailel go agal oiagab petak emen mui, goagen ze pataimai, goagal dudu ipal tapai maraimai, Barnabas zaug Pol dual ereg palautarabun dabilemen. Goagen Zudas, gonugau wanib tub Barsabas, Sailas dual tapai maremenin. Dudu aliag go dudu ipal agal ameagab ebu igul naliu mui dacanemen. ");
INSERT INTO bmh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Go guzenai sikut waimai, palautemenin, O igual zaiger, ig Yesus nugau ze oi aidanem dudu mui, e ebuan dudu banban mui, igual oigeb ag en siksikaimai, ag igual zaiger emgasag ipal ebuan dudu Antiok uzan daremen mui, Siria agaig daremen mui, Silisia agaig daremen sikut wai maraimai, ‘Umaseu’ awarem. ");
INSERT INTO bmh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ig domun, igual dudu ipal agen beteimai, enimag galau kuatabun ze awaremen domenin, ze go en agal oiagab eg weun. Bo, iguan ag ze go betei ag marabun awarab tam. ");
INSERT INTO bmh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Guzenaimai, ig unum gotulaimai, dudu aliag ag awarabun palautaremun. Go igual zaiger Pol zaug Barnabas dual ereg bitamam. ");
INSERT INTO bmh_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pol zaug Barnabas dual go Yesus nugau salau mina, dudu ipal agen ugarebi, noumabun dabilemenin. Bo, ag goagal doropag en ban dabilab tam. ");
INSERT INTO bmh_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Guzenaimai, iguan Zudas, Sailas dual ag waiagab palautarem. Goagal oiagsau eiman sikut e wai marem sul guzenaital awaramam. ");
INSERT INTO bmh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Uwait nugau Ah Wes ig imaig darena, ig uhu ipal ag i maramam. Igul e iwanarai sag guzenan. ");
INSERT INTO bmh_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Dudu ipal em Uwait ipal ulapagwag marabun egun aganem, egun go i zan. Ag eseu han i zan. Ag egun dudu agen beguranag olinaranemen egun go i zan. Ag wal igul i macan. Ag ze go sesamoramamen, ag go naliu damamen. Go sag, am ban naliu, suban dacan. ");
INSERT INTO bmh_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dudu go tapai maremenin palautarena, Antiok beteimai, duailel goagal oiagab Yesus en petak emenin gotularaimai, agau go sikut wemenin maremen. ");
INSERT INTO bmh_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Duailel go sikut wemen goagal oiagab selai dabun nanalaimai, go banban siksikemen. ");
INSERT INTO bmh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Zudas Sailas dual go Uwait nugau ze doimai, awaranemen dudu aliag, gonun, duailel goagal oiagab petak emen ze asiu awaraimai, goagal oiagab gusig maremenin. ");
INSERT INTO bmh_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Uzan tub ziwas huia daimai, uzanan duailel go suban dabun ze awaraimai, Yesus nugau ze oi aidanemen dudu waiagab palautaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Bo, Sailas go Antiok uzan dabun dabeleu oun. ");
INSERT INTO bmh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol zaug Barnabas dual go ziwas huia, Antiok daimai, go dudu ipal abai, duailel Uwait nugau Ze abai maremen. ");
INSERT INTO bmh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ziwas huia daimai, Pol nug Barnabas aureun, “Ig koli beteimai, uzan go beu beu getal Uwait nugau Ze abai maremun, igual Kristen zaiger go iboi darem ta, erunai darem piarabun bitap.” ");
INSERT INTO bmh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Go guzenina, Barnabas nug Zon-Mak imai bitabun aneun. ");
INSERT INTO bmh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bo, Pol nugau dabeleu go Zon-Mak imai bitab uteun. Getal go abai Pampilia agaig daimai, salau poab tam, go utaraimai, koli gonugau uzan waneun. Guzenaimai, Pol nug Zon-Mak imai bitab uteun. ");
INSERT INTO bmh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Agtal banban ze alalaimai, beu beu wanemenin. Barnabas go Zon-Mak imai aimai, tebil ebu Saiprus waug uzan betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol go Sailas imai aimai, utei unabun, gonun, duailel goagal oiagab petak emenin, goagen Dubanou Ban nug go ag isanarabun gonugau ebeg ebu moitaraimai, waneun. ");
INSERT INTO bmh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Go Siria agaig mui Silisia agaig ebuan oiagab petak emenin dudu gusig mara marai beteun. ");
INSERT INTO bmh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol go Antiok uzan uteimai, Derbe uzan eiman betei, koli Listra uzan beteun. Du tub gonugau wanib Timoti, gonugau ougab Yesus en petak eun uzan go dareun. Gonugau anag han gonugau ougab petak eun, go Zuda air. Timoti nugau memeg go Grik du. ");
INSERT INTO bmh_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra uzanan Kristen duailel, Aikoniam uzanan Kristen duailel mui, agen Timoti nugau igul naliu anem. ");
INSERT INTO bmh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Guzenaimai, Pol nug Timoti imai ereg unabun aimai, gonugau enib galau kuatai moroun. Go ebuan Zuda duailel go abiu Timoti nugau memeg go Zuda du tam, gonun, Pol nug Zuda duailel go oiagab eg i ugamau aimai, igul go meun. ");
INSERT INTO bmh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Go unum ban uzan aidaimai, getal Yesus nugau ze oi aidanemen dudu mui, dudu banban mui, Zerusalem uzan ze pataimai, sikut wemen ze go duailel oiagab petak emenin go awaremen. Go ze go sag sesamorabun aimai awaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Guzenaimai, duailel goagal oiagab petak emenin gusig maraimai, ziwas tutak tutak duailel ipal oiagab ailaimai, Kristen duailel asiu usalemen. ");
INSERT INTO bmh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol gonugau zaugul abai Prigia agaig, Galesia agaig ebu sag beteimai, Uwait nugau Ze duailel maremenin. Go ibut ze tubaiman bitabun iborain tam, einen, Uwait nugau Ah Wes nug Esia agaig tubaim Uwait nugau Ze i betei awaran aimai kuatai ze mareun. ");
INSERT INTO bmh_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Go betei Misia agal em be ebu beteimai, go Bitinia em ebu siabun guzenemenin. Bo, Yesus nugau Ah Wes nug kuatai ze marena, em go ebu siab tam. ");
INSERT INTO bmh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Guzenaimai, go Misia emgasag zilacoroi beteimai, Troas uzan nomen. ");
INSERT INTO bmh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Troas uzan noimai, umaum, Pol wabilai sul uligeun, Masedonia agaig ebuan du tub nug ameg ebu zoi, tapai daimai, aureun, “Na ibut ze matelaiba, Masedonia alaiba, ig isanigen.” ");
INSERT INTO bmh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol go wabilai uligaimai, aigina, igual esab suban maimai, Masedonia agaig betemun. Igual dabeleu go Uwait nug agaig go ebuan duailel Uwait nugau Ze Naliupet awarabun uligeun. ");
INSERT INTO bmh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ig tebil tub oimai Troas uzan uteimai, Samotres em ebu beteimai, uzan go ninemun, umaseu, Neapolis uzan betemun. ");
INSERT INTO bmh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Go eiman Masedonia agaig agal ban uzan wanib Pilipai betemun. Go ban uzan Rom agen gumaranem. Ig uzan go ziwas ginamtal daremun. ");
INSERT INTO bmh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Imabun ziwas ebu, uzan go uzaneim ze gasageim nomun. Ig ze go gasag duailel agal Uwait aurabun empip dareu aimai, dabeleimun. Ig noimai hoboi darena, ailel ipal gotulabun alina, iguan Uwait nugau Ze maremun. ");
INSERT INTO bmh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Go ebu air tub dareun. Gonugau wanib Lidia, go Taiataiara uzanan. Air gonugau salau go tibur galau naliu pet ubia gonugau uzanan oimai, aiwag en maraneu. Air go gue Uwait ulagwag muraneu, guzenaimai, Dubanou Ban nug gonugau ougab im oitina, Pol nug Uwait nugau Ze meun suban doi dareun. ");
INSERT INTO bmh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Guzenaimai, air gonug gonugau atagul abai, gonugau salau duailel gonugau zaueim daremen go unum Pol nug ze ziwareun. Guzenaimai, air go nug ig aigeun, Iz Dubanou Ban en oiab petak em ag iz ibail izal zau beteimai, ee zab ta?” Guzenai aigaimai, gusig ze migena, ig go sesamorai betemun. ");
INSERT INTO bmh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ziwas tub ebu, ig Zuda duailel gotulaimai, Uwait auranem uzan bete beteimai, abu ebu salau air tub go wes eg mui tuloromun. Air go wes eg mui ein igul aiu ses zumau duailel awarina, gonugau gumanemen dudu agen aiwag asiu dudu ipal ebuan wanemen. ");
INSERT INTO bmh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Air gonug Pol nugau zaugul abai ereg sesamarai beteimai, enai uleun, “Dudu ag Uwait Banou, Mesgai wag dareu, nugau salau dudu. Ag Uwait nug erunai koli imarabun ze marai aidanem.” ");
INSERT INTO bmh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Air go ziwas umkoskos sesamarai ze go mina, Pol nug salau air go en bisou peimai, kekulaimai, wes eg go aureun, “Iz Yesus nugau wanib ebu, aizem, na air go uteiba, alien!” Guzenina, wes eg ziwas go ebutal air go uteimai, waneun. ");
INSERT INTO bmh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Air go gumanem dudu go air go koli salau maba, aiwag wabun iborain tam aimai dabeleimai, aiag sisilina, Pol zaug Sailas dual gusig pataremenin. Guzenaimai, goagen dudu aliag go, dudu banban gotulai daremen goagal ameagab ebu pataraimai abai betemenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Go dudu banban ameagab ebu imaraimai beteimai, enemen, “Zuda dudu e agen igual uzanan duailel ze gugeg beu awaraimai, goagal oiagab asai maremenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Goagen igul beu beu duailel abai maremenin. Igul go igual kasai ze sesamorab tam. Ig Rom emgasag ebuan duailel, gonun, ig igul go dudu aliag go agen guzenemen ig i sesamoramam.” ");
INSERT INTO bmh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Guzenaimai, duailel agen Pol zaug Sailas dual bigegwaimai, apiparemen. Guzenina, ze sisiaranemen dudu banban agen malai dudu awarina, goagal tibur galau oi heimai, esalau sul ugabun awaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Go gusig esalau sul ugaimai, hiacaranem zau oug hiacaraimai, zau gumaneun du go gue dudu aliag suban gumarabun gusig ze auremenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Zau gumaneu du go goagal gusig ze doimai, dudu aliag go zau tub empip ula dareu oug hiacaraimai, goagal aramag gusig kiai maraimai, zau im gusig gebei memenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Umaum ula ebu Pol zaug Sailas dual go Uwait ulagwag moroimai, kabal wai daremenin. Hiacaranem zauan dudu ipal go ereg zau oug daremen go doi daremen. ");
INSERT INTO bmh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Pigaital, mim banou zoimai, hiacaranem zau go unum iloialoieun. Guzenina, zauan go zau im nugtal oiteun. Go us han, dudu ebeagab ebu kiai memen nugtal golosai heun. ");
INSERT INTO bmh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Zau gumaneun du, go asaimai, zau im unum oitai heun peimai, gonugau dabeleu hiacaranem zauan dudu unum uminai wanemen aimai, gonugau maulzag huia oimai, nugtal gonugau enib wamoroi dabeleun. ");
INSERT INTO bmh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Guzenina, Pol nug ulaimai, eneun, “Ei! Ig uminai unab tam, ig unum darem, na nagtal nait enim i wen.” ");
INSERT INTO bmh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Guzenaimai, zau gumaneun du nug dudu ipal awarina, al oi zuna, go uminaimai, betei Pol zaug Sailas dual aramag waiagab taubib weun. ");
INSERT INTO bmh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Guzenaimai, go nug uzaneim imarai noimai, awareun, “Du banban aliag, iz ein igul memin, Uwait nug iz koli imailamau?” ");
INSERT INTO bmh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Goagen koli auremen, “Nait ounab Yesus en tutak petak emen, Uwait nug nait atanar mui koli imaramau.” ");
INSERT INTO bmh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Guzenaimai, goagen Uwait nugau Ze gonugau atagul mui marena, domenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Umaum, du go nug hiacaranem zau ebuan imarai noimai, goagal suiag unum otoi mareun. Guzenaimai, nug mui gonugau atagul abai ereg Pol nug ze ziwareun. ");
INSERT INTO bmh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Gonug Pol zaug Sailas dual gonugau zaueim imarai beteimai, ee marena, zemenin. Go gonugau atagul abai Uwait en oiagab petak emen, gonun, goagal oiagab oug siksikemenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Umaseu, Rom agal dudu banban agen malai dudu palautarena, betei hiacaranem zau gumaneun du auremen, “Dudu aliag go utaremen, unamam.” ");
INSERT INTO bmh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Guzenaimai, zau gumaneun du nug Pol aureun, dudu banban agen go hiacaranem zau utarebi, unamam emen go awarem, “Go utei unan. Agal oiagab selai mui unan!” ");
INSERT INTO bmh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pol nug malai dudu awareun, “Ig igul eg tub mab tam, bo, ig duailel ameagab ebu gaul esalau sul iguemen. Ig Rom emgasag ebuan dudu. Ig hiacaranem zau oug heigemen ulis wage wageimai palautigabun dabelem ta? Tam pet! Rom agal dudu banban agtal alaimai, ig palautigebi, unamam.” ");
INSERT INTO bmh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Malai dudu go agen beteimai, ze go Rom agal dudu banban awaremenin. Ag Pol zaug Sailas dual Rom emgasag ebuan dudu ze domenin abe maraimai, go uminemenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Guzenaimai, agtal beteimai, bisomagar mui aimai, dudu aliag go uzaneim imarai noimai, awaremen, “Ag e uzan i dacan.” Guzenai awaraimai, palautaremenin. ");
INSERT INTO bmh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol zaug Sailas dual go zau uteimai, Lidia nugau zau betemenin, Go ebu beteimai, dudu oiagab petak emen gusig dabun ze awaraimai, utarai wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol zaug Sailas dual Lidia nugau uzan uteimai, Ampipolis uzan siemen. Go Ampipolis uzanan betei, Apolonia uzan betemenin. Go uzan go han uteimai, Tesalonaika uzan zomen. Zuda agal gotulanemen zau tub dareu ebu siemen. ");
INSERT INTO bmh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol go gue gotulanemen zaueim simai, zobu ainarai uzan go daimai, umkoskos uzan ipal guzenaneu sul, go Uwait nugau Ze nalalaimai, petak pet abai marabun awareun. ");
INSERT INTO bmh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Go nug Uwait nugau Ze nanalaimai, zebigeg awareun, “Uwait nug Yesus go mu banou oimai, noumaimai, koli asabun tapai meun. Yesus go iz ulis gonugau ze awarai darem, go Kristus, du go Uwait nugtal ig imaigabun tapai maimai, palautoroun.” ");
INSERT INTO bmh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Zuda duailel ipal go Pol nugau ze petak aimai, Pol zaug Sailas al tulemen. Grik duailel ipal go Uwait nugau Ze sesamoranem mui, ailel banban ipal han, Yesus en oiagab petak emen. ");
INSERT INTO bmh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Zuda dudu ipal go igul go peimai, go goagal oiagab eg warai, ban abu ebu beteimai, dudu igul eg macanemen imarena, dudu egeg go agen duailel ipal agal oiagab asai maremenin. Guzenaimai, go Zeson nugau zaueim beteimai, Pol zaug Sailas dual duailel agal ameagab ebu imarai alabun betei zau talioroi katoromen. ");
INSERT INTO bmh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Go dudu aliag go piarab tam, gonun, goagen Zeson nugau zau og unum silai heimai, zaueim simai, Zeson mui dudu ipal goagal oiagab petak emen imaraimai, uzanan dudu banban ameagab ebu tapai maraimai, enemen, “Dudu go Pol zaug Sailas dual go emgasag unum igul eg mai aidanem. Go ulis igul go mabun igual uzan zomen. ");
INSERT INTO bmh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Guzenaimai, Zeson nug gonugau zaueim marendai, daremen. Go Sisar nugau ze i sesamoranemen. Goagen guzenai ananem, ‘Emgasag ebu gumigabun du tub dareu, gonugau wanib Yesus.’” ");
INSERT INTO bmh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Duailel mui dudu banban mui ze go doimai, goagal oiagab eg weun. ");
INSERT INTO bmh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Uzanan dudu banban agen, Zeson mui, dudu oiagab petak emen mui, go aiwag asiu kot gau mabun mina, utarina, unamam aimai, awaremen. Guzenaimai, go koli goagal zau wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Umaum go ebu, dudu goagal oiagab petak emen agen Pol zaug Sailas dual wageimai palautarena, Beria uzan betemen. Go Beria uzan simai, Zuda agal gotulanemen zaueim siemen. ");
INSERT INTO bmh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria uzanan Zuda duailel goagal igul naliu, goagal igul nug Tesalonaika uzanan duailel goagal igul zilarai darem. Go Uwait nugau Ze doimai, oiagab siksikaimai, Pol nug Uwait nugau Ze ziwas umkoskos nanalaneu, gonugau ze petak abe mabun agtal Uwait nugau ze suban nanalanem. ");
INSERT INTO bmh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Guzenaimai, Zuda duailel asiu uzan go darem goagal oiagab petak emen. Grik dudu banban ipal mui goagal ailel banban go han goagal oiagab Yesus en petak emen. ");
INSERT INTO bmh_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Dai dai, Zuda duailel Tesalonaika uzan daremen go Pol Beria uzan Uwait nugau Ze marai daren ze doimai, go uzan go simai, duailel goagen Pol zaug Sailas dual zamarabun oiagab asai maremen. ");
INSERT INTO bmh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Guzenaimai, go ebuan dudu oiagab petak emen agen Pol palautina, uzan tub ibut ze gasageim dareu ebu waneun. Sailas zaug Timoti dual go sag Beria uzan daremen. ");
INSERT INTO bmh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Dudu go Pol imai Atens uzan beteimai, go koli Beria uzan bitabun ina, Pol nug Sailas zaug Timoti dual pigai betei go tularaimai, gusig ze awarabun awarina, ze oi betemen. ");
INSERT INTO bmh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","17","Pol go Atens uzan beteimai, Sailas zaug Timoti dual unabun gumarai dai dai, uzanan em uwait go agal doropag asiu goagal ebeag sil patai memen peimai, go bisomagar piareun. Guzenaimai, ziwas umkoskos, Pol go Zuda duailel agal gotulanemen zaueim beteimai, Zuda dudu mui, emgasag ipal ebuan duailel goagal oiagab petak emen Uwait nugau Ze abai mareun. Go igwanem empip ebu beteimai, duailel inen alanem Uwait nugau Ze maraneu. ");
INSERT INTO bmh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Go awarina, tapaimaranemen dudu ipal goagal wanimag Epikurian dudu mui, Stoik dudu mui, go zuna, Pol al ze ebu alalemenin. Go Yesus noumeun koli waseun ze marai dareun, ipal agen enemen, “Zemeu du go ein ze zemai, aidareu?” Dudu ipal agen enemen, “Go emgasag ipal ebuan em Uwait wanib ebu zemai, aidareu.” ");
INSERT INTO bmh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Guzenaimai, goagen Pol imai aimai, Areopagus gotulanemen uzan ze sisiaranemen dudu banban ameagab ebu imai beteimai, enemen, “Ig ze awau go nagen duailel maranem memen, ig dumam. ");
INSERT INTO bmh_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nait ze ipal ig domun awau, gonun, ig oigeb putputeu, ig ze awau go zebigeg suban aigemen doimai, abe mamam.” ");
INSERT INTO bmh_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atens uzanan duailel mui, emgasag ipal ebuan duailel go dacanemen go unum umkoskos ze awau mina, doimai, go salau tub i macanemen. ");
INSERT INTO bmh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Guzenaimai, Pol nug Areopagus uzanan dudu banban ameagab ebu asaimai, eneun, “Atens uzanan duailel, iz ag uligaremin, agal oiagab agal em uwait ulapagwag marabun oiagab petak banou pet macanemen. ");
INSERT INTO bmh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Iz agal zobu pianemen ebu aidanemin, iz agal em uwait ulapagwag maranemen biz ebu guzenai sikut wai memen uligaremin. Biz tub ebu ag guzenai sikut wai memen ‘Em uwait e go ig gonugau wanib i abiu nugau biz.’ Ag go Uwait i abiu ulagwag muranemen, gonun, iz Uwait go gonugau ze awaramoroi. Gonugau wanib Uwait. ");
INSERT INTO bmh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Uwait nug em e ebu ece unum dareu go gonug patai meun. Go Emes mui, em e mui, goagal Banou. Go zobu zau dudu agen memen ebu i dacaneu. ");
INSERT INTO bmh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Duailel goagen esab tub murabun iborain tam, einen, esab unum gonugau. Go gonugtal wes awau, esab ipal unum mui, duailel nugtal maraneu. ");
INSERT INTO bmh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ig duailel ulis e darem, Uwait nug du tutak ebuan patigai mina, go ug ebuan pouina, em e unum iborabun migeun Uwait nugtal ziwas mui uzan dabun mui tapai maimai, patai mareun. ");
INSERT INTO bmh_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Uwait nugtal gugeg go meun. Einen, dudu goagen pulig dareu aimai i itanamamen, bo, Uwait go pulig dab tam, go ig waigeb dareu. ");
INSERT INTO bmh_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ig ulis go al daimai, go nug gusig migena, em e ebu dacanem. Getal agal abiu macanemen dudu agen guzenai sikut wemen, ‘Ig han ig gonugau gelegul.’ ");
INSERT INTO bmh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Guzenaimai, ig Uwait nugau gelegul darem, gonun, igual dabeleu agal Uwait go gol, silva aiwag sul aimai i dabilan. Dudu agen agal dabeleu eiman ebeag sil patai memen aimai i dabilan. ");
INSERT INTO bmh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Getal dudu ag igul go ag i abiu, gonun, ag esab asiu ulapagwag mabun patai mina, Uwait nug ag eg marab tam. Ulis Uwait nug em e ebuan duailel unum goagal oiagab ailabun aimai ze gusig mareu. ");
INSERT INTO bmh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Go ziwas tub duailel unum sisiarabun tapai meun dareu. Ziwas go ebu go nug duailel agal igul sisiamau. Go subantal sisiaramau. Uwait nug du tub sisiarabun tapai meun. Du go noumina, Uwait nug koli usai meun. Guzenaimai, ig abiu go petak.” ");
INSERT INTO bmh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Duailel ag Pol nugau ze dudu noumemen asamam en ze doimai, dudu ipal goagen peimai welemen, ipal agen enemen, “Ig koli ze go aigemen, dumam.” ");
INSERT INTO bmh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ag agal oiagab petak ab tam, gonun, Pol go gotulai daremen ebuan utaraimai, waneun. ");
INSERT INTO bmh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Dudu ipal go ula darem, go Pol nugau ze sesamoraimai, goagal oiagab petak emenin. Du tub gonugau wanib Dionisius, go Areopagus uzanan du banou mui, air tub gonugau wanib Daimairis mui, duailel ipal abai ereg goagal oiagab petak emen. ");
INSERT INTO bmh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pol go Areopagus uzanan dudu banban ameagab ebu ze marai maziaimai, Atens ban uzan uteimai, Korin ban uzan beteun. ");
INSERT INTO bmh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","3","Go ebu Zuda du tub tuloroimai, go al dareun. Du go gonugau wanib Akwila, Pontus agaig ebu ban meun. Gonugau wau wanib Prisila dual, go Rom ban uzanan ulis alemen, einen, Sisa-Klodius nug gonugau emgasag ebu Zuda duailel i damam, unamamen aimai awarina, go Rom ban uzan utei wanemenin. Guzenaimai, Pol go gue Zuda du gonugau wau dual piarabun beteimai, go abai dareun. Go salap zau patai maimai, dudu ipal maraimai, aiwag wanem. Go Pol nugau salau macaneu sul, gonun, go abai salau go mai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pol nug Imabun ziwas ebu gotulanemen zaueim, Zuda duailel mui Grik duailel agal oiagab ailabun ze umkoskos maraneun. ");
INSERT INTO bmh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailas zaug Timoti dual go Masedonia agaig eiman Pol waugab betena, Pol go salau tub mab tam, go Uwait nugau Ze tutak Zuda duailel Yesus go Kristus aimai awareun. ");
INSERT INTO bmh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Zuda duailel ipal go gonugau ze duabun uteimai, ze biabial kuina, go nug goagal igul eg abai marabun gonugau tibur galau ebuan emwaibul esues kueceimai, awareun, “Uwait nug ag eg marabun aba, go izal uhu tam, go agal uhu. Izal oiab naliu darena, ulis iz emgasag ipal ebuan duailel Uwait nugau Ze awarabun bitai.” ");
INSERT INTO bmh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Guzenaimai, go utaraimai, betei du tub wanib Titius-Zastus nugau zau beteun. Go Uwait ulagwag muraneu du. Gonugau zau Zuda duailel agal gotulanemen zau waugab dareun. ");
INSERT INTO bmh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Gotulanemen zau go gumaneu du gonugau wanib Krispus, gonugau ug mui, Korin duailel ipal mui, go Pol nugau ze doimai, oiagab petak aimai, go Pol nug ze ziwareun. ");
INSERT INTO bmh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Umaum tub, Dubanou Ban nug Pol wabil eiman sul aureun, “Na i uminen, izal ze duailel awarabun i uten. ");
INSERT INTO bmh_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Iz na ibaiz darem. Du tub nug na ibaiz iwai maimai, eg i mizamau, einen, izal duailel asiu go uzan e darem.” ");
INSERT INTO bmh_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Guzenaimai, Pol go gue uzan wai tutak geil wasolig sag daimai, duailel Uwait nugau Ze abai marai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","13","Rom agal dudu banban agen du tub wanib Galio, go Grik emgasag gumabun tapai moromen. Go emgasag go gumaneun ziwas ebu Zuda duailel koli gotulaimai, Pol gusig pataimai, ze sisiaranemen dudu banban waiagab imai beteimai, enemen, “Du e go igual duailel Uwait ulagwag murabun igul atai abai maraneu. Ig gonugau ze sesamoraimai, ig Sisar nugau kasai ze i sesamoramam.” ");
INSERT INTO bmh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol nug koli awarai ina, Galio nug Zuda duailel awareun, “Ag Zuda duailel, go don! Du e go igual emgasag ebuan kasai ze tub utab tam. Go igul eg pet tub mab tam. Go igul go meun zob, iz agal ze petak awarem zob. ");
INSERT INTO bmh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Bo, go agal kasai ze en alai ailemen, go agtal suban macan. Iz ze go i duai.” ");
INSERT INTO bmh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gonug guzenai awarina, Zuda dudu ipal palautarena, uzaneim nomen. ");
INSERT INTO bmh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Uzaneim noimai, go aiag sisilina, du tub go goagal gotulanemen zau gumaneu du wanib Sostenes gusig pataimai, Galio nugau zau waugab gaul wemen. Galio gue igul go guzenemen go dabeleu asiu i oun. ");
INSERT INTO bmh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol go Korin uzan ziwas umkoskos duailel goagal oiagab petak emen abai daimai, tebil oimai, utaraimai, Siria agaig bitabun dabeleun. Prisila gonugau gamu Akwila dual go Pol al ereg betemen. Pol go tebil wag siab tam ebu, Senkria uzan Zuda agal igul sesamoraimai, gonugau gagalig gulum meun. Go igul tub guzeneun, einen, Uwait dual baib pateun. ");
INSERT INTO bmh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Epesus uzan zoimai, go ebu Prisila gamu Akwila dual utaraimai, Pol nugtal Zuda duailel goagal gotulanemen zaueim Uwait nugau Ze marabun en waneun. ");
INSERT INTO bmh_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Goagen go ziwas asiu go abai ereg dabun auremen, go nug awareun, “Iz ag abai ereg ban i dai,” aimai, awareun. ");
INSERT INTO bmh_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Go unabun aimai, guzenai awareun, “Uwait nug koli e ebu alen ailaba, iz petak alai.” Guzenaimai, go tebil oimai, Epesus uzan uteimai, Sisaria uzan beteun. ");
INSERT INTO bmh_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Go Sisaria uzan beteimai, Zerusalem ban uzan simai, duailel oiagab petak emen ze awarai maziaimai, Antiok uzan koli waneun. ");
INSERT INTO bmh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol go Antiok uzan ziwas asiu daimai, waneun. Go Galesia agaig mui, Prigia agaig ebu uzan beu beu aidaimai, duailel goagal oiagab petak emen gusig mara marai ai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Zuda du tub go gonugau wanib Apolos, go Aleksandria ban uzan go daimai ban meun, go Epesus uzan zoun. Go ze naliu macaneu, go Uwait nugau Ze unum suban abe meun. ");
INSERT INTO bmh_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Dudu ipal agen Yesus nugau igul suban abai morona, go nug koli Yesus nugau ze tuguiai duailel ipal abai mareun. Bo, go Zon nugau ze ziwaraneun igul tutak go abiu. ");
INSERT INTO bmh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Go Zuda duailel agal gotulanemen zaueim simai, go duailel uminarab tam. Uwait nugau Ze gusig mareun. Guzenina, Prisila gamu Akwila dual go gonugau ze doimai, goagal zau imai beteimai, Yesus nugau ze ipal go i abiu goagen go suban abai moromen. ");
INSERT INTO bmh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos go Uwait nugau Ze Akaia agaig marabun unabun dabilena, Epesus uzanan Kristen duailel agen gonugau dabeleu gusig morona, Akaia agaig ebuan Kristen duailel go imabun aimai, sikut wai morona, oimai beteun. Guzenaimai, agaig go ebu, Apolos nug beteimai, Uwait nug gonugau ougab naliu mui eiman duailel isanarena, goagal oiagab petak emen, duailel go suban isanareun. ");
INSERT INTO bmh_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Go duailel ipal agal ameagab ebu, Zuda dudu abai ze ze maimai, gonug Uwait nugau Ze nanalaimai, abai mareun, petak Yesus go Kristus, du go gue Uwait nug palautina, go imarabun aleun. ");
INSERT INTO bmh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","2","Apolos go Korin ban uzan Akaia agaig darena, Pol go Prigia agaig uteimai, aidai dai betei, Epesus ban uzan zoun. Go ebu, dudu ipal oiagab petak emen gotularaimai, kanabareun, “Ag agal oiagab petak aimai, Uwait nugau Ah Wes omen ta?” Goagen koli auremen, “Ah Wes dareu ig i abiu.” ");
INSERT INTO bmh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Guzenina, Pol nug koli kanabareun, “Ag ein igul eiman dudu ze ziwaremen?” Goagen koli enemen, “Ig Zon nugau igul eiman sesamoraimai, ze ziwigemen.” ");
INSERT INTO bmh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol nug koli eneun, “Getal Zon nug duailel goagal igul eg ebuan kekulina, ze ziwareun. Gonug duailel du go ulis alai dareu, go en goagal oiagab petak abun aimai guzenai awareun. Du go gue Yesus.” ");
INSERT INTO bmh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Go ze go doimai, Yesus en oiagab petak emen duailel ipal abai marabun dudu ipal ze ziwemenin. ");
INSERT INTO bmh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol nug gonugau ebeg duailel goagal tabaiag patena, Uwait nugau Ah Wes go ebalagab zuna, goagen emgasag ipal ebuan ze beu beu go getal i abiu go eiman Uwait nugau wanib ulagwag moromen. ");
INSERT INTO bmh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Duair unum go begurug sag guzenai sul. ");
INSERT INTO bmh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol geil ainarai uzan go daimai, go Zuda duailel agal gotulanemen zaueim simai, umkoskos Uwait nugau Ze petak abe mabun gusig ze awareun. Go abai daimai, Uwait em e alai gumabun ze unum marai dareun. ");
INSERT INTO bmh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Duailel ipal goagal oiagab gusig mina, go gonugau ze duabun uteimai, enemen, “Go Dubanou Ban nugau Abu sesamorabun ze tapaimigeu ze go polumaraneu.” Guzenina, Pol go utaraimai, go nug Yesus en oiagab petak emen duailel imarai, Tiranus nugau ze macanemen empip zaueim betemen. Pol nug ziwas tutak tutak duailel abai ze sisianeun. ");
INSERT INTO bmh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol go wai aliag igul go guzenina, Zuda duailel go mui, Grik duailel Esia agaig dacanemen mui, go unum Uwait nugau Ze domen. ");
INSERT INTO bmh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Uwait nug Pol nugau ebeg ebu gugeg banou beu beu meun. ");
INSERT INTO bmh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Duailel igul go uligaimai, goagen bam zig mui, tibur galau ogog ipal mui, oimai, Pol nugau enib gagoroimai, ebeu dudu waiagab beteimai, go ebalagab mina, ebeu eg mui, wes eg go ebalagab daremenin utei unanem. ");
INSERT INTO bmh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Zuda dudu ipal agen han betei aidaimai, wes eg oiabun, go Yesus nugau wanib pataimai, wes eg zilagai oiabun guzenemen. Ipal agen wes eg awaranem, “Iz Yesus, du go, Pol nug awaraneu, gonugau wanib ebu ag pigai unabun gusig awarem.” ");
INSERT INTO bmh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Zuda agal Uwait ula dacaneun du banou tub wanib Skeva, gonugau gelegul kwali sag agen igul go guzenanem. ");
INSERT INTO bmh_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bo, ziwas tub ebu wes eg go nug awareun, “Iz Yesus zaug Pol dual abiu. Ag inen?” ");
INSERT INTO bmh_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Du go gue wes eg eiman aigsisilaimai, dudu kwali sag ugaraimai, eg maraimai, goagal tibur galau unum bigagai marena, burum goagal zau eiman uminai wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Zuda duailel mui, Grik duailel go Epesus uzan dacanemen ze go doimai, unum banban uminemen. Guzenaimai, goagen Yesus nugau wanib wag pet ulagwag banou moromenin. ");
INSERT INTO bmh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Duailel goagal oiagab petak emen goagen zoimai, goagal igul eg guzenanemen unum araog memen. ");
INSERT INTO bmh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Dudu ipal getal eten macanem go goagal agau oug oz ze sikut wemen dareu unum oi alaimai, duailel goagal ameagab ebu ab banou oug agaremenin. Go agau go dudu ipal maremen zob, go aiwag asiu tausen houhou wasolig (60,000) kina sul wabun iboin pet. ");
INSERT INTO bmh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Uwait nugau Ze emgasag unum iboraimai, gusig pet e zoun. ");
INSERT INTO bmh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Igul go unum guzenaimai, Pol go Masedonia agaig mui, Akaia agaig eiman beteimai, Zerusalem ban uzan bitabun dabeleun. Gonugau dabeleu eiman eneun, “Iz go ebu beteimai, Rom ban uzan han betei piai,” eun. ");
INSERT INTO bmh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Guzenaimai, go nug Timoti zaug Erastus dual gonugau salau isanuranemen dudu aliag palautarena, Masedonia agaig betena, nug Esia agaig ziwas asiu dareun. ");
INSERT INTO bmh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ziwas go ebu, dudu ipal go Uwait nugau abu sesamorabun uteimai, ze ze ebu alalemen. ");
INSERT INTO bmh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Du tub gonugau wanib Demitrius, go aiwag tub wanib silva ebuan esab ipal patai macaneu. Gonug aiwag go silva eiman em uwait go wanib Artemis nugau zobu zau dorog ginaginam asiu patai mina, dudu ipal agen gau mina, go ebuan aiwag asiu waneu. Guzenaimai, go nug dudu asiu silva salau mai maraimai, aiwag banou waneu. ");
INSERT INTO bmh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Gonug dudu go abai dudu esab asiu patai macanemen mui, gotularaimai, awareun, “Zaiar, ag abiu igual aiwag naliupet asiu salau go eiman zuaneu. ");
INSERT INTO bmh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Du go wanib Pol nug ein ze macaneu agtal doiban, sisian. Gonug enaneu, dudu agen go agal ebeag sil em uwait dorog patai macanemen, esab go polu wes. Guzenaimai, go nug Epesus uzan mui, Esia agaig ebuan duailel asiu pet unum awarina, gonugau ze tutak sesamorem. ");
INSERT INTO bmh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Go Pol nugau ze nug igual aiwag salau eg migabun iborain pet. Go sag tam, duailel agen air go Artemis igual em uwait banou nugau zobu zau koli i ulagwag muramamen. Air go duailel unum Esia agaig mui, em go unum ulagwag muranemen, gonugau gusig poamau.” ");
INSERT INTO bmh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Duailel go ze go doimai, aiag sisilina, gusig ulaimai, enemen, “Epesus uzanan em uwait Artemis go igual Banou.” ");
INSERT INTO bmh_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Uzanan duailel unum aiag sisilina, dudu ipal agen Gaius zaug Aristarkas dual, Masedonia agaig ebuan dudu aliag Pol al ereg aidanemen, gusig pataraimai, goagal gotulanemen empip banou ebu keuarai betemen. ");
INSERT INTO bmh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol go nugtal duailel ameagab ebu bitabun dabeleun, bo, duailel goagal oiagab petak emen goagen kuatai ze aurina, uteun. ");
INSERT INTO bmh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Dudu banban ipal go Pol nugau zaugul, goagen han ze palautaimai, auremen, “Na uzan go duailel gotulanemen ebu i beten.” ");
INSERT INTO bmh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Duailel unum pie pie aimai, go ze beu beu ulina, duailel asiu ipal agen einen gotulemen go i abiu. Go gaul ulai daremen. ");
INSERT INTO bmh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Zuda dudu agen Aleksanda duailel ameagab ebu suina, sieun, gonun, dudu ipal agen go zebigeg duabun, dabilemen. Guzenaimai, Aleksanda nug duailel soebiag, ze mabun aimai gonugau ebeg sil soan aimai awareun. ");
INSERT INTO bmh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Go Zuda du peimai, abiu maimai, go oiagab tutak maimai, koli koli ulaimai, enemen, “Igual Artemis go Epesus uzanan Banou.” ");
INSERT INTO bmh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Dai daimai, ban uzanan gumaraneu du banou tub go zoimai, go nug duailel soabun awareun. Duailel unum soina, go nug guzenai awareun, “Epesus uzanan duailel, em e ebuan duailel unum abiu Epesus ban uzanan duailel agen Artemis Banou go nugau zau mui, gonugau dorog ulagwag macanemen Mesgai wageim noun mui, gumaranemen, go ag abiu. ");
INSERT INTO bmh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Guzenaimai, du tub nug go igul gue i abiu aimai i anamau. Guzenaimai, go soaimai, iau darenar. ");
INSERT INTO bmh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Agen dudu aliag e imarai alemen, bo, goagen zobu zauan esab tub zob wab tam. Igual em Uwait ze biabial kuai murab tam. ");
INSERT INTO bmh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bo, Demitrius gonugau salau zaugul abai go ze mui aba, sisiarabun empip dareu. Sisiarabun dudu darem. Go ebu betei ze mabun iboin. ");
INSERT INTO bmh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ag ze ipal mui aba, agal gumaranem dudu banban go gotulabun ziwas ebu, go ze go suban mamamen. ");
INSERT INTO bmh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ig ulis uhu wabun iboin, einen, ig ulis zebigeg tamacag gaul alalai darem. Rom gumaranem dudu agen ig uhu migamam. Einen, ig alalabun zebigeg ag awarabun iborain tam.” ");
INSERT INTO bmh_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Du banou gonug ze awaraimai, duailel palautarena, goagal uzan wanemenin. ");
INSERT INTO bmh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Go ze ebu alalemenin unum noumina, Pol nug duailel goagal oiagab petak emen gotularaimai, gusig dabun ze awaraimai, ‘Kero’ awaraimai, utarai Masedonia agaig waneun. ");
INSERT INTO bmh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Go agaig go eiman beteimai, duailel go ebuan gusig dabun ze mareun. Guzenaimai, go Grik emgasag beteun. ");
INSERT INTO bmh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Go ebu geil ainarai dareun. Gonugau esab suban maimai, Siria agaig tebil oimai, bitabun dabeleun. Zuda duailel agen go webi, noumabun ze doimai, koli Masedonia agaig bitabun dabeleun. ");
INSERT INTO bmh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Dudu ipal go Pol al wanemen goagal wanimag go ena: Pirus nugau nag, Sopater go Beria uzanan, Aristarkas zaug Sekundus dual go Tesalonaika uzanan, Gaius go Derbe uzanan, Tikikus zaug Tropimus dual go Esia agaig ebuan mui, Timoti han ereg betemen. ");
INSERT INTO bmh_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Dudu go amegai beteimai, Troas uzan ig gumigai daremen. ");
INSERT INTO bmh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pasowa Imabun ziwas maziaimai, ig Pilipai uzanan tebil wag utei beteimai, go ziwas tabkwai ebu Troas uzan tularemun. Ig go ebu betei, zobu tutak daremun. ");
INSERT INTO bmh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ginam zobu umaum, ig Uwait nugau ee zabun unum gotulemun. Pol nug duailel ze mareun. Go tuaba umaseu, uzan go utei unabun, gonun, go ze marai betei umaum ula ebu. ");
INSERT INTO bmh_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Al asiu usaimai, gotulanemen zaueim empip tub wag pet ig gotulai daremun ebu, unum asarai memen dareun. ");
INSERT INTO bmh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mogoi magun tub gonugau wanib Iutikus go wag zau wol abu ebu hoboi daimai, Pol ze marena, doi dareun. Iutikus go ames maimai, ames waugweun. Ames waugwina, zau wageim alai em nogoug ebu noi beteun. Dudu goagen noi imai aimai, pemen go noumeun. ");
INSERT INTO bmh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol go noimai, du go gonugau ebeg sil pataimai, ene