﻿USE sofia;
DROP TABLE IF EXISTS sofia.blzNT_vpl;
CREATE TABLE blzNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES blzNT_vpl WRITE;
INSERT INTO blzNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Koi kani'imari a susunganna puli ni Yesus Kristus, men lee' ni Daud ka' lee' ni Abraham. ");
INSERT INTO blzNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham tama ni Ishak, Ishak tama ni Yakub, Yakub tama ni Yehuda ka' utusna sambana, ");
INSERT INTO blzNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda tama ni Peres tii Zerah men i Tamar a sinana, Peres tama ni Hezron, Hezron tama ni Ram, ");
INSERT INTO blzNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram tama ni Aminadab, Aminadab tama ni Nahason, Nahason tama ni Salmon, ");
INSERT INTO blzNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon tama ni Boas men i Rahab a sinana, Boas tama ni Obed men i Rut a sinana, Obed tama ni Isai, ");
INSERT INTO blzNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai tama ni Tomundo' Daud. Daud tama ni Salomo. Sina ni Salomo iya'a boroki' ni Uria. ");
INSERT INTO blzNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo tama ni Rehabeam, Rehabeam tama ni Abia, Abia tama ni Asa, ");
INSERT INTO blzNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tama ni Yosafat, Yosafat tama ni Yoram, Yoram tama ni Uzia, ");
INSERT INTO blzNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia tama ni Yotam, Yotam tama ni Ahas, Ahas tama ni Hizkia, ");
INSERT INTO blzNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkia tama ni Manasye, Manasye tama ni Amon, Amon tama ni Yosia, ");
INSERT INTO blzNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia tama ni Yekhonya ka' utusna sambana. Raaya'a tumuo' na tempo lipu' Israel ni'atori na Babel. ");
INSERT INTO blzNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Noko daa lipu' Israel ni'atori na Babel, koi kani'imari a susunganna puli ni Yesus: Yekhonya tama ni Sealtiel, Sealtiel tama ni Zerubabel, ");
INSERT INTO blzNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel tama ni Abihud, Abihud tama ni Elyakim, Elyakim tama ni Azor, ");
INSERT INTO blzNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor tama ni Zadok, Zadok tama ni Akhim, Akhim tama ni Eliud, ");
INSERT INTO blzNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud tama ni Eleazar, Eleazar tama ni Matan, Matan tama ni Yakub, ");
INSERT INTO blzNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub tama ni Yusuf, ka' i Yusuf langkai' ni Maria men nangamea'kon i Yesus men uga' ngaanon Kristus. ");
INSERT INTO blzNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mbaka' ringkat ni Abraham pataka ni Daud isian koi sompulo' paat sunsun lee'. Ka' ringkat ni Daud pataka na tempo lipu' Israel ni'atori na Babel uga' isian koi sompulo' paat sunsun lee'. Kasi ringkat na tempo lipu' Israel ni'atori na Babel pataka ni Kristus uga' isian koi sompulo' paat sunsun lee'. ");
INSERT INTO blzNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Koi kani'imari a tundunan nongamea'an ni Yesus Kristus. Koo'po tia i Maria tii Yusuf men motondoloi iya'a nosuo', ni'inti'imo se' nampaiwawamo gause kuasana Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gause i Yusuf sa'angu' mian men sinampang minglimang men kana', mbaka' ia bude' mampapakamaa' i Maria na mian biai'. Ia mingkira' mansarak salan wuni-wuni bo pengerensai i Maria. ");
INSERT INTO blzNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pintanga' i Yusuf mompoo'inarutikon pingkira'na iya'a, notakamo a malaa'ikatna Tumpu na ipionna, ka' norobu taena, “Yusuf, lee' ni Daud! Alia i koo babata momosuo'i i Maria, gause anak men pimpaiwawakononna nosida tia kuasana Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria bo mangamea'kon sa'angu' anak moro'one. Anak iya'a tiodaa ngaanioon i Yesus, gause i Ia men bo pansalamatkon mian-Na na dosana.” ");
INSERT INTO blzNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kinosidana men koiya'a ni Yusuf tii Maria kada' sida a wurungna Tumpu koi men ia tadulkon nabii-Na men koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Imamat ini'imari! Sa'angu' laandue' men sianpo nontoo poobeel tia moro'one, bo mampaiwawa ka' bo mangamea'kon sa'angu' anak moro'one. Anak iya'a bo ngaanion i Imanuel.” Na wurung Ibrani, Imanuel aratina, “Alaata'ala mansambai i kita.” ");
INSERT INTO blzNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sarataa i Yusuf nowangon, ia nongololoikonmo koi men ia posuu'kon malaa'ikatna Tumpu na ipionna. Ia nosuo'mo tii Maria. ");
INSERT INTO blzNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kasee i Yusuf tii Maria sian nontoo poobeel pataka nongamea' a anak iya'a. Sarataa anak iya'a nongamea', Yusuf nangaanimo anak iya'a i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus nongamea' na kota Betlehem na libutan Yudea, na tempo batomundo'an ni Herodes. Tempo iya'a, isian toropii mian men isian pinginti'ianna na bitu'on, men ringkat na paraas bete'an taka na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Raaya'a waale'e-le'emari bapikirawar, taena, “Aana Anak iya'a men ningamea'kon bo pontomundo'i lipu' Yahudi? Kai nimiile' bitu'on-Na paraas bete'an, mbali' i kai notaka monsoosa' i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sarataa ia rongor i Tomundo' Herodes a panduungna mian men isian pinginti'ianna na bitu'on iya'a, tongkodi' tuu' i ia ka' uga' giigii' samba Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mbaka' ia rimpungmo a giigii' tanaasna imam ka' wawa ukum Toratna lipu' Yahudi bo pimikirawaranna se' maana bo ngamea'anna Tomundo' Pansalamatkon men ia toonkon Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mbaka' ia bantilkonmo i raaya'a taena, “Na Betlehem libutan Yudea. Gause isian wurungna Tumpu men ia tulis nabii koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Koo Betlehem men na tano' Yehuda, koo mase taasi' kota itiu'na na giigii' kota moola' sambana na Yehuda. Gause na ko'oom a ringkatanna sa'angu' tanaas men bo pantanaasi mian-Ku Israel.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Noko daa nongorongor tundunanna i raaya'a, mbaka' i Herodes nengeleelo'mo mian men isian pinginti'ianna na bitu'on iya'a, kasee lilu-lilung. Kasi ia pikirawari pore-pore se' maripi a nimiile'anna i raaya'a bitu'on iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Noko daa iya'a ai Herodes nomosuu'mo i raaya'a kada' mae' na Betlehem taena, “Rae' ka' sarak pore-pore a Anak iya'a. Sarataa tausionmuumo, bantilkon na ingku' kada' i yaku' uga' mae' ka' monsoosa' i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Sarataa nongorongor potoona tomundo' iya'a, raaya'a nomae'mo. Mbaka' nokampiile'anmo soosoodo a bitu'on men ia piile' i raaya'a na bete'an. Bitu'on iya'a nongolukonimo i raaya'a pataka notaan singintu tampatna Anak iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Raaya'a nobeles tuu' gause nimiile' bitu'on iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mbaka' i raaya'a ninsoopmo na laigan ka' nimiile' Anak iya'a tii Maria men sina-Na. Kasi i raaya'a nobanintuur ka' notumutuku' rumbuk tano' nonsoosa' Anak iya'a. Noko daa iya'a, raaya'a nombongkatimo tuuman ka' nongorookon na Ko'ona mosoni, kamangian ka' muur. ");
INSERT INTO blzNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gause Alaata'ala nomotoo i raaya'a na ipion kada' alia mule'kon waale'e ni Herodes, mbaka' i raaya'a nomule'konmo na lipu'na, kasee nuntutu' salan men sambana. ");
INSERT INTO blzNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sarataa noporus a mian men isian pinginti'ianna na bitu'on iya'a, Yusuf ningipimo nimiile' malaa'ikatna Tumpu men norobu taena, “Wangon ka' wawa a Anak kanono' tia sina-Na, pamarere ka' dodongo na Mesir pataka bantilkonon-Ku soosoodo na ko'oom, gause i Herodes bo mansarak ka' mampapatei Anak kanono'.” ");
INSERT INTO blzNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mbaka' nowangonmo i Yusuf, ka' rondompo iya'a ia wawamo a Anak iya'a tia sina-Na mamarere na Mesir. ");
INSERT INTO blzNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Raaya'a nodumodongomo indo'o pataka nolapus i Herodes. Sarataa ari Yusuf namarere na Mesir ka' komburi'na nileelo' umuar na Mesir, mbaka' nosidamo a wurungna Tumpu men ia tadulkon nabii-Na men koi kani'imari: “Yaku' mengeleelo' Anak-Ku kada' umuar na Mesir.” ");
INSERT INTO blzNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sarataa ia inti'i i Herodes se' mian men isian pinginti'ianna na bitu'on iya'a nangakalimo i ia, ia nomaso'mo tuu'. Mbaka' ia nomosuu'mo mampapatei giigii' anak morio' moro'one na Betlehem ka' na dodongoan sambana men pookarani'anna. Anak men nipapatei iya'a giigii' men umur rua' taun waaro'ona sintutu' tia tempo men ia inti'i na mian men isian pinginti'ianna na bitu'on. ");
INSERT INTO blzNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tempo anak morio' iya'a nipapatei, mbaka' nosidamo a wurungna Tumpu koi men ia tadulkon i Nabii Yeremia taena, ");
INSERT INTO blzNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nokamporongoranmo a ranggusna mian wiri na Rama, barananang ka' tumando' kasiongo'an. Rahel mingiwirii anakna kasee i ia kunda tia tata'uon, gause anakna iya'a nosianmo.” ");
INSERT INTO blzNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sarataa i Herodes nolapusmo, mbaka' malaa'ikatna Tumpu nintipiile'mo na ipionna i Yusuf tempo i ia dauga' na Mesir. ");
INSERT INTO blzNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Malaa'ikat iya'a norobu taena, “Wangon ka' wawa Anak kanono' tia sina-Na, kasi rae' na lipu' Israel, gause mian men nansarak mampapatei i Ia daa nokolapusmo.” ");
INSERT INTO blzNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mbaka' nowangonmo i Yusuf ka' nangawawa Anak iya'a tia sina-Na mae' na lipu' Israel. ");
INSERT INTO blzNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gause ia rongor i Yusuf se' i Arkhelaus, anak ni Herodes, nombolosimo tamana bo tomundo' na libutan Yudea, mbaka' ia nolayaonmo waara'a. Gause ia bantilkon Tumpu na ipion soosoodo, mbaka' ari Yusuf nomae'mo na libutan Galilea. ");
INSERT INTO blzNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Sarataa notaka na Galilea, raaya'a nodumodongomo na sa'angu' kota men ngaanon Nazaret. Sarataa nodumodongo na Nazaret, mbaka' nosidamo a wurungna Tumpu koi men ia tadulkonmo nabii men nuntundunkon Anak iya'a taena, “Ia bo ngaanon Samba Nazaret.” ");
INSERT INTO blzNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na tempo ari Yesus dauga' dumodongo na Nazaret, notakamo i Yohanes Pansarani na tano' maleas Yudea ka' nuntundunkon lelena Tumpu taena, ");
INSERT INTO blzNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Sosoli ka' kadarai a gau'muu men ba'idek gause Batomundo'anna Surugaa karani'mo!” ");
INSERT INTO blzNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanesmo iya'a men ia tundun i Nabii Yesaya taena, “Bo isian sa'angu' mian na tano' maleas mengeleelo'kon ka' mambantilkon taena, ‘Toropoti a salan bona Tumpu; loosikon a salan bo Ko'ona.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pakean ni Yohanes wuluna unta a niwawau, ka' boborna lolosna anit a niwawau. Kakaanna katumbang tia gurana wani'. ");
INSERT INTO blzNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Biai' a samba Yerusalem, mian na longkop libutan Yudea ka' uga' mian na longkop libutan men pookarani' Weerkauna Yordan taka ni Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Raaya'a nonsosoli ka' nangkadarai wawauna men sala', kasi ia sarani i Yohanes na Weerkauna Yordan. ");
INSERT INTO blzNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kasee tempo i Yohanes nimiile' se' biai' a mian Farisi tia mian Saduki men taka mikisarani, mbaka' ia norobumo na ko'ona i raaya'a taena, “Wee i kuu men koi lee'na ule ba'idek! Ime a men nambantilkon na ko'omuu se' i kuu sian kana'onna ukumanna Alaata'ala na ilio komburi? ");
INSERT INTO blzNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pipiile'kon a wawaumuu se' i kuu daa nonsosolimo ka' nangkadaraimo gau'muu men ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Alia mongooskon na noamuu se' i kuu daa bo tonsapu na ukuman montookon i Abraham daa pulimuu. Bantilkononku na ko'omuu se' watupo karaani'i sida wawauonna Alaata'ala bo lee' ni Abraham! ");
INSERT INTO blzNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Usong noko toropotmo bo pantara' kau pataka na wakatna. Sanda' kau men sian miwoo'kon woo' men pore sabole bo tara'ion ka' tibarkonon na apu. ");
INSERT INTO blzNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yaku' mansarani i kuu tia weer bo oosna se' i kuu daa nonsosolimo ka' nangkadaraimo gau'muu men ba'idek. Kasee moko daa i yaku' bo taka i Ia men dauga' labi i yaku' a kuasa-Na. Ia bo mansarani i kuu tia Alus Molinas ka' tia apu. Mangawawa sapato-Napo yaku' koo'. ");
INSERT INTO blzNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ia noko into-intonmo ikiran bo pantaapi giigii' gandum-Na pataka moloe'. Gandum bo soopkonon-Na na alang, kasee ota'na bo tunuon-Na na apu men sian pokoon papateion.” ");
INSERT INTO blzNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na tempo i Yohanes na Weerkauna Yordan, Yesus norumingkatmo na Galilea mae' mbaale'e na ko'ona. Taka inde'e, Ia nikisaranimo ni Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kasee i Yohanes nontopongi nangalia i Ia. Taena i Yohanes, “Bookoi se' i yaku' mba'a men tio saranion-Muu. Kasee kani'i, nongko'upa se' i Kuu a men notaka mikisarani na ingku'?” ");
INSERT INTO blzNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mbaka' ia simbati i Yesus tae-Na, “Sobii, sian kongupana, gause bookoi tio koiya'a kada' i kita mongololoikon tuutuu' koi men pingkira'na Alaata'ala.” Mbaka' i Yohanes nansaranimo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Noko daa nisarani, Yesus no'umuarmo na weer iya'a. Na tempo iya'a langit nokobongkatianmo ka' i Yesus nimiile' Alusna Alaata'ala men koi marampatii nalau na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kasi nokamporongoran a wurungna Alaata'ala nda'amari surugaa, tae-Na, “Ni'imo a Anak-Ku men kolingu'-Ku. Ia men daa kokana'-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Noko daa iya'a ai Yesus ia andaarkonmo Alus Molinas mae' na tano' maleas kada' bo topongionna Ibiliis. ");
INSERT INTO blzNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Patompulo' ilio patompulo' rondom i Yesus noba'apata, sian nokumaan. Mbaka' Ia nololumo. ");
INSERT INTO blzNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mbaka' Ibiliis notakamo mimitopongi i Yesus ka' norobu taena, “Gause i Koo Anakna Alaata'ala, mbaka' posuu' a watu karaani'i bi sida roti.” ");
INSERT INTO blzNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ia simbati i Yesus tae-Na, “Na Alkitaap isian nitulis koi kani'imari: ‘Mian taasi' tongko' tuo'kon roti, kasee tuo'kon giigii' wurung men ia wurungkon Alaata'ala.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Noko daa iya'a, Ibiliis nangawawamo i Yesus na Yerusalem, Kota Molinas, ka' nongowoot i Ia na wuunganna Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kasi Ibiliis norobu ni Yesus taena, “Kalu se' Koo Anakna Alaata'ala, alaka' tumbur waaro'o! Gause na Alkitaap isian nitulis koi kani'imari: ‘Alaata'ala bo momosuu' malaa'ikat-Na bo pandagai i Koo pore-pore. Raaya'a bo mantanai i Koo tia limana dako' saraat tontutup na watu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ia simbati i Yesus tae-Na, “Na Alkitaap isian uga' nitulis koi kani'imari: ‘Alia i koo mimitopongi Tumpu Alaata'alanta.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mbaka' ia andaarkonmo Ibiliis i Yesus lumopon na wawona buu'na men alayo' tuu', kasi ninsiso'kon na Ko'ona giigii' batomundo'an na tano' balaki' tiamo isiina men pore tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kasi Ibiliis norobu soosoodo taena, “Karaaro'o giigii' bo rookononku i Koo, kalu i Koo banintuur ka' tumutuku' rumbuk tano' monsoosa' i yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ia simbati i Yesus tae-Na, “Ibiliis! Rae' i koo. Gause na Alkitaap isian nitulis koi kani'imari: ‘Koo tio monsoosa' Tumpu Alaata'alanta, ka' tongko' i Ia a lolo'oon!’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Komburi'na Ibiliis somo nomae'. Kasi notaka a malaa'ikat toropii nangkalesang i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sarataa ia rongor i Yesus se' i Yohanes nitarungkumo, Ia namarereimo' Yudea ka' nomae' na Galilea. ");
INSERT INTO blzNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kasi Ia namarerei Nazaret ka' nodumodongo na Kapernaum, na soripi'na Danau Galilea men tonsoop libutan Zebulon ka' libutan Naftali. ");
INSERT INTO blzNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tempo i Yesus nangawawau men koiya'a, mbaka' nosidamo a wurungna Tumpu koi men ia tadulkon i Nabii Yesaya taena, ");
INSERT INTO blzNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tano' Zebulon ka' tano' Naftali, na salan mae' na tobui, na sambotakna Weerkauna Yordan. Ya'amo a Galilea men ia dodongoi mian biai' men taasi' samba Yahudi! ");
INSERT INTO blzNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mian men tumuo' na kapintungan nimiile'mo Ruar men tarang tuu'! Ka' lipu' men layaonkon lapus nimiile'mo Ruar men nobete'!” ");
INSERT INTO blzNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Muntumbei i Yesus dumodongo na Kapernaum, Ia nambantilkonmo na mian tae-Na, “Sosoli ka' kadarai a gau'muu men ba'idek, gause Batomundo'anna Surugaa karani'mo!” ");
INSERT INTO blzNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na sa'angu' tempo rae-rae' i Yesus moso'ole na Danau Galilea. Ia nimiile' rua' mian moto'utus men palimangonna i raaya'a pupuka' susum. Sa'angu' ngaanna i Simon men uga' dele leelo'on i Petrus, ka' sa'angu'na soosoodo i Andreas, utusna. Raaya'a pintanga' mumuka' susum na Danau Galilea. ");
INSERT INTO blzNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Taeni Yesus na ko'ona i raaya'a, “Mai i kuu, lolo' i Yaku' kada' poposidaon-Ku pumuka' mian.” ");
INSERT INTO blzNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Raaya'a liuliu namarerei puka'na ka' nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Noko daa iya'a ai Yesus nomae'mo. Kasi i Ia nimiile' soosoodo rua' mian moto'utus sambanaan men i Yakobus tii Yohanes, anak ni Zebedeus. Raaya'a pintanga' montotobo'i puka' tia tamana na lalomna duangan. Raaya'a rua' ira ia angemo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Raaya'a liuliu namarerei tamana ka' duangan, kasi nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus nomae'mo longkop libutan Galilea ka' nimisiso' mian na laigan bakitumpuan. Ia nengelelekon Lele Pore men mambantilkon Batomundo'anna Surugaa. Ka' i Ia uga' nengelesi'i biai' kaliangan nggeona mian ka' men sian maka'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Lele ni Yesus iya'a norumeebarmo longkop lipu' Siria, mbali' biai' a mian men taka na Ko'ona. Raaya'a mangawawa mian biai' men takaionna biai' kaliangan nggeo, ka' men munsuri repaan. Giigii' mian men lampingionna meena, mian men loka'on, ka' mian men repo', ia lesi'i i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mbaka' biai' tuu' a mian men nongololo' i Yesus na tempo iya'a. Isian men ringkat Galilea, ka' uga' men ringkat na Dekapolis, Yerusalem, Yudea, ka' isian uga' men ringkat sambotakna Weerkauna Yordan. ");
INSERT INTO blzNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sarataa i Yesus nimiile' mian biai' iya'a, Ia nolumoponmo mbaara'a buu'na. Tongko' sai oruang-Na, murit-Na nuntuu'imo i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mbaka' i Yesus nuntumbeimo nimisiso' i raaya'a tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Barakaatan a mian men talalais ka' tongko' mongooskon Alaata'ala, gause i raaya'amo a mianna Batomundo'anna Surugaa! ");
INSERT INTO blzNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Barakaatan a mian men noana masiongo', gause Alaata'ala bo mantata'u i raaya'a! ");
INSERT INTO blzNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Barakaatan a mian men mompopokoo' wakana, gause i raaya'a bo pontombonoi tano' balaki' kani'i! ");
INSERT INTO blzNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Barakaatan a mian men tongko' mingkira'kon mangawawau men kikira'na Alaata'ala, gause Alaata'ala bo mantarai men kikira'na. ");
INSERT INTO blzNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Barakaatan a mian men molingu'kon mian sambana, gause i raaya'a uga' bo kolingu'kononna Alaata'ala! ");
INSERT INTO blzNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Barakaatan a mian men molinas a noana, gause i raaya'a bo mimiile' Alaata'ala! ");
INSERT INTO blzNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Barakaatan a mian men mantakakon pooka'amatan, gause i raaya'a bo ngaanon anakna Alaata'ala! ");
INSERT INTO blzNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Barakaatan a mian men talalaison gause mingilimang koi men kikira'na Alaata'ala, gause i raaya'a men bo pontombonoi Batomundo'anna Surugaa! ");
INSERT INTO blzNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Barakaatan i kuu men irokion, talalaison, ka' potaekonon gause i kuu mongololo' i Yaku'! ");
INSERT INTO blzNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nabii men notuo' olukon uga' nitalalais koiya'a! Bi lewa' ka' beles i kuu, gause balaki' tuu' a tambona Alaata'ala men nitoropotikonmo na surugaa bo ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kuu mase timuson bona mian na tano' balaki'. Kalu timuson iya'a nalambasmo, sida mbali' wawauon ma'asing soosoodo? Sianmo kana'na saliwakon somo balo'konon ka' peepee'ionna mian. ");
INSERT INTO blzNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kuu uga' ruar bona mian na tano' balaki'. Sa'angu' kota na wawona buu'na sian pokoon bo lilungkonon. ");
INSERT INTO blzNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ka' uga' sianta mian men muntutungi boloak, kasi mansa'u tia gumbang. Kasee sabole uga' pokelaonna na sulaanna boloak iya'a kada' sida munguruari giigii' mian men na laigan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Koiya'a uga' a ruarmuu tiodaa kampiile'an na mian kada' i raaya'a mimiile' giigii' wawaumuu men pore, kasi muntunde' Tamamuu men na surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Alia i kuu mansarui se' i Yaku' notaka bo panganui ukum Torat ka' pisiso'na nabii. Yaku' notaka taasi' bo panganui, kasee bo pinsidakon giigii' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' kalu langit ka' tano' balaki' kani'i dauga' isian, sa'angu' hurup kabai se' titikpo na ukum Torat sian kosapuian, pataka giigii' men nitoonkon iya'a nisidakonmo. ");
INSERT INTO blzNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mbali' iya'a, ime a men mongkosiankon sa'angu'po men nipotookon na ukum Torat, mau mune' tongko' titiu', ka' mimisiso'kon mian sambana men koiya'a, mian iya'a bo mongoruangi oruangan men kando'ona tuu' na Batomundo'anna Surugaa. Kasee i ime a men mangawawau ka' mimisiso'kon mian sambana giigii' men nipotookon iya'a, ia bo mongoruangi oruangan men kanda'ana tuu' na Batomundo'anna Surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mbali' iya'a, bantilkonon-Ku na ko'omuu se' i kuu tio mingilimang po'uusna Alaata'ala labi tia limangna wawa ukum Torat ka' mian Farisi. Kalu sian, mbaka' i kuu sabole sian minsoop na Batomundo'anna Surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kuu ninginti'imo pisiso'na pulinta men koi kani'imari: Alia mampapatei mian. Ime a men mampapatei mian tio ukumon. ");
INSERT INTO blzNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kasee bantilkonon-Ku na ko'omuu se' ime a men maso'kon mian sambana, ia bo ukumon, ka' i ime a men munguduli mian sambana, ia tio ukumion na Mahkama Agama. Ka' kalu isian men mangaani mian sambana, ‘Pompon,’ tio soopkonon na leapna apu na naraka. ");
INSERT INTO blzNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mbali' iya'a, kalu i kuu pintanga' momokela kurbaan na mesba men na Laiganna Alaata'ala, kasee notonginau' se' dauga' isian mian men makitkon i kuu, ");
INSERT INTO blzNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","porena parerei kutung a kurbaan na mesba iya'a, kasi rae' pooka'amat tia mian iya'a. Moko daasi iya'a, kasi i kuu sida mule'kon soosoodo ka' momokela kurbaanmuu na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kalu isian mian mongowoot i kuu na pungukumi, kuu tio donga-dongan pooka'amat tii mian iya'a tempo i kuu dauga' potorae' na salan. Kalu sian, mbaka' i kuu wootonnamo mian iya'a na pungukumi, ka' pungukumi iya'a bo mongorookon i kuu na pulisi. Kasi pulisi bo monsoopkon i kuu na tarungkuan. ");
INSERT INTO blzNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' i kuu sian umuar na tarungkuan kalu giigii' samayamuu sianpo bontor.” ");
INSERT INTO blzNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kuu ninginti'imo pisiso' men koi kani'imari: Alia i kuu muntumpangkon samba-samba. ");
INSERT INTO blzNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kasee bantilkonon-Ku na ko'omuu se' ime a men mintioki sa'angu' wiwine ka' ningkikira'i, mbaka' i ia nuntumpangkonmo na noana. ");
INSERT INTO blzNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mbali' iya'a, kalu matamuu paraas uanan manggau'kon i kuu baradosa, kuati ka' balo'kon a matamuu inono'! Mbulokon sa'angu' sampana wakamuu anuion dako' wakamuu tibunta tibarkonon na naraka. ");
INSERT INTO blzNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kalu limamuu men paraas uanan manggau'kon i kuu baradosa, kolongi ka' balo'kon a limamuu inono'. Mbulokon sa'angu' sampana wakamuu anuion dako' wakamuu tibunta soopkonon na naraka.” ");
INSERT INTO blzNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Isian uga' pisiso' men koi kani'imari: Ime a men mengerensai boroki'na tio mantarai surat poorensaanna suo' bona boroki'na iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kasee bantilkonon-Ku na ko'omuu se' sanda' moro'one men mengerensai boroki'na kasee boroki'na iya'a sian nogora', langkai' men koiya'a minsidakon boroki'na muntumpangkon. Ka' moro'one men mosuo' tia wiwine men ia rensai langkai'na, moro'one iya'a uga' muntumpangkon.” ");
INSERT INTO blzNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kuu ninginti'imo uga' pisiso'na pulinta men koi kani'imari: Alia basumpa' men borek. Upa a men kuu toonkonmo na sumpa'muu na Alaata'ala, tio bo wawauonmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kasee bantilkonon-Ku na ko'omuu se' i kuu alia tia basumpa'. Alia basumpa' mau uga' mangaan langit, gause langit a oruanganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Alia basumpa' mau uga' mangaan tano' balaki', gause tano' balaki' a pimpee'anna Alaata'ala. Ka' alia basumpa' mangaan Yerusalem, gause Yerusalem kotana Tomundo' Balaki'. ");
INSERT INTO blzNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ka' uga' alia basumpa' mangaan takala'muu, gause i kuu sian momoko mompopobulak kabai se' mompopo'itom wuukmuu, maupo tongko' sansila'. ");
INSERT INTO blzNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kalu daa, bi ngaanon, ‘Daa’, kasee kalu sian, bi ngaanon, ‘Sian.’ Kalu saliwanakon iya'a, na ko'ona men gau'na ba'idek a norumingkatanna.” ");
INSERT INTO blzNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kuu ninginti'imo pisiso' men koi kani'imari: Mata bolosion tia mata, ka' wese' bolosion tia wese'. ");
INSERT INTO blzNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kasee bantilkonon-Ku na ko'omuu se' alia pangawaloskuu kalu mian mangka'idek i kuu. Tongko' kalu isian mian mangarapa' kasumpi'muu men paraas uanan, rookon soosoodo a kasumpi'muu men paraas kauri'. ");
INSERT INTO blzNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ka' kalu too isian mian men mongowoot i kuu na mian men bo pungukumi gause mingkikira'i bokukummuu, rookon uga' tia jubamuu. ");
INSERT INTO blzNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kalu isian sa'angu' mian mamparipari i kuu kada' mamasa'ankon wawana koi sa'angu' kilo a ko'oloana, pasa'ankon koi rua' kilo. ");
INSERT INTO blzNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kalu mian mama'ase' upa-upa na ko'omuu, tarai. Ka' alia i kuu sian mombolosii mian men mombolos upa-upamuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kuu ninginti'imo pisiso' men koi kani'imari: Kolingu'kon a simbaya'muu, ka' komakitkon a mian men maso'kon i kuu. ");
INSERT INTO blzNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kasee bantilkonon-Ku na ko'omuu se' kolingu'kon a mian men maso'kon i kuu, ka' sambayangkon a giigii' mian men mantalalais i kuu. ");
INSERT INTO blzNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Gause tia wawaumuu men koiya'a, nanasamo i kuu se' anakna Tamamuu men na surugaa. Gause Alaata'ala nompopobete' ilio bona mian men pore a noana tia uga' mian men ba'idek a gau'na. Ia mamalaukon usan bona mian men pore ka' uga' men ba'idek a gau'na. ");
INSERT INTO blzNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kalu i kuu tongko' mongkolingu'kon mian men mongkolingu'kon i kuu, bo upana Alaata'ala ka' mantarai tambo na wawaumuu men koiya'a? Taasi' uga' pagawena pajak minginti'i mangawawau men koiya'a? ");
INSERT INTO blzNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ka' kalu i kuu tongko' mangka'amat poto'utusanmuu, upa a poosasala'na tia lipu' men sian minginti'i Alaata'ala? Raaya'apo mangawawau men koiya'a! ");
INSERT INTO blzNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tamamuu men na surugaa mongkolingu'kon tuu' giigii' mian, sian momoosasala'kon. Mbaka' i kuu uga' tio koiya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Imamat pore-pore ini'imari! Alia i kuu mansalankon agama tongko' se' kada' bo piile'onna mian biai'. Kalu i kuu mangawawau men koiya'a, kuu sian mantausi tambo men rookononna Tamamuu men na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mbali' iya'a, kalu i kuu mantarai upa-upa na mian men talalais, sakat duupkonon popuukon koi wawauna mian men minti pa'a-pa'agama. Kikira'na i raaya'a men mangawawau koiya'a na laigan bakitumpuan ka' na bendar kada' bo koporekononna mian. Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' ya'amo a tambona men ia poko labotmo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kasee kalu i kuu mantarai upa-upa na mian, sakat inti'ionna limamuu men kauri' a upa men rookononna limamuu men uanan. ");
INSERT INTO blzNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Sai'muu iya'a rookon roko-rokot daamo, sakat inti'ionna mian. Tongko' Tamamuu na surugaa a ninginti'i. Mbaka' Tamamuu men mimiile' wawaumuu men sian piile'onna mian a bo pangawalos wawaumuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kalu i kuu sambayang, alia sambayang koi mian men minti pa'a-pa'agama. Kikira'na i raaya'a sambayang potokerer na laigan bakitumpuan ka' na gimpangna bendar kada' bo piile'onna mian. Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' ya'amo a tambona men ia poko labotmo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kasee kalu i kuu sambayang, pinsoop na tambin ka' ompori a soopan. Moko daa iya'a, kasi i kuu sambayang na Tamamuu na surugaa men sian piile'on. Mbaka' Tamamuu men mimiile' wawaumuu men sian piile'onna mian bo mangawalos wawaumuu. ");
INSERT INTO blzNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mbali' iya'a, kalu i kuu sambayang, alia tongko' muntundun men sian tabateanna koi lipu' men sian minginti'i Alaata'ala. Raaya'a mansarui too pa'ase'na bo loloikonon montookon sambayangna i raaya'a daa biai' taa'. ");
INSERT INTO blzNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kuu alia men koi i raaya'a. Gause koo'po tia i kuu nama'ase' na Tamamuu na surugaa, Ia noko pinginti'imo panduungmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mbali' iya'a, kuu tio sambayang koi kani'imari: ‘Tamamai na surugaa! Bi angga'ion a ngaan-Muu. ");
INSERT INTO blzNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Takakon a Batomundo'an-Muu kada' men kikira'-Muu bo lolo'on na tano' balaki' mongololo' koi men na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sulano taraion-Muu i kai kakaan men kosukupmai na ilio koini'i. ");
INSERT INTO blzNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kai miki'ampuni sala'mai koi i kai uga' mangampuni mian men isian sala'na na ko'omai. ");
INSERT INTO blzNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amo' dalaion i kai topongionna upa men mantakakon ba'idek, kasee oloakon i kai na giigii' iya'a. Gause i Kuu a Tomundo' men mungkuasai ka' angga'ion pataka sidutu. Amin.’ ");
INSERT INTO blzNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kalu i kuu mangampuni mian men isian sala'na na ko'omuu, mbaka' Tamamuu men na surugaa uga' mangampuni sala'muu. ");
INSERT INTO blzNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kasee kalu i kuu sian mangampuni sala'na mian na ko'omuu, Tamamuu na surugaa uga' sian mangampuni sala'muu.” ");
INSERT INTO blzNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ka' kalu i kuu ba'apata, ro'upmuu alia piile'on marepa koi mian men minti pa'a-pa'agama. Raaya'a mombolii dudusna kada' inti'ionna mian sambana se' i raaya'a pintanga' ba'apata. Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' ya'amo a tambona men ia poko labotmo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kasee kalu i kuu ba'apata, alaka' pirurup, kasi minamina'i a wuukmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tio koiya'a kada' daa sian inti'ionna mian se' i kuu ba'apata, kasee tongko' Tamamuu men sian piile'on a minginti'i wawaumuu. Mbaka' Tamamuu men mimiile' wawaumuu men sian piile'onna mian a bo pangawalos wawaumuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Alia i kuu mantambun kupang na tano' balaki', gause tongko' bo atakon ka' kaanonna araka. Ka' uga' mian puraga minsoop mamangan. ");
INSERT INTO blzNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kasee pantambun kupang na surugaa men daa sian atakon ka' sian kaanonna araka. Ka' uga' mian mamangan sian minsoop ka' mamangan. ");
INSERT INTO blzNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gause aana a kupangmuu mbaka' ino'o uga' a kokabusanna a noamuu!” ");
INSERT INTO blzNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mata mase boloakna waka. Kalu matamuu tarang, longkop wakamuu moruar. ");
INSERT INTO blzNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kasee kalu matamuu sian tarang, mbaka' pika' a wakamuu. Kalu ruarna wakamuu pika'mo, mbaka' wakamuu nopika'mo tuu'!” ");
INSERT INTO blzNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Sa'angu' mian sian sida balimang na rua' tanaas. Gause kalu koiya'a, ata' iya'a mongkomakitkon tanaas men sa'angu' ka' mongkolingu'kon men sambana. Kabai se' i ia momorongori tanaas men sa'angu' ka' sian momorongori men sambana. Koiya'a uga' i kuu. Kuu sian sida balimang bona Alaata'ala ka' bona kupang!” ");
INSERT INTO blzNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mbali' iya'a, bantilkonon-Ku na ko'omuu se' alia i kuu babatakon tutuo'muu, ka' upa men bo kaanon ka' inumonmuu. Alia babatakon wakamuu ka' upa men bo pakeonmuu. Taasi' uga' tutuo'muu a umangga'na tia kakaan, ka' wakamuu a umangga'na tia pakean? ");
INSERT INTO blzNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Piile' ansee a sapu' na lealaa. Raaya'a sian mangasok, sian mamadak, sian mantambun ka' manganaa' na alang. Kasee mau mune' koiya'a, Tamamuu men na surugaa mamakaan i raaya'a. Taasi' uga' i kuu a umangga'na tuu' tia sapu' iya'a? ");
INSERT INTO blzNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Isian mbali' i kuu men gause babata, ninsidakon umurmuu nokanturangan mau mune' tongko' titiu'? ");
INSERT INTO blzNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nongko'upa i kuu se' babatakon pakean? Piile' uga' a bunga men sian ni'asok. Ia sian balimang ka' sian mangawawau pakean, kasee pore a tutuo'na. ");
INSERT INTO blzNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bantilkonon-Ku na ko'omuu se' Tomundo' Salomopo men kupangon tuu' sian nopake men koi koporena bunga iya'a! ");
INSERT INTO blzNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Rakut na ale' tumuo' koini'i, kasee liila kabus tunuon. Mau mune' koiya'a, Alaata'ala namakei rakut iya'a men tamban pore tuu'. Upa mune' i kuu! Kasee i kuu sian laan parasaya! ");
INSERT INTO blzNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mbali' iya'a, alia babata ka' mangaan, ‘Upa a men bo kaanonta?’ ka' ‘Upa a men bo inumonta?’ kabai se' ‘Upa a men bo pakeonta?’ ");
INSERT INTO blzNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Giigii' iya'a sarakonna lipu' men sian minginti'i Alaata'ala. Kasee Tamamuu men na surugaa inti-inti'i se' i kuu mamaraluukon giigii' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kasee tukokon a Batomundo'anna Alaata'ala ka' upa-upa men kokana'na Alaata'ala, mbaka' giigii' men paraluukononmuu iya'a bo rookonon-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mbali' iya'a, alia i kuu babatakon ilio liila, gause Alaata'ala uga' bo muntulung i kuu ilio liila. Repaan men kuu suri sangilio tongko' bona ilio sangilio.” ");
INSERT INTO blzNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Alia i kuu mompoposala' mian dako' i kuu poposala'on. ");
INSERT INTO blzNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gause koi upa a pompoposala'muu mian, mbaka' koiya'a uga' a bo pansasala' i kuu. Ka' takalan men kuu takalkon bo takalkonon na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nongko'upa i kuu se' tongko' mimiile' pupu' na matana simbaya'muu, kasee balak na matamuu sian kuu inti'i? ");
INSERT INTO blzNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Koi upa a kosidana i kuu mangaan na simbaya'muu taemuu: ‘Mai yaku' anuikona a pupu' na mataam kanono'!’ poali isian balak na matamuu? ");
INSERT INTO blzNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wee i kuu men minti palo-paloos! Anui kutung a balak na matamuu kada' i kuu manasa mimiile', ka' sida manganui pupu' na matana simbaya'muu.” ");
INSERT INTO blzNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Alia i kuu mongorookon na au' upa men molinas dako' i kuu pimbalikionna ka' rungkabion. Ka' alia mongorookon mutiaramuu na bau' dako' peepee'ionna.” ");
INSERT INTO blzNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pama'ase', mbaka' i kuu taraion. Pansarak, mbaka' i kuu mantausi. Mikileaki, mbaka' omporon leakikonon i kuu. ");
INSERT INTO blzNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gause sanda' mian men mama'ase' bo taraion, ka' mian men mansarak bo mantausi, ka' mian men mikileaki omporon, omporon bo leakikonon. ");
INSERT INTO blzNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Na ko'omuu mbali' se' isian minti'i men mantarai anakna watu kalu anakna iya'a mama'ase' kakaan? ");
INSERT INTO blzNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kabai isian mbali' a men mantarai ule kalu anakna mama'ase' susum? ");
INSERT INTO blzNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mau mune' gau'muu malia' ba'idek, kasee sabole inti'ionmuu a men pore bo rookonon na anakmuu. Upa mune' Tamamuu men na surugaa! Ia mongorookon men pore na mian men mama'ase' na Ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Giigii' upa men kikira'muu wawauonna mian na ko'omuu, wawau uga' a men koiya'a na ko'ona i raaya'a. Ya'amo a tukona pisiso'na ukum Torat ka' kitapna nabii.” ");
INSERT INTO blzNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pinsoop na soopan men itiu', gause balaki' a soopan tia salan men mae' na kosilaka'an. Ka' uga' biai' a mian men minsoop lumiu na soopan balaki' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kasee itiu' a soopan ka' itiu' a salan mae' na tutuo' men pore. Ka' tongko' titiu' a mian men daa mantausi soopan tia salan itiu' iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Maka'amat i kuu na minti nabi-nabii. Raaya'a taka na ko'omuu koi domba, kasee men tuutuu'na i raaya'a serigala men minsilaka'i. ");
INSERT INTO blzNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Na wawauna a pinginti'ianmuu i raaya'a. Kau ruri'on sian miwoo'kon anggur. Ka' rakut ruri'on sian miwoo'kon ara. ");
INSERT INTO blzNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Koiya'a uga', kau men pore a tutuo'na miwoo'kon woo' men pore, ka' kau men ba'idek a tutuo'na miwoo'kon woo' men sian pore. ");
INSERT INTO blzNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kau men pore a tutuo'na sian miwoo'kon woo' men sian pore, ka' kau men ba'idek a tutuo'na sian miwoo'kon woo' men pore. ");
INSERT INTO blzNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Giigii' kau men sian miwoo'kon woo' men pore sabole bo tara'ion ka' tibarkonon na apu. ");
INSERT INTO blzNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mbaka' na wawauna minti nabi-nabii iya'a a bo pinginti'ianmuu i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Sian giigii' mian men mangaan i Yaku', ‘Tumpu! Tumpu!’ se' daa bo minsoop na Batomundo'anna Surugaa. Kasee men tonsoop, tongko' mian men daa mangawawau koi pingkira'na Tamang-Ku men na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na Ilio Pungukumian, biai' a mian men morobu koi kani'imari: ‘Tumpu! Tumpu! Taasi' uga' i kai nengelelekon potoona Alaata'ala nangaan ngaan-Muu? Taasi' uga' i kai numbuse'i meena ka' nangawawau biai' upa kosamba' nangaan ngaan-Muu?’ ");
INSERT INTO blzNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Na temposi iya'a kasi bo simbation-Ku koi kani'imari: ‘Yaku' sian nontoo inti'i i kuu! Rae' i kuu men tongko' mangawawau ba'idek!’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mian men mongorongor wurung-Ku ka' mongololo' men koiya'a, ia koi mian pande men momokerer laiganna na watu. ");
INSERT INTO blzNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na tempo usan kalu waa' tia baleba' mantakai laigan iya'a, laigan iya'a sian koruntun gause nipokerer na watu. ");
INSERT INTO blzNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kasee mian men mongorongor wurung-Ku see sian mongololo', ia koi mian bobo' men momokerer laiganna na bone. ");
INSERT INTO blzNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na tempo usan kalu waa' tia baleba' mantakai laigan iya'a, laigan iya'a sabole koruntun ka' kobaraba'ian!” ");
INSERT INTO blzNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sarataa i Yesus nangkakabusi pisiso'-Na, giigii' mian men nomorongor pisiso'-Na kodaawan. ");
INSERT INTO blzNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pimisiso'-Na koi mian men kuasaan ka' poosasala' tia pimisiso'na wawa ukum Toratna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sarataa i Yesus notumokuru nda'amari buu'na, biai' tuu' a mian nongololo' i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kasi notaka na Ko'ona sa'angu' mian men kustaon. Mian iya'a nobanintuurmo monsoosa' i Yesus ka' norobu taena, “Tuan, kalu i Kuu maloos, Kuu sabole sida mengelesi'i i yaku' kada' maloe' koi aturanna agama.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus nondoekonmo lima-Na, nongkoyong mian iya'a kasi norobu tae-Na, “Daa, Yaku' maloos. Bi poloe'mo i koo!” Tempopo iya'a uga', na'anumo a kustana mian iya'a ka' noloe'mo i ia. ");
INSERT INTO blzNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kasi i Yesus norobu na ko'ona tae-Na, “Imamatoon pore-pore! Alia i koo mambantilkon ni imepo. Kasee rae' na imam ka' pipiile'kon na ko'ona se' kustaam daa na'anumo. Moko daa iya'a kasi rookon a kurbaan koi men ia posuu'kon i Musa na ukum Torat kada' manasa na mian se' kustaam tuutuu' na'anumo!” ");
INSERT INTO blzNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sarataa i Yesus notaka na Kapernaum, taka a sa'angu' moomoola'na surudaduna Roma miki tulung na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Taena, “Tuan, tutulungingku repo' na laigan, somo toko-tokol. Ka' i ia marepa tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ia simbati i Yesus tae-Na, “Yaku' bo waale'e na laigaan mengelesi'i ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Taena moomoola'na surudadu iya'a, “Sobii Tuan, gause i yaku' kani'i mian men sian kana'na mangalabot i Kuu na laiganku. Tongko' ngaan toro santaa' daamo, kada' tutulungingku iya'a malesi'. ");
INSERT INTO blzNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gause i yaku' mian men posuu'on, ka' surudadu men kando'onana tii yaku' tio uga' mongololoikon posuu'ku. Kalu i yaku' momosuu' sa'angu' surudadu, ‘Rae'!’ mbaka' i ia sabole mae'. Ka' kalu i yaku' mengeleelo' men sambana, ‘Mai ka'ita!’ mbaka' i ia sabole taka. Kabai se' kalu yaku' momosuu' tutulungingku, ‘Limang a kani'i!’ mbaka' sabole uga' limangonna.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus samba' nomorongor men taena moomoola'na surudadu iya'a. Ia norobumo na mian men mongololo' i Ia tae-Na, “Tuutuu' mba'a. Ka' bantilkonon-Ku na ko'omuu se' na lipu' Israelpo Yaku' sianpo nontoo rumpaki mian men imaanan tuu' koi kaya'a! ");
INSERT INTO blzNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bantilkonon-Ku na ko'omuu se' mian biai' men ringkat paraas bete'an ka' paraas sopokan bo taka ka' umoruang kumaan ruru-ruru' tia ari Abraham, Ishak ka' i Yakub na Batomundo'anna Surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kasee mian men bookoi mianna Batomundo'anna Surugaa iya'a bo tibarkonon na kapintungan men pika' tuu'. Indo'o i raaya'a bo tumando' ka' marepa tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kasi taeni Yesus na moomoola'na surudadu iya'a, “Ule'konmo, ka' bi sida na ko'oom koi men koo parasaya.” Na tempopo iya'a uga', tutulungina nalesi'mo. ");
INSERT INTO blzNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesus nomae'mo na laigan ni Petrus. Sarataa notaka, Ia nimiile' monian ni Petrus men sinana boroki'na somo toko-tokol gause suminggar. ");
INSERT INTO blzNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus nongkoyongmo limana, mbaka' i ia liuliu nalesi'. Noko daa iya'a ia nowangonmo ka' nangkalesang i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sarataa guntumalommo, biai' a mian men lampingionna meena ia wawa mian waale'e ni Yesus. Meena iya'a tongko' ia buse'i Yesus tia wurung santaa', ka' nengelesi'i giigii' mian men manggeo. ");
INSERT INTO blzNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tempo i Yesus nengelesi'i mian, mbaka' nosidamo a wurungna Tumpu koi men ia tadulkon i Nabii Yesaya, taena, “Iamo a men bo pamasa'ankon repaanta ka' mengelesi'i nggeonta.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sarataa i Yesus nimiile' se' biai' a mian na tiku-tikum-Na, Ia nomosuu'mo murit-Na lumembet na sambotakna danau. ");
INSERT INTO blzNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kasi notaka a sa'angu' wawa ukum Torat ka' nobantil taena, “Guru, yaku' mingkira' mongololo' i Kuu mau maana a rae'an-Muu!” ");
INSERT INTO blzNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ia simbati i Yesus tae-Na, “Serigala isian bolo'na, ka' sapu' isian pimpeetaanna, kasee Anak Manusia sianta bo tokolan-Na.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kasi sa'angu' murit-Na norobu taena, “Tumpu, poturang i yaku' mule'kon kutung mae' mantanom tamangku.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kasee tongko' ia simbati i Yesus tae-Na, “Lolo' i Yaku', ka' patalai a mian lapus mantanom mianna i raaya'a men nolapusmo.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sarataa i Yesus nolumakit na duangan, murit-Na nongololo'mo i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ola-olan taka baleba' men makorong tuu' na danau iya'a, tamban duanganna i raaya'a paibamba'ionna bokol. Kasee i Yesus tongko' royot. ");
INSERT INTO blzNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mbaka' murit-Na nuntuu'imo ka' ninsimpu taena, “Tumpu! Kaba'on! Silaka'mo i kita!” ");
INSERT INTO blzNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ia simbati i Yesus tae-Na, “Nongko'upa mbali' i kuu se' layaon? Kuu sian laan mamarasaya i Yaku'!” Kasi i Yesus nokumekerer ka' nongkokundakon baleba' ka' danau iya'a kada' bi rokot. Kasi notodoo tuu' a danau iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Murit ni Yesus samba', taena, “Mian upa kaya'a, tamban baleba' tia danau momorongori i Ia?” ");
INSERT INTO blzNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesus notakamo na sambotakna danau iya'a, na dodongoanna lipu' Gadara. Indo'o isian mian rua' ira men ia lampingi meena ringkat na wangunan nomootuungi i Yesus. Rua' mian iya'a kolayaon, pataka sianta mian men momoko lumiu na salan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Raaya'a nangkakaro'kon taena, “Anakna Alaata'ala! Upaioonmo i kai kani'i? Koo too bo mantalalais i kai mau mune' koo'po tempona?” ");
INSERT INTO blzNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sian oloa indo'o isian bau' biai' men pintanga' mansarak kumaan. ");
INSERT INTO blzNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mbaka' meena iya'a nokumakaase' ni Yesus taena, “Kalu i Koo momosuu' i kai umuar, posuu' i kai balimba' na bau' karaatu'u.” ");
INSERT INTO blzNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mbaka' ia posuu'mo i Yesus tae-Na, “Rae'mo!” Noko daa koiya'a, no'umuarmo a meena iya'a, kasi ninsoop na bau'. Salulusan bau' iya'a kabus notumumbur na liu' waaro'o na danau, kasi nopate nolomos. ");
INSERT INTO blzNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pontondong bau' iya'a notumetende'mo na kota ka' nuntundunkon giigii' men nosida, ka' uga' nuntundun rua' mian men ia lampingi meena. ");
INSERT INTO blzNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mbaka' giigii' mian na kota iya'a nangarae'imo i Yesus. Sarataa nopoopiile' tii Yesus, raaya'a nama'ase' i Ia kada' mamarerei dodongoanna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Noko daa iya'a ai Yesus nolumakitmo na duangan ka' nolumembet na danau. Kasi i Ia notaka na kota men dodongoan-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tempo iya'a, isian mian nangawawa ni Yesus sa'angu' mian repo' men somo toko-tokol na ampasna. Sarataa i Yesus nimiile' se' i raaya'a parasaya tuu' na Ko'ona, Ia norobumo na mian repo' iya'a tae-Na, “Anak-Ku! Popotaan a noaam. Dosaam daa ni'ampunimo!” ");
INSERT INTO blzNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Toropii wawa ukum Torat men indo'o norobu na noana i raaya'a taena, “Wurungna mian kaya'a koi se' i Iamo a Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kasee i Yesus ninginti'i men na noana i raaya'a, mbali' Ia norobu tae-Na, “Nongko'upa i kuu se' mimikirkon upa-upa men ba'idek? ");
INSERT INTO blzNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aupa a daana, mangaan, ‘Dosaam daa ni'ampunimo,’ kabai se' mangaan, ‘Wangonmo ka' tumpang?’ ");
INSERT INTO blzNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kasee koini'i popo'inti'ikonon-Ku na ko'omuu se' na tano' balaki' kani'i Anak Manusia kuasaan mangampuni dosa.” Kasi i Yesus norobu na mian repo' iya'a tae-Na, “Wangonmo, nakat a ueraan ka' ule'kon na laigaan!” ");
INSERT INTO blzNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mbaka' nowangonmo a mian men repo' iya'a ka' nomule'kon na laiganna. ");
INSERT INTO blzNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mian biai' men nimiile' iya'a nolayaonmo. Kasi i raaya'a nuntunde' Alaata'ala gause nongorookon kuasa men balaki' tuu' na mian. ");
INSERT INTO blzNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sarataa i Yesus namarerei tampat iya'a, Ia nimiile'mo sa'angu' mian pagawena pajak men ngaanna i Matius. Ia oru-oruang na kantor pajak. Taeni Yesus na ko'ona, “Mai, lolo' i Yaku'!” Mbaka' ia norumingkatmo ka' nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pintanga' i Yesus kumaan na laigan ni Matius notakamo a mian biai' men pagawena pajak ka' mian dosaon. Raaya'a nokumaanmo tii Yesus ka' murit-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sarataa mian Farisi nimiile' se' koiya'a, raaya'a norobumo na murit ni Yesus taena, “Nongko'upa a Gurumuu se' kumaan poopooruru' tia pagawena pajak ka' mian dosaon?” ");
INSERT INTO blzNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nomorongor upa men ia porobukon i raaya'a, mbaka' ia simbatimo i Yesus tae-Na, “Taasi' mian malesi' a paraluu dokter, kasee mian men manggeo. ");
INSERT INTO blzNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gause i Yaku' notaka taasi' bo pengeleelo' mian men kana' a wawauna, kasee bo pengeleelo' mian dosaon kada' mongololo' i Yaku'. Mbali' iya'a, rae' ka' sarak kada' inti'ionmuu a aratina wurungna Tumpu men koi kani'imari: ‘Men kikira'-Ku mase isian polingu', taasi' kurbaan.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Noko daa iya'a, murit ni Yohanes Pansarani notakamo ni Yesus. Raaya'a nobapikirawarmo taena, “Kai tia mian Farisi ba'apata see nongko'upa a murit-Muu se' sian?” ");
INSERT INTO blzNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ia simbati i Yesus tae-Na, “Sida mbali' a sawe'na suo' moro'one masiongo' na posuo'anna kalu suo' moro'one iya'a dauga' indo'o tii raaya'a? Sabole sian! Kasee bo taka a tempona suo' moro'one iya'a bo alaon na ko'ona i raaya'a. Na temposi iya'a kasi i raaya'a ba'apata.” ");
INSERT INTO blzNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Sianta sa'angu'po mian a mantampalkon sangkeap toik u'uru na pakean men manau'mo. Gause kalu koiya'a, toik u'uru men pantampal iya'a sabole kumomput ka' memberak bokukum iya'a, mbaka' kaekae' dodoa a berakna. ");
INSERT INTO blzNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Koiya'a uga' sianta mian men mantawa' anggur u'uru na batutu' anit manau' men motopu'mo. Gause kalu koiya'a, batutu' anit iya'a sabole bo koberak, mbaka' anggurna kowuwus ka' batutu' anitna kobaraba'ian. Anggur men u'uru sabole naa'on na batutu' anit men u'uru kada' batutu' anit ka' anggurna rua-rua'na kototobo' pore.” ");
INSERT INTO blzNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pintanga' i Yesus mambantilkon men koiya'a na murit ni Yohanes, notakamo a sa'angu' tanaasna laigan bakitumpuan. Ia nonsoosa' i Yesus ka' norobu taena, “Anakku wiwine baasi nolapus, kasee sabole dauga' sida potuo'ion-Muu asar i Kuu taka ka' mengepetkon lima-Muu na ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mbaka' norumingkatmo i Yesus tia murit-Na, kasi nongololo' mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na tanga'na salan isian sa'angu' wiwine men sompulo'mo rua' taun mariingi'on men dodoa. Wiwine iya'a nuntuntunimo i Yesus, nembeeli paraas tokurung-Na ka' nongkoyong puusna juba-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Gause na noana taena, “Mau tongko' koyongonku a juba-Na sabole malesi' i yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus nolumingamo nintioki wiwine iya'a ka' norobu tae-Na, “Anak-Ku! Popotaan a noaam. Gause i koo parasaya na Ingku', mbaka' i koo malesi'!” Tongko' noko daa koiya'a, liuliu na'anu a mariingi'na wiwine iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sarataa i Yesus notaka na laiganna tanaasna laigan bakitumpuan, Ia nimiile' isian mian men munduup poloit ka' biai' a mian men gora'. ");
INSERT INTO blzNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ia norobumo na ko'ona i raaya'a tae-Na, “Uar kutung i kuu giigii'! Anak kanono' sian nolapus; ia tongko' noroyot.” Kasee mian na laigan iya'a nongkolengkeimo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sarataa no'umuar a mian men na laigan iya'a, Yesus ninsoopmo na tambinna anak iya'a ka' ningintoni limana. Kasi nowangon a anak wiwine iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbaka' norumeebarmo a lele men koiya'a na longkop libutan. ");
INSERT INTO blzNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Noko daa iya'a ai Yesus nomae'mo. Na tanga'na salan, isian rua' mian men mampisok nongololo' i Ia. Raaya'a mangkakaro' taena, “Lee' ni Daud! Kolingu'konon i kai!” ");
INSERT INTO blzNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sarataa i Yesus ninsoop na sa'angu' laigan, notakamo a rua' mian men mampisok iya'a na Ko'ona. Yesus nimikirawarimo i raaya'a tae-Na, “Parasayaonmuu uga' se' i Yaku' momoko mengelesi'i i kuu?” Ia simbati i raaya'a taena, “Daa, Tumpu, parasayaonmai!” ");
INSERT INTO blzNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kasi i Yesus nongkoyong matana i raaya'a ka' norobu tae-Na, “Bi sida na ko'omuu koi men kuu parasayamo.” ");
INSERT INTO blzNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mbaka' nopoopiile'mo a matana i raaya'a. Kasi ia potoo i Yesus tae-Na, “Imamat ini'imari! Alia sa'angu'po mian minginti'i se' koiya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kasee i raaya'a nomae'mo na longkop libutan iya'a ka' nengelelekon upa men ia wawau i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tongko' nomae' a rua' mian men nopoopiile'mo iya'a, isianmo soosoodo sa'angu' mian umu' men ia lampingi meena, ia wawa mian taka ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sarataa ia buse'i i Yesus a meena iya'a, mbaka' ninsidamo norobu a mian men umu' iya'a. Nimiile' koiya'a, samba' a mian biai'. Taena i raaya'a, “Men koi kani'i sianpo ia piile' mian na Israel!” ");
INSERT INTO blzNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kasee mian Farisi norobu taena, “Ia namake kuasana tanaasna meena bo numbuse'i-Na meena iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kasi i Yesus nangarae'i giigii' kota tia kampung. Ia nimisiso' mian na laigan bakitumpuanna ka' nengelelekon Lele Pore men mambantilkon Batomundo'anna Surugaa. Ia nengelesi'i biai' kaliangan nggeona mian ka' men repo'. ");
INSERT INTO blzNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ia nolingu' nimiile' mian biai' iya'a, gause i raaya'a noraranga'mo ka' nokodalaianmo, koi domba men sianta mian nontondong. ");
INSERT INTO blzNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kasi i Ia norobu na murit-Na tae-Na, “Padakon mase biai', kasee papalimang men bo pamadak tongko' titiu'. ");
INSERT INTO blzNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mbali' iya'a, pama'ase' na tombono ale' kada' i Ia mantakakon papalimang men bo pamadak ule'na aso-asok iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na sa'angu' tempo ai Yesus nengeleelo'mo sompulo' rua' murit-Na barimpung. Kasi i Ia nantarai i raaya'a kuasa bo pumbuse'i meena, ka' bo pengelesi'i biai' kaliangan nggeona mian ka' men repo'. ");
INSERT INTO blzNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ngaanna sompulo' rua' poposuu' iya'a: Men olukon i Simon men ngaanon uga' i Petrus tia utusna i Andreas, kasi rurua' anak ni Zebedeus men i Yakobus tii Yohanes, ");
INSERT INTO blzNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus tii Bartolomeus, Tomas tii Matius men pagawena pajak, kasi i Yakobus anak ni Alfeus, tii Tadeus, ");
INSERT INTO blzNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ka' i Simon mian Zelot tii Yudas Iskariot men nangakalkon bo pongorookonna i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus nomosuu'mo sompulo' rua' poposuu'-Na iya'a tia potoo men koi kani'imari: “Alia i kuu mae' na lipu'na mian men taasi' Yahudi. Ka' alia mae' na kota na lipu' Samaria. ");
INSERT INTO blzNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kasee rae' na samba Yahudi lipu' Israel. Raaya'a koi domba men nopenta'. ");
INSERT INTO blzNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Rae' ka' lelekon na ko'ona i raaya'a se' Batomundo'anna Surugaa karani'mo. ");
INSERT INTO blzNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mian men manggeo alaka' lesi'i. Mian men lapus alaka' potuo'i. Mian men kustaon alaka' lesi'i. Ka' buse'i a meena men mangalampingi mian. Kuu noko pangalabotmo bulu-bulu' barakaat iya'a. Mbali' iya'a, tarai a mian bulu-bulu'. ");
INSERT INTO blzNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Alia mangawawa doi' mosoni, doi' salaka', kabai se' doi' kulaluk na lalomna boborna lolosmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ka' uga' alia mangawawa tuuman na rae'anmuu. Alia mangawawa bokukum rurua' kabai se' sapato ka' tokon rurua', gause mian men balimang salananmo mantausi tambona. ");
INSERT INTO blzNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kalu i kuu minsoop na sa'angu' kota kabai kampung, pansarak mian men daa mingkira' mangalaboti i kuu. Dodongo na ko'ona pataka tempo komae'anmuu soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kalu i kuu minsoop na laiganna mian, ngaan a koi kani'imari: ‘Sulano bi barakaationna Alaata'ala i kuu.’ ");
INSERT INTO blzNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kalu mian na laigan iya'a mangalaboti i kuu, sulano a upa men kuu wurungkon iya'a bi tontako' na ko'ona i raaya'a. Kasee kalu i raaya'a sian mangalaboti i kuu, upa men kuu wurungkon iya'a bi tongule'kon na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kalu isian mian men bude' mangalaboti i kuu ka' bude' momorongori wurungmuu, uar ka' parerei a mian na laigan kabai se' na kota inono', kasi taperi a awu na palaana saratmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' na Ilio Pungukumian, ukumanna Alaata'ala bona lipu' Sodom ka' lipu' Gomora a malaina tia ukuman bona kota iya'a!” ");
INSERT INTO blzNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Imamat ini'imari! Yaku' momosuu' i kuu koi domba na tanga'na serigala. Mbali' iya'a, kuu bi pande koi ule ka' noamuu maloos koi marampatii. ");
INSERT INTO blzNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kasee maka'amat i kuu na giigii' mian, gause isian men bo mangkalaakkon i kuu na moomoola'na agama. Ka' i kuu bo sasalionna i raaya'a na laigan bakitumpuanna. ");
INSERT INTO blzNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kuu bo wawaonna i raaya'a na mian moola' tia tomundo' gause na pongololo'an i Yaku'. Ya'amo a tempona bo pompo'inti'ikonanmuu i Yaku' na ko'ona tia mian men taasi' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kasee kalu i raaya'a mangkalaakkon i kuu bo ukumion, alia babatakon men bo pinsimbatimuu kabai koi upa bo porobumuu. Gause men bo pinsimbatimuu bo bantilkonon na ko'omuu tempo iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Men morobu na tempo iya'a taasi' i kuu, kasee Alusna Tamamuu men na surugaa men muntundunkon i kuu. ");
INSERT INTO blzNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Isian uga' mian bo minsasapu na utusna kada' utusna papateionna mian. Isian uga' tama bo minsasapu na anakna kada' anakna papateionna mian. Ka' anak bo mintimban minti'ina ka' minsasapu kada' minti'ina papateionna mian. ");
INSERT INTO blzNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kuu bo kokundaionna giigii' mian gause na pongololo'an i Yaku'. Kasee mian men mantaan pataka kokomburi'anna bo salamatkonon. ");
INSERT INTO blzNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kalu i raaya'a mantalalais i kuu na sa'angu' kota, pamarere na kota sambana. Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' sianpo paraa i kuu mantakai giigii' kota na Israel, Anak Manusia noko takamo. ");
INSERT INTO blzNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sa'angu' mian men guruion sian angga'ion mangalalabii guruna, ka' sa'angu' tutulungi sian angga'ion mangalalabii tanaasna. ");
INSERT INTO blzNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sianmo pangalabikonan kalu sa'angu' mian men guruion niwawaukon koikoimo tia guruna, ka' sa'angu' tutulungi niwawaukon koikoimo tia tanaasna. Kalu i Yaku' men bookoi tanaasna sangkau laigan ningaanimo Beelzebul, upa mune' i kuu men tonsoop mian na laigan iya'a. Kuu uga' sabole ngaanion men ba'idekna!” ");
INSERT INTO blzNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Alia layaonkon i raaya'a. Gause sianta upa mawuni men sian kampiile'an, ka' sianta upa men popowunion men sian ka'inti'ian. ");
INSERT INTO blzNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Upa men Yaku' bantilkon na ko'omuu men tongko' kuu-kuuna a nongorongor, tadulkon iya'a na mian biai'. Ka' upa men Yaku' seasoikon na tilingamuu, lelekon na mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Alia i kuu layaonkon i raaya'a men mampapatei wakana mian kasee sian kuasaan mampapatei alusna. Kasee i kuu tio layaonkon i Ia men kuasaan minsilaka'i waka ka' alusmuu na naraka. ");
INSERT INTO blzNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Rua' sapu' pereet kalu balukkonon, angga'na tongko' sa'angu' doi' men titiu'na tuu'. Kasee mau mune' koiya'a, sianta sa'angu'po a men kodalaian mandawo' na tano' kalu sian koi pingkira'na Tamamuu men na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ka' i kuu, wuukpo na takala'muu nisaa'mo giigii'. ");
INSERT INTO blzNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mbali' iya'a, aliamomo' layaon, gause i kuu a umangga'na tia sapu' pereet men biai'!” ");
INSERT INTO blzNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mian men mompotuutuu' na mian biai' se' i ia pololo'-Ku, ia bo potuutuu'on-Ku na Tamang-Ku men na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kasee i ime a men mangaan na mian se' i ia taasi' mian-Ku, mian iya'a uga' bantilkonon-Ku na Tamang-Ku na surugaa se' i ia taasi' mian-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Alia i kuu mansarui se' i Yaku' taka na tano' balaki' kani'i bo pantakakon pooka'amatan. Tatakang-Ku kani'i taasi' mantakakon pooka'amatan, kasee mantakakon mian sida poopapate. ");
INSERT INTO blzNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tatakang-Ku minsidakon anak moro'one sianmo mangkakana' tamana, anak wiwine sianmo mangkakana' sinana, ka' monianna men wiwine sianmo mangkakana' sinana langkai'na. ");
INSERT INTO blzNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mbaka' poto'utusanmuu a men maso'kon i kuu. ");
INSERT INTO blzNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ime a men mongkolingu'kon tamana tia sinana mangalalabii pongkolingu'konna i Yaku', ia sian kokana'-Ku bo murit-Ku. Ka' ime a men mongkolingu'kon anakna moro'one kabai men wiwine mangalalabii pongkolingu'konna i Yaku', ia sian kokana'-Ku bo murit-Ku. ");
INSERT INTO blzNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mian men bude' mamasa'an saliipna ka' mongololo' i Yaku', ia sian kokana'-Ku. ");
INSERT INTO blzNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gause mian men mampari-pari popo'olukon wakana, ia sian mantausi tutuo' men pore. Kasee mian men mongorookon wakana na Ingku', ia bo mantausi tutuo' men pore.” ");
INSERT INTO blzNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ime a men mangalaboti i kuu, ia mangalaboti i Yaku'. Ka' i ime a men mangalaboti i Yaku', ia mangalaboti Tamang-Ku men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ime a men mangalaboti nabii gause nabii iya'a mianna Tumpu, mian men mangalaboti nabii iya'a bo mantausi koi tambona sa'angu' nabii. Ka' i ime a men mangalaboti sa'angu' mian men kana' a wawauna gause i ia mangangga'i mian iya'a, ia bo mantausi koi tambona sa'angu' mian men kana' a wawauna iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Imepo a men mimi'inumi mian men sian angga'ion kani'i, mau tongko' weer memel, gause mian iya'a pololo'-Ku, mbaka' bantilkonon-Ku na ko'omuu se' i ia sabole-bole mantausi tambona!” ");
INSERT INTO blzNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Noko daa i Yesus nomotoo sompulo' rua' murit-Na, Ia namarereimo dodongoan iya'a. Ia nomae'mo nimisiso' ka' nengelelekon Lele Pore na kota men karani' indo'o. ");
INSERT INTO blzNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohanes Pansarani men na tarungkuan nongorongor palimangon ni Kristus. ");
INSERT INTO blzNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mbaka' Ia nomosuu'mo toropii muritna mae' bapikirawar ni Yesus. Taena i raaya'a, “Too daa i Kuumo a men bo taka koi men ia toonkon Alaata'ala, kabai i kai tio mempeperai mian sambana?” ");
INSERT INTO blzNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ia simbati i Yesus tae-Na, “Rae' ule'kon waale'e ni Yohanes ka' bantilkon a upa men kuu rongor ka' kuu piile' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mian mampisok nopoopiile'mo, mian repo' nolumempangmo, mian kustaon na'anumo, mian mabongol nopoorongormo, mian men lapus nipotuo'imo, ka' Lele Pore men ringkat na Alaata'ala nilelekonmo na mian talalais. ");
INSERT INTO blzNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Barakaatan a mian men sian mongkokundai i Yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sarataa nomae' a mian men ia posuu' i Yohanes, Yesus nuntumbeimo nuntundun i Yohanes na mian biai' men isian tii Ia. Tae-Na, “Kuu nomae' na tano' maleas bo mimiile' upa? Mimiile' sansila' rakut men puuronna mombuul waale'e-le'emari? ");
INSERT INTO blzNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kuu nomae' bo mimiile' upa? Mimiile' sa'angu' mian men mopakean pore? Mian men mopakean pore dodongoanna na laiganna tomundo'! ");
INSERT INTO blzNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ansee i kuu no'umuar bo mimiile' upa? Bo mimiile' sa'angu' nabii? Tuutuu' mba'a. Ka' bantilkonon-Ku na ko'omuu se' i Yohanes labi tia tongko' nabii. ");
INSERT INTO blzNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gause i ia isian nitulis na Alkitaap koi kani'imari: ‘Imamat ini'imari! Yaku' bo momosuu' mian-Ku mongolukoni i Kuu. Mian iya'a bo montoropoti salan-Muu.’ ");
INSERT INTO blzNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' na tano' balaki' kani'i sian nontoo isian mian men mangalalabii i Yohanes a pangangga'ina mian. Kasee mian men itiu'na na Batomundo'anna Surugaa, iamo a balaki'na tii Yohanes Pansarani. ");
INSERT INTO blzNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nuntumbeiannapo i Yohanes Pansarani nengelelekon lele pataka koini'i, Batomundo'anna Surugaa ia lawuimo mian. Ka' men mangalawui iya'a montopongi mungkuasai. ");
INSERT INTO blzNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kasee giigii' nabii ka' kitap Torat pataka i Yohanes nuntundun upa men tio bo sida. ");
INSERT INTO blzNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ka' kalu i kuu mingkira' parasaya, Yohanesmo iya'a men i Nabii Elia, men kotakaanna nipopo'inti'ikonmo. ");
INSERT INTO blzNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Daa tilingaan, imamat pore-pore! ");
INSERT INTO blzNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tio koi upa a pompookokoikonan-Ku mian men tumuo' na tempo koini'i? Raaya'a koi anak men poto'oruang na tampat pobalukan ka' ba'ilianna mian. Ka' i raaya'a mangkakaro'kon na lulusanna taena, ");
INSERT INTO blzNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kai munduup poloit bo ko'omuu, kasee i kuu bude' manari! Kai mangananikon nanian kasiongo'an, kasee i kuu sian masiongo'!’ ");
INSERT INTO blzNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohanes notaka, ka' i ia malia' ba'apata ka' sian ninginum anggur, kasee mian mangaan se' i Yohanes ia lampingimo meena! ");
INSERT INTO blzNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kasi Anak Manusia notaka, ka' i Ia nokumaan ka' ninginum, mbaka' mian norobu taena, ‘Piile' a mian kale'e! Modoko', bukuan lio', motobela' tia pagawena pajak ka' mian dosaon.’ Mau mune' koiya'a, pinginti'ianna Alaata'ala kampiile'an se' kana' na wawauna mian men mongololo pinginti'ianna iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kasi i Yesus nuntumbei nompoposala' mian na toropii kota men bude' monsosoli ka' mangkadarai gau'na i raaya'a men ba'idek, mau mune' na kota iya'a a biai'anna upa kosamba' men Ia wawau. ");
INSERT INTO blzNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Taeni Yesus, “Silaka' i kuu mian na kota Khorazim, ka' silaka' i kuu mian na kota Betsaida! Gause kalu upa kosamba' men niwawaumo na libutanmuu uga' isian niwawau na kota Tirus tia kota Sidon, mbaka' sabole mianna kota iya'a nanau'mo noko ponsosolimo ka' nangkadaraimo gau'na i raaya'a men ba'idek, ka' mopakean kasiongo'an, ka' momokela awu na wawona takala'na i raaya'a. Kasee i kuu sian. ");
INSERT INTO blzNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bantilkonon-Ku na ko'omuu se' na Ilio Pungukumian, mian na Tirus tia mian na Sidon a malaina ukumanna Alaata'ala pookokoikonon tia ukumanmuu! ");
INSERT INTO blzNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ka' i kuu mian na kota Kapernaum! Pinginti'imuu mbali' se' i kuu bo leengketon taka surugaa? Sian! Kuu bo tibarkonon na dodongoanna mian lapus! Kalu upa kosamba' men niwawaumo na libutanmuu niwawau na lipu' Sodom mbaripian, mbaka' lipu' Sodom iya'a dauga' isian pataka koini'i! ");
INSERT INTO blzNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bantilkonon-Ku na ko'omuu se' na Ilio Pungukumian, mianna lipu' Sodom a malaina ukumanna Alaata'ala pookokoikonon tia ukumanmuu!” ");
INSERT INTO blzNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na tempo iya'a i Yesus nosambayang tae-Na, “Papa! Tumpu men montombonoi langit ka' tano' balaki'! Yaku' basukuur na Ko'omuu gause giigii' iya'a Kuu popowunikon na mian pande tia men pinginti'ianan, kasee Kuu pipiile'kon na mian men sian minginti'i upa-upa. ");
INSERT INTO blzNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Papa, ya'amo a men kinokana'na noa-Muu.” ");
INSERT INTO blzNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kasi i Yesus norobu na mian biai' tae-Na, “Giigii' upa ia poko rookonmo Tama na surugaa na Ingku'. Sa'angu'po mian sian minginti'i Anak. Men minginti'i Anak tongko' Tama na surugaa. Sa'angu'po mian sian minginti'i Tama na surugaa. Men minginti'i Tama na surugaa tongko' Anak ka' mian men kikira'na Anak bo pompopo'inti'ikon Tama. ");
INSERT INTO blzNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mai taka na Ingku' giigii' i kuu men mamale, ka' men munsuri wawaan marawat. Yaku' mangalawei i kuu. ");
INSERT INTO blzNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pasa'an a wawa men Yaku' popasa'anikon na ko'omuu, ka' mikipisiso' na Ingku', gause i Yaku' ma'amat a noang-Ku ka' sian mongkodaakon waka. Mbaka' i kuu bo munsuri koporean. ");
INSERT INTO blzNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gause men posuu'konon-Ku iya'a ma'amat, ka' wawa men popasa'anikonon-Ku na ko'omuu malai.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na sa'angu' tempo na ilio Sabat, Yesus tia murit-Na nolumiu na ale'na gandum. Murit-Na numpupumo gandum ka' nangkaan gause mololu. ");
INSERT INTO blzNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sarataa ia piile' mian Farisi se' koiya'a, raaya'a norobumo ni Yesus taena, “Piile'! Murit-Muu nangawawau upa men sian patalaion wawauon na ilio Sabat.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ia simbati i Yesus tae-Na, “Sianpo mbali' i kuu nambasa a upa men ia wawau i Daud na tempo i ia tia mian men nongololo' i ia see nokololuan? ");
INSERT INTO blzNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Daud ninsoop na Laiganna Alaata'ala, kasi i ia tia mian men nongololo' i ia nangkaan roti men nirookonmo bona Alaata'ala. Poali na aturanna agama, roti iya'a sian sida kaanon. Men daa sida mangkaan tongko' imam. ");
INSERT INTO blzNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kabai i kuu sianpo nambasa na kitap Torat se' sanda' ilio Sabat imam men balimang na Laiganna Alaata'ala malia' mansala'kon ukum men bookoi sian sida balimang na ilio Sabat, kasee i raaya'a sian poposala'on? ");
INSERT INTO blzNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bantilkonon-Ku na ko'omuu se' kani'imari isian mian men angga'na labi tia Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Koi kani'imari a wurungna Tumpu men nitulis na Alkitaap: ‘Men kikira'-Ku mase isian polingu', taasi' kurbaan.’ Kalu i kuu tuutuu' minginti'i panduungna wurungna Tumpu iya'a, sabole i kuu sian mansasala' mian men sian sala'na. ");
INSERT INTO blzNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gause Anak Manusia a bo Pinginti'i na ilio Sabat.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus namarereimo tampat iya'a kasi nomae' na laigan bakitumpuanna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Indo'o isian sa'angu' mian men repo' a limana sambotak. Mian na laigan bakitumpuan iya'a mingkira' mompoposala' i Yesus mbaka' i raaya'a nobapikirawarmo taena, “Too sida mengelesi'i mian na ilio Sabat?” ");
INSERT INTO blzNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ia simbati i Yesus tae-Na, “Kalu se' i kuu dombaan, ka' na ilio Sabat dombamuu iya'a nandawo' na lobong men alalom, sian mbali' pari-parionmuu ka' uarkonon? ");
INSERT INTO blzNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mune' se' daa mian men isian angga'na pookokoikonon tia domba? Mbali' iya'a, sian kongupana mangawawau men pore na ilio Sabat.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kasi i Yesus norobu na mian men repo' a limana sambotak tae-Na, “Soorkon a limaam!” Mian iya'a nonsoorkonmo limana, mbaka' limana iya'a nalesi'mo koi limana men sambotak. ");
INSERT INTO blzNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kasee mian Farisi no'umuarmo na laigan bakitumpuan iya'a ka' nobasangada mampapatei i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesus inti-inti'i se' mian Farisi mansasikon bo mangawawau ba'idek na Ko'ona. Mbali' iya'a, Ia namarereimo dodongoan iya'a. Biai' a mian men nongololo' i Ia, kasi giigii' men manggeo Ia lesi'i. ");
INSERT INTO blzNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kasee i Ia nongkokundakon tuu' i raaya'a kada' alia montootundun na mian sambana wawau-Na iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tempo i Yesus nangawawau men koiya'a, mbaka' nosidamo a wurungna Tumpu koi men ia tadulkon i Nabii Yesaya taena, ");
INSERT INTO blzNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Piile'! Ni'imo a Mian-Ku men Yaku' ruruki, Mian men kolingu'-Ku, ka' men kokana'na noang-Ku. Alus-Ku bo rookonon-Ku na Ko'ona, ka' i Ia bo mengelelekon na biai' lipu' wawaung-Ku men kana'. ");
INSERT INTO blzNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ia sian poogagai, sian mangkakaro', ka' Ia sian mompopodaa waka-Na na bendar. ");
INSERT INTO blzNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lambangan men noko pekokmo sian pato'on-Na, boloak men momayo-mayo'mo sian poro'ion-Na. Ia bo mampari-pari pataka wawau men kana' sida na tano' balaki'. ");
INSERT INTO blzNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Giigii' lipu' tongko' mongooskon i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sian paraa nanau' a noporusanna iya'a, sa'angu' mian men mampisok ka' uga' umu' gause ia lampingi meena, niwawamo ni Yesus. Mian iya'a ia lesi'imo i Yesus mbali' daa ninsidamo norobu ka' nopoopiile'. ");
INSERT INTO blzNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Giigii' mian samba'. Taena i raaya'a, “Too tuutuu' i Iamo kani'i a lee' ni Daud men nitoonkon?” ");
INSERT INTO blzNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kasee sarataa mian Farisi nongorongor se' koiya'a, ia simbatimo i raaya'a taena, “Mian kaya'a namake kuasana Beelzebul men tanaasna meena bo numbuse'i-Na meena iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kasee i Yesus ninginti'i noana mian Farisi iya'a. Mbaka' i Ia norobumo na ko'ona i raaya'a tae-Na, “Kalu sa'angu' batomundo'an pookakaresa, batomundo'an iya'a sabole sianmo umimput. Kalu sa'angu' kota kabai se' sa'angu' suo' pookakaresa ka' sian pooka'amat, sianmo bakitaan. ");
INSERT INTO blzNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Koiya'a uga' na batomundo'anna Ibiliis. Kalu Ibiliis mumbuse'i simbaya'na, mbaka' i raaya'a pookakaresamo gause galal mintimbangi waka-wakanamo. Kalu koiya'a, batomundo'anna sianmo bakitaan. ");
INSERT INTO blzNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kuu nangaan se' i Yaku' mumbuse'i meena tia kuasa ni Beelzebul. Kalu koiya'a, ansee tia kuasa ni ime a mianmuu mumbuse'i meena? Mianmuusi iya'a a men bo pompopo'inti'ikon se' i kuu sala'! ");
INSERT INTO blzNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kasee kalu Yaku' numbuse'i meena tia kuasana Alusna Alaata'ala, mbaka' sabole Batomundo'anna Alaata'ala notakamo na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Sianta mian men daa momoko miminsoopi laiganna mian men bukuan ka' mangarampasi kupangna kalu sian punguonna kutung a mian bukuan iya'a. Moko daasi punguon kasi i ia sida mangala kupangna mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mian men sian umapak na Ingku', ia mangaka'idek i Yaku', ka' mian men sian sangada tii Yaku', ia mambaraba'i palimangon-Ku! ");
INSERT INTO blzNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mbali' iya'a, bantilkonon-Ku na ko'omuu se' giigii' dosa ka' wurung men mingiroki mian dauga' sida ampunion! Kasee kalu ia mingiroki Alus Molinas, ia sian sida ampunion! ");
INSERT INTO blzNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kalu mian mangaan upa-upa men mintimban Anak Manusia, ia dauga' sida ampunion. Kasee kalu ia mangaan upa-upa men mintimban Alus Molinas, ia sianmo sida ampunion, mau mune' na tempo koini'i kabai se' na tempo men bo rumpakion!” ");
INSERT INTO blzNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Sa'angu' kau men pore a tutuo'na sabole mantakakon woo'na men pore. Koiya'a uga' sa'angu' kau men ba'idek a tutuo'na sabole mantakakon woo'na men sian pore. Pore kabai se' ba'idek a kau iya'a, na woo'na mba'a pinginti'ianmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wee i kuu men koi lee'na ule ba'idek! Koi upa a kosidana i kuu mangaan upa-upa men pore, kasee i kuu ba'idek? Gause upa men porobukononna mian rumingkat na noana. ");
INSERT INTO blzNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mian men ma'amat momorobukon upa-upa men ma'amat, gause noana ma'amat. Kasee mian men ba'idek a gau'na momorobukon upa-upa men ba'idek, gause noana ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mbali' iya'a, bantilkonon-Ku na ko'omuu se' giigii' porobuan men sian kana' men ia porobukon mian tio tanggungonna na Ilio Pungukumian. ");
INSERT INTO blzNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gause koi men porobukononmuu i kuu bo popokana'on, ka' koi men porobukononmuu uga' i kuu bo ukumon.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Noko daa iya'a, toropii wawa ukum Torat ka' mian Farisi norobumo ni Yesus. Taena, “Guru, kai mingkira' mimiile' i Kuu mangawawau upa kosamba' bookoi oos.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ia simbati i Yesus tae-Na, “Mian men tumuo' na tempo koini'i ba'idek tuu' ka' sian malolo'! Raaya'a mama'ase' sa'angu' upa kosamba' kada' i raaya'a mamarasaya i Yaku', kasee i raaya'a sian taraion sa'angu'po upa kosamba' saliwakon upa kosamba' koi men nosida ni Nabii Yunus. ");
INSERT INTO blzNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nabii Yunus koi tolunondom tolungilio na lalomna kompongna susum balaki'. Koiya'a uga' a Anak Manusia bo dumodongo na lalomna tano' koi tolunondom tolungilio. ");
INSERT INTO blzNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na tempo pungukumian ni'imarian, mianna kota Niniwe bo potuo'ion singka-singkat tia mian men tumuo' na tempo koini'i. Mianna Niniwe iya'a bo mansasala' i kuu, gause mianna Niniwe iya'a nonsosolimo ka' nangkadarai gau'na i raaya'a men ba'idek na tempo i raaya'a nomorongor pisiso' ni Yunus. Poali na ko'omuu koini'i isian men labi i Nabii Yunus a kobalaki'na! ");
INSERT INTO blzNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na tempo pungukumian ni'imarian, tomundo' wiwine na tano' paraas Selatan bo potuo'ion singka-singkat tia mian men tumuo' na tempo koini'i. Ka' i ia bo mansasala' i kuu. Tomundo' wiwine iya'a ringkat na ko'oloaan tuu', na puusna tano' balaki', ka' taka nomorongor pisiso' ni tomundo' Salomo men pinginti'ianan. Poali na ko'omuu koini'i isian men labi i Salomo a kobalaki'na!” ");
INSERT INTO blzNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kalu se' meena mamarerei sa'angu' mian, meena iya'a mae'mo tumikum na tampat men makangkung mansarak pintimalean, kasee sian nantausi. ");
INSERT INTO blzNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kasi i ia morobu taena, ‘Yaku' bo mule'kon na laigan men yaku' parereimo.’ Ia nomae'mo see nantakai laigan iya'a liing, moloe' nikarei, ka' nitotobo' pore-pore. ");
INSERT INTO blzNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kasi i ia umuar ka' nangange pitu' meena sambana men ba'idekna tii ia. Kasi i raaya'a ninsoop na mian iya'a, ka' nodumodongo indo'o. Komburi'na mian iya'a na'idekmo tuu' pookokoikonon tia men tumbena. Koiya'a uga' a men bo sida na mian men ba'idek na tempo koini'i.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pintanga' i Yesus morobu tia mian biai' iya'a, notakamo a sina-Na ka' utus-Na. Raaya'a potokerer na liwa mansarak pootuung tii Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sa'angu' mian na mian biai' iya'a nambantilkonmo ni Yesus taena, “Piile'! Sina-Muu tia utus-Muu mokaraale'e na liwa, mampari-pari momootuungi i Kuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kasee ia simbati i Yesus a mian men nambantilkon iya'a tae-Na, “Ime mbali' a sinang-Ku? Ime mbali' a utus-Ku?” ");
INSERT INTO blzNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kasi i Ia ninsiso' murit-Na ka' norobu tae-Na, “Iraani'i a sinang-Ku tia utus-Ku! ");
INSERT INTO blzNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gause i ime a men mangawawau koi pingkira'na Tamang-Ku men na surugaa, iamo a utus-Ku moro'one, utus-Ku wiwine, ka' iamo a sinang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na iliopo iya'a uga' i Yesus namarereimo laigan iya'a, kasi nomae' na soripi'na danau ka' no'umoruang indo'o. ");
INSERT INTO blzNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Biai' a mian men notaka nunguruuti i Yesus, pataka i Ia somo nolumakit na duangan ka' no'umoruang. Kasee mian biai' iya'a giigii' potokerer na poso'oleon. ");
INSERT INTO blzNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kasi i Yesus nintimbaani'kon biai' kaliangan pisiso' na ko'ona i raaya'a. Tae-Na, “Imamat ini'imari! Isian po'ale' sa'angu' mae' mangkambur wine' na ale'na. ");
INSERT INTO blzNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Banta-bantang i ia mangkambur, isian wine' men nandawo' na soripi'na salan. Kasi notaka a sapu' ka' nangkaan wine' iya'a pataka nokabus. ");
INSERT INTO blzNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Isian uga' men nandawo' na karabatu, men sian laan tano'na. Wine' iya'a liuliu notumuo' gause tano'na monipis. ");
INSERT INTO blzNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kasee sarataa no'alayo'mo a ilio, wine' men notuo'mo iya'a nalaumo, kasi nakangkung ka' nopate, gause wakatna sian alalom. ");
INSERT INTO blzNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Isian uga' wine' men nandawo' na rakut masolot ka' ruri'on. Kasi rakut masolot ka' ruri'on iya'a no'uminsur ka' ningipit wine' men notuo'mo iya'a pataka nopate. ");
INSERT INTO blzNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kasee isian uga' wine' men nandawo' na tano' men molumba', kasi niwoo'. Woo'na isian men para sa'atu paku', isian men poro nomompulo' paku', ka' isian uga' men poro tolumpulo' paku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Noko daa nuntundunkon timbaani' iya'a, Yesus norobumo tae-Na, “Daa tilingaan, imamat pore-pore!” ");
INSERT INTO blzNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kasi murit ni Yesus notaka na Ko'ona nobapikirawar taena, “Nongko'upa i Kuu se' batimbaani' kalu batundun na mian biai'?” ");
INSERT INTO blzNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ia simbati i Yesus tae-Na, “Kuu nitaraimo pinginti'ian kada' minginti'i upa men mawuni na Batomundo'anna Surugaa, kasee i raaya'a sian. ");
INSERT INTO blzNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gause mian men isianmo upa ia tombonoi bo taraion soosoodo, ka' i ia bo kalabian. Kasee mian men sianta upa tombonoionna, toro tiu'po men dauga' isian na ko'ona bo alaon. ");
INSERT INTO blzNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mbali' iya'a, Yaku' batimbaani' kalu batundun na mian biai', gause mau i raaya'a poopiile', kasee koi mian men mampisok. Ka' mau i raaya'a poorongor, kasee koi mian men mabongol ka' sian minginti'i. ");
INSERT INTO blzNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tempo i raaya'a nangawawau men koiya'a, mbaka' nosidamo a wurungna Tumpu men ia tundun i Nabii Yesaya taena, ‘Raaya'a bookoi nomorongor kasee sian ninginti'i; raaya'a bookoi nimiile' kasee sian ninginti'i upa men nosida. ");
INSERT INTO blzNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gause pinginti'ina mian karaani'i noko'ompodianmo, tilingana i raaya'a nopabongolmo ka' matana i raaya'a nirampitkonmo. Nosida koiya'a kada' matana i raaya'a alia mimiile', tilingana i raaya'a alia momorongor, pikiranna i raaya'a alia minginti'i ka' alia mule'kon na Ingku', pataka i Yaku' mengelesi'i i raaya'a.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kasee barakaation i kuu gause matamuu daa poopiile' ka' tilingamuu daa poorongor. ");
INSERT INTO blzNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' biai'mo a nabii mbaripian tia mian men malolo' na Alaata'ala mingkira' mimiile' men koi kuu piile'mo koini'i, kasee i raaya'a sian nimiile'. Raaya'a mingkira' mongorongor men koi kuu rongormo koini'i, kasee i raaya'a sian nongorongor.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mbali' iya'a, porongori pore-pore a aratina timbaani'na po'ale iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wine' men nandawo' na salan, ya'amo mian men nongorongor lelena Batomundo'anna Surugaa, kasee sian minginti'i. Mian iya'a ia rae'i i ia men gau'na ba'idek ka' nirampasi a upa men nipoko kamburmo na noana. ");
INSERT INTO blzNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wine' men nikambur na karabatu mase mian men nongorongor wurung iya'a, ka' lako-lako nangalabot tia noa beles. ");
INSERT INTO blzNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kasee wurung iya'a sian niwakat na noana i raaya'a. Mbali' iya'a, sian paraa notontaan nanau' a notuo'anna. Tempo i raaya'a takaionna repaan kabai se' talalaison gause lele iya'a, raaya'a liuliu minsasapu kaparasaya'anna. ");
INSERT INTO blzNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wine' men nikambur na rakut masolot ka' ruri'on mase mian men nongorongor wurung iya'a, kasee dauga' babatakon tutuo'na i raaya'a ka' uga' mingkira' tumuo' labian na tano' balaki' kani'i. Mbali' iya'a, wurungna Alaata'ala noko'ipit na noana i raaya'a, mbaka' sian niwoo'. ");
INSERT INTO blzNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ka' wine' men nikambur na tano' men molumba' mase mian men nongorongor lele iya'a kasi ninginti'i ka' miwoo'. Ule'na isian men para sa'atu paku', poro nomompulo' paku', ka' isian men poro tolumpulo' paku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nuntundunkonmo soosoodo sa'angu' timbaani' tae-Na, “Batomundo'anna Surugaa iya'a koi sa'angu' po'ale' men nangkambur wine'na gandum na ale'na. ");
INSERT INTO blzNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na sa'angu' malom, tempona koroyotanna mian, notakamo a mian men maso'kon i ia ka' nangkambur woo'na padang na tanga'na gandum, kasi nomae'. ");
INSERT INTO blzNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Takamo tempo kotuo'anna woo'na padang iya'a ka' muntumbeimo mimburak, mbaka' nokampiile'anmo uga' a padang biai' na ale' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kasi notaka a mian men ia tamboi po'ale' iya'a, ka' norobu taena, ‘Tuan, taasi' mbali' wine' pore a men kuu kambur na ale'muu? Koi upa mune' se' isian padang na ale' iya'a?’ ");
INSERT INTO blzNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ia simbati po'ale' iya'a taena, ‘Isian sa'angu' mian men maso'kon i yaku' a men nangawawau koiya'a!’ Kasi mian men nitamboi iya'a nimikirawar soosoodo taena, ‘Tuan, kuu mingkira' kalu i kai mae' mangarawuti padang iya'a?’ ");
INSERT INTO blzNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ia simbati po'ale' iya'a taena, ‘Alia. Kalu rawutionmuu a padangna iya'a, too mba'a bo ko'anuian tia gandum. ");
INSERT INTO blzNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sobii rua-rua'na bi tuo' pataka tempona pamadakan. Bantilkononkusi na mian men mamadak se' tambun kutung a padangna, koot, kasi tunu. Moko daa iya'a, kasi posuu'onku mantambun gandumna ka' manganaa' na alangku.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus nuntundunkonmo soosoodo timbaani' sambana na mian biai' tae-Na, “Batomundo'anna Surugaa iya'a koi watuna sasawi ia ala mian kasi nikambur na ale'na. ");
INSERT INTO blzNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Watuna sasawi iya'a sa'angu' wine' men itiu'na na giigii' wine' sambana. Kasee kalu tumuo' ka' uminsur, kobalaki'na mangalalabii aso-asok sambana. Ia mingkaumo pataka sapu' na lealaa taka mimpeeta na panga'na.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus nuntundunkonmo sa'angu' timbaani' soosoodo na mian biai' tae-Na, “Batomundo'anna Surugaa iya'a koi ragi men ia ala sa'angu' wiwine, kasi ia lauk na patompulo' liter tarigu ka' nikior pataka no'uminsur giigii'.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Giigii' pisiso' ni Yesus na mian biai' Ia bantilkon tia timbaani'. Pisiso'-Na iya'a sianta sa'angu'po a men sianta nitimbaani'kon. ");
INSERT INTO blzNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tempo i Yesus batimbaani', mbaka' nosidamo a wurungna Tumpu koi men ia tadulkon nabii, men koi kani'imari: “Yaku' batimbaani' kalu morobu tii raaya'a; Yaku' bo mambantilkon upa-upa men niwunikon muntumbeipo ninsidakonan dunia kani'i.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Noko daa iya'a ai Yesus namarereimo mian biai' iya'a ka' ninsoop na laigan. Kasi murit-Na notaka ka' norobu taena, “Kai mikisiso'kon aratina timbaani' padang na tanga'na gandum iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ia simbati i Yesus tae-Na, “Mian men nangkambur wine' pore iya'a, ya'amo Anak Manusia. ");
INSERT INTO blzNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ale' iya'a, mase tano' balaki' kani'i. Wine' men pore iya'a mase mianna Batomundo'anna Surugaa. Padang iya'a mase mian men malolo' na ko'ona men gau'na ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mian men maso'kon po'ale' iya'a ka' nangkamburkon padang iya'a mase Ibiliis. Tempona pamadakan, mase kakabusanna tempo, ka' mian men mamadak mase malaa'ikat. ");
INSERT INTO blzNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Koi padang men tambunon ka' tunuon na apu, koiya'a uga' na kakabusanna tempo. ");
INSERT INTO blzNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Anak Manusia bo momosuu' malaa'ikat-Na mingirimpung giigii' mian na batomundo'an-Na men nanggau'kon mian nangawawau dosa tia giigii' mian sambana men nangawawau ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Raaya'a giigii' bo tibarkonon na apu men leaambangan. Indo'o i raaya'a bo tumando' ka' marepa tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka' giigii' mian men malolo' na Alaata'ala bo kampiile'an a ruarna koi matana ilio na Batomundo'anna Tamana i raaya'a. Daa tilingaan, imamat pore-pore!” ");
INSERT INTO blzNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Batomundo'anna Surugaa iya'a koi kupang men ninaa' na lalomna tano' men ia tausi sa'angu' mian, kasi ia kekekon soosoodo. Gause nobeles tuu', mian iya'a nomae'mo nambalukkon giigii' upana, kasi nomule'kon ka' ningili tano' iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Batomundo'anna Surugaa iya'a uga' koi sa'angu' pobaluk mansarak mutiara men pore. ");
INSERT INTO blzNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sarataa i ia nimiile' sa'angu' mutiara men umangga' tuu', lako-lako i ia nomae' ka' nambalukkon giigii' upana, kasi ningili mutiara iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Batomundo'anna Surugaa iya'a uga' koi puka' men nita'an na danau, kasi noko'ule' susum men biai' kaliangan. ");
INSERT INTO blzNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sarataa a puka' iya'a nobuke'mo susum, ia leengketmo mian a puka' iya'a na katano'an. Kasi i raaya'a nongoruangkon ka' nungururuki susum iya'a. Men ma'amat ni'isiikonmo na karandang, men ba'idekna nibalo'konmo. ");
INSERT INTO blzNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Koiya'a uga' a kakabusanna tempo. Malaa'ikat bo taka mengerensakon mian men ba'idek a gau'na ka' mian men malolo' na pingkira'na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kasi mian men ba'idek a gau'na iya'a bo tibarkonon na apu men leaambangan. Indo'o i raaya'a bo tumando' ka' marepa tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus nimikirawarimo murit-Na tae-Na, “Too daa kuu inti'imo a giigii' timbaani' iya'a?” Ia simbati i raaya'a taena, “Daa, inti'ionmaimo!” ");
INSERT INTO blzNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Taeni Yesus, “Sanda' wawa ukum Torat men nongololo'mo pisiso'na Batomundo'anna Surugaa, ia nipookokoikon koi sa'angu' tombono laigan men nunguarkon kupang men u'uru tia kupang men manau' na tampat men nanganaa'anna.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Noko daa i Yesus nuntundunkon timbaani' iya'a, Ia namarereimo dodongoan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ia nomule'konmo na dodongoan-Na. Indo'o i Ia nomae'mo mimisiso' mian na laigan bakitumpuanna. Mian indo'o men nomorongori i Ia kosamba'an tuu'. Taena i raaya'a, “Maana nantausian-Na pinginti'ian tia kuasa mangawawau upa kosamba'? ");
INSERT INTO blzNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Taasi' i Ia anakna i tukang? Taasi' i Maria a sina-Na, ka' moto'utus tii Yakobus, Yusuf, Simon ka' i Yudas? ");
INSERT INTO blzNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ka' taasi' giigii' utus-Na wiwine dumodongo iraani'i tii kita? Se' daa maana a nantausian-Na giigii' iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mbaka' i raaya'a bude' mangalaboti i Yesus. Kasi i Yesus norobu na ko'ona tae-Na, “Sa'angu' nabii mau mbariana angga'ionna mian, tongko' na kampung men dodongoanna, tia mianna sangkau laigan ia sian angga'ion.” ");
INSERT INTO blzNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mbaka' i Yesus sian nangawawau biai' upa kosamba' indo'o, gause i raaya'a sian parasaya. ");
INSERT INTO blzNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tempo i Yesus mimisiso' mian, lele-Na nokamporongoranmo ni Herodes men tomundo' na libutan Galilea. ");
INSERT INTO blzNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes norobumo na pagawena taena, “Sabole i Yohanes Pansarani inooro'o. Ia notuo'mo soosoodo noko daa lapus! Mbali' Ia kuasaan mangawawau upa kosamba'.” ");
INSERT INTO blzNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes norobu koiya'a gause mbaripian i ia nomosuu' nangarakop i Yohanes ka' numungu, ka' nonsoopkon na tarungkuan. Herodes nangawawau koiya'a gause i ia nosuo' tii Herodias, boroki' ni Filipus utusna. ");
INSERT INTO blzNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Wawau ni Herodes men koiya'a piribiai'mo ia kokundakon i Yohanes taena, “Sian sida i koo mangala i Herodias bo boroki'im!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bookoi i Herodes mingkira' mampapatei i Yohanes, kasee i ia layaonkon mian biai' gause pimiile'na i raaya'a i Yohanes koi sa'angu' nabii. ");
INSERT INTO blzNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na tempo i Herodes nangaramekon ilio men nongamea'anna, anak wiwine ni Herodias nosumoili'mo na aropna sawe' biai'. Wawauna iya'a nompopobeles noa ni Herodes. ");
INSERT INTO blzNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mbaka' i Herodes nobasumpa' bo mongorookon na ko'ona upapo a men pa'ase'onna. ");
INSERT INTO blzNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Gause asuionna sinana, mbaka' anak wiwine iya'a norobumo taena, “Yaku' mama'ase' takala' ni Yohanes Pansarani wawakonon na ingku' koikoini'ina tanaon na dulang!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sarataa nongorongor pa'ase'na iya'a, Herodes nasiongo'mo. Gause i ia nobasumpa'mo rongo-rongor sawe'na, uga' somo ia loloikon a pa'ase'na anak wiwine iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ia nomosuu'mo mian mae' na tarungkuan mongkolongi takala' ni Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Noko daa iya'a, niwawamo a takala' ni Yohanes na dulang ka' nirookon na wiwine laandue' iya'a. Kasi ia wawakon iya'a na sinana. ");
INSERT INTO blzNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Noko daa iya'a, murit ni Yohanes Pansarani notakamo nondolo' biibiina ka' nantanom. Kasi i raaya'a nomae' nambantilkon ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sarataa i Yesus nomorongor lele iya'a, Ia nasawe'mo na duangan ka' namarerei dodongoan iya'a, mansarak tampat men oloa na mian biai'. Kasee sarataa ia inti'i mian se' koiya'a, raaya'a namarereimo kotana sanda-sanda', ka' nogintano' nuntuus i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sarataa i Yesus nalau na duangan ka' nimiile' mian biai' iya'a, Ia nolingu'mo. Mbaka' i Ia nengelesi'imo mian men manggeo men isian indo'o tia mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Maamaalommo, murit ni Yesus nuntuu'imo i Ia ka' norobu taena, “Ilio boomo sopok, ka' tampat kani'i oloa na dodongoanna mian. Mbulo posuu' a mian karaani'i bi rae' kada' daa i raaya'a sida mingili kakaan na kampung.” ");
INSERT INTO blzNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kasee taeni Yesus, “Sian sakat i raaya'a mae'. Kuusi a mantarai i raaya'a kakaan.” ");
INSERT INTO blzNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Taena, “Kai tongko' isian roti lilima' ka' susum rurua'!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Taeni Yesus, “Le'emarikon na Ingku'!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kasi i Yesus nomosuu' mian biai' iya'a umoruang na rakut. Noko daa iya'a, ia alamo i Yesus a roti lilima ka' susum men rurua' iya'a, kasi nolumelengea' waara'a langit ka' nobasukuur na Alaata'ala. Noko daa iya'a Ia rumpi-rumpikmo a roti iya'a ka' nongorookon na murit-Na kada' bo obo-oboskonon na mian biai' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Raaya'a wiwi'na nobenteng nangkaan. Ka' labina roti men nikaan iya'a ia ruru' murit ni Yesus, dauga' nobuke' sampulo' rua' basung. ");
INSERT INTO blzNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mian moro'one men nangkaan roti iya'a isian toro lima' loloon mian, sianpo tonsoop tia wiwine ka' anak morio'. ");
INSERT INTO blzNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Noko daa koiya'a ai Yesus liuliu nomosuu' murit-Na mae' baduangan mongolukoni i Ia na sambotakna danau. Kasi mian men biai' iya'a Ia posuu'mo mule'kon. ");
INSERT INTO blzNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sarataa nomae'mo a mian biai' iya'a, Yesus nolumoponmo suungna na buu'na ka' nosambayang. Pataka malom i Yesus dauga' inda'a suungna. ");
INSERT INTO blzNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Duangan men ia lakiti murit ni Yesus noko toropiimo kilo a ko'oloana namarerei katano'an, ka' pailumbu'onna golong-golong gause sumpale'onna mombuul. ");
INSERT INTO blzNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Toro jaam tiga karani' ilio notakamo i Yesus na ko'ona i raaya'a tumpa-tumpang na wawona weer. ");
INSERT INTO blzNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sarataa murit ni Yesus nimiile' i Ia notumumpang na wawona weer, tongkodi' tuu' i raaya'a. Raaya'a nangkakaro'mo nolayaon. Taena, “Tile'e santuo'!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kasee liuliu ia simbati i Yesus tae-Na, “Porampot a noamuu! Yaku' ini'i. Alia layaon!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kasi i Petrus norobu taena, “Tumpu, kalu tuutuu' i Yesus i Kuu, leelo' ansee i yaku' nooro'o na Ko'omuu tumumpang na wawona weer!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ia simbati i Yesus tae-Na, “Mai!” Mbaka' nalaumo i Petrus na duangan, ka' notumumpang na wawona weer nuntuu'i i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kasee sarataa ia suri i Petrus se' makorong a mombuul na danau iya'a, ia nolayaonmo ka' nuntumbeimo tololop. Mbaka' ia nangkakaro'mo taena, “Tumpu, kaba'on!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus liuliu nondoekon lima-Na ka' ningintoni i Petrus. Kasi i Ia norobu tae-Na, “Wee i koo men sian laan parasaya! Nongko'upa i koo se' dauga' raranga' na Ingku'?” ");
INSERT INTO blzNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sarataa i raaya'a nasawe' na duangan, mombuul norokotmo. ");
INSERT INTO blzNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mbaka' murit ni Yesus men na duangan iya'a nonsoosa'mo i Ia. Taena i raaya'a, “Kuu tuutuu' Anakna Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sarataa nolumembet na sambotakna danau, raaya'a notakamo na Genesaret. ");
INSERT INTO blzNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tongko' ia piile' mian men iraando'o se' i Yesus a men notaka, raaya'a nengelelekonmo na giigii' kota men pookarani' tia Genesaret. Kasi giigii' mian men manggeo niwawamo ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Raaya'a nama'ase' kada' patalaion mongkoyong juba-Na, mau tongko' puusna. Kasi giigii' men nongkoyong juba-Na sida nalesi'. ");
INSERT INTO blzNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kasi toropii mian Farisi tia wawa ukum Torat na Yerusalem notaka ni Yesus. Raaya'a nobapikirawar taena, ");
INSERT INTO blzNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nongko'upa a murit-Muu se' munguluani adatna pulinta? Raaya'a sian mingoso' kutung kalu kumaan, koi men adatna pulinta!” ");
INSERT INTO blzNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ia simbati i Yesus tae-Na, “Nongko'upa se' i kuu munguluani posuu'na Alaata'ala tongko' se' montookon mongololo' adatna pulimuu? ");
INSERT INTO blzNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gause isian wurungna Alaata'ala nangaan tae-Na, ‘Angga'i a tama tia sinamuu!’ Ka', tae-Na, ‘Ai ime a men mantadeankon tamana kabai se' sinana tiodaa pate a ukumanna.’ ");
INSERT INTO blzNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kasee i kuu isian pisiso'muu se' mian sida mambantilkon na tamana kabai se' sinana men koi kani'imari: ‘Giigii' upa men tio bo rookononku na ko'omuu, yaku' poko kurbaankonmo na Alaata'ala.’ ");
INSERT INTO blzNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mbaka' i kuu sianmo sakat mangangga'i tama tia sinamuu. Kuu sianmo mongololo' wurungna Alaata'ala kada' bi mongololo' adatna pulimuu. ");
INSERT INTO blzNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wee i kuu mian men minti pa'a-pa'agama! Tuutuu' a men ia tulis i Nabii Yesaya muntundun i kuu, taena, ");
INSERT INTO blzNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mian karaani'i muntunde' i Yaku' tongko' na wewerna, see noana i raaya'a oloa na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sianta kana'na i raaya'a monsoosa' i Yaku', gause aturanna mian a pisiso'kononna koikoi se' aturan iya'a a aturan-Ku.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kasi i Yesus nengeleelo' mian biai' ka' norobu na ko'ona tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Porongori pore-pore kada' inti'ionmuu! Taasi' men minsoop na nganga' a men mengerere wakana mian, kasee wurung ba'idek men umuar na nganga' a men mengerere wakana mian.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mbaka' murit ni Yesus nuntuu'imo i Ia ka' nimikirawar taena, “Inti'ion-Muu se' mian Farisi kokoo'an tempo i raaya'a nongorongor wurung-Muu?” ");
INSERT INTO blzNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ia simbati i Yesus tae-Na, “Giigii' aso-asok men taasi' ia asok Tamang-Ku men na surugaa bo bubution-Na tiwaka-wakatna. ");
INSERT INTO blzNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Patalai i raaya'a. Raaya'a mase koi mian mampisok men mangalambin mian mampisok. Kalu mian mampisok mangalambin mian mampisok, sabole rua-rua'na mandawo' na bolo'.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kasi i Petrus norobu na Ko'ona taena, “Kai mikisiso'kon aratina timbaani' men mengerere wakana mian.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ia simbati i Yesus tae-Na, “Sianpo inti'ionmuu mbali'? ");
INSERT INTO blzNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sianpo kuu inti'i se' giigii' kakaan men minsoop na nganga' waaro'o na kompong ka' bo uarkonon soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kasee upa ba'idek men umuar na nganga' sabole mimpu'u na noa, ka' iya'a a men mengerere wakana mian. ");
INSERT INTO blzNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gause na noa a nimpu'uanna giigii' pikiran men ba'idek. Pikiran koiya'a a men manggau'kon mian mampapatei mian, muntumpangkon samba-samba, mogora', mamangan, momborekkon mian, ka' momotaekon. ");
INSERT INTO blzNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Raanono'mo a men mengerere wakana mian. Kasee kumaan men sian mingoso' sian mengerere wakana mian.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kasi i Yesus namarerei Genesaret ka' nomae' na libutan men karani' na kota Tirus tia kota Sidon. ");
INSERT INTO blzNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sa'angu' wiwine na libutan iya'a men samba Kana'an notaka ni Yesus ka' norobu boolak taena, “Tumpu, lee' ni Daud! Kolingu'konon i yaku'! Anakku wiwine lampingionna meena. Ia marepa tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kasee i Yesus sian ninsimbati wiwine iya'a. Kasi murit-Na nuntuu'i i Ia ka' nama'ase' taena i raaya'a, “Posuu' a wiwine kale'e mae'. Ia tongko' lolo-lolo' na komburi'ta ka' monggora'i!” ");
INSERT INTO blzNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ia simbati i Yesus tae-Na, “Yaku' niposuu' tongko' bona lipu' Israel, men koi domba nopenta'.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kasee wiwine iya'a nuntuu'imo i Yesus ka' nobanintuur, kasi norobu taena, “Tumpu, tulungon i yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ia simbati i Yesus tae-Na, “Sianta kana' a mangala kakaanna anak morio' ka' mintibarkon bona au'.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Taena wiwine iya'a, “Indo' Tumpu, kasee au'po mangkaan puputna kakaan men mandawo' na meja'na tombonona.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mbaka' ia simbati i Yesus tae-Na, “Naung, balaki' tuu' a imaawan na Ingku'! Bi sida na ko'oom koi men kikira'am!” Mbaka' na tempopo iya'a, anakna wiwine iya'a nalesi'mo. ");
INSERT INTO blzNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus namarereimo libutan iya'a, kasi nomae' moso'ole na Danau Galilea. Noko daa iya'a, Ia nolumoponmo na buu'na ka' no'umoruang inda'a. ");
INSERT INTO blzNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Biai' a mian notaka na Ko'ona nangawawa mian men repo', mian men pepa', mian men mampisok, men umu', ka' biai' a mian soosoodo men isian nggeo sambana. Raaya'a nomokelamo mian men manggeo na arop ni Yesus ka' mian biai' men manggeo iya'a ia lesi'imo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mbaka' nosamba'mo a mian biai' men iraando'o gause nimiile' mian men umu' norobumo, men pepa' nalesi'mo, men repo' nolumempangmo, ka' men mampisok nopoopiile'mo. Kasi i raaya'a nuntunde' Alaata'ala men soosa'onna lipu' Israel. ");
INSERT INTO blzNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kasi i Yesus nengeleelo' murit-Na ka' norobu tae-Na, “Molingu' tuu' i Yaku' na mian biai' karaani'i. Tolungiliomo i raaya'a kamba'a tii Yaku', kasee sianta kakaanan. Ka' sian pokoon-Ku a momosuu' i raaya'a mule'kon tilolu, dako' poso' na salan.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kasi murit ni Yesus nobapikirawar na Ko'ona, taena, “Koi upa a bo pantausian kakaan na tampat kani'i men oloa na mian bo pamakaanta mian men biai' tuu' karaaya'a?” ");
INSERT INTO blzNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ia simbati i Yesus tae-Na, “Pipii a roti men isian na ko'omuu?” Taena, “Pipitu', tia susum morio' toropii.” ");
INSERT INTO blzNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mbaka' ia posuu'mo i Yesus a mian biai' iya'a umoruang na tano'. ");
INSERT INTO blzNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kasi i Ia ala a roti pipitu' roti tia susum iya'a ka' nobasukuur na Alaata'ala. Noko daa koiya'a, Ia rumpi-rumpikmo, kasi nirookon na murit-Na. Mbaka' ia obo-oboskonmo i raaya'a na mian biai' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Giigii' mian iya'a benteng nokumaan. Lapas nokumaan, raaya'a ningirimpungmo labina kakaan iya'a. Labina iya'a dauga' nobuke' pitu' basung. ");
INSERT INTO blzNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Men nokumaan na tempo iya'a moro'one koi paat loloon mian, sianpo tonsoop men wiwine tia anak morio'. ");
INSERT INTO blzNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kasi i Yesus nomosuu' mian biai' iya'a mule'kon. Ia nolumakitmo na sa'angu' duangan ka' notarabut paraas libutan Magadan. ");
INSERT INTO blzNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kasi toropii mian Farisi tia mian Saduki notaka ni Yesus mingkira' mimitopongi i Ia. Raaya'a mama'ase' kada' i Yesus mangawawau upa kosamba' bookoi oos se' i Ia notaka nda'ara'amari na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kasee ia simbati i Yesus tae-Na, “Kalu maamaalom piile'onmuu langit memea', kuu mangaan se' bo pengkar liila. ");
INSERT INTO blzNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ka' kalu ma'ulo-ulop piile'onmuu langit memea' ka' antongon, kuu mangaan se' bo usan kodi' ini'i. Kuu minginti'i mimiile' oosan na langit pataka i kuu minginti'i upa men bo sida, kasee i kuu sian minginti'i mimiile' upa men ia limang Alaata'ala na tempo koini'i! ");
INSERT INTO blzNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mian men tumuo' na tempo koini'i ba'idek tuu' ka' sian malolo'! Raaya'a mama'ase' sa'angu' upa kosamba' kada' i raaya'a mamarasaya i Yaku', kasee i raaya'a sian taraion sa'angu'po upa kosamba' saliwakon upa kosamba' koi men nosida ni Nabii Yunus.” Noko daa norobu koiya'a, Yesus nomae'mo namarerei i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kasi i Yesus tia murit-Na nolumembet na Danau Galilea, kasee murit-Na nolimbo' nangawawa roti. ");
INSERT INTO blzNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus norobu na ko'ona tae-Na, “Pore-pore ka' maka'amat i kuu na ragina mian Farisi tia mian Saduki.” ");
INSERT INTO blzNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Raaya'a nuntumbeimo pootunduni taena, “Ai Ia nangaan koiya'a gause i kita sian nangawawa roti.” ");
INSERT INTO blzNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kasee i Yesus ninginti'i upa men pootunduniikononna i raaya'a mbali' i Ia norobu tae-Na, “Wee i kuu men sian laan parasaya! Nongko'upa i kuu se' tongko' momootunduniikon sianta roti? ");
INSERT INTO blzNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Sia-siannapo mbali' kuu inti'i? Sianmo mbali' kuu oos a roti lilima' men Yaku' rumpi-rumpik bona mian lima' loloon? Kasi pipii basung a labina roti men kuu rimpung? ");
INSERT INTO blzNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ka' koi upa a pipitu' roti men bona paat loloon mian? Pipii basung a labina men kuu rimpung? ");
INSERT INTO blzNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nongko'upa i kuu se' dauga' sian minginti'i se' taasi' roti a men tundunon-Ku? Kasee maka'amat i kuu na ragina mian Farisi tia mian Saduki!” ");
INSERT INTO blzNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na temposi iya'a kasi ia inti'i murit-Na se' i Yesus nambantili i raaya'a kada' maka'amat na pisiso'na mian Farisi tia mian Saduki, taasi' na ragi men bo pangawawau roti. ");
INSERT INTO blzNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kasi i Yesus tia murit-Na nomae' na libutan Kaisarea Filipi. Yesus nimikirawarimo murit-Na tae-Na, “Koi taena mian, ime mbali' a Anak Manusia?” ");
INSERT INTO blzNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ia simbati i raaya'a taena, “Isian men mangaan ai Yohanes Pansarani. Men sambana mangaan a i Elia. Ka' men sambana mangaan se' i Yeremia, kabai se' sa'angu' mian na giigii' nabii.” ");
INSERT INTO blzNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Taeni Yesus soosoodo, “Kasee ka' na ko'omuu, ai ime i Yaku' kani'i?” ");
INSERT INTO blzNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ia simbati i Simon Petrus taena, “Kuu a Tomundo' Pansalamatkon, Anakna Alaata'ala, Alaata'ala Men Tumuo'.” ");
INSERT INTO blzNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kasi taeni Yesus, “Barakaatan i koo, Simon anak ni Yunus! Gause taasi'po mian a men ninsiso'kon na ko'oom, kasee Tamang-Ku men na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mbali' iya'a, bantilkonon-Ku na ko'oom se' i koo Petrus, koi watu men moonggor. Ka' na wawona watu kani'i a bo pomokereran-Ku jama'at-Ku, men sian pokoonna dodongoanna mian lapus tuaion! ");
INSERT INTO blzNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bo rookonon-Ku na ko'oom a kuncina Batomundo'anna Surugaa. Upa men koo kokundakon bo wawauonna mian na tano' balaki' kani'i, ia poko kokundakonmo Alaata'ala na surugaa. Ka' upa men koo patalaikon bo wawauonna mian na tano' balaki', ia poko patalaikonmo Alaata'ala na surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Noko daa iya'a ai Yesus nomotoomo murit-Na kada' alia mambantilkon mau ni imepo se' i Iamo a Tomundo' Pansalamatkon. ");
INSERT INTO blzNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Noko daa koiya'a, ai Yesus nuntumbeimo mompopo'inti'ikon na murit-Na se' i Ia tio mae' na Yerusalem, ka' na Yerusalem motu-motu'a, tanaasna imam, ka' wawa ukum Torat bo mengerepai i Ia. Ia bo papateion, kasee na ilio kotolu'na bo potuo'ion. ");
INSERT INTO blzNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kasee i Petrus nangawawa i Yesus waale'e na soripi'na ka' nongkomaso'i, taena, “Tumpu, sulano Alaata'ala mongoloakon men koiya'a! Men koiya'a sabole sian sida na Ko'omuu!” ");
INSERT INTO blzNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus ningilingamo i Petrus ka' norobu na ko'ona tae-Na, “Kumbaale'ena i koo, Ibiliis! Koo mantalantangi i Yaku'. Pinginti'iim kanono' pinginti'ina mian, taasi' pinginti'na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kasi i Yesus norobu na murit-Na, tae-Na, “Mian men mingkira' mongololo' i Yaku' tiodaa mongkolimbo'kon pingkira'na noana kasi mamasa'an saliipna ka' mongololo' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gause mian men mampari-pari mansalamatkon wakana na tano' balaki' kani'i, ia sian mantausi tutuo' men pore. Kasee mian men mongorookon wakana bo Ingku', ia bo mantausi tutuo' men pore. ");
INSERT INTO blzNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aupa mbali' a ee'na men takakononna mian mau ia montombonoi longkop tano' balaki' kasee komburi'na sian mantausi tutuo' men pore? Sianta upa men umangga' men sida pombolosi tutuo' men pore iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gause Anak Manusia bo taka soosoodo tia malaa'ikat-Na. Ia bo taka tia kuasana Tama-Na, ka' na tempo iya'a, Ia bo mangawalos giigii' mian koi wawauna. ");
INSERT INTO blzNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' isian i kuu men daa mokaraani'i men sianpo lapus kalu koo'po mimiile' Anak Manusia taka bo pontomundo'i na batomundo'an-Na.” ");
INSERT INTO blzNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Koi noommo ilio a noporusanna, Yesus nangawawamo i Petrus ka' i Yakobus tia utusna men i Yohanes nasawe' na buu'na sa'angu' men alayo'. Sianta mian sambana indo'o. ");
INSERT INTO blzNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kasi dudus ni Yesus nokoboliian na aropna i raaya'a. Ro'upna notarangmo somo koi ilio, ka' juba-Na nosidamo bubulak tamban dingkalapan. ");
INSERT INTO blzNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kasi totolu' murit-Na nimiile' i Musa tii Elia pintanga' batundun tii Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mbaka' taeni Petrus na ko'ona i Yesus, “Tumpu, ma'amat tuu' i kita isian na tampat kani'i. Kalu Kuu mingkira', daa bo pokereriionku sa'up totolu' ka'ita, sa'angu' bo Ko'omuu, sa'angu' boni Musa, ka' sa'angu' boni Elia.” ");
INSERT INTO blzNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pintanga' i Petrus morobu, nalaumo a antong men tarang nansa'upi i raaya'a, ka' na antong iya'a isian wurung men nokamporongoran nangaan taena, “Ni'imo a Anak-Ku men kolingu'-Ku. Ia men daa kokana'-Ku. Porongori i Ia!” ");
INSERT INTO blzNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sarataa a murit ni Yesus nongorongor men koiya'a, raaya'a nolayaonmo tuu' tamban notonsumpul na tano'. ");
INSERT INTO blzNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kasee i Yesus nembeelimo i raaya'a ka' nongkoyong, kasi norobu tae-Na, “Kekerer. Alia layaon!” ");
INSERT INTO blzNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sarataa i raaya'a notumangak, raaya'a sian nimiile' sa'angu'po mian, somo i Yesus suungna indo'o. ");
INSERT INTO blzNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tempo i raaya'a notumokuru na buu'na iya'a, Yesus nomotoomo i raaya'a tae-Na, “Alia montoobantilkonkuu ni imepo aupa men kuu piile' umba'a kalu Anak Manusia sianpo potuo'ion moko daa lapus.” ");
INSERT INTO blzNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Murit-Na nobapikirawarmo na Ko'ona taena, “Kalu koiya'a, nongko'upa a wawa ukum Torat muntundun se' i Elia tio taka olukon koo'po tia kotakaan-Na Tomundo' Pansalamatkon?” ");
INSERT INTO blzNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ia simbati i Yesus tae-Na, “Ai Elia tuutuu' taka olukon, kada' giigii' upa bi toropot. ");
INSERT INTO blzNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ka' bantilkonon-Ku na ko'omuu se' i Elia noko takamo, see i ia sian inti'ionna mian. Raaya'a nangawawaukon i ia koi pingkira'na i raaya'a. Ka' koiya'a uga' a pangawawauna i raaya'a Anak Manusia.” ");
INSERT INTO blzNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ya'asi ka' ia inti'i murit-Na se' i Yesus nuntundun i Yohanes Pansarani men koi i nabii Elia. ");
INSERT INTO blzNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sarataa i Yesus tia murit-Na totolu' nomule'kon na mian biai' iya'a, notakamo a sa'angu' moro'one nobanintuur nonsoosa' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Moro'one iya'a norobumo taena, “Tumpu, kolingu'konon a anakku. Ia nikalo' ka' marepa tuu'. Ia malia' torimpa' na apu ka' mandawo' na weer. ");
INSERT INTO blzNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ia yaku' wawamo na murit-Muu, kasee i raaya'a sian nomoko nengelesi'i.” ");
INSERT INTO blzNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mbaka' ia simbatimo i Yesus tae-Na, “Alia uga' i kuu mian men tumuo' na tempo koini'i! Kuu tuutuu' mian men sian parasaya ka' men nosala'mo salan. Pataka ipi mbali' Yaku' tio dumodongo tii kuu? Pataka ipi mbali' i Yaku' tio mokotaan na upa men wawauonmuu? Wawa a anak kanono' le'emari!” ");
INSERT INTO blzNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kasi i Yesus nengerengeaki meena men nangalampingi anak iya'a. Mbaka' no'umuarmo a meena iya'a ka' anak iya'a liuliu nalesi'. ");
INSERT INTO blzNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sarataa somo raaraaya'ana, murit ni Yesus nuntuu'imo i Ia kasi nobapikirawar taena, “Nongko'upa i kai se' sian nomoko numbuse'i meena iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ia simbati i Yesus tae-Na, “Kuu sian nomoko gause i kuu sian laan parasaya. Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' kalu i kuu imaanan mau tongko' koi kobalaki'na watuna sasawi, kuu momoko momosuu' buu'na kaya'a, ‘Balimba' kande'e!’ mbaka' sabole balimba' a buu'na kaya'a. Ka' sianta sa'angu'po a upa men sian pokoonmuu wawauon!  ");
INSERT INTO blzNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kasee meena men koi umba'a sian pokoon buse'ion kalu sian sambayang ka' ba'apata.” ");
INSERT INTO blzNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sarataa i Yesus tia murit-Na nobarimpung na Galilea, Yesus norobumo na murit-Na tae-Na, “Sianmo paraa manau' a Anak Manusia bo rookonon na kuasana mian. ");
INSERT INTO blzNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ia bo papateionna i raaya'a, kasee na ilio kotolu'na Ia bo potuo'ion.” Mbaka' nasiongo'mo tuu' a murit-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sarataa ari Yesus tia murit-Na notaka na Kapernaum, pagawe pajakna Laiganna Alaata'ala notakamo ni Petrus ka' nobapikirawar taena, “Gurumuu se' mambayar pajakna Laiganna Alaata'ala kabai sian?” ");
INSERT INTO blzNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ia simbati i Petrus taena, “Daa, mambayar!” Sarataa i Petrus ninsoop na laigan, ai Yesus nongolukonimo nimikirawari i ia. Tae-Na, “Simon, koi upa pinginti'iim? Ime a men tio mambayar pajak bona tomundo' na tano' balaki' kani'i? Mianna kabai se' mian sambana?” ");
INSERT INTO blzNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ia simbati i Petrus taena, “Mian sambana.” Taeni Yesus soosoodo, “Kalu koiya'a rayat sakat mambayar pajak. ");
INSERT INTO blzNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kasee kada' i kita sian mingidek noana i raaya'a, mbaka' i koo posuu'on-Ku bapeka na danau. Ala a susum men olukon koo poko'ule'. Bongkati a nganga'na mbaka' i koo bo mantausi doi' men saa'na paat dirham bo pambayar pajaak tia pajak-Ku. Ala a doi' iya'a ka' bayar a pajakta.” ");
INSERT INTO blzNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na tempopo iya'a, notakamo a murit ni Yesus nobapikirawar na Ko'ona. Taena i raaya'a, “Ime a men balaki'na na Batomundo'anna Surugaa?” ");
INSERT INTO blzNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mbaka' i Yesus nengeleelo'mo sa'angu' anak morio' kasi Ia pokerer a anak iya'a na aropna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kasi i Yesus norobu tae-Na, “Kada' bo inti'ionmuu: Bantilkonon-Ku na ko'omuu se' kalu i kuu sian mombolii gau'muu pataka sida koi anak morio' kani'i, kuu sian minsoop na Batomundo'anna Surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mian men mompopokoo' wakana ka' sida koi anak morio' kani'i, iamo a men balaki'na na Batomundo'anna Surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ime a men mangalaboti sa'angu' anak morio' koi kani'i gause mian iya'a mongololo' pisiso'-Ku, nono' a men ngaanon mangalaboti i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kasee ime a men manggau'kon sa'angu' anak morio' karaani'i men parasaya na Ingku' sida baradosa, mbulokon mian iya'a kootiion watu pinggiling na toure'na, kasi pololopon na tobui men alalom. ");
INSERT INTO blzNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Silaka' a dunia kani'i, gause isian upa-upa men manggau'kon mian baradosa. Daa mba'a uga' a upa-upa men koiya'a sabole sinampang isian, kasee silaka' a mian men mingilimang iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Too limamuu kabai se' saratmuu a manggau'kon i kuu baradosa, kolongi ka' balo'kon. Mbulokon limamuu kabai se' saratmuu somo sambotak kasee daa tumuo' tia Alaata'ala pookokoikonon tia limamuu kabai se' saratmuu sampa kasee i kuu tibarkonon na apu men sian kopate-pateanna. ");
INSERT INTO blzNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Too matamuu a manggau'kon i kuu baradosa, kuati ka' balo'kon a matamuu inono'! Mbulokon i kuu mampisok sambotak kasee daa tumuo' tia Alaata'ala pookokoikonon tia dauga' isian rua-rua'na matamuu kasee i kuu tibarkonon na apuna naraka.” ");
INSERT INTO blzNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Imamat pore-pore ini'imari! Alia sian mangangga'i sa'angu'po anak morio'. Bantilkonon-Ku na ko'omuu se' malaa'ikatna i raaya'a sinampang poopoopiile' tia Tamang-Ku men na surugaa.  ");
INSERT INTO blzNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gause Anak Manusia taka bo pansalamatkon mian men sian minginti'i Tumpu! ");
INSERT INTO blzNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Koi upa mbali' a pinginti'imuu? Kalu isian mian sa'angu' men dombaan sa'atu, ka' sa'angu' dombana iya'a nopenta', upa ansee a men bo wawauonna mian iya'a? Sabole parereionna kutung a domba men siompulo' sio' iya'a na buu'na, ka' mae' mansarak sa'angu' domba men nopenta' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' kalu tausionnamo a domba men nopenta' iya'a, sabole pongkobeleskonna sa'angu' domba men nopenta' iya'a labi tia pongkobeleskonna siompulo' sio' domba sambana men sian nopenta'. ");
INSERT INTO blzNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Koiya'a uga' a Tamamuu men na surugaa sian kikira'-Na kalu isian sa'angu' anak morio' karaani'i sida penta'.” ");
INSERT INTO blzNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kalu utusmuu sa'angu' kaparasaya'an nangawawau dosa, rae' ka' bantili i ia men tongko' rua' kuu daamo. Kalu porongorionna a bantilimuu, mbaka' wawamuu sida pore soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kasee kalu ia sian momorongori i kuu, angekon soosoodo sa'angu' kabai se' rurua' mian. Gause na Alkitaap isian nitulis koi kani'imari: ‘Titiu'namo rurua' kabai se' totolu' mian a men bo pinginti'ian too tuutuu' a mian sala'an kabai se' sian.’ ");
INSERT INTO blzNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kalu sian porongorionna a bantilina mian iya'a, bantilkon na jama'at. Ka' komburi'na, kalu sia-siannapo porongorionna a bantilina mian na jama'at iya'a, galalmo i ia koi sa'angu' mian men sian minginti'i Alaata'ala kabai se' koi pagawena pajak.” ");
INSERT INTO blzNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' upa men kuu kokundakon bo wawauonna mian na tano' balaki' kani'i ia poko kokundakonmo Alaata'ala na surugaa. Ka' upa men kuu patalaikon bo wawauonna mian na tano' balaki' kani'i, ia poko patalaikonmo Alaata'ala na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Bantilkonon-Ku uga' na ko'omuu kalu isian rua' mian na tano' balaki' kani'i nopoo'akoori mama'ase' upa-upa, sabole pa'ase'na i raaya'a bo loloikononna Tamang-Ku men na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kalu isian rurua' kabai se' totolu' mian barimpung gause i raaya'a mian-Ku, Yaku' sabole isian tii raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kasi notaka i Petrus nobapikirawar ni Yesus taena, “Kalu utusku sa'angu' kaparasaya'an mangawawau dosa na ingku', tio piripii yaku' mangampuni i ia? Pataka piripitu'?” ");
INSERT INTO blzNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ia simbati i Yesus tae-Na, “Sian. Bantilkonon-Ku na ko'omuu se' taasi' tongko' piripitu', kasee tio pitumpulo' kali pipitu'! ");
INSERT INTO blzNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Gause Batomundo'anna Surugaa koi timbaani' kani'imari. Isian sa'angu' tomundo' men mama'ase' mansaa' samayana tutulungina. ");
INSERT INTO blzNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na tempo i ia muntumbei mansaa', niwawamo na ko'ona a sa'angu' tutulungi men samayaon sompulo' loloon doi' mosoni. ");
INSERT INTO blzNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kasee samayana mian iya'a sianmo pokoonna bontorion. Mbaka' tomundo' nomosuu'mo kada' mian iya'a balukkononmo tia anakna ka' boroki'na ka' uga' giigii' upana, kada' bo pombontori samayana. ");
INSERT INTO blzNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mbali' iya'a, tutulungi iya'a nobanintuurmo monsoosa' tomundo' iya'a, ka' nama'ase' taena, ‘Tuan, taraion tempo i yaku'! Yaku' bo mombontori giigii' samayangku.’ ");
INSERT INTO blzNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mbaka' nolingu'mo a tomundo' iya'a, mbali' ia sapuimo a giigii' samayana mian iya'a kasi nipatalai nomae'. ");
INSERT INTO blzNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sarataa no'umuar a tutulungi iya'a, ia nopootuungmo tia simbaya'na men uga' tutulungi. Simbaya'na iya'a samayaon sa'atu doi' dinar na ko'ona. Ia rakopmo a simbaya'na men samayaon iya'a ka' nipegot, kasi norobu taena, ‘Bontori a giigii' samayaam na ingku'!’ ");
INSERT INTO blzNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kasi nobanintuur a simbaya'na iya'a ka' nama'ase na ko'ona taena, ‘Taraion tempo i yaku'! Yaku' bo mombontori samayangku!’ ");
INSERT INTO blzNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kasee i ia kunda koiya'a. Ia nangatormo simbaya'na men samayaon iya'a bo tarungkuon pataka kobontorian a samayana. ");
INSERT INTO blzNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sarataa tutulungi sambana nimiile' upa men nosida, raaya'a nolingu'mo, kasi i raaya'a nambantilkon na tomundo'. ");
INSERT INTO blzNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mbaka' tomundo' iya'a nomosuu'mo nengeleelo' tutulungi iya'a ka' norobu na ko'ona taena, ‘Noaam se' ba'idek tuu'! Taasi' giigii' samayaam yaku' sapuimo gause koi pa'ase'em na ingku'? ");
INSERT INTO blzNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kalu koiya'a i koo uga' tio molingu'kon simbaya'am koi i yaku' nolingu'kon i koo!’ ");
INSERT INTO blzNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tomundo' iya'a nomaso'mo tuu' ka' nomosuu' kada' tutulungi men ba'idek a noana iya'a papolosion ka' soopkonon na tarungkuan pataka bontorionna a giigii' samayana.” ");
INSERT INTO blzNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kasi taeni Yesus, “Koiya'a uga' a Tamang-Ku men na surugaa bo mongkoiya'akon i kuu kalu i kuu sian maloos a noamuu mangampuni utusmuu sa'angu' kaparasaya'an.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Noko daa i Yesus nambantilkon pisiso'-Na, Ia namarereimo Galilea ka' nomae' na libutan Yudea na sambotakna Weerkauna Yordan. ");
INSERT INTO blzNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Biai' a mian men nongololo' i Ia, ka' i raaya'a ia lesi'i i Yesus indo'o. ");
INSERT INTO blzNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kasi notaka a toropii mian Farisi mimitopongi i Yesus. Raaya'a nobapikirawarmo taena, “Koi upa pinginti'i-Muu? Too poturangon a moro'one mengerensai boroki'na mau mune' upapo a pongkokundaianna?” ");
INSERT INTO blzNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ia simbati i Yesus tae-Na, “Sianpo mbali' i kuu nambasa na Alkitaap se' i Ia men ninsidakon mian tumbena ninsidakon i raaya'a moro'one tia wiwine? ");
INSERT INTO blzNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Noko daa Ia ninsidakon mian Ia norobu tae-Na, ‘Mbali' iya'a, moro'one bo mamarerei tamana tia sinana ka' mosa'angu' tia boroki'na, mbaka' rua' mian iya'a nosidamo koi sa'angu' waka.’ ");
INSERT INTO blzNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mbaka' moro'one tia boroki'na taasi'mo rurua' kasee sa'angu'. Mbali' iya'a, upa men ia posa'angu'mo Alaata'ala sian sida rensaonna mian.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kasi mian Farisi nobapikirawar soosoodo, taena, “Kalu koiya'a, nongko'upa i Musa se' nomosuu' mian mantarai surat poorensaanna suo' bona boroki'na men ia rensai?” ");
INSERT INTO blzNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ia simbati i Yesus tae-Na, “Ai Musa nomoturang i kuu mengerensai boroki'muu gause i kuu bingilan. Kasee men tumbena taasi' koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Bantilkonon-Ku na ko'omuu se' ime a men mengerensai boroki'na see boroki'na iya'a sian nogora', kasi langkai'na iya'a mosuo' soosoodo tia wiwine sambana, mbaka' moro'one iya'a muntumpangkon.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Murit ni Yesus norobumo taena i raaya'a, “Kalu koiya'a poowawana mian men motosamba, mbulokon alia mosuo'.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ia simbati i Yesus tae-Na, “Wurung men koi kanooro'o sian giigii' mian sida mangalabot, kasee tongko' mian men ia tarai Tumpu pinginti'ian men koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Isian mian men sian sida mosuo' gause i ia nongamea' men koiya'a. Isian uga' men sian sida mosuo' gause ia gau'kon mian. Ka' isian uga' men sian mosuo' gause pingkira'na suungna kada' sida balimang na Batomundo'anna Surugaa. Ime a men momoko mongololo' pisiso'-Ku kani'i, alaka' lolo'.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kasi isian mian nangawawa anak morio' waale'e ni Yesus kada' i Ia mengepetkon lima-Na ka' mansambayangkon i raaya'a. Kasee murit ni Yesus tongko' nongkomaso'i mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mbaka' i Yesus norobumo na murit-Na tae-Na, “Patalai a anak karaanono' taka na Ingku'! Alia mantaankon i raaya'a, gause mian men koi anak karaani'i a men bo mianna Batomundo'anna Surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kasi i Yesus nengepetkon lima-Na na anak morio' iya'a ka' nambarakaati. Noko daa iya'a, kasi i Ia namarerei tampat iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sa'angu' tempo isian sa'angu' moro'one notaka ni Yesus. Ia nobapikirawar taena, “Guru, wawau pore koi upa men tio bo wawauonku kada' mantausi tutuo' men pore pataka sidutu?” ");
INSERT INTO blzNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ia simbati i Yesus tae-Na, “Nongko'upa i koo se' mimikirawar na Ingku' upa men pore? Tongko' Sa'angu' a men pore. Kalu koo mingkira' mantausi tutuo' men pore, koo tio malolo' na potoona Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Taena mian iya'a, “Potoo men koi upa inooro'o?” Taeni Yesus, “Alia mampapatei mian, alia muntumpangkon samba-samba, alia mamangan ka' alia momborekkon mian. ");
INSERT INTO blzNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Angga'i a tamaam tia sinaam, ka' kolingu'kon a simbaya'am mian koikoimo pongkolingu'koon wakaam.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Taena anak malai moro'one, “Giigii' potoo kanooro'o yaku' poko loloikonmo. Dauga' upa soosoodo a men koo'po?” ");
INSERT INTO blzNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Taeni Yesus, “Kalu koo mingkira' talakana a tutuo'om, rae' balukkon a giigii' upaam. Rookon a doi'na na mian men talalais. Kalu koiya'a, koo bo mokosue kupang na surugaa. Moko daa kasi taka mongololo' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sarataa anak malai iya'a nongorongor wurung ni Yesus, ia nomae'mo. Noana masiongo' gause i ia biai' a kupangna. ");
INSERT INTO blzNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kasi i Yesus norobu na murit-Na tae-Na, “Imamat a men taeng-Ku. Bantilkonon-Ku na ko'omuu se' marepa tuu' a mian kupangon minsida mianna Batomundo'anna Surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bantilkonon-Ku na ko'omuu soosoodo se' bagiakon sa'angu' unta minsoop na bolo'na pakaut a daana, tia sa'angu' mian kupangon minsida mianna Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sarataa murit ni Yesus nongorongor men koiya'a, raaya'a nosamba'mo tuu'. Taena, “Ka' koiya'a, ai ime ansee a men sida salamatkonon?” ");
INSERT INTO blzNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus nintiokimo i raaya'a kasi norobu tae-Na, “Manusia sian momoko mansalamatkon wakana, kasee giigii' upa pokoonna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kasi i Petrus norobu ni Yesus taena, “Piile'! Kai namarereimo giigii' upamai ka' nongololo' i Kuu. Ansee upa bo tambomai?” ");
INSERT INTO blzNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ia simbati i Yesus tae-Na, “Tuutuu' mba'a. Ka' bantilkonon-Ku na ko'omuu se' na tempo Alaata'ala mungule'kon giigii' upa na dunia koi men tumbe, Anak Manusia bo umoruang na oruangan kobalaki'an-Na. Na tempo iya'a, kuu men nongololo'mo i Yaku' bo umoruang na sompulo' rua' oruangan kobalaki'an ka' mungukumi sompulo' rua' bense'na lipu' Israel! ");
INSERT INTO blzNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ka' giigii' mian men mamarerei laiganna, kabai mamarerei utusna wiwine ka' utusna men moro'one, kabai se' mamarerei tamana kabai sinana, kabai mamarerei anakna, kabai se' ale'na gause na pongololo'an i Yaku', mian iya'a bo moko'ule' soosoodo pirisa'atu paku'. Ka' i ia bo moko'ule' tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kasee biai' a mian men tongaan tempo koini'i bo kosian tongaan tempo ni'imarian. Ka' uga' mian men tempo koini'i piile'onta sianta tongaan, bo tongaan tempo ni'imarian.” ");
INSERT INTO blzNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Batomundo'anna Surugaa koi timbaani' kani'imari. Sa'angu' mian men tombono ale'na anggur no'umuar ma'ulo-ulop mae' mansarak mian bo balimang na ale'na. ");
INSERT INTO blzNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sarataa nosangada se' sangilio tambona sa'angu' doi' dinar, ia nomosuu'mo i raaya'a balimang na ale'na anggurna. ");
INSERT INTO blzNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Toro jaammo sembilan ma'ulop, tombono ale' iya'a no'umuarmo soosoodo kasi nimiile' toropii mian men sian palimangonna iraando'o na tampat pobalukan ka' ba'ilianna mian. ");
INSERT INTO blzNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mbaka' i ia norobumo na ko'ona i raaya'a taena, ‘Rae' i kuu balimang na ale'na anggurku. Tamboionkusi i kuu tambo koi men kosidana.’ Mbaka' i raaya'a nomae'mo. ");
INSERT INTO blzNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Toro jaam dua blaas tanga'iloa' ka' jaam tiga tobiling, tombono ale' iya'a no'umuarmo soosoodo ka' nangange mian balimang na ale'na. ");
INSERT INTO blzNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kasi toro jaam lima maamaalom, tombono ale' iya'a no'umuarmo soosoodo ka' nimiile' mian sambana men sian nobalimang. Ia norobumo na ko'ona i raaya'a taena, ‘Nongko'upa i kuu se' sangiliomo tongko' potorokot karaa'ita, sian balimang?’ ");
INSERT INTO blzNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ia simbati i raaya'a taena, ‘Gause sianta mian men bo pangalaanmai tambo.’ Mbaka' ia posuu'mo tombono ale' iya'a taena, ‘Rae' i kuu uga' balimang na ale'ku.’ ");
INSERT INTO blzNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Guntumalommo, norobumo a tombono ale' iya'a na mian men mandagai mian balimang taena, ‘Leelo' a mian men nobalimang ka' rookon a tambona. Po'olukon a mian men ninsoop komburi', kasi mian men olukon ninsoop.’ ");
INSERT INTO blzNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mbaka' notakamo a mian men nuntumbei balimang jaam lima. Raaya'a nitarai toro sa'angu'anna doi' dinar. ");
INSERT INTO blzNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kasi notaka soosoodo a mian men ma'ulo-uloppo a nuntumbeianna balimang. Raaya'a mansarui se' ko'ona a biai'na. Kasee i raaya'a uga' nitarai toro sa'angu'an doi' dinar. ");
INSERT INTO blzNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mbaka' sarataa nangalabot tambona, raaya'a nansasala'mo tombonona ale'. ");
INSERT INTO blzNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Taena, ‘Mian men ninsoop komburi' tongko' nobalimang sa'angu' jaam. Kasee i kai men sumasangiliomo balimang marawat ka' ganggarionna pengkar. Mau mune' koiya'a tambona i raaya'a men kuu rookon koikoimo tia tambomai!’ ");
INSERT INTO blzNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kasee tombono ale' iya'a ninsimbati sa'angu' mian men isian na ko'ona i raaya'a taena, ‘Utus! Sian sala' i yaku' na ko'oom. Taasi' i koo nosangadamo tamboion doi' sa'angu' salaka' sangilio? ");
INSERT INTO blzNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ala oboos ka' rae'! Yaku' nantarai tambona mian men ninsoop komburi' koikoimo tia tambo men yaku' rookon na ko'omuu gause koiya'a men kikira'ku. ");
INSERT INTO blzNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sian sida mbali' i yaku' bo pinginti'i upangku koi pingkira'ku? Kabai i koo masindir montookon yaku' mongkolingu'kon mian?’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kasi i Yesus norobu soosoodo tae-Na, “Kasee biai' a mian men sian angga'ion tempo koini'i bo angga'ion tempo ni'imarian, ka' biai' a mian men angga'ion tempo koini'i sianta angga'ion tempo ni'imarian.” ");
INSERT INTO blzNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Banta-bantang ari Yesus mae' na Yerusalem, na tanga'na salan Ia nangangemo sompulo' rua' murit-Na barimpung raaraaya'ana. Yesus norobumo na murit-Na tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Imamat ini'imari! Koini'i kita banta-bantang mae' na Yerusalem, ka' Anak Manusia bo rookonon na tanaasna imam tia wawa ukum Torat. Ka' i raaya'a bo mungukum Anak Manusia tia ukuman pate. ");
INSERT INTO blzNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ia bo kalaakonon na mian men taasi' Yahudi. Ia bo irokion, sasalion, ka' saliipkonon. Kasee na ilio kotolu'na, Ia bo potuo'ion.” ");
INSERT INTO blzNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kasi sinana anak ni Zebedeus tia anakna notaka nuntuu'i i Yesus. Ia nobanintuurmo mama'ase' men kikira'na. ");
INSERT INTO blzNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus nimikirawarimo wiwine iya'a tae-Na, “Aupa men kikira'muu?” Ia simbati wiwine iya'a taena, “Kikira'ku a anakku rua' ira kani'i po'oruangon na batomundo'an-Muu, sa'angu' paraas uanan-Muu ka' sa'angu'na paraas kauri'-Muu.” ");
INSERT INTO blzNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Taeni Yesus, “Kuu sian minginti'i upa men pa'ase'onmuu. Se' daa pokoonmuu a minginum na inuman repaan men tiodaa bo inumon-Ku?” Ia simbati i raaya'a taena, “Daa, pokoonmai!” ");
INSERT INTO blzNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Taeni Yesus soosoodo, “Daa mba'a. Kuu bo minginum na inuman repaan men bo inumon-Ku. Kasee ime a men bo umoruang na uanan-Ku kabai se' na kauri'-Ku taasi' i Yaku' a men bo pinginti'i. Tamang-Ku a men bo pinginti'i mian men taraion-Na oruangan men Ia poko toropotikonmo iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nongorongor se' koiya'a, sompulo' murit ni Yesus nongkomaso'konmo i raaya'a rua' ira moto'utus. ");
INSERT INTO blzNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kasee i Yesus nengeleelo' i raaya'a ka' norobu tae-Na, “Kuu poto'inti'i se' pamarentana lipu' men sian minginti'i Alaata'ala mantalalais mianna. Ka' moomoola'na lipu' iya'a mamarenta mianna koi pingkira'na susuung. ");
INSERT INTO blzNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kasee i kuu amo' koiya'a. Kuu men mingkira' sida mian moola', kuu tio sida bo tutulungna mian. ");
INSERT INTO blzNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kuu men mingkira' tongaan na mian, kuu tio sida koi sa'angu' ata'na mian. ");
INSERT INTO blzNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Koiya'a wawauna Anak Manusia. Ia notaka taasi' kalesangon. Ia taka mangkalesang ka' mongorookon noa-Na tia waka-Na papateion bo pontololoki dosana mian biai'.” ");
INSERT INTO blzNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sarataa i Yesus tia murit-Na namarerei Yerikho, mian biai' nobeormo nongololo' i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Isian rua' mian mampisok poto'oruang na soripi'na salan. Sarataa i raaya'a nongorongor se' i Yesus nolumiu, raaya'a nangkakaro'mo taena, “Tumpu, lee' ni Daud! Kolingu'konon i kai!” ");
INSERT INTO blzNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mian biai' iraando'o nongkokundakon i raaya'a ka' nomosuu' kada' mimporokot. Kasee rua' mian mampisok iya'a tongko' kaekae' momboolaki mangkakaro'. Taena, “Tumpu, lee' ni Daud! Kolingu'konon i kai!” ");
INSERT INTO blzNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mbaka' notaanmo i Yesus, kasi nengeleelo' ka' nimikirawari i raaya'a tae-Na, “Aupa men kikira'muu kada' wawauon-Ku na ko'omuu?” ");
INSERT INTO blzNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ia simbati i raaya'a taena, “Tumpu, kai mingkira' bi poopiile'!” ");
INSERT INTO blzNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus nolingu'konmo i raaya'a, mbaka' Ia koyongmo a matana i raaya'a. Na tempopo iya'a i raaya'a nopoopiile'mo. Kasi i raaya'a nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sarataa i Yesus tia murit-Na montorumpakimo Yerusalem, indo'omo na kampung Betfage men na Buu'na Zaitun, Ia nomosuu'mo murit-Na rurua' mae' olukon, ");
INSERT INTO blzNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ka' nomotoo tae-Na, “Rae' na kampung katu'u men torumpakionta Kuu bo liuliu mungurumpaki keledai wiwine men tootoongkon tia anakna rundara beebeel. Alaka' kakai a kokootna rua-rua'na ka' wawa tu'umari na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kalu isian mian mongkosamba'i i kuu, bantilkon inta', ‘Tumpu mamaraluui. Ka' keledai iya'a sian paraa maalin daa ule'konon-Namo.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tempo i Yesus nangawawau koiya'a, mbaka' nosidamo a wurungna Tumpu koi men ia tadulkon nabii men koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bantilkon mian na kota Sion: Piile'! Tomundo'muu taka na ko'omuu. Ia ma'amat a noana ka' nolumakit na sa'angu' keledai wiwine lolo-lolo' a anakna.” ");
INSERT INTO blzNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mbaka' nomae'mo a rua' murit-Na iya'a ka' nangawawau koi men ia posuu'kon i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Raaya'a nangawawamo keledai wiwine iya'a tia anakna rundara, kasi nangalatasi sengke'na tia jubana i raaya'a. Noko daa koiya'a, kasi i Yesus nolumakit. ");
INSERT INTO blzNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Biai' a mian nanggampalkon bokukumna i raaya'a na salan, ka' men sambanaanna nongkolong panga' morio' ka' nendeer na salan. ");
INSERT INTO blzNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Giigii' mian men potorae', mau men na olukon ka' men na komburi', mangkakaro'kon taena, “Tunde' a lee' ni Daud! Barakaatan i Ia men taka ia pokau Tumpu! Tunde' a Alaata'ala men na ko'alayo'an!” ");
INSERT INTO blzNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sarataa i Yesus ninsoop na Yerusalem, giigii' mian men na kota iya'a nogenggewumo. Taena, “Ime a mian kaya'a?” ");
INSERT INTO blzNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ia simbati mian men potololo' i Yesus taena i raaya'a, “Ni'imo i Nabii Yesus men ringkat na Nazaret libutan Galilea!” ");
INSERT INTO blzNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Noko daa iya'a ai Yesus ninsoopmo Laiganna Alaata'ala ka' numbuse'i giigii' mian men ba'ili ka' men mobalu-baluk indo'o na tolodona Laiganna Alaata'ala. Meja'na mian men totolosi doi' ka' bangkona mian men mobaluk marampatii Ia tua-tua'kon. ");
INSERT INTO blzNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kasi i Yesus norobu na ko'ona tae-Na, “Na Alkitaap isian nitulis koi kani'imari: ‘Laigan-Ku tio ngaanon laigan bo basambayangan.’ Kasee kuu wawaumo bo dodongoanna mian puraga!” ");
INSERT INTO blzNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mian men mampisok tia mian men pepa' notaka ni Yesus na Laiganna Alaata'ala. Raaya'a ia lesi'i i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kasee tanaasna imam tia wawa ukum Torat nomaso'mo nimiile' upa kosamba' men ia wawau i Yesus. Ka' i raaya'a nomaso' nomorongor anak mangkakaro' na Laiganna Alaata'ala men taena, “Tunde' a lee' ni Daud!” ");
INSERT INTO blzNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Raaya'a norobumo ni Yesus taena, “Koo nongorongor upa men taena i raaya'a?” Ia simbati i Yesus tae-Na, “Daa, Yaku' rongor! Kasee sianpo kuu basa mbali' a isiina Alkitaap men koi kani'imari: ‘Tumpu! Anak morio' tia men ngamea' Kuu poko pisiso'mo muntunde' i Kuu’?” ");
INSERT INTO blzNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Noko daa iya'a ai Yesus namarereimo mian biai' no'umuar na kota, mae' na Betania kasi notokol indo'o. ");
INSERT INTO blzNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Koi liilana ma'ulo-ulop, banta-bantang i Yesus mule'kon na Yerusalem, Ia nopoosurimo nololu. ");
INSERT INTO blzNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ia nimiile' kau ara sangkau na soripi'na salan, kasi nuntuu'i kau iya'a, kasee sianta sa'angu'po a woo'na men Ia tausi saliwakon roonana. Kasi i Yesus nomorobu na kau iya'a tae-Na, “Koo sianmo miwoo' pataka manau'!” Kau iya'a liuliu nalau. ");
INSERT INTO blzNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nimiile' upa men nosida iya'a, samba' a murit ni Yesus. Raaya'a nimikirawarmo taena, “Koi upa se' daa liuliu nalau a kau ara kale'e?” ");
INSERT INTO blzNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ia simbati i Yesus tae-Na, “Imamat a kau kale'e. Bantilkonon-Ku na ko'omuu se' kalu i kuu parasaya ka' sian babata, kuu sida mangawawau koi men Yaku' wawaumo na kau kale'e. Ka' taasi' tongko' koiya'a. Kuu uga' sida momosuu' buu'na kani'i, ‘Bi ko'akit ka' bi tombalo' i koo na tobui!’ mbaka' buu'na iya'a sabole balimba'. ");
INSERT INTO blzNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kalu i kuu parasaya, mau upa a men pa'ase'onmuu na Alaata'ala na sambayangmuu bo dapotonmuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kasi i Yesus nomule'kon na Laiganna Alaata'ala, ninsoop ka' nuntumbei nimisiso' indo'o. Pintanga' i Ia mimisiso', notakamo a tanaasna imam tia motu-motu'ana lipu' Yahudi bapikirawar. Taena i raaya'a, “Upa a pimpu'uaan nangawawau men koiya'a? Ka' ime a nantarai i Koo kuasa mbali' nangawawau giigii' iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ia simbati i Yesus tae-Na, “Yaku' uga' isian upa bo pikirawaron-Ku na ko'omuu. Alaka' simbati kada' bantilkonon-Ku i kuu se' kuasa ni ime mbali' daa i Yaku' mangawawau koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ime a men nantarai i Yohanes kuasa mansarani mian? Alaata'ala kabai mian?” Kasi tanaasna imam tia motu-motu'ana lipu' Yahudi nopootundunii raaraaya'ana, taena, “Kalu kita mangaan, ‘Kuasana ringkat na Alaata'ala,’ mbaka' simbation-Na, ‘Nongko'upa i kuu se' kosian mamarasaya upa men taeni Yohanes?’ ");
INSERT INTO blzNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kasee kalu simbationta se' tia kuasana mian ansee i kita bo komaso'kononna mian biai' gause pimiile'na mian giigii' se' i Yohanes sa'angu' nabii.” ");
INSERT INTO blzNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mbaka' ia simbatimo i raaya'a taena, “Sian inti'ionmai!” Kasi taeni Yesus, “Kalu koiya'a Yaku' sian mambantilkon na ko'omuu se' kuasa ni ime bo pimpu'uan-Ku mangawawau koiya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Taeni Yesus, “Kasee koi upa pinginti'imuu timbaani' kani'imari? Isian sa'angu' mian men anakon moro'one rurua'. Ia nomae'mo na anakna men balaki'na ka' nomosuu' taena, ‘Rae' i koo balimang na ale'na anggur ilio kani'i!’ ");
INSERT INTO blzNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ia simbati anakna taena, ‘Yaku' kunda!’ Kasee noko daa iya'a i ia ninsosolmo ka' nomae'mo na ale'na anggur. ");
INSERT INTO blzNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kasi tamana anak iya'a nomae' na anakna men korua'na ka' nomosuu' taena, ‘Rae' i koo balimang na ale'na anggur ilio kani'i!’ Ia simbati anak iya'a taena, ‘Daa, Papa!’ Kasee i ia sian nomae'.” ");
INSERT INTO blzNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesus nimikirawarimo i raaya'a tae-Na, “Na rurua' anak iya'a, ime a men daa nongololoikon pingkira'na tamana?” Ia simbati i raaya'a taena, “Anak men balaki'na!” Taeni Yesus, “Tuutuu' mba'a. Ka' bantilkonon-Ku na ko'omuu se' pagawena pajak tia wiwine men eloon mongolukoni i kuu minsoop na Batomundo'anna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gause i Yohanes Pansarani notaka bo pinsiso'kon i kuu tutuo' men daa kikira'na Alaata'ala, see i kuu sian mamarasaya pisiso'na. Pagawena pajak tia wiwine men eloon a men daa namarasaya i ia. Mau mune' i kuu nimiile'mo giigii' iya'a, kuu sian nonsosoli ka' nangkadarai gau'muu men ba'idek ka' sian namarasaya i ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Taeni Yesus, “Porongor soosoodo a sa'angu' timbaani' kani'imari. Isian sa'angu' mian montombonoi tano' ka' tano'na iya'a ia asoki anggur. Ia nambalamo tiku-tikumna, ka' nengkeke bolo' bo pimiisan anggur, ka' nangawawau sa'up bo badagaian ale' iya'a. Kasi ia nantamboikon ale'na anggur iya'a na papalimang, ka' nomae' na lipu' sambana. ");
INSERT INTO blzNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tempo daa sidamo pumpupuan woo'na anggur iya'a, mian men tombono tano' iya'a nomosuu'mo tutulungina mae' na papalimang ale' iya'a mangala ule' men bokoi obosna. ");
INSERT INTO blzNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kasee papalimang iya'a nangarakopmo tutulungi iya'a. Raaya'a numukul men sa'angu', nampapatei men sambana ka' nangalapak men sambana tia watu. ");
INSERT INTO blzNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Noko daa iya'a mian men tombono tano' iya'a nomosuu'mo tutulungina men sambana, kasee labi tia men tumbena, ka' i raaya'apo niwawaukon koikoimo simbaya'na i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kokomburi'annamo ia nomosuu'mo anakna na ko'ona i raaya'a, taena, ‘Kalu anakku sabole kolayaonna i raaya'a.’ ");
INSERT INTO blzNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kasee na tempo papalimang iya'a nimiile' anak iya'a, raaya'a nopootunduniimo taena, ‘Iamo kaya'a a men bo pontombonoi giigii' upana tamana. Mai kita papateia i ia kada' kitamo a pontombonoi budelna.’ ");
INSERT INTO blzNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Raaya'a nangarakopmo ka' nintibarkon na liwana ale'na anggur iya'a, kasi nampapatei. ");
INSERT INTO blzNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kalu tombono ale'na anggur iya'a taka, upa a bo wawauonna na papalimang iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Taena tanaasna imam tia motu-motu'ana lipu' Yahudi, “Ia bo minsilaka'i mian men ba'idek iya'a ka' ale'na anggurna bo tamboikononnamo na papalimang men sambanaan, men daa mongorookon ule'na na ko'ona kalu temponamo.” ");
INSERT INTO blzNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Taeni Yesus soosoodo, “Sabole i kuu nambasamo na Alkitaap men koi kani'imari: ‘Watu men ia balo'konmo tukang nosidamo watu tuko men bo pandasi. Men koiya'a ia wawau Tumpu, ka' wawau-Na iya'a nompoposamba' i kita men nimiile'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mbali' iya'a, bantilkonon-Ku na ko'omuu se' Batomundo'anna Alaata'ala bo alaon na ko'omuu ka' bo rookonon na sa'angu' lipu' men daa mingilimang upa men kana' na Batomundo'an iya'a.  ");
INSERT INTO blzNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ime a men mandawo' na watu iya'a bo koraso-raso', ka' ime a men utunonna watu iya'a bo magampial.” ");
INSERT INTO blzNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na tempo tanaasna imam ka' mian Farisi nongorongor timbaani' ni Yesus, raaya'a ninginti'i se' i raaya'a a men pi'intuon ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Raaya'a nampari-pari mangarakop i Ia, kasee i raaya'a layaonkon mian biai', gause mian biai' iya'a mansarui Ia nabii. ");
INSERT INTO blzNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kasi i Yesus nobatimbaani' soosoodo na ko'ona i raaya'a tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Batomundo'anna Surugaa koi sa'angu' tomundo' men nangawawau ramean posuo'anna anakna. ");
INSERT INTO blzNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ia nomosuu' tutulungina mondolo' mian men nipoko angemo na ramean posuo'an iya'a, kasee i raaya'a bude' taka. ");
INSERT INTO blzNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kasi ia nomosuu' soosoodo tutulungi sambana taena, ‘Bantilkon koi kani'imari na mian men bo dolo'on iya'a inta': Imamat ini'imari! Kakaan nipoko toropotimo, sapi' moro'one tia anakna sapi' men molongo' nipoko koyo'mo. Giigii' nipoko toropotimo. Mai taka na ramean posuo'an iya'a.’ ");
INSERT INTO blzNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kasee mian men ni'ange iya'a sian ningimamat. Isian men mae' na ale'na, isian men mae' ningilimang palimangonna, ");
INSERT INTO blzNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ka' men sambana nangarakop tutulungina tomundo' iya'a, kasi nampapolosi ka' nampapatei. ");
INSERT INTO blzNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mbaka' nomaso'mo a tomundo' iya'a, kasi nomosuu' surudaduna mbaale'e mampapatei mian men nampapatei tutulungina iya'a ka' muntunu kotana i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Noko daa iya'a, ia norobumo na tutulungina taena, ‘Ramean posuo'an noko toropotmo, kasee mian men ni'ange olukon sianmo kokana'ku bo taka na ramean kani'i. ");
INSERT INTO blzNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mbali' iya'a, rae' na pogolimpanga'anna salan ka' ange a giigii' mian men rumpakionmuu indo'o taka na ramean posuo'an iya'a.’ ");
INSERT INTO blzNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kasi nomae' a tutulungi iya'a ka' ningirimpung giigii' mian men rumpakionna i raaya'a na bendar, mian men ba'idek a gau'na ka' mian men pore, pataka nobuke' tia sawe' a tampat ramean posuo'an iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Na tempo tomundo' iya'a ninsoop bo pootuung tia sawe'na iya'a, ia nimiile' sa'angu' mian men sian nopake pakeanna ramean. ");
INSERT INTO blzNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ia norobumo na ko'ona taena, ‘Oo bela'! Koi upa i koo ninsoop ka'ita see sian namake pakean barame?’ Kasee mian iya'a tongko' nimporokot. ");
INSERT INTO blzNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kasi tomundo' iya'a norobu na tutulungi taena, ‘Koot a saratna tia limana ka' tibarkon a mian iya'a na kapintungan men pika' tuu'. Indo'o i ia bo tumando' ka' marepa tuu'.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kasi i Yesus nangkakabusi timbaani'-Na tae-Na, “Biai' a mian men ia ange Tumpu, kasee titiu' a men niruruki.” ");
INSERT INTO blzNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Komburi'na nomae'mo a mian Farisi ka' nansangadakon se' koi upa i raaya'a sida monsosooli wurung ni Yesus na upa men pikirawaronna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Raaya'a nomosuu' muritna i raaya'a tia winawa ni Tomundo' Herodes bapikirawar na Ko'ona taena, “Guru, kai inti'i i Kuu sian muntundun upa men kosian. Mbali' iya'a i Kuu mimisiso'kon pingkira'na Alaata'ala men tuutuu'na. Imepo uga' sian kolayaonmuu, gause i Kuu sian momposasala'kon mian. ");
INSERT INTO blzNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bantilkon na ko'omai: Koi pinginti'i-Muu, daa patalaion a mambayar pajak bona Kaisar kabai sian?” ");
INSERT INTO blzNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kasee i Yesus ninginti'i idekna noana i raaya'a kasi norobu tae-Na, “Wee i kuu mian men minti palo-paloos! Nongko'upa i kuu se' mimitopongi i Yaku'? ");
INSERT INTO blzNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pipiile'kon na Ingku' a doi' bo pambayar pajak iya'a.” Raaya'a nangawawamo na Ko'ona sa'angu' doi' dinar. ");
INSERT INTO blzNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kasi i Yesus nobapikirawar na ko'ona i rayaa tae-Na, “Gambar tia ngaan ni ime ini'i?” ");
INSERT INTO blzNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ia simbati i raaya'a taena, “Gambar tia ngaanna Kaisar.” Taeni Yesus na ko'ona i raaya'a, “Rookon bona Kaisar a upa men tio rookononmuu na Kaisar ka' rookon bona Alaata'ala a upa men tio rookononmuu na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nongorongor iya'a i raaya'a nosamba'mo, kasi nomae' namarerei i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na iliopo iya'a uga' notakamo ni Yesus a toropii mian Saduki, men koi na pinginti'ina se' mian men lapusmo sianmo tumuo' soosoodo. Raaya'a nobapikirawar na Ko'ona taena, ");
INSERT INTO blzNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Guru! Ai Musa nangaan se' kalu isian sa'angu' moro'one lapus ka' sian anakon, mbaka' utusna moro'one iya'a tio mosuo' tia baluna utusna kada' utusna isian lee'na. ");
INSERT INTO blzNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kasee na ko'omai isian pitu' moro'one moto'utus. Men balaki'na nosuo', kasee komburi'na lapus. Gause i ia sian no'anakon, mbaka' ia posuo'imo utusna. ");
INSERT INTO blzNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Utusna men korua'na uga' koiya'a ka' men kotolu'na ka' pataka men kopitu'na. ");
INSERT INTO blzNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Komburi'na kabus nolapus i raaya'a giigii', wiwine iya'a uga' nolapusmo. ");
INSERT INTO blzNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na pipitu' moro'one moto'utus iya'a, ime a men bo sida langkai'na wiwine iya'a na ilio pomotuo'ian mian lapus? Gause giigii' i raaya'a nompoboroki'mo i ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus ninsimbati i raaya'a tae-Na, “Kuu nosala'mo, gause i kuu sian minginti'i isiina Alkitaap kabai se' kuasana Alaata'ala! ");
INSERT INTO blzNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na tempo pomotuo'ian mian lapus, raaya'a sian mosuo' ka' sian poposuo'on kasee tumuo' koi malaa'ikat na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kuu mbali' sianpo nambasa men ia bantilkonmo Alaata'ala na ko'omuu se' mian lapus bo potuo'ion? Tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yaku'mo a Alaata'ala ni Abraham, Alaata'ala ni Ishak ka' Alaata'ala ni Yakub?’ Ia taasi' Alaata'alana mian lapus kasee Alaata'alana mian tumuo'.” ");
INSERT INTO blzNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mian biai' men nongorongor iya'a samba'kon pisiso'-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na tempo mian Farisi nongorongor se' i Yesus ninsidakon mian Saduki iya'a somo nimporokot, raaya'a nobarimpungmo. ");
INSERT INTO blzNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ka' sa'angu' mian na ko'ona i raaya'a men wawa ukum Torat nobapikirawar mimitopongi i Yesus. Taena, ");
INSERT INTO blzNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Guru, potoo men koi upa a men tuko na ukum Torat?” ");
INSERT INTO blzNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ia simbati i Yesus tae-Na, “Kolingu'kon a Tumpu Alaata'alamuu tia noa men tuutuu', ka' tia giigii' wakamuu ka' giigii' pinginti'ianmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Koiya'a a potoo men tuko ka' men tumbena. ");
INSERT INTO blzNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Potoo korua'na koikoimo potoo men tumbena: Kolingu'kon a simbaya'muu mian koikoimo pongkolingu'konmuu wakamuu. ");
INSERT INTO blzNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Giigii' ukum Torat ka' kitap nabii nimpu'u na rua' potoo iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na tempona mian Farisi dauga' potorimpung, ai Yesus nobapikirawar na ko'ona i raaya'a tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Koi upa a pinginti'imuu i Tomundo' Pansalamatkon? Lee' ni ime i Ia?” Taena i raaya'a, “Lee' ni Daud.” ");
INSERT INTO blzNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Taeni Yesus, “Kalu koiya'a, koi upa i Daud tia pisiso'na Alus Molinas sida mangaan i Tomundo' Pansalamatkon se' Tumpuna, na tempo ia norobu taena, ");
INSERT INTO blzNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tumpu Alaata'ala nangaanmo na Tumpungku tae-Na: ‘Oruang na paraas uanan-Ku, pataka Yaku' mompoporungku' giigii' mian men mangka'idek i Koo sida malolo' na Ko'oom.’ ");
INSERT INTO blzNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mbaka', kalu Daud se' nangaan Tomundo' Pansalamatkon iya'a Tumpuna, koi upa a kosidana se' daa Tomundo' Pansalamatkon uga' bo lee'na?” ");
INSERT INTO blzNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sianta sa'angu'po mian men nomoko ninsimbati i Yesus, ka' muntumbei ilio iya'a sianta sa'angu'po mian men momoko mimikirawar upa-upa na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kasi i Yesus norobu na mian biai' ka' na murit-Na tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wawa ukum Torat ka' mian Farisi nitarai kuasa mompopo'inti'ikon ukum ni Musa. ");
INSERT INTO blzNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mbali' iya'a, lolo' ka' loloikon a giigii' men ia posuu'kon i raaya'a. Kasee alia mingilimang upa men ia limangmo i raaya'a, gause i raaya'a sian mansalankon upa men pisiso'kononna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Raaya'a momosuu' mingilimang men marawat ka' mompopasa'anikon aturan iya'a na mian, kasee i raaya'a bude' muntulung mian kada' sida mingilimang men koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Giigii' men ia limang i raaya'a tongko' kada' bo piile'onna mian. Raaya'a mantalekon mamake lui' sambayang men bambal tia mangarutu'i rendana jubana i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Raaya'a mingkira' umoruang na oruangan men pore na ramean ka' uga' na oruangan men porena na laigan bakitumpuan. ");
INSERT INTO blzNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Raaya'a beleskon angga'ionna mian na pasar ka' mingkira' leelo'on Guru. ");
INSERT INTO blzNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kasee i kuu alia mingkira' leelo'on Guru, gause Gurumuu tongko' isian sa'angu' ka' uga' i kuu giigii' moto'utus sa'angu' kaparasaya'an. ");
INSERT INTO blzNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ka' i kuu alia mengeleelo' sa'angu'po mian na tano' balaki' kani'i tama, gause Tamamuu tongko' sa'angu'. Ia Tamamuu men na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ka' alia i kuu mingkira' leelo'on tanaas, gause Tanaasmuu tongko' sa'angu' men ngaanon Tomundo' Pansalamatkon. ");
INSERT INTO blzNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mian men balaki'na na ko'omuu tio sida bo puntulung i kuu. ");
INSERT INTO blzNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mian men mompopodaa wakana bo popokoo'on, ka' mian men mompopokoo' wakana bo popodaaon. ");
INSERT INTO blzNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Silaka' i kuu wawa ukum Torat ka' mian Farisi! Kuu mian men minti pa'a-pa'agama! Kuu mongompot mian men minsoop na Batomundo'anna Surugaa, gause i kuu sian minsoop, ka' mian men mampari-pari minsoop na Batomundo'anna Surugaa talantangionmuu.  ");
INSERT INTO blzNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Silaka' i kuu wawa ukum Torat ka' mian Farisi! Kuu mian men minti pa'a-pa'agama! Kuu mangakalkon balu wiwine ka' mangarampasi laiganna ka' uga' mingirimboroi gau' ba'idekna tia sambayang biai' taa'. Mbali' iya'a, ukumanmuu a marepana tia ukumanna mian sambana. ");
INSERT INTO blzNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Silaka' i kuu wawa ukum Torat ka' mian Farisi! Kuu mian men minti pa'a-pa'agama! Kuu mae' oloa mengelembeti tobui, ka' mansasayoi longkop tano' tongko' bo pinsidakon sa'angu' mian minsoop agamamuu, kasee i kuu minsidakon i ia mian men bo minsoop naraka, men idekna pinduan paku' koi idekmuu! ");
INSERT INTO blzNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Silaka' i kuu tanaas men mampisok! Kuu mimisiso'kon se' kalu mian basumpa' mangaan Laiganna Alaata'ala, mian iya'a sian paraa mongololoikon sumpa'na. Kasee kalu ia basumpa' mangaan mosoni na Laiganna Alaata'ala, ia tio mongololoikon sumpa'na iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kuu mian bobo' ka' mampisok! Upa mbali' a men tuko, mosoni men isian na Laiganna Alaata'ala kabai se' Laiganna Alaata'ala men ninsidakon mosoni iya'a molinas? ");
INSERT INTO blzNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kuu mimisiso'kon koi kani'imari: Kalu sa'angu' mian basumpa' mangaan mesba, mian kanono' sian paraa mongololoikon sumpa'na. Kasee kalu ia basumpa' mangaan kurbaan na mesba iya'a, ia tio mongololoikon sumpa'na iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kuu se' mampisok tuu'! Upa mbali' a men tuko, kurbaan na mesba kabai se' mesba men minsidakon kurbaan iya'a molinas? ");
INSERT INTO blzNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mbali' iya'a, kalu sa'angu' mian basumpa' mangaan mesba, aratina i ia basumpa' mangaan mesba ka' uga' giigii' kurbaan men isian na mesba iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ka' kalu sa'angu' mian basumpa' mangaan Laiganna Alaata'ala, aratina i ia basumpa' mangaan Laiganna Alaata'ala iya'a ka' uga' Alaata'ala men dumodongo na lalomna. ");
INSERT INTO blzNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ka' kalu sa'angu' mian basumpa' mangaan surugaa, aratina i ia basumpa' mangaan oruanganna Alaata'ala, ka' uga' i Ia men no'umoruang na oruangan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Silaka' i kuu wawa ukum Torat ka' mian Farisi! Kuu mian men minti pa'a-pa'agama! Ule'na aso-asokmuu koimo solasi, popuuton ka' jintan, kuu rookon a koi sangobosan na lalomna sompulo' obosan bona Alaata'ala. Kasee upa men tuko na ukum Torat sian imamatonmuu, koimo wawau men maloos, polingu'an ka' palolo'an. Poali iya'amo a men tio limangonmuu, ka' alia mamatalai men sambana. ");
INSERT INTO blzNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kuu tanaas men mampisok! Laale na lalomna inumanmuu tapisonmuu, kasee unta kuu pulon! ");
INSERT INTO blzNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Silaka' i kuu wawa ukum Torat ka' mian Farisi! Kuu mian men minti pa'a-pa'agama! Kuu koi sasangkir tia lean men ni'oso'i moloe' na liwana, kasee na lalomna mariingi' tuu'. Gause upa men kuu poko'ule' iya'a, kuu dapot na podoko'anmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kuu mampisok! Oso'i kutung bi poloe' a lalomna sasangkir tia leanmuu kada' na liwana uga' sida moloe'. ");
INSERT INTO blzNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Silaka' i kuu wawa ukum Torat ka' mian Farisi! Kuu mian men minti pa'a-pa'agama! Kuu koi baleanan men niceet bubulak. Na liwana piile'on pore, kasee na lalomna buke' tia wuku ka' giigii' men bobosi'. ");
INSERT INTO blzNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Koiya'a uga' i kuu. Na pimiile'na mian koi se' pore, kasee noamuu borek sowu-sowu ka' ba'idek tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Silaka' i kuu wawa ukum Torat ka' mian Farisi! Kuu mian men minti pa'a-pa'agama! Kuu mangawawau baleanan men pore bona nabii, ka' mompore-porei patungna mian men malolo' na Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ka' i kuu norobu taemuu, ‘Kalu se' i kai tumuo' na tempo pulimai mbaripian, kai sian tololo' tii raaya'a na pampapateian nabii.’ ");
INSERT INTO blzNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gause noamuu mompopodaa wakamuu men koiya'a, mbaka' i kuu mimpipiile'kon se' gau'muu koikoimo pulimuu, ka' i kuu tuutuu' lee'na mian men nampapatei nabii. ");
INSERT INTO blzNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mbali' iya'a, imputi ka' upusi a gau'na pulimuu men ia poko tumbeimo i raaya'a! ");
INSERT INTO blzNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wee i kuu men koi ule, ka' koi lee'na ule ba'idek! Koi upa i kuu mbali' daa sida mansalamatkon wakamuu na ukuman na naraka? ");
INSERT INTO blzNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Imamat ini'imari! Yaku' bo momosuu' na ko'omuu nabii, mian pinginti'ianan, ka' wawa ukum Torat. Kasee sambana bo papateionmuu, ka' sambana bo saliipkononmuu. Isian men bo sasalionmuu na laigan bakitumpuanmuu, ka' laya'onmuu na sa'angu' kota mae' na kota sambana. ");
INSERT INTO blzNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mbaka' i kuu bo ukumon gause wawaumuu iya'a, ka' wawauna pulimuu men nampapatei giigii' mian men sian sala'an na tempopo nampapateian i Habel men sian sala'an pataka nampapateian i Zakharia, anak ni Berekhya, men kuu papatei na ola'na Laiganna Alaata'ala tia mesba. ");
INSERT INTO blzNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' mian men tumuo' na tempo koini'i bo ukumon gause giigii' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalem! Yerusalem! Nabii kuu papatei. Mian men ia posuu' Alaata'ala kuu lapak tia watu pataka lapus! Piribiai'mo i Yaku' mingkira' mongoroot giigii' mian men dumodongo na ko'omuu koi sinana siok mongopo'i anakna na intuna laina, kasee i kuu bude'! ");
INSERT INTO blzNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Imamat ini'imari! Laiganmuu kani'i bo parereion ka' sianmo mianna. ");
INSERT INTO blzNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bantilkonon-Ku na ko'omuu se' supu koini'i i kuu sianmo mimiile' i Yaku' soosoodo pataka i kuu morobu taemuu, ‘Barakaation i Ia men taka pokauonna Tumpu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na tempo i Yesus namarerei Laiganna Alaata'ala, murit-Na notakamo na Ko'ona ka' ninsiso' Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesus norobu na ko'ona i raaya'a, tae-Na, “Too daa i kuu nimiile' giigii' iya'a? Imamat iya'a. Bantilkonon-Ku na ko'omuu se' ni'imarian sianta sa'angu'po watu na Laiganna Alaata'ala kani'i a men dauga' patalaion pootapi'. Wiwi'na bo runtunion!” ");
INSERT INTO blzNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Komburi'na i Yesus nomae'mo na Buu'na Zaitun ka' na tempo i Ia oru-oruang, murit-Na notakamo bo pootundunii tii Ia men tongko' raaraaya'ana. Taena i raaya'a, “Bantilkon i kai se' ipi a bo sidaanna men tae-Muu umba'a, ka' oosan upa men bo pinginti'ian kotakaan-Muu ka' kakabusanna tempo?” ");
INSERT INTO blzNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ia simbati Yesus tae-Na, “Maka'amat dako' i kuu ko'akalian. ");
INSERT INTO blzNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gause biai' a mian bo taka ka' mangaan ngaan-Ku ka' morobu taena, ‘Yaku'mo a Tomundo' Pansalamatkon!’ Raaya'a bo mangakalkon mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kuu bo momorongor lelena mian poopapate ka' laungna sindapanna mian men poopapate, kasee alia uga' layaon. Gause upa-upa iya'a tio bo sida, kasee iya'a taasi'po kakabusanna tempo. ");
INSERT INTO blzNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lipu' men sa'angu' bo poopapate mintimbangi lipu' men sambana, ka' batomundo'an sa'angu' bo poopapate mintimbangi batomundo'an men sambana. Na toropii dodongoan takaionna loluan tia lili'. ");
INSERT INTO blzNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Giigii' iya'a baasi tumbena, koi polos men baasi ia suri sa'angu' wiwine na tempo mindompu'. ");
INSERT INTO blzNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tempo iya'a i kuu bo rakopon ka' rookonon bo repaion kasi papateion. Kuu bo kokundaionna giigii' lipu' gause na pongololo'an i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na tempo iya'a biai' a mian bude'mo sida murit-Ku. Raaya'a pookalaakkon tia simbaya'na men pooka'idek. ");
INSERT INTO blzNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bo taka a biai' minti nabi-nabii men tongko' momboreki mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Idek bo kanturangan men dodoa tuu' pataka mian biai' sianmo pookolingu'kon. ");
INSERT INTO blzNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kasee mian men mantaan pataka kokomburi'anna bo salamatkonon. ");
INSERT INTO blzNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ka' Lele Pore men mambantilkon Batomundo'anna Alaata'ala bo lelekonon na longkop tano' balaki' kada' giigii' mian momorongor. Moko daa iya'a kasi taka a kakabusanna tempo. ");
INSERT INTO blzNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Sa'angu' tempo i kuu bo mimiile' pinsilaka'i men ba'idek kumekerer na tampat men molinas, koi wurungna Tumpu men ia tadulkon i Nabii Daniel. (Sulano i kuu men mambasa iya'a sida minginti'i.) ");
INSERT INTO blzNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na tempo iya'a, mian men isian na libutan Yudea tio mamarere na buu'na. ");
INSERT INTO blzNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mian men monda'a na wawona laiganna amo' malau ka' minsoop na laigan mangala upana. ");
INSERT INTO blzNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mian men na ale' sobii ka' mule'kon mangala pakeanna. ");
INSERT INTO blzNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Marepa a wiwine men mampaiwawa tempo iya'a, ka' sina men dauga' momosusui anak. ");
INSERT INTO blzNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pa'ase' na sambayangmuu kada' alia paraa mamarere na tempo memel kabai na ilio Sabat. ");
INSERT INTO blzNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gause na tempo iya'a bo taka a sa'angu' repaan men marepa tuu' koi men sianpo ia toosuri mian nuntumbeipo nosidaanna tano' balaki' pataka koini'i. Ka' sianmo isian repaan men koiya'a soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kalu Alaata'ala sian monsondo'i tempo marepa iya'a, mbaka' sianta sa'angu'po mian men salamat. Kasee kada' mian men Ia ruruki sida salamat, mbaka' bo sondo'ion-Na tempo iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Na tempo iya'a kalu isian mian morobu na ko'omuu taena, ‘Piile', kani'imo a Tomundo' Pansalamatkon!’ kabai taena, ‘Piile', kale'emo a Tomundo' Pansalamatkon!’ alia mamarasaya upa men ia ngaan mian kanono'. ");
INSERT INTO blzNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gause pansalamatkon borek tia minti nabi-nabii bo taka. Raaya'a bo mingilimang oos men pore tuu' ka' upa kosamba' bo pangakalianna mian, maupo mian men ia rurukimo Alaata'ala bo mian-Na. Uga' pi'akalionna i raaya'a kalu too pokoonna. ");
INSERT INTO blzNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Daa Yaku' bantilkonmo a upa men bo rumpakion ini'imari. ");
INSERT INTO blzNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kalu i kuu momorongor mian morobu na ko'omuu taena, ‘Piile'! Ia isian na tano' maleas,’ alia i kuu waale'e. Kabai kalu taena, ‘Piile'! Ia ninsapit na lalomna tambin kani'i,’ alia mamarasaya. ");
INSERT INTO blzNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gause kotakaanna Anak Manusia bo sida koi kilap men tarang dumilep ringkat na bete'an taka na sopokan. ");
INSERT INTO blzNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Aana a men isian bangke, ino'o moriwut a sapu' men mangkaan bangke. ");
INSERT INTO blzNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sarataa moko daa repaan na tempo iya'a, matana ilio bo pintung, ka' wulan sianmo tarang. Bitu'on bo mandawo' ra'amari na langit, ka' pungkuasai langit iya'a bo toyunggot. ");
INSERT INTO blzNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tempo iya'a oosanna Anak Manusia bo kampiile'an na langit. Giigii' lipu' na tano' balaki' bo wiri. Raaya'a bo mimiile' Anak Manusia taka ra'amari na wawona antong tia kuasa ka' lingkaangan tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Torompeet balaki' bo duupon, ka' Anak Manusia bo momosuu' malaa'ikat-Na mingirimpung mian men Ia ruruki bo mian-Na na longkop tano' balaki' ka' na puusna langit men sa'angu' pataka puusna men sambana. ");
INSERT INTO blzNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Inau' a timbaani'na kau ara. Kalu panga'na malalas ka' molusa', ka' nosumumpemo, inti'ionmuu se' tempona pengkar booboomo. ");
INSERT INTO blzNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Koiya'a uga' kalu i kuu mimiile' men taeng-Ku' kaekae'mo sida. Inti'ionmuu se' tempona booboomo. ");
INSERT INTO blzNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' giigii' upa men Yaku' poko bantilkonmo na ko'omuu iya'a bo sida koo'po tia mian men tumuo' tempo koini'i lapus giigii'na. ");
INSERT INTO blzNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Langit ka' tano' balaki' bo penta', kasee wurung-Ku isian pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kasee sianta sa'angu'po mian men minginti'i iliona tia jaamna. Malaa'ikat na surugaa sian, Anakna Alaata'ala uga' sian. Tongko' Tama na surugaa a men daa ninginti'i. ");
INSERT INTO blzNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Gause koi upa a men nosida na tempo ni Nuh mbaripian, mbaka' koiya'a uga' a men bo sida na tempo kotakaanna Anak Manusia. ");
INSERT INTO blzNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na tempo koo'po tia tano' balaki' ia limbusi weer, mian kumaan, ba'inum, mosuo' ka' mompoposuo' anakna. Koiya'a pataka na ilio ninsoopan ni Nuh na lalomna kapal. ");
INSERT INTO blzNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na tempo tano' balaki' ia limbusi weer iya'a ka' ninsilaka'i i raaya'a giigii', ya'asi ka' ia inti'i i raaya'a a upa men kaekae' sida. Koiya'a uga' a men bo sida na tempo kotakaanna Anak Manusia. ");
INSERT INTO blzNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na tempo iya'a, rua' mian pintanga' balimang na ale'. Sa'angu' mian bo wawaon, ka' men sa'angu' bo parereion. ");
INSERT INTO blzNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rua' wiwine pintanga' minggiling gandum. Sa'angu' bo wawaon, ka' men sa'angu' bo parereion. ");
INSERT INTO blzNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mbaka' mandagaisi, gause ilio kotakaanna Tumpumuu sian inti'ionmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Imamat a timbaani' kani'imari! Kalu tombono laigan inti-inti'i se' jaam pipii a takaanna mian mamangan na tempo malom, ia sabole sian royot kada' mian mamangan sian minsoop na laiganna. ");
INSERT INTO blzNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mbali' iya'a, kuu uga' tio maka'amat. Gause Anak Manusia bo taka na tempo men sian sasaakionmuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kalu isian tutulungi men malolo' ka' motu'a a noana, iamo a men nakatonna tanaasna bo pantanaasi tutulungi sambana ka' mantarai i raaya'a kumaan na tempona. ");
INSERT INTO blzNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Barakaatan a tutulungi iya'a kalu tanaasna mule'kon ka' mantakai i ia pintanga' mingilimang palimangonna. ");
INSERT INTO blzNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' tanaas iya'a bo mamarasayakon giigii' kupangna na tutulungi iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kasee kalu tutulungi iya'a ba'idek, ia bo morobu na noana taena, ");
INSERT INTO blzNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Tanaasku dauga' manau' ka' mule'kon.’ Mbaka' ia nampapolosimo tutulungi men sambana, ka' kumaan ba'inum tia mian men bukuan lio'. ");
INSERT INTO blzNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kasee kokomburi'anna tanaasna bo mule'kon na ilio men sian sasaakionna tutulungi iya'a, ka' jaam men sian inti'ion. ");
INSERT INTO blzNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mbaka' tutulungi iya'a bo papolosionna tanaasna, ka' tibarkonon na tampatna mian men minti pore-pore! Indo'o i raaya'a bo tumando' ka' marepa tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Na tempo kotakaanna Anak Manusia soosoodo, Batomundo'anna Surugaa koi timbaani' kani'imari. Isian sompulo' wiwine laandue' nompoo'ala panso, kasi mae' mangalaboti suo' moro'one. ");
INSERT INTO blzNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lilima' bobo', ka' lilima' pande. ");
INSERT INTO blzNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lilima' men bobo' nangawawa panso kasee sian nangawawa likison bo punturangina. ");
INSERT INTO blzNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lilima' men pande nangawawa panso tia uga' likison bo punturangina. ");
INSERT INTO blzNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Suo' moro'one iya'a naalin ka' notaka, mbaka' wiwine iya'a nuntumbeimo nototundo' ka' noroyot. ");
INSERT INTO blzNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tanga'na rondom, kasi nirongor a mian mengeleelo'kon taena, ‘Takamo a suo' moro'one! Mai laboti i ia.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sompulo' wiwine iya'a nowangonmo ka' nontotobo'i pansona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wiwine men bobo' iya'a norobu na wiwine men pande taena, ‘Taraion likisonmuu titiu' i kai, gause pansomai boomo pate.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ia simbati wiwine men pande iya'a taena, ‘Sian sida! Dako' i kita giigii' kokabusionna likison. Rae' pingili na toko'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mbaka' wiwine men bobo' iya'a nomae'mo mingili likison. Sarataa noporus nomae' i raaya'a, suo' moro'one iya'a notakamo. Lilima' wiwine men nobatoropotmo iya'a ninsoopmo singka-singkat tia suo' moro'one na tampat ramean, ka' soopan ni'omporimo. ");
INSERT INTO blzNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Komburi'na wiwine men sambana iya'a notakamo. Raaya'a nengeleelo'mo taena, ‘Tuan! Tuan! Kai miki leakikon soopan kada' i kai minsoop.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kasee suo' moro'one iya'a ninsimbati taena, ‘Bantilkononku na ko'omuu se' yaku' sian poo'inti'i tii kuu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kasi i Yesus nongkokomburi'i timbaani'-Na iya'a tae-Na, “Mbali' iya'a, maka'amat gause iliona kabai se' jaamna sian inti'ionmuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Na tempo kotakaanna Anak Manusia soosoodo, Batomundo'anna Surugaa koi timbaani' kani'imari. Isian sa'angu' tanaas mae' na dodongoan men oloa. Ia nengeleelo'mo tutulungina ka' namarasayakon kupangna na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Na sanda' tutulungi iya'a ia tarai koi men pokoonna sanda-sanda'. Na sa'angu' tutulungi ia tarai lima' loloon doi' mosoni. Ka' na sa'angu' tutulungi soosoodo ia tarai rua' loloon doi' mosoni. Ka' na sa'angu' tutulungi men sambana ia tarai sololoon doi' mosoni. Kasi ia nomae'. ");
INSERT INTO blzNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tutulungi men nangalabot lima' loloon doi' mosoni iya'a lako-lako nomae' badagang, kasi nantausi soosoodo ule' lima' loloon doi' mosoni. ");
INSERT INTO blzNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Koiya'a uga' a tutulungi men nangalabot rua' loloon doi' mosoni iya'a nantausi soosoodo ule' rua' loloon doi' mosoni. ");
INSERT INTO blzNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kasee tutulungi men nangalabot sololoon doi' mosoni iya'a nomae'mo nengkeke tano' kasi nanganaa' indo'o doi'na tanaasna. ");
INSERT INTO blzNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nanau' a noporusanna iya'a, tanaasna tutulungi iya'a nomule'kon ka' nopoosaa'i tii raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tutulungi men nangalabot lima' loloon doi' mosoni iya'a taka ka' nongorookon sompulo' loloon. Taena, ‘Tanaas, kuu nongorookon lima' loloon doi' mosoni na ingku'. Piile'! Yaku' nomoko nantausi ule' lima' loloon soosoodo.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Taena tanaas iya'a, ‘Pore tuu' a men koo wawau. Koo tutulungi men pore ka' malolo'. Gause i koo daa sida ooskonon mau tongko' na upa titiu', mbaka' biai' a men pokaukononku na ko'oom. Mai, pinsoop ka' munsuri beles tii yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kasi tutulungi men nangalabot rua' loloon doi' mosoni iya'a notaka ka' norobu taena, ‘Tanaas, kuu nongorookon rua' loloon doi' mosoni na ingku'. Piile'! Yaku' nomoko nantausi ule' rua' loloon soosoodo.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Taena tanaas iya'a, ‘Pore tuu' a men koo wawau. Koo daa tutulungi men pore ka' malolo'. Gause i koo daa sida ooskonon mau tongko' na upa titiu', mbaka' biai' a men pokaukononku na ko'oom. Mai, pinsoop ka' munsuri beles tii yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kokomburi'anna tutulungi men nangalabot sololoon doi' mosoni iya'a notakamo ka' norobu taena, ‘Tanaas, yaku' inti'i i kuu sa'angu' mian men maso'on. Kuu mamadak na ale' men sian kuu kamburi, ka' mangala ule' na ale' men sian kuu asoki. ");
INSERT INTO blzNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gause i yaku' layaonkon i kuu, doi'muu yaku' naa'mo na tano'. Mbaka' kani'imo a doi'muu.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Taena tanaas, ‘Koomo a tutulungi men ba'idek ka' molulu'! Kalu i koo inti'imo se' yaku' mamadak na ale' men sian yaku' kamburi, ka' mangala ule' na ale' men sian yaku' asoki, ");
INSERT INTO blzNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nongko'upa mbali' i koo sian manganaa' doi'ku iya'a na baang kada' na tempo i yaku' mule'kon, yaku' daa mangalabot soosoodo doi'ku iya'a tia bungana?’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Mbali' iya'a, alamo a doi' men isian na ko'ona kaya'a ka' rookon na mian men nitarai sompulo' loloon doi' mosoni iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gause sanda' mian men isianmo upa ia tombonoi bo taraion soosoodo, ka' i ia bo kalabian. Kasee mian men sian montombonoi upa-upa, toro tiu'po upa men daa isian na ko'ona bo alaon. ");
INSERT INTO blzNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ka' tutulungi men sian kana'na iya'a alaka' tibarkon na kapintungan men pika' tuu'. Indo'o ia bo tumando' ka' marepa tuu'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kalu Anak Manusia taka bookoi Tomundo' lolo'onna giigii' malaa'ikat-Na, Ia bo umoruang na oruangan kobalaki'an-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Giigii' lipu' na dunia bo rimpungon na arop-Na. Kasi i Ia bo mengerensakon giigii' mian sida rua' tompuk koi pontondong ayop mengerensakon domba ka' bembe'. ");
INSERT INTO blzNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mian men mingilimang pingkira'na Alaata'ala rimpungon na paraas uanan-Na, ka' men sian mingilimang pingkira'na Alaata'ala rimpungon na paraas kauri'-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kasi Tomundo' iya'a morobu na mian men paraas uanan-Na taena, ‘Mai i kuu men barakaationna Tamang-Ku. Pinsoop na batomundo'an men nitoropotimo bo ko'omuu na tempopo ninsidakonan dunia. ");
INSERT INTO blzNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gause na tempo i Yaku' mololu, kuu nantarai i Yaku' kakaan, ka' na tempo i Yaku' moro'u, kuu nantarai i Yaku' weer. Tempo i Yaku' koi mian tumaka, kuu nangalabot i Yaku' na laiganmuu. ");
INSERT INTO blzNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tempo i Yaku' sian pakeanan, kuu nantarai i Yaku' pakean. Tempo i Yaku' nanggeo, kuu nandagai i Yaku'. Tempo i Yaku' nitarungku, kuu nengelego'i Yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kasi mian men pore a wawauna iya'a norobu taena, ‘Tumpu, maripi mbali' a nimiile'anmai i Kuu mololu, kasi i kai nantarai i Kuu kakaan, kabai moro'u, kasi i kai nantarai i Kuu weer? ");
INSERT INTO blzNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Maripi mbali' a nimiile'anmai i Kuu koi mian tumaka, kasi i kai nangalaboti i Kuu na laiganmai? Maripi mbali' i Kuu sian pakeanan, kasi i kai nantarai i Kuu pakean? ");
INSERT INTO blzNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Maripi mbali' a nimiile'anmai i Kuu nanggeo kabai na tarungkuan, kasi i kai nengelego'i Kuu?’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tomundo' iya'a bo minsimbati taena, ‘Tuutuu' mba'a. Kasee bantilkonon-Ku na ko'omuu se' na tempo i kuu ningilimang iya'a, maupo na sa'angu' utus-Ku men talalaisna, mbaka' i kuu ningilimangmo bo Ingku'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kasi Tomundo' iya'a morobu na mian men paraas kauri'-Na taena, ‘Rae', uar i kuu, mian men silaka'mo! Pinsoop na apu men sian morok men nipoko toropotimo bona Ibiliis ka' malaa'ikatna! ");
INSERT INTO blzNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gause na tempo i Yaku' mololu, kuu sian nantarai Yaku' kakaan. Tempo i Yaku' moro'u, kuu sian nantarai Yaku' weer. ");
INSERT INTO blzNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tempo i Yaku' koi mian tumaka, kuu sian nangalabot i Yaku' na laiganmuu. Tempo i Yaku' sian pakeanan, kuu sian nantarai i Yaku' pakean. Tempo i Yaku' nanggeo ka' nitarungku, kuu sian nangkalesang i Yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kasi i raaya'a morobu na Ko'ona taena, ‘Tumpu, maripi mbali' i kai nimiile' i Kuu mololu, kabai moro'u, kabai koi mian tumaka, kabai sian pakeanan, kabai nanggeo, kabai nitarungku, ka' i kai sian ningimamat i Kuu?’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tomundo' iya'a bo minsimbati tae-Na, ‘Imamat ini'imari! Bantilkonon-Ku na ko'omuu se' na tempo i kuu bude' mingimamat mian men talalaisna kani'i, mbaka' i kuu bude' mingimamat i Yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mbaka' mian iya'a bo ukumon tia ukuman men sidutu, kasee mian men nangawawau pingkira'na Alaata'ala bo mentempoi tuo' men pore pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sarataa i Yesus nangkakabusi tundunan-Na iya'a, Ia norobumo na murit-Na tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kuu daa mingiti'i se' rua' ilio koini'i, takamo pangaramekonan Paska. Tempo iya'a, Anak Manusia bo rookonon ka' saliipkonon.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tempo iya'a nobarimpungmo a tanaasna imam tia motu-motu'ana lipu' Yahudi na laiganna Imam Moola' men ngaanna i Kayafas. ");
INSERT INTO blzNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Raaya'a nopoosangadaimo mangarakop i Yesus wuni-wuni ka' mampapatei. ");
INSERT INTO blzNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kasee i raaya'a nangaan taena, “Amo'po wawauon na tempo ramean, dako' mantakakon kogora'an na mian biai'.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sarataa i Yesus na Betania, na laigan ni Simon men kustaon mbaripian, ");
INSERT INTO blzNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","notakamo ni Yesus a sa'angu' wiwine nangawawa sa'angu' botor pualam isiian minamina' men alayo' a ilina. Minamina' iya'a ia timbu'konmo na takala' ni Yesus men oru-oruang pintanga' kumaan. ");
INSERT INTO blzNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nimiile' men koiya'a murit-Na nomaso'mo ka' norobu taena, “Bo upa ka' mambaraba'i koi kani'i? ");
INSERT INTO blzNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gause minamina' kanono' sida balukkonon alayo' a ilina ka' doi'na sida rookonon bona mian men talalais.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kasee i Yesus inti-inti'i pikiranna i raaya'a kasi norobu tae-Na, “Nongko'upa i kuu se' mampapolosi noana wiwine kani'i? Ia nangawawaumo upa men pore na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ka' mian talalais sinampang isian na ko'omuu, kasee i Yaku' sian sinampang isian na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Gause ia nintimbu'kon minamina' iya'a na wakang-Ku, mbaka' ia nontoropotimo bo pantanoman i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' longkop tano' balaki', mau maana a pengelelekonan Lele Pore, ino'o uga' upa men ia wawaumo wiwine kani'i bo bantilkonon bookoi pinginau'an i ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mbaka' sa'angu' mian men tonsoop na sompulo' rua' murit iya'a, men ngaanna i Yudas Iskariot, nomae'mo nari tanaasna imam. ");
INSERT INTO blzNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ia norobu taena, “Upa a men bo rookononmuu na ingku' kalu yaku' mongorookon i Yesus na ko'omuu?” Raaya'a nambayar tolumpulo' doi' salaka' na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Supu iya'a i Yudas nansarakmo salan men daa pore bo pongorookonanna i Yesus na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na ilio tumbena pangaramekonan Roti Sianta Ragina notakamo ni Yesus a murit-Na ka' norobu taena, “Maana po'uus-Muu bo pontoropotianmai kakaan bo pangaramekonan Paska?” ");
INSERT INTO blzNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ia simbati i Yesus tae-Na, “Rae' na kota na sa'angu' mian ka' bantilkon na ko'ona inta': Potuunna Guru, tempong-Ku boomo taka. Yaku' mo'uus mangaramekon Paska ruru-ruru' tia murit-Ku na laiganmuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kasi murit-Na nangawawau koi men ia posuu'kon i Yesus ka' nontoropoti kumaanan Paska. ");
INSERT INTO blzNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sarataa malommo, Yesus no'umoruangmo kumaan ruru-ruru' tia sompulo' rua' murit-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pintanga' i raaya'a kumaan, Ia norobumo tae-Na, “Imamat ini'imari! Bantilkonon-Ku na ko'omuu se' isian i kuu men bo mongorookon i Yaku' kada' papateion.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kasi tia noa men masiongo' tuu' i raaya'a norobumo sa'angu'-sa'angu' taena, “Tumpu, taasi'po i yaku', indo'?” ");
INSERT INTO blzNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ia simbati i Yesus tae-Na, “Mian men mongorom rotina na lalomna mangko' patombongan kani'i tii Yaku', iamo a men bo mongorookon i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anak Manusia tuutuu' bo lapus koi men nipoko tulismo na Alkitaap, kasee silaka' a mian men mongorookon Anak Manusia iya'a. Mian iya'a bagia sian nidodongokon.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, men bo mongorookon i Yesus ninsimbati taena, “Guru, taasi'po i yaku', indo'?” Taeni Yesus na ko'ona, “Daa, koomo mba'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pintanga' kumaan i raaya'a, Yesus nangalamo roti, nobasukuur ka' nungurumpi-rumpik, kasi nongorookon na murit-Na ka' norobu tae-Na, “Alamo ka' kaan, ni'imo a wakang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Noko daa koiya'a, Ia ala a pinginuman tia anggur ka' nobasukuur na Alaata'ala kasi nongorookon i raaya'a ka' norobu tae-Na, “Pinginum i kuu giigii' na sasangkir kani'i. ");
INSERT INTO blzNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gause ni'imo a rara'-Ku men mamakadodor toonna Alaata'ala. Rara'-Ku tonturo' bona mian biai' bo pangampuni dosana i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kasee bantilkonon-Ku na ko'omuu se' supu koini'i Yaku' sianmo minginum anggur soosoodo kani'i pataka na iliona men bo pinginuman-Kumo anggur men u'uru iya'a ruru-ruru' tii kuu na Batomundo'anna Tamang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Noko daa nangananikon nanian puntunde', ai Yesus tia murit-Na nomae'mo na Buu'na Zaitun. ");
INSERT INTO blzNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mbaka' i Yesus norobumo na ko'ona i raaya'a tae-Na, “Na malom kani'i uga' i kuu giigii' sianta mantaan a noamuu mamarasaya i Yaku'. Gause nipoko tulismo na Alkitaap koi kani'imari: Yaku' bo mampapatei pontondongna domba ka' lulusanna domba bo bagera-gerap. ");
INSERT INTO blzNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kasee moko daa i Yaku' potuo'ion, Yaku' bo mongolukoni i kuu na Galilea.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ia simbati i Petrus taena, “Mau mune' i raaya'a giigii' sianta mantaan a noana mamarasaya i Kuu, kasee i yaku' sabole sian.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Taeni Yesus na ko'ona, “Tuutuu' mba'a. Kasee bantilkonon-Ku na ko'oom se' rondommo kani'i koo'po tia siok muntuturuu', koo noko porotolumo ninsasapu na Ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ia simbati i Petrus taena, “Yaku' mau pate tii Kuu, sian minsasapu na Ko'omuu.” Giigii' murit men sambana uga' nangaan men koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mbaka' notakamo i Yesus tia murit-Na na tampat men ngaanon Getsemani. Kasi i Yesus norobu na murit-Na tae-Na, “Oruang karaa'ita. Yaku' dauga' kumbaale'e mae' sambayang.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ka' Ia nangawawa i Petrus tia anak ni Zebedeus rurua' mae' tii Ia. Muntumbeimo i Ia masiongo' ka' siasa. ");
INSERT INTO blzNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kasi i Ia norobu na ko'ona tae-Na, “Noang-Ku masiongo' tuu', koi se' kolapus-Kumo surion. Kuu ka'itamo tii Yaku' ka' maka'amat.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kasi i Ia nobalimba' ndee-ndee'e ka' nobanintuur tumutuku' rumbuk tano' ka' nosambayang, tae-Na, “Oo Tamang-Ku! Too daa sida oloakon na Ingku' a repaan men tio bo surion-Ku kani'i. Kasee alia koi men pingkira'-Ku, kasee uga' koi men pingkira'-Muu.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Noko daa iya'a, Ia nombaale'emo na murit-Na. Ia takai i raaya'a nokoroyotmo. Kasi i Ia norobu ni Petrus tae-Na, “Sian mbali' i kuu momoko moburar badaga sa'angu' jaam tii Yaku'? ");
INSERT INTO blzNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Maka'amat ka' basambayang dako' i kuu topongionna idek. Noamuu mo'uus mangawawau men kana', kasee i kuu sian mokotaan.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kasi i Ia nomae' men kopinduanna ka' nosambayang tae-Na, “Oo Tamang-Ku! Kalu repaan kani'i tio bo surion-Ku ka' sian sida oloakonon, patalaimo koi men po'uus-Muu!” ");
INSERT INTO blzNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ka' sarataa i Ia nde'emari soosoodo, Ia takai i raaya'a pintanga' royot, gause i raaya'a nototundo'mo. ");
INSERT INTO blzNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ia namarereimo i raaya'a indo'o ka' nomae' sambayang men koporotoluna. Sambayang-Na men ya'a-ya'amo. ");
INSERT INTO blzNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Noko daa iya'a, Ia notakamo na murit-Na ka' norobu tae-Na, “Kuu dauga' royot tia mintimale? Piile'! Takamo a tempona Anak Manusia rookonon na limana mian men dosaon. ");
INSERT INTO blzNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wangonmo. Mai, kita mae'mo. Piile'! Mian men mongorookon i Yaku' karani'mo!” ");
INSERT INTO blzNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pintanga' i Yesus dauga' morobu, notakamo i Yudas, sa'angu' mian men tonsoop sompulo' rua' murit ni Yesus. Ka' men nongololo' i ia mian biai' potowawa bakoko' tia popool, ia posuu' tanaasna imam tia motu-motu'ana lipu' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mian men mongorookon i Yesus noko pambantilkonmo oosan kani'imari na ko'ona i raaya'a: “Mian men ookionku, ya'amo i Ia. Rakop i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mbaka' i Yudas liuliu nuntuu'i i Yesus ka' norobu taena, “Tabea', Guru!” Kasi ia nongooki i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kasee i Yesus norobu tae-Na, “Oo bela', supu-supuanna koiya'a i koo taka?” Mbaka' i raaya'a nuntuu'imo i Yesus ka' nangarakop. ");
INSERT INTO blzNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kasee sa'angu' mian men nongololo' i Yesus numbubut bakoko'na ka' nontotok ata'na Imam Moola' tamban nokopantas a tilinganna. ");
INSERT INTO blzNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mbaka' taeni Yesus, “Soopkon soosoodo a bakoko'om na guma'na, gause giigii' mian men mamake bakoko' bo pate tia bakoko'. ");
INSERT INTO blzNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kabai punsuriim se' i Yaku' sian momoko mama'ase' na Tamang-Ku kada' i Ia liuliu momosuu' labi tia sompulo' rua' pasukan malaa'ikat bo puntulung i Yaku'? ");
INSERT INTO blzNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kasee kalu i Yaku' mikitulung na Tamang-Ku, mbaka' koi upa a bo kosidana men nitulismo na Alkitaap men mangaan se' tio sida koi kani'i?” ");
INSERT INTO blzNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tempo iya'a i Yesus norobu na mian biai' tae-Na, “Pansaruimuu se' i Yaku' too mian puraga mbali' i kuu taka poto'inton bakoko' tia popool bo pangarakop i Yaku'? Sanda' ilio i Yaku' no'umoruang mimisiso' mian na tolodona Laiganna Alaata'ala, see i kuu sian nangarakop i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kasee giigii' kani'i tio sida kada' sidamo a men nitulis na kitapna nabii.” Kasi giigii' murit-Na kabus namarere ka' namarerei i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Noko daa i raaya'a nangarakop i Yesus, ia wawamo i raaya'a ni Kayafas men Imam Moola'. Indo'o isian wawa ukum Torat tia motu-motu'a men nobarimpungmo. ");
INSERT INTO blzNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ka' i Petrus nuntuntuni i Ia kasee olo-oloa mae' na tolodona Imam Moola' ka' sarataa ninsoop na tolodo, ia no'umoruang tari dadagai mempeperai kowawasanna parakala iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tanaasna imam tia giigii' mianna Mahkama Agama mansarak mian bo pomborekkon i Yesus kada' Ia tio ukumon pate. ");
INSERT INTO blzNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kasee i raaya'a sian nantausi sala'-Na, mau mune' biai' a mian men nitakakon bo pomborekkon i Ia. Komburi'na notakamo a mian rurua', ");
INSERT INTO blzNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","men nangaan taena, “Mian kani'i nangaan tae-Na: Yaku' sida munguruntuni Laiganna Alaata'ala ka' mangawangonkon soosoodo na lalomna tolu' ilio.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kasi Imam Moola' iya'a nokumekerer ka' norobu ni Yesus taena, “Sian simbatioon a upa men ia raitkon mian karaaya'a na Ko'oom?” ");
INSERT INTO blzNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kasee i Yesus tongko' roko-rokot. Kasi taena Imam Moola' na Ko'ona, “Mimpu'u na Alaata'ala men tumuo', bantilkon na ko'omai, too i Koo a Tomundo' Pansalamatkon, Anakna Alaata'ala, kabai taasi'.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ia simbati i Yesus tae-Na, “Daa. Kuu poko ngaanmo. Kasee bantilkonon-Ku na ko'omuu se' supu koini'i kuu bo mimiile' Anak Manusia umoruang paraas uananna Alaata'ala men Pungkuasai, ka' taka ra'amari na wawona antong na langit.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mbaka' Imam Moola' iya'a nemberakmo pakeanna ka' norobu taena, “Ia mingidek Alaata'ala. Bo upa ka' dauga' mansarak mian bo pinginti'ianta. Koini'i daa kuu rongormo i Ia ningidek Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Koi upa a pinginti'imuu?” Raaya'a ninsimbati taena, “Ia tio ukumon pate.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kasi i raaya'a ninginori ro'up-Na ka' isian uga' men numukul ka' nampapagi i Ia, ");
INSERT INTO blzNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ka' norobu taena, “Io, Tomundo' Pansalamatkon! Bantilkon na ko'omai se' ime a men numukul i Koo.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petrus oru'oruang na liwana laigan na tolodo. Mbaka' notakamo a sa'angu' ata' wiwine na ko'ona ka' norobu taena, “Kuu uga' sinampang poololo' tii Yesus, samba Galilea iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kasee ia ninsasapu na giigii' mian taena, “Sian inti'ionku upa a panduuwung.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sarataa ia nomae' na soopanna tolodo, sa'angu' ata' wiwine sambanaan nimiile' i ia ka' norobu na mian men iraando'o taena, “Mian kani'i poopoololo' tii Yesus, samba Nazaret iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ka' ia ninsasapu soosoodo ka' nobasumpa' taena, “Yaku' mase sian inti'ionku inooro'o mian.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sian paraa nanau' mian men isian iraando'o notakamo ni Petrus ka' norobu taena, “Sabole i koo uga' tonsoop tii raaya'a. Men koiya'a nirongor na wuruung.” ");
INSERT INTO blzNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mbaka' i Petrus nuntumbeimo nobatadean ka' nobasumpa' taena, “Yaku' mase sian inti'ionku inooro'o mian.” Ka' na tempo iya'a nuntuturuu'mo a siok. ");
INSERT INTO blzNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mbaka' notonginau'mo i Petrus upa men ia bantilkonmo i Yesus na ko'ona tae-Na, “Koo'po tia siok muntuturuu' i koo noko porotolumo minsasapu na Ingku'.” Mbaka' no'umuarmo i Petrus ka' nowiri tamban bolingongoton. ");
INSERT INTO blzNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sarataa boomo ilio, giigii' tanaasna imam tia motu-motu'ana lipu' Yahudi nobarimpungmo ka' nopoosangadai mampapatei i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Raaya'a numungumo i Ia kasi nangawawa mae' ni Pilatus men gubernuur na libutan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sarataa i Yudas men nongorookon i Yesus nimiile' se' i Yesus nikana'imo ukuman pate, ia ninsosolmo. Kasi ia nungule'kon doi' salaka' men tolumpulo' iya'a na tanaasna imam tia motu-motu'a, ");
INSERT INTO blzNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ka' norobu taena, “Yaku' nodosaonmo gause nongorookon rara'na mian men sian sala'na.” Kasee ia simbati i raaya'a taena, “Upa a urusanmai tia kanono'? Kanono' urusaan suuwung!” ");
INSERT INTO blzNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mbaka' ia nambalo'konmo doi' salaka' iya'a na lalomna Laiganna Alaata'ala, kasi nomae' nintipegot. ");
INSERT INTO blzNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tanaasna imam nangalamo doi' salaka' iya'a ka' norobu taena, “Sian poturangon monsoopkon doi' kani'i na pundi, gause doi' kani'i doi'na rara'.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Noko daa i raaya'a nopoosangadai, raaya'a namba'ilikonmo doi' iya'a ningili tano' men ngaanon Tano'na Tukang Kuren. Tano' iya'a nisidakon tampat bo baleananna mian men tumaka. ");
INSERT INTO blzNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mbali' iya'a, pataka koini'i tano' iya'a ngaanion Tano' Rara'. ");
INSERT INTO blzNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tempo i raaya'a mangawawau men koiya'a mbaka' nosidamo a wurungna Tumpu koi men ia tadulkon i Nabii Yeremia taena, “Raaya'a nangalabot tolumpulo' doi' salaka', ya'amo a ilina men ia poosangadaikonmo lipu' Israel bo pambayar i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ka' doi' iya'a ia pakemo i raaya'a bo pingili Tano'na Tukang Kuren koi men ia potookonmo Tumpu na ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kasi i Yesus niwawa na gubernuurna libutan iya'a. Ka' gubernuur iya'a nimikirawari i ia taena, “Koomo a tomundo'na lipu' Yahudi?” Ia simbati i Yesus tae-Na, “Koi nooro'o men taemuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kasee tempo tanaasna imam tia motu-motu'a mambantilkon giigii' men raitkononna i raaya'a ni Yesus, Ia sian santaa' ninsimbati. ");
INSERT INTO blzNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mbaka' i Pilatus norobumo ni Yesus taena, “Sian rongoroon se' biai' a men raitkononna mian karaani'i na Ko'oom?” ");
INSERT INTO blzNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kasee i Ia sian ninsimbati santaa'po, tamban gubernuur iya'a nosamba' tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sanda' ramean Paska, delena gubernuur iya'a sabole munguarkon sa'angu' mian na tarungkuan koi men ko'uusionna mian. ");
INSERT INTO blzNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ka' na tempo iya'a isian sa'angu' mian men nitarungku. Ngaanna i Barabas. Ia tongaan ba'idek tuu' a gau'na. ");
INSERT INTO blzNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tempo mian biai' nobarimpung na tampat iya'a, ai Pilatus norobumo na ko'ona i raaya'a taena, “Ime a men ko'uusmuu bo uarkononku bo ko'omuu, Barabas kabai se' i Yesus men ngaanon i Kristus?” ");
INSERT INTO blzNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus inti-inti'i se' i raaya'a nangkalaakkon i Yesus gause i raaya'a kokoo'ankon i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sarataa i Pilatus no'umoruang na oruangan pungukumian, boroki'na nomotuun i ia taena, “Alia i koo mangawawau upapo na mian men sian sala'na kanono', gause i Ia i yaku' nunsuri marepa tuu' na lalomna ipionku rimputu'.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kasee tanaasna imam ka' motu-motu'a nomosuu' mian biai' mama'ase' ni Pilatus kada' i Barabas a uarkonon ka' i Yesus a ukumon pate. ");
INSERT INTO blzNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gubernuur iya'a norobu na ko'ona i raaya'a taena, “Na rurua' mian kani'i, ime a men ko'uusmuu uarkonon bo ko'omuu?” Ia simbati i raaya'a taena, “Barabas.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Taena i Pilatus na ko'ona i raaya'a, “Ansee ka' koiya'a upaionkumo ni Yesus men ngaanon i Kristus?” Raaya'a giigii' nangkakaro' taena, “Ia tio saliipkonon!” ");
INSERT INTO blzNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Taena i Pilatus, “Kasee idek upa a men Ia poko wawaumo?” Kasee i raaya'a tongko' kaekae' dodoa mangkakaro' taena, “Ia tio saliipkonon!” ");
INSERT INTO blzNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sarataa i Pilatus nunsuri se' ia sian moko ba'upa, ka' mian biai' kaekae' dodoa gora', ia nangalamo weer ka' ningoso' na aropna mian biai' ka' norobu taena, “Yaku' sian sala' na rara'na mian kani'i. Ya'a urusanmuu!” ");
INSERT INTO blzNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ka' giigii' mian ninsimbati taena, “Daa. Rara'-Na kaisi tia anakmai a bo pantaup!” ");
INSERT INTO blzNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kasi ia nunguarkon i Barabas bo ko'ona i raaya'a, ka' nomosuu' mian mansasali i Yesus, kasi nongorookon bo saliipkonon. ");
INSERT INTO blzNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Surudaduna gubernuur nangawawamo i Yesus na laiganna gubernuur, kasi nengeleelo' giigii' surudadu barimpung mintikumi i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Raaya'a nungukatimo pakean-Na ka' nimpisoki i Ia tia juba kakamumu'. ");
INSERT INTO blzNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Raaya'a nanganam sa'angu' likok ruri' niwawau koi mahkota ka' nunsulon na takala'-Na, kasi nomo'intoni tokon na lima-Na uanan. Kasi i raaya'a nobanintuur ka' ningiroki i Ia, taena, “Tabea', oo tomundo'na lipu' Yahudi!” ");
INSERT INTO blzNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Raaya'a ninginori i Ia ka' nangala tokon iya'a kasi nomoolkon na takala'-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Noko daa i Yesus nibibiani, ia ukatimo i raaya'a a juba-Na, kasi nipopisokikon a pakean-Na soosoodo. Kasi i raaya'a nangawawa i Ia umuar bo saliipkonon. ");
INSERT INTO blzNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sarataa i raaya'a mae' umuar na kota, raaya'a nopootuungmo sa'angu' mian samba Kirene men ngaanna i Simon. Mian iya'a ia pakisaamo i raaya'a mamasa'an saliip ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mbaka' notakamo i raaya'a na sa'angu' tampat men ngaanon Golgota, aratina: Tampat Lamasna Takala'. ");
INSERT INTO blzNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kasi i raaya'a nantarai i Ia minginum anggur men nibauri sopoyu'. Sarataa Ia nangananami, Ia nobude' ninginum. ");
INSERT INTO blzNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Noko daa nansaliipkon i Ia, raaya'a nungundimo pakean-Na ka' nongobo-obos. ");
INSERT INTO blzNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kasi i raaya'a no'umoruang indo'o mandagai i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ka' na wawona takala'-Na nipakampa'i tulisan men mangaan nongko'upa se' i Ia ni'ukum. Tulisan iya'a koi kani'imari: Ni'imo i Yesus Tomundo'na Lipu' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Singkat tii Ia uga' isian rurua' mian puraga nisaliipkon, sa'angu' paraas uanan-Na ka' sa'angu' paraas kauri'-Na. ");
INSERT INTO blzNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mian men lumiu inda'a ningililokkon takala'na ka' mingiroki i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Raaya'a norobu taena, “Wee i Koo men bo munguruntuni Laiganna Alaata'ala ka' tongko' tolu' ilio pokoowonmo patindongon soosoodo. Salamatkon a wakaam. Kalu i Koo Anakna Alaata'ala, palau na saliiwip kanono'!” ");
INSERT INTO blzNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Koiya'a uga' tanaasna imam tia wawa ukum Torat ka' motu-motu'a ningiroki i Ia ka' nangaan taena, ");
INSERT INTO blzNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mian sambana pokoon-Na salamatkonon, kasee waka-Na sian pokoon-Na salamatkonon! Kalu i Ia tomundo'na lipu' Israel, porena i Ia malau na saliip iya'a kada' i kai parasaya na Ko'ona! ");
INSERT INTO blzNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ia mamarasayakon waka-Na na Alaata'ala. Sobii Alaata'alasi a pansalamatkon i Ia koini'i kalu Alaata'ala mo'lingu'kon i Ia. Gause i Ia isian nangaan se' i Ia Anakna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Koiya'a uga' mian puraga men nisaliipkon tii Ia uga' mangaani. ");
INSERT INTO blzNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Muntumbei jaam duablaas, nopintungmo a longkop libutan iya'a pataka jaam tiga. ");
INSERT INTO blzNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Toro jaam tiga i Yesus nangkakaro'mo men boolak tae-Na, “Eli! Eli! Lema sabakhtani?” Aratina: Alaata'alang-Ku! Alaata'alang-Ku! Nongko'upa se' i Kuu mandalai i Yaku'? ");
INSERT INTO blzNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nomorongor iya'a toropii mian men potokerer iraando'o norobu taena, “Ia mengeleelo' i Elia.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sa'angu' mian men isian tii raaya'a nomae'mo pasa-pasasara' nangala garanggan mongura' ka' nongorom na anggur makarang, kasi ia potoor na kau ka' nisoorkon waara'a, mimi'inumi i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kasee mian sambana norobu taena, “Alia. Mai kita piile'a, too i Elia taka mansalamatkon i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus nangkakaro'mo boolak soosoodo kasi nolapus. ");
INSERT INTO blzNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Singkat iya'a, toik men pongola'i olisna Laiganna Alaata'ala nokoberak rua' inda'ana tudun indo'ona. Isian lili' ka' buu'na watu kinobotakmo. ");
INSERT INTO blzNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Baleanan kinobongkatian ka' biai' a mian men malolo' na Tumpu men nolapusmo notuo'mo soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ka' noko daa i Yesus tumuo' soosoodo, raaya'a uga' umuar na baleanan, kasi minsoop na Yerusalem, kota molinas, ka' mintipiile' na mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tanaasna surudadu tia surudaduna men mandagai i Yesus nolayaonmo tuu'. Sarataa i raaya'a nunsuri lili' ka' upa men nosida, raaya'a norobumo taena, “Mian kani'i tuutuu' Anakna Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Isian uga' indo'o biai' a wiwine men montoa'i na ko'oloaan. Wiwine iraaya'a a men nongololo' i Yesus ka' nangakalesang ringkatpo na Galilea. ");
INSERT INTO blzNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Isian i Maria Magdalena, ka' i Maria sina ni Yakobus tii Yusuf, ka' sinana anak ni Zebedeus, ka' isian uga' men sambana. ");
INSERT INTO blzNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Guntumalom notakamo a sa'angu' mian men kupangon, samba Arimatea. Ngaanna i Yusuf men uga' nosidamo murit ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ia nomae'mo ni Pilatus ka' nama'ase' biibii ni Yesus. Mbaka' i Pilatus nomosuu'mo mianna kada' biibii ni Yesus iya'a rookonon na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kasi i Yusuf nangala biibii iya'a ka' nambalun tia toik pobalun biibii men bubulak maloe'. Pobalun iya'a, toik lenang a niwawau. ");
INSERT INTO blzNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ia nomotokolmo biibii iya'a na baleanan u'uru men nipa'atkon na buu'na watu. Noko daa iya'a, ia ningilinda'mo watu balaki' ka' nongompodi soopanna baleanan iya'a, kasi ia nomae'. ");
INSERT INTO blzNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kasee Maria Magdalena tii Maria men sambanaan moraando'o poto'oruang na baleanan. ");
INSERT INTO blzNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Koi liilana, noko daa ilio batoropotan, tanaasna imam tia mian Farisi notakamo ni Pilatus, ");
INSERT INTO blzNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ka' nambantil taena, “Tuan, inau'onmai se' tempo i tukang borek dauga' tumuo', Ia isian norobu tae-Na, ‘Moko daa tolu' ilio, Yaku' bo tumuo' soosoodo.’ ");
INSERT INTO blzNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mbali' iya'a, posuu'kon mian mandagai baleanan iya'a pataka ilio kotolu'na, dako' murit-Na taka mamangan biibii-Na ka' mambantilkon na mian se' i Ia nipotuo'imo noko daa lapus. Ka' pimborekan men kokomburi'anna kani'i ba'idek tuu' tia men olukon.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Taena i Pilatus na ko'ona i raaya'a, “Karaani'i a surudadu bo pandagaimuu. Rae' ka' dagai a baleanan iya'a pore-pore.” ");
INSERT INTO blzNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mbaka' i raaya'a nomae'mo tia surudadu, ka' i raaya'a nensegelmo watu men nongompodi baleanan iya'a ka' nandagai dako' singaonna mian. ");
INSERT INTO blzNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sarataa noporus a ilio Sabat, na ilio Minggu ma'ulop tuu', ai Maria Magdalena tii Maria men sambanaan nomae'mo mengelego'i baleanan ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ola-olan nolili'onmo men dodoa gause isian malaa'ikatna Tumpu nalau ra'amari langit. Ia notaka na watu men nongompodi baleanan iya'a kasi ningilinda' ka' no'umoruang na wawona. ");
INSERT INTO blzNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ro'upna dingkalapan koi kilap ka' pakeanna bubulak tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ka' surudadu men nandagai baleanan iya'a nolantutukanmo layaon ka' dudusna i raaya'a somo koi mian lapus. ");
INSERT INTO blzNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kasee malaa'ikat iya'a norobu na wiwine men iraando'o taena, “Alia i kuu layaon, gause inti'ionku se' i kuu mansarak i Yesus men nisaliipkon iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ia sianmo kani'i, gause i Ia notuo'mo soosoodo koi men Ia poko ngaanmo. Mai piile' a tampat men nomotokolan i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Rae'mo donga-dongan ka' bantilkon na murit-Na se' i Ia notuo'mo soosoodo noko daa lapus. Ia mongolukoni i kuu na Galilea. Nda'asi ka' piile'onmuu i Ia. Imamat a men yaku' bantilkonmo na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Raaya'a liuliu namarerei baleanan iya'a tia noa layaon ka' lewa' tuu' kasi notumetende' mambantilkon na murit ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ola-olan i Yesus nomootuungi i raaya'a ka' norobu tae-Na, “Tabea' na ko'omuu.” Raaya'a nangkarani'mo i Ia ka' nangarangkot sarat-Na ka' nonsoosa'. ");
INSERT INTO blzNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mbaka' i Yesus norobumo na ko'ona i raaya'a tae-Na, “Alia layaon. Rae' ka' bantilkon na utus-Ku kada' i raaya'a mae' na Galilea. Nda'asi ka' i raaya'a mimiile' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sarataa i raaya'a na tanga'na salan, toropii surudadu men nandagai baleanan iya'a nomae'mo na kota ka' nambantilkon na tanaasna imam giigii' upa men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ka' noko daa nopoosangadai tia motu-motu'a, raaya'a nantaraimo surudadu iya'a doi' men biai' tuu', ");
INSERT INTO blzNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ka' nambantilkon taena, “Kuu tio mangaan se' murit-Na notaka malo-malom ka' namangan biibii-Na na tempo i kuu royot. ");
INSERT INTO blzNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka' kalu kani'i inti'ionna gubernuur, kaisi a mambantilkon na ko'ona kada' i kuu sian mungurumpaki repaan.” ");
INSERT INTO blzNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Raaya'a nangalabot doi' iya'a ka' nongololoikon koi men nipotookonmo na ko'ona i raaya'a. Ka' tundunan kani'i notolelemo na lipu' Yahudi pataka koini'i. ");
INSERT INTO blzNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ka' sompulo' sa'angu' murit norumingkatmo mae' na Galilea, na buu'na men ia siso'konmo i Yesus na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sarataa nimiile' i Ia, raaya'a nonsoosa'mo, kasee toropii mian dauga' babata. ");
INSERT INTO blzNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus nangkarani' i raaya'a ka' norobu tae-Na, “Giigii' kuasa na surugaa tia na tano' balaki' nirookonmo na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mbali' iya'a, rae' ka' sidakon a giigii' lipu' bo murit-Ku. Sarani i raaya'a mangaan ngaanna Tama ka' Anak ka' Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pisiso' i raaya'a mangawawau giigii' men Yaku' poko bantilkonmo na ko'omuu. Imamat ini'imari! Yaku' sinampang mansambai i kuu pataka kakabusanna tempo.”");
INSERT INTO blzNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Koi kani'imari a tumbena Lele Pore men ringkat ni Yesus Kristus, men Anakna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lele iya'a nosida koi men ia tulis i Nabii Yesaya na kitapna, taena, “ ‘Imamat ini'imari! Yaku' bo momosuu' mian-Ku mongolukoni i Kuu. Mian iya'a bo montoropoti salan-Muu.’ ");
INSERT INTO blzNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bo isian sa'angu' mian na tano' maleas men mengeleelo'kon ka' mambantilkon, taena, ‘Toropoti a salan bona Tumpu; loosikon a salan bo Ko'ona.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Koi men ia tulis i Yesaya, koiya'a uga' a tatakana i Yohanes Pansarani. Ia dumodongo na tano' maleas, ka' nuntundunkon lelena Tumpu, taena, “Sosoli ka' kadarai a gau'muu men ba'idek ka' i kuu tio saranion kada' Alaata'ala mangampuni dosamuu.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mian na longkop libutan Yudea ka' giigii' mian na kota Yerusalem notaka na ko'ona. Raaya'a nonsosoli ka' nangkadarai wawauna men sala', ka' ia sarani i Yohanes na Weerkauna Yordan. ");
INSERT INTO blzNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pakean ni Yohanes wuluna unta a niwawau, ka' boborna lolosna anit a niwawau. Kakaanna katumbang tia gurana wani'. ");
INSERT INTO blzNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Koi kani'imari a men ia bantilkon i Yohanes mian, taena, “Moko daa i yaku' bo taka i Ia men dauga' labi i yaku' a kuasa-Na. Dumudungku' mangalakai lui'na sapato-Napo, yaku' koo'. ");
INSERT INTO blzNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ai yaku' mansarani i kuu tia weer, kasee i Ia bo mansarani i kuu tia Alus Molinas.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tempo iya'a, ai Yesus norumingkatmo na Nazaret na lipu' Galilea, notaka ni Yohanes. Yesus ia sarani i Yohanes na Weerkauna Yordan. ");
INSERT INTO blzNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sarataa i Yesus no'umuar na weer, Ia nimiile' langit nokobongkatian, ka' Alus Molinas koi marampatii nalau na waka-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kasi nokamporongoran a wurungna Alaata'ala nda'amari surugaa, tae-Na, “Koomo a Anak-Ku men kolingu'-Ku ka' i Koo a men daa kokana'-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Noko daa iya'a, Alus Molinas nangandaarkonmo i Yesus na tano' maleas. ");
INSERT INTO blzNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ia dongo-dongo patompulo' ilio na tano' maleas ka' ia topongi Ibiliis. Ia na tanga-tanga'na ayop malela', kasee malaa'ikatna Alaata'ala nansambai Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Noko daa i Yohanes nitarungkumo, taka i Yesus na Galilea mengelelekon Lele Pore men ringkat na Alaata'ala, ");
INSERT INTO blzNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","tae-Na, “Temponamo. Batomundo'anna Alaata'ala karani'mo. Sosoli ka' kadarai a gau'muu men ba'idek ka' parasayamo a Lele Pore men ringkat na Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tempona i Yesus nomae' noso'ole na Danau Galilea, Ia nimiile' i Simon tii Andreas moto'utus. Raaya'a pintanga' muntuong puka' na danau, gause palimangonna i raaya'a pupuka' susum. ");
INSERT INTO blzNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Taeni Yesus na ko'ona i raaya'a, “Mai i kuu, lolo' i Yaku', kada' poposidaon-Ku pumuka' mian.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Raaya'a liuliu namarerei puka'na ka' nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ndee-ndee'e Ia nimiile'mo i Yakobus tii Yohanes, anak ni Zebedeus, pintanga' montotobo'i puka'na na lalomna duangan. ");
INSERT INTO blzNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus liuliu nengeleelo' i raaya'a ka' raaya'a uga' namarereimo tamana men i Zebedeus tia mian men ia tamboi i raaya'a balimang na duangan, kasi nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Noko daa koiya'a, ari Yesus notakamo na kota Kapernaum. Na ilio Sabat, ai Yesus ninsoopmo na laigan bakitumpuan ka' nimisiso' mian. ");
INSERT INTO blzNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Raaya'a kodaawan nongorongor pisiso' ni Yesus, gause pimisiso'-Na koi mian men kuasaan ka' poosasala' tia pimisiso'na wawa ukum Torat. ");
INSERT INTO blzNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tempo iya'a, isian sa'angu' mian men ia lampingi meena na lalomna laigan bakitumpuan iya'a. Mian iya'a nangkakaro', taena, ");
INSERT INTO blzNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Oo Yesus samba Nazaret, aupa a urusaan tii kai? Kabai i Koo taka bo pinsilaka'i i kai? Inti'ionku se' i ime i Koo: Koo a men Molinas nda'ara'amari na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kasee ai Yesus nengerengeaki meena iya'a, taena, “Pimporokot! Uarmo i koo na mian kanono'!” ");
INSERT INTO blzNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Meena iya'a ningirimpa-rimpa'konmo mian men ia lampingi, ka' nangkakaro', kasi no'umuar. ");
INSERT INTO blzNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wiwi'na mian men nimiile' nosamba'mo, tamban i raaya'a nopootundunii, taena, “Se', aupa inta ini'i? Sa'angu' pisiso' u'uru men kuasaan. Meenapo posuu'on-Na umuar, ka' raaya'a malolo' na Ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Liuliu notolele a wawau ni Yesus na longkop libutan Galilea. ");
INSERT INTO blzNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tonguar na laigan bakitumpuan iya'a, ari Yesus nomae'mo na laigan ni Simon tii Andreas. Ai Yakobus tii Yohanes uga' nomae'. ");
INSERT INTO blzNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Taka inde'e, Ia takai monian ni Simon men sinana boroki'na toko-tokol suminggar. Mian na laigan iya'a liuliu nambantilkon i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ia nomae'mo na tokolanna wiwine iya'a, ningintoni limana ka' nangawangonkon. Wiwine iya'a liuliu nalesi'. Noko daa koiya'a, wiwine iya'a nangkalesangmo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Guntumalom, niwawamo ni Yesus a wiwi'na mian men manggeo tia mian men lampingionna meena. ");
INSERT INTO blzNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wiwi'na mian na kota iya'a nobarimpung na soopanna laigan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ia nengelesi'imo mian biai' men biai' kaliangan a nggeona. Ka' Ia uga' numbuse'i meena biai'. Ai Yesus sian namatalai meena iya'a morobu, gause raaya'a ninginti'imo i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma'ulo-ulop tuu', ilio dauga' pintung, Yesus nowangonmo ka' nomae' na liwana kota. Ia nomae' oloa na mian ka' nosambayang. ");
INSERT INTO blzNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kasee i Simon tia mian sambana mae' nansarak i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sarataa ia rumpaki i raaya'a, raaya'a nambantilkonmo, taena, “Wiwi'na mian mansarak i Kuu.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kasee taeni Yesus, “Mai, kita rae' na dodongoan sambana, na kota men beebeel kaniaale'e, kada' inda'aa uga' ai Yaku' sida mengelelekon Lele Pore, gause i Yaku' notaka bo pengelelekon Lele Pore.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kasi i raaya'a nomae' longkop libutan Galilea. Ia nengelelekon Lele Pore na laigan bakitumpuan, ka' numbuse'i meena men nangalampingi mian. ");
INSERT INTO blzNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tempo iya'a, isian sa'angu' mian kustaon notaka ni Yesus, ka' nobanintuur na arop-Na. Ia nokitulung ni Yesus, taena, “Kalu i Kuu maloos, Kuu sida mengelesi'i i yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tongkibit a noa ni Yesus nolingu'. Ia doekon a lima-Na nongkoyong mian iya'a, ka' norobu tae-Na, “Daa, Yaku' maloos. Bi poloe'mo i koo!” ");
INSERT INTO blzNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tempo iya'a uga', na'anumo a kustana mian iya'a. Ia liuliu nalesi'. ");
INSERT INTO blzNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Liuliu i Yesus nomosuu' mian iya'a mae' na imamna Yahudi, ka' nomotoo, tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Imamatoon pore-pore! Alia i koo mambantilkon ni imepo, kasee rae' na imam ka' pipiile'kon na ko'ona se' kustaam daa na'anumo. Moko daa iya'a kasi rookon a kurbaan koi men ia posuu'kon i Musa na ukum Torat kada' manasa na mian se' kustaam tuutuu' na'anumo.” ");
INSERT INTO blzNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kasee mian iya'a nomae' nuntundunkon ka' nontolele'kon na mian biai' upa men nosida na wakana. Noko daa koiya'a, ai Yesus sianmo ningkakateda minsoop na kota. Ia somo na liwana kota, na tampat men sianta mianna. Mau koiya'a, mian na sanda' lembo' dauga' sataka-taka na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Porusmo toro pii ilio, ai Yesus notakamo soosoodo na Kapernaum. Tolele a tundunan, se' i Ia isianmo na laigan. ");
INSERT INTO blzNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mbaka' notakamo a mian biai' moruuruut, tamban na laigan iya'a sianmo pinsisipan, mau na soopanpo, nobootmo. Pintanga' i Ia muntundunkon wurungna Alaata'ala na ko'ona i raaya'a, ");
INSERT INTO blzNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","isian mian toropii ira notaka ni Yesus nangawawa sa'angu' mian repo'. Mian repo' iya'a ni'uer paat mian. ");
INSERT INTO blzNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kasee i raaya'a sian nomoko nangawawa ni Yesus gause mian indo'o biai' tuu'. Raaya'a somo nantataki atop intu-intu i Yesus. Noko daa nitataki, ia ululmo i raaya'a a mian repo' iya'a tia ueranna. ");
INSERT INTO blzNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ia piile' i Yesus se' i raaya'a parasaya na Ko'ona, mbaka' Ia norobumo na mian repo' iya'a, tae-Na, “Oo anak-Ku, dosaam daa ni'ampunimo!” ");
INSERT INTO blzNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kasee indo'o isian uga' wawa ukum Torat toropii ira poto'oruang. Raaya'a nompoo'inurutikonmo na noana taena, ");
INSERT INTO blzNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nongko'upa a mian kaya'a se' mangaan koiya'a? Wawau-Na koi se' i Iamo a Alaata'ala. Ime a men daa sida mangampuni dosa saliwakon Alaata'ala suungna?” ");
INSERT INTO blzNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kasee i Yesus liuliu ninginti'i noana wawa ukum Torat iya'a. Yesus norobumo na ko'ona i raaya'a, tae-Na, “Nongko'upa se' i kuu mimikirawar koiya'a na noamuu? ");
INSERT INTO blzNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aupa a daana, mangaan na mian repo' kani'i, ‘Dosaam daa ni'ampunimo,’ kabai se' mangaan, ‘Wangonmo, leengket a ueraan ka' tumpang?’ ");
INSERT INTO blzNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kasee koini'i popo'inti'ikonon-Ku na ko'omuu se' Anak Manusia kuasaan mangampuni dosana mian na tano' balaki'.” Kasi i Yesus norobu na mian repo' iya'a, tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Porongori a wurung-Ku: wangonmo, nakat a ampaas ka' ule'kon na laigaan!” ");
INSERT INTO blzNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mian iya'a nowangonmo, liuliu nangala ampasna pototiok i raaya'a giigii' ka' no'umuar. Mbaka' i raaya'a wiwi'na nosamba'mo, kasi nuntunde' Alaata'ala. Taena, “Upa men koi kani'i baasi kita piile'!” ");
INSERT INTO blzNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Noko daa iya'a, ai Yesus nomae'mo soosoodo na soripi'na danau. Biai' a mian notaka na Ko'ona, ka' i raaya'a ia pisiso' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Rae-rae' i Yesus indo'o, Ia nimiile' anak ni Alfeus sa'angu' men ngaanna, ai Lewi. Ia oru-oruang na kantor pajak. Taeni Yesus na ko'ona, “Mai, lolo' i Yaku'.” Mbaka' ia norumingkatmo, ka' nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pintanga' i Yesus kumaan na laigan ni Lewi notakamo a mian biai' men pagawena pajak tia mian dosaon kumaan ruru-ruru' tii Yesus ka' murit-Na, gause biai' a mian nongololo' ari Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sarataa wawa ukum Torat men mian Farisi nimiile' se' i Yesus kumaan tia papa'ase' pajak ka' mian dosaon, raaya'a norobumo na murit ni Yesus, taena, “Nongko'upa i Ia se' kumaan poopooruru' tia pagawena pajak ka' mian dosaon?” ");
INSERT INTO blzNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nomorongor upa men ia porobukon i raaya'a, mbaka' ia simbatimo i Yesus tae-Na, “Taasi' mian malesi' a paraluu dokter, kasee mian men manggeo. Yaku' notaka taasi' bo pengeleelo' mian men kana' a wawauna, kasee bo pengeleelo' mian dosaon kada' mongololo' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tempo pintanga' ba'apata a murit ni Yohanes toropii ira ka' mian Farisi toropii ira, taka a mian toro pii ira norobu ni Yesus, taena, “Murit ni Yohanes tia muritna mian Farisi ba'apata, see nongko'upa a murit-Muu se' sian?” ");
INSERT INTO blzNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ia simbati i Yesus tae-Na, “Sida mbali' a sawe'na suo' moro'one ba'apata na posuo'anna see suo' moro'one iya'a dauga' indo'o tii raaya'a? Kalu suo' moro'one dauga' indo'o tii raaya'a, sabole i raaya'a sian ba'apata. ");
INSERT INTO blzNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kasee bo taka a tempona suo' moro'one iya'a bo alaon na ko'ona i raaya'a. Na temposi iya'a kasi i raaya'a ba'apata. ");
INSERT INTO blzNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sianta sa'angu'po mian a mantampalkon sangkeap toik u'uru na pakean men manau'mo. Gause kalu koiya'a, toik u'uru men pantampal iya'a sabole kumomput ka' memberak pakean men manau'mo, mbaka' kaekae' dodoa a berakna. ");
INSERT INTO blzNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Koiya'a uga', sianta sa'angu'po mian a mantawa' anggur men u'uru na batutu' anit manau'. Gause kalu koiya'a, anggur iya'a sabole memberak batutu' anit iya'a, mbaka' anggurna kowuwus ka' batutu' anitna kobaraba'ian. Kasee anggur men u'uru uga' tiodaa isiikonon na batutu' anit men u'uru.” ");
INSERT INTO blzNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na sa'angu' ilio Sabat, ari Yesus nosumalan na ale'na gandum. Potorae' i raaya'a, murit-Na numpupumo gandum. ");
INSERT INTO blzNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mbaka' mian Farisi norobumo ni Yesus, taena, “Piile'! Nongko'upa i raaya'a se' mangawawau upa men sian patalaion wawauon na ilio Sabat?” ");
INSERT INTO blzNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ia simbati i Yesus tae-Na, “Sianpo mbali' i kuu nambasa a upa men ia wawau i Daud na tempo i ia tia mian men nongololo' i ia see nokololuan? ");
INSERT INTO blzNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ia ninsoop na Laiganna Alaata'ala tempo i Abyatar a Imam Moola', ka' nitarai nangkaan roti men nirookonmo bona Alaata'ala. Poali tongko' imam a men daa sida mangkaan roti iya'a. Kasee i Daud nangkaan tamban nantarai giigii' lolo'na.” ");
INSERT INTO blzNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kasi i Yesus norobu na ko'ona i raaya'a, tae-Na, “Ilio Sabat niwawau kada' bo pangalawei mian, ka' taasi'po mian niwawau kada' bo repaion na ilio Sabat. ");
INSERT INTO blzNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ka' Anak Manusia uga' a Pinginti'i na ilio Sabat.” ");
INSERT INTO blzNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Noko daa koiya'a, ai Yesus ninsoopmo soosoodo na laigan bakitumpuan. Indo'o isian sa'angu' mian men repo' a limana sambotak. ");
INSERT INTO blzNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka' isian uga' mian toropii ira indo'o. Raaya'a manganasai i Yesus, too-too mengelesi'i mian iya'a na ilio Sabat, kada' bo pompoposala'anna i raaya'a i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ai Yesus norobumo na mian men repo' a limana sambotak iya'a, tae-Na, “Mai, kekerer ka'ita na aropna mian!” ");
INSERT INTO blzNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Noko daa koiya'a i Yesus norobumo na mian iraando'o, tae-Na, “Koi taena agama, upa a men sida wawauonta na ilio Sabat? Mangawawau men ma'amat kabai se' mangawawau men ba'idek? Mansalamatkon mian kabai se' mampapatei mian?” Kasee i raaya'a tongko' potorokot. ");
INSERT INTO blzNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus nasiongo'konmo noana i raaya'a men bingilan, ka' Ia nomaso'. Ia nantangak tiku-tikum na i raaya'a, ka' norobu na mian iya'a, tae-Na, “Soorkon a limaam!” Kasi ia soorkon, mbaka' limana mian iya'a uga' nalesi'mo. ");
INSERT INTO blzNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kasi mian Farisi toropii ira no'umuar na laigan bakitumpuan ka' nobasangada mampapatei i Yesus tia winawa ni Tomundo' Herodes toropii ira. ");
INSERT INTO blzNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Noko daa koiya'a, ai Yesus tia murit-Na nobalimba'mo na danau. Biai' a mian men ringkat na Galilea nompololo'. Isian uga' men ringkat na Yudea, ");
INSERT INTO blzNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusalem, lipu' Idumea, sambotakna Weerkauna Yordan, ka' na tano' Tirus tia Sidon. Biai' a mian notaka na Ko'ona, gause i raaya'a nongorongor wiwi'na upa men Ia wawau. ");
INSERT INTO blzNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gause mian biai' tuu', mbaka' i Yesus somo nomosuu' murit-Na montoropoti duangan sa'angu' bo Ko'ona, dako' i Ia ko'ipit na mian. ");
INSERT INTO blzNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wiwi'na mian men manggeo, popeepeet mae' munsuduk i Ia, gause i Ia nengelesi'i mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mian men lampingionna meena, kalu mimiile' i Yesus, tonsungol na arop-Na, ka' i raaya'a mangkakaro', taena, “Koomo mba'a a men anak na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kasee i Yesus nongkokundakon tuu' meena iya'a dako' mambantilkon se' ai ime i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Noko daa iya'a i Yesus nolumoponmo mbaara'a buu'na. Ia nengeleelo' mian men kikira'-Na ka' raaya'a uga' notakamo na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ia nungururuki sompulo' rua' mian men ngaanon poposuu', bo pongololo' i Ia, ka' bo posuu'on-Na mengelelekon Lele Pore. ");
INSERT INTO blzNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Raaya'a Ia tarai kuasa bo pumbuse'i meena. ");
INSERT INTO blzNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sompulo' rua' mian men Ia patuk iya'a: ai Simon men ia ngaani i Yesus i Petrus, ");
INSERT INTO blzNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ka' i Yakobus tia utusna i Yohanes, rua-rua' irana iya'a anak ni Zebedeus, ka' rua-rua'na Ia ngaani i Yesus Boanerges, men aratina, anakna kokurung. ");
INSERT INTO blzNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Men sambana: ai Andreas, Filipus, Bartolomeus, Matius, Tomas, Yakobus, anak ni Alfeus, Tadeus, Simon mian Zelot, ");
INSERT INTO blzNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ka' i Yudas Iskariot, men nangakalkon bo pongorookonna i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Noko daa iya'a, ari Yesus ninsoopmo na sa'angu' laigan. Mbaka' notakamo a mian biai' ningiriwuti i raaya'a tamban nokumaanpo, sianmo ia sida i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ia rongor poto'utusan-Na a wawau-Na se' koiya'a, raaya'a notakamo nondolo' i Ia, gause taena i raaya'a se' i Ia sianmo matotong. ");
INSERT INTO blzNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ka' wawa ukum Torat men notaka nda'amari Yerusalem nambantilkon, taena, “Ai Yesus ia lampingimo Beelzebul, men tanaasna meena.” Taena uga', “Ai Yesus mumbuse'i meena men mangalampingi mian tia ukumaatna tanaasna meena.” ");
INSERT INTO blzNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ai Yesus nengeleelo' wawa ukum Torat iya'a, kasi norobu na ko'ona i raaya'a see tia timbaani', tae-Na, “Koi upa a Ibiliis ka' mumbuse'i Ibiliis? ");
INSERT INTO blzNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kalu sa'angu' batomundo'an pookakaresa ka' sian pooka'amat, batomundo'an iya'a sian bakitaan, ");
INSERT INTO blzNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ka' kalu sa'angu' suo' pookakaresa ka' sian pooka'amat, suo' iya'a sianmo bakitaan. ");
INSERT INTO blzNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Koiya'a uga' na batomundo'anna Ibiliis. Kalu meenana pootimbangi raaraaya'amo, ka' pookakaresamo, batomundo'anna sianmo bakitaan, mbaka' takamo a kosilaka'anna. ");
INSERT INTO blzNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kasee sianta sa'angu'po mian a men momoko miminsoopi laiganna mian men bukuan ka' mangarampasi kupangna, kalu sian punguonna kutung a mian bukuan iya'a. Moko daasi koiya'a, kasi i ia sida mangala kupangna mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' giigii' dosana mian mau wurungpo men mingiroki Alaata'ala sida ampunion, ");
INSERT INTO blzNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kasee kalu mian mingiroki Alus Molinas, ia sian sida ampunion pataka manau', gause mian iya'a nangawawaumo sala' men sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Koiya'a nambantili ni Yesus wawa ukum Torat iya'a, gause i raaya'a nangaani i Yesus ia lampingi meena. ");
INSERT INTO blzNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mbaka' notakamo a sina ni Yesus tia utus-Na. Raaya'a potokerer na liwana ka' nomosuu' mian mengeleelo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Isian mian biai' no'umoruang nintikumi i Yesus. Raaya'a norobu na Ko'ona, taena, “Piile', sina-Muu tia utus-Muu mokaraale'e na liwana, mampari-pari momootuungi i Kuu.” ");
INSERT INTO blzNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ia simbati i Yesus tae-Na, “Ime mbali' a sinang-Ku ka' ime mbali' a utus-Ku?” ");
INSERT INTO blzNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ia nimiile' giigii' mian men no'umoruang tiku-tikum-Na kasi norobu tae-Na, “Iraani'i a sinang-Ku tia utus-Ku! ");
INSERT INTO blzNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ime a men mangawawau koi pingkira'na Alaata'ala, iamo a utus-Ku moro'one, utus-Ku wiwine, ka' iamo a sinang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na sa'angu' tempo, ai Yesus nimisiso' mian soosoodo na soripi'na danau. Mbaka' notakamo a mian biai' tuu' ningiriwuti i Ia, pataka i Ia somo nolumakit na sa'angu' duangan men lanto-lanto, ka' no'umoruang indo'o. Kasee mian biai' iya'a, wiwi'na na tano' na soripi'na danau. ");
INSERT INTO blzNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesus nobatimbaani' nimisiso'kon biai' kaliangan upa na ko'ona i raaya'a. Koi kani'i a pisiso'-Na, tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Porongori ini'imari! Isian po'ale' sa'angu' mae' mangkambur wine' na ale'na. ");
INSERT INTO blzNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Banta-bantang i ia mangkambur, isian wine' men nandawo' na soripi'na salan. Kasi notaka a sapu' ka' nangkaan wine' iya'a pataka nokabus. ");
INSERT INTO blzNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Isian uga' men nandawo' na karabatu, men sian laan tano'na. Wine' iya'a liuliu notumuo' gause tano'na monipis. ");
INSERT INTO blzNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kasee sarataa no'alayo'mo a ilio, wine' men notuo'mo iya'a nalaumo, kasi nakangkung ka' nopate, gause wakatna sian alalom. ");
INSERT INTO blzNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Isian uga' wine' men nandawo' na rakut masolot ka' ruri'on. Kasi rakut masolot ka' ruri'on iya'a no'uminsur ka' ningipit wine' men notuo'mo iya'a pataka nopate, mbaka' sianmo niwoo'. ");
INSERT INTO blzNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kasee isian uga' wine' men nandawo' na tano' men molumba'. Ia notumuo' molumba' ka' niwoo'. Woo'na isian men ninturang poro tolumpulo' paku', poro nomompulo' paku', ka' isian uga' men para sa'atu paku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kasi tae-Na, “Daa tilingaan, imamat pore-pore!” ");
INSERT INTO blzNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sarataa i Yesus somo suungna, toropii mian men nongololo' i Ia tia sompulo' rua' murit-Na iya'a, nimikirawarmo na Ko'ona se' upa aratina timbaani' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Taeni Yesus, “Kuu nitaraimo pinginti'ian kada' minginti'i upa men mawuni na Batomundo'anna Alaata'ala, kasee na mian sambana men sian mongololo' pisiso'-Ku, wiwi'na upa bantilkonon tia timbaani', ");
INSERT INTO blzNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kada' daa sida a men nitulis: ‘Mau mimiile' see i raaya'a sian mingimamat; maupo mongorongor see i raaya'a sian minginti'i, dako' i raaya'a mombolii wawauna ka' ampunion.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kasi ia pikirawari i Yesus i raaya'a, tae-Na, “Ai kuu se' daa ninginti'imo timbaani' kani'i kabai sianpo? Kalu sianpo, koi upa a pinginti'ianmuu timbaani' sambanaan? ");
INSERT INTO blzNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Po'ale' men mangkambur wine' mintimbaani'kon mian men mengelelekon wurungna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tano' na soripi'na salan mintimbaani'kon mian men mongorongor wurungna Alaata'ala iya'a, kasee liuliu notaka a Ibiliis ninsiasa wurungna Alaata'ala men baasi nilelekon na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tano' men watuon mintimbaani'kon mian men mongorongor wurungna Alaata'ala, ka' liuliu mangalabot tia noa beles; ");
INSERT INTO blzNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kasee raaya'a sian niwakat, mbali' tongko' notontaan sangkodi' a wurungna Alaata'ala. Komburi'na, kalu repaionna mian ka' talalaison gause i raaya'a nangalabot wurungna Alaata'ala iya'a, raaya'a liuliu minsasapu kaparasaya'anna. ");
INSERT INTO blzNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tano' men isian rakut ruri'on mintimbaani'kon mian men nongorongor wurungna Alaata'ala, ");
INSERT INTO blzNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kasee dauga' babatakon tutuo'na i raaya'a ka' uga' mingkira' tumuo' labian na tano' balaki' kani'i. Biai' kaliangan a ko'uusna. Mbali' iya'a, wurungna Alaata'ala noko'ipit na noana i raaya'a, mbaka' sian niwoo'. ");
INSERT INTO blzNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kapupusanna, wine' men nikambur na tano' men molumba' mase mian men mongorongor ka' mangalabot wurungna Alaata'ala, kasi miwoo'. Ule'na isian men poro tolumpulo' paku', kabai poro nomompulo' paku', kabai se' para sa'atu paku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ai Yesus norobu soosoodo na ko'ona i raaya'a, tae-Na, “Mian moboloak taasi' sa'uon tia gumbang, kabai pokelaon na intuna tokolan, kasee pokelaon na sulaanna. ");
INSERT INTO blzNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Koiya'a uga', upa men mawuni, komburi'na uga' bo kampiile'an. Ka' upa men nipopowuni, komburi'na bo bantilkonon. ");
INSERT INTO blzNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kalu i kuu mo'uus minginti'i Batomundo'anna Alaata'ala, imamat pore-pore!” ");
INSERT INTO blzNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ai Yesus ningimputimo tundunan-Na soosoodo, tae-Na, “Imamat a upa men kuu rongor! Takalan men kuu takalkon bo takalkonon na ko'omuu. Saliwakon koiya'a bo turangion na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Gause mian men isianmo upa ia tombonoi bo taraion soosoodo, kasee mian men sianta upa tombonoionna, toro tiu'po men dauga' isian na ko'ona bo alaon na ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kasi taeni Yesus, “Batomundo'anna Alaata'ala koi mian men mangkambur wine' na ale'na. ");
INSERT INTO blzNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sian inti'ionna mian iya'a koi upa a i'insurna wine' iya'a. Malom, tempo ia motokol, kabai ilio, tempo ia wangon, wine' iya'a sumukutmo ka' kaekae' alayo'. ");
INSERT INTO blzNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tano' suungna munguarkon woo'na, tumbe-tumbe boinganna, kasi koengna, moko daa, kasi wurasna men bentes. ");
INSERT INTO blzNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tempona woo'na mataakmo, ia padakonnamo mian iya'a, gause kopamadakanmo.” ");
INSERT INTO blzNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ai Yesus norobu soosoodo, taena, “Upa a pomookokoikonta Batomundo'anna Alaata'ala iya'a, kabai koi upa bo pintimbaani'kon tia pimpipiile'konta? ");
INSERT INTO blzNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Batomundo'an-Na koi watuna sasawi men nikambur na tano'. Watuna sasawi a men morio' tuu', ka' sianta watuna gala sambana men koiya'a korio'na. ");
INSERT INTO blzNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kasee tempo i ia nikambur, ia tumuo' ka' uminsur labi gala sambanaan, kasi mimpanga' biai' ka' moola', mau sapu'po sida mimpeeta ka' lilungionna.” ");
INSERT INTO blzNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus nambantilkon wurungna Alaata'ala na mian biai' tia biai' timbaani' men koiya'a. Timbaani' iya'a sintutu' tia pinginti'ianna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sinampang i Ia mimisiso' mian, Ia batimbaani', kasee na murit-Na bantilkonon-Na a aratina wiwi'na, kalu raaraaya'ana. ");
INSERT INTO blzNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Maamaalom na ilio iya'a, ai Yesus norobumo na murit-Na, tae-Na, “Mai kita lumembet na sambotakna danau.” ");
INSERT INTO blzNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Murit ni Yesus namarereimo mian biai' ka' nolumakit na duangan ka' nangawawa i Yesus men noko ndo'omo na lalomna. Raaya'a nomae'mo ka' isian uga' duangan men sanggiran nomae'. ");
INSERT INTO blzNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kasi notaka a boyus men makorong tuu' ka' bokol munsumparak duangan, tamban duangan iya'a boomo mosool. ");
INSERT INTO blzNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na tempo iya'a, ai Yesus pintanga' royot na batolopuusan, takala'-Na notangunan. Mbaka' murit-Na ninsimpumo i Ia, ka' nambantilkon na Ko'ona, taena, “Guru, ai Kuu tongko' royot, kita mase boomo silaka'.” ");
INSERT INTO blzNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ai Yesus nowangonmo, ka' nongkokundakon boyus iya'a ka' nomorobui danau, tae-Na, “Rokot, bi todoo!” Uga' norokotmo a boyus ka' danau iya'a notodoomo tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kasi i Yesus norobu na murit-Na, tae-Na, “Nongko'upa i kuu se' layaon tuu' koiya'a? Nongko'upa i kuu se' sian parasaya na Ingku'?” ");
INSERT INTO blzNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Raaya'a nolayaonmo tuu', ka' nopootundunii simbaya'na, taena, “Ime a men tuutuu'na mian kaya'a? Mombuul tia danaupo momorongori i Ia!” ");
INSERT INTO blzNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ari Yesus notakamo na sambotakna danau na dodongoanna lipu' Gerasa. ");
INSERT INTO blzNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Baasi nalau i Yesus na duangan, liuliu notaka a sa'angu' mian moro'one ringkat na wangunan. Mian iya'a ia lampingi meena, ");
INSERT INTO blzNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ka' dodongoanna na wangunan iya'a. Ia sianmo dodoron kooton, mau tia rante, ");
INSERT INTO blzNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","gause piripiimo i ia nikalo' ka' nirante kasee rante tatakonna ka' kalo'anna baraba'ionna. Mian iya'a bukuan tuu'; sianta sa'angu' mian a men mamaka'ala manganaami. ");
INSERT INTO blzNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ilio malom ia tongko' sayo-sayo waale'e-le'emari na wangunan tia buu'na ka' mangkakaro' ka' membelai wakana tia watu. ");
INSERT INTO blzNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Oloapo a nontoa'ianna mian iya'a se' i Yesus notaka, ia notumetende'mo ka' nonsoosa' na arop ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Boolak tuu' i ia nangkakaro'kon, taena, “Oo Yesus, Anakna Alaata'ala men na ko'alayo'an! Upaioonmo i yaku' kani'i? Sumpa' mangaan ngaanna Alaata'ala, pa'ase'onku, amo' talalaison i yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mbali koiya'a a norobuna gause i Yesus norobu na mian iya'a, tae-Na, “Meena men mangalampingi mian kani'i, uar!” ");
INSERT INTO blzNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kasi ia pikirawari Yesus a mian iya'a, tae-Na, “Ime a ngaawan?” Ia simbati mian iya'a, taena, “Ngaanku i Legion, gause i kai biai' tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Piribiai' i ia nokumakaase' ni Yesus kada' amo' buse'ion i raaya'a umuar na dodongoan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Karani' dodongoan iya'a isian bau' biai' tuu' pintanga' mansarak kumaan na tembanon. ");
INSERT INTO blzNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Raaya'a nokumakaase' ni Yesus, taena, “Posuu' i kai balimba' na bau' karaatu'u, ka' patalai i kai miminsoopi.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ai Yesus sangada men koiya'a. Meena iya'a no'umuarmo na mian iya'a ka' nangalampingi bau' iraantu'u. Bau' salulusan iya'a notumetende'mo ka' notumumbur na liu' waaro'o na weer, mbaka' nopatemo nolomos. Kobiai'na bau' iya'a toro rua' loloon. ");
INSERT INTO blzNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pontondong bau' iya'a notumetende'mo ka' nuntundunkon lele iya'a na kota ka' na kampung men na tiku-tikumna. Mbaka' no'umuarmo a mian biai' mae' mimiile' upa men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mian biai' iya'a notakamo ni Yesus ka' nimiile' mian iya'a men koi umba'ana ia lampingi meena biai' iya'a, mondo'o oru'oruang. Ia nobapakemo ka' nopatotongmo. Mbaka' i raaya'a nolayaonmo. ");
INSERT INTO blzNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mian men nimiile' upa men nosida iya'a nuntundunkonmo na ko'ona i raaya'a upa men nosida na mian men ia lampingi meena ka' uga' men nosida na bau' men biai' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kasi tombono dodongoan iya'a nama'ase' ni Yesus kada' i Ia mamarerei dodongoan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tolakit i Yesus na duangan, mian iya'a men ia lampingi meena, nama'ase'mo ni Yesus kada' i ia poturangon lumolo' na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kasee i Yesus sian nomoturang. Tae-Na, “Ule'kon na laigaan ka' bantilkon poto'utusaan a upa men ia wawau Tumpu na ko'oom, ka' polingu'-Na na ko'oom.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mian iya'a uga' nomae'mo ka' nuntundunkon mian na libutan Dekapolis upa men ia wawau i Yesus na ko'ona. Wiwi'na mian men nongorongor tundunanna iya'a nosamba'mo. ");
INSERT INTO blzNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ai Yesus nolumakitmo na duangan ka' nomule'kon soosoodo na sambotakna danau. Dauga' indo'o na soripi'na danau i Ia, noruuruubanmo a mian taka munguruuti i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Taka a sa'angu' mian, ngaanna ai Yairus. Ia tanaasna laigan bakitumpuan. Tongko' ia piile' se' i Yesus, ia liuliu nonsoosa' na arop-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ia nokumakaase' ni Yesus, taena, “Anakku wiwine manggeo tuu', boomo lapus. Taka walinta ka' epetkon a lima-Muu na wakana, kada' i ia malesi', dako' lapus.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ai Yesus uga' nomae'mo singka-singkat tii Yairus. Biai' a mian nompololo' tamban pogeegeet tiku-tikum. ");
INSERT INTO blzNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na tanga'na mian biai' iya'a isian sa'angu' wiwine men sompulo'mo rua' taun mariingi'on men dodoa. ");
INSERT INTO blzNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Biai'mo a mian namakuli' i ia tamban kabus a kupangna nambayar nobapakuli'anna, see sia-sianapo nalesi', tongko' kaekae' ka' dodoa. ");
INSERT INTO blzNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ia nongorongormo lelena upa men wawauon ni Yesus. Mbaka' na tanga-tanga'na mian biai' iya'a, ia nembeelimo i Yesus see paraas tokurung-Na, kasi nongkoyong juba-Na, ");
INSERT INTO blzNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","gause na noana, taena, “Mau tongko' koyongonku a juba-Na sabole malesi' i yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Poololo'kon iya'a uga' na'anumo liuliu a mariingi'na, ka' nunsuri wakana nalesi'mo. ");
INSERT INTO blzNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Singkat iya'a uga' ai Yesus nunsuri isian kuasa-Na men no'umuar na waka-Na. Ia ningilinga mian biai' paraas tokurung-Na, ka' nimikirawar, tae-Na, “Ime a men nongkoyong jubang-Ku?” ");
INSERT INTO blzNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Taena murit-Na, “Kuu daa nimiile' mian biai' tuu' kani'i pogeegeet, kadai i kuu dauga' mimikirawar, se' i ime a men nongkoyong i Yaku'?” ");
INSERT INTO blzNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kasee i Yesus dauga' nintioki tiku-tikum mansarak mian men nongkoyong i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wiwine men nalesi' iya'a ninginti'i upa men ia surimo na wakana. Ia nolantutukanmo layaon, ka' notaka na arop ni Yesus nonsoosa', ka' nambantilkon tuutuu'na upa men nosida na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kasi i Yesus norobu na wiwine iya'a, tae-Na, “Anak-Ku, gause i koo parasaya na Ingku', mbaka' i koo malesi'. Rae'mo tia noa ma'amat. Koo daa nalesi'mo.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pintanga' morobu i Yesus, notakamo a mian pii ira men poto'utusan ni Yairus, tanaasna laigan bakitumpuan iya'a. Raaya'a nambantilkon ni Yairus, taena, “Anakmuu nolapusmo. Nongko'upa ka' dauga' mungkulen i Guru.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesus sianta nomorongori upa men ia tundun i raaya'a. Ia norobumo na tanaasna laigan bakitumpuan iya'a, tae-Na, “Alia layaon. Parasaya, daamo.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesus liuliu nomae' na laigan ni Yairus see sianta namatalai sa'angu'po mian mongololo' i ia. Men sida mongololo', tongko' i Petrus tii Yakobus ka' i Yohanes, utusna. ");
INSERT INTO blzNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sarataa i raaya'a notaka na laiganna tanaasna laigan bakitumpuan, ia piile' i Yesus a mian se' sianmo ni'inti-inti'i. Isian men gora', wiri ka' tumando'. ");
INSERT INTO blzNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus liuliu ninsoop ka' norobu na ko'ona i raaya'a, tae-Na, “Nongko'upa se' gora' tuu' koi kani'imari ka' wiri? Anak kanono' sian nolapus; ia tongko' noroyot.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kasee i raaya'a tongko' nongkolengkei i Yesus. Mbaka' ia posuu'mo i Yesus i raaya'a wiwi'na umuar, kasi Ia wawa a sinana tia tamana anak iya'a, ka' murit-Na tolutolu'na ninsoop na tokolanna anak iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kasi ia intoni i Yesus a limana anak iya'a, ka' norobu tae-Na, “Talita kum,” men aratina, “igo', Yaku' morobu na ko'oom, wangonmo.” ");
INSERT INTO blzNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Anak wiwine iya'a liuliu nowangon ka' notumumpang. Umurna anak iya'a sompulo'mo rua' taun. Wiwi'na mian men isian iraando'o nosamba' tuu' nimiile' koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kasee wawau-Na iya'a sian tuu' patalaion-Na tundunon na mian sambana. Kasi Ia nomosuu' i raaya'a mantarai anak iya'a kumaan. ");
INSERT INTO blzNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ai Yesus namarerei dodongoan iya'a ka' nomae' tia murit-Na na kampung men dodongoan-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na ilio Sabat, ai Yesus ninsoopmo na laigan bakitumpuan, ka' nuntumbei nimisiso' mian biai' indo'o. Raaya'a nosamba' tuu' nongorongor pisiso' ni Yesus. Taena, “Maana nantausian-Na kaya'amari wiwi'na? Koi upa inta' a pinginti'ian men isian na mian kaya'a? Koi upa se' daa sidaon-Na a mangawawau upa kosamba'? ");
INSERT INTO blzNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Taasi' tukang kau i Ia kani'i, men anak ni Maria, ka' moto'utus tii Yakobus, Yoses, Yudas, ka' i Simon? Ka' utus-Na men wiwine taasi' uga' isian iraani'i poododongoi tii kita?” Mbaka' i raaya'a bude' mangalaboti i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kasi i Yesus norobu na ko'ona tae-Na, “Sa'angu' nabii mau mbariana angga'ionna mian, tongko' na kampung men dodongoanna, tia na tanga-tanga'na poto'utusanna tia mianna sangkau laigan ia sian angga'ion.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ai Yesus sian sida nangawawau upa kosamba' na dodongoan iya'a saliwana nengelesi'i mian men manggeo bangar pii ira, men Ia epet tia lima-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesus samba'kon i raaya'a kadai se' sian parasaya. 6:6b-13 Noko daa iya'a ai Yesus nomae'mo na kampung men tiku-tikum pookarani' ka' nimisiso' mian. ");
INSERT INTO blzNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ia leelo' a murit-Na sompu-sompulo' rua' irana, ka' niposuu' mae' rua'-rua'. Koo'po tia nomae', Ia nantarai i raaya'a kuasa bo pumbuse'i meena, ");
INSERT INTO blzNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ka' Ia nomotoo i raaya'a koi kani'imari, tae-Na, “Alia mangawawa upa-upa na rae'anmuu. Men sida tongko' tokon. Alia mangawawa kakaan, kabai se' tuuman, ka' alia mangawawa doi' maupo na boborna lolos. ");
INSERT INTO blzNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mosapato kasee alia mangawawa bokukum rurua'.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ia uga' norobu tae-Na, “Kalu kuu tuuk na laiganna mian, ka' ia laboti mian, dodongomo ino'o; alia balimba' pataka i kuu mamarerei dodongoan kanono'. ");
INSERT INTO blzNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kasee kalu i kuu taka na sa'angu' dodongoan, ka' mian iraando'o bude' mangalaboti tia momorongori i kuu, parerei a dodongoan inono'. Taperi a awu na saratmuu bookoi oos se' i raaya'a sian kokana'na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mbaka' i raaya'a nomae'mo nengelelekon se' mian tiodaa monsosoli ka' mangkadarai wawauna men ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Raaya'a numbuse'i meena biai' ka' menggegesi tia likisonna saitun mian men manggeo ka' mengelesi'i. ");
INSERT INTO blzNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ngaan ni Yesus notolelemo longkop dodongoan, tamban wiwi'na upa men Ia wawau i Yesus uga' nokamporongoranmo ni Tomundo' Herodes. Isian mian men nuntundun i Yesus, taena, “Yohanes Pansarani nipotuo'imo noko daa lapus. Ya'a mbali' mba'a i ia kuasaan mangawawau upa kosamba'.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kasee mian sambana nangaan, taena, “Ia, ai Elia.” Isian uga' men nangaan, taena, “Ia nabii, koikoimo tia nabii mbaripian.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ia rongor i Herodes se' koiya'a, ia norobumo taena, “Sabole i Yohanes Pansarani, men mbaripian yaku' kolongimo a takala'na. Koini'i i ia notuo'mo soosoodo!” ");
INSERT INTO blzNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Gause i Herodes isian nomosuu'kon mian mangarakop i Yohanes ka' nonsoopkon na tarungkuan. Mbali' i Herodes nangawawau koiya'a gause pingkira' ni Herodias. Herodias boroki' ni Filipus, utus ni Herodes, kasee ia poboroki'mo i Herodes. ");
INSERT INTO blzNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Wawau ni Herodes iya'a piribiai'mo ia kokundakon i Yohanes, taena, “Koo sian sida mosuo' tia boroki' na utuus kanono'.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Koiya'a mbali' i Herodias nanganaa' maso'na ni Yohanes, ka' nomonano mampapatei i Yohanes, see sian pokoonna tuu'konon. ");
INSERT INTO blzNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ai Yohanes kolayaon ni Herodes, gause ia inti'i se' i Yohanes sa'angu' mian men kana' a wawauna ka' sianta idekna. Ka' wurung ni Yohanes mau kosiasana noana i Herodes, kasee uga' kikira'na rongoron. Ya'a mbali' ia posuu'kon i Herodes mian kada' mandagai i Yohanes pore-pore dako' silaka'. ");
INSERT INTO blzNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mbaka' daa taka uga' a sa'angu' tempo men ma'amat boni Herodias. Tempo iya'a ai Herodes mangaramekon ilio men nongamea'anna. Na tempo iya'a uga' i Herodes nangawawau ramean bona giigii' moomoola'na batomundo'anna, ka' moomoola'na surudaduna, ka' mian men angga'ion na Galilea. ");
INSERT INTO blzNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na ramean iya'a, anak ni Herodias men laandue' no'umosulen. Osulenna iya'a kinokana'na tuu' noa ni Herodes tia giigii' sawe'na. Mbaka' i Tomundo' Herodes norobumo na laandue' iya'a, taena, “Upapo a men kikira'am, tongko' pa'ase'. Sabole rookononku.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wurung iya'a ia basumpa'kon i Herodes a nontoonkon laandue' iya'a. Taeni Herodes, “Mau upa a men pa'ase'oon, rookononku, tamban mau batomundo'ankupo sambotak, rookononku!” ");
INSERT INTO blzNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wiwine laandue' iya'a no'umuarmo ka' nimikirawar na sinana, taena, “Mama, upa inta' a men pore bo pa'ase'onku?” Ia simbati sinana, taena, “Pa'ase' a takala' ni Yohanes Pansarani!” ");
INSERT INTO blzNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wiwine laandue' iya'a liuliu nomule'kon na Tomundo' ka' norobu taena, “Pa'ase'onku a takala' ni Yohanes Pansarani, rookononmuu i yaku' koikoini'ina tanaon na dulang.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ia rongor i Tomundo' se' koiya'a a pa'ase'na, liuliu nasiongo' tuu' i ia. Kasee sian pokoonna koo'konon a pa'ase'na wiwine laandue' iya'a gause ia nobasumpa'mo rongo-rongor sawe'na. ");
INSERT INTO blzNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mbaka' somo liuliu ia posuu'kon dadagana sa'angu' mae' mondolo' takala' ni Yohanes Pansarani. Mian men niposuu' iya'a nomae'mo na tarungkuan, liuliu nongkolongi takala' ni Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Noko daa koiya'a, ia wawamo a takala' iya'a nitana na dulang ka' nirookon na wiwine laandue' iya'a. Wiwine laandue' iya'a nongorookonmo takala' iya'a na sinana. ");
INSERT INTO blzNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Murit ni Yohanes nongorongor lele koiya'a, ia rae'imo i raaya'a ka' nidolo' a biibii ni Yohanes, ka' nitanom. ");
INSERT INTO blzNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Poposuu' ni Yesus iya'a nomule'konmo soosoodo ka' nopooruru' tii Yesus. Raaya'a nambantilkonmo ni Yesus giigii' upa men ia wawaumo i raaya'a, ka' men ia pisiso'kon i raaya'a na mian. ");
INSERT INTO blzNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Biai' tuu' a mian taka tia mae', tamban i raaya'a sianmo minsida kumaan. Mbaka' taeni Yesus na murit-Na, “Mai, kita rae' na dodongoan men sianta mianna men somo kita-kitana kada' sida mintimale kodi-kodi'.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Raaya'a nolumakitmo na duangan ka' nomae' na tampat men oloa na mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kasee biai' a mian men nimiile' i raaya'a nomae' ka' ia inti'i mian uga' a nomae'anna. Mbaka' mian na giigii' kota na dodongoan iya'a notumetende'mo, nongolukoni i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sarataa i Yesus nalau na duangan ka' nimiile' mian biai' iya'a, Ia nolingu'mo, gause i raaya'a somo koi domba men sianta mian nontondong. Mbaka' Ia nimisiso'konmo biai' upa na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Maamaalommo, murit ni Yesus nuntuu'imo i Ia ka' norobu taena, “Koini'i boomo malom, ka' dodongoan kani'i oloa mian. ");
INSERT INTO blzNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mbulo posuu' a mian karaani'i bi rae' kada' minsida mingili kakaan na libutan tia kampung men kara-karaani' ka'ita.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kasee ia simbati i Yesus tae-Na, “Kuusi a mantarai i raaya'a kakaan.” Taena i raaya'a, “Ansee, kada' kaimo a mingili kakaan bona mian biai'? Sabole tiodaa mamaraluukon doi' koi rua' atu doi' dinar.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ia pikirawar i Yesus na ko'ona i raaya'a, tae-Na, “Piile' kutung. Too pipii a roti men isian na ko'omuu?” Ia piile' i raaya'a, taena, “Isian roti lilima' ka' susum rurua'.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kasi i Yesus nomosuu' giigii' mian iya'a morimpung umoruang na rakut malalas. ");
INSERT INTO blzNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Raaya'a no'umoruangmo pore-pore sarimpung-sarimpung. Isian men sa'atu mian a sarimpung, isian uga' men limampulo' mian a sarimpung. ");
INSERT INTO blzNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Noko daa iya'a, ia alamo i Yesus a roti men lilima' ka' susum men rurua' iya'a, ka' nolumelengea' waara'a langit nobasukuur na Alaata'ala. Noko daa koiya'a Ia rumpi-rumpikmo a roti iya'a, kasi Ia rookon na murit-Na kada' bo obo-oboskonon na mian biai' iya'a. Ka' susum men rurua' iya'a uga' ni'obo-oboskonmo na ko'ona i raaya'a wiwi'na. ");
INSERT INTO blzNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Raaya'a wiwi'na nobenteng nangkaan. ");
INSERT INTO blzNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ka' labina roti tia susum men nikaan iya'a ia ruru' murit ni Yesus, dauga' nobuke' sampulo' rua' basung. ");
INSERT INTO blzNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mian moro'one men nangkaan roti iya'a isian lima' loloon mian. ");
INSERT INTO blzNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Noko daa koiya'a, liuliu Ia posuu' i Yesus a murit-Na mae' baduangan mongolukoni i Ia na Betsaida na sambotakna danau. Kasi mian men biai' iya'a Ia posuu'mo mule'kon. ");
INSERT INTO blzNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sarataa mian biai' nomae', Yesus nomae' na buu'na ka' nosambayang. ");
INSERT INTO blzNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na tanga'namo danau a duanganna murit-Na, ilio nomalommo. Kasee i Yesus dauga'na na katano'an. ");
INSERT INTO blzNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ia toa'i i Yesus i raaya'a se' marepa tuu' a mombose duanganna gause mombuulon ra'amari na aropna duangan. Mbaka' toro jaam tiga karani' ilio, ai Yesus notakamo na ko'ona i raaya'a tumpa-tumpang na wawona weer, koikoi se' mingkira' mingiliukon i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sarataa i raaya'a nimiile' se' i Yesus notumumpang na wawona weer, mbaka' i raaya'a nangkakaro'mo nolayaon, gause pansaruina i raaya'a se' santuo'. ");
INSERT INTO blzNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wiwi' irana notongkodi' tuu' nimiile' i Ia. Kasee i Yesus liuliu norobu na ko'ona i raaya'a, tae-Na, “Porampot a noamuu! Yaku' ini'i. Alia layaon.” ");
INSERT INTO blzNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sarataa i Yesus nasawe' na duanganna i raaya'a, mombuul norokotmo. Raaya'a samba' tuu', ");
INSERT INTO blzNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","gause i raaya'a sianpo ninginti'i upa men nosida na roti lilima' men kosamba' iya'a. Ka' noana i raaya'a dauga' bingilan. ");
INSERT INTO blzNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sarataa nolumembet na sambotakna danau, raaya'a nobalabumo na Genesaret. ");
INSERT INTO blzNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nalaumo i raaya'a na duangan, liuliu ia inti'i mian biai' se' isian i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mbaka' i raaya'a notumetende'mo longkop dodongoan iya'a, kasi i raaya'a nangawawa ni Yesus giigii' mian men manggeo ni'uer tia ampa-ampasna. Ka' rongoronna i raaya'a se' i Yesus na dodongoanmo sa'angu'an, raaya'a mangawawamo mian men manggeo iya'a waatu'u. ");
INSERT INTO blzNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mau mbaria kotakaan ni Yesus, mau na kampung, mau na kota kabai se' na libutan, na dodongoan inono' mian men manggeo pokelaionna i raaya'a na pasar. Ka' pa'ase'onna i raaya'a kada' daa mian men manggeo iya'a patalaion mongkoyong juba ni Yesus, mau tongko' puusna. Wiwi'na men nongkoyongmo sida nalesi'. ");
INSERT INTO blzNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mian Farisi tia wawa ukum Torat toropii ira men na Yerusalem a dodongoanna notaka ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Raaya'a nimiile' murit ni Yesus toropii ira nokumaan see sian ningoso' men koi pisiso'na agamana. ");
INSERT INTO blzNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gause mian Farisi koikoimo tia samba Yahudi men sambana mongololoikon tuu' adat tia wawauna minti'ina i raaya'a. Raaya'a sian kumaan kalu sianpo ningoso' koi men ia pisiso'kon minti'ina i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ka' mule'kon na pasar i raaya'a sian kumaan kalu sianpo noloop. Ka' dauga'na biai' a aturan sambanaan na minti'ina i raaya'a men loloikononna tuu', koimo na aturan mongoso'i galaas, mangko', ka' pakakas men kulaluk. ");
INSERT INTO blzNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Koiya'a mba'a mbali' mian Farisi tia wawa ukum Torat nimikirawar ni Yesus, taena, “Nongko'upa a murit-Muu se' sian mongololoikon adatna pulinta? Nongko'upa i raaya'a se' kumaan see sian mingoso'?” ");
INSERT INTO blzNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ia simbati i Yesus tae-Na, “Kuu karaani'i uga' se' minti pate-patete! Tuutuu' a men ia tulis i Nabii Yesaya muntundun i kuu, taena, ‘Mian karaani'i muntunde' i Yaku' tongko' na wewerna, see noana i raaya'a oloa na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sianta kana'na i raaya'a monsoosa' i Yaku', gause aturanna mian a pisiso'kononna koikoi se' aturan iya'a a aturan-Ku.’ ");
INSERT INTO blzNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Posuu'na Alaata'ala kauri'kononmuu kasee aturan na mian a men moonggor a pingintonimuu.” ");
INSERT INTO blzNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kasi i Yesus norobu soosoodo, tae-Na, “Kuu minsida tuu' mongoloakon posuu'na Alaata'ala kada' daa pokoonmuu a mamakapoonggor adatmuu! ");
INSERT INTO blzNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Koi kani'imari a posuu' ni Musa, taena, ‘Angga'i a tama tia sinamuu!’ Ka', taena, ‘Ai ime a men mantadeankon tamana kabai se' sinana tiodaa pate a ukumanna.’ ");
INSERT INTO blzNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kasee ko'omuu koi kani'imari a pisiso'muu, taemuu, ‘Kalu mian nomorobui minti'ina, taena, “Giigii' upa men tio bo rookononku na ko'omuu mase Kurban. Yaku' poko kurbaankonmo na Alaata'ala.” ’ ");
INSERT INTO blzNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mbaka' mian iya'a sian patalaionmuu mongololoikon wawauna mangalawei tama tia sinana. ");
INSERT INTO blzNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mbaka' tia pisiso'muu susuung men kuu pisiso'kon mian, kuu sianmo mongololo' wurungna Alaata'ala. Ka' dauga'na biai' a upa men koiya'a wawauonmuu.” ");
INSERT INTO blzNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kasi i Yesus nengeleelo' soosoodo mian biai' iya'a ka' norobu tae-Na, “Porongori pore-pore kada' inti'ionmuu. ");
INSERT INTO blzNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sianta upa men na liwa ka' minsoop na wakana mian sida mengerere wakana, kasee ka' upa a men na lalom ka' umuar, nono' a men mengerere wakana.  ");
INSERT INTO blzNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ka' men daa tilingaan, porongori.” ");
INSERT INTO blzNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus namarereimo mian biai' iya'a, ka' ninsoop na laigan. Murit-Na nimikirawarmo na Ko'ona, se' upa a patukna timbaani' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ia simbati i Yesus tae-Na, “Sia-sianapo uga' minginti'i i kuu? Koo'po kuu inti'i se' upa men na liwa ka' minsoop na wakana mian sian mengerere i ia? ");
INSERT INTO blzNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Gause men minsoop na lalom inono' sian minsoop na noa, kasee minsoop na kompong ka' uarkonon soosoodo.” Wurung ni Yesus iya'a mambantilkon se' wiwi'na kakaan sida kaanon. ");
INSERT INTO blzNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesus norobu soosoodo, tae-Na, “Men umuar na nganga'na mian, nono' a men mengerere i ia. ");
INSERT INTO blzNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gause na lalomna waka, na noa a nimpu'uanna giigii' pikiran men ba'idek. Pikiran koiya'a a men manggau'kon mian mogora', mamangan, mampapatei mian, ");
INSERT INTO blzNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","muntumpangkon samba-samba, mongko'uusi upana mian, mangawawau men ba'idek, umakal, mongololoikon po'uusna noa, masindir, momotaekon, lambak, bolongoli. ");
INSERT INTO blzNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wiwi'na men ba'idek iya'a na noa a nimpu'uanna, ka' iya'a a men mangawawau mian sida marere na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Noko daa koiya'a, ai Yesus namarereimo dodongoan iya'a ka' nomae' na libutan men karani' na kota Tirus. Ia ninsoopmo na sa'angu' laigan see Ia bude' inti'ionna mian se' isian ndo'o. Kasee tataka-Na sian kawunianna. ");
INSERT INTO blzNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Isian sa'angu' wiwine men anakna lampingionna meena. Ia nongorongor se' isian i Yesus. Wiwine iya'a notakamo ka' nobanintuur na arop ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ia nama'ase' kada' i Yesus mumbuse'i meena men nangalampingi anakna. Wiwine iya'a samba Yunani, lipu' Fenisia na Siria. ");
INSERT INTO blzNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesus norobu na ko'ona, tae-Na, “Anak a olukon pakaanon bi benteng. Sianta kana' a mangala kakaanna anak morio' ka' mintibarkon bona au'.” ");
INSERT INTO blzNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ia simbati wiwine iya'a taena, “Indo' Tumpu, kasee au'po na intuna meja'po mangkaan puputna kakaan men tuongonna anak.” ");
INSERT INTO blzNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesus norobu na ko'ona, tae-Na, “Kalu koi nooro'o a taeem, ule'kon i koo. Meena men nangalampingi anaak, no'umuarmo.” ");
INSERT INTO blzNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wiwine iya'a nomule'konmo. Ia takai na laigan, anakna toko-tokol na tokolan, ka' meena iya'a tuutuu' uga' no'umuarmo. ");
INSERT INTO blzNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Noko daa iya'a ai Yesus namarereimo dodongoanna lipu' Tirus, ka' ningimputkon rae'an-Na lumiu na Sidon mae' na Danau Galilea. Ia sumalan lumiu na libutan Dekapolis. ");
INSERT INTO blzNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tongko' indo'o, isian mian nangawawa na Ko'ona sa'angu' mian men umu' ka' mabongol. Raaya'a nama'ase' kada' i Yesus mengepetkon limana na mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus nangawawamo mian iya'a ka' daa somo raaraaya'ana, kasi Ia soopkon a rangkum-Na na tilingana mian iya'a rua-ruambotakna. Kasi Yesus no'uminor ka' numurusi sila'na mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Noko daa koiya'a, ai Yesus nolumelengea'mo waara'a na langit ka' ninoa booboolak kasi norobu na mian iya'a, tae-Na, “Epata,” men aratina, bi koloaian. ");
INSERT INTO blzNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tilingana mian iya'a nopoorongormo ka' sila'na nolundengmo soosoodo ka' ninsidamo morobu men manasa. ");
INSERT INTO blzNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesus nomotoo mian men isian iraando'o kada' alia muntundun wawau iya'a na mian sambana. Mau koiya'a i Yesus nongkokundakon mian muntundun, kasee i raaya'a tongko' kaekae' ka' dodoa montolele'kon wawau iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wiwi'na mian men nongorongor iya'a nosamba' tuu'. Raaya'a norobu taena, “Wiwi'na ia wawau, pore. Mian mabongol ia wawau sida nopoorongor, ka' mian umu', sida norobu.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sa'angu'mo tempo isian soosoodo mian biai' nobarimpung, kasee i raaya'a sianta kakaanna. Mbaka' ia leelo'mo i Yesus a murit-Na ka' norobu tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Molingu' tuu' i Yaku' na mian biai' karaani'i. Tolungiliomo i raaya'a kamba'a tii Yaku', kasee sianta kakaanan. ");
INSERT INTO blzNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ka' kalu posuu'on-Ku i raaya'a mule'kon tilolu, mbaka' i raaya'a sabole poso' na tanga'na salan. Daa isian men ringkat na ko'oloaan.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ia simbati murit-Na, taena, “Tampat kani'i oloa na mian. Koi upa a bo pantausian kakaan na tampat kani'i men oloa na mian bo pamakaanta mian karaani'i?” ");
INSERT INTO blzNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ia pikirawar i Yesus tae-Na, “Pipii a roti men isian na ko'omuu?” Taena, “Pipitu'.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mbaka' ia posuu'mo i Yesus a mian biai' iya'a umoruang na tano'. Kasi Ia ala a roti pipitu' iya'a ka' nobasukuur na Alaata'ala. Noko daa koiya'a, Ia rumpi-rumpikmo, kasi nirookon na murit-Na kada' obo-oboskononna i raaya'a na mian biai'. Murit-Na uga' nongololoikonmo koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mian biai' iya'a isian uga' men nangawawa susum morio' toropii. Yesus nunsukuurkon susum iya'a na Alaata'ala, kasi Ia posuu' a murit-Na mongobo-oboskon. ");
INSERT INTO blzNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wiwi'na mian benteng nokumaan. Lapas nokumaan, raaya'a ningirimpungmo labina kakaan iya'a. Labina iya'a dauga' nobuke' pitu' basung. ");
INSERT INTO blzNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Raaya'a isian toro paat loloon a kobiai'na. Kasi ia posuu' i Yesus i raaya'a mule'kon. ");
INSERT INTO blzNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ka' i Yesus tia murit-Na liuliu nolumakit na duangan ka' notarabut paraas libutan Dalmanuta. ");
INSERT INTO blzNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Taka a mian Farisi toro pii ira ni Yesus mae' nopoogagai tii Ia. Raaya'a mingkira' mimitopongi i Yesus. Raaya'a nama'ase' kada' daa i Yesus mangawawau upa kosamba' bookoi oos se' i Ia notaka nda'ara'amari na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mbaka' i Yesus nasiongo'mo, tae-Na, “Upa inta a mian men tumuo' na tempo koini'i se' mama'ase' kada' i Yaku' mangawawau upa kosamba'? Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' bona mian tempo koini'i, Yaku' sian mangawawau sa'angu'po upa kosamba'.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ia parereimo i Yesus i raaya'a, kasi Ia nolumakit na duangan ka' nomae' na sambotakna danau iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Murit ni Yesus nolimbo' nangawawa roti. Raaya'a tongko' sa'angu' a men isian na ko'ona i raaya'a na duangan. ");
INSERT INTO blzNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus nambantili i raaya'a tae-Na, “Pore-pore ka' maka'amat i kuu na ragina mian Farisi tia ragi ni Herodes.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Raaya'a nopootunduniimo, taena, “Mbali' koiya'a a wurung-Na gause i kita sian nangawawa roti.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus ninginti'i upa men pootunduniikononna i raaya'a. Mbaka' tae-Na, “Nongko'upa i kuu se' momootunduniikon sianta roti? Sia-siannapo nopoo'inti'i ka' ninginti'i i kuu? Mokudul tuu' a noamuu. ");
INSERT INTO blzNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kuu mataan, nongko'upa se' sian poopiile'? Kuu tilingaan, nongko'upa se' sian poorongor? Sianmo kuu oos ");
INSERT INTO blzNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","a roti lilima' men Yaku' rumpi-rumpik bona mian lima' loloon? Pipii basung a nobuke' labina kakaan men kuu ruru'?” Ia simbati i raaya'a, taena, “Sampulo'rua' basung.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ia pikirawar i Yesus soosoodo, tae-Na, “Ka' koi upa a pipitu' roti men bona paat loloon mian? Pipii basung a labina kakaan men kuu rimpung?” Taena i raaya'a, “Pitu' basung.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kasi taeni Yesus, “Sia-siannapo kuu inti'i?” ");
INSERT INTO blzNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Noko daa koiya'a, ai Yesus tia murit-Na notakamo na Betsaida. Na Betsaida isian mian nangawawa sa'angu' mian mampisok ni Yesus, ka' nama'ase' na ko'ona kada' daa koyongon-Na ka' lesi'ion. ");
INSERT INTO blzNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mbaka' ia intonimo i Yesus a limana mian men mampisok ka' nibibit mae' na liwana kampung. Kasi ia inori i Yesus a matana mian iya'a, ka' nikoyong, kasi Ia pikirawari, tae-Na, “Piile'oonmo a upa-upa?” ");
INSERT INTO blzNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mian iya'a nontoa'imo waatu'u ka' norobu taena, “Indo'. Yaku' nimiile' mian pototumpang, see tongko' koi kau piile'onku.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ia koyong i Yesus soosoodo a matana mian iya'a. Noko daa iya'a, mian men mampisok iya'a nopoopiile'mo tuu'. Ia nalesi'mo ka' wiwi'na manasamo piile'onna. ");
INSERT INTO blzNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesus norobu na ko'ona soosoodo, tae-Na, “Ule'kon na laigaan, ka' alia motanga' kampung.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Noko daa koiya'a, Yesus tia murit-Na nomae'mo na kampung men na libutan Kaisarea Filipi. Na tanga'namo salan, ai Yesus nimikirawarimo murit-Na, tae-Na, “Koi taena mian, ime mbali' i Yaku' kani'i?” ");
INSERT INTO blzNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ia simbati murit-Na, taena, “Isian men mangaan ai Yohanes Pansarani. Men sambana mangaan a i Elia. Ka' men sambana soosoodo mangaan sa'angu' mian na giigii' nabii.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ia pikirawar i Yesus soosoodo, tae-Na, “Kasee ka' na ko'omuu, ai ime i Yaku' kani'i?” Ia simbati i Petrus, taena, “Kuu a Tomundo' Pansalamatkon.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kasi i Yesus nomotoo i raaya'a kada' alia mambantilkon mau ni imepo se' i ime i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Noko daa koiya'a, ai Yesus nuntumbeimo nimisiso' murit-Na se' Anak Manusia tio munsuri repaan biai' ka' kokundaionna motu-motu'a, tanaasna imam ka' wawa ukum Torat. Ia bo papateion, kasee na ilio kotolu'na, Ia bo tumuo' soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Koiya'a a kanasana i Yesus nuntundunkon iya'a na murit-Na. Kasee i Petrus nangawawa i Yesus waale'e na soripi'na ka' nongkomaso'i. ");
INSERT INTO blzNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesus ningilinga ka' nangarop murit-Na, kasi nongkomaso'i i Petrus, tae-Na, “Kumbaale'ena i koo, Ibiliis! Pinginti'iim kanono' pinginti'ina mian, taasi' pinginti'na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Noko daa koiya'a, Ia leelo'mo i Yesus a murit-Na tia mian biai' men isian iraando'o, kasi norobu i Ia, tae-Na, “Mian men mingkira' mongololo' i Yaku' tiodaa mongkolimbo'kon pingkira'na noana kasi mamasa'an saliipna ka' mongololo' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gause mian men mampari-pari mansalamatkon wakana na dunia kani'i, ia sian mantausi tutuo' men pore. Kasee mian men mongorookon wakana bo Ingku' tia bona Lele Pore men ringkat na Alaata'ala, ia bo mantausi tutuo' men pore. ");
INSERT INTO blzNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aupa mbali' a ee'na men takakononna mian mau ia montombonoi longkop tano' balaki' kasee komburi'na sian mantausi tutuo' men pore? ");
INSERT INTO blzNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sianta upa men umangga' men sida pombolosi tutuo' men pore iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kalu isian mian men makamaa' mompotuutuu' i Yaku' tia pisiso'-Ku na mian biai' men sian malolo' ka' dosaon, Anak Manusia uga' bo makamaa' mompotuutuu' mian iya'a na tempo Ia taka tia kuasana Tama-Na ka' lolo'onna malaa'ikat men molinas.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Taeni Yesus, “Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' isian i kuu men daa mokaraani'i men sianpo lapus kalu koo'po mimiile' Batomundo'anna Alaata'ala taka tia kuasa-Na.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Koi noommo ilio a noporusanna, ai Yesus nangawawamo i Petrus tii Yakobus ka' i Yohanes nasawe' na buu'na sa'angu' men alayo'. Sianta mian sambana indo'o. Kasi dudus ni Yesus nokoboliian na aropna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Juba-Na nosidamo bubulak laangan. Sianta sa'angu' mian na tano' balaki' kani'i a men mamaka'ala mantatapi koiya'a a kobulakna. ");
INSERT INTO blzNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kasi totolu' murit-Na nimiile' i Elia tii Musa men pintanga' batundun tii Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mbaka' taeni Petrus na ko'ona i Yesus, “Guru, ma'amat tuu' i kita isian na tampat kani'i. Mbulo i kai momokerer sa'up totolu', sa'angu' bo Ko'omuu, sa'angu' boni Musa, ka' sa'angu' soosoodo boni Elia.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ai Petrus nobatundun koiya'a gause ia tia samba-sambana rurua' nolayaonmo tuu', mbali' sianmo ia inti'i se' upa men bo tundunonna. ");
INSERT INTO blzNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Noko daa koiya'a, ia sa'upimo antong i raaya'a, ka' na antong iya'a, ia rongor i raaya'a isian wurung, tae-Na, “Ni'imo a Anak-Ku men kolingu'-Ku. Porongori i Ia!” ");
INSERT INTO blzNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tongko' sangkodi', tempo i raaya'a nengelealokon na tiku-tikumna, raaya'a sian nimiile' sa'angu'po mian, somo i Yesus suungna indo'o. ");
INSERT INTO blzNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tempona i raaya'a notumokuru na buu'na iya'a, Yesus nomotoomo i raaya'a tae-Na, “Alia montoobantilkonkuu ni imepo aupa men kuu piile' umba'a kalu Anak Manusia sianpo potuo'ion moko daa lapus.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Potoo iya'a ia tontoni i raaya'a. Kasee raaraaya'ana, raaya'a momootunduniikon se' upa a panduung ni Yesus mangaan “tumuo' soosoodo moko daa lapus”. ");
INSERT INTO blzNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ia pikirawar i raaya'a ni Yesus, taena, “Nongko'upa a wawa ukum Torat nuntundun se' i Elia tio taka olukon koo'po tia kotakaan-Na Tomundo' Pansalamatkon?” ");
INSERT INTO blzNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ia simbati i Yesus tae-Na, “Ai Elia tuutuu' taka olukon, kada' giigii' upa bi toropot. Kasee koi upa a Anak Manusia? Nongko'upa se' na Alkitaap nitulis se' i Ia bo munsuri repaan ka' idekionna mian? ");
INSERT INTO blzNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kasee bantilkonon-Ku na ko'omuu se' i Elia noko takamo, ka' mian biai' nangawawaukon i Ia koi pingkira'na i raaya'a. Ya'a kana'mo tia men nitulis na Alkitaap men muntundun waka-Na.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tempona i Yesus tia murit-Na totolu' raando'omo tia murit-Na men sambana, ia piile' i raaya'a biai' a mian ningiriwuti iraando'o. Isian toro pii wawa ukum Torat pintanga' poogagai tia murit ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sarataa ia toopiile' mian se' isian i Yesus, raaya'a samba' tuu'. Liuliu notumetende' mae' nangalaboti i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus nimikirawar na murit-Na, tae-Na, “Upa iraando'o men poogagaikononmuu tia wawa ukum Torat?” ");
INSERT INTO blzNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na tanga'na mian biai' iya'a, sa'angu' a mian men ninsimbati, taena, “Guru, yaku' nangawawa anakku na Ko'omuu. Anakku iya'a ia popo'umu' meena. ");
INSERT INTO blzNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sarataa takaionnamo, mbaka' wawauonna meena iya'a kada' anakku mangkairimpa' na tano', nganga'na wura'on, wese'na mokoroit, ka' wakana sida moroson. Yaku' niki tulungmo na murit-Muu kada' mumbuse'ikon meena iya'a, kasee sian ia poko i raaya'a nibuse'i.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus norobu na ko'ona i raaya'a, tae-Na, “Alia uga' i kuu mian men tumuo' na tempo koini'i! Kuu tuutuu' mian men sian parasaya. Pataka ipi mbali' Yaku' tio dumodongo tii kuu? Pataka ipi mbali' i Yaku' tio mokotaan na upa men wawauonmuu? Wawa a anak kanono' le'emari.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Anak iya'a ia wawakonmo i raaya'a ni Yesus. Tongko' ia toopiile' meena iya'a i Yesus, ia rosonkonmo meena a wakana anak iya'a, liuliu tinombabas, kasi tinongkolinda' na tano'. Nganga'na wura'on. ");
INSERT INTO blzNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ia pikirawar i Yesus na tamana anak iya'a, tae-Na, “Koi upamo a nau'na i ia nokoi kaya'a?” Ia simbati tamana, taena, “Dauga'napo itiu' i ia. ");
INSERT INTO blzNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Isianmo piripii a meena mongko'uusi mampapatei i ia. Isian men ia babaskon na apu, ka' isian men na weer. Kasee kalu pokoon-Muu tulungon, kolingu'i i kai, alinta, ka' tulung i kai.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ia simbati i Yesus tae-Na, “Upa a taeem umba'a, kalu pokoon-Muu? Wiwi'na upa-upa pokoon asar mian parasaya.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tamana anak iya'a liuliu nangkakaro', taena, “Yaku' parasaya! Tulung i yaku' kada' i yaku' parasaya tuutuu'.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ia piile' i Yesus se' kaekae' biai' a mian taka moruuruut, mbaka' Ia nengerengeaki meena iya'a, tae-Na, “Hee, koo meena men nombongoli tia nompopo'umu'! Uar na anak kanono', ka' aliamomo' mungule'i soosoodo i ia.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Meena iya'a nangkakaro' ka' nompoporoson tia nunggugurkon wakana anak iya'a, kasi no'umuar. Anak iya'a somo koi mian lapus piile'on, tamban mian biai' norobu taena, “Daamo, lapusmo ile'e i ia.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kasee i Yesus ningintoni limana anak iya'a ka' nangawangonkon. Anak iya'a uga' nokumekerermo. ");
INSERT INTO blzNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na laiganmo i Yesus, notakamo a murit-Na men raaraaya'ana, ka' nimikirawar na Ko'ona, taena, “Nongko'upa i kai se' sian nomoko numbuse'i meena iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ia simbati i Yesus tae-Na, “Meena men koi umba'a sian pokoon buse'ion, tongko' sambayang a men sida pumbuse'i. Sian sida tia upa sambana.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ai Yesus tia murit-Na nomae'mo namarerei dodongoan iya'a ka' ningimputkon rae'anna i raaya'a, lumiu na lipu'na Galilea. Ai Yesus bude' inti'ionna mian se' aana i Ia, ");
INSERT INTO blzNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","gause i Ia pintanga' mimisiso' murit-Na tae-Na, “Anak Manusia bo rookonon na kuasanana mian, ka' Ia bo papateionna i raaya'a. Kasee ka' papateion, Ia bo tumuo' soosoodo na ilio kotolu'na.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Murit ni Yesus sian ninginti'i upa men Ia wurungkon, kasee i raaya'a babata mimikirawar na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ari Yesus notakamo na Kapernaum. Ndo'omo na laigan Ia pikirawarimo i Yesus a murit-Na, tae-Na, “Upa a men poogagaikononmuu umba'a na tanga'na salan?” ");
INSERT INTO blzNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Raaya'a sian ninsimbati gause umba'a na tanga'na salan, raaya'a nopoogagaikon munsurung se' ime a men balaki'na i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ai Yesus no'umoruangmo, kasi Ia leelo' a murit-Na sompu-sompulo' rua' irana iya'a, ka' norobu tae-Na, “Ime i kuu men mingkira' sida balaki'na, ia tiodaa sida koi morio'na, po'ata'onna mian biai'.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Noko daa iya'a, ia ala i Yesus a anak morio' sa'angu' kasi Ia pokerer na tanga'na i raaya'a wiwi'na. Kasi Ia taawan i Yesus a anak iya'a, ka' norobu na murit-Na, tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ime a men mangalaboti sa'angu' anak koi kani'i gause mian iya'a mongololo' pisiso'-Ku, nono' a men ngaanon mangalaboti i Yaku'. Ka' ime a men mangalaboti i Yaku', ia taasi' tongko' mangalaboti i Yaku', kasee mangalaboti uga' i Ia men nomosuu' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kasi i Yohanes nobatundun ni Yesus taena, “Guru! Kai nimiile' sa'angu' mian numbuse'i meena see mangaan ngaan-Muu a numbuse'ina, mbaka' kai kokundakonmo i ia gause i ia taasi' tii kita.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kasee i Yesus norobu tae-Na, “Alia i kuu mongkokundakon i ia, gause sianta sa'angu' mian a men mangawawau upa kosamba' mangaan ngaan-Ku liuliu sida mingidek i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mian men sian mangka'idek i kita, nono' aratina umapak na ko'onta. ");
INSERT INTO blzNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' mian men mimi'inumi i kuu, montoodaa i kuu lolo' ni Kristus, ia sabole-bole mantausi tambona.” ");
INSERT INTO blzNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ime a men manggau'kon sa'angu' anak morio' karaani'i men parasaya na Ingku' sida baradosa, mbulokon mian iya'a kootiion watu pinggiling na toure'na ka' tuongon na tobui. ");
INSERT INTO blzNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Too limamuu a manggau'kon i kuu baradosa, kolongi a limamuu inono'. Mbulokon limamuu somo sambotak kasee daa tumuo' tia Alaata'ala pookokoikonon tia limamuu sampa kasee i kuu tibarkonon na naraka, na apu men sian kopate-pateanna.  ");
INSERT INTO blzNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Apuna naraka iya'a sianta pate ka' ule morio' uga' sianta pate na apu iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Too saratmuu a manggau'kon i kuu baradosa, kolongi a saratmuu inono'. Mbulokon saratmuu somo sambotak kasee daa tumuo' tia Alaata'ala pookokoikonon tia saratmuu sampa kasee i kuu tibarkonon na naraka.  ");
INSERT INTO blzNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Apuna naraka iya'a sianta pate ka' ule morio' uga' sianta pate na apu iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Too matamuu a manggau'kon i kuu baradosa, kuati a matamuu inono'. Mbulokon matamuu somo sambotak kasee daa tumuo' tia Alaata'ala pookokoikonon tia matamuu sampa kasee i kuu tibarkonon na naraka. ");
INSERT INTO blzNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Apuna naraka iya'a sianta pate ka' ule morio' uga' sianta pate na apu iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wiwi'na mian bo molinasion tia apu, koikoimo upa men bo koyo'konon bona Tumpu molinasion tia timuson. ");
INSERT INTO blzNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Timuson mase pore, kasee ka' natawas i ia, sianmo sidaon wawauon bi potee'. Mbali' iya'a, kuu tio bi sida koi timuson. Tumuo' pooka'amat tia simbaya'muu.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Inda'a ai Yesus norumingkatmo mae' na libutan Yudea ka' na libutan na sambotakna Weerkauna Yordan. Indo'o uga' biai' a mian notaka ningiriwuti i Ia, ka' i Ia taka mimisiso' i raaya'a koi men dele wawauon-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mbaka' notakamo a toropii mian Farisi mimitopongi i Yesus. Raaya'a bapikirawar na Ko'ona, taena, “Koi upa pinginti'i-Muu? Too poturangon a moro'one men boroki'an mengerensai boroki'na?” ");
INSERT INTO blzNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kasee Ia simbati i Yesus tae-Na, “Koi upa a pisiso ni Musa bo ko'omuu?” ");
INSERT INTO blzNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Taena, “Ai Musa namatalai mian mengerensai boroki'na kalu muntulis surat poorensaanna suo' bona boroki'na.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Taeni Yesus, “Mbali' i Musa nuntulis pisiso iya'a bo ko'omuu gause i kuu bingilan. ");
INSERT INTO blzNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kasee na tumbe-tumbepo, tempona Alaata'ala ninsidakon mian, ‘Alaata'ala ninsidakon i raaya'a moro'one tia wiwine. ");
INSERT INTO blzNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mbali' iya'a, moro'one bo mamarerei tamana tia sinana ka' mosa'angu' tia boroki'na, ");
INSERT INTO blzNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mbaka' rua' mian iya'a nosidamo koi sa'angu' waka. Mbaka' moro'one tia boroki'na taasi'mo rurua' kasee sa'angu'.’ ");
INSERT INTO blzNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mbali' iya'a, upa men ia posa'angu'mo Alaata'ala sian sida rensaonna mian.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tongko' na lalomnamo laigan, murit ni Yesus nobapikarawarmo soosoodo upa men ia poosisimbatkon toropii mian Farisi tii Yesus koi umba'ana. ");
INSERT INTO blzNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mbaka' taeni Yesus, “Ime a mengerensai boroki'na ka' mosuo' tia wiwine sambana, ai ia kanono' muntumpangkon boroki'na. ");
INSERT INTO blzNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mau wiwine a men mengerensai langkai'na ka' mosuo' tia moro'one sambana, wiwine iya'a uga' muntumpangkon langkai'na.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Isian mian nangawawa anak morio' mbaale'e ni Yesus kada' daa i Yesus mongkoyong ka' mambarakaati anakna i raaya'a. Kasee murit ni Yesus tongko' nongkomaso'i mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kasee Ia piile' i Yesus se' koiya'a, Ia pinsala'imo, tae-Na, “Patalai a anak karaanono' taka na Ingku'! Alia mantaankon i raaya'a, gause mian men koi anak karaani'i a men bo mianna Batomundo'anna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' mian men sian mangalabot Batomundo'anna Alaata'ala koi pangalabotna anak morio', ai ia sian minsoop na Batomundo'an iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Noko daa i Yesus nangaan koiya'a, Ia nongorootmo anak morio', kasi Ia epetkon lima-Na na anak morio' iya'a ka' nambarakaati. ");
INSERT INTO blzNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tempo i Yesus rumingkat mingimputkon rae'an-Na taka a sa'angu' mian tende-tende' mbaale'e na Ko'ona kasi nobanintuur na arop ni Yesus. Ia nobapikirawar, taena, “Guru men pore! Upa a men tiodaa wawauonku kada' i yaku' mantausi tutuo' men pore pataka sidutu?” ");
INSERT INTO blzNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ia simbati i Yesus tae-Na, “Nongko'upa i koo se' mangaan i Yaku' pore? Sianta men pore saliwana Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ai koo ninginti'imo potoona Alaata'ala: ‘Alia mampapatei mian, alia muntumpangkon samba-samba, alia mamangan, alia momborekkon mian, alia mangakali mian, ka' angga'i a tamaam tia sinaam.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Taena mian iya'a, “Guru, giigii' potoo iya'a yaku' poko loloikonmo tempopo i yaku' nopoo'inti'imo.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus nintioki mian iya'a ka' nolingu', kasi i Ia norubu, tae-Na, “Dauga' sangkaliangan a men koo'po koo wawau. Rae' ka' balukkon a giigii' upaam ka' rookon a doi'na bona mian talalais. Kalu koiya'a, koo bo mokosue kupang na surugaa. Moko daa kasi taka mongololo' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nongorongor i Yesus nangaan koiya'a, mian iya'a liuliu kinoboliian a dudusna. Ia nomae'mo kasee masiongo' tuu' a noana gause i ia biai' a kupangna. ");
INSERT INTO blzNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kasi i Yesus nengelealokon murit-Na ka' nambantilkon na ko'ona i raaya'a, tae-Na, “Marepa tuu' a mian kupangon minsida mianna Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Murit ni Yesus samba' nongorongor upa men Ia tundun i Yesus. Kasee Ia imputi i Yesus soosoodo a wurung-Na, tae-Na, “Anak-Ku, marepa tuu' mba'a minsida mianna Batomundo'anna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bagiakon sa'angu' unta minsoop na bolo'na pakaut a daana, tia sa'angu' mian kupangon minsida mianna Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Murit ni Yesus nosamba'mo tuu', ka' i raaya'a nopootunduniimo, taena, “Ka' koiya'a, ai ime ansee a men sida salamatkonon?” ");
INSERT INTO blzNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus nintiokimo i raaya'a kasi norobu tae-Na, “Manusia sian momoko mansalamatkon wakana, kasee taasi' koiya'a kalu Alaata'ala. Gause giigii' upa pokoonna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kasi taeni Petrus, “Piile! Kai namarereimo wiwi'na upamai ka' nongololo' i Kuu.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ia simbati i Yesus tae-Na, “Tuutuu' mba'a. Ka' bantilkonon-Ku na ko'omuu se' mian men mamarerei laiganna, kabai utusna moro'one, kabai utusna wiwine, kabai sinana, kabai tamana, kabai anakna, kabai se' ale'na gause mongololo' i Yaku' ka' gause mengelelekon Lele Pore men ringkat na Alaata'ala, ");
INSERT INTO blzNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mian kanono' koini'i uga' bo moko'ule' pirisa'atu paku' laigan, utus moro'one, utus wiwine, sina, anak tia ale' mau mune' pintanga' mongololongi repaan. Tempo ni'imarian mian iya'a bo mantausi tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kasee biai' a mian men tongaan tempo koini'i bo kosian tongaan tempo ni'imarian. Ka' uga' mian men tempo koini'i piile'onta sianta tongaan, bo tongaan tempo ni'imarian.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus tia murit-Na banta-bantang mae' na Yerusalem, ka' i Yesus na olukonna i raaya'a. Murit-Na samba' ka' layaon. Mau mian men mongololo' i Ia indoro'omari na komburi' uga' layaon. Ia angemo a sompulo' rua' murit-Na ka' Ia nuntumbeimo nambantilkon soosoodo na ko'ona i raaya'a upa men bo rumpakion-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tae-Na, “Koini'i kita banta-bantang mae' na Yerusalem ka' Anak Manusia bo rookonon na tanaasna imam tia wawa ukum Torat. Ka' i raaya'a bo mungukum Anak Manusia tia ukuman pate. Ka' i raaya'a bo mangkalaakon i Ia na mian men taasi' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ka' i Ia bo irokion, ka' inorion, sasalion ka' saliipkonon. Ka' moko daa iya'a, na ilio kotolu'na Ia bo tumuo' soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Noko daa iya'a ai Yakobus tii Yohanes, anak ni Zebedeus, nuntuu'i i Yesus ka' nobantil, taena, “Guru, kai mongooskon kada' i kuu mangalabot pore pa'ase'mai.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ia simbati i Yesus tae-Na, “Upa a ko'uusmuu men bo wawauon-Ku?” ");
INSERT INTO blzNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Taena i raaya'a, “Too daa sida, tarai i kai umoruang na batomundo'an-Muu ni'imarian. Men sa'angu' mian umoruang na paraas uanan-Muu, sa'angu' mian na paraas kauri'-Muu.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kasee Ia simbati i Yesus tae-Na, “Kuu sian minginti'i upa men pa'ase'onmuu. Se' daa pokoonmuu a minginum na inuman repaan men tiodaa bo inumon-Ku ka' mongololongi sa'angu' repaan men bo rumpakion-Ku?” ");
INSERT INTO blzNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ia simbati i raaya'a taena, “Daa, pokoonmai!” Mbaka' taeni Yesus, “Daa mba'a. Kuu bo minginum na inuman repaan men bo inumon-Ku, ka' bo mongololongi sa'angu' repaan men bo rumpakion-Ku. ");
INSERT INTO blzNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kasee ime a men bo umoruang na uanan-Ku kabai na kauri'-Ku, taasi' i Yaku' a men bo pinginti'i. Alaata'ala a men bo pinginti'i ime a men bo umoruang na oruangan iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nongorongor se' koiya'a, sompulo' murit ni Yesus nongkomaso'konmo i Yakobus tii Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kasee i Yesus nengeleelo'mo i raaya'a ka' norobu tae-Na, “Kuu poto'inti'i se' raaya'a men ngaanion pamarentana lipu' men sian minginti'i Alaata'ala mantalalais mianna. Ka' moomoola'na lipu' iya'a mamarenta mianna koi pingkira'na susuung. ");
INSERT INTO blzNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kasee i kuu amo' koiya'a. Kuu men mingkira' sida mian moola', kuu tio sida bo tutulungna mian, ");
INSERT INTO blzNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kuu men mingkira' tongaan na mian, kuu tio sida koi sa'angu' ata'na mian giigii'. ");
INSERT INTO blzNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gause Anak Manusia taka taasi' bo kalesangon. Ia taka mangkalesang ka' mongorookon noa-Na tia waka-Na papateion bo pontololoki dosana mian biai'.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus tia murit-Na notakamo na Yerikho. Tempo i Yesus tia murit-Na ka' mian biai' namarerei kota iya'a, isian sa'angu' mian talalais men mampisok poto'oruang na soripi'na salan ka' mo'ase'-ase' upana mian men lumiu. Ngaanna ai Bartimeus, anak ni Timeus. ");
INSERT INTO blzNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sarataa Ia rongor se' i Yesus men samba Nazaret a nolumiu, ia nangkakaro'mo taena, “Yesus, lee' ni Daud! Kolingu'konon i yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mian biai' iraando'o nongkokundakon i ia ka' nomosuu' kada' mimporokot. Kasee ia tongko' kaekae' boolak mangkakaro', taena, “Lee' ni Daud! Kolingu'konon i yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ai Yesus notaanmo kasi tae-Na, “Leelo' i ia.” Mbaka' ia leelo'mo i raaya'a a mian mampisok iya'a. Kasi taena i raaya'a, “Popotaan a noaam! Mai ringkat. Ai koo Ia leelo' i Yesus.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mian mampisok iya'a liuliu nungukati jubana ka' nambalo'kon, kasi norumingkat donga-dongan ka' nombaale'e ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Taeni Yesus na ko'ona, “Upa a men kikira'am wawauon-Ku na ko'oom?” Ia simbati mian mampisok iya'a, taena, “Guru, yaku' mingkira' bi poopiile'.” ");
INSERT INTO blzNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kasi Ia simbati i Yesus soosoodo, tae-Na, “Rae'mo. Gause i koo mamarasaya na Ingku', koo nopoopiile'mo!” Mian mampisok iya'a liuliu nopoopiile'. Kasi ia nongololo' i Yesus na rae'an-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sarataa i Yesus tia murit-Na montorumpakimo Yerusalem, karani'mo Betfage tia Betania men na Buu'na Zaitun, ai Yesus nomosuu'mo murit-Na rurua', ");
INSERT INTO blzNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ka' nomotoo tae-Na, “Rae' na kampung katu'u men torumpakionta. Taka intu'u kodi' i kuu bo liuliu mungurumpaki sa'angu' keledai rundara nitoongkon, men sianpo ia toolakiti mian. Alaka' kakai a kokootna ka' wawa tu'umari. ");
INSERT INTO blzNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka' too isian mian mimikirawar na ko'omuu taena, ‘Nongko'upa i kuu se' mangkakai kokootna keledai kanono'?’ bantilkon inta', ‘Tumpu mamaraluui. Ka' sian maalin daa ule'konon-Namo ka'ita.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Raaya'a nomae'mo ka' nungurumpaki keledai rundara nitoongkon na aropna laigan na soripi'na salan, kasi ia kakai i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Isian toropii mian indo'o potokerer nimikirawar na ko'ona i raaya'a, taena, “Nongko'upa i kuu se' mangkakai kokootna keledai kanono'?” ");
INSERT INTO blzNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kasi ia simbati i raaya'a koi men Ia potookon i Yesus. Mbaka' i raaya'a ia patalaimo mian. ");
INSERT INTO blzNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kasi i raaya'a nangawawa keledai iya'a mbaatu'u ni Yesus. Taka intu'u ia latasimo i raaya'a a sengke'na keledai iya'a tia jubana, kasi ia lakiti i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Biai' a mian nanggampalkon bokukumna i raaya'a na salan, ka' isian mian men nangala' na ale' panga' morio' men roonanaan ka' nendeer na salan. ");
INSERT INTO blzNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Giigii' mian men potorae', mau men na olukon ka' men na komburi', mangkakaro'kon taena, “Tunde' a Alaata'ala! Barakaatan i Ia men taka ia pokau Tumpu! ");
INSERT INTO blzNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Barakaatan a Batomundo'an-Na ini'imari men batomundo'an ni Daud minti'inta! Tunde' a Alaata'ala men na ko'alayo'an.” ");
INSERT INTO blzNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Taka na Yerusalem i Yesus ninsoopmo na Laiganna Alaata'ala. Na lalomna Ia lealokonmo ka' ninasai wiwi'na. Kasee ka' boomo malom, ia nomae'mo na Betania tia sompulo' rua' murit-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Koi liilana, tempona ari Yesus namarereimo Betania, Yesus nopoosurimo nololu. ");
INSERT INTO blzNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na oloapo ia nontoa'i kau ara koi kantu'u, marioompong a roonana. Ia rae'imo a kau ara iya'a toodaa woo'an, kasee taka intu'u i Ia, Ia sian nungurumpaki woo'na, tongko' roonana a biai', gause sianpo tempona miwoo'. ");
INSERT INTO blzNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mbaka' i Yesus nomorobu na kau iya'a tae-Na, “Muntumbei koini'i sa'angu'po mian sianmo mangkaan woo'om pataka manau'.” Giigii' murit-Na nongorongor. ");
INSERT INTO blzNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kasi taka a ari Yesus na Yerusalem. Tongko' ninsoop i Yesus na Laiganna Alaata'ala, Ia numbuse'imo mian biai' men ba'ili ka' men mobalu-baluk indo'o na tolodona Laiganna Alaata'ala. Meja'na mian men totolosi doi' ka' bangkona mian men mobaluk marampatii Ia tua-tua'kon. ");
INSERT INTO blzNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ia sianmo namatalai mian men mobaluk mangawawa upana lumiu na tolodona Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kasi i Yesus nimisiso' ka' nambantili i raaya'a, tae-Na, “Taasi' nipokotulismo na Alkitaap, ‘Laigan-Ku tio ngaanon laigan bo basambayanganna mianna longkop tano'? Kasee kuu wawaumo bo dodongoanna mian puraga!’ ” ");
INSERT INTO blzNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sarataa tanaasna imam tia wawa ukum Torat nongorongor upa men ia wawau i Yesus, raaya'a nansarakmo akal kada' mampapatei i Ia. Raaya'a uga' layaonkon i Yesus gause biai' a mian men koporean upa men pisiso'konon-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Guntumalommo Yesus tia murit-Na namarereimo kota iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Koi liilana ma'ulop tempo i raaya'a nolumiu, ia piile' i raaya'a a kau ara iya'a nokangkungmo tia waka-wakatna. ");
INSERT INTO blzNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mbaka' notonginau'mo i Petrus upa men ia ngaan i Yesus koi rimberi'na. Ia nobapikirawarmo taena, “Guru, piile'! Kau ara men Kuu tadeankon, nokangkungmo.” ");
INSERT INTO blzNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ia simbati i Yesus tae-Na, “Parasayamo na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' ime a momosuu' buu'na kani'i, taena, ‘Bi ko'akit ka' bi tombalo' i koo na tobui,’ asar noana amo' babata ka' parasaya se' bo sida a men ngaanonna, mbaka' men koiya'a bo sida na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mbali' iya'a bantilkonon-Ku na ko'omuu se' upa a men pa'ase'onmuu na sambayangmuu, parasaya inono' se' Alaata'ala noko pantaraimo upa men kuu pa'ase', mbaka' i kuu bo mangalabot. ");
INSERT INTO blzNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kalu i kuu kumukerer sambayang, kasee noamuu kokoo'ankon mian gause i ia nampapolosi noamuu, ampuni kutung a mian iya'a, kada' Tamamuu men na surugaa mangampuni i kuu. ");
INSERT INTO blzNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kalu i kuu sian mangampuni sala'na mian, mbaka' Tamamuu men na surugaa uga' sian mangampuni sala'muu.” ");
INSERT INTO blzNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ai Yesus tia murit-Na notakamo soosoodo na Yerusalem. Rae-rae' i Yesus na tolodona Laiganna Alaata'ala taka a toropii tanaasna imam, wawa ukum Torat ka' motu-motu'a nantaankon i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Raaya'a nimikirawar, taena, “Upa a pimpu'uaan nangawawau men koiya'a? Ka' ime a nantarai i Koo kuasa mbali' nangawawau giigii' iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ia simbati i Yesus tae-Na, “Yaku' uga isian upa bo pikirawaron-Ku na ko'omuu. Alaka' simbati kada' bantilkonon-Ku i kuu se' kuasa ni ime mbali' daa i Yaku' mangawawau koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Alaata'ala kabai mian a nantarai i Yohanes kuasa bo pansarani mian? Koi upa i kuu?” ");
INSERT INTO blzNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tanaasna imam ka' motu-motu'a na Yahudi nopootunduniimo raaraaya'ana, taena, “Kalu kita mangaan, ‘Kuasana ringkat na Alaata'ala,’ mbaka' simbation-Na, ‘Nongko'upa i kuu se' kosian mamarasaya upa men taeni Yohanes?’ ");
INSERT INTO blzNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kasee mare-marepanapo kalu simbationta, ‘Kuasana ringkat na mian.’ Kita bo komaso'kononna mian biai' gause pimiile'na mian giigii' se' i Yohanes tuutuu' sa'angu' nabii.” ");
INSERT INTO blzNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mbaka' ia simbati i raaya'a, “Sian inti'ionmai.” Taeni Yesus, “Kalu koiya'a, Yaku' uga' sian mambantilkon na ko'omuu se' kuasa ni ime bo pimpu'uan-Ku mangawawau koiya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ai Yesus nuntumbeimo nuntundun timbaani' na tanaasna imam, wawa ukum Torat ka' moomoola'na Yahudi. Tae-Na, “Isian sa'angu' mian nosumapar bo ale'na anggur. Ia nambalamo tiku-tikumna, ka' nengkeke bolo' bo pimiisan anggur, ka' nangawawau sa'up bo badagaian ale' iya'a. Kasi ia nantamboikon ale'na anggur iya'a na papalimang, ka' nomae' na lipu' sambana. ");
INSERT INTO blzNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sarataa temponamo kopumpupuan anggur, mian iya'a nomosuu'mo sa'angu' tutulungina mae' na mian men mingilimang ale'na anggur iya'a kada' mangala ule' men bokoi obosna. ");
INSERT INTO blzNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kasee papalimang na ale'na anggur iya'a tongko' nangarakop tutulungina tombono ale'na anggur iya'a ka' numukul ka' nomosuu' nomae' tia lima sompulo'. ");
INSERT INTO blzNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Noko daa koiya'a, tombono ale'na anggur iya'a nomosuu'mo sa'angu' mianna men sambanaan mbaatu'u na ko'ona i raaya'a. Mian iya'a ia pukulmo i raaya'a pataka nobelaon a takala'na ka' ni'iroki. ");
INSERT INTO blzNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tombono ale'na anggur iya'a nomosuu'mo sa'angu' tutulungina men sambana, ka' mian iya'a ia papatei i raaya'a. Biai' uga' a mianna sambana men niposuu'. Isian men nipool ka' isian uga' men nipapatei. ");
INSERT INTO blzNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Koini'i somo anakna sa'angu' men kolingu'na tuu'. Kokomburi'anna ia nomosuu'mo anakna, taena, ‘Kalu anakku sabole kolayaonna i raaya'a.’ ");
INSERT INTO blzNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tongko' ia piile' papalimang na ale'na anggur iya'a se' notakamo a anak iya'a, raaya'a nopootunduniimo, taena, ‘Iamo kaya'a a men bo pontombonoi giigii' upana tamana. Mai kita papateia i ia kada' kitamo a pontombonoi budelna.’ ");
INSERT INTO blzNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mbaka' anak iya'a nirakopmo ka' nipapatei. Biibiina ia balo'kon i raaya'a na liwana ale' iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesus nimikirawarmo, tae-Na, “Upamo a wawauonna tombono ale'na anggur iya'a? Sabole i ia bo taka ka' mampapatei papalimang na ale'na, kasi mongorookon ale'na iya'a na papalimang sambana. ");
INSERT INTO blzNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kuu sabole nambasamo na Alkitaap, Watu men ia balo'konmo tukang nosidamo watu tuko men bo pandasi. ");
INSERT INTO blzNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Men koiya'a ia wawau Tumpu, ka' wawau-Na iya'a nompoposamba' i kita men nimiile'.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Moomoola' na Yahudi mansarak salan mangarokop i Yesus. Gause ia inti'i se' tundunan ni Yesus umba'a mintimbaani'kon i raaya'a koi papalimang ale'na anggur men ba'idek. Kasee i raaya'a layaonkon mian biai'. Mbaka' i raaya'a somo namarerei i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Moomoola' na Yahudi nomosuu'mo mian Farisi tia toropii winawa ni Tomundo' Herodes mae' ni Yesus mansarak mangakalkon i Yesus tia upa men pikirawaronna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Raaya'a notakamo ni Yesus ka' nobapikirawar, taena, “Guru, kai inti'i i Kuu sian muntundun upa men kosian, ka' mau i ime, sian kolayaon-Muu, gause i Kuu sian momposasala'kon mian. Kasee i Kuu mimisiso'kon pingkira'na Alaata'ala men tuutuu'na. Kalu na aturanna agamanta, daa patalaion a mambayar pajak bona Kaisar kabai sian? Tiodaa i kai mambayar pajak kabai sian?” ");
INSERT INTO blzNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kasee i Yesus inti-inti'i panduungna i raaya'a, kasi tae-Na, “Nongko'upa i kuu se' mimitopongi i Yaku'? Wawa le'emari a sa'angu' doi' dinar kada' piile'on-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ia wawamo i raaya'a. Kasi i ia pikirawar tae-Na, “Gambar tia ngaan ni ime ini'i?” Taena, “Gambar tia ngaanna Kaisar.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kasi taeni Yesus, “Rookon bona Kaisar a upa men tio rookononmuu na Kaisar ka' rookon bona Alaata'ala a upa men tio rookononmuu na Alaata'ala!” Raaya'a samba' tuu' nongorongor upa men taeni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Toropii mian Saduki notaka ni Yesus. (Pinginti'ina i raaya'a se' mian lapus sianmo tumuo' soosoodo.) Mbali' iya'a, raaya'a nimikirawar taena, ");
INSERT INTO blzNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Guru, ai Musa nuntulis ukum koi kani'imari bo ko'onta': Kalu sa'angu' mian moro'one lapus namarerei boroki' men sian anakon, mbaka' utusna moro'one iya'a tio mosuo' tia baluna utusna kada' utusna isian lee'na. ");
INSERT INTO blzNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Isian pitu' moro'one moto'utus. Men balaki'na nosuo' tia sa'angu' wiwine, kasi moro'one iya'a nolapus kasee sian no'anakon. ");
INSERT INTO blzNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Men korua'na nomosuo'imo wiwine iya'a, ka' lapus kasee sian no'anakon. Koiya'a uga' na utusna men kotolu'na, ");
INSERT INTO blzNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","pataka men na kopitu'na. Pitu-pitu'na nomosuo'i kasee sian no'anakon. Raaya'a kabus nolapus. Ka' kokomburi'anna wiwinemo iya'a a men nolapus. ");
INSERT INTO blzNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na ilio pomotuo'ian mian lapus ni'imarian, mian men moto'utus pitu' ira iya'a, ime a men bo sida langkai'na wiwine iya'a? Gause pitu-pitu' irana nompoboroki'mo i ia.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ia simbati i Yesus tae-Na, “Ai kuu mansala'imo, gause i kuu sian minginti'i isiina Alkitaap ka' sian minginti'i kuasana Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gause mian lapus men tumuo' soosoodo sianmo mosuo' ka' poposuo'on. Raaya'a tumuo' koi malaa'ikat na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kasee mian lapus sabole bo potuo'ion. Kuu taasi' noko pambasamo kitap ni Musa? Na kitap iya'a isian ningaan kau morio' ruri'on men kumait, ka' i Musa mondo'o kere-kerer. Isian wurungna Tumpu nambantilkon, tae-Na, ‘Yaku'mo a Alaata'ala ni Abraham, Alaata'ala ni Ishak, ka' Alaata'ala ni Yakub.’ ");
INSERT INTO blzNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Alaata'ala iya'a taasi' Alaata'ala na mian lapus, kasee Alaata'ala na mian tumuo'. Ai kuu uga' mansala'imo tuu'!” ");
INSERT INTO blzNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Isian sa'angu' wawa ukum Torat taka momorongori i Yesus poosisimbat tia toropii mian Saduki, ka' i ia uga' minginti'i se' upa men simbatikonon ni Yesus na mian Saduki kana' tuu'. Wawa ukum Torat iya'a nobapikirawarmo ni Yesus taena, “Wiwi'na ukum, potoo men koi upa a men tuko?” ");
INSERT INTO blzNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Taeni Yesus, “Potoo men tuko mbaka': Porongori i kuu samba Israel! Tumpu Alaata'alanta mase Tumpu men sianta sambanaan. Tongko' i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kolingu'kon a Tumpu Alaata'alamuu tia noa men tuutuu', ka' tia wiwi'na wakamuu ka' wiwi'na pinginti'ianmuu ka' tia wiwi'na men pokoonmuu. ");
INSERT INTO blzNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ka' potoo men korua'na mbaka': Kolingu'kon a simbaya'muu mian koikoimo pongkolingu'konmuu wakamuu. Sianta potoo sambana men nitukokon saliwana rurua' potoo kani'i.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kasi wawa ukum Torat iya'a ninsimbati i Yesus taena, “Tuutuu', Guru! Kana'mo inooro'o tae-Muu. Tumpu Alaata'ala uga' tongko' sa'angu' ka' kosian Alaata'ala sambana. ");
INSERT INTO blzNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ka' mian tiodaa mongkolingu'kon Alaata'ala tia noa men tuutuu', tia wiwi'na waka ka' wiwi'na pinginti'ian ka' tia wiwi'na men pokoonna. Ka' i ia uga' tiodaa mongkolingu'kon simbaya'na mian koikoimo pongkolingu'konna wakana. Ya'a a daana tia mongorookon kurbaan men tunuon ka' kurbaan sambana bona Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ia porongor i Yesus a ninsimbatina wawa ukum Torat iya'a se' pore ka' kana'. Ia norobumo tae-Na, “Ai kuu kara-karaani'mo sida mian na Batomundo'anna Alaata'ala.” Noko daa iya'a sianta sa'angu'po mian men momoko bapikirawar soosoodo ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tempo i Yesus mimisiso' na Laiganna Alaata'ala, Ia nobapikirawarmo na ko'ona i raaya'a, tae-Na, “Na pinginti'imuu, nongko'upa mbali' a wawa ukum Torat mangaan Tomundo' Pansalamatkon se' lee' ni Daud? ");
INSERT INTO blzNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Gause Daud a men nangaan tia pisiso'na Alus Molinas taena: ‘Tumpu Alaata'ala nangaan na Tumpungku tae-Na: oruang na paraas uanan-Ku pataka Yaku' mompoporungku' giigii' mian men mangka'idek i Koo sida malolo' na Ko'oom.’ ");
INSERT INTO blzNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daud a men nangaan se' Tomundo' Pansalamatkon iya'a Tumpuna. Pinginti'imuu, koi upa a kosidana se' daa Tomundo' Pansalamatkon uga' bo lee'na?” Mian men biai' tuu' kokana'an nongorongor pisiso' ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Taeni Yesus, “Maka'amat na wawa ukum Torat. Gause i raaya'a mo'uus sumasayo mojuba alayo' ka' beleskon angga'ionna mian na pasar. ");
INSERT INTO blzNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Raaya'a mo'uus umoruang na oruangan men porena na laigan bakitumpuan kabai na pootatakaianna mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Raaya'a mangakali balu ka' mangala laiganna. Ka' bo pingililungina gau'na men ba'idek, raaya'a sambayang biai' taa'. Mian koiya'a sabole bo mantausi ukuman marawat.” ");
INSERT INTO blzNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus no'umoruang nangarop peti pingilinsonan doi' persembaahan na Laiganna Alaata'ala. Ia namakanasai mian biai' monsoopkon doi'na i raaya'a na peti. Biai' a mian kupangon mingilinson doi'na men biai' a angga'na. ");
INSERT INTO blzNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Taka a sa'angu' wiwine balu men talalais ningilinson doi'na rurua' men tongko' titiu' a angga'na. ");
INSERT INTO blzNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus nengeleelo'mo murit-Na, tae-Na, “Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' balu men talalais kale'e a biai'na ia linson na peti tia na mian sambana. ");
INSERT INTO blzNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gause i raaya'a giigii' nantarai persembaahan tia labina kupangna. Kasee balu men talalais kale'e nongorookonmo upa wiwi'na men somo iya'a a isian na ko'ona, ka' men bookoi bo kaanonna liila ipuan.” ");
INSERT INTO blzNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tempo i Yesus no'umuar na Laiganna Alaata'ala, sa'angu' murit-Na nangaan, taena, “Guru, Piile'! Pore tuu' a laigan watu balaki' kale'e ka' moonggor tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Taeni Yesus, “Yaku' mingkira' mambantilkon na ko'omuu laigan watu balaki' men taemuu se' balaki' ka' moonggor. Ni'imarian sianta sa'angu'po watu na Laiganna Alaata'ala kani'i a men dauga' patalaion pootapi'. Wiwi'na bo runtunion.” ");
INSERT INTO blzNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Noko daa iya'a ari Yesus nomae'mo na Buu'na Zaitun ka' i Yesus no'umoruang nangarop patuk buu'na men kekelaanna Laiganna Alaata'ala. Ai Petrus, Yakobus, Yohanes ka' i Andreas nimikirawarmo raaraaya'ana ni Yesus, taena, ");
INSERT INTO blzNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Bantilkon i kai se' ipi a bo sidaanna men tae-Muu umba'a, ka' oosan upa men bo pinginti'ian kalu takamo a tempona kosidaanna giigii' iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Taeni Yesus, “Maka'amat, dako' i kuu ko'akalian. ");
INSERT INTO blzNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Biai' a mian bo taka mangaan ngaan-Ku, ka' morobu taena, ‘Yaku'mo a Tomundo' Pansalamatkon!’ Raaya'a bo mangakalkon mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kalu i kuu momorongor lelena mian poopapate ka' laungna sindapanna mian men poopapate, alia i kuu uga' layaon. Gause iya'a tiodaa sida koiya'a kasee iya'a taasi'po kakabusanna tempo. ");
INSERT INTO blzNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lipu' men sa'angu' bo poopapate mintimbangi lipu' men sambana, ka' batomundo'an sa'angu' bo poopapate mintimbangi batomundo'an men sambana. Ka' bo lili'on na toropii dodongoan, ka' bo liuonna pololuan. Wiwi'na iya'a baasi muntumbei repaan, koi polos men surionna wiwine men boomo mondodongokon anak. ");
INSERT INTO blzNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kuu tiodaa maka'amat, gause i kuu bo rakopon ka' wawaon na moomoola'na agama. Kuu bo poolon na laigan bakitumpuan. Ka' i kuu uga' bo wawaon na gubernuur ka' na tomundo' gause i kuu parasaya na Ingku'. Ya'amo a tempomuu men pore bo pambantilkonanmuu Lele Pore na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lele Pore men na Alaata'ala tiodaa lelekonon kutung na sanda' lipu'. ");
INSERT INTO blzNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kalu rakopon i kuu ka' wawaon na mian men bo pungukumi mbaka' amo' babatakon men bo porobukononmuu. Porobukon men rookonon na ko'omuu tempo iya'a, gause upa men porobukononmuu kanono' taasi' rumingkat na ko'omuu kasee na Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Isian uga' mian bo minsasapu na utusna kada' utusna papateionna mian. Isian uga' tama bo minsasapu na anakna kada' anakna papateionna mian. Ka' anak bo mintimban minti'ina ka' minsasapu kada' minti'ina papateionna mian. ");
INSERT INTO blzNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kuu bo kokundaionna giigii' mian gause na pongololo'an i Yaku'. Kasee mian men mantaan pataka kokomburi'anna bo salamatkonon.” ");
INSERT INTO blzNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Sa'angu' tempo i kuu bo mimiile' pinsilaka'i men ba'idek kumekerer na sa'angu' tampat men sian sida kekererionna. (Sulano i kuu men mambasa ini'i sida minginti'i.) Na tempo iya'a, mian men isian na libutan Yudea tio mamarere na buu'na. ");
INSERT INTO blzNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mian men monda'a na wawona laiganna tempo iya'a ka' upana isian na laigan, amo'mo malau ka' minsoop na laigan mangala upana. ");
INSERT INTO blzNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ka' mian men na ale' sobii ka' mule'kon mangala pakeanna. ");
INSERT INTO blzNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Marepa a wiwine men mampaiwawa tempo iya'a, ka' sina men dauga' momosusui anak. ");
INSERT INTO blzNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pa'ase' na sambayangmuu kada' amo' tempo memel a kotakaanna tempo iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gause na tempo iya'a bo taka a sa'angu' repaan men sianpo ia toosuri mian tumbe-tumbepo Alaata'ala ninsidakon tano' balaki' pataka koini'i. Ka' sianmo isian repaan men koiya'a soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kalu Alaata'ala sian monsondo'i tempo marepa iya'a, mbaka' sianta sa'angu'po mian men salamat. Kasee kada' mian-Na men Ia ruruki sida salamat, mbaka' bo sondo'ion-Na tempo iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tempo iya'a kalu isian mian morobu na ko'omuu taena, ‘Piile', kani'imo a Tomundo' Pansalamatkon!’ kabai taena, ‘Piile', kale'emo a Tomundo' Pansalamatkon!’ alia mamarasaya upa men ia ngaan mian kanono'. ");
INSERT INTO blzNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gause pansalamatkon borek tia minti nabi-nabii bo taka. Raaya'a bo mingilimang oos ka' upa kosamba' bo pangakalianna mian, maupo mian men ia rurukimo Alaata'ala bo mian-Na. Uga' pi'akalionna i raaya'a kalu too pokoonna. ");
INSERT INTO blzNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Maka'amat i kuu. Gause daa Yaku' bantilkonmo a upa men bo rumpakion ini'imari.” ");
INSERT INTO blzNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kasee moko daa repaan iya'a, matana ilio bo pintung ka' wulan sianmo tarang. ");
INSERT INTO blzNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Bitu'on bo mandawo' ra'amari na langit ka' pungkuasai langit iya'a bo toyunggot. ");
INSERT INTO blzNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na tempo iya'a mian bo mimiile' Anak Manusia taka ra'amari na lalomna antong tia kuasa balaki' ka' lingkaangan. ");
INSERT INTO blzNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ka' na tempo iya'a uga' Anak Manusia bo momosuu' malaa'ikat-Na umuar kada' bo pingirimpung giigii' mian men Ia ruruki na longkop tano' balaki', ringkat na puusna tano' balaki' pataka na puusna langit. ");
INSERT INTO blzNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Inau' a timbaani'na kau ara. Kalu panga'na malalas ka' molusa', ka' muntumbeimo sumumpe, inti'ionmuumo se' tempona pengkar booboomo. ");
INSERT INTO blzNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Koiya'a uga' kalu i kuu mimiile' men taeng-Ku' kaekae'mo sida. Inti'ionmuu se' tempona booboomo. ");
INSERT INTO blzNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' giigii' upa men Yaku' poko bantilkonmo na ko'omuu iya'a bo sida koo'po tia mian men tumuo' tempo koini'i lapus giigii'na. ");
INSERT INTO blzNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langit ka' tano' balaki' bo penta', kasee wurung-Ku isian pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kasee sianta sa'angu'po mian men minginti'i iliona tia jaamna. Malaa'ikat na surugaa sian, Anakna Alaata'ala uga' sian. Tongko' Tama na surugaa a men daa ninginti'i.” ");
INSERT INTO blzNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Amo' rame, kasee tio maka'amat. Gause i kuu sian minginti'i kotakaanna tempona. ");
INSERT INTO blzNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tempona timbaani'konon koi sa'angu' mian men namarerei laiganna ka' namarasayakon na tutulungina bo pinginti'i laiganna iya'a. Ka' giigii' tutulungi sanda' nitarai men bo dagaionna. Ka' uga' i ia nomosuu' dadagai soopan balaki' badaga pore-pore. ");
INSERT INTO blzNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mbaka' mandagaisi, gause i kuu sian minginti'i se' ipi a kotakaanna tombonona laigan iya'a, too guntumalom, kabai tanga'na rondom, kabai karani' ilio kabai se' too ma'ulo-ulop tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kada' kalu ola-olan taka i ia, amo' takaionna i kuu pintanga' royot. ");
INSERT INTO blzNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Upa men Yaku' bantilkonmo i kuu, bantilkonon-Ku uga' na mian wiwi'na se' badaga!” ");
INSERT INTO blzNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dauga' koi rua' ilio muntumbeimo pangaramekonan Paska tia ramean Roti Sianta Ragina. Tanaasna imam tia wawa ukum Torat, nansarakmo salan mangarakop i Yesus wuni-wuni ka' mampapatei. ");
INSERT INTO blzNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Taena i raaya'a, “Amo'po wawauon na tempo ramean, dako' mantakakon kogora'an na mian biai'.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sarataa i Yesus na Betania, na laigan ni Simon men kustaon mbaripian, taka a wiwine sa'angu' nangawawa botor men watu pualam isiian minamina' narwastu. Minamina' narwastu iya'a alayo' tuu' a angga'na gause sianta baurna. Pintanga' kumaan i Yesus, ia pula'imo wiwine iya'a a talopna botorna, kasi nitimbu'ikon takala' ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Toropii a mian indo'o nomaso'mo, ka' nopootundunii simbaya'na, taena, “Upa a kana'na minamina' narwastu kale'e ka' lalaision? ");
INSERT INTO blzNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gause minamina' narwastu kale'e sida balukkonon tolu'atu labi doi' dinar, ka' ilina sida obo-oboskonon bona mian talalais.” Mbaka' ia komaso'i i raaya'a a wiwine iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kasee taeni Yesus, “Patalai i ia. Nongko'upa i kuu se' mampapolosi noana? Ia nangawawaumo upa men pore na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ka' mian talalais sinampang isian na ko'omuu. Sanda' ilio kalu i kuu mingkira', sidaonmuu laweion i raaya'a. Kasee i Yaku' sian sina-sinampang tii kuu. ");
INSERT INTO blzNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ia nangawawaumo upa men daa sidaonna wawauon. Wakang-Ku ia poko minamina'imo bookoi pontoropotianna bo pantanoman i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' longkop tano' balaki', mau maana a pengelelekonan Lele Pore, ino'o uga' upa men ia wawaumo wiwine kani'i bo bantilkonon bookoi pinginau'an i ia.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na lalomna sompulo' rua' murit ni Yesus isian sa'angu' mian men ngaanna i Yudas Iskariot. Ia nomae' nari tanaasna imam bo mongorookon i Yesus na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wiwi'na i raaya'a nobeles tuu' nongorongor men ia bantilkon i Yudas, ka' i raaya'a nontoon i ia se' bo taraionna doi'. Noko daa iya'a, ai Yudas nansarakmo salan men daa pore bo pongorookonanna i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na ilio tumbena pangaramekonan Roti Sianta Ragina mian malia' mongkoyo' domba Paska. Tempo iya'a murit ni Yesus nobapikirawar na Ko'ona, taena, “Maana po'uus-Muu bo pontoropotianmai kakaan bo pangaramekonan Paska?” ");
INSERT INTO blzNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kasi i Ia nomosuu' rurua' murit-Na, tae-Na, “Rae' na kota. Nda'a na kota i kuu bo pootuung sa'angu' moro'one tumambu' mangawawa gumbang buke' a weer. Lolo' i ia. ");
INSERT INTO blzNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Na laigan men pinsoopanna, bantilkon na tombono laigan iya'a, inta': Potuunna Guru: maana a tampat men bo pangkaanan kakaan ramean Paska tia murit-Ku? ");
INSERT INTO blzNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tombono laigan iya'a bo minsiso'kon na ko'omuu sa'angu' olisna parawawo men balaki' men noko toropotmo tia pakakasna. Toropoti a kakaan bo ko'onta'.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kasi rurua' murit ni Yesus nomae' na kota iya'a. Ia takai i raaya'a wiwi'na sintutu' koi men taeni Yesus. Raaya'a uga' nontoropotimo kakaan men bo kaanon na Paska iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sarataa malommo taka i Yesus tia murit-Na sompulo' rua' na laigan men nitoropotimo. ");
INSERT INTO blzNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Poto'oruang i raaya'a kumaan, ai Yesus norobumo tae-Na, “Imamat ini'imari! Bantilkonon-Ku na ko'omuu se' isian i kuu men bo mongorookon i Yaku' kada' papateion, men pintanga' kumaan tii Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tongko' nongorongor iya'a, mbaka' noana i raaya'a nasiongo'mo. Raaya'a norobumo sa'angu'-sa'angu' taena, “Taasi'po i yaku', indo'?” ");
INSERT INTO blzNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Taeni Yesus, “Mian iya'a sa'angu' mian na ko'omuu sompulo' rua' i kuu ka' men mongorom rotina na lalomna mangko' patombongan tii Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tuutuu' mba'a se' Anak Manusia bo lapus koi men nipoko tulismo na Alkitaap. Kasee silaka' a mian men mongorookon Anak Manusia. Mian iya'a bagia sian nidodongokon.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pintanga' kumaan i Yesus tia murit-Na, Yesus nangalamo roti, nobasukuur ka' nungurumpi-rumpik, kasi nongorookon na murit-Na ka' norobu tae-Na, “Alamo, ni'imo a wakang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Noko daa koiya'a, Ia ala a pinginuman tia anggur ka' nobasukuur na Alaata'ala kasi nongorookon i raaya'a, ka' wiwi' irana ninginum anggur iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ia norobumo taena, “Ni'imo a rara'-Ku men mamakadodor toonna Alaata'ala. Rara'-Ku tonturo' bona mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' Yaku' sianmo minginum anggur soosoodo pataka na iliona men bo pinginuman-Kumo anggur men u'uru iya'a ruru-ruru' tii kuu na Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Noko daa nangananikon nanian puntunde', raaya'a nomae'mo na Buu'na Zaitun. ");
INSERT INTO blzNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus norobu na ko'ona i raaya'a, tae-Na, “Kuu giigii' kuuna sianta mantaan a noamuu. Gause nipoko tulismo a wurungna Alaata'ala, ‘Bo poolon-Ku a pontondong domba ka' giigii' domba bo bagera-gerap.’ ");
INSERT INTO blzNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kasee moko daa i Yaku' potuo'ion, Yaku' bo mongolukoni i kuu na Galilea.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ia simbati i Petrus, taena, “Mau i raaya'a giigii' sianta mantaan a noana, see men i yaku' mokotaan.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Taeni Yesus, “Tuutuu' mba'a. Kasee bantilkonon-Ku na ko'oom se' rondommo kani'i, koo'po tia paraa muntuturuu' a siok kopinduanna, koo noko porotolumo minsasapu na Ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kasee i Petrus nanggagai, taena, “Yaku' mau pate tii Kuu, sian minsasapu na Ko'omuu.” Giigii' murit men sambana uga' nangaan men koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Taka i Yesus tia murit-Na na tampat men ngaanon Getsemani. Taeni Yesus na murit-Na, “Oruang karaa'ita. Yaku' dauga' mae' sambayang.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kasi i Yesus nangange i Petrus, Yakobus, ka' i Yohanes mae' tii Ia. Muntumbeimo i Ia munsuri marepa tuu' ka' siasa. ");
INSERT INTO blzNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Taeni Yesus na ko'ona i raaya'a, “Noang-Ku masiongo' tuu', koi se' kolapus-Kumo surion. Kuu ka'itamo ka' maka'amat.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ai Yesus nomae'mo ndee-ndee'e, kasi notumutuku' rumbuk tano' ka' nosambayang. Na sambayang-Na, Ia mama'ase' too daa sida kada' i Ia amo' munsuri repaan men bo tumaka. ");
INSERT INTO blzNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Taeni Yesus, “Oo Papa, Tamang-Ku! Giigii' upa ai Kuu a Pinginti'i. Anui a repang-Ku kani'i na wakang-Ku. Mau koiya'amo, taasi' pingkira'-Ku a lolo'on, kasee pingkira'-Muu a lolo'on.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Noko daa iya'a i Yesus nomule'konmo. Ia takai a murit-Na nokoroyotmo. Ia norobumo ni Simon Petrus, tae-Na, “Simon, se' royot i koo? Sian mbali' i koo momoko moburar badaga sa'angu' jaam?” ");
INSERT INTO blzNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kasi i Yesus norobu na ko'ona i raaya'a, tae-Na, “Maka'amat ka' basambayang dako' i kuu topongionna upa men ba'idek. Noamuu mo'uus mangawawau men kana', kasee i kuu sian mokotaan.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kasi i Ia nomae' soosoodo ka' nosambayang men koi Ia tundun na sambayang-Na umba'a. ");
INSERT INTO blzNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ka' sarataa i Ia nde'emari soosoodo, Ia takai i raaya'a pintanga' royot, gause i raaya'a nototundo'mo. Raaya'a sianmo ninginti'i i se' koi upa a bo pinsimbati i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ai Yesus nomae'mo nosambayang ka' nomule'kon soosoodo koporotoluna na ko'ona i raaya'a. Taeni Yesus, “Nongko'upa se' dauga' royot i kuu ka' mintimale? Daamo. Takamo a tempona. Piile'! Anak Manusia rookononmo na limana mian men dosaon. ");
INSERT INTO blzNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wangon, mai kita mae'mo. Ai ia men mongorookon i Yaku' takamo.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pintanga' i Yesus dauga' morobu, notakamo i Yudas, sa'angu' mian men tonsoop sompulo' rua' murit ni Yesus. Ka' men nongololo' i ia mian biai' potowawa bakoko' tia popool. Raaya'a ia posuu' tanaasna imam ka' wawa ukum Torat, tia motu-motu'a. ");
INSERT INTO blzNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ai Yudas men bo mongorookon i Yesus noko pambantilkonmo oosan kani'imari na ko'ona i raaya'a, taena, “Mian men ookionku, ya'amo i Ia. Rakop ka' wawa i Ia. Dagai pore-pore.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tongko' notaka i Yudas imba'a, ia liuliu nuntuu'i i Yesus ka' norobu taena, “Guru!” Kasi ia nongooki i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mbaka' ia intonimo i raaya'a i Yesus ka' nirakop. ");
INSERT INTO blzNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Isian sa'angu' mian men indo'o tii Yesus numbubut bakoko'na ka' nontotok sa'angu' ata'na Imam Moola', tamban nokopantas a tilingana. ");
INSERT INTO blzNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus norobu na ko'ona i raaya'a tae-Na, “Pansaruimuu se' i Yaku' too mian puraga mbali' i kuu taka poto'inton bakoko' tia popool bo pangarakop i Yaku'? ");
INSERT INTO blzNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sanda' ilio i Yaku' monda'a tii kuu mimisiso' mian na tolodona Laiganna Alaata'ala, see i kuu sian nangarakop i Yaku'. Kasee tio koiya'a kosidana kada' sidamo a men nitulis na Alkitaap.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kasi giigii' murit-Na kabus namarere ka' namarerei i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sa'angu' anak malai moro'one, na malom iya'a tongko' nokalimbut toik lenang, mae' nongololo' i Yesus. Ia intoni i raaya'a a mian iya'a bo rakoponna, ");
INSERT INTO blzNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kasee liuliu ia tikarkon a kalimbutna ka' notumetende' lada-ladak. ");
INSERT INTO blzNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tongko' daa koiya'a, ai Yesus niwawamo na Imam Moola'. Wiwi'na tanaasna imam ka' motu-motu'a tia wawa ukum Torat nobarimpung indo'o. ");
INSERT INTO blzNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus nuntuntuni i Yesus kasee olo-oloa mae' na tolodona Imam Moola'. Inda'a i ia no'umoruang nintingola' nari dadagai ka' ninguru. ");
INSERT INTO blzNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tanaasna imam tia wiwi'na mianna Mahkama Agama mansarak mian bo pomborekkon i Yesus kada' i Ia tio ukumon pate, kasee i raaya'a sian nantausi sala'-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Biai' uga' a mian men nomborekkon i Yesus, kasee tundunanna i raaya'a sian pootutu'. ");
INSERT INTO blzNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kasi isian toro pii mian nokumekerer ka' nomborekkon wawau i Yesus, taena, ");
INSERT INTO blzNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kai nongorongormo mian kaya'a nobatundun, tae-Na, ‘Yaku' bo munguruntun Laiganna Alaata'ala men ia wawau mian, kasee na lalomna tolu' ilio pokereron-Kumo a laigan sambana, men taasi' ia wawau mian.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ya'apo tundunanna i raaya'a sian pootutu'. ");
INSERT INTO blzNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Imam Moola' nokumekerermo na tanga-tanga'na mian biai' ka' nimikirawari i Yesus, taena, “Nongko'upa i Koo se' sian minsimbati? Koi upa men ia raitkon mian karaaya'a na Ko'oom?” ");
INSERT INTO blzNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kasee i Yesus tongko' roko-rokot, sian ninsimbati. Imam Moola' dauga' nimikirawari i Yesus soosoodo, taena, “Too i Koo a Tomundo' Pansalamatkon, Anakna Tumpu Tontunde', kabai taasi'?” ");
INSERT INTO blzNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Taeni Yesus, “Yaku'mo mba'a inono'. Ka' i kuu bo mimiile' Anak Manusia umoruang paraas uananna Alaata'ala Men Pungkuasai, ka' taka ra'amari langit na tanga-tanga'na antong.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nongorongor wurung ni Yesus, Imam Moola' nemberak pakeanna ka' norobu taena, “Bo upa ka' dauga' mansarak mian bo pinginti'ianta? ");
INSERT INTO blzNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kuu daa nongorongormo i Ia ningidek Alaata'ala. Koi upa i kuu?” Kasi i raaya'a nompoposa'angu' wurungna i raaya'a, se' ai Yesus tiodaa ukumon pate. ");
INSERT INTO blzNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kasi toropii mian ninginori i Yesus ka' nongompodi ro'up-Na ka' numukul i Yesus, kasi norobu na Ko'ona, taena, “Io nabii, ngaan too i ime a numukul i Koo.” Tamban ari dadagai numukul i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tempo iya'a i Petrus dauga' indo'o na tolodo, taka sa'angu' wiwine men ata'na Imam Moola'. ");
INSERT INTO blzNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ia toopiile' se' isian i Petrus minguru, ia pakalolo'imo a dudusna, taena, “Ai koomo mba'a a men poopoololo' tii Yesus, samba Nazaret iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kasee i ia ninsasapu, taena, “Sian inti'ionku ka' sian arationku se' upa a panduuwung.” Kasi i Petrus nomae' na soopan balaki' na gandaria. Tempo iya'a nuntuturuu'mo a siok. ");
INSERT INTO blzNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ia piile' wiwine iya'a se' isian i Petrus soosoodo, ia norobumo na mian iraando'o, taena, “Mianmo kani'i mba'a a samba-sambana i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kasee i Petrus ninsasapu soosoodo. Sian paraa nanau' mian men isian iraando'o norobu ni Petrus taena, “Sabole i koo tonsoop tii raaya'a, gause i koo mase samba Galilea.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kasi i Petrus nobatadean ka' nobasumpa', taena, “Yaku' mase sian inti'ionku inooro'o mian men kuu ngaan.” ");
INSERT INTO blzNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Singka-singkat iya'a, nuntuturuu'mo a siok men kopinduanna. Liuliu notonginau' i Petrus se' ia poko bantilkonmo i Yesus, taena, “Koo'po tia siok muntuturuu' men kopinduanna, ai koo noko porotolumo minsasapu na Ingku'.” Petrus liuliu nowiri, tamban bolingongoton. ");
INSERT INTO blzNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ma'ulo'-ulop tuu', ari tanaasna imam tia motu-motu'a ka' ari wawa ukum Torat, tia wiwi'na mianna Mahkama Agama nomosa'angu'mo wurung. Ia pungu i raaya'a i Yesus, kasi niwawa taka ni Pilatus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus nimikirawarimo i Ia, taena, “Koomo a tomundo'na lipu' Yahudi?” Ia simbati i Yesus tae-Na, “Koi nooro'o men taemuu.” ");
INSERT INTO blzNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Liuliu tanaasna imam nambantilkon biai' kaliangan mangarait i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kasi ia pikirawari i Pilatus soosoodo, taena, “Nongko'upa i Koo se' sian minsimbati? Rongor, biai'mo kaliangan a wurungna i raaya'a mangarait i Koo.” ");
INSERT INTO blzNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kasee i Yesus santaa'po sianmo ninsimbati, tamban i Pilatus nosamba'mo. ");
INSERT INTO blzNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Koi men nodelemo sanda' taun na pangaramekonan Paska, ai Pilatus munguarkon sa'angu' mian na tarungkuan men koi pa'ase'na mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na tempo iya'a isian mian ngaanon i Barabas tia mian toro pii men sian momorongori pamarenta. Raaya'a nitarungku singka-singkat, gause nampapateimo mian na tempo nangawawau kogora'an. ");
INSERT INTO blzNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mbaka' notakamo ni Pilatus a mian biai' mama'ase' kada' munguarkon sa'angu' mian na tarungkuan koi men nodelemo. ");
INSERT INTO blzNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ia pikirawar i Pilatus, taena, “Ko'uusmuu a tomundo'na lipu' Yahudi kani'i uarkononku?” ");
INSERT INTO blzNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatus inti-inti'i se' tanaasna imam nangkalaakkon i Yesus gause i raaya'a kokoo'ankon i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kasee tanaasna imam nomosuu' mian biai' mama'ase' ni Pilatus kada' i Barabas a men uarkonon bo ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dauga' ia pikirawari i Pilatus soosoodo, taena, “Ansee ka' koiya'a upaionkumo a mian kaya'a men taemuu se' tomundo'na lipu' Yahudi?” ");
INSERT INTO blzNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Liuliu nangkakaro' i raaya'a, taena, “Saliipkonmo a mian kanono'!” ");
INSERT INTO blzNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kasee taena i Pilatus na ko'ona i raaya'a, “Kasee idek upa a men Ia poko wawaumo?” Kasee i raaya'a tongko' kaekae' dodoa mangkakaro' taena, “Saliipkon a mian kanono'!” ");
INSERT INTO blzNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gause i Pilatus mingkira' mompobeles noana mian biai', ia ala uarkon i Barabas men koi kikira'na i raaya'a, ka' ia posuu'konmo i Pilatus mian mansasali i Yesus, kasi nongorookon bo saliipkonon. ");
INSERT INTO blzNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Noko daa iya'a, ai Yesus ia wawamo surudadu minsoop na tolodona laiganna Gubernuur, kasi nileelo' a surudadu wiwi'na barimpung. ");
INSERT INTO blzNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Raaya'a nimpisoki i Yesus tia juba kakamumu', kasi nanganam sa'angu' likok ruri' niwawau koi mahkota ka' nunsulon na takala'-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Noko daa iya'a, raaya'a nantabe'imo i Yesus, taena, “Tabea', oo tomundo' na lipu' Yahudi!” ");
INSERT INTO blzNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kasi ia pool i raaya'a a takala' ni Yesus tia tokon ka' ni'inori, kasi nobanintuur ka' nonsoosa' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Noko daa i Yesus nibibiani, ia ukatimo i raaya'a a juba-Na men kakamumu', kasi nipopisokikon a pakean-Na soosoodo. Noko daa iya'a, kasi ni'uarkon kada' bo saliipkonon. ");
INSERT INTO blzNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tempo iya'a, isian sa'angu' mian nolumiu, ngaanna ai Simon, samba Kirene, tama ni Aleksander tii Rufus. Ia baasi sai takana na kota. Liuliu ia pakisaa i raaya'a mamasa'an saliip ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesus ia wawamo i raaya'a na sa'angu' tampat men ngaanon Golgota, aratina: Tampat Lamasna Takala'. ");
INSERT INTO blzNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kasi i Yesus ia tarai i raaya'a anggur nibaur muur pakuli' pangalalapi polos, kasee ia nobude' ninginum. ");
INSERT INTO blzNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Noko daa iya'a, ia saliipkonmo i raaya'a i Yesus. Kasi ni'obo-obos a pakean-Na, ka' ni'undi bo pinginti'ian too i ime a men mangala. ");
INSERT INTO blzNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nansaliipkonan i Ia, na jaam 9 ma'ulop. ");
INSERT INTO blzNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mbali' i Ia ni'ukum, daa piile'on na tulisan men nipakampa' inda'a na saliipna, men nitulis: Tomundo'na Lipu' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Singkat tii Ia uga' isian rurua' mian puraga nisaliipkon, sa'angu' paraas uanan-Na ka' sa'angu' paraas kauri'-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ka' koiya'a, nosidamo a men nitulis na Alkitaap, taena, “Ia uga' tonsoop saa'na mian men ba'idek a gau'na.” ");
INSERT INTO blzNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mian men lumiu inda'a ningililokkon takala'na ka' mingiroki i Yesus. Raaya'a norobu taena, “Wee i Koo men bo munguruntuni Laiganna Alaata'ala ka' tongko' tolu' ilio pokoowonmo patindongon soosoodo, ");
INSERT INTO blzNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","palau na saliiwip kanono' ka' salamatkon a wakaam.” ");
INSERT INTO blzNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Koiya'a uga' tanaasna imam tia wawa ukum Torat ningiroki i Yesus. Raaya'a nopootundunii simbaya'na, taena, “Mian sambana pokoon-Na salamatkonon, kasee waka-Na sian pokoon-Na salamatkonon! ");
INSERT INTO blzNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kalu i Koo tuutuu' Tomundo' Pansalamatkon, Tomundo' na Israel, ansee koini'i palau na saliip kanono' kada' piile'onmai ka' parasayaonmai.” Mau rurua' mian men nisaliipkon singkat i Yesus uga' mangaani i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na jaam duablaas, nopintungmo a longkop libutan iya'a pataka jaam tiga. ");
INSERT INTO blzNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ka' na jaam tiga i Yesus nangkakaro'mo men boolak tae-Na, “Eli! Eli! Lema sabakhtani?” Aratina: Alaata'alang-Ku! Alaata'alang-Ku! Nongko'upa se' i Kuu mandalai i Yaku'? ");
INSERT INTO blzNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nomorongor iya'a, toropii mian men potokerer iraando'o norobu taena, “Rongor, Ia mengeleelo' i Elia.” ");
INSERT INTO blzNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Liuliu nomae' a mian sa'angu' nangala garanggan mongura' ka' nongorom na anggur makarang, kasi ia potoor na kau ka' nisoorkon waara'a, mimi'inumi i Yesus. Kasi norobu taena, “Daa, peperaionta ka' piile'on too i Elia taka mantaro' i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Noko daa iya'a, Yesus nangkakaro'mo boolak kasi nopudul a noa-Na. ");
INSERT INTO blzNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Singkat iya'a, toik pongola' na Laiganna Alaata'ala nokoberak rua' inda'ana tudun indo'ona. ");
INSERT INTO blzNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tempo tanaasna surudadu men nokumekerer na arop ni Yesus, nimiile' lalapus-Na se' koiya'a ka' nopudulmo a noa-Na, mbaka' ia norobumo taena, “Mian kani'i tuutuu' Anakna Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Isian uga' toro pii wiwine men montoa'i na ko'oloaan. Raaya'a ai Maria Magdalena, Salome, ka' i Maria sina ni Yakobus men itiu' tii Yoses, ka' isian uga' men sambana. ");
INSERT INTO blzNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wiwi' irana nongololo'mo i Yesus ka' nangkalesang tempona i Ia na Galilea. Ka' isian wiwine sambana iraando'o men noko takamo na Yerusalem tii Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Guntumalom notakamo, ka' ilio iya'a ilio batoropotan men montorumpaki ilio Sabat. ");
INSERT INTO blzNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mbaka' Yusuf, samba Arimatea, sa'angu' mianna Mahkama Agama men tongaan, men uga' mempeperai Batomundo'anna Alaata'ala, nambaranikon noana mae' ni Pilatus ka' mama'ase' biibii ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus nosamba' nongorongor se' i Yesus nolapusmo. Mbaka' ia nengeleelo'mo tanaasna surudadu ka' nimikirawar na ko'ona too nolapusmo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sarataa ia rongor na tanaasna surudadu se' koiya'a, ai Pilatus namatalaimo i Yusuf mondolo' biibii ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kasi i Yusuf ningili toik pobalun, ka' noko daa iya'a, ia taro'konmo a biibii ni Yesus men na saliip ka' nambalun tia toik pobalun. Pobalun iya'a, toik lenang a niwawau. Kasi ia nomotokol biibii ni Yesus na baleanan men nipa'atkon na buu'na watu. Noko daa iya'a, ia ningilinda'mo watu ka' nongompodi soopanna baleanan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena tii Maria sina ni Yoses nimiile' i Yesus nipotokol na baleanan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sarataa noporus a ilio Sabat, ai Maria Magdalena, Salome, ka' i Maria sina ni Yakobus, ningilimo rampa bo pintimbu'i biibii ni Yesus na lalomna baleanan. ");
INSERT INTO blzNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na Minggu, ilio tumbena minggu iya'a, ma'ulo'-ulop bete' a ilio, raaya'a nomae'mo na baleanan. ");
INSERT INTO blzNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Raaya'a nopootunduniimo, taena, “Ai ime inta' a bo pingilinda'kon i kita watu men na soopanna baleanan?” ");
INSERT INTO blzNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kasee karani'mo i raaya'a, ia piile' a watu men balaki' tuu' iya'a noko tolinda'mo. ");
INSERT INTO blzNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Liuliu raaya'a ninsoop na baleanan. Ia piile' i raaya'a paraas uananna isian sa'angu' anak malai mojuba bubulak umoruang paraas uanan. Raaya'a notongkodi' tuu'. ");
INSERT INTO blzNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kasee anak malai iya'a liuliu norobu na ko'ona i raaya'a, taena, “Alia layaon! Kuu mansarak i Yesus samba Nazaret men nisaliipkon iya'a. Ia notuo'mo soosoodo. Ia sianmo kani'i. Piile'! Kani'i a tampat men nomotokolanna i raaya'a i Ia. ");
INSERT INTO blzNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kasee koini'i, rae' i kuu, bantilkon murit-Na ka' i Petrus, inta', ‘Ai Yesus mongolukoni i kuu na Galilea. Ntu'uasi ka' piile'onmuu i Ia, koi men Ia poko bantilkonmo i kuu itaan.’ ” ");
INSERT INTO blzNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Raaya'a liuliu no'umuar ka' notumetende' namarerei baleanan iya'a, gause notongkodi' ka' nolayaon tuu'. Raaya'a sian nontootundun upa-upa na sa'angu'po mian, supu-supuanna nolayaon. 16:9-11  ");
INSERT INTO blzNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sarataa i Yesus notuo' soosoodo, na Minggu ma'ulo'-ulop, na ilio tumbena na minggu iya'a, tumbena tuu', Ia nintipiile' ni Maria Magdalena, men mbaripian ia buse'i i Yesus a meena pipitu' men nangalampingi i ia. ");
INSERT INTO blzNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kasi i Maria Magdalena nomae' nambantilkon na mian men sinampang mongololo' i Yesus, men tempo iya'a dauga' masiongo' ka' wiri. ");
INSERT INTO blzNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ia rongor i raaya'a se' i Yesus notuo'mo soosoodo ka' ia piile'mo i Maria Magdalena, kasee i raaya'a dauga' sian mamarasaya. ");
INSERT INTO blzNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Noko daa koiya'a, isian murit ni Yesus rua' ira no'umuar namarerei kota. Yesus nintipiile' na ko'ona i raaya'a see poosasala' tia nintipiile'-Na ni Maria Magdalena. ");
INSERT INTO blzNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Raaya'a nomule'konmo ka' nambantilkon simbaya'na, kasee i raaya'a dauga' sian mamarasaya. ");
INSERT INTO blzNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Komburi'na ia nintipiile'mo na murit-Na men sompulo' sa'angu' ira iya'a, na tempo i raaya'a pintanga' kumaan. Ya'asi kasi ia sasala' i Yesus a men sian laan parasaya, ka' men baroan a noana, sian mamarasaya mian men noko pimiile'mo i Yesus men notuo'mo soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kasi i Yesus norobu na ko'ona i raaya'a, tae-Na, “Rae' i kuu na longkop tano' balaki' ka' lelekon a Lele Pore bona giigii' mian. ");
INSERT INTO blzNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mian men parasaya ka' saranion, ia bo salamatkonon. Kasee mian men sian parasaya, bo ukumon. ");
INSERT INTO blzNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mian men parasaya bo mingilimang oosan koi kani'imari: Ngaan-Ku a bo pumbuse'ina i raaya'a meena. Raaya'a morobu tia wurung men sian inti'ionna i raaya'a, ");
INSERT INTO blzNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ka' mau mingintoni ule, kabai se' minginum rasung, raaya'a sian nongko'upa. Ka' mian manggeo, kalu epetonna i raaya'a tia limana, sida malesi'.” ");
INSERT INTO blzNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Noko daa i Tumpu Yesus norobu koiya'a na ko'ona i raaya'a, Ia notoleengketmo waara'a na surugaa, kasi no'umoruang paraas uananna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mbaka' murit ni Yesus nomae'mo mengelelekon Lele Pore na longkop tano', ka' Tumpu uga' muntulung i raaya'a, ka' mompotuutuu' Lele Pore tia oosan men ia limang i raaya'a.");
INSERT INTO blzNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teofilus men angga'ion! Biai'mo a mian nampari-pari nunsusun ka' nuntulis lelena upa giigii' men nosida na ko'onta, ");
INSERT INTO blzNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","koi men ia tundunkon mian men daa nimiile' tumbe-tumbenapo upa men nosida, ka' komburi'na nengelelekon lele iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Noko daa yaku' sarak pore-pore a upa men tuutuu'na nosida na tumbenapo, yaku' munsurikon pore kalu muntulis ka' mangawawau kitap men susunon pore-pore boni Tuan, ");
INSERT INTO blzNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kada' inti'ion ni Tuan se' upa men nipisiso'kon na ko'omuu, nono' tuutuu' kana'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tempo batomundo'an ni Herodes na Yudea, isian imam men ngaanna i Zakharia. Ia tonsoop tompukanna imam Abia. Ngaanna boroki'na i Elisabet men lee' ni Imam Harun. ");
INSERT INTO blzNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Rua-rua' irana tutuo'na sintutu' tia po'uusna Alaata'ala, malolo' na potoo-Na ka' titiu'po sianta idekna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kasee i raaya'a sian no'anakon, gause i Elisabet kamba' ka' uga' rua-rua' irana umurmo. ");
INSERT INTO blzNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na sa'angu' tempo, tompukanna imam Abia a men bo balimang na Laiganna Alaata'ala, ka' i Zakharia bo pingilimang palimangonna Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Gause nokana' undi koi men doodoopo bo pinginti'ian too imam ime a men bo pingilimang, mbaka' ia uga' ninsoopmo na Laiganna Alaata'ala ka' nuntunu kamangian. ");
INSERT INTO blzNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pintanga' i Zakharia muntunu kamangian na lalomna Laiganna Alaata'ala, giigii' mian nobarimpungmo na liwana ka' nosambayang. ");
INSERT INTO blzNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na tempo iya'a, malaa'ikatna Tumpu nintipiile'mo ni Zakharia kere-kerer paraas uanan na mesba puntunuan kamangian. ");
INSERT INTO blzNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nimiile' men koiya'a, tongkodi' i Zakharia, mbaka' i ia nolayaonmo. ");
INSERT INTO blzNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Malaa'ikat iya'a norobumo taena, “Zakharia, alia layaon! Pa'ase'em na sambayaang daa ia loloikonmo Tumpu. Boroki'im bo mangamea'kon sa'angu' anak moro'one bo ko'oom, ka' i ia tiodaa ngaanion i Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Koo bo beles tuu', ka' uga' biai' a mian bo mongkobeleskon kongamea'anna. ");
INSERT INTO blzNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ia bo sida mian moola' koi pimiile'na Alaata'ala. Ia sian sida minginum anggur kabai se' minginum upa kolio', ka' uga' na kompongpo i ia bo bariosonna Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ia bo mimisiso' mian biai' na Israel kada' mule'kon malolo' na Alaata'ala, Tumpuna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ia taka mongolukoni Tumpu ka' noana tia kuasana koi noa tia kuasa ni Elia. Ia bo mompooka'amatikon tama tia anakna ka' mombolii gau'na mian men ba'idek kada' sida mian ma'amat. Ia bo mingilimang koiya'a kada' daa mian batoropot bona Tumpu.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakharia norobumo na malaa'ikat iya'a taena, “Koi upa kada' yaku' sida mamarasaya men koiya'a? Yaku' langkai'mo ka' boroki'ku uga' boroki'mo.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ia simbati malaa'ikat iya'a taena, “Yaku' i Gabriel men balimang na Tumpu. Yaku' ia posuu' Tumpu morobu ka' mengelelekon lele pore kani'i na ko'oom. ");
INSERT INTO blzNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Upa men yaku' porobukonmo bo sida kalu temponamo. Kasee ka' i koo sian mamarasaya, mbaka' i koo bo sida umu' pataka sida a men koi taengku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tempo iya'a, biai' a mian inde'e na liwana mempeperai i Zakharia. Raaya'a samba' gause i Zakharia nanau' tuu' na lalomna Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tempo i Zakharia no'umuar, ia sianmo ninsida norobu na ko'ona i raaya'a, mbaka' ia inti'imo i raaya'a se' i Zakharia nimiile'mo simpalaalung na lalomna Laiganna Alaata'ala. Ia somo mosaasiso' gause no'umu'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Noko daa i Zakharia ningilimang palimangonna na Laiganna Alaata'ala, ia nomule'konmo na laiganna. ");
INSERT INTO blzNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Sian paraa nanau', Elisabet nampaiwawamo. Koi lima' bitu'on ia sian nintipiile' na mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Taena i Elisabet, “Tumpu nuntulungmo i yaku', gause i Ia nanganuikonmo maa'ku na mian biai'.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Konoomna bitu'on a nampaiwawaan ni Elisabet, Alaata'ala nomosuu'mo malaa'ikat Gabriel mae' na Nazaret, sa'angu' kota na tano' Galilea, ");
INSERT INTO blzNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","mae' na sa'angu' laandue' men sianpo nontoo poobeel tia moro'one. Ngaanna laandue' iya'a i Maria. Ia ndoloi ni Yusuf men lee' ni Daud. ");
INSERT INTO blzNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaa'ikat iya'a notakamo ni Maria ka' norobu taena, “Tabea' na ko'oom, wiwine men nibarakaati! Tumpu mandagai i koo.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nongorongor wurung koiya'a, tongkodi' i Maria. Ia nompoo'inurutikonmo se' upa a aratina tabea' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Taena malaa'ikat, “Maria, alia layaon, gause i koo kolingu'na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Koo bo mampaiwawa ka' mangamea'kon sa'angu' anak moro'one men tiodaa ngaanioon i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ia bo balaki' a kuasa-Na ka' bo ngaanon Anakna Alaata'ala men na ko'alayo'an. Tumpu Alaata'ala bo mongorookon na Ko'ona Batomundo'an ni Daud men puli-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ia bo pontomundo'i lee' ni Yakub pataka sidutu ka' batomundo'an-Na sian kokabu-kabusanna.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Taena i Maria na malaa'ikat iya'a, “Koi upa bo kosidana men koiya'a, gause i yaku' sianpo langakai'an?” ");
INSERT INTO blzNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ia simbati malaa'ikat iya'a taena, “Alus Molinas bo malau taka na ko'oom, ka' kuasana Alaata'ala men na ko'alayo'an bo mandagai i koo. Mbali' iya'a, Anak men bo ngamea'konoon tio ngaanon Molinas, Anakna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Imamat ini'imari! Ai Elisabet, poto'utusaan men ngaanonna mian se' kamba', mase nampaiwawamo ka' bo mangamea'kon sa'angu' anak moro'one. Koini'i kompongna noommo bitu'on. ");
INSERT INTO blzNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gause sianta upa men sian pokoonna Alaata'ala wawauon.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Taena i Maria, “Yaku' kani'i mase tongko' ata'na Tumpu. Bi sida na wakangku koi wurungmuu kanooro'o.” Kasi malaa'ikat iya'a namarerei i Maria. ");
INSERT INTO blzNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sian paraa nanau', ai Maria liuliu nomae'mo na sa'angu' kota men na buu'na Yehuda. ");
INSERT INTO blzNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Taka na laigan nari Zakharia, ia ninsoopmo ka' nantabe'i i Elisabet. ");
INSERT INTO blzNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sarataa i Elisabet nomorongor tabea' ni Maria, anak men na kompongna nogumiokmo, ka' i Elisabet uga' ia bariosmo Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ia norobumo boolak taena, “Tumpu nambarakaati i koo labi wiwine sambana, ka' nambarakaati Anak na kompoong kanono'. ");
INSERT INTO blzNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ime i yaku' kani'i mbali' daa leleongionna sinana Tumpungku? ");
INSERT INTO blzNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sarataa yaku' nomorongor tabea'am, anak men na kompongku kani'i lako-lako nogumiok gause nobeles. ");
INSERT INTO blzNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Barakaatan i koo, gause i koo parasaya se' upa men ia porobukon Tumpu na ko'oom bo sidakonon-Na.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Taena i Maria, “Yaku' muntunde' Tumpu, ");
INSERT INTO blzNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ka' noangku basukuur gause Alaata'ala, Pansalamatkon i yaku'. ");
INSERT INTO blzNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ia ningimamatmo i yaku', ata'-Na men talalais. Supu koini'i-waara'ana giigii' mian bo mangaan se' i yaku' nibarakaati, ");
INSERT INTO blzNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","gause Alaata'ala men Pungkuasai nangawawaumo upa men angga'an tuu' bona ingku'. Alaata'ala iya'a molinas. ");
INSERT INTO blzNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ka' lingu'-Na bo rookonon-Na sunsun ka' sunsun na mian men malolo' na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Na wawau-Na men kosamba', Ia mimpipiile'kon kuasa-Na mantabunsalang giigii' mian men mintidaa-daa. ");
INSERT INTO blzNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ia mamalaukon tomundo' men pintanga' batomundo', ka' manganakat mian men sian angga'ion. ");
INSERT INTO blzNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Men kololuan taraion-Na giigii' men pore bi kalabian, ka' Ia momosuu' mian kupangon mae' tia lima sompulo'. ");
INSERT INTO blzNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ia nuntulung Israel, ata'-Na, gause koiya'a a toon-Na men Ia toonkonmo na pulinta. ");
INSERT INTO blzNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tumpu sian mongkolimbo'i toon-Na. Ia molingu'kon i Abraham tia lee'na pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria nodumodongo ni Elisabet koi tolu' bitu'on a nau'na, kasi nomule'kon na dodongoanna. ");
INSERT INTO blzNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sarataa temponamo bitu'on ni Elisabet mindompu', mbaka' i ia nangamea'konmo sa'angu' anak moro'one. ");
INSERT INTO blzNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tempo pootolodoianna ka' poto'utusanna nongorongor se' Tumpu nongkolingu'kon i Elisabet, raaya'a uga' nobelesmo koi i Elisabet. ");
INSERT INTO blzNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sarataa walu'mo ilio a nongamea'anna anak iya'a, pootolodoianna ka' poto'utusanna notakammo munsunat anak iya'a. Raaya'a mingkira' mangaani anak iya'a i Zakharia koikoimo tia ngaanna tamana. ");
INSERT INTO blzNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kasee taena sinana anak iya'a, “Alia! Ia tiodaa ngaanion i Yohanes.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Taena i raaya'a ni Elisabet, “Poto'utusanmuu sian isian ngaan men koi nooro'o.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kasi i raaya'a nosaasiso' mimikirawar ni Zakharia too ime a bo pangaanina anakna. ");
INSERT INTO blzNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakharia nama'ase'mo watu bo puntulisan ka' nuntulis koi kani'imari: “Ngaanna i Yohanes.” Raaya'a giigii' nosamba'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na tempopo iya'a i ia lako-lako ninsida norobu soosoodo ka' nuntunde' Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mbaka' natakutmo a giigii' mian men pootolodoi tii raaya'a. Kasi upa men nosida iya'a notolele na longkop libutan na buu'na Yudea. ");
INSERT INTO blzNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Giigii' i raaya'a men nomorongor lele iya'a ningintomkonmo ka' norobu taena, “Se' bo sida upa a anak kani'i na ilio komburi'?” Gause Tumpu mandagai i ia. ");
INSERT INTO blzNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakharia, tama ni Yohanes, ia bariosmo Alus Molinas. Ia nuntundunkon upa men bo sida na ilio komburi', taena, ");
INSERT INTO blzNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tontunde' a Tumpu, Alaata'alana lipu' Israel, gause i Ia muntulung mian-Na kada' salamat. ");
INSERT INTO blzNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ia mongorookon na ko'onta' Pansalamatkon men tingkai, men ringkat na lee' ni Daud men ata'na Tumpu, ");
INSERT INTO blzNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","koi men mbaripian ia tundunkon nabii men molinas. ");
INSERT INTO blzNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kita bo tulungonna Pansalamatkon iya'a kada' sianmo kuasaionna giigii' mian men maso'kon i kita. ");
INSERT INTO blzNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Alaata'ala mimpipiile'kon lingu'-Na na pulinta, ka' toon-Na men molinas iya'a loloikonon-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ya'amo a sumpa' men Ia toonkonmo ni Abraham pulinta se' i Ia bo mongkolingu'kon i kita, ");
INSERT INTO blzNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kada' kita tonsapu na mian men maso'kon i kita ka' sianmo pata-patakut monsoosa' i Ia, ");
INSERT INTO blzNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kasee i kita sidamo monsoosa' i Ia tia noa men maloos ka' molinas tempo i kita dauga' tumuo' na tano' balaki'. ");
INSERT INTO blzNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka' i koo, anakku, bo ngaanonna mian nabiina Alaata'ala men na ko'alayo'an, gause i koo bo sumalan mongolukoni Tumpu ka' mantatas salan bo Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Koo bo mimisiso'kon na mian-Na sasalanna Alaata'ala mansalamatkon i raaya'a tia mangampuni dosana i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Barakaat tia lingu'na Alaata'ala bo taka na ko'onta' mansalamatkon i kita. Koi ruarna ilio ma'ulo-ulop men ringkat na ko'alayo'an, ");
INSERT INTO blzNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","koiya'a uga' i Ia bo mintingkari giigii' mian men tumuo' na kapintungan ka' layaonkon lapus, kasi momosalan i kita na salan men ma'amat.” ");
INSERT INTO blzNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anak ni Zakharia iya'a no'uminsurmo ka' imaanna kaekae' moonggor. Ia dumodongo na tano' maleas pataka tempona i ia umuar mintipiile' na lipu' Israel. ");
INSERT INTO blzNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na tempo iya'a, Kaisar Agustus men montomundo'i Batomundo'anna Roma, nomosuu' kada' muntulis ka' mansaa' giigii' mianna. ");
INSERT INTO blzNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nuntulisan ka' nansaa'an kobiai'na mian iya'a nilimang tempo i Kirenius Gubernuur na Siria. ");
INSERT INTO blzNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Giigii' mian uga' nomae'mo na kotana sanda-sanda' kada' tulison a ngaanna bo saa'on. ");
INSERT INTO blzNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Koiya'a uga' i Yusuf ringkat na kota Nazaret, na libutan Galilea, mae' na libutan Yudea, na kota Betlehem men nongamea'an ni Tomundo' Daud, gause i ia tonsoop lee' ni Daud. ");
INSERT INTO blzNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yusuf nonsoopkonmo ngaanna rua' ira tii Maria men ndoloina bo saa'on. Tempo iya'a i Maria mampaiwawamo. ");
INSERT INTO blzNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sarataa i raaya'a na Betlehem, notakamo a tempona i Maria mindompu. ");
INSERT INTO blzNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ia nangamea'konmo sa'angu' anak moro'one, anakna men balaki'na. Anak iya'a ia pokalimbutimo tia toik ka' nipotokol na pamakaanan ayop, gause raaya'a sian nantausi laigan bo torumpakanna. ");
INSERT INTO blzNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na sa'angu' dodongoan men karani' dodongoan iya'a, isian toropii pontondong domba men mandagai lulusanna domba na padang tempo malom. ");
INSERT INTO blzNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ola-olan taka a malaa'ikatna Tumpu kere-kerer karani' i raaya'a ka' ruarna Tumpu dingkalapan nunguruari i raaya'a, ka' i raaya'a nolayaonmo tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kasee malaa'ikat iya'a norobu taena, “Alia i kuu layaon. Mbali' i yaku' notaka ka'ita mase mambantilkon na ko'omuu lele pore men kobeles tuu' bona mian na giigii' lipu'. ");
INSERT INTO blzNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ilio kani'i na kota ni Daud nongamea'mo a men bo Pansalamatkon i kuu, men i Kristus, Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Koi kani'imari a bo oosanmuu: Kuu bo mungurumpaki sa'angu' anak ngamea' men nipokalimbuti tia toik ka' nipotokol na pamakaanan ayop.” ");
INSERT INTO blzNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ola-olan ia piile' i raaya'a a malaa'ikat iya'a nobiai'mo a samba-sambana men muntunde' Alaata'ala taena, ");
INSERT INTO blzNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tontunde' a Alaata'ala na ko'alayo'an, ka' bi pooka'amat a mian na tano' balaki' kani'i men kokana'na Tumpu.” ");
INSERT INTO blzNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Noko daa iya'a, giigii' malaa'ikat nomae'mo mule'kon na surugaa. Pontotobo' domba iya'a nopootunduniimo simbaya'na taena, “Mai kita mae' na Betlehem mimiile' upa men nosida iya'a, koi men ia bantilkon Tumpu na ko'onta'.” ");
INSERT INTO blzNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Raaya'a lako-lako nomae' ka' nuntuungi i Maria tii Yusuf ka' anak ngamea' men nipotokol na pamakaanan ayop. ");
INSERT INTO blzNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sarataa nimiile' anak ngamea' iya'a, raaya'a nuntundunmo tundunanna malaa'ikat men nambantilkon anak ngamea' iya'a na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Giigii' i raaya'a nosamba' nongorongor tundunanna pontondong domba iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kasee i Maria tongko' nongoos na noana lele men ia rongor iya'a ka' ningintoomkon pore-pore. ");
INSERT INTO blzNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pontotobo' domba iya'a nomule'konmo na dodongoanna. Ka' banta-bantang mule'kon, raaya'a muntunde' ka' mompopobalaki' Alaata'ala gause giigii' men ia piile' ka' ia rongor i raaya'a, sintuutuu' tia upa men ia bantilkon malaa'ikat na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Walu'mo ilio a nongamea'anna Anak iya'a, Ia nisunatmo ka' ia ngaani i raaya'a i Yesus, ngaan men ia bantilkon malaa'ikat bo Ko'ona men koo'po tia ia pintipu'unkon sina-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Takamo tempona i Yusuf tii Maria mongoloe'i waka koi aturanna ukum Torat ni Musa. Raaya'a nangawawamo i Yesus mae' na Yerusalem bo rookonon na Tumpu, ");
INSERT INTO blzNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","gause isian nitulis na kitap ukumna Tumpu koi kani'imari: “Giigii' anak moro'one men balaki'na tiodaa rookonon bona Tumpu.” ");
INSERT INTO blzNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Raaya'a uga' nomae' nangatorkon kurbaan koi men taena ukumna Tumpu, men sapaar sapu' sapatau kabai se' rua' sapu' marampatii. ");
INSERT INTO blzNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na tempo iya'a isian sa'angu' mian na Yerusalem men ngaanna i Simeon. Ia mian men kana' a wawauna, malolo' na Tumpu, ka' kuasana Alus Molinas uga' isian na ko'ona. Ia mempeperai tempona Alaata'ala mansalamatkon Israel. ");
INSERT INTO blzNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Alus Molinas nambantilkonmo na ko'ona se' i ia sianpo lapus kalu sianpo mimiile' Tomundo' Pansalamatkon men ia toonkon Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gause pingkira'na Alus Molinas, mbaka' i Simeon ninsoopmo na Laiganna Alaata'ala. Na tempo iya'a uga' i Yusuf tii Maria ninsoopmo nangawawa i Yesus men dauga' ngamea' mongololoikon adat koi men nipisiso'konmo na ukum Torat. ");
INSERT INTO blzNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon nangalamo Anak iya'a ka' nantaawan, kasi nuntunde' Tumpu Alaata'ala taena, ");
INSERT INTO blzNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tumpu, koini'i Kuu sidakonmo a toon-Muu. Patalaimo a ata'-Muu kani'i lapus pore-pore. ");
INSERT INTO blzNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gause matangku suungku nimiile'mo Pansalamatkon men Kuu takakon. ");
INSERT INTO blzNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pansalamatkon iya'a Kuu poko toropotikonmo bona giigii' lipu'. ");
INSERT INTO blzNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iamo a Ruar men bo pompopo'inti'ikon Alaata'ala na lipu' sambana ka' men bo pinsidakon lipu'-Muu Israel angga'ion.” ");
INSERT INTO blzNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tama tia sina ni Yesus samba' nongorongor giigii' upa men ia porobukon i Simeon muntundun Anakna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon nambarakaatimo i raaya'a ka' nambantilkon ni Maria taena, “Imamat ini'imari! Anak kani'i ia patukmo Alaata'ala bo pinsilaka'i ka' uga' bo pansalamatkon mian biai' na Israel. Ia sida bookoi oosna Alaata'ala, ka' bo minsidakon poogagaianna mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mbaka' ka'inti'ianmo a isiina noana mian biai'. Siongo' men bo surioon ni'imarian somo koi piso' mungusuk suloowom.” ");
INSERT INTO blzNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Indo'o isian sa'angu' nabii wiwine men boroki'mo tuu', ngaanna i Hana. Ia anak ni Fanuel men bense' ni Asyer. Tongko' pitu' taun a nosuo'anna ka' nopoololo'anna tia langkai'na, ");
INSERT INTO blzNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ia nobalumo ka' umurna walumpulo'mo papaat taun. Ia tongko' dongo-dongo na Laiganna Alaata'ala, ka' ilio malom tongko' bakitumpu, ba'apata ka' basambayang. ");
INSERT INTO blzNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na tempo iya'a i Hana uga' notaka na ko'ona i raaya'a ka' nobasukuur na Alaata'ala, kasi ia nuntundunkon Anak iya'a na giigii' mian men mempeperai kotakaanna Tumpu mansalamatkon Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Noko daa i Yusuf tii Maria ningilimang upa men tiodaa limangon koi taena ukumna Tumpu, raaya'a nomule'konmo na dodongoanna na kota Nazaret, na libutan Galilea. ");
INSERT INTO blzNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Anak iya'a no'uminsurmo ka' kaekae' motikol. Ia pande tuu' ka' kolingu'na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sanda' taun tama tia sina ni Yesus mae' na Yerusalem mangaramekon ramean Paska. ");
INSERT INTO blzNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na tempo umur ni Yesus sompulo'mo rua' taun, raaya'a nomae'mo na Yerusalem koi men doodoopo wawauonna i raaya'a sanda' taun. ");
INSERT INTO blzNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Noko daa ramean Paska, raaya'a nomule'konmo. Kasee sian ia inti'i tama-Na tia sina-Na se' i Ia dauga' nintitako' na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Raaya'a mongooskon se' i Ia isian nopoololo' tia mian biai'. Sangiliosi a nomae'anna i raaya'a, kasi i raaya'a nansarak i Ia too daa nomae' poololo' tia poto'utusanna kabai se' poo'inti'ianna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kasee sian ia tausi i raaya'a. Mbaka' i raaya'a nomule'konmo soosoodo na Yerusalem mae' mansarak i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sarataa tolungilio kasi ia tausi i raaya'a na lalomna Laiganna Alaata'ala. Ia oru-oruang na tanga'na guru agama Yahudi. Ia momorongori i raaya'a batundun ka' uga' bapikirawar na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Giigii' mian men nomorongor i Ia nosida samba' gause i Ia pande tuu' minsimbati. ");
INSERT INTO blzNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Minti'i-Napo samba' nimiile' i Ia. Mbaka' sina-Na norobumo na Ko'ona taena, “Anakku, nongko'upa i Koo se' mangawawau koi kani'i na ko'omai? Tamaam tii yaku' noleapkonmo i Koo!” ");
INSERT INTO blzNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ia simbati i Yesus tae-Na, “Nongko'upa mbali' i kuu muntuus i Yaku'? Too sian kuu inti'i se' Yaku' tiodaa ka'ita na Laiganna Tamang-Ku?” ");
INSERT INTO blzNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kasee i raaya'a sian ninginti'i patukna wurung ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Noko daa iya'a ai Yesus nomule'konmo poololo' tii raaya'a mae' na Nazaret. Ia dauga' dongo-dongo na tama tia sina-Na ka' malolo' na ko'ona i raaya'a. Sina-Na nongoosmo na noana giigii' upa men ia piile' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus kaekae' uminsur, kapandean-Na uga' kaekae' kanturangan, ka' kaekae' balaki' a polingu'na Alaata'ala tia mian na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na kosompulo'na lima' taun batomundo'an ni Kaisar Tiberius, Pontius Pilatus nosidamo gubernuur na libutan Yudea, ka' i Herodes montomundo'i libutan Galilea. Filipus men utus ni Herodes montomundo'i libutan Iturea ka' libutan Trakhonitis, ka' i Lisanias montomundo'i libutan Abilene. ");
INSERT INTO blzNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na taun iya'a, Hanas tii Kayafas nosida Imam Moola'. Tempo iya'a Alaata'ala norobumo na tano' maleas na ko'ona i Yohanes men anak ni Zakharia. ");
INSERT INTO blzNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mbaka' nomae'mo i Yohanes na longkop tano' Yordan ka' nuntundunkon lelena Tumpu taena, “Sosoli ka' kadarai a gau'muu men ba'idek, ka' i kuu tio saranion kada' Alaata'ala mangampuni dosamuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Pisiso' ni Yohanes iya'a sintutu' koi men nitulis na kitap ni Nabii Yesaya men koi kani'imari: “Bo isian sa'angu' mian na tano' maleas mengeleelo'kon ka' mambantilkon taena, ‘Toropoti a salan bona Tumpu; loosikon a salan bo Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sanda' leokna bo tabunion ka' sanda' buu'na bo lempation. Salan men mangkailekut bo loosion, ka' salan men mangkailebok bo tabunion. ");
INSERT INTO blzNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Giigii' mian na longkop tano' balaki' bo mimiile' pansalamatkonna Alaata'ala mian.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Biai' a mian men notaka ni Yohanes mikisarani. Taena i Yohanes, “Wee i kuu men koi lee'na ule ba'idek! Ime a men nambantilkon na ko'omuu se' i kuu sian kana'onna ukumanna Alaata'ala na ilio komburi'? ");
INSERT INTO blzNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pipiile'kon a wawaumuu se' i kuu daa nonsosolimo ka' nangkadaraimo gau'muu men ba'idek! Alia mongooskon na noamuu se' i kuu bo tonsapu na ukuman montookon i Abraham daa pulimuu. Bantilkononku na ko'omuu se' watupo karaani'i sida wawauonna Alaata'ala bo lee' ni Abraham! ");
INSERT INTO blzNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Usong noko toropotmo bo pantara' kau pataka na wakatna. Sanda' kau men sian miwoo'kon woo' men pore sabole bo tara'ion ka' tibarkonon na apu.” ");
INSERT INTO blzNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mian biai' nimikirawarmo ni Yohanes taena i raaya'a, “Ka' kalu koiya'a, upa a men tiodaa wawauonmai?” ");
INSERT INTO blzNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ia simbati i Yohanes taena, “Ime a men isian bokukum rurua', ia tiodaa mongobosii mian men sian bokukumna, ka' i ime a men daa kakaanan, ia uga' tiodaa poo'obos.” ");
INSERT INTO blzNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Isian uga' toropii pagawena pajak men notaka mikisarani. Raaya'a nimikirawar ni Yohanes taena, “Guru, upa a men tiodaa wawauonmai?” ");
INSERT INTO blzNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Taena i Yohanes, “Alia mama'ase' labian koi men nibantilkonmo na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ka' isian uga' toropii surudadu men nimikirawar na ko'ona taena i raaya'a, “Ka' i kai, upa a men tiodaa wawauonmai?” Ia simbati i Yohanes taena, “Alia aribiru ka' alia mangakali mian kada' taraionna upa-upa, kasee ala tongko' koi tambomuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tempo iya'a, noana mian biai' mansarui i Yohanes, too iamo a Tomundo' Pansalamatkon men peperaionna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mbaka' i Yohanes norobumo na ko'ona i raaya'a taena, “Yaku' mansarani i kuu tia weer, kasee i Ia men balaki'na kuasa tii yaku' bo taka, ka' mangalakaipo kookootna sapato-Na, yaku' koo'. Ia bo mansarani i kuu tia Alus Molinas ka' tia apu. ");
INSERT INTO blzNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ia noko into-intonmo ikiran bo pantaapi giigii' gandum-Na pataka moloe'. Gandum bo soopkonon-Na na alang-Na, kasee ota'na bo tunuon-Na na apu men sian pokoon papateion.” ");
INSERT INTO blzNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Biai' kaliangan a nambantili ni Yohanes mian biai' na tempo ia nengelelekon Lele Pore. ");
INSERT INTO blzNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kasee ka' i Yohanes nambantili i Herodes, men tomundo' na libutan Galilea, gause i Herodes nosuo' tii Herodias boroki'na utusna, ka' uga' gause giigii' idek men ia wawaumo, ");
INSERT INTO blzNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","mbaka' i Tomundo' Herodes tongko' nunturangi idekna soosoodo, gause i ia nonsoopkon i Yohanes na tarungkuan. ");
INSERT INTO blzNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sarataa giigii' mian iya'a ia sarani Yohanes, Yesus uga' nisarani. Noko daa i Yesus nisarani, pintanga' i Ia basambayang, langit nokobongkatianmo. ");
INSERT INTO blzNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Alus Molinas nalaumo na Ko'ona koi marampatii. Kasi nokamporongoran a wurungna Alaata'ala nda'amari langit tae-Na, “Koomo a Anak-Ku men kolingu'-Ku, ka' i Koo a men daa kokana'-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na tempo i Yesus nuntumbei palimangon-Na, umur-Na toro tolumpulo'mo taun. Koi pinginti'ina mian, Ia anak ni Yusuf, Yusuf anak ni Eli, ");
INSERT INTO blzNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli anak ni Matat, Matat anak ni Lewi, Lewi anak ni Malkhi, Malkhi anak ni Yanai, Yanai anak ni Yusuf, ");
INSERT INTO blzNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf anak ni Matica, Matica anak ni Amos, Amos anak ni Nahum, Nahum anak ni Hesli, Hesli anak ni Nagai, ");
INSERT INTO blzNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai anak ni Maat, Maat anak ni Matica, Matica anak ni Simei, Simei anak ni Yosekh, Yosekh anak ni Yoda, ");
INSERT INTO blzNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda anak ni Yohanan, Yohanan anak ni Resa, Resa anak ni Zerubabel, Zerubabel anak ni Sealtiel, Sealtiel anak ni Neri, ");
INSERT INTO blzNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri anak ni Malkhi, Malkhi anak ni Adi, Adi anak ni Kosam, Kosam anak ni Elmadam, Elmadam anak ni Er, ");
INSERT INTO blzNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er anak ni Yesua, Yesua anak ni Eliezer, Eliezer iya'a anak ni Yorim, Yorim anak ni Matat, Matat anak ni Lewi, ");
INSERT INTO blzNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi anak ni Simeon, Simeon anak ni Yehuda, Yehuda anak ni Yusuf, Yusuf anak ni Yonam, Yonam anak ni Elyakim, ");
INSERT INTO blzNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim anak ni Melea, Melea anak ni Mina, Mina anak ni Matata, Matata anak ni Natan, Natan anak ni Daud, ");
INSERT INTO blzNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud anak ni Isai, Isai anak ni Obed, Obed anak ni Boas, Boas anak ni Salmon, Salmon anak ni Nahason, ");
INSERT INTO blzNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason anak ni Aminadab, Aminadab anak ni Admin, Admin anak ni Arni, Arni anak ni Hezron, Hezron anak ni Peres, Peres anak ni Yehuda, ");
INSERT INTO blzNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda anak ni Yakub, Yakub anak ni Ishak, Ishak anak ni Abraham, Abraham anak ni Terah, Terah anak ni Nahor, ");
INSERT INTO blzNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor anak ni Serug, Serug anak ni Rehu, Rehu anak ni Peleg, Peleg anak ni Eber, Eber anak ni Salmon, ");
INSERT INTO blzNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon anak ni Kenan, Kenan anak ni Arpakhsad, Arpakhsad anak ni Sem, Sem anak ni Nuh, Nuh anak ni Lamekh, ");
INSERT INTO blzNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekh anak ni Metusalah, Metusalah anak ni Henokh, Henokh anak ni Yared, Yared anak ni Mahalaleel, Mahalaleel anak ni Kenan, ");
INSERT INTO blzNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan anak ni Enos, Enos anak ni Set, Set anak ni Adam, Adam anakna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus men ia bariosmo Alus Molinas namarereimo Weerkauna Yordan. Alus Molinas nangandaarkonmo i Ia na tano' maleas. ");
INSERT INTO blzNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ia dongo-dongo na tano' maleas patompulo' ilio a nau'na ka' i Ia ia topongi Ibiliis. Tempo na tano' maleas Ia sian notookaan upa-upa, ka' sarataa porus patompulo' ilio iya'a, Ia nololumo. ");
INSERT INTO blzNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibiliis norobumo na Ko'ona taena, “Gause i Koo Anakna Alaata'ala, alaka' posuu' a watu kani'i bi sida roti.” ");
INSERT INTO blzNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ia simbati i Yesus tae-Na, “Na Alkitaap isian nitulis koi kani'imari: ‘Mian taasi' tongko' tuo'kon roti.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kasi ia andaarkonmo Ibiliis i Yesus na tampat men alayo', ka' tongko' sangkudap mata Ibiliis ninsiso'kon na Ko'ona giigii' batomundo'an na tano' balaki'. ");
INSERT INTO blzNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ibiliis norobumo na Ko'ona taena, “Giigii' kuasa ka' kupang karaaro'o bo rookononku i Koo, gause giigii' iraaro'o nirookonmo na ingku' ka' i yaku' sida mongorookon na mian koi men kikira'ku. ");
INSERT INTO blzNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kalu i Koo monsoosa' i yaku', mbaka' giigii' kuasa ka' kupang karaaro'o bo tombonoioon.” ");
INSERT INTO blzNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ia simbati i Yesus tae-Na, “Na Alkitaap isian nitulis koi kani'imari: ‘Koo tio monsoosa' Tumpu Alaata'alanta, ka' tongko' i Ia a lolo'oon!’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Noko daa iya'a, Ibiliis nangawawamo i Yesus na Yerusalem ka' nongowoot i Ia na wuunganna Laiganna Alaata'ala, kasi norobu ni Yesus taena, “Kalu se' i Koo Anakna Alaata'ala, alaka' tumbur waaro'o! ");
INSERT INTO blzNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gause na Alkitaap isian nitulis koi kani'imari: ‘Alaata'ala bo momosuu' malaa'ikat-Na kada' mandagai i Koo pore-pore. ");
INSERT INTO blzNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Raaya'a bo mantanai i Koo tia limana dako' saraat tontutup na watu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ia simbati i Yesus tae-Na, “Na Alkitaap isian nitulis koi kani'imari: ‘Alia i koo mimitopongi Tumpu Alaata'alanta.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Noko daa Ibiliis nimitopongi i Yesus tia toropii kaliangan iya'a, ia namarereimo i Yesus ka' mempeperai tempo men pore. ");
INSERT INTO blzNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus ia bariosmo Alus Molinas ka' i Ia nomule'konmo na libutan Galilea. Ia notolelemo na longkop libutan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesus nimisiso'mo mian na toropii laigan bakitumpuan, ka' giigii' mian muntunde' i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus notaka na Nazaret na dodongoan men nobalaki'an-Na. Na ilio Sabat Ia ninsoopmo na laigan bakitumpuan koi men doodoopo wawauon-Na, kasi Ia nokumekerer mambasa Alkitaap. ");
INSERT INTO blzNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ia nitarai kitap Nabii Yesaya, ka' noko daa Ia kambangi a lulunanna kitap iya'a, Ia nantausi men nitulis koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Alusna Tumpu isian na Ingku', gause i Ia nengelengketmo Yaku' bo pengelelekon Lele Pore bona mian talalais. Ia nomosuu'mo i Yaku' mengelelekon se' mian men nirakop bo uarkonon, ka' mian men mampisok bo poopiile', ka' mian men nipo'ata' bo sida malewa, ");
INSERT INTO blzNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ka' mengelelekon kotakaanna Tumpu mansalamatkon mian-Na.” ");
INSERT INTO blzNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus nungululunmo soosoodo kitap iya'a ka' nungule'kon na mian men mandagai laigan bakitumpuan, kasi no'umoruang. Giigii' mian na laigan bakitumpuan iya'a rontos na pintiokian i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kasi i Ia nuntumbei mimisiso' i raaya'a tae-Na, “Na ilio kani'i nosidamo a isiina Alkitaap men baasi kuu rongor.” ");
INSERT INTO blzNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Giigii' mian iya'a kodaawankon i Ia, ka' men Ia wurungkon pore ka' kosamba'. Taena i raaya'a, “Taasi' i Ia kani'i anak ni Yusuf?” ");
INSERT INTO blzNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mbaka' i Yesus norobumomo tae-Na, “Sabole i kuu bo mangaan na Ingku' timbaani' koi kani'imari: ‘Dokter, lesi'i a wakaam kutung. Wawau ka'ita na dodongoaan a upa men kai rongormo isian Koo wawau na Kapernaum.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Taeni Yesus soosoodo, “Tuutuu' mba'a. Kasee bantilkonon-Ku na ko'omuu se' sianta nabii men angga'ion na dodongoanna suungna. ");
INSERT INTO blzNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Men bantilkonon-Ku na ko'omuu kani'imari tuutuu'. Na tempo ni Nabii Elia, isian koi tolu' taun noom bitu'on sian no'usan pataka ninsidakon pololuan men dodoa tuu' na longkop dodongoan. Tempo iya'a biai' a wiwine balu na Israel. ");
INSERT INTO blzNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mau mune' koiya'a, Elia sian niposuu' mae' muntulung wiwine balu na lipu' Israel, kasee niposuu' mae' na sa'angu' wiwine balu na Sarfat na tano' Sidon. ");
INSERT INTO blzNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Koiya'a uga' a na tempo ni Nabii Elisa, biai' a mian kustaon na lipu' Israel, kasee na ko'ona i raaya'a sianta sa'angu'po a mian men nilesi'i. Men nilesi'i tongko' i Naaman mian na lipu' Siria iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nongorongor koiya'a, giigii' mian men na laigan bakitumpuan iya'a nomaso'mo tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Raaya'a norumingkatmo, kasi nangaraap i Yesus umuar na kota ka' nangawawa na soripi'na liu' na kotana i raaya'a, bo tibarkononna. ");
INSERT INTO blzNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kasee i Yesus no'umuarmo nintingola' na ko'ona i raaya'a, kasi nomae'. ");
INSERT INTO blzNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kasi i Yesus nomae' na kota Kapernaum, na libutan Galilea. Inda'a i Ia nimisiso' mian na ilio Sabat. ");
INSERT INTO blzNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Raaya'a kodaawan nomorongor pisiso'-Na, gause wurung-Na kuasaan. ");
INSERT INTO blzNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na lalomna laigan bakitumpuan iya'a isian sa'angu' mian men ia lampingi meena. Mian iya'a nangkakaro'kon taena, ");
INSERT INTO blzNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oo Yesus samba Nazaret, upa a urusaan tii kai? Kabai i Koo taka bo pinsilaka'i i kai? Inti'ionku se' ime i Koo: Koo a men Molinas nda'ara'amari na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kasee i Yesus nengerengeaki meena iya'a tae-Na, “Pimporokot! Uarmo i koo na mian kanono'!” Mbaka' meena iya'a ningirimpa'konmo mian iya'a na tanga'na mian biai', kasi no'umuar namarerei mian iya'a, kasee daa sian nampapolosi i ia. ");
INSERT INTO blzNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Giigii' mian samba', ka' norobu na simbaya'na i raaya'a taena, “Kinopore tuu' a men Ia wurungkon! Ia nomosuu' meena umuar tia kuasa-Na men tongaan, ka' i raaya'a uga' somo no'umuar.” ");
INSERT INTO blzNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kasi notolele a wawau ni Yesus na longkop libutan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kasi i Yesus namarerei laigan bakitumpuan iya'a ka' nomae' na laigan ni Simon. Monian ni Simon men sinana boroki'na tempo iya'a suminggar dodoa ka' i raaya'a nama'ase' ni Yesus kada' muntulung i ia. ");
INSERT INTO blzNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mbaka' Ia nokumekerermo na soripi'na wiwine iya'a, kasi nongkokundakon suminggarna, mbaka' wiwine iya'a liuliu nalesi'. Wiwine iya'a liuliu nowangon, kasi nangkalesang i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sarataa ilio nosopokmo, giigii' mian nangawawamo mian men manggeo mae' ni Yesus. Nggeo men nangkana' i raaya'a biai' kaliangan. Yesus nengepetkon lima-Na na ko'ona i raaya'a sanda-sanda' ka' nengelesi'i. ");
INSERT INTO blzNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Meena' uga' no'umuarmo na mian biai' potokaro' taena i raaya'a, “Koomo a Anakna Alaata'ala.” Kasi i Yesus nongkokundakon i raaya'a ka' sian namatalai morobu, gause raaya'a ninginti'i se' i Yesus iya'a a Tomundo' Pansalamatkon. ");
INSERT INTO blzNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sarataa ma'ulo-ulop i Yesus norumingkatmo ka' nomae' na sa'angu' tampat men sianta mianna. Kasee mian biai' nansarak i Ia. Noko daa ia tausi raaya'a, raaya'a nampari-pari kada' i Ia sian mamarerei i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kasee i Yesus norobu na ko'ona tae-Na, “Na kota sambana Yaku' uga' tio mengelelekon Lele Pore men mambantilkon Batomundo'anna Alaata'ala, gause Yaku' niposuu' bo pingilimang men koiya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kasi i Ia nengelelekon Lele Pore na laigan bakitumpuan na libutan Yudea. ");
INSERT INTO blzNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na sa'angu' tempo, Yesus kere-kerer na soripi'na Danau Genesaret mengelelekon wurungna Alaata'ala. Mian biai' taka nunguruuti i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ia piile' i Yesus isian duangan rurua' na soripi'na danau iya'a. Mian na duangan iya'a noko palaumo ka' pintanga'mo mongoso'i puka'na i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesus nolumakitmo na sa'angu' duangan, men duangan ni Simon. Kasi i Ia nomosuu' i Simon mumbuntulkon duangan iya'a waatu'u paraas ko'alaloman. Yesus no'umoruangmo na duangan iya'a ka' nimisiso' mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Noko daa nimisiso' mian biai', Ia norobumo tae-Na, “Simon, bose waatu'u na ko'alaloman ka' ta'an a puka'muu kada' moko'ule' susum.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ia simbati i Simon taena, “Guru, sanondommo i kai na bapuka'an, kasee kosian upa men kai tausi. Kasee ka' i Kuu a nomosuu', mbaka' ta'anonku a puka' soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Noko daa ia ta'an i raaya'a a puka'na, nokana'mo susum men biai' tuu' puka'na i raaya'a tamban kinoraras. ");
INSERT INTO blzNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mbaka' i raaya'a somo nokikaba' na samba-sambana i raaya'a men isian na duangan sambana. Samba-sambana i raaya'a notakamo ka' nopootulungi nongowoot susum pataka nobuke' a duanganna i raaya'a rurua' ka' boomo mosool. ");
INSERT INTO blzNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tempo i Simon Petrus nimiile' se' koiya'a, ia nobanintuurmo kasi norobu taena, “Tumpu! Parerei i yaku' gause yaku' kani'i sa'angu' mian men dosaon.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon tia giigii' mian men isian na duanganna samba' nimiile' kobiai'na susum men ia puka' i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Koiya'a uga' a samba-samba ni Simon men i Yakobus tii Yohanes, anak ni Zebedeus. Yesus norobumo ni Simon tae-Na, “Alia layaon! Muntumbei koini'i i koo sidamo pumuka' mian.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Simon tia samba-sambana nimbingkatmo duanganna waara'a na katano'an, ka' i raaya'a namarereimo giigii' upana kasi nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na sa'angu' tempo, Yesus isian na sa'angu' kota. Inda'a isian moro'one men kustaon longkop wakana. Sarataa ia nimiile' i Yesus, ia nobanintuurmo ka' nama'ase' taena, “Tuan, kalu i Kuu maloos, Kuu sabole sida mengelesi'i i yaku' kada' maloe' koi aturanna agama.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus nondoekonmo lima-Na, nongkoyong mian iya'a kasi norobu tae-Na, “Daa, Yaku' maloos. Bi poloe'mo i koo!” Tempopo iya'a uga', kustana na'anumo. ");
INSERT INTO blzNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kasi i Yesus nomotoo mian iya'a kada' alia mambantilkon ni imepo upa men nosida iya'a, ka' norobu tae-Na, “Rae' na imam ka' pipiile'kon na ko'ona se' kustaam daa na'anumo. Moko daa iya'a kasi rookon a kurbaan koi men ia posuu'kon i Musa na ukum Torat kada' manasa na mian se' kustaam tuutuu' na'anumo!” ");
INSERT INTO blzNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kasee i Yesus notolelemo, ka' biai' a mian taka na Ko'ona momorongor i Ia ka' miki lesi'i nggeona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Noko daa iya'a ai Yesus nomae'mo na tampat men sianta mianna ka' nosambayang. ");
INSERT INTO blzNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na sa'angu'mo ilio pintanga' i Yesus mimisiso', isian toropii mian Farisi ka' wawa ukum Torat poto'oruang momorongori i Ia indo'o. Raaya'a ringkat na Yerusalem ka' na kota na Galilea tia Yudea. Yesus isian kuasana Tumpu men bo pengelesi'i mian manggeo. ");
INSERT INTO blzNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na tempo i Yesus pintanga' mimisiso' mian, isian toro pii mian notaka nangawawa sa'angu' mian repo' men toko-tokol na ampasna. Raaya'a mampari-pari mangawawa mian iya'a na lalomna laigan kada' daa sida pokelaon na arop ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kasee i raaya'a sian nomoko nonsoopkon i ia gause mian indo'o biai' tuu'. Mbali' iya'a, raaya'a namasawe'konmo mian repo' iya'a na wawona atop. Kasi i raaya'a nantataki atop ka' nungulul i ia na ampasna na tanga'na mian biai' na arop ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sarataa i Yesus nimiile' wawauna i raaya'a se' parasaya tuu' na Ko'ona, Ia norobumo na mian iya'a tae-Na, “Utus! Dosaam daa ni'ampunimo.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kasee wawa ukum Torat tia mian Farisi nompoo'inurutikonmo na noana i raaya'a taena, “Ime a mian kaya'a? Wurung-Na koi se' i Iamo a Alaata'ala. Ime a men daa sida mangampuni dosa saliwakon Alaata'ala suungna?” ");
INSERT INTO blzNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kasee i Yesus ninginti'i upa men isian na noana i raaya'a. Mbali' i Ia norobu tae-Na, “Nongko'upa se' i kuu mimikirawar koiya'a na noamuu? ");
INSERT INTO blzNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aupa a daana, mangaan, ‘Dosaam daa ni'ampunimo,’ kabai se' mangaan, ‘Wangonmo ka' tumpang?’ ");
INSERT INTO blzNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kasee koini'i popo'inti'ikonon-Ku na ko'omuu se' na tano' balaki' kani'i Anak Manusia kuasaan mangampuni dosa.” Kasi i Yesus norobu na mian repo' iya'a tae-Na, “Porongori a wurung-Ku: wangonmo, nakat a ueraan ka' ule'kon na laigaan!” ");
INSERT INTO blzNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mian iya'a liuliu nowangon ka' nanganakat ampasna pototiok i raaya'a giigii', kasi nomule'kon na laiganna ka' nuntunde' Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Raaya'a giigii' samba' tuu', kasi nuntunde' Alaata'ala. Raaya'a nolayaonmo ka' norobu taena, “Kosamba' tuu' a upa men kita piile' na ilio kani'i.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Noko daa iya'a i Yesus no'umuarmo. Ia nimiile' sa'angu' mian pagawena pajak men oru-oruang na kantor pajak. Ngaanna i Lewi. Taeni Yesus na ko'ona, “Mai, lolo' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi norumingkatmo ka' namarerei giigii' palimangonna, kasi nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Noko daa iya'a ai Lewi nangawawaumo ramean balaki' boni Yesus na laiganna. Biai' a pagawena pajak ka' uga' mian sambana men nokumaan ruru-ruru' tii raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Toropii mian Farisi ka' wawa ukum Torat nobarangunungmo ka' norobu na murit ni Yesus taena, “Nongko'upa se' i kuu kumaan ka' uga' ba'inum poopooruru' tia pagawena pajak ka' mian dosaon?” ");
INSERT INTO blzNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ia simbati i Yesus tae-Na, “Taasi' mian malesi' a paraluu dokter, kasee mian men manggeo. ");
INSERT INTO blzNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yaku' taka taasi' bo pengeleelo' mian men kana' a wawauna, kasee bo pengeleelo' mian dosaon kada' i raaya'a monsosoli ka' mangkadarai gau'na men ba'idek.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mian Farisi norobumo na ko'ona i Yesus taena, “Murit ni Yohanes ka' uga' muritna mian Farisi malia' ba'apata ka' basambayang. Kasee murit-Muu, nongko'upa se' tongko' kumaan ka' ba'inum?” ");
INSERT INTO blzNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ia simbati i Yesus tae-Na, “Sida mbali' a sawe'na suo' moro'one posuu'on ba'apata na posuo'anna see suo' moro'one iya'a dauga' indo'o tii raaya'a? Sabole sian! ");
INSERT INTO blzNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kasee bo taka a tempona suo' moro'one iya'a bo alaon na ko'ona i raaya'a. Na temposi iya'a kasi i raaya'a ba'apata.” ");
INSERT INTO blzNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kasi i Yesus nuntundunkon timbaani' na ko'ona i raaya'a tae-Na, “Sianta mian men memberaki bokukum u'uru ka' mantampalkon na bokukum men manau'mo. Gause kalu koiya'a, bokukum men u'uru uga' koberak. Ka' toik pantampal men u'uru sian pookakana' tia bokukum men manau'. ");
INSERT INTO blzNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Koiya'a uga' sianta sa'angu'po mian a men mantawa' anggur u'uru na batutu' anit manau' men motopu'mo. Gause kalu koiya'a, anggur men u'uru iya'a bo minsidakon batutu' anit manau' iya'a koberak, mbaka' anggur iya'a kowuwusmo, ka' batutu' anit iya'a kobaraba'ian. ");
INSERT INTO blzNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mbali' iya'a, anggur men u'uru uga' tio isiikonon na batutu' anit men u'uru. ");
INSERT INTO blzNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Koiya'a uga' sianta mian men daa mingkira' minginum anggur u'uru noko daa minginum anggur men manau'. Gause taena i raaya'a, ‘Anggur men manau' iya'a a ma'amatna.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na ilio Sabat, Yesus tia murit-Na nolumiu na ale'na gandum. Tempo iya'a, murit-Na numpupumo gandum, kasi nimpiupur ka' nangkaan. ");
INSERT INTO blzNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Toropii mian Farisi norobumo taena, “Nongko'upa i kuu se' nangawawau upa men sian patalaion wawauon na ilio Sabat?” ");
INSERT INTO blzNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ia simbati i Yesus tae-Na, “Sianpo mbali' i kuu nambasa a upa men ia wawau i Daud na tempo i ia tia mian men nongololo' i ia see nokololuan? ");
INSERT INTO blzNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ia ninsoop na Laiganna Alaata'ala, nangala roti men nirookonmo bona Alaata'ala ka' nangkaan, kasi nantarai uga' mian men nongololo' i ia. Poali tongko' imam a men daa sida mangkaan roti iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Taeni Yesus soosoodo, “Anak Manusia a bo Pinginti'i na ilio Sabat!” ");
INSERT INTO blzNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na sa'angu'anmo ilio Sabat soosoodo, Yesus nomae'mo mimisiso' mian na laigan bakitumpuan. Indo'o isian mian men repo' a limana uanan. ");
INSERT INTO blzNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Isian toropii wawa ukum Torat tia mian Farisi men pintanga' momonano i Yesus too-too i Ia mengelesi'i mian na ilio Sabat, kada' bo pompoposala'anna i raaya'a i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kasee i Yesus ninginti'i sagiana i raaya'a. Mbaka' i Ia norobumo na mian men repo' a limana iya'a tae-Na, “Mai kekerer ka'ita na aropna mian!” Mian iya'a norumingkatmo ka' nokumekerer. ");
INSERT INTO blzNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kasi i Yesus nimikirawar na mian biai' men isian indo'o tae-Na, “Koi taena agama, upa a men sida wawauonta na ilio Sabat? Mangawawau men ma'amat kabai se' mangawawau men ba'idek? Mansalamatkon mian kabai se' minsilaka'i mian?” ");
INSERT INTO blzNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus nengelealokonmo mian men na tiku-tikum-Na, kasi norobu na mian men repo' a limana iya'a tae-Na, “Soorkon a limaam!” Mian iya'a nonsoorkonmo limana, ka' limana mian iya'a uga' nalesi'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kasee wawa ukum Torat tia toropii mian Farisi iya'a noburuki'mo tuu', ka' i raaya'a nopootunduniimo se' too upaionmo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na tempo iya'a i Yesus nomae'mo na sa'angu' buu'na basambayang. Inda'a Ia nosambayangmo na Alaata'ala pataka sanondom. ");
INSERT INTO blzNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sarataa noruarmo, Ia nengeleelo'mo murit-Na, kasi nungururuki sompulo' rua' mian men Ia ngaan poposuu'. Ngaanna: ");
INSERT INTO blzNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon men ia ngaani i Yesus i Petrus tia utusna i Andreas, Yakobus ka' i Yohanes, Filipus ka' i Bartolomeus, ");
INSERT INTO blzNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius ka' i Tomas, Yakobus anak ni Alfeus, ka' i Simon (men ngaanon mian Zelot), ");
INSERT INTO blzNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas anak ni Yakobus ka' i Yudas Iskariot men komburi'na nangakalkon bo pongorookonna i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus notumokurumo na buu'na iya'a poopoololo' tia poposuu'-Na kasi notumataan kere-kerer na lempatna. Indo'o uga' isian murit-Na men sambana ka' biai' a mian sambana men ringkat na Yudea, na Yerusalem ka' na Tirus tia Sidon men na soripi'na tobui. ");
INSERT INTO blzNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Raaya'a notaka bo momorongor i Yesus ka' mikipakuli'kon nggeona i raaya'a. Mian men lampingionna meena uga' notaka ka' nilesi'i. ");
INSERT INTO blzNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Giigii' mian mampari-pari sulano munsuduk i Yesus, gause isian kuasa men umuar na waka-Na men sida mengelesi'i raaya'a giigii'. ");
INSERT INTO blzNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus nintiokimo murit-Na kasi norobu tae-Na, “Barakaatan i kuu giigii' mian men talalais, gause i kuumo a men bo mianna Batomundo'anna Alaata'ala! ");
INSERT INTO blzNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Barakaatan i kuu men mololu koini'i, gause i kuumo a men bo pobentengon! Barakaatan i kuu men wiri koini'i, gause i kuumo a men bo lengke! ");
INSERT INTO blzNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Barakaatan i kuu kalu koburuki'kononna mian, sian labotionna mian, irokion ka' potaekonon gause i kuu mongololo' Anak Manusia! ");
INSERT INTO blzNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nabii tempo mbaripian niwawaukon koiya'a uga'. Kalu men koiya'a kuu tempoimo, kuu tio lewa' a noamuu ka' rumunsak kobelesan, gause tambomuu men nitoropotikonmo na surugaa mase balaki' tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kasee silaka' i kuu men kupangon koini'i, gause i kuu nentempoimo men pore! ");
INSERT INTO blzNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Silaka' i kuu men benteng koini'i, gause i kuu bo mololu! Silaka' i kuu men lengke koini'i, gause i kuu bo masiongo' ka' wiri! ");
INSERT INTO blzNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Silaka' i kuu kalu giigii' mian muntunde' i kuu, gause koiya'a uga' na tempo mbaripian pulina i raaya'a muntunde' nabii men borek.” ");
INSERT INTO blzNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kasee i kuu men nongorongor i Yaku' koini'i, potoong-Ku koi kani'imari: Kolingu'kon a mian men maso'kon i kuu. Wawau a men pore bona mian men mangka'idek i kuu. ");
INSERT INTO blzNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Alaka' barakaati a mian men mantadeankon i kuu, ka' sambayangkon a mian men mangawawau ba'idek na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kalu mian mangarapa' kasumpi'muu men sambotak, rookon uga' a kasumpi'muu sambotakna soosoodo. Kalu jubamuu rampasion, rookon uga' a bokukummuu. ");
INSERT INTO blzNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kalu mian mama'ase' upa-upa na ko'omuu, tarai. Kalu upamuu rampasion, sobiimo ka' mungule'i. ");
INSERT INTO blzNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Upa men kikira'muu wawauonna mian na ko'omuu, wawau uga' a men koiya'a na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kalu i kuu tongko' mongkolingu'kon mian men mongkolingu'kon i kuu, men koiya'a mbali' se' kana'mo? Mianpo men dosaon minginti'i mongkolingu'kon mian men mongkolingu'kon i raaya'a! ");
INSERT INTO blzNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ka' kalu i kuu mangawawau pore tongko' bona giigii' mian men mangawawau pore na ko'omuu, men koiya'a mbali' se' kana'mo? Mianpo men dosaon minginti'i mangawawau pore na mian men mangawawau pore na ko'ona! ");
INSERT INTO blzNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka' kalu i kuu mombolosii upa-upa na mian see tongko' na mian men daa momoko mombolosi upa-upa iya'a, men koiya'a mbali' se' kana'mo? Mianpo men sian malolo' na aturan agama mantarai simbaya'na mombolos upa-upa kasi pa'ase'onna soosoodo! ");
INSERT INTO blzNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kasee i kuu tio mongkolingu'kon mian men maso'kon i kuu ka' mangawawau pore na ko'ona i raaya'a. Kuu tio mombolosii ka' alia mongooskon se' daa bo ule'konon. Gause kalu koiya'a, balaki' a tambomuu ka' manasa i kuu anakna Alaata'ala men na ko'alayo'an. Gause Alaata'ala pore a noa-Na bona mian men sian minginti'i basukuur, ka' bona mian men ba'idek a gau'na. ");
INSERT INTO blzNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kuu tiodaa isian polingu'muu koi Tamamuu na surugaa uga' isian polingu'-Na!” ");
INSERT INTO blzNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Alia i kuu mompoposala' mian mbaka' i kuu uga' sian poposala'on. Alia mungukum mian kada' i kuu uga' sian ukumon. Ampuni a mian kada' i kuu uga' ampunion. ");
INSERT INTO blzNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tarai a mian, mbaka' i kuu uga' taraion. Takalan pore men tamban peeton kasi tutupkonon pataka kowuwus bo rookonon na ko'omuu. Gause takalan men kuu takalkon bo takalkonon na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Noko daa iya'a ai Yesus nuntundunmo timbaani' na ko'ona i raaya'a tae-Na, “Sida mbali' mian mampisok mangalambin mian mampisok? Sabole rua-rua'na bo mandawo' na bolo'. ");
INSERT INTO blzNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sa'angu' mian men guruion sian angga'ion mangalalabii guruna. Kasee mian men tamatmo na ilimuu' men ia sikolai, ia sidamo koi guruna. ");
INSERT INTO blzNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nongko'upa i kuu se' tongko' mimiile' pupu' na matana simbaya'muu, kasee balak na matamuu sian kuu inti'i? ");
INSERT INTO blzNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Koi upa a kosidana i kuu mangaan na simbaya'muu taemuu, ‘Mai, yaku' anuikona a pupu' na mataam kanono'’ poali balak na matamuu sian kuu piile'? Wee i kuu men minti palo-paloos! Anui kutung a balak na matamuu kada' i kuu manasa mimiile' ka' sida manganui pupu' na matana simbaya'muu.” ");
INSERT INTO blzNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kau men pore a tutuo'na sian miwoo'kon woo' men sian pore. Koiya'a uga' a kau men ba'idek a tutuo'na sian miwoo'kon woo' men pore. ");
INSERT INTO blzNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pore kabai se' ba'idek a kau iya'a, na woo'na mba'a pinginti'ianmuu. Rakut ruri'on sianta pantausian mumpupu woo'na ara, ka' na kau men ruri'on sianta pantausian mumpupu woo'na anggur. ");
INSERT INTO blzNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mian men ma'amat momorobukon upa-upa men ma'amat, gause noana ma'amat. Kasee mian men ba'idek a gau'na momorobukon upa-upa men ba'idek, gause noana ba'idek. Gause upa men porobukononna mian rumingkat na noana.” ");
INSERT INTO blzNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nongko'upa mbali' i kuu se' mangaan i Yaku', ‘Tumpu! Tumpu!’ kasee i kuu sian mangawawau upa men bantilkonon-Ku na ko'omuu? ");
INSERT INTO blzNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Bantilkonon-Ku se' sanda' mian men taka na Ingku' ka' mongorongor wurung-Ku tia mongololo' men koi taeng-Ku', ");
INSERT INTO blzNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","i ia koi mian men na tempo mangawawau laigan, ia nengkeke ala-alalom ka' nangawawau pandasi na wawona watu. Na tempo waa' mingiliu laigan iya'a, laigan iya'a sian koruntun gause wawauna moonggor. ");
INSERT INTO blzNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kasee mian men nomorongor wurung-Ku see sian mongololo', ia koi sa'angu' mian men nomokerer laigan na tano' see sian nipandasi. Sarataa liuonna waa', laigan iya'a liuliu koruntun ka' kobaraba'ian dodoa tuu'!” ");
INSERT INTO blzNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Noko daa i Yesus nimisiso' mian biai', Ia nomae'mo na Kapernaum. ");
INSERT INTO blzNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Indo'o isian moomoola'na surudaduna Roma. Ia isian sa'angu' tutulungina men kolingu'na tuu' men manggeo tuu' ka' boomo lapus. ");
INSERT INTO blzNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na tempo i ia nongorongor lele se' isian i Yesus, ia nomosuu'mo toropii motu-motu'ana lipu' Yahudi mangarae'i ka' mengeleelo i Yesus kada' taka mengelesi'i tutulungina. ");
INSERT INTO blzNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sarataa nopootuung i Yesus, raaya'a ningkaase'mo kada' i Ia muntulung moomoola'na surudaduna Roma iya'a. Raaya'a norobumo ni Yesus taena, “Too daa sidaon-Muu tulungon a moomoola'na surudadu iya'a, ");
INSERT INTO blzNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","gause i ia mongkolingu'kon lipu'ta ka' i iamo a men nangawawau laigan bakitumpuanmai.” ");
INSERT INTO blzNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mbaka' nomae'mo i Yesus poololo' tii raaya'a. Sarataa torumpakmo na laiganna moomoola'na surudaduna Roma iya'a, surudadu iya'a nomosuu'mo toropii bela'na momootuungi i Ia ka' mambantilkon koi kani'imari: “Tuan! Sobiimo ka' makulen mae' na laiganku. Yaku' kani'i mian men sian kana'na mangalaboti i Kuu na laiganku. ");
INSERT INTO blzNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mbali' iya'a, yaku' suungku sian momoko taka na Ko'omuu. Mbaka' pa'ase'onku, tongko' ngaan toro santaa' daamo, kada' tutulungingku iya'a malesi'. ");
INSERT INTO blzNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gause i yaku' mian men posuu'on, ka' men kando'onana tii yaku' tio uga' mongololoikon posuu'ku. Kalu i yaku' momosuu' sa'angu' surudadu, ‘Rae'!’ mbaka' i ia sabole mae'. Ka' kalu i yaku' mengeleelo' men sambana, ‘Mai ka'ita!’ mbaka' i ia sabole taka. Kabai se' kalu i yaku' momosuu' tutulungingku, ‘Limang a kani'i!’ mbaka' sabole uga' limangonna.” ");
INSERT INTO blzNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nongorongor men koiya'a, samba' i Yesus. Ia nolumingamo na mian biai' men nongololo' i Ia ka' norobu tae-Na, “Bantilkonon-Ku na ko'omuu se' na lipu' Israelpo Yaku' sianpo nontoo rumpaki mian men imaanan tuu' koi kaya'a!” ");
INSERT INTO blzNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sarataa toropii mian men ia posuu' surudadu iya'a nomule'kon na laigan, ia takai i raaya'a tutulungi iya'a noko palesi'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Noko daa iya'a ai Yesus nomae'mo na kota Nain. Murit-Na tia mian biai' nomae' tii Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tempo i Yesus torumpakmo na soopanna kota, isian mian biai' nunguer biibii mae' na baleanan. Mian men nolapus iya'a anak moro'one suusuungna, ia anakna sa'angu' wiwine men nobalumo. Biai' a mianna kota nomae' tia balu iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sarataa i Yesus nimiile' wiwine iya'a, Ia nolingu' tuu' a noa-Na kasi norobu tae-Na, “Aliamomo' wiri!” ");
INSERT INTO blzNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kasi i Yesus nuntuu'i ueran biibii iya'a ka' ningintoni. Mbaka' mian men nunguer biibii iya'a notaanmo. Yesus norobumo tae-Na, “Oo atu'! Bantilkonon-Ku na ko'oom, wangonmo!” ");
INSERT INTO blzNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Anak malai moro'one men nolapusmo iya'a nowangonmo kasi no'umoruang ka' nobatundun. Mbaka' mian iya'a ia rookonmo i Yesus na sinana. ");
INSERT INTO blzNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Giigii' mian natakutmo ka' muntunde' Alaata'ala. Raaya'a norobumo taena, “Nabii balaki' notakamo na ko'onta'! Alaata'ala takamo bo mansalamatkon mian-Na!” ");
INSERT INTO blzNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lele ni Yesus iya'a notolelemo na longkop libutan Yudea ka' uga' libutan na tiku-tikumna. ");
INSERT INTO blzNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanes nongorongor na muritna giigii' upa men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mbaka' ia nengeleelo'mo rurua' muritna, kasi nomosuu' i raaya'a mae' ni Tumpu Yesus mimikirawar taena, “Too daa i Kuumo a men bo taka koi men ia toonkon Alaata'ala, kabai i kai tio mempeperai mian sambana?” ");
INSERT INTO blzNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Rurua' murit ni Yohanes iya'a nomae'mo ni Yesus ka' nimikirawar taena, “Kai ia posuu' i Yohanes Pansarani mimikirawar na Ko'omuu, too daa i Kuumo a men bo taka koi men ia toonkon Alaata'ala, kabai kai tio mempeperai mian sambana?” ");
INSERT INTO blzNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tempo iya'a i Yesus nengelesi'i mian biai' ka' numbuse'i meena biai' kasi ninsidakon mian biai' men mampisok sida poopiile'. ");
INSERT INTO blzNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mbaka' ia simbatimo i Yesus tae-Na, “Rae' ule'kon waale'e ni Yohanes ka' bantilkon a upa men kuu rongor ka' kuu piile'. Mian mampisok nopoopiile'mo, mian repo' nolumempangmo, mian kustaon na'anumo, mian mabongol nopoorongormo, mian men lapus nipotuo'imo, ka' Lele Pore men ringkat na Alaata'ala nilelekonmo na mian talalais. ");
INSERT INTO blzNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Barakaatan a mian men sian mongkokundai i Yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sarataa noporus a mian men ia posuu' i Yohanes, Yesus nuntumbeimo nuntundun i Yohanes na mian biai' men isian tii Ia. Tae-Na, “Kuu nomae' na tano' maleas bo mimiile' upa? Mimiile' sansila' rakut men puuronna mombuul waale'e-le'emari? ");
INSERT INTO blzNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kuu nomae' bo mimiile' upa? Mimiile' sa'angu' mian men mopakean pore? Mian men mopakean koiya'a ka' men tumuo' pore, dodongoanna na laiganna tomundo'! ");
INSERT INTO blzNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ansee i kuu no'umuar bo mimiile' upa? Bo mimiile' sa'angu' nabii? Tuutuu' mba'a. Ka' bantilkonon-Ku na ko'omuu se' i Yohanes labi tia tongko' nabii. ");
INSERT INTO blzNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gause i Yohanes isian nitulis na Alkitaap koi kani'imari: ‘Imamat ini'imari! Yaku' bo momosuu' mian-Ku mongolukoni i Kuu. Mian iya'a bo montoropoti salan-Muu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Taeni Yesus soosoodo, “Bantilkonon-Ku na ko'omuu se' na tano' balaki' kani'i sianta sa'angu'po mian men mangalalabii i Yohanes a pangangga'ina mian. Kasee mian men itiu'na na Batomundo'anna Alaata'ala, iamo a balaki'na tii Yohanes Pansarani.” ( ");
INSERT INTO blzNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Giigii' mian men nongorongor wurung-Na tonsoop pagawena pajak nompotuutuu' Alaata'ala gause i raaya'a niki saranimo ni Yohanes Pansarani. ");
INSERT INTO blzNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kasee mian Farisi tia wawa ukum Torat nongkokundai sagiana Alaata'ala na ko'ona i raaya'a, gause nobude' ia sarani i Yohanes Pansarani.) ");
INSERT INTO blzNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kasi i Yesus norobu soosoodo tae-Na, “Tio koi upa a pompookokoikonan-Ku mian men tumuo' na tempo koini'i? Koi upa i raaya'a? ");
INSERT INTO blzNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Raaya'a koi anak men poto'oruang na tampat pobalukan ka' ba'ilianna mian. Raaya'a mengeleelo'kon na anak sambana taena, ‘Kai munduup poloit bo ko'omuu, kasee i kuu bude' manari! Kai mangananikon nanian kasiongo'an, kasee i kuu sian wiri!’ ");
INSERT INTO blzNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohanes Pansarani notaka, ka' i ia malia' ba'apata ka' sian ninginum anggur, kasee i kuu nangaan se' i Yohanes ia lampingimo meena! ");
INSERT INTO blzNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kasi Anak Manusia notaka, ka' i Ia nokumaan ka' ninginum, ka' i kuu norobu taemuu, ‘Piile' a mian kale'e! Modoko', bukuan lio', motobela' tia pagawena pajak ka' motobela' tia mian dosaon.’ ");
INSERT INTO blzNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mau mune' koiya'a, pinginti'ianna Alaata'ala kampiile'an se' kana' na wawauna mian men mongololo pinginti'ianna iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Isian sa'angu' mian Farisi nangange i Yesus kada' kumaan na laiganna. Yesus nomae'mo na laiganna mian Farisi iya'a ka' nokumaan. ");
INSERT INTO blzNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na kota iya'a isian sa'angu' wiwine men tolele ba'idek a gau'na. Sarataa wiwine iya'a nongorongor se' i Yesus pintanga' kumaan na laiganna mian Farisi, ia nangawawamo sa'angu' botor pualam isiian minamina' men mawangi ka' nuntuungi i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ia nomae' wiri-wiri kasi nokumekerer na tokurung ni Yesus karani' sarat-Na ka' nengementaki sarat ni Yesus tia lolu'na ka' nansapui tia wuukna, kasi nongooki sarat ni Yesus ka' nintimbu'i tia minamina' men mawangi iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sarataa mian Farisi men nangange i Yesus nimiile' upa men nosida iya'a, ia norobumo na noana taena, “Kalu i Ia kaya'a nabii, sabole inti'ion-Na too ime ka' koi upa a wiwine men nunsuduk i Ia. Sabole inti'ion-Na a wiwine kale'e se' ba'idek a gau'na.” ");
INSERT INTO blzNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kasi i Yesus norobu na ko'ona tae-Na, “Simon, isian men bo bantilkonon-Ku na ko'oom.” Ia simbati i Simon taena, “Guru, tundunon-Muusi.” ");
INSERT INTO blzNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Taeni Yesus, “Isian rua' mian men samayaon na mian men mombolosii doi'. Men sa'angu', samayaon lima' atu doi' dinar, ka' sa'angu' mian soosoodo samayaon limampulo' doi' dinar. ");
INSERT INTO blzNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Gause sianmo pokoonna i raaya'a bontorion, mbaka' mian men nombolosii doi' iya'a nansapuimo samayana rua-rua' irana. Na rurua' mian iya'a, ime a men mongkolingu'kon tuu' mian men nansapuimo samayana iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ia simbati i Simon taena, “Saruionku, mian men biai'na samayana nisapui.” Ia simbati i Yesus tae-Na, “Pinginti'iim kanooro'o tuutuu'.” ");
INSERT INTO blzNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kasi i Yesus nintioki wiwine iya'a ka' norobu ni Simon tae-Na, “Daa koo piile'mo a wiwine kani'i? Yaku' ninsoop na laigaan ka' i koo sian nantarai Yaku' weer bo pimbuu'on-Ku, kasee wiwine kaya'a nengementakimo sarat-Ku tia lolu'na ka' nansapui tia wuukna. ");
INSERT INTO blzNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Koo sian nongooki i Yaku', kasee wiwine kaya'a taka-takapo i ia, ia sian otasna mongooki sarat-Ku. ");
INSERT INTO blzNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Koo sian ningiminamina'i takala'-Ku, kasee wiwine kaya'a ningiminamina'i sarat-Ku tia minamina' men mawangi. ");
INSERT INTO blzNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mbali' iya'a, bantilkonon-Ku na ko'omuu se' wiwine kani'i molingu'kon tuu' i Yaku'. Lingu'na iya'a ninsiso'kon se' dosana men biai' ni'ampunimo. Kasee mian men daa ni'ampuni na dosana men tongko' titiu', lingu'na na Ingku' uga' tongko' titiu'.” ");
INSERT INTO blzNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kasi i Yesus norobu na wiwine iya'a tae-Na, “Dosaam daa ni'ampunimo.” ");
INSERT INTO blzNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mian men nokumaan ruru-ruru' tii Yesus norobumo na simbaya'na i raaya'a taena, “Se' ime i Ia kaya'a mbali' daa Ia momoko mangampuni dosa?” ");
INSERT INTO blzNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kasee i Yesus norobu na wiwine iya'a tae-Na, “Imaawan nansalamatkonmo i koo. Koini'i rae'mo i koo tia noa beles!” ");
INSERT INTO blzNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sian paraa nanau' noporusanna iya'a, Yesus nomae'mo na toropii kota tia kampung mengelelekon Lele Pore men mambantilkon Batomundo'anna Alaata'ala. Sompulo' rua' murit-Na nomae' tii Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Koiya'a uga' a toropii wiwine men isian meena ni'uarkon na ko'ona, ka' men nilesi'i na nggeona i raaya'a, tonsoop i Maria men ngaanon i Magdalena (pitu' meena men ni'uarkon na ko'ona); ");
INSERT INTO blzNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","uga' i Yohana, boroki' ni Khuza men pagawena laigan batomundo'an ni Herodes; Susana ka' uga' biai' a wiwine men sambana. Raaya'a nomae' nangkalesang i Yesus tia murit-Na, mau mune' i raaya'a somo namba'ilikon doi'na susuung. ");
INSERT INTO blzNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Biai' a mian men ringkat na toropii kota mae' ni Yesus. Sarataa biai'mo a mian men notorimpung, Yesus nuntundunkonmo i raaya'a timbaani' men koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Isian po'ale' sa'angu' mae' mangkambur wine' na ale'na. Banta-bantang i ia mangkambur, isian wine' men nandawo' na soripi'na salan. Sanggiran ia pee'imo mian ka' men sanggiran ia kaanmo sapu' pataka nokabus. ");
INSERT INTO blzNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Isian uga' men nandawo' na karabatu. Tempo wine' nosumukutmo, ia liuliu nalau gause tano'na kerengkengan. ");
INSERT INTO blzNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Isian uga' wine' men nandawo' na rakut masolot ka' ruri'on. Kasi rakut masolot ka' ruri'on iya'a tumuo' singkat tia wine' iya'a ka' ningipit pataka nopate. ");
INSERT INTO blzNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kasee isian uga' wine' men nandawo' na tano' men molumba'. Sarataa notumuo' ia niwoo'mo para sa'atu paku'.” Noko daa nambantilkon timbaani' iya'a, Yesus norobumo tae-Na, “Daa tilingaan, imamat pore-pore!” ");
INSERT INTO blzNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Murit ni Yesus nimikirawarmo na Ko'ona se' upa aratina timbaani' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ia simbati i Yesus tae-Na, “Kuu nitaraimo pinginti'ian kada' minginti'i upa men mawuni na Batomundo'anna Alaata'ala. Kasee mian sambana nipisiso' tia timbaani' kada' mau mune' i raaya'a mimiile', kasee sian poopiile'. Ka' mau i raaya'a poorongor, kasee sian minginti'i.” ");
INSERT INTO blzNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Koi kani'imari a aratina timbaani' iya'a: Wine' iya'a mase wurungna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wine' men nandawo' na soripi'na salan, mase mian men nongorongor wurung iya'a. Kasee notakamo a Ibiliis nangarampasi wurung iya'a na noana dako' i raaya'a mamarasaya ka' salamatkonon. ");
INSERT INTO blzNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wine' men nandawo' na karabatu mase mian men na tempo nongorongor wurung iya'a, ia nangalabotmo tia noa beles. Kasee wurung iya'a sian niwakat na noana i raaya'a. Raaya'a parasaya kasee tongko' kodi-kodi', ka' tempo takaionna solon-solong, raaya'a minsasapu kaparasaya'anna. ");
INSERT INTO blzNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wine' men nandawo' na rakut ruuri'on mase mian men nongorongor wurung iya'a, kasee dauga' babatakon tutuo'na i raaya'a ka' uga' mingkira' tumuo' labian ka' pore. Giigii' iya'a minsidakon i raaya'a sian mantakakon woo' men motu'a. ");
INSERT INTO blzNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wine' men nandawo' na tano' men molumba' mase mian men nongorongor wurung iya'a, kasi ia naa' na noana men pore ka' matondong. Raaya'a momoko bakitaan pataka mantakakon woo'.” ");
INSERT INTO blzNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Taeni Yesus soosoodo, “Sianta mian men muntutungi boloak ka' mansa'u tia gumbang, kabai se' momokela na intuna tokolan. Ia tio momokela boloak iya'a na sulaanna kada' mian men minsoop sida mimiile' ruarna. ");
INSERT INTO blzNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sianta upa-upa men tonaa' men komburi'na sian pipiile'konon, ka' sianta upa-upa men nipopowuni men komburi'na sian kanginti'ian ka' lelekonon. ");
INSERT INTO blzNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mbali' iya'a, imamat pore-pore a pongorongormuu pisiso'-Ku. Gause mian men isianmo upa ia tombonoi bo taraion soosoodo, kasee mian men sianta upa tombonoionna, toro tiu'po men saruion dauga' isian na ko'ona uga' bo alaon.” ");
INSERT INTO blzNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sina ni Yesus tia utus-Na notaka na Ko'ona, kasee i raaya'a sian nomoko nomootuungi i Ia gause biai' tuu' a mian. ");
INSERT INTO blzNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Isian sa'angu' mian norobu ni Yesus taena, “Sina-Muu tia utus-Muu mokaraale'e na liwa, mingkira' momootuungi i Kuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kasee ia simbati i Yesus tae-Na, “Mian men nongorongor wurungna Alaata'ala ka' mansalankon tia wawau men pore, raaya'amo a sinang-Ku tia utus-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na sa'angu' tempo i Yesus tia murit-Na nolumakitmo na duangan. Yesus norobumo na ko'ona i raaya'a tae-Na, “Mai kita lumembet na sambotakna danau.” Mbaka' i raaya'a nomae'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pintanga' i raaya'a tarabut i Yesus notomporoyotmo. Ola-olan taka boyus na danau iya'a. Duanganna i raaya'a muntumbeimo isiionna weer pataka boomo silaka'. ");
INSERT INTO blzNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Murit ni Yesus nomae'mo na Ko'ona ka' ninsimpu i Ia. Taena, “Guru! Guru! Silaka'mo i kita!” Yesus nowangonmo ka' nongkokundakon boyus tia bokol men kaekae' makorong ka' makansang tuu'. Boyus tia bokol iya'a uga' liuliu norokot ka' danau iya'a notodoomo. ");
INSERT INTO blzNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesus norobumo na murit-Na tae-Na, “Nongko'upa i kuu se' sian mamarasaya i Yaku'?” Raaya'a nolayaonmo ka' nosamba'. Raaya'a nopoopikirawarimo simbaya'na taena, “Ime a men tuutuu'na mian kaya'a mbali' daa sida mongkokundakon mombuul tia bokol, ka' mombuul tia bokol iya'a momorongori i Ia?” ");
INSERT INTO blzNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus tia murit-Na notakamo na dodongoanna lipu' Gerasa na sambotakna Danau Galilea. ");
INSERT INTO blzNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sarataa i Yesus nalau na katano'an, ia pootuungimo sa'angu' moro'one men ia lampingi meena. Mian iya'a ringkat na kota. Ia nanau'mo sian mopake ka' sianmo nodumodongo na laigan. Ia tongko' dumodongo na leeng men pantanoman mian lapus. ");
INSERT INTO blzNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Sarataa mian iya'a nimiile' i Yesus, ia nangkakaro'mo kasi nobanintuur ka' norobu taena, “Oo Yesus, Anakna Alaata'ala men na ko'alayo'an! Upaioonmo i yaku'? Pa'ase'onku, amo' talalaisoon i yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mian iya'a norobu koiya'a gause i Yesus nomosuu'mo meena umuar na wakana mian iya'a. Ia piribiai'mo lampingionna meena mbali' mau lima tia saratna punguon tia rante ka' dagaion pore-pore, ia dauga' momoko mamantas rante men nipungukon kasi wawaonna meena na tampat men oloa' na mian. ");
INSERT INTO blzNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus nimikirawarimo mian iya'a tae-Na, “Ime a ngaawan?” Ia simbati mian iya'a taena, “Ngaanku i Legion,” gause biai' tuu' a meena men ninsoop na wakana. ");
INSERT INTO blzNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Meena iya'a ningkakaase' kada' i Yesus alia momosuu' i raaya'a mae' na pakom. ");
INSERT INTO blzNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Karani' na tampat iya'a isian bau' biai' tuu' men pintanga' mansarak kumaan na tembanon. Meena iya'a nokumakaase' ni Yesus kada' patalaion minsoop na bau' karaatu'u. Ka' i Yesus daa sangada. ");
INSERT INTO blzNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mbaka' meena no'umuarmo na mian iya'a ka' ninsoop na bau' men biai' iya'a. Kasi salulusan bau' men biai' iya'a notumetende' ka' notumumbur na liu' waaro'o na weer, mbaka' nopatemo nolomos. ");
INSERT INTO blzNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pontondong bau' iya'a nimiile' upa men nosida. Mbaka' i raaya'a notumetende'mo ka' nuntundunkon lele iya'a na kota ka' na kampung men na tiku-tikumna. ");
INSERT INTO blzNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kasi mian biai' no'umuar ka' mae' nimiile' upa men nosida. Raaya'a notakamo ni Yesus, ka' indo'o i raaya'a nantakai mian men sianmo ia lampingi meena oru-oruang beebeel sarat ni Yesus. Ia nobapakemo ka' nopatotongmo. Raaya'a nolayaonmo. ");
INSERT INTO blzNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mian men nimiile' upa men nosida iya'a nuntundunkonmo na mian sambana koi upa a mian iya'a nilesi'i. ");
INSERT INTO blzNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kasi giigii' mian na lipu' Gerasa nama'ase' ni Yesus kada' i Ia mamarerei dodongoan iya'a, gause raaya'a giigii' nolayaonmo tuu'. Mbaka' i Yesus nolumakitmo na duangan ka' nomule'kon. ");
INSERT INTO blzNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mian men sianmo ia lampingi meena iya'a nama'ase'mo ni Yesus kada' i ia poturangon lumolo' na Ko'ona. Kasee i Yesus nomosuu' i ia mule'kon tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ule'konmo na laigaan ka' lelekon a giigii' upa men ia wawaumo Alaata'ala na ko'oom.” Mbaka' mian iya'a nomae'mo na sanda' dodongoan na lalomna kotana ka' nengelelekon upa men ia wawau i Yesus na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sarataa i Yesus nomule'kon na sambotakna danau, ia labotimo mian biai' tia noa beles gause i raaya'a noko potoperamo. ");
INSERT INTO blzNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kasi notaka ni Yesus a sa'angu' tanaasna laigan bakitumpuan. Ngaanna i Yairus. Ia nobanintuur ka' nama'ase' kada' i Yesus sabole-bole mae' na laiganna, ");
INSERT INTO blzNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","gause isian anakna wiwine men sa'a-sa'angu' ka' umurna baasi sompulo' rua' taun pintanga' sakaal. Yesus banta-bantang mae' na laigan ni Yairus, mian biai' na tiku-tikum-Na menggeet i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na mian biai' iya'a isian uga' sa'angu' wiwine men sompulo'mo rua' taun mariingi'on men dodoa. Mian iya'a namakabusmo giigii' kupangna bo bapakuli'na na dokter, kasee sianta men kinalesi'na. ");
INSERT INTO blzNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wiwine iya'a nuntuntuni i Yesus, nembeeli paraas tokurung-Na ka' nongkoyong puusna juba-Na. Tempo iya'a uga' mariingi'na wiwine iya'a liuliu norokot. ");
INSERT INTO blzNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus nimikirawarmo tae-Na, “Ime a men nongkoyong i Yaku'?” Giigii' mian indo'o ninsasapu. Kasi i Petrus norobu taena, “Guru, biai' tuu' a mian nunguruuti ka' nenggeet i Kuu!” ");
INSERT INTO blzNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesus norobu tae-Na, “Kasee isian mian men nongkoyong i Yaku'. Ya'a Yaku' inti'i, gause isian kuasa men no'umuar na wakang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wiwine iya'a ninginti'i se' upa men ia wawau nokanginti'ianmo. Mbaka' i ia nangkarani'mo i Yesus ka' notumutuku' ranggu-ranggugur. Kasi i ia nuntundunkon na mian biai' nongko'upa mbali' i ia nongkoyong i Yesus, ka' nuntundunkon se' mariingi'na na'anumo tempopo iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus norobumo soosoodo na ko'ona tae-Na, “Anak-Ku, gause i koo parasaya na Ingku', mbaka' i koo nalesi'mo. Rae'mo tia noa ma'amat!” ");
INSERT INTO blzNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pintanga' morobu i Yesus, notakamo a sa'angu' mian men poto'utusan ni Yairus, tanaasna laigan bakitumpuan iya'a. Ia nambantilkon ni Yairus taena, “Anakmuu nolapusmo. Sobiimo i kuu ka' dauga' mungkulen i Guru.” ");
INSERT INTO blzNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sarataa i Yesus nongorongor se' koiya'a, Ia norobumo ni Yairus tae-Na, “Alia layaon. Parasaya, daamo. Anaak sabole bo malesi'.” ");
INSERT INTO blzNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sarataa i Yesus notaka na laigan ni Yairus, Ia sian nomoturang mian sambana minsoop tii Ia saliwakon i Petrus, Yohanes, Yakobus ka' sina tia tamana anak iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Giigii' mian pintanga' wiri ka' tumando' gause anak men nolapus iya'a. Kasee i Yesus norobu tae-Na, “Alia wiri. Anak kanono' sian nolapus; ia tongko' noroyot!” ");
INSERT INTO blzNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Raaya'a nongkolengkeimo i Yesus, gause i raaya'a poto'inti'i se' anak wiwine iya'a tuutuu' noko lapusmo. ");
INSERT INTO blzNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Komburi'na i Yesus ningintonimo limana anak iya'a kasi norobu tae-Na, “Anak, wangonmo!” ");
INSERT INTO blzNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Anak iya'a liuliu ninoa ka' uga' lako-lako nowangon. Noko daa koiya'a kasi i Yesus nomosuu' i raaya'a kada' mamakaan anak iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Minti'ina anak iya'a samba' tuu'. Kasee i Yesus nomotoo i raaya'a kada' alia muntundunkon upa men nosida iya'a mau ni imepo. ");
INSERT INTO blzNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus nengeleelo'mo murit-Na men sompulo' rua' iya'a kasi nantarai i raaya'a kuasa bo pumbuse'i meena ka' bo pengelesi'i biai' kaliangan nggeona mian. ");
INSERT INTO blzNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ka' i Ia nomosuu' i raaya'a mae' mengelelekon Batomundo'anna Alaata'ala ka' mengelesi'i mian manggeo. ");
INSERT INTO blzNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Taeni Yesus na ko'ona i raaya'a, “Alia mangawawa upa-upa na rae'anmuu, alia mangawawa tokon, kabai tuuman, kabai kakaan, kabai doi', kabai se' bokukum rurua'. ");
INSERT INTO blzNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kalu kuu tuuk na laiganna mian, ka' ia laboti mian, dodongo na laiganna pataka i kuu mamarerei kota iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka' kalu isian mian men bude' mangalaboti i kuu na sa'angu' kota, na tempo i kuu mamarerei kota inono', taperi a awu na palaana saratmuu bookoi oos se' i raaya'a sian kokana'na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kasi i raaya'a nomae' na longkop kampung pori-porimban mengelelekon Lele Pore iya'a ka' mengelesi'i mian manggeo men na biai' dodongoan. ");
INSERT INTO blzNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na tempo i Herodes men tomundo' na libutan Galilea nongorongor giigii' men nosida iya'a, ia noraranga'mo. Gause isian mian men nangaan se' i Yohanes Pansarani nipotuo'imo noko daa lapus. ");
INSERT INTO blzNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Isian uga' mian men nangaan se' i Elia notakamo soosoodo. Mian sambana uga' nangaan se' sa'angu' nabii men na nabii mbaripian notuo'mo soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Taena i Herodes, “Yaku' nomosuu'konmo mian nongkolongi takala' ni Yohanes. Kasee mian kani'i, ime i Ia men tuutuu'na? Biai'mo a lele-Na men yaku' rongor.” Mbaka' i Herodes nampari-parimo bo pootuung tii Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Poposuu' ni Yesus nomule'konmo ka' nuntundunkon ni Yesus giigii' men ia wawau i raaya'a. Yesus nangangemo i raaya'a ka' mae' nintisaal na kota Betsaida. ");
INSERT INTO blzNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kasee mian biai' inti-inti'i se' koiya'a. Mbaka' i raaya'a nuntuntunimo i Yesus. Raaya'a ia labotimo i Yesus, kasi i Yesus nuntundunkon na ko'ona i raaya'a Batomundo'anna Alaata'ala. Ka' Ia uga' nengelesi'i mian men mingkira' malesi'. ");
INSERT INTO blzNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sarataa ilio muntumbeimo sopok, murit-Na men sompulo' rua' notakamo na Ko'ona ka' norobu taena, “Guru, tampat kani'i oloa na dodongoanna mian. Mbulo posuu' a mian karaani'i bi rae' kada' i raaya'a mansarak kakaan ka' tampat bo tuukanna na kampung men isian na libutan kani'i.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kasee taeni Yesus, “Kuusi a mantarai i raaya'a kakaan.” Taena murit ni Yesus, “Kai tongko' isian roti lilima' ka' susum rurua'. Kabai se' kai tio mingili kakaan bona mian biai' karaaya'a?” ");
INSERT INTO blzNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Indo'o isian toro lima' loloon mian moro'one.) Taeni Yesus na murit-Na, “Posuu' a mian karaanono' umoruang morimpung, ka' sarimpung toro limampulo' mian.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Murit ni Yesus iya'a nongololoikonmo koi men taeni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Komburi'na i Yesus nangalamo roti lilima' ka' susum rurua' iya'a, kasi nolumelengea' waara'a langit, ka' nobasukuur na Alaata'ala. Noko daa koiya'a Ia rumpi-rumpikmo a roti iya'a kasi nongorookon na murit-Na bo obo-oboskononna i raaya'a na mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Raaya'a wiwi'na nobenteng nangkaan. Ka' labina roti men nikaan iya'a ia ruru' murit ni Yesus, dauga' nobuke' sampulo' rua' basung. ");
INSERT INTO blzNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na sa'angu' tempo pintanga' i Yesus sambayang suungna, notakamo a murit-Na na Ko'ona. Kasi i Yesus nimikirawari i raaya'a tae-Na, “Koi taena mian biai', ime mbali' i Yaku' kani'i?” ");
INSERT INTO blzNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ia simbati i raaya'a taena, “Yohanes Pansarani. Isian sambana men mangaan ai Elia. Mian sambana soosoodo mangaan se' isian nabii tempo mbaripian men notuo'mo soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesus nimikirawarmo na ko'ona i raaya'a tae-Na, “Koi taemuu murit-Ku, ai ime i Yaku' kani'i?” Ia simbati i Petrus taena, “Tomundo' Pansalamatkon men nda'ara'amari na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kasi i Yesus nomotoo i raaya'a kada' alia mambantilkon ni imepo upa-upa men nosida kani'i. ");
INSERT INTO blzNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ka' taeni Yesus, “Anak Manusia tio munsuri repaan biai' ka' kokundaionna motu-motu'a, tanaasna imam ka' wawa ukum Torat. Ia bo papateion, kasee na ilio kotolu'na bo potuo'ion.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Komburi'na taeni Yesus na giigii' mian men indo'o, “Mian men mingkira' mongololo' i Yaku' tio mongkolimbo'kon pingkira'na noana, kasi mamasa'an saliipna sanda' ilio ka' mongololo' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gause mian men mampari-pari mansalamatkon wakana na dunia kani'i, ia sian mantausi tutuo' men pore. Kasee mian men mongorookon wakana bo Ingku', ia bo mantausi tutuo' men pore. ");
INSERT INTO blzNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Upa mbali' a ee'na men takakononna mian mau ia montombonoi longkop tano' balaki' kasee i ia silaka' ka' sian mantausi tutuo' men pore pataka sidutu? ");
INSERT INTO blzNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kalu isian mian men makamaa' mompotuutuu' i Yaku' tia pisiso'-Ku, Anak Manusia uga' bo makamaa' mompotuutuu' mian iya'a na tempo Ia taka tia kuasa-Na ka' kuasana Tama-Na ka' kuasana malaa'ikat men molinas! ");
INSERT INTO blzNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' isian i kuu men daa mokaraani'i men sianpo lapus kalu koo'po mimiile' Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Toro walu' ilio a noporusanna i Yesus nimisiso'kon upa-upa iya'a, Ia nangawawamo i Petrus, Yohanes, ka' i Yakobus nasawe' na wawona sa'angu' buu'na mae' sambayang. ");
INSERT INTO blzNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tempo i Yesus pintanga' sambayang inda'a, ro'up-Na nokoboliianmo ka' juba-Na nosidamo bubulak dingkalapan. ");
INSERT INTO blzNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kasi nokampiile'an a rua' mian batundun tii Ia. Mian iya'a ai Musa tii Elia. ");
INSERT INTO blzNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Rua-rua' irana nintipiile' tia kobalaki'an ka' ruar men nda'ara'amari na surugaa. Raaya'a batundun tii Yesus, muntundun kolapusan-Na men sianmo manau' bo rumpakion-Na na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na tempo iya'a i Petrus tia simbaya'na tinomporoyotmo, kasee tempo i raaya'a nowangon, raaya'a nimiile' se' i Yesus nodingkalapanmo ka' uga' rua' mian iya'a men potokerer tii Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tempo rua' mian iya'a boomo mamarerei i Yesus, Petrus norobumo ni Yesus taena, “Guru, ma'amat tuu' i kita isian na tampat kani'i. Mbulo i kai momokerer sa'up totolu', sa'angu' bo Ko'omuu, sa'angu' boni Musa, ka' sa'angu' boni Elia.” (Petrus norobu koiya'a kasee sian ia inti'i a upa men ia porobukon.) ");
INSERT INTO blzNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Dauga' pintanga' i Petrus morobu, notakamo a antong nansa'upi i raaya'a. Tempo ia sa'upi antong iya'a, raaya'a nolayaonmo. ");
INSERT INTO blzNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Komburi'na na antong iya'a nokamporongoranmo a wurung men nangaan, “Ni'imo a Anak-Ku men Yaku' ruruki. Porongori i Ia!” ");
INSERT INTO blzNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Noko daa wurung men koiya'a, ia piile' i raaya'a i Yesus somo suungna indo'o. Murit ni Yesus nompopowuni upa men nosida iya'a, ka' tempo iya'a sianpo nitundunii upa men ia piile' i raaya'a ni imepo. ");
INSERT INTO blzNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Koi liilana i Yesus tia murit-Na totolu' notumokurumo na buu'na iya'a, ka' mian biai' notakamo na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sa'angu' moro'one men isian na mian biai' iya'a nengeleelo'kon taena, “Guru, miki piile'kon anakku. Ia anakku men sa'a-sa'angu'! ");
INSERT INTO blzNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kalu meena mangalampingi i ia, ia liuliu mangkakaro' ka' meena iya'a munggugurkon i ia pataka wura'on a nganga'na. Meena iya'a sinampang mampapolosi i ia ka' bude' mamarerei i ia. ");
INSERT INTO blzNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yaku' niki tulungmo na murit-Muu kada' mumbuse'ikon meena iya'a, kasee sian ia poko i raaya'a nibuse'i.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Taeni Yesus, “Alia uga' i kuu mian men tumuo' na tempo koini'i! Kuu tuutuu' mian men sian parasaya ka' men nosala'mo salan. Pataka ipi mbali' i Yaku' tio dumodongo tii kuu ka' mokotaan na upa men wawauonmuu? Wawa le'emari anakmuu kanono'!” ");
INSERT INTO blzNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pintanga' anak iya'a waale'e ni Yesus, meena iya'a ningirimpa'konmo na tano' ka' nunggugurkon i ia. Kasee i Yesus nengerengeaki meena iya'a ka' nengelesi'i anak iya'a. Kasi i Yesus nungule'kon anak iya'a na tamana. ");
INSERT INTO blzNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Giigii' mian samba' nimiile' kuasana Alaata'ala men balaki' tuu'. 9:43b-45 Na tempo mian biai' dauga' samba' tuu' mimiile' giigii' men ia wawau i Yesus, Ia norobumo na murit-Na tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Rongor ka' intoomkon pore-pore a wurung-Ku kani'imari. Anak Manusia bo rookonon na kuasana mian.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kasee murit ni Yesus sian ninginti'i upa men Ia wurungkon, gause aratina niwunikon na ko'ona i raaya'a dako' inti'ionna i raaya'a. Kasee i raaya'a babata mimikirawar ni Yesus aratina wurung-Na iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Murit ni Yesus nopoogagaimo munsurung se' ime a men balaki'na i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus ninginti'i pikiranna i raaya'a, mbali' Ia nangalamo sa'angu' anak morio' kasi Ia pokerer a anak iya'a na soripi'-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kasi i Ia norobu na murit-Na tae-Na, “Ime a men mangalaboti anak kani'i gause mian iya'a mongololo' pisiso'-Ku, nono' a men ngaanon mangalaboti i Yaku'. Ka' ime a men mangalaboti i Yaku', mian iya'a uga' mangalaboti i Ia men nomosuu' i Yaku'. Gause mian men morio'na, iamo a men balaki'na.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Taena i Yohanes, “Guru! Kai nimiile' mian numbuse'i meena see mangaan ngaan-Muu a numbuse'ina, mbaka' kai kokundakonmo i ia gause i ia taasi' tii kita.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ia simbati i Yesus tae-Na, “Alia mongkokundakon i ia! Gause mian men daa sian mangka'idek i kuu, nono' aratina umapak na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sarataa karani'mo a tempo ni Yesus bo nakaton waara'a surugaa, Ia namakadodormo noa-Na se' i Ia bo mae' na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mbaka' i Ia nomosuu'mo mian mae' mongolukoni i Ia. Raaya'a men niposuu' nomae'mo, kasi ninsoop na sa'angu' kampungna lipu' Samaria bo montoropotikon giigii' bo Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kasee mian na kampung iya'a bude' nangalaboti i Yesus, gause noka'inti'ianmo se' i Ia banta-bantang mae' na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mbaka' na tempo rua' murit ni Yesus men i Yakobus ka' i Yohanes ninginti'i upa men nosida iya'a, raaya'a norobumo na Ko'ona taena, “Tumpu, kalu poturangon-Muu, kai mama'ase' kada' apu malau nda'ara'amari langit bo pinsilaka'i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kasee i Yesus noluminga ka' nongkokundakon i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kasi i raaya'a nomae' na kampung sambana. ");
INSERT INTO blzNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na tempo i Yesus ka' murit-Na ningimputkonmo rae'anna soosoodo, isian mian men nangaan ni Yesus taena, “Yaku' mingkira' mongololo' i Kuu mau maana a rae'an-Muu!” ");
INSERT INTO blzNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ia simbati i Yesus tae-Na, “Serigala isian bolo'na, ka' sapu' isian pimpeetaanna, kasee Anak Manusia sianta bo tokolan-Na.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kasi i Yesus norobu na sa'angu' mian men sambana tae-Na, “Lolo'mo i Yaku'.” Kasee mian iya'a norobu taena, “Poturang i yaku' mule'kon kutung mae' mantanom tamangku.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ia simbati i Yesus tae-Na, “Patalai a mian lapus mantanom mianna i raaya'a men nolapusmo. Kasee i koo, rae' ka' lelekon a lelena Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Isian uga' mian sambana men nangaan taena, “Tumpu, yaku' mingkira' mongololo' i Kuu, kasee poturang i yaku' mule'kon kutung mae' mobantil na poto'utusanku.” ");
INSERT INTO blzNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kasee taeni Yesus na mian iya'a, “Mian men muntumbeimo bapajeko kasee mingilinga na komburi', ia sian kokana'-Ku bo mianna Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Noko daa koiya'a Tumpu nungururukimo pitumpulo' murit-Na soosoodo, kasi nomosuu' i raaya'a rua'-rua' mian mongolukoni i Ia na sanda' kota ka' dodongoan men bo rae'ion-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Taeni Yesus na ko'ona i raaya'a, “Padakon mase biai', kasee papalimang men bo pamadak tongko' titiu'. Mbali' iya'a, pama'ase' na tombono ale' kada' i Ia mantakakon papalimang men bo pamadak ule'na aso-asok iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Rae'mo! Imamat ini'imari! Yaku' momosuu' i kuu koi anakna domba na tanga'na serigala. ");
INSERT INTO blzNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Alia mangawawa dompet kabai tuuman, kabai se' sapato. Alia tumataan na tanga'na salan mantabe'i mau imepo. ");
INSERT INTO blzNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kalu i kuu minsoop na sa'angu' laigan men olukon ngaanonmuu koi kani'imari: ‘Sulano bi tumuo' pore i kuu na lalomna laigan kani'i.’ ");
INSERT INTO blzNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kalu isian mian men mingkira' pooka'amat, mbaka' salammuu iya'a isian na ko'ona. Kalu ia bude' mangalabot, mbaka' salammuu iya'a bo mule'kon na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dodongo tongko' na sa'angu' laigan. Labot a upa men taropkononna mian bo ko'omuu, gause sa'angu' mian men balimang salananmo mantausi tambona. Alia mobaabalimba' a laigan dodongoanmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kalu i kuu mae' na sa'angu' kota ka' na kota iya'a i kuu labotionna mian pore-pore, alaka' kaan a upa-upa men nitaropkon ino'o na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Alaka' lesi'i a mian men manggeo na kota iya'a ka' lelekon na mian biai' inta': ‘Batomundo'anna Alaata'ala karani'mo na ko'omuu.’ ");
INSERT INTO blzNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kasee kalu i kuu taka na sa'angu' kota ka' na kota iya'a i kuu sian labotionna mian, uar ka' rae' waale'e na salan kasi porobukon a koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Awu na kotamuupo men kumampit na saratmai, taperionmai bookoi oosanmai na ko'omuu. Kasee bo inti'ionmuu se' Batomundo'anna Alaata'ala karani'mo!’ ");
INSERT INTO blzNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Bantilkonon-Ku na ko'omuu se' na Ilio Pungukumian, ukumanna Alaata'ala na lipu' Sodom a malaina kalu pookokoikonon tia ukumanna Alaata'ala na kota iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Silaka' i kuu mian na kota Khorazim, ka' silaka' i kuu mian na kota Betsaida! Gause kalu upa kosamba' men niwawaumo na libutanmuu uga' isian niwawau na kota Tirus tia kota Sidon, mbaka' sabole mianna kota iya'a nanau'mo noko ponsosolimo ka' nangkadaraimo gau'na i raaya'a men ba'idek, ka' mopakean kasiongo'an, ka' momokela awu na wawona takala'na i raaya'a. Kasee i kuu sian. ");
INSERT INTO blzNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na tempo pungukumian, mianna Tirus tia Sidon a malaina ukumanna Alaata'ala pookokoikonon tia ukumanmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ka' i kuu mian na kota Kapernaum! Pinginti'imuu mbali' se' i kuu bo leengketon taka surugaa? Sian! Kuu bo tibarkonon na dodongoanna mian lapus!” ");
INSERT INTO blzNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kasi taeni Yesus na murit-Na, “Imepo a men momorongori i kuu, ia momorongori i Yaku'. Mian men kundakon i kuu, ia kundakon i Yaku'. Ka' mian men kundakon i Yaku', ia uga' kundakon i Ia men nomosuu' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Komburi'na, murit ni Yesus men pitumpulo' iya'a nomule'konmo tia noa men beles tuu'. Taena, “Tumpu, meenapo malolo' na ko'omai, gause i kai mamarenta i raaya'a mangaan ngaan-Muu!” ");
INSERT INTO blzNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ia simbati i Yesus tae-Na, “Yaku' nimiile' Ibiliis nandawo' nda'ara'amari langit koi bongki-bongkit. ");
INSERT INTO blzNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Imamat ini'imari! Kuu Yaku' taraimo kuasa kada' sida memee'i ule tia beua' ka' bo pungurungku'i giigii' kuasana mian men maso'kon i kuu, ka' sianta sa'angu'po a men sida minsilaka'i i kuu. ");
INSERT INTO blzNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mau mune' koiya'a, alia i kuu beles montookon meena malolo' na ko'omuu. Porena i kuu beles gause ngaanmuu nitulismo na surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yesus uga' nobeles na tempo iya'a gause ia barios Alus Molinas. Taeni Yesus, “Papa, Tumpu men montombonoi langit ka' tano' balaki'! Yaku' basukuur na Ko'omuu gause giigii' iya'a Kuu popowunikon na mian pande tia men pinginti'ianan, kasee Kuu pipiile'kon na mian men sian minginti'i upa-upa. Papa, ya'amo a men kinokana'na noa-Muu.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kasi i Yesus norobu tae-Na, “Giigii' upa ia poko rookonmo Tama na surugaa na Ingku'. Sa'angu'po mian sian minginti'i Anak. Men minginti'i Anak tongko' Tama na surugaa. Sa'angu'po mian sian minginti'i Tama na surugaa. Men minginti'i Tama na surugaa tongko' Anak ka' mian men kikira'na Anak bo pompopo'inti'ikon Tama.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kasi i Yesus ningilinga murit-Na men raaraaya'ana ka' norobu tae-Na, “Barakaatan i kuu gause nimiile'mo men kuu piile' koini'i. ");
INSERT INTO blzNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bantilkonon-Ku na ko'omuu se' biai'mo a nabii ka' tomundo' mbaripian men mingkira' mimiile' men koi kuu piile'mo koini'i, kasee i raaya'a sian nimiile'. Raaya'a mingkira' mongorongor men koi kuu rongormo koini'i, kasee i raaya'a sian nongorongor.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na sa'angu' tempo isian sa'angu' wawa ukum Torat nokumekerer bo mimitopongi i Yesus. Ia nimikirawarmo taena, “Guru, upa men bo wawauonku kada' sida mantausi tutuo' men pore pataka sidutu?” ");
INSERT INTO blzNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ia simbati i Yesus tae-Na, “Upa a men nitulis na ukum Torat? Koi upa a men kuu basa na ukum iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ia simbati wawa ukum Torat iya'a taena, “Kolingu'kon a Tumpu Alaata'ala tia noa men tuutuu', ka' tia giigii' wakamuu, ka' tia giigii' men pokoonmuu, ka' tia giigii' pinginti'ianmuu, ka' kolingu'kon a simbaya'muu mian koikoimo pongkolingu'konmuu wakamuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Taeni Yesus, “Simbatmuu kanooro'o tuutuu'! Wawaumo a men koiya'a, mbaka' i kuu bo tumuo'.” ");
INSERT INTO blzNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kasee ka' i ia mingkira' mompopokana' wakana, mbaka' ia nimikirawarmo ni Yesus taena, “Ime mbali' a simbaya'ku?” ");
INSERT INTO blzNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ia simbati i Yesus tae-Na, “Isian sa'angu' moro'one nalau na Yerusalem mae' na Yerikho. Na tanga'na salan, mian iya'a ia takaimo mian puraga ka' nirampasi a giigii' upa men isian na ko'ona. Mian iya'a nilana-lanas tamban somo noa banta-bantang, kasi niparerei rango-rangop na salan. Mian iya'a uga' tamban nobelaon men dodoa tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kasintuunganna iya'a isian sa'angu' imam men nolumiu na salan iya'a. Sarataa i ia nimiile' mian men rampa-rampap na salan iya'a, ia nolumilismo waale'e na soripi'na salan ka' nobakaliuliu. ");
INSERT INTO blzNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Koiya'a uga' a sa'angu' mian Lewi men nolumiu indo'o. Sarataa i ia nimiile' mian iya'a, ia uga' nolumilismo waale'e na soripi'na salan ka' nobakaliuliu. ");
INSERT INTO blzNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kasee komburi'na isian samba Samaria men na rae'anna uga' nolumiu indo'o. Sarataa ia nimiile' mian iya'a, notongkibitmo a noana gause nolingu'. ");
INSERT INTO blzNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mbaka' ia nuntuu'imo mian iya'a ka' nongoso'ikon belana tia anggur kasi ia pakuli' tia likison ka' nonggogoikon belana. Noko daa koiya'a, mian iya'a ia wootmo mian Samaria na keledaina, kasi niwawa na sa'angu' laigan tuukan ka' ia kalesang. ");
INSERT INTO blzNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Koi liilana ia nangalamo rua' doi' dinar ka' nongorookon na tombono laigan men notuukanna iya'a ka' taena, ‘Kalesangkonon a mian kani'i ka' kalu isian upa-upa sambana men paraluukononna, ko'ule'konankusi ro'omari ka' bayaronku.’” ");
INSERT INTO blzNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kasi i Yesus nangkakabusi tundunan-Na iya'a tia nobapikirawar tae-Na, “Pinginti'imuu, na totolu' mian kani'i, ime a simbaya'na mian men nipuraga a upa-upana iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ia simbati wawa ukum Torat iya'a taena, “Mian men nongkolingu'kon mian iya'a.” Taeni Yesus na ko'ona, “Alaka' limang uga' a men koiya'a!” ");
INSERT INTO blzNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Komburi'na i Yesus tia murit-Na ningimputkonmo rae'anna i raaya'a, kasi notaka na sa'angu' kampung. Indo'o isian sa'angu' wiwine men ngaanna i Marta nangalaboti i Yesus na laiganna. ");
INSERT INTO blzNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta isian sa'angu' utusna wiwine men ngaanna i Maria. Maria kani'i no'umoruang beebeel sarat ni Tumpu mongorongor pisiso'-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kasee i Marta tongko' ningilimang biai' palimangon na laigan bo pangkalesang i Yesus. Marta nuntuu'imo i Yesus ka' norobu taena, “Tumpu, nongko'upa i Kuu se' sian mingimamat utusku men mandalai i yaku' balimang suungku? Posuu'kon i ia muntulungi i yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ia simbati Tumpu tae-Na, “Marta, Marta! Koo babata ka' mongkomalingkon mingilimang biai' kaliangan palimangon. ");
INSERT INTO blzNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Poali men kana' tongko' sa'angu'. Ka' i Maria nungururukimo men porena iya'a, men sianmo alaon na ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na sa'angu' tempo i Yesus nosambayang na sa'angu' tampat. Noko daa Ia sambayang, sa'angu' murit-Na norobu taena, “Tumpu, kai mikipisiso' sambayang koi i Yohanes nimisiso' muritna sambayang.” ");
INSERT INTO blzNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mbaka' taeni Yesus na ko'ona i raaya'a, “Kalu i kuu sambayang, porobukon koi kani'imari: ‘Tama na surugaa, bi angga'ion a ngaan-Muu! Takakon a Batomundo'an-Muu. ");
INSERT INTO blzNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sulano taraion-Muu i kai sanda' ilio kakaan men kosukupmai. ");
INSERT INTO blzNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kai miki'ampuni dosamai, gause i kai uga' mangampuni sanda' mian men isian sala'na na ko'omai. Amo' dalaion i kai topongionna idek.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kasi taeni Yesus na ko'ona i raaya'a, “Kalu isian i kuu mae' na laiganna bela'muu tempo tanga'na rondom ka' morobu taemuu, ‘Bela', bolosiioon roti totolu', ");
INSERT INTO blzNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","gause isian bela'ku men banta-bantang na rae'anna notuuk na laiganku ka' i yaku' sianta kakaan bo pantaropingku i ia!’ ");
INSERT INTO blzNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sabole bela'muu men na laigan men kuu rae'i iya'a sian minsimbati i kuu tia wurung men koi kani'imari: ‘Alia minsinga i yaku'! Soopan ni'omporimo ka' i yaku' tia anakku noko tokolmo. Yaku' sian sida wangon ka' mantarai upa-upa bo ko'oom.’ ");
INSERT INTO blzNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bantilkonon-Ku na ko'omuu se' mau mune' mian iya'a bela'muu, ia bude' wangon ka' mantarai i kuu upa-upa. Kasee ka' i kuu sian poo'inti'i makamaa' tongko' mama'ase' liuliu, mbaka' bela'muu men na laigan iya'a bo wangon uga' ka' mantarai i kuu upa-upa men pa'ase'onmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mbali' iya'a, bantilkonon-Ku na ko'omuu, pama'ase', mbaka' i kuu bo taraion. Pansarak, mbaka' i kuu bo mantausi. Mikileaki, mbaka' omporon bo leakikonon i kuu. ");
INSERT INTO blzNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gause sanda' mian men mama'ase' bo taraion, ka' mian men mansarak bo mantausi, ka' mian men mikileaki omporon, omporon bo leakikonon. ");
INSERT INTO blzNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Na ko'omuu kani'i mbali', isian tama men mantarai ule na anakna kalu anakna mama'ase' susum? ");
INSERT INTO blzNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kabai se' mantarai beua' kalu ia mama'ase' opuu? ");
INSERT INTO blzNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mau mune' gau'muu malia' ba'idek, kasee sabole inti'ionmuu a men pore bo rookonon na anakmuu. Upa mune' a Tamamuu men na surugaa! Ia bo mongorookon Alus Molinas na mian men mama'ase' na Ko'ona!” ");
INSERT INTO blzNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na sa'angu' tempo i Yesus numbuse'i meena kada' umuar na sa'angu' mian men umu'. Sarataa meena iya'a no'umuar, mian iya'a ninsidamo norobu. Biai' a mian samba'. ");
INSERT INTO blzNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kasee isian mian men nangaan taena, “Ia namake kuasana Beelzebul men tanaasna meena bo numbuse'i-Na meena iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Isian uga' mian sambana men mingkira' mimitopongi i Yesus, mbaka' i raaya'a nama'ase' ni Yesus kada' mangawawau upa kosamba' bookoi oos se' i Ia notaka nda'ara'amari na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kasee i Yesus ninginti'i noana mian iya'a. Mbaka' i Ia norobumo na ko'ona i raaya'a tae-Na, “Kalu sa'angu' batomundo'an pookakaresa ka' sian pooka'amat, batomundo'an iya'a sabole sianmo umimput. Kalu sa'angu' suo' pookakaresa ka' sian pooka'amat, suo' iya'a sabole sian bakitaan. ");
INSERT INTO blzNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Koiya'a uga' na batomundo'anna Ibiliis. Kalu meenana pookakaresamo ka' pootimbangi raaraaya'amo, batomundo'an ni Ibiliis iya'a sianmo bakitaan. Ka' i kuu nangaan se' i Yaku' numbuse'i meena tia kuasana Beelzebul. ");
INSERT INTO blzNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kalu se' i Yaku' numbuse'i meena tia kuasana Beelzebul, ansee tia kuasana upa a mianmuu mumbuse'i meena? Mianmuusi iya'a a men bo mompopo'inti'ikon se' i kuu sala'! ");
INSERT INTO blzNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kasee kalu i Yaku' numbuse'i meena tia kuasana Alaata'ala, mbaka' sabole Batomundo'anna Alaata'ala notakamo na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kalu sa'angu' mian men moonggor tia sindapan men sukup mandagai laiganna, giigii' upana bo salamat. ");
INSERT INTO blzNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kasee kalu sa'angu' mian men moonggorna taka mangalawui ka' mungurungku'i i ia, mbaka' mian men moonggorna iya'a bo mangarampasi giigii' sindapan men kodaakononna tombono laigan iya'a, kasi mongobo-oboskon giigii' upana. ");
INSERT INTO blzNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ime a men sian umapak na Ingku', ia mangkakaresa i Yaku', ka' mian men sian umapak na Ingku' mambaraba'i palimangon-Ku!” ");
INSERT INTO blzNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kalu meena mamarerei sa'angu' mian, meena iya'a mae'mo tumikum na tampat men makangkung mansarak pintimalean, kasee ka' sian nantausi, ia norobu taena, ‘Yaku' bo mule'kon na laigan men yaku' parereimo!’ ");
INSERT INTO blzNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ia nomae'mo see nantakai laigan iya'a noloe'mo nikarei ka' nitotobo' pore-pore. ");
INSERT INTO blzNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kasi i ia no'umuar ka' nangange pitu' meena sambana men ba'idekna tii ia. Kasi i raaya'a ninsoop na mian iya'a, ka' nodumodongo indo'o. Komburi'na mian iya'a na'idekmo tuu' pookokoikonon tia men tumbena.” ");
INSERT INTO blzNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Noko daa i Yesus nangaan koiya'a, sa'angu' wiwine men isian na mian biai' iya'a norobu ni Yesus taena, “Barakaatan a wiwine men nangamea'kon ka' men nomosusui i Kuu!” ");
INSERT INTO blzNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ia simbati i Yesus tae-Na, “Indo'. Kasee men barakaatan tuu' mase mian men mongorongor wurungna Alaata'ala ka' mingimamat wurung iya'a!” ");
INSERT INTO blzNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tempo mian kaekae' biai' munguruuti i Yesus, Ia ningimputimo tundunan-Na tae-Na, “Mian men tumuo' na tempo koini'i ba'idek tuu'. Raaya'a mama'ase' sa'angu' upa kosamba' kada' i raaya'a mamarasaya i Yaku', kasee i raaya'a sian taraion sa'angu'po upa kosamba' saliwakon upa kosamba' men nosida ni Nabii Yunus. ");
INSERT INTO blzNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Koi Nabii Yunus men nosida oosan bona mian na lipu' Niniwe, koiya'a uga' a Anak Manusia bo sida oosan bona mian tempo koini'i. ");
INSERT INTO blzNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na tempo pungukumian ni'imarian, tomundo' wiwine na tano' paraas Selatan bo potuo'ion singka-singkat tia mian men tumuo' na tempo koini'i. Ka' i ia bo mansasala' mian men tumuo' na tempo koini'i. Tomundo' wiwine iya'a ringkat na ko'oloaan tuu', na puusna tano' balaki', ka' taka nomorongor pisiso' ni tomundo' Salomo men pinginti'ianan. Poali na ko'omuu koini'i isian men labi i Salomo a kobalaki'na! ");
INSERT INTO blzNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na tempo pungukumian ni'imarian, mian na lipu' Niniwe bo potuo'ion singka-singkat tia mian men tumuo' na tempo koini'i. Mianna Niniwe iya'a bo mansasala' mian men tumuo' tempo koini'i, gause i raaya'a nonsosolimo ka' nangkadaraimo gau'na men ba'idek na tempo i raaya'a nomorongor pisiso' ni Yunus. Poali men ka'ita koini'i a balaki'na tii Yunus!” ");
INSERT INTO blzNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Sianta mian men muntutungi boloak kasi manganaa' kabai mansa'u tia gumbang. Kasee i ia bo momokela boloak iya'a na sulaanna kada' mian men minsoop sida mimiile' ruarna. ");
INSERT INTO blzNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matamuu mase boloakna wakamuu. Kalu matamuu tarang, longkop wakamuu moruar. Kasee kalu matamuu sian tarang, mbaka' pika' a wakamuu. ");
INSERT INTO blzNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mbali' iya'a, maka'amat. Amo' ruar men isian na ko'omuu iya'a sida pika'. ");
INSERT INTO blzNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kalu longkop wakamuu moruar ka' sianta sambana men pika', mbaka' longkop wakamuu iya'a moruar tuu', koi men ia baangi ruarna boloak.” ");
INSERT INTO blzNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Noko daa i Yesus norobu, sa'angu' mian Farisi nangangemo i Ia kumaan na laiganna. Mbaka' i Yesus mae'mo nokumaan na laiganna mian Farisi iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mian Farisi iya'a samba' nimiile' i Yesus kumaan kasee sian ningoso' kutung koi aturanna agama. ");
INSERT INTO blzNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mbali' iya'a, Tumpu norobu na ko'ona tae-Na, “Wee i kuu mian Farisi! Kuu mongoso'i paraas liwana sasangkirmuu ka' leanmuu, kasee i kuu aribiru ka' wakamuu buke' tia wawau men ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kuu bobo'! Taasi' uga' Alaata'ala a men nangawawau paraas liwa iya'a, Ia uga' a men nangawawau paraas lalomna? ");
INSERT INTO blzNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Men isian na lalomna sasangkir ka' leanmuu a men tio rookononmuu na mian talalais. Kalu i kuu mangawawau men koiya'a, mbaka' paraas liwa tia paraas lalomna giigii' sida moloe' na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Silaka' i kuu mian Farisi! Ule'na aso-asokmuu koimo solasi ka' inggu ka' gala sambana, kuu rookon a koi sangobosan na lalomna sompulo' obosan bona Alaata'ala, kasee i kuu nongkolimbo'i wawau men maloos ka' sian mongkolingu'kon Alaata'ala. Men sa'angu' tio limangon ka' men sambana uga' amo' kolimbo'ion. ");
INSERT INTO blzNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Silaka' i kuu mian Farisi! Kuu mingkira' umoruang na oruangan men porena na laigan bakitumpuan, ka' beleskon angga'ionna mian na pasar. ");
INSERT INTO blzNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Silaka' i kuu! Kuu koi baleanan men sianta oosna. Mian men sumalan na wawona sian ninginti'i se' baleanan.” ");
INSERT INTO blzNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sa'angu' wawa ukum Torat norobu ni Yesus taena, “Guru, wurung-Muu men koiya'a uga' mingiroki i kai!” ");
INSERT INTO blzNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ia simbati i Yesus tae-Na, “Silaka' i kuu wawa ukum Torat! Kuu momosuu' mian mingilimang men marawat, kasee i kuu toro tiu'po sian muntulung mian kada' sida mingilimang men koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Silaka' i kuu! Kuu mangawawau baleanan men pore bona nabii poali pulimuu a men nampapatei nabii iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Wawau men kuu limangmo iya'a mompopo'inti'ikon se' i kuu mompotuutuu' upa men daamo ia wawau pulimuu. Gause tuutuu' i raaya'amo a men nampapatei nabii ka' i kuumo a men mompore-porei baleananna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mbali' iya'a, Alaata'ala men pinginti'i giigii' upa nangaan tae-Na, ‘Yaku' bo momosuu' nabii ka' poposuu'-Ku taka na ko'ona i raaya'a. Sambana bo papateion ka' sambana bo talalaison!’ ");
INSERT INTO blzNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mbaka' mian men tumuo' na tempo koini'i bo ukumon gause giigii' nabii men nipapatei iya'a na tempopo dunia kani'i nisidakon, ");
INSERT INTO blzNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nuntumbeipo nampapateian i Habel pataka nampapateian i Zakharia, men nosida na ola'na mesba ka' Laiganna Alaata'ala. Bantilkonon-Ku na ko'omuu se' mian men tumuo' na tempo koini'i bo ukumon gause giigii' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Silaka' i kuu wawa ukum Torat! Kunci bo pengeleaki soopan pinginti'ian ninaa' na ko'omuu, kasee i kuu bude' minsoop mansarak pinginti'ian iya'a. Ka' mian men daa mampari-pari minsoop mansarak pinginti'ian iya'a talantangionmuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sarataa i Yesus namarerei laigan iya'a, wawa ukum Torat ka' mian Farisi nomaso'konmo tuu' i Ia. Raaya'a ninggimataimo i Ia ka' nimikirawar biai' kaliangan kada' mansasalani i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Raaya'a mongorori wurung ni Yesus too upa men sala' na tundunan-Na kada' pangarakopanna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na loloon mian moruut tamban isian mian men kopee-pee'ian a saratna. Pintanga' a mian moruut, Yesus nuntumbeimo nimisiso' murit-Na. Tae-Na, “Maka'amat na ragina mian Farisi. Men panduung-Ku mase wawauna i raaya'a men minti palo-paloos. ");
INSERT INTO blzNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sianta upa mawuni men sian kampiile'an, ka' sianta upa men popowunion men sian ka'inti'ian. ");
INSERT INTO blzNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mbali' iya'a, upa men ngaanonmuu na kapintungan bo kamporongoran na karuaran, ka' men seasoikononmuu na tilingana mian na tambin bo lelekonon na mian biai'.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Bela'-Ku! Bantilkonon-Ku na ko'omuu se' alia i kuu layaonkon raaya'a men mampapatei waka kasee sian sida mangawawau men labi iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kasee siso'konon-Ku na ko'omuu ime a men tio kolayaonmuu. Alaata'ala a men kolayaon! Gause moko daa i Ia mampapatei, mbaka' Ia uga' kuasaan bo mintibarkon i kuu na lalomna naraka! Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' Iamo a men tio kolayaonmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Lima' sapu' pereet kalu balukkonon, angga'na tongko' rua' doi' men titiu'na tuu'. Mau mune' koiya'a sianta sa'angu'po a men kolimbo'ionna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wuukpo na takala'muu nisaa'mo giigii'. Mbali' iya'a, aliamomo' layaon, gause i kuu a umangga'na tia sapu' pereet men biai'!” ");
INSERT INTO blzNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Bantilkonon-Ku na ko'omuu se' mian men mompotuutuu' na mian biai' se' i ia pololo'-Ku, ia uga' bo potuutuu'onna Anak Manusia na malaa'ikatna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kasee i ime a men mangaan na mian se' i ia taasi' mian-Ku, mian iya'a uga' bantilkononna Anak Manusia na malaa'ikatna Alaata'ala se' i ia taasi' mian-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sanda' mian men mangaan upa-upa men mintimban Anak Manusia dauga' sida ampunion. Kasee kalu i ia mingiroki Alus Molinas, ia sian sida ampunion. ");
INSERT INTO blzNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kalu i kuu wawaon na tanaasna laigan bakitumpuan kabai na pamarenta ka' mian moola' sambana, alia i kuu babatakon too koi upa bo pansalangi wakamuu kabai upa a men tio bo ngaanonmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gause upa men tio ngaanonmuu iya'a bo siso'kononna Alus Molinas na tempona.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sa'angu' mian men isian na mian biai' iya'a nangaan ni Yesus taena, “Guru! Bantilkon na utusku kada' i kai poo'obos budelmai.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ia simbati i Yesus tae-Na, “Utus, ime mbali' a men nanganakat i Yaku' bo pungukumi kabai bo pongobos budelmuu rua' kuu?” ");
INSERT INTO blzNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Taeni Yesus soosoodo na giigii' mian men isian indo'o, “Pore-pore ka' maka'amat, alia i kuu mingkira'kon kupang biai'. Gause tutuo'na mian taasi' kupang a bo pinginti'i, mau mune' kupangna biai' tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kasi i Yesus nuntundunkon na ko'ona i raaya'a timbaani' men koi kani'imari: “Isian sa'angu' mian kupangon. Ia isian tano'na men biai' tuu' a ule'na. ");
INSERT INTO blzNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mian kupangon iya'a norobumo na noana taena, ‘Upa a men tio limangonku, gause i yaku' sianta tampat bo panganaa'anku ule'na tano'ku?’ ");
INSERT INTO blzNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kasi taena, ‘Koi kani'imarimo a men bo wawauonku. Alangku runtunionkumo kasi yaku' mangawawau men balaki' kada' bo panganaa'anku giigii' gandumku ka' upangku men sambana. ");
INSERT INTO blzNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Noko daa koiya'a yaku' bo morobu na noangku: Yaku' nontombonoimo upa-upa biai' men sianta kabus pataka toropii taun. Koini'i yaku' mintimalemo, kumaan, ba'inum ka' munsuri beles!’ ");
INSERT INTO blzNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kasee Alaata'ala norobu na ko'ona tae-Na, ‘Wee i koo mian bobo'! Malom kani'i uga' noaam bo ule'ionna Tumpu. Kasi ime a men bo pontombonoi giigii' kupang men koo tambunmo bo ko'oom iya'a?’ ");
INSERT INTO blzNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Koiya'a a kosidaanna na sanda' mian men mampari-pari bi kupangon bona waka-wakana, kasee sian mampari-pari kupangon men daa koi pingkira'na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kasi i Yesus norobu na murit-Na tae-Na, “Mbali' iya'a, bantilkonon-Ku na ko'omuu se' alia i kuu babatakon tutuo'muu, na upa men bo kaanon ka' inumonmuu. Alia babatakon wakamuu na upa men bo pakeanmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gause tutuo'muu a umangga'na tia kakaan, ka' wakamuu a umangga'na tia pakean. ");
INSERT INTO blzNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Piile' a sapu' paapaa'! Raaya'a sianta mangasok, sianta mamadak, uga' sianta wokung kabai alang. Kasee Alaata'ala mamakaan raaya'a! Kuu a umangga'na tuu' tia sapu' iya'a! ");
INSERT INTO blzNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Isian mbali' i kuu men gause babata, ninsidakon umurmuu nokanturangan mau mune' tongko' titiu'? ");
INSERT INTO blzNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kalu tongko' upa men morio' iya'a sianmo pokoonmuu wawauon, nongko'upa mbali' i kuu se' babatakon upa-upa sambana? ");
INSERT INTO blzNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Piile' uga' a bunga! Ia sian balimang, ka' sian mangawawau pakean, kasee pore a tutuo'na. Bantilkonon-Ku na ko'omuu se' i Tomundo' Salomopo men kupangon tuu' sian nopake men koi koporena bunga iya'a! ");
INSERT INTO blzNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Rakut na ale' tumuo' koini'i kasee liila kabus tunuon. Mau mune' koiya'a, Alaata'ala namakei rakut iya'a men tamban pore tuu'. Upa mune' i kuu! Kasee i kuu sian laan parasaya! ");
INSERT INTO blzNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mbaka' alia babatakon ka' susakon upa men bo kaanonmuu ka' inumonmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Giigii' iya'a sarakonna lipu' na tano' balaki' kani'i men sian minginti'i Alaata'ala. Kasee Tamamuu na surugaa inti-inti'i se' i kuu mamaraluukon giigii' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kasee sarak kutung a batomundo'an-Na, mbaka' giigii' men paraluukononmuu iya'a uga' bo rookonon-Na.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kuu men tongko' titiu' kuu, alia layaon! Gause Tamamuu na surugaa mingkira' minsidakon i kuu mian na batomundo'an-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Balukkon a upa-upamuu ka' rookon a doi'na na mian talalais. Wawau bo ko'omuu a dompet men sianta kobaraba'ian, ya'amo kupang men ninaa' na surugaa. Kupang iya'a sianta kabus gause mian mamangan sian momoko mangala ka' apat sian momoko mambaraba'i. ");
INSERT INTO blzNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gause aana a kupangmuu mbaka' ino'o uga' a kokabusanna a noamuu!” ");
INSERT INTO blzNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kuu tio sinampang batoropot mopake ka' boloakmuu sinampang kumait, ");
INSERT INTO blzNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","koikoimo tia tutulungi men pintanga' mempeperai tanaasna mule'kon ra'amari na ramean posuo'an. Kalu tanaas iya'a mule'kon ka' mentenggor soopan, raaya'a bo donga-dongan mengeleaki soopan. ");
INSERT INTO blzNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Barakaatan a tutulungi men nitakai notoropotmo na tempo tanaasna nomule'kon. Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' tanaas iya'a bo batoropot ka' momosuu' tutulungina iya'a umoruang, kasi i ia mantaropi i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Barakaatan a tutulungi iya'a kalu tanaasna nantakai i raaya'a notoropotmo, mau mune' i ia taka na tanga'na rondom kabai se' karani'mo ilio! ");
INSERT INTO blzNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Imamat ini'imari! Kalu tombono laigan inti-inti'i se' jaam pipii a kotakaanna mian mamangan, ia bo badaga kada' mian mamangan sian minsoop na laiganna. ");
INSERT INTO blzNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mbali' iya'a, kuu uga' tio batoropot, gause Anak Manusia bo taka na tempo men sian sasaakionmuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ia pikirawar i Petrus taena, “Tumpu, too patukna timbaani' iya'a bo ko'omai kabai se' bona giigii' mian?” ");
INSERT INTO blzNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ia simbati Tumpu tae-Na, “Kalu isian tutulungi men malolo' ka' motu'a a noana, iamo a men nakatonna tanaasna bo pantanaasi tutulungi sambana ka' mantarai i raaya'a kumaan na tempona. ");
INSERT INTO blzNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Barakaatan a tutulungi iya'a kalu tanaasna mule'kon ka' mantakai i ia pintanga' mingilimang palimangonna! ");
INSERT INTO blzNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' tanaas iya'a bo mamarasayakon giigii' kupangna na tutulungi iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kasee kalu tutulungi iya'a ba'idek, ia bo morobu na noana taena, ‘Tanaasku dauga' manau' ka' mule'kon.’ Mbaka' ia nampapolosimo tutulungi moro'one tia wiwine ka' nokumaan ka' ba'inum pataka nolio'. ");
INSERT INTO blzNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mbaka' tanaasna bo mule'kon na ilio men sian sasaakion tutulungi iya'a, ka' jaam men sian inti'ion. Ka' tutulungi iya'a bo papolosionna ka' sidakonon koikoimo tia mian men sian malolo' na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tutulungi men minginti'i pingkira'na tanaasna kasee sian batoropot ka' sian mangawawau pingkira'na tanaasna iya'a bo pukulon piribiai'. ");
INSERT INTO blzNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kasee tutulungi men sian minginti'i pingkira'na tanaasna ka' komburi'na nangawawau upa men sala' pataka i ia tio papolosion, ia bo papolosion men sian laan dodoa. Kasee mian men nitaraimo biai', uga' biai' a men pa'ase'on na ko'ona. Ka' mian men nitarai kaparasaya'an biai', sabole uga' biai' a men pa'ase'on na ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yaku' taka bo mantakakon apu na tano' balaki' kani'i. Ooskonon-Ku tuu' apuna noko leapmo! ");
INSERT INTO blzNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Dauga' isian repaan dodoa men tio salanion-Ku. Ka' noang-Ku siasa tuu' kalu repaan iya'a sianpo salanion-Ku. ");
INSERT INTO blzNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pansaruimuu se' tatakang-Ku mantakakon pooka'amatan na tano' balaki'? Sian, taasi' pooka'amatan, kasee mantakakon mian sida poosinsala'. ");
INSERT INTO blzNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Muntumbei koini'i, suo' men isian lima' mian sianmo pokakana'. Totolu' mintimbangi rurua' kabai rurua' mintimbangi totolu'. ");
INSERT INTO blzNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tama sian mangka'amat anakna moro'one, ka' anak moro'one sian mangka'amat tamana. Sina sian mangka'amat anakna men wiwine, ka' anak wiwine sian mangka'amat sinana. Monian wiwine sian mangka'amat boroki'na anak, koiya'a uga' boroki'na anak sian mangka'amat monianna men wiwine.” ");
INSERT INTO blzNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus norobu soosoodo na mian biai' tae-Na, “Kalu i kuu mimiile' antong paraas sopokan, kuu liuliu mangaan, ‘Bo usan.’ Ka' tuutuu' usan. ");
INSERT INTO blzNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kalu i kuu munsuri mombuul taka paraas selatan, kuu mangaan, ‘Bo pengkar.’ Ka' tuutuu' pengkar. ");
INSERT INTO blzNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wee i kuu men minti pande-pande! Kuu minginti'i mimiile' oosan na langit ka' na katano'an pataka i kuu minginti'i upa men bo sida. Nongko'upa mbali' i kuu se' sian minginti'i mimiile' upa men ia limang Alaata'ala na tempo koini'i?” ");
INSERT INTO blzNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nongko'upa mbali' se' sian inti'ionmuu a upa men daa kana'? ");
INSERT INTO blzNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kalu isian mian mongowoot i kuu na mian men bo pungukumi, pari-pari ka' pooka'amat tii ia tempo i kuu dauga' potorae' na salan. Kalu sian, mbaka' i kuu wootonnamo mian iya'a na pungukumi, ka' pungukumi iya'a bo mongorookon i kuu na pulisi, ka' pulisi bo monsoopkon i kuu na tarungkuan. ");
INSERT INTO blzNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Bantilkonon-Ku na ko'omuu se' i kuu sian umuar na tarungkuan kalu giigii' samayamuu sianpo bontor.” ");
INSERT INTO blzNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na tempo i Yesus pintanga' batundun na murit-Na ka' na mian biai', isian mian notaka na Ko'ona nuntundun toropii samba Galilea men ia papatei i Pilatus na tempo i raaya'a pintanga' mongorookon kurbaan na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nongorongor tundunan iya'a, Yesus norobumo tae-Na, “Gause samba Galilea iya'a nipapatei men koiya'a, mbaka' surionmuu se' i raaya'a a balaki'na dosana na giigii' samba Galilea men sambana? ");
INSERT INTO blzNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sabole sian! Kasee bantilkonon-Ku na ko'omuu se' kalu i kuu sian monsosoli ka' mangkadarai gau'muu men ba'idek, kuu giigii' uga' bo silaka' koikoimo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Koi upa uga' tia sompulo' walu' mian men nolapus na Siloam, na tempo menara iya'a nungutun i raaya'a? Kuu mansarui iya'a minsiso'kon se' i raaya'a a biai' a sala'na pookokoikonon tia giigii' mian sambana men dumodongo na Yerusalem? ");
INSERT INTO blzNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Sabole sian! Kasee bantilkonon-Ku na ko'omuu se' kalu i kuu sian monsosoli ka' mangkadarai gau'muu men ba'idek, kuu giigii' uga' bo silaka' koikoimo i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Noko daa koiya'a ai Yesus nuntundunkonmo timbaani' men koi kani'imari tae-Na, “Isian sa'angu' mian men montombonoi kau ara na ale'na anggurna. Sa'angu' ilio ia nomae'mo mansarak woo'na kau iya'a, kasee sawuraspo sian nantausi. ");
INSERT INTO blzNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mbaka' i ia norobumo na dadagai ale' iya'a taena, ‘Piile'! Tolu'mo taun i yaku' taka mansarak woo'na ara na kauna kaya'a, kasee sian nontoo tausi sawuraspo. Tara'mo a kau kaya'a! Ia tongko' mamakabus likisonna tano'!’ ");
INSERT INTO blzNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kasee dadagai ale' iya'a ninsimbati taena, ‘Tuan, patalai ia tumuo' na taun kani'i soosoodo. Yaku' dauga' kutung mengkeke tano' na tiku-tikumna ka' momokelai pupuk, ");
INSERT INTO blzNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","too daa i ia miwoo' na taun nda'ana. Kasee kalu sian, kuu sidamo mantara'i.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na sa'angu' ilio Sabat, Yesus nimisiso' na sa'angu' laigan bakitumpuan. ");
INSERT INTO blzNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Indo'o isian wiwine men sompulo'mo walu' taun manggeo, gause ia lampingi meena. Wiwine iya'a boboru'ut ka' sian maloos a kekererna. ");
INSERT INTO blzNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na tempo i Yesus nimiile' wiwine iya'a, Ia leelo'mo muntuu'i i Ia, kasi norobu tae-Na, “Oo naung, kuu nalesi'mo!” ");
INSERT INTO blzNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kasi i Yesus nengepetkon lima-Na na wiwine iya'a, ka' na tempo iya'a uga' naloosmo a kekererna, kasi wiwine iya'a nuntunde' Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tanaasna laigan bakitumpuan iya'a nomaso'mo gause i Yesus nengelesi'i mian na ilio Sabat. Mbali' tanaas iya'a norobu na mian biai' taena, “Isian noom ilio a bo balimangan. Mbali' iya'a, mai taka na ilio sambana kada' lesi'ion. Alia na ilio Sabat!” ");
INSERT INTO blzNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ia simbati Tumpu tae-Na, “Kuu mian men minti pa'a-pa'agama! Na ilio Sabat giigii' mian munguarkon sapi' kabai keledaina na eko'anna ka' mangawawa bo pi'inumion. ");
INSERT INTO blzNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kasee kani'i na ko'onta koini'i isian sa'angu' wiwine lee' ni Abraham, men sompulo'mo walu' taun a nau'na ia koot Ibiliis. Sian sida mbali' i ia lakaion a kokootna na ilio Sabat?” ");
INSERT INTO blzNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ninsimbati ni Yesus iya'a kinakamaa'na tuu' mian men maso'kon i Ia, kasee giigii' mian sambana beles nimiile' giigii' wawau kosamba' men ia limangmo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesus nimikirawar tae-Na, “Koi upa a Batomundo'anna Alaata'ala? Koi upa a pomookokoikonan-Ku? ");
INSERT INTO blzNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Batomundo'an-Na koi watuna sasawi ia ala mian kasi nikambur na ale'na. Watuna iya'a tumuo' kasi ningkau ka' sapu' mangawawau peetana na panga'na.” ");
INSERT INTO blzNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus nimikirawar soosoodo tae-Na, “Koi upa a pomookokoikonan-Ku Batomundo'anna Alaata'ala? ");
INSERT INTO blzNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Batomundo'anna Alaata'ala koi ragi men ia ala sa'angu' wiwine, kasi ia lauk na patompulo' liter tarigu ka' nikior pataka no'uminsur giigii'.” ");
INSERT INTO blzNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na rae'an mae' na Yerusalem, Yesus lumiu na toropii kota tia kampung pori-porimban mimisiso'. ");
INSERT INTO blzNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kasi isian mian men nimikirawar na Ko'ona taena, “Tumpu, tongko' titiu' a mian men daa bo salamatkonon?” ");
INSERT INTO blzNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesus norobumo na mian iraando'o tae-Na, “Pari-pari a minsoop na soopan men itiu'. Bantilkonon-Ku na ko'omuu se' biai' a mian bo mampari-pari minsoop kasee sianmo sida. ");
INSERT INTO blzNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Gause na tempo tombono laigan wangon ka' mongompori soopanna, kuu somo potokekerer na liwana ka' mentenggor omporon kasi morobu taemuu, ‘Tuan! Kai miki leakikon soopan kada' i kai minsoop.’ Tombono laigan iya'a bo minsimbati taena, ‘Yaku' sian ninginti'i se' ringkat aana i kuu!’ ");
INSERT INTO blzNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kuu bo minsimbati taemuu, ‘Kai nokumaanmo ka' noba'inummo ruru-ruru' tii Kuu, ka' i Kuu uga' daamo nimisiso' i kai na bendar na kotamai!’ ");
INSERT INTO blzNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kasee i Ia bo morobu soosoodo taena, ‘Yaku' sian ninginti'i i kuu se' ime. Rae'! Alia ka'ita i kuu men nangawawau upa ba'idek!’ ");
INSERT INTO blzNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na tempo i kuu mimiile' i Abraham, Ishak ka' i Yakub tia giigii' nabii na Batomundo'anna Alaata'ala, kuu bo tumando' ka' marepa tuu' gause i kuu nitibarkonmo na liwa! ");
INSERT INTO blzNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ka' mian men ringkat na paraas bete'an ka' paraas sopokan, paraas utara ka' paraas selatan, bo taka umoruang kumaan na Batomundo'anna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Imamat ini'imari! Isian mian men tongkomburi' bo sida mian men tongolukon, ka' isian mian men tongolukon bo sida mian men tongkomburi'.” ");
INSERT INTO blzNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na tempo i Yesus pintanga' mimisiso', isian toropii mian Farisi taka na Ko'ona ka' norobu taena, “Alia dumodongo ka'ita! Rae'mo na dodongoan sambana, gause i Herodes mansagia mampapatei i Koo.” ");
INSERT INTO blzNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ia simbati i Yesus tae-Na, “Rae' bantilkon na mian men ba'idek a noana iya'a inta', ‘Ilio kani'i tia liila Yaku' mumbuse'i meena ka' mengelesi'i mian manggeo, kasee na ilio kotolu'na, Yaku' bo mamakabus palimangon-Ku.’ ");
INSERT INTO blzNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mau mune' koiya'a Yaku' tio mingimputkon rae'an-Ku ilio kani'i, liila ka' ipuan, gause sa'angu' nabii sian sida papateion kalu taasi' na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalem! Yerusalem! Nabii kuu papatei! Mian men ia posuu' Alaata'ala kuu lapak tia watu pataka lapus! Piribiai'mo i Yaku' mingkira' mongoroot giigii' mian men dumodongo na ko'omuu koi sinana siok mongopo'i anakna na intuna laina, kasee i kuu bude'! ");
INSERT INTO blzNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Imamat ini'imari! Laiganmuu kani'i bo parereion. Bantilkonon-Ku na ko'omuu se' supu koini'i i kuu sianmo mimiile' i Yaku' soosoodo pataka i kuu morobu taemuu, ‘Barakaation i Ia men taka pokauonna Tumpu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na sa'angu' ilio Sabat, Yesus nomae' kumaan na laiganna sa'angu' tanaasna mian Farisi. Giigii' mian men isian indo'o namakanasai tuu' i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kasi notaka a sa'angu' mian men bangkak a saratna tia limana. ");
INSERT INTO blzNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kasi i Yesus nimikirawar na wawa ukum Torat ka' mian Farisi men isian indo'o tae-Na, “Koi taena ukumna agamanta, sida i kita mengelesi'i mian manggeo na ilio Sabat kabai sian?” ");
INSERT INTO blzNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wawa ukum Torat ka' mian Farisi iya'a tongko' rokot. Kasi i Yesus ningintoni limana mian iya'a ka' nengelesi'i, kasi nomosuu' i ia mule'kon. ");
INSERT INTO blzNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Noko daa koiya'a i Yesus norobumo na mian biai' tae-Na, “Kalu i kuu isian anakmuu kabai sapi'muu men mandawo' na lobong tambu'an na ilio Sabat, kuu mbali' sian liuliu mongowoot ka' munguarkon anak kabai sapi' iya'a na ilio iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kasee sa'angu'po mian sian nomoko ninsimbati i Yesus na upa men Ia pikirawar. ");
INSERT INTO blzNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus nimiile' isian toropii sawe' men mungururuki oruangan men porena tuu'. Mbali' iya'a i Ia nuntundunkon timbaani' na ko'ona i raaya'a koi kani'imari, tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kalu i kuu leelo'on na ramean posuo'an, alia i kuu mae' umoruang na oruangan men angga'ion. Gause kalu taka a mian sambana men nileelo' men angga'ion labi i kuu, ");
INSERT INTO blzNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","mbaka' tombono laigan men nengeleelo'mo i kuu somo bo taka na ko'omuu ka' mambantilkon taena, ‘Amo'si kookoo'an, oruangan kani'i nitoropotikonmo bona sawe' kale'e.’ Mbaka' tia noa men makamaa' i kuu somo umoruang na oruangan men na puusna tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mbali' iya'a, kalu i kuu nileelo' na ramean posuo'an, ruruki a oruangan men na puusna kada' tombono laigan bo taka ka' mangaan na ko'omuu taena, ‘Bela', mai oruang na oruangan men porena.’ Mbaka' i kuu daa ni'angga'i na aropna giigii' sawe' men sambana. ");
INSERT INTO blzNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mian men mompopodaa wakana bo popokoo'on, ka' mian men mompopokoo' wakana bo popodaaon.” ");
INSERT INTO blzNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kasi taeni Yesus na tombono laigan, “Kalu i kuu mengleelo' mian bo mangawawau ramean kumaan ilio kabai kumaan malom, alia mengeleelo' bela'muu, kabai utusmuu, kabai poto'utusanmuu, kabai se' pootolodoianmuu men kupangon. Gause komburi'na i raaya'a bo mengleelo' i kuu uga', ka' tia men koiya'a i kuu mangalabot walosna wawaumuu men nengeleelo' i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kasee kalu i kuu mangawawau ramean, alaka' leelo' a mian men talalais, mian men kaempa'on, mian repo', ka' mian mampisok. ");
INSERT INTO blzNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kuu bo barakaation, gause mian men koiya'a sian momoko mangawalos kaporeanmuu. Kaporeanmuu bo waloskononna Alaata'ala na tempo mian men kana' a wawauna potuo'ion.” ");
INSERT INTO blzNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na tempo sa'angu' mian men nokumaan ruru-ruru' tii raaya'a indo'o nongorongor wurung ni Yesus, ia norobumo taena, “Barakaatan a mian men bo kumaan na Batomundo'anna Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kasee i Yesus norobu na mian iya'a tae-Na, “Isian sa'angu' mian nangawawau ramean men balaki' ka' nengeleelo' mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tempo puntumbeian ramean, mian iya'a nomosuu'mo tutulungina mae' na giigii' mian men ia ange taena, ‘Maimo. Wiwi'na noko toropotmo!’ ");
INSERT INTO blzNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kasee i raaya'a giigii', sa'angu'-sa'angu' nama'ase' kada' i raaya'a amo' kookoo'ion. Men olukon norobumo na tutulungi iya'a taena, ‘Yaku' baasi ningili ale' ka' i yaku' dauga' mae' mimiile'. Amo'si kookoo'ion i yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Men sambana nangaan taena, ‘Yaku' baasi ningili sapi' lima' paar ka' dauga' mimitopongi sapi' iya'a. Amo'si kookoo'ion i yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Men sambana soosoodo nangaan taena, ‘Yaku' baasi nosuo'. Mbali' iya'a, yaku' sianpo minsida taka.’ ");
INSERT INTO blzNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tutulungi iya'a nomule'konmo ka' nambantilkon men koiya'a na tanaasna. Tanaas iya'a nomaso'mo, ka' norobu na tutulungina taena, ‘Rae' dongan na bendar ka' na salan na kota. Wawamo ro'omari a mian talalais, mian men kaempa'on, mian mampisok ka' mian men repo'.’ ");
INSERT INTO blzNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Noko daa koiya'a tutulungi iya'a norobumo taena, ‘Tanaas, men kuu posuu'kon daa yaku' limangmo, kasee oruangan dauga' isian.’ ");
INSERT INTO blzNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kasi tanaas iya'a norobu taena, ‘Rae' na sanda' salanoa' ka' na pogolimpanga'anna salan na liwana kota, ka' pari-pari a mian iraando'o taka minsoop laiganku kada' buke' tia mian. ");
INSERT INTO blzNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bantilkononku na ko'omuu se' sianta sa'angu'po a mian men nileelo'mo olukon iya'a bo kumaan na rameanku kani'i!’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Biai' a mian nomae' poololo' i Yesus. Yesus ningilingamo i raaya'a ka' norobu tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mian men taka na Ingku' see mongkolingu'kon sinana, tamana, boroki'na, anakna, utusna, kabai se' wakana suungna labi tia pongkolingu'konna i Yaku', ia sian sida bo murit-Ku. ");
INSERT INTO blzNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Imepo a men bude' mamasa'an saliipna ka' mongololo' i Yaku', ia sian sida bo murit-Ku. ");
INSERT INTO blzNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kalu isian i kuu mingkira' mangawawau sa'angu' menara, men olukonionmuu sabole umoruang mansaa' doi'muu kada' inti'ionmuu too sukup bo pangawawau menara iya'a kabai sian. ");
INSERT INTO blzNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Gause kalu komburi'na menara iya'a sian kabus niwawau, kasee pandasina nipoko wawaumo, mbaka' giigii' mian men nimiile' palimangon iya'a bo mongkolengkei i kuu. ");
INSERT INTO blzNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Raaya'a bo mangaan taena, ‘Piile'! Mian kani'i nuntumbeimo nangawawau menara, kasee sianmo ia kabus niwawau!’ ");
INSERT INTO blzNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kalu sa'angu' tomundo' men isian sompulo' loloon surudadu bo poopapate tia tomundo' sambana men isian ruampulo' loloon surudadu, sabole men olukon wawauonna ia umoruang kutung mompoo'inarutikon too daa pokoonna mintimbangi tomundo' iya'a kabai sian. ");
INSERT INTO blzNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kalu inti'ionna se' sian tuaionna, sabole dauga'po oloa tomundo' iya'a, ia momosuu'mo mianna mimikirawar koi upa kada' sida pooka'amat.” ");
INSERT INTO blzNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kokomburi'anna i Yesus norobu tae-Na, “Koiya'a uga' i kuu. Sianta sa'angu'po a men bo sida murit-Ku, kalu i ia sian mansapukon giigii' upa men ia tombonoi.” ");
INSERT INTO blzNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Timuson iya'a pore, kasee kalu nalambasmo, sida mbali' wawauon ma'asing soosoodo? ");
INSERT INTO blzNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sianmo kana'na, mau bona ale' kabai se' bo pupuk. Mbaka' somo bo balo'konon. Daa tilingaan, imamat pore-pore!” ");
INSERT INTO blzNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na sa'angu' tempo, biai' a pagawena pajak ka' mian men sian malolo' na aturan agama taka mongorongor i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mian Farisi ka' wawa ukum Torat nokokoo'anmo. Taena, “Mian kale'e mangalaboti mian dosaon ka' uga' kumaan tii raaya'a!” ");
INSERT INTO blzNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mbali' iya'a i Yesus nuntundunkonmo na ko'ona i raaya'a timbaani' men koi kani'imari, tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kalu isian i kuu men dombaan sa'atu, kasi domba iya'a nopenta' a sa'angu', koi upa bo wawauonmuu? Sabole i kuu mamarerei domba men siompulo' sio' iya'a na padang ka' mae' mansarak men nopenta' iya'a pataka tausionmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ka' kalu kuu tausimo a domba iya'a, kuu lewa' tuu', kasi pasa'anonmuu, ");
INSERT INTO blzNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ka' mule'kon. Komburi'na kuu mengeleelo'mo bela'muu ka' pootolodoianmuu ka' mambantil taemuu, ‘Mai kita balewa-lewa'. Dombangku men nopenta' iya'a yaku' tausimo soosoodo!’ ");
INSERT INTO blzNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bantilkonon-Ku na ko'omuu se' koiya'a uga' na surugaa. Isian men bo kobeles tuu' kalu isian sa'angu' mian dosaon men nonsosolimo ka' nangkadaraimo gau'na men ba'idek. Pongkobelesi labi tia belesna siompulo' sio' mian men pore men sian mamaraluukon monsosoli ka' mangkadarai gau'na men ba'idek.” ");
INSERT INTO blzNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kabai se' kalu sa'angu' wiwine men isian sompulo' doi' dirham, kasi nopenta' a sa'angu', upamo a men bo wawauonna? Ia bo muntutungi boloak ka' mangkarei laiganna ka' mansarak pore-pore pataka tausionna a doi' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na tempo doi' iya'a ia tausimo, ia mengeleelo'mo simbaya'na tia pootolodoianna, kasi mambantilkon taena, ‘Beles tuu' i yaku'. Daa yaku' tausimo soosoodo a doi'ku men nopenta'. Mai kita balewa-lewa'!’ ");
INSERT INTO blzNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bantilkonon-Ku na ko'omuu se' koiya'a uga' a malaa'ikatna Alaata'ala beles kalu isian sa'angu' mian dosaon monsosoli ka' mangkadarai gau'na men ba'idek.” ");
INSERT INTO blzNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus norobu soosoodo tae-Na, “Isian sa'angu' mian men anakon moro'one rurua'. ");
INSERT INTO blzNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Men itiu'na norobu na tamana taena, ‘Papa, rookonmo i yaku' koini'i a obosku na kupangta.’ Mbaka' tamana nongoboskonmo kupangna iya'a na anakna rurua'. ");
INSERT INTO blzNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Toropii ilio a noporusanna, anakna itiu'na iya'a nambalukkonmo obosna kasi nomae' na dodongoan men oloa. Inda'a ia nambaraba'imo doi'na tia wawau men sian kana'na. ");
INSERT INTO blzNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sarataa giigii' doi'na nokabus, na lipu' iya'a ia takaimo sa'angu' repaan pololuan men dodoa, pataka ia nuntumbeimo marepa. ");
INSERT INTO blzNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kasi i ia nomae' balimang na sa'angu' mian men tombono dodongoan iya'a. Mian iya'a nomosuu'mo i ia mae' na ale'na mandagaikon bau'na. ");
INSERT INTO blzNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ia nololu tuu' tamban mingkira' mingisii kompongna tia mangkaan kakaanna bau' iya'a. Mau mune' koiya'a a loluna, sianta sa'angu'po a mian men nantarai kakaan bo ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Na kokomburi'anna ia notonginau'mo ka' norobu taena, ‘Mian biai' men balimang na tamangku labian a kakaanna i raaya'a, kasee i yaku' kani'i boomo lapuskon mololu! ");
INSERT INTO blzNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yaku' bo mule'kon na tamangku ka' morobu na ko'ona men koi kani'imari: Papa, yaku' nodosaonmo na Alaata'ala ka' na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yaku' sianmo kana' bo ngaanon anakmuu soosoodo. Posidamo i yaku' kani'i bookoi papalimang men tamboionmuu.’ ");
INSERT INTO blzNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mbaka' i ia norumingkatmo mule'kon na tamana. Dauga' oloa a laigan, tamana noko pontoa'imo i ia. Gause lingu'na tamana mbaka' ia notumetende'mo ka' nomootuungi anakna iya'a, kasi ia root ka' ni'ooki. ");
INSERT INTO blzNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Taena anak iya'a, ‘Papa, yaku' nodosaonmo na Alaata'ala ka' na ko'omuu. Yaku' sianmo kana'na bo ngaanon anakmuu soosoodo.’ ");
INSERT INTO blzNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kasee tamana nengeleelo'mo tutulungina ka' norobu taena, ‘Dongan! Ala pakean men porena tuu' ka' popisokikon na ko'ona. Posinsimi ka' posapatoi. ");
INSERT INTO blzNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Noko daa koiya'a, pangala anakna sapi' men molongo' ka' pongkoyo'. Kita bo kumaan ka' balewa-lewa'. ");
INSERT INTO blzNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gause anakku kani'i nolapusmo, kasee koini'i notuo'mo soosoodo. Ia nopenta'mo, kasee koini'i nitausimo soosoodo.’ Kasi i raaya'a nuntumbei barame. ");
INSERT INTO blzNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tempo iya'a, anak men balaki'na dauga' na ale'. Sarataa i ia nomule'kon ka' karani'mo laigan, ia rongor isian laungna musiik ka' mian manari. ");
INSERT INTO blzNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mbaka' ia nengeleelo'mo sa'angu' mian tutulungina, kasi nimikirawar taena, ‘Isian upa na laigan kani'i?’ ");
INSERT INTO blzNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ia simbati tutulungi iya'a taena, ‘Utusmuu itiu'na notakamo! Ka' tamamuu nomosuu'mo nongkoyo' anakna sapi' men molongo', gause anak iya'a ia tausimo soosoodo see daa sian nongko'upa.’ ");
INSERT INTO blzNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Anak men balaki'na iya'a noburuki'mo tamban ia sianmo ninsoop na laigan. Kasi tamana no'umuar ka' nangande-ande i ia kada' waale'e minsoop. ");
INSERT INTO blzNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kasee taena anak iya'a, ‘Piile'! Taunanmo a nau'na yaku' balimang bo ko'omuu. Giigii' upa men kuu posuu'kon yaku' sian nontoo panggagai. Kasee upa a men kuu rookon na ingku'? Sa'angu'po bembe' sian kuu rookon i yaku' bo barameanku tia simbaya'ku! ");
INSERT INTO blzNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Anakmuu kaya'a tongko' mingkira' namakabus kupangmuu na wiwine men eloon, kasee sarataa ia nomule'kon, kuu nongkoyo'mo anakna sapi' men molongo' bo ko'ona!’ ");
INSERT INTO blzNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ia simbati tamana taena, ‘Anakku! Koo a men mokani'i tii yaku'. Giigii' men yaku' tombonoi koo uga' a men tombono. ");
INSERT INTO blzNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kasee kita salanan mangawawau ramean ka' balewa-lewa', gause utuus itiu'na iya'a nolapusmo, kasee koini'i notuo'mo soosoodo. Ia nopenta'mo, kasee koini'i nitausimo soosoodo.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Taeni Yesus na murit-Na, “Isian sa'angu' mian kupangon. Mian iya'a montombonoi sa'angu' pagawe panganaa' doi' men mungurus kupangna. Mian kupangon iya'a niparawooti se' pagawena iya'a nambarundais doi'na. ");
INSERT INTO blzNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mbaka' ia nengeleelo'mo pagawe panganaa' doi' iya'a ka' norobu taena, ‘Upa ini'i men yaku' rongor koo wawau? Koini'i bantilkon na ingku' a palimangoon men mungurus kupangku. Koo sianmo sida balimang bo panganaa' doi'ku.’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pagawe panganaa' doi' iya'a nobapikirmo na noana taena, ‘Yaku' tio mangawawau upa koini'i? Tanaasku sianmo nomoturang i yaku' balimang. Bapasol, yaku' sian bukuan. Mo'ase'-ase', yaku' makamaa'. ");
INSERT INTO blzNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yaku' isian akal. Kalu yaku' sianmo balimang bookoi panganaa' doi', yaku' tio isian bela' men biai' kada' daa bo pangalaboti i yaku' na laiganna i raaya'a.’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kasi pagawe panganaa' doi' iya'a nengeleelo' sanda' mian men samayaon na tanaasna. Taena na mian men tumbena, ‘Pipii a samayaam na tanaasku?’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ia simbati mian iya'a taena, ‘Sa'atu gumbang likison saitun.’ Taena pagawe iya'a na ko'ona, ‘Kani'i a surat samayaam. Oruangmo dongan ka' tulis: limampulo' gumbang.’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Noko daa koiya'a ia norobumo na mian korua'na taena, ‘Pipii a samayaam?’ Ia simbati mian iya'a taena, ‘Sololoon karung gandum.’ Pagawe panganaa' doi' iya'a norobumo na ko'ona taena, ‘Kani'i a surat samayaam. Tulismo: walu' atu karung.’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mbaka' tanaasna nuntunde'mo pagawe panganaa' doi' men kelo-kelos iya'a gause pagawena iya'a pande tuu' ningilimang men koiya'a. Gause mian na dunia kani'i a pandena mingilimang palimangonna i raaya'a tia simbaya'na men tumuo' na karuaran. ");
INSERT INTO blzNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Bantilkonon-Ku na ko'omuu se' pakemo a kupangna dunia kani'i bo pamakadodor poowawamuu tia lulusanmuu, kada' kalu kupang na dunia kani'i sianmo angga'na, kuu bo labotion na sa'angu' dodongoan men isian pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Mian men sida ooskonon na upa-upa men morio', ia uga' sida ooskonon na upa-upa men moola'. Kasee mian men sian sida ooskonon na upa-upa men morio', ia uga' sian sida ooskonon na upa-upa men moola'. ");
INSERT INTO blzNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mbaka', kalu i kuu sianmo sida ooskonon bo pinginti'i kupang na tano' balaki' kani'i, ime a men daa mongooskon i kuu bo pinginti'i kupang men tuutuu' isian angga'na? ");
INSERT INTO blzNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka' kalu kuu sian sida ooskonon na upa men ia tombonoi mian sambana, ime a men daa mantarai i kuu upa men bo tombonoionmuu? ");
INSERT INTO blzNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Sa'angu' ata' sian momoko balimang na rua' tanaas. Gause kalu koiya'a, ia bo mongkomakitkon men sa'angu' ka' mongkolingu'kon men sambana. Kabai se' i ia bo momorongori tanaas men sa'angu' ka' sian momorongori men sambana. Koiya'a uga' i kuu. Kuu sian sida balimang bona Alaata'ala ka' uga' bona kupang!” ");
INSERT INTO blzNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mian Farisi nongorongor giigii' men ia porobukon i Yesus. Raaya'a nangaanimo i Yesus, gause i raaya'a tongko' loingonkon doi'. ");
INSERT INTO blzNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kasee i Yesus norobu na ko'ona tae-Na, “Kuu mompopokana' wakamuu na mian biai', kasee Alaata'ala ninginti'i isiina noamuu. Gause upa men angga'ionna mian ka'idekna Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ukum men ia rookon i Musa ka' pisiso'na nabii dauga' sumalan pataka tempo ni Yohanes Pansarani. Muntumbei tempo iya'a pataka koini'i Lele Pore men muntundun Batomundo'anna Alaata'ala nilelekonmo, ka' giigii' mian mampari-pari minsoop na Batomundo'anna Alaata'ala iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kasee bagia langit ka' tano' balaki' sianmo isian tia sa'angu' titik na ukum Torat sianmo pakeon. ");
INSERT INTO blzNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sanda' moro'one men mengerensai boroki'na kasi mosuo' tia wiwine sambana, moro'one iya'a muntumpangkon. Ka' moro'one men mosuo' tia wiwine men ia rensai langkai'na, moro'one iya'a uga' muntumpangkon.” ");
INSERT INTO blzNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Isian sa'angu' mian men kupangon. Ia sinampang mojuba kamumu' ka' toik malusa'. Sanda' ilio ia tongko' barame men labian. ");
INSERT INTO blzNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Karani' soopanna laiganna mian kupangon iya'a nipokelai sa'angu' mian talalais ngaanna i Lazarus. Wakana burut tia warut men tamban kumeran. ");
INSERT INTO blzNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ia mingkira' mingisii kompongna tia puputna kakaan men mandawo' na meja'na mian kupangon iya'a. Au'po isian men taka mae' minsila'i keranna. ");
INSERT INTO blzNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mian talalais iya'a komburi'na nolapusmo kasi ia wawa malaa'ikat na oruangan men pore poobeel i Abraham. Mian kupangon iya'a nolapusmo uga' ka' nitanommo. ");
INSERT INTO blzNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na dodongoanna mian lapus, mian kupangon iya'a marepa tuu'. Ka' na tempo ia nolumelengea', ia nimiile' i Abraham na tampat men oloa ka' i Lazarus isian na soripi' ni Abraham. ");
INSERT INTO blzNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mian kupangon iya'a nengeleelo'mo i Abraham taena, ‘Bapa' Abraham, kolingu'i i yaku'! Poosuu' i Lazarus mongoromok rangkumna na weer kasi taka mengementakikon sila'ku. Yaku' marepa tuu' na lalomna apu kani'i!’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kasee ia simbati Abraham taena, ‘Anakku, inau'. Tempo i koo tumuo', koo nantausimo giigii' men porena, kasee i Lazarus nantausi men ba'idekna. Koini'i ia noporemo kani'i, ka' i koo marepa tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Saliwakon iya'a, na ola'ta isian liu' men sian pa'alaon lembetion kada' mian men ka'ita sian sida waatu'u, ka' mian men tu'una sian sida tu'umari!’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Taena mian kupangon iya'a, ‘Bapa', kalu koiya'a, yaku' mama'ase' tuu' kada' i kuu momosuu' i Lazarus mae' na laiganna tamangku. ");
INSERT INTO blzNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Gause dauga' isian lilima' a utusku ira'aa. Posuu'kon i Lazarus mompopo'inti'ikon i raaya'a dako' i raaya'a uga' minsoop na tampat men marepa kani'i.’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ia simbati i Abraham taena, ‘Raaya'a isianmo kitap ni Musa ka' kitapna nabii! Patalai porongorionnasi a upa men nitulismo na kitap iya'a!’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Taena mian kupangon iya'a, ‘Sian, Bapa' Abraham! Kasee kalu isian mian men nolapusmo see tumuo' soosoodo ka' taka na ko'ona i raaya'a, raaya'a sabole monsosoli ka' mangkadarai gau'na men ba'idek.’ ");
INSERT INTO blzNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kasee ia simbati i Abraham taena, ‘Kalu i raaya'a sian momorongori pisiso' ni Musa ka' nabii, raaya'a bude' mamarasaya mau uga' isian mian men nolapusmo kasi tumuo' soosoodo ka' taka na ko'ona i raaya'a.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus norobumo na murit-Na taena, “Sabole isian upa-upa men manggau'kon mian mangawawau dosa. Kasee silaka' a mian men manggau'kon mian sambana sida baradosa! ");
INSERT INTO blzNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Porena bona mian iya'a kalu toure'na kootiion watu pinggiling kasi ia tuongon waaro'o na tobui dako' ia manggau'kon mian men baasi parasaya kani'i mangawawau dosa. ");
INSERT INTO blzNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mbali' iya'a, maka'amat! Kalu utusmuu sa'angu' kaparasaya'an baradosa, bantili i ia. Kalu ia minsosol, ampuni i ia. ");
INSERT INTO blzNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mau mune' ia baradosa na ko'omuu piripitu' a sangilio, ka' piripitu' ia mule'kon na ko'omuu ka' mangaan taena, ‘Yaku' mintisala',’ ampuni i ia.” ");
INSERT INTO blzNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kasi poposuu' iya'a norobu ni Tumpu Yesus taena, “Tumpu, popomoonggor a imaanmai.” ");
INSERT INTO blzNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ia simbati Tumpu tae-Na, “Kalu i kuu imaanan mau tongko' koi kobalaki'na watuna sasawi, kuu sida morobu na kau ara kani'i taemuu, ‘Bi kobubut i koo ka' tontanom na tobui,’ ka' sabole kau iya'a bo mongololo' posuu'muu.” ");
INSERT INTO blzNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Too isian i kuu men montombonoi sa'angu' ata' men bapajeko na ale' kabai montotobo' domba. Kalu ata' iya'a mule'konmo, isian mbali' i kuu morobu na ko'ona, ‘Mai, kumaan kutung’? ");
INSERT INTO blzNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sabole sian! Kasee i kuu bo morobu na ata' iya'a taemuu, ‘Toropoti a kakaanku. Pamake pakean men moloe', ka' peperai pataka yaku' moko daa kumaan ka' ba'inum. Moko daasi iya'a kasi i koo sida kumaan.’ ");
INSERT INTO blzNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ata' iya'a mosoo tunde'on gause ningilimangmo posuu'na tanaasna, taasi' koiya'a? ");
INSERT INTO blzNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Koiya'a uga' i kuu. Kalu i kuu daamo nangawawau giigii' men niposuu'kon, bantilkon a koi kani'imari inta': ‘Kai tongko' ata' men sian kana'na. Kai tongko' nangawawau upa men tio wawauonmai.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na rae'an mae' na Yerusalem, Yesus nosumalan na kosupuanna Samaria tia Galilea. ");
INSERT INTO blzNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tempo i Ia baasi minsoop na sa'angu' kampung, ia pootuungimo sompulo' mian men kustaon. Raaya'a potokerer na ko'oloaan, ");
INSERT INTO blzNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ka' mangkakaro' taena, “Yesus! Guru! Kolingu'konon i kai!” ");
INSERT INTO blzNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tempo i Yesus nimiile' i raaya'a, Ia norobumo tae-Na, “Rae' na imam. Pa'ase' kada' i raaya'a mamaresa wakamuu.” Potorae' i raaya'a, kustana na'anumo. ");
INSERT INTO blzNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sarataa sa'angu' mian men isian na sompulo' mian iya'a ninginti'i se' kustana na'anumo, ia nomule'konmo ni Yesus ka' nuntunde' Alaata'ala tia wurung men kamporongoran. ");
INSERT INTO blzNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kasi ia nobanintuur na sarat ni Yesus ka' nobasukuur na Ko'ona. Mian iya'a samba Samaria. ");
INSERT INTO blzNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kasi i Yesus norobu tae-Na, “Taasi' isian sompulo' mian a men nilesi'i? Aanamo a men sio' mian iya'a? ");
INSERT INTO blzNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nongko'upa se' tongko' mian men sa'angu'an lipu' kani'i a nomule'kon ka' nuntunde' Alaata'ala?” ");
INSERT INTO blzNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kasi i Yesus norobu na mian iya'a tae-Na, “Kekerermo ka' rae'. Gause i koo mamarasaya i Yaku', mbaka' i koo nisalamatkonmo.” ");
INSERT INTO blzNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Toropii mian Farisi nimikirawar ni Yesus se' ipimo a kotakaanna Batomundo'anna Alaata'ala. Ia simbati i Yesus tae-Na, “Kotakaanna Batomundo'anna Alaata'ala sianta isian oosan men sida piile'onna mian, ");
INSERT INTO blzNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","pataka mian morobu taena, ‘Piile'! Ni'imo a Batomundo'anna Alaata'ala!’ kabai taena, ‘Piile'! Kara'amo a Batomundo'anna Alaata'ala!’ Gause Batomundo'anna Alaata'ala isian na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Noko daa koiya'a i Yesus norobumo na murit-Na tae-Na, “Bo taka tempona i kuu mingkira' mimiile' sangilio na tempona Anak Manusia, kasee i kuu sianmo mimiile'. ");
INSERT INTO blzNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mian bo morobu na ko'omuu taena, ‘Piile' itu'u! Isian i ia.’ Kabai taena, ‘Piile' ini'i! Isian i ia.’ Kasee i kuu alia umuar mansarak ka' lumolo' i ia. ");
INSERT INTO blzNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gause koikoimo tia bongki-bongkit tumilep ringkat na puusna langit pataka puusna langit, koiya'a uga' ni'imarian na iliona kotakaanna Anak Manusia. ");
INSERT INTO blzNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kasee i Ia tio mungurumpaki kutung biai' repaan ka' sian labotionna mian men tumuo' na tempo koini'i. ");
INSERT INTO blzNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Koi men nosida na tempo ni Nuh, koiya'a uga' a men bo sida ni'imarian na iliona kotakaanna Anak Manusia. ");
INSERT INTO blzNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mian kumaan ka' ba'inum, mosuo' ka' mompoposuo' anakna. Koiya'a pataka na ilio ninsoopan ni Nuh na lalomna kapal ka' tano' balaki' ia limbusi weer ka' ninsilaka'i i raaya'a giigii'. ");
INSERT INTO blzNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Koiya'a uga' na tempo ni Loot. Mian kumaan ka' ba'inum, mobaluk ka' mingili, mo'ale' ka' mangawawau laigan. ");
INSERT INTO blzNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kasee tempo i Loot no'umuar na Sodom, na ilio iya'a no'usanmo apu tia balerang nda'amari langit ninsilaka'i raaya'a giigii'. ");
INSERT INTO blzNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Koiya'a uga' ni'imarian na iliona Anak Manusia pipiile'konon. ");
INSERT INTO blzNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Na ilio iya'a mian men monda'a na wawona laiganna, alia mangala upana men isian na lalomna laiganna. Koiya'a uga' a mian men isian na ale', alia mule'kon na laiganna. ");
INSERT INTO blzNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Inau' a upa men nosida na boroki' ni Loot! ");
INSERT INTO blzNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mian men mampari-pari mansalamatkon wakana na dunia kani'i sian mantausi tutuo' men pore. Kasee mian men mongorookon wakana na Ingku', ia bo mantausi tutuo' men pore. ");
INSERT INTO blzNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Bantilkonon-Ku na ko'omuu se' na malom iya'a rua' mian pototokol na sa'angu' tokolan, sa'angu' bo wawaon ka' men sa'angu' bo parereion. ");
INSERT INTO blzNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Rua' wiwine pintanga' minggiling gandum. Sa'angu' bo wawaon, ka' men sa'angu' bo parereion.  ");
INSERT INTO blzNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Rua' mian pintanga' balimang na ale'. Sa'angu' bo wawaon, ka' men sa'angu' bo parereion.” ");
INSERT INTO blzNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Murit ni Yesus nimikirawar taena, “Tumpu! Maana a men bo sidaanna men koiya'a?” Ia simbati i Yesus tae-Na, “Aana a men isian bangke, ino'o moriwut a sapu' men mangkaan bangke.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Noko daa koiya'a i Yesus nuntundunkonmo sa'angu' timbaani' bo mimisiso' murit-Na kada' i raaya'a sinampang sambayang, ka' alia kobangaran. ");
INSERT INTO blzNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Taeni Yesus, “Na sa'angu' kota isian pungukumi men sian layaonkon Alaata'ala, ka' uga' mau imepo sian angga'ionku. ");
INSERT INTO blzNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na kota iya'a uga' isian sa'angu' balu men sinampang taka na pungukumi iya'a mama'ase' moki salangi parakalana. Taena balu iya'a, ‘Tulung i yaku' na mian men mintimbangi yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Toropii tempo a nau'na pungukumi iya'a sian nuntulung balu iya'a. Kasee komburi'na pikiranna pungukumi iya'a koi kani'imari, taena, ‘Mau mune' yaku' sian layaonkon Alaata'ala ka' uga' mau imepo sian angga'ionku, ");
INSERT INTO blzNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kasee ka' balu iya'a sinampang mungkulen i yaku', bagia salangionkumo a parakalana dako' i ia sataka-taka mengerepai i yaku'.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kasi taena Tumpu, “Intoomkon a upa men taena pungukumi men kelo-kelos iya'a! ");
INSERT INTO blzNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Alaata'ala sian mbali' mangapaki parakalana mian-Na men Ia rurukimo men ilio malom miki tulung na Ko'ona? Isian mbali' i Ia monsompo' muntulung i raaya'a? ");
INSERT INTO blzNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bantilkonon-Ku na ko'omuu se' i Ia liuliu mangapaki i raaya'a! Kasee kalu Anak Manusia taka na tano' balaki', too daa dauga' rumpakion-Na a mian men parasaya?” ");
INSERT INTO blzNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus uga' nuntundunkon timbaani' kani'i men Ia patukkon na mian men sian mangangga'i mian sambana, kasee munsurikon se' wakana daa pore. ");
INSERT INTO blzNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Taeni Yesus, “Isian rua' mian mae' sambayang na Laiganna Alaata'ala. Men sa'angu' mian Farisi, men sa'angu' pagawena pajak. ");
INSERT INTO blzNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mian Farisi iya'a nokumekerer ka' nosambayang na noana taena, ‘Oo Alaata'ala! Yaku' basukuur na Ko'omuu gause yaku' sian koi mian sambana men puraga, men ba'idek a gau'na, men muntumpangkon samba-sambana, kabai se' koi pagawena pajak kaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yaku' ba'apata pinduan sa'angu' minggu, ka' i yaku' mongorookon na Ko'omuu sangobosan na lalomna sompulo' obosan basarakanku.’ ");
INSERT INTO blzNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kasee pagawena pajak iya'a nokumekerer olo-oloa ka' ia sian momoko lumelengea'. Ia numurusi sara'anna ka' norobu taena, ‘Oo Alaata'ala, kolingu'kon i yaku', mian men dosaon kani'i!’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Taeni Yesus, “Bantilkonon-Ku na ko'omuu se' na tempo mule'kon na laiganna, pagawena pajak a men popokana'onna Alaata'ala taasi'po mian Farisi iya'a. Gause sanda' mian men mompopodaa wakana bo popokoo'on, ka' mian men mompopokoo' wakana bo popodaaon.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Isian mian men nangawawa anak morio' ni Yesus kada' i Ia mengepetkon lima-Na na ko'ona i raaya'a. Tempo murit ni Yesus nimiile' men koiya'a, raaya'a nongkomaso'imo mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kasee i Yesus nengeleelo' mian iya'a kasi norobu na murit-Na tae-Na, “Patalai anak karaanono' taka na Ingku'! Alia mantaankon i raaya'a, gause mian men koi anak karaani'i a men bo mianna Batomundo'anna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' mian men sian mangalabot Batomundo'anna Alaata'ala koi pangalabotna anak morio', ia sian minsoop na Batomundo'an iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sa'angu' tanaasna lipu' Yahudi nimikirawar ni Yesus taena, “Guru men pore! Tio mangawawau upa kada' i yaku' mantausi tutuo' men pore pataka sidutu?” ");
INSERT INTO blzNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ia simbati i Yesus tae-Na, “Nongko'upa i koo se' mangaan i Yaku' pore? Sianta men pore saliwakon Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ai koo ninginti'imo potoona Alaata'ala: ‘Alia muntumpangkon samba-samba, alia mampapatei mian, alia mamangan, alia momborekkon mian, ka' angga'i a tamaam tia sinaam.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Taena mian iya'a, “Giigii' potoo men koiya'a yaku' poko loloikonmo tempopo i yaku' nopoo'inti'imo.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nongorongor koiya'a, Yesus norobumo tae-Na, “Dauga' isian sa'angu' kaliangan a men tio wawauwoon. Balukkonmo a giigii' upaam ka' obo-oboskon a doi'na na mian talalais. Kalu koiya'a, koo bo mokosue kupang na surugaa. Moko daa kasi taka mongololo' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kasee sarataa nongorongor men koiya'a, mian iya'a nasiongo'mo tuu' gause i ia kupangon tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus ninginti'i se' mian iya'a masiongo' tuu' a noana. Mbali' iya'a, Ia norobumo tae-Na, “Marepa tuu' a mian kupangon minsida mianna Batomundo'anna Alaata'ala! ");
INSERT INTO blzNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bagiakon sa'angu' unta minsoop na bolo'na pakaut a daana, tia sa'angu' mian kupangon minsida mianna Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Biai' a mian men nongorongor i Yesus nangaan koiya'a nimikirawar taena, “Ka' koiya'a, ai ime ansee a men sida salamatkonon?” ");
INSERT INTO blzNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ia simbati i Yesus tae-Na, “Men sian pokoonna mian, pokoonna Alaata'ala wawauon.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kasi i Petrus norobu taena, “Piile'! Kai namarereimo giigii' upamai ka' nongololo' i Kuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Taeni Yesus, “Tuutuu' mba'a. Ka' bantilkonon-Ku na ko'omuu se' mian men mamarereim laiganna, kabai boroki'na, kabai utusna, kabai minti'ina, kabai anakna gause Batomundo'anna Alaata'ala, ");
INSERT INTO blzNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mian iya'a tempo koini'i uga' bo mangalabot walosna men labi tia upa men ia parereimo, ka' na tempo men bo rumpakion ni'imarian, ia bo mantausi tutuo' men pore pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus ningirimpungmo murit-Na men sompulo' rua' ka' nintisaal kasi norobu tae-Na, “Imamat ini'imari! Kita koini'i banta-bantang mae' na Yerusalem. Giigii' men ia tulismo nabii men muntundunkon Anak Manusia bo sida inda'a. ");
INSERT INTO blzNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ia bo kalaakonon na mian men taasi' Yahudi. Ia bo irokion, idekion ka' inorion. ");
INSERT INTO blzNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Raaya'a bo mansasali ka' mampapatei i Ia, kasee na ilio kotolu'na i Ia bo tumuo' soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Giigii' iya'a titiu'po sian inti'ionna murit ni Yesus. Aratina wurung-Na iya'a niwunikon na ko'ona i raaya'a. Raaya'a sian ninginti'i panduungna tundunan-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tempo i Yesus torumpakmo na Yerikho, isian sa'angu' mian men mampisok poto'oruang na soripi'na salan ka' mo'ase-ase' upana mian men lumiu. ");
INSERT INTO blzNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sarataa mian iya'a nongorongor se' biai' a mian men lumiu, ia nimikirawarmo taena, “Isian upa?” ");
INSERT INTO blzNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Taena i raaya'a na ko'ona, “Yesus, mian na Nazaret iya'a, lumiu.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mbaka' nangkakaro'mo a mian men mampisok iya'a taena, “Yesus, lee' ni Daud! Kolingu'konon i yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mbaka' i raaya'a men pototumpang olukon nongkokundakon i ia ka' nomosuu' kada' mimporokot. Kasee ia tongko' kaekae' momboolaki mangkakaro' taena, “Lee' ni Daud! Kolingu'konon i yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kasi i Yesus notumataan ka' nomosuu' mian kada' mangawawa mian mampisok iya'a na Ko'ona. Sarataa mian iya'a karani'mo ni Yesus, Yesus nimikirawarmo tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Upa a men kikira'am wawauon-Ku na ko'oom?” Ia simbati mian mampisok iya'a taena, “Tumpu, yaku' mingkira' bi poopiile'!” ");
INSERT INTO blzNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Taeni Yesus, “Bi poopiile'mo! Gause i koo mamarasaya na Ingku', koo nopoopiile'mo.” ");
INSERT INTO blzNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tempo iya'apo uga' ia nopoopiile'mo, kasi ia nongololo' i Yesus ka' nobasukuur na Alaata'ala. Sarataa mian biai' nimiile' men koiya'a, raaya'a giigii' nuntunde'mo Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus ninsoop lumiu na kota Yerikho. ");
INSERT INTO blzNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na kota iya'a isian sa'angu' mian kupangon men tanaasna pagawena pajak. Ngaanna i Zakheus. ");
INSERT INTO blzNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ia mingkira' mimiile' too ime i Yesus iya'a, kasee i ia pepende' ka' mian uga' biai' tuu', mbaka' ia sian namaka'ala nimiile' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Zakheus notumetende'mo nongolukoni mian biai', kasi nimenek na kau ara kada' sida mimiile' i Yesus men boomo lumiu indo'o. ");
INSERT INTO blzNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sarataa i Yesus nolumiu na kau iya'a, Ia nolumelengea'mo kasi norobu tae-Na, “Zakheus, palau dongan! Gause i Yaku' bo tuuk na laigaan ilio kani'i.” ");
INSERT INTO blzNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kasi i Zakheus nalau donga-dongan ka' nangawawa i Yesus tia noa beles. ");
INSERT INTO blzNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Giigii' mian men nimiile' se' koiya'a noramumukmo gause kokoo'an montookon i Yesus notuuk na laigan ni Zakheus. Taena i raaya'a, “Nongko'upa se' i Ia daa tuuk na laiganna mian men sian malolo' na aturanna agama?” ");
INSERT INTO blzNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kasee i Zakheus nokumekerer ka' norobu ni Yesus taena, “Tumpu, piile'! Sangobosan na lalomna ruangobosanna kupangku bo rookononku na mian talalais, ka' imepo a men yaku' too akalimo, na ko'ona bo ule'kononku parapaat paku'!” ");
INSERT INTO blzNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kasi taeni Yesus, “Na ilio kani'i koo tia giigii' poto'utusaan na laigan kani'i ia salamatkonmo Alaata'ala, gause i koo uga' lee' ni Abraham. ");
INSERT INTO blzNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gause Anak Manusia taka bo mansarak ka' mansalamatkon mian men sian mamarasaya Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pintanga' a mian dauga' momorongori i Ia, Ia nuntundunkonmo sa'angu' timbaani'. Na tempo iya'a Ia nda'amo karani' na Yerusalem, ka' mian mansarui se' Alaata'ala boomo mimpipiile'kon Batomundo'an-Na na tano' balaki'. ");
INSERT INTO blzNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Taeni Yesus, “Isian sa'angu' mian lee'na tomundo' men bo mae' na dodongoan men oloa bo nakaton sida tomundo' na lipu'na, ka' moko daa iya'a, kasi ia mule'kon. ");
INSERT INTO blzNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Koo'po tia ia rumingkat, ia nengeleelo'mo sompulo' mian tutulungina, kasi nantarai i raaya'a sanda-sanda' toro sa'angu'an doi' mosoni, kasi taena, ‘Doi' kani'i ala bo pobalu-balukmuu pataka yaku' mule'kon soosoodo.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kasee mian men sa'angu' lipu' tii ia ka'idekan i ia. Sarataa i ia nomae', raaya'a nomosuu'mo mian men bo pambantilkon taena, ‘Kai kunda tomundo'ionna mian kani'i.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kasee lee'na tomundo' iya'a ninakatmo ka' nosidamo tomundo', kasi nomule'kon na dodongoanna. Ia liuliu nengeleelo' tutulungina kada' inti'ionna se' pipii a ule' men ia tausimo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tutulungi men tumbena notakamo ka' norobu taena, ‘Tuan, sa'angu' doi' mosoni men kuu rookon na ingku', yaku' sidakonmo sompulo' doi' mosoni.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Taena tomundo' iya'a, ‘Pore tuu' a men koo wawau. Koo tutulungi men pore! Gause i koo daa sida ooskonon mau tongko' na upa titiu', mbaka' i koo poposidaonkumo bo pinginti'i na sompulo' kota.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tutulungi men korua'na notakamo ka' norobu taena, ‘Tuan, sa'angu' doi' mosoni men kuu rookon na ingku', yaku' sidakonmo lilima' doi' mosoni.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tomundo' norobumo na tutulungi iya'a taena, ‘Koo poposidaonku bo pungkuasai lima' kota.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tutulungi men sambana notakamo ka' norobu taena, ‘Tuan, ni'imo a doi'muu. Yaku' tuummo tia lenso ka' ninaa'. ");
INSERT INTO blzNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yaku' layaonkon i kuu, gause i kuu mian men maso'on. Kuu mangala men taasi' kuu limang, ka' mangala ule' na ale' men sian kuu asoki.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tomundo' iya'a norobumo na ko'ona taena, ‘Koo tutulungi men ba'idek! Ka' sintutu' tia wuruung mbaka' koo bo ukumionku. Koi taeem se' yaku' mian men maso'on. Taeem se' yaku' mangala upa men taasi'po yaku' a ningilimang ka' mangala ule' na ale' men taasi'po yaku' a nangasoki. ");
INSERT INTO blzNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kalu koiya'a nongko'upa mbali' i koo sian nanganaa' doi' iya'a na baang kada' kalu yaku' mule'konmo, yaku' mangalabot doi' iya'a tia bungana?’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kasi tomundo' iya'a norobu na mian men potokerer iraando'o taena, ‘Alamo a doi' kanooro'o na ko'ona ka' rookon na tutulungi men no'isianmo sompulo' doi' mosoni iya'a.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kasee taena i raaya'a, ‘Tuan, ia noko isianmo sompulo' doi' mosoni.’ ");
INSERT INTO blzNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ia simbati tomundo' iya'a taena, ‘Bantilkononku na ko'omuu se' sanda' mian men isianmo upa ia tombonoi bo taraion soosoodo, kasee mian men sianta upa tombonoionna, toro tiu'po men dauga' isian na ko'ona bo alaon. ");
INSERT INTO blzNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ka' koini'i wawamo le'emari a giigii' mian men maso'kon i yaku' men bude'kon i yaku' a men bo pontomundo'i i raaya'a. Papatei i raaya'a giigii' piipiile' i yaku'!’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Noko daa nangaan giigii' men koiya'a, raaya'a nomae'mo. Yesus a na olukon, kasi ia tuntuni i raaya'a mae' paraas Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sarataa montorumpakimo Betfage ka' Betania na buu'na men ngaanon Buu'na Zaitun, Ia nomosuu'mo murit-Na rurua' mae' olukon, ");
INSERT INTO blzNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ka' nomotoo tae-Na, “Rae' na kampung katu'u men torumpakionta. Kalu i kuu minsoopmo intu'u, kuu bo mungurumpaki sa'angu' keledai rundara men nitoongkon. Keledai iya'a sianpo ia toolakiti mian. Alaka' kakai a kokootna ka' wawa tu'umari. ");
INSERT INTO blzNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ka' too isian mian mimikirawar na ko'omuu taena, ‘Nongko'upa i kuu se' mangalakai keledai iya'a?’ bantilkon inta', ‘Tumpu mamaraluui.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Rua' murit ni Yesus iya'a nomae'mo ka' i raaya'a nantakai giigii' sintutu' koi men taeni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pintanga' mangalakai kokootna keledai rundara iya'a, norobumo a tombonona keledai iya'a taena, “Nongko'upa mbali' i kuu se' mangalakai kokootna keledai kanono'?” ");
INSERT INTO blzNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ia simbati i raaya'a taena, “Tumpu mamaraluui.” ");
INSERT INTO blzNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kasi i raaya'a nangawawa keledai rundara iya'a mbaatu'u ni Yesus. Komburi'na i raaya'a nangalatasikonmo pakeanna i raaya'a na sengke'na keledai iya'a ka' nomolakit i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pintanga' i Yesus lumiu laki-lakit na keledai iya'a, mian biai' nanggampalkonmo bokukumna i raaya'a na salan. ");
INSERT INTO blzNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sarataa i Yesus karani'mo Yerusalem, na salan men toku-tokuru na Buu'na Zaitun, giigii' murit-Na men biai' iya'a nuntumbeimo nokamporongoran muntunde' ka' basukuur na Alaata'ala gause giigii' upa kosamba' men ia piile'mo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Raaya'a mangkakaro' taena, “Barakaatan a Tomundo' men notaka ia pokau Tumpu! Bi pore na surugaa! Tunde' a Alaata'ala men na ko'alayo'an!” ");
INSERT INTO blzNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Toropii mian Farisi men isian na mian biai' iya'a norobu ni Yesus taena, “Guru, kokundakon a murit-Muu kada' mimporokot.” ");
INSERT INTO blzNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ia simbati i Yesus tae-Na, “Bantilkonon-Ku na ko'omuu se' kalu i raaya'a mimporokot, watu karaaya'a bo mangkakaro'.” ");
INSERT INTO blzNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tempo i Yesus karani'mo na Yerusalem, ka' sarataa nimiile' kota iya'a, Ia nowirimo. ");
INSERT INTO blzNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tae-Na, “Kolingu' i kuu mian na Yerusalem! Kaporeanna kalu ilio kani'i kuu minginti'i upa men daa mantakakon pooka'amatan! Kasee koini'i kuu sian mimiile' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sa'angu' tempo kuu bo mungurumpaki repaan. Mian men maso'kon i kuu bo mangawawau ompot na tiku-tikumuuu. Raaya'a bo mangalawui i kuu ka' mongompot i kuu tiku-tikum. ");
INSERT INTO blzNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Raaya'a bo minsilaka'i i kuu ka' uga' giigii' mianmuu, ka' sianta sa'angu'po watu a men bo dalaionna i raaya'a dauga' pootapi' na kekelaanna, gause i kuu sian ningimamat tempona Alaata'ala taka mansalamatkon i kuu!” ");
INSERT INTO blzNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus ninsoop na Laiganna Alaata'ala ka' numbuse'i giigii' mian men mobalu-baluk indo'o. ");
INSERT INTO blzNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Taeni Yesus na ko'ona i raaya'a, “Na Alkitaap isian nitulis koi kani'imari: Alaata'ala nangaan tae-Na, ‘Laigan-Ku bo sida laigan basambayangan.’ Kasee kuu wawaumo bo dodongoanna mian puraga!” ");
INSERT INTO blzNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sanda' ilio i Yesus nimisiso' na Laiganna Alaata'ala. Tanaasna imam ka' wawa ukum Torat tia tanaasna lipu' Yahudi mingkira'amo mampapatei Ia, ");
INSERT INTO blzNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kasee i raaya'a sian nantausi salan bo mangawawau men koiya'a, gause giigii' mian mingkira'kon i Ia ka' mo'uus momorongori wurung-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na sa'angu' tempo pintanga' i Yesus mimisiso' ka' mengelelekon Lele Pore men ringkat na Alaata'ala bona mian biai' men na Laiganna Alaata'ala, isian tanaasna imam, wawa ukum Torat, tia motu-motu'a notaka indo'o. ");
INSERT INTO blzNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Raaya'a norobu ni Yesus taena, “Io, bantilkon na ko'omai se' upa a pimpu'uaan nangawawau men koiya'a? Ka' ime a nantarai i Koo kuasa mbali' nangawawau giigii' iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ia simbati i Yesus tae-Na, “Yaku' uga' mingkira' mimikirawar na ko'omuu. Pinginti'imuu, ");
INSERT INTO blzNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanes nansarani mian nimpu'u na kuasa ni ime, Alaata'ala kabai mian?” ");
INSERT INTO blzNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Raaya'a nopootunduniimo kasi taena i raaya'a, “Kalu kita mangaan, ‘Kuasana ringkat na Alaata'ala,’ mbaka' simbation-Na, ‘Nongko'upa i kuu se' kosian mamarasaya upa men taeni Yohanes?’ ");
INSERT INTO blzNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kasee kalu kita mangaan, ‘Nimpu'u na kuasana mian,’ giigii' mian karaale'e bo mangalapak i kita tia watu, gause i raaya'a mamarasaya se' i Yohanes mase nabii.” ");
INSERT INTO blzNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mbaka' ia simbati i raaya'a taena, “Sian inti'ionmai.” ");
INSERT INTO blzNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mbaka' norobumo i Yesus na ko'ona i raaya'a tae-Na, “Kalu koiya'a Yaku' uga' sian mambantilkon na ko'omuu se' kuasa ni ime bo pimpu'uan-Ku mangawawau koiya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kasi i Yesus nuntundunkon na ko'ona i raaya'a timbaani' men koi kani'imari: “Isian sa'angu' mian no'ale' ka' ale'na ia asoki anggur. Ale' iya'a ia tamboikonmo na toropii mian papalimang, kasi ia nomae' na lipu' sambana ka' nodumodongo pataka nanau'. ");
INSERT INTO blzNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Temponamo pumpupuan woo'na anggur iya'a, tombono ale' iya'a nomosuu'mo tutulungina mae' na papalimangna ale'na iya'a mama'ase' obosna ule'na. Kasee papalimang iya'a tongko' numukul tutulungi iya'a ka' nomosuu' nomae' tia lima sompulo'. ");
INSERT INTO blzNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mbaka' tombono ale' iya'a nomosuu'mo sa'angu' tutulungina men sambana. Kasee iapo uga' tongko' nipukul ka' ia iroki papalimang iya'a, kasi niposuu' mule'kon tia lima sompulo'. ");
INSERT INTO blzNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tombono ale' iya'a nomosuu'mo soosoodo tutulungi men kotolu'na. Kasee iapo uga' tongko' ia pukul i raaya'a ka' nitibarkon waale'e na liwana ale' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Komburi'na tombono ale' iya'a norobumo taena, ‘Upa a men tio bo wawauonku soosoodo? Yaku' bo momosuu' anakku men kolingu'ku. Sabole ia kolayaonna i raaya'a!’ ");
INSERT INTO blzNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kasee tempo papalimangna ale' iya'a nimiile' anakna iya'a, raaya'a nopootunduniimo taena, ‘Iamo kaya'a a men bo pontombonoi giigii' upana tamana. Mai kita papateia i ia kada' kitamo a pontombonoi budelna.’ ");
INSERT INTO blzNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mbaka' ia tibarkonmo i raaya'a a anak iya'a waale'e na liwana ale' kasi nipapatei.” Yesus nimikirawarmo na ko'ona i raaya'a tae-Na, “Koi upa a tombono ale' iya'a? Upamo a wawauonna na papalimangna ale'na iya'a? ");
INSERT INTO blzNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sabole ia bo taka ka' mampapatei papalimang iya'a, kasi mongorookon ale' iya'a na papalimang men sambana.” Nongorongor men koiya'a, mian biai' norobumo na Ko'ona taena, “Ansee, amo' sida a men koiya'a!” ");
INSERT INTO blzNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus nintiokimo i raaya'a kasi nangaan tae-Na, “Kalu koiya'a, upa aratina isiina Alkitaap men koi kani'imari: ‘Watu men ia balo'konmo tukang nosidamo watu tuko men bo pandasi’? ");
INSERT INTO blzNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ime a men mandawo' na watu iya'a bo koraso-raso', ka' ime a men utunonna watu iya'a bo magampial.” ");
INSERT INTO blzNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kasi wawa ukum Torat ka' tanaasna imam nampari-pari mangarakop i Yesus na tempopo iya'a, gause ia inti'i se' tundunan ni Yesus umba'a mintimbaani'kon i raaya'a koi papalimang ale'na anggur men ba'idek. Kasee i raaya'a layaonkon mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Wawa ukum Torat ka' tanaasna imam iya'a nanganasaimo i Yesus. Raaya'a nomosuu'mo mian men mimpipiile'kon tatakana koi se' mian maloos, mimikirawari i Yesus kada' Ia sala' wurung, kasi i raaya'a nangarakop ka' namarawootkon i Yesus na gubernuur. ");
INSERT INTO blzNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mbaka' i raaya'a men niposuu' norobumo ni Yesus taena, “Guru, kai inti'i se' giigii' men Kuu ngaan ka' Kuu pisiso'kon iya'a tuutuu', ka' i Kuu sian momposasala'kon mian, kasee i Kuu mimisiso'kon pingkira'na Alaata'ala men tuutuu'na. ");
INSERT INTO blzNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kalu na aturanna agamanta, daa patalaion a mambayar pajak bona Kaisar kabai sian?” ");
INSERT INTO blzNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kasee ia inti'i i Yesus se' i raaya'a tongko' monsosoolani wurung-Na. Mbali' iya'a, Ia norobu tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pipiile'kon na Ingku' sa'angu' doi' dinar. Gambar tia ngaan ni ime ini'i?” Ia simbati i raaya'a taena, “Gambar tia ngaanna Kaisar!” ");
INSERT INTO blzNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Taeni Yesus, “Kalu koiya'a, rookon bona Kaisar a upa men tio rookononmuu na Kaisar, ka' rookon bona Alaata'ala a upa men tio rookononmuu na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wawa ukum Torat ka' tanaasna imam iya'a sian nandapot monsosoolani i Yesus tempo i Ia norobu potorongor mian biai'. Raaya'a nimporokotmo ka' nosamba'konmo pinsimbati ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mbaka' notakamo ni Yesus a toropii mian Saduki men koi na pinginti'ina se' mian lapus sianmo tumuo' soosoodo. Raaya'a nimikirawar ni Yesus taena i raaya'a, ");
INSERT INTO blzNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Guru! Musa nuntulis ukum men koi kani'imari bo ko'onta': Kalu sa'angu' mian moro'one lapus namarerei boroki' men sian anakon, mbaka' utusna moro'one iya'a tio mosuo' tia baluna utusna kada' utusna isian lee'na. ");
INSERT INTO blzNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Isian pitu' moro'one moto'utus. Men balaki'na nosuo' tia sa'angu' wiwine, kasee pataka nolapus ia sian no'anakon. ");
INSERT INTO blzNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kasi utusna men korua'na nosuo' tia baluna, kasee i iapo uga' nolapus ka' sian no'anakon. ");
INSERT INTO blzNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Koiya'a uga' a utusna men kotolu'na pataka men kopitu'na. Pitu-pitu'na nomosuo'i kasee sian no'anakon. ");
INSERT INTO blzNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Komburi'na wiwine iya'a uga' nolapusmo'. ");
INSERT INTO blzNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na ilio pomotuo'ian mian lapus, wiwine iya'a se' boroki' ni ime? Gause pitu-pitu' irana nompoboroki'mo i ia.” ");
INSERT INTO blzNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ia simbati i Yesus tae-Na, “Mian men tumuo' tempo koini'i dauga' mosuo' ka' poposuo'on, ");
INSERT INTO blzNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kasee mian men daa sida bo potuo'ion moko daa lapus ka' tumuo' na tempo men bo rumpakion, raaya'a sian mosuo' ka' sian poposuo'on. ");
INSERT INTO blzNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Raaya'a sianmo lapus gause koikoimo malaa'ikat. Raaya'a mase anakna Alaata'ala, gause nipotuo'imo. ");
INSERT INTO blzNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa isian nangaan se' mian lapus bo potuo'ion. Na tulisanna men muntundunkon kau morio' ruri'on men kumait iya'a, Musa nangaan se' Tumpu iya'a Alaata'ala ni Abraham, Alaata'ala ni Ishak ka' Alaata'ala ni Yakub. ");
INSERT INTO blzNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ia taasi' Alaata'alana mian lapus, kasee i Ia Alaata'alana mian tumuo'! Gause na pimiile'na Alaata'ala, giigii' mian sianta men lapus.” ");
INSERT INTO blzNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Toropii wawa ukum Torat norobu taena, “Guru, pore tuu' a ninsimbati-Muu.” ");
INSERT INTO blzNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mbali' iya'a, raaya'a sianmo momoko nimikirawar upa-upa ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesus nimikirawarmo na ko'ona i raaya'a tae-Na, “Na pinginti'imuu, nongko'upa mbali' a mian se' mangaan Tomundo' Pansalamatkon iya'a lee' ni Daud? ");
INSERT INTO blzNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Poali i Daud uga' nangaan na kitap Mazmur taena, ‘Tumpu Alaata'ala nangaan na Tumpungku tae-Na: Alaka' oruang na paraas uanan-Ku, ");
INSERT INTO blzNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pataka Yaku' mompoporungku' giigii' mian men mangka'idek i Koo sida malolo' na Ko'oom.’ ");
INSERT INTO blzNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daud nangaan se' Tomundo' Pansalamatkon iya'a Tumpuna. Pinginti'imuu, koi upa a kosidana se' daa Tomundo' Pansalamatkon uga' bo lee'na?” ");
INSERT INTO blzNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tempo giigii' mian dauga' pintanga' momorongori i Yesus, Ia norobumo na murit-Na tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kuu tio maka'amat na wawa ukum Torat. Raaya'a na sasayoan mingkira' mojuba men alayo' ka' beleskon angga'ionna mian na pasar. Raaya'a mingkira' umoruang na oruangan men porena na laigan bakitumpuan kabai na pootatakaianna mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Raaya'a mangakalkon balu wiwine ka' mangarampasi laiganna. Raaya'a mingirimboroi gau' ba'idekna tia sambayang biai' taa'! Ukumannasi a marepana tia ukumanna mian sambana!” ");
INSERT INTO blzNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na Laiganna Alaata'ala, Yesus nimiile' toropii mian men kupangon monsoopkon doi'na i raaya'a na peti pingilinsonan doi' persembaahan. ");
INSERT INTO blzNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ia uga' nimiile' sa'angu' wiwine balu men talalais ningisiikon na peti iya'a rua' doi' kulaluk men titiu' tuu' a angga'na. ");
INSERT INTO blzNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kasi taeni Yesus, “Imamat ini'imari! Bantilkonon-Ku na ko'omuu se' balu men talalais kale'e a biai'na ia linson na peti tia na mian sambana. ");
INSERT INTO blzNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gause i raaya'a giigii' nantarai persembaahan tia labina kupangna. Kasee balu kale'e mau mune' talalais, ia nongorookonmo doi'na wiwi'na tonsoop men paraluukononna bona tutuo'na.” ");
INSERT INTO blzNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Isian toropii mian nuntundun Laiganna Alaata'ala men niporei tia watu men pore ka' uga' niporei tia biai' kaliangan upa men nirookon bona Alaata'ala. Mbaka' i Yesus norobumo na ko'ona i raaya'a tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ni'imarian bo taka a tempona giigii' men kuu piile' kani'i bo runtunion, ka' sianta sa'angu'po watu na Laiganna Alaata'ala kani'i a men dauga' patalaion pootapi'!” ");
INSERT INTO blzNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Raaya'a nimikirawar ni Yesus taena, “Guru, ipi a tempona kosidaanna men koiya'a? Ka' upa men bo oosan se' daa takamo tempona?” ");
INSERT INTO blzNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Taeni Yesus, “Maka'amat! Alia i kuu ko'akalian. Biai' a mian bo taka ka' mangaan ngaan-Ku, ka' morobu taena, ‘Yaku'mo a Tomundo' Pansalamatkon!’ ka' taena, ‘Boomo kakabusanna tempo.’ Kasee i kuu alia mongololo' i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kalu i kuu mongorongor lelena mian poopapate kabai mian sianmo malolo' na pamarenta, alia i kuu uga' layaon. Giigii' iya'a tio sida olukon. Kasee men koiya'a taasi' se' daa takamo a kakabusanna tempo.” ");
INSERT INTO blzNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kasi taeni Yesus soosoodo, “Lipu' men sa'angu' bo poopapate mintimbangi lipu' men sambana, ka' batomundo'an sa'angu' bo poopapate mintimbangi batomundo'an men sambana. ");
INSERT INTO blzNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na sanda' dodongoan bo isian lili' men dodoa, pololuan, ka' nggeo men lumalin. Ka' uga' bo isian upa-upa men kolayaon ka' upa kosamba' nda'ara'amari langit. ");
INSERT INTO blzNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kasee mongolukoni giigii' iya'a, kuu bo rakopon ka' talalaison. Kuu bo ukumion na laigan bakitumpuan ka' soopkonon na tarungkuan. Ka' i kuu bo wawaon na tomundo' ka' pamarenta gause i kuu murit-Ku. ");
INSERT INTO blzNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ya'amo a tempo men pore na ko'omuu bo mengelelekon Lele Pore men ringkat na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pari-pari na noamuu se' i kuu sian babatakon upa men bo porobukononmuu mansalangi wakamuu. ");
INSERT INTO blzNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yaku' a bo pantarai i kuu wurung men kana' kada' mian men maso'kon i kuu sian momoko mintimbangi kabai se' manggagai i kuu. ");
INSERT INTO blzNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kuu bo silaka'ionna minti'imuu, utusmuu, poto'utusanmuu, ka' bela'muu. Toropii mianmuu bo papateionna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kuu bo kokundaionna giigii' mian gause na pongololo'an i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kasee sansila'po wuuk na takala'muu sianta penta'. ");
INSERT INTO blzNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kalu i kuu mokotaan, kuu bo mantausi tutuo' men pore.” ");
INSERT INTO blzNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kalu i kuu mimiile' se' Yerusalem ia tikumimo surudadu, inti'ionmuumo se' kota iya'a sianmo manau' bo silaka'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na tempo iya'a, mian men isian na libutan Yudea tio mamarere na buu'na. Raaya'a men isian na kota tio mamarerei kota, ka' i raaya'a men na liwana kota aliamomo' minsoop na kota, ");
INSERT INTO blzNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","gause tempo iya'a a tempo pungukuman kada' sida a giigii' men nitulismo na Alkitaap. ");
INSERT INTO blzNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Marepa a wiwine men mampaiwawa tempo iya'a, ka' sina men dauga' momosusui anak! Dodongoan kani'i bo munsuri repaan men dodoa tuu', ka' maso'na Tumpu bona lipu' kani'i. ");
INSERT INTO blzNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Isian men bo papateion tia bakoko', isian uga' mian men nirakop ka' niwawa na giigii' lipu', ka' mian men taasi' Yahudi bo mempee-pee'i Yerusalem pataka kabus a tempona men ia patukomo Tumpu bo ko'ona i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Bo isian oosan na matana ilio, wulan ka' bitu'on. Giigii' lipu' na tano' balaki' bo babata ka' layaon mongorongor kokuungna bokol ka' mimiile' tobui men makansang. ");
INSERT INTO blzNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mian poso' layaonkon montorumpaki upa men bo sida na longkop tano' balaki' kani'i, gause pungkuasai langit bo toyunggot. ");
INSERT INTO blzNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na tempo iya'a mian bo mimiile' Anak Manusia taka ra'amari na lalomna antong tia kuasa ka' lingkaangan tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kalu upa-upa men koiya'a muntumbeimo sida, ringkat ka' lelengea', gause i kuu booboomo salamatkonon.” ");
INSERT INTO blzNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kasi i Yesus nuntundunkon na ko'ona i raaya'a timbaani' koi kani'imari, tae-Na, “Piile' pore-pore a kau ara ka' giigii' kau men sambana. ");
INSERT INTO blzNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kalu lonsongna kau iya'a kampiile'anmo, inti'ionmuu se' tempona pengkar booboomo. ");
INSERT INTO blzNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Koiya'a uga' kalu i kuu mimiile' men taeng-Ku' kaekae'mo sida. Inti'ionmuu se' Batomundo'anna Alaata'ala karani'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' giigii' upa men Yaku' poko bantilkonmo na ko'omuu iya'a bo sida koo'po tia mian men tumuo' tempo koini'i lapus giigii'na. ");
INSERT INTO blzNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langit ka' tano' balaki' bo penta', kasee wurung-Ku isian pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Dagai a wakamuu. Alia i kuu tongko' mingimamat barame ka' minginum upa kolio', kabai tongko' mingimamat upa-upa men bo tutuo'muu pataka i kuu sianmo toropot na ilio kotakaanna Tumpu men sian kuu inti'i. ");
INSERT INTO blzNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gause ilio iya'a bo mantakai giigii' mian na tano' balaki' kani'i. ");
INSERT INTO blzNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kuu tio sinampang maka'amat ka' sambayang, kada' i kuu mokotaan montorumpaki giigii' upa men bo sida iya'a pataka i kuu momoko poororo'up Anak Manusia.” ");
INSERT INTO blzNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesus nimisiso' na Laiganna Alaata'ala tempo ilio, ka' malom Ia mantalei motokol na Buu'na Zaitun. ");
INSERT INTO blzNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sanda' ma'ulo-ulop giigii' mian taka na Laiganna Alaata'ala momorongori pisiso' ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ramean Roti Sianta Ragina men ngaanon Paska karani'mo tempona. ");
INSERT INTO blzNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tanaasna imam ka' wawa ukum Torat nansarakmo salan se' too koi upa bo pampapatei i Yesus, gause i raaya'a matakutkon mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kasi Ibiliis niminsoopi i Yudas men ngaanon uga' i Iskariot. Yudas tonsoop sompulo' rua' murit ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ia nomae'mo ka' nopootundunii tia tanaasna imam ka' tanaasna dadagai Laiganna Alaata'ala se' koi upa a bo sasalan mongorookon i Yesus na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Raaya'a nobeles tuu' kasi nontoon i Yudas se' bo taraionna i raaya'a doi'. ");
INSERT INTO blzNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas uga' nansangadaimo, kasi ia nansarak salan men daa pore bo pongorookonanna i Yesus na ko'ona i raaya'a, kasee wuni-wuni dako' inti'ionna mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Takamo a tempona pangaramekonan Roti Sianta Ragina. Ilio iya'a mian tio mongkoyo' domba Paska men bo kaanon na baramean. ");
INSERT INTO blzNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mbaka' i Yesus nomosuu'mo i Petrus tii Yohanes tae-Na, “Rae' pontoropoti kumaanan Paska bo ko'onta'.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Raaya'a nimikirawarmo taena, “Maana po'uus-Muu bo pontoropotianmai?” ");
INSERT INTO blzNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ia simbati i Yesus tae-Na, “Imamat ini'imari! Tempo i kuu minsoop na kota, kuu bo pootuung sa'angu' moro'one tumambu' mangawawa gumbang buke' a weer. Lolo' i ia pataka laigan men pinsoopionna, ");
INSERT INTO blzNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ka' bantilkon na tombono laigan iya'a inta': ‘Guru nangaan tae-Na: maana a tampat men bo pangkaanan kakaan ramean Paska tia murit-Ku?’ ");
INSERT INTO blzNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tombono laigan iya'a bo minsiso'kon na ko'omuu sa'angu' olisna parawawo men balaki' men noko toropotmo tia pakakasna. Toropoti a kakaanta inda'a.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mbaka' nomae'mo i Petrus tii Yohanes, ka' nungurumpaki giigii' iya'a sintutu' koi men ia ngaan i Yesus. Raaya'a uga' nontoropotimo kakaan men bo kaanon na Paska iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sarataa takamo a tempo kumaanan Paska iya'a, Yesus no'umoruangmo kumaan ruru-ruru' tia poposuu'-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kasi i Ia norobu na ko'ona tae-Na, “Yaku' mingkira' tuu' kumaan Paska kani'i ruru-ruru' tii kuu koo'po tia i Yaku' repaion! ");
INSERT INTO blzNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bantilkonon-Ku na ko'omuu se' Yaku' mase sianmo mangkaan kakaan Paska soosoodo pataka aratina Paska kani'i pipiile'konon na Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Noko daa koiya'a i Yesus nanganakatmo sasangkir men isian anggur, nobasukuur na Alaata'ala, kasi norobu tae-Na, “Ala kani'i, ka' poo'obos. ");
INSERT INTO blzNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bantilkonon-Ku na ko'omuu se' supu koini'i Yaku' sianmo minginum anggur soosoodo pataka kotakaanna Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Noko daa koiya'a i Yesus nangalamo roti, nobasukuur ka' nungurumpi-rumpik, kasi nongorookon na murit-Na ka' norobu tae-Na, “Ni'imo a wakang-Ku men nirookon bo pontololoki i kuu. Alaka' wawau a men koi kani'i bookoi pinginau'muu i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Koiya'a uga', noko daa nangkaan, Ia nangalamo pinginuman tia anggur ka' nongorookon na ko'ona i raaya'a kasi norobu tae-Na, “Isiina pinginuman kani'i bookoi oosna toonna Alaata'ala men u'uru, men nipakadodor tia rara'-Ku, rara' men tonturo' bo ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Kasee piile'! Mian men bo pongorookon Yaku' isian kani'i tii Yaku'! ");
INSERT INTO blzNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Anak Manusia sabole bo lapus koi men ia patukomo Alaata'ala, kasee silaka' a mian men mongorookon i Ia!” ");
INSERT INTO blzNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kasi i raaya'a nopoopikirawari simbaya'na se' ime a men bo mangawawau koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mbaka' murit ni Yesus nopoomaso'mo gause munsurung ime a men balaki'na. ");
INSERT INTO blzNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus norobumo na ko'ona i raaya'a tae-Na, “Tomundo'na lipu' men sian minginti'i Alaata'ala mantalalais mianna, ka' i raaya'a mangaan wakana ‘Dadagai Rayat’. ");
INSERT INTO blzNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kasee kuu alia men koiya'a. Mian moola'na na ko'omuu tio sida koi men morio'na, ka' tanaas tio sida koi tutulungi. ");
INSERT INTO blzNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ime a men balaki'na: mian men taropion na meja', kabai se' mian men motarop? Sabole mian men taropion iya'a. Kasee Yaku' isian ruru-ruru' tii kuu bookoi mian men mantaropi. ");
INSERT INTO blzNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kuu a men sinampang ruru-ruru' tii Yaku' na giigii' repaan men nantakai i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yaku' mantarai i kuu batomundo'an koi men i rookon Tama na surugaa na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mbaka' i kuu bo kumaan ka' ba'inum ruru-ruru' tii Yaku' na Batomundo'an-Ku ka' i kuu uga' bo mongoruangi oruangan kobalaki'an ka' mungukumi sompulo' rua' bense'na lipu' Israel.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, imamat ini'imari! Ibiliis nama'ase'mo mimitopongi i kuu giigii' kada' i kuu bi sida koi ota'na gandum men nitaapi. ");
INSERT INTO blzNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kasee Yaku' daamo nansambayangkon i koo dako' imaawan rungku'. Ka' sarataa i koo mule'konmo na Ingku', koo tio mompopomoonggor utuus sa'angu' kaparasaya'an.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ia simbati i Petrus taena, “Tumpu, yaku' maloos a noangku minsoop na tarungkuan ka' pate ruru-ruru' tii Kuu!” ");
INSERT INTO blzNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kasee taeni Yesus, “Petrus, bantilkonon-Ku na ko'oom se' koo'po tia siok muntuturuu' ilio kani'i, koo noko porotolumo mangaan se' i koo sian poo'inti'i tii Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kasi i Yesus norobu na ko'ona tae-Na, “Tempo i Yaku' nomosuu' i kuu ka' sian nomoturang i kuu mangawawa dompet, pomantuan kabai sapato, kuu mbali' nunsuri isian men sianta na ko'omuu?” Ia simbati i raaya'a taena, “Sian!” ");
INSERT INTO blzNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Taeni Yesus, “Kasee koini'i, ime a men isian dompet kabai tuuman tio wawaonna. Ime a men sianta bakoko'na tio mambalukkon jubana bo pingili bakoko'. ");
INSERT INTO blzNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bantilkonon-Ku na ko'omuu se' men nitulis na Alkitaap tio sida na wakang-Ku. Isian nitulis koi kani'imari: ‘Ia nigalal koi sa'angu' mian men ba'idek a gau'na.’ Upa men nitulis na Alkitaap iya'a koini'i pintanga'mo sida na Ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Taena murit ni Yesus, “Tumpu, piile'! Kani'i isian bakoko' rurua'.” Ia simbati i Yesus tae-Na, “Daamo!” ");
INSERT INTO blzNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus namarereimo kota ka' nomae' na Buu'na Zaitun men malia' rae'ion-Na, ka' murit-Na uga' nomae' tii Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sarataa notakamo inda'a, Ia norobumo na ko'ona i raaya'a tae-Na, “Sambayangmo dako' i kuu topongionna idek.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kasi i Ia nintisaal olo-oloa na ko'ona i raaya'a, ko'oloana toro koi balo'on tia watu, kasi Ia nobanintuur ka' nosambayang. ");
INSERT INTO blzNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tae-Na, “Oo Tamang-Ku! Too daa i Kuu sangada, oloakon na Ingku' a repaan men tio rumpakion-Ku kani'i. Kasee alia mongololo' pingkira'-Ku. Lolo' a pingkira'-Muu.”  ");
INSERT INTO blzNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kasi sa'angu' malaa'ikat notaka na Ko'ona ka' nompopomoonggor i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Siasa tuu' a noa ni Yesus. Mbali' iya'a, Ia nosambayangmo tuu'. Ugot-Na koi rara' men tumuro' na tano'. ");
INSERT INTO blzNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Noko daa nosambayang, Yesus nomule'konmo soosoodo na murit-Na. Ia takai i Yesus i raaya'a nokoroyotmo gause masiongo'. ");
INSERT INTO blzNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kasi i Ia norobu na ko'ona tae-Na, “Nongko'upa se' i kuu royot? Wangon ka' sambayangmo dako' i kuu topongionna idek.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Pintanga' i Yesus dauga' morobu, notakamo a mian sa'angu' lulusan. Raaya'a ia tanaasi i Yudas men tonsoop sompulo' rua' murit ni Yesus. Kasi i Yudas nombaale'e ni Yesus bo mongooki i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kasee i Yesus norobu na ko'ona tae-Na, “Yudas, too tia nongooki iya'a koo mangakalkon Anak Manusia?” ");
INSERT INTO blzNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tempo murit ni Yesus men isian indo'o nimiile' upa men nosida, raaya'a nimikirawarmo taena, “Tumpu, too i raaya'a tio lawuionmai tia bakoko'?” ");
INSERT INTO blzNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kasi sa'angu' mian men nitakai indo'o nontotok ata'na Imam Moola' tamban nokopantas tilingana paraas uanan. ");
INSERT INTO blzNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kasee i Yesus norobu tae-Na, “Aliamomo'!” Kasi i Ia nongkoyong tilingana mian iya'a ka' nengelesi'i. ");
INSERT INTO blzNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Noko daa koiya'a i Yesus norobumo na tanaasna imam ka' na tanaasna dadagai Laiganna Alaata'ala tia motu-motu'a men notaka indo'o bo pangarakop i Ia tae-Na, “Pansaruimuu se' i Yaku' too mian puraga mbali' i kuu notaka poto'inton bakoko' tia popool? ");
INSERT INTO blzNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sanda' ilio i Yaku' monda'a tii kuu mimisiso' mian na tolodona Laiganna Alaata'ala, see i kuu sian nangarakop Yaku'. Kasee ni'imo a tempomuu balimang, ka' koini'i kuasana kapintungan a mingilimang.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Raaya'a nangarakopmo i Yesus ka' nangawawa na laiganna Imam Moola'. Petrus nuntuntuni kasee olo-oloa. ");
INSERT INTO blzNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na tanga'na tolodo iya'a isian mian namatu'u apu ka' i raaya'a no'umoruang na tiku-tikumna apu iya'a. Petrus uga' no'umoruangmo nintingola' na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Isian sa'angu' ata' wiwine nimiile' i Petrus oru-oruang karani' apu iya'a. Ia ninggimatai i Petrus ka' komburi'na ia norobu taena, “Mian kaya'a uga' poololo' tii Yesus!” ");
INSERT INTO blzNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kasee i Petrus ninsasapu taena, “Taasi'. Yaku' sian ninginti'i i Ia!” ");
INSERT INTO blzNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sian paraa nanau', mian sambana uga' nimiile' i Petrus ka' norobu taena, “Koo uga' tonsoop tii raaya'a!” Taena i Petrus, “Sian, taasi' i yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Toro sa'angu' jaam a noporusanna, mian sambana norobumo boolak taena, “Daa tuutuu' mian kaya'a poololo' tii Yesus, gause i ia uga' samba Galilea!” ");
INSERT INTO blzNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kasee ia simbati i Petrus taena, “Taasi'! Yaku' sian ninginti'i upa men koo porobukon.” Tempo iya'a uga' pintanga' i Petrus morobu, siok nuntuturuu'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tumpu ningilingamo ka' nintioki i Petrus. Kasi i Petrus tinonginau' se' Tumpu noko pambantilkonmo na ko'ona men tae-Na, “Koo'po tia siok muntuturuu' ilio kani'i, koo noko porotolumo minsasapu na Ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mbaka' no'umuarmo i Petrus ka' nowiri tamban bolingongoton. ");
INSERT INTO blzNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mian men nandagai i Yesus ningirokimo ka' numukul Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Raaya'a nongompodi ro'up-Na ka' nimikirawar na Ko'ona taena, “Io, ngaan too ime a numukul i Koo” ");
INSERT INTO blzNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dauga' biai' soosoodo a wurung men irokikononna i raaya'a i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma'ulopna, motu-motu'ana lipu' Yahudi, tanaasna imam tia wawa ukum Torat nobarimpungmo, kasi nangawawa i Yesus na Mahkama Agamana i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Taena i raaya'a, “Kalu i Koo kani'i Tomundo' Pansalamatkon, bantilkon na ko'omai.” Ia simbati i Yesus tae-Na, “Maupo bantilkonon-Ku na ko'omuu, kuu sian mamarasaya. ");
INSERT INTO blzNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ka' kalu Yaku' mimikirawar na ko'omuu, kuu uga' sian minsimbati. ");
INSERT INTO blzNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kasee supu koini'i Anak Manusia bo umoruang na paraas uananna Alaata'ala men Pungkuasai.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Raaya'a giigii' norobumo taena, “Kalu koiya'a, Koo kani'i Anakna Alaata'ala?” Ia simbati i Yesus tae-Na, “Koi men taemuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kasi i raaya'a norobu taena, “Bo upa ka' dauga' mansarak mian bo pinginti'ianta! Daa kita rongormo a men Ia porobukon!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Giigii' mian men bo pungukumi iya'a nokumekerermo, kasi nangawawa i Yesus mae' ni Pilatus. ");
INSERT INTO blzNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Indo'o raaya'a nuntumbeimo nangarait i Yesus. Raaya'a nangaan taena, “Kai piile'mo se' mian kani'i montombolongkon mian biai'. Ia nangasui mian kada' alia mambayar pajak bona Kaisar, ka' Ia nangaan waka-Na se' Iamo i Kristus, men sa'angu' Tomundo'.” ");
INSERT INTO blzNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kasi i Pilatus nimikirawar ni Yesus taena, “Koomo a tomundo'na lipu' Yahudi?” Ia simbati i Yesus tae-Na, “Koi nooro'o men taemuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mbaka' taena i Pilatus na tanaasna imam ka' na mian biai' iya'a, “Yaku' sian nantausi sa'angu'po sala'na mian kani'i kada' bo ukumkonon i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kasee i raaya'a dauga' mamparipari taena, “Ia mangasui mian na longkop Yudea tia pisiso'-Na, tumbena na Galilea, ka' koini'i takamo ka'ita.” ");
INSERT INTO blzNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tempo i Pilatus nongorongor men koiya'a, ia nimikirawarmo taena, “Mian kani'i se' samba Galilea?” ");
INSERT INTO blzNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sarataa nibantilkon se' i Yesus ringkat na libutan men tomundo'ion ni Herodes, Pilatus nomosuu'mo mian mangawawa i Ia mae' ni Herodes men tempo iya'a isian uga' na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sarataa i Herodes nimiile' i Yesus, beles tuu' i ia, gause nanau'mo a nongorongoranna i Yesus, ka' ia uga' mingkira' mimiile' i Yesus. Ia mongooskon se' daa mimiile' i Yesus mangawawau upa kosamba'. ");
INSERT INTO blzNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mbali' iya'a, biai' a men ia pikirawar i Herodes na Ko'ona, kasee santaa'po sian Ia simbati. ");
INSERT INTO blzNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tanaasna imam ka' wawa ukum Torat nokumekerermo ka' nangarait i Yesus men dodoa tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mbaka' i Herodes tia surudaduna nuntumbeimo nangaani ka' ningiroki i Yesus, ka' nomopakei pakean kobalaki'an, kasi nungule'kon i Ia mbaale'e ni Pilatus. ");
INSERT INTO blzNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na ilio iya'a uga' i Herodes tii Pilatus men mbaripian sian pookakana' nosidamo notobela' soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus ningirimpungmo tanaasna imam, tanaasna lipu' Yahudi ka' mian biai', ");
INSERT INTO blzNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kasi norobu na ko'ona i raaya'a taena, “Kuu nangawawa mian kani'i na ingku' ka' taemuu se' i Ia montombolongkon mian biai'. Koini'i yaku' paresamo i Ia piipiile' i kuu, kasee titiu'po idek-Na men kuu raitkon i Ia sian yaku' rumpaki. ");
INSERT INTO blzNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ka' i Herodespo uga' sian nantausi sala'-Na. Mbali' iya'a, ia nungule'konmo i Yesus soosoodo na ko'omai. Imamat ini'imari! Mian kani'i bookoi sian nangawawau titiu'po men sala' men tio bo ukumon tia ukuman pate. ");
INSERT INTO blzNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mbali' iya'a, Ia bo sasalionku kasi uarkonon.”  ");
INSERT INTO blzNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na sanda' ramean Paska, Pilatus tio munguarkon sa'angu' mian na tarungkuan bona mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kasee giigii' mian men norimpung indo'o nangkakaro'mo taena i raaya'a, “Papatei Ia! Uarkon i Barabas bo ko'omai!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas nitarungku gause sian momorongori pamarenta ka' nangawawau kogora'an na lalomna kota ka' nampapatei mian. ");
INSERT INTO blzNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus mingkira' munguarkon i Yesus. Mbali' iya'a, ia norobu soosoodo na mian biai' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kasee i raaya'a tongko' mangkakaro', taena, “Saliipkonmo a mian kanono'! Saliipkonmo a mian kanono'!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kasi i Pilatus norobu men koporotoluna na ko'ona i raaya'a taena, “Kasee idek upa a men Ia poko wawaumo? Yaku' sian nimiile' sa'angu'po sala'-Na men tio ukumon tia ukuman pate! Mbaka' Ia bo sasalionku, kasi uarkonon.” ");
INSERT INTO blzNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kasee i raaya'a tongko' kaekae' dodoa mangkakaro'kon se' i Yesus tio saliipkonon. Ka' komburi'na upa men ia pangkakaro'kon i raaya'a niloloikonmo. ");
INSERT INTO blzNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mbaka' i Pilatus nongololoikonmo koi men kikira'na i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ia nunguarkonmo mian men ia pa'ase' i raaya'a, mian men nitarungku gause nangawawau kogora'an ka' nampapatei mian. Kasee i Yesus ia rookon i Pilatus na ko'ona i raaya'a bo wawauonna koi pingkira'na i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mbaka' i Yesus ia wawamo i raaya'a. Na tanga'na salan raaya'a nopootuungmo tia sa'angu' mian men ngaanna i Simon, Ia samba Kirene, ka' baasi bo minsoop na kota. Raaya'a nantaankon i ia ka' namakisaa nompopasa'anikon saliip iya'a na ko'ona, kasi i ia nuntuntuni i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Biai' a mian nongololo' na komburi' ni Yesus. Isian uga' toropii wiwine. Raaya'a mingiwirii ka' mantando'i i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kasee i Yesus ningilinga i raaya'a ka' norobu tae-Na, “Oo wiwine men na Yerusalem! Aliamomo' mingiwirii i Yaku'. Wirii a wakamuu ka' anakmuu. ");
INSERT INTO blzNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Imamat ini'imari! Bo taka tempona mian bo mangaan, ‘Barakaatan a wiwine men sian nontoo pampaiwawa, men sian nontoo anakon ka' sian nontoo pomosusui anak ngamea'!’ ");
INSERT INTO blzNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na tempo iya'a mian bo momorobui buu'na taena, ‘Utunimo i kai!’ ka' momorobui buu'na morio' taena, ‘Tabunimo i kai!’ ");
INSERT INTO blzNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gause kalu na kau men dauga' tumuo' mian noko pangawawaumo men koiya'a, upa mune' na kau men noko pakangkungmo!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Isian uga' rua' mian sambana men ba'idek a gau'na, ia wawa i raaya'a bo ukumon pate singka-singkat' tii Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sarataa notaka na tampat men ngaanon Lamasna Takala', raaya'a nansaliipkonmo i Yesus ka' uga' rua' mian men ba'idek a gau'na iya'a, men sa'angu' paraas uanan ka' sa'angu' soosoodo paraas kauri' ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kasi i Yesus nosambayang tae-Na, “Tama, ampuni i raaya'a gause i raaya'a sian ninginti'i upa men wawauonna.” Pakean ni Yesus ni'undimo indo'o ka' ni'obo'-obos na mian men nokana' undi. ");
INSERT INTO blzNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mian biai' potokerer indo'o ka' nimiile' giigii' iya'a. Kasee moomoola'na Yahudi ningiroki i Ia taena, “Mian sambana pokoon-Na salamatkonon. Koini'i bi salamatkona waka-waka-Namo, kalu se' tuutuu' i Ia Tomundo' Pansalamatkon men ia ruruki Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Surudadu uga' ningiroki i Ia. Raaya'a nonsoori i Ia anggur men makarang, ");
INSERT INTO blzNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kasi nangaan taena i raaya'a, “Kalu Koo tomundo'na lipu' Yahudi, salamatkonmo a wakaam!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na paraas wawona saliip ni Yesus isian nitulis koi kani'imari: Ni'imo a Tomundo'na Lipu' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sa'angu' mian men ba'idek a gau'na men nisaliipkon inda'a uga' ningirokimo i Yesus taena, “Koo taasi' Tomundo' Pansalamatkon? Salamatkon a wakaam ka' uga' i kai!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kasee samba-sambana men sa'angu' nambantili samba-sambana iya'a taena, “Koo sian layaonkon Alaata'ala? Koo uga' ni'ukum pate koikoimo tii Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tongko' se' ukumanta rua' kita sintutu' tia wawaunta. Kasee i Ia kaya'a toro tiu'po sianta sala'-Na!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kasi ia norobu taena, “Yesus, inau'on i yaku' kalu i Kuu takamo bo pontomundo'i!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Taeni Yesus na ko'ona, “Daa. Bantilkonon-Ku na ko'oom se' na iliopo kani'i i koo bo ruru-ruru' tii Yaku' na Firdaus.” ");
INSERT INTO blzNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Toro jaam duablaas, nopintungmo a longkop libutan iya'a pataka jaam tiga, ");
INSERT INTO blzNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","gause ilio sianmo notaraang. Toik men pongola'i olisna Laiganna Alaata'ala kinoberakmo rua'. ");
INSERT INTO blzNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kasi i Yesus nangkakaro' boolak tae-Na, “Papa! Na lima-Muu a pongorookonan-Ku alus-Ku!” Noko daa norobu koiya'a, nopudul a noa-Na. ");
INSERT INTO blzNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tempo tanaasna surudadu nimiile' upa men nosida iya'a, ia nuntunde'mo Alaata'ala, kasi norobu taena, “Sabole mian kani'i sianta sala'-Na!” ");
INSERT INTO blzNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mian biai' men notaka nimiile' mian nisaliip iya'a nimiile'kon upa men nosida. Raaya'a giigii' nomule'konmo puru-purusi sara'an gause ninsosol tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kasee giigii' poo'inti'ian ni Yesus, tonsoop wiwine men nongololo' i Ia ringkatpo na Galilea, potokerer oloa ka' nimiile' giigii' men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Isian sa'angu' mian men ngaanna i Yusuf. Ia tonsoop mianna Mahkama Agama. Ia mian men pore a wawauna ka' kana'. ");
INSERT INTO blzNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ia sian nansangadai men taena Mahkama Agama iya'a. Ia ringkat na Arimatea, sa'angu' kota na Yahudi ka' ia pintanga' mempeperai tempona Batomundo'anna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ia nomae'mo ni Pilatus ka' nama'ase' biibii ni Yesus kada' rookonon na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kasi ia nantaro' biibii ni Yesus na saliip ka' nambalun tia toik pobalun. Pobalun iya'a, toik lenang a niwawau. Noko daa koiya'a ia nomotokolmo biibii ni Yesus na baleanan men nipa'atkon na buu'na watu. Baleanan iya'a sianpo nitoopake. ");
INSERT INTO blzNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ilio iya'a ilio batoropotan, ka' boomo muntumbei iliona Sabat. ");
INSERT INTO blzNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wiwine men notaka tii Yesus ringkatpo na Galilea nongololo'mo i Yusuf ka' nimiile' baleanan iya'a. Raaya'a nimiile' uga' koi upa biibii ni Yesus nipotokol na lalomna baleanan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Komburi'na i raaya'a nomule'konmo kasi nontoropoti rampa ka' minamina' bo pintimbu'i biibii ni Yesus. Na ilio Sabat, raaya'a sian balimang gause malolo' na ukum Torat. ");
INSERT INTO blzNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na iliona Minggu, ma'ulo-ulop tuu' toropii wiwine iya'a nomae'mo na baleanan nangawawa rampa men ia toropotimo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ia takai i raaya'a a watu men nongompodi baleanan iya'a noko tolinda'mo. ");
INSERT INTO blzNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kasi i raaya'a ninsoop na baleanan iya'a, kasee i raaya'a sian nantakai biibii ni Tumpu Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Potokerer i raaya'a indo'o ka' samba'kon upa men nosida iya'a, ola-olan kere-kerer a rua' mian men nopakean tamban dingkalapan beebeel i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Raaya'a nolayaonmo tuu', mbaka' i raaya'a notumutuku' rumbuk tano'. Kasee mian men rua' ira iya'a norobumo taena, “Nongko'upa i kuu se' mansarak mian tumuo' na mian men nolapusmo? ");
INSERT INTO blzNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ia sianmo kani'i. Ia notuo'mo soosoodo! Inau' a upa men Ia tundunkonmo na ko'omuu tempo Ia dauga' na Galilea, ");
INSERT INTO blzNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","men tae-Na, ‘Anak Manusia tio rookonon na limana mian dosaon, kasi saliipkonon, ka' na ilio kotolu'na i Ia bo tumuo' soosoodo.’ ” ");
INSERT INTO blzNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mbaka' i raaya'a tinonginau'mo na wurung ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sarataa i raaya'a nomule'kon ntu'umari na baleanan, raaya'a nuntundunkonmo giigii' men nosida iya'a na murit ni Yesus men sompulo' sa'angu' iya'a, ka' uga' na giigii' murit men sambana. ");
INSERT INTO blzNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wiwine men nambantilkon giigii' iya'a na poposuu' ni Yesus tonsoop ai Maria Magdalena, Yohana, Maria sina ni Yakobus, kasi toropii wiwine sambana men poopoololo' tii raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kasee poposuu' iya'a nansarui se' wiwine iya'a tongko' nuntundunkon upa men sian tuutuu'. Raaya'a sian namarasaya tundunanna wiwine iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mau mune' koiya'a i Petrus noringkatmo ka' notumetende' mae' na baleanan iya'a. Ia nodumudungku'mo ka' nimiile' waatu'u na lalomna, kasee men ia piile' tongko' toik pobalun. Kasi ia nomule'kon see na noana mingintomkon upa men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na ilio iya'a uga', rua' mian murit ni Yesus banta-bantang mae' na sa'angu' kampung men ngaanna Emaus. Ko'oloana toro sompulo' sa'angu' kilo na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Potorae', raaya'a muntundun giigii' upa men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tempo i raaya'a pintanga' pootundunii ka' pootarai pikiran, notakamo i Yesus poopoololo' tii raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Raaya'a nimiile' i Yesus, kasee isian men ningililungi matana i raaya'a mbali' sian ia inti'i i raaya'a se' ime i Ia. ");
INSERT INTO blzNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kasi i Yesus norobu na ko'ona tae-Na, “Upa a men pootunduniikononmuu potorae' kani'i?” Raaya'a notaanmo ka' ro'upna i raaya'a kampiile'an masiongo'. ");
INSERT INTO blzNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kasi sa'angu' mian na rua' mian iya'a, men ngaanna i Kleopas, nimikirawar ni Yesus taena, “Dogi' tongko' i Koo a mian tumaka na Yerusalem men sian ninginti'i upa men nosida inda'a baa-baasi kani'i.” ");
INSERT INTO blzNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ia pikirawar i Yesus tae-Na, “Upa a men nosida?” Ia simbati i raaya'a taena, “Tundunan men nosida na waka ni Yesus samba Nazaret iya'a. Ia nabii. Wurung-Na ka' upa men Ia wawau kuasaan tuu', mau koi pomiile'na Alaata'ala ka' uga' koi pomiile'na giigii' mian. ");
INSERT INTO blzNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tanaasna imam ka' tanaasna lipu'mai nongorookon Ia bo ukumon pate, ka' i raaya'a nansaliipkonmo i Ia! ");
INSERT INTO blzNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Poali kai mongooskon se' Iamo a men bo pembebaskon lipu' Israel! Ka' ilio kani'i ilio kotolu'namo nosidaanna giigii' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kasee isian toropii wiwine men simbaya'mai nomotongkodi'mo i kai. Gause ma'ulo-ulop tuu' i raaya'a nomae'mo na baleanan, ");
INSERT INTO blzNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kasee i raaya'a sian nantakai biibii-Na. Kasi i raaya'a nomule'kon ka' nambantilkon se' i raaya'a nimiile' malaa'ikat, ka' malaa'ikat iya'a nangaan se' i Yesus notuo'mo soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Toropii mian samba-sambamai uga' nomae' na baleanan iya'a, ia takai i raaya'a a upa men ia ngaan toropii wiwine iya'a tuutuu'. Kasee i raaya'a sian nimiile' i Yesus.” ");
INSERT INTO blzNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kasi i Yesus norobu na ko'ona tae-Na, “Kuu kani'i se' bobo' tuu'! Nanau'mo i kuu sian mamarasaya giigii' men ia poko ngaanmo nabii! ");
INSERT INTO blzNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Taasi' uga' Tomundo' Pansalamatkon tio munsuri repaan kutung, kasi angga'ion?” ");
INSERT INTO blzNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kasi i Yesus nompopo'inti'ikon na ko'ona i raaya'a giigii' upa men nitulis na Alkitaap men muntundun waka-Na, muntumbei na kitap ni Musa ka' giigii' kitapna nabii. ");
INSERT INTO blzNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pintanga' mompopo'inti'ikon men koiya'a raaya'a noko karani'mo kampung men rae'ionna. Yesus nangawawaumo se' ako-akon Ia bo bakaliuliu. ");
INSERT INTO blzNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kasee i raaya'a nantaankonmo i Ia. Taena, “Tuuk kutung na ko'omai. Koini'i boomo malom ka' uga' muntumbeimo pika'.” Mbaka' i Yesus notuukmo tii raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sarataa i raaya'a umoruangmo kumaan, Yesus nangalamo roti, nobasukuur na Alaata'ala ka' nungurumpi-rumpik roti iya'a, kasi nongorookon i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kasi matana i raaya'a sianmo nokolilungian ka' i raaya'a ninginti'imo se' mian iya'a i Yesus. Kasee i Yesus sianmo ia piile' i raaya'a soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Raaya'a nopootundunimo taena, “Taasi' uga' noanta tongkibit tuu' tempo Ia batundun tii kita na tanga'na salan, ka' tempo Ia nompopo'inti'ikon isiina Alkitaap na ko'onta?” ");
INSERT INTO blzNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tempo iya'a uga' i raaya'a norumingkatmo ka' nomule'kon na Yerusalem. Inda'a raaya'a nantakaimo sompulo' sa'angu' poposuu' ni Yesus pintanga' barimpung tia mian sambana. ");
INSERT INTO blzNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mian men nobarimpung iya'a norobumo taena, “Tumpu notuo'mo soosoodo! Ia nintipiile'mo ni Simon!” ");
INSERT INTO blzNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Rua' murit ni Yesus men baasi notaka nuntundunkonmo upa men nosida na tanga'na salan, ka' koi upa a ninginti'ina i raaya'a i Ia tempo i Ia nungurumpi-rumpik roti. ");
INSERT INTO blzNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pintanga' i raaya'a batundun, ola-olan isian i Yesus kere-kerer na tanga'na i raaya'a. Ia norobu tae-Na, “Sulano bi ratong a tutuo'muu!” ");
INSERT INTO blzNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Raaya'a tinongkodi'mo ka' nolayon gause pansaruina se' i raaya'a nimiile' santuo'. ");
INSERT INTO blzNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kasee i Yesus norobu tae-Na, “Nongko'upa i kuu se' layaon? Nongko'upa a noamuu se' raranga'? ");
INSERT INTO blzNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Piile' a limang-Ku ka' piile' a sarat-Ku. Yaku'mo ini'i! Purus ka' piile' pore-pore, gause santuo' sianta antokna kabai wukuna koi men kuu piile' na Ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesus nangaan koiya'a poopoololo' nimpipiile'kon lima-Na tia sarat-Na na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na tempo i raaya'a sianpo laan mamarasaya, gause beles tuu' ka' samba', Yesus nimikirawarmo na ko'ona i raaya'a tae-Na, “Kuu isian kakaan kani'imari?” ");
INSERT INTO blzNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Raaya'a nantaraimo i Ia sangkorot susum nigoreng. ");
INSERT INTO blzNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesus nangalamo susum iya'a kasi nangkaan piipiile' i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Noko daa koiya'a i Yesus norobumo na ko'ona i raaya'a tae-Na, “Sanda' upa men nitulis muntundunkon i Yaku' na kitap Torat Musa, kitap Nabii, ka' kitap Mazmur, nono' tio sida. Ni'imo a men Yaku' poko bantilkonmo na ko'omuu tempo i Yaku' dauga' ruru-ruru' tii kuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kasi i Yesus nunguruari pikiranna i raaya'a kada' minginti'i isiina Alkitaap. ");
INSERT INTO blzNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kasi i Ia norobu na tae-Na, “Na Alkitaap isian nitulis se' Tomundo' Pansalamatkon tio munsuri repaan ka' noko daa lapus Ia tumuo' soosoodo na ilio men kotolu'na. ");
INSERT INTO blzNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ka' i kuu tio mangaan ngaanna Tomundo' Pansalamatkon tempo i kuu mengelelekon na giigii' lipu' se' mian tio monsosoli ka' mangkadarai gau'na men ba'idek, ka' Alaata'ala mangampuni dosa. Lele iya'a tio lelekonon na giigii' lipu' muntumbei na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kuu a men bo pompotuutuu' giigii' kani'i. ");
INSERT INTO blzNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ka' i Yaku' uga' bo mamakatu na ko'omuu upa men ia toonkonmo Tamang-Ku. Kasee i kuu tio mempeperai na kota kani'i pataka kuasana Alaata'ala taka na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Noko daa koiya'a i Yesus nangawawamo i raaya'a umuar na kota mae' na Betania. Inda'a i Ia nanganakatmo lima-Na, kasi nambarakaati i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pintanga' i Ia mambarakaati i raaya'a, Ia notoleengketmo waara'a surugaa torensa na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Raaya'a nobanintuurmo ka' notumutuku' rumbuk tano' nonsoosa' i Ia, kasi i raaya'a nomule'kon na Yerusalem tia noa men beles tuu'. ");
INSERT INTO blzNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Raaya'a sinampang isian na Laiganna Alaata'ala muntunde' Alaata'ala.");
INSERT INTO blzNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tumbenapo, koo'po tia dunia nisidakon, Ia men ningaan Wurungna Alaata'ala noko isianmo. Wurung iya'a ruru-ruru' tia Alaata'ala, ka' Wurungmo iya'a uga' a Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ia tumbenapo ruru-ruru' tia Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Wurungmo iya'a a men bo pinsidakon giigii' upa. Giigii' men nosidamo ka' men no'isianmo iya'a, sianta sa'angu'po upa men taasi' i Ia a ninsidakon. ");
INSERT INTO blzNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iamo a pu'una tutuo' men pore, ka' tutuo'-Na iya'a a ruar bona mian. ");
INSERT INTO blzNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ruar iya'a munguruari kapintungan, ka' kapintungan sianta momoko mungurungku'i ruar iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Isian sa'angu' mian men notaka ia posuu' Alaata'ala. Ngaanna i Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ia notaka mompotuutuu' ruar iya'a, kada' tia tatakana giigii' mian sida parasaya. ");
INSERT INTO blzNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kasee taasi'po i Yohanes a ruar iya'a. Ia tongko' nompopo'inti'ikon ruar iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ruar men tuutuu'na, men munguruari giigii' mian, notakamo na tano' balaki'. ");
INSERT INTO blzNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wurung iya'a isianmo na tano' balaki', ka' tano' balaki' iya'a i Ia a ninsidakon, kasee mian na tano' balaki' sianta ninginti'i i Ia. ");
INSERT INTO blzNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ia notaka na lipu'-Na suungna, kasee mian men na lipu'-Na iya'a sian nangalabot i Ia. ");
INSERT INTO blzNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kasee uga' isian mian men daa nangalabot ka' namarasaya i Ia, ka' i raaya'a uga' Ia tarai kuasa kada' sida anakna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Raaya'a taasi' anak men ia ngamea'kon mian gause pingkira'na moro'one, kasee nosida anak tia kuasana Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wurung men ruru-ruru' tia Alaata'ala iya'a nosidamo mian ka' nodumodongo na ko'onta'. Ka' uga' kita piile'mo a kobalaki'an-Na men ia rookon Alaata'ala na Anak-Na men sa'a-sa'angu'. Kita nimiile' na Anak iya'a biai' a kaporean men kana'. ");
INSERT INTO blzNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes taka mompopo'inti'ikon Wurung iya'a. Ia nengeleelo'kon taena, “Kani'imo i Ia men taengku': Ia bo taka muntuntuni i yaku', ka' i Ia balaki'na tii yaku', gause koo'po tia i yaku' no'isian, Ia noko isianmo.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kaporean-Na sian kokabu-kabusanna, ka' Ia sinampang mambarakaati i kita giigii'. ");
INSERT INTO blzNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ukum Torat ia tadulkon i Musa. Kasee kaporean men kana' ia tadulkon i Yesus Kristus. ");
INSERT INTO blzNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sianpo isian mian men nontoo piile' Alaata'ala saliwakon Anak-Na men sa'a-sa'angu' men isian tii Ia. Ia a men nompopo'inti'ikon na ko'onta' Alaata'ala men Tama-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Koi kani'imari a taeni Yohanes tempo isian moomoola'na Yahudi na Yerusalem nomosuu' toro pii imam ka' mian Lewi taka nimikirawari i ia. Taena i raaya'a, “Ime i koo kani'i?” ");
INSERT INTO blzNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ia sian nompopowuni kasee liuliu nonsosoikon taena, “Yaku' taasi' Tomundo' Pansalamatkon.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mbaka' taena i raaya'a, “Kalu koiya'a, ime mbali' i koo? Koomo i Elia?” Ia simbati i Yohanes taena, “Taasi'.” Mbaka' ia pikirawarimo i raaya'a soosoodo taena, “Kabai koomo a nabii men peperaion?” Ia simbati i Yohanes taena, “Taasi'.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Taena i raaya'a, “Kalu koiya'a, ime ansee i koo kani'i? Gause tio bo bantilkononmai na tanaasmai men nomosuu' i kai se' ime i koo men tuutuu'na. Too koi upa a taeem?” ");
INSERT INTO blzNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ia simbati i Yohanes taena, “Yaku'mo a men ia tundun i Nabii Yesaya taena, ‘Isian mian na tano' maleas mengeleelo'kon ka' mambantilkon koi kani'imari: loosikon a salan bona Tumpu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mian men niposuu' iya'a uga' isian mian Farisi. ");
INSERT INTO blzNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Taena i raaya'a, “Kalu i koo taasi' Tomundo' Pansalamatkon, taasi' i Elia, ka' uga' taasi' nabii men peperaion, kadai i koo se' mansarani mian?” ");
INSERT INTO blzNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Taeni Yohanes, “Yaku' mansarani mian tia weer. Kasee isian sa'angu' mian na ko'omuu men sian kuu inti'i. ");
INSERT INTO blzNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ia taka muntuntuni i yaku', kasee mangalakai lui'na sapato-Napo, yaku' koo'.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Giigii' iya'a nosida na Betania, na soripi'na Weerkauna Yordan paraas bete'an, na tampat ni Yohanes mansarani mian. ");
INSERT INTO blzNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Koi liilana i Yohanes nimiile' i Yesus nuntuu'i i ia. Kasi taeni Yohanes, “Piile', ya'amo a Anak Dombana Alaata'ala men mansapui dosana dunia. ");
INSERT INTO blzNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iamo a men taengku' bo taka muntuntuni i yaku'. Kasee i Ia a balaki'na tii yaku', gause koo'po tia i yaku' no'isian i Ia noko isianmo. ");
INSERT INTO blzNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Maune' i yaku' taka mansarani mian tia weer kada' samba Israel minginti'i i Ia, kasee tumbena i yaku' sianpo ninginti'i i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ka' i Yohanes uga' nompopo'inti'ikon taena, “Yaku' nimiile' Alus Molinas nalau nda'amari langit koi sapu' marampatii ka' nodumodongo ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tempo i yaku' sianpo nimiile' Alus Molinas nda'amari langit, yaku' sianpo ninginti'i i Ia. Kasee Alaata'ala men nomosuu' i yaku' mansarani tia weer nambantilkon na ingku' tae-Na, ‘Kalu i koo mimiile' Alus Molinas malau na sa'angu' mian, mbaka' mian men palauionna nono'mo a men bo mansarani tia Alus Molinas.’ ");
INSERT INTO blzNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yaku' poko piile'mo suungku, mbali' daa yaku' mompotuutuu' na ko'omuu se' i Iamo a Anakna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Koi liilana i Yohanes no'isianmo soosoodo tia rua' muritna. ");
INSERT INTO blzNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sarataa ia nimiile' i Yesus nolumiu, ia norobumo na muritna taena, “Piile'! Le'emo a Anak Dombana Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Rua-rua'na murit ni Yohanes iya'a nomorongor upa men ia ngaan, kasi i raaya'a mae' nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus ningilinga na komburi'na ka' nimiile' se' i raaya'a nolumolo'mo tii Ia. Mbaka' Ia pikirawarimo taena, “Upa a men sarakonmuu?” Ia simbati i raaya'a taena, “Rabi, aana dodongoan-Muu?” (Rabi aratina Guru.) ");
INSERT INTO blzNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Taeni Yesus, “Mai, lolo' kada' piile'onmuu.” Mbaka' i raaya'a nomae'mo tii Yesus mimiile' dodongoan-Na. Raaya'a notaka toro jaam ampat maamaalom, ka' indo'o tii Yesus pataka malom. ");
INSERT INTO blzNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andreas, utus ni Simon Petrus, tonsoop korua'na mian men nomorongor upa men taeni Yohanes, ka' nongololo' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ia liuliu nansarak i Simon utusna, ka' nambantilkon taena, “Kai nopootuungmo tii Tomundo' Pansalamatkon!” (Tomundo' Pansalamatkon aratina: Kristus) ");
INSERT INTO blzNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andreas nangatormo i Simon mae' ni Yesus. Yesus nintiokimo i Simon, ka' norobu taena, “Koo Simon, anak ni Yohanes. Koo bo ngaanon i Kefas.” (Kefas koikoimo i Petrus, aratina: buu'na watu.) ");
INSERT INTO blzNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Koi liilana i Yesus nuntukokonmo mae' na libutan Galilea. Ia nopootuung tii Filipus, ka' nangange taena, “Mai, lolo' i Yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipus iya'a samba Betsaida, kota men dodongoan nari Andreas tii Petrus. ");
INSERT INTO blzNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipus nangarae'i i Natanael ka' nambantilkon taena, “Kai tausimo a mian men ia tundun i Musa na Kitap Torat ka' uga' men ia bantilkon nabii. Iamo i Yesus, samba Nazaret, anak ni Yusuf.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ia simbati i Natanael taena, “Minsoop na akal mbali' se' upa men pore bo taka ringkat na kota Nazaret?” ");
INSERT INTO blzNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ia simbati i Filipus taena, “Mai, alaka' piile' suuwung!” Yesus nimiile' se' i Natanael notaka na Ko'ona, mbaka' Ia nuntundunmo i Natanael taena, “Piile', ia men daa tuutuu' ngaanon samba Israel. Ia sianta idekna.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kasi i Natanael nimikirawar ni Yesus taena, “Koi upa se' i Kuu ninginti'i i yaku'?” Taeni Yesus, “Koo'po tia i Filipus nangarae'i i koo, Yaku' poko piile'mo i koo na intuna kau ara.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Taeni Natanael, “Guru, Kuumo a Anakna Alaata'ala! Kuumo a Tomundo'na samba Israel!” ");
INSERT INTO blzNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ia simbati i Yesus tae-Na, “Too i koo noparasaya montookon Yaku' nangaan se' nimiile' i koo na intuna kau ara? Upa-upa men labi tia koiya'a bo piile'oon.” ");
INSERT INTO blzNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kasi taeni Yesus soosoodo, “Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' i kuu bo mimiile' langit kobongkatian ka' mimiile' malaa'ikatna Alaata'ala malau-masawe' mae' na Ingku' Anak Manusia.” ");
INSERT INTO blzNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Koi itulunna isian posuo'an na kota Kana men na Galilea, ka' sina ni Yesus uga' isian indo'o. ");
INSERT INTO blzNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus tia murit-Na uga' nibantili na posuo'an iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sarataa anggur na posuo'an iya'a nokabusmo, sina ni Yesus norobumo na Ko'ona taena, “Anggurna i raaya'a nokabusmo.” ");
INSERT INTO blzNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ia simbati i Yesus tae-Na, “Mama, kadai se' i kuu morobu koiya'a na Ingku'. Sianpo taka tempona i Yaku' mimpipiile'kon wawaung-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kasee sina ni Yesus norobu na mian men balimang taena, “Wawau a upa men bantilkonon ni Yesus na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na posuo'an iya'a isian gumbang nonoom men nitoropoti bo pimbuu'an gause koiya'a a adatna Yahudi. Sanda' gumbang iya'a isiina toro sa'atu liter. ");
INSERT INTO blzNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus norobumo na mian men balimang tae-Na, “Isiimo tia weer a gumbang karaanono'.” Mbaka' ia isiimo i raaya'a pataka nobuke'. ");
INSERT INTO blzNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kasi i Yesus norobu na ko'ona tae-Na, “Alaka' tauk a weer kanono' titiu' ka' wawakon na tanaasna ramean.” Mbaka' ia wawakonmo i raaya'a a weer iya'a na tanaasna ramean, ");
INSERT INTO blzNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","kasi ia inum a weer iya'a men nosidamo anggur. (Kasee tanaas iya'a sian ninginti'i nangalaan anggur iya'a, tongko' mian balimang men nantauk weer iya'a men daa ninginti'i.) Mbaka' tanaasna ramean iya'a nuntuu'imo moro'one men mosuo', ");
INSERT INTO blzNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ka' norobu taena, “Mansanda' mian mantaropkon olukon anggur men pore ka' kalu sawe' bangarmo kasi anggur men sian laan pore. Kasee i kuu nanganaa' anggur men porena tuu' pataka koini'i!” ");
INSERT INTO blzNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ya'amo a upa kosamba' men tumbena tuu' ia wawau i Yesus. Ia nangawawau iya'a na Kana men na Galilea. Wawau kosamba' iya'a niwawau bookoi oosan men mompopo'inti'ikon kobalaki'an-Na. Mbaka' murit-Na noparasayamo na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Noko daa posuo'an iya'a, Yesus tia sina-Na, utus-Na, ka' murit-Na nomae'mo na Kapernaum. Raaya'a nodumodongo indo'o toro pii ilio. ");
INSERT INTO blzNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Torumpak ilio ramean Paska na lipu' Yahudi, Yesus nomae'mo na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na tolodona Laiganna Alaata'ala na Yerusalem, Ia nantakai mian mobaluk sapi', domba, marampatii, ka' uga' mian men totolosi doi' poto'oruang iraando'o. ");
INSERT INTO blzNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesus nangalamo lui' bo pembebot ka' nangaraap i raaya'a giigii' tia domba ka' sapi' men isian na tolodona Laiganna Alaata'ala iya'a. Giigii' mejana mian totolosi doi' Ia tua-tua'kon tamban doi'na i raaya'a notampaas na tano'. ");
INSERT INTO blzNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kasi Ia norobu na mian men mobaluk marampatii tae-Na, “Uarkon giigii' iraanono'. Alia minsidakon Laiganna Tamang-Ku bo pobalukanmuu!” ");
INSERT INTO blzNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mbaka' murit-Na tinonginau'mo isiina Alkitaap men taena, “Lingu'-Ku na Laigan-Muu Alaata'ala, minsidakon munsuap noang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Moomoola'na Yahudi nanggagai i Yesus taena i raaya'a, “Kalu i Koo ia tarai Alaata'ala kuasa bo pinginti'i Laigan-Na kani'i, alaka' pangawawau upa kosamba' bo oosanmai.” ");
INSERT INTO blzNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ia simbati i Yesus tae-Na, “Runtuni a Laigan kani'i, ka' tongko' tolu' ilio pokereron-Kumo soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kasi taena i raaya'a, “Laiganna Alaata'ala kani'i tiodaa patompulo' ka' nonoom taun mbali' daa poko nipokerer. Se' daa i Koo mangaan bo momokerer tongko' tolu' ilio?” ");
INSERT INTO blzNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kasee panduung ni Yesus mangaan Laiganna Alaata'ala mase waka-Na suung-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sarataa i Yesus nipotuo'i noko daa lapus, kasi notonginau' a murit-Na se' iya'a Ia poko bantilkonmo mbaripian. Mbaka' i raaya'a noparasayamo na upa men nitulis na Alkitaap ka' upa men ia bantilkonmo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na tempo i Yesus na Yerusalem, na ilio ramean Paska, biai' a mian men nosida parasaya na Ko'ona gause nimiile' upa kosamba' ka' sian dele men Ia wawau. ");
INSERT INTO blzNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kasee i Yesus sian mongooskon kaparasaya'anna mian na Ko'ona, gause Ia minginti'i a noana giigii' mian. ");
INSERT INTO blzNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ka' mian mosoo mompopo'inti'ikon na Ko'ona gau'na mian sambana, gause Ia minginti'i noana giigii' mian. ");
INSERT INTO blzNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Isian sa'angu' mian Farisi, ngaanna i Nikodemus. Ia tonsoop sa'angu' tanaasna agama Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Na sa'angu' rondom i Nikodemus notakamo ni Yesus ka' norobu taena, “Guru! Kai inti'i se' i Kuu guru men ia posuu' Alaata'ala. Gause sianta sa'angu'po mian men sida mangawawau upa kosamba' koi men Kuu wawau, kalu Alaata'ala sian muntulung i ia.” ");
INSERT INTO blzNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ia simbati i Yesus tae-Na, “Tuutuu' mba'a. See bantilkonon-Ku na ko'omuu se' sianta sa'angu'po mian men sida mimiile' Batomundo'anna Alaata'ala kalu i ia sian ngamea'konon soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Taena i Nikodemus, “Koi upa a kosidana mian men moola'mo se' daa sida ngamea'konon? Sida mbali' a mian mule'kon na kompongna sinana ka' ngamea'konon soosoodo?” ");
INSERT INTO blzNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ia simbati i Yesus tae-Na, “Tuutuu' sian sida, kasee bantilkonon-Ku na ko'omuu kalu mian sian ngamea'konon tia weer ka' Alus Molinas, ia sian sida minsoop na Batomundo'anna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mian ngamea'kononna mian, kasee kada' mantausi tutuo' u'uru, tiodaa ngamea'kononna Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Alia i koo samba' kalu Yaku' mangaan se' i kuu giigii' tiodaa ngamea'konon soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mombuul mimbusa mbaria a men pingkira'na, ka' i kita momorongor seaakna. Kasee i kita sian minginti'i mbariaasi a notakaanna ka' mbaria a rae'anna. Koiya'a uga' a mian men ngamea'kononna Alus Molinas.” ");
INSERT INTO blzNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ia pikirawar i Nikodemus taena, “Koi upa a kosidana men koiya'a?” ");
INSERT INTO blzNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Taeni Yesus, “Koo tamban guru na Israel, kasee kadai se' sian inti'ioon? ");
INSERT INTO blzNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' i kai tongko' muntundun upa men kai inti'i ka' mompopo'inti'ikon upa men kai piile', kasee i kuu giigii' sian mamarasaya upa men taemai. ");
INSERT INTO blzNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yaku' nuntundunkonmo i kuu upa-upa na dunia kani'i, kasee i kuu sian parasaya. Koi upa bo pamarasayamuu kalu Yaku' muntundunkon i kuu upa-upa men na surugaa? ");
INSERT INTO blzNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sianta sa'angu'po a mian men nomae' na surugaa saliwakon Anak Manusia men nalau nda'amari na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Koi i Musa na tano' maleas namasawe'kon ule tambaga na tokon, koiya'a uga' a Anak Manusia tio pasawe'konon, ");
INSERT INTO blzNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kada' giigii' mian men parasaya na Ko'ona mantausi tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gause Alaata'ala molingu'kon tuu' mian na tano' balaki' kani'i, mbaka' Ia nongorookonmo Anak-Na men sa'a-sa'angu', kada' giigii' mian men parasaya na Ko'ona sian silaka', kasee mantausi tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Alaata'ala nantatakakon Anak-Na na tano' balaki' kani'i taasi' bo pungukum mianna, kasee bo pansalamatkon. ");
INSERT INTO blzNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mian men parasaya na Anakna Alaata'ala sianta ukumon, kasee mian men sian parasaya ia ukummo Alaata'ala, gause ia sian parasaya na Anak-Na men sa'a-sa'angu'. ");
INSERT INTO blzNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ukuman iya'a koi kani'imari: Ruar iya'a noko takamo na tano' balaki', kasee mian tongko' mingkira'kon kapintungan, taasi'po ruar, gause wawauna i raaya'a ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sanda' mian men ba'idek a gau'na mongkokundai ruar. Ia kunda mae' na moruar, kada' wawauna men ba'idek sian kampiile'an. ");
INSERT INTO blzNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kasee mian men mangawawau upa men kana', ia taka na moruar kada' kampiile'an se' upa men ia wawau iya'a, sintutu' koi pingkira'na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Noko daa iya'a ai Yesus tia murit-Na nomae'mo na Yudea. Raaya'a nodumodongo inda'a toro pii ilio ka' nansarani mian. ");
INSERT INTO blzNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohanes nansarani mian na Ainon men sian oloa na Salim, gause na tampat iya'a daa biai' a weer. Ka' biai' a mian men taka na ko'ona miki sarani. ");
INSERT INTO blzNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tempo iya'a i Yohanes sianpo nisoopkon na tarungkuan. ");
INSERT INTO blzNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Toro pii murit ni Yohanes tia samba Yahudi nompoogagaikon aturan pongoloe'ian waka. ");
INSERT INTO blzNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Raaya'a nomae'mo ni Yohanes ka' nimikirawar taena, “Guru, dauga'na inau'onmuu a mian men mbaripian tii kuu na sambotakna Weerkauna Yordan, men kuu popo'inti'ikon na ko'omai? Ia uga' koini'i mansarani mian, ka' giigii' mian mae' na Ko'ona!” ");
INSERT INTO blzNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ia simbati i Yohanes taena, “Sianta sa'angu'po mian men sida mangala upa-upa bo ko'ona suungna, kalu sian rookononna Alaata'ala na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kuu uga' nomorongormo upa men taengku', ‘Yaku' taasi' Tomundo' Pansalamatkon. Yaku' tongko' niposuu' mongolukoni i Ia.’ ");
INSERT INTO blzNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Moro'one a pontombonoi wiwine men posuo'ionna. Lulusanna moro'one iya'a tongko' kumekerer na soripi'na moro'one ka' momorongori. Ka' lulusanna moro'one beles tuu' kalu momorongor wurungna moro'one iya'a. Koiya'a uga' i yaku' koi lulusanna moro'one iya'a. Koini'i yaku' beles tuu'. ");
INSERT INTO blzNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yesusmo a men tio angga'ion, kasee i yaku' sobiimo.” ");
INSERT INTO blzNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Taeni Yohanes, “Men notaka nda'amari surugaa mingilingkudui giigii'. Men ringkat na tano' balaki' kani'i mase mian na tano' balaki', ka' muntundunkon upa-upa men na tano' balaki'. Yesus men notaka nda'amari surugaa mingilingkudui giigii' upa. ");
INSERT INTO blzNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ia nompopo'inti'ikon upa men Ia piile' ka' Ia rongormo, kasee sianta sa'angu'po mian men mamarasaya upa men tae-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mian men mamarasaya upa men taeni Yesus iya'a mompotuutuu' se' Alaata'ala a men kana'. ");
INSERT INTO blzNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Gause mian men ia posuu' Alaata'ala iya'a nambantilkon wurungna Alaata'ala, gause Alaata'ala taasi' tongko' alu-alum nongorookon Alus-Na na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tama men na surugaa mongkolingu'kon Anak-Na ka' nongorookon giigii' kuasa na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mian men mamarasaya Anak iya'a bo mantausi tutuo' men pore pataka sidutu. Kasee mian men sian malolo' na Anak-Na iya'a sian mantausi tutuo' men pore, gause maso'na Alaata'ala dauga' isian na ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mian Farisi nomorongor se' mian men ia tausi i Yesus bo murit-Na ka' men Ia sarani a biai'na tia men ia sarani i Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ya'apo i Yesus sianta nansarani mian, tongko' murit-Na.) ");
INSERT INTO blzNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sarataa ia inti'i i Yesus se' mian Farisi nomorongormo se' koiya'a, Ia namarereimo Yudea ka' nomule'kon soosoodo na Galilea. ");
INSERT INTO blzNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yesus tio lumiu na Samaria mule'kon na Galilea. ");
INSERT INTO blzNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mbaka' notakamo i Ia na Sikhar, sa'angu' kota na Samaria. Sikhar iya'a sianta oloa na tano' men mbaripian ia rookon i Yakub boni Yusuf anakna. ");
INSERT INTO blzNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Inda'a isian lobong tambu'an ni Yakub. Yesus nopamalemo tuu' gause nogintano' oloa. Mbali' iya'a, Ia no'umoruangmo ka' nintimale na soripi'na lobong iya'a. Tempo iya'a toro jaam duabelaas tanga'iloa'. ");
INSERT INTO blzNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sian nanau' notakamo a sa'angu' wiwine samba Samaria mae' tumambu'. Yesus norobumo na wiwine iya'a tae-Na, “Sida i Yaku' mama'ase' minginum?” ");
INSERT INTO blzNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tempo iya'a i Yesus somo suusuungna gause murit-Na nomae'mo na kota mingili kakaan. ");
INSERT INTO blzNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Taena wiwine iya'a, “Tuan! Kuu samba Yahudi. Nongko'upa se' i Kuu mama'ase' minginum weer na ingku' wiwine na Samaria?” (Gause samba Yahudi sianta pooka'amat tia samba Samaria.) ");
INSERT INTO blzNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Taeni Yesus, “Kalu koo inti'i a upa men ia rookon Alaata'ala, ka' koo inti'i se' i ime a men mama'ase' minginum weer na ko'oom, sabole i koo mama'ase' minginum na Ko'ona, ka' i koo taraion-Na weer men mantatakon tutuo' men pore.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Taena wiwine iya'a, “Kuu Tuan sianta sasabuan, ka' lobong kani'i alalom tuu'. Mbaria a pantausian-Muu weer men mantatakon tutuo' men pore? ");
INSERT INTO blzNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yakub, pulimai, nongorookon lobong kani'i bo ko'omai. Ia mbaripian tia anakna tumambu' ka'ita, bo inumonna i raaya'a tia ayopna. Surion-Muu Tuan, se' i Kuu mbali' a balaki'na tii Yakub?” ");
INSERT INTO blzNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Taeni Yesus, “Mian men minginum weer kani'i bo moro'u soosoodo, ");
INSERT INTO blzNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kasee mian men minginum weer men rookonon-Ku, sianmo moro'u pataka sidutu. Gause weer men rookonon-Ku iya'a bo sida matana weer na lalomna wakana men umembuar mantarai tutuo' men pore pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Taena wiwine iya'a, “Tuan, taraimo i yaku' weer iya'a kada' i yaku' sianmo moro'u soosoodo, ka' kada' sianmo sakat ra'amari tumambu'.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Taeni Yesus, “Rae'mo, ka' leelo' a langkai'im ra'amari.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Taena wiwine iya'a, “Yaku' sian langkai'an.” Taeni Yesus, “Tuutuu' a upa men taeem, ");
INSERT INTO blzNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","gause i koo noko pirilima'mo nosuo' ka' moro'one men poototobo' tii koo koini'i taasi'po langkai'im.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Taena wiwine iya'a, “Ni'isi ka' yaku' inti'i se' i Kuu sa'angu' nabii. ");
INSERT INTO blzNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pulimai monsoosa' Alaata'ala na buu'na kani'i, kasee i kuu samba Yahudi nangaan se' tongko' na Yerusalem a ponsoosa'anna mian Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Taeni Yesus, “Parasayamo, bo taka a tempona se' mian bo monsoosa' Tama na surugaa taasi'mo tongko' na buu'na kani'i ka' uga' taasi'mo tongko' na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kuu lipu' Samaria monsoosa' upa men sian kuu inti'i, kasee i kai lipu' Yahudi monsoosa' i Ia men kai inti'i. Kai monsoosa' men kai inti'i iya'a gause kasalamatan men ia takakon Alaata'ala ringkat na lipu' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bo taka a tempona, ka' koini'i notakamo, se' mian bo monsoosa' Tama na surugaa koi men tuutuu'na ka' tia kuasana Alus Molinas. Ponsoosa' men koiya'a kikira'na Tama na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gause Alaata'ala iya'a Alus, mbaka' tongko' tia kuasana Alus Molinas a mian sida monsoosa' i Ia koi men tuutuu'na.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wiwine iya'a ninsimbatimo i Yesus taena, “Yaku' inti'i se' Tomundo' Pansalamatkon, men uga' ngaanon Kristus bo taka. Kalu i Ia takamo, Ia bo mambantilkon giigii' upa na ko'onta'.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Taeni Yesus, “Yaku'mo mba'a inono' men koini'i pintanga' batundun tii koo.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pintanga' i Yesus batundun tia wiwinena Samaria iya'a, notakamo a murit-Na. Raaya'a samba' nimiile' se' i Yesus batundun tia wiwine. Kasee sianta sa'angu'po i raaya'a men nimikirawar na wiwine iya'a, “Ibu, upa a panduungmuu?” kabai men nimikirawar ni Yesus, “Nongko'upa i Kuu se' batundun tia wiwine kanono'?” ");
INSERT INTO blzNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mbaka' wiwine iya'a namarereimo gumbangna indo'o, ka' notumetende' mae' na kota ka' nambantilkon na mian taena, ");
INSERT INTO blzNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mai piile' a mian kuaro'o men nambantilkon na ingku' giigii' men yaku' wawaumo. Too i Iamo a Tomundo' Pansalamatkon?” ");
INSERT INTO blzNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mbaka' i raaya'a namarereimo kota ka' nomae' ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pintanga' iya'a, Yesus ia taropimo murit-Na bo kumaan. Taena i raaya'a, “Guru, mai kumaanmo!” ");
INSERT INTO blzNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mbaka' ia simbati i Yesus tae-Na, “Yaku' daa isian kakaan kasee men sian inti'ionmuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mbaka' murit ni Yesus nopoopikirawarimo taena, “Isian mbali' mian sambana men nangawawa kakaan bo Ko'ona?” ");
INSERT INTO blzNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kasi i Yesus norobu tae-Na, “Kakaan-Ku mase mongololoikon pingkira'-Na men nomosuu' i Yaku', ka' mamakabus palimangon men Ia rookon bo limangon-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tempo i kuu mimiile' ale', kuu mangaan se' somo paat bitu'on mamadakmo. Kasee bantilkonon-Ku na ko'omuu: Alaka' piile' tiku-tikum! Giigii' ale' somo potosongi', noko toropotmo bo padakon! ");
INSERT INTO blzNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mian men mamadak noko pangalabotmo tambona, ka' nantambun ule' bona tutuo'na men pore pataka sidutu. Mbaka' mian men nangasok ka' mian men namadak koikoimo munsuri beles. ");
INSERT INTO blzNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Men koiya'a kana'mo tia timbaani' kani'imari: ‘Men sa'angu' mangasok, men sambana mamadak.’ ");
INSERT INTO blzNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yaku' nomosuu' i kuu mae' mamadak na ale' men taasi' i kuu a ningilimang. Mian sambana noko balimangmo inda'a, kasee i kuu mangala ule'na limangna i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Biai' a samba Samaria na kota iya'a men noparasaya ni Yesus, gause isian tundunanna wiwine iya'a men taena, “Ia nambantilkon na ingku' giigii' upa men yaku' wawaumo.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mbaka' sarataa samba Samaria nopootuung tii Yesus, raaya'a nama'ase'mo kada' i Ia sabole-bole dumodongo tii raaya'a. Mbaka' i Yesus notuukmo ruangilio na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tempo iya'a, nokanturanganmo biai' a mian men parasaya ni Yesus, gause upa men pisiso'konon-Na na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Raaya'a norobumo na wiwine iya'a taena, “Kai koini'i parasaya, taasi'mo tongko' upa men koo bantilkon na ko'omai, kasee daa kai rongormo a upa men tae-Na, ka' daa kai inti'imo se' tuutuu' Iamo a Pansalamatkon dunia.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sarataa i Yesus ruangiliomo na Sikhar, Ia nomule'konmo na Galilea. ");
INSERT INTO blzNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesus isian nangaan tae-Na, “Sa'angu' nabii sian angga'ion na dodongoanna suungna.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kasee tempo i Yesus taka na Galilea, mian biai' nangalabotimo i Ia tia noa ma'amat, gause i raaya'a uga' nimiile'mo giigii' men ia wawau i Yesus tempo pangaramekonan Paska na Yerusalem, ka' i raaya'a uga' isian na ramean iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mbaka' i Yesus nomule'konmo soosoodo na kota Kana men na Galilea, men mbaripian nangawawauan-Na weer nosida anggur. Tempo iya'a isian sa'angu' pagawena batomundo'an men anakna pintanga' manggeo na Kapernaum. ");
INSERT INTO blzNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sarataa i ia nomorongor se' i Yesus notakamo na Galilea ringkat na Yudea, ia nomae'mo na Ko'ona ka' nama'ase' kada' i Ia mae' na Kapernaum mengelesi'i anakna men sakaalmo. ");
INSERT INTO blzNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus norobumo na pagawena batomundo'an iya'a tae-Na, “Kalu i kuu sian mimiile' upa kosamba' men wawauon-Ku, kuu sian mamarasaya.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ia simbati pagawena batomundo'an iya'a taena, “Tumpu, indamo dongan, kada' takaionta a anakku sianpo lapus.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Taeni Yesus, “Rae', ule'konmo. Anaak palesi'mo.” Pagawe iya'a parasaya men taeni Yesus, kasi i ia nomae'. ");
INSERT INTO blzNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na tanga'na salan, toro pii mian men balimang na ko'ona nomootuungi i ia ka' nambantilkon na ko'ona taena, “Anakmuu daa palesi'mo.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kasi i ia nimikirawar na ko'ona i raaya'a se' jaam pipii a nuntumbeianna nalesi'. Ia simbati i raaya'a taena, “Rimberi'po toro jaam satu tanga'iloa', sianmo nosuminggar.” ");
INSERT INTO blzNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kasi tamana anak iya'a notonginau' se' toro jaam koiya'a a men nangaanan ni Yesus na ko'ona men tae-Na, “Anaak palesi'mo.” Mbaka' i ia tia giigii' poto'utusanna noparasayamo ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ya'amo a kopinduanna i Yesus nangawawau upa kosamba' na Galilea sarataa notaka ringkat na Yudea. ");
INSERT INTO blzNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Noko daa iya'a, isian rameanna lipu' Yahudi, mbaka' i Yesus nomae'mo na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na kota Yerusalem, karani' soopanna balana kota na tampat men ngaanion Soopanna Domba, isian sa'angu' kolam men na wurung Ibrani ngaanon Betesda. Na kolam iya'a isian lilima' palapalangkat. ");
INSERT INTO blzNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na giigii' palapalangkat iya'a biai' a mian poto tokol manggeo. Isian men mampisok, isian men pepa', ka' isian men repo'. Raaya'a mempeperai weer na kolam iya'a kolebu, ");
INSERT INTO blzNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","gause tempo-tempo isian malaa'ikatna Tumpu malau na kolam iya'a ka' mengelebu weerna. Mian manggeo men olukon malau na kolam iya'a tempo weerna kolebu, ia bo malesi' maune' nggeo men koi upa. ");
INSERT INTO blzNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na tampat iya'a isian sa'angu' moro'one men tolumpulo'mo ka' wawalu' taun a nanggeoanna. ");
INSERT INTO blzNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus nimiile' i ia toko-tokol inda'a, ka' ia inti'i i Yesus se' nanau'mo a nanggeoanna. Mbaka' Ia pikirawarimo tae-Na, “Koo mingkira' malesi'?” ");
INSERT INTO blzNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Taena mian men manggeo iya'a, “Tuan, sianta mian ka'ita bo pangawaaro'okon i yaku' na kolam kalu weerna kolebumo. Ka' baasi waaro'o i yaku' na kolam, mian sambana noko palaumo olukon.” ");
INSERT INTO blzNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mbaka' i Yesus norobumo na ko'ona tae-Na, “Wangonmo, nakat a ampaas ka' tumpang.” ");
INSERT INTO blzNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tempopo iya'a uga' nalesi'mo a mian iya'a. Mbaka' ia nakatmo a ampasna ka' notumumpang. Kasee iya'a nosida na ilio Sabat. ");
INSERT INTO blzNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mbali' iya'a moomoola'na Yahudi norobumo na mian men baasi nalesi' iya'a taena, “Koini'i ilio Sabat. Koo sian sida mamasa'an ampaas.” ");
INSERT INTO blzNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Taena mian men baasi nalesi' iya'a, “Mian men nengelesi'i i yaku' umba'a a men nomosuu' i yaku' manganakat ampasku ka' nomosuu' tumumpang.” ");
INSERT INTO blzNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Moomoola'na Yahudi nimikirawarmo taena i raaya'a, “Ime a mian men nomosuu' i koo manganakat ampaas ka' tumumpang?” ");
INSERT INTO blzNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kasee mian men baasi nalesi' iya'a sianmo ninginti'i mianna, gause i Yesus nintipenta'mo na mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kasee noko daa iya'a ai Yesus nopootuungmo mian men baasi nalesi'i iya'a na lalomna Laiganna Alaata'ala. Ia norobu na ko'ona tae-Na, “Koini'i i koo daa nalesi'mo. Aliamomo' mangawawau sala' soosoodo, dako' i koo munsuri men ba'idek tuu'.” ");
INSERT INTO blzNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mbaka' mian iya'a nomae'mo ka' nambantilkon moomoola'na Yahudi se' i Yesus a men nengelesi'i i ia. ");
INSERT INTO blzNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mbali' iya'a, moomoola'na Yahudi nanpari-pari mampapolosi i Yesus, gause i Ia nengelesi'imo mian na ilio Sabat. ");
INSERT INTO blzNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kasee i Yesus norobu na moomoola'na Yahudi iya'a tae-Na, “Tamang-Ku na surugaa dauga' balimang pataka koini'i, mbaka' Yaku' uga' tio balimang.” ");
INSERT INTO blzNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wurung men koiya'a ninsidakon moomoola'na Yahudi mampari-pari mampapatei i Yesus. Raaya'a nangawawau koiya'a taasi' tongko' montookon i Yesus nansala'kon ilio Sabat men taasi' koi aturanna agama, kasee uga' gause i Ia nangaan se' Alaata'ala iya'a Tama-Na. Kalu koiya'a, Ia momookokoikon waka-Na tia Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mbaka' i Yesus norobumo na moomoola'na Yahudi iya'a tae-Na, “Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' Anak sianta momoko mangawawau upa-upa tia kuasana suung-Na. Ia tongko' mangawawau upa men Ia piile' wawauonna Tama-Na. Gause upa men wawauonna Tama na surugaa, koiya'a uga' a wawauonna Anak-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tama na surugaa mongkolingu'kon Anak-Na ka' minsiso'kon na Ko'ona giigii' men wawauonna Tama na surugaa. Tama na surugaa uga' bo minsiso'kon na Ko'ona a wawau men balaki'na pataka i kuu samba'. ");
INSERT INTO blzNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Koi Tama na surugaa mangawangonkon mian lapus, ka' momotuo'i i raaya'a, koiya'a uga' a Anak-Na momotuo'i ka' mantarai tutuo' men pore pataka sidutu na mian men kikira'-Na taraion. ");
INSERT INTO blzNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tama na surugaa sianta mungukumi sa'angu'po mian. Giigii' kuasa-Na men bo pungukumi mian Ia rookonmo na Anak-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tama na surugaa mangawawau koiya'a, kada' giigii' mian mangangga'i Anak koi i raaya'a mangangga'i Tama na surugaa. Mian men sian mangangga'i Anak iya'a, uga' sian mangangga'i Tama na surugaa men nomosuu' Anak-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' mian men momorongori wurung-Ku ka' parasaya na Ko'ona men nomosuu' i Yaku', ia isianmo tutuo' men pore pataka sidutu. Ia sianmo ukumon. Ia namarereimo kolapusan, ka' nantausimo tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' bo taka a tempona, ka' koini'i uga' noko takamo, se' mian lapus bo momorongor wurungna Anakna Alaata'ala. Ka' mian men momorongor wurung iya'a bo tumuo' soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Koi Tama na surugaa pu'una tutuo' men pore, koiya'a uga' i Ia minsidakon Anak-Na bo pu'una tutuo' men pore. ");
INSERT INTO blzNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tama na surugaa nantaraimo i Ia kuasa bo pungukumi, gause i Ia Anak Manusia. ");
INSERT INTO blzNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Alia i kuu samba'kon momorongor men koiya'a, gause bo taka a tempona se' giigii' mian men nolapusmo bo momorongor wurungna Anak Manusia, ");
INSERT INTO blzNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ka' mian men pore a wawauna bo potuo'ion ka' umuar na baleananna ka' tumuo' pore pataka sidutu. Mian men ba'idek a gau'na uga' bo potuo'ion ka' umuar na baleanan, kasee bo ukumon. ");
INSERT INTO blzNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yaku' sian sida mangawawau upa-upa men tongko' pingkira'-Ku suung-Ku. Yaku' mungukumi mian koi men Yaku' rongor na Tama na surugaa. Ka' men pungukuming-Ku iya'a maloos, gause i Yaku' sian mongololoikon koi pingkira'-Ku suung-Ku, kasee koi pingkira'na Tama na surugaa men nomosuu' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kalu tongko' suung-Ku a men muntundunkon wakang-Ku, tundunan men koiya'a sida uga' sian parasayaonmuu. ");
INSERT INTO blzNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kasee isian mian men mompotuutuu' i Yaku', ka' Yaku' inti'i se' tundunanna iya'a tuutuu'. ");
INSERT INTO blzNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kuu nomosuu' mian mae' ni Yohanes, ka' i ia nompotuutuu' men kana'. ");
INSERT INTO blzNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yaku' nangaan men koiya'a taasi' se' kada' i Yaku' potuutuu'onna mian, kasee kada' i kuu salamatkonon. ");
INSERT INTO blzNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanes iya'a koi boloak men kait ka' munguruari, see i kuu tongko' kodi-kodi' lewa'kon ruar iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kasee men potuutuu'on-Ku a balaki'na tia men ia potuutuu' i Yohanes. Giigii' limang men Ia rookon Tama na surugaa na Ingku' kada' limangon-Ku, men koiya'a mompopo'inti'ikon se' Tama na surugaa a men nomosuu' i Yaku'. Palimangon iya'a uga' a men limangon-Ku koini'i. ");
INSERT INTO blzNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ka' Tama na surugaa men nomosuu' i Yaku' uga' mompotuutuu' i Yaku'. Kuu sianpo nontoo rongor wurung-Na ka' uga' sianpo nontoo piile' dudus-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Wurung-Na sian kuu naa' na noamuu gause i kuu sian parasaya na Ingku' men Ia posuu'. ");
INSERT INTO blzNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kuu mansarak minginti'i isiina Alkitaap gause pansaruimuu kalu i kuu minginti'imo isiina, kuu mantausi tutuo' men pore pataka sidutu. Alkitaap iya'a uga' mompotuutuu' i Yaku', ");
INSERT INTO blzNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","kasee i kuu bude' taka na Ingku' kada' mantausi tutuo' men pore pataka sidutu iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yaku' sian moki angga'i na mian. ");
INSERT INTO blzNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kasee i kuu, inti'ion-Ku se' noamuu sian mongkolingu'kon Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yaku' taka tia kuasana Tamang-Ku na surugaa, kasee i kuu sian mangalabot i Yaku'. Kasee kalu isian mian sambanaan taka tia kuasana suungna, mian iya'a labotionmuu. ");
INSERT INTO blzNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Koi upa a bo pamarasayamuu i Yaku' kalu i kuu tongko' mansarak kada' angga'ionna simbaya'muu, ka' taasi' mansarak angga'ionna Alaata'ala men sa'a-sa'angu'? ");
INSERT INTO blzNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Alia i kuu mansarui se' i Yaku' bo mompoposala' i kuu na aropna Tama na surugaa. Kasee men bo mompoposala' i kuu mase i Musa men ooskononmuu. ");
INSERT INTO blzNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kalu i kuu mamarasaya i Musa, kuu sabole mamarasaya i Yaku', gause i ia isian nuntulis i Yaku' na kitapna. ");
INSERT INTO blzNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kasee ka' i kuu sian mamarasaya upa men ia tulis i Musa, mbaka' i kuu uga' sian mamarasaya upa men taeng-Ku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Noko daa iya'a ai Yesus nomae'mo na sambotakna Danau Galilea, men uga' ngaanon Danau Tiberias. ");
INSERT INTO blzNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Biai' a mian bero-beros mongololo' i Ia, gause i raaya'a nimiile'mo upa kosamba' men Ia wawau tempo nengelesi'i mian men manggeo. ");
INSERT INTO blzNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kasi i Yesus nolumopon mbaara'a buu'na ka' no'umoruang tia murit-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na tempo iya'a, karani'mo a ilio ramean Paska na samba Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sarataa i Yesus nimiile' na tiku-tikum-Na se' biai' tuu' a mian taka na Ko'ona, Ia norobumo ni Filipus tae-Na, “Mbaria a pingilianta kakaan kada' pamakaanta mian karaani'i?” ");
INSERT INTO blzNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesus ninginti'i upa men bo wawauon-Na, kasee Ia norobu koiya'a gause mansarak minginti'i noa ni Filipus.) ");
INSERT INTO blzNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ia simbati i Filipus taena, “Kakaan men tongko' ilion tia rua' atu doi' dinar sianpo sanda' bona mian karaani'i, maupo tongko' toro tiu'an.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sa'angu' murit ni Yesus men i Andreas, utus ni Simon Petrus, norobumo na Ko'ona taena, ");
INSERT INTO blzNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kani'i isian sa'angu' anak moro'one men isian roti jelai lilima' ka' susum rurua'. Kasee daa sukup mbali' bona mian men koi kani'i a kobiai'na?” ");
INSERT INTO blzNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Taeni Yesus, “Posuu'mo a mian karaanono' umoruang.” Na tampat iya'a biai' a rakut, mbaka' i raaya'a no'umoruangmo na rakut. Kobiai'na mian iya'a toro lima' loloon moro'one. ");
INSERT INTO blzNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kasi i Yesus nangala roti iya'a, ka' nobasukuur na Alaata'ala. Sarataa iya'a, Ia nongobo-obosmo roti iya'a na mian biai' men poto oruang indo'o. Koiya'a uga' na susum iya'a. Ka' i raaya'a nokumaan pataka benteng. ");
INSERT INTO blzNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sarataa i raaya'a wiwi'na nobentengmo, Yesus norobumo na murit-Na tae-Na, “Posa'angu' a labina. Alia isian men tontako'.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mbaka' i raaya'a nungururu'mo labina lilima' roti jelai iya'a men ia kaan i raaya'a, ka' labina dauga' nobuke' sompulo' rua' basung. ");
INSERT INTO blzNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sarataa mian biai' nimiile' upa kosamba' men ia wawau i Yesus, raaya'a norobumo taena, “Tuutuu', kani'imo a nabii men bo taka na tano' balaki'!” ");
INSERT INTO blzNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Gause i Yesus ninginti'i se' i raaya'a bo taka ka' mamakisaa mangawawa i Ia bo sidakonon tomundo', mbaka' Ia nintirensamo suung-Na ka' nomae' na buu'na men sambana. ");
INSERT INTO blzNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sarataa guntumalommo, murit ni Yesus nalaumo na danau. Raaya'a nolumakitmo na duangan, ");
INSERT INTO blzNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kasi nengelembeti danau iya'a mae' na Kapernaum. Tempo iya'a ilio noko pintungmo, kasee i Yesus koo'po notaka na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tempo iya'a danau kaekae' mabokol gause mombuulon makorong. ");
INSERT INTO blzNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sarataa i raaya'a nobabose toro lima' kabai noom kilometer a ko'oloana, raaya'a nimiile'mo i Yesus tumpa-tumpang na wawona weer mangkarani' duangan. Raaya'a nolayaonmo. ");
INSERT INTO blzNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kasee i Yesus norobu na ko'ona tae-Na, “Yaku' ini'i. Alia layaon!” ");
INSERT INTO blzNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kasi tia noa beles, raaya'a nangalabotimo i Yesus na lalomna duangan, ka' tempo iya'a uga' duanganna nokambotmo na bone, na tampat men rae'ionna. ");
INSERT INTO blzNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Koi liilana mian biai' men dauga' na sambotakna danau, nimiile' se' duangan men somo sa'angu' iya'a sianmo intu'u. Ia inti'i i raaya'a se' murit ni Yesus nomae'mo na duangan iya'a, kasee i Yesus sian nolumolo'. ");
INSERT INTO blzNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tempo iya'a isian toro pii duangan men ringkat na kota Tiberias notaka ka' nobalabu karani' tampat men nangkaananna mian biai' roti noko daa ia sukuurkon i Tumpu Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sarataa mian biai' iya'a nimiile' se' sian isian i Yesus tia murit-Na, raaya'a nolumakitmo na duangan men baasi nobalabu iya'a ka' norumingkat mae' na Kapernaum mansarak i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sarataa mian biai' nopootuung tii Yesus na sambotakna danau, raaya'a nimikirawar taena, “Guru, mbaripi a notakaan-Muu ka'ita?” ");
INSERT INTO blzNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ia simbati i Yesus tae-Na, “Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' i kuu mansarak i Yaku' taasi' se' daa i kuu ninginti'imo aratina upa kosamba' men Yaku' wawaumo, kasee tongko' se' daa i kuu nangkaanmo roti pataka nobenteng. ");
INSERT INTO blzNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kuu balimang alia tongko' mansarak kakaan men bo kabus ka' bo mobosi'. Kasee alaka' balimang mansarak men sian mobosi' ka' men daa mantarai tutuo' men pore pataka sidutu. Kakaan iya'a bo rookononna Anak Manusia na ko'omuu, gause Anak Manusia a men ia potuutuu' Alaata'ala tia oos-Na.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kasi taena i raaya'a, “Upa a men bo wawauonmai kada' men wawauonmai iya'a koi kikira'na Alaata'ala?” ");
INSERT INTO blzNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Taeni Yesus, “Koi kani'imari a men kikira'na Alaata'ala: kuu tio parasaya na Ko'ona men ia posuu' Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mbaka' taena i raaya'a, “Upa a men bo wawauon-Muu men sida pongoosanmai, kada' daa piile'onmai ka' parasayaonmai i Kuu? Upa a men limangon-Muu? ");
INSERT INTO blzNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pulimai mbaripian nangkaan roti manna na tano' maleas, koi men nitulis na Alkitaap taena, ‘Ia namakaan i raaya'a tia roti men nda'amari na surugaa.’ ” ");
INSERT INTO blzNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kasi taeni Yesus, “Tuutuu' mba'a, kasee bantilkonon-Ku na ko'omuu se' taasi' i Musa a men nantarai i kuu roti nda'amari surugaa, kasee Tamang-Ku. Ka' koini'i Tamang-Ku a mantarai i kuu roti men tuutuu'na nda'amari surugaa. ");
INSERT INTO blzNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gause roti men na Alaata'ala, mase i Ia men nda'amari surugaa men mantarai tutuo' men pore pataka sidutu bona mian na tano' balaki'.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Taena i raaya'a, “Tuan, tarai i kai a roti sanda' ilio koi men tae-Muu.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Taeni Yesus, “Yaku'mo a roti men mantarai tutuo' men pore pataka sidutu. Mian men taka na Ingku' sianmo bo mololu pataka sidutu. Ka' mian men parasaya na Ingku' sianmo bo moro'u pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kasee koi men Yaku' bantilkonmo na ko'omuu, maune' i kuu nimiile'mo i Yaku', kuu sian mamarasaya. ");
INSERT INTO blzNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Giigii' mian men ia rookon Tamang-Ku na Ingku' bo taka na Ingku', ka' mian men taka na Ingku' sian kokundaion-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gause i Yaku' nda'amari surugaa taasi' bo pangawawau upa men koi pingkira'-Ku suung-Ku, kasee koi pingkira'-Na men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ka' koi kani'imari a pingkira'-Na men nomosuu' i Yaku': amo' sa'angu'po a men malalap na giigii' mian men Ia rookon na Ingku', kasee kada' potuo'ion-Ku na ilio kokomburi'anna. ");
INSERT INTO blzNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gause ni'imo a pingkira'na Tamang-Ku: Kada' giigii' mian men nimiile' Anak ka' parasaya na Ko'ona bo mandapot tutuo' men pore pataka sidutu, ka' potuo'ion-Ku na ilio kokomburi'anna.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mbaka' samba Yahudi nokokoo'ankonmo i Yesus gause Ia norobu tae-Na, “Yaku'mo a roti men nda'amari surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Raaya'a norobu taena, “Taasi' uga' i Yesus kani'i a men anak ni Yusuf? Inti'ionmai a sina-Na tia tama-Na! Koi upa mbali' se' i Ia sida mangaan se' i Ia nda'amari surugaa?” ");
INSERT INTO blzNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kasi taeni Yesus, “Alia kokoo'ankon i Yaku'! ");
INSERT INTO blzNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sianta sa'angu'po mian men sida taka na Ingku', kalu Tama men nomosuu' i Yaku' sian nambaetok noana kada' taka na Ingku'. Ka' ime a men taka na Ingku' bo potuo'ion-Ku na ilio kokomburi'anna. ");
INSERT INTO blzNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na kitapna nabii isian nitulis koi kani'imari: ‘Giigii' mian bo pisiso'onna Alaata'ala.’ Mbaka' giigii' mian men nomorongormo ka' nangalabot pisiso'na Tama na surugaa, bo taka na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Men koiya'a, taasi' se' daa isianmo mian men nimiile'mo Tama. Men daa nimiile'mo Tama na surugaa tongko' i Ia men ia posuu' Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' mian men parasaya, ia mandapot tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yaku'mo a roti men mantarai tutuo' pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pulimuu nangkaanmo roti manna na tano' maleas ka' i raaya'a nolapusmo. ");
INSERT INTO blzNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kasee roti men nda'amari surugaa taasi'po koiya'a. Mian men mangkaan roti iya'a sianmo lapus. ");
INSERT INTO blzNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yaku'mo a roti nda'amari surugaa men mantarai tutuo' men pore pataka sidutu. Mian men mangkaan roti kani'i, ia bo tumuo' pataka sidutu. Roti men rookonon-Ku bona mian na tano' balaki' kada' tumuo' mase antok-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nomorongor men koiya'a, samba Yahudi nopoogagaimo tia simbaya'na ka' norobu taena, “Koi upa mbali' a mian kanooro'o se' daa mongorookon antok-Na bo kaanonta?” ");
INSERT INTO blzNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kasi taeni Yesus, “Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu kalu i kuu sian mangkaan antokna Anak Manusia ka' minginum rara'-Na, kuu sian mantausi tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mian men mangkaan antok-Ku ka' minginum rara'-Ku bo mantausi tutuo' men pore pataka sidutu ka' bo potuo'ion-Ku na ilio kokomburi'anna. ");
INSERT INTO blzNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gause antok-Ku tuutuu' kakaan, ka' rara'-Ku tuutuu' bo inumon. ");
INSERT INTO blzNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mian men mangkaan antok-Ku ka' minginum rara'-Ku, ia poowawa pore tii Yaku' ka' Yaku' poowawa pore tii ia. ");
INSERT INTO blzNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tama na surugaa men tumuo' nomosuu' i Yaku' ka' i Yaku' tumuo' gause Tama na surugaa. Koiya'a uga' mian men mangkaan antok-Ku bo tumuo' gause i Yaku' a men momotuo'i. ");
INSERT INTO blzNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yaku'mo a roti men nda'amari surugaa. Roti iya'a taasi' koi roti men ia kaan pulimuu. Gause soro' nangkaan roti iya'a, raaya'a uga' nolapus. Kasee mian men mangkaan roti men nda'amari surugaa, ia bo tumuo' pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Giigii' iya'a ia bantilkon i Yesus na Kapernaum, na tempo i Ia mimisiso' na laigan bakitumpuan. ");
INSERT INTO blzNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sarataa nongorongor wurung ni Yesus, biai' a murit-Na men norobu taena, “Pisiso' kani'i marepa tuu'. Ime a men daa momoko mongololo'?” ");
INSERT INTO blzNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesus ninginti'i se' murit-Na nokokoo'ankon i Ia men nangaan koiya'a. Mbaka' Ia norobumo tae-Na, “Kokoo'muu mbali' a wurung-Ku men koiya'a? ");
INSERT INTO blzNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ka' koi upa kalu i kuu mimiile' Anak Manusia masawe' soosoodo na dodongoan-Na men mbaripian? ");
INSERT INTO blzNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Alus Molinas a men mantarai mian tutuo' pore pataka sidutu, taasi' wakana mian. Wurung men bantilkonon-Ku kani'i, mase wurungna Alus Molinas men mantarai tutuo' pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kasee isian i kuu men sian parasaya.” (Yesus ninginti'i na tumbenapo, se' ime a men sian parasaya ka' ime a men bo mongorookon i Ia kada' papateion.) ");
INSERT INTO blzNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kasi i Yesus norobu soosoodo tae-Na, “Ya'amo mbali' i Yaku' nambantilkon na ko'omuu se' sianta sa'angu'po mian men taka na Ingku', kalu Tama na surugaa sianta minsidakon men koiya'a.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Muntumbei tempo iya'a biai' a murit ni Yesus men namarerei i Ia ka' nokundamo nongololo' i Ia soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mbaka' i Yesus norobumo na sompulo' rua' murit-Na tae-Na, “Too i kuu uga' bo mamarerei i Yaku'?” ");
INSERT INTO blzNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ia simbati i Simon Petrus taena, “Tumpu, ime a bo rae'anmai? Wurungmuu Tumpu mantarai tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kai parasayamo ka' kai inti'imo se' i Kuu a men molinas men ringkat na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ia simbati i Yesus tae-Na, “Taasi' uga' i Yaku' a men nungururuki sompulo' rua' kuu kani'i? Kasee isian i kuu men kani'i sa'angu' mian koi ibiliis!” ");
INSERT INTO blzNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Men panduungion ni Yesus mase i Yudas anak ni Simon Iskariot. Maune' i Yudas sa'angu' mian men tonsoop murit ni Yesus, kasee ia bo mongorookon i Yesus kada' papateion. ");
INSERT INTO blzNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Noko daa iya'a ai Yesus nomae'mo longkop Galilea. Ia kunda dumodongo na Yudea, gause isian moomoola'na Yahudi momoosarak bo mampapatei i Ia. ");
INSERT INTO blzNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tempo iya'a karani'mo rameanna samba Yahudi men ngaanon ramean Sa'up Roon. ");
INSERT INTO blzNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mbaka' utus ni Yesus norobumo na Ko'ona taena, “Ringkatmo i Koo mae' na Yudea, kada' muriit sida uga' mimiile' upa men wawauoon. ");
INSERT INTO blzNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Gause sianta sa'angu'po mian men mansapitkon mangawawau upa-upa, kalu ia mingkira' tolele na mian biai'. Kalu i Koo mangawawau upa-upa tiodaa pipiile'konoon na mian na tano' balaki'.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Mbali' utus-Na mangaan koiya'a gause raaya'apo uga' sian parasaya na Ko'ona.) ");
INSERT INTO blzNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ia simbati i Yesus tae-Na, “Koini'i koo'po tempong-Ku, kasee i kuu daa sinampang tempoan. ");
INSERT INTO blzNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dunia kani'i sian mangka'idek i kuu, kasee mangka'idek i Yaku', montookon i Yaku' nompopo'inti'ikon se' wawauna dunia kani'i ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Rae'mo i kuu na ramean iya'a! Yaku' sianpo mae', gause koini'i koo'po tempong-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Koiya'a ninsimbati ni Yesus i raaya'a, ka' i Ia dauga' na Galilea. ");
INSERT INTO blzNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sarataa utus ni Yesus nomae' na ramean iya'a, Ia uga' nomae'mo kasee wuni-wuni ka' sianta paraa nintipiile' na mian. ");
INSERT INTO blzNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na ramean iya'a moomoola'na Yahudi nansarak i Yesus. Raaya'a nimikirawar na mian, taena, “Aana i Ia?” ");
INSERT INTO blzNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ka' biai' a mian pooseasoi muntundun i Ia. Isian mian men mangaan: “Ia mian ma'amat.” Isian uga' men mangaan: “Sian, Ia mantarai pisiso' sala' na mian biai'.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kasee sianta sa'angu'po mian men morobu rongor-rongor moomoola'na Yahudi gause layaonkon i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pintanga' ramean iya'a, Yesus ninsoopmo na Laiganna Alaata'ala ka' nimisiso' mian. ");
INSERT INTO blzNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mbaka' moomoola'na Yahudi nosamba'mo ka' norobu taena i raya'a, “Koi upa a mian kaya'a se' biai' a inti'ion-Na, kasee sianta nosikola?” ");
INSERT INTO blzNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ia simbati i Yesus tae-Na, “Pisiso'-Ku taasi' norumingkat na Ingku', kasee na Ko'ona men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mian men mingilimang pingkira'na Alaata'ala, sabole bo minginti'i se' pisiso'-Ku norumingkat na Alaata'ala kabai se' tongko' na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mian men muntundun wakana, ia mansarak kada' angga'ionna mian. Kasee mian men mansarak mangangga'i Alaata'ala men nomosuu' i ia, mian iya'a kana' a wawauna, ka' sian borek. ");
INSERT INTO blzNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Taasi' uga' i Musa a men nantarai i kuu Ukum Torat? Kasee sianta sa'angu'po i kuu men mongololoikon Ukum Torat iya'a. Nongko'upa se' i kuu momoosarak mampapatei i Yaku'?” ");
INSERT INTO blzNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Taena i raaya'a taena, “Koo ia lampingi meena! Ime mbali' a men momoosarak ka' mampapatei i Koo?” ");
INSERT INTO blzNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Taeni Yesus, “Tongko' sa'angu' palimangon a men Yaku' wawau na ilio Sabat, kuu noko kokoo'anmo. ");
INSERT INTO blzNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa nambantilkonmo kada' i kuu tio basunat. Bookoi sunat kani'i taasi' ia tadulkon i Musa, kasee ia tadulkon pulinta. Ka' i kuu uga' munsunat mian na ilio Sabat! ");
INSERT INTO blzNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kalu i kuu munsunat mian na ilio Sabat dako' munguluani ukum ni Musa, kadai se' i kuu maso'kon i Yaku' montookon nengelesi'i mian na ilio Sabat? ");
INSERT INTO blzNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Alia mungukumi mian tongko' mongololo'kon upa men kampiile'an, kasee ukumi koi men tuutuu'na.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Toro pii samba Yerusalem norobu taena i raaya'a, “Taasi' Iamo kani'i a men sarakon bo papateion? ");
INSERT INTO blzNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ka' piile'! Ia sian bata-bata morobu na aropna mian biai' ka' sianta upa-upa men ia ngaan i raaya'a na Ko'ona. Kabai tanaasta ninginti'imo se' Iamo a Tomundo' Pansalamatkon? ");
INSERT INTO blzNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mian iya'a kita inti'imo a noringkatan-Na, kasee kalu Tomundo' Pansalamatkon taka sianta sa'angu'po a mian minginti'i se' mbaria a noringkatan-Na.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tempo i Yesus mimisiso' na Laiganna Alaata'ala, Ia nengeleelo'kon tae-Na, “Tuutuu' mba'a inti'ionmuu se' ime i Yaku' ka' mbaria a noringkatan-Ku. Kada' inti'ionmuu, Yaku' notaka taasi' tongko' pingkira'-Ku, kasee pingkira'na Alaata'ala. Ia Alaata'ala men tuutuu' ka' i Ia a nomosuu' i Yaku'. Kasee i kuu sianta minginti'i i Ia. ");
INSERT INTO blzNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yaku' ninginti'i i Ia, gause i Yaku' ringkat na Ko'ona ka' Iamo a men nomosuu' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Raaya'a momoosarak mangarakop i Yesus, kasee sianta sa'angu'po a mian men nongkoyong i Ia, gause tempona koo'po taka. ");
INSERT INTO blzNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kasee na mian biai' iya'a, isian uga' biai' a men noparasaya na Ko'ona ka' norobu taena, “Mian kanooro'o sabole i Tomundo' Pansalamatkon gause biai' tuu' a upa kosamba' men Ia wawaumo.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mian Farisi nomorongor se' biai' a mian momooseasoikon i Yesus, mbaka' i raaya'a tia tanaasna imam nomosuu'mo dadagai Laiganna Alaata'ala mangarakop i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mbaka' i Yesus norobumo na mian biai' men isian na lalomna Laiganna Alaata'ala tae-Na, “Somo kodi-kodi' i Yaku' dauga'na ruru-ruru' tii kuu ka' moko daa iya'a i Yaku' bo mae' na Ko'ona men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kuu bo mansarak i Yaku', kasee sian rumpakionmuu, gause i kuu sian momoko mantaka dodongoan-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kasi moomoola'na Yahudi nopoopikirawari, taena, “Mbaria a rae'an-Na, mbali' se' sian rumpakionta? Kabai i Ia bo mae' na samba Yahudi men na laosalaan, na tanga-tanga'na samba Yunani, bo pimisiso' i raaya'a? ");
INSERT INTO blzNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Upa aratina wurung-Na kani'i: Kuu bo mansarak i Yaku', kasee sian rumpakionmuu, ka' i kuu uga' sian momoko mantaka dodongoan-Ku?” ");
INSERT INTO blzNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na ilio men kokomburi'anna ramean Sa'up Roon, iliona ramean men tuko, nokumekerermo i Yesus na Laiganna Alaata'ala ka' nengeleelo'kon tae-Na, “Mian men moro'u, porena i ia taka na Ingku' ka' minginum! ");
INSERT INTO blzNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mian men parasaya na Ingku', ia koi men nitulis na Alkitaap taena, ‘Na noana bo umembuar a weer men mantarai tutuo' men pore pataka sidutu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesus muntundun Alus Molinas men bo labotonna mian men parasaya na Ko'ona. Tempo iya'a Alus Molinas koo'po notaka, gause i Yesus koo'po notonakat mbaara'a na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Biai' a mian nomorongor upa men ia tundun i Yesus. Ka' na mian biai' iya'a isian men norobu taena, “Mian kaya'a sabole nabii men bo taka.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mian sambana uga' norobu taena, “Ia kani'i Tomundo' Pansalamatkon.” Kasee men sambana uga' norobu taena, “Taasi'. Tomundo' Pansalamatkon taasi' ringkat na Galilea! ");
INSERT INTO blzNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gause isian nitulis na Alkitaap se' i Tomundo' Pansalamatkon iya'a lee' ni Daud ka' ringkat na kampung Betlehem, dodongoan ni Daud mbaripian.” ");
INSERT INTO blzNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mbaka' mian biai' nompoogagaikonmo se' ime i Yesus too i Ia Tomundo' Pansalamatkon kabai taasi'. ");
INSERT INTO blzNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Isian men mingkira' mangarakop i Ia, kasee sianta sa'angu'po mian men nongkoyong i Ia. ");
INSERT INTO blzNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sarataa nomule'kon a dadagai Laiganna Alaata'ala men niposuu' mangarakop i Yesus, tanaasna imam tia mian Farisi iya'a nobapikirawarmo na ko'ona i raaya'a taena, “Nongko'upa i kuu se' sianta nangawawa i Ia?” ");
INSERT INTO blzNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ia simbati dadagai iya'a taena, “Koo'po isian mian men morobu koi i Ia!” ");
INSERT INTO blzNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Taena mian Farisi, “Kabai i kuu tinompololo'mo na pisiso'-Na men sala'? ");
INSERT INTO blzNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Isian mbali' a tanaasta kabai se' sa'angu'po mian na mian Farisi men mamarasaya i Ia? ");
INSERT INTO blzNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kasee mian biai' karaani'i men sian minginti'i Ukum Torat, bi silaka' i raaya'a!” ");
INSERT INTO blzNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus, sa'angu' mian Farisi men mbaripian isian notaka ni Yesus, norobu na simbaya'na taena, ");
INSERT INTO blzNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ukum Toratta mbali' se' mungukum mian, kalu koo'po tia nirongor ka' ni'inti'i se' upa men ia wawau?” ");
INSERT INTO blzNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ia simbati i raaya'a taena, “Kabai i koo uga' samba Galilea? Alaka' piile' na Alkitaap kada' inti'ioon se' sianta nabii men ringkat na Galilea.” 7:53-8:11  ");
INSERT INTO blzNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kasi i raaya'a nompoo'ule'kon na laiganna, ");
INSERT INTO blzNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","kasee i Yesus nomae'mo na Buu'na Zaitun. ");
INSERT INTO blzNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma'ulo-ulop tuu' i Yesus ndo'omo soosoodo na Laiganna Alaata'ala, ka' biai' a mian men taka na Ko'ona. Ka' i Ia no'umoruang mimisiso' i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mbaka' wawa Ukum Torat tia mian Farisi nangawawamo na Ko'ona sa'angu' wiwine men nirumpaki nuntumpangkon langkai'na. ");
INSERT INTO blzNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Raaya'a nomokerermo wiwine iya'a na tanga' ka' norobu ni Yesus, taena, “Guru, wiwine kani'i nirumpaki pintanga' muntumpangkon langkai'na. ");
INSERT INTO blzNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na Ukum Torat ni Musa ia nomosuu' i kita mangalapak wiwine men koiya'a pataka lapus. Koi upa a pinginti'i-Muu men koiya'a?” ");
INSERT INTO blzNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Raaya'a mangaan men koiya'a bo mimitopongi i Ia, kada' i raaya'a mantausi sala'-Na. Kasee i Yesus nodumodungku' kasi nobatulis na tano' tia rangkum-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Gause i raaya'a sapiki-pirawar na Ko'ona, mbaka' Ia nokumekerermo kasi norobu tae-Na, “Kuu men sianta dosaon, tio i kuu a men mongolukoni mangalapak wiwine kaya'a tia watu.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kasi i Ia nodumodungku' soosoodo ka' nobatulis na tano'. ");
INSERT INTO blzNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kasee sarataa i raaya'a nomorongor wurung iya'a, raaya'a nomae'mo sa'angu'-sa'angu', muntumbei na mian men motu'a. Komburi'na somo i Yesus suungna tia wiwine iya'a men dauga' isian na tampat iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kasi i Yesus nokumekerer ka' norobu na wiwine iya'a tae-Na, “Aanamo i raaya'a? Sianta mian men nungukum i koo?” ");
INSERT INTO blzNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Taena wiwine iya'a, “Sianta, Tumpu.” Kasi taeni Yesus, “Yaku' uga' sian mungukum i koo. Rae'mo, ka' muntumbei koini'i aliamomo' mangawawau dosa.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesus norobumo soosoodo na mian biai' iya'a tae-Na, “Yaku'mo a ruarna dunia. Kalu i ime a mongololo' i Yaku' ia sian mae' na kapintungan, kasee ia isian ruar men mantarai tutuo' men pore pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Taena mian Farisi, “Koo a men mompotuutuu' wakaam. Tundunaan sian tuutuu'.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Taeni Yesus, “Maune' Yaku' mompotuutuu' wakang-Ku, kasee tundunan-Ku tuutuu', gause Yaku' ninginti'i mbaria a noringkatan-Ku ka' mbaria a rae'an-Ku. Kasee i kuu sian ninginti'i se' mbaria a ringkatan-Ku ka' mbaria a rae'an-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kuu mungukumi mongololo' sukatan na mian, Yaku' sian mungukumi sa'angu'po mian. ");
INSERT INTO blzNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kasee kalu i Yaku' mungukumi, mbaka' pungukuming-Ku iya'a tuutuu', gause i Yaku' taasi' tongko' suung-Ku, kasee Yaku' poopoololo' tii Ia men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ka' na kitap Toratmuu isian nitulis koi kani'imari: tundunan men porongorionna mian mase tio men potuutuu'onna rua' mian. ");
INSERT INTO blzNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yaku' a men mompotuutuu' wakang-Ku, ka' uga' Tamang-Ku men nomosuu' i Yaku' a mompotuutuu' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mbaka' taena i raaya'a, “Aana mbali' a Tamaam?” Ia simbati i Yesus tae-Na, “Yaku', maupo Tamang-Ku sian inti'ionmuu. Kalu se' i kuu minginti'i i Yaku', kuu uga' minginti'i Tamang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Giigii' iya'a ia bantilkon i Yesus beebeel petina doi' kurbaan na tempo i Ia pintanga' mimisiso' mian na Laiganna Alaata'ala. Ka' sianta sa'angu'po mian men nangarakop i Ia, gause sianpo tempona. ");
INSERT INTO blzNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus norobumo soosoodo na mian biai' tae-Na, “Yaku' bo mae' ka' i kuu bo mansarak i Yaku', kasee i kuu bo lapus dauga' dosaon. Dodongoan men rae'an-Ku sian takaonmuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mbaka' moomoola'na Yahudi norobumo taena, “Too i Ia bo mintipate mbali' se' i Ia nangaan: ‘Dodongoan men rae'an-Ku, sian takaonmuu?’ ” ");
INSERT INTO blzNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kasi i Yesus norobu tae-Na, “Kuu ndo'omari, kasee i Yaku' nda'amari. Kuu ringkat na dunia, kasee noringkatan-Ku taasi' na dunia. ");
INSERT INTO blzNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gause iya'a, mbali' i Yaku' nambantilkon na ko'omuu umba'a se' i kuu bo lapus gause dosamuu. Kalu i kuu sian mamarasaya se' i Yaku'mo inono' men ngaanon YAKU' ISIAN, kuu bo lapus dauga' dosaon.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mbaka' i raaya'a nimikirawarmo na Ko'ona taena, “Ime mbali' i Koo?” Taeni Yesus, “Upa a kana'na i Yaku' morobu soosoodo tii kuu? ");
INSERT INTO blzNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dauga' biai' a men tio bantilkonon-Ku ka' ukumikonon-Ku i kuu. Kasee Yaku' tongko' mambantilkon na dunia upa men Yaku' rongor na Ko'ona men nomosuu' i Yaku', ka' i Ia Alaata'ala men tuutuu'.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Raaya'a sian ninginti'i se' i Ia muntundunkon Tama na surugaa na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mbaka' i Yesus norobumo tae-Na, “Kalu i kuu mamasawe'konmo Anak Manusia, temposi iya'a kasi inti'ionmuu se' i Yaku'mo inono' men ngaanon YAKU' ISIAN, ka' daa bo inti'ionmuu se' i Yaku' sianta mangawawau upa-upa koi pingkira'-Ku, kasee i Yaku' muntundunkon upa-upa koi men ia pisiso'kon Tama na surugaa na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ka' i Ia men nomosuu' i Yaku' poopoololo' tii Yaku'. Ia sian mamatalai i Yaku' suusuung-Ku, gause i Yaku' sinampang mangawawau upa men kikira'-Na.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Noko daa i Yesus nuntundunkon giigii' iya'a, biai' a mian men noparasaya na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kasi i Yesus norobu na samba Yahudi men parasaya na Ko'ona tae-Na, “Kalu i kuu tumuo' koi pisiso'-Ku, kuu tuutuu' murit-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kalu i kuu tuutuu' nosidamo murit-Ku, kuu bo minginti'i pisiso' men kana'. Kalu koiya'a i kuu sianmo po'ata'on.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ia simbati samba Yahudi taena, “Kai mase lee' ni Abraham ka' i imepo sianpo nompo'ata' i kai. Koi upa i Koo mangaan se' kai sianmo po'ata'on?” ");
INSERT INTO blzNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Taeni Yesus, “Tuutuu' mba'a, kasee bantilkonon-Ku na ko'omuu se' mian men mangawawau dosa mase ata'na dosa. ");
INSERT INTO blzNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ka' sa'angu' ata' sianta dumodongo na laigan pataka manau', kasee anak a men daa sinampang dumodongo na laigan. ");
INSERT INTO blzNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ka' kalu Anak minsidakon dosa sianmo mompo'ata' i kuu, mbaka' i kuu tuutuu' sianmo nipo'ata'.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Inti'ion-Ku se' i kuu lee' ni Abraham. Kasee i kuu momoosarak mampapatei i Yaku', gause i kuu bude' mangalabot pisiso'-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Upa men Yaku' piile' na Tama na surugaa ya'amo a men bantilkonon-Ku. Kasee i kuu mingilimang upa men kuu rongor na tamamuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Taena i raaya'a, “Tamamai mase i Abraham.” Taeni Yesus, “Kalu se' tuutuu' i kuu anak ni Abraham, kuu sabole mingilimang palimangon men ia limangmo i Abraham. ");
INSERT INTO blzNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kasee i kuu momoosarak mampapatei i Yaku' men mambantilkon na ko'omuu upa men tuutuu'na men Yaku' rongor na Alaata'ala. Abraham sian mingilimang koi men limangonmuu. ");
INSERT INTO blzNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kuu mingilimang upa men limangonna tamamuu.” Taena i raaya'a, “Kai taasi' ningamea'kon na posuo' men sambu-sambumo. Tamamai tongko' sa'angu', men Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Taeni Yesus, “Kalu se' Alaata'ala iya'a Tamamuu, kuu bo molingu'kon i Yaku', gause i Yaku' ringkat na Alaata'ala. Ka' i Yaku' taka taasi' tongko' pingkira'-Ku, kasee pingkira'-Na men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nongko'upa mbali' se' i kuu sian minginti'i upa men bantilkonon-Ku? Gause i kuu sian mokotaan mongorongor pisiso'-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ibiliismo a men bo tamamuu ka' i kuu mingkira' mangawawau men kikira'na tamamuu. Iamo a men mampapatei mian na tumbenapo ka' sianta wawauna men kana', gause na ko'ona sianta men tuutuu'. Kalu ia mimborek, ia morobu koi pingkira'na suungna, gause i ia bukuan mimborek ka' tamana giigii' borek. ");
INSERT INTO blzNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yaku' mambantilkon men tuutuu'na na ko'omuu, kasee i kuu sian parasaya na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ai ime i kuu men daa momoko mimpipiile'kon se' tuutuu' i Yaku' nangawawau dosa? Yaku' nambantilkon upa men tuutuu', kasee kadai se' i kuu sian mamarasaya i Yaku'? ");
INSERT INTO blzNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kalu mian men ringkat na Alaata'ala, ia momorongori wurungna Alaata'ala. Kasee i kuu taasi' ringkat na Alaata'ala, mbali' iya'a i kuu sian momorongori.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Moomoola'na Yahudi ninsimbatimo i Yesus taena i raaya'a, “Sian tuu' mbali' kalu i kai mangaan se' i Koo samba Samaria men ia lampingi meena?” ");
INSERT INTO blzNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ia simbati i Yesus tae-Na, “Yaku' sian ia lampingi meena, kasee i Yaku' mangangga'i Tamang-Ku ka' i kuu sian mangangga'i i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kasee i Yaku' sian mansarak kada' angga'ionmuu. Isian sa'angu' men mansarak kada' i Yaku' angga'ion ka' i Ia uga' a men mungukumi. ");
INSERT INTO blzNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu kalu ime a men mongololo' men taeng-Ku, ia sian lapus pataka sidutu.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Taena moomoola'na Yahudi, “Koini'i daa kai inti'imo se' i Koo tuutuu' ia lampingimo meena. Gause i Abraham noko lapusmo ka' koiya'a uga' a nabii. Kasee i Koo nangaan, ‘Kalu ime men mongololo' men taeng-Ku, ia sian lapus pataka sidutu.’ ");
INSERT INTO blzNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kalu i Abraham noko lapusmo, ka' giigii' nabii uga' noko lapusmo, ime mbali' i Koo kani'i? Sian minsoop na akal kalu i Koo a balaki'na tii Abraham minti'imai!” ");
INSERT INTO blzNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Taeni Yesus, “Kalu i Yaku' mansarak kada' i Yaku' bi angga'ion, men koiya'a sianta kana'na. Tamang-Ku men na surugaa a men mangangga'i i Yaku'. Tama na surugaa iya'a men taemuu se' Alaata'alamuu, ");
INSERT INTO blzNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","kasee i kuu sian minginti'i i Ia. Yaku' daa minginti'i i Ia. Kalu i Yaku' mangaan se' sian minginti'i i Ia, mbaka' i Yaku' mimborek koi i kuu. Kasee i Yaku' minginti'i i Ia ka' mongololo' men tae-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham minti'imuu beles tuu' se' i ia bo mimiile' ilio kotakaan-Ku ka' ia noko pimiile'mo ka' nobeles.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mbaka' taena moomoola'na Yahudi, “Umuur koo'po tia limampulo' taun ka' i Koo mangaan se' nimiile'mo i Abraham?” ");
INSERT INTO blzNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Taeni Yesus, “Tuutuu' a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' koo'po tia i Abraham nongamea', Yaku' noko isianmo.” ");
INSERT INTO blzNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kasi i raaya'a nangala watu mangalapak i Yesus, kasee i Ia nintipenta'mo ka' namarerei Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na tempo i Yesus nolumiu, Ia nimiile' sa'angu' mian mampisok ngame-ngamea'po. ");
INSERT INTO blzNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Murit ni Yesus nimikirawarmo na Ko'ona taena i raaya'a, “Guru, ime a men nangawawau dosa, mian kaya'a suungna kabai minti'ina, mbali' i ia ningamea'kon mampisok?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ia simbati i Yesus tae-Na, “Ia nampisok, taasi' ia gau'kon dosana ka' uga' taasi' ia gau'kon dosana minti'ina, kasee ia ningamea'kon mampisok kada' kuasana Alaata'ala sida piile'on balimang na wakana. ");
INSERT INTO blzNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Daa dauga'na ilio, kita tio mingilimang palimangon-Na men nomosuu' i Yaku'. Malom bo taka ka' sa'angu'po mian sianmo momoko balimang. ");
INSERT INTO blzNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dauga'na i Yaku' na tano' balaki' kani'i, Yaku' a ruarna tano' balaki'.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sarataa i Yesus norobu koiya'a, Ia no'uminormo na tano' ka' nangalauk inor-Na iya'a tia tano', kasi nenggegeskon na matana mian men mampisok iya'a, ");
INSERT INTO blzNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ka' norobu tae-Na, “Rae' pirurup na kolam Siloam.” Siloam aratina: “Men niposuu'.” Mbaka' mian iya'a nomae'mo nirurup kasi ia nomule'kon ka' mian iya'a nopoopiile'mo. ");
INSERT INTO blzNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kasee mian men pookarani'anna laigan ka' mian men ninginti'i se' i ia mbaripian sa'angu' mian men mo'ase'-ase', norobumo taena i raaya'a, “Taasi' mianmo kani'i a men sinampang mo'ase'-ase'?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Isian mian men nangaan, “Tuutuu', mianmo kani'i.” Isian uga' men nangaan, “Taasi' i ia. Ia tongko' pookoikoianna mian iya'a.” Kasee mian iya'a nangaan taena, “Daa tuutuu' i yaku'mo.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Taena mian, “Koi upa mbali' se' daa i koo nopoopiile'mo?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ia simbati mian iya'a taena, “Mian men ngaanion Yesus nangalauk inor-Na tia tano' ka' nenggegeskon na matangku ka' nomosuu' i yaku' tae-Na, ‘Rae' na kolam Siloam ka' pirurup.’ Kasi i yaku' nomae' ka' sarataa nirurup, yaku' nopoopiile'mo.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Taena i raaya'a, “Aanamo a mian iya'a?” Taena mian iya'a, “Yaku' sian ninginti'i.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kasi i raaya'a nangawawa mian men mampisok mbaripian iya'a na mian Farisi. ");
INSERT INTO blzNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tempo i Yesus nangalauk inor-Na tia tano' ka' nompopotarang matana mian iya'a, na ilio Sabat. ");
INSERT INTO blzNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mbali' iya'a mian Farisi nimikirawarmo na mian iya'a koi upa se' daa i ia nopoopiile'mo. Ia simbati taena, “Ia nenggegesi matangku tia tano' men nilauk inor kasi i yaku' nirurup ka' koini'i i yaku' nopoopiile'mo.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Toro pii mian Farisi norobu taena, “Mian men nangawawau koi kani'i taasi' ringkat na Alaata'ala, gause i Ia sian mongololo' aturan na ilio Sabat.” Mian Farisi sambana uga' norobu taena, “Kalu i Ia sa'angu' mian men dosaon, sian minsoop na akal se' daa momoko mangawawau upa kosamba' men koiya'a.” Mbaka' ninsidakonmo i raaya'a nopoogagai. ");
INSERT INTO blzNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mbali' iya'a mian Farisi nimikirawarimo mian iya'a soosoodo taena, “Ka' i koo, koi upa a pinginti'iim i Ia, gause i Ia nompopotarangmo mataam?” Ia simbati taena, “Ia nabii.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kasee moomoola'na Yahudi sian parasaya se' mbaripian i ia mampisok, ka' koini'i nopoopiile'mo. Mbali' iya'a, raaya'a nengeleelo'mo minti'ina, ");
INSERT INTO blzNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ka' nimikirawar taena, “Kani'imo a anakmuu men taemuu se' mampisok ngame-ngamea'po? Kalu koiya'a, koi upa se' koini'i daa nopoopiile'mo?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ia simbati minti'ina mian iya'a taena, “Tuutuu'. Ia kani'i anakmai men ngame-ngamea'po mampisok, ");
INSERT INTO blzNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","kasee koi upa se' koini'i daa nopoopiile'mo, kai sian ninginti'i, ka' uga' sian kai inti'i se' i ime a nompopotarang matana. Alaka' pikirawar na ko'ona, ia daa balaki'mo. Ia sida muntundunkon i kuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Minti'ina norobu koiya'a, gause layaonkon moomoola'na Yahudi, gause i raaya'a nosangadamo kalu ime a men mangaan se' i Yesus a Tomundo' Pansalamatkon, ia sianmo poturangon minsoop na laigan bakitumpuan. ");
INSERT INTO blzNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Koiya'a mbali' minti'ina norobu taena, “Pikirawar na ko'ona, ia daa balaki'mo.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kasi i raaya'a nengeleelo' soosoodo mian men mbaripian mampisok iya'a ka' norobu taena, “Bantilkon a tuutuu'na na aropna Alaata'ala. Kai inti'i se' mian iya'a dosaon.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ia simbati taena, “Mian iya'a dosaon kabai se' sian, yaku' sian ninginti'i. Kasee men yaku' inti'i, mbaripian yaku' mampisok ka' koini'i daa nopoopiile'mo.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Taena i raaya'a, “Upa a men Ia limang na ko'oom? Koi upa i Ia ninsidakon i koo nopoopiile?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ia simbati taena, “Yaku' poko bantilkonmo na ko'omuu, kasee i kuu sian namarasaya. Mbaka' bo upamuu ka' dauga' momorongor soosoodo? Kabai i kuu uga' mingkira' sida bo murit-Na?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kasi i raaya'a ningiroki ka' norobu taena, “Koo a muritna mian iya'a, kasee i kai murit ni Musa. ");
INSERT INTO blzNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kai inti'i se' Alaata'ala norobu ni Musa, kasee i Ia sian kai inti'i mbaria a noringkatan-Na.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Taena mian iya'a, “Kosamba' tuu' se' i kuu sian ninginti'i noringkatan-Na tamban i Ia ninsidakon i yaku' poopiile. ");
INSERT INTO blzNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kita poto'inti'i se' Alaata'ala sian momorongori mian dosaon, kasee momorongori mian men malolo' ka' mingilimang men kikira'-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mbaripianpo pataka koini'i sianpo nitoorongor se' isian mian men nengelesi'i mian men mampisok ngame-ngamea'po sida poopiile'. ");
INSERT INTO blzNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kalu se' mian iya'a taasi' norumingkat na Alaata'ala Ia sian sida mangawawau upa-upa.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ia simbati i raaya'a taena, “Koo kani'i dosaon ngame-ngamea'po ka' i koo mimisiso' i kai?” Mbaka' supu iya'a i ia sianmo nipoturang minsoop na laigan bakitumpuan. ");
INSERT INTO blzNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ia rongor i Yesus se' mian iya'a sianmo ia poturang i raaya'a minsoop na laigan bakitumpuan, mbaka' ia sarakmo i Yesus a mian iya'a ka' norobu na ko'ona taena, “Parasayaoon a Anak Manusia?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ia simbati taena, “Tuan, ime mbali' i Ia, kada' i yaku' parasaya na Ko'ona?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Taeni Yesus, “Koo noko pimiile'mo i Ia. Iamo a men pintanga' batundun tii koo koini'i.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Taena mian iya'a, “Parasayaonku i kuu, Tumpu.” Kasi ia nobanintuur nonsoosa' i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Taeni Yesus, “Yaku' taka na tano' balaki' bo pungukumi, kada' ime a men sian poopiile' sidakonon poopiile', ka' ime a men mangaan se' wakana daa poopiile', ia bo sidakonon mampisok.” ");
INSERT INTO blzNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wurung ni Yesus iya'a ia rongor toro pii mian Farisi men isian iraando'o, mbaka' i raaya'a norobumo ni Yesus taena, “Kalu koiya'a, kai kani'i mbali' mampisok?” ");
INSERT INTO blzNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Taeni Yesus, “Kalu se' i kuu mampisok, kuu sian dosaon. Kasee i kuu nangaan, ‘Kai poopiile',’ mbaka' i kuu dauga' dosaon.” ");
INSERT INTO blzNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' ime a men minsoop na eko'anna domba see taasi' lumiu na soopanna, kasee mimenek, mian men koiya'a mamangan ka' mian puraga. ");
INSERT INTO blzNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kasee ime a men minsoop lumiu na soopan, ia a pontondong domba. ");
INSERT INTO blzNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Dadagai eko'an mengeleaki soopan bona pontondong, ka' domba momorongori wurungna pontondong ka' i ia mengeleelo' dombana koi ngaanna sanda-sanda' ka' nantandan umuar. ");
INSERT INTO blzNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kalu giigii' dombana uarkononnamo na liwana, ia mae' na olukon ka' dombana tumuntun na komburi'na, gause i raaya'a mongoos wurungna. ");
INSERT INTO blzNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Domba iya'a bude' mongololo' mian sambana. Raaya'a tongko' mamarere, gause wurungna mian sambana sian inti'ionna i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Koiya'a a timbaani' men ia tundunkon i Yesus na mian Farisi, kasee i raaya'a sian ninginti'i se' upa a panduung-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mbaka' i Yesus norobumo soosoodo tae-Na, “Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' Yaku'mo a soopan bona domba. ");
INSERT INTO blzNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Giigii' mian men notaka mongolukoni i Yaku', raaya'a mamangan ka' mian puraga kasee a domba iya'a sian momorongori i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yaku' a soopan iya'a. Kalu ime a minsoop lumiu na Ingku', ia bo salamat ka' i ia bo minsoop ka' umuar mantausi kakaan. ");
INSERT INTO blzNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Men mamangan tongko' taka mamangan ka' mampapatei ka' minsilaka'i. Yaku' taka kada' i raaya'a sida tumuo', ka' isian tutuo' men pore tuu'. ");
INSERT INTO blzNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yaku' a pontondong men ma'amat. Pontondong men ma'amat mongorookon noana bona dombana. ");
INSERT INTO blzNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kasee sa'angu' mian men tongko' tamboion men taasi' pontondong, ka' men taasi' tombonona domba iya'a, sarataa mimiile' serigala taka, ia tumetende' mamarerei domba iya'a. Mbaka' serigala iya'a mongorongkobimo ka' mengerensa-rensakon domba iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mian men nitamboi iya'a mamarere, gause mian iya'a balimang tongko' mansarak tambona. Ia sian mingimamat domba iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Yaku' a pontondong men ma'amat. Yaku' minginti'i dombang-Ku ka' dombang-Ku minginti'i i Yaku', ");
INSERT INTO blzNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Koimo Tama na surugaa minginti'i i Yaku' ka' i Yaku' minginti'i Tama na surugaa. Yaku' mongorookon noang-Ku bona dombang-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Dauga' isian dombang-Ku sambana, men taasi' na eko'an kani'i. Domba iya'a tio uga' bo wawaon-Ku ka' i raaya'a bo momorongor wurung-Ku. Raaya'a wiwi'na bo sida sa'angu' lulusan men tondongonna sa'angu' mian. ");
INSERT INTO blzNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tama na surugaa molingu'kon i Yaku', gause i Yaku' mongorookon noang-Ku men bo mule'kon na Ingku' soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sianta sa'angu'po mian momoko mamantas noang-Ku kalu sianta rookonon-Ku, kasee i Yaku' a men mongorookon koi pingkira'-Ku. Yaku' kuasaan mongorookon ka' kuasaan mangala soosoodo. Ya'amo a kuasa men Yaku' labot na Tamang-Ku na surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gause i Yesus norobu koiya'a, mbaka' samba Yahudi nopoogagaimo. ");
INSERT INTO blzNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Biai' a mian norobu taena, “Ia nolampingonmo na meena ka' i Ia lengang! Bo upamuu ka' momorongori i Ia?” ");
INSERT INTO blzNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kasee isian uga' men norobu taena, “Mian men lampingionna meena sianta morobu koiya'a! Sida mbali' a meena mompopotarang matana mian mampisok?” ");
INSERT INTO blzNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na Yerusalem mian pintanga' mangaramekon Nomokereran Laiganna Alaata'ala. Ya'a nosida na tempo memel. ");
INSERT INTO blzNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus rae-rae' na Laiganna Alaata'ala na gandaria men ngaanon Gandaria Salomo. ");
INSERT INTO blzNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mbaka' samba Yahudi nintikumimo i Ia ka' norobu na Ko'ona taena, “Pataka ipi i Kuu mamatalai i kai tumuo' sian kabubuana? Alia mompopowuni, bantilkon na ko'omai kalu tuutuu' i Kuumo a Tomundo' Pansalamatkon.” ");
INSERT INTO blzNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ia simbati i Yesus tae-Na, “Yaku' poko bantilkonmo na ko'omuu, kasee i kuu sian mamarasaya. Giigii' upa kosamba' men Yaku' limangmo iya'a mimpu'u na Tamang-Ku na surugaa, ka' limang iya'a a men mompotuutuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kasee i kuu sian parasaya, gause i kuu sian tonsoop dombang-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Men dombang-Ku sabole momorongori wurung-Ku. Yaku' minginti'i i raaya'a ka' i raaya'a mongololo' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yaku' mantarai i raaya'a tutuo' men pore pataka sidutu ka' i raaya'a sianta lapus. Sianta sa'angu'po mian men momoko mangarampasi i raaya'a na limang-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamang-Ku na surugaa a men nongorookon i raaya'a na Ingku', ka' i Ia a balaki'na tia mian giigii'. Sianta sa'angu'po mian men momoko mangarampasi i raaya'a na lima-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yaku' tia Tama na surugaa iya'a sa'angu'.” ");
INSERT INTO blzNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kasi samba Yahudi nangala watu soosoodo mangalapak i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kasee i Yesus norobu na ko'ona i raaya'a tae-Na, “Biai' a palimangon pore men ia posuu'kon Tamang-Ku na surugaa men Yaku' pipiile'konmo na ko'omuu. Giigii' palimangon-Ku iya'a, aana a men minsidakon i kuu mangalapak i Yaku'?” ");
INSERT INTO blzNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Taena samba Yahudi, “Taasi' se' i Koo ningilimangmo men pore mbali' se' i kai mangalapak tia watu, kasee ka' i Koo mingidek Alaata'ala. Koo tongko' mian, kasee mangaan wakaam koikoimo tia Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kasi ia simbati i Yesus tae-Na, “Taasi' uga' isian nitulis na kitap Toratmuu: Taena Alaata'ala, ‘Kuu mase alaata'ala?’ ");
INSERT INTO blzNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kita poto'inti'i se' upa men nitulis na Alkitaap bo sida pataka sidutu. Alaata'ala nantarai ngaan alaata'ala na mian men nomorongor wurung iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ansee kalu koiya'a, kadai se' i kuu mangaan i Yaku' mingidek Alaata'ala gause i Yaku' nuntundun se' i Yaku' Anakna Alaata'ala? Kada' bo inti'ionmuu se' i Yaku' ia rurukimo Alaata'ala ka' niposuu' na tano' balaki'. ");
INSERT INTO blzNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kalu men limangon-Ku taasi' palimangon men ia posuu'kon Tama na surugaa, alia mamarasaya i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Maune' i kuu bude' parasaya na Ingku', kasee ka' Yaku' limangmo a palimangon men ia posuu'kon Tama na surugaa iya'a, mbaka' parasayamo a upa men Yaku' limang iya'a, kada' i kuu poo'inti'i ka' minginti'i se' Tama na surugaa poowawa pore tii Yaku' ka' i Yaku' tia Tama na surugaa poowawa pore.” ");
INSERT INTO blzNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Raaya'a momoosarak soosoodo bo mangarakop i Yesus, kasee sian ia dapot i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kasi i Yesus nomae' soosoodo ka' nodumodongo na sambotakna Weerkauna Yordan men nansaranian ni Yohanes mian mbaripian. ");
INSERT INTO blzNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Biai' a mian men taka na Ko'ona ka' i raaya'a pootundunii taena, “Yohanes sian nangawawau upa kosamba', kasee giigii' upa men ia bantilkonmo muntundun mian iya'a tuutuu'.” ");
INSERT INTO blzNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mbaka' indo'o nobiai'mo a mian men namarasaya i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Isian sa'angu' mian men pintanga' manggeo, ngaanna i Lazarus. Dodongoanna na kampung Betania tia utusna ai Maria tii Marta. ");
INSERT INTO blzNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mariamo kani'i a wiwine men mbaripian nintimbu'kon minamina' muur men mawangi na sarat ni Tumpu Yesus ka' nansapui tia wuukna. Ia moto'utus tii Lazarus men manggeo iya'a.) ");
INSERT INTO blzNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Rua-rua'na utusna iya'a nengelelekonmo ni Yesus taena, “Tumpu, utusmai men kolingu'um iya'a manggeo.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sarataa nongorongor lele iya'a, Yesus norobumo tae-Na, “Nggeona sian kolapus, kasee bo pimpipiile'kon kobalaki'anna Alaata'ala, gause tia nggeo iya'a Anakna Alaata'ala bo pobalaki'on.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus tuutuu' mongkolingu'kon i Marta, Maria, ka' i Lazarus. ");
INSERT INTO blzNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kasee tempo i Yesus nongorongor se' i Lazarus manggeo, Ia sianpo liuliu nomae' ni Lazarus. Ia dauga' nantalekon nodumodongo koi ruangilio na tampat iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Noko daa iya'a ai Yesus norobumo na murit-Na tae-Na, “Mai kita mule'konmo na Yudea.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ia simbati murit-Na taena, “Guru, sianpo nanau' a samba Yahudi boomo mangalapak i Kuu tia watu, mune' daa koini'i i Kuu bo mae' soosoodo na dodongoanna i raaya'a!” ");
INSERT INTO blzNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Taeni Yesus, “Taasi' uga' isian sompulo' rua' jaam a sangilio? Ime a men mae' na tempo ilio, saratna sian tonsude, gause i ia mimiile' ruar na tano' balaki' kani'i. ");
INSERT INTO blzNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kasee kalu sa'angu' mian mae' na tempo malom, saratna bo tonsude, gause sianta ruar na wakana.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Koiya'a a men ia tundun i Yesus. Kasi Ia norobu tae-Na, “Lazarus lulusanta tinomporoyotmo, kasee i Yaku' bo mae' mangawangonkon i ia.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Taena murit-Na, “Tumpu, kalu i Lazarus tongko' tinomporoyot, ia sabole bo malesi'.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesus ninginti'i se' i Lazarus nolapusmo. Kasee murit-Na nansarui se' i Yesus nangaan i Lazarus tongko' tinomporoyot. ");
INSERT INTO blzNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mbali' iya'a ia popopanasakonmo i Yesus na ko'ona i raaya'a tae-Na, “Lazarus nolapusmo. ");
INSERT INTO blzNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kasee i Yaku' beles daa sianta inda'a. Gause koiya'a a porena bo ko'omuu, kada' i kuu sida parasaya. Koini'i mai kita mae' ni Lazarus.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas men ngaanon i Rapi' norobu na murit ni Yesus sambana taena, “Mai kita lumolo', sobii mau i kita pate tii ia!” ");
INSERT INTO blzNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sarataa i Yesus notaka na tampat ni Lazarus, Lazarus noko paatmo ilio a nantanoman. ");
INSERT INTO blzNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania pookarani' tia Yerusalem, kopoo'oloana toro tolu' kilometer, ");
INSERT INTO blzNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","mbali' biai' samba Yahudi notaka nengelego'i i Marta tii Maria bo mantata'u i raaya'a gause utusna i raaya'a nolapusmo. ");
INSERT INTO blzNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sarataa i Marta nomorongor se' i Yesus notakamo, ia nomae'mo nangalaboti i Yesus, kasee i Maria monda'a na laigan. ");
INSERT INTO blzNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta norobumo ni Yesus taena, “Tumpu, kalu se' i Kuu nokotakamo tempo iya'a, sabole utusku sian lapus. ");
INSERT INTO blzNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Maune' koiya'a, inti'ionku se' koini'i uga' Alaata'ala bo mantarai upa men pa'ase'on-Muu na Ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ia simbati i Yesus tae-Na, “Utuus bo tumuo' soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Taeni Marta, “Yaku' inti'imo se' i Lazarus bo tumuo' soosoodo na tempo pomotuo'ian mian lapus na ilio kokomburi'anna.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Taeni Yesus, “Yaku' a bo pomotuo'i mian lapus ka' bo pantarai tutuo' men pore pataka sidutu. Mian men parasaya na Ingku' bo tumuo', maune' i ia noko lapusmo. ");
INSERT INTO blzNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ka' mian tumuo' men parasaya na Ingku' sian lapus pataka sidutu. Parasayaoonmo a men koiya'a?” ");
INSERT INTO blzNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Taeni Marta, “Tumpu, yaku' parasaya se' i Kuu Anakna Alaata'ala, Tomundo' Pansalamatkon men bo taka na tano' balaki' kani'i.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Sarataa i Marta norobu koiya'a, ia nomae'mo nondolo' utusna i Maria ka' nenseasokon taena, “Guru isian kaya'amari. Ia nimikirawar i koo.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nomorongor koiya'a, Maria liuliu norumingkat kasi nomae' nomootuungi i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tempo iya'a, Yesus koo'po ninsoop na kampung. Ia dauga' na tampat men nomootuungian ni Marta. ");
INSERT INTO blzNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Samba Yahudi men pintanga' mantata'u i Maria na laigan, nimiile' i Maria norumingkat ka' liuliu no'umuar. Mbaka' i raaya'a nongololo'mo i ia, gause taena i raaya'a too i ia bo mae' na baleanan ka' wiri. ");
INSERT INTO blzNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sarataa i Maria notaka ni Yesus ka' nimiile' i Ia, Maria nobanintuurmo na arop ni Yesus ka' norobu taena, “Tumpu, kalu se' i Kuu notakamo tempo iya'a, sabole utusku sian lapus.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tempo i Yesus nimiile' i Maria tia samba Yahudi men notaka tii ia wiri, mbaka' i Yesus nasiongo'mo nolingu'kon tuu' i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Taeni Yesus, “Aana a nantanomanmuu i ia?” Ia simbati i raaya'a taena, “Tumpu, mai piile'.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kasi i Yesus nowiri. ");
INSERT INTO blzNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mbaka' samba Yahudi norobumo taena, “Piile'! Ia molingu'kon tuu' i Lazarus!” ");
INSERT INTO blzNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kasee isian mian men norobu taena, “Ia mompopotarang matana mian mampisok, kadai se' i Lazarus sian Ia lesi'i kada' sian lapus?” ");
INSERT INTO blzNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus nasiongo'mo soosoodo, kasi nomae' na baleanan. Baleanan iya'a sa'angu' leeng men ni'ompodi tia watu balaki'. ");
INSERT INTO blzNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesus norobumo tae-Na, “Anui a watu kanono'!” Ia simbati i Marta, utusna mian men nolapus iya'a, taena, “Tumpu, ia noko paatmo ilio a nantanoman. Sabole bobosi'mo!” ");
INSERT INTO blzNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Taeni Yesus, “Taasi' uga' Yaku' poko bantilkonmo na ko'oom: Kalu i koo parasaya, koo bo mimiile' kuasana Alaata'ala men balaki' tuu'?” ");
INSERT INTO blzNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mbaka' i raaya'a nanganuimo watu iya'a. Kasi i Yesus nolumelengea' na langit ka' norobu tae-Na, “Tama na surugaa, sukuur na Ko'omuu, gause i Kuu daa nomorongor i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Inti'ion-Ku se' i Kuu sinampang momorongor i Yaku', kasee i Yaku' muntundunkon kani'i bona mian men isian karaani'i, kada' i raaya'a mamarasaya se' i Kuumo a men nomosuu' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sarataa norobu koiya'a, Yesus norobumo boolak soosoodo tae-Na, “Lazarus, mai uar!” ");
INSERT INTO blzNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mbaka' no'umuarmo a mian men nolapusmo iya'a. Limana tia saratna dauga'na balu-balun tia toik pobalun biibii, ka' ro'upna dauga'na sa'u-sa'ubi tia toik sasa'ubi ro'up. Kasi i Yesus norobu na mian men iraando'o tae-Na, “Anui a toik pobalunna kada' i ia sida mae'!” ");
INSERT INTO blzNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Biai' a samba Yahudi men notaka nengelego'i i Maria. Gause i raaya'a nimiile' upa men ia wawau i Yesus, mbaka' i raaya'a noparasayamo na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kasee isian i raaya'a toro pii ira men nomae' na mian Farisi ka' nambantilkon upa men ia wawau i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mbali' iya'a mian Farisi ka' tanaasna imam nobarimpungmo tia Mahkama Agama. Raaya'a norobumo taena, “Upa a men tio wawauonta? Mian iya'a mangawawau biai' upa kosamba'. ");
INSERT INTO blzNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kalu patalaionta i Ia koi kani'i liuliu, giigii' mian bo parasaya na Ko'ona, ka' samba Roma bo taka munsurung Laiganna Alaata'alanta ka' munsurung lipu'ta.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Isian sa'angu' mian na ko'ona i raaya'a men ngaanna ai Kayafas. Ia Imam Moola' na taun iya'a. Ia norobu na ko'ona i raaya'a taena, “Kuu sianta upa inti'ionmuu. ");
INSERT INTO blzNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sian mbali' inti'ionmuu se' bagiakon sa'angu' mian bo lapus, dako' giigii' lipu'ta kobaraba'ian?” ");
INSERT INTO blzNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafas mangaan men koiya'a, taasi' pingkira'na suungna, kasee pingkira'na Alaata'ala. Gause na taun iya'a iamo a Imam Moola', mbaka' bookoi i ia uga' nuntundunkonmo men sianta ia inti'i se' i Yesus bo lapus bona samba Yahudi kada' i raaya'a sida salamatkonon. ");
INSERT INTO blzNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ka' taasi' tongko' bona samba Yahudi, kasee uga' bo mingirimpung ka' momosa'angu' anakna Alaata'ala men sinangkarensa. ");
INSERT INTO blzNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Muntumbei ilio iya'a moomoola'na Yahudi nobasangadamo bo mampapatei i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mbali' iya'a, Yesus sianmo nintipiile' na samba Yahudi. Ia namarereimo kota Yerusalem men na lipu' Yudea, kasi nomae' na kota Efraim karani' tano' maleas. Na kota Efraim iya'a Ia nodumodongomo tia murit-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tempo iya'a karani'mo a ilio ramean Paska na samba Yahudi. Koo'po tia ilio iya'a, biai' a mian na kampung nomae' na Yerusalem bo mongololo'kon aturan pongoloe'ian waka. ");
INSERT INTO blzNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na tempo i raaya'a nobarimpung na Laiganna Alaata'ala, raaya'a nansarakmo i Yesus. Raaya'a nopoopikirawarimo taena, “Koi upa a pinginti'imuu? Kabai i Yesus sianmo taka na ramean kani'i.” ");
INSERT INTO blzNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Raaya'a muntundun koiya'a, gause tanaasna imam tia mian Farisi nunguarkon aturan, kalu ime a minginti'i se' aana i Yesus, tio mambantilkon na ko'ona i raaya'a kada' bo rakoponna. ");
INSERT INTO blzNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Dauga' koi noom ilio a ilio ramean Paska, Yesus nomae'mo na Betania. Betania iya'a dodongoan ni Lazarus men ia potuo'i i Yesus noko daa lapus. ");
INSERT INTO blzNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Indo'o ari Lazarus nangalabotimo i Yesus ka' i Marta nantaropi kumaan na basukuuranna. Lazarus tia giigii' sawe' no'umoruang kumaan singka-singkat tii Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mbaka' i Maria notakamo nangawawa toro sambande' liter minamina' narwastu men mawangi ka' alayo' tuu' a ilina. Maria nintimbu'konmo minamina' iya'a na sarat ni Yesus kasi ia sapui tia wuukna. Woona minamina' iya'a simomoran longkop lalomna laigan. ");
INSERT INTO blzNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kasee i Yudas Iskariot, sa'angu' murit ni Yesus men bo mongorookon i Yesus kada' papateion, norobu taena, ");
INSERT INTO blzNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nongko'upa se' minamina' narwastu kani'i sian balukkonon tolu' atu doi' dinar ka' a ilina rookonon bona mian talalais?” ");
INSERT INTO blzNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas norobu koiya'a taasi' se' molingu'kon mian talalais, kasee ka' i ia mamangan. Ia mala' mangala doi'na mian biai' men ninaa' na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kasee i Yesus norobu tae-Na, “Patalai a wiwine kani'i! Ia mangawawau koi kani'i bona ilio pantanoman i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mian talalais sinampang isian na ko'omuu, kasee i Yaku' sian.” ");
INSERT INTO blzNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Biai' a samba Yahudi nongorongor se' i Yesus isian na Betania, mbaka' i raaya'a nomae'mo na Betania. Raaya'a nomae' taasi' tongko' gause isian i Yesus, kasee i raaya'a mae' mimiile' i Lazarus men ia potuo'i i Yesus noko daa lapus. ");
INSERT INTO blzNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mbali' iya'a tanaasna imam nobasangadamo bo mampapatei i Lazarus. ");
INSERT INTO blzNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Gause upa men nosida ni Lazarus iya'a, mbaka' biai' a samba Yahudi namarerei tanaasna imam ka' namarasaya i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Koi liilana mian biai' men notakamo mangaramekon ramean Paska nongorongor se' i Yesus banta-bantang ro'omari na salan mae' na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mbaka' i raaya'a nangalamo roonana kau kasi mae' mangalaboti i Ia, ka' i raaya'a mangkakaro'kon taena, “Tunde' a Alaata'ala! Barakaatan i Ia men taka ia pokau Tumpu. Barakaatan a Tomundo'na Israel!” ");
INSERT INTO blzNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus nantausi sa'angu' keledai rundara bo nolakitan-Na. Mbaka' nosidamo a men nitulis na Alkitaap taena, ");
INSERT INTO blzNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Alia matakut i kuu mian na Sion! Piile' a Tomundo'muu taka, lumakit na keledai rundara!” ");
INSERT INTO blzNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na tempo iya'a murit ni Yesus sianpo ninginti'i giigii' iya'a. Kasee sarataa i Yesus nipopobalaki' noko daa lapus, kasi i raaya'a notonginau' se' men ia wawau mian na Ko'ona nipoko tulismo na Alkitaap. ");
INSERT INTO blzNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mian biai' men isian tii Yesus na tempo i Ia nengeleelo' i Lazarus umuar na baleanan ka' nomotuo'i noko daa lapus, raaya'a mompotuutuu' wawau ni Yesus iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mbali' iya'a mian biai' nomae'mo ni Yesus, gause i raaya'a nongorongor se' i Iamo men nangawawau upa kosamba' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mbaka' mian Farisi nopootunduniimo taena, “Kita sian sida mangawawau upa-upa! Piile', giigii' mian na tano' balaki' mae' mongololo' i Ia!” ");
INSERT INTO blzNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Isian uga' samba Yunani toro pii ira men nomae' na Yerusalem na tempo ilio ramean Paska. ");
INSERT INTO blzNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Raaya'a notaka ni Filipus ka' norobu taena, “Tuan, kalu sida, kai mingkira' pootuung tii Yesus.” (Filipus samba Betsaida men na Galilea.) ");
INSERT INTO blzNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mbaka' i Filipus nomae'mo nambantilkon ni Andreas, ka' noko daa iya'a, raaya'a rua' ira nambantilkonmo ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus norobumo na ko'ona i raaya'a tae-Na, “Temponamo Anak Manusia bo pobalaki'on. ");
INSERT INTO blzNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu kalu sawuras gandum sianta asokon na tano' ka' pate, ia tongko'-tongko'na sawuras. Kasee kalu wuras na gandum iya'a pate, ia bo ule'an biai' gandum. ");
INSERT INTO blzNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mian men tongko' mingimamat wakana susuung, komburi'na bo silaka' a wakana, kasee mian men sian mingimamat wakana na tano' balaki' kani'i, ia bo mantausi tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mian men bo papalimang-Ku tio mongololo' i Yaku' kada' mau mbaria i Yaku', ia isian tii Yaku'. Mian men bo papalimang-Ku bo angga'ionna Tamang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Taeni Yesus, “Koini'i noang-Ku siasa. Upa a men tio bo tundunon-Ku? Kabai Yaku' tio mama'ase' na Tama na surugaa kada' Yaku' sianta munsuri men bo sida iya'a? Sian, gause Yaku' notaka kada' munsuri repaan men koini'i. ");
INSERT INTO blzNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tama na surugaa, pobalaki' a ngaan-Muu!” Mbaka' nokamporongoranmo a wurung nda'amari langit tae-Na, “Yaku' pobalaki'mo ka' bo pobalaki'on-Ku soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mian biai' men iraando'o nomorongor wurung iya'a. Raaya'a mangaan taena, “Waara'a kokurung!” Kasee isian uga' men mangaan, “Taasi'! Waara'a malaa'ikat morobu tii Ia!” ");
INSERT INTO blzNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kasi i Yesus norobu tae-Na, “Wurung kuwaara'a nokamporongoran taasi' bo Ingku', kasee bo ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Koini'i temponamo a dunia ukumion. Ka' koini'i Ibiliis men pungkuasai dunia kani'i rungku'ionmo. ");
INSERT INTO blzNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ka' kalu i Yaku' pasawe'kononmo na wawona tano' balaki', giigii' mian bo leelo'on-Ku taka na Ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ia norobu koiya'a bookoi pambantilkon-Na se' too koi upa a papate-Na na saliip. ");
INSERT INTO blzNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mian biai' norobumo na Ko'ona taena, “Koi men nitulis na kitap Torat, Tomundo' Pansalamatkon bo tumuo' pataka sidutu. Koi upa se' daa i Kuu mangaan se' Anak Manusia tio pasawe'konon na wawona tano'? Ime mbali' a Anak Manusia iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ia simbati i Yesus tae-Na, “Sianmo paraa manau' a ruar iya'a munguruari kuu. Gause daa dauga' isian ruar, alaka' lempang na koruaran kada' i kuu sian takaionna kapintungan. Mian men rumae' na kapintungan sian minginti'i se' too mbaria a rae'anna. ");
INSERT INTO blzNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gause ruar iya'a daa dauga' tii kuu, parasayamo a ruar iya'a kada' i kuu sida anakna koruaran.” Noko daa norobu koiya'a, Yesus nomae'mo ka' sianmo nintipiile' na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maune' i Yesus nangawawaumo biai' upa kosamba' na aropna samba Yahudi, kasee i raaya'a sian parasaya na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mbaka' nosidamo a upa men ia bantilkon i Nabii Yesaya taena, “Tumpu, ime a men parasaya na upa men bantilkononmai, mau kuasana Tumpu nipipiile'konmo na ko'ona i raaya'a?” ");
INSERT INTO blzNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Raaya'a sian parasaya, gause i Yesaya uga' isian nangaan taena, “Alaata'ala nangaan: ");
INSERT INTO blzNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Yaku' minsidakon i raaya'a mampisok, ka' minsidakon i raaya'a sian momorongori, kada' i raaya'a alia poopiile', ka' pikiranna i raaya'a alia poo'inti'i, ka' alia mule'kon na Ingku', pataka i Yaku' mengelesi'i i raaya'a.’ ” ");
INSERT INTO blzNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya nangaan koiya'a gause i ia noko pimiile'mo kobalaki'an ni Yesus, ka' i Yesaya isian nuntundun i Ia. ");
INSERT INTO blzNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Maune' koiya'a, biai' a mian men noparasaya ni Yesus tonsoop uga' moomoola'na Yahudi. Kasee i raaya'a babata mimpipiile'kon se' i raaya'a parasaya, gause layaonkon mian Farisi too mba'a sianmo mamatalai minsoop na laigan bakitumpuan. ");
INSERT INTO blzNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Raaya'a bagiakon tunde'onna mian, mau sian tunde'onna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kasi i Yesus norobu tae-Na, “Mian men parasaya na Ingku', taasi' tongko' mamarasaya i Yaku', kasee uga' parasaya na Ko'ona men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ka' mian men mimiile' i Yaku', uga' mimiile' i Ia men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yaku' taka na tano' balaki' kani'i bookoi ruar, kada' giigii' mian men parasaya na Ingku' sian dumodongo na kapintungan. ");
INSERT INTO blzNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mian men momorongor pisiso'-Ku, kasee sian mongololoikon, taasi' i Yaku' a men mungukum i raaya'a, gause i Yaku' taka taasi' bo pungukumi dunia, kasee bo pansalamatkon. ");
INSERT INTO blzNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mian men sian mangalabot i Yaku' ka' sian momorongori wurung-Ku, ia noko isianmo men bo pungukumi na ilio kokomburi'anna. Wurung men Yaku' bantilkonmo a men bo pungukumi i ia na ilio kokomburi'anna. ");
INSERT INTO blzNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Men Yaku' bantilkon taasi' koi pingkira'-Ku, kasee koi men ia posuu'kon Tama na surugaa na Ingku'. Iamo a men nambantilkon na Ingku' upa men tio porobukonon-Ku ka' bantilkonon-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ka' inti'ion-Ku se' upa men Ia bantilkon na Ingku' iya'a mantarai tutuo' men pore pataka sidutu. Mbaka' i Yaku' mambantilkon koi men ia bantilkon Tama na surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Somo koi liila a ilio ramean Paska. Ia inti'imo i Yesus se' temponamo i Ia bo mamarerei tano' balaki' kani'i, ka' mule'kon na Tama-Na. Ia mongkolingu'kon mian men tombonoion-Na na tano' balaki' kani'i, ka' i Ia mongkolingu'kon i raaya'a pataka kakabusanna palimangon-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesus tia murit-Na pintanga' kumaan malom. Ibiliis nonsoopkonmo sagiana na noa ni Yudas Iskariot anak ni Simon bo mongorookon i Yesus kada' papateion. ");
INSERT INTO blzNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus ninginti'i se' Tama na surugaa nongorookonmo giigii' kuasa na Ko'ona. Ka' Ia inti'i uga' se' i Ia ringkat na Alaata'ala ka' bo mule'kon na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mbali' iya'a Ia nokumekerermo, ka' nungukati juba-Na ka' nonggogoskon handuk na lolos-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Noko daa iya'a Ia ningisiikonmo weer na loyang, kasi nuntumbei nimimbuu'i murit-Na ka' nansapui tia handuk men Ia gogoskon na lolos-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sarataa notaka ni Simon Petrus, ia norobumo taena, “Tumpu, kadai se' i Kuu mimimbuu'i i yaku'?” ");
INSERT INTO blzNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ia simbati i Yesus tae-Na, “Koini'i sian inti'ioon a upa men wawauon-Ku kani'i, kasee daa bo inti'ioon.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Taeni Petrus, “Alia! Kuu sian sida mimimbuu'i i yaku'.” Kasee ia simbati i Yesus tae-Na, “Kalu se' i Yaku' sian mimimbuu'i i koo, koo sian mantausi obosan tii Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ia simbati i Simon Petrus taena, “Tumpu, kalu koiya'a, alia tongko' saratku, kasee uga' tia limangku ka' takala'ku!” ");
INSERT INTO blzNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Taeni Yesus, “Mian men noko poloopmo, ia noloe'mo giigii'. Ia sobiimo ka' loe'ion soosoodo saliwakon saratna. Kuu karaani'i noloe'mo, kasee sianpo wiwi'kuuna.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Ia poko inti'imo i Yesus se' i ime men bo mongorookon i Ia kada' papateion. Mbali' iya'a Ia norobumo, “Kuu karaani'i noloe'mo, kasee sianpo wiwi'kuuna.”) ");
INSERT INTO blzNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Noko daa i Yesus nimimbuu'i i raaya'a, Ia nimisokmo juba-Na ka' no'umoruang soosoodo. Kasi Ia norobu na ko'ona tae-Na, “Too daa inti'onmuu a upa men baasi Yaku' wawau na ko'omuu? ");
INSERT INTO blzNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kuu mengeleelo' i Yaku' Guru ka' Tumpu. Ka' tuutuu' uga' a men koiya'a, gause Yaku' tuutuu' Guru ka' Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kalu i Yaku' bookoi Tumpumuu ka' Gurumuu mimimbuu'i i kuu, kuu uga' tio poopimbuu'i. ");
INSERT INTO blzNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yaku' mantarai pisiso' kani'i na ko'omuu, kada' i kuu uga' mangawawau upa men Yaku' poko wawaumo na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' sianta sa'angu' ata' men mangalalabii tanaasna, kabai se' mian men niposuu' mangalalabii mian men nomosuu'. ");
INSERT INTO blzNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kalu i kuu ninginti'imo giigii' kani'i, mbaka' i kuu bo barakaation kalu mangawawau men koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Upa men tundunon-Ku kani'imari taasi' muntundun i kuu wiwi'na. Inti'ion-Ku se' ime a men Yaku' rurukimo. Kasee upa men nitulis na Alkitaap tiodaa sida, koi men taena, ‘Mian men kumaan ruru-ruru' tii Yaku' bo mongorookon i Yaku' kada' papateion.’ ");
INSERT INTO blzNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Koo'po tia men koiya'a sida, koini'ipo uga' bantilkonon-Ku na ko'omuu, kada' kalu men koiya'a sidamo, kuu mamarasaya se' i Yaku' a men ngaanon YAKU' ISIAN. ");
INSERT INTO blzNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu kalu i ime mangalabot mian men posuu'on-Ku, ia mangalabot i Yaku'. Ka' ime men mangalabot i Yaku', ia mangalabot men nomosuu' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Noko daa i Yesus norobu koiya'a, Ia nolingu'mo tuu'. Kasi tae-Na, “Imamat ini'imari! Bantilkonon-Ku na ko'omuu se' isian i kuu men bo mongorookon i Yaku' kada' papateion.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Murit ni Yesus nopootiokimo samba'kon too ime a men panduung-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sa'angu' murit ni Yesus men kolingu'-Na no'umoruang na soripi' ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petrus nongkodemo murit iya'a kada' mimikirawar ni Yesus too ime a panduung-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Murit men no'umoruang beebeel i Yesus iya'a nangkarani'mo i Yesus ka' nimikirawar taena, “Tumpu, ime a mianna?” ");
INSERT INTO blzNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Taeni Yesus, “Mian men taraion-Ku roti men ni'orom na mangko', iamo a mianna.” Mbaka' i Yesus nangalamo roti sansaap ka' nongorom na mangko' kasi nongorookon ni Yudas anak ni Simon Iskariot. ");
INSERT INTO blzNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tongko' porus nangalabot roti iya'a i Yudas ia lampingimo Ibiliis. Kasi i Yesus norobu ni Yudas tae-Na, “Wawaumo dongan a upa men bo wawauoon.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sianta sa'angu'po i raaya'a men no'umoruang kumaan indo'o men ninginti'i se' kadai i Yesus mbali' norobu koiya'a ni Yudas. ");
INSERT INTO blzNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Isian men mansarui se' too i Yesus momosuu' i Yudas mingili upa-upa men bo kokosida na ramean iya'a, kabai se' mantaraikon doi' bona mian talalais, gause Yudas iya'a panganaa' doi'na i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Noko daa i Yudas nangalabot roti iya'a, ia liuliu no'umuar. Tempo iya'a noko malommo. ");
INSERT INTO blzNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sarataa i Yudas nomae'mo, Yesus norobumo tae-Na, “Koini'i Anak Manusia pobalaki'on. Ka' na Anak Manusia iya'a, Alaata'ala uga' sida pobalaki'on. ");
INSERT INTO blzNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kalu Alaata'ala pobalaki'on mimpu'u na Anak Manusia, Alaata'ala uga' bo pobalaki'on Anak Manusia tia kuasa-Na. Ka' Alaata'ala donganmo mompobalaki' Anak Manusia. ");
INSERT INTO blzNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Anak-Ku, Yaku' sianmo manau' dumodongo tii kuu. Kuu bo mansarak i Yaku', kasee men koi Yaku' bantilkonmo na moomoola'na Yahudi, koiya'a uga' bantilkonon-Ku na ko'omuu se' na dodongoan men rae'an-Ku, sianta takaonmuu. ");
INSERT INTO blzNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yaku' mongorookon potoo u'uru na ko'omuu: Pookolingu'kon i kuu tia simbaya'muu. Koi i Yaku' mongkolingu'kon i kuu, koiya'a uga' i kuu tio pookolingu'kon. ");
INSERT INTO blzNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kalu i kuu pookolingu'kon, giigii' mian bo minginti'i se' i kuu murit-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus nimikirawarmo ni Yesus taena, “Tumpu, mbaria mbali' a bo rae'an-Muu?” Ia simbati i Yesus tae-Na, “Na dodongoan men bo rae'an-Ku, sian sida lolo'oon koini'i, kasee komburi'na i koo daa bo mongololo' i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Taeni Petrus, “Tumpu, kadai se' i yaku' sian sida lumolo' tii Kuu koini'i? Yaku' mau pate tii Kuu, daa!” ");
INSERT INTO blzNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Taeni Yesus, “Tuutuu' i koo se' mingkira' pate bo Ingku'? Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' koo'po tia siok muntuturuu', koo noko porotolumo ninsasapu na Ingku'!” ");
INSERT INTO blzNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Alia siasa a noamuu. Parasaya a Alaata'ala ka' parasayamo uga' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na Laiganna Tamang-Ku biai' a dodongoan. Kalu se' sian koiya'a sabole bantilkonon-Ku na ko'omuu. Yaku' bo mae' waara'a montoropoti bo dodongoanmuu. ");
INSERT INTO blzNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Moko daa i Yaku' mae' waara'a ka' montoropoti bo dodongoanmuu, Yaku' bo mule'kon soosoodo ka' mangawawa i kuu na dodongoan-Ku, kada' i kuu uga' inda'a tii Yaku' na dodongoan-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ka' mbaria a rae'an-Ku inti'ionmuumo lolo'on a salan mae' na dodongoan iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas norobumo na Ko'ona taena, “Tumpu, sian inti'ionmai se' mbaria a rae'an-Muu, ansee koi upa a pinginti'imai salan mae' na dodongoan iya'a?” ");
INSERT INTO blzNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ia simbati i Yesus tae-Na, “Yaku'mo a salan, ka' Yaku' a men kana', ka' Yaku' a bo pantarai tutuo' men pore pataka sidutu. Sianta sa'angu'po mian a men taka na Tama na surugaa kalu sianta tii Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kalu se' i kuu minginti'i i Yaku', kuu sabole uga' minginti'i Tamang-Ku. Koini'i i kuu ninginti'imo i Ia ka' i kuu nimiile'mo i Ia.” ");
INSERT INTO blzNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipus norobumo ni Yesus taena, “Tumpu, siso'kon i kai a Tama men tae-Muu, koiya'apo ka' daamo.” ");
INSERT INTO blzNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ia simbati i Yesus tae-Na, “Noko nanau'mo i Yaku' poopooruru' tii kuu giigii', Filipus, kasee sian inti'ioon i Yaku'? Kalu ime a men noko pimiile'mo i Yaku', ia noko pimiile'mo Tama na surugaa. Koi upa se' i koo mangaan, ‘Siso'kon i kai a Tama men tae-Muu?’ ");
INSERT INTO blzNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Sian mbali' parasayaoon se' i Yaku' poowawa pore tia Tama ka' Tama poowawa pore tii Yaku'? Upa men Yaku' bantilkon na ko'omuu taasi' koi pingkira'-Ku, kasee koi pingkira'na Tama men dumodongo na Ingku'. Iamo a men mingilimang giigii' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Parasayamo se' i Yaku' poowawa pore tia Tama ka' Tama poowawa pore tii Yaku'. Kabai koo'mo tia koo', parasayamo gause upa men Yaku' poko wawaumo iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' ime a men mamarasaya i Yaku', ia bo mingilimang palimangon men Yaku' poko limangmo, ka' uga' palimangon men balaki'na soosoodo, gause i Yaku' mae' na Tama na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ka' mau upa a men pa'ase'onmuu mangaan ngaan-Ku, sabole taraion-Ku kada' Tama na surugaa pobalaki'on gause upa men limangon-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kalu i kuu mama'ase' upa-upa na Ingku' mangaan ngaan-Ku sabole taraion-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kalu i kuu mongkolingu'kon i Yaku', kuu bo mongololoikon giigii' posuu'-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yaku' bo mama'ase' na Tama na surugaa, ka' i Ia bo mantarai i kuu sa'angu' Tutulungi men sambana, kada' i Ia mandagai i kuu pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tutulungi iya'a a Alus Molinas men mompopanasakon upa men kana'. Dunia sianta momoko mangalabot i Ia, gause dunia sianta mimiile' i Ia ka' sian minginti'i i Ia. Kasee i kuu minginti'i i Ia, gause i Ia mandagai i kuu ka' bo dumodongo na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yaku' sian mamarerei i kuu koi anak unon. Yaku' bo taka soosoodo na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sianmo paraa manau' dunia sianmo mimiile i Yaku', kasee i kuu bo mimiile' i Yaku'. Gause i Yaku' tumuo' mbaka' i kuu uga' bo tumuo'. ");
INSERT INTO blzNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Takasi a tempona kasi inti'ionmuu se' i Yaku' poowawa pore tia Tamang-Ku ka' i kuu poowawa pore tii Yaku' ka' i Yaku' poowawa pore tii kuu. ");
INSERT INTO blzNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mian men mingintoni ka' mansalankon upa men posuu'konon-Ku, iamo a men mongkolingu'kon i Yaku'. Tamang-Ku mongkolingu'kon mian men mongkolingu'kon i Yaku'. Yaku' uga' molingu'kon mian iya'a ka' mintipiile' na ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudas (taasi' i Yudas Iskariot) nimikirawarmo ni Yesus taena, “Tumpu, kadai se' i Kuu mintipiile' na ko'omai, see taasi' mune' na dunia?” ");
INSERT INTO blzNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ia simbati i Yesus tae-Na, “Mian men mongkolingu'kon i Yaku' bo mansalankon pisiso'-Ku. Tamang-Ku mongkolingu'kon i ia. Tamang-Ku tii Yaku' bo taka na ko'ona ka' dumodongo tii ia. ");
INSERT INTO blzNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mian men sian mongkolingu'kon i Yaku' sian mansalankon pisiso'-Ku. Pisiso' men kuu rongor iya'a taasi' ringkat na Ingku', kasee ringkat na Tama na surugaa men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Giigii' iya'a bantilkonon-Ku na ko'omuu daa i Yaku' dauga' ruru-ruru' tii kuu. ");
INSERT INTO blzNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kasee Tutulungi men Alus Molinas iya'a men Yaku' pa'ase' bo posuu'onna Tama na surugaa. Iamo a men bo mimisiso'kon giigii' upa na ko'omuu ka' bo mompopo'inau'kon na ko'omuu giigii' upa men Yaku' poko bantilkonmo. ");
INSERT INTO blzNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Koratongan tako'konon-Ku na ko'omuu. Koratongan-Ku a men rookonon-Ku na ko'omuu. Men rookonon-Ku iya'a taasi' koi men rookononna dunia na ko'omuu. Alia siasa, alia layaon. ");
INSERT INTO blzNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kuu nongorongormo i Yaku' nangaan, ‘Yaku' bo mae', kasee i Yaku' daa dauga' bo taka soosoodo na ko'omuu.’ Kalu i kuu mongkolingu'kon i Yaku', kuu bo beleskon i Yaku' mae' na Tama na surugaa, gause Tama na surugaa balaki'na tii Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bantilkonon-Ku iya'a na ko'omuu koini'i, koo'po tia giigii' iya'a sida, kada' kalu men koiya'a sidamo to'ipi i kuu bo parasaya. ");
INSERT INTO blzNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yaku' sianmo sakat biai' morobu soosoodo tii kuu, gause temponamo kotakaanna Ibiliis men pungkuasai dunia kani'i. Kasee i ia sian momoko mambarios wakang-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Giigii' iya'a tio sida kada' dunia minginti'i se' i Yaku' mongkolingu'kon Tama na surugaa ka' mingilimang giigii' upa men ia posuu'kon Tamang-Ku bo limangon-Ku. Koiya'amo kutung. Mai, kita mae'mo!” ");
INSERT INTO blzNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus norobumo soosoodo tae-Na, “Yaku'mo a pu'una anggur men tuutuu'na ka' Tamang-Ku a pontombonoi ale'. ");
INSERT INTO blzNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Giigii' panga'-Ku men sian miwoo' bo pantasion-Na ka' giigii' panga' men miwoo' lalapion-Na kada' minturang soosoodo a woo'na. ");
INSERT INTO blzNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kuu noloe'mo gause ningilimangmo pisiso'-Ku men Yaku' bantilkonmo na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kuu tio poowawa pore tii Yaku' kada' i Yaku' uga' poowawa pore tii kuu. Koimo panga' sian sida miwoo' suungna kalu sian motokantang tia pu'una, koiya'a uga' i kuu sian sida miwoo' kalu i kuu sian poowawa pore tii Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yaku'mo a pu'una anggur, ka' i kuu a panga'na. Mian men poowawa pore tii Yaku' ka' i Yaku' poowawa pore tii ia, mbaka' i ia bo miwoo' biai'. Kalu ime a sian poowawa pore tii Yaku', ia sian momoko mingilimang upa-upa. ");
INSERT INTO blzNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mian men sianta poowawa pore tii Yaku' bo pantasion koi panga' kada' bi pakangkung. Panga' men koiya'a bo rimpungon ka' balo'konon na lalomna apu kada' kotunu. ");
INSERT INTO blzNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kalu i kuu poowawa pore tii Yaku' ka' pisiso'-Ku mambarios noamuu, alaka' pama'ase' na Tama na surugaa too upa a men kikira'muu. Kalu koiya'a, pa'ase'muu bo loloikonon. ");
INSERT INTO blzNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kalu i kuu miwoo' biai' mbaka' Tamang-Ku na surugaa pobalaki'on, ka' tia wawaumuu men koiya'a i kuu mimpipiile'kon se' i kuu tuutuu' murit-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Koi Tama na surugaa mongkolingu'kon i Yaku', koiya'a uga' i Yaku' mongkolingu'kon i kuu. Kuu tiodaa tumuo' koi mian men kolingu'konon-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kalu i kuu mansalankon posuu'-Ku, kuu kolingu'konon-Ku, koimo i Yaku' mansalankon posuu'na Tamang-Ku, mbali' daa i Yaku' kolingu'konon-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Wiwi'na kani'i bantilkonon-Ku na ko'omuu, kada' kobelesan-Ku sida surionmuu, ka' men kobelesanmuu uga' sida sampa. ");
INSERT INTO blzNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Koi kani'imari a posuu'-Ku: Pookolingu'kon i kuu tia simbaya'muu, koimo i Yaku' mongkolingu'kon i kuu. ");
INSERT INTO blzNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sianta isian lingu' men mangalalabii polingu'na sa'angu' mian men mingkira' lapus bona bela'na. ");
INSERT INTO blzNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kalu i kuu mongololoikon upa men posuu'konon-Ku, kuumo a bela'-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kuu sianmo ngaanon-Ku ata', gause ata' sian minginti'i upa men pintanga' limangonna tanaasna. Kuu leelo'on-Ku bela' gause giigii' men Yaku' rongor na Tamang-Ku, Yaku' poko bantilkonmo na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Taasi'po i kuu a men nungururuki i Yaku', kasee i Yaku' a men nungururuki i kuu, kasi momosuu' i kuu mae' kada' miwoo' biai', ka' woo' iya'a sian kobaraba'ian. Mbaka' Tama na surugaa bo mantarai i kuu upa-upa men pa'ase'onmuu na Ko'ona mangaan ngaan-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Koi kani'imari a posuu'-Ku na ko'omuu: Pookolingu'kon i kuu tia simbaya'muu.” ");
INSERT INTO blzNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kalu dunia mangka'idek i kuu, inau' se' i Yaku' noko olukonmo ia ka'idek dunia. ");
INSERT INTO blzNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kalu se' i kuu tombonoionna dunia, sabole i kuu bo kolingu'kononna dunia, gause i ia a tombono. Kasee i Yaku' noko pungururukimo i kuu na dunia, mbaka' i kuu taasi'mo dunia a pontombonoi. Mbali' iya'a, dunia mangka'idek i kuu. ");
INSERT INTO blzNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Alaka' inau' a upa men Yaku' poko bantilkonmo na ko'omuu men taeng-Ku', ‘Ata' sianta mangalalabii tanaasna.’ Kalu i Yaku' talalaisonnamo i raaya'a, kuu uga' bo talalaisonna i raaya'a. Kalu i raaya'a mongololo' pisiso'-Ku, raaya'a uga' bo mongololo' pisiso'muu. ");
INSERT INTO blzNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Giigii' iya'a bo wawauonna i raaya'a na ko'omuu, gause i kuu murit-Ku, gause i raaya'a sian minginti'i i Ia men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kalu se' i Yaku' sian notaka, ka' sian nambantilkon giigii' iya'a na ko'ona i raaya'a, raaya'a sian dosana. Kasee koini'i i raaya'a sian sida minsasapu na dosana. ");
INSERT INTO blzNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mian men mangka'idek i Yaku' uga' mangka'idek Tamang-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kalu se' na ko'ona i raaya'a i Yaku' sian nangawawau upa-upa men koo'po tia ia toowawau mian sambana, mbaka' i raaya'a sian dosana. Maune' koini'i i raaya'a daa nimiile'mo upa men Yaku' wawaumo, kasee i raaya'a mangaka'ideki i Yaku' tia uga' Tamang-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kasee tiodaa koiya'a, kada' sida a men nitulis na kitap Toratna i raaya'a men koi kani'imari: ‘Raaya'a mangka'idek i yaku' mau sianta bo pangka'idekanna.’ ");
INSERT INTO blzNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kuu bo taraion-Ku Tutulungi men ringkat na Tama na surugaa. Tutulungi iya'a a Alus Molinas ka' i Ia mambantilkon men kana'. Kalu se' i Ia takamo, Ia bo pompotuutuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ka' i kuu uga' tio mompotuutuu' i Yaku', gause i kuu noko poopoololo'mo tii Yaku' tumbenapo.” ");
INSERT INTO blzNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Giigii' kani'i bantilkonon-Ku na ko'omuu, kada' i kuu sian mongkokundai i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kuu bo uarkonon na laigan bakitumpuan. Ka' bo taka a tempona mian men mampapatei i kuu see i ia munsurikon se' i ia mingilimang men pore na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Raaya'a mangawawaukon i kuu koiya'a gause i raaya'a sianpo ninginti'i Tama na surugaa ka' uga' sianpo ninginti'i i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kasee koini'i bantilkonon-Ku na ko'omuu a men koiya'a, kada' kalu takamo a tempona, inau'onmuu se' men koiya'a Yaku' poko bantilkonmo na ko'omuu.” 16:4b-15 “Men koi kani'i sianpo Yaku' bantilkon na ko'omuu tumbenapo gause i Yaku' dauga' poopooruru' tii kuu. ");
INSERT INTO blzNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kasee koini'i Yaku' bo mae' na Ko'ona men nomosuu' i Yaku', ka' sianta sa'angu'po i kuu men mimikirawar se' mbaria a rae'an-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ka' koini'i noamuu nasiongo'mo gause i Yaku' nambantilkon men koiya'a na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kasee tuutuu' a men koi kani'imari: Porena bo ko'omuu, kalu i Yaku' mae'. Gause kalu i Yaku' sian mae', Tutulungi sian taka na ko'omuu. Kasee kalu i Yaku' mae', bo posuu'on-Ku i Ia kada' taka na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kalu i Ia takamo, bo bantilkonon-Na na dunia se' upa a tuutuu'na dosa iya'a, ka' upa a men kana', ka' upa a ukumanna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ia bo mambantilkon na dunia se' kalu sian mamarasaya i Yaku' mase dosaon. ");
INSERT INTO blzNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ka' i Ia bo mambantilkon se' i Yaku' a tuutuu'na, gause i Yaku' mae' na Tama na surugaa ka' i kuu sianmo mimiile i Yaku' soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ka' i Ia uga' bo mambantilkon se' Alaata'ala noko puntumbeimo mungukum, gause Ibiliis men pungkuasai dunia kani'i ni'ukumimo. ");
INSERT INTO blzNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Dauga' biai' a men bo bantilkonon-Ku na ko'omuu, kasee koini'i sianpo pokoonmuu laboton. ");
INSERT INTO blzNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kasee kalu Alus iya'a takamo, Ia bo mambantilkon men kana', ka' mantandan i kuu kada' minginti'i giigii' men kana'. Ia sian morobu koi pingkira'-Na, kasee Ia mambantilkon upa men Ia rongormo, ka' Ia bo mambantilkon na ko'omuu upa men bo sida na ilio komburi'. ");
INSERT INTO blzNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ia bo mompopobalaki' i Yaku', gause upa men bantilkonon-Na na ko'omuu, laboton-Na na Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Giigii' men isian na Tama tombonoion-Ku. Ya'a mbali' i Yaku' mangaan se' upa men bantilkononna Alus na ko'omuu, Ia labot na Ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Sianmo paraa manau' i kuu sianmo mimiile' i Yaku', ka' uga', sianmo paraa manau' i kuu bo mimiile' i Yaku' soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Toro pii murit-Na nopoopikirawarimo taena, “Upa a panduung-Na i Ia mambantilkon na ko'onta', ‘Sianmo paraa manau' i kuu sianmo mimiile' i Yaku', ka' uga', sianmo paraa manau' i kuu bo mimiile' i Yaku' soosoodo?’ Ka' upa a panduung-Na men tae-Na, ‘Yaku' bo mae' na Tama?’ ” ");
INSERT INTO blzNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Raaya'a poopikirawari taena, “Upa aratina, ‘Sianmo paraa manau'?’ Sian inti'ionta se' upa a men tundunon-Na!” ");
INSERT INTO blzNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus ninginti'imo se' i raaya'a bo bapikirawar na Ko'ona. Mbaka' tae-Na, “Taeng-Ku' umba'a, ‘Sianmo paraa manau' i kuu sianmo mimiile' i Yaku', ka' sianmo paraa manau' i kuu bo mimiile' i Yaku' soosoodo.’ Ya'a a men pikirawaronmuu? ");
INSERT INTO blzNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' i kuu bo wiri ka' tumando', kasee dunia bo kambelesan. Noamuu bo masiongo' kasee kasiongo'anmuu bo koboliian sida kambelesan. ");
INSERT INTO blzNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kalu se' sa'angu' wiwine boomo mindompu', ia sabole siasa gause takamo a tempona i ia munsuri repaan. Kasee kalu daamo pindompu'kononna a anakna, kolimbo'kononnamo a repaan men ia suri gause i ia beles tuu' montookon sa'angu' anak daa nipindompu'konmo na tano' balaki'. ");
INSERT INTO blzNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Koiya'a uga' i kuu: Koini'i noamuu masiongo', kasee i Yaku' bo pootuung soosoodo tii kuu, mbaka' noamuu bo kambelesan. Ka' sianta sa'angu'po mian men momoko munsurung kambelesan iya'a na noamuu. ");
INSERT INTO blzNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na ilio iya'a i kuu sianmo mimikirawar upa-upa na Ingku'. Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' giigii' upa men pa'ase'onmuu na Tama na surugaa mangaan ngaan-Ku, sabole taraikonon-Na i kuu. ");
INSERT INTO blzNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pataka koini'i i kuu sianpo nama'ase' upa-upa mangaan ngaan-Ku. Alaka' pama'ase' kada' i kuu bo mangalabot, ka' kambelesanmuu sida sampa.” ");
INSERT INTO blzNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Giigii' kani'i bantilkonon-Ku na ko'omuu tia timbaani'. Bo taka tempona i Yaku' sianmo batimbaani', kasee Tama na surugaa bo bantilkonon-Ku na ko'omuu a men tuutuu'na. ");
INSERT INTO blzNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na tempo iya'a i kuu bo mama'ase' upa-upa na Tama na surugaa mangaan ngaan-Ku. Ka' taasi' se' tio i Yaku' a men bo puntundunkon na Tama na surugaa, ");
INSERT INTO blzNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","gause Tama na surugaa mongkolingu'kon i kuu. Ia mongkolingu'kon i kuu gause i kuu mongkolingu'kon i Yaku', ka' mamarasaya se' i Yaku' taka ringkat na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tuutuu', Yaku' ringkat na Tama na surugaa, ka' noko takamo na tano' balaki'. Kasee koini'i Yaku' mamarereimo tano' balaki' ka' mule'kon na Tama na surugaa.” ");
INSERT INTO blzNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kasi murit ni Yesus norobu taena, “Koini'i Tumpu morobu sian mompopowuni ka' sian batimbaani'. ");
INSERT INTO blzNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Koini'i kai inti'imo se' Tumpu minginti'i upa giigii', ka' sianta sakat sa'angu'po mian mimikirawar na Ko'omuu. Mbali' iya'a parasayaonmai se' i Kuu ringkat na Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ia simbati i Yesus tae-Na, “Koini'i daa parasayaonmuumo? ");
INSERT INTO blzNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Inau'! Bo taka a tempona, ka' koini'i uga' noko takamo, se' i kuu bo bagera-gerap ka' bo mule'kon na laiganmuu sanda-sanda' mamarerei i Yaku' pataka somo suung-Ku. Kasee Yaku' sianta tongko' suung-Ku, gause Tama na surugaa poopoololo' tii Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Giigii' kani'i bantilkonon-Ku kada' i kuu munsuri koratongan men ringkat na Ingku'. Na dunia i kuu bo marepa, kasee i kuu bi poonggor, gause dunia daa Yaku' poko rungku'imo.” ");
INSERT INTO blzNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Noko daa norobu koiya'a, Yesus notumangakmo waara'a lealaa ka' nosambayang tae-Na, “Tama na surugaa, koini'i takamo a tempona. Pobalaki'mo a Anak-Muu, kada' Anak-Muu uga' mompopobalaki' i Kuu. ");
INSERT INTO blzNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tama na surugaa nantaraimo Anak kuasa na giigii' mian, kada' Anak mantarai tutuo' men pore pataka sidutu bona giigii' mian men Kuu rookonmo na Ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kalu mian minginti'i i Kuu, Alaata'ala men sa'a-sa'angu' ka' men kana', ka' uga' minginti'i i Yesus Kristus men Kuu posuu', mbaka' koiya'a a salan kada' daa mantausi tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yaku' namakabus palimangon men Kuu posuu'kon na Ingku' pataka i Kuu sida nipopobalaki' na tano' balaki' kani'i. ");
INSERT INTO blzNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tama! Pobalaki' i Yaku' koini'i kada' sida rumuru' tii Kuu ka' montombonoi kobalaki'an men tombonoion-Ku koo'po tia dunia kani'i nisidakon, tempo i Yaku' ruru-ruru' tii Kuu. ");
INSERT INTO blzNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Tama na surugaa, Kuu Yaku' popo'inti'ikonmo na mian men Kuu rookon na Ingku' na dunia kani'i. Raaya'a tombonoion-Muu ka' Kuu rookonmo na Ingku'. Raaya'a nongololoikonmo wurung-Muu. ");
INSERT INTO blzNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Koini'i ia inti'imo i raaya'a se' giigii' upa men Kuu rookonmo na Ingku' iya'a norumingkat na Ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Yaku' poko bantilkonmo na ko'ona i raaya'a a wurung men Kuu tundunkon na Ingku', ka' ia poko labotmo i raaya'a. Raaya'a ninginti'i se' i Yaku' tuutuu' ringkat na Tama na surugaa ka' i raaya'a parasaya se' Tama na surugaa a men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yaku' mansambayangkon i raaya'a. Yaku' sian mansambayangkon mian na dunia men sian parasaya, kasee bona mian men daa Kuu poko rookonmo na Ingku', gause i raaya'a tombonoion-Muu. ");
INSERT INTO blzNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Giigii' men tombonoion-Ku uga' tombonoion-Muu, ka' giigii' men tombonoion-Muu uga' tombonoion-Ku. Raaya'amo a men nimpipiile'kon kobalaki'an-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Koini'i i Yaku' takamo na Ko'omuu, Tama na surugaa. Yaku' sianmo dumodongo na dunia, kasee i raaya'a dauga'na na dunia. Tama na surugaa men molinas! Dagai i raaya'a mimpu'u na kuasana ngaan-Muu, ngaan men Kuu poko rookonmo na Ingku', kada' i raaya'a sida poowawa pore koi Tama na surugaa tii Yaku' uga' poowawa pore. ");
INSERT INTO blzNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tempo i Yaku' dauga' ruru-ruru' tii raaya'a i Yaku' nandagaimo i raaya'a mimpu'u na kuasana ngaan-Muu Tama na surugaa, ngaan-Muu men Kuu rookonmo na Ingku'. Yaku' nandagaimo i raaya'a ka' sianta sa'angu'po i raaya'a men malalap, saliwakon i ia men nipokongaanmo men bo silaka' kada' sida a upa men nitulismo na Alkitaap. ");
INSERT INTO blzNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Koini'i i Yaku' taka na Tama na surugaa. Giigii' sambayang-Ku kani'i tundunon-Ku na tempo i Yaku' dauga' na dunia kada' i raaya'a tuutuu' munsuri kobelesan-Ku na wakana i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yaku' nambantilkonmo wurung-Muu Tama na surugaa na ko'ona i raaya'a, ka' mian na dunia mangka'idek i raaya'a, gause i raaya'a taasi' mian na dunia a tombono, koikoimo i Yaku' uga' taasi' mian na dunia a tombono. ");
INSERT INTO blzNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yaku' sian mama'ase' kada' i raaya'a dolo'on-Muu na dunia kani'i, kasee i Yaku' mama'ase' kada' i Kuu Tama na surugaa mandagai i raaya'a dako' i raaya'a singaonna upa men ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Koikoimo i Yaku' taasi' mian na dunia a tombono, raaya'a uga' taasi' mian na dunia a tombono. ");
INSERT INTO blzNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sidakon molinas i raaya'a tia upa men kana'. Wurung-Muu daa kana'. ");
INSERT INTO blzNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Koi Tama na surugaa nomosuu' i Yaku' mae' na mian na dunia, koiya'a uga' i Yaku' nomosuu' i raaya'a mae' na mian na dunia. ");
INSERT INTO blzNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kada' bo kaparaluuanna i raaya'a, Yaku' mongorookon wakang-Ku men tongko' bo Ko'omuu, kada' i raaya'a uga' sida tongko' bo Ko'omuu koi men tuutuu'na. ");
INSERT INTO blzNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Yaku' taasi' tongko' mansambayangkon i raaya'a kani'i. Kasee i Yaku' uga' mansambayangkon mian men bo parasaya na Ingku' gause tundunanna i raaya'a mompotuutuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yaku' mama'ase' na Ko'omuu Tama na surugaa kada' i raaya'a giigii' poowawa pore, koi Tama na surugaa poowawa pore tii Yaku' ka' i Yaku' poowawa pore tia Tama na surugaa. Sulano i raaya'a sida poowawa pore tii Kita kada' inti'ionna mian na dunia se' Tama na surugaa a men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yaku' nompobalaki'mo i raaya'a koi men Kuu wawaumo Tama na surugaa na Ingku', kada' i raaya'a poowawa pore koi i Kita uga' poowawa pore. ");
INSERT INTO blzNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yaku' poowawa pore tii raaya'a, ka' Tama na surugaa poowawa pore tii Yaku'. Kalu i raaya'a tuutuu' sida poowawa pore, mbaka' inti'ionna mian na dunia se' Tama na surugaa a men nomosuu' i Yaku' ka' inti'ionna mian na dunia se' Tama na surugaa molingu'kon i raaya'a men parasaya koi i Kuu uga' molingu'kon i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tama na surugaa, Yaku' mingkira' sulano i raaya'a men Kuu rookonmo na Ingku' sida ruru-ruru' tii Yaku' mau mbaana i Yaku', kada' i raaya'a mimiile' kobalaki'an-Ku. Kobalaki'an-Ku iya'a Kuu rookon na Ingku', gause i Kuu molingu'kon i Yaku' koo'po tia dunia kani'i nisidakon. ");
INSERT INTO blzNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tama na surugaa men maloos! Mau mune' mian na dunia sian minginti'i i Kuu, kasee i Yaku' minginti'i i Kuu; ka' mian karaani'i ninginti'i se' Tama na surugaa a men nomosuu' i Yaku'. ");
INSERT INTO blzNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yaku' nompopo'inti'ikonmo ngaan-Muu na ko'ona i raaya'a, ka' men koiya'a sinampang wawauon-Ku, kada' polingu'na Tama na surugaa na Ingku' sinampang uga' isian na noana i raaya'a, ka' kada' i Yaku' poowawa pore tii raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Noko daa i Yesus nosambayang koiya'a, Ia tia murit-Na no'umuarmo na kota Yerusalem ka' nomae' na sambotakna weerkauna Kidron. Na tampat iya'a isian sa'angu' taman, ka' i Yesus tia murit-Na ninsoopmo na taman iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas men bo mongorookon i Yesus, ninginti'i tampat iya'a gause i Yesus dele pootatakai indo'o tia murit-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mbaka' i Yudas nomae'mo na tampat iya'a ka' nangawawa sa'angu' pasukan surudadu tia toro pii dadagai Laiganna Alaata'ala men ia posuu' tanaasna imam tia mian Farisi. Raaya'a potowawa lantera', panso ka' pakakas bo poopapate. ");
INSERT INTO blzNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus ninginti'imo giigii' men bo sida na Ko'ona, mbaka' Ia nangkarani'mo i raaya'a ka' nimikirawari tae-Na, “Ime a sarakonmuu?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ia simbati i raaya'a taena, “Yesus samba Nazaret.” Taeni Yesus, “Yaku'mo i Ia.” Yudas men ba'idek a noana ni Yesus uga' indo'o potokerer tii raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tempo i Yesus nambantilkon na ko'ona i raaya'a se', “Yaku'mo i Ia,” raaya'a giigii' nosumusungkele'mo ka' tinombabas. ");
INSERT INTO blzNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesus nimikirawarimo i raaya'a soosoodo tae-Na, “Ime a sarakonmuu?” Ia simbati i raaya'a taena, “Yesus samba Nazaret.” ");
INSERT INTO blzNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Taeni Yesus, “Yaku' bantilkonmo se' i Yaku'mo i Ia. Ka' kalu se' tuutuu' i Yaku' a men sarakonmuu, patalai a mian karaani'i mae'.” ");
INSERT INTO blzNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Wurung ni Yesus men koiya'a a ninsidakon upa men Ia poko ngaanmo men tae-Na, “Tama na surugaa! Giigii' mian men Kuu poko rookonmo na Ingku', sianta men lapus.”) ");
INSERT INTO blzNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petrus men nangawawa bakoko' numbubutmo bakoko'na kasi nontotok sa'angu' mian men ata'na Imam Moola' tamban kinopantas a tilingana men uanan. Ngaanna mian men kinopantas a tilingana iya'a i Malkhus. ");
INSERT INTO blzNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mbaka' i Yesus norobumo ni Petrus tae-Na, “Soopkon a bakoko'om na guma'na! Pingiti'iim se' sian pokoon-Ku a munsuri repaan men rookononna Tama na surugaa na Ingku'?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mbaka' surudadu tia tanaasna ka' dadagai men ia posuu' samba Yahudi nangarakopmo i Yesus ka' nengkea'. ");
INSERT INTO blzNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tumbena i raaya'a nangawawa i Yesus mae' ni Hanas, monian ni Kayafas men moro'one. Kayafas a men Imam Moola' na taun iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ka' i ia a men nambantili moomoola'na Yahudi se' mbulokon sa'angu' mian lapus bona giigii' mian. ");
INSERT INTO blzNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrus ka' sa'angu' murit men sambanaan nongololo' i Yesus. Sa'angu' murit iya'a poo'inti'i tia Imam Moola', mbali' iya'a ia sida ninsoop tii Yesus na tolodona laiganna Imam Moola', ");
INSERT INTO blzNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kasee i Petrus dauga' inde'e mempeperai na liwana beebeel soopan. Mbaka' sa'angu' murit ni Yesus men poo'inti'i tia Imam Moola' mae' no'umuar ka' norobu tia ata' wiwine men mandagai soopan kasi nangawawa i Petrus minsoop na lalomna. ");
INSERT INTO blzNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ata' wiwine men mandagai soopan iya'a norobumo ni Petrus taena, “Koo taasi' uga' tonsoop muritna mian kale'e?” Ia simbati i Petrus taena, “Taasi'.” ");
INSERT INTO blzNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Malom iya'a memel tuu' a lealaa, mbali' iya'a papalimang tia dadagai Laiganna Alaata'ala namatu'umo apu ka' ninguru iraando'o. Petrus nuntuu'imo i raaya'a ka' ninguru tii raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Imam Moola' nimikirawar ni Yesus murit-Na ka' pisiso'-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ia simbati i Yesus tae-Na, “Yaku' sinampang morobu na aropna mian biai' ka' sianta wuni-wuni. Yaku' sinampang mimisiso' mian na laigan bakitumpuan ka' na Laiganna Alaata'ala na tampat men malia' pootatakaianna samba Yahudi. Yaku' sianpo nontoo bantilkon upa-upa na mian biai' men wuni-wuni. ");
INSERT INTO blzNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nongko'upa se' i kuu mimikirawari i Yaku'? Pikirawar na ko'ona i raaya'a men nomorongormo i Yaku' mimisiso'. Sabole inti'ionna i raaya'a se' upa a men Yaku' wawau.” ");
INSERT INTO blzNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sarataa i Yesus norobu koiya'a, sa'angu' dadagai men indo'o nangarapa'mo i Yesus ka' norobu taena, “Koiya'a pinsimbatiim Imam Moola'!” ");
INSERT INTO blzNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ia simbati i Yesus tae-Na, “Kalu i Yaku' muntundun upa men sala', bantilkon ka'ita too upa a men sala'! Kasee kalu men Yaku' tundun kani'i kana', kadai se' i kuu mangarapa' i Yaku'?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kasi Hanas nomosuu' mian mangawawa i Yesus men nikea' a limana mae' ni Kayafas, men Imam Moola'. ");
INSERT INTO blzNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petrus dauga'na indo'o kere-kerer minguru. Taena mian men iraando'o, “Koo uga' tonsoop murit-Na, taasi'?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kasee i Petrus ninsasapu taena, “Taasi'!” Sa'angu' ata'na Imam Moola' men poto'utusanna mian men ia pantas i Petrus a tilingana norobu taena, “Taasi' uga' i yaku' nimiile' i koo na taman iya'a poopoololo' tii Ia?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kasi i Petrus ninsasapu soosoodo. Ka' noko daa koiya'a siok nuntuturuu'mo. ");
INSERT INTO blzNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ma'ulo-ulop tuu' i raaya'a nangawawamo i Yesus ringkat na laigan ni Kayafas mae' na laiganna gubernuur. Samba Yahudi sian ninsoop na laiganna gubernuur iya'a, dako' mangawawau men doso na waka koi men taena agamana, gause i raaya'a bo kumaan Paska. ");
INSERT INTO blzNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mbali' iya'a i Pilatus no'umuarmo nangaropi i raaya'a ka' nimikirawar taena, “Upa mbali' a men raitkononmuu na mian kani'i?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Taena i raaya'a, “Kalu se' i Ia sian ba'idek a gau'na, kai sian mangawawa i Ia ka'ita na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Taena i Pilatus, “Alaka' wawa i Ia ka' ukumi koi Ukum Toratmuu!” Kasee taena samba Yahudi, “Kai sian sida mungukum mian tia ukuman pate.” ");
INSERT INTO blzNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Nosida men koiya'a kada' sida a men ia poko ngaanmo i Yesus muntundun lalapus-Na.) ");
INSERT INTO blzNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus ninsoopmo soosoodo na laiganna gubernuur ka' nengeleelo' i Yesus, kasi nimikirawar taena, “Koomo a tomundo'na lipu' Yahudi?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ia simbati i Yesus taena, “Too daa men kuu pikirawar kanooro'o no'umuar na noamuu suungmuu kabai se' isian mian sambana men nuntundun i Yaku' na ko'omuu?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Taeni Pilatus taena, “Yaku' mbali' se' samba Yahudi? Men nongorookon i Koo na ingku' mase lipu'um tia tanaasna imam. Upa a men Koo wawau?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ia simbati i Yesus taena, “Batomundo'an-Ku taasi' na dunia kani'i. Kalu se' batomundo'an-Ku na dunia kani'i, sabole mian-Ku mariwuku muntulungkon i Yaku' kada' sian rookonon na moomoola'na Yahudi. Kasee batomundo'an-Ku taasi' na dunia kani'i!” ");
INSERT INTO blzNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mbaka' taeni Pilatus, “Kalu koiya'a, Koo tomundo'?” Ia simbati i Yesus taena, “Kuu mangaan se' i Yaku' kani'i tomundo'. Gause bo pontomundo'i iya'a mbali' i Yaku' nongamea' ka' notaka na tano' balaki' kani'i kada' yaku' sida mambantilkon upa men kana'. Mian men mingkira' upa men kana', ia momorongori i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Taena i Pilatus, “Upa iya'a men kana'?” 18:38b-19:16a Kasi i Pilatus no'umuar soosoodo na tampat pungukumian ka' norobu na samba Yahudi taena, “Yaku' sian nantausi sa'angu'po sala'-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kasee men dele na ko'omuu, yaku' mansanda' munguarkon sa'angu' mian na tarungkuan na ilio ramean Paska. Too daa i kuu mingkira' kalu i yaku' munguarkon tomundo'na samba Yahudi bo ko'omuu?” ");
INSERT INTO blzNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Raaya'a nangkakaro'mo ninsimbati taena i raaya'a, “Sian! Alia i Ia, kasee i Barabas!” (Barabas sa'angu' mian men puraga.) ");
INSERT INTO blzNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kasi i Pilatus nondolo' i Yesus ka' nomosuu' mian membebot i Ia tia sambook. ");
INSERT INTO blzNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Surudadu nanganam sa'angu' likok ruri' niwawau koi mahkota ka' nunsulon na takala' ni Yesus. Raaya'a uga' nimpisokimo i Ia tia juba kakamumu'. ");
INSERT INTO blzNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kasi i raaya'a nuntuu'i i Ia ka' norobu taena, “Tabea', oo tomundo' na lipu' Yahudi!” Kasi ia papagi i raaya'a a ro'up-Na. ");
INSERT INTO blzNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Noko daa iya'a ai Pilatus no'umuarmo soosoodo ka' norobu na mian biai' taena, “Piile'! Yaku' nunguarkon i Ia, mimpipiile'kon na ko'omuu kada' inti'ionmuu se' i yaku' sianta nantausi sa'angu'po sala'-Na.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mbaka' i Yesus no'umuarmo, niposapeo'i ruri' ka' nojuba kakamumu'. Kasi i Pilatus norobu na ko'ona i raaya'a taena, “Piile' a mian kanono'.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sarataa tanaasna imam tari dadagai nimiile' i Yesus, raaya'a nangkakaro'mo taena, “Saliipkonmo a mian kanono'! Saliipkonmo a mian kanono'!” Mbaka' norobumo i Pilatus na ko'ona i raaya'a taena, “Alaka' wawa i Ia ka' saliipkon kuu-kuuna, gause i yaku' sianta nantausi sa'angu'po sala'-Na.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ia simbati samba Yahudi taena, “Mongololoikon koi men na ukummai, Ia tio ukumon pate gause i Ia mangaan se' waka-Na Anakna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sarataa i Pilatus nongorongor i raaya'a norobu koiya'a, ia nokanturanganmo a takutna. ");
INSERT INTO blzNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mbaka' ia ninsoopmo soosoodo na lalomna laiganna gubernuur, ka' sarataa i Yesus nisoopkon, Pilatus nimikirawarimo i Ia taena, “Koo ringkat aana?” Kasee i Yesus sian ninsimbati. ");
INSERT INTO blzNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mbaka' i Pilatus norobumo soosoodo taena, “Koo bude' morobu tii yaku'? Kada' bo inti'ioon, yaku' kuasaan bo munguarkon i Koo ka' kuasaan mansaliipkon i Koo!” ");
INSERT INTO blzNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ia simbati i Yesus taena, “Kalu Alaata'ala sian nantarai kuasa iya'a na ko'omuu, sabole i kuu sianta kuasaan na Ingku'. Mbali' iya'a, men balaki'na dosana tii kuu mase mian men nongorookon i Yaku' na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sarataa i Pilatus nongorongor iya'a, ia nomoosarakmo bo munguarkon i Yesus. Kasee samba Yahudi mangkakaro' taena, “Kalu i Tuan munguarkon i Ia, Tuan taasi'po bela' ni Kaisar! Mian men mangaan se' wakana tomundo', ia mian men sian pooka'amat tii Kaisar!” ");
INSERT INTO blzNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tempo i Pilatus nongorongor wurung men koiya'a, ia nangawawamo i Yesus umuar, kasi ia no'umoruang na oruangan pungukumian na tampat men ngaanion Dasar Watu. (Na wurung Ibrani ngaanna Gabata.) ");
INSERT INTO blzNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tempo iya'a toro jaam duablaas tanga'iloa', ka' koi liilana ilio ramean Paska. Pilatus norobumo na samba Yahudi taena, “Ni'imo a tomundo'muu!” ");
INSERT INTO blzNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mbaka' nangkakaro'mo i raaya'a taena, “Papatei i Ia! Papatei i Ia! Saliipkon a mian kanono'!” Pilatus nimikirawarmo taena, “Tio saliipkononku mbali' a tomundo'muu?” Ia simbati tanaasna imam taena, “Tomundo'mai tongko' Kaisar, sianta sambanaan!” ");
INSERT INTO blzNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mbaka' i Pilatus nongorookonmo i Yesus na ko'ona i raaya'a bo saliipkonon. 19:16b-27 Raaya'a nangawawamo i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesus no'umuarmo pasa-pasa'an saliip-Na mae' na tampat men ngaanon Lamasna Takala'. (Na wurung Ibrani ngaanna Golgota.) ");
INSERT INTO blzNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Inda'a Ia nisaliipkon. Isian uga' rua' mian nisaliipkon singkat tii Ia, sa'angu' mian paraas kauri', sa'angu' mian paraas uanan ka' i Yesus na ola'na. ");
INSERT INTO blzNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na saliip ni Yesus i Pilatus nomosuu' mamakana' tulisan men koi kani'imari: Yesus samba Nazaret, Tomundo'na lipu' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Biai' a samba Yahudi mambasa tulisan iya'a, gause tampat men nansaliipkonan i Yesus sian oloa na kota. Tulisan iya'a na wurung Ibrani, wurung Latin ka' wurung Yunani. ");
INSERT INTO blzNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tanaasna imam norobu ni Pilatus taena, “Alia muntulis ‘Tomundo'na samba Yahudi’ kasee alaka' tulis, ‘Mian kani'i nangaan, Yaku' Tomundo'na samba Yahudi.’ ” ");
INSERT INTO blzNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kasee ia simbati i Pilatus taena, “Men yaku' poko tulismo sianmo kosapuian.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sarataa surudadu nansaliipkon i Yesus, raaya'a nangalamo pakean-Na. Pakean iya'a ni'obos paat, sanda-sanda' nandapot sangobosan. Raaya'a uga' nangala jubana. Juba iya'a koi toik saleak muntumbei nda'ana taka ro'ona, sianta kautanna. ");
INSERT INTO blzNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mbali' iya'a, raaya'a nopootunduniimo simbaya'na taena, “Alia i kita mongobos juba kaya'a men tongko' toro samberakan. Mai kita undia kada' inti'ion too ime a men mandapot.” Men koiya'a nosida kada' sida a upa men ningaan na Alkitaap taena, “Raaya'a mongobo-obos pakean-Ku, ka' mungundi jubang-Ku.” Ka' uga' surudadu iya'a nangawawau men koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Karani' saliip ni Yesus isian sina-Na, ka' isian sa'angu' wiwine men utusna sina-Na, ka' i Maria boroki' ni Klopas, ka' i Maria Magdalena potokerer. ");
INSERT INTO blzNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sarataa i Yesus nimiile' sina-Na ka' murit-Na men kolingu'-Na potokerer karani' i Ia, Ia norobumo na sina-Na tae-Na, “Mama, nono' a anakmuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kasi i Yesus norobu na murit-Na iya'a tae-Na, “Nono' a sinaam.” Supupo iya'a sina ni Yesus nodumodongomo na laiganna murit iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus ninginti'i se' giigii' noko daamo, ka' kada' sida a upa men nitulismo na Alkitaap, mbaka' Ia norobumo tae-Na, “Yaku' moro'u.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Indo'o isian sa'angu' mangko' men buke' tia anggur makarang. Mbaka' i raaya'a nongoromkonmo garanggan mongura' na anggur men makarang ka' potoor na kau hisop itiu' sangkolong, kasi nondoekon paraas nganga' ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Noko daa i Yesus nonsosop anggur makarang iya'a, ia norobumo taena, “Daa pupulmo.” Kasi Ia nuntutuku'kon takala'-Na ka' nolapus. ");
INSERT INTO blzNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ilio iya'a batoropotan ilio Sabat men ramean balaki'. Gause moomoola'na Yahudi bude' biibii iya'a poto ndoeng na saliip na ilio Sabat, mbaka' notakamo i raaya'a ni Pilatus ka' mama'ase' na ko'ona kada' saratna i raaya'a pato'on ka' biibiina taro'konon. ");
INSERT INTO blzNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mbaka' surudadu ni Pilatus nomae'mo ka' nongolukoni namato' saratna mian rua' ira men nisaliipkon singkat tii Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sarataa i raaya'a notaka inde'e ni Yesus, ia piile' i raaya'a noko lapusmo. Mbaka' i raaya'a sianmo namato' saratna. ");
INSERT INTO blzNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kasee isian sa'angu' surudadu nungusuk i Yesus tia kalait paraas rusuk-Na pataka liuliu no'umuar a rara' tia weer. ");
INSERT INTO blzNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mian men nimiile' upa men nosida iya'a, iamo a men nuntundunkon kani'i kada' i kuu uga' mamarasaya. Upa men ia tundunkon iya'a tuutuu' ka' inti'ionna se' upa men bantilkonna iya'a kana'. ");
INSERT INTO blzNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Men koiya'a nosida kada' sida a men nitulis na Alkitaap taena, “Sianta sa'angu'po a wukuna men bo pato'on.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na Alkitaap uga' isian nitulis taena, “Raaya'a bo mengelelengea' i Ia men ia poko usukmo.” ");
INSERT INTO blzNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Noko daa iya'a, Yusuf samba Arimatea nama'ase' ni Pilatus mangala biibii ni Yesus. (Yusuf iya'a murit ni Yesus kasee wuni-wuni gause layaonkon moomoola'na Yahudi.) Pilatus nomoturang i ia, mbaka' ia nomae'mo nangala biibii ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus men mbaripian isian notaka ni Yesus tempo malom, uga' nomae' tii Yusuf. Nikodemus nangawawa mina' muur men nilauk tia mina' gaharu, wiwi'namo toro tolumpulo' kilo a kobiai'na. ");
INSERT INTO blzNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Raaya'a rua' ira nangalamo biibii ni Yesus ka' nambalun tia toik pobalun ka' nintimbu'i tia minamina' iya'a mongololo' koi adatna samba Yahudi kalu mantanom biibii. ");
INSERT INTO blzNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Karani' tampat men nansaliipkonan i Yesus isian sa'angu' taman. Na taman iya'a isian baleanan u'uru men sianpo nipokelaii biibii. ");
INSERT INTO blzNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Gause ilio iya'a batoropotianna samba Yahudi bona ilio Sabat, ka' baleanan iya'a daa karani', mbaka' i raaya'a nomokelamo biibii ni Yesus inde'e. ");
INSERT INTO blzNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na ilio tumbena minggu iya'a, ma'ulo-ulop tuu' men dauga'na pintung, Maria Magdalena nomae'mo na baleanan ni Yesus. Ia piile' a watu men nongompodi baleanan iya'a notonsaalmo. ");
INSERT INTO blzNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mbaka' i ia notumetende'mo mae' nansarak i Simon Petrus ka' murit men kolingu' ni Yesus ka' nambantilkon na ko'ona i raaya'a taena, “Biibiina Tumpu ia alamo mian na baleanan-Na ka' sian kai inti'i se' aana a nomokelaan.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kasi i Petrus tia murit men kolingu' ni Yesus iya'a nomae' na baleanan. ");
INSERT INTO blzNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Raaya'a rua' ira notumetende'mo, kasee murit men sa'angu'na iya'a ma'agorna tii Petrus mbaka' ia olukon notaka na baleanan. ");
INSERT INTO blzNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ia no'uminsoo' na lalomna baleanan ka' nontoa'i toik pobalun biibii indo'o kela-kela, kasee ia sian ninsoop. ");
INSERT INTO blzNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petrus notakamo nuntuntuni i ia kasi liuliu ninsoop na baleanan iya'a. Ia nimiile' toik pobalun indo'o kela-kela, ");
INSERT INTO blzNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ka' toik men isian na takala' ni Yesus sianta isian beebeel toik pobalun biibii iya'a, kasee na tampat sambanaan paraas soripi'na ka' nokolulunmo. ");
INSERT INTO blzNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kasi murit men olukon notaka iya'a uga' ninsoopmo ka' nimiile' ka' namarasaya. ");
INSERT INTO blzNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Pataka tempo iya'a i raaya'a sianpo ninginti'i upa men nitulis na Alkitaap se' Ia tio tumuo' soosoodo moko daa lapus.) ");
INSERT INTO blzNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Noko daa iya'a rua' murit ni Yesus iya'a nomule'konmo. ");
INSERT INTO blzNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kasee i Maria Magdalena nokumekerer na soripi'na baleanan iya'a ka' nowiri. Pintanga' wiri, ia no'uminsoo' na lalomna baleanan, ");
INSERT INTO blzNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kasi nimiile' rurua' malaa'ikat nopakean bubulak. Raaya'a no'umoruang na tampat men nomokelaan biibii ni Yesus, men sa'angu' paraas takala' ka' men sa'angu'na paraas sarat. ");
INSERT INTO blzNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malaa'ikat iya'a nimikirawarmo taena, “Ibu, nongko'upa i kuu se' wiri?” Ia simbati i Maria taena, “Biibiina Tumpungku ia alamo mian ka' sianta yaku' inti'i se' aana nomokelaan.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Noko daa norobu koiya'a, ia nolumingamo paraas tokurungna. Ia nimiile' isian i Yesus kere-kerer indo'o, kasee ia sian ninginti'i se' i Yesus iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Taeni Yesus, “Ibu, kadai se' wiri? Ime a sarakoon?” Maria mansarui se' mian iya'a papalimang na taman, mbaka' ia norobumo taena, “Tuan, kalu se' i kuu a men ningilimba' i Ia, bantilkon na ingku' too aana nomokelaanmuu i Ia kada' dolo'onku.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Taeni Yesus, “Maria!” Maria ningilingamo i Yesus kasi norobu na wurung Ibrani taena, “Rabuni!” (Aratina, Guru.) ");
INSERT INTO blzNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Taeni Yesus, “Alia mingintoni ka' mantaankon i Yaku', gause i Yaku' koo'po nomae' waara'a na Tamang-Ku na surugaa. Kasee rae' na poto'utusan-Ku ka' bantilkon na ko'ona i raaya'a se' koini'i Yaku' waara'amo na Tamang-Ku men Tamamuu, Alaata'alang-Ku ka' uga' Alaata'alamuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mbaka' i Maria Magdalena nomae'mo nambantilkon na murit ni Yesus se' i ia nimiile'mo Tumpu ka' nambantilkon se' Tumpu a men nambantilkon giigii' iya'a na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sarataa nomalommo, na ilio tumbena minggu iya'a, murit ni Yesus nobarimpungmo na sa'angu' laigan ka' giigii' soopan nisupat, gause i raaya'a layaonkon moomoola'na Yahudi. Ola-olan i Yesus notaka ka' nokumekerer na tanga'na i raaya'a ka' norobu taena, “Sulano bi ratong a tutuo'muu!” ");
INSERT INTO blzNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Noko daa norobu koiya'a, Ia nimpipiile'konmo lima-Na tia rusuk-Na na ko'ona i raaya'a. Sarataa nimiile' Tumpu, raaya'a nobelesmo. ");
INSERT INTO blzNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kasi i Yesus norobu na ko'ona i raaya'a soosoodo taena, “Sulano bi ratong a tutuo'muu. Yaku' ia posuu' Tama na surugaa, koiya'a uga' i Yaku' momosuu' i kuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kasi Ia nunduupi i raaya'a ka' norobu taena, “Laboti a Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kalu i kuu mangampuni dosana mian, dosana uga' ampunionna Alaata'ala. Ka' kalu i kuu sian mangampuni dosana mian, Alaata'ala uga' sian mangampuni dosana mian iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kasee i Tomas men malia' ngaanon Rapi' tonsoop sompulo' rua' murit ni Yesus, sian nobarimpung tia samba-sambana tempo i Yesus notaka. ");
INSERT INTO blzNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mbaka' murit ni Yesus men sambana norobumo ni Tomas taena, “Kai nimiile'mo Tumpu!” Kasee ia simbati i Tomas taena, “Kalu i yaku' sianpo nimiile' salanna paku' men na lima-Na ka' momokela rangkumku na bela men namaku'an iya'a, ka' sianpo mongkoyong belana rusuk-Na, mau koi upa yaku' sianta mamarasaya.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sarataa kowalu'na ilio, murit ni Yesus nopootatakaimo soosoodo na tampat iya'a, ka' i Tomas isian uga' tii raaya'a. Maune' giigii' soopan nisupat, kasee i Yesus notaka ka' nokumekerer na tanga-tanga'na i raaya'a kasi norobu tae-Na, “Tabea' na ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kasi i Yesus norobu ni Tomas tae-Na, “Piile' a limang-Ku ka' pokela a rangkuum ka'ita, soorkon a limaam ka' koyong a belana rusuk-Ku ka' aliamomo' i koo sian mamarasaya, kasee parasayamo!” ");
INSERT INTO blzNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ia simbati i Tomas taena, “Tumpungku ka' Alaata'alangku!” ");
INSERT INTO blzNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Taeni Yesus, “Gause i koo daa nimiile'mo i Yaku' mbaka' i koo noparasayamo. Barakaatan a mian men sian mimiile' i Yaku' kasee daa uga' mamarasaya.” ");
INSERT INTO blzNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Dauga' biai' soosoodo a upa kosamba' men ia wawau i Yesus piipiile' murit-Na men sian nitulis na kitap kani'i. ");
INSERT INTO blzNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kasee giigii' men na kitap kani'i nitulis kada' i kuu mamarasaya se' i Yesus iya'a a Tomundo' Pansalamatkon, Anakna Alaata'ala, ka' gause i kuu parasaya na Ko'ona, kuu mantausi tutuo' men pore pataka sidutu. ");
INSERT INTO blzNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Sarataa iya'a, Yesus dauga'na pensan soosoodo nintipiile' na murit-Na na Danau Tiberias. Koi kani'imari a tundunanna. ");
INSERT INTO blzNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sa'angu' tempo, pintanga' barimpung a ari Simon Petrus, Tomas men ngaanon uga' i Rapi', Natanael samba Kana men na Galilea, anak ni Zebedeus, ka' rua' murit ni Yesus men sambana, ");
INSERT INTO blzNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Taeni Simon Petrus, “Yaku' mae' mumuka' susum.” Ia simbati i raaya'a taena, “Kai lumolo'!” Mbaka' i raaya'a nolumakitmo na duangan. Kasee na sanondom iya'a, sianta upa men ia dapot i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sarataa ilio muntumbeimo bete', Yesus nokumekerermo na poso'oleon, kasee i raaya'a sian ninginti'i se' i Yesus itu'u. ");
INSERT INTO blzNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesus norobumo na ko'ona i raaya'a taena, “Oo anak-Ku! Kuu daa susuman?” Ia simbati i raaya'a taena, “Sian.” ");
INSERT INTO blzNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Taeni Yesus, “Tuong a puka'muu paraas uananna duangan, mbaka' i kuu bo moko'ule'.” Kasi i raaya'a nuntuong puka' iya'a, ka' puka' iya'a tamban sianmo ia poko i raaya'a nibubut gause biai' tuu' a susum nokana'. ");
INSERT INTO blzNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Murit men kolingu' ni Yesus norobu ni Petrus taena, “Tumpu mba'a itu'u!” Sarataa i Simon ninginti'i se' i Yesus itu'u, ia nimisokmo bokukumna (gause ia sian nobokukum), kasi notumumbur na danau. ");
INSERT INTO blzNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Murit men sambana nuntuntunimo waatu'u lumobos tia duangan gause daa sian oloa na katano'an, tongko' toro sa'atu meter, ka' banta-bantang iya'a, raaya'a uga' mumbubut puka'na men biai' tuu' susumna. ");
INSERT INTO blzNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sarataa notolobos, raaya'a nimiile' isian wara' men na wawona isian susum tia roti. ");
INSERT INTO blzNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesus norobumo na ko'ona i raaya'a tae-Na, “Ala ka' pangawawa le'emari susum toro pii men baasi kuu puka'.” ");
INSERT INTO blzNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus nasawe'mo na duangan kasi numbubut puka'na mae' paraas katano'an. Puka' iya'a buke' tia susum moola'. Wiwi'namo sa'atu limampulo' ka' totolu' susum. Ka' maune' biai' koiya'a, puka'na sian kino berak. ");
INSERT INTO blzNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus norobumo na ko'ona i raaya'a taena, “Mai mongkorowi.” Sianta sa'angu'po murit-Na men momoko mimikirawar se', “Ime i Kuu?” gause i raaya'a ninginti'i se' i Ia Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kasi i Yesus nangkarani' i raaya'a, ka' nangala roti iya'a ka' nongoboskon na ko'ona i raaya'a. Koiya'a uga' tia susum iya'a. ");
INSERT INTO blzNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ni'imo a koporotoluna i Yesus nintipiile' na murit-Na supu i Ia nipotuo'i noko daa lapus. ");
INSERT INTO blzNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Noko daa i raaya'a nongkorowi, Yesus norobumo ni Simon Petrus tae-Na, “Simon, anak ni Yohanes, tuutuu' a pongkolingu'koon i Yaku' labi tia pongkolingu'konna i raaya'a i Yaku'?” Ia simbati i Petrus taena, “Tuutuu' Tumpu. Kuu inti'i se' i yaku' mongkolingu'kon i Kuu.” Taeni Yesus, “Totobo' a dombang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kopinduanna i Yesus nimikirawar na ko'ona tae-Na, “Simon, anak ni Yohanes, tuutuu' i koo molingu'kon i Yaku'?” Ia simbati i Simon taena, “Tuutuu' Tumpu. Kuu inti'i se' i yaku' mongkolingu'kon i Kuu.” Yesus norobu na ko'ona tae-Na, “Totobo' a dombang-Ku.” ");
INSERT INTO blzNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Koporotoluna i Yesus nimikirawar na ko'ona tae-Na, “Simon, anak ni Yohanes, tuutuu' i koo mongkolingu'kon i Yaku'?” Petrus nasiongo'mo gause i Yesus nimikirawari i ia pataka porotolu. Mbaka' ia simbati i Petrus taena, “Tumpu, Tumpu minginti'i giigii'. Tumpu minginti'i se' i yaku' mongkolingu'kon i Tumpu!” Kasi i Yesus norobu na ko'ona tae-Na, “Totobo'mo a dombang-Ku. ");
INSERT INTO blzNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Imamat a men taeng-Ku', ka' uga' bantilkonon-Ku na ko'omuu se' tempo i koo dauga' anak malai i koo suuwung mamarot loloos, ka' mae' too mbaria a kikira'am. Kasee kalu i koo langkai'mo to'ipi, koo monsoorkon limaam ka' mian sambana a men mongkoot i koo ka' mangawawa i koo na tampat men sian kikira'am bo rae'an.” ");
INSERT INTO blzNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus nangaan koiya'a kada' bo mompopo'inti'ikon se' koi upa a lalapus ni Petrus bo pompobalaki' Alaata'ala. Noko daa iya'a ai Yesus norobumo ni Petrus tae-Na, “Lolo' i Yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tempo i Petrus noluminga, ia piile' isian murit men kolingu' ni Yesus nuntuntuni i raaya'a. Iamo a murit men no'umoruang beebeel i Yesus na tempo i raaya'a pintanga' kumaan ka' men nimikirawar taena, “Tumpu, ime a mianna men bo mongorookon i Kuu kada' papateion?” ");
INSERT INTO blzNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sarataa nimiile' murit iya'a, Petrus nimikirawarmo ni Yesus taena, “Tumpu, upa a men bo sida na ko'ona kani'i?” ");
INSERT INTO blzNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ia simbati i Yesus tae-Na, “Kalu se' i Yaku' mingkira' kada' ia tumuo' pataka i Yaku' taka soosoodo, taasi'po i koo a pinginti'i. Kasee i koo, lolo' i Yaku'!” ");
INSERT INTO blzNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mbaka' notolelemo na murit ni Yesus se' murit iya'a men kolingu' ni Yesus sianta lapus. Men tuutuu'na i Yesus sian nangaan se' murit iya'a sian lapus, kasee men Ia ngaan, “Kalu i Yaku' mingkira' kada' ia sian lapus pataka i Yaku' taka soosoodo, taasi'po i koo a pinginti'i.” ");
INSERT INTO blzNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iamo a murit men nompopo'inti'ikon giigii' men nosida kani'i ka' giigii' iya'a ia a men nuntulis. Ka' kita ninginti'i se' upa men ia tundunkon na tulisanna kani'i tuutuu'. ");
INSERT INTO blzNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Dauga' biai' a upa sambana men ia wawau i Yesus. Kalu se' giigii' iya'a tulison sa'angu'-sa'angu', surionku sianta sukup a tampat na longkop tano' balaki' bo pomokelaan kitap men bo tulison iya'a.");
INSERT INTO blzNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilus! Na kitapku men tumbena, yaku' nuntulis wiwi'na men ia limang ka' ia pisiso'kon i Yesus, ");
INSERT INTO blzNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","taka na ilio men nasawe'an-Na na surugaa. Koo'po tia Ia notonakat na surugaa, Ia nimisiso'mo poposuu'-Na men Ia poko rurukimo. Ia nimisiso'mo poposuu'-Na iya'a ia tulung Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sarataa Ia nunsuri repaan ka' nolapus, koi patompulo' ilio, tempo-tempo manasa Ia nintipiile' na poposuu'-Na se' i Ia notumuo'mo soosoodo. Ia nuntundunkon na ko'ona i raaya'a Batomundo'anna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na tempo i Ia nobarimpung kumaan tii raaya'a, Ia nambantilkon tae-Na, “Alia mamarerei Yerusalem. Peperai ino'o pataka Tama na surugaa mongorookon Alus Molinas men Ia toonkon, koi men Yaku' tundunmo mbaripian na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gause i Yohanes nansarani tia weer, see somo toro pii ilio, kuu bo saranionna Alaata'ala tia Alus Molinas.” ");
INSERT INTO blzNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tempo poposuu' nobarimpung tii Yesus, raaya'a nobapikirawar taena, “Tumpu, too koini'i Tumpu mo'uus mungule'kon batomundo'an na samba Israel?” ");
INSERT INTO blzNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ia simbati i Yesus tae-Na, “Tempo ka' ilio iya'a mosoo ka' inti'ionmuu, gause iya'a Tamang-Ku a bo pinginti'i. ");
INSERT INTO blzNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kasee i kuu bo mangalabot kuasa na tempo kotakaanna Alus Molinas na ko'omuu pataka minsidakon i kuu mompotuutuu' i Yaku'. Kuu bo mompopo'inti'ikon i Yaku' na Yerusalem, longkop Yudea, na Samaria, pataka longkop tano' balaki'.” ");
INSERT INTO blzNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Noko daa i Yesus nuntundun koiya'a, Ia notoleengketmo waara'a na surugaa potopiile' i raaya'a pataka kinolilungian na antong. ");
INSERT INTO blzNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dauga' potolengea' i raaya'a mimiile' i Yesus men ninakat, ola-olan isian rua' mian nobukukum bubulak nokumekerer na soripi'na i raaya'a ");
INSERT INTO blzNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ka' norobu taena, “Kuu samba Galilea, nokadai i kuu se' kumekerer kano'o ka' mengelelengea' langit? Yesus men namarereimo i kuu notonakat waara'a na surugaa bo mule'kon soosoodo koi men kuu piile' umba'a.” ");
INSERT INTO blzNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Noko daa koiya'a, poposuu' namarereimo Buu'na Zaitun ka' nomule'kon na Yerusalem. Buu'na iya'a na Yerusalem tongko' toro sa'angu' kilo. ");
INSERT INTO blzNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Taka na Yerusalem, raaya'a nomae'mo na laigan men notorumpakanna i raaya'a, ka' nasawe' na parawawo. Poposuu' iya'a i Petrus, Yohanes, Yakobus, Andreas, Filipus, Tomas, Bartolomeus, Matius, Yakobus anak ni Alfeus, Simon mian Zelot ka' i Yudas anak ni Yakobus. ");
INSERT INTO blzNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wiwi'irana sa'angu' noa, ka' sinampang barimpung basambayang tia toro pii wiwine, tonsoop tii Maria sina ni Yesus, ka' utus ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sa'angu'anmo ilio, isian toro sa'atu ruampulo' mian men parasaya na Tumpu nobarimpung. Kasi i Petrus norumingkat ka' norobu taena, ");
INSERT INTO blzNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Utu-utus! Upa men nitulis na Alkitaap, mase tio sida. Mbaripian tia kuasana Alus Molinas i Daud nuntundun i Yudas men nosida bo pambaarkon mian mangarakop i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas iya'a tonsoop mian kai-kaimo, ka' uga' nobalimangmo tii kai.” ");
INSERT INTO blzNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Tambona limang ni Yudas men ba'idek kani'i a men ia ilikon tano'. Ia tinomparangop, kasi nolapus. Kompongna kinobotak ka' isiina tinonsupa' wiwi'na. ");
INSERT INTO blzNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Giigii' mian na Yerusalem ninginti'i lele iya'a. Ya'amo mbali' raaya'a nangaani tano' iya'a koi wurungna i raaya'a, Hakal Dama, men aratina “Tano' Rara'”.) ");
INSERT INTO blzNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Taeni Petrus, “Na kitap Mazmur isian nitulis koi kani'imari, ‘Poliingi a dodongoanna; alia dauga' sa'angu'po mian a mondodongoi.’ Isian soosoodo nitulis koi kani'imari, ‘Dalai bi alaa mian a oruanganna.’ ");
INSERT INTO blzNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Mbaka' koini'i kita tio mansarak mian bo pombolosi i Yudas kada' poosambai tii kai mompotuutuu' se' i Yesus notuo'mo soosoodo. Kasee mian iya'a tio men doodoopo ruru-ruru' tii kai mongololo' i Yesus, sarataapo i Yohanes nuntumbei nansarani mian pataka tempo notonakatan ni Yesus mbaara'a surugaa namarerei i kai.” ");
INSERT INTO blzNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kasi raaya'a ninsiso' rua' mian men bo rurukion: i Yusuf men ngaanon i Barsabas (men mbalia' ngaanon i Yustus), tii Matias. ");
INSERT INTO blzNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Raaya'a wiwi'na nosambayang taena, “Oo Tumpu, Kuu minginti'i noana mian wiwi'na. Siso'kon sulano too ime a men rurukion-muu men rua' ira kani'i, ");
INSERT INTO blzNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","bo pangalabot palimangonna poposuu' men ia parereimo i Yudas, gause i ia nungurumpakimo balaa' men sintutu' bo ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kasi raaya'a nungundi mian men rua' ira, ka' men nokana' undi ai Matias. Tongko' daa koiya'a, ia uga' niturangikonmo poposuu' men sompulo' sa'angu' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na ilio Ramean Pentakosta, giigii' mian parasaya nobarimpung na sa'angu' tampat. ");
INSERT INTO blzNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ola-olan no'ioosan koi boyus nda'amari langit tamban laungna boolak na lalomna laigan men no'umoruanganna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kasi raaya'a nimiile' biai' upa men koi sila' kasee kumait ka' nosingkaamburan mintingke'i raaya'a sanda-sanda'. ");
INSERT INTO blzNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Raaya'a ia barios Alus Molinas, ka' i raaya'a nobatundunmo biai' wurung men taasi' wurungna i raaya'a. Sanda-sanda' i raaya'a norobumo koi men ia rookon Alus Molinas bo porobukononna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tempo iya'a biai' a samba Yahudi men pa'agama na toro pii lipu' notumaka ringkat na ko'oloaan. Raaya'a uga' isian na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sarataa mian biai' nongorongor laung iya'a, raaya'a nangkarani'mo mian parasaya iya'a. Raaya'a tinongkodi' ka' nosamba' nongorongor se' wurungna i raaya'a sanda-sanda' men wurungkononna mian parasaya indo'o. ");
INSERT INTO blzNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Raaya'a notangangmo ka' taena, “Mian men batundun karaale'e mase samba Galilea. ");
INSERT INTO blzNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Koi upa kosidana mian karaale'e se' daa sida munguwurungkon koi wurung men na lipu' ringkatanta? ");
INSERT INTO blzNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kita men samba Partia, Media, Elam, mianna Mesopotamia, Yudea, Kapadokia, Pontus ka' Asia, ");
INSERT INTO blzNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia, Mesir ka' mian na libutan Libia men pookarani' Kirene, mian men notumaka ringkat na Roma, ");
INSERT INTO blzNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(mau samba Yahudi ka' uga' lipu' sambanaan men ninsoopmo Agama Yahudi), samba Kreta, samba Arab. Kita wiwi'na mongorongor i raaya'a batundun tia wurungta, muntundun wawau kosamba' men ia pipiile'kon Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Raaya'a giigii' nosamba'mo ka' notangang, kasi nopootundunii taena, “Upa aratina men koi kani'i?” ");
INSERT INTO blzNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kasee mian sambana tongko' mingiroki taena, “Mian karaaya'a pintanga' lio'kon anggur.” ");
INSERT INTO blzNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mbaka' norumingkatmo i Petrus tia sompulo' sa'angu' poposuu', ka' tia wurung men lansoongan ia norobu na mian biai' taena, “Utu-utus samba Yahudi tii kuu wiwi'na mian na Yerusalem! Porongor ka' intoomkon a wurungku kani'imari. ");
INSERT INTO blzNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mian karaani'i taasi' lio' koi pansaruimuu, gause ilio baasi jaam sembilan ma'ulo-ulop. ");
INSERT INTO blzNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kasee ya'amo a men ia bantilkon Alaata'ala ka' ia tundun i Nabii Yoel mbaripian koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Taena Alaata'ala, ‘Na ilio kokomburi'anna, Yaku' bo mongorookon Alus Molinas-Ku bona giigii' mian. Anakmuu wiwine moro'one bo mongorongor wurung-Ku ka' muntundunkon na ko'omuu. Anakmuu men malai bo pipiile'ion-Ku simpalaalung, ka' minti'imuu bo mingipi men Yaku' popo'ipikon na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ka' na ilio iya'a, Yaku' bo mongorookon Alus Molinas-Ku na mian men posuu'on-Ku, moro'one tia wiwine; i raaya'a bo mongorongor wurung-Ku ka' muntundunkon na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yaku' bo mangawawau biai' upa kosamba' nda'a na langit ka' oosan na tano' kani'i, koimo rara', apu ka' tibuk matabo' sangkompol-sangkompol. ");
INSERT INTO blzNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Matana ilio bo sida pikit tuu', ka' wulan somo koi rara', mongolukoni kotakaanna ilionna Tumpu men balaki' ka' pore. ");
INSERT INTO blzNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tempo iya'a, ime a men parasaya ka' miki tulung na Tumpu, ia salamatkonon.’ ");
INSERT INTO blzNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Utu-utus samba Israel! Porongori a wurungku kani'imari: Yesus samba Nazaret iya'a mase mian men ia potuutuu' Alaata'ala na ko'omuu. Alaata'ala nomokau i Ia ningilimang men kosamba', ka' oosan koi men kuu inti'imo. ");
INSERT INTO blzNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesus men ia rookon Alaata'ala koi panduung-Na ka' sagia-Na, kuu papateimo, gause i kuu namatalai mian men ba'idek a gau'na nansaliipkon i Ia. ");
INSERT INTO blzNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kasee Alaata'ala nomotuo'i i Ia noko daa lapus. Alaata'ala nunguarkon i Ia na kolapusan, gause kolapusan sian momoko mungkuasai i Ia pataka manau'. ");
INSERT INTO blzNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ka' i Yesus, isian uga' ia tundun i Daud taena, ‘Yaku' nimiile' Tumpu sinampang na aropku. Ia isian na uananku, mbali' daa i yaku' sianta pokoonna upa sege-segeion. ");
INSERT INTO blzNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mbali' iya'a, noangku beles. Yaku' muntunde' Tumpu, ka' wakangku bo mempeperai men ooskononku na Ko'ona, ");
INSERT INTO blzNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","gause Tumpu sianta mandalai i yaku' tontako' na dodongoanna mian lapus, ka' i Kuu sianta momoturang poposuu'-Muu men malolo' iya'a munsuri kosilaka'an. ");
INSERT INTO blzNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kuu nuntundunkon na ingku' sasalanna tutuo'; Kuu mangawawau i yaku' beles na arop-Muu.’ ");
INSERT INTO blzNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Utu-utus! Yaku' batundun losop-losop na ko'omuu muntundun i Daud men pulina lipu'ta. Ia nolapusmo ka' nitanom, ka' baleananna dauga' isian pataka koini'i. ");
INSERT INTO blzNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kasee ka' i Daud iya'a sa'angu' nabii, mbaka' ia ninginti'i se' Alaata'ala nontoon i Ia tia sumpa' se' Alaata'ala bo momo'oruang sa'angu' mian men lee'na bo sida tomundo' koi ia. ");
INSERT INTO blzNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mbali' iya'a ia noko pimiile'mo men na olukon, ka' nuntundun pomotuo'ian soosoodo i Tomundo' Pansalamatkon, koi men taena, ‘Ia sianta tontako' na dodongoanna mian lapus ka' waka-Na sianta baras.’ ");
INSERT INTO blzNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesusmo kani'i a men ia potuo'i Alaata'ala, ka' i kai wiwi'na a nimiile'. ");
INSERT INTO blzNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ka' sarataa i Ia ia po'oruang Alaata'ala paraas uanan-Na, Ia nangalabot Alus Molinas men nitoonkon, kasi Ia rookon na mian biai'. Men kuu rongor ka' kuu piile' umba'a, mase Alus Molinas men ia rookon i Yesus na ko'omai. ");
INSERT INTO blzNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Taasi' se' i Daud a men nasawe' na surugaa, kasee i ia tongko' nuntundun koi men taena, ‘Alaata'ala isian nangaan na Tumpungku tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“Alaka' oruang na paraas uanan-Ku, pataka Yaku' mompoporungku' giigii' mian men mangka'idek i Koo sida malolo' na Ko'oom.” ’ ");
INSERT INTO blzNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mbali' iya'a giigii' samba Israel tio tuutuu' minginti'i se' Alaata'ala nangawawaumo i Yesus men kuu saliip iya'a nosidamo Tumpu ka' Tomundo' Pansalamatkon.” ");
INSERT INTO blzNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sarataa i raaya'a nongorongor se' koiya'a a sasalanna, raaya'a nunsurimo se' i raaya'a sala' ka' ninsosol, kasi nimikirawar ni Petrus tia poposuu' men sambana taena, “Utu-utus! Kalu se' koiya'a, tio koi upa men wawauonmai?” ");
INSERT INTO blzNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Taeni Petrus, “Sosoli ka' kadarai a gau'muu men ba'idek. Kuu sanda-sanda' tio saranion mangaan ngaan ni Yesus Kristus, kada' dosamuu ampunion ka' i kuu sida mangalabot Alus Molinas men rookononna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gause Alus Molinas men ia toonkon Alaata'ala iya'a mase bo ko'omuu pataka na lee'muu, ka' uga' bona mian men isian na dodongoan oloa men bo leelo'onna Tumpu Alaata'ala taka na Ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Koiya'a a men ia tundunkon i Petrus na ko'ona i raaya'a. Ka' uga' tia tundunan sambana, ia nangama-amati kada' i raaya'a minti rensa na lipu' men ba'idek iya'a, men bo ukumonna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mian men nangalabot wurung ni Petrus nisaranimo, ka' na ilio iya'a, mian men parasaya nokanturanganmo toro tolu' loloon mian. ");
INSERT INTO blzNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Raaya'a rampot na pisiso'na poposuu' ka' malia' pootatakai. Raaya'a sinampang kumaan ruru-ruru' ka' basambayang. ");
INSERT INTO blzNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tempo mian biai' nimiile' biai' a upa kosamba' tia oosan men wawauonna poposuu', mian biai' iya'a nosamba'mo. ");
INSERT INTO blzNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ka' giigii' mian men noparasayamo uga' sinampang poowawa pore, ka' giigii' upa men isian na ko'ona i raaya'a, wiwi'na mian a pontombonoi. ");
INSERT INTO blzNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ka' isian i raaya'a men mambalukkon kupangna ka' mongobo-oboskon na mian wiwi'na koi men paraluuionna i raaya'a sanda-sanda'. ");
INSERT INTO blzNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Raaya'a sianta kobangaran kasee sanga-sangada barimpung sanda' ilio na Laiganna Alaata'ala. Raaya'a mungurumpi-rumpik roti ka' kumaan ruru-ruru' na laiganna i raaya'a sanda-sanda' poopoobobolos. Raaya'a beles ka' noana i raaya'a uga' ma'amat na mian. ");
INSERT INTO blzNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Raaya'a muntunde' Alaata'ala ka' kolingu'na mian. Sanda' ilio koturangian a kobiai'na mian men salamatkononna Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sa'angu' ilio, montorumpaki tempo bo sambayangan, jaam tiga maamaalom, ninsoopmo i Petrus tii Yohanes na Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Indo'o raaya'a nimiile' isian sa'angu' moro'one men tiodaa bo ueronna mian gause repo' ngame-ngamea'po. Sanda' ilio mian repo' iya'a atoron ka' pokelaon karani' soopanna Laiganna Alaata'ala men ngaanon, Soopan Pore, kada' mo'ase'-ase' na mian men minsoop na Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sarataa mian repo' iya'a nimiile' i Petrus tii Yohanes bo minsoop na Laiganna Alaata'ala, ia nama'ase'mo. ");
INSERT INTO blzNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petrus tii Yohanes rontos nintioki i ia, kasi taeni Petrus, “Tioki i kai.” ");
INSERT INTO blzNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kasi mian repo' iya'a nintioki ari Petrus. Na noana i ia mongooskon too daa isian upa men bo rookononna i raaya'a na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Taeni Petrus, “Mosoni tia salaka' sianta isian na ingku', kasee daa upa a men isian na ingku' rookononku na ko'oom. Mimpu'u na kuasa ni Yesus Kristus samba Nazaret, alaka' tumpang!” ");
INSERT INTO blzNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kasi ia sangkum i Petrus a limana uanan ka' niparaandaki norumingkat. Tempo iya'a uga' sarat tia bokulalina nopoonggormo. ");
INSERT INTO blzNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ia noporoditan rumingkat ka' notumumpang waale'e-le'emari. Kasi ia nongololo' ari Petrus minsoop na Laiganna Alaata'ala. Ia notumumpang ka' molaalonggo' kasi muntunde' Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wiwi'na i raaya'a uga' nimiile' i ia tumpa-tumpang muntunde' Alaata'ala, ");
INSERT INTO blzNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ka' raaya'a uga' ninginti'i se' mianmo iya'a a men mala' umoruang na “Soopan Pore” na Laiganna Alaata'ala mo'ase'-ase' na mian. Mbali' iya'a raaya'a samba' ka' tangang gause nimiile' upa men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mian men sianmo repo' iya'a ningintoni i Petrus tii Yohanes ka' kinololo-lolo'namo tii raaya'a. Tempona i raaya'a tolu' ira notaka na gandaria men ngaanon “Gandaria Salomo”, wiwi'na mian taka pototende' nintikumi i raaya'a gause samba' tuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Sarataa i Petrus nimiile' mian men nintikumi i raaya'a, ia norobumo taena, “Oo samba Israel! Nongko'upa i kuu se' samba'kon wawau kani'i. Nongko'upa i kuu se' tongko' poto tiok na ko'omai, gause mian men nomokomo tumumpang kaya'a taasi' se' kuasamai a ninsidakon, ka' taasi' se' montookon i kai malolo' na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Alaata'ala men soosa'on ni Abraham, Ishak, ka' i Yakub, pulinta, nangangga'imo mian-Na men i Yesus. Mian-Na iya'a kuu rookon na pungkuasai mian, ka' kuu kokundai na arop ni Pilatus. Tempo iya'a bookoi i Pilatus mo'uus munguarkon i Ia. ");
INSERT INTO blzNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ia Mian Molinas ka' Ma'amat. Kasee i kuu nongkokundai i Ia ka' nampari-pari kada' i Pilatus tio mongololoikon pa'ase'muu, men munguarkon sa'angu' mian men bukuan mampapatei mian. ");
INSERT INTO blzNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kuu nampapateimo i Ia, kasee tuutuu'na, Ia a men pimpu'uanna katuo'anna giigii' mian. Alaata'ala nomotuo'imo i Ia noko daa lapus. Wiwi'na iya'a kai poko piile'mo. ");
INSERT INTO blzNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kuu daa nimiile'mo ka' ninginti'imo upa a men ninsidakon mian kani'i sianmo repo'. Ia noonggormo ka' nalesi'mo gause i ia noparasayamo ni Yesus tia kuasa-Na. Gause ia parasaya ni Yesus, mbaka' mian kani'i tuutuu' nalesi'mo koi men kuu piile' koini'i. ");
INSERT INTO blzNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Utu-utus! Yaku' inti'i se' i kuu tia tanaasmuu nangawawaukon i Yesus tia wawau men sian kuu inti'i. ");
INSERT INTO blzNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kasee wawaumuu men koiya'a ninsidakonmo upa men ia bantilkon Alaata'ala mbaripianpo na nabii-Na se' Tomundo' Pansalamatkon men nitoonkonmo tiodaa munsuri repaan. ");
INSERT INTO blzNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Utu-utus! Mbali' iya'a, sosoli ka' kadaraimo a wawaumuu men ba'idek, ka' parasaya a Alaata'ala kada' sapuion-Na wiwi'na dosamuu, ");
INSERT INTO blzNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ka' kada' Tumpu minsidakon i kuu pore a noamuu. Ka' i Ia bo momosuu' i Yesus men ia tukokonmo Alaata'ala bo Tomundo' Pansalamatkon i kuu. ");
INSERT INTO blzNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ia sianpo sida mamarerei surugaa pataka Alaata'ala mungule'kon wiwi'na na dunia koi men tumbe, ka' koi men Ia bantilkonmo na toro pii nabii-Na mbaripianpo. ");
INSERT INTO blzNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa isian nangaan taena, ‘Alaata'ala Tumpumuu bo manganakat sa'angu' nabii na ko'omuu men simbaya'muu sa'angu' lipu', koi i Ia nomosuu' i yaku'. Kuu tiodaa momorongori wiwi'na upa men ia bantilkon nabii iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mian men sian mingimamat upa men ia bantilkon nabii iya'a, mian inono' bo rensakonon oloa na mian men parasayamo na Alaata'ala, ka' silaka'ion.’ ");
INSERT INTO blzNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nabii Samuel tia nabii men komburi', wiwi'na nuntundunkonmo upa men nosidamo tempo koini'i. ");
INSERT INTO blzNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Toonna Alaata'ala men ia bantilkon nabii iya'a, mase bo ko'omuu. Toon men ia wawaumo Alaata'ala tia pulimuu i Abraham koi kani'imari: ‘Ringkat na lee'em, Yaku' bo mambarakaati wiwi'na lipu' na tano' balaki' kani'i.’ ");
INSERT INTO blzNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ya'a mbali' Alaata'ala nungururuki mian-Na ka' nomosuu' i Ia taka na ko'omuu olukon kada' i kuu barakaation-Na. Barakaat-Na koi kani'imari: Ia minsidakon i kuu monsosoli ka' mangkadarai wawaumuu men ba'idek.” ");
INSERT INTO blzNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pintanga' morobu i Petrus tii Yohanes na mian biai', ola-olan taka a toro pii imam tia tanaasna dadagai Laiganna Alaata'ala ka' mian Saduki nomootuungi i Petrus tii Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Raaya'a maso' gause i Petrus tii Yohanes nambantilkon na mian biai' se' i Yesus notuo'mo soosoodo ka' iya'a koi sa'angu' pinginti'ian se' mian lapus dauga' tumuo' soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mbaka' i raaya'a nangarakopmo rurua' poposuu' iya'a ka' nonsoopkon na tarungkuan. Gause malommo, Petrus tii Yohanes dauga' nitaankon na tarungkuan pataka koi liilana. ");
INSERT INTO blzNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kasee biai' a mian men nongorongor pisiso'na poposuu' iya'a nosida mian parasaya. Mbaka' saa'na i raaya'a nokanturanganmo; isian toro lima' loloon mian moro'one. ");
INSERT INTO blzNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Koi liilana, mianna Mahkama Agama tonsoop tanaasna agama, tia motu-motu'a na samba Yahudi ka' wawa ukum Torat nopootuu'imo na Yerusalem bo pootundunii. ");
INSERT INTO blzNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Raaya'a nomae'mo ni Hanas, Imam Moola', ka' i Kayafas, Yohanes, Aleksander ka' tia giigii' mian sambana men tonsoop poto'utusanna Imam Moola'. ");
INSERT INTO blzNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kasi i Petrus tii Yohanes niwawa na ko'ona i raaya'a kasi nipikirawari taena, “Koi upa mbali' daa kuu poko a nengelesi'i mian repo' kaya'a, kabai se' nimpu'u ni ime i kuu nangawawau men koiya'a?” ");
INSERT INTO blzNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petrus ia barios Alus Molinas ninsimbati taena, “Tuan tanaasna lipu' tia tuan mianna Mahkama! ");
INSERT INTO blzNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ilio kani'i, kai ni'ukumi gause nangawawau upa pore nuntulung sa'angu' mian repo' ka' gause ari tuan mo'uus minginti'i koi upa a mian iya'a nilesi'i. ");
INSERT INTO blzNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mbaka' kada' bo inti'ionmuu tuan ka' giigii' samba Israel, mbali' daa mian kani'i kere-kerer nalesi'mo koi men kuu piile' koini'i, mase kuasa ni Yesus Kristus samba Nazaret iya'a. Yesus iya'a kuu saliipkonmo, kasee Alaata'ala nomotuo'imo i Ia noko daa lapus. ");
INSERT INTO blzNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesusmo kani'i a men nitulis na Alkitaap, ‘Watu men kuu balo'konmo tukang, poali nosidamo watu tuko men bo pandasi.’ ");
INSERT INTO blzNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Sianta sa'angu'po mian men sida mansalamatkon saliwakon i Yesus. Gause giigii' mian na longkop tano' balaki', sianta mian sambana men ia pokau Alaata'ala bo pansalamatkon i kita.” ");
INSERT INTO blzNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mianna Mahkama iya'a samba' nimiile' kabaranian ni Petrus tii Yohanes gause ia inti'i i raaya'a, rua' ira iya'a tongko' mian biasa, sianta nosikola alayo'. Kasi ia too'inau' i raaya'a se' rurua' mian iya'a samba-samba ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Raaya'a sianmo norobu upa-upa gause mian men nilesi'i iya'a mondo'o kere-kerer na aropna i raaya'a tii Petrus ka' i Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mbaka' ia posuu'mo i raaya'a i Petrus tii Yohanes umuar, mamarerei tampat Pungukumian, kasi i raaya'a noposangadai. ");
INSERT INTO blzNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Taena, “Upaiontamo a mian karaaya'a? Wiwi'na mian na Yerusalem ninginti'imo se' wawau men kosamba' tuu' iya'a ia wawau i raaya'a rua' ira. Sian sidaonta pokosianon. ");
INSERT INTO blzNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kasee kada' wawau iya'a sian tolele na mian biai', mbaka' i raaya'a rua' ira tiodaa arasonta kada' sianmo sida batundun na mian mangaan ngaan ni Yesus.” ");
INSERT INTO blzNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mbaka' rurua' poposuu' iya'a nileelo'mo minsoop soosoodo, kasi nirorongi se' sianmo sida batundun kabai mimisiso' mangaan ngaan ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kasee ia simbati i Petrus tii Yohanes taena, “Intoomkon pore-pore a men daa kokana'na Alaata'ala: mongololoikon po'uus nari tuan kabai mongololoikon po'uusna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gause i kai sian sida mongkorokotkon upa a men kai piile'mo ka' upa a men kai rongormo.” ");
INSERT INTO blzNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mbaka' rurua' poposuu' iya'a ia arasmo mianna Mahkama soosoodo ka' niposuu' mule'kon, gause i raaya'a sian nantausi salan bo pungukum i Petrus tii Yohanes men sian paraa mantakakon kogora'an na mian biai' men muntunde' Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mian men nilesi'i tia wawau kosamba' iya'a labimo patompulo' taun a umurna. ");
INSERT INTO blzNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sarataa i Petrus tii Yohanes nipatalai nomae', raaya'a nomule'konmo na samba-sambana ka' nuntundunkon wiwi'na upa men ia bantilkon tanaasna imam tia moomoola'na samba Yahudi na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sarataa samba-sambana nongorongor koiya'a, raaya'a nosa'angu'mo noa ka' nosambayang na Alaata'ala taena, “Tumpu, Kuu a men nangawawau langit ka' tano' balaki' ka' tobui tia giigii' isiina. ");
INSERT INTO blzNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Alus-Muu men Molinas a ninsidakon mian-Muu men i Daud pulimai nuntundunkon wurung-Muu men taena, ‘Nongko'upa se' maso' a mian biai' men sian parasaya na Alaata'ala? Nongko'upa se' biai' a lipu' sambana mangawawau sagia men sianta kana'na? ");
INSERT INTO blzNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tomundo' na tano' balaki' batoropot batumburi, ka' tanaas basangada mintimban Tumpu tia Tomundo' Pansalamatkon.’ ");
INSERT INTO blzNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gause i Herodes tii Pontius Pilatus tuutuu' nopoosangadaimo tia lipu' sambana ka' samba Israel na kota kani'i. Raaya'a nosangadamo mongkokundai i Yesus, mian-Muu men Molinas men Kuu nakatmo sida Tomundo' Pansalamatkon. ");
INSERT INTO blzNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Raaya'a poosangadai mongkokundai i Yesus koi men Kuu ngaanmo na olukonanpo men sabole bo sida, upa a men Kuu ngaanmo iya'a mimpu'u na kuasa ka' po'uus-Muu. ");
INSERT INTO blzNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Koini'i Tumpu, piile'! Raaya'a mangaras i kai. Tarai i kai salan kada' i kai mian-Muu kani'i momoko mae' mengelelekon lele-Muu. ");
INSERT INTO blzNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kai miki tulung kada' mian manggeo sida malesi', ka' pipiile'kon a oosan tia upa kosamba' men sida tia kuasa ni Yesus, mian-Muu men Molinas iya'a.” ");
INSERT INTO blzNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Noko daa i raaya'a nosambayang, laigan men nopootatakaianna notoyunggotmo. Raaya'a wiwi'na ia lingkuduimo Alus Molinas ka' nomokomo nambantilkon lelena Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tutuo'na giigii' mian men noparasayamo nosa'angu'mo noa ka' nosa'angu'mo pikiran. Sianta sa'angu'po mian men munsurikon se' upa men isian na ko'ona, tongko' i ia pontombonoi, kasee tombonoionna i raaya'a sanga-sangada. ");
INSERT INTO blzNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Poposuu' iya'a isian kuasana Tumpu pataka i raaya'a nompotuutuu' se' i Yesus notuo'mo soosoodo, ka' balaki' tuu' a kaporeanna Alaata'ala na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tutuo'na i raaya'a sa'angu'po sianta men marepa gause ime a men isian tano' kabai se' laigan, balukkononna ka' ilina wawaonna i raaya'a, ");
INSERT INTO blzNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kasi rookonon na poposuu'. Raaya'asi a mongobo-oboskon na sanda' mian men mamaraluui. ");
INSERT INTO blzNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Koiya'a uga' i Yusuf. Ia sa'angu' mian men lee' ni Lewi men ringkat na Siprus. Poposuu' nangaani ia i Barnabas (aratina Pantata'u). ");
INSERT INTO blzNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ia uga' nambalukkon tano'na, kasi ilina ia wawa ka' nirookon na poposuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kasee isian mian men ngaanna i Ananias. Ia tia boroki'na i Safira, uga' nopoosangadai nambalukkon tano'na i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ka' sanggiran ilina tano' iya'a, ia sangadakonmo motoboroki' ka' ninaa'. Kasi men sanggiran ia wawamo ka' nirookon nari poposuu' bo persembaahanna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kasee taeni Petrus, “Ananias, kadai i koo se' pokoonna Ibiliis rungku'ion? Koo nomborekimo Alus Molinas gause i koo nanganaa'mo ilina tano'om men sanggiran. ");
INSERT INTO blzNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Koo'po tia tano'om koo balukkon, koo a tombono, ka' sarataa koo balukkon, ilina uga' i koo a bo pinginti'i. Nongko'upa se' i koo nansagia ka' ningilimang men koiya'a? Taasi' i kai a men koo boreki kasee Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tempo nongorongor wurung ni Petrus, Ananias tinombabasmo ka' nolapus. Mbaka' giigii' mian men nongorongor lele iya'a nolayaonmo tuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sarataa nimiile' upa men nosida, toro pii anak malai nuntuu'imo ka' nambalun biibii ni Ananias, kasi nunguarkon ka' mae' nantanom. ");
INSERT INTO blzNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Toro tolu' jaam a noporusanna, boroki' ni Ananias ninsoopmo, kasee i ia sianpo ninginti'i upa men nosida na langkai'na. ");
INSERT INTO blzNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Mbaka' taeni Petrus na ko'ona, “Tundunkon i yaku' too tongko' koi kani'i a ilina tano'muu?” Ia simbati boroki' ni Ananias taena, “Tuutuu', tongko' nono-nono'na.” ");
INSERT INTO blzNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Taeni Petrus, “Nokadai i kuu motolangkai' se' sangada mimitopongi Alusna Tumpu? Rongor! Mian men nantanom langkai'im isianmo karaale'e na liwana soopan. Koo uga' bo ueronna i raaya'a ka' uarkonon.” ");
INSERT INTO blzNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tongko' koiya'a i ia liuliu notonsumpul karani' sarat ni Petrus lako-lako nolapus. Ka' sarataa ninsoop a anak malai, ia takai raaya'a, boroki' ni Ananias noko lapusmo. Anak malai iya'a nunguermo ka' nunguarkon boroki' ni Ananias kasi mae' nantanom na soripi'na langkai'na. ");
INSERT INTO blzNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nongorongor lele iya'a, giigii' mian na jama'at tia mian sambana nolayaonmo tuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Biai' oosan tia upa kosamba' men wawauonna poposuu' na mian biai'. Giigii' mian parasaya poowawa pore ka' sinampang barimpung na gandaria ni Salomo na Laiganna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kasee mian men sian parasaya na Tumpu, babata pooruru' tii raaya'a. Mian men parasaya na Tumpu angga'ionna tuu' mian. ");
INSERT INTO blzNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kaekae' manau' kaekae' kanturangan a mian men parasaya na Tumpu, mau wiwine ka' uga' moro'one. ");
INSERT INTO blzNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Gause wawau nari poposuu' iya'a, mbaka' mian men manggeo wawaon na salan ka' pokelaon na tokolanna kabai se' na ampas, kada' koo'mo tii koo', koliuan ni Petrus, sulano kana'onna loolungna. ");
INSERT INTO blzNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mian men na tiku-tikumna kota Yerusalem bakalaituntun taka mangawawa mian manggeo ka' men lampingionna meena, ka' wiwi'na men koiya'a sida nalesi'. ");
INSERT INTO blzNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kokomburi'anna, Imam Moola' tia giigii' mianna men tonsoop mian Saduki, nangawawaumo kogora'an gause i raaya'a masindirkon ari poposuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Raaya'a nangarakopmo ari poposuu' ka' nonsoopkon na tarungkuan men isian na kota. ");
INSERT INTO blzNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kasee malomna, sa'angu' malaa'ikatna Tumpu nengeleakimo soopanna tarungkuan, ka' nunguarkon ari poposuu' iya'a kasi taena, ");
INSERT INTO blzNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Rae' i kuu na Laiganna Alaata'ala ka' bantilkon mian biai' a giigii' lele men mantakakon tutuo' u'uru.” ");
INSERT INTO blzNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mbaka' ari poposuu' uga' nongololoikonmo koi men ia bantilkon malaa'ikat iya'a. Ma'ulo-ulop tuu', raaya'a nomae'mo na Laiganna Alaata'ala, ka' nuntumbei nimisiso' mian indo'o. Pintanga' iya'a, Imam Moola' tia mianna notakamo, mangawawau sidang mahkama tia giigii' tanaasna lipu' Israel. Kasi raaya'a nomosuu' mian mae' mondolo' ari poposuu' men na tarungkuan iya'a, kada' taka na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kasee sarataa notaka na tarungkuan a mian men niposuu' mondolo' iya'a, ia takai i raaya'a ari poposuu' sianmo indo'o. Mbaka' i raaya'a somo nomule'kon na mahkama ka' nambantilkon upa men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Taena, “Kai takai a soopanna tarungkuan poto'ompor ka' nisupat pore-pore ka' uga' wiwi'na mian men mandagai soopan moraando'o. Kasee sarataa kai leaki a omporonna, kai sian nimiile' sa'angu'po mian na lalomna.” ");
INSERT INTO blzNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sarataa tanaasna dadagai Laiganna Alaata'ala tia tanaasna imam nongorongor upa men nibantilkon iya'a, raaya'a no'orobankonmo ari poposuu' iya'a too upa men bo sida. ");
INSERT INTO blzNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Soro' koiya'a, notakamo a sa'angu' mian nangawawa lele taena, “Rongor kutung! Mian men ia tarungku i tanaas, koini'i pintanga' mimisiso' mian biai' na Laiganna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mbaka' tanaasna dadagai Laiganna Alaata'ala tia mianna, mae' nondolo' ari poposuu' soosoodo, kasee raaya'a sian nansambumo, gause layaon too mian biai' mangalapak i raaya'a tia watu. ");
INSERT INTO blzNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ari poposuu' nisoopkonmo na mahkama, kasi Imam Moola' namaresa i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Taena Imam Moola', “Laampo' kai poko bantilkonmo se' i kuu sianmo tuu' sida mimisiso'kon i Yesus na mian? Kasee piile' a limangmuu kani'i! Kuu nimisiso'mo mian longkop Yerusalem, ka' koini'i kuu ningilimba'imo i kai taemuu se' i kai a nanggau'kon mbali' i Yesus nipapatei.” ");
INSERT INTO blzNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petrus tia poposuu' sambana ninsimbatimo taena, “Kita tio malolo' na Alaata'ala, taasi' na mian. ");
INSERT INTO blzNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesus men kuu saliipkon pataka nopate, ia potuo'imo Alaata'alana pulinta. ");
INSERT INTO blzNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Alaata'ala nongorookonmo ni Yesus oruangan na paraas uanan-Na, bo Tanaas ka' bo Pansalamatkon, kada' samba Israel sida monsosoli ka' mangkadarai wawauna men ba'idek, kasi ampunion. ");
INSERT INTO blzNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kaimo tia Alus Molinas a men mompotuutuu' giigii' iya'a. Alus Molinas iya'a uga' a men ia rookon Alaata'ala na mian men mongololo' po'uus-Na.” ");
INSERT INTO blzNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sarataa Mahkama Agama nongorongor wurung men koiya'a, raaya'a nomaso'mo tuu', ka' nobasangadamo mampapatei ari poposuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kasee isian sa'angu' mian Farisi na mahkama iya'a, ngaanna ai Gamaliel. Ia wawa ukum Torat men angga'ionna mian wiwi'na. Ia nokumekerer kasi nomosuu' mian munguarkon ari poposuu' na liwana kodi-kodi'. ");
INSERT INTO blzNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kasi taeni Gamaliel na Mahkama Agama iya'a, “Utu-utus samba Israel! Inau' pore-pore kutung too upa a men bo wawauonmuu na mian karaale'e. ");
INSERT INTO blzNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gause mbaripian isian mian men ngaanon i Teudas. Ia nangaan wakana se' mian moola'. Ia isian lolo'na toro pato'atu mian. Kasee ia nipapatei ka' giigii' mian men nongololo' pisiso'na somo nobasia-siak, ka' limangna i raaya'a uga' sianmo no'imputan. ");
INSERT INTO blzNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Noko daa iya'a, tempona basensusan, taka soosoodo i Yudas men samba Galilea. Gause wawauna men kokana'na mian, mbaka' biai' a mian men sian malolo' na pamarenta nompololo' i ia. Kasee i ia uga' nipapatei, ka' mian men nongololo' pisiso'na uga' somo nobasia-siak. ");
INSERT INTO blzNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bookoi upa men nosida kani'i, pingkira'ku: alia mungupai i raaya'a. Patalaimo. Gause kalu pisiso' tia wawauna i raaya'a rumingkat na mian, pisiso' tia wawau iya'a sabole sianta umimput. ");
INSERT INTO blzNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kasee kalu pisiso' tia wawau iya'a rumingkat na Alaata'ala, mbaka' i kuu sianta momoko mungurungku'i i raaya'a. Tongko' minsidakon i kuu mintimban Alaata'ala.” Pa'ase' ni Gamaliel ia porongori mahkama. ");
INSERT INTO blzNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mbaka' ari poposuu' nileelo'mo ka' nisasali, kasi nibantili se' aliamomo' mimisiso'kon i Yesus na mian. Noko daa koiya'a, ari poposuu' nipatalaimo umuar. ");
INSERT INTO blzNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Raaya'a namarereimo sidang Mahkama Agama. Raaya'a beles gause Alaata'ala nansaa'mo i raaya'a tonsoop men ni'ideki gause mengelelekon i Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ka' sanda' ilio, raaya'a sinampang mimisiso'kon Lele Pore na Laiganna Alaata'ala tia na laiganna mian, ka' nambantilkon se' i Yesus a Tomundo' Pansalamatkon. ");
INSERT INTO blzNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Samba Yahudi men malolo' ni Yesus, kaekae' manau' kaekae' kanturangan. Tempo iya'a, samba Yahudi men mowurung Yunani, sianmo nangka'amat samba Yahudi men tuko. Kasi samba Yahudi men mowurung Yunani iya'a norobu taena, “Wiwinemai men nobalumo sianta nantausi obos kakaan sanda' ilio koi men ni'oboskon na wiwine balu sambana.” ");
INSERT INTO blzNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mbali' iya'a, ari poposuu' men sompulo' rua' ira, ningirimpungmo mian men malolo' ni Yesus iya'a, kasi norobu taena, “Sian pore kalu i kai sian mingimamat mengelelekon Wurungna Alaata'ala supu-supuana pungurusan kakaan. ");
INSERT INTO blzNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Utu-utus! Mbaka' porena i kuu mansarak mungururuki pitu' mian men kuu-kuumo. Ka' mian iya'a tio men sianpo idekna a ngaanna, kuasaionna Alus Molinas ka' motu'a a noana. Raaya'a nakatonmai bo pingilimang palimangon iya'a, ");
INSERT INTO blzNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kada' i kai sida mongononoai sambayang ka' mengelelekon Wurungna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wiwi'na mian iraando'o nansangadaimo papa'ase' nari poposuu'. Mbaka' i raaya'a nanganakatmo i Stefanus, sa'angu' mian men parasaya tuu' ni Yesus ka' kuasaionna Alus Molinas. Ka' mian sambana men ninakat, tonsoop ari Filipus, Prokhorus, Nikanor, Timon, Parmenas ka' i Nikolaus, men samba Antiokhia. Ia taasi' samba Yahudi, kasee ninsoopmo agama Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pitu' mian iya'a niwawamo na arop nari poposuu', kasi ari poposuu' nosambayang ka' nengepetkon limana na ko'ona i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mbaka' lele na Alaata'ala kaekae' tolele, ka' mian men malolo' ni Yesus na Yerusalem kaekae' kanturangan, ka' uga' biai' a imam na Yahudi men noparasayamo ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus biai' tuu' a barakaatna tia kuasana men ia rookon Alaata'ala. Mbali' iya'a, biai' a upa kosamba' tia oosan wawauonna na mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kasee uga' isian mian sambana men sian momorongori i Stefanus. Raaya'a a mian na laigan bakitumpuan men ngaanon Laigan Bakitumpuanna Mian Men Sianmo Nipo'ata'. Men tonsoop mian na laigan bakitumpuan iya'a mase samba Yahudi na kota Kirene ka' kota Aleksandria tia samba Yahudi na libutan Kilikia ka' libutan Asia. Raaya'a poogagai tii Stephanus. ");
INSERT INTO blzNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mau mune' koiya'a, upa men bantilkonon ni Stefanus uga' sian pokoonna i raaya'a gagaion, gause Alus Molinas mantarai i Stefanus pinginti'ian batundun. ");
INSERT INTO blzNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ya'a mbali' i raaya'a nantamboimo toro pii mian bo puntundun koi kani'imari: “Kai nongorongor mian kanono' ningiroki i Musa tia Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Koiya'a a nangasuina i raaya'a mian na Yahudi tia tanaa-tanaasna ka' wawa ukum Torat. Mbaka' i raaya'a nangarakopmo i Stefanus, kasi nangawawa i ia mae' na Mahkama Agama. ");
INSERT INTO blzNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Raaya'a uga' nangawawa toro pii mian bo pomborekkon i Stefanus. Raaya'a norobu taena, “Mian kaya'a tongko' mingiroki Laiganna Alaata'ala men molinas, ka' mingiroki ukum Torat men ia tadulkon i Musa tempo mbaripian. ");
INSERT INTO blzNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ka' uga' kai nongorongor mian kaya'a nuntundun se' i Yesus men samba Nazaret bo munguruntuni Laiganna Alaata'ala kani'i ka' mombolii adat men ia tadulkon i Musa na ko'onta'!” ");
INSERT INTO blzNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mbaka' giigii' mian men no'umoruang na sidang Mahkama Agama iya'a, rontos mintioki i Stefanus. Ka' tempo iya'a, ro'up ni Stefanus piile'on somo koi ro'upna malaa'ikat. ");
INSERT INTO blzNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Taena Imam Moola', “Tuutuu' a upa men ia raitkon mian karaaya'a na ko'oom?” ");
INSERT INTO blzNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ia simbati i Stefanus taena, “Tabea' na ko'onta', utu-utus tia tanaas! Rongor kutung ni'imari. Koo'po tia pulinta men i Abraham nobalimba' na Haran, tempona pulinta iya'a dauga' dumodongo na Mesopotamia, Alaata'ala men angga'ion tuu' notaka ni Abraham ");
INSERT INTO blzNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ka' norobu tae-Na, ‘Parerei a dodongoaan tia poto'utusaan. Rae' ka' dodongo na dodongoan men siso'konon-Ku i koo.’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mbaka' i Abraham namarereimo Kasdim ka' nobalimba' na Haran. Sarataa nolapus a tama ni Abraham, Alaata'ala nomosuu'mo i Abraham nobalimba' soosoodo ka' nodumodongo na tano' kani'i men dumodongoanta koini'i. ");
INSERT INTO blzNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tempo iya'a, sianta titiu'po a dodongoan kani'i men Ia rookon Alaata'ala bo tombonoion ni Abraham, kasee Alaata'ala nontoonmo se' i Ia bo mongorookon dodongoan kani'i, kada' bo tombonoion ni Abraham pataka na lee'na, mau mune' tempo iya'a i Abraham sianpo no'anakon. ");
INSERT INTO blzNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kasee Alaata'ala isian norobu ni Abraham soosoodo taena, ‘Lee'em tongko' bo sida koi mian notumaka na dodongoanna mian sambana. Raaya'a bo po'ata'on ka' talalaison pato'atu taun a nau'na. ");
INSERT INTO blzNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kasee lipu' men mompopo'ata' i raaya'a bo ukumon-Ku, ka' i raaya'a men nipopo'ata' bo umuar na dodongoan iya'a, kasi monsoosa' i Yaku' na dodongoan kani'i.’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Noko daa Alaata'ala norobu koiya'a, Ia nuntukokonmo sunat bookoi sa'angu' oosan toon. Mbaka' tongko' nongamea' i Ishak anak ni Abraham, na ilio kowalu'na i Abraham nunsunatmo anak iya'a. Koiya'a uga' sarataa i Ishak no'anakon i Yakub, ia nunsunatmo anakna, ka' sarataa i Yakub no'anakon, ia uga' nunsunatmo wiwi'na anakna men sompulo' rua' ira. Ya'amo a men nosida pulinta samba Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Pulinta moto'utus, nasindirkonmo utusna i raaya'a men i Yusuf. Mbali' iya'a, raaya'a nambalukkonmo i Yusuf na tano' Mesir. Kasee Alaata'ala mansambai i Yusuf, ");
INSERT INTO blzNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ka' nuntulung i ia na repaan. Alaata'ala nantarai i Yusuf noa men pore tia pinginti'ian na tempo i ia niwawa ni Firaun tomundo'na Mesir, pataka tomundo' iya'a nanganakat i ia sida gubernuur na Mesir, ka' uga' bo pinginti'ina laiganna batomundo'an. ");
INSERT INTO blzNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Noko daa koiya'a, notakamo a tempona pololuan men dodoa longkop Mesir tia Kana'an pataka mian munsuri marepa tuu'. Tempo iya'a pulinta sianmo nantausi kakaan. ");
INSERT INTO blzNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kasee sarataa ia rongor i Yakub se' na Mesir dauga' isian gandum, mbaka' ia nomosuu'mo anakna, men kana'mo pulinta, mae' na Mesir men tumbena. ");
INSERT INTO blzNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka' kopinduanna i raaya'a nomae', Yusuf nambantilkonmo na utusna iya'a se' i iamo i Yusuf. Temposi iya'a ka' ia inti'i tomundo'na Mesir a poto'utus ni Yusuf. ");
INSERT INTO blzNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Sarataa koiya'a, Yusuf nomotuunmo i Yakub tamana, kada' wiwi'na poto'utusanna balimba' na Mesir. Wiwi' irana koi pitumpulo' ka' lilima' mian. ");
INSERT INTO blzNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mbaka' i Yakub nobalimba'mo na Mesir, ka' i Yakub tia anakna men pulinta nolapus na Mesir. ");
INSERT INTO blzNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kasee biibiina i raaya'a ni'ule'kon ka' nitanom na baleanan men ia ilimo i Abraham na anak ni Hemor na Sikhem tia doi' salaka'. ");
INSERT INTO blzNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sarataa karani'mo tempona Alaata'ala bo mongololoikon toon-Na ni Abraham, mianta na tano' Mesir kaekae'mo kanturangan. ");
INSERT INTO blzNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kokomburi'anna namarentamo a sa'angu' tomundo'na Mesir men sian ninginti'i Yusuf. ");
INSERT INTO blzNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tomundo' iya'a nemeemee'kon ka' nantalalais pulinta. Ia namakisaa mian mangatori anak men ngamea' kada' kopatalaian ka' lapus. ");
INSERT INTO blzNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tempo iya'a i Musa nongamea'. Ia anak ngamea' men kotingkaina Tumpu a ro'upna. Ia nitondong sapi-sapit koi tolu' bitu'on na laiganna tamana, ");
INSERT INTO blzNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ka' sarataa i Musa ni'atori, anak wiwine na tomundo'na Mesir nangalamo anak iya'a, kasi ia tondong koi anakna suungna. ");
INSERT INTO blzNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa nipisiso'i tia biai' kapandeanna samba Mesir, ka' i ia nosidamo mian men pande morobu ka' tongaan a wawauna. ");
INSERT INTO blzNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tempo umur ni Musa patompulo'mo taun, ia ningkira'mo mengelego'i poto'utusanna men samba Israel. ");
INSERT INTO blzNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tempo iya'a i Musa nungurumpaki sa'angu' mian men sa'angu' lipu' tii ia, papolosionna sa'angu' mian men samba Mesir. Mbaka' i Musa nuntulungkonmo mian men papolosion ka' nampapatei samba Mesir iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa mongooskon se' mian men sa'angu' lipu' tii ia, daa ninginti'imo se' Alaata'ala nomokau i ia bo pansalamatkon i raaya'a. Kasee upa men ia piile', sian sintutu' tia upa men ia ooskon iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Koi liilana soosoodo, ia nimiile' samba Israel rua' ira poopapolosi. Musa nomoosarakmo ka' nompooka'amatikon. Ia norobu taena, ‘Kuu kani'i mase moto'utus. Nongko'upa i kuu se' poopalosi?’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kasee mian men nampapolosi samba-sambana iya'a nunduolkon i Musa, kasi taena, ‘Ime a men nanganakat i koo bo pantanaasi ka' pungukumi i kai? ");
INSERT INTO blzNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kabai i koo mo'uus mampapatei i yaku' koi i koo nampapatei samba Mesir imberi'?’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sarataa i Musa nongorongor upa men ia porobukon mian iya'a, Musa namareremo ka' nosida mian tumaka na Midian. Ka' na Midian ia no'anakon rurua'. ");
INSERT INTO blzNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Sarataa patompulo' taun i ia na Midian, sa'angu' malaa'ikat notakamo na ko'ona na tano' maleas karani' buu'na Sinai. Malaa'ikat iya'a no'umuar na apuna rampo' men pintanga' kumait. ");
INSERT INTO blzNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa samba' nimiile' men koiya'a. Mbali' iya'a, ia nuntuu'imo kara-karani' mamaresa se' upa iya'a. Kasi ia nongorongor wurungna Tumpu tae-Na, ");
INSERT INTO blzNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yaku' a Alaata'alana puliim; Yaku' Alaata'ala ni Abraham, Ishak tii Yakub.’ Musa norangguguranmo na patakutan, tamban ia sianmo noko pimiile' rampo' men kumait iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tumpu norobu soosoodo tae-Na, ‘Anui a sandaawal men koo pisok, gause tano' men nokumekereraan kanono' molinas. ");
INSERT INTO blzNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yaku' daa nimiile'mo ka' ningimamatmo idekna repaanna mian-Ku na Mesir. Yaku' nongorongormo pogimeleena i raaya'a na Ingku', ka' i Yaku' taka bo mansalamatkon i raaya'a. Mbali' iya'a, mai i koo kada' posuu'on-Ku mae' na Mesir.’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musa iya'a a men sianta ia labot samba Israel ka' nikokundai tia wurung koi kani'imari, ‘Ime a men nanganakat i koo sida pantanaasi ka' pungukumi i kai?’ Poali iamo a men ia posuu' Alaata'ala bo pantanaasi ka' pansalamatkon samba Israel, koi men ia bantilkon malaa'ikat na rampo' men kumait iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa iya'a a men nantanaasi samba Israel no'umuar na Mesir tia nangawawau upa kosamba' tia oosan na Mesir, na Tobui Memea', ka' na tano' maleas koi patompulo' taun a nau'na. ");
INSERT INTO blzNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa a men norobu na samba Israel taena, ‘Alaata'ala bo mongorookon na ko'omuu sa'angu' nabii men rurukion na mian men kuu-kuumo, koi i Ia nungururuki i yaku'.’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa a topobisara na samba Israel tia malaa'ikat na tano' maleas. Ia nongorongor wurungna malaa'ikat na Buu'na Sinai, ka' nantadulkon na pulinta. Ia a men nanglabot na Alaata'ala lelena tutuo' men pore bo ko'onta'. ");
INSERT INTO blzNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mau koiya'amo, pulinta sian momorongori. Raaya'a sian nangalabot i Musa ka' i raaya'a monoa mule'kon na Mesir. ");
INSERT INTO blzNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Raaya'a norobumo ni Harun taena, ‘Wawauii i kai toro pii patung kada' bo pantandan i kai. Gause sianmo kai inti'i a wawau ni Musa men nangawawa ka' nunguarkon i kai na Mesir!’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kasi tempo iya'a, raaya'a nangawawau sa'angu' patung koi anakna sapi', kasi i raaya'a nongorookon kelai na patung iya'a ka' nangaramekon upa men ia wawau i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mbaka' i raaya'a ia parereimo Alaata'ala ka' nipatalai mangkanggi giigii' upa na langit. Ya'a koi men nitulis na kitapna nabii koi kani'imari, ‘Oo samba Israel! Patompulo' taun na tano' maleas i kuu nongkoyo' ka' nengkelaikon ayop, see taasi' bo Ingku'. ");
INSERT INTO blzNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kemana diim Molokh a men paiwawaonmuu tia diimna bitu'on men ngaanon Refan; patungna a men wawaonmuu ka' kanggion. Mbali' iya'a, Yaku' bo mangatori i kuu na sambotakna lipu' Babel.’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kema men torumpakanna Alaata'ala na mian isian na pulinta na tano' maleas. Kema iya'a niwawau gause posuu'na Alaata'ala ni Musa, koi men ia pipiile'kon Alaata'ala na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kasi kema men ia labot pulinta, ia wawamo i raaya'a minsoop na dodongoan kani'i. Tempo iya'a i Yosua nantanaasi i raaya'a mae' nunsurung dodongoanta kani'i, na lipu' men ia buse'i Alaata'ala na aropna i raaya'a. Ka' kema iya'a dauga'na pataka ni Daud. ");
INSERT INTO blzNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daud isian kaporeanna Alaata'ala. Mbali' iya'a ia nama'ase' kada' patalaion mangawawau Laigan bona Alaata'ala men soosa'on ni Yakub. ");
INSERT INTO blzNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kasee i Salomo a men nomokerer Laigan bona Alaata'ala iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mau koiya'a, Alaata'ala men na ko'alayo'an sian dumodongo na laigan men wawauonna mian; gause na kitapna nabii, isian nitulis koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Taena Alaata'ala, Langit a oruangan-Ku ka' tano' balaki' a pimpee'an-Ku. Laigan koi upa a men pokereronmuu bo Ingku'? Mbariana a dodongoan bo pintimalean-Ku? ");
INSERT INTO blzNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Taasi' uga' i Yaku' a men ninsidakon wiwi'na upa?’ ");
INSERT INTO blzNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Utu-utus! Kuu bolongoli tuu'! Noamuu sian malolo' na Alaata'ala! Kuu sian momorongori wurungna Alaata'ala! Kuu koikoimo pulimuu, sinampang kundakon Alus Molinas! ");
INSERT INTO blzNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Isian mbali' nabii men daa sian ia talalais pulimuu? Raaya'a nampapatei mianna Alaata'ala, men mbaripian nuntundunkon kotakaanna Mian men Kana' a wawauna. Ka' koini'i kuu kokundaimo ka' nipapatei a Mian iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Malaa'ikat nantadulkonmo ukum Torat na koomuu, kasee i kuu sianta nongololo'!” ");
INSERT INTO blzNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sarataa ia rongor mianna Mahkama Agama a upa men ia tundun i Stefanus, raaya'a nomakitmo tuu' tamban mongkoroit a wese'na. ");
INSERT INTO blzNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kasee i Stefanus men kuasaionna Alus Molinas tongko' notumangak waara'a na langit. Ia nimiile' kobalaki'anna Alaata'ala, ka' i Yesus nokumekerer paraas uananna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kasi i Stefanus norobu taena, “Piile', yaku' nontoa'i surugaa nokobongkatian ka' Anak Manusia nokumekerer paraas uananna Alaata'ala!” ");
INSERT INTO blzNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mianna Mahkama Agama nongompodimo tilingana i raaya'a kasi nangkakaro', ka' liuliu nimimuruki i Stefanus. ");
INSERT INTO blzNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Raaya'a nangawawamo i Stefanus na liwana kota, ka' nangalapak tia watu. Giigii' mian men nomborekkon i Stefanus nungukatimo bokukumna i raaya'a ka' nomokela na aropna sa'angu' anak malai men ngaanon i Saulus. ");
INSERT INTO blzNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pintanga' i raaya'a mangalapak i Stefanus, Stefanus nosambayangmo taena, “Oo Tumpu Yesus, labot a alusku!” ");
INSERT INTO blzNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kasi ia nobanintuur ka' norobu booboolak taena, “Oo Tumpu, alia mompopasa'anikon dosa kani'i na mian karaaya'a!” Noko daa nangaan koiya'a, Stefanus nolapusmo. ");
INSERT INTO blzNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ka' i Saulus uga' sangada tia wawauna mian men nampapatei i Stefanus. 8:1b-3 Na iliopo iya'a, mian na jama'at Yerusalem nipootorapikonmo ka' nitalalais men dodoa tuu' pataka mian men parasaya saliwakon poposuu', somo nobasia-siak longkop Yudea tia Samaria. ");
INSERT INTO blzNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mian men parasaya na Alaata'ala nantanommo i Stefanus, ka' i raaya'a masiongo' tuu' tamban wiri. ");
INSERT INTO blzNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kasee i Saulus momoosarak ka' minsilaka'i jama'at. Ia mae' na sanda' laigan ka' mandaat mian men parasaya na Tumpu, mau wiwine tia moro'one, kasi nonsoopkon na tarungkuan. ");
INSERT INTO blzNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mian parasaya na Tumpu men nobasia-siakmo iya'a nomae'mo longkop Yudea tia Samaria nengelelekon Lele Pore men ringkat na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipus nomae'mo na sa'angu' kota na Samaria ka' nengelelekon Tomundo' Pansalamatkon men ia toonkon Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Sarataa mian biai' nongorongor upa men ia tundun i Filipus ka' nimiile' oosan men ia wawau, mbaka' biai' a mian men namakanasai upa men tundunonna iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Isian meena men somo potokuriris umuar na mian biai' men nolampingon, ka' uga' biai' a mian repo' tia men pepa' nilesi'i, ");
INSERT INTO blzNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","mbaka' nobelesmo tuu' a mian men na kota iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na kota iya'a isian sa'angu' moro'one, ngaanna i Simon. Mian na Samaria nanau'mo mongkodaakon kadiimanna. Simon nambantilkon na mian se' i ia mangalalabii mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mbaka' giigii' mian morio'-moola' na kota iya'a, muntunde' i Simon taena i raaya'a, “Mianmo kaya'a a pingintoni kuasana Alaata'ala men tolele koi ‘Kuasa Balaki'’.” ");
INSERT INTO blzNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nanau'mo i ia mompoposamba' mian tia kadiimanna, tamban mian mangkaroro i ia. ");
INSERT INTO blzNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kasee sarataa i Filipus nengelelekon Lele Pore na ko'ona i raaya'a, raaya'a namarasayamo i Filipus, men nambantilkon Batomundo'anna Alaata'ala tii Yesus Kristus, Tomundo' Pansalamatkon iya'a. Mbaka' i raaya'a, mau moro'one ka' uga' wiwine, nisaranimo. ");
INSERT INTO blzNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon suungna uga' noparasayamo, ka' niki sarani. Noko daa iya'a, ia nongololo'mo i Filipus liuliu. Simon samba' tuu' nimiile' oosan tia upa kosamba' men nosida iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Sarataa poposuu' na Yerusalem nongorongor se' mian na Samaria namarasayamo wurungna Alaata'ala, mbaka' poposuu' iya'a nomosuu'mo i Petrus tii Yohanes mae' na Samaria. ");
INSERT INTO blzNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tongko' notaka i Petrus tii Yohanes, raaya'a nansambayangkonmo samba Samaria, kada' i raaya'a pinsoopionna Alus Molinas, ");
INSERT INTO blzNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","gause Alus Molinas sianpo isian na ko'ona i raaya'a; raaya'a baasi nisarani mangaan ngaan ni Tumpu Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kasi i Petrus tii Yohanes nengepetkon limana na mian men noparasayamo iya'a. Noko daa koiya'a, raaya'a ia pinsoopimo Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tongko' ia piile' i Simon se' Alus Molinas niminsoopimo i raaya'a na tempo poposuu' nengepetkon limana, Simon nonsoorkonmo doi'na ni Petrus tii Yohanes, ");
INSERT INTO blzNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kasi norobu taena, “Tarai i yaku' kuasa, kada' kalu i yaku' mengepetkon limangku na mian sambumo, mian iya'a pinsoopionna Alus Molinas.” ");
INSERT INTO blzNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kasee ia simbati i Petrus taena, “Silaka' i koo tia doi'im! Pansaruiim mbali' se' upa men rookononna Alaata'ala sida ilioon tia doi'? ");
INSERT INTO blzNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Koo sianta kana' bo pongololo' palimangonmai kani'i, gause noaam sian maloos na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mbali' iya'a, sosoli ka' kadarai a sagiaam men ba'idek kanono', ka' pa'ase' na Tumpu, kada' i koo ampunion-Na. Gause i koo nimikirkonmo upa men ba'idek. ");
INSERT INTO blzNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gause yaku' inti'i i koo masindir tuu' ka' po'ata'onna noaam men ba'idek.” ");
INSERT INTO blzNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kasi i Simon norobu na ko'ona i raaya'a taena, “Pa'ase'kon na Tumpu, kada' alia sa'angu'po upa men kuu ngaan kanooro'o sida na wakangku.” ");
INSERT INTO blzNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Sarataa i Petrus tii Yohanes nompotuutuu' wawauna Tumpu na ko'ona i raaya'a, ka' nuntundunkon wurungna Tumpu, raaya'a nomule'konmo na Yerusalem. Ka' na tanga'na salan, raaya'a uga' mengelelekon Lele Pore na biai' kampungna lipu' Samaria. ");
INSERT INTO blzNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sa'angu' malaa'ikatna Tumpu norobu ni Filipus taena, “Ringkat ka' rae' i koo paraas selatan na salan men nangkantang Yerusalem tia Gaza.” Salan iya'a sian laan liuonna mian. ");
INSERT INTO blzNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mbaka' i Filipus nomae'mo. Na tanga'na salan, ia ningiliu sa'angu' pamarenta moola'. Mian iya'a tanaasna pagawena pungurus doi' na tomundo' wiwine na lipu' Etiopia men ngaanon i Kandake. Tanaasna pagawe iya'a norumingkat na Yerusalem na bakitumpuan, ");
INSERT INTO blzNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ka' banta-bantangmo mule'kon na dodongoanna. Tanaasna pagawe iya'a oru-oruang na lalomna keretana, pintanga' mambasa Kitap Nabii Yesaya. ");
INSERT INTO blzNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Alus Molinas norobumo ni Filipus taena, “Tuu'i a mian na kereta kale'e.” ");
INSERT INTO blzNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mbaka' i Filipus nuntuu'imo, kasi nomorongori mian iya'a mambasa kitap Nabii Yesaya. Filipus nimikirawarmo taena, “Too daa inti'ionmuu a upa men kuu basa kanooro'o?” ");
INSERT INTO blzNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ia simbati tanaasna pagawe iya'a taena, “Sian! Tiodaa siso'kononna mian, kada' daa inti'ionku.” Mbali' iya'a ia ninsiloloaimo i Filipus masawe' umoruang tii ia. ");
INSERT INTO blzNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Isiina Alkitaap men ia basa koi kani'imari: “Ia koi domba men nidaat bo koyo'on. Ia koi anakna domba men guntingion a wuluna, kasee sian morembee'. Koiya'a uga' i Ia, sianta santaa'po upa porobukonon-Na. ");
INSERT INTO blzNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ia irokion ka' wawaukonon sambu-sambumo. Ia bo papateion, kada' sianta lee'-Na bo paitundunonna mian.” ");
INSERT INTO blzNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Noko daa koiya'a, pagawe moola' na Etiopia iya'a norobumo soosoodo ni Filipus taena, “Pitundunkon i yaku'. Ime a men ia tundun nabii na kitap kani'i? Waka-wakanamo kabai se' mian sambana?” ");
INSERT INTO blzNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mbaka' i Filipus nungule'imo nuntundun men baasi ia basa pagawe iya'a, bookoi nuntumbeina mengelelekon Lele Pore men ringkat ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na tanga'na salan i raaya'a ningiliu tampat men isian weer. Pagawe iya'a norobumo ni Filipus taena, “Piile', karo'o isian weer! Too daa sida saranion i yaku'?”  ");
INSERT INTO blzNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ia simbati i Filipus taena, “Kalu i kuu parasayamo tuutuu' na Tumpu, kuu sidamo saranion.” Kasi taena pagawe iya'a soosoodo, “Indo', yaku' daa parasayamo se' i Yesus Kristus iya'a Anakna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mbaka' pagawe iya'a nokitaankonmo keretana, ka' i raaya'a rua' ira nalau mbaaro'o na weer, kasi i Filipus nansarani i ia. ");
INSERT INTO blzNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sarataa i raaya'a no'umuar na weer, Alusna Tumpu nangawawamo i Filipus. Mbaka' pagawe iya'a sianmo nimiile' i Filipus. Pagawe iya'a ningimputkonmo rae'anna ka' nobeles tuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ola-olan i Filipus noko isianmo na kota Asdod. Ia ningimputkonmo rae'anna ka' nengelelekon Lele Pore na wiwi'na kota men liuonna mae' na Kaisarea. ");
INSERT INTO blzNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tempo iya'a, Saulus tongko' kaekae' loingon mangaras ka' mampapatei mian men malolo' ni Yesus. Saulus nomae'mo na Imam Moola', ");
INSERT INTO blzNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ka' nama'ase' surat kuasa kada' ia sida muntuungi tanaasna laigan bakitumpuanna samba Yahudi na Damsyik, kada' kalu i ia muntuungi mian men mongololo' Salanna Tumpu, mau wiwine kabai moro'one, ia sida mangarakop ka' mangawawa i raaya'a na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Banta-bantang mae' na Damsyik, sarataa karani'mo na kota iya'a, ola-olan isian ruar men masulo nda'amari langit nintimpa' na tiku-tikum ni Saulus. ");
INSERT INTO blzNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulus notonsumpulmo na tano', kasi ia nongorongor Wurung taena, “Saulus, Saulus! Nongko'upa i koo se' mantalalais i Yaku'?” ");
INSERT INTO blzNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Taeni Saulus, “Ime i Kuu, Tuan?” Taena Wurung iya'a, “Yaku'mo i Yesus men talalaisoon. ");
INSERT INTO blzNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kasee koini'i, wangon i koo ka' rae' na kota. Ndo'osi kasi bantilkonon i koo a upa men bo wawauoon.” ");
INSERT INTO blzNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mian men nompololo' i Saulus tinongkodi' tamban i raaya'a sianmo noko batundun, gause i raaya'a uga' nongorongor wurung iya'a, kasee i raaya'a sian nimiile' sa'angu'po mian. ");
INSERT INTO blzNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kasi i Saulus norumingkat ka' nokumambang, kasee ia sianmo nopoopiile'. Mbaka' i raaya'a nimbibitmo ka' namaraandaki i ia mae' na Damsyik. ");
INSERT INTO blzNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Koi tolungilio i Saulus sian nopoopiile', ka' koiya'a a nau'na i Saulus sian nokumaan kabaipo ninginum weer. ");
INSERT INTO blzNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na Damsyik isian sa'angu' mian men malolo' ni Yesus, ngaanna i Ananias. Na simpalaalungna, ia nimiile' ka' nongorongor Tumpu nengeleelo' i ia tae-Na, “Ananias!” Ia simbati i Ananias taena, “Upa Tumpu?” ");
INSERT INTO blzNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Taena Tumpu, “Rae' i koo koini'i na laigan ni Yudas na Salan Maloos. Sarakoon i Saulus men samba Tarsus. Mian iya'a pintanga' sambayang, ");
INSERT INTO blzNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","gause na simpalaalung ni Saulus, Yaku' ninsiso'konmo na ko'ona, se' sa'angu' mian men ngaanon i Ananias bo taka ka' mengepetkon limana na ko'ona kada' i ia sida poopiile' soosoodo.” ");
INSERT INTO blzNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ia simbati i Ananias taena, “Tumpu, yaku' nongorongormo mian biai' muntundun wawau ni Saulus men ba'idek. Ka' men tukona mase pantalalaisanna mian-Muu na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ka' koini'i i ia notakamo kani'imari tia kuasana tanaasna imam kada' bo mangarakop mian men parasaya na Ko'omuu.” ");
INSERT INTO blzNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kasee Tumpu norobu ni Ananias tae-Na, “Rae'mo! Gause i Yaku' nungururukimo i ia bo pengelelekon i Yaku' na mian men taasi' Yahudi tia na tomundo' ka' uga' na mian-Ku men samba Israel. ");
INSERT INTO blzNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ka' i Yaku' suung-Ku bo mimpipiile'kon na ko'ona biai' tuu' repaan men bo surionna montookon i ia mamarasaya i Yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mbaka' i Ananias nomae'mo na laigan ni Yudas, ka' nengepetkon limana ni Saulus. Kasi taeni Ananias, “Saulus, utusku! Tumpu Yesus men koo piile' na tanga'na salan tempo i koo banta-bantang mae' ka'ita, Iamo a men nomosuu' i yaku' taka na ko'oom, kada' mataam sida tarang soosoodo, ka' i koo kuasaionna Alus Molinas.” ");
INSERT INTO blzNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tempopo iya'a uga', isian upa men koi sisikna susum notonguar na mata ni Saulus, pataka i ia sidamo nopoopiile' soosoodo. Mbaka' i Saulus nowangonmo, kasi nisarani. ");
INSERT INTO blzNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ka' sarataa nokumaan, Saulus nopoonggormo soosoodo. 9:19b-25 Saulus nodumodongomo na Damsyik tia mian men malolo' ni Yesus koi toro pii ilio. ");
INSERT INTO blzNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saulus liuliu nomae' na laigan bakitumpuan ka' nuntumbei nengelelekon se' i Yesusmo a Anakna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Giigii' mian samba' mongorongor upa men tundunon ni Saulus. Raaya'a norobu taena, “Taasi' i ia mbali' a men na Yerusalem men nampapatei biai' mian men parasaya ni Yesus? Taasi' i ia uga' a men taka ka'ita bo mangarakop mian ka' mangawawa i raaya'a na tanaasna imam?” ");
INSERT INTO blzNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kasee i Saulus kaekae' porongorionna tuu' mian. Ia nuntundun se' i Yesus a Tomundo' Pansalamatkon, ka' upa-upa men bantilkononna muntundun i Yesus parasayaonna mian tuu', tamban samba Yahudi men dumodongo na Damsyik sian noko panggagai upa men ia tundunkon. ");
INSERT INTO blzNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sarataa koimo toro pii ilio, samba Yahudi nompoosangadaikonmo bo mampapatei i Saulus. ");
INSERT INTO blzNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kasee sagiana i raaya'a noka'inti'ianmo ni Saulus. Ilio-malom i raaya'a mempeperai na soopanna kota kada' bo mampapatei i Saulus. ");
INSERT INTO blzNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mau ne' koiya'a, na sa'angu'anmo malom, mian men mongololo' i Saulus, ningisiikonmo i Saulus na karandang, kasi nungulul waaro'o na liwana tembokna kota. ");
INSERT INTO blzNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulus nomae'mo na Yerusalem, ka' ia momoosarak kada' sida basangada tia mian men malolo' ni Yesus. Kasee i raaya'a babatakon i Saulus, gause i raaya'a sianpo parasaya se' i Saulus daa tuutuu' noparasayamo ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kasee i Barnabas notaka ni Saulus ka' nangawawa i Saulus na poposuu'. Barnabas nuntundunkon nari poposuu' se' i Saulus nimiile' Tumpu na tanga'na salan ka' Tumpu norobu na ko'ona. Ia uga' nuntundunkon se' i Saulus momoko mengelelekon i Yesus na mian na Damsyik. ");
INSERT INTO blzNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mbaka' i Saulus nalewamo waale'e-le'emari na Yerusalem tia ari poposuu', ka' i ia sianta babata mimisiso' mian na Yerusalem tia kuasana Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ia muntundun ka' poogagai tia samba Yahudi men mowurung Yunani, kasee i raaya'a mampari-pari ka' mampapatei i Saulus. ");
INSERT INTO blzNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sarataa ia too inti'i mian parasaya men sambana a upa men nosida iya'a, raaya'a nangawawamo i Saulus na kota Kaisarea, ka' noko daa iya'a, Saulus ia poporingkatmo i raaya'a mae' na kota Tarsus. ");
INSERT INTO blzNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mbaka' jama'at na longkop lipu' Yudea, libutan Galilea ka' na kota Samaria nunsurimo ratong. Raaya'a mangangga'i Tumpu ka' tulungonna Alus Molinas pataka sanda' jama'at nosidamo moonggor ka' ninturang biai'. ");
INSERT INTO blzNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Banta-bantang i Petrus mangarae'i toro pii dodongoan, ia nengelego'imo mianna Tumpu na kota Lida. ");
INSERT INTO blzNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na kota iya'a, ia nuntuungi sa'angu' moro'one, ngaanna i Eneas. Mian iya'a walu'mo taun a norepo'anna tamban sianmo momoko wangon. ");
INSERT INTO blzNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus norobumo ni Eneas taena, “Eneas, Yesus Kristus mengelesi'i i koo. Wangon ka' totobo' a tokolaan.” Mbaka' i Eneas lako-lako nomoko nowangon. ");
INSERT INTO blzNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Giigii' mian na kota Lida tia na rempa'na Saron nimiile' i Eneas, kasi i raaya'a noparasaya na Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kasi men na kota Yope, isian sa'angu' wiwine, ngaanna i Tabita. Ia sa'angu' mian men malolo' ni Yesus. (Na wurung Yunani, ia ngaanon i Dorkas men aratina, donga.) Biai' tuu' a wawauna men pore ka' i ia mo'uus muntulung mian men talalais. ");
INSERT INTO blzNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na tempo iya'a, ia nanggeo ka' nolapus. Soro' nipoloopi a biibiina, ia nipokelamo na tambin men na wawo. ");
INSERT INTO blzNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kota Yope sian laan oloa na kota Lida. Na tempo iya'a, mian men malolo' ni Yesus na kota Yope ninginti'i se' i Petrus isian na Lida. Raaya'a nomosuu'mo rua' mian kada' mae' mondolo' i Petrus na kota Lida, tia potuun koi kani'imari: “Donga-dongan waara'a na Yope.” ");
INSERT INTO blzNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mbaka' i Petrus liuliu norumingkat ka' nompololo' i raaya'a mae' na Yope. Taka-taka i Petrus niwawamo na tambin men na wawo. Giigii' wiwine balu men moraando'o nintikumimo i Petrus potorunsuk wiri ka' minsiso'kon bokukum tia jubana i raaya'a men ia kautkon i Dorkas tempo i ia dauga' tumuo'. ");
INSERT INTO blzNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus nomosuu'mo i raaya'a kada' umuar, kasi ia nobanintuur ka' nosambayang. Noko daa koiya'a, ia nangaropmo biibii ni Dorkas ka' norobu taena, “Tabita, wangon i koo!” Mbaka' i Tabita nangkambangkonmo matana, ka' sarataa ia nimiile' i Petrus, ia no'umoruangmo. ");
INSERT INTO blzNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kasi i Petrus ningintoni limana ka' nantaandaki ia nokumekerer. Noko daa iya'a, Petrus nengeleelo'mo mianna Tumpu tia wiwi'na wiwine balu, ka' nongorookon i Dorkas men notuo'mo soosoodo iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Upa men nosida iya'a notolelemo na longkop kota Yope, ka' na kota iya'a, biai' a mian men noparasayamo se' i Yesus a Tomundo' men Pansalamatkon i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Soro' koiya'a, Petrus dauga' koi toro pii ilio na kota Yope. Ia nintunda na sa'angu' mian men ngaanna i Simon. Palimangonna mingilimang anit. ");
INSERT INTO blzNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na kota Kaisarea isian sa'angu' mian, ngaanna i Kornelius. Ia sa'angu' kapiteen “Pasukan Italia.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ia sa'angu' mian pa'agama ka' raaya'a sangkau laigan layaonkon Alaata'ala. Ia piribiai'mo nuntulung samba Yahudi men marepa a tutuo'na, ka' i ia sinampang sambayang na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sa'angu'mo tempo, toro jaam tiga maamaalom, ia ninsimpalaalungkon nimiile' sa'angu' malaa'ikatna Alaata'ala notaka ka' nengeleelo' i ia taena, “Kornelius!” ");
INSERT INTO blzNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelius nontoa'imo malaa'ikat iya'a pata-patakut ka' norobu taena, “Upa Tuan?” Ia simbati malaa'ikat iya'a taena, “Sambayaang tia upa men koo rookonmo na mian, daa ia labotmo Alaata'ala, ka' Alaata'ala uga' minginau' i koo. ");
INSERT INTO blzNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Koini'i posuu' a mian mae' na kota Yope mengeleelo' i Simon men uga' ngaanon i Simon Petrus. ");
INSERT INTO blzNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ia koini'i nintunda na sa'angu' mian men mingilimang anit, ngaanna uga' i Simon. Laiganna na soripi'na tobui.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Sarataa malaa'ikat men norobu ni Kornelius iya'a nomae', Kornelius nengeleelo'mo rua' mian men tutulungi balimang na laiganna, tia sa'angu' surudadu pangawalna men pa'agama ka' mala' mongololo' i ia. ");
INSERT INTO blzNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kasi i Kornelius nuntundunkon na ko'ona i raaya'a, giigii' upa men nosida na ko'ona, ka' noko daa iya'a ia nomosuu'mo i raaya'a mae' na kota Yope. ");
INSERT INTO blzNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Koi liilana, toro jaam dua blaas tanga'iloa', raaya'a men niposuu' banta-bantang mae' montorumpakimo kota Yope, kasi i Petrus nasawe'mo na wawona laigan bo sambayang. ");
INSERT INTO blzNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ia nokololuanmo ka' mo'uus tuu' kumaan. Pintanga' a mian montoropoti kakaan, ola-olan isian simpalaalung na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ia nontoa'i langit nokobongkatian, ka' isian upa koi toik men bambal ni'ulul nda'amari langit, nikoot loe-loe na papaat susuna toik iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na lalomna isian biai' kaliangan ayop men papaat a saratna, ka' biai' ayop men sumondur tia sapu' men malela'. ");
INSERT INTO blzNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kasi isian wurung ia rongor tae-Na, “Petrus, wangon! Pongkoyo' ka' pangkaan!” ");
INSERT INTO blzNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ia simbati i Petrus taena, “Sian Tumpu! Yaku' sianpo nontoo kaan upa men sian sida kaanon koi na ukum Torat.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kasee wurung iya'a ia rongor soosoodo taena, “Upa men ia ngaanmo Alaata'ala sida kaanon, alia i koo mangaan se' sian sida kaanon ka' kobiit.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Simpalaalung iya'a koi porotolu ia piile', kasi toik iya'a notonakat waara'a na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petrus samba' mompoo'inau'ikon upa men ia piile' na simpalaalungna iya'a. Pintanga' i ia mompoo'inau'ikon, mian men mansarak laiganna, men ia poosuu' i Kornelius, noko isianmo na soopan. ");
INSERT INTO blzNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kasi i raaya'a nengeleelo' mian ka' nimikirawar taena i raaya'a, “Too isian sawe' men nintunda ka'ita men ngaanon i Simon Petrus?” ");
INSERT INTO blzNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pintanga' i Simon Petrus mompoo'inau'ikon aratina simpalaalungna men ia piile' iya'a, Alus Molinas norobumo na ko'ona tae-Na, “Petrus, isian mian tolu' ira mansarak i koo. ");
INSERT INTO blzNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Rae' palau dongan ka' alia bata-bata mongololo' i raaya'a, gause Yaku' a nomoosuu' i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Mbaka' i Petrus nalaumo ka' norobu na ko'ona i raaya'a taena, “Yaku'mo a men sarakonmuu. Upa a panduungmuu taka na ingku'?” ");
INSERT INTO blzNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ia simbati i raaya'a taena, “Kapiteen Kornelius a men nomosuu' i kai nda'amari. Ia mian men kana' a wawauna ka' layaonkon Alaata'ala, ka' angga'ionna giigii' samba Yahudi. Sa'angu' malaa'ikatna Alaata'ala nomosuu' i ia mengeleelo' i tuan kada' mae' na laiganna. Ia niposuu' kada' mongorongor upa men tundunon ni tuan na ko'ona.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mbaka' i Petrus ninsiloloaimo i raaya'a kada' tuuk motokol na ko'ona. Koi liilana i Petrus nomae'mo poololo' tii raaya'a. Toro pii mian na Yope men parasaya na Tumpu, uga' nolumolo'. ");
INSERT INTO blzNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sangilio noko daa iya'a, raaya'a notakamo na Kaisarea. Ia takai i raaya'a i Kornelius tia poto'utusanna ka' lulusanna men sa'angu' noa men ia leelo' noko potoperamo. ");
INSERT INTO blzNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Sarataa i Petrus notaka, Kornelius nomoorumpakimo ka' nobanintuur na arop ni Petrus ka' nonsoosa' i Petrus. ");
INSERT INTO blzNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kasee i Petrus ningintoni lima ni Kornelius, kasi norobu taena, “Ringkat! Yaku' uga' mian.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pintanga' i raaya'a poolalabot batundun, Petrus ninsoopmo na laigan. Ia takai biai' a mian men noko barimpungmo. ");
INSERT INTO blzNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kasi taeni Petrus na ko'ona i raaya'a, “Kuu poto'inti'i se' i kai samba Yahudi sianta patalaionna agamamai mangarae'i kabai se' molulusan tia mian men taasi' Yahudi. Kasee Alaata'ala ninsisiso'konmo na ingku', se' i yaku' sian sida mangaan imepo kobiit kabai se' haraam. ");
INSERT INTO blzNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ya'a mbali' tempo i tuan nikidolo' i yaku', yaku' sian marakuntu' taka. Mbaka' koini'i i yaku' mo'uus minginti'i se' upa a leelo'konon ni tuan i yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kasi i Kornelius nobatundun taena, “Ripaton, toro koini'imari a ilio, toro jaam tiga maamaalom, yaku' pintanga' sambayang na laigan. Ola-olan sa'angu' moro'one nokumekerer na aropku. Bokukumna mian iya'a dingkalapan. ");
INSERT INTO blzNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ia norobu na ingku' taena, ‘Kornelius! Alaata'ala daa nangalabotmo sambayaang ka' i Ia ninginau'mo men koo rookon na mian. ");
INSERT INTO blzNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mbaka' posuu' a mian mae' mengeleelo' i Simon Petrus na Yope. Ia koini'i nintunda ni Simon men mingilimang anit. Laiganna na soripi'na tobui.’ ");
INSERT INTO blzNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ya'a mbali' i yaku' liuliu nomosuu' mian mae' mengeleelo' i tuan. Ka' i tuan tuutuu' tia noa ma'amat notaka ka'ita. Koini'i kai giigii' nobarimpungmo ka'ita na aropna Alaata'ala mongorongor upa men ia posuu'kon Tumpu bo tundunon ni tuan na ko'omai.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kasi i Petrus nobatundun taena, “Koini'i tuutuu' yaku' inti'imo se' Alaata'ala sianta momoosasala'kon mian. ");
INSERT INTO blzNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mian men mamarasaya Alaata'ala ka' mingilimang men kana', mian inono' kokana'na Alaata'ala. Alaata'ala sian mungururuki mau too samba upa. ");
INSERT INTO blzNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kuu daa ninginti'imo lele men ia tadulkon Alaata'ala na samba Israel. Lele iya'a mase Lele Pore muntundunkon koi upa a mian sida ma'amat na Alaata'ala gause i Yesus Kristus, men Tumpu na giigii' mian. ");
INSERT INTO blzNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kuu uga' ninginti'imo upa men nosida na longkop Yudea, muntumbei na Galilea, noko daa pansaranian men ia posuu'kon i Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Alaata'ala nungururuki i Yesus samba Nazaret iya'a ka' nongorookon Alus Molinas tia kuasa-Na na Ko'ona. Kuu uga' daa ninginti'i se' i Yesus iya'a, mau mae' mbaana, Ia mangawawau men pore, ka' mengelesi'i giigii' mian men lampingionna Ibiliis, gause Alaata'ala mansambai i Ia. ");
INSERT INTO blzNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kaimo a mian men nimiile'mo giigii' upa men Ia limang na dodongoanna samba Yahudi tia na Yerusalem. Kasee maune' koiya'a, raaya'a nampapateimo ka' nansaliipkon i Ia. ");
INSERT INTO blzNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kasee na ilio men kotolu'na, Alaata'ala nomotuo'imo i Ia ka' nimpipiile'kon i Ia na mian. ");
INSERT INTO blzNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Taasi' na giigii' mian, kasee tongko' na ko'omai men ia rurukimo Alaata'ala na olukonanpo bo pompopo'inti'ikon i Ia. Sarataa i Ia notumuo' soosoodo noko daa lapus, kai nokumaan ka' noba'inum tii Ia. ");
INSERT INTO blzNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ka' i Ia nomosuu' i kai mengelelekon Lele Pore iya'a na mian ka' mompotuutuu' se' i Iamo a men ia nakat Alaata'ala nosida pungukumi mian men dauga' tuo' tia mian men nolapusmo. ");
INSERT INTO blzNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Giigii' nabii nuntundunmo i Ia. Raaya'a nuntundun se' giigii' mian men parasaya ni Yesus, bo ampunion a dosana mimpu'u na kuasa ni Yesus.” ");
INSERT INTO blzNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pintanga' i Petrus morobu, Alus Molinas nalau ka' niminsoopi giigii' mian men mongorongor lele iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Samba Yahudi toro pii ira men parasaya ni Yesus ka' nompololo' i Petrus ringkat na Yope samba' nimiile' se' Alaata'ala nongorookonmo Alus Molinas na mian men taasi' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Raaya'a uga' nongorongor mian biai' morobu biai' kaliangan wurung ka' muntunde' Alaata'ala. Kasi i Petrus norobu soosoodo taena, ");
INSERT INTO blzNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Piile'! Mian karaani'i ia pinsoopimo Alus Molinas koikoimo i kita. Sida mbali' a mian mantalantangi raaya'a saranion tia weer?” ");
INSERT INTO blzNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mbaka' i Petrus nomoosuu'mo kada' i raaya'a saranion bo pompotuutuu' se' i raaya'a parasayamo ni Yesus Kristus. Noko daa koiya'a, raaya'a nama'asemo kada' i Petrus dumodongo tii raaya'a toro pii ilio a nau'na. ");
INSERT INTO blzNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ari poposuu' tia mian men parasaya ni Yesus na longkop Yudea, nongorongor se' mian men taasi' Yahudi uga' namarasayamo wurungna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sarataa i Petrus nomae' na Yerusalem, samba Yahudi men noparasayamo ni Yesus iya'a, nompoposala'mo i Petrus. ");
INSERT INTO blzNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Taena i raaya'a, “Nongko'upa i kuu se' mae' na laiganna mian men taasi' Yahudi, men sianpo nisunat? Kuu tamban kumaan singka-singkat tii raaya'a!” ");
INSERT INTO blzNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ya'a mbali' i Petrus nuntundunkonmo na ko'ona i raaya'a giigii' kakalianganna upa men nosida tumbenapo. Taeni Petrus, ");
INSERT INTO blzNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yaku' pintanga' sambayang na kota Yope, kasi i yaku' nosimpalaalungon. Yaku' nimiile' isian upa men koi sa'angu' toik bambal ni'ulul nda'amari langit, loe-loe nikoot na papaat susuna, ka' notaan na aropku. ");
INSERT INTO blzNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pintanga' i yaku' mamakanasai lalomna, ola-olan yaku' nimiile' ayop men papaat a saratna, ayop men malela', ayop men sumondur tia sapu' men malela'. ");
INSERT INTO blzNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kasi yaku' nongorongor wurung men koi kani'imari, ‘Alaka' wangon, Petrus! Pongkoyo' ka' pangkaan!’ ");
INSERT INTO blzNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kasee yaku' simbati taengku', ‘Sian, Tumpu! Yaku' sianpo nontoo kaan kakaan men sian sida kaanon koi na ukum Torat.’ ");
INSERT INTO blzNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kasee yaku' rongor soosoodo a wurung men nda'amari surugaa taena, ‘Upa men ia ngaanmo Alaata'ala se' sida kaanon, alia i koo mangaan se' sian sida kaanon ka' kobiit.’ ");
INSERT INTO blzNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yaku' nimiile' men koiya'a koi porotolu. Ka' komburi'na notonakatmo mbaara'a na surugaa. ");
INSERT INTO blzNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tempopo iya'a tolu' mian men ringkat na Kaisarea, men niposuu' mondolo' i yaku' notakamo na laigan men nintundaanku. ");
INSERT INTO blzNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kasi Alus Molinas nomosuu' i yaku' mae' poololo' tii raaya'a, tia sian bata-bata. Mian men noom ira karaaya'a, tempo iya'a uga' nolumolo' tii yaku' mae' na Kaisarea, ka' i kai giigii' ninsoop na laigan ni Kornelius. ");
INSERT INTO blzNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kasi i Kornelius nuntundunkon na ko'omai koi upa i ia nimiile' sa'angu' malaa'ikat nokumekerer na laiganna ka' norobu taena, ‘Posuu' a mian mae' na kota Yope mengeleelo' sa'angu' mian men ngaanon i Simon Petrus. ");
INSERT INTO blzNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ia bo mantadulkon lele men mansalamatkon i kuu sangkau laigan.’ ");
INSERT INTO blzNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ka' baasi muntumbei morobu i yaku', Alus Molinas niminsoopimo i raaya'a koi men tumbena nosida na ko'onta' mbaripian. ");
INSERT INTO blzNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kasi i yaku' notonginau', se' Tumpu isian norobu koi kani'imari: ‘Yohanes mansarani tia weer, kasee i kuu bo saranionna Alaata'ala tia Alus Molinas.’ ");
INSERT INTO blzNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mbaka' manasamo se' Alaata'ala uga' mongorookon barakaat na mian men taasi' Yahudi iya'a, koikoimo men Ia rookon i kita, tempo i kita noparasaya ni Tumpu Yesus Kristus. Kalu koiya'a, se' sida mbali' i yaku' mantalantangi Alaata'ala?” ");
INSERT INTO blzNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sarataa nongorongor men koiya'a, raaya'a sianmo nanggagai soosoodo. Raaya'a nuntunde' Alaata'ala, kasi taena i raaya'a, “Kalu koiya'a, mian men taasi' Yahudi uga' ia tarai Alaata'ala tempo bo monsosoli ka' mangkadarai wawauna men ba'idek!” ");
INSERT INTO blzNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kasee sarataa i Stefanus nipapatei, mian men parasaya ni Yesus nipoototorapikon, pataka i raaya'a somo nobasia-siak waale'e-le'emari. Isian men namarere na lipu' Fenisia, ka' isian uga' men tadul na togong Siprus tia na kota Antiokhia. Mau ne' i raaya'a mengelelekon lele ni Yesus tongko' na samba Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kasee isian mian men parasaya ni Yesus men ringkat na Siprus tia Kirene. Raaya'a a men nomae' na Antiokhia nengelelekon Lele Pore men ringkat ni Yesus na samba Yunani. ");
INSERT INTO blzNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kuasana Tumpu isian na ko'ona i raaya'a, mbali' biai' a mian men noparasayamo ka' nongorookon wakana i raaya'a na Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Lele iya'a uga' notadulmo na jama'at Yerusalem. Mbaka' i raaya'a nomosuu'mo i Barnabas mae' na Antiokhia. ");
INSERT INTO blzNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ka' sarataa i Barnabas notaka na Antiokhia ka' nimiile' se' koi upa a barakaatna Alaata'ala na mian biai' iya'a, ia nobelesmo tuu'. Kasi ia nama'ase' kada' i raaya'a sida malolo' na Tumpu tia noa men tuutuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Gause i Barnabas kani'i mian men ma'amat a noana ka' kuasaionna Alus Molinas, ka' i ia parasaya tuu' na Tumpu, mbaka' nokanturanganmo biai' a mian men nongololo' Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kasi i Barnabas nomae' na Tarsus nansarak i Saulus. ");
INSERT INTO blzNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sarataa nopootuung tii Saulus, ia nangawawamo i Saulus mae' na Antiokhia. Raaya'a koi sa'angu' taun a nau'na nodumodongo tia jama'at na Antiokhia, ka' nimisiso' mian biai'. Na Antiokhiamo iya'a a tumbena mian men malolo' ni Yesus ningaan mian Sarani. ");
INSERT INTO blzNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tempo iya'a isian toro pii nabii men ringkat na Yerusalem notaka na Antiokhia. ");
INSERT INTO blzNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Isian sa'angu' nabii iya'a, ngaanna i Agabus. Alus Molinas namatana' i ia mambantilkon se' na longkop tano' balaki' bo takaionna pololuan men dodoa tuu'. (Ka' men koiya'a uga' nosida na tempo batomundo'an ni Kaisar Klaudius.) ");
INSERT INTO blzNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mbaka' mian men malolo' ni Yesus nosangadamo mantarai ruru'anna bona utus sa'angu' kaparasaya'an men dumodongo na Yudea; sanda' mian mungururu' koi men pokoonna. ");
INSERT INTO blzNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ka' sangadaan iya'a uga' ia limangmo i raaya'a, kasi i Barnabas tii Saulus niposuu' mangator ruru'anna i raaya'a na penatuana jama'at. ");
INSERT INTO blzNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sian paraa nanau' noko daa iya'a i Tomundo' Herodes nantalalaismo toro pii mianna jama'at na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Herodes nomosuu'mo mian nampapatei tia sinangkidi i Yakobus men utus ni Yohanes. ");
INSERT INTO blzNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Sarataa i Herodes nimiile' se' wawauna iya'a kobelesna samba Yahudi, ia ningimputkonmo limangna men koiya'a; ia uga' nomosuu'mo mian mangarakop i Petrus. Wawau men koiya'a nosida na tempo Ramean Roti Sianta Ragina. ");
INSERT INTO blzNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Sarataa i Petrus nirakop, ia nisoopkonmo na tarungkuan. Na tarungkuan iya'a i Petrus ia posuu'kon i Herodes dagaionna surudadu koi papaat reguu. Sa'angu' reguu, paat surudadu. Moko daasi Ramean Paska, kasi i Herodes mungukumi i Petrus na aropna mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mbaka' i Petrus nitaankonmo na tarungkuan; kasee jama'at na Yerusalem tia noa men tuutuu' mansambayangkon i ia na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Malom koi liilana i Herodes mungukumi i Petrus na aropna mian biai', tempo iya'a i Petrus toko-tokol royot nipungu tia rua' rante ka' ia pootatanga'ikon rua' surudadu pangawal. Na soopanna tarungkuan iya'a, pangawal sambana uga' moraando'o mandagai tarungkuan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ola-olan malaa'ikatna Tumpu nokumekerer indo'o ka' isian ruar na lalomna tambin na tarungkuan iya'a. Malaa'ikat iya'a ninsimpumo i Petrus pataka i Petrus nosuri. Kasi taena malaa'ikat iya'a, “Wangon, dongan!” Tempo iya'a uga' rante besi men nipungukon i Petrus liuliu nokolakasian. ");
INSERT INTO blzNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kasi taena malaa'ikat iya'a, “Pisok a bokukuum tia sapatoom.” Mbaka' i Petrus liuliu nimisok bokukum tia sapatona. Taena malaa'ikat iya'a soosoodo, “Pisok a jubaam ka' lolo' i yaku'.” ");
INSERT INTO blzNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Mbaka' i Petrus nongololo'mo malaa'ikat iya'a no'umuar na tarungkuan. Kasee i Petrus sian ninginti'i se' upa men wawauonna malaa'ikat iya'a na ko'ona, tuutuu' nosida. Petrus nansarui too tongko' simpalaalung. ");
INSERT INTO blzNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Raaya'a ningiliukonmo badagaan men tumbena tia men korua'na, kasi i raaya'a notaka na omporon besi men umuaran mae' na kota. Omporon iya'a nokoleakian suungna, kasi i raaya'a no'umuar ka' ninsalan na salan itiu'. Ola-olan malaa'ikat iya'a namarereimo i Petrus. ");
INSERT INTO blzNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Noko daasi koiya'a, kasi i Petrus ninginti'i upa men nosida na ko'ona. Taena, “Koini'i yaku' inti'imo se' Tumpu tuutuu' nomosuu'mo malaa'ikat-Na nansapukon i yaku' na kuasa ni Herodes, ka' na giigii' upa men sagiaonna tanaasna samba Yahudi bo wawauon na ingku'.” ");
INSERT INTO blzNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Noko daa i Petrus ningintoomkon upa men ia tempoi iya'a, ia nomae'mo na laigan ni Maria men sina ni Yohanes. Yohanesmo iya'a a men uga' ngaanon i Markus. Indo'o biai' a mian barimpung pintanga' sambayang. ");
INSERT INTO blzNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petrus nentenggormo omporonna bala, kasi sa'angu' wiwine tutulungi, ngaanna i Rode, nengelego'i mimiile' se' i ime a men mentenggor omporon iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Liuliu ia inti'i a wurung ni Petrus. Gause nolewa', ia donga-dongan ninsoop soosoodo, kasee sianpo nengeleaki omporon iya'a. Ia nambantilkon mian se' i Petrus isian na liwa. ");
INSERT INTO blzNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Taena i raaya'a, “Koo mbuol!” Kasee i Rode mompotuutuu' se' i Petrus waale'e na liwa. Mbaka' taena i raaya'a, “Waale'e malaa'ikat ni Petrus!” ");
INSERT INTO blzNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kasee i Petrus tongko' satenggo-tenggor omporon. Mbaka' sarataa ia leaki raaya'a a omporon ka' nimiile' se' tuutuu' isian i Petrus na liwana, raaya'a samba' tuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus nempepesmo i raaya'a tia limana kada' i raaya'a alia gora', kasi ia nuntundunkon koi upa Tumpu nunguarkon i ia na tarungkuan. Kasi taena, “Men yaku' tundun kani'i, bantilkon ni Yakobus ka' uga' na utus sambana.” Noko daa koiya'a i Petrus nomae'mo balimba' namarerei dodongoan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Koi liilana nogenggewumo a surudadu pangawal. Raaya'a samba'kon tuu' upa men nosida ni Petrus. ");
INSERT INTO blzNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kasi i Herodes nomosuu' mian mansarak i Petrus, kasee sian ia tausi i raaya'a. Mbaka' i Herodes nomosuu'konmo kada' pangawal iya'a pikirawarion, kasi papateion. Soro' koiya'a i Herodes namarereimo Yudea ka' notorondongo na Kaisarea. ");
INSERT INTO blzNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes maso'kon tuu' samba Tirus tia Sidon. Mbali' i raaya'a nosangadamo mae' ni Herodes. Tumbena i raaya'a nangama-amati i Blastus, men mantanaasi laigan batomundo'an ni Herodes, pataka i Blastus muntulungkon i raaya'a. Kasi i raaya'a nomae' ni Herodes, ka' nama'ase' pooka'amat, gause mian na dodongoanna i raaya'a somo mongooskon kakaan men isian na dodongoan ni Herodes. ");
INSERT INTO blzNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sa'angu'mo ilio men nipatukokonmo, Herodes nimisokmo pakean kobalaki'an, kasi no'umoruang na oruangan batomundo'anna, ka' nuntumbei norobu na aropna mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mian men nongorongor iya'a mangkakaro'kon ka' muntunde' i Herodes, taena, “Kaya'amari wurungna diim, taasi' wurungna mian!” ");
INSERT INTO blzNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tempopo iya'a uga' malaa'ikatna Tumpu nantakakonmo balaa' ni Herodes, gause ia sian mangangga'i Alaata'ala. Herodes nolapusmo ia kaan gaanggalang. ");
INSERT INTO blzNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mbaka' wurungna Alaata'ala kaekae' tolele ka' kaekae' biai' a mian men momorongori wurung iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sarataa i Barnabas tii Saulus namakabus palimangonna men mangator ruru'an, raaya'a namarereimo Yerusalem ka' nomule'kon na Antiokhia, nangawawa i Yohanes men ngaanon i Markus. ");
INSERT INTO blzNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jama'at na Antiokhia isian nabii tia guru. Raaya'a i Barnabas, Simeon men ningaani i Niger, Lukius samba Kirene, Menahem (men nitondong singka-singkat Tomundo' Herodes men montomundo'i sangobosan libutan na batomundo'anna tamana) kasi i Saulus. ");
INSERT INTO blzNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tempo i raaya'a pintanga' bakitumpu ka' ba'apata, Alus Molinas norobu na ko'ona tae-Na, “Saalkon i Barnabas tii Saulus bo Ingku' kada' i raaya'a mingilimang palimangon men ko'uus-Ku bo limangonna i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Noko daa noba'apata ka' nosambayang, raaya'a nengepetkonmo limana na takala' ni Barnabas tii Saulus, kasi nompoporingkat i raaya'a rua' ira. ");
INSERT INTO blzNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Gause ia posuu' Alus Molinas, mbaka' i Barnabas tii Saulus nomae'mo na kota Seleukia, kasi i raaya'a notarabut mae' na togong Siprus. ");
INSERT INTO blzNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sarataa notaka na kota Salamis, raaya'a nengelelekonmo wurungna Alaata'ala na laigan bakitumpuanna samba Yahudi. Yohanes Markus nomae' bo puntulungi i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Togong iya'a longkop ia rae'i i raaya'a pataka na Pafos. Na Pafos, raaya'a nopootuung tia sa'angu' samba Yahudi, ngaanna i Baryesus. Ia mian kadiiman ka' muntundun se' i ia nabii. ");
INSERT INTO blzNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Sergius Paulus, gubernuur na togong iya'a, motolulusan tia mian men kadiiman iya'a. Gubernuur iya'a sa'angu' mian men pande. Ia nengeleelo' i Barnabas tii Saulus, gause ia mingkira' mongorongor wurungna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kasee i Barnabas tii Saulus poosarakon ni Elimas, mian men kadiimanan iya'a, ka' talantangion kada' gubernuur iya'a, sian mamarasaya i Yesus. (Bar Yesus na wurung Yunani ngaanon Elimas.) ");
INSERT INTO blzNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kasee i Saulus men uga' ngaanon i Paulus, ia kuasaimo Alus Molinas. Ia nongororontosimo mian men kadiiman iya'a, ");
INSERT INTO blzNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kasi norobu taena, “Wee i koo, anakna Ibiliis! Koo men mimborek tuu' ka' ba'idek a gau'um! Koo maso'kon giigii' upa men kana'. Nongko'upa i koo se' sian koroko-rokotaan a mingiliaskon Salanna Tumpu men mansalamatkon mian? ");
INSERT INTO blzNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Koini'i piile', Tumpu bo mungukum i koo! Koo bo mampisok pataka i koo sianmo mimiile' ruarna ilio toro pii ilio.” Tempopo iya'a, Elimas nunsuri koi isian seeru' mo'itom nongompot matana, pataka i ia mae' somo mokaakayo mansarak mian bo pimbibit i ia. ");
INSERT INTO blzNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Sarataa gubernuur iya'a nimiile' upa men nosida, ia namarasayamo Tumpu, gause ia nokokana'an tuu' pisiso'na Tumpu men ia tundunkon i Paulus. ");
INSERT INTO blzNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Na kota Pafos i Paulus tia samba-sambana notarabutmo mae' na kota Perga men na libutan Pamfilia. Kasee i Yohanes Markus namarereimo i raaya'a, ka' nomule'kon na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na Perga ari Paulus ningimputkonmo rae'anna na kota Antiokhia na libutan Pisidia. Na ilio Sabat, raaya'a nomae'mo na laigan bakitumpuan ka' no'umoruang. ");
INSERT INTO blzNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Sarataa kitap Musa tia kitap nabii nibasakon, tanaasna laigan bakitumpuan iya'a nomosuu'mo mian bapikirawar ni Paulus tia samba-sambana taena i raaya'a, “Utu-utus, kalu i kuu isian potoomuu bona mian karaani'i, alaka' bantilkon.” ");
INSERT INTO blzNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mbaka' i Paulus norumingkatmo ka' nantabe'i tia limana, kasi norobu taena, “Utu-utusku samba Israel tia giigii' utus sambana karaani'i men layaonkon Alaata'ala! Rongor a wurungku: ");
INSERT INTO blzNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Alaata'ala na samba Israel nungururukimo pulinta, ka' ninsidakon lipu' kani'i biai' tempo i raaya'a dumodongo na Mesir koi mian men notumaka. Kasi tia kuasa men balaki' Alaata'ala nangawawa i raaya'a umuar na Mesir. ");
INSERT INTO blzNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ia uga' sian sungkolkon wawauna i raaya'a na Padang Gurun koi patompulo' taun a nau'na. ");
INSERT INTO blzNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kasee pitu' lipu' na libutan Kana'an Ia silaka'i ka' libutan iya'a Ia obo-oboskon na samba Israel kada' dodongoan iya'a sida tombonoionna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Giigii' iya'a nosida koi paat atu limampulo' taun a nau'na. Noko daa nongoboskon libutan Kana'an, Alaata'ala nantaraimo i raaya'a wawa ukum. Wawa ukum men kokomburi'anna ya'amo i nabii Samuel. ");
INSERT INTO blzNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kasi i raaya'a nama'ase' sa'angu' tomundo'. Alaata'ala nongorookonmo i Saul anak ni Kish men bense' Benyamin, bo pontomundo'i i raaya'a, koi patompulo' taun. ");
INSERT INTO blzNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sarataa Alaata'ala namalaukon i Saul na batomundo'anna, Ia nanganakatmo i Daud bo pontomundo'i samba Israel. Ka' i Daud isian ia ngaan Alaata'ala koi kani'imari tae-Na, ‘Yaku' nantausimo i Daud men anak ni Isai. Ia kokana' na noang-Ku. Iamo a mian men bo pingilimang upa men kikira'-Ku.’ ");
INSERT INTO blzNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Na lee' ni Daud iya'a a men ninsidakonanna Alaata'ala sa'angu' Tomundo' Pansalamatkon bona samba Israel, koi men Ia toonkonmo. Ka' i Yesusmo a Tomundo' Pansalamatkon iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Koo'po tia i Yesus nuntumbei palimangon-Na i Yohanes noko pambantilkonmo na samba Israel, kada' i raaya'a monsosoli ka' mangkadarai wawauna men ba'idek kasi saranion. ");
INSERT INTO blzNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ka' sarataa karani'mo kabus a palimangonna i Yohanes nimikirawarmo na mian biai' taena, ‘Pinginti'imuu, ime mbali' i yaku' kani'i? Yaku' taasi'po mian men peperaionmuu. Kasee porus i yaku', mian iya'a bo taka, ka' mantalu'i sapatonapo kasandangku.’ ");
INSERT INTO blzNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Utu-utus lee' ni Abraham, ka' giigii' utus sambana men isian karaani'i men layaonkon Alaata'ala! Alaata'ala nantakakonmo lele men mansalamatkon na ko'onta'. ");
INSERT INTO blzNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kasee mian men dumodongo na Yerusalem tia tanaasna i raaya'a sian mamarasaya se' i Iamo a pansalamatkon iya'a. Raaya'a sian minginti'i pisiso'na nabii men basaon sanda' ilio Sabat, mbali' i raaya'a nungukum i Yesus. Kasee uga' tia limang men koiya'a, raaya'a nangawawau upa men ia ngaanmo nabii. ");
INSERT INTO blzNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mau mune' i raaya'a sian nantausi titiu'po sala'-Na men sida bo ukumon pate, kasee i raaya'a nama'ase' ni Pilatus kada' i Ia papateion. ");
INSERT INTO blzNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Noko daa i raaya'a ningilimang giigii' koi men nitulis na Alkitaap men muntundun i Ia, raaya'a namalaukonmo biibii-Na na saliip ka' nomokela na lalomna baleanan. ");
INSERT INTO blzNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kasee Alaata'ala nomotuo'i i Ia noko daa lapus. ");
INSERT INTO blzNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ka' koi toro pii ilio i Ia taka nintipiile' na mian men notaka tii Ia mbaripian ringkat na Galilea mae' na Yerusalem. Raaya'amo a men koini'i nosida bo pompopo'inti'ikon i Ia bona samba Israel. ");
INSERT INTO blzNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Mbaka' koini'i kai mantadulkon Lele Pore na ko'omuu, mambantilkon upa men ia toonkonmo Alaata'ala na pulinta. ");
INSERT INTO blzNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Alaata'ala nongololoikonmo toon-Na iya'a na ko'onta' men lee'na i raaya'a tempo i Ia nomotuo'i i Yesus. Ka' men koiya'a, na mazmur korua'na isian nitulis koi kani'imari, ‘Koomo a anak-Ku; ilio kani'i Yaku' mompopanasakon se' i Yaku' a Tamaam.’ ");
INSERT INTO blzNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Alaata'ala nomotuo'imo i Ia noko daa lapus. Koini'i i Ia sianmo lapus. Men koiya'a Alaata'ala isian nangaan tae-Na, ‘Yaku' sabole bo mongorookon na ko'omuu barakaat molinas koi men Yaku' toonkonmo ni Daud.’ ");
INSERT INTO blzNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Koiya'a uga' na mazmur sambana nitundun koi kani'imari, ‘Alaata'ala sian mamatalai mian-Na men malolo' iya'a baras na lalomna baleanan.’ ");
INSERT INTO blzNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daud noko lapusmo ka' nitanom ruru-ruru' tia pulina, noko daa ia ningilimang upa men ia posuu'kon Alaata'ala bo limangonna. Biibiinapo i Daud noko barasmo ka' nokabus. ");
INSERT INTO blzNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kasee i Yesus men ia potuo'i Alaata'ala sianta paraa nobaras. ");
INSERT INTO blzNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mbali' iya'a, utu-utus, kada' bo inti'ionmuu, gause Yesus iya'a, mbali' sida nilelekon na ko'omuu se' dosa sida ampunion. ");
INSERT INTO blzNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ka' mimpu'u na Ko'ona, sanda' mian men parasaya, dosana sida kolekasian, ka' men koiya'a sian tausionmuu na ukum Torat Musa. ");
INSERT INTO blzNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ya'a mbali' i kuu tio mingimamat pore-pore; amo' paraa sida na ko'omuu koi men wurungna nabiina Alaata'ala mbaripian taena, ");
INSERT INTO blzNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Wee i kuu mian men mo'uus mingiroki wurungna Alaata'ala! Imamat pore-pore! Kuu bo samba', kasi lapus! Gause na tempo kani'i i Yaku' pintanga' mingilimang upa men sian parasayaonmuu, mau mune' isian mian men muntundunkon na ko'omuu.’ ” ");
INSERT INTO blzNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sarataa i Paulus tii Barnabas namarerei laigan bakitumpuan iya'a, mian men na laigan bakitumpuan nama'ase' kada' i raaya'a sida taka soosoodo na ilio Sabat men tuntunna, kada' mimisiso'kon bi panasa giigii' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Noko daa mian no'umuar na laigan bakitumpuan iya'a, Paulus tii Barnabas ia lolo'mo samba Yahudi tia mian sambana men ninsoopmo agama Yahudi mbaripianpo ka' layaonkon Alaata'ala. Mbaka' rua' poposuu' iya'a nambantilimo i raaya'a kada' mongooskon kaporeanna Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na ilio Sabat tuntunna, karani' kabus a mian na kota iya'a taka mongorongor wurungna Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sarataa samba Yahudi nimiile' mian biai' iya'a, raaya'a nasindirmo tuu'. Raaya'a ningirokimo i Paulus ka' nanggagai giigii' men ia tundun. ");
INSERT INTO blzNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kasee i Paulus tii Barnabas tongko' batundun. Taena, “Wurungna Alaata'ala mase tio tundunkonon kutung na ko'omuu. Kasee i kuu bude' mangalabot. Kuu a men nuntundun se' i kuu sian sida mangalabot tutuo' men sidutu. Mbaka' koini'i i kai mamarerei i kuu kasi mae' na mian men taasi' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gause ni'imo a men ia posuu'kon Tumpu na ko'omai; taena Tumpu, ‘Yaku' mompoposida i kuu bo sida ruar na mian men taasi' Yahudi, kada' i kuu mansalamatkon mian na longkop tano' balaki'.’ ” ");
INSERT INTO blzNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tempo mian men taasi' Yahudi nongorongor iya'a, raaya'a beles tuu', kasi i raaya'a nuntunde' wurungna Tumpu. Ka' giigii' mian men ia patukomo Alaata'ala bo mantausi tutuo' men pore ka' sidutu uga' noparasaya. ");
INSERT INTO blzNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Wurungna Tumpu uga' notolelemo longkop libutan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kasee moomoola'na kota iya'a tia wiwine angga'ion men layaonkon Alaata'ala, ia asuimo samba Yahudi. Raaya'a nangawawaumo poosasala'an tii Paulus ka' i Barnabas, ka' numbuse'i i raaya'a na libutan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mbaka' poposuu' nangkaberimo awu men na saratna na aropna i raaya'a bookoi mompo'inti'ikon mian iya'a, kasi i raaya'a nomae' na Ikonium. ");
INSERT INTO blzNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mian men malolo' ni Yesus na Antiokhia beles tuu' ka' kuasaionna Alus Molinas. ");
INSERT INTO blzNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na kota Ikonium i Paulus tii Barnabas uga' nomae' na laigan bakitumpuanna Yahudi ka' norobu men somo koiya'a pataka biai' samba Yahudi tia samba Yunani nosida parasaya ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kasee isian samba Yahudi men sian mamarasaya nangasuimo mian men taasi' Yahudi, pataka i raaya'a nangka'ideki mian biai' men parasaya ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mbali' iya'a i Paulus tii Barnabas nodumodongo nanau' indo'o. Ka' i raaya'a sian babata muntundunkon Tumpu na ko'ona i raaya'a. Tumpu uga' nimpipiile'konmo se' kaporean-Na iya'a tuutuu'. Ia nantarai i raaya'a kuasa kada' ari poposuu' sida mangawawau oosan tia upa kosamba'. ");
INSERT INTO blzNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kasee mian na kota iya'a sianmo nopookakana'. Isian men sangada tia samba Yahudi ka' isian men sangada tia ari poposuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kasi samba Yahudi tia tanaasna i raaya'a ka' mian men taasi' Yahudi nosangadamo mantalalais ka' mangalapak ari poposuu' tia watu. ");
INSERT INTO blzNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Sarataa ari poposuu' ninginti'i men koiya'a, mbaka' i raaya'a namareremo na kota Listra tia kota Derbe men na libutan Likaonia, ka' na tiku-tikumna libutan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ka' na libutan iya'a uga' i raaya'a nengelelekonmo Lele Pore soosoodo. ");
INSERT INTO blzNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na kota Listra isian sa'angu' moro'one men repo' a saratna ngame-ngamea'po, pataka mian iya'a sian nontoo tumpang, gause saratna lundeng tuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mian iya'a no'umoruang indo'o, momorongori i Paulus batundun. Paulus nimiile' se' mian repo' iya'a parasaya. Mbali' iya'a, mian iya'a sida lesi'ion. Kasi i Paulus nintioki mian iya'a, ");
INSERT INTO blzNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ka' norobu boolak na mian iya'a taena, “Kekerer bi paloos!” Mian iya'a liuliu nolumonggo' kasi notumumpang. ");
INSERT INTO blzNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sarataa mian biai' nimiile' upa men ia wawau i Paulus iya'a, raaya'a nangkakaro'mo tia wurung Likaonia, taena, “Diim nalaumo na tano' balaki' koi dudusna mian.” ");
INSERT INTO blzNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kasi i raaya'a nangaani i Barnabas i Zeus, ka' i Paulus ia ngaani i raaya'a i Hermes, gause ia a men bukuan morobu. ");
INSERT INTO blzNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Imam diim Zeus, men laigan ponsoosa'anna torumpakion na kota, taka nangawawa toro pii sapi' moro'one tia bunga na soopanna kota iya'a. Ia nolumolo' tia mian biai' bo mongorookon kurbaanna na poposuu' iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Sarataa i Barnabas tii Paulus nongorongor upa men pintanga' wawauonna mian i raaya'a, poposuu' iya'a nembera-berakmo bokukumna ka' notumetende' na tanga-tanga'na mian biai' kasi nangkakaro' taena, ");
INSERT INTO blzNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Wee, no'upaon i kuu se' mangawawau men koi kani'i? Kai kani'i uga' mian men koikoimo i kuu! Kai notaka ka'ita bo mengelelekon Lele Pore na ko'omuu, kada' i kuu mamarerei wawaumuu men sian mingkaliangan, ka' taka na Alaata'ala men tumuo', men ninsidakon langit ka' tano' balaki' ka' tobui tia giigii' isiina. ");
INSERT INTO blzNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tempo mbaripi, Alaata'ala namatalaimo giigii' lipu' tumuo' koi po'uusna i raaya'a sanda-sanda'. ");
INSERT INTO blzNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Maupo koiya'a Ia sinampang mompopo'inti'ikon waka-Na. Ia mimpipiile'kon wawau pore men Ia limangmo. Ia nantarai i kuu usan nda'amari langit ka' uga' dale'na tano' na tempona. Ia nantaraimo i kuu kakaan ka' nompopobeles noamuu.” ");
INSERT INTO blzNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mau mune' poposuu' marepa tuu' mongkokundakon mian mangawawa kurbaan na ko'ona i raaya'a, kasee komburi'na mian uga' sianmo nangawawa. ");
INSERT INTO blzNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Toro pii samba Yahudi taka na Listra norumingkat na Antiokhia na Pisidia tia na Ikonium mantata' mian biai' iya'a, pataka mian biai' notonggilolo'mo na ko'ona i raaya'a. Raaya'a nangalapak i Paulus tia watu, kasi nandaat na liwana kota, gause raaya'a nansarui se' i Paulus nolapusmo. ");
INSERT INTO blzNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kasee sarataa mian biai' men malolo' ni Yesus nokumekerer na tiku-tikumna, Paulus nowangonmo, kasi ninsoop na kota soosoodo. Koi liilana i Paulus tii Barnabas nomae'mo na kota Derbe. ");
INSERT INTO blzNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Na kota Derbe i Paulus tii Barnabas nengelelekonmo Lele Pore, ka' biai' a mian men noparasaya ni Yesus. Sarataa koiya'a i raaya'a nomule'konmo na Listra, ka' na Ikonium, kasi nomae' na Antiokhia men na libutan Pisidia. ");
INSERT INTO blzNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Na kota iya'a, raaya'a nompoporampotmo noana mian men malolo' ni Yesus ka' nambantili i raaya'a kada' sinampang parasaya ni Yesus. Taena, “Kita tio munsuri repaan kutung, kasi sida munsuri beles na Batomundo'anna Alaata'ala.” ");
INSERT INTO blzNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ka' na sanda' jama'at i Paulus tii Barnabas nanganakatmo tanaasna jama'at. Raaya'a sambayang ka' ba'apata kasi nongorookon tanaas iya'a na Tumpu men parasayaonna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Noko daa iya'a ai Paulus tii Barnabas ningimputkonmo rae'anna lumiu na libutan Pisidia pataka na libutan Pamfilia. ");
INSERT INTO blzNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kasi i raaya'a nengelelekon wurungna Alaata'ala na kota Perga, kasi ningimputkon mae' na kota Atalia na soripi'na tobui. ");
INSERT INTO blzNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Na Atalia, raaya'a notarabutmo ka' nomule'kon na Antiokhia, kota men mbaripian nongorookonan i raaya'a na Alaata'ala kada' munsuri barakaat kaporean-Na mingilimang palimangon koi men ia limangmo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sarataa notaka na Antiokhia i raaya'a ningirimpungmo mian na jama'at iya'a, kasi nuntundunkon upa giigii' men ia wawau Alaata'ala na palimangonna i raaya'a. Raaya'a uga' nuntundun koi upa Alaata'ala nantarai salan bona mian men taasi' Yahudi noparasaya ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na kota iya'a i Paulus tii Barnabas, nodumodongo nanau' tia mian men malolo' ni Yesus. ");
INSERT INTO blzNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Toro pii mian na tano' Yudea notaka ka' nimisiso'kon mian men parasaya na Antiokhia se' kalu i raaya'a sian sunaton koi taena ukum Torat Musa, raaya'a sian salamat. ");
INSERT INTO blzNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulus tii Barnabas mompoogagaikon tuu' pinginti'ina toro pii mian iya'a. Komburi'na, nitukokonmo kada' i Paulus tii Barnabas tia toro pii mian sambana men na Antiokhia, mae' na Yerusalem kada' momootunduniikon tia ari poposuu' ka' motu-motu'a na Yerusalem upa men poogagaikononna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mian na jama'at Antiokhia nangator i raaya'a taka liwana kota, kasi i raaya'a nomae' lumiu na Fenisia tia Samaria. Na Fenisia tia Samaria i raaya'a muntundunkon koi upa a mian men taasi' Yahudi men namarasayamo Alaata'ala. Lele iya'a kinobelesna tuu' mian men parasaya indo'o. ");
INSERT INTO blzNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sarataa i raaya'a notaka na Yerusalem, jama'at tia poposuu' ka' motu-motu'a nangalabotimo i raaya'a pore-pore. Kasi i raaya'a nuntundunkon upa men ia wawau Alaata'ala na palimangonna i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kasee toro pii mian Farisi men noparasayamo, norumingkat ka' norobu taena, “Mian men taasi' Yahudi men noparasayamo tio sunaton ka' tio mongololo' ukum Torat Musa.” ");
INSERT INTO blzNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kasi ari poposuu' tia motu-motu'a nobarimpung momootunduniikon upa men ia tundun mian Farisi. ");
INSERT INTO blzNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nanau' tuu' i raaya'a momootunduniikon. Kasi i Simon Petrus nokumekerer ka' norobu taena, “Utu-utus! Kuu ninginti'imo se' mbaripian, Alaata'ala nungururukimo na ko'onta' i yaku' bo pengelelekon Lele Pore na mian men taasi' Yahudi, kada' i raaya'a uga' mongorongor ka' parasaya. ");
INSERT INTO blzNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ka' Alaata'ala men minginti'i noana mian, ninsiso'konmo se' i Ia mangalabot mian men taasi' Yahudi iya'a; Ia ninsiso'kon giigii' iya'a tia nongorookon Alus Molinas na ko'ona i raaya'a koikoimo men Ia rookonmo na ko'onta'. ");
INSERT INTO blzNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pimiile'na Alaata'ala i kita tii raaya'a sian poosasala'. Ia mingilinasi noana i raaya'a, gause i raaya'a noparasayamo. ");
INSERT INTO blzNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kalu koiya'a, nokadai mbali' i kuu koini'i sian momorongori Alaata'ala ka' mo'uus mangkana'kon ukum men marawat bona mian men malolo' ni Yesus, mau mune' pulinta ka' uga' i kitapo sian momoko mingilimang? ");
INSERT INTO blzNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Gause i kita noparasayamo se' i kita nisalamatkon mimpu'u na kaporean ni Yesus Tumpunta. Koiya'a uga' mian men taasi' Yahudi.” ");
INSERT INTO blzNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mbaka' giigii' mian men nobarimpung iya'a somo norokot. Kasi i raaya'a nomorongori i Barnabas tii Paulus muntundun oosan tia upa kosamba' men ia wawaumo Alaata'ala na palimangonna i raaya'a na mian men taasi' Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Noko daa i raaya'a norobu, Yakobus norobu taena, “Utu-utus, porongori kutung i yaku'! ");
INSERT INTO blzNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon baasi nuntundunkon koi upa a Alaata'ala nompopo'inti'ikon pimiile'-Na mian men taasi' Yahudi, ka' mungururuki men sida bo mian-Na. ");
INSERT INTO blzNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Koiya'a sintutu' tia men ia tundunkonmo nabii. Gause isian nitulis koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Taena Tumpu, Noko daa iya'a Yaku' bo mule'kon, ka' momokerer soosoodo laigan ni Daud men nokoruntunmo, ka' montotobo'i runtunanna, ka' mompopomoonggor, ");
INSERT INTO blzNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","kada' giigii' mian men sambana mansarak Tumpu, tonsoop giigii' mian men taasi' Yahudi, men Yaku' leelo'mo bo tombonoion-Ku. Koiya'a a wurungna Tumpu, ");
INSERT INTO blzNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","men Ia bantilkonmo mbaripianpo.’ ” ");
INSERT INTO blzNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kasi taeni Yakobus soosoodo, “Pinginti'ingku i kita sian sida mengerepai mian men taasi' Yahudi men nongorookonmo wakana i raaya'a na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kasee i kita tio muntulis surat bo ko'ona i raaya'a, ka' mambantili kada' i raaya'a alia mangkaan kakaan men kobiit men nikelaikonmo na patung, kabai se' mangkaan antok men sian ni'uarkon a rara'na, kabai mangkaan rara'. Ka' uga' kada' i raaya'a mongoloakon waka na wawau men mogora'. ");
INSERT INTO blzNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gause ukum Torat Musa mbaripianpo nibasakonmo sanda' ilio Sabat na laigan bakitumpuan ka' nibantilkonmo mian na giigii' kota.” ");
INSERT INTO blzNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ari poposuu' tia motu-motu'a ka' giigii' mianna jama'at nosangadamo bo mungururuki toro pii mianna men bo posuu'on mae' na Antiokhia poololo' i Paulus tii Barnabas. Mbaka' i raaya'a nungururukimo i Silas ka' i Yudas men ngaanon i Barsabas. Raaya'a rua' ira tonsoop mian men angga'ionna mian parasaya na Yerusalem. ");
INSERT INTO blzNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Raaya'a uga' namakatu surat na mian men niposuu' iya'a. Isiina surat iya'a koi kani'imari: “Bona giigii' utus men ringkat na toro pii lipu' sambana men taasi' Yahudi, men dumodongo na Antiokhia, Siria ka' Kilikia. Salammai poposuu' tia motu-motu'a men utusmuu. ");
INSERT INTO blzNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kai rongor isian toro pii mianmai men nomae'mo na ko'omuu ka' nompoposiasa tia pisiso'na i raaya'a men sala' pataka i kuu nosiasa. Kasee i kai sian nomosuu' i raaya'a mangawawau men koiya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ya'a mbali' i kai nopootunduniimo, ka' nosangadamo nungururuki toro pii mian ka' nomosuu' i raaya'a mae' na ko'omuu singka-singkat tii Barnabas ka' i Paulus men kolingu'mai. ");
INSERT INTO blzNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Rua' ira kani'i mian men nongorookonmo noana gause na pongololo'an Tumpunta i Yesus Kristus. ");
INSERT INTO blzNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ya'a mbali' i kai nomosuu'mo i Yudas tii Silas mae' na ko'omuu. Raaya'a uga' bo mambantilkon na ko'omuu isiina surat kani'i. ");
INSERT INTO blzNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Gause Alus Molinas ka' i kai uga' nansangadaimo kada' i kuu sobii ka' posuu'on mingilimang upa men marawat saliwakon mingilimang men tio limangonmuu koi kani'imari: ");
INSERT INTO blzNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Alia mangkaan kakaan men nikelaikonmo na patung, alia mangkaan rara', alia mangkaan antokna ayop men sian ni'uarkon a rara'na ka' alia mogora'. Kalu i kuu umoloa na giigii' wawau men koiya'a i kuu nangawawaumo men pore. Koiya'amo kutung. Tabea'mai!” ");
INSERT INTO blzNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sarataa nobasiloloa, Yudas tii Silas nomae'mo na Antiokhia. Na Antiokhia i raaya'a nengeleelo'mo giigii' mianna jama'at barimpung, kasi i raaya'a nongorookon surat iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Sarataa mian na jama'at nambasa surat iya'a, raaya'a nobeles tuu' gause isiina surat iya'a mantata'u noana i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudas tii Silas men uga' nabii, nanau' nambantili utus sa'angu' kaparasaya'an na Antiokhia ka' nompoporampot imaanna i raaya'a tia nompopomoonggor. ");
INSERT INTO blzNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ka' sarataa i Yudas tii Silas nodumodongo nanau' na Antiokhia, mian parasaya men na Antiokhia nompoporingkatmo i raaya'a tia noa beles kada' mule'kon na dodongoanna mian men nomosuu' i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kasee i Silas nongotoongmo noa se' i ia dumodongomo na Antiokhia. ");
INSERT INTO blzNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus tii Barnabas uga' nodumodongomo nana-nanau' na Antiokhia. Indo'o i raaya'a tia biai' mian sambana singka-singkat nimisiso'mo mian ka' nengelelekon wurungna Tumpu. ");
INSERT INTO blzNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Noko daa koiya'a i Paulus norobumo ni Barnabas taena, “Mai kita mule'konmo mengelego'i utus sa'angu' kaparasaya'an na giigii' kota men nengelelekonanta wurungna Tumpu, kada' piile'onta too koi upamo i raaya'a.” ");
INSERT INTO blzNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas mo'uus mangawawa i Yohanes Markus, ");
INSERT INTO blzNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kasee i Paulus sian mansangadai, gause i Yohanes Markus bude' pootulungi ka' uga' namarerei i raaya'a na Pamfilia. ");
INSERT INTO blzNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mbaka' i Paulus tii Barnabas nopoogagaimo tamban poomaso-maso'kon ka' komburi'na i raaya'a nobarensa-rensamo. Barnabas nangawawamo i Markus ka' notarabut mae' na Siprus. ");
INSERT INTO blzNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulus nungururuki i Silas, kasi utus sa'angu' kaparasaya'an na Antiokhia nongorookon i raaya'a na Tumpu kada' munsuri barakaat kaporean-Na. Noko daa iya'a, kasi Paulus tii Silas nomae'. ");
INSERT INTO blzNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Raaya'a nomae'mo tikum Siria tia Kilikia ka' nompoporampot noana mian men na jama'at. ");
INSERT INTO blzNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ari Paulus ningimputkonmo rae'anna i raaya'a na Derbe tia na Listra. Na Listra isian sa'angu' mian men malolo' ni Yesus, ngaanna i Timotius. Sinana samba Yahudi men noparasayamo ni Yesus, kasee tamana samba Yunani. ");
INSERT INTO blzNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotius tolele na mian parasaya men dumodongo na Listra tia Ikonium se' sa'angu' mian men pore a noana. ");
INSERT INTO blzNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus mo'uus kada' i Timotius lumolo' tii ia. Mbali' iya'a i Paulus nunsunatmo i Timotius. Ia nangawawau koiya'a, gause giigii' samba Yahudi na libutan iya'a ninginti'i se' tama ni Timotius samba Yunani. ");
INSERT INTO blzNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na sanda' kota men rae'ionna i raaya'a, bantilkononna na mian men parasaya na Tumpu a giigii' kasangadaan men ia tukokonmo ari poposuu' tia motu-motu'a na Yerusalem. Raaya'a mambantili mian men noparasayamo na Tumpu, kada' mongololo' aturan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mbaka' mian na jama'at iya'a nokanturanganmo rampot a kaparasaya'anna i raaya'a, ka' sanda' ilio kanturangan a kobiai'na i raaya'a men parasaya. ");
INSERT INTO blzNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Alus Molinas sian nomoturang i Paulus tii Silas mengelelekon wurungna Alaata'ala na poropinsi Asia. Mbaka' i raaya'a ningimputkonmo mae' na libutan Frigia tia Galatia. ");
INSERT INTO blzNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Sarataa notaka na pookotoonan tia Misia i raaya'a nontopongimo ninsoop na poropinsi Bitinia, kasee Alus ni Yesus nongkokundakon i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mbaka' sarataa noporus Misia i raaya'a liuliu nomae' na Troas. ");
INSERT INTO blzNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Malomna na Troas i Paulus nimiile'mo simpalaalung. Na simpalaalung iya'a ia nimiile' sa'angu' mian samba Makedonia kere-kerer na aropna ka' kumakaase' tuu' kada' i Paulus mae' na Makedonia ka' muntulung i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Gause isian simpalaalung iya'a, mbaka' i kai liuliu nobatotobo' ka' nomae' na Makedonia. Kai parasaya se' Alaata'ala a men nomosuu' i kai mae' mengelelekon Lele Pore na samba Makedonia. ");
INSERT INTO blzNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kasi i kai namarerei Troas ka' notarabut mae' na Samotrake. Koi liilana, kai nomae'mo na kota Neapolis. ");
INSERT INTO blzNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Na Neapolis kasi kai nomae' na Filipi, sa'angu' kota na lipu' Makedonia men mangalalabii kota sambana koramena. Filipi tonsoop sa'angu' kota men biai' a samba Roma dumongo. Na Filipi i kai nodumodongo toro pii ilio. ");
INSERT INTO blzNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na ilio Sabat i kai nomae'mo lumolo' soripi'na weer kauna na liwana soopan balaki' na kota iya'a, gause i kai munsuri se' na libutan iya'a isian basambayanganna samba Yahudi. Kasi i kai no'umoruang ka' nobatundun tia wiwine men nobarimpung na basambayangan iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wiwine men nobarimpung iya'a, isian sa'angu' pobaluk toik kamumu', ngaanna i Lidia. Ia mian na kota Tiatira, ka' i ia monsoosa' Alaata'ala. Alaata'ala nongoloangimo noana kada' mangalabot upa men pisiso'konon ni Paulus na ko'ona. ");
INSERT INTO blzNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mbaka' i Lidia sangkau laigan nisaranimo. Noko daa nisarani i ia nengeleelo'mo i kai, kasi norobu taena, “Kalu i kuu munsuri se' i yaku' tuutuu' parasayamo ni Yesus, mai i kita tuuk kutung na laiganku.” Koiya'a a nampari-parina kada' i kai mongololoikon pa'ase'na. ");
INSERT INTO blzNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Na sa'angu'mo ilio, tempo i kai potobantang mae' na basambayangan, kai nopootuung tia sa'angu' ata' wiwine. Wiwine iya'a ia lampingi meena pataka i ia momoko mompopo'inti'ikon upa men bo sida na ilio komburi'. Wawauna wiwine iya'a men mompopo'inti'ikon tutuo'na mian, mantakakon ule' balaki' bona mian men montombonoi i ia. ");
INSERT INTO blzNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wiwine iya'a lolo-lolo' i Paulus tii kai, ka' mangkakaro' taena, “Mian karaani'i posuu'na Alaata'ala na ko'alayo'an! Raaya'a taka bo mambantilkon na ko'omuu koi upa a wawaumuu kada' i kuu salamat.” ");
INSERT INTO blzNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Toro pii ilio wiwine iya'a tongko' karo-karo'. Paulus sianmo nokotaan, mbaka' ia ningilingamo wiwine iya'a kasi norobu na meena iya'a taena, “Mimpu'u ni Yesus Kristus, yaku' momosuu' i koo umuar na wiwine kaya'a!” Mbaka' meena iya'a liuliu namarerei wiwine iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Sarataa men tombono ata' iya'a nunsuri se' pantausianna i raaya'a doi' sianmo isian, raaya'a nangarakopmo i Paulus tii Silas, kasi nandaat na tolodona pamarenta moola' kada' wawaon na pamarenta men mungkuasai. ");
INSERT INTO blzNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Raaya'a nangawawamo i Paulus tii Silas na i'intoni kuasa na Roma, kasi norobu taena, “Mian karaani'i samba Yahudi. Raaya'a monggora' kota dodongoanta kani'i. ");
INSERT INTO blzNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Raaya'a mimisiso' mian mingilimang adat men dele wawauon men pootetengkea'i tia ukumta na Roma. Kita sian sida mangalabot kabai se' mongololo' adat men dele wawauon men koiya'a!” ");
INSERT INTO blzNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mbaka' mian biai' uga' nongololo'mo nintimbangi i Paulus tii Silas, ka' pamarenta moola' nomosuu' mian nemberak pakean men potopisok nari poposuu' iya'a, kasi nomosuu' mian nembebot i raaya'a rua' ira. ");
INSERT INTO blzNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sarataa i raaya'a nibebot men tamban dodoa, raaya'a nisoopkonmo na tarungkuan. Tanaasna tarungkuan iya'a niposuu'mo kada' mandagai i raaya'a pore-pore. ");
INSERT INTO blzNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Gause isian posuu' iya'a, mbaka' tanaasna tarungkuan nantaankonmo i Paulus tii Silas na tambinna tarungkuan men na tanga', ka' nangkalo' saratna i raaya'a tia balak. ");
INSERT INTO blzNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Toro tanga'namo rondom i Paulus tii Silas pintanga' sambayang ka' muntunde' Alaata'ala tia nanian; mian sambana men na tarungkuan iya'a uga' nomorongor i raaya'a manani. ");
INSERT INTO blzNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ola-olan isian lili' men balaki' tuu', pataka pandasi na tarungkuan iya'a uga' tololo' nokoyunggot. Giigii' omporonna tarungkuan nokobongkatian ka' giigii' rante men nipungukon mian na tarungkuan uga' nokolekasian. ");
INSERT INTO blzNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mbaka' tanaasna tarungkuan iya'a nowangonmo notongkodi'. Sarataa ia nimiile' omporonna tarungkuan se' potoleak, ia numbubutmo bakoko'na bo mintikoyo', gause ia nansarui too mian na tarungkuan kabusmo namarere. ");
INSERT INTO blzNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kasee i Paulus nengeleelo' booboolak taena, “Alia mintipate! Kai giigii' dauga' karaani'i!” ");
INSERT INTO blzNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tanaasna tarungkuan iya'a nama'ase'mo boloak, kasi notumetende' nangkaba' ninsoop na lalomna, ka' nintisumpul ranggu-ranggugur na arop ni Paulus tii Silas. ");
INSERT INTO blzNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kasi ia nangawawa i raaya'a umuar ka' norobu taena, “Tuan, upa a men tio limangonku kada' i yaku' salamatkonon?” ");
INSERT INTO blzNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ia simbati Paulus tii Silas taena, “Parasayamo ni Tumpu Yesus Kristus, kada' i koo salamat, koo tia giigii' mian men na laigaan!” ");
INSERT INTO blzNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kasi i Paulus tii Silas nuntundunkon wurungna Tumpu na tanaasna tarungkuan iya'a tia na giigii' mian men dumodongo na laiganna. ");
INSERT INTO blzNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tanga'na rondompo iya'a uga' tanaasna tarungkuan iya'a nangawawamo i raaya'a, kasi nongoso'ikon belana. Ka' i ia tia giigii' mian men na laiganna liuliu nisarani. ");
INSERT INTO blzNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Noko daa iya'a, tanaasna tarungkuan nangawawamo i Paulus tii Silas na laiganna ka' nantaropi kakaan. Tanaasna tarungkuan sangkau laigan beles tuu', gause i raaya'a giigii' noparasayamo na Alaata'ala. ");
INSERT INTO blzNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Koi liilana ma'ulop i'intoni kuasa na Roma nomosuu'mo pulisi mae' na tarungkuan ka' nambantilkon kada' i Paulus tii Silas uarkononmo na tarungkuan. ");
INSERT INTO blzNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tanaasna tarungkuan iya'a nambantilkonmo ni Paulus tii Silas taena, “Tuan, i'intoni kuasa nambantilkonmo kada' i kuu uarkononmo. Koini'i i kuu sidamo mule'kon. Maka'amatsi na salan!” ");
INSERT INTO blzNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kasee i Paulus norobu na pulisi iya'a taena, “Kai samba Roma. Sianpo tia ni'ukumi i kai nipoko bebotmo na aropna mian biai' ka' nisoopkon na tarungkuan. Mune' koini'i i raaya'a momosuu' i kai mae' potorokot? Kai bude' koiya'a. Posuu' a i'intoni kuasa kada' taka ka'ita munguarkon i kai.” ");
INSERT INTO blzNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pulisi nambantilkonmo na i'intoni kuasa na Roma. Sarataa ia rongor se' i Paulus tii Silas iya'a samba Roma, raaya'a natakutmo. ");
INSERT INTO blzNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kasi i raaya'a nomae' ni Paulus tii Silas mama'ase' kada' amo' kookoo'ion, ka' nangator i raaya'a rua' ira umuar na tarungkuan, ka' nama'ase' kada' i raaya'a mamarerei kota iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulus tii Silas namarereimo tarungkuan iya'a, ka' nomae' na laigan ni Lidia. Raaya'a nopootatakai tia mian parasaya ka' nompoporampot noana i raaya'a. Sarataa koiya'a kasi ari Paulus nomae'. ");
INSERT INTO blzNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulus tii Silas ningimputkonmo rae'anna i raaya'a lumiu na Amfipolis tia Apolonia, kasi notaka na kota Tesalonika. Na Tesalonika isian laigan bakitumpuanna samba Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ka' i Paulus uga' nomae' na laigan bakitumpuan iya'a, koi men mala' wawauonna kalu isian laigan bakitumpuanna samba Yahudi. Ia nomootunduniikonmo Alkitaap koi porotolu Sabat pootuntun. ");
INSERT INTO blzNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ia nompopo'inti'ikon ka' nompopanasakon se' Tomundo' Pansalamatkon men ia toonkon Alaata'ala tio munsuri repaan ka' lapus, kasi tumuo' soosoodo moko daa lapus. Ka' taeni Paulus, “Yesus men lelekononku na ko'omuu iya'a, Iamo a Tomundo' Pansalamatkon men nitoonkon.” ");
INSERT INTO blzNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Toro pii mian sida noparasaya, kasi nongololo' i Paulus tii Silas. Koiya'a uga' biai' a samba Yunani men mangangga'i ka' malolo' na Alaata'ala, tia biai' wiwine men tongaan. ");
INSERT INTO blzNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kasee samba Yahudi nasindirmo. Raaya'a nengeleelo'mo mian men tongko' potolaak na salan ka' nopoosangadai mangawawau kogora'an, kasi minsiasa kota iya'a ka' nuntumburi sa'angu' mian parasaya men ngaanna i Yason na laiganna. Raaya'a mansarak i Paulus tii Silas, gause i raaya'a bo mangawawa i Paulus tii Silas na liwa na aropna mian biai'. ");
INSERT INTO blzNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kasee sarataa i raaya'a sian nungurumpaki i Paulus tii Silas, raaya'a nandaatmo i Yason tia toro pii mian parasaya sambana na aropna pamarenta men pungkuasai na kota iya'a. Raaya'a mangkakaro' taena, “Mian men mangawawau kogora'an waale'e-le'emari notakamo. Koini'i, kota dodongoantapo ia pinsoopimo i raaya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ka' i Yason uga' nangalabotimo i raaya'a na laiganna. Raaya'a giigii' nunguluanimo upa men ia tukokonmo Kaisar, gause i raaya'a nangaan se' isian tomundo' sambana men ngaanon i Yesus.” ");
INSERT INTO blzNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wurungna i raaya'a men koiya'a nanggau'konmo mian biai' tia pungkuasai kota iya'a nosida siasa. ");
INSERT INTO blzNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kasi pungkuasai na kota iya'a nomosuu' i Yason tia mian parasaya men sambana mambayar doi' pataru. Noko daa iya'a, kasi i raaya'a nipatalai mae'. ");
INSERT INTO blzNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Malompo iya'a, mian parasaya na kota iya'a nomosuu'mo i Paulus tii Silas mae' na kota Berea. Taka-taka na Berea i Paulus tii Silas nomae'mo na laigan bakitumpuanna samba Yahudi. ");
INSERT INTO blzNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Samba Yahudi na Berea a porena noa tia samba Yahudi men na Tesalonika. Raaya'a nobeles tuu' nongorongor lele ni Yesus, ka' sanda' ilio i raaya'a mansarak minginti'i isiina Alkitaap bo pinginti'ianna i raaya'a too tuutuu' a men pisiso'konon ni Paulus. ");
INSERT INTO blzNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Biai' i raaya'a men noparasaya ni Yesus, ka' taasi' titiu' a samba Yunani men tongaan men noparasaya ni Yesus, mau wiwine ka' uga' moro'one. ");
INSERT INTO blzNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Sarataa samba Yahudi men na Tesalonika nongorongor se' i Paulus nengelelekonmo wurungna Alaata'ala na Berea, raaya'a uga' nomae'mo na Berea ka' nangasui, kasi nangawawau mian na Berea sida siasa. ");
INSERT INTO blzNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kasee mian parasaya men na Berea nangatormo i Paulus donga-dongan na soripi'na tobui, ka' i Silas tii Timotius dauga' nodumodongo na kota iya'a. ");
INSERT INTO blzNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Noko daa nangator i Paulus taka Atena, utus sa'angu' kaparasaya'an iya'a nomule'konmo na Berea nangawawa potuun ni Paulus kada' i Silas tii Timotius muntuntuni i ia donga-dongan. ");
INSERT INTO blzNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pintanga' i Paulus mempeperai i Silas tii Timotius na kota Atena, noana nasiongo'mo nimiile' na kota iya'a biai' tuu' a patung niwawau bo kanggion. ");
INSERT INTO blzNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mbali' iya'a na laigan bakitumpuan, Paulus pootundunii tia samba Yahudi ka' mian sambana iraando'o men daa layaonkon Alaata'ala. Koiya'a uga' na pasar, sanda' ilio ia pootundunii tia sanda' mian men isian na pasar. ");
INSERT INTO blzNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Guru men mingintoni pisiso' na mian Epikuros tia pisiso'na mian Stoa uga' nopoogagai tii ia. Toro pii guru iya'a norobu taena, “Upa a men inti'ionna mian kaya'a? Pinginti'ianna tongko' titiu', kasee i ia biai' a tundunanna!” Ka' toro pii mian sambana nangaan taena, “Paasan i ia mengelelekon diimna lipu' sambana.” Raaya'a morobu koiya'a, montookon i Paulus muntundun Lele Pore men ringkat ni Yesus, ka' muntundun i Yesus men nipotuo'i noko daa lapus. ");
INSERT INTO blzNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kasi i raaya'a nangawawa i Paulus na pootatakaian na Buu'na Areopagus. Inda'a i raaya'a norobumo ni Paulus, taena, “Kai mo'uus mongorongor pisiso' u'uru men lelekonoon. ");
INSERT INTO blzNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ka' gause i koo muntundunkon upa-upa men sian dele rongoronmai, mbaka' koini'i i kai mo'uus minginti'i aratina.” ");
INSERT INTO blzNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Gause giigii' samba Atena tia mian notumaka men nodumodongo indo'o mo'uus tuu' mondolangkon tempo momorongori kabai se' momootunduniikon upa men dauga' u'uru na ko'ona i raaya'a.) ");
INSERT INTO blzNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tempo i Paulus nokumekerer na aropna mian men nobarimpung na Areopagus iya'a i Paulus norobumo taena, “Tabea' na ko'omuu, samba Atena! Yaku' nimiile' se' na upa giigii', kuu pa'agama tuu'. ");
INSERT INTO blzNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Gause tempo i yaku' nansasayoi tikum kotamuu ka' namakanasai biai' kaliangan upa men kanggionmuu, yaku' uga' nimiile' sa'angu' pomokelaanmuu kelai men nitulisii koi kani'imari: ‘Bona Tumpu Men Sian Ni'inti'i.’ Bantilkononku na ko'omuu, se' Tumpu men soosa'onmuu kasee sian inti'ionmuu, nono'mo a men lelekononku na ko'omuu. ");
INSERT INTO blzNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Alaata'ala men ninsidakon dunia kani'i tia giigii' isiina i Iamo a Tumpu mau na langit ka' uga' na tano' balaki'. Ia sian dumodongo na laigan ponsoosa'an men wawauonna mian. ");
INSERT INTO blzNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ia uga' mosoo tulungionna mian, gause Iamo a men mantarai tuo' tia noa ka' giigii' upa na mian. ");
INSERT INTO blzNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ringkat na sa'angu' mian Ia nangawawaumo giigii' lipu' 