﻿USE sofia;
DROP TABLE IF EXISTS sofia.blx_vpl;
CREATE TABLE blx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES blx_vpl WRITE;
INSERT INTO blx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ati ya listaan mani ninunun Jesu Cristu ya layin David ya layin Abraham. ");
INSERT INTO blx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham ya bapan Isaac, si Isaac ya bapan Jacob, buy si Jacob ya bapan Juda buy ya mapatêl na. ");
INSERT INTO blx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda ya bapa lan Fares buy si Zara, buy si Tamar ya indu la, si Fares ya bapan Esrom, buy si Esrom ya bapan Aram. ");
INSERT INTO blx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram ya bapan Aminadab, si Aminadab ya bapan Naason, buy si Naason ya bapan Salmon. ");
INSERT INTO blx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon buy si Rahab ya bapa buy indu nan Boaz, si Boaz ya bapan Obed buy si Ruth ya indu na, buy si Obed ya bapan Jesse. ");
INSERT INTO blx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Jesse ya bapan Arin David buy si Arin David ya bapan Solomon. (Ya indu na sabay ya manan asawan Urias.) ");
INSERT INTO blx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon ya bapan Rehoboam, si Rehoboam ya bapan Abias, buy si Abias ya bapan Asa. ");
INSERT INTO blx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa ya bapan Jehoshafat, si Jehoshafat ya bapan Joram, buy si Joram ya bapan Ozias. ");
INSERT INTO blx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Ozias ya bapan Jotam, si Jotam ya bapan Ahaz, buy si Ahaz ya bapan Ezequias. ");
INSERT INTO blx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Ezequias ya bapan Manases, si Manases ya bapan Amos, buy si Amos ya bapan Josias. ");
INSERT INTO blx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias ya bapan Jeconias buy mapatêl na. Sa panawun abiin, dinakêp pa mani Israelita buy inipus sila sa Babilonia. ");
INSERT INTO blx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pamakayari silan inipus sa Babilonia, nagin anak Jeconias si Salatiel buy si Salatiel ya bapan Zerubabel. ");
INSERT INTO blx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Zerubabel ya bapan Abiud, si Abiud ya bapan Eliaquim, buy si Eliaquim ya bapan Azor. ");
INSERT INTO blx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Azor ya bapan Sadoc, si Sadoc ya bapan Aquim, buy si Aquim ya bapan Eliud. ");
INSERT INTO blx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud ya bapan Eleazar, si Eleazar ya bapan Matan, buy si Matan ya bapan Jacob. ");
INSERT INTO blx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob ya bapan Jose ya asawan Maria. Si Maria ya indun Jesus ya pambêgên Cristu. ");
INSERT INTO blx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kabay dilag gan mapu buy apat ta layi ya ubat kan Abraham angga kan David, dilag mapu buy apat ta layi ya ubat kan David angga sa pangaipus mani Israelita sa Babilonia, buy dilag mapu buy apat ta layi ya ubat sa pangaipus angga sa in-anak si Jesus ya pambêgên Cristu. ");
INSERT INTO blx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Paradi ya pamianak kan Jesu Cristu. Si Maria ya indu na, nakal-an nan itangên kan Jose. Nuwa bayu sila miawyun, natandan Mariay nabuktut ya sa kapamilatan Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si Jose ya mapag-asawa na, gisa yan matinêk ka tawu buy a na labay mipakadêng-êy si Maria. Kabay naisip nay makisyay ya kan Maria un liim. ");
INSERT INTO blx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nuwa kaban pan-isipin Jose ya abitu, nagpakit sa sulêplêp nay gisay ang-el Bapan Namalyari ya nagsabin, “Jose, layin David, agana ka malimun tangênên si Maria tagawan nangalêk ya sa kapamilatan Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Manganak yan gisay liyaki buy ya ipalagyu mu kana, Jesus, tagawan iligtas nay mani tawu na sa mani kasalanan la.” ");
INSERT INTO blx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nalyari ya kaganawan abiin amên matupad da sinabin Bapan Namalyari sa kapamilatan propeta, ");
INSERT INTO blx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mangalêk ka gisay dalaga buy manganak yan gisay liyaki. Bêgên yan Emmanuel.” (Ya labay sabin Emmanuel, “Kaawyun tamuy Bapan Namalyari.”) ");
INSERT INTO blx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sên nimata si Jose, sinunul nay sinabin ang-el Panginuun buy tinangên na si Maria. ");
INSERT INTO blx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nuwa a na ginêtan si Maria angga sa naianak nay gisay liyaki. Sên naianak kay kulaw, impalagyuy nan Jose kanay Jesus. ");
INSERT INTO blx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","In-anak si Jesus sa balayan Bethlehem sa prubinsyan Judea sabitun si Herodes ya ari. Gisay allu, inlumatêng sa Jerusalem ya dakun umnuy tawu ya mag-aral sa pagkimit bêtêwên. Ubat sila sa êtêb puputakan mamut. ");
INSERT INTO blx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Namatang sila, “Saantuy pinianakan sa Arin mani Judio? Impatang yan na ati gawan nakit yan na bêtêwên sa puputakan mamut ya tanda' nu saantu ya in-anak. Kabay naku kay baydi amên ulimênên yan ya.” ");
INSERT INTO blx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sên natandan Arin Herodes ya ati, nigaganaka ya buy para êt bayduy kaganawan tawuy idi sa balayan Jerusalem. ");
INSERT INTO blx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kabay impabêg Herodes ya kaganawan mamunun pari buy mani manurun Kautusan amên ipatang na kallay, “Saantu ianak si Cristu?” ");
INSERT INTO blx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nakitbay sila, “Sa Bethlehem ma sakup prubinsyan Judea, tagawan paradi ya insulat propeta, ");
INSERT INTO blx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sikaw wa mani tawu sa Bethlehem sa lutan Juda, alwan sikaw wa pinakanayêpa sa mani balayan Juda, tagawan maubat kamuyuy gisay mamunu ya magpastul sa mani Israelita.’ ” ");
INSERT INTO blx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sên natandan Herodes ya ati, liim nan impabêg ga mani tawuy mag-aral sa pagkimit bêtêwên buy natandan nay luway tawun nay inlumibas. ");
INSERT INTO blx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pamakayari, impalaku na sila sa Bethlehem. Intipan na kallay, “Mita kawna buy pakangêdên yun têkapên na kulaw. Nu makitan yu, tambêng yun ibalita kangku amên maku waku êt mangulimên kana.” ");
INSERT INTO blx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pamakayari lan nalêngêy intipan Ari, namita silayna. Kaban mamita sila, nanguman nagpakit ta bêtêwên na nakitan la sa puputakan mamut. Kabay sadyay saya la buy sinunul lay ati angga sa nilatêng sila sa binyanan kulaw. ");
INSERT INTO blx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pamakasun la sa bali, nakitan lay kulaw wa idi sa danin indu na ya si Maria. Nanduku sila amên ulimênên lay kulaw buy in-awas lay mani gintan lay gintu, insensu, buy mira amên iandug kana. ");
INSERT INTO blx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sên pauli silayna, nagsabi si Bapan Namalyari sa kapamilatan taynêp la, “Agana kawna mag-udung kan Herodes.” Kabay dinuman sila tana sa kaatag dan pauli. ");
INSERT INTO blx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sên namitay nay mani mag-aral sa pagkimit bêtêwên, nagpakit sa taynêp Jose ya gisay ang-el Panginuun. Sinabin ang-el kana, “Mimata ka, gêtan muy mitaindu buy mita kaw papakun sa Egipto. Manugêl kaw pun baydu anggan a ku pun sabin na mag-udung kawna, tagawan pantêkapên Herodes ya anak amên patin.” ");
INSERT INTO blx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kabay sa yabin abitu, nimata si Jose buy gintan nay mitaindu sa Egipto. ");
INSERT INTO blx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Buy nanugêl sila baydu angga sa nati si Arin Herodes. Sa pakapakun baydu, natupad da sinabin Bapan Namalyari sa kapamilatan propeta, “Binêg kuy anak ku amên mita sa bansan Egipto.” ");
INSERT INTO blx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sên natandan Arin Herodes ya inlinlang yan mani lawyaki ya mag-aral sa pagkimit bêtêwên, sadyay tubag na. Kabay ya kaganawan anak ka lawyaki sa Bethlehem ya idad luway tawun payêpa buy sa mani lugal la nakapalitêng baydu, impapati na sila. Tagawan abituy tawun na natandan na nu nakanu nunan nagpakit ta bêtêwên sa mani lawyaki ya mag-aral sa pagkimit bêtêwên. ");
INSERT INTO blx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sa kadawakan na dinyag Herodes, natupad da sinabin Propeta Jeremias, ");
INSERT INTO blx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dilag yan nalêngêy tangisan buy masnêg ga alab sa balayan Rama. Pantangisan Raquel la mani anak na. Ayin makasamung sa panangis na tagawan nati silayna.” ");
INSERT INTO blx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pamakamatin Herodes, kaban idi sa Egipto si Jose, nanguman nagpakit kanay gisay ang-el Bapan Namalyari sa kapamilatan taynêp na. ");
INSERT INTO blx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Sinabin ang-el kana, “Jose, mimata ka. Iuli minay mitaindu sa Israel, ta nati yay kalabay mamatin anak.” ");
INSERT INTO blx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kabay nimata si Jose buy in-uli nay mitaindu sa Israel. ");
INSERT INTO blx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nuwa sên natandan Jose ya si Arquelao ya ari sa Judea ya kasagilin bapa nay si Herodes, nalimwan lay nan maku baydu. Kabay nanguman yan pinatandan Bapan Namalyari sa kapamilatan taynêp buy nagdaus sila sa Galilea. ");
INSERT INTO blx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Buy nanugêl sila sa Nazaret. Sa pakapakun baydu, natupad da sinabin mani propeta, “Bêgên Nazarenu” ya Cristu. ");
INSERT INTO blx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sa panawun abitu, inlumatêng si Juan ya Mamawtismu sa kakyangan sa prubinsyan Judea ya mangaral paradi, ");
INSERT INTO blx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pagsisyan buy itgên yuy panyag kasalanan, tagawan marani yanay pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan na pantukuyun Propeta Isaias sabitun sinabi nay, “Dilag gisay mamibêg sa kakyangan ya pansabin na ‘Il-an yuy danan Panginuun. Itinêk yuy balang danan na.’ ” ");
INSERT INTO blx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ya yaming Juan, diyag sa sabut kamelyu buy diyag sa balat ayup pa yakês na. Ya pangkanên na, durun buy pulut panilan. ");
INSERT INTO blx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Malakêy tawuy naku kana ubat sa balayan Jerusalem, sa mani lugal sa prubinsyan Judea, buy sa mani lugal sa palitêng ilug Jordan. ");
INSERT INTO blx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sinabi lay mani kasalanan la buy binawtismuwan silan Juan sa ilug Jordan. ");
INSERT INTO blx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nuwa sên nakitan Juan na malakêy Pariseo buy Saduseo ya mamaku êt magpabawtismu, sinabi na kalla, “Sikaw wa kaparisun lupung, sisabêt ta nagsabi kamuyun makatakas kaw sa lumatêng nga parusan Bapan Namalyari? ");
INSERT INTO blx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nu pêtêg kaw nagsisi sa mani kasalanan yu, ipakit yu sa mani diyag yu. ");
INSERT INTO blx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Agana yu isipin na a kaw maparusan gawan layi kaw Abraham. Pansabin ku kamuyuy agyan na mani batun ati, madyag Bapan Namalyarin mani layin Abraham. ");
INSERT INTO blx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Amêsên, kaparisu kaw kayuy asê managêy mangêd. Kabay nakal-an nan mamarusa si Bapan Namalyari kamuyu ya paran palatsaw wa nakal-an nan mamutus puun kayu buy isamwag sa apuy.” ");
INSERT INTO blx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Pambawtismuwan kataw sa lanêm bilang pagpapêtêg sa pagsisi yu, nuwa dilag gisay lumatêng nga makapangyarian pun kangku. A ku sêpat mantan sandalyas na. Bawtismuwan nakaw sa Ispiritun Bapan Namalyari buy apuy. ");
INSERT INTO blx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Siyay mamipapawan mapanyag kangêdan sa mani mapanyag kadawakan kaparisun gisay mamibalusbus trigu. Ta ya triguy naibalusbus sana, sabay ya pan-isêmpan. Nuwa ya apa, sabay ya pan-ulamên sa apuy ya asê mangapalêng.” ");
INSERT INTO blx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Inlumatêng si Jesus sa Ilug Jordan ya ubat sa prubinsyan Galilea amên magpabawtismu kan Juan. ");
INSERT INTO blx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nuwa asê dayi kalabay si Juan ya bawtismuwan na si Jesus. Kabay sinabin Juan, “Siku dayi ya sêpat mun bawtismuwan, nuwa siyan sika yay magpabawtismu kangku ta?” ");
INSERT INTO blx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nuwa nakitbay si Jesus kana, “Pasawan mun malyari amêsên na ati, gawan ati ya sêpat tan daygên amên matupad da buun kalabayan Bapan Namalyari.” Kabay nakalabay si Juan. ");
INSERT INTO blx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sên nabawtismuwan na si Jesus, nagsalwang ya sa lanêm buy nakitan nay nawang-at ta langit buy nagtabuy kanay Ispiritun Bapan Namalyari ya nanuwad gisay pati-pati. ");
INSERT INTO blx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Buy dilag gisay tunuy ya ubat sa langit ta nagsabin, “Ati ya kakaidwan kun Anak ya kapapaidu kangku.” ");
INSERT INTO blx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pamakayari, impalêt Ispiritun Bapan Namalyari si Jesus sa kakyangan amên tuksun Satanas. ");
INSERT INTO blx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Baydun nag-ayunu si Jesus un apattapuy allu buy apattapuy yabi. Kabay inlayang ya. ");
INSERT INTO blx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Inlumatêng amêsên na mapanuksuy Satanas buy sinabi na kana, “Nu sikay Anak Bapan Namalyari, daygên mun kanên na mani batun ati.” ");
INSERT INTO blx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nuwa nakitbay si Jesus, “Idi sa kasulatan, ‘Alwan kay sa kanên mambumyay ya tawu, nun a sa balang Sabin Bapan Namalyari.’ ” ");
INSERT INTO blx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pamakayari, pikilaku yan Satanas sa têngêl Templu sa Jerusalem ");
INSERT INTO blx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","buy sinabi na kan Jesus, “Nu sikay Anak Bapan Namalyari, magnabu ka di. Ta idi sa kasulatan, ‘Iutus Bapan Namalyari ya mani ang-el na buy sal-un laka amên asê midumpul sa batuy bitis mu.’ ” ");
INSERT INTO blx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nakitbay si Jesus, “Idi sa kasulatan, ‘Agana mu subukun ya Panginuun mun Namalyari.’ ” ");
INSERT INTO blx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pamakayari, pikilaku yan Satanas sa sadyay katag-ayan bung-uy buy impakit kanay kaganawan kaarian sa babun luta buy pibandiyan mani ati. ");
INSERT INTO blx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Buy sinabin Satanas kan Jesus, “Ya kaganawan abiin, idin ku kamu, nu dukwan muku buy ulimênên.” ");
INSERT INTO blx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nakitbay si Jesus, “Magtas kay, Satanas! Gawan idi sa kasulatan, ‘Kay Panginuun mun Namalyari ya ulimênên mu buy pagsuywan mu.’ ” ");
INSERT INTO blx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pamakayarin abiin, inlakwanan yan Satanas. Buy inlumatêng nga ang-el Bapan Namalyari buy naglingkud kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sên nabalitan Jesus ya nakasukul si Juan, nag-udung ya sa prubinsyan Galilea. ");
INSERT INTO blx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nuwa a yina nanugêl sa balayan Nazaret nun a sa balayan Capernaum, sa agid dagat Galilea sa katganan Zebulun buy Neftali. ");
INSERT INTO blx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sa pakapakun baydu, natupad day sinabin Propeta Isaias, ");
INSERT INTO blx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ya lugal Zebulun buy ya lugal Neftali sabay ya dadanan papakun sa lawa ya idi sa lipay ilug Jordan. Ya mani lugal abiin, sakup Galilea ya panugêlan mani alwan Judio.” ");
INSERT INTO blx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mambumyay sa nadiglêm ya mani tawu baydu, nuwa makakit silan ayin kaparisuy sawang. Agyan idi sila sa nadiglêm papakun sa kamatyan, masawangan na isip la. ");
INSERT INTO blx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Paubat sabitun inlumatêng si Jesus sa Capernaum, nangaral ya. Sinabi na, “Pagsisyan buy itgên yuy panyag kasalanan, tagawan marani yanay pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kaban mamita si Jesus sa agid lawan Galilea, nakitan nay mipatêl ya silan Simon ya pambêgên Pedro buy si Andres. Mamisamwag silan dala ta ubra lay mandakêp kênan lanêm. ");
INSERT INTO blx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sinabin Jesus kalla, “Kilaku kaw kangku ta daygên kataw mamipakaranin tawu kan Bapan Namalyari amên manampalataya sila kaparisun pandakêp yun kênan lanêm.” ");
INSERT INTO blx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tambêng lan imbalag ga dala la buy nakilaku sila kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kaban pan-isundun Jesus ya pamita na, nakitan nay mipatêl ya si Santiago buy si Juan ya idi sa bangka ya mamipakapalan dala la. Kaawyun la si Zebedeo ya bapa la. Binêg sila êt Jesus amên makilaku kana. ");
INSERT INTO blx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kabay tambêng lan inlakwanan ya bangka la buy bapa la ta nakilaku sila kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Inlakun Jesus ya buun prubinsyan Galilea buy sinumun ya sa mani balin pagtipunan mani Judio amên manuru. In-aral nay Mangêd da Balita tungkul sa pag-arin Bapan Namalyari. Pinaiyul na êt ta kaganawan magmikakalasi ya sakit buy dilag mangatanam. ");
INSERT INTO blx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Niwagaw wa balita tungkul kan Jesus sa buun prubinsyan Siria. Kabay gintan kanay kaganawan nagsakit buy mani magkasakit sa matanam la buy mani sinêdakan nadawak ka ispiritu buy mani tinugaw buy mani a kabita. Pinaiyul nay kaganawan abitu. ");
INSERT INTO blx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kabay inlaku yan sadyay lakên tawuy ubat sa prubinsyan Galilea, sa mani balayan sa Decapolis, sa balayan Jerusalem, sa prubinsyan Judea buy sa lipay Ilug Jordan. ");
INSERT INTO blx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sên nakitan Jesus ya malakêy tawu, sinumukpa ya sa gisay bung-uy buy niknu baydu. Nagdani kanay mani tagasunul na ");
INSERT INTO blx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","buy nag-umpisa yan nangaral. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Pinagpalay mani tawuy nayêpay nakêm, tagawan mibilang sila sa pag-arian na. ");
INSERT INTO blx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pinagpalay mani tawuy sadyay lungkut, tagawan samungun silan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pinagpalay mani tawuy nayêpay nakêm, tagawan mapagmana lay babun luta. ");
INSERT INTO blx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pinagpalay mani tawuy nasabêk sa panyag katinêkan kaparisun gisay tawuy layangên buy napêl-ang, tagawan pakabsuyun silan Bapan Namalyari sa katinêkan. ");
INSERT INTO blx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pinagpalay mani tawuy mapallunus, tagawan kalunusan sila êt Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pinagpalay mani tawuy malinis ya bêkê, tagawan makitan lay Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pinagpalay mani tawuy manawup mamikasundu, tagawan bêgên silan mani anak Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pinagpalay mani tawuy pampasakitin gawan sa panunul la sa kalabayan Bapan Namalyari, tagawan miawyun sila sa pag-arian na. ");
INSERT INTO blx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Pinagpala kaw nu pandustakên lakaw, pampasakitin buy pagsabyanan lakaw magmikakalasi ya nadawak ka panangkan gawan sa panunul yu kangku. ");
INSERT INTO blx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ta para êt baysên na mangadanasan mani propeta awlagi. Kabay nu mangadanasan yuy abiin, magsaya kaw buy matula, tagawan maulagay gantimpala yu sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sikaw wa mani tagasunul ku, maiparisu kaw sa asin sa kaganawan tawu sa babun luta. Nuwa nu mitas ya lasan asin, asina miudung buy ayin nan nabang. Kabay isamwag la tay ati sa dan buy piturakturakan mani tawu.” ");
INSERT INTO blx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Sikaw wa dêkêt sa mani tawu sa babun luta kaparisun gisay balayan sa babun gisay bung-uy ya asê maitagu.” ");
INSERT INTO blx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Ayin tawuy mamagkêt sulu ya itagu na sa aypan pamisêmpanan, nun a idin nay sulu sa pêtêg pamyanan amên masawangan na kaganawan idi sa bali. ");
INSERT INTO blx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Para êt bayduy sêpat yun daygên. Pasawangên yuy dêkêt yu sa mani tawu amên makitan lay mangêd da pandaygên yu buy ulimênên lay Bapa yuy idi sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Agana yu isipin na naku waku baydi amên daygên ayin pukat ta Kautusan na impasulat kan Moises buy insulat mani propeta. Naku waku baydi amên tuparên kuy mani ati. ");
INSERT INTO blx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pansabin ku kamuyuy kaban dilag langit buy luta, agyan kay gisay gulis sa Kautusan, asê madyag ayin pukat anggan asê pun natupad da kaganawan. ");
INSERT INTO blx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kabay nu sisabêt man na nallabag sa nangabêlêng nga baagin Kautusan buy mamituru sa kaatag amên mallabag êt, pan-ituwad yan pinakanayêpa sa kaganawan mani kaawyun sa pag-arian Bapan Namalyari. Nuwa nu sisabêt man na manunul sa Kautusan buy mamituru êt sa kaatag amên manunul êt, pan-ituwad yan matag-ay sa mani kaawyun sa pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pansabin ku kamuyuy nu a yu igitan na panyag katinêkan mani manurun Kautusan buy mani Pariseo, a kaw miawyun sa pag-arian Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sinabi pun êt Jesus, “Nalêngê yuy sinabi sa mani pipuunpuunan tamu, ‘Agana ka mamatin tawu, tagawan nu sisabêt man na mamatin tawu, atulun ya.’ ");
INSERT INTO blx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nuwa amêsên, pansabin ku kamuyu ya nu sisabêt man na dilag tubag sa patêl na, atulun yan Bapan Namalyari. Buy nu sisabêt man na mandustak sa patêl na buy magsabin ‘Ayin kan pukat!’, iarap ya sa mani mangatwan Judioy mangatuynungan. Buy nu sisabêt man na magsabi sa patêl na, ‘Ayin kan tanda!’, milaku ya sa impernu. ");
INSERT INTO blx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kabay nu mam-i ka sa pamiandugan kan Bapan Namalyari buy maganaka mun dilag suluk kamuy patêl mu, ");
INSERT INTO blx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lakwanan mu pun na andug mu sa arap pamiandugan, ta makikasundu ka pun kana. Pamakayari, mag-udung ka buy mag-andug kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nu dilag mamidalum kamu, tambêng kan makikasundu kana kaban a naka pun naidalum. Gawan nu asê, dat iarap naka sa mallitis buy pamakayari, igawang kan mallitis sa pulis amên isukul. ");
INSERT INTO blx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pansabin ku kamuy a ka makaawas sa sukulan anggan a mu pun nabayaran na kaganawan pan-ipabayad la kamu.” ");
INSERT INTO blx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nalêngê yuy sinabi sabitun nuna, ‘Agana ka makikanayun.’ ");
INSERT INTO blx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nuwa amêsên, pansabin ku kamuyuy kay êlêwên mu pun na gisay babayi ya dilag gan nadawak ka pangisip, nangasalanan kaynan pamikikanayun. ");
INSERT INTO blx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kabay nu wanan mata muy magin sangkan pangasalanan mu, lus-ukun mu buy isamwag! Mas mangêd pun na matasan kan gisay mata kaysa buuy lawini mu, nuwa isamwag ka sa impernu. ");
INSERT INTO blx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Buy nu wanan gamêt muy magin sangkan pangasalanan mu, putusun mu buy isamwag. Mangêd pun na matasan kan gisay gamêt kaysa buuy lawini mu nuwa isamwag ka sa impernu.” ");
INSERT INTO blx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Idi êt sa kasulatan, ‘Nu labay gisay liyakin isyay ya asawa na, sêpat biyan nayan kasulatan pamisyay.’ ");
INSERT INTO blx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nuwa amêsên, pansabin ku kamuyuy nu sisabêt man na liyaki ya misyay asawa na, liban ta nu nakikanayun na babayi, siyay nay namitustus sa babayi amên makikanayun nu mag-asawa yan kaatag. Buy nu sisabêt man na nakapag-asawa sa babayi ya in-isyay liyaki, nangasalanan yan pamikikanayun.” ");
INSERT INTO blx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nalêngê yu êt ta sinabi sabitun nuna sa mani pipuunpuunan tamu, ‘Agana kaw manumpan ayin kapêtêgan, nun a tuparên yuy pangaku yu sa lagyun Panginuun.’ ");
INSERT INTO blx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nuwa amêsên, pansabin ku kamuyuy nu mangaku kaw, agana kaw manumpa. Agana yu sabin sa pangaku yuy ‘Makit takun langit’, tagawan idi bayduy trunun Bapan Namalyari, ");
INSERT INTO blx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o kayay ‘Makit takun luta’, tagawan ati ya tutudakan bitis na. Buy agana kaw êt magsabin, ‘Makit takun balayan Jerusalem,’ tagawan ati ya balayan Dakilan Ari. ");
INSERT INTO blx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Buy agana kaw êt magsabin ‘Agyan mati yaku’, tagawan agyan kay gisay sabut yu, a yu agyun paputin o pauyangên. ");
INSERT INTO blx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sabin yu tanay ‘Awu’ nu awu buy ‘Asê’ nu asê, tagawan nu manumpa kaw pun, ubat ta abiin kan Satanas.” ");
INSERT INTO blx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nalêngê yuy sinabi sabitun nuna, ‘Nu binulag kan kaparisu mu, bulagên muya êt. Nu mêgmên kaparisu muy bêbêy mu, mêgmên muya êt.’ ");
INSERT INTO blx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nuwa amêsên, pansabin ku kamuyuy nu dilag manyag nadawak kamuyu, agana kaw mangablas. Nu dilag mandalpin pingi mu, ipadalpi mu êt ta kapaka. ");
INSERT INTO blx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nu sisabêt man na mamidalum kamu amên kêwên na yaming mu, idin mu êt ta up-up mu. ");
INSERT INTO blx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nu ipilit ipabakay sundalus kamuy gêgtan na un gisay kilumetru, bakayên muy abiin un luway kilumetru. ");
INSERT INTO blx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nu dilag manyawad kamu, biyan muya. Buy nu dilag mangandam kamu, paandamên muya.” ");
INSERT INTO blx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nalêngê yuy sinabi sabitun nuna, ‘Kaidwan muy kaluguran mu buy kasulukan muy kapati mu.’ ");
INSERT INTO blx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nuwa amêsên, pansabin ku kamuyuy ‘Kaidwan yuy mani kapati yu buy manalangin kaw para sa mani mamasakit kamuyu.’ ");
INSERT INTO blx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nu daygên yuy abiin, mapagpapêtgan na anak kaw Bapan Namalyari ya idi sa langit. Tagawan alwan kay sa mangangêd da tawu miputak ka mamut, nun a agyan êt sa mani nangadawak. Buy alwan kay mani tawuy matinêk ka pambiyan nan uran, nun a agyan na mani alwan matinêk. ");
INSERT INTO blx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nu kay ya mani mangidu kamuyuy pan-idun yu, ayin kaw matanggap pa gantimpalay ubat kan Bapan Namalyari. Ta abiin êt ta pandaygên mani maningil buwis ya makasalanan. ");
INSERT INTO blx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Buy nu kay mani patêl yuy pangkumustên yu, ayin kaw pamikaatag sa kaatag mani tawu. Ta abiin êt ta pandaygên mani tawuy asê mangilala kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kabay kaylangan magin ganap kaw kaparisun Bapa yu ya idi sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mangillag kaw ta dat ya panyag yun mangêd, kay amên ulimênên kaw mani tawu. Tagawan nu kay parabaysên na pandaygên yu, ayin kaw matanggap pa gantimpalay ubat sa Bapa yuy idi sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kabay nu mam-i kaw sawup sa mani magkasakit, agana yina ibalitay ati kaparisun mani tawuy mapagtalingkayu. Ta nu idin la, pan-ibalita la sa balin pagtipunan buy sa mani dan amên ulimênên silan mani tawu. Pansabin ku kamuyuy natanggap lay nay mani pangulimên mani tawu ya sabay ya gantimpala la. ");
INSERT INTO blx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nuwa nu mam-i kaw sawup sa mani magkasakit, agana yu ipatanda agyan kansabêt man ");
INSERT INTO blx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","amên liim ya panawup yu. Sa pakapakun baydu, ya Bapa yun Namalyari ya makakit sa pandaygên tamun liim, sabay ya mam-in gantimpala kamuyu.” ");
INSERT INTO blx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nu manalangin kaw, agana kaw mambus sa mani mapagtalingkayu. Labaylabay lan manalangin nakaidêng sa balin pagtipunan buy sa mani pisubangan na dan amên ta makitan silan mani tawu. Pansabin ku kamuyuy natanggap lay nay mani pangulimên mani tawu ya sabay ya gantimpala la. ");
INSERT INTO blx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nuwa nu manalangin kaw, sumun kaw sa lalên silid buy isara yuy pasbul. Baydu kaw manalangin sa Bapa yuy asê maakit. Ta ya Bapa yuy makakit sa pandaygên yun liim, sabay siyay mam-in gantimpala kamuyu. ");
INSERT INTO blx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kabay nu manalangin kaw, agana yu piudung-udung nga ayin kapukatan na sabi kaparisun pandaygên mani tawuy manalangin sa diyusdiyusan la. Indap la nu lêng-ên silan diyusdiyusan la gawan sa kakarangan panalangin la. ");
INSERT INTO blx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gana yu sila tubsun, tagawan bayu kaw pun manyawad, tanday nan Bapa nu sabêt ta kaylangan yu. ");
INSERT INTO blx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nu manalangin kaw, paradi ya sabin yu, ‘Bapa yan na idi sa langit, labay yan na kay sikay ulimênên mani tawu. ");
INSERT INTO blx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Labay yan na mag-ari kayna kanyan kaganawan buy sunulun mani tawuy kalabayan mu baydi sa babun luta, kaparisu sa langit. ");
INSERT INTO blx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Biyan mukay kanên sa inallu-allu. ");
INSERT INTO blx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawarên mukay sa mani kasalanan yan, kaparisun pamatawad yan sa mani nangasalanan kanyan. ");
INSERT INTO blx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Buy agana mukay paulayan matuksu, nun a iligtas mukay kan Satanas.’ ");
INSERT INTO blx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nu pampatawarên yuy mani tawuy nangasalanan kamuyu, patawarên kaw êt Bapa yun Namalyari ya idi sa langit. ");
INSERT INTO blx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nuwa nu a yu sila patawarên, a kaw êt patawarên Bapa yuy idi sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nu mag-ayunu kaw, agana kaw mambus sa mani tawuy mapagtalingkayu. Ta kay tatalagên lan maglupan malungkut amên ta ipakit la sa mani tawuy mag-ayunu sila. Pansabin ku kamuyuy natanggap lay nay mani pangulimên mani tawu ya sabay ya gantimpala la. ");
INSERT INTO blx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nuwa sikaw, nu mag-ayunu kaw, magpulamus kaw buy ipakapala yuy sarili yu. ");
INSERT INTO blx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Daygên yuy abiin amên asê matandan mani tawuy mag-ayunu kaw. Ta ya Bapa yun Namalyari ya idi sa langit ya asê makitan, sabay siyay makakit sa pandaygên yun liim buy mam-i yan gantimpala kamuyu.” ");
INSERT INTO blx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Agana kaw manipun pibandiyan para sa sarili yu baydi sa babun luta. Ta baydi, dilag mani insektuy maniran pibandiyan yu o mangalawang buy dilag mani manakaw wa mangwan ati. ");
INSERT INTO blx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nun a manipun kaw pibandiyan yu sa langit. Ta baydu, asê anagên, asê kalawangên buy ayin makasun na manakaw. ");
INSERT INTO blx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tagawan nu idi saantuy pibandiyan yu, idi êt bayduy isip yu.” ");
INSERT INTO blx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ya mata, sabay ya sawang lawini. Kabay nu malinaw wa pangêlêw mu, nasawang êt ta buun lawini mu. ");
INSERT INTO blx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nuwa nu asê malinaw wa pangêlêw mu, nadiglêm êt ta buun lawini mu. Kabay nu ya sawang nga idi kamu, nadiglêm awêd, nadidiglêm ma biyay mu!” ");
INSERT INTO blx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ayin tawuy piagnanên nan magsuyu sa luway amung na. Ta nu parabaydu, kasulapwan buy pustakên nay gisa, nuwa ya gisa, idun nan tapat. Para êt baydu, a yu malyarin piagnanên pagsuywan si Bapan Namalyari buy pibandiyan.” ");
INSERT INTO blx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kabay pansabin ku kamuyuy agana kaw napitik tungkul sa ikabyay yu buy nu sabêt ta kanên yu, inêmên yu o iyaming yu. Tagawan igit maulagay biyay kaysa kanên buy igit maulagay lawini kaysa yaming. ");
INSERT INTO blx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pakaêlêwên yuy mani uybun manuk ka mallumpad. A sila mananêm, mamupul o manipun maêkan la sa budega. Nuwa paraman baydu, pampakan silan Bapa yun Namalyari ya idi sa langit. Sikaw pun nayi, igit kaw maulaga kana kaysa sa mani uybun manuk. ");
INSERT INTO blx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ayin kamuyun makapikadang biyay na agyan sa gisay uras sa kapamilatan kapitikan na. ");
INSERT INTO blx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Agana kaw napitik tungkul sa pagyaming yu. Elêwên yu nu parasaantun mantumubuy mani tanaman na mamulak ya bêngat tan tinumubu. A sila mag-ubra o manyag yaming la. ");
INSERT INTO blx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nuwa pansabin ku kamuyuy agyan si Solomon na mabandi, a ya nakapagyaming kasin kangêd gisa man na bulaklak tanaman. ");
INSERT INTO blx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pampakangêdên Bapan Namalyari ya mani lamun sa bung-uy ya nabyay amêsên, nuwa pamakawasak, maulam. Nu parabaysên na pandaygên Bapan Namalyari sa mani lamun, luyang ngabay kamuyu, pilmin payamingan nakaw. Pêtêg kawnan nabêlêng nga panampalataya kana ta! ");
INSERT INTO blx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kabay agana kaw napitik tungkul sa kanên, inêmên o yaming yu. ");
INSERT INTO blx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ta ya mani asê mangilala kan Bapan Namalyari, pawa silan napitik tungkul sa mani bagay ya abiin. Nuwa sikaw, tanday nan Bapa yun Namalyari ya idi sa langit ya kaylangan yuy kaganawan abiin. ");
INSERT INTO blx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nuwa igit sa kaganawan, pagpilitan yun magpasakup sa pag-arin Bapan Namalyari buy pagpilitan yun manunul sa kalabayan na. Sa pakapakun baydu, idin na kamuyuy kaganawan kaylangan yu. ");
INSERT INTO blx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kabay agana kaw napitik sa kaylangan yu sa wasak. Wasak yu tan isipin na abiin. Nukad day pangisip yu sa allun ati.” ");
INSERT INTO blx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Agana kaw mangusgan kaparisu yu amên a kaw êt usgên Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tagawan nu parasaantu yun inusgay kaparisu yu, para kaw êt baydun usgên Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Uysiyan makitan mu yay puling sa matan kaparisu mu, pakan a mu makitan na maragul la puling sa mata mu ta? ");
INSERT INTO blx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Parasaantu mun masabi kanay, ‘Kaksaw ka ta itas kuy puling mu,’ pakan dilag kan maragul la puling? ");
INSERT INTO blx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mapagtalingkayu! Itas mu pun na maragul la puling sa mata mu amên makakit kan mangêd. Sa pakapakun baydu, maitas muy puling sa matan kaparisu mu.” ");
INSERT INTO blx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Agana yu idin sa mani asuy banal la bagay, ta dat sikaw pun na balikwasan na buy kayatên. Buy agana yu êt idin sa mani babuy ya perlas ta kay piturakturakan lay ati. Para êt baydu, agana yu ipilit iaral la Sabin Bapan Namalyari sa mani tawuy asê kalabay mallêngê sa sabi na.” ");
INSERT INTO blx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Manyawad kaw kan Bapan Namalyari buy biyan nakaw. Têkapên yu kanay pantêkapên yu buy makitan yu. Mamêg kaw kana buy pakitbayan nakaw. ");
INSERT INTO blx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tagawan na kaganawan manyawad kana, pambiyan na sila. Buy ya kaganawan mangkap, makakit. Buy ya kaganawan mamêg, pakitbayan. ");
INSERT INTO blx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sikaw wa mangatwa, nu manyawad tinapay kamuyuy anak yu, biyan yu sila nayin batu? Asê! ");
INSERT INTO blx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Buy nu manyawad kamuyun kênan lanêm ma anak yu, biyan yu sila nayin utan? Asê! ");
INSERT INTO blx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sikaw wa mani nangadawak, nu katanda kaw mam-in mangangêd da bagay sa mani anak yu, luyang ngabay ya Bapa yun Namalyari ya idi sa langit! Idin nay mangangêd da bagay sa kaganawan manyawad kana.” ");
INSERT INTO blx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kabay daygên yu sa mani kaparisu yuy labay yun daygên la kamuyu. Ta abiin na ustuy panunul sa Kautusan na impasulat kan Moises buy insulat mani propeta.” ");
INSERT INTO blx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Sumun kaw sa nalipit ta pasbul, tagawan nakwal la pasbul buy malapad da dan papakun sa ayin katganan na kaparusan buy malakêy mansumun baydu. ");
INSERT INTO blx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nuwa nalipit ta pasbul buy iibun na dan papakun sa biyay ya ayin katganan buy kay pêpêrad da manduman baydu.” ");
INSERT INTO blx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mangillag kaw sa mani magtatalingkayun propeta. Magdani sila kamuyun paran mangêd da tawu kaparisun tupa, pakan sa kapêtêgan, nadawak ka labay la kamuyu kaparisun asun aniwid. ");
INSERT INTO blx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Matandan yu sila sa mani diyag la tagawan na tanaman na madiwi, asê managêy ubas o igus. ");
INSERT INTO blx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ya mangêd da puun kayu, managêy yan pangkanên. Buy ya puun kayuy asê mangêd, managêy yan asê pangkanên. ");
INSERT INTO blx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ya mangêd da puun kayu, asê managêy asê pangkanên. Buy ya puun kayuy asê mangêd, asê managêy pangkanên. ");
INSERT INTO blx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ya kaganawan puun kayuy asê managêy pangkanên, pamputusun buy pan-isamwag sa apuy. ");
INSERT INTO blx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kabay matandan yuy magtatalingkayun propeta sa mani diyag la.” ");
INSERT INTO blx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Malakêy mamêg kangkun ‘Panginuun, Panginuun’ nuwa asê labay sabin na miawyun sila sa pag-arian Bapan Namalyari. Kay mani tawuy manunul sa kalabayan Bapa kuy idi sa langit ya miawyun sa pag-arian na. ");
INSERT INTO blx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sa allun pangukum, malakêy magsabi kangkun paradi, ‘Panginuun, Panginuun alwa nayin sa lagyu mu, impatanda yan na mani sabi mu, namitas kay nangadawak ka ispiritu, buy nanyag kay malakêy mamakaupapas?’ ");
INSERT INTO blx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nuwa sabin ku kallay, ‘A kataw kakilala. Magpakarayu kaw kangku, sikaw wa manyag kadawakan.’ ” ");
INSERT INTO blx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kabay ya mani mallêngê buy manunul sa mani sabi ku, kaparisu yan mautêk ka liyaki ya namipaydêng bali na sa pundasyun na batu. ");
INSERT INTO blx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sên nanguran malakas, nallanab buy sadyay lakas angin, asê nalasak ka bali na, tagawan napas-êy ya pinipundasyunan na. ");
INSERT INTO blx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ya mani tawuy mallêngê sa pansabin ku, pakan a la pansunulun, kaparisu silan tawuy ayin tanda ya namipaydêng bali sa kabalasan. ");
INSERT INTO blx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sên nanguran malakas, nallanab buy sadyay lakas angin, nayêgmak buy nalasak ka bali.” ");
INSERT INTO blx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","“Pamakayarin nangaral Jesus, nakaupapas ya mani tawu sa pangaral na, ");
INSERT INTO blx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tagawan nakit lay dilag yan kapangyarian sa pangaral na, asê kaparisun pangaral mani manurun Kautusan.” ");
INSERT INTO blx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sên pamakalunsan Jesus ubat sa bung-uy, pikilakwan yan malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Amêsên, nagdani kanay gisay nagsakit ketung buy nanduku ya sa arapan na. Sinabi na, “Panginuun, nu kalabayan mun kayêk, paiyulun muku.” ");
INSERT INTO blx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dinukpan yan Jesus buy sinabi na, “Labay ku. Umiyul kayna.” Kabay tambêng inumiyul la nagsakit buy mangêd day lawini na. ");
INSERT INTO blx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sinabin Jesus kanay, “Agana mu sabin kansabêt man na nalyari kamu, nun a maku ka sa pari buy ipaêlêw muy lawini mu ya inumiyul lana. Pamakayari, mag-andug ka ayun sa insulat Moises bilang pagpapêtêg ga inumiyul kayna.” ");
INSERT INTO blx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sên inlumatêng si Jesus sa balayan Capernaum, naku kanay gisay kapitan mani sundalus Romano buy nakisabi, ");
INSERT INTO blx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Panginuun, idi sa bali kuy ipus kuy nakakalêk ka asina miidêng buy sadyay sakit matanam na.” ");
INSERT INTO blx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sinabin Jesus, “Awu, maku waku, ta paiyulun kuya.” ");
INSERT INTO blx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nuwa nakitbay kanay kapitan mani sundalus, “Panginuun, a ku sêpat lakwên mu sa bali ku. Kay sabin muy umiyul la ipus ku, umiyul yabay. ");
INSERT INTO blx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tanda kuy ati, gawan siku man, dilag mani nipagtungkulan na makapangyarian pun êt kangku. Buy dilag gaku êt pansakupun na mani sundalus. Nu sabin ku sa gisay, ‘Maku ka baydu’, maku yabay baydu. Nu sabin kuy, ‘Kaksaw ka baydi’, magdani ya. Buy nu sabêt ta iutus ku sa ipus ku, daygên na.” ");
INSERT INTO blx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sên nalêngên Jesus ya sinabin kapitan sundalus, nakaupapas ya buy sinabi na sa mani tawuy kilalaku kanay, “Pansabin ku kamuyuy ayin naku pun nakitan na gisay Israelitay dilag paradi ya karagul la panampalataya. ");
INSERT INTO blx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pansabin ku kamuyuy malakêy alwan Judioy ubat sa magmikakanayun na lugal baydi sa babun luta ya mapagkaêm lan Abraham, Isaac buy Jacob sa kalutun Bapan Namalyari sa kaarian na sa langit. ");
INSERT INTO blx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Malakê dayi ya mani Judioy pag-arian Bapan Namalyari, nuwa isamwag sila sa kadlêman. Manangis sila baydun mingêngêt ta bêbêy.” ");
INSERT INTO blx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sinabin Jesus sa kapitan mani sundalus, “Muli kayna. Gawan sa panampalataya mu, umiyul la ipus mu.” Sa uras êt abitu, inumiyul la ipus kapitan. ");
INSERT INTO blx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Naku si Jesus sa balin Pedro. Pamakalatêng na baydu, nakitan nay ampun Pedroy babayi ya nakakalêk gawan umutun. ");
INSERT INTO blx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dinukpan Jesus ya gamêt babayi buy tambêng yan inumiyul. Pamakayari, nidêng ya buy pinakan na si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sên mamayabiyabi yana, gintan mani tawu kan Jesus ya malakêy sinêdakan nangadawak ka ispiritu. Kay sa gisay sabi na, naipatas nay nangadawak ka ispiritu buy pinaiyul nay mani nipagsakit. ");
INSERT INTO blx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dinyag nay abiin amên matupad da sinabin Propeta Isaias, “Pinaiyul na kitamu sa sakit buy intas nay mani matanam tamu.” ");
INSERT INTO blx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sên nakitan Jesus ya malakêy tawuy nakapalitêng kana, sinabi na sa mani tagasunul nay “Maglipay kitamina sa lawa.” ");
INSERT INTO blx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dilag gisay manurun Kautusan na nagdani kan Jesus. Sinabi na, “Manuru, kilaku waku kamu agyan saantu man na lakwên mu.” ");
INSERT INTO blx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nuwa nakitbay si Jesus, “Dilag lubut ta tutugêlan na mani asun aniwid. Dilag êt salay ya mani uybun manuk. Nuwa sikuy ubat sa langit ta in-Anak Tawu, ayin naku tan sarilin tutugêlan na mapagpaynawan.” ");
INSERT INTO blx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Gisa pun sa mani tagasunul nay nagsabi, “Panginuun, muli yaku pun dayi ta ipalbêng kuy bapa ku.” ");
INSERT INTO blx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nuwa sinabin Jesus kana, “Manunul ka kangku buy ipalbêng minay nati mu sa mani nati sa pangêlêw Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nagsakay si Jesus sa gisay bangka kaawyun na mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kaban idi sa bunak lanêm ma bangka la, inlumakas ya angin buy nayi-nayi silaynan matugpawan mangaragul la alun. Nuwa sa uras abitu, mamabêlêw si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kabay pinêw yan mani tagasunul na, “Panginuun, iligtas mukay ta milêmlêm kitamina!” ");
INSERT INTO blx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nakitbay si Jesus kalla, “Alwa ta malimu kaw yata? Nanabêlêng yay panampalataya yuta.” Kabay nidêng ya buy in-utus nay malakas ya angin buy alun, “Tunggên kaw.” Tinunggên yabay. ");
INSERT INTO blx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nakaupapas ya mani tagasunul na buy sinabi la, “Sisabêt ta atiyê? Siyan mapatgên na yay angin buy alun ta!” ");
INSERT INTO blx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sên inlumatêng si Jesus sa lipay lawa, sa lutan mani Gadareno, timbêng yan luway liyaki ya ubat sa lêyang nga pamilbêngan. Ya lawyakin ati, sinêdakan silan nangadadawak ka ispiritu. Mangatubag sila. Kabay ayin sisabêt man na makadan baydu. ");
INSERT INTO blx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sinabi la kan Jesus, “Sikay Anak Bapan Namalyari, sabêt ta daygên mu kanyan? Naku ka nayi baydi amên pasakitan mukay, agyan alwa pun panawun?” ");
INSERT INTO blx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sa narayun pêrad, dilag malakêy babuy ya manabêl. ");
INSERT INTO blx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nakisabi kanay mani nangadawak ka ispiritu, “Nu ipatas mukay, tulutan mukay magsêdak sa mani babuy.” ");
INSERT INTO blx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sinabin Jesus, “Mita kaw!” Kabay nagtas sila sa luway liyaki buy nagsêdak sa mani babuy. Nipamwayuy mani babuy buy nanabu sa bêngaw. Kabay nangalulumud sila sa lawa. ");
INSERT INTO blx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nuwayuy mani manaysay babuy papakun sa balayan buy imbalita la nu sabêt ta nalyari sa mani babuy buy sa luway liyaki ya sinêdakan nangadadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kabay inumawas ya kaganawan tawu sa balayan amên lakwên la si Jesus buy pakisabyan layan “Magtas kayna baydi sa lugal yan.” ");
INSERT INTO blx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kabay nagsakay silan Jesus sa bangka buy naku sila sa lipay lawa. Pamakalatêng la baydu, nuli ya sa Capernaum sa sarili nan balayan. ");
INSERT INTO blx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amêsên, gintan kanan dakun umnuy tawu ya gisay liyaki ya lumpu ya idi sa kalapayan na. Sên nakitan Jesus ya maragul la panampalataya la kana, sinabi na sa liyaki ya lumpu, “Anak kuway, pas-êyên muy nakêm mu, ta pinatawad day mani kasalanan mu.” ");
INSERT INTO blx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dilag êt baydun mani manurun Kautusan ya mangisip paradi, “Pallamusun yan tawun ati si Bapan Namalyari ta!” ");
INSERT INTO blx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nuwa tandan Jesus ya pan-isipin la. Kabay sinabi na, “Awta mangisip kaw yan nadawak ta? ");
INSERT INTO blx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mas nalêp-aw sabin sa liyaki ya lumpuy, ‘Pinatawad danay mani kasalanan mu,’ gawan a yu makit nu pinatawad o asê. Nuwa sabin ku kanay, ‘Midêng ka buy mita ka’ ");
INSERT INTO blx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","amên makitan yuy sikuy ubat sa langit ta in-Anak Tawu, dilag gakun kapangyarian baydi sa babun lutan mamatawad mani kasalanan.” Buy sinabi na sa liyaki ya lumpu, “Midêng ka, gêtan muy kalapayan mu buy muli kayna!” ");
INSERT INTO blx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kabay nidêng yabay ya liyaki buy nuli. ");
INSERT INTO blx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sên nakit mani tawuy nalyari, nakaupapas buy nangulimên sila kan Bapan Namalyari ya nam-in parabayduy kapangyarian sa gisay tawu. ");
INSERT INTO blx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pamakabitan Jesus baydu, nakitan nay gisay liyaki ya naglagyun Mateo ya nakaiknu sa pamayaran buwis. Sinabin Jesus kana, “Kilaku ka kangku.” Kabay nidêng si Mateo buy nakilaku kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kaban mangan si Jesus buy mani tagasunul na sa balin Mateo, nipallumatêng nga malakêy maningil buwis buy kaatag pun na pan-ituwad makasalanan ya napagkaawyun lan mangan. ");
INSERT INTO blx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sên nakitan mani Pariseoy abiin, pinatang lay mani tagasunul Jesus, “Uysiyan makiawyun yay manuru yun mangan sa mani maningil buwis buy sa kaatag pun mani makasalanan ta?” ");
INSERT INTO blx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sên nalêngên Jesus ya abitu, sinabi na, “Asê mangaylangan manuluy tawuy ayin sakit, nun a abituy tawuy nagsakit. ");
INSERT INTO blx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mita kaw buy pakaisipin yu nu sabêt ta labay sabin ati ya idi sa kasulatan, ‘Alwan andug yu kangkuy labay ku, nun a magin mapallunus kaw.’ Tagawan naku waku baydi amên bêgên na mani tawuy makasalanan, alwan abitu silay mani tawuy magsabin ayin silan kasalanan.” ");
INSERT INTO blx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dilag dakun umnuy tagasunul Juan ya Mamawtismu ya naku kan Jesus buy namatang, “Uysiyan sikay buy mani Pariseoy pawa kay mag-ayunu, pakan mani tagasunul muy a yata?” ");
INSERT INTO blx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kabay in-alimbawan Jesus ya sarili na sa liyaki ya pan-itangên, “Malyari nayin mag-ayunuy mani bisita sa tangênan pakan kaawyun la pun na liyaki ya pan-itangên? Asê! Nuwa lumatêng nga alluy kêwên kallay liyaki ya pan-itangên. Sa panawun abiin, baydu sila pun mag-ayunu.” ");
INSERT INTO blx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sinabin Jesus kallay mani paalimbawa, “Ayin mamilanib bayuy yaming sa manan yaming. Tagawan nu mikuyum ma bayuy yaming, mapaktang nga manan yaming buy luyang dumagul la ginit. ");
INSERT INTO blx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ayin êt mamitiis bayuy alak sa manan pamyanan na diyag sa balat, tagawan matlês ya pamyanan buy mibulug ga alak. Parisu silan masayang! Ya bayuy alak, sêpat itiis sa bayuy pamyanan. Sa pakapakun baydu, parisu silan mabuyutan.” ");
INSERT INTO blx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kaban pansabin nay ati, inlumatêng nga gisay mamunu sa balin pagtipunan mani Judio. Nanduku ya buy nakisabi kan Jesus, “Kapimati pun anak kuy babayi. Nu malyari dayin kayêk, lakwên muya pun buy ipaluntu muy gamêt mu kana amên bumyay ya.” ");
INSERT INTO blx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kabay nakilaku kana si Jesus buy mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kaban mamita sila, dilag gisay babayi ya nagdani sa bukut Jesus. Ya babayin ati, mapu buy luway tawun nan dayên. Sinabin babayi sa nakêm na, “Madukpan kuta dayi ya yaming na, umiyul lakina.” Kabay dinukpan nay palpal yaming Jesus. ");
INSERT INTO blx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nangawing si Jesus buy nakitan nay babayi. Sinabi na, “Anak kuway, pas-êyên muy nakêm mu. Inumiyul ka gawan sa panampalataya mu.” Kabay tambêng inumiyul la babayi. ");
INSERT INTO blx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sên pamakalatêng Jesus sa balin mamunu sa pagtipunan, nakitan nay manigtig buy malakêy tawuy matarit. ");
INSERT INTO blx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sinabi na, “Mag-awas kaw pun, ta asê nati ya anak! Kay mamabêlêw ya.” Gawan sa sinabi na, inuyam laya. ");
INSERT INTO blx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sên nag-awas ya mani tawu, sinumun si Jesus, ta tinalan nay gamêt anak buy nimata ya. ");
INSERT INTO blx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ya dinyag Jesus, niwagaw sa kaganawan balayan baydu. ");
INSERT INTO blx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pamakabitan Jesus baydu, pikilakwan yan luway bulag ga liyaki ya masnêg magsabin, “Layin Arin David, kalunusan mukay ya kayêk!” ");
INSERT INTO blx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pamakalatêng Jesus sa bali ya bibiyan na, nagdani kanay mani bulag. Pinatang silan Jesus, “Manampalataya kaw nayi ya mapaiyul kataw?” Nakitbay sila, “Awuy Panginuun.” ");
INSERT INTO blx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kabay dinukpan Jesus ya mata la buy sinabi na, “Gawan sa panampalataya yu kangku, makakit kawna.” ");
INSERT INTO blx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kabay nakakit yabay ya luway bulag. Masipit intipan Jesus kallay, “Agana yu sabin na nalyari kamuyu agyan kansabêt man.” ");
INSERT INTO blx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nuwa sên nakabitay nay luwa, inwagaw-wagaw lay dinyag Jesus sa buun lugal abitu. ");
INSERT INTO blx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kaban pabitay na silan Jesus, dilag gintan kanay gisay liyaki ya pinapipin nadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Impatas Jesus ya nadawak ka ispiritu. Kabay nakapagsabi ya. Nakaupapas ya mani tawu buy sinabi la, “Agyan kanuman, ayin pun nalyari ya paradi sa buun Israel.” ");
INSERT INTO blx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nuwa sinabin mani Pariseo, “Si Satanas ya puun nangadadawak ka ispiritu, sabay ya nam-in kapangyarian kanan mamipatas nangadadawak ka ispiritu.” ");
INSERT INTO blx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Inlakun Jesus ya mani balayan buy mani baryu buy sinumun ya sa mani balin pagtipunan mani Judio amên manuru. In-aral nay Mangêd da Balita tungkul sa pag-arin Bapan Namalyari. Pinaiyul na êt ta kaganawan tawuy dilag magmikakanayun na sakit buy dilag mangatanam. ");
INSERT INTO blx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sên nakitan Jesus ya malakêy tawu, nalunus ya kalla gawan nakit nay maguluy isip la buy ayin tan manawup kalla. Para silan tupay ayin magpastul. ");
INSERT INTO blx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kabay sinabi na sa mani tagasunul na, “Elêwên yuy malakêy tawuy nakal-an magpasakup kan Bapan Namalyari ya paran pali ya pupulun, nuwa pêpêrad da mamupul. ");
INSERT INTO blx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kabay manalangin kaw sa Panginuun na magbandin pampupulun ya miutus yapun mamupul.” ");
INSERT INTO blx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Binêg Jesus ya mapu buy luway tagasunul na, ta binyanan na silan kapangyarian mamipatas nangadawak ka ispiritu buy mamaiyul kaganawan sakit buy mangatanam. ");
INSERT INTO blx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ati ya lagyun mapu buy luway tagasunul ya binêg nan apostul. Ya mumuna, si Simon ya pambêgên lan Pedro, si Andres ya patêl na, si Santiago buy Juan ya anak Zebedeo, ");
INSERT INTO blx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe, si Bartolome, si Tomas, si Mateo ya maningil buwis, si Santiago ya anak Alfeo, si Tadeo, ");
INSERT INTO blx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon na Cananeo, buy si Judas Iscariote ya sabay ya nisupakat kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","In-utus Jesus ya mapu buy luway tagasunul na buy tinipanan na silan, “Agana kaw maku sa mani alwan Judio o saantu man na balayan mani Samaritano, ");
INSERT INTO blx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","nun a maku kaw sa mani Israelitay nanuwad mani tupay nalitêp. ");
INSERT INTO blx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Iaral yu kallay marani yay pag-arin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Paiyulun yuy mani nipagsakit buy nagketung. Pabyayên yuy nangamamati buy ipatas ya nangadadawak ka ispiritu. Gawan nananggap kaw abiin na kapangyarian un a yu binayaran, a kaw êt magpabayad sa panawup yu. ");
INSERT INTO blx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sa pamita yu, agana kaw mantan pera, agyan gintu, pilak o tangsu. ");
INSERT INTO blx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Agana kaw êt mantan susut, yaming nga pangalili, sandalyas, o têkên. Tagawan ya mag-ubra, sêpat yan mananggap mani kaylangan na.” ");
INSERT INTO blx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Sinabi pun êt Jesus, “Agyan dakun saantu man na balayan o baryuy lakwên yu, mangkap kaw tawuy nanaspat mananggap kamuyun mangêd sa bali na. Manugêl kaw baydu angga sa pamita yu. ");
INSERT INTO blx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamakasun yu sa balin abitu, sabin yu sa kaganawan idi bayduy, ‘Pagpalên kaw Bapan Namalyari.’ ");
INSERT INTO blx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nu tanggapên lakaw, mapakallay kapatêtbêkan Bapan Namalyari. Nuwa nu asê, mag-udung kamuyuy abituy kapatêtbêkan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nu a lakaw tanggapên o lêng-ên sa gisay bali o balayan, mita kaw baydu. Nuwa bayu kaw mita, ikampag yu pun na abu sa bitis yu bilang pamatanda kalla ya nadawak ka dinyag la. ");
INSERT INTO blx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Pansabin ku kamuyuy sa Allun Pangukum Bapan Namalyari sa mani tawu, mas mabyat ta parusay madanasan la kaysa sa mani taga Sodoma buy taga Gomorra.” ");
INSERT INTO blx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Buy sinabi pun êt Jesus sa mani tagasunul na, “Pansabin ku kamuyuy para kaw tupa ya pan-iutus ku sa mani tawuy paran asun aniwid. Kabay magin mautêk kaw nanuwad utan, nuwa magpakatunud kaw nanuwad pati-pati. ");
INSERT INTO blx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mangillag kaw sa mani tawu, tagawan dakpên lakaw buy iarap sa mani manungkulan. Latikun lakaw sa mani balin pagtipunan. ");
INSERT INTO blx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gawan sa panunul yu kangku, iarap lakaw sa mani gobernador buy sa mani ari. Abiin nay panawun yu amên makapagpapêtêg kalla buy sa mani alwan Judio tungkul kangku. ");
INSERT INTO blx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Buy nu iarap lakaw sa mani mallitis, agana kaw napitik nu sabêt ta sabin yu buy nu parasaantuy ipakitbay yu. Ta si Bapan Namalyari ya mamipaisip kamuyu nu sabêt ta sabin yu sa panawun abiin, ");
INSERT INTO blx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","tagawan alwan sikaw wa magsabi, nun a Ispiritun Bapa yun Namalyari ya magsabi sa kapamilatan yu.” ");
INSERT INTO blx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sa panawun abitu, dilag tawuy migawang patêl na amên ipapati. Dilag êt mangatway migawang anak la amên ipapati buy dilag êt mani anak ka manalangsang buy mipapatin mangatwa la. ");
INSERT INTO blx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gawan sa panunul yu kangku, kasulapwan lakaw kaganawan. Nuwa ya manugêl tapat angga sa katganan, sabay siyay miligtas. ");
INSERT INTO blx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nu pisakitin kaw sa gisay balayan, tumakas kaw sa kaatag balayan. Pansabin ku kamuyuy a yu pun mayarin malakuy kaganawan balayan Israel, sikuy ubat sa langit ta in-Anak Tawu, mag-udung ngakina baydi.” ");
INSERT INTO blx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ayin mag-aral la igit pun sa manuru kana. Buy ayin ipus ya igit pun sa amung na. ");
INSERT INTO blx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nu madanasan gisay mag-aral la kaparisun nadanasan manuru na, kay sêpat kanay abitu. Buy nu madanasan ipus ya kaparisun nadanasan amung na, kay sêpat êt kanay abitu. Ta nu sikuy bilang mamunu yuy pambêgên lan Satanas, luyang ngabay sikaw.” ");
INSERT INTO blx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kabay agana kaw malimu sa mani tawuy mamasakit kamuyu. Tagawan ayin pan-itaguy asê makitan buy ayin pan-iliim ma asê matandan. ");
INSERT INTO blx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ya mani pansabin ku kamuyu sa kadlêman, ipatanda yu êt sa nasawang. Buy ya pan-iayas ku kamuyu, sabay ya masnêg yun sabin sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Agana kaw malimu sa mani tawuy kalabay mamati kamuyu. Ta kay lawini yuy agyu lan patin, nuwa alwan kaladwa yu. Nun a ya kalimwan yu, si Bapan Namalyari, ta sabay siyay dilag kapangyarian mamatin lawini yu buy mamisamwag kaladwa yu sa impernu. ");
INSERT INTO blx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ya luway laynê, kay pan-isaliw sa nayêpay alaga. Nuwa ayin agyan gisa man kallay manabu sa lutan asê kalabayan Bapa yun Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Luyang kaw pun. Ta agyan ya bilang mani sabut yuy tandan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kabay agana kaw malimu, ta luyang kaw maulaga kaysa sa malakêy laynê.” ");
INSERT INTO blx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sinabi pun êt Jesus, “Nu sisabêt man na mangilala kangku sa arapan mani tawu, kilalanên kuya êt sa arapan Bapa kuy idi sa langit. ");
INSERT INTO blx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nuwa nu sisabêt man na mamikadêng-êy kangku sa arapan mani tawu, ikadêng-êy kuya êt sa arapan Bapa kuy idi sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Agana yu isipin ya naku waku baydi sa babun luta amên dilag mangêd da pamiaawyun na mani tawu. Asê! Gawan sa pamaku ku baydi, asê mikakaintindi ya mani tawu. ");
INSERT INTO blx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Buy gawan kangku, pakipatyan anak ka liyaki ya bapa na. Buy pakipatyan anak ka babayi ya indu na. Para êt bayduy daygên manuyang nga babayi sa ampu nay babayi. ");
INSERT INTO blx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ya mapagkapatin gisay tawu sabay ya sarili nan pamilya.” ");
INSERT INTO blx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ya mangidu sa mangatwa nan igit pun kangku, a ya sêpat tagasunul ku. Buy ya mangidu sa anak nan igit pun kangku, a ya sêpat tagasunul ku. ");
INSERT INTO blx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ya asê nakal-an mati gawan sa panunul na kangku kaparisun pamakay kurus, a ya sêpat tagasunul ku. ");
INSERT INTO blx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sisabêt man na tawuy maglabay miligtas ya biyay na, sabay ya matasan biyay na. Nuwa ya tawuy nakal-an mam-in biyay na para kangku, sabay ya mabiyan biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Sisabêt man na mananggap kamuyu, sikinay pantanggapên na. Buy ya mananggap kangku, pantanggapên naynay namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ya mananggap sa gisay propeta gawan sa pangapropeta na, makatanggap yan gantimpala para sa gisay propeta. Buy ya mananggap sa matinêk ka tawu gawan matinêk ya, makatanggap yan gantimpala para sa matinêk ka tawu. ");
INSERT INTO blx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pansabin ku kamuyuy nu sisabêt man na makab-in gisay basun lanêm ma nalêpêt sa gisay mamakapalunus ya tagasunul ku gawan tagasunul kuya, pilmin makatanggap yan gantimpalay ubat kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pamakayarin tinurwanan Jesus ya mapu buy luway tagasunul na, namita ya sa lugal abitu amên manuru buy mangaral êt sa mani narani ya lugal baydu. ");
INSERT INTO blx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nakasukul sa panawun abitu si Juan ya Mamawtismu. Natandan nay mani pandaygên Cristu. Kabay in-utus nay mani tagasunul na ");
INSERT INTO blx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","amên ipatang kanay paradi, “Sikayna nayi ya pan-êtêngên yan na lumatêng o mangêtêng kay pun kaatag?” ");
INSERT INTO blx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nakitbay si Jesus, “Mag-udung kaw kan Juan buy ibalita yu kanay nalêngê buy nakit yu amêsên. ");
INSERT INTO blx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nakakit tanay mani bulag. Nakabitay mani lumpu. Inumiyul la mani nagketung. Nakalêngêy mani asê kalêngê. Pampabyayên na mani nati. Buy pan-iaral lana sa mani kaluluy Mangêd da Balita. ");
INSERT INTO blx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Buy sabin yu êt kanay pinagpalay tawuy asê magluway nakêm kangku!” ");
INSERT INTO blx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kaban mamitay mani tagasunul Juan, pinatang Jesus ya mani tawu, “Sabitun naku kaw sa kakyangan, sabêt ta napilmi yun makit? Gisay timbu nayi ya pangkimpayên angin? Asê! ");
INSERT INTO blx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Gisay tawu nayi ya nakayaming mangêd? Asê, ta ya mani tawuy nakayaming mangêd, kay makitan sa balin ari. ");
INSERT INTO blx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Naku kaw êt nayi sa kakyangan amên makit ya gisay propeta? Awu! Pêtêg, gisa yabay propeta si Juan. Nuwa pansabin ku kamuyuy igit yapun sa gisay propeta. ");
INSERT INTO blx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta sabay si Juan na pantukuyun Bapan Namalyari sabitun sinabi na sa Kasulatan, ‘Dilag gakun gisay iutus ya muna kamu amên mil-an danan mu.’ ” ");
INSERT INTO blx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Pansabin ku kamuyuy ayin tawuy in-anak ya igit pun kan Juan. Nuwa nu sisabêt man na pinakanayêpa sa mani tawuy pag-arian Bapan Namalyari, igit yapun kan Juan. ");
INSERT INTO blx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ubat pun sa pangaral Juan angga amêsên, pampilitin mani tawun mibilang sila sa pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tagawan ya kaganawan propeta, nagsabi yana sabitun nuna tungkul sa pag-arin Bapan Namalyari buy idi êt sa Kautusan na impasulat kan Moises. Nuwa ya abiin, kay aangga sa panawun Juan. ");
INSERT INTO blx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Buy nu maniwala kaw sa pansabin na ati, si Juan sabay si Elias ya impangakun lumatêng. ");
INSERT INTO blx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sikaw wa mani mallêngê, pakaisipin yuy nalêngê yu!” ");
INSERT INTO blx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Sinabi pun êt Jesus, “Sa sabêt ku maiparisuy mani tawu sa panawun amêsên? Maiparisu ku sila sa mani anak ka nakaiknu sa pangapalan. Pansabin lan masnêg sa mani kakapal la, ");
INSERT INTO blx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tinigtigan yan kaw bulugudyung, nuwa a kaw nanalêk. Nagkanta kay pagkanta sa nati, nuwa siyan a kaw nanangis.’ ” ");
INSERT INTO blx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Para êt bayduy mani tawu amêsên ya sên inlumatêng baydi si Juan, nakitan la yay mag-ayunu buy asê maminêm alak. Pansabin lay, ‘Pansêdakan nadawak ka ispirituy tawun abiin.’ ");
INSERT INTO blx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Buy sikuy ubat sa langit ta in-Anak Tawu, sên inlumatêng ngaku baydi, nakitan lakun mangan buy maminêm alak, siyan pansabin lay, ‘Elêwên yumbay ya tawun abiin! Masing-ul buy mapaglasing ya, kaluguran yan mani maningil buwis buy mani mapanyag kasalanan!’ Nuwa paraman baydu, mapagpapêtgan na pêtêg ga kabiyasnan Bapan Namalyari sa kapamilatan diyag mani tawuy manunul sa kalabayan na.” ");
INSERT INTO blx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pamakayari, sinabyanan Jesus ya mani tawu sa mani balayan ya pinanyagan nan malakêy mamakaupapas, gawan a sila nagsisi sa mani kasalanan la. ");
INSERT INTO blx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sinabi na, “Mamakapalunus kaw wa mani taga balayan Corazin! Mamakapalunus kaw êt ta mani taga balayan Bethsaida! Ta nu sa balayan Tiro buy balayan Sidon nalyari ya mani mamakaupapas ya dinyag ku kamuyu, manayna dayi silan nagyaming saku buy inabwan lan abuy ulu la bilang pagpapêtêg ga nagsisi silayna. ");
INSERT INTO blx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nuwa pansabin ku kamuyuy sa Allun Pangukum Bapan Namalyari, mas mabyat ta parusay madanasan yu kaysa mani taga Tiro buy mani taga Sidon. Gawan agyan nakit yuy mani mamakaupapas ya dinyag ku, a kaw nagsisi sa mani kasalanan yu. ");
INSERT INTO blx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Buy sikaw wa mani taga Capernaum, indap yu kali nu dayêwên kaw angga sa langit? Asê! Isamwag kaw sa impernu! Tagawan nu sa Sodoma nalyari ya mani mamakaupapas ya dinyag ku kamuyu, asê dayi inulam Bapan Namalyari ya balayan la buy nanugêl pun dayi ya balayan la angga amêsên. ");
INSERT INTO blx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kabay pansabin ku kamuyu, sa Allun Pangukum, mas mabyat ta parusay madanasan yu kaysa mani taga Sodoma.” ");
INSERT INTO blx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sa uras êt abitu sinabin Jesus, “Pampasalamatan katay Bapa, ya Panginuun sa langit buy baydi sa babun luta, gawan inliim muy ati ya kapêtêgan sa mani tawuy biyasa buy sa mani matag-ay ya pinag-aralan, nun a impatanda mu sa mani tawuy kaparisun nabêlêng nga anak ya ayin pun tanda. ");
INSERT INTO blx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Awuy Bapa, dinyag muy abiin ta abiin na kalabayan mu.” ");
INSERT INTO blx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pamakayari, sinabi na sa mani tawu, “Indin na kangkun Bapay kaganawan. Ayin magtanda kangkuy Anak na, nun a kay ya Bapa ku. Buy ayin êt magtanda kan Bapa, nun a kay sikuy Anak na buy ya mani tawuy pinili kun pipatandan kana.” ");
INSERT INTO blx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Magdani kaw kangku, sikaw wa kaganawan magkasakit buy mabyatan, ta sikuy mam-in kapaynawan kamuyu. ");
INSERT INTO blx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Sunulun yuy mani utus ku buy mag-aral kaw kangku, tagawan mangêd buy nayêpay nakêm ku. Buy makatanam kaw kapaynawan, ");
INSERT INTO blx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","gawan asê mabyat ta pawud ku buy nalêp-aw wa pan-ipabakay ku kamuyu.” ");
INSERT INTO blx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Gisay Allun Pagpaynawa, nagdan silan Jesus sa nagtrigu. Nalayangan mani tagasunul na. Kabay nanggutus silan tilalagay trigu buy kinnan lay ati. ");
INSERT INTO blx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sên nakit silan mani Pariseo, sinabi la kan Jesus, “Elêwên muy pandaygên mani tagasunul mu. Pallabagên lay Kautusan tungkul sa Allun Pagpaynawa.” ");
INSERT INTO blx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pikitbayan silan Jesus, “A yu pun nayi nabasay dinyag David sabitun inlayang ya buy mani kaawyun na? ");
INSERT INTO blx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sinumun ya sa Tolday Pagsimban, nangwa yan tinapay ya in-andug kan Bapan Namalyari, kinnan na buy pinakan na êt ta mani kaawyun na, agyan idi sa Kautusan ya kay mani pari ya dilag karapatan mangan abitu. ");
INSERT INTO blx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","A yu pun êt nayi nabasa sa Kautusan na impasulat kan Moises ya si mani pari, mag-ubra sila sa Templu agyan sa Allun Pagpaynawa? Gisa êt ta ati sa asê panunul sa Kautusan na impasulat kan Moises, nuwa a sila nangasalanan. ");
INSERT INTO blx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pansabin ku kamuyuy dilag pun gisay idi baydi ya igit pun sa Templu. ");
INSERT INTO blx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","Tagawan sikuy ubat sa langit ta in-Anak Tawuy makapagsabi nu sabêt ta daygên sa Allun Pagpaynawa. Tanda yuta dayi nu sabêt ta labay sabin Bapan Namalyari sa Kasulatan, ‘Alwan andug yu kangkuy labay ku, nun a mapallunus kaw.’ Nuwa gawan a yu tanda, pan-atulun yuy mani kaawyun kuy ayin kasalanan.” ");
INSERT INTO blx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pamakabitan Jesus sa lugal abitu, sinumun ya sa balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Dilag gisay liyaki bayduy nati ya gisay gamêt. Dilag êt mani tawu bayduy mangkap maisangkan laban kan Jesus. Kabay pinatang laya, “Pantulutan nayin Kautusan na mamaiyul nagsakit sa Allun Pagpaynawa?” ");
INSERT INTO blx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nakitbay ya, “Nu sikaw wa dilag tupa ya nanabu sa lubut sa Allun Pagpaynawa, alwa nayin isalwang yuya?” ");
INSERT INTO blx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Luyang ngabay ya tawuy maulaga kaysa sa gisay tupa! Kabay pantulutan Kautusan na manyag mangêd sa kaparisun tawu sa Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pamakayari, sinabin Jesus sa liyaki ya nati ya gisay gamêt, “Ipaktang muy gamêt mu.” Kabay impaktang liyaki ya gamêt na buy inumiyul ya kaparisun kapakan gamêt na. ");
INSERT INTO blx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Namitay mani Pariseoy idi baydu buy nisasabi sila nu parasaantu lan maipapati si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Natandan Jesus ya pan-isipin mani Pariseo. Kabay namita ya buy mani tagasunul na. Malakêy tawuy nangamat kana buy pinaiyul nay kaganawan nipagsakit. ");
INSERT INTO blx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nuwa impakasipit nan intipan kallay, “Agana yu ipatanda sa kaatag nu sisabêt taku.” ");
INSERT INTO blx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sa pakapakun baydu, natupad da sinabin Bapan Namalyari sa kapamilatan propeta Isaias, ");
INSERT INTO blx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ati ya lingkud da pinili ku. Kakaidwan kuya buy kapapaidu ya kangku. Iutus ku kanay Ispiritu ku, buy ipatanda nay katuynungan sa kaganawan bansa. ");
INSERT INTO blx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A ya makisubakan, a ya masnêg magsabi, buy asê malêngêy tunuy na sa dan. ");
INSERT INTO blx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ya mani mangayna sa panampalataya, pas-êyên na sila, buy a na paulayan na mani matasan un pag-asa. A ya tunggên anggan asê manambut ta katuynungan. ");
INSERT INTO blx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta siyay pangubatan pag-asan kaganawan tawu sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dilag gintan na mani tawu kan Jesus ya gisay liyaki ya binulag buy pinapipin nadawak ka ispiritu. Pinaiyul yan Jesus. Kabay nakakit ya buy nakapagsabi. ");
INSERT INTO blx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nakaupapas ya kaganawan buy sinabi la, “Ati ya lawês ya Mamiligtas ya impangakun Bapan Namalyari ya ubat sa layin David?” ");
INSERT INTO blx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nuwa sên nalêngên mani Pariseoy abiin, sinabi la, “Si Satanas ya puun nangadadawak ka ispiritu ya nam-in kapangyarian kanan mamipatas nangadadawak ka ispiritu!” ");
INSERT INTO blx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nuwa tandan Jesus ya pan-isipin la. Kabay sinabi na kalla, “Nu mitutubag ga mani tawu sa gisay kaarian, masiray kaarian. Para êt baydu sa gisay balayan o pamilya. Nu mitutubag sila, a sila êt mapêng. ");
INSERT INTO blx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kabay nu si Satanas ya mipatas sa kaawyun nan nangadadawak ka ispiritu, pagkapati nay pansakupun na. Nu parabayduy pandaygên na, asê mapêng ya panakup na. ");
INSERT INTO blx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Buy nu mamipatas sakun mani nangadadawak ka ispiritu sa kapamilatan kapangyarian Satanas, sisabêt awêd da nam-in kapangyarian sa mani tagasunul yu amên mamipatas nangadadawak ka ispiritu? Ya mani tagasunul yuy mamipapêtêg ga taganan mali kaw. ");
INSERT INTO blx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amêsên, gawan namitas sakun mani nadawak ka ispiritu sa kapamilatan Ispiritun Bapan Namalyari, ya labay sabin, inlumatêng nga kamuyuy pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ayin malyarin makasun sa balin gisay tawuy napas-êy kaynu dilag pun mas napas-êy kana. Buy nu naigapus sinan mas napas-êy pun kana, masunan na bali na buy matakaw wa pibandiyan na.” ");
INSERT INTO blx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ya asê panig kangku, kapati naku buy ya asê manawup sa pamidanin mani tawu kangku, kay mamipakarayu yan tawu kangku. ");
INSERT INTO blx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pansabin ku kamuyuy kaganawan kasalanan buy pallamus kan Bapan Namalyari, mapatawad pun. Nuwa ya pallamus sa Ispiritun Bapan Namalyari, ayin patawad. ");
INSERT INTO blx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sisabêt man na mallamus kangkuy ubat sa langit ta in-Anak Tawu, mapatawad pun. Nuwa nu sisabêt man na mallamus sa Ispiritun Bapan Namalyari, ayina mapatawad kanuman.” ");
INSERT INTO blx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nu pansabin yun mangêd da puun kayu, pangkanên na tagêy na. Nuwa nu asê mangêd da puun kayu, asê pangkanên na tagêy na. Tagawan matandan na puun kayu sa tagêy na. ");
INSERT INTO blx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sikaw wa napakalayin lupung, parasaantu kaw makapagsabin mangêd pakan nadawak ka bêkê yu? Tagawan nu sabêt ta idi sa bêkên gisay tawu, sabay ya sabin na. ");
INSERT INTO blx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ya tawuy mangêd da ugali, magsabi yan pawan kangêdan, tagawan napnun kangêdan na bêkê na. Nuwa ya tawuy nadawak ka ugali, magsabi yan pawan kadawakan, tagawan napnun kadawakan na bêkê na. ");
INSERT INTO blx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pansabin ku kamuyuy sa Allun Pangukum, managut ta balang gisa sa balang sinabi nay ayin kapukatan. ");
INSERT INTO blx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tagawan matandan sa mani pagsabi mu nu parusan ka o asê.” ");
INSERT INTO blx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dilag dakun umnuy manurun Kautusan buy mani Pariseoy nagsabi kan Jesus. Sinabi la, “Manuru, mipakit kan mamakaupapas bilang tanda' ya in-utus kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nakitbay si Jesus, “Sikaw wa mani tawu amêsên na nadawak buy asê tapat kan Bapan Namalyari, manyawad kaw mamakaupapas bilang tanda' ya in-utus sakun Bapan Namalyari, nuwa ayin yan ipakit kamuyu nun a ya tanda' ya nalyari kan propeta Jonas sabitun nuna. ");
INSERT INTO blx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ta nu parasaantun idi sa bitukan kakaragulan kênan lanêm si Jonas un tatluy allu buy tatluy yabi, para ku êt bayduy ubat sa langit ta in-Anak Tawu, tatluy allu buy tatluy yabi yaku êt nakalbêng. ");
INSERT INTO blx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pamakayarin nangaral Sabin Bapan Namalyari si Jonas baydu sa Nineve, nagsisi ya mani tawu. Amêsên, idi yaku baydi ya igit pun kan Jonas nuwa a kaw kalabay magsisi sa mani kasalanan yu. Kabay sa Allun Pangukum, midêng nga mani taga Nineve buy manuwat kamuyu. ");
INSERT INTO blx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Alwa pun êt kay abiin. Ya Reynan Sheba awlagi, agyan naubat yapun sa marayuy lugal, naku yan mallêngê sa kabiyasnan Arin Solomon. Amêsên, idi yaku baydi ya igit pun kan Arin Solomon nuwa a kaw kalabay mallêngê kangku. Kabay sa Allun Pangukum, midêng nga Reynan Sheba buy manuwat kamuyu.” ");
INSERT INTO blx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nu mag-awas ya nadawak ka ispiritu sa tawu, mibitabita ya sa mani kakyangan na lugal amên mangkap yan mapagpaynawan na. Nuwa nu ayin yan makitan, ");
INSERT INTO blx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","sabin na sa sarili nay, ‘Mag-udung ngaku tana sa tawuy ubatan ku.’ Buy nu niudung ngina, makitan nay ubatan na ya paran bali ya ayin nan manugêl, malinis buy nakakumpuni yana. ");
INSERT INTO blx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kabay magtas ya sa tawuy ubatan na. Nuwa sa pag-udung na, mamipikilaku yan pituy ispirituy luyang pun nadawak kana buy magsêdak sila sa tawun abitu. Kabay luyang pun dumawak ya kabilyan tawun abitu kaysa sa mana nan kabilyan. Para êt baysên na malyari sa mani nadawak ka tawu amêsên.” ");
INSERT INTO blx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kaban magsabi pun si Jesus sa mani tawu, inlumatêng nga indu na buy mapatêl na. Nakaidêng sila sa lawasan gawan labay layan mapagkasabi. ");
INSERT INTO blx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dilag nagsabi kan Jesus, “Idi sa lawasan na indu mu buy mapatêl mu. Labay lakan mapagkasabi.” ");
INSERT INTO blx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nakitbay si Jesus, “Sisabêt ta indu ku buy mapatêl ku?” ");
INSERT INTO blx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Inturu nay mani tagasunul na buy sinabi na, “Ati ya mani indu ku buy mapatêl ku. ");
INSERT INTO blx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tagawan nu sisabêt man na manunul sa kalabayan Bapa kuy idi sa langit, sabay silay indu ku buy mapatêl ku.” ");
INSERT INTO blx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sa allu êt abitu, nag-awas si Jesus sa bali buy niknu sa agid lawa. ");
INSERT INTO blx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Malakêy tawuy nititipun kana. Kabay nagsakay ya sa bangka buy niknu ya baydun nangaral. Ya mani tawuy naman, idi sila sa agid lawa. ");
INSERT INTO blx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Malakêy paalimbaway in-aral na kalla. Sinabi na, “Dilag gisay manggitnay namibulaglag bini. ");
INSERT INTO blx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sa pamibulaglag na, dilag bini ya nangananabu sa dan. Inlumatêng nga mani uybun manuk buy tinuktuk lay mani bini. ");
INSERT INTO blx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dilag êt mani bini ya nangananabu sa mabatuy lugal la ayin mayngan luta. Tambêng tinumubuy bini gawan nalayab ba luta. ");
INSERT INTO blx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nuwa sên naasnagan mamut ta ati, nawangêy sila, gawan ayin silan pukat pagyamutan. Kabay nangamamati sila. ");
INSERT INTO blx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dilag êt mani bini ya nangananabu sa pantubwanan têmak ka madiwi. Sên inlumabung nga bini, inlumabung êt ta têmak ka madiwi buy kinêlkêlan nay mani bini ya tinumubu. ");
INSERT INTO blx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ya kaatag, nangananabu sa mangêd da luta. Tinumubu buy dinumagul la mani abiin buy nanagêy. Ya kaatag, nanagêy tidinalan na lasi, ya kaatag, tianêmmapu buy ya kaatag êt, titlumpu. ");
INSERT INTO blx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sikaw wa mani mallêngê, pakaisipin yuy nalêngê yu!” ");
INSERT INTO blx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pamakayari, nagdani kan Jesus ya mani tagasunul na buy namatang kana, “Awta manggamit kaw yan paalimbawa sa pangaral yu sa mani tawu ta?” ");
INSERT INTO blx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nakitbay si Jesus, “Impaintindi kamuyuy nakaliim tungkul sa pag-arin Bapan Namalyari, nuwa asê impaintindi sa kaatag. ");
INSERT INTO blx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tagawan ya tawuy manunul sa malêngê nay kapêtêgan, biyan yapun êt pangintindi. Nuwa ya tawuy asê manunul sa malêngê nay kapêtêgan, agyan pêrad nan pangintindi, itas pun êt kana. ");
INSERT INTO blx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kabay pawa kun magsabi kallan paalimbawa, tagawan kapangêlêw-êlêw laman, a sila makakit buy kapallêngê-lêngê laman, a sila makalêngê buy makapukat. ");
INSERT INTO blx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kabay natupad kallay sinabin propeta Isaias, ‘Kapallêngê-lêngê yu man, a kaw makapukat. Buy kapangêlêw-êlêw yu man, a kaw makakit. ");
INSERT INTO blx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tagawan nakdêy ya ulun mani tawun ati. Tinêmpanan lay mani têk la buy impêdêng lay mani mata la. Gawan dat makakit ta mani mata la buy makalêngêy mani têk la, buy mapukatan lay pansabin ku buy magdani sila kangku amên paiyulun ku sila.’ ” ");
INSERT INTO blx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nuwa pinagpala kaw, tagawan mangakitan yuy pandaygên ku buy mangapukatan yuy pansabin ku. ");
INSERT INTO blx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Pansabin ku kamuyuy malakêy mani propeta buy mani matinêk ka tawu awlagi ya kalabay makakit sa nakit yu, nuwa a la nakit ta abitu. Labay la êt malêngêy nalêngê yu, nuwa a la nalêngê.” ");
INSERT INTO blx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pakalêng-ên yuy labay sabin paalimbawa tungkul sa mamibulaglag bini. ");
INSERT INTO blx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ya bini sabay ya Sabin Bapan Namalyari. Ya dan na kinapinabwan bini, sabay ya mani tawuy nallêngê sa Sabin Bapan Namalyari tungkul sa pag-ari na, nuwa a la napukatan. Inlumatêng si Satanas buy intas na sa bêkê lay nalêngê la.” ");
INSERT INTO blx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Ya mabatuy lutay kinapinabwan bini sabay ya mani tawuy nallêngê sa Sabin Bapan Namalyari buy tambêng lan tinanggap dilag tula. ");
INSERT INTO blx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nuwa asê napêng nga ati gawan asê nipakatêbêk sa bêkê lay Sabin Bapan Namalyari. Kabay sên inlumatêng nga kasakitan o pamasakit gawan sa Sabin Bapan Namalyari, tambêng lan tinalibatukan ya panampalataya la. ");
INSERT INTO blx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ya lutay pantubwanan têmak ka madiwi nu saantu nanabuy kaatag bini, sabay ya mani tawuy nallêngên Sabin Bapan Namalyari. Nuwa gawan sa mani pangganakên baydi sa babun luta buy sa paglabay lan bumandi, nalitêpan lay Sabin Bapan Namalyari. Kabay asê nanagêy sa biyay la. ");
INSERT INTO blx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nuwa ya mangêd da lutay kinapinabwan bini sabay ya mani tawuy nallêngê buy nakapukat sa Sabin Bapan Namalyari. Kabay dilag nanagêy tidinalan, tianêmmapu buy ya kaatag, titlumpu.” ");
INSERT INTO blx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nangaral la êt si Jesus kallan gisay paalimbawa, “Ya pag-arin Bapan Namalyari, maiparisu sa dinyag gisay tawuy nibulaglag mangêd da bini sa panggitnan na. ");
INSERT INTO blx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nuwa pamakayabi, kaban mamabêlêw wa mani tawu, inlumatêng nga kapati na buy nibulaglag binin têmak sa trigu buy namita. ");
INSERT INTO blx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sên tinumubuy trigu buy nanagêy, inlumtaw êt ta têmak. ");
INSERT INTO blx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kabay nakun namatang nga mani ipus sa magbandin panggitnan, ‘Alwa nayin kay mangêd da binin triguy imbulaglag mu sa panggitnan? Ipakun nabiyan binin têmak?’ ” ");
INSERT INTO blx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Sinabin magbandi, ‘Gisay kapati ya nanyag abiin.’ ” “Pinatang yan mani ipus, ‘Labay yu nayin lamunun yan na mani têmak?’ ” ");
INSERT INTO blx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Nakitbay ya, ‘Agana yu pun, ta dat mapikilamun yuy mani trigu. ");
INSERT INTO blx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pasawên yu pun angga sa pupulun. Nu lumatêng nga panawun abitu, sabin ku sa mani mamupul, “Unên yu pun lamunun na mani têmak buy piaawyunun yu amên sêlbên. Pamakayari, pupulun yuy trigu buy tipunun sa budega ku.” ’ ” ");
INSERT INTO blx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nangaral la êt si Jesus kalla sa paalimbawa, “Ya pag-arin Bapan Namalyari, maiparisu sa nabêlêng nga but-un mustasay intanêm gisay tawu sa panggitnan na. ");
INSERT INTO blx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nuwa nu dumagul la ati, maragul yapun sa kaatag panggulayên buy pakadyag yan paran puun kayu. Kabay ya mani sangan ati, mapanyagan salay mani uybun manuk.” ");
INSERT INTO blx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nangaral la êt si Jesus kalla sa gisay paalimbawa, “Ya pag-arin Bapan Namalyari, maiparisu sa pêpêrad da pamalbag ga ginêmês gisay babayi sa malakêy arina. Kabay napalbag nay arinay ginêmês.” ");
INSERT INTO blx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sa pangaral Jesus tungkul sa pag-arin Bapan Namalyari, a ya nanuru sa mani tawun asê nanggamit paalimbawa. ");
INSERT INTO blx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sa paradi ya paralan, natupad da sinabin Bapan Namalyari sa kapamilatan propeta na, “Magsabi yaku kalla sa kapamilatan paalimbawa. Sabin ku kallay mani bagay ya nakaliim ubat pun sabitun dinyag ga babun luta.” ");
INSERT INTO blx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pamakayari, inlakwanan Jesus ya mani tawu buy sinumun ya sa gisay bali. Nagdani ya mani tagasunul na buy sinabi kana, “Ipatanda mu kanyan na labay sabin paalimbawa tungkul sa têmak ka idi sa panggitnan.” ");
INSERT INTO blx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nakitbay si Jesus, “Ya nibulaglag mangêd da bini, sabay sikuy ubat sa langit ta in-Anak Tawu. ");
INSERT INTO blx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ya panggitnan sabay ya babun luta. Buy ya mangêd da bini, sabay ya mani tawuy pag-arian Bapan Namalyari. Ya mani têmak, sabay ya mani tawuy pansakupun Satanas. ");
INSERT INTO blx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ya kapatin manggitna ya namibulaglag binin têmak, sabay si Satanas. Ya pamupul, sabay ya katganan babun luta. Buy ya mamupul, sabay ya mani ang-el. ");
INSERT INTO blx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nu parasaantun tipunun na mani têmak buy pan-ulamên, para êt bayduy malyari sa mani pag-arian Satanas sa katganan babun luta. ");
INSERT INTO blx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sikuy ubat sa langit ta in-Anak Tawuy mamiutus mani ang-el, buy itas la sa pag-arian kuy kaganawan pangubatan kasalanan kaatag buy manyag kadawakan. ");
INSERT INTO blx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Isamwag sila sa manggilud da apuy. Manangis sila baydun mingêngêt ta bêbêy. ");
INSERT INTO blx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nuwa ya mani matinêk, mansumawang silan nanuwad mamut sa pag-arian Bapa lan Namalyari. Sikaw wa mani mallêngê, pakaisipin yuy nalêngê yu!” ");
INSERT INTO blx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sinabi pun êt Jesus, “Ya pag-arin Bapan Namalyari, maiparisu sa pibandiyan na nakakali sa gisay panggitnan. Sên nakalin gisay tawu, ingkali nan manguman. Buy sa tula na, nuli ya buy insaliw nay kaganawan pibandiyan na amên masaliw nay abituy panggitnan.” ");
INSERT INTO blx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ya pag-arin Bapan Namalyari, maiparisu sa dinyag gisay mangalakal ya mangkap mangangêd da perlas. ");
INSERT INTO blx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sên nakakit yan gisay makamal la perlas, insaliw nay kaganawan pibandiyan na buy sinaliw nay abituy perlas.” ");
INSERT INTO blx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ya pag-arin Bapan Namalyari, maiparisu sa gisay pukut ya pinanalap mani tawu sa lawa buy nakadakêp silan magmikakalasi ya kênan lanêm. ");
INSERT INTO blx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sên napnuy nay pukut, ginuluy lay ati sa agid lawa. Pamakayari, niknu sila buy impapawa lay kênan lanêm ma makna buy insamwag lay asê makna. ");
INSERT INTO blx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Para êt bayduy malyari sa katganan babun luta. Lumatêng nga mani ang-el buy ipapaway mani matinêk sa nangadadawak. ");
INSERT INTO blx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Isamwag ga mani nangadadawak sa manggilud da apuy. Manangis sila baydun mingêngêt ta bêbêy.” ");
INSERT INTO blx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pamakayari, pinatang silan Jesus, “Napukatan yu nayi ya kaganawan paalimbaway sinabi ku?” Nakitbay sila, “Awu. Napukatan yan nana.” ");
INSERT INTO blx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Buy sinabin Jesus kalla, “Kabay awêd, ya balang manurun Kautusan ya naturwanan nana tungkul sa pag-arin Bapan Namalyari, maiparisu sa gisay magbandin bali ya dilag malakêy pibandiyan sa budega. Pan-isalwang nay mana buy bayun gamit sa budega na.” ");
INSERT INTO blx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pamakayarin in-aral Jesus ya mani paalimbawan abiin, namitayna. ");
INSERT INTO blx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Naku ya sa Nazaret sa balayan na kinaragulan na buy nangaral ya baydu sa balin pagtipunan mani Judio. Nakaupapas ya mani kabaryu na sa kabiyasnan na. Sinabi la, “Saantu nay naman nakway kabiyasnan na buy kapangyarian manyag mamakaupapas? ");
INSERT INTO blx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pakan kay anak yan gisay kalpinteru ta buy ya indu na, si Maria? Buy alwa nayin mapatêl nay lawyaki silan Santiago, Jose, Simon, buy si Judas? ");
INSERT INTO blx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Buy alwa nayin kay kabaryu tamu êt ta mapatêl nay babayi? Saantu na nakway parabaysên na kapangyarian?” ");
INSERT INTO blx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kinasêman laya. Kabay sinabin Jesus kalla, “Ya gisay propeta, panggalangên ya agyan dakun saantuy lugal, liban tana sa sarili nan balayan buy pamilya.” ");
INSERT INTO blx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Asê nanyag baydun malakêy mamakaupapas si Jesus, gawan a sila manampalataya kana. ");
INSERT INTO blx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sa panawun abitu, nabalitan Gobernador Herodes Antipas ya tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kabay sinabi na sa mani upisyal na, “Siya si Juan ya Mamawtismu ya nanguman nabyay! Kabay mamakadyag yan mamakaupapas!” ");
INSERT INTO blx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ati ya nalyari kan Juan bayu ya nati. Pawa nan pansabin kan Gobernador Herodes Antipas, “Asê ustuy pinag-asawa mu si Herodias ya asawan Felipe ya patêl mu.” Kabay impadakêp buy impasukul Gobernador Herodes Antipas si Juan. ");
INSERT INTO blx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Labay dayin Gobernador Herodes Antipas ya ipapati na si Juan, nuwa malimu ya sa mani Judio tagawan pangkilalanên lan propeta si Juan. ");
INSERT INTO blx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sên inlumatêng ngay allun pangganaka sa allun pamianak kan Gobernador Herodes Antipas, nanalêk ka dalaga ya anak Herodias sa arapan mani bisita. Gawan sa panalêk na, natula si Gobernador Herodes Antipas. ");
INSERT INTO blx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kabay sinabi na sa dalaga, “Manumpa kun idin ku kamuy agyan sabêt ta yawarên mu.” ");
INSERT INTO blx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Gawan sa sinabin Gobernador Herodes Antipas, nakuy dalaga sa indu na buy namatang ya nu sabêt ta labay nan yawarên. Kabay sinabi na sa dalagay paradi, “Labay kuy idin mu kangkuy ulun Juan ya Mamawtismuy idi sa gisay pambusku.” Kabay nag-udung ya kan Gobernador Herodes Antipas buy sinabi nay abitu. ");
INSERT INTO blx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ingkalungkut Gobernador ya inyawad dalaga. Nuwa gawan sa pangakuy nalêngên mani bisita, in-utus nay daygên na inyawad dalaga. ");
INSERT INTO blx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kabay impaputus nay ulun Juan ya idi sa sukulan ");
INSERT INTO blx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","buy indin ya ulu na sa gisay pambusku buy inggawang sa dalaga. Buy inggawang êt dalaga sa indu na. ");
INSERT INTO blx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kingwan mani tagasunul Juan ya bangkay na buy in-ilbêng. Pamakayari, impatanda la kan Jesus ya nalyari. ");
INSERT INTO blx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sên natandan Jesus ya abitu, namita ya baydu buy nagsakay ya sa gisay bangka napapakun sa gisay lugal la kakyangan. Nuwa sên natandan mani tawuy ubat sa magmikakanayun na balayan ya nakabitay na si Jesus, namita sila papakun sa lugal la lakwên na. ");
INSERT INTO blx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kabay sên nagtabuy si Jesus sa bangka, nakitan nay sadyay lakên tawu. Nalunus ya kalla. Kabay pinaiyul nay mani nipagsakit. ");
INSERT INTO blx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sên mamayabi-yabi yana, nagdani kan Jesus ya mani tagasunul na buy sinabi la, “Idi kitamu sa kakyangan na lugal buy yabi yana. Kabay ipalaku minay mani tawu sa nangarani ya baryu amên makasaliw silan maêkan la.” ");
INSERT INTO blx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nuwa sinabin Jesus kalla, “A layna kaylangan mita. Sikaw wa mam-in maêkan la.” ");
INSERT INTO blx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nakitbay sila, “Kay lilima yabay ya tinapay tamu buy kay luluway kênan lanêm.” ");
INSERT INTO blx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sinabin Jesus, “Gêtan yu di kangku.” ");
INSERT INTO blx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pinaiknu nay mani tawu sa lamun. Pamakayari, kingwa nay limay tinapay buy luway kênan lanêm. Nangêlêw ya sa langit buy nagpasalamat kan Bapan Namalyari. Binis-ilbis-il nay tinapay buy kênan lanêm buy indin na sa mani tagasunul na. Indin êt mani tagasunul na sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nakaêkan na kaganawan tawu buy nabsuy. Sên tinipun mani tagasunul nay tagan na tinapay buy kênan lanêm, napakapnu la pun êt ta mapu buy luway salikap. ");
INSERT INTO blx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ya bilang mani lawyaki ya nakaêkan, limay libu. Asê pun kaawyun na mani babayi buy mani anak baydu. ");
INSERT INTO blx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kaban pan-ipaulin Jesus ya mani tawu, impasakay na sa bangka ya mani tagasunul na buy impauna na sa lipay lawa. ");
INSERT INTO blx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sên nakabitay nay mani tawu, sinumukpa yan kakapad na sa bung-uy amên manalangin. Nayabinan nayna baydu ");
INSERT INTO blx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","buy ya bangkan mani tagasunul na, idi yana sa bunak lawa ya masipwakan nan mangaragul la alun gawan masabangan silan angin. ");
INSERT INTO blx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sên bunatbunat tana, kinamat nay mani tagasunul nan mamita sa babun lanêm. ");
INSERT INTO blx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sên nakit mani tagasunul nay dilag mamita sa babun lanêm, sadyay limu la. Kabay masnêg lan sinabi, “Anitu!” ");
INSERT INTO blx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nuwa tambêng nagsabi si Jesus, “Sikuy ati, agana kaw malimu. Pas-êyên yuy nakêm yu!” ");
INSERT INTO blx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nakitbay si Pedro kana, “Panginuun, nu sabay sikay abiin, ipalaku muku baysên mamita êt sa babun lanêm.” ");
INSERT INTO blx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Kaksaw ka!”, sinabin Jesus. Kabay nagtabuy si Pedro sa bangka buy namita sa babun lanêm papakun kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nuwa sên nakitan nay malakas ya angin, nalimu ya buy pakanawa yan nilêmlêm. Kabay masnêg nan sinabi, “Panginuun, iligtas muku!” ");
INSERT INTO blx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tambêng yan dinwang Jesus buy sinabi na, “Nabêlêng yay panampalataya muta! Siyan magmitalisa ka yata?” ");
INSERT INTO blx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sên pamakasakay lan luwa sa bangka, tinunggên na malakas ya angin. ");
INSERT INTO blx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Buy inulimên yan mani tagasunul nay idi sa bangka buy sinabi lay, “Pêtêg yabay Anak Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sên pamakalipay la sa lawa, nilatêng sila sa lugal Genesaret. ");
INSERT INTO blx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nakilalan mani taga baydu si Jesus buy tambêng silan niutus mibalita sa mani tawu sa lugal la nakapalitêng baydu. Kabay gintan kan Jesus ya kaganawan nagsakit. ");
INSERT INTO blx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nakilunuslunus kan Jesus ya mani nipagsakit ya agyan kay madukpan lay palpal yaming na. Buy inumiyul la kaganawan nakadukpa kana. ");
INSERT INTO blx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pamakayarin abitu, nagdani kan Jesus ya dakun umnuy Pariseo buy mani manurun Kautusan na ubat sa Jerusalem. Namatang sila kana, ");
INSERT INTO blx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Uysiyan a ya pansunulun mani tagasunul muy naugalyan mani pipuunpuunan tamu ta? A sila mag-uyas gamêt bayu mangan.” ");
INSERT INTO blx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pikitbayan silan Jesus, “Uysiyan pallabagên yu yay utus Bapan Namalyari amên kay masunul yuy mani naugalyan mani pipuunpuunan yu ta? ");
INSERT INTO blx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaparisun ati, in-utus Bapan Namalyari ya, ‘Galangên muy mangatwa mu.’ Buy in-utus na êt ya, ‘Sisabêt man na mandustak sa mangatwa na, sêpat yan patin.’ ");
INSERT INTO blx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nuwa sikaw, siyan pan-iaral yu yay malyarin sabin anak sa mangatwa nay, ‘Mangatwa kuway, ya sawup pa idin ku dayi kamuyu, in-il-an kina kan Bapan Namalyari.’ ");
INSERT INTO blx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Sa pakapakun baydu, a nayna inggalang ya mangatwa na. Gawan sa naugalyan yu, dinyag yun ayin kapukatan na utus Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mani mapagtalingkayu! Pêtêg ga impasulat Bapan Namalyari kan Propeta Isaias tungkul kamuyu. Ta idi sa kasulatan, ");
INSERT INTO blx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Panggalangên nakun mani tawun ati nuwa kay sa sabi la, tagawan marayu kangkuy bêkê la. ");
INSERT INTO blx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ayin kapukatan na pangulimên la kangku, gawan na pan-ituru la, kay utus tawu.’ ” ");
INSERT INTO blx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Impadanin Jesus ya mani tawu buy sinabi na kalla, “Mallêngê kaw buy pakaintindin yuy sabin ku. ");
INSERT INTO blx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Alwan mansumun sa bêbêy tawuy makapadinat kana, nun a ya nadawak ka sabi ya man-umawas sa bêbêy na.” ");
INSERT INTO blx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nagdani ya mani tagasunul na buy sinabi, “Manuru, a mu nayi tanday natibsêy mani Pariseo gawan sa sinabi mu?” ");
INSERT INTO blx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nakitbay si Jesus, “Ya kaganawan tanaman ya asê intanêm Bapa kuy idi sa langit, ulutun na. ");
INSERT INTO blx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pasawan yu sila. Ta para silan mani bulag ya mangakay kaparisu lan bulag. Nu akayên bulag ya kaparisu nan bulag, parisu silan manabu sa kali.” ");
INSERT INTO blx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Amêsên, sinabin Pedro, “Ipaintindi mu kanyan ya labay sabin abiin na paalimbaway sinabi mu.” ");
INSERT INTO blx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sinabin Jesus kalla, “Sikaw êt nayi, a yu mapukatan? ");
INSERT INTO blx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","A yu nayi tanday agyan sabêt ta kanên yu, sumun sa bituka yu buy iawas nay ati? ");
INSERT INTO blx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nuwa ya mani nadawak ka sabi ya man-umawas sa bêbêy tawu ya naubat sa bêkê na, sabay ya makapadinat kana. ");
INSERT INTO blx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tagawan maubat sa bêkên tawuy pangisip nan nadawak ya sabay ya mitustus kanan mamati, makikanayun, mampêl, manakaw, maglaram, buy magsabin nadawak laban sa kaparisu na. ");
INSERT INTO blx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Abiin na kaganawan kadawakan ya sabay ya makapagpadinat sa gisay tawu, nuwa ya asê pag-uyas gamêt bayu mangan, alwan abiin ya makapadinat kana.” ");
INSERT INTO blx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Namita baydu si Jesus buy naku ya sa mani lugal la marani sa balayan Tiro buy Sidon. ");
INSERT INTO blx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dilag gisay babayi ya alwan Judio ya taga Canaan. Nagdani ya kan Jesus buy nakilunuslunus ya kana. Sinabi na, “Panginuun ya layin Arin David, malunus ka kayêk kangku! Ya anak kuy babayi, pansêdakan yan nadawak ka ispiritu ya sabay ya mamasakit kana.” ");
INSERT INTO blx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nuwa asê nakitbay si Jesus kana. Kabay nagdani kanay mani tagasunul na buy sinabi la, “Pabitên yinay babayin abiin, gawan matarit yatan kilalaku kantamu.” ");
INSERT INTO blx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sinabin Jesus sa babayi, “In-utus saku baydi kay para sa mani Israelita ya paran mani tupay nangalilitêp.” ");
INSERT INTO blx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nuwa nagdani kanay babayi buy nanduku sa arapan na buy sinabi, “Panginuun, sawpan muku.” ");
INSERT INTO blx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sinabin Jesus kanay gisay panabin, “Asê mangêd da kêwên na kanên mani anak buy idin sa mani asu.” ");
INSERT INTO blx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nakitbay ya babayi, “Pêtêg yabay ya Panginuun, nuwa agyan mani asu, mangan silan saksak ya mangainêgnêg amung la ubat sa lamesa.” ");
INSERT INTO blx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Amêsên, sinabin Jesus kana, “Bapan dagul panampalataya mu! Madyag ga panyawarên mu.” Buy sa uras êt abitu, inumiyul la anak nay babayi. ");
INSERT INTO blx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sên namita baydu si Jesus, dinuman ya sa agid lawan Galilea buy sinumukpa ya sa bung-uy buy baydu yan niknu. ");
INSERT INTO blx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Malakêy tawuy nilaku kan Jesus un mani pilay, bulag, lumpu, pipi buy kaatag pun êt ta nipagsakit. Indani la sa arapan Jesus buy pinaiyul na sila. ");
INSERT INTO blx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sên nakit mani tawuy nakapagsabi ya pipi, inumiyul ya mani lumpu, nakabitay mani pilay, buy nakakit tay mani bulag, nakaupapas sila. Kabay inulimên lay Bapan Namalyarin Israel. ");
INSERT INTO blx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Binêg Jesus ya mani tagasunul na buy sinabi na kalla, “Malunus saku sa mani tawun ati, gawan tatluy allu ku silaynan kaawyun buy ayin silaynan maêkan. A ku sila labay paulin layangên dat mablay sila sa dan.” ");
INSERT INTO blx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nakitbay ya mani tagasunul na, “Antuy pangwanan tamun kanên baydi sa kakyangan amên ipakan sa paradi ya kalakêy tawu.” ");
INSERT INTO blx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pinatang silan Jesus, “Umnuy tinapay yu baysên?” Nakitbay sila, “Kay pitu buy dakun umnuy nangabêlêng nga kênan lanêm.” ");
INSERT INTO blx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pinaiknun Jesus ya mani tawu sa luta. ");
INSERT INTO blx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kingwa nay pituy tinapay buy mani kênan lanêm buy nagpasalamat ya kan Bapan Namalyari. Pamakayari, binis-ilbis-il nay ati buy indin na sa mani tagasunul na amên idin la sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nakaêkan na kaganawan buy nabsuy. Sên tinipun lay mani tagan na kanên, napakapnu la pun êt ta pituy salikap. ");
INSERT INTO blx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ya bilang mani lawyaki ya nangan, apat ta libu. Asê pun êt kaawyun di ya mani babayi buy mani anak. ");
INSERT INTO blx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pamakayarin impaulin Jesus ya mani tawu, nagsakay ya sa bangka buy naku ya sa lugal Magadan. ");
INSERT INTO blx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dilag mani Pariseo buy mani Saduseoy nagdani kan Jesus amên subukan laya. Inyawad la kanay mipakit yan mamakaupapas bilang tanda' ya in-utus yan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nuwa sinabin Jesus kalla, “Nu mikêlêp pa mamut buy naudit ta langit, pansabin yuy ‘Mangêd da panawun wasak.’ ");
INSERT INTO blx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Buy nu maranun buy makit yuy naudit buy nabudêg ga langit, pansabin yu, ‘Manguran amêsên.’ Tanda yuy labay sabin mani mangakit yu sa langit, nuwa siyan a yu tanday labay sabin mani pandaygên Bapan Namalyari sa kapamilatan ku amêsên ta? ");
INSERT INTO blx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sikaw wa tawu amêsên na nadawak buy asê tapat kan Bapan Namalyari! Manyawad kaw mamakaupapas bilang tanda' ya in-utus sakun Bapan Namalyari, nuwa ayin yan ipakit kamuyu nun a ya tanda' ya nalyari kan propeta Jonas sabitun nuna!” Pamakayari, inlakwanan silan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sên naku sila sa lipay dagat, natandan mani tagasunul Jesus ya naliwan lay mantan tinapay. ");
INSERT INTO blx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sinabin Jesus kalla, “Mangillag kaw sa pamalbag mani Pariseo buy mani Saduseo.” ");
INSERT INTO blx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nisasabi ya mani tagasunul Jesus, “Sinabi nay abitu gawan ayin kitamun gintan na tinapay.” ");
INSERT INTO blx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nuwa tandan Jesus ya pisasabyan la. Kabay pinatang na sila, “Awta siyan pisasabyan yu yay ayin kaw gintan na tinapay ta? Kabêlêng ngan panampalataya yu! ");
INSERT INTO blx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A kaw pun nayi makapukat? Nalitêpan yina nayi ya dinyag ku sa limay tinapay ya impakan sa limay libuy tawu? A yu nayi maganaka nu umnuy salikap pa napakapnu yu sa mani tagan na kanên? ");
INSERT INTO blx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nalitêpan yu êt nayi ya pituy tinapay ya impakan sa apat ta libuy tawu, buy a yu nayi maganaka nu umnuy salikap pa napakapnu yu sa mani tagan na kanên? ");
INSERT INTO blx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","A yu nayi mapukatan na alwan tinapay ya labay kun sabin sabitun sinabi kuy, ‘Mangillag kaw sa pamalbag mani Pariseo buy mani Saduseo?’ ” ");
INSERT INTO blx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kay baydu la pun napukatan ya alwa awêd pamalbag sa tinapay ya labay sabin Jesus nun a ya pan-iaral mani Pariseo buy mani Saduseo. ");
INSERT INTO blx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sên inlumatêng si Jesus buy mani tagasunul na sa lugal ya marani sa balayan Cesarea Filipos, pinatang na sila, “Sabêt ta pansabin mani tawu tungkul kangku ya in-Anak Tawuy ubat sa langit?” ");
INSERT INTO blx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nakitbay sila, “Dilag magsabin sika si Juan ya Mamawtismu. Dilag êt taman magsabin sika si propeta Elias. Buy ya kaatag, magsabin sika si propeta Jeremias o gisa ka sa mani propeta.” ");
INSERT INTO blx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pinatang silan Jesus, “Nuwa kamuyu, sisabêt taku?” ");
INSERT INTO blx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nakitbay si Simon Pedro, “Sabay sika ya Cristuy Anak Bapan Namalyari ya nabyay!” ");
INSERT INTO blx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sinabin Jesus kana, “Simon ya anak Jonas, pinagpala kan Bapan Namalyari tagawan alwan tawuy nipatanda kamun abiin, nun a ya Bapa kuy idi sa langit. ");
INSERT INTO blx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Simon, sika si Pedro buy sa batun ati, ipaydêng kuy manampalatayay miaawyun buy agyan na kapangyarian kamatyan, asê manambut kana. ");
INSERT INTO blx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Idin ku kamuy mani susin kaarian sa langit amên nu sabêt man na ibawal mu baydi sa babun luta, ibawal êt sa langit buy nu sabêt man na tulutan mu baydi sa babun luta, tulutan êt sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pamakayarin abiin, tinipanan Jesus ya mani tagasunul na ya agana la sabin agyan kansabêt man ya sabay siyay Cristuy impangakun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Paubat baydu, impatandan Jesus sa mani tagasunul nay, “Kaylangan kun maku sa Jerusalem buy madanasan na malakêy pamasakit sa mani mangatway manungkulan, mani mamunun pari, buy sa mani manurun Kautusan. Ipapati laku, nuwa sa ikatluy allu, manguman nakun mabyay.” ");
INSERT INTO blx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sên nalêngên Pedroy abitu, pikilaku na si Jesus sa gisay agid buy pinagkasabi naya, “Panginuun, agana ta dayi tulutan Bapan Namalyari kamuy abiin. Kanuman asê malyari kamuy abiin.” ");
INSERT INTO blx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nag-arap si Jesus kan Pedro buy sinabi na, “Magpakarayu ka kangkuy Satanas! Pambênbênan mukun daygên na kalabayan Bapan Namalyari, ta alwan kalabayan nay pan-isipin mu nun a ya kalabayan tawu.” ");
INSERT INTO blx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pamakayari, sinabin Jesus sa mani tagasunul na, “Nu sisabêt man na kalabay manunul kangku, sêpat nan liwanên na sarili nan kalabayan buy nakal-an yan mati gawan sa panunul na kangku kaparisun pamakay kurus buy manunul ya kangku. ");
INSERT INTO blx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tagawan nu sisabêt man na tawuy maglabay miligtas ya biyay na, sabay ya matasan biyay na. Nuwa ya tawuy nakal-an mam-in biyay na para kangku, sabay ya mabiyan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Agyan makwan gisay tawuy kaganawan pibandiyan baydi sa babun luta, nuwa mipakabili ya sa ayin katganan na kaparusan, a nayna mapagnabang nga ati. Dilag ya nayin maibayad amên mabiyan yan biyay ya ayin katganan? ");
INSERT INTO blx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tagawan sikuy ubat sa langit ta in-Anak Tawu, lumatêng ngakun kaawyun na mani ang-el Bapa ku ya dilag kapangyarian na. Sa allun abitu, tumbasan kuy dinyag balang gisa. ");
INSERT INTO blx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pansabin ku kamuyuy dilag dakun umnu kamuyu baydi ya asê mati anggan a laku makitan na ubat sa langit ta in-Anak Tawuy mallumatêng nga mag-ari.” ");
INSERT INTO blx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pamakayarin anêm ma allu, pikilakun Jesus si Pedro buy luway mipatêl ya silan Santiago buy si Juan sa gisay matag-ay ya bung-uy un kay kakapad la. ");
INSERT INTO blx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sên idi silayna baydu, nakit lay nagbayuy wangis Jesus. Ya lupan Jesus, sinumawang nanuwad mamut buy pinupumutin nanuwad sawang nga yaming na. ");
INSERT INTO blx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bêngat tan nagpakit si Elias buy si Moises ya makisabi kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kabay sinabin Pedro kan Jesus, “Panginuun, mangêd da idi kitamu baydi. Nu labay mu, manyag gakun tatluy sawung. Gisa kamu, gisa kan Moises buy gisa kan Elias.” ");
INSERT INTO blx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kaban magsabi pun si Pedro, natugpawan silan mamakasilêw wa ulap. Buy dilag silan nalêngêy tunuy ya ubat sa ulap pa magsabin, “Ati ya kakaidwan kun Anak ya kapapaidu kangku. Mallêngê kaw kana!” ");
INSERT INTO blx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sên nalêngên mani tagasunul nay tunuy, nipaglukub sila gawan sa limu la. ");
INSERT INTO blx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nuwa dinanyan silan Jesus buy tinalan. Sinabi na, “Midêng kaw! Gana kaw malimu.” ");
INSERT INTO blx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sên nangêlêw sila, ayin silaynan kaatag nakitan, nun a kay si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kaban manlumunsan sila sa bung-uy, intipan Jesus kallay, “Agana yu sabin agyan kansabêt man na nakitan yu anggan a ku manguman mabyay ya in-Anak Tawuy ubat sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kabay pinatang yan mani tagasunul na, “Uysiyan pansabin yan mani manurun Kautusan na kaylangan munan lumatêng si Elias bayu si Cristu ta?” ");
INSERT INTO blx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nakitbay si Jesus, “Pêtêg ga dilag munan lumatêng nga kaparisun Elias amên il-an nay kaganawan bagay. ");
INSERT INTO blx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pansabin ku kamuyuy inlumatêng ngay kaparisun Elias, nuwa a ya nakilalan mani tawu nun a dinyag lay labay lan daygên kana. Para êt baysên na daygên la kangkuy ubat sa langit ta in-Anak Tawu, ta pasakitan laku êt.” ");
INSERT INTO blx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sên sinabi nay abitu, napukatan mani tagasunul nay sabay si Juan ya Mamawtismuy pantukuyun na. ");
INSERT INTO blx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sên nag-udung silan Jesus sa binyanan malakêy tawu, dilag gisay liyaki ya nagdani kana buy nanduku sa arapan na. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Panginuun, malunus ka sa anak kuy liyaki. Dilag yan sakit ta tinugaw buy nu latngan ya, sadyay sakit matanam na. Kabay magkamitugaw ya sa apuy buy pawa ya êt manabu sa lanêm. ");
INSERT INTO blx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gintan kuya sa mani tagasunul mu, nuwa a laya mapaiyul.” ");
INSERT INTO blx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nakitbay si Jesus, “Sikaw wa layin ayin panampalataya buy natukawkaw wa isip! Anggan makanu kataw pun pibabatan? Gêtan yu baydi ya anak!” ");
INSERT INTO blx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tinubag buy impatas Jesus ya nadawak ka ispiritu buy nag-awas ya sa anak. Buy sa uras êt abitu, inumiyul la anak. ");
INSERT INTO blx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sên kakapad la tana, nagdani kan Jesus ya mani tagasunul na buy namatang, “Uysiyan a yan ya naipatas ya nadawak ka ispiritu ta?” ");
INSERT INTO blx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nakitbay si Jesus, “Gawan kay nabêlêng nga panampalataya yu! Pansabin ku kamuyuy nu dilag kaw panampalatayay kasin bêlêng but-un mustasa, malyari yun sabin sa bung-uy ati, ‘Milaku ka du,’ buy milaku yabay. Ayin bagay ya a yu madyag. ");
INSERT INTO blx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nuwa ya parabayduy kalasin nadawak ka ispiritu, kay maipatas ya sa kapamilatan panalangin buy pag-ayunu.” ");
INSERT INTO blx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sên nititipun si Jesus buy mani tagasunul na, sinabi na kalla, “Sikuy ubat sa langit ta in-Anak Tawu, igawang ngaku sa mani nipagtungkulan ");
INSERT INTO blx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","buy patin laku. Nuwa sa ikatluy allu, manguman nakun mabyay.” Sên nalêngên mani tagasunul nay abitu, nalungkut sila. ");
INSERT INTO blx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pamakalatêng la sa balayan Capernaum, nagdani kan Pedroy mani maningil buwis para sa Templu buy namatang, “Mamayad nayin buwis ya Manuru yu para sa Templu?” ");
INSERT INTO blx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nakitbay si Pedro, “Awu, mamayad ya.” Sên nag-udung si Pedro sa bali ya tutugêlan la, pinatang yan Jesus, “Para kamuy Pedro, sisabêt ta mamayad buwis sa mani ari? Ya mani anak la o ya mani dayuwan?” ");
INSERT INTO blx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nakitbay si Pedro, “Ya mani dayuwan.” Sinabin Jesus, “Nu parabaydu, ya labay mun sabin, a yina kaylangan mamayad buwis ya mani anak. ");
INSERT INTO blx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nuwa nu a kitamu mamayad buwis, dat kasakitan na kitan nakêm. Kabay maku ka sa lawa buy mamadwas. Ya muna mun makway kêna, ibinganga muy bêbêy na. Buy makitan mu bayduy peray nukad tan pamayad buwis. Kêwên muy abitu ta ibayad ta sa mani maningil buwis.” ");
INSERT INTO blx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sa uras abitu, nagdani kan Jesus ya mani tagasunul na buy namatang, “Sisabêt ta pinakadakila sa pag-arian Bapan Namalyari?” ");
INSERT INTO blx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Binêg Jesus ya gisay anak ka nabêlêng buy impaidêng sa arapan la. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Pansabin ku kamuyuy nu a kaw magbayu buy mambus sa ugalin nabêlêng nga anak ya mapagpayêpa, a kaw miawyun sa mani tawuy pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kabay nu sisabêt man na magpakayêpa kaparisun anak ka ati, sabay ya pinakadakila sa pag-arian Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Buy nu sisabêt man na mananggap sa anak ka ati gawan sa panunul na kangku, sikinay pantanggapên na.” ");
INSERT INTO blx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nuwa nu sisabêt man na magin sangkan pangasalanan nangabêlêng nga anak ya manampalataya kangku, mangêd pun na is-êl la bêng na sa maragul la panggilingan na batu buy isamwag sa bunak dagat.” ");
INSERT INTO blx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kapalunus ya mani tawu baydi sa babun luta gawan sa mani tuksuy sangkan pangasalanan. Pêtêg yabay lumatêng nga abiin, nuwa kapalunus ya malyari sa tawuy pangubatan kasalanan kaparisu na.” ");
INSERT INTO blx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kabay nu ya gamêt mu o bitis mu ya magin sangkan pangasalanan mu, putusun mu buy isamwag. Mangêd pun ya maku ka sa langit ya gigisay bitis buy gigisay gamêt mu kaysa luway bitis buy luway gamêt muy isamwag sa apuy ya asê mangapalêng. ");
INSERT INTO blx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Buy nu gisay mata muy magin sangkan pangasalanan mu, lus-ukun mu buy isamwag! Mas mangêd pun na maku ka sa langit ta gigisay mata kaysa luwa yabay ya mata mu, nuwa isamwag kay naman sa impernu.” ");
INSERT INTO blx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Illagan yun agana yu êlêwên nayêpay agyan gisa man sa nangabêlêng nga anak. Pansabin ku kamuyu ya mani ang-el ya magbantay kalla, pawan idi sa arapan Bapa kuy idi sa langit. ");
INSERT INTO blx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tagawan sikuy ubat sa langit ta in-Anak Tawu, naku waku baydi sa babun luta amên iligtas ya mani nangalilitêp.” ");
INSERT INTO blx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Sabêt sa pangêlêw yuy daygên gisay tawuy dilag dinalan na tupa nu nalitêp pa gisa? Alwa nayin lakwanan na pun na siyam mapu buy siyam ma tupa baydu sa bung-uy ya pagpastulan na, ta têkapên nay gisay nalitêp? ");
INSERT INTO blx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pansabin ku kamuyuy nu makitan nay tupay nalitêp, matula-tula ya kaysa siyam mapu buy siyam ma asê nalitêp. ");
INSERT INTO blx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Para êt baysên na matanam Bapa yuy idi sa langit, ta a na labay malitêp agyan gisa man sa nabêlêng nga anak.” ");
INSERT INTO blx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nu mangasalanan kamuy patêl mu sa panampalataya, lakwên muya buy misabi kaw kay kakapad yu. Ipalinaw mu kanay kasalanan na dinyag na. Nu mallêngê ya kamu, miudung ya sa mana yun pamibêbêtêk bilang mipapatêl sa panampalataya. ");
INSERT INTO blx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nuwa nu a yapun mallêngê kamu, mipikilaku kan gisa o luwa pun na patêl sa panampalataya amên ‘ya kaganawan napisabyan yu, mapagpapêtgan luwa o tatluy nakakit.’ ");
INSERT INTO blx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nu a ya mallêngê kalla, ipatanday ati sa mani manampalatayay miaawyun. Buy nu a yapun kalabay mallêngê kalla, ituwad yuyan gisay tawuy asê mangilala kan Bapan Namalyari o gisay maningil buwis.” ");
INSERT INTO blx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Pansabin ku kamuyuy nu sabêt man na ibawal yu baydi sa babun luta, ibawal êt sa langit, buy nu sabêt man na tulutan yu baydi sa babun luta, tulutan êt sa langit.” ");
INSERT INTO blx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Pansabin ku kamuyuy nu dilag luwa kamuyuy nikasundu sa sabêt man baydi sa babun luta sa panalangin yu, idin Bapa kuy idi sa langit ta panyawarên yu. ");
INSERT INTO blx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tagawan nu saantu dilag luwa o tatluy nititipun gawan kangku, idi yaku baydu kalla.” ");
INSERT INTO blx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Amêsên, nagdani si Pedro kan Jesus buy namatang, “Panginuun, katiumnu kun patawarên na patêl kuy pawan manyag kasalanan kangku? Makatapitu nayi?” ");
INSERT INTO blx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nakitbay si Jesus, “Alwan kay makatapitu nun a pitumpu buy pitu. ");
INSERT INTO blx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tagawan ya pag-arin Bapan Namalyari, maiparisu sa pag-arin gisay ari ya impabêg nay mani ipus na amên singilin na sila sa mani utang la. ");
INSERT INTO blx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sên umpisên naynay paningil na, gintan kanay gisay ipus ya nakautang kanan milyun-milyun. ");
INSERT INTO blx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gawan a ya makabayad, sinabin ari, ‘Isaliw yu silan mipapamilya buy kaganawan pibandiyan na amên mabayaran nay utang na.’ ” ");
INSERT INTO blx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kabay nakilunuslunus buy nandukuy ipus sa ari, ‘Ari kuway, biyan muku pun kayêk panawun amên mabayaran kuy kaganawan nautang ku.’ ");
INSERT INTO blx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kinalunusan yan ari. Kabay a nayna impabayad da mani utang na buy impauli ya.” ");
INSERT INTO blx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nuwa pamakabitan ipus, natbêng nay gisay kaparisu nan ipus ya nakautang pêrad kana. Dinagus buy ginêyêk naya. Sinabi na, ‘Bayaran muy utang mu kangku!’ ” ");
INSERT INTO blx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Nanduku kanay kaparisu nan ipus buy nakilunuslunus, ‘Biyan muku pun kayêk panawun amên mabayaran kuy kaganawan nautang ku kamu.’ ");
INSERT INTO blx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nuwa a ya nakalabay, nun a impasukul nay kaparisu nan ipus anggan asê pun makabayad.” ");
INSERT INTO blx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Sên nakitan kaatag ipus ya dinyag na, nalungkut sila. Kabay naku sila sa ari amên ipatanda lay kaganawan nalyari.” ");
INSERT INTO blx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Impabêg amêsên ari ya ipus buy sinabi kana, ‘Sikay nadawak ka ipus! A ku impabayad da nautang mu gawan nakilunuslunus ka kangku. ");
INSERT INTO blx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Siyan a ka ya nalunus sa kaparisu mun ipus kaparisun pallunus ku kamu ta?’ ");
INSERT INTO blx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gawan sa sadyay tubag ari, impasukul nay ipus anggan a na pun mabayaran na kaganawan nautang na.” ");
INSERT INTO blx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sinabi pun Jesus, “Para êt baysên na daygên Bapa kuy idi sa langit, nu alwan buun bêkê ya pamatawad yu sa kaparisu yu.” ");
INSERT INTO blx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pamakayarin in-aral Jesus ya mani bagay ya abiin, namita ya sa prubinsyan Galilea buy naku ya sa sakup prubinsyan Judea sa lipay Ilug Jordan. ");
INSERT INTO blx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Malakêy tawuy nanunul kana buy pinaiyul nay nipagsakit. ");
INSERT INTO blx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dilag dakun umnuy Pariseoy nagdani kan Jesus amên subukan ya. Kabay namatang sila, “Pantulutan nayin Kautusan na isyay liyaki ya asawa na agyan sa sabêt ta sangkan?” ");
INSERT INTO blx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nakitbay si Jesus, “A yu nayi nabasa sa Kasulatan ya sa umpisa pun, sabitun dinyag Bapan Namalyari ya babun luta, dinyag nay liyaki buy babayi? ");
INSERT INTO blx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Buy sinabi na, ‘Gawan di, lakwanan liyaki ya bapa buy indu na amên miawyun silan miasawa. Buy ya luwa, pakadyag gigisa.’ ");
INSERT INTO blx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sa pakapakun baydu, alwa silaynan luwa, nun a gigisa silayna. Kabay ya piniawyun Bapan Namalyari, asê sêpat pisyayên tawu.” ");
INSERT INTO blx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nanguman namatang nga mani Pariseo, “Nu parabaydu awêd, uysiyan sinabin Moises ya malyarin isyay liyaki ya asawa na nu biyan nayan kasulatan pamisyay ta?” ");
INSERT INTO blx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nakitbay si Jesus kalla, “Gawan sa kakdêyan ulu yu, tinulutan Moises ya isyay liyaki ya asawa na. Nuwa paubat pun sabitun nuna, alwan abiin na kalabayan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kabay pansabin ku kamuyu ya nu isyay liyaki ya asawa na buy mag-asawa yan kaatag, mangasalanan yan pamikikanayun, liban nu nakikanayun ya asawa na. Buy nu sisabêt man na nakapag-asawa sa babayi ya in-isyay liyaki, nangasalanan yan pamikikanayun.” ");
INSERT INTO blx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Sinabin mani tagasunul Jesus, “Nu parabaysên na kabilyan liyaki sa asawa na, mangêd da agana yina mag-asawa.” ");
INSERT INTO blx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nakitbay si Jesus, “Ya aral la abiin, asê agyun tanggapên kaganawan tawu, kay ya mani tawuy in-il-an Bapan Namalyarin asê mag-asawa. ");
INSERT INTO blx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dilag kaatag sangkan ya siyan asê nag-asaway dakun umnuy tawu. Dilag mani tawuy in-anak kan asê makaanak. Dilag êt tinaganan kinapun, buy dilag asê nag-asawa gawan sa paglingkud la sa pag-arin Bapan Namalyari. Ya tawuy agyun tanggapên ya aral ya abiin, sêpat nan daygên.” ");
INSERT INTO blx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dilag mani tawuy nilakun nangabêlêng nga anak kan Jesus amên yawarên lan ipaluntuy gamêt na kalla buy manalangin para kalla. Nuwa binênbênan silan mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sinabin Jesus sa mani tagasunul na, “Paulayan yun magdani kangkuy mani anak. Agana yu sila bênbênan, tagawan ya mani kaparisu la sabay ya miawyun sa mani tawuy pag-arian Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Impaluntun Jesus ya gamêt na sa mani anak buy pinagpala na sila. Pamakayari, namitay na. ");
INSERT INTO blx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Amêsên, dilag gisay liyaki ya nagdani kan Jesus buy namatang, “Manuru, sabêt ta mangêd kun daygên amên mabiyan nakun biyay ya ayin katganan?” ");
INSERT INTO blx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nakitbay si Jesus, “Uysiyan patangên muya kangku nu sabêt ta mangêd ta? Gigisay mangêd buy ayin nan kaatag nun a kay si Bapan Namalyari. Nu labay mun mabiyan kan biyay ya ayin katganan, sunulun muy mani utus.” ");
INSERT INTO blx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kabay namatang nga liyaki, “Sabêt sa mani utus ya abiin na sunulun ku?” Nakitbay si Jesus, “Agana ka mamatin tawu, agana ka makikanayun, agana ka manakaw, agana ka êt magpapêtêg sa alwan kapêtêgan, ");
INSERT INTO blx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","galangên muy mangatwa mu, buy kaidwan muy kaparisu mun tawu kaparisun pangidu mu sa sarili mu.” ");
INSERT INTO blx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sinabin liyaki, “Sinunul kinay kaganawan abiin. Sabêt pun na kaylangan kun daygên?” ");
INSERT INTO blx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nakitbay si Jesus, “Nu labay mun magin ganap, isaliw muy mani pibandiyan mu. Buy ya naabli mu, idin mu sa mani kalulu. Sa pakapakun baydu, dilag kan pibandiyan sa langit. Pamakayari, mag-udung ka buy manunul kangku.” ");
INSERT INTO blx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nuwa sên nalêngên liyaki ya abitu, namita yan malungkut, gawan malakêy pibandiyan na. ");
INSERT INTO blx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kabay sinabin Jesus sa mani tagasunul na, “Pansabin ku kamuyu, ya tawuy malakêy pibandiyan, masakit magpasakup sa pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Misun pun na kamelyu sa lubut karayum, kaysa misun sa kaarian Bapan Namalyari ya gisay tawuy mabandi.” ");
INSERT INTO blx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sên nalêngên mani tagasunul nay abiin, nakatêgag sila. Kabay namatang sila, “Nu parabaydu, sisabêt awêd da miligtas?” ");
INSERT INTO blx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nangêlêw si Jesus kalla buy sinabi na, “Asê madyag tawuy abiin, nuwa si Bapan Namalyari, madyag nay kaganawan.” ");
INSERT INTO blx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nagsabi si Pedro, “Parasaantu kay yaman? Inlakwanan yan na kaganawan amên manunul kamu. Sabêt ta nabang yan?” ");
INSERT INTO blx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nakitbay si Jesus, “Pansabin ku kamuyuy lumatêng lanuy alluy ibayun Bapan Namalyari ya babun luta. Buy sikuy ubat sa langit ta in-Anak Tawu, miknu waku sa dakilay turonu ku ya mag-ari. Buy sikaw wa mani tagasunul kuy miknu êt sa mapu buy luway turonu amên mangukum sa mapu buy luway layin Israel. ");
INSERT INTO blx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Buy ya kaganawan nallakwan bali, nallakwan mapatêl, nallakwan mangatwa, nallakwan maanak, o nallakwan mani luta gawan sa panunul na kangku, mananggap yan dinalan pun êt sa inlakwanan na buy mabiyan yan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Malakêy mapagmatag-ay amêsên na iyêpa lanu. Buy malakêy mapagpayêpa amêsên na itag-ay lanu.” ");
INSERT INTO blx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sinabi pun Jesus, “Ya daygên Bapan Namalyari sa pag-ari na, maiparisu sa dinyag gisay magbandin ubasan. Gisay allu, maranundanun nag-awas ya magbandin ubasan amên mangkap mani mag-ubra sa ubasan na. ");
INSERT INTO blx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sên nakakit yan mani tawuy paubrên na, nakikasundu ya kallan upan na silan nukad da upa sa gisay allu. Pamakayari, impalaku na sila sa ubasan na. ");
INSERT INTO blx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sên alas nuwebi yanan maranun, nag-awas sina êt buy nakakit tina êt mani tawuy ayin ubra, kay nagtukawan sa palengki.” ");
INSERT INTO blx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Sinabi na kalla, ‘Maku kaw sa ubasan ku buy mag-ubra. Nukad da iupa ku kamuyu.’ Kabay naku sila sa ubasan. ");
INSERT INTO blx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sên ugtuy na, nanguman nina êt nag-awas buy nakakit tina êt kaatag tawuy pinaubra na. Sên alas tres san kaawat, paray na êt bayduy dinyag na.” ");
INSERT INTO blx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Sên alas singkuy nan kaawat, nanguman nina êt nag-awas buy nakakit tina êt dakun umnuy nagtukawan. Sinabi na kallay, ‘Uysiyan kay mamapatingapun kaw yan nagtukawan ayin pandaygên ta?’ ” ");
INSERT INTO blx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Nakitbay sila kana, ‘Gawan ayin yabay mamaubra kanyan.’ ” “Sinabi na kallay, ‘Maku kawna sa ubasan ku amên mag-ubra.’ ” ");
INSERT INTO blx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Sên magdêm mana, sinabin magbandi sa katiwala na, ‘Bêgên muy mani mag-ubra ta upan mu silayna. Unên muy nipaubatan nag-ubra, angga sa mani nunan nag-ubra.’ ");
INSERT INTO blx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Inlumatêng ngay pinaubra nan alas singkun kaawat buy nananggap silan nukad da upa sa gisay allun pag-ubra.” ");
INSERT INTO blx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sên inlumatêng ngay mani nunan pinaubra na, indap lay mananggap silan igit pun kaysa nipaubatan na pinaubra, pakan asê, ta kay parisu êt ta inupa kalla. ");
INSERT INTO blx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sên natanggap lay nay upa la, nagdeklamu sila sa magbandin ubasan. ");
INSERT INTO blx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Sinabi la, “Te, siyan kay parisu yay upa yan ta! Pakan kay nipaubatan silan inlumatêng buy kay gigisay uras ya pinag-ubra la. Pakan sikay yaman, nibabata kay sa naumut-umut ta mamut buy nag-ubran mamapatingapun.” ");
INSERT INTO blx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Pikitbayan magbandi ya gisa kalla, ‘Patêl lay, a kata pinurayit. Alwa nayin nikasundu kitaynan biyan katan upa sa gisay allun pag-ubra mu? ");
INSERT INTO blx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kabay kêwên minay upa mu buy muli kayna. Idi ya kangku nu biyan kun kaparisun upa yuy mani nipaubatan nag-ubra. ");
INSERT INTO blx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Alwa nayin dilag gakun karapatan daygên na labay ku sa pera ku? O kay kasêman yuku gawan mangêd daku kalla?’ ” ");
INSERT INTO blx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pamakayari, sinabin Jesus, “Para êt baysên na malyari sa tawlin allu. Ya mani mapagpayêpa amêsên, mitag-ay buy ya mani mapagmatag-ay amêsên, miyêpa sila.” ");
INSERT INTO blx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kaban mamita silan Jesus patuksaw sa Jerusalem, impapawa nay mapu buy luway tagasunul na sa mani tawu. Sinabi na kalla, ");
INSERT INTO blx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Elêwên yu! Tumuksaw kitamina sa Jerusalem. Buy sikuy ubat sa langit ta in-Anak Tawu, igawang ngaku sa mani mamunun pari buy mani manurun Kautusan. Atulan lakun kamatyan ");
INSERT INTO blx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","buy igawang sa mani alwan Judio amên pustakên, latikun buy ipaku sa kurus. Nuwa sa ikatluy allu, manguman nakun mabyay.” ");
INSERT INTO blx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nagdani kan Jesus ya asawan Zebedeo, kaawyun nay luway anak nay liyaki. Nanduku ya sa arapan Jesus. Sinabi na, “Manuru, dilag gaku dayin labay yawarên kamu.” ");
INSERT INTO blx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pinatang yan Jesus, “Sabêt ta labay mu?” Nakitbay ya, “Nu mag-ari kayna, ipangaku mu dayi ya paiknun muy luway anak ku sa dani mu, ya gisa sa wanan mu buy ya gisa sa udi mu.” ");
INSERT INTO blx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nuwa pikitbayan silan Jesus, “A yu tanda nu sabêt ta panyawarên yu. Mapibabatan yu nayi ya pamasakit ta danasên ku?” Nakitbay sila, “Awu, mapibabatan yan.” ");
INSERT INTO blx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sinabin Jesus kalla, “Awu, pêtêg madanasan yuy abiin. Nuwa alwan sikuy mamili nu sisabêt ta miknu sa wanan ku o sa udi ku, ta ya iknuwan abitu, kay para sa mani pinil-anan Bapa ku.” ");
INSERT INTO blx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sên natandan mapuy tagasunul na nu sabêt ta inyawad mipatêl, nanubag sila kalla. ");
INSERT INTO blx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kabay impadani silan Jesus buy sinabi na kallay, “Tanda yuy mani manungkulan ya alwan Judio, pan-ipilit lay labay la sa mani pansakupun la buy agyan sabêt ta labay la, pansunulun mani pansakupun la. ");
INSERT INTO blx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nuwa alwan parabaysên na labay kun daygên yu, nun a nu sisabêt man kamuyuy kalabay magin dakila, kaylangan magin lingkud yu. ");
INSERT INTO blx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Buy nu sisabêt man kamuyuy kalabay magin mamunu, sêpat yan magin ipus yu. ");
INSERT INTO blx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Abiin na pandaygên ku ta agyan sikuy ubat sa langit ta in-Anak Tawu, naku waku baydi amên maglingkud buy idin kuy biyay ku amên atbusun na malakêy tawu. A ku naku baydi amên paglingkuran mani tawu!” ");
INSERT INTO blx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sên pabitay na sa balayan Jerico si Jesus buy mani tagasunul na, pikilakwan silan malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Amêsên, dilag luway bulag bayduy nakaiknu sa agid dan. Sên nalêngê lay mallumibas si Jesus, masnêg lan sinabi, “Panginuun, layin Arin David, kalunusan mukay kayêk!” ");
INSERT INTO blx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nuwa binênbênan silan mani tawu, “Agana kaw mantarit!” Nuwa ingkakadus la pun insabin masnêg, “Panginuun, layin Arin David, kalunusan mukay kayêk!” ");
INSERT INTO blx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tinunggên si Jesus, binêg na sila buy pinatang, “Sabêt ta labay yun daygên ku kamuyu?” ");
INSERT INTO blx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nakitbay sila, “Panginuun, kalabay kay makakit.” ");
INSERT INTO blx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nalunus si Jesus kalla. Kabay dinukpan nay mata la. Tambêng silan nakakit buy nanunul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sên narani yana silan Jesus sa Jerusalem, tinunggên sila sa Bung-uy mani Ulibu ya narani sa balayan Bethfage. Impaunan Jesus ya luway tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Sinabi na, “Maku kaw sa kasunul la baryu. Makitan yu bayduy mitainduy asnuy nakas-êl. Agwatên yu buy iakay yu baydi kangku. ");
INSERT INTO blx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu dilag mamatang kamuyun paradi, ‘Uysiyan pan-agwatên yu yay asnu ta,’ sabin yu kanay, ‘Kaylangan Panginuun’, buy tulutan nakaw na.” ");
INSERT INTO blx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nalyari ya abiin amên matupad da sinabin Propeta awlagi, ");
INSERT INTO blx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sabin yu sa mani idi sa balayan Zion, ‘Elêwên yu! Palatêng ngay ari yu. Mapagpayêpa ya buy ya pagsakayan na, biserun asnu.’ ” ");
INSERT INTO blx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kabay namita yabay ya mani tagasunul na buy sinunul lay in-utus Jesus kalla. ");
INSERT INTO blx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kabay in-akay lay nay mitainduy asnu kan Jesus, inlatêp lay balabal la sa bukut biserun asnu buy nagsakay ya. ");
INSERT INTO blx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Malakêy tawuy namimakmak balabal la sa dan. Buy ya kaatag êt, nallapak silan mani palapa buy in-makmak la sa dan. ");
INSERT INTO blx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ya mani tawuy idi sa mumunan Jesus buy idi sa ubatan, mansaway silan magsabin, “Ulimênên na Layin Arin David! Pagpalên Bapan Namalyari ya mallumatêng sa lagyu na. Ulimênên na Bapan Namalyari ya idi sa langit!” ");
INSERT INTO blx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sên nilatêng nga si Jesus sa Jerusalem, naguluy kaganawan tawu sa balayan. Nipapatang sila, “Sisabêt ta tawun abiin?” ");
INSERT INTO blx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nakitbay ya mani kaawyun Jesus, “Sabay siya si Jesus ya propetay taga Nazaret sa prubinsyan Galilea.” ");
INSERT INTO blx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Naku si Jesus sa kasawangan Templun Bapan Namalyari buy impatas nay mani magtinda buy mani manaliw baydu. Imbabaliswag nay mani lamesan mallibay peran dayuwan sa peran mani Judio buy iknuwan mani magtindan pati-pati ya pan-iandug kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sinabi na kalla, “Nakasulat sa Sabin Bapan Namalyari, ‘Ya bali ku, pambêgên balin panalanginan.’ Nuwa siyan dinyag yun pagtagwan mani manakaw!” ");
INSERT INTO blx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kaban idi sa Templu si Jesus, dilag mani bulag buy nipagpilay ya nagdani kana buy pinaiyul na sila. ");
INSERT INTO blx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nuwa nanubag ga mani mamunun pari buy mani manurun Kautusan gawan nakitan lay mani mamakaupapas ya dinyag Jesus. Buy nanubag sila êt sên nalêngê lay mani anak ka idi sa Templuy masnêg magsabin, “Ulimênên na Layin Arin David!” ");
INSERT INTO blx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kabay sinabi la kan Jesus, “Malêngê mu nayi ya pansabin la?” Nakitbay si Jesus, “Awu, nalêngê ku, nuwa a yu nayi nabasay sinabi sa kasulatan ya, ‘Agyan kay nabêlêng nga anak tinurwanan Bapan Namalyarin mangulimên kana’?” ");
INSERT INTO blx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pamakayari, inlakwanan silaynan Jesus buy naku ya sa balayan Bethania, ta baydu yan mamawatwat. ");
INSERT INTO blx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pamakawatwat, sên paudung nga silan Jesus sa balayan Jerusalem, nalayangan na. ");
INSERT INTO blx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dilag yan nakitan na puun kayun igus sa danin dan. Kabay inlaku nan inêlêw wa ati nu nagtagêy. Nuwa ayin, nun a kay pawan bulung. Kabay sinabi na sa kayu, “Kanuman, a kayna managêy manguman!” Buy tambêng nayanguy kayu. ");
INSERT INTO blx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sên nakitan mani tagasunul Jesus ya nalyari, nakaupapas sila. Sinabi la, “Aw indi, parasaantun tambêng nayanguy kayun igus?” ");
INSERT INTO blx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nakitbay si Jesus, “Pansabin ku kamuyuy nu dilag kaw panampalataya buy asê magmikakunuy nakêm, madyag yu êt ta dinyag ku sa puun kayun igus. Buy alwa pun êt kay abiin, malyari yu êt sabin sa bung-uy ya, ‘Mitas ka buy milaku ka sa dagat’ buy madyag yabay! ");
INSERT INTO blx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Agyan sabêt man na yawarên yu kan Bapan Namalyari sa panalangin, nu maniwala kaw wa idin na kamuyu, pilmin matanggap yu.” ");
INSERT INTO blx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nag-udung si Jesus sa Templu. Kaban mangaral ya sa kasawangan Templu, nagdani kanay mani mamunun pari buy mani mangatway manungkulan. Namatang sila kana, “Sabêt ta karapatan mun manyag abiin na dinyag mu? Sisabêt ta nam-i kamun parabaysên na karapatan?” ");
INSERT INTO blx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pikitbayan silan Jesus, “Patangên kataw êt. Nu mapakitbayan yuku, sabin ku êt kamuyu nu sisabêt ta nam-i kangkun karapatan manyag paradi. ");
INSERT INTO blx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ati ya patang ku kamuyu. Kansabêt ubat ta karapatan Juan ya mamawtismu, kan Bapan Namalyari o sa tawu?” Kabay nisasabi sila, “Nu sabin tamuy ‘kan Bapan Namalyari’, sabin nay naman êt kantamuy, ‘Uysiyan a kaw yabay maniwala kan Juan ta?’ ");
INSERT INTO blx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nuwa nu sabin tamuy ‘sa tawu’, manubag ga mani tawu kantamu, gawan maniwala silan propetan Bapan Namalyari si Juan.” ");
INSERT INTO blx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kabay nakitbay sila kan Jesus, “A yan tanda.” Sinabin Jesus kalla, “Nu parabaydu, a ku êt sabin kamuyu nu sisabêt ta nam-i kangkun karapatan manyag ati.” ");
INSERT INTO blx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sinabi pun êt Jesus kalla, “Para kamuyu, sabêt ta labay sabin paalimbawan ati? Dilag gisay tawuy nag-anak luway liyaki. Nagdani ya sa panganay buy sinabi na, ‘Anak ku, maku ka amêsên sa ubasan tamu ta mag-ubra ka.’ ");
INSERT INTO blx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kabay nakitbay ya, ‘A ku kalabay.’ Nuwa asê nabuyut, nagbayuy isip na buy nakuy na baydu. ");
INSERT INTO blx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nagdani êt ta bapa la sa bungsu buy sinabi na, ‘Anak ku, maku ka amêsên sa ubasan tamu ta mag-ubra ka.’ ” “Nakitbay ya bungsu, ‘Awuy Bapa,’ pakan a yinaman naku.” ");
INSERT INTO blx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Amêsên, pinatang Jesus ya mani mamunun pari buy mani mangatwan manungkulan. Sinabi na, “Para kamuyu, sisabêt sa luway nanunul sa kalabayan bapa la?” Nakitbay sila, “Abituy panganay.” Kabay sinabin Jesus kalla, “Pansabin ku kamuyuy si pan-ituwad yun nadawak kaparisun mani maningil buwis buy mani babayi ya pambayaran, muna sila pun kamuyun miawyun sa mani pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tagawan inlumatêng kamuyu si Juan ya Mamawtismu buy in-aral na kamuyu nu parasaantu kaw bumyay matinêk sa arapan Bapan Namalyari, nuwa a yuya pinaniwalan. Pakan ya mani maningil buwis buy mani babayi ya pambayaran, naniwala silayna man. Nakitan yinay ati, nuwa a kaw pun êt nagsisi buy nagpabukut sa mani kasalanan yu, buy a kaw pun êt naniwala kana.” ");
INSERT INTO blx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sinabi pun Jesus, “Pakalêng-ên yuy gisa pun êt ta paalimbawa. Dilag gisay tawuy nananêm ubas sa panggitnan na. Pamakayari nan nananêm, impabakud nay abitu buy namipadyag yan pamêspêsan ubas. Namipaydêng ya êt gisay matag-ay ya bali ya bibiyan mamantay. Pamakayarin abitu, impasamak nay ubasan na sa mani makisamak ta naku ya sa marayuy lugal. ");
INSERT INTO blx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sên panawun nan pamupul ubas, in-utus nay mani ipus na sa mani kasamak na amên kêwên na dakay na. ");
INSERT INTO blx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nuwa sên nakitan mani kasamak nay mani ipus, dinagus sila. Ya gisa, dinugêdugê la, buy ya ikalwa, pinati la, buy ya ikatlu, binatwan la angga sa nati. ");
INSERT INTO blx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Niutus manguman na magbandin mas malakêy ipus kaysa sabitun nuna, nuwa para êt bayduy dinyag mani kasamak na. ");
INSERT INTO blx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sa katatawliyan, in-utus magbandi ya anak na, ta sinabi na sa nakêm nay, ‘Pilmin galangên lay anak ku.’ ");
INSERT INTO blx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nuwa sên nakitan mani kasamak ya anak magbandi, nisasabi sila, ‘Ah! Ati yay tagapagmana! Kaksaw kaw, patin tamu ya amên mapagbandi tamuy mapagmana na.’ ");
INSERT INTO blx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kabay sên inlumatêng ngay anak, dinagus laya, ginuluy laya sa lawasan ubasan buy pinati.” ");
INSERT INTO blx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pamakayari, namatang si Jesus kalla, “Sa pag-udung magbandi, sabêt ta daygên na sa mani kasamak na?” ");
INSERT INTO blx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nakitbay ya mani mamunun pari buy mani mangatwan manungkulan, “Pilmin upudun nay mani nadawak ka kasamak na buy ipasamak natay ubasan na sa kaatag makisamak ya mam-in dakay na sa balang panawun pamipupul.” ");
INSERT INTO blx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sinabin Jesus kalla, “A yu nayi nabasay ati sa Kasulatan, ‘Ya batuy insakwil mani mamipaydêng bali, sabay ya batuy nagin pundasyun. Abiin na dinyag Bapan Namalyari ya mamakaupapas kantamu.’ ” ");
INSERT INTO blx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kabay pakalêngê kaw. Alwaynan sikaw wa pag-arian Bapan Namalyari, nun a ya mani tawuy manunul sa kalabayan na. ");
INSERT INTO blx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sisabêt man na manabu sa batun ati, mangatutunglu. Nuwa ya manabwanan ati, mangayayapung.” ");
INSERT INTO blx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sên nalêngên mani mamunun pari buy mani Pariseoy abituy paalimbawan Jesus, napukatan lay sabay sila awêd da pantukuyun na. ");
INSERT INTO blx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kabay dakpên layna dayi si Jesus, nuwa nalimu sila sa mani tawu, ta maniwala silan propeta si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nanguman nagsabi si Jesus kalla sa kapamilatan paalimbawa. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ya pag-arin Bapan Namalyari, maiparisu sa dinyag gisay ari ya nil-an kalutu sa tangên anak nay liyaki. ");
INSERT INTO blx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","In-utus nay mani ipus na amên bêgên ya mani insagyat na sa kalutu, nuwa a sila kalabay maku.” ");
INSERT INTO blx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kabay niutus yan kaatag ipus amên sabin sa mani insagyat nay paradi, ‘Maku kawna ta nakal-an nay kaganawan buy nakaapag gay kanên. Pinati yay mani baka buy kaatag êt ta mangatabay saysay.’ ");
INSERT INTO blx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nuwa a la dinambi ya nisagyat kalla. Ya gisa, naku sa panggitnan, buy ya gisa, sa ligosyu na. ");
INSERT INTO blx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ya kaatag gaman, dinagus lay mani ipus ari, impakadêng-êy buy pinati.” ");
INSERT INTO blx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Kabay gawan sa dinyag la, napatubag lay ari. Kabay niutus yan mani sundalus na amên patin na namatin mani ipus na buy impaulam nay balayan la.” ");
INSERT INTO blx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Pamakayari, sinabin ari sa mani kaatag ipus na, ‘Nakal-an nay pamiêêman sa tangên anak ku, nuwa asê sêpat mangan na mani insagyat ku. ");
INSERT INTO blx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kabay maku kaw sa mani dan buy sagyatên yuy kaganawan makitan yu.’ ");
INSERT INTO blx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nakuy nabay sa mani dan buy insagyat lay kaganawan tawuy nakitan la, nadawak man o mangêd. Kabay napnun bisitay pamidausan kalutu.” ");
INSERT INTO blx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sinumun na ari amên êlêwên na mani bisita. Nakitan nay gisay liyaki ya bisitay asê nakayaming para sa tangên. ");
INSERT INTO blx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kabay pinatang naya, ‘Kaluguran, uysiyan sinumun kayan asê nakayaming para sa tangên ta?’ Asê nakatarit ta liyaki.” ");
INSERT INTO blx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kabay sinabin ari sa mani ipus na, ‘Sêl-an yuy gamêt buy bitis na ta isamwag yuya sa kadlêman, baydu sa lawasan. Manangis ya baydun mingêngêt ta bêbêy na.’ ” ");
INSERT INTO blx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pamakayari, sinabin Jesus, “Ati ya labay sabin paalimbawa. Malakêy pansagyatên Bapan Namalyari ya miawyun sa pag-arian na, nuwa pêpêrad da pinili na.” ");
INSERT INTO blx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Amêsên, namitay mani Pariseo amên misasabi sila nu parasaantu lan maipadakêp si Jesus sa pagsabi na. ");
INSERT INTO blx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kabay in-utus la kan Jesus ya dakun umnuy tagasunul la buy dakun umnuy tawun Gobernador Herodes Antipas. Sinabi la, “Manuru, tanda yan na pêtêg ga pansabin mu. Pan-ituru muy kapêtêgan tungkul sa kalabayan Bapan Namalyari. Ayin kan pampilinin, gawan a ka mangêlêw sa kabilyan gisay tawu. ");
INSERT INTO blx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Amêsên, dilag kay ipatang kamu. Sêpat kitamu nayin mamayad buwis sa Emperador Roma o asê?” ");
INSERT INTO blx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nuwa tandan Jesus ya nadawak ka labay lan daygên. Kabay sinabi na, “Kay mapagtalingkayu kaw! Alwa ta labay yukun dakpên sa pagsabi ku ta? ");
INSERT INTO blx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Elêwên kuwati bay ya peray pamayad buwis.” Kabay inggawang lay pera kana. ");
INSERT INTO blx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pinatang silan Jesus, “Kansabêt lupa buy lagyuy makit yu di?” ");
INSERT INTO blx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nakitbay sila, “Sa Emperador.” Kabay sinabin Jesus kalla, “Nu parabaydu, idin yu sa Emperador ya para sa Emperador, buy idin yu kan Bapan Namalyari ya para kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sên nalêngê lay pikitbay Jesus, nakaupapas sila. Kabay namita sila tana. ");
INSERT INTO blx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Amêsên, dilag dakun umnuy Saduseoy nagdani kan Jesus amên patangên ya. Ya mani Saduseo, a sila maniwalan manguman mabyay ya mani nangamamati. ");
INSERT INTO blx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Amêsên, sinabi la kan Jesus. “Manuru, ayun sa Kautusan na impasulat kan Moises, ‘Nu ya gisay liyaki nati yan ayin anak sa asawa na, ya bayaw nay liyaki, sêpat nan pag-asaway bal-uy babayi amên makaanak sila para sa patêl nay nati.’ ");
INSERT INTO blx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Amêsên, dilag pituy mipapatêl la lawyaki baydi kanyan. Nakapag-asaway panganay, nuwa nati yan ayin anak. Kabay ya ikalway panganay pinag-asawa nay nabal-u, nuwa nati ya êt ayin anak. ");
INSERT INTO blx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Para êt bayduy nalyari sa ikatlu angga sa ikapituy patêl la. ");
INSERT INTO blx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sa katatawliyan, nati êt ta bal-u. ");
INSERT INTO blx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Amêsên, sa allun pangabyay manguman nangamamati, sisabêt ta asawan abituy babayi, gawan napag-asawa yan pituy mipapatêl?” ");
INSERT INTO blx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nakitbay si Jesus, “Taganan mali kaw, tagawan a yu mapukatan na Kasulatan Bapan Namalyari buy a yu mapukatan na kapangyarian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tagawan sa pangabyay manguman, ayin nan pag-asawa, ta magin kaparisu silaynan mani ang-el sa langit ya ayin asawa. ");
INSERT INTO blx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tungkul sa pangabyay manguman, a yu nayi nabasa sa Kasulatan na sinabin Bapan Namalyari kamuyu, ");
INSERT INTO blx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sikuy Bapan Namalyari lan Abraham, Isaac buy Jacob’? Ya labay sabin, nabyay sila, tagawan alwa yan Bapan Namalyarin nangamamati, nun a Bapan Namalyari yan nangabyay.” ");
INSERT INTO blx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sên nalêngên mani tawuy pangaral na, nakaupapas sila. ");
INSERT INTO blx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sên nabalitan mani Pariseoy asê nakatarit ta mani Saduseo kan Jesus, nititipun sila buy nagdani kana. ");
INSERT INTO blx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Gisa kallay manurun Kautusan ya namatang kan Jesus amên subukun ya, ");
INSERT INTO blx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Manuru, sabêt ta pinakamaulagay utus sa Kautusan?” ");
INSERT INTO blx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nakitbay si Jesus kana, “ ‘Kaidwan muy Panginuun mun Namalyari un buun bêkê, buun kaladwa buy buun isip.’ ");
INSERT INTO blx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Abiin ya pinakamaulagay utus sa kaganawan. ");
INSERT INTO blx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Buy para êt bayduy ikalwa, ‘Kaidwan muy kaparisu mun tawu kaparisun pangidu mu sa sarili mu.’ ");
INSERT INTO blx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ya kaganawan kautusan na impasulat kan Moises buy kaganawan insulat mani propeta, idi sa luway utus.” ");
INSERT INTO blx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kaban nititipun na mani Pariseo, namatang si Jesus kalla, ");
INSERT INTO blx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sabêt ta tanda yu tungkul sa Cristu ya impangakun Bapan Namalyari? Kansabêt layi ya pinangubatan na?” Nakitbay sila, “Layi yan Arin David.” ");
INSERT INTO blx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Amêsên, sinabin Jesus kalla, “Nu layi yan Arin David, uysiyan binêg yabay David ‘Panginuun’ ta? Sabitun idi kanay Ispiritun Bapan Namalyari, sinabi na, ");
INSERT INTO blx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Sinabin Bapan Namalyari sa Panginuun ku, “Miknu ka sa wanan ku angga sa mapasuku ku kamuy mani kapati mu.” ’ ");
INSERT INTO blx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nu binêg yan Arin David Panginuun, parasaantun masabin mani tawuy si Cristuy kay layi yan Arin David?” ");
INSERT INTO blx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ayin nakapakitbay gisa man sa pamatang Jesus. Ubat ta baydu, ayin nan nakadêgdêg mamatang kana. ");
INSERT INTO blx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pamakayari, sinabin Jesus sa mani tawu buy sa mani tagasunul na, ");
INSERT INTO blx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ya mani manurun Kautusan buy mani Pariseo sabay silay pangkilalanên mamiaral Kautusan na impasulat kan Moises. ");
INSERT INTO blx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kabay papakalêng-ên buy sunulun yuy kaganawan pan-iaral la kamuyu. Nuwa agana yu tubsun na pandaygên la, gawan a la pandaygên na pan-iaral la. ");
INSERT INTO blx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pan-ipatupad la kamuyuy mani utus ya indagdag lay masakit tuparên ya paran pan-ipabakay la kamuyuy mangabayat ta kalga, pakan a lakaw taganan sawpan sa pantan ati. ");
INSERT INTO blx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ya kaganawan pandaygên la, kay amên dayêwên silan mani tawu. Kabay ya pan-iptês la sa waêng la buy ya pan-ikêskês sa takyay la ya dilag Sabin Bapan Namalyari, pan-ilapad la pun buy ipapakakarang la êt ta gumaygumay sa palpal yaming la. ");
INSERT INTO blx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nu dilag kalutu, labaylabay lan miknu sa iknuwan na in-il-an para sa maulagay tawu. Buy para êt baydu sa balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Labaylabay lan galangên silan mani tawuy malibasan la buy bêgên ‘Manuru.’ ” ");
INSERT INTO blx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Nuwa sikaw, agana kaw pabêg ‘Manuru’, tagawan mipapatêl kaw kaganawan buy kay sikuy Manuru yu. ");
INSERT INTO blx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Buy agana yu bêgên ‘Bapa’ ya sisabêt man baydi sa babun luta, tagawan kay gigisay Bapa yu, ya sabay ya Bapa yun Namalyari ya idi sa langit. ");
INSERT INTO blx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Agana kaw êt pabêg ‘Amung,’ gawan kay gigisay Amung yu, ayin kaatag nun a si Cristu. ");
INSERT INTO blx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ya pinakadakila kamuyu, sêpat yan magin lingkud yu. ");
INSERT INTO blx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ya mapagmatag-ay sabay ya iyêpan Bapan Namalyari. Buy ya mapagpayêpa, sabay ya itag-ay Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kapapalunus kaw wa mani manurun Kautusan buy mani Pariseoy mapagtalingkayu! Sikaw wa sangkan kabay asê mibilang nga mani tawu sa pag-arian Bapan Namalyari. Gawan sikaw man, asê mibilang buy pambênbênan yu pun êt ta mani tawuy kalabay miawyun sa pag-arian na.” ");
INSERT INTO blx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kapapalunus kaw wa mani manurun Kautusan buy mani Pariseoy mapagtalingkayu! Buy pampurayitin yuy mani nabal-u amên makwa yuy mani pibandiyan la, buy pagtatalimpanan yuy abiin sa kapamilatan makarang nga panalangin yu sa arapan mani tawu. Kabay mas nabyat lanuy parusan Bapan Namalyari kamuyu!” ");
INSERT INTO blx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kapapalunus kaw wa mani manurun Kautusan buy mani Pariseoy mapagtalingkayu! Maglipay kaw sa dagat buy mamaku kaw sa mani marayuy lugal amên ta mapasunul la gisay tawu sa paniwala yu. Nuwa nu napasunul yinay ati, pandaygên yuyan nadawak pun kamuyu buy luyang yapun milaku sa impernu!” ");
INSERT INTO blx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kapapalunus kaw! Para kaw bulag ga mangakay sa kaatag buy pan-iaral yuy, ‘Nu sisabêt man na manumpa sa kapamilatan Templu, a nayna kaylangan tuparên. Nuwa nu manumpa ya sa kapamilatan gintuy idi sa Templu, kaylangan nan tuparên.’ ");
INSERT INTO blx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sikaw wa mani bulag ga ayin tanda! Sabêt ta mas maulaga, gintu nayi o ya Templuy magpabanal sa gintu? ");
INSERT INTO blx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pan-iaral yu pun êt ta nu manumpa kaw sa kapamilatan pamiandugan, a yina kaylangan tuparên na ati, nuwa nu manumpa kaw sa andug ga idi sa pamiandugan, kaylangan yun tuparên na ati. ");
INSERT INTO blx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sikaw wa mani bulag, sabêt ta mas maulaga, ya andug o ya pamiandugan na magpabanal sa andug? ");
INSERT INTO blx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kabay nu manumpa kaw sa kapamilatan pamiandugan kan Bapan Namalyari, nanumpa kaw êt sa kaganawan andug ga idi sa pamiandugan. ");
INSERT INTO blx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nu manumpa kaw sa kapamilatan Templu, nanumpa kaw êt kan Bapan Namalyari ya manugêl baydu. ");
INSERT INTO blx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Buy nu manumpa kaw sa kapamilatan langit, nanumpa kaw êt sa turonun Bapan Namalyari buy kan Bapan Namalyari ya nakaiknu baydu.” ");
INSERT INTO blx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kapapalunus kaw wa manurun Kautusan buy mani Pariseoy mapagtalingkayu! Ta agyan pan-idin yu kan Bapan Namalyari ya ikapun mani pamalasa yu, pampaulayan yinaman na mani maulagay utus tungkul sa makatuynungan, mapallunus buy mapagtiwalan. Mangêd da mam-i kaw ikapu yu, nuwa agana yu paulayan na mas maulagay utus. ");
INSERT INTO blx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mani bulag ga mangakay! Paran pansalakên yuy ilêk sa pan-inêmên yu, pakan pan-ibuun yuy kamelyu!” ");
INSERT INTO blx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kapapalunus kaw wa mani manurun Kautusan buy mani Pariseoy mapagtalingkayu! Pallinisin yuy mani lawasan tasa buy pinggan yu, nuwa napnun mani bagay ya pinurayit yu sa mani tawu gawan sa kasakiman yu. ");
INSERT INTO blx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sikaw wa Pariseoy bulag! Linisin yu pun na lalên tasa buy pinggan yu amên magin malinis êt ta lawasan ati.” ");
INSERT INTO blx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kapapalunus kaw wa mani manurun Kautusan buy mani Pariseoy mapagtalingkayu! Nanuwad kaw mani pamilbêngan ya pininturan naputi ya mangangêd sa lawasan, pakan ya lalên ati, pawan but-un nangamamati buy kaganawan kadinatan. ");
INSERT INTO blx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Para kaw êt baysên! Sa êlêw tawu matinêk kaw, pakan lalên bêkê yuy pawan pagtatalingkayu buy kadawakan.” ");
INSERT INTO blx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Kapapalunus kaw wa mani manurun Kautusan buy mani Pariseoy mapagtalingkayu! Magpadyag kaw mani tanda' sa mani pinilbêngan mani propeta sabitun nuna buy pampakangêdên yuy mani pinilbêngan mani tawuy matinêk. Buy pansabin yuy, ‘Nu nabyay kay dayi sa panawun mani ninunu yan, a yan patin na mani propeta kaparisun dinyag mani ninunu yan.’ ");
INSERT INTO blx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sa parabaysên na pagsabi yu, pagpapêtgan yuy mani layi kaw namatin mani propeta! ");
INSERT INTO blx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dali kawna bay, yarin yinay inumpisan mani ninunu yu!” ");
INSERT INTO blx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Sikaw wa paran mani layin lupung! A yina matakasan na parusan impernu! ");
INSERT INTO blx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kabay mallêngê kaw! Mamiutus saku kamuyun mani propeta, mani mangabiyasay tawu buy mani manurun Kautusan. Patin yuy dakun umnu kalla. Ya kaatag, ipaku yu sa kurus. Ya kaatag êt, latikun yu sa lalên balin pagtipunan. Buy ya kaatag, pisakitin yu sila agyan antuy lakwên la. ");
INSERT INTO blx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kabay maparusan kaw gawan sa pamati yu. Buy alwan kay abiin na panagutan yu, nun a sikaw êt ta managut sa pangamatin kaganawan tawuy matinêk paubat kan Abel angga kan Zacarias ya anak Barakias. Ta ya mani ninunu yu sabay silay namati kan Zacarias ya pinati la sa pibunakan pamiandugan buy Templu. ");
INSERT INTO blx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pansabin ku kamuyu ya kaganawan kasalanan na abiin, panagutan mani tawu amêsên.” ");
INSERT INTO blx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Sikaw wa mani taga Jerusalem, pampatin yuy mani propeta buy pambatwan yuy mani pan-iutus Bapan Namalyari kamuyu angga sa mati sila. Katiumnu kataw nan labay tipunun buy saysayên kaparisun panyumyum gayindun manuk sa mani siwsiw na, nuwa siyan a kaw kalabay. ");
INSERT INTO blx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kabay agyan lasakên lay tutugêlan yu, pakabaala kawna. ");
INSERT INTO blx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pansabin ku kamuyuy paubat amêsên, a yu kina makitan angga sa lumatêng nga panawun na sabin yuy, ‘Pagpalên na mallumatêng sa lagyun Panginuun.’ ” ");
INSERT INTO blx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nag-awas si Jesus ubat sa kasawangan Templu buy sên mamitay na, nagdani kanay mani tagasunul na buy inturu la kanay impaidêng nga nakapalitêng sa Templu. ");
INSERT INTO blx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sinabin Jesus kalla, “Awu. Pan-êlêwên yuy abiin. Nuwa pansabin ku kamuyuy malasak ka kaganawan abiin buy ayin batuy mitagan na nakapaluntu sa kaparisu nan batu.” ");
INSERT INTO blx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kaban nakaiknu si Jesus sa gisay lugal sa Bung-uy mani Ulibu, nagdani kanay mani tagasunul na. Buy pinatang layan kay kakapad na. Sinabi la, “Sabin mu kanyan nu makanu malyari ya sinabi mu buy nu sabêt ta tanda' sa pag-udung mu buy sa katganan babun luta.” ");
INSERT INTO blx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nakitbay si Jesus kalla, “Mangillag kaw amên a kaw mailitêp agyan sisabêt man. ");
INSERT INTO blx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tagawan malakêy lumatêng nga manggamit lagyu ku buy sabin lay, ‘Sikuy Cristuy impangakun Bapan Namalyari.’ Kabay malakêy mailitêp la. ");
INSERT INTO blx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makalêngê kaw migegeray marani kamuyu buy makabalita kaw êt migegeray marayu. Nuwa agana kaw malimu, ta sêpat malyari ya abiin. Nuwa alwa pun abiin na katganan babun luta. ");
INSERT INTO blx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tagawan makigeray bansa sa kaparisu nan bansa buy makigeray kaarian sa kaparisu nan kaarian. Buy lumatêng êt ta sadyay layang buy layun sa magmikakanayun na lugal. ");
INSERT INTO blx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ya kaganawan kasakitan na abiin, kay umpisa pun sadyay kasakitan ya maiparisu sa kasakitan babayi ya manganak.” ");
INSERT INTO blx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sa panawun abitu, gawan sa panunul yu kangku, kasulapwan kaw kaganawan. Dakpên kaw amên pasakitan buy patin. ");
INSERT INTO blx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Malakêy magpabukut sa panampalataya la kangku. Misusulapu sila buy misusupakat ta balang gisa. ");
INSERT INTO blx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Malakêy magtatalingkayun propetay lumtaw buy ilitêp lay malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gawan kapamiwagaw-wagaw kadawakan baydi sa babun luta, kabay lumêpêt ta pamiiidun malakêy manampalataya. ");
INSERT INTO blx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nuwa ya manugêl tapat angga sa katganan, sabay siyay miligtas. ");
INSERT INTO blx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Maipatanda sa kaganawan bansa baydi sa babun luta ya Mangêd da Balita tungkul sa pag-arin Bapan Namalyari bilang pagpapêtêg kalla bayu pun lumatêng nga katganan.” ");
INSERT INTO blx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Sikaw wa mamasa, pakaintindin yuy ati! Nu makitan yun idi ya sa Templun Bapan Namalyari ya pansabin Propeta Daniel tungkul sa sadyay kadawakan na maniray lumatêng, ");
INSERT INTO blx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ya kaganawan idi sa Judea, kaylangan tumakas makun kabubung-uyan. ");
INSERT INTO blx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ya idi sa lawasan bali, aganayna sumun amên mangwan dakun sabêt sa lalên bali na. ");
INSERT INTO blx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ya idi sa panggitnan, aganayna muli amên mangwan yaming na. ");
INSERT INTO blx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mamakapalunus ya mani nabuktut buy mani mamasusu sa allun abiin, tagawan magkasakit silan tumakas. ");
INSERT INTO blx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Manalangin kaw kan Bapan Namalyari ya sa pantumakas yu, alwan panawun nalêpêt o Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tagawan sa panawun abitu, makadanas ya mani tawun sadyay kasakitan ya a la pun nadanasan ubat pun sabitun dinyag ga babun luta angga amêsên. Buy ayin nan manguman makadanas parabayduy kasakitan kanuman. ");
INSERT INTO blx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ta nu asê inêpêk Bapan Namalyari ya panawun abitu, ayin tawuy miligtas. Nuwa para sa mani tawuy pinili na, êpêkên nay panawun abitu.” ");
INSERT INTO blx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nu dilag magsabi kamuyun, ‘Idi ya baydi ya Cristu!’, o ‘Idi ya baydu!’, agana kaw makipapaniwala. ");
INSERT INTO blx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tagawan lumtaw wa mani magtatalingkayun Cristu buy mani magtatalingkayun propeta. Mipakit silan mani tanda' buy mamakaupapas amên ilitêp pa mani tawu buy nu malyari, agyan na mani pinilin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kabay mangillag kaw! Sinabi kuy abiin kaban asê pun nalyari.” ");
INSERT INTO blx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kabay nu dilag magsabi kamuyun, ‘Idi ya baydu sa kakyangan na Cristu!’, agana kaw maku baydu. Buy nu dilag magsabin, ‘Idi yina sa lalên bali!’, agana kaw makipapaniwala. ");
INSERT INTO blx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta sikuy ubat sa langit ta in-Anak Tawu, mag-udung ngaku sa babun luta ya makitan kaganawan tawu. Ta para kun sawang kimat ta mangulimad sa langit ya ubat sa puputakan mamut angga sa tatanglêwan.” ");
INSERT INTO blx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Nu saantuy dilag bangkay, mititipun bayduy mani uwak. Kabay matandan kaganawan.” ");
INSERT INTO blx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pamakayarin abituy allun sadyay kasakitan, dumiglêm ma mamut buy asina sumawang nga buwan. Mangananabuy mani bêtêwên buy maubus maêyêg ga mani bagay ya idi sa langit buy mitas sila sa binyanan la. ");
INSERT INTO blx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pamakayari, makitan sa langit ta tandan pallumatêng ku. Buy gawan sa tandan ati, mipanangis ya kaganawan tawu sa babun luta. Ta sikuy ubat sa langit ta in-Anak Tawu, makitan lakun lumatêng nga idi sa ulap buy dilag kapangyarian buy mamakapasilêw wa sawang. ");
INSERT INTO blx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sa masnêg ga sênêg patutut, iagnan kun iutus ya mani ang-el ku sa kaganawan lugal sa babun luta amên tipunun lay mani tawuy pinili ku.” ");
INSERT INTO blx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sinabi pun êt Jesus, “Pakaintindin yuy aral sa paalimbawa sa puun kayun igus. Nu magbulung nganay sangan ati, tanda yinay marani yay kaynitan. ");
INSERT INTO blx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Para êt bayduy malyari lanu. Nu makitan yinan malyari yay kaganawan pansabin ku kamuyu, matandan yuy marani yakinan lumatêng ya paran idi yakina sa pasbul bali. ");
INSERT INTO blx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pansabin ku kamuyuy bayu mati ya kaganawan tawu sa panawun amêsên, matupad day kaganawan sinabi ku. ");
INSERT INTO blx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ya langit buy luta, dilag katganan. Nuwa ya mani sabi ku, manugêl kanuman.” ");
INSERT INTO blx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Sinabi pun êt Jesus, “Nuwa tungkul laman sa allu o uras pag-udung ku, ayin magtanda, agyan na mani ang-el sa langit buy agyan sikuy Anak Bapan Namalyari. Kay si Bapay magtanda. ");
INSERT INTO blx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Buy nu parasaantun nagbabang-uwan na mani tawu sabitun panawun Noe, para êt baydun magbabang-uwan na mani tawu sa pag-udung kuy ubat sa langit ta in-Anak Tawu. ");
INSERT INTO blx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sabitun panawun Noe, bayu lumatêng nga lanab, magbabang-uwan na mani tawun mangan, maglasing buy mipag-asawa angga sa sinumun sa barku si Noe. ");
INSERT INTO blx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ayin silan katatanda sa malyari kalla angga sa inlumatêng nga lanab buy nangaaanul silan kaganawan. Parabaysên na malyari sa pag-udung kuy ubat sa langit ta in-Anak Tawu ya kay magbabang-uwan sila. ");
INSERT INTO blx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sa allun pag-udung ku, dilag luway liyaki ya mag-ubra sa panggitnan. Ya gisa, gêtan sa langit. Nuwa ya gisa, lakwanan. ");
INSERT INTO blx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Buy dilag luway babayi ya mag-ubra sa panggilingan. Ya gisa, gêtan sa langit, nuwa ya gisa, lakwanan.” ");
INSERT INTO blx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kabay pawa kaw maglêan, tagawan a yu tanda nu sabêt ta allun pallumatêng Panginuun yu. ");
INSERT INTO blx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pakaisipin yuy ati. Nu tandan magbali nu sabêt ta uras sa yabi lumatêng nga manakaw, papakabantayan nay bali na buy a na pasawên masunan na bali na. ");
INSERT INTO blx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kabay sikaw man, sêpat kaw pawan maglêan, tagawan sikuy ubat sa langit ta in-Anak Tawu, mag-udung ngaku sa uras ya magbabang-uwan kaw.” ");
INSERT INTO blx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sinabi pun êt Jesus, “Ya mapagtiwalan buy katanday ipus, sabay siyay pagtiwalan amung na sa mani kaatag ipus buy siyay mam-in kanên kalla sa ustuy uras. ");
INSERT INTO blx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pinagpalay abituy ipus nu malatêng yan amung nay mag-ubra sa pan-ipadyag amung na. ");
INSERT INTO blx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pansabin ku kamuyuy sabay siyay pagtiwalan amung na sa kaganawan pibandiyan na. ");
INSERT INTO blx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nuwa ya ipus ya abiin, nu asê mangêd da nakêm na buy indap na nu mabuyut pun bayu lumatêng nga amung na. ");
INSERT INTO blx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kabay ya daygên na, patukpatukun nay kaatag ipus, makiêm buy makiawyun yan maglasing. ");
INSERT INTO blx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nuwa sa alluy magbabang-uwan ya, lumatêng nga amung na. ");
INSERT INTO blx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kabay parusan yan amung na un mabyat buy isamwag naya sa lugal la pamisamwagan mani mapagtalingkayu. Manangis ya baydun mingêngêt ta bêbêy na.” ");
INSERT INTO blx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sinabi pun êt Jesus, “Ya pamibilang kantamu sa pag-arian Bapan Namalyari, maiparisu sa nalyari sa mapuy dalagay dilag gêgtan na suluy nagsalwang amên têgmên na liyaki ya manangên. ");
INSERT INTO blx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ya lima kalla, ayin tanda buy ya lima, katanda. ");
INSERT INTO blx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ya mani ayin tanda, kay nipantan sulu, nuwa a sila nantan pagkapanagdag lay gas. ");
INSERT INTO blx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pakan ya mani katanda, nipantan pagkapanagdag lay gas sa mani sulu la. ");
INSERT INTO blx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nuwa naêpêng inlumatêng nga liyaki ya manangên. Kabay nabêlêwan mani dalaga sa pangêtêng la.” ");
INSERT INTO blx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Sên bunak kan yabi, dilag masnêg ga nagbêg, ‘Abiti yay liyaki ya manangên! Mag-awas kawna amên têgmên yuya!’ ");
INSERT INTO blx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tambêng nimatay mapuy dalaga buy impakapala lay sulu la. ");
INSERT INTO blx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sinabin limay ayin tanda sa mani limay katanda, ‘Biyan yukay yatin agyan pêrad da gas, ta marani yan mapalêng nga sulu yan.’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Nakitbay ya mani katanda, ‘A yabay minukad da gas kantamun kaganawan. Mangêd da maku kawna sa magtinda buy manaliw kaw para kamuyu.’ ");
INSERT INTO blx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kabay namitay limay dalagay ayin tanda amên manaliw gas la. Nuwa kaban manaliw sila, inlumatêng ngay liyaki ya manangên. Ya limay nakal-an, kaawyun nan sinumun sa kalutu. Pamakasun la, insaray nay pasbul.” ");
INSERT INTO blx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Pamakayari, inlumatêng nga limay ayin tanday dalaga buy nagbêg, ‘Kakay, kakay, pasunun mukay ya kayêk!’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Nuwa nakitbay ya liyaki ya manangên, ‘Sisabêt kaw? A kataw kakilala.’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Buy sinabin Jesus, “Pawa kaw maglêan, gawan a yu tanda nu sabêt ta allu o uras pag-udung ku.” ");
INSERT INTO blx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sinabi pun êt Jesus, “Ya pag-arin Bapan Namalyari, maiparisu sa dinyag gisay tawuy mabandi ya bayu ya namita papakun sa marayuy lugal, binêg nay mani ipus na buy intiwala na kallay pibandiyan na. ");
INSERT INTO blx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Binyanan nay balang gisa kalla ayun sa agyu lan pagligosyu. Binyanan nay gisan limay libuy gintu. Ya gisay naman, luway libuy gintu. Ya gisa êt, binyanan nan gisay libuy gintu. Pamakayari, namitay nay mabandi. ");
INSERT INTO blx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ya ipus ya binyanan limay libuy gintu, tambêng yan nagligosyu buy nakatubu yan limay libuy gintu. ");
INSERT INTO blx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Para êt bayduy dinyag ipus ya binyanan luway libuy gintu. Nakatubu ya êt luway libuy gintu. ");
INSERT INTO blx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nuwa ya ipus ya binyanan gisay libuy gintu, kay ingkali nay naman sa luta.” ");
INSERT INTO blx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pamakayarin makarang nga panawun, nag-udung nga amung la buy impabêg na sila amên patangên tungkul sa pibandiyan ya intiwala na kalla. ");
INSERT INTO blx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nagdani ya ipus ya pinitiwalan nan limay libuy peray gintu. Sinabi na, ‘Amung kuway, ya limay libuy peray gintuy intiwala mu kangku, nakatubu yan limay libuy peray gintu!’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Nakitbay ya amung na, ‘Mangêd buy tapat ta ipus, mangêd da dinyag mu! Kabay gawan tapat ka sa pêpêrad da intiwala ku kamu, itiwala ku kamuy maragul pun na alaga. Kaksaw ka ta makisaya ka kangku!’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Pamakayari, nagdani ya ipus ya binyanan nan luway libuy gintu. Sinabi na, ‘Amung kuway, ya luway libuy gintuy intiwala mu kangku, nakatubun luway libuy gintu!’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Nakitbay ya amung na, ‘Mangêd buy tapat ta ipus, mangêd da dinyag mu! Kabay gawan tapat ka sa pêpêrad da intiwala ku kamu, itiwala ku kamuy maragul pun na alaga. Kaksaw ka ta makisaya ka kangku!’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nagdani êt ta ipus ya binyanan nan gisay libuy gintu. Sinabi na sa amung na, ‘Tanda kuy maigpit ka buy ayin lunus. Pampupulun muy a mu intanêm buy pangkêwên muy pinagkasakitan kaatag. ");
INSERT INTO blx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kabay nalimu waku kamu buy ingkali ku tanay pibandiyan mu sa luta. Ati ya gisay libuy gintuy intiwala mu kangku.’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nakitbay ya amung na, ‘Nadawak buy matamad da ipus! Tanda mu awêd da pampupulun kuy a ku intanêm buy pangkêwên kuy a ku pinagpagalan. ");
INSERT INTO blx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Uysiyan a mu yata imbangkuy peray gintu ku amên sa pag-udung ku, makwa kuy tubu na?’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Kabay sinabi na sa kaatag pun na mani ipus, ‘Kêwên yu kanay gisay libuy gintu, ta idin yu sa nakapagtubun mapuy libuy gintu. ");
INSERT INTO blx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tagawan ya tawuy dilag gana, biyan yapun êt, buy mabiyan yapun êt mas malakê. Nuwa ya tawuy pêrad tay idi kana, itas pun êt kana. ");
INSERT INTO blx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Isamwag yu sa kadlêman sa lawasan ya abiin na ayin pukat ta ipus. Manangis ya baydun mingêngêt ya bêbêy.’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sinabi pun êt Jesus, “Sikuy ubat sa langit ta in-Anak Tawu, mag-udung ngakun dilag kapangyarian kaawyun na kaganawan ang-el buy miknu waku sa dakilay turonu ku. ");
INSERT INTO blx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tipunun ku sa arapan kuy kaganawan tawu sa babun luta. Daygên ku silan luway pustu, kaparisun pandaygên magpastul tupa buy kambing. ");
INSERT INTO blx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ya mani tawuy paran tupa, idin ku sila sa wanan ku. Nuwa ya mani tawuy paran kambing, idin ku sila sa udi ku.” ");
INSERT INTO blx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Pamakayari, sikuy bilang Ari, sabin ku sa mani tawuy idi sa wanan ku, ‘Kaksaw kaw ya mani pagpalên Bapa ku. Sikaw wa magmana sa kaarian na in-il-an para kamuyu ubat pun sa dinyag ga babun luta. ");
INSERT INTO blx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tagawan sên nalayangan ku, pinakan yuku. Buy sên napêl-ang ngaku, pinaynêm yuku. Sên dayuwan naku kamuyu, tinanggap yuku sa bali yu. ");
INSERT INTO blx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Buy sên ayin nakun maiyaming, pinayamingan yuku. Sên nagsakit taku, sinaysay yuku. Sên idi yaku sa sukulan, dinungawan yuku.’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Makitbay ya mani matinêk, ‘Panginuun, nakanu yan kan nakitan na inlayang buy pinakan, o napêl-angan buy pinaynêm yan? ");
INSERT INTO blx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nakanu yan kan nakitan na dayuwan buy tinanggap yan sa bali o ayin maiyaming buy pinayamingan yan? ");
INSERT INTO blx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nakanu yan kan nakitan na nagsakit o idi sa sukulan buy dinungawan yan?’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Buy makitbay yaku bilang Ari, ‘Pansabin ku kamuyuy sên dinyag yuy ati sa mani pinakanayêpay patêl ku, bilang dinyag yina kangkuy abiin.’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pamakayari, sabin ku êt sa mani tawuy idi sa udi ku, ‘Sikaw wa mani insumpan Bapan Namalyari, magpakarayu kaw kangku! Minggat kaw sa apuy ya asê mangapalêng nga impakal-an para kan Satanas buy sa mani kampun na. ");
INSERT INTO blx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gawan sên nalayangan ku, a yu kuta pinakan. Buy sên napêl-ang ngaku, a yu kuta pinaynêm. ");
INSERT INTO blx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Sên nagin dayuwan naku kamuyu, a yu kuta tinanggap sa bali yu. Sên ayin nakun maiyaming, a yu kuta pinayamingan. Sên nagsakit taku buy idi sa sukulan, a yu kuta dinungawan.’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Patangên laku, ‘Panginuun, nakanu yan kan nakitan ya inlayang, napêl-angan, dayuwan, ayin maiyaming, nagsakit o idi sa sukulan buy a yan ka nasawpan?’ ");
INSERT INTO blx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Buy makitbay yaku kalla, ‘Pansabin ku kamuyuy sên a yu sinawpan na pinakanayêpay patêl ku, bilang a yukina sinawpan.’ ” ");
INSERT INTO blx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sinabi pun êt Jesus, “Ya mani tawun ati, maipalaku ku sila sa ayin katganan na parusa, nuwa ya mani tawuy matinêk, biyan ku silan biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pamakayarin in-aral Jesus ya kaganawan abiin, sinabi na sa mani tagasunul na, ");
INSERT INTO blx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tanda yuy luwa tanay allu bayu Pestan Kaligtasan. Buy sikuy ubat sa langit ta in-Anak Tawuy igawang sa mani tawu amên ipaku sa kurus.” ");
INSERT INTO blx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sa uras abitu, ya mani mamunun pari buy mani mangatway manungkulan, nititipun sila sa palasyun Caifas ya pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pisasabyan la nu parasaantu lan ipadakêp buy ipapati si Jesus un ayin makatanda. ");
INSERT INTO blx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sinabi la, “Gana tamu pun daygên sa allun pesta, ta dat maguluy mani tawu.” ");
INSERT INTO blx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Idi sa Bethania si Jesus sa balin Simon na natasan ketung. ");
INSERT INTO blx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kaban nakaiknu si Jesus sa panganan, nagdani kanay gisay babayi ya mantan makamal la pabangi ya idi sa gisay pamyanan na diyag sa batun alabastru. Buy pakanawa nan imbulug ga pabangi sa ulun Jesus. ");
INSERT INTO blx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nuwa sên nakit mani tagasunul Jesus ya dinyag babayi, nanubag sila. Sinabi lay, “Uysiyan insayang na yay pabangi ta? ");
INSERT INTO blx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pakan maisaliw naya dayi sa makamal la alaga ta, buy ya naabli na, maidin sa mani kalulu.” ");
INSERT INTO blx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nuwa tandan Jesus ya pisasabyan la. Kabay sinabi na kalla, “Uysiyan pakyalaman yu yay pandaygên babayi ta? Mangêd da dinyag na kangku. ");
INSERT INTO blx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pawa yun mapagkaawyun na mani kalulu, nuwa siku, a yu pawan mapagkaawyun. ");
INSERT INTO blx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Binulugan nay nan pabangi ya lawini ku amên il-an na sa pamilbêng kangku. ");
INSERT INTO blx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pansabin ku kamuyuy agyan saantu iaral baydi sa babun lutay Mangêd da Balita, miwagaw êt ta mangêd da dinyag na kangku bilang pangganaka kana.” ");
INSERT INTO blx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Si Judas Iscariote ya gisa sa mapu buy luway tagasunul Jesus, naku ya sa mani mamunun pari. ");
INSERT INTO blx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Sinabi na kalla, “Sabêt ta ibayad yu kangku, nu sawpan kataw mandakêp kan Jesus?” Nakitbay sila, “Biyan yan kan tatlumpuy pilak.” Kabay binyanan la si Judas un tatlumpuy pilak. ");
INSERT INTO blx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Paubat baydu, nangêtêng nginan panawun na masawpan na silan mandakêp kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sên inlumatêng nga nunan allun Pestan Tinapay ya Ayin Pamalbag, nagdani ya mani tagasunul Jesus buy namatang kana. Sinabi la, “Antuy labay mun pamil-anan yan apunan para sa Pestan Kaligtasan?” ");
INSERT INTO blx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nakitbay si Jesus, “Lakwên yu sa balayan Jerusalem ya tawuy sinabi ku kamuyu buy sabin yu kanay, ‘Pan-ipasabin Manuru kamuy inlumatêng ngay uras na. Kabay baydi sa bali muy labay nan pangapunan nan Pestan Kaligtasan kaawyun nay mani tagasunul na.’ ” ");
INSERT INTO blx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sinunul lay utus Jesus buy in-il-an la bayduy apunan la para sa Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sên yabi yana, niknuy na si Jesus sa arapan lamesa kaawyun nay mapu buy luway tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kaban mangan sila, sinabin Jesus kalla, “Pansabin ku kamuyuy gisa kamuyuy mamisupakat kangku.” ");
INSERT INTO blx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sên nalêngê lay sinabin Jesus, nalungkut sila buy tisatisa silan namatang kana, “Panginuun, siku nayi?” ");
INSERT INTO blx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nakitbay ya, “Ya mapagkaagnan kun mamisawsaw tinapay sa kulu, sabay ya mamisupakat kangku. ");
INSERT INTO blx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sikuy ubat sa langit ta in-Anak Tawu, patin naku, ta abiin na idi sa Kasulatan. Nuwa taganan mamakapalunus ya tawuy mamisupakat kangku! Mangêd pun na a yina in-anak.” ");
INSERT INTO blx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Namatang êt si Judas ya sabay ya mamisupakat kana, “Manuru, siku nayi?” Nakitbay si Jesus, “Sikay nay nagsabi.” ");
INSERT INTO blx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kaban mangan sila, nangwan tinapay si Jesus buy impasalamat na kan Bapan Namalyari. Binis-ilbis-il nay tinapay buy inggawang na sa mani tagasunul na. Sinabi na, “Ati ya lawini ku. Kêwên yu buy kanên.” ");
INSERT INTO blx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pamakayari, kingwa nay pan-inêmên buy impasalamat na kan Bapan Namalyari buy inggawang na kalla. Sinabi na kalla, “Kêwên yuy ati buy inêmên yun kaganawan. ");
INSERT INTO blx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tagawan ati ya daya kuy mibulug para sa pamatawad kasalanan malakêy tawu. Ati ya mamipapêtêg sa bayuy kasunduwan Bapan Namalyari sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pansabin ku kamuyuy a kina manguman minêm alak ka diyag sa sabên ubas anggan a kataw manguman mapagkaawyun minêm sa kaarian Bapa ku.” ");
INSERT INTO blx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nagkanta silan pangulimên kan Bapan Namalyari buy pamakayari, naku sila sa Bung-uy mani Ulibu. ");
INSERT INTO blx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sinabin Jesus sa mani tagasunul na, “Sa yabin ati, lakwanan yukun kaganawan, ta paradi ya idi sa Kasulatan, ‘Patin kuy pastul buy mikyat ta mani tupa.’ ");
INSERT INTO blx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nuwa pamakayari kun mabyay manguman, muna ku kamuyu sa prubinsyan Galilea.” ");
INSERT INTO blx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sinabin Pedro kan Jesus, “Agyan lakwanan kan kaganawan, a kata lakwanan.” ");
INSERT INTO blx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nakitbay si Jesus, “Pansabin ku kamuy bayu mangkati ya manuk amêsên yabi, katitlu mukun ipuglaw.” ");
INSERT INTO blx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sinabin Pedro, “Agyan patin nakun kaawyun mu, a kata ipuglaw.” Para êt bayduy sinabin kaganawan tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Naku si Jesus sa lugal la pambêgên Getsemani kaawyun nay mani tagasunul na. Pamakalatêng la baydu, sinabi na kalla, “Miknu kaw pun baydi, ta maku waku pun baydun manalangin.” ");
INSERT INTO blx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nuwa pikilakun Jesus si Pedro buy ya luway anak Zebedeo. Baydu winan nag-umpisan nalêlê buy nabêgbêg ga bêkê. ");
INSERT INTO blx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kabay sinabi na kalla, “Paran mati yakina gawan sa sadyay lêlên bêkê ku. Minggat kaw baydi buy awyunan yukun magpuyat.” ");
INSERT INTO blx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nagpakarayu yan pêrad, nagpalukub yan nanalangin, “Bapa ku, nu malyari dayi, itas muy pamasakit ta madanasan ku. Nuwa paraman baydu, alwan kalabayan kuy masunul, nun a ya kalabayan mu.” ");
INSERT INTO blx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Inudung Jesus ya tatluy tagasunul na buy nalatêng na silan mamabêlêw. Sinabi na kan Pedro, “A mu nayi mabatan magpuyat kaawyun ku, agyan kay gisay uras? ");
INSERT INTO blx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpuyat kaw buy manalangin amên a kaw masambut tuksu. Ta ya ispiritu, nakal-an yan manunul, nuwa maynay lawini.” ");
INSERT INTO blx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nanguman nagpakarayu si Jesus buy nanalangin, “Bapa ku, nu kaylangan kun danasên na kasakitan na ati, madyag ga kalabayan mu.” ");
INSERT INTO blx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pamakayari, inudung nan manguman na mani tagasunul na buy nalatêng na silayna êt mamabêlêw gawan kabêlêwbêlêw sila. ");
INSERT INTO blx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nanguman na êt nagpakarayu si Jesus buy sa ikatlun panalangin na, para êt bayduy panalangin na. ");
INSERT INTO blx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Inudung nayna êt ta mani tagasunul na buy sinabi, “Uysiyan nabêlêw kaw yapun buy magpaynawa ta? Elêwên yu! Inlumatêng ngay uras ya sikuy ubat sa langit ta in-Anak Tawu, insupakat takina sa mani makasalanan. ");
INSERT INTO blx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mimata kaw! Kaksaw wana! Ta abiti yay tawuy namisupakat kangku.” ");
INSERT INTO blx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kaban magsabi pun si Jesus, inlumatêng si Judas Iscariote ya gisa sa mapu buy luway tagasunul na. Dilag yan malakêy kaawyun na nipagkêya buy nipagpamatuk. In-utus silan mani mamunun pari buy mani mangatway manungkulan. ");
INSERT INTO blx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Paradi ya patanda' ya sinabin Judas sa mani mandakêp kan Jesus, “Ya dêpên kuy pingi, sabay ya pantêkapên yu. Dakpên yuya.” ");
INSERT INTO blx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tambêng nagdani si Judas kan Jesus buy sinabi na, “Mangêd da yabi kamuy Manuru.” Pamakayari, dinêp nay pingin Jesus. ");
INSERT INTO blx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sinabin Jesus kana, “Kaluguran, daygên minay palanu mu.” Nagdani ya mani kaawyun na buy dinakêp la si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nanganus kêyay gisa sa mani tagasunul Jesus buy pinutus nay têk ipus pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sinabin Jesus kana, “Isakêb muy kêya mu sa kaluban! Gawan ya manggamit kêya, mati ya êt sa kêya. ");
INSERT INTO blx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","A mu nayi tanday nu manyawad dakun sawup sa Bapa kun Namalyari, tambêng nan iutus ya mapu buy luway batalyun mani ang-el na? ");
INSERT INTO blx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nuwa nu daygên kuy abitu, asê matupad da idi sa Kasulatan ya magsabin sêpat malyari ya ati.” ");
INSERT INTO blx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pamakayari, sinabin Jesus sa mani tawu, “Tulisan naku nayi? Uysiyan mantan kaw yapun mani kêya buy pamatuk amên dakpên naku ta? Allu-allu wakun mangaral sa kasawangan Templu. Uysiyan a yuku yata dinakêp baydu ta? ");
INSERT INTO blx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nuwa nalyari ya kaganawan abiin amên matupad da impasulat Bapan Namalyari sa mani propeta.” Amêsên, tambêng nipamwayuy mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pamakayari, gintan la si Jesus sa balin pinakapuun pari ya si Caifas. Nititipun bayduy mani manurun Kautusan buy mani mangatway manungkulan. ");
INSERT INTO blx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nanunul êt si Pedro kalla, nuwa kay idi ya sa marayun pêrad. Sinumun ya sa bakud pinakapuun pari buy nakiiknu sa mani magbantay amên matandan na nu sabêt ta malyari kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Amêsên, ya mani mamunun pari buy kaganawan mangatwan Judioy mangatuynungan, mangkap silan mani tawuy magsabin alwan pêtêg laban kan Jesus amên maatulan layan kamatyan. ");
INSERT INTO blx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nuwa ayin silan nakitan na maisangkan laban kana, agyan malakêy tawuy nagsabin alwan pêtêg laban kana. Sa kapupusan, dilag luway lawyaki ya nagdani ");
INSERT INTO blx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","buy nagsabi, “Sinabin tawun ati ya agyu nan lasakên na Templun Bapan Namalyari buy sa lalên tatluy allu, maipaydêng nan manguman na Templu.” ");
INSERT INTO blx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nidêng nga pinakapuun pari buy pinatang na si Jesus, “Ayin ka nayin maipakitbay laban sa panangkan la kamu?” ");
INSERT INTO blx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nuwa asê nakitbay si Jesus. Kabay inuman yan pinatang pinakapuun pari, “Sa lagyun Bapan Namalyari ya nabyay, sabin mu amêsên kanyan nu sikay Cristuy Anak Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nakitbay si Jesus, “Sikay nay nagsabi. Pansabin ku kamuyun kaganawan na paubat amêsên, sikuy ubat sa langit ta in-Anak Tawu, makitan yu kuy nakaiknu sa wanan Bapan Namalyari ya Makapangyarian. Buy sa pag-udung ku, makitan yu kuy idi sa ulap pa mallumatêng.” ");
INSERT INTO blx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sên nalêngên pinakapuun pari ya abitu, nanubag ya. Kabay gininit nay yaming na buy sinabi nay, “Pallamusun na si Bapan Namalyari! A tamina kaylangan na dilag kaatag magpapêtêg ta nalêngê taminay pallamus na kan Bapan Namalyari! ");
INSERT INTO blx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sabêt amêsên na iatul yu kana?” Nakitbay sila, “Sêpat yan patin.” ");
INSERT INTO blx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tinupayan lay lupa na buy dinugêdugê laya. Tinakpan kaatag ga matan Jesus buy dinalpi lay pingi na. ");
INSERT INTO blx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Buy sinabi la kanay, “Nu sika si Cristu, ulên mu nu sisabêt ta nandugê kamu!” ");
INSERT INTO blx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kaban nakaiknu si Pedro sa lawasan balin pinakapuun pari, dinanyan yan gisay babayi ya ipus buy sinabin babayi kana, “Sika êt ta pagkaawyun Jesus ya taga Galilea.” ");
INSERT INTO blx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nuwa impuglaw Pedroy abiin sa arap malakêy tawu. Sinabi na, “A ku tanday pansabin mu.” ");
INSERT INTO blx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Naku si Pedro sa agid pasbul buy nakitan yan kaatag babayi ya ipus. Buy sinabin babayi sa mani tawu baydu, “Ya tawun abiin, sabay siyay pagkaawyun Jesus ya taga Nazaret.” ");
INSERT INTO blx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nuwa inuman impuglaw Pedro si Jesus, “A ku kakilalay tawun abiin!” ");
INSERT INTO blx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Asê naêpêng, nagdani kan Pedroy kaatag pun na idi baydu buy sinabi la, “Pilmin gisa ka sa mani kaawyun Jesus, gawan malêngê yan sa pagsabi mu.” ");
INSERT INTO blx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nakitbay si Pedro, “Taganan a ku kilalay tawun abiin, agyan mati yaku amêsên.” Sa uras êt abitu, nangkati ya manuk. ");
INSERT INTO blx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kabay naganakan Pedroy sinabin Jesus kana, “Bayu mangkati ya manuk, katitlu mukun ipuglaw.” Kabay nagsalwang si Pedro buy sadyay tangis na. ");
INSERT INTO blx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pamakamaranun, nipupulung nga kaganawan mamunun pari buy mani mangatway manungkulan nu sabêt ta daygên la amên maipapati la si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Impagapus la si Jesus buy in-arap kan Gobernador Pilato. ");
INSERT INTO blx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sên natandan Judas ya inatulan nan kamatyan si Jesus, nagsisi ya sa dinyag nay pamisupakat. Kabay in-udung na sa mani mamunun pari buy mani mangatway manungkulan na tatlumpuy pirasun pilak. ");
INSERT INTO blx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Sinabi na kalla, “Nangasalanan naku, ta insupakat ku kamuyuy tawuy ayin kasalanan.” Nuwa nakitbay sila, “Ayin kay pakyalam kamu. Idi ya kamuy abiin.” ");
INSERT INTO blx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Insamwag Judas ya pilak baydu sa Templu. Pamakayari, namita ya buy nagpakamati. ");
INSERT INTO blx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pinulut mani mamunun pari ya pilak buy sinabi, “Labag sa Kautusan na idin tamuy pilak sa pamyanan bandin Templu, gawan imbayad da abiin amên maipapati ya gisay tawu. ");
INSERT INTO blx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kabay nikakasundu silan gamitin na pilak amên saliwin na lutay panggitnan manyag banga amên daygên pamilbêngan mani dayuwan. ");
INSERT INTO blx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kabay angga amêsên, pambêgên na abitun ‘Lutan Daya.’ ” ");
INSERT INTO blx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sa pakapakun baydu, natupad da sinabin propeta Jeremias sabitun sinabi nay, “Kingwa lay tatlumpuy pirasun pilak, ta ati ya napikasunduwan mani Israelitay alagan biyay na. ");
INSERT INTO blx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Buy pinanaliw lan lutay panggitnan manyag banga, tagawan abiin na in-utus kangkun Panginuun.” ");
INSERT INTO blx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sên in-arap la si Jesus kan Gobernador Pilato, pinatang naya, “Sika nayi ya Arin mani Judio?” Nakitbay si Jesus, “Sikay nay nagsabi.” ");
INSERT INTO blx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nuwa sên sinangkanan yan mani mamunun pari buy mani mangatway manungkulan, asê nakitbay si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kabay pinatang yan nanguman Gobernador Pilato, “Malakêy pan-isangkan la laban kamu. A mu nayi malêngêy pansabin la?” ");
INSERT INTO blx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nuwa asê êt nakitbay si Jesus. Kabay nakaupapas ya Gobernador. ");
INSERT INTO blx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Balang Pestan Kaligtasan, naugalyan Gobernador Pilatoy mamibus yan gisay nakasukul ayun sa labay mani tawu. ");
INSERT INTO blx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sa panawun abitu, dilag gisay nakasukul la maglagyun Barabbas ya pikatandan sa panyag kadawakan. ");
INSERT INTO blx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sên nititipun na mani tawu, pinatang silan Gobernador Pilato, “Sisabêt ta labay yun ibus ku? Si Barabbas o si Jesus ya pambêgên Cristu?” ");
INSERT INTO blx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nasabi nay abiin gawan tanda nay in-arap mani Judio si Jesus kana gawan kay kinasêman laya. ");
INSERT INTO blx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kaban nakaiknu si Gobernador Pilato sa pallitisan, impasabin asawa nay paradi, “Agana mu pakyalaman na tawun abiin na ayin kasalanan, tagawan naalipusan na lalên nakêm ku sa taynêp ku tungkul kana.” ");
INSERT INTO blx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nuwa ya mani mamunun pari buy mani mangatway manungkulan, intustus lay mani tawuy yawarên kan Pilatoy ibus si Barabbas buy patin si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kabay namatang nanguman si Gobernador Pilato sa mani tawu, “Sisabêt sa luway labay yun ibus ku?” Masnêg lan sinabi, “Si Barabbas!” ");
INSERT INTO blx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nanguman namatang si Gobernador Pilato, “Sabêt ta labay yun daygên ku sa pambêgên Cristu?” Nakitbay ya kaganawan, “Ipaku ya sa kurus!” ");
INSERT INTO blx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pinatang silan Gobernador Pilato, “Awta, sabêt ta dinyag nay kasalanan?” Nuwa ingkakadus sinabin mani tawuy, “Ipaku ya sa kurus!” ");
INSERT INTO blx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sên nakitan Pilatoy ayin yan madyag gawan dat maguluy mani tawu, nipakwa yan lanêm buy nag-uyas yan gamêt sa arapan mani tawu buy sinabi na, “Ayin nakun kasalanan sa pangamatin tawun ati. Sikaw wa sêpat managut.” ");
INSERT INTO blx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nakitbay ya mani tawu, “Awu, sikay buy mani anak yan na managut sa kamatyan na!” ");
INSERT INTO blx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pamakayari, impabus Gobernador Pilato si Barabbas. Nuwa si Jesus, impalatiku naya buy inggawang na sa mani sundalus amên ipaku sa kurus. ");
INSERT INTO blx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gintan mani sundalus si Jesus sa palasyun Gobernador Pilato buy pinalitêngan ya baydun kaganawan sundalus ya kaawyun la. ");
INSERT INTO blx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Intas lay yaming na buy pinayamingan layan kulay muraduy balabal. ");
INSERT INTO blx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nanyag silan kuronay nagdiwi ya impakurona la kana buy impatalan sa wanan gamêt nay têkên na nanuwad têkên ari. Nanduku sila sa arapan na buy inuyam laya, “Pagpalên baman na Arin mani Judio!” ");
INSERT INTO blx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tinupayan la si Jesus. Kingwa lay têkên kana buy impatukpatuk sa ulu na. ");
INSERT INTO blx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pamakayari lan inlamus si Jesus, intas lay balabal na buy pinayamingan layan sarili nan yaming. Pamakayari, in-awas laya sa balayan amên ipaku sa kurus. ");
INSERT INTO blx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sên idi silayna sa lawasan balayan, natbêng lay gisay liyaki ya taga Cirene ya naglagyun Simon. Impilit lan impabakay kanay kurus Jesus. ");
INSERT INTO blx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pallumatêng la sa lugal la pambêgên Golgota ya labay sabin “Lugal Bungu,” ");
INSERT INTO blx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","pinaynêm lan alak si Jesus ya sinabugan aplu. Nuwa sên natawayan Jesus ya ati, a nayna ininêm. ");
INSERT INTO blx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Impaku la si Jesus sa kurus buy pinibabagutan lay yaming na. ");
INSERT INTO blx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pamakayari, niknu sila ta binantayan la si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nikabit silan karatula sa ugtun ulun Jesus buy nakasulat bayduy pan-isangkan la laban kana, “Si Jesus ya Arin mani Judio.” ");
INSERT INTO blx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dilag êt luway tulisan na impaku sa kurus kaagnan Jesus. Ya gisa, idi sa wanan buy ya gisa, idi sa udi na. ");
INSERT INTO blx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ya mani tawuy manduman baydu, kapêyêngpêyêngan lan manguyam kan Jesus ");
INSERT INTO blx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","buy pansabin lay, “Alwa nayin sinabi muy lasakên muy Templu buy ipaydêng mun manguman sa lalên tatluy allu? Dali! Nu sikay Anak Bapan Namalyari, magtabuy ka sa kurus buy iligtas muy sarili mu!” ");
INSERT INTO blx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Para êt bayduy panguyam mani mamunun pari, mani manurun Kautusan buy mani mangatway manungkulan. Sinabi la, ");
INSERT INTO blx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Inligtas nay kaatag, pakan a na agyun iligtas ya sarili na. Alwa nayin siyay Arin Israel? Nu magtabuy ya sa kurus, maniwala kay kana. ");
INSERT INTO blx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Magtiwala ya kan Bapan Namalyari buy pansabin nay sabay siyay Anak Bapan Namalyari. Dali, êlêwên tamina bay nu taganan iligtas yan Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Agyan na mani tulisan na impaku êt sa kurus, inuyam laya êt. ");
INSERT INTO blx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sên ugtuy na, dinumiglêm ma babun luta anggay nan alas tres kaawat. ");
INSERT INTO blx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sên pamaka alas tres kaawat, masnêg sinabin Jesus, “Eli, Eli, lema sabachthani?” Ya labay sabin, “Bapa ku, Bapa kun Namalyari, siyan pinaulayan muku yata?” ");
INSERT INTO blx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sên nalêngên mani nakaidêng bayduy abiin, sinabi lay, “Pambêgên na si propeta Elias.” ");
INSERT INTO blx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tambêng nuwayuy gisa kalla buy niptês paran bulak sa gisay sanga. Imbasa na sa nangisuy alak buy impasêpsêp kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nuwa sinabin kaatag, “Paulayên muya. Elêwên tamu nu lumatêng yabay si Elias amên iligtas ya.” ");
INSERT INTO blx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nanguman nagsabin masnêg si Jesus buy nabuytuwan yan inawanên. ");
INSERT INTO blx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sa uras êt abitu, naginit ta panabing sa lalên Templu paubat sa babu angga sa aypa. Nallayun buy nangapapakay dapas. ");
INSERT INTO blx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nibuklat ta mani pamilbêngan buy nanguman nabyay ya malakêy banal la tawu. ");
INSERT INTO blx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nag-awas sila sa pamilbêngan. Buy sên nanguman nabyay si Jesus, naku sila sa Jerusalem. Kabay nakitan silan malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ya kapitan buy mani sundalus na ya mamantay kan Jesus, sên nallayun buy sên nakit lay mani nalyari, nalimu sila. Sinabi la, “Pêtêg awêd ya Anak yan Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sa narayun pêrad, dilag malakêy babayi ya mangêlêw nu sabêt ta malyari kan Jesus. Sabay silay mani babayi ya nakilaku buy naglingkud kan Jesus sabitun namita ya sa Galilea. ");
INSERT INTO blx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kaawyun kalla si Maria ya taga Magdala, si Maria ya indu lan Santiago buy si Jose buy ya asawan Zebedeo. ");
INSERT INTO blx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sên nadêm mana, inlumatêng si Jose ya gisay mabandi ya taga Arimateay tagasunul êt Jesus. ");
INSERT INTO blx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Naku ya kan Gobernador Pilato ta inyawad nay bangkay Jesus. Buy in-utus Gobernador Pilatoy idin kanay abiin. ");
INSERT INTO blx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kabay kingwan Jose ya bangkay buy binêdbêdan nan telay naputi. ");
INSERT INTO blx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Insun nay ati sa bayun pamilbêngan na inlubtan na dapas ya impadyag na. Pamakayari, imbulid nay gisay maragul la batuy panakêp nan lawasan pamilbêngan bayu ya namita. ");
INSERT INTO blx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria ya taga Magdala buy gisa pun êt ta Maria, nakaiknu sila sa arapan pamilbêngan. ");
INSERT INTO blx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pamakawasak, sa Allun Pagpaynawa, nakuy mani mamunun pari buy mani Pariseo kan Gobernador Pilato. ");
INSERT INTO blx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Sinabi la, “Gobernador, naganaka yan na sabitun nabyay pun na mapamilitêp, sinabi nay ‘Pamakayarin tatluy allu, mabyay yakun manguman.’ ");
INSERT INTO blx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kabay panyawarên yan na ipabantay muy pinilbêngan kana angga sa ikatluy allu. Dat limêdên mani tagasunul nay bangkay na buy ibalitan nabyay ya. Nu malyari ya abiin, luyang na pun mailitêp pa mani tawu kaysa sabitun nuna.” ");
INSERT INTO blx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nuwa nakitbay si Gobernador Pilato kalla, “Mangwa kaw mani sundalus buy sikaw tay mamipabantay mangêd.” ");
INSERT INTO blx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kabay naku sila sa pamilbêngan buy binyanan lan tanda' ya nakatakêp baydu amên matandan la nu dilag mamibuklat. Buy nibalag silan dakun umnuy magbantay. ");
INSERT INTO blx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sên mawatwat tan allun Duminggu, pamakalibas Allun Pagpaynawa, naku sa pinilbêngan kan Jesus si Maria ya taga Magdala, kaawyun nay gisa êt ta Maria amên êlêwên na pinilbêngan kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bêngat tan nallayun malakas, ta gisay Ang-el Panginuun na ubat sa langit ta nibulid batuy pinanakêp sa pinilbêngan buy iniknuwan na. ");
INSERT INTO blx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ya lupa na, nanuwad kimat ta makasilêw buy naputiputi ya yaming na. ");
INSERT INTO blx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sên nakit mani sundalus ya magbantay sa pinilbêngan ya ang-el, sadyay limu la. Kabay namilapil buy nitugaw silan paray nan nati. ");
INSERT INTO blx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sinabin ang-el sa mani babayi, “Agana kaw malimu! Tanda kuy pantêkapên yu si Jesus ya impaku sa kurus. ");
INSERT INTO blx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ayin nina baydi. Nanguman ninan nabyay kaparisun sinabi na kamuyu. Kaksaw kaw, ta êlêwên yuy pinipakalêkan bangkay na. ");
INSERT INTO blx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kamutun yun lakwên na mani tagasunul na buy sabin yu kallay nabyay ya buy muna ya sa Galilea. Buy makit yuya baydu. Kay abiin tanay masabi ku kamuyu.” ");
INSERT INTO blx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kinamut namitan luway babayi sa pinilbêngan ya dilag limu buy tula. Nuwayu silan naku sa mani tagasunul amên ibalita lay nalyari. ");
INSERT INTO blx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kaban mamita sila, bêngat ta silan timbêng Jesus. Buy sinabi na kallay, “Nagpapakun kawna?” Kabay nagdani sila, dinukpan lay bitis na buy nangulimên kana. ");
INSERT INTO blx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sinabin Jesus kallay, “Agana kaw malimu. Lakwên yuy mapatêl ku buy sabin yu kallay maku sila sa Galilea. Baydu laku makitan.” ");
INSERT INTO blx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pamakabitan mani babayi sa pamilbêngan, naku sa balayan na dakun umnuy bantay sa pamilbêngan buy imbalita la sa mani mamunun pari ya kaganawan nalyari. ");
INSERT INTO blx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pamakayari, nititipun na mani mamunun pari buy mani mangatway manungkulan amên pikasunduwan lan suulan maragul la alagay mani bantay. ");
INSERT INTO blx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Sinabi la sa mani bantay, “Ibalita yuy kaban mamabêlêw kaw saybi, inlumatêng nga mani tagasunul Jesus buy inlimêd lan kingway bangkay na. ");
INSERT INTO blx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nu matandan man Gobernador ya abiin, sikay yay baalan magsabi kana amên a kaw dakun mapakun.” ");
INSERT INTO blx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tinanggap mani bantay ya pera. Pamakayari, sinabi êt mani bantay ya pan-ipasabi kalla. Kabay angga amêsên, abiin pun êt ta pan-iwagaw mani Judio. ");
INSERT INTO blx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Amêsên, ya mapu buy gisay tagasunul Jesus, naku sila sa gisay bung-uy ya sinabin Jesus kalla. ");
INSERT INTO blx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sên nakitan la si Jesus, nangulimên sila kana, nuwa dilag êt dakun umnu kallay magluway nakêm nu sabay siya si Jesus. ");
INSERT INTO blx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nagdani si Jesus buy sinabi na kalla, “Indin na kangkuy kaganawan kapangyarian sa langit buy sa luta. ");
INSERT INTO blx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kabay lakwên yuy mani tawu sa kaganawan layi buy daygên yu silan mani tagasunul ku. Bawtismuwan yu sila sa lagyun Bapa, sa Anak buy sa Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Turwanan yu silan manunul sa kaganawan mani in-utus ku kamuyu. Pakalêngê kaw. Pawa yukun kaawyun angga sa katganan babun luta.”");
INSERT INTO blx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Ati ya Mangêd da Balita tungkul kan Panginuun Jesu Cristu ya Anak Bapan Namalyari. Nag-umpisay Mangêd da Balita sabitun natupad da insulat Propeta Isaias ya daygên Bapan Namalyari, “Dilag gakun gisay iutus ya muna kamu amên mil-an danan mu. ");
INSERT INTO blx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sabay siyay mamibêg sa kakyangan na magsabin, ‘Il-an yuy danan Panginuun. Itinêk yuy balang danan na.’ ” ");
INSERT INTO blx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Amêsên, natupad da abiin sên inlumatêng si Juan ya Mamawtismu sa kakyangan. In-aral na sa mani tawuy, “Pagsisyan buy itgên yuy panyag kasalanan buy magpabawtismu kaw amên patawarên kaw Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kabay malakêy taga Judea buy taga balayan Jerusalem ya naku kan Juan ya Mamawtismu. Insabi lay mani kasalanan la buy binawtismuwan silan Juan sa Ilug Jordan. ");
INSERT INTO blx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ya yaming Juan, diyag sa sabut kamelyu buy diyag sa balat ayup pa yakês na. Ya pangkanên na, durun buy pulut panilan. ");
INSERT INTO blx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pawa nan pansabin sa pangaral nay, “Dilag gisay lumatêng nga makapangyarian pun kangku. A ku sêpat mantan sandalyas na. ");
INSERT INTO blx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Pambawtismuwan kataw sa lanêm, nuwa bawtismuwan nakaw sa Ispiritun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sa panawun abitu, inlumatêng si Jesus ubat sa balayan Nazaret sa prubinsyan Galilea buy nagpabawtismu ya kan Juan sa Ilug Jordan. ");
INSERT INTO blx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pamakasalwang Jesus sa lanêm, nakitan nay nawang-at ta langit buy nagtabuy kanay Ispiritun Bapan Namalyari ya nanuwad gisay pati-pati. ");
INSERT INTO blx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Buy dilag gisay tunuy ya ubat sa langit ta nagsabin, “Sikay kakaidwan kun Anak ya kapapaidu kangku.” ");
INSERT INTO blx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pamakayarin abitu, impalaku yan Ispiritun Bapan Namalyari sa kakyangan. ");
INSERT INTO blx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Sa lalên apattapuy allu, pantuksun yan Satanas. Dilag êt baydun mangasilêb ba ayup buy dilag êt baydun mani ang-el la naglingkud kana. ");
INSERT INTO blx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sên nakasukul si Juan, naku si Jesus sa prubinsyan Galilea buy in-aral nay Mangêd da Balita ubat kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Sinabi na, “Inlumatêng nganay intakday panawun na mag-ari ya si Bapan Namalyari! Kabay pagsisyan yinay mani kasalanan yu buy maniwala kaw sa Mangêd da Balita.” ");
INSERT INTO blx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kaban mamita si Jesus sa agid lawan Galilea, nakitan nay mipatêl la silan Simon buy si Andres ya mamisamwag dala la ta ubra lay mandakêp kênan lanêm. ");
INSERT INTO blx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sinabin Jesus kalla, “Kilaku kaw kangku, ta daygên kataw mamipakaranin tawu kan Bapan Namalyari amên manampalataya sila kaparisun pandakêp yun kênan lanêm.” ");
INSERT INTO blx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tambêng lan imbalag ga dala la buy nakilaku sila kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sa pamitan Jesus, nakitan nay mani anak Zebedeo ya silan Santiago buy si Juan ya idi sa bangka ya mamipakapalan dala la. ");
INSERT INTO blx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tambêng silan binêg Jesus. Kabay inlakwanan lay bapa la sa bangka ya kaawyun mani tawuy pan-upan la, ta nakilaku sila kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Naku silan Jesus sa balayan Capernaum. Sa Allun Pagpaynawa, sinumun si Jesus sa balin pagtipunan mani Judio buy nangaral ya baydu. ");
INSERT INTO blx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nakaupapas ya mani tawu tagawan nakit lay dilag yan kapangyarian sa pangaral na, asê kaparisun pangaral mani manurun Kautusan. ");
INSERT INTO blx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kaban mangaral si Jesus sa mani tawu baydu sa balin pagtipunan mani Judio, dilag gisay liyaki ya sinêdakan nadawak ka ispiritu ");
INSERT INTO blx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ya masnêg magsabin, “Jesus ya taga Nazaret, sabêt ta daygên mu kanyan? Naku ka nayi baydi amên upudun kay? Tanda yan ka nu sisabêt ka! Sikay Banal la in-utus Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nuwa sinabyanan Jesus ya nadawak ka ispiritu, “Mangimbêk ka buy magtas kana!” ");
INSERT INTO blx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sên anti, pinakusadkusad yan nadawak ka ispiritu buy kapan-angaw-angaw nag-awas kana. ");
INSERT INTO blx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nakaupapas ya kaganawan tawuy idi baydu. Kabay nipapatang sila, “Sabêt ta ati? Bayun aral la dilag kapangyarian! Agyan na nadawak ka ispiritu, mapasunul na sa utus na.” ");
INSERT INTO blx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kabay tambêng niwagaw wa balita tungkul kan Jesus sa buun Galilea. ");
INSERT INTO blx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pamakasalwang lan Jesus sa balin pagtipunan mani Judio, naku sila sa bali lan Simon buy si Andres, kaawyun na silan Santiago buy si Juan. ");
INSERT INTO blx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nalatêng lay bakêt ta ampun Simon na nakakalêk gawan umutun. Kabay tambêng lan sinabi kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nagdani si Jesus sa babayi buy tinalan nay gamêt na. Impaimata naya buy inumiyul ya. Kabay nidêng ya buy pinakan na silan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sên nitanglêw way mamut, gintan mani tawu kan Jesus ya kaganawan nipagsakit buy sinêdakan nadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nitipun na sadyay lakên tawu sa lawasan balin Simon. ");
INSERT INTO blx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Namaiyul si Jesus sa malakêy tawuy dilag magmikakanayun na sakit buy namitas yan nangadawak ka ispiritu sa malakêy tawu. A na tinulutan magsabi ya nadawak ka ispiritu, tagawan tanda lay siyay Anak Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sên bunatbunat tana, namitay na si Jesus. Naku ya sa kakyangan buy nanalangin. ");
INSERT INTO blx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tingkap yan Simon buy mani kaawyun na. ");
INSERT INTO blx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sên nakitan laya, sinabi la, “Manuru, pantêkapên kan malakêy tawu!” ");
INSERT INTO blx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nuwa sinabin Jesus kalla, “Lakwên tamu pun na kasunul la lugal amên ipatanda ku êt kallay Mangêd da Balita tagawan abiin na sangkan pamaku ku baydi sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kabay naku yan nangaral sa mani balin pagtipunan mani Judio sa buun prubinsyan Galilea buy namipatas yan nangadawak ka ispiritu sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dilag gisay liyaki ya nagsakit ketung ya nagdani kan Jesus. Nanduku ya buy nakilunuslunus kan Jesus buy sinabi na, “Nu labay mun kayêk, paiyulun muku.” ");
INSERT INTO blx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nalunus si Jesus kana. Kabay dinukpan naya buy sinabi na, “Labay ku. Umiyul kayna!” ");
INSERT INTO blx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tambêng yan inumiyul buy inluminis ya lawini na. ");
INSERT INTO blx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pamakayarin abitu, pinabitan Jesus ya liyaki buy masipit nan intipan na, ");
INSERT INTO blx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Agana mu sabin agyan kansabêt ta nalyari kamu, nun a maku ka sa pari buy ipaêlêw muy lawini mu ya inumiyul lana. Pamakayari, mag-andug ka ayun sa insulat Moises bilang pagpapêtêg ga inumiyul kayna.” ");
INSERT INTO blx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nuwa namitay liyaki buy imbalita nay nalyari kana. Sên niwagaw wa nalyari sa liyaki, asina makasun si Jesus sa balayan gawan nu makitan yan mani tawu, pagsêksêkan laya. Kabay nanugêl ya tana sa kakyangan, nuwa pallakwên yapun êt mani tawuy ubat sa mani kaatag lugal. ");
INSERT INTO blx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pamakayarin dakun umnuy allu, nag-udung si Jesus sa balayan Capernaum. Nabalitan mani tawuy idi ya sa bali. ");
INSERT INTO blx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kabay nititipun na malakêy tawu sa binyanan nay bali buy ayin nan danan sa lawasan gawan malakê êt ta tawu. Kaban mangaral si Jesus sa Sabin Bapan Namalyari, ");
INSERT INTO blx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","dilag inlumatêng nga apat ta liyaki ya manambayuk gisay liyaki ya lumpu. Idani laya dayi kan Jesus, ");
INSERT INTO blx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","nuwa gawan malakêy tawu, a sila midani. Kabay nagdakêy sila tana sa bubungan bali buy inlubtan lay atêp sa ugtun Jesus bayu la impakanawan inyêpay liyaki ya lumpu sa arapan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sên nakitan Jesus ya maragul la panampalataya la kana, sinabi na sa liyaki ya lumpu, “Anak kuway, pinatawad day mani kasalanan mu.” ");
INSERT INTO blx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dilag êt baydun nakaiknuy manurun Kautusan na mangisip paradi, ");
INSERT INTO blx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Siyan magsabi yan parabaysên ta? Pallamusun naya si Bapan Namalyari ta! Ayin kaatag mamatawad kasalanan, nun a kay si Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nuwa tandan Jesus ya pan-isipin la. Kabay sinabi na kalla, “Awta mangisip kaw yan parabaysên ta? ");
INSERT INTO blx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mas nalêp-aw sabin sa liyaki ya lumpuy, ‘Pinatawad danay mani kasalanan mu’, gawan a yu makit nu pinatawad o asê. Nuwa sabin ku kanay, ‘Midêng ka, gêtan muy kalapayan mu buy mita ka’ ");
INSERT INTO blx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","amên makitan yuy sikuy ubat sa langit ta in-Anak Tawu, dilag gakun kapangyarian baydi sa babun lutan mamatawad mani kasalanan.” Sinabi na sa liyaki ya lumpu, ");
INSERT INTO blx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Midêng ka, gêtan muy kalapayan mu buy muli kayna!” ");
INSERT INTO blx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nidêng nga liyaki, insapat nay kalapayan na buy nakitan kaganawan na pamita na. Kabay nakaupapas sila buy nangulimên kan Bapan Namalyari buy sinabi la, “Babayu kay pun nakakit paradi.” ");
INSERT INTO blx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Gisay allu, nanguman naku si Jesus sa agid lawan Galilea. Nakilaku kanay malakêy tawu buy tinurwanan na sila. ");
INSERT INTO blx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kaban mamita ya, nakitan na si Levi ya anak Alfeo ya nakaiknu sa pamayaran buwis. Sinabin Jesus kana, “Kilaku ka kangku.” Kabay nidêng si Levi buy nakilaku kana. ");
INSERT INTO blx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Buy insagyat Levin mangan si Jesus buy mani tagasunul na sa bali na. Malakê êt ta maningil buwis buy mani makasalanan na kaêm lan mangan, tagawan malakêy nakilaku kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dilag êt baydun Pariseoy manurun Kautusan. Sên nakitan lay makiawyun mangan si Jesus sa mani maningil buwis buy sa kaatag pun mani makasalanan, pinatang lay mani tagasunul na, “Uysiyan makiawyun yan mangan sa mani maningil buwis buy sa kaatag pun mani makasalanan ta?” ");
INSERT INTO blx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sên nalêngên Jesus ya abitu, sinabi na, “Asê mangaylangan manuluy ayin sakit, nun a abituy tawuy nagsakit. Naku waku baydi amên bêgên na mani makasalanan, alwan abitu silay mani tawuy magsabin ayin silan kasalanan.” ");
INSERT INTO blx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gisay allu, nag-ayunuy mani tagasunul Juan ya Mamawtismu buy mani Pariseo. Dilag nagdani kan Jesus buy namatang, “Uysiyan mag-ayunuy tagasunul Juan ya Mamawtismu buy mani Pariseo ta, pakan mani tagasunul muy a yata?” ");
INSERT INTO blx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kabay in-alimbawan Jesus ya sarili na sa liyaki ya pan-itangên, “Malyari nayin mag-ayunuy mani bisita sa tangênan pakan kaawyun la pun na liyaki ya pan-itangên? Asê! ");
INSERT INTO blx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nuwa lumatêng nga alluy kêwên kallay liyaki ya pan-itangên. Sa panawun abiin, baydu sila pun mag-ayunu.” ");
INSERT INTO blx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sinabin Jesus kallay mani paalimbawa, “Ayin mamilanib bayuy yaming sa manan yaming. Tagawan nu daygên nay abitu, mikuyum ma bayuy yaming, mapaktang nga manan yaming buy luyang dumagul la ginit. ");
INSERT INTO blx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ayin êt mamitiis bayuy alak sa manan pamyanan na diyag sa balat, tagawan matlês ya pamyanan buy mibulug ga alak. Parisu silan masayang! Nuwa ya bayuy alak, sêpat itiis sa bayuy pamyanan.” ");
INSERT INTO blx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gisay Allun Pagpaynawa, nagdan silan Jesus sa nagtrigu. Kaban magdan sila baydu, nanggutus ya mani tagasunul nan tilalagay trigu. ");
INSERT INTO blx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kabay sinabin mani Pariseo kana, “Elêwên muy pandaygên mani tagasunul mu. Uysiyan pallabagên la yay Kautusan tungkul sa Allun Pagpaynawa ta?” ");
INSERT INTO blx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sinabin Jesus, “A yu pun nayi nabasay dinyag David sabitun inlayang ya buy mani kaawyun na buy nangaylangan silan kanên? ");
INSERT INTO blx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sinumun ya sa Tolday Pagsimban, nangwa yan tinapay ya in-andug kan Bapan Namalyari, kinnan na buy pinakan na êt ta mani kaawyun na, agyan idi sa Kautusan ya kay mani pari ya dilag karapatan mangan abitu.” Nalyari ya abiin sabitun si Abiatar ya pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Insundun Jesus ya pagsabi na sa mani Pariseo. Sinabi na, “Ya Allun Pagpaynawa, dinyag para sa ikakangêd mani tawu. Asê dinyag ga tawu para sa ikakangêd Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kabay sikuy ubat sa langit ta in-Anak Tawuy makapagsabi nu sabêt ta mangêd daygên sa Allun Pagpaynawa.” ");
INSERT INTO blx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gisay allu, nanguman sinumun si Jesus sa balin pagtipunan mani Judio. Dilag gisay liyaki bayduy nati ya gisay gamêt. ");
INSERT INTO blx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dilag êt mani tawuy mamakaillag kan Jesus. Ta nu paiyulun nay liyaki sa Allun Pagpaynawa, dilag silan maisangkan laban kana. ");
INSERT INTO blx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sinabin Jesus sa liyaki ya nati ya gisay gamêt, “Kaksaw ka baydi sa arapan.” ");
INSERT INTO blx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sinabi na kalla, “Sabêt ta pantulutan Kautusan sa Allun Pagpaynawa? Manyag mangêd o manyag nadawak? Miligtas o mamati?” Nuwa a sila nakitbay. ");
INSERT INTO blx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pinakaêlêw Jesus un dilag suluk ka mani tawuy nakapalitêng kana buy nalêlêy nakêm na gawan sa kakdêyan bêkê la. Inuman nan inêlêw wa liyaki buy sinabi na, “Ipaktang muy gamêt mu.” Kabay impaktang liyaki ya gamêt na buy inumiyul yabay. ");
INSERT INTO blx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tambêng namitay mani Pariseo buy naku sa mani tawun Gobernador Herodes Antipas buy pinisasabyan la nu parasaantu lan maipapati si Jesus. ");
INSERT INTO blx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Namita si Jesus buy mani tagasunul na buy naku sila sa danin lawa. Kinamat yan sadyay lakên tawuy ubat sa Galilea buy ubat sa Judea, ");
INSERT INTO blx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","sa balayan Jerusalem, sa prubinsyan Idumea, sa mapaglipay ilug Jordan, buy sa palitêng balayan Tiro buy balayan Sidon gawan nabalitan lay kaganawan dinyag Jesus. ");
INSERT INTO blx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kabay nipal-an bangka si Jesus sa mani tagasunul na ya pagsakayan na amên a ya mapiit malakêy tawu, ");
INSERT INTO blx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","tagawan namaiyul yan malakê. Kabay pinagsêksêkan yan kaganawan tawuy nipagsakit amên madukpan laya. ");
INSERT INTO blx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Balang tawuy sinêdakan nadawak ka ispirituy nakakit kana, nipaglukub sa arapan na buy masnêg lan sinabi, “Sikay Anak Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nuwa impakasipit intipan Jesus kallay “Agana yu ipatanda sa kaatag nu sisabêt taku.” ");
INSERT INTO blx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pamakayari, sinumukpa silan Jesus sa bung-uy. Binêg nay balang pinili na buy nagdani sila kana. ");
INSERT INTO blx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Namili yan mapu buy luwa ya pambêgên nan apostul amên makaawyun nan iutus mitan mangaral. ");
INSERT INTO blx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Binyanan na silan kapangyarian mamipatas mani nadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ati ya mapu buy luway pinili na, si Simon na pinalagyunan nan Pedro, ");
INSERT INTO blx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ya anak Zebedeo ya silan Santiago buy si Juan na pinalagyunan nan Boanerges ya labay sabin mani anak kilat, ");
INSERT INTO blx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","silan Andres, Felipe, Bartolome, Mateo, Tomas, Santiago ya anak Alfeo, si Tadeo buy si Simon na manalangsang sa gubernun Roma, ");
INSERT INTO blx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","buy si Judas Iscariote ya sabay ya nisupakat kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sên nuli ya si Jesus, nanguman nagtipun na malakêy tawu. Kabay asina makadambin mangan Jesus buy mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sên nabalitan mani kaawyun na sa bali, inlaku laya amên iuli, gawan pansabin mani tawuy tinulaw ya. ");
INSERT INTO blx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Dilag mani manurun Kautusan na ubat sa Jerusalem ya nagsabin, “Pansêdakan yan Satanas ya puun nangadadawak ka ispiritu ya sabay ya nam-in kapangyarian kanan mamipatas nangadadawak ka ispiritu.” ");
INSERT INTO blx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kabay impadanin Jesus ya mani tawu buy nangalimbawa ya kalla, “Ipakun ipatas Satanas ya sarili na? ");
INSERT INTO blx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nu mitutubag ga mani tawu sa gisay kaarian, asê mapêng nga kaarian. ");
INSERT INTO blx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Buy nu mitutubag êt ta gisay pamilya, asê êt mapêng nga pamiaawyun la. ");
INSERT INTO blx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Para êt baydu, nu pagkapatin Satanas ya pansakupun na, asê êt mapêng ya panakup na.” ");
INSERT INTO blx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ayin malyarin makasun sa balin gisay tawuy napas-êy kaynu dilag pun mas napas-êy kana. Buy nu naigapus sinan mas napas-êy pun kana, masunan na bali na buy matakaw wa pibandiyan na.” ");
INSERT INTO blx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Pansabin ku kamuyuy malyarin mapatawad da kaganawan kasalanan buy pallamus. ");
INSERT INTO blx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nuwa nu sisabêt man na mallamus sa Ispiritun Bapan Namalyari, ayina mapatawad. Asê mitas ya kasalanan na agyan kanu pun.” ");
INSERT INTO blx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sinabin Jesus ya abiin gawan pansabin kaatag, “Pansêdakan yan nadawak ka ispiritu.” ");
INSERT INTO blx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Amêsên, inlumatêng nga indu buy mapatêl Jesus. Nuwa kay nakaidêng sila sa lawasan. Kabay impabêg laya. ");
INSERT INTO blx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sa lalên bali malakêy tawuy nakaiknuy nakapalitêng kan Jesus. Dilag nagsabi kanan, “Idi sa lawasan na indu mu buy mapatêl mu. Pan-ipabêg laka.” ");
INSERT INTO blx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kabay sinabin Jesus, “Sisabêt ta indu ku buy mapatêl ku?” ");
INSERT INTO blx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nangêlêw ya sa balang nakaiknuy nakapalitêng kana buy sinabi na, “Ati ya mani indu ku buy mapatêl ku. ");
INSERT INTO blx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tagawan nu sisabêt man na manunul sa kalabayan Bapan Namalyari, sabay silay indu ku buy mapatêl ku.” ");
INSERT INTO blx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nanguman nanuru si Jesus sa agid lawan Galilea. Sa sadyay lakên tawuy nititipun kana, nagsakay ya sa bangka buy niknu ya baydun nangaral. Ya mani tawuy naman, idi sila sa agid lawa. ");
INSERT INTO blx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Malakêy paalimbaway in-aral na kalla. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Lêng-ên yuy ati! Dilag gisay manggitnay namibulaglag bini. ");
INSERT INTO blx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sa pamibulaglag na, dilag mani bini ya nangananabu sa dan. Inlumatêng nga mani uybun manuk buy tinuktuk lay mani bini. ");
INSERT INTO blx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dilag êt mani bini ya nangananabu sa mabatuy lugal la ayin mayngan luta. Tambêng tinumubuy mani bini gawan nalayab ba luta. ");
INSERT INTO blx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nuwa sên naasnagan mamut ta ati, nawangêy sila, gawan ayin silan pukat pagyamutan. Kabay nangamamati sila. ");
INSERT INTO blx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dilag êt mani bini ya nangananabu sa pantubwanan têmak ka madiwi. Sên inlumabung nga bini, inlumabung êt ta têmak ka madiwi buy kinêlkêlan nay mani bini ya tinumubu. Kabay asê namukat nanagêy. ");
INSERT INTO blx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ya kaatag, nangananabu sa mangêd da luta. Tinumubu buy dinumagul la mani abiin buy nanagêy. Ya kaatag, nanagêy titlumpu, ya kaatag, tianêmmapu buy ya kaatag êt, tidinalan na lasi.” ");
INSERT INTO blx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sinabi êt Jesus, “Sikaw wa mani mallêngê, pakaisipin yuy nalêngê yu.” ");
INSERT INTO blx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sên namitay nay malakêy tawu, nitagan na mapu buy luway tagasunul na buy kaatag pun tagasunul na. Namatang sila kana nu sabêt ta labay sabin abituy paalimbawa na. ");
INSERT INTO blx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sinabin Jesus kalla, “Impaintindi kamuyuy nakaliim tungkul sa pag-arin Bapan Namalyari nuwa sa kaatag, pawan paalimbaway pan-isabi ku kalla ");
INSERT INTO blx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","amên ‘Kapangêlêw-êlêw laman, a sila makakit buy kapallêngê-lêngê laman, a sila makapukat. Ta nu makapukat sila, dat magsisi sila sa kasalanan la buy patawarên silan Bapan Namalyari.’ ” ");
INSERT INTO blx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Buy sinabin Jesus kalla, “Nu a yu mapukatan na ati ya paalimbawa, ipakun yun mapukatan na kaatag paalimbawa? ");
INSERT INTO blx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ati ya labay sabin paalimbawa. Ya bini ya pan-ibulaglag manggitna, sabay ya Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ya dan na kinapinabwan bini, sabay ya mani tawuy nallêngên Sabin Bapan Namalyari. Nuwa tambêng inlumatêng si Satanas buy intas nay Sabin Bapan Namalyari sa bêkê la. Kabay inliwan layna. ");
INSERT INTO blx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ya mabatuy lutay kinapinabwan bini, sabay ya mani tawuy nallêngê sa Sabin Bapan Namalyari buy tambêng lan tinanggap dilag tula. ");
INSERT INTO blx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nuwa asê napêng nga ati gawan asê nipakatêbêk sa bêkê lay Sabin Bapan Namalyari. Kabay sên inlumatêng nga kasakitan o pamasakit gawan sa Sabin Bapan Namalyari, tambêng lan tinalibatukan ya panampalataya la.” ");
INSERT INTO blx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ya lutay pantubwanan têmak ka madiwi nu saantu nanabuy kaatag bini, sabay ya mani tawuy nallêngên Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nuwa gawan sa mani pangganakên baydi sa babun luta, ya paglabay lan bumandi buy pagnasa sa kaatag pun bagay, nalitêpan lay Sabin Bapan Namalyari. Kabay asê nanagêy sa biyay la. ");
INSERT INTO blx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nuwa ya mangêd da lutay kinapinabwan bini, sabay ya mani tawuy nallêngê buy nananggap sa Sabin Bapan Namalyari. Kabay nanagêy silan titlumpu, tianêmmapu buy tidinalan.” ");
INSERT INTO blx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sinabi pun Jesus kalla, “Ayin tawuy mamagkêt sulu ya itagu na sa aypan pamisêmpanan na o sa silung papag, nun a idin na sa pêtêg pamyanan. ");
INSERT INTO blx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta ayin pan-itaguy asê miwagaw buy ayin pan-iliim ma asê matandan. ");
INSERT INTO blx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sikaw wa mani mallêngê, pakaisipin yuy nalêngê yu.” ");
INSERT INTO blx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sinabi na pun, “Pakausisên yuy nalêngê yu. Ya panukad da panggamitin yu sa kaatag sabay êt ta panukad da gamitin kamuyu buy igit pun baydu. ");
INSERT INTO blx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ya tawuy manunul sa malêngê nay kapêtêgan, biyan yapun êt pangintindi. Nuwa ya tawuy asê manunul sa malêngê nay kapêtêgan, agyan pêrad nan pangintindi, itas pun êt kana.” ");
INSERT INTO blx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sinabi pun Jesus kalla, “Ya pag-arin Bapan Namalyari, maiparisu sa dinyag gisay manggitnay nibulaglag bini. ");
INSERT INTO blx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pamakayari nan nibulaglag bini, mamabêlêw ya nu yabi buy nu alluy naman, mag-ubra ya. Kabay ya bini ya imbulaglag na, tinumubu buy dinumagul agyan a na tanda nu dakun parasaantu. ");
INSERT INTO blx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ya luta sabay ya mamatubun mani bini sa panggitnan. Munan magsalwang nga tubu bayu magsalwang nga bulung, pamakayari managêy yinan mani lasi. ");
INSERT INTO blx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Buy nu nawtuy nay lasi, tambêng palutun manggitna gawan panawun nan pamipupul.” ");
INSERT INTO blx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sinabi pun Jesus kalla, “Saantu tamu maiparisuy pag-arin Bapan Namalyari? Sabêt ta alimbaway gamitin amên maipakit tamuy ati? ");
INSERT INTO blx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maiparisu sa gisay but-un mustasay pinakanabêlêng sa kaganawan but-u. ");
INSERT INTO blx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nuwa nu itanêm mina, dumagul ya buy maragul yapun sa kaatag panggulayên buy pakadyag yan paran puun kayu. Kabay ya mani sangan ati, mapanyagan salay mani uybun manuk.” ");
INSERT INTO blx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Malakê pun êt ta paalimbaway ginamit Jesus sa pangaral nan Sabin Bapan Namalyari sa mani tawu, nuwa ayun sa pangintindi la. ");
INSERT INTO blx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A ya nanuru sa mani tawun asê nanggamit paalimbawa. Nuwa sên kakapad la tana buy mani tagasunul na, sinabi nayna kalla ya kaganawan labay nan sabin. ");
INSERT INTO blx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sên yabi yana, sinabin Jesus sa mani tagasunul na, “Maglipay kitamina sa lawa.” ");
INSERT INTO blx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kabay inlakwanan mani tagasunul nay mani tawu buy nagsakay sila sa gisay bangka ya pinagsakayan Jesus. Dilag êt kaatag bangka ya nanunul kalla. ");
INSERT INTO blx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Amêsên, bêngat tan inlumakas ya angin buy pansipwakan mangaragul la alun ya bangka la. Kabay nayi-nayin mapnuwan lanêm ma bangka la. ");
INSERT INTO blx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Si Jesus, mamabêlêw yan nakaulunan sa êtêb tawlin bangka. Kabay pinêw yan mani tagasunul na, “Manuru, mimata ka! Milêmlêm kitamina! A ka nayi napitik ka mati kitamina?” ");
INSERT INTO blx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nimata si Jesus buy in-utus nay angin, “Tunggên ka!” Buy sinabi na sa alun, “Magpatêtbêk ka!” Kabay tinunggên na angin buy namatêtbêk ka alun. ");
INSERT INTO blx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pinatang nay mani tagasunul na, “Alwa ta malimu kaw yata? Ayin kaw pun nayin panampalataya kangku?” ");
INSERT INTO blx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nakatanam silan sadyay limu. Kabay nisasabi ya balang gisa kalla, “Sisabêt ta atiyê? Siyan mapatgên na yay angin buy alun ta!” ");
INSERT INTO blx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sên inlumatêng silan Jesus sa lipay lawa sa lugal mani tawuy pambêgên lan Geraseno, ");
INSERT INTO blx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","nagtabuy si Jesus sa bangka. Timbêng yan gisay liyaki ya sinêdakan nadawak ka ispiritu ya ubat sa lêyang nga pamilbêngan. ");
INSERT INTO blx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Baydu yan manugêl sa pamilbêngan. Ayin malyarin makagapus kana, agyan tanikala pun na gamitin. ");
INSERT INTO blx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Katiumnu lay nan pan-itanikalay gamêt buy bitis na, nuwa mabuytu na pun êt. Ayin makabênbên kana, agyan sisabêt. ");
INSERT INTO blx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allu buy yabi yan nagtapan sa pamilbêngan buy kapan-angaw-angaw na sa nangatutung-uy. Buy pansugatên nan batuy lawini na. ");
INSERT INTO blx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Marayu pun si Jesus, nakitan ninan liyaki. Kabay nuwayu yan nagdani kan Jesus buy nanduku sa arapan na. ");
INSERT INTO blx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Sinabin Jesus, “Nadawak ka ispiritu, magtas ka sa tawun abiin!” Kabay masnêg nan sinabi, “Jesus ya Anak Bapan Namalyari ya Katatag-ayan, sabêt ta daygên mu kangku? Makisabi yaku kamu sa lagyun Bapan Namalyari, agana muku pasakitan.” ");
INSERT INTO blx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pinatang yan Jesus, “Sabêt ta lagyu mu?” Kabay nakitbay ya, “Libulibu, tagawan malakê kay.” ");
INSERT INTO blx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nakilunuslunus ya nangadadawak ka ispiritu kan Jesus ya agana sila ipatas sa lugal la abitu. ");
INSERT INTO blx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dilag malakêy babuy ya manabêl baydu sa bung-uy. ");
INSERT INTO blx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kabay nakilunuslunus ya nangadadawak ka ispiritu kan Jesus, “Ipalaku mukay tana sa mani babuy ta magsêdak kay kalla.” ");
INSERT INTO blx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kabay sinabin Jesus kalla, “Dali kawna, magsêdak kawna sa mani babuy!” Nagtas ya nangadawak ka ispiritu sa liyaki buy nagsêdak sila sa luway libuy babuy. Nipamwayuy mani babuy buy nanabu sa bêngaw. Kabay nangalulumud sila sa lawa. ");
INSERT INTO blx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nuwayuy mani manaysay babuy papakun sa balayan buy sa karanin baryu buy imbalita lay nalyari. Kabay naku bayduy mani tawu amên êlêwên la nu sabêt ta nalyari. ");
INSERT INTO blx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sên nagdani sila kan Jesus, nakitan lay liyaki ya tinasan nan nadawak ka ispiritu ya nakaiknuy na, nakayaming ngina buy mamangêd day isip na. Kabay nalimwan mani tawu sa mani nalyari. ");
INSERT INTO blx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ya mani tawuy nakakit sa dinyag Jesus, ingkuwentu la sa mani tawuy naku baydu nu sabêt ta nalyari sa liyakin abitu buy sa mani babuy. ");
INSERT INTO blx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kabay pikisabyan la si Jesus ya magtas sina sa lugal la. ");
INSERT INTO blx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Buy sên magsakay ya si Jesus sa bangka, nakisabi kanay liyaki ya tinasan nan nadawak ka ispiritu, “Kilaku waku dayi kamu.” ");
INSERT INTO blx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nuwa alwan parabayduy labay Jesus, nun a sinabi na, “Muli ka sa mani kamag-anak mu buy ibalita mu kallay dinyag Panginuun kamu buy nu para nakasaantun kinalunusan.” ");
INSERT INTO blx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kabay namitay liyaki buy imbalita na sa Decapolis ya dinyag Jesus kana buy nakaupapas ya kaganawan nakalêngên abitu. ");
INSERT INTO blx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kabay sên nag-udung si Jesus sa lipay lawa, nanguman nagtipun kanay malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Inlumatêng bayduy gisay liyaki ya naglagyun Jairo ya gisa sa mani mamunu sa balin pagtipunan mani Judio. Pamakakit na kan Jesus, nanduku ya sa arapan na. ");
INSERT INTO blx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nakilunuslunus ya kana, “Marani yan mati ya anak kuy dalagita. Nu malyari dayin kayêk, lakwên muya buy ipaluntu muy gamêt mu kana amên umiyul ya buy a ya mati!” ");
INSERT INTO blx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kabay nakilaku si Jesus kan Jairo. Malakêy tawuy nakilaku kanay nipipiitan. ");
INSERT INTO blx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dilag gisay babayi bayduy mapu buy luway tawun nan dayên. ");
INSERT INTO blx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Gawan sa matanam na, malakêy nay kasakitan na nadanasan na. Malakêy nay nanulu kana buy naubus say kaganawan pibandiyan na. Nuwa a ya inumiyul, nun a naluyang pun na matanam na. ");
INSERT INTO blx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Sên nalêngê nay pamaiyul Jesus sa anak Jairo, sinabi na sa nakêm na, “Madukpan kuta dayi ya yaming na, umiyul lakina.” Kabay nakipiit yan nagdani sa bukut Jesus buy dinukpan na ya yaming na. ");
INSERT INTO blx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sên nadukpan nay yaming Jesus, tambêng tinunggên na pagdaya na buy natanam nay inumiyul ya. ");
INSERT INTO blx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tambêng natanam Jesus ya inumawas ya kapangyarian na. Kabay nangawing ya sa mani tawu buy namatang, “Sisabêt ta nandukpan yaming ku?” ");
INSERT INTO blx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nakitbay ya mani tagasunul na, “Manuru, sadyay lakên tawuy nipipiitan kamu, siyan ipatang muya pun kanyan nu sisabêt ta nandukpan yaming mu ta?” ");
INSERT INTO blx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nuwa inêlêw-êlêw nay nakapalitêng kana nu sisabêt ta nandukpan yaming na. ");
INSERT INTO blx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Gawan tandan babayi ya nalyari kana, nalimu ya buy pumilapil yan nanduku sa arapan Jesus buy sinabi nay dinyag na buy nu sabêt ta nalyari kana. ");
INSERT INTO blx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kabay sinabin Jesus kana, “Anak kuway, inumiyul ka gawan sa panampalataya mu kangku. Muli kaynan napatêtbêk ka nakêm, ta inumiyul kayna.” ");
INSERT INTO blx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kaban magsabi pun si Jesus, dilag dakun umnuy inlumatêng nga ubat sa balin Jairo ya mamunu sa balin pagtipunan mani Judio. Sinabi la kan Jairo, “Nati yanay anak mu. A mina kaylangan abalên na Manuru.” ");
INSERT INTO blx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nuwa asê inlêngên Jesus ya sinabi la. Sinabi na kan Jairo, “Agana ka malimu. Kay manampalataya ka kangku.” ");
INSERT INTO blx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kabay namita silaynan naku sa balin Jairo, nuwa ayin yan kaatag pikilaku, nun a kay silan Pedro buy ya mipatêl ya silan Santiago buy Juan. ");
INSERT INTO blx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sên inlumatêng sila sa balin Jairo, nakit Jesus ya maguguluy malakêy tawu. Dilag manangis buy dilag man-alab. ");
INSERT INTO blx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sên sinumun ya sa bali, sinabi na kalla, “Siyan manangis buy man-alab kaw yata? Asê nati ya anak, kay mamabêlêw ya!” ");
INSERT INTO blx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Gawan sa sinabi na, inuyam laya. Kabay pinasalwang nay kaganawan tawu sa bali. Kay tagasunul na buy mangatwan anak ka pikilaku nan sinumun sa binyanan abituy anak. ");
INSERT INTO blx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tinalan nay gamêt anak buy sinabi, “Talita kum,” ya labay sabin, “Anak kuway, mimata ka.” ");
INSERT INTO blx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tambêng nimatay anak buy namita. Kabay nakaupapas ya mani tawu. Ya idad un anak, mapu buy luway tawun. ");
INSERT INTO blx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nuwa masipit intipan Jesus kallay a la sabin agyan kansabêt ta nalyari. Pamakayari, sinabin Jesus kalla, “Pakan yuya.” ");
INSERT INTO blx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Namita si Jesus sa lugal abitu. Naku ya sa Nazaret sa balayan na kinaragulan na, kaawyun nay mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sên Alluy nan Pagpaynawa, sinumun ya sa balin pagtipunan mani Judio buy nangaral ya baydu. Malakêy nallêngê kana ya nakaupapas sa balang sinabi na. Sinabi la, “Saantu nan nakway kabiyasnan na? Sabêt ta kabiyasnan na indin kana? Buy parasaantu yan nakadyag mamakaupapas? ");
INSERT INTO blx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pakan kay kalpinteru ya buy ya indu na, si Maria buy ya mapatêl na sabay silan Santiago, Jose, Judas, buy si Simon buy ya mapatêl nay babayi, kay kabaryu tamu êt?” Kabay kinasêman laya. ");
INSERT INTO blx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Amêsên, sinabin Jesus kalla, “Ya gisay propeta, panggalangên ya agyan dakun saantuy lugal, liban tana sa sarili nan balayan, kamag-anak buy pamilya.” ");
INSERT INTO blx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ayin yan nadyag ga mamakaupapas baydu liban sa dakun umnuy nipagsakit ta pinaluntuwan nan gamêt buy inumiyul. ");
INSERT INTO blx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nakaupapas ya gawan a sila manampalataya kana. Amêsên, nangaral si Jesus sa mani sakup balayan Nazaret. ");
INSERT INTO blx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Binêg nay mapu buy luway tagasunul na buy in-utus na silan tilwatilwa. Binyanan na silan kapangyarian mamipatas nangadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Intipan na kallay, “Sa pamita yu, agana kaw mantan dakun sabêt, agyan kanên, susut o pera. Magtêkên kaw tana. ");
INSERT INTO blx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kay mag-isteping kaw buy agana kaw mantan yaming nga pangalili yu.” ");
INSERT INTO blx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sinabi pun êt Jesus, “Nu pinasun kaw sa gisay bali, baydu kaw tana manugêl angga sa pamita yu sa lugal la abitu. ");
INSERT INTO blx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nu a lakaw tanggapên buy nu a kaw lêng-ên mani tawu sa gisay lugal, sa pamita yu, ikampag yuy abu sa bitis yu bilang pamipatanda kalla ya nadawak ka dinyag la.” ");
INSERT INTO blx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kabay namitay nay mapu buy luway tagasunul na. Sinabi la sa mani tawu, “Pagsisyan buy itgên yuy panyag kasalanan!” ");
INSERT INTO blx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Namipatas silan malakêy nadawak ka ispiritu buy pinunwan lan laruy malakêy nipagsakit buy inumiyul. ");
INSERT INTO blx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Natandan Gobernador Herodes Antipas ya tungkul kan Jesus, gawan pikatandan ya agyan dakun saantu. Dilag magsabin, “Siya si Juan ya Mamawtismu ya nanguman nabyay. Kabay mamakadyag yan mamakaupapas.” ");
INSERT INTO blx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nuwa pansabin kaatag, “Sabay siya si propeta Elias.” Dilag êt magsabin, “Gisa ya sa propetay kaparisun propeta sabitun nuna.” ");
INSERT INTO blx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sên nalêngên Gobernador Herodes Antipas ya pansabin la, sinabi na, “Si Juan na abiin ya impaputus kinay ulu nuwa nanguman nabyay!” ");
INSERT INTO blx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ati ya nalyari nu parasaantun impapatin Gobernador Herodes Antipas si Juan ya Mamawtismu. Si Gobernador Herodes Antipas, pinag-asawa na si Herodias ya asawan Felipe ya patêl un Herodes. Pawan pansabin Juan kanay, “Asê ustuy pinag-asawa muy asawan patêl mu.” Kabay impadakêp Gobernador Herodes Antipas si Juan, impagapus buy impasukul na. ");
INSERT INTO blx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nisêêmsêêm si Herodias kan Juan. Kabay labay nayan ipapati, nuwa a na madyag, ");
INSERT INTO blx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","gawan pan-itanggul Gobernador Herodes Antipas si Juan buy panggalangên naya, ta tanda nay matinêk si Juan buy banal. Paraman baydu, labaylabay nan lêng-ên si Juan agyan napitik-pitik ka nakêm na sa pansabin Juan. ");
INSERT INTO blx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amêsên, nagkalutu si Gobernador Herodes Antipas amên ganakên na allun pamianak kana. Insagyat nay mani nipagtungkulan buy mani puun sundalus buy ya mani tawuy pikatandan baydu. Abiin na panawun na pan-êtêngên Herodias amên maipapati na si Juan. ");
INSERT INTO blx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sên uras san kalutu, sinumun na anak Herodias ya babayi buy nanalêk ya. Kabay natulatula si Gobernador Herodes Antipas buy mani bisita na buy sinabin Gobernador sa dalaga, “Yawarên mu kangkuy agyan sabêt ta labay mu ta idin ku kamu.” ");
INSERT INTO blx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Buy sinabi na, “Manumpa kun idin ku kamuy agyan sabêt ta yawarên mu kangku, agyan kapitna pun kaarian ku.” ");
INSERT INTO blx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nagsalwang yan nakun namatang sa indu na, “Sabêt ta yawarên ku?” Kabay sinabi na, “Ulun Juan ya Mamawtismu.” ");
INSERT INTO blx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tambêng nag-udung nga dalaga kan Gobernador Herodes Antipas buy sinabi na, “Labay kun idin mu amêsên kangkuy ulun Juan ya Mamawtismu ya idi sa gisay pambusku.” ");
INSERT INTO blx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sadyay lungkut Gobernador Herodes Antipas. Nuwa gawan sa pangakuy nalêngên mani bisita, a ya malyarin paaku sa dalaga. ");
INSERT INTO blx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kabay tambêng nan impalaku sa sukulan na gisay mamatin tawu amên putusun na ulun Juan. Kabay nakuy mamatin tawu sa sukulan buy pinutus nay ulun Juan. ");
INSERT INTO blx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Indin na ulun Juan sa gisay pambusku buy inggawang sa dalaga. Buy inggawang êt dalaga sa indu na. ");
INSERT INTO blx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sên nabalitan tagasunul Juan na nalyari kana, kingwa lay bangkay na buy in-ilbêng. ");
INSERT INTO blx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Amêsên, nag-udung nga mani apostul Jesus ya in-utus nan mangaral buy ingkuwentu la kanay kaganawan dinyag la buy in-aral la. ");
INSERT INTO blx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gawan malakêy tawuy magmililiwas lumatêng, a layna madambin mangan. Kabay sinabin Jesus sa mani tagasunul na, “Lakwanan tamu pun na mani tawu. Maku kitamu pun sa gisay lugal kakyangan amên makapagpaynawa.” ");
INSERT INTO blx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kabay nagsakay sila sa bangka buy naku sa gisay lugal kakyangan. ");
INSERT INTO blx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nuwa malakêy nakakit buy nakatanda sa pamita la. Kabay naunan silan malakêy tawuy ubat sa magmikakanayun na balayan ya kay namaras namita papakun sa lakwên lan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sên nagtabuy si Jesus sa bangka, nakitan nay sadyay lakên tawu. Nalunus ya kalla tagawan para silan tupay ayin magpastul. Buy tinurwanan na silan malakêy bagay. ");
INSERT INTO blx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sên mitanglêw way mamut, nagdani kan Jesus ya mani tagasunul na buy sinabi la, “Idi kitamu sa kakyangan na lugal buy mitanglêw way mamut. ");
INSERT INTO blx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kabay ipalaku minay mani tawu sa nangarani ya panggitnan buy baryu amên makasaliw silan maêkan la.” ");
INSERT INTO blx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nuwa nakitbay si Jesus kalla, “Sikaw wa mam-in maêkan la.” Kabay sinabi la kana, “Labay mu nayin sikay ya makun manaliw tinapay ya ipakan kalla? Ya alagan abiin, luwan dalan na dinaryu.” ");
INSERT INTO blx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kabay namatang si Jesus, “Umnuy gintan yuy tinapay? Elêwên yu.” Sên nakitan la, sinabi la kan Jesus, “Lilimay tinapay buy luluway kênan lanêm.” ");
INSERT INTO blx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kabay sinabin Jesus sa mani tagasunul na, “Paiknun yu sa lamun na mani tawu un pustu-pustu.” ");
INSERT INTO blx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kabay niknu silan pustu-pustun tidinalan buy tilimampu. ");
INSERT INTO blx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kingwan Jesus ya limay tinapay buy luway kênan lanêm. Pamakayari, nangêlêw ya sa langit buy nagpasalamat kan Bapan Namalyari. Binis-ilbis-il nay tinapay buy pinutus-putus nay kênan lanêm buy indin na sa mani tagasunul na. Indin êt mani tagasunul na sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nakaêkan na kaganawan tawu buy nabsuy. ");
INSERT INTO blx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sên tinipun lay mani tagan na tinapay buy kênan lanêm, napakapnu la pun êt ta mapu buy luway salikap. ");
INSERT INTO blx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ya bilang mani lawyaki ya nakaêkan, limay libu. ");
INSERT INTO blx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kaban pan-ipaulin Jesus ya mani tawu, impasakay na sa bangka ya mani tagasunul na buy impauna nan maglipay sa Bethsaida. ");
INSERT INTO blx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","47","Sên nakabitay nay mani tawu, sinumukpa yan kakapad na sa bung-uy amên manalangin. Nayabinan nayna baydu buy ya bangkan mani tagasunul na, idi yana sa bunak lawa. ");
INSERT INTO blx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nakitan nay magkasakit ta mani tagasunul na sa pagsagwan, gawan masabangan silan angin. Sên bunatbunat tana, nangamat si Jesus sa mani tagasunul na un mamita ya sa babun lanêm. Libasan na dayi sila. ");
INSERT INTO blx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nuwa sên nakit mani tagasunul nay dilag mamita sa babun lanêm, nan-angaw sila sa sadyay limu, gawan indap la nu anitu. Kabay tambêng nagsabi si Jesus kalla, “Sikuy ati, agana kaw malimu. Pas-êyên yuy nakêm yu.” ");
INSERT INTO blx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sên pamakasakay na sa bangka, tambêng tinunggên na angin. Kabay sadyay upapas la. ");
INSERT INTO blx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ta agyan nakit lay nay mamakaupapas ya dinyag na sa tinapay buy sa kênan lanêm, a la pun êt mapukatan, gawan nakdêy ya bêkê la. ");
INSERT INTO blx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sên pamakalipay la sa lawa, nilatêng sila sa lugal Genesaret. Baydu la in-itgên buy in-is-êl la bangka la. ");
INSERT INTO blx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Buy sên nagtabuy silayna sa bangka, tambêng nakilalan mani tawu si Jesus. ");
INSERT INTO blx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pinaras mani tawun impatanday inlumatêng nga si Jesus sa lugal abitu. Kabay agyan antuy kabalitanan la nu idi saantu si Jesus, pan-isapat lay nipagsakit ya idi sa kakalêkan la. ");
INSERT INTO blx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Buy agyan antuy sunan nay baryu o balayan o panggitnan, pan-igtan lay balang nipagsakit sa palengki. Buy makilunuslunus sila kana ya agyan kay madukpan lay palpal yaming na. Buy inumiyul la kaganawan nakadukpa kana. ");
INSERT INTO blx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Dilag mani Pariseo buy mani manurun Kautusan na inlumatêng ubat sa Jerusalem buy nagdani kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nakitan lay dakun umnuy tagasunul Jesus ya nangan un asê nanunul sa naugalyan pipuunpuunan tungkul sa pag-uyas gamêt. ");
INSERT INTO blx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gawan ya mani Judio buy mani Pariseo, a sila makaêkan un asê nag-uyas gamêt, bilang tandan panunul la sa naugalyan pipuunpuunan la. ");
INSERT INTO blx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Buy nu naubat sila sa palengki, mag-uyas sila pun gamêt bayu la kanên na agyan dakun sabêt ta nasaliw la. Malakê pun na naugalyan na pansunulun la, kaparisun panguyas mani kulu, pitsil buy kudên na tangsu. ");
INSERT INTO blx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kabay pinatang mani Pariseo buy mani manurun Kautusan si Jesus, “Uysiyan a ya pansunulun mani tagasunul muy naugalyan mani pipuunpuunan tamu tungkul sa pag-uyas gamêt ta?” ");
INSERT INTO blx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kabay nakitbay si Jesus kalla, “Pêtêg ga impasulat Bapan Namalyari kan propeta Isaias tungkul kamuyun mapagtalingkayu. Ta idi sa kasulatan, ‘Panggalangên nakun mani tawun ati nuwa kay sa sabi la, tagawan marayu kangkuy bêkê la. ");
INSERT INTO blx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ayin kapukatan na pangulimên la kangku, gawan na pan-ituru la, kay utus tawu.’ ” ");
INSERT INTO blx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Pandaygên yun ayin kapukatan na Kautusan Bapan Namalyari ta ya pansunulun yu, abituy naugalyan mani pipuunpuunan yu.” ");
INSERT INTO blx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sinabi êt Jesus, “Kabiyasnan yinan manyag ayin pukat sa Kautusan Bapan Namalyari amên kay masunul yuy mani naugalyan mani pipuunpuunan yu! ");
INSERT INTO blx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Impasulat Bapan Namalyari kan Moises, ‘Galangên muy mangatwa mu,’ buy ‘Sisabêt man na mandustak sa mangatwa na, sêpat yan patin!’ ");
INSERT INTO blx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nuwa sikaw, siyan pan-iaral yu yay malyarin sabin anak sa mangatwa nay ‘Mangatwa kuway, ya sawup pa idin ku dayi kamuyu, in-il-an kina kan Bapan Namalyari.’ ");
INSERT INTO blx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sa pakapakun baydu, imbawal yu silaynan manawup sa mangatwa la. ");
INSERT INTO blx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Pandaygên yun ayin kapukatan na utus Bapan Namalyari gawan sa panunul yu sa naugalyan mani pipuunpuunan yu. Buy malakê pun na pandaygên yuy parabaysên.” ");
INSERT INTO blx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nanguman impadanin Jesus ya mani tawu buy sinabi na kalla, “Mallêngê kaw kaganawan kangku buy pakaintindin yuy sabin ku. ");
INSERT INTO blx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Alwan mansumun sa bêbêy tawuy makapadinat kana, nun a ya nadawak ka sabi ya man-umawas sa bêbêy na. ");
INSERT INTO blx_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Sikaw wa mallêngê, pakaisipin yuy abiin!” ");
INSERT INTO blx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pamakayari, inlakwanan Jesus ya mani tawu buy sinumun ya sa bali kaawyun na mani tagasunul na. Pamakasun la, impatang mani tagasunul nay tungkul sa labay sabin paalimbawa na. ");
INSERT INTO blx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sinabin Jesus kalla, “Sikaw êt, a yu êt nayi mapukatan? A yu nayi tanday agyan sabêt ta kanên tawu, alwan abituy makapadinat kana? ");
INSERT INTO blx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Gawan agyan sabêt ta kanên na, asê sumun sa bêkê na, nun a bituka nay naman na sunan buy iawas nay ati. Sên sinabin Jesus ya abiin, impatanda na ya kaganawan maêkan, malyari tamun kanên.” ");
INSERT INTO blx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sinabi pun êt Jesus, “Ya mani nadawak ka sabi ya man-umawas sa bêbêy tawu sabay ya makapadinat kana. ");
INSERT INTO blx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gawan maubat sa bêkên tawuy pangisip nan nadawak ya sabay ya mitustus kanan mampêl, manakaw, mamati, ");
INSERT INTO blx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","makikanayun, masaklaw, buy manyag kaganawan kadawakan kaparisun pamurayit, kalaswaan, pangasêm, pagsabin nadawak laban sa kaparisu, pamagmatag-ay, buy ayin pukat ta pangisip. ");
INSERT INTO blx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Abiin na kaganawan kadawakan, ubat sa bêkên tawu ya sabay ya makapadinat kana.” ");
INSERT INTO blx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Namita baydu si Jesus buy naku ya sa mani lugal la marani sa balayan Tiro. Nagdaus ya baydu sa gisay bali. Asê labay Jesus ya matandan yan mani tawuy idi ya baydu, nuwa natandan laya pun êt. ");
INSERT INTO blx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Dilag gisay babayi bayduy nag-anak sinêdakan nadawak ka ispiritu. Ya babayin ati, Griego ya buy taga Sirofenicia. Sên natandan nay pallumatêng Jesus, tambêng yan naku kan Jesus buy nanduku yan nakilunuslunus sa arapan na amên ipatas ya nadawak ka ispirituy nagsêdak sa anak na. ");
INSERT INTO blx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nuwa sinabin Jesus kanay gisay panabin, “Sêpat pun pakabsuyun na mani anak. Asê mangêd da kêwên na kanên mani anak buy idin sa mani asu.” ");
INSERT INTO blx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nakitbay ya babayi, “Pêtêg ga Panginuun, nuwa agyan na mani asuy idi sa silung lamesa, mangan silan saksak ya mangainêgnêg anak.” ");
INSERT INTO blx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sinabin Jesus kana, “Gawan sa sinabi mu, malyari kaynan muli. Inlakwanan nan nadawak ka ispirituy anak mu.” ");
INSERT INTO blx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nuli ya babayi buy nalatêng nay anak nay babayi sa kakalêkan na ya inlakwanan nan nadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sên namita si Jesus ubat sa lugal Tiro, dinuman ya sa Sidon buy inlibut nay mani lugal la sakup Decapolis, pamakayari nagdaus ya sa agid lawan Galilea. ");
INSERT INTO blx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Gintan mani tawu kanay liyaki ya asê makalêngê buy asê mayngan makasabi. Panyawarên la kan Jesus ya ipaluntu na sa liyaki ya gamêt na amên umiyul. ");
INSERT INTO blx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Impakarayu pun Jesus ya liyaki sa malakê bayu na impasun na mani galamay na sa mani têk abituy liyaki ya asê kalêngê. Pamakayarin abitu, tinupayan nay mani galamay na buy intalan na sa dilan abituy liyaki. ");
INSERT INTO blx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nangêlêw si Jesus sa langit bayu ya nakaupus. Sinabi na sa liyaki, “Effata,” ya labay sabin, “Mawang-at!” ");
INSERT INTO blx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pamakayarin abitu, nakalêngê buy nakapagsabin mangêd da liyaki. ");
INSERT INTO blx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Intipan Jesus sa mani tawuy agana ibalitay nalyari. Nuwa agyan tinipanan na sila, siyan ingkakadus lan imbalitay abiin. ");
INSERT INTO blx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sa sadyay upapas la, nasabi lay, “Aw-indêkê! Mangêd da dinyag na. Makalêngêy nay asê kalêngê buy makapagsabi yay pipi.” ");
INSERT INTO blx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Inlumibas ya dakun umnuy allu, nanguman nagtipun na malakêy tawu sa binyanan Jesus. Gawan ayin silaynan maêkan, binêg Jesus ya tagasunul na buy sinabi na, ");
INSERT INTO blx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Malunus saku sa mani tawun ati, gawan tatluy allu ku silaynan kaawyun buy ayin silaynan maêkan. ");
INSERT INTO blx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu paulin ku silan layangên, dat mablay sila sa dan, gawan na kaatag, ubat pun sa marayu.” ");
INSERT INTO blx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kabay nakitbay ya mani tagasunul na, “Antuy pangwanan tamun kanên baydi sa kakyangan amên ipakan kalla?” ");
INSERT INTO blx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kabay pinatang na sila, “Umnuy tinapay yu baysên?” Nakitbay sila, “Pitu.” ");
INSERT INTO blx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pinaiknun Jesus ya mani tawu sa luta. Kingwa nay pituy tinapay buy nagpasalamat ya kan Bapan Namalyari. Pamakayari, binis-ilbis-il nay tinapay buy indin sa mani tagasunul na amên idin la sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dilag êt dakun umnuy nangabêlêng nga kênan lanêm. Impasalamat êt Jesus ya ati buy in-utus na sa mani tagasunul nay idin sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nakaêkan na kaganawan buy nabsuy. Sên tinipun lay mani tagan na kanên, napakapnu la pun êt ta pituy salikap. ");
INSERT INTO blx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ya bilang mani tawuy nangan, apat ta libu. Pamakayarin abitu, pinaulin Jesus ya mani tawu. ");
INSERT INTO blx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pamakayari, nagsakay ya sa bangka kaawyun nay mani tagasunul na buy naku sila sa lugal Dalmanuta. ");
INSERT INTO blx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pamakalatêng la baydu, nagdani ya mani Pariseo buy nakisubakan sila kan Jesus. Labay layan subukan. Kabay inyawad la kanay mipakit yan mamakaupapas bilang tanda' ya in-utus yan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nakaupus si Jesus buy sinabi na kalla, “Awta sikaw wa mani tawu amêsên, manyawad kaw mamakaupapas bilang tanda' ya in-utus sakun Bapan Namalyari? Pansabin ku kamuyuy ayin dakun sabêt man na ipakit kamuyuy tanda'.” ");
INSERT INTO blx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pamakayari, inlakwanan na sila buy nagsakay ya sa bangka kaawyun na mani tagasunul na buy naku sa lipay dagat. ");
INSERT INTO blx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naliwan mani tagasunul Jesus ya mantan tinapay, nuwa dilag gisay tinapay sa bangka. ");
INSERT INTO blx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sinabin Jesus kalla, “Mangillag kaw sa pamalbag mani Pariseo buy si Gobernador Herodes Antipas.” ");
INSERT INTO blx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nisasabi ya mani tagasunul Jesus, “Sinabi nay abitu gawan ayin kitamun gintan na tinapay.” ");
INSERT INTO blx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nuwa tandan Jesus ya pansabin la. Kabay pinatang na sila, “Awta siyan pisasabyan yu yay ayin kaw gintan na tinapay ta? A kaw pun nayi makapukat? Ta siyan nakdêy pun êt ta mani ulu yu? ");
INSERT INTO blx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Dilag kaw mata, uysiyan a yuya nakit ta? Dilag kaw têk, uysiyan a yuya nalêngê ta? A yina nayi maganaka ");
INSERT INTO blx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ya sabitun binis-ilbis-il kuy limay pirasun tinapay ya impakan sa limay libuy tawu? Umnuy salikap pa napakapnu yu sa tagan na tinapay?” Nakitbay sila, “Mapu buy luwa.” ");
INSERT INTO blx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sên binis-ilbis-il kuy tinapay ya impakan sa apat ta libuy tawu, umnuy salikap pa napakapnu yu sa mani tagan na kanên?” Nakitbay sila, “Pitu.” ");
INSERT INTO blx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kabay sinabin Jesus kalla, “A yu pun nayi mapukatan?” ");
INSERT INTO blx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pamakalatêng la sa Bethsaida, dilag gisay liyaki ya bulag ga gintan umnuy tawu kan Jesus. Pikilunuslunus la kan Jesus ya dukpan naya amên makakit ya. ");
INSERT INTO blx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kabay tinambay Jesus ya bulag pasalwang sa Bethsaida. Pamakalatêng la baydu sa lawasan, inlawayan Jesus ya matan bulag buy indukpa nay gamêt na sa bulag buy pinatang naya, “Makakit kayna nayi?” ");
INSERT INTO blx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nangêlêw wa liyaki buy sinabi na, “Makakit takun tawu, nuwa siyan paran puun kayuy mamita.” ");
INSERT INTO blx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kabay indukpan manguman Jesus ya gamêt na sa matan bulag. Pamakayarin abitu, nanguman nangêlêw wa liyaki. Sên nangêlêw yabay, inumiyul ya buy malinaw naynan makitan ya kaganawan. ");
INSERT INTO blx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bayu ya pinaulin Jesus, tinipanan naya, “Agana kayna duman sa Bethsaida.” ");
INSERT INTO blx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pamakayari, inlakun Jesus buy mani tagasunul na ya mani baryu ya marani sa balayan Cesarea Filipos. Kaban mamita sila, pinatang Jesus ya mani tagasunul na, “Sisabêt taku kanu sabin mani tawu?” ");
INSERT INTO blx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nakitbay sila, “Dilag magsabin sika si Juan ya Mamawtismu. Dilag êt magsabin sika si propeta Elias. Ya kaatag êt, magsabin gisa ka sa mani propeta.” ");
INSERT INTO blx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pinatang silan Jesus, “Nuwa kamuyu, sisabêt taku?” Nakitbay si Pedro, “Sabay sika ya Cristu.” ");
INSERT INTO blx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tinipanan silan Jesus, “Agana yu sabin agyan kansabêt man.” ");
INSERT INTO blx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Paubat baydu, in-aral Jesus sa mani tagasunul nay, “Sikuy ubat sa langit ta in-Anak Tawu, kaylangan kun madanasan na malakêy pamasakit. Isakwil lakun mani mangatway manungkulan buy mani mamunun pari buy mani manurun Kautusan. Ipapati laku nuwa sa ikatluy allu, manguman nakun mabyay.” ");
INSERT INTO blx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Intusêk na sa mani tagasunul nay abiin. Sên nalêngên Pedro, pikilaku na si Jesus sa gisay agid buy pinagkasabi naya. ");
INSERT INTO blx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nuwa nag-arap si Jesus sa mani tagasunul na buy sinabyanan na si Pedro, “Magpakarayu ka kangkuy Satanas! Ta alwan kalabayan Bapan Namalyari ya pan-isipin mu, nun a ya kalabayan tawu.” ");
INSERT INTO blx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kabay impadanin Jesus kanay mani tawu buy mani tagasunul na. Sinabi na kalla, “Sisabêt man na kalabay manunul kangku, sêpat nan liwanên na sarili nan kalabayan buy nakal-an yan mati gawan sa panunul na kangku kaparisun pamakay kurus buy manunul ya kangku. ");
INSERT INTO blx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tagawan sisabêt man na tawuy maglabay miligtas ya biyay na, sabay ya matasan. Nuwa ya tawuy nakal-an mam-in biyay na para kangku buy sa Mangêd da Balita, sabay ya mabiyan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Agyan makwan gisay tawuy kaganawan pibandiyan baydi sa babun luta, nuwa mipakabili ya sa ayin katganan na kaparusan, a nayna mapagnabang nga ati. ");
INSERT INTO blx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dilag ya nayin maibayad amên mabiyan yan biyay ya ayin katganan? ");
INSERT INTO blx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nu ikadêng-êy yuku buy ya pan-iaral ku sa arapan mani asê tapat kan Bapan Namalyari buy mani makasalanan sa panawun ati, sikuy in-Anak Tawuy ubat sa langit, ikadêng-êy kataw êt sa pag-udung ku baydi ya idi kangkuy kapangyarian Bapan Namalyari buy kaawyun kuy mani banal la ang-el.” ");
INSERT INTO blx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sinabi pun êt Jesus kallay paradi, “Pansabin ku kamuyuy dilag dakun umnu kamuyuy asê mati anggan a la makitan na makapangyarian na pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pamakayarin anêm ma allu, pikilakun Jesus silan Pedro, Santiago buy si Juan sa gisay matag-ay ya bung-uy. Kakapad la ta baydu. Sên idi silayna baydu, nakit lay nagbayuy wangis Jesus. ");
INSERT INTO blx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ya yaming na, pinupumuti buy mamakasilêw êlêwên. Ayin malyarin makapaputin yaming na baydi sa babun luta. ");
INSERT INTO blx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nagpakit baydu si Elias buy si Moises ya makisabi kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sinabin Pedro kan Jesus, “Manuru, mangêd da idi kitamu baydi. Manyag kay tatluy sawung. Gisa kamu, gisa kan Moises buy gisa kan Elias.” ");
INSERT INTO blx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Asê tandan Pedro nu sabêt ta sêpat nan sabin tagawan sadyay limu la. ");
INSERT INTO blx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pamakayari, natugpawan silan ulap buy dilag silan nalêngêy gisay tunuy ubat sa ulap pa magsabin, “Ati ya kakaidwan kun Anak. Mallêngê kaw kana!” ");
INSERT INTO blx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sên nangêlêw sila sa palitêng la, ayin silaynan kaatag nakitan nun a kay si Jesus. ");
INSERT INTO blx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kaban manlumunsan sila sa bung-uy, intipan Jesus kallay, “Agana yu sabin agyan kansabêt man na nakitan yu anggan a ku manguman mabyay ya in-Anak Tawuy ubat sa langit.” ");
INSERT INTO blx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kabay idi tana sa nakêm lay sinabin Jesus. Nuwa sên kakapad la tana, nipapatang sila nu sabêt ya labay sabin manguman mabyay. ");
INSERT INTO blx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kabay pinatang la si Jesus, “Uysiyan pansabin yan mani manurun Kautusan na kaylangan munan lumatêng si Elias bayu si Cristu ta?” ");
INSERT INTO blx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Nakitbay si Jesus, “Pêtêg ga dilag munan lumatêng nga kaparisun Elias amên il-an nay kaganawan bagay. Nuwa pansabin ku kamuyuy inlumatêng ngay kaparisun Elias buy dinyag lay labay lan daygên kana kaparisun nakasulat sa kasulatan tungkul kana. Nuwa idi êt sa kasulatan na sikuy ubat sa langit ta in-Anak Tawu, makadanas sakun kasakitan buy pustakên nakun mani tawu.” ");
INSERT INTO blx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sên nag-udung silan Jesus sa binyanan kaatag pun êt ta tagasunul na, nakitan lay malakêy tawuy nakapalitêng kalla buy dilag êt mani manurun Kautusan na makisubakan kalla. ");
INSERT INTO blx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sên nakit mani tawu si Jesus, nakaupapas sila. Kabay nuwayu silan nananggap kana. ");
INSERT INTO blx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pinatang Jesus ya mani tagasunul na, “Sabêt ta pisusulakan yu?” ");
INSERT INTO blx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nakitbay ya gisay liyaki baydu sa malakê, “Manuru, gintan ku baydi kamuy anak kuy liyaki ya asê makapagsabi tagawan sinêdakan yan nadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nu sêdakan yan nadawak ka ispiritu, mipakalêk ya buy magbulabulay bêbêy na buy mingêngêt buy kumtang ya. Inyawad ku sa mani tagasunul muy ipatas lay nadawak ka ispiritu nuwa a la naipatas.” ");
INSERT INTO blx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sinabin Jesus kallay, “Sikaw wa mani tawu amêsên na ayin panampalataya! Anggan makanu kataw pun pibabatan? Gêtan yu baydi ya anak.” ");
INSERT INTO blx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kabay gintan lay anak kan Jesus. Nuwa pamakakit nadawak ka ispiritu kan Jesus, kinumtang nga anak buy nipakalêk yan nitulintulin buy magbulabulay bêbêy. ");
INSERT INTO blx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pinatang Jesus ya bapan anak, “Nakanu yapun sinêdakan nadawak ka ispiritu?” Nakitbay ya bapa na, “Paubat pun sa nabêlêng ya. ");
INSERT INTO blx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pawa nayan itugaw sa apuy buy sa lanêm amên patin. Kabay nu dilag kan madyag, malunus ka kanyan buy sawpan mukay kayêk.” ");
INSERT INTO blx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nakitbay si Jesus, “Siyan sinabi mu yay nu dilag gakun madyag ta? Ya kaganawan bagay, madyag sa tawuy dilag panampalataya.” ");
INSERT INTO blx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tambêng masnêg sinabin bapa un abituy anak, “Manampalataya ku, nuwa kulang pun! Dagdagan mu pun na panampalataya ku!” ");
INSERT INTO blx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sên nakit Jesus ya inlumakêy tawu, tinubag nay nadawak ka ispiritu, “Sikay nadawak ka ispirituy mamapipi buy asê mamakalêngê, pan-ipatas kata sa anak! Buy agana kayna mag-udung kana!” ");
INSERT INTO blx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kabay nan-angaw wa nadawak ka ispiritu buy nangkusadkusad da anak buy nagtas ya nadawak ka ispiritu. Paran nati yay anak. Kabay sinabin mani tawuy, “Nati yina!” ");
INSERT INTO blx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nuwa tinalan Jesus ya gamêt anak buy impaidêng naya. ");
INSERT INTO blx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sên sinumun si Jesus sa bali, liim yan pinatang mani tagasunul na, “Uysiyan a yan ya naipatas ya nadawak ka ispiritu ta?” ");
INSERT INTO blx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kabay nakitbay si Jesus, “Ya paradi ya nadawak ka ispiritu, kay maipatas ya sa kapamilatan panalangin.” ");
INSERT INTO blx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Amêsên, namita sila baydu buy dinuman sa prubinsyan Galilea. A labay Jesus ya matandan mani tawuy idi ya baydu ");
INSERT INTO blx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tagawan panturwanan nay mani tagasunul na. Sinabi na, “Sikuy ubat sa langit ta in-Anak Tawu, igawang ngaku sa mani nipagtungkulan buy patin laku. Nuwa sa ikatluy allu, manguman nakun mabyay.” ");
INSERT INTO blx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nuwa a la mapukatan na sinabi na buy malimu sila êt mamatang kana. ");
INSERT INTO blx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Inlumatêng sila sa Capernaum. Sên idi silayna sa gisay bali, pinatang Jesus ya mani tagasunul na, “Sabêt ta pisusulakan yu sa dan?” ");
INSERT INTO blx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A sila nakapakitbay gawan pisusulakan la nu sisabêt kallay pinakadakila. ");
INSERT INTO blx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kabay niknu si Jesus buy binêg nay mapu buy luway tagasunul na buy sinabi na kallay, “Sisabêt kamuyuy kalabay magin mamunu, sêpat yan magpaubatan buy magin ipus kaganawan.” ");
INSERT INTO blx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Impadani nay gisay anak ka nabêlêng buy impaidêng sa arapan la. Nasên anti, inampun nay ati buy sinabi na kalla, ");
INSERT INTO blx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sisabêt man na mananggap sa paradi ya nabêlêng nga anak gawan sa panunul na kangku, sikinay pantanggapên na. Buy ya mananggap kangku, alwan kay sikuy pantanggapên na, nun a ya namiutus êt kangku.” ");
INSERT INTO blx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sinabin Juan kan Jesus, “Manuru, dilag kay nakitan na mamipatas nangadawak ka ispiritu sa lagyu mu. Imbawal yan ya gawan a tamu ya kaawyun.” ");
INSERT INTO blx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nuwa sinabin Jesus, “Agana yuya bawalên, ta ya tawuy manyag mamakaupapas sa kapamilatan lagyu ku, a ya magsabin nadawak tungkul kangku. ");
INSERT INTO blx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta ya asê mallumaban kantamu, kapanig tamu ya. ");
INSERT INTO blx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pansabin ku kamuyuy nu sisabêt man na mam-i kamuyun gisay basun lanêm tagawan tagasunul kataw, pilmin makatanggap yan gantimpalay ubat kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Sisabêt man na magin sangkan pangasalanan nangabêlêng nga anak ya manampalataya kangku, mangêd pun na is-êl la bêng na sa maragul la panggilingan na batu buy isamwag sa dagat. ");
INSERT INTO blx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nu gamêt muy magin sangkan pangasalanan mu, putusun mu! Mangêd pun na gigisay gamêt mu nuwa dilag kan biyay ya ayin katganan kaysa luwa yabay ya gamêt mu, nuwa milaku kay naman sa impernu nu saantu asê mangapalêng nga apuy. ");
INSERT INTO blx_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Baydu sa impernu, asê êt mangamati ya mani êwêl buy asê êt mangapalêng nga apuy.” ");
INSERT INTO blx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Buy nu bitis muy magin sangkan pangasalanan mu, putusun mu! Mangêd pun na gigisay bitis mu, nuwa dilag kan biyay ya ayin katganan kaysa luwa yabay ya bitis mu, nuwa isamwag kay naman sa impernu. ");
INSERT INTO blx_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Baydu sa impernu, asê êt mangamati ya mani êwêl buy asê mangapalêng nga apuy.” ");
INSERT INTO blx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Nu mata muy magin sangkan pangasalanan mu, lus-ukun mu! Mangêd pun na mibilang ka sa pag-arian Bapan Namalyari ya gigisay mata mu kaysa luwa yabay ya mata mu, nuwa isamwag ka sa impernu. ");
INSERT INTO blx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Baydu sa impernu, asê êt mangamati ya mani êwêl buy asê mangapalêng nga apuy.” ");
INSERT INTO blx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tagawan makadanas un panubuk ka balang gisa kaparisun pan-iandug kan Bapan Namalyari ya pambiyan asin bayu ipapakatupus sa apuy. ");
INSERT INTO blx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mangêd da asin. Nuwa nu mitas ya lasan asin, asina miudung buy ayin nan nabang. Magin nabang kaw sa kaganawan tawu kaparisun asin na dilag nabang sa kaganawan. Sa pakapakun baydu, bumyay kaw dilag kapatêtbêkan sa balang gisa.” ");
INSERT INTO blx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Amêsên, namita si Jesus baydu buy naku ya sa sakup prubinsyan Judea buy naglipay ya sa ilug Jordan. Nanguman nagtipun kanay malakêy tawu buy tinurwanan na sila kaparisun mana nan pandaygên. ");
INSERT INTO blx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dilag dakun umnuy Pariseoy nagdani kan Jesus amên subukan ya. Kabay namatang sila, “Pantulutan nayin Kautusan na isyay liyaki ya asawa na?” ");
INSERT INTO blx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kabay nakitbay si Jesus, “Sabêt ta utus Moises kamuyu tungkul sa pamisyay miasawa?” ");
INSERT INTO blx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nakitbay ya mani Pariseo, “Impaintulut Moises ya isyay liyaki ya asawa na nu dilag yan dinyag ga kasulatan pamisyay.” ");
INSERT INTO blx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nuwa sinabin Jesus, “Gawan sa kakdêyan ulu yu, insulat Moises ya kautusan abiin. ");
INSERT INTO blx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nuwa paubat sabitun dinyag Bapan Namalyari ya babun luta, dinyag nay liyaki buy babayi. ");
INSERT INTO blx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kabay lakwanan liyaki ya bapa buy indu na amên miawyun silan miasawa, ");
INSERT INTO blx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","buy ya luwa, pakadyag gigisa.’ Sa pakapakun baydu, alwa silaynan luwa, nun a gigisa silayna. ");
INSERT INTO blx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kabay ya piniawyun Bapan Namalyari, asê sêpat pisyayên tawu.” ");
INSERT INTO blx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pallumatêng la sa bali, namatang manguman na mani tagasunul Jesus kana patungkul sa pamisyay miasawa. ");
INSERT INTO blx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sinabi na kalla, “Nu in-isyay liyaki ya asawa na ta mag-asawa yan kaatag, mangasalanan yan pamikikanayun sa nuna nan asawa. ");
INSERT INTO blx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Para êt bayduy babayi. Nu in-isyay nay asawa na buy mag-asawa yan kaatag, mangasalanan ya êt pamikikanayun.” ");
INSERT INTO blx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dilag mani tawuy nilakun nangabêlêng nga anak kan Jesus amên yawarên lan ipaluntuy gamêt na kalla buy pagpalên na sila. Nuwa binênbênan silan mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sên nakitan Jesus ya abiin, nanubag ya buy sinabi na kalla, “Paulayan yun magdani kangkuy mani anak. Agana yu sila bênbênan, tagawan ya mani kaparisu la sabay ya miawyun sa pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pansabin ku kamuyuy sisabêt man na asê magpasakup sa pag-arin Bapan Namalyari kaparisun pagpasakup nangabêlêng nga anak, a ya miawyun sa mani tawuy pag-arian na.” ");
INSERT INTO blx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pamakayari, inampun nay mani anak buy impaluntu nay gamêt na kalla buy pinagpala na sila. ");
INSERT INTO blx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sên mamitay na si Jesus, dilag gisay liyaki ya nuwayun nagdani kana. Nanduku ya sa arapan na buy namatang, “Mangêd da Manuru, sabêt ta sêpat kun daygên amên mabiyan nakun biyay ya ayin katganan?” ");
INSERT INTO blx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sinabin Jesus kana, “Uysiyan binêg muku yan mangêd ta? Ayin kaatag mangêd nun a kay si Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tungkul sa impatang mu, tanda muy Kautusan Bapan Namalyari, ‘Agana ka mamatin tawu. Agana ka makikanayun. Agana ka manakaw. Agana ka magpapêtêg sa alwan kapêtêgan. Agana ka mamurayit. Galangên muy mangatwa mu.’ ” ");
INSERT INTO blx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nakitbay ya liyaki, “Manuru, ubat pun sa anak kaku, pansunulun kinay kaganawan abiin angga amêsên.” ");
INSERT INTO blx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Inêlêw yan Jesus un dilag pangidu buy sinabi na kanay, “Dilag ka pun gisay sêpat daygên. Muli kayna ta isaliw muy mani pibandiyan mu buy ya naabli mu, idin mu sa mani kalulu. Sa pakapakun baydu, dilag kan pibandiyan sa langit. Pamakayari, mag-udung ka buy manunul kangku.” ");
INSERT INTO blx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sên nalêngên liyaki ya abiin, nalungkut ya buy namita yan nalêlêy nakêm, gawan malakêy pibandiyan na. ");
INSERT INTO blx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pinakaêlêw Jesus ya mani nakapalitêng kana buy sinabi na sa mani tagasunul na, “Pêtêg baynan masakit magpasakup pa mani tawuy malakêy pibandiyan sa pag-arian Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nakaupapas ya mani tagasunul na sa sinabi na. Nuwa inuman sinabin Jesus, “Maanak kuway, pêtêg baynan masakit magpasakup pa mani tawuy malakêy pibandiyan sa kaarian Bapan Namalyari! ");
INSERT INTO blx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Misun pun na kamelyu sa lubut karayum, kaysa misun sa kaarian Bapan Namalyari ya gisay tawuy mabandi.” ");
INSERT INTO blx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Luyang pun êt nakatêgag ga mani tagasunul na. Kabay namatang sila, “Nu parabaydu, sisabêt awêd da miligtas?” ");
INSERT INTO blx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pinakaêlêw silan Jesus buy sinabi na, “Ya asê madyag tawu, madyag Bapan Namalyari, ta madyag nay kaganawan.” ");
INSERT INTO blx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kabay sinabin Pedro, “Parasaantu kay yaman? Inlakwanan yan na kaganawan amên manunul kamu!” ");
INSERT INTO blx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nuwa nakitbay si Jesus, “Pansabin ku kamuyuy nu sisabêt man na nallakwan bali na, nallakwan mapatêl na, nallakwan mangatwa na, nallakwan maanak na o nallakwan mani luta na gawan sa panunul na kangku buy sa pangaral nan Mangêd da Balita, ");
INSERT INTO blx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sa panawun ati, mananggap yan dinalan pun êt sa inlakwanan na. Mananggap yan mani bali, mapatêl, mangatwa, maanak, buy mani luta na, agyan dilag man kaawyun pamasakit. Nuwa sa lumatêng nga panawun, mabiyan yan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Malakêy mapagmatag-ay amêsên ya iyêpa lanu. Buy malakêy mapagpayêpa amêsên ya itag-ay lanu.” ");
INSERT INTO blx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sên idi silayna sa dan patuksaw sa balayan Jerusalem, nuna si Jesus kalla. Nakaupapas ya mani tagasunul na buy nalimuy mani tawuy manunul kana. Inuman impapawan Jesus ya mapu buy luway tagasunul na buy sinabi na kalla nu sabêt ta malyari kana, ");
INSERT INTO blx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Elêwên yu! Tumuksaw kitamina sa Jerusalem. Buy sikuy ubat sa langit ta in-Anak Tawu, igawang ngaku sa mani mamunun pari buy sa mani manurun Kautusan. Atulan lakun kamatyan buy igawang ngaku sa mani alwan Judio. ");
INSERT INTO blx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pupustakên laku, pitupaytupayan laku, latikun buy patin. Nuwa sa ikatluy allu, manguman nakun mabyay.” ");
INSERT INTO blx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nagdani kan Jesus ya luway anak Zebedeo ya silan Santiago buy si Juan. Sinabi la, “Manuru, dilag kay dayin yawarên kamu.” ");
INSERT INTO blx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Namatang si Jesus, “Sabêt ta yawarên yu?” ");
INSERT INTO blx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nakitbay sila, “Nu mag-ari kayna, labay yan dayin miknun mikapaka sa dani mu, ya gisa sa wanan mu buy ya gisa, sa udi mu.” ");
INSERT INTO blx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nuwa sinabin Jesus kallay, “A yu tanda nu sabêt ta panyawarên yu. Mapibabatan yu nayi ya pamasakit ta danasên ku? Buy nakal-an kaw nayin mati kaparisu ku?” ");
INSERT INTO blx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nakitbay sila, “Awu, mapibabatan yan.” Sinabin Jesus, “Ya pamasakit ta madanasan ku, madanasên yu êt buy mati kaw êt kaparisu ku. ");
INSERT INTO blx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nuwa alwan sikuy mamili nu sisabêt ta miknu sa wanan ku o sa udi ku, ta ya iknuwan abitu, kay para sa mani pinil-anan Bapa ku.” ");
INSERT INTO blx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Sên natandan mapuy tagasunul nay inyawad lan Santiago buy si Juan, nanubag sila. ");
INSERT INTO blx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kabay impadani silan Jesus buy sinabi na kallay, “Tanda yuy mani manungkulan ya alwan Judio, pan-ipilit lay labay la sa mani pansakupun la buy agyan sabêt ta labay la, pansunulun mani pansakupun la. ");
INSERT INTO blx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nuwa alwan parabaysên na labay kun daygên yu, nun a nu sisabêt man kamuyuy kalabay magin dakila, kaylangan yan magin lingkud yu. ");
INSERT INTO blx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Buy nu sisabêt man kamuyuy kalabay magin mamunu, sêpat yan magin ipus kaganawan. ");
INSERT INTO blx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tagawan agyan siku man na ubat sa langit ta in-Anak Tawu, naku waku baydi amên maglingkud buy idin kuy biyay ku amên atbusun na malakêy tawu. A ku naku baydi amên paglingkuran mani tawu.” ");
INSERT INTO blx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Inlumatêng silan Jesus sa balayan Jerico. Sên mita yina baydu sa Jerico, kaawyun nay mani tagasunul na buy kaatag pun êt. Dilag gisay bulag ga magpalimus ya nakaiknu sa agid dan. Ya lagyu na, Bartimeo ya anak Timeo. ");
INSERT INTO blx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sên nalêngê nay mallumibas si Jesus ya taga Nazaret, masnêg nan sinabi, “Jesus ya layin Arin David, kalunusan muku kayêk!” ");
INSERT INTO blx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Binênbênan yan mani tawu, “Agana ka mantarit!” Nuwa ingkakadus nan insabin masnêg, “Layin Arin David, kalunusan muku kayêk!” ");
INSERT INTO blx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sên nalêngê yan Jesus, tinunggên ya buy sinabi na, “Bêgên yuya.” Kabay binêg lay bulag, “Pas-êyên muy nakêm mu. Midêng ka ta pan-ipabêg naka.” ");
INSERT INTO blx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Insamwag nay balabal na. Tambêng yan nidêng buy nagdani kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Namatang si Jesus kana, “Sabêt ta labay mun daygên ku kamu?” Nakitbay ya bulag, “Manuru, kalabay yakun makakit.” ");
INSERT INTO blx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kabay sinabin Jesus kana, “Malyari kaynan muli. Inumiyul ka gawan sa panampalataya mu kangku.” Tambêng yan nakakit buy nanunul ya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sên narani yana silan Jesus sa Jerusalem, tinunggên sila sa Bung-uy mani Ulibu ya narani sa balayan Bethfage buy sa balayan Bethania. Impaunan Jesus ya luway tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Sinabi na kalla, “Maku kaw sa kasunul la baryu. Pamakasun yu baydu, makitan yuy gisay biserun asnuy nakas-êl ya asê pun nasakayan agyan sisabêt man. Agwatên yuya buy akayên baydi. ");
INSERT INTO blx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nu dilag mamatang kamuyun paradi, ‘Uysiyan pan-agwatên yu yay asnu ta?’ sabin yu kanay, ‘Kaylangan Panginuun buy tambêng nan iudung baydi.’ ” ");
INSERT INTO blx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kabay namita silayna buy nakitan laya bay ya biserun asnu sa danin dan ya nakas-êl sa lawasan gisay bali. Sên pan-agwatên layna, ");
INSERT INTO blx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","dilag gisa sa dakun umnuy tawu bayduy namatang kalla, “Uysiyan pan-agwatên yu yay biserun asnu ta?” ");
INSERT INTO blx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kabay sinabi lay pan-ipasabi kallan Jesus buy tinulutan la sila. ");
INSERT INTO blx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pamakayari, in-akay layna kan Jesus ya biserun asnu. Inlatêp lay balabal la sa bukut biserun asnu buy nagsakay ya. ");
INSERT INTO blx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Malakêy tawuy namimakmak balabal la sa dan. Ya kaatag êt, namimakmak silan palapay pinutus la sa panggitnan. ");
INSERT INTO blx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ya kaganawan tawuy idi sa mumuna buy idi sa ubatan, mansaway silan magsabin, “Ulimênên na Bapan Namalyari! Pagpalên na mallumatêng sa lagyu na! ");
INSERT INTO blx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pagpalên Bapan Namalyari ya mallumatêng nga kaarian ninunu tamun si Arin David. Ulimênên na Bapan Namalyari ya idi sa langit.” ");
INSERT INTO blx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pallumatêng Jesus sa Jerusalem, naku ya sa kasawangan Templu. Pinakaêlêw nan mangêd da kaganawan idi baydu. Buy gawan mamayabi-yabi yana, nag-udung ya sa Bethania kaawyun nay mapu buy luway tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pamakawasak, sên mita silayna ubat sa balayan Bethania paudung sa Jerusalem, nalayangan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Naipatanês nay gisay puun kayun igus ya malabung. Inlaku nan inêlêw ya ati nu nagtagêy. Nuwa ayin yan nakitan nun a kay pawan bulung, gawan alwa pun panawun panagêy igus. ");
INSERT INTO blx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kabay sinabi na sa puun kayu, “Agyan kanu pun, ayin nan kaatag makaêkan tagêy mu.” Nalêngên mani tagasunul nay sinabi na. ");
INSERT INTO blx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pamakalatêng la sa Jerusalem, naku si Jesus sa kasawangan Templun Bapan Namalyari buy impatas nay mani magtinda buy mani manaliw baydu. Imbabaliswag nay lamesan mallibay peran dayuwan sa peran mani Judio buy iknuwan mani magtindan pati-pati ya pan-iandug kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Imbawal nay mani tawuy mantan pan-itinda sa kasawangan Templu. ");
INSERT INTO blx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pamakayari, tinurwanan nay mani tawu baydu. Sinabi na kalla, “Nakasulat sa Sabin Bapan Namalyari, ‘Ya bali ku, pambêgên balin panalanginan mani tawu sa kaganawan bansa.’ Nuwa siyan dinyag yun pagtagwan mani manakaw.” ");
INSERT INTO blx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sên nabalitan mani mamunun pari buy mani manurun Kautusan ya tungkul sa dinyag Jesus, pisasabyan la nu sabêt ta daygên la amên maipapati laya. Nuwa nalimu sila kana gawan malakêy tawuy nakaupapas sa panuru na. ");
INSERT INTO blx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sên nadiglêm mana, nag-awas silan Jesus sa balayan Jerusalem. ");
INSERT INTO blx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pamakamaranun, sên mag-udung silayna sa Jerusalem, nadanan layna êt ta puun kayun igus buy nakitan lay nayangu ya. ");
INSERT INTO blx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Naganakan Pedroy sinabin Jesus sa puun kayu. Kabay sinabi na, “Manuru, êlêwên muy puun kayun igus ya insumpa mu. Nayanguy na!” ");
INSERT INTO blx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sinabin Jesus kalla, “Manampalataya kaw kan Bapan Namalyari! ");
INSERT INTO blx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pansabin ku kamuyuy nu dilag kaw panampalataya buy asê magmikakunuy nakêm, malyari yun sabin sa bung-uy ati, ‘Mitas ka buy milaku ka sa dagat!’, buy taganan madyag ga pansabin yu. ");
INSERT INTO blx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kabay pansabin ku kamuyuy sabêt man na yawarên yu kan Bapan Namalyari sa panalangin, maniwala kaw wa natanggap yinay panyawarên yu buy matanggap yina. ");
INSERT INTO blx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nu manalangin kaw, patawarên yu pun na nangasalanan kamuyu amên patawarên kaw êt Bapa yuy idi sa langit. ");
INSERT INTO blx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ta nu a kaw mamatawad, a kaw êt patawarên Bapa yuy idi sa langit.” ");
INSERT INTO blx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Naku silayna êt sa Jerusalem. Kaban mamita si Jesus sa kasawangan Templu, nagdani kanay mani mamunun pari buy mani manurun Kautusan buy mani mangatway manungkulan. ");
INSERT INTO blx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Namatang sila kana, “Sabêt ta karapatan mun manyag abiin na dinyag mu? Sisabêt ta nam-i kamun parabaysên na karapatan?” ");
INSERT INTO blx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kabay pikitbayan silan Jesus, “Patangên kataw êt. Nu mapakitbayan yuku, sabin ku êt kamuyu nu sisabêt ta nam-i kangkun karapatan manyag paradi. ");
INSERT INTO blx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sabin yu kangku nu kansabêt ubat ta karapatan Juan ya mamawtismu, kan Bapan Namalyari o sa tawu? Sabêt ta pakitbay yu?” ");
INSERT INTO blx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kabay nisasabi sila, “Nu sabin tamuy ‘kan Bapan Namalyari’, sabin nay naman êt kantamuy, ‘Uysiyan a kaw yabay maniwala kan Juan ta?’ ");
INSERT INTO blx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nuwa nu sabin tamuy ‘sa tawu’, manubag ga mani tawu kantamu.” (Malimu sila sa mani tawu gawan maniwalay mani tawu ya propetan Bapan Namalyari si Juan.) ");
INSERT INTO blx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kabay nakitbay sila kan Jesus, “A yan tanda.” Sinabi êt Jesus, “Nu parabaydu, a ku êt sabin kamuyu nu sisabêt ta nam-i kangkun karapatan manyag ati.” ");
INSERT INTO blx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kabay nangalimbawa pun si Jesus kalla. Sinabi na, “Dilag gisay tawuy nananêm ubas sa panggitnan na. Pamakayari nan nananêm, impabakud nay abitu buy namipadyag yan pamêspêsan ubas. Namipaydêng ya êt gisay matag-ay ya bali ya bibiyan mamantay. Pamakayarin abitu, impasamak nay ubasan na sa mani makisamak ta naku ya sa marayuy lugal. ");
INSERT INTO blx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sên panawun nan pamupul ubas, in-utus nay gisay ipus na sa mani kasamak na amên kêwên na dakay na. ");
INSERT INTO blx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nuwa dinagus mani kasamak ya ipus buy dinugêdugê buy impatas layan ayin gintan. ");
INSERT INTO blx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Niutus manguman na magbandin ubasan un gisa pun na ipus, nuwa impakadêng-êy laya buy pinatuk sa ulu. ");
INSERT INTO blx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nanguman nina êt namiutus gisa pun na ipus, nuwa pinati lay abitu. Malakê pun na in-utus magbandi, nuwa abituy kaatag, dinugêdugê la buy ya kaatag êt, pinati la.” ");
INSERT INTO blx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Pamakayarin abitu, ayin ninan ipus ya maiutus. Kabay in-utus naynay kakaidwan nan anak, ta indap na nu galangên lay anak na.” ");
INSERT INTO blx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nuwa sên nakitan mani kasamak ya anak na, sinabi la, ‘Ah! Ati yay tagapagmana! Kaksaw kaw! Patin tamu ya amên mapagbandi tamuy mapagmana na.’ ");
INSERT INTO blx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kabay dinagus lay anak, pinati buy ginuluy lay bangkay na sa lawasan panggitnan.” ");
INSERT INTO blx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pamakayari, namatang si Jesus, “Sabêt amêsên na daygên magbandin ubasan? Pilmin lakwên nay mani kasamak na buy patin. Pamakayari, ipasamak na sa kaatag ya ubasan na. ");
INSERT INTO blx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","A yu nayi nabasa sa Kasulatan na impasulat Bapan Namalyari, ‘Ya batuy insakwil mani mamipaydêng bali, sabay ya batuy nagin pundasyun. ");
INSERT INTO blx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Abiin na dinyag Bapan Namalyari ya mamakaupapas kantamu.’ ” ");
INSERT INTO blx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Napukatan mani puun Judio ya sabay silay pantukuyun Jesus sa paalimbawa na. Kabay dakpên layna dayi si Jesus, nuwa nalimu sila sa mani tawu. Kabay pinaulayan la si Jesus buy namita sila tana. ");
INSERT INTO blx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Impalakun mani puun Judio kan Jesus ya dakun umnuy Pariseo buy dakun umnuy tawun Gobernador Herodes Antipas amên lêng-ên laya gawan labay layan dakpên sa pagsabi na. ");
INSERT INTO blx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sên inlumatêng sila kan Jesus, sinabi la, “Manuru, tanda yan na pêtêg ya pansabin mu buy ayin kan pampilinin gawan a ka mangêlêw sa kabilyan gisay tawu, nun a kay kapêtêgan tungkul sa kalabayan Bapan Namalyari ya pan-ituru mu. Amêsên, dilag kay ipatang kamu, sêpat kitamu nayin mamayad buwis sa Emperador Roma o asê?” ");
INSERT INTO blx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nuwa tandan Jesus ya kay magtatalingkayu sila. Kabay sinabi na, “Alwa ta labay yukun dakpên sa pagsabi ku ta? Mantan kaw baydin pera ta êlêwên ku.” ");
INSERT INTO blx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nantan sila yabay pera buy pinatang na sila, “Kansabêt lupa buy lagyuy makit yu di?” Sinabi la, “Sa Emperador.” ");
INSERT INTO blx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kabay sinabin Jesus kalla, “Nu parabaydu, idin yu sa Emperador ya para sa Emperador. Buy idin yu kan Bapan Namalyari ya para kan Bapan Namalyari.” Taganan nakaupapas sila sa sinabi na. ");
INSERT INTO blx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Amêsên, dilag dakun umnuy Saduseoy nagdani kan Jesus amên patangên ya. Ya mani Saduseo, a sila maniwalan manguman mabyay ya mani nangamamati. Sinabi la kan Jesus, ");
INSERT INTO blx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Manuru, ayun sa Kautusan na impasulat kan Moises, nu ya gisay liyaki nati yan ayin anak sa asawa na, sêpat pag-asawan patêl nay liyaki ya bayaw nay nabal-u amên makaanak sila para sa patêl nay nati.” ");
INSERT INTO blx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Amêsên, dilag pituy mipapatêl la lawyaki. Nakapag-asaway panganay, nuwa nati yan ayin anak. ");
INSERT INTO blx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kabay ya nabal-u, napag-asawa nay ikalway panganay, nuwa nati ya êt ayin anak. Para êt bayduy nalyari sa ikatluy patêl la. ");
INSERT INTO blx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Balang gisa sa pituy mipapatêl la nakapag-asawan abituy babayi ya nabal-u, namatyan lan kaganawan ayin anak sa babayi. Sa katatawliyan, nati êt ta bal-u. ");
INSERT INTO blx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Amêsên, sa allun pangabyay manguman nangamamati, sisabêt ta asawan abituy babayi, gawan napag-asawa yan pituy mipapatêl?” ");
INSERT INTO blx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nakitbay si Jesus, “Taganan mali kaw, tagawan a yu mapukatan na Kasulatan Bapan Namalyari buy a yu mapukatan na kapangyarian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tagawan sa pangabyay manguman, ayin nan pag-asawa, ta magin kaparisu silaynan mani ang-el sa langit ya ayin asawa. ");
INSERT INTO blx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tungkul laman sa pangabyay manguman, a yu nayi nabasay impasulat kan Moises? Sabitun idi ya baydu sa magdêkêtdêkêt ta puun kayu, sinabin Bapan Namalyari kanay, ‘Sikuy Bapan Namalyari lan Abraham, Isaac, buy Jacob.’ ");
INSERT INTO blx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ya labay sabin, nabyay sila, tagawan alwa yan Bapan Namalyarin nangamamati, nun a Bapan Namalyari yan nangabyay. Kabay taganan mali kaw!” ");
INSERT INTO blx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dilag baydun gisay manurun Kautusan ya mallêngê sa misusulakan. Nalêngê nay mangêd da pikitbay Jesus. Kabay nagdani ya buy namatang, “Sabêt ta pinakamaulagay utus?” ");
INSERT INTO blx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nakitbay si Jesus, “Ati ya pinakamaulagay utus, ‘Sikaw wa mani Israelita, mallêngê kaw! Ya Panginuun tamun Namalyari, kay gigisa buy ayin nan kaatag. ");
INSERT INTO blx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kabay kaidwan muy Panginuun mun Namalyari un buun bêkê, buun kaladwa, buun isip buy buun pas-êy.’ ");
INSERT INTO blx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ati êt ta ikalway pinakamaulagay utus, ‘Kaidwan muy kaparisu mun tawu kaparisun pangidu mu sa sarili mu.’ Abiin na luway utus ya pinakamaulaga buy ayin nan kaatag.” ");
INSERT INTO blx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sinabin manurun Kautusan kan Jesus, “Manuru, ustu ka. Pêtêg ga sinabi muy kay gigisa si Bapan Namalyari, ayin nan kaatag. ");
INSERT INTO blx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kabay sêpat yan kaidwan un buun bêkê, buun isip buy buun pas-êy. Buy sêpat tamu êt kaidwan na kaparisu tamun tawu kaparisun pangidu tamu sa sarili tamu. Igit maulagay ati kaysa kaganawan kalasin sinlêb ba andug buy sa kaatag pun na andug.” ");
INSERT INTO blx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sên nalêngên Jesus ya mangêd da pakitbay na, sinabi na kana, “Marani kaynan miawyun sa pag-arin Bapan Namalyari.” Ubat ta baydu, ayin nan nakadêgdêg namatang kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kaban manuru si Jesus baydu sa kasawangan Templu, namatang ya, “Parasaantun masabin mani manurun Kautusan ya si Cristuy impangakun Bapan Namalyari, kay layi yan Arin David? ");
INSERT INTO blx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sa kapamilatan pangawyun Ispiritun Bapan Namalyari kan Arin David, sinabi nay, ‘Sinabin Bapan Namalyari sa Panginuun ku, Miknu ka sa wanan ku angga sa mapasuku ku kamuy mani kapati mu.’ ");
INSERT INTO blx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Amêsên, nu binêg Arin David Panginuun ya Cristu, parasaantun masabin mani tawuy si Cristuy kay layi yan Arin David?” Labaylabay lêng-ên mani tawu si Jesus. ");
INSERT INTO blx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sinabi pun êt Jesus sa pangaral na, “Mangillag kaw sa mani manurun Kautusan. Labaylabay lan mamitan nakayaming makarang buy labaylabay lan galangên silan mani tawuy malibasan la. ");
INSERT INTO blx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Labaylabay lan miknu sa iknuwan na in-il-an para sa maulagay tawu sa balin pagtipunan mani Judio buy sa mani kalutu. ");
INSERT INTO blx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pampurayitin la êt ta mani nabal-uy babayi amên makwa lay mani pibandiyan la buy magmamangêdan sila sa arapan mani tawu sa kapamilatan makarang nga panalangin la. Kabay lanu, luyang pun nabyat ta pamarusan Bapan Namalyari kalla.” ");
INSERT INTO blx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kaban idi pun sa Templu si Jesus, niknu ya sa êtêb pamyanan pera para sa Templu buy inêlêw nay malakêy mam-in pera. Malakêy mabandi ya nam-in mangaragul la alaga. ");
INSERT INTO blx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dilag êt baydun gisay kaluluy babayi ya bal-uy nagdani buy nam-in luluway pirasun barya sa pamyanan pera. ");
INSERT INTO blx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Impadanin Jesus ya mani tagasunul na buy sinabi na kallay, “Pansabin ku kamuyuy igit pun maulagay indin nabal-u kaysa indin kaganawan. ");
INSERT INTO blx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gawan ya kaatag, nam-i silan a layna kaylangan. Nuwa ya bal-u, agyan kay kalulu ya, inlapas na pun indin ya panaliw nan kanên na.” ");
INSERT INTO blx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kaban paawas silan Jesus sa Templu, sinabin gisa sa mani tagasunul na, “Manuru, êlêwên muy mani impaidêng nga nakapalitêng sa Templu ya pawan diyag sa mangaragul la batu. Mamangêd da pangadyag!” ");
INSERT INTO blx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sinabin Jesus kana, “Makitan yuy mani abiin na dyag sa mangaragul la batu. Nuwa lumatêng nga panawun, ayin batuy mitagan na nakapaluntu sa kaparisu nan batu.” ");
INSERT INTO blx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sên nakaiknuy na si Jesus sa gisay lugal sa Bung-uy mani Ulibu sa arapan Templu, namatang silan Pedro, Santiago, Juan buy si Andres un kay kakapad la. ");
INSERT INTO blx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Sinabi la, “Sabin mu kanyan nu makanu malyari ya sinabi mu buy nu sabêt ta tanda' ya marani yan malyari ya abitu?” ");
INSERT INTO blx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kabay sinabin Jesus kalla, “Mangillag kaw amên a kaw mailitêp agyan sisabêt man. ");
INSERT INTO blx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tagawan malakêy lumatêng nga manggamit lagyu ku. Sabin lay, ‘Sikuy Cristuy impangakun Bapan Namalyari.’ Kabay malakêy mailitêp la. ");
INSERT INTO blx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nu makalêngê kaw migegeray marani kamuyu buy nu makabalita kaw êt migegeray marayu, agana kaw malimu. Ta sêpat malyari ya abiin, nuwa alwa pun abiin na katganan babun luta. ");
INSERT INTO blx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tagawan makigeray bansa sa kaparisu nan bansa buy makigeray kaarian sa kaparisu nan kaarian. Lumatêng nga layun sa magmikakanayun na lugal. Lumatêng êt ta sadyay layang. Ya kaganawan kasakitan na abiin, kay umpisa pun sadyay kasakitan ya maiparisu sa kasakitan babayi ya manganak.” ");
INSERT INTO blx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kabay mangillag kaw tagawan sa panampalataya yu kangku, dakpên lakaw buy iarap sa mani manungkulan. Latikun lakaw sa balin pagtipunan mani Judio buy iarap sa mani gobernador buy sa mani ari. Sa pakapakun baydu, makapagpapêtêg kaw kalla tungkul kangku. ");
INSERT INTO blx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sêpat pun maipatanday Mangêd da Balita sa kaganawan bansa bayu lumatêng nga katganan.” ");
INSERT INTO blx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Nu lumatêng nga panawun na dakpên kaw buy iarap sa mallitis, agana kaw napitik nu sabêt ta sabin yu, nun a ya sabin yu, abituy pan-ipasabin Ispiritun Bapan Namalyari kamuyu sa uras abitu, tagawan alwan sikaw wa magsabi nun a ya Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sa panawun abitu, dilag tawuy migawang patêl na amên ipapati. Dilag êt mangatway migawang anak la amên ipapati buy dilag êt mani anak ka manalangsang buy mipapatin mangatwa la. ");
INSERT INTO blx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gawan sa panunul yu kangku, kasulapwan kaw kaganawan. Nuwa ya manugêl tapat angga sa katganan, sabay siyay miligtas.” ");
INSERT INTO blx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Insundun Jesus ya pagsabi na, “Sikaw wa mamasa, pakaintindin yuy ati! Nu makit yuy sadyay kadawakan ya manira baydu sa lugal la asê sêpat panyagan, ya kaganawan na idi sa Judea, kaylangan muwayu silaynan makun bung-uy. ");
INSERT INTO blx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sa panawun abitu, ya idi sa lawasan bali, aganayna sumun amên mangwan dakun sabêt sa lalên bali na. ");
INSERT INTO blx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ya idi sa panggitnan, aganayna muli amên mangwan yaming na. ");
INSERT INTO blx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mamakapalunus ya mani nabuktut buy mani mamasusu sa allun abiin, tagawan magkasakit silan tumakas. ");
INSERT INTO blx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Manalangin kaw kan Bapan Namalyari ya sa allun abiin, alwan panawun nalêpêt. ");
INSERT INTO blx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sa panawun abitu, makadanas ya mani tawun sadyay kasakitan ya a la pun nadanasan ubat pun sabitun dinyag Bapan Namalyari ya babun luta angga amêsên. Buy ayin nan manguman makadanas parabayduy kasakitan kanuman. ");
INSERT INTO blx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ta nu asê inêpêk Bapan Namalyari ya panawun abitu, ayin tawuy miligtas. Nuwa para sa mani tawuy pinili na, inêpêk nay panawun abitu.” ");
INSERT INTO blx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Amêsên, nu dilag magsabi kamuyun, ‘Idi ya baydi ya Cristu!’, o ‘Idi ya baydu!’, agana kaw makipapaniwala. ");
INSERT INTO blx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tagawan lumtaw wa mani magtatalingkayun Cristu buy mani magtatalingkayun propeta. Mipakit silan mani tanda' buy mamakaupapas amên ilitêp pa mani tawu buy nu malyari, agyan na mani pinilin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kabay mangillag kaw! Sinabi kuy abiin kaban asê pun nalyari.” ");
INSERT INTO blx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pamakayarin abituy allun sadyay kasakitan, dumiglêm ma mamut buy asina sumawang nga buwan. ");
INSERT INTO blx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mangananabuy mani bêtêwên buy maubus maêyêg ga mani bagay ya idi sa langit buy mitas sila sa binyanan la. ");
INSERT INTO blx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pamakayari, makitan la kuy in-Anak Tawuy ubat sa langit ya mallumatêng nga idi sa ulap ya dilag dakilay kapangyarian buy sawang. ");
INSERT INTO blx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iutus kuy mani ang-el ku sa kaganawan lugal sa babun luta amên tipunun lay mani tawuy pinili ku.” ");
INSERT INTO blx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Pakaintindin yuy aral sa paalimbawa sa puun kayun igus. Nu magbulung nganay sangan ati, tanda yinay marani yay kaynitan. ");
INSERT INTO blx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Para êt bayduy malyari lanu. Nu makitan yinan malyari yay mani pansabin ku kamuyu, matandan yuy marani yakinan lumatêng ya paran idi yakina sa pasbul bali. ");
INSERT INTO blx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pansabin ku kamuyuy bayu mati ya kaganawan tawu sa panawun amêsên, matupad day kaganawan sinabi ku. ");
INSERT INTO blx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ya langit buy luta, dilag katganan. Nuwa ya mani sabi ku, manugêl kanuman.” ");
INSERT INTO blx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nuwa tungkul laman sa allu o uras pag-udung ku, ayin magtanda, agyan na mani ang-el sa langit buy agyan sikuy Anak Bapan Namalyari. Kay si Bapay magtanda. ");
INSERT INTO blx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kabay mangillag kaw buy maglêan, gawan a yu tanda nu makanuy pallumatêng ku.” ");
INSERT INTO blx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Malyari tamun ialimbawa sa dinyag gisay tawuy naku sa marayuy lugal. Bayu ya namita, sinabi na sa mani ipus na nu sabêt ta daygên la buy intipan na êt sa mamantay sa lawasan na maglêan ya sa pallumatêng amung na.” ");
INSERT INTO blx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Kabay maglêan kaw, tagawan a yu tanda nu makanu lumatêng nga magbandin bali. Mapalyarin yabi, bunak yabi, bunatbunat o maranun. ");
INSERT INTO blx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dat tambêng yan lumatêng buy malatêng nakaw wa mamabêlêw. ");
INSERT INTO blx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ya pansabin ku kamuyu, pansabin ku êt sa kaganawan, ‘Maglêan kaw!’ ” ");
INSERT INTO blx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Amêsên, luwa tanay allu bayu miras ya Pestan Kaligtasan buy Pestan Tinapay ya ayin Pamalbag. Namalanuy mani mamunun pari buy mani manurun Kautusan nu parasaantu lan madakêp buy maipapati si Jesus un ayin makatanda. ");
INSERT INTO blx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sinabi la, “Gana tamu pun daygên sa allun pesta, ta dat maguluy mani tawu.” ");
INSERT INTO blx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sên idi sa balayan Bethania si Jesus, mangan ya sa balin Simon na natasan ketung. Dilag inlumatêng nga gisay babayi ya mantan makamal la pabangi ya pawan nardo ya idi sa pamyanan na diyag sa batun alabastru. Imbuklat nay ati buy pakanawa nan imbulug sa ulun Jesus. ");
INSERT INTO blx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sên nakitan kaatag ga dinyag babayi, nanubag sila. Sinabi lay, “Uysiyan insayang na yay pabangi ta? ");
INSERT INTO blx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pakan maisaliw naya dayi sa alagan upan gisay tawu sa gisay tawun, buy ya naabli na, maidin sa mani kalulu.” Buy tinubag lay babayi. ");
INSERT INTO blx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nuwa sinabin Jesus, “Paulayan yuya! Uysiyan pakyalaman yuya ta? Mangêd da dinyag na kangku. ");
INSERT INTO blx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pawa yun mapagkaawyun na mani kalulu. Kabay agyan sabêt man na uras, masawpan yu sila. Nuwa siku, a yu pawan mapagkaawyun. ");
INSERT INTO blx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dinyag nay kaganawan madyag na kangku. Binulugan nay nan pabangi ya lawini ku bilang pamil-an sa pamilbêng kangku. ");
INSERT INTO blx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pansabin ku kamuyuy agyan saantu iaral baydi sa babun lutay Mangêd da Balita, miwagaw êt ta mangêd da dinyag na kangku bilang pangganaka kana.” ");
INSERT INTO blx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Amêsên, si Judas Iscariote ya gisa sa mapu buy luway tagasunul Jesus, naku ya sa mani mamunun pari amên isupakat si Jesus. ");
INSERT INTO blx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sên nalêngê lay abiin, sadyay saya la. Kabay nangaku silan biyan layan pera. Paubat baydu, nangêtêng nginan panawun na masawpan na silan mandakêp kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Inlumatêng nga nunan allun Pestan Tinapay ya Ayin Pamalbag ya allun pamatin mani Israelita un biserun tupa ya kêna la sa Pestan Kaligtasan. Kabay pinatang mani tagasunul na si Jesus, “Antuy labay mun pamil-anan yan apunan tamu para sa Pestan Kaligtasan?” ");
INSERT INTO blx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kabay in-utus Jesus ya luwa sa mani tagasunul na, “Maku kawna sa balayan Jerusalem. Pamakalatêng yu baydu, matbêng yuy gisay liyaki ya mantan bangay naglanêm. Pakilakwan yuya ");
INSERT INTO blx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sa bali ya sunan na. Sabin yu sa magbali, ‘Pan-ipatang Manuru nu saantuy kuwartuy pamil-anan apunan para sa Pestan Kaligtasan kaawyun nay mani tagasunul na.’ ");
INSERT INTO blx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ituru na kamuyuy gisay makwal la kuwartu sa babu. Buy nakal-an bayduy gamit ta gamitin tamu sa apunan. Baydu yun il-an na apunan tamu.” ");
INSERT INTO blx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Namitay nay luway tagasunul nan naku sa Jerusalem buy nakitan lay pêtêg ga kaganawan sinabin Jesus kalla. Kabay in-il-an la bayduy apunan la para sa Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sên yabi yana, inlumatêng si Jesus sa makwal la kuwartu kaawyun nay mapu buy luway tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sên mangan silayna, sinabin Jesus kalla, “Pansabin ku kamuyuy gisa baydi sa kaêm kuy mamisupakat kangku.” ");
INSERT INTO blx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pamakalêngê la, nalungkut sila buy namatang nga balang gisa kana, “Siku nayi?” ");
INSERT INTO blx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sinabin Jesus, “Gisa kamuyun mapu buy luway mapagkaagnan kun mamisawsaw tinapay sa kulu, sabay ya mamisupakat kangku. ");
INSERT INTO blx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sikuy ubat sa langit ta in-Anak Tawu, patin naku, ta abiin na idi sa Kasulatan. Nuwa taganan mamakapalunus ya tawuy mamisupakat kangku. Mangêd pun na a yina in-anak.” ");
INSERT INTO blx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kaban mangan sila, nangwan tinapay si Jesus buy impasalamat na kan Bapan Namalyari. Binis-ilbis-il nay tinapay buy inggawang na sa mani tagasunul na. Sinabi na, “Ati ya lawini ku. Kêwên yu buy kanên.” ");
INSERT INTO blx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Amêsên, kingwa nay pan-inêmên buy impasalamat na kan Bapan Namalyari. Inggawang na kalla buy ninêm ma kaganawan. ");
INSERT INTO blx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Sinabi na kalla, “Ati ya daya kuy mibulug para sa malakêy tawu. Ati ya mamipapêtêg sa bayuy kasunduwan Bapan Namalyari sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Pansabin ku kamuyuy a kina manguman minêm alak ka diyag sa sabên ubas angga sa allun inêmên kuy bayuy alak sa kaarian Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nagkanta silan pangulimên kan Bapan Namalyari buy pamakayari, naku sila sa Bung-uy mani Ulibu. ");
INSERT INTO blx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sinabin Jesus sa mani tagasunul na, “Lakwanan yukun kaganawan, ta paradi ya idi sa Kasulatan, ‘Patin kuy pastul buy mikyat ta mani tupa.’ ");
INSERT INTO blx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nuwa pamakayari kun mabyay manguman, muna ku kamuyu sa prubinsyan Galilea.” ");
INSERT INTO blx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sinabi yaman Pedro kan Jesus, “Agyan lakwanan kan kaganawan, a kata lakwanan.” ");
INSERT INTO blx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nakitbay si Jesus, “Pansabin ku kamuy bayu mangkatin katilway manuk amêsên yabi, katitlu mukun ipuglaw.” ");
INSERT INTO blx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nuwa luyang pun sinabin Pedroy, “Agyan patin nakun kaawyun mu, a kata ipuglaw.” Para êt bayduy sinabin kaganawan tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pamakayari, naku sila sa gisay lugal la pambêgên Getsemani. Sinabin Jesus kalla, “Miknu kaw pun baydi kaban manalangin naku.” ");
INSERT INTO blx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pamakayari, pikilakun Jesus si Pedro, Santiago, buy si Juan. Baydu nakatanam yan sadyay lungkut buy nabêgbêg ga bêkê. ");
INSERT INTO blx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sinabin Jesus kalla, “Para kinan mati gawan sa sadyay lêlên bêkê ku. Minggat kaw baydi buy magpuyat kaw.” ");
INSERT INTO blx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nagpakarayu yan pêrad buy nagpalukub yan nanalangin ya nu malyari, a na danasên na sadyay pamasakit ta lumatêng kana. ");
INSERT INTO blx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Sinabi na, “Bapa ku, madyag muy kaganawan. Nu malyari dayi, itas muy pamasakit ta madanasan ku. Nuwa paraman baydu, alwan kalabayan kuy masunul, nun a ya kalabayan mu.” ");
INSERT INTO blx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pamakayari nan nanalangin, inudung Jesus ya tatluy tagasunul na buy nalatêng na silan mamabêlêw. Sinabi na kan Pedro, “Simon, mamabêlêw ka nayi? A ka nayi makabatan magpuyat, agyan kay gisay uras? ");
INSERT INTO blx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magpuyat kaw buy manalangin amên a kaw masambut tuksu. Ta ya ispiritu, nakal-an yan manunul, nuwa maynay lawini.” ");
INSERT INTO blx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nanguman nagpakarayu si Jesus buy inuman nay panalangin na. ");
INSERT INTO blx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pamakayari, inudung nan manguman na mani tagasunul na buy nalatêng na silayna êt mamabêlêw gawan kabêlêwbêlêw sila. Sên nimata silayna, a la tanda ya sabin la. ");
INSERT INTO blx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sên katitlu na silan inudung, sinabi na kalla, “Uysiyan mamabêlêw kaw yapun buy magpaynawa ta? Ustina! Inlumatêng ngay uras ya sikuy ubat sa langit ta in-Anak Tawu, insupakat takina sa mani makasalanan! ");
INSERT INTO blx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mimata kaw! Kaksaw wana! Ta abiti yay tawuy namisupakat kangku!” ");
INSERT INTO blx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kaban magsabi pun si Jesus, inlumatêng nga si Judas Iscariote ya gisa sa mapu buy luway tagasunul na. Dilag yan malakêy kaawyun na nipagkêya buy nipagpamatuk. In-utus silan mani mamunun pari, mani manurun Kautusan buy mani mangatway manungkulan. ");
INSERT INTO blx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Paradi ya patanday sinabin Judas sa mani mandakêp kan Jesus, “Ya dêpên kuy pingi, sabay ya pantêkapên yu. Dakpên yuyan gêtan buy papakabantayan.” ");
INSERT INTO blx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pamakalatêng Judas, tambêng yan nagdani kan Jesus buy sinabi na, “Manuru!” Pamakayari, dinêp nay pingin Jesus. ");
INSERT INTO blx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dinuyung mani tawu si Jesus buy dinakêp. ");
INSERT INTO blx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nuwa nanganus kêyay gisa sa mani tagasunul Jesus buy pinutus nay têk ipus pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Amêsên, sinabin Jesus sa mani mandakêp kana, “Tulisan naku nayi? Uysiyan mantan kaw yapun mani kêya buy pamatuk amên dakpên naku ta? ");
INSERT INTO blx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Allu-allu wakun mangaral sa kasawangan Templu buy idi kaw êt baydu. Uysiyan a yuku yata dinakêp ta? Nuwa sêpat malyari ya abiin amên matupad da idi sa Kasulatan.” ");
INSERT INTO blx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tambêng nipamwayuy mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Amêsên, dilag gisay bayuntawuy manunul kan Jesus ya kay nakapunggus êwês. Dinakêp laya êt. ");
INSERT INTO blx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nuwa nabul-isan laya buy kay êwês tay natalan la. Kabay nakapuwayu yan ayin yaming. ");
INSERT INTO blx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gintan la si Jesus sa balin pinakapuun pari. Nititipun bayduy mani mamunun pari, mani mangatway manungkulan, buy mani manurun Kautusan. ");
INSERT INTO blx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nanunul êt si Pedro kalla nuwa kay idi ya sa marayun pêrad. Sinumun ya sa bakud pinakapuun pari buy nakiiknu ya sa mani magbantay amên mimudu. ");
INSERT INTO blx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ya mani mamunun pari buy kaganawan mangatwan Judioy mangatuynungan, mangkap silan magpapêtêg laban kan Jesus amên maatulan layan kamatyan. Nuwa ayin silan nakitan. ");
INSERT INTO blx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Malakêy tawuy magsabin alwan pêtêg laban kana, nuwa asê pariparisuy pansabin la. ");
INSERT INTO blx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dilag êt umnuy nidêng nga nagsabin alwan pêtêg. Sinabi la, ");
INSERT INTO blx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nalêngê yan na sinabi nay ‘Lasakên kuy Templun ati ya diyag tawu buy sa lalên tatluy allu, mamipaydêng ngakun kaatag templuy alwan diyag tawu.’ ");
INSERT INTO blx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nuwa asê êt pariparisuy pansabin la.” ");
INSERT INTO blx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Amêsên, nidêng nga pinakapuun pari la sa arapan malakê buy pinatang na si Jesus, “Ayin ka nayin maipakitbay laban sa panangkan la kamu?” ");
INSERT INTO blx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nuwa asê nakitbay si Jesus. Sinabi êt pinakapuun pari kana, “Sika nayi ya Cristuy Anak Bapan Namalyari ya Kapapaulimên?” ");
INSERT INTO blx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nakitbay si Jesus, “Siku ya bayna. Buy sikuy ubat sa langit ta in-Anak Tawu, makitan yu kuy nakaiknu sa wanan Bapan Namalyari ya Makapangyarian. Buy sa pag-udung ku, makitan yu kuy idi sa ulap pa mallumatêng.” ");
INSERT INTO blx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sên nalêngên pinakapuun pari ya abitu, nanubag ya. Kabay gininit nay yaming na buy sinabi nay, “A tamina kaylangan na dilag kaatag magpapêtêg, ");
INSERT INTO blx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ta nalêngê taminay pallamus na kan Bapan Namalyari! Sabêt amêsên na iatul yu kana?” Kabay inatulan layan kamatyan. ");
INSERT INTO blx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tinupayan yan dakun umnuy idi baydu. Tinakpan lay mata na, dinugêdugê laya buy sinabi la kanay, “Ulên mu nu sisabêt ta nandugê kamu!” Dinugêdugê ya êt mani magbantay. ");
INSERT INTO blx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kaban nakaiknu si Pedro sa lawasan balin pinakapuun pari kaawyun na mani magbantay ya mamimudu, nagdani kanay gisay babayi ya ipus pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pinakaêlêw naya buy sinabi na, “Sika êt pagkaawyun Jesus ya taga Nazaret.” ");
INSERT INTO blx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nuwa impuglaw Pedroy abiin, “A ku tanday pansabin mu.” Pamakayari, namita ya papakun sa pasbul lawasan. Amêsên, nangkati yay manuk. ");
INSERT INTO blx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Asê naêpêng, nakitan nina êt baydun babayi ya ipus pinakapuun pari. Sinabi na sa mani tawuy idi bayduy, “Ya tawun abiin, gisa ya sa pagkaawyun Jesus!” ");
INSERT INTO blx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nuwa impuglaw wa êt Pedroy abiin. Asê naêpêng, sinabi ya êt mani tawuy idi bayduy, “Pilmin gisa ka sa mani pagkaawyun Jesus, gawan taga Galilea ka êt.” ");
INSERT INTO blx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nuwa sinabin Pedroy, “Taganan a ku kilalay tawun abiin, agyan mati yaku amêsên!” ");
INSERT INTO blx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pamakasabin Pedron abiin, nangkatin manguman na manuk buy naganakan Pedroy sinabin Jesus kana, “Bayu mangkatin katilway manuk, katitlu mukun ipuglaw.” Kabay sadyay tangis Pedro. ");
INSERT INTO blx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pamakamaranun, tambêng nipupulung nga mani mamunun pari, mani mangatway manungkulan, mani manurun Kautusan buy kaatag mangatwan Judioy mangatuynungan. Impagapus la si Jesus buy in-arap kan Gobernador Pilato. ");
INSERT INTO blx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pinatang Gobernador Pilato si Jesus, “Sika nayi ya Arin mani Judio?” Nakitbay si Jesus, “Sikay nay nagsabi.” ");
INSERT INTO blx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Malakêy pan-isangkan mani mamunun pari laban kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kabay pinatang ngina êt Gobernador Pilato, “Nalêngê muy malakêy pan-isangkan la laban kamu. Ayin ka nayin maipakitbay?” ");
INSERT INTO blx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nuwa asê êt nakitbay si Jesus. Kabay nakaupapas si Gobernador Pilato. ");
INSERT INTO blx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Balang Pestan Kaligtasan, naugalyan Gobernador Pilatoy mamibus yan gisay nakasukul ayun sa panyawarên mani tawu. ");
INSERT INTO blx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Dilag gisay nakasukul la naglagyun Barabbas. Nisukul ya gawan gisa ya sa mani nagribeldi sa gubernu buy nakapati yan tawu. ");
INSERT INTO blx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nagdani ya mani tawu kan Gobernador Pilato buy inyawad la kanay daygên nan manguman na mamibus yan gisay nakasukul. ");
INSERT INTO blx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kabay pikitbayan silan Gobernador Pilato, “Labay yu nayin ibus kuy Ari yun mani Judio?” ");
INSERT INTO blx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nasabi nay abiin gawan tanda nay in-arap mani mamunun pari si Jesus kana gawan kay kinasêman laya. ");
INSERT INTO blx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nuwa intustus mani mamunun pari ya mani tawu amên si Barabbas ya yawarên lan ibus. ");
INSERT INTO blx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kabay nanguman namatang si Gobernador Pilato kalla, “Sabêt taman na labay yun daygên ku sa pambêgên yun arin mani Judio?” ");
INSERT INTO blx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Masnêg lan sinabi, “Ipaku ya sa kurus!” ");
INSERT INTO blx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sinabin Gobernador Pilato kalla, “Awta, sabêt ta dinyag nay kasalanan?” Nuwa ingkakadus saman sinabin mani tawuy, “Ipaku ya sa kurus!” ");
INSERT INTO blx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Amêsên, impabus Gobernador Pilato si Barabbas amên mapasaya nay mani tawu. Impalatiku na si Jesus buy inggawang naya sa mani sundalus amên ipaku sa kurus. ");
INSERT INTO blx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gintan mani sundalus si Jesus sa kasawangan palasyun Gobernador Pilato buy tinipun la bayduy kaganawan sundalus ya kaawyun la. ");
INSERT INTO blx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pinayamingan la si Jesus un kulay muraduy balabal kaparisun yaming ari buy nanyag silan kuronay nagdiwi ya impakurona la kana. ");
INSERT INTO blx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pamakayari, sinabi lay, “Pagpalên baman na Arin mani Judio!” ");
INSERT INTO blx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pinatukpatuk lan têkên na ulu na buy pitupaytupayan laya. Nanduku sila kana buy pan-ulimênên laya kanwadis. ");
INSERT INTO blx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pamakayari lan inlamus si Jesus, intas lay balabal nay kulay muradu buy pinayamingan layan sarili nan yaming. Pamakayari, in-awas laya sa balayan amên ipaku sa kurus. ");
INSERT INTO blx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kaban mamita sila, natbêng lay gisay liyaki ya ubat sa panggitnan ya sabay si Simon na taga Cirene ya bapan Alejandro buy si Rufo. Impilit lan impabakay kanay kurus Jesus. ");
INSERT INTO blx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sa pamita la, gintan mani sundalus si Jesus sa lugal la pambêgên lan Golgota ya labay sabin “Lugal Bungu.” ");
INSERT INTO blx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Paynêmên laya dayin alak ka sinabugan mira, nuwa a na ininêm. ");
INSERT INTO blx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Amêsên, impaku layna sa kurus buy pinibabagutan lay yaming na amên matandan lay makwan balang gisa kalla. ");
INSERT INTO blx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nuwebin maranun sabitun impaku la si Jesus sa kurus. ");
INSERT INTO blx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dilag karatula sa ugtun ulun Jesus buy paradi ya nakasulat bayduy pan-isangkan la laban kana, “Siya ya Arin mani Judio.” ");
INSERT INTO blx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dilag êt luway tulisan na impaku sa kurus kaagnan Jesus. Ya gisa, idi sa wanan buy ya gisa, idi sa udi na. ");
INSERT INTO blx_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sa dinyag la kan Jesus, natupad ya impasulat Bapan Namalyari sa kasulatan, “Intuwad layan makasalanan.” ");
INSERT INTO blx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ya mani tawuy manduman baydu, kapêyêngpêyêngan lan manguyam kan Jesus buy pansabin lay, “Uy antu yaba ya sinabi muy lasakên muy Templu buy sa lalên tatluy allu, ipaydêng mun manguman? ");
INSERT INTO blx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Dali, magtabuy ka sa kurus, ta iligtas muy sarili mu!” ");
INSERT INTO blx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Para êt bayduy panguyam mani mamunun pari buy mani manurun Kautusan. Sinabi la sa balang gisa kalla, “Inligtas nay kaatag pakan a nay naman agyun iligtas ya sarili na! ");
INSERT INTO blx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nu makit tamuy makapagtabuy si Cristu sa kurus ya Ari kanun Israel, maniwala kitamu kana!” Inuyam ya êt kaagnan nan impaku sa kurus. ");
INSERT INTO blx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sên ugtuy na, dinumiglêm ma babun luta anggay nan alas tres kaawat. ");
INSERT INTO blx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sên alas tres sanan kaawat, masnêg sinabin Jesus, “Eloi, Eloi, lema sabachthani?” Ya labay sabin, “Bapa ku, Bapa kun Namalyari, siyan pinaulayan muku yata?” ");
INSERT INTO blx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sên nalêngên mani nakaidêng bayduy abiin, sinabi lay, “Lêng-ên yu. Pambêgên na si propeta Elias.” ");
INSERT INTO blx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nuwayuy gisa kalla buy niptês paran bulak sa gisay sanga. Imbasa na sa nangisuy alak buy impasêpsêp kan Jesus. Sinabi na, “Paulayên tamu ya. Elêwên tamu nu lumatêng ngabay si Elias amên mitabuy kana sa kurus.” ");
INSERT INTO blx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amêsên, nagsabin masnêg si Jesus buy nabuytuwan yan inawanên. ");
INSERT INTO blx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sa uras êt abitu, naginit ta panabing sa lalên Templu paubat sa babu angga sa aypa. ");
INSERT INTO blx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nakaidêng sa arapan kurus ya kapitan mani sundalus buy nakit na nu parasaantun nabuytuwan inawanên si Jesus. Kabay nasabi na, “Pêtêg awêd ya Anak Bapan Namalyari ya tawun ati.” ");
INSERT INTO blx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sa narayun pêrad, dilag dakun umnuy babayi ya mangêlêw nu sabêt ta malyari kan Jesus. Kaawyun la si Maria ya taga Magdala, si Salome, buy si Maria ya indun Santiago ya alin Jose. ");
INSERT INTO blx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Paubat sa Galilea, nakilaku buy naglingkud silayna kan Jesus. Idi êt bayduy dakun umnuy babayi ya kaawyun Jesus un naku sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sên nadêm mana, uras san pamil-an ta duspiras san Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Inlumatêng si Jose ya taga Arimatea. Si Jose, panggalangên yan mani kaparisu nan mani mangatwan Judioy mangatuynungan. Gisa ya êt sa mangêtêng sa pag-arin Bapan Namalyari. Pinas-êy nay nakêm nan maku kan Gobernador Pilato ta yawarên nay bangkay Jesus. ");
INSERT INTO blx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sên nalêngên Gobernador Pilato ya nati yana si Jesus, nakaupapas ya. Kabay impabêg nay kapitan mani sundalus buy pinatang na nu pêtêg yabay nati si Jesus. ");
INSERT INTO blx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sên natandan na sa kapitan mani sundalus ya pêtêg yabay nati si Jesus, tinulutan nay kêwên Jose ya bangkay Jesus. ");
INSERT INTO blx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kabay intabuy layna sa kurus ya bangkay Jesus buy binêdbêdan lan telay linu ya kapisaliw Jose. Pamakayari, insun lay bangkay Jesus sa pamilbêngan na inlubtan na dapas. Buy imbulid lay maragul la batuy panakêp lan lawasan pamilbêngan. ");
INSERT INTO blx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nakit Maria ya taga Magdala buy si Maria ya indun Jose nu saantu la insun si Jesus. ");
INSERT INTO blx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pamakayarin Allun Pagpaynawa, nanaliw pabangi silan Maria ya taga Magdala, si Maria ya indun Santiago, buy si Salome, buy naku sila sa pinilbêngan kan Jesus amên bulugan lan pabangi ya bangkay na. ");
INSERT INTO blx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pamakamaranun allun Duminggu, sên pamakaputak mamut, naku sila sa pinilbêngan kan Jesus. ");
INSERT INTO blx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kaban idi sila pun sa dan, nipapatang nga balang gisa kalla, “Sisabêt ta pakisabyan tamun mamibulid batuy pinanakêp sa pinilbêngan?” ");
INSERT INTO blx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nuwa sên pamakaêlêw la, nakit lay nibulid da batuy maragul. ");
INSERT INTO blx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sên sinumun sila sa pinilbêngan, nakit lay gisay bayuntawuy nakayaming makarang nga naputi buy nakaiknu sa wanan. Kabay sadyay limun babayi. ");
INSERT INTO blx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sinabi na kalla, “Agana kaw malimu! Tanda kuy pantêkapên yu si Jesus ya taga Nazaret ya impaku sa kurus. Ayin nina baydi. Nanguman ninan nabyay! Elêwên yuy ati ya pinipakalêkan kana. ");
INSERT INTO blx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mita kawna buy sabin yu sa mani tagasunul na buy kan Pedroy munay na si Jesus sa Galilea. Makit yuya baydu, kaparisun sinabi na kamuyu.” ");
INSERT INTO blx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kinêdêsan sila buy nakaupapas silan nuwayun namita sa pinilbêngan. Sa sadyay limu la, ayin silan pinisabyanan. ");
INSERT INTO blx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Maranundanun allun Duminggu, pamakayarin nanguman nabyay Jesus, nuna yan nagpakit kan Maria ya taga Magdala ya sabay ya babayi ya tinasan nan pituy nadawak ka ispiritu sabitun nuna. ");
INSERT INTO blx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naku si Maria ya taga Magdala sa mani tagasunul Jesus buy imbalita nay nakitan na. Sa uras abitu, manêmtêm buy manangis sila. ");
INSERT INTO blx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nuwa a sila kalabay maniwala sa sinabin Maria ya nanguman nabyay si Jesus buy nagpakit ya kana. ");
INSERT INTO blx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pamakayari, sên mamitay luway tagasunul Jesus papakun sa panggitnan, nagpakit kalla si Jesus, nuwa kaatag ga wangis na. ");
INSERT INTO blx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tambêng silan nag-udung sa mani kaawyun la sa balayan Jerusalem buy imbalita lay nagpakit kalla si Jesus, nuwa a sila êt labay paniwalan. ");
INSERT INTO blx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Amêsên, kaban mangan na mapu buy gisay tagasunul na, nagpakit kalla si Jesus. Sinabyanan na sila gawan ayin silan panampalataya buy nakdêy ya bêkê la, buy gawan a sila kalabay maniwala sa sinabin kaganawan nakakit kana ya nanguman yan nabyay. ");
INSERT INTO blx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sinabin Jesus kalla, “Maku kaw sa buun babun luta buy iaral yu sa kaganawan tawuy Mangêd da Balita tungkul kangku. ");
INSERT INTO blx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sisabêt man na manampalataya buy pabawtismu, miligtas ya sa kaparusan. Nuwa sisabêt man na asê manampalataya, parusan yan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sisabêt man na manampalataya kangku, biyan yan kapangyarian manyag mamakaupapas bilang tanda'. Gawan sa lagyu ku, makapipatas silan nadawak ka ispiritu buy magsabi silan magmikakanayun na sabi. ");
INSERT INTO blx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","A sila dakun mapakun agyan manalan silan utan o makainêm lasun. Buy mapaiyul lay nipagsakit ta paluntuwan lan gamêt la.” ");
INSERT INTO blx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pamakayarin nagsabin Jesus kalla, nitag-ay yina sa langit buy niknu ya sa wanan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nipamitay nan nangaral la mani tagasunul na sa kaganawan lugal. Sinawpan silan Panginuun sa pandaygên la buy impapêtêg nay pan-iaral sa kapamilatan pam-i nan kapangyarian manyag mamakaupapas.");
INSERT INTO blx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Panggalangên na Teofilo, sabitun idi pun baydi si Jesus kantamu, malakêy nakakit sa dinyag na. Buy impatanda lay nalyari paubat sa nuna yan nangaral Sabin Bapan Namalyari. Malakê êt ta nanulat abituy impatanda la. Buy pamakayari kun inusisa ya kaganawan nalyari ubat pun sabitun nangaral si Jesus, naisip kun ipakapala ku êt isulat ta kuwentu para kamuyu ");
INSERT INTO blx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","amên mapilmiyan mun pêtêg ga aral la inturu kamu. ");
INSERT INTO blx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sabitun si Herodes ya ari sa prubinsyan Judea, dilag gisay pari ya naglagyun Zacarias. Gisa ya sa pangkat pari ya pambêgên “Pangkat Abias.” Dilag yan asaway naglagyun Elisabet ya ubat sa layin Aaron ya nunan pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Si Zacarias buy si Elisabet, parisu silan matinêk sa pangêlêw Bapan Namalyari buy pêtêg silan manunul sa mani pan-iutus Panginuun. ");
INSERT INTO blx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ayin silan anak gawan layus si Elisabet buy parisu silaynan tuwa. ");
INSERT INTO blx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Gisay allu, pangkat ta êt Zacarias ya maglingkud sa Templun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Buy kaparisun manan naugalyan mani pari, nibabagutan sila amên matandan la nu sisabêt ta manlêb insensu ya pamadêp kan Bapan Namalyari. Si Zacarias ya nabagut. Kabay sinumun ya sa Templu. ");
INSERT INTO blx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kaban manlêb yan insensu baydu, malakêy tawuy manalangin sa lawasan Templu. ");
INSERT INTO blx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Amêsên, bêngat tan nagpakit kan Zacarias ya gisay ang-el Panginuun. Nakaidêng ya sa wanan pamiandugan pansêlbên na insensu. ");
INSERT INTO blx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sên pamakakit na sa ang-el, nakatêgag buy nalimwan si Zacarias. ");
INSERT INTO blx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nuwa sinabin ang-el kana, “Agana ka malimuy Zacarias! Ta inlêngên Bapan Namalyari ya panalangin mu. Si Elisabet ta asawa mu, manganak yan gisay liyaki. Ya ipalagyu mu kana, Juan. ");
INSERT INTO blx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Matula ka gawan kana buy malakêy tawu êt ta matula sa pamianak kana, ");
INSERT INTO blx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","gawan magin dakila ya sa pangêlêw Panginuun. Kaylangan a ya minêm alak o agyan sabêt man na mamakalasing. Paubat pun sa idi ya sa bitukan indu na, matupus sinan Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Malakêy mani Israelitay ipaudung na sa Panginuun ya Bapan Namalyari la. ");
INSERT INTO blx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Muna ya sa Panginuun amên il-an nay mani tawu sa pallumatêng Panginuun. Madyag nay ati sa sawup kapangyarian Ispiritun Bapan Namalyari kaparisun dinyag propeta Elias sabitun nuna ya naiudung nay pamiiidun mitatabapa. Buy ya nakêm mani tawuy asê manunul kan Bapan Namalyari, ibayu na amên magin kaparisu silan mani tawuy matinêk.” ");
INSERT INTO blx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sinabin Zacarias sa ang-el, “Ipakun kun matandan nu pêtêg malyari ya ati? Ta tuwa kina, para êt bayduy asawa ku.” ");
INSERT INTO blx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nakitbay ya ang-el, “Siku si Gabriel ya maglingkud sa arapan Bapan Namalyari sa langit. Impalaku naku kamu amên sabin na mangêd da balitan ati. ");
INSERT INTO blx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ya kaganawan sinabi ku kamu, pêtêg malyari sa lumatêng nga panawun. Nuwa gawan a ka naniwala sa sinabi ku, mapakadyag kan pipi. A ka makapagsabi angga sa manganak ka asawa mu.” ");
INSERT INTO blx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kaban idi sa lawasan na mani tawuy mangêtêng sa pag-awas Zacarias, nakaupapas sila gawan naêpêng ya sa lalên Templu. ");
INSERT INTO blx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sên pag-awas na, siyan a yina makapagsabi buy kay maningyal ya tana. Kabay inisip lay dilag impakit si Bapan Namalyari kana sa lalên Templu. Buy ubat ta baydu, a yina nakapagsabi. ");
INSERT INTO blx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pamakayarin panawun paglingkud na sa Templu, nuli si Zacarias. ");
INSERT INTO blx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A yabay naêpêng, nangalêk si Elisabet buy sa lalên limay buwan, a ya nag-awas sa bali la. ");
INSERT INTO blx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kabay sinabi na, “Ati ya kangêdan Bapan Namalyari kangku, ta intas na kangkuy dêng-êy kun asê manganak.” ");
INSERT INTO blx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sên ikaanêm man buwan buktut Elisabet, in-utus Bapan Namalyari si ang-el Gabriel sa balayan Nazaret sa prubinsyan Galilea. ");
INSERT INTO blx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","In-utus yan maku sa gisay dalagay naglagyun Maria ya nakal-an itangên kan Jose ya gisay liyaki ya layin Arin David. ");
INSERT INTO blx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nagdani ya ang-el sa dalaga buy sinabi kanay, “Matula ka, gawan kapapaidu ka kan Bapan Namalyari! Idi kamuy Panginuun.” ");
INSERT INTO blx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Naguluy isip Maria sa sinabin ang-el kana. Kabay pan-isipin na nu sabêt ta labay sabin abitu. ");
INSERT INTO blx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nuwa sinabin ang-el kana, “Agana ka malimuy Maria, ta kapapaidu ka kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lêng-ên muy ati! Mabuktut ka buy manganak kan gisay liyaki ya palagyunan mun Jesus. ");
INSERT INTO blx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Magin dakila ya buy bêgên yan Anak Bapan Namalyari ya Katatag-ayan. Idin Bapan Namalyari kanay katungkulan mag-ari kaparisun pag-arin ninunu na ya si Arin David sabitun nuna. ");
INSERT INTO blx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mag-ari ya sa mani layin Jacob kanuman buy ya pag-ari na, ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kabay namatang si Maria sa ang-el, “Parasaantun malyari ya ati, pakan dalaga ku pun?” ");
INSERT INTO blx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nakitbay ya ang-el, “Mapakamuy Ispiritun Bapan Namalyari buy mangalêk ka sa kapamilatan kapangyarian Bapan Namalyari ya Katatag-ayan. Kabay ya ianak mu, ayin yan kasalanan buy bêgên yan ‘Anak Bapan Namalyari.’ ");
INSERT INTO blx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Si Elisabet ta kamag-anak mu, tandan kaganawan na layus ya. Nuwa amêsên, anêm ma buwan nay nan nabuktut, agyan tuwa yina. ");
INSERT INTO blx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta ayin bagay ya asê madyag Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nakitbay si Maria, “Kay ipus sakun Bapan Namalyari. Malyari dayi kangkuy mani sinabi mu.” Pamakayari, namitay ang-el. ");
INSERT INTO blx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Asê naêpêng, nangamut si Marian naku kallan Elisabet sa gisay balayan na idi sa bung-uy prubinsyan Judea. Pamakalatêng na sa bali la, sinabi na, “Nagpapakun kaynay Elisabet?” ");
INSERT INTO blx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sên nalêngên Elisabet ta pangatulan Maria, nagkimit ta kulaw sa bitukan Elisabet. Natupus yan Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Masnêg sinabin Elisabet, “Igit kan pinagpalan Bapan Namalyari kaysa kaganawan babayi buy pinagpala na êt ta ianak mu! ");
INSERT INTO blx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Gisay maragul la karangalan na lakwên nakun indun Panginuun ku. ");
INSERT INTO blx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sên kinatula muku, nagkimit ta kulaw sa bituka ku gawan sa tula na. ");
INSERT INTO blx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pinagpala kan Bapan Namalyari gawan naniwala kan matupad da sinabi na kamu.” ");
INSERT INTO blx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Buy sinabin Maria, “Buun bêkê kun ulimênên na Panginuun, ");
INSERT INTO blx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","buy masaya ku kan Bapan Namalyari ya Mamiligtas ku, ");
INSERT INTO blx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","gawan ginanaka naku ya kay ipus na! Kabay ubat amêsên, ya kaganawan tawu, ituwad lakun pinagpala, ");
INSERT INTO blx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","gawan sa kangêdan na dinyag kangkun Bapan Namalyari ya makapangyarian. Ayin yan kaparisu! ");
INSERT INTO blx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pangkalunusan nay mani tawuy dilag limu kana ubat pun sabitun nunan panawun anggan makanuman. ");
INSERT INTO blx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impakit nay kapangyarian na sa kapamilatan mani mamakaupapas ya diyag na. In-ikyat nay mani tawuy pawan matag-ay ya pangêlêw sa sarili. ");
INSERT INTO blx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Intas nay tungkulan mani manungkulan buy intag-ay nay mani nayêpay nakêm. ");
INSERT INTO blx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pinakabsuy nan mangêd da mani layangên, nuwa impabita nan ayin gintan na mabandi. ");
INSERT INTO blx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Sinawpan na kitamuy mani Israelitay maglingkud kana. Ta a na nalitêpan na impangaku na kan Abraham angga sa mani layi na, ya kalunusan na sila kanuman.” ");
INSERT INTO blx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Buy nakitugêl si Maria kallan Elisabet un tatluy buwan bayu ya nuli. ");
INSERT INTO blx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Amêsên, sên niras say panawun panganak Elisabet, naianak nay gisay liyaki. ");
INSERT INTO blx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nabalitan mani karani nan bali buy mani kamag-anak la nu parasaantu yan kinalunusan Panginuun. Kabay nakitula sila êt kana. ");
INSERT INTO blx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sên waluy alluy nan kulaw, nagtipun na mani karani lan bali buy kamag-anak la amên tulin ya. Zacarias dayi ya ipalagyu la kana gawan lagyun bapa nay abitu. ");
INSERT INTO blx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nuwa sinabin Elisabet, “Te, asê! Juan na ipalagyu kana.” ");
INSERT INTO blx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Sinabi la, “Pakan sa mani kamag-anak yuy ayin yan parabaysên na lagyu ta.” ");
INSERT INTO blx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kabay pinatang la si Zacarias sa kapamilatan singyal nu sabêt ta labay nan ipalagyu sa kulaw. ");
INSERT INTO blx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naningyal yan pamisulatan buy insulat nay “Juan na lagyu na.” Nakaupapas ya kaganawan idi baydu. ");
INSERT INTO blx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tambêng êt nakapagsabi si Zacarias buy nangulimên kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sa nalyarin abitu, nalimuy kaganawan karani lan bali. Kabay pisasabyan na ati sa buun bung-uy prubinsyan Judea ya nalyari. ");
INSERT INTO blx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ya kaganawan nakabalita, nangisip sila buy namatang, “Mapakadyag sabêt ta anak ka ati?” Sinabi lay ati gawan makit la kanay kapangyarian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Si Zacarias ya bapan Juan, natupus yan Ispiritun Bapan Namalyari buy namipatanda yan sabi ya ubat kan Bapan Namalyari. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ulimênên na Panginuun ya Bapan Namalyarin mani Israelita! Ta naku ya baydi amên iligtas nay mani tawuy pinili na. ");
INSERT INTO blx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","In-utus na kantamuy makapangyarian ya Mamiligtas ya sabay ya ubat sa layin David ya lingkud na. ");
INSERT INTO blx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ati ya impangaku na sabitun nunan panawun sa kapamilatan mani banal la propeta, ");
INSERT INTO blx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ya iligtas na kitamu sa mani kapati tamu buy sa kaganawan manubag kantamu. ");
INSERT INTO blx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Impangaku na êt ta kalunusan nay mani ninunu tamu buy tuparên nay banal la kasunduwan na kalla. ");
INSERT INTO blx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Abiin na impangaku na kan Abraham ma ninunu tamu. ");
INSERT INTO blx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Iligtas na kitamu sa kapati tamu amên makapaglingkud kitamun ayin limu kana, ");
INSERT INTO blx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","magin malinis buy matinêk sa pangêlêw na kaban nabyay kitamu pun.” ");
INSERT INTO blx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sinabin Zacarias sa anak na, “Anak ku, bêgên lakan propetan Bapan Namalyari ya Katatag-ayan, tagawan sikay muna sa Panginuun amên il-an na mani tawu sa pallumatêng na. ");
INSERT INTO blx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ipatanda mu sa mani tawu nu parasaantu silan miligtas sa kapamilatan pamatawad sa mani kasalanan la. ");
INSERT INTO blx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gawan mapallunus ya Bapa tamun Namalyari, iutus nay mamiligtas kantamu kaparisun mamut ta mam-in sawang sa kaganawan tawu ");
INSERT INTO blx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","amên masawangan na mani tawuy idi sa nadiglêm buy mangalimu sa kamatyan. Buy turwanan na kitamu nu parasaantun bumyay dilag kapatêtbêkan.” ");
INSERT INTO blx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Amêsên, dinumagul si Juan buy nagin napas-êy ya nakêm na. Nanugêl ya sa kakyangan angga sa allun nag-umpisa yan nangaral sa mani Israelita. ");
INSERT INTO blx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sa panawun abitu, si Emperador Augusto ya pinakamatag-ay ya mamunu sa Roma buy sa mani kaatag lugal la pansakupun na. Impabalita nay kautusan na sa mani tawu. Sinabi na, “Maku kaw sa lugal pipuunpuunan yu amên magpasensus.” ");
INSERT INTO blx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ati ya nunan sensus sabitun si Cirenio ya Gobernador sa prubinsyan Siria. ");
INSERT INTO blx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kabay naku ya kaganawan tawu sa balang lugal pipuunpuunan la amên magpasensus. ");
INSERT INTO blx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Si Jose, taga balayan Nazaret ya sa prubinsyan Galilea. Layi yan Arin David. In-anak ya sa Bethlehem sa prubinsyan Judea. Kabay naku ya baydu amên magpasensus, ");
INSERT INTO blx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","kaawyun na si Mariay itangên na ya marani yan manganak. ");
INSERT INTO blx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kaban idi sila sa Bethlehem, inlumatêng ngay uras panganak Maria. ");
INSERT INTO blx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nuwa gawan ayin nan lugal para kalla sa bali, nanugêl sila tana sa bali ya tutugêlan mani saysay. In-anak nay panganay nay gisay liyaki. Inlampinan nay kulaw buy impakalêk na sa pamakanan mani saysay. ");
INSERT INTO blx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sa yabin abitu, dilag mani magpastul tupay narani sa Bethlehem ya magpuyat magbantay sa mani tupa la. ");
INSERT INTO blx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Amêsên, tambêng nagpakit kallay gisay ang-el Bapan Namalyari buy dilag mamakapasilêw wa sawang Bapan Namalyari sa palitêng la. Kabay sadyay limu la. ");
INSERT INTO blx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nuwa sinabin ang-el kalla, “Agana kaw malimu ta naku waku baydi amên sabin kamuyuy mangêd da balitay mam-in sadyay tula sa kaganawan tawu. ");
INSERT INTO blx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gawan in-anak amêsên sa Bethlehem sa balayan Arin David da Mamiligtas ya sabay si Cristu ya Panginuun. ");
INSERT INTO blx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ati ya patanda yu. Makitan yuy gisay kulaw wa inlampinan buy nakakalêk sa pamakanan mani saysay.” ");
INSERT INTO blx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pamakayarin nagsabin ang-el, tambêng nagpakit ta malakêy ang-el sa langit ta niaawyun nangulimên kan Bapan Namalyari. Sinabi la, ");
INSERT INTO blx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ulimênên si Bapan Namalyari ya idi sa langit! Buy sa babun luta, dilag gan kapatêtbêkan na mani tawuy kapapaidu kana.” ");
INSERT INTO blx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sên nakuy na sa langit ta mani ang-el, nisasabi ya mani magpastul tupa. Sinabi la, “Kaksaw kaw ta maku kitamu sa Bethlehem buy êlêwên tamuy mani nalyari ya sinabi kantamun ang-el Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kabay pinaras-paras lan naku sa Bethlehem. Pamakalatêng la baydu, nakitan la si Maria buy si Jose kaawyun lay kulaw wa nakakalêk sa pamakanan mani saysay. ");
INSERT INTO blx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sên nakit lay kulaw, imbalita lay sinabin ang-el tungkul kana. ");
INSERT INTO blx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nakaupapas ya kaganawan nakalêngê sa sinabin mani magpastul. ");
INSERT INTO blx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nuwa si Maria, impakatêbêk na sa nakêm nay kaganawan buy pan-isipin nay ati. ");
INSERT INTO blx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nag-udung sa pagpastulan na mani magpastul ya pan-ulimênên la si Bapan Namalyari gawan sa kaganawan nalêngê buy nakitan la, ta pêtêg ga kaganawan sinabin ang-el kalla. ");
INSERT INTO blx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pamakalatêng ikawaluy allu, impatuli ya kulaw buy pinalagyunan layan Jesus, ta abiin na lagyuy sinabin ang-el bayu yapun ialêk. ");
INSERT INTO blx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sên inlumatêng ngay allun pallinis kallan Maria buy kan Jose, naku sila sa Templu sa balayan Jerusalem amên tuparên na Kautusan na impasulat kan Moises. Gintan la êt si Jesus amên iandug kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ta ati ya nakasulat sa Kautusan Panginuun, “Ya kaganawan panganay ya liyaki, kaylangan yan iandug sa Panginuun.” ");
INSERT INTO blx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kabay namiandug silan gisay paris batu-batu buy pati-pati, ta abiin na idi sa Kautusan Panginuun. ");
INSERT INTO blx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dilag baydun gisay liyaki sa Jerusalem ma naglagyun Simeon. Matinêk ya buy dilag yan limu kan Bapan Namalyari buy idi kanay Ispiritun Bapan Namalyari. Mangêtêng ya êt sa pallumatêng Cristuy Mamiligtas sa Israel. ");
INSERT INTO blx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sinabin Ispiritun Bapan Namalyari kanay, “A ka mati anggan a mu makit ta Cristuy impangakun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sa allun abitu, impalaku yan Ispiritun Bapan Namalyari sa kasawangan Templu. Kabay sên idi yina sa Templu, sinumun si Jose buy si Maria un aampun nay kulaw, ta daygên lay idi sa Kautusan tungkul kana. ");
INSERT INTO blx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Si Simeon, inampun nay kulaw buy inulimên na si Bapan Namalyari. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“Panginuun, kay gisa kun maglingkud kamu. Amêsên, naêtêng kinay Mamiligtas ya impangaku mu ya in-il-an mu para sa kaganawan tawu. Sabay ya mam-in sawang sa isip mani alwan Judio, buy siyay mam-in karangalan sa mani Israelita ya pinili mu. Panginuun, kêwên mukina amêsên un dilag kapatêtbêkan, ta natupad day impangaku mu kangku.” ");
INSERT INTO blx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nakaupapas ya mangatwan kulaw sa sinabin Simeon tungkul kana. ");
INSERT INTO blx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sinabin Simeon kan Maria ya indu nan Jesus, “Pagpalên kaw Bapan Namalyari. Ya kulaw wa ati, in-il-an amên itag-ay buy iyêpa ya mani tawu sa Israel. Agyan siyay magin tanda' ya ubat kan Bapan Namalyari, pangkalabanên yapun êt malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sa pakapakun baydu, masakitan ka êt, nanuwad natayad da kêyay inlatug sa bêkê mu. Buy gawan sa daygên na, maipatanday idi sa isip malakêy tawu.” ");
INSERT INTO blx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Idi êt baydu sa Templuy gisay propetay babayi ya naglagyun Ana. Anak yan Fanuel ya layin Aser. Nisadsad ya sa pangatwa na. Pipituy tawun pamiawyun lan miasawa ubat pun sabitun intangên sila ");
INSERT INTO blx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","bayu ya nabal-u. Amêsên, walumpu buy apat ta tawun na. Allu buy yabi yan mamaku sa Templu amên mangulimên sa kapamilatan pag-ayunu buy panalangin. ");
INSERT INTO blx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sa uras êt abitu, nagdani ya kan Maria buy kan Jose buy nagpasalamat ya kan Bapan Namalyari. Dilag êt tawu bayduy mangêtêng sa pallumatêng Cristu. Kabay sinabin Ana kalla, “Ati ya kulaw ya Mamiligtas ya impangakun Bapan Namalyari ya sabay ya Cristuy mangatbus kasalanan mani Israelita!” ");
INSERT INTO blx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sên natupad Jose buy si Maria ya kaganawan sêpat lan daygên ya idi baydu sa Kautusan Panginuun, nuli silayna sa Nazaret ya sabay ya balayan la sa prubinsyan Galilea. ");
INSERT INTO blx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dinumagul si Jesus buy nagin napas-êy, idi kanay kabiyasnan buy kapapaidu ya kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sa balang tawun, dilag Pestan Kaligtasan sa Jerusalem. Naugalyan Jose buy si Maria ya makipesta. ");
INSERT INTO blx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sên mapu buy luway tawun nan Jesus, naku silan nanguman sa Pestan Kaligtasan, ta abiin na naugalyan la. ");
INSERT INTO blx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pamakayarin pesta, sên nuli silayna, asê tandan mangatwan Jesus ya nagbalag ya sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Indap la nu kaawyun ninan kabaryu la sa pamita la. Sên kaawat tana, tingkap laya sa mani kamag-anak la buy sa mani kaluguran la. ");
INSERT INTO blx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sên a ya makitan mangatwa na, nag-udung sila sa Jerusalem amên têkapên laya baydu. ");
INSERT INTO blx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sên pamakatatluy allu, nakitan la si Jesus sa kasawangan Templuy nakaiknu sa bunak mani manurun Kautusan. Mallêngê ya buy mamatang kalla. ");
INSERT INTO blx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ya kaganawan tawuy idi bayduy nakalêngê, nakaupapas sila sa kabiyasnan na buy sa mani pakitbay na. ");
INSERT INTO blx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sên nakitan yan mangatwa na, nakaupapas sila. Kabay sinabin indu na, “Anak kuway siyan dinyag muya kanyan na abiin ta? Nigaganaka kay sa pangkap kamu!” ");
INSERT INTO blx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nakitbay si Jesus, “Indu way, uysiyan pantêkapên yuku yata? A yu nayi tanday sêpat idi yaku baydi sa balin Bapa ku?” ");
INSERT INTO blx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nuwa a la napukatan na labay nan sabin. ");
INSERT INTO blx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nuli si Jesus sa Nazaret kaawyun nay mangatwa na buy mapanunul ya kalla. Si Maria, impakatêbêk na sa bêkê nay kaganawan nalyari. ");
INSERT INTO blx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Dinumagul si Jesus buy nagin biyasa ya. Kapapaidu ya kan Bapan Namalyari buy sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sên ikamapu buy limay tawun pag-arin Emperador Tiberio sa Roma, si Poncio Pilatoy gobernador sa prubinsyan Judea, si Herodes Antipas ya gobernador sa prubinsyan Galilea, si Felipe ya patêl nay gobernador sa Iturea buy sa Traconite buy si Lisanias ya gobernador sa Abilinia. ");
INSERT INTO blx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ya mani pinakapuun pari yaman, silan Anas buy si Caifas. Sa panawun abitu, idi sa kakyangan si Juan ya anak Zacarias. Impatandan Bapan Namalyari ya sabi na kan Juan. ");
INSERT INTO blx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kabay inlakun Juan ya mani lugal la mitalipay sa ilug Jordan. In-aral na sa mani tawuy, “Pagsisyan buy itgên yuy panyag kasalanan buy magpabawtismu kaw amên patawarên kaw Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sa dinyag nan abiin, natupad da insulat Propeta Isaias, “Dilag gisay mamibêg sa kakyangan na pansabin na, ‘Il-an yuy danan Panginuun. Itinêk yuy balang danan na! ");
INSERT INTO blx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Buntunan yuy mani nalawug ga lugal, buy patalên na mani bung-uy. Itinêk yuy dan na nikatukawkaw, buy ipakapalay mani nikalikêdlikêd da dan. ");
INSERT INTO blx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Buy makitan kaganawan tawuy pamiligtas ya daygên Bapan Namalyari.’ ” ");
INSERT INTO blx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Naku kan Juan na malakêy tawu amên magpabawtismu. Sinabi na kalla, “Sikaw wa kaparisun lupung, sisabêt ta nagsabi kamuyun makatakas kaw sa lumatêng nga parusan Bapan Namalyari? ");
INSERT INTO blx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nu pêtêg kaw nagsisi sa mani kasalanan yu, ipakit yu sa mani diyag yu. Agana yu isipin na a kaw maparusan gawan layi kaw Abraham. Pansabin ku kamuyuy agyan na mani batun ati, madyag Bapan Namalyarin mani layin Abraham. ");
INSERT INTO blx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Amêsên, kaparisu kaw kayuy asê managêy mangêd. Kabay nakal-an nan mamarusa si Bapan Namalyari kamuyu ya paran palatsaw wa nakal-an nan mamutus puun kayu buy isamwag sa apuy.” ");
INSERT INTO blx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pinatang mani tawu si Juan, “Nu parabaydu awêd, sabêt ta sêpat yan daygên?” ");
INSERT INTO blx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nakitbay si Juan, “Nu dilag kaw luway yaming, idin yuy gisa sa tawuy ayin yaming. Buy nu dilag kaw êt kanên, biyan yuy ayin kanên.” ");
INSERT INTO blx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Dilag êt mani maningil buwis ya inlumatêng amên magpabawtismu. Pinatang laya, “Manuru, sabêt ta sêpat yan daygên?” ");
INSERT INTO blx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Pikitbayan silan Juan, “Agana kaw maningil makamal un igit pun sa sêpat yun pansingilin.” ");
INSERT INTO blx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dilag êt mani sundalus ya namatang kana, “Buy sikay êt taman nay, sabêt ta sêpat yan daygên?” Sinabin Juan kalla, “Agana kaw mamilit mangwan alwan kamuyu o manangkan alwan pêtêg. Sêpat kaw matula sa mani upa yu!” ");
INSERT INTO blx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mangêtêng nga mani tawu sa pallumatêng Cristu ya impangakun Bapan Namalyari. Kabay inisip la, “Si Juan na lawês ya Cristuy pan-êtêngên yan?” ");
INSERT INTO blx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nuwa sinabin Juan kalla, “Pambawtismuwan kataw sa lanêm, nuwa dilag gisay lumatêng nga makapangyarian pun kangku. A ku sêpat mantan sandalyas na. Bawtismuwan nakaw sa Ispiritun Bapan Namalyari buy apuy. ");
INSERT INTO blx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Maiparisu ya sa gisay mamibalusbus trigu. Ta ya triguy naibalusbus sana, sabay ya pan-isêmpan. Nuwa ya apa, sabay ya pan-ulamên sa apuy ya asê mangapalêng.” ");
INSERT INTO blx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sa pangaral Juan sa Mangêd da Balita, malakê pun êt ta in-aral na. ");
INSERT INTO blx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kabay agyan si Herodes Antipas ya gobernador sa prubinsyan Galilea, sinabyanan yan Juan gawan sa nadawak ka pandaygên na. Sinabi na, “Asê ustuy pinag-asawa mu si Herodias ya asawan patêl mu!” ");
INSERT INTO blx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kabay impasukul na si Juan. Sa pakapakun baydu, nadagdagan na kasalanan Gobernador Herodes Antipas. ");
INSERT INTO blx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sabitun asê pun impasukul si Juan, namawtismu ya sa mani tawu. Amêsên, nagpabawtismu êt kana si Jesus. Buy sên nanalangin si Jesus, nawang-at ta langit ");
INSERT INTO blx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","buy nagtabuy kanay Ispiritun Bapan Namalyari ya nanuwad gisay pati-pati. Buy dilag gisay tunuy ya ubat sa langit ta nagsabin, “Sikay kakaidwan kun Anak ya kapapaidu kangku.” ");
INSERT INTO blx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sên nag-umpisay nan nangaral si Jesus, tatlumpuy tawun nayna. Agyan naianak ya sa kapamilatan kapangyarian Ispiritun Bapan Namalyari, indap mani tawu, si Jesus anak yan Jose ya anak Eli. ");
INSERT INTO blx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si si Eli, anak yan Matat, ya anak kaman êt Levi. Si si Levi, anak yan Melqui, ya anak kaman êt Janai. Si si Janai, anak yan Jose, ");
INSERT INTO blx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ya anak kaman êt Matatias. Si si Matatias, anak yan Amos, ya anak kaman êt Nahum. Si si Nahum, anak yan Esli, ya anak kaman êt Nagai. ");
INSERT INTO blx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si si Nagai, anak yan Matat, ya anak kaman êt Matatias. Si si Matatias, anak yan Semei, ya anak kaman êt Josec. Si si Josec, anak yan Joda, ");
INSERT INTO blx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ya anak kaman êt Joanan. Si si Joanan, anak yan Resa, ya anak kaman êt Zerubabel. Si si Zerubabel, anak yan Salatiel, ya anak kaman êt Neri. ");
INSERT INTO blx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si si Neri, anak yan Melqui, ya anak kaman êt Adi. Si si Adi, anak yan Cosam, ya anak kaman êt Elmadam. Si si Elmadam, anak yan Er, ");
INSERT INTO blx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ya anak kaman êt Josue. Si si Josue, anak yan Eliezer, ya anak kaman êt Jorim. Si si Jorim, anak yan Matat, ya anak kaman êt Levi. ");
INSERT INTO blx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si si Levi, anak yan Simeon, ya anak kaman êt Juda. Si si Juda, anak yan Jose, ya anak kaman êt Jonam. Si si Jonam, anak yan Eliaquim, ");
INSERT INTO blx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ya anak kaman êt Melea. Si si Melea, anak yan Menna, ya anak kaman êt Matat. Si si Matat, anak yan Natan, ya anak kaman êt David. ");
INSERT INTO blx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si si David, anak yan Jesse, ya anak kaman êt Obed. Si si Obed, anak yan Boaz, ya anak kaman êt Salmon. Si si Salmon, anak yan Naason ");
INSERT INTO blx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ya anak kaman êt Aminadab. Si si Aminadab, anak yan Admin, ya anak kaman êt Arni. Si si Arni, anak yan Esrom, ya anak kaman êt Fares. Si si Fares, anak yan Juda, ");
INSERT INTO blx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ya anak kaman êt Jacob. Si si Jacob, anak yan Isaac, ya anak kaman êt Abraham. Si si Abraham, anak yan Terah, ya anak kaman êt Nahor. ");
INSERT INTO blx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si si Nahor, anak yan Serug, ya anak kaman êt Reu. Si si Reu, anak yan Peleg, ya anak kaman êt Eber. Si si Eber, anak yan Sala, ");
INSERT INTO blx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ya anak kaman êt Cainan. Si si Cainan, anak yan Arfaxad, ya anak kaman êt Shem. Si si Shem, anak yan Noe, ya anak kaman êt Lamec. ");
INSERT INTO blx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si si Lamec, anak yan Metusalem, ya anak kaman êt Enoc. Si si Enoc, anak yan Jared, ya anak kaman êt Mahalaleel. Si si Mahalaleel, anak yan Cainan, ya anak kaman êt Enos. ");
INSERT INTO blx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si si Enos, anak yan Set, ya anak kaman êt Adan. Buy si si Adan, anak yan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Amêsên, natupus Ispiritun Bapan Namalyari si Jesus. Namita ya sa ilug Jordan buy impalêt yan Ispiritun Bapan Namalyari sa kakyangan. ");
INSERT INTO blx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Sa lalên apattapuy allu, pantuksun yan Satanas. Sa panawun abitu, asê mangan si Jesus agyan dakun sabêt. Kabay nalayang-layang ya. ");
INSERT INTO blx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sinabin Satanas kana, “Nu sikay Anak Bapan Namalyari, daygên mun kanên na batun ati.” ");
INSERT INTO blx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nuwa pikitbayan yan Jesus, “Ati ya nakasulat sa Sabin Bapan Namalyari, ‘Alwan kay sa kanên mambumyay ya tawu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pamakayari, inlaku yina êt Satanas sa gisay matag-ay ya lugal amên tuksun. Kabay impakit kanay kaganawan kaarian sa babun luta sa gisay pakulimad. ");
INSERT INTO blx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sinabin Satanas, “Idin ku kamuy kaganawan kapangyarian buy kaganawan pibandiyan na abiin, ta indin kangkuy ati buy malyari ku êt idin agyan sisabêt ta labay kun pamyanan. ");
INSERT INTO blx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kabay nu ulimênên muku, idin ku kamuy kaganawan abiin.” ");
INSERT INTO blx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nakitbay si Jesus, “Idi sa kasulatan, ‘Kay Panginuun mun Namalyari ya ulimênên mu buy pagsuywan mu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pamakayari, pikilaku yan Satanas sa Jerusalem sa têngêl Templu buy sinabi na kan Jesus, “Nu sikay Anak Bapan Namalyari, magnabu ka di. ");
INSERT INTO blx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ta idi sa kasulatan, ‘Iutus Bapan Namalyari ya mani ang-el na amên illagan laka.’ ");
INSERT INTO blx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Buy ‘Sal-un laka amên asê midumpul sa batuy bitis mu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nuwa pikitbayan yan Jesus, “Ati ya nakasulat sa Sabin Bapan Namalyari, ‘Agana mu subukun ya Panginuun mun Namalyari.’ ” ");
INSERT INTO blx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pamakayarin tinuksun Satanas si Jesus sa kaganawan paralan, inlakwanan naya buy nangêtêng ya tanan mangêd da uras amên tuksun nan manguman. ");
INSERT INTO blx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nag-udung si Jesus sa prubinsyan Galilea un idi kanay kapangyarian Ispiritun Bapan Namalyari. Niwagaw wa balita tungkul kana sa kaganawan lugal baydu. ");
INSERT INTO blx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nanuru ya sa mani balin pagtipunan mani Judio buy inulimên yan kaganawan tawu. ");
INSERT INTO blx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Amêsên, nuli si Jesus sa Nazaret sa lugal la kinaragulan na. Sên Alluy nan Pagpaynawa, sinumun ya sa balin pagtipunan mani Judio ya mana nan pandaygên. Nidêng ya amên mamasan Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Inggawang kanay nakatilitil la pinisulatan sabin propeta Isaias. Kabay intiknal na buy sên nakitan nay pantêkapên, binasa nay paradi, ");
INSERT INTO blx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ya Ispiritun Panginuun, idi ya kangku, gawan intalaga nakun mangaral Mangêd da Balita sa mani kalulu. In-utus nakun mipatanda sa mani nadakêp pa mibus silayna buy sabin sa mani bulag ga makakit silayna. In-utus naku êt amên ibus ya mani pan-ipusun. ");
INSERT INTO blx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Buy ipatanday inlumatêng ngay panawun pamiligtas Panginuun.” ");
INSERT INTO blx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pamakayari, intilitil Jesus ya kasulatan buy in-udung na sa maglingkud. Kabay niknu ya amên mangaral. Buy pinakaêlêw yan kaganawan idi baydu. ");
INSERT INTO blx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sinabi na kalla, “Amêsên, kaban mallêngê kaw, natupad ya idi sa Kasulatan.” ");
INSERT INTO blx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nakaupapas ya kaganawan tawu buy sinabi la, “Pawan mangêd da pagsabi na! Pakan kay anak yan Jose ya kabaryu tamu ta!” ");
INSERT INTO blx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kabay sinabin Jesus kalla, “Pilmin ungkatên yu kangkuy ati ya panabin, ‘Manulu, paiyulun mu pun ya sarili mu.’ Ta labay yun ipadyag kangkuy mamakaupapas baydi sa sarili kun balayan ya nabalitan yuy dinyag ku sa balayan Capernaum.” ");
INSERT INTO blx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sinabi pun êt Jesus kalla, “Pansabin ku kamuyuy ayin propetay pantanggapên sa sarili nan balayan. ");
INSERT INTO blx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ganakên yuy nalyari sabitun panawun propeta Elias. Sên asê namauran si Bapan Namalyari sa tatluy tawun buy kapaka, inlayang nga kaganawan idi baydu. Sa panawun abitu, malakêy bal-u sa Israel. ");
INSERT INTO blx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nuwa asê impalakun Bapan Namalyari kalla si Elias, nun a sa gisay bal-u ya alwan Judioy idi sa balayan Sarepta ya sakup Sidon. ");
INSERT INTO blx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Para êt bayduy nalyari sa panawun propeta Eliseo. Malakêy tawu sa Israel ya dilag malalay sakit sa balat. Nuwa ya pinaiyul Eliseo, kay si Naaman ya alwan Judio ya taga Siria.” ");
INSERT INTO blx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sên nalêngên mani tawuy idi bayduy sinabin Jesus tungkul sa panawup Bapan Namalyari sa mani alwan Judio, nagsuluk sila. ");
INSERT INTO blx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kabay nidêng silan kaganawan. Impatas la si Jesus sa balayan na palaku sa bung-uy ya pinipaydêngan lan balayan la amên inabu laya dayi sa bêngaw. ");
INSERT INTO blx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nuwa dinuman si Jesus sa pibunakan la buy namita. ");
INSERT INTO blx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ubat ta baydu, naku si Jesus sa balayan Capernaum sa prubinsyan Galilea. Sa Allun Pagpaynawa, nangaral ya sa mani tawu sa balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nakaupapas ya mani tawu sa pangaral na, tagawan dilag kapangyarian ya pagsabi na. ");
INSERT INTO blx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Baydu sa balin pagtipunan mani Judio dilag gisay liyaki ya sinêdakan nadawak ka ispiritu ya masnêg magsabin, ");
INSERT INTO blx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus ya taga Nazaret, sabêt ta daygên mu kanyan? Naku ka nayi baydi amên upudun kay? Tanda yan ka nu sisabêt ka! Sikay Banal la in-utus Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nuwa sinabyanan Jesus ya nadawak ka ispiritu, “Mangimbêk ka buy magtas kana!” Sên anti, intugaw yan nadawak ka ispiritu sa piakit-akit kaganawan buy inlakwanan yan asê nasakitan. ");
INSERT INTO blx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kabay nakaupapas ya mani tawu buy sinabi la sa balang gisa, “Sabêt ta ati? Siyan dilag yan kapangyarian mamipatas nadawak ka ispiritu buy maipatas na sila yata!” ");
INSERT INTO blx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kabay niwagaw wa balita tungkul kan Jesus sa buun lugal abitu. ");
INSERT INTO blx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pamakayari, namita si Jesus sa balin pagtipunan mani Judio ta naku ya sa balin Simon. Matag-ay ya umut ampun Simon ya babayi. Kabay pikisabyan la si Jesus amên paiyulun naya. ");
INSERT INTO blx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kabay nagdani si Jesus sa nagsakit buy impatas nay umut na. Sa uras êt abitu, tambêng nidêng nga babayi buy pinakan na silan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sên pamakatanglêw mamut, gintan mani tawu kan Jesus ya magmikakanayun na nipagsakit. Kabay impaluntu nay gamêt na sa balang gisa, ta pinaiyul na sila. ");
INSERT INTO blx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dilag êt malakêy tawuy sinêdakan nadawak ka ispirituy indani la kan Jesus. Sên pinaawas nay nadawak ka ispiritu, masnêg lan sinabi, “Sika ya Anak Bapan Namalyari!” Nuwa sinabyanan na sila buy a na sila tinulutan magsabi, tagawan tanda lay sabay siyay Cristuy impangakun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sên pamakamaranun, naku si Jesus sa gisay lugal kakyangan. Tingkap yan malakêy tawu. Sên nakit laya, pikisabyan laya, “Manuru, nu malyari, agana ka pun mita sa balayan yan.” ");
INSERT INTO blx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nuwa sinabi na kallay, “Asê malyari, ta kaylangan ku pun iaral sa kaatag lugal la Mangêd da Balita tungkul sa pag-arin Bapan Namalyari, tagawan abiin na sangkan in-utus saku baydi sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kabay insundu nay pangaral na sa mani balin pagtipunan mani Judio sa prubinsyan Judea. ");
INSERT INTO blx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gisay allu, kaban manuru si Jesus sa agid lawan Genesaret, pinagsêksêkan yan malakêy tawu amên mallêngên Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Baydu sa agid lawa, dilag yan nakit ta luway bangka ya ayin nan tawu, gawan nipagtabuy yanay mani mandakêp kênan lanêm ya manguyas pukut la. ");
INSERT INTO blx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kabay nagsakay si Jesus sa bangkan Simon. Buy sinabi na kana, “Idêsêg mun pêrad ya bangka sa lanêm.” Sên naidêsêg gay bangka, niknu si Jesus, ta baydu yan mangaral sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pamakayarin nangaral Jesus, sinabi na kan Simon, “Ilaku yuy bangka yu sa miyalê buy ikatkat yuy mani pukut yu amên makakwa kaw kênan lanêm.” ");
INSERT INTO blx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nakitbay si Simon, “Manuru, napagalan yan nana, pakan ayin kay yatan nakwa. Nuwa gawan sinabi mu, ikatkat kuy mani pukut sa lanêm.” ");
INSERT INTO blx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sên dinyag lay abitu, nayi-nayi yan maginit ya mani pukut la gawan sa malakêy kênan lanêm ma nakwa la. ");
INSERT INTO blx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kabay kinawêy lay mani kaawyun la sa kaatag bangka amên magdani sila buy manawup kalla. Sên nisasawup sila, napapnu lan kênan lanêm ma luway bangka angga sa marani yan milêmlêm. ");
INSERT INTO blx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sên nakitan Simon Pedroy abitu, nanduku ya sa arapan Jesus. Sinabi na, “Panginuun, magpakarayu ka kangku, ta makasalanan naku.” ");
INSERT INTO blx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sinabi nay abiin gawan nakaupapas ya buy mani kaawyun na tagawan malakêy nakwa lay kênan lanêm. ");
INSERT INTO blx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kabay nakaupapas silan Santiago buy si Juan ya mani anak Zebedeo ya kaawyun Simon Pedro. Sinabin Jesus kan Simon Pedro, “Agana kayna malimu, ta paubat amêsên, alwa kaynan mandakêp kênan lanêm nun a mamipakarani kaynan mani tawu ya manampalataya kangku kaparisun pandakêp yun kênan lanêm.” ");
INSERT INTO blx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kabay sên naiagid lay nay bangka la, imbalag lay kaganawan buy nakilaku sila kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Gisay allu, kaban idi si Jesus sa gisay balayan, nagdani kanay gisay liyaki ya nagsakit ketung. Nanduku ya buy nakilunuslunus. Sinabi na, “Panginuun, nu kalabayan mun kayêk, paiyulun muku.” ");
INSERT INTO blx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kabay dinukpan yan Jesus buy sinabi na, “Labay ku. Umiyul kayna.” Kabay tambêng inumiyul la nagsakit. ");
INSERT INTO blx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Intipan Jesus kanay, “Agana mu sabin agyan kansabêt man na nalyari kamu, nun a maku ka sa pari buy ipaêlêw muy lawini mu ya inumiyul lana. Pamakayari, mag-andug ka ayun sa insulat Moises bilang pagpapêtêg ga inumiyul kayna.” ");
INSERT INTO blx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nuwa luyang pun êt niwagaw wa balita tungkul kan Jesus. Kabay inlumatêng pun êt ta malakêy tawu amên mallêngê sa mani aral na buy amên mapaiyul la sakit la. ");
INSERT INTO blx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nuwa si Jesus, pawa yan mamaku sa kakyangan amên manalangin baydu. ");
INSERT INTO blx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gisay allu, kaban manuru si Jesus, idi bayduy dakun umnuy Pariseo buy manurun Kautusan ya nakaiknu sa dani na. Dilag kallay naubat sa balayan Jerusalem buy dilag êt ubat sa kaganawan lugal sa prubinsyan Galilea buy prubinsyan Judea. Idi kan Jesus ya kapangyarian Bapan Namalyari amên mamaiyul sakit. ");
INSERT INTO blx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Amêsên, dilag inlumatêng nga dakun umnuy lawyaki ya manambayuk gisay liyaki ya lumpu. Idani laya dayi kan Jesus, ");
INSERT INTO blx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","nuwa gawan malakêy tawu, a sila midani. Kabay indakêy lay liyaki ya lumpu sa bubungan bali buy inlubtan lay atêp bayu la impakanawan inyêpay liyaki ya lumpu sa arapan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sên nakitan Jesus ya maragul la panampalataya la kana, sinabi na, “Patêl lay, pinatawad day mani kasalanan mu.” ");
INSERT INTO blx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amêsên, mangisip pa mani Pariseo buy mani manurun Kautusan un paradi, “Sisabêt ta tawun ati? Siyan pallamusun naya si Bapan Namalyari ta? Ayin kaatag mamatawad kasalanan, nun a kay si Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nuwa tandan Jesus ya pan-isipin la. Kabay pinatang na sila, “Awta mangisip kaw yan parabaysên ta? ");
INSERT INTO blx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mas nalêp-aw sabin sa liyaki ya lumpuy, ‘Pinatawad danay mani kasalanan mu,’ gawan a yu makit nu pinatawad o asê. Nuwa sabin ku kanay, ‘Midêng ka buy mita ka’ ");
INSERT INTO blx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","amên makitan yuy sikuy ubat sa langit ta in-Anak Tawu, dilag gakun kapangyarian baydi sa babun lutan mamatawad mani kasalanan.” Buy sinabi na sa liyaki ya lumpu, “Midêng ka, gêtan muy kalapayan mu buy muli kayna.” ");
INSERT INTO blx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kabay tambêng nidêng nga liyaki sa arapan kaganawan buy gintan nay kalapayan na. Buy nuli yan mangulimên kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nakaupapas ya kaganawan idi baydu. Kabay inulimên la si Bapan Namalyari. Sinabi la, “Sa allun ati, nakakit kitamun mani mamakaupapas ya diyag.” ");
INSERT INTO blx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pamakayarin abitu, namita si Jesus buy nakitan nay gisay maningil buwis ya naglagyun Levi. Nakaiknu ya sa pamayaran buwis. Sinabin Jesus kana, “Kilaku ka kangku.” ");
INSERT INTO blx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kabay nidêng si Levi, inlakwanan nay kaganawan buy nakilaku ya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nil-an si Levin maragul la kalutu amên maparangalan si Jesus. Malakêy maningil buwis buy kaatag êt ta tawuy nakiawyun nangan kalla. ");
INSERT INTO blx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sên anti, nagdeklamuy mani Pariseo buy mani manurun Kautusan sa mani tagasunul na. Sinabi la, “Uysiyan mangan kaw buy maminêm kaawyun na mani maningil buwis buy kaatag pun mani makasalanan ta?” ");
INSERT INTO blx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pikitbayan silan Jesus, “Asê mangaylangan manuluy ayin sakit, nun a abituy tawuy nagsakit. ");
INSERT INTO blx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Naku waku baydi amên bêgên na mani tawuy makasalanan amên pagsisyan buy lakwanan lay panyag kasalanan, alwan amên bêgên ya abitu silay mani tawuy magsabin ayin silan kasalanan.” ");
INSERT INTO blx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sinabin mani tawu kan Jesus, “Ya mani tagasunul Juan buy mani tagasunul Pariseo, pawa silan mag-ayunu buy manalangin. Uysiyan ya mani tagasunul muy pawa yan mangan buy maminêm ta?” ");
INSERT INTO blx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kabay in-alimbawan Jesus ya sarili na sa liyaki ya pan-itangên, “Malyari nayin mag-ayunuy mani bisita sa tangênan pakan kaawyun la pun na liyaki ya pan-itangên? Asê! ");
INSERT INTO blx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nuwa lumatêng nga alluy kêwên kallay liyaki ya pan-itangên. Sa panawun abiin, baydu sila pun mag-ayunu.” ");
INSERT INTO blx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sinabi êt Jesus kallay paalimbawan ati, “Ayin tawuy mangginit bayuy yaming amên ilanib sa manan yaming. Tagawan nu daygên nay abitu, maginit ta bayuy yaming buy ya inlanib sa bayu, asê naspat sa manan yaming.” ");
INSERT INTO blx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sinabi pun êt Jesus kallay gisay alimbawa, “Ayin êt mamitiis bayuy alak sa manan pamyanan na diyag sa balat. Ta nu daygên nay abitu, matlês ya pamyanan buy mibulug ga alak. Parisu silan masayang! ");
INSERT INTO blx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nuwa ya bayuy alak, sêpat itiis sa bayuy pamyanan. ");
INSERT INTO blx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ayin êt tawuy nakainêm manan alak ka kalabay minêm bayuy alak. Ta sabin nay, ‘Manyaman na manan alak.’ ” ");
INSERT INTO blx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gisay Allun Pagpaynawa, nagdan silan Jesus sa nagtrigu. Nanggutus ya mani tagasunul nan tilalagay trigu buy pinuyu-puyu lay ati sa mani gamêt la bayu la kinnan na mani lasin ati. ");
INSERT INTO blx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nuwa dilag dakun umnuy Pariseo ya nagsabin, “Uysiyan pallabagên yu yay Kautusan tungkul sa Allun Pagpaynawa ta?” ");
INSERT INTO blx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pikitbayan silan Jesus, “A yu pun nayi nabasay dinyag David sabitun inlayang ya buy mani kaawyun na? ");
INSERT INTO blx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sinumun ya sa Tolday Pagsimban, kingwa nay tinapay ya in-andug kan Bapan Namalyari, kinnan na buy pinakan na êt ta mani kaawyun na, agyan idi sa Kautusan ya kay mani pari ya dilag karapatan mangan abitu.” ");
INSERT INTO blx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sinabi pun êt Jesus sa mani Pariseo, “Sikuy ubat sa langit ta in-Anak Tawuy makapagsabi nu sabêt ta mangêd daygên sa Allun Pagpaynawa.” ");
INSERT INTO blx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gisay na êt ta Allun Pagpaynawa, nanguman sinumun si Jesus sa balin pagtipunan mani Judio buy nangaral ya. Dilag gisay liyaki bayduy nati ya gamêt nay wanan. ");
INSERT INTO blx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ya mani manurun Kautusan buy mani Pariseo, pinakaillagan la si Jesus. Ta nu paiyulun nay liyaki sa Allun Pagpaynawa, dilag silan maisangkan laban kana. ");
INSERT INTO blx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nuwa tandan Jesus ya pan-isipin la. Kabay sinabi na sa liyaki, “Midêng ka buy magdani ka baydi sa arapan.” Kabay nidêng nga liyaki buy nagdani kana. ");
INSERT INTO blx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pamakayari, sinabin Jesus sa mani Pariseo buy sa mani manurun Kautusan, “Patangên kataw, ‘Sabêt ta pantulutan Kautusan sa Allun Pagpaynawa? Manyag mangêd o manyag nadawak? Miligtas o mamati?’ ” ");
INSERT INTO blx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kabay pinakaêlêw Jesus ya kaganawan nakapalitêng kana bayu na sinabi sa liyaki, “Ipaktang muy gamêt mu.” Kabay impaktang liyaki ya gamêt na buy inumiyul yabay. ");
INSERT INTO blx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nuwa sên nakitan mani Pariseo buy manurun Kautusan na namaiyul ya sa Allun Pagpaynawa, nanubag sila. Kabay pisasabyan la nu sabêt ta daygên lay nadawak kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sa panawun abitu, naku si Jesus sa bung-uy buy nawat-watan nan nanalangin kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pamakamaranun, binêg nay mani tagasunul na ta namili yan mapu buy luway binêg nan apostul, ");
INSERT INTO blx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","si Simon ya pinalagyunan nan Pedro buy si Andres ya patêl na, si Santiago, si Juan, si Felipe, si Bartolome, ");
INSERT INTO blx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo, si Tomas, si Santiago ya anak Alfeo, si Simon ya manalangsang sa gubernun Roma, ");
INSERT INTO blx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","buy si Judas ya anak kaatag Santiago, buy si Judas Iscariote ya nisupakat kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pamakayari nan namilin apostul na, inlumunsan silan ubat sa bung-uy bayu tinunggên sa gisay napatal la lugal. Idi bayduy malakêy tagasunul na buy idi êt bayduy sadyay lakên tawuy ubat sa kaganawan lugal sa prubinsyan Judea buy sa balayan Jerusalem buy ubat sa mani lugal sa agid dagat sa balayan Tiro buy sa balayan Sidon. ");
INSERT INTO blx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Naku sila baydu amên mallêngê kan Jesus buy paiyulun sila. Kabay pinaiyul nay nipagsakit buy mani sinêdakan nadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kabay pinagpilitan kaganawan na madukpan laya, ta idi kanay kapangyarian Bapan Namalyari ya mamaiyul sa kaganawan nipagsakit. ");
INSERT INTO blx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Inêlêw nay mani tagasunul na buy sinabi na, “Pinagpala kaw wa mani kalulu, tagawan mibilang kaw sa pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pinagpala kaw wa mani layangên amêsên, tagawan mabsuy kaw. Pinagpala kaw wa mani manangis amêsên, tagawan mangkayli kaw. ");
INSERT INTO blx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Pinagpala kaw nu pagsakitan kaw nakêm buy nu ipapawa kaw buy nu dustakên kaw kaganawan tawu gawan sa panunul yu kangku ya in-Anak Tawuy ubat sa langit.” ");
INSERT INTO blx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ta parabaydu êt ta dinyag mani ninunu la sa mani propeta awlagi. Kabay nu mangadanasan yuy abiin, matula kaw buy mag-ukdu kaw gawan sa tula, tagawan maulagay gantimpala yu sa langit. ");
INSERT INTO blx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Sikaw wa mani mabandi, mamakapalunus kaw lanu, ta natanggap yina amêsên na katigsawan yu. ");
INSERT INTO blx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sikaw wa nangabsuy amêsên, mamakapalunus kaw lanu, ta lumayang kaw. Sikaw wa mani mangkayli amêsên, mamakapalunus kaw lanu, ta magluksa kaw buy mipanangis. ");
INSERT INTO blx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Sikaw wa mani pan-ulimênên kaganawan tawu amêsên, mamakapalunus kaw êt lanu, gawan para bayduy dinyag mani ninunu la sa mani magtatalingkayun propeta.” ");
INSERT INTO blx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Amêsên, sinabin Jesus, “Nuwa pansabin ku kamuyun mani mallêngê kangku, kaidwan yuy mani kapati yu buy manyag kaw mangêd sa mani nipagsakit nakêm kamuyu. ");
INSERT INTO blx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Manalangin kaw para sa mani mandustak kamuyu ya pagpalên silan Bapan Namalyari buy manalangin kaw para sa mani mamasakit kamuyu. ");
INSERT INTO blx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nu dilag mandalpin pingi mu, ipadalpi mu êt ta kapaka. Nu dilag mangwan up-up mu, agana mu êt iimut ya yaming mu. ");
INSERT INTO blx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nu dilag manyawad kamu, biyan muya. Buy nu dilag mangwan pibandiyan mu, agana mina udungun. ");
INSERT INTO blx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Daygên yu sa mani kaparisu yuy labay yun daygên la kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nu kay ya mani mangidu kamuyuy pan-idun yu, ayin kaw matanggap pa gantimpalay ubat kan Bapan Namalyari. Tagawan agyan ya mani makasalanan na tawu, pan-idun la êt ta mangidu kalla. ");
INSERT INTO blx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Buy nu kay panyagên yun mangêd da tawuy manyag mangêd kamuyu, a kaw ulimênên Bapan Namalyari. Tagawan agyan ya mani makasalanan, para êt bayduy pandaygên la. ");
INSERT INTO blx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nu kay pamaraman yuy mamakabayad kamuyu, a kaw ulimênên Bapan Namalyari. Tagawan agyan ya mani makasalanan, mamaandam sila êt sa kaparisu lan makasalanan, ta natanêk ya nakêm lan iudung lay abitu! ");
INSERT INTO blx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Alwan parabayduy daygên yu, nun a kaidwan yuy mani kapati yu, manyag kaw mangêd kalla, buy paandamên yu silan a kaw mangêtêng kapalit. Nu parabayduy daygên yu, maragul la gantimpala yu buy mapagpapêtgan ya anak kaw Bapan Namalyari ya Katatag-ayan. Tagawan mangêd ya agyan sa mani tawuy ayin utang nga nakêm buy sa mani nadawak ka tawu. ");
INSERT INTO blx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Magin mapallunus kaw kaparisun Bapa yun Namalyari ya mapallunus.” ");
INSERT INTO blx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Agana kaw mangusgan kaparisu yu amên a kaw êt usgên Bapan Namalyari. Agana kaw êt mangatul kaparisu yu amên a kaw êt atulan Bapan Namalyari. Mamatawad kaw amên patawarên kaw Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mam-i kaw sa kaatag amên biyan kaw êt Bapan Namalyari. Ta ya idin yu, iudung na un ustuy takal, intêtê, imbinsêk anggan masalipaw. Gawan nu sabêt ta panukad da panggamitin yun pam-i sa kaatag, sabay êt ta panukad da gamitin Bapan Namalyari kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sinabi êt Jesus ya paalimbawan ati, “Malyari nayin mangakay ya bulag sa kaparisu nan bulag? Asê! Ta parisu silan manabu sa kali nu daygên lay abitu. ");
INSERT INTO blx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ayin mag-aral la igit pun sa manuru kana. Nuwa nu napakaturwanan yan mangêd, magin kaparisu yan manuru kana.” ");
INSERT INTO blx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Uysiyan makitan mu yay puling sa matan kaparisu mu, pakan a mu makitan na maragul la puling sa mata mu ta? ");
INSERT INTO blx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Parasaantu mun masabi kanay, ‘Patêl lay, paulayên mun itas kuy puling sa mata mu’, pakan a mina man makit ta maragul la puling sa mata mu? Mapagtalingkayu! Itas mu pun na maragul la puling sa mata mu amên makakit kan mangêd. Sa pakapakun baydu, maitas muy puling sa matan kaparisu mu.” ");
INSERT INTO blx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sinabi pun êt Jesus, “Ya mangêd da puun kayu, asê managêy asê pangkanên buy ya puun kayuy asê mangêd, asê managêy pangkanên. ");
INSERT INTO blx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Balang puun kayu, matandan sa mani tagêy na. Tagawan na tanaman na madiwi, asê managêy igus o ubas. ");
INSERT INTO blx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Para êt baydu sa tawu. Ya tawuy mangêd da ugali, magsabi yan pawan kangêdan, tagawan napnun kangêdan na bêkê na. Nuwa ya tawuy nadawak ka ugali, magsabi yan pawan kadawakan, tagawan napnun kadawakan na bêkê na. Tagawan nu sabêt ta idi sa bêkên gisay tawu, sabay ya sabin na.” ");
INSERT INTO blx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sinabi pun êt Jesus, “Uysiyan pambêgên yuku yan, ‘Panginuun, Panginuun’, pakan a yu pansunulun ya mani pansabin ku? ");
INSERT INTO blx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Paradi ya magdani kangkun mallêngê buy manunul sa mani sabi ku. Kaparisu yan ");
INSERT INTO blx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","gisay tawuy nangalin malalê buy impaydêng nay bali na sa pundasyun na batu. Sên inlumatêng nga lanab, asê nalasak ka bali na, ta napas-êy ya pinipundasyunan na. ");
INSERT INTO blx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nuwa ya tawuy mallêngê sa pansabin ku, pakan a nay naman pansunulun, kaparisu yan tawuy nanyag bali ya ayin pundasyun. Sên inlumatêng nga lanab, tambêng nayêgmak buy nalasak ka bali na.” ");
INSERT INTO blx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sên nayari yan tinurwanan Jesus ya mani tawu, naku ya sa balayan Capernaum. ");
INSERT INTO blx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Idi bayduy gisay kapitan mani sundalus Romano. Dilag yan ipus ya kakaidwan na ya nagsakit buy marani yan mati. ");
INSERT INTO blx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sên nabalitan kapitan ya tungkul kan Jesus, in-utus nay mani mangatwan Judioy manungkulan amên pakisabyan laya si Jesus ya lakwên naya sa bali na buy paiyulun nay ipus na. ");
INSERT INTO blx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sên nilatêng silayna kan Jesus, pikisabyan layan mangêd, “Nu malyari dayi, sawpan muy kapitan gawan sêpat yan sawpan. ");
INSERT INTO blx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ta kaidwan na kitamuy mani layin Judio buy siyay nipadyag balin pagtipunan tamu.” ");
INSERT INTO blx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kabay nakilaku kalla si Jesus. Sên marani silayna sa balin kapitan mani sundalus, in-utus êt kapitan na dakun umnuy kaluguran na amên têgmên si Jesus buy ipasabi kanay, “Panginuun, agyan a kayna kanu maku sa bali na ta a ya sêpat lakwên. ");
INSERT INTO blx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kabay a yina nagdani, ta a ya sêpat makiarap kamu. Nuwa nu sabin mu kanuy umiyul la ipus na, umiyul yabay. ");
INSERT INTO blx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tanda nay ati, gawan siya man, dilag mani nipagtungkulan na makapangyarian pun êt kana. Buy dilag ya êt pansakupun na mani sundalus. Nu sabin na sa gisay, ‘Maku ya baydu’, maku yabay baydu. Nu sabin nay, ‘Kaksaw ka baydi’, magdani ya. Buy nu sabêt ta iutus na sa ipus na, daygên na.” ");
INSERT INTO blx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sên nalêngên Jesus ya impasabin kapitan sundalus, nakaupapas ya buy nag-arap ya sa mani tawuy kilalaku kana. Sinabi na, “Agyan sa mani Israelitay ayin naku pun nakitan na tawuy paradi ya karagul la panampalataya.” ");
INSERT INTO blx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sên nag-udung sa bali ya mani in-utus kapitan, nakitan laya bay ya inumiyul lay ipus na. ");
INSERT INTO blx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pamakayari, naku si Jesus sa balayan ya naglagyun Nain. Nakilaku kanay mani tagasunul na buy ya malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sên marani silayna sa susunan balayan Nain, nakatbêng silan malakêy tawuy mamilbêng nati. Ta nati ya gigisay liyaki ya anak bal-uy babayi. Malakêy taga balayan ya nakilbêng nga kaawyun na. ");
INSERT INTO blx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sên nakitan Panginuun Jesus ya bal-u, nalunus ya. Kabay sinabi na, “Patêl la, agana ka manangis.” ");
INSERT INTO blx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nagdani ya buy dinukpan nay kakalêkan nati ya gêgtan mamilbêng. Kabay tinunggên sila buy sinabin Jesus sa liyaki ya nati, “Ali kuway, mimata kayna.” ");
INSERT INTO blx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Niknuy nati, êh nakasabi yina. Tinambay yan indin Jesus sa indu na. Sinabi na, “Ati ya anak mu.” ");
INSERT INTO blx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kabay sa limu la sa nalyari, kinêdêsan na kaganawan tawu buy nangulimên sila kan Bapan Namalyari. Sinabi la, “Ha, pata taganan pansawpan kitamun Bapan Namalyari! Ta inlumtaw kantamuy makapangyarian na propeta na.” ");
INSERT INTO blx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ya tungkul sa dinyag Jesus, niwagaw sa buun prubinsyan Judea buy sa mani lugal la nakapalitêng. ");
INSERT INTO blx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Amêsên, ya mani tagasunul Juan ya Mamawtismu, inlaku laya si Juan sa sukulan buy sinabi la kanay kaganawan dinyag Jesus. Sên natandan Juan na abitu, in-utus nay luwa sa mani tagasunul na kan Jesus amên ipatang kanay paradi, “Sika nayi ya pan-êtêngên yan na lumatêng o mangêtêng kay pun kaatag?” ");
INSERT INTO blx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sên nilatêng silay nabay kan Jesus, sinabi la, “In-utus kay Juan ya Mamawtismu amên ipatang yan kamu nu sika nayi ya pan-êtêngên yan lumatêng o mangêtêng kay pun kaatag.” ");
INSERT INTO blx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sa mani uras abitu, malakêy pinaiyul Jesus ya nipagsakit buy mani bulag. Malakê êt ta sinêdakan nadawak ka ispirituy impatas na sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kabay sinabin Jesus sa mani tagasunul Juan, “Mag-udung kaw kan Juan buy ibalita yu kanay nakit buy nalêngê yu amêsên. Nakakit tanay mani bulag. Nakabitay mani lumpu. Inumiyul la mani nagketung. Nakalêngêy mani asê kalêngê. Pampabyayên na mani nati. Buy pan-iaral sa mani kaluluy Mangêd da Balita. ");
INSERT INTO blx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pinagpalay tawuy asê magluway nakêm kangku.” ");
INSERT INTO blx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pamakabitan mani tagasunul Juan, pinatang Jesus ya mani tawu, “Sabitun naku kaw sa kakyangan, sabêt ta napilmi yun makit? Gisay timbu nayi ya pangkimpayên angin? Asê! ");
INSERT INTO blx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Gisay tawu nayi ya nakayaming mangêd? Asê, ta ya mani tawuy nakayaming mangêd buy mambumyay sa mangêd da kabilyan, kay makitan sa balin ari. ");
INSERT INTO blx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Naku kaw êt nayi sa kakyangan amên makit ya gisay propeta? Awu. Pêtêg gisa yabay propeta si Juan. Nuwa pansabin ku kamuyuy igit yapun sa gisay propeta. ");
INSERT INTO blx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta sabay si Juan na pantukuyun Bapan Namalyari sabitun sinabi na sa Kasulatan, ‘Dilag gakun gisay iutus ya muna kamu amên mil-an danan mu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sinabi pun êt Jesus, “Pansabin ku kamuyuy ayin tawuy in-anak ya igit pun kan Juan. Nuwa nu sisabêt man na pinakanayêpa sa mani tawuy pag-arian Bapan Namalyari, igit yapun kan Juan.” ");
INSERT INTO blx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sên nalêngên mani tawu buy maningil buwis ya pangaral Jesus, sinabi la, “Ustuy pan-ipadyag Bapan Namalyari.” Sinabi lay abiin gawan nagpabawtismu sila kan Juan. ");
INSERT INTO blx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nuwa ya mani Pariseo buy mani manurun Kautusan, a sila nagpabawtismu kan Juan. Kabay a la tinanggap ya pan-ipadyag Bapan Namalyari sa biyay la. ");
INSERT INTO blx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sinabi pun êt Jesus, “Sa sabêt ku maiparisuy mani tawu sa panawun amêsên? Kansabêt ku sila maiparisu? ");
INSERT INTO blx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Maiparisu ku sila sa mani anak ka nakaiknu sa pangapalan. Pansabin lan masnêg sa mani kakapal la, ‘Tinigtigan yan kaw bulugudyung, nuwa a kaw nanalêk. Nagkanta kay pagkanta sa nati, nuwa siyan a kaw nanangis.’ ” ");
INSERT INTO blx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Para kaw êt baydu tagawan sên inlumatêng baydi si Juan ya mag-ayunu buy asê maminêm alak, siyan pansabin yuy, ‘Pansêdakan nadawak ka ispirituy tawun abiin.’ ");
INSERT INTO blx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Buy sikuy ubat sa langit ta in-Anak Tawu, sên inlumatêng ngaku baydi, nakitan yukun mangan buy maminêm alak, siyan pansabin yuy, ‘Elêwên yumbay ya tawun abiin! Masing-ul buy mapaglasing ya, kaluguran yan mani maningil buwis buy mani mapanyag kasalanan.’ ");
INSERT INTO blx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nuwa paraman baydu, mapagpapêtgan na pêtêg ga kabiyasnan Bapan Namalyari sa mani tawuy manunul sa pan-ituru yan.” ");
INSERT INTO blx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Amêsên, dilag gisay Pariseoy naglagyun Simon. Insagyat na si Jesus un mangan sa bali na. Kabay sinumun si Jesus un mangan. ");
INSERT INTO blx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sa balayan abitu, dilag gisay babayi ya pikatandan ya asê mangêd da pangababayi. Sên natandan nay mangan si Jesus sa balin Simon, naku ya baydun gêgtan na makamal la pabangi ya idi sa mangêd da pamyanan ya diyag sa batun alabastru. ");
INSERT INTO blx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Amêsên, sên idi ya bayduy babayi, nagdani ya sa kabukutan Jesus sa danin bitis na. Nanangis ya baydu angga sa napitakan luwa nay bitis Jesus. Kabay pinunis nan sabut nay ati, dinêp nay bitis buy pakanawa nan binulugan pabangi. ");
INSERT INTO blx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Si Simon na nanagyat kan Jesus, sên nakitan nay dinyag babayi, nasabi na sa sarili na, “Nu pêtêg propetay tawun ati, tanda na dayi ya asê mangêd da pangababayin nakadukpa kana.” ");
INSERT INTO blx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nuwa tandan Jesus ya inisip Simon. Kabay sinabin Jesus kana, “Dilag gakun labay sabin kamuy Simon.” Nakitbay si Simon, “Sabêt ta abituy Manuru?” ");
INSERT INTO blx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sinabin Jesus kana, “Dilag luway tawuy nangutang pera sa gisay tawuy mamautang. Liman dalan ya inutang gisa. Ya gisa, limampu. ");
INSERT INTO blx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sên a sila makabayad, a nayna impabayad da utang la. Amêsên, sa êlêw mu, sisabêt sa luway mas mangidu baydu sa namautang kalla?” ");
INSERT INTO blx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nakitbay si Simon, “Sa pangêlêw ku, abituy mas malakêy utang.” Kabay sinabin Jesus, “Ustuy pakitbay mu.” ");
INSERT INTO blx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pamakayari, inawing Jesus ya babayi buy sinabi na kan Simon, “Elêwên muy babayin ati. Sên sinumun naku nangun sa bali mu, a muku binyanan lanêm panguyas kun bitis ku. Nuwa ya babayin ati, inuyasan nan luwa nay bitis ku buy pinunisan nan sabut nay bitis ku. ");
INSERT INTO blx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A muku êt dinêp bilang pananggap mu kangku, nuwa siya, ubat sa sinumun ya baydi, a ya tinunggên mandêp sa bitis ku. ");
INSERT INTO blx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A mu binulugan laruy ulu ku, nuwa siya, binulugan nan makamal la pabangi ya bitis ku. ");
INSERT INTO blx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kabay pansabin ku kamuyuy ya maragul la pangiduy impakit na kangku, sabay ya pagpapêtêg pinatawad day mani kasalanan na. Nuwa ya tawuy pinatawad pêrad, pêrad êt ta impakit nay pangidu.” ");
INSERT INTO blx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Amêsên, sinabin Jesus sa babayi, “Pinatawad day mani kasalanan mu.” ");
INSERT INTO blx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ya mani kaêm nan mangan, namatang sila sa sarili la, “Sisabêt ta tawun ati, ta agyan kasalanan mapatawad na?” ");
INSERT INTO blx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sinabin Jesus sa babayi, “Niligtas kayna sa parusa, gawan sa panampalataya mu kangku. Muli kaynan napatêtbêk ka nakêm.” ");
INSERT INTO blx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pamakayari, inlakun Jesus ya mani balayan buy mani baryu sa Galilea, ta mangaral yan Mangêd da Balita tungkul sa pag-arin Bapan Namalyari. Kaawyun nay mani mapu buy luway tagasunul na ");
INSERT INTO blx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","buy dakun umnuy babayi ya pinaiyul na buy babayi ya tinasan na êt nadawak ka ispiritu. Gisa kalla si Mariay pambêgên lan Magdala ya tinasan Jesus un pituy nadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Dilag êt kaawyun si Juana ya asawan Cusa ya pagtiwalan Gobernador Herodes Antipas, si Susana buy malakê pun êt ta kaatag. Ya mani babayin abiin, manawup sila sa mani kaylangan lan Jesus ubat sa mani sarili lan pibandiyan. ");
INSERT INTO blx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kaban mititipun na malakêy tawuy ubat sa magmikakanayun na balayan, ingkuwentun Jesus ya paalimbawan ati, ");
INSERT INTO blx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Dilag gisay manggitnay namibulaglag bini. Sa pamibulaglag na, dilag mani bini ya nangananabu sa dan. Nangatudakan na ati buy tinuktuk mani uybun manuk. ");
INSERT INTO blx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dilag êt mani bini ya nangananabu sa mabatuy lugal. Tinumubuy mani ati, nuwa tambêng nawangêy, gawan namalay luta. ");
INSERT INTO blx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dilag êt mani bini ya nangananabu sa pantubwanan têmak ka madiwi. Niagnan inlumabung nga mani bini buy mani têmak, nuwa kinêlkêlan têmak ka madiwi ya mani bini. ");
INSERT INTO blx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ya kaatag, nangananabu sa mangêd da luta. Kabay tinumubu buy nanagêy ya mani bini un tidinalan na lasi.” Pamakayari, masnêg sinabin Jesus, “Sikaw wa mani mallêngê, pakaisipin yuy nalêngê yu.” ");
INSERT INTO blx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Namatang nga mani tagasunul Jesus, “Sabêt ta labay mun sabin sa paalimbawan abiin?” ");
INSERT INTO blx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kabay pikitbayan silan Jesus, “Impaintindi kamuyuy nakaliim tungkul sa pag-arin Bapan Namalyari, nuwa sa kaatag, pan-isabi ya ati sa kapamilatan paalimbawa amên, ‘Kapangêlêw-êlêw laman, a sila makakit. Buy kapallêngê-lêngê laman, a sila makapukat.’ ” ");
INSERT INTO blx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Impatandan Jesus nu sabêt ta labay sabin abituy paalimbawa. Sinabi na, “Ya bini, sabay ya Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ya dan na kinapinabwan bini, sabay ya mani tawuy nallêngê sa Sabin Bapan Namalyari. Nuwa sên inlumatêng si Satanas, intas nay Sabin Bapan Namalyari sa bêkê la amên a sila manampalataya buy a sila miligtas sa parusa. ");
INSERT INTO blx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ya mabatuy lutay kinapinabwan bini, sabay ya mani tawuy nallêngê sa Sabin Bapan Namalyari buy matula lan tinanggap pa ati. Nuwa asê nipakatêbêk sa bêkê lay pananggap la. Kabay asê napêng nga panampalataya la, ta sên inlumatêng nga mani panubuk, inlakwanan lay nay panampalataya la. ");
INSERT INTO blx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ya lutay pantubwanan têmak ka madiwi nu saantu nanabuy kaatag bini, sabay ya nallêngên Sabin Bapan Namalyari. Nuwa sên kabuyutan, gawan sa mani pangganakên sa biyay la, pibandiyan buy panunul sa kalabayan lawini la, nalitêpan lay Sabin Bapan Namalyari. Kabay asê nanagêy sa biyay la. ");
INSERT INTO blx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nuwa ya mangêd da lutay kinapinabwan bini, sabay ya mani tawuy nallêngên Sabin Bapan Namalyari ya dilag mangêd da nakêm. Impakatêbêk lay ati sa bêkê la buy pinibabatan lan sinunul angga sa nanagêy sa biyay la.” ");
INSERT INTO blx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sinabi pun êt Jesus, “Ayin tawuy mamagkêt sulu ya takpan nan timba o idin sa aypan papag, nun a idin nay sulu sa pêtêg pamyanan amên mam-in sawang sa kaganawan sumun sa bali. ");
INSERT INTO blx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ta ayin pan-itaguy asê miwagaw buy ayin pan-iliim ma asê matandan.” ");
INSERT INTO blx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kabay mallêngê kaw mangêd sa pansabin ku. Ta ya tawuy manunul sa malêngê nay kapêtêgan, biyan yapun êt pangintindi. Nuwa ya tawuy asê manunul sa malêngê nay kapêtêgan, agyan na indap nay idi kana, itas pun êt kana.” ");
INSERT INTO blx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Amêsên, naku kan Jesus ya indu na buy mapatêl na. Nuwa a sila midani, gawan malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kabay dilag nagsabi kan Jesus, “Idi sa lawasan ya indu mu buy mapatêl mu. Labay lakan makitan.” ");
INSERT INTO blx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nuwa pikitbayan yan Jesus, “Ya mani mallêngê buy manunul sa Sabin Bapan Namalyari, sabay silay indu ku buy mapatêl ku.” ");
INSERT INTO blx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gisay allu, nagsakay si Jesus buy mani tagasunul na sa gisay bangka. Sinabi na kallay, “Maglipay kitamina sa lawa.” Kabay naglipay silayna. ");
INSERT INTO blx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sên idi ya sa lanêm ya bangka, nabêlêwan Jesus. Asê naêpêng, inlumakas ya angin buy nasunan malakêy lanêm ya bangka la. Kabay idi sila sa nadawak ka kabilyan. ");
INSERT INTO blx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kabay pinêw yan mani tagasunul na, “Manuru, Manuru, mimata ka! Milêmlêm kitamina!” Kabay nimata si Jesus, in-utus nay malakas ya angin buy maragul la alun, “Tunggên kaw!” Kabay tinunggên na angin buy namatêtbêk ka alun. ");
INSERT INTO blx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pinatang Jesus ya mani tagasunul na, “Antuy panampalataya yu?” Nakaupapas sila buy nalimu. Kabay nisasabi sila, “Sisabêt ta ati! Siyan mapatgên na yay angin buy alun ta!” ");
INSERT INTO blx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Amêsên, insundu lay paglipay la angga sa nilatêng sila sa lugal mani tawuy pambêgên lan Geraseno ya katalipay lawan Galilea. ");
INSERT INTO blx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kabay pamakalatêng la, nagtabuy si Jesus sa bangka. Timbêng yan gisay liyaki ya manugêl baydu ya sinêdakan nadawak ka ispiritu. Nabuyut tinan asê magyaming buy a ya manugêl sa bali, nun a sa lêyang nga pamilbêngan. ");
INSERT INTO blx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Agyan papakabantayan laya buy papakasêl-an tanikalay gamêt na buy bitis na, mabuytu na pun êt. Pawa yan pansêdakan nadawak ka ispiritu buy pan-ipalaku ya sa kakyangan na lugal. Sên nakitan liyaki si Jesus, nan-angaw ya buy nanduku ya sa arapan na. Kabay sinabin Jesus kana, “Nadawak ka ispiritu, magtas ka kana!” Kabay masnêg nan sinabi, “Jesus ya Anak Bapan Namalyari ya Katatag-ayan, sabêt ta daygên mu kangku? Makisabi yaku kamu, agana muku pasakitan.” ");
INSERT INTO blx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kabay pinatang yan Jesus, “Sabêt ta lagyu mu?” Nakitbay ya, “Libulibu.” Sinabi nay abitu gawan malakêy nadawak ka ispirituy nagsêdak kana. ");
INSERT INTO blx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nakilunuslunus ya nadawak ka ispiritu kan Jesus, “Agana mukay ipalaku sa kalalêlalêan sukulan sa aypan luta.” ");
INSERT INTO blx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dilag malakêy babuy ya manabêl baydu sa bung-uy. Nakilunuslunus ya nangadadawak ka ispiritu kan Jesus, “Tulutan mukay magsêdak sa mani babuy.” Kabay sinabin Jesus kalla, “Dali kawna!” ");
INSERT INTO blx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kabay nagtas ya mani nadawak ka ispiritu sa liyaki buy nagsêdak sa mani babuy. Nipamwayuy mani babuy buy nanabu sa bêngaw. Kabay nangalulumud sila sa lawa. ");
INSERT INTO blx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sên nakit manaysay babuy ya abitu, nuwayu silan napapakun sa balayan buy sa karanin baryu buy imbalita lay nalyari. ");
INSERT INTO blx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kabay naku bayduy mani tawu amên êlêwên lay nalyari. Pamakalatêng la kan Jesus, nakitan lay liyaki ya tinasan nan nadawak ka ispiritu ya nakayaming ngina buy nakaiknuy na sa kabitisan Jesus buy mamangêd day isip na. Kabay nalimwan ya mani tawu sa mani nalyari. ");
INSERT INTO blx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ya mani nakakit sa dinyag Jesus, ingkuwentu lay nalyari sa mani inlumatêng, “Impatas Jesus ya nadawak ka ispiritu ya nagsêdak sa liyaki.” ");
INSERT INTO blx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ya mani taga baydu sa Geraseno, nakisabi sila kan Jesus, “Magtas kayna sa lugal yan, ta lilimun kay kamu!” Kabay nagsakay ya silan Jesus sa bangka ta maglipay sila papakun sa lugal la ubatan la. ");
INSERT INTO blx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nakisabi kan Jesus ya liyaki ya tinasan nan nadawak ka ispiritu, “Kilaku waku dayi kamu.” Nuwa alwan parabayduy labay Jesus. Kabay sinabi na, ");
INSERT INTO blx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Muli kayna amên ipatanda mu kallay dinyag Bapan Namalyari kamu.” Kabay nuli ya liyaki buy imbalita na sa buun balayan na dinyag Jesus kana. ");
INSERT INTO blx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Amêsên, sên nag-udung si Jesus sa lipay lawa, matula yan tinanggap mani tawu gawan mangêtpan kanay kaganawan. ");
INSERT INTO blx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Inlumatêng nga gisay liyaki ya naglagyun Jairo ya gisay mamunu sa balin pagtipunan mani Judio. Nanduku ya sa arapan Jesus buy nakisabi ya, “Nu malyari dayin kayêk, maku ka dayi sa bali ku, ");
INSERT INTO blx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","gawan marani yan mati ya gigisay anak kuy babayi ya mapu buy luway nay tawun.” Kaban papakun si Jesus sa balin Jairo, nipipiitan na mani tawu kana. ");
INSERT INTO blx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dilag gisay babayi bayduy mapu buy luway tawun nan dayên. Naubus say kaganawan pibandiyan na sa pamayad sa pagpaêlêw na sa mani manulu. Nuwa ayin makapaiyul kana, agyan sisabêt. ");
INSERT INTO blx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Naku yan nagdani sa bukut Jesus buy dinukpan nay palpal yaming na. Kabay tambêng tinunggên na pagdaya na. ");
INSERT INTO blx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Namatang si Jesus, “Sisabêt ta nandukpa kangkun ah?” Sinabin balang gisa, “Alwan siku.” Kabay sinabin Pedro, “Manuru, tanda muy malakêy tawuy nakapalitêng nga nipipiitan amên midani kamu.” ");
INSERT INTO blx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nuwa sinabin Jesus, “Dilag nandukpa kangku, ta natanam kuy dilag kapangyarian na nag-awas kangku.” ");
INSERT INTO blx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sên natandan babayi ya a na maipuglaw wa dinyag na, pumilapil yan nagdani kan Jesus. Nanduku ya sa arapan buy sinabi na sa kaganawan nu sabêt ta sangkan uysiyan dinukpan nay yaming Jesus buy nu parasaantu yan inumiyul. ");
INSERT INTO blx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kabay sinabin Jesus kana, “Anak kuway, inumiyul ka gawan sa panampalataya mu kangku. Muli kaynan napatêtbêk ka nakêm.” ");
INSERT INTO blx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kaban kasabi pun Jesus ya babayi, inlumatêng nga gisay liyaki ya ubat sa balin Jairo. Sinabi na kan Jairo, “Nati yanay anak mu. Agana mina abalên na Manuru.” ");
INSERT INTO blx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nuwa sên nalêngên Jesus ya abiin, sinabi na kan Jairo, “Agana ka malimu. Kay manampalataya ka kangku buy mabyay yan manguman.” ");
INSERT INTO blx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pamakalatêng la sa bali, ayin pinasun si Jesus nun a kay silan Pedro, Santiago, buy si Juan buy mangatwan anak. ");
INSERT INTO blx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Manangis buy man-alab ya mani tawuy idi baydu. Nuwa sinabin Jesus kalla, “Agana yu tangisan na anak, gawan a ya nati, nun a kay mamabêlêw ya.” ");
INSERT INTO blx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Inuyam laya, ta tanda lay pêtêg nati ya anak. ");
INSERT INTO blx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nuwa tinalan Jesus ya gamêt anak buy sinabi na kana, “Anak kuway, mimata ka.” ");
INSERT INTO blx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nabyay ya anak buy tambêng yan niknu. Kabay sinabin Jesus kalla, “Pakan yuya.” ");
INSERT INTO blx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nakaupapas ya mangatwa na, nuwa masipit intipan Jesus kallay a la sabin agyan kansabêt man na nalyari. ");
INSERT INTO blx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Binêg Jesus ya mapu buy luway tagasunul na. Buy binyanan na silan kapangyarian buy karapatan makapitas kaganawan nangadawak ka ispiritu buy mamaiyul nipagsakit. ");
INSERT INTO blx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","In-utus na sila amên mangaral tungkul sa pag-arin Bapan Namalyari buy mamaiyul mani tawuy nipagsakit. ");
INSERT INTO blx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Sinabi na kalla, “Sa pamita yu, agana kaw mantan dakun sabêt, agyan têkên, susut, kanên, pera o yaming nga pangalili. ");
INSERT INTO blx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Makitugêl kaw agyan sa sisabêt man na mananggap kamuyu buy manugêl kaw baydu angga sa pamita yu sa balayan abitu. ");
INSERT INTO blx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Buy nu a kaw tanggapên mani tawu sa gisay balayan, mita kaw baydu. Nuwa bayu kaw mita, ikampag yuy abuy idi sa bitis yu bilang pamipatanda kalla ya nadawak ka dinyag la.” ");
INSERT INTO blx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kabay ya mani tagasunul na, namitay nan naku sa mani baryu. Nangaral silan Mangêd da Balitan Bapan Namalyari buy namaiyul silan nipagsakit agyan saantu man na lugal. ");
INSERT INTO blx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sên nabalitan Gobernador Herodes Antipas ya kaganawan pandaygên Jesus, naguluy nakêm na, ta dilag magsabin, “Nanguman nabyay si Juan ya Mamawtismu.” ");
INSERT INTO blx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dilag dakun umnuy nagsabin, “Sabay siya si propeta Elias ya nanguman nagpakit.” Dilag êt taman nagsabin, “Gisa ya sa mani propeta sabitun nuna ya nanguman nabyay.” ");
INSERT INTO blx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nuwa sinabin Gobernador Herodes Antipas, “Alwan siya si Juan, ta impaputus kinay ulu na. Nuwa sisabêt taman na imbalita la kangku?” Kabay pinagpilitan nan makitan si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Amêsên, sên nag-udung nga mani apostul kan Jesus, ingkuwentu lay kaganawan dinyag la. Sên anti, pikilaku na sila un kakapad la sa gisay balayan na pambêgên Bethsaida. ");
INSERT INTO blx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nuwa sên natandan malakêy tawuy pamita la, nangamat sila kan Jesus. Sên nakitan silan Jesus, dinambi na sila. Kabay nangaral ya kalla tungkul sa pag-arin Bapan Namalyari buy pinaiyul nay mani tawuy nipagsakit. ");
INSERT INTO blx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sên nitanglêw way mamut, nagdani kan Jesus ya mapu buy luway tagasunul na buy sinabi la kana, “Manuru, idi kitamu sa kakyangan na lugal. Kabay ipalaku minay mani tawu sa nangarani ya baryu buy sa panggitnan amên makatkap silan maêkan buy kabêlêwan la.” ");
INSERT INTO blx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nuwa sinabin Jesus kalla, “Asê, sikaw wa mam-in maêkan kalla.” Kabay nakitbay sila, “Manuru, kay dilag kitamun lilimay tinapay buy luluway kênan lanêm. Ya labay mun sabin ni maku kay pun êt nayin manaliw maêkan la?” ");
INSERT INTO blx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ya bilang mani lawyaki, limay libu. Nuwa sinabin Jesus sa mani tagasunul na, “Paiknun yu silan tilimampu sa gisay grupu.” ");
INSERT INTO blx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kabay pinaiknu lay kaganawan. ");
INSERT INTO blx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sên anti, kingwan Jesus ya limay tinapay buy luway kênan lanêm. Pamakayari, nangêlêw ya sa langit buy nagpasalamat ya kan Bapan Namalyari. Binis-ilbis-il nay tinapay buy pinutus-putus nay kênan lanêm buy indin na sa mani tagasunul na. Indin êt mani tagasunul na sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nakaêkan na kaganawan tawu buy nabsuy. Sên tinipun lay tagan na tinapay buy kênan lanêm, napakapnu la pun êt ta mapu buy luway salikap. ");
INSERT INTO blx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gisay allu, kaban manalangin si Jesus un kakapad na, nagdani kanay mani tagasunul na. Kabay pinatang na sila, “Sisabêt taku kanu sabin mani tawu?” ");
INSERT INTO blx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nakitbay sila, “Dilag magsabin sika si Juan ya Mamawtismu. Dilag êt taman magsabin sika si propeta Elias. Buy ya kaatag, magsabin gisa ka sa mani propeta sabitun nunan panawun ya kay nanguman nabyay.” ");
INSERT INTO blx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kabay pinatang silan Jesus, “Nuwa kamuyu, sisabêt taku?” Nakitbay si Pedro, “Sabay sika ya Cristuy impangakun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kabay impapakatipan Jesus sa mani tagasunul nay, “Agana yu sabin agyan kansabêt man.” ");
INSERT INTO blx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sinabi na pun êt, “Sikuy ubat sa langit ta in-Anak Tawu, kaylangan kun madanasan na malakêy pamasakit. Isakwil lakun mangatway manungkulan buy mani mamunun pari buy mani manurun Kautusan. Ipapati laku, nuwa sa ikatluy allu, manguman nakun mabyay.” ");
INSERT INTO blx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pamakayari, sinabi na sa kaganawan, “Sisabêt man na kalabay manunul kangku, sêpat nan liwanên na sarili nan kalabayan buy sa inallu-allu nakal-an yan mati gawan sa panunul na kangku kaparisu yan mamakay kurus buy manunul ya kangku. ");
INSERT INTO blx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tagawan sisabêt man na tawuy maglabay miligtas ya biyay na, sabay ya matasan biyay na. Nuwa ya tawuy nakal-an mam-in biyay na para kangku, sabay ya mabiyan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Agyan makwan gisay tawuy kaganawan pibandiyan baydi sa babun luta, nu milakuy naman sa ayin katganan na kaparusan, a nayna mapagnabang. ");
INSERT INTO blx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nu ikadêng-êy yuku buy ya pan-iaral ku, sikuy in-Anak Tawuy ubat sa langit, ikadêng-êy kataw êt sa pag-udung ku baydi ya idi kangkuy kapangyarian ku buy kapangyarian Bapan Namalyari buy kaawyun kuy mani banal la ang-el. ");
INSERT INTO blx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pansabin ku kamuyuy dilag dakun umnu kamuyuy asê mati anggan a la makitan na pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sên nilabas say waluy allu, tinumuksaw si Jesus sa bung-uy amên manalangin. Pikilaku na silan Pedro, Juan buy si Santiago. ");
INSERT INTO blx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kaban manalangin si Jesus, nagbayuy lupa na buy napakadyag yan naputiputi un mamakasilêw wa yaming na. ");
INSERT INTO blx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bêngat latan nakitan na propetan Bapan Namalyari ya silan Moises buy si Elias ya makisabi kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mamakasilêw sila êt buy sinabi la kanay, “Marani kaynan mati buy malyari ya ati sa balayan Jerusalem.” ");
INSERT INTO blx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Si Pedro buy mani kaawyun na, mamabêlêw sila. Nuwa nakaligwat sila ta nakit lay kapasilêw wa sawang Jesus buy ya luway liyaki ya silan Moises buy si Elias ya nakaidêng sa dani na. ");
INSERT INTO blx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sên pabitay nay luway liyaki, sinabin Pedro kan Jesus, “Manuru, mangêd da idi kitamu baydi. Manyag kay tatluy sawung. Gisa kamu, gisa kan Moises, buy gisa kan Elias.” Sinabin Pedro ya abitu, gawan kay nakatêgag ya. ");
INSERT INTO blx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Buy kaban magsabi pun si Pedro, natugpawan silan ulap. Kabay nalimu sila. ");
INSERT INTO blx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Amêsên, dilag gisay tunuy ya ubat sa ulap pa magsabin, “Ati ya Anak kuy pinili ku. Mallêngê kaw kana.” ");
INSERT INTO blx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sên tinunggên nan nagsabi ya tunuy, nakit lay gigisa tan Jesus. A la sinabi agyan kansabêt man ya nakitan la. ");
INSERT INTO blx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pamakawasak, sên inlumunsan sila sa bung-uy, timbêng malakêy tawu si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dilag gisay liyaki baydu sa malakêy tawuy masnêg magsabin, “Manuru, pakiêlêw mun kayêk ka kagisagisay anak kuy liyaki. ");
INSERT INTO blx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nu sêdakan yan nadawak ka ispiritu, bêngat yatan kumusadkusad ya man-angaw buy magbulabulay bêbêy. Pawa yatan pampasakitan un nadawak ka ispiritu buy a na labay lakwanan na anak ku. ");
INSERT INTO blx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Pikisabi kina sa mani tagasunul muy, ‘Ipatas la dayi ya nadawak ka ispirituy idi sa anak ku’, nuwa a laya agyun itas.” ");
INSERT INTO blx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nakitbay si Jesus, “Sikaw wa layin ayin panampalataya buy natukawkaw wa isip! Anggan makanu kataw pun pibabatan? Gêtan mu baydi ya anak mu.” ");
INSERT INTO blx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kaban magdani kan Jesus ya anak, intugaw ya buy ingkusadkusad yan nadawak ka ispiritu. Kabay impatas Jesus ya nadawak ka ispiritu, pinaiyul nay anak, buy in-udung na sa bapa na. ");
INSERT INTO blx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nakaupapas ya mani tawu sa nakitan lay kapangyarian Bapan Namalyari. Kaban nakaupapas ya kaganawan tawu sa mani dinyag Jesus, sinabi na sa mani tagasunul na, ");
INSERT INTO blx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Lêng-ên buy tandanên yuy ati ya sabin ku. Sikuy ubat sa langit ta in-Anak Tawu, igawang ngaku sa mani nipagtungkulan.” ");
INSERT INTO blx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nuwa a la mapukatan, gawan inliim kallay labay sabin Jesus. Buy malimu sila êt mamatang kana. ");
INSERT INTO blx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gisay allu, nisusubakan na mani tagasunul Jesus nu sisabêt kallay pinakadakila. ");
INSERT INTO blx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nuwa tandan Jesus ya pan-isipin la. Kabay impadani nay gisay anak ka nabêlêng buy impaidêng na sa dani na. ");
INSERT INTO blx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pamakayari, sinabi na kalla, “Sisabêt man na mananggap sa anak ka ati gawan sa panunul na kangku, sikinay pantanggapên na buy ya mananggap kangku, pantanggapên naynay namiutus kangku. Ta ya pinakanayêpay nakêm kamuyu kaparisun anak ka ati, sabay siyay pinakadakila.” ");
INSERT INTO blx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nakitbay si Juan, “Panginuun, dilag kay nakitan na mamipatas nangadawak ka ispiritu sa lagyu mu. Imbawal yan ya gawan a tamu ya kaawyun.” ");
INSERT INTO blx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nuwa sinabin Jesus kana, “Agana yuya bawalên. Ta sisabêt man na asê mallumaban kamuyu, kapanig yuya.” ");
INSERT INTO blx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sên marani yan mag-udung si Jesus sa langit, nagnakêm yan maku sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kabay in-utus nay dakun umnuy tawu sa gisay baryu sa Samaria amên mangkap silan tugêlan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nuwa a ya tinanggap mani tawu baydu, gawan tanda lay papakun ya sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sên natandan lan Santiago buy si Juan na ayin kalabay mananggap kan Jesus baydu, sinabi la kan Jesus, “Panginuun, kalabay ka ta manyawad kay apuy ubat sa langit amên sêlbên sila?” ");
INSERT INTO blx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nuwa nangawing si Jesus buy sinabyanan na sila. ");
INSERT INTO blx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kabay naku ta sila sa kaatag ga baryu. ");
INSERT INTO blx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kaban mamita silan Jesus sa dan, dilag liyaki ya nagsabi kan Jesus, “Kilaku waku kamu agyan saantu man na lakwên mu.” ");
INSERT INTO blx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nuwa nakitbay si Jesus, “Dilag lubut ta tutugêlan na mani asun aniwid. Dilag êt salay ya mani uybun manuk. Nuwa sikuy ubat sa langit ta in-Anak Tawu, ayin naku tan sarilin tutugêlan ya mapagpaynawan.” ");
INSERT INTO blx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sinabin Jesus sa gisa êt taman, “Kilaku ka kangku.” Nuwa nakitbay ya, “Panginuun, muli yaku pun dayi ta ipalbêng kuy bapa ku.” ");
INSERT INTO blx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nuwa sinabin Jesus kana, “Ipalbêng minay nati mu sa mani nati sa pangêlêw Bapan Namalyari. Nuwa sika, mita ka buy ibalita muy tungkul sa pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dilag êt nagsabi kan Jesus, “Panginuun, kilaku waku kamu, nuwa paulayan muku pun mulin magpatanda sa pamilya ku.” ");
INSERT INTO blx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nuwa sinabin Jesus kana, “Ya gisay manarul ya pawan mangawing, ayin ulagay panarul na. Para êt bayduy tawuy pawan mangawing sa mana nan pandaygên, ta a ya malyarin maglingkud kan Bapan Namalyari sa pag-arian na.” ");
INSERT INTO blx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pamakayarin sinabin Jesus ya abitu, namili yan pitumpu buy luway tawu. In-utus nan muna kana un tilwatilwa sa balang balayan buy lugal la lakwên na. ");
INSERT INTO blx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Buy sinabin Jesus kalla, “Elêwên yuy malakêy tawuy nakal-an magpasakup kan Bapan Namalyari ya paran pali ya pupulun, nuwa pêpêrad da mamupul. Kabay manalangin kaw sa Panginuun na magbandin pampupulun ya miutus yapun mamupul. ");
INSERT INTO blx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dali kawnay mita! Nuwa mamakapala kaw ta para kaw tupa ya pan-iutus ku sa mani tawuy paran asun aniwid. ");
INSERT INTO blx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Agana kaw mantan susut, bag, o sandalyas nga pangalili. Buy agana kaw manayang panawun sa pamikisabi sa tawu sa dan. ");
INSERT INTO blx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bayu kaw sumun sa gisay bali, sabin yu sa magbali, ‘Mapakamuyuy kapatêtbêkan.’ ");
INSERT INTO blx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nu mangêd da pananggap la kamuyu, mapakallay kapatêtbêkan Bapan Namalyari. Nu asê mangêd da pananggap la kamuyu, mag-udung êt kamuyuy kapatêtbêkan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Manugêl kaw sa bali ya bibiyan yu. Agana kaw kapaglipaylipay. Kanên buy inêmên yuy iapag la kamuyu. Tagawan na mag-ubra, dilag yan karapatan mananggap upa na. ");
INSERT INTO blx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nu lumatêng kaw sa gisay balayan buy tanggapên kaw mani tawu, kanên yuy iapag la kamuyu. ");
INSERT INTO blx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Paiyulun yuy mani nipagsakit baydu buy sabin yu kallay, ‘Marani yanay pag-arin Bapan Namalyari kamuyu.’ ");
INSERT INTO blx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nuwa nu a kaw tanggapên sa gisay balayan, maku kaw sa dan buy sabin yuy, ");
INSERT INTO blx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Agyan na abun balayan yuy nipigta sa mani bitis yan, pan-ikampag yan bilang pamipatanda yan kamuyu sa pamitakwil yu kanyan, ta agyan marani yanay pag-ari na kamuyu, a yu tinanggap.’ ");
INSERT INTO blx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pansabin ku kamuyuy sa Allun Pangukum, mas mabyat ta parusay madanasan mani tawu sa balayan abiin kaysa kaparusan ya nadanasan mani tawuy taga Sodoma sabitun nuna.” ");
INSERT INTO blx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sinabi pun êt Jesus, “Mamakapalunus kaw wa mani taga balayan Corazin! Mamakapalunus kaw êt ta mani taga balayan Bethsaida! Ta nu sa balayan Tiro buy sa balayan Sidon nalyari ya mani mamakaupapas ya dinyag ku kamuyu, manayna dayi silan nagyaming saku buy niknu sa abu bilang pagpapêtêg ga nagsisi silayna. ");
INSERT INTO blx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nuwa sa Allun Pangukum, mas mabyat ta parusay madanasan yu kaysa mani taga Tiro buy taga Sidon. ");
INSERT INTO blx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Buy sikaw wa mani taga Capernaum, indap yu kali nu dayêwên kaw angga sa langit? Asê! Isamwag kaw sa impernu!” ");
INSERT INTO blx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Amêsên, sinabin Jesus sa mani tagasunul na, “Sisabêt man na mallêngê kamuyu, sikinay inlêngê na. Buy sisabêt man na asê mananggap kamuyu, sikinay a na pantanggapên. Buy sisabêt man na asê mananggap kangku, a na êt pantanggapên na namiutus kangku.” ");
INSERT INTO blx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ya pitumpu buy luway tawuy in-utus Jesus un manuru, natula silan nag-udung. Sinabi la kana, “Panginuun, agyan na mani nadawak ka ispiritu, naipatas yan nu pansabin yan na lagyu mu!” ");
INSERT INTO blx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nakitbay si Jesus kalla, “Nakitan kuy tambêng nitas sa kapangyarian Satanas ya nanuwad kimat. ");
INSERT INTO blx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Binyanan kataw kapangyarian manambut sa kaganawan kampun Satanas ya kapati tamu. Kabay agyan turakan yuy mani utan buy kulsisipit ya mamakamati, a kaw masakitan. ");
INSERT INTO blx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Paraman baydu, agana yu ikatulay napasakup kamuyuy nadawak ka ispiritu nun a ya ikatula yu, nakasulat ta lagyu yu sa librun biyay sa langit.” ");
INSERT INTO blx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sa uras êt abitu, pinasiglan Ispiritun Bapan Namalyari si Jesus buy sinabi na, “Pampasalamatan katay Bapa, ya Panginuun sa langit buy baydi sa babun luta, gawan inliim muy ati ya kapêtêgan sa mani biyasa buy sa mani matag-ay ya pinag-aralan, nun a impatanda mu sa mani tawuy kaparisun nabêlêng nga anak ya ayin pun tanda. Awuy Bapa, dinyag muy abiin ta abiin na kalabayan mu.” ");
INSERT INTO blx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pamakayari, sinabi na sa mani tawu, “Indin na kangkun Bapay kaganawan. Ayin magtanda kangkuy Anak na, nun a kay Bapa ku. Buy ayin êt magtanda kan Bapa ku, nun a kay sikuy Anak na buy ya mani tawuy pinili kun pipatandan kana.” ");
INSERT INTO blx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Amêsên, sên kakapad la tana, pinag-arapan Jesus ya mani tagasunul na buy sinabi na kalla, “Pinagpala kaw, tagawan mangakitan yuy pandaygên ku. ");
INSERT INTO blx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pansabin ku kamuyuy malakêy mani propeta buy mani pinunu awlagi ya kalabay makakit sa nakit yu, nuwa a la nakit ta abitu. Labay la êt malêngêy nalêngê yu, nuwa a la nalêngê.” ");
INSERT INTO blx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Amêsên, dilag gisay manurun Kautusan na nidêng amên subukun si Jesus. Sinabi na, “Manuru, sabêt ta sêpat kun daygên amên mabiyan nakun biyay ya ayin katganan?” ");
INSERT INTO blx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nakitbay si Jesus kana, “Sabêt ta nakasulat sa Kautusan? Sabêt ta mangabasa mu baydu?” ");
INSERT INTO blx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nakitbay ya liyaki, “Kaidwan muy Panginuun mun Namalyari un buun bêkê, buun kaladwa, buun pas-êy, buy buun isip. Buy sêpat tamu êt kaidwan na kaparisu tamun tawu kaparisun pangidu tamu sa sarili tamu.” ");
INSERT INTO blx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Ustuy pikitbay mu,” sinabin Jesus. “Daygên muy abiin amên mabiyan kan biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nuwa asê labay manurun Kautusan na mipakadêng-êy ya. Kabay pinatang na si Jesus, “Nu parabaydu, sisabêt ta kaparisu kun tawu ya sêpat kun kaidwan?” ");
INSERT INTO blx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bilang pikitbay kana, nagkuwentu si Jesus, “Dilag gisay tawuy papakun sa Jerico ya ubat sa Jerusalem. Kaban mamita ya, inapat yan mani tulisan. Dinugêdugê laya, inlabus buy kingwa lay gêgtan na buy inlakwanan layan paray nan nati. ");
INSERT INTO blx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Amêsên, dilag pari ya nidan baydu. Sên nakitan nay liyaki ya dinugêdugê, inlibasan naya êt buy insundu nay pamita na. ");
INSERT INTO blx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dilag êt nidan bayduy gisay liyaki ya Levita. Nuwa sên inlumatêng ya baydu, nakitan nay gisay liyaki ya dinugêdugê. Inlibasan naya êt. ");
INSERT INTO blx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amêsên, dilag gisay tawuy Samaritano ya nidan baydu. Sên nakitan nay liyaki ya dinugêdugê, kinalunusan naya. ");
INSERT INTO blx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dinanyan nay abituy liyaki ta inuyasan nan alak buy laruy mani nuka na bayu na binêdbêdan. Pamakayari, insakay nay liyaki sa saysay nay pagsakayan na buy gintan na sa bali ya pan-upan, ta baydu nayan sinaysay. ");
INSERT INTO blx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pamakawasak, binyanan nan peray magbandin bali ya pan-ipaupa buy sinabi na kanay, ‘Saysayên muya buy nu kulang pun na abiin na magastus mu kana, bayaran kata sa pag-udung ku.’ ” ");
INSERT INTO blx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Amêsên, pinatang Jesus ya manurun Kautusan, sinabi na, “Sa êlêw mu, sisabêt sa tatlun abiin na pêtêg nangidu sa kaparisu nan tawuy dinugêdugên mani tulisan?” ");
INSERT INTO blx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nakitbay ya manurun Kautusan, “Sa êlêw ku, ya nalunus kana.” Sinabin Jesus kana, “Dali ka. Para êt bayduy daygên mu.” ");
INSERT INTO blx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sên namita si Jesus buy ya mani tagasunul na, nilatêng sila sa gisay balayan. Baydu dilag gisay babayi ya naglagyun Marta. Matula na silan tinanggap sa bali na. ");
INSERT INTO blx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Dilag patêl si Martan gisay babayi ya maglagyun Maria. Niknu si Maria sa kabitisan Jesus amên mallêngê sa pan-ituru na. ");
INSERT INTO blx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nuwa si Marta, asê mipaldan sa pamil-an kanên buy inêmên Jesus buy mani tagasunul na. Kabay nagdani ya kan Jesus buy sinabi na, “Panginuun, ayin naman nayin kwenta kamuy mana nangun kay nakaiknu si Maria sa kabitisan mun ayin tan dinyag? Sabin mu kanay sawpan naku di.” ");
INSERT INTO blx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nuwa sinabin Jesus kana, “Martay a kayna dayi mipaldan sa mani pandaygên mu ta. ");
INSERT INTO blx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kay gigisay kaylangan, ya mallêngê kangku. Sabay ya pinilin Maria. Mas mangêd da ati buy ayin makakwa kanan ati agyan kanuman.” ");
INSERT INTO blx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gisay allu, naku si Jesus sa gisay lugal amên manalangin. Amêsên, pamakayari nan nanalangin, sinabin gisa sa mani tagasunul nay, “Panginuun, turwanan mukay nu parasaantun manalangin kaparisun dinyag Juan sa mani tagasunul na.” ");
INSERT INTO blx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sinabin Jesus kalla, “Nu manalangin kaw, paradi ya sabin yu, ‘Bapa yan na Namalyari, labay yan na kay sikay ulimênên mani tawu. Labay yan na mag-ari kayna kanyan kaganawan. ");
INSERT INTO blx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Biyan mukay kanên sa inallu-allu. ");
INSERT INTO blx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Buy patawarên mukay sa mani kasalanan yan, tagawan pinatawad yan na kaganawan nangasalanan kanyan. Buy agana mukay paulayan matuksu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Amêsên, sinabi pun êt Jesus sa mani tagasunul na, “Alimbawa, dilag gisa kamuyuy naku sa balin kaluguran na un limbanak kan yabi. Sinabi na, ‘Kaluguran nay, biyan mukun tatluy tinapay, ");
INSERT INTO blx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","gawan inlumatêng nga kaluguran kuy ubat sa marayu buy ayin nakun maipakan kana amêsên.’ ");
INSERT INTO blx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nakitbay ya kaluguran nay idi sa lalên bali, ‘Agana mukay ya gambalên buy mani anak ku. Nakakalêk kay yana buy maanak ku buy nakakabat tay pasbul yan. A kina malyarin midêng amên idin pun na kaylangan mu.’ ");
INSERT INTO blx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nuwa pansabin ku kamuyuy agyan a naka labay biyan kanên gawan sa pamikaluguran yu, midêng yapun êt amên idin nay kaylangan mu gawan pinaanin-anin muya.” ");
INSERT INTO blx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kabay paradi ya sabin ku kamuyu. Manyawad kaw kan Bapan Namalyari buy biyan nakaw. Têkapên yu kanay pantêkapên yu buy makitan yu. Mamêg kaw kana buy pakitbayan nakaw. ");
INSERT INTO blx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tagawan na kaganawan manyawad kana, pambiyan na sila. Buy ya mangkap, makakit. Buy ya kaganawan mamêg, pakitbayan. ");
INSERT INTO blx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sikaw wa mani bapa, nu manyawad kamuyun kênan lanêm ma anak yu, biyan yuya nayin utan? Asê! ");
INSERT INTO blx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Buy nu manyawad ya nayin ukuy, biyan yuya nayin kulsisipit? Asê êt! ");
INSERT INTO blx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sikaw wa mani nangadadawak, nu katanda kaw mam-in mangangêd da bagay sa mani anak yu, luyang ngabay ya Bapa yun Namalyari ya idi sa langit! Idin nay Ispiritu na sa kaganawan manyawad kana.” ");
INSERT INTO blx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gisay allu, impatas Jesus ya gisay nadawak ka ispirituy ingkapipin gisay liyaki. Sên nag-awas say nadawak ka ispiritu, nakapagsabi ya liyaki. Kabay ya mani tawuy idi baydu, nakaupapas sila. ");
INSERT INTO blx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nuwa dilag dakun umnu bayduy nagsabin, “Si Satanas ya puun nangadadawak ka ispiritu sabay ya nam-in kapangyarian kanan mamipatas nangadadawak ka ispiritu.” ");
INSERT INTO blx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Buy ya kaatag êt taman, labay lan subukun si Jesus. Kabay inyawad la kanay mipakit yan mamakaupapas bilang tanda' ya in-utus yan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nuwa tandan Jesus ya pan-isipin la. Kabay sinabi na kalla, “Nu mitutubag ga mani tawu sa gisay kaarian, asê mapêng nga kaarian. Buy nu mitutubag ga gisay pamilya, mangapisisyay sila. ");
INSERT INTO blx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kabay nu pagkapatin Satanas ya pansakupun na, parasaantun mapêng nga panakup na? Pan-ipatang ku kamuyuy abiin tagawan pansabin yuy mamipatas sakun nangadawak ka ispiritu sa kapamilatan kapangyarian Satanas. ");
INSERT INTO blx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kabay nu mamipatas sakun mani nangadadawak ka ispiritu sa kapamilatan kapangyarian Satanas, sisabêt awêd da nam-in kapangyarian sa mani tagasunul yu amên mamipatas nangadadawak ka ispiritu? Ya mani tagasunul yuy mamipapêtêg ga taganan mali kaw. ");
INSERT INTO blx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amêsên, gawan namitas sakun mani nadawak ka ispiritu sa kapamilatan kapangyarian Bapan Namalyari, ya labay sabin, inlumatêng nga kamuyuy pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","In-alimbawan Jesus si Satanas sa gisay napas-êy ya liyaki. Sinabi na, “Nu dilag napas-êy ya liyaki ya malakêy almas na buy magbantay yan bali na, ayin nan makasun sa bali na amên makakwa sa mani pibandiyan na. ");
INSERT INTO blx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nuwa nu dilag lumatêng nga liyaki ya mas napas-êy pun kana, sambutun yan ati. Ta ya mas napas-êy ya liyaki, kêwên nay almas ya pan-asaan napas-êy ya liyaki. Kêwên êt mas napas-êy ya liyaki buy iatag-atag ya pibandiyan liyaki.” ");
INSERT INTO blx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ya asê panig kangku, kapati naku buy ya asê manawup sa pamidanin mani tawu kangku, kay mamipakarayu yan tawu kangku.” ");
INSERT INTO blx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sinabi pun êt Jesus, “Nu mag-awas ya nadawak ka ispiritu sa tawu, mibitabita ya sa mani kakyangan na lugal amên mangkap yan mapagpaynawan na. Nuwa nu ayin yan makitan, sabin na sa sarili nay, ‘Mag-udung ngaku tana sa tawuy ubatan ku.’ ");
INSERT INTO blx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Buy nu niudung ngina, makitan nay ubatan na ya paran bali ya malinis buy nakakumpuni yana. ");
INSERT INTO blx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kabay magtas ya sa tawuy ubatan na. Nuwa sa pag-udung na, mamipikilaku yan pituy ispirituy luyang pun nadawak kana buy magsêdak sila sa tawun abitu. Kabay luyang dumawak ya kabilyan tawun abitu kaysa mana nan kabilyan.” ");
INSERT INTO blx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kaban magsabi pun si Jesus, dilag gisay babayi ya idi sa malakêy tawuy masnêg nagsabi kan Jesus, “Pinagpalay babayi ya nianak buy namasusu kamu!” ");
INSERT INTO blx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nuwa nakitbay si Jesus kana, “Pêtêg bayna, nuwa luyang pinagpalay mani tawuy mallêngê buy manunul sa Sabin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kaban mititipun ya malakêy tawu sa danin Jesus, insundu nay pagsabi na. Sinabi na, “Ya mani tawu amêsên ya nadawak, mangkap silan mamakaupapas bilang tanda' ya in-utus sakun Bapan Namalyari. Nuwa ayin ipakit kalla nun a ya tanda' ya nalyari kan propeta Jonas sabitun nuna. ");
INSERT INTO blx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ya nalyari kan Jonas sabay ya nagin tanda' sa mani tawu sa Nineve ya pêtêg in-utus yan Bapan Namalyari. Para ku êt bayduy ubat sa langit ta in-Anak Tawuy in-utus Bapan Namalyarin magin tanda' sa mani tawu amêsên. ");
INSERT INTO blx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Si Reynan Sheba awlagi, agyan naubat yapun sa marayuy lugal, naku yan mallêngê sa kabiyasnan Arin Solomon. Amêsên, idi yaku baydi ya igit pun kan Solomon, nuwa a kaw kalabay mallêngê kangku. Kabay sa Allun Pangukum, midêng nga Reynan Sheba buy manuwat kamuyu. ");
INSERT INTO blx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pamakayarin nangaral Sabin Bapan Namalyari si Jonas baydu sa Nineve, nagsisi ya mani tawu. Amêsên, idi yaku baydi ya igit pun kan Jonas, nuwa a kaw kalabay magsisi sa mani kasalanan yu. Kabay sa Allun Pangukum, midêng nga mani taga Nineve buy manuwat kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sinabi pun êt Jesus, “Ayin tawuy mamagkêt sulu ya itagu na o tugpawan sa pamisêmpanan, nun a idin nay sulu sa pêtêg pamyanan amên mam-in sawang sa kaganawan sumun.” ");
INSERT INTO blx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Ya mata, sabay ya sawang lawini. Kabay nu malinaw wa pangêlêw mu, nasawang êt ta buun lawini mu. Nuwa nu napukakêy pangêlêw mu, nadêm êt ta buun lawini mu. ");
INSERT INTO blx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pilmin mu, ta dat ya sawang nga idi kamuyu indap yu nu nasawang, pakan nadiglêm awêd. ");
INSERT INTO blx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nu nasawangan na buun lawini yu buy ayin nan pêrad da nadiglêm baysên, nasawang ngay biyay yu ya paran sinawangan sulu.” ");
INSERT INTO blx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pamakayarin nangaral Jesus, dilag gisay Pariseoy nisagyat kanan mangan. Kabay nakilaku si Jesus buy nag-arap ya sa kanên. ");
INSERT INTO blx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ya mani Pariseo, dilag silan naugalyan nu parasaantuy panguyas gamêt bayu mangan, nuwa asê sinunul Jesus ya naugalyan la. Kabay nagtakay Pariseoy nisagyat kana. ");
INSERT INTO blx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kabay sinabin Jesus kana, “Sikaw wa mani Pariseo, pallinisin yuy lawasan tasa buy pinggan, pakan lalên bêkê yuy napnun kasakiman buy kadawakan. ");
INSERT INTO blx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mani ayin tanda! Agyan ya mani lawini buy lalên bêkê yu, si Bapan Namalyari ya nanyag. ");
INSERT INTO blx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kabay kalunusan yuy mani kalulu buy sawpan yu sila sa mani kaylangan la amên maituwad malinis ya bêkê buy lawini yu sa êlêw Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nuwa kapapalunus kaw wa mani Pariseo gawan parusan kaw Bapan Namalyari! Ta agyan na mani pamalasan pangkanên, pan-idin yuy ikapu kan Bapan Namalyari, pakan pampaulayan yinaman na katinêkan buy pangidu kan Bapan Namalyari. Mangêd da mam-i kaw ikapu yu, nuwa agana yu paulayan na mas maulagay pandaygên.” ");
INSERT INTO blx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kapapalunus kaw wa mani Pariseo gawan parusan kaw Bapan Namalyari! Ta labaylabay yun miknu sa iknuwan na in-il-an para sa maulagay tawu sa mani balin pagtipunan. Buy labaylabay yun galangên kaw mani tawuy malibasan yu.” ");
INSERT INTO blx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kapapalunus kaw wa mani Pariseo gawan parusan kaw Bapan Namalyari! Ta indap mani tawu, malinis kaw, pakan sa a la tanda, madinat kaw awêd. Kabay nanuwad kaw pamilbêngan na piturakturakan mani tawu sa a la tanda.” ");
INSERT INTO blx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Amêsên, sinabin gisa sa mani manurun Kautusan, “Manuru, agyan sikay yaman ni, ipakadêng-êy mu yata.” ");
INSERT INTO blx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nakitbay si Jesus kana, “Agyan sikaw êt ta mani manurun Kautusan, kapapalunus kaw, gawan parusan kaw Bapan Namalyari! Ta pan-ipatupad yu sa mani tawuy kautusan na masakit tuparên ya paran pan-ipabakay yu kallay mangabayat ta kalga, pakan a yu sila taganan sawpan sa pantan ati. ");
INSERT INTO blx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kapapalunus kaw êt! Tagawan magpadyag kaw mani tanda' sa mani pinilbêngan mani propetay pinatin mani ninunu yu. ");
INSERT INTO blx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kabay sikaw êt ta namipapêtêg ga inayunan yuy dinyag la. Ta pinati lay mani propeta buy siyan sikaw êt ta mipadyag mani tanda' sa mani pamilbêngan la. ");
INSERT INTO blx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kabay sa kabiyasnan Bapan Namalyari, ati ya sinabi na tungkul kamuyu, ‘Mamiutus sakun mani propeta kalla buy mani apostul. Patin lay kaatag buy pisakitan lay kaatag.’ ");
INSERT INTO blx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kabay sikaw wa mani tawu amêsên, parusan kaw Bapan Namalyari gawan sa pangamatin nunan propeta sabitun dinyag nay babun luta angga amêsên ");
INSERT INTO blx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","buy paubat pun sa pamatin mani ninunu yu kan Abel angga kan Zacarias ya pinati la êt sa pibunakan Templu buy sa pamiandugan. Awu, pansabin ku kamuyuy parusan kaw Bapan Namalyari gawan sa dinyag mani ninunu yu.” ");
INSERT INTO blx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kapapalunus kaw wa mani manurun Kautusan gawan parusan kaw Bapan Namalyari! Gawan a yu impatanda sa mani tawuy tungkul kan Bapan Namalyari. Buy agyan sikaw, a kaw kalabay magpasakup kana, nun a pambênbênan yu pun êt ta mani tawuy kalabay magpasakup kana. Paran kingwa yinay susi sa mani tawuy kalabay miawyun sa pag-arian Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pamakayarin nagsabin Jesus, namita ya sa balin abitu. Ubat ta baydu, ya mani Pariseo buy mani manurun Kautusan, pawa lan pambatikusun si Jesus. Pampatangên laya tungkul sa malakêy bagay. ");
INSERT INTO blx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pan-êtpanan lay pakitbay na amên nu magkamali ya sa pagsabi na, dakpên laya. ");
INSERT INTO blx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sa uras abitu, libulibuy tawuy mallumatêng kan Jesus buy sa sadyay lakê la, mangapipiit sila. Sinabin Jesus sa mani tagasunul na, “Mangillag kaw sa pagtatalinkayun mani Pariseo ya nanuwad pamalbag. ");
INSERT INTO blx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta ayin pan-itaguy asê makitan buy ayin pan-iliim ma asê matandan. ");
INSERT INTO blx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kabay sabêt man na sinabi yu sa nadiglêm, malêngê sa nasawang buy sabêt man na in-ayas yu sa lalên bali yu, sabay ya masnêg sabin.” ");
INSERT INTO blx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mani kaluguran ku, pansabin ku kamuyuy agana kaw malimu sa mani tawuy kalabay mamati kamuyu, ta kayari lan patin na lawini yu, ayin silaynan kaatag madyag kamuyu. ");
INSERT INTO blx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nuwa pansabin ku kamuyu ya sêpat yun kalimwan, kay si Bapan Namalyari, ta kayari na kan patin, dilag yapun êt kapangyarian mamisamwag kamuyu sa impernu. Awu, pansabin ku kamuyuy kay si Bapan Namalyari ya kalimwan yu.” ");
INSERT INTO blx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ya limay laynê, kay pan-isaliw sa nayêpay alaga. Nuwa agyan gisa man kalla, asê nalitêpan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kabay agana kaw malimu ta luyang kaw maulaga kaysa sa malakêy laynê. Ta agyan ya bilang mani sabut yu, tanda na.” ");
INSERT INTO blx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sinabi pun êt Jesus kalla, “Pansabin ku kamuyuy sikuy ubat sa langit ta in-Anak Tawu, sisabêt man na mangilala kangku sa arapan mani tawu, kilalanên kuya êt sa arapan mani ang-el Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nuwa sisabêt man na mamikadêng-êy kangku sa arapan mani tawu, ikadêng-êy kuya êt sa arapan mani ang-el Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sisabêt man na mallamus kangkuy ubat sa langit ta in-Anak Tawu, mapatawad yapun. Nuwa nu sisabêt man na mallamus sa Ispiritun Bapan Namalyari, a yina mapatawad.” ");
INSERT INTO blx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nu iarap lakaw sa mani balin pagtipunan mani Judio buy sa mani manungkulan sa balayan gawan sa panampalataya yu kangku, agana kaw napitik nu parasaantu kaw makitbay o nu sabêt ta sabin yu kalla bilang pamitanggul sa sarili yu, ");
INSERT INTO blx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tagawan sa uras abitu, ya Ispiritun Bapan Namalyari, sabay ya manuru kamuyu nu sabêt ta sabin yu.” ");
INSERT INTO blx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Amêsên, ya gisa sa malakêy tawuy idi baydu, sinabi na kan Jesus, “Manuru, sabin mu wati sa patêl kuy idin na kangkuy dakay ku sa mana yan.” ");
INSERT INTO blx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nuwa sinabin Jesus kana, “Patêl, awta ipatang muya kangkuy abiin ta? A ku tagaukum o tagadakay pibandiyan yu.” ");
INSERT INTO blx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kabay sinabi na kalla, “Mangillag kaw sa kaganawan kasakiman, tagawan ya biyay tawu, asê makwa sa lakên pibandiyan.” ");
INSERT INTO blx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Buy ingkuwentu pun êt Jesus ya paalimbawa, “Dilag gisay liyaki ya mabandi ya nakapupul malakê sa panamnan na. ");
INSERT INTO blx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kabay sinabi na sa sarili na, ‘Sabêt ta daygên ku? Ayin nakinan mapamyanan mani pupul ku. ");
INSERT INTO blx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ah, tanda kina! Lasakên kinay mani budega ku ta mipadyag gakun mas maragul la mani budega amên idin ku bayduy mani pupul buy pibandiyan ku.’ ");
INSERT INTO blx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pamakayari, sabin ku sa sarili ku, ‘Malakêy nay natipun ku para sa kinakarangan panawun. Kabay kay magpaynawa ku tanan mangan, minêm, buy magpakasaya!’ ” ");
INSERT INTO blx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Nuwa sinabin Bapan Namalyari kanay, ‘Ayin kan tanda! Sa yabin ati, kêwên kinay biyay mu. Kabay kaatag tan tawuy makapagnabang tinipun mu para sa sarili mu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sinabin Jesus, “Parabaysên ya malyari sa tawuy manipun pibandiyan na para sa sarili na, pakan kalulu ya awêd sa pangêlêw Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pamakayari, sinabin Jesus sa mani tagasunul na, “Kabay pansabin ku kamuyuy agana kaw napitik nu sabêt ta kanên yu amên mabyay. Buy agana kaw êt napitik nu sabêt ta iyaming yu. ");
INSERT INTO blx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tagawan igit maulagay biyay kaysa kanên buy igit maulagay lawini kaysa yaming. ");
INSERT INTO blx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Elêwên yu êt ta mani uwak. A sila mananêm, mamupul, o manipun maêkan la sa budega. Nuwa paramanbaydu, pampakan silan Bapan Namalyari. Sikaw pun nayi, igit kaw maulaga kaysa mani uybun manuk. ");
INSERT INTO blx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ayin kamuyun makapikadang biyay na agyan sa gisay uras sa kapamilatan kapitikan na. ");
INSERT INTO blx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kabay nu a yu agyun maikadang nga biyay yu agyan sa gisay uras, agana kawna napitik sa kaatag bagay.” ");
INSERT INTO blx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Elêwên yu nu parasaantun mantumubuy mani tanaman na mamulaklak ya bêngat tan tumubu. A sila mag-ubra o manyag yaming la. Nuwa pansabin ku kamuyuy agyan si Solomon na mabandi, a ya nakapagyaming kasin kangêd gisa man na bulaklak tanaman. ");
INSERT INTO blx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pampakangêdên Bapan Namalyari ya mani lamun sa bung-uy ya nabyay amêsên, nuwa pamakawasak, maulam. Nu parabaysên na pandaygên Bapan Namalyari sa mani lamun, luyang ngabay kamuyu, pilmin payamingan nakaw. Pêtêg kawnan nabêlêng nga panampalataya kana ta! ");
INSERT INTO blx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kabay agana kaw napitik tungkul sa kanên o inêmên yu. ");
INSERT INTO blx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta ya mani asê mangilala kan Bapan Namalyari, pawa silan napitik tungkul sa mani bagay ya abiin. Nuwa sikaw, tanday nan Bapa yuy idi sa langit ya kaylangan yuy kaganawan abiin. ");
INSERT INTO blx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kabay pagpilitan yun magpasakup sa pag-arin Bapan Namalyari buy idin na kamuyuy kaganawan kaylangan yu.” ");
INSERT INTO blx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Amêsên, sinabin Jesus sa mani tagasunul na, “Agyan pêpêrad kaw, agana kaw malimu, tagawan matula si Bapan Namalyarin mibilang kaw sa pag-ari na. ");
INSERT INTO blx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Isaliw yuy mani pibandiyan yu buy idin yu sa mani kaluluy naabli yu. Nu parabaysên na daygên yu, makatipun kaw pibandiyan sa langit ya asê maluma, asê maubus, asê matakaw buy asê anagên. ");
INSERT INTO blx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tagawan nu idi saantuy pibandiyan yu, idi êt bayduy isip yu.” ");
INSERT INTO blx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Sinabi pun êt Jesus kalla, “Pawa kaw maglêan sa pallumatêng ku kaparisun mani ipus ya mangêtêng sa pamulin amung lay ubat sa tangênan. Nakal-an nakapagkêt ya mani sulu la amên sa pallumatêng amung la buy magbêg ya, tambêng lan mabuklat ta pasbul. ");
INSERT INTO blx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pinagpalay mani ipus ya malatngan amung lay nakaimatan mangêtêng sa pamuli na. Pansabin ku kamuyuy maglêan ya amung la buy paiknun sila ta mamiapag yan kanên amên pakan sila. ");
INSERT INTO blx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pinagpalay mani ipus ya nakal-an sa pallumatêng amung la, agyan sa bunak yabi o mawatwatan man.” ");
INSERT INTO blx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Pakaisipin yuy ati. Nu tandan magbali nu sabêt ta uras pallumatêng manakaw, a na pasawên masunan na bali na. ");
INSERT INTO blx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kabay sikaw man, sêpat kaw pawan maglêan, tagawan sikuy ubat sa langit ta in-Anak Tawu, mag-udung ngaku sa uras ya magbabang-uwan kaw.” ");
INSERT INTO blx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Amêsên, namatang si Pedro, “Panginuun, para kansabêt ta paalimbawan abiin, kay para nayi kanyan, o para sa kaganawan?” ");
INSERT INTO blx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kabay nakitbay si Jesus, “Ya mapagtiwalan buy katanday ipus, sabay siyay pagtiwalan amung na sa mani kaatag ga ipus buy siyay mam-in kanên kalla sa ustuy uras. ");
INSERT INTO blx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pinagpalay abituy ipus nu malatêng yan amung nay mag-ubra sa pan-ipadyag amung na kana. ");
INSERT INTO blx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pansabin ku kamuyuy sabay siyay pagtiwalan amung na sa kaganawan pibandiyan na. ");
INSERT INTO blx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nuwa abiin na ipus, indap na nu mabuyut pun bayu lumatêng nga amung na. Ya daygên na, magpakabsuy ya, maglasing buy patukpatukun nay kaatag ipus, liyaki man o babayi. ");
INSERT INTO blx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Amêsên, sa alluy magbabang-uwan ya, lumatêng nga amung na. Kabay parusan yan amung nan mabyat buy isamwag naya sa lugal la pamisamwagan mani asê mapagtiwalan.” ");
INSERT INTO blx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ya ipus ya nakatanda sa kalabayan amung na, nuwa a ya nanunul, parusan yan mabyat. ");
INSERT INTO blx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nuwa ya ipus ya asê nakatanda sa kalabayan amung na buy nakadyag yan kamalyan ya ikaparusa na, kay nalup-aw wa parusay matanggap na. Ya binyanan malakê, malakêy têkapên kana. Awu, ya pinagtiwalan malakê, malakê êt ya pakitbayan na.” ");
INSERT INTO blx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sinabin Jesus, “Naku waku baydi sa babun luta amên mantan kaparusan paran apuy ya labay ku dayin magdêkêtdêkêt tina. ");
INSERT INTO blx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nuwa kaylangan ku pun danasên na pamasakit. Buy a ku mipatêtbêk anggan asê malyari ya ati.” ");
INSERT INTO blx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Indap yu nayi naku waku baydi sa babun luta amên dilag mangêd da pamiaawyun na mani tawu? Asê! Gawan sa pamaku ku baydi, dilag pipapatyan na mani tawu. ");
INSERT INTO blx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Paubat amêsên, mangapisisyay ya limay tawu sa gisay pamilya, tatlu laban sa luwa buy luwa laban sa tatlu. ");
INSERT INTO blx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pakipatyan bapay anak nay liyaki buy ya anak nay liyaki, pakipatyan nay bapa na. Para êt bayduy malyari sa indu buy anak nay babayi, sa ampu nay babayi buy sa manuyang nay babayi.” ");
INSERT INTO blx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sinabin Jesus sa mani tawu, “Nu makitan yu sa tatanglêwan alluy nabudêg, pansabin yuy manguran, buy manguran yabay. ");
INSERT INTO blx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Buy nu mantumyêp pay angin, pansabin yuy umumut buy umumut yabay. ");
INSERT INTO blx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mani mapagtalingkayu! Tanda yuy labay sabin mani mangakit yu sa luta buy sa langit, nuwa siyan a yuya tanday labay sabin pandaygên Bapan Namalyari sa kapamilatan ku amêsên ta?” ");
INSERT INTO blx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sinabi pun Jesus, “Isipin yu nu sabêt ta sêpat yun daygên. ");
INSERT INTO blx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu dilag mamidalum kamu, pagpilitan mun makikasundu kana kaban a naka pun naidalum. Ta dat pilitin naka pun iarap sa mallitis buy pamakayari, igawang kan mallitis sa pulis amên isukul. ");
INSERT INTO blx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pansabin ku kamuy a ka makaawas sa sukulan anggan a mu pun nabayaran na kaganawan pan-ipabayad la kamu.” ");
INSERT INTO blx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kaban magsabi si Jesus, dilag dakun umnuy tawuy nagdani buy nibalita kanan, “Dilag dakun umnuy tawuy impapatin Gobernador Pilato kaban mam-i silan andug kan Bapan Namalyari sa Templu.” ");
INSERT INTO blx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sinabin Jesus kalla, “Indap yu nayi ya gawan sa nalyari kalla, mas makasalanan na mani taga Galilea ya impapati kaysa kaatag taga Galilea ya asê impapati? ");
INSERT INTO blx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Asê! Pansabin ku kamuyuy nu a yu pagsisyan na mani kasalanan yu, milaku kaw êt sa ayin katganan na kaparusan. ");
INSERT INTO blx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Isipin yu êt ta mapu buy waluy tawuy nati sabitun nadug-anan silan matag-ay ya bali sa lugal Siloe. Indap yu nu mas makasalanan sila kaysa kaatag manugêl sa balayan Jerusalem ya asê nati? ");
INSERT INTO blx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Asê! Pansabin ku kamuyuy nu a yu pagsisyan ya mani kasalanan yu, milaku kaw êt sa ayin katganan na kaparusan.” ");
INSERT INTO blx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Amêsên, ingkuwentun Jesus ya paalimbawan ati, “Dilag gisay tawuy manggitna. Nipatanêm yan puun kayun igus sa panggitnan na. Inlaku nay ati amên êlêwên nu nanagêy yana, nuwa ayin yan nakitan. ");
INSERT INTO blx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kabay sinabi na sa manaysay gitna na, ‘Tatluy tawun nakinan miudung-udung baydi amên êlêwên nu nanagêy yay puun kayun igus, nuwa ayin naku yatan makitan. Putusun mutay puun kayun abiin! Masayang tay lutay pinitamnan kana.’ ");
INSERT INTO blx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nuwa nakitbay ya manaysay gitna na, ‘Amung ngay paulayên mina pun na puun kayu sa tawun ati. Kalin kuta pun na palitêng na buy biyan kun pamataba. ");
INSERT INTO blx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ta dat managêy ya sa gisay tawun. Nuwa nu asê pun, putusun kina.’ ” ");
INSERT INTO blx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gisay Allun Pagpaynawa, manuru si Jesus sa gisay balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Amêsên, dilag gisay babayi bayduy pinakuban nadawak ka ispiritu sa mapu buy waluy tawun. A yina makaidêng matinêk. ");
INSERT INTO blx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kabay sên nakitan yan Jesus, sinagyat nayan magdani kana buy sinabi, “Babayi, inumiyul kayna sa sakit mu.” ");
INSERT INTO blx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Impaluntun Jesus ya gamêt na sa babayi buy tambêng tinuminêk ka pamidêng babayi. Kabay nangulimên ya kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sa nalyarin abitu, nanubag ya mamunu sa balin pagtipunan mani Judio gawan namaiyul si Jesus sa Allun Pagpaynawa. Kabay sinabin mamunu sa mani tawuy, “Sa gisay duminggu dilag kaw anêm ma alluy pag-ubra. Sa mani allun abiin kaw waman dayin mamaiyul, alwan sa Allun Pagpaynawa.” ");
INSERT INTO blx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pinakitbayan yan Jesus, “Sikaw wa mapagtalingkayun manunul sa kalabayan Bapan Namalyari! Nu dilag kaw baka o asnu ya napêl-angan, alwa nayin agwatên yuya buy paynêmên agyan sa Allun Pagpaynawa? ");
INSERT INTO blx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nu kalunusan yuy mani saysay, parasaantu pun na babayin ati ya ubat sa layin Abraham ya mapu buy waluy tawun nan inggapus Satanas? Alwa nayin sêpat yan agwatên agyan sa Allun Pagpaynawa?” ");
INSERT INTO blx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Gawan sa sinabin Jesus, nipakadêng-êy ya mani tawuy makitubag kana. Nuwa ya kaatag gaman, natula sila gawan sa mamakaupapas ya dinyag Jesus. ");
INSERT INTO blx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Amêsên, insundun Jesus ya pangaral na. Sinabi na, “Saantu tamu maiparisuy pag-arin Bapan Namalyari? ");
INSERT INTO blx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ya pag-arin Bapan Namalyari, maiparisu sa gisay but-un mustasa ya intanêm gisay tawu sa panamnan na. Dinumagul yan napakadyag gisay puun kayu. Kabay ya mani sangan ati, mapanyagan salay mani uybun manuk.” ");
INSERT INTO blx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sinabi pun êt Jesus, “Alwa pun êt kay abiin. Ta ya pag-arin Bapan Namalyari, ");
INSERT INTO blx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","maiparisu ya sa pêpêrad da pamalbag ga ginêmês gisay babayi sa malakêy arina. Kabay napalbag nay arinay ginêmês.” ");
INSERT INTO blx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Insundun Jesus ya pamita na papakun sa Jerusalem. Buy sa pamita na, nangaral ya sa mani balayan buy sa mani baryuy mangadanan na. ");
INSERT INTO blx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Amêsên, dilag namatang kana, “Panginuun, pêpêrad nayi ya miligtas sa parusa?” Nakitbay si Jesus kana, ");
INSERT INTO blx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pagpilitan yun sumun sa nalipit ta pasbul, ta malakêy magpilit sumun, nuwa a sila makasun. ");
INSERT INTO blx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nu insaray nan magbandi ya pasbul bali na, midêng kaw tana sa lawasan. Magbêg kaw, sabin yu, ‘Patêl lay, pasunun mukay ya kayêk!’ Nuwa pakitbayan nakaw, ‘A kataw kakilala!’ ");
INSERT INTO blx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Buy sabin yu kana, ‘Aw indi, parasaantu mun masabi ya a mukay kakilala, pakan napagkaêm yan ka pun nangan buy ninêm. Nangaral ka pun êt sa lugal yan.’ ");
INSERT INTO blx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nuwa pakitbayan nakaw manguman, ‘Magpakarayu kaw kangku, sikaw wa kaganawan manyag kadawakan, ta a kataw kakilala.’ ");
INSERT INTO blx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Manangis kaw buy mingêngêt ta bêbêy tagawan makitan yu silan Abraham, Isaac, Jacob buy ya kaganawan mani propetay idi sa kaarian Bapan Namalyari, pakan sikaw, isamwag gaman sa lawasan. ");
INSERT INTO blx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sa allun abitu, malakêy alwan Judioy ubat sa magmikakanayun na lugal ya mapagkaêm sa kalutu sa kaarian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kabay pêtêg baynan dilag mapagmatag-ay amêsên ya miyêpa buy dilag mapagpayêpa amêsên ya mitag-ay.” ");
INSERT INTO blx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sa uras abitu, inlumatêng nga dakun umnuy Pariseoy nagsabi kan Jesus, “Mita kayna baydi, gawan labay kan ipapatin Gobernador Herodes Antipas.” ");
INSERT INTO blx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nakitbay si Jesus kalla, “Sabin yu sa mapagtalingkayuy isundu kuy pamitas kun nadawak ka ispiritu buy pamaiyul kun nipagsakit amêsên buy wasak. Sa ikatluy allu, mayari kuy pandaygên ku. ");
INSERT INTO blx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sêpat kun isunduy pamita ku amêsên, wasak buy sa kalwa, tagawan ayin kaatag pamatyan kanyan mani propeta nun a sa Jerusalem.” ");
INSERT INTO blx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Amêsên, sinabi pun êt Jesus, “Sikaw wa mani taga Jerusalem, pampatin yuy mani propeta buy pambatwan yuy mani pan-iutus Bapan Namalyari kamuyu angga sa mati sila. Katiumnu kataw nan labay tipunun buy saysayên kaparisun panyumyum gayindun manuk sa mani siwsiw na, nuwa siyan a kaw kalabay. ");
INSERT INTO blx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kabay agyan lasakên lay tutugêlan yu, pakabaala kawna. Pansabin ku kamuyuy paubat amêsên a yu kina makitan angga sa lumatêng nga panawun na sabin yuy, ‘Pagpalên na mallumatêng sa lagyun Panginuun.’ ” ");
INSERT INTO blx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Gisay Allun Pagpaynawa, dilag gisay Pariseoy mamunu ya nisagyat kan Jesus mangan sa bali na. Pambantayan yan mani tawuy idi baydu. ");
INSERT INTO blx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nagdani kan Jesus ya gisay liyaki ya binaya. ");
INSERT INTO blx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kabay namatang si Jesus sa mani manurun Kautusan buy sa mani Pariseo, “Awta sabêt ta idi sa Kautusan? Malyari nayin mamaiyul o asê sa Allun Pagpaynawa?” ");
INSERT INTO blx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nuwa a sila nakitbay. Kabay tinalan Jesus ya tawuy binaya, pinaiyul naya buy impauli. ");
INSERT INTO blx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Amêsên, pinatang silan Jesus, “Nu dilag gisa kamuyuy nag-anak o kaya nagbaka ya nanabu sa nalalêy lib-ung sa Allun Pagpaynawa, alwa nayin tambêng yuyan isalwang?” ");
INSERT INTO blx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nuwa ayin makapakitbay kana. ");
INSERT INTO blx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Amêsên, naêsban Jesus ya pampilin mani bisitay iknuwan ya nakal-an sa mani tawuy maulaga. Kabay nagsabi yan paalimbawa, ");
INSERT INTO blx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nu dilag nisagyat kamu sa gisay tangênan, agana ka mangamut miknu sa iknuwan mani tawuy maulaga, ta dat dilag pun insagyat ta mas maulaga pun kamu. ");
INSERT INTO blx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Dat danyan kan nisagyat kamu buy sabin na, ‘Idin muy abiin na iknuwan sa tawun ati.’ Sa pakapakun baydu, mipakadêng-êy kayna man buy miknu ka ta sa iknuwan mani tawuy asê maulaga. ");
INSERT INTO blx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kabay nu insagyat ka sa tangênan, ya mangêd minaman daygên, miknu kayna man pun sa iknuwan mani tawuy asê maulaga, ta dat magdani kamuy nisagyat buy sabin nay, ‘Kaluguran, miknu kayna man du sa iknuwan mani tawuy maulaga.’ Sa pakapakun baydu, maparangalan ka sa piakit-akit kaganawan bisita. ");
INSERT INTO blx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gawan ya mapagmatag-ay sabay ya iyêpan Bapan Namalyari. Buy ya mapagpayêpa, sabay ya itag-ay Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pamakayari, sinabin Jesus sa nisagyat kana, “Nu magkalutu ka sa gisay pamiêêman, ya isagyat mu, alwan kay mani kaluguran, mapatêl, mani kamag-anak o ya mabandi ya karani mun bali. Tagawan dat isagyat laka êt amên maablasan lay dinyag mu kalla. ");
INSERT INTO blx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kabay nu magkalutu ka, ya isagyat mina man, mani magkasakit, mani lumpu, mani pilay, buy mani bulag. ");
INSERT INTO blx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ta nu parabaysên na daygên mu, pagpalên kan Bapan Namalyari. Ta ya insagyat mu, agyan a la maablasan ya mangêd da dinyag mu kalla, si Bapan Namalyari yaman na mangablas kamu sa dinyag mu kalla sa panguman pangabyay.” ");
INSERT INTO blx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sên nalêngên gisa sa mani kaêm nay abiin, sinabi na kan Jesus, “Pinagpalay mani makaêm sa kalutu sa kaarian Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nakitbay si Jesus sa kapamilatan paalimbawa, “Dilag gisay liyaki ya nil-an maragul la kalutu buy nisagyat yan malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sên nakal-an nay kaganawan, in-utus nay gisay ipus nan sabin sa mani insagyat nay, ‘Kaksaw kawna, ta nakal-an nay kaganawan!’ ");
INSERT INTO blx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nuwa ya kaganawan insagyat, nanyag silan sangkan. Sinabin nuna, ‘Sabin muta kayêk kanay a ku milaku ta nakasaliw wakun panggitnan. Kaylangan kun lakwên amên makitan ku.’ ” ");
INSERT INTO blx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Nasên anti, inlaku nayna êt ta gisa, nuwa para êt bayduy sinabi na, ‘A kun kayêk milaku, ta nakasaliw wakun mapuy baka buy kaylangan ku silan subukun panarul.’ ” ");
INSERT INTO blx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Kabay inlaku nayna êt ya gisa, nuwa para êt bayduy sinabi na, ‘A kun kayêk milaku, ta bayu wakun tangên.’ ” ");
INSERT INTO blx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kabay nag-udung ya sa amung na buy imbalitay kaganawan sinabin insagyat na. Sên nalêngê nay imbalitan ipus, nanubag ya. Kabay nanguman yan niutus ipus na. Sinabi na, ‘Dali kayna, maku ka sa mani dan buy sa nalipit ta dan balayan. Ta isagyat mu baydi ya mani kalulu, mani lumpu, mani bulag, buy mani pilay.’ ” ");
INSERT INTO blx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Sên nag-udung nga ipus, sinabi na sa amung na, ‘Amung kuway, sinunul kinay kaganawan in-utus mu kangku, nuwa siyan dilag pun iknuwan ya ayin tawu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Sinabin amung sa ipus na, ‘Mita ka baydi sa balayan buy maku ka sa mani dan balayan buy sa mani dan sa lawasan balayan. Pagpilitan mun maku baydi ya mani tawu amên mapnun bisitay bali ku. ");
INSERT INTO blx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pansabin ku kamuyuy gisa man sa mani nuna kun insagyat, asê makataway inlutu ku.’ ” ");
INSERT INTO blx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Malakêy tawuy nakilaku kan Jesus. Amêsên, nag-arap ya kalla buy sinabi na, ");
INSERT INTO blx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sisabêt man na kalabay magin tagasunul ku, kaylangan idun nakun igit pun sa mangatwa na, asawa na, mani anak na, mapatêl na buy agyan sa sarili na. Nu a naku agyun idun igit pun sa kaganawan, a ya malyarin magin tagasunul ku. ");
INSERT INTO blx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sisabêt man na asê nakal-an mati gawan sa panunul na kangku kaparisun pamakay kurus, a ya malyarin magin tagasunul ku.” ");
INSERT INTO blx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sisabêt man na kalabay magin tagasunul ku, pakaisipin na pun, kaparisun gisay tawuy manyag gisay maragul la bali ya papakaisipin na pun nu saktuynay kaganawan kaylangan na amên mayari nay bali na. ");
INSERT INTO blx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta nu inumpisan nan impadyag ga bali, nuwa a na maipayari, kay uyamên yan mani tawuy makakit kana. ");
INSERT INTO blx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Sabin lay, ‘Nipaydêng ya kanwadis bali, pakan anata naipayari.’ ” ");
INSERT INTO blx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Para êt baydu sa gisay ari ya kalabay makipati sa kaparisu nan ari. Pakaisipin na pun nu agyun mapuy libuy sundalus nay luwampuy libuy sundalus kapati na. ");
INSERT INTO blx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta nu a na agyu, mamipauna yinan dakun umnuy tawu na amên makikasundu kaban marayu pun na kapati na. ");
INSERT INTO blx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Para kaw êt baydu. Pakaisipin yu pun nu agyu yun manunul kangku. Ta nu a yu agyun lakwanan ya kaganawan idi kamuyu, a kaw malyarin magin tagasunul ku.” ");
INSERT INTO blx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sinabi pun êt Jesus, “Mangêd da asin. Nuwa nu mitas ya lasa na, ayina miudung. ");
INSERT INTO blx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ayin nan ulaga sa luta buy asê êt malyarin iawyun sa pamataba. Kabay isamwag yatan mani tawu. Sikaw wa mani mallêngê, pakaisipin yuy nalêngê yu!” ");
INSERT INTO blx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Amêsên, ya mani maningil buwis buy mani kaatag makasalanan, naku silan mallêngê kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Amêsên, dilag mani Pariseo buy mani manurun Kautusan ya idi baydu buy niaayas sila. Sinabi la, “Elêwên yuy tawun abitu! Pantanggapên nay mani makasalanan buy makiêm yapun êt kalla.” ");
INSERT INTO blx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kabay sinabin Jesus kallay paalimbawan ati, ");
INSERT INTO blx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nu gisa kamuyuy dilag dinalan na tupa, ta nalitêp pa gisa, sabêt ta daygên na? Alwa nayin lakwanan na pun na siyam mapu buy siyam ma tupa baydu sa pagpastulan, ta têkapên nay gisay nalitêp angga sa makitan naya? ");
INSERT INTO blx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Buy nu makitan nay tupa, matula nay nan bakayên pauli. ");
INSERT INTO blx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pangalatêng na sa bali, sagyatên nay mani kaluguran na buy karani nan bali buy sabin kallay, ‘Makitula kaw kangku, gawan nakitan kinay tupa kuy nabating!’ ” ");
INSERT INTO blx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Buy sinabin Jesus, “Para êt bayduy idi sa langit. Matula-tula sila baydu gawan sa gisay makasalanan na nagsisi sa mani kasalanan na kaysa siyammapu buy siyam ma matinêk ka ayin nan pagsisi.” ");
INSERT INTO blx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Amêsên, sinabin Jesus ya paalimbawa sa mani niaayas, “Nu dilag gisay babayi ya dilag mapuy peray pilak ta nabating nga gisa, sabêt ta daygên na? Alwa nayin pagkêtan nay sulu buy pakangêdên nan têkapên sa buun bali ya peray nabating angga sa makitan nay ati? ");
INSERT INTO blx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Buy nu makitan naynay pera na, sagyatên nay mani kaluguran na buy karani nan bali buy sabin kallay, ‘Makitula kaw kangku, gawan nakitan kinay pera kuy nabating!’ ” ");
INSERT INTO blx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Buy sinabin Jesus, “Para êt bayduy idi sa langit. Matula-tulay mani ang-el Bapan Namalyari gawan sa gisay makasalanan na nagsisi sa mani kasalanan na.” ");
INSERT INTO blx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sinabi pun êt Jesus ya paalimbawa, “Dilag gisay bapay nag-anak luway liyaki. ");
INSERT INTO blx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amêsên, sinabin bungsu sa bapa na, ‘Bapay, idakay mina kangkuy atag ku sa mani pibandiyan mu.’ Kabay pidakay yan bapa lay atag lan luwa.” ");
INSERT INTO blx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Pamakalibas umnuy allu, insaliw bungsuy naatag nay pibandiyan buy naku ya sa marayuy lugal. Baydu na ginastus ya pera na sa ayin kapukatan na pamibiyaybiyay. ");
INSERT INTO blx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sên naubus naynay pera na, inlumatêng nga panawun layang sa lugal abitu. Kabay nag-umpisay kasakitan na gawan ayin ninan panaliw maêkan na. ");
INSERT INTO blx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ya dinyag na, naku yan nakiupa sa gisay tawuy tagabaydu. Kabay in-utus yan tawuy tagabaydu sa panggitnan na, ta dinyag nayan manaysay mani babuy. ");
INSERT INTO blx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sa sadyay layang na, kanên nayna dayi ya pangkanên babuy, gawan ayin nam-in kanên kana.” ");
INSERT INTO blx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Sên naisip-isip nay kaganawan dinyag na, sinabi na sa sarili nay, ‘Du kanyan naman ni agyan ya ipus bapa kuy ustuy pangkanên buy subra pun êt kalla. Nuwa sikina man, mati yan layang. ");
INSERT INTO blx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mag-udung ngaku ta sa bapa ku buy sabin ku kanay, “Bapay nangasalanan naku kan Bapan Namalyari buy kamu. ");
INSERT INTO blx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A kina sêpat bêgên mun anak. Ituwad muku tan gisa sa mani ipus mu.” ’ ");
INSERT INTO blx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kabay nuli yina sa bapa na. Idi yapun sa marayu, nakitan ninan bapa na. Sa lunus kanan ati, ginanagan nayan tinakês buy dinêp.” ");
INSERT INTO blx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Kabay sinabin anak sa bapa na, ‘Bapay, nangasalanan naku kan Bapan Namalyari buy kamu. A kina sêpat bêgên mun anak.’ ” ");
INSERT INTO blx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Nuwa sinabin bapa na sa mani ipus na, ‘Parasên yu! Kêwên yuy pinakamangêd da yaming bayu yuya payamingan. Pasingsingan yuyan singsing buy pasapatusan yuya. ");
INSERT INTO blx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Buy kêwên yuy nabêlêng nga bakay impataba. Patin yuy ati ta mangan kitamu buy magsaya! ");
INSERT INTO blx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gawan na anak kuy indap ku nu nati, pakan nabyay awêd! Indap ku êt nu nabating, pakan nakitan kina!’ Kabay nag-umpisa silaynan magsaya.” ");
INSERT INTO blx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Sa uras abitu, idi pun sa panggitnan ya panganay. Nuli ya ati buy sên marani yina sa bali la, nalêngê nay tigtigan buy talêkan. ");
INSERT INTO blx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kabay binêg nay gisay ipus buy pinatang na, ‘Awta? Sabêt ya nalyari baydi?’ ” ");
INSERT INTO blx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Nakitbay ya ipus, ‘Inlumatêng ya ali mu, nabyay buy ayin yan sakit. Kabay impati yan bapa mun impatabay baka.’ ” ");
INSERT INTO blx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Amêsên, nagsuluk ya panganay buy a ya kalabay sumun sa bali la. Kabay nag-awas ya bapa la amên samungun yan sumun.” ");
INSERT INTO blx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Nuwa nakitbay ya, ‘Bapay, sa makarang nga panawun, para kun ipus ya manunul sa kaganawan pan-iutus mu. Nuwa agyan misan, a mukuta binyanan agyan kay gigisay nabêlêng nga kambing amên makapagsaya ku kaawyun ya mani kaluguran ku. ");
INSERT INTO blx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nuwa sên inlumatêng ya anak muy nangubus buy nanggastus pibandiyan mu sa mani babayi ya pambayaran, siyan impati muya pun êt impatabay baka ta!’ ” ");
INSERT INTO blx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Kabay nakitbay ya bapa na, ‘Pakan pawa kata yan pagkaawyun na anak kuta buy kay kamuy kaganawan pibandiyan ku. ");
INSERT INTO blx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nuwa amêsên, sêpat kitamun magsaya buy matula, gawan ya patêl muy indap tamu nu nati yana, pakan nabyay awêd. Indap tamu êt nu nabating ya, pakan nakitan tamina.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Amêsên, sinabin Jesus sa mani tagasunul na, “Dilag gisay tawuy mabandi ya nitiwalan pibandiyan na sa gisay tawu. Nuwa dilag nipatanda kanan paradi, ‘Ya pinitiwalan mu, pinagmumun nay pibandiyan mu.’ ");
INSERT INTO blx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kabay impabêg nay pinitiwalan na buy pinatang naya, ‘Sabêt ta ati ya nalêngê ku tungkul kamu? Idin mina kangkuy kaganawan listaan nagastus mu buy ya tubu na. Ta paubat amêsên, akatayna mapagtiwalan sa pibandiyan ku.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kabay sinabin pinitiwalan sa sarili na, ‘Pataindukudu, itas sakinan amung ku sa ubra ku. Sabêt ta daygên ku, pakan a ku agyuy mabyat ta ubra buy madêng-êyan naku êt magpalimus. ");
INSERT INTO blx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, tanda kina! Ustun itas laku sa ubra ku, manyag gakun paralan amên tanggapên nakun mani tawu sa bali la.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Amêsên, bayu nam-in listaan ya pinitiwalan amung na, tisatisa nan pikisabyan ya kaganawan nakautang sa amung na. Pinatang nay nunan nakautang, ‘Umnuy utang mu sa amung ku?’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Nakitbay ya nag-utang, ‘Ya utang kuy larun ulibu, dinalan na banga.’ ” “Sinabin pinitiwalan, ‘Miknu ka, kêwên muy ati ya listaan utang mu, ta daygên mutan limampu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Amêsên, pinatang nayna êt ya ikalway nakautang, ‘Sika, umnuy utang mu?’ ” “Pikitbayan yan nag-utang, ‘Ya utang kuy trigu, dinalan na kaban.’ ” “Buy sinabi êt pinitiwalan, ‘Kêwên muy ati ya listaan utang mu, ta daygên mutan walumpu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Sên natandan amung nga dinyag asê mangêd da pinitiwalan, sinabi na, ‘Kabiyasnan minan manyag paralan!’ ” Sinabi pun êt Jesus, “Awu, pêtêg baynan mas katandan manyag paralan ya mani tawuy asê manunul kan Bapan Namalyari kaysa mani tawuy nasawangan nana tungkul kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Buy insundu pun êt Jesus ya pagsabi na, “Pansabin ku kamuyu ya mani pera yu baydi sa babun luta, isawup yu sa mani kaparisu yu. Ta agyan maubus ya pera yu baydi sa babun luta, baydu sa langit matula kaw tanggapên.” ");
INSERT INTO blx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ya tawuy mapagtiwalan sa pêrad da bagay, mapagtiwalan ya êt sa malakêy bagay. Buy ya tawuy asê mapagtiwalan sa pêrad da bagay, a ya êt mapagtiwalan sa malakêy bagay. ");
INSERT INTO blx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kabay nu a kaw mapagtiwalan sa mani pibandiyan baydi sa babun luta, a kaw êt pagtiwalan Bapan Namalyari sa pêtêg ga pibandiyan. ");
INSERT INTO blx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nu a kaw mapagtiwalan sa pibandiyan kaatag, ayin mam-in pibandiyan para kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ayin ipus ya piagnanên nan suyun ya luway amung na. Ta nu parabaydu, kasulapwan buy pustakên nay gisa, nuwa ya gisa, idun nan pêtêg. Para êt baydu, a yu malyarin piagnanên pagsuywan si Bapan Namalyari buy pibandiyan.” ");
INSERT INTO blx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sên nalêngên mani Pariseoy pangaral Jesus tungkul sa pibandiyan, dinustak laya, gawan lupa silan pera. ");
INSERT INTO blx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kabay sinabin Jesus kalla, “Magmamangêdan kaw kanwadis sa êlêw mani tawu pakan tandan Bapan Namalyari ya laman bêkê yu. Tagawan na mani pan-ituwad mani tawun maulaga, sabay ya asê kapapaidu kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ya Kautusan na impasulat kan Moises buy ya mani insulat propeta sabitun nuna, sabay ya pansunulun mani tawu angga sa nangaral si Juan ya Mamawtismu. Paubat sa panawun Juan, pan-iaral lay Mangêd da Balita tungkul sa pag-arin Bapan Namalyari buy malakêy magpilit miawyun sa mani pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nuwa asê labay sabin ayin kapukatan na Kautusan Bapan Namalyari. Ta agyan mapanat man na langit buy babun luta, asê êt madyag ayin pukat agyan kay gisay gulis sa Kautusan.” ");
INSERT INTO blx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Alimbawa, nu in-isyay liyaki ya asawa na ta mag-asawa yan kaatag, mangasalanan yan pamikikanayun. Buy sisabêt man na nakapag-asawa sa babayi ya in-isyay liyaki, mangasalanan ya êt pamikikanayun.” ");
INSERT INTO blx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sinabi pun êt Jesus sa mani Pariseo, “Dilag gisay liyaki ya mabandi ya pawan magyaming makamal buy malakêy kanên na sa inallu-allu. ");
INSERT INTO blx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dilag êt taman gisay kalulu bayduy maglagyun Lazaro ya pawan nukay lawini. Gintan ya sa lawasan pasbul sa balin mabandi. ");
INSERT INTO blx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kalabay ya dayin mangan agyan kay saksak kanên ya ubat sa lamesan mabandi. Alwan kay abitu, ta magdani pun êt kanay mani asu buy pandilên ya mani nuka na.” ");
INSERT INTO blx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Amêsên, nati ya kalulu buy gintan yan mani ang-el sa danin Abraham. Nati êt ta mabandi buy in-ilbêng ya. ");
INSERT INTO blx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Buy nakadanas yan sadyay kasakitan sa impernu. Amêsên, nangêlêw ya kan Abraham ya idi sa marayu kaawyun nan Lazaru. ");
INSERT INTO blx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Buy masnêg nan sinabi, ‘Bapan Abraham, malunus ka kangku! Iutus mu si Lazaro ya isugnu nay panudu na sa lanêm, ta patulwanan nay dila ku amên na kuta lumêpêt. Ta magkasakit taku baydi, gawan sa sadyay umut apuy.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nuwa nakitbay si Abraham, ‘Anak, ganakên mu sabitun nabyay ka pun sa babun luta. Nagpakapda ka, pakan si Lazaroy naman, pawan kasakitan na nadanasan na. Kabay masaya ya amêsên baydi, nuwa sika, idi ka amêsên baysên na magkasakit. ");
INSERT INTO blx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Buy gisa pun êt, dilag kakwalan na bêngaw sa pisaêtan tamu. Kabay ayin baydi ya makalaku baysên buy ayin baysên na makalaku baydi.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Sinabi êt mabandi, ‘Nu parabaydu awêd ya Bapan Abraham, makisabi yaku ya palakwên muta si Lazaro sa balin bapa ku. ");
INSERT INTO blx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ta patandan nay limay patêl kuy liyaki tungkul sa abiti ya lugal kasakitan amên a sila milaku baydi.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nuwa nakitbay si Abraham, ‘Idi kallay impasulat kan Moises buy mani insulat mani propeta. Kaylangan lan paniwalan na nakasulat.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kabay nakitbay ya mabandi, ‘Asê nukad da abituy Bapan Abraham. Nuwa nu dilag nati ya nanguman nabyay ya makun mangaral kalla, pagsisyan buy lakwanan lay mani kasalanan la.’ ” ");
INSERT INTO blx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Nuwa sinabin Abraham, ‘Nu a la pinaniwalan na impasulat kan Moises buy insulat mani propeta, a la êt paniwalan na iaral gisay nati ya nanguman nabyay.’ ” ");
INSERT INTO blx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Amêsên, sinabin Jesus sa mani tagasunul na, “Kanuman asê malisyan na pallumatêng tuksuy sangkan kasalanan. Nuwa kapalunus ya malyari sa tawuy pangubatan kasalanan kaparisu na. ");
INSERT INTO blx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sisabêt man na magin sangkan pangasalanan nangabêlêng nga anak ya manampalataya kangku, mangêd pun na is-êl la bêng na sa panggilingan na batu buy isamwag sa dagat. ");
INSERT INTO blx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kabay mangillag kaw. Nu nangasalanan kamuy patêl mu, sabyanan muya. Nu magsisi ya, patawarên muya. ");
INSERT INTO blx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Agyan makatapitu yapun mangasalanan kamu sa gisay allu, ta makatapitu ya êt manyawad tawad kamu, patawarên muya.” ");
INSERT INTO blx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Amêsên, sinabin mani apostul kan Jesus, “Dagdagan mu pun na panampalataya yan!” ");
INSERT INTO blx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nakitbay si Jesus, “Nu dilag kaw panampalatayay kasin bêlêng but-un mustasa, malyari yun sabin sa maragul la puun kayun ati, ‘Maulut ka buy milaku ka sa dagat!’ Buy sumunul yabay kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","Sinabi pun êt Jesus, “Alimbawa, nu dilag ipus ya manarul o magpastul mani tupa ya inlumatêng ubat sa panggitnan, asê malyari ya amung nga mamil-an kanên ipus na. Nun a ipus saman na maglingun amung na. Paradi ya sabin amung na, ‘Magyaming kayna bayu mu lingunun ya apunan ku. Kaban mangan naku, lingunun muku. Buy pamakayari kun mangan, malyari kaynan mangan buy minêm.’ ");
INSERT INTO blx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Asê pampasalamatan amung ya ipus na, ta kay pansunulun nay pan-iutus amung na. ");
INSERT INTO blx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Para êt baydu kamuyu. Nu nadyag yuy kaganawan in-utus kamuyu, sabin yuy, ‘Kay pandaygên yan na pan-iutus kanyan, ta kay ipus kay.’ ” ");
INSERT INTO blx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sa pamita lan Jesus buy mani tagasunul na palaku sa balayan Jerusalem, dinuman sila sa pisaêtan prubinsyan Samaria buy sa prubinsyan Galilea. ");
INSERT INTO blx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Amêsên, kaban pasun si Jesus sa gisay baryu, timbêng yan mapuy liyaki ya nagsakit sa balat. Ya mani nagsakit sa balat, tinunggên sila sa marayun pêrad. ");
INSERT INTO blx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Masnêg lan sinabi, “Panginuun Jesus, kalunusan mukay!” ");
INSERT INTO blx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pamakakit kallan Jesus, sinabi na, “Maku kaw sa mani pari buy ipaêlêw yuy lawini yuy ayin nan sakit.” Kaban mamita sila, mamakun ni, inumiyul buy inluminis ya lawini la. ");
INSERT INTO blx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sên nakitan gisa kallay inumiyul lina, nag-udung ya kan Jesus buy masnêg yan magsabin pangulimên kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nanduku ya sa arapan Jesus buy nagpasalamat kana. Ya tawun ati, gisa yan Samaritano. ");
INSERT INTO blx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sinabin Jesus, “Aw-indi, pakan mapu kaw yay pinaiyul ku nangun ta? Antuy siyam? ");
INSERT INTO blx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Uysiyan kay dayuwan yay nag-udung amên mangulimên kan Bapan Namalyari ta?” ");
INSERT INTO blx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kabay sinabin Jesus kana, “Midêng ka ta muli kayna. Inumiyul ka gawan sa panampalataya mu kangku.” ");
INSERT INTO blx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Amêsên, pinatang mani Pariseo si Jesus nu makanu mag-umpisay pag-arin Bapan Namalyari. Nakitbay si Jesus kalla, “Asê makitan na pallumatêng pag-arin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kabay ayin malyarin makapagsabin, ‘Baydin mag-ari si Bapan Namalyari!’ o ‘Baydu yan mag-ari!’ gawan si Bapan Namalyari, mag-ari yina sa bêkên mani manampalataya kana.” ");
INSERT INTO blx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Amêsên, sinabin Jesus sa mani tagasunul na, “Lumatêng lanuy panawun na labay yun makitan na pag-udung ku ya ubat sa langit ta in-Anak Tawu, nuwa a yu makitan na ati. ");
INSERT INTO blx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dilag magsabi tungkul kangku, ‘Elêwên yu, ati yina!’, o ‘Elêwên yu, idi yina baydi!’ Nuwa agana kaw maniwala o kilaku amên têkapên naku. ");
INSERT INTO blx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta sikuy ubat sa langit ta in-Anak Tawu, mag-udung ngaku sa babun luta ya paran kimat ta mansumawang sa buun langit. ");
INSERT INTO blx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nuwa amêsên, kaylangan naku pun makadanas malakêy kasakitan buy isakwil lakun mani tawu sa panawun amêsên.” ");
INSERT INTO blx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nu parasaantun nagbabang-uwan na mani tawu sabitun panawun Noe, para êt baydun magbabang-uwan na mani tawu sa allun pag-udung kuy ubat sa langit ta in-Anak Tawu. ");
INSERT INTO blx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sabitun panawun Noe, magbabang-uwan na mani tawun mangan, maglasing, buy mipag-asawa angga sa sinumun sa barku si Noe. Inlumatêng nga lanab buy nangalulumud da kaganawan.” ");
INSERT INTO blx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Para êt baydu sa panawun Lot. Ya mani tawu mangan, mipaglasing, manaliw, magtinda, manggitna buy mamipaydêng bali, ");
INSERT INTO blx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","angga sa allun inlakwanan Lot ya balayan Sodoma. Pamakayari, nanguran nan apuy buy asupri ya ubat sa langit. Kabay nati silan kaganawan sa Sodoma.” ");
INSERT INTO blx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Para êt bayduy malyari sa allun pag-udung kuy ubat sa langit ta in-Anak Tawu. ");
INSERT INTO blx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sa allun abitu, ya idi sa lawasan bali, aganayna sumun amên mangwan dakun sabêt sa lalên bali na. Ya idi sa panggitnan, aganayna muli. ");
INSERT INTO blx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Isipin yuy nalyari sa asawan Lot sa balayan Sodoma. ");
INSERT INTO blx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sisabêt man na tawuy maglabay miligtas ya biyay na, sabay ya matasan biyay na. Nuwa ya sisabêt man na nakal-an mam-in biyay na, sabay ya mabiyan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Pansabin ku kamuyuy sa yabin abitu, dilag luway liyaki ya mamabêlêw wa midani. Ya gisa, gêtan sa langit. Nuwa ya gisa, lakwanan. ");
INSERT INTO blx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dilag luway babayi ya miawyun manggiling. Ya gisa, gêtan sa langit. Nuwa ya gisa, lakwanan. ");
INSERT INTO blx_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dilag luway liyaki ya miawyun mag-ubra sa panggitnan. Ya gisa, gêtan sa langit. Nuwa ya gisa, lakwanan.” ");
INSERT INTO blx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pinatang yan mani tagasunul na, “Panginuun, saantu malyari ya abiin!” Nakitbay ya, “Nu saantuy dilag bangkay, mititipun bayduy mani uwak.” ");
INSERT INTO blx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Amêsên, insabin Jesus sa mani tagasunul nay gisay paalimbawa, ta labay nan ipaintindi kallay kaylangan lan pawan manalangin buy agana mangaynay nakêm. ");
INSERT INTO blx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sinabi na, “Sa gisay balayan, dilag mallitis ya ayin limu kan Bapan Namalyari buy ayin panggalangên na tawu. ");
INSERT INTO blx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sa balayan êt abitu, dilag babayi ya nabal-u. Pawa yan mamaku sa mallitis buy pansabin nay, ‘Itanggul muku laban sa mani kapati ku!’ ");
INSERT INTO blx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sa nunan pangabalan nabal-u kana, a naya pun dinambi, nuwa sa makarang nga panawun, sinabi na sa sarili na, ‘Agyan ayin nakun limu kan Bapan Namalyari buy ayin nakun panggalangên na tawu, ");
INSERT INTO blx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nuwa sawpan kuyna sa kasu na, gawan ayin tunggên na pangabala na kangku buy pêrad tana mapasuluk nakina.’ ” ");
INSERT INTO blx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Amêsên, sinabin Panginuun Jesus kalla, “Pakaisipin yuy sinabin abituy nadawak ka mallitis. ");
INSERT INTO blx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Si Bapan Namalyari pun nayi, a na nayi itanggul ya pinili nan kay kana ya mamêg kana allu buy yabi? Paêtêngên na sila nayin mabuyut? ");
INSERT INTO blx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pansabin ku kamuyuy tambêng silan itanggul. Nuwa sikuy ubat sa langit ta in-Anak Tawu, sa pag-udung ku baydi sa babun luta, dilag gaku nayin malatêng nga manampalataya kangku?” ");
INSERT INTO blx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Amêsên, dilag mani tawu bayduy indap lay matinêk sila. Kabay ya êlêw layna man sa kaatag, nayêpa. Kabay sinabin Jesus kallay gisay paalimbawa, ");
INSERT INTO blx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Dilag luway liyaki ya naku sa Templu amên manalangin. Ya gisa, Pariseo, buy ya gisa, maningil buwis. ");
INSERT INTO blx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nidêng nga Pariseo buy nanalangin yan patungkul sa sarili na. Sinabi na, ‘Bapan Namalyari, magpasalamat taku kamu tagawan a ku kaparisun kaatag manakaw, mallinlang buy makikanayun o kaparisun ati ya maningil buwis. ");
INSERT INTO blx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sa gisay duminggu, katilwa kun mag-ayunu, buy mam-i yaku êt ikapu sa kaganawan upa ku.’ ” ");
INSERT INTO blx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nuwa ya maningil buwis, nakaidêng ya sa marayu buy manalangin. Sa dêng-êy na, a na maêlêw ya langit. Kabay pan-apuapun nay pagaw na buy pansabin na, ‘Malunus ka kangkuy Bapa kun Namalyari, ta gisa kun makasalanan.’ ” ");
INSERT INTO blx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sinabi pun Jesus, “Pansabin ku kamuyuy nuli ya maningil buwis un matinêk sa pangêlêw Bapan Namalyari. Nuwa ya Pariseo, asê. Gawan ya mapagmatag-ay, sabay ya iyêpan Bapan Namalyari. Buy ya mapagpayêpa, sabay ya itag-ay Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Amêsên, dilag mani tawuy nilakun nangabêlêng nga anak kan Jesus amên yawarên lan ipaluntuy gamêt na kalla buy pagpalên na sila. Sên nakitan mani tagasunul nay abitu, binênbênan lay mani tawu. ");
INSERT INTO blx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nuwa binêg Jesus ya mani tagasunul na buy sinabi na kalla, “Paulayan yun magdani kangkuy mani anak. Agana yu sila bênbênan, tagawan ya mani kaparisu la sabay ya mani tawuy miawyun sa pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pansabin ku kamuyuy sisabêt man na asê magpasakup sa pag-arin Bapan Namalyari kaparisun pagpasakup nangabêlêng nga anak, a ya miawyun sa mani tawuy pag-arian na.” ");
INSERT INTO blx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Amêsên, dilag gisay liyaki ya nagtungkulan ya namatang kan Jesus, “Mangêd da Manuru, sabêt ta sêpat kun daygên amên mabiyan nakun biyay ya ayin katganan?” ");
INSERT INTO blx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nakitbay si Jesus kana, “Uysiyan binêg muku yan mangêd ta? Ayin kaatag mangêd nun a kay si Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tanda muy Kautusan Bapan Namalyari, ‘Agana ka makikanayun, agana ka mamatin tawu, agana ka manakaw, agana ka magpapêtêg sa alwan kapêtêgan, buy galangên muy mangatwa mu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Nakitbay ya liyaki ya nagtungkulan, ‘Ubat pun sa anak kaku, pansunulun kinay kaganawan abiin angga amêsên.’ ” ");
INSERT INTO blx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sên nalêngên Jesus ya sinabin nagtungkulan, sinabi na kana, “Dilag ka pun gisay sêpat daygên. Isaliw muy kaganawan pibandiyan mu buy ya naabli mu, idin mu sa mani kalulu. Sa pakapakun baydu, dilag kan pibandiyan sa langit. Pamakayari, mag-udung ka buy manunul kangku.” ");
INSERT INTO blx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nuwa sên nalêngên nagtungkulan ya sinabin Jesus, inlumungkut ya, gawan malakêy pibandiyan na. ");
INSERT INTO blx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sên nakitan Jesus ya nalungkut ya nagtungkulan, sinabi na, “Pêtêg baynan masakit magpasakup pa mani tawuy malakêy pibandiyan sa kaarian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tagawan misun pun na kamelyu sa lubut karayum, kaysa misun sa kaarian Bapan Namalyari ya gisay tawuy mabandi.” ");
INSERT INTO blx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Amêsên, namatang nga mani tawuy nakalêngê sa sinabin Jesus, “Nu parabaydu, sisabêt awêd da miligtas?” ");
INSERT INTO blx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nakitbay si Jesus kalla, “Ya asê madyag tawu, madyag Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Amêsên, sinabin Pedro, “Parasaantu kay yaman? Inlakwanan yan na kaganawan amên manunul kamu.” ");
INSERT INTO blx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nakitbay si Jesus, “Pansabin ku kamuyuy nu sisabêt man na nallakwan bali na, asawa na, mapatêl na, mangatwa na, o maanak na gawan sa pag-arin Bapan Namalyari, ");
INSERT INTO blx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mabiyan yan igit pun sa inlakwanan na sa panawun amêsên. Buy sa lumatêng nga panawun, mabiyan yan biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Amêsên, impapawan Jesus ya mapu buy luway tagasunul na buy sinabi na kalla, “Tumuksaw kitamina sa Jerusalem buy matupad da bayduy kaganawan insulat mani propeta tungkul kangkuy ubat sa langit ta in-Anak Tawu. ");
INSERT INTO blx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Igawang ngaku sa mani alwan Judio. Pidudustakan, ipakadêng-êy buy tupaytupayan laku. ");
INSERT INTO blx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Latikun laku buy patin, nuwa sa ikatluy allu, manguman nakun mabyay.” ");
INSERT INTO blx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nuwa ayin napukatan ya mapu buy luway tagasunul na sa sinabi na. Inliim kallay labay sabin abitu buy a la tanda nu sabêt ta pantukuyun na. ");
INSERT INTO blx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Amêsên, sên narani ya silan Jesus sa balayan Jerico, dilag gisay bulag ga liyaki ya magpalimus ya nakaiknu sa agid dan. ");
INSERT INTO blx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sên nalêngê nay malakêy tawuy mallumibas, pinatang na sila, “Sabêt ta malalyari?” ");
INSERT INTO blx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pinakitbayan laya, “Mallumibas si Jesus ya taga Nazaret.” ");
INSERT INTO blx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kabay masnêg sinabin bulag, “Jesus ya Layin Arin David, kalunusan mukun kayêk!” ");
INSERT INTO blx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Binênbênan yan idi sa mumunan Jesus, “Agana ka mantarit.” Nuwa ingkakadus nan insabin masnêg, “Layin Arin David, kalunusan mukun kayêk!” ");
INSERT INTO blx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sên nalêngê yan Jesus, tinunggên ya buy dilag yan in-utus mangakay sa bulag amên idani kana. Sên marani yay bulag, sinabin Jesus kana, ");
INSERT INTO blx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Sabêt ta labay mun daygên ku kamu?” Nakitbay ya bulag, “Panginuun, kalabay yakun makakit.” ");
INSERT INTO blx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kabay sinabin Jesus kana, “Makakit kayna. Inumiyul ka gawan sa panampalataya mu kangku.” ");
INSERT INTO blx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tambêng yan nakakit buy nanunul ya kan Jesus un mangulimên kan Bapan Namalyari. Sên nakitan mani tawuy nalyari, nangulimên sila êt kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Amêsên, nilatêng nga silan Jesus sa balayan Jerico ta baydu silan duman papakun sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Dilag gisay liyaki bayduy maglagyun Zaqueo. Mabandi ya buy gisa ya sa mani puun maningil buwis. ");
INSERT INTO blx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Labay nan makitan nu sisabêt si Jesus, nuwa gawan pandak ya buy malakêy tawu, a naya makitan. ");
INSERT INTO blx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kabay nuwayu yan nuna sa danan lan Jesus bayu ya nagdakêy sa puun kayun sikamoru amên makitan naya. ");
INSERT INTO blx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sên niras silan Jesus sa nagkayu, inêlêw na si Zaqueo buy sinabi na, “Zaqueo, parasên mun magtabuy ta kaylangan kun maku amêsên sa bali mu.” ");
INSERT INTO blx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kabay tambêng nagtabuy si Zaqueo buy matula nan tinanggap silan Jesus sa bali na. ");
INSERT INTO blx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sên nakitan mani tawuy sinumun si Jesus sa balin Zaqueo, niaayas sila. Sinabi la, “Nagdaus ya sa balin tawuy makasalanan.” ");
INSERT INTO blx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kabay nidêng si Zaqueo buy sinabi na, “Panginuun. Idin ku sa mani kaluluy kapitnan pibandiyan ku buy nu sisabêt man na napurayit kuy iudung kun katiapat ta kingwa ku kana.” ");
INSERT INTO blx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sinabin Jesus kana, “Niligtas say magbalin ati, gawan naniwala si Zaqueo kan Bapan Namalyari kaparisun ninunu yun si Abraham. ");
INSERT INTO blx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tagawan sikuy ubat sa langit ta in-Anak Tawu, naku waku baydi amên têkapên buy iligtas ya balang nalitêp.” ");
INSERT INTO blx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kaban mallêngêy mani tawu, insabin Jesus kallay gisay paalimbawa gawan marani silayna sa balayan Jerusalem buy indap mani tawu mag-umpisay nay pag-arin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kabay sinabi na, “Dilag gisay tawuy panggalangên ya naku sa marayuy lugal amên tanggapên nay tungkulan nan mag-ari. Buy nu matanggap naynay katungkulan na, mag-udung ya. ");
INSERT INTO blx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nuwa bayu ya namita, binêg nay mapuy ipus na buy binyanan na silan tisatisay peray gintu. Sinabi na kalla, ‘Kaban ayin naku pun, pakalak-ên yuy ati.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Nuwa kasulapwan yan mani kalugal na. Kabay sên namita ya, dilag silan in-utus sa lugal ya lakwên na amên sabin lay, ‘A yan labay mag-ari kanyan ya tawun abiin.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Nuwa nadyag yapun êt ari. Sên nakauli yina sa balayan na, impabêg nay mapuy ipus nay binyanan nan peray gintu amên matandan na nu umnuy natubu la. ");
INSERT INTO blx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nagdani kanay nuna buy sinabi, ‘Amung kuway, ya peray gintuy intiwala mu kangku, nakatubu yan mapu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Sinabin ari, ‘Mangêd da ipus, mangêd da dinyag mu! Ta mapagtiwalan ka sa pêpêrad da intiwala ku kamu, sikay mamaala sa mapuy balayan.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nagdani êt kanay ikalwa buy nagsabi, ‘Amung kuway, ya peray gintuy intiwala mu kangku, nakatubu yan lima.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Kabay sinabi êt ari kana, ‘Sikay mamaala sa limay balayan.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Amêsên, nagdani êt ta gisay ipus buy sinabi, ‘Amung kuway, ati ya peray gintu mu. Impunggus kuya sa gisay panyu bayu ku intagu, ");
INSERT INTO blx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","gawan malimu waku kamu. Ta tanda kuy maigpit ka, pangkêwên muy a mu pinagpagalan buy pampupulun muy a mu intanêm.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kabay sinabin ari kana, ‘A mangêd da ipus! Atulan kata ayun sa sinabi mu. Tanda mu awêd da maigpit taku, pangkêwên kuy a ku pinagpagalan buy pampupulun kuy a ku intanêm.’ ");
INSERT INTO blx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Parabaydu awêd, uysiyan a mu yata imbangkuy peray gintu ku amên sa pag-udung ku, makwa kuy tubu na? ");
INSERT INTO blx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Amêsên, sinabin ari sa mani idi baydu, ‘Kêwên yu kanay peray gintu, ta idin yu sa nakapagtubun mapu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Nuwa sinabi la, ‘Amung kuway, dilag ginan mapuy peray gintu!’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Kabay sinabin ari, ‘Pansabin ku kamuyu ya tawuy mapagtiwalan sa pêrad, biyan yapun. Nuwa ya tawuy asê mapagtiwalan agyan sa pêrad da intiwala kana, itas pun êt kana. ");
INSERT INTO blx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amêsên, tungkul laman sa mani kapati kuy asê kalabay pasakup kangku bilang ari la, gêtan yu sila baydi buy patin yu sila sa arapan ku.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sên pamakayarin ingkuwentun Jesus, insundu nay pamita na patuksaw sa balayan Jerusalem kaawyun na mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sên narani yana silan Jesus sa bung-uy ya pambêgên Bung-uy mani Ulibu ya narani sa balayan Bethfage buy sa balayan Bethania, impauna nay luway tagasunul na. ");
INSERT INTO blx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Sinabi na kalla, “Maku kaw sa kasunul la baryu. Pamakasun yu baydu, makitan yuy gisay biserun asnuy nakas-êl ya asê pun nasakayan agyan sisabêt man. Agwatên yu buy iakay yu baydi. ");
INSERT INTO blx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nu dilag mamatang kamuyun paradi, ‘Uysiyan pan-agwatên yu yay asnu ta?’ sabin yu kanay, ‘Kaylangan yan Panginuun.’ ” ");
INSERT INTO blx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kabay namitay nay luway in-utus na buy nakitan laya bay ya biserun asnu baydu kaparisun sinabin Jesus. ");
INSERT INTO blx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kaban pan-agwatên lay asnu, sinabin magbandi, “Uysiyan pan-agwatên yu yay biserun asnu ta?” ");
INSERT INTO blx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nakitbay sila, “Kaylangan yan Panginuun.” ");
INSERT INTO blx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","In-akay la kan Jesus ya biserun asnu buy inlatêp lay balabal la sa bukut biserun asnu buy impasakay layna si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Insundu lan Jesus ya pamita la papakun sa Jerusalem. In-makmak mani tawuy balabal la sa danan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sên marani silayna sa Jerusalem, palunsan sa Bung-uy mani Ulibu, ya mani tagasunul na, nagkanta silan sadyay saya buy pan-ulimênên la si Bapan Namalyari, gawan sa nakitan lay mamakaupapas sa dinyag Jesus. ");
INSERT INTO blx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sinabi la, “Pagpalên na ari ya in-utus Bapan Namalyari! Dilag kapatêtbêkan sa langit! Ulimênên si Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Amêsên, baydu sa lakên mansumunul kan Jesus, dilag dakun umnuy Pariseoy nagsabi kanan, “Manuru, ibawal muy mani tagasunul mun mangulimên kamu.” ");
INSERT INTO blx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nuwa pikitbayan silan Jesus, “Pansabin ku kamuyuy nu mangimbêk sila, ya mani batuy man-angaw mangulimên.” ");
INSERT INTO blx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sên marani ya silan Jesus sa balayan Jerusalem, nakitan nay balayan buy tinangisan nay mani tawu baydu, gawan sa lunus na kalla. ");
INSERT INTO blx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Sinabi na, “Kapapalunus kaw wa manugêl sa Jerusalem. Nu tanda yu dayi nu sabêt ta mam-in kapatêtbêkan, a kaw dayi kapalunus, nuwa a yu tanda! ");
INSERT INTO blx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lumatêng lanuy alluy pagkampuwan kaw mani kapati yu. Palitêngan buy duyungun lakaw. ");
INSERT INTO blx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Patin lakaw buy sirên lay mani balayan yu. Buy ayin batuy mitagan na nakapaluntu sa kaparisu nan batu. Madanasan yuy abiin, gawan a yu dinambi ya pallumatêng Bapan Namalyari ya mamiligtas kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Amêsên, naku si Jesus sa kasawangan Templu buy impatas nay mani magtinda. ");
INSERT INTO blx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Sinabi na kalla, “Nakasulat sa Sabin Bapan Namalyari, ‘Ya bali ku, balin panalanginan.’ Nuwa siyan dinyag yun pagtagwan mani manakaw!” ");
INSERT INTO blx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Amêsên, allu-allun manuru si Jesus sa kasawangan Templu. Nuwa ya mani mamunun pari, ya mani manurun Kautusan, buy ya mani manungkulan, labay lan ipapati si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nuwa ayin silan makit ta paralan, ta labaylabay lêng-ên mani tawuy pan-ituru na. ");
INSERT INTO blx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gisay allu, kaban manuru buy mangaral si Jesus un Mangêd da Balita sa mani tawuy idi sa kasawangan Templu, nagdani kanay mani mamunun pari, mani manurun Kautusan buy mani mangatway manungkulan. ");
INSERT INTO blx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Sinabi la kanay, “Dat sabin mu wati kanyan nu sabêt ta karapatan mun manyag parabaysên? Sisabêt ta nam-i kamun parabaysên na karapatan?” ");
INSERT INTO blx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Pikitbayan silan Jesus, “Patangên kataw êt. Sabin yu wati kangku ");
INSERT INTO blx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nu kansabêt ubat ta karapatan Juan ya mamawtismu, kan Bapan Namalyari o sa tawu?” ");
INSERT INTO blx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kabay nisasabi sila, “Nu sabin tamuy ‘kan Bapan Namalyari’, sabin nay naman êt kantamuy, ‘Uysiyan a kaw yabay maniwala kan Juan ta?’ ");
INSERT INTO blx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nuwa nu sabin tamuy ‘sa tawu’, batwan kitamun mani tawu, gawan maniwala silan propetan Bapan Namalyari si Juan.” ");
INSERT INTO blx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kabay nakitbay sila, “A yan tanda.” ");
INSERT INTO blx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sinabin Jesus kalla, “Nu parabaydu, a ku êt sabin kamuyu nu sisabêt ta nam-i kangkun karapatan manyag ati.” ");
INSERT INTO blx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Amêsên, ingkuwentuy na êt Jesus ya paalimbawa sa mani tawu, “Dilag gisay tawuy nananêm ubas sa panggitnan na. Amêsên, impasamak nay ubasan na sa mani makisamak ta naku ya sa marayuy lugal. Buy nanugêl ya baydun mabuyut ta panawun. ");
INSERT INTO blx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sên panawun nan pamupul, in-utus nay gisay ipus na sa mani kasamak na amên kêwên na dakay na. Nuwa ya ipus ya in-utus na, dinugêdugên kasamak buy impatas layan ayin gintan. ");
INSERT INTO blx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kabay niutus yan manguman kaatag ipus, nuwa dinugêdugê laya êt buy impakadêng-êy bayu impatas layan ayin gintan. ");
INSERT INTO blx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Niutus yan ikatluy ipus, nuwa sinugatsugat laya êt buy impatas. ");
INSERT INTO blx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kabay nangisip pa magbandin ubasan, ‘Sabêt ta daygên ku? Tanda kina. Iutus kuy kakaidwan kun anak. Dat galangên laya.’ ” ");
INSERT INTO blx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Nuwa sên nakitan mani kasamak ya anak magbandi, nisasabi sila, ‘Ah! Ati yay tagapagmana! Patin tamu ya amên mapagbandi tamuy mapagmana na.’ ");
INSERT INTO blx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kabay dinakêp layan ginuluy sa lawasan ubasan buy pinati.” Amêsên, pinatang Jesus ya mani mallêngê, “Sabêt amêsên na daygên magbandin ubasan sa mani kasamak na? ");
INSERT INTO blx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pilmin lakwên na sila buy patin. Pamakayari, ipasamak na tana sa kaatag ya ubasan na.” Sên nalêngên mani tawuy abiin, sinabi la, “Agana ta dayi tulutan Bapan Namalyarin malyari ya abiin!” ");
INSERT INTO blx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nuwa pinakaêlêw Jesus ya mani tawu buy sinabi na kalla, “Sabêt ta labay sabin ati ya nakasulat sa Kasulatan Bapan Namalyari? ‘Ya batuy insakwil mani mamipaydêng bali, sabay ya batuy nagin pundasyun.’ ” ");
INSERT INTO blx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sinabi pun êt Jesus, “Sisabêt man na manabu sa batun abiin, mangatutunglu. Nuwa ya manabwanan abiin, mangayayapung.” ");
INSERT INTO blx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Napukatan mani manurun Kautusan buy mani mamunun pari ya sabay silay pantukuyun Jesus sa paalimbawa na. Kabay dakpên layna dayi si Jesus sa uras abitu, nuwa nalimu sila sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kabay nangêtêng sila tan kaatag panawun. Namiutus silan mani tawuy magtatalingkayun mangêd da pandaygên la sa pamaku la kan Jesus. Pakan labay layan dakpên sa pagsabi na buy amên maipadakêp sa gobernador. ");
INSERT INTO blx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sinabin mani magtatalingkayu kan Jesus, “Manuru, tanda yan na pêtêg ga mani pansabin mu buy pan-ituru mu. Ayin kan pampilinin, nun a kay kapêtêgan tungkul sa kalabayan Bapan Namalyari ya pan-ituru mu. ");
INSERT INTO blx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Amêsên, dilag kay ipatang kamu. Sêpat kitamu nayin mamayad buwis sa Emperador Roma o asê?” ");
INSERT INTO blx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nuwa tandan Jesus ya kay magtatalingkayu sila. Kabay sinabi na kalla, ");
INSERT INTO blx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipakit yu kangkuy pera. Kansabêt lupa buy lagyuy makit yu di?” Nakitbay sila, “Sa Emperador.” ");
INSERT INTO blx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kabay sinabin Jesus, “Nu parabaydu, idin yu sa Emperador ya para sa Emperador buy idin yu kan Bapan Namalyari ya para kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kabay a la nadakêp si Jesus sa pagsabi na sa arapan malakêy tawu buy ayin silan nasabi gawan nakaupapas sila sa pikitbay na. ");
INSERT INTO blx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amêsên, dilag dakun umnuy Saduseoy nagdani kan Jesus amên patangên ya. Ya mani Saduseo, a sila maniwalan manguman mabyay ya mani nangamamati. ");
INSERT INTO blx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Amêsên, sinabi la kan Jesus, “Manuru, ayun sa Kautusan na impasulat kan Moises, nu ya gisay liyaki, nati yan ayin anak sa asawa na, sêpat pag-asawan patêl nay liyaki ya bayaw nay nabal-u amên makaanak sila para sa patêl nay nati. ");
INSERT INTO blx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Amêsên, dilag pituy mipapatêl la lawyaki. Nakapag-asaway panganay, nuwa nati yan ayin anak. ");
INSERT INTO blx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kabay ya ikalway panganay, napag-asawa nay nabal-u, nuwa nati ya êt ayin anak. ");
INSERT INTO blx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Para êt bayduy nalyari sa ikatlu angga sa ikapituy patêl la. Namatyan lan kaganawan ayin anak sa babayi. ");
INSERT INTO blx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Sa katatawliyan, nati êt ta bal-u. ");
INSERT INTO blx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Amêsên, sa allun pangabyay manguman nangamamati, sisabêt ta asawan abituy babayi, gawan napag-asawa yan pituy mipapatêl?” ");
INSERT INTO blx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nakitbay si Jesus, “Ya mani tawu sa panawun ati, mag-asawa sila. ");
INSERT INTO blx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nuwa ya mani pinilin Bapan Namalyari ya pabyayên nan manguman buy miawyun sa pag-arian na, a silayna mag-asawa. ");
INSERT INTO blx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Buy a sila mati ta kaparisu silan mani ang-el. Anak silaynan Bapan Namalyari, gawan pinabyay na silan manguman. ");
INSERT INTO blx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Agyan si Moises, nagpapêtêg yan pabyayên manguman Bapan Namalyari ya nangamamati. Tagawan insulat Moises ya tungkul sa magdêkêtdêkêt ta puun kayu nu saantu nan binêg Panginuun, ‘Bapan Namalyarin Abraham, Isaac, buy Jacob.’ ");
INSERT INTO blx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ya labay sabin, nabyay sila, tagawan alwa yan Bapan Namalyarin nangamamati, nun a Bapan Namalyari yan nangabyay. Ta ya kaganawan tawu, nabyay sa pangêlêw na.” ");
INSERT INTO blx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Amêsên, sinabin umnuy mani manurun Kautusan, “Manuru, mangêd da pikitbay mu!” ");
INSERT INTO blx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kabay ayin nan nakadêgdêg mamatang kana. ");
INSERT INTO blx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Amêsên, namatang êt si Jesus kalla, “Parasaantun masabin mani tawuy si Cristuy impangakun Bapan Namalyari, kay layi yan Arin David? ");
INSERT INTO blx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pakan insulat yan Arin David sa librun mani Kanta ya tungkul kan Cristuy, ‘Sinabin Bapan Namalyari sa Panginuun ku, miknu ka sa wanan ku, ");
INSERT INTO blx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","angga sa mapasuku ku kamuy mani kapati mu.’ ” ");
INSERT INTO blx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sinabi pun êt Jesus, “Amêsên, nu binêg Arin David Panginuun ya Cristu, parasaantun masabin mani tawuy si Cristuy kay layi yan Arin David?” ");
INSERT INTO blx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kaban mallêngê kan Jesus ya kaganawan tawu, sinabi na sa mani tagasunul na, ");
INSERT INTO blx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mangillag kaw sa mani manurun Kautusan. Labaylabay lan mamitan nakayaming makarang buy labaylabay lan galangên silan mani tawuy malibasan la. Labaylabay lan miknu sa iknuwan na in-il-an para sa maulagay tawu sa mani balin pagtipunan mani Judio buy sa mani kalutu. ");
INSERT INTO blx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pampurayitin la êt ta mani nabal-uy babayi amên makwa lay mani pibandiyan la buy magmamangêdan sila sa arapan mani tawu sa kapamilatan makarang nga panalangin la. Kabay lanu, luyang pun nabyat ta pamarusan Bapan Namalyari kalla.” ");
INSERT INTO blx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kaban idi pun si Jesus buy mani tagasunul na sa kasawangan Templu, nakit nay mani mabandi ya mam-in pera la sa pamyanan pera para sa Templu. ");
INSERT INTO blx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Buy nakitan na êt ta gisay kaluluy babayi ya bal-uy nam-in luluway pirasun barya sa pamyanan pera. ");
INSERT INTO blx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kabay sinabin Jesus sa mani tagasunul na, “Pansabin ku kamuyuy igit pun maulagay indin nabal-u kaysa indin kaganawan. ");
INSERT INTO blx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tagawan na indin mani mabandi, kay abituy a layna kaylangan. Nuwa ya bal-u, agyan kay kalulu ya, inlapas na pun indin ya panaliw nan kanên na.” ");
INSERT INTO blx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Amêsên, dilag dakun umnuy tagasunul Jesus ya misasabi tungkul sa mangangêd da batu buy sa pampakangêd da pan-idin sa Templu. Sên nalêngên Jesus ya pisasabyan la, sinabi na kalla, ");
INSERT INTO blx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ya mani mangêd da nakitan yu, lumatêng nga alluy malasak ka kaganawan abiin buy ayin batuy mitagan na nakapaluntu sa kaparisu nan batu.” ");
INSERT INTO blx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Amêsên, namatang nga mani tagasunul na, “Manuru, makanu malyari ya abiin buy sabêt ta tanda' ya marani yan malyari ya abitu?” ");
INSERT INTO blx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kabay nakitbay si Jesus, “Mangillag kaw amên a kaw mailitêp agyan sisabêt man. Tagawan malakêy lumatêng nga manggamit lagyu ku buy sabin lay, ‘Sikuy Cristuy impangakun Bapan Namalyari.’ Sabin la êt, ‘Inlumatêng ngay katganan babun luta!’ Agana kaw makipapaniwala kalla. ");
INSERT INTO blx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Buy nu dilag kaw mabalitan na migegera buy milalaban, agana kaw malimu. Ta sêpat malyari ya abiin, nuwa asê pun tambêng lumatêng nga katganan babun luta.” ");
INSERT INTO blx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Amêsên sinabi pun êt Jesus kalla, “Migegeray mani bansa buy migegera êt ya mani kaarian la. ");
INSERT INTO blx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dilag lumatêng nga masikan na layun buy lumatêng êt ta sadyay layang buy sakit ta ikamati sa magmikakanayun na lugal. Buy makakit kaw mani tanda' ya mamakapalimu buy mamakaupapas ya ubat sa langit.” ");
INSERT INTO blx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nuwa bayu malyari ya kaganawan abiin, dakpên buy pasakitan kaw mani tawu gawan sa panunul yu kangku. Buy iarap lakaw sa mani balin pagtipunan mani Judio amên litisin buy ipasukul. Iarap lakaw êt sa mani ari buy sa mani gobernador. ");
INSERT INTO blx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Abiin nay panawun yu amên makapagpapêtêg kaw kalla tungkul kangku. ");
INSERT INTO blx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kabay itanêm yu sa isip yuy agana kaw napitik nu sabêt ta sabin yu bilang pamitanggul yu sa sarili yu, ");
INSERT INTO blx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tagawan ipaisip ku kamuyuy sêpat yun sabin buy biyan kataw kabiyasnan ya asê agyun labanên o sambutun kapati yu. ");
INSERT INTO blx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ta agyan ya mani mangatwa buy mani patêl yu, mani kamag-anak yu buy mani kaluguran yu, igawang lakaw buy ipapati lay dakun umnu kamuyu. ");
INSERT INTO blx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Gawan sa panunul yu kangku, kasulapwan kaw kaganawan tawu. ");
INSERT INTO blx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nuwa a kaw paulayan Bapan Namalyari, ta agyan gisay sabut sa ulu yu, asê mitas. ");
INSERT INTO blx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Buy nu mibabata kaw, mabiyan kaw biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sinabin pun Jesus, “Nu makit yuy nakapalitêng nga mani sundalus sa Jerusalem, tanda yinay marani yay panira kana. ");
INSERT INTO blx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kabay ya kaganawan idi sa Judea, kaylangan tumakas san maku sa kabubung-uyan buy ya kaganawan idi sa balayan Jerusalem, kaylangan tambêng ngan mita. Buy ya kaganawan idi sa panggitnan, aganay na pun mag-udung sa balayan Jerusalem. ");
INSERT INTO blx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tagawan abituy panawun pamarusa amên matupad ya mani idi sa Kasulatan. ");
INSERT INTO blx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mamakapalunus ya mani nabuktut buy mani mamasusu sa allun abiin, tagawan magkasakit silan tumakas. Nabyat ta kasakitan na madanasan mani tawu sa lutan ati, ta katubagan sila. ");
INSERT INTO blx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ya kaatag kallay patin sa kêya buy ya kaatag, dakpên ta ipusun sa marayuy lugal. Buy ya balayan Jerusalem, sakupun mani alwan Judio angga sa mayari ya panawun na intakdan Bapan Namalyari kalla.” ");
INSERT INTO blx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Sinabi pun êt Jesus, “Makakit kaw tanda' sa allu, sa buwan, buy sa mani bêtêwên. Buy ya kaganawan bansa baydi sa babun luta, magulu ta malimu sila sa tarit alun sa dagat. ");
INSERT INTO blx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mabtêk ya mani tawu sa sadyay limu la gawan sa mani malyari sa babun luta, tagawan maubus maêyêg ga mani bagay ya idi sa langit buy mitas sila sa binyanan la. ");
INSERT INTO blx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sa panawun abiin, sikuy ubat sa langit ta in-Anak Tawu, makitan lakun lumatêng nga idi sa ulap ya dilag kapangyarian buy mamakapasilêw wa sawang. ");
INSERT INTO blx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu mag-umpisay nan malyari ya mani abiin, midêng kaw mangêlêw sa langit ta marani yay pamiligtas kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ingkuwentun Jesus kallay gisay paalimbawa. Sinabi na, “Elêwên yuy puun kayun igus buy ya kaatag puun kayu. ");
INSERT INTO blx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nu magbulung ngay mani ati, tanda yinay marani yay kaynitan. ");
INSERT INTO blx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Para êt bayduy malyari lanu. Nu makitan yinan malyari yay mani pansabin ku, matandan yuy marani yanay pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Pansabin ku kamuyuy bayu mati ya kaganawan tawu sa panawun amêsên, matupad day kaganawan sinabi ku. ");
INSERT INTO blx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ya langit buy luta, dilag katganan. Nuwa ya mani sabi ku, manugêl kanuman.” ");
INSERT INTO blx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Sinabi pun êt Jesus, “Mangillag kaw. Agana kaw magpagtan sa kasimbawan, paglasing, buy kapigaganakan sa biyay amên a kaw malatngan ya asê nakal-an sa allun pallumatêng kun manguman. ");
INSERT INTO blx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gawan bêngat tan lumatêng nga allun abitu sa kaganawan tawu sa babun luta un ayin magtanda. ");
INSERT INTO blx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kabay magpakal-an kaw sa kaganawan uras. Pawa kaw manalangin ya biyan nakaw kapas-êyan amên malampusan yuy kaganawan kasakitan ya malyari sa lumatêng nga allu amên makapakiarap kaw kangkuy ubat sa langit ta in-Anak Tawu.” ");
INSERT INTO blx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Allu-allu manuru si Jesus sa kasawangan Templu. Pamakayabi, mamaku ya sa Bung-uy mani Ulibu amên mamawatwat yabi. ");
INSERT INTO blx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Maranun mamakuy mani tawu sa kasawangan Templu amên mallêngê kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Amêsên, marani yanay Pestan Tinapay ya ayin Pamalbag ya sabay ya Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ya mani mamunun pari buy mani manurun Kautusan, mangisip silan paralan nu parasaantu lan maipapati si Jesus un ayin makatanda, gawan malimu sila sa mani tawuy mallêngê kana. ");
INSERT INTO blx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Si Judas ya pambêgên Iscariote, gisa ya sa mapu buy luway tagasunul Jesus. Nuwa sinakup yan Satanas. ");
INSERT INTO blx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kabay amêsên, naku si Judas sa mani mamunun pari buy sa mani puun magbantay sa Templu. Buy pisasabyan la nu parasaantu nan maisupakat si Jesus kalla. ");
INSERT INTO blx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ingkatula la êt ta pamikisupakat Judas kalla laban kan Jesus. Buy nangaku silan biyan layan pera. ");
INSERT INTO blx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nalabay êt taman si Judas. Kabay ubat ta baydu, nangêtêng nginan panawun na masawpan na silan mandakêp kan Jesus ya asê matandan malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Amêsên, inlumatêng ngay nunan allun Pestan Tinapay ya ayin Pamalbag. Sa allun abitu, ya mani Judio, kaylangan lan mamatin anak tupa ya kêna la sa Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kabay in-utus Jesus si Pedro buy si Juan. Sinabi na, “Mita kawna, ta il-an yuy apunan tamu para sa Pestan Kaligtasan.” ");
INSERT INTO blx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kabay namatang si Pedro buy si Juan, “Antuy labay mun pamil-anan yan apunan tamu?” ");
INSERT INTO blx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nakitbay si Jesus, “Pamakasun yu sa balayan Jerusalem, matbêng yuy gisay liyaki ya mantan bangay naglanêm. Pakilakwan yuya sa bali ya sunan na. ");
INSERT INTO blx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Buy sabin yu sa magbali, ‘Pan-ipatang Manuru nu saantuy kuwartuy pamil-anan apunan para sa Pestan Kaligtasan kaawyun nay mani tagasunul na.’ ");
INSERT INTO blx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pakilaku nakaw sa babu buy ituru na kamuyuy gisay makwal la kuwartu. Idi ya bayduy kaganawan magamit. Baydu yun il-an na apunan tamu.” ");
INSERT INTO blx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Amêsên, namitay na si Pedro buy si Juan buy nakitan lay pêtêg ga kaganawan sinabin Jesus kalla. Kabay in-il-an la bayduy apunan la para sa Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sên uras san apunan, niknuy na si Jesus sa arapan lamesa kaawyun mani apostul na. ");
INSERT INTO blx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sinabin Jesus kalla, “Labay kuy bayu ku madanasan na pamasakit, makaêm kataw pun sa apunan sa Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gawan pansabin ku kamuyuy a kina manguman mangan ati angga sa matupad da labay sabin ati sa pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Amêsên, kingwa nay panginêman na dilag alak ka diyag sa sabên ubas, ta nagpasalamat ya kan Bapan Namalyari buy sinabi na kalla, “Kêwên yuy ati buy piiinêman. ");
INSERT INTO blx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pansabin ku kamuyuy a kina manguman minêm alak ka diyag sa sabên ubas anggan asê pun lumatêng nga pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Amêsên, nangwa yan tinapay buy impasalamat na kan Bapan Namalyari. Binis-ilbis-il nay ati buy inggawang na kalla. Sinabi na, “Ati ya lawini kuy pan-idin ku para kamuyu. Daygên yuy ati bilang pangganaka yu kangku.” ");
INSERT INTO blx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pamakayari lan nangan, para êt bayduy dinyag na sa pan-inêmên. Kingwa nay ati buy sinabi na, “Ya pan-inêmên na ati, sabay ya bayuy kasunduwan ya pinagpapêtgan daya ku ya mibulug para kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sinabin Jesus, “Nuwa lêng-ên yuy ati! Kaêm tamu amêsên na tawuy mamisupakat kangku. ");
INSERT INTO blx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta sikuy ubat sa langit ta in-Anak Tawu, patin naku, gawan abituy intalagan Bapan Namalyari kangku. Nuwa taganan mamakapalunus ya tawuy mamisupakat kangku.” ");
INSERT INTO blx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Amêsên, nipapatang nga mapu buy luway apostul na nu sisabêt kallay manyag parabaydu. ");
INSERT INTO blx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nisusubakan na mani apostul Jesus nu sisabêt kallay pinakadakila. ");
INSERT INTO blx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kabay sinabin Jesus kalla, “Asê ustuy isip yu. Pan-ipilit mani alwan Judioy labay la sa mani pansakupun la buy labay lay sunulun buy bêgên silan ‘Mapanawup’. ");
INSERT INTO blx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nuwa alwan parabaysên kamuyu. Ta ya pinakamatag-ay, sêpat yan magpakayêpa buy ya mamunu, sêpat yan magin kaparisun gisay ipus. ");
INSERT INTO blx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tagawan sisabêt dayi ya igit pun matag-ay, ya tawuy nakaiknun mangan o ya tawuy magsuyu kana? Alwa nayin sabay ya tawuy nakaiknun mangan? Nuwa sikuy magsuyu kamuyu agyan sikuy mamunu yu.” ");
INSERT INTO blx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Sa mani panubuk ka dinanasan ku, a yuku inlakwanan. ");
INSERT INTO blx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kabay gawan binyanan nakun kapangyarian Bapa kun mag-ari, biyan kataw êt parabayduy kapangyarian. ");
INSERT INTO blx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Daygên kuy abiin amên makaêm kataw mangan buy minêm sa lamesa ku baydu sa pag-arian ku. Buy miknu kaw sa mapu buy luway turonu amên mangukum sa mapu buy luway layin Israel.” ");
INSERT INTO blx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sinabin Jesus kan Simon ya pambêgên lan Pedro, “Pakalêng-ên muy ati ya Simon! Nakisabi si Satanas kan Bapan Namalyari amên subukun nakaw kaganawan kaparisun pamibalusbus trigu. ");
INSERT INTO blx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nuwa manalangin naku para kamu amên asê mangaynay panampalataya mu kangku. Buy nu magsisi ka buy mag-udung kayna kangku, pas-êyên muy panampalatayan mapatêl mu.” ");
INSERT INTO blx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nakitbay si Pedro, “Panginuun, nakal-an nakun isukul o mati kaawyun mu.” ");
INSERT INTO blx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nuwa sinabin Jesus kana, “Pedro, pansabin ku kamuy bayu mangkati ya manuk amêsên yabi, katitlu mukun ipuglaw.” ");
INSERT INTO blx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Amêsên, sinabin Jesus sa mani tagasunul na, “Sabitun in-utus kataw un ayin gintan ya susut, bag, o isteping, nagkulang kaw nayi?” Nakitbay sila, “Asê.” ");
INSERT INTO blx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Nuwa amêsên,” sinabin Jesus, “nu dilag kaw susut o bag, gêtan yu. Buy nu ayin kaw kêya, isaliw yuy yaming yu buy manaliw kaw kêya. ");
INSERT INTO blx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tagawan pansabin ku kamuyuy kaylangan matupad ya idi sa Kasulatan tungkul kangku, ya paradi, ‘Pan-ibilang layan gisa sa mani makasalanan.’ Buy abiin na nakasulat tungkul kangku, matupad da amêsên.” ");
INSERT INTO blx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kabay sinabin mani tagasunul na, “Panginuun, dilag kay luway kêya baydi!” Nakitbay ya, “Ustuy nay abiin.” ");
INSERT INTO blx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Amêsên, naku si Jesus sa Bung-uy mani Ulibu, kaparisun mana nan pandaygên. Buy nakilaku kanay mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sên idi silayna baydu, sinabin Jesus kalla, “Pawa kaw manalangin amên a kaw masambut tuksu.” ");
INSERT INTO blx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Amêsên, nagpakarayun pêrad si Jesus kalla buy nanduku yan nanalangin. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bapa ku, nu kalabayan mu, itas muy pamasakit ta madanasan ku. Nuwa paraman baydu, alwan kalabayan kuy masunul, nun a ya kalabayan mu.” ");
INSERT INTO blx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Amêsên, nagpakit kanay ang-el ya ubat sa langit buy pinapas-êy nay nakêm Jesus. ");
INSERT INTO blx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sa sadyay lungkut matanam Jesus, nanalangin yan buun nakêm angga sa sinayngêtan yan paran dayay nantulu sa luta. ");
INSERT INTO blx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pamakayari nan nanalangin, nidêng ya buy inudung nay mani tagasunul na buy nalatêng na silan mamabêlêw, gawan napagal sila sa sadyay lungkut. ");
INSERT INTO blx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kabay sinabi na kalla, “Alwa ta, siyan mamabêlêw kaw yata? Mimata kaw buy manalangin amên a kaw masambut tuksu.” ");
INSERT INTO blx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kaban magsabi pun si Jesus, inlumatêng nga malakêy tawu. Si Judas ya gisa sa mapu buy luway tagasunul nay manguna kalla. Dinanyan na si Jesus buy dinêp sa pingi. ");
INSERT INTO blx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nuwa sinabin Jesus kana, “Dêp nayi ya pamisupakat mu kangkuy in-Anak Tawuy ubat sa langit?” ");
INSERT INTO blx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sên nakitan mani tagasunul Jesus ya mani nalyari, sinabi la, “Panginuun, tabtabên yana nayi sila?” ");
INSERT INTO blx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Amêsên, tinabtab un gisa sa mani tagasunul Jesus ya wanan têk ipus pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nuwa sinabin Jesus, “Ustuy nay abiin!” Dinukpan nay têk ipus buy pinaiyul na. ");
INSERT INTO blx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sinabin Jesus sa mani mamunun pari, sa mani kapitan mani magbantay sa Templu buy sa mani mangatway manungkulan, “Tulisan naku nayi? Uysiyan mantan kaw yan mani kêya buy pamatuk amên dakpên naku ta? ");
INSERT INTO blx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Inallu-allu wakun idi baysên kamuyu sa Templu. Uysiyan a yuku yata dinakêp ta? Nuwa ati ya panawun ya indin kamuyu amên dakpên naku. Ta sa uras ati, kapangyarian Satanas ya mag-ari kamuyu.” ");
INSERT INTO blx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dinakêp la si Jesus buy gintan sa balin pinakapuun pari. Nanunul êt si Pedro, nuwa kay idi ya sa marayun pêrad. ");
INSERT INTO blx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baydu sa kasawangan bali, nagpaybay mani tawu buy niknu sila sa agid atug amên mimudu. Buy nakiiknu êt si Pedro baydu kalla amên mimudu. ");
INSERT INTO blx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Amêsên, dilag gisay ipus ya babayi ya nakakit kan Pedro ya nakaiknun mamimudu sa danin atug. Kabay pinakaêlêw naya buy sinabi na, “Pagkaawyun êt Jesus ya liyakin atiyê.” ");
INSERT INTO blx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nuwa impuglaw yan Pedro, “Te! A kuya kakilala.” ");
INSERT INTO blx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A naêpêng, dilag êt nakakit kana buy sinabi, “Alwa nayin pagkaawyun laka êt?” Nakitbay si Pedro, “Te! Asê.” ");
INSERT INTO blx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pamakayari bay-in gisay uras, impilit êt gisay, “Pêtêg êt pagkaawyun yan Jesus ya tawun ati, tagawan taga Galilea ya êt.” ");
INSERT INTO blx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nuwa sinabin Pedroy, “Te! A ku tanday pansabin mu!” Buy kaban magsabi ya, nangkati ya manuk. ");
INSERT INTO blx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nangawing si Jesus buy pinakaêlêw na si Pedro. Kabay naisip Pedroy sinabin Jesus kana, “Bayu mangkati ya manuk amêsên yabi, katitlu mukun ipuglaw.” ");
INSERT INTO blx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kabay nagsalwang si Pedro buy sadyay tangis na. ");
INSERT INTO blx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pinustak buy dinugêdugê yan mani magbantay kana. ");
INSERT INTO blx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tinakpan la êt ta mata na buy sinabi la kanay, “Ulên mu nu sisabêt ta nandugê kamu?” ");
INSERT INTO blx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Buy malakê pun êt ta nadawak ka sinabi la laban kana. ");
INSERT INTO blx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pamakamaranun, nititipun na mani mangatwan Judioy mangatuynungan. Dilag mani mamunun pari buy mani manurun Kautusan. Amêsên, gintan si Jesus ta in-arap kalla. ");
INSERT INTO blx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Sinabi la kana, “Sabin mu kanyan nu sikay Cristuy impangakun Bapan Namalyari.” Nakitbay si Jesus, “Agyan sabin ku kamuyu, a yuku paniwalan. ");
INSERT INTO blx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Buy nu patangên kataw, a yu êt pakitbayan. ");
INSERT INTO blx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nuwa paubat amêsên, sikuy ubat sa langit ta in-Anak Tawu, miknu wakina sa wanan Bapan Namalyari ya Makapangyarian.” ");
INSERT INTO blx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kabay sinabin kaganawan, “Nu parabaydu awêd, pansabin mu nayi ya sika ya Anak Bapan Namalyari?” Nakitbay si Jesus, “Sikaw way nagsabi ya sikina.” ");
INSERT INTO blx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kabay sinabi la, “A tamina kaylangan na dilag kaatag magpapêtêg, ta nalêngê taminay pagsabi na.” ");
INSERT INTO blx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","“Pamakayarin abitu, nidêng silan kaganawan buy in-arap la si Jesus kan Gobernador Pilato. ");
INSERT INTO blx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kabay inumpisan lay panangkan la kan Jesus. Sinabi la kan Gobernador Pilato, ‘Nadakêp yan na tawun ati ya managyat mani tawun lumaban sa gubernu. Pansabin nay agana silayna mamayad buwis sa Emperador Roma. Pansabin na pun na siyay ari ya Cristuy impangakun Bapan Namalyari.’ ” ");
INSERT INTO blx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kabay pinatang Gobernador Pilato si Jesus, “Sika nayi ya Arin mani Judio?” Nakitbay si Jesus, “Sikay nay nagsabi.” ");
INSERT INTO blx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kabay sinabin Gobernador Pilato sa mani mamunun pari buy sa mani tawu, “Ayin nakun makit ta kasalanan sa tawun ati.” ");
INSERT INTO blx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nuwa impilit lan sinabi, “Ya tawun abiin, panggulun nay mani tawu sa buun prubinsyan Judea sa kapamilatan panuru na. Nag-umpisa yan nanuru sa prubinsyan Galilea. Buy amêsên, idi yina êt baydi sa Jerusalem.” ");
INSERT INTO blx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sên nalêngên Pilatoy sinabi la, pinatang na nu taga Galilea si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Si Herodes Antipas ya gobernador sa prubinsyan Galilea buy sa panawun abitu, idi ya êt sa Jerusalem. Kabay sên natandan Pilatoy taga Galilea si Jesus, sinabi na, “Gêtan yuya kan Gobernador Herodes Antipas.” ");
INSERT INTO blx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sên nakitan Gobernador Herodes Antipas si Jesus, sadyay tula na, ta mana naynan labay makitan si Jesus gawan malakêy mangalêngê na tungkul kana. Buy labay na êt makitan na mamakaupapas sa diyag na. ");
INSERT INTO blx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kabay malakêy impatang Gobernador Herodes Antipas kan Jesus, nuwa a ya nakitbay. ");
INSERT INTO blx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ya mani mamunun pari buy mani manurun Kautusan, nidêng sila buy masnêg lan pansabin na panangkan la laban kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Amêsên, si Gobernador Herodes Antipas buy mani sundalus na, pinustak buy inuyam la si Jesus. Pinayamingan laya pun êt mangêd da yaming kaparisun yaming ari buy in-udung laya kan Gobernador Pilato. ");
INSERT INTO blx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Si Gobernador Herodes Antipas buy si Gobernador Pilato, nisuluk sila sabitun nuna, nuwa paubat sa allun abiin, mikaluguran silayna. ");
INSERT INTO blx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Impabêg Pilatoy mani mamunun pari, ya kaatag manungkulan buy ya malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Buy sinabi na kalla, “Gintan yu kangkuy tawun ati gawan pansabin yuy sabay siyay pangubatan kagulwan. Pinakapatang kuya sa malêngê yu, nuwa ayin nakun nakit ta kasalanan sa pan-isangkan yu kana. ");
INSERT INTO blx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Agyan si Gobernador Herodes Antipas, parabaydu êt ta napagpapêtgan na. Kabay impaudung na si Jesus baydi kantamu. Ya tawun ati, ayin yan nadyag ga kasalanan amên parusan yan kamatyan. ");
INSERT INTO blx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kabay ipabarug kuya tana bayu kuya ipabus.” ");
INSERT INTO blx_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Balang Pestan Kaligtasan, kaylangan mamibus si Pilaton gisay nakasukul. ");
INSERT INTO blx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nuwa malakêy tawuy masnêg nagsabin, “Patin na tawun abiin! Si Barabbas saman na ibus mu!” ");
INSERT INTO blx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nasukul si Barabbas gawan sa pamati nan tawu buy kaawyun ya sa mani nagribeldi sa gubernu sa Jerusalem sabitun nuna.) ");
INSERT INTO blx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Labay dayin Pilatoy ipabus na si Jesus. Kabay nagsabi yan nanguman ya ipabus si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nuwa masnêg sinabin mani tawuy, “Ipaku ya sa kurus! Ipaku ya sa kurus!” ");
INSERT INTO blx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Katitlun nagsabi si Gobernador Pilato. Sinabi na, “Awta? Sabêt ta kasalanan na? Ayin nakun makit ta kasalanan kana amên ipapati ya. Kabay ipabarug kuya tana bayu kuya ipabus!” ");
INSERT INTO blx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nuwa luyang lan masnêg sinabi, “Ipaku ya sa kurus!” Kabay ayin nan madyag si Gobernador Pilato ");
INSERT INTO blx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","buy sinunul na tay kalabayan mani tawuy ipaku si Jesus sa kurus. ");
INSERT INTO blx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Imbus na si Barabbas ya nakasukul gawan sa pamatin tawu buy sa pamikipati sa gubernu. Nuwa inggawang Gobernador Pilato si Jesus kalla amên daygên lay labay la kana. ");
INSERT INTO blx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Amêsên, gintan mani sundalus si Jesus sa lawasan balayan. Buy sên idi sila pun sa dan, natbêng lay gisay liyaki ya maglagyun Simon ya taga Cirene ya ubat sa panggitnan. Impilit lan impabakay kan Simon ya kurus Jesus buy pinasunul laya kana. ");
INSERT INTO blx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Malakêy mani tawuy nakilaku kan Jesus. Malakêy babayi ya manangis buy manyubêk gawan sa kalungkutan la sa nalyari kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nangawing si Jesus buy sinabi na kalla, “Sikaw wa mani babayi sa Jerusalem, agana yuku tangisan ta ya tangisan yinaman, ya sarili yu buy maanak yu. ");
INSERT INTO blx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta lumatêng nga alluy sabin mani tawuy, ‘Pinagpalay babayi ya layus buy ya asê namasusu.’ ");
INSERT INTO blx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa panawun abitu, sabin la sa mani bung-uy buy sa mani tung-uy, ‘Tugpawan yukay!’ ");
INSERT INTO blx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tagawan nu paradi ya pandaygên sa kayuy nailê, sabêt kayay malyari sa kayuy nayangu?” ");
INSERT INTO blx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Amêsên, dilag pun luway tulisan ya gintan amên patin kaawyun Jesus. ");
INSERT INTO blx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sên nilatêng sila sa lugal la pambêgên lan “Bungu”, impaku la si Jesus kaawyun na mani kriminal. Ya gisa, idi sa wanan Jesus, buy ya gisa, idi sa udi na. ");
INSERT INTO blx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Amêsên, sinabin Jesus, “Bapay patawarên mu sila tagawan a la tanday pandaygên la.” Pinibabagutan mani sundalus ya yaming Jesus. ");
INSERT INTO blx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kaban malakêy tawuy idi bayduy manalbay, pan-uyamên si Jesus un mamunu sa Templu. Sinabi la, “Inligtas nay kaatag. Nu siyay Cristuy impangakuy pinilin Bapan Namalyari, iligtas nay sarili na!” ");
INSERT INTO blx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Inuyam ya êt mani sundalus si Jesus buy paynêmên laya dayin nangisuy alak. ");
INSERT INTO blx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Buy sinabi la pun kana, “Nu sika yabay ya Arin mani Judio, iligtas muy sarili mu!” ");
INSERT INTO blx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dilag karatula sa ugtun ulun Jesus buy paradi ya nakasulat, “Ati ya Arin mani Judio.” ");
INSERT INTO blx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Amêsên, ya gisay tulisan ya nakapaku sa kurus, inuyam na êt si Jesus. Sinabi na, “Alwa nayin sikay Cristuy impangakun Bapan Namalyari? Iligtas muy sarili mu, agyan sikay êt!” ");
INSERT INTO blx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nuwa imbawal yan kaawyun nay nakapaku, “Agana ka magsabin parabaysên kana! A ka nayi malimu kan Bapan Namalyari? Parisu kitamun pinarusan kamatyan. ");
INSERT INTO blx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Taganan sêpat kitan parusan kamatyan gawan sa dinyag tay kasalanan. Nuwa ya tawun ati, ayin yan dinyag ga kasalanan.” ");
INSERT INTO blx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Buy sinabi na pun kan Jesus, “Jesus, agana mukun kayêk litêpên nu mag-ari kayna.” ");
INSERT INTO blx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nakitbay si Jesus, “Pansabin ku kamuy, amêsên êt makaawyun muku sa Paraiso.” ");
INSERT INTO blx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sên marani yay ugtuy allu, dinumiglêm ma mamut sa lugal abitu anggay nan alas tres kaawat. ");
INSERT INTO blx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kaban nagdêm, bêngat tan naginit ta panabing sa lalên Templu. ");
INSERT INTO blx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Amêsên, masnêg sinabin Jesus, “Bapay pan-itiwala ku kamuy ispiritu ku!” Pamakayari nan sinabi ya abitu, nabuytuwan yan inawanên. ");
INSERT INTO blx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sên nakit kapitan mani sundalus ya nalyari, inulimên na si Bapan Namalyari. Sinabi na, “Pêtêg yabay awêd ayin kasalanan na tawun ati.” ");
INSERT INTO blx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ya mani tawuy naku baydu amên makit lay kaganawan nalyari, nulin pan-apuapun na pagaw la gawan sa sadyay lungkut la. ");
INSERT INTO blx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ya mani babayi ya nakilaku kan Jesus ubat sa prubinsyan Galilea buy kaatag pun na kakilalan Jesus, nakaidêng sila sa narayun pêrad. Nakit la êt ta kaganawan nalyari kana. ");
INSERT INTO blx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Dilag gisay liyaki ya maglagyun Jose ya taga balayan Arimatea sa prubinsyan Judea. Agyan kaawyun yan mani mangatwan Judioy mangatuynungan, a na kalabayan ya dinyag la kan Jesus. Mangêd yan tawu, matinêk buy kaawyun ya sa mani mangêtêng sa pag-arin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Amêsên, naku si Jose kan Gobernador Pilato ta inyawad nay bangkay Jesus. Nakalabay êt taman si Gobernador Pilato. ");
INSERT INTO blx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kabay kingwan Jose ya bangkay Jesus sa kurus buy binêdbêdan nan telay naputi. Pamakayari, insun nay ati sa pamilbêngan na inlubtan na dapas ya asê pun pinilbêngan. ");
INSERT INTO blx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bernis kaawat ya abitu buy sabay ya allun paglêan para sa Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ya mani babayi ya nakilaku kan Jesus ubat sa prubinsyan Galilea, nakilaku sila kan Jose. Nakit lay pinilbêngan kan Jesus buy nu parasaantun insun bayduy bangkay na. ");
INSERT INTO blx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Amêsên, ya mani babayi, nuli sila amên mil-an malakêy pabangi ya ipunu la sa bangkay Jesus. Buy sa Allun Pagpaynawa, nagpaynawa sila, gawan abituy idi sa Kautusan mani Judio. ");
INSERT INTO blx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pamakamaranun allun Duminggu, nakuy mani babayi sa pinilbêngan kan Jesus. Gintan lay mani pabangi ya in-il-an la. ");
INSERT INTO blx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pamakalatêng la baydu, nakit lay maragul la batuy pinanakêp sa pinilbêngan kan Jesus ya nibulid dana. ");
INSERT INTO blx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kabay sinumun sila, nuwa a la nakit ta bangkay Jesus. ");
INSERT INTO blx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kaban pan-isipin la nu sabêt ta nalyari, bêngat tan nagpakit kallay luway liyaki ya mamakapasilêw wa yaming nga nakaidêng sa dani la. ");
INSERT INTO blx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gawan sa limu la, nakadêngdêng sila sa luta. Pinatang silan luway liyaki, “Uysiyan pantêkapên yu yay nabyay sa pamilbêngan mani nati ta? ");
INSERT INTO blx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ayin nina baydi. Nanguman ninan nabyay. Isipin yuy sinabi na kamuyu sabitun idi yapun sa prubinsyan Galilea. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Sikuy ubat sa langit ta in-Anak Tawu, kaylangan nakun igawang sa gamêt mani makasalanan. Ipaku laku sa kurus, nuwa sa ikatluy allu, manguman nakun mabyay.’ ” ");
INSERT INTO blx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","10","Ya dakun umnuy babayi ya miaawyun naku sa pinilbêngan, si Maria ya taga Magdala, si Juana buy si Maria ya indun Santiago buy kaatag pun na kaawyun la. Naganakan mani babayin ati ya sinabin Jesus sabitun nuna. Kabay namita sila sa pinilbêngan buy nag-udung sa mapu buy gisay apostul Jesus. Buy imbalita lay nakit la. ");
INSERT INTO blx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nuwa indap mani apostul alwan pêtêg ga pansabin mani babayi, gawan paran kay diyagdiyag la. Kabay a sila pinaniwalan. ");
INSERT INTO blx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Paraman baydu, si Pedro, nuwayu yan naku sa pamilbêngan. Pamakalatêng na baydu, nanilip ya sa lalê. Nuwa ayin na bayduy bangkay Jesus. Ya kay idi ta baydu, abituy telay makamal la pinamêdbêd kana. Kabay nuli yan nakaupapas sa nalyari. ");
INSERT INTO blx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sa allu êt abitu, dilag luway tagasunul Jesus ya mamita papakun sa baryun Emaus ya dilag mapu buy gisay kilumetruy dayu sa balayan Jerusalem. ");
INSERT INTO blx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kaban mamita sila, pisasabyan lay kaganawan nalyari kan Jesus. ");
INSERT INTO blx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kaban misasabi sila, nagdani kalla si Jesus buy nakisunul sa pamita la. ");
INSERT INTO blx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nakitan laya, nuwa a la makilala si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pinatang silan Jesus, “Sabêt ta pisasabyan yu?” Tinunggên sila. Makit sa mata lay malungkut sila. ");
INSERT INTO blx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Gisa kalla si Cleopas ya nagsabi, “Gigisa mu ta lawês sa malakêy tawuy mamaku sa Jerusalem ya asê nakatanda sa nalyari baydu dakun nakanu?” ");
INSERT INTO blx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kabay pinatang silan Jesus, “Awta, sabêt ta nalyari?” Sinabi la êt taman, “Ya nalyari kan Jesus ya taga Nazaret. Gisa yan propetay makapangyarian sa arapan Bapan Namalyari buy sa mani tawu. Pinagpapêtgan nay ati sa kapamilatan mani makapangyarian na diyag buy mani makapangyarian na aral na. ");
INSERT INTO blx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Impadakêp yan mani mamunun pari buy mani manungkulan amên atulan yan ipaku sa kurus. ");
INSERT INTO blx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Man-umasa kay dayi kana ya siyay mamibus sa bansan Israel. Nuwa ikatluy allu nayna amêsên ubat sa pinati laya. ");
INSERT INTO blx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Nuwa nakatêgag kay sa imbalita kanyan dakun umnuy babayi ya kaawyun yan naku nangun maranun sa pinilbêngan kana. A la nakit ya bangkay Jesus, nuwa nakakit sila kanun ang-el Bapan Namalyari ya nagsabin nabyay nanguman si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Naku êt sa pinilbêngan kanay dakun umnu sa mani kaawyun yan na liyaki buy nakit la bayduy ayin nay bangkay kaparisun sinabin mani babayi.” ");
INSERT INTO blx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Amêsên, sinabin Jesus kalla, “Ayin kaw ya dayin tanda ta buy siyan masakit kaw ya êt maniwala sa kaganawan pansabin mani propeta! ");
INSERT INTO blx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Alwa nayin sinabi lay kaylangan madanasan Cristu ya pamasakit bayu ya parangalên Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Impaintindin Jesus kallay kaganawan tungkul kana ya nakasulat sa Kasulatan Bapan Namalyari, ubat sa mani impasulat kan Moises angga sa mani insulat mani propeta. ");
INSERT INTO blx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sên narani silayna sa baryun Emaus ya pallakwên la, isundu pun dayin Jesus ya pamita na. ");
INSERT INTO blx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nuwa binênbênan laya, “Minggat kayna pun di kanyan, ta nadêm mana.” Kabay nakilaku kalla si Jesus. ");
INSERT INTO blx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sên mangan silayna, kingwan Jesus ya tinapay buy impasalamat kan Bapan Namalyari. Binis-ilbis-il nay ati buy indin na kalla. ");
INSERT INTO blx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sa dinyag nan abitu, nakilala lay sabay siya awêd si Jesus. Nuwa bêngat yatan napanat sa pangêlêw la. ");
INSERT INTO blx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sinabin luwa, “Kabay awêd sadyay tula ta kaban pampakisabyan na kita sa dan buy pan-ipaintindi na kantay Kasulatan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sa uras êt abitu, nag-udung sila sa balayan Jerusalem. Pamakalatêng la baydu, nalatêng lay mapu buy gisay apostul Jesus ya nititipun kaawyun na kaatag ");
INSERT INTO blx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ya magsabi kallan luwa, “Pêtêg awêd da nanguman nabyay ya Panginuun, ta nagpakit ya kan Simon Pedro!” ");
INSERT INTO blx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Amêsên, insabi êt luway ubat sa Emaus ya nalyari kalla sa dan buy nu parasaantu layan nakilala si Jesus sên binis-ilbis-il nay tinapay. ");
INSERT INTO blx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kaban pisasabyan lay abiin, nagpakit si Jesus buy nidêng sa pibunakan la. Sinabi na, “Mapakamuyuy kapatêtbêkan.” ");
INSERT INTO blx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nuwa nakatêgag sila buy sadyay limu la, gawan indap la nakakit silan anitu. ");
INSERT INTO blx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kabay sinabin Jesus kalla, “Alwa ta siyan malimu kaw yata buy siyan magluway nakêm yu ta? ");
INSERT INTO blx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Elêwên yuy mani gamêt buy mani bitis ku. Sikuy ati! Talanên yuku buy êlêwên, alwa kun anitu. Ta ya anitu, ayin yan laman buy but-u, nuwa siku dilag.” ");
INSERT INTO blx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pamakasabi nan abiin, impakit nay mani gamêt buy bitis na kalla. ");
INSERT INTO blx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A sila pun êt maniwala gawan sa sadyay tula la buy nakaupapas sila. Kabay pinatang silan Jesus, “Dilag kaw nayin kanên?” ");
INSERT INTO blx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sinabi la, “Dilag!” Kabay binyanan layan gisay putus intêktêk ka kênan lanêm. ");
INSERT INTO blx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kingwa nay abiin, ta kinnan na sa arapan la. ");
INSERT INTO blx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pamakayari, sinabi na kalla, “Sinabi kina kamuyu sabitun miaawyun kitamu pun ya kaylangan matupad da kaganawan mani insulat tungkul kangku sa Kautusan na impasulat kan Moises, ya insulat mani propeta buy sa librun mani Kanta.” ");
INSERT INTO blx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kabay imbuklat Jesus ya isip la amên mapukatan lay nakasulat sa Kasulatan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Sinabi na kalla, “Ati ya nakasulat, ‘Ya Cristuy impangakun Bapan Namalyari, kaylangan yan mibabata sa pamasakit buy mati. Nuwa sa ikatluy allu, manguman yan mabyay.’ ");
INSERT INTO blx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nakasulat êt ta kaylangan iaral sa kaganawan bansa paubat sa balayan Jerusalem ya sa kapamilatan ku, patawarên Bapan Namalyari ya kaganawan magsisi sa mani kasalanan la.” ");
INSERT INTO blx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sinabi pun êt Jesus, “Sikaw wa makapagpapêtêg sa mani bagay ya ati. ");
INSERT INTO blx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iutus ku kamuyuy Ispiritun Bapan Namalyari ya impangakun Bapa ku. Kabay manugêl kaw pun sa Jerusalem anggan asê mapakamuyuy kapangyarian na ubat sa langit.” ");
INSERT INTO blx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Amêsên, pikilakun Jesus ya mani tagasunul na palaku sa baryun Bethania. Sên marani silayna sa baryu, intag-ay nay luway gamêt na ta pagpalên na sila. ");
INSERT INTO blx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kaban pagpalên na sila, nitag-ay yina sa langit. ");
INSERT INTO blx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Inulimên laya buy nag-udung sila sa balayan Jerusalem un sadyay tula. ");
INSERT INTO blx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Buy pawa silaynan idi sa Templu amên mangulimên kan Bapan Namalyari.");
INSERT INTO blx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bayu pun dinyag ga kaganawan, dilag gay pambêgên Sabi. Ya Sabi, kaawyun nan Namalyari buy ya Sabi sabay ya Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bayu dinyag ga kaganawan, ya Sabi, kaawyun nan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ya kaganawan bagay, dinyag Namalyari sa kapamilatan Sabi buy ayin dakun sabêt man na dinyag un ayin na Sabi. ");
INSERT INTO blx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ya Sabi sabay ya pinangubatan biyay buy ya biyay na sabay ya dêkêt ya mam-in sawang sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ya dêkêt ta ati sabay ya mam-in sawang sa mani tawuy idi sa kadlêman buy a ya masambut un kadlêman. ");
INSERT INTO blx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","In-utus Namalyari ya gisay tawuy maglagyun Juan. ");
INSERT INTO blx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","In-utus ya amên magpapêtêg nu sisabêt ta dêkêt amên manampalatayay kaganawan tawu. ");
INSERT INTO blx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Alwan si Juan ya dêkêt, nun a kay in-utus ya amên magpapêtêg nu sisabêt ta dêkêt. ");
INSERT INTO blx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ya pêtêg ga dêkêt, inlumatêng ngana baydi sa babun luta ya sabay ya mam-in sawang sa kaganawan tawu. ");
INSERT INTO blx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nuwa a yapun êt kinilalan mani tawu, agyan idi yina baydi buy agyan dinyag nay babun luta. ");
INSERT INTO blx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Naku ya sa sarili nan lugal, nuwa malakêy asê nananggap kana. ");
INSERT INTO blx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nuwa ya mani nananggap buy nanampalataya kana, binyanan nan karapatan magin anak Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nagin anak silan Bapan Namalyari alwan sa kapamilatan pamianak tawu o sa kalabayan miasawa, nun a sa kalabayan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Napakadyag tawuy Sabi buy nanugêl yan kaawyun yan. Nakitan yan ya kadakilaan na bilang gigisay Anak Namalyari. Pawa yan kangêdan buy kapêtêgan. ");
INSERT INTO blx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nagpapêtêg si Juan tungkul kana. Ati ya masnêg nan pansabin, “Sabay siyay pantukuyun ku sabitun sinabi kuy, ‘Dilag gisay lumatêng nga mas dakila pun kangku, tagawan dilag gina bayu waku pun ianak.’ ” ");
INSERT INTO blx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gawan sa lubus sa kangêdan na, pawa kitamun makatanggap kangêdan. ");
INSERT INTO blx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ya Kautusan, indin Namalyari kantamu sa kapamilatan Moises, nuwa ya kangêdan buy kapêtêgan, indin naman êt kantamu sa kapamilatan Jesu Cristu. ");
INSERT INTO blx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ayin pun nakakit sa Namalyari agyan kanuman, nuwa ya gigisay Anak nay pawa nan kaawyun, impakilala nay Namalyari kantamu. ");
INSERT INTO blx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Impalakun mani puun Judio sa Jerusalem ya dakun umnuy mani pari buy Levita amên patangên la si Juan nu sisabêt ya. ");
INSERT INTO blx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","A na impuglaw wa pêtêg nun a sinabi na, “Alwan sikuy Cristu ya impangakun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Namatang silayna êt, “Nu parabaydu, sisabêt ka? Sika nayi si Propeta Elias ya pan-êtêngên yan?” Nakitbay ya, “Alwan siku.” Kabay pinatang layna êt manguman, “Nu parabaydu, sika nayi ya Propetay impangakun Bapan Namalyari ya lumatêng?” Nakitbay si Juan, “Alwa êt.” ");
INSERT INTO blx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Sinabi la, “Nu parabaydu, sabin mu kanyan nu sisabêt ka amên dilag kay maibalita sa namiutus kanyan. Sabêt ta masabi mu tungkul sa sarili mu?” ");
INSERT INTO blx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nakitbay si Juan, “Sabay sikuy pantukuyun Propeta Isaias sabitun sinabi nay, ‘Malêngêy gisay tawuy mamibêg sa kakyangan un paradi, “Itinêk yuy danan Panginuun.” ’ ” ");
INSERT INTO blx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Amêsên, dilag ga êt in-utus ya mani Pariseo kan Juan. Namatang sila, “Uysiyan mamawtismu ka yata, pakan alwan sika awêd ya Cristu buy alwan sika si propeta Elias buy alwan sikay Propetay impangakun Bapan Namalyari ya lumatêng?” ");
INSERT INTO blx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nakitbay si Juan, “Mamawtismu waku sa lanêm, nuwa dilag nakaidêng ya kaawyun yu ya a yu kilala. ");
INSERT INTO blx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Sabay siyay pansabin kuy lumatêng buy a ku sêpat magin ipus na.” ");
INSERT INTO blx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nalyari ya ati sa lugal Bethania sa lipay Ilug Jordan nu saantun namawtismu si Juan. ");
INSERT INTO blx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pamakawasak, nakitan Juan si Jesus ya mamadanidani kana. Kabay sinabi na sa mani tawu, “Elêwên yu. Abiti yay Biserun Tupan Bapan Namalyari ya mamitas kasalanan mani tawu sa babun luta! ");
INSERT INTO blx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sabay siyay pantukuyun ku sabitun sinabi kuy, ‘Dilag gisay lumatêng nga mas dakila pun kangku, tagawan dilag gina bayu waku pun ianak.’ ");
INSERT INTO blx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","33","Sabitun nuna, a ku yapun êt tanda nu sisabêt ya. Nuwa si Bapan Namalyari ya niutus kangkun mamawtismu sa lanêm, sinabi na kangku, ‘Makitan mun magyêpa ya Ispiritu ku sa gisay tawu buy manugêl kana. Sabay siyay tawuy mamawtismu kamuyu sa Ispiritu ku.’ Amêsên, pan-ipapêtêg kuy nakitan kuy Ispiritun Bapan Namalyari ya nanuwad pati-pati ya nagtabuy ubat sa langit buy nanugêl kana. Kabay naku waku baydi ya mamawtismu sa lanêm amên ipakilala kuya kamuyun mani Israelita. ");
INSERT INTO blx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nakitan kuy abiin buy magpapêtêg gakun sabay siyay Anak Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pamakawasak, idi ya êt baydu si Juan kaawyun nay luwa sa mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sên nakitan na si Jesus ya manduman, sinabi na, “Elêwên yu! Abiti yay Biserun Tupan Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sên nalêngên luway tagasunul Juan ya sinabi na, sinunul la si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nangawing si Jesus. Kabay nakitan na silay kilalaku kana buy pinatang na sila, “Sabêt ta labay yu?” Nakitbay sila, “Manuru, labay yan matandan nu antuy bibiyan mu.” ");
INSERT INTO blx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Sinabin Jesus kalla, “Kaksaw kaw amên makitan yu.” Nakilakuy luwa buy nakitan lay bibiyan na. Mag-alas kuwatruy nan kaawat ta abitu. Kabay baydu ta silan namalibas yabi kaawyun na. ");
INSERT INTO blx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ya gisa sa luway nakalêngê sa sinabin Juan buy nakilaku kan Jesus sabay si Andres ya patêl Simon Pedro. ");
INSERT INTO blx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pamakamaranun, tambêng tingkap Andres ya patêl na ya si Simon buy sinabi kanay, “Nakitan yan nay Mesiyas.” (Ya labay sabin Mesiyas, “Cristu.”) ");
INSERT INTO blx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Impikilaku na si Simon kan Jesus. Buy sên nilatêng silayna kan Jesus, inêlêw Jesus si Simon buy sinabi na, “Sika si Simon ya anak Juan, nuwa paubat amêsên, palagyunan katan Cefas.” (Ya labay sabin lagyun Cefas, Pedro.) ");
INSERT INTO blx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pamakawasak, naisip Jesus ya maku sa prubinsyan Galilea. Nakitan na baydu si Felipe buy sinabi na kana, “Kilaku ka kangku.” ");
INSERT INTO blx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe taga balayan Bethsaida ya, kaparisu lan Andres buy si Pedro. ");
INSERT INTO blx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nakitan Felipe si Nathanael buy sinabi na kana, “Nakitan yan nay tawuy pantukuyun sa Kautusan na impasulat kan Moises buy impasulat sa mani propeta. Sabay siya si Jesus ya taga Nazaret ya anak Jose.” ");
INSERT INTO blx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Sinabin Nathanael kana, “Kali! Taga Nazaret si Cristu? Dilag nayin mangêd da maubat sa Nazaret?” Kabay nakitbay si Felipe, “Kaksaw ka amên makit muya.” ");
INSERT INTO blx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sên nakitan Jesus ya magdani kana si Nathanael, sinabin Jesus kana, “Abiti yay gisay pêtêg Israelita ya asê mapamurayit.” ");
INSERT INTO blx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Pinatang yan Nathanael, “Parasaantu mukun nakilala?” Nakitbay si Jesus, “Bayu ka pun binêg Felipe, nakitan katay nay idi sa aypan puun kayun igus.” ");
INSERT INTO blx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nakitbay si Nathanael, “Manuru, sika yabay ya Anak Bapan Namalyari! Sika ya arin Israel!” ");
INSERT INTO blx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Sinabin Jesus kana, “Manampalataya ka nayi kangku gawan sinabi kuy nakitan kata sa aypan puun kayun igus? Alwan kay abiin na makit mu, ta igit pun baysên na makitan mu.” ");
INSERT INTO blx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Buy sinabi pun êt Jesus kana, “Pansabin ku kamuyuy makitan yuy mawang-at ta langit buy makitan yu êt ya mani ang-el Bapan Namalyari ya magdakêy buy magtabuy sa bibiyan kuy in-Anak Tawuy ubat sa langit.” ");
INSERT INTO blx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sên nilabas say luway allu, dilag tangênan sa Cana sa prubinsyan Galilea. Idi bayduy indu nan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Buy naku êt baydu si Jesus kaawyun nay mani tagasunul na gawan sinagyat sila. ");
INSERT INTO blx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sên naubus say alak sa kalutu, sinabin indu nan Jesus kana, “Naubus ya alak la.” ");
INSERT INTO blx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sinabin Jesus kana, “Tuwa kuway, paulayan muku pun. Asê pun inlumatêng nga uras ku.” ");
INSERT INTO blx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sinabin indu nan Jesus sa mani manawup sa kalutu, “Daygên yuy sabêt man na iutus na kamuyu.” ");
INSERT INTO blx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dilag baydun anêm ma tapayan ya panggamitin mani Judio sa naugalyan lan pag-uyas. Ya balang tapayan, malyarin maglaman pitumpu buy limay litru anggan dinalan buy mapu buy limay litruy lanêm. ");
INSERT INTO blx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sinabin Jesus sa mani manawup, “Pakapnun yun lanêm ma mani tapayan.” Buy pinakapnu la yabay. ");
INSERT INTO blx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pamakayari, sinabin Jesus kalla, “Manaksêb kaw buy gêtan yu sa mamaala sa kalutu.” Nanaksêb sila yabay buy indin la sa mamaala. ");
INSERT INTO blx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kabay tinawayan mamaalay lanêm ya napakadyag alak. A na tanda nu saantu naubat ya alak nuwa ya mani manawup, tanda la ta silay nanaksêb lanêm. Kabay impabêg nay liyaki ya pan-itangên ");
INSERT INTO blx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","buy sinabi na, “Babayu muyan in-awas ya mamanyaman na alak ta. Pakan sa balang kalutuy mumuna lan pan-iawas ya mamanyaman na alak. Buy nu malakêy nay nainêm mani tawu, baydu la pun iawas ya pêrad manyaman na alak.” ");
INSERT INTO blx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ya nalyarin abiin sa Cana sa prubinsyan Galilea, sabay ya nunan mamakaupapas ya dinyag Jesus. Buy sa kapamilatan dinyag na, impakit nay kapangyarian na. Kabay luyang nanampalataya kanay mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pamakayarin tangênan, naku si Jesus sa balayan Capernaum, kaawyun nay indu na, mapatêl na buy mani tagasunul na. Nanugêl sila baydun dakun umnuy allu. ");
INSERT INTO blx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Narani yay pestan mani Judioy pambêgên Pestan Kaligtasan. Kabay naku si Jesus sa balayan Jerusalem. ");
INSERT INTO blx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nalatêng na sa kasawangan Templun Bapan Namalyari ya mani magtindan baka, mani tupa buy mani pati-pati ya pan-iandug kan Bapan Namalyari. Nakitan na êt ta mani tawuy nakaiknu ya mallibay peran dayuwan sa peran mani Judio. ");
INSERT INTO blx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pamakakit na kalla, nangwa yan sêêl ya pinallatiku na buy inuday nan impaawas ya mani baka buy tupa sa Templu. Imbulaglag nay mani peran mani mallibay buy imbabaliswag nay mani lamesa la. ");
INSERT INTO blx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sinabin Jesus sa mani mamisaliw mani pati-pati, “Itas yuy mani abiin! Agana yu daygên palengki ya balin Bapa ku!” ");
INSERT INTO blx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Naganakan mani tagasunul nay idi sa kasulatan, “Mipakadawak kaku gawan sa pagmalasakit ku sa bali mu.” ");
INSERT INTO blx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gawan sa dinyag na, pinatang yan puun mani Judio, “Sabêt ta mamakaupapas ya maipakit mu kanyan amên maipapêtêg mun dilag kan karapatan daygên na abiin?” ");
INSERT INTO blx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Pikitbayan silan Jesus, “Lasakên yuy Templun ati buy sa lalên tatluy allu, ipaydêng kun manguman.” ");
INSERT INTO blx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Sinabi lay naman, “Nayin kay tatluy allu minaman daygên ya Templun ati, pakan dinyag ga ati sa lalên apattapu buy anêm ma tawun?” ");
INSERT INTO blx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nuwa a la mapukatan ya templuy pansabin Jesus sabay ya lawini na. ");
INSERT INTO blx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kabay sên nanguman nabyay si Jesus, naganakan mani tagasunul nay mani sinabi na tungkul sa Templu. Buy luyang silan nanampalataya sa pansabin Kasulatan Bapan Namalyari buy sa mani sinabin Jesus. ");
INSERT INTO blx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sabitun Pestan Kaligtasan, idi pun sa Jerusalem si Jesus. Malakêy mamakaupapas ya dinyag na. Kabay malakêy nanampalataya kana. ");
INSERT INTO blx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nuwa asê nagtiwala si Jesus sa mani tawu, gawan tanda nay isip kaganawan tawu. ");
INSERT INTO blx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Buy a nayna kaylangan dilag magsabi kana tungkul sa pan-isipin mani tawu, ta tanda nayna nu sabêt ta idi sa bêkê la. ");
INSERT INTO blx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dilag gisay tawuy maglagyun Nicodemo. Gisa ya sa puun mani Judio buy kaawyun ya sa grupun mani Pariseo. ");
INSERT INTO blx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gisay yabi, naku ya kan Jesus buy sinabi na, “Manuru, tanda yan ya gisa ka sa mani manuruy in-utus Bapan Namalyari, tagawan ayin makadyag sa mani mamakaupapas ya pandaygên mu, kaynu idi kana si Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nakitbay si Jesus kana, “Pansabin ku kamuy nu asê ianak manguman ya gisay tawu, a ya miawyun sa mani tawuy pag-arian Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Namatang si Nicodemo, “Parasaantun ianak manguman ya gisay tawu nu tuwa yina? A yina malyarin miudung sa bitukan indu na amên ianak yan manguman.” ");
INSERT INTO blx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sinabin Jesus, “Pansabin ku kamuy liban ta nu asê ianak sa kapamilatan lanêm buy sa Ispiritun Bapan Namalyari ya gisay tawu, a ya miawyun sa mani tawuy pag-arian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ya in-anak sa kapamilatan tawu, dilag yan lawini. Nuwa ya in-anak sa kapamilatan Ispiritun Bapan Namalyari, dilag yan bayun biyay gawan sa Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kabay agana ka magtaka sa sinabi ku kamuy kaylangan kaw ianak manguman. ");
INSERT INTO blx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ya Ispiritun Bapan Namalyari, para yan angin ya asê makitan. Ya angin, malêngê tamuy pantumyêp na, nuwa a tamu tanda nu antuy ubatan na o antuy lakwên na. Para êt baydu sa tawuy idi kanay Ispiritun Bapan Namalyari, ta abituy makitan sa biyay na.” ");
INSERT INTO blx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Namatang si Nicodemo, “Parasaantun malyari ya abitu?” ");
INSERT INTO blx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nakitbay si Jesus, “Gisa kan kilalay manurun Kautusan sa Israel, nuwa siyan a muya mapukatan na ati ta? ");
INSERT INTO blx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pansabin ku kamuyuy pan-ipatanda yan na mani natandan yan buy pan-ipapêtêg yan na mani nakitan yan. Nuwa a yu pantanggapên ya pan-ipapêtêg yan. ");
INSERT INTO blx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nu a kaw maniwala sa pansabin ku tungkul sa mani bagay baydi sa babun luta, luyang kawnan asê maniwala sa sabin ku kamuyu tungkul sa mani bagay sa langit. ");
INSERT INTO blx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ayin kaatag nakalaku sa langit liban kangkuy ubat sa langit ta in-Anak Tawu.” ");
INSERT INTO blx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sinabi pun êt Jesus, “Sabitun nuna, intag-ay êt Moises ya utan ya tangsu sa kayu sa kakyangan amên ya balang natuktuk utan ya mangêlêw sa utan ya tangsu, miligtas sila. Para ku êt bayduy ubat sa langit ta in-Anak Tawu ya sêpat êt itag-ay ");
INSERT INTO blx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","amên nu sisabêt man na manampalataya kangku, mabiyan yan biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Gawan kakaidwan Bapan Namalyari ya kaganawan tawu sa babun luta, indin nay kagisagisay Anak na amên nu sisabêt man na manampalataya kana, a ya milaku sa ayin katganan na kaparusan, nun a mabiyan yan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gawan asê in-utus Bapan Namalyari ya Anak na baydi sa babun luta amên atulan kaparusan ya mani tawu, nun a amên iligtas na sila.” ");
INSERT INTO blx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ya manampalataya sa Anak na, a ya atulan kaparusan. Nuwa ya asê manampalataya kana, inatulan ninan Bapan Namalyari sa kaparusan, gawan a ya nanampalataya sa kagisagisay Anak na. ");
INSERT INTO blx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Inatulan silayna gawan inlumatêng nga Anak Bapan Namalyari bilang dêkêt baydi sa babun luta. Nuwa labay la pun manugêl sa nadiglêm kaysa magdani kanay mam-in sawang, gawan nadawak ka mani pandaygên la. ");
INSERT INTO blx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ta ya tawuy manyag nadawak, a ya kalabay sa nasawang buy a ya magdani sa nasawang, gawan a na labay makitan ya pandaygên na. ");
INSERT INTO blx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nuwa ya tawuy mambumyay sa kapêtêgan, magdani ya sa nasawang amên makit kaganawan na nadyag nay mangangêd sa kapamilatan panunul na sa kalabayan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pamakayarin abiin, naku si Jesus buy mani tagasunul na sa prubinsyan Judea. Nanugêl sila baydun pêrad da panawun buy namawtismun mani tawu. ");
INSERT INTO blx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Namawtismu êt si Juan sa lugal la pambêgên Enon ya narani sa balayan Salim, gawan malakêy lanêm baydu. Mamaku kanay mani tawu amên magpabawtismu. ");
INSERT INTO blx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sa panawun na abitu, asê pun impasukul si Juan. ");
INSERT INTO blx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Amêsên, dilag pamisusubakan ya gisay Judio buy mani tagasunul Juan tungkul sa naugalyan lay pallinis. ");
INSERT INTO blx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kabay nakuy mani tagasunul Juan kana buy sinabi la, “Manuru, si Jesus ya impakilala mu sa mani tawu sa lipay Ilug Jordan, mamawtismu ya êt buy malakê êt ta tawuy mamaku kana.” ");
INSERT INTO blx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nakitbay si Juan, “Ayin madyag ga tawu nu asê tulutan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sikaw way makapagpapêtêg sa sinabi kuy alwan sikuy Cristu, nun a kay gisa kun in-utus Bapan Namalyari ya nuna kana amên ipatanday pallumatêng na. ");
INSERT INTO blx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Alimbawa sa gisay tangên, nu palatêng ngay liyaki ya manangên buy nu malêngêy nan abay ya tunuy na, sadyay sayan abay gawan mapagkaawyun nan liyaki ya babayi ya pantangênên na. Para ku êt baydu. Sadyay saya ku gawan mapagkaawyun nan mani tawu si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sêpat yan mitag-ay buy sikuy naman miyêpa.” ");
INSERT INTO blx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Sinabi pun êt Juan, “Si Cristu, ubat ya sa langit. Kabay dakila ya sa kaganawan. Sikitamina man, idi baydi sa babun luta buy magsabin kay tungkul sa mani bagay baydi sa babun luta. Nuwa si Cristu, ubat ya sa langit. Kabay dakila ya sa kaganawan. ");
INSERT INTO blx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pan-ipapêtêg nay nakitan na buy nalêngê na sa langit, nuwa kay dakun umnuy naniwala sa pan-ipapêtêg na. ");
INSERT INTO blx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nuwa ya naniwala sa pansabin na, magpapêtêg yan mapagtiwalan ya mani pansabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ta si Cristuy in-utus Bapan Namalyari ya sabay ya mamipatanda kantamun mani pansabin Bapan Namalyari, gawan lubus indin kanay Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kakaidwan Bapan Namalyari ya Anak na buy impaaypa nay kaganawan sa kapangyarian na. ");
INSERT INTO blx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ya manampalataya sa Anak Bapan Namalyari, mabiyan yan biyay ya ayin katganan. Nuwa ya asê manunul kana, a ya mabiyan biyay ya ayin katganan, nun a manugêl kanay tubag Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nabalitan mani Pariseoy mas malakêy tagasunul Jesus buy binawtismuwan na kaysa kan Juan. ");
INSERT INTO blx_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pakan ya pêtêg, alwan si Jesus ya mamawtismu nun a mani tagasunul nay pan-iutus nan mamawtismu. ");
INSERT INTO blx_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Namita si Jesus sa prubinsyan Judea buy nag-udung ya sa prubinsyan Galilea. ");
INSERT INTO blx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kaylangan nan duman sa Samaria. ");
INSERT INTO blx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sên manduman na si Jesus buy mani tagasunul na sa Samaria, niras sila sa gisay balayan ya pambêgên Sicar ya narani sa lutay manan indin Jacob sa anak nay si Jose. ");
INSERT INTO blx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Dilag baydun pangasuyan ya manan dinyag Jacob. Sên napagalan Jesus sa pamita na, niknu ya sa danin pangasuyan. Marani yan ugtuy mamut ya abitu. ");
INSERT INTO blx_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ya mani tagasunul na, napapakun sa balayan amên manaliw kanên. Kaban nakaiknu si Jesus, dilag inlumatêng ya gisay babayi ya Samaritana amên mangasuy. Sinabin Jesus kana, “Malyari yaku nayin makiinêm?” ");
INSERT INTO blx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nuwa sinabin babayi kana, “Uysiyan manyawad kayan lanêm kangku ta? Pakan Judio ka buy Samaritana ku.” Sinabi nay abiin tagawan ayin pamikiawyun na mani Judio sa mani Samaritano. ");
INSERT INTO blx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Pikitbayan Jesus ya babayi, “Nu tanda mu ta dayi ya pan-idin Bapan Namalyari buy nu sisabêt ta makiinêm amêsên kamu, dat sika pun na makiinêm lanêm kangku buy biyan katan lanêm ya mam-in biyay.” ");
INSERT INTO blx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sinabin babayi, “Patêl lay, malalêy pangasuyan buy ayin kan panaksêb. Saantuy pangwanan mun lanêm ya mam-in biyay? ");
INSERT INTO blx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Awta igit ka pun nayi sa ninunu tamun si Jacob ya nipamana kanyan ati ya pangasuyan nê? Sabitun nuna, baydi sila maminêm buy mani anak na, agyan na mani saysay na.” ");
INSERT INTO blx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nakitbay si Jesus, “Ya kaganawan minêm sa lanêm ma pan-asuyun yu baydi, pumêl-ang yan manguman, ");
INSERT INTO blx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nuwa sisabêt man na minêm sa lanêm ma idin ku, a yina pumêl-ang. Ta ya lanêm ma idin ku kana, kaparisun lanêm sa sibul ya nabyay sa lalên bêkê na ya sabay ya mam-in biyay ya ayin katganan kana.” ");
INSERT INTO blx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sinabin babayi, “Patêl lay, biyan muku bay abiin na lanêm ya pansabin mu amên a kina mapêl-ang buy a kina miudung-udung mangasuy baydi.” ");
INSERT INTO blx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sinabin Jesus kanay, “Muli kay na pun buy pakilaku muy asawa mu baydi.” ");
INSERT INTO blx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Pikitbayan yan babayi, “Ayin nakun kayêk asawa.” Sinabin Jesus kana, “Pêtêg ga sinabi muy ayin kan asawa, ");
INSERT INTO blx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","gawan limay nay napag-asawa mu buy ya pagkaawyun mu amêsên, alwa mu êt pêtêg asawa. Kabay pêtêg ga sinabi mu.” ");
INSERT INTO blx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Sinabin babayi, “Tanda kuy gisa kan propeta. ");
INSERT INTO blx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ya mani ninunu yan, baydi sa bung-uy mangulimên kan Bapan Namalyari. Nuwa sikaw waman na mani Judio, magsabin kay sa Jerusalem sêpat mangulimên na mani tawu.” ");
INSERT INTO blx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sinabin Jesus kana, “Maniwala ka sa sabin ku. Lumatêng nga panawun na alway nan sa bung-uy ya ati o sa Jerusalem kaw mangulimên kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sikaw wa mani Samaritano, a yu kilala ya pan-ulimênên yu. Nuwa sikay ya mani Judio, kilala yan na pan-ulimênên yan, tagawan maubat sa layin mani Judio ya mamiligtas sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nuwa palatêng ngay panawun buy idi yana baydi, ya mani pêtêg mangulimên kan Bapan Namalyari, mangulimên sila sa kapamilatan sawup Ispiritun Bapan Namalyari buy sa kapêtêgan, ta parabaysên na kalabayan Bapa. ");
INSERT INTO blx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Si Bapan Namalyari, Ispiritu ya. Kabay ya mangulimên kana, sêpat yan mangulimên kana sa kapamilatan Ispiritun Bapan Namalyari buy sa kapêtêgan.” ");
INSERT INTO blx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sinabin babayi, “Tanda kuy lumatêng nga Mesiyas ya pambêgên Cristu. Pamakalatêng na, siyay mipatanda kanyan kaganawan bagay.” ");
INSERT INTO blx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sinabin Jesus kana, “Siku amêsên na kasabi mu ya sabay ya Mesiyas ya pan-êtêngên yu.” ");
INSERT INTO blx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sa uras abitu, inlumatêng nga mani tagasunul Jesus. Nakamulala sila gawan nalatêng lay makisabi ya sa gisay babayi. Nuwa ayin gisa man kallay namatang nu sabêt ta kaylangan babayi. Buy ayin êt namatang kan Jesus ya siyan makisabi ya sa babayi. ");
INSERT INTO blx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Inlakwanan babayi ya banga na buy nag-udung ya sa balayan buy sinabi na sa mani tawu bayduy, ");
INSERT INTO blx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kaksaw kaw! Elêwên yuy tawuy siyan tanda nay kaganawan dinyag ku! Dat sabay siyay nay Cristuy pan-êtêngên tamu.” ");
INSERT INTO blx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kabay namitay mani tawu sa balayan buy inlaku la si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kaban ayin pun na babayi, nakisabi ya mani tagasunul kan Jesus, “Manuru, mangan kayna.” ");
INSERT INTO blx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nuwa nakitbay si Jesus, “Dilag gakun kanên na a yu tanda.” ");
INSERT INTO blx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kabay nipapatang nga mani tagasunul na, “Dilag nayin namalêt kanên kana?” ");
INSERT INTO blx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sinabin Jesus kalla, “Ya kanên ku sabay ya panunul ku sa kalabayan Bapan Namalyari ya namiutus kangku buy yarin na pan-ipadyag na. ");
INSERT INTO blx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Alwa nayin pansabin yuy ‘apat ta buwan pun bayuy pamipupul’? Nuwa pansabin ku kamuyuy êlêwên yuy mani tawuy mallumatêng. Para silan pali ya nawtuy na buy malyari yan pupulun! ");
INSERT INTO blx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Amêsên, pupulun yu silayna amên makatanggap kaw gantimpalay ubat kan Bapan Namalyari. Buy ya mani tawuy pampupulun yu, mabiyan silan biyay ya ayin katganan. Kabay masayan miaawyun na nananêm buy namupul. ");
INSERT INTO blx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pêtêg ga panabin, ‘Kaatag ga nananêm buy kaatag êt ta namupul.’ ");
INSERT INTO blx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","In-utus kataw amên pupulun na a yu intanêm. Kaatag ga nagkasakit nitanêm Sabin Bapan Namalyari kalla, nuwa sikaw waman na mamupul sa intanêm la.” ");
INSERT INTO blx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Malakêy Samaritano sa balayan abituy nanampalataya kan Jesus gawan sa imbalitan babayi, “Tandan Jesus ya kaganawan dinyag ku.” ");
INSERT INTO blx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kabay pamakalatêng mani Samaritano kan Jesus, inyawad lay, “Manuru, manugêl ka pun baydi kanyan.” Kabay nanugêl yabay baydu kallan luway allu. ");
INSERT INTO blx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gawan sa pangaral Jesus, malakê pun êt kallay nanampalataya. ");
INSERT INTO blx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sinabin mani tawu sa babayi, “Manampalataya kay amêsên kana, alwan gawan sa sinabi mu, nun a gawan nalêngê yan na pagsabi na buy tanda yan na sabay siyay nay Mamiligtas sa kaganawan tawu baydi sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pamakayarin luway allun panugêl Jesus baydu, namita yan papakun sa prubinsyan Galilea. ");
INSERT INTO blx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Si Jesus ya nagsabin ya gisay propeta, asê panggalangên sa sarili nan lugal. ");
INSERT INTO blx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sên nilatêng ya sa prubinsyan Galilea, mangêd yan tinanggap mani tawu, gawan nakitan lay kaganawan dinyag na sa Jerusalem sabitun Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nanguman nag-udung si Jesus sa Cana sa prubinsyan Galilea nu saantu nan dinyag alak ka lanêm. Baydu dilag gisay pinunuy nag-anak liyaki ya nagsakit ta idi sa balayan Capernaum. ");
INSERT INTO blx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sên nabalitan nay nag-udung si Jesus sa prubinsyan Galilea ubat sa Judea, inlaku nay ati. Nakisabi ya kan Jesus, “Panginuun, nagsakit kayêk ka anak kuy liyaki buy marani yan mati. Nu malyari dayin kayêk, kilaku ka pun kangku sa Capernaum amên paiyulun muya.” ");
INSERT INTO blx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sinabin Jesus kana, “Anggan a kaw makakit mamakaupapas buy mani tanda', a kaw pun maniwala kangku.” ");
INSERT INTO blx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sinabin pinunu, “Panginuun, kilaku kayna pun dayin kayêk kangku bayu pun mati ya anak ku.” ");
INSERT INTO blx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sinabin Jesus kana, “Muli kayna. Umiyul lay anak mu.” Naniwalay pinunu sa sinabin Jesus buy nuli yina. ");
INSERT INTO blx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kaban idi yapun sa dan, timbêng nginan mani ipus na buy sinabi kanay, “Inumiyul lay anak mu!” ");
INSERT INTO blx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kabay pinatang naya, “Sabêt ta uras nan inumiyul?” Nakitbay sila, “Saybi pun ala unan kaawat, a yina inumut.” ");
INSERT INTO blx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naganakan pinunu ya sa uras êt ta abitu, sinabin Jesus kanay “Inumiyul lay anak mu!” Kabay nanampalataya ya kan Jesus buy kaganawan kaawyun na sa bali. ");
INSERT INTO blx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ati ya ikalway mamakaupapas ya dinyag Jesus sa prubinsyan Galilea sabitun pamakaubat na sa prubinsyan Judea. ");
INSERT INTO blx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pamakayarin abiin, naku si Jesus sa Jerusalem sa gisay pestan mani Judio. ");
INSERT INTO blx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sa gisay pasbul la pasun sa balayan Jerusalem nu saantu la pan-idan na mani tupa, dilag narani ya dinyag lan pagpaluynan ya nu bêgên sa sabin Hebreo, Bethzata. Sa palitêng ati, dilag limay dinyag ga pagpagêmwan, ");
INSERT INTO blx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","nu saantun nakakalêk ka malakêy nagsakit, mani bulag, mani pilay buy mani lumpu. Pan-êtêngên lan magkimit ta lanêm, ");
INSERT INTO blx_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","gawan nu misan, dilag gisay ang-el Bapan Namalyari ya magtabuy bayu mamikimit lanêm. Nu naikimit tan ang-el la lanêm, ya munan makalaku baydu sa lanêm, umiyul ya agyan sabêt man na sakit na. ");
INSERT INTO blx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Dilag baydun liyaki ya tatlumpu buy waluy tawun nan sinakit. ");
INSERT INTO blx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sên nakitan yan Jesus buy natandan nay nabuyut tinan sinakit, pinatang naya, “Labay mu nayin umiyul ka?” ");
INSERT INTO blx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nakitbay ya nagsakit, “Awuy patêl ku, nuwa ayin manawup kangkun maku nu pan-ikimit ta lanêm. Kaban papakun naku pun baydu, maunan nakinan kaatag.” ");
INSERT INTO blx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sinabin Jesus kana, “Midêng ka, gêtan muy kalapayan mu buy mita kayna!” ");
INSERT INTO blx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tambêng inumiyul la liyaki buy gintan nay amak na buy nakabita ya. Nalyari ya abiin sa Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kabay sinabin mani puun Judio sa tawuy pinaiyul, “Allun Pagpaynawa amêsên! Labag sa Kautusan na pantan mun abiin na amak mu.” ");
INSERT INTO blx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nuwa nakitbay ya, “Ya tawuy nakapaiyul kangku sabay ya nagsabin gêtan kuy amak ku buy mita ku.” ");
INSERT INTO blx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pinatang laya, “Magkatawwan nagsabi kamun gêtan muy amak mu buy mita ka?” ");
INSERT INTO blx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nuwa asê tandan liyaki nu sisabêt ta namaiyul kana tagawan nakiagêm si Jesus sa malakêy tawu. ");
INSERT INTO blx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Asê naêpêng, nakitan Jesus sa Templuy tawuy pinaiyul na. Kabay sinabi na kana, “Elêwên mu, inumiyul kayna. Agana kayna manguman manyag kasalanan, ta dat mas nadawak pun na malyari kamu.” ");
INSERT INTO blx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sên nakilala na si Jesus, nagdani ya sa mani puun Judio buy sinabi na kallay, “Si Jesus ya nakapaiyul kangku.” ");
INSERT INTO blx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gawan namaiyul si Jesus sa Allun Pagpaynawa, inumpisan yan pinasakit mani puun Judio. ");
INSERT INTO blx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nuwa sinabin Jesus kalla, “Pawan manyag ga Bapa kun Namalyari. Kabay pawa ku êt manyag.” ");
INSERT INTO blx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gawan sa sinabin Jesus, ingkadus pun mani puun Judioy patin ya. Tagawan alwan kay inlabag nay batas tungkul sa Allun Pagpaynawa, nun a binêg na pun êt sarili nan bapa si Bapan Namalyari. Buy sa pakapakun baydu, imparisu naynay sarili na kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kabay sinabin Jesus kalla, “Pansabin ku kamuyuy sikuy Anak Bapan Namalyari, ayin nakun pandaygên na kay sa sarili ku, nun a ya pandaygên ku, kay ya mangakit kuy pandaygên Bapa ku. Ta nu sabêt man na pandaygên Bapa ku, para êt bayduy pandaygên ku bilang Anak na. ");
INSERT INTO blx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ta kakaidwan nakun Bapa kun Namalyari buy pan-ipakit na kangkuy kaganawan pandaygên na. Buy ya ipakit na kangku amêsên, igit pun sa nakitan yu amên makaupapas kaw. ");
INSERT INTO blx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nu parasaantun pampabyayên Bapay mani nati, para ku êt bayduy Anak na, pabyayên kuy sisabêt man na labay kun pabyayên. ");
INSERT INTO blx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Alwan si Bapay mangatul sa sisabêt man, nun a sikuy Anak na, ta impabaala na kangkuy kaganawan karapatan mangatul ");
INSERT INTO blx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","amên parangalên nakun kaganawan tawu kaparisun pamarangal la kan Bapa. Ya asê mamarangal kangku, a ya êt parangalên Bapa kuy namiutus kangku.” ");
INSERT INTO blx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Pansabin ku kamuyuy sisabêt man na mallêngê sa mani sabi ku buy manampalataya sa namiutus kangku, mabiyan yan biyay ya ayin katganan. A yina atulun ta inligtas sina sa kamatyan buy mabyay yinan ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pansabin ku kamuyuy palatêng ngay panawun buy inlumatêng ngana, ya si mani tawuy nati sa pangêlêw Bapan Namalyari, malêngê lay nay tunuy ku ya Anak na buy ya mallêngê buy maniwala sa sabin ku, mabiyan yan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ta dilag kapangyarian na Bapay mam-in biyay. Para ku êt bayduy Anak na, ta binyanan nakun kapangyarian mam-in biyay. ");
INSERT INTO blx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Buy binyanan naku êt karapatan mangatul, gawan sikuy ubat sa langit ta in-Anak Tawu.” ");
INSERT INTO blx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Agana yu pagtakan na sinabi ku, gawan lumatêng lanuy uras ya kaganawan mani nati ya nakalbêng, malêngê lay tunuy ku ");
INSERT INTO blx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","buy mimata silan mipag-awas. Ya mani nanyag mangêd, pabyayên na silan ayin katganan. Nuwa ya mani nanyag nadawak, parusan silan ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sinabi pun êt Jesus, “Ayin nakun madyag nun kay sarili ku. Mangatul laku, nuwa ya pangatul kuy kay ayun sa malêngê kun pansabin Bapa ku. Kabay makatuynungan na pangatul ku, gawan alwan sarili kun kalabayan na pansunulun ku, nun a ya kalabayan namiutus kangku.” ");
INSERT INTO blx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nu kay sikuy magpapêtêg tungkul sa sarili ku, dat kay sabin yuy alwan pêtêg ga mani pansabin ku. ");
INSERT INTO blx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nuwa dilag gisay magpapêtêg tungkul kangku ya sabay ya Bapa ku buy tanda kuy pêtêg ga pansabin na.” ");
INSERT INTO blx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Para êt baydu si Juan ya Mamawtismu. Sên niutus kaw tawu amên patangên ya, nagpapêtêg ya tungkul kangku. ");
INSERT INTO blx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Insabi kuy tungkul sa pagpapêtêg Juan, alwan gawan kaylangan kuy pagpapêtêg gisay tawu, nun a amên manampalataya kaw kangku buy miligtas. ");
INSERT INTO blx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan, kaparisu yan gisay dêkêt ta mansumawang. Buy agyan a ya naêpêng, lubus kaw natula sa sawang pagpapêtêg na. ");
INSERT INTO blx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nuwa dilag pun pagpapêtêg tungkul kangku ya igit pun sa pagpapêtêg Juan. Ayin kaatag nun a ya mani pan-ipadyag kangkun Bapa ku ya pandaygên ku amêsên ta abiin na magpapêtêg ya si Bapay namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Buy si Bapay namiutus kangkuy magpapêtêg êt tungkul kangku. Kanuman a yu pun nalêngêy tunuy na o nakitan na wangis na. ");
INSERT INTO blx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Buy ayin sa bêkê yuy sabi na, gawan a kaw nanampalataya kangkuy in-utus na. ");
INSERT INTO blx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pan-usisên yuy Kasulatan Bapan Namalyari ta indap yu nu sa kapamilatan pangusisa yu, mabiyan kaw biyay ya ayin katganan. Ya Kasulatan na abiin, sabay ya magpapêtêg tungkul kangku, ");
INSERT INTO blx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nuwa a kaw kalabay magdani kangku amên mabiyan kaw biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“A ku pan-angadên na pangulimên mani tawu. ");
INSERT INTO blx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nuwa kilala kataw buy tanda ku êt ta ayin sa bêkê yuy pangidu kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","In-utus sakun Bapan Namalyari baydi sa lagyu na, nuwa a yuku labay tanggapên. Nuwa nu dilag kaatag lumatêng kamuyu sa sarili nan lagyu, pantanggapên yuya. ");
INSERT INTO blx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Parasaantu kaw manampalataya kangku nu kay pangulimên kaparisu yun tawuy labay yu buy alwan pangulimên sa gigisay Bapan Namalyari?” ");
INSERT INTO blx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Agana yu isipin na sikuy mamidalum kamuyu sa Bapa ku, nun a si Moises ya pan-asaan yu ya sabay ya mamidalum kamuyu, ");
INSERT INTO blx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ta tungkul kangkuy insulat Moises. Kabay nu paniwalan yuya, paniwalan yuku êt. ");
INSERT INTO blx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nuwa gawan a yu paniwalan na mani insulat na, ipakun yu saantun paniwalan na mani pansabin ku?” ");
INSERT INTO blx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pamakayarin pesta, nag-udung si Jesus buy mani tagasunul na sa prubinsyan Galilea. Gisay allu, naglipay sila sa lawan Galilea ya pambêgên êt Tiberias. ");
INSERT INTO blx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sinunul sadyay lakên tawu si Jesus, gawan nakitan lay mani mamakaupapas ya dinyag na sa mani nipagsakit. ");
INSERT INTO blx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tinumuksaw sa bung-uy si Jesus kaawyun nay mani tagasunul na buy niknu sila baydu. ");
INSERT INTO blx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Narani yanay pestan mani Judioy pambêgên Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sên nangêlêw si Jesus, nakitan nay sadyay lakên tawuy magdani kana. Kabay pinatang na si Felipe, “Saantu kitamu makasaliw kanên amên maipakan sa mani tawun ati?” ");
INSERT INTO blx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pinatang nay ati amên subukan si Felipe, gawan tanday nan Jesus nu sabêt ta daygên na. ");
INSERT INTO blx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nakitbay si Felipe, “Asê nukad da luwan dalan na dinaryu amên panaliw tinapay sadyay lakên tawu, agyan kay tipêrad pun êt ta balang gisa.” ");
INSERT INTO blx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sinabi yaman Andres ya patêl Pedro ya gisa sa tagasunul Jesus, ");
INSERT INTO blx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Dilag gisay anak ka liyaki baydi ya dilag lilimay tinapay buy luluway kênan lanêm. Nuwa asê nukad da ati sa sadyay lakên tawu.” ");
INSERT INTO blx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sinabin Jesus, “Paiknun yuy mani tawu.” Niknuy naman na mani tawu baydu sa malakêy lamun. Ya bilang mani lawyaki, limay libu. ");
INSERT INTO blx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kingwan Jesus ya tinapay buy kênan lanêm buy impasalamat na kan Bapan Namalyari. Pamakayari, inatag-atag nay ati sa mani tawu buy nangan sila. ");
INSERT INTO blx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sên nanabsuy yay mani tawu, sinabin Jesus sa mani tagasunul na, “Tipunun yuy kaganawan tagan amên ayin masayang.” ");
INSERT INTO blx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kabay tinipun lay tagan na tinapay buy napakapnu lay mapu buy luway salikap. ");
INSERT INTO blx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sên nakitan mani tawuy mamakaupapas ya dinyag Jesus, sinabi lay, “Sabay siyay nay propetay pan-êtêngên tamun lumatêng baydi sa babun luta!” ");
INSERT INTO blx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tandan Jesus ya labay layan pilitin daygên ari. Kabay namita ya baydu buy nanguman yan nagtuksaw sa bung-uy un kay kakapad na. ");
INSERT INTO blx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sên mamayabiyabi yana, inlumunsan na mani tagasunul Jesus sa agid lawa. ");
INSERT INTO blx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nadêm mana buy ayin pun si Jesus. Kabay nagsakay silayna sa gisay bangka buy munay nan maglipay papakun sa balayan Capernaum. ");
INSERT INTO blx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kaban maglipay sila, nag-umpisan inlumakas ya angin buy dinumagul la alun. ");
INSERT INTO blx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sên nakasagwan silaynan lima o anêm ma kilumetru, dilag silan nakitan na mamita sa babun lanêm ya mamadanidani sa bangka la. A la nakilalay si Jesus awêd da abitu. Kabay sadyay limu la. ");
INSERT INTO blx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nuwa sinabin Jesus kallay, “Sikuy ati! Agana kaw malimu.” ");
INSERT INTO blx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kabay impasakay la si Jesus sa bangka la buy mamakun ni, nilatêng sila sa lugal la lakwên la. ");
INSERT INTO blx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Kinawasakan, ya mani tawu nu saantu sila pinakan tinapay un Panginuun, idi sila pun êt baydu. Tanda lay kay gigisay bangka ya sinakayan mani tagasunul na buy asê nakilaku si Jesus kalla. Kabay indap la, idi pun baydu si Jesus. Amêsên, dilag inlumatêng nga mani bangka ya ubat sa Tiberias ya tinunggên sa lugal nu saantu impasalamat Panginuun na tinapay ya kinnan mani tawu. ");
INSERT INTO blx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sên a layna nakit si Jesus baydu buy mani tagasunul na, nagsakay sila sa mani bangkan abitu buy naku sa Capernaum amên têkapên si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pamakalatêng mani tawu sa Capernaum, nakitan la si Jesus buy pinatang laya, “Manuru way, nakanu kaw pun naku baydi?” ");
INSERT INTO blx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nakitbay si Jesus kalla, “Pansabin ku kamuyuy kay pantêkapên yuku, gawan nakaêkan kaw tinapay ya nakabsuy kamuyu, alwan gawan sa mani nakitan yuy mamakaupapas. ");
INSERT INTO blx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mag-ubra kaw alwan kay sa kanên na mangasira, nun a sa kanên na asê mangasira buy makab-in biyay ya ayin katganan. Sikuy ubat sa langit ta in-Anak Tawu ya mam-i kamuyun ati, ta sikuy pinilin Bapan Namalyarin binyanan nan kapangyarian mam-i kamuyun ati ya kanên na sabay ya mam-in biyay ya ayin katganan kamuyu.” ");
INSERT INTO blx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kabay pinatang mani tawu si Jesus, “Sabêt ta sêpat yan daygên amên madyag yan na pan-ipadyag Bapan Namalyari kanyan?” ");
INSERT INTO blx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nakitbay si Jesus, “Ati ya pan-ipadyag Bapan Namalyari kamuyu. Manampalataya kaw kangkuy in-utus na.” ");
INSERT INTO blx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Namatang nga mani tawu, “Sabêt ta mamakaupapas ya ipakit mu kanyan amên manampalataya kay kamu? ");
INSERT INTO blx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sabitun idi sa kakyangan na mani pipuunpuunan yan, nangan silan kanên. Ta abituy idi sa Kasulatan, ‘Binyanan silan Moises kanên ya ubat sa langit.’ ” ");
INSERT INTO blx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sinabin Jesus kalla, “Pansabin ku kamuyuy alwan si Moises ya nam-in kanên na ubat sa langit sa pipuunpuunan yu, nun a ya Bapa kuy nam-i. Buy siya êt amêsên na mam-i kamuyun pêtêg kanên na ubat sa langit. ");
INSERT INTO blx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gawan ya kanên na pan-idin Bapan Namalyari, ayin kaatag nun a abituy ubat sa langit buy mam-in biyay sa mani tawu sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kabay sinabin mani tawu, “Panginuun, pawa mukay biyan abiin na pansabin muy kanên.” ");
INSERT INTO blx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sinabin Jesus kallay, “Sikuy kanên na mam-in biyay. Sisabêt man na magdani buy manampalataya kangkuy a yina lumayang o pumêl-ang agyan kanuman.” ");
INSERT INTO blx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Nuwa sabitun nuna, sinabi kina kamuyuy agyan nakit yinay mamakaupapas ya dinyag ku, a kaw pun êt nanampalataya kangku. ");
INSERT INTO blx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ya kaganawan tawuy pan-itiwala kangkun Bapa, sabay silay magdani kangku. Buy ya tawuy magdani kangku, tanggapên kuya. ");
INSERT INTO blx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gawan naku waku baydin ubat sa langit amên daygên kuy kalabayan Bapa kuy namiutus kangku, alwan ya sarili kun kalabayan. ");
INSERT INTO blx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ati ya kalabayan namiutus kangku. A ku paulayan mipakadawak ka mani intiwala na kangku, nun a pabyayên ku sila sa allun pangukum ku. ");
INSERT INTO blx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gawan ati ya kalabayan Bapa ku, ya si kaganawan nangilala buy nanampalataya kangku ya Anak na, mabiyan silan biyay ya ayin katganan. Buy pabyayên ku sila sa allun pangukum ku.” ");
INSERT INTO blx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Amêsên, niaayas ya mani Judio gawan sinabin Jesus ya sabay siyay kanên na ubat sa langit. ");
INSERT INTO blx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Sinabi la, “Alwa nayin kay si Jesus ya abiin ya anak Jose? Siyan pansabin nayay ubat ya sa langit ta, pakan kay kilala tamuy mangatwa na?” ");
INSERT INTO blx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sinabin Jesus kallay, “Agana kaw miaayas. ");
INSERT INTO blx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ayin tawuy manampalataya kangku liban ta nu si Bapay namiutus kangkuy mipakadani kana. Buy ya mani magdani kangku, pabyayên ku sila sa allun pangukum ku. ");
INSERT INTO blx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Idi sa insulat mani propetay, ‘Turwanan silan kaganawan Bapan Namalyari.’ Kabay ya kaganawan mallêngê buy makatanda sa sabin Bapa, sabay ya magdani kangku. ");
INSERT INTO blx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Asê labay sabin na dilag gan nakakit kan Bapa, liban kangkuy ubat kan Bapan Namalyari ya sabay ya nakakit kana.” ");
INSERT INTO blx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Pansabin ku kamuyuy ya manampalataya kangku, mabiyan yan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sikuy kanên na mam-in biyay. ");
INSERT INTO blx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ya mani pipuunpuunan yu, nangan silan kanên na indin Bapan Namalyari kalla sa kakyangan, nuwa nati sila pun êt kaganawan. ");
INSERT INTO blx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nuwa idi ya baydi ya kanên na ubat sa langit buy ya mangan ati, a yina mati. ");
INSERT INTO blx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sikuy kanên na mam-in biyay ya ubat sa langit. Ya lawini ku sabay ya kanên na idin kun ikabyay mani tawu sa babun luta. Sisabêt man na mangan kanên na ati, mabiyan yan biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nisusubakan na mani Judioy mallêngê kan Jesus. Sinabi la, “Parasaantun maidin tawun ati ya lawini na amên kanên tamu?” ");
INSERT INTO blx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sinabin Jesus kalla, “Pansabin ku kamuyuy nu a kaw mangan lawini ku ya in-Anak Tawuy ubat sa langit buy minêm daya ku, a kaw mabiyan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nuwa sisabêt man na mangan lawini ku buy minêm daya ku, mabiyan yan biyay ya ayin katganan buy pabyayên kuya sa allun pangukum. ");
INSERT INTO blx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tagawan na lawini kuy pêtêg kanên buy ya daya kuy pêtêg pan-inêmên. ");
INSERT INTO blx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sisabêt man na mangan lawini ku buy minêm daya ku, manugêl ya kangku buy manugêl laku êt kana. ");
INSERT INTO blx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Si Bapan Namalyari ya namiutus kangku ya sabay ya pinangubatan biyay buy bumyay yaku gawan kana. Para êt baydu, sisabêt man na mangan lawini ku, bumyay ya êt gawan kangku. ");
INSERT INTO blx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sikuy kanên na ubat sa langit. Ya kanên na ati, alwan kaparisun kanên na kinnan mani pipuunpuunan yu, tagawan agyan nangan sila, nati sila pun êt. Nuwa sisabêt man na mangan lawini ku, mabiyan yan biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Abiin na sinabin Jesus sa pangaral na sa balin pagtipunan mani Judio sa Capernaum. ");
INSERT INTO blx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sên nallêngên mani tagasunul Jesus ya abitu, malakê kallay nagsabin, “Mangasakit ta pan-iaral na. Sisabêt ta makatanggap ati?” ");
INSERT INTO blx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nuwa agyan ayin magsabi kana, tandan Jesus ya piaayasan mani tagasunul nay in-aral na. Kabay sinabi na kallay, “Natibsê kaw nayi sa sinabi ku? ");
INSERT INTO blx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Luyang ngabay nu makitan yu kuy ubat sa langit ta in-Anak Tawuy mag-udung sa ubatan ku. ");
INSERT INTO blx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ya Ispiritun Bapan Namalyari sabay ya mam-in biyay. Asê madyag tawuy ati. Ya mani pansabin ku kamuyuy ubat sa Ispiritun Bapan Namalyari ya sabay ya mam-in biyay. ");
INSERT INTO blx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nuwa dilag dakun umnu kamuyuy asê maniwala sa mani pansabin ku.” Sinabin Jesus ya abiin gawan sa umpisa pun, tanda nayna nu sisabêt ta asê manampalataya buy nu sisabêt ta mamisupakat kana. ");
INSERT INTO blx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sinabi pun êt Jesus, “Ati ya sangkan na sinabi ku kamuyuy ayin manampalataya kangku nu asê tulutan Bapa ku.” ");
INSERT INTO blx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ubat ta baydu, malakê sa mani tagasunul nay nallakwan kana buy asina nanunul kana. ");
INSERT INTO blx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kabay pinatang nay mapu buy luway tagasunul na, “Sikaw way, lakwanan yuku êt nayi?” ");
INSERT INTO blx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nakitbay si Simon Pedro, “Panginuun, sisabêt pun na sunulun yan? Kay sikay dilag mani sabi ya mam-in biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Maniwala kay kamu buy tanda yan na kay sikay Banal la in-utus Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Sinabin Jesus kallay, “Alwa nayin sikuy namili kamuyun mapu buy luwa? Nuwa ya gisa kamuyu, pinagsuklutan Satanas!” ");
INSERT INTO blx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ya pantukuyun Jesus sabay si Judas ya anak Simon Iscariote, gawan agyan kaawyun si Judas sa mapu buy luway tagasunul na sabay siyay mamisupakat kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pamakayarin abiin, inlibut nay prubinsyan Galilea. Nuwa a ya naku sa prubinsyan Judea gawan labay yan patin mani puun Judio baydu. ");
INSERT INTO blx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sên narani yay pestan mani Judioy pambêgên Pestan Pamipaydêng mani Sawung, ");
INSERT INTO blx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","sinabin mani mapatêl Jesus kanay, “Siyan a kaya naku sa Judea amên makitan mani tagasunul muy mani pandaygên mu ta? ");
INSERT INTO blx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Gawan ayin tawuy manyag paliim nu labay nan makilala ya. Nu manyag kaynan mamakaupapas, ipakit mina sa kaganawan tawu.” ");
INSERT INTO blx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Sinabin mapatêl Jesus ya abiin gawan agyan sila, a sila manampalataya kana. ");
INSERT INTO blx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kabay sinabin Jesus kalla, “Alwa pun amêsên na panawun kun maku. Nuwa sikaw, malyari kaw maku agyan sabêt ta panawun. ");
INSERT INTO blx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ta asê nasulapu kamuyuy mani tawuy asê manunul kan Bapan Namalyari, nuwa siku, pangkasulapwan la, gawan pagpapêtgan kuy kadawakan na pandaygên la. ");
INSERT INTO blx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sikaw tanay maku sa pesta, ta a ku pun panawun maku baydu.” ");
INSERT INTO blx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pamakasabi nan abiin, nagpalakwan ya sa prubinsyan Galilea. ");
INSERT INTO blx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pamakabitan mapatêl Jesus papakun sa pesta, naku êt si Jesus nuwa paliim. ");
INSERT INTO blx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Baydu sa pesta, pantêkapên yan mani puun Judio. “Antuyna kanung a?”, patang la. ");
INSERT INTO blx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Malakêy piaayasan mani tawu tungkul kan Jesus. Dilag magsabin, “Mangêd yan tawu.” Nuwa sinabi yaman kaatag, “Asê, kay pan-ilitêp nay mani tawu.” ");
INSERT INTO blx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nuwa ayin nagsabi tungkul kana sa arapan malakêy tawu gawan malimu sila sa mani puun Judio. ");
INSERT INTO blx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sên kabunakan nan allun pesta, naku si Jesus sa Templu buy nanuru ya sa kasawangan. ");
INSERT INTO blx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nakaupapas ya mani puun Judio sa panuru na buy sinabi lay, “Saantu na nakway abiin na kabiyasnan na, pakan a ya nag-aral?” ");
INSERT INTO blx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kabay sinabin Jesus kallay, “Ya pan-ituru ku alwan ubat kangku, nun a ubat sa namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sisabêt man na manunul sa kalabayan Bapan Namalyari, matandan na nu ya pan-ituru kuy ubat kan Bapan Namalyari o kay ubat kangku. ");
INSERT INTO blx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ya manurun ubat sa sarili na, kay labay nay ulimênên ya. Nuwa ya maglabay ulimênên na namiutus kana, tapat ya buy a ya malaram. ");
INSERT INTO blx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Alwa nayin indin Moises kamuyuy Kautusan? Nuwa siyan ayin yan gisa man kamuyuy manunul sa Kautusan. Gawan nu pansunulun yuy Kautusan, uysiyan labay yuku yan patin ta?” ");
INSERT INTO blx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nakitbay ya mani tawu, “Pansêdakan kaynan nadawak ka ispiritu! Sisabêt taman na kalabay mamati kamu?” ");
INSERT INTO blx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sinabin Jesus kalla, “Nakamulala kaw gawan pinaiyul kuy gisay tawu sabitun Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Alwa nayin indin Moises kamuyuy utus tungkul sa panuli? Sa kapêtêgan, alwan ubat kan Moises ya abiin, nun a ubat sa mani pipuunpuunan yu. Kabay pantulin yuy mani anak, agyan sa Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Amêsên, nu tinuli yina bay ya anak sa Allun Pagpaynawa amên asê malabag ga utus ya impasulat kan Moises, uysiyan manubag kaw ya kangku gawan pinaiyul kuy buun lawinin gisay tawu sa Allun Pagpaynawa ta? ");
INSERT INTO blx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Agana kaw mangusga ayun sa mangakitan yu, nun a bayu kaw mangusga, usisên yu pun amên matandan yuy kapêtêgan.” ");
INSERT INTO blx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sinabin dakun umnuy taga Jerusalem, “Alwa nayin sabay ya tawun ati ya labay patin mani pinunu tamu? ");
INSERT INTO blx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nuwa êlêwên yu! Magsabi ya sa arapan malakêy tawu buy ayin pansabin na mani pinunu laban kana. Dat pangkilalanên lay nan siyay Cristu. ");
INSERT INTO blx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nuwa tanda tamu nu antuy ubatan tawun ati. Nu lumatêng nga Cristu, ayin makatanda nu antuy ubatan na.” ");
INSERT INTO blx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kaban manuru si Jesus sa kasawangan Templu, masnêg nan sinabi, “Indap yu nayi nu kilala yu kina buy indap yu nayi nu tanda yina nu antuy ubatan ku. Naku waku baydi alwan kay sa sarili kun kalabayan, nun a kalabayan namiutus kangku. Tapat ya, nuwa a yuya kilala. ");
INSERT INTO blx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kilala kuya gawan ubat taku kana buy sabay siyay namiutus kangku.” ");
INSERT INTO blx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Gawan sa mani sinabin Jesus, labay yina dayin dakpên mani puun Judio. Nuwa ayin nandakêp kana gawan alwa na pun uras. ");
INSERT INTO blx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Agyan paraman baydu, malakê pun na mani tawuy manampalataya kana. Sinabi la, “Sabay siyay nabay ya Cristu, gawan ayin makaigit sa mani mamakaupapas ya dinyag na!” ");
INSERT INTO blx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nalêngên mani Pariseoy piaayasan mani tawu tungkul kan Jesus. Kabay ya mani mamunun pari buy mani Pariseo, in-utus lay dakun umnuy magbantay sa Templu amên dakpên si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sinabin Jesus, “Pêrad tanay panawun na mapagkaawyun yuku buy pamakayari, mag-udung ngakina sa namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Têkapên yuku, nuwa a yuku makitan, gawan a kaw makalaku sa lakwên ku.” ");
INSERT INTO blx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kabay nipapatang nga mani puun Judio, “Antu kanuy lakwên na ta a tamuy na makitan? Maku ya nayi sa mani Judioy nikyat sa lugal mani Griego? Dat turwanan nay mani Griego? ");
INSERT INTO blx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Sabêt ta labay nan sabin sa sinabi nay, ‘Têkapên yuku, nuwa a yuku makitan,’ buy ‘A kaw makalaku sa lakwên ku’?” ");
INSERT INTO blx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sên kapupusan nan allun pesta ya sabay ya pinakamaulaga, nidêng si Jesus buy masnêg nan sinabi, “Sisabêt man na napêl-ang, magdani ya kangku buy minêm. ");
INSERT INTO blx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tagawan idi sa Kasulatan nu sisabêt man na manampalataya kangku, ‘Mag-awas ubat sa bêkê nay lanêm ma nanuwad sibul la mam-in biyay.’ ” ");
INSERT INTO blx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ya lanêm ma pansabin Jesus, sabay ya Ispiritun Bapan Namalyari ya marani yan tanggapên mani manampalataya kana. Sa panawun abitu, asê pun indin na Ispiritun Bapan Namalyari gawan asê pun nag-udung si Jesus sa langit. ");
INSERT INTO blx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Malakêy tawuy nakalêngê sa sinabin Jesus buy sinabin dakun umnu kalla, “Sabay siyay Propetay pan-êtêngên tamu!” ");
INSERT INTO blx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sinabi êt taman kaatag, “Sabay siyay Cristu!” Nuwa dilag êt magsabin, “Alwan siyay Cristu, gawan asê malyarin maubat ta Cristu sa Galilea. ");
INSERT INTO blx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Alwa nayin idi sa Kasulatan ya si Cristuy maubat sa layin Arin David buy ianak ya sa Bethlehem ma balayan David?” ");
INSERT INTO blx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kabay asê mipaparisuy paniwalan mani tawu tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Labay kaatag ga dakpên ya, nuwa ayin nandakêp kana. ");
INSERT INTO blx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Amêsên, nag-udung nga mani magbantay sa Templu sa mani mamunun pari buy mani Pariseo ya sabay ya namiutus kalla. Pinatang silan mani ati, “Siyan a yuya gintan baydi ta?” ");
INSERT INTO blx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nakitbay sila, “Babayu kay pun nakalêngên tawuy magsabin parabaysên.” ");
INSERT INTO blx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sinabin mani Pariseo, “Alwa ta, agyan sikaw nayiy nailitêp êt tawun abitu? ");
INSERT INTO blx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Dilag kawna nayin nakitan na mani pinunu o mani Pariseoy manampalataya kana? ");
INSERT INTO blx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ayin! Kay mani tawuy ayin tanda sa Kautusan na impasulat kan Moises ya manampalataya kana. Parusan silan Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Si Nicodemo ya naku kan Jesus sabitun nuna buy gisa ya êt sa mani Pariseoy idi baydu. Sinabi na sa mani kaawyun na, ");
INSERT INTO blx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Alwa nayin labag sa Kautusan tamuy atulan na gisay tawu anggan a yapun inlitis buy anggan asê pun natandan nu sabêt ta dinyag na?” ");
INSERT INTO blx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pikitbayan la si Nicodemo, “Awta taga Galilea ka êt nayi? Mangusisa ka sa Kautusan buy mangabasa muy ayin propetay lumatêng nga kay maubat sa Galilea.” ");
INSERT INTO blx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pamakayarin abiin, nipamuli silaynan kaganawan. ");
INSERT INTO blx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Si Jesus saman, naku ya sa Bung-uy mani Ulibu. ");
INSERT INTO blx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pamakawasak, kaban mamabunatbunat, nag-udung si Jesus sa kasawangan Templu. Buy malakêy tawuy nagdani kana. Kabay niknu yan nangaral kalla. ");
INSERT INTO blx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kaban mangaral ya, inlumatêng nga mani manurun Kautusan buy mani Pariseoy dilag aakay ya babayi ya nadakêp lan makikanayun. In-arap lay babayi sa mani tawu ");
INSERT INTO blx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","buy sinabi la kan Jesus, “Manuru, ya babayin ati, nadakêp yan makikanayun. ");
INSERT INTO blx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Idi sa Kautusan na impasulat kan Moises, ya tawuy nangasalanan pamikikanayun, sêpat yan batwan angga sa mati ya. Kabay amêsên, sabêt ta masabi mu?” ");
INSERT INTO blx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Abiin na impatang la kana amên subukan ya, gawan mangkap silan maisangkan laban kana. Nuwa kay nagduku si Jesus buy pinanulat nay panudun gamêt na sa luta. ");
INSERT INTO blx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nuwa sên piuman-uman layan pinatang, nidêng si Jesus buy sinabi kallay, “Sisabêt baydi kamuyuy ayin kasalanan, sabay siyay munan mamatu kana.” ");
INSERT INTO blx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nanguman nagduku si Jesus buy nanulat sa luta. ");
INSERT INTO blx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pamakalêngê lan sinabi na, tisatisa silan namita. Nunay mangatwa angga sa kay si Jesus tay nitagan buy babayi. ");
INSERT INTO blx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Amêsên, nidêng si Jesus buy sinabi na sa babayi, “Antu silayna? Ayin nayin nitagan agyan gisa man amên mangatul kamu?” ");
INSERT INTO blx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nakitbay ya babayi, “Ayin na kayêk.” Kabay sinabin Jesus kana, “Agyan siku, a kata êt atulun. Mita kayna, nuwa agana kayna manguman manyag kasalanan.” ");
INSERT INTO blx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nanguman nagsabi si Jesus sa mani tawu, “Sikuy dêkêt sa babun luta. Sisabêt man na manunul kangku, a yina bumyay sa kadlêman, nun a bumyay yina sa dêkêt.” ");
INSERT INTO blx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sên nalêngên mani Pariseoy abiin, sinabi lay, “A yan ka paniwalan ta kay kakapad minaman na magpapêtêg tungkul sa sarili mu.” ");
INSERT INTO blx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nakitbay si Jesus, “Agyan magpapêtêg gaku tungkul sa sarili ku, pêtêg ga pansabin ku, tagawan tanda ku nu antuy ubatan ku buy nu antuy lakwên ku. Nuwa sikaw, a yu tanda nu antuy ubatan ku o nu antuy lakwên ku. ");
INSERT INTO blx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pan-atulun yuku ayun sa kabiyasnan mani tawu baydi sa babun luta. Nuwa siku, a ku mangatul sa sisabêt man. ");
INSERT INTO blx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nuwa agyan mangatul laku, makatuynungan na pangatul ku. Ta alwan kay kakapad kuy mangatul, nun a kaawyun ku si Bapa ya namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Idi sa Kautusan yuy nu miparisuy pagpapêtêg luway nakakit, sêpat yun paniwalan ya pansabin la. ");
INSERT INTO blx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kabay sêpat yun paniwalan ya pagpapêtêg ku tungkul sa sarili ku, ta alwan kay sikuy magpapêtêg, nun a ya Bapa ku êt ta namiutus kangku.” ");
INSERT INTO blx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kabay namatang nga mani Pariseo, “Antu yabay ya Bapa mu?” Nakitbay si Jesus, “A yuku pêtêg kilala buy a yu êt kilalay Bapa ku. Ta nu kilala yuku dayi, kilala yu êt ta Bapa ku.” ");
INSERT INTO blx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Abiin na sinabin Jesus kaban mangaral ya sa danin pamyanan pera sa Templu. Nuwa ayin nandakêp kana, gawan a na pun panawun. ");
INSERT INTO blx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kabay nanguman nagsabi si Jesus sa mani pinunun mani Judio, “Mita ku buy têkapên yuku. Nuwa a kaw makalaku sa lakwên ku, ta mati kaw un asê pun napatawad da mani kasalanan yu.” ");
INSERT INTO blx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kabay nisasabi ya mani puun Judio, “Magpakamati ya lawês? Sabêt ta labay nan sabin ya a kitamu makalaku sa lakwên na?” ");
INSERT INTO blx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sinabin Jesus kallay, “Sikaw, taga babun luta, nuwa siku, taga langit. ");
INSERT INTO blx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kabay sinabi ku kamuyuy mamatyan yun asê pun napatawad da mani kasalanan yu. Tagawan nu a kaw maniwala ya sikuy Cristu, taganan mamatyan yun asê napatawad da mani kasalanan yu.” ");
INSERT INTO blx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kabay namatang sila kana, “Awta, sisabêt ka?” Nakitbay si Jesus, “Alwa nayin sinabi kina kamuyu sabitun nuna pun nu sisabêt taku. ");
INSERT INTO blx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Malakêy maisabi ku buy maiatul laban kamuyu. Nuwa paraman baydu, ya pan-ipatanda ku sa mani tawu sa babun luta, kay abituy mani pan-ipasabin namiutus kangku. Buy mapagtiwalan na mani pansabin na.” ");
INSERT INTO blx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","A la mapukatan ya si pantukuyun na, sabay ya Bapa nay idi sa langit. ");
INSERT INTO blx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kabay sinabin Jesus, “Sikuy ubat sa langit ta in-Anak Tawu, nu intag-ay yu kinay ubat sa langit ta in-Anak Tawu, matandan yuy sikuy Cristu. Buy matandan yu êt ta kaganawan pandaygên ku buy pansabin kuy kay abituy in-aral kangkun Bapa ku. ");
INSERT INTO blx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Pawa kun pagkaawyun na namiutus kangku. A naku pallakwanan un kay kakapad ku, tagawan pawa kun pandaygên na mani kapapaidu kana.” ");
INSERT INTO blx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sên nalêngên mani tawuy sinabin Jesus, malakêy nanampalataya kana. ");
INSERT INTO blx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sinabin Jesus sa mani Judioy nanampalataya kana, “Nu isundu yuy panunul yu sa pan-iaral ku, pêtêg ga mani tagasunul kataw. ");
INSERT INTO blx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Matandan yuy kapêtêgan buy ya kapêtêgan sabay ya mamibus kamuyu.” ");
INSERT INTO blx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nakitbay sila kan Jesus, “Layi kay Abraham buy kanuman, a kay napaipus agyan kan sisabêt man. Uysiyan sinabi muyay mibus kay yata?” ");
INSERT INTO blx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nakitbay si Jesus kalla, “Pansabin ku kamuyuy nu sisabêt man na mangasalanan, ipus yan kasalanan. ");
INSERT INTO blx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ya ipus, asê kaawyun sa gisay pamilya, nuwa ya anak, kaawyun ya kanuman. ");
INSERT INTO blx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kabay nu ya Anak Bapan Namalyari ya mamibus kamuyu sa kasalanan, taganan mibus kaw. ");
INSERT INTO blx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tanda kuy layi kaw Abraham, nuwa labay yukun patin, gawan a yu labay tanggapên na pangaral ku. ");
INSERT INTO blx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pansabin ku kamuyuy mani nakitan ku sa lukup Bapa ku, nuwa sikaw, pandaygên yuy naman na nalêngê yu sa bapa yu.” ");
INSERT INTO blx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Sinabin mani tawu, “Layi kay Abraham!” Nakitbay si Jesus, “Nu pêtêg kaw mani layin Abraham, pandaygên yu dayi ya mangangêd da dinyag na. ");
INSERT INTO blx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nuwa amêsên, siyan labay yu kinan patin, agyan pansabin kina kamuyuy kapêtêgan na nalêngê ku kan Bapan Namalyari. Alwan parabaysên na dinyag Abraham. ");
INSERT INTO blx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sikaw, pandaygên yuy mani pandaygên bapa yu.” Nakitbay sila kan Jesus, “Alwa kay anak sa kaatag! Kay si Bapan Namalyari ya bapa yan.” ");
INSERT INTO blx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sinabin Jesus kalla, “Nu si Bapan Namalyari ya Bapa yu, kakaidwan yuku dayi, gawan ubat taku kana. Buy naku waku baydi alwan sa sarili kun kalabayan, nun a in-utus sakun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","A yu mapukatan na pansabin ku, gawan a yu labay tanggapên na pan-iaral ku. ");
INSERT INTO blx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Satanas ya bapa yu, ta nu sabêt ta labay na, sabay ya pandaygên yu. Mamati yan tawu ubat pun sa umpisa buy a na labay ya kapêtêgan, gawan ayin kanay kapêtêgan. Ugali naynay malaram, gawan sabay siyay bapan kaganawan kalaraman. ");
INSERT INTO blx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nuwa agyan kapêtêgan na pansabin ku, a yuku labay paniwalan. ");
INSERT INTO blx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sisabêt kamuyuy makapagsabin nakadyag gakun kasalanan? Ayin! Nu kapêtêgan na pansabin ku, uysiyan a kaw ya kalabay manampalataya kangku ta? ");
INSERT INTO blx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ya mani anak Bapan Namalyari, mallêngê sila sa pansabin Bapan Namalyari. Nuwa sikaw, a kaw mallêngê gawan a kaw anak Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sinabin puun mani Judio kan Jesus, “Pêtêg awêd da gisa kan Samaritano buy pansêdakan nadawak ka ispiritu.” ");
INSERT INTO blx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nakitbay si Jesus, “A ku pansêdakan nadawak ka ispiritu, nun a pamparangalên kuy Bapa ku. Nuwa sikaw, a yuku pamparangalên. ");
INSERT INTO blx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A ku mangkap pamarangal. Si Bapay mangkap mani tawuy mamarangal kangku buy kay siyay mangukum. ");
INSERT INTO blx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Pansabin ku kamuyuy nu sisabêt man na manunul sa pan-iaral ku, a ya mati kanuman.” ");
INSERT INTO blx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sinabin mani Judio, “Amêsên, pêtêg yabay ya pansêdakan kaynan nadawak ka ispiritu. Ta nati si Abraham buy mani propeta, pakan pansabin muy asê mati kanuman na manunul sa pan-iaral mu. ");
INSERT INTO blx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mas igit ka pun nayi sa bapa yan ya si Abraham? Agyan siya buy mani propetay nati! Sisabêt ka sa êlêw mu?” ");
INSERT INTO blx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nakitbay si Jesus, “Nu kay sikuy mamarangal sa sarili ku, ayin kapukatan na ati. Nuwa si Bapay pansabin yuy Bapan Namalyari yuy sabay ya mamarangal kangku. ");
INSERT INTO blx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","A yuya kilala, nuwa kilala kuya. Nu sabin kuy a kuya kilala, kaparisu yu kinan malaram. Nuwa taganan kilala kuya buy pansunulun kuy pansabin na. ");
INSERT INTO blx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sên natandan bapa yun Abraham ma tungkul sa panawun na pallumatêng ku baydi, natula ya. Pamakakit na, natulatula yabay.” ");
INSERT INTO blx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sinabin mani puun Judio kanay, “Ayin ka pun limampuy tawun. Parasaantu mun masabi ya nakitan mina si Abraham?” ");
INSERT INTO blx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nakitbay si Jesus, “Pansabin ku kamuyuy bayu pun ianak si Abraham, Sikuwi Sikina.” ");
INSERT INTO blx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Gawan sa sinabi na, namulut batuy mani tawu amên batwan ya. Nuwa nakapagtagu si Jesus buy namita ya sa Templu. ");
INSERT INTO blx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kaban mamita si Jesus, dilag yan nakitan na gisay liyaki ya in-anak kinan bulag. ");
INSERT INTO blx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pinatang mani tagasunul na si Jesus, “Manuru, sisabêt ta nangasalanan ta in-anak yan bulag? Siya nayi o mangatwa na?” ");
INSERT INTO blx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nakitbay si Jesus, “Alwan siya o mangatwa nay nangasalanan, nun a in-anak yan bulag amên makitan kanay kapangyarian Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kabay kaban allu pun, sêpat tamun daygên na pan-ipadyag Bapan Namalyari ya namiutus kangku. Gawan nu yabi yana, a tamina madyag ga pan-ipadyag na. ");
INSERT INTO blx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kaban idi yaku pun sa babun luta, sikuy dêkêt mani tawu.” ");
INSERT INTO blx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pamakasabi nan ati, nanupay ya sa luta ya dinyag nan burak buy impunu na sa matan bulag. ");
INSERT INTO blx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sinabin Jesus sa bulag, “Maku ka sa pagpaluynan ya pambêgên Siloe buy magpulamus ka baydu.” Ya labay sabin Siloe, “In-utus.” Kabay naku yabay bayduy bulag buy nagpulamus. Sên nag-udung ngina, nakakit tina. ");
INSERT INTO blx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kabay nipapatang nga mani karani nan bali buy kaatag pun na nakakit kana sabitun magpalimus yapun. Sinabi la, “Alwa nayin sabay siyay nakaiknun magpalimus allu-allu?” ");
INSERT INTO blx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sinabin kaatag, “Awya sabay siya yabay.” Nuwa sinabi êt kaatag, “Te! Alwa, kay kalupa nay abitu.” Sinabin bulag, “Sabay sikuy abitu.” ");
INSERT INTO blx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kabay pinatang lay liyaki, “Parasaantu kan nakakit?” ");
INSERT INTO blx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nakitbay ya, “Ya liyaki ya pambêgên lan Jesus, nanyag yan burak buy impunu nay ati sa mata ku buy sinabi na kangkuy, ‘Maku ka sa pagpaluynan na pambêgên Siloe buy magpulamus ka baydu.’ Kabay naku waku baydu buy nagpulamus. Pamakayari, nakakit takina.” ");
INSERT INTO blx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Namatang nga mani tawu, “Antuyna?” Nakitbay ya liyaki, “Tawan, a kina tanda.” ");
INSERT INTO blx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Amêsên, ya manan bulag, gintan nan mani tawu sa mani Pariseo. ");
INSERT INTO blx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Allun Pagpaynaway abitu sabitun nanyag burak si Jesus buy pinaiyul la bulag. ");
INSERT INTO blx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pinatang nga êt mani Pariseoy manan bulag, “Parasaantu kan nakakit.” Kabay sinabi na, “Pinunwan nan burak ka mata ku. Nagpulamus saku buy pamakayari, nakakit takina.” ");
INSERT INTO blx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sinabin dakun umnuy Pariseo, “Pilmin alwan ubat kan Bapan Namalyari ya tawuy nanyag abiin, gawan a na sinunul la utus tungkul sa Allun Pagpaynawa.” Nuwa sinabi yaman kaatag, “Nu makasalanan ya, parasaantu nan nadyag ga parabaysên na mamakaupapas?” Kabay asê nikakasunduy mani Pariseo tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kabay pinatang manguman mani Pariseoy manan bulag, “Sabêt ta masabi mu tungkul sa tawuy namaiyul kamu?” Nakitbay ya, “Ya masabi ku, gisa yan propeta.” ");
INSERT INTO blx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nuwa asê pun êt naniwalay mani puun Judio ya sabay siyay manan bulag buy amêsên, makakit tina. Kabay impabêg lay mangatwa na ");
INSERT INTO blx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","buy pinatang, “Anak yu nayi ya ati? Pêtêg nayin in-anak kinan bulag? Uysiyan makakit tina amêsên ta?” ");
INSERT INTO blx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nakitbay ya mangatwa na, “Awu, tanda yan na anak yan yabay buy in-anak kinan bulag. ");
INSERT INTO blx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nuwa a yan naman tanda nu parasaantu yan makakit amêsên. Buy a yan êt tanda nu sisabêt ta namaiyul kana. Siya tay patangên yu, ta idi yina sa ustuy idad. Makapikitbay yina para sa sarili na.” ");
INSERT INTO blx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abiin na sinabin mangatwan manan bulag gawan malimu sila sa mani puun Judio. Tagawan napikasunduwan mani puun Judio ya nu sisabêt man na magsabin si Jesus sabay siyay Cristu, isakwil lina sa balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kabay paradi ya pikitbay mangatwa na, “Idi yina sa ustuy idad. Siya tay patangên yu.” ");
INSERT INTO blx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kabay manguman lan impabêg ga manan bulag buy sinabi kanay, “Manumpa ka sa lagyun Bapan Namalyari ya sabin mu kanyan ya pêtêg! Tanda yan na makasalanan na tawun abitu!” ");
INSERT INTO blx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nakitbay ya, “A ku tanda nu makasalanan ya o asê. Ta kay tanda kinamanbay, mana kinan bulag, nuwa amêsên, makakit takina.” ");
INSERT INTO blx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kabay pinatang layna êt ta manan bulag, “Sabêt ta dinyag na kamu? Parasaantu nakan pinaiyul?” ");
INSERT INTO blx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nakitbay ya, “Pakan sinabi kina kamuyu ta, nuwa kay a kaw kalabay maniwala. Awta labay yuku yan malêngên manguman ta? Kalabay kaw êt nayin madyag tagasunul na?” ");
INSERT INTO blx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kabay nanubag ga mani Pariseo buy inuyam laya, “Sikay naman na tagasunul na, nuwa sikay, tagasunul kay yaman Moises. ");
INSERT INTO blx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tanda yan na nagsabi si Bapan Namalyari kan Moises, nuwa ya tawun abitu, a yan tanda nu antuy ubatan na!” ");
INSERT INTO blx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nakitbay ya liyaki, “Abiin yabay ya mamakaupapas. A yu tanda nu antuy ubatan na, nuwa pinaiyul nay mata ku. ");
INSERT INTO blx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tanda tamuy asê pallêng-ên Bapan Namalyari ya mani makasalanan, nun a pallêng-ên nay sisabêt man na mangulimên kan Bapan Namalyari buy manyag sa kalabayan na. ");
INSERT INTO blx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Paubat awlagi angga amêsên, ayin kitamu pun nalêngêy tawuy nakapaiyul tawuy in-anak kan bulag. ");
INSERT INTO blx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nu alwan ubat kan Bapan Namalyari ya tawun abiin, a na dayi nadyag kangkuy ati ya mamakaupapas.” ");
INSERT INTO blx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nakitbay ya mani puun Judio, “In-anak kaynan makasalanan! Alwa ta siyan napas-êy yapun na nakêm mun aralên ka yaman ta!” Kabay impatas laya sa balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nabalitan Jesus ya manan bulag, impatas ya sa balin pagtipunan mani Judio. Kabay tingkap nay ati. Sên nakitan naya, pinatang naya, “Sikayna man nay, manampalataya ka nayi sa in-Anak Tawuy ubat sa langit?” ");
INSERT INTO blx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nakitbay ya liyaki, “Sisabêt ya? Sabin mu wati kangku amên manampalataya ku kana.” ");
INSERT INTO blx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Sinabin Jesus kana, “Nakitan mu wina. Sabay ya pagkasabi mu amêsên.” ");
INSERT INTO blx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kabay sinabin liyaki, “Panginuun, manampalataya kina kamu.” Nanduku ya buy nangulimên kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sinabi pun êt Jesus, “Naku waku baydi sa babun luta amên mipatandan pêtêg ga kabilyan mani tawu sa pangêlêw Bapan Namalyari. Ya mani tawuy magsabin makakit sila sa kapêtêgan, sabay silay bulag. Nuwa ya magsabin a la makitan na kapêtêgan, sabay silay makakit.” ");
INSERT INTO blx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Dilag dakun umnuy Pariseoy nakalêngê sa sinabin Jesus. Kabay pinatang laya, “Pansabin mu nayi ya bulag kay êt?” ");
INSERT INTO blx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nakitbay si Jesus, “Nu pansabin yuy bulag kaw sa kapêtêgan, ayin dayi kamuyuy kasalanan. Nuwa gawan pansabin yuy makakit kaw, manugêl pun kamuyuy kasalanan.” ");
INSERT INTO blx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nagsabi si Jesus sa kapamilatan paalimbawa, “Pansabin ku kamuyuy ya mansumun sa kural mani tupa un asê manduman sa pasbul nun a kay mallukbang ya sa bakud, sabay siyay manakaw buy tulisan. ");
INSERT INTO blx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nuwa ya manduman sa pasbul, sabay siyay magpastul sa mani tupa. ");
INSERT INTO blx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ya magbantay sa pasbul, pasunun nay magpastul buy tandan mani tupay tunuy magpastul kalla. Pambêgên nay lagyun mani tupa na buy umawas silan manunul kana. ");
INSERT INTO blx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu namipaawas yan tupa, mumuna ya kalla buy manunul kanay mani tupa, tagawan tanda lay tunuy na. ");
INSERT INTO blx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A sila manunul sa kaatag tawu, nun a muwayu silan pakarayu, gawan a la tanday tunuy kaatag.” ");
INSERT INTO blx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sinabin Jesus sa mani tawuy paalimbawan abiin, nuwa a la napukatan na labay nan sabin. ");
INSERT INTO blx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kabay nanguman nagsabi si Jesus, “Pansabin ku kamuyuy sikuy pasbul la dadanan mani tupa. ");
INSERT INTO blx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ya kaganawan nangaral kamuyun alwan pêtêg ya nuna kangku sabay silay mani manakaw tupa buy mani tulisan. Nuwa a sila inlêngên mani tupa ku. ");
INSERT INTO blx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sikuy pasbul. Buy sisabêt man na sumun duman kangku sabay siyay miligtas. Manuwad yan tupay malyarin sumun buy umawas sa kural buy makakit yan pagpastulan. ");
INSERT INTO blx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kay mallumatêng nga manakaw amên manakaw, mamati buy manira. Nuwa inlumatêng ngaku amên biyan kuy mani tawun biyay ya sagana buy ganap.” ");
INSERT INTO blx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Sikuy mangêd da pastul. Buy ya mangêd da pastul, nakal-an yan mati para sa mani tupa na. ");
INSERT INTO blx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ya pan-upan na magpastul, nu makakit yan asun aniwid da mallumatêng, muwayu ya buy lakwanan nay mani tupa, gawan alwan kana. Kabay duyungun asun aniwid da mani tupa buy mangapisisyay sila. ");
INSERT INTO blx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ya pan-upan na magpastul, muwayu ya buy lakwanan nay mani tupa gawan kay pan-upan ya buy ayin yan malasakit sa mani tupa.” ");
INSERT INTO blx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Sikuy mangêd da pastul. Nu parasaantu wakun kilalan Bapa ku buy nu parasaantu kuyan kilala, parabaysên êt ta pangilala ku sa mani tupa ku buy ya pangilala la kangku. Buy nakal-an nakun mati para kalla. ");
INSERT INTO blx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Dilag gaku pun tupay a ku pun naikural. Kaylangan ku silan ipasun sa kural. Pallêng-ên lay naman na tunuy ku buy piaawyunun ku sila amên kay gigisa ta sila ya dilag gigisay magpastul.” ");
INSERT INTO blx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kakaidwan nakun Bapa, gawan nakal-an nakun mati para kalla amên manguman nakun mabyay. ");
INSERT INTO blx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ayin makakwan biyay ku, nun a kay kusa kun idin. Dilag gakun kapangyarian idin na ati buy dilag gaku êt kapangyarian mabyay manguman, ta abiin na in-utus kangkun Bapa ku.” ");
INSERT INTO blx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gawan sa sinabin Jesus, asina êt nikakasunduy mani Judio. ");
INSERT INTO blx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Malakê kallay magsabin, “Tulawên ya buy pansêdakan yan nadawak ka ispiritu. Siyan mallêngê kaw ya kana ta?” ");
INSERT INTO blx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nuwa sinabi yaman kaatag mani Judio, “Alwan parabaysên na pansabin tawuy pansêdakan nadawak ka ispiritu. Ta nu pêtêg yan pansêdakan nadawak ka ispiritu, a na dayi napaiyul la bulag.” ");
INSERT INTO blx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Amêsên sa balayan Jerusalem, Pestay nan Pamitalagan Templu kan Bapan Namalyari. Panawun nalêpêt ta abitu. ");
INSERT INTO blx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Idi sa Templu si Jesus ya mamita sa balkun Solomon. ");
INSERT INTO blx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pinalitêngan yan mani Judio buy sinabi kanay, “Makanu mu sabin kanyan nu sisabêt ka? Nu sikay Cristu, sabin minan tapatan kanyan.” ");
INSERT INTO blx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nakitbay si Jesus kalla, “Sinabi kina kamuyu nu sisabêt taku, nuwa a kaw kalabay maniwala kangku. Ya mamakaupapas ya dinyag ku sa lagyun Bapa ku, sabay ya magpapêtêg nu sisabêt taku. ");
INSERT INTO blx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nuwa a kaw maniwala kangku, gawan alwan sikaw wa mani tupa ku. ");
INSERT INTO blx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mallêngê kangkuy mani tupa ku. Kilala ku sila buy manunul sila kangku. ");
INSERT INTO blx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Pambiyan ku silan biyay ya ayin katganan buy kanuman a sila milaku sa ayin katganan na kaparusan. Idi silayna kangku buy ayin nan makasakmut kalla. ");
INSERT INTO blx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Indin sila kangkun Bapa kun Namalyari ya makapangyarian sa kaganawan buy ayin makasakmut kalla sa Bapa ku. ");
INSERT INTO blx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Siku buy si Bapa, gigisa.” ");
INSERT INTO blx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sên nalêngên mani Judioy abiin, nanguman silan namulut batuy pamatu la kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nuwa sinabin Jesus kallay, “Impakit kina kamuyuy malakêy mangangêd da dinyag ku ya impadyag kangkun Bapa ku. Sabêt sa mani abiin na sangkan ta siyan batwan yuku yata?” ");
INSERT INTO blx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nakitbay sila, “A yan ka batwan gawan sa mangangêd da dinyag mu, nun a sa pallamus mu kan Bapan Namalyari, tagawan pan-iparisu muy sarili mu kan Bapan Namalyari, pakan kay tawu ka.” ");
INSERT INTO blx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nakitbay si Jesus, “Alwa nayin idi sa kasulatan na sinabin Bapan Namalyari ya mani namalyari kaw? ");
INSERT INTO blx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tanda tamuy a tamu malyarin daygên ayin pukat ta Kasulatan Bapan Namalyari. Kabay nu binêg nan namalyari ya mani ninunu tamu ya pinipatandan nan sabi na, ");
INSERT INTO blx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","siyan pansabin yu yay pallamusun ku si Bapan Namalyari gawan sinabi kuy, ‘Anak kakun Bapan Namalyari ta.’ Sikuy pinili na buy in-utus baydi sa babun luta! ");
INSERT INTO blx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nu a ku pandaygên na mani pan-ipadyag kangkun Bapa ku, agana kaw maniwala kangku. ");
INSERT INTO blx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nuwa pandaygên kuy mani pan-ipadyag na kangku. Kabay agyan a yuku paniwalan, paniwalan yu dayi ya mani dinyag kuy mamakaupapas amên matandan yu buy mapukatan na idi kangku si Bapa buy idi yaku kana.” ");
INSERT INTO blx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gawan sa sinabin Jesus, dakpên nina dayin mani Judio, nuwa a laya nadakêp. ");
INSERT INTO blx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kabay nanguman naku si Jesus sa lipay Ilug Jordan, sa lugal la pinamawtismuwan Juan sabitun nuna. Nanugêl ya baydu ");
INSERT INTO blx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","buy malakêy tawuy naku kana. Sinabi la, “Ayin yabay dinyag si Juan na mamakaupapas, nuwa pêtêg ga kaganawan sinabi na tungkul sa tawun ati.” ");
INSERT INTO blx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Buy malakêy tawu bayduy nanampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dilag gisay liyaki ya naglagyun Lazaro sa baryun Bethania, kaawyun nay mapatêl na ya silan Maria buy si Marta. ");
INSERT INTO blx_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Si Maria, sabay ya namibulug pabangi sa bitis Panginuun buy pamakayari, pinunisan nan sabut na. Amêsên, dilag sakit si Lazaro. ");
INSERT INTO blx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kabay impasabin Marta buy si Maria kan Jesus, “Panginuun, nagsakit ta kakaidwan mun kaluguran.” ");
INSERT INTO blx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sên natandan Jesus ya abiin, sinabi nay, “A na ikamati ya sakit ta ati. Nalyari ya abiin amên maparangalan si Bapan Namalyari buy maparangalan naku êt ta Anak na.” ");
INSERT INTO blx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kakaidwan Jesus ya mipapatêl ya silan Marta, Maria buy si Lazaro. ");
INSERT INTO blx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Paraman baydu, sên nabalitan nay nagsakit si Lazaro, nanugêl yan luway allu sa binyanan na. ");
INSERT INTO blx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pamakayari, sinabi na sa mani tagasunul nay, “Mag-udung kitamina sa prubinsyan Judea.” ");
INSERT INTO blx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nakitbay sila kana, “Manuru, uysiyan labay muyan mag-udung ka sa Judea ta pakan dakun nakanu pun, labay kan batwan mani Judio baydu?” ");
INSERT INTO blx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nakitbay kalla si Jesus, “Alwa nayin dilag mapu buy luway uras ya nasawang sa gisay allu? Kabay ya mamita sa nasawang, a ya midumpul, gawan nasawang nga babun luta. ");
INSERT INTO blx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nuwa ya mamita sa yabi, midumpul ya gawan ayin nan sawang.” ");
INSERT INTO blx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pamakayari, sinabi pun êt Jesus, “Ya kaluguran tamun si Lazaro, mamabêlêw ya. Nuwa lakwên kuyan pêwên.” ");
INSERT INTO blx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kabay sinabin mani tagasunul na, “Panginuun, nu kay mamabêlêw ya, umiyul yapun.” ");
INSERT INTO blx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Indap la nu kay mamabêlêw si Lazaro, pakan ya labay sabin Jesus, nati yina. ");
INSERT INTO blx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kabay intusêk sinabin Jesus kallay, “Nati yana si Lazaro. ");
INSERT INTO blx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nuwa matula ku ya ayin naku baydu ta abiin na makakangêd kamuyu. Ta sa kapamilatan daygên ku, luyang kaw pun manampalataya kangku. Kaksaw kawna, ta lakwên tamu ya.” ");
INSERT INTO blx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Si Tomas ya pambêgên lan Kambal, sinabi na sa mani kaparisu nan tagasunul, “Kilaku kitamu kana agyan mati kitamun kaawyun na.” ");
INSERT INTO blx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sên inlumatêng si Jesus sa balayan Bethania, natandan nay apat tay allun nakalbêng si Lazaro. ");
INSERT INTO blx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kay tatluy kilumetruy dayun Bethania sa balayan Jerusalem. ");
INSERT INTO blx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kabay malakêy Judioy ubat sa Jerusalem ya nakun nakidamay kallan Marta buy kan Maria sa pangamatin patêl la. ");
INSERT INTO blx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sên nalêngên Martay inlumatêng ngana si Jesus, timbêng naya. Nuwa si Maria, nanugêl ya sa bali la. ");
INSERT INTO blx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sinabin Marta kan Jesus, “Panginuun, nu idi kata dayi baydi, asê dayi nati si Lazaro ya patêl ku. ");
INSERT INTO blx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nuwa paraman baydu, agyan amêsên, tanda kuy agyan sabêt man na yawarên mu kan Bapan Namalyari, idin na kamu.” ");
INSERT INTO blx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sinabin Jesus kanay, “Manguman mabyay ya patêl mu.” ");
INSERT INTO blx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nakitbay si Marta, “Tanda kuy mabyay ya sa tawlin allu nu pabyayên manguman na nangamamati.” ");
INSERT INTO blx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sinabin Jesus kanay, “Sikuy mam-in biyay buy sikuy mamabyay manguman sa mani nati. Ya manampalataya kangku, agyan mati ya, manguman yan mabyay. ");
INSERT INTO blx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Buy sisabêt man na nangabyay buy manampalataya kangkuy agyan mati ya, mabyay yan ayin katganan. Maniwala ka nayi sa sinabi ku?” ");
INSERT INTO blx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nakitbay si Marta, “Awuy Panginuun. Manampalataya kun sikay Cristuy Anak Bapan Namalyari ya pan-êtêngên yan lumatêng baydi sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pamakasabi nan abiin, nag-udung si Marta sa bali la buy dinanyan na si Maria buy in-ayas kanay, “Inlumatêng ngay Manuru. Pan-ipabêg naka.” ");
INSERT INTO blx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sên nalêngên Mariay abiin, tambêng yan nidêng buy naku kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Asê pun nilatêng si Jesus sa Bethania, ta idi yapun sa lugal nu saantu yan timbêng Marta. ");
INSERT INTO blx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sên nakitan mani Judioy makidamay kallay tambêng nidêng si Maria buy nag-awas, pikilakwan laya, ta indap la nu maku ya sa pinilbêngan kan Lazaro amên manangis. ");
INSERT INTO blx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pamakalatêng Maria sa binyanan Jesus, nanduku ya sa arapan na buy sinabi na, “Panginuun, nu idi kata dayi baydi, asê dayi nati ya patêl ku.” ");
INSERT INTO blx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sên nakitan Jesus ya manangis si Maria buy ya mani Judioy kaawyun na, nalunus ya buy nalugmay nakêm na. ");
INSERT INTO blx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pinatang na sila, “Antuy pinilbêngan yu kana?” Nakitbay sila, “Panginuun, kaksaw ka, ta êlêwên muya.” ");
INSERT INTO blx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nakatangis si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kabay sinabin mani Judio, “Elêwên yu nu parasaantu nan kakaidwan si Lazaro.” ");
INSERT INTO blx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nuwa sinabi yaman kaatag, “Pinaiyul nay liyaki ya bulag. Uysiyan pinaulayan nayan nati si Lazaro ta?” ");
INSERT INTO blx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kaban papakun silan Jesus sa pinilbêngan kan Lazaro, nanguman nalugmay nakêm na. Ya pinilbêngan kan Lazaro, gisay lêyang nga tinakpan gisay maragul la batu. ");
INSERT INTO blx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pamakalatêng la baydu, sinabin Jesus, “Itas yuy batu.” Nuwa nakitbay si Marta ya magpatêl sa nati, “Panginuun, nabatay na amêsên na bangkay na, ta apat tay allu nan nakalbêng.” ");
INSERT INTO blx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Sinabin Jesus kanay, “Alwa nayin sinabi kina kamuy nu manampalataya ka, makitan muy kapangyarian Bapan Namalyari?” ");
INSERT INTO blx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kabay intas lay batu. Nangêlêw si Jesus sa langit buy sinabi na, “Bapa, magpasalamat taku kamu, gawan inlêngê muku. ");
INSERT INTO blx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tanda kuy pawa mukun pallêng-ên, nuwa pansabin kuy ati para sa ikakangêd mani idi sa palitêng ku amên maniwala silan sikay namiutus kangku.” ");
INSERT INTO blx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pamakasabi nan abiin, masnêg nan sinabi, “Lazaro, magsalwang ka!” ");
INSERT INTO blx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kabay nagsalwang yabay si Lazaro ya nakabêlêbêl pun telay paglêbêng ya mani gamêt buy bitis na buy nakatakêp pun telay lupa na. Sinabin Jesus kallay, “Itas yuy telay nakabêlêbêl kana amên makabita ya.” ");
INSERT INTO blx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ya mani Judioy nakidamay kallan Maria, sên nakitan lay dinyag Jesus, malakê kallay nanampalataya kana. ");
INSERT INTO blx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nuwa ya kaatag kalla, naku sa mani Pariseo buy sinabi lay dinyag Jesus. ");
INSERT INTO blx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kabay impabêg mani mamunun pari buy mani Pariseoy kaganawan mangatwan Judioy mangatuynungan. Buy sên nititipun silayna, sinabi lay, “Sabêt ta daygên tamu? Malakêy nay mamakaupapas ya pandaygên tawun abiin. ");
INSERT INTO blx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu paulayan tamu ya, maniwalay kaganawan tawuy sabay siyay Cristu buy daygên layan ari tamu. Nu malyari ya abiin, lakwên kitamun mani sundalus Romano buy sirên lay Templu buy bansa tamu.” ");
INSERT INTO blx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nuwa gisa kalla si Caifas ya pinakapuun pari sa panawun abitu ya nagsabin, “Pêtêg yabay ayin kaw tanda. ");
INSERT INTO blx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","A yu nayi naisip pa mas mangêd da kay gigisay tawuy mati kaysa mipakadawak ka buun bansa?” ");
INSERT INTO blx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Alwan ubat sa sarilin Caifas ya sinabi na nun a bilang pinakapuun pari sa panawun abitu, impatanda nay pan-ipasabin Bapan Namalyari kana ya mati si Jesus para sa ikakangêd buun bansa. ");
INSERT INTO blx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Alwan kay para sa ikakangêd buun bansa, nun a para sa kaganawan anak Bapan Namalyari ya nikyat sa buun babun luta amên tipunun buy pibêtêkên sila. ");
INSERT INTO blx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kabay paubat ta baydu, nangisip silayna nu parasaantu lan ipapati si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kabay paubat ta baydu, a yina mamaku si Jesus sa piakit-akit mani Judio, nun a kay naku yata sa balayan Efraim ya narani sa kakyangan buy nanugêl ya baydu kaawyun ya mani tagasunul na. ");
INSERT INTO blx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sên narani yay pestan mani Judioy pambêgên Pestan Kaligtasan, malakêy tawuy ubat sa kaatag lugal Israel ya naku sa Jerusalem amên daygên na naugalyan lay pallinis bayu magpesta. ");
INSERT INTO blx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pantêkapên mani tawu si Jesus buy nipapatang sila sa kasawangan Templu, “Sabêt ta êlêw yu? Maku ya nayi baydi sa pesta?” ");
INSERT INTO blx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sa panawun abitu, nam-in utus ya mani mamunun pari buy mani Pariseo un paradi, “Nu tanda yuy binyanan Jesus, sabin yu kanyan.” In-utus lay abiin amên maipadakêp laya. ");
INSERT INTO blx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Anêm ma allu bayu miras ya Pestan Kaligtasan, naku si Jesus sa Bethania nu saantu manugêl si Lazaro ya pinabyay na. ");
INSERT INTO blx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kabay namil-an apunan na mani kaluguran Jesus ya silan Maria, Marta buy si Lazaro. Si Martay mangapag kalla buy gisa si Lazaro sa kaêm Jesus. ");
INSERT INTO blx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Si Maria, dilag yan kapitnan litruy makamal la pabangi ya pawan nardo. Pakanawa nan imbulug ga ati sa bitis Jesus buy pinunisan nan sabut na. Kabay sadyay bawun pabangi sa lalên bali. ");
INSERT INTO blx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Si Judas Iscariote ya gisa sa mani tagasunul Jesus ya sabay ya mamisupakat kana, idi ya êt baydu. Sinabi na, ");
INSERT INTO blx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ya pabangin abiin, alagan upan gisay tawu sa gisay tawun. Uysiyan a na yata insaliw buy ya naabli na, maidin sa mani kalulu?” ");
INSERT INTO blx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sinabin Judas ya abiin, alwan gawan magmalasakit ya sa mani kalulu nun a gawan mapanakaw ya. Tagawan sabay siyay manalan pera la, nuwa pallimêdên nay ati. ");
INSERT INTO blx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Sinabin Jesus, “Paulayên muya. Imbulug nay ati bilang pamil-an sa pamilbêng kangku. ");
INSERT INTO blx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pawa yun mapagkaawyun na mani kalulu. Nuwa siku, a yu pawan mapagkaawyun.” ");
INSERT INTO blx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Malakêy Judioy nakabalitan idi sa Bethania si Jesus. Kabay nipammaku sila baydu, alwan kay gawan kan Jesus nun a labay la êt makitan si Lazaro ya pinabyay na. ");
INSERT INTO blx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kabay pinalanun mani mamunun pari ya ipapati la êt si Lazaro. ");
INSERT INTO blx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tagawan sa pangabiyay nan manguman, malakêy Judioy nakisyay kalla buy nanampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pamakawasak, nabalitan malakêy tawuy nakipesta, ya maku si Jesus sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kabay nangwa silan mani palapan palma buy timbêng si Jesus. Mansaway silan magsabin, “Ulimênên na Bapan Namalyari! Pagpalên Bapan Namalyari ya mallumatêng sa lagyu na! Pagpalên na Arin Israel!” ");
INSERT INTO blx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nakasakay ya sa biserun asnu kaparisun nakasulat sa Sabin Bapan Namalyari, ");
INSERT INTO blx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sikaw wa mani tawuy idi sa balayan Zion, agana kaw malimu! Elêwên yu! Palatêng ngay ari yu ya nakasakay sa gisay biserun asnu!” ");
INSERT INTO blx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Asê pun mapukatan mani tagasunul na ya abiin na pandaygên mani tawu kana. Nuwa sên nag-udung nga si Jesus sa langit, baydu la pun napukatan ya si pangulimên mani tawu kana, sabay ya pantukuyun un kasulatan. ");
INSERT INTO blx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Sabitun binêg Jesus si Lazaro sa pinilbêngan kana buy pinabyay ya, malakêy nakakit. Kabay imbalita lay nalyari. ");
INSERT INTO blx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sên nabalitan malakêy tawuy mamakaupapas ya dinyag Jesus, timbêng laya. ");
INSERT INTO blx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kabay nisasabi ya mani Pariseo, “Elêwên yu ba! Ayin kitaminan madyag, ta manunul la kanay kaganawan tawu!” ");
INSERT INTO blx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Dilag dakun umnuy mani Griegoy naku sa pesta sa Jerusalem amên mangulimên kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nagdani sila kan Felipe ya taga Bethsaida sa prubinsyan Galilea. Sinabi la kana, “Patêl lay, labay yan dayin makit si Jesus.” ");
INSERT INTO blx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Inlakun Felipe si Andres buy sinabi kanay panyawarên mani Griego. Pamakayari, inlaku la si Jesus buy sinabi lay panyawarên la. ");
INSERT INTO blx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sinabin Jesus kallay, “Inlumatêng ngay uras ya sikuy ubat sa langit ta in-Anak Tawu, parangalên nakun Bapa ku. ");
INSERT INTO blx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Pansabin ku kamuyuy nu asê ilbêng nga lasi sa luta, manugêl yan kay gigisa. Nuwa nu ilbêng nga lasi sa luta buy mati, tumubu ya buy managêy yan malakê. ");
INSERT INTO blx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ya tawuy mamakamal biyay na, sabay ya matasan ati. Nuwa ya asê mamakamal biyay na baydi sa babun luta, sabay ya mabiyan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sisabêt man na kalabay maglingkud kangkuy sêpat yan manunul kangku. Buy nu antuy binyanan ku, idi ya êt baydu. Sisabêt man na maglingkud kangkuy parangalên yan Bapa ku.” ");
INSERT INTO blx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sinabi pun êt Jesus, “Naalipusan naku amêsên. Sabin ku nayi sa Bapay iligtas naku sa marani ya pamasakit? Asê, tagawan naku waku baydi amên madanasan na pamasakit ta abiin.” ");
INSERT INTO blx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pamakayari, sinabin Jesus, “Bapay, parangalên muy lagyu mu.” Nasên anti, bêngat natan nalêngêy tunuy Bapan Namalyari ya ubat sa langit ya magsabin, “Pinarangalan kina buy parangalên kun manguman.” ");
INSERT INTO blx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sên nalêngên mani tawuy idi bayduy tunuy, sinabi lay, “Nangilat!” Nuwa sinabi yaman kaatag, “Pakisabyan yan gisay ang-el.” ");
INSERT INTO blx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sinabin Jesus kallay, “Ya tunuy ya nalêngê yu, impalêngê alwan para kangku nun a para kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Inlumatêng ngay panawun pangatul Bapan Namalyari sa mani tawu sa babun luta. Buy si Satanas ya manakup kalla, masambut tana. ");
INSERT INTO blx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Buy nu itag-ay yakina, idani kuy kaganawan tawu kangku.” ");
INSERT INTO blx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sinabin Jesus ya abiin amên ipatanda nu parasaantu yan mati. ");
INSERT INTO blx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nakitbay kana ya mani tawu, “Idi sa Kasulatan Bapan Namalyari ya si Cristu, mabyay yan ayin katganan. Uysiyan sinabi muyay kaylangan itag-ay ya in-Anak Tawu ta? Sisabêt ta in-Anak Tawuy pansabin mu?” ");
INSERT INTO blx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nakitbay si Jesus, “Pêrad tay panawun na mapagkaawyun yuy dêkêt. Kabay kaban kaawyun yuy dêkêt, bumyay kaw sa sawang amên a kaw malatêng nadiglêm. Tagawan na mamita sa nadiglêm, a na tanda nu antuy lakwên na. ");
INSERT INTO blx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kaban kaawyun yuku pun bilang dêkêt yu, manampalataya kaw kangku amên masawangan na isip yu.” Pamakasabi nan abiin, namitay na si Jesus buy asina nagpakit kalla. ");
INSERT INTO blx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Agyan nakitan mani tawuy malakêy mamakaupapas ya dinyag Jesus, a sila pun êt nanampalataya kana. ");
INSERT INTO blx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sa pakapakun baydu, natupad da sinabin Propeta Isaias, “Panginuun, paran ayin naniwala sa in-aral yan. Agyan impakit mina kallay kapangyarian mu, a sila pun êt naniwala kamu.” ");
INSERT INTO blx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kabay a sila maniwala tagawan sinabi pun êt Isaias ya sangkan sabitun sinabi nay, ");
INSERT INTO blx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Binulag Bapan Namalyari ya mata la amên a sila makakit buy pinakdêy nay ulu la amên a sila makapukat, gawan dat mag-udung sila pun kana buy paiyulun na sila.” ");
INSERT INTO blx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Sinabin Propeta Isaias ya abiin gawan nakitan nay kadakilaan Jesus buy nagsabi ya tungkul kana. ");
INSERT INTO blx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Paraman baydu, malakêy puun mani Judioy nanampalataya kan Jesus. Nuwa a la impatanday panampalataya la gawan malimu sila sa mani Pariseo, ta dat isakwil sila sa balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tagawan inlabay la pun na parangalên silan mani tawu kaysa parangalên silan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Amêsên, nagsabin masnêg si Jesus, “Ya manampalataya kangku, alwan kay kangku ya manampalataya, nun a kan Bapan Namalyari ya sabay ya namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Buy ya nakakit kangku, nakakit êt sa namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naku waku baydi bilang dêkêt sa babun luta amên nu sisabêt man na manampalataya kangku, a yina manugêl sa kadlêman. ");
INSERT INTO blx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sisabêt man na nakalêngên pan-iaral ku nuwa a na pansunulun na abiin, maatulan ya. Nuwa alwan sikuy mangatul kana, tagawan naku waku baydi amên iligtas ya mani tawu, alwan amên atulun sila. ");
INSERT INTO blx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sisabêt man na asê mananggap kangku buy sa pan-iaral ku, dilag kaatag mangatul kalla sa allun pangukum sabay ya mani sabi ya in-aral ku kalla. ");
INSERT INTO blx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tagawan na pan-iaral kuy alwan ubat sa sarili ku nun a ubat sa Bapay namiutus kangku. Siyay namisabi nu sabêt ta sabin ku. ");
INSERT INTO blx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Buy tanda kinay ya mani utus nay mam-in biyay ya ayin katganan. Kabay nu sabêt ta pan-ipasabin Bapa, sabay ya pansabin ku.” ");
INSERT INTO blx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kinawasakan Pestay nan Kaligtasan. Tandan Jesus ya inlumatêng ngay panawun pamita na baydi sa babun luta amên mag-udung ya sa Bapa nay idi sa langit. Kakaidwan nay mani tagasunul na baydi sa babun luta buy impakit na kallay pangidu na angga sa katganan biyay na. ");
INSERT INTO blx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sa yabin abitu, kaban mangan si Jesus kaawyun na mani tagasunul na, pinaisipan nan Satanas si Judas ya anak Simon Iscariote ya isupakat nayna si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tandan Jesus ya kaganawan kapangyarian, indin nan Bapan Namalyari kana. Buy tanda na êt ta ubat ya kan Bapan Namalyari buy mag-udung ya êt kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kaban mangan sila, nidêng si Jesus. Intas nay latêp yaming na buy niyakês yan tuwalya sa awak na. ");
INSERT INTO blx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pamakayari, namibulug yan lanêm sa gisay palanggana. Inumpisan nan inuyasan na bitis mani tagasunul na buy pinunisan nan tuwalyay nakayakês sa awak na. ");
INSERT INTO blx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pamakadani na kan Simon Pedro, sinabin Simon kan Jesus, “Panginuun, siyan sika yay manguyas bitis ku ta?” ");
INSERT INTO blx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nakitbay si Jesus, “A mu mapukatan na pandaygên ku amêsên, nuwa lanu mapukatan mu.” ");
INSERT INTO blx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Sinabin Pedro kanay, “Asê malyarin sika ya manguyas mani bitis ku kanuman.” Nakitbay si Jesus, “Nu a ku uyasan na bitis mu, ayin kan pamikibêtêk kangku.” ");
INSERT INTO blx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kabay sinabin Simon Pedroy, “Nu parabayduy Panginuun, alwan kay bitis kuy uyasan mu, nun a agyan gamêt buy ulu ku!” ");
INSERT INTO blx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nuwa sinabin Jesus kanay, “Ya nagpaluyuy na, malinis say buun lawini na. Kabay a yina kaylangan uyasan pun, liban tay bitis na. Malinis kawna, nuwa alwan kaganawan kamuyu.” ");
INSERT INTO blx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kabay sinabin Jesus ya alwan kaganawan kallay malinis, gawan tanda na nu sisabêt ta mamisupakat kana. ");
INSERT INTO blx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sên nauyasan nan Jesus ya bitis la, inuman nan inyaming nga latêp na buy nanguman yan niknu sa panganan la. Pamakayari, pinatang na sila, “Napukatan yu nayi ya dinyag ku kamuyu? ");
INSERT INTO blx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pambêgên yukun ‘Manuru’ buy ‘Panginuun’. Ustu kaw, ta sikinay abitu. ");
INSERT INTO blx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nu sikuy manuru yu buy Panginuun yu ya nanguyas bitis yu bilang paglingkud ku kamuyu, sêpat yu êt daygên na parabaysên sa balang gisa. ");
INSERT INTO blx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dinyag kuy abiin kamuyu amên dilag kaw alimbaway pakitbusan yu. Kabay daygên yu êt ta dinyag ku kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Pansabin ku kamuyuy ayin ipus ya igit pun sa amung na buy ayin êt in-utus ya igit pun sa namiutus kana. ");
INSERT INTO blx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Amêsên, tanda yinay mani bagay ya abiin. Kabay nu daygên yuy abiin, pinagpala kaw.” ");
INSERT INTO blx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“A ku pansabin na pinagpala kaw kaganawan, ta kilala kuy mani pinili ku. Nuwa kaylangan matupad da idi sa Kasulatan ya paradi, ‘Isupakat takun gisa sa kaêm ku.’ ” ");
INSERT INTO blx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Pansabin ku kamuyuy ati bayu pun malyari amên nu nalyari yana, maniwala kaw wa sabay sikuy Cristu. ");
INSERT INTO blx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Pansabin ku kamuyuy sisabêt man na mananggap sa mani tawuy in-utus ku, sikinay tinanggap na. Buy sisabêt man na mananggap kangku, tinanggap naynay namiutus kangku.” ");
INSERT INTO blx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pamakasabin Jesus, nalugmay nakêm na. Sinabi nay, “Pansabin ku kamuyuy isupakat takun gisa kamuyu.” ");
INSERT INTO blx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Niêêlêw wa mani tagasunul na, ta a la tanda nu sisabêt ta pantukuyun na. ");
INSERT INTO blx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nakaunsalig sa danin Jesus ya kakaidwan nay tagasunul. ");
INSERT INTO blx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kabay siningyalan yan Simon Pedro amên patangên si Jesus nu sisabêt ta pantukuyun na. ");
INSERT INTO blx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kaban nakaunsalig ya sa danin Jesus, nangawing yan namatang, “Panginuun, sisabêt ta pantukuyun mu?” ");
INSERT INTO blx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nakitbay si Jesus, “Nu sisabêt ta biyan kun tinapay ya insawsaw, sabay siyay abitu.” Kabay nangwan tinapay si Jesus buy pamakayari nan insawsaw, indin na kan Judas ya anak Simon Iscariote. ");
INSERT INTO blx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pamakakwan Judas sa tinapay, nagsêdak ka kana si Satanas. Kabay sinabin Jesus kanay, “Ya pandaygên mu, parasên minan daygên.” ");
INSERT INTO blx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Asê napukatan mani kaêm na sa apunan ya siyan sinabi yan Jesus ya abitu ta. ");
INSERT INTO blx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nuwa gawan si Judas sa manalan pera la, indap kaatag nu kay pan-iutus yan Jesus manaliw kaylangan la sa pesta o mam-in limus sa mani kalulu. ");
INSERT INTO blx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pamakaêkan Judas un tinapay, tambêng yan namita. Yabi yay abitu. ");
INSERT INTO blx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sên nakabitay na si Judas, sinabin Jesus, “Sikuy ubat sa langit ta in-Anak Tawu, maparangalan nana. Buy sa kapamilatan ku, maparangalan êt si Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Buy nu sa kapamilatan kuy parangalên si Bapan Namalyari, parangalên naku êt buy tambêng nan daygên na ati.” ");
INSERT INTO blx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sinabi pun êt Jesus, “Mani anak kuway, naêpêk tay panawun na mapagkaawyun yuku. Têkapên yuku, nuwa a yuku makitan kaparisun sinabi ku sa mani Judio, ‘A kaw makalaku sa lakwên ku.’ ");
INSERT INTO blx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Amêsên, ati ya bayuy utus sa idin ku kamuyu. Miiidu kaw. Nu para kataw saantun inidu, para kaw êt baydun miiidu sa balang gisa. ");
INSERT INTO blx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nu miiidu kaw, matandan kaganawan tawuy tagasunul kataw.” ");
INSERT INTO blx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pinatang Simon Pedro si Jesus, “Panginuun, antuy lakwên mu?” Nakitbay si Jesus, “A ka pun makapikilaku sa lakwên ku amêsên, nuwa lanu, makalaku ka êt sa lakwên ku.” ");
INSERT INTO blx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pinatang pun êt Pedro si Jesus, “Panginuun, uysiyan a kuya malyarin makapikilaku kamu amêsên ta? Pakan nakal-an nakun mati para kamu.” ");
INSERT INTO blx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nakitbay si Jesus, “Pêtêg ka nayin nakal-an mati para kangku? Pansabin ku kamuy bayu mangkati ya manuk, katitlu mukun ipuglaw.” ");
INSERT INTO blx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sinabin Jesus kalla, “Agana kaw naalipusan. Magtiwala kaw kan Bapan Namalyari buy magtiwala kaw êt kangku. ");
INSERT INTO blx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Sa balin Bapa ku, malakêy kuwartu. Maku waku baydu amên il-an kataw mabiyan. A ku sabin na abiin nu alwan pêtêg. ");
INSERT INTO blx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pamakayari kun maku baydu buy nu nail-an kinay mabiyan yu, mag-udung ngaku buy pakilaku kataw na amên nu idi yaku saantu, idi kaw êt baydu. ");
INSERT INTO blx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Buy tanda yinay dan papakun sa lakwên ku.” ");
INSERT INTO blx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Sinabin Tomas kana, “Panginuun, parasaantu yan matandan ya dan, pakan a yan tanda nu antuy lakwên mu?” ");
INSERT INTO blx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nakitbay si Jesus, “Sikuy dan, sikuy kapêtêgan buy sikuy biyay. Ayin makalaku kan Bapa nu a ya duman kangku. ");
INSERT INTO blx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu kilala yuku, kilala yu êt ta Bapa ku. Buy paubat amêsên, kilala yuwina buy nakitan yinay Bapa.” ");
INSERT INTO blx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Sinabin Felipe kana, “Panginuun, ipakit mu kanyan na Bapa buy nukad dana kanyan na abiin.” ");
INSERT INTO blx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nakitbay si Jesus kana, “Felipe, mana yu kinan kaawyun. A muku pun êt nayi kilala? Ya nakakit kangku, nakakit ta kan Bapa. Uysiyan panyawarên mu yay ipakit ku kamuyuy Bapa ta? ");
INSERT INTO blx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A ka nayi maniwalan idi yaku kan Bapa buy idi êt kangkuy Bapa? Ya mani sabi ya pansabin ku kamuyuy alwan ubat kangku, nun a ubat kan Bapa ya idi kangku ya sabay ya manyag un mani pandaygên ku. ");
INSERT INTO blx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Maniwala kaw ya idi yakina kan Bapa buy idi êt kangkuy Bapa. Nu a kaw kalabay maniwala sa pansabin ku, maniwala kaw tana kangku gawan sa mani dinyag kuy mamakaupapas. ");
INSERT INTO blx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Pansabin ku kamuyuy ya manampalataya kangku, madyag na êt ta mani pandaygên ku buy igit pun di ya madyag na, tagawan papakun nakina kan Bapa. ");
INSERT INTO blx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Buy agyan dakun sabêt man na yawarên yu sa lagyu ku, daygên ku amên maparangalan si Bapa sa kapamilatan ku ya Anak na. ");
INSERT INTO blx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Awu, agyan sabêt man na yawarên yu sa lagyu ku, daygên ku.” ");
INSERT INTO blx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sinabin Jesus, “Nu kaidwan yuku, sunulun yuy mani utus ku. ");
INSERT INTO blx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Buy yawarên ku kan Bapay biyan nakaw pun gisay Manawup ya manugêl kamuyu kanuman. ");
INSERT INTO blx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Sabay siyay Ispiritun Bapan Namalyari ya manurun kapêtêgan. A ya matanggap mani tawuy asê manunul kan Bapan Namalyari, gawan a laya makitan buy a laya makilala. Nuwa sikaw, kilala yuya, tagawan kaawyun yuya buy manugêl ya kamuyu kanuman.” ");
INSERT INTO blx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“A kataw lakwanan ayin kaawyun. Mag-udung ngaku kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Asê mabuyut, a kina makitan mani tawuy asê manunul kan Bapan Namalyari, nuwa sikaw, makitan yuku. Buy gawan mabyay yakun manguman, mabyay kaw êt. ");
INSERT INTO blx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sa allun abitu, matandan yuy idi yaku kan Bapa buy idi kaw êt kangku buy idi yaku êt kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sisabêt man na mananggap buy manunul sa mani utus ku, sabay siyay mangidu kangku. Buy ya mangidu kangku, idun ya êt Bapa ku. Idun kuya êt buy ipakilala kuy sarili ku kana.” ");
INSERT INTO blx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Pinatang yan gisay Judas ya alwan si Judas Iscariote, “Panginuun, uysiyan kay kanyan kaya magpakilala ta? Uysiyan alwa yan sa kaganawan tawu ta?” ");
INSERT INTO blx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nakitbay si Jesus, “Ya mangidu kangku, pansunulun nay sabi ku. Kaidwan yan Bapa ku buy manugêl kay kana. ");
INSERT INTO blx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nuwa ya asê mangidu kangku, a ya manunul sa mani sabi ku. Buy ya mani sabi ya nalêngê yu, alwan ubat kangku, nun a ubat sa Bapa kuy namiutus kangku.” ");
INSERT INTO blx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Pansabin ku kamuyuy mani abiin kaban kaawyun yuku pun. ");
INSERT INTO blx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nuwa iutus Bapa kuy Ispiritu na kamuyu ya Manawup kamuyu bilang kasagili ku. Sabay siyay manuru kamuyun kaganawan buy siyay mipaganaka kamuyun kaganawan sinabi ku. ");
INSERT INTO blx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Agana kaw naalipusan buy agana kaw malimu, gawan bayu waku mita, idin ku sa bêkê yuy kapatêtbêkan. Ya kapatêtbêkan na idin ku kamuyu, alwan kaparisun kapatêtbêkan mani tawuy asê manunul kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nalêngê yuy sinabi ku, ‘Mita ku nuwa mag-udung ngaku êt kamuyu.’ Nu kaidwan yuku, ikatula yuy pamaku ku kan Bapa, gawan mas dakilay Bapa kaysa kangku. ");
INSERT INTO blx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pansabin ku kamuyuy ati bayu pun malyari amên nu nalyari yana, maniwala kaw kangku. ");
INSERT INTO blx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","A kina pakakarangên ya pagsabi ku tagawan palatêng nga si Satanas ya mag-ari sa mani tawuy asê manunul kan Bapan Namalyari. Ayin yan kapangyarian kangku. ");
INSERT INTO blx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nuwa kaylangan daygên kuy pan-iutus kangkun Bapa ku amên matandan kaganawan tawuy kakaidwan kuy Bapa ku. Kaksaw kawna, mita kitamina.” ");
INSERT INTO blx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Sinabi pun êt Jesus, “Sikuy pêtêg puun ubas buy Bapa kuy manaysay. ");
INSERT INTO blx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Pamputusun nay balang sanga kuy asê managêy buy pallinisin nay balang sangay managêy amên luyang pun managêy. ");
INSERT INTO blx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Malinis kawna gawan sa mani sabi ya sinabi ku kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Manugêl kaw kangku buy manugêl laku êt kamuyu. Asê malyarin managêy ya gisay sanga nu a ya manugêl nakatumpang sa puun. Para êt taman baydu, a kaw malyarin managêy nu a kaw manugêl kangku.” ");
INSERT INTO blx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Sikuy puun ubas buy sikaw wa mani sanga. Ya tawuy manugêl kangku buy manugêl laku êt kana, managêy yan malakê. Ta ayin kaw madyag nu nakasyay kaw kangku. ");
INSERT INTO blx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ya asê manugêl kangku, kaparisu yan sangay asê managêy ya pan-isamwag buy nayanguy na. Kabay ibuntun buy isamwag ya sa apuy amên maulam. ");
INSERT INTO blx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nu manugêl kaw kangku buy manugêl kamuyuy mani sabi ku, yawarên yuy agyan sabêt ta labay yu buy idin kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nu managêy kaw sadyay lakê, maparangalan na Bapa ku. Buy sa paradi ya paralan, mapagpapêtgan yuy mani tagasunul kataw.” ");
INSERT INTO blx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Kaidwan kataw kaparisun pangidu kangkun Bapa ku. Kabay manugêl kaw sa pangidu ku. ");
INSERT INTO blx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu pansunulun yuy mani utus ku, manugêl kaw sa pangidu ku kaparisun panunul ku sa mani utus Bapa ku buy manugêl laku sa pangidu na.” ");
INSERT INTO blx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Sinabi ku kamuyuy kaganawan abiin amên mapakamuyuy tula ku buy lubus pun êt ta tula yu. ");
INSERT INTO blx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ati ya utus ku kamuyu. Miiidu kaw kaparisun pangidu ku kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ayin nan pangiduy makaigit pun sa pangidun gisay tawuy nam-in biyay na para sa mani kaluguran na. ");
INSERT INTO blx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nu pansunulun yuy mani utus ku, kaluguran kataw. ");
INSERT INTO blx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","A kataw na pan-ituwad ipus, tagawan asê tandan ipus nu sabêt ta pandaygên amung na. Nun a intuwad kataw nan kaluguran, tagawan na kaganawan nalêngê ku sa Bapa ku, impatanda kina kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Alwan sikaw wa namili kangku, nun a sikuy namili kamuyu buy in-il-an kun mitan mangaral amên managêy kaw mani tagêy ya manugêl kanuman. Sa pakapakun baydu, sabêt man na yawarên yu kan Bapa sa lagyu ku, idin na kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Buy ati ya pan-iutus ku kamuyu, miiidu kaw sa balang gisa.” ");
INSERT INTO blx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Sinabi pun êt Jesus, “Nu nasulapu kamuyuy mani tawuy asê manunul kan Bapan Namalyari, ganakên yuy bayu lakaw kinasulapwan, sikina pun na kinasulapwan la. ");
INSERT INTO blx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu kabilang kaw sa mani asê manunul kan Bapan Namalyari, kaidwan la kaw. Nuwa a kaw kabilang sa mani tawuy asê manunul kan Bapan Namalyari, nun a pinili kataw ubat sa mani tawuy asê manunul kan Bapan Namalyari. Kabay nasulapu sila kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tandanên yuy sinabi ku kamuyu ya ayin ipus sa igit pun sa amung na. Nu pinasakit laku, pisakitin lakaw êt. Buy nu sinunul lay sabi ku, sunulun la êt ta sabi yu. ");
INSERT INTO blx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Daygên la kamuyuy kaganawan abiin gawan sa panunul yu kangku, ta a la kilalay namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nu a ku dayi naku baydi sa babun luta buy nangaral kalla, malyari lan sabin na a la tanday dilag silan kasalanan. Nuwa amêsên, ayin silaynan mapagsasangkanan sa mani kasalanan la. ");
INSERT INTO blx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ya nasulapu kangku, nasulapu êt sa Bapa ku. ");
INSERT INTO blx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nu a ku nanyag sa arap lan mani mamakaupapas ya kanuman asê nadyag agyan sisabêt man, malyari lan sabin na ayin silan kasalanan. Nuwa agyan nakitan lay nay mani mamakaupapas sa dinyag ku, kinasulapwan laku pun êt buy Bapa ku. ");
INSERT INTO blx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nuwa sa dinyag lan abiin, natupad day idi sa Kautusan la, ‘Kinasulapwan lakun ayin sangkan.’ ” ");
INSERT INTO blx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pamakayari, sinabin Jesus, “Iutus ku kamuyuy Ispiritu ya ubat kan Bapa ya sabay ya Manawup kamuyu buy mamipatandan kapêtêgan. Nu lumatêng ngina, magpapêtêg ya tungkul kangku. ");
INSERT INTO blx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Buy sikaw êt ta magpapêtêg tungkul kangku, tagawan ubat pun sabitun nuna, kaawyun kataw na.” ");
INSERT INTO blx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Sinabi kuy abiin kamuyu amên nu lumatêng nga pamisakit, a yu talibatukan na panampalataya yu kangku. ");
INSERT INTO blx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Isakwil kaw kaparisu yun mani Judio sa balin pagtipunan la. Buy lumatêng nga panawun na sisabêt man na mamati kamuyu, indap na nu sabay ya abiin na pagsuyu na kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Daygên lay mani abiin gawan a laku kilala buy a la kilalay Bapa ku. ");
INSERT INTO blx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sinabi kina kamuyuy abiin amên nu malyari yanay pamisakit, maganaka yuy sinabi ku kamuyu.” “A ku sinabi kamuyu sabitun nunay tungkul sa pamisakit, tagawan kaawyun yuku pun. ");
INSERT INTO blx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nuwa amêsên, pansabin ku kamuyuy abiin tagawan mag-udung ngakina sa namiutus kangku. Buy ayin tan gisa man kamuyuy namatang kangku nu antuy lakwên ku. ");
INSERT INTO blx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nuwa sên sinabi ku kamuyuy lakwên ku, ingkalungkut yu. ");
INSERT INTO blx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Paraman baydu, sêpat yun matandan na kapêtêgan. Ya pamita ku para sa ikakangêd yu, tagawan nu a ku mita, asê maku baydi ya Ispiritun Bapan Namalyari ya Manawup kamuyu. Nuwa nu nakabita kina, iutus kuya kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pamakalatêng Ispiritun Bapan Namalyari, ipapêtêg na sa mani tawuy asê manunul kan Bapan Namalyari ya asê ustuy pangintindi la tungkul sa kasalanan, tungkul sa pangamatinêk buy tungkul sa pangatul Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ipapêtêg na sa mani tawuy makasalanan sila, ta a sila nanampalataya kangku. ");
INSERT INTO blx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ipapêtêg na sa mani tawuy matinêk kaku, ta papakun nakina sa Bapa buy a yu kina makitan. ");
INSERT INTO blx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ipapêtêg na êt kallay atulun Bapan Namalyari ya mani tawuy asê manunul kan Bapan Namalyari, ta inatulan nayna si Satanas ya manakup sa mani tawuy asê manunul kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Malakê pun dayi ya sabin ku kamuyu, nuwa a yu pun agyun mapukatan amêsên. ");
INSERT INTO blx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nuwa pamakalatêng Ispiritun mamipatandan kapêtêgan, sabay siyay manawup kamuyu amên mapukatan yuy kaganawan kapêtêgan. Ta a ya magsabin kay ubat sa sarili na, nun a abituy nalêngê na kan Bapan Namalyari ya sabay ya sabin na buy ipatanda na kamuyuy tungkul sa malyari lanu. ");
INSERT INTO blx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Parangalên nakun Ispiritun Bapan Namalyari gawan ya kaganawan kapêtêgan na ipatanda na kamuyu, ubat kangku. ");
INSERT INTO blx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ya kaganawan idi sa Bapa, idi êt kangku. Kabay sinabi kuy maubat kangkuy kaganawan ipatandan Ispiritun Bapan Namalyari kamuyu.” ");
INSERT INTO blx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sinabin Jesus, “Naêpêk tay panawun, a yu kina makitan, nuwa pamakayarin naêpêk ka panawun, makitan yu kinan manguman.” ");
INSERT INTO blx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nipapatang nga dakun umnuy mani tagasunul na, “Sabêt ta labay nan sabin? Siyan sinabi nayay naêpêk tay panawun, a tamuy na makitan ta, nuwa pamakayarin naêpêk ka panawun, makitan tamu yan manguman? Sabêt êt ta labay nan sabin ya, ‘tagawan maku waku kan Bapa’? ");
INSERT INTO blx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Sabêt êt ta labay nan sabin na, ‘Naêpêk tay panawun’? A tamu mapukatan na labay nan sabin.” ");
INSERT INTO blx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tandan Jesus ya mamatang dayi ya mani tagasunul na. Kabay sinabi na kallay, “Pipapatangan yu nayi nu sabêt ta labay kun sabin sa sinabi kun, ‘Naêpêk tay panawun, a yu kina makitan, nuwa pamakayarin naêpêk ka panawun, makitan yu kinan manguman’? ");
INSERT INTO blx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Pansabin ku kamuyuy manangis kaw manyubêk sa malyari kangku, nuwa matulay mani tawuy asê manunul kan Bapan Namalyari. Maglungkut kaw, nuwa ya paglungkut yu, masagilyan tula. ");
INSERT INTO blx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kaparisun gisay babayi ya makatanam ilab, gawan inlumatêng ngay uras panganak na. Nuwa pamakayari nan nanganak, a nayna maganakay ilab na gawan sa tula na sa gisay kulaw wa naianak na. ");
INSERT INTO blx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Para kaw êt baydu. Maglungkut kaw amêsên, nuwa sa allun pamikakit tamun manguman, matula kaw buy ayin sisabêt man na makapitas tula yu.” ");
INSERT INTO blx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Sa allun abitu, ayina kaylangan mamatang kangku. Pansabin ku kamuyuy idin Bapa ya agyan sabêt man na yawarên yu kana sa lagyu ku. ");
INSERT INTO blx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Angga amêsên, ayin kaw pun inyawad kana sa kapamilatan lagyu ku. Manyawad kaw buy makatanggap kaw amên magin lubus ya tula yu.” ");
INSERT INTO blx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Sinabi pun Jesus, “Pansabin kuy mani abiin kamuyu sa kapamilatan paalimbawa. Nuwa lumatêng nga panawun ya a kina magsabi kamuyun paradi, nun a ipapakatulyag kina kamuyuy tungkul kan Bapa. ");
INSERT INTO blx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sa allu êt abitu, sikaw way manyawad kan Bapa sa kapamilatan lagyu ku. Alway nan sikuy manyawad kan Bapa para kamuyu. ");
INSERT INTO blx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ta kakaidwan kaw Bapa, tagawan inidu yuku buy maniwala kaw ya ubat taku kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ubat taku kan Bapa buy naku waku baydi sa babun luta. Nuwa amêsên, mita kinan mag-udung kan Bapa.” ");
INSERT INTO blx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kabay sinabin mani tagasunul nay, “Amêsên magsabi kaynan tulyag kanyan buy alway nan paalimbawa. ");
INSERT INTO blx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Amêsên, tanda yan na tanda muy kaganawan bagay. Agyan a yan kaw pampatangên, tanda mu nu sabêt ta ipatang yan. Kabay maniwala kay ya ubat ka kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Sinabin Jesus kalla, “Pêtêg kalin manampalataya kawna amêsên kangku? ");
INSERT INTO blx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nadanidani yay uras ya mangapisisyay kawna buy mangapipapaway balang gisa. Lakwanan yuku nuwa paraman baydu, a ku magpagisa gawan kaawyun kuy Bapa ku. ");
INSERT INTO blx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sinabi ku kamuyuy abiin amên mabiyan kaw kapatêtbêkan sa pamikibêtêk yu kangku. Baydi sa babun luta, makadanas kaw kasakitan. Nuwa pas-êyên yuy nakêm yu, gawan nasambut kinay nadawak ka kapangyarian babun luta.” ");
INSERT INTO blx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pamakasabin Jesus sa mani abiin, nangêlêw ya sa langit buy nanalangin yan paradi, “Bapa, inlumatêng ngay uras. Parangalên mu kinay Anak mu amên maparangalan kata. ");
INSERT INTO blx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tagawan binyanan mukun kapangyarian sa kaganawan tawu amên mabiyan biyay ya ayin katganan ya kaganawan tawuy indin mu kangku. ");
INSERT INTO blx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ya mani tawuy mangilala kamun sikay pêtêg buy gigisay Bapan Namalyari buy mangilala kangkun sikuy in-utus mu, sabay silay mabiyan biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pinarangalan kata baydi sa babun luta, ta inyari kinay impadyag mu kangku. ");
INSERT INTO blx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kabay amêsên ya Bapa, parangalên mukina sa arapan mu kaparisun karangalan ku sabitun idi yaku sa lukup mu bayu pun daygên ya babun luta.” ");
INSERT INTO blx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Impakilala katay na sa mani tawuy indin mu kangku ubat sa mani tawu baydi sa babun luta. Kamu sila buy indin mu sila kangku buy sinunul lay sabi mu. ");
INSERT INTO blx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tanda layna amêsên ya si kaganawan indin mu kangkuy ubat kamu. ");
INSERT INTO blx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tagawan impatanda ku kallay aral la impatanda mu kangku buy tinanggap la. Tanda la êt ta ubat taku kamu buy naniwala silan in-utus muku.” ");
INSERT INTO blx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Manalangin naku para kalla. A ku manalangin para sa mani tawuy asê manunul kan Bapan Namalyari nun a para sa mani tawuy indin mu kangku, tagawan kamu sila. ");
INSERT INTO blx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ya kaganawan kangku, kamu êt. Buy ya kaganawan kamu, kangku êt buy maparangalan naku sa kapamilatan la. ");
INSERT INTO blx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Buy amêsên, mag-udung ngakina kamu buy a kina manugêl baydi sa babun luta, nuwa manugêl sila pun sa babun luta. Banal la Bapa, illagan mu sila sa kapamilatan kapangyarian lagyuy indin mu kangku amên mapibêtêk sila kaparisu ta. ");
INSERT INTO blx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kaban kaawyun laku pun, illagan ku sila sa kapamilatan kapangyarian lagyu muy indin mu kangku. Buy ayin kallay milaku sa ayin katganan na kaparusan liban ta sa tawuy intakday na sa ayin katganan na kaparusan amên matupad da idi sa Kasulatan.” ");
INSERT INTO blx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Amêsên, mag-udung ngakina kamu. Buy pansabin ku kallay abiin kaban idi yaku pun baydi sa babun luta amên lubus ya tula la kaparisun tula ku. ");
INSERT INTO blx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Impatanda kina kallay sabi mu buy kinasulapwan silan mani tawuy asê manunul kamu, tagawan a silayna kabilang sa mani tawuy asê manunul kamu, kaparisu kun asê kabilang kalla. ");
INSERT INTO blx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A ku manalangin ya kêwên mu silayna sa babun lutan ati, nun a manalangin nakun illagan mu sila laban kan Satanas. ");
INSERT INTO blx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A sila kabilang sa mani tawuy asê manunul kamu, kaparisu kun asê kabilang sa mani tawuy asê manunul kamu. ");
INSERT INTO blx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ipakal-an mu sila ya magin kay kamu sa kapamilatan kapêtêgan. Ya sabi mu sabay ya kapêtêgan. ");
INSERT INTO blx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nu parasaantu mukun in-utus sa babun luta, para ku sila êt baydun pan-iutus. ");
INSERT INTO blx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Alang-alang kalla, impakal-an kuy sarili ku para kamu amên ipakal-an sila êt para kamu sa kapamilatan kapêtêgan.” ");
INSERT INTO blx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ya panalangin ku, alwan kay para sa mani tagasunul ku, nun a para êt sa mani manampalataya kangku sa kapamilatan pangaral la. ");
INSERT INTO blx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Manalangin naku kamuy Bapa ya silan kaganawan, pakadyag gigisa kaparisun pamikibêtêk mu kangku buy pamikibêtêk ku kamu. Kibêtêk ta dayi sila kanta amên maniwalay mani tawu ya in-utus muku. ");
INSERT INTO blx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Indin kina kallay karangalan na indin mu kangku amên pakadyag silan gigisa kaparisu ta ya gigisa. ");
INSERT INTO blx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nakibêtêk kaku kalla buy nakibêtêk ka êt kangku amên lubus silan mapibêtêk. Sa pakapakun baydu, matandan mani tawu sa babun luta ya in-utus muku buy matandan la êt ta kakaidwan muy mani manampalataya kangku kaparisun pangidu mu kangku.” ");
INSERT INTO blx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Bapay, indin mu sila kangku. Buy labay kun makaawyun ku sila sa lakwên ku amên makit lay karangalan ku ya indin mu kangku gawan inidu mukina bayu pun dinyag ga babun luta. ");
INSERT INTO blx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bapa kun Namalyari ya makatuynungan, a ka kilalan mani tawuy asê manunul kamu, nuwa kilala kata buy tandan mani tagasunul kuy sikay namiutus kangku. ");
INSERT INTO blx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impakilala katay na kalla buy pan-isundu katan pan-ipakilala amên na pangidu mu kangku, manugêl kalla buy manugêl laku êt kalla.” ");
INSERT INTO blx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pamakayarin nanalangin Jesus, namita ya kaawyun na mani tagasunul na buy naglipay sa sapan Kidron buy naku sa lugal la panggitnan ulibu. ");
INSERT INTO blx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Si Judas Iscariote ya mamisupakat kan Jesus, tanda nay lugal abitu, gawan pawan mamaku si Jesus baydu kaawyun na mani tagasunul na amên mipupulung. ");
INSERT INTO blx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kabay naku baydu si Judas kaawyun nay gisay grupun mani Romanoy sundalus buy dakun umnuy Judioy magbantay sa Templu ya in-utus mani mamunun pari buy mani Pariseo. Dilag silan gêgtan na sulu, atang buy mani almas. ");
INSERT INTO blx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tandan Jesus ya kaganawan malyari kana. Kabay timbêng na sila buy pinatang, “Sisabêt ta pantêkapên yu?” ");
INSERT INTO blx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nakitbay sila, “Si Jesus ya taga Nazaret.” Sinabin Jesus kallay, “Sikuy Sikina.” Idi êt bayduy mamisupakat ya si Judas ya nakaidêng kaawyun na mani tawuy mangkap kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sên sinabin Jesus ya “Sikuy Sikina,” nakadêtna sila buy nitugaw. ");
INSERT INTO blx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kabay nanguman namatang si Jesus, “Sisabêt ta pantêkapên yu?” Nakitbay sila, “Si Jesus ya taga Nazaret.” ");
INSERT INTO blx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Sinabin Jesus kallay, “Sinabi kina kamuyuy Sikuy Sikina. Kabay nu sikuy pantêkapên yu, paulayan yun makabitay mani kaawyun ku.” ");
INSERT INTO blx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sinabi nay abiin amên matupad da sinabi na sa Bapa, “Ayin gisa man na mipakadawak sa mani indin mu kangku.” ");
INSERT INTO blx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Amêsên, nanganus kêya si Simon Pedro buy pinutus nay têk ipus pinakapuun pari sa wanan. Ya lagyun abituy ipus, Malco. ");
INSERT INTO blx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nuwa sinabin Jesus kan Pedro, “Isakêb muy kêya mu sa kaluban! Sêpat kun tanggapên na kasakitan na indin kangkun Bapa ku.” ");
INSERT INTO blx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Amêsên, ya mani Romanoy sundalus, ya kapitan la buy mani Judioy magbantay sa Templu, dinakêp la si Jesus buy inggapus. ");
INSERT INTO blx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Gintan yapun kan Anas ya sabay ya ampun Caifas. Sa panawun na abitu, si Caifas ya pinakapuun pari ");
INSERT INTO blx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","buy sabay siyay nagsabi sabitun nuna sa mani puun Judio un paradi, “Mangêd da kay gigisay tawuy mati amên asê mipakadawak ya buun bansa.” ");
INSERT INTO blx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nanunul si Simon Pedro kan Jesus kaawyun nay gisa pun na tagasunul. Ya tagasunul la ati, kilala yan pinakapuun pari. Kabay nakasun yan kaawyun Jesus sa sural pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nagpalakwan si Pedro sa lawasan pasbul. Kabay nagsalwang nga tagasunul la kakilalan pinakapuun pari buy nakisabi ya sa babayi ya mamantay sa pasbul. Sinabi na, “Malyari nayin pasunun muy kaawyun ku?” Kabay pinasun nayna si Pedro. ");
INSERT INTO blx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pinatang babayi si Pedro, “Alwa nayin gisa ka sa mani tagasunul tawun abiin?” Nakitbay si Pedro, “Asê!” ");
INSERT INTO blx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nalêpêt ta uras abitu. Kabay nag-atug ga mani ipus buy mani magbantay buy nititipun sila sa palitêng apuy amên mimudu. Nakiawyun êt si Pedro kalla buy nimudu. ");
INSERT INTO blx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sa uras êt abitu, pinatang pinakapuun pari si Jesus tungkul sa mani tagasunul na buy sa pan-iaral na. ");
INSERT INTO blx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nakitbay si Jesus, “Pawa kun mangaral sa arapan mani tawu sa kasawangan Templu buy sa mani balin pagtipunan mani Judio. Ayin nakun pan-iliim sa pagsabi ku. ");
INSERT INTO blx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Siyan siku yay pampatangên mu ta? Ya patangên minaman, abituy mani nakalêngê kangku, ta tanda la nu sabêt ta sinabi ku.” ");
INSERT INTO blx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pamakasabin Jesus abiin, dinalpi yan gisa sa mani magbantay buy sinabi nay, “Alwa ta para kaya baydun makitbay sa pinakapuun pari ta?” ");
INSERT INTO blx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pikitbayan yan Jesus, “Nu dilag gakun sinabi ya asê ustu, papêtgan mu. Nuwa nu ustuy sinabi ku, siyan dinalpi muku yata?” ");
INSERT INTO blx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kaban nakagapus pun si Jesus, impalaku yan Anas kan Caifas ya sabay ya pinakapuun pari. ");
INSERT INTO blx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kaban mamimudu pun si Simon Pedro, sinabi kanan mani idi bayduy, “Pakan gisa kaya sa mani tagasunul na ta?” Nakitbay si Pedro, “Asê!” ");
INSERT INTO blx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pinatang ya êt gisa sa mani ipus pinakapuun pari ya kamag-anak pinutusan nan têk, “Alwa nayin sikay nakitan ku ya kaawyun Jesus sa panggitnan ulibu?” ");
INSERT INTO blx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nanguman nagpuglaw si Pedro buy sa uras êt abitu, nangkati ya manuk. ");
INSERT INTO blx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sên mawatwat tana, kingwan mani puun Judio si Jesus sa balin Caifas buy gintan la sa palasyun Gobernador Pilato. Nuwa asê sinumun na mani Judio sa palasyu gawan ayun sa kautusan la, nu sumun sila sa balin gisay alwan Judio, maituwad silan madinat buy a silayna sêpat mangan apunan sa Pestan Kaligtasan. ");
INSERT INTO blx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kabay nagsalwang si Gobernador Pilato buy pinatang na sila, “Sabêt ta isangkan yu laban sa tawun ati?” ");
INSERT INTO blx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nakitbay sila, “Gobernador, nu asê nanyag nadawak ka tawun ati, a yan ya gêtan baydi.” ");
INSERT INTO blx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sinabin Gobernador Pilato kalla, “Kêwên yuya buy sikaw tay mangatul ayun sa kautusan yu.” Nakitbay ya mani puun mani Judio, “Nuwa ayin kay karapatan mangatul kamatyan.” ");
INSERT INTO blx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nalyari ya abiin amên matupad da sinabin Jesus nu parasaantuy kamatyan na danasên na. ");
INSERT INTO blx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nanguman sinumun si Gobernador Pilato sa palasyu buy impabêg si Jesus buy pinatang naya, “Sika nayi ya Arin mani Judio?” ");
INSERT INTO blx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nakitbay si Jesus, “Ubat nayi kamuy abiin na patang o kay dilag nagsabi kamu tungkul kangku?” ");
INSERT INTO blx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nakitbay si Gobernador Pilato, “Alwa kun Judio. Ya mani kaparisu mun Judio buy mani mamunun pari sabay silay nilaku kamu baydi kangku. Sabêt ta dinyag mu?” ");
INSERT INTO blx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Sinabin Jesus kanay, “Ya kaarian ku, ayin baydi sa babun luta. Ta nu baydi dayi ya kaarian ku, inlumaban nay mani tagasunul ku amên a ku madakêp mani Judio. Nuwa alwan baydi ya kaarian ku.” ");
INSERT INTO blx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sinabin Gobernador Pilato, “Nu parabaydu, gisa kan ari!” Nakitbay si Jesus, “Ustuy sinabi mun gisa kun ari. In-anak kaku baydi sa babun luta amên magpapêtêg tungkul sa kapêtêgan. Sisabêt man na kalabay makatandan kapêtêgan, mallêngê ya kangku.” ");
INSERT INTO blx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pinatang yan Gobernador Pilato, “Sabêt ta kapêtêgan?” Pamakasabin Pilaton abiin, nagsalwang ya buy sinabi na sa mani Judio, “Ayin nakun nakitan na kasalanan sa tawun ati. ");
INSERT INTO blx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nuwa ayun sa naugalyan yu, balang Pestan Kaligtasan, panyawarên yu kangkuy mamibus sakun gisay nakasukul. Amêsên, labay yu nayin ibus kuy Ari yun mani Judio?” ");
INSERT INTO blx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Masnêg sinabin mani tawuy, “Alwan siya! Si Barabbas saman!” Si Barabbas, gisa yan manalangsang sa gubernu. ");
INSERT INTO blx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kabay impakwan Gobernador Pilato si Jesus buy impalatiku. ");
INSERT INTO blx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nanyag ga mani sundalus un kuronay nagdiwi buy impakurona la kan Jesus. Buy pinayamingan layan kulay muraduy balabal. ");
INSERT INTO blx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Pamakayari, tisatisa silan nagdani kana buy nagsabin panguyam, “Pagpalên baman na Arin mani Judio!” Buy pagkadinalpi laya. ");
INSERT INTO blx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nanguman nag-awas si Gobernador Pilato buy sinabi na sa mani tawuy, “Mallêngê kaw! Iarap kuyan manguman kamuyu amên matandan yuy ayin nakun nakitan na kasalanan kana!” ");
INSERT INTO blx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Buy in-awas la si Jesus ya nakakuronay nan diwi buy nakayaming ngan batêk muraduy balabal. Sinabin Gobernador Pilato kalla, “Elêwên yuya!” ");
INSERT INTO blx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sên nakitan yan mani mamunun pari buy mani magbantay sa Templu, masnêg lan sinabi, “Ipaku ya sa kurus! Ipaku ya sa kurus!” Nuwa nakitbay si Gobernador Pilato, “Kêwên yuya. Pakabaala kaw nay mipaku kana sa kurus, gawan para kangku, ayin nakun makit ta kasalanan kana.” ");
INSERT INTO blx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nakitbay ya mani Judio, “Ayun sa kautusan yan, sêpat yan mati, gawan pansabin nay Anak yan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sên nalêngên Pilatoy sinabi la, luyang nginan nalimu. ");
INSERT INTO blx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kabay impikilakun Gobernador Pilato si Jesus sa lalên palasyu buy pinatang, “Taga saantu ka?” Nuwa asê nakitbay si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kabay sinabin Pilatoy, “Siyan a muku ya pakitbayan ta? A mu nayi tanday dilag gakun kapangyarian ipabus ka o ipapaku ka sa kurus?” ");
INSERT INTO blx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nakitbay si Jesus, “Ayin kan madyag kangku nu a ka binyanan Bapan Namalyarin kapangyarian. Kabay mas maragul la kasalanan tawuy nilaku kangku baydi kamu.” ");
INSERT INTO blx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sên nalêngên Pilatoy abiin, nangisip yan paralan amên ibus si Jesus. Nuwa masnêg sinabin mani Judioy, “Nu ibus muy tawun abiin, a ka kaluguran Emperador! Tagawan nu sisabêt man na magsabin ari ya, kapati yan Emperador.” ");
INSERT INTO blx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sên nalêngên Gobernador Pilatoy abiin, in-awas na si Jesus sa palasyu. Pamakayari, niknu ya sa pallitisan sa lugal la pambêgên “Tinapil la Batu” ya sa sabin Hebreo, “Gabatha.” ");
INSERT INTO blx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sên ugtuy nan mamut duspiras Pestan Kaligtasan, sinabin Gobernador Pilato sa mani Judioy “Abiti yay ari yu!” ");
INSERT INTO blx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nuwa masnêg sinabin mani Judioy, “Patin ya! Patin ya! Ipaku ya sa kurus!” Kabay sinabin Gobernador Pilato kallay, “Ipaku ku nayi sa kurus ya ari yu?” Nakitbay ya mani mamunun pari, “Ayin kay kaatag ga ari, nun a kay ya Emperador.” ");
INSERT INTO blx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kabay inggawang Gobernador Pilato si Jesus kalla amên ipaku ya sa kurus. Gintan mani sundalus si Jesus ");
INSERT INTO blx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","pasalwang sa balayan. Buy impabakay la kanay kurus papakun sa lugal la pambêgên lan “Lugal Bungu” ya sa sabin Hebreo, Golgota. ");
INSERT INTO blx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pamakalatêng la baydu, impaku laya kaawyun na luwa. Ya gisa, idi sa wanan na buy ya gisa, idi sa udi na buy idi sa bunak la si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Impab-in Gobernador Pilaton karatula ya kurus Jesus buy paradi ya impasulat na, “Si Jesus ya taga Nazaret ya Arin mani Judio.” ");
INSERT INTO blx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nakasulat ta abiin sa sabin Hebreo, Latin, buy Griego. Malakêy Judioy nakabasan ati, gawan kay narani sa balayan ya pinipakwan kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kabay sinabin mani mamunun pari kan Gobernador Pilato, “Agana mu isulat ya ‘Arin mani Judio’ nun a ya isulat mu, ‘Sinabin tawun ati siyay Arin mani Judio.’ ” ");
INSERT INTO blx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nuwa pikitbayan silan Gobernador Pilato, “Nu sabêt ta impasulat ku, sabay yana.” ");
INSERT INTO blx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sên naipakuy nan mani sundalus si Jesus sa kurus, kingwa lay mani yaming na buy piaatagan lan apat, tisatisay balang sundalus. Kingwa la êt ya yaming nay makarang nga panglalê. Ayin tayi ya ati ubat sa babu angga sa aypa. ");
INSERT INTO blx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kabay nisasabi ya mani sundalus, “Agana tamina ginitin ya ati nun a mibabagutan kitamu tana nu kansabêt milakuy ati.” Nalyari ya ati amên matupad da idi sa Kasulatan, “Piaatagan lay mani yaming ku buy pibabagutan la.” Buy dinyag yabay mani sundalus ya abiin. ");
INSERT INTO blx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Baydu sa danin kurus Jesus nakaidêng nga indu na, ya patêl indu nay babayi, si Maria ya asawan Cleopas buy si Mariay taga Magdala. ");
INSERT INTO blx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sên nakitan Jesus ya indu na buy ya kakaidwan nay tagasunul ya idi sa danin indu na, sinabi na, “Tuwa kuway, ibilang muyan anak mu.” ");
INSERT INTO blx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Buy sinabi na sa tagasunul na, “Ati ya indu mu.” Kabay paubat ta baydu, in-uli yan tagasunul ya kakaidwan Jesus sa bali na ya indu na. ");
INSERT INTO blx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tandan Jesus ya naganap pay impadyag kanan Bapa na. Kabay sinabi nay, “Napêl-ang ngaku.” Sinabi nay abitu amên matupad da idi sa Kasulatan. ");
INSERT INTO blx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dilag baydun gisay banga ya napnun nangisuy alak. Kabay insawsaw mani sundalus sa nangisuy alak ya paran bulak ya nakaptês sa sangan isopu buy impasêpsêp kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Sên nasêpsêp pan Jesus, sinabi nay, “Naganap pana.” Indêngdêng nay ulu na buy nabuytuwan yan inawanên. ");
INSERT INTO blx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Allun Bernis sa abitu buy asê labay mani Judion idi pun sa kurus ya mani bangkay angga sa Allun Pagpaynawa. Luyang maulagay Allun Pagpaynawan ati gawan allu êt Pestan Kaligtasan. Kabay inyawad la kan Pilatoy, “Gobernador ray, ipatukis minay asêl mani impaku sa kurus buy itabuy ya mani bangkay la.” ");
INSERT INTO blx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kabay abiin ya dinyag mani sundalus. Tinukis lay asêl luway impakun kaawyun Jesus. ");
INSERT INTO blx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nuwa pamakalatêng la kan Jesus, nakitan lay nati yina. Kabay a layna tinukis ya asêl na, ");
INSERT INTO blx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","nun a inlatug gisa sa mani sundalus ya tagyang Jesus buy tambêng nanukusuk ka daya buy lanêm. ");
INSERT INTO blx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Siku si Juan ya nakakit abiin. Pêtêg ya nakitan ku buy pan-ipapêtêg kuy ati kamuyu amên manampalataya kaw êt. ");
INSERT INTO blx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nalyari ya kaganawan abiin amên matupad da idi sa Kasulatan, “Ayin matukis gisa man sa mani but-u na.” ");
INSERT INTO blx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Buy idi pun êt sa kaatag ga baagin Kasulatan, “Papakaêlêwên lay tawuy inlatug la.” ");
INSERT INTO blx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Amêsên, si Jose ya taga Arimatea, gisa yan tagasunul Jesus nuwa kay liim gawan malimu ya sa mani puun Judio. Inyawad na kan Pilatoy kêwên ya bangkay Jesus buy tinulutan naya. Kabay inlaku nay bangkay Jesus buy kingwa nay ati. ");
INSERT INTO blx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kaawyun na si Nicodemo ya sabay ya nagpaksa kan Jesus sabitun gisay yabi. Dilag bay-in maigit tatlumpuy kilun pabangi ya gêgtan na ya diyag sa mira buy aloe. ");
INSERT INTO blx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kaban pambêdbêdan lan makamal la telay bangkay na, pagkabulugan layan pabangi, ta abituy naugalyan mani Judio sa pamilbêng. ");
INSERT INTO blx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sa lugal nu saantu impaku si Jesus, dilag panamnan. Buy dilag êt baydun gisay bayuy pamilbêngan na inlubtan sa agid tung-uy ya asê pun pinilbêngan kanuman. ");
INSERT INTO blx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Allun paglêan na abiin para sa Allun Pagpaynawa. Buy narani sa inlubtan na dapas ya dinyag lay pamilbêngan. Kabay baydu layna in-ilbêng si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pamakagalingaldaw allun Duminggu, kaban nadiglêm pun, naku si Mariay taga Magdala sa pinilbêngan kan Jesus. Nakitan nay intas say batuy pinanakêp sa lawasan ati. ");
INSERT INTO blx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kabay nuwayu yan naku kan Simon Pedro buy sa tagasunul ya kakaidwan Jesus buy sinabi na kallay, “Dilag nangwa sa Panginuun baydu sa pinilbêngan kana buy a yan tanda nu antuy pinilakwan kana.” ");
INSERT INTO blx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kabay naku si Pedro sa pamilbêngan kaawyun nay tagasunul ya kakaidwan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Parisu silan nuwayu, nuwa mabilis pun ya tagasunul la kakaidwan Jesus kaysa kan Pedro. Kabay niuna yan nilatêng sa pamilbêngan. ");
INSERT INTO blx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A ya sinumun sa pamilbêngan ta kay nagduku ya buy nanilip. Nakit na bayduy telay makamal la pinamêdbêd kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sên nilatêng si Simon Pedro, nagdaus yan sinumun sa pamilbêngan buy nakitan nay telay makamal ya idi sa pinikalêkan kan Jesus. ");
INSERT INTO blx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Buy ya telay pinamêdbêd sa ulun Jesus, siyan napakapalay na buy nakapapaway ati sa telay makamal. ");
INSERT INTO blx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sinumun êt ta tagasunul ya nunan inlumatêng. Sên nakitan nay telay nalakwan, naniwala yan nabyay si Jesus. ");
INSERT INTO blx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Agyan idi sa Kasulatan na kaylangan mati si Jesus buy mabyay manguman, a la pun mapukatan na abiin. ");
INSERT INTO blx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pamakayari, nuli ya luway tagasunul na. ");
INSERT INTO blx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nuwa nakaidêng sa lawasan pamilbêngan si Maria ya manangis. Kaban manangis ya, nagduku ya buy nanilip sa lalên pamilbêngan. ");
INSERT INTO blx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Buy nakitan nay luway ang-el la nakayaming naputi ya nakaiknu sa pinipakalêkan sa bangkay Jesus. Ya gisa, idi sa ubatan ulu na buy ya gisa, idi sa ubatan kabitisan na. ");
INSERT INTO blx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pinatang la si Maria, “Siyan manangis kaya ta?” Nakitbay ya, “Gawan dilag nangwan bangkay Panginuun ku buy a ku tanda nu antuy pinilakwan kana.” ");
INSERT INTO blx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pamakasabi nan abitu, nangawing ya buy nakakit yan gisay tawuy nakaidêng baydu. Nuwa a na nakilala ya si Jesus sa abitu. ");
INSERT INTO blx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Pinatang yan Jesus, “Tuwa kuway, siyan manangis kaya ta? Sisabêt ta pantêkapên mu?” Indap Maria manaysay tanaman bayduy namatang kana. Kabay sinabin Maria, “Patêl lay, nu sikay nangwa kana, sabin mu kangku nu antuy pinilakwan mu kana, ta kêwên kuya.” ");
INSERT INTO blx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sinabin Jesus kana, “Mariay!” Nag-arap si Maria kan Jesus buy sinabi na sa sabin Hebreo, “Rabboni!” Ya labay sabin, “Manuru”. ");
INSERT INTO blx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sinabin Jesus kana, “Agana muku talanên, ta a ku pun nakapag-udung sa Bapa ku. Maku ka sa mapatêl ku buy sabin mu kallay mag-udung ngaku sa langit sa Bapa ku ya Bapa yu êt buy sa Namalyari ku ya Namalyari yu êt.” ");
INSERT INTO blx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kabay naku si Maria ya taga Magdala sa mani tagasunul Jesus buy sinabi na kallay, “Nakitan kinay Panginuun!” Buy sinabi na êt kallay mani pan-ipasabin Jesus. ");
INSERT INTO blx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pamakayabin allun Duminggu, nititipun na mani tagasunul Jesus. Impapakasara lay mani pasbul bali gawan sa limu la sa mani puun Judio. Bêngat tan nagpakit si Jesus buy nidêng sa pibunakan la buy sinabi na, “Mapakamuyuy kapatêtbêkan.” ");
INSERT INTO blx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pamakasabi nan abiin, impakit na sa mani tagasunul nay mani gamêt na buy mani tagyang na. Sên nakit lay Panginuun, natulatula sila. ");
INSERT INTO blx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Inuman na êt sinabin Jesus kallay, “Mapakamuyuy kapatêtbêkan. Nu parasaantu wakun in-utus Bapa ku, para kataw êt baydun pan-iutus.” ");
INSERT INTO blx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pamakasabi nan abiin, kinayupan na sila buy sinabi na, “Tanggapên yuy Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nu patawarên yuy gisay tawu sa kasalanan na, patawarên ya êt Bapan Namalyari. Nuwa nu a yuya patawarên sa kasalanan na, a ya êt patawarên Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nuwa sabitun nagpakit si Jesus, ayin baydu si Tomas ya pambêgên Kambal ya gisa sa mapu buy luway apostul na. ");
INSERT INTO blx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kabay sinabi la kanay, “Nakitan yan na Panginuun.” Nuwa sinabin Tomas kallay, “A ku maniwala anggan a ku makitan ya nukay ubatan paku sa gamêt na buy matalan ya ati buy anggan a ku maisun ya galamay ku sa nukay idi sa tagyang na.” ");
INSERT INTO blx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nilabas sa waluy allu, nanguman nititipun na mani tagasunul Jesus sa lalên bali, kaawyun layna si Tomas. Impapakasara lay mani pasbul, nuwa nisun pun si Jesus buy nidêng sa pibunakan la. Buy sinabi na, “Mapakamuyuy kapatêtbêkan.” ");
INSERT INTO blx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sinabin Jesus kan Tomas, “Elêwên mu buy dukpan na nuka sa gamêt ku buy dukpan muy nukay idi sa tagyang ku. Agana kayna magluway nakêm, nun a maniwala kayna.” ");
INSERT INTO blx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nakitbay si Tomas, “Panginuun ku buy Namalyari ku!” ");
INSERT INTO blx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Sinabin Jesus kana, “Naniwala kayna nayi gawan nakitan mukina? Pinagpalay mani manampalataya kangku agyan a laku nakitan.” ");
INSERT INTO blx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Malakê pun na mamakaupapas ya dinyag Jesus ya nakitan mani tagasunul nay asê pun naisulat sa librun ati. ");
INSERT INTO blx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nuwa ya mani nakasulat sa librun ati, insulat amên manampalataya kaw ya si Jesus sabay siyay Cristu ya Anak Bapan Namalyari. Buy nu manampalataya kaw kana, mabiyan kaw biyay ya ayin katganan. ");
INSERT INTO blx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nilabas sa dakun umnuy allu, nanguman nagpakit si Jesus sa mani tagasunul na sa agid lawan Tiberias. Paradi ya nalyari. ");
INSERT INTO blx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sa panawun na abitu, niaawyun silan Simon Pedro, si Tomas ya pambêgên Kambal, si Nathanael ya taga balayan Cana sa prubinsyan Galilea, ya luway anak Zebedeo, buy luwa pun êt ta tagasunul Jesus. ");
INSERT INTO blx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sinabin Simon Pedro kalla, “Mandakêp pakun kênan lanêm.” Sinabi la, “Kilaku kay kamu.” Kabay nagsakay sila sa bangka amên mandakêp silan kênan lanêm sa lawa. Nuwa namawatwat silan ayin nakwa. ");
INSERT INTO blx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sên nasawang ngana, nakaidêng si Jesus sa agid lawa, nuwa a laya nakilala. ");
INSERT INTO blx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Binêg silan Jesus, “Mapatêl kuway, dilag kaw nayin nakwa?” Nakitbay sila, “Ayin na kayêk.” ");
INSERT INTO blx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Sinabin Jesus kalla, “Inabu yu sa lanêm ya pukut yu sa wanan bangka amên makakwa kaw.” Kabay dinyag lay nabay ya abitu buy sên guluyun lay nay dala la, a layna maguluy gawan sa lakên nakwa lay kêna. ");
INSERT INTO blx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ya tagasunul ya kakaidwan Jesus, sinabi na kan Pedroy, “Sabay ya Panginuun na abitu!” Sên nalêngên Pedroy abiin, kingwa nay yaming nga inlukas na ta in-is-êl na sa awak na. Nag-ukdu ya sa lanêm buy nangaway ya papakun sa agid lawa. ");
INSERT INTO blx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ya kaatag mani tagasunul ya idi sa bangka, nag-udung sila sa agid ya miguguluy dalay napnun kênan lanêm, gawan kay manga siyam mapuy metruy dayu la sa agid. ");
INSERT INTO blx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pamakalatêng la sa agid, nakitan la bayduy dilag kênan lanêm ma nakasagpa sa bayan apuy buy dilag êt tinapay. ");
INSERT INTO blx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sinabin Jesus kallay, “Mantan kaw baydin dakun umnuy kênan lanêm ya nakwa yu.” ");
INSERT INTO blx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kabay nagsakay si Simon Pedro sa bangka buy ginuluy nay dala papakun sa agid ya napnun mangaragul ya kênan lanêm. Dinalan buy limampu buy tatluy kaganawan. Nuwa agyan parabaydun kalakêy kêna, asê nasiray dala. ");
INSERT INTO blx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Sinabin Jesus kalla, “Kaksaw kaw ta mangalmusal kitamu.” Ayin gisa man kallay nakadêgdêg namatang nu sisabêt ya tagawan tanda lay sabay siyay Panginuun. ");
INSERT INTO blx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nangwan tinapay si Jesus buy indin kalla. Pamakayari, nangwa ya êt kênan lanêm buy indin na kalla. ");
INSERT INTO blx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Abiin ya ikatluy pagpakit Jesus sa mani tagasunul na pamakayari nan nabyay nanguman ubat sa nangamamati. ");
INSERT INTO blx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pamakayari lan nangan, sinabin Jesus kan Simon Pedro, “Simon ya anak Juan, kaidwan muku nayin igit pun sa pangidu la kangku?” Nakitbay si Pedro, “Awuy Panginuun, tanda muy kakaidwan kata.” Kabay sinabin Jesus kana, “Nu parabaydu, pakanên muy mani tupa ku.” ");
INSERT INTO blx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pinatang yan manguman Jesus, “Simon na anak Juan, kaidwan muku nayi?” Nakitbay si Pedro, “Awuy Panginuun, tanda muy kakaidwan kata.” Kabay sinabin Jesus kana, “Nu parabaydu, saysayên muy mani tupa ku.” ");
INSERT INTO blx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Katitlu yan pinatang Jesus, “Simon ya anak Juan, kaidwan muku nayi?” Nalêlêy nakêm Pedro gawan katitlu yan pinatang Jesus nu kaidwan naya. Kabay nakitbay ya, “Panginuun, tanda muy kaganawan bagay buy tanda mu êt ta kaidwan kata.” Kabay sinabin Jesus kana, “Pakanên muy mani tupa ku. ");
INSERT INTO blx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pansabin ku kamuy sabitun anak ka pun, sikay mamayaming sarili mu buy pallakwên muy labay mun lakwên. Nuwa nu tuwa kayna, ipaktang muy gamêt mu ta kaatag gay mamayaming kamu buy gêtan laka sa lugal la a mu labay.” ");
INSERT INTO blx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sinabin Jesus ya abiin amên ipatanda na nu parasaantuy pangamati ya danasên Pedro amên maparangalan si Bapan Namalyari. Pamakayari, sinabin Jesus kan Pedro, “Kilaku ka kangku.” ");
INSERT INTO blx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Sên nangawing si Pedro, nakitan nay manunul kallay kakaidwan na tagasunul Jesus. Sabay siyay tagasunul Jesus ya nakaunsalig sa dani na sabitun mangapun sila buy namatang kana nu sisabêt ta mamisupakat kana. ");
INSERT INTO blx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sên nakitan Pedro si Jesus, pinatang naya, “Panginuun, sabêt taman na malyari sa tawun abiin?” ");
INSERT INTO blx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nakitbay si Jesus, “Nu labay kuyan mabyay angga sa pag-udung ku, makapakun naman kamu? Kay sumunul ka kangku.” ");
INSERT INTO blx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kabay niwagaw wa balita sa mani manampalataya ya asê mati ya tagasunul ya kakaidwan Jesus. Nuwa asê sinabin Jesus ya a ya mati. Ya kay sinabi na, “Nu labay kuyan mabyay angga sa pag-udung ku, makapakun naman kamu?” ");
INSERT INTO blx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Siku si Juan na tagasunul Jesus ya magpapêtêg sa mani bagay ya ati buy siku êt ta nanulat. Buy tandan mani kaawyun ku ya pêtêg ga pansabin ku. ");
INSERT INTO blx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Malakê pun êt ta mani dinyag Jesus. Nu isulat kuy kaganawan ati, sa êlêw kuy asê minukad sa buun babun lutay kaganawan libruy maisulat ku.");
INSERT INTO blx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kakaidwan kun Teofilo, sa nunan sulat ku kamu, insulat kuy dinyag Jesus buy in-aral na paubat sa umpisa yan nangaral ");
INSERT INTO blx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","angga sa allun intag-ay ya sa langit. Nati si Jesus sa kurus, nuwa nanguman yan nabyay buy malakêy dinyag na amên pagpapêtgan na abiin. Buy sa apattapuy allu, katiumnu yan nagpakit sa mani pinili nay apostul buy pansabin na kallay tungkul sa pag-arin Bapan Namalyari. Intipan na êt kallay mani utus sa kapamilatan Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Gisay allu, kaban mipupulung sila kaawyun si Jesus, intipan na kallay, “Agana kaw pun mita sa Jerusalem. Etêngên yu pun na impangakun Bapan Namalyari kamuyuy Ispiritu na. Sinabi kinay abiin kamuyu sabitun nuna. ");
INSERT INTO blx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ta si Juan ya Mamawtismu, namawtismu ya sa lanêm, nuwa pamakayarin dakun umnuy allu, bawtismuwan kaw sa Ispiritun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sên nititipun na mani apostul buy si Jesus, pinatang laya, “Panginuun, ati nayi ya panawun iudung muy pag-ari sa Israel sa mani Israelita?” ");
INSERT INTO blx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nakitbay si Jesus, “A yina kaylangan matandan nu makanu malyari ya mani intakdan Bapa ku sa kapamilatan kapangyarian na. ");
INSERT INTO blx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nuwa sa pallumatêng Ispiritun Bapan Namalyari kamuyu, biyan nakaw kapangyarian. Buy sikaw wa magpapêtêg tungkul kangku sa mani tawu baydi sa balayan Jerusalem, sa prubinsyan Judea, sa prubinsyan Samaria buy sa kaganawan lugal baydi sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pamakayarin sinabin Jesus ya abiin, nitag-ay yina sa langit. Buy kaban pakaêlêwên layan pamatatag-ay, nasanipan ninan ulap angga sa a layna nakitan. ");
INSERT INTO blx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kaban mamakaêlêw sila sa langit, bêngat tan nidêng sa dani lay luway ang-el ya nakayaming naputi. ");
INSERT INTO blx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Buy sinabin luway ang-el, “Sikaw wa mani taga prubinsyan Galilea, siyan nakaidêng kaw yapun baydin nakaêlêw sa langit ta? Si Jesus ya nakitan yun nitag-ay papakun sa langit, mag-udung ya baydi sa babun luta. Buy nu parasaantu yuyan nakitan na nitag-ay papakun sa langit, para êt bayduy pag-udung na baydi sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kabay nag-udung ya mani apostul sa balayan Jerusalem ubat sa Bung-uy mani Ulibu. Ya bung-uy ya ati, kulang tan pêrad sa gisay kilumetru ya dayu na sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Sên nilatêng silayna sa Jerusalem, nagdaus silan nagdakêy sa bibiyan lay kuwartu ya idi sa têngêl. Ya mani ati sabay silan Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago ya anak Alfeo, si Simon ya manalangsang sa gubernun Roma, buy si Judas ya anak kaatag Santiago. ");
INSERT INTO blx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pawa silan miaawyun manalangin kaawyun ya dakun umnuy babayi buy si Maria ya indun Jesus buy ya mapatêl Jesus ya lawyaki. ");
INSERT INTO blx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sên nilabas say dakun umnuy allu, nititipun na mani manampalatayay dilag bilang dinalan buy luwampu. Nidêng si Pedro buy sinabi na, ");
INSERT INTO blx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mapatêl kuway, kaylangan matupad da kasulatan na impatandan Ispiritun Bapan Namalyari kan Arin David sabitun nuna ya tungkul kan Judas Iscariote, ya sabay ya nanawup nandakêp kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sabitun nuna, kaawyun yan si Judas bilang apostul ya pinilin Jesus amên maglingkud kana.” ");
INSERT INTO blx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Nuwa si peray pinamayad kan Judas sa nadawak ka dinyag na, pinanaliw nan luta. Sa lutay nasaliw na, nagnabu yan nipalukub buy inlumtus ya bituka nan niawas sa laman. ");
INSERT INTO blx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Natandan kaganawan tawu sa Jerusalem ya nalyari kan Judas. Kabay ya lutan abitu, binêg lan Akeldama ya labay sabin sa sabi la, “Panggitnan ya Dilag Daya.”) ");
INSERT INTO blx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sinabi pun êt Pedro, “Nakasulat sa mani librun Kanta ya tungkul kan Judas, ‘Pasawan tanay bibiyan na buy ayin nan malyarin manugêl baydu.’ ” Buy nakasulat êt, “Idin ta sa kaatag ya katungkulan na.” ");
INSERT INTO blx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Sinabi pun êt Pedro, “Kabay sêpat kitaminan mamilin tawuy panagili kan Judas ya makaawyun yan mamipapêtêg sa pangabyay manguman Panginuun Jesus. Kaylangan ya pilin tamu, gisa sa mani pagkaawyun yan sabitun kaawyun tamu pun si Jesus, paubat sabitun nagpabawtismu ya kan Juan ya Mamawtismu angga sa gintan ya papakun sa langit.” ");
INSERT INTO blx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kabay lagyun luway liyaki ya sinabi la. Ya gisa, si Jose ya pambêgên Barsabas buy pambêgên êt Justo. Ya gisa êt, si Matias. ");
INSERT INTO blx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pamakayari, nanalangin sila, sinabi la, “Panginuun, tanda muy idi sa bêkên kaganawan tawu. Kabay ipatanda mu kanyan nu sisabêt sa luway pilin mun ");
INSERT INTO blx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","daygên apostul bilang kasagilin Judas. Ta binukutan Judas ya pandaygên na bilang gisay apostul buy naku ya sa gisay lugal la nanaspat kana.” ");
INSERT INTO blx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pamakayari lan nanalangin, nibagutan sila. Ya nabagut la, si Matias. Kabay si Matias ya indagdag sa mapu buy gisay apostul. ");
INSERT INTO blx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sên inlumatêng ya allun pestan mani Judioy pambêgên Pentecostes, nagtipun sa gisay bali ya kaganawan manampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kaban mititipun sila, mamakun ni, nakalêngê silan sênêg sa buun bali. Ya sênêg ga ati, ubat sa langit ya nanuwad malakas ya angin. ");
INSERT INTO blx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Buy dilag silan nakit ya paran apuy ya nanuwad dila ya nag-ugpa sa balang gisa kalla. ");
INSERT INTO blx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Natupus Ispiritun Bapan Namalyari ya kaganawan idi baydu buy nakapagsabi silan magmikakanayun na sabi ya a la pun natandan. ");
INSERT INTO blx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Amêsên sa panawun abitu, dilag êt mani Judioy idi sa Jerusalem ya manunul sa Kautusan Bapan Namalyari. Ubat sila sa magmikakanayun na bansa buy asê pariparisuy sabi la. ");
INSERT INTO blx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sên nalêngê lay sênêg, pinaras lan naku sa pagtipunan mani manampalataya. Nakaupapas sila gawan nalêngê lay magsabi ya mani manampalataya sa mani sabin mani mallêngê. ");
INSERT INTO blx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kabay sinabi la, “Aw indi, alwa nayin taga prubinsyan Galilea ya mani tawun ati sila? ");
INSERT INTO blx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Uysiyan makapagsabi sila yan sabi tamu ta? ");
INSERT INTO blx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Dilag baydi kantamun taga Partia, taga Media, taga Elam, taga Mesopotamia, taga Judea, taga Capadocia, taga Ponto buy taga Asia. ");
INSERT INTO blx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ya kaatag kantamu taga Frigia, taga Pamfilia, buy taga Egipto. Buy dilag êt ubat sa mani lugal ya sakup Libya ya narani sa Cirene. Dilag êt taga balayan Roma, ");
INSERT INTO blx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ya mani Judio buy alwan Judio ya napasunul êt sa mani paniwalan mani Judio. Buy ya kaatag, taga Creta buy taga Arabia. Nuwa ya abiin sila, mani taga Galilea. Uysiyan mangalêngê tamu sila yan magsabi sa sabi tamu ta tungkul sa mamakaupapas ya dinyag Bapan Namalyari?” ");
INSERT INTO blx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nakaupapas sila buy a la makwan maisip pa nalyari. Kabay nipapatang sila, “Sabêt ta labay sabin ati?” ");
INSERT INTO blx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nuwa ya kaatag, inuyam lay mani manampalataya. Sinabi la, “Kay malasing ya mani tawun abiin!” ");
INSERT INTO blx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kabay nidêng si Pedro kaawyun na mapu buy gisay apostul buy masnêg nan sinabi, “Sikaw wa mapatêl kun mani Judio buy sikaw wa kaatag manugêl sa Jerusalem, pakalêngê kaw, ta itutu ku nu sabêt ta labay sabin ati ya mangapalyari amêsên. ");
INSERT INTO blx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Indap yu nu kay malasing kay. A kay malasing, ta tanda tamuy ayin maglasing un alas nuwebin maranun. ");
INSERT INTO blx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ya mangapalyari amêsên kanyan, sabay ya katuparan sinabin propeta Joel sabitun nuna, ");
INSERT INTO blx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ati ya pansabin Bapan Namalyari, “Ya daygên ku sa tawlin allu bayu sa katganan babun luta, iutus kuy Ispiritu ku sa kaganawan layin tawu. Ya mani anak yuy lawyaki buy babayi, mamipatandan mani sabi ku. Ya mani bayuntawu yuy makakit sulêplêp pa ipasulêplêp ku kalla. Ya mani mangatwa yuy lawyaki, makataynêp silan taynêp pa ipataynêp ku kalla. ");
INSERT INTO blx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sa allun abitu, iutus kuy Ispiritu ku sa mani lawyaki buy sa mani babayi ya lingkud ku, buy ipatanda lay mani sabi ku. ");
INSERT INTO blx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mamipakit takun mani mamakaupapas sa langit buy mani tanda' sa luta sa kapamilatan daya, apuy, buy makudpay asuk. ");
INSERT INTO blx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Dumiglêm ma allu, buy umudit ta buwan kaparisun daya. Malyari ya abiin bayu lumatêng nga alluy ayin kaparisu buy mamakaupapas ya sabay ya allun pallumatêng Panginuun. ");
INSERT INTO blx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Buy nu sisabêt man na mamêg sa Panginuun, miligtas ya.” ’ ” ");
INSERT INTO blx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Insundun Pedroy pagsabi na, “Kabay sikaw wa kaparisu kun Israelita, pakalêng-ên yuy ati! Si Jesus ya taga Nazaret, in-utus yan Bapan Namalyari kantamu. Buy pinagpapêtgan Bapan Namalyari ya abiin sa kapamilatan mani imala, mamakaupapas, buy tanda' ya dinyag Jesus. Tanda yuy kaganawan abiin tagawan nalyari baydi kamuyu. ");
INSERT INTO blx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sabitun nuna pun, tanday nan Bapan Namalyari ya igawang kamuyu si Jesus ta taganan parabaysên na palanu na. Impapati yuya sa mani makasalanan na tawu ya nipaku kana sa kurus. ");
INSERT INTO blx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nuwa pinabyay yan Bapan Namalyari buy inligtas sa kapangyarian kamatyan, gawan asê malyarin manugêl nati si Jesus. ");
INSERT INTO blx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ati ya impasabin Bapan Namalyari kan Arin David tungkul kan Jesus, ‘Nakit kuy Bapan Namalyari ya pawan idi sa arapan ku. Gawan pawa kuyan kaawyun, asê magmikakunuy nakêm ku. ");
INSERT INTO blx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kabay masayay bêkê ku buy a ku mabênbênan na bêbêy kun mangulimên kan Bapan Namalyari. Agyan mati yaku, dilag gaku pun kapilmiyan na mabyay yakun manguman. ");
INSERT INTO blx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gawan a mu paulayan na kaladwa ku baydu sa lugal la nangamamati. Buy a mu êt paulayan bumatay bangkay Banal la Lingkud mu. ");
INSERT INTO blx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Impatanda mu kangkuy mabyay yaku. Buy gawan pawa katan pagkaawyun, sadyay tula ku.’ ” ");
INSERT INTO blx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Sinabi pun êt Pedro, “Sikaw wa mani kaparisu kun Judio, sabitun sinabin Arin David da abiin, malinaw wa alwan sarili nay pantukuyun na. Tanda tamuy nati si Arin David buy angga amêsên, tanda tamu nu saantu yan nakalbêng. ");
INSERT INTO blx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Si David, gisa ya sa mani propeta. Buy tanda nay impangakun Bapan Namalyari kana ya gisa sa mani layi nay mamisundu sa pag-ari na. ");
INSERT INTO blx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sabitun nuna, tanday nan Arin David da pabyayên Bapan Namalyari si Cristu ya impangaku na. Kabay insabin David da tungkul kana, ‘A naya pinaulayan sa lugal la nangamamati. Buy a na pinaulayan binumatay bangkay na.’ ");
INSERT INTO blx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Si pantukuyun na sabay si Jesus ya pinabyay Bapan Namalyari. Buy magpapêtêg kay kaganawan sa pangabyay nan manguman. ");
INSERT INTO blx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Sabay siyay intag-ay Bapan Namalyari sa langit buy impaiknu sa wanan na. Buy natanggap nay impangakuy Ispiritu ya sabay êt ta indin na kanyan buy abiin na mangakitan yu buy mangalêngê yu amêsên. ");
INSERT INTO blx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ta alwan si Arin David da gintan sa langit, nun a si Jesus ya Panginuun na. Kabay sinabin David, ‘Sinabin Bapan Namalyari sa Panginuun ku, “Miknu ka sa wanan ku, ");
INSERT INTO blx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","angga sa mapasuku ku kamuy mani kapati mu.” ’ ” ");
INSERT INTO blx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Insundun Pedroy pagsabi na, “Kabay sikaw wa kaganawan kaparisu kun mani Israelita, sêpat yun matandan ya si Jesus ya impapaku yu sa kurus, sabay siyay dinyag Bapan Namalyarin Panginuun buy sabay siyay Cristuy impangaku na!” ");
INSERT INTO blx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sên nalêngên mani tawuy abitu, nabêgbêg ga nakêm la. Kabay namatang sila kan Pedro buy sa kaawyun nan mani apostul, sinabi la, “Mapatêl kuway, sabêt kayêk ka sêpat yan daygên?” ");
INSERT INTO blx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nakitbay si Pedro kalla, “Ya balang gisa kamuyu, magsisi buy itgên yuy panyag yun kasalanan. Buy magpabawtismu kaw sa lagyun Jesu Cristu amên mapatawad da mani kasalanan yu buy matanggap yuy pan-idin Bapan Namalyari ya ayin kaatag nun a ya Ispiritu na. ");
INSERT INTO blx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tagawan na Ispiritun Bapan Namalyari, sabay ya impangaku na kamuyu buy sa mani anak yu buy sa kaganawan tawuy idi sa mangarayuy lugal. Impangakun Bapan Namalyari ya Panginuun tamuy ati sa sisabêt man na tawuy bêgên nan magdani kana.” ");
INSERT INTO blx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Malakê pun êt ta pagpapêtêg ga sinabin Pedro kalla. Buy inyawad na êt kallay paradi, “Agana kaw makiawyun sa mani layi amêsên na mapanyag kadawakan amên miligtas kaw sa parusay lumatêng.” ");
INSERT INTO blx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Malakêy naniwala sa sinabin Pedro. Kabay nagpabawtismu sila. Sa allu êt abitu, tatluy libuy tawuy nidagdag sa mani manampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ya mani bayun nanampalataya kan Jesus, pawa silan mamaku sa mani apostul amên mallêngê sa mani pan-ituru la, pawa silan mibêbêtêk bilang mipapatêl sa panampalataya, pawa sila êt miaawyun mangan tinapay buy pawa silan manalangin. ");
INSERT INTO blx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gawan sa kapangyarian Bapan Namalyari, nakadyag ya mani apostul un malakêy mamakaupapas buy tanda'. Kabay ya mani tawuy idi baydu, nalimu sila kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ya mani manampalataya kan Jesus, dilag silan gigisay nakêm buy ya pibandiyan la, piniaagêm la. ");
INSERT INTO blx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pan-isaliw lay luta buy pibandiyan la, ta ya peray naabli la, pan-idin la sa balang gisa ayun sa kaylangan la. ");
INSERT INTO blx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Allu-allu silan mititipun sa Templu. Miaawyun silan mangan sa balin balang gisa un dilag mangêd da nakêm buy tula. ");
INSERT INTO blx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Buy pawa lan pan-ulimênên si Bapan Namalyari. Panggalangên sila êt mani tawuy idi baydu. Allu-allu pan-idagdag Panginuun kallay mani tawuy inligtas na sa parusay lumatêng. ");
INSERT INTO blx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gisay allu sên alas tres san kaawat, naku si Pedro buy si Juan sa Templu. Uras panalangin na abitu. ");
INSERT INTO blx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Baydu sa Templu, dilag pambêgên Mangêd da Pasbul. Dilag gisay liyaki bayduy lumpu ubat ta sa in-anak ya. Allu-allu panggêtan laya baydu amên magpalimus ya sa mani mansumun sa Templu. ");
INSERT INTO blx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sên nakit na silan Pedro buy si Juan na pasun sa kasawangan Templu, nanyawad yan limus kalla. ");
INSERT INTO blx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pinakaêlêw yan Pedro buy si Juan. Sinabin Pedro, “Elêwên mukay.” ");
INSERT INTO blx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kabay nangêlêw wa liyaki kalla, gawan piêêtêng nay biyan layan pera. ");
INSERT INTO blx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nuwa sinabin Pedro kana, “Ayin nakun pera o gintu, nuwa dilag gakun idin kamu. Sa lagyun Jesu Cristu ya taga Nazaret, midêng ka buy mita ka.” ");
INSERT INTO blx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tinalan Pedroy wanan gamêt na buy impaidêng naya. Tambêng pinumas-êy ya bitis buy tulatud na. ");
INSERT INTO blx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kabay tambêng yan nidêng buy nakabita. Pamakayari, nakilaku ya kallan Pedro sa kasawangan Templu. Nibitabita yan nag-ukdu-ukdun mangulimên kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nakitan kaganawan na nakabita ya buy mangulimên nina kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nalupan lay sabay siya awêd da abituy liyaki ya lumpu ya magpalimus sa mani mansumun sa pambêgên lan “Mangêd da Pasbul” sa Templu. Kabay sadyay upapas la sa nalyari kana. ");
INSERT INTO blx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pamakayarin abitu, asina imbul-is liyaki si Pedro buy si Juan. Kaban mamita sila sa pambêgên lan “Balkun Solomon,” kapagtalantalan na kalla. Nipamwayun nagdani kallay kaganawan tawu, gawan nakaupapas sila sa nalyari. ");
INSERT INTO blx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pamakakit Pedro sa mani tawu, sinabi na kallay, “Mapatêl kun Israelita, uysiyan nakaupapas kaw ya sa nalyari ta? Buy papakaêlêwên yukay yata? Indap yu nayi nu napabita yan na tawun ati gawan sa sarili yan kapangyarian o sa panunul yan sa kalabayan Bapan Namalyari? Asê! ");
INSERT INTO blx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Alwan sikay ya namaiyul kana, nun a ya Bapan Namalyarin mani ninunu tamu ya silan Abraham, Isaac, buy Jacob amên maparangalan na si Jesus ya Lingkud na. Si Jesus sabay ya indin yu sa mani manungkulan buy insakwil yuya sa arapan Gobernador Pilato, agyan ibus nayna dayi. ");
INSERT INTO blx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Agyan sabay siyay Banal buy Matinêk ka Lingkud Bapan Namalyari, insakwil yuya buy inyawad yu kan Pilatoy ibus ya gisay mamatin tawu. ");
INSERT INTO blx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Impapati yuy pangubatan biyay ya ayin katganan, nuwa pinabyay yan Bapan Namalyari. Sikay ya magpapêtêg ga nabyay yan manguman, ta nakitan yan ya. ");
INSERT INTO blx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ya panampalataya sa kapangyarian lagyun Jesus sabay ya nakapabita sa liyakin ati ya makit buy malupan yu. Nalyari ya ati gawan sa panampalataya kan Jesus. Buy agyan sikaw, napagpapêtgan yuy inumiyul ya.” ");
INSERT INTO blx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Buy amêsên na mapatêl, tanda kuy nadyag yun impapati si Jesus buy mani mamunu yu gawan a yu tanda nu sisabêt yan tagana. ");
INSERT INTO blx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nuwa sên dinyag yu kanay abiin, natupad day impatandan Bapan Namalyari awlagi sa kapamilatan mani propeta ya si Cristu, kaylangan nan madanasan na pamasakit. ");
INSERT INTO blx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kabay sêpat kawnan magsisi buy magdani kan Bapan Namalyari amên patawarên nay mani kasalanan yu. ");
INSERT INTO blx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nu daygên yuy abiin, matanggap yuy bayuy katigsawan na ubat sa Panginuun buy iutus na si Jesus ya Cristuy intalaga na para kamuyu sabitun nuna pun. ");
INSERT INTO blx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nuwa kaylangan pun manugêl si Jesus sa langit angga sa lumatêng nga panawun ibayun Bapan Namalyari ya kaganawan bagay ayun sa impangaku na sabitun nuna sa kapamilatan mani banal la propeta na. ");
INSERT INTO blx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ta paradi ya sinabin Moises sabitun nuna tungkul kan Cristu, ‘Ya Bapa yun Namalyari ya mamilin gisay propetay nanuwad kangku ya kalayi yu. Sêpat yun sunulun na kaganawan sabin na kamuyu. ");
INSERT INTO blx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nu sisabêt man na asê manunul sa pansabin propetan abitu, ipapawa yan Bapan Namalyari sa mani tawu na amên upudun ya.’ ” ");
INSERT INTO blx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Insundun Pedroy pagsabi na, “Ya kaganawan propetan Bapan Namalyari paubat kan Samuel, impatanda lay tungkul sa mani mangapalyari amêsên. ");
INSERT INTO blx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sikitamuy makapagmanan mani impangakun Bapan Namalyari sa kapamilatan mani propeta na. Buy kaawyun kitamu êt sa kasunduwan Bapan Namalyari sa mani ninunu tamu sabitun sinabi na kan Abraham, ‘Pagpalên kuy kaganawan tawu sa kapamilatan layi mu.’ ");
INSERT INTO blx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kabay pinilin Bapan Namalyari ya Lingkud na buy nuna nan in-utus kantamun mani Judio amên pagpalên na kitamu sa kapamilatan panawup na kantamun lakwanan ya panyag nadawak.” ");
INSERT INTO blx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kaban magsabi pun si Pedro buy si Juan sa malakêy idi baydu sa Balkun Solomon sa Templu, dilag inlumatêng nga dakun umnuy pari kaawyun lay kapitan mani magbantay sa Templu buy mani Saduseo. ");
INSERT INTO blx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sadyay suluk la kan Pedro buy kan Juan gawan pan-iaral la sa mani tawuy mabyay manguman ya nangamamati gawan nabyay si Jesus. ");
INSERT INTO blx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kabay dinakêp la si Pedro buy si Juan. Litisin la sila dayi nuwa gawan yabi yana, insukul la tana sila anggan maranun. ");
INSERT INTO blx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Paraman baydu, malakê sa mani nallêngê sa pangaral lay nanampalataya kan Jesus. Kabay nidagdag ya bilang la angga sa niras limay libuy lawyaki. ");
INSERT INTO blx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pamakawasak, nipupulung sa Jerusalem ma mani mamunu, ya mani mangatway manungkulan buy mani manurun Kautusan. ");
INSERT INTO blx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Idi êt baydu si Anas ya pinakapuun pari, si Caifas, si Juan, si Alejandro buy ya kaatag kamag-anak Anas. ");
INSERT INTO blx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","In-arap kalla si Pedro buy si Juan buy pinatang, “Sabêt ta kapangyarian yu buy kansabêt lagyuy ginamit yu amên mamaiyul sa liyakin ati?” ");
INSERT INTO blx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Natupus Ispiritun Bapan Namalyari si Pedro. Kabay sinabi na, “Sikaw wa panggalangên na mamunu buy sikaw wa mangatway manungkulan, ");
INSERT INTO blx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nu pallitisin yukay amêsên tungkul sa kangêdan na dinyag yan sa liyakin ati buy nu parasaantu yan nakabita, ");
INSERT INTO blx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","sêpat yun matandan buy kaganawan kaparisu tamun Israelitay ati. Ya liyaki ya nakaidêng amêsên sa arapan yuy ayin nan sakit, inumiyul ya gawan sa kapangyarian Jesu Cristuy taga Nazaret. Sabay siyay impapaku yu sa kurus, nuwa pinabyay yan manguman Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Buy si Jesus ya pantukuyun sa talatan ati, ‘Ya batuy insakwil yun mani mamipaydêng bali, sabay ya batuy nagin pundasyun.’ ");
INSERT INTO blx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ayin sisabêt man na makapiligtas kantamu sa ayin katganan na parusa, nun a kay si Jesu Cristu ya in-utus Bapan Namalyari baydi sa babun luta.” ");
INSERT INTO blx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sên natandan lay kay nayêpay pangatawu lan Pedro buy si Juan buy a sila nag-aral, nakaupapas sila sa kapas-êyan nakêm la. Naisip lay sabay silay pagkaawyun Jesus. ");
INSERT INTO blx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nuwa ayin silaynan nasabi laban kalla, ta nakitan lay liyaki ya makabitay na ya nakaidêng kaawyun lan Pedro buy si Juan. ");
INSERT INTO blx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kabay impaawas la pun silan Pedro buy si Juan un mangatwan Judioy mangatuynungan buy nisasabi silan, ");
INSERT INTO blx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Sabêt ta daygên tamu kalla? A tamina maipuglaw wa dinyag lay mamakaupapas, ta tanday nan buun Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Patandan tamu ta sila ya agana layna iaral la tungkul kan Jesus amên asina miwagaw wa nalyari.” ");
INSERT INTO blx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kabay impabêg silan manguman buy pinatandan, “Agana kawna magsabi o mangaral tungkul kan Jesus.” ");
INSERT INTO blx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nuwa nakitbay si Pedro buy si Juan, “Pakaisipin yu nu sabêt ta ustu sa pangêlêw Bapan Namalyari, manunul kay kamuyu o kan Bapan Namalyari? ");
INSERT INTO blx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gawan para kanyan, a yan malyarin asê sabin na nakitan buy nalêngê yan kan Jesus.” ");
INSERT INTO blx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Labay la dayin parusan ya luwa, nuwa a la madyag tagawan malimu sila sa mani tawuy mangulimên kan Bapan Namalyari sa mamakaupapas sa nadyag, gawan si abituy liyaki ya nakabitay na, apattapuy tawun nayna. Kabay imbus la tanay luwa buy pinakasipit lan sinabyanan ya aganayna mangaral tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sên imbus sa silan Pedro buy si Juan, nagtalus sila sa mani kaawyun lan manampalataya kan Jesus buy imbalita lay sinabi kallan mani mamunun pari buy mani mangatway manungkulan. ");
INSERT INTO blx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sên nalêngên mani manampalatayay abitu, niaawyun silan nanalangin kan Bapan Namalyari. Sinabi la, “Panginuun yan na Makapangyarian sa kaganawan, sika ya nanyag langit, luta, dagat buy sika ya nanyag kaganawan idi baydi! ");
INSERT INTO blx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sa kapamilatan Ispiritu mu, impasabi mu kan David da lingkud muy ninunu yan ya paradi, ‘Uysiyan natubag-tubag yay mani alwan Judio ta? Buy siyan mangisip yan ayin pukat ta mani Judio ta? ");
INSERT INTO blx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Naglêan ya mani ari baydi sa babun luta buy nititipun ya mani mamunu amên makipati kan Bapan Namalyari buy kan Cristuy intalaga na.’ ");
INSERT INTO blx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Panginuun, natupad day impasabi mu kan Arin David tagawan silan Gobernador Herodes Antipas, si Gobernador Poncio Pilato, ya mani alwan Judio buy ya mani kaparisu yan Judio, nibêbêtêk sila amên patin si Jesus ya Banal la Lingkud ya intalaga mun Mamiligtas. ");
INSERT INTO blx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gawan sa kapangyarian buy kalabayan mu, nadyag lay mana mun in-il-an na palanu. ");
INSERT INTO blx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Buy amêsên na Panginuun, êlêwên mu! Pampalimun lakay. Kabay sawpan mukay ya mani lingkud mu amên maipangaral yan na sabi mu un dilag napas-êy ya nakêm. ");
INSERT INTO blx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sa kapamilatan kapangyarian mu, labayên muy mapaiyul yan na nipagsakit buy makadyag kay mani mamakaupapas sa kapamilatan kapangyarian Jesus ya Banal la Lingkud mu.” ");
INSERT INTO blx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pamakayari lan nanalangin, naêyêg ya bali ya pagtipunan la. Kabay ya kaganawan idi baydu, natupus Ispiritun Bapan Namalyari buy napas-êy ya nakêm lan niaral Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ya mani manampalataya kan Jesus, nibêbêtêk ka isip buy nakêm la buy a la pan-isipin ya kay kallay pibandiyan la nun a para sa kaganawan. ");
INSERT INTO blx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kaban pan-ipapêtêg mani apostul ya nabyay nanguman na Panginuun Jesus, sadyay kapangyarian na idi kalla. Buy sadyay kangêdan Bapan Namalyari sa balang manampalataya. ");
INSERT INTO blx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ayin nagkulang agyan gisa kalla, gawan na dilag luta o bali, pan-isaliw lay ati buy ya peray naabli la, ");
INSERT INTO blx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","indin la sa mani apostul. Buy indin êt taman mani apostul ya ati sa balang gisa ayun sa kaylangan la. ");
INSERT INTO blx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Para êt bayduy dinyag Jose ya taga Cyprus ya ubat sa layin Levi. Pambêgên yan mani apostul un Bernabe ya labay sabin, “Mamapas-êy nakêm.” ");
INSERT INTO blx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Insaliw nay luta na buy ya peray naabli na, indin na sa mani apostul. ");
INSERT INTO blx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dilag êt miasaway nisaliw luta la. Ya lagyun liyaki, Ananias buy ya lagyun babayi, Safira. ");
INSERT INTO blx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nuwa nibêtêk ka miasaway baw-asên lay peray naabli la buy ya nitagan sabay ya gintan Ananias sa mani apostul. Sinabi na kalla, “Kay aati ya naabli yan sa luta yan.” ");
INSERT INTO blx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nuwa sinabin Pedro kana, “Ananias, uysiyan nagpasakup kaya kan Satanas ta? Naglaram ka sa Ispiritun Bapan Namalyari gawan binaw-asan muy naabli mu sa luta yu. ");
INSERT INTO blx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sabitun a mu pun insaliw ya luta, kamuy abiin buy sên naisaliw mina, idi êt kamu nu sabêt ta daygên mu sa peray naabli mu! Uysiyan dinyag mu yay parabaysên ta? Naglaram ka alwan kay sa tawu, nun a kan Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pamakalêngên Ananias sa sinabin Pedro, nati yan nitugaw. Kabay dinanyan yan mani bayuntawu buy impunggus lay bangkay na. Pamakayari, gintan layan paawas buy in-ilbêng. Buy ya kaganawan nakalêngê sa nalyari, sadyay limu la. ");
INSERT INTO blx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pamakalibas tatluy uras, inlumatêng si Safira ya asawan Ananias. Ayin yan katatanda sa nalyari sa asawa na. ");
INSERT INTO blx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pinatang yan Pedro, “Sabin mu kangku nu kay ati ya naabli yu sa luta yu.” Sinabi na, “Awu, kay abiin.” ");
INSERT INTO blx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kabay sinabin Pedro kana, “Uysiyan nibêtêk kaw yan subukan ya Ispiritun Panginuun ta? Elêwên mu! Inlumatêng ngay nilbêng asawa mu buy sikay na êt amêsên ya ilbêng la.” ");
INSERT INTO blx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mamakun ni, nati yan nitugaw sa arapan Pedro. Pamakasun mani bayuntawu, nakitan lay nati ya êt si Safira. Kabay insapat layan insalwang buy in-ilbêng sa danin asawa na. ");
INSERT INTO blx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Sadyay limun mani manampalatayay miaawyun buy sadyay limun balang nakalêngê sa nalyari. ");
INSERT INTO blx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Gawan sa kapangyarian Bapan Namalyari, malakêy tanda' buy mamakaupapas ya dinyag mani apostul sa arapan mani tawu. Pawan mititipun na kaganawan manampalataya sa Balkun Solomon sa Templu. ");
INSERT INTO blx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ya mani asê manampalataya kan Jesus, agyan panggalangên lay mani manampalataya, malimu silan makiawyun kalla. ");
INSERT INTO blx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Buy luyang pun êt inlumakêy lawyaki buy babayi ya manampalataya sa Panginuun. ");
INSERT INTO blx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Gawan sa mani mamakaupapas ya dinyag mani apostul, gintan mani tawuy nipagsakit sa agid dan buy indin sa amak la amên sa panduman Pedro, agyan kay maêtêban silan alinaw na buy umiyul sila. ");
INSERT INTO blx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dilag êt malakêy inlumatêng nga ubat sa kaatag baryuy nakapalitêng sa Jerusalem. Panggêtan lay mani nipagsakit buy mani sinêdakan nadawak ka ispiritu. Buy inumiyul silan kaganawan. ");
INSERT INTO blx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kinasêman pinakapuun pari buy ya mani kaawyun nan Saduseoy mani apostul. ");
INSERT INTO blx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kabay impadakêp lay mani apostul buy impasukul. ");
INSERT INTO blx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nuwa sa yabin abitu, dilag gisay ang-el Panginuun ya naku sa sukulan, ta imbuklat nay pasbul pamisukulan buy impaawas na sila. Sinabin ang-el kalla, ");
INSERT INTO blx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Maku kaw sa Templu buy iaral yu sa mani tawuy tungkul sa bayun biyay ya pan-idin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kabay dinyag lay sinabin ang-el, ta sên niputak ka mamut, naku sila sa kasawangan Templu buy nangaral sa mani tawu. Sên inlumatêng nga pinakapuun pari buy mani kaawyun na, impabêg lay mani mangatwan Judioy mangatuynungan. Buy namiutus silan mani magbantay amên kêwên na mani apostul sa sukulan. ");
INSERT INTO blx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nuwa sên inlumatêng nga mani in-utus la sa pamisukulan, ayin na bayduy mani apostul. Kabay nag-udung sila sa mani mangatwan Judioy mangatuynungan. Sinabi la, ");
INSERT INTO blx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Sên inlumatêng kay sa sukulan, nakit yan na mamangêd da pangakandadun pasbul buy ya mani bantay, idi baydu sa pasbul. Nuwa sên imbuklat yan nay pasbul, ayin kayan nakitan na tawu baydu sa lalê!” ");
INSERT INTO blx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sên nalêngên kapitan mani magbantay sa Templu buy ya mani mamunun pari ya abiin, nakatêgag sila buy a la makwan maisip nu sabêt ta nalyari. ");
INSERT INTO blx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Amêsên, dilag tawuy inlumatêng buy nibalita, “Lêng-ên yuy ati! Ya mani tawuy impasukul yu, idi sila amêsên sa Templuy mangaral sa mani tawu.” ");
INSERT INTO blx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kabay tambêng naku sa Templuy kapitan kaawyun nay mani magbantay na amên dakpên manguman ya mani apostul. Nuwa a la sila pinasakitan, gawan malimu sila ta dat batwan silan mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","In-arap kapitan buy mani magbantay nay mani apostul sa mani mangatwan Judioy mangatuynungan. Sinabin pinakapuun pari sa mani apostul, ");
INSERT INTO blx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Masipit yan kawnan imbawal mangaral tungkul kan Jesus. Elêwên yuy dinyag yu! Niwagaw sa buun Jerusalem ya pan-iaral yu. Buy sikay pun êt ya pansangkanan yun namati sa tawun abiin!” ");
INSERT INTO blx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kabay nakitbay si Pedro buy ya mani kaawyun nan apostul, “Kay si Bapan Namalyari ya sêpat yan sunulun, alwan tawu. ");
INSERT INTO blx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Si Bapan Namalyari ya pan-ulimênên mani ninunu tamu, pinabyay nan manguman si Jesus ya impaku yun pinati sa kurus. ");
INSERT INTO blx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Intag-ay yan Bapan Namalyari buy pinaiknu naya sa wanan na bilang Mamunu buy Mamiligtas amên sikitamun mani Judio, mabiyan kitamun panawun magsisi buy sa pakapakun baydu, mapatawad da mani kasalanan tamu. ");
INSERT INTO blx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sikay ya magpapêtêg sa kaganawan nalyari kan Jesus. Buy alwan kay sikay nun a ya Ispiritun Bapan Namalyari êt ta indin na sa kaganawan manunul kana.” ");
INSERT INTO blx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sên nalêngên mani mangatwan Judioy mangatuynungan ya abitu, natubag-tubag sila buy labay lan patin na mani apostul. ");
INSERT INTO blx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nuwa nidêng nga gisa kalla ya naglagyun Gamaliel. Gisa yan Pariseo buy manurun Kautusan buy panggalangên kaganawan tawu. In-utus nay pasalwangên pun na mani apostul. ");
INSERT INTO blx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pamakasalwang mani apostul, sinabin Gamaliel, “Mani kaparisu kun Israelita, isipin yun mangêd nu sabêt ta mangêd yun daygên sa mani tawun abiin. ");
INSERT INTO blx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gawan dakun umnuy tawun nay inlumibas dilag êt parabaysên na nalyari. Dilag gisay liyaki ya naglagyun Teudas ya namadayêw nagsabin siyay dakilay pinunu. Nakasagyat yan apat ta ralan na lawyaki ya nakiawyun kana. Nuwa sên pinati ya, nangapisisyay ya mani kaawyun na buy a silayna niaawyun. ");
INSERT INTO blx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pamakayarin abitu, sabitun panawun pagsensus mani tawu, dilag êt parabaysên na nalyari. Dilag êt gisay liyaki ya naglagyun Judas ya taga prubinsyan Galilea. Nakasagyat ya êt malakêy lawyaki. Nuwa sên pinati ya, nangapisisyay êt ta mani kaawyun na. ");
INSERT INTO blx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kabay ati ya masabi ku kamuyu. Agana yu pakyalaman na mani tawun abiin buy pasawên yu silayna, gawan nu ya palanu o pandaygên la, kay ubat sa tawu, mangapisisyay êt ta abiin. ");
INSERT INTO blx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nuwa nu ubat kan Bapan Namalyari, a yu sila mapatgên. Ta dat kay lumtaw kaw tan manalungat kan Bapan Namalyari!” Kabay sinunul mani mangatwan Judioy mangatuynungan na sinabin Gamaliel. ");
INSERT INTO blx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Impabêg lan manguman na mani apostul buy impalatiku. Buy imbawal silan mangaral tungkul kan Jesus bayu sila imbus. ");
INSERT INTO blx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Namitay mani apostul sa mani mangatwan Judioy mangatuynungan un matula-tula, ta tinulutan silan Bapan Namalyarin mipakadêng-êy gawan sa panunul la kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Allu-allu silan mamaku sa Templu buy mamaku sa balang bali amên manuru buy mangaral Mangêd da Balita ya si Jesus sabay ya Cristuy impangakun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sa panawun abitu, kaban mallumakêy tagasunul Jesus, dilag mani Judioy magsabin Griego ya nagdeklamu laban sa mani Judioy magsabin Hebreo. Tagawan ya mani nabal-uy babayi ya magsabin Griego, a silayna pambiyan pan-ikabyay la sa inallu-allu. ");
INSERT INTO blx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kabay impabêg mapu buy luway apostul ya kaganawan tagasunul Jesus. Sinabi la, “Asê mangêd da paulayan yan na pangaral Sabin Bapan Namalyari amên kay dambin na pam-in kanên. ");
INSERT INTO blx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kabay mani mapatêl, mamili kaw sa mani kaawyun yun pituy lawyaki ya tanda yuy panggalangên mani tawu, katanda buy natupus Ispiritun Bapan Namalyari, ta sabay silay pagtiwalan yan amên mandambin mam-in kanên. ");
INSERT INTO blx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Buy sikay, mail-an yan na sarili yan sa panalangin buy pangaral Sabin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nalabayan kaganawan mani manampalataya ya sinabin mani apostul. Kabay pinili la si Esteban ya dilag napas-êy ya panampalataya buy natupus Ispiritun Bapan Namalyari. Pinili la êt silan Felipe, Procoro, Nicanor, Timon, Parmenas, buy si Nicolas ya taga Antioquia. Si Nicolas, alwa yan Judio nuwa napasunul ya sa paniwalan mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","In-arap lay abituy pituy napili la sa mani apostul. Impaluntun mani apostul ya gamêt la buy nanalangin. ");
INSERT INTO blx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kabay niwagaw wa Sabin Bapan Namalyari buy kapanlulumakên mani tagasunul Jesus sa Jerusalem. Kapanlulumakê êt pari ya nanampalataya kana. ");
INSERT INTO blx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Esteban, binyanan yan Bapan Namalyarin kangêdan buy kapangyarian. Kabay malakêy mamakaupapas buy tanda' ya dinyag nay nakitan mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nuwa dilag mani tawuy nakisubakan kan Esteban. Naibilang sila sa pambêgên Pagtipunan mani Tawuy Naibus. Ya mani kaatag kalla, taga Cirene, taga Alejandria, taga Cilicia buy taga Asia. ");
INSERT INTO blx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nuwa a la agyun masambut si Esteban, gawan binyanan yan kabiyasnan Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kabay liim lan insagyat ta dakun umnuy liyakin magsabin kalaraman. Paradi ya impasabi kalla, “Nalêngê yan si Esteban ya nagsabin nadawak laban kan Moises buy kan Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Gawan sa sinabi la, naitustus lan manubag ga mani tawu, mani mangatway manungkulan buy mani manurun Kautusan. Kabay dinakêp la si Esteban buy gintan sa mani mangatwan Judioy mangatuynungan. ");
INSERT INTO blx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Namiarap sila êt mani tawu amên magpapêtêg sa alwan pêtêg laban kan Esteban. Sinabin tawuy in-arap la, “Ya tawun abiin manunggun magsabin nadawak laban sa Templun Bapan Namalyari buy sa Kautusan na impasulat kan Moises. ");
INSERT INTO blx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ta nalêngê yan na sinabi nay si Jesus ya abiin, lasakên nay Templu tamu buy sagilyan nay manan naugalyan na inlakwanan kantamun Moises.” ");
INSERT INTO blx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ya kaganawan kaawyun lay mani mangatwan Judioy mangatuynungan, pinakaêlêw la si Esteban buy nakitan lay lupa nay manginangkinang nanuwad lupan ang-el. ");
INSERT INTO blx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pinatang pinakapuun pari si Esteban, “Pêtêg nayi ya pansabin mani tawu tungkul kamu?” ");
INSERT INTO blx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kabay nakitbay si Esteban, “Mapatêl buy mangatwa ku, pakalêng-ên yuy sabin ku! Si Bapan Namalyari ya makapangyarian, nagpakit ya sa ninunu tamun si Abraham sabitun idi yapun sa Mesopotamia bayu yapun nanugêl sa balayan Haran. ");
INSERT INTO blx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Sinabin Bapan Namalyari kanay, ‘Lakwanan muy lugal mu buy mani kamag-anak mu buy maku ka sa lugal la ituru ku kamu.’ ” ");
INSERT INTO blx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Kabay inlakwanan Abraham ma lugal mani Caldeo ta naku yan nanugêl sa balayan Haran. Sên nati yay bapa na, impalaku yan Bapan Namalyari baydi sa lutay bibiyan tamu amêsên. ");
INSERT INTO blx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sa panawun na abitu, asê pun binyanan Bapan Namalyari si Abraham un agyan kay pêrad da luta. Nuwa nangaku si Bapan Namalyari ya si lugal la ati, idin na kan Abraham buy sa mani layi na agyan ayin pun anak si Abraham. ");
INSERT INTO blx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Paradi ya sinabin Bapan Namalyari kana, ‘Ya mani layi muy manugêl sa kaatag lugal. Ipusun sila baydu buy pasakitan sila sa apat ta ralan na tawun. ");
INSERT INTO blx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nuwa parusan kuy mani tawuy mangipus kalla. Pamakayari, mita sila sa lugal la abitu buy mag-udung sila sa lugal la ati buy ulimênên laku baydi.’ ");
INSERT INTO blx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Buy bilang tanda' sa kasunduwan Bapan Namalyari kalla, in-utus na kan Abraham ma sêpat tulin ya kaganawan lawyaki. Kabay sên in-anak si Isaac, tinuli yan Abraham sa ikawaluy allu. Para êt bayduy dinyag Isaac kan Jacob ya anak na. Buy dinyag êt Jacob ya ati sa mapu buy luway anak na ya ninunu tamu.” ");
INSERT INTO blx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Nuwa ya mani ninunu tamun abiin, kinasêman la si Jose ya ali kallan mipapatêl. Kabay insaliw laya amên magin ipus sa bansan Egipto. Nuwa kaawyun na si Bapan Namalyari buy sinawpan naya sa kaganawan kasakitan na pandanasên na. Binyanan yan Bapan Namalyarin kabiyasnan buy nalabayan yan Faraon ya Arin Egipto. Kabay dinyag nayan mamaala sa buun Egipto buy sa kaganawan pibandiyan na.” ");
INSERT INTO blx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Amêsên, inlumatêng ya panawun layang sa buun Egipto buy sa Canaan. Magkasakit ta mani tawu. Buy ya mani ninunu tamu, ayin silaynan mapangwanan maêkan. ");
INSERT INTO blx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sên natandan Jacob ya dilag awêd masaliw wa trigu sa bansan Egipto, in-utus nay maanak na ya sabay ya mani ninunu tamu amên manaliw sila. Sa nuna lan pamaku baydu, a la nakilala si Jose ya patêl la. ");
INSERT INTO blx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nuwa sa ikalwan pamaku la baydu, nagpakilalay na si Jose kalla. Kabay natandan Faraon ya tungkul sa pamilyan Jose. ");
INSERT INTO blx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pamakayari, in-utus Jose ya ipalakuy bapa na ya si Jacob sa Egipto kaawyun ya buun pamilya na. Pitumpu buy lima silan mipapamilya. ");
INSERT INTO blx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kabay naku si Jacob sa Egipto buy maanak na ya ninunu tamu. Nanugêl sila baydu buy baydu silayna nati. ");
INSERT INTO blx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","In-uli baydi sa luta tamuy mani bangkay la buy in-ilbêng sa Shekem sa pamilbêngan na sinaliw Abraham sa mani anak Hamor sabitun nuna.” ");
INSERT INTO blx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Sên marani yan matupad da pangakun Bapan Namalyari kan Abraham, ya mani ninunu tamu baydu sa Egipto, kapanlulumakê la. ");
INSERT INTO blx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sa pamisasagilin mani ari, inlumatêng nga panawun na dilag bayuy ari ya a na tanday tungkul kan Jose. ");
INSERT INTO blx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ya arin ati, pinurayit nay mani ninunu tamu buy pinasakitan na sila sa kapamilatan pamilit na kallan lakwanan lay mani kulaw la sa lawasan amên mati.” ");
INSERT INTO blx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Abitu êt ta panawun ya in-anak si Moises ya gisay anak ya kinaidwan Bapan Namalyari. Sinaysay yan mangatwa na sa bali la un tatluy buwan. ");
INSERT INTO blx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nuwa sên napilitan layan lakwanan, kingwa yan babayi ya anak Faraon buy sinaysay nayan intuwad nan pêtêg nan anak. ");
INSERT INTO blx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tinurwanan si Moises sa kaganawan kabiyasnan mani tawu sa Egipto buy nagin dakila ya sa sabi buy sa mani diyag na.” ");
INSERT INTO blx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Sên apattapuy tawun nan Moises, naisipan nan maglimbun sa mani kaparisu nan Israelita amên êlêwên na nu sabêt tay nalyari kalla. ");
INSERT INTO blx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Sên idi yina baydu, nakitan nay kaparisu nan Israelita ya pampasakitin gisay taga Egipto. Sinawpan nay kaparisu na buy sa pangablas na, pinati nay abituy taga Egipto. ");
INSERT INTO blx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Indap na nu mapukatan mani kaparisu nay sabay siyay gamitin Bapan Namalyarin mamiligtas kalla, nuwa a la napukatan. ");
INSERT INTO blx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pamakawasak, nalatêng nay luway kaparisu nan Israelitay mipapati. Labay na dayin mikasundu sila. Kabay sinabi na, ‘Uysiyan mipapati kaw yata, alwa nayin parisu kaw Israelita?’ ");
INSERT INTO blx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nuwa ya namasakit sa kaparisu na, intulak na si Moises buy sinabi na, ‘Sisabêt ta nam-i kamun karapatan mamunu buy mangukum kanyan? ");
INSERT INTO blx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Labay muku êt nayin patin kaparisun pamati mu sa taga Egipto saybi?’ ");
INSERT INTO blx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sên nalêngên Moises ya abiin, tinumakas ya buy naku sa lugal la pambêgên Midian. Nanugêl ya baydu bilang dayuwan buy baydu winan nag-asawa buy nakaanak yan luway liyaki.” ");
INSERT INTO blx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nilabas say apattapuy tawun, idi sa kakyangan si Moises ya marani sa Bung-uy Sinai. Nagpakit baydu kanay gisay ang-el Bapan Namalyari sa nayêpay puun kayuy magdêkêtdêkêt. ");
INSERT INTO blx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sên nakitan Moises ya abitu, nakaupapas ya. Kabay pinagdanyan nay ati amên êlêwên na. Sên mamadanidani yina, nalêngê nay tunuy Bapan Namalyari ya nagsabin, ");
INSERT INTO blx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Siku ya Namalyarin mani ninunu mu ya silan Abraham, Isaac, buy Jacob.’ Sên nalêngên Moises ya ati, nanginagin ya gawan sa limu buy a yina makaêlêw. ");
INSERT INTO blx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Sinabin Bapan Namalyari kana, ‘Itas muy isteping mu, gawan idi ka sa banal la lugal. ");
INSERT INTO blx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mangakit kuy kasakitan mani tawu ku sa Egipto buy mangalêngê kuy pamikilunuslunus la. Kabay nagtabuy yaku baydi amên iligtas sila. Maglêan kay Moises, ta sikay iutus kun mag-udung sa Egipto.’ ” ");
INSERT INTO blx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Si ati si Moises, insakwil yan mani kaparisu nan Israelita sabitun sinabi la kanay, ‘Awta sisabêt ta nam-i kamun karapatan mamunu buy mangukum kanyan?’ Nuwa agyan parabaydu, sa kapamilatan sawup ang-el la nagpakit kana sa nayêpay puun kayu ya magdêkêtdêkêt, si Moises pun êt ta in-utus Bapan Namalyarin mamunu buy mamiligtas kalla. ");
INSERT INTO blx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises êt ta namiawas kaparisu nan Israelita sa kasakitan la baydu sa Egipto. Nanyag yan mani mamakaupapas buy mani tanda' sa Egipto, sa Dagat ta Naudit buy sa kakyangan sa lalên apattapuy tawun. ");
INSERT INTO blx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Moises êt ta nagsabi sa mani kaparisu nan, ‘Lumatêng nga panawun na si Bapan Namalyari, mamili yan gisay propetay nanuwad kangku ya kalayi yu.’ ");
INSERT INTO blx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Sên nititipun na mani ninunu tamu sa kakyangan, si Moises ya namilatan sa mani tawu buy sa ang-el ya nakisabi kana sa Bung-uy Sinai. Sabay siya êt ta nananggap Sabin Bapan Namalyari ya mam-in biyay amên idin êt kantamu.” ");
INSERT INTO blx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nuwa a ya sinunul mani ninunu tamu, nun a insakwil laya bilang pinunu la. Buy labay la pun na mag-udung sila sa Egipto. ");
INSERT INTO blx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Sinabi la kan Aaron, ‘Idyag mukay diyusdiyusan na manguna kanyan, gawan a yan tanda nu sabêt tay nalyari sa Moises ya abiin ya namipaawas kanyan sa Egipto.’ ");
INSERT INTO blx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kabay nanyag silan ribultuy kaparisun biserun baka. Pamakayari, namati silan saysay la ya in-andug la baydu sa ribultu. Nagkalutu silan nagsaya sa pangulimên baydu sa arapan ribultuy dinyag la. ");
INSERT INTO blx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Gawan baydu, tinalibatukan silan Bapan Namalyari buy pinaulayan na silan mangulimên sa allu, buwan, buy bêtêwên sa langit. Ya dinyag la, kaparisun insulat mani propeta sabitun nuna, ‘Sikaw wa mani Israelita, sa lalên apattapuy tawun sa kakyangan, namiandug kaw mani pinati ya saysay, nuwa alwan sikuy piniandugan yu. ");
INSERT INTO blx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pigêgtan yu pun êt ta toldan diyusdiyusan yu ya si Molec buy ya diyusdiyusan yuy si Renfan na nagwangis bêtêwên. Dinyag yuy mani abiin amên ulimênên yu sila. Kabay ipatas kataw mas marayu pun sa Babilonia.’ ” ");
INSERT INTO blx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Sinabi pun êt Esteban, ‘Sabitun idi pun sa kakyangan na mani ninunu tamu, gintan lay tolday tanda' un pangawyun kallan Bapan Namalyari. Dinyag lay toldan ati ayun sa utus Bapan Namalyari kan Moises buy sa palanuy impakit kana. ");
INSERT INTO blx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Sên nati ya si Moises, si Josue ya kasagili nan namunu sa mani ninunu tamu. Buy pigêgtan lay toldan abiin sabitun sinakup lay lutay impangakun Bapan Namalyari buy impatas Bapan Namalyari ya mani manan manugêl baydi. Buy nanugêl êt baydi ya tolda angga sa panawun pag-arin David. ");
INSERT INTO blx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kinaidwan Bapan Namalyari si Arin David. Kabay nanyawad yan paintulut kan Bapan Namalyari ya mipaydêng yan Templun Bapan Namalyari amên baydu mangulimên na mani layin Jacob. ");
INSERT INTO blx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nuwa a ya tinulutan Bapan Namalyari, nun a si Solomon na anak na ya sabay ya namipaydêng Templun Bapan Namalyari.’ ” ");
INSERT INTO blx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nuwa agyan parabaydu, si Bapan Namalyari ya Katatag-ayan, a ya manugêl sa bali ya dinyag tawu. Gawan ati ya sinabi na sa kapamilatan propeta Isaias, ");
INSERT INTO blx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Miknu wakun mag-ari sa langit, buy babun lutay tuturakan bitis ku. Kabay agyan sabêt man na kalasin bali ya daygên yu para kangku, asê minukad kangku. Ayin dakun sabêt man na lugal la malyari kun pagpaynawan. ");
INSERT INTO blx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Alwa nayin sikuy nanyag kaganawan bagay ya abiin?’ ” ");
INSERT INTO blx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Insundu pun êt Esteban na pagsabi na, “Taganan nakdêy ya ulu yu! Para kaw mani alwan Judioy asê kalabay maniwala kan Bapan Namalyari buy a yu labay lêng-ên na mani sabi na. Natubus-tubus yuy ugalin mani ninunu yu, ta pawa yun pangkalabanên na Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ayin propeta sa panawun ninunu yuy a la pinasakit. Agyan na mani mamipatanda tungkul sa pallumatêng Matinêk ka Lingkud, pinati la êt. Buy sabitun inlumatêng ya, sikaw êt ta namisupakat buy namati kana. ");
INSERT INTO blx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Sikaw wa nananggap sa Kautusan na indin Bapan Namalyari sa kapamilatan mani ang-el, nuwa a yu sinunul la abiin.” ");
INSERT INTO blx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sên nalêngên mani mangatwan Judioy mangatuynungan na abiin, sadyay tubag la kan Esteban. Kabay mingêngêt ta bêbêy la. ");
INSERT INTO blx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nuwa ya Ispiritun Bapan Namalyari idi kan Esteban. Kabay nangêlêw ya sa langit buy nakitan nay sawang Bapan Namalyari buy nakitan na êt si Jesus ya nakaidêng sa wanan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kabay sinabin Esteban, “Elêwên yu. Makitan kuy langit ta nakabuklat buy makitan ku êt si Jesus ya in-Anak Tawuy nakaidêng sa wanan Bapan Namalyari!” ");
INSERT INTO blx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kabay nan-angaw wa mani mangatwan Judioy mangatuynungan buy tinêmpanan lay têk la amên a la malêngêy pansabin Esteban. Buy niaagnan silan nanduyung kana. ");
INSERT INTO blx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ginuluy la si Esteban paawas sa balayan buy pinisasawpan layan binatwan. Ya mani magpapêtêg laban kan Esteban, intas lay mani balabal la buy imbalag sa gisay bayuntawuy naglagyun Saulo. ");
INSERT INTO blx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kaban pambatwan la si Esteban, manalangin ya. Sinabi na, “Panginuun Jesus, tanggapên muy kaladwa ku.” ");
INSERT INTO blx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pamakayari, nanduku ya buy masnêg nan sinabi, “Panginuun, patawarên mu sila sa kasalanan na pandaygên la kangku.” Buy pamakasabi nan abiin, nati ya. ");
INSERT INTO blx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","In-ilbêng si Esteban un mani tawuy dilag limu kan Bapan Namalyari buy sadyay panangis la kana. Ubat ta baydu, nag-umpisay nay sadyay pamasakit sa mani manampalatayay miaawyun na idi sa Jerusalem. Kabay nikyat sila sa buun prubinsyan Judea buy sa prubinsyan Samaria. Kay ya mani apostul tay nabalag sa Jerusalem. Si Saulo ya nakiayun sa pamati kan Esteban, ");
INSERT INTO blx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ya sabay êt ta magpilit amên sirên nay pamibêbêtêk mani manampalatayay miaawyun. Kabay sinunan nay balang balin mani manampalataya, ta dakpên na silan guluyun buy ipasukul, lawyaki man o babayi. ");
INSERT INTO blx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ya mani manampalataya kan Jesus, nangapisisyay sa magmikakanayun na lugal. Nuwa agyan antuman na kapilakwan la, pan-iaral lay Mangêd da Balita tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Felipe, gisa ya kalla. Inlumunsan ya sa gisay balayan sa prubinsyan Samaria buy nangaral ya tungkul kan Jesus ya sabay ya Cristuy impangakun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Sên nalêngên mani tawuy pansabin Felipe buy sên nakitan lay mani mamakaupapas ya dinyag na, pinakalêngê laya. ");
INSERT INTO blx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Impatas nay mani nangadadawak ka ispirituy nagsêdak sa malakêy tawu. Kaban mag-awas ya nangadadawak ka ispiritu sa mani tawu, man-angaw silan masnêg. Malakê êt ta lumpu buy pilay ya inumiyul. ");
INSERT INTO blx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kabay natulatulay mani tawu sa balayan abitu. ");
INSERT INTO blx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Dilag liyaki ya maglagyun Simon na manugêl êt baydu sa Samaria. Manay nan manyag mamakaupapas sa mani taga Samaria sa kabiyasnan nan manalamangka. Buy pan-ipadayêw nay dilag yan kapangyarian. ");
INSERT INTO blx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mallêngê kanay kaganawan tawu sa balayan abitu, matag-ay man o nayêpay pangatawu la. Pansabin la, “Si Simon, dilag yan kapangyarian Bapan Namalyari ya pambêgên Dakilan Kapangyarian.” ");
INSERT INTO blx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Labaylabay yan lêng-ên mani tawu, gawan mana nayna silan napaupapas sa kabiyasnan nan manalamangka. ");
INSERT INTO blx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nuwa sên in-aral Felipe ya Mangêd da Balita tungkul sa pag-arin Bapan Namalyari buy tungkul kan Jesu Cristu, nanampalataya sila buy nagpabawtismu, lawyaki buy babayi. ");
INSERT INTO blx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Si Simon, nanampalataya ya êt. Nagpabawtismu ya buy nakilaku ya kan Felipe. Nakaupapas ya sa mani imala buy mamakaupapas ya dinyag Felipe. ");
INSERT INTO blx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pamakalêngên mani apostul sa Jerusalem ya nanampalatayay mani taga Samaria sa Sabin Bapan Namalyari, in-utus la baydu si Pedro buy si Juan. ");
INSERT INTO blx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pamakalatêng la sa Samaria, nanalangin sila para sa mani manampalataya baydu amên matanggap lay Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tagawan agyan nabawtismuwan silayna sa lagyun Panginuun Jesus, a la pun natanggap pa Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Impaluntun Pedro buy si Juan na gamêt la sa mani manampalataya kan Jesus buy natanggap lay Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Nakitan Simon ya sa kapamilatan pamipaluntun gamêt mani apostul sa mani manampalataya, natanggap lay Ispiritun Bapan Namalyari. Kabay sinabin Simon kan Pedro buy kan Juan, “Biyan kataw pera nu biyan yukun parabaysên na kapangyarian amên nu sisabêt man na paluntuwan kun gamêt ku, matanggap la êt ta Ispiritun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nuwa nakitbay si Pedro kana, “Sika, milaku ka dayi sa ayin katganan na kaparusan kaawyun na pera mu. Gawan indap mu nu mabiyan kan kapangyarian Bapan Namalyari sa kapamilatan pera mu. ");
INSERT INTO blx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A ka kaawyun sa pandaygên yan, gawan madinat ta bêkê mu sa pangêlêw Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kabay pagsisyan muy nadawak ka diyag mu buy manalangin ka sa Panginuun ya dayi patawarên naka sa madinat ya pan-isipin mu. ");
INSERT INTO blx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ta makitan kuy sadyay pangasêm mu buy ipus kan kasalanan.” ");
INSERT INTO blx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nuwa sinabin Simon kalla, “Nu malyari, manalangin kaw sa Panginuun para kangku amên asê malyari kangkuy parusay pansabin yu.” ");
INSERT INTO blx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nagpapêtêg si Pedro buy si Juan sa nakit lay dinyag Jesus buy nangaral silan sabi na. Pamakayarin abitu, nag-udung sila sa balayan Jerusalem. Buy sa pamuli la, in-aral lay Mangêd da Balita tungkul kan Jesus sa mani baryuy madanan la sa prubinsyan Samaria. ");
INSERT INTO blx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Amêsên, dilag gisay ang-el Panginuun ya nagsabi kan Felipe, “Tambêng kan maku sa timug buy tutun muy dan ubat sa Jerusalem papakun sa Gaza.” Ya dan abitu, ayin nan mayngan manduman. ");
INSERT INTO blx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Kabay tambêng namita si Felipe buy kaban mamita ya, nakitan nay liyaki ya taga Etiopia. Matag-ay ya tungkulan na gawan siyay pinitiwalan sa pibandiyan Candace. Ya labay sabin Candace, reynan Etiopia. Ya nagtungkulan, pauli yinan ubat sa Jerusalem nu saantu yan nangulimên kan Bapan Namalyari buy pauli yinan nakasakay sa kalesa. Kaban mamitay kalesa na, mamasa yan libruy insulat propeta Isaias. ");
INSERT INTO blx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Sinabin Ispiritun Bapan Namalyari kan Felipe, “Danyan muya buy pakiagnanan muy kalesa na.” ");
INSERT INTO blx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kabay nuwayu si Felipe buy natagal nay kalesa. Nalêngê nay mamasay nagtungkulan sa librun propeta Isaias. Kabay pinatang yan Felipe, “Mapukatan mu nayi ya pambasên mu?” ");
INSERT INTO blx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nakitbay ya nagtungkulan, “A ya bay! Parasaantu kun mapukatan nu ayin mamipapukat kangku?” Kabay sinagyat na si Felipe un magsakay sa kalesa na buy pinaiknu na sa dani na. ");
INSERT INTO blx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ati ya baagin Kasulatan na pambasên na, “A ya nagdeklamu. Kaparisu yan tupay gêgtan sa pamatyan, o sa gisay biserun tupay nabêlêng nga ayin tarit kaban pan-urugun. ");
INSERT INTO blx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dinustak ya buy asê ustuy pangatul kana. Ayin makapagsabi tungkul sa mani layi na, gawan tambêng layan pinati.” ");
INSERT INTO blx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sinabin nagtungkulan kan Felipe, “Sabin mu kangku nu sabêt ta pantukuyun propeta, sarili na nayi o kaatag tawu?” ");
INSERT INTO blx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kabay ubat sa abituy baagin Kasulatan na binasa na, in-aral Felipe kanay Mangêd da Balita tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sa pamita la, niras sila sa lugal la naglanêm. Sinabin nagtungkulan kan Felipe, “Elêwên mu. Dilag lanêm di. Dilag pun nayin sangkan amên a ku mabawtismuwan?” ");
INSERT INTO blx_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nakitbay kana si Felipe, “Malyari kaynan bawtismuwan nu manampalataya kan buun bêkê.” Nakitbay ya nagtungkulan, “Awu, manampalataya ku ya si Jesu Cristu ya sabay ya Anak Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Impapatgên nagtungkulan na kalesa buy inlumunsan silan luwa sa lanêm buy binawtismuwan yan Felipe. ");
INSERT INTO blx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sên nagsalwang silayna sa lanêm, tambêng kingwan Ispiritun Panginuun si Felipe. Kabay a yina nakitan nagtungkulan, nuwa matula yan namisundun pamita na. ");
INSERT INTO blx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Bêngat tan idi sa balayan Azoto si Felipe. Paubat ta baydu, nangaral yan Mangêd da Balita sa mani tawu sa kaganawan balayan na mangadanan na angga sa nilatêng ya sa balayan Cesarea. ");
INSERT INTO blx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pan-isundu pun êt Sauloy pagbanta na ya patin nay mani tagasunul Panginuun Jesus. Naku ya sa pinakapuun pari ");
INSERT INTO blx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","buy nanyawad yan sulat ya ipakit na sa mani pinunu sa balin pagtipunan mani Judio sa Damasco bilang pagpapêtêg ga binyanan yan karapatan mandakêp buy mantan sa Jerusalem un sisabêt man na manampalataya sa pangaral Jesus, liyaki man o babayi. ");
INSERT INTO blx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sên marani ya si Saulo sa balayan Damasco, bêngat yatan napalitêngan mamakasilêw wa sawang nga ubat sa langit. ");
INSERT INTO blx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nitugaw ya buy dilag yan nalêngêy tunuy ya nagsabin, “Saulo, Saulo, uysiyan pan-usigin muku yata?” ");
INSERT INTO blx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sinabin Saulo, “Panginuun, sisabêt ka?” Pikitbayan yan tunuy, “Siku si Jesus ya pan-usigin mu. Kay pamparusan mutay sarili mu. Para katan mandansêk sa natayad da kayu.” ");
INSERT INTO blx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nanginagin ya buy nakaupapas buy sinabi nay, “Panginuun, sabêt ta labay mun daygên ku?” Sinabin Panginuun kana, “Midêng ka buy maku ka sa balayan, ta dilag magsabi baydu kamu nu sabêt ta sêpat mun daygên.” ");
INSERT INTO blx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ya mani kaawyun Saulo, kay nakadêtna tana silan asê nakasabi. Nakalêngê silan tunuy, nuwa ayin silan nakitan. ");
INSERT INTO blx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nidêng si Saulo, nuwa sên nimukat yan mata na, a yina makakit. Kabay tinambay yatan mani kaawyun na angga sa balayan Damasco. ");
INSERT INTO blx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tatluy allu nan asê nakakit, asê nangan buy asê maminêm. ");
INSERT INTO blx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Baydu sa Damasco, dilag gisay tagasunul Jesus ya maglagyun Ananias. Pinagkasabi yan Panginuun Jesus sa gisay sulêplêp. Sinabi na, “Ananias!” Nakitbay si Ananias, “Sabêt ta abituy Panginuun?” ");
INSERT INTO blx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Sinabin Panginuun kan Ananias, “Maku ka sa balin Judas, baydu sa dan na pambêgên ‘Matinêk’, buy têkapên mu bayduy liyaki ya taga Tarso ya maglagyun Saulo. Manalangin ya amêsên. ");
INSERT INTO blx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Impakit ku kana sa kapamilatan gisay sulêplêp pa sumun sa binyanan nay gisay liyaki ya maglagyun Ananias ya mipaluntun gamêt kana amên makakit yan manguman.” ");
INSERT INTO blx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nuwa nakitbay si Ananias, “Panginuun, malakêy mangabalitan ku tungkul sa tawun abiin buy nu parasaantu nan pampasakitin na mani manampalataya kamu sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Buy naku ya baydi sa Damasco ya dilag karapatan ubat sa mani mamunun pari amên dakpên na kaganawan manampalataya kamu.” ");
INSERT INTO blx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nuwa sinabin Panginuun kan Ananias, “Mita kayna, ta sabay siyay pinili kun maglingkud kangku amên ipakilala naku sa mani alwan Judio buy sa mani ari la buy kamuyun mani Israelita. ");
INSERT INTO blx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Buy ipakit ku êt kanay malakêy pamasakit ta sêpat nan pibabatan gawan kangku.” ");
INSERT INTO blx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kabay inlakun Ananias si Saulo sa bali ya bibiyan na. Pamakasun na baydu, impaluntu nay gamêt na kan Saulo buy sinabi na, “Saulo, patêl ku sa Panginuun, impalaku waku baydin Panginuun Jesus ya sabay ya nagpakit kamu sa dan sabitun papakun ka baydi. In-utus naku baydi amên makakit kan manguman buy matupus kan Ispiritun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sa uras êt abitu, bêngat tan nanabu sa matan Saulo ya paran mani kaliskis kênan lanêm buy nakakit yan manguman. Pamakayari, nidêng ya buy nagpabawtismu. ");
INSERT INTO blx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nangan ya buy pinumas-êy yan manguman. Nanugêl si Saulo un dakun umnuy allu sa Damasco kaawyun nay mani tagasunul Jesus. ");
INSERT INTO blx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Naku ya sa mani balin pagtipunan mani Judio buy in-aral nay sabay si Jesus ya Anak Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nakaupapas ya kaganawan nakalêngê kana. Kabay sinabi la, “Alwa nayin sabay ya tawun ati ya mamasakit sa mani mamêg sa lagyun Jesus baydu sa Jerusalem? Alwa nayin naku ya baydi amên dakpên na mani manampalataya kan Jesus buy gêtan makagapus sa mani mamunun pari?” ");
INSERT INTO blx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nuwa pinupumas-êy ya nakêm Saulo sa pangaral na. Pinagpapêtgan nay si Jesus sabay ya Cristuy impangakun Bapan Namalyari. Kabay nagluway nakêm mani Judioy manugêl baydu buy a sila nakapakitbay kana. ");
INSERT INTO blx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sên nilabas ya dakun umnuy allu, nipupulung nga mani Judio amên ipalanu la nu parasaantu lan patin si Saulo. ");
INSERT INTO blx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Allu buy yabi lan pan-apatên si Saulo sa mani lawasan balayan amên patin. Nuwa dilag nagsabi kan Saulo ya labay layan patin. ");
INSERT INTO blx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kabay gisay yabi, ingkulsug yan mani tagasunul na sa maragul la tiklis buy intabuy laya sa lawasan pader balayan. ");
INSERT INTO blx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pamakalatêng Saulo sa Jerusalem, sinubukan nan makiawyun sa mani tagasunul Jesus, nuwa malimu sila kana. A sila maniwalan tagasunul linan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nuwa pikilaku yan Bernabe buy gintan sa mani apostul. Ingkuwentun Bernabe kalla nu parasaantun nakit Saulo ya Panginuun Jesus sa dan buy dilag sinabi si Jesus kana. Buy sinabi na êt nu parasaantun kapas-êy ya nakêm Saulo sa pangaral na tungkul kan Jesus baydu sa Damasco. ");
INSERT INTO blx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kabay ubat ta baydu, kaawyun layna si Saulo buy napas-êy ya nakêm nan niaral tungkul kan Jesus agyan saantu man sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Makisabi ya buy makitutul sa mani Judioy magsabin Griego, nuwa nanubag sila buy labay layan patin. ");
INSERT INTO blx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sên natandan mani manampalatayay labay lan daygên kan Saulo, in-atêl laya sa Cesarea buy impauli sa Tarso. ");
INSERT INTO blx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pamakayarin abitu, nipatêtbêk kay mani manampalatayay miaawyun sa buun Judea, sa Galilea, buy sa Samaria. Pinupumas-êy ya panampalataya la buy mambumyay silan dilag limu sa Panginuun. Pampas-êyên Ispiritun Bapan Namalyari ya nakêm la. Kabay inlulumakêy mani manampalataya. ");
INSERT INTO blx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Malakêy lugal la inlakun Pedro amên lakwên na mani manampalataya kan Jesus buy sabin kallay “Nagpapakun kawna.” Naku ya êt sa balayan Lida. ");
INSERT INTO blx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nakilala na bayduy gisay liyaki ya maglagyun Eneas. Sa lalên waluy tawun, kay nakakalêk ya gawan lumpu ya. ");
INSERT INTO blx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Sinabin Pedro kana, “Eneas, pinaiyul kaynan Jesu Cristu. Kabay midêng kayna buy ilulun muy amak mu.” Tambêng nidêng si Eneas. ");
INSERT INTO blx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nakitan kaganawan manugêl sa balayan Lida buy sa Saron na inumiyul la si Eneas. Kabay nanampalataya sila êt sa Panginuun. ");
INSERT INTO blx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Sa balayan Jope, dilag gisay babayi ya tagasunul Jesus ya maglagyun Tabita. Ya lagyu na sa Griego, Dorcas. Pan-iubus nay panawun na sa panyag kangêdan buy pawa yan manawup sa mani kalulu. ");
INSERT INTO blx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nitagun nakatanam ma babayin ati buy nati ya. Inlinis lay bangkay na bayu imburul sa gisay kuwartu sa têngêl. ");
INSERT INTO blx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ya Jope, narani sa Lida. Kabay sên natandan mani tagasunul Jesus ya idi sa Lida si Pedro, in-utus lay luway tawu amên pakisabyan si Pedro ya tambêng yan maku sa Jope. ");
INSERT INTO blx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kabay tambêng nakilaku si Pedro kalla. Pamakalatêng la sa Jope, gintan laya sa kuwartuy piniburulan sa nati. Dilag mani bal-u bayduy manangis. Impakit la kan Pedroy mani yaming nga tinayin Dorcas para kalla sabitun nabyay yapun. ");
INSERT INTO blx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Impaawas Pedroy kaganawan idi sa kuwartu. Nanduku ya buy nanalangin. Pamakayari, nag-arap ya sa bangkay buy sinabi na, “Tabita, midêng ka.” Pamakamukat Tabita, nakitan na si Pedro. Kabay niknu ya. ");
INSERT INTO blx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tinalan Pedroy gamêt na buy sinawpan nayan nidêng. Pamakayari, binêg Pedroy mani nabal-u buy kaatag manampalataya baydu buy impakit na kalla si Tabita ya nabyay yana. ");
INSERT INTO blx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ya nalyarin abiin, niwagaw sa buun Jope. Kabay malakêy nanampalataya sa Panginuun Jesus. ");
INSERT INTO blx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nanugêl pun si Pedro sa Jope un dakun umnuy allu sa balin Simon na mamipakyang balat ayup. ");
INSERT INTO blx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sa balayan Cesarea, dilag gisay liyaki ya maglagyun Cornelio. Kapitan yan mani sundalus Romano ya pambêgên “Batalyun Italianu.” ");
INSERT INTO blx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Si Cornelio buy ya mani kaawyun na sa bali, matinêk ka pamibiyaybiyay la buy dilag silan limu kan Bapan Namalyari. Agyan alwa yan Judio, malakêy naidin nay sawup sa mani kaluluy Judio buy pawa yan manalangin kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gisay allu, sên mag-alas tres san kaawat, nasulêplêp nay gisay ang-el Bapan Namalyari ya sinumun sa bali na buy namêg kana, “Cornelio!” ");
INSERT INTO blx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kabay pinakaêlêw nay ang-el un dilag sadyay limu. Sinabi na, “Sabêt ta abitu?” Nakitbay ya ang-el kana, “A ka panlitêpên Bapan Namalyari gawan inlêngê nay mani panalangin mu buy masaya ya sa panawup mu sa mani kalulu. ");
INSERT INTO blx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Amêsên, mamiutus kan dakun umnuy tawu sa balayan Jope buy ipasalunsun mu si Simon na pambêgên Pedro. ");
INSERT INTO blx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Makitugêl ya baydu sa balin katukayu na ya mamipakyang balat ayup. Ya bali na, idi sa agid dagat.” ");
INSERT INTO blx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Sên nakabitay nay ang-el, binêg Cornelio ya luway ipus na buy ya gisay sundalus na ya pawan maglingkud kana ya kaparisu nan matinêk. ");
INSERT INTO blx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ingkuwentun Cornelio kallay kaganawan nalyari. Pamakayari, in-utus na silan maku sa balayan Jope. ");
INSERT INTO blx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kinawasakan, sên ugtuy nay allu, narani yay mani in-utus Cornelio sa balayan Jope. Si Pedro, nagdakêy ya sa bubung bali amên manalangin. ");
INSERT INTO blx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nalayangan Pedro buy kalabay yinan mangan. Nuwa kaban pan-il-an na kanên, dilag impasulêplêp kana si Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nakitan nan niwang-at ta langit buy dilag kapanyêyêmêpay nanuwad makwal la êwês ya nagsêêl sa apat ta duyu. ");
INSERT INTO blx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nakitan na baydu sa êwês ya kaganawan kalasin ayup. Dilag mamita, mandumakap, buy mallumpad. ");
INSERT INTO blx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pamakayari, dilag yan nalêngêy tunuy ya nagsabin, “Pedro, midêng ka! Mamati kan kêna mu.” ");
INSERT INTO blx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nuwa nakitbay si Pedro, “Panginuun, asê malyari ya abiin! Kanuman a ku nadyag ga abiin gawan a ku mangnan mani ayup pa pan-ituwad madinat buy pan-ibawal kêna.” ");
INSERT INTO blx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nanguman nagsabi kanay tunuy, “Agana mu ituwad madinat ta sabêt man na intuwad Bapan Namalyarin malinis.” ");
INSERT INTO blx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Katitlun nalyari ya ati buy pamakayari, tambêng nitag-ay ya êwês sa langit. ");
INSERT INTO blx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kaban asê makwan maisip Pedro nu sabêt ta labay sabin nasulêplêp na, inlumatêng sa lugal abituy mani tawuy in-utus Cornelio. Sên natandan lay balin Simon, naku sila sa pasbul bakud. ");
INSERT INTO blx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Namêg sila, “Dilag nayin manugêl baydi ya maglagyun Simon Pedro?” ");
INSERT INTO blx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kaban pan-isipin pun Pedroy labay sabin nakit na, sinabi kanan Ispiritun Bapan Namalyari, “Dilag tatluy tawuy mangkap kamu. ");
INSERT INTO blx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kabay midêng kayna buy magtabuy. Agana ka magmikakunun kilaku kalla, ta sikuy namiutus kalla.” ");
INSERT INTO blx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kabay nagtabuy si Pedro buy sinabi na sa mangkap kana, “Sikuy pantêkapên yu. Sabêt ta maisawup ku kamuyu?” ");
INSERT INTO blx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nakitbay sila, “In-utus kay baydin kapitan Cornelio. Mangêd yan tawu buy dilag yan limu kan Bapan Namalyari buy panggalangên yan kaganawan Judio. Sinabin banal la ang-el kanay sagyatên naka sa bali na amên malêngê na nu sabêt ta sabin mu.” ");
INSERT INTO blx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kabay pinasun silan Pedro amên baydu silayna mabêlêw sa yabin abitu. Pamakamaranun, nakilaku si Pedro kalla. Nakilaku êt kanay dakun umnuy mapatêl kan Jesus ya taga Jope. ");
INSERT INTO blx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sên nilabas ya gisay allu, inlumatêng silan Pedro sa balayan Cesarea. Mangêtêng kalla si Cornelio buy mani kamag-anak na buy mani kaluguran nay sinagyat na. ");
INSERT INTO blx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Sên pasun na si Pedro, timbêng yan Cornelio. Buy nanduku ya sa arapan Pedro amên ulimênên naya. ");
INSERT INTO blx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nuwa pinaidêng yan Pedro. Sinabi na, “Midêng ka. Agana muku ulimênên, ta kay kaparisu muku êt tawu.” ");
INSERT INTO blx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Buy kaban pan-isundu lay pamisasabi la, pasun sila sa bali, siyan nakitan Pedroy malakêy tawuy mititipun baydu. ");
INSERT INTO blx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kabay sinabin Pedro kalla, “Tanda yuy bawal sa kautusan yan Judio ya makiawyun o magliwa sa mani alwan Judio. Nuwa impatanda kangkun Bapan Namalyari ya a ku ituwad madinat ta agyan sisabêt man. ");
INSERT INTO blx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kabay sên impasalunsun yuku, a ku nagmikakunun nakilaku sa mani in-utus Cornelio. Amêsên, labay kun matandan uysiyan impasalunsun yuku yata.” ");
INSERT INTO blx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kabay sinabin Cornelio, “Tatluy nay alluy nilabas sabitun nanalangin naku sa bali un paradi êt ta uras ya mag-alas tres san kaawat. Kaban manalangin naku, bêngat tan nagpakit sa arapan kuy gisay liyaki ya nakaidêng nga mamakapasilêw wa yaming. ");
INSERT INTO blx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Sinabi na kangku, ‘Cornelio, inlêngên Bapan Namalyari ya panalangin mu buy a na nalitêpan na panawup mu sa mani kalulu. ");
INSERT INTO blx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Amêsên, mamiutus kan mani tawuy maku sa Jope buy ipasalunsun mu si Simon na pambêgên Pedro. Makitugêl ya baydu sa balin katukayu na ya mamipakyang balat ayup. Ya balin abituy katukayu na, idi sa agid dagat.’ ");
INSERT INTO blx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kabay tambêng katan impasalunsun. Salamat ta naku ka baydi. Amêsên, idi kay baydi sa arapan Bapan Namalyari amên lêng-ên na pan-ipasabi na kamu.” ");
INSERT INTO blx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kabay nagsabi si Pedro, “Amêsên, tanda kinay asê mamili si Bapan Namalyari sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Buy pantanggapên nay sisabêt man na tawu, agyan sabêt pun na layi na, nu dilag yan limu kana buy matinêk ka pandaygên na. ");
INSERT INTO blx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tanda yuy Mangêd da Balitay impatandan Bapan Namalyari kanyan mani Israelita ya malyarin makibêtêk ka mani tawu kan Bapan Namalyari sa kapamilatan Jesu Cristu ya sabay ya Panginuun kaganawan. ");
INSERT INTO blx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tanda yu êt ta mani nalyari sa buun Judea tungkul kan Jesus ya taga Nazaret. Nag-umpisay ati sa prubinsyan Galilea pamakayarin nangaral Juan tungkul sa pamawtismu. ");
INSERT INTO blx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Si Jesus ya taga Nasaret, tinupus yan Ispiritun Bapan Namalyari buy kapangyarian na. Kabay naku ya sa magmikakanayun na lugal la pawan manyag kangêdan buy pinaiyul nay kaganawan sinêdakan buy pampasakitan Satanas.” ");
INSERT INTO blx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sinabi pun Pedro, “Sikay yanay magpapêtêg sa kaganawan dinyag na, gawan nakit yan na ati sa Jerusalem buy sa kaatag pun balayan mani Judio. Pinati yan mani Judio sa kapamilatan pamipaku la sa kurus. ");
INSERT INTO blx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nuwa sa ikatluy allu, pinabyay yan Bapan Namalyari buy nagpakit ya kanyan. ");
INSERT INTO blx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A ya nagpakit sa kaganawan, nun a kay kanyan mani pinilin Bapan Namalyari ya magpapêtêg ya nabyay yan nanguman. Ta sabitun nabyay yan nanguman, napagkaawyun yan yapun êt nangan buy ninêm. ");
INSERT INTO blx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","In-utus na kanyan na mangaral kay Mangêd da Balita sa mani tawu buy magpapêtêg ga si Jesus sabay ya pêtêg pinilin Bapan Namalyari un mangukum sa mani nabyay buy sa nangamamati. ");
INSERT INTO blx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Sabay siyay pantukuyun mani propeta ya nu sisabêt man na manampalataya kana, patawarên yan Bapan Namalyari sa kaganawan kasalanan na sa kapamilatan lagyun Jesus.” ");
INSERT INTO blx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kaban magsabi pun si Pedro, inlumatêng ngay Ispiritun Bapan Namalyari sa mani mallêngê kana. ");
INSERT INTO blx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nakaupapas ya mani manampalatayay Judio ya nakilaku kan Pedro ubat sa Jope, gawan indin êt sa mani alwan Judio ya Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Natandan lay abitu gawan nalêngê lay magsabi silan Cornelio un magmikakanayun na sabi ya a la pun natandan buy mangulimên sila kan Bapan Namalyari. Kabay sinabin Pedro, ");
INSERT INTO blx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Natanggap lay nay Ispiritun Bapan Namalyari kaparisu tamu agyan alwa silan Judio. Kabay ayin nan makabênbên kalla amên bawtismuwan sila.” ");
INSERT INTO blx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kabay in-utus Pedroy bawtismuwan sila sa lagyun Jesu Cristu. Pamakayarin abitu, pikisabi la kan Pedroy manugêl yapun baydu kalla un dakun umnuy allu. ");
INSERT INTO blx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nabalitan mani apostul buy mani mapatêl kan Cristu sa prubinsyan Judea ya si mani alwan Judio, nananggap sila êt Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sên nag-udung nga si Pedro sa balayan Jerusalem, inuyam yan mani manampalatayay Judioy magsabin kaylangan magpatuli ya mani alwan Judio bayu sila makiawyun kalla. ");
INSERT INTO blx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Sinabi la kan Pedro, “Pakan Judio ka yata, uysiyan sinumun ka sa balin mani alwan Judio buy nakiêkan kalla ta?” ");
INSERT INTO blx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kabay impaintindin Pedro kallay kaganawan nalyari kana. ");
INSERT INTO blx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Sinabi na kalla, “Kaban idi yaku sa balayan Jope ya manalangin, dilag impakit ta sulêplêp kangku si Bapan Namalyari. Nakitan kuy nanuwad makwal la êwês ya kapanyêyêmêpan ubat sa langit ta nagsêêl sa apat ta duyu buy inyêpa sa dani ku. ");
INSERT INTO blx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pinapakapupus kun inêlêw wa abitu buy nakitan ku bayduy umnuy kalasin ayup. Dilag mangasilêb buy asê mangasilêb, mandumakap, buy mani mallumpad. ");
INSERT INTO blx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Buy nalêngê kuy tunuy ya nagsabi kangkun, ‘Pedro, midêng ka. Mamati kan kêna mu.’ ");
INSERT INTO blx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nuwa nakitbay yaku, ‘Panginuun, asê malyari ya abiin! Kanuman, a ku mangnan mani ayup pa pan-ituwad madinat buy pan-ibawal kêna.’ ");
INSERT INTO blx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pamakayari, nanguman nagsabi ya tunuy ya ubat sa langit, ‘Agana mu ituwad madinat ta sabêt man na intuwad Bapan Namalyarin malinis.’ ");
INSERT INTO blx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Katitlun nalyari ya ati buy pamakayari, nabunay ya êwês patag-ay sa langit.” ");
INSERT INTO blx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sa uras êt abitu, baydu sa bali ya bibiyan ku, inlumatêng nga tatluy lawyaki ya ubat sa balayan Cesarea ya in-utus Cornelio ya manalunsun kangku. ");
INSERT INTO blx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sinabin Ispiritun Bapan Namalyari kangkuy agana ku magmikakunun kilaku kalla agyan alwa silan mani Judio. Kabay nakilaku waku buy sinumun sa balin Cornelio sa balayan Cesarea, kaawyun kuy anêm ma mapatêl tamuy manampalatayay taga Jope. ");
INSERT INTO blx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ingkuwentun Cornelio kanyan na dilag yan nakitan na gisay ang-el sa lalên bali na ya nagsabi kanan, ‘Mamiutus ka sa Jope amên salunsunun si Simon na pambêgên Pedro. ");
INSERT INTO blx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ta sabin kanun Pedro nu parasaantu kan miligtas buy buun pamilya mu.’ ” ");
INSERT INTO blx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Buy sên nag-umpisa kun nagsabi, inlumatêng ngay Ispiritun Bapan Namalyari kalla, kaparisun nalyari kantamu sabitun nuna. ");
INSERT INTO blx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Buy naganaka kuy sinabin Panginuun Jesus, ‘Namawtismu si Juan sa lanêm, nuwa bawtismuwan kaw Bapan Namalyari sa Ispiritu na.’ ");
INSERT INTO blx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ya mani alwan Judio, binyanan silan Bapan Namalyarin Ispiritu na kaparisun dinyag na kantamun Judio ya nanampalataya kan Panginuun Jesu Cristu. Kabay nu parabayduy kalabayan Bapan Namalyari, sisabêt taku amên mamênbên kan Bapan Namalyari?” ");
INSERT INTO blx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sên nalêngên mapatêl la Judioy abiin, a layna inuyam si Pedro, nun a inulimên lay Bapan Namalyari buy sinabi la, “Nu parabaydu, ulimênên si Bapan Namalyari, ta binyanan nan panawun na mani alwan Judio amên magsisi buy mabiyan silan biyay ya ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ubat ta sa pinati si Esteban, nikyat ta mani manampalataya gawan sa pamasakit kalla. Dilag nilaku sa prubinsyan Fenicia, sa islan Cyprus, buy sa balayan Antioquia. Agyan dakun antuy lakwên la, pan-iaral lay Mangêd da Balita, nuwa kay sa mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nuwa ya kaatag gaman manampalatayay taga Cyprus buy taga Cirene, naku sila sa Antioquia buy namiaral Mangêd da Balita tungkul sa Panginuun Jesus, agyan sa mani Griego. ");
INSERT INTO blx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kaban mangaral sila, idi kallay kapangyarian Panginuun. Kabay malakêy tawuy nanampalataya buy nanunul sa Panginuun. ");
INSERT INTO blx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ya nalyarin abiin, nabalitan mani manampalatayay miaawyun sa Jerusalem. Kabay in-utus la si Bernabe sa balayan Antioquia. ");
INSERT INTO blx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pamakalatêng na baydu, sinumaya ya, gawan nakit nay mani kangêdan na dinyag Bapan Namalyari sa mani tawu baydu. Buy inaralan na silan manugêl tapat buy napas-êy ya panampalataya sa Panginuun. ");
INSERT INTO blx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mangêd da tawu si Bernabe. Buy natupus yan Ispiritun Bapan Namalyari buy napas-êy ya panampalataya na. Kabay malakêy tawu sa Antioquia ya nanampalataya sa Panginuun. ");
INSERT INTO blx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pamakayari, naku si Bernabe sa Tarso amên têkapên si Saulo. ");
INSERT INTO blx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sên nakitan nayna si Saulo, pikilaku nayan nag-udung sa Antioquia. Buy sa lalên gisay tawun, nakiawyun sila sa mani manampalatayay miaawyun baydu buy malakêy tawuy tinurwanan la. Sa balayan Antioquia, baydu nunan binêg “Cristiyanu” ya mani tagasunul Jesus. ");
INSERT INTO blx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sa panawun na abitu, inlumatêng sa Antioquia ya mani propetay ubat sa balayan Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ya lagyun gisa kalla, si Agabo. Nidêng ya buy nipatanda sa kapamilatan Ispiritun Bapan Namalyari ya dilag lumatêng nga sadyay layang sa buun babun luta. Nalyari ya ati sa panawun Emperador Claudio. ");
INSERT INTO blx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kabay napikasunduwan mani tagasunul Jesus sa Antioquia ya si balang gisa kalla mipagtan sawup sa mani mapatêl sa prubinsyan Judea ayun sa agyu lan idin. ");
INSERT INTO blx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Impagtan lay mani sawup la kallan Bernabe buy kan Saulo amên idin la sa mani mamunu sa manampalatayay miaawyun sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sa panawun abitu, nag-umpisay pamasakit Arin Herodes sa dakun umnuy manampalataya. ");
INSERT INTO blx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Impaputus nay bêng Santiago ya patêl Juan. ");
INSERT INTO blx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Gawan sa dinyag na, napasaya nay mani Judio. Kabay impadakêp na êt si Pedro. Nalyari ya ati sabitun panawun Pestan Tinapay ya Ayin Pamalbag. ");
INSERT INTO blx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Impasukul na si Pedro buy impabantay na sa apat ta grupun mani sundalus ya dilag tiapat ta sundalus ya misasagilin magbantay pamakayarin tatluy uras. Pan-isipin Herodes ya pamakayarin Pestan Kaligtasan, litisin na si Pedro sa arapan mani tawun balayan. ");
INSERT INTO blx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kaban idi sa sukulan si Pedro, buun nakêm manalangin na mani manampalatayay miaawyun para kana. ");
INSERT INTO blx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Sa yabin abitu, bayu iarap sa pallitisan si Pedro, mamabêlêw yan nakagapus sa luway tanikala sa pisaêtan luway sundalus. Buy dilag pun êt mani bantay sa pasbul sukulan. ");
INSERT INTO blx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bêngat tan sinumawang sa lalên sukulan buy nagpakit ta gisay ang-el Panginuun. Dinalpi na sa tagyang si Pedro buy sinabi na, “Mimata ka. Parasên mu!” Buy nitas ya mani tanikala sa gamêt Pedro. ");
INSERT INTO blx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Sinabin ang-el, “Magyakês ka buy mag-isteping ka.” Buy dinyag Pedroy abitu. Sinabi pun êt ang-el kana, “Upungan muy lawini mu buy manunul ka kangku.” ");
INSERT INTO blx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Buy nanunul ya sa ang-el paawas sa sukulan. Asê tandan Pedro nu pêtêg ga nalyari, tagawan indap na, kay sulêplêp nay abitu. ");
INSERT INTO blx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kay inlibasan lay mumuna buy ikalway mani magbantay. Pamakalatêng la sa bakal la pasbul papakun sa balayan, bêngat tan nibuklat ta ati. Sên nakaawas silayna, nalibasan lay gisay dan. Bêngat tan naplak ka ang-el. ");
INSERT INTO blx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Baydu pun natandan Pedroy alwa awêd sulêplêp pa ati. Kabay sinabi na, “Pêtêg awêd da in-utus Panginuun na ang-el na buy inligtas naku sa kapangyarian Herodes buy sa labay daygên mani Judio kangku.” ");
INSERT INTO blx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sên napukatan nay nalyari, naku ya sa balin Maria ya indun Juan ya pambêgên êt Marcos. Malakêy tawuy nititipun baydun manalangin. ");
INSERT INTO blx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nagbêg si Pedro sa pasbul un bakud buy inlaku yan gisay ipus ya naglagyun Roda amên matandan nu sisabêt ta magbêg. ");
INSERT INTO blx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Natunuyan nay si Pedroy abitu. Kabay sa sadyay saya na, a nayna pun imbuklat ta pasbul, nun a nuwayu yan sinumun amên ipatanda sa mani kaawyun nay idi sa lawasan si Pedro. ");
INSERT INTO blx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Sinabi la kan Roda, “Tinulaw kay na lawês!” Nuwa pan-ipilit nay naman, “Pêtêg idi sa lawasan si Pedro.” Kabay sinabi la, “Dat ang-el Pedroy abitu.” ");
INSERT INTO blx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nuwa paraman baydu, magbêg pun êt si Pedro. Kabay imbuklat lay pasbul buy sên nakitan laya, nakaupapas sila. ");
INSERT INTO blx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kabay siningyalan silan Pedron agana mantarit. Buy ingkuwentu na kalla nu parasaantu yan in-awas Panginuun sa sukulan buy sinabi na kalla, “Sabin yuy ati ya nalyari kan Santiago buy sa kaatag pun mapatêl kan Jesus.” Pamakayari, namita ya buy naku ya sa kaatag lugal. ");
INSERT INTO blx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sên pamakamaranun, naguluy mani magbantay sa sukulan, gawan ayin na si Pedro buy a la tanda nu sabêt ta nalyari kana. ");
INSERT INTO blx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Namiutus si Herodes amên têkapên ya. Sên a laya makitan, inlitis nay mani magbantay buy impapati. Pamakayari, namita si Herodes sa prubinsyan Judea. Naku ya sa balayan Cesarea buy nanugêl ya baydu. ");
INSERT INTO blx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nasuluksuluk si Arin Herodes sa mani taga Tiro buy sa mani taga Sidon. Kabay gawan maubat sa pansakupun Arin Herodes ya pangkanên mani taga Tiro buy mani taga Sidon, nakikaluguran sila pun kan Blasto ya pagtiwalan ari sa palasyu. Ta labay lan pasawup kan Blasto amên makikasundu kan Arin Herodes. ");
INSERT INTO blx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sên inlumatêng ngay allun pamikiarap Arin Herodes sa mani taga Tiro buy sa mani taga Sidon, nagyaming yan yaming ari buy niknu ya sa turonu na buy nagsabi ya sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Masnêg sinabin mani tawuy, “Ya nalêngê tamu, tunuy gisay namalyari, alwan tawu!” ");
INSERT INTO blx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sa uras êt abitu, pinarusan ang-el Panginuun si Arin Herodes, gawan tinanggap nay pamarangal ya kay sêpat kan Bapan Namalyari. Kabay inêwêl ya angga sa ingkamati na. ");
INSERT INTO blx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nuwa kapamiwagaw-wagaw Sabin Bapan Namalyari buy kapanlulumakên manampalataya. ");
INSERT INTO blx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sên naiatêl lan Bernabe buy si Saulo ya mani sawup sa mani mapatêl sa balayan Jerusalem, nag-udung sila sa balayan Antioquia. Pikilaku la êt si Juan na pambêgên Marcos. ");
INSERT INTO blx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Baydu sa mani manampalatayay miaawyun na idi sa balayan Antioquia, dilag mani propeta buy mani manuru ya sabay silan Bernabe, Simeon na pambêgên Negru, Lucio ya taga Cirene, si Manaen ya kaagnan nan dinumagul sa pamilyan Gobernador Herodes Antipas, buy si Saulo. ");
INSERT INTO blx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Gisay allu, kaban mag-ayunu sila buy mangulimên sa Panginuun, sinabin Ispiritun Bapan Namalyari kallay paradi, “Italaga yu kangku silan Bernabe buy si Saulo, ta dilag gakun ipadyag kalla.” ");
INSERT INTO blx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pamakayari lan nag-ayunu buy nanalangin, impaluntu lay gamêt la kan Bernabe buy kan Saulo bayu silayna pinabita. ");
INSERT INTO blx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kabay gawan sa utus Ispiritun Bapan Namalyari, naku silan Bernabe buy si Saulo sa balayan Seleucia. Paubat baydu nagsakay silan barku papakun sa Cyprus. ");
INSERT INTO blx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pamakalatêng la baydu sa balayan Salamis, nangaral silan Sabin Bapan Namalyari sa mani balin pagtipunan mani Judio. Kaawyun la êt si Juan na pambêgên Marcos buy manawup ya sa mani pandaygên la. ");
INSERT INTO blx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Dinurutan lay buun islan Cyprus angga sa niras sila sa balayan Pafos. Dilag silan nakitan bayduy gisay Judioy manalamangka ya kay magtatalingkayun propetan Bapan Namalyari. Ya lagyu na, Bar-Jesus. ");
INSERT INTO blx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kaawyun yan Gobernador sa islan Cyprus ya si Sergio Paulo ya katanda. Impabêg Gobernador silan Bernabe buy si Saulo gawan kalabay yan mallêngên Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nuwa binênbênan silan Elimas ya manalamangka. Elimas ya lagyun Bar-Jesus sa sabin Griego. Dinyag nay abitu gawan a na labay manampalatayay Gobernador kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nuwa si Saulo ya pambêgên êt Pablo, natupus yan Ispiritun Bapan Namalyari. Pinakaêlêw na si Elimas buy sinabi na kana, ");
INSERT INTO blx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Elimas, anak kan Satanas buy kapati kan kaganawan mangêd! Pawan kalaraman buy kadawakan na pandaygên mu. Pawa mu tanan pan-itukawkaw wa kapêtêgan ya ubat kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Amêsên, parusan kan Bapan Namalyari. Mabulag ka buy a mu makitan na sawang sa dakun umnuy allu.” Tambêng dinumiglêm ma pangêlêw Elimas buy nabulag ya. Kabay nagdalikapkapan yatan mangkap tawuy mangakay kana. ");
INSERT INTO blx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Sên nakitan Gobernador ya nalyari kan Elimas, nanampalataya ya gawan nakaupapas ya sa mani pan-iaral tungkul sa Panginuun. ");
INSERT INTO blx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Namita silan Pablo sa balayan Pafos buy nagsakay silan barku papakun sa balayan Perga sa prubinsyan Pamfilia. Pamakalatêng la baydu, inlakwanan silan Juan na pambêgên Marcos, ta nag-udung ya sa balayan Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Namita si Pablo buy si Bernabe sa balayan Perga buy naku sa balayan Antioquia sa prubinsyan Pisidia. Pallumatêng Allun Pagpaynawa, sinumun sila sa balin pagtipunan mani Judio buy niknu sila. ");
INSERT INTO blx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Dilag namasan ubat sa Kautusan na impasulat kan Moises buy sa insulat mani propeta. Pamakayari, namiutus ya mamunu sa balin pagtipunan mani Judio ya sabin nay ati kallan Pablo, “Mani mapatêl, nu dilag kaw sabin na mamakapas-êy nakêm sa mani tawu, sabin yina.” ");
INSERT INTO blx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kabay nidêng si Pablo buy siningyalan nay mani tawun mallêngê kana. Sinabi na, “Sikaw wa mani kaparisu kun Israelita buy sikaw wa alwan Israelitay dilag limu kan Bapan Namalyari, mallêngê kaw kangku! ");
INSERT INTO blx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ya Bapan Namalyarin mani Israelita sabay ya namilin mani ninunu tamu. Sabitun idi sila pun sa Egipto, pinalakê na sila. Buy sa kapamilatan kapangyarian Bapan Namalyari, intas na sila sa Egipto. ");
INSERT INTO blx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sa lalên apattapuy tawun, pinibabatan na sila baydu sa kakyangan. ");
INSERT INTO blx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Sên sinambut Bapan Namalyari ya pituy layi ya idi sa Canaan, indin nay abiin na luta sa mani ninunu tamu. ");
INSERT INTO blx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nalyari ya kaganawan abiin sa lalên apat ta ralan buy limampuy tawun.” “Pamakayari, binyanan na silan mani tawuy mamunu kalla angga sa panawun Propeta Samuel. ");
INSERT INTO blx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nanyawad silan ari buy pinilin Bapan Namalyari ya gisay liyaki. Ya lagyu na, Saul ya anak Kis ya naubat sa layin Benjamin ya sabay ya magin ari la. Nag-ari si Saul sa lalên apattapuy tawun. ");
INSERT INTO blx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sên intas Bapan Namalyari si Saul, pinili na si David da magin ari. Ati ya sinabin Bapan Namalyari tungkul kan David, ‘Kapapaidu kangku si David ya anak Jesse. Nakal-an yan manunul sa kaganawan iutus ku kana.’ ” ");
INSERT INTO blx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Sinabi pun êt Pablo sa mani tawu, “Ubat sa layin David si Jesus ya Mamiligtas ya impangakun Bapan Namalyari kantamun mani Israelita. ");
INSERT INTO blx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Bayu pun mag-umpisa si Jesus sa pandaygên na, nangaral la si Juan sa kaganawan Israelita ya sêpat lan pagsisyan na mani kasalanan la buy magpabawtismu sila. ");
INSERT INTO blx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Buy sên marani yan mayarin Juan na pan-ipadyag Bapan Namalyari kana, sinabi na sa mani tawu, ‘Indap yu nayi nu sikuy Cristuy impangakun Bapan Namalyari ya pan-êtêngên yu? Alwan siku, nun a dilag lumatêng nga makapangyarian pun kangku. A ku sêpat magin ipus na.’ ” ");
INSERT INTO blx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mani mapatêl la ubat sa layin Abraham buy mani alwan Judioy dilag limu kan Bapan Namalyari, sikitamuy pinipatandan Bapan Namalyari un Mangêd da Balita nu parasaantu kitamun miligtas sa kaparusan na ayin katganan. ");
INSERT INTO blx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ya mani Judioy manugêl sa balayan Jerusalem buy ya mani pinunu la, a la kinilala si Jesus bilang Mamiligtas. Buy a la napukatan na insulat mani propeta, agyan malêngê lay nay pambasên sa balang Allun Pagpaynawa. Kabay sên inatulan lan kamatyan si Jesus, sabay silaynay nanupad abituy insulat mani propeta ya pan-ibasa kalla. ");
INSERT INTO blx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Agyan ayin silan sêpat ta sangkan amên patin ya, inyawad la pun êt kan Pilatoy ipapati si Jesus. ");
INSERT INTO blx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sên nadyag lay nay kaganawan nakasulat ta malyari kan Jesus, intabuy laya sa kurus buy in-ilbêng. ");
INSERT INTO blx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nuwa pinabyay yan Bapan Namalyari ubat sa nangamamati. ");
INSERT INTO blx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Buy sa dakun umnuy allu, katiumnu yan nagpakit sa mani tawuy nakilaku kana sên namita ya sa prubinsyan Galilea papakun sa balayan Jerusalem. Angga amêsên, ya mani tawun abitu, sabay silay magpapêtêg sa mani Israelita tungkul kan Jesus.” ");
INSERT INTO blx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Kabay idi kay êt baydi amên ipatanda kamuyuy Mangêd da Balitay impangakun Bapan Namalyari sa mani ninunu tamu. ");
INSERT INTO blx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tinupad na kantamun kaapuapuan lay abitu, ta pinabyay na si Jesus. Ati ya nakasulat sa ikalwan Kanta, ‘Sikay Anak ku, buy amêsên, ipatanda kuy sikuy Bapa mu.’ ” ");
INSERT INTO blx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Impangakun Bapan Namalyari ya pabyayên na si Jesus buy asê bumatay lawini na. Sinabi na, ‘Tuparên ku kamuy banal la kangêdan na impangaku ku kan Arin David.’ ” ");
INSERT INTO blx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Buy nakasulat pun êt sa kaatag Kanta, ‘A mu paulayan bumatay bangkay Banal la Lingkud mu.’ ” ");
INSERT INTO blx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Alwan si David da pantukuyun di, gawan sên nayarin David da pan-ipadyag Bapan Namalyari kanay maglingkud sa mani tawu sa panawun na, nati ya buy in-ilbêng ya sa danin mani ninunu na buy binumatay lawini na. ");
INSERT INTO blx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nuwa si Jesus, pinabyay yan Bapan Namalyari buy asê binumatay lawini na. ");
INSERT INTO blx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Kabay sikaw wa mapatêl, sêpat yun matandan na sa kapamilatan dinyag Jesus, pan-ipatanda yan na mapatawad Bapan Namalyari ya mani kasalanan tamu. Ta sisabêt man na manampalataya kan Jesus, pan-ituwad yan Bapan Namalyarin matinêk. Nuwa ayin tawuy pan-ituwad Bapan Namalyarin matinêk sa kapamilatan panunul na sa Kautusan na impasulat kan Moises. ");
INSERT INTO blx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kabay mangillag kaw amên asê malyari kamuyuy pansabin mani propeta ya paradi, ");
INSERT INTO blx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Sikaw wa mani manguyam, lêng-ên yuy ati. Makaupapas kaw sa daygên ku, nuwa mati kaw pun êt! Gawan dilag gakun daygên sa panawun yuy a yu paniwalan agyan dilag pun mamipatanda kamuyu.’ ” ");
INSERT INTO blx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sên pasalwang nga silan Pablo buy si Bernabe sa balin pagtipunan mani Judio, nakisabi ya mani tawu kallan manguman sila pun magsabi tungkul sa mani pan-iaral la sa sumunul la Allun Pagpaynawa. ");
INSERT INTO blx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sên nipagsalwang silayna, malakêy mani Judio buy alwan Judioy napasunul sa paniwalan mani Judio ya nanunul kallan Pablo buy kan Bernabe. In-aral Pablo buy si Bernabe kallay isundu lay panampalataya la sa kangêdan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sên sumunul la Allun Pagpaynawa, ya mani tawu sa balayan, nayin maubus san sumun sa balin pagtipunan mani Judio amên mallêngên Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sên nakitan mani Judioy malakêy tawuy nititipun, nakasêm sila. Sinalangsang la si Pablo buy dinustak laya. ");
INSERT INTO blx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nuwa ayin limun nakitbay silan Pablo buy si Bernabe un paradi, “Sêpat dayi kamuyun mani Judio munan iaral la Sabin Bapan Namalyari. Nuwa gawan a yu tinanggap pa ati, ya labay sabin, inatulan yinay sarili yu ya a kaw sêpat biyan biyay ya ayin katganan. Kabay paubat amêsên, sa alwan Judio kay yana mangaral Mangêd da Balita. ");
INSERT INTO blx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tagawan ati ya utus Panginuun kanyan, ‘Dinyag katan dêkêt sa mani alwan Judio amên sa kapamilatan mu, mibalitay kaligtasan sa buun babun luta.’ ” ");
INSERT INTO blx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sên nalêngên mani alwan Judioy abitu, natula sila buy inulimên lay Sabin Bapan Namalyari. Buy ya kaganawan pinilin Bapan Namalyari ya biyan nan biyay ya ayin katganan, sabay silay nanampalataya kana. ");
INSERT INTO blx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kabay niwagaw wa Sabin Panginuun sa buun lugal abitu. ");
INSERT INTO blx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nuwa intustus mani Judioy mani lawyaki ya mamunu sa balayan buy ya mani babayi ya pikatandan buy mangulimên kan Bapan Namalyari ya kalabanên la silan Pablo. Kabay pinasakit laya bay silan Pablo buy si Bernabe buy impatas sa lugal abitu. ");
INSERT INTO blx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kabay ingkampag Pablo buy si Bernabe ya abuy idi sa bitis la bilang pamipatanda kalla ya nadawak ka dinyag la. Buy nagdaus sila sa balayan Iconio. ");
INSERT INTO blx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ya mani tagasunul Jesus baydu sa Antioquia, sadyay tula la buy natupus silan Ispiritun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nu sabêt ta nalyari sa Antioquia, para êt bayduy nalyari sa Iconio. Naku silan Pablo buy si Bernabe sa balin pagtipunan mani Judio. Buy gawan sa pangaral la baydu, malakêy Judio buy Griegoy nanampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nuwa dilag êt mani Judioy asê manampalataya kan Jesus ya namitustus sa mani alwan Judio amên manubag sila sa mani manampalataya. ");
INSERT INTO blx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nabuyutan lan Pablo buy si Bernabe sa Iconio. Ayin silan limun magsabi tungkul sa Panginuun. Buy pinagpapêtgan Panginuun na pêtêg ga pan-iaral la tungkul sa kangêdan na, gawan binyanan na silan kapangyarian manyag imala buy mamakaupapas. ");
INSERT INTO blx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kabay nisyay ya mani tawu sa balayan abitu. Ya kaatag, nakiawyun sa mani Judio buy ya kaatag, nakiawyun kan Pablo buy kan Bernabe. ");
INSERT INTO blx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dilag dakun umnuy mani Judio buy mani alwan Judioy kaawyun na mani mamunu kalla ya namalanun mamasakit buy mamatu kan Pablo buy kan Bernabe. ");
INSERT INTO blx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Sên natandan Pablo buy si Bernabe ya palanu la, tambêng silan namita papakun sa balayan Listra buy sa balayan Derbe ya sakup sa prubinsyan Licaonia buy sa kaatag pun lugal la nakapalitêng. ");
INSERT INTO blx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Baydu la in-aral la Mangêd da Balita tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Sa balayan Listra, dilag gisay nakaiknuy liyaki ya a makabita ta lumpu ya ubat sa in-anak ya. ");
INSERT INTO blx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nallêngê ya sa mani pangaral Pablo. Pinakaêlêw Pabloy lumpu buy natandan nay dilag yan panampalatayay umiyul ya. ");
INSERT INTO blx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kabay masnêg sinabin Pablo, “Midêng ka!” Tambêng nidêng nga liyaki buy nibitabita. ");
INSERT INTO blx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sên nakitan mani tawuy dinyag Pablo, masnêg lan sinabi sa sabin Licaoniay, “Ya mani diyus, nagtabuy baydi kantamu ya nagwangis tawu!” ");
INSERT INTO blx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Si Bernabe, binêg layan Zeus, ya gisay diyus la. Buy si Pablo êt taman, binêg layan Hermes ya gisa pun êt ta diyus la, gawan siyay tagapagsabi kaparisun Hermes. ");
INSERT INTO blx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Idi sa lawasan balayan Listra ya narani sa pasbul balayan ya pagsimban la kan Zeus. Kabay ya dinyag pari la, nantan bakay nag-unun bulaklak baydu sa pasbul balayan. Ta labay na buy mani tawuy iandug lay ati kan Bernabe buy kan Pablo, ta pan-isipin lay sabay silay pêtêg diyus la. ");
INSERT INTO blx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nuwa sên natandan lan Bernabe buy si Pabloy abitu, gininit lay yaming la bilang patanday taganan a la labay ya abitu. Buy nuwayu sila sa bunak mani tawuy masnêg magsabin, ");
INSERT INTO blx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mani kaluguran, uysiyan mag-andug kaw ya kanyan ta? Pakan kay kaparisu yukay yan tawu. Pan-iaral yan kamuyuy Mangêd da Balita amên itgên yinay pangulimên yu sa mani diyusdiyusan ya ayin kapukatan buy magdani kaw kan Bapan Namalyari ya nabyay. Sabay siyay nanyag langit, luta, dagat, buy siyay nanyag kaganawan idi baydi. ");
INSERT INTO blx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Sabitun nuna, pinaulayan tan Bapan Namalyari ya kaganawan layi ya manunul sa sarili lan kalabayan. ");
INSERT INTO blx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Paraman baydu, pawan pan-ipakit Bapan Namalyari ya pangaNamalyari na sa mani tawu sa kapamilatan mangangêd da diyag na. Pambiyan nakaw uran buy malakêy pupul sa ustuy panawun amên mabsuy kaw buy sumiglay bêkê yu.” ");
INSERT INTO blx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nuwa agyan parabayduy pansabin Pablo buy si Bernabe, nagkasakit sila pun êt sa pamênbên sa mani tawuy agana sila biyan mani andug. ");
INSERT INTO blx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nuwa siyan dilag gaman mani Judioy inlumatêng ubat sa balayan Antioquia buy Iconio. Sinagyat lay mani tawu un makiawyun kalla. Kabay binatwan la si Pablo buy ginuluy layan pasalwang sa balayan, ta indap la nu nati yina. ");
INSERT INTO blx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nuwa sên napalitêngan yan mani tagasunul Jesus, nidêng ya buy nag-udung sa balayan. Kinawasakan, naku ya sa balayan Derbe kaawyun si Bernabe. ");
INSERT INTO blx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Sên nilatêng nga silan Pablo buy si Bernabe sa balayan Derbe, in-aral la bayduy Mangêd da Balita buy malakêy naisagyat lan nagin tagasunul Jesu Cristu. Pamakayari, nag-udung silayna êt sa Listra, Iconio, buy sa Antioquia. ");
INSERT INTO blx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pinapas-êy lay nakêm mani tagasunul Jesus buy insabi ya isundu lay panampalataya la. Sinabi la pun, “Malakêy kasakitan na sêpat tamun danasên bayu kitamu miawyun sa pag-arin Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Namili si Pablo buy si Bernabe un mani mamunu sa balang pustun mani manampalatayay miaawyun. Nag-ayunu sila buy nanalangin para sa mani napili buy intiwala lay mani ati sa Panginuun na panampalatayanan la. ");
INSERT INTO blx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pamakayarin abitu, dinuman silan Pablo buy si Bernabe sa prubinsyan Pisidia buy nilatêng sila sa prubinsyan Pamfilia. ");
INSERT INTO blx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nangaral sila baydu sa balayan Perga. Pamakayari, inlumunsan sila sa balayan Atalia. ");
INSERT INTO blx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ubat ta baydu, nagsakay silan barku paudung sa Antioquia sa prubinsyan Syria. Sabitun nuna sa lugal la abiin, nanalangin na mani manampalataya para kalla ya pagpalên Bapan Namalyari ya mani pandaygên la buy amêsên, nayari lay nay abiin. ");
INSERT INTO blx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sên inlumatêng sila sa Antioquia, tinipun lay mani manampalatayay miaawyun buy ingkuwentu la kallay kaganawan dinyag Bapan Namalyari sa kapamilatan la buy nu parasaantun binyanan Bapan Namalyarin panawun na mani alwan Judio ya malyari sila êt manampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Buy nabuyutan la sa Antioquia kaawyun na mani tagasunul Jesus baydu. ");
INSERT INTO blx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Dilag dakun umnuy tawuy inlumatêng ubat sa prubinsyan Judea ya naku sa Antioquia buy nangaral sa mapatêl la manampalataya baydu un paradi, “Nu a kaw magpatuli ayun sa naugalyan na inturun Moises, a kaw miligtas sa parusay ayin katganan.” ");
INSERT INTO blx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Gawan sa sinabi la, naumut ta pamikisubakan lan Pablo buy si Bernabe kalla. Kabay nibêbêtêk ka mani manampalataya baydu ya ipalaku sa Jerusalem silan Pablo buy si Bernabe buy ya kaatag pun na mani manampalataya sa Antioquia. Ta baydu sila misasabi sa mani apostul buy sa mani mamunu sa mani manampalatayay miaawyun. ");
INSERT INTO blx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kabay impalakun mani mapatêl la manampalatayay miaawyun silan Pablo sa Jerusalem. Buy kaban manduman sila sa prubinsyan Fenicia buy sa prubinsyan Samaria, pan-ibalita la sa mani mapatêl la manampalatayay malakêy nay alwan Judioy manampalataya kan Jesus. Sên nalêngê lay ati, sadyay tula la. ");
INSERT INTO blx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pamakalatêng lan Pablo sa Jerusalem, tinanggap silan mapatêl la manampalataya, mani apostul, buy mani mamunu sa manampalatayay miaawyun. Imbalitan Pablo buy si Bernabe ya kaganawan dinyag Bapan Namalyari sa kapamilatan la. ");
INSERT INTO blx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nuwa nidêng nga dakun umnuy manampalatayay membrun grupun mani Pariseo buy nagsabi, “Kaylangan tulin na alwan mani Judio buy iutus kallay sunulun lay Kautusan na impasulat kan Moises.” ");
INSERT INTO blx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kabay nipupulung nga mani apostul buy mani mamunu sa manampalataya amên pisasabyan lay abiin. ");
INSERT INTO blx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pamakayarin makarang nga pamisusubakan, nidêng si Pedro buy nagsabi, “Mapatêl lay, tanda yuy pinili yakun Bapan Namalyari ubat kamuyu sabitun nuna amên ipatanda kuy Mangêd da Balita sa mani alwan Judio amên makalêngê sila buy manampalataya. ");
INSERT INTO blx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Si Bapan Namalyari ya magtandan laman bêkên balang tawu, impapêtêg na kantamuy pantanggapên nay mani alwan Judio ya manampalataya kan Jesus, gawan indin na êt kallay Ispiritu na kaparisun dinyag na kantamu sabitun nuna. ");
INSERT INTO blx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sa pangêlêw Bapan Namalyari, Judio man o alwan Judio, kay pariparisu, gawan inlinis na êt ta bêkê la sabitun nanampalataya sila kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Amêsên, uysiyan pansubukun yuya si Bapan Namalyari ta? Buy siyan pilitin yu yay mani alwan Judioy tagasunul Jesus ya manunul sa mani kautusan ta? Agyan sikitamu buy mani ninunu tamu, a tamu êt masunul la Kautusan! ");
INSERT INTO blx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Maniwala kitamun miligtas kitamu sa kapamilatan kangêdan Panginuun Jesu Cristu buy para êt baydu sa mani alwan Judio.” ");
INSERT INTO blx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nangimbêk ka kaganawan buy nallêngê sila sa pansabin Bernabe buy si Pablo ya tungkul sa mani imala buy mamakaupapas ya dinyag Bapan Namalyari sa mani alwan Judio sa kapamilatan la. ");
INSERT INTO blx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pamakayari lan nagsabi, sinabin Santiago, “Sikaw wa mapatêl ku, lêng-ên yuku. ");
INSERT INTO blx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ingkuwentun Simon Pedro ya nunan pamêg Bapan Namalyari sa mani alwan Judio. Buy namili si Bapan Namalyari kalla ya magin kana. ");
INSERT INTO blx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nakaayun êt ta abiin sa impasulat Bapan Namalyari sa mani propeta sabitun nuna, gawan sinabi sa Kasulatan, ");
INSERT INTO blx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Mag-udung ngaku lanu, ta ipaydêng kun manguman na kaarian Arin David. Iuman kuyan ipaydêng ubat sa pangalasak na ");
INSERT INTO blx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","amên têkapên nakun kaatag tawu buy mani alwan Judio ya pinili kun kay kangku. Sikuy Panginuun na magsabin abiin. ");
INSERT INTO blx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Buy mana kinan impatanday abiin.’ ” ");
INSERT INTO blx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Sinabi pun êt Santiago, “Kabay nu kay kangku, agana tamina daygên masakit sa mani alwan Judioy magdani kan Bapan Namalyari, ");
INSERT INTO blx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","nun a sulatan tamu silan aganayna mangan kanên na in-andug sa diyusdiyusan, gawan pan-ituwad tamun madinat ta ati. Buy agana sila makikanayun. Buy agana mangan daya o karnin mani ayup pa asê pinadaya. ");
INSERT INTO blx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gawan ubat pun sabitun nuna, tanday nan mani Judioy abiin ya impasulat kan Moises ya pagkaibasa la sa balin pagtipunan la sa balang Allun Pagpaynawa buy pan-iaral la sa balang balayan.” ");
INSERT INTO blx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kabay ya mani apostul buy ya mani mamunu sa manampalatayay miaawyun buy ya kaganawan manampalataya, nikasundu silan mamilin lawyaki ya maubat sa grupu lay iutus sa Antioquia. Sabay silay mapagkaawyun lan Pablo buy si Bernabe. Ya napili la, silan Judas ya pambêgên Barsabas buy si Silas gawan panggalangên silan mani manampalataya. ");
INSERT INTO blx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Buy paradi ya nakasulat sa impagtan kalla, “Mani kakaidwan yan, sikay ya mani apostul buy mani mamunu sa manampalatayay miaawyun na magsulat ati. Nagpapakun kaw nay mapatêl la alwan Judio baysên sa Antioquia, sa Siria buy sa Cilicia. ");
INSERT INTO blx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Natandan yan na dilag mani tawuy ubat di kanyan na naku baysên ya namilitêp sa isip yu sa mani pan-iaral la. Nuwa a yan sila in-utus maku baysên amên manurun parabaydu. ");
INSERT INTO blx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kabay sên nalêngê yan na abiin, napikasunduwan yan na mamili kay mani tawuy iutus yan kamuyun mamisabin mani bagay ya napikasunduwan yan. Kaawyun silan Bernabe buy si Pablo ya pangkaidwan tamun mapatêl. ");
INSERT INTO blx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","In-il-an Pablo buy si Bernabe ya biyay la sa paglingkud la sa Panginuun tamun Jesu Cristu. ");
INSERT INTO blx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","In-utus yan silan Judas buy si Silas baysên kamuyu amên ipapukat lay laman sulat. ");
INSERT INTO blx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Impaisip Ispiritun Bapan Namalyari kanyan na a yan ipatupad kamuyuy mangabayat ta utus, nun a kay ya idi sa sulat ta ati ya kaylangan yun sunulun. ");
INSERT INTO blx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Agana kaw mangan mani kanên na in-andug sa diyusdiyusan. Agana kaw mangan daya buy karnin mani ayup pa asê pinadaya. Buy agana kaw makikanayun. Mangêd da magpakarayu kaw sa mani bagay ya abiin. Kay angga ta baydi.” ");
INSERT INTO blx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kabay amêsên, ya mani tawuy in-utus la papakun sa Antioquia, namitay nabay. Pamakalatêng la baydu, tinipun lay kaganawan manampalataya buy indin kallay sulat. ");
INSERT INTO blx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Sên nabasa lay sulat, sadyay sayan nakêm la. ");
INSERT INTO blx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Si Judas buy si Silas, mani propeta sila êt. Malakêy in-aral la sa mani mapatêl amên papas-êyên na nakêm buy panampalataya la. ");
INSERT INTO blx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nanugêl silan dakun umnuy allu baydu. Bayu sila nuli, nanalangin na mani mapatêl sa Panginuun para kalla amên illagan na pamita la angga sa milatêng sila sa mani namiutus kalla. ");
INSERT INTO blx_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nuwa nagpalakwan baydu si Silas. ");
INSERT INTO blx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Buy nanugêl pun si Pablo buy si Bernabe sa Antioquia. Malakêy kaawyun lan manuru buy mangaral Sabin Panginuun. ");
INSERT INTO blx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Sên inlumibas ya dakun umnuy allu, sinabin Pablo kan Bernabe, “Mag-udung kita sa kaganawan balayan na inaralan tan Sabin Panginuun buy magliwa sa mapatêl amên matandan tamuy kabilyan la.” ");
INSERT INTO blx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Labay Bernabe ya pakilaku na si Juan na pambêgên Marcos. ");
INSERT INTO blx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nuwa asê labay Pablon pakilaku si Marcos, gawan sabitun idi sila sa prubinsyan Pamfilia, inlakwanan silan Marcos sa pandaygên la. ");
INSERT INTO blx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Gawan sa sadyay pamisusubakan la, nisyay sila. Pikilakun Bernabe si Marcos buy nagsakay silan barku papakun sa Cyprus. ");
INSERT INTO blx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pikilakuy naman Pablo si Silas. Bayu sila namita, nanalangin na mani mapatêl para kalla ya sawpan silan Panginuun sa pamita la. ");
INSERT INTO blx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Naku silan Pablo sa prubinsyan Siria buy sa prubinsyan Cilicia buy pinapas-êy lay mani manampalatayay miaawyun baydu. ");
INSERT INTO blx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Insundu lan Pabloy pamita la papakun sa balayan Derbe angga sa balayan Listra. Baydu sa Listra, dilag gisay liyaki ya tagasunul Jesus ya maglagyun Timoteo. Judioy indu na buy manampalataya ya kan Jesus nuwa ya bapa na, Griego. ");
INSERT INTO blx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ya mani mapatêl tamu baydu sa balayan Listra buy sa balayan Iconio, pagpapêtgan lan mangêd da tawu si Timoteo. ");
INSERT INTO blx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Labay Pablo, pakilaku na si Timoteo. Kabay impatuli nay ati amên ayin masabi ya mani Judio laban kana, gawan si kaganawan Judioy manugêl baydu sa lugal abitu, tanda lay Griego ya bapa na. ");
INSERT INTO blx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pamakayari, naku sila sa mani balayan buy pinatandan lay mani manampalatayay sumunul sila sa kautusan na napikasunduwan mani apostul buy mani mamunu sa manampalatayay miaawyun sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kabay pinupumas-êy ya panampalatayan mani manampalatayay miaawyun. Buy sa inallu-allu, kapanlulumakên mani manampalataya. ");
INSERT INTO blx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Asê tinulutan Ispiritun Bapan Namalyari silan Pablo ya mangaral silan Sabin Bapan Namalyari baydu sa prubinsyan Asia. Kabay naku sila sa mani lugal sa prubinsyan Frigia buy sa prubinsyan Galacia. ");
INSERT INTO blx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pamakalatêng la sa katganan prubinsyan Misia, labay la dayin maku sila sa prubinsyan Bitinia, nuwa a sila tinulutan Ispiritun Jesus. ");
INSERT INTO blx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kabay dinuman sila tana sa prubinsyan Misia buy naku sa balayan Troas. ");
INSERT INTO blx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Sa yabin abitu, impasulêplêp Bapan Namalyari kan Pablo ya gisay liyaki ya taga Macedonia ya nakaidêng buy magmakalunus kana. Sinabi na, “Maglipay ka baydi sa Macedonia ta sawpan mukay.” ");
INSERT INTO blx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pamakayarin nasulêplêp Pabloy abiin, tambêng kay nagsakay barku papakun sa prubinsyan Macedonia, gawan napilmi kay ya pan-ipalaku kay baydun Bapan Namalyari amên mangaral Mangêd da Balita sa mani tawu baydu. ");
INSERT INTO blx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Baydu sa Troas, nagsakay kay papakun sa islan Samotracia buy kinawasakan, naglipay kay naku sa balayan Neapolis. ");
INSERT INTO blx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ubat sa Neapolis, namita kay papakun sa balayan Filipos ya sabay ya pinakamaragul la balayan sa prubinsyan Macedonia. Ya mani manugêl baydu, malakê kallay taga Roma. Nanugêl kay baydun dakun umnuy allu. ");
INSERT INTO blx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pamakalatêng Allun Pagpaynawa, nag-awas kay sa balayan buy naku sa danin ilug. Indap yan dilag baydun lugal la pagtipunan mani Judio amên manalangin. Nitagun dilag baydun mani babayi ya nangapititipun. Kabay nakiiknu kay buy nakisabi kalla. ");
INSERT INTO blx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Gisa sa mani mallêngê kanyan, si Lydia ya taga balayan Tiatira. Gisa yan mangalakal mani makamal la telay kulay muradu buy mangulimên ya kan Bapan Namalyari. Kaban mallêngê ya sa pan-iaral Pablo, imbuklat Panginuun na bêkê na amên tanggapên nay mani pansabin Pablo. ");
INSERT INTO blx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nagpabawtismu ya buy ya mani kaawyun na sa bali la. Pamakayari, sinabi na, “Nu maniwala kaw nan gisa kinan pêtêg ga manampalataya kan Jesus, baydu kawna magdaus sa bali ku.” Gawan sa pamilit na kanyan, naisagyat nakay nagdaus sa bali na. ");
INSERT INTO blx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gisay allu, kaban papakun kay sa lugal la pagtipunan amên manalangin, natbêng kay gisay dalagay ipus. Ya dalagan abitu, manuga ya gawan sinêdakan yan nadawak ka ispiritu. Maragul la panakitan mani amung na sa panuga na. ");
INSERT INTO blx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pakilalakwan nakay buy masnêg nan pansabin, “Ya mani tawun ati, lingkud silan Bapan Namalyari ya Katatag-ayan! Pan-iaral la kamuyu nu parasaantu kaw miligtas!” ");
INSERT INTO blx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Allu-allu nan pandaygên na abitu angga sa napasuluk ka si Pablo. Kabay pinag-arapan nay babayi buy sinabi na sa nadawak ka ispirituy idi kana, “Sa lagyun Jesu Cristu, pan-iutus katan mag-awas kana!” Buy tambêng nag-awas ya nadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Sên nakitan amung nay ayin silaynan panakitan, dinakêp la si Pablo buy si Silas buy ginuluy sa palengki amên iarap sa mani manungkulan sa balayan. ");
INSERT INTO blx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Sinabi la sa mani manungkulan, “Ya mani Judion ati, manggulu sila sa balayan tamu. ");
INSERT INTO blx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Pan-iaral lay naugalyan ya labag sa kautusan tamun mani Romano. A tamu malyarin sunulun na mani pan-iaral la.” ");
INSERT INTO blx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nibêbêtêk ka mani tawu sa panduyung kan Pablo buy kan Silas. Impalabus mani manungkulan na yaming la buy impabadug. ");
INSERT INTO blx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sên napakangêd silaynan binadug, impasukul sila buy in-utus la sa magbantay, “Papakabantayan mu sila.” ");
INSERT INTO blx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kabay impasun magbantay ya luwa sa nalalêlalêy sukulan buy impasun na mani bitis la sa pisaêtan luway mangabayat ta kayuy inlubtan. ");
INSERT INTO blx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sên limbanak kan yabi, manalangin silan Pablo buy si Silas buy magkanta silan pangulimên kan Bapan Namalyari. Buy pallêng-ên silan kaatag mani nakasukul baydu. ");
INSERT INTO blx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bêngat tan nallayun malakas. Kabay naêyêg êt ta sukulan. Nibuklat ta kaganawan pasbul sukulan buy nangabubuytuy tanikalan kaganawan nakasukul. ");
INSERT INTO blx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nipaimatay magbantay buy nakitan nay nakabuklat ta kaganawan pasbul. Indap na nu tinumakas say mani nakasukul. Kabay inanus nay kêya na, ta magpakamati yina dayi. ");
INSERT INTO blx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nuwa masnêg sinabin Pabloy, “Agana ka magpakamati! Abiti kay kaganawan!” ");
INSERT INTO blx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nipakwan suluy magbantay buy namaras yan sinumun. Nanduku ya sa arapan lan Pablo buy si Silas un manginagin limu. ");
INSERT INTO blx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pamakayari, sên in-awas sa silan Pablo sa sukulan, pinatang na sila, “Kakay sabêt ta sêpat kun daygên amên miligtas?” ");
INSERT INTO blx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nakitbay sila, “Manampalataya ka sa Panginuun Jesus buy miligtas ka buy mani kaawyun mu sa bali.” ");
INSERT INTO blx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","34","Amêsên, pikilaku na silan Pablo sa bali na, inuyasan nay nuka la buy pinakan. Buy in-aral lan Pabloy Sabin Bapan Namalyari kana buy sa kaganawan kaawyun na sa bali buy nagpabawtismu sila. Masaya-sayay magbantay buy buun pamilya na, ta nanampalataya silayna kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pamakamaranun, ya mani manungkulan sa balayan, namiutus silan mani pulis ya ibus sa silan Pablo. ");
INSERT INTO blx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kabay sinabin magbantay sa sukulan kan Pablo, “Namiutus ya mani manungkulan ya ipabus kawna. Kabay malyari kawnan umawas buy mitan napatêtbêk.” ");
INSERT INTO blx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nuwa sinabin Pablo sa mani pulis, “Inlabag mani manungkulan na kautusan Romano, gawan impabarug lakay sa arapan mani tawu buy impasukul kay ayin pallitis, agyan mani Romano kay. Sên amêsên ni, labay lakay ipabus un ayin magtanda. Asê malyari! Silay naman na manungkulan na maku din mamibus kanyan.” ");
INSERT INTO blx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kabay nag-udung nga mani pulis sa mani manungkulan buy imbalita kallay sinabin Pablo. Sên natandan mani manungkulan ya Romano awêd silan Pablo, nalimu sila. ");
INSERT INTO blx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kabay naku sa sukulan ya mani manungkulan buy nanyawad silan tawad kallan Pablo. Pamakayari, impaawas sila buy pikisabi lay, “Nu malyari dayi, mita kawna sa balayan yan.” ");
INSERT INTO blx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Sên nakaawas sa silan Pablo buy si Silas sa sukulan, naku sila sa balin Lydia. Nalatêng la bayduy mapatêl buy pinas-êy lan Pabloy panampalataya la. Pamakayari, namitay na silan Pablo. ");
INSERT INTO blx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Dinuman silan Pablo sa balayan Amfipolis bayu sa balayan Apolonia angga sa inlumatêng sila sa balayan Tesalonica. Dilag baydun balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Buy ayun sa manan pandaygên Pablo, sinumun ya sa balin pagtipunan mani Judio. Buy sa tatluy Allun Pagpaynawa, nakitutul ya sa mani tawu baydu. Ginamit nay Kasulatan Bapan Namalyari amên ");
INSERT INTO blx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ipaintindi na kallay nakasulat buy ipapêtêg na ya si Cristu kaylangan yan mibabata sa pamasakit buy manguman yan mabyay. Sinabin Pablo, “Si Jesus ya pan-ipatanda ku kamuyu, sabay ya Cristuy impangakun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ya kaatag Judio, nanampalataya buy nakilaku kan Pablo buy kan Silas. Malakê êt ta mani Griego ya mangulimên kan Bapan Namalyari buy malakê êt ta pikatandan na babayi ya nanampalataya buy nakilaku kalla. ");
INSERT INTO blx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nuwa dilag kaatag Judioy nakasêm kan Pablo buy kan Silas. Kabay tinipun lay mani tawuy mapanyag kadawakan ya kay nagtukawan sa palengki. Sên malakêy nay natipun la, nag-umpisa silaynan manggulu sa balayan. Pinilit lan sinumun sa balin Jason gawan sa pangkap la kan Pablo buy kan Silas amên iarap sila sa mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nuwa sên a la makit silan Pablo buy si Silas, dinakêp la si Jason buy ya kaatag pun êt mani manampalataya. Ginuluy lay mani ati papakun sa mani manungkulan sa balayan buy masnêg lan sinabi, “Ya mani tawun ati, mapanyag silan kagulwan agyan antuy lakwên la. Buy amêsên, idi silayna baydi sa balayan tamu. ");
INSERT INTO blx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Impasun Jason sa bali na silan Pablo buy si Silas. Kaganawan lay mangalaban sa kautusan Emperador, gawan pansabin lay dilag pun êt kaatag ari ya maglagyun Jesus.” ");
INSERT INTO blx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sên nalêngên mani tawuy abitu buy mani manungkulan, naguluy isip la. ");
INSERT INTO blx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bayu la imbus si Jason buy ya mapatêl tamu kan Jesus ya kaawyun na, pinabayad sila pun. ");
INSERT INTO blx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pamakayabi, impalakun mani manampalataya silan Pablo buy si Silas sa balayan Berea. Pamakalatêng la baydu, sinumun sila sa balin pagtipunan mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Luyang pun nakabuklat ya isip mani Judio sa Berea kaysa sa mani taga Tesalonica, tagawan labaylabay lan lêng-ên ya pan-iaral lan Pablo buy allu-allu lan pag-aralan ya Kasulatan Bapan Namalyari amên matandan la nu pêtêg ya pansabin lan Pablo. ");
INSERT INTO blx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kabay malakê kallay nanampalataya kan Jesus. Malakê êt ta mani Griegoy babayi ya pikatandan sa balayan buy mani Griegoy lawyaki ya nanampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nuwa sên nalêngên mani Judio sa Tesalonicay mangaral si Pablo un Sabin Bapan Namalyari sa Berea, naku sila êt baydu buy sinagyat lay mani tawu un manggulu. ");
INSERT INTO blx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kabay tambêng in-atêl mani manampalataya si Pablo sa agid dagat. Nuwa si Silas buy si Timoteo, nagpalakwan baydu sa Berea. ");
INSERT INTO blx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Dilag mani tawuy namiatêl kan Pablo angga sa Atenas. Sên mag-udung silayna sa Berea, intipan Pablo kallay tambêng pakamatên kana silan Silas buy si Timoteo. ");
INSERT INTO blx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kaban mangêtêng si Pablo kan Silas buy kan Timoteo sa Atenas, nakitan nay malakêy diyusdiyusan baydu. Nabêgbêg ga nakêm na. ");
INSERT INTO blx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kabay sinumun ya sa balin pagtipunan mani Judio buy nakitutul ya sa mani Judio buy sa mani alwan Judioy mangulimên kan Bapan Namalyari. Allu-allu ya êt mamaku sa pangapalan amên makitutul agyan sisabêt man na malatêng na baydu. ");
INSERT INTO blx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dilag êt luway grupun mani manuruy nakitutul kan Pablo. Ya gisa, pambêgên lan mani Epicureo. Ya gisa, pambêgên lan Estoico. Sinabin dakun umnu kalla, “Sabêt ta pansabin tawun abiin ya magbibiyasa?” Ya sinabin kaatag, “Ya pan-iaral nan abiin, abituy pan-ulimênên mani dayuwan.” Pansabin lay abitu gawan mangaral si Pablo un tungkul kan Jesus buy sa panguman nan pangabyay. ");
INSERT INTO blx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kabay pikilaku la si Pablo sa mani manungkulan ya pambêgên grupun Areopago. Sinabi la kana, “Malyari yan nayin matandan nu sabêt ta bayun aral ya pan-iaral mu? ");
INSERT INTO blx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Babayu yan nalêngêy mani pansabin mu. Kabay labay yan matandan nu sabêt ta labay sabin abiin.” ");
INSERT INTO blx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Sinabi lay abiin gawan ya mani taga Atenas buy mani dayuwan na makitugêl baydu, ayin silan kaatag pandaygên nun a kay misasabi buy mallêngê tungkul sa bayuy aral. ");
INSERT INTO blx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kabay nidêng si Pablo sa arapan mani tawuy pambêgên grupun Areopago buy sinabi na, “Mani taga Atenas! Makit kuy masipêg kaw mangulimên. ");
INSERT INTO blx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tagawan sa paglimbun ku sa balayan yu, nakit kuy mani pan-ulimênên yu. Buy nakit ku êt ta pamiandugan yuy nakasulat ya paradi, ‘Sa namalyari ya a yan kilala,’ Ya pan-ulimênên yuy a yu kilala, sabay ya Bapan Namalyari ya pan-iaral ku kamuyu.” ");
INSERT INTO blx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Ya Bapan Namalyari ya pan-iaral ku kamuyu, sabay ya nanyag babun luta buy kaganawan idi baydi ya sabay ya Panginuun langit buy luta. A ya manugêl sa mani templu ya dinyag mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","A ya mangaylangan sawup ubat sa tawu, gawan sabay siyay nam-i kantamun biyay, inawanên buy kaganawan pangaylanganan tamu. ");
INSERT INTO blx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Dinyag nay kaganawan layi ya ubat sa gisay tawu buy in-ikyat na sa buun babun luta. Intalaga nay katganan bibiyan balang layi baydi sa babun luta buy intalaga na êt ta panawun ya mabyay sila. ");
INSERT INTO blx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dinyag Bapan Namalyari ya kaganawan abiin amên dat sa pangkap tamu kana, makitan tamu ya. Nuwa sa kapêtêgan, asê marayu si Bapan Namalyari sa balang gisa kantamu. ");
INSERT INTO blx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Gawan sa kapamilatan kapangyarian na, nabyay kitamu buy makakimit buy idi kitamu baydi.’ Para êt bayduy sinabin dakun umnuy manyag tula, ‘Anak kitamun Bapan Namalyari.’ ” ");
INSERT INTO blx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Kabay gawan anak kitaminan Bapan Namalyari, agana tamu isipin ya si Bapan Namalyari, kay kaparisu yan ribultuy gintu, pilak, o batu ya pawan kay diyag isip buy kabiyasnan tawu. ");
INSERT INTO blx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Sabitun nuna, sên asê pun kilalan mani tawu si Bapan Namalyari, pinaulayan nay mani pandaygên la. Nuwa amêsên, pan-iutus Bapan Namalyari sa kaganawan tawu sa balang lugal ya magsisi sila buy lakwanan lay mani nadawak ka pandaygên la. ");
INSERT INTO blx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Gawan intakdan Bapan Namalyari ya allu nu makanu na ipatupad ya makatuynungan na pangukum na sa kaganawan tawu baydi sa babun luta sa kapamilatan tawuy pinili nan mangukum. Pinagpapêtgan nay abiin sa kaganawan sabitun pinabyay nan manguman ya tawun abitu.” ");
INSERT INTO blx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sên nalêngê lay sinabin Pablo tungkul sa panguman pangabyay, kinalyan yan dakun umnu. Nuwa sinabin kaatag, “Mag-udung kan manguman baydi, gawan kalabay kay pun mallêngê tungkul baysên.” ");
INSERT INTO blx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pamakayari, inlakwanan silan Pablo sa pagtipunan la. ");
INSERT INTO blx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Dilag dakun umnuy lawyaki ya nanampalataya kan Jesus buy nakilaku kan Pablo. Ya gisa kalla, si Dionisio ya membrun grupun Areopago buy dilag êt babayi ya naglagyun Damaris buy dilag pun êt kaatag ga nakilaku. ");
INSERT INTO blx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pamakayarin abitu, namita si Pablo sa balayan Atenas buy naku ya sa balayan Corinto. ");
INSERT INTO blx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nakilala na bayduy gisay kaparisu nan Judio ya in-anak sa prubinsyan Ponto. Ya lagyu na, Aquila. Kay kapilatêng Aquila sa Corinto ubat sa balayan Roma sa bansan Italia, kaawyun na si Priscila ya asawa na. Nakitugêl sila baydu gawan impatas Arin Claudio ya kaganawan Judio sa balayan Roma. Inlakun Pabloy miasawa sa bali la. ");
INSERT INTO blx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Gawan manyag silan tolda kaparisun Pablo, nakitugêl ya kalla buy awyun lay nan mag-ubra. ");
INSERT INTO blx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Balang Allun Pagpaynawa, mamaku si Pablo sa balin pagtipunan mani Judio amên makitutul kalla buy pansagyatên nan manampalataya kan Cristuy mani Judio buy mani Griego. ");
INSERT INTO blx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sên inlumatêng silan Silas buy si Timoteo ubat sa prubinsyan Macedonia, impamisan Pablo ya panawun na sa pangaral nan Sabin Bapan Namalyari. Pinagpapêtgan na sa mani Judioy si Jesus sabay ya Cristuy impangakun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nuwa sinalangsang la si Pablo buy dinustak laya. Kabay ingkampag Pabloy abuy idi sa yaming na bilang patanda laban kalla. Sinabi na, “Nu parusan kaw Bapan Namalyari, kasalanan yina. Ayin nakinan panagutan kamuyu. Paubat amêsên, mangaral lakina sa mani alwan Judio.” ");
INSERT INTO blx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kabay namita ya baydu buy nakitugêl ya sa balin Ticio Justo ya idi sa danin balin pagtipunan mani Judio. Ya tawun ati, a ya Judio nuwa mangulimên ya kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Si Crispo ya mamunu sa balin pagtipunan mani Judio, nanampalataya ya sa Panginuun Jesus buy mani kaawyun na sa bali. Malakê pun na taga Corinto ya nallêngê kan Pablo ya nanampalataya buy nagpabawtismu. ");
INSERT INTO blx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Gisay yabi, nagpakit ya Panginuun kan Pablo buy nagsabi sa kapamilatan sulêplêp. Sinabi na, “Agana ka malimuy Pablo. Isundu muy pangaral mu buy agana ka tunggên, ");
INSERT INTO blx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ta kaawyun muku. Buy ayin makapasakit kamu tagawan malakêy tagasunul ku sa balayan ati.” ");
INSERT INTO blx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kabay nanugêl si Pablo sa Corinto un gisay tawun buy kapaka. Buy pan-iaral na sa mani tawuy Sabin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nuwa sên si Galio ya gobernador sa Acaya, nibêbêtêk ya mani Judio laban kan Pablo. Dinakêp laya buy gintan kan Galio amên litisin. ");
INSERT INTO blx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Sinabi la, “Ya tawun abiin, pan-isagyat nan mangulimên kan Bapan Namalyari ya mani tawu sa paralan ya labag sa kautusan.” ");
INSERT INTO blx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Sên magsabi ya dayi si Pablo, nunan nagsabi si Galio sa mani Judio. Sinabi na, “Nu tungkul sa pallabag kautusan o mabayat ta kasalanan ya kasuy gintan yu kangku, lêng-ên kataw. ");
INSERT INTO blx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nuwa gawan kay tungkul sa mani sabi, sa mani lagyu, buy sa kautusan yu, sikaw nay pakabaala baysên. A ku kalabay mangatuynungan sa parabaysên na kasu.” ");
INSERT INTO blx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kabay impaawas na sila sa pallitisan. ");
INSERT INTO blx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Si Sostenes, gisa yan mamunu sa balin pagtipunan mani Judio. Dinakêp yan mani Griego buy dinugêdugê laya sa lawasan pallitisan. Nuwa asê dinambin Gobernador Galio ya nalyari. ");
INSERT INTO blx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Nanugêl si Pablo sa Corinto un malakêy allu. Pamakayari, nagpatanda ya sa mani mapatêl buy naku ya sa Cencrea kaawyun nay miasaway silan Aquila buy si Priscila. Nagpaurug ya baydu gawan tinupad nay gisay impangaku na kan Bapan Namalyari. Ubat sa Cencrea, nagsakay silan barku papakun sa prubinsyan Siria. ");
INSERT INTO blx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pamakalatêng la sa Efeso, inlakwanan Pablo ya miasawa ta sinumun ya sa balin pagtipunan mani Judio buy nakitutul ya sa mani Judio baydu. ");
INSERT INTO blx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Pikisabi la kan Pablo ya manugêl yapun baydu kalla un dakun umnuy allu, nuwa asê kalabay si Pablo. ");
INSERT INTO blx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nuwa bayu ya namita, sinabi na kalla, “Nu kalabayan Bapan Namalyari, mag-udung ngaku baydi.” Pamakayari, namita ya sa Efeso un nagsakay sa barku. ");
INSERT INTO blx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sên nilatêng ngina sa balayan Cesarea, naku ya sa balayan Jerusalem ta nangumusta ya sa mani manampalatayay miaawyun. Pamakayari, nagdaus ya sa balayan Antioquia. ");
INSERT INTO blx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A ya naêpêng baydu. Namita ya buy inlaku nay mani lugal la sakup Galacia buy Frigia, ta pinas-êy nay panampalatayan mani tagasunul Jesus baydu. ");
INSERT INTO blx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Inlumatêng sa Efesoy gisay Judioy taga Alejandria. Ya lagyu na, Apolos. Mangêd yan magsabi buy malakêy tanda na sa Kasulatan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Naturwanan ninan aral tungkul sa Panginuun. Buun nakêm yan mangaral buy ustuy pan-ituru na tungkul kan Jesus. Nuwa ya kay tanda na, kay abituy bawtismu ya in-aral Juan. ");
INSERT INTO blx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nagsabi yan ayin limu sa balin pagtipunan mani Judio. Sên nalêngê lan Priscila buy si Aquilay pan-iaral na, insagyat laya sa bali la buy impatanda la kanan mangêd nu parasaantun iligtas Bapan Namalyari ya mani manampalataya sa Panginuun Jesus. ");
INSERT INTO blx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Buy sên nalabayan Apolos ya maku sa prubinsyan Acaya, pinas-êy ya nakêm nan mani manampalatayay idi sa Efeso buy nanulat sila sa mani tagasunul Jesus ya idi sa Acaya ya tanggapên la si Apolos. Pamakalatêng na baydu, maragul la naisawup na sa mani nanampalataya sa kapamilatan kangêdan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Sa pamikitutul na sa mani Judio, sinambut na sila sa kapamilatan Kasulatan Bapan Namalyari. Impapêtêg na kallay sabay si Jesus ya Cristuy impangakun Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kaban idi sa balayan Corinto si Apolos, nagdan naman si Pablo sa lugal la nangatutung-uy angga sa inlumunsan ya sa balayan Efeso. Dilag yan nakitan bayduy mani tagasunul Jesus. ");
INSERT INTO blx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Namatang si Pablo kalla, “Sabitun nanampalataya kaw kan Jesus, natanggap yina nayi ya Ispiritun Bapan Namalyari?” Nakitbay sila, “Asê. Ayin kay pun tanda ya dilag awêd pambêgên Ispiritun Bapan Namalyari.” ");
INSERT INTO blx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Namatang si Pablo kalla, “Sa sabêt kaw binawtismuwan?” Nakitbay sila, “Binawtismuwan kay ayun sa inturun Juan.” ");
INSERT INTO blx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Sinabin Pablo kallay, “Ya pamawtismun Juan, para sa mani tawuy nagsisi sa mani kasalanan la. Sinabi na sa mani tawuy sêpat silan manampalataya sa lumatêng nga kasunul na ya ayin kaatag nun a si Jesus.” ");
INSERT INTO blx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Sên nalêngê lay abiin, nagpabawtismu sila sa lagyun Panginuun Jesus. ");
INSERT INTO blx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Sên impaluntun Pabloy gamêt na kalla, natupus Ispiritun Bapan Namalyari ya balang gisa kalla. Kabay nakapagsabi silan magmikakanayun na sabi ya a la natandan buy dilag silan impatanday mani sabi ya ubat kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ya bilang kaganawan lawyaki ya nagpabawtismu, mapu buy luwa. ");
INSERT INTO blx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Sa tatluy buwan, magkamaku si Pablo sa balin pagtipunan mani Judio. Ayin yan limun makitutul sa mani tawu buy pan-isagyat na silan magpasakup sa pag-arin Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nuwa dilag dakun umnu kallay nakdêy ya ulu. Asê kalabay manampalataya buy nagsabi silan nadawak sa arapan malakêy tawu tungkul kan Jesus. Kabay namita si Pablo sa balin pagtipunan mani Judio, kaawyun na mani tagasunul Jesus. Buy allu-allu yan mamaku sa pag-aralan Tirano amên isunduy pamikitutul. ");
INSERT INTO blx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Sa lalên luway tawun, parabayduy pandaygên na. Kabay ya kaganawan manugêl sa prubinsyan Asia, Judio buy Griego, nalêngê lay tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Malakêy mamakaupapas ya dinyag Bapan Namalyari sa kapamilatan Pablo. ");
INSERT INTO blx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kabay agyan panyu o sabêt man ya paglatup ya ginamit Pablo, panggêtan mani tawu sa mani nipagsakit. Sa pakapakun baydu, nitas ya sakit buy nangadadawak ka ispiritu. ");
INSERT INTO blx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Dilag dakun umnuy Judio bayduy mibitabita buy mamipatas nadawak ka ispiritu sa mani tawuy sinêdakan. Sinubukan lan gamitin ya lagyun Panginuun Jesus amên ipatas ya nadawak ka ispiritu. Sinabi la sa nangadadawak ka ispiritu, “Sa lagyun Jesus ya pan-iaral Pablo, pan-iutus yan ya magtas kaw.” ");
INSERT INTO blx_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Parabayduy pandaygên pituy lawyaki ya anak Esceva ya gisa sa mani mamunun parin mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Sên sinubukan lan impatas ya nadawak ka ispiritu sa lagyun Jesus, nakitbay ya nadawak ka ispiritu, “Kilala ku si Jesus buy kilala ku êt si Pablo, nuwa sisabêt kaw naman?” ");
INSERT INTO blx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Buy inukduwan silan tawuy sinêdakan nadawak ka ispiritu, sinambut buy pinasakitan silan kaganawan. Ayin silan nadyag. Kabay nuwayu silan pasalwang sa bali un nikalalabus buy nikasusugat. ");
INSERT INTO blx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ya nalyari sa pituy anak Esceva, nabalitan kaganawan mani Judio buy Griego ya manugêl baydu sa Efeso. Nalimu sila buy inulimên ya lagyun Panginuun Jesus. ");
INSERT INTO blx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Malakê sa mani manampalatayay nagdani buy napaawu sa nadawak ka dinyag la. ");
INSERT INTO blx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Malakê êt ta mani magkukulam ya nanipun libru la ya panggamitin la sa pangulam bayu la sinlêb sa makitan kaganawan. Ya alagan mani libruy sinlêb la, niras limampuy libun pilak. ");
INSERT INTO blx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Sa pakapakun baydu, nakit mani tawuy dilag kapangyarian na Sabin Bapan Namalyari. Kabay kapamiwagaw-wagaw Sabi na buy inlumakêy manampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pamakayarin abituy mani nalyari, naisip Pablon duman pun sa prubinsyan Macedonia buy Acaya bayu maku sa Jerusalem. Sinabi na pun êt, “Pamakaubat ku sa Jerusalem, kaylangan kun lakwên ya Roma.” ");
INSERT INTO blx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Impauna na sa Macedonia silan Timoteo buy si Erasto ya luway manawup kana. Buy nagpalakwan pun si Pablo sa prubinsyan Asia. ");
INSERT INTO blx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sa panawun na abitu, dilag maragul la gulu sa Efeso, gawan ya kaatag mani tawu baydu, a la labay ya pan-iaral tungkul kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nag-umpisay abiin ya gulu sa gisay tawuy naglagyun Demetrio ya mamanday. Manyag yan nangabêlêng nga templuy diyag sa pilak ya imparisu sa templun Artemis ya diyusa la. Panakitan nan maragul la abiin kaawyun na mani mag-ubra na. ");
INSERT INTO blx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kabay impabêg nay kaganawan mag-ubra na buy ya kaatag pun na mani tawuy para êt bayduy kabyayan. Sinabi na, “Mani kaluguran, tanda yuy gawan sa ubra tamun abiin, mangêd da kabyayan tamu. ");
INSERT INTO blx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nakitan yu buy nalêngêy dinyag Pablo. Pansabin nay ya ribultuy dinyag tawu, alwan pêtêg namalyari. Malakêy naniwala kana, alwan kay baydi sa Efeso nun a sa buun prubinsyan Asia. ");
INSERT INTO blx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kabay mipakadawak ya kabyayan tamu, gawan dat dawakên mani tawu. Buy alwan kay abiin, mipakadawak êt ta templun diyusa tamun si Artemis. Dat matasan ninan pukat buy asina kilalanên mani tawuy diyusay pansambên tamu, alwan kay baydi sa prubinsyan Asia nun a sa buun babun luta.” ");
INSERT INTO blx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Sên nalêngên mani tawuy abiin, sadyay tubag la buy masnêg lan sinabi, “Makapangyarian si Artemis ya diyusan mani taga Efeso!” ");
INSERT INTO blx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kabay niwagaw wa kagulwan sa buun balayan. Dinakêp lay mani kaawyun Pablo ya silan Gaius buy si Aristarco ya mani taga Macedonia. Pamakayari, kaban pangguluyun lay luwa, niaawyun silan nuwayu sa lugal la pagtipunan mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Labay dayin Pablon makiarap sa mani tawu, nuwa binênbênan yan mani tagasunul Jesus. ");
INSERT INTO blx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Agyan ya kaatag sa mani kaluguran Pabloy manungkulan sa prubinsyan Asia, namiutus silan magsabi kanan agana ya maku sa pagtipunan mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Luyang pun naguluy mani tawu, ta asê pariparisuy pansabin la gawan asê tandan malakê kalla nu sabêt ta sangkan pititipunan la. ");
INSERT INTO blx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Indap kaatag si Alejandro ya nanyag nadawak ta sabay siyay intulak mani Judio sa arapan. Siningyalan nay mani tawuy mangimbêk. ");
INSERT INTO blx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nuwa sên natandan mani tawuy Judio awêd si Alejandro, niaagnan silan masnêg magsabin, “Makapangyarian si Artemis ya diyusan mani taga Efeso!” Luway uras lan pansabin ya parabaydu. ");
INSERT INTO blx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nuwa pamakayarin napatgên gisay mamunu ya mani tawuy idi sa balayan, sinabi na kalla, “Mani kabalayan kun taga Efeso, tandan kaganawan tawuy sikitamuy mani taga Efeso ya sabay ya mamantay sa templun marangal la Artemis ya makapangyarian buy sa sagraduy batuy kalupa na ya nanabun ubat sa langit. ");
INSERT INTO blx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Asê mailimêd da abiin agyan kan dakun sisabêt man. Kabay magpatêtbêk kaw! Agana kaw patutulsub. ");
INSERT INTO blx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gintan yu baydi ya mani tawun ati, agyan ayin silay naman tinakaw sa templu tamu o pinustak ya diyusa tamu. ");
INSERT INTO blx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nu dilag deklamu si Demetrio buy mani kaawyun nan mamanday laban kan dakun sisabêt man, dilag kitamun mani mangatuynungan buy mani manungkulan. Sêpat silan magdeklamu baydu. ");
INSERT INTO blx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nuwa nu dilag kaw pun kaatag deklamu, kaylangan pakapalanên na abiin sa pamititipun manungkulan sa balayan. ");
INSERT INTO blx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nadawak ka malyari kantamu nu dilag magdeklamu sa gubernun Roma tungkul sa gulun ati. Ayin kitamun mangêd da sangkan ya ipakitbay nu siyan pandaygên tamuy ati.” ");
INSERT INTO blx_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Pamakayari nan nagsabi, pinauli nay mani tawuy nititipun. ");
INSERT INTO blx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Sên nayari yay gulu sa balayan Efeso, impabêg Pabloy mani tagasunul Jesus, ta pinas-êy nay nakêm la. Pamakayari, nagpatanda ya kalla ta naku ya sa prubinsyan Macedonia. ");
INSERT INTO blx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Malakêy lugal ya inlaku na sa Macedonia. Pinas-êy nay nakêm mani manampalataya sa kapamilatan pangaral na kalla. Pamakayari, naku ya sa Grecia ");
INSERT INTO blx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","buy nanugêl ya baydun tatluy buwan. Sên magsakay yina dayi sa barku papakun sa Siria, natandan nay palanun mani Judioy patin ya. Kabay sa pag-udung na, inisip nay duman ya tana sa prubinsyan Macedonia. ");
INSERT INTO blx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nakilaku kan Pablo si Sopater ya taga Berea ya anak Pirro, silan Aristarco buy si Segundo ya mani taga Tesalonica, si Gaius ya taga Derbe, si Timoteo, buy silan Tiquico buy si Trofimo ya taga prubinsyan Asia. ");
INSERT INTO blx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pamakalatêng yan sa Filipos, nuna sila kanyan sa Troas buy inêtêng lakay baydu. ");
INSERT INTO blx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pamakayarin Pestan Tinapay ya ayin Pamalbag, nagsakay kay barku ubat sa Filipos papakun Troas. Pamakayarin limay allu, napikakit kay manguman sa Troas. Nanugêl kay baydun pituy allu. ");
INSERT INTO blx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sa nunan allu sa gisay duminggu, niaawyun kay amên mangan tinapay bilang pangganaka sa pangamatin Jesus. Buy gawan mita si Pablo kinawasakan, nangaral ya anggan limbanak yabi. ");
INSERT INTO blx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Malakêy sulu baydu sa kuwartuy pagtipunan yan ya idi sa têngêl. ");
INSERT INTO blx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Dilag baydun gisay bayuntawuy naglagyun Eutico ya nakaiknu sa awang. Buy gawan sa karang pagsabin Pablo, nabêlêwan na. Kabay nanabu ya ubat sa ikatluy palapag bali. Sên insapat laya, nati yina. ");
INSERT INTO blx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nuwa nagtabuy si Pablo buy nagpalukub ya sa babun Eutico buy tinakês naya. Sinabi na sa mani tawu, “Agana kaw napitik, ta nabyay ya.” ");
INSERT INTO blx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nag-udung si Pablo sa têngêl buy binis-ilbis-il nay tinapay buy kinnan la. Pamakayari, nangaral yapun angga sa bunatbunat bayu ya namita. ");
INSERT INTO blx_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","In-uli la si Eutico ya nabyay buy sadyay saya la. ");
INSERT INTO blx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Amêsên, nagsakay kay sa barku papakun sa Ason. Baydu yan pakikitan si Pablo amên isakay, gawan sinabi nay kay mita yan papakun baydu. ");
INSERT INTO blx_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Sên napikakit kay sa Ason, nagsakay ya sa barkuy pinagsakayan yan buy niaawyun kay naku sa Mitilene. ");
INSERT INTO blx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ubat sa Mitilene, insundu yan na pamita yan buy kinawasakan nilatêng kay sa êtêb islan Quio. Sên sumunul la allu, dinuman kay sa Samos. Nilabas pun na gisay allu, inlumatêng kay sa Mileto. ");
INSERT INTO blx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","A kay dinuman sa Efeso, gawan asê labay Pablon maabalay panawun na sa prubinsyan Asia. Labay nay idi yina sa Jerusalem bayu miras sa Allun Pentecostes. ");
INSERT INTO blx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kaban idi sa Mileto si Pablo, dilag yan impalaku sa Efeso amên sabin sa mani mamunu sa mani manampalatayay miaawyun na makikit kan Pablo sa balayan Mileto. ");
INSERT INTO blx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pamakalatêng la, sinabin Pablo kallay, “Tanda yu nu parasaantuy pamibiyaybiyay ku sabitun kaawyun yuku pun, ubat ta sa inlumatêng ngaku baydi sa prubinsyan Asia. ");
INSERT INTO blx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Naglingkud daku sa Panginuun un dilag nayêpay nakêm buy mantuluy luwa ku. Malakêy panubuk ka dinanasan ku gawan labay mani Judion patin laku. ");
INSERT INTO blx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tanda yu êt ta a ku nagmikakunun nangaral agyan sabêt man na makasawup kamuyu. Ta nanuru waku kamuyu sa arapan malakêy tawu buy sa binalibali. ");
INSERT INTO blx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","In-aral ku êt sa mani Judio buy sa mani Griego ya kaylangan lan magsisi sa mani kasalanan la, mag-udung kan Bapan Namalyari buy manampalataya sila sa Panginuun tamun Jesus.” ");
INSERT INTO blx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Amêsên, maku waku sa Jerusalem gawan ati ya in-utus kangkun Ispiritun Bapan Namalyari. A ku tanda nu sabêt ta malyari kangku baydu. ");
INSERT INTO blx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kay tanda kinaman, agyan saantu pun na balayan na lakwên ku, pan-ipatanda kangkun Ispiritun Bapan Namalyari ya masukul laku buy magkasakit. ");
INSERT INTO blx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nuwa asê maulaga kangkuy biyay ku. Ya maulaga kangku, mayari kuy pan-ipadyag kangkun Panginuun Jesus ya sabay ya pamipatandan Mangêd da Balita tungkul sa kangêdan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Sabitun nuna, sên impatanda ku kamuyuy tungkul sa pag-arin Bapan Namalyari, nakiawyun naku kamuyu. Nuwa amêsên, tanda kuy a kitamina mapikakit manguman. ");
INSERT INTO blx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kabay pansabin ku kamuyu amêsên ya nu dilag kamuyuy asê miligtas sa ayin katganan na kaparusan, ayin nakinan panagutan kana.” ");
INSERT INTO blx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tagawan a ku nagluway nakêm ma nangaral kamuyun buun kalabayan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Illagan yuy sarili yu buy ya kaganawan manampalataya, ta sikaw wa pinilin Ispiritun Bapan Namalyari ya mamunu kalla. Mamunu kaw sa mani manampalatayay miaawyun ya inatbus Bapan Namalyari sa kapamilatan dayan Anak na. ");
INSERT INTO blx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Tanda kuy sa pagtas ku baydi, dilag mani lumatêng baysên na mangaral alwan pêtêg. Nanuwad silan asun aniwid ta labay lan sirên na pamiaawyun yu. ");
INSERT INTO blx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dilag êt maubat kamuyuy tawuy mangaral kalaraman amên maisagyat lan manunul kallay mani tagasunul Jesus. ");
INSERT INTO blx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kabay mangillag kaw. Ganakên yuy sa lalên tatluy tawun, allu buy yabi kun pan-ipaganaka kamuyu un dilag panangis. ");
INSERT INTO blx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Buy amêsên, pan-itiwala kataw kan Bapan Namalyari buy sa Sabi na tungkul sa kangêdan na ya sabay ya makapapas-êy sa panampalataya yu buy abiin na makab-i kamuyun pamana ya in-il-an Bapan Namalyari para sa kaganawan tawuy pinili nan kay kana. ");
INSERT INTO blx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","A ku inangad da mani pibandiyan yu o mani yaming dakun sisabêt man. ");
INSERT INTO blx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Tanda yuy nag-ubra ku amên dilag gakun pangwanan kaylangan ku buy mani kaawyun ku. ");
INSERT INTO blx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Sa pag-ubra ku, impakit ku kamuyuy alimbawan pagsipêg. Ta nu tubsun yuy ati, makasawup kitamu sa mani kalulu. Pawa tamun ganakên na sinabin Panginuun Jesus, ‘Pinagpalay mam-i kaysa sa mananggap.’ ” ");
INSERT INTO blx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pamakayarin nagsabin Pablo, niaawyun silan nanduku buy nanalangin. ");
INSERT INTO blx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nanangis silan kaganawan buy tinakês la si Pablo buy dinêp. ");
INSERT INTO blx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ingkalungkut lay sinabin Pabloy a silayna mapikakit manguman. Pamakayari, in-atêl la si Pablo sa barku. ");
INSERT INTO blx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nagpatanda kay sa mani mamunu sa manampalataya sa Efeso buy nagsakay kay angga sa islan Cos. Kinawasakan, nilatêng kay sa islan Rodas. Buy ubat ta baydu, insundu yan na pamita yan angga sa balayan Patara. ");
INSERT INTO blx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pamakalatêng yan sa Patara, dilag kay nakit ta barkuy papakun sa Fenicia. Kabay tambêng kay nagsakay. ");
INSERT INTO blx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dinuman kay sa êtêb Cyprus ya madungawan sa êtêb udi. Insundu yan na pamita yan papakun sa Siria, nuwa tinunggên pun na barku sa Tiro, gawan intabuy bayduy kargan barku. ");
INSERT INTO blx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tingkap yan bayduy mani tagasunul Jesus buy nakitugêl kay kalla sa lalên pituy allu. Sa kapamilatan Ispiritun Bapan Namalyari, pinatandan la si Pablo ya aganayna maku sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nuwa pamakayarin pituy allu, insundu yan na pamita yan. Ya kaganawan manampalataya buy mani asawa buy anak la ya sabay ya namiatêl kanyan sa lawasan balayan. Nanduku kay sa agid lanêm buy nanalangin. ");
INSERT INTO blx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Sên nakapagpatanda kay kalla, nagsakay kay sa barku buy nuli silayna. ");
INSERT INTO blx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ubat sa Tiro, insundu yan na paglayag yan papakun sa Tolemaida. Pamakalatêng yan baydu, napikakit kay sa mani mapatêl sa Panginuun buy nanugêl kay kalla un gisay allu. ");
INSERT INTO blx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kinawasakan, insundu yan na paglayag yan papakun sa balayan Cesarea. Pamakalatêng yan baydu, naku kay sa balin Felipe ya mamiaral Mangêd da Balita buy baydu kay nakitugêl. Si Felipe, gisa ya sa pituy lawyaki ya pinili sabitun nuna sa Jerusalem ya manawup sa mani apostul Jesus. ");
INSERT INTO blx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Si Felipe, dilag yan apat ta anak ka dalaga ya pawan mani propeta. ");
INSERT INTO blx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Pamakayarin dakun umnuy allu, inlumatêng nga gisay propeta ya naglagyun Agabo ya ubat sa prubinsyan Judea. ");
INSERT INTO blx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Inlaku nakay buy kingway yakês Pablo, ta in-is-êl sa mani bitis na buy mani gamêt na. Buy sinabi na, “Ati ya pan-ipasabin Ispiritun Bapan Namalyari. ‘Paradi ya daygên mani Judio sa Jerusalem sa magyakês ati buy idin laya sa mani alwan Judio.’ ” ");
INSERT INTO blx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Sên nalêngê yan na abiin, sikay buy mani mapatêl baydu, nakisabi kay kan Pablo ya aganayna maku sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nuwa nakitbay si Pablo, “Uysiyan manangis kaw yata? Kay pampakaynên yuy nakêm ku. Nakal-an nakun migapus buy agyan mati yaku sa Jerusalem para sa lagyun Panginuun Jesus.” ");
INSERT INTO blx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Sên a yan mabênbênan si Pablo sa pamita na, tinunggên kay yana. Kabay sinabi yan tanay, “Matupad day kalabayan Panginuun.” ");
INSERT INTO blx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pamakayarin dakun umnuy allu, naglêan kay buy namita papakun sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Inawyunan kay dakun umnuy tagasunul Jesus ya taga Cesarea. Impalêt lakay sa balin Mnason buy baydu kay nakitugêl. Si Mnason, taga Cyprus ya buy gisa ya sa mani nunan tagasunul Jesus. ");
INSERT INTO blx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Sên nilatêng kay sa Jerusalem, matula kay tinanggap mani mapatêl sa Panginuun baydu. ");
INSERT INTO blx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kinawasakan, naku si Pablo kan Santiago kaawyun nakay buy idi êt bayduy kaganawan mani mamunu sa manampalataya sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Sinabin Pablo kallay, “Nagpapakun kawna” buy ingkuwentu nay kaganawan dinyag Bapan Namalyari sa mani alwan Judio sa kapamilatan pangaral na. ");
INSERT INTO blx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Sên nalêngê lay abiin, inulimên la si Bapan Namalyari. Amêsên, sinabi la kan Pablo, “Tanda muy patêl, libulibuy nay mani Judioy manampalataya kan Jesus buy masipêg silan kaganawan na manunul sa Kautusan na impasulat kan Moises. ");
INSERT INTO blx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nabalitan layna kanuy pan-iaral mu sa mani Judioy manugêl sa lugal alwan Judio ya a layna kaylangan manunul sa Kautusan na impasulat kan Moises. Sinabi mu kanuy agana layna ipatuli ya anak la o sunulun na kaatag pun êt ta naugalyan taminan mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Amêsên, sabêt ta daygên tamu amên matandan lay alwan pêtêg ga nabalitan la? Tagawan pilmin matandan lay inlumatêng kayna baydi. ");
INSERT INTO blx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mangêd da daygên muy sabin yan kamu. Dilag apat ta lawyaki baydi ya dilag impangaku kan Bapan Namalyari. ");
INSERT INTO blx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pakilaku mu sila sa Templu buy daygên yuy pan-ipadyag Kautusan tungkul sa pallinis. Bayarên mu êt sa pari ya gastus la amên makapagpaurug silan sabut la. Sa paradi ya paralan, matandan kaganawan na alwan pêtêg ga balitay nalêngê la tungkul kamu, gawan makitan lay agyan sika, manunul sa Kautusan na impasulat kan Moises. ");
INSERT INTO blx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ya mani alwan Judioy manampalataya sa Panginuun Jesus, sinulatan yan na sila tungkul sa napikasunduwan yan ya aganayna mangan dakun sabêt man na in-andug sa diyusdiyusan buy aganayna mangan daya buy aganayna mangan ayup pa asê pinadaya buy aganayna makikanayun.” ");
INSERT INTO blx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kinawasakan, pikilakun Pabloy apat ta lawyaki buy dinyag lay abiin na naugalyan lay pallinis. Pamakayari, naku si Pablo sa Templu buy impatanda na nu makanu mayari ya pallinis amên maiandug ga mani saysay para sa balang gisa kalla. ");
INSERT INTO blx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Sên marani yan mayari ya ikapituy allun pallinis la, dilag dakun umnuy mani Judioy ubat sa prubinsyan Asia ya nakakit kan Pablo sa kasawangan Templu. Insagyat lay kaganawan tawuy idi baydu sa kasawangan Templu amên dakpên si Pablo. ");
INSERT INTO blx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Masnêg lan sinabi, “Mani mapatêl yan na Israelita, sawpan yukay! Ya tawun abiin, agyan dakun saantuy lakwên na, manuru ya laban kantamun mani Judio, sa Kautusan na impasulat kan Moises buy sa Templun ati. Alwa pun êt kay abiin, gintan na pun baydi sa Templuy mani alwan Judio. Kabay kinadidiyan nay banal la lugal.” ");
INSERT INTO blx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Sinabi lay abiin gawan nakitan la si Trofimo ya taga Efeso ya kaawyun Pablo baydu sa Jerusalem buy indap la nu pikilaku yan Pablo sa Templu. ");
INSERT INTO blx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kabay naguluy mani tawu sa buun Jerusalem buy nanduyung sila sa Templu amên dakpên si Pablo. Pamakadakêp la kana, ginuluy laya pasalwang sa Templu buy tambêng lan insaray pasbul Templu. ");
INSERT INTO blx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nuwa sên patin layna dayi si Pablo, dilag nakapagsabi sa pinakamatag-ay ya pinunu un mani sundalus Romanoy maguguluy mani tawu sa buun Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kabay tambêng yan namisagyat mani kapitan buy mani sundalus la buy inlaku lay mani tawuy magugulu. Pamakakit mani tawu sa pinakamatag-ay ya pinunu buy sa mani sundalus, tinunggên silan mandugê kan Pablo. ");
INSERT INTO blx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kabay inlakun pinakamatag-ay ya pinunun sundalus si Pablo buy impadakêp. In-utus na êt ta gapusun yan luway tanikala. Pamakayari, pinatang pinakamatag-ay ya pinunun sundalus ya mani tawu, “Sisabêt ta tawun ati buy sabêt ta dinyag na?” ");
INSERT INTO blx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nuwa asê pariparisuy mani pakitbay ya nalêngê na. Buy gawan sa maragul la gulun mani tawu, asê tandan pinakamatag-ay ya pinunun sundalus nu sabêt ta pêtêg nalyari. Kabay in-utus nay mani sundalus ya gêtan si Pablo sa kampu. ");
INSERT INTO blx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pamakalatêng la sa eran kampu, insapat la ta si Pablo gawan maguluy mani tawu. ");
INSERT INTO blx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pikilalakwan laya buy masnêg lan pansabin, “Patin ya!” ");
INSERT INTO blx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Sên gêtan na si Pablo sa lalên kampun mani sundalus, sinabi na sa pinakamatag-ay ya pinunun mani sundalus sa sabin Griego, “Dilag gaku dayin sabin kamu.” Nakitbay ya, “Katanda ka awêd magsabin Griego? ");
INSERT INTO blx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nu parabaydu awêd, alwan sikay abituy liyaki ya taga Egipto ya dakun nakanu namunu sa pagribeldi sa gubernu. Gintan na sa kakyangan na apat ta libuy lawyaki ya mangatubag buy mamatin tawu.” ");
INSERT INTO blx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Nakitbay si Pablo, “Gisa kun Judio ya in-anak sa Tarso ya sabay ya pikatandan na balayan sa prubinsyan Cilicia. Nu malyari, tulutan mukun magsabi sa mani tawu.” ");
INSERT INTO blx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tinulutan yan pinakamatag-ay ya pinunun mani sundalus. Kabay nidêng si Pablo sa eran buy naningyal ya sa mani tawun dilag yan sabin. Sên nangimbêk silayna, nagsabi ya sa sabin Hebreo ya sarilin sabin mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mapatêl buy mangatwa kuway, lêng-ên yu pun na sabin ku bilang pamitanggul ku sa sarili ku!” ");
INSERT INTO blx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Sên nalêngên mani tawuy magsabi si Pablo sa sabin Hebreo, suspu silan nangimbêk. Kabay insundun Pablo ya pagsabi na, ");
INSERT INTO blx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Judio waku ya in-anak sa balayan Tarso sa prubinsyan Cilicia, nuwa dinumagul laku baydi sa Jerusalem. Nag-aral laku baydi buy ya nanuru kangku, si Gamaliel. Masipit nan inturu kangkuy Kautusan na pansunulun mani ninunu tamu. Buun nakêm ku êt pagsuywan si Bapan Namalyari kaparisu yu amêsên ya idi baydi. ");
INSERT INTO blx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pinasakit kuy mani manunul sa panurun Jesus buy impapati kuy kaatag. Impadakêp ku sila buy impasukul, lawyaki man o babayi. ");
INSERT INTO blx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ya pinakapuun pari buy kaganawan mangatwan Judioy mangatuynungan, silay magpapêtêg sa kaganawan sinabi ku. Silay nam-in sulat kangku para sa mani mapatêl tamun mani Judioy idi sa Damasco. Sa kapamilatan sulat ta abitu, indin la kangkuy karapatan maku sa Damasco amên dakpên na mani manampalataya kan Jesus buy gêtan mag-udung baydi sa Jerusalem amên parusan.” ");
INSERT INTO blx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Sên ugtuy na buy narani yakina sa Damasco, bêngat tan nangulimad sa palitêng kuy mamakasilêw wa sawang nga ubat sa langit. ");
INSERT INTO blx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nipalukub baku sa luta buy dilag gakun nalêngêy tunuy ya magsabi kangkun, ‘Saulo, Saulo, uysiyan pan-usigin muku yata?’ ");
INSERT INTO blx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Namatang ngaku, ‘Panginuun, sisabêt ka?’ Nakitbay ya tunuy, ‘Siku si Jesus ya taga Nazaret ya pan-usigin mu.’ ");
INSERT INTO blx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nakitan mani kaawyun kuy sawang nuwa a la nalêngêy tunuy ya nagsabi kangku. ");
INSERT INTO blx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Buy namatang ngaku pun êt, ‘Panginuun, sabêt ta daygên ku?’ Sinabin Panginuun, ‘Midêng ka buy maku ka sa balayan Damasco. Ta dilag baydun magsabi kamun kaganawan in-il-an kun ipadyag kamu.’ ");
INSERT INTO blx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nabulag gaku sa sadyay sawang. Kabay tinambay yakun mani kaawyun ku papakun sa Damasco.” ");
INSERT INTO blx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Baydu sa Damasco, dilag gisay tawuy naglagyun Ananias. Dilag yan limu kan Bapan Namalyari buy manunul ya sa Kautusan. Panggalangên yan mani Judioy manugêl baydu. ");
INSERT INTO blx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Inlaku naku buy sinabi na, ‘Patêl la Saulo, makakit kaynan manguman!’ Pamakasabi na kangku, nakakit takun manguman buy nakit kuya. ");
INSERT INTO blx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Sinabi na kangku, ‘Ya Bapan Namalyarin mani ninunu tamu sabay ya namili kamu amên matandan muy kalabayan na buy amên makitan mu buy mallêngêy tunuy un Matinêk ka Lingkud na. ");
INSERT INTO blx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ta sikay magpapêtêg sa kaganawan tawu nu sabêt ta abituy nakit buy nalêngê mu. ");
INSERT INTO blx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Amêsên, sabêt pun na pan-êtêngên mu? Midêng kayna buy pabawtismu buy mamêg sa Panginuun amên luminis ka sa mani kasalanan mu.’ ” ");
INSERT INTO blx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Pamakayari, nag-udung ngaku sa Jerusalem. Buy kaban manalangin naku sa Templu, dilag gakun nasulêplêp. ");
INSERT INTO blx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nakit ku si Jesus ya magsabi kangkun, ‘Parasên mu! Tambêng kan mita sa Jerusalem, gawan asê tanggapên mani manugêl baydi ya pagpapêtêg mu tungkul kangku.’ ");
INSERT INTO blx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Sinabi ku, ‘Panginuun, tanda lay sabitun nuna, dinurutan kuy mani balin pagtipunan mani Judio amên ta dakpên buy dugên na mani tawuy manampalataya kamu. ");
INSERT INTO blx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Buy sên patin si Esteban na magpapêtêg tungkul kamu, idi yaku baydu buy nakiayun naku kalla, ta sikuy namantay mani balabal mani namati kana.’ ");
INSERT INTO blx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nuwa sinabin Panginuun kangkuy, ‘Mita ka, gawan iutus kata sa marayuy lugal amên iaral muy tungkul kangku sa mani alwan Judio.’ ” ");
INSERT INTO blx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Sên pamakasabin Pablon tungkul sa mani alwan Judio, a yina labay lêng-ên mani Judio buy masnêg lan sinabi, “Patin na tawun abiin! A ya sêpat bumyay baydi sa babun luta!” ");
INSERT INTO blx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Insundu lay pan-angaw la, pan-iwêswês lay mani balabal la buy pan-isamwag lay abu patag-ay. ");
INSERT INTO blx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kabay in-utus pinakamatag-ay ya pinunu sa mani sundalus nay gêtan si Pablo sa lalên kampu un latikun angga sa sabin na nu sabêt ta nadyag nay kasalanan. Labay nan matandan ya siyan paray nabayduy pansabin mani tawu laban kana. ");
INSERT INTO blx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Sên naigapus layna si Pablo amên latikun, sinabi na sa kapitan mani sundalus ya nakaidêng bayduy, “Ustu nayi sa batas ya latikun na gisay Romano, agyan asê pun inlitis ya kasu na?” ");
INSERT INTO blx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Sên nalêngên kapitan mani sundalus ya abiin, naku ya sa pinakamatag-ay ya pinunun sundalus buy sinabi na, “Sabêt ta ati ya pan-ipadyag mu? Romano awêd da tawun abitu.” ");
INSERT INTO blx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kabay nakuy pinakamatag-ay ya pinunun sundalus kan Pablo buy namatang, “Romano ka nayi?” Nakitbay si Pablo, “Awu.” ");
INSERT INTO blx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Sinabin pinakamatag-ay ya pinunun sundalus, “Siku man êt, napakadyag Romano nuwa kay sa kapamilatan pamayad maragul la alaga.” Nakitbay si Pablo, “Nuwa siku, in-anak kakinan Romano.” ");
INSERT INTO blx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tambêng nakadêtnay mani sundalus ya mallitis dayi kana. Nalimu êt ta pinakamatag-ay ya pinunun sundalus gawan impagapus na si Pablo pakan gisa ya awêd Romano. ");
INSERT INTO blx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Taganan labay matandan pinakamatag-ay ya pinunun sundalus nu sabêt ta panangkan mani Judio kan Pablo. Kabay pamakawasak, impabêg nay mani mamunun pari buy kaganawan mangatwan Judioy mangatuynungan. Pamakayari, impakalag nay tanikalan Pablo buy in-arap laya kalla. ");
INSERT INTO blx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pinapakaêlêw Pabloy mani mangatwan Judioy mangatuynungan buy sinabi na, “Mani mapatêl ku, nu tungkul sa pamibiyaybiyay ku, malinis ya nakêm ku kan Bapan Namalyari angga amêsên.” ");
INSERT INTO blx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pamakasabin Pablon abiin, si Ananias ya pinakapuun pari, impadadpik na si Pablo sa mani tawuy narani kana. ");
INSERT INTO blx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Sinabin Pablo kana, “Dadpikin ka êt Bapan Namalyari, sikay magtatalingkayu! Nakaiknu ka baysên amên atulan naku ayun sa Kautusan, pakan mismun sika, pallabagên muy Kautusan. Ta agyan asê pun napagpapêtgan na nangasalanan naku, impadadpik mukina!” ");
INSERT INTO blx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Sinabin mani tawuy nakaidêng sa danin Pabloy, “Pallamusun mu yay pinakapuun parin Bapan Namalyari ta!” ");
INSERT INTO blx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Nakitbay si Pablo, “Mani mapatêl, a ku tandan siya awêd da pinakapuun pari. Ta nu tanda ku dayi, a kina sinabi ya parabaydu, tagawan idi sa kasulatan, ‘Agana ka mallamus sa mamunu yu.’ ” ");
INSERT INTO blx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Amêsên, sên nakitan Pabloy dilag mani Saduseo buy dilag êt mani Pariseo sa mani mangatwan Judioy mangatuynungan, masnêg nan sinabi kalla, “Mani mapatêl, Pariseo waku. Ya bapa ku, Pariseo êt. Indalum laku gawan napilmi yakun manguman mabyay ya mani nati.” ");
INSERT INTO blx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Sên nasabi nay abiin, nisusubakan na mani Pariseo buy Saduseo buy nangapisisyay ya mani mangatwan Judioy mangatuynungan. ");
INSERT INTO blx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nalyari ya abitu, gawan ayun sa mani Saduseo, ayin panguman pangabyay. A sila êt maniwalan dilag mani ang-el o mani ispiritu. Nuwa ya kaganawan abiin, paniwalan mani Pariseo. ");
INSERT INTO blx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kabay naipakasnêg lay sinabi la. Nidêng nga dakun umnuy Pariseoy manurun Kautusan buy impakatutu lan sinabi, “Ayin kay nakitan na kasalanan sa tawun ati. Dat dilag ispiritu o ang-el la nakisabi kana!” ");
INSERT INTO blx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Luyang inumumut ta pamisubakan la angga sa nalimuy pinakamatag-ay ya pinunun sundalus ya dat pipapaktangên mani tawu si Pablo. Kabay namiutus yan mani sundalus nan magtabuy buy kêwên si Pablo sa mani tawu ta gêtan ya sa kampu. ");
INSERT INTO blx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pamakayabi, nagpakit ta Panginuun kan Pablo buy sinabi kanay, “Pas-êyên muy nakêm mu gawan nu parasaantu kan nagpapêtêg tungkul kangku baydi sa Jerusalem, para êt bayduy daygên mu sa Roma.” ");
INSERT INTO blx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Pamakamaranun, dilag maigit apattapuy Judioy nititipun amên ipalanu la nu parasaantu lan patin si Pablo. Nangaku silan a sila mangan o minêm anggan a la mapati si Pablo. ");
INSERT INTO blx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kabay naku sila sa mani mamunun pari buy sa mangatway manungkulan buy sinabi kallay, “Impangaku yan ya a kay mangan agyan dakun sabêt man anggan a yan mapati si Pablo. ");
INSERT INTO blx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kabay sikaw buy mani mangatwan Judioy mangatuynungan, yawarên yu sa pinakamatag-ay ya pinunun sundalus Romanoy labay yu pun ipalakun manguman baydi si Pablo. Sabin yuy labay yuya pun papakalitisin. Pakan bayu yapun milatêng baydi, apatan yan nina.” ");
INSERT INTO blx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nuwa ya palanu la, nalêngên liyaki ya angkên Pablo ya anak patêl nay babayi. Kabay sinumun ya sa kampun mani sundalus buy impatanda kan Pabloy abiin. ");
INSERT INTO blx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Binêg Pabloy gisa sa mani kapitan sundalus baydu buy sinabi nay, “Ilaku mu kayêk ya bayuntawun ati sa pinakamatag-ay ya pinunun sundalus, gawan dilag yan sabin kana.” ");
INSERT INTO blx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kabay inlaku yabay kapitan sa pinakamatag-ay ya pinunun sundalus. Pamakalatêng la baydu, sinabin kapitan, “Binêg gakun Pabloy nakasukul buy nakisabi ya kangkun ilaku ku baydi kamuy bayuntawun ati, gawan dilag yan sabin kamu.” ");
INSERT INTO blx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tinambay pinakamatag-ay ya pinunun sundalus ya bayuntawu buy inlaku naya sa lugal la ayin kaatag makalêngê buy pinatang naya, “Sabêt ta sabin mu kangku?” ");
INSERT INTO blx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Sinabin bayuntawu, “Nikasunduy mani Judion yawarên kamuy ilaku wasak si Pablo sa mangatwan Judioy mangatuynungan, gawan pakangêdên laya kanwadis litisin. ");
INSERT INTO blx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nuwa agana ka maniwala kalla, gawan dilag maigit apattapuy tawuy magbantay ya mangapat kana. Nangaku silan a sila mangan o minêm anggan a la mapati si Pablo. Amêsên, nakal-an silayna. Kay mangêtêng sila tanan paintulut mu.” ");
INSERT INTO blx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Sinabin pinakamatag-ay ya pinunun sundalus kanay, “Agana mu sabin agyan kansabêt ta imbalita muy ati kangku.” Buy impauli nay bayuntawu. ");
INSERT INTO blx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tambêng impabêg pinakamatag-ay ya pinunun sundalus sa luway kapitan mani sundalus buy sinabi kallay, “Mamil-an kaw luwan dalan na sundalus ta ipalaku kataw sa Cesarea. Mipikilaku kaw êt pitumpuy sundalus ya nakakabayu buy luwan dalan na sundalus ya nipagbayi. Mita kaw paênggan alas nuwebin yabi. ");
INSERT INTO blx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mamil-an kaw êt mani kabayuy pagsakayan Pablo. Papakabantayan yuya amên ayin malyari kana angga sa milatêng ya kan Gobernador Felix.” ");
INSERT INTO blx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Buy nanulat ta pinakamatag-ay ya pinunun sundalus kan Gobernador Felix. Paradi ya insulat na, ");
INSERT INTO blx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Panggalangên na Gobernador Felix, siku si Claudio Lisias ya nanulat kamu. Nagpapakun kayna. ");
INSERT INTO blx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ya tawuy pan-igawang ku kamuy dinakêp mani Judio buy patin. Nuwa natandan kuy gisa ya awêd Romano. Kabay namipikilaku wakun mani sundalus buy inligtas ya. ");
INSERT INTO blx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","In-arap kuya sa mani mangatwan Judioy mangatuynungan amên matandan ku nu sabêt ta pan-isangkan la kana. ");
INSERT INTO blx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Natandan kuy pan-isangkan kanay kay tungkul awêd sa kautusan reliiyun la. Nuwa ayin sêpat ya sangkan amên ipasukul o ipapati ya. ");
INSERT INTO blx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kabay sên natandan kuy palanun mani Judioy patin ya, tambêng kuyan impalaku kamu. Sinabi ku êt sa mani mamidalum kanay magdalum sila kamu.” ");
INSERT INTO blx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sinunul mani sundalus ya utus kalla. Buy sa yabin abitu, kingwa la si Pablo buy gintan laya sa balayan Antipatris. ");
INSERT INTO blx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pamakawasak, ya mani sundalus ya asê nakakabayu, nag-udung sila sa kampu. Nuwa ya mani sundalus ya nakakabayu, inawyunan la si Pablo papakun sa balayan Cesarea. ");
INSERT INTO blx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Sên inlumatêng sila sa Cesarea, in-arap la si Pablo sa gobernador buy indin ya sulat. ");
INSERT INTO blx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Binasa nay ati buy pinatang na si Pablo, “Taga saantu ka?” Nakitbay si Pablo, “Taga Cilicia ku.” Sên natandan nay taga Cilicia si Pablo, ");
INSERT INTO blx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","sinabi na, “Nu lumatêng nga mani mamidalum kamu, lêng-ên kuy kasu mu.” Buy impabantay Gobernador si Pablo sa palasyuy impadyag Arin Herodes. ");
INSERT INTO blx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pamakalibas limay allu, naku sa Cesarea si Ananias ya pinakapuun pari. Kaawyun nay dakun umnuy mangatway manungkulan buy ya abugaduy si Tertulo. Nag-arap sila kan Gobernador Felix buy sinabi lay panangkan la kan Pablo. ");
INSERT INTO blx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Sên in-arap layna kalla si Pablo, inumpisan nan Tertulo ya pamidalum kana. Sinabi na, “Panggalangên na Gobernador, gawan sa mangêd da pamunu mu, dilag kapatêtbêkan baydi sa bansa yan buy malakêy imbayu muy ingkakangêd bansa yan. ");
INSERT INTO blx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kabay agyan saantu man buy agyan kanuman, dilag kay utang nga nakêm kamu buy ayin katganan na pagpasalamat yan kamu. ");
INSERT INTO blx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Amêsên, a yan labay ya maabala ka. Kabay makisabi yaku kamu ya nu malyari, lêng-ên muy naêpêk ka sabin yan. ");
INSERT INTO blx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nakitan yan na manggulu sa mani Judioy tawun ati agyan antu man na lugal ya lakwên na buy sabay siyay mamunu sa reliiyun ya pambêgên Nazarenu. ");
INSERT INTO blx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Agyan na Templu yan, labay nan dinatan. Kabay dinakêp yan ya. Atulan yan nina dayi ayun sa Kautusan yan, ");
INSERT INTO blx_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","nuwa inlumatêng nga pinakamatag-ay ya pinunun sundalus ya si Lisias buy pinilit nan kingwa kanyan si Pablo. ");
INSERT INTO blx_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Buy sinabi na êt ta nu sisabêt man na dilag pan-isangkan kan Pablo, kaylangan yan maku kamu. Nu litisin muy tawun ati, matandan muy pêtêg ga kaganawan pan-isangkan yan kana.” ");
INSERT INTO blx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Buy napaawu êt ta mani Judio sa kaganawan sinabin Tertulo. ");
INSERT INTO blx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Sên siningyalan nan Gobernador si Pablon siyay nay magsabi, sinabi na, “Panggalangên na Gobernador, tanda kuy mana kaw nan mangukum sa bansan ati. Kabay matula kun itanggul la sarili ku sa arapan mu. ");
INSERT INTO blx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nu mamatang ka sa kaatag tawu, matandan muy ayin pun mapu buy luway alluy pallumatêng ku sa Jerusalem amên mangulimên. ");
INSERT INTO blx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ya mani Judion abiin, agyan misan a laku nakitan na nakisubakan agyan kansabêt man sa Templu o nanyag gulu sa balin pagtipunan mani Judio o agyan dakun saantu man sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ayin silan maipapêtêg sa pan-isangkan la kangku. ");
INSERT INTO blx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nuwa pan-aminin ku kamuy pan-ulimênên kuy Bapan Namalyarin mani ninunu yan ayun sa panurun Jesus. Nuwa sa êlêw lay naman awêd, asê ustuy panampalataya ku. Nuwa maniwala ku êt sa kaganawan idi sa Kautusan na impasulat kan Moises buy sa kaganawan insulat mani propeta. ");
INSERT INTO blx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nanuwad êt sa mani kaparisu kun Judio, napilmi yaku êt ta pabyayên Bapan Namalyari ya kaganawan tawu, matinêk man o asê. ");
INSERT INTO blx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kabay pagpilitan kun pawan manyag mangêd amên magin malinis ya nakêm ku sa arap Bapan Namalyari buy sa mani tawu.” ");
INSERT INTO blx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Pamakayarin dakun umnuy tawun na ayin naku sa Jerusalem, nag-udung ngaku baydu amên mantan sawup sa mani kaluluy kaparisu kun Judio buy amên mamiandug gaku kan Bapan Namalyari sa Templu. ");
INSERT INTO blx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Pamakayari kun dinyag sa Templuy pan-ipadyag Kautusan tungkul sa pallinis, nalatêng laku bayduy mamiandug. Kay pêpêrad da mani tawu sa Templu sa uras abitu buy ayin gulu. ");
INSERT INTO blx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nuwa dilag baydun mani Judioy ubat sa prubinsyan Asia ya nakakit kangku. Sêpat taman dayin silay idi baydin mamidalum kamu, nu taganan dilag silan isangkan laban kangku. ");
INSERT INTO blx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Gawan ayin sila baydi, ya mani tawu tay idi baydi ya magsabi nu sabêt ta kasalanan na nakitan la kangku sabitun inlitis laku sa mani mangatwan Judioy mangatuynungan. ");
INSERT INTO blx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Tagawan ayin nakun kaatag sinabi sa arapan la, nun a kay ati ya masnêg kun sinabi, ‘Pansangkanan yuku amêsên, gawan maniwala kun manguman mabyay ya mani nati.’ ” ");
INSERT INTO blx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Malakêy nay natandan Gobernador Felix tungkul sa panurun Jesus. Kabay impatgên nay pallitis. Sinabi na, “Nu lumatêng nga pinakamatag-ay ya pinunun sundalus ya si Lisias, litisin kuy kasun ati.” ");
INSERT INTO blx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pamakayari, in-utus Gobernador Felix ya kapitan mani sundalus, “Papakabantayan yu si Pablo, nuwa agana igpitan. Paulayan yuy mani kaluguran nay mandungaw buy manawup sa mani kaylangan na.” ");
INSERT INTO blx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pamakayari, dilag inlaku si Gobernador Felix. Buy sên nilibas say dakun umnuy allu, nag-udung ya kaawyun nay asawa nay si Drusila ya gisay Judio. Impabêg na si Pablo amên lêng-ên nay mani pagsabi na tungkul sa panampalataya kan Cristu Jesus. ");
INSERT INTO blx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nuwa sên impaintindin Pabloy tungkul sa matinêk ka pamibiyaybiyay, sa pamênbên sa sarili, buy tungkul sa lumatêng nga Allun Pangukum, nalimu si Gobernador Felix. Kabay sinabi na kan Pablo, “Ustuy na pun na abiin! Ipabêg kata tanan manguman nu dilag gakun panawun.” ");
INSERT INTO blx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pawa nan pan-ipabêg si Pablo amên pakisabyan, gawan pan-êtêngên nan bayaran yan Pablo. ");
INSERT INTO blx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Buy gawan labay Felix ya malabayan yan mani Judio, pinaulayan na si Pablo sa sukulan. Sên nilabas ya luway tawun, insagili kan Felix si Porcio Festo bilang Gobernador. ");
INSERT INTO blx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Si Festo ya bayun gobernador, inlumatêng ya sa prubinsyan Judea sa balayan Cesarea. Pamakalibas tatluy allu, naku ya sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Naku kanay mani mamunun pari buy mangatwan Judio ta sinabi lay panangkan la kan Pablo. Nanyawad sila kan Festo ya biyan silan paintulut ya ipagtan si Pablo sa Jerusalem. Sinabi lay abiin gawan dilag silan palanuy apatan si Pablo sa dan amên patin. ");
INSERT INTO blx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nakitbay si Festo, “Pambantayan si Pablo sa sukulan Cesarea buy tambêng ngaku êt mag-udung baydu. ");
INSERT INTO blx_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Kabay pakilaku yu kangkuy mani manungkulan yu. Nu dilag yan nadyag ga kasalanan, baydu silaynan magdalum.” ");
INSERT INTO blx_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Namalibas pun walu o mapuy allu si Gobernador Festo sa Jerusalem. Pamakayari, nag-udung ya sa Cesarea. Kinawasakan, niknu ya sa pallitisan buy namiutus yan iarap kana si Pablo. ");
INSERT INTO blx_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pamakalatêng Pablo, tambêng yan pinalitêngan mani Judioy ubat sa Jerusalem. Buy malakêy mangabayat ta insangkan la kana, pakan a lay naman taganan napagpapêtgan. ");
INSERT INTO blx_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Intanggul Pabloy sarili na, “Ayin nakun nadyag ga kasalanan laban sa Kautusan mani Judio, sa Templu o sa Emperador.” ");
INSERT INTO blx_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nuwa gawan sa labay Gobernador Festo ya malabayan yan mani Judio, pinatang na si Pablo, “Labay mu nayin maku sa Jerusalem buy baydu ku litisin na kasu mu?” ");
INSERT INTO blx_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nuwa nakitbay si Pablo, “Baydi yakun nakaidêng sa gisay pallitisan un Emperador. Baydi yakun sêpat litisin. Ayin nakun dinyag ga kasalanan sa mani Judio buy tanda muy abiin. ");
INSERT INTO blx_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nu pêtêg ga nallabag gaku sa Kautusan buy sêpat takun atulan kamatyan, pantanggapên kuy atul kangku. Nuwa nu ayin kapêtêgan na pan-isangkan la kangku, a ku sêpat itiwala kalla. Kabay pilitin kun idani sa Emperador Roma ya kasu ku!” ");
INSERT INTO blx_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nakisabi si Festo sa mani kaawyun nan manungkulan. Pamakayari, sinabi na kan Pablo, “Gawan pan-ipilit mun idani sa Emperador ya kasu mu, ipagtan kata kana.” ");
INSERT INTO blx_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Pamakalibas dakun umnuy allu, inlumatêng sa Cesarea si Arin Agripa buy patêl na ya si Bernice gawan labay lan makitan si Gobernador Festo. ");
INSERT INTO blx_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kaban manugêl sila baydun dakun umnuy allu, sinabin Festo kan Arin Agripay tungkul sa kasun Pablo, “Dilag liyaki baydi ya nakasukul la manan inlakwanan Gobernador Felix. ");
INSERT INTO blx_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Sabitun idi yaku sa Jerusalem, indalum mani mamunun pari buy mangatway manungkulan mani Judio ya tawun ati. Inyawad la kangkuy atulun kuya.” ");
INSERT INTO blx_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Sinabi ku kallay alwan kaugaliyan mani Romanoy parusan ya agyan sisabêt ta tawu ya asê pun napiarap ya mani manangkan buy pansangkanan buy asê pun nabiyan panawun na maitanggul nay sarili na. ");
INSERT INTO blx_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kabay sa pag-udung ku sa Cesarea, nakilaku sila kangku. Kinawasakan tambêng ngakun niknu sa pallitisan buy impakwa kuy tawun abitu. ");
INSERT INTO blx_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Indap ku nu dilag silan mabayat ta panangkan kana, nuwa sên niaarap silayna, ayin naman awêd. ");
INSERT INTO blx_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ya mani pitutubagan la, kay tungkul sa reliiyun la buy sa gisay tawuy maglagyun Jesus. Nati yay tawun abitu, nuwa pan-ipilit Pabloy nabyay ya. ");
INSERT INTO blx_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","A ku tanda nu sabêt ta daygên ku sa kasun ati. Kabay pinatang ku si Pablo nu kalabay yan maku sa Jerusalem ta baydu kuya litisin. ");
INSERT INTO blx_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nuwa impilit Pablo ya idani sa Emperador ya kasu na. Kabay namiutus sakun bantayan ya angga sa maipaatêl kuya sa Emperador.” ");
INSERT INTO blx_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Sinabin Arin Agripa kan Gobernador Festo, “Labay kun malêngêy tawun abitu.” Nakitbay si Gobernador Festo, “Awu, wasak malêngê muya.” ");
INSERT INTO blx_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kinawasakan, inlumatêng sa pallitisan silan Arin Agripa buy si Bernice ya nakayaming un mamangêd. Malakêy pinunun mani sundalus buy mani pikatandan na tawu sa balayan na nakilaku kalla. Pamakayari, impakwan Gobernador Festo si Pablo buy in-arap kalla. ");
INSERT INTO blx_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Sinabin Gobernador Festo, “Panggalangên na Arin Agripa buy sikaw wa kaganawan idi baydi amêsên, abiin nay tawuy indalum kangkun mani Judio baydi sa Cesarea buy sa Jerusalem. Masnêg lan sinabi ya a yina sêpat bumyay. ");
INSERT INTO blx_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nuwa sa pallitis ku, ayin nakun nakitan na sangkan amên atulun yan kamatyan. Buy gawan impilit nan idani sa Emperador ya kasu na, nagdisisyun nakun ipagtan ya sa Emperador. ");
INSERT INTO blx_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nuwa ayin nakun maisulat ta sangkan sa Emperador tungkul sa tawun abiin ya ipagtan ku baydu kana. Kabay pan-iarap kuya kamuyu buy luyang ngabay kamuy Arin Agripa amên pamakayarin pallitis tamu kana, dilag gakinan isulat. ");
INSERT INTO blx_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tagawan asê ustuy ipagtan sa Emperador ya gisay nakasukul nu ayin malinaw wa pan-isangkan laban kana.” ");
INSERT INTO blx_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Pamakayari, sinabin Arin Agripa kan Pablo, “Malyari minan sabin na pamitanggul mu sa sarili mu!” Kabay naningyal si Pablon magsabi yina. ");
INSERT INTO blx_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Sinabin Pablo, “Panggalangên kun Arin Agripa, pan-ituwad kun mapalad daku gawan binyanan mukun panawun midêng sa arapan mu amên itanggul kuy sarili ku sa kaganawan pan-isangkan mani Judio laban kangku. ");
INSERT INTO blx_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Luyang ta tanda muy kaganawan naugalyan buy mani pamisusubakan mani Judio. Kabay panyawarên ku, nu malyari, lêng-ên muy sabin ku.” ");
INSERT INTO blx_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Tandan mani Judio nu parasaantuy pamibiyaybiyay ku ubat sa anak kaku pun sa sarili kun balayan angga sa idi yaku sa Jerusalem. ");
INSERT INTO blx_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Mana lay nan tanday abiin buy nu labayên la ta dayin magpapêtêg, kabilang ngaku sa mani Pariseo ya sabay ya pinakamaigpit sa reliiyun yan mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kabay abiti yaku amêsên na pallitisin sa ukuman gawan sa kapilmiyan kun tuparên Bapan Namalyari ya impangaku na sa mani ninunu yan. ");
INSERT INTO blx_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ya pangakun abiin, sabay êt ta kapilmiyan mapu buy luway layi yan. Kabay allu buy yabi yan pan-ulimênên si Bapan Namalyari. Arin Agripa, gawan sa paniwala ku sa mani abiin, pansangkanan nakun mani Judio. ");
INSERT INTO blx_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Buy sikaw wa mani Judio, uysiyan a kaw ya maniwalan agyun pabyayên Bapan Namalyari ya mani nati ta?” ");
INSERT INTO blx_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Sabitun nuna, naisip ku êt ta sêpat kun kalabanên si Jesus ya taga Nazaret. ");
INSERT INTO blx_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Parabayduy dinyag ku sabitun nuna sa Jerusalem. Sa kapamilatan karapatan na indin kangkun mani mamunun pari, malakêy manampalataya kan Jesus ya impasukul ku. Buy sên atulan silan kamatyan, nakiayun naku êt kallan nangatul. ");
INSERT INTO blx_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nakatiumnu wakinan mamaku sa balin pagtipunan mani Judio amên parusan sila buy pampilitin ku silan magsabin laban kan Jesus. Sa sadyay tubag ku kalla, pampasakitin ku sila angga sa mangarayuy lugal.” ");
INSERT INTO blx_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Abiin na sangkan ya naku waku sa Damasco ya dilag gintan na sulat ubat sa mani mamunun pari. Ya sulat abitu, sabay ya nam-i kangkun karapatan buy paintulut ya mandakêp sa mani manampalataya kan Jesus. ");
INSERT INTO blx_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Arin Agripa, kaban mamita ku papakun sa Damasco, sên ugtuy nan allu, bêngat tan nangulimad sa palitêng yan ya mamakasilêw wa sawang nga ubat sa langit. ");
INSERT INTO blx_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nipalukub kay kaganawan sa luta buy dilag gakun nalêngêy tunuy ya magsabi kangku sa sabin Hebreo, ‘Saulo, Saulo, uysiyan pan-usigin muku yata? Kay pampasakitan mutay sarili mu. Para katan mandansêk sa natayad da kayu.’ ");
INSERT INTO blx_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Namatang ngaku, ‘Panginuun, sisabêt ka?’ Nakitbay ya Panginuun, ‘Siku si Jesus ya pan-usigin mu. ");
INSERT INTO blx_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Midêng kayna. Nagpakit taku kamu gawan pinili katan magin lingkud ku buy magpapêtêg un nakitan mu kangku amêsên buy mani ipakit ku pun êt kamu. ");
INSERT INTO blx_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Iligtas kata sa mani kaparisu mun Judio buy sa mani alwan Judio nu saantu kata iutus. ");
INSERT INTO blx_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Iutus kata kalla amên ibuklat muy mata la amên iudung silayna sa nasawang nga kapangyarian Bapan Namalyari ubat sa nadiglêm ma kapangyarian Satanas. Sa kapamilatan panampalataya la kangku, patawarên sila sa mani kasalanan la buy miawyun sila sa mani tawuy pinilin Bapan Namalyarin kay kana.’ ” ");
INSERT INTO blx_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kabay Arin Agripa, sinunul kuy sinabi sa sulêplêp pa impakit kangkun ubat sa langit. ");
INSERT INTO blx_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ya nuna kun dinyag, nangaral laku sa Damasco buy pamakayari, sa Jerusalem. Ubat sa Jerusalem inlaku kuy buun Judea buy inlaku ku êt ta mani alwan Judio. In-aral ku kalla ya sêpat silan magsisi sa mani kasalanan la buy mag-udung kan Bapan Namalyari buy ipakit la sa kapamilatan mani diyag lay pêtêg ga nagsisi sila. ");
INSERT INTO blx_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Gawan sa pangaral ku, dinakêp pakun mani Judio baydu sa kasawangan Templu buy labay laku dayin patin. ");
INSERT INTO blx_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nuwa pansawpan nakun Bapan Namalyari angga sa allun ati. Kabay idi yaku baydi amêsên amên magpapêtêg tungkul kana sa kaganawan tawu, sa mani tawuy pikatandan o asê. Ayin nakun kaatag sabin, nun a abituy impasulat sa mani propeta buy impasulat kan Moises. ");
INSERT INTO blx_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Sinabi la ya Cristuy impangakun Bapan Namalyari, kaylangan nan makadanas kasakitan buy mati buy muna yan mabyay ubat sa kamatyan amên maipangaral sa mani Judio buy sa mani alwan Judio ya balitay paran sawang nga mamasawang kalla ya malyari silaynan miligtas sa mani kasalanan la.” ");
INSERT INTO blx_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Kaban magsabi pun si Pablo, masnêg sinabin Festo, “Tinulaw kaynay Pablo! Nasiray nay utêk mu gawan sa subray pag-aral!” ");
INSERT INTO blx_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nakitbay si Pablo, “Panggalangên na Festo, a ku tinulaw. Pêtêg ga mani pansabin ku buy ustuy isip ku. ");
INSERT INTO blx_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","A ku malimun magsabi kana. Napilmi yakun tanda nay mani bagay ya abiin, gawan alwan kay sa liim ya nalyari. ");
INSERT INTO blx_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Arin Agripa, maniwala ka nayi sa mani pansabin mani propeta? Tanda kuy maniwala ka.” ");
INSERT INTO blx_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Nakitbay si Arin Agripa, “Indap mu bay nu bêngat mukun masagyat magin Cristiyanu.” ");
INSERT INTO blx_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Nakitbay si Pablo, “Ya panyawarên ku kan Bapan Namalyari, mabuyutan man o asê, alwan kay sika nun a sikaw kaganawan na mallêngê kangku amêsên, pakadyag Cristiyanu kaparisu ku. Nuwa a ku labay ya misukul kaw.” ");
INSERT INTO blx_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pamakayari, nidêng si Arin Agripa buy si Gobernador buy si Bernice, buy ya kaganawan kaawyun lay nakaiknu baydu. ");
INSERT INTO blx_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Sên inumawas sila, sinabi la sa balang gisa, “Pakan ayin yan dakun sabêt ta dinyag ga tawun abitu amên atulan yan kamatyan o isukul ta.” ");
INSERT INTO blx_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Sinabin Arin Agripa kan Gobernador Festo, “Nu a na ta dayi indani sa Emperador ya kasu na, malyari ya dayin mibus.” ");
INSERT INTO blx_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Sên napikasunduwan lay maglayag kay papakun sa Italia, intiwala la kan Julio si Pablo buy ya kaatag nakasukul. Si Julio, gisa yan kapitan mani sundalus Romano ya pambêgên “Batalyun Emperador.” ");
INSERT INTO blx_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Baydu sa Cesarea, dilag gisay barkuy ubat sa balayan Adramicio ya papakun sa mani paglatngan prubinsyan Asia. Baydu kay nagsakay. Nakilaku kanyan si Aristarco ya taga balayan Tesalonica sa prubinsyan Macedonia. ");
INSERT INTO blx_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kinawasakan, inlumatêng kay sa balayan Sidon. Mangêd da nakêm Julio kan Pablo. Kabay tinulutan nan magliwa si Pablo sa mani kaluguran bay