﻿USE sofia;
DROP TABLE IF EXISTS sofia.blw_vpl;
CREATE TABLE blw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES blw_vpl WRITE;
INSERT INTO blw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chichato hen natontonan hen nangingganà an Jesu Cristu way ganà Arey David way narpon Abraham. ");
INSERT INTO blw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ummanà ah Abraham wat ah Isaac way nangen-anà an Jacob. Yag anat umanà ah Jacob wat cha Juda way masosnod. ");
INSERT INTO blw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ah Juda, enahawana ah Tamar wat inyanàcha cha Fares an Zara. Ah Fares, inyanàna ah Esrom way nangen-anà an Ram. ");
INSERT INTO blw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ah Ram, inyanàna ah Aminadab. Ah Aminadab, inyanàna ah Naason, yag ah Naason, inyanàna ah Salmon. ");
INSERT INTO blw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Cha Salmon way hen-ahawa an Rahab, inyanàcha ah Boaz. Yag cha Boaz way hen-ahawa an Ruth, inyanàcha agé ah Obed way nangen-anà an Jesse. ");
INSERT INTO blw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yag ah Jesse, inyanàna ah David way nan-are. Ah David way annag enahawa hen ahawan Urias, chicha hen nangen-anà an Solomon. ");
INSERT INTO blw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Yag ah Solomon, inyanàna ah Roboam, yah Roboam, inyanàna ah Abias, yah Abias, inyanàna ah Asa. ");
INSERT INTO blw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ah Asa, inyanàna ah Josafat. Ah Josafat, inyanàna ah Joram way nangen-anà an Ozias. ");
INSERT INTO blw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ah Ozias, inyanàna ah Jotam way nangen-anà an Ahaz, ya ah Ahaz, inyanàna ah Ezekias. ");
INSERT INTO blw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ah Ezekias, inyanàna ah Manasse way nangen-anà an Amon, yah Amon, inyanàna ah Josias. ");
INSERT INTO blw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ah Josias, inyanàna cha Jeconias way masosonod. Yag hen hiyachiy tempo, yachi hen niyéyan hen anchichay ganà Israel ad Babilonia way nan-alepan. ");
INSERT INTO blw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Angkay hiyachi way wachacha ad Babilonia, ummanà ah Jeconias wat ah Sealtiel way nangen-anà an Zorobabel. ");
INSERT INTO blw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ah Zorobabel, inyanàna ah Abiud way nangen-anà an Eliakim, yah Eliakim, inyanàna ah Azor. ");
INSERT INTO blw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ah Azor, inyanàna ah Sadoc way nangen-anà an Akim, yah Akim, inyanàna ah Eliud. ");
INSERT INTO blw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Angkay ummanà ah Eliud wat ah Eleazar way nangen-anà an Matan, ya ah Matan, inyanàna ah Jacob. ");
INSERT INTO blw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ah Jacob, hiyan nangen-anà an Jose way ahawan Maria way inan Jesus. Ya ah Jesus, hiya hen anchi Cristu way empopostan Apudyus way epalena hen antoy lota way mantoray. ");
INSERT INTO blw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Wat hiyachi, nanepod an Abraham ingganan David wat ma-ahemporo ya opat way apo. Yag nanepod agé an David inggana hen anchi niyéyan hen anchichay ganà Israel ad Babilonia, wat na-ahemporo ya opat agé way apo. Yag nanepod hen anchi niyéyancha ad Babilonia inggana hen anchi niyana-an Cristu way empopostan Apudyusat na-ahemporo ya opat way apo agé. ");
INSERT INTO blw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yato hen nekaman hen niyana-an Jesu Cristu. Ah Maria way inana, netotorag way man-ahawacha an Jose, ngém cha-ancha mantepon yag fin-énat Maria way nafugi peet way gapo hen kafaelan hen Espiritun Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ngém ah Jose way katoragna, na-ammuwana way nafugi ah Maria ngém maid innilana hen nekaman, wat gapo ta annag sosolloton yanggay hen orchincha, ekatnéén masapor achina etoroy. Ngém gapo agé ta achina laychén way maustan ah Maria wat ekatnéén iyanapna hen ekamanna way achi mangentoroy way achi ma-am-ammuwan. ");
INSERT INTO blw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngém angkay hiyachi way chana ham-éham-én hen ekamanna, nampàilaat agé hen ihay anghel Apudyus hen nan-in-inpana way mangaliyén, “Heay Jose way ganà David, achia cha mafiinan way mangen-ahawa an Maria, te hen anchi finuginaat maid kasen narpowana no faén yanggay hen kafaelan hen Espiritun Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wat iyanàna hen larae way ngadnanyu ah Jesus te hiya hen mangenharà an chàyu way ahentaguna hen machusaanyu gapo hen fasoryu.” ");
INSERT INTO blw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na-ammaan amin chato ah tommot-owaan hen anchi imfagan Apudyus ad namenghan way ensorat hen profetana, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ammag an mafugi hen ihay fafarasang way cha-an matmatchà, yag iyanàna hen larae way mangadnan ah Emmanuel way hen laychén nadchiy aryénat i netape ah Apudyus an chitaaw ad uwan.” ");
INSERT INTO blw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Angkay hiyachi way fummangon ah Jose, enafurotna hen imfagan hen anchi anghel wat enteponna ah Maria. ");
INSERT INTO blw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngém iggayna paat tadtad-én hiya ingganah ummanà. Yag angkay ummanà, ngenadnan Jose hen anchi utteng ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Angkay hiyachi way tempon hen ka-aren Herod, niyanà tot-owa ah Jesus ad Bethlehem way ihay fabréy hen anchi provinsiyan hen Judea. Angkay hiyachi yag wachacha hen naligwat hen achawwéy way fabréy way nan-apet hen cha fùnagan hen init way chicha hen anchichay nan-araeng way cha mangachar hen cha isinyar hen taraw. Angkay inumchahcha ad Jerusalem, henanhanancha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Chuud hen anchi onga way niyanà way man-are an chàyu way Judio, te innilani hen anchi taraw way sinyar hen miyana-ana way fummùnag hen nan-apetan hen cha fùnagan hen init. Wat yachi hen ummaliyannihto ta ini chayawén hiya.” ");
INSERT INTO blw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Angkay hiyachi way chengngar are way Herodchi, ammag naguru way térén hen hamhamàna ya umat agé hen tapen anchichay eJerusalem. ");
INSERT INTO blw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wat hen enkaman Are Herod, empa-ayagna hen amin anchichay anap-apon hen papachin hen Judio ya hen anchichay siguchay cha mintudtuchu hen orchin, yag inimohna an chicha no chuud hen nesosorat way miyana-an hen anchi Cristu way hahadchén hen Judio way umale way mantoray. ");
INSERT INTO blw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yag anchaat ifaga an hiya way mangaliyén, “Ad Bethlehem way sakop hen provinsiyan hen Judea hen miyana-an Cristu te yaha chillu hen ensorat hen anchi profeta ad namenghan way ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hen anchi akettoyay fabréy way Bethlehem way fabréy hen provinsiyan hen Judea, mamfalin peetchi ah kangatowan way fabréy hen aminay fabréy ad Judea, te ahchi hen miyana-an hen anchi man-ap-apo way hiya hen manalimun hen tatagù way ganà Israel.’ Yaha hen nesosorat.” ");
INSERT INTO blw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wat angkay chengngar Herodchi, entat-allingébna way nempa-ayag hen anchichay nangachar hen taraw, yag inimohna an chicha no kamana paat hen ustoy fummùnagan hen anchi taraw. ");
INSERT INTO blw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Angkay imfagacha an hiya yag annaat paligwatén chicha way éméy ad Bethlehem, yag imfagana way mangaliyén, “No éméy-ayuhchi, emamadyu way manganap hen anchi onga ta no ichahanyu, masapor umaleayu way mangimfaga an haén ta éméyà agé way manayaw an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Angkay hiyachi yag naligwatcha way éméy ad Bethlehem. Yag angkay chacha éméy, ammag amchan hen laylayadcha te kasencha innila hen anchi tarawanchi way innilacha hen anchi pés-éy naligwatancha. Wat hen anchi taraw, chana epangpango ah umunuchancha, yag iggayna etàtàchég ingganah nemamang hen ininggawan hen anchi onga. ");
INSERT INTO blw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Angkay hiyachi way inumchahcha hen hiyachiy faréy, hinénggépcha yag innilacha hen anchi onga way ah Jesus yah inana way Maria, yag chachaat mampalentomang way manayaw an hiya. Yag anchaat agé epafùnag hen idchatcha an hiya way pahig nan-angina way faletò ya fangfangru way incienso ya mira. ");
INSERT INTO blw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Angkay hiyachi yag empahelap Apudyus an chicha way achicha engwa ah faréy Herod no mamfangadcha, wat safali hen chinarancha way namfangad ah fabréycha. ");
INSERT INTO blw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Angkay hiyachi way lommayaw hen anchichay nangachar hen taraw, kasen nampàila hen anghel Apudyus an Jose hen nan-in-inpana, yag imfagana way mangaliyén, “Fumangon-ayu ta elayawnowat hen annay onga yah inana te anapén angkay Are Herod hen annay onga ta pédténa. Wat mamfakwit-ayu ad Egipto yag ahchin i-inggawanyu ingganah ifagà hen lomayawanyu.” ");
INSERT INTO blw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yag yachi, fummangon ah Jose yag inligwatna chicha way hen-ina hen hiyachiy lafi way éméy ad Egipto, ");
INSERT INTO blw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","yag anchag ini-inggaw ahchi ingganah natéy hen anchi are way Herod. Na-ammaanchi ah tommot-owaan hen anchi imfafaggan Apudyus ad namenghan way ensorat hen anchi profeta way ekatnéén, “Ayagà hen anào way maligwat ad Egipto.” ");
INSERT INTO blw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Angkay hiyachi way enlasin Are Herod way lenepat peet hen anchichay nangachar hen taraw hiya te safali hen enengwacha, wat ammag ommaningarngar way térén, wat annag inyurchin way mepapchit amin hen ungunga way larae ad Bethlehem ya hen senakopna way fafabréy way hen mepapchitat amin hen anchichay anat niyanà ingganah mantawén ah chuwa, te yachi hen tawnén hen onga nanepod hen nail-an hen taraw way henaphapet hen anchichay nangachar hen taraw. ");
INSERT INTO blw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wat yaha hen tommot-owaan hen enalen hen anchi profetay Jeremias ad namenghan hen nangaryanéén, ");
INSERT INTO blw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Mamagngar hen usengar ad Rama way ammag pararo hen ifil ya kela. Chichachi hen ganà Raquel way chacha ifilan hen anchichay a-anàcha way natéy. Ya ammag maid maka-à-arò an chicha te nan-atéycha hen anchichay a-anàcha.” ");
INSERT INTO blw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Angkay hiyachi way émmé-émméy hen tawén, natéy ah Are Herod yag kasen nampàila hen anchi anghel Apudyus an Jose ad Egipto hen nan-in-inpana way ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Fumangon-ayu agé ta ifangadno chillu cha Maria way hen-ina hen anchi lotayu way Israel, te nan-atéycha hen anchichay manlayad way mamchit hen annay onga.” ");
INSERT INTO blw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Angkay hiyachi, enlayaw tot-owa Jose hen anchi onga yah inana wat namfangadcha chillu ad Israel. ");
INSERT INTO blw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ngém angkay chengngar Jose way ah Arkelao peet hen neparég an amana way Herod way mantoray hen provinsiyan hen Judea, ammag émmégyat way fumabréy ahchi. Wat anat kasen epahelap Apudyus an hiya way hen provinsiyan hen Galilea hen minyapetancha. ");
INSERT INTO blw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wat hiyachi, incha fummabréy hen ihay fabréy ahchi way ekatchéén Nazaret. Yato hen nekaman ah tommot-owaan hen ensorat hen anchichay profeta ad namenghan way ekatchéén, “Ah hamhamà hen tatagu, anchag ekatén hiya hen ihay eNazaret.” ");
INSERT INTO blw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Angkay hiyachi way émméy hen kamanay tawén, wacha hen ihay tagu way hen ngachannaat ah Juan way nangadnan ah chan funfunyag. Émméy hen anchi chanak yag inlugina way mangintudtuchu hen anchichay tatagu way cha ummunud an hiya, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Masapor manchùganyu hen aminay laweng way chayu ammaan, te tég-angay angkay milugi hen mantorayan Apudyus an chitaaw.” ");
INSERT INTO blw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ah Juananto, hiya hen cha aryén hen anchi profeta way Isaias ad namenghan hen nangaryanéén, “Wacha hen anchi ini-inggaw hen anchi chanak way chana èngaèngaw hen anchichay tatagu way mangaliyén, ‘Naway hen Ap-apo, wat iyam-ammayu hen chayu am-ammaan ya manggadngényu hen hamhamàyu.’ ” ");
INSERT INTO blw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Hen lumfong Juananchi way chan funfunyag, wat an lawa ammag enafar way chotchot chi animar way kemér, ya nansesentoron agé ah gadchang. Yag hen chana agé iyatagu wat chuchun ya chilu. ");
INSERT INTO blw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wat ancha ammag cha émé-éméy hen tatagu way mangngar hen chana itudtuchu way narpocha ad Jerusalem ya hen aminay sakopon hen provinsiyan hen Judea, ya anat agé hen amin anchichay fafabréy way nehag-én hen anchi wangwang way ekatchéén Jordan. ");
INSERT INTO blw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yag chacha tot-owa epudnu hen fasorcha ya anat funyagan Juan chicha hen hiyachiy wangwang way Jordan. ");
INSERT INTO blw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ngém hen émméyan hen anchichay nan-angato way Fariseo ya Saduceo an Juan way mampafunyag koma, wachan narasenna yag annaat ifaga an chicha way mangaliyén, “Chàyu way ammag nan-asilib, ay ammoh ekatyuwén hen mafunyaganyu hen manginlisiyanyu hen chusan Apudyus an chàyu. ");
INSERT INTO blw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Te masapor angkay atofunyu paat hen a-ammayu ah mempàil-anyu way imfafawiyu tot-owa hen fasoryu. ");
INSERT INTO blw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yag achiyu agé ekatén gapo ta ganà chàyu an Abraham wat achi chàyu chuséén an Apudyus, te hen ifagà an chàyu, uray hen antochay fatowat mafalin mamfalinén Apudyus chicha ah ganà Abraham no laychéna. ");
INSERT INTO blw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ya hen anchi miyaligan hen manusaan Apudyus hen tatagu wat kaman hen na-a-awid way potaw. Wat aminay away way achi mamunga ah ammayay funga wat marngoh ta ma-apoyan.” ");
INSERT INTO blw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Entoroy Juan way mangaliyén, “Haén, chanum yanggay hen chà ifunyag an chàyu ah mepàil-an hen namfafawiyanyu. Ngém wacha hen meparég an haén way nangatngato way térén no haén te uray lawa anà an man-alepan an hiyéén achì karébféngan. Yag hiya, ifunyagna an chàyu hen Espiritun Apudyus ya hen apoy. ");
INSERT INTO blw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yag no umale, henhenéna hen anchichay ammayay tatagu hen anchichay laweng way kaman hen anchi mantéép way henhenéna hen anchi nafégahan hen anchi maid fégahna. Yag hen anchi nafégahan, tarpénéna ah arangna. Waman hen anchi maid fégahna, etongona hen anchi apoy way ammag achi madmachép.” ");
INSERT INTO blw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Angkay hiyachi yag lummigwat ah Jesus ad Galilea way éméy hen anchi wangwang way Jordan way mampafunyag an Juan. ");
INSERT INTO blw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngém ah Juan, ommachi te ekatnéén, “Ammoh mafalin way haén hen mamunyag an hea way hea koma hen mamunyag an haén.” ");
INSERT INTO blw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngém senongfatan Jesus way mangaliyén, “Tàén wat hea chillu hen mamunyag an haén, te yato hen mangammaanta hen aminay laychén Apudyus.” Yachi yag ommafun ah Juan wat finunyagana ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Angkay hiyachi way nafunyagan ah Jesus, tommàchangat yag ammag namfuat ad uchu yag innilana hen Espiritun Apudyus way cha émhép an hiya way kaman karopate. ");
INSERT INTO blw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yag hen hiyachi agé, wacha hen nan-ale ad uchu way mangaliyén, “Yaton anào way laylaychê paat ya chana agé eparaylayad haén.” ");
INSERT INTO blw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Angkay hiyachi yag enetnod hen Espiritun Apudyus ah Jesus hen anchi chanak ta ahchi hen mamachasan Chumunyu way mangawis an hiya. ");
INSERT INTO blw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wat angkay ini-inggaw ahchi ah opatporoy ag-agaw way ammag iggay nangnangan, wat ammag hommenaang way térén. ");
INSERT INTO blw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yag yachi way ammag amchan hen henaangna, émméy ah Chumunyu way i mangawis an hiya way mangaliyén, “No hea hen tot-oway anà Apudyus paat wat mamfaliném hen antoy fato ah aném.” ");
INSERT INTO blw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yag senongfatan Jesus hiya way mangaliyén, “Nesosorat hen alen Apudyus way ekatnéén, ‘Achi ummat hen ma-an ah iyatagun hen tatagu, te masaporcha agé chillu hen aminay enalen Apudyus ah mataguwancha ah ing-inggana.’ ” ");
INSERT INTO blw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Angkay hiyachi yag inyéy Chumunyu hiya ad Jerusalem way i nangempatùchu hen tabfongan hen anchi faréy Apudyus way ekatchéén Templo. ");
INSERT INTO blw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yag annaat agé ifaga an hiya way mangaliyén, “No tot-owa way anàcha-a an Apudyusat mampêchag-a udpay, te nesosorat met hen anchi alena way ekatnéén, ‘Ifagan Apudyus hen anchichay anghelna ta halimunancha-a wat ancha-ag hèmatén way ammag uray hen he-emat achi mepetag hen anchi fato.’ ” ");
INSERT INTO blw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yag sommongfat agé ah Jesus way mangaliyén, “Oo a, ngém wacha chillu hen nesosorat way alen Apudyus way ekatnéén, ‘Achiyu cha padpachasén hen kafaelan Apudyus way Apoyu.’ ” ");
INSERT INTO blw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Angkay hiyachi way narpas agéchi, inyéy Chumunyu hiya hen ammag akayyang way filig, yag empàilana hen aminay namfinafinab-én way toray hen antoy lota ya hen kaenammaycha. ");
INSERT INTO blw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yag annaat ifaga way mangaliyén, “Idchat-o aminto an hea no an-a mampalentomang way manayaw an haén.” ");
INSERT INTO blw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yag senongfatan Jesus way mangaliyén, “Lomayaw-aat Chumunyu te hen nesosorat chillu hen alen Apudyus way ekatnéén, ‘Ammag maid kasen chayawényu no faén yanggay hen apoyu way ah Apudyus, ya maid agé kasen afurotonyu no faén yanggay hiya.’ ” ");
INSERT INTO blw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hiyachi yag lommayaw tot-owa ah Chumunyu, yag émméycha hen anchichay anghel way i manorong an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Angkay hiyachi way chengngar Jesus way nifarud ah Juan way chan funfunyag, lommayaw way namfangad hen anchi provinsiyan hen Galilea. ");
INSERT INTO blw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ngém iggay inggaw ad Nazaret te nanchakpos ad Capernaum way nehag-én hen anchi fayfay way ekatchéén Galilea way nan-apet hen sakopon hen Zabulon ya Neftali. ");
INSERT INTO blw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yachi hen nekaman ah tommot-owaan hen enalen hen anchi profeta way Isaias ad namenghan hen nangaryanéén, ");
INSERT INTO blw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Matorongancha hen anchichay tatagu ad Zabulon yad Neftali way fafabréy hen chumang hen anchi wangwang way Jordan way nan-apet hen anchi fayfay way chicha hen anchichay faén Judio way ini-inggaw hen anchi provinsiyan hen Galilea. ");
INSERT INTO blw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hen cha nadchiy tatagu, kamancha ini-inggaw hen helang te ammag nahehellangan hen hamhamàcha gapon fasorcha, yag yachi agé hen nesenaancha an Apudyus. Ngém ammay ad uwan te cha mahelawan hen hamhamàcha te inumchah hen anchi napegsay Helaw an chicha.” ");
INSERT INTO blw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yag nanepod hen hiyachi, inlugin Jesus way manginwarawag hen itudtuchuna, ekatnéén, “Masapor etagayyu hen annay laweng way a-ammayu te tég-angay hen milugiyan hen mantorayan Apudyus an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Angkay hiyachi way cha manaran ah Jesus hen penget hen anchi fayfay way Galilea, innilana hen chuway hen-agi way cha Simon way mamPedro yah Andres way chacha manafukor te mangagadchiwcha chillu. ");
INSERT INTO blw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yachi yag imfagan Jesus an chicha way mangaliyén, “Ehàfayu chaha ta metnod-ayu an haén ta falewà hen hiyahay chunuyu ta hen tatagu hen atenglényu ah omafurotancha an haén.” ");
INSERT INTO blw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wat enhàfacha tot-owa hen anchi tafukorcha yag netnodcha an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Angkay nànàéycha yag innilan Jesus hen kasen hen-agi way cha Jaime an Juan way nìtutùchucha an amacha way Zebedeo hen anchi fangkacha way chacha taramanén hen tafukorcha. Yachi yag enayagan Jesus chicha agé. ");
INSERT INTO blw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wat anchag tenaynan ah amacha ya hen anchi fangkacha way netnod an cha Jesus. ");
INSERT INTO blw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Angkay hiyachi, cha émé-éméy ah Jesus hen kafabréfabréy hen provinsiyan hen Galilea way cha i mantudtutudtuchu hen anchichay chacha ma-am-amongan way Judio way ekatchéén sinagoga way yachi hen chana minwarawagan hen anchi ammayay chamag mepanggép hen mantorayan Apudyus. Ya chana agé etape way manga-an hen anchichay namfinafinab-én way saket ya ligat hen tatagu. ");
INSERT INTO blw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yachi yag ammag nanhemamag hen mepanggép an hiya hen aminay fabréy hen anchi lota ad Siria, wat hen anchichay tatagu, inyéycha an hiya amin hen anchichay chan saket way namfinafinab-én hen ligatcha, te wachacha hen anchichay nahurugan ya hen chan orchah ya umat agé hen anchichay napàroy hen acharna. Yag cha natto way ligatat ammag kena-an Jesus amin. ");
INSERT INTO blw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wat hiyachi, chuarcha hen anchichay tatagu way cha umunu-unud an hiya way narpon provinsiyan hen Galilea ya Judea ya anat ad Decapolis ya ad Jerusalem ya umat agé hen anchichay fabréy way chumang hen anchi wangwang way Jordan. ");
INSERT INTO blw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Angkay hiyachi way innilan Jesus hen anchi ammag chuar way tatagu, émméy hen anchi tagéytéy yag tummùchu wat enamongan hen anchichay pasorotna hiya. ");
INSERT INTO blw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yag annaat tudtuchuwan chicha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Lomaylayad-ayu, chàyu way maka-awat way maid kafaelanyu way mangamma hen ammayén Apudyus no achi chàyu torongan an hiya, te chàyu hen metape hen mantorayana.” ");
INSERT INTO blw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Lomaylayad-ayu agé, chàyu way chan totokar gapon anchi cha ma-ammaan way laweng, te ah Apudyus hen mangemparaylayad an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Lomaylayad-ayu, chàyu way cha mangempafafa hen acharna, te idchat Apudyus an chàyu hen anchichay empopostana.” ");
INSERT INTO blw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Lomaylayad-ayu agé, chàyu way maid kasen laychéna no faén yanggay hen laychén Apudyus, te totollongan Apudyus chàyu way mangamma an cha nahha ah kapnekanyu.” ");
INSERT INTO blw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Lomaylayad-ayu agé, chàyu way cha manég-aség-ang ah ifana, te séség-angan chàyu agé an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“An-ayu agég lomaylayad, chàyu way cha mangamma hen laychén Apudyus way nacharos chi pontosna, te ilanyu ah Apudyus ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Lomaylayad-ayu agé, chàyu way cha manginyornos hen katornosan hen tatagu, te ifilang Apudyus chàyu ah anàna.” ");
INSERT INTO blw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Lomaylayad-ayu agé, chàyu way cha mapap-aligatan gapon chayu mangammaan hen laychén Apudyus, te etapena chàyu hen mantorayana ad uchu.” ");
INSERT INTO blw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“An-ayu ammag lomaylayad yanggay no insortuwén chàyu ya paligatén chàyu ya ustan chàyu hen anchichay tatagu gapon sommorotanyu an haén. ");
INSERT INTO blw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Uray no yaha hen ammaancha an chàyu, an-ayu yanggay ammag lomaylayad chillu, te chakar hen gunggunayu ad uchu. Yag yaha agé chillu hen nekaman hen anchichay profetan Apudyus ad namenghan.” ");
INSERT INTO blw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yachi yag entoroy Jesus hen chana itudtuchu, ekatnéén, “Hen ahin hen mangempa-ammay hen missa. Wat chàyu, kaman-ayu agé ahin te chàyu hen cha mangintudtuchu hen omammayan hen tatagu hen antoy lota. Ngém non an umat way maka-an hen anchi paket hen ahin, ay ammoh mafalin way papaketém kasen. Achi met, te ammag metap-ar yanggay way gategatenan hen tatagu te maid chillu sérfina.” ");
INSERT INTO blw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yag chàyu agé hen kaman helaw way manelaw hen hamhamà hen aminay tatagu hen antoy lota. Hen miyaligana, kaman-ayu hen ihay fabréy way ininggaw hen tagéytéy way mamàila way achi mafalin way malenglengfan. ");
INSERT INTO blw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ya maid agé tatagu ah mamasgéd ah helaw yag henàufana, te no pasgéchana, anna an epatang ta mahelawan hen aminay wachah faréy. ");
INSERT INTO blw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wat kaman agéhchi koma hen homelawanyu ah mangil-an hen tatagu, te hen mangil-ancha hen anchi ammay way chayu ammaan, yachi hen manayawancha an Apudyus way Amataaw ad uchu.” ");
INSERT INTO blw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yachi yag entoroy Jesus agé way mangaliyén, “Achiyu ekatén anà ummale way an mamakas hen anchichay orchin way ensorat Moses ya hen intudtuchun hen anchichay profeta, te hen ganchat-o paat way ummaliyat ah tomot-owaan hen imfagan hen amin anchichay nesosorat way orchin. ");
INSERT INTO blw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yag tot-owa hen antoy ifagà way achi mafalin miyat-atob hen anchi orchin Apudyus. Te uray mamaid hen antoy lota yad uchu, achi chillu mamaid hen uray anchi ka-ak-akettoyan way orchin ingganah ma-ammaan amin. ");
INSERT INTO blw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wat hiyachi, heno way manlabseng hen anchi uray kafafaan way lentég yag yachi agé hen itudtuchuna hen tapena, wat hiya hen mifilang ah kafafaan hen mantorayan Apudyus. Ngém heno way mangafurot amin hen anchi orchin Apudyus yag yachi agé hen itudtuchuna hen tapena, wat hiya hen mifilang ah nangato hen anchi mantorayana. ");
INSERT INTO blw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngém hen ifagà an chàyu, achiayu angkay metape hen mantorayan Apudyus no achiyu ammaan hen laychéna, te achi ummat hen cha ekaman hen anchichay Fafariseo ya hen anchichay siguchay cha mintudtuchu hen anchi orchinanchi. Wat masapor wadwadcha hen ekamanyu no hen chacha ekamkaman.” ");
INSERT INTO blw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Innilayu way nanepod ad namenghan, nitudtuchu an chitaaw hen anchi orchin way ekatnéén, ‘Achiayu cha pomatéy te hen anchi pomatéy, mauwis yag nachusa.’ ");
INSERT INTO blw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngém hen ifagà an chàyu ad uwan, uray hen anchi ammag an omaningarngar ah ifana wat mauwis angkay agé. Ya hen anchi mameloh ah ifana, ammag michérém hen anchichay nan-angato way konsel. Ya hen anchi tagu way mangaleh ifanéén, ‘Heaat ammag maid sérsérfim,’ hen anchi nangalehchi wat lébféngna way metap-ar hen anchi apoy ad imférno. ");
INSERT INTO blw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Wat hiyachi, no wachay cham iyéy hen Templon Apudyus ah ekatnowén ichatonno an hiya, yag hemhemmàno way wacha uwa hen lawengén hen anchi ifam an hea, ");
INSERT INTO blw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","annog man-ehàfa unna hen anchi ekatnowén ichatonno ta éméy-aat way i mètagépfar hen ifamanchi ta manchinnaros-ayu unna. Yag no narpaschi, yachin mangentoroyam way manginchaton hen anchi ekatnowén ichatonno an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Yag mag-ay ta wachay manginchérém an hea, éméy-a an hiya unna way mètagépfar ta no mafalin, achia koma mepasango hen uwis. Te no loohcha-a epasango hen uwis, awni yag idchatna hea hen anchi poles yag imfarudcha-a. ");
INSERT INTO blw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wat maid angkay meparufusam hen pagfaruchan ingganah fayacham amin hen anchi mortam.” ");
INSERT INTO blw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Innilayu agé hen anchi nitudtuchu way ekatnéén ‘Achiayu cha chumagchagas.’ ");
INSERT INTO blw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngém hen ifagà an chàyu ad uwan, heno way tagu way mangila ah fufae yag hemhemmàna way manòyong, chummagchagaschi ah hamhamàna. ");
INSERT INTO blw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wat hiyachi, no oma-annig hen ilan hen matayu ah chayu fumasoran, un-unnina no okatényu yag entap-aryu. Te un-unnina angkay hen makorangan hen achar no hen wacha amin yag ad imférno hen metap-aranyu. ");
INSERT INTO blw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yag no oma-annig agé hen cha ammaan hen limayu ah chayu fumasoran, un-unnina no porhanyu yag entap-aryu. Te un-unnina angkay way an makorangan hen lima no hen anchi wacha amin yag ad imférno hen iggawanyu.” ");
INSERT INTO blw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Siguchay nitudtuchu an chitaaw way no ihiyan hen larae hen ahawana, masapor idchatna an hiya hen papel way mangempàila hen manhiyanancha. ");
INSERT INTO blw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngém hen ifagà an chàyu ad uwan, heno way larae way manginhiyan an ahawana, fasornachi, manongad no an chummagchagas hen anchi ahawana. Fumasor te chana ammaan hen chumagchagasan hen anchi inhiyanna no kasen mangahawa, te faén chillu ahawana hen anchi kasenna ahaw-én te chagchagasnachi. Ya umat agé hen anchi nangahawa an hiyaat anna agé an chinagchagas.” ");
INSERT INTO blw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Innilayu agé way nanepod ad namenghan, intudtuchun hen anchichay anap-otaaw way ekatchéén, ‘Achiyu cha labsengén hen empostayu te masapor ammaanyu way ammaan hen heno way ensapatayu an Apudyus.’ ");
INSERT INTO blw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Ngém hen antoy ifagà an chàyu ad uwan, achiayu chan sapsapata ah uray heno way epostayu. Achiyu ammag ekatén meorob ad uchu ya hen antoy lota no faén tot-owa hen enaleyu, te ad uchu, yachi hen tummutùchuwan Apudyus, ya hen antoy lota, yato hen kaman pommapattangana. Ya achiyu agé esapata hen anchi fabréy way Jerusalem way machachael agé no faén tot-owa hen enaleyu, te hen hiyachiy fabréy hen fumaryan hen anchi kangatowanay Are. ");
INSERT INTO blw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ya achiyu agé cha esapata way pomokaw hen fuùyu no faén tot-owa hen enaleyu, te ay ammoh kafaelanyu way mangempapokaw ya mangempangétég hen uray himféras way fuùyu. ");
INSERT INTO blw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wat hen ekamanyu, anyu yanggay ammag ekatén, ‘Oo’ no oo, ya ‘achi’ no achi. Te no taptapyanyuchi, ah Chumunyu angkay hen narpowan hen anchi entaptapeyu.” ");
INSERT INTO blw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Innilayu agé hen anchi nitudtuchu an chitaaw way ekatnéén, ‘Heno way tagu way manachael hen matan hen ahentaguna, masapor machachael agé hen matana. Yag heno way tagu agé way manachael hen fub-an hen ahentaguna, masapor machachael agé hen fub-ana.’ ");
INSERT INTO blw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngém hen ifagà an chàyu ad uwan, achiayu cha fumab-arés ah uray heno way ma-ammaan an chàyu. Wat no wachay manappet hen apengyu, uray etayayu hen anchi chumangna ta tappeténa agé. ");
INSERT INTO blw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yag no wachay manginchérém an chàyu yag menortana chàyu ah ihay lumfong, uray iyuyayu agé hen anchi agwana. ");
INSERT INTO blw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yag no wacha agé hen mangempapelet way mempachén hen kargana ah ihay lometor, uray icharanyu ah chuway lometor. ");
INSERT INTO blw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Adchanyu hen anchichay chan ochaw an chàyu, ya pafuruchanyu agé hen anchichay cha fumurud an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Innilayu hen anchi nitudtuchu way ekatnéén, ‘Masapor laylaychényu hen ifayu yag hen anchi gumura an chàyu, guréényu agé.’ ");
INSERT INTO blw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngém hen ifagà an chàyu ad uwan, masapor epàilayu hen layadyu hen anchi uray gumura an chàyu, ya masapor agé iluwaruwanyu hen anchi cha mamaligat an chàyu. ");
INSERT INTO blw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Te no yahan ammaanyu, cha-ayu komaman an Amataaw way Apudyus ad uchu. Te hiya, eparufusna hen uminitan hen init ah pagsaya-atan hen aminay tatagu way uray hen anchichay laweng ya hen anchichay ammay. Yag umat agé hen uchan, idchatna ah pagsaya-atan agé hen aminay tatagu way uray hen anchichay mangamma hen laweng ya hen anchichay mangamma hen ammay. ");
INSERT INTO blw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Te ay ammoh gunggunaan chàyu an Apudyus no ammag hen anchi yanggay manlayad an chàyu hen laylaychényu. Achi angkay, te uray hen anchichay cha mangam-among hen furor way chan lokop wat chacha met ammaan chaha. ");
INSERT INTO blw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ya maid agé manlahyanyu no anggay hen anchichay ifayu yanggay hen chayu tagépfarén, te uray hen anchichay achi omafurot wat chacha met ammaan chaha. ");
INSERT INTO blw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Masapor usto paat hen ekamanyu way kaman hen kenauston hen cha ekaman Amataaw way Apudyus ad uchu.” ");
INSERT INTO blw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Entoroy Jesus way mantudtuchu, ekatnéén, “Ar-arwachanyu ta faén ah mangil-an hen tatagu hen chayu mangammaan ah ammay. Te no hen machayawanyu yanggay hen mangammaanyu hen ammay, maid angkay idchat Amataaw way Apudyus ah gunggunayu ad uchu. ");
INSERT INTO blw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Wat no wachay idchatyu ah etorongyu hen anchi makasapor ah torong, achiyu koma ammag eparangchi hen kachùran hen tatagu way kaman hen cha ekaman hen anchichay senang a-afurot way éméycha hen anchi sinagoga way chacha ma-am-amongan ya hen korsa way mangempadpadcha hen chacha ammaan ah machayawancha. Tot-owa hen antoy ifagà an chàyu way ammag nanarpas angkay hen aminay gunggunacha. ");
INSERT INTO blw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngém chàyu, hen ekamanyu koma, no wachay idchatyu ah etorongyu, ilanyu ta uray hen anchi gayyémyu paatén achina koma changchangrén way wachan inidchatyu, ");
INSERT INTO blw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta anyu an etat-allo way mangidchat. Wat ah Amataaw way Apudyus way mangi-ila hen egachay achi maila, idchatna hen gunggunayu.” ");
INSERT INTO blw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“No manluwaruayu, achiyu torachén hen cha ekaman hen anchichay senang a-afurot way incha tomatàchég way manluwaru hen anchi chacha ma-am-amongan ya hen penget hen korsa ah an yanggay mangil-an hen tatagu an chicha. Tot-owa hen antoy ifagà an chàyu way ammag nanarpas angkay hen aminay gunggunacha. ");
INSERT INTO blw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngém chàyu, no manluwaruayu, yato hen ekamanyu, éméy-ayu ah faréy yag nan-énéb-ayu ta achiayu maila way manluwaru an Amataaw way Apudyus way achi agé maila. Yag ah Apudyus way makaila hen egachay achi maila, idchatna hen gunggunayu ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ya no manluwaruayu agé, achiyu ammag ar-arkosan way mangempa-anchu hen luwaruyu way kaman hen cha ekaman hen anchichay maid afurotna te chicha, ekatchéén changrén ano Apudyus chicha gapon kena-anchun hen luwarucha. ");
INSERT INTO blw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Achiyu torachén hen chacha ekaman way manluwaru, te ah Amataaway Apudyus, inni-ilana chillu hen masaporyu uray hen cha-anyu mangimfag-an. ");
INSERT INTO blw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wat yato hen ekamanyu way manluwaru. “‘Amani ad uchu, ta machachayaw hen ngachanno. ");
INSERT INTO blw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ya ta umchah koma hen mantorayam. Ya ta ma-ammaan agé hen laychém hen antoy lota way kaman agé ad uchu. ");
INSERT INTO blw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Idchatno hen man-érégnah anénni ah ka-ag-a-ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ya pakawaném agé chàni hen anchi laweng way enammaanni way kaman hen chani mamakawanan hen anchichay nangamma hen laweng an chàni. ");
INSERT INTO blw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ya achim koma eparufus hen ma-awisanni way achini makaya ya torongam agé chàni ta achi chàni lokopon an Chumunyu.’ ” ");
INSERT INTO blw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Entoroy Jesus way mangaliyén, “No pakawanényu hen anchi nangamma ah laweng an chàyu, pakawanén agé chàyu an Amataaway Apudyus ad uchu. ");
INSERT INTO blw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngém no achiyu pakawanén chicha, achi chàyu agé pakawanén an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“No manlangan-ayu way mangan gapo hen manluwaruwanyu an Apudyus, achiyu ammag epàpàila way cha-ayu manhenaang way kaman hen cha ekaman hen anchichay senang a-afurot. Te chicha, iyanggayancha hen acharcha ah mangil-an hen tatagu way chachan langan. Tot-owa hen antoy ifagà an chàyu way ammag nanarpas angkay hen aminay gunggunacha. ");
INSERT INTO blw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngém chàyu, no manlangan-ayu, manchar-op-ayu ya mansasaggaysay-ayu ");
INSERT INTO blw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta maid makelasin ah tatagu way cha-ayu manlangan, ta anggay ah Amataaw way Apudyus ah mangammu. Wat ah Apudyus way achi maila, i-illana chillu hen aminay netataro way na-ammaan, wat idchatna hen gunggunayu ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Achiyu ammag patpatigén hen fumaknanganyu hen antoy lota way cha mangamoamong hen egad, te amin cha nahha wat machachaelcha chillu te ancha yanggay ammag maropà ya mabfufù ya mafalin amin akawén hen mangakaw. ");
INSERT INTO blw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ta hen ekamanyu komaat patpatigényu paat hen anchi laychén Apudyus ta hiya hen mangentarpén hen tot-oway kafinaknangyu ad uchu. Te ahchi, ammag maid makachachael ya maid agé maka-akaw. ");
INSERT INTO blw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ya ah kenatot-owana agé, heno way patpatigényu, kapeletan way yachi hen haham-ényu.” ");
INSERT INTO blw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yachi yag nampani ah Jesus way mangaliyén, “Hen mata, hiya hen helaw hen achar. Wat no iggay nakorafuwan hen mata, nahehellawan hen aminay achar. ");
INSERT INTO blw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngém no nakorafuwan hen anchi mata, ammag helang hen achar. Hiyachi, no helang hen anchi karpowan koma hen omenpapaway, ammag pararo tot-owa hen ngéngét hen achar. Hen miyaligana, no usto hen patigén paat hen hamhamà, achita mèfat. Ngém no nat-én hen patigén hen hamhamà, ammag pararo hen mèfatan.” ");
INSERT INTO blw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Maid tatagu ah mafalin chuwa hen omapowana te kapeletan way laylaychéna hen iha yag achina laychén hen iha. Ya pelet way afurotona agé hen iha ya achina agé hen anchi iha. Pachongna agé an Apudyus ya hen pelak, te no ammag hen pelak hen napatpateg an hea, achi mafalin way patigém hen laychén Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Wat yato hen ifagà an chàyu. Achiayu machanagan hen mepanggép hen iyataguyu way anényu ya ilumfongyu, te ay ammoh faén wadwadcha hen ataguwanyu no hen anényu, ya hen acharyu no hen ilumfongyu. ");
INSERT INTO blw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilanyu ngén hen anchichay kasole way ancha lawag chan tat-ayap way achichan mura ya mamfatà ya maid agé chacha etarpén ah usaréncha. Yag pakay chacha chillu matagu nò. Oo, te ah Amataaw ad uchu hen cha manalimun an chicha. Wat ay ammoh achi kaskasen hen hamhamàna an chàyu no hen kasole. ");
INSERT INTO blw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ya maid chillu etorong hen chanag te tàén machachannagan-ayu, ay ammoh pa-anchuwén lawa hen anchi chanagyu hen ataguwanyu ah uray ihay uras.” ");
INSERT INTO blw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ya pakay agé cha-ayu machanagan ah ilumfongyu. Te ilanyu ngén hen anchi charoh way cha lomtà. Achicha met chan amma ya man-afar ");
INSERT INTO blw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ngém hen ifagà an chàyu, anam-ammay chillu hen sabsafongcha no hen anchi ka-a-ammayan way cha inlumfong hen anchi kafafaknangan way are way Solomon. ");
INSERT INTO blw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wat no yaha hen ekaman Apudyus way mangempa-ammay hen charoh way uray wacha ad uwan, ammag màrong ah wakas yag nahèlan, ay ammoh achi kaskasen hen hamhamàna ah ilumfongyu way tatagu. Ammag korang peet hen pammateyu.” ");
INSERT INTO blw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Wat hiyachi, achiayu koma machanagan mepanggép hen anényu ya hen ilumfongyu, ");
INSERT INTO blw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","te chichachi hen ammag cha ham-éham-én hen anchichay pagano. Ngém chàyu, inni-ilan chillu Amataaw ad uchu way masaporyu amin chaha. ");
INSERT INTO blw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Isonga hen haham-ényu koma, wat mepanggép hen mantorayan Apudyus ya anat hen ekamanyu way mangamma hen laychéna. Te no hiyachi hen patpatigényu, egad hiya way manmanmà hen masapor hen acharyu.” ");
INSERT INTO blw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Ya achiayu agé machanagan mepanggép hen mepasamak ah wakas te para agé ah wakas ya anat ma-ammaan cha nadchi. Te pakay inyu héphépén hen anchi ligatyu ad uwan ta inyu etape hen ligat para ah wakas.” ");
INSERT INTO blw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Entoroy Jesus way mantudtuchu, ekatnéén, “Achiyu ammag pafasoron hen tapena wat achi chàyu agé pafasoron an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Te hen chayu ekaman hen tapena, kaman agéhchi hen ekaman Apudyus an chàyu. Wat amin way ekamanyu hen ahentaguyu, yachi agé hen ekaman Apudyus an chàyu. ");
INSERT INTO blw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hen miyaligana, narawag hen mangil-anyu hen uray aginnà way finutan hen ifayu yag achiyuwat agé elasin way wachan liniéy way nampopoggar ah matayu. Te pakay paat chayu aryéaryén hen akettoy way fasor hen tapena yag anyug achi cha elasin hen chakar way fasoryu. ");
INSERT INTO blw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ay ammoh mafalin ekatnowén, ‘Ayé ta ka-anê hen annay aginnà way finutam’ yag wà-achaat peet hen liniéy ah matam. ");
INSERT INTO blw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Anyug cha pap-arangén hen kaenammayyu. Wat masapor ka-anényu unna hen annay liniéy ah matayu ta lomawag hen mangil-anyu way manga-an hen finutan hen ifayu.” ");
INSERT INTO blw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Achiyu ammag cha epagngapagngar hen alen Apudyus hen anchichay tatagu way ammag térénay achi manlayad way mangngar. Hen miyaligana, kaman hen aho, te uray adchan hiya hen anchi ka-ammayan, fangtén chàyu chillu. Ya achiyu agé cha idchat hen anammay way haleppon hen fafuy, te anchag iwa-at yag inchayachayahchahcha.” ");
INSERT INTO blw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“No wachay masaporyu, chawatényu an Apudyus wat idchatna. Ana-anapényu hen anchi chayu anapén wat ichahanyu. Mankogkokogkog-ayu hen anchi hawang wat mafùtan an chàyu. ");
INSERT INTO blw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Te aminay manchawat an Apudyusat wacha hen midchat an hiya, ya hen anchi cha manganap ah anapéna, wat wachan ichahana. Ya umat agé hen anchi chan kogkokogkog, mafùtan hen anchi hawang an hiya. ");
INSERT INTO blw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hamham-ényu ngén te uray chàyu way anam-ama, no mamfaga hen anàyu ah ma-an, ay ammoh fatowat agé hen idchatyu. ");
INSERT INTO blw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yag no mamfaga agé ah gachiw, ay ammoh farakkan agé hen idchatyu. ");
INSERT INTO blw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Isonga, chàyu way menangfasor way tatagu, no innilayu way mangidchat hen ammay hen a-anàyu, ay ammoh achi kaskasen hen ekaman Amataaw ad uchu way mangidchat hen ammay hen anchichay chan chawat an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Hen heno way laychényu way ammaan koma hen tatagu an chàyu, yachi agé hen ammaanyu an chicha, te yaha chillu hen pontos hen aminay inyurchin Moses ad namenghan ya hen intudtuchun hen anchichay profeta.” ");
INSERT INTO blw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Engwayu paat hen anchi nalepet way hawang ta faén hen anchi narawa, te hen ayan hen anchi naraway hawang wat ad imférno. Yag gapo ta naraka hen hiyachiy charan, wat chuarcha hen mangéy. ");
INSERT INTO blw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ngém gapo ta nalepet hen anchi hawang way éméy ad uchu ya naligat agé hen hiyachiy charan, wat aketcha yanggay hen mangéy.” ");
INSERT INTO blw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ar-arwachanyu hen anchichay tatagu way ah kenasilibcha, ekatchéén alen Apudyus ano hen chacha itudtuchu yag faénat agé. Te ah kail-ana, na-anohcha, ngém ah katot-owana, ancha i chachaelén hen afurotyu. ");
INSERT INTO blw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Maelasinyu chicha te hen anchi chacha ekamkaman wat yachi hen mangimfaga hen kenatatagucha way hen kepaniyana, kaman hen pagat way achi mafalin mamunga ah pagéy. Ya hen tùfu, achi agé mamunga ah ma-an. ");
INSERT INTO blw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ya hen iha, amin hen ammayay away wat ammay agé hen ifungana. Waman hen anchi laweng way away, laweng hen ifungana. ");
INSERT INTO blw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Te maid ammay ah marpo hen laweng, yag maid agé laweng ah marpo hen ammay. ");
INSERT INTO blw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yag hen anchi away way achi mamunga ah ammayay funga, ammag marngoh ta metongo. ");
INSERT INTO blw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yachi, hen mangenlasinanyu hen anchi ustoy mangintudtuchu ya hen faén, wat hen anchi a-ammacha.” ");
INSERT INTO blw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Entoroy Jesus way mantudtuchu, ekatnéén, “Chuarcha hen tatagu way mìya-apo an haén, ngém achicha angkay amin makaghép hen mantorayan Apudyus, te hen metape yanggay wat hen anchichay cha mangamma hen laychén Amataaw ad uchu. ");
INSERT INTO blw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wat no umchah hen anchi ag-agaw way manguwisan Apudyus hen tatagu, lonaycha hen mampaségség-ang an haén way mangaliyén, ‘Apo, Apo, paghépém chàni te gapon kafaelam wat chani intudtuchu hen mepanggép an Apudyus, ya chani amin emparyaw hen anchichay nihurug way ongtan, ya enammaanni agé hen chuar way kaskascha-aw, wat paghépém paat chàni.’ ");
INSERT INTO blw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngém hen esongfat-o an chicha, ekat-owén, ‘Chàyu way nangéttém, maid angkay chillu innilà an chàyu wat lomayaw-ayuwat te laweng-ayu.’ ” ");
INSERT INTO blw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Heno way tagu way cha mangngar hen antochay chà ifaga yag chana ammaan, wat kaman hen anchi naham-an way tagu way senà-adna hen faréyna hen fato. ");
INSERT INTO blw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wat uray no cha umuchauchan ya chan churuchurun hen wangwang ya cha fumalifali, achi chillu meorob hen anchi faréyna te kénég hen anchi fato way nanà-achana. ");
INSERT INTO blw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Waman hen anchi tagu agé way cha mangngar hen antochay chà ifaga yag achina chillu ammaan, wat kaman hen anchi nawéngwéng way tagu way ammag hen anchi paginahar hen nanà-achana hen faréyna. ");
INSERT INTO blw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yag angkay hiyachi way cha umuchauchan yag nanchurun hen wangwang ya cha fumalifali, ammag neorob hen anchi faréyna way ammag maid poros nehàfa.” ");
INSERT INTO blw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Angkay hiyachi way narpas hen nangaryan Jesus amin an cha natto, ancha ammag nahahaang way térén hen anchichay na-a-among way tatagu gapon enkamanna way nantudtuchu. ");
INSERT INTO blw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Te hen enkamanna, faén hen cha ekaman hen anchichay siguchay cha mintudtuchu hen orchin te maila way wachan karébféngana way mantudtuchu. ");
INSERT INTO blw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Angkay hiyachi way nan-éhég ah Jesus hen anchi tagéytéy way nantudtuchuwana, chuarcha hen tatagu way cha umunud an hiya. ");
INSERT INTO blw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yag hen hiyachi, wachan ihay tagu way nakkonet hen acharna, yag émméy an Jesus way nampalentomang hen henagongna way mangaliyén, “Apo, afurotò way kafaelam way manga-an hen antoy saket-o wat ka-asiyam koma haén.” ");
INSERT INTO blw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yachi yag tenchà Jesus hiya way mangaliyén, “Oo, ka-asiyà hea, wat maka-an hen annay saketno.” Yag hen hiyachi naka-anat tot-owa hen anchi aggarémha way saketna. ");
INSERT INTO blw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yag anat téngténgén Jesus hiya way mangaliyén, “Masapor achim paat cha haphapetén ah uray heno way tagu hen antoy enammaà an hea, ngém éméy-aat ta in-a mampàila hen anchi pachi ta ilana way naka-an hen anchi saketno yag an-aat manchaton an Apudyus hen anchi inyurchin Moses way michaton ah manot-owaan hen tatagu way naka-an hen hiyahay saket.” ");
INSERT INTO blw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Angkay narpaschi, émméy ah Jesus ad Capernaum yag hen anchi échahna, wachan ihay faén Judio way eRoma way kapetan hen sorchachu, yag ina hinib-at ah Jesus way chan pangpanga-ase way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apo, wachan anchi alepan-o ah faréyni way ammag amchan hen saketna way achi amin makaì-iwi, wat ammag napàgangay térén.” ");
INSERT INTO blw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yag anat ekat Jesus an hiyéén, “Wat no yaha, umaliyà ah faréyyu way i manga-an hen saketna.” ");
INSERT INTO blw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Apo,” way ekat hen anchi kapetan, “achi ménat masapor umalea ah faréyni te chaà mafiinan way manmangili an hea. Wat uray ud-ay annog iyale wat maka-an hen saketna. ");
INSERT INTO blw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Te kaman an haén way masapor afurotò hen aryén hen apò. Yag hen anchichay sorchachu way chà etorayan, afurotoncha agé hen aryê, te no ekat-o hen ihéén ‘in-a’ wat éméy, yag no ekat-owén ‘umalea’ wat umale agé. Ya umat agé hen anchi alepan-o, no ekatowén ‘ammaamto’ wat ammaana agé. Wat kaskasen a, way ma-ammaan hen aryém te wachan kafaelam.” ");
INSERT INTO blw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ammag nahaang ah Jesus hen nangngaranan nadchi, yag annaat ekat hen anchichay tatagu way cha umunud way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way maid inchahà ah afurot an chitaaw way ganà Israel ah kaman hen afurot nahhay tagu. ");
INSERT INTO blw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Wat tot-owa hen ifagà an chàyu way chuarcha angkay hen anchichay faén Judio way marpo hen karotarota way i mèlagsak an cha Abraham an Isaac yah Jacob hen anchi mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Waman hen anchichay Judio paat way penelen Apudyus way mètape koma hen mantorayana, kachùran an chicha hen metap-ar hen anchi iggaw hen pararoy helang way ahchi, magénén mankelacha ya manngangalitféncha hen fub-acha ah kaligatna.” ");
INSERT INTO blw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yachi yag, anat ifagan Jesus hen anchi kapetan way mangaliyén, “Wat no hiyaha, homàyat-a te hen anchi afurotom way ma-ammaan an chàyu wat na-ammaanat ad uwan.” Yag tot-owa, te hen hiyachi, naka-anat hen saket hen anchi alepanna. ");
INSERT INTO blw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Angkay hiyachi yag émméy ah Jesus ah faréy cha Pedro yag innilana hen anchi atogangan Pedro way iné-émfég te chan saket. ");
INSERT INTO blw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Wat ina tenchà hen limana yag naka-anat hen saketna, wat fummangon way hiyaat agé hen i nan-alekatto way mamangan an cha Jesus. ");
INSERT INTO blw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yag hen hiyachi agéy lafi, inyéy hen tatagu an Jesus hen chuaray nan-ahurugan ah ongtan. Wat anggay hen man-aryanéén lommayawcha hen anchichay nihuhurug way ongtan, yag kena-an Jesus agé hen saket amin hen anchichay chan sasaket. ");
INSERT INTO blw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Enammaana amin chachi ah tomot-owaan hen enalen hen anchi profeta way Isaias ad namenghan hen nangaryanéén, “Hiyaat kena-anna hen aminay sakettaaw yag finnéhna hen ligattaaw.” ");
INSERT INTO blw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Angkay hiyachi way innilan Jesus hen anchichay chuaray tatagu way cha mangamoamong an hiya, imfagana hen anchichay pasorotna ta éméycha amin hen chumang hen anchi fayfay. ");
INSERT INTO blw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yag hen hiyachi, ummaliyat agé hen ihay siguchay cha mintudtuchu hen orchin, yag imfagana an Jesus way mangaliyén, “Apo, umu-unnuchà angkay an hea hen uray heno way ayam.” ");
INSERT INTO blw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Senongfatan Jesus way mangaliyén, “Hen motet, wacha hen orobna ah omanamotana ya hen kasole, wacha agé hen hòfotna ah omanamotana. Ngém haén way Pangorowan hen Tatagu, maid angkay faréy-o ah omanamotà. Wat ay umunud-a chillu.” ");
INSERT INTO blw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yachi yag wacha agé hen ihay pasorot Jesus way mangalen hiyéén, “Apo, awni kayya ah hen-aketan ta ana-at somorot an hea, ta iyà koma mìlufù an Ama unna.” ");
INSERT INTO blw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yag ekat Jesus an hiyéén, “Umunud-aat an haén ta hen anchichay maid afurotna way kaman nanattéy an Apudyus, egadcha way i manginlufù hen anchi kapachongcha way natéy.” ");
INSERT INTO blw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Angkay hiyachi yag hinénggép cha Jesus ya hen anchichay pasorotna hen anchi fangka ta gumchangcha hen anchi fayfay. ");
INSERT INTO blw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yag angkay cha éméy hen anchi fangka, inluginaat agé way fumali way ammag séréd. Wat cha hàfongan hen chanum hen anchi fangka yag tég-angay malihéd. Ngém ah Jesus, ammag nanasséy. ");
INSERT INTO blw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wat i finangon hen anchichay pasorotna hiya way mangaliyén, “Apo, homarà-a te antoy maofortaaw.” ");
INSERT INTO blw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nanlèna ah Jesus yag ekatnéén, “Pakay ammag pararo hen égyatyu. Ay ammoh achiyu peet chillu manchinlan haén.” Yachi, fummangon yag menancharna hen anchi fali ya hen anchi chanum ta guminangcha, wat nafég-as hen anchi fali yag ommalenanà hen anchi fayfay. ");
INSERT INTO blw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yag anchichay pasorotna, ancha ammag nahahaang way mangaliyén, “Heno ay paat hen katatagun nattowa, way magénén uray hen fali ya chanumén enafurotcha hiya.” ");
INSERT INTO blw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Angkay hiyachi way inumchahcha hen chumang hen anchi fayfay way sakopon hen Gadareno, wachan i nihib-at way chuway tatagu an Jesus way narpochah palinufù. Nahuhullugancha ah ongtan wat anchag aggaégyat way térén, wat maid makatorod way mangéy hen hiyachiy charan. ");
INSERT INTO blw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yag angkay hen nangil-ancha an Jesus, anchaat agég nan-ongaw way mangaliyén, “Heay anà Apudyus, nokay hen ammaam an chàni. Ay ad uwanat hen mamàgangam an chàni way cha-an umchah hen ustoy tempona.” ");
INSERT INTO blw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yachi yag netongpo way wachacha hen ê-éyna hen ammag chuaray fafuy way chan garab. ");
INSERT INTO blw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wat anchaat mampangpanga-ase hen anchichay ongtan way mangale an Jesusén, “No eparyawno chillu chàni, eparufusno koma ta hen anchichay fafuy hen ayanni.” ");
INSERT INTO blw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Wat in-ayu,” way ekat Jesus, yag tenaynancha hen anchi tatagu way nihurugancha yag émméycha hen anchichay fafuy. Yachiyat agé yag amin hen anchichay fafuy, anchag hetatagtag wat napoligcha amin hen anchi chéprah yag nepesokcha hen fayfay wat anchag naofor amin. ");
INSERT INTO blw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yag hen anchichay nanginya-achug hen fafuy, ancha agé ammag ommawid way émméy ah fabréy, yag henaphapetcha amin hen na-ammaan hen anchichay fafuy ya umat agé hen anchichay nahurugan way tatagu. ");
INSERT INTO blw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hen hiyachi, lummigwatcha amin hen anchichay tataguh fabréy way i manib-at an Jesus. Yag angkay inchahancha hiya, anchag nampangpanga-ase way lomayaw koma hen hiyachiy fabréycha. ");
INSERT INTO blw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Angkay hiyachi yag kasen nanlugan cha Jesus hen anchi fangka way kasen gumchang hen anchi fayfay way mamfangad ah fabréycha. ");
INSERT INTO blw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Angkay hiyachi way hommàyatcha, ummalecha hen anchichay tatagu way ninya-atang hen ihay tagu way ammag napàroy hen acharna yag inyéycha an Jesus. Angkay enlasin Jesus way anchag manchinlan amin hiya, wat imfagana hen anchi napàroy way mangaliyén, “Heay sonod, pas-émém hen hamhamàno te napakawan hen fasorno.” ");
INSERT INTO blw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hen yachiy tempo, wachacha agéhchi hen tapen anchichay siguchay cha mintudtuchu hen orchin Moses, yag hen nangngarancha hen anchi enalen Jesus, ekatchah hamhamàchéén, “Apay annag cha pérhén hen kena-Apudyus Apudyus a, way annag cha epachong hen kafaelana hen kafaelan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngém ah Jesus, a-ammuna hen anchi chacha hamham-én yag annaat ekatén, “Pakay kaman ahnay hamhamàyu way ammag laweng. ");
INSERT INTO blw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ah hamhamàyu, ay narakraka hen mangaryaén napakawan hen fasorno no hen mangaryaén tomàchég-a ta manaran-a. ");
INSERT INTO blw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngém haén way Pangorowan hen Tatagu, ah manot-owaanyu way wachan lébféng-o hen antoy lota way mamakawan hen fasor, wat ka-anê hen saket hen taguwanna.” Yag annaat ekat hen anchi napàroyén, “Fumangon-a yag innaram hen annay allakwangno ta omanamot-a. ");
INSERT INTO blw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yag fummangonat tot-owa hen anchi tagu yag ommanamot.” ");
INSERT INTO blw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yag hen anchichay chuaray tatagu, hen nangil-ancha an nadchi, anchag nahaang way amchanat agé hen égyatcha. Wat chinayawcha ah Apudyus gapon nangidchatana hen kafaelan hen tatagu way mangamma hen kaman an nadchi. ");
INSERT INTO blw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Angkay cha lomayaw ah Jesus an nadchi, innilana hen ihay cha mangam-among ah furor way tummutùchu ah opesenana way ah Mateo hen ngachanna. Yag anat ifagan Jesus an hiya way mangaliyén, “Umaleaat ta somorot-a an haén.” Yag naranigwat tot-owa ah Mateo way somorot an hiya. ");
INSERT INTO blw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Angkay na-awni way cha mangan cha Jesus ya hen anchichay pasorotna ah faréy cha Mateo, émméy mèan agé hen chuar way ifan Mateo way cha mangam-among ah furor ya anat agé hen anchichay tapenay tatagu way menangfasor amin. ");
INSERT INTO blw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yachi way innilan hen tapen anchichay Fariseo chicha, ekatcha hen anchichay pasorot Jesusén, “Ay ammoh ammag cha mèan peet hen annay Apoyu hen annachay tatagu way kaman an cha nahha.” ");
INSERT INTO blw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yachi way chengngar Jesus hen anchi chacha aryén, yag annaat songfatan ah pani way mangaliyén, “Hen anchichay tatagu way maid saketna, achicha masapor hen choktor. Waman hen anchichay wacha hen saketna, chicha hen mansapor ah choktor. ");
INSERT INTO blw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wat hamham-ényu ngén no nokay hen laychén hen anchi nesosorat way alen Apudyus way aryén hen nangaryanéén, ‘Faén hen chayu ichatochaton an haén hen chà patigén, te hen chà patigénat hen manga-asiyanyu paat hen ifayu.’ ” Yag anat ekat Jesus agéén, “Iggayà ummale hen antoy lota way manudtuchu hen anchichay ammay way tatagu, te hen ummaliyà, ta iyà tudtuchuwan hen anchichay menangfasor.” ");
INSERT INTO blw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Angkay hiyachi yag émméycha an Jesus hen anchichay pasorot Juan way chan funfunyag, yag senarudsudcha way mangaliyén, “Pakay chàni ya hen anchichay Fariseo wat chani met amin soroton hen gagangaytaaw way Judio mepanggép hen chan langanan way mangan. Ngém hen anchichay pasorotno wat achicha.” ");
INSERT INTO blw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yag nampani ah Jesus way sommongfat, ekatnéén, “Ay ammoh ekatyuwén mantotokarcha hen anchichay tatagu way i mèkasar no mawawà-acha hen komasar. Achi met. Ngém umchah chillu hen ag-agaw way melayaw hen anchi komasar, wat yachi hen umchahan hen manlanganancha way achicha manganan.” ");
INSERT INTO blw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Entoroy Jesus agé way mangaliyén, “Maid tagu ah ammag mangid-op hen anchi faru way lopot hen anchi naropà way lumfong. Te no yachi hen ma-ammaan, émhén hen anchi faru way lopot yag enagamidna hen anchi nid-opana, wat ammag kaskasenat hen magissayana. ");
INSERT INTO blw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yag umat agé hen anchi fayah way finanar, achi mafalin way ifongofongchi hen anchi nausar way gadchang way amoto, te achi matantan hen anchi nausar way gadchang, wat fumtà yag ayyua amin hen anchi finanar ya hen anchi gadchang agé. Wat hen ekaman métat ifongofong hen finanar hen anchi gadchang hen anat naparte way karnero wat maid masayang.” ");
INSERT INTO blw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yachi way étég Jesus way cha mangale hen chana ifaga, yag ummaliyat agé hen ihay okom hen Judio way nampalentomang hen henagongna way mangaliyén, “Apo, anat naumpoh hen fùfuoh hen anchi anào way fafarasang, wat ay achi mafalin ta umalea ta tad-ém ta kasen matagu.” ");
INSERT INTO blw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yachi yag lummigwatat cha Jesus ya hen anchichay pasorotna way umunud hen anchi okom way éméy ah faréycha. ");
INSERT INTO blw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Hen hiyachi, niyaphor way wacha agé hen ihay in-ina way ammag hemporo ya chuway tawén hen chana chumar-achar-an. Yag ekatna ah hamhamànéén, “No an-o koma paat an tad-én hen uray anchi lumfongnaat maka-an hen antoy saket-o.” Yachi yag anat i mehnop hen échég Jesus way inna tenchà hen pongton hen lumfongna. ");
INSERT INTO blw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yag namfiliwit ah Jesus way nangila an hiya yag annaat ekatén, “Heay sonod, pas-émém hen hamhamàno, te gapo hen pammatem an haénat naka-an hen annay saketno.” Yag hen hiyachi, naka-anat tot-owa hen anchi saketna. ");
INSERT INTO blw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Angkay inumchah cha Jesus hen faréy hen anchi okom way hinénggépcha, yag ammag amchan hen hometang hen anchichay chan i-ifil ya cha mamarachong. ");
INSERT INTO blw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yag annaat ifaga an chicha way mangaliyén, “Gumhad-ayu amin te cha-an angkay matéy hen annay ongaanna te an yanggay nanasséy.” Yag ammag enam-amrang hen anchichay tatagu hiya. ");
INSERT INTO blw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Angkay ginumhadcha hen anchichay tatagu, émméy ah Jesus hen kowarton hen anchi natéy, yag inégnanana hen limana yag ammag fummangonat agé. ");
INSERT INTO blw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wat hen hiyatoy enammaan Jesusat ammag nanhemamag hen kafabréfabréy hen hiyachiy lugar. ");
INSERT INTO blw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Angkay hiyachi way lommayaw ah Jesus an nadchi, cha manadchad-aran yag chaat agé umunud hen chuway nabfurag way chan o-ongaw way mangaliyén, “Heay ganà David, pangpanga-asem paat ta ka-asiyam chàni.” ");
INSERT INTO blw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yachi way hinénggép ah Jesus ah faréy, yag nì-ighépcha agé hen anchi chuway nabfurag. Yag anat ekat Jesus an chichéén, “Ay afurotonyu way makaka-anà tot-owa hen annay finuragyu.” Yag sommongfatcha way mangaliyén, “Oo Apo, afurotonni.” ");
INSERT INTO blw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wat anat tad-én Jesus hen matacha way mangaliyén, “Ma-ammaan an chàyu hen annay chayu afuroton way ma-ammaan.” ");
INSERT INTO blw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wat hen hiyachi, makailachaat tot-owa. Yachi yag anat téngtéténgténgén Jesus chicha way mangaliyén, “Ilanyu ta achiyu paat cha haphapeténto ah uray heno way tagu.” ");
INSERT INTO blw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngém angkay ginumhadcha, chachaat agé iwarawarawag hen anchi enammaan Jesus an chicha hen amin anchi sakop hen hiyachiy lugar. ");
INSERT INTO blw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Angkay hiyachi way cha lomayaw hen anchi chuway nabfurag, chachaat agé iyéy an Jesus hen ihay tagu way ammag tenongong hen anchi nihuhurug way ongtan. ");
INSERT INTO blw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yachi way emparyaw Jesus hen anchi ongtan, yag ammag naka-aleyat agé hen hiyachiy tagu. Wat anchag nahahaang hen anchichay na-a-among way tatagu yag ekatchéén, “Ay ammoh wachay nangil-antaaw way ganà Israel ah kaman an natto.” ");
INSERT INTO blw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngém anchag sommongfat hen anchichay Fariseo an nadchi way mangaliyén, “Kafaelana kagé way mangemparyaw hen ongtan te hen ap-apon hen ongtan hen nangidchat hen kafaelana.” ");
INSERT INTO blw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Angkay hiyachi yag ginégga-ay Jesus hen kafabréfabréy ahchi way i mantudtuchu hen anchichay sinagoga way chacha ma-am-amongan te chana iwarawag hen anchi ammayay chamag mepanggép hen mantorayan Apudyus. Ya chana agé ka-anén hen saket hen anchichay heno way cha masaket. ");
INSERT INTO blw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yag yachi way innilana hen anchichay ammag chuar way tatagu, ammag naség-angan way térén, te anchag kaségség-ang, ya maid agé innilacha ah manginyapetancha ah tomorong an chicha, te ancha yanggay ammag kaman karnero way maid manalimun an chicha. ");
INSERT INTO blw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yachi yag inyalig Jesus hen anchichay chuaray tatagu ah naggahan way pagéy way mabtà koma, te maila way omafurotcha non an wachay i mangintudtuchu hen omafurotancha. Wat ekatnan anchichay pasorotnéén, “Ammag chuar hen mabtà ngém achi ummat hen anchichay i mamfatà.” ");
INSERT INTO blw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Wat chawatényu an Apudyus way nangen-awa hen antoy fatà ta hénagéna hen tapena way i mamfatà. ");
INSERT INTO blw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Angkay hiyachi yag enamong Jesus hen anchichay hemporo ya chuway pasorotna yag inidchatna hen kafaelancha way mangemparyaw hen nihuhurug way ongtan ya anat hen kafaelancha way manga-an hen aminay karasey saket. ");
INSERT INTO blw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chichato hen ngachan hen anchichay hemporo ya chuway aposelna. Ah Simon way nangadnan ah Pedro ya ah Andres way enawchina, cha Jaime an Juan way hen-agi way anà Zebedeo, ");
INSERT INTO blw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","cha Felipe an Bartolome, ah Tomas, ah Mateo way cha nangam-among hen furor, ah Jaime way anà Alfeo, ah Tadeo, ");
INSERT INTO blw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ya anat ah Simon way ekatchéén “Selot”, ya anat agéh Judas Iscariote way hiyan anchi nangenlao an Jesus hen ummawni. ");
INSERT INTO blw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","7","Yachi yag hennag Jesus amin chicha way mangaliyén, “Éméy-ayu ta iyu iwarawag hen anchichay ahentaguyu way ganà Israel way tég-angay milugi hen anchi mantorayan Apudyus way hahadchéncha. Yag ilanyu agé ta achiayu cha ém-éméy hen heno way fabréy hen anchichay faén Judio way uray ad Samaria ta hen kacharaanyu yanggay hen ayanyu, te chicha, anchag kaman nattafaw way karnero. ");
INSERT INTO blw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Inidchat-o hen kafaelanyu wat ka-anényu hen sasaketcha way uray hen anchi ka-aggarémhaan way saket way konet. Man-uchiyényu hen natéy ya eparyawyu agé hen anchichay nihurug way ongtan. Maid finab-ayachanyu ah aminay nidchat an chàyu wat achiyu agé epafayad hen heno way etorongyu. ");
INSERT INTO blw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Achiayu mamfaron ah pelak ");
INSERT INTO blw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ya achiayu agé mampah-eng. Achiayu amin omentatàen ah mansokatanyu way lumfong ya sapatos, ya achiyu agé aran hen uray hor-od, ta egad hen tatagu an chàyu, te karébfénganyu way ma-adchan ah aminay masaporyu gapon chayu ammaan.” ");
INSERT INTO blw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Entoroy Jesus way mangaliyén, “No umchah-ayu hen ihay fabréy, anapényu hen anchi tagu way manlayad way manginfisita an chàyu ta hiya hen mì-iggawanyu inggana hen lomayawanyu. ");
INSERT INTO blw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yag no hénggép-ayu hen faréycha, ifagayu way bibindisyunan Apudyus chicha. ");
INSERT INTO blw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yag no laychén chàyu way mì-iggaw an chicha, bindisyunan tot-owa Apudyus chicha. Ngém non an umat way achi chàyu laychén, man-awayu chillu hen anchi bindisyun Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yag mag-ay ta maid mangempaghép an chàyu ya ancha agég achi changrén hen ifagayu, anyug pòpoan hen tapok ah he-eyu hen lomayawanyu ah mangenlasinancha way egadcha hen machusaancha. ");
INSERT INTO blw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yag tot-owa hen antoy ifagà an chàyu way no umchah hen anchi ag-agaw way manguwisan Apudyus hen katagutagu, wat am-améd angkay hen kachusaan cha nadchi no hen manusaana hen anchichay lawengay tatagu ad Sodoma yad Gomora.” ");
INSERT INTO blw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Entoroy Jesus hen imfagana hen anchichay pasorotna, ekatnéén, “Changrényu hen antoy ifagà an chàyu, te hénagê chàyu hen anchichay laweng way tatagu way kaman-ayu yanggay karnero way éméy hen iggaw hen anchichay aggaégyat way tanan way aho. Wat masapor ar-arwachanyu paat hen chacha ekaman an chàyu, ngém anyu chillug iyam-amma paat hen ekamanyu an chicha. ");
INSERT INTO blw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ar-arwachanyu te awni yag wachacha hen tapenay tatagu way manelew an chàyu yag inchérém chàyu, yag awni agé yag anchag epapagoh chàyu hen iggaw hen chacha ma-am-amongan. ");
INSERT INTO blw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yag gapo agé hen afurotyu an haénat an chàyug epasango hen anchichay nan-angato way chan totoray. Ngém hiyachi hen wayayu way mangimfaga an chicha ya uray hen anchichay faén Judio hen anchi ammayay chamag mepanggép an haén. ");
INSERT INTO blw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yag no nepasangoayu, achiayu cha machanagan mepanggép hen aryényu ya hen ekamanyu way somongfat, te hen hiyachiy urasat midchat an chàyu hen ustoy aryényu. ");
INSERT INTO blw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Te faén chillu chàyu hen marpowan hen anchi iyaleyu te hen anchi Espiritun Amataaway Apudyus hen mangempahpahmà an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Yag hen hiyachiy tempo agé wat uray hen masosnochén man-ahetennocharcha ah mapchitan hen ifacha. Yag umat agé hen ekaman hen ama hen a-anàna, ya kaman agé hen a-anà hen chinàcha-arna, wat man-ahepennochitcha. ");
INSERT INTO blw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yag chàyu agé, an chàyug agorgoran hen aminay tatagu gapo hen afurotyu an haén. Ngém heno way mangempapate hen afurotna chillu ingganah anongohna, mahara-an way mì-iggaw an Apudyus ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wat no paligatén chàyu hen ihay fabréy, omawid-ayu way man-aton ah safali. Yag tot-owa hen antoy ifagà an chàyu way achiayu angkay makarpas hen antoy chà epa-amma an chàyu way manginggégga-ay hen aminay fabréy hen ganà Israel yag inumchahat hen mamfangchà way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yachi yag penanin Jesus mepanggép hen mepasamak an chicha, ekatnéén, “Maid cha matudtuchuwan ah nangatngato no hen anchi cha manudtuchu an hiya, ya maid agé alepan ah nangatngato no hen apona. ");
INSERT INTO blw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wat kapeletan way heno way ma-ammaan hen anchi mantudtuchu, ma-ammaan agéchi hen anchi chana tudtuchuwan. Umat agé hen alepan, te heno way ma-ammaan hen apona, sigurachu way ma-ammaan agéchi an hiya. Wat haén way apoyu, no ustanà hen tatagu way ekatchéén haén ah Beelzebub ano way ap-apon hen chumunyu, ay ammoh achi kaskasen hen mangsotancha an chàyu way pasorot-o.” ");
INSERT INTO blw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Entoroy Jesus way mangaliyén, “Achiayu cha émégyat koma hen an yanggay an tatagu. Te amin way achi maila ad uwan, mepàila chillu ah awni. Ya amin agé way netataro ad uwan, mepagngar chillu no umchah hen tempona. ");
INSERT INTO blw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wat amin hen anchichay chà intudtuchu an chàyu hen ka-anggayyu ya hen chà inyut-utiyam, masapor epagngaryu hen aminay katagutagu way uray èngawyu. ");
INSERT INTO blw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ya achiayu agé cha émég-égyat hen anchichay makapchit yanggay hen achar te achicha chillu makapchit hen lennawa. Ta hen émégyatanyu yanggay komaat ah Apudyus, te hiya, kafaelana way mangentap-ar hen achar ad imférno way nelarammong hen lennawa. ");
INSERT INTO blw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ilanyu ngén hen hamhamà Apudyus an chàyu, te uray hen anchichay tolen way ammag an tanso yanggay hen laon hen chuwaat maid chillu matéy ah uray ihà-an an chicha no achi parufusun Amataaway Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yag kaskasen chàyu, te uray hen kabras hen fuùyuwén finifilang Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Wat yaha, achiayu koma émég-égyat ah uray heno te kaskasen hen mamatigan Apudyus an chàyu no hen kasole.” ");
INSERT INTO blw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Entoroy Jesus way mangaliyén, “Heno way tagu way mangentàchég hen sangwanan hen tatagu way haén hen apona, tàchégà agé hiya an Amay Apudyus ad uchu. ");
INSERT INTO blw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Waman hen anchi tagu way mangenhoot an haén hen sangwanan hen ahentaguna, ehoot-o agé hiya an Amay Apudyus ad uchu.” ");
INSERT INTO blw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Awni yag ekatyuwén ummaliyà hen antoy lota way mangempatornos hen tatagu, ngém faén angkay tornos hen inyalè te guru. ");
INSERT INTO blw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Te inyalè hen mansosongelan hen hen-anamma ya hen-ininna ya umat agé hen ma-at-atoganga. ");
INSERT INTO blw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yag hen térén way kafusor hen ihay tagu wat maid kasen no faén hen ahimfafaryanna.” ");
INSERT INTO blw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Heno way tagu way pawadwad-éna hen layadna hen chinàcha-arna no hen layadna an haén, wat maid karébféngana way mifilang ah pasorot-o. Ya umat agé hen anchi tagu way pawadwad-éna hen layadna hen a-anàna no hen layadna an haén, wat maid agé karébféngana way mifilang ah pasorot-o. ");
INSERT INTO blw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ya heno agé way tagu way ekatnéén somorot an haén, ngém annag achi anohan hen ligatna way uray iyatéyna, wat maid angkay agé karébféngana way mifilang ah pasorot-o. ");
INSERT INTO blw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Te hen anchi tagu way ammag mangempapangég hen ataguwana hen antoy lota wat matéy chillu. Ngém hen anchi tagu way achina epangég hen matéyana gapon afurotna an haén, midchat an hiya hen mannanayun way ataguwana an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Entoroy Jesus way mangaliyén, “Heno way tagu way mangimfilang an chàyu, chana angkay agé ifilang haén. Yag hen anchi cha mangimfilang an haén, chana agé ifilang hen anchi nannag an haén. ");
INSERT INTO blw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ya heno agé way mangimfilang hen anchi cha mangintudtuchu hen alen Apudyus gapo ta yachin chununa, midchat an hiya hen gunggunana way kaman agé hen gunggunan hen anchi cha mangintudtuchuwanchi. Yag umat agé hen heno way mangimfilang hen anchi tot-oway ammayay tagu gapon kena-ammayna, wat midchat an hiya agé hen gunggunana way kaman hen gunggunan hen anchi ammayay taguwanchi. ");
INSERT INTO blw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yag umat agé hen heno way tagu way an lawag an mangempainum hen ténéng way chanum hen uray anchi kafafaan way cha omafurot an haén ah gapon ommafurotana, wat idchat agé Apudyus way idchat hen gunggunana.” ");
INSERT INTO blw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Angkay hiyachi way lempas Jesus way manugun hen anchichay hemporo ya chuway pasorotna, lommayaw ahchi way émméy hen anchichay nehag-énay fabréy way i manudtuchu an chicha. ");
INSERT INTO blw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hen hiyachiy tempo, nifafarud ah Juan way chan funfunyag. Angkay chengngarna ah pagfaruchan hen cha enamma-ammaan Jesus, yag annaat hénagén hen tapenay pasorotna way i mangimoh an Jesus way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ay hea tot-owa hen anchi mamahhéd way imfagan Apudyus way umale, ono manhééd-ani ah safali.” ");
INSERT INTO blw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yag anat ekat Jesus an chichéén, “Mamfangad-ayu an Juan ta haphapetényu hen chayu chengngar ya hen chayu innila way chà enammaan ");
INSERT INTO blw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","way hen anchichay nabfuragén, makailacha, ya hen anchichay nattorangén, makagngarcha, ya hen anchichay nakkonetén, ommammay hen acharcha, ya hen anchichay nappelayén, makacharancha. Ya uray hen natéyén nepauchicha, ya hen anchichay maid mafalinna way tatagu, cha miwarawag an chicha hen anchi ammayay chamag. ");
INSERT INTO blw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ya ifagayu an hiya agé way ammag lomaylayad hen anchi tagu way achin chuwachuwa hen afurotna way haén hen anchi hennag Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Angkay hiyachi way chacha lomayaw hen anchichay pasorot Juan, inlugin Jesus way mangimfaga hen anchichay tatagu hen mepanggép an Juan, ekatnéén, “Hen anchi iyu nangil-an an Juan ah chanak, nokay hen ekatyuwén inyu ilan. Ay ammoh ekatyuwén hiya hen kaman gurun way ammag maid achina omadyugan no hapochén hen yawyaw. ");
INSERT INTO blw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","No faénchi, pakay émméy-ayu nò way nokay hen inyu innila. Ay ammoh anyu an i innila no nanlumfong ah ammayay lumfong. Iggay a, te ah faréy hen Are hen iggaw cha nadchi way faén ah chanak. ");
INSERT INTO blw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Wat nokay ngarud hen tot-owa way pontosyu way i nangila nò. Ah katot-owana, anyu chillu an i innila hen profetan Apudyus. Wat hen ifagà an chàyu, wadwadcha angkay ah Juananchi no hen profetan Apudyus ");
INSERT INTO blw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","te hiya paat hen anchi tagu way ena-allen hen anchi nesosorat way alen Apudyus way ekatnéén, ‘Wacha hen ihay tagu way faarê way mamangpango no hea, ta ina esasaggana hen anchichay tatagu ta changréncha-a.’ ");
INSERT INTO blw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tot-owa hen antoy ifagà an chàyu,” way ekat Jesus, “way maid kasen tagu ah niyanà hen antoy lota ah nangatngato no ah Juan way chan funfunyag. Ngém nangatngato chillu hen anchi uray kafafaan way tagu way metape hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nanepod hen laprapon hen nantudtuchuwan Juananchi ingganad uwan, chuar hen cha mangempapelet way metape hen mantorayan Apudyus, ya kaskasen agé hen cha ekaman hen tapena way mangempapelet way metape. ");
INSERT INTO blw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hen anchi mantorayan Apudyus chillu hen pontos hen cha aryén hen amin anchichay profeta way nanepod ad namenghan inggana hen ummaliyan Juananchi. Ya yachi agé hen pontos hen anchi orchin way ensorat Moses. ");
INSERT INTO blw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wat non anyu an afuroton hen chacha amin imfaga wat ma-awatanyu way ah Juananchi, hiya angkay ah Elias way nifafagga way mamfangad.” ");
INSERT INTO blw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","“Chengngaryu hen antoy chà ifaga te naingaan-ayu wat ma-awatanyu koma hen laychénay aryén.” ");
INSERT INTO blw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Entoroy Jesus way mangaliyén, “Nokay lawa hen mangempaniyà an chàyu way tatagu ad uwan way ammag maid ma-ara an chàyu. Iyalig-o chàyu ah kaman ungunga way omachi way man-ay-ayam uray no cha chàyu ongawén ah tapena ta mèay-ayam-ayu. ");
INSERT INTO blw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Te hen namattopattongancha ah mèhalepanyu koma, anyug iggay lenyad way mètape. Yag yachi way emparégcha way nan-ib-ifil ah metapyanyu koma, an-ayu chillug achi mètape. ");
INSERT INTO blw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yaha hen cha mekaman an chàyu way ammag maid ma-ara. Te hen ummaliyan Juananchi way chan langrangan way mangan ya achi amin uminum ah fayah, wat penelohyu hiya way mangaliyén an nahurugan ah ongtan. ");
INSERT INTO blw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wat angkay ummaliyà agé way Pangorowan hen Tatagu way achiyà manlangrangan way mangan ya chaà amin mì-inum, wat anyu agég cha pelohon haén way mangaliyén anà ammag fukatot ya amfutangén, ya chayu amin ekatén chà gayyémén hen anchichay cha mangam-among hen furor ya hen anchichay tapenay menangfasor. Ngém tàén yaha, mepàila chillu hen kenaraeng Apudyus te hen halenonot hen ekamanna, yachi hen manot-owaan hen kenaustona.” ");
INSERT INTO blw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Angkay hiyachi yag anat agé ilugin Jesus way mangingar hen tatagu hen anchichay fabréy way nangempàil-ana hen kachùran way kaskascha-aw te uray innilacha, anchag achi chillu manchùgan hen anchi laweng way chacha am-ammaan. ");
INSERT INTO blw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ekatnéén, “An-ayu ammag kàka-ase, chàyu way eCorazin ya iBetsaida. Ka-as-aseayu no hen anchichay faén Judio way eTiro ya eSidon, te non an umat yag ahchi hen nangammaà hen kaskascha-aw way kaman hen enammaà ah fabréyyu, wat ancha angkay ammag nanchapchapor ya nanlumfong ah sako ah mamfafawiyancha. ");
INSERT INTO blw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wat tot-owa hen antoy ifagà an chàyu way mangmanghan angkay hen machusaan hen eTiro ya eSidon no chàyu hen anchi ag-agaw way manguwisan Apudyus hen aminay katagutagu.” ");
INSERT INTO blw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ya chàyu agé way eCapernaum, magénén ekatyuwén machachayaw-ayu ingganad uchu. Ngém achiayu angkay te an-ayu ammag mepesok ad imférno gapon achiyu mamfafawiyan. Te non an umat yag ad Sodoma hen nangammaà hen kaskascha-aw way kaman hen enammaà ah fabréyyu wat namfafawicha angkay way é-éttégcha ad uwan way cha-an nèopoh. ");
INSERT INTO blw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wat tot-owa antoy ifagà agé an chàyu way mangmanghan angkay hen machusaan hen eSodoma no chàyu hen umchahan hen anchi ag-agaw way manguwisan Apudyus hen katagutagu.” ");
INSERT INTO blw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Angkay hiyachi yag nanluwaru ah Jesus way mangaliyén, “Manyamanà an hea Amay Apudyus way Ap-apo ad uchu ya hen antoy lota, te annog empaka-ammu hen katot-owaan mepanggép an haén hen antochay cha-an na-achar way achi ma-awatan hen anchichay nan-araeng ya naka-achar. ");
INSERT INTO blw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wat saramat paat Ama te yaha hen enammaam way yaha chillu hen laychém.” ");
INSERT INTO blw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yachi yag anat agé ifagan Jesus hen anchichay pasorotna way mangaliyén, “Impiyar Amay Apudyus hen egachay wacha an haén way haén, maid nangila hen kenatatagù ya hen kena-apudyus-o no faén yanggay ah Amay Apudyus. Ya maid agé nangila an Amay Apudyus no faén yanggay haén way anàna ya anat hen anchichay tatagu way piliyê ah mangempaka-ammuwà hen mepanggép an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Amin-ayu way napoproblemaan ya nau-ungar gapon ligat, umaleayu an haén, wat man-inungarê chàyu. ");
INSERT INTO blw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yag changrényu hen tugun-o ta acharényu paat hen wachan haén, wat matornos-ayu ya yumagpaw hen hamhamàyu. Te haén, na-anohà ya achì èmehan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ya achiayu agé maligatan way mangamma hen epa-ammà an chàyu te faén naligat.” ");
INSERT INTO blw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Angkay hen-argawan way Safachu way ngilin chillu hen Judio, cha manaran cha Jesus ya hen anchichay pasorotna hen ihay chacha murmur-an ah pagéy. Yag angkay gapo ta chachan henaang hen anchichay pasorotna, wat ancha lawag ummara an nadchi ah chacha ot-ottemén. ");
INSERT INTO blw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Angkay innilan hen anchichay Fariseo chicha way chan ottem, chinumsekcha way mangalen Jesusén, “Ilam ngén hen annay cha ammaan hen pasorotno, chacha angkay labsengén hen orchintaaw way mangempawa hen mamfat-an hen ngilin way Safachu.” ");
INSERT INTO blw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Senongfatan Jesus chicha way mangaliyén, “Pakay. Ay ammoh maid finasayu hen anchi enammaan hen anchi apotaaw way David ad namenghan ya hen anchichay ifana hen hommenaangancha. ");
INSERT INTO blw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","An met ammag hinénggép hen anchi faréy Apudyus yag innarana hen anchi tenapay way nichachaton an Apudyus way ekat hen orchintaawén anggay hen papachi hen mangan an nadchi. Ngém enan David chillu ya ummidchat agé hen anchichay ifana. Wat gapoh kena-arena, maid met ekattaawén fasornachi. ");
INSERT INTO blw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yag ay ammoh iggayyu agé faséén hen anchi orchin way ensorat Moses mepanggép hen anchichay papachi agé way chan chunu ah Templo, wat Senafachu met way chacha agé labsengén hen anchi ngilin way man-inungaran te uray Safachu way ngilinén, chacha chillu manchunu ahchi. Ngém achi met mifilangchi ah fasor gapo hen kenapateg hen anchi Templo way chacha manchunuwan. ");
INSERT INTO blw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yag tot-owa hen antoy ifagà an chàyu way ad uwananto, wacha hen inumchah an chàyu way napatpateg no hen anchi Templo. ");
INSERT INTO blw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hen anchi nesosorat way alen Apudyus, ekatnéén, ‘Faén hen anchi chayu ichaton an haén hen patpatigê te hen patpatigê paatat hen manég-anganyu hen ifayu.’ ” Yachi yag ekat Jesusén, “Non anyu an na-awatan koma hen laychén nadchi way aryén, wat iggayyu koma pafasoron hen antochay cha-an fummasor. ");
INSERT INTO blw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Te haén way Pangorowan hen Tatagu, haén hen nangimfiyang way mangimfaga hen ma-ammaan hen ngilin.” ");
INSERT INTO blw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Angkay lommayaw ah Jesus an nadchi yag émméy hen ihay sinagoga way chacha ma-am-amongan way Judio. ");
INSERT INTO blw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yag niyaphor way wacha agéhchi hen ihay tagu way ammag nàis-is hen ihay limana. Yag wachacha agé hen anchichay tapena way cha manganap ah manginchérémancha an Jesus, wat incha imfaga an hiya way mangaliyén, “Ay marabseng ngén hen anchi orchintaaw no tàén Safachu way ngilin yag kena-an hen saket hen tagu.” ");
INSERT INTO blw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Senongfatan Jesus chicha ah pani way mangaliyén, “Chàyu ngay, no wachay nag-ah ah karneroyu hen fito hen tempon hen ngilin, ay ammoh achiyu chillu i aran. ");
INSERT INTO blw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wat ay ammoh faén napatpateg hen tatagu no hen karnero. Isonga achi an cha labsengén hen orchintaaw no torongan hen tatagu uray Safachu way ngilin.” ");
INSERT INTO blw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yachi way enalen Jesuschi yag annaat ifaga hen anchi taguwanchi way mangaliyén, “Uyachém hen annay limam.” Inuyadna yag ammag ommammayat agé way nepachong hen anchi iha. ");
INSERT INTO blw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Wat hen anchichay Fariseo, ancha ammag lommayaw way incha man-a-atopàpà ah ekamancha way mamchit an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Angkay hiyachi way chengngar Jesus hen anchi chachan a-atopàpa-an, ammag lommayaw an nadchi. Ngém chachaat ma-atiguyguy chillu hen anchichay chuaray tatagu way umunud an hiya yag kena-anna hen aminay sasaketcha, ");
INSERT INTO blw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yag annaat téngténgén chicha ta achicha koma cha haphapetén ah tapena hen mepanggép an hiya. ");
INSERT INTO blw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hiyaha hen enkamkaman Jesus ah tomot-owaan hen anchi alen Apudyus way ensorat hen anchi profeta way Isaias ad namenghan way ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hiyato hen anchi penepelè ah chà fabfaarén way hiya hen anchi laylaychê paat ya hiya agé hen cha mangemparaylayad an haén. Idchat-o hen Espiritù an hiya ta hiya hen manginwarawag hen anchi ammayê hen anchichay faén Judio ah karotarota. ");
INSERT INTO blw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Achi me-esngel ya achina agé an èngaw hen ifagana. Ya achi agé ammag an manchischiskorso hen iggaw hen tatagu. ");
INSERT INTO blw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ya achina agé ammag héphépén hen anchichay nakapsot hen pammatena, ya ammag na-anoh agé hen ekamanna hen anchichay aggarayos, ya achina agé iyanggayan hen chana amma-ammaan ingganah mangafà hen anchi usto way afaéna hen aminay laweng. ");
INSERT INTO blw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yag hiya yanggay hen manchinlan hen aminay tatagu ah kahara-ancha.” Yaha hen ensorat Isaias ad namenghan. ");
INSERT INTO blw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Angkay hiyachi yag inyéycha an Jesus hen ihay tagu way nabfurag ya nattongong te naruyawan. Yag angkay emparyaw Jesus hen anchi ongtan, nan-aleyat agé hen taguwanchi yag mafalin makaila. ");
INSERT INTO blw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wat amin hen anchichay lonay way tatagu, ancha ammag nahahaang way mangaliyén, “Ay hiyato ngata hen anchi ganà David way hahadchéntaaw.” ");
INSERT INTO blw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Angkay chengngar hen anchichay Fariseo hen enalen hen anchichay tatagu, senongfatancha way mangaliyén, “Ayong-ang, ah Beelzebub angkay way ap-apon hen ongtan way Chumunyu hen nangidchat hen kafaelan nattoy tagu way mangemparyaw hen nihuhurug way ongtan.” ");
INSERT INTO blw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngém ah Jesus, inni-ilana chillu hen chacha hamham-én wat senongfatana chicha ah pani way mangaliyén, “Uray heno way toray, no maid tetempoyug hen anchichay tataguna way anchag chan sososongel, ammag naraka hen ma-afa-ancha. Ya umat agé hen himfafaryan ono hen umili, no maid tetempoyugcha ta anchag chan sososongel, wat anchag mahihiyan amin yag na-afàcha. ");
INSERT INTO blw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wat pachongna agé no ekatyuwén hen anchi ap-apon hen ongtan hen nangidchat hen kafaelà way mangemparyaw hen ongtan, te anna agé cha gufatén hen anchichay kapachongnay ongtan. Yag no yahaat ay ammoh faén ag-aggah hen machachaelan hen mantorayana. ");
INSERT INTO blw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yag no ekatyu chilluwén ah Beelzebub way ap-apon hen ongtan hen nangidchat hen kafaelà way mangemparyaw hen anchi nihurug way ongtan, achi pay ongtan agé hen nangidchat hen kafaelan hen annachay pasorotyu way cha mangemparyaw agé hen cha mihurug way ongtan. Wat hen cha ammaan hen annachay pasorotyu, yachi hen mangempàila way enomfat hen annay chayu aryén an haén. ");
INSERT INTO blw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wat faén ah Beelzebub hen nangidchat hen kafaelà way mangemparyaw hen anchichay ongtan te hen Espiritun Apudyus. Wat yachi hen manot-owaanyu way looh niluruggi peet hen mantorayan Apudyus hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ah katot-owana, ammag maid makaghép hen faréy hen orhe way tagu way i mangara hen kok-owana no achina unna faruchun hen orheyanchi yag annaat mafalin aran hen kok-owana. Orhe tot-owa ah Chumunyu, ngém ena-afào chillu hiya yag a-allà agé hen kok-owana.” ");
INSERT INTO blw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Heno way tagu way achi mangifa an haén wat chana angkay fusoron haén. Ya heno agé way achi cha manorong an haén hen chà ammaan, annaat angkay cha kontaréén haén. ");
INSERT INTO blw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Wat hiyachi, tot-owa hen antoy ifagà an chàyu way uray heno way fasor way ammaan hen tatagu ya uray agé hen mangsotancha an Apudyus wat mafalin mapakawan. Ngém hen anchi ammag achi mapakawan way fasor wat hen anchi mangsot hen Espiritun Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wat hiyaha, heno way mangsot an haén way Pangorowan hen Tatagu, mafalin chillu mapakawan. Ngém hen anchi mangsot paat hen anchi Espiritun Apudyus, achi poros mafalin mapakawan way uray ad uwan yah pegwana.” ");
INSERT INTO blw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yachi yag kasen nampani ah Jesus way mangaliyén, “No ammay hen away, ammay agé hen anchi ifungana. Ngém no laweng hen anchi away, kapeletan way laweng agé hen anchi ifungana, te hen fungana hen mangimfaga hen kena-away hen away. ");
INSERT INTO blw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yachi hen manot-owaan way an-ayug kaman farakkan, te ay ammoh mafalin laway aryényu hen ammay no an-ayu chillug laweng. Te tot-owa angkay way hen anchi wacha ah hamhamà, yachi agé hen iyalen hen tapà. ");
INSERT INTO blw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wat hen anchi tagu way ammay ya usto hen hamhamàna, ammay agé hen a-ammana. Waman hen anchi tagu way ammag laweng chillu hen chana hamham-én, laweng agé hen a-ammana.” ");
INSERT INTO blw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Tot-owa hen antoy ifagà an chàyu way no umchah hen anchi ag-agaw way mauwisan hen egachay katagutagu, wéhchiyén songfatana an Apudyus hen aminay enammaana way uray hen anchichay enalena way maid gutokna. ");
INSERT INTO blw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Te hen aminay chayu aryén, yachi hen mangchat ah machusaanyu ah pegwana ono achiayu.” ");
INSERT INTO blw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Angkay hiyachi yag nan-ale hen anchichay tapen hen siguchay cha mintudtuchu hen orchin Moses ya hen anchichay Fariseo, yag ekatchan Jesusén, “Apo, omenpàila-a kaya ah kaskascha-aw ah manot-owaanni no henoa.” ");
INSERT INTO blw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yag senongfatan Jesus chicha way mangaliyén, “Chàyu way tatagu ad uwan, an-ayug laweng way anyug nanchùgan ah Apudyus. Yag pakay paat hen kaskascha-aw hen epapeletyu way ammaà. Maid angkay kaskascha-aw ah epàilà an chàyu no faén yanggay hen anchi sinyar way na-ammaan hen anchi profeta way Jonas ad namenghan. ");
INSERT INTO blw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Te ah Jonas, ini-inggaw hen poton hen anchi chakaray gachiw ah toroy ag-agaw. Yag umat agé haén way Pangorowan hen Tatagu wat milufuà hen lota ah toroy ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wat no umchah hen anchi ag-agaw way mauwisan hen aminay katagutagu, an chàyug pafasoron hen anchichay tinudtuchuwan Jonas way eNineve te chichaat namfafawicha way térén hen nangngarancha hen imfagan Jonas. Ngém chàyu, nat-én-ayu te tàén antoyanà ad uwan way nangatngato no ah Jonas, anyug achi chillu changrén hen chà itudtuchu an chàyu. ");
INSERT INTO blw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ya hen hiyachi agéy tempo way kauwisan hen tatagu, fùnag hen anchi arey fufae way narpod Seba way mangempafasor an chàyu agé, te hiyaat ammag acha-achawwéy hen namfiyahiyana way i paat mangngar hen anchi kenaraeng way itudtuchun Arey Solomon. Ngém chàyu, tàén antoyanà ad uwan way nangatngato no ah Solomon, anyug achi chillu changrén hen chà itudtuchu an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Entoroy Jesus way nampani, ekatnéén, “No lomayaw hen nihuhurug way ongtan hen tagu, ina gégga-ayén hen anchi lugar way maid fummabréy way i man-anap ah fumaryana. Ngém mag-ay ta maid ichahana, ");
INSERT INTO blw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mamfangad chillu hen anchi tagu way narpowana. Yag angkay no mamfangad yag innilana way ammag maid peet ininggaw ya nacharos ya niyam-amma amin hen egad, ");
INSERT INTO blw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","wat i man-ayag ah pitu ah ifana way mas kaskasen hen kenarawengcha no hiya, yag fummaréycha amin an hiya. Wat hen na-ammaan hen anchi taguwanchi hen anongohna, ammag kaskasen way kàka-ase no hen anchi pés-éyna.” Yachi yag inyanongoh Jesus way mangaliyén, “Kaman an nadchi hen mekaman an chàyu way tatagu ad uwan way ammag laweng.” ");
INSERT INTO blw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Étég Jesus way chan tudtuchu hen anchichay tatagu yag inumchahchaat agé cha inana ya hen anchichay enawchina way chacha epa-ayag hiya te wachan ifagacha. ");
INSERT INTO blw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yag anat i ifagan hen ihay tagu an Jesus way mangaliyén, “Anchiyan cha inam ya hen e-enawchim ah chara way chacha-a epa-ayag te wacha anon ifagacha.” ");
INSERT INTO blw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yag senongfatan Jesus way mangaliyén, “Oo a, ngém faén yanggay chicha hen ifilang-oh chàcha-ar-o ya sosnod-o.” ");
INSERT INTO blw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yag annaat tuchuwén hen anchichay pasorotna way mangaliyén, “Chichato agé hen ifilang-o ah sosnod-o ya chinàcha-ar-o, ");
INSERT INTO blw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","te heno way tagu way mangamma hen laychén Ama ad uchu, chichachi agé hen sosnod-o ya chinàcha-ar-o.” ");
INSERT INTO blw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Angkay hen hiyachiy ag-agaw chillu, ginumhad ah Jesus yag i tummùchu hen anchi penget hen fayfay way i mantudtuchu hen tatagu. ");
INSERT INTO blw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yag gapo ta anchag chuar hen anchichay nangamong an hiya, i tummùchu hen anchi fangka yag atàtàchégcha hen anchichay tatagu hen anchi tarantag. ");
INSERT INTO blw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yachi yag inlugina way mampani way chuar hen intudtuchuna an chicha hen nampaniyana. Ekatnéén, “Wacha anon ihay tagu way i nanmura hen anchi lotana. ");
INSERT INTO blw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yag hen anchi chana minwalehan hen fukar, ammag nemamang hen tapena hen anchi charan. Yag anchaat éméy hen anchichay kasole yag enancha amin hen anchi ininggaw hen charan. ");
INSERT INTO blw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yag hen tapen hen anchi fukar way niwaleh, nemamangcha agé hen anchi pafinatto way yapet hen lotana, yag cha-an nahen-awniyan yag hommangawcha gapo hen anchi aketay lotana. ");
INSERT INTO blw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ngém yachi way ummini-init, anchaat agég nàrong te akettoy hen anchi lota wat maid lomamotancha, wat anchag narango amin. ");
INSERT INTO blw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yag hen tapen anchi fukar agé, nemamangcha hen anchi papenagat yag lenomtàcha. Ngém angkay lommafang hen anchichay charoh way napagatan, anchag henyong hen anchi mura. ");
INSERT INTO blw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ngém hen anchichay tapen hen fukar, nemamangcha hen anchi ammayay lota yag tummufucha wat penémhéd. Wat namungacha amin way magénén hinggagsot hen fungan hen tapena, ya hen-én-ém poporo hen tapena, ya hentotlon poporo hen tapena.” ");
INSERT INTO blw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yachi yag anat ekat Jesus hen anchichay tataguwén, “Chengngaryu hen antoy penanì te naingaan-ayu, wat hamham-ényu koma hen laychéna way aryén.” ");
INSERT INTO blw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Angkay hiyachi yag émméycha hen anchichay pasorot Jesus an hiya way mangaliyén, “Pakay ammag pahig pani hen cham ekaman way manudtuchu hen anchichay tatagu.” ");
INSERT INTO blw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ya annaat esoplekar way mangaliyén, “Amin hen anchichay cha-an ma-ammuwan way mepanggép hen mantorayan Apudyusat chàyu yanggay hen mepaka-ammuwana way achi mepaka-ammu hen tapena. ");
INSERT INTO blw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Te ilanyu ngén, hen anchichay tatagu way cha omafurot yag wacha tot-owa hen ma-awatancha, tapyatapyan Apudyuschi ta chumùchùar. Waman hen anchi tagu way ammag achi omafurot, ammag maonghor hen uray anchi aket way na-awatana. ");
INSERT INTO blw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wat hen pontos-o way mangempani hen itudtuchù an chicha wat yato, te chicha, uray féféttégéncha, anchag achi chillu emamad. Ya uray agé no chachangréncha, ancha chillug cha linglingégén wat achicha ma-awatan. ");
INSERT INTO blw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wat chicha hen tommot-owaan hen anchi enalen Apudyus way ensorat hen anchi profeta way Isaias way ekatnéén, ‘Tàén anchag cha changréchangrén, achicha chillu ma-awatan. Yag tàén anchag féféttégén hen chà epàila, achicha chillu elasin no henochi. ");
INSERT INTO blw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Te cha nattoy tatagu, ammag looh chinumgat hen anchi laweng ah hamhamàcha yag kamancha agé henohorat hen ingacha ya kenekemetcha hen matacha. Te non faén koma umat hena, wat makagngarcha hen chà ifaga, ya makailacha hen chà epàila, yag ma-awatancha agé hen usto, wat kapeletan way yahan manhagongancha an haén ah manga-anà hen fasorcha.’ Yahan enalen Apudyus way ensorat Isaias.” ");
INSERT INTO blw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yachi yag entoroy Jesus hen anchichay chana aryén hen anchichay pasorotna way mangaliyén, “Ngém chàyu, nagasat-ayu te makaila-ayu ya makagngar-ayu te chayu ma-awatan hen tot-owa. ");
INSERT INTO blw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yag tot-owa hen antoy ifagà an chàyu way chuarcha hen anchichay profeta ad namenghan ya anat hen anchichay na-apudyusan way tataguna way anchag laychénay térén way mangila hen antoy chayu ilan ya mangngar koma hen antoy chayu changrén ad uwan, ngém iggaycha eman maparufusan.” ");
INSERT INTO blw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Wat changrényuto,” way ekat Jesus, “te yato hen laychén hen anchi penanì way aryén mepanggép hen anchi i nanwaleh. ");
INSERT INTO blw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hen anchi charan way nemamangan hen tapen anchi fukar, chichachi hen anchichay tatagu way nangngar mepanggép hen mantorayan Apudyus ngém anchag achi pagan-ano way manmanmà ta ma-awatancha, wat émméy ah Chumunyu yag ina menaid hen anchi chengngarcha. ");
INSERT INTO blw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yag hen anchi pafinatto way nemamangan hen tapen hen anchi fukar agé, chichachi hen anchichay tatagu way layyalayyad way nangafun hen alen Apudyus hen anchaat nangngaran. ");
INSERT INTO blw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngém ammag iggay inggaw ah hamhamàcha, te an yanggay hen-aketan hen nannanma-ancha an nadchi. Te angkay inumchah hen naproblemaancha ya hen napaligatancha gapon ommafurotancha, wat anchag entagay, te iggay peet lommamot hen anchi alen Apudyus ah hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ya hen anchi papenagat way nemamangan hen anchi tapen hen fukar, chichachi hen anchichay tatagu way nangngar hen alen Apudyus ngém ammag nahyong hen chengngarcha. Te gapoh pangégcha ah mangar-ancha hen masaporcha hen antoy ataguwan ad uwan ya gapo agéh layadcha way fumaknang, wat yachi hen kaman nanyong hen hamhamàcha an Apudyus, wat ammag maid nafalinan hen afurotcha. ");
INSERT INTO blw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ngém hen anchi ammayay lota way nemamangan hen tapen hen anchi fukar, chichachi hen anchichay tatagu way nangngar hen alen Apudyus yag enafurotcha, wat wachan imfungacha way magénén hinggagsot hen tapena ya hen-én-ém poporo hen tapena ya hentotlon poporo hen tapena.” ");
INSERT INTO blw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kasen agé nampani ah Jesus way mangaliyén, “Hen mepaniyan hen anchi mantorayan Apudyus wat kaman hen ihay tagu way i nangenhamar hen anchi ammayay pagéy hen lotana. ");
INSERT INTO blw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngém angkay henlafiyan way nanasséycha amin hen tatagu, émméy agé hen anchi kafusorna yag annag i winalehan ah haphapog hen anchi nahamar ah pagéy yag lommayaw. ");
INSERT INTO blw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yachi way chachan fugi hen anchi pagéy, yag maelasinat agé hen anchichay haphapog way nè-eltà. ");
INSERT INTO blw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Wat hen anchichay alepan hen anchi nangenlota, incha imfaga an hiya way mangaliyén, ‘Apo, ay ammoh faén ustoy pagéy hen enhamartaaw hen anchi lotam, te pakay ammag chuar chi haphapogna nò no nokay hen narpowan cha nadchi.’ ");
INSERT INTO blw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wat anat ifagan hen anchi ap-apo way mangaliyén, ‘Wacha ngatay kafusor ah i nanginwaleh hen anchi haphapog.’ Yachi yag ekat hen anchichay alepannéén, ‘Wat ay laychém ta ini hònoton hen anchi haphapog.’ ");
INSERT INTO blw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngém sommongfat hen anchi ap-apo way mangaliyén, ‘Aẁ, achiyu te awni yag wachay mehlam hen anchi pagéy way mahònot. ");
INSERT INTO blw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wat yasa ta metatappecha hen anchi haphapog hen pagéy ingganah ahebtà. Yag no ahebtà, an-owat ifaga hen anchichay i mamfatà ta incha unna ka-anén hen anchi haphapog yag finédféfédfédcha way mangapoy yag anchaat i fat-én hen anchi pagéy way mangentarpén ah arang-o.’ ” ");
INSERT INTO blw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yachi yag kasen nampani ah Jesus way mangaliyén, “Hen mepaniyan hen mantorayan Apudyus wat kaman hen chumakran hen anchi ka-akettoyan way fukar way i inmuran hen ihay tagu ah garchinna. ");
INSERT INTO blw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yag tàén no ka-ak-akettoyanchi no hen aminay fukarat ammag an chummakar way yachiyat agé hen kachakkaran way mura way ammag ommaway yag i hommòfotan hen anchichay kasole hen pangapangana.” ");
INSERT INTO blw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Narpaschi yag kasen agé nampani ah Jesus way mangaliyén, “Hen iha agé way mempaniyan hen mantorayan Apudyus wat kaman hen anchi tenòtò way mangempabnar hen tenapay. Angkay inyipon hen anchi fufae hen tenòtò hen ihay awit way arina, annag empabnar hen amin anchi arina.” ");
INSERT INTO blw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ammag pahig pani hen inyusar Jesus way nangintudtuchu hen aminay intudtuchuna hen tatagu, te maid intudtuchuna an chicha ah iggayna an epani. ");
INSERT INTO blw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yahan enkamanna ah tomot-owaan hen anchi imfagan hen profeta ad namenghan way ekatnéén, “No wachan ifagà an chichéén anà an mampani way mangimfaga way yachi hen ekaman-o way mangintudtuchu hen anchichay cha-an ma-am-ammuwan nanepod hen na-ammaan hen antoy lota ingganad uwan.” ");
INSERT INTO blw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Angkay hiyachi way tenaynan Jesus hen anchichay tatagu, hinénggép ah faréy yag ummunudcha agé hen anchichay pasorotna way mananhan an hiya way mangaliyén, “Heno man hen laychén hen anchi penanim way aryén mepanggép hen anchi haphapog way niwaleh hen anchi lota.” ");
INSERT INTO blw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yag anat esoplekar Jesus an chicha way mangaliyén, “Hen miyaligan hen anchi i nanhamar hen anchi ustoy pagéyat haénchi way Pangorowan hen Tatagu. ");
INSERT INTO blw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yag hen anchi minur-ana, yachi hen antoy lota. Ya hen anchi ustoy pagéy agé, chichachi hen anchichay ustoy metape hen mantorayan Apudyus. Waman hen anchi haphapog, chichachi hen anchichay tatagu way metape an Chumunyu. ");
INSERT INTO blw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yag hen anchi kafusor way nanginwaleh hen anchi haphapog, wat yachi ah Chumunyu. Yag hen miyaligan agé hen anchi ahebtà wat yachi hen kaman anongoh hen ag-agaw hen antoy lota. Ya anat agé hen anchichay mamfatà, chichachi hen anchichay anghel Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yag hen anchi nekaman hen anchi haphapog way ammag na-among yag netap-ar hen iggaw apoy, wat kaman agéhchi hen ma-ammaan hen tatagu hen anchi anongoh hen ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te haén way Pangorowan hen Tatagu, hénagê hen anchichay a-anghel-o way i mangamong amin hen anchichay tatagu way cha mangamma hen fumasoran hen tapena ya hen anchichay cha mangam-amma hen laweng ta mat-éncha ");
INSERT INTO blw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","way incha metap-ar hen anchi ammag cha gumilagilab way apoy, ta ahchi hen mapàpàgangancha way magénén mankelakelacha ya manngangalitféncha hen fub-acha ah kaligatna. ");
INSERT INTO blw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Waman hen anchichay tatagun Apudyus, anchag kaman init way cha humili hen mì-iggawancha hen mantorayan Amacha way Apudyus.” “Chengngaryu hen antoy chà ifaga te naingaan-ayu wat papannaagényu koma.” ");
INSERT INTO blw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kasen agé nampani ah Jesus way mangaliyén, “Hen miyaligan hen anchi mantorayan Apudyusat kaman hen anchi faletò way netataro hen ihay lota. Angkay inchahan hen ihay taguchi, annag inép-épan way ammag lommaylayad yag ina enlao hen aminay kok-owana yag annaat i làwan hen hiyachi paat way lota.” ");
INSERT INTO blw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ya hen ihay mepaniyan hen anchi mantorayan Apudyus agéat, kaman hen anchi chan ah-ahente ah haleppon way chan ana-anap ah làwana ah am-ammay way perlas. ");
INSERT INTO blw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yag yachi way inchahana hen ihay perlas way ammag napateg way térén, annag i enlao amin hen anchi kok-owana yag ina lenàwan hen hiyachi paat way perlas.” ");
INSERT INTO blw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Entoroy Jesus way mangaliyén, “Hen mepaniyan hen anchichay metape hen mantorayan Apudyus agéat kaman hen mangempetla-ancha hen tafukor hen fayfay yag ammag maid achi wachah gachiw ah nàna. ");
INSERT INTO blw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Angkay hiyachi way napno, finugwahcha way nanginyéy hen anchi tarantag yag intùchucha way mamele hen anchichay anammay way gachiw yag iniggacha ah awit. Waman hen anchichay laweng, anchag entap-ar. ");
INSERT INTO blw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wat kaman agéhchi hen ma-ammaan hen anchi anongoh chi ag-agaw, te umalecha hen anchichay a-anghel way mangamong hen anchichay laweng way tatagu ta mat-éncha hen anchichay ammayén Apudyus, ");
INSERT INTO blw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yag entap-archa chicha hen iggaw hen anchi ammag cha gumilagilab way apoy way yachi hen mapàpàgangancha way magénén mankelakelacha ya manngangalitféncha hen fub-acha ah kaligatna.” ");
INSERT INTO blw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Angkay hiyachi yag anat ekat Jesus hen anchichay pasorotnéén, “Ay na-awatanyu amin cha nadchi.” “Oo,” way ekatcha, “na-awatanni.” ");
INSERT INTO blw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yag annaat ekat agéén, “Hen anchichay siguchay cha mintudtuchu hen orchin Moses, non paat ancha afuroton hen chà itudtuchu mepanggép hen mantorayan Apudyus wat anchag kaman hen anchi tagu way kompleto hen kok-owana way nangila hen ekamanna way mangusar hen anchichay chacha-an way tenawidna, yag innilana agé way mangusar hen anchichay kà-ara.” ");
INSERT INTO blw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Angkay hiyachi way narpas hen anchichay penanin Jesus, lommayaw an nadchi ");
INSERT INTO blw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yag hommàyat ah fabréycha ad Nazaret. Yag angkay ahchi, émméy nantudtuchu hen anchi sinagoga way chacha ma-am-amongan. Yag hen anchichay na-among way tatagu, anchag nahahaang hen nangngarancha an hiya, yag ekatchéén, “Heno ay hen i nangacharan nahha ah kenaraengna, ya pakay agé amin maka-amma ah kaskascha-aw. ");
INSERT INTO blw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Te ay ammoh faén anà hen an lawag karapenteroha way ah Maria agé hen inana ya cha Jaime an cha Jose an Simon yah Judas hen sosnodna. ");
INSERT INTO blw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ya antochayan kay agé yà hen aminay sosnodna way finufae. Wat nokay lawa hen ina nangar-an an cha nahha nò.” ");
INSERT INTO blw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wat ancha ammag achi mangiggéén hiya. Yachi yag anat ekat Jesus an chichéén, “Tot-owa way uray heno way fabréy way ayan hen profetan Apudyus wat ririspituwén hen tatagu hiya way manongad yanggay hen anchichay kakailiyana ya hen ahimfafaryanna paat ah achi manrispitu an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wat hiyachi, ammag an aket yanggay hen enammaan Jesus way kaskascha-aw ahchih fabréycha te anchag achi chillu omafurot. ");
INSERT INTO blw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Angkay hen hiyachiy tempo, chengngar Herod way toray hen Galilea hen mepanggép hen anchi cha ammaan Jesus, ");
INSERT INTO blw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yag annaat ifaga hen anchichay opisyarna way mangaliyén, “Ah Jesusanna, hiyaha angkay ah Juananchi way chan funfunyag way an nan-uchi, te pakay magénén makafael way mangamma hen annachay kaskascha-aw nò.” ");
INSERT INTO blw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Hen nangaryan Herod an nadchi, te hiya hen nangan-a an Juan way hen nekaman, enamhew Juan ah Are Herod way mangaliyén, “Maid karébféngam way ammag mamréh an Herodiasanna te hiyan ipagno way ahawan enawchim way Felipe.” Ngém ah Arey Herod, gapo ta laychéna chillu way mangahawa an Herodias, annag empatelew ah Juan yag imfarudna. ");
INSERT INTO blw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yag annag laychén paat way mangempapchit an hiya hen hiyachi, ngém cha-anna gapoh pangégna hen anchichay Judio, te hen kachùran hen anchichay Judio, ekatchéén profetan Apudyus ah Juananchi. ");
INSERT INTO blw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ngém angkay hiyachi way inumchah hen anchi ag-agaw way manayawancha hen niyana-an Are Herod, émméy hen anchi anà Herodias way fafarasang way i nansas-ara hen sangwanan cha Herod ya hen anchichay ifana way nan-angato. Ammag naragsakan way térén ah Herod, ");
INSERT INTO blw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","wat annag emposta hen anchi fafarasang way mangaliyén, “Esapatà an hea way uray heno way chawatém an haénat idchat-o way idchat.” ");
INSERT INTO blw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wat hen anchi fafarasang, gapon anchi intugun inana, yag annaat ekat an Areyén, “Idchatno an haén ad uwananto paat hen fat-ag Juan way chan funfunyag way mepapattang hen hachang.” ");
INSERT INTO blw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ammag ngommehpéy ah Are Herod, ngém gapo ta loohna ensapata yag chana agé ifiin hen amin anchichay mangilina, wat annag imfaga way midchat hen anchi cha chawatén hen anchi fafarasang. ");
INSERT INTO blw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yag annaat epahiwat ah Juananchi ah pagfaruchan, ");
INSERT INTO blw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","yag inyéycha hen anchi fat-agna way nahahadchang way i nangidchat hen anchi fafarasang. Yag hen anchi fafarasang agé, inyéyna an inana. ");
INSERT INTO blw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yachi yag émméy hen anchichay pasorot Juan way i nangara hen anchi acharna yag incha inlufù yag anchaat i haphapetén an Jesus hen anchi na-ammaan. ");
INSERT INTO blw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Angkay hiyachi way chengngar cha Jesus hen anchi nekaman an Juan, lommayawcha an nadchi way incha nanlugan hen fangka way gumchang hen fayfay ta icha koma omanggay hen anchi lugar way maid tatagu. Ngém hiyachi, nanhemamag chillu ah kafabréfabréy hen émméyancha, wat anchag ummunud hen anchichay tatagu way ancha an chinaran way nangwa hen tarantag. ");
INSERT INTO blw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Angkay cha tomàchang cha Jesus hen anchi fangka yag innilanaat agé hen anchichay ammag chuar way tatagu, yag ammag naség-angan way térén an chicha, wat annaat ka-anén hen sasaket hen amin anchichay cha masaket. ");
INSERT INTO blw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Angkay hiyachi way cha madhém, imfagan hen anchichay pasorotna an hiya way mangaliyén, “Aẁ, ammag cha madhém yag maid fabréy ahto, wat ammay ménat no ifagam hen annachay tatagu ta homàyatcha hen annachay fafabréy ta inchan ilah manganancha.” ");
INSERT INTO blw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ngém hen ekat Jesus, ekatnéén, “Achi koma masapor chicha hen i man-anap, ta uray chàyu koma hen mamangan an chicha.” ");
INSERT INTO blw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Oo a,” way chacha ekat, “ngém an yanggay lemay tenapay hen antoyan ya anat hen antoy chuway files.” ");
INSERT INTO blw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yag ekat Jesusén, “Wat iyaliyuhto hen annay wacha.” ");
INSERT INTO blw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yag annaat ifaga hen anchichay tatagu ta tumùchucha hen anchi ngudngud. Yachi yag innarana hen anchi lemay tenapay ya anat hen anchi chuway files yag nantangad ad uchu way manyaman an Apudyus, yag annaat petpet-angén amin way mangidchat hen anchichay pasorotna ta iwarascha hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yachi yag nangancha amin hen anchichay tatagu ingganah nagipohcha amin. Yag angkay nagipohcha, enamong hen anchichay pasorotna hen fay-ancha yag ammag napnowat agé hen hemporo ya chuway awit. ");
INSERT INTO blw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yag hen anchichay tatagu way nangan, émméy ah lemanlifu way anggay yanggay hen anchichay larae ah nafilang te iggaycha netape hen anchichay finufae ya ungunga way nafilang. ");
INSERT INTO blw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Angkay narpas hen namanganan Jesus hen anchichay tatagu, imfagana hen anchichay pasorotna ta manlugancha hen anchi fangka ta uray epangpangocha way gumchang ta an umunud no epaligwatna hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Angkay hiyachi way lommayawcha hen anchichay tatagu wat ommanggay ah Jesus way i manluwaru hen anchi tagéytéy. Yag yachi way cha homelang, é-éttég Jesus hen anchi tagéytéy. ");
INSERT INTO blw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Waman hen anchichay pasorotna way nanlugan hen anchi fangka, ommachawwéycha te nan-agginawacha hen anchi fayfay. Yachi yag hinib-atcha hen anchi séréchay fali, wat ammag cha mihibyahibyat hen anchi fangkacha. ");
INSERT INTO blw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Angkay hiyachi way chan penen-et, cha umunud ah Jesus an chicha way annag cha charanén hen uhun hen chanum. ");
INSERT INTO blw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yag hen nangil-an hen anchichay pasorotna hen chana manaranan hen anchi uhun hen chanum, anchag émmégyatay térén te ekatchéén fanig, wat nan-ongawcha. ");
INSERT INTO blw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yag nan-aleyat ah Jesus way mangaliyén, “Achiayu cha émégyat te haénto, wat papegséényu hen hamhamàyu.” ");
INSERT INTO blw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sommongfatat agéh Pedro way mangaliyén, “Apo, no hea tot-owaha, wat idchatno hen kafaelà ta charanê agé hen antoy chanum way umale an hea.” ");
INSERT INTO blw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Umalea kaỳ,” way ekat Jesus. Yag nampangagéhad tot-owa ah Pedro yag nanaran hen anchi uhun hen chanum way éméy an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngém yachi way nalènana hen kaséréd hen anchi fali, ammag narmuwat agé hen égyatna yag chanaat agé ilugi way malihéd, wat ammag nan-ongaw way mangaliyén, “Apo, aranà!” ");
INSERT INTO blw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yachi yag lenapchuat Jesus hiya yag ekatnéén, “Ay korang peet hen pammatem an haén te pakay cha-an chuwachuwa.” ");
INSERT INTO blw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yachi way hinénggépcha way chuwa hen anchi fangka yag nafég-asat hen anchi fali. ");
INSERT INTO blw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yag amin hen anchichay pasorotna way wachah fangka, hen nangil-ancha an nadchi, ancha amin ammag chinayaw ah Jesus way mangaliyén, “Hea tot-owa hen anchi hahadchénni way anà peet Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Angkay hiyachi way ginumchangcha hen anchi fayfay way inumchahcha ad Genesaret, ");
INSERT INTO blw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","wat enlasin hen anchichay tataguhchi way yachi ah Jesus yag anchaat i tarontonon hen egachay fabréy ahchi ta iyéycha hen anchichay chan sasaket an hiya. ");
INSERT INTO blw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yag chachan pangpanga-ase an Jesus agé ta no mafalin, eparufusna koma ta uray lawa hen anchi penget hen lumfongnéén epatchàna hen anchichay chan saket. Wat amin hen anchichay cha tenomchà naka-an hen saketcha. ");
INSERT INTO blw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yachi yag wachacha hen anchichay narpod Jerusalem way tapenay Fariseo ya hen siguchay cha mintudtuchu hen orchin, yag incha imfaga an Jesus way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Apay nga cha labsengén hen annachay pasorotno hen anchi gagangaytaaw way intudtuchun hen anap-otaaw ad namenghan, te anchag an achi unuchun hen liglamenton hen mamfuruwan yag chachaat mangan.” ");
INSERT INTO blw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yag senongfatan Jesus chicha way mangaliyén, “Yag pakay agé chàyu nò wat chayu labsengén hen anchi orchin Apudyus ta hen anchi gagangay hen anyug é-égnanan. ");
INSERT INTO blw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaman hen anchi inyurchin Apudyus way ekatnéén, ‘Masapor ririspituwén hen chinàcha-ar,’ yag ‘Hen anchi manlaweng hen chinàcha-arna, masapor mepapchit.’ ");
INSERT INTO blw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yachin niyurchin ngém chàyu, chayu iwalinchi te chayu itudtuchu way uray no wachan anchi etorongna koma hen chinàcha-arna, no annag an ekatén loohna ini-idchatchi an Apudyus, ");
INSERT INTO blw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","wat mapasinsiya way uray ud-ay achina rispituwén hen chinàcha-arna way tomorong an chicha. Hen hiyaha way ma-ammaanat anyug cha iwalin hen orchin Apudyus ta hen gagangayyu paat hen é-égnananyu. ");
INSERT INTO blw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wat an-ayu peet ammag senang a-afurot. Yag ammag tot-owa hen anchi enalen Apudyus ad namenghan mepanggép an chàyu way ensorat hen anchi profetay Isaias way ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Chichatoy tatagu, ammag ah tapàcha yanggay hen iggaw hen manayawancha an haén ngém ammag maid awanwani ah hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wat ammag maid sérfina hen chacha manayawan an haén, te chacha itudtuchu hen anchi narpo yanggay ah hamhamà hen tatagu way anchag penarang way ekatchéén narpochi an haén.’ ” ");
INSERT INTO blw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yachi way enalen Jesuschi yag annaat ayagan hen anchichay chuaray tatagu yag ekatnéén, “Papannaagényu hen antoy ifagà ta ma-awatanyu koma. ");
INSERT INTO blw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Faén angkay hen anchi éméy ah tapà hen tatagu way maùmun hen mangemparaweng an hiya an Apudyus, te hen mangemparaweng hen tatagu an Apudyusat hen anchi marpoh tapàna way miyale.” ");
INSERT INTO blw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Angkay na-awni yag émméy hen anchichay pasorot Jesus an hiya way mangaliyén, “Anchag nasugatan angkay hen anchichay Fariseo hen nangngarancha hen annay enalem.” ");
INSERT INTO blw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yag senongfatan Jesus ah pani way mangaliyén, “Hen heno way mura way faén ah Ama ad uchu hen nanginmura wat mahònot chachi chillu. ");
INSERT INTO blw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wat hiyachi, achiayu machanagan an chicha te ancha chillug kaman nabfurag way cha pachangén hen nabfurag agé. Yag kapeletan no tudtuchuwan hen anchi maid innilana hen anchi maid agé innilanaat anchag omfat amin way yachi hen mekobfangancha.” ");
INSERT INTO blw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yachi yag nan-ale agéh Pedro way mangaliyén, “Nokay uwa hen laychénay aryén hen anchi penanim mepanggép hen mangemparaweng hen tatagu an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yag anat ekat Jesusén, “Ay kaman-ayu peet hen annachay tapena way iggayyu agé ma-awatan. ");
INSERT INTO blw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ilanyu ngén, hen aminay éméy ah tapà yag inùmun hen tagu, éméy ah poto yag ah awni, fùnag chillu. ");
INSERT INTO blw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Waman hen anchi iyalen hen tatagu, narpochi ah hamhamàna yag yachi hen mangemparaweng an hiya an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Te hen hamhamà, yachi hen marpowan hen aminay laweng way kaman hen pomatéy ya chumagchagas ya hen mangammah lenoroko. Ya umat agé hen mangakaw ya mankétém ya anat agé hen man-usot. ");
INSERT INTO blw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chichato hen mangemparaweng hen tatagu an Apudyus way faén agé hen anchi achi manorachan hen liglamenton hen mamfuruwan, te achi lawengén Apudyuschi.” ");
INSERT INTO blw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Angkay hiyachi way lommayaw ah Jesus an nadchi, émméy hen anchi lugar way sakopon hen Tiro ya Sidon. ");
INSERT INTO blw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yag wachan ihay in-ina way eCanaan way faén Judio way fummabréy ahchi, yag émméy an Jesus way chan pangpanga-ase way mangaliyén, “Apo way ganà Arey David, ség-anganà koma te wachan anchi anào way fafarasang way nahurugan ah ongtan wat cha maligatan.” ");
INSERT INTO blw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngém iggay senongsongfatan Jesus hiya. Yachi yag i enà-arò hen anchichay pasorot Jesus hiya way mangaliyén, “Uray ud-ay ammaam hen chana chawatén ta lomayaw te ammag hometang way cha umunu-unud an chitaaw.” ");
INSERT INTO blw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yag anat somongfat ah Jesus way mangaliyén, “Oo a, ngém hen pontos hen nahnagà hen antoy lota, wat hen anchichay ganà Israel yanggay te anchag kaman nattafaw way karnero, yag faén hen anchichay safaliy tatagu way faén Judio.” ");
INSERT INTO blw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngém inlurud chillu hen anchi in-ina wat ammag i nampalentomang hen henagong Jesus way mangaliyén, “Apo, toronganà paat.” ");
INSERT INTO blw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Senongfatan Jesus ah pani way mangaliyén, “Ay ammoh mafalin way ammag aran hen anén hen a-anà yag inidchat hen anchichay aho ta chicha hen pés-éy mangan.” ");
INSERT INTO blw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yachi yag na-awatan hen anchi in-ina way achi koma matorongan hen anchichay faén Judio unna, te hen Judio paat hen pés-éy matorongan koma. Yag annaat ekatén, “Oo, tot-owa Apo hen annay enalem, ngém mafalin ménat chillu anén hen aho hen anchi lawa fugtan hen a-anà.” ");
INSERT INTO blw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yag anat ekat Jesusén, “Ammag chakar tot-owa hen pammatem an haén, wat ma-ammaan hen annay cham chawatén.” Yag hen hiyachiyat agé lommayaw tot-owa hen anchi nihuhurug hen anchi anàna wat ommammay. ");
INSERT INTO blw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Angkay lommayaw ah Jesus an nadchi, enengwana hen anchi penget hen fayfay way Galilea, yag nane-ed hen ihay tagéytéy way i tummùchu. ");
INSERT INTO blw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yachi yag ummunudcha hen anchichay ammag chuaray tatagu way manginyéy hen anchichay ifacha way namfinafinab-én hen saketcha, te wacha ay nappelay ya wacha ay nabfurag ya wacha ay nattongong ya wacha ay nappèlod. Wat amin cha natto, empasangocha an Jesus yag kena-anna amin hen anchichay sasaketcha. ");
INSERT INTO blw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wat ancha ammag nahahaang amin hen anchichay na-a-among way tatagu, te innilacha way hen anchichay nan-attongongén maka-alecha, ya hen anchichay nan-appelay ya nan-appèlochén makacharancha, ya hen anchichay nabfuragén makailacha. Wat amincha, anchag chinayaw ah Apudyus way hiya chillu hen ommapowan hen anchichay ganà Israel. ");
INSERT INTO blw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yachi yag enayagan Jesus hen anchichay pasorotna way mangaliyén, “Chaà maség-angan way mangi-ila hen antochay tatagu te ammag petlona ad uwan way ag-agaw ah nì-i-iggawancha an chitaaw, yag na-amin hen faroncha wat maid anéncha. Yag achì laychén way ammag mangempaligwat an chicha way homàyat no achicha mangan unna, te magat lawa mahigngéncha hen charan.” ");
INSERT INTO blw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","“Oo tot-owa Apo,” way ekat hen anchichay pasorotna, “ngém nokay lawa hen intaaw umar-an ah érégnah epangantaaw hen antochay ammag chuar way tatagu, te maid met fabréy hen antoy ini-inggawantaaw.” ");
INSERT INTO blw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yachi yag senarudsud Jesus an chicha way mangaliyén, “Kamana hen tenapay way wachan chàyu.” “An yanggay pitu ya anat hen aketay files way a-anakettoy,” way ekat hen anchichay pasorotna. ");
INSERT INTO blw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yachi yag imfagan Jesus hen anchichay tatagu ta tumùchucha, ");
INSERT INTO blw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","yag annaat aran hen anchi pituy tenapay ya hen anchi files yag nanyaman an Apudyus. Yachi yag penetpet-angna yag inidchatna hen anchichay pasorotna ta iwarascha hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yag nanganangan amin hen anchichay tataguingganah nagipohcha. Yachi yag enamong hen anchichay pasorot Jesus hen anchi fay-ancha, yag ammag napnowat agé hen pituy awit. ");
INSERT INTO blw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ya hen anchichay nangan, émméy ah opatlifu hen anchichay lenarae yanggay way cha-an mafilang hen anchichay finufae ya ungunga. ");
INSERT INTO blw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Angkay hiyachi yag empaligwat Jesus hen anchichay tatagu, yag anchaat manlugan cha Jesus hen anchi fangka way émméy hen sakopon hen Magadan. ");
INSERT INTO blw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Angkay hiyachi yag wachacha hen émméy an Jesus way Fariseo ya Saduceo way hen gagaracha, icha pachasén way manlokop an hiya. Wat imfagacha ta omenpàila ah kaskascha-aw ah manot-owaancha no ah Apudyus hen nannag an hiya. ");
INSERT INTO blw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ngém senongfatan Jesus chicha ah pani way mangaliyén, “No cha madhém yag nanlidlidchaga, elasinyu hen laychénay aryén way ammay hen ag-agaw ah wakas, yag ammay tot-owa. ");
INSERT INTO blw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yag no pomaway agé, no cha manlidlidchaga yag chan lomot, wat elasinyu agé hen chana isinyar way umuchan, yag umuchan tot-owa. Wat pakay makelasin-ayu hen sinyar hen ka-ammay hen ag-agaw yag an-ayug achi makelasin hen cha isinyar Apudyus hen antoy cha mepasamak ad uwan. ");
INSERT INTO blw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Chàyu way tatagu ad uwan, an-ayug térén way laweng te anyug nanchùgan ah Apudyus, yag chàyuwat agé hen cha manganap hen kaskascha-aw way manginsinyar hen kasasa-ad-o. Ngém maid angkay mepàila an chàyu ah sinyar no faén yanggay hen anchi kaman hen na-ammaan an Jonas ad namenghan.” Enalen Jesuschi yag anat lomayaw way nanaynan an chicha. ");
INSERT INTO blw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Angkay hiyachi way ginumchang cha Jesus hen chumang hen anchi fayfayanchi, hemhemmà hen anchichay pasorotna way naliw-ancha uwa way ummara ah faroncha. ");
INSERT INTO blw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yachi yag ekat Jesus an chichéén, “Ar-arwachanyu hen tenòtò hen anchichay Fariseo ya Saduceo ta achiayu maipowan.” ");
INSERT INTO blw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yag hen anchichay pasorotna, hemhemmàcha hen anchi tenòtò way mausar ah tenapay wat chachan a-atopàpà way mangaliyén, “Aẁ enalena ménatha te naliw-antaaw way umarah farontaaw.” ");
INSERT INTO blw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ngém ammun chillu Jesus hen anchi chachan a-atopàpa-an yag annaat ekatén, “Pakay lawa anggay hen maid anéntaaw yag in-ayu machanagan ta anggay haén chayun atopàpa-an. Ay anyug achi peet chillu manchinlan haén. ");
INSERT INTO blw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ay ammoh achiyu peet chillu ma-awatan hen kafaelà. Ay naliw-anyu hen anchi lemay tenapay way empangan-o hen anchichay nasorok ah lemanlifu way tatagu. Yag kamanay awit hen enamongyu way nahawar. ");
INSERT INTO blw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ya umat agé hen anchi pituy tenapay way empangan-o hen anchichay nasorok ah opatlifu way tatagu, yag kamana agé chillu hen enamongyu way nahawar. ");
INSERT INTO blw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Wat pakay anyug achi chillu ma-awatan way faén ma-an hen chà aryén. Te hen laychê way aryén an chàyu wat hen mangarwachanyu hen anchi kaman tenòtò way cha iyipon hen anchichay Fariseo ya Saduceo hen anchi ustoy mitudtuchu.” ");
INSERT INTO blw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yag hen hiyachi, na-awatan hen anchichay pasorot Jesus way faén peet hen anchi tenòtò way miyipo ah ma-an hen cha aryén Jesus, te hen laychénay aryénat ar-arwachancha hen anchi nat-én way cha itudtuchun hen anchichay Fariseo ya Saduceo way chacha ahrangan hen anchi ustoy cha mitudtuchu. ");
INSERT INTO blw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Angkay hiyachi way inumchah cha Jesus hen sakopon hen anchi chakaray fabréy ad Cesarea Filipos, yag annaat hanhanan hen anchichay pasorotna way mangaliyén, “Nokay hen hamhamà hen tatagu an haén way Pangorowan hen Tatagu no henowà ngata.” ");
INSERT INTO blw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yag anchaat ekatén, “Hen ekat hen tapena, hea ano ah Juananchi way chan funfunyag way an nan-uchi. Waman hen tapena, ekatchéén hea ano ah Elias way kasen ummale. Ya ekat hen tapenéén hea ano ah Jeremias no faén hea hen ihay safaliy profeta way an kasen natagu.” ");
INSERT INTO blw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yag anat ekat Jesus an chichéén, “Ngém chàyu kaỳ, nokayà agé nò ah manmanmàyu.” ");
INSERT INTO blw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Yag sommongfat ah Simon Pedro way mangaliyén, “Hea hen anchi Cristu way empopostan Apudyus way umaley mantoray, te hea hen anà paat hen anchi natattagu way Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yag sommongfat ah Jesus way mangaliyén, “Heay Simon way anà Juan, lomaylayad-a te faén tatagu hen nangempaka-ammun nahha an hea, te ah Amay Apudyus way wacha ad uchu hen nangempahpahmà. ");
INSERT INTO blw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yag heay Pedro, kaman-a fato. Te hen annay inyalem way mepanggép an haénat, yachi hen kaman pégnad te yachi hen masapor afuroton hen aminay tatagu. Wat yachi hen manà-achà hen egachay omafurot an haén. Yag gapon kenakénég hen nasà-achancha, wat ammag maid maka-afà an chicha way uray hen matéyan. ");
INSERT INTO blw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yag piyarê agé hea way mangchén hen torfek way mam-at hen anchi mantorayan Apudyus ad uchu. Wat hen anchi epawam hen antoy lota, mepawa agé ad uchu. Yag hen anchi eparufusno hen antoy lota, meparufus agéchi ad uchu.” ");
INSERT INTO blw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yachi hen imfagan Jesus yag annaat téngténgén hen anchichay pasorotna ta achicha ifagfaga way hiya hen anchi Cristu way empopostan Apudyus way umale. ");
INSERT INTO blw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nanepod hen hiyachiy tempo, inlugin Jesus way mangimfaga hen anchichay pasorotna hen ma-ammaan an hiya. Ekatnéén, “Masapor éméyà ad Jerusalem yag mapàpàgangà ahchi, te pàpàgangénà hen anchichay anam-ama way ponò hen Judio ya anap-apon hen pachi ya hen anchichay siguchay cha mintudtuchu hen orchin Moses, yag ana-at agé epapchit. Ngém hen anchi ma-atlo way ag-agaw wat man-uchiyà chillu.” ");
INSERT INTO blw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yachi yag nan-iyéyat Pedro hiya hen ê-éyna yag annag enamhew way mangaliyén, “Apo, achi paat koma mafalin parufusun Apudyus way ma-ammaanha an hea.” ");
INSERT INTO blw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yachi yag nanhagong ah Jesus an Pedro way mangaliyén, “Lomayaw-aat Chumunyu, te annog cha awisén haén way achì mangamma hen laychén Apudyus. Te hen hiyahay hamhamàno, faén hamhamà Apudyus te ammag hamhamà yanggay hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yachi yag anat ifagan Jesus hen anchichay pasorotna way mangaliyén, “Heno way tagu way manlayad way somorot an haén, masapor faén hen ataguwana hen antoy lota hen epapangégna, te masapor ammaana paat hen laychê way uray yachin iyatéyna. ");
INSERT INTO blw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Te heno way tagu way mangempapangég hen ataguwana hen antoy lotaat matéy chillu. Waman hen anchi tagu way ammag achi mangempangég hen matéyana gapon afurotna an haén, wat uray matéy, midchat an hiya hen kasen ataguwan way mannanayun. ");
INSERT INTO blw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Te nokay lawa hen sérfina no ammag kok-owéén hen ihay tagu hen aminay ininggaw hen antoy lota no ah awni yag etatap-ar chillu Apudyus hiya. Te maid angkay narégna ah uray heno way kafinaknang hen tatagu ah ifayadna hen mètaguwana an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Te haén way Pangorowan hen Tatagu, kasenà mamfangad ah pegwana way etnochà hen anchichay a-anghel-o ya humiliyà agé hen kaenammay Amay Apudyus. Yag hiyachi hen mangidchatà hen assong hen aminay enammaan hen katagutagu. ");
INSERT INTO blw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yag tot-owa hen antoy ifagà way wachacha hen tapena an chàyu ad uwananto way achi matéy ingganah ilancha hen manginlugiyà way mantoray, haén way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Angkay hiyachi way nanlooh hen énémay ag-agaw, enayagan Jesus cha Pedro an cha Jaime an Juan way hen-agi, yag incha ommanggay hen anchi akayyang way filig. ");
INSERT INTO blw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Angkay hen ininggawancha ahchi, ammag sommafali hen achar Jesus hen nangil-ancha an hiya way ammag cha humili hen féharna way kaman init, ya hen anchi lumfongna agé wat ammag pommokaw way térén way cha humili way kaman helaw. ");
INSERT INTO blw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yag hen hiyachi, innilacha way ammag niya-ahachat agé cha Moses an Elias way chacha mètagépfar an hiya. ");
INSERT INTO blw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yag ammag nan-ale agé ah Pedro way mangalen Jesusén, “Apo, ammay ta wachataaw ahto, wat no laychém, omamma-ani ah toroy fawi ta màmàchang-ayu an cha Moses yah Elias.” ");
INSERT INTO blw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","É-éttég Pedro way chan ale yag anchag nanépnépan ah cha humili way funat. Yag chengngarcha hen anchi chan ale way narpon anchi funat way ekatnéén, “Yato hen anchi laylaychê way Anào way cha mangemparaylayad an haén, wat changrényu hiya.” ");
INSERT INTO blw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hen nangngaran hen anchichay pasorot Jesus hen anchi nan-ale, anchag nanlùfub gapoh amchan hen égyatcha. ");
INSERT INTO blw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yachi yag émméy ah Jesus way i nanchà an chicha way mangaliyén, “Fumangon-ayu ta achiayu cha émégyat.” ");
INSERT INTO blw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yag anchaat mammuhwat yag ammag anggayat agéh Jesus ah wà-acha. ");
INSERT INTO blw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Angkay hiyachi way chachan éhég, cha tugunun Jesus chicha way mangaliyén, “Achiyu kay paat cha ifagfaga ah tapena hen anchi innilayu ingganah man-uchiyà way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yachi yag anat agé hanhanan hen anchichay pasorot Jesus an hiya way mangaliyén, “Pakay uwa ekat hen anchichay siguchay cha mintudtuchu hen orchinén, ‘Masapor kasen umale ano unna ah Elias way profeta yag an-aat agé umale way Cristu way empopostan Apudyus.’ ” ");
INSERT INTO blw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yag ekat Jesusén, “Oo, tot-owa way mamangpango ah Elias way mangensagana hen hamhamà hen tatagu ta elasincha ah Cristu. ");
INSERT INTO blw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngém ah katot-owana looh angkay namangpango ah Elias way ummale, ngém iggay ematonan chillu hen tatagu hiya, wat anchag enammaan hen laylaychéncha an hiya. Yag yachi agé hen ekamancha an haén way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yachi way enalen Jesuschi yag anat ma-awatan hen anchichay pasorotna way ah Juan peet way chan funfunyag hen chana aryén. ");
INSERT INTO blw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Angkay hiyachi way inumchah cha Jesus hen iggaw hen anchichay na-a-among way tatagu, wacha hen ihay am-ama way émméy an hiya yag nampalentomang hen anchi henagongna way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo, ség-angam koma hen anchi anào te cha màorchah ya cha mapaligatanay térén, te kankanayén way mantap-ar hen apoy ya hen chanum no gìnéénachi. ");
INSERT INTO blw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inyéy-o hiya hen anchichay pasorotno ngém anchag achi makaka-an hen saketna.” ");
INSERT INTO blw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sommongfat ah Jesus way mangaliyén, “Chàyu way tatagu ad uwan, ammag pararo hen enomfatanyu. Te pasagchi ah nì-i-iggawà an chàyu ya an chillug maid afurotyu. Kamana kay ah anoh-o an chàyu yag an-ayu chillug achi omafurot. Iyaliyuhto hen annay onga.” ");
INSERT INTO blw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yachi yag menanchar Jesus hen anchi nihuhurug way ongtan wat lommayaw yag naka-anat tot-owa hen saket hen anchi onga. ");
INSERT INTO blw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Angkay na-awni way anggay ah Jesus, i henanhanan hen anchichay pasorotna an hiya way mangaliyén, “Pakay iggay-ani nakeparyaw hen anchi nihuhurug.” ");
INSERT INTO blw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yag anat ekat Jesusén, “Oo, te korang hen pammateyu. Tot-owa hen antoy ifagà an chàyu way no wachay pammateyu ah uray lawa akettoy way kaman hen ka-akettoy hen anchi fukar hen mostasa wat ammag maid achi mafalin an chàyu te uray anyug ekat hen antoy filigén màéy-a wat màéy tot-owa. ");
INSERT INTO blw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngém hen nihuhurug way kaman an nadchi, maid chillu makeparyaw ingganah manlangan way mangan ya manchawachawat an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Angkay na-amongcha hen amin anchichay pasorot Jesus hen provinsiyan hen Galilea, imfagana an chicha way mangaliyén, “Haén way Pangorowan hen Tatagu, tég-angay umchah hen midchatà hen anchichay tatagu ");
INSERT INTO blw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","way mamchit an haén. Ngém uray no pédténà, man-uchiyà chillu hen anchi ma-atloy ag-agaw.” Yag anchag tenomkar way térén hen anchichay pasorotna hen nangngaranchan yachi. ");
INSERT INTO blw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Angkay hiyachi way émméy cha Jesus ya hen anchichay pasorotna ad Capernaum, wachan ihay cha mangam-among ah furor hen Templo way émméy an Pedro way mangaliyén, “Hen annay apoyu, ay achina cha fayachan hen furor hen antoy Templo way faréy Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Aẁ chana met fayachan,” way ekat Pedro. Yag angkay ommanamot ah Pedro, yag nan-aleyat ah Jesus way mangaliyén, “Simon, nokay hen hamhamàno way mekaman. Heno hen mansengelan hen a-are hen antoy lota ah furor. Ay hen anchichay siguchay tataguna ono hen anchichay tatagu way funag.” ");
INSERT INTO blw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ekat Pedrowén, “Hen anchichay tatagu way funag hen mansengelana.” “Oo tot-owa,” way ekat Jesus, “wat hen laychénay aryén, maid koma fab-ayachan hen anchichay siguchay tataguna. ");
INSERT INTO blw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngém tàén no faénta funag, achi fali, fayachanta chillu ta achi lomaweng hen hamhamà hen annachay tatagu. Wat éméy-a ta in-a mamangwit hen anchi fayfay. Yag hen anchi pés-éy éném, ta-angém hen tapàna wat wacha hen ilam way pelak way érégna ah mamayadno hen furorta way chuwa. Wat aramchi yag ino finayachan.” ");
INSERT INTO blw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Angkay hen hiyachi, émméycha hen anchichay pasorot Jesus an hiya way mananhan no henokay hen anchi kangatngatowan hen anchichay tatagu way etorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yachi yag enayagan Jesus hen ihay onga yag annaat epasango an chicha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Tot-owa hen antoy ifagà an chàyu way masapor falewanyu hen hamhamàyu ta komaman hen hamhamà hen antoy onga way maid hamham-éna ah ngomatowana. Te no achiyu, wat achi angkay mafalin metapeayu hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Te hen anchi kangatowan way tagu hen mantorayan Apudyus wat hiya hen anchi mangempafafa hen acharna way kaman hen antoy onga. ");
INSERT INTO blw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yag heno way tagu agé way gapon afurotna an haén yag chana ifilang hen anchichay nafafa way tatagu way kaman hen antoy onga, wat chanaat angkay agé ifilang haén. ");
INSERT INTO blw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ngém heno way tagu way mangamma ah fumasoran hen kaman antoy onga ta manchùgana haén, wat ammag wadwadcha angkay hen machusaana ah pegwana no hen metàchan hen fato ah fagangna yag nepetlà hen fayfay ta maofor.” ");
INSERT INTO blw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Anchag kàka-ase hen tatagun antoy lota way ma-awis yag nanchùgancha ah Apudyus, ngém cha chillu ma-ammaan chaha. Ngém ammag kaskasen way ka-as-ase hen anchi tagu way ommawis ah manùgan hen pachongnay tagu an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Wat hiyachi, mag-ay ta hen laychén hen limayu way aran ono he-eyu way ayan, yag yachi hen mangammah manùganyu an Apudyus, anyug porhan yag entap-aryu. Te un-unnina angkay hen uray ud-ay an ihà-an hen lima ono he-e no antaat an mètagu an Apudyus no hen anchi wachan chuway lima ya he-e yag anta chillug metap-ar hen anchi apoy way achi madmachép ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yag no mag-ay hen i-illanyu hen mangammah manùganyu an Apudyus, anyug okatén hen matayu yag entap-aryu. Te un-unnina angkay hen uray ud-ay maid hen ihay mata no antaat an mètagu an Apudyus no hen anchi wachan chuway mata yag antag metap-ar hen anchi apoy ad imférno.” ");
INSERT INTO blw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Wat ar-arwachanyu paat ta achiyu cha pelohon hen uray heno way nafafa way tatagu way kaman hen antochay ungunga, te tot-owa hen antoy ifagà an chàyu way hen anchichay anghel way manginya-achug an chicha, chacha mèsangosango an Amay Apudyus ad uchu. ");
INSERT INTO blw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Te haén way Pangorowan hen Tatagu, hen ummaliyà hen antoy lotaat ta hara-à hen menangfasor ta achicha metap-ar hen apoy.” ");
INSERT INTO blw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Angkay enalen Jesus amin chachi, yag anat mampani way mangaliyén, “Nokay hen hamhamàyu non an umat yag wachan ihay tagu way hinggasot hen karnerona yag natarà hen iha. Ay ammoh achina taynan hen anchi siyamporo ya siyam way cha mangan ta ina anapén hen anchi ihà-an way natarà. ");
INSERT INTO blw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yag no ichahana hen anchi ihà-an way natarà, yachi paat hen memparaylayad an hiya way faén hen anchichay siyamporo ya siyam way cha-an matarà. ");
INSERT INTO blw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yag pachongna agé an Amataaw way Apudyus ad uchu te achina paat laychén way wachan uray ihà-an ah metap-ar way uray hen anchi kafafaan way tatagu.” ");
INSERT INTO blw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Entoroy Jesus way mangaliyén, “No wachay ifayu ah fummasor an chàyu, omanggay-a way éméy an hiya way i mètagépfar way mangimfaga hen anchi enammaana. Ngém ilam ta chàyu yanggay way chuwa way maid kasen. Yag no mag-ay changréna, ammay te namfangchém hen ustoy hamhamàna. ");
INSERT INTO blw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngém mag-ay ta achina changrén hea, man-ayag-a ah chuwa ono iha ah man-ifam ta kasen-ayu éméy ta ma-ammaan hen anchi nesosorat way masapor wachay toro ono chuwa ah manàchég hen tot-owa. ");
INSERT INTO blw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yag no mag-ay annag achi chillu changrén chàyu, ifagayu hen amin anchichay tapenay cha omafurot hen anchi chayu ma-am-amongan ta tomorongcha agé. Ngém no mag-ay annag achi chillu changrén hen amin anchichay ifayu, anyug ifilang hiya ah ihay achi omafurot ono kaman hen ihay nangakkaw way cha mangam-among hen furor. ");
INSERT INTO blw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Te tot-owa hen antoy ifagà an chàyu way heno way epawayu hen antoy lota, mepawa agé ad uchu. Yag hen anchi eparufusyu hen antoy lota, meparufus agéchi ad uchu.” ");
INSERT INTO blw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Yag hen ihay ifagà an chàyu agé, no wachan chawatényu an Apudyus way uray an-ayug chud-uwa, no mantempoyuganyu hen hamhamàyu way manawat, wat ammaan Amataaw ad uchu hen anchi laychényu way chawatén. ");
INSERT INTO blw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te uray no an yanggay toro ono chuwa hen ma-among gapoh afurotcha an haén, wat wachaà agé way nìya-among an chicha.” ");
INSERT INTO blw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Angkay hiyachi yag henanhanan Pedro an Jesus way mangaliyén, “Apo, kamana kay hen masapor an-og cha mamakapakawanan hen fummasoran hen ifà an haén. Ay ingganah mangappitu.” ");
INSERT INTO blw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Achì ekatén an yanggay ammag mangappitu,” way ekat Jesus, “te mangappiappitu hen mamakawanam an hiya. ");
INSERT INTO blw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Te yato hen ekaman hen anchi mantorayan Apudyus ad uchu way hen mepaniyana, kaman hen ihay Are way nannanmà way manotar hen utang hen anchichay o-opisyarna.” ");
INSERT INTO blw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Angkay hiyachi way chana ilugi way mantotar, inyéycha an hiya hen ihay opisyar way nan-utang an hiya ah kalifulifuna. ");
INSERT INTO blw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yag gapo ta achi makafayad hen anchi utangna, imfagan hen anchi are way masapor melaocha amin way himfafaryan ah alepan, ya melao agé hen aminay kok-owacha ta yachi hen manobfotna hen utangna. ");
INSERT INTO blw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wat ammag nampalentomang hen anchi opisyaranchi hen henagong Are way mampangpanga-ase way mangaliyén, ‘Apo, pangpanga-asem paat ta wayanà way man-anap ah mamayad-o, wat fayachà amin hen utang-owanchi.’ ");
INSERT INTO blw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngém ammag gapoh ség-ang Are an hiya, annag penakawan amin hen anchi utangna way ammag nilibli.” ");
INSERT INTO blw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ngém angkay hiyachi way lommayaw hen anchi opisyaranchi ah faréy Are, hinib-atnaat agé hen ihay ifana way opisyar way nakautang an hiya ah hinggasot yanggay. Yag annaat agég lenapchù hiya way mankar way mangaliyén, Masapor fayachamat amin hen anchi inutangno an haén. ");
INSERT INTO blw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ammag nampalentomang agé hen anchi ifana way mampangpanga-ase way mangaliyén, ‘Panga-asem paat ta wayanà way man-anap ah mamayad-o wat fayachà tot-owa.’ ");
INSERT INTO blw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngém annag achi ség-angan hiya te hen enkamanna, empafarudna ta inggana anoh fayachana amin hen anchi utangna.” ");
INSERT INTO blw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Angkay innilan hen anchichay ifana way o-opisyar hen enkamanna hen anchi ihay ifana, ammag lommaweng hen hamhamàcha yag anchaat i elepot an Are hen aminay enkamanna. ");
INSERT INTO blw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yag anat epa-ayag Are hiya way mangaliyén, ‘An-ag laweng way tagu way ammag maid sérfin hen kenasérfisyum. Te haén, penakawan-o amin hen anchi chakaray utangno gapo yanggay hen chawatno, ");
INSERT INTO blw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","wat pakay annog iggay ség-angan hen ifamanto way kaman hen enkaman-o an hea.’ ");
INSERT INTO blw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ammag amchan hen aningarngar hen anchi are wat empafarudna hiya ta mapap-aligatan ingganah fayachana amin hen anchi utangna.” ");
INSERT INTO blw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yachi yag anat ekat Jesusén, “Kaman agéhchi hen ekaman Ama ad uchu an chàyu no achiyu pakawanén hen fummasoran hen ifayu an chàyu way masapor ammag maid un-unongonyu.” ");
INSERT INTO blw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Angkay narpas way intudtuchun Jesus amin cha nadchi, lommayaw hen hiyachiy provinsiyan hen Galilea yag ginumchangcha hen anchi wangwang way Jordan way éméy hen anchi provinsiyan hen Judea. ");
INSERT INTO blw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yag anchag chuar agé hen tatagu way ummunud an hiya, wat kena-anna hen saket hen anchichay cha masaket. ");
INSERT INTO blw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Angkay hiyachi, émméycha agé hen tapenay Fariseo way i mamachas way manlokop an hiya. Wat henanhanancha way mangaliyén, “Ay marabseng ngata hen orchintaaw no ihiyan hen larae hen ahawana way uray farangna hen gapona.” ");
INSERT INTO blw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yag senongfatan Jesus chicha way mangaliyén, “Ay iggayyu peet faséén hen anchi nesosorat way alen Apudyus ad namenghan way ekatnéén, ‘Hen laprapona way hen nangammaan hen anchi namayang hen tatagu, enammaana hen larae ya anat hen fufae,’ ");
INSERT INTO blw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","yag annaat ekatén, ‘Gapon hiyaha, wat taynan hen larae hen chinàcha-arna ta i metepon an ahawana way yachin mamfalinancha ah ihà-an way achar. ");
INSERT INTO blw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yag nanepod hen hiyachi, faén chuwa hen acharcha te nanteponcha ah ihà-anay achar.’ Wat hiyaha, maid karébféngan hen tatagu way ammag manginhiyan hen anchi looh nanteponon Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Oo a,” way ekat hen anchichay Fariseo, “ngém pakay emparufus Moses nò, te inyurchinna met way hen larae, no ammag omensorat ah papel ah manginhiyanana an ahawana wat mafalin ihiyanna.” ");
INSERT INTO blw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yag anat ekat Jesusén, “Hen pés-éyna, maid kaman an nadchi, ngém gapoh kenasongelyu wat ammag emparufus Moses hen manginhiyananyu hen ahawayu. ");
INSERT INTO blw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngém hen ifagà an chàyu, heno way larae way ammag manginhiyan hen ahawana way faén gapoh chummagchagasan hen anchi fufae, fummasor chillu te no kasen mangahawa hen anchi laraeyanchi, kaman chagchagasnachi te ahawana chillu hen anchi pés-éy ahawana.” ");
INSERT INTO blw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yachi yag anat ekat hen anchichay pasorot Jesusén, “Wat no yaha peet hen mekaman hen hen-ahawa, un-unninaat no achita ud-ay mangah-ahawa.” ");
INSERT INTO blw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","“Oo tot-owa,” way ekat Jesus, “ngém achi maka-ara hen aminay tatagun nadchi, te anggay yanggay hen anchichay mangidchatan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Te nankarakarase hen lason hen anchi achi mangahaw-an hen larae. Te hen tapena, nisissigud an chicha, yag hen tapena agé, gapo ta nabraancha. Yag hen tapena, anchag anohan way achi mangah-ahawa gapo ta anchag pa-annongan way manginwarawag hen mepanggép hen mantorayan Apudyus. Wat heno way maka-anoh an nadchi, ammaana koma.” ");
INSERT INTO blw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Angkay hiyachi yag wachacha hen anchichay nanginyéy hen a-anàcha an Jesus ta ichàépna koma hen limana an chicha yag inluwaruwana, ngém ammag iningar hen anchichay pasorotna chicha. ");
INSERT INTO blw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngém ekat Jesusén, “Masapor eparufusyu hen miyaliyan hen annachay ungunga an haén ta achiyu an epawa, te chacha manchinlan haén, ya hen kaman an cha nadchi yanggay hen mètape hen mantorayan Apudyus ad uchu.” ");
INSERT INTO blw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wat inchàépna hen limana hen anchichay ungunga yag anat lomayaw. ");
INSERT INTO blw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Angkay hen-argawan, wacha hen ihay larae way émméy an Jesus way mangaliyén, “Apo, nokay ngata hen ammay way ammaà ta midchat an haén agé hen mannanayun way mètaguwà an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yag ekat Jesusén, “Pakay hanhanam an haén hen mepanggép hen ammay, te an met ihà-an hen ammay way hiyah Apudyus yanggay. Wat no laychém tot-owa way mètagu an hiya ah ing-inggana, ammaam amin hen anchichay inyurchinna.” ");
INSERT INTO blw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Henochi hen anchi inyurchinna way masapor ammaà,” way ekat hen anchi laraeyanchi. Yag anat ekat Jesusén, “Masapor achita cha pomatéy, achita cha chumagchagas, achita cha mangakaw ya achita cha istiguwan hen faén tot-owa. ");
INSERT INTO blw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ya masapor agé rispituwénta hen chinàcha-ar, ya masapor epadchata agé hen layadta hen ahentaguta way kaman hen manlaychanta hen acharta.” ");
INSERT INTO blw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yag sommongfat agé hen anchi larae way mangaliyén, “Tenongpar-o met amin cha nadchi, wat nokay ngata hen kenakorang-o chillu.” ");
INSERT INTO blw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yag anat ekat Jesusén, “No laychém way mangamma hen ustousto paat, im elao amin hen kok-owam yag inidchatno hen laona hen anchichay maid mafalinna, yag an-aat umale way somorot an haén. Wat ad uchu hen marmuwan hen tot-oway kafinaknangno.” ");
INSERT INTO blw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ngém hen nangngaran hen anchi larae an nadchi, ammag lommayaw way chan totokar te ammag faknang way térén. ");
INSERT INTO blw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yachi yag anat ekat Jesus hen anchichay pasorotnéén, “Tot-owa hen antoy ifagà an chàyu way ammag naligatay térén hen metapyan hen anchichay faknang hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ammag narakrakaat agé hen homroan hen kafayu hen abfot hen chagum no hen metapyan hen faknang hen mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yag anchag nahaang hen anchichay pasorotna hen nangngarancha an nadchi yag anchaat ekatén, “Wat no yaha, ay nanggila ah wachay tatagu ah mahara-an.” ");
INSERT INTO blw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Finéfétég Jesus chicha way mangaliyén, “No an yanggay tatagu hen mangamma hen mètaguwancha an Apudyus wat ammag achi tot-owa mafalin. Ngém no ah Apudyus hen mangamma, wat mafalin te maid achi mafalin an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yachi yag nan-aleyat ah Pedro way mangaliyén, “Apo chàni kaỳ way anni met ammag tenaynan hen aminay wachan chàni ah sommorotanni an hea, wat ay magunggunaan-ani ngata.” ");
INSERT INTO blw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yag anat ekat Jesusén, “Tot-owa hen antoy ifagà an chàyu way haén way Pangorowan hen Tatagu, no umchah hen anchi kachachayyawan way tumùchuwà way mantoray ah pegwana, wat chàyu way pasorot-o, tumùchuayu agé hen anchi hemporo ya chuway tùchu way mètoray an haén. Yag chàyu agé hen manguwis hen aminay ganà hen anchichay hemporo ya chuway anà Israel. ");
INSERT INTO blw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yag amin agé way tatagu way ammag manaynan hen fabréycha ya sosnodcha, chinàcha-archa, hen a-anàcha ya hen lorotacha gapo hen sommorotancha an haén, wat ammag chùchùar hen midchat an chicha no hen anchi tenaynancha. Yag faén agé yanggaychi te mètagucha agé an Apudyus ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngém chuarcha hen anchichay kaman nan-angato ad uwan way anchag nafafa ah pegwana. Yag chuarcha agé hen anchichay kaman nafafa ad uwan way anchag ngomato ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kasen nampani ah Jesus way mangaliyén, “Hen mantorayan Apudyus wat kaman hen anchi ihay tagu way ammag chuar chi murana. Wat fummigat way i man-anap ah mèlabfu an hiya. ");
INSERT INTO blw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Angkay hiyachi way wachacha hen inchahana, nètorag an chicha way idchatna hen anchi larabfuwan hen ihay ag-agaw yag annaat epééy chicha way i man-amma.” ");
INSERT INTO blw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Angkay nà-argaw yag kasen agé émméy hen anchi cha um-umfunan hen tatagu yag innilana hen anchichay tapenay atàtàchég way maid chacha am-ammaan. ");
INSERT INTO blw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yag annaat ifaga an chicha way mangaliyén, ‘In-ayu agé mìyamma hen anchi murà wat idchat-o hen ustoy labfuyu.’ Yag émméycha tot-owa.” ");
INSERT INTO blw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Angkay nanggawa, i kasen nan-ila ah tapen chi manlabfuwéna, yag umat agé hen fummatangan.” ");
INSERT INTO blw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Yag angkay hen fummatangan ah attè, kasen agé émméy hen anchi cha um-umfunan hen tatagu yag inchahana agé hen anchichay tapena way maid chacha am-ammaan. Yag annaat ekat an chichéén, ‘Pakay an-ayug omen-enargaw way ammag chan ufu-ufun way maid chayu am-ammaan.’ ");
INSERT INTO blw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yag sommongfatcha way mangaliyén, ‘Oo kagé te maid umpay mèlabfuwanni.’ ‘Wat in-ayu kagé mìyamma hen anchichay chà epa-amma,’ way ekat hen anchi chan anap ah man-amma.” ");
INSERT INTO blw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Angkay hiyachi way nadhém yag anat ifagan hen anchi nanginmura hen anchi kapatasna way mangaliyén, ‘Ayagam hen anchichay nan-amma ta idchatno hen labfucha, yag ilugim way mangidchat hen labfun hen anchichay uchi inggana hen anchichay pés-éy ummale hen figfigat.’ ");
INSERT INTO blw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wat yachi, hen anchichay nanginlugi way nan-amma hen fummatangan ah attè, anchag narabfuwan ah kaman hen labfun hen ihay ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yag angkay hiyachi way inumchah hen marabfuwan hen anchichay pés-éy nan-amma hen figfigat, ekatcha ah hamhamàchéén awniyat chùchùar ménat hen labfucha. Ngém faénat agé peet te ammag napapchong amin. ");
INSERT INTO blw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wat chachan ngangayutongot hen nangawatancha hen labfucha yag anchaat manlili hen anchi namparabfu way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ammag ihay uras yanggay hen nan-ammaan hen antochay anongoh way ummale, yag pakay ammag nepachong hen labfucha an chàni way ammag nififillag ah ihay ag-agaw way nan-amma-amma.’ ");
INSERT INTO blw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yachi yag sommongfat hen anchi nanginmura yag ekatnan anchi ihéén, ‘Sonod-o, cha-an-o met lugiyén chàyu te yaha met chillu hen enafunanyu ah labfuyu way larabfuwan chillu hen ihay ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wat aranyu hen annay ustoy labfuyu ta homàyat-ayu, te ammag ah layad-o yanggay yag an-owat papchongon amin hen labfuyu hen uray antochay anongoh way ummale. ");
INSERT INTO blw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ay ammoh epawayu lawa no yaha hen ekaman-o way mangastos hen pelak-o. Ono cha-ayu omapar gapon nanga-asiyà an chicha.’ ” ");
INSERT INTO blw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yachi yag inyanongoh Jesus way mangaliyén, “Wat hen anchichay kaman nafafa ad uwan, awni yag chicha hen nangato ah pegwana. Yag hen anchichay kaman nangato ad uwan, awni yag chicha agé hen nafafa ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Angkay hiyachi way cha mane-ed cha Jesus way éméy ad Jerusalem, enayangana hen anchichay hemporo ya chuway pasorotna ta omanggaycha. Yag hen chacha manaranan, imfagana an chicha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Changrényu ngén hen antoy ifagà te hen antoy ayantaaw ad Jerusalem ad uwanat yato hen manpapancha an haén way Pangorowan hen Tatagu. Yag meporangà hen anchichay anap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin way chicha hen mangimfaga hen matéyà. ");
INSERT INTO blw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yag ana-at eporang hen anchichay faén Judio way manénséna ya manaphaprat an haén, yag ana-at agé elansa hen koros ta matéyà. Ngém hen anchi petlon hen ag-agaw, man-uchiyà chillu.” ");
INSERT INTO blw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Angkay hiyachi yag émméycha an Jesus hen anchichay hen-ininna way ahawan Zebedeo ya hen anchi chuway a-anàna way pasorot Jesus. Yag nampalentomang ah inacha hen henagong Jesus way mangimfaga hen anchi laychéna way chawatén. ");
INSERT INTO blw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yachi yag ekat Jesus an hiyéén, “Nokay hen ifagam.” Yag annaat ifaga way mangaliyén, “Ay achi mafalin ta no umchah hen mantorayam wat ilam paat ta hen antoy chuway a-anào hen mìtùchu an hea way epatùchum hen iha hen pachawananno ya hen iha ah pachawigim.” ");
INSERT INTO blw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Aẁ,” way ekat Jesus, “achiyu angkay ma-awatan hen annay chayu chawatén.” Yag annaat ifaga hen anchi chuway hen-agi way mangaliyén, “Ay mafalin way ma-anohanyu hen anchi ligat way kaman hen anchi ligat way mepachah an haén.” Yag ekatchéén, “Oo, ma-anohanni.” ");
INSERT INTO blw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yag anat ekat Jesus agéén, “Tot-owa way ma-anohanyu cha nadchi te umchah agé hen mapap-aligatanyu. Ngém faén chillu haén hen mampele no heno hen tumùchu ah pachawanan-o ya ah pachawigì, te ah Amay Apudyus hen nangensasagga hen hiyachiy tùchuwan ah para hen anchichay mangidchatana.” ");
INSERT INTO blw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hen nangngaran hen anchichay hemporo way tapen hen pasorot Jesus hen anchi cha chawatén hen anchi chuway hen-agi, ammag lommaweng hen hamhamàcha an chicha. ");
INSERT INTO blw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wat enamong Jesus chicha amin yag annaat tugunun way mangaliyén, “Innilataaw met hen ekaman hen anchichay anap-apo hen antoy lota, wat anchag cha manchamancharén hen anchichay chacha etorayan. Ya umat agé hen anchichay o-okom, chacha agé mancharén hen anchichay ahentagucha. ");
INSERT INTO blw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngém chàyu, achi mafalinha ah ekamanyu te no wachay manlayad an chàyu way man-ap-apo, masapor mamfalinéna hen acharna ah katorongan hen anchichay tapena. ");
INSERT INTO blw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yag no wacha agéy manlayad way ngomato an chàyu, masapor angkay mamfalinéna hen acharna ah kafafaan way kaman alepan hen anchichay tapena. ");
INSERT INTO blw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Te kaman an haén way Pangorowan hen Tatagu, iggayà ummale hen antoy lota way i mampatorong hen tatagu, te ummaliyà way anà i tomorong an chicha. Ya ummaliyà agé way i matéy ah sobfot hen fasor hen chuar way tatagu.” ");
INSERT INTO blw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Angkay hiyachi way cha lomayaw cha Jesus hen anchi fabréy ad Jerico, anchag chuar hen anchichay tatagu way cha metnod. ");
INSERT INTO blw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yag niyaphor agé way wachacha hen chuway nabfurag way tummutùchu hen penget hen anchi korsa way chacha engwa. Yag angkay chengngarcha way ah Jesus peet hen manlooh, anchaat ilugi way man-ongaw way mangaliyén, “Heay ganà Are David, panga-asem paat ta ség-angam chàni.” ");
INSERT INTO blw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yag hen anchichay tatagu, anchag hi-i-ingar an chicha way mangempaginang koma, ngém chachaat ekaskasen way mangèngaw way mangaliyén, “Heay ganà Are David, panga-asem paat ta ség-angam chàni.” ");
INSERT INTO blw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yachi yag entàchég Jesus yag ekatnan chichéén, “Nokay hen laychényu way ammaà an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yag anchaat ekatén, “Apo, ta makaila-ani koma.” ");
INSERT INTO blw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Wat sinég-angan Jesus chicha yag tenchàna hen matacha wat naka-anat tot-owa hen finuragcha yag netnodcha an hiya. ");
INSERT INTO blw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Angkay hiyachi way cha homag-én cha Jesus ad Jerusalem way tég-angaycha umchah hen anchi fabréy way Betfage wat entàchégcha hen pénad hen anchi filig ad Olivo, yag hennag Jesus hen chuway pasorotna way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Epangpangoyu hen annay fabréy way chuchummangéntaaw wat ichahanyu hen ihay kafayu way netatàéd way wacha hen ubfuna. Ùfachényu yag inyaliyu chichahto. ");
INSERT INTO blw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yag mag-ay ta wachay mangaliyén pakay ùfachényuha, ifagayu way masapor hen ap-apo wat man-eparufusna hen mangar-anyu.” ");
INSERT INTO blw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hen hiyachiy na-ammaan, na-ammaan ah tommot-owaan hen anchi imfafaggan hen anchi profeta ad namenghan hen nangaryanéén, ");
INSERT INTO blw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ifagayu hen anchichay tatagu ad Jerusalem way manSion way naway hen Arecha way empafafana hen acharna way ammag ubfun laway kafayu hen nansakayana.” ");
INSERT INTO blw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Angkay hiyachi yag émméycha hen anchichay pasorot Jesus yag enammaancha amin hen imfagana an chicha. ");
INSERT INTO blw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wat innaracha hen anchi hen-ina way kafayu yag anchaat iyap-ap hen agwan hen lumfongcha hen échégna yag nansakay ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yag ammag chuar hen anchichay tatagu way nenhaprà hen lumfongcha hen anchi korsa way engwana ah manayawancha an hiya. Yag hen anchichay tapena, incha sommongpat ah arumfanga ah ehapràcha hen korsa agé. ");
INSERT INTO blw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wat amin hen anchichay cha mamangpango ya cha umunud, anchag heo-ongaw way mangaliyén, “Chayawéntaaw hen antoy ganà Are David. Chayawéntaaw hen antoy ummale way narpon Apudyus. Ya chayawéntaaw hen anchi kangatowan way Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Angkay hiyachi way inumchah cha Jesus ad Jerusalem, anchag na-ateb-ar hen amin anchichay tatagu yag ekatchéén, “Heno man paat ah naha.” ");
INSERT INTO blw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yag sommongfat hen anchichay nenetnod way mangaliyén, “Hiyato ah Jesus way profetan Apudyus way narpod Nazaret way ihay fabréy hen provinsiyan hen Galilea.” ");
INSERT INTO blw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Angkay hiyachi yag émméy ah Jesus hen fatawan hen anchi Templo way faréy Apudyus yag annag emparyaw amin hen anchichay chan elàrao ya cha lomao ah michaton an hiya. Yag anna agég tenokang hen anchichay lamesa-an hen anchichay chan soksokat ah pelak ya umat agé hen tùchun hen anchichay chan elaoh karopate. ");
INSERT INTO blw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yag annaat ekat an chicha way mangaliyén, “Nesosorat hen alen Apudyus way ekatnéén, ‘Hen faréy-o wat mausar ah manluwaruwan hen tatagu an haén.’ Yaha hen imfagan Apudyus ngém chàyu, anyug namfalinén hen antoy faréyna ah chayu i manlokkowan hen ahentaguyu.” ");
INSERT INTO blw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Angkay hiyachi yag émméy hen anchichay nan-abfurag ya nan-appelay ah Templo way i mampàila an Jesus, wat kena-anna hen sasaketcha. ");
INSERT INTO blw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngém hen anchichay anap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin, anchag ommaningarngar hen nangil-ancha hen anchi chana ammaan way kaskascha-aw, ya kaskasen hen nangngarancha hen cha èngaw hen anchichay ungunga ahchih Templo way mangaliyén, “Chayawéntaaw hen antoy ganà David.” ");
INSERT INTO blw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wat anchaat ifaga an Jesus way mangaliyén, “Ay ammoh achim cha changrén hen annay cha èngaw hen annachay ungunga.” “Chachangrê met,” way ekat Jesus. Yag annaat ekat agéén, “Ay ammoh iggayyu faséén hen anchi nesosorat way alen Apudyus way ekatnéén, ‘Tinudtuchuwan Apudyus hen anchichay ungunga way manginchayaw an hiya hen anchi nènong paat.’ ” ");
INSERT INTO blw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yachi way enalen Jesuschi yag annag tenaynan chicha way lommayaw ad Jerusalem yag émméy ad Betania way i ummiyan ahchi. ");
INSERT INTO blw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Angkay nafigat way chachan fangad ad Jerusalem, chan henaang ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yag yachi way innilana hen ihay away way ekatchéén fig hen penget hen charan yag inna innila no wachay fungana. Yag ammag maid te an yanggay tangréb chi tufuna. Yag annaat iyaryan hen anchi away way mangaliyén, “Achia kasen mamub-unga ah ing-inggana, yag ammag nàrongat agé hen anchi away.” ");
INSERT INTO blw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hen anchichay pasorotna, anchag nahahaang hen nangil-ancha hen anchi na-ammaan yag anchaat ekatén, “Ané, pakay ammag pegachi yag nàrongat hen annay away.” ");
INSERT INTO blw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yag ekat Jesusén, “Tot-owa hen antoy ifagà an chàyu way no ah Apudyus yanggay hen manokchunyu way achiayu chan chuwachuwa, wat mafalin ammaanyu agé hen changan antoy enammaà hen antoy awayanto. Ya faén yanggay agéha te uray agé anyug ifaga hen anchi filig way marabten yag nepetlà ah fayfay, wat ma-ammaan tot-owa. ");
INSERT INTO blw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te no anyu yanggay ammag manokchun ah Apudyusat, idchatna an chàyu hen amin way chawatényu.” ");
INSERT INTO blw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Angkay hiyachi way namfangad ah Jesus ah Templo yag inlugina way mantudtuchu. Yag hen chana mantudtuchuwan, hinénggépcha agé hen anchichay anap-apon hen pachi ya hen anchichay anam-ama way ponò hen Judio, yag émméycha an Jesus way i mamistigar an hiya way mangaliyén, “Henon pam i ammaan hen annay cham ammaan. Yag heno ay paat hen nangidchat hen karébféngam way mangammahna.” ");
INSERT INTO blw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yag senongfatan Jesus chicha way mangaliyén, “Wacha unna hen hanhanà an chàyu yag no masongfatanyu wat ifagà agé an chàyu no heno hen nangidchat hen antoy karébféngà way mangamma hen antochay chà ammaan.” ");
INSERT INTO blw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yag annaat ekatén, “Heno ngarud hen nangidchat hen karébféngan Juan way mamfunyag. Ay ah Apudyus ono tatagu.” Yag chacha mahalifunuwan hen tapena way man-ahetennopà te ekatchéén, “No ekattaawén ah Apudyus hen nangidchat hen karébféngan Juan, awniyat ifagan Jesus agé an chitaaw no pakay iggaytaaw agé afuroton hen imfagan Juan. ");
INSERT INTO blw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Waman no ekattaaw agéén an yanggay tatagu hen nangidchat hen karébféngan Juan, aggaégyat agé ah wachay ammaan hen antochay tatagu an chitaaw, te afurotoncha amin way tot-oway profetan Apudyus ah Juananchi.” ");
INSERT INTO blw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wat anchag senongfatan ah Jesus way mangaliyén, “Tawwan te maid innilani.” “Wat no yaha,” way ekat Jesus, “achì agé ifaga an chàyu no heno hen nangidchat hen karébféngà way mangamma hen antochay chà ammaan.” ");
INSERT INTO blw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yachi yag anat mampani ah Jesus an chicha way mangaliyén, “Nokay hen manmàyu an natto. Wachan ihay am-ama way chuwa hen anàna way lenarae. Yag yachi, imfagana hen anchi pango way mangaliyén, ‘Anào, in-a ta homepot-a ad uwan.’ ");
INSERT INTO blw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Gapo ah achi ma-aryan, ekatnéén, ‘Innà angkay éméy.’ Ngém angkay na-awni way nanhamahamà, namfafawi yag émméy chillu. ");
INSERT INTO blw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yachi yag émméy agé hen anchi am-ama way i nangimfaga hen anchi enawchina ta éméy agé homepot. Yag ekat hen anchi enawchiyén, ‘Oo kay Ama, éméyà.’ Ngém ammag iggay émméy.” ");
INSERT INTO blw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yachi yag anat ekat Jesusén, “Henokay an cha nadchi way chuwa hen nangamma hen laychén hen anchi amacha.” Yag sommongfatcha way mangaliyén, “Hen anchi pango kagé.” Yag anat lawrawagén Jesus an chicha way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way hen anchichay lawengay tatagu way kaman hen anchichay cha mangam-among hen furor ya hen anchichay fufae way cha menlao ah acharna, wat mamangpangocha no chàyu way mètape hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Te chàyu, ummale ah Juan way chan funfunyag way mangintudtuchu hen ustoy ekamanyu ta mifilang-ayu ah ammayay tatagu, ngém anyug iggay enafurot hiya. Waman hen anchichay manga-akaw way cha mangam-among hen furor ya hen anchichay fufae way cha menlao hen acharcha, wat enafurotcha hiya. Yag kaskasen agé te uray no enlasinyu hen namfalewancha, anyug iggay chillu fab-alewan hen hamhamàyu ah omafurotanyu.” ");
INSERT INTO blw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Changrényu ngén hen antoy kasen paniyê,” way ekat Jesus. “Wachan ihay tagu way minur-ana hen lotana ah greps way mafayah hen fungana. Yachi yag enaradna hen anchi minurana yag anat agé mampatoktok ah fato ah manlechehana hen fungana. Yag annaat agé epa-amma hen akayyang way paranha ah iggawan hen anchichay mangguwarcha. Yachi yag annaat epa-afang ah safaliy tatagu yag lommayaw way i namfiyahi ah safaliy lota.” ");
INSERT INTO blw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Angkay inumchah hen tempon hen mamungaan hen anchi inmurana, hennagna hen tapen hen alepanna ta icha aran hen penakafingayna. ");
INSERT INTO blw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngém hen anchichay cha mangafang, anchag chinpap hen anchichay alepan yag penagohcha hen iha, yag pinchitcha agé hen iha, yag anchaat agé funfunto-on hen anchi iha. ");
INSERT INTO blw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ngém uray, kasen chillu hennag hen anchi nangenlota hen chùchùar way alepanna no hen anchi pés-éyna. Yag ammag pachongna chillu hen enkamancha an chicha. ");
INSERT INTO blw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Angkay hen anongohna, annaat hénagén hen anchi mismoy anàna te ekatnah hamhamànéén, ‘Ta éhéd yag ifiincha hiya te anào paat tot-owa.’ ");
INSERT INTO blw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngém angkay innilan hen anchichay cha mangafang way hen anchi anànaaat hen naway, anchaat mantatagépfar way mangaliyén, ‘Ayé, annayan hen anchi ustoy mangentawid hen antoy lotaanto wat antaawat pédtén ta chitaaw hen mangen-awa.’ ");
INSERT INTO blw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wat chinpapcha tot-owa hen anchi anàna yag inilhincha hen anchi arad way i mamchit.” ");
INSERT INTO blw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Wat ad uwan,” way ekat Jesus an chicha, “nokay hen hamhamàyu way ammaan hen anchi nangenlota hen anchichay cha mangafang no homàyat.” ");
INSERT INTO blw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yag sommongfatcha way mangaliyén, “Anna yanggay ammag pédtén hen anchichay cha mangafang te anchag lawengay térén, yag annaat epa-afang hen nalimpiyu way tatagu way mangidchat hen ustoy penakafingayna.” ");
INSERT INTO blw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yag anat ekat Jesus an chicha agéén, “Wat ay ammoh iggayyu faséén hen anchi nesosorat way alen Apudyus way ekatnéén, ‘Hen anchi fato way enachin hen anchichay chan sà-ad ah faréy way ekatchéén maid sérfina, wat ammag yachiyat agé hen anchi kapatpatigan way mepégnad. Ah Apudyus hen nangamman natto, yag ammag kahahaang tot-owa.’ ” ");
INSERT INTO blw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Entoroy Jesus way mangaliyén, “Wat tot-owa hen antoy ifagà an chàyu way faén angkay chàyu way Judio hen etorayan Apudyus te eh-atna chàyu hen anchichay safaliy tatagu way cha mangafurot hen laychéna. ");
INSERT INTO blw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yag hen anchi fatowanchi agé, no wachay màchég an hiyaat ammag mapmaptén. Ngém no hen anchi fato agé hen meposet hen ihay tagu, wat ammag matampò way kaman chapor.” ");
INSERT INTO blw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yachi way chengngar hen anchichay anap-apon hen papachi ya hen anchichay Fariseo hen anchichay empanin Jesus, wat na-awatancha way chicha hen chana paniyén. ");
INSERT INTO blw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yag anchag laychén paat way manelew an hiya hen hiyachi, ngém iggaycha chillu gapo ta iyégyatcha hen anchichay chuaray tatagu, te hen anchichay tatagu, afurotoncha way profetan Apudyus ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kasen nampanih Jesus hen nanudtuchuwana hen anchichay tatagu, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hen mepaniyan hen mantorayan Apudyus wat kaman hen anchi ihay Are way nangensasaggana hen anchi lagsak way mankasaran hen anàna. ");
INSERT INTO blw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Angkay hiyachi way nesagana hen egad, hennagna hen anchichay alepanna way i mangayag hen anchichay tatagu way loohna ini-imfitar. Ngém hen anchichay naimfitar, anchag achi peet éméy. ");
INSERT INTO blw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wat annaat kasen hénagén hen anchichay tapen hen alepanna way mangaliyén, ‘Inyu kasen ifaga hen anchichay looh-o ini-imfitar way napaparte hen anchichay faka ya hen tatanabfa way ubfu, yag nesasaggana amin hen egad wat umalechaat koma way mèkasar.’ ");
INSERT INTO blw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngém hen anchichay naimfitar way tatagu, anchag hentot-orangén hen cha ifagan hen anchichay alepan. Yag chachaat éméy ah ay-ayancha way hen tapena, icha homepot, ya hen tapena, éméycha agé man-amma hen chacha am-ammaan. ");
INSERT INTO blw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yag anat hen tapena agé, anchaat agég chinpap hen anchichay alepan way maid achicha enammaan an chicha yag anchaat pédtén.” ");
INSERT INTO blw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Angkay hiyachi way chengngar Are hen anchi nekaman, ammag ommaningarngar way térén yag annaat hénagén hen anchichay sorchachuna way incha pinchit hen anchichay pommatéy yag anchaat po-oran hen anchi fabréycha. ");
INSERT INTO blw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yachi yag anat ifagan Are hen anchichay tapenay alepanna way mangaliyén, ‘Nesasaggana hen aminay egad hen antoy lagsak, ngém hen annachay looh-o inimfitar, achicha karébféngan way mèlagsak. ");
INSERT INTO blw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wat éméy-ayu hen anchichay korsa yag aminay tatagu way ilanyu, ayaganyu chicha amin way umaley mèlagsak.’ ");
INSERT INTO blw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yachi yag émméycha tot-owa hen anchichay alepanna hen kakorsakorsa, yag aminay tatagu way inchahancha, enayagancha amin way uray hen anchichay laweng ya ammay, wat napno hen faréy Are ah i mèkasar.” ");
INSERT INTO blw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Angkay hiyachi way émméy ah Are way i mangila hen anchichay tatagu way na-among, yag nanmatanaat agé hen ihay tagu way annag iggay inlumfong hen ustoy lumfong way para hen kasar. ");
INSERT INTO blw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yag anat éméy an hiya way mangaliyén, ‘Ayong hea, henon pa-a umalehto way mèkasar yag an-ag iggay nanlumfong ah lumfong para hen kasar.’ Yag ammag chan tomtomaà hen taguwanchi way maid elasonna. ");
INSERT INTO blw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yag anat ifagan Are hen anchichay alepanna way mangaliyén, ‘Faruchunyu hen antoy taguwanto yag sértényu hen farud hen limana ya he-ena yag entap-aryu ah chara way ammag ngéngét, ta ahchi hen mankelaana way magénén manngangalitféna hen fub-ana ah kaligatna.’ ” ");
INSERT INTO blw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yachi yag henalenonot Jesus way mangaliyén, “Anchag chuar tot-owa hen naimfitar ngém otonna hen mapele.” ");
INSERT INTO blw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Angkay hiyachi yag anchag lommayaw hen anchichay Fariseo way incha mantetennopà ah ekamancha way manlokop koma an Jesus ta wachay manginchérémancha an hiya. ");
INSERT INTO blw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wat hen enkamancha, hennagcha hen tapen hen pasorotcha ya tapen hen anchichay ifan Are Herod ta incha ifaga an Jesus way mangaliyén, “Apo, innilani way maid tot-owa kétkétémno way tagu, ya cham agé itudtuchu hen anchi tot-owa way laychén paat Apudyus way ma-ammaan, ya annog achi agé iyég-égyat hen uray heno way aryén hen tagu an hea te ammag maid wahigém way uray hen nan-asa-achan. ");
INSERT INTO blw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wat ifagam kaỳ no heno hen manmanmàno an natto, no ay achitaaw ngata cha labsengén hen orchintaaw way Judio no fayachantaaw hen furor hen anchi Are ad Roma.” ");
INSERT INTO blw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngém ah Jesus, enlasinna chillu hen kenasilibcha yag annaat ekatén, “Chàyu way senang a-afurot, pakay pachasényu way manlokop an haén. ");
INSERT INTO blw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ilà kayya hen annay pelak way mifayad ah furor.” Yag empàilacha hen ihay pelak. ");
INSERT INTO blw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yag ekat Jesusén, “Nokay hen antoy nepepetchor an natto yag nokay agé hen nangenngachan hen antoy nesosorat.” ");
INSERT INTO blw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Hen anchi Are ad Roma,” way ekatcha. Yag anat ekat Jesus agéén, “Wat no yaha way hen Are hen nangen-awa, idchatyu kagé an hiya hen para an hiya. Ngém ilanyu agé ta idchatyu an Apudyus amin hen para agé an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hen nangngarancha an nadchi, anchag naleletag yag lommayawcha way nanaynan hiya. ");
INSERT INTO blw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Angkay hen hiyachi agé way ag-agaw, émméycha hen anchichay Judio way Saduceo an Jesus way chicha hen achi mangafurot way kasen man-uchi hen natéy. Yag imfagacha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Apo, hen intudtuchun Moses ad namenghan, ekatnéén no ommahawa hen ihay larae yag natéy way maid anàna, masapor ahaw-én hen sonodna hen anchi nafaro ta umanàcha koma ah kaman penaka-anà hen anchi natéyanchi way sonodna. ");
INSERT INTO blw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wat hanhanannito an hea, te ad namenghan, wachacha anohto hen pituy larae way masosnod. Yag angkay nangahawa hen anchi pango, cha-ancha umanà yag natéy. Yag gapo ta maid anàcha, enahawan hen anchi metéb hen anchi nafarowanchi. ");
INSERT INTO blw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ngém yachi agé hen nepasamak an hiya. Yag umat agé hen anchi ma-atlo inggana hen anchi enawchi way ma-apitu way maid ummanà an chicha yag natéycha amin. ");
INSERT INTO blw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yag hen ommanongoh, natéy agé hen fufaeyanchi. ");
INSERT INTO blw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wat hen man-uchiyan hen tatagu ah pegwana te ekatyuwén man-uchicha, nokay ngarud hen ustoy mangen-ahawa hen fufaeyanchi nò, te amincha met way pitu wat enahawacha amin hiya.” ");
INSERT INTO blw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Senongfatan Jesus chicha way mangaliyén, “Oo a, ngém an-ayug nèfat way térén ya korang hen innilayu mepanggép hen anchi nesosorat way alen Apudyus ya achiyu agé ma-awatan hen mannakafalinna. ");
INSERT INTO blw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Te hen man-uchiyan hen nan-atéy, maid angkay man-ah-ahawa te kamancha hen anchichay anghel Apudyus ad uchu. ");
INSERT INTO blw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yag hen mepanggép hen man-uchiyan hen natéy, ay ammoh iggayyu faséén hen anchi nesosorat way alen Apudyus an chàyu way ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Haén ah Apudyus way cha chayawén cha Abraham an cha Isaac yah Jacob,’ way hen laychén nahhay aryénat uray nan-atéycha cha Abraham hen hiyachiy tempo, é-éttégcha chillu way natattagu ad uchu, te pakay wachacha ad uwan way cha manayaw an Apudyus nò.” ");
INSERT INTO blw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hen nangngaran hen anchichay chuaray na-a-among way tatagu an nadchi, anchag nahahaang way manmanmà hen chana itudtuchu. ");
INSERT INTO blw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Angkay hiyachi way chengngar hen anchichay Fariseo way ancha peet ammag nasokok hen anchichay Saduceo wat anchaat ammag mantetepon way éméy an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yag hen iha an chicha way ihay cha mintudtuchu hen orchin Moses, penachasna way manlokop an Jesus way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Apo, nokay ngata hen anchi kapatpatigan paat way orchintaaw.” ");
INSERT INTO blw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Senongfatan Jesus hiya way mangaliyén, “Masapor laychényu ah Apudyus ah patinggan hen aminay hamhamàyu ya ah aminay a-ammayu ya ah aminay kenaraengyu. ");
INSERT INTO blw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yato hen anchi kangatowanay orchin Apudyus way kapatpatigan. ");
INSERT INTO blw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ya hen metéb, kaman agé te ekatnéén masapor laychényu hen ahentaguyu kaman hen manlaychanyu hen acharyu. ");
INSERT INTO blw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chichato way chuway orchin Apudyus, enahapna amin hen anchichay orchin way ensorat Moses ya hen intudtuchun hen anchichay profeta.” ");
INSERT INTO blw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Angkay hiyachi way na-a-amongcha chillu hen anchichay Fariseo, nansarudsud ah Jesus an chicha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nokay hen manmàyu mepanggép hen anchi empopostan Apudyus way epalena way Cristu no nokay hen nangingganà an hiya.” Yag ekatcha way sommongfatén, “Ah Cristu wat hiya hen ganà Are David.” ");
INSERT INTO blw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Oo a, ngém no yaha,” way ekat agé Jesus, “pakay agé imfagan Are David way ah Cristuwat hiya agé hen Ap-apona nò. Te hen enalen David way empahmà hen Espiritun Apudyus, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ah Apudyus way Ap-apo, imfagana hen anchi ap-apò way mangaliyén, Tumùchua hen antoy pachawanan-o ingganah epa-afào an hea hen anchichay aminay kafusorno.’ ” ");
INSERT INTO blw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Entoroy Jesus way mangaliyén, “Wat no yaha way uray ah Are Davichén enawagana hen anchi umale way mantoray ah ap-apona, wat nokay agé hen ekamanna way hiya hen mangingganà hen anchi ap-apo nò.” ");
INSERT INTO blw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yag ammag maid poros makasongfat an Jesus. Wat nanepod hen hiyachi, maid makatorod way kasen mamachas way manlokop an hiya. ");
INSERT INTO blw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Angkay hiyachi yag imfagan Jesus hen anchichay chuaray tatagu ya hen anchichay pasorotna way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Hen anchichay siguchay cha mintudtuchu hen orchin Moses ya hen anchichay Fariseo, chicha hen napiyar way mangintudtuchu hen anchichay orchin Apudyus way ensorat Moses. ");
INSERT INTO blw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wat masapor afurotonyu way mangamma hen aminay chacha itudtuchu, ngém achiyu paat cha torachén hen a-ammacha te anchag achi ammaan hen anchi chacha itudtuchu. ");
INSERT INTO blw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yag ancha agég cha sorsorfatan hen orchin yag anchaat epapelet hen tatagu way somorot an cha nadchi. Ngém ammag maid agé etorongcha hen anchichay tatagu way cha manorot. Te kaman paat chacha epakarga hen ammag chinaghén way karga hen tatagu, ngém anchag achi paat fumnéh. ");
INSERT INTO blw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yag aminay chacha ammaanat, ammaancha yanggay ah mangempàpàil-ancha hen tatagu ah machayawancha, te ancha agég cha pachakarén hen anchi mangi-iggaancha hen anchi nesosorat way alen Apudyus way chacha ifédféd ah etongcha ya hen tàraycha. Ya chacha agé pa-anchuwén hen paraypay hen panchilengcha. ");
INSERT INTO blw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ya ancha agég laylaychén way chicha paat hen machayaw hen heno way lagsak, ya chicha agé paat hen i tumùchu hen anchichay am-ammay way tùchu hen chacha ma-am-amongan. ");
INSERT INTO blw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yag no ay éméycha agé hen cha um-umfunan hen tatagu, ammay no rispituwén paat agé hen tatagu chicha, ya ammay agé paat no ma-awagancha ah Apo. ");
INSERT INTO blw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yaha hen wachan chicha. Ngém chàyu, achiyu parufusun way ma-awagan-ayu ah Apo, te napapchong-ayu way masosnod ya an ihà-an yanggay chillu hen apoyu te anggayà. ");
INSERT INTO blw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ya achiyu agég cha awagan hen an lawag tatagu hen antoy lota ah amayu, te an ihà-an yanggay chillu hen amataaw way hiyah Apudyus ad uchu. ");
INSERT INTO blw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ya achiyu agé parufusun way ma-awagan-ayu ah ap-apo, te haén yanggay hen Ap-apoyu way haén hen anchi empopostan Apudyus way ummaley mantoray. ");
INSERT INTO blw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ya hen anchi kangatowan an chàyu, masapor hiya agé hen katorongan hen tapena. ");
INSERT INTO blw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ya heno way tagu agé way mangempangato hen acharnaat epafafan Apudyus hiya. Waman hen anchi tagu way mangempafafa hen acharna wat pangatowén Apudyus hiya.” ");
INSERT INTO blw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“An-ayug ka-ase, chàyu way siguchay cha mintudtuchu hen orchin Moses ya chàyu agé way Fariseo, te an-ayug senang a-afurot way anyug cha sellaan peet hen metapyan hen tatagu hen mantorayan Apudyus, yag gapo hen anchi achiyu ketapyan yag chayuwat agé lengalengén hen anchichay chan anap ah ketapyana.” ");
INSERT INTO blw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“An-ayu lawag ka-ase, chàyu way siguchay cha mintudtuchu hen orchin ya chàyu agé way Fariseo way an-ayug senang a-afurot. Te pakay chayu saoron hen anchichay faro way anyug cha aran hen kok-owacha, yag ah mangempàpàil-anyu ah kena-ammayyu, chayu anchuanchuwén hen manluwaruwanyu. Wat gapon yaha, ammag kaskasen hen manusaan Apudyus an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“An-ayug ka-ase, chàyu way siguchay cha mintudtuchu hen orchin ya chàyu agé way Fariseo way an-ayug senang a-afurot. Te magénén ginchangyu hen chakaray fayfay yag ginégga-ayyu hen chakaray lota ah mangawisanyu ah uray ihà-anay pasorotyu. Yag angkay enawisyu, enammaanyu hiya ah am-améd no chàyu ta kaskasen agé hen kachusaana no hen kachusaanyu.” ");
INSERT INTO blw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“An-ayu ammag ka-ase, te kaman-ayu nabfurag way maid innilayu yag chayuwat agé tudtuchuwan hen anchichay maid agé innilana. Kaman hen anchi chayu itudtuchu way no mag-ay hen anchi Templo hen esapatan hen anchi mansapata, wat yasa no achina ammaan hen imfagana te achi ano chillu makafasor. Ngém ekatyuwén no mag-ay hen anchi faletò paat way ininggaw hen anchi Templo hen esapatana, masapor yanggay ammaana way ammaan te fasorna ano no achina. ");
INSERT INTO blw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","An-ayu tot-owa ammag nawéngwéng way nabfurag, te nokay hen napatpateg, hen anchi faletò ono hen anchi Templo way nanaém hen anchi faletò ta ma-apudyusan.” ");
INSERT INTO blw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ya chayu itudtuchu agé way no mag-ay hen anchi cha mepatpatngan hen michaton an Apudyus hen esapatan hen anchi mansapata, wat yasa no achina ammaan hen empostana te achi ano chillu makafasor. Ngém mag-ay ta hen anchi cha michaton paat hen esapatana, masapor yanggay ammaana way ammaan te fasorna ano agé no achina. ");
INSERT INTO blw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wat an-ayu tot-owa ammag nabfurag way maid innilayu, te ay ammoh napatpateg hen anchi cha michaton no hen anchi chana mepatpatngan way nanaém hen na-apudyusan nadchi. ");
INSERT INTO blw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wat hen ifagà an chàyu, henoy tagu way mangensapata hen anchi cha mepatpatngan hen michaton an Apudyusat ma-awatanyu way faén yanggaychi hen ensapatana, te henaémna agé hen aminay nepapattang an nadchi. ");
INSERT INTO blw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ya umat agé hen anchi Templo way faréy Apudyus, no yachi hen esapatan hen tatagu, wat ma-awatanyu agé way faén yanggay hen anchi Templo hen chana esapata te henaémna agé ah Apudyus paat way ini-inggaw an nadchi. ");
INSERT INTO blw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pachongna agé hen uray heno way tagu way mangensapata ad uchu, te annag henaém agé hen mantorayan Apudyus ya anat agé ah Apudyus paat way chan toray ahchi.” ");
INSERT INTO blw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“An-ayug ka-ase, chàyu way siguchay cha mintudtuchu hen orchin ya chàyu agé way Fariseo way an-ayug senang a-afurot. Te ammag maid lawrawhanyu hen anchichay faén napateg way liglamenton hen orchin, kaman hen anchi chayu mangidchatan hen pagkaporon hen uray lawa hen anchichay charoh way omenparamnaw hen missa. Achiyu lawrawhan chachi, ngém chayuwat agé iwalin hen anchichay napateg paat way inyurchin Apudyus way masapor malilimpiyu hen a-ammayu ya masapor ség-anganyu hen ifayu ya masapor agé matalek-ayu way tatagu. Chichato hen masapor ammaanyu koma way uray achiyu agé lawhan hen annachay tapena.” ");
INSERT INTO blw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“An-ayu tot-owa ammag kaman nabfurag yag chayuwat agé iwichén hen tapena. Anyug cha iyam-amma paat way mangamma hen anchichay kafafaan way orchin ngém an-ayug natorod way manmaid hen anchichay napatpateg paat.” ");
INSERT INTO blw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“An-ayu ammag ka-ase, chàyu way siguchay cha mintudtuchu hen orchin ya chàyu agé way Fariseo way an-ayug senang a-afurot. Te hen miyaligana, anyug chachallosan hen mamàila way achar hen tasayu ya hen pengganyu, ngém ad char-ém way achi maila, ammag aggarémha way kaman yachi hen chayu manlugiyan hen tapena ya hen chayu mangamgaman hen egad. ");
INSERT INTO blw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","An-ayu tot-owag kaman nabfurag, chàyu way Fariseo. Wat masapor charosanyu unna hen annay aggarémha way achi maila wat kapeletan way ma-ahap agé hen anchi mamàila way nacharos.” ");
INSERT INTO blw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“An-ayu ammag ka-ase, chàyu way siguchay cha mintudtuchu hen orchin ya chàyu agé way Fariseo way an-ayug senang a-afurot. Te hen ihay miyaliganyu, an-ayug kaman napepentoran way lufù way ah mangilan hen tataguwat fub-urùan. Ngém ah katot-owana, ammag nanapno ad char-ém ah aggarémha way tongar ya chérang chi natéy. ");
INSERT INTO blw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wat yachi hen pachongyu, te ah sangwanan hen tataguwat am-ammay-ayu, ngém ah hehemmàyuwat ammag pahig kétém ya laweng.” ");
INSERT INTO blw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“An-ayug ka-ase, chàyu way siguchay cha mintudtuchu hen orchin ya chàyu agé way Fariseo way an-ayug senang a-afurot. Te a-anammay tot-owa eman hen anchichay lufù way enammaanyu para hen anchichay tongar hen profeta way napchit ad namenghan, ya enar-arkosanyu agé hen lufù hen anchichay anammay way tatagu. ");
INSERT INTO blw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yag ekatyu agé way mangaliyén, ‘Non an-ayu wà-acha hen natatagguwan hen anchichay profetaat iggay-ayu nì-ipchit hen namchitan hen anap-oyu an chicha.’ ");
INSERT INTO blw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wat chayu peet tot-owa epudnu way ganà chàyu hen anchichay namchit hen anchichay profeta ad namenghan. ");
INSERT INTO blw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Wat ayéat kaỳ lopasényuwat hen anchi looh inlugin hen anchichay anap-oyu. ");
INSERT INTO blw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","An-ayug kaman tot-owa farakkan way kaman tenatawidyu hen ammag pahig laweng. Wat ay ammoh ekatyuwén mailisiyanyu hen ketap-aranyu ad imférno. ");
INSERT INTO blw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ifafaggà an chàyu hen ammaanyu, te wachacha hen epalè an chàyu way profeta ya nan-araeng way tatagu ya anat agé hen anchichay manudtuchu an chàyu. Ngém awniyat anyug pédtén angkay hen tapena ya ekorosyu hen tapena, yag pagohonyu hen tapena hen chayu ma-am-amongan, yag unu-unuchunyu chicha agé ah heno way fabréy way omawichancha. ");
INSERT INTO blw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Wat hen halenonot hen hiyatoy ammaanyu, chuséén Apudyus chàyu ta chàyu hen mangara hen chusan hen napchitan amin hen anchichay tatagu way maid karébféngana way mapchit way manepod hen namchitancha hen anchi ustoy tagu way Abel inggana hen anchi profeta way Zacarias way anà Barakias way napchit hen namfattanan hen Templo ya hen anchi cha mepatpatngan hen michaton an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tot-owa hen antoy ifagà way chàyu way tatagu way cha matagu ad uwan, chàyu angkay hen mangenkaro hen chusan hen amin cha nadchi way na-ammaan.” ");
INSERT INTO blw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Angkay hiyachi way hemhemmà Jesus hen a-amman hen anchichay iJerusalem, annaat ekatén, “Ani lawa chàyu way iJerusalem, ammag sigab hen hamhamào an chàyu, chàyu hen namchit hen anchichay profeta ya chàyu hen namuntofuntò hen anchichay hennag Apudyus way manudtuchu an chàyu. Hen laychê koma, an-og hahallimunan yanggay chàyu way kaman hen anchi cha ekaman hen manò way manaufu hen a-anàna, ngém anyug a-adchiyén. ");
INSERT INTO blw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wat ad uwan, an-ayug egad way ammag maid manalimun an chàyu. ");
INSERT INTO blw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yag manepod ad uwan, maid kasen mangil-il-anyu an haén ingganah pegwana way yachi hen mangaryanyuwén, ‘Chayawéntaaw hen annay ummale way narpon Apudyus.’ ” ");
INSERT INTO blw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Angkay hiyachi way ginumhad ah Jesus hen anchi Templo, hinib-at hen anchichay pasorotna hiya yag inlugicha way mangale hen ka-ammay hen anchi Templo ya hen anchichay hengehengena. ");
INSERT INTO blw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Oo, mamàila tot-owa hen ka-ammay hen annay Templo,” way ekat Jesus. “Ngém tot-owa hen antoy ifagà an chàyu way umchah hen anchi ag-agaw way ammag meorob amin chaha, wat maid mehàhàfa ah uray anchi natentenor-og way fato te ammag miwakas amin.” ");
INSERT INTO blw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Angkay hiyachi way tummutùchu ah Jesus hen anchi filig way Olivo, ommanggaycha hen anchichay pasorotna way émméy an hiya, yag anchaat hanhanan way mangaliyén, “Ay achi mafalin ta ifagam man paat an chàni no kamana hen umchahan hen anchi imfagam ad annad, yag heno agé hen sinyar hen kasenno umaliyan ya hen sinyar agé hen anongoh chi ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sommongfat ah Jesus way mangaliyén, “An-ayu yanggay ammag man-ar-arwad ta achiayu marokop, ");
INSERT INTO blw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","te fùnagcha angkay hen chuaray tatagu way ammag mangaliyén chicha ano agé hen hennag Apudyus way mantoray, wat ammag chuar tot-owa hen lokoponcha. ");
INSERT INTO blw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yag awniyat changrényu agé hen a-anihéb hen gufat, ya chamagényu agé hen anchichay chan aheginnufat hen anachawwéy way lota. Ngém achiayu kay cha émégyat te masapor chillu ma-ammaan chachi, ngém cha-an chillu hen anongoh chi ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Te hen mekaman wat man-aheginnufatcha hen chan totoray hen antoy lota. Ya hen ihay lota, gufaténa agé hen henlomota. Yag maid agé achina manlunigan ya umchah hen pararo way fitel. ");
INSERT INTO blw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ngém an yanggay lugrugin hen ligat amin cha natto way kaman hen anchi pés-éy émtéfan hen anchi cha umanà.” ");
INSERT INTO blw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ya ammag agorgoran chàyu hen tatagu hen antoy lota gapon afurotyu an haén, wat telewén chàyu ya pap-aligatén chàyu way tapena ya pédtén chàyu agé way tapena. ");
INSERT INTO blw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wat gapo hen hiyachi, chuarcha tot-owa hen mangentagay hen afurotcha. Wat man-ahetennocharcha hen tatagu yag man-aheginnuracha. ");
INSERT INTO blw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yag fùnagcha agé hen chuaray senang poprofeta way manlokop hen chuar way tatagu. ");
INSERT INTO blw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yag gapo ta omam-améd hen laweng way ma-ammaan hen antoy lota wat kachùran hen tatagu, ammag matarà hen layadcha hen ifacha. ");
INSERT INTO blw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngém hen anchi mangempapate hen afurotna ingganah anongohnaat mahara-an yag nì-iggaw an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yag hen anchi ammayay chamag mepanggép hen mantorayan Apudyus, wat mepagngar hen aminay karotarota ah mangammuwan hen egachay katagutagu yag anat umchah hen anchi anongoh chi egad.” ");
INSERT INTO blw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Entoroy Jesus way mangaliyén, “Wacha agé hen imfagan hen anchi profeta way Daniel ad namenghan way fùnag hen ammag aggaégyatay térén. Chàyu way mamasan natto, ma-awatanyu koma hen laychénay aryén. Yag no ilanyu hiya way inggaw hen anchi maid poros karébféngan hen tatagu way inggaw te ah Apudyus yanggay koma, ");
INSERT INTO blw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","no ilanyuchi, an-ayug omawid way i mantaro ah filig, chàyu way iJudea. ");
INSERT INTO blw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ya hen anchichay niyaphor way wachah chara hen yachiy uras, achicha koma hamham-én way hénggép way i mangara ah uray heno way alekaméncha, te masapor anchag omawid yanggay. ");
INSERT INTO blw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yag umat agé hen anchichay niyaphor way hommepot, ammag maid agé hamham-éncha ah homàyat way i mangara ah uray lawa lumfongcha, te anchag an omawid amin. ");
INSERT INTO blw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wat ammag ka-as-ase lawa hen anchichay nafufugi ya hen anchichay chan pasoso hen hiyachiy tempo. ");
INSERT INTO blw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wat anyu yanggay ammag chawatén an Apudyus ta achi koma metongpochi hen agiléd ya hen anchi ngilin way Safachu. ");
INSERT INTO blw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Te ammag pararo angkay tot-owa hen ligat hen yachiy tempo way ammag maid mepaniyana nanepod hen lugrugin hen egad ingganad uwan. Ya ah ing-inggana, maid agé kasen mepachah hen antoy lota ah kaman an nadchiy ligat. ");
INSERT INTO blw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yag no an iggay looh finifilang Apudyus hen ag-agaw way ma-ammaan cha nadchi, anchag matéy hen egachay katagutagu. Ngém gapoh ség-angna hen anchichay tatagu way penepelena, annag empa-aket chillu hen ag-agaw way ma-ammaan cha nadchi.” ");
INSERT INTO blw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Yag mag-ay agé ta wachay tagu ah mangalen chàyuwén, ‘Ilanyu ngén, antoyan hen anchi hennag Apudyus way mantoray,’ ono ekatchéén, ‘Ayé, anchayan ahchi,’ wat achiyu ammag cha afuroton. ");
INSERT INTO blw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Te fùnagcha angkay hen senang Cicristu ya senang poprofeta way mangaliyén chicha ano hen piniyar Apudyus. Yag chicha, kafaelancha way ammag mangamma hen chuar way kaskascha-aw ya sinyar way omempahaang ah manlokopancha hen tatagu ta non an mafalin, lokoponcha hen uray anchichay penepelen Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wat hamham-ényu ngén, te hen nangimfagaà amin an cha natto an chàyu ya anat ma-ammaan, ta achiayu koma marokop.” ");
INSERT INTO blw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Yag mag-ay ta wachay mangalen chàyuwén, Wacha ano ah tanap hen anchi penelen Apudyus way mantoray, achiayuwat ammag cha éméy way i mangila. Ya no ekatchéén wacha ano ah fabréy way cha-an mampàila, achiyuwat ammag cha afuroton. ");
INSERT INTO blw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Te hen miyaligan hen umaliyà way Pangorowan hen Tatagu, wat kaman hen anchi koliyapyap way no sumgid, maid achi mangila te helawana hen fùnagan hen init inggana hen malihnugana.” ");
INSERT INTO blw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ya uray heno way iggaw hen natéy, amongan way amongan hen anchichay kasole way cha manginyatagu hen natéy.” ");
INSERT INTO blw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Entoroy Jesus way mangaliyén, “No marpas chachiy ligat, ammag makorkor hen aminay maila ad uchu ya ammag machép hen init ya ammag achi homelaw agé hen hérag. Yag umat agé hen anchichay tarawat anchag maya-ayà. ");
INSERT INTO blw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ya anat agé hen hiyachi, fùnag ad uchu hen sinyar hen umaliyà way Pangorowan hen Tatagu. Wat anchag mankela hen aminay tatagu gapoh pararo way égyatcha hen mangil-ancha an haén way haén, iyaliyà hen funat way marpod uchu yag maila agé hen mannakafalin-o way anà ammag humili way térén ah kena-Apudyus-o. ");
INSERT INTO blw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yag hen hiyachi agé, mepa-ale hen anchi tangguyub way ammag chakar hen alena, yag an-owat hénagén hen anchichay a-anghel-o way éméy hen egachay karotarota ta incha amongon amin hen anchichay penepelen Apudyus way maid lawrawhancha ah uray heno way penget chi lota.” ");
INSERT INTO blw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ilanyu hen annay away way fig te wachan acharényun nadchi koma ah mangar-anyu ah hamhamàyu. Te inni-ilayu met way mag-ay no chana ilugi way umutar ya pomenge, tég-angay hen tiyargaw. ");
INSERT INTO blw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wat pachongna agé, no ilanyu way cha ma-ammaan amin hen anchichay enalè, maelasinyu koma agé way tég-angay hen mamfangchà hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tot-owa hen antoy ifagà an chàyu way achicha matéy amin hen antochay tatagu way cha matagu ad uwan ya anat ma-ammaan amin hen imfagà. Ma-ammaan amin chachi way ma-ammaan, ");
INSERT INTO blw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","te uray maumah hen antoy lota ya hen aminay maila ad uchu, wat ammag achi chillu ma-at-atob hen antochay chà enale ah ing-inggana te masapor ma-ammaan amin.” ");
INSERT INTO blw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Entoroy Jesus way mangaliyén, “Maid nangila hen anchi ag-agaw ya uras paat hen ka-ammaan amin hen anchichay imfagà. Te uray hen anchichay a-anghel ad uchu ya haén way anà Apudyus wat maid agé nangila te ah Ama yanggay hen nangila. ");
INSERT INTO blw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ya hen mekaman hen antoy lota hen mamfangchà way Pangorowan hen Tatagu, wat kaman hen nekaman hen anchi tempon Noe ad namenghan, ");
INSERT INTO blw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","way hen hiyachiy tempo, maid ekat hen anchichay tataguwén wachan mepasamak, te anchag cha mangmangan ya umin-inum ya ma-ah-ahawa inggana hen anchi hinénggépan paat cha Noe hen anchi papor. ");
INSERT INTO blw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yag ammag maid enlasincha ah ma-ammaan yag chaat map-ong hen antoy lota wat naoforcha amin. Wat kaman agéhchi hen mekaman hen mamfangchà way Pangorowan hen Tatagu. ");
INSERT INTO blw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Te hen hiyachiy tempo, no chuway larae hen hommepot, ammag aran hen anchichay anghel-o hen iha yag nehàfa hen iha. ");
INSERT INTO blw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yag umat agé no chuway fufae hen chan fayu, ammag ma-ara hen iha yag nehàfa agé hen iha. ");
INSERT INTO blw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Wat ar-arwachanyu ta an-ayug mansasaggana te maid innilayu hen ag-agaw way mamfangchà way apoyu. ");
INSERT INTO blw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hen miyaligana, no innilan hen anchi nanginfaréy hen ustoy uras hen aliyan hen anchi i mangakaw ah faréyna, kapeletan way ammag achi masmasséy te hihimnéna hen umchahana ta maid ma-akaw ah faréyna. ");
INSERT INTO blw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wat yachi agé hen ekamanyu koma way mansasaggana te haén way Pangorowan hen Tatagu, ekatyuwén cha-acha-an hen ustoy uras way mamfangchà yag inumchaha-at.” ");
INSERT INTO blw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Entoroy Jesus way mampani, ekatnéén, “Heno hen mangenlasinanyu hen anchi natalek ya naham-an way alepan. Hiya hen anchi piniyar hen ap-apona way mangemponò hen anchichay ifana way alepan ya mamangan an chicha hen tempon hen manganancha. ");
INSERT INTO blw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yag ammag laylayad hen hiyachiy alepan no aphoran hen apona hiya way cha mangamma amin hen anchi nipiyar an hiya. ");
INSERT INTO blw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Te tot-owa hen antoy ifagà an chàyu way ah kenataleknaat ammag piyarén hen anchi ap-apo hiyah mangi-ila amin hen anchichay kok-owana. ");
INSERT INTO blw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngém non an umat yag ammag achi matalek hen anchi alepan way annag ekat ah hamhamànéén maid ménat awanwani ah homàyatan hen anchi apona, ");
INSERT INTO blw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yag inluginaat way mamàpàgang hen anchichay ifana way alepan ya ammag cha i mèmèan ya cha i mì-in-inum hen anchichay amfutangén. ");
INSERT INTO blw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ngém ammagat agég hen-argawan yag hommàyatat hen anchi apona way iggay pòpo-otan hen anchi alepananchi hen uras way hàyatana, ");
INSERT INTO blw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","wat kapeletan way annag chuséén hiya ah pararo way chusa way annag etape hiya hen manusaana hen anchichay senang a-afurot. Yag ahchi, ammag pararo hen ligat te mankelakela ya magénén manngangalitféna hen fub-ana ah kaligatna.” ");
INSERT INTO blw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Entoroy Jesus way mangaliyén, “Hen mepaniyan hen mantorayan Apudyus no mamfangachà, wat kaman hen anchichay hemporoy finafallasang way wéhchiyén ummara ah helawna way i manib-at hen anchi omahawa way larae. ");
INSERT INTO blw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hen anchichay lema, anchag kaman nàong-ong. Waman hen anchichay ifacha way lema, naham-ancha. ");
INSERT INTO blw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Te hen anchichay kaman nàong-ong, anchag inligwat hen helawcha way maid innaracha ah risérfacha ah petoryu. ");
INSERT INTO blw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Waman hen anchichay naham-an, umma-aracha ah risérfan hen helawcha. ");
INSERT INTO blw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yag gapo ta nataktak hen anchi icha hib-atén, nahéyamancha way mamannéd yag nasséycha.” ");
INSERT INTO blw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Angkay hiyachi way gawan chi lafi, wachan cha mangèngaw way mangaliyén, ‘Naway hen anchi omahawa way larae wat inyu hib-atén hiya.’ ");
INSERT INTO blw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wat fummangon hen anchichay finafallasang yag inyam-ammacha hen helawcha. ");
INSERT INTO blw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yag hen anchi lema way kaman nàong-ong, chachan ochaw hen anchichay ifacha way mangaliyén, ‘Aẁ adchan chàni paat hen tapen annay petoryuyu te antoy cha ma-amin an chàni.’ ");
INSERT INTO blw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ngém sommongfat agé hen anchichay lema way mangaliyén, ‘Aẁ kaman paat achi ummatto an chitaaw amin, wat éméy-ayuwat ah tencha-an ta in-ayu lomaoh usarényu.’ ");
INSERT INTO blw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wat lummigwatcha hen anchichay kaman nàong-ong way i lomao ah usaréncha.” “Ngém hiyachi way chacha éméy, inumchahat agé hen anchi hahadchéncha. Wat hen anchichay lema way nansasaggana, nì-ighépcha an hiya way i mèlagsak yag naumfanat hen anchi hawang.” ");
INSERT INTO blw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Angkay na-awni way namfangadcha hen anchichay i lommao yag chachan harahag way mangaliyén, ‘Apo, apo fùtamto te antoyan-ani.’ ");
INSERT INTO blw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngém ammag sommongfat hen anchi ommahawa way mangaliyén, ‘Oo a, ngém maid met innilà an chàyu.’ ” ");
INSERT INTO blw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yachi yag inyanongoh Jesus way mangaliyén, “Wat yaha, masapor an-ayug mansasaggana te maid innilayu hen uras ya hen ag-agaw way mamfangchà.” ");
INSERT INTO blw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Entoroy Jesus agé way mangaliyén, “Hen mepaniyan agé hen anchi mantorayan Apudyus no mamfangachà, wat kaman hen anchi ihay ap-apo way i mamfiyahi ah achawwéy. Angkay hen lummigwatana, enayagana hen anchichay alepanna yag piniyarna chicha way mangchén hen kok-owana ");
INSERT INTO blw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","way empàchangna an chicha hen kafaelan hen ihaiha way égnan. Wat hen anchi iha, impiyarna hen lemanlifu te yachi hen kafaelana. Ya hen anchi iha, impiyarna agé hen chuwanlifu te yachi agé hen kafaelana. Yag hen anchi miyatlo, impiyarna an hiya hen henlifu te yachi agé hen kafaelana. Yag yachi way narpas yag anat lumigwat.” ");
INSERT INTO blw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Angkay hen anchi alepan way nipiyaran hen anchi lemanlifu, inyéynaat way i mangentencha wat émméy ah lemanlifu agé hen garansiyana. ");
INSERT INTO blw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yag umat agé hen anchi nipiyaran hen anchi chuwanlifu, wat yachi agé hen enkamanna, wat émméy agéh chuwanlifu hen garansiyana. ");
INSERT INTO blw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Waman hen anchi nipiyaran hen anchi henlifu, annag i enkaub way nangentaro hen anchi nipiyar an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Angkay nafayafayag yag namfangad hen anchi nangimpiyar an chicha yag annaat epa-ayag hen anchichay alepanna ta ilana hen enkamancha hen anchi impiyarna an chicha. ");
INSERT INTO blw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yachi yag émméy hen anchi nipiyaran hen lemanlifu yag ina emporang hen anchi iné-égnana way mangaliyén, ‘Apo, antoyan hen anchi lemanlifu way impiyarno an haén, yag antoyan agé hen anchi kasen lemanlifu way inyanàna.’ ");
INSERT INTO blw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Yag anat ekat hen anchi apochéén, ‘Aỳ, usto paat hen annay enkamanno. Wat ammay-a tot-owa way alepan te natalek-a. Yag gapo hen kenatalekno way nangchén hen uray akettoy, wat an-og talekén hea way mangchén ah chakchakkar. Wat umalea ta mèlam-a hen antoy laylayad-o.’ ” ");
INSERT INTO blw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Angkay hiyachi yag émméy agé hen anchi nipiyaran hen chuwanlifu, yag ina agé emporang hen anchi iné-égnana way mangaliyén, ‘Apo, antoyan hen anchi impiyarno an haén way chuwanlifu, ya antoyan agé hen kasen chuwanlifu way inyanàna.’ ");
INSERT INTO blw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yag anat ekat hen anchi apocha agéén, ‘Aỳ usto paat agé hen annay enkamanno, wat ammay-a agé way alepan te natalek-a. Yag gapo hen kenatalekno way nangchén hen uray akettoy, wat an-og talekén hea way mangchén ah chakchakkar. Wat umalea agé way metape an haén ta mèlam-a agé hen antoy laylayad-o.’ ” ");
INSERT INTO blw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Yachi yag émméy agé hen anchi nipiyaran hen henlifu yag ekatna way manlasonén, ‘Apo, innilà way an-ag térén way tagu, te an-ag cha mèawa hen enlengatan hen tapena way kaman paat annog cha fat-én hen iggayno enhamar. ");
INSERT INTO blw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wat yaha hen émmégyatà an hea wat an-og i enkaub way nangentaro hen anchi impiyarno an haén ta achi matarà. Wat antoyan kagé chillu hen anchi ustoy pelakno.’ ");
INSERT INTO blw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yag ammag sommongfat hen anchi apocha way mangaliyén, ‘An-ag laweng way alepan way ammag nasachot, te no innilam mampay way anà ammag cha mèawa hen enlengatan hen tapena way an-og cha fat-én peet hen iggay-o enhamar, ");
INSERT INTO blw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","wat pakay iggayno lawa i imfangko hen antoy pelak-o ta wacha laway aket ah anàna ah arà hen antoy mamfangchà.’ ");
INSERT INTO blw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yag annaat ifaga hen ihay alepanna way mangaliyén, ‘Aram hen anchi impiyar-o an hiya yag inidchatno hen anchi nangchén hen anchi hemporoy lifu. ");
INSERT INTO blw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Te hen anchi natalek way tagu, an mataptapyan hen midchat an hiya ingganah homawahawar. Waman hen anchi achi matalek, ammag maonghor hen anchi uray aket way wachan hiya. ");
INSERT INTO blw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wat hen ekamanyu hen annay maid sérfina way alepan, anyug etap-ar hiya hen anchi lugar way ngéngét ta ahchi hen mankelakelaana way magénén manngangalitféna hen fub-ana ah kaligatna.’ ” ");
INSERT INTO blw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Entoroy Jesus way mangaliyén, “Haén way Pangorowan hen Tatagu, hen mamfangchà hen antoy lota, etnochà hen amin anchichay a-anghel way mamàila hen kenachayaw-o. Yag yachi, tumùchuwà way mantoray ya manguwis hen amin, ");
INSERT INTO blw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","wat mepasangocha an haén hen egachay katagutagu hen antoy lota. Yachi yag an-og henhenén chicha amin way kaman hen cha manenhenan hen chan pastor hen karnero ya hen gancheng. ");
INSERT INTO blw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wat hen anchichay ammay way tatagu way kaman karnero, tênê chicha ah pachawanan-o. Waman hen anchichay laweng way kaman gancheng, tênê chicha ah pachawigì.” ");
INSERT INTO blw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Angkay hiyachi, haén way Are, ifagà hen anchichay tatagu ah pachawanan-o way mangaliyén, ‘Umaleayu, chàyu way binindisyunan Amay Apudyus ta mètapeayu hen antoy mantorayà way nesasaggana chillu para an chàyu nanepod hen na-ammaan hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Te hen enkamanyu an haén, hen hommenaangà wat penanganà an chàyu. Ya hen nàwawà, penainumanà agé an chàyu. Yag tàén anà funag ah fabréyyu, menangiliyà an chàyu. ");
INSERT INTO blw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yag angkay maid agé lumfong-o yag linumfonganà an chàyu. Yag hen nansaketà, henalimunanà an chàyu. Yag hen nifaruchà, finisitaà an chàyu.’ ");
INSERT INTO blw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yachi yag hen anchichay tatagu way ammayén Apudyus, manhanhancha way mangaliyén, ‘Apo, maid met innilani ah hommenaangam yag penanganni hea. Yag maid agé innilani ah nàwawam yag penainumanni hea. ");
INSERT INTO blw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yag nokay agé hen nangil-anni hen kenafunagno yag menangilini hea ono ah maid lumfongno yag wachan inidchatni way lumfongno. ");
INSERT INTO blw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ya maid met agé nangil-anni ah nansaketam yag henalimunanni hea, ya ah nifarucham yag finisitani hea.’ ” ");
INSERT INTO blw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Wat haén way man-are, somongfatà an chicha way mangaliyén, ‘Tot-owa hen antoy ifagà an chàyu way uray heno way enammaanyu hen anchi uray lawa ka-arohaehan way cha omafurot an haénat, kaman haén chillu hen nangammaanyu an cha nadchi.’ ” ");
INSERT INTO blw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Angkay hen anchichay ten-én-o ah pachawigì, ifagà agé an chicha way mangaliyén, ‘Lomayaw-ayuwat, chàyu way machudchusa, te an-ayug metap-ar hen anchi mannanayun way apoy way nesasaggana ah metap-aran Chumunyu ya hen anchichay a-anghelna. ");
INSERT INTO blw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Te tàén chaà manhenaang, iggayà penangan an chàyu, yag hen nàwawà, iggayà agé penainuman an chàyu. ");
INSERT INTO blw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yag angkay hen kenafunag-o ah fabréyyu, iggayà agé menangili an chàyu. Yag ah kommorangan hen lumfong-o, iggayà adchan ah lumfong. Yag iggayyu agé halimunan haén hen nansaketà ya iggayyu agé fisitéén haén hen nifaruchà.’ ");
INSERT INTO blw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yachi yag anchaat somongfat way mangaliyén, ‘Apo, maid ay innilani ah hommenaangam ono ah nàwawam. Ya maid ay agé amin innilani ah kenafunagno ono ah nansaketam ono ah nifarucham ah iggayni mangasekasowan an hea. Ya maid agé innilani ah kommorangan hen lumfongno yag iggayni adchan hea.’ ” ");
INSERT INTO blw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Yag songfatà chicha way mangliyén, ‘Tot-owa hen antoy ifagà an chàyu way hen anchi nangachiyanyu way tomorong hen uray anchi ka-arohaehan way cha mangafurot an haén, yachi angkay agé hen nanga-adchiyanyu way tomorong an haén.’ ");
INSERT INTO blw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wat hiyachi, mepééy amin cha nadchi hen anchi mannanayun way ligat ah machusaancha ah ing-inggana. Ngém hen anchichay ammayén Apudyus, mètagucha an hiya ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Angkay lempas Jesus way nangintudtuchu amin an cha nadchi, imfagana hen anchichay pasorotna way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Innilayu way ah hin-uchumat milugi hen anchi lagsak way manmanma-an hen iggay namchitan hen anghel hen a-anà hen anap-otaaw ad Egipto. Wat hen tempon hen hiyachiy lagsak, haén way Pangorowan hen Tatagu, midchatà hen anchichay tatagu way mangenlansa an haén hen koros.” ");
INSERT INTO blw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yag hen anchichay ap-apon hen papachi ya anam-ama way ponò hen Judio, na-amongcha tot-owa ah faréy hen anchi kangatowanay pachi way ah Caifas ");
INSERT INTO blw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ta man-a-atopàpàcha no heno hen ekamancha way manelew an Jesus ah achi ma-am-ammuwan yag pinchitcha. ");
INSERT INTO blw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ngém hen ekatcha, achi koma paat metongpo hen anchi lagsak te awni yag magurucha hen tatagu. ");
INSERT INTO blw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Angkay hiyachi yag wacha cha Jesus ad Betania ah faréy cha Simon way nakkonet hen anchi ar-argaw. ");
INSERT INTO blw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yag hen chacha manganan, ammag hinénggép hen ihay in-ina way nan-é-édchan ah pichuru way na-ammaan ah fato way alebastér way natatarwan ah ammag nanginay lana, yag annag inhiyat ah urun Jesus. ");
INSERT INTO blw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Angkay hen nangil-an hen anchichay pasorotna an nadchi, ammag lommaweng hen hamhamàcha yag anchaat mangngorongor way mangaliyén, “Pakay lawa annag lamraménha, ");
INSERT INTO blw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ta annaat koma an enlao ah pelak ta wacha laway midchat hen anchichay maid mafalinna.” ");
INSERT INTO blw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngém ah Jesus, ammuna chillu hen anchi chacha aryén yag annaat ekatén, “Pakay iyu chumsekén hen antoy in-inaanto, te usto met ya ammay hen antoy enammaana an haén. ");
INSERT INTO blw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ya no mepanggép hen manoronganyu hen anchichay maid mafalinna, anchag mawawà-acha met. Ngém haén, achi mafayag hen mì-iggawà an chàyu hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Te hen annay nanginhiyatana hen anchi lana hen achar-o, yaha angkay hen nangensaganaana hen milufuà. ");
INSERT INTO blw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yag tot-owa hen antoy ifagà an chàyu way amin hen antoy lota way mitudtuchuwan hen anchi ammayay chamag wat mahaphapet agé hen enammaan hen antoy in-inaanto ah manamham-an hen tatagu an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Angkay hiyachi agé yag ah Judas Iscariote way ihay pasorot Jesus, émméy hen anchichay anap-apon hen papachi way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Kamana kay paat hen mamayadyu an haén no etochar-o ah Jesus an chàyu.” Yag finilangcha hen toronporo way pelak yag imfayadcha an hiya. ");
INSERT INTO blw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yag nanepod hen hiyachi, inluginat Judas way manginyanap hen wayana way mangentochar an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Angkay hiyachi way inumchah hen anchi pés-éy ag-agaw hen anchi lagsak way manganan hen Judio hen anchi tenapay way achi mepabnar, yag i henanhanan hen anchichay pasorot Jesus an hiya way mangaliyén, “Chuud hen laychém way mangensaganaanni hen manganantaaw hen anchi lagsak way manmanma-an hen iggay napchitan hen a-anà hen anap-otaaw.” ");
INSERT INTO blw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yag anat ifagan Jesus an chicha way homàyatcha ah fabréy ta icha ifaga hen anchi ihay tagu way mangaliyén, “Imfagan hen anchi aponi way tég-angay umchah hen matéyana, wat antoy faréyyu ano hen mangananni hen antoy lagsak way Manmanma-an.” ");
INSERT INTO blw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yachi yag lummigwatcha tot-owa hen anchichay pasorot Jesus way icha enammaan hen aminay chana imfaga yag ensaganacha hen manganancha hen hiyachiy lagsak. ");
INSERT INTO blw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Angkay hiyachiy nadhém, naliliub cha Jesus ya hen anchichay pasorotna way mangan. ");
INSERT INTO blw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yag hen chacha manganan, imfagan Jesus an chicha way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way wacha angkay hen iha an chàyu way mangentochar an haén.” ");
INSERT INTO blw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wat ammag ngommehpéy hen hamhamàcha amin yag wéhchiyén chana hanhanan way mangaliyén, “Ay haén ngata, Apo.” ");
INSERT INTO blw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yag anat ekat Jesusén, “Hen anchi migsan an haén way mangensawsaw hen anchi anéna wat hiya hen mangentochar an haén. ");
INSERT INTO blw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Haén way Pangorowan hen Tatagu, pédténà chillu te yachi hen looh nesosorat way mekaman an haén. Ngém kàka-ase hen anchi ammag mangentorod way mangentochar an haén, te un-unninaat non an iggay koma niyanàchi way tagu.” ");
INSERT INTO blw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yachi yag nan-ale ah Judas way hiya chillu hen mangentochar yag ekatnéén, “Ay ammoh haén, Apo.” Yag ekat Jesusén, “Oo, enalem kayyà.” ");
INSERT INTO blw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Angkay hiyachi way chacha mangan, innaran Jesus hen ihay tenapay yag anat manyaman an Apudyus yag penetpet-angna, yag annaat iwaras hen anchichay pasorotna way mangaliyén, “Anto, aranyu ta anényu te yato hen achar-o.” ");
INSERT INTO blw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yachi yag annaat agé aran hen hentasa way fayah yag kasen nanyaman an Apudyus, yag annaat agé idchat an chicha way mangaliyén, “Mì-inum-ayu amin an natto ");
INSERT INTO blw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","te yato hen charà way mifùfù ah macharosan hen fasor hen chuaray tatagu way yato agé hen manot-owaan hen anchi kà-amma way torag Apudyus. ");
INSERT INTO blw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yag tot-owa hen antoy ifagà an chàyu way achiyà kasen umin-inum ah fayah ingganah umchah hen anchi ag-agaw way mantorayan Apudyus way yachi hen mì-inumà an chàyu hen anchi faru way fayah.” ");
INSERT INTO blw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Angkay hiyachi way nankankantacha yag ginumhadcha way éméy hen anchi tagéytéy ad Olivo. ");
INSERT INTO blw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Angkay na-awni yag imfagan Jesus hen anchichay pasorotna way mangaliyén, “Awniyat anà ammag taynan an chàyu amin hen yatoy lafi, te an-ayug omawid amin gapon ma-ammaan an haén. Te yaha chillu hen laychén hen anchi nesosorat way alen Apudyus way aryén way ekatnéén, ‘Pédtén Apudyus hen anchi minya-achug wat anchag miwa-at amin hen anchichay karnerona.’ ");
INSERT INTO blw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngém no man-uchiyà, mamangpangowà hen provinsiyan hen Galilea ta ahchi hen man-aheil-antaaw.” ");
INSERT INTO blw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yachi yag nan-aleyat ah Pedro way mangaliyén, “Aẁ, uray angkay taynancha-a hen antochay tapenaat achi angkay mafalin way taynà hea.” ");
INSERT INTO blw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngém ekat Jesus an hiyéén, “Tot-owa angkay hen antoy ifagà an hea way achi manollaò hen manò hen yato paatay lafi yag mametluwémat way mangenhoot an haén.” ");
INSERT INTO blw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ngém ammag tenlén Pedro way mangaliyén, “Aẁ achì chillu ehoot hea, tàén yachi hen mìyatéyà an hea.” Yag yachi agé hen enalen amin hen anchichay tapena. ");
INSERT INTO blw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Angkay hiyachi yag émméy cha Jesus ya hen anchichay pasorotna hen anchi lugar way ekatchéén “Getsemani,” yag annaat ifaga an chicha way mangaliyén, “Itùchuyu an natto ta iyà manluwaru hen anchi ê-éyna.” ");
INSERT INTO blw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yag entàtaenna cha Pedro ya hen anchi chuway a-anà Zebedeo way cha Jaime an Juan, yag inlugina way tomkar way ammag chémméghénay térén hen hamhamàna. ");
INSERT INTO blw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yag annaat ekat an chichéén, “Ammag amchan hen antoy hamhamào way kaman paat ammag narégna ah iyatéy-o, wat inggaw-ayu an natto ta i-illanà.” ");
INSERT INTO blw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yag anat kasen éméy hen ê-éyna way ammag nanlùfub way manluwaru way mangaliyén, “Amay Apudyus, no mafalin koma, achi meparufus hen antoy ligat way tég-angay mepachah an haén. Ngém uray no yahan chawat-o, laychê chillu way ma-ammaan yanggay hen laychém way faén hen laychê.” ");
INSERT INTO blw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yachi yag namfangad ah Jesus hen iggaw hen anchi toroy ifana yag inchahana chicha way nanasséy. Yag annaat ekat an Pedro way mangaliyén, “Ay achi mafalin ta i-illanà ah uray lawa ihay uras. ");
INSERT INTO blw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Achiayu koma cha masséy ta an-ayuwat an manluwaru agé ta achiayu ma-awis way fumasor. Tot-owa way wachan layadyu ah hamhamàyu way mangamma hen usto, ngém an-ayu cha ma-afà ah kenakapsot hen acharyu.” ");
INSERT INTO blw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yachi yag kasen émméy chillu way i manluwaru way mangaliyén, “Amay Apudyus, no achi mafalin way mafalewan hen antoy mepasamak an haén way an-o yanggay ammag harémén, wat ta ma-ammaan chillu hen laychém.” ");
INSERT INTO blw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yachi yag anat kasen agé mamfangad yag inchahana agé chillu hen anchichay toro way nanasséy te ammag amchan hen héyépcha. ");
INSERT INTO blw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yachi yag annaat kasen taynan chicha way émméyna epetlo way manluwaru ah ina nangimfag-an an Amana hen anchichay chana chillu imfaga. ");
INSERT INTO blw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yag angkay namfangad kasen hen iggaw hen anchichay ifana yag ekatnan chichéén, “Ay étégyu chillu way nanasséy way chan inungar. Ilanyu ngénat inumchah angkay hen anchi uras way haénay Pangorowan hen Tatagu wat midchatà hen anchichay lawengay tatagu. ");
INSERT INTO blw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wat fangon-ayuwat ta intaaw te ilanyu ngén, nawayat hen anchi mangentochar an haén.” ");
INSERT INTO blw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ammag étég Jesus way chan ale yag inumchahat ah Judas way iha hen anchichay hemporo ya chuway pasorotna yag wachacha agé hen anchichay ene-etnodna way ammag chuaray tatagu way namfafangngidcha amin ya nampapang-orcha way chicha hen anchichay hennag hen anap-apon hen papachi ya hen anam-ama way ponò hen Judio. ");
INSERT INTO blw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yag imfafaggan chillu Judas an chicha way mangaliyén, “Hen anchi tagu way mangentomoà hen tapào hen apengna ah mangempàil-à hen rispitù, hiya hen chayu anapén wat telewényu.” ");
INSERT INTO blw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yachi yag émméyat ah Judas an Jesus way mangaliyén, “Apo, ay hea peetha.” Yag entomònaat hen tapàna hen apeng Jesus. ");
INSERT INTO blw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yag ekatat Jesusén, “Ayéat sonod, ammaamat hen anchi ganchatno.” Yachiyat yag émméy hen anchichay tatagu way i namchéng an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yag hen hiyachi agé, ammag nan-ohfùat hen anchi ihay ifan Jesus hen fangidna way fuma-ag yag fina-agnaat hen ihay alepan hen anchi kangatowan way pachi, yag naporhan hen ingana. ");
INSERT INTO blw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yag enamhewat Jesus hiya way mangaliyén, “Ichùchùnowat man hen annay fangidno, te no fangid hen eharà wat fangid agé hen iyatéy. ");
INSERT INTO blw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yag ammoh maid peet innilam way non an-o an chawatén an Ama wat man-epalena hen kalifulifu way anghel way manarà an haén. ");
INSERT INTO blw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ngém non an yaha hen ammaà, achi ma-ammaan hen anchi nesosorat ad namenghan way ekatnéén masapor ma-ammaanto.” ");
INSERT INTO blw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Angkay hiyachi yag imfagan Jesus agé hen anchichay chuaray tatagu way mangaliyén, “Ammoh futangelowà ta masapor mamfafangngid-ayu ya mampapang-or-ayu way i manelew an haén. Ammag enag-agaw met way nìtutùchuwà an chàyu ahchih Templo way mantudtuchu yag pakay iggayà telewén hen hiyachi nò. ");
INSERT INTO blw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngém yato chillu hen mekaman ah tomot-owaan hen ensosorat hen anchichay profeta ad namenghan.” Yachi yag anchag ommawid amin hen anchichay pasorot Jesus way anchag tenaynan hiya. ");
INSERT INTO blw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Angkay hen anchichay nanelew an Jesus, inyéycha hiyah faréy cha Caifas way kangatowan way pachi, te ahchi hen na-a-ammongan hen anchichay siguchay cha mintudtuchu hen orchin Moses ya hen anchichay anam-ama way ponò hen Judio. ");
INSERT INTO blw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ngém ah Pedro, chinumchum-ang way cha umunud inggana hen anchi fatawan hen faréy hen pachiyanchi, yag anat i mìtùchu hen anchichay chan guwarcha ta ilana no nokay hen mekaman an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yag angkay ah faréy, cha iyanap hen anchichay anap-apon hen papachi ya amin hen anchichay o-okom way konsel hen mangempafasorancha an Jesus ta wachay lasoncha way mangempapchit an hiya. ");
INSERT INTO blw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ngém ammag maid chillu inchahancha, tàén anchag chuar hen cha manginchérém an hiya ah kétém. Ngém angkay hiyachi yag tommàchég hen chuway tatagu way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Hen yahay tagu wat ekatnéén kafaelana ano way mamakas hen anchi Templon Apudyus yag annaat kasen sà-achén hen unig hen ma-atloy ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hiyachi yag tommàchégat hen anchi kangatowan way pachi way mangalen Jesusén, “Ayé, pakay achim songfatanha. Ay tot-owa hen anchi enalecha.” ");
INSERT INTO blw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngém ammag gummiginnang chillu ah Jesus. Yag anat kasen man-ale hen anchi kangatowanay pachi way mangaliyén, “Ah kenasa-ad-o, an-o yanggay ammag mancharén hea way manongfat an natto ah mangngaran hen anchi natattagu way Apudyus, wat ay hea tot-owa hen anàna paat way Cristu way hahadchénni way umale.” ");
INSERT INTO blw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yag anat somongfat ah Jesus way mangaliyén, “Tot-owaha hen annay enalem. Ngém hen ifagà an chàyu amin, no marpas hen antoy mekaman an haén, wat ilanyu haén way Pangorowan hen Tatagu way tumutùchu hen pachawanan hen anchi mannakafalin way Apudyus. Yag ilanyu agé hen kasen-o umaliyan way marpod uchu way iyaliyà hen funat.” ");
INSERT INTO blw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hen nangngaran hen anchi kangatowan way pachi hen nangaryan Jesus an nadchi, annag entanong way nangissay hen lumfongna gapoh pararo way aningarngarna way cha mangaliyén, “Ammag mampachinarto way mamréh hen kena-apudyus Apudyus, wat ay ammoh masapor wachay kasen anapén ah man-istigu hen fasorna. Te chengngartaaw met amin hen anchi aggaégyat way enalena. ");
INSERT INTO blw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wat nokay hen hamhamàyu ah ekaman an hiya nò.” Yag ekatchéén, “Narégnaha ah iyatéyna.” ");
INSERT INTO blw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yag chachaat toptoppaan hen féharna yag chacha lopropagén. Yag hen tapena agé, finongotcha hen matana ya anchaat tappetén way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ayé ang, ifagam no heno hen nanappet an hea no hea tot-owa hen hennag Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Angkay ah Pedro, étégna way nìtutùchu ah fatawa yag émméy an hiya hen ihay fufae way katorong hen anchi kangatowan way pachi yag ekatnéén, “Uray met agé heaat, hea hen iha way cha netnetnod an Jesusanchi way narpod Galilea.” ");
INSERT INTO blw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngém ammag enhoot Pedro hen sangwanancha amin way mangaliyén, “Maid angkay innilà hen annay cham aryénanna.” ");
INSERT INTO blw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yag lommayaw way émméy hen liwangan hen anchi fatawa. Ngém hiyachi, innilan agé hen ihay katorong way fufae hiya, yag annaat ifaga hen anchichay tatagu way atàtàchég way mangaliyén, “Annayan angkay agé hen ihay cha netnetnod an Jesusanchi way eNazaret.” ");
INSERT INTO blw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yag kasen agé enhoot Pedro way annag ensapata way mangaliyén, “Maid angkay tot-owa innilà hen annay taguwanna.” ");
INSERT INTO blw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Angkay na-awni agé, émméycha an hiya hen tapen anchichay lenarae way atàtàchég way mangaliyén, “Aẁ hea kayyà hen ihay ifana te mamab-én met hen ayug hen alem.” ");
INSERT INTO blw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yag ammag kaskasen hen nangenhootan Pedro te annag ensapata way mangaliyén, “Uray anà ammag chuséén an Apudyus no faén tot-owa hen antoy chà ifaga way maid poros innilà hen annay taguwanna.” Yag hen hiyachi, nanollaoat tot-owa hen anchi manò. ");
INSERT INTO blw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yag hemhemma-at agé Pedro hen anchi imfagan Jesus an hiya hen nangaryanéén, “Achi manollaò hen manò yag penetlomat way mangenhoot an haén.” Yag lommayawat ah Pedro way ammag paket hen kelana. ");
INSERT INTO blw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Angkay hiyachi way cha pomaway, na-amongcha amin hen anchichay anap-apon hen papachi ya anam-ama way ponò hen Judio way mantotopà no nokay hen ekamancha way mangempapchit an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wat hen enkamancha, kenanselancha hiya yag inyéycha way i mangemporang an Pilato way gubérnador. ");
INSERT INTO blw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Angkay hiyachi yag ah Judas way hiya hen anchi nangentochar an Jesus, hen nangammuwana way ancha peet epapchit ah Jesus, ammag lommaweng hen hamhamàna yag nan-a-amuyu hen enammaana, wat ina imfangad hen anchi toronporo way pelak hen anchichay anap-apon hen papachi ya anam-ama way ponò hen Judio way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Aẁ, fummasorà peet te an-og empatelew hen anchi tagu way ammag maid fasorna.” Ngém anchag senongfatan hiya way mangaliyén, “Maid ay fiyangnihna wat egad-a.” ");
INSERT INTO blw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wat ammag enhapowà Judas hen anchi pelak ah Templo yag lommayaw way ammag i namfit-ar. ");
INSERT INTO blw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yag hen anchichay anap-apon hen papachi, incha tenomtoman hen anchi pelak yag ekatchéén, “Marabseng met hen orchin Apudyus no elamongtaawto hen anchi pelak ah Templo, te hen hiyato wat laon hen fiyag chi tagu.” ");
INSERT INTO blw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wat hen nahalenonotan hen nantatagépfarancha, ancha i enlao ah lota way lotan hen anchi chan chid-iwin ah fanga ta wachay chacha manginlufuan hen funag way tatagu way faén Judio. ");
INSERT INTO blw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wat ingganad uwan, nangadnan hen anchi lotaanchi ah nachar-an way lota gapo hen anchi narpowan hen laona. ");
INSERT INTO blw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Wat yachi hen tommot-owaan hen ena-allen hen anchi profeta way Jeremias ad namenghan hen nangaryanéén, “Hen anchi toronporo way pelak way yachi hen enafunan hen anchichay ganà Israel ah ustoy laona, innarachachi ");
INSERT INTO blw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","yag imfayadcha hen anchi lotan hen anchi chan chid-iwin ah fanga way yaha chillu hen imfafaggan Apudyus an haén way ma-ammaan.” ");
INSERT INTO blw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Angkay hiyachi yag empasangocha ah Jesus an gubérnador way Pilato, yag anat hanhanan Gubérnador way mangaliyén, “Ay hea ano hen Aren hen Judio.” Yag ekat Jesusén, “Oo, tot-owa hen annay enalem.” ");
INSERT INTO blw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngém ammag achi songsongfatan Jesus hen anchichay ap-apon hen papachi ya anam-ama way ponò hen Judio hen chacha mangempafasoran an hiya. ");
INSERT INTO blw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yag anat ekat Pilatowén, “Pakay achim songfatan hen annay chacha epafasor an hea.” ");
INSERT INTO blw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngém ammag gummiginnang chillu ah Jesus way maid senongsongfatana ah uray ihà-an hen anchi chacha epafasor an hiya, wat yachi hen ammag nahahaangan Gubérnador. ");
INSERT INTO blw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tenawén way no tempon hen anchi lagsak way Manmanma-an, ammag nigangay an Gubérnador way mangemparufus hen ihay farud way chawatén hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yag hen hiyachiy tempo, netongpo way wacha hen ihay farud way ammag nanhemamag hen kenarawengna way ah Jesus Barabas hen ngachanna. ");
INSERT INTO blw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Angkay na-amongcha hen anchichay chuaray tatagu, imfagan Gubérnador an chicha way mangaliyén, “Heno hen laychényu way eparufus-o, ay ah Jesus way ekatchéén Barabas ono ah Jesusanto way ekatchéén Cristu.” ");
INSERT INTO blw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yahan imfagan Gubérnador te nadlawna way oma-annig hen apés yag inchérémcha ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ya hen iha agé, hen anchi tummutùchuwana hen anchi tùchu way chana mangu-uwwisan hen tatagu, ammag enawatnaat agé hen sorat ahawana way ekatnéén, “Achim paat cha fib-iyangan hen yahay tagu way maid poros fasfasorna, te anà ammag émmégyat hen anchi in-inép-o ad arubyan mepanggép an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ngém hen anchichay anap-apon hen papachi ya anam-amma way ponò hen Judio, ancha peet ammag sinubsufan hen anchichay na-a-among way tatagu ta ifagacha way ah Barabas hen meparufus ta ah Jesus hen mepapchit. ");
INSERT INTO blw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wat hen nangimohan Gubérnador no heno hen laychéncha way eparufusna an chicha way chuwa, anchag ekat aminén ah Barabas. ");
INSERT INTO blw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yag ekat agé hen anchi Gubérnadorén, “Oo a, ngém nokay hen ekaman-o an Jesus nò way ekatchéén hennag Apudyus.” Yag anchaat agé ekat aminén, “Anyug elansa hiya hen koros.” ");
INSERT INTO blw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yag anat ekat Gubérnador agéén, “Pakay, nokay paat hen enammaana way laweng ah ina melansaan hen koros.” Yag ammag kaskasen way anchag heo-ongaw amin hen anchichay tatagu way mangaliyén, “Elansayu man hiya hen koros.” ");
INSERT INTO blw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Angkay hiyachi way mailan Gubérnador Pilato way maid sérfin hen chana ifaga te awni yag magurucha hen tatagu, wat ammag nampa-arah chanum yag namfuru hen sangwanan amin hen anchichay tatagu way mangaliyén, “Yato hen mangil-anyu way maid angkay fib-iyang-o hen mangempapchitanyu hen hiyatoy tagu wat an-ayug egad.” ");
INSERT INTO blw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yag anchaat ammag hesosongfat hen anchichay tatagu way mangaliyén, “Yasa ta an-anig egad ya hen ganàni no hen mepapchitana hen kachusaanni.” ");
INSERT INTO blw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wat hiyachi yag emparufus Gubérnador Pilato ah Barabas yag empahapratna ah Jesus ya annaat eporang hiya hen anchichay mangenlansa hen koros. ");
INSERT INTO blw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Angkay hiyachi yag inyéy hen anchichay sorchachun Gubérnador Pilato ah Jesus ah faréy Gubérnador yag enamongan amiamin hen anchichay sorchachu hiya. ");
INSERT INTO blw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yag anchaat farchan yag emparumfongcha hen anchi chittakan ah manging-inghancha hen lumfong chi are. ");
INSERT INTO blw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yag anchaat agé fumallengawngaw ah pagat ah kaman koronan chi are yag inhùrubcha ah uruna, ya anchaat agé epachén hen lunu ah awanna way yachi ano hen hor-od hen are. Yag anchaat sénsén-én hiya way magénén namparpalentomangcha lawa hen henagongna way mangaliyén, “Ta matattagua ah ing-inggana, heay aren hen Judio.” ");
INSERT INTO blw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ya anchaat agé toppatoppaan hiya ya ancha agég lenapchù hen anchi lunu way inégnanana yag enhapratcha hen uruna. ");
INSERT INTO blw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Angkay narpas way sensennacha, kasencha senokatan hen anchi emparumfongcha yag iniggacha hen anchi siguchay lumfongna yag anchaat iyéy way i mangenkoros. ");
INSERT INTO blw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Angkay hiyachi way chacha iyéy ah Jesus, hinib-atcha hen ihay tagu way eCirene way ah Simon hen ngachanna, yag anat ammag peletén hen anchichay sorchachu hiya way mamu-ud hen anchi koros Jesus. ");
INSERT INTO blw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Angkay inumchahcha hen anchi lugar way ekatchéén “Golgota” way hen laychénay aryénat alentutugun chi uru, ");
INSERT INTO blw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","yag anchaat idchat an Jesus hen fayah way na-ahrangan ah apgu. Yag angkay henemhemana, annag iggay inumun. ");
INSERT INTO blw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yachi yag anchaat elansa hiya hen koros yag anchaat mamfunfunnot way manginyàchang hen anchichay lumfongna, ");
INSERT INTO blw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","yag anchaat itùchu way manguwarcha an hiya. ");
INSERT INTO blw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yag empòatcha agé hen petchayan hen uruna hen anchi ekatchéén fasorna way hen ensoratcha, ekatnéén, “Yato ah Jesus way Aren hen Judio.” ");
INSERT INTO blw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yag hen hiyachi agé, enkoroscha hen chuway futangelo way nanggagaw-éncha ah Jesus te ah pachawananna hen iha ya ah pachawigina hen iha. ");
INSERT INTO blw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yag hen anchichay chan looh way tatagu, chachan wigwigiwig way mangensorto an Jesus way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ayé kay umpaya, anggayhaat ekatnowén fakasém hen Templo yag senà-adno hen petlon hen ag-agaw, wat hara-am kay mampay hen annay acharno. Yag no hea tot-owa hen anà Apudyusat gumhad-a umpay hen annay korosanna.” ");
INSERT INTO blw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yag umat agé hen anchichay anap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin Moses ya hen anchichay anam-ama way ponò hen Judio, chacha amin agé sénsén-én hiya way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Annag tenorongan hen tapena yag achi makatorong hen acharna. Yag hiya met ano agé hen Aren hen ganà Israel. Non an gumhad paat hen annay koros wat afurotontaaw kaỳ way ah Apudyus hen narpowana. ");
INSERT INTO blw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Chana agé ano manokchun ah Apudyus, yag ah Apudyus agé ano hen nangen-anà paat an hiya. Wat ilantaaw kaya no laychén Apudyus way mangenharà an hiya ad uwan.” ");
INSERT INTO blw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yag uray agé hen anchi chuway futangelo way nekokollosén yachi agé hen enkamancha way cha manénséna an hiya. ");
INSERT INTO blw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Angkay hiyachi way ustoy nanggawa, ammag hommelangat agé amin hen lota ingganah fummatangan. ");
INSERT INTO blw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yag yachi way fummatangan, nan-ongaw ah Jesus way mangaliyén, “Eli eli lama sabaktani,” way hen laychénay aryénat, “Amay Apudyus, pakay manchùganà.” ");
INSERT INTO blw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ngém hen nangngar hen tapen anchichay atàtàchég, kaman ah Elias hen enalena yag anchaat ekatén, “Chana peet fagaan ah Elias.” ");
INSERT INTO blw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yag anat managtag hen iha way inna ensawsaw hen lopot hen anchi ommelém way fayah yag annaat epa-at hen lunu way manginchawchaw an Jesus ta sosopona. ");
INSERT INTO blw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngém enamhew hen anchichay tapena way mangaliyén, “Awni ta hahadchéntaaw kaya ta ilantaaw no umale tot-owa ah Elias way mangenharà an hiya.” ");
INSERT INTO blw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hiyachi yag kasen nan-ongaw ah Jesus yag anongohnachi hen fùfuohna. ");
INSERT INTO blw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yag hen hiyachi, ammag nan-agwa hen anchi ammag séchar way kortena way horchà hen iggaw Apudyus paat ah Templo way ammag nanlugi ad uchu yag nanadnad ad char-ém. Yag nanlunig agé ya ammag natémtémang hen uray anchichay chéprah. ");
INSERT INTO blw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yag umat agé hen anchichay lufù wat anchag nafùtan yag chuarcha hen anchichay tatagun Apudyus way nan-atéy way anchag nan-uchi, ");
INSERT INTO blw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","wat lommayawcha hen anchi lurufùcha. Yag hen karpasan hen nan-uchiyan Jesus, émméycha ad Jerusalem way chuar hen nangila an chicha ahchi. ");
INSERT INTO blw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yag hen anchi kapetan ya hen anchichay sorchachuna way cha manguwarcha an Jesus, hen nangil-ancha hen aminay nekaman ya hen nangìnaancha amin hen anchi lunig, anchag émmégyat way térén yag ekatchéén, “Tot-owa peet way hiya hen anà Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yag hen hiyachi agé, wachacha hen ê-éyna hen chuar way finufae way nangi-ila hen cha mekaman way chichachi hen nenetnod way tommorong an Jesus hen narpowancha ad Galilea. ");
INSERT INTO blw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Hen wachan nadchi wat ah Maria way eMagdalena yah Maria way inan cha Jaime an Jose ya anat agé hen anchi ahawan Zebedeo. ");
INSERT INTO blw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Angkay cha madhém, ummale hen ihay faknang way iyArematea way ah Jose hen ngachanna way hiya agé hen ihay sommorot an Jesus. ");
INSERT INTO blw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yachi yag émméy an Pilato way i manawat hen achar Jesus, yag imfagan Pilato way mafalin arana. ");
INSERT INTO blw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yachi yag namfangad ah Jose yag ina lenaharah hen achar Jesus ya annaat funifunan ah am-ammayay uroh, ");
INSERT INTO blw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","yag ina enehlò way nangempabfég hen anchi anat na-ammaan way lufù way yachiy lufù, chéprah way anna an empatoktok way manlufùna koma. Yag yachi way iniggana hen anchi natéy yag annaat allinén hen chakaray fato way tépà ah entangébna yag anat lomayaw. ");
INSERT INTO blw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yag cha Maria way eMagdalena ya anat hen anchi ihay Maria, wachacha way tummutùchu hen ê-éyna way nanahagang hen anchi lufù. ");
INSERT INTO blw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Angkay hiyachi way nafigat way ngilin te Safachu, incha na-among ah faréy Gubérnador Pilato hen anchichay anap-apon hen papachi ya hen anchichay Fariseo, yag imfagacha an hiya way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Apo, hemhemmàni uwa hen enalen hen anchi nangéttémanchi hen cha-anna matéyan way ekatnéén man-uchi ano hen petlon hen ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wat ammay ménat no homnag-a koma ah éméy manginyam-amma paat way manguwarcha hen anchi lufù inggana hen miyatloy ag-agaw, te awni yag anchag éméy hen anchichay pasorotna way ammag mangenlayaw hen acharna yag anchaat lawa ammag ekatén an nan-uchi. Yag no yachi wat ammag kaskasen, a, way chùchùar hen marokop way tatagu no hen anchi pés-éyna.” ");
INSERT INTO blw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Wat emparufus Pilato way mangaliyén, “Okaỳ, annachayan hen sorchachu wat iyéyyu chicha ta incha guwarchaan ah péppég chi kafaelancha.” ");
INSERT INTO blw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yachi yag inyéycha tot-owa hen anchichay sorchachu yag lenetaletacha hen tangéb hen anchi lufù yag anchaat lomayaw way enhàfacha hen anchichay sorchachu way mangguwarcha an nadchi. ");
INSERT INTO blw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Angkay narpas hen anchi ngilin way Safachu yag cha pomaway hen Chuminggu, lummigwat cha Maria way eMagdalena ya hen anchi ihay Maria way éméy ah lufù. ");
INSERT INTO blw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yag hen hiyachiyat ammag nanlunig ah napegsa yag ammag enémhép hen ihay anghel Apudyus way narpod uchu yag inna enallin hen tangéb hen anchi lufù yag tinùchuwana. ");
INSERT INTO blw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yag hen itchurana, ammag cha humiliy térén way kaman koliyapyap, yag hen lumfongna agé, ammag pokkawan way térén. ");
INSERT INTO blw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wat hen nangil-an hen anchichay guwarcha an hiya, anchag chan papayagpag ah égyatcha yag ancha ammag narangad way kamancha natéy. ");
INSERT INTO blw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ngém hen anchichay finufae, tenagépfar hen anchi anghel chicha way mangaliyén, “Achiayu cha émégyat te innilà chillu hen inyu ilan way hiya ah Jesus way nelansa hen koros. ");
INSERT INTO blw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ngém maid angkay hiyahto te nan-uchi met way yachi chillu hen imfafaggana an chàyu. Wat umaleayu ngén ta inyu ilan hen anchi nepabfégana. ");
INSERT INTO blw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wat in-ayuwat ta inyu ifaga hen anchichay pasorotna way nan-uchi tot-owa hiya wat epangpangona agé ad Galilea way ahchi hen mangil-ancha an hiya. Ilanyuwat ta achiyu aliw-an hen antoy imfagà an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yachi yag tenaynanchaat hen anchi lufù way chacha émég-égyatén lommaylayadcha. Yag chacha managtag way i mangimfaga hen ifagacha hen anchichay pasorot Jesus. ");
INSERT INTO blw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ngém hen chacha lomayawan, anchag hinib-atat agéh Jesus yag annaat ekat an chichéén, “Nokay hen ayanyu.” Yag anchaat ammag mampalentomang hen henagongna way inégnanancha hen he-ena way manayaw an hiya. ");
INSERT INTO blw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Achiayu cha émégyat,” way ekat Jesus, “in-ayuwat ta inyu ifaga hen anchichay sosnod-o ta éméycha ad Galilea way ahchi hen mangil-ancha an haén.” ");
INSERT INTO blw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Angkay hiyachi way chacha éméy hen anchichay finufae, hommàyatchaat ah fabréy hen tapen anchichay chan guwarcha yag henaphapetcha hen aminay na-ammaan ah lufù hen anchichay anap-apon hen papachi. ");
INSERT INTO blw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wat hen anchichay papachi, enayagancha hen anchichay anam-ama way ponò hen Judio yag nantatagépfarcha no heno hen ekamancha. Yachi yag anchag penasoksokan hen anchichay sorchachu way nangguwarcha ah ammag chakaray pelak way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Hiyato hen haphapetényu hen tatagu. Ifagayu way ummalecha hen anchichay pasorotna hen lafi yag incha enakaw hen anchi acharna hen nanasséyanyu. ");
INSERT INTO blw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yag achiayu agé machanagan no changrén Gubérnador chato te egad-ani way mangensoplekar hen amin an hiya wat achi chàyu chillu pafasoron.” ");
INSERT INTO blw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yachi yag enawat hen anchichay sorchachu hen anchi pelak yag enafurotcha paat tot-owa hen anchi nifaga an chicha. Yag ingganad uwan, yachi hen cha iwarawarawag hen anchichay Judio. ");
INSERT INTO blw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Angkay hen anchichay hemporo ya ihay pasorot Jesus, émméycha hen anchi tagéytéy hen provinsiyan hen Galilea way ekat Jesusén manib-atana an chicha. ");
INSERT INTO blw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yag yachi way innilacha hiya, chachaat chayawén. Ngém wachacha chillu hen tapena way chan chuwachuwa hen hamhamàna no tot-owa way ah Jesuschi. ");
INSERT INTO blw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yachi yag hommag-én ah Jesus an chicha way mangaliyén, “Nipiyar an haén hen fiyang hen egachay wacha ad uchu ya hen antoy lota ");
INSERT INTO blw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","wat hénagà chàyu way éméy hen aminay kafabréfabréy hen antoy lota ta tudtuchuwanyu hen aminay tatagu ta omafurotcha an haén ah mampasorot-o. Yag funyaganyu chicha ah mangempàila way nètetempoyugcha an Amay Apudyus ya an haén way anàna ya hen Espirituna. ");
INSERT INTO blw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ya tudtutudtuchuwanyu agé chicha ta afurotoncha hen aminay imfagà an chàyu. Yag achiyu agé cha ar-aliw-an way anà ammag mawawà-acha an chàyu ah ing-inggana.”");
INSERT INTO blw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yato hen anchi ammayay chamag way mepanggép an Jesu Cristu way anà Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hen nilugiyana wat hen tommot-owaan hen anchi ensorat hen anchi profeta way Isaias way yachi hen ena-allen Apudyus an anàna, ekatnéén, “Wacha hen ihay tagu way faarê way mamangpango no hea ta ina esasaggana hen anchichay tatagu ta changréncha-a. ");
INSERT INTO blw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hiya hen anchi ini-inggaw hen anchi chanak way chana èngaèngaw hen anchichay tatagu way mangaliyén, ‘Naway hen ap-apo, wat iyam-ammayu hen chayu am-ammaan ya manggadngényu hen hamhamàyu.’ ” ");
INSERT INTO blw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yag angkay hiyachi yag fummùnag tot-owa ah Juan hen anchi chanak ah tommot-owaan hen anchi nesosorat, yag chana funyagan hen tatagu ya chana epagngar an chicha way mangaliyén, “Masapor ifafawiyu hen fasoryu ya mafunyagan-ayu ah mangempàil-anyu way nanchùganyu tot-owa hen anchi laweng way a-ammayu, wat pakawanén Apudyus chàyu.” ");
INSERT INTO blw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yachi yag anchag chuar hen anchichay tatagu way narpod Jerusalem ya hen kafabréfabréy way provinsiyan hen Judea way cha ummunud an Juan way i mamangngar hen anchi chana itudtuchu. Ya anchaat agé epudnu hen fasorcha yag anat funyagan Juan chicha hen anchi wangwang way ekatchéén Jordan. ");
INSERT INTO blw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Hen lumfong Juananto way chan funfunyag, ammag na-afar way chotchot hen anchi animar way kemér ya gadchang agé hen sentoronna. Yag hen chana agé iyatagu wat chuchun ya chilu. ");
INSERT INTO blw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yag imfagana agé hen anchichay tatagu way mangaliyén, “Wacha hen anchi meparég an haén way ammag nangatngato no haén te uray lawa hen anà man-alepan an hiyéén achì karébféngan. ");
INSERT INTO blw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Te haén, chanum yanggay hen infunyag-o an chàyu. Waman hiyaat hen Espiritun paat Apudyus hen ifunyagna an chàyu.” ");
INSERT INTO blw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Angkay hiyachi way chan funyag ah Juan, ummale tot-owa ah Jesus way narpod Nazaret way fabréyna way provinsiyan hen Galilea, yag émméy an Juan way i mampafunyag hen anchi wangwang way Jordan. ");
INSERT INTO blw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yag angkay tommàchang ah Jesus, innilana way ammag nanfuatat agé ad uchu yag cha émhép hen anchi Espiritun Apudyus an hiya way kaman karopate. ");
INSERT INTO blw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yag wachaat agé hen nan-ale ad uchu way mangaliyén, “Hea hen anchi laylaychê way anào, yag hea agé hen mangemparaylayad an haén.” ");
INSERT INTO blw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hen hiyachi, hennagat hen anchi Espiritun Apudyus ah Jesus way éméy hen ihay lugar way maid fummabréy. ");
INSERT INTO blw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yag yachi way émméy, ini-inggaw ahchi ah opatporo way ag-agaw, yag cha awiawisén Chumunyu way ap-apon hen ongtan ta fumasor. Yag wachacha agé hen hiyachiy lugar hen ammag aggaégyat way nanka-atap way animar. Ngém wachacha chillu agé hen anchichay anghel way émméy mangi-ila an hiya. ");
INSERT INTO blw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Angkay hiyachi way nifarud ah Juan way chan funfunyag, namfangad ah Jesus hen provinsiyan hen Galilea yag inlugina way mangintudtuchu hen anchi ammayay chamag way narpon Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Intudtuchuna way mangaliyén, “Inumchah ad uwan hen manot-owaan Apudyus hen imfafaggana, wat tég-angay hen manorayana hen amin. Wat manchùganyu hen aminay laweng way a-ammayu ya afurotonyu paat hen antoy ammayay chamag.” ");
INSERT INTO blw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Angkay hiyachi way cha manaran ah Jesus hen penget hen anchi fayfay way Galilea, innilana hen hen-agi way mangagadchiw way cha Simon an Andres hen ngachancha way chacha eporwak hen tafukorcha hen anchi fayfay. ");
INSERT INTO blw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yachi way innilan Jesus chicha, imfagana way mangaliyén, “Ehàfayu chaha ta metnod-ayu an haén, wat sokatà hen annay chunuyu ta hen tatagu hen atenglényu ah omafurotancha an haén.” ");
INSERT INTO blw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yag hen hiyachi, anchag enhàfa hen anchi tafukorcha yag netnodchaat an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Angkay hiyachi way nànàéycha, innilan agé Jesus hen kasen hen-agi way cha Jaime an Juan way anà Zebedeo way tummutùchucha hen anchi fangkacha way chacha taramanén hen tafukorcha. ");
INSERT INTO blw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yag hen nangil-an Jesus an chicha, enayagana wat netnodcha agé an hiya way tenaynancha ah amacha hen anchi fangka ya hen anchichay tatagu way cha mèlabfu an hiya. ");
INSERT INTO blw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Angkay hiyachi, émméy cha Jesus ya hen anchichay pasorotna ad Capernaum. Yag angkay yachi way Safachu way ngilincha chillu way Judio, hinénggépcha hen anchi chacha ma-am-amongan way sinagoga yag inlugin Jesus way mantudtuchu. ");
INSERT INTO blw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yag anchaat agég nahaang amin hen anchichay tatagu te hen anchi enkamanna way nantudtuchu, faén kaman hen cha ekaman hen anchichay siguchay cha mintudtuchu hen orchin Moses, te maila way wachan karébféngana way mantudtuchu. ");
INSERT INTO blw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yag hen hiyachi, wachaat agén hinénggép way ihay am-ama way nahurugan ah ongtan way ammag nan-ongaw way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Heay Jesus way eNazaret, heno hen ammaam an chàni. Ay an-a an ummale way i manachael an chàni, te inni-ilà angkay hea way hea hen anchi nepoposta way na-apudyusan way empalena.” ");
INSERT INTO blw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yag menancharat Jesus hen anchi ongtan way mangaliyén, “Guminang-aat man ta lomayaw-a hen annay nihuhullugam.” ");
INSERT INTO blw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yag ammag empa-adhar hen anchi ongtan hen anchi am-ama yag nan-ongaw way lommayaw. ");
INSERT INTO blw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yag hen nangil-an hen anchichay tatagun nadchi, ancha ammag nahaang way térén. Yag chachan pepennoot way mangaliyén, “Apay henoto, ay kadchachatoto way tudtuchu, te pakay wachan kafaelana nò way manmanchar way uray ongtanén afurotonchaat hen ifagana.” ");
INSERT INTO blw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yachi yag ammag nanhemamagat hen mepanggép an Jesus hen anchichay kafabréfabréy hen anchi provinsiyan hen Galilea. ");
INSERT INTO blw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Angkay hiyachi way lommayaw cha Jesus hen anchi sinagoga way cha ma-am-amongan hen Judio yag émméycha ah faréy cha Simon an Andres yag nàyéy agé cha Jaime an Juan way hen-agi. ");
INSERT INTO blw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Angkay inumchahcha, imfagachaat an Jesus way ammag chan saket hen anchi atogangan Simon way ammag amchan hen pochotna. ");
INSERT INTO blw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wat émméy ah Jesus an hiya yag inégnanana hen limana way namangon ya ammag naka-anat hen saketna, yag ammag hiyaat agé hen nan-alekatto hen nanganan cha Jesus. ");
INSERT INTO blw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Angkay nalihnug hen init, inyéy hen anchichay tatagu an Jesus hen aminay masaket ya hen anchichay nahurugan ah ongtan. ");
INSERT INTO blw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wat aminay tatagu hen hiyachiy fabréy, anchag na-among amin hen anchi fatawan cha Simon, ");
INSERT INTO blw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","yag kena-an Jesus hen nankarakarase way saket hen anchichay ammag chuar way tatagu ya emparyawna agé hen anchichay nihuhurug way ongtan, yag empawana agé hen mangaryancha mepanggép an hiya te chicha, innilacha no henoh Jesus. ");
INSERT INTO blw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Angkay nawakas, fummangon ah Jesus hen na-apeh yag ginumhad way i manluwaru hen ihay lugar way maid tatagu. ");
INSERT INTO blw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Angkay pommaway way fummangon cha Simon ya hen anchichay ifana, émméycha way i manganap an hiya. ");
INSERT INTO blw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yag angkay inchahancha, ekatchéén, “Lonaycha angkay hen tatagu way cha mangimoh an hea.” ");
INSERT INTO blw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngém ekat Jesus an chichéén, “Uray te masapor éméytaaw chillu hen tapen hen fabréy ta iyà agé tudtuchuwan chicha, te yaha chillu hen ganchat-o way ummale hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wat yachi yag ginéggégga-aycha amin hen anchichay kafabréfabréy hen provinsiyan hen Galilea. Yag aminay fabréy way émméyancha wat nantudtuchu ah Jesus hen anchi cha ma-am-amongan hen Judio, yag emparyawna agé hen anchichay nihuhurug way ongtan. ");
INSERT INTO blw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Angkay hiyachi, wachan ihay tagu way chan saket hen anchi aggaégyatay saket way konet, wat émméy an Jesus yag nampalentomang way mampangpanga-ase way mangaliyén, “Afurotò way wachan kafaelam way manga-an hen antoy saket-o no anno an ka-asiyan haén.” ");
INSERT INTO blw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wat ammag naség-angan ah Jesus yag annaat tad-én hiya way mangaliyén, “Ka-asiyà tot-owa hea, ta maka-an hen annay saketno.” ");
INSERT INTO blw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yag hen hiyachi ammag naka-anat tot-owa hen anchi saketna way ommammay hen acharna. ");
INSERT INTO blw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yag anat téngtéténgténgén Jesus hiya way mangaliyén, “Achim paat cha haphapetén ah uray heno way tatagu hen antoy enammaà an hea. Yag manidchiwéh-aat way i mamparang hen anchi pachi ta ilana way naka-an hen saketno. Yag an-aat manchaton an Apudyus hen anchi inyurchin Moses way michaton ah manot-owaan hen tatagu way naka-an hen anchi saketno.” ");
INSERT INTO blw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yachiyat agéy lommayaw hen anchi tagu, annaat agég an inwarawarawag way manaphapet hen anchi enkaman Jesus an hiya. Wat gapon yachi, achi mafalin eparang Jesus hen acharna way hénggép hen anchichay fabréy. Wat annag cha iyapet way éméy hen lugar way maid fummabréy, yag yachin cha mangunuchan hen tatagun hiya way maid achicha narpowan. ");
INSERT INTO blw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Angkay hiyachi way nanlooh hen kamanay ag-agaw, namfangad ah Jesus ad Capernaum yag nanchinngar way hommàyat. ");
INSERT INTO blw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wat ammag enamongan hen chuar way tatagu hiya ingganah anchag hommortot hen tatagu ah faréy yah hawang. Yag cha itudtuchun Jesus an chicha hen anchi chamag mepanggép an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yachi way chan tudtuchu, inumchahcha hen opatay tatagu way nangimfufulig hen ihay am-ama way napàroy hen acharna. Ichidchiwéhcha koma an Jesus, ");
INSERT INTO blw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ngém maid én-énnéncha way hénggép gapoh kachuar hen tatagu, wat anchag inyéy ah tabfongan yag tenòwapcha hen anchi atép way nemamangan Jesus, yag inuy-uycha hen anchi pelay ah faréy way iné-émfég hen anchi allakwangna. ");
INSERT INTO blw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yag angkay enlasin Jesus way anchag nanchinlan amin hiya, imfagana hen anchi napàroy way mangaliyén, “Heay sonod, napakawan hen fasorno.” ");
INSERT INTO blw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Niyaphor way wachacha agé hen nìya-among way tapen hen anchichay siguchay cha mintudtuchu hen orchin Moses. Yag yachi way chengngarcha hen yachi, chinumsekcha ah Jesus ah hamhamàcha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nokay paat ano hen lébféng nahha way annag cha pérhén hen kena-apudyus Apudyus, te ah Apudyus met paat yanggay hen mafalin mamakawan hen fasor.” ");
INSERT INTO blw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngém hen hiyachi enlasinat chillu Jesus hen anchi wachah hamhamàcha yag annaat ekatén, “Pakay peet kaman henay hamhamàyu. ");
INSERT INTO blw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ay ammoh wachay ekatyuwén narakraka. Te ammoh wachay kafaelan hen tagu way mamakawan hen fasor. Yag ay ammoh wacha agéy kafaelan hen tagu way manga-an hen penàroy hen tagu. ");
INSERT INTO blw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngém ah manot-owaanyu way haén way Pangorowan hen Tatagu, wachan lébféng-o hen antoy lota way mamakawan hen fasor wat ka-anê hen penàroyna.” Yag annaat ifaga hen anchi napàroy way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Hen ifagà an hea, fumangon-a yag inaram hen annay allakwangno yag ommanamot-a.” ");
INSERT INTO blw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yag yachi way cha ilan amin hen anchichay tatagu hiya, ammag tommàchégat agé hen anchi napàroy yag innarana hen anchi allakwangna yag chaat manaran way lomayaw. Wat anchag nahaang way térén hen anchichay tatagu yag chinayawcha ah Apudyus way mangaliyén, “Nanepod hen natatagguwanni, maid paat innilani ah kaman an cha natto.” ");
INSERT INTO blw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Angkay hiyachi way lommayaw cha Jesus ad Capernaum, kasen émméy ah Jesus hen penget hen anchi fayfay way Galilea, yag enamongan hen ammag chuar way tatagu hiya, wat tinudtuchuwana chicha. ");
INSERT INTO blw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yag angkay na-awni way cha manadchad-aran, innilana hen ihay cha mangam-among ah furor way tummutùchu hen opesenana way ah Levi hen ngachanna way anà Alfeo. Yag anat ifagan Jesus an hiya way mangaliyén, “Umaleaat ta somorot-an haén.” Yag naranigwat tot-owa ah Levi way somorot an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Angkay na-awni way cha mangan cha Jesus ya hen anchichay pasorotna ah faréy cha Levi, ummunudcha an hiya hen anchichay chuaray cha mangam-among hen furor ya anat agé hen anchichay tapenay menangfasor, wat chuarcha way nèofong an chicha. ");
INSERT INTO blw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yag angkay hen tapen anchichay Fariseo way siguchay cha mintudtuchu hen orchin Moses, hen nangil-ancha hen nèofongan Jesus hen anchichay cha mangam-among hen furor ya hen tapenay menangfasor, chinumsekcha hen anchichay pasorotna way mangaliyén, “Ay ammoh mèofong peet hen annay apoyu hen tatagu way kaman an cha nahha way laweng.” ");
INSERT INTO blw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yachi way chengngar Jesuschi yag anat mampani way mangaliyén, “Hen anchichay wachan saketna, yachi hen kasaporan hen choktor way hen miyaligana, haén, iggayà ummale way manudtuchu hen anchichay ammayay tatagu te ummaliyà way manudtuchu hen anchichay menangfasor.” ");
INSERT INTO blw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Angkay hen-argawan, chacha amin manlangan way mangan hen amin anchichay pasorot Juan way chan funfunyag ya anat agé hen anchichay Fafariseo. Ngém hen anchichay pasorot Jesus, achicha chan langan. Wat émméycha hen tapenay tatagu an Jesus way mangaliyén, “Pakay amin hen anchichay pasorot Juan ya umat agé hen anchichay pasorot hen Fariseo wat chacha amin manlangan, ngém pakay hen annachay pasorotno way anchag achin langan nò.” ");
INSERT INTO blw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Senongfatan Jesus ah pani way mangaliyén, “Ay ammoh manlangancha hen anchichay tatagu way i mèkasar hen anchi ifacha way komasar. Achi met. Yag kaskasen no mawawà-acha agé hen anchi komasar wat sigurachu way mamangngancha. ");
INSERT INTO blw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngém umchah chillu hen ag-agaw way melayaw hen anchi komasar, wat yachi hen umchahan hen manlanganancha way achicha manganan.” ");
INSERT INTO blw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yachi yag kasen nampanih Jesus way mangaliyén, “Maid tagu ah ammag mangid-op hen anchi faru way lopot hen anchi naropà way lumfong. Te no yachin ammaana, émhén hen anchi faru way lopot yag enagamidna hen anchi nid-opana yag kaskasenat agé hen kagissayana. ");
INSERT INTO blw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yag umat agé hen anchi faru way fayah way finanar, wat achi mafalin way ifongofongchi hen anchi nausar way gadchang way amoto, te achi matantan hen anchi nausar way gadchang wat ammag fumtà yag ayyua a hen finanaranchi ya hen anchi gadchang agé. Wat hen anchi faru way fayah, masapor agé hen anchi faru way gadchang hen mifongofongana.” ");
INSERT INTO blw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Angkay hen-argawan way Safachu way ngilin chillu hen Judio, cha manaran cha Jesus ya hen anchichay pasorotna hen ihay chacha murmur-an ah pagéycha. Yag hen anchichay pasorotna, chacha umarah otteméncha. ");
INSERT INTO blw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yag anat fistigarén hen anchichay Fariseo ah Jesus way mangaliyén, “Ilam ngén hen annay cha ammaan hen pasorotno, chacha labsengén hen anchi orchintaaw way epawana hen mamfat-an hen ngilin.” ");
INSERT INTO blw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yag anat somongfat ah Jesus way mangaliyén, “Ay ammoh maid finasayu hen enkaman hen anchi apotaaw way David ad namenghan hen tempon hen hommenaangana ya hommenaangan agé hen anchichay ifana. ");
INSERT INTO blw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te anna met ammag hinggép hen anchi faréy Apudyus hen tempon Abiatar way kangatowan way pachi yag innarana hen anchi tenapay way nichachaton an Apudyus way ekat hen orchintaawén anggay hen pachi hen mangan. Ngém enan chillu David ya ummidchat agé hen anchichay ifana. Wat maid met ekattaawén fasornachi.” ");
INSERT INTO blw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wat henalenonot Jesus way mangaliyén, “Masapor ma-awatanyu way wadwadcha hen tatagu no hen ngilin, te enammaan Apudyus hen ngilin ah pagsaya-atan hen tatagu way iggayna an enammaan hen tatagu ah pagsaya-atan hen ngilin. ");
INSERT INTO blw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yag haén way Pangorowan hen Tatagu, haén hen nangimfiyang way mangimfaga hen ma-ammaan hen ngilin.” ");
INSERT INTO blw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Angkay hen-argawan way Safachu way ngilin chillu, nì-ighép ah Jesus hen anchi cha ma-am-amongan hen Judio yag niyaphor way wacha agéhchi hen ihay tagu way nàis-is hen limana. ");
INSERT INTO blw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ngém wachacha agé hen tapenay tatagu way ancha paat ammag seseppotan ah Jesus no ka-anéna hen inis-is hen anchi taguwanchi way tàén ngilin ta wachay minchérémancha koma an hiya. ");
INSERT INTO blw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yachi yag enayagan Jesus hen anchi nàis-is hen limana way mangaliyén, “Umaleahto ah sangwanan.” ");
INSERT INTO blw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yag annaat agé hanhanan hen anchichay tatagu way mangaliyén, “Nokay hen eparufus hen orchintaaw way ma-ammaan hen tempon hen ngilin. Ay ammaantaaw hen ammay ono hen laweng. Ay taguwéntaaw hen ifa ono pédténtaaw.” Ngém anchag achi somongsongfat. ");
INSERT INTO blw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yachi yag ommaningarngar ah Jesus way nangila an chicha ngém chaat agé chillu maség-ang an chicha, te anchag térén way achi matudtuchuwan. Yachi yag annaat ifaga hen anchi nàis-is hen limana way mangaliyén, “Uyachém hen annay limam.” Inuyadna yag ammag ommammayat agé hen anchi limana. ");
INSERT INTO blw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wat ginumhadcha hen anchichay Fariseo way inchaat man-a-atopàpà hen anchichay ifan Are Herod ta anapéncha hen ekamancha way mamchit an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Angkay hiyachi yag émméy cha Jesus ya hen anchichay pasorotna hen penget hen anchi fayfay way Galilea, yag ammag chuar hen anchichay tatagu way cha mangunu-unud an hiya way maid achicha narpowan. Te wachacha hen narpon anchichay provinsiyan hen Galilea ya Judea. ");
INSERT INTO blw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ya narpocha hen tapena ad Jerusalem ya anat hen tapena hen sakopon hen Idumea ya hen sakopon agé hen fafabréy way Tiro ya Sidon. Ya wachacha agé hen anchichay narpo hen fafabréy way lahin hen anchi wangwang way Jordan. Amin cha natto way tatagu, chengngarcha hen anchichay enammaan Jesus wat yachi hen ummunuchancha way mangila an hiya. ");
INSERT INTO blw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yag gapo hen karonay hen anchichay tatagu, imfagan Jesus hen pasorotna ta esaganacha hen fangka ah iggawana ta achicha ammag ipetén hiya. ");
INSERT INTO blw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Te gapon nanga-anana hen sasaket hen chuar way tatagu wat chachan ep-eporyoh amin hen anchichay tapena ah homag-énancha paat an hiya ta tad-éncha koma agé. ");
INSERT INTO blw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yag hen anchichay nahurugan agé ah ongtan, no mag-ay ilancha ah Jesus wat anchag manlùfub hen henagongna way man-ongaw way mangaliyén, Hea hen anà Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngém menanchar Jesus hen anchichay nihuhurug way ongtan ta achicha paat ifagfaga ah uray heno way tagu way hiya hen anà Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Angkay hiyachi, enayagan Jesus hen anchichay tatagu way laychénay ayagan yag inyéyna chicha hen anchi ihay tagéytéy. Yag angkay enamongancha hiya ahchi, ");
INSERT INTO blw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","penelena hen hemporo ya chuwa ta man-ifana paat ya ta wacha agéy chana hénagén way i manudtuchu hen tatagu. Yag ngenadnana chicha ah aposel ");
INSERT INTO blw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","yag inidchatna agé an chicha hen kafaelancha way mangemparyaw hen nihuhurug way ongtan. ");
INSERT INTO blw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hen anchichay hemporo ya chuwa way penelena, wat ah Simon hen iha way ngenadnana ah Pedro, ");
INSERT INTO blw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ya anat cha Jaime an Juan way anà Zebedeo way ngenadnana chicha ah Boanerges way hen laychén nadchiy ngachan way aryénat kaman hen echor. ");
INSERT INTO blw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ya hen anchichay tapena wat cha Andres an Felipe, ah Bartolome ya ah Mateo, ah Tomas ya ah Jaime way anà Alfeo, ah Tadeo ya anat ah Simon way ekatchéén “Selot,” ");
INSERT INTO blw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ya anat agé ah Judas Iscariote way hiyan anchi nangenlao an Jesus hen ommawni. ");
INSERT INTO blw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Angkay hiyachi way hommàyat cha Jesus, ammag kasen agé enamongan hen chuaray tatagu hiya wat ammag maid én-énnéncha way mangan. ");
INSERT INTO blw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yag angkay chengngar hen anchichay ahimfafaryan Jesus hen nekaman, émméycha ta icha koma ehàyat, te hen ekat hen anchichay tatagu wat an nattagar ano ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yag hen tapen anchichay siguchay cha mintudtuchu hen orchin agé way narpod Jerusalem, chacha agé ekatén, “An nahurugan ah Jesus hen anchi ap-apon hen chumunyu way ah Beelzebub, wat hiya ano hen cha mangidchat hen kafaelana way mangemparyaw hen tapen hen nihuhurug way ongtan.” ");
INSERT INTO blw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yachi yag anat amongon Jesus hen anchichay tatagu yag nampani way mangaliyén, “Ay ammoh mafalin eparyaw chumunyu ah chumunyu. ");
INSERT INTO blw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hamham-ényu ngén, te no maid tetempoyug hen tatagu hen ihay lota way anchag chan sososongel, ay ammoh achi afaén hen henlomota chicha. ");
INSERT INTO blw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yag no maid agé tetempoyug hen ihay himfafaryan way anchag chan sososongel, ay ammoh achicha mahihiyan. ");
INSERT INTO blw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yag umat agé ah chumunyu, no maid tetempoyugcha way ekatyuwén ah chumunyu hen cha mangemparyaw hen ahenchumunyuna, kapeletan way anchag ma-afà amin yag mapéppég hen kafaelancha.” ");
INSERT INTO blw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ah katot-owana, maid makaghép hen faréy hen anchi orheorhe way i mangara hen ginaona no achina unna tawichén hen anchi orheyanchi yag annaat mafalin aran hen anchichay kok-owana. Orhe tot-owa ah Chumunyu ngém ena-afào chillu hiya, yag a-allà agé hen kok-owana.” ");
INSERT INTO blw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Tot-owa way tot-owa hen antoy ifagà an chàyu way aminay karasen hen fasor way ammaan hen tatagu wat mafalin mapakawan way uray hen mangsotancha an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngém heno way mangaliyén Chumunyu hen nangidchat hen kafaelan way ah katot-owanaat Espiritun Apudyus hen nangidchat, yachi hen fasor way ammag achi mapakpakawan ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yachi hen imfagan Jesus te wachacha hen mangaliyén ah Chumunyu ano hen nìyachar an hiya way cha mangidchat hen kafaelana yag faénat agé te hen Espiritun Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Angkay hiyachi way inumchah ah inan Jesus ya hen anchichay sosnodna, tommatàchégcha ah chara way cha mangempa-ayag an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yag hen anchichay chuar way tatagu way niya-among an Jesus, ekatchéén, “Anchichayan cha inam ya hen sosnodno ah chara way chacha-a epa-ayag.” ");
INSERT INTO blw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yag sommongfat ah Jesus way mangaliyén, “Faén yanggay chicha hen ifilang-o ah inà ya sosnod-o.” ");
INSERT INTO blw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yag lenangranganat hen anchichay tatagu way nanliliub an hiya way mangaliyén, “Cha natto agé hen chàcha-ar-o ya sosnod-o, ");
INSERT INTO blw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","te heno way tagu way mangamma hen laychén Apudyus wat chichachi hen chàcha-ar-o ya sosnod-o.” ");
INSERT INTO blw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Angkay hiyachi, kasen agé émméy cha Jesus hen penget hen anchi fayfay way Galilea ta i mantudtuchu. Yag gapon kachuar hen anchichay tatagu way na-among, ammag hinénggép ah Jesus hen ihay fangka yag yachin tummùchuwana way chinumchum-ang ah aket. Yag hen anchichay tatagu, anchag ahetàtàchég hen anchi tarantag. ");
INSERT INTO blw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yachi yag anat mampani way chuar hen intudtuchuna an chicha hen chana nampaniyan. Ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Changrényu ngén hen antoy ifagà way hen-argawan ano, wacha hen ihay tagu way i nanmura hen lotana. ");
INSERT INTO blw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yag hen chana minwalehan hen fukar, ammag nemamang hen tapena hen anchi charan. Yag émméychaat hen anchichay kasole way i nangan amin. ");
INSERT INTO blw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yag hen tapena, anchag nemamang hen anchi pafinatto way ammag aket hen lotana. Yag cha-an mahen-awniyan yag hommangawcha tot-owa te wachan aket way lotana. ");
INSERT INTO blw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngém angkay yachi way ummini-init, anchaat agég nàrong te akettoy hen anchi lota wat maid lommamotancha yag anchag narango amin. ");
INSERT INTO blw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yag hen tapen agé hen anchi fukar way niwaleh, nemamangcha hen anchi papenagat. Manowat te lenomtàcha ngém angkay lommafang hen anchi pagat, anchag henyong hen anchi mura. Wat anchag iggay mamunga. ");
INSERT INTO blw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ngém hen tapen hen anchi niwaleh, nemamangcha hen anchi ammayay lota yag penémhéd hen tummufuwancha. Wat namungacha amin way magénén hinggagsot hen fungan hen tapena ya hen-én-ém poporo hen tapena ya hentotlon poporo agé hen tapena.” ");
INSERT INTO blw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yahan penanin Jesus yag annaat ekatén, “Chengngaryu hen antoy penanì te naingaan-ayu, wat hamham-ényu koma hen laychénay aryén.” ");
INSERT INTO blw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Angkay na-awni way anggay ah Jesus, émméycha hen anchichay hemporo ya chuway pasorotna ya anat agé hen anchichay tapena way nangngar hen anchi penanina, yag henanhanancha no henon laychén nadchiy aryén. ");
INSERT INTO blw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yag anat ekat Jesus an chichéén, “Chàyu way cha somorot an haén wat mifaga an chàyu yanggay hen anchichay cha-an mepaka-ammu mepanggép hen anchi mantorayan Apudyus. Waman hen anchichay tapena way achi omafurot, an lawag pahig panpani hen ifagà an chicha. ");
INSERT INTO blw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Te ilanyu ngén, ‘Uray ta i-illancha, ancha chillug achi elasin. Yag uray agé ta chachangréncha, ancha chillug achi ma-awatan. Te non an paat ancha anapén ta ma-awatancha, manhagongcha an Apudyus yag penakawanna agé chicha.’ ” ");
INSERT INTO blw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yachi yag anat ekat Jesus an chicha way mangaliyén, “Ay iggayyu peet agé ma-awatan hen anchi penanì mepanggép hen anchi i nanwaleh ah fukar. Wat no yahaat ay nanggilah ma-awatanyu hen tapenay paniyê.” ");
INSERT INTO blw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yag annaat esoplekar an chicha way mangaliyén, “Hen miyaligan hen anchi fukar, yachi hen alen Apudyus. Ya hen anchi chan waleh, hiya hen anchi cha manginwarawag. ");
INSERT INTO blw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yag hen niyaligan hen anchi charan way émméyan hen anchi tapen hen fukar, chichachi hen anchichay tatagu way nangngar hen alen Apudyus, yag émméyat ah Chumunyu yag ina menaid hen chengngarcha. ");
INSERT INTO blw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yag hen anchi pafinatto agé way émméyan hen tapena, wat chichachi hen anchichay tatagu way nangngar hen alen Apudyus way layyalayyadcha hen pés-éyna. ");
INSERT INTO blw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngém ammag achi lomamot ah hamhamàcha te an hen-aketan yanggay hen ommafunancha. Te no umchah hen problemacha ya mapaligatancha gapon ommafurotancha, anchag iyanggayan. ");
INSERT INTO blw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yag umat agé hen anchi papenagat way émméyan hen tapen anchi fukar, wat yachin anchichay tatagu way nangngar agé hen alen Apudyus, ");
INSERT INTO blw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ngém ammag nahyong hen chengngarcha. Te gapon pangégcha ah mangar-ancha hen masapor hen antoy ataguwan ad uwan ya gapo agé hen layadcha way fumaknang ya anat hen chuar agé way laychéncha way mangamoamong hen antoy lota, wat chichachi hen kaman nanyong hen chengngarcha way alen Apudyus, wat ammag maid nantongparan hen chengngarcha. ");
INSERT INTO blw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngém hen anchi ammay way lota way émméyan hen tapen hen fukar, chichachi hen anchichay tatagu way nangngar hen alen Apudyus yag enafurotcha. Wat wachan imfungacha way magénén hinggagsot hen tapena ya hen-én-ém poporo hen tapena ya hentotlon poporo agé hen tapena.” ");
INSERT INTO blw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Entoroy Jesus way mampani, ekatnéén, “No wachay mamasgéd ah helaw, ay ammoh hàufana ono anna i igga ah selok hen kama. Achina met, te anna an epatang hen anchi ustoy mepatngana ta mahelawan amin. ");
INSERT INTO blw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hamham-ényu ngén te aminay netataro, umchah hen meparangana. Ya umat agé hen amin way achi ma-ammuwan ad uwan, umchah hen mepaka-ammuwana chillu.” ");
INSERT INTO blw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“Chengngaryu hen antoy penanì te naingaan-ayu, wat hamham-ényu koma hen laychénay aryén.” ");
INSERT INTO blw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yachi yag anat ekat Jesus agéén, “Masapor papannaagényu hen antoy chà aryén, way heno way ekamanyu hen tapena, kaman agéhchi hen ekaman Apudyus an chàyu yag am-améd chillu hen ekamanna an chàyu. ");
INSERT INTO blw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yag hen anchi tagu way mangamma hen chana changrén, wat mataptapyan hen ma-awatana. Waman hen anchi tagu way annag achi ammaan hen chana changrén, wat uray hen anchi aket way na-awatana wat ammag maonghor.” ");
INSERT INTO blw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kasen agé nampani ah Jesus way mangaliyén, “Hen miyaligan hen mantorayan Apudyus wat kaman hen ihay tagu way inna minur-an hen lotana. ");
INSERT INTO blw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yachiy narpas, yag no madhémén nasséy. No ag-agawén i hommepot. Yachiyat agé, lenomtà hen anchi minura yag chacha lomafang. Ngém achina ma-awatan no nokay hen enkamancha way lenomtà ya hen chacha ekaman way lomafang. ");
INSERT INTO blw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Te hen anchi lota hen nangempatufu hen anchi mura ah mamungaana way hen pés-éy fùnagat hen anchi tufuna yag inlugina way mamfugi, yag kasen agé yag hen mafégahana. ");
INSERT INTO blw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yag angkay naggahan, émméy hen anchi nanginmura yag ina fintà te inumchah hen mabta-ana.” ");
INSERT INTO blw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Entoroy Jesus way mantudtuchu yag ekatna way manarudsuchén, “Nokay ngata hen mempachongantaaw hen mantorayan Apudyus ya nokay agé hen kasentaaw manginyaligan. ");
INSERT INTO blw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hen ihay miyaligana, wat kaman hen anchi ka-ak-akettoyan way fukar hen antoy lota way i inmuran hen ihay tagu hen garchinna. ");
INSERT INTO blw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yag angkay lenomtà, ammag hiyaat agé hen kachachakkaran way mura ah garchin. Wat ah kachanakkar hen pangana, incha hommòfot hen anchichay kasole.” ");
INSERT INTO blw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Intudtutudtuchun Jesus hen alen Apudyus hen anchichay tatagu way chuar hen empanina way kaman an cha nadchiy pani. Yag intudtuchuna an chicha hen patinggan hen mafalin ma-awatancha. ");
INSERT INTO blw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Maid intudtuchuna an chicha ah iggayna penani. Ngém no omanggaycha hen anchichay pasorotna, anna paat an esoplekar an chicha hen amin way laychén hen anchichay penanina way aryén. ");
INSERT INTO blw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Angkay cha madhém hen hiyachiy ag-agaw, imfagan Jesus hen anchichay pasorotna way mangaliyén, “Gumchangtaaw hen antoy fayfay ta intaaw ad chumang.” ");
INSERT INTO blw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yachi yag hinénggépcha hen anchi fangka way tummutùchuwan chillu Jesus, yag inligwatcha way tenaynancha hen anchichay ammag chuar way tatagu. Yag wachacha agé chillu hen tapena way namfangka way nàyéy. ");
INSERT INTO blw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yag angkay hen nanlurugganancha, inluginaat agé way fumali yag ammag séréd. Wat ammag napegsa hen anchi challuyun wat cha mahàchuwan hen anchi fangka way tég-angay malihéd. ");
INSERT INTO blw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngém ah Jesus, namopongngan way nanasséy ah chugun hen anchi fangka. Yag anchaat fangonon hiya way mangaliyén, “Ayong Apo, ay ammoh yasa ud-ay ta maofortaaw.” ");
INSERT INTO blw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Fangofangon ah Jesus yag menancharna hen anchi fali way mangaliyén, “Ginang-aat.” Yag annaat agé ifaga hen anchi fayfay way mangaliyén, “Anggay, omalenanà-a.” Wat ammag nafég-as hen anchi fali yag ommalenanà hen anchi fayfay. ");
INSERT INTO blw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yachi yag anat ekat Jesus hen anchichay pasorotnéén, “Pakay amchan hen égyatyu. Ay anyu chillug achi peet manchinlan haén.” ");
INSERT INTO blw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wat anchag nahaang amin hen anchichay pasorotna way chacha man-ahetennopà way mangaliyén, “Heno ay paat hen kenatatagun nattowa way magénén uray hen fali ya chanumén afurotoncha hiya.” ");
INSERT INTO blw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Angkay hiyachi way ginumchang cha Jesus ya hen anchichay pasorotna hen anchi fayfay way Galilea, tommàchangcha yag sakoponat hen Geraseno. ");
INSERT INTO blw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Angkay ginumhad ah Jesus, i nihib-at hen ihay tagu way nahuhullugan ah ongtan. Hen hiyachiy tagu, narpo hen anchi palinufù ");
INSERT INTO blw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","te yachin i-iggawana. Yag hiya agéat ammag orhe way térén way ah kenaorhena, maid makafarud an hiya, tàén kawad hen usaréncha. ");
INSERT INTO blw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Te namen-ano way penachascha way mamarud ngém anna chillug cha géhgéhtén hen kawad hen limana ya gumugum-un agé hen farud hen he-ena. Wat ammag maid makafael way mangafà an hiya. ");
INSERT INTO blw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ammag enag-agaw ya lenafi way chan fangngafangngad hen anchi palinufù ya hen anchichay fib-ilig way chan ongaongaw, ya chana amin tégtégén hen acharna ah fato. ");
INSERT INTO blw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ngém angkay hen nangil-ana an Jesus hen achawwéy, ammag nanagtag way i nampalentomang hen henagongna way manayaw an hiya. ");
INSERT INTO blw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yachi yag menanchar Jesus hen anchi nihuhurug way ongtan way mangaliyén, “Lomayaw-aat hen annay tagu.” Yag nan-ongaw hen anchi ongtan way mangaliyén, “Heay Jesus way anà hen kangatowan way Apudyus, nokay hen ammaam an haén. Panga-asem paat gapon Apudyus ta achiyà koma pap-aligatén.” ");
INSERT INTO blw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yachi yag anat hanhanan Jesus way mangaliyén, “Nokay hen ngachanno.” Yag sommongfat hen anchi nihuhurug way mangaliyén, “Ah Kachuaran hen ngachan-o te an-anig chuar.” ");
INSERT INTO blw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yag chan pangpanga-ase hen anchi tagu an Jesus ta achina koma eparyaw chicha hen hiyachiy lugar. ");
INSERT INTO blw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hen hiyachi, netongpo agé way wachacha hen chuar way fafuy way nehahag-én way chan garab hen anchi tagéytéy. ");
INSERT INTO blw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wat nampangpanga-ase hen anchichay ongtan an Jesus way mangaliyén, “Panga-asem ta parufusum chàni way éméy hen anchichay fafuy ta wachay iggawanni.” ");
INSERT INTO blw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yag emparufus Jesus chicha. Wat tenaynancha hen anchi tagu way nihuhullugancha yag incha nihurug hen anchichay fafuy way éméychah chuwan lifu. Wat amin hen anchichay fafuy, hen hiyachi way nahurugancha, anchag hetatagtag way maid pootoncha ah ayancha, yag nichawangcha amin hen anchi chéprah wat nepesokcha hen anchi fayfay yag naoforcha amin. ");
INSERT INTO blw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Angkay hen nangil-an hen anchichay nanginya-achug hen fafuy hen nepasamak, anchag ommawid amin. Ya chacha hapehapetén hen aminay chacha hib-ahib-atén hen charan ingganah fabréycha. Yachi yag émméycha agé hen anchichay tatagu way i mangila hen anchi na-ammaan. ");
INSERT INTO blw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Angkay inumchahcha hen kawad Jesus, inchahancha agé hen anchi tagu way tenaynan hen anchichay chuaray ongtan way ammag tummutùchu ya nanlurumfong yag ustousto agé hen hamhamàna, yag chachaat agé émégyat. ");
INSERT INTO blw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yachi yag henaphapet hen anchichay ustoy nangila hen anchi aminay innilacha way na-ammaan hen anchi nahurugan way tagu ya hen anchichay fafuy. ");
INSERT INTO blw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wat chacha amin mampangpanga-ase an Jesus ta lomayaw koma hen hiyachiy fabréycha. ");
INSERT INTO blw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Angkay hiyachi way cha hénggép cha Jesus hen anchi fangka way lomayaw, émméy hen nahurugananchi way i mampanga-ase an hiya ta metnod koma. ");
INSERT INTO blw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngém empawan Jesus way mangaliyén, “Un-unnina no homàyat-a ah fabréyyu ta im haphapetén hen anchichay ahimfafaryanno hen enkaman Apudyus way nanorong an hea ya hen nanég-angana an hea.” ");
INSERT INTO blw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wat lummigwat hen anchi tagu way cha émé-éméy hen anchichay kafabréfabréy ad Decapolis way i manaphapet hen enkaman Jesus an hiya. Yag hen anchichay tatagu way nangngar, anchag nascha-aw amin. ");
INSERT INTO blw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Angkay hiyachi way kasen ginumchang cha Jesus hen anchi fayfay way namfangad ad chumang, enamongan agé hen ammag chuar way tatagu hiya hen anchi tarantag. ");
INSERT INTO blw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yag anat umchah hen ihay am-ama way ap-apon hen anchi cha ma-am-amongan hen Judio ahchi way ah Jairo hen ngachanna. Yachi way innilanah Jesus yag émméy nampalentomang hen henagongna, ");
INSERT INTO blw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yag chan pangpanga-ase way mangaliyén, “Anchi tég-angay matéy hen anào way fufae, wat panga-asem paat ta umalea way manchà ta maka-an hen anchi saketna ta matagu koma.” ");
INSERT INTO blw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wat nìligwat cha Jesus an hiya. Yag anchag chuar agé hen anchichay nàyéy wat anchag chan in-inippet. ");
INSERT INTO blw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yag hen hiyachi agé, wacha hen ihay in-ina way nansaket ah hemporo ya chuway tawén way ammag cha chumarachara. ");
INSERT INTO blw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yag chuar agé way choktor hen chana nampa-aga-agahan yag annag imfayad amin hen kok-owana, ngém anna chillug cha iyam-améd hen saketna. ");
INSERT INTO blw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ngém gapo ta chengngarna hen mepanggép an Jesus, i nìfurug hen anchichay tatagu. Wat i nehnop ah échég Jesus ");
INSERT INTO blw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","te ah hamhamàna, ekatnéén, “No an-o koma paat tad-én hen uray lumfongnaat maka-an hen antoy saket-o.” ");
INSERT INTO blw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yachi way tenchàna tot-owa hen anchi lumfong Jesus, yag ginsan hen anchi chara way natchù, ya nalènana agé way naka-an hen saketna. ");
INSERT INTO blw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yag ah Jesus agé, nalènanaat way nausar hen kafaelana, wat nan-ehagongna ah échégna way mangaliyén, “Heno hen nanchà hen lumfong-o.” ");
INSERT INTO blw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yag sommongfat hen anchichay pasorotna way mangaliyén, “Innilam way anchag chuar hen antochay tatagu way chan sensenettak gapon hea, yag in-a anapén hen nanchà an hea.” ");
INSERT INTO blw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yag chaat chillu langrang-én Jesus no heno hen nanchà an hiya. ");
INSERT INTO blw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wat hen anchi in-ina, gapo ta enlasinna hen nekaman an hiya, émméy nampalentomang hen henagong Jesus way chan papayagpag ah égyatna yag annaat haphapetén hen kenatot-owan hen na-ammaan. ");
INSERT INTO blw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wat ekat Jesus an hiyéén, “Heay sonod, gapo hen pammatem an haénat naka-an tot-owa hen annay saketno. Wat ta sém-ém hen hamhamàno te achi kasen fùfùnag hen saketno.” ");
INSERT INTO blw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Étég Jesus way chan ale yag inumchahchaat hen anchichay i mamfêang way narpoh faréy cha Jairo, yag imfagacha an hiya way mangaliyén, “Uray achitaaw ud-ay haliw-én hen annay ap-apowanna te looh angkay narpas hen fiyag hen anchi onga.” ");
INSERT INTO blw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngém iggay pagan-anon Jesus hen imfagacha an Jairo, te annag ekatén, “Achiaat an machanagan ta annowat an manokchun haén.” ");
INSERT INTO blw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yachi yag annaat epawa hen metnochan hen anchichay tatagu ta anggay yanggay cha Pedro an cha Jaime an Juan way hen-agi ah emparufusna. ");
INSERT INTO blw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yag yachi way inumchahcha ah faréy cha Jairo, innilan Jesus hen nakorkoran hen tatagu, yag ammag maid achangchangrana hen ifilcha ya hen kekelacha. ");
INSERT INTO blw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yachi yag hinénggépcha ah faréy yag ekat Jesus hen anchichay tataguwén, “Pakay an-ayug nakorkor ya an-ayug an hi-i-ifil amin, te cha-an angkay natéy hen annay ongaanna te an yanggay nanasséy.” ");
INSERT INTO blw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yag anat agég cha am-amrangén hen anchichay tatagu hiya. Wat imfagana ta gumhadcha amin yag annaat ayagan hen aman ya inan hen anchi natéy ya anat agé hen anchichay pasorotna yag émméycha hen anchi iné-émfégan hen anchi natéy. ");
INSERT INTO blw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yachi yag inégnanana hen limana yag ekatnéén, “Talita koum,” way hen aletaawat “Anào, hen ifagà an hea wat fumangon-a.” ");
INSERT INTO blw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yachi yag fummangonat tot-owa hen anchi natéy way fafarasang yag nanaran te hemporo ya chuwa hen tawénna. Yag hen anchichay nangila, anchag nahaang way térén. ");
INSERT INTO blw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ngém tenéngténg Jesus chicha amin way mangaliyén, “Ilanyu ta achiyu paat cha haphapeténto ah uray heno way tatagu.” Yag annaat ifaga ta panganéncha hen anchi onga. ");
INSERT INTO blw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Angkay hiyachi way lommayaw ah Jesus an nadchi, namfangad ah fabréyna way nàyéycha agé hen anchichay pasorotna. ");
INSERT INTO blw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yag angkay Safachu way ngilin, émméy ah Jesus way i mantudtuchu hen anchi chacha ma-am-amongan way Judio. Yag hen anchichay chuar way na-among, anchag nahaang amin hen nangngarancha hen anchi chana ekaman way mantudtuchu. Yag anchaat ekatén, “Heno ay hen nangacharan nahha ah chana itudtuchu. Yag heno ay agé hen nangar-an nahha ah kenaraengna ya hen kafaelana way mangammah kaskascha-aw. ");
INSERT INTO blw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ay ammoh faénha hen anchi karapentero tà way anà cha Maria way pangorowan cha Jaime, Joses, Judas yah Simon. Yag ammoh faén agé sosnodna hen antochay tapen hen finufae way niya-ahrang an chitaaw tà.” Yaha hen ekat hen anchichay tatagu yag anchag achi mangiggéén ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wat ekat Jesus an chichéén, “Uray heno way fabréy way ayan hen profetan Apudyus wat ririspituwén hen tatagu hiya way manongad yanggay hen anchichay tatagu ah fabréyna paat ya hen anchichay totorangna ya hen ahimfafaryanna.” ");
INSERT INTO blw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wat gapoh achicha mangiggéén hiya, maid én-énnéna way mangamma hen kaskascha-aw ahchi, te an yanggay aket hen chana tenchà yag naka-an hen saketcha. ");
INSERT INTO blw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ammag nascha-aw ah Jesus way mangi-ilan cha nadchi way tatagu te ammag maid pammatecha. Angkay hiyachi yag émméy cha Jesus hen aminay fabréy way panigib Nazaret way i mantudtuchu. ");
INSERT INTO blw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yag enamongna hen anchichay hemporo ya chuway pasorotna yag inidchatna hen kafaelancha way mangemparyaw hen nihuhurug way ongtan, yag annaat hinchudwéén chicha way mangempééy hen anchichay kafabréfabréy. ");
INSERT INTO blw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Imfagana agé way maid etàtaencha ah uray heno way masaporcha hen anchi mamfiyahiyancha ta ancha yanggay ammag manhorhor-od, ya achichan pahpah-eng ya umarah anéncha, ya achicha agé omentàtaen ah pelak, ");
INSERT INTO blw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ta ancha yanggay an mansasappatos way achicha agé umara ah mansokatancha ah lumfong. ");
INSERT INTO blw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yag imfagana agé an chicha way mangaliyén, “Heno way fabréy way ayanyu, epahigyu way i-inggaw hen faréy hen anchi mangempaghép an chàyu ingganah lomayawanyu hen hiyachiy fabréy. ");
INSERT INTO blw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ya mag-ay ta wachay fabréy ah ayanyu yag achi chàyu epaghép hen anchichay tatagu ya ancha agég achi changrén hen itudtuchuyu, taynanyu hen hiyachiy fabréy yag penòpoanyu hen tapok hen he-eyu ah mangenlasinancha way egadcha hen machusaancha.” ");
INSERT INTO blw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Angkay narpas way imfagan Jesuschi yag lummigwatcha tot-owa hen anchichay pasorotna way i mangintudtuchu hen tatagu way masapor manchùgancha hen a-ammacha way laweng. ");
INSERT INTO blw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yag hen chacha mantudtuchuwan, chacha agé emparyaw hen chuar way nihurug way ongtan, ya chacha agé lenana hen anchichay chuar way chan saket wat naka-an hen saketcha. ");
INSERT INTO blw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Angkay hiyachi yag uray ah Are way Herochén chengngarna hen mepanggép an Jesus te ammag hiya hen cha hapehapetén hen tatagu. Yag hen ekat agé hen tapen anchichay tatagu, ekatchéén, “Ah Jesusanto wat hiya ah Juan way chan funfunyag way an nan-uchi, wat yachi hen wachan kafaelana way mangamma hen kaskascha-aw.” ");
INSERT INTO blw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Waman hen tapena, ekatchéén hiya ah Elias. Yag hen tapena agé, ekatchéén hiya hen ihay profeta way kaman chillu hen anchichay tapen hen profeta ad namenghan. ");
INSERT INTO blw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngém hen nangngaran Are Herod, anna yanggay ammag ekatén, “Hiya tot-owa ah Juananchi way chan funfunyag way empahiwat-o way an peet nan-uchi.” ");
INSERT INTO blw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yaha hen ekat Are te hen enkamanna, empadpapna ah Juananchi way chan funfunyag way nangempatelew yag empafarudna, te yachi hen lenyad Herodias way ah Herodiasanto, hiya hen ahawan Felipe way sonod Are Herod, ngém penléh Herod hiya yag enahawana. ");
INSERT INTO blw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yag hen nempafaruchan Herod an Juan, te ammag cha enamheamhew Juan hiya way mangaliyén, “Maid karébféngam way mamréh hen ahawan sonodno.” ");
INSERT INTO blw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yag gapon hiyachi, ammag achi poros laychén Herodias ah Juan, te hen laychénaat epapchitna koma. Ngém gapon Are, ammag maid én-énnéna, ");
INSERT INTO blw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","te ah Are Herod, ammag cha émégyat an Juan te enlasinna way na-apudyusan ya ammag ammay way tagu, wat annag hahallimunan. Yag uray agé ta cha makorkor hen hamhamàna no changréna hen cha itudtuchun Juan, annag laychén chillu way mamangngar hen chana itudtuchu. ");
INSERT INTO blw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ngém angkay hen-argawan, inchahanat agé Herodias hen wayana way mangempapchit an Juan. Te hen hiyachiy ag-agaw wat yachin manayawancha hen anchi niyana-an Are Herod. Wat empasaganan Herod hen chakar way lagsak yag inimfitarna hen amin anchichay ifana way anap-apon hen o-okom ya hen anchichay anap-apon hen sorchachu ya anat agé hen anchichay nan-angato way tatagu ad Galilea. ");
INSERT INTO blw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yag yachi way chachan pop-orogram, émméy hen anchi anà Herodias way fafarasang yag nansas-ara hen sangwanancha amin, yag ammag naragsakan ah Are Herod ya umat agé hen anchichay fisitana. Wat anat ekat Are an hiyéén, “Ifagam hen uray heno way laychém wat idchat-o an hea.” ");
INSERT INTO blw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yag annag ensapata an hiya way mangaliyén, “Uray heno way laychém wat idchat-o an hea way ichat way uray hen kagudwan hen kena-arè wat idchat-o no yachi hen laychém.” ");
INSERT INTO blw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yachi yag ginumhad hen anchi fafarasang way i mangimoh an inana way Herodias way mangaliyén, “Nokay ngata hen ifagà way idchat Are an haén.” Yag ekat inanéén, “Ifagam way hen anchi fat-ag Juan way chan funfunyag hen idchatna an hea.” ");
INSERT INTO blw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yachi yag enag-aggag hen anchi fafarasang way namfangad an Are yag imfagana way mangaliyén, “Hen laychê way idchatno an haén ad uwananto paat wat hen anchi fat-ag Juan way chan funfunyag way mepatang hen hachang.” ");
INSERT INTO blw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yag ammag ngommehpéy way térén hen hamhamà Are, ngém gapo ta looh nansapata hen sangwanan hen anchichay mangilina, achi mafalin way iyachina. ");
INSERT INTO blw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wat hennagna hen ihay sorchachuna way guwarcha way i mangara hen fat-ag Juan. Wat ginumhad hen anchi sorchachu yag ina hiniwat hen urun Juan ah pagfaruchan, ");
INSERT INTO blw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","yag annaat epatang hen anchi hachang ya annaat idchat hen anchi fafarasang. Yag hen anchi fafarasang agé, inyéyna an inana. ");
INSERT INTO blw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Angkay hiyachi way chengngar hen anchichay pasorot Juan hen nekaman an hiya, émméycha way i nangara hen acharna yag incha inlufù. ");
INSERT INTO blw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Angkay hiyachi way namfangad hen anchichay aposel hen anchi namfiyahiyancha, émméycha an Jesus way nanaphapet amin hen enammaancha ya hen intudtuchucha. ");
INSERT INTO blw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yag gapo ta anchag chuar hen anchichay tatagu way chan penpenarég way i mangila an Jesus, ammag maid wayacha way mangan. Yag anat ekat Jesus hen anchichay pasorotnéén, “Intaaw ta intaaw omanggay ta wachay man-inungaranyu.” ");
INSERT INTO blw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wat anchaat manlugan hen fangka way gumchang hen anchi fayfay way éméy hen anchi lugar way maid tatagu. ");
INSERT INTO blw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngém chuarcha chillu hen nangi-ila hen lummigwatancha yag enlasincha way cha Jesuschi. Wat hen enkaman hen anchichay tatagu way narpoh kafabréfabréy, nanagtagcha way enengwacha hen tarantag yag namangpangocha way éméy hen anchi lugar way cha ayan cha Jesus. ");
INSERT INTO blw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yag angkay tommàchang cha Jesus, inu-umchahchaat hen anchichay chuar way tatagu. Yag ammag naség-angan ah Jesus way nangi-ila an chicha te anchag kaman karnero way maid manalimun an chicha. Yachi yag inlugina agé way mangintudtuchu hen chuar an chicha. ");
INSERT INTO blw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Angkay yachiy cha madhém, ekat hen anchichay pasorotna an hiya way mangaliyén, “Annay cha madhém yag maid met fabréy ahto, ");
INSERT INTO blw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","wat ammay ménat no hénagém hen antochay tatagu ta éméycha hen anchichay fafabréy ta icha lomao ah anéncha.” ");
INSERT INTO blw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngém tenomfar ah Jesus yag ekatnéén, “Chàyu koma hen mamangan an chicha.” Yag ekatcha agéén, “Ay lasoy pangan cha nahha, te uray ay non an umat yag wachay labfu ah makatawénat achina chillu narég ah elaoh anéncha.” ");
INSERT INTO blw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yag anat ekat Jesus an chichéén, “Umpayat inyu ilan no kamanay hangat hen wacha an chàyu.” Yag yachi way incha innila, yag ekatchéén, “An yanggay lemay tenapay ya anat hen chuway files.” ");
INSERT INTO blw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yachi yag anat ifagan Jesus hen anchichay pasorotna ta ifagacha hen anchichay tatagu ta matpomatponcha way tumùchu hen anchi pachinaroh. ");
INSERT INTO blw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wat tummùchucha tot-owa way natponatpon way hinggagsot hen topon hen tapena ya hen lelman poporo hen tapena. ");
INSERT INTO blw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yachi yag innaran Jesus hen anchi lemay tenapay ya hen anchi chuway files yag nantangad ad uchu way manyaman an Apudyus, yag annaat petpet-angén hen anchi tenapay yag empayàchangna hen anchichay pasorotna ta iwarascha hen tatagu. Yag annaat agé aran hen anchi chuway files yag penpenhetna yag empawarasna agé. ");
INSERT INTO blw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wat nanganangancha hen anchichay tatagu ingganah nagipohcha amin. ");
INSERT INTO blw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Angkay nagipohcha, enamong hen anchichay pasorotna hen anchi nafay-anan way tenapay ya files, yag napno hen hemporo ya chuway awit. ");
INSERT INTO blw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yag hen filang hen anchichay larae yanggay way nangan wat lemanlifu. ");
INSERT INTO blw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Angkay hiyachi way narpas hen namanganan Jesus hen anchichay tatagu, yag emparuganna hen anchichay pasorotna hen anchi fangka ta mamangpangocha way gumchang way éméy ad Betsaida. Yag ah Jesus, nantaynan way mangempaligwat hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Angkay empaligwatna chicha, émméy hen ihay tagéytéy way i manluwaru. ");
INSERT INTO blw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Angkay hiyachiy nadhém way é-éttég Jesus hen anchi tagéytéy, neppégcha hen anchichay pasorotna hen agginawan hen anchi fayfay way chacha gumchangan. ");
INSERT INTO blw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yag innilan Jesus way chacha maligatan way manginchurun hen anchi fangka te napegsa hen anchi fali way cha manib-at an chicha. Angkay na-apeh, ummunud ah Jesus way ammag nanaran hen uhun hen chanum way hen ekatna, ammag manidchiwéh ad chumang. ");
INSERT INTO blw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ngém hen nangil-ancha an hiya way cha manaran hen uhun hen chanum, anchag nan-ongaw ah égyatcha te ekatchéén fanig ");
INSERT INTO blw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","te ammag pararo hen égyatcha amin. Yag anat man-ale ah Jesus way mangaliyén, “Achiayu cha émégyat te haénto.” ");
INSERT INTO blw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yachi yag hinénggép ah Jesus hen anchi fangka way nìlugan an chicha, yag nafég-asat agé hen anchi fali. Wat anchag nahahaang amin hen anchichay pasorotna, ");
INSERT INTO blw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","te tàén innilacha hen namanganana hen anchichay chuaray tatagu ah an yanggay lemay tenapay, iggaycha chillu ma-awatan no heno hiya, yag kaman paat achi éméy ah hamhamàcha hen anchichay chacha innila. ");
INSERT INTO blw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Angkay hiyachi way ginumchang cha Jesus hen anchi fayfay yag inumchahcha ad Genesaret. Yachi yag entaédcha hen anchi fangka ");
INSERT INTO blw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","yag tommàchangcha, yag enlasinat hen anchichay tatagu way cha Jesus peetchi. ");
INSERT INTO blw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wat chachaat managtag way i mantaronton hen anchichay fafabréy way manaphapet way wachah Jesus. Wat hen anchichay tatagu, no changréncha hen cha ayan Jesusén chachaat iyunud hen anchichay chan sasaket way nangimfufulig. ");
INSERT INTO blw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ya uray heno way lugar way ayan Jesus way chakar man way fabréy ono akettoy, anchag amongon hen aminay masaket hen anchi cha um-umfunan hen tatagu yag chachaat mampangpanga-ase an Jesus ta epatchàna hen uray lawan penget hen lumfongna. Yag aminay tenomchà wat naka-an hen saketcha. ");
INSERT INTO blw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Angkay hen-argawan, ummalecha hen anchichay narpod Jerusalem way Fafariseo ya hen tapen anchichay siguchay cha mintudtuchu hen orchin Moses way i nangila an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yag namatmatanchaat agé hen anchichay pasorot Jesus way anchag achi cha tongparén hen anchi gagangaycha way Judio mepanggép hen ekamancha way mamfuru yag chachaat mangan. ");
INSERT INTO blw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Te hen anchichay Fariseo ya uray amin hen anchichay Judio wat chacha tongparén hen anchi gagangaycha way intudtuchun hen anap-ocha ad namenghan way masapor paat u-unnuchuncha hen liglamenton hen mamfuruwancha ya anchaat mangan. ");
INSERT INTO blw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ya achicha agég anén hen uray heno way maràwan ingganah ammaancha hen anchi gagangaycha unna ah kacharosan nadchi. Yag chuar agé hen tapen hen liglamenton hen gagangaycha way chacha tongparén, te wacha amin hen masapor way ekamancha way mangurah ah uray tasa ya fanga ya hen gamfang way ganchilucha. ");
INSERT INTO blw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Angkay hiyachi, hen anchichay Fariseo ya hen siguchay cha mintudtuchu hen orchin, imfagacha an Jesus way mangaliyén, “Pakay ammag achi tongparén hen annachay pasorotno hen liglamenton hen gagangaytaaw way intudtuchun hen anap-otaaw ad namenghan mepanggép hen ekaman way mamfuru yag chachaat mangan.” ");
INSERT INTO blw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Senongfatan Jesus chicha way mangaliyén, “Usto paat tot-owa hen anchi ensorat hen profeta way Isaias ad namenghan mepanggép an chàyu way an-ayug senang a-afurot. Te ensoratna hen enalen Apudyus way ekatnéén, ‘Hen antochay tatagu, ammag ah tapàcha yanggay hen manayawancha an haén, ngém ammag maid awanwani ah hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wat ammag maid sérfina hen anchi chacha manayawan an haén te hen chacha itudtuchu wat hen anchi narpoh hamhamà hen tatagu way anchag penarang yag ekatchéén narpon haén.’ ” ");
INSERT INTO blw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Entoroy Jesus way mangaliyén, “Anyu peet ammag cha iwalin hen anchi inyurchin Apudyus ta hen anchi paat gagangayyu way narpoh hamhamà hen tatagu hen chayu tongparén. ");
INSERT INTO blw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","An-ayug naraeng tot-owa way manginwalin hen orchin Apudyus ta hen anchi paat gagangayyu hen é-égnananyu. ");
INSERT INTO blw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Te ilanyu ngénat, kaman hen ihay orchin way ensorat Moses way ekatnéén, ‘Masapor ririspituwén hen chinàcha-ar, ya hen anchi ammag mangsot hen chinàcha-arna wat masapor mepapchit.’ ");
INSERT INTO blw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngém chàyuwat agé, chayu maichénchi te chayu itudtuchu hen gagangayyu ah manlasonyu ah achiyu manorotan hen inyurchin Apudyus, te ekatyuwén, ‘Henoy tagu way makatorong koma hen chinàcha-arna, no loohna ekatén para an Apudyusto, ");
INSERT INTO blw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","wat mafalin mapasinsiya way achi ano masapor torongana hen chinàcha-arna.’ ");
INSERT INTO blw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Wat hen annay chayu itudtuchu, chana huligén hen enalen Apudyus. Yag chuarcha agé hen tapena way kaman an cha nahha way chayu amma-ammaan.” ");
INSERT INTO blw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Angkay hiyachi yag kasen enayagan Jesus hen anchichay chuaray tatagu yag ekatnéén, “Papannaagényu amin hen antoy ifagà ta ma-awatanyu. ");
INSERT INTO blw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Faén angkay hen anchi éméy ah lenoang hen tatagu hen mangemparaweng an hiya an Apudyus, te hen anchi marpo hen tagu, yachi hen mangemparaweng an hiya.” ");
INSERT INTO blw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Changrényu koma hen antoy chà ifaga te naingaan-ayu.” ");
INSERT INTO blw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Angkay na-awni way tenaynan Jesus hen anchichay tatagu yag hinénggép ah faréy, émméy hen anchichay pasorotna way i mananhan no heno hen laychén hen anchi penanina way aryén. ");
INSERT INTO blw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yag annaat ekat an chichéén, “Ay ammoh uray peet agé chàyuwén cha-anyu ma-awatan. Ilanyu ngén, heno way ma-an way éméy ah tapà yag inùmun hen tagu, achi mafalin way chichachi hen mangemparaweng an hiya an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Te achina met engwa ah hamhamàna te ah potona hen ayana yag an fumùnag ah awni.” (Hen yatoy enalen Jesus wat empaka-awatna way aminay ma-an wat maid lawengna an Apudyus.) ");
INSERT INTO blw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yag annaat etoroy way mangaliyén, “Hen anchi mangemparaweng hen tatagu an Apudyus wat hen anchi marpo paat ah hamhamàna. ");
INSERT INTO blw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Te hen anchi hamhamà, yachi hen marpowan hen egachay laweng way achi laychén Apudyus, te yachi hen karmuwan hen mangakaw ya hen pomatéy ");
INSERT INTO blw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ya hen chumagchagas. Ya hen hamhamà agé hen manligwatan hen gamgam ya hen laweng way a-amma ya hen lokop. Ya hen hamhamà agé hen karpowan hen layos ya hen apés, hen usot ya pasekat ya aminay lenoroko way a-amma. ");
INSERT INTO blw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Amin chato wat ah hamhamà hen tatagu hen marpowana, yag chichato hen mangemparaweng hen tatagu an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Angkay hiyachi way lommayaw ah Jesus an nadchi, émméy hen anchi sakopon hen Tiro yag hinénggép hen ihay faréy way hen gagarana, ta man-inungar way achi koma ma-am-ammuwan. Ngém maid chillu mafalin te chengngar hen tatagu. ");
INSERT INTO blw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ya hen ihay nangngar wat ihay in-ina way faén Judio way niyanà ad Sirofenicia way sakopon hen Siria. Ammag nahurugan ah ongtan hen anchi anàna way fafarasang. Wat angkay chengngarna way wachah Jesus, émméyat nampalentomang hen henagongna way chan pangpanga-ase ta eparyawna koma hen anchi nihuhurug hen anàna. ");
INSERT INTO blw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ngém senongfatan Jesus hiya ah pani way mangaliyén, “Masapor panganén unna hen anchichay a-anà ya anat hen aho, te faén usto no aran hen anén hen a-anà yag inidchat hen aho.” Yachi yag na-awatan hen anchi in-ina hen anchi penanin Jesus way hen anchichay Judio hen matorongan unna ya anat hen anchichay faén Judio. ");
INSERT INTO blw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wat sommongfat way mangaliyén, “Tot-owa hen annay enalem Apo, ngém ammoh faén usto no anén hen aho hen anchi laway fugtan hen a-anà.” ");
INSERT INTO blw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yag anat ekat Jesus an hiyéén, “Nènong paat tot-owa hen annay songfatno, wat omanamot-aat te lommayaw hen anchi nihuhurug way ongtan hen anchi anàno.” ");
INSERT INTO blw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yag angkay ommanamot hen anchi in-ina, inchahana hen anchi anàna way iné-émfég way maid tot-owa hen anchi nihuhurug an hiya. ");
INSERT INTO blw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Angkay hiyachi way lommayaw cha Jesus hen sakopon hen Tiro, enengwacha ad Sidon ya hen sakopon hen anchi ekatchéén Decapolis yag anchaat manakpos way éméy hen anchi penget hen fayfay way Galilea. ");
INSERT INTO blw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yag angkay ahchi, wacha hen ihay tagu way nattorang ya nattongong, yag inyéy hen anchichay tatagu hiya an Jesus yag chachan pangpanga-ase ta tad-éna koma ta maka-an hen anchi saketna. ");
INSERT INTO blw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yachi yag inyéy Jesus hiya hen ê-éyna ta ommanggaycha, yag annaat epahrò hen gammatna hen nanchumang way ingan hen anchi nattorang, yag annaat agé toppaan hen limana yag enetchàna hen chilan hen taguwanchi. ");
INSERT INTO blw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yag anat mantangad ad uchu yag ommaghéy way mangaliyén, “Eppata,” way hen laychénay aryén, metogwang-ayu. ");
INSERT INTO blw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yachi yag naka-anat hen tenorangna ya hen tenongongna wat makagngar ya warahwah chi man-aryana. ");
INSERT INTO blw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yachi yag tenéngténg Jesus hen anchichay tatagu ta achicha paat cha haphapetén hen anchi enammaana. Yag anchaat agég henhorhoryachén way cha manapehapet. ");
INSERT INTO blw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wat amin hen anchichay nangngar, anchag nahaang way térén yag ekatchéén, “Ammag ammay hen aminay chana ammaan te uray hen nattorangén makagngar ya hen nattongongén maka-ale.” ");
INSERT INTO blw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Angkay hen-argawan way cha-an unay paat mafayag, kasen enamongan hen chuar way tatagu ah Jesus. Angkay na-amin hen faroncha, enayagan Jesus hen anchichay pasorotna yag imfagana way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maség-angà hen antochay chuar way tatagu te ma-atlo ad uwan ah ag-agaw ah anchag nì-i-iggawan an chitaaw yag na-amin hen faroncha. ");
INSERT INTO blw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yag no epaligwat-o chicha way hommehennaang, magat anchag mahigngén hen charan, kaskasen te anachawwéy hen ayan hen tapena.” ");
INSERT INTO blw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","“Oo a,” way ekat hen anchichay pasorotna, “ngém nokay lawa hen omar-antaaw ah epangantaaw an chicha way maid met nehag-én ah fabréy hen antoy ini-inggawantaaw.” ");
INSERT INTO blw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yag anat hanhanan Jesus an chicha way mangaliyén, “Wat kamana hen faron way wachan chàyu.” Yag ekatchéén, “An yanggay pituy tenapay.” ");
INSERT INTO blw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yachi yag imfagan Jesus hen anchichay tatagu ta tumùchucha hen anchi pachinaroh yag annaat aran hen anchi pituy tenapay yag nanyaman an Apudyus yag annaat petpet-angén yag inidchatna hen anchichay pasorotna ta iwarascha hen anchichay tatagu, yag inwarascha tot-owa. ");
INSERT INTO blw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yag wacha agé hen anchi aketay files wat inyaman Jesuschi an Apudyus yag imfagana hen anchichay pasorotna ta iwarascha agé. ");
INSERT INTO blw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wat nanganangancha hen anchichay tatagu ingganah nagipohcha amin. Angkay narpascha way nangan, enamong hen anchichay pasorotna hen finay-anancha yag napno hen pituy awit. ");
INSERT INTO blw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ya hen filang hen anchichay tatagu way nangan wat émméy ah opatlifu. ");
INSERT INTO blw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yachi yag anat epaligwat Jesus chicha yag anat mì-ighép hen anchichay pasorotna hen anchi fangka ta manlugancha way éméy hen sakopon Dalmanuta. ");
INSERT INTO blw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Angkay hiyachi yag émméycha hen tapen anchichay Fariseo an Jesus way i mamachas way manlokop an hiya. Wat inlugicha way manarchar ta omenpàila ah kaskascha-aw ah manot-owaancha way ah Apudyus tot-owa hen nannag an hiya. ");
INSERT INTO blw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yag ammag ommaghéy ah Jesus way mangaliyén, “Pakay hen tatagu way cha matagu ad uwan, ammag hen kaskascha-aw paat hen laychéncha way ilan. Achi a, te hen ifagà an chàyu wat ammag maid angkay mepàila an chàyu ah kaskascha-aw way sinyar ah manot-owaanyu an haén.” ");
INSERT INTO blw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yachin imfagana yag tenaynanaat chicha way kasen nanlugan hen anchi fangka way gumchang ad chumang. ");
INSERT INTO blw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Angkay hiyachi way chacha gumchang, ammag naliw-an hen anchichay pasorot Jesus way ummara ah faroncha te an ihà-an yanggay hen anchi tenapay way wacha an chicha hen anchi fangka. ");
INSERT INTO blw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yag anat ekat Jesus an chicha way mangaliyén, “Ar-arwachanyu ta achiayu maipowan hen anchi tenòtò Herod ya hen anchichay Fariseo.” ");
INSERT INTO blw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yachi yag hemhemmàcha hen tenòtò way mausar ah tenapay yag chachaat agén ahetotopà way mangaliyén, “Hen nangaryana ngata hen tenòtò te naliw-antaaw way omentàtaen ah farontaaw.” ");
INSERT INTO blw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Enlasin Jesus hen anchi chacha tatagépfarén yag annaat ekatén, “Pakay inyu man-a-atopàpa-an mepanggép hen kamaichan hen anéntaaw. Ammoh ammag kenémnég hen hamhamàyu ta maid chillu ma-awatanyu ya maelasinyu hen mepanggép hen kafaelà. ");
INSERT INTO blw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Annachayan hen matayu yag an-ayug achi makaila hen chà enammaan. Ya hen ingayu, ay achiayu agé makagngar hen chà enale. Ay ammoh naliw-anyuwat ");
INSERT INTO blw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","hen anchi nametpet-angà hen an lemay tenapay way namangan hen anchichay lemanlifu, wat kamana kay hen anchi nahawar way enamongyu.” Yag ekat hen anchichay pasorotnéén, “Hemporo ya chuway awit.” ");
INSERT INTO blw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Yag hen anchi ngay nametpet-angà hen anchi an pituy tenapay way namangan hen anchi opatlifu way tatagu, kamana agéy awit hen nahawar way enamongyu.” Yag ekatcha agéén, “Pitu.” ");
INSERT INTO blw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Wat no yaha,” way ekat Jesus, “ay ammoh achiyu peet chillu ma-awatan way achiayu koma machanagan mepanggép ah anén.” ");
INSERT INTO blw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Angkay hiyachi way inumchah cha Jesus ad Betsaida, wachacha hen nanginyéy an hiya hen ihay nabfurag. Yag chachan pangpanga-ase ta tad-éna koma ta maka-an hen anchi finuragna. ");
INSERT INTO blw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yachi yag pinchén Jesus hen anchi nabfurag yag inyéyna ah fùnagan hen anchi fabréy, yag annaat toppaan hen matana yag tenchàna. Yag annaat hanhanan way mangaliyén, “Ay wachay ilam.” ");
INSERT INTO blw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nanmuhwat hen anchi nabfurag yag ekatnéén, “Oo, mailà hen anchichay tatagu, ngém anchag kaman away way cha manaran.” ");
INSERT INTO blw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wat kasen tenchà Jesus hen matana, yag yachi way nan-ifétégna way nangila yag lommawagat agé hen mangil-ana hen angamin te naka-an way térén hen finuragna. ");
INSERT INTO blw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yachi yag tenéngténg Jesus hiya ta manchakpos way homàyat ah fabréycha way achina engwa hen anchi fabréyanchi way anchaat narpowan. ");
INSERT INTO blw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Angkay hiyachi way cha manaran cha Jesus ya hen anchichay pasorotna way éméy hen anchichay fafabréy way sakopon hen Cesarea Filipos, henanhanana an chicha way mangaliyén, “Nokayà ngata ah hamhamà hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yag ekatchéén, “Hen ekat hen tapena, hea ah Juananchi way chan funfunyag way an nan-uchi. Ya hen tapena, ekatcha agéén hea ano hen anchi profeta ad namenghan way Elias way kasen ummale. Yag hen tapena agé, ekatchéén hea hen iha hen anchichay profeta ad namenghan way kasen natagu.” ");
INSERT INTO blw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yag anat ekat Jesus an chichéén, “Chàyu kay, nokay agé hen ekatyu an haén.” Yag nan-aleyat ah Pedro way mangaliyén, “Hea hen anchi Cristu way empopostan Apudyus way umale way mantoray.” ");
INSERT INTO blw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yag anat téngténgén Jesus chicha way mangaliyén, “Ilanyu ta achiyu paat cha haphapeténha hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Angkay hiyachi yag inlugin Jesus way mangimfaga hen anchichay pasorotna hen mekaman an hiya, ekatnéén, “Haén way Pangorowan hen Tatagu, wat masapor mapap-aligatanà way térén. Yag achiyà mangiggéén hen anchichay anam-ama way ponò hen Judio ya hen anchichay anap-apon hen papachi ya umat agé hen anchichay siguchay cha mintudtuchu hen orchin Moses. Yag ana-at agé epapchit, ngém hen petlon hen ag-agaw, man-uchiyà chillu.” ");
INSERT INTO blw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Enlawarawagna way nangensoplekar amin an cha nadchi an chicha. Wat ah Pedro, annag enayagan ah Jesus hen anchi ê-éyna yag chanaat agé amhiwén hiya way achi koma mafalin ma-ammaan hen enalena. ");
INSERT INTO blw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yag nanhagong ah Jesus hen anchichay pasorotna yag iningarna ah Pedro way mangaliyén, “Lomayaw-aat Chumunyu, te hen annay hamhamàno, narpoha hen tagu way faén narpon Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Angkay hiyachi yag enayagan Jesus hen anchichay chuar way tatagu ya hen anchichay pasorotna, yag imfagana an chicha way mangaliyén, “Heno way tagu way manlayad way somorot an haén, masapor faén hen antoy ataguwana ad uwan hen haham-éna te masapor sorotona hen ifagà, tàén yachi hen iyatéyna. ");
INSERT INTO blw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Te hen anchi tagu way ammag mangempapangég hen ataguwana hen antoy lotaat matéy chillu. Waman hen anchi tagu way achi mangempangég hen matéyana gapon afurotna an haén ya hen anchi ammay way chamag, wat uray ta matéy, midchat chillu an hiya hen kasenna ataguwan way maid péppégna. ");
INSERT INTO blw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yag ay ammoh wachay sérfina no ammag awéén hen ihay tagu hen egachay ininggaw hen antoy lota no ah awni yag entap-ar chillu Apudyus hiya. ");
INSERT INTO blw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Te maid chillu kafinaknang ah uray heno ah érégna way ifayad ta mètagu an Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Amchan hen kenaraweng hen tatagu ad uwan way ammag maid afurot hen kachùran an chicha. Wat heno way tagu way miyahrang an chicha ya ammag mafiinan way manàchég an haén ya hen intudtuchù, wat mafiinanà agé way manàchég an hiya ah tapen chi ag-agaw hen anchi mamfangchà. Te haén way Pangorowan hen Tatagu, etnochà hen anchichay anghel Apudyus hen mamfangchà way humiliyà ah kenangaton Ama way yachi chillu hen kenangatò.” ");
INSERT INTO blw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yag entoroy Jesus way mangaliyén, “Tot-owa hen antoy ifagà way wachacha hen tapena an chàyu ahto ad uwan way achi matéy ingganah ilancha hen mantorayan Apudyus way chakar hen mannakafalinna.” ");
INSERT INTO blw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Angkay hiyachi way narooh hen énémay ag-agaw, enayagan Jesus cha Pedro an Jaime yah Juan yag inyéyna chicha hen ihay akayyang way filig way ommanggay ahchi. Yag hen nangi-il-ancha an Jesus, ammag nafalewan hen acharna ");
INSERT INTO blw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","way ammag cha humili hen lumfongna ah pommokawana way maid mepachongan hen kenapokawna hen amin antoy lota. ");
INSERT INTO blw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yag hen hiyachi, innilachaat agé cha Elias an Moses way niya-ahad way cha mètagépfar an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yag ammag nan-aleyat ah Pedro way ekatnan Jesusén, “Apo, ammag ammayat ta wachataaw ahto wat ayé, ta omamma-ani ah toroy fawi ta para an hea hen iha, ya para an Moses hen iha, ya para agé an Elias hen iha.” ");
INSERT INTO blw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ammag yachi lawan inyalen Pedro te maid innilanah aryéna gapo hen anchi pararoy égyatcha. ");
INSERT INTO blw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yag hen hiyachi, anchag nanépnépan ah funat yag wachan nan-ale way narpon anchi funat way ekatnéén, “Yato hen laylaychê way anào wat changrényu hiya.” ");
INSERT INTO blw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yag hiyachiyat agé way langrangéén cha Pedro yag anggayat agé ah Jesus ah wacha. ");
INSERT INTO blw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Angkay hiyachi way chachan éhég hen anchi filig way lomayaw, tenéngténg Jesus chicha way mangaliyén, “Ilanyu ta achiyu paat cha haphapetén hen anchi innilayu ingganah marpas way matéyà ya man-uchiyà, haén way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wat enafurotcha tot-owa way iggaycha haphapeténchi, ngém chacha chillu man-ahetennopà no heno hen laychén Jesus way aryén hen anchi enalena way matéy ya man-uchi. ");
INSERT INTO blw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yag anchaat imohon an hiya way mangaliyén, “Pakay ekat hen anchichay siguchay cha mintudtuchu hen orchinén, ‘Masapor umale unna ah Elias way profeta ad namenghan ya anat umale hen anchi empopostan Apudyus way Cristu nò.’ ” ");
INSERT INTO blw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Yag ekat Jesusén, “Oo, tot-owa way umale unna ah Elias way mangensagana hen hamhamà hen tatagu ta elasincha koma ah Cristu. Ngém ah katot-owana, looh angkay umma-ale ah Elias way ammag maid amsédna ah enammaan hen tatagu an hiya, te yaha chillu hen nesosorat way ma-ammaan an hiya. Yag wacha agé hen anchi nesosorat way imfafaggana agé way haénay Pangorowan hen Tatagu, wat masapor mapap-aligatanà agé way achiyà amin mangiggéén hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Angkay hiyachi way inumchah cha Jesus hen iggaw hen anchichay tapen hen pasorotna, innilacha way ena-ammongan hen chuar way tatagu chicha. Yag wachacha agé hen tapen anchichay siguchay cha mintudtuchu hen orchin Moses way cha mè-esngel hen anchichay tapen hen pasorot Jesus. ");
INSERT INTO blw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yag hen nangil-an hen anchichay tatagu an Jesus, anchag lommaylayad wat nanagtagcha way i manib-at an hiya. ");
INSERT INTO blw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yag anat hanhanan Jesus hen anchichay pasorotna way mangaliyén, “Pakay, nokay hen chayu mansosongelan.” ");
INSERT INTO blw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yag ammag sommongfat hen iha hen anchichay tatagu way ekatnéén, “Apo, hea koma hen manginyaliyà hen antoy anào way fummafaru te nahurugan ah ongtan way yachi hen nattongongana. ");
INSERT INTO blw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yag mag-ay ta umchah hen man-ancharan hen anchi nihuhurugén ammag mantap-ar ya cha tomarfutab hen tapàna way chana manngalitfén amin hen fub-ana yag cha amin omadhar. Imfagà hen antochay pasorotno ta eparyawcha koma, ngém anchag achi peet kafaelan.” ");
INSERT INTO blw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yag anat ekat Jesus hen anchichay tataguwén, “Ammag pasagchi ah nì-i-iggawà an chàyu way tatagu ad uwan yag ammag maid chillu afurotyu. Ammoh kamana hen ekaman-o way manganoh an chàyu way ammag naligat hen omafurotanyu. Iyaleyuhto hen annay onga.” ");
INSERT INTO blw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wat inyéycha hen anchi onga, yag hen nangil-an hen anchi nihuhurug an Jesus, annag empa-adhar hen anchi onga wat nantap-ar way cha omalepodpod ya cha tomarfutab agé hen tapàna. ");
INSERT INTO blw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Henanhanan Jesus hen anchi aman hen onga way mangaliyén, “Kamana hen nanginlugiyan hen yatoy chana gìnéén.” Yag ekatnéén, “Nanepod hen anchi kaong-ongana chillu. ");
INSERT INTO blw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yag ammag kankanayén way cha pachasén hen anchi ongtan way mamchit an hiya way annag cha etap-ar hiya hen anchi apoy ya hen chanum. Wat no kafaelam way mangemparyaw hen annay nihuhurug, panga-asem paat ta torongam chàni.” ");
INSERT INTO blw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yag ekat Jesus an hiyéén, “Pakay ekatnowén no kafaelà. Ay achim peet afuroton way kafaelà, te maid achi mafalin ah ma-ammaan hen tatagu nonat an omafurot. Wat ay omafurot-a.” ");
INSERT INTO blw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yag ammag tenomfar hen anchi am-ama way mangaliyén, “Oo, wachan afurot-o ngém toronganà te ammag korang chillu.” ");
INSERT INTO blw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ngém angkay hiyachi way innilan Jesus way chacha chumuar hen anchichay tatagu way cha ma-amoamong, menancharna hen anchi nihuhurug way mangaliyén, “Heay tommongong ya tommorang way ongtan, lomayaw-aat hen annay onga ya achia kasen cha mihuh-urug an hiya.” ");
INSERT INTO blw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yag ammag nan-ongaw hen anchi ongtan yag empa-adharna way térén hen anchi onga yag anat lomayaw. Yag ammag kaman natéy hen anchi onga. Yag ekat hen anchichay tataguwén, “Anggay a, te natéy hen annay onga.” ");
INSERT INTO blw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngém inégnanan Jesus hen limana way namuhwat yag tommàchég hen anchi onga. ");
INSERT INTO blw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yag yachi way hinénggép cha Jesus ya hen anchichay pasorotna hen ihay faréy way anggaycha, henanhanancha way mangaliyén, “Pakay ngata iggay-ani nakeparyaw hen anchi nihuhurug.” ");
INSERT INTO blw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yag ekat Jesusén, “Hen kaman an cha nadchi, egad angkay epapate way manluwaru ya anat mafalin meparyaw.” ");
INSERT INTO blw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Angkay hiyachi way lommayaw cha Jesus an nadchi, nanchakposcha way nangéy hen provinsiyan hen Galilea te achi laychén Jesus way ma-ammuwan hen iggawana, ");
INSERT INTO blw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","te wacha hen chana itudtuchu hen anchichay pasorotna way hen chana itudtuchu, ekatnéén, “Haén way Pangorowan hen Tatagu wat midchatà hen anchichay tatagu way mamchit an haén, ngém hen anchi petlon hen ag-agaw wat man-uchiyà chillu.” ");
INSERT INTO blw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Chechengngar hen anchichay pasorotna hen anchi enalena, ngém anchag iggay ma-awatan no heno hen laychénay aryén, ya chacha agé émégyat way kasen mangimoh. ");
INSERT INTO blw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Angkay hiyachi way inumchah cha Jesus ya hen anchichay pasorotna ad Capernaum, hinénggépcha hen ihay faréy yag anat hanhanan Jesus an chicha way mangaliyén, “Nokay hen anchi chayun sosongelan hen charan.” ");
INSERT INTO blw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngém iggaycha somongfat, te hen chachan sosongelan wat mepanggép hen ngomatowan no heno hen nangatngato an chicha. ");
INSERT INTO blw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yachi way tummùchu ah Jesus yag imfagana way tumùchucha agé hen anchichay hemporo ya chuway pasorotna, yag annaat ekat an chichéén, “Henoy tagu way manlayad way ngomato, masapor epafafana hen acharna way kaman annag ifilang hen acharna ah alepan ah katorongan hen ifana.” ");
INSERT INTO blw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yachi yag anat ayagan Jesus hen ihay onga hen sangwanancha amin yag annaat hàliyén way mangimfaga hen anchichay pasorotna, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hen onga, kaman maid filangna. Ngém henoy tagu way gapon afurotna an haén yag chana chillu ifilang hen anchichay kaman hen antoy onga, wat chana agé ifilang haén. Yag heno agéy mangimfilang an haén, wat chana agé ifilang hen anchi nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yachi yag nan-aleh Juan yag ekatnéén, “Apo, wachan innilani way tagu way chana eparyaw hen anchi nihurug way ongtan way hea ano hen nangidchat hen kafaelana. Yag empawani te faén met tapetaaw hiya.” ");
INSERT INTO blw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngém ekat Jesusén, “Aẁ, achiyu cha epawa hen kaman an cha nadchi, te henoy tagu way haén hen narpowan hen kafaelana way mangamma ah kaskascha-aw, wat faén naraka ah mangaryana hen laweng an haén. ");
INSERT INTO blw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Te heno way achi mangontara an chitaaw, wat ifataaw chilluchi. ");
INSERT INTO blw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yag tot-owa hen antoy ifagà way uray henoy tagu way tomorong an chàyu way an lawa umidchat ah chanum gapon chayu omafurotan an haén way Cristu, wat sigurachu way magunggunaan.” ");
INSERT INTO blw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Heno way tagu ah ammag mangintudtuchu ah fumasoran hen anchi cha omafurot an haén way kaman hen antoy onga, wat wadwadcha hen machusana ah pegwana no hen metàchan hen fatoh fagangna yag netap-ar hen fayfay.” ");
INSERT INTO blw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Wat mag-ay no hen a-amman hen limayu ah mangamma hen manùganyu an Apudyus, un-unnina no porhanyu. Te un-unnina angkay hen uray ud-ay an ihà-an hen lima hen antoy ataguwan no hen anchi kompeleto hen lima yag ad imférno hen ayan way ahchi, ammag achi madmachép hen anchi apoy ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Yag mag-ay agé ta hen laychényu way ayan hen mangammah manùganyu an Apudyus, un-unnina no porhanyu hen he-eyu. Te un-unnina angkay hen uray ud-ay an ihà-an hen he-e hen antoy ataguwan no hen anchi kompeleto hen he-e yag ad imférno hen metap-aran. ");
INSERT INTO blw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yag mag-ay ta hen i-illanyu hen mangamma ah manùganyu an Apudyus, un-unnina no okatényu hen matayu. Te un-unnina angkay hen uray ud-ay korang hen mata hen antoy ataguwan no hen anchi kompeleto hen mata yag ad imférno chillu hen metap-aran. ");
INSERT INTO blw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Te ahchi, ammag achi matmatéy hen anchichay figis way cha mangissaissa hen achar ya maid agé makachép hen anchi apoy way cha manangchachangchang hen achar.” ");
INSERT INTO blw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Hen aminay michaton an Apudyus wat ma-ahinan ah mangammayan Apudyus. Ya kaman agéhchi hen ma-ahinan hen aminay tatagu ah apoy. ");
INSERT INTO blw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ammay hen ahin te epawana hen kabruan. Ngém no maka-an hen kenapaketna, ammag maid poros sérfina te maid én-énnén way kasen mangempapaket. Wat ilanyu ta man-anchar hen anchi kaman kena-ahinyu wat matotornos-ayu.” ");
INSERT INTO blw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Angkay hiyachi way lomayaw cha Jesus ad Capernaum, enengwacha hen anchichay fafabréy hen provinsiyan hen Judea yag anchaat gumchang hen anchi wangwang way ekatchéén Jordan. Yag ahchi, cha amoamongan hen anchichay tatagu hiya, yag chana tudtuchuwan chicha te yachi chillu hen chana ekamkaman. ");
INSERT INTO blw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Angkay hiyachi yag émméycha agé hen tapen hen anchichay Fariseo way icha pachasén way manlokop an Jesus. Yag hen henarudhudcha, ekatchéén, “Nokay hen ma-awatam hen orchintaaw, ay wachay karébféngan hen larae way manginhiyan hen ahawana.” ");
INSERT INTO blw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yag senongfatan Jesus ah harudhud agé, ekatnéén, “Nokay hen inyurchin Moses way ma-ammaan nò.” ");
INSERT INTO blw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yag ekatchéén, “Emparufusna met te hen ekatna, ‘No ammag omensorat hen larae ah papel ah mangimfaga hen manhiyanancha wat mafalin ihiyanna hen ahawana.’ ” ");
INSERT INTO blw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Oo a,” way ekat Jesus, “ngém hen nanginyurchinan Moses an nahha, te gapon kenatérén hen uruyu way an-ayug achi matudtuchuwan. ");
INSERT INTO blw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Te hen anchi lugrugin hen egad way hen pés-éy nangammaan Apudyus hen angamin, enammaana hen larae ya fufae. ");
INSERT INTO blw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yag gapon hiyaha wat taynan hen larae hen chinàcha-arna ta metepon an ahawana. ");
INSERT INTO blw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Wat yachi hen mamfalinéncha ah ihà-anay achar way manepod hen hiyachi, faéncha chuwa te anchag émméhà-an ah matan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ah Apudyus hen nangamman nadchi, wat maid karébféngan hen tatagu way mangempahiyan hen anchi looh nanteponon Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Angkay hiyachi way hinénggép cha Jesus ah faréy, henanhanan hen anchichay pasorotna no henon laychén hen anchi enalena way aryén. ");
INSERT INTO blw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yag annaat ekat an chichéén, “Henoy larae way manginhiyan hen ahawana yag kasen nangahawa, fummasor hiya hen anchi pés-éy ahawana te chagchagasna hen anchi inyatobna. ");
INSERT INTO blw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yag maid agé nat-énana hen fufae way manginhiyan hen ahawana yag kasen nangahawa, te ancha chumagchagas agé.” ");
INSERT INTO blw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Angkay hen-argawan, wachacha hen anchichay cha manginyéy hen ungunga an Jesus ta tad-éna way mamindisyun, ngém chaat agé amhiwén hen anchichay pasorotna chicha. ");
INSERT INTO blw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yachi way innilan Jesuschi, iningarna hen anchichay pasorotna way mangaliyén, “Masapor eparufusyu hen umaliyan hen ungunga an haén way achiyu cha epawa, te hen anchichay kaman an chicha, wat chichachi hen metape hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Te tot-owa hen antoy ifagà an chàyu way henoy tagu way achi mangempafafa hen acharna ah omafurotana an Apudyus way kaman hen cha ekaman hen antochay ungunga, wat achi angkay mafalin way metape hen mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yachi yag henàlena hen anchichay ungunga yag inchàépna hen limana an chicha way mamindisyun. ");
INSERT INTO blw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Angkay hiyachi way cha lumigwat agé cha Jesus, nanagtag hen ihay tagu way i nampalentomang hen henagongna way mangaliyén, “Heay ammay way Apo, nokay hen ammaà ta ma-adchanà ah mannanayun way ataguwan an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yag ekat Jesus an hiyéén, “Pakay ekatnowén ammayà, te maid met safalih ammay no faén yanggay ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yag innilam chillu hen anchichay orchin Apudyus way achita cha pomatéy ya achita cha chumagchagas, achita cha mangakaw ya achita cha istiguwan hen faén tot-owa, achita lomokop, ya masapor rispituwén hen chinàcha-ar.” ");
INSERT INTO blw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yag anat ekat hen anchi taguwén, “Oo Apo, tenongpar-o amin chaha nanepod ah kaong-ongà.” ");
INSERT INTO blw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yag ammag nasékét hen matan Jesus ah layadna an hiya yag ekatnéén, “An ihà-an yanggay hen korang an hea, wat hen ammaam, im elao amin hen anchichay kok-owam yag inidchatno hen laona hen anchichay publi, wat marmu hen tot-oway kafinaknangno ad uchu, yag yachi, an-aat umale way somorot an haén.” ");
INSERT INTO blw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngém hen nangngarana hen anchi imfagan Jesus, ammag ngommehpéy hen hamhamàna yag cha lomayaw way chan totokar te ammag faknang way térén. ");
INSERT INTO blw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Angkay lommayaw hen taguwanchi, henagong Jesus hen anchichay pasorotna yag ekatnéén, “Ammag naligat way térén hen metapyan hen faknang hen mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yag anchag nahaang way térén hen anchichay pasorotna hen nangngarancha hen anchi enalena. Ngém entoroy Jesus chillu way mangaliyén, “Sosnod, ammag naligat tot-owa hen ketapyan hen tatagu hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngém kaskasen hen anchichay faknang, te ammag narakrakaat hen homroan hen kafayu hen matan hen chagum no hen metapyancha an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yag ammag kaskasen hen nahaangan hen anchichay pasorotna, yag anchaat man-ahetoptopà way mangaliyén, “Wat no yaha, ay nanggilah wachay ihà-an lawah mahara-an.” ");
INSERT INTO blw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Finéfétég Jesus chicha way mangaliyén, “No hen tatagu hen mangamma ah kahara-ancha, achi tot-owa mafalin. Ngém no ah Apudyus hen mangamma, wat mafalin te maid achi mafalin an hiya.” ");
INSERT INTO blw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hiyachi yag anat man-ale ah Pedro way mangaliyén, “Ilam ngén chàni, wat annig tenaynan hen aminay wacha an chàni ah sommorotanni an hea.” ");
INSERT INTO blw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Tot-owaha,” way ekat Jesus, “yag hen ifagà an chàyu, henoy tagu way manaynan hen fabréyna ya sosnodna ya chinàcha-arna ya hen a-anàna ya hen lotana gapon haén ya hen minwarawagana hen anchi ammayay chamag, ");
INSERT INTO blw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wat midchat agé an hiya hen antoy matatagguwana hen chùchùar no hen tenaynana. Te midchat an hiya hen chùchùar way fumaryana ya hen mansosnodna ya hen manchinàcha-arna ya hen man-a-anàna ya uray agé hen manlotana, ngém yanggay te wacha chillu hen mapap-aligatana. Ngém ah pegwana, mètagu an Apudyus ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ngém hen ihay ifagà agé,” way ekat Jesus, “wat hen anchichay kaman nangato ad uwan, anchag nafafa ah pegwana. Waman hen anchichay kaman nafafa ad uwan, wat chicha agé hen ngomato ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Angkay hiyachi yag lummigwat cha Jesus way mane-ed hen anchi charan way éméy ad Jerusalem. Cha mamangpango ah Jesus way cha umunud hen anchichay pasorotna way ancha amin ammag nahaang. Yag chacha agé émégyat hen anchichay tapenay tatagu way cha umunud. Yag angkay hiyachi, kasen enet-én Jesus hen anchichay hemporo ya chuway pasorotna, yag kasenna agé imfaga an chicha hen anchi mepasamak an hiya. ");
INSERT INTO blw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ekatnéén, “Changrényu ngén hen antoy ifagà. Hen antoy ayantaaw ad Jerusalem ad uwan wat haén way Pangorowan hen Tatagu, yato hen kadpapà yag ana-at meporang hen anchichay kangatowan way pachi ya hen anchichay siguchay cha mintudtuchu hen orchin Moses. Yag uwisénà an chicha ah mamchitanà ya ana-at midchat hen anchichay faén Judio. ");
INSERT INTO blw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yag ana-at agé sénsén-én an chicha ya magénén tenoppaanà ya henapratanà yag ana-at pédtén. Ngém man-uchiyà chillu hen anchi petlon hen ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Angkay hiyachi yag hommag-én an Jesus hen anchi chuway a-anà Zebedeo way cha Jaime an Juan way mangaliyén, “Apo, wacha koma hen laychénni way ifaga an hea no mafalin.” ");
INSERT INTO blw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yag anat ekat Jesusén, “Nokaychi hen laychényu.” ");
INSERT INTO blw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yag anchaat ekatén, “No umchah hen anchi machachayaw way mantorayam, parufusum koma chàni way mìtùchu an hea way hen iha, ah pachawananno ya hen iha agé, ah pachawigim.” ");
INSERT INTO blw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngém ekat Jesus an chichéén, “Maid angkay innilayu hen annay chayu chawatén. Te ay mafalin ma-anohanyu hen ligat way kaman hen anchi ligat way mepachah an haén. Yag ay maetorodyu hen anchi miyatéy way kaman hen anchi iyatéy-o.” ");
INSERT INTO blw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yag ekatchéén, “Oo, mafalin maetorodni chaha.” Yag ekat Jesusén, “Oo, tot-owa way ma-anohanyu hen ligat way kaman agé hen mepachah an haén, ya etorodyu agé hen miyatéy way kaman hen iyatéy-o. ");
INSERT INTO blw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngém hen tumùchu ah pachawanan-o ya ah pachawigì wat faén haén hen mamele, te ah Apudyus hen nangensasagganan cha nadchi way tumùchuwan ah para hen anchichay mangidchatana.” ");
INSERT INTO blw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Angkay hiyachi way chengngar hen anchichay tapenay pasorot Jesus hen anchi cha chawatén hen ifacha way cha Jaime an Juan, ammag lommaweng hen hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wat enamong Jesus amin chicha yag ekatna way manugunén, “Innilayu hen cha ekaman hen anchichay chan toray hen antoy lota, te anchag cha manchamancharén hen anchichay chacha etorayan. Ya umat agé hen anchichay o-okom, ancha agég cha manchamancharén hen anchichay ahentagucha. ");
INSERT INTO blw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngém achi mafalinha ah ekamanyu. Te chàyu, no heno hen manlayad way man-ap-apo, masapor epafafana hen acharna ah katorongan hen anchichay tapena. ");
INSERT INTO blw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yag heno agé hen manlayad way ngomato an chàyu, masapor mamfalinéna hen acharna ah kaman alepan hen aminay ifana. ");
INSERT INTO blw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te uray haén way Pangorowan hen Tatagu wat iggayà ummale hen antoy lota ta mamfalinê hen tatagu ah alepan-o. Te ummaliyà ta an-og mamfalinén hen achar-o ah kaman alepan ah katorongan hen tatagu, ya ta idchat-o agé hen ataguwà ah sobfot hen chuaray tatagu.” ");
INSERT INTO blw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Angkay hiyachi, inumchah cha Jesus ya hen anchichay pasorotna ad Jerico, yag hen chacha lomayawan, anchag chuar hen anchichay tatagu way cha metnod. Yag wacha hen ihay furag way tummutùchu way chan pap-alemmos hen penget hen chacha charanén. Ah Bartimeo hen ngachanna way anà Timeo. ");
INSERT INTO blw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yag angkay chengngarna way ah Jesus peet way eNazaret hen naway, inlugina way man-ongaw way mangaliyén, “Jesus way ganà David, panga-asem paat ta ség-anganà.” ");
INSERT INTO blw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yag chuar hen anchichay cha mangingar an hiya ta guminang koma. Ngém annag inyam-améd way mangèngaw way mangaliyén, “Heay ganà David, panga-asem paat ta ség-anganà.” ");
INSERT INTO blw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yachi yag entàchég Jesus yag ekatnéén, “Ayaganyu hiyahto.” Wat enayagancha hen anchi furag way mangaliyén, “Wat lomaylayad-a yag tomàchég-a te anchi chacha-a epa-ayag.” ");
INSERT INTO blw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yag ammag nan-eparàwin Bartimeo hen anchi funnafunna hen tommàchégana way éméy an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yag ekat Jesus an hiyéén, “Nokay hen laychém way ammaà an hea.” Yag ekat anchi nabfuragén, “Apo, ta makailaà koma.” ");
INSERT INTO blw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yag ekat Jesusén, “Wat in-a ah ayam te gapo hen annay pammatem an haén wat naka-an hen finuragno.” Yag hen hiyachi, naka-anat tot-owa hen anchi finuragna yag netnod an cha Jesus hen anchi chacha ayan. ");
INSERT INTO blw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Angkay cha homag-én cha Jesus ad Jerusalem way tég-angaycha umchah hen anchi fabréy ad Betfage ya ad Betania yag entàchégcha hen pénad hen anchi tagéytéy ad Olivo yag anat hénagén Jesus hen chuway pasorotna way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Epangpangoyu hen fabréyanchi way chuchummangéntaaw, yag no umchah-ayu wat wacha hen ilanyu way netatàéd way ubfun chi kafayu way cha-an masaksakayan. Ùfachényu yag inyaleyuhto. ");
INSERT INTO blw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yag mag-ay ta wachay mangaliyén, ‘Pakay aranyuha,’ ifagayu way masapor hen anchi ap-apo wat man-ifangadna no marpas.” ");
INSERT INTO blw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Angkay hiyachi way émméycha hen anchi chuwa, wacha tot-owa hen inchahancha way ubfu hen anchi korsa way netatàéd hen mamang hen hawang hen ihay faréy yag émméycha way mangùfad. ");
INSERT INTO blw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yag hen chacha mangùfachan, ekat hen anchichay tatagu way tommatàchég an nadchiyén, “Payu ùfachén hen annay ubfuwanna.” ");
INSERT INTO blw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yag anchaat ifaga hen anchi imfagan Jesus an chicha yag emparufuscha. ");
INSERT INTO blw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yachi yag inyéycha hen anchi ubfu an Jesus yag anchaat iyap-ap hen anchi agwan lumfongcha hen échég hen ubfuwanchi yag nansakay ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yag umat agé hen anchichay chuar way tapen hen tatagu wat enhapràcha hen anchi agwan lumfongcha hen anchi korsa. Ya hen tapena, enhapràcha hen anchichay tufu way incha senongpat. ");
INSERT INTO blw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yag hen anchichay tatagu way cha mangempangpango ya cha umunud an Jesus, chacha amin èngaw way mangaliyén, “Machachayaw hen antoy Aretaaw, chayawéntaaw hen antoy ummale way narpon Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Chayawéntaaw hiya te hiya hen anchi mangentoroy hen penaka-aren hen Apotaaw way David, wat chayawéntaaw hen anchi kangatowan way Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Angkay hiyachi way inumchahcha ad Jerusalem, émméy ah Jesus ah Templo. Yag angkay lenangrangana hen amin, lommayaw te cha madhém, yag netnodcha hen anchichay hemporo ya chuway pasorotna way i ummiyan ad Betania. ");
INSERT INTO blw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Angkay nafigat way chachan fangad ad Jerusalem way narpod Betania, hommenaang cha Jesus. ");
INSERT INTO blw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yag gapo ta innilan Jesus hen ihay away way fig hen anchi ê-éyna way ammag tangréb chi tufuna, émméy way i nangila no wachay fungana. Ngém ammag maid te an yanggay tangréb chi tufuna, te faén chillu tempon hen mamungaana. ");
INSERT INTO blw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yag anat iyaryan Jesus hen anchi away way mangaliyén, “Manepod ad uwan, maid kasen mangmangan hen fungan nattoy away.” Yag chengngar hen anchichay pasorotna hen anchi enalena. ");
INSERT INTO blw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Angkay hiyachi way inumchah cha Jesus ad Jerusalem, émméy hen fatawan hen anchi Templo yag inlugina way mangadchug amin hen anchichay tatagu way chan elao ya cha lomao ah michaton an Apudyus. Yag tenokangna agé amin hen lamesa-an hen anchichay chan soksokat ah pelak, ya umat agé hen tùchun hen anchichay chan elao ah karopate. ");
INSERT INTO blw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yag empawana agé hen anchichay nankakarga way cha manginyarawah hen charancha ah Templo. ");
INSERT INTO blw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yag annaat ifaga hen anchichay tatagu way mangaliyén, “Nesosorat ad namenghan hen enalen Apudyus way ekatnéén, ‘Hen faréy-o wat mausar ah manluwaruwan hen egachay katagutagu an haén.’ Yaha hen imfagan Apudyus ngém chàyu, anyug namfalinén hen antoy faréyna ah manlugiyanyu hen ahentaguyu.” ");
INSERT INTO blw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Angkay hiyachi, hen anchichay anap-apon hen pachi ya hen anchichay siguchay cha mintudtuchu hen orchin Moses, chengngarcha hen anchi enkaman Jesus yag chachaat agé émégyat an hiya. Wat nantatagépfarcha no heno hen ekamancha way mamchit an hiya. Ngém pomangégcha chillu hen anchichay chuaray tatagu te laylaychéncha way mamangngar hen anchi chana itudtuchu. ");
INSERT INTO blw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Angkay hiyachi way cha madhém, kasen lommayaw cha Jesus ya hen anchichay pasorotna ad Jerusalem. ");
INSERT INTO blw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Angkay nafigat way cha manaran cha Jesus, innilan hen anchichay pasorotna hen anchi away way fig way ammag nàrong manepod ah guwisna ingganah pongarna. ");
INSERT INTO blw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yachi yag hemhemmà Pedro hen anchi enalen Jesus hen anchi away yag annaat ekat an hiyéén, “Apo, ilam ngén hen anchi away way inyaryam, wat ammag narango.” ");
INSERT INTO blw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yag ekat Jesusén, “Anyu yanggay ammag a-abfuroton ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Te tot-owa hen antoy ifagà an chàyu way henoy tagu way ammag mangimfaga hen anchi filig way marabten yag nepetlà ah fayfay, no annag afuroton way ma-ammaanchi way maid chuwachuwan hen hamhamàna, wat ammag ma-ammaan tot-owa. ");
INSERT INTO blw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wat hen ifagà an chàyu, henoy chawatényu hen manluwaruwanyu, anyug afuroton way ninidchatchi an chàyu wat midchat tot-owa. ");
INSERT INTO blw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ngém no manluwaruayu, masapor pakawanényu hen henoy tagu way nangamma ah laweng an chàyu ta pakawanén agé Apudyus way Amayu ad uchu hen enammaanyu way laweng. ");
INSERT INTO blw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Te no achiyu pakawanén hen anchichay nangamma ah laweng an chàyu, wat achi agé pakawanén Apudyus chàyu.” ");
INSERT INTO blw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Angkay kasen namfangad cha Jesus ad Jerusalem, chacha manadchad-aran hen fatawan hen Templo yag émméycha an Jesus hen anchichay anap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin ya anat agé hen anchichay anam-ama way ponò hen Judio. ");
INSERT INTO blw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yag finistigarcha hiya way mangaliyén, “Henon pam ammaan hen anchi enammaam. Yag heno ay paat agé hen nangidchat hen karébféngam way mangammahna.” ");
INSERT INTO blw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yag sommongfat ah Jesus way mangaliyén, “Wacha unna hen sarudsuchù an chàyu, yag no masongfatanyu wat ifagà agé no heno hen nangidchat hen karébféngà way mangamma hen anchichay chà ammaan. ");
INSERT INTO blw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wat ifagayu ngén no heno hen nangidchat an Juan hen karébféngana way mamfunyag. Ay ah Apudyus ono tatagu.” ");
INSERT INTO blw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yag chacha mahalifunuwan hen anchichay tapena way man-ahetennopà te ekatchéén, “No ekattaawén ah Apudyus hen nangidchat hen karébféngan Juan, awniyat ifagana no pakay iggaytaaw agé afurot hiya. ");
INSERT INTO blw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yag no ekattaaw agéén tatagu hen nangidchat, aggaégyat hen annachay tatagu te aminchaat afurotoncha way narpon Apudyus paat hen anchi kenaprofetan Juan.” ");
INSERT INTO blw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wat anchaat songfatan ah Jesus way mangaliyén, “Tawwan te maid innilani.” Yag anat ekat Jesus agéén, “Wat no yaha, achì agé ifaga an chàyu no heno hen nangidchat hen karébféngà way mangamma hen anchichay chà ammaan.” ");
INSERT INTO blw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Angkay hiyachi yag empanin Jesus hen anchichay cha mamistigar an hiya way mangaliyén, “Wacha hen ihay tagu way i nanmura hen lotana ah greps yag annaat arachén yag ommenpatoktok ah mamaliwésan hen greps no fayahéncha. Yachi yag empa-ammana agé hen akayyang way paranha ah iggawan hen anchi mangguwarcha. Angkay narpas aminchi yag annaat epa-afang ah tapena yag lommayaw way émméy ah achawwéyay lota.” ");
INSERT INTO blw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Yachi way inumchah hen tempon hen namungaan hen anchichay nimura, yag hennagna hen ihay alepanna way i mangara hen penakafingayna. ");
INSERT INTO blw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Angkay hiyachi way inumchah hen anchi alepanna, ammag lenapchù hen anchichay cha mangafang hen lota yag penagopagohcha yag anchaat eparyaw way maid inidchatcha ah penakafingay hen anchi nangenlota. ");
INSERT INTO blw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yachi yag kasen agé hennag hen anchi nangenlota hen ihay alepanna. Wat hen enkamancha agé, anchag chinunor hen uruna yag enammaancha hen aminay afifiin an hiya. ");
INSERT INTO blw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngém uray ta yachi, kasen chillu hennag hen anchi nangenlota hen ihay alepanna, yag anchag pinchit. Wat yachiyachi hen chacha enkamkaman hen amin anchichay nahnag way alepan way penagopagohcha hen tapena ya pinchitcha hen tapena. ");
INSERT INTO blw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wat hen anchi anongohna, an yanggay ihà-an hen nehàfa ah hénagén hen anchi nangenlota way yachin anchi laylaychéna paat way anàna. Yag annaat ekat ah hamhamànéén, ‘Awni yag ifiincha hiya te anào paat.’ Yag annaat hénagén hen anchi anàna way éméy. ");
INSERT INTO blw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngém hen nangil-an hen anchichay cha mangafang hen lota way naway hen anchi anàna, nan-ahetennopàcha way mangaliyén, ‘Annayan hen anchi ustoy mangentawid hen antoy lota, wat ayéat ta pédténtaaw ta chitaaw hen mangen-awa hen antoy lota.’ ");
INSERT INTO blw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wat anchaat chupapén yag pinchitcha ya anchaat etap-ar hen acharna hen lahin hen anchi arad.” ");
INSERT INTO blw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Narpas way penanin Jesuschi yag annaat hanhanan an chicha way mangaliyén, “Nokay ngata hen ekaman hen anchi nangenlota hen anchichay chan afang. Kapeletan a way mamfangad way i mamchit an chicha yag empa-afangna ah safali. ");
INSERT INTO blw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pachongna hen anchi nesosorat way alen Apudyus, yag ay ammoh iggayyu faséénchi way ekatnéén, ‘Hen anchi fato way enachin hen anchichay chan sà-ad ah faréy way ekatchéén maid sérfina, wat ammag yachiyat agé hen kapatigan ah mepégnad. ");
INSERT INTO blw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ah Apudyus hen nangamman natto, yag ammag kahahaang tot-owa.’ ” ");
INSERT INTO blw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hen nangngaran hen anchichay ponò hen Judio hen anchi penanin Jesus, na-awatancha way chicha hen chana paniyén, wat anchag laychén way manelew an hiya hen hiyachi, ngém an gapo yanggay ta iyégyatcha hen anchichay tatagu, anchag lommayaw way cha-an mangentoroy. ");
INSERT INTO blw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Angkay hiyachi, wachacha hen nahnag an Jesus way tapen hen anchichay Fariseo ya hen tapen hen anchichay ifan Are Herod way icha pachasén way manlokop an hiya ta no mèfat hen aryéna yag yachin mempafasorancha. ");
INSERT INTO blw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yachiy émméycha, imfagacha way mangaliyén, “Apo, innilani way pahig tot-owa hen cham itudtuchu way maid ég-égyatno hen tatagu. Te uray nangato ya nafafa wat ammag napapchong chillu hen ekamanno way mintudtuchu an chicha hen laychén Apudyus, te maid epohowam ah tatagu. Wat hen laychénni paat way changrén an hea wat yato, ay ammoh achitaaw labsengén hen anchi orchintaaw way Judio no fayachantaaw hen furor an Are ad Roma. Wat ay fayachantaaw ono achitaaw.” ");
INSERT INTO blw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngém enlasin Jesus hen kenasilibcha, wat ekatnéén, “Pakay chayu pachasén way manlokop an haén. Uminyaleayu ah pelak ta ilà.” ");
INSERT INTO blw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yachi way inidchatcha hen anchi pelak, innilana yag annaat ekatén, “Nokay hen antoy nepepetchor an natto, yag nokay agé hen nangenngachan hen antoy nesosorat.” Yag ekatchéén, “Ah Are ad Roma.” ");
INSERT INTO blw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yag ekat Jesusén, “Umpayat no yaha way hiya hen nangen-awa, idchatyu kagé an hiya. Yag ilanyu agé ta idchatyu an Apudyus hen anchichay para an hiya.” Wat anchag nahahaang amin hen anchichay nanangngar hen anchi ensongfat Jesus. ");
INSERT INTO blw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Angkay hiyachi, wachacha hen anchichay tapen hen Judio way ekatchéén Saduceo way chicha hen anchichay achi mangafurot way man-uchi hen natéy ah pegwana. Yachi yag émméycha an Jesus yag imfagacha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Apo, hen anchi ensorat Moses ad namenghan way orchintaaw, ekatnéén, ‘No wachay larae ah ommahawa yag natéy way maid anàcha, masapor ahaw-én hen anchi sonod hen natéy hen anchi fufae way nafaro, ta no wachay anàcha yag yachin kaman penaka-anà hen anchi natéy ah metoroyan hen ganàna.’ ");
INSERT INTO blw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Angkay hen-argawan ano, wachacha hen pituy lenarae way masosnod, yag hen anchi pango, ommahawa ngém cha-ancha ummanà yag natéy. ");
INSERT INTO blw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wat hen anchi metéb an hiya, enahawana hen anchi nafaro. Ngém cha-ancha agé umanà yag natéy agé hen anchi larae. Yachi yag neparég agé hen anchi miyatlo yag natéy chillu way maid agé anàcha. ");
INSERT INTO blw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yag nansasarunucha hen anchichay pituy masosnod way nangahawa amin hen anchi ihay fufae, ngém natéycha amin way maid anàcha. Yachiy ommanongoh yag natéy agé hen anchi fufae. ");
INSERT INTO blw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wat non an umat way man-uchicha hen natéy, nokay hen ustoy mangen-ahawa hen anchi fufae nò, te amincha met way pitu wat enahawacha hiya.” ");
INSERT INTO blw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yachi yag senongfatan Jesus chicha way mangaliyén, “Ammag yaha tot-owa hen mepàil-an hen nèfatanyu way térén. Te ammag korang hen innilayu mepanggép hen alen Apudyus, ya korang agé hen innilayu mepanggép hen kafaelana. ");
INSERT INTO blw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Te hen man-uchiyan hen natéy, anchag kaman hen anchichay anghel ad uchu way maid man-ah-ahawa. ");
INSERT INTO blw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yag mepanggép hen man-uchiyan hen natéy, ay ammoh iggayyu faséén hen anchi ensorat Moses hen nekaman hen anchi cha gumilafan hen away way iggay maghéb. Te ensoratna hen enalen Apudyus an hiya way ekatnéén, ‘Haén ah Apudyus way cha chayawén cha Abraham an Isaac ya ah Jacob.’ ");
INSERT INTO blw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wat hen laychén natto way aryénat, uray nan-atéycha cha Abraham hen hiyachiy tempo, é-éttégcha chillu way natattagu ad uchu, te pakay wachacha ad uwan way cha manayaw an Apudyus nò. Wat nèfat-ayu angkay way térén.” ");
INSERT INTO blw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hen hiyachi, wacha agé hen ihay tagu way siguchay cha mintudtuchu hen orchin way nanangngar hen cha mìchiskasan hen anchichay Saduceo. Yag angkay chengngarna hen anchi usto way ensongfat Jesus an chicha, wat émméy agé an hiya way manarudsud, ekatnéén, “Hen amin anchichay orchin Apudyusat nokay ngata hen anchi kapatpatigan paat.” ");
INSERT INTO blw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yag ekat Jesusén, “Hen anchi kapatigan way orchin, ekatnéén, ‘Changrényuto way ganà Israel, te ah Apudyus way ap-apoyu wat anggay yanggay hiya ah Apudyus way man-ap-apoyu. ");
INSERT INTO blw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Masapor laylaychényu hiya ah patinggan hen aminay hamhamàyu ya ah aminay a-ammayu ya ah aminay kenaraengyu ya ah aminay kafaelanyu.’ ");
INSERT INTO blw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yag hen anchi miyagwa way napateg way orchinnaat, ‘masapor agé laylaychényu hen ahentaguyu way kaman hen manlaychanyu hen acharyu.’ Maid kasen napatpateg way orchin Apudyus no faén cha natto.” ");
INSERT INTO blw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yachi yag anat ekat hen anchi cha mintudtuchu hen orchinén, “Apo, tot-owa hen annay enalem, te tot-owa way hen anchi Apotaaw yanggay wat ah Apudyus yag maid kasen Apudyus no faén yanggay hiya. ");
INSERT INTO blw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yag tot-owa way masapor laylaychéntaaw hiya ah aminay hamhamàtaaw ya ah aminay kenaraengtaaw ya ah aminay kafaelantaaw. Yag masapor agé laychén hen ahentagu kaman hen manlaychan hen achar. Tot-owa way wadwadcha paat hen mangafurotan hen annachay orchin no hen minchatonan hen amin way michaton an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yachi yag enlasin Jesus way naham-anchi way tagu gapon kenauston hen songfatna, yag annaat ekat an hiyéén, “Maila way faén naligat hen mantorayan Apudyus an hea.” Yag nanepod hen hiyachi, maid makatorod way kasen mansarudsud an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Angkay hiyachi way kasen chan tudtuchu ah Jesus ahchih Templo, senarudsudna way mangaliyén, “Pakay cha itudtuchun hen anchichay siguchay cha mintudtuchu hen orchin Moses way hen anchi epalen Apudyus way mantoray way Cristu, wat an yanggay ganà Are David. ");
INSERT INTO blw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Te uray ah Are David, hen nempahpahma-an hen Espiritun Apudyus an hiya, ekatnéén, ‘Ah Apudyus way Ap-apo, imfagana hen anchi Ap-apò way mangaliyén, tumùchua hen antoy pachawanan-o ingganah epa-afào an hea hen anchichay aminay kafusorno.’ ” ");
INSERT INTO blw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Entoroy Jesus way mangaliyén, “Wat no yaha way uray ah Davichén enawagana hen anchi Cristu ah Ap-apona, wat nokay agé hen ekamanna way hiya agé hen mangingganà hen anchi Ap-apo nò.” Hen anchichay chuaray way tatagu, anchag laylayad way mamangngar hen anchichay cha itudtuchun Jesus. ");
INSERT INTO blw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yag hen anchi chana manudtuchuwan an chicha, ekatnéén, “Ar-arwachanyu ta achiayu komaman hen anchichay siguchay cha mintudtuchu hen orchin Moses. Te chicha, anchag laylaychén way manginggégga-ay hen anchichay a-anammay way lumfongcha. Yag laylaychéncha agé way maririspitu paat wat anchag chan paraparamanu hen u-umfunan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yag no éméycha agé hen anchi chacha ma-am-amongan, icha tumùchu hen anchi ammay paat way tùchuwan. Yag kaman agé no incha mèlagsak, hen anchi tùchun agé paat hen nan-angato hen tumùchuwancha. ");
INSERT INTO blw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ngém chachaat angkay agé pérhén hen kok-owan hen anchichay nà-amfaro. Yag chachaat pa-anchuanchuwén hen luwarucha ah manlengébcha hen anchi kenarawengcha. Wat ammag chuséén Apudyus chicha ah chakchakkar way chusa.” ");
INSERT INTO blw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Angkay hiyachi way tummutùchu ah Jesus hen chumang hen anchi chacha mangententennagan hen pelak way midchat an Apudyus, innilana hen anchichay tatagu way cha omentennag. Yag enlasin Jesus way chuarcha hen anchichay fafaknang way ammag chachanakkar hen pelak way chacha etennag. ");
INSERT INTO blw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yag hen hiyachi, hinénggép agé hen ihay publi way nà-amfaro yag an yanggay chuway sentemos hen entennagna. ");
INSERT INTO blw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yachi yag anat ayagan Jesus hen anchichay pasorotna yag ekatna an chichéén, “Tot-owa hen antoy ifagà an chàyu way hen anchi publi way nà-amfaro wat hiyan kachachakkaran hen entennagna no hen anchichay amin way nantennag. ");
INSERT INTO blw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Te hen anchichay tapena wat inidchatcha yanggay hen anchi hommawar an chicha. Waman hen anchi nà-amfaro, ammag anggay paatchi ah pelakna yag enonghorna way nangidchat an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Angkay hen-argawan way cha gumhad cha Jesus hen anchi Templo, ekat hen ihay pasorotnéén, “Apo, ilam ngén hen ka-ammay hen antoy Templo ya hen hengehengena. Yag ammag kaskascha-aw agé hen annachay fato way nausar te ancha ammag chachanakkar ya a-anammay.” ");
INSERT INTO blw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yag ekat Jesusén, “Oo, anammaycha tot-owa ya chachanakkar, ngém tot-owa hen antoy ifagà an chàyu way umchah hen ag-agaw way anchag machachael aminto way ammag maid maila ah mantentenor-og ah fato, te ammag meorob amin.” ");
INSERT INTO blw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Angkay hiyachi yag émméy ah Jesus hen anchi tagéytéy ad Olivo yag tummutùchu way nangu-ughong hen anchi Templo. Yachi yag tommanig cha Pedro an Jaime yah Juan ya ah Andres way émméy an hiya yag henanhanancha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ay achi mafalin ta ifagam no kamana hen umchahan hen anchi imfagam ad annad way mepasamak. Yag nokay ngata agé hen sinyar way ma-ammaan ah mangenlasinan way tég-angay hen umchahan cha nadchi.” ");
INSERT INTO blw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yag sommongfat ah Jesus way mangaliyén, “Anyu yanggay ammag ar-arwachan ta achiayu marokop. ");
INSERT INTO blw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Te chuarcha angkay hen tatagu way fùnag way ancha ammag ekatén chicha ano hen hennag Apudyus way mantoray. Wat ammag chuar agé hen lokoponcha. ");
INSERT INTO blw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ya achiayu agé cha émégyat no changrényu hen a-anihéb hen gufat ya chamagényu agé hen gufat hen anchichay anachawwéy way lota. Te masapor chillu ma-ammaan cha natto. Ngém cha-an chillu hen umchahan hen anchi péppégan hen ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Te hen mekaman wat man-ahegugufatcha hen chan totoray hen antoy lota. Ya hen ihay lota agé, gufaténa hen henlomota. Yag maid agé achina manlunigan ya umchah hen pararo way fitel. Ngém amin cha nadchi wat an yanggay an lugrugin hen ligat way kaman hen anchi pés-éy sumigfan hen poton hen anchi chan pànot.” ");
INSERT INTO blw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Yag chàyu, masapor man-ar-arwad-ayu te telewén chàyu way manginchérém ya pangpang-oron agé chàyu hen kawad hen anchichay cha ma-am-amongan hen tatagu. Yag mepasangoayu agé hen anchichay chan totoray kaman hen anchichay gubérnador ya Are. Ma-ammaan amin cha nadchi an chàyu gapon afurotyu an haén, ngém yachiyat agé hen wayayu way mangempaka-ammu an haén. ");
INSERT INTO blw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te masapor chillu mepagngar hen antoy ammayay chamag hen katagutagu ah karotarota ya anat umchah hen péppég hen ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ngém mag-ay ta matelew-ayu ya michérém-ayu, achiayu machanagan ah esongfatyu, te no umchahchi wat midchat an chàyu hen ustoy iyaleyu. Te faén chillu chàyu hen marpowana te an epahmà hen Espiritun Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Yag hen tapen agé hen mekaman, wat man-ahetennocharcha hen ma-an-anag-i way mangempapchit hen iha ya iha. Ya uray agé hen hen-anamma ya hen-ininna wat man-ahetennocharcha way mangempapchit hen iha ya iha. ");
INSERT INTO blw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yag aminay tatagu wat agorgorancha chàyu gapo hen afurotyu an haén. Ngém hen anchichay mangempapate chillu hen afurotna ingganah anongohna wat mahara-an.” ");
INSERT INTO blw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Entoroy Jesus way mangaliyén, “Awniyat ammag hen-argawan ilanyu hen anchi aggaégyatay térén way ammag tumùchu hen anchi achi koma mafalin tumùchuwana. (Chàyu way mamasa an natto, ma-awatanyu koma hen laychénay aryén.) No ilanyuchi, chàyu way wacha hen provinsiyan hen Judea, omawid-ayuwat way i mantaro ah filig. ");
INSERT INTO blw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yag uray agé hen anchichay wachah chara, wat achicha hénggép ah fafaréycha way i mangara hen kok-owacha te anchaat an omawid. ");
INSERT INTO blw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yag umat agé hen anchichay hommepot, wat achicha homàyat way mangalekam hen lumfongcha, te anchag manlapon nadchi yag ommawidchaat. ");
INSERT INTO blw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yag anchag kàka-ase lawa hen anchichay nafufugi ya hen anchichay chan pasoso hen hiyachiy tempo. ");
INSERT INTO blw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wat chawatényu an Apudyus ta achi koma ma-ammaanchi hen tempon hen agiléd. ");
INSERT INTO blw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Te hen ligat way fùnag hen hiyachiy tempo wat ammag maid mepaniyan hen kenaligatna nanepod hen lugrugin hen nangammaan Apudyus hen angamin ingganad uwan, ya uray agé ah ing-inggana wat maid kasen mepachah hen antoy lota ah kaman an nadchiy ligat. ");
INSERT INTO blw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te no achi aketén Apudyus hen ag-agaw way ka-ammaan hen hiyachiy ligat, wat sigurachu way anchag matéy hen aminay tatagu. Ngém gapo ta ka-asiyana hen anchichay tatagu way penepelena, annag imfafagga way aket hen ag-agaw way ka-ammaan hen yachiy ligat.” ");
INSERT INTO blw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Yag mag-ay ta wachay mangalen chàyuwén, ‘Antoyan hen anchi hennag Apudyus way mantoray,’ ono ekatchéén, ‘Anchayan way wachahchi,’ achiyuwat ammag cha afurotonchi. ");
INSERT INTO blw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Te fùnagcha angkay hen chuar way tatagu way senang Cicristu way ammag mangaliyén chicha ano hen hennag Apudyus. Ya chuar agé hen senang poprofeta way mangaliyén chicha ano agé hen profetan Apudyus. Yag kafaelancha agé way mangamma hen kaskascha-aw ya hen anchichay sinyar way omenpahaang, ta no an mafalin wat uray hen anchichay tatagu way penepelen Apudyusat lokoponcha. ");
INSERT INTO blw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wat ar-arwachanyu te hen nangimfag-à amin an cha natto an chàyu ya anat ma-ammaan, ta ah mansasagganaanyu.” ");
INSERT INTO blw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Entoroy Jesus agé way mangaliyén, “Yag no marpas hen hiyachiy ligat wat ammag makorkor hen egad ad uchu ya ammag machép hen init, yag achi agé homelaw hen hérag ya anchag maya-ayà hen anchichay taraw. ");
INSERT INTO blw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yag hen hiyachi, mampàilaà way Pangorowan hen Tatagu te umaliyà way marpo ad uchu way iyaleyà hen funat yag humiliyà ah kaenammay-o yag maila agé hen mannakafalin-o. ");
INSERT INTO blw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yag hen hiyachi agé, hénagê hen anchichay a-anghel-o ta éméycha hen péppég hen karotarota way i mangamong hen anchichay aminay tatagu way penepelen Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yachi yag anat ekat Jesus agéén, “Ilanyu hen annay away way fig te wachan acharényun nadchi koma ah mangar-anyu ah hamhamàyu. Te inni-ilayu met way no chana ilugi way umutar ya pomenge, tég-angay hen tiyargaw. ");
INSERT INTO blw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wat pachongna agé, no ilanyu way cha ma-ammaan hen annachay imfagà, ma-awatanyu agé koma way tég-angay hen mamfangchà. ");
INSERT INTO blw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yag tot-owa hen antoy ifagà an chàyu way achi matéy hen tapen hen tatagu way cha matagu ad uwan yag na-ammaanat amin hen anchichay imfagà. ");
INSERT INTO blw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Te uray maumah amin hen maila ad uchu ya hen antoy lota wat achi chillu miyat-atob hen antochay chà enale te masapor ma-ammaan amin.” ");
INSERT INTO blw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ekat Jesus agéén, “Maid tagu ah nangila hen anchi ag-agaw ya uras way ma-ammaan hen anchichay imfagà. Yag uray haénay anà Apudyus ya umat agé hen anchichay a-anghel wat maid nangila, te hen nangila yanggayat ah Ama ad uchu. ");
INSERT INTO blw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wat hiyachi, an-ayu yanggay ammag mansasaggana way kaman mamah-ag, te maid innilayu hen umchahan cha nadchi. ");
INSERT INTO blw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hen mepaniyanaat kaman hen anchi ihay tagu way i namfiyahi. Yag hen anchi lommayawana, impiyarna hen egad hen anchichay alepanna way wéhchiyén na-adchan ah fiyang way ammaana. Yag tinugutugunna agé hen anchi guwarcha ta an yanggay ammag mamah-ag way manguwarcha hen chana guwarchaan. ");
INSERT INTO blw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wat kaman agé an chàyu, an-ayu yanggay ammag kaman mamah-ag way kaman agé guwarcha. Te hen anchi guwarcha, maid innilana no henoy uras hen mamfangchan hen anchi ap-apona, no cha madhém ono gawan chi lafi ono cha ma-apeh ono cha pomaway. ");
INSERT INTO blw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wat mansasaggana-ayu agé ta no umaliyà, achì koma aphoran chàyu way ammag kaman nanasséy hen afurotyu. ");
INSERT INTO blw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Chà ifagato an chàyu ta masapor sasagganéényu hen mamfangchà. Yag faén agé yanggay chàyu hen chà mangimfag-an te uray agé hen aminay tatagu.” ");
INSERT INTO blw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yachi way chuway ag-agaw yanggay wat umchah hen anchi lagsak way manmanma-an hen anchi iggay namchitan hen anghel hen a-anà hen ganà Israel ad Egipto way hen yachiy lagsak agé hen manganancha hen anchi tenapay way cha-an fumnar. Yag hen hiyachi agé way tempo, chachan totopà hen anchichay anap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin no heno hen ekamancha way menlepot way manelew an Jesus ah mangempapchitancha. ");
INSERT INTO blw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yag hen ekatcha, achicha telewén hiya hen anchi tempon hen yachiy lagsak te awni yag anchag gumabfor hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Hen hiyachi, wacha cha Jesus ad Betania ah faréy cha Simon way hiyan anchi nakkonet hen ar-argaw. Angkay hen chacha manganan ahchi, hinénggép hen ihay in-ina way nan-é-édchén ah am-ammay way futilya way na-ammaan ah fato way ekatchéén alebastér way natatarwan ah kanginaan way fangfangru way ekatchéén nardo. Yachi yag penténna hen fagang hen anchi futilya yag inhiyatna ah urun Jesus. ");
INSERT INTO blw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngém hen tapen hen anchichay nìtutùchu an Jesus, ammag lommaweng hen hamhamàcha, wat chachan tetennopà way manumsek hen anchi in-ina, ekatchéén, “Pakay ammag lamramén nahha hen annay lana. ");
INSERT INTO blw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ammoh achi un-unnina no anna enlao ta midchat koma hen laona hen anchichay maid mafalinna. Te non an umat yag nelaohaat narégnah elabfu ah nasorok ah ihay tawén.” Yag chacha ingarén hen anchi in-ina. ");
INSERT INTO blw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngém ekat Jesusén, “Pakay ingarényu. Yasa ta egad hiya hen antoy chana ammaan, te usto met ya ammay hen antoy enammaana an haén. ");
INSERT INTO blw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yag no mepanggép hen anchichay maid mafalinna, farangna hen tomoronganyu an chicha no ekatyuwén tomorong-ayu te ancha met ammag mawawà-acha. Ngém haén, achi mafayag hen mì-i-iggawà an chàyu. ");
INSERT INTO blw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yag hen antoy in-ina, enammaana hen patinggan hen kafaelana ya layadna, te penangpangona way nanlana hen achar-o ah mesaganaan hen milufuà. ");
INSERT INTO blw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yag tot-owa hen antoy ifagà an chàyu way henoy lugar hen amin antoy lota way mitudtuchuwan hen antoy ammayay chamag, wat mahaphapet agé hen enammaan hen antoy in-ina ah manamham-an an hiya.” ");
INSERT INTO blw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Angkay hiyachi, ah Judas Iscariote way iha hen anchichay hemporo ya chuway pasorot Jesus, émméy hen anchichay anap-apon hen papachi way i mangentorag ah manelewancha an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wat anchag laylayad way térén hen nangngarancha hen anchi imfagan Judas, yag empostacha way fayachancha hiya. Wat nanepod hen hiyachi, inlugin Judas way manginyanap hen ekamanna way mangempadpap an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Angkay hiyachi, inumchah hen anchi pés-éy hen ag-agaw hen anchi lagsak way manganancha hen anchi tenapay way cha-an fumnar. Yag yachi agé hen mamartiyancha hen anchi karnero way issacha hen anchi lagsak way manmanma-ancha hen anchi iggay namchitan hen anghel hen a-anà hen anchichay ganà Israel. Angkay hiyachi, henanhanan hen anchichay pasorot Jesus an hiya way mangaliyén, “Chuud hen laychém way mangensaganaanni hen anchi manganantaaw hen antoy lagsak way Manmanma-an.” ");
INSERT INTO blw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yachi yag hennag Jesus hen chuway pasorotna way mangaliyén, “In-ayu hen hiyachiy fabréy wat hib-atényu hen ihay am-ama way namfufu-ud ah nahahàchuwan way fanga yag inunudyu hiya ");
INSERT INTO blw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","hen anchi faréy way hénggépana. Wat ifagayu hen anchi nangimfaréy way mangaliyén, ‘Hen imfagan hen anchi aponi, chuud anohto hen anchi kowarto way mèanana an chàni way pasorotna hen antoy lagsak way Manmanma-an.’ ");
INSERT INTO blw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yag no ifagayuha, wat itudtuchuna an chàyu hen anchi chakar way kowarto hen pegwan hen garachu way wacha amin hen masapor. Yag yachi hen mangensaganaanyu hen manganantaaw.” ");
INSERT INTO blw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hiyachi yag lummigwat tot-owa hen anchi chuwa way émméy hen anchi fabréy yag inchahancha amin hen imfagan Jesus, wat ensaganacha hen manganancha hen hiyachiy lagsak. ");
INSERT INTO blw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Angkay hiyachi way cha madhém, ommanamot cha Jesus ya hen anchichay hemporo ya chuway pasorotna hen hiyachiy faréy. ");
INSERT INTO blw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yag hen chacha manganan, ekat Jesus an chichéén, “Tot-owa hen antoy ifagà an chàyu way wacha angkay hen iha way cha mèan ad uwan way mangentochar an haén.” ");
INSERT INTO blw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wat anchag ngommehpéy amin way wéhchiyén chana ifaga an Jesus way mangaliyén, “Ay haén ngata.” ");
INSERT INTO blw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yag ekat Jesusén, “Hiyan iha an chàyuwanna way hemporo ya chuwa way cha paat mèofong an haén. ");
INSERT INTO blw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Haén way Pangorowan hen Tatagu, pédténà chillu te yachi hen nesosorat ad namenghan ah ma-ammaan an haén. Ngém ammag kàka-ase lawa hen anchi tagu way ammag mangentorod way mangentochar hen atéyà. Ammag un-unnina non an iggay koma niyanà hen hiyahay tagu.” ");
INSERT INTO blw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hen hiyachi way chacha mangan, innaran Jesus hen ihay tenapay yag nanyaman an Apudyus yag annaat petpet-angén yag inwarasna hen anchichay pasorotna way mangaliyén, “Anényuto te yato hen achar-o.” ");
INSERT INTO blw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yachi yag annaat agé aran hen ihay tasa way fayah, yag kasen nanyaman an Apudyus yag annaat idchat an chicha ta mantebtebyanancha amin. ");
INSERT INTO blw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yag annaat ekat way mangaliyén, “Yato hen charà way miwàwà ah macharosan hen fasor hen chuaray tatagu. Yag hen antoy charà agé hen manot-owaan hen anchi kà-amma way torag Apudyus hen tatagu. ");
INSERT INTO blw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yag tot-owa hen antoy ifagà an chàyu way achiyà kasen umin-inum hen kaman annatto way fayah ingganah umchah hen anchi mantorayan Apudyus ya ana-at uminum hen anchi faru way fayah.” ");
INSERT INTO blw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Angkay hiyachi yag nankankantacha yag anchaat gumhad way éméy hen anchi tagéytéy ad Olivo. ");
INSERT INTO blw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Imfagan Jesus hen anchichay pasorotna way mangaliyén, “No aw-awniyat anà ammag taynan an chàyu te an-ayug omawid amin, te yaha chillu hen imfagan hen anchi nesosorat way alen Apudyus way ekatnéén, ‘No pédtê hen anchi minya-achug hen karnero wat anchag omawid amin hen anchichay karnero.’ ");
INSERT INTO blw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngém no man-uchiyà wat mamangpangowà no chàyu hen anchi provinsiyan hen Galilea ta ahchi hen man-aheil-antaaw.” ");
INSERT INTO blw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yachi yag nan-ale ah Pedro way mangaliyén, “Uray no taynancha-a hen antochay ifà wat achì chillu taytaynan hea.” ");
INSERT INTO blw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngém ekat Jesus an hiyéén, “Tot-owa hen antoy ifagà an heay Pedro way achi epegwan hen manò way manollaò hen hiyatoy lafi wat mametluwémat way mangenhoot an haén.” ");
INSERT INTO blw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yag tenlén chillu Pedro way mangaliyén, “Achi mafalin way ehoot-o hea, uray yachi hen mìyatéyà an hea.” Yag nètemfuruycha agé amin hen anchichay pasorotna way yachi agé hen enalecha. ");
INSERT INTO blw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Angkay hiyachi yag émméy cha Jesus hen anchi lugar way ekatchéén Getsemani yag imfagana hen anchichay pasorotna way mangaliyén, “Itùchuyu an natto ta iyà manluwaru.” ");
INSERT INTO blw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yag annaat etàtaen cha Pedro an Jaime yah Juan. Yag yachi, inlugina way tomkar way ammag pararo way térén hen hamhamàna. ");
INSERT INTO blw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yag annaat ifaga hen anchichay ifana way mangaliyén, “Ammag pararo hen antoy hamhamào way kaman paat yatowat agé hen iyatéy-o. Wat inggaw-ayu an natto way achiayu cha masséy ta i-illanà koma.” ");
INSERT INTO blw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yachi yag émméy hen anchi ê-éyna yag ammag nanlùfub way manluwaru. Yag chana chawatén an Apudyus ta no mafalin, achi koma metoroy hen anchi ligat way tég-angay mepachah an hiya. ");
INSERT INTO blw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yag ekatna way manluwaruwén, “Ama, maid achi mafalin an hea, wat achim koma parufusun hen antoy ligat way tég-angay mepachah an haén. Ngém uray no yaha hen chawatê, laychê chillu way ma-ammaan yanggay hen laychém.” ");
INSERT INTO blw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yachi yag namfangad ah Jesus hen iggaw hen anchichay ifana yag inchahanaat agé chicha way nanasséy. Yag annaat ekat an Pedrowén, “Simon, ay nanasséy-ayuwat. Ay achi lawa mafalin ta i-illanà ah uray ihay uras. ");
INSERT INTO blw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Achiayu cha masséy ta an-ayuwat manluwaru agé ta achiayu koma ma-afà gapon anchi mepasamak. Innilà way ah hamhamàyu wat laychényu way mangamma hen usto, ngém an-ayu yanggay ammag cha ma-afà ah kenakapsot hen acharyu.” ");
INSERT INTO blw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yachi yag kasen agé émméy ah Jesus way i nanluwaru way nangempegwa way mangimfaga an Apudyus hen anchi chinawatna chillu. ");
INSERT INTO blw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yag anat kasen mamfangad yag innilana agé cha Pedro way nanasséy chillu te ammag pararo hen héyépcha. Finangon Jesus chicha yag ammag maid innilacha ah esongfatcha an hiya. ");
INSERT INTO blw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Angkay na-awni agé way petlon hen namfangchana way manluwaru, ekat Jesus an chichéén, “Ay étégyu chillu way nanasséy way man-inungar. Nonghamchi te antoy inumchahat hen tempo way haén way Pangorowan hen Tatagu wat midchatà hen anchichay lawengay tatagu. ");
INSERT INTO blw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wat fumangon-ayuwat ta intaaw te ilanyu ngén, nawayat hen anchi mangentochar an haén.” ");
INSERT INTO blw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Angkay hiyachi way étég Jesus way chan ale yag inumchahat ah Judas way iha hen anchichay hemporo ya chuway pasorotna. Yag wachacha agé hen anchichay chuar way tatagu way enetnodna way namfafangngid hen tapena ya nampapang-or hen tapena. Cha nadchiy tatagu hen hennag hen anchichay anap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin Moses ya anat hen anchichay anam-ama way ponò hen Judio. ");
INSERT INTO blw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Hen imfafaggan Judas hen anchichay enetnodna, ekatnéén, “Hen anchi tagu way mangempàil-à hen rispitù an hiya hen mentomoà hen tapào hen apengna, yachi hen telewényu ya elayawyu way masapor maguguwwarchaan.” ");
INSERT INTO blw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yachi yag émméy ah Judas an Jesus yag ekatnéén, “Apo,” yag annaat etomò hen tapàna hen apengna. ");
INSERT INTO blw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yag hen hiyachi, ammag finchéngat hen anchichay tatagu ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngém hen ihay ifana way nètatàchég an nadchi, annag inuhfù hen fangidna yag fina-agna hen alepan hen anchi kangatowan way pachi yag naporhan hen ingana. ");
INSERT INTO blw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yachi yag imfagan Jesus hen anchichay namchéng an hiya way mangaliyén, “Pakay, ay futangelowà ta masapor mamfafangngid-ayu ya mampapang-or-ayu way i manelew an haén. ");
INSERT INTO blw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ammag enag-agaw met way nìyamoamongà an chàyu ah Templo hen anchi chà nantudtuchuwan, yag pakay faén ahchi hen nanelewanyu an haén nò. Ngém yato chillu hen masapor mekaman ah tomot-owaan hen anchi nesosorat way alen Apudyus.” ");
INSERT INTO blw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yag hen hiyachi, anchag ommawid amin hen anchichay pasorotna yag tenaynancha hiya. ");
INSERT INTO blw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yag wacha agé hen hiyachi hen ihay fafaru way ammag iggay nanlumfong hen nangunuchana an Jesus, te an yanggay nan-a-akrang ah yapet way lopot. Wat entakorong hen anchichay tatagu way mampap an hiya. ");
INSERT INTO blw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ngém an yanggay hen anchi akrangna hen empagudcha te pommorhapoh way ommawid way ammag namfafallad. ");
INSERT INTO blw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Angkay hiyachi yag inyéycha ah Jesus hen faréy hen anchi kangatowan way pachi te ahchi hen na-amongan amin hen anchichay anap-apon hen papachi ya hen anchichay anam-ama way ponò hen Judio ya hen anchichay siguchay cha mintudtuchu hen orchin Moses. ");
INSERT INTO blw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Wat ah Pedro, chinuchum-ang way cha umunud yag nanlahin hen anchi fatawan hen faréy hen anchi kangatowan way pachi yag nìtùchu hen anchichay guwarcha way mèanichu. ");
INSERT INTO blw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Angkay hen anchichay na-a-among ah faréy way anap-apon hen papachi ya amin hen anchichay anam-ama way ponò way ekatchéén konsel, chacha amin anapén hen epafasorcha an Jesus ah érégnah mempapchitancha, ngém ammag maid inchahancha. ");
INSERT INTO blw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Anchag chuar hen anchichay i man-istigu way mangenlémrém an hiya, ngém ammag nanhinafà-ar hen chacha enale. ");
INSERT INTO blw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hiyachi yag anat tomàchég hen anchichay tapen hen anam-ama way mangenlémrém an hiya way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Chengngarni angkay hen enalen hen antoy tagu way chachaeléna ano hen antoy Templotaaw way tatagu hen nangamma yag anna agég sà-achén hen iha hen anchi ma-atloy ag-agaw way faén anoh tagu hen mangamma.” ");
INSERT INTO blw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngém uray agé chichaat ammag achi chillu agé mètemfuruy hen chacha aryén. ");
INSERT INTO blw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Angkay hiyachi yag tommàchég hen anchi kangatowan way pachi hen sangwanancha amin way mamistigar an Jesus yag ekatnéén, “Ay achia makasongfat hen antochay chacha epafasor an hea. Ay tot-owa hen chacha aryén.” ");
INSERT INTO blw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngém ammag gummiginnang chillu ah Jesus way achin ar-ale. Wat entoroy hen anchi chan fistigar way mangaliyén, “Ay hea hen anchi Cristu way anà hen anchi machachayaw way Apudyus ta hea hen anchi empopostana way umale way mantoray.” ");
INSERT INTO blw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Oo haén,” way ekat Jesus, “yag awniyat ilanyu amin haén way Pangorowan hen Tatagu way tumutùchu hen pachawanan Apudyus way mannakafalin. Yag ilanyu agé haén hen anchi mamfangchà way marpod uchu way iyalen hen funat.” ");
INSERT INTO blw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yag hen hiyachi, ammag entanong hen anchi kangatowan way pachi way nangissay hen lumfongna gapon anchi enalen Jesus, yag ekatnéén, “Ay ammoh kasentaaw anapén hen man-istigu ah fasorna. ");
INSERT INTO blw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chengngartaaw met amin hen anchi enalena way annag cha pérhén hen kena-apudyus Apudyus. Wat nokay hen ekamantaaw an hiya nò.” Yag tenomfarcha amin hen anchichay na-a-among way mangaliyén, “Karébféngana way mepapchit.” ");
INSERT INTO blw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yachi yag inluginat hen tapena way manoppatoppa an hiya. Yag hen tapena, ancha an finongot hen uruna ta maid ilana yag anchaat loproppagén way mangaliyén, “Ayé, ifagam man no heno hen nanlopag an hea.” Ya uray agé hen anchichay guwarcha, anchag lapchù-un hiyéén tenappetappetcha. ");
INSERT INTO blw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ah Pedro agé, étégna ah fatawa, yag émméy hen ihay fafarasang way alepan hen anchi kangatowan way pachi. ");
INSERT INTO blw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yachi way innilana ah Pedro way cha mèanichu, enméschagana hiya yag annaat ekatén, “Hean samet hen ihay ifan Jesusanchi way eNazaret.” ");
INSERT INTO blw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngém enhoot Pedro way mangaliyén, “Tawwan hen annay cham aryén te maid innilà.” Yag chaat lomayaw ah Pedro way éméy hen anchi penget hen fatawa way nanag-én hen charan. Yachi yag nanollaò hen manò te pés-éy tollaòchi. ");
INSERT INTO blw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yachi yag kasen agé innilan hen anchi fafarasang hiya yag imfagana hen anchichay ahetàtàchég way tatagu way mangaliyén, “Yaha angkay agé hen ihay ifana.” ");
INSERT INTO blw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngém kasen agé enhoot chillu Pedro. Yag yachi agé way iggay nahen-awniyan yag ekat agé hen anchichay ahetàtàchégén, “Aẁ, hea eman hen ihay ifana, a, te afab-én way iGalilea, a, met.” ");
INSERT INTO blw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yag ammag nansapata ah Pedro way mangaliyén, “Uray ud-ay pédténà an Apudyus no faén tot-owa hen antoy chà ifaga an chàyu te tot-owa angkay way maid poros innilà hen annay taguwanna way chayu aryén.” ");
INSERT INTO blw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yag hen hiyachi, kasenat agé nanollaò hen manò way yachin pegwan hen tollaò, yag hemhemma-at Pedro hen anchi imfafaggan Jesus an hiya way achi manollaò hen pegwan tollaò yag nametluwénaat way mangenhoot an hiya. Yag chaat mankela gapoh hamhamàna. ");
INSERT INTO blw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Angkay hiyachi way cha pomaway, kasencha na-among hen anchichay anap-apon hen papachi ya anam-ama way ponò ya hen anchichay siguchay cha mintudtuchu hen orchin Moses ya amin agé hen anchichay konsel, yag nantatagépfarcha way mamanoh no henon ekamancha an Jesus. Wat tenawidcha hen limana yag inyéycha way i mangemporang an Gubérnador Pilato. ");
INSERT INTO blw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yachi way inumchahcha yag finistigar Pilato ah Jesus way mangaliyén, “Ay hea ano hen Aren hen Judio.” Yag ekat Jesusén, “Oo, tot-owa hen annay enalem.” ");
INSERT INTO blw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yachi yag ammag chuar hen cha epafasor hen anchichay anap-apon hen papachi an Jesus. ");
INSERT INTO blw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yag anat ekat Pilato an hiyéén, “Ay achia makasongfat hen annachay chacha epafasor an hea way an peet ammag chuar.” ");
INSERT INTO blw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngém ammag gummiginnang chillu ah Jesus. Wat ammag nahaang ah Pilato. ");
INSERT INTO blw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hen nigagangay an Gubérnador Pilato, no umchah hen hiyatoy lagsak hen Judio way Manmanma-an, wat wachay wacha hen ilufusna way ihay farud way egad hen piliyén hen anchichay Judio. ");
INSERT INTO blw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Angkay hen hiyachiy tempo, wachacha hen nifafarud way tot-oway pommatéy way nangabfor hen gubérno, yag hen ihan chicha wat ah Barabas hen ngachanna. ");
INSERT INTO blw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Angkay hiyachi yag na-among hen anchichay tatagu way i nangimfaga an Pilato way ammaana koma hen anchi chana ekamkaman chillu way mangemparufus hen ihay farud. ");
INSERT INTO blw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Wat ekat Pilato an chichéén, “Ay laychényu ta hen antoy Areyu way Judio hen ilufus-o.” ");
INSERT INTO blw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yahan imfagana te nadlawna way ammag gapo yanggay hen apés hen anchichay anap-apon hen papachi yag anchaat epafarud ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ngém hen enkaman peet agé hen anchichay anap-apon hen papachi, ancha ammag senubsufan hen anchichay na-a-among way tatagu te ammag ah Barabasat agé hen imfagacha way ilufusna. ");
INSERT INTO blw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","“Oo a,” way ekat Pilato an chicha, “ngém nokay hen mangammaà hen antoy ekatyuwén Areyu way Judio nò.” ");
INSERT INTO blw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yag anchag aheo-ongaw amin way mangaliyén, “Anyuwat an ekoros hiya.” ");
INSERT INTO blw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Yag ekat Pilato agéén, “Oo a, ngém chuud chi laweng ah enammaana ah narégna ah mekorosana.” Ngém chachaat ehorhoryad way mangèngaw way mangaliyén, “Ekorosyuwat hiya.” ");
INSERT INTO blw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yag gapo ta patigén Pilato hen kapnekan hen anchichay tatagu, wat annag inlufus ah Barabas ah pagfaruchan. Waman ah Jesus, empahapratna yag annaat eporang way melansa hen koros. ");
INSERT INTO blw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Angkay hiyachi yag inighad hen anchichay sorchachu ah Jesus hen anchi fatawa hen faréy Gubérnador Pilato yag enayagancha hen anchichay aminay ifacha way sorchachu. ");
INSERT INTO blw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yag anchaat lumfongan ah Jesus ah kaman hen lumfong chi are ah manénsénaancha. Yag anchaat agé falengawngawén hen pagat ah kaman koronana yag inhùrubcha ah uruna. ");
INSERT INTO blw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yag anchag cha sén-ésén-én way magénén senaruchucha hiya way mangaliyén, “Ta mataguah ing-inggana, heay Aren hen Judio.” ");
INSERT INTO blw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yachi yag anchaat agé pagpaggohon hen uruna yag tenoppatoppaancha hiya, yag magén aminén nampap-alentomangcha way manad-ayaw an hiya. ");
INSERT INTO blw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Angkay hiyachiy narpas way sensennacha, kasencha senokatan hen anchi emparumfongcha yag iniggacha hen anchi siguchay lumfongna yag anchaat iyéy hiya hen anchi mekorosana. ");
INSERT INTO blw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Angkay hen chacha manginyéyan an Jesus, hinib-atcha hen ihay tagu way iCerene way cha homàyat way i hommepot. Ah Simon hen ngachanna way aman cha Alejandro an Rufo. Yag ammag penelet hen anchichay sorchachu ta fu-uchuna hen anchi koros Jesus. ");
INSERT INTO blw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yachi yag inyéycha ah Jesus ad Golgota way hen laychénay aryénat, “Hen alentutugun chi uru.” ");
INSERT INTO blw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yag enadchancha hiyah fayah way na-ahrangan ah agah way mira ngém achina chillu inumun. ");
INSERT INTO blw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yachi yag enlansan hen anchichay sorchachu hiya hen anchi koros, yag anchaat mamfub-unnot way manginyàchang hen lumfongna. ");
INSERT INTO blw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nà-argaw hen anchi nangenlansaancha an hiya. ");
INSERT INTO blw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yag wacha agé hen empòatcha hen uhun hen uruna way nesoratan hen anchi ekatchéén fasorna way ekatnéén, “Yato hen Aren hen Judio.” ");
INSERT INTO blw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hen hiyachi, wachacha agé hen chuway futangelo way nigsan way nekoros way hen iha, ah pachawananna ya hen iha, ah pachawigina. ");
INSERT INTO blw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hen na-ammaan cha nadchi wat ah tomot-owaan hen anchi nesosorat ad namenghan way ekatnéén, “Metakorong hiya hen anchichay futangelo.” ");
INSERT INTO blw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yag aminay tatagu way manloohén chacha amin manwigwigiwig way manmanna an Jesus, yag chacha agé insortuwén way mangaliyén, “Ayé kay umpaya, ammag anggayhaat ekatnowén fakasém hen anchi Templo yag kasenno senà-ad hen petlon hen ag-agaw. ");
INSERT INTO blw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yag ayé kay umpay, gumhad-a ta hara-am hen acharno.” ");
INSERT INTO blw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yag uray agé hen anchichay anap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin Mosesat chachan tatagépfar way manmanna an hiya way mangaliyén, “Ammag anggayhaat tenorongana hen tapena yag ammag achiyat agé peet makatorong hen acharna. ");
INSERT INTO blw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ilantaaw kay anga hen Aretaawanna way ganà Israel non an gumhad ta mangil-antaaw ah mangafurotantaaw way hiya tot-owa hen empalen Apudyus way Cristu.” Yag uray agé hen anchi chuway ifana way nelaransa wat chacha agé metaptape way mangmangsot an hiya. ");
INSERT INTO blw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Angkay hiyachi way ustoy nanggawa, ammag hommelangat agé hen aminay lota ingganah fummatangan. ");
INSERT INTO blw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yag yachi way fummatangan, enèngaw Jesus way mangaliyén, “Eli, Eli, lama sabaktani,” way hen laychénay aryénat, “Amay Apudyus, pakay manchùganà.” ");
INSERT INTO blw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chengngar hen tapen hen anchichay tatagu hen anchi enalena yag ekatchéén, “Changréntaaw ngén, te kaman paat chana ayagan ah Elias.” ");
INSERT INTO blw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yag nanagtagat hen iha an chicha way i mangempainum, wat ensawsawna hen anchi lopot hen ommelém way fayah yag annaat pa-atén way minchawchaw an Jesus ta sosopona. Yag chana ekatén, “Hahadchéntaaw éggaya ta ilantaaw no umale tot-owa ah Elias way tomorong an hiya.” ");
INSERT INTO blw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yag kasen nan-ongaw ah Jesus yag natéyat. ");
INSERT INTO blw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wat hen hiyachi, ammag nan-agwaat agé way nagissay hen anchi séchar way kortena way horchà hen iggaw Apudyus paat ah Templo way ammag nanlugi ad uchu inggana ad char-ém. ");
INSERT INTO blw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yag hen anchi kapetan hen sorchachu way nanahagang an Jesus, hen nangil-ana hen enkamanna way natéy, ekatnéén, “Aẁ, yato peet tot-owa hen anà Apudyus, a.” ");
INSERT INTO blw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yag hen anchi ê-éyna agé, wachacha hen anchichay inin-ina way nangi-ila hen nekaman. Hen tapena an chichaat ah Maria way eMagdalena ya anat ah Salome, ya ah Maria agé way inan anchi ihay Jaime way ong-onga yah Joses. ");
INSERT INTO blw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chichachi hen anchichay cha netnonetnod an Jesus way tommorong an hiya hen kawad-ana ad Galilea. Yag wachacha agé an nadchi hen anchichay chuar way tapenay finufae way netnod an Jesus hen émméyana ad Jerusalem. ");
INSERT INTO blw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Hen hiyachiy ag-agaw wat yachi hen mangensaganaan hen Judio hen aminay masaporcha para hen Safachu way ngilin. Wat hiyachi way tég-angay malihnug hen init ah milugiyan hen anchi ngilin hen Senafachu, wachan ihay iyArimatea way ammag nangentorod way émméy an Gubérnador Pilato way mangimfaga hen anchi achar Jesus no mafalin. Ah Jose hen ngachanna way hiyan ihay maririspitu way membron hen anchi konsel hen Judio, ya hiya agé hen ihay mamannéd hen milugiyan hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Angkay émméy ah Jose an Gubérnador way i mangimfaga hen achar hen anchi natéy, yag ammag nahaang ah Gubérnador hen nangngarana te pegachi yag natéyat. Wat empa-ayagna hen anchi kapetan hen sorchachu ah manot-owaana way natéy ah Jesus. ");
INSERT INTO blw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yag imfagan hen anchi kapetan way natéy tot-owa. Yachi yag anat parufusun Gubérnador ah Jose way i mangara hen achar Jesus. ");
INSERT INTO blw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wat i lommao ah Jose ah am-ammay ya pokkawan way uroh yag annaat i upahén hen achar Jesus yag infunifunna hen anchi lenàwana, yag annaat iyéy way manginlufù hen anchi lufù way an napasorag way natoktokan hen chéprah. Yachi yag annaat agé allinén hen anchi chakaray tépà way etangébna hen anchi lufù. ");
INSERT INTO blw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Yag cha Maria way eMagdalena ya ah Maria way inan cha Joses, ini-ilacha hen nekaman hen nilufuan Jesus. ");
INSERT INTO blw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Angkay hiyachi way cha madhém way narpas hen anchi Safachu way ngilin, émméy cha Maria way eMagdalena yah Salome ya ah Maria way inan cha Jaime way icha lomao ah fangfangru way melana hen natéy ta incha koma lanéén hen anchi achar Jesus ah lufù. ");
INSERT INTO blw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Angkay nafigat way Chuminggu, fummigatcha way émméy hen anchi nilufuan Jesus. ");
INSERT INTO blw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yag hen anchi chacha manaranan, chachan tatagépfar way mangaliyén, “Nokay ngata hen mangallin hen tangéb hen anchi lufù ");
INSERT INTO blw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","te ammag chakar way térén hen anchi tépà way tangébna.” Angkay hiyachi way chacha homag-én yag innilacha hen anchi lufù way ammag na-a-allinat agé hen anchi tépà way nafufùtan hen anchi lufù. ");
INSERT INTO blw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wat henomròcha hen anchi lufù yag innilachaat agé hen ihay kaman fafaru way tummutùchu hen ommapet ah pachawanancha way ammag pokkawan hen lumfongna. Wat anchag émmégyat way nangila an hiya. ");
INSERT INTO blw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yag nan-ale hen anchi tagu way mangaliyén, “Achiayu cha émégyat te innilà way ah Jesus way eNazaret hen inyu ilan way enlansacha hen koros. Ngém maid angkay ahto te nan-uchi. Ilanyu ngén hen annay nepabfégana wat maid hiya. ");
INSERT INTO blw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wat homàyat-ayuwat ta inyu ifaga hen amin anchichay pasorotna ya ah Pedro paat way ah Jesus, mamangpango ad Galilea ta ahchi hen mangil-ancha an hiya, te yaha chillu hen imfafaggana an chicha.” ");
INSERT INTO blw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yachi yag anchag hetatagtag hen anchichay inin-ina way lomayaw hen anchi lufù way chacha amin mampapayagpag ah égyatcha. Yag maid agé henaphapetcha gapon égyatcha.  9 Angkay émméy hen anchichay inin-ina an cha Pedro ya hen anchichay ifana, 10 Angkay hiyachi yag hennag Jesus hen anchichay pasorotna way éméy ah karotarota way i mangempagngar hen anchi chamag way narpon Apudyus way yachin mepanggép hen mì-iggawan an hiya ah ing-inggana.  ");
INSERT INTO blw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Angkay hiyachi way nan-uchi ah Jesus hen cha pomaway hen Chuminggu, hen anchi pés-éy nampàil-ana wat an Maria way eMagdalena way hiya hen anchi nemparyawana hen anchi pitu way nihuhurug way ongtan. ");
INSERT INTO blw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yag yachi way innilan Maria ah Jesus, innaat henaphapet hen anchichay ifan Jesus way chachan totokar ya chachan kela amin. ");
INSERT INTO blw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngém chicha, uray chengngarcha hen anchi henaphapetna way nan-uchi ah Jesus yag innilana paat agé hiya, ancha chillug achi afuroton. ");
INSERT INTO blw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Angkay hiyachi yag kasen agé nampàila ah Jesus hen chuway ifana hen chacha manaranan way éméy hen ihay fabréy, ngém safali hen enkamanna way nampàila an chicha. ");
INSERT INTO blw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yachi yag namfangadcha way i nanaphapet hen anchichay ifacha agé, ngém tàén, anchag achi chillu afuroton. ");
INSERT INTO blw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Angkay hiyachi way ommanongoh yag nampàila agé ah Jesus hen anchichay hemporo ya ihay pasorotna hen chacha manganan. Yag enamolichana chicha te anchag songsongellan way achi mangafurot hen henaphapet hen anchichay nangila an hiya hen anchi annaat nan-uchiyan. ");
INSERT INTO blw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yachi yag annaat ifaga an chicha way mangaliyén, “Éméy-ayu hen aminay lota ta inyu epagngar hen egachay katagutagu hen anchi ammayay chamag mepanggép an haén. ");
INSERT INTO blw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yag heno way omafurot ya anat mafunyagan wat mètagu an Apudyus ah ing-inggana. Ngém heno way achi mangafurot wat etap-ar Apudyus hiya hen anchi machusaana ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yag hen anchichay tot-oway omafurot wat midchat an chicha hen kafaelancha way mangamma hen kaskascha-aw, te gapon kafaelà, makeparyawcha hen nihurug way ongtan ya mafalin agé man-ale ah safaliy ale. ");
INSERT INTO blw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ya uray agé égnanancha hen farakkan ono inumuncha hen gamot wat ammag maid ekatna an chicha. Yag no ichàépcha hen limacha hen anchichay chan saket wat maka-an agé hen saketcha.” ");
INSERT INTO blw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Angkay hiyachi way narpas hen anchi imfagan Jesus an chicha, ammag cha matarok way éméy ad uchu, yag i tummùchu hen anchi pachawanan Apudyus. ");
INSERT INTO blw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yag hen anchichay pasorotna, émméycha agé hen kafabréfabréy way i mangintudtuchu hen anchi ammayay chamag. Yag mawawà-acha agé ah Apo Jesus way cha manorong an chicha way chana agé idchat hen kafaelancha way mangamma hen kaskascha-aw ah manot-owaan hen tatagu hen kenatot-owan hen chacha itudtuchu.");
INSERT INTO blw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Antoyan hen sorat-o an hea Apo Teofilo. Chuarcha hen tatagu way namachas way nangensorat hen anchichay aminay nekaman hen antoy iggawtaaw. ");
INSERT INTO blw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yag hen anchi ensoratcha wat hen anchichay nahaphapet an chàni way henaphapet hen anchichay nangi-ila paat way chicha, innilacha hen anchichay nekaman nanepod hen anchi laprapona yag anchaat epagngar. ");
INSERT INTO blw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wat yaha, Apo Teofilo, gapo ta inyam-ammà paat way nangachar amin hen anchichay na-ammaan nanepod hen ninlugiyancha ingganad uwan, ekat-owén ammay ménat no haén hen mangensorat an cha nadchi an hea ta mafafatéy hen ma-ale. ");
INSERT INTO blw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yato hen ekaman-o ta ma-awa-awatam hen katot-owan hen anchichay nitudtuchu an hea. ");
INSERT INTO blw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hen anchi lugrugina, yachi hen tempon hen ka-aren Herod ad Judea. Yag wacha agéhchi hen ihay pachi way ah Zacarias hen ngachanna way hiyan ihay ganà hen anchi pachi way ah Abias hen ngachanna. Ya ah ahawana agé, ah Elisabet hen ngachanna way hiyan ihay ganà Aaron way ap-apon chi pachi. ");
INSERT INTO blw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chicha way hen-ahawa, ammaycha an Apudyus te totongparéncha amin hen orchinna ya hen tugunna wat maid mepafasorancha. ");
INSERT INTO blw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngém maid anàcha te lopat ah Elisabet yag loohcha narakay way térén way hen-ahawa. ");
INSERT INTO blw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Angkay hen-argawan yag wachah Zacarias ah Templo te inumchah hen tempon hen mangammaana hen a-amman hen pachi. ");
INSERT INTO blw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yag hen gangaycha way pachi, chachan funfunnot ta maila no heno hen mangamma hen ma-ammaan. Yag ah Zacarias hen namunot way éméy hen anchi kowarton Apudyus way i manginyapoy hen anchi fangfangru. ");
INSERT INTO blw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Angkay hiyachi way hinénggép ah Zacarias ah Templo yag wachacha agé hen chuaray tataguh chara way chan luwaru hen hiyachiy uras way manginyapoyana hen anchi fangfangru. ");
INSERT INTO blw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Yag hen chana manginyapoyan, ammag niyahad an hiya hen ihay anghel Apudyus yag tommàchég ah pachawanan hen anchi chacha mempatpatngan hen anchi chacha manginyapoyan hen anchi fangfangru. ");
INSERT INTO blw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wat ammag naégyay ah Zacarias hen nangil-ana yag émmégyat. ");
INSERT INTO blw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yachi yag nan-ale hen anchi anghel way mangaliyén, “Achia cha émégyat, Zacarias, te chengngar Apudyus hen chawatyu wat mafugi angkay ah ahawam wat wacha hen iyanàna way larae, wat ngadnanyu hiya ah Juan. ");
INSERT INTO blw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","An-ayug lomaylayad gapon hiya ya lomaylayadcha agé hen chuaray tatagu. ");
INSERT INTO blw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wat ah Apudyus, ifilangna hiya ah nangato way tagu. Ngém masapor achi umin-inum hiyah fayah ya uray heno way fumutang. Yag manepod hen miyana-ana, machachà-an hen mamangchénan hen Espiritun Apudyus hen hamhamàna. ");
INSERT INTO blw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yag gapon hiyaat mepahagong hen hamhamà hen chuar way kacharaana way ganà Israel an Apudyus ta omapocha an hiya. ");
INSERT INTO blw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ya hen anchi iyanàyu agé, hiya hen anchi mamangpango no hen anchi nepoposta way Cristu way hen ekamanna, kaman hen anchi profeta way Elias ad namenghan way pachong agé hen kafaelana. Te mantempoyuguna hen hamhamà hen himfafaryan, ya manggédngéna agé hen hamhamà hen anchichay achi omafurot ta komaman hen hamhamàcha hen anchichay ammayay tatagu. Yachi hen mangensaganaana hen anchichay tatagu ah mangngarancha hen anchi ap-apocha no umale.” Yaha hen imfagan hen anchi anghel an Zacarias. ");
INSERT INTO blw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yachi yag anat ekat Zacarias hen anchi anghelén, “Oo a, ngém ay nanggilah mafalinha, te narakay-ani met way térén way hen-ahawa, wat nokay hen manot-owaà nò.” ");
INSERT INTO blw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yachi yag sommongfat hen anchi anghel way mangaliyén, “Haén ah Gabriel way nì-i-iggaw hen sangwanan Apudyus, way hiya hen namaar an haén way i mangimfaga hen antoy karaylayad way chamag an hea. ");
INSERT INTO blw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ngém gapo ta achim afuroton hen enalè, an-ag mattongong way achi maka-ale ingganah ma-ammaan hen antoy imfagà, te tot-oway umchah way umchah hen anchi ustoy tempona wat ma-ammaan chillu.” ");
INSERT INTO blw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Angkay hen anchichay tatagu ah chara, anchag nahédchan hen gumhachan Zacarias, yag chacha anapén no pakay ammag nafayag ah faréy. ");
INSERT INTO blw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Angkay na-awni way ginumhad ah Zacarias, anat agég achin ale te ammag nattongong, wat na-awatan hen tatagu way wachan empàilan Apudyus an hiya ah Templo. Yag gapo ta achi maka-ale, annag cha sinyaran chicha. ");
INSERT INTO blw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Angkay narpas hen anchi fiyang Zacarias ah Templo, hommàyat ah fabréycha. ");
INSERT INTO blw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yag yachi agé way cha-an mafayag, nafugi tot-owa ah ahawana way Elisabet, wat iggay gumgumhad ah chara hen unig hen lemay furan. ");
INSERT INTO blw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yag ekatnéén, “Inumchah tot-owa hen nanorongan paat Apudyus an haén, wat naka-an hen fiin-o hen ahentagù te antoyan hen narmu way anào.” ");
INSERT INTO blw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Angkay hen anchi maénémay furan hen nafugiyan Elisabet, kasen hennag Apudyus hen anchi anghel way ah Gabriel ta éméy ad Nazaret way ihay fabréy hen provinsiyan hen Galilea, ");
INSERT INTO blw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","te wachan ina ifaga hen ihay fafarasang ahchi way hen fafarasanganchi, netotorag way mangahawa an Jose way ganà Are David. Ah Maria hen ngachanna. ");
INSERT INTO blw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yachi yag émméy hen anchi anghel an Maria way mangaliyén, “Antoyanà way ummale way mangimfaga way nabindisyunan-a paat te wacha ah Apudyus an hea.” ");
INSERT INTO blw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yag ammag nahaang ah Maria hen nangngaranan nadchi, yag chana anapén no heno hen laychénay aryén. ");
INSERT INTO blw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yag anat ekat hen anchi anghelén, “Achia cha émégyat Maria, te enlaychancha-a an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wat hen ifagà an hea, mafugia wat iyanàno hen larae way ngadnanyu ah Jesus. ");
INSERT INTO blw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ammag nangato way térén hen annay iyanàno ya awagan hen tatagu hiya ah anà hen kangatowanay Apudyus ya epatawid Apudyus an hiya hen kena-aren David way apona ad namenghan. ");
INSERT INTO blw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wat hiya hen man-aren hen amin anchichay Judio way ganà Jacob ah ing-inggana way ammag maid péppég hen kena-arena.” Yachi hen imfagan hen anchi anghel an Maria. ");
INSERT INTO blw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yag anat ekat Maria hen anchi anghelén, “Oo a, ngém nokay hen énnê way mafugi way ammag poros met chi nanchà an haén.” ");
INSERT INTO blw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yag ekat hen anchi anghelén, “Umale hen Espiritun Apudyus an hea, ya umchah hen kafaelana way ancha-ag lichuman yag nafugia. Yag gapo ta hiyachi hen mekaman, wat ma-ammuwan way na-apudyusan hen anchi iyanàno, yag ma-awagan ah anà paat Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Entoroy hen anchi anghel agé way mangaliyén, “Ya ah agim way Elisabet way ekatchéén lopat, wat nafugi agé hen antoy narakayana, wat énémay furan ad uwan hen anchi finugina way larae. ");
INSERT INTO blw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wat yachin kail-ana way ammag maid achi mafalin an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yachi yag anat ekat Mariéén, “Haén, wat anà lawa an alepan Apudyus, wat ma-ammaan amin hen annay enalem an haén.” Yachi yag lommayaw hen anchi anghel. ");
INSERT INTO blw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Angkay narhawan yag nansagana ah Maria way lumigwat way mane-ed way éméy ah fabréy cha Zacarias way ini-inggaw hen anchi pafinilig hen provinsiyan hen Judea. ");
INSERT INTO blw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yachi way inumchah ah faréy cha Zacarias, nan-ale ah Maria an Elisabet. ");
INSERT INTO blw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yag hen nangngaran Elisabet hen alena, ammag namfalihhochong hen finugina. Yag empahmà hen Espiritun Apudyus an Elisabet, ");
INSERT INTO blw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","yag chinakarna way mangaliyén, “Hea hen anchi térén way nabindisyunan hen aminay fufae, ya nabibindisyunan paat agé hen anchi iyanàno. ");
INSERT INTO blw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Wat pakay paat enlaychanà ta umalea way mamisita an haén, hea way man-inan hen Ap-apò. ");
INSERT INTO blw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Te hen nangngarà hen alemat ammag namfalihhochong hen finugì ah laylayadna. ");
INSERT INTO blw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kapeletan laylayad-a te enafurotno way tomot-owa amin hen anchi imfagan Apudyus an hea.” ");
INSERT INTO blw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yachi yag ekat Mariéén, “An-og chayawén ah Apotaaw way Apudyus, ");
INSERT INTO blw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ya anà agég laylayad gapon hiya way nangenharà an haén, ");
INSERT INTO blw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ya inna paat hemhemmà haén way nafafa way alepanna. Wat manepod ad uwan, ekat amin hen tataguwén, enlaychanà ");
INSERT INTO blw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","gapo hen anchi kahahaang way enammaan hen anchi mannakafalin way Apudyus an haén. Ammag ka-ammayan tot-owa ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ya chana ség-angan hen amin way tatagu way cha manginyafiin an hiya way manepod hen anchi pés-éy tatagu inggana hen amin anchichay chan paréparég way miyanà. ");
INSERT INTO blw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Empàilana hen kafaelana way mangamma hen ammaana yag kenorkorna hen planon hen anchichay chan pahih-iya. ");
INSERT INTO blw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Annag empafafa hen anchichay nan-angato way toray yag anna agég empangato hen anchichay nafafa. ");
INSERT INTO blw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ya hen anchichay cha mamfaga ah torong, chuar hen inidchatna an chicha way ammay. Waman hen anchichay nanapnek ah kaenammaycha, emparyawna chicha way maid inidchatna. ");
INSERT INTO blw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yag enammaana hen anchi empopostana hen anchichay anap-otaaw ad namenghan ya totollongana chitaaw way ganà Israel. ");
INSERT INTO blw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Iggayna tot-owa aliw-an ah Abraham ya chitaaw way ganàna te séség-angana chitaaw ah ing-inggana.” Yachi hen enalen Maria hen nanayawana an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Angkay hiyachi yag nì-iggaw ah Maria an cha Elisabet ah unig hen toroy furan yag anat lomayaw. ");
INSERT INTO blw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Angkay hiyachi way inumchah hen umana-an Elisabet, inyanàna tot-owa hen larae. ");
INSERT INTO blw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wat amin hen anchichay atògongna ya hen totorangna, anchag laylayad amin hen nangngarancha hen anchi chakar way ség-ang Apudyus an hiya. ");
INSERT INTO blw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Angkay hen anchi ma-awaru way ag-agaw hen anchi utteng, incha empasinyar ah manongparancha hen orchin way yachi agé hen manngadnancha. Ya ah gagangaycha agé, ammay no an manZacarias te yachi hen ngachan amana. ");
INSERT INTO blw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ngém ammag ommachi ah inana way mangaliyén, “Faénha hen engachantaaw ta ah Juan hen manngachanna.” ");
INSERT INTO blw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Oo a,” way ekat hen anchichay tatagu, “ngém maid met nangenngachan ah Juan an chàyu.” ");
INSERT INTO blw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yag anchaat sinyaran ah amana way mangimoh no heno hen laychéna way epangachan hen anchi onga. ");
INSERT INTO blw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yag anat isinyar Zacarias hen papel yag ensoratna way hen manngachannaat ah Juan. Yag anchag nascha-aw hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yag hen hiyachi, naka-anat hen tenongong Zacarias yag nan-aleyat way manayaw an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wat anchag nascha-aw amin hen anchichay atògongna. Yachi yag nanhemamag hen anchi nekaman hen amin hen hiyachiy lugar ad Judea. ");
INSERT INTO blw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yag amin hen anchichay nangngar, chacha ham-éham-én no heno ngata hen mamfalinan nahha way onga te narawag way wacha tot-owa hen kafaelan Apudyus an hiya. ");
INSERT INTO blw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Angkay hiyachi, ah Zacarias way aman hen anchi onga, na-adchan ah Espiritun Apudyus yag annaat aryén hen empaka-ammun Apudyus, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Antaaw yanggay ammag chayawén ah Apudyus way Apotaaw, chitaaw way ganà Israel, te ummale way manorong an chitaaw way tataguna ya manobfot an chitaaw. ");
INSERT INTO blw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Te ensasagganana hen anchi mannakafael way mangenharà an chitaaw way hiyan ganà hen anchi omma-abfurot way Are David. ");
INSERT INTO blw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yag empaka-ammun agé hen anchichay na-apudyusan way profetana ad namenghan hen empostan Apudyus, ");
INSERT INTO blw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ekatnéén hara-ana chitaaw hen anchichay kafusortaaw ya anat agé hen kafaelan hen anchichay achi manlayad an chitaaw. ");
INSERT INTO blw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yag hen empostan Apudyus agé, ekatnéén séség-angana chitaaw nanepod hen anchichay anap-otaaw ad namenghan, ya achina agé aliw-an hen anchi entotoragna an chicha. ");
INSERT INTO blw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yag nansapata ah Apudyus way nangemposta hen empostana an apotaaw way Abraham ");
INSERT INTO blw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","way hen empostana, hara-ana chitaaw amin hen kafusortaaw ta wachay én-énnéntaaw way mangamma hen laychéna way achitaaw cha émég-égyat way mangamma. ");
INSERT INTO blw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ya ta ma-apudyusantaaw hen antoy matatagguwantaaw way achi agé ma-ahrangan ah laweng hen chataaw ekamkaman.” ");
INSERT INTO blw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Entoroy Zacarias way mangale agéén, “Ya heay anào, ma-awagan-a ah ihay profetan hen anchi kangatowan way Apudyus. Ya hea hen mamangpango no hen anchi apotaaw ta esaganam hen tatagu hen umaliyana. ");
INSERT INTO blw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wat hea hen mangimfaga hen anchichay tataguna way mafalin mètagucha an Apudyus ah ing-inggana no mapakawan hen fasorcha. ");
INSERT INTO blw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Te ah Apotaaw way Apudyus, ammag menangség-ang ya na-anoh way térén, ya hen anchi mangenhara-ana an chitaaw, wat kaman yanggay hen cha fùnagan hen init hen karpasan hen lafi. ");
INSERT INTO blw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Te no umale, helawan chitaaw way ininggaw hen helang way cha émégyat way matéy, ya tudtuchuwana chitaaw agé hen ekamantaaw way mètempoyug an Apudyus.” Yachi hen empahpahmà hen Espiritun Apudyus an Zacarias. ");
INSERT INTO blw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Angkay hiyachi yag hommeéheén hen anchi anà cha Zacarias ya chummuar hen hamhamàna an Apudyus. Yag ammag ini-inggaw hen anchi chanak way iggay fùfùnag ingganah inumchah hen anchi tempon hen manginlugiyana way manudtuchu hen anchichay ganà Israel. ");
INSERT INTO blw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Angkay hen hiyachiy tempo, inyurchin hen anchi Are ad Roma way Augusto way masapor mampalestacha amin hen egachay tatagu hen yachiy lota way chana etorayan. ");
INSERT INTO blw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yag ah Kirenio hen gubérnador ad Siria hen anchi pés-éy mepalestaan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wat hen nekaman, émméycha amin hen tatagu anchi fabréy way nangingganà an chicha way i mempalesta hen ngachancha. ");
INSERT INTO blw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Wat ah Jose, gapo ta hiya hen ihay ganà Are David ad namenghan, wat ad Betlehem hen ayana. Wat lummigwat ad Nazaret way fabréycha way sakopon hen provinsiyan hen Galilea yag nane-ed way émméy hen anchi fabréy apona way David ad Betlehem way provinsiyan hen Judea. ");
INSERT INTO blw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yag nàyéy agé ah Maria way netorag way man-ahawana way nafufugi ta i mampalesta agé. ");
INSERT INTO blw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Angkay hen kawad-ancha ad Betlehem, yachi hen netongpowan hen umana-ana, ");
INSERT INTO blw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","wat inyanàna hen féhég chi anàna way larae. Yag finunnafunana ah uroh yag empabfégna hen cha manganan hen animar te maid iggawancha hen anchi faréy way chachag-ohan. ");
INSERT INTO blw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hen hiyachiy lafi, wachacha agé hen anchichay chan pastor hen anchi nehahag-énay péchag way anchag lommabrafi way minya-achug hen karnerocha. ");
INSERT INTO blw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yachi yag ammag niyahad hen ihay anghel Apudyus an chicha, wat nachilangancha ah ka-ammay Apudyus yag anchag émmégyat way térén. ");
INSERT INTO blw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","“Achiayu cha émégyat,” way ekat anchi anghel, “te ummaliyà way mangempagngar an chàyu hen ammag ammayay chamag way mangemparaylayad hen aminay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Te hen hiyato paat way lafi, wacha hen niyanà ah fabréy Are David way mangenharà an chàyu, way hiya hen anchi Ap-apo way Cristu way empopostan Apudyus way epalena way mantoray. ");
INSERT INTO blw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yag hen manot-owaanyu, ichahanyu hen anchi onga way nafunnafunan ah uroh way nepapabfég hen cha manganan hen animar.” ");
INSERT INTO blw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hiyachi yag ammag napnowat ad uchu ah chuaray anghel yag chachaat amin chayawén ah Apudyus way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ta machachayaw ah Apudyus ad uchu ya hen antoy lota, ta matornoscha hen tatagu way mangemparaylayad an hiya.” ");
INSERT INTO blw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angkay hiyachi way lommayaw hen anchichay anghel way namfangad ad uchu, nantatagépfar hen anchichay chan pastor way mangaliyén, “Intaaw ad Betlehem ta intaaw ilan hen anchi na-ammaan way empagngar Apotaaw way Apudyus an chitaaw.” ");
INSERT INTO blw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wat enag-aggagcha way émméy yag inchahancha cha Maria an Jose ya hen anchi utteng way empapabfégcha hen anchi cha mangmanganan hen animar. ");
INSERT INTO blw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Angkay innilacha hen anchi utteng, henaphapetcha amin hen imfagan hen anchi anghel mepanggép an hiya. ");
INSERT INTO blw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yag anchag nahaang amin hen anchichay nangngar hen henaphapet hen anchichay chan pastor. ");
INSERT INTO blw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ngém ah Maria, annag inliméd ah hamhamàna hen aminay nekamkaman way cha manmamanmà. ");
INSERT INTO blw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yachi yag namfangadcha hen anchichay chan pastor way chacha chayachayawén ah Apudyus gapo hen anchi innilacha ya chengngarcha, te na-ammaan tot-owa amin hen imfagan hen anchi anghel an chicha. ");
INSERT INTO blw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Angkay hen anchi ma-awaru way ag-agaw way inumchah hen tempon hen masinyaran hen anchi utteng, yag ngenadnancha agé hiya ah Jesus way yachi chillu hen imfafaggan hen anchi anghel hen cha-anna marmuwan. ");
INSERT INTO blw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Angkay hiyachi way inumchah hen ag-agaw way ekat hen orchin Mosesén wachan ma-ammaan ah macharosan hen anchichay umanà, lummigwat cha Maria an Jose way éméy ad Jerusalem. Yag inyéycha agé hen anchi onga ta icha agé eparang hiya an Apudyus, ");
INSERT INTO blw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","te nesosorat chillu hen orchin way amin way pés-éy chi anà way larae, wat masapor midchat an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wat cha Maria an Jose, incha inchaton an Apudyus hen ekat hen anchi orchin way masapor gébhéncha hen chuway karopate no faén chuway ginapachay tuggu. ");
INSERT INTO blw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hen hiyachi yag wacha agé ahchid Jerusalem hen ihay makorang way ah Simeon hen ngachanna. Ammayay tagu ah Simeon ya amchan hen layadna an Apudyus, ya hiya agé hen ihay mamannéd hen kahara-an hen anchichay kacharaana way ganà Israel. Wawà-acha hen Espiritun Apudyus an hiya ");
INSERT INTO blw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","way nangempaka-awat way achi matéy ingganah ilana hen anchi Cristu way empopostan Apudyus way umale. ");
INSERT INTO blw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Hen hiyachiy tempo, empahpahmà hen Espiritun Apudyus an Simeon way éméy ah Templo. Yag hen hiyachi agéy ag-agaw, yachi hen nanginyéyan hen chinàcha-ar Jesus an hiya ah Templo agé way mangamma hen niyurchin mepanggép hen anat niyanà. ");
INSERT INTO blw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yachi way innilan Simeon hen anchi onga, yag annaat fénhén yag nanyaman an Apudyus way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apo way Apudyus, uray eparufusno ad uwan hen atéyà way alepanno te ammay hen atéyà te na-ammaan tot-owa hen anchi empostam an haén. ");
INSERT INTO blw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Te innilan paat hen matà hen antoy mangenharà hen tatagu hen kachusaancha ");
INSERT INTO blw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","way ensaganam para hen aminay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yato pe-et hen anchi manelaw hen hamhamà hen anchichay safaliy tatagu way faén ganà Israel, way hiya hen mangintudtuchu an chicha hen laychém. Yag hiya agé hen mangempachayaw an chàni way tatagum way ganà Israel.” ");
INSERT INTO blw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yachi yag anchag nahahaang hen chinàcha-ar Jesus hen nangngarancha hen enalen Simeon mepanggép an Jesus. ");
INSERT INTO blw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yag anat bindisyunan Simeon chicha yag ekatna an Maria way inanéén, “Hen antoy anàno, chinuchuttokan Apudyus hiya, wat gapon hiya, chuarcha an chitaaw way ganà Israel hen machachael ya metap-ar ya chuar agé hen mahara-an. Wat hiya hen sinyar Apudyus way ammag kontaréén hen chuaray tatagu ");
INSERT INTO blw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","way yachi agé hen mepàil-an hen anchi netataro way lawengay hamhamàcha. Ya heay inana, ammag mapàgang way térén hen hamhamàno gapo hen ma-ammaan an hiya.” Yaha hen imfagan Simeon. ");
INSERT INTO blw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wacha agéhchi hen ihay profeta way mad-an way narakay way térén way ah Ana hen ngachanna way anà Fanuel way ganà Aser. An yanggay pituy tawén hen nan-a-ahhaw-ancha ");
INSERT INTO blw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","yag natéy ah ahawana, yag émméy ah warunporo ya opat hen tawénna. An agég achi lomaylayaw ah Ana hen anchi Templo te enag-agaw ya lenafi way chana chayachayawén ah Apudyus way chan luwaluwaru way magénén achi mangan no hen-argawan. ");
INSERT INTO blw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hen hiyachiy uras, inchahan agé Ana cha Jesus wat kaskasen hen nanyamanana an Apudyus. Yag nanepod hen hiyachi, henaphapetna mepanggép an Jesus hen amin anchichay tatagu way mamannéd hen anchi mangenharà an chicha way ganà Israel. ");
INSERT INTO blw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Angkay hiyachi way lempas cha Jose an Maria hen aminay ekat hen orchin Apudyus, namfangadcha ah fabréycha ad Nazaret way provinsiyan hen Galilea. ");
INSERT INTO blw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yag hommeéheén hen anchi onga ahchi way cha pomegsapegsa hen acharna ya cha chumuachuar hen hamhamàna, yag enlaychan paat Apudyus hiya. ");
INSERT INTO blw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tenawén way cha émé-éméy hen chinàcha-ar Jesus ad Jerusalem way i mèlagsak hen anchi lagsak way ekatchéén Manmanma-an ah manmanma-ancha hen anchi nanlawhan hen anghel hen ganà Israel way mamchit. ");
INSERT INTO blw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yachi way hemporo ya chuway tawén Jesus, nàyéy way i mèlagsak te yachi chillu hen chacha amma-ammaan ah tenawén. ");
INSERT INTO blw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Angkay narpas hen anchi lagsak, inligwatcha way mamfangad ad Nazaret, ngém hen anchi onga way ah Jesus, nantaynan ad Jerusalem. Ngém hen chinàcha-arna, achicha ammu way nantaynan ");
INSERT INTO blw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","te hen ekatchaat an netnod ah Jesus hen anchichay tapena. Wat enar-argawcha way nanaran yag anchaat imohon hiya hen anchichay atògongcha ya totorangcha way narpohchi. ");
INSERT INTO blw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ngém ammag maid inchahancha. Wat anchaat mamfangad ad Jerusalem way icha taratéén. ");
INSERT INTO blw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yag hen ma-atloy ag-agaw, inchahancha hen anchi onga ah Templo way nìtutùchu hen anchichay anap-apo way cha mangintudtuchu mepanggép an Apudyus way hiya, anna peet cha changrén hen chacha aryén ya anna agé cha im-imohon hen tapena. ");
INSERT INTO blw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yag nascha-awcha amin hen anchichay nìya-among ah kenaraengna agé way somongfat hen aminay imohoncha an hiya. ");
INSERT INTO blw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yag anchag nahaang hen chinàcha-arna hen nangil-ancha an hiya, yag anat ekat inanéén, “Anào, pakay yato hen enammaan an chàni. Te an-anig nachanagan way térén an amam way cha manganap an hea.” ");
INSERT INTO blw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Oo,” way ekat Jesus, “ngém pakay masapor anapénà, te no maichà kapeletan way wachaà ahtoh faréy Ama.” ");
INSERT INTO blw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yaha hen enalen hen anchi onga way Jesus ngém iggaycha ma-awatan hen laychénay aryén. ");
INSERT INTO blw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Angkay hiyachi yag nìfangad ah Jesus hen chinàcha-arna ah fabréycha ad Nazaret yag enafurotna amin hen laychéncha. Yag ah inana, annag inliméd way cha manmamanmà hen amin anchichay cha mekamakaman. ");
INSERT INTO blw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ya ah Jesus, cha homeéheén way cha chumuachuar agé hen hamhamàna. Ya cha omam-améd hen layad hen tatagu an hiya, ya umat agé hen layad Apudyus an hiya. ");
INSERT INTO blw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Angkay hiyachi way émmé-émméy hen tawén yag nan-are ah Tiberio ad Roma way ma-ahemporo ya lemay tawén hen nan-areyana. Ya hen gubérnador ad Judea hen hiyachi, wat ah Poncio Pilato way eRoma, ya ah Herod way ihay Judio hen nantoray ad Galilea, ya ah Felipe way sonodna hen nantoray ad Iturea ya ad Traconite. Ya ah Lisanias way Judio agé hen nantoray ad Abilene. ");
INSERT INTO blw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ya hen anchichay kangatowan way pachi hen hiyachiy tempo, wat cha Anas an Caifas. Angkay hiyachi, wacha hen imfagan Apudyus an Juan way anà Zacarias way ini-inggaw hen anchi chanak, ");
INSERT INTO blw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","yag yachi hen nanginlugiyana way mantudtuchu. Wat émméy hen aminay sakopon hen anchi wangwang way Jordan way cha mangimfaga hen tatagu way mangaliyén, “Masapor ifafawiyu ya manchùganyu hen anchi laweng way a-ammayu, ya mampafunyag-ayu ah mangempàil-anyu way nanchùganyu tot-owa, wat pakawanén Apudyus chàyu.” ");
INSERT INTO blw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yaha hen intudtuchuna te yaha chillu hen imfagan hen anchi profeta way Isaias ad namenghan hen nangensoratana way ekatnéén, “Wacha hen anchi ini-inggaw hen anchi chanak way mangèngaw hen anchichay tatagu way mangaliyén, ‘Naway hen Ap-apo wat iyam-ammayu hen hamhamàyu ya manggadngényu hen ekamanyu, kaman hen anchi manginyam-ammaan hen charan non an umat yag naway hen Are. ");
INSERT INTO blw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hen ammaanyu, kaman afafényu amin hen tappo, ya tòyapanyu amin hen tagéytéy ya filig ta mantanapcha. Manggadngényu hen anchichay nanteko way charan ya iyam-ammayu hen anchichay na-ag-agitortor, ");
INSERT INTO blw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ta aminay katagutagu hen antoy lotaat ilancha amin hen anchi homarà way marpon Apudyus.’ ” Yachi hen ensorat Isaias mepanggép hen ammaan Juan. ");
INSERT INTO blw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Angkay hiyachi, anchag chuar hen anchichay tatagu way émméy an Juan way mampafunyag. Yag ah nangenlasinana hen hamhamàcha, ekatnéén, “Pakay chàyu way ammag nan-asilib, ay ammoh ekatyuwén anggay hen mampafunyaganyu yag ilisiyanyu hen chusan Apudyus way tég-angay mepachah. ");
INSERT INTO blw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Achi, te masapor angkay atofunyu paat hen a-ammayu ah mangempàil-anyu way nanchùganyu tot-owa hen chayu fumasoran. Yag achiyu agé ekatén gapo ta ganà chàyu an Abraham wat achi chàyu chuséén an Apudyus, te hen ifagà an chàyu, uray hen antochay fato wat mamfalinén Apudyus ah ganà Abraham no laychéna. ");
INSERT INTO blw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yag hen miyaligan hen manusaan Apudyus hen tatagu, wat kaman hen na-a-awid way potaw way aminay away way achi mamunga ah ammayay funga, annag longhon yag enapoyana.” ");
INSERT INTO blw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yachi yag senarudsud hen anchichay tatagu an Juan way mangaliyén, “Wat nokay hen ammaanni nò.” ");
INSERT INTO blw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yag imfagana way mangaliyén, “Hen anchi tagu way chuwa hen lumfongna, idchatna hen iha hen anchi maid lumfongna. Ya umat agé hen anchi wachay anéna, umidchat agé hen anchi maid anéna.” ");
INSERT INTO blw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yachi yag wachacha agé hen émméy an Juan way i mampafunyag way chicha hen anchi cha mangam-among ah furor, yag ekatchéén, “Apo, chàni kaỳ, nokay agé hen ammaanni nò.” ");
INSERT INTO blw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yag ekatnéén, “Achiyu ammag cha sorokan way mangamong hen ustoy furor hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ya hen anchichay tapen hen sorchachu way i mampafunyag, ekatchéén, “Chàni kay agé, nokay hen ammaanni agé nò.” Yag ekat Juan an chichéén, “Achiyu ammag cha ilémrém hen tatagu ah maid katot-owana, ya achiyu agé ilémrém chicha ah mangar-anyu ah laylaychényu, ta nongham hen labfuyu yag napnek-ayu.” ");
INSERT INTO blw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Angkay hiyachi, gapo ta hahahadchén hen anchichay tatagu hen umaliyan hen anchi empopostan Apudyus way umale way mantoray, chacha ekat ah hamhamàchéén, “Ay hiyato ngata hen anchi hahadchéntaaw way Cristu.” ");
INSERT INTO blw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ngém senongfatan Juan chicha way mangaliyén, “Haén, chanum yanggay hen ifunyag-o an chàyu, ngém wacha hen meparég an haén way nangatngato way térén no haén way uray lawa anta man-alepan an hiyéén achì karébféngan. Te hiya, ifunyagna an chàyu hen Espiritun Apudyus ya hen apoy. ");
INSERT INTO blw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yag no umale, henhenéna hen anchichay ammay way tatagu hen anchichay laweng way kaman hen anchi mantéép way manenhen hen anchi nafégahan hen anchi maid fégahna. Yag hen anchi nafégahan, tarpénéna ah arangna. Waman hen anchi maid fégahna, etongona hen anchi apoy way ammag achi madmachép.” ");
INSERT INTO blw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Maid achi enkaman Juan way nangintudtuchu hen anchi ammayay chamag mepanggép an Apudyus hen tatagu ah mangafurotancha koma. ");
INSERT INTO blw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yag anna agég enamhew ah Gubérnador Herod gapon namréhana an Herodias way ahawan hen sonodna ya gapo agé hen anchichay tapenay enammaana way laweng. ");
INSERT INTO blw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yachi yag ammag henéphép Herod hen fasorna te annaat agég imfarud ah Juan. ");
INSERT INTO blw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Angkay hiyachi way nafunyagancha amin hen anchichay tatagu yag nafunyagan agé ah Jesus. Yag hen chana manluwaruwan, ammag namfuat ad uchu ");
INSERT INTO blw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","yag inémhép hen Espiritun Apudyus an hiya way kaman karopate. Yag wacha agé hen nan-ale ad uchu way mangaliyén, “Hea hen anchi laylaychê paat way anào ya hea hen cha mangemparaylayad an haén.” ");
INSERT INTO blw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Hen nanginlugiyan Jesus way mantudtuchu, nantoronporo hen tawénna. Ya ah hamhamà hen tatagu, anchag ekatén hiya ano hen anà Jose. Ya ah Jose, hiyan anà Eli ");
INSERT INTO blw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","way anà Matat. Ya ah Matat, hiyan anà Levi. Ya ah Levi, hiyan anà Melki way anà agé Jane way hiya agé hen anà Jose. ");
INSERT INTO blw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ya ah Jose, hiyan anà Matatias way anà Amos. Ya ah Amos, hiyan anà Nahum way anà Esli way hiya agé hen anà Nage. ");
INSERT INTO blw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ah Nage, hiyan anà Maat way anà Matatias. Ya ah Matatias, hiyan anà Semei way anà Jose ya ah Jose, hiyan anà Juda. ");
INSERT INTO blw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ya ah Juda, hiyan anà Joana way anà Resa. Ya ah Resa, hiyan anà Zorobabel way anà Sealtiel way hiya agé hen anà Neri. ");
INSERT INTO blw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ya ah Neri, hiyan anà Melki way anà Addi. Ya ah Addi, hiyan anà Cosam way anà Elmodam way hiya agé hen anà Er. ");
INSERT INTO blw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ya ah Er, hiyan anà Josue way anà Eliezer way anà agé Jorim. Ya ah Jorim, hiyan anà Matat way anà Levi. ");
INSERT INTO blw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ah Levi, hiyan anà Simeon way anà Juda ya ah Juda, hiya agé hen anà Jose. Ya ah Jose, hiyan anà Jonan way anà Eliakim. ");
INSERT INTO blw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ah Eliakim, hiyan anà Melea way anà Mena way hiya agé hen anà Matata. Ya ah Matata, hiyan anà Natan way anà David. ");
INSERT INTO blw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ya ah David, hiyan anà Jesse way anà Obed. Ya ah Obed, hiyan anà Boaz way anà Salmon way hiya agé hen anà Naason. ");
INSERT INTO blw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ah Naason, hiyan anà Aminadab way anà Admin way anà Arni. Ya ah Arni, hiyan anà Esrom way hiyan anà Fares way hiya agé hen anà Juda. ");
INSERT INTO blw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ah Juda, hiyan anà Jacob way anà Isaac ya ah Isaac, hiyan anà Abraham. Ya ah Abraham, hiyan anà Tare way anà Nacor. ");
INSERT INTO blw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ah Nacor, hiyan anà Serug way anà Ragau way hiya agé hen anà Peleg. Ya ah Peleg, hiyan anà Heber way anà Sara. ");
INSERT INTO blw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ah Sara, hiyan anà Cainan way anà Arfaxad way hiya agé hen anà Sem. Ya ah Sem, hiyan anà Noe way anà Lamec. ");
INSERT INTO blw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ah Lamec, hiyan anà Metusela way hiyan anà Enoc way hiya agé hen anà Jared. Ya ah Jared, hiyan anà Mahalaleel way anà Cainan. ");
INSERT INTO blw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ya ah Cainan, hiyan anà Enos way anà Set. Ya ah Set, hiya agé hen anà Adam way anà Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Angkay hiyachi way nafunyagan ah Jesus, lommayaw hen anchi wangwang ad Jordan way ammag iné-égnanan hen Espiritun Apudyus hen hamhamàna. Yachi yag enetnod hen Espiritu hiya hen anchi lugar way maid fummabréy ");
INSERT INTO blw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","yag hen unig hen opatporo way ag-agaw, cha pachapachasén Chumunyu way mangawis an hiya. Wat iggay mangmangan ah Jesus hen ini-inggawana ahchi. Angkay ommanongoh yag ammag amchan hen henaangna. ");
INSERT INTO blw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yachi yag anat ekat hen anchi ap-apon hen ongtan way Chumunyu an Jesusén, “No hea tot-owa hen anà paat Apudyus, wat mamfaliném hen antochay fato ah aném.” ");
INSERT INTO blw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ngém senongfatan Jesus way mangaliyén, “Nesosorat hen alen Apudyus way ekatnéén, ‘Achi ummat hen ma-an ah iyatagun hen tatagu.’ ” ");
INSERT INTO blw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Angkay hiyachi yag anat ete-ed Chumunyu ah Jesus hen anchi akayyang way filig yag yachi way iggay nahen-emad, empàilanaat an hiya hen egachay toray hen katagutagu hen antoy lota, ");
INSERT INTO blw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","yag annaat ekatén, “Mafalin man-ap-apowê hea hen annachay aminay tatagu ya idchat-o agé an hea hen kenafaknangcha, te ilamat, lébféng-o way mangidchat an cha nahha hen heno way laychê te looh ninidchat chillu an haén. ");
INSERT INTO blw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wat ayé, ta man-awam amin cha nahha no annowat an chayawén haén.” ");
INSERT INTO blw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ngém senongfatan Jesus way mangaliyén, “Hen nesosorat way alen Apudyus, ekatnéén, ‘Ammag maid chillu kasen chayawényu no faén yanggay ah Apudyus way Apoyu, ya hiya yanggay agé hen afurotonyu.’ ” ");
INSERT INTO blw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yachi yag anat iyéy Chumunyu ah Jesus ad Jerusalem yag empatùchuna hen anchi tabfongan hen Templo yag annaat ekatén, “No hea tot-owa hen anà Apudyus wat mampêchag-a, ");
INSERT INTO blw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","te nesosorat hen alen Apudyus way ekatnéén, ‘Ifagan Apudyus hen anchichay a-anghelna ta ayuwanan cha-a,’ ");
INSERT INTO blw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","yag ekatna agéén, ‘Ancha-ag hèmatén way uray hen he-emén achi mepetag hen fato.’ ” ");
INSERT INTO blw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ngém senongfatan Jesus way mangaliyén, “Oo a, ngém ekat agé hen alen Apudyusén, ‘Achiyu cha padpachasén hen kafaelan Apudyus way Apoyu.’ ” ");
INSERT INTO blw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Angkay hiyachi way maid achi empachas Chumunyu way mangawis an Jesus, yag ammag lommayaw way i agé nanhééd ah kasen tempona. ");
INSERT INTO blw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Angkay hiyachi way namfangad ah Jesus hen provinsiyan hen Galilea, ammag nawawà-acha hen kafaelan hen Espiritun Apudyus an hiya. Ya nanhemamag hen chamag mepanggép an hiya hen amin hen yachiy lugar. ");
INSERT INTO blw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yag chan tudtuchu hen anchichay sinagoga way cha ma-am-amongan hen Judio, wat aminay tatagu, chacha chayawén hiya. ");
INSERT INTO blw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Angkay hiyachi, émméy ah Jesus ad Nazaret way yachin fabréy way chummakrana, yag hen anchi ngilin way Safachu, i nìyamong hen anchi chacha ma-am-amongan way Judio te yachi chillu hen gagangaycha. Yag tommàchég ah Jesus way mamasa hen alen Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wat inidchatcha an hiya hen anchi libnu way ensorat profetay Isaias yag annaat fùyagén way manganap hen anchi fasééna yag annaat ifasa way ekatnéén, ");
INSERT INTO blw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wà-acha hen Espiritun Apudyus an haén te penelena haén way i mangimfaga hen anchi ammayay chamag hen anchichay tatagu way maid mafalinna. Hennagà way i mangempagngar hen anchichay kaman nifafarud way mahara-ancha, ya hen anchichay kaman nabfurag way maka-an hen finuragcha, ya hen anchichay nèmehan agé, wat matàchégancha. ");
INSERT INTO blw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yag hen ifagà agé, inumchah hen tempon hen manorongan Apudyus hen tataguna.” ");
INSERT INTO blw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Narpaschi way finasan Jesus yag inumfana hen anchi libnu yag imfangadna hen anchi nangidchat an hiya yag anat tumùchu way ammag finéfétég amin hen tatagu hiya. ");
INSERT INTO blw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yachi yag annaat ekat an chicha way mangaliyén, “Hen yahay enalen Apudyus ad namenghan way an-owat finasa, cha angkay tomot-owa ad uwananto hen antoy nangngaranyu.” ");
INSERT INTO blw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yag amin hen anchichay tatagu way nangngar, enafunancha hen kenaham-an Jesus yag nahaangcha agé hen kena-ammay hen anchi enalena. “Oo a,” way chacha ekat, “ngém ay ammoh faénto hen anchi anà Jose tà.” ");
INSERT INTO blw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yachi yag anat ekat Jesus an chichéén, “Oo a, kapeletan way aryényu hen anchi ma-aleyu mepanggép an haén way no choktorà, agahà unna hen achar-o ta an-owat agahan hen tapena. Yag ifagayu agé ta ammaà ahtoh fabréy-o hen kaskascha-aw way kaman hen anchichay chengngaryu way enammaà ad Capernaum. ");
INSERT INTO blw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tot-owa hen antoy ifagà an chàyu way achi tot-owa mangiggéén hen kailiyan hen profeta hiya. ");
INSERT INTO blw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Wat chàyu, an-ayug kaman hen anchichay anap-otaaw ad namenghan hen kawad Elias. Te iggay umud-uchan ahtod Israel hen unig hen toroy tawén ya kagudwa, wat anchag nabtel amin hen tatagu hen antoy lota. Wat kapeletan chuarcha hen anchichay ka-as-ase way nà-amfaro hen hiyachiy tempo, ");
INSERT INTO blw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ngém faén chicha hen imfagan Apudyus way matorongan, te hennagna ah Elias hen safali way lota ta ina torongan hen anchi nà-amfaro way faén Judio ad Serepta way sakop hen Sidon. ");
INSERT INTO blw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ya hen iha, hen kawad-an hen anchi profeta way Eliseo agé, chuarcha hen Judio way nakkonet ahtod Israel, ngém maid naka-an ah saketcha, te naka-an yanggay hen saket hen anchi faén Judio way ah Naaman way iSiria.” ");
INSERT INTO blw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hen nangngaran hen anchichay tatagu hen anchi penanin Jesus, anchag ommaningarngar way térén te na-awatancha way chicha hen chana aryén. ");
INSERT INTO blw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wat hililigwatcha way i manlàéy an Jesus way mangenlayaw hen hiyachiy fabréy. Wat lenakrakcha hiya way manginyéy hen anchi napoayan hen chéprah way penget hen fabréy ta epég-ahcha koma. ");
INSERT INTO blw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngém ammag namfiliwit ah Jesus yag chaat lomaylayaw way nanwa-awà an chicha. ");
INSERT INTO blw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Angkay hiyachi yag nan-éhég ah Jesus way éméy ad Capernaum way fabréy hen provinsiyan hen Galilea. Yag hen anchi ngilin way Senafachu, hinénggép hen anchi chacha ma-am-amongan way i manudtuchu hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yag hen anchichay tatagu, nascha-awcha way nangngar hen enkamanna way mangintudtuchu te naelasin hen katot-owaan hen chana aryén. ");
INSERT INTO blw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yachi agé yag wacha an nadchi hen ihay am-ama way nahurugan ah ongtan. Yag ammag nan-ongaw way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aw, nokay hen ammaam an chàni, heay Jesus way eNazaret. Ay ummalea way i manachael an chàni. Te inni-ilà angkay hea way hea hen anchi na-apudyusan way empopostan Apudyus way umale.” ");
INSERT INTO blw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yag menancharat Jesus hiya way mangaliyén, “Iginangno man ta lomayaw-aat ta taynam hen annay nihurugam.” Yachi yag empa-adhar hen ongtan anchi am-ama way nempafàtad hen sangwanan hen tatagu, yag anat lomayaw way maid sinugatana. ");
INSERT INTO blw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wat anchag nahahaang amin hen anchichay nangila yag chachan ahetennopà way mangaliyén, “Nokay lawatoh chan tudtuchu way kafaelana amin, te tàén ongtanén menancharna way mangemparyaw yag lommayaw tot-owa.” ");
INSERT INTO blw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wat nanhemamag hen mepanggép an Jesus hen amin hen hiyachiy lugar. ");
INSERT INTO blw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Angkay hiyachi way lommayaw ah Jesus hen anchi chacha ma-am-amongan way Judio yag émméy ah faréy cha Simon way mamPedro. Yachi yag imfagacha way chan saket ah atogangan Simon way amchan hen pochotna. ");
INSERT INTO blw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wat i inughongan Jesus hiya hen anchi ébfégna yag imfagana way maka-an hen anchi pochotna, yag naka-an tot-owa. Wat fummangon yag hiyaat agé hen i nan-alekatto ah anéncha. ");
INSERT INTO blw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Angkay hiyachi way nalihnug hen init, aminay tatagu way wacha hen masaket an chicha way uray heno way saket, inyéycha amin an Jesus. Wat tenchàna amin chicha wat naka-an hen aminay saketcha. ");
INSERT INTO blw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yag emparyawna agé hen anchichay nihuhurug way ongtan hen chuaray tatagu, yag hen anchichay cha lomayawan hen anchichay nihuhurug, chacha èngaw way mangaliyén, “Hea hen anchi anà paat Apudyus.” Ngém menanchar Jesus chicha way mangempawa hen manginhugchayancha te chicha, inni-ilacha way hiya tot-owa hen Cristu way empopostan Apudyus way umale. ");
INSERT INTO blw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Angkay na-apeh, fummangon ah Jesus yag lommayaw ad Capernaum way i ommanig way émméy hen anchi lugar way maid tatagu. Yag na-awni, anchag chuar hen tatagu way i manganap an hiya. Yag hen nangchahancha, peneletcha way achi koma lomayaw ah fabréycha. ");
INSERT INTO blw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngém imfagan Jesus an chicha way mangaliyén, “Achiyà koma lomayaw ah fabréyyu, ngém masapor éméyà chillu hen anchichay tapenay fabréy agé way i mangempagngar hen anchi ammayay chamag mepanggép hen mantorayan Apudyus, te yachi chillu hen ganchat Apudyus way nannag an haén hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wat hiyachi, cha tarontonon Jesus hen anchichay cha ka-am-amongan hen tatagu hen hiyachiy provinsiyan hen Galilea way i mangintudtuchu hen chana itudtuchu. ");
INSERT INTO blw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Angkay hen-argawan, tommatàchég ah Jesus hen penget hen anchi fayfay way ekatchéén Genesaret way chana itudtuchu hen alen Apudyus, yag hen anchichay lonay way tatagu, chacha yémyémén hiya ah mangngarancha koma hen chana itudtuchu. ");
INSERT INTO blw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yachi yag innilan Jesus hen chuway fangka way nepapattàchang hen tarantag way ginugumhad hen anchichay nangimfangka te incha inurahan hen tafukorcha. ");
INSERT INTO blw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wat hinénggép ah Jesus hen anchi iha way awan Simon yag imfagana ta iturturchunna koma ah aket. Yag anat tumùchu way manudtuchu hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Angkay narpas hen nantudtuchuwana yag annaat ifaga an Simon way mangaliyén, “Epàpàéyyu hen antoy fangka hen anchi iggaw hen anchi ka-adcharéman hen chanum yag emporwakyu hen anchi tafukor wat wachay aranyu ah gachiw.” ");
INSERT INTO blw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Oo a, Apo,” way ekat Simon, “ngém enlabrafini met ad arubyan way nanafukor yag maid paat ennani ah ihà-an, ngém no hea hen mangale wat tàén yag emporwakni.” ");
INSERT INTO blw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wat emporwakcha yag ammag pommeltangat agé hen anchi tafukorcha wat ammag tég-angay magissay. ");
INSERT INTO blw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wat enayagancha hen ifacha way ininggaw hen anchi ihay fangka ta umalecha way tomorong way manlapchù. Yachi way tommorongcha yag ammag napno hen anchi chuway fangka way tég-angaycha lémnéd ah kachaghén hen anchichay gachiw. ");
INSERT INTO blw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yachi yag na-awatan Simon Pedro hen nekaman, yag anat ammag nampalentomang hen henagong Jesus way mangaliyén, “Apo, achia cha homag-én an haén te anà ammag menangfasor way tagu.” ");
INSERT INTO blw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Te cha Pedro ya hen anchichay ifana, anchag nahahaang amin ah kachuar hen anchichay gachiw way tenafukorancha. ");
INSERT INTO blw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yag umat agé hen anchichay ifana way cha Jaime an Juan way anà Zebedeo, nahahaangcha agé. Yachi yag ekat Jesus an Simonén, “Achia cha émégyat, Simon, te manepod ad uwan, falewà hen yahay chunum ta hen tatagu hen atenglém ah omafurotancha an haén.” ");
INSERT INTO blw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yachi way entàchangcha hen fangkacha yag anchag tenaynan hen angamin yag netnodchaat an Jesus. ");
INSERT INTO blw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Angkay hen-argawan, wachah Jesus hen ihay fabréy way kawad-an agé hen ihay tagu way nakkonet. Yag hen nangil-ana an Jesus, ammag nampalentomang hen henagongna way nampangpanga-ase way mangaliyén, “Apo, afurotò way wachan kafaelam way manga-an hen antoy saket-o no anno paat an ka-asiyan haén.” ");
INSERT INTO blw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yachi yag tenchà Jesus hiya way mangaliyén, “Oo, ka-asiyà hea ta maka-an hen annay saketno.” Yag hen hiyachi, ammag naka-anat tot-owa. ");
INSERT INTO blw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yag anat téngténgén Jesus hiya way mangaliyén, “Achim kay paat cha haphapeténto ah uray heno way tagu ta in-aat mampàila hen anchi pachi ta ilana way naka-an tot-owa hen annay saketno. Yag an-aat i manchaton hen anchi inyurchin Moses way michaton ah manot-owaan hen tatagu way naka-an tot-owa hen annay saketno.” ");
INSERT INTO blw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngém ammag kaskasenat hen niwarawagan hen chamag mepanggép an Jesus, wat chummùchùarcha hen anchichay cha ma-amoamong way i mangngar hen aryéna ya hen cha i mangempaka-an hen sasaketcha. ");
INSERT INTO blw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ngém hen aw-awniyanén émméy ah Jesus way i omanggay way manluwaru. ");
INSERT INTO blw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Angkay hen-argawan way chan tudtuchu ah Jesus, wachacha agé way nìtutùchu hen tapen anchichay siguchay cha mintudtuchu hen orchin ya anat hen anchichay na-achar way ekatchéén Fariseo way anchag nahibhib-at way narpod Jerusalem ya anat hen kafabréfabréy hen provinsiyan hen Galilea ya Judea. Ya hen hiyachi agé, wacha hen kafaelan Apudyus an Jesus way manga-an hen saket. ");
INSERT INTO blw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yachi yag inumchahcha hen anchichay nanginya-atang hen ihay tagu way napàroy hen acharna. Yag chacha pachasén way mangempaghép ta epasangocha koma an Jesus, ");
INSERT INTO blw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ngém ammag maid én-énnéncha te naposekcha hen tatagu. Wat incha tenòwap hen atép hen anchi faréy yag inuy-uycha hiya hen henagong Jesus way ginagawan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yag hen nangil-an Jesus way anchag nanchinlan amin hiya, imfagana hen anchi napàroy hen acharna way mangaliyén, “Heay sonod, napakawan hen fasorno.” ");
INSERT INTO blw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ngém hen anchichay Fariseo ya siguchay cha mintudtuchu hen orchin, ekatcha ah hamhamàchéén, “Heno ay paat hen katatagun nahha way annag cha pérhén hen kena-apudyus Apudyus, te ah Apudyus met yanggay hen mafalin way mamakawan ah fasor.” ");
INSERT INTO blw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yag yachi way enlasin Jesus hen anchi chacha hamham-én, yag annaat ekatén, “Pakay kaman ahnay hamhamàyu. ");
INSERT INTO blw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ay ammoh ekatyuwén narakraka hen maka-anan hen fasor no hen kaka-anan hen saket. ");
INSERT INTO blw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngém ta wachay manot-owaanyu way haén way Pangorowan hen Tatagu, wacha hen lébféng-o hen antoy lota way mamakawan hen fasor hen tatagu, wat ka-anê agé hen antoy saketna.” Yachi yag annaat ifaga hen anchi napàroy hen acharna way mangaliyén, “Hen ifagà an hea, fumangon-a yag inaram hen annay allakwangno yag ommanamot-a.” ");
INSERT INTO blw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yag hen hiyachi, ginsannaat way tommàchég hen sangwanancha amin yag innarana hen anchi allakwangna yag ommanamot way cha manayachayaw ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yag amin hen anchichay na-a-among way tatagu, anchag nahahaang way térén ya chachaat agé émégyat. Yag chacha agé chayawén ah Apudyus way mangaliyén, “Maid mempaniyan hen innilataaw ad uwananto way ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Angkay narpaschi way lommayaw ah Jesus yag innilana hen ihay cha mangam-among ah furor way tummutùchu ah opisinana way ah Levi hen ngachanna. Yag anat ifagan Jesus an hiya way mangaliyén, “Waynowat ta somorot-a an haén.” ");
INSERT INTO blw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yag ammag nallanigwat ah Levi way inyanggayana hen egad yag sommorot an Jesus. ");
INSERT INTO blw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yachi yag namparte cha Levi ah faréycha ah chakaray lagsak ah mangempàil-ana ah layadna an Jesus, yag nìyamongcha agé hen chuaray ifana way cha mangam-among hen furor ya hen anchichay tapenay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Angkay hiyachi, hen anchichay tapen hen Fariseo ya hen anchichay tapen hen ifacha way siguchay cha mintudtuchu hen orchin, chachan ngangayutongot way mangimfaga hen anchichay pasorot Jesus way mangaliyén, “Henon pa-ayu mèan hen annachay cha mangam-among ah furor ya hen annachay tapena way menangfasor.” ");
INSERT INTO blw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yachi yag senongfatan Jesus chicha ah pani way mangaliyén, “Hen anchichay tatagu way maid saketna, achicha masapor hen choktor. Waman hen anchichay chan saket, chichachi hen makasapor ah choktor ah ka-agahan hen saketcha. ");
INSERT INTO blw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yag hen miyaligana, haén, iggayà ummale hen antoy lota way manudtuchu hen anchichay ammay way tatagu te hen ummaliyà, ta iyà tudtuchuwan hen anchichay menangfasor ah mangentagayancha hen anchi lawengay a-ammacha.” ");
INSERT INTO blw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wachacha hen anchichay tapenay tatagu way émméy an Jesus way mangaliyén, “Pakay hen anchichay pasorotno wat achichan langan way mangan hen chachan luwaluwaruwan. Waman hen anchichay pasorot Juanat kankanayén way chachan langan ya umatcha agé hen anchichay pasorot hen Fariseo.” ");
INSERT INTO blw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yachi yag nampani ah Jesus way mangaliyén, “Ay ammoh achicha mangan hen anchichay tatagu way i mèkasar no wà-acha hen anchi komasar. Mamangngancha met. ");
INSERT INTO blw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ngém umchah chillu hen anchi tempo way melayaw hen anchi komasar, wat yachi hen manlanganancha way mangan.” ");
INSERT INTO blw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kasen nampani ah Jesus agé way mangaliyén, “Maid tagu ah ammag mangissay hen kà-amma way lumfong ta wachay id-opna hen anchi nagigissay. Te no yachi, ayyua hen anchi ammay yag achina agé chillu epaknég hen anchi nagigissay. ");
INSERT INTO blw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ya hen iha, maid agé mangimfongofong ah finénar hen anchi nausar way gadchang way amoto te achi met kasen matantan hen anchi nausar, wat ammag fumtà yag ayyua hen anchi finénar ya hen anchi gadchang agé. ");
INSERT INTO blw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Te hen finénar, masapor mifongofong yanggay hen anchi gadchang hen kappaparte way mafalin matantan. ");
INSERT INTO blw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ya hen anchi nangempaengha hen anchi chacha-an way fayah, achina agé laychén hen anchi kà-amma, te ekatnéén am-ammay ano hen anchi nafayag.” ");
INSERT INTO blw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Angkay hen-argawan way Safachu way ngilin chillu hen Judio, cha manaran cha Jesus hen ihay chacha murmur-an ah pagéycha way terigo, yag hen anchichay pasorotna, chacha umarah otteméncha. ");
INSERT INTO blw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yag anat ekat hen tapenay Fariseo an chichéén, “Pakay chayu labsengén hen anchi orchintaaw way Judio way mangempawa hen mamfat-an hen tempon hen ngilin.” ");
INSERT INTO blw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yag senongfatan Jesus way mangaliyén, “Ay ammoh iggayyu faséén hen enammaan Are David way apotaaw ad namenghan hen hommenaangana ya hen anchichay sorchachuna. ");
INSERT INTO blw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Anna met ammag hinggép hen anchi faréy Apudyus yag innarana hen anchi tenapay way nichachaton an Apudyus way anggay koma hen pachi ah mangan an nadchi, yag annag entàén yag enanna, yag enadchana agé hen anchichay ifana. Wat maid met ekattaawén fasornachi.” ");
INSERT INTO blw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yachi yag inyanongoh Jesus way mangaliyén, “Haén way Pangorowan hen Tatagu, haén hen nangimfiyang way mangimfaga hen ma-ammaan hen ngilin way Senafachu.” ");
INSERT INTO blw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Angkay kasen Safachu agé way ngilin chillu, hinénggép ah Jesus hen anchi chacha ma-am-amongan way Judio way i mantudtuchu. Yag niyaphor way wacha agéhchi hen ihay larae way nàis-is hen anchi awanay limana. ");
INSERT INTO blw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yag wachacha agé an nadchi hen tapen anchichay siguchay cha mintudtuchu hen orchin ya hen anchichay Fariseo agé way chacha amin iyanap hen ekamancha way mangempafasor an Jesus ta wachay lasoncha way manginchérém an hiya, wat chacha sepsepotan no tàén ngilin yag kena-anna hen anchi inis-is hen anchi taguwanchi. ");
INSERT INTO blw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ngém ah Jesus, inni-ilana hen hamhamàcha ngém ekatna chillu hen anchi nàis-isén, “Tomàchég-a yag ummaleahtoh sangwanà.” Wat émméy hen anchi tagu. ");
INSERT INTO blw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yag anat ekat Jesus hen anchichay mangi-ila an hiyéén, “Wacha hen sarudsuchù an chàyu no heno hen eparufus hen orchintaaw way ma-ammaan hen tempon hen ngilin. Ay ammaantaaw hen ammay ono hen laweng. Ay tomagutaaw ono antaaw pomchit.” ");
INSERT INTO blw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yachi way finéfétég Jesus chicha yag annaat ekat hen anchi nàis-isén, “Uyachém hen annay limam.” Yag inuyadna tot-owa yag ammag ommammayat agé. ");
INSERT INTO blw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wat hen anchichay Fariseo ya hen anchichay siguchay cha mintudtuchu hen orchin, anchag pommelang ah aningarngarcha an Jesus yag inlugicha way man-a-atopàpà no heno hen ekamancha an hiya. ");
INSERT INTO blw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Angkay hiyachi yag émméy ah Jesus hen ihay tagéytéy way lommabrafi way manluwaru an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Angkay pommaway, enayagana hen anchichay cha somorot an hiya yag annaat piliyén hen hemporo ya chuwa way ngenadnana ah aposel, ");
INSERT INTO blw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","way hen ngachancha, ah Simon way ngenadnana ah Pedro ya hen anchi sonodna way Andres ya anat cha Jaime an Juan, ah Felipe ya ah Bartolome, ");
INSERT INTO blw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ah Mateo, ah Tomas ya ah Jaime way anà Alfeo, ah Simon way ekatchéén natorod, ");
INSERT INTO blw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ah Judas way anà Jaime ya anat ah Judas Iscariote way nangenlao an Jesus hen na-awni. ");
INSERT INTO blw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Angkay hiyachi way nan-éhég cha Jesus ya hen anchichay penelena way aposel, yag entàchégcha hen anchi tanap way na-amongan hen anchichay chuar way cha somorot an hiya way narpocha ad Jerusalem ya hen provinsiyan hen Judea ya anat hen anchichay fabréy way ahag-én hen fayfay ad Tiro ya ad Sidon. ");
INSERT INTO blw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wat hen ganchatcha amin way ummale, ta incha changrén hen aryén Jesus ya incha epaka-an hen saketcha. Ya umat agé hen anchichay nahurugan ah ongtan, wat neparyaw hen anchichay nihuhurug an chicha. ");
INSERT INTO blw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yag amin hen anchichay tataguwén chacha esellasel hen acharcha way i manchà koma an Jesus te wachan kafaelana way uray anchag tad-énén naka-an hen saketcha. Wat naka-an amin hen sasaket hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Angkay hiyachi yag nanhagong ah Jesus hen anchichay pasorotna yag ekatna way mangintudtuchuwén, “Lomaylayad-ayu, chàyu way kaman maid mafalinna, te ma-awatanyu way maid kafaelanyu way mangamma hen ammayén Apudyus no achi chàyu torongan an hiya. Wat chàyu hen metape hen mantorayana. ");
INSERT INTO blw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Lomaylayad-ayu agé, chàyu way kaman chan henaang way mangamma hen laychén Apudyus te totollongan Apudyus chàyu way mangamma an cha nadchi ah kapnekanyu. Ya lomaylayad-ayu agé, chàyu way chan lulluruwa ad uwan gapon anchi laweng way cha mekaman te hêtan Apudyus hen luwayu ah laylayad ah pegwana. ");
INSERT INTO blw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","An-ayu yanggay ammag lomaylayad no agorgoran chàyu hen tatagu ya no achi chàyu ifilang ya no insortuwén chàyu agé ya uray no ekatchéén laweng-ayu, te no yaha hen ma-ammaan an chàyu gapon afurotyu an haén way Pangorowan hen Tatagu, ");
INSERT INTO blw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","wat an-ayug lomaylayad way uray pay an-ayug manalep ah layadyu te ammag chakar hen gunggunayu ad uchu. Yag hen anchichay chacha ekaman an chàyu, yachi chillu hen enkaman hen anchichay anap-ocha ad namenghan hen anchichay profetan Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngém chàyu way faknang ad uwan, an-ayug ka-as-ase te hen antoy lota ad uwan hen péppég hen manlamram-ayanyu. ");
INSERT INTO blw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ya ka-as-aseayu agé, chàyu way kaman mamabhug ad uwan, te gìnéényu hen amchan way henaangyu ah pegwana. Yag an-ayug ka-as-ase agé, chàyu way ammag layyalayyad ad uwan, te ah pegwanaat pahigényu hen kela ya tokar. ");
INSERT INTO blw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“An-ayu tot-owa ammag ka-as-ase no an chàyug chayawén hen aminay tatagu ad uwan, te hen anchichay cha manayaw an chàyu ad uwan, ganà hen anchichay nanayaw hen anchichay senang poprofeta ad namenghan.” ");
INSERT INTO blw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Entoroy Jesus way mangaliyén, “Hen ifagà an chàyu, masapor epàilayu hen layadyu, uray hen anchi gumura an chàyu. Ya ammaanyu agé hen ammay hen anchi achi manlayad an chàyu. ");
INSERT INTO blw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Masapor chawatényu hen torong Apudyus para hen anchi mangechot an chàyu, ya iluwaruwanyu hen anchichay mamaligat an chàyu. ");
INSERT INTO blw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","No tappeténcha hen apengyu, etayayu hen anchi chumangna. Yag no arancha hen ihay lumfongyu, iyuyayu agé hen anchi agwana. ");
INSERT INTO blw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Adchanyu hen anchi man-ochaw an chàyu, ya no wachay mamréh hen kok-owayu, achiyu cha ifaga way ifangadna. ");
INSERT INTO blw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hen laychényu way ma-ammaan koma an chàyu, yachi hen ammaanyu hen tapena.” ");
INSERT INTO blw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Non an umat yag chayu epàila hen layadyu hen anchichay manlayad yanggay an chàyu, ay ammoh magunggunaan-ayu. Te uray met hen anchichay lawengay tatagu, laychéncha agé hen anchichay manlayad an chicha. ");
INSERT INTO blw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ya no ammaanyu hen ammay hen anchichay cha mangamma yanggay hen ammay an chàyu, ay ammoh ekatyuwén magunggunaan-ayu. Te uray hen anchichay menangfasorén chacha met agé ammaan chaha. ");
INSERT INTO blw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yag no chayu pafuruchan yanggay hen anchichay sigurachuwényu way mangempafangad hen anchi chacha furuchun, maid angkay gunggunayu te uray hen anchichay menangfasor, wat chacha agé pafuruchan hen ifacha way menangfasor no sigurachu way mifangad amin an chicha. ");
INSERT INTO blw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ngém chàyu, masapor epàilayu hen layadyu hen anchichay achi manlayad an chàyu, ya ammaanyu hen ammay an chicha. Pafuruchanyu hen anchi fumurud an chàyu way uray maid namnama ah ifangadna. Te no yaha hen ekamanyu wat ammag chakar hen gunggunayu, wat an-ayu yanggay ammag mifilang ah anà hen anchi Kangatowan way Apudyus. Te ah Apudyus, ammaana hen ammay hen uray anchichay laweng way tatagu ya hen anchichay achi manyaman an hiya. ");
INSERT INTO blw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Masapor suméség-ang-ayu te menangség-ang ah Apudyus way amataaw.” ");
INSERT INTO blw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Achiyu cha uwisén hen karaweng hen tapena wat achi agé uwisén Apudyus hen karawengyu. Achiyu cha pafasoron hen tapena, wat achi chàyu pafasoron agé an Apudyus. Pakawanényu hen ahentaguyu wat pakawanén agé Apudyus chàyu. ");
INSERT INTO blw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Adchanyu hen tapena wat adchan chàyu an Apudyus agé way ammag chùchùar hen idchatna an chàyu no hen inidchatyu, te homawar way ingganah achiayu makachén. Te hen ekamanyu way mangidchat ah tapena, yachi hen ekaman agé Apudyus way mangidchat an chàyu.” ");
INSERT INTO blw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yag nampani ah Jesus an chicha way mangaliyén, “Achi mafalin way pachangén hen nabfurag hen ihay nabfurag te kapeletan way anchag mekobfang way chuwa. ");
INSERT INTO blw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ya maid agé matudtuchuwan ah nangatngato no hen anchi cha manudtuchu an hiya. Ngém no acharéna amin hen mitudtuchu an hiya, komaman hen anchi nanudtuchu an hiya.” ");
INSERT INTO blw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kasen nampani ah Jesus agé mepanggép hen mangarkorowan hen karaweng hen ifa, ekatnéén, “Pakay narawag hen mangil-anyu hen uray aginnà way finutan hen ifayu yag achiyuwat agé elasin way wacha hen liniéy way nampopoggar ah matayu. ");
INSERT INTO blw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wat an-ayug natorod way mangaliyén, ‘Ayé ta ka-anê hen annay aginnà way finutam yag wà-achaat peet hen liniéy ah matam.’ Paspasekatnoha te masapor ka-aném unna hen annay liniéy ah matam ta lomawag hen mangil-am way manga-an hen finutan hen ifam.” ");
INSERT INTO blw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kasen nampani ah Jesus way mangaliyén, “Hen anchi ammay way away, achi mamunga ah laweng ya hen anchi laweng way away, achi mamunga ah ammay. ");
INSERT INTO blw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Te hen fungan hen away, yachi hen mangimfaga hen kena-awayna. Te ay ammoh mafalin pogahém hen fungan hen sanggis hen tata. Ya ay ammoh pogahém hen fungan hen agit hen chawar. ");
INSERT INTO blw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hen miyaligana, hen anchi ammayay tagu, ammaana chillu hen ammay te yachi hen tenatarpénna ah hamhamàna. Waman hen anchi lawengay tagu, ammaana hen laweng te yachi agé hen tenatarpénna ah hamhamàna. Te kapeletan way hen tagu, aryéna hen anchi tenatarpénna ah hamhamàna.” ");
INSERT INTO blw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Entoroy Jesus way mangaliyén, “Pakay ekatyuwén haén hen ap-apoyu yag achiyu chillu ammaan hen chà ifaga. ");
INSERT INTO blw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Heno way somorot an haén ta changréna hen aryê yag enafurotna, yato hen miyaligana. ");
INSERT INTO blw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hiya hen kaman anchi tagu way i nansà-ad ah faréyna, yag finùana hen lota ingganah inchahana hen fato yag yachi hen nanà-achana. Wat yachi, uray chan churuchurun hen wangwang ya henènap hen chanum hen anchi faréy, ammag achi chillu manyuhyuhaw te ammag kénég hen tùchuna. ");
INSERT INTO blw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Waman hen anchi tagu way annag cha changchangrén hen aryê yag achina chillu afuroton, hiya hen kaman anchi tagu way i nanà-ad ah faréyna hen iggaw hen lapok. Yag angkay chummuar hen chanum way nahènap, ammag neorob wat ammag sayang hen anchi faréyanchi te permi hen nachachaelana.” ");
INSERT INTO blw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Angkay hiyachi way narpas hen nanudtuchuwan Jesus hen anchichay tatagu, émméy ad Capernaum. ");
INSERT INTO blw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yag wachahchi hen ihay faén Judio way kapetan hen sorchachun hen Roma way amchan hen saket hen ihay alepanna way laylaychéna way tég-angay matéy. ");
INSERT INTO blw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yag yachi way chengngarna way wacha ah Jesus, henomnag hen anchichay anam-ama way ponò hen Judio ta incha ayagan ah Jesus ta umale koma way manga-an hen saket hen anchi alepanna. ");
INSERT INTO blw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Angkay inchahancha ah Jesus, chachan pangpanga-ase paat way mangaliyén, “Ammayay tagu hen anchi kapetan ya karébféngana way matorongan ");
INSERT INTO blw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","te laylaychéna chitaaw way Judio. Ya ah kenamafalinna, empa-ammana hen ihay chataaw ka-am-amongan.” ");
INSERT INTO blw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Angkay hiyachi yag netnod ah Jesus an chicha. Yag hen tég-angaycha umchahan hen anchi faréy Kapetan, hinib-atcha hen kasenna hennag way incha ifaga hen enalena way ekatnéén, “Apo, achì koma taktakén hea te achì karébféngan way manmangili an hea, ");
INSERT INTO blw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ya achì agé karébféngan way mèsango an hea. Wat uray anno yanggay ammag iyale wat maka-an hen saket hen alepan-o. ");
INSERT INTO blw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Te haén, ma-awatà mepanggép hen lébféng, te haén way Kapetan, masapor afurotò hen aryén hen apò. Ya hen anchichay sorchachu way chà etorayan, afurotoncha agé hen aryê, te no ekat-owén in-a, wat éméy, yag no ekat-owén umalea, wat umale agé. Yag umat agé hen anchi alepan-o, no ekat-owén ammaamto, wat ammaana met. Wat kaskasen way masapor ma-ammaan hen aryém te wachan kafaelam.” ");
INSERT INTO blw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yachi yag ammag nahaang ah Jesus hen nangngaranan nadchi. Wat imfiliwitna hen anchichay chuar way tatagu way cha umunud an hiya way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way uray an chitaaw way Judiowén, maid inchahà ah afurot ah kaman an nahha.” ");
INSERT INTO blw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Angkay hiyachi yag hommàyat hen anchichay nahnag yag inchahancha hen anchi alepan Kapetan way naka-an tot-owa hen saketna. ");
INSERT INTO blw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Angkay na-awni hen hiyachiy ag-agaw, émméy cha Jesus ya hen anchichay pasorotna ad Nain yag nàyéycha agé hen chuar way tatagu. ");
INSERT INTO blw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yag hen anchi chacha umchahan hen fùnagan hen anchi fabréy, hinib-atcha hen chuar way nafufurug way tatagu way chacha iyéy hen natéy way nenetnod agé ah inana way faro. Fafaru hen anchi natéy way anggay agéchi ah anà inana wat naunghor. ");
INSERT INTO blw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naség-angan ah Jesus way nangila an inana yag annaat ekat an hiyéén, “Achia chan kela, Ina.” ");
INSERT INTO blw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yachi yag anat homag-én ah Jesus hen anchi lungun yag tenchàna yag entàchég hen anchichay nanginya-atang. Yag annaat ekatén, “Fafaru, hen ifagà an hea, fumangon-aat.” ");
INSERT INTO blw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yag hen hiyachi, ammag tummùchuwat agé hen anchi natéy yag inlugina way man-ale, yag emporang Jesus hiya an inana. ");
INSERT INTO blw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wat anchag émmégyat way térén hen anchichay tatagu way nangi-ila yag chinayawcha ah Apudyus way mangaliyén, “Fummùnag peet an chitaaw hen nangato way profeta, wat ummale peet tot-owa ah Apudyus way manorong hen tataguna.” ");
INSERT INTO blw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yag nanhemamag hen mepanggép an Jesus hen aminay fabréy hen sakopon nadchi ya hen anchichay tapenay fabréy agé. ");
INSERT INTO blw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Angkay hiyachi yag émméy hen anchichay pasorot Juan way chan funfunyag an hiya ah pagfaruchan way i manaphapet hen amin way mepanggép an Jesus. ");
INSERT INTO blw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yachi yag anat hénagén Juan hen chuwa an chicha way i mangimoh an Apo Jesus no hiya hen anchi empopostan Apudyus way umale ono manhéédcha chillu ah safali. ");
INSERT INTO blw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Angkay émméycha an Jesus, imfagacha way mangaliyén, “Hennag Juan way chan funfunyag chàni ta ini ifaga an hea no hea ano hen anchi chana aryén way umale ono hahadchénni chillu hen safali.” ");
INSERT INTO blw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yag hen hiyachi paat way tempo, kena-an Jesus hen nankarakarasey saket hen chuaray tatagu, yag emparyawna agé hen anchichay nihuhurug way ongtan, ya kena-anna agé hen finurag hen chuaray nabfurag. ");
INSERT INTO blw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yag annaat songfatan hen anchi chuway nahnag way mangaliyén, “Mamfangad-ayu an Juan yag haphapetényu hen aminay innilayu ya hen chengngaryu way chà enammaan way hen anchichay nabfuragén makailacha, ya hen anchichay nappelayén makacharancha, ya hen anchichay nakkonetén ommammay hen acharcha, ya hen anchichay nattorangén makagngarcha, ya uray hen natéyén nepauchicha, ya hen anchichay maid mafalinnéén cha mepagngar hen anchi ammayay chamag an chicha. ");
INSERT INTO blw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yag ifagayu an hiya agé way ammag lomaylayad hen anchi tagu way achi manchuwachuwa hen afurotna way haén hen anchi hennag Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Angkay hiyachi way lommayaw hen anchichay hennag Juan, inlugin Jesus way mangimfaga hen anchichay tatagu mepanggép an hiya, ekatnéén, “Hen anchi iyu nangil-an an Juan ah chanak, nokay hen ekatyuwén inyu ilan. Ay ammoh ekatyuwén hiya hen kaman gurun way maid achina manyongyongan no hapochén hen yawyaw. ");
INSERT INTO blw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","No faénchi, nokay hen payu i ilan nò. Te ay ammoh anyu an i innila no nanlurumfong ah am-ammayay lumfong. Iggay a, te hen anchichay am-ammay hen lumfongna way naram-ay hen ataguwancha, faén chanak hen iggawancha te ah faréy hen are. ");
INSERT INTO blw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wat nokay hen tot-oway ganchatyu way i nangila nò. Ay anyu i innila hen profetan Apudyus. Oo yachi, ya ah katot-owana, faén ammag profeta yanggay ah Juananchi, ");
INSERT INTO blw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","te hiya paat hen anchi tagu way ena-allen hen anchi nesosorat way alen Apudyus way ekatnéén, ‘Wacha hen ihay tagu way faarê way mamangpango no hea ta ina esasaggana hen anchichay tatagu ta changréncha-a.’ ” ");
INSERT INTO blw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yachi yag entoroy Jesus way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way maid kasen tagu ah niyanà hen antoy lota ah nangatngato no ah Juan. Ngém tàén hiyachi, nangatngato chillu hen anchi kafafaan way tagu way netape hen mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ammag laylayad hen anchichay kachùran way tatagu way nangngar hen imfagan Juan way uray agé hen anchichay cha mangam-among ah furor. Te chicha hen nangafun hen imfagan Apudyus wat nampafunyagcha an Juan. ");
INSERT INTO blw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Waman hen anchichay Fariseo ya siguchay cha mintudtuchu hen orchin Moses, anchag enachi hen laychén Apudyus an chicha wat iggaycha mampafunyag an Juan. ");
INSERT INTO blw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Entoroy Jesus agé way mangaliyén, “Nokay lawa hen mangempaniyà hen tatagu way cha matagu ad uwan way ammag maid ma-ara an chicha way nokay hen mepachongancha. ");
INSERT INTO blw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iyalig-o chicha ah kaman hen anchichay ammag ommachi way ungunga way chan ay-ayam ah fatawa. Hen tapena, imfagacha hen anchichay ifacha way mangaliyén, ‘Namattopattong-ani ah metapyanyu way manalep koma yag an-ayug achi. Wat emparégni way man-ib-ifil ah metapyanyu koma, yag an-ayu agég achi chillu.’ ");
INSERT INTO blw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hen laychénay aryén, ummale ah Juananchi way chan funfunyag way chan langarangan way mangan ya achina amin hemheman hen fayah yag chayu pelohon hiya way mangaliyén, nahurugan ah ongtan. ");
INSERT INTO blw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yag angkay ad uwan way ummaliyà way Pangorowan hen Tatagu way achi manlangrangan way mangan ya chaà amin mì-inum, yag ekatyuwat agéén anà ammag fukatot ya amfutangén, ya nì-i-ibfaà hen anchichay cha mangam-among ah furor ya hen anchichay tapenay menangfasor. ");
INSERT INTO blw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngém tàén yaha, te hen anchichay tatagu way cha omafurot an Apudyus, elasincha chillu hen kenaraeng Apudyus, te hen halenonot hen ekamanna, yachi hen mangimfaga hen kenaustona.” ");
INSERT INTO blw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Angkay hen-argawan, wacha hen ihay Fariseo way ah Simon hen ngachanna, yag enayagana ah Jesus way i mèan ah faréycha. Wat émméy ah Jesus yag hinénggép way i tumùchu way mangan. ");
INSERT INTO blw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yag wacha agé hen hiyachiy fabréy hen ihay in-ina way ammag pota hen anchi ar-argaw. Yag hen nangngarana way wachah Jesus ah faréy hen anchi Fariseo, lummigwat way entàtaenna hen pichuru way na-ammaan ah fato way ekatchéén alebastér way natatarwan ah ammag nangina way fangfangru. ");
INSERT INTO blw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yachi way hinénggép hen anchi fufae yag i tommàchég hen échég Jesus way chan kela ya cha tomedted hen luwana hen he-en Jesus, yag penonahana ah fuùna ya chaat omafaya hen he-ena ah layadna, yag annaat ihiyat hen anchi fangfangru hen he-ena. ");
INSERT INTO blw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ngém hen nangil-an hen anchi nangayag an Jesus hen cha mekaman, ekatna ah hamhamànéén, “Até, faén peet profeta ah Jesusanto te non an profeta komaat innilana koma hen kenatatagun hen annay fufaeyanna way cha manchà an hiya yag empawana.” ");
INSERT INTO blw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yachi yag senongfatan Jesus hen hamhamà hen anchi Fariseo way mangaliyén, “Simon, wacha hen ifagà an hea.” “Oo, nokaychi Apo,” way ekat hen anchi Fariseo. ");
INSERT INTO blw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yag nampani ah Jesus way mangaliyén, “Wachan ihay tagu way nan-utang hen chuway tatagu an hiya way lemanporo hen inutang hen iha ya lemanggasot hen inutang hen anchi iha. ");
INSERT INTO blw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yag gapo ta achicha makafayad way chuwa, ammag empasinsiyan hen anchi nampautang an chicha way uray achicha sokatan.” Yag anat ekat Jesusén, “Nokay an chicha way chuwa hen ekatnowén chakchakar hen layadna hen anchi nampautang nò.” ");
INSERT INTO blw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yag ekat Simonén, “Awniyat hen anchi chakchakar hen nepasinsiya an hiya.” “Oo,” way ekat Jesus, “yachi.” ");
INSERT INTO blw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yag anat manhagong ah Jesus hen anchi fufae yag ekatna an Simon chilluwén, “Yachi hen miyaligan hen antoy fufae, te ilam ngén, hen hinénggépà hen antoy faréyyu, maid empa-aram ah chanum ah mangurah-o hen he-è ah gagangaytaaw. Waman hiya, inyurahna hen luwana ah he-è yag emponahna hen fuùna. ");
INSERT INTO blw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yag hea, iggayno agé fàwarén haén hen hinénggépà. Waman hiya, ingganad uwan, é-éttégna way omma-abfaya hen he-è. ");
INSERT INTO blw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yag hea agé, iggayno amin lanéén hen urù way nigagangay an chitaaw. Waman hiya, lenanana hen he-è ah nangina way fangfangru. ");
INSERT INTO blw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wat hen ifagà an hea, hen anchi chakar way layad hen antoy fufaeyanto an haén, yachi hen manot-owaan way napakawan hen anchichay chuaray fasorna. Ngém hen anchi tagu way an yanggay aket hen napakawan way fasorna, aket agé hen epàilana way layadna an haén.” ");
INSERT INTO blw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yachi yag anat ekat Jesus hen anchi fufaeyén, “Wat naka-an tot-owa hen fasorno.” ");
INSERT INTO blw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ngém hen anchichay tapena way cha mèan, ekatcha ah hamhamàchéén, “Heno ay paat ah nahhay tagu way ammag mampachinar way mamakawan ah fasor.” ");
INSERT INTO blw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yag chaat ekat Jesus hen anchi fufaeyén, “Gapo ta manokchum haén wat naka-an tot-owa hen fasorno ah kahara-am wat mapanoh hen hamhamàno.” ");
INSERT INTO blw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Angkay hen-argawan yag kasen éméy ah Jesus ya hen anchichay hemporo ya chuway pasorotna ah kafabréfabréy way i mangintudtuchu hen anchi chamag mepanggép hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Yag netnod agé hen anchichay inin-ina way nangemparyawan Jesus hen ongtan ya nanga-anana hen sasaket. Ah Maria way eMagdalena hen iha way hiya hen anchi nangemparyawan Jesus hen pituy ongtan. ");
INSERT INTO blw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ya wacha agé ah Juana way ahawan Cusa way ah Cusaanchi, hiya hen anchi mamfafantay hen kok-owan Are Herod. Ya wacha agé ah Susana ya anat hen chuar way tapenay finufae way chacha amin torongan cha Jesus ah heno way kafalinancha. ");
INSERT INTO blw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Angkay hiyachi yag émméycha an Jesus hen ammag chuaray tatagu way narpo ah kafabréfabréy. Yag yachi way enamongancha hiya, nampani way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hen-argawan ano wacha hen ihay tagu way i nanmura hen anchi lotana. Yag hen anchi chana manwalehan hen fukar, nemamang hen tapena hen charan yag anchag nagategatenan yag enan hen kasole. ");
INSERT INTO blw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yag hen tapen hen anchi fukar way niwaleh, nemamangcha hen pafinatto. Manowat te hommangawcha ngém anchag nàrong te maid chanum. ");
INSERT INTO blw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yag hen tapena agé, nemamangcha hen anchi papenagat yag lenomtàcha. Ngém angkay lommafang hen anchi charoh way napagatan, anchag henyong hen anchi mura. ");
INSERT INTO blw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yag hen tapen anchi niwaleh, nemamangcha hen anchi ammayay lota yag tummufu wat penémhéd yag namunga ah chuar.” Narpaschi way enalen Jesus yag annaat ekatén, “Chengngaryu hen antoy penanì te naingaan-ayu, wat hamham-ényu koma hen laychénay aryén.” ");
INSERT INTO blw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Angkay hiyachi yag inimoh hen anchichay pasorot Jesus no heno hen laychén hen anchi penanina way aryén. ");
INSERT INTO blw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yag annaat ekatén, “Amin hen anchichay cha-an ma-ammuwan mepanggép hen mantorayan Apudyusat chàyu yanggay hen mepaka-ammuwana way achi mepaka-ammu hen tapena, te pani yanggay hen mifaga an chicha. Te uray féféttégéncha, anchag achi chillu emamad. Yag uray chachangréncha, achicha chillu pachasén way manganap ta ma-awatancha.” ");
INSERT INTO blw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Entoroy Jesus way mangaliyén, “Yato hen laychén hen anchi penanì way aryén. Hen miyaligan hen anchi fukar, yachi hen alen Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yag hen miyaligan hen anchi charan way nemamangan hen tapena, chichachi hen anchichay tatagu way chengngarcha hen alen Apudyus, ngém émméy ah Chumunyu way ina menaid amin hen anchi chengngarcha ta achicha afuroton hen kahara-ancha an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ya hen anchi pafinatto way nemamangan hen tapen hen fukar, chichachi hen anchichay tatagu way layyalayyadcha way nangafun hen alen Apudyus hen anchaat nangngaran. Ngém ammag achi inggaw ah hamhamàcha te an yanggay hen-aketan hen ommafurotancha, te no mapaligatancha, anchag iyanggayan. ");
INSERT INTO blw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yag hen miyaligan agé hen anchi papenagat way nemamangan hen tapena, chichachi hen anchichay tatagu way nangngar hen alen Apudyus ngém nahyong hen chengngarcha, te ammag gapoh pangégcha ah mataguwan hen antoy lota ya hen hamhamàcha ah mangar-ancha ah pelak ya hen manlamram-ayancha koma hen antoy ataguwan ad uwan, wat ammag achi fumgah an chicha hen anchi chengngarcha. ");
INSERT INTO blw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yag hen miyaligan agé hen anchi ammayay lota way nemamangan hen tapen anchi fukar, chichachi hen anchichay tatagu way nanangngar hen alen Apudyus yag empapatecha way mangafurot, te tàén chacha maligatan, ancha chillug inyahà-an hen hamhamàcha an Apudyus, wat finumgah hen alen Apudyus an chicha.” ");
INSERT INTO blw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kasen nampani ah Jesus way mangaliyén, “Maid tagu ah mamasgéd hen helaw yag annaat hàufan ono anna an igga hen selok hen kama, te anna an epatang hen ustoy mepatngana ta mahelawancha hen anchichay hénggép.” ");
INSERT INTO blw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ekat Jesus agéén, “Hamham-ényu ngén te amin way netataro ad uwan, umchah chillu hen meparangana. Ya umat agé hen aminay nalelengfan ad uwan, wat umchah chillu hen mepafùnagana. ");
INSERT INTO blw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wat papannaagényu paat way mamangngar hen aryê, te hen anchi tagu way mangamma hen chana changrén, mataptapyan hen ma-awatana. Waman hen anchi tagu way annag achi ammaan hen chengngarna, uray hen anchi aket way na-awatana wat ammag maonghor.” ");
INSERT INTO blw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Angkay hiyachi yag inumchah ah inan Jesus ya hen anchichay sosnodna, ngém achicha makahag-én an Jesus gapon anchichay chuaray tatagu. ");
INSERT INTO blw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wat wacha hen ihay nangimfaga an Jesus way mangaliyén, “Wacha cha inam ya hen sosnodno ah chara way chacha-a epa-ayag.” ");
INSERT INTO blw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yachi yag anat ekat Jesus an chicha aminén, “Hen anchichay tatagu way mamangngar hen alen Apudyus yag enammaancha, chichachi agé hen ifilang-o ah inà ya sosnod-o.” ");
INSERT INTO blw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Angkay hen-argawan, ekat Jesus hen anchichay pasorotnéén, “Intaaw ta intaaw hen chumang antoy fayfay.” Wat hinénggépcha hen anchi fangka yag lummigwatcha. ");
INSERT INTO blw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yag hen nanlurugganancha, nasséy ah Jesus. Angkay na-awni yag annag empàrat way fummali way ammag séréd. Wat cha mihibyat hen chanum yag cha map-ong hen anchi fangka wat ammag aggaégyat ah anchag malihéd. ");
INSERT INTO blw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yag i finangon hen anchichay pasorot Jesus hiya way mangaliyén, “Ayong Apo, antoy maofortaaw.” Yachi yag fummangon ah Jesus yag menancharna hen anchi fali ya hen chanum way cha makérékéréd, wat nafég-as hen anchi fali ya ammag ommalenanà hen anchi fayfay. ");
INSERT INTO blw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yag annaat ekat hen anchichay pasorotnéén, “Pakay chan finfinafang hen pammateyu way achiyu manokchun haén.” Ngém chicha, anchag nahahaang ya chacha agé émégyat wat nan-ahetennopàcha way mangaliyén, “Heno ay paatha ah tagu way uray hen fali ya chanumén enafurotcha hiya no mancharéna.” ");
INSERT INTO blw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Angkay hiyachi yag entoroy cha Jesus ya hen anchichay pasorotna way namfangka way éméy hen anchi sakopon hen Gerasa way ninidmang ad Galilea. ");
INSERT INTO blw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yag hen chacha tomàchangan, i nihib-atat an Jesus hen ihay larae way iGerasa way nahuhullugan ah ongtan way nafayag way ammag namfafallad ya ammag achi oman-anamot te ah palinufù yanggay hen i-inggawana. ");
INSERT INTO blw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Te hen anchi taguwanchi, namen-ano way cha um-umchah hen anchi ongtan an hiya, yag uray no faruchuncha way magénén kenakawwachancha hen limana ya hen he-ena, anna chillug cha géhténén empatagtag hen anchi ongtan hiya ah chanak. Yag hen nangil-ana an Jesus, ammag nan-ongaw yag nanlùfub hen henagongna ah égyatna way mangaliyén, “Heay Jesus way anà hen Kangatowan way Apudyus, nokay hen ammaam an haén. Pangpanga-asem paat ta achiyà koma chuséén.” Yaha hen enalena te menanchar Jesus hen anchi ongtan way lomayaw. ");
INSERT INTO blw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yachi yag anat hanhanan Jesus way mangaliyén, “Nokay hen ngachanno.” Yag sommongfat hen anchi nihuhurug way mangaliyén, “Ah Kachuaran hen ngachan-o.” Yaha hen imfagana te anchag chuar way nihuhurug. ");
INSERT INTO blw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yachi yag anchaat mampangpanga-ase ta achicha koma mepééy hen anchi fito way maid péppég hen ka-adcharémna ah machusaancha. ");
INSERT INTO blw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hen hiyachi, netongpo way wachacha hen chuaray fafuy way chan garab hen anchi nehahag-én way tagéytéy. Wat nampangpanga-ase hen anchichay ongtan ta icha koma mihurug lawa hen anchichay fafuy. Wat emparufus Jesus. ");
INSERT INTO blw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yachi yag lommayaw hen anchichay ongtan hen anchi tagu yag incha nihurug hen anchichay fafuy. Yag anchaat agég hetatagtag hen anchichay fafuy yag nichawangcha amin hen anchi chéprah yag omàfawcha hen fayfay wat anchag naofor amin. ");
INSERT INTO blw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Angkay hen anchichay nanginya-achug hen fafuy, hen nangil-ancha hen anchi nepasamak, anchag ommawid amin way hehahapet hen nekaman hen aminay chacha hib-atén hen charan ingganah fabréycha. ");
INSERT INTO blw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yachi yag émméy amin hen anchichay nangngar way i mangila hen anchi na-ammaan, yag hen inumchahancha an Jesus, inchahancha hen anchi tagu way lommayawan hen anchichay ongtan way ammag tummutùchu hen chapat Jesus way nanlurumfong ya ommammay hen hamhamàna. Yag anchaat agég émmégyat hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yachi yag anat kasen haphapetén hen anchichay ustoy nangi-ila hen aminay nekaman hen nemparyawana hen anchichay ongtan hen anchi tagu. ");
INSERT INTO blw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wat amin hen anchichay iGerasa, anchag chinawat ta lomayaw ah Jesus hen fabréycha te ammag amchan hen égyatcha. Wat hinénggép cha Jesus hen anchi fangka way lomayaw. ");
INSERT INTO blw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yag hen anchi tagu way lommayawan hen anchichay nihuhurug, chan pangpanga-ase ta màyéy koma. Ngém empawan Jesus way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uray yag homàyat-a ah fabréyyu ta im haphapetén hen tatagu amin hen enkaman Apudyus way nanorong an hea.” Hiyachi yag hommàyat tot-owa hen anchi tagu way ammag maid iggayna ayan hen anchi fabréyna way manaphapet amin hen enammaan Jesus an hiya. ");
INSERT INTO blw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Angkay hiyachi way namfangad cha Jesus hen anchi chumang hen fayfay, laylayadcha hen anchichay chuar way tatagu te nahédchancha an hiya. ");
INSERT INTO blw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yag hen hiyachi, inumchah agé hen ihay ap-apon hen anchi chacha ma-am-amongan way Judio way ah Jairo hen ngachanna. Yag i nampalentomang hen henagong Jesus way mampangpanga-ase ta éméy ah faréycha, ");
INSERT INTO blw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","te tég-angay matéy hen anchi ih-ihà-anay anàna way fufae way hemporo ya chuwa hen tawénna. Angkay hiyachi way lummigwatcha, ammag chuar agé hen anchichay tatagu way nàyéy wat chachan sensenettak. ");
INSERT INTO blw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yag hen iha an chicha, ihay in-ina way émméy ah hemporo ya chuway tawén hen chana chumar-achar-an, yag annag imfayad amin hen kok-owana hen kamanay choktor, ngém maid chillu nakafael way manga-an hen saketna. ");
INSERT INTO blw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yachi yag i nehnop hen échég Jesus way inna tenchà hen pongton hen lumfongna yag ginsanat hen charana way natchù. ");
INSERT INTO blw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Wat ekat Jesusén, “Henochi hen nanchà an haén.” Ngém ammag maid nangimfaga. Yag anat ekat Pedrowén, “Apo, hen kachuar hen tatagu, yachi hen chacha michillichilan an hea.” ");
INSERT INTO blw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngém ekat Jesusén, “Oo a, ngém wacha chillu hen iha way i nanginggagtà paat way nanchà an haén, te lenènà way nausar hen kafaelà.” ");
INSERT INTO blw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yachi yag na-awatan hen anchi in-ina way na-ammuwan peet hen anchi enammaana, wat i nampalentomang hen henagong Jesus way chan papayagpag ah égyatna. Yag uray chachangrén hen aminay tatagu, imfagana hen lasonna way nanchà an hiya ya hen naka-anan hen saketna. ");
INSERT INTO blw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yachi yag anat ekat Jesus an hiyéén, “Heay sonod, gapo ta annog nanokchun haén wat naka-an tot-owa hen saketno, wat ta mapanoh hen hamhamàno.” ");
INSERT INTO blw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Étég Jesus way chan ale yag inumchahat agé hen anchi i nangimfêang way narpoh faréy cha Jairo, yag imfagacha an Jairo way mangaliyén, “Uray achitaaw ud-ay haliw-én hen annay ap-apowanna te looh angkay narpas hen fiyag hen anchi onga.” ");
INSERT INTO blw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngém yachi way chengngar Jesuschi, ekatnan Jairowén, “Achia cha émégyat ta annog manokchun haén wat matagu chillu hen anchi anàno.” ");
INSERT INTO blw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","52","Angkay hiyachi way inumchahcha ah faréy hen anchi natéy, anchag an hi-i-ifil amin hen anchichay tatagu. Yag anat ekat Jesus an chichéén, “Anggay, achiayu ammag chan kelakela te cha-an angkay natéy hen annay ongaanna te an yanggay nanasséy.” Yachi yag hinénggép ah Jesus yag empawana hen mì-ighépan hen tatagu te anggay yanggay cha Pedro an Jaime yah Juan ya anat hen chinàcha-ar hen anchi natéy ah emparufusna way mì-ighép. ");
INSERT INTO blw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yag hen anchichay tatagu, anchag cha am-amrangén ah Jesus te innilacha way natéy tot-owa. ");
INSERT INTO blw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yachi way émméy ah Jesus hen anchi natéy yag inégnanana hen limana yag annaat ekatén, “Anà ta fumangon-a.” ");
INSERT INTO blw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wat ammag namfangachat hen fùfuohna yag fummangon, yag anat ifagan Jesus ta panganéncha. ");
INSERT INTO blw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yag anchag nahahaang way térén hen anchichay chinàcha-arna, ngém tenéngténg Jesus chicha ta achicha paat cha haphapetén hen nekaman. ");
INSERT INTO blw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Angkay hiyachi yag enayagan Jesus hen anchichay hemporo ya chuway pasorotna yag inidchatna an chicha hen kafaelancha way mangemparyaw hen nihuhurug way ongtan ya manga-an hen heno way saket hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yag annaat hénagén chicha ta icha itudtuchu hen mepanggép hen mantorayan Apudyus ya ta incha ka-anén hen saket hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yag intugunna an chicha way mangaliyén, “Achiayu chan tàtaen ah uray heno hen mamfiyahiyanyu. Achiayu chan pah-eng, achiayu chan hor-od, achiayu omentàtaen ah pelak ya uray anényu ya agwan hen lumfongyu. ");
INSERT INTO blw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yag no epaghép chàyu hen ihay faréy, epahigyu way i-inggaw hen hiyachiy faréy ingganah lomayawanyu hen hiyachiy fabréy. ");
INSERT INTO blw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yag mag-ay ta wachay fabréy ah achi mangempaghép an chàyu, an-ayug lomayaw yag penòpoanyu hen tapok hen he-eyu ah mangil-ancha way egadcha hen machusaancha.” ");
INSERT INTO blw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Angkay hiyachi yag lummigwatcha tot-owa yag émméycha ah kafabréfabréy way i nangintudtuchu hen anchi ammayay chamag ya cha i agé manga-an hen saket hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Angkay hiyachi, ah Herod way chan toray ad Galilea, chengngarna amin hen enammaan cha Jesus yag ammag nakorkor hen hamhamàna te hen ekat hen tapenay tatagu, nan-uchi ano ah Juan way chan funfunyag. ");
INSERT INTO blw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yag hen tapena, ekatcha agéén an namfangad peet hen anchi profeta way Elias. Yag wacha agé hen tapena way mangaliyén magat wachay kasen natagu way profeta ad namenamenghan. ");
INSERT INTO blw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ngém ah Herod, ekatnéén, “Empahiwat-o met ah Juan, wat heno ay paat ah nahhay tagu way chacha hapehapetén nò.” Yag chana iyana-anap hen ekamanna way mangila an Jesus. ");
INSERT INTO blw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Angkay hiyachi way namfangad hen anchichay aposel way hennag Jesus, henaphapetcha amin hen enammaancha. Yachi yag enayagan Jesus chicha ta icha koma omanggay ad Betsaida way i man-inungar. Wat lummigwatcha. ");
INSERT INTO blw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ngém chengngar chillu hen anchichay chuaray tatagun nadchi, wat anchaat umunud yag lenyad agé Jesus chicha chillu. Wat tinudtuchuwana chicha mepanggép hen mantorayan Apudyus, yag annaat agé ka-anén hen sasaket hen anchichay aminay cha masaket. ");
INSERT INTO blw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Angkay cha malihnug hen init, i imfagan hen anchichay pasorot Jesus an hiya way mangaliyén, “Ammay ménat no ifagam hen annachay chuaray tatagu ta incha man-ila ah anéncha ya umiyanancha hen anchichay nehag-én way fabréy te maid met ma-an ahto.” ");
INSERT INTO blw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngém ekat Jesus an chichéén, “Chàyu koma hen mamangan an chicha.” “Oo a,” way chacha ekat, “ngém maid met epanganni, te an yanggay lemay tenapay ya anat hen antoy chuway files hen wacha, yag ay ammoh in-ani lomao ah anén hen annachay ammag chuaray tatagu.” ");
INSERT INTO blw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Te hen filang hen anchichay larae yanggay way wachahchi wat émméy ah lemanlifu. Yachi yag anat ifagan Jesus hen anchichay pasorotna ta tumùchucha hen anchichay tatagu way matpomatpon ah henlelman poporo. ");
INSERT INTO blw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yag yachi way tummùchucha amin, ");
INSERT INTO blw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","innaran Jesus hen anchi lemay tenapay ya chuway files yag entangadna ad uchu way manyaman an Apudyus, yag annaat petpet-angén yag inidchatna hen anchichay pasorotna ta iwarascha hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wat nangancha amin hen anchichay chuaray tatagu, yag yachi way nagipohcha, enamong hen anchichay pasorot Jesus hen fay-ancha yag ammag napnowat agé hen hemporo ya chuway awit. ");
INSERT INTO blw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Angkay hen-argawan way ommanggay ah Jesus way chan luwaru, émméy hen anchichay pasorotna an hiya, yag ah Jesus, henanhanana an chicha way mangaliyén, “Nokayà ngata ah hamhamà hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yag ekatchéén, “Hen tapena, ekatchéén hea ano ah Juan way chan funfunyag way an nan-uchi. Ya hen tapena, ekatchéén hea hen anchi profeta way Elias way kasen ummale. Yag hen tapena agé, ekatchéén hea hen ihay profeta ad namenghan way kasen natagu.” ");
INSERT INTO blw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Ngém chàyu kaỳ,” way ekat Jesus, “nokay agé hen mangaleyu an haén nò.” Yachi yag tenomfar ah Pedro way mangaliyén, “Hea hen anchi Cristu way empopostan Apudyus way umale way mantoray.” ");
INSERT INTO blw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hiyachi yag tenéngténg Jesus chicha way mangempawa hen manaphapetancha an nadchi ah tapena. ");
INSERT INTO blw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Angkay hiyachi yag imfagan Jesus agé way mangaliyén, “Haén way Pangorowan hen Tatagu, masapor mapap-aligatanà way térén ya achiyà mangiggéén hen anchichay anam-ama way ponò ya hen anchichay anap-apon hen pachi ya umat agé hen anchichay siguchay cha mintudtuchu hen orchin Moses. Yag ana-at agé epapchit, ngém hen anchi ma-atloy ag-agaw, man-uchiyà chillu.” ");
INSERT INTO blw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yachi yag imfagan Jesus an chicha amin way mangaliyén, “Heno way tagu way manlayad way somorot an haén, masapor faén hen antoy ataguwana ad uwan hen epapangégna te masapor ammaana hen imfagà, tàén yachi hen iyatéyna. ");
INSERT INTO blw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te hen anchi tagu way annag epapangég hen ataguwana hen antoy lotaat matéy chillu. Waman hen anchi tagu way achina epangég hen matéyana gapon afurotna an haén, wat uray matéy, midchat chillu an hiya hen kasenna ataguwan way mannanayun. ");
INSERT INTO blw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Te nokay paat chillu hen sérfina no ammag kok-owéén hen ihay tagu hen uray aminay ininggaw hen antoy lota yag ah awni yag entap-ar chillu Apudyus hiya way ammag sayang amin. ");
INSERT INTO blw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yag heno agé way tagu way mafiinan way mangempàila hen layadna an haén ya hen chà itudtuchu, mafiinanà agé way mempàila hen layad-o an hiya no mamfangachà. Te haén way Pangorowan hen Tatagu, no mamfangachà, humiliyà ah kaenammay-o ya hen kaenammay Amay Apudyus, ya metape agé hen anchichay chana fabfaarén way anghel. ");
INSERT INTO blw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tot-owa hen antoy ifagà an chàyu way wachacha hen tapena an chàyuwanto ad uwan way ilancha hen mantorayan Apudyus yag anchaat matéy.” ");
INSERT INTO blw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Angkay émméy ménat ah ihay chuminggu nanepod hen nangaryan Jesus an nadchi yag enayagana cha Pedro an Juan yah Jaime yag émméycha ah filig way manluwaru. ");
INSERT INTO blw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yag hen cha manluwaruwan Jesus, ammag sommafali hen féharna yag pommokaw way térén hen lumfongna ingganah cha humili. ");
INSERT INTO blw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yag hen hiyachi, ammag niyahachat agé hen chuway larae way chicha cha Moses an Elias way apocha ad namenghan, yag chacha mètagépfar an Jesus ");
INSERT INTO blw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","way chacha agé humili amin. Yag hen chacha aryénat mepanggép hen anchi matéyan Jesus ad Jerusalem ah ma-ammaan hen aminay laychén Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ngém ah Pedro ya hen anchi chuway ifana, anchag nasséy te amchan hen héyépcha. Ngém angkay na-awni way fummangoncha, innilacha agé hen anchi cha humiliyan Jesus ya anat agé hen anchi chuway tatagu way nètatàchég an hiya. ");
INSERT INTO blw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yachi way cha lomayaw hen anchi chuwa, yag ekat Pedro an Jesus way mangaliyén, “Apo, ammay te wacha-anihto, wat ta omamma-ani ah toroy fawi ta màmàchang-ayu an cha Moses an Elias.” Yachin enalena te ammag maid pootona ah ustoy aryéna. ");
INSERT INTO blw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yag hen chanan aryan, anchaat agég nanépnépan ah funat yag chacha émégyat way térén hen nannafunafan hen anchi funat an chicha. ");
INSERT INTO blw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yachi yag wacha hen nan-ale way narpon anchi funat way ekatnéén, “Yaton anào way penepelè way mantoray wat changrényu paat hiya.” ");
INSERT INTO blw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yag yachi way narpas hen anchi nan-ale, yag ammag anggayat agé ah Jesus ah wà-acha. Wat hen anchichay pasorotna, anchag enetmég way maid nanaphapetancha mepanggép hen innilacha. ");
INSERT INTO blw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Angkay nawakas way nan-éhég ah Jesus ya hen anchi toroy ifana hen anchi filig, hinib-atat agé hen chuaray tatagu chicha. ");
INSERT INTO blw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yachi yag nan-ongaw hen ihay am-ama way niyahrang an chicha way mangaliyén, “Apo, pangpanga-asem paat ta ilam hen antoy fugtong way anào, ");
INSERT INTO blw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","te cha mahuh-urugan ah ongtan. Yag no umchah ayén, nan-ongaw ya ommadhar ya nantatarafutab hen tapàna, yag annag cha chunuchunoron hen acharna way ammag naligat hen lomayawana. ");
INSERT INTO blw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yag nampangpanga-asiyà hen annachay pasorotno ta eparyawcha koma ngém achicha kafaelan.” ");
INSERT INTO blw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yachi yag ekat Jesusén, “Chàyu way tatagu ad uwan, ammag pararo hen enomfatanyu, te pasag chi ah nì-i-iggawà an chàyu ya ngotoh anoh-o an chàyu yag ammag maid chillu pammateyu an haén.” Yachi yag ekat Jesus hen anchi am-améén, “Iyalem hen annay anànohto.” ");
INSERT INTO blw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ngém hen anchi chana minyaliyan, ammag entap-ar hen anchi ongtan hiya yag annaat epa-adhar. Wat menancharat Jesus hen anchi nihuhurug ta lomayaw yag ommammayat hen anchi onga, yag anat eparang Jesus hiya an amana. ");
INSERT INTO blw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wat amin hen anchichay tatagu, anchag nahahaang hen nangil-ancha hen anchi kafaelan Apudyus way maid mepaniyana. Angkay hiyachi way é-éttég hen anchichay tatagu way nahahaang gapon innilacha, yag cha agé ifagan Jesus hen anchichay pasorotna way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Achiyu cha aliw-an hen antoy ifagà an chàyu way haén way Pangorowan hen Tatagu, tég-angay umchah hen midchatà hen anchichay tatagu way mangamma an haén hen heno way laylaychéncha.” ");
INSERT INTO blw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ngém hen anchichay pasorotna, ammag maid pootoncha no heno hen laychénay aryén te iggaycha ma-awatan way térén, yag chacha agé émégyat way mananhan. ");
INSERT INTO blw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hen-argawan, nansosongelcha hen anchichay pasorot Jesus no heno hen nangatngato an chicha. ");
INSERT INTO blw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yag yachi way enlasin Jesus hen chacha hamham-én, enayagana hen ihay onga way i michapat an hiya, ");
INSERT INTO blw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yag annaat ekat an chichéén, “Ilanyu ngén hen antoy onga way kaman maid filangna. Ngém heno way tagu way gapon afurotna an haén yag chana chillu ifilang hen anchi kaman hen antoy onga, wat chana agé ifilang haén. Yag heno agéy mangimfilang an haén, wat chana agé ifilang hen anchi nannag an haén. Wat hen anchi kafafaan an chàyu, hiyaat agé angkay hen nangato.” ");
INSERT INTO blw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hiyachi yag ekat Juan an Jesusén, “Apo, innilani hen ihay tagu way chana eparyaw hen anchi nihuhurug way ongtan yag hea ano hen cha karpowan hen kafaelana, wat empawani te faén met iha an chitaaw.” ");
INSERT INTO blw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngém ekat Jesus an chicha aminén, “Achiyu cha epawa hen kaman an cha nadchi, te heno way achi mangontara an chitaaw wat ifataaw chillu.” ");
INSERT INTO blw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Angkay tég-angay hen tempon hen mamfangchan Jesus ad uchu, annag epapate way éméy ad Jerusalem, ");
INSERT INTO blw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","wat nanhénag ah mamangpango way i mangensagana hen ayana. Wat lummigwat hen anchichay nahnag yag émméycha hen ihay fabréy way provinsiyan hen Samaria ta icha saganéén hen tatagu ah umchahan Jesus. ");
INSERT INTO blw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngém hen anchichay tataguhchi, ancha ammag achi laychén way paghépén ah Jesus te narawag way ad Jerusalem hen ayana way fabréy hen Judio. ");
INSERT INTO blw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Angkay chengngar cha Jaime an Juan hen nekaman, ekatcha an Jesusén, “Apo, ay achitaaw ifaga an Apudyus ta annag epêchég hen apoy ta maghébcha amin.” ");
INSERT INTO blw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ngém nanhagong ah Jesus yag iningarna chicha. ");
INSERT INTO blw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yag anchaat éméy hen safaliy fabréy. ");
INSERT INTO blw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Angkay hiyachi way chacha manaran way éméy, wachan ihay tagu way nangale an Jesusén, “Apo, umu-unnuchà angkay an hea hen uray heno way ayam.” ");
INSERT INTO blw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yag senongfatan Jesus hiya way mangaliyén, “Hen motet, wacha hen orobna ah omanamotana, ya hen kasole, wacha agé hen hòfotna ah omanamotana. Ngém haén way Pangorowan hen Tatagu, maid angkay faréy-o ah omanamotà wat ay umunud-a chillu.” ");
INSERT INTO blw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yachi yag ekat Jesus hen ihay tagu agéén, “Somorot-a an haén.” Ngém ekat hen anchi taguwén, “Apo, awni ta iyà ilufù ah Ama unna ta ana-at somorot an hea.” ");
INSERT INTO blw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngém ekat Jesus an hiyéén, “Egadcha hen anchichay kaman nanattéy way maid afurotna ah i manginlufù hen anchi kapachongna way natéy. Waman hea, in-a ta im epagngar hen mepanggép hen mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yachi yag wacha agén iha way mangaliyén, “Apo, sorotò hea, ngém iyà koma mampakacha unna hen ahimfafaryan-o.” ");
INSERT INTO blw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yag ekat agé Jesus an hiyéén, “Heno way tagu way manginlugi way somorot an haén yag chan chuwachuwa hen hamhamàna, maid angkay misérfiyana hen anchi mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Angkay hiyachi, penelen Jesus hen pitunporo ya chuwa way larae yag annaat hinchudchudwéén chicha way mangempangpango hen egachay fabréy way ekatnéén ayana. ");
INSERT INTO blw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yag anat mampani an chicha hen nangimfag-ana way chuarcha hen tatagu way omafurot koma non an wachay i manudtuchu an chicha. Ekatna way mampaniyén, “Ammag chuar hen mabtà ngém ancha aket hen anchichay i mamfatà, wat chawatényu an Apudyus way nangen-awa hen antoy fatà ta homnag ah tapena way i mamfatà.” ");
INSERT INTO blw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yachi yag empaligwat Jesus chicha way mangaliyén, “Masapor man-ar-arwad-ayu te chà hénagén chàyu hen anchichay nan-araweng way tatagu, way an ayug kaman karnero way cha éméy hen iggaw hen tanan way aho. ");
INSERT INTO blw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Achiayu omentàtaen ah pelak ya uray hen mansoktanyu ah sapatosyu. Achiayu mampah-eng ya achiayu amin cha mì-ib-ifun hen charan. ");
INSERT INTO blw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wat no hénggép-ayu hen ihay faréy, ifagayu hen anchichay ininggaw way bindisyunan Apudyus chicha. ");
INSERT INTO blw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yag no laylayadcha way mangempaghép an chàyu, wat mabindisyunancha tot-owa. Ngém mag-ay ta achicha laychén, mamfangad chillu an chàyu hen anchi enaleyu. ");
INSERT INTO blw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yag no epaghép chàyu, epahigyu way i-inggaw hen hiyachiy faréy way achiayun at-aton, ya anyu agég akseptarén hen heno way ipissacha ya epainumcha an chàyu te yachi hen kaman labfuyu. Te hen anchi man-amma, karébféngana way midchat hen masaporna. ");
INSERT INTO blw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wat hiyachi, uray heno way fabréy way homàyatanyu yag empaghép chàyu, issayu hen heno way epasangocha an chàyu. ");
INSERT INTO blw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ya ka-anényu hen saket hen aminay masaket hen hiyachiy fabréy, ya ifagayu hen aminay tatagu way tég-angay umchah hen mantorayan Apudyus an chicha. ");
INSERT INTO blw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngém mag-ay ta homàyat-ayu hen ihay fabréy yag achi chàyu laychén way mempaghép, éméy-ayu hen charancha yag imfagayu an chicha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Uray hen anchi tapokyu way penom-at hen he-eni wat pòpoanni ah mangil-anyu way an-ayug egad ah machusaanyu. Ngém ma-awatanyu koma chillu way tég-angay tot-owa umchah hen mantorayan Apudyus an chàyu yag an-ayug omachi.” ");
INSERT INTO blw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Entoroy Jesus way manugun an chicha, ekatnéén, “Tot-owa hen antoy ifagà way sigurachu way no umchah hen manguwisan Apudyus hen aminay tatagu, chakchakkar hen ség-angna hen anchichay iSodoma way ammag neopoh gapoh fasorcha no hen anchi fabréy way mangachi an chàyu.” ");
INSERT INTO blw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Entoroy Jesus way mangaliyén, “An-ayug ka-as-ase, chàyu way iCorazin ya iBetsaida. Kaségség-ang-ayu no hen anchichay faén Judio way iTiro ya iSidon, te non an umat yag ahchi hen nangammaà hen kaskascha-aw way kaman hen enammaà ah fabréyyu, wat ancha angkay ammag nanlumfong ah sako ya intùchucha way manchapchapor ah mangempàil-ancha hen namfafawiyancha. ");
INSERT INTO blw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wat mangmanghan angkay hen machusaan hen anchichay iTiro ya iSidon no chàyu no umchah hen anchi ag-agaw way manguwisan Apudyus hen aminay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya chàyu agé way eCapernaum, magénén ekatyuwén machachayaw-ayu ingganad uchu. Ngém achiayu te an-ayug mepesok ad imférno gapon achiyu mamfafawiyan.” ");
INSERT INTO blw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yachi yag anat ekat Jesus hen anchichay sommorot an hiya agéén, “Heno way mangafurot hen aryényu, chana agé afuroton haén. Waman hen anchi annag achi pagan-ano chàyu, achina agé pagan-ano haén. Ya hen anchi achina pagan-ano haén, achina agé pagan-ano hen anchi nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Angkay hiyachi yag namfangad hen anchichay pitunporo ya chuwa way hennag Jesus, yag amchan hen laylayadcha. Yag ekatchéén, “Apo, tàén ongtanén emparyawni hen nanginyusaranni hen ngachanno.” ");
INSERT INTO blw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yag ekat Jesus an chichéén, “Oo, tot-owa te inni-ilà hen na-afa-an Chumunyu way ap-apon chi ongtan way kaman koliyapyap way narpod uchu hen nàchégana. ");
INSERT INTO blw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Manowat te inidchat-o an chàyu hen kafaelanyu ta uray igatenyu hen farakkan ya gayyamanén maid ekatna, ya afaényu agé hen kafaelan Chumunyu, wat maid mangafà an chàyu. ");
INSERT INTO blw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ngém faén koma chillu hen kafaelanyu way mangafà hen ongtan hen mangemparayad an chàyu, te hen mangemparayad an chàyu koma, hen anchi nelelestaan hen ngachanyu ad uchu.” ");
INSERT INTO blw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hen hiyachi, emparaylayad hen Espiritun Apudyus ah Jesus yag anat ekat Jesusén, “Amay Apudyus way ap-apo ad uchu ya hen antoy lota, anà ammag manyaman an hea te annog empaka-ammu hen katot-owaan mepanggép an haén hen antochay tatagu way iggay ma-achar yag entat-allingébnoto hen hamhamà hen anchichay naraeng ya na-achar. Enammaamha Ama, te yaha chillu hen laychém.” ");
INSERT INTO blw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Entoroy Jesus way mangaliyén, “Impiyar Amay Apudyus amin hen egad an haén. Ngém maid nangammu hen kena-apudyus-o no faén yanggay ah Ama way Apudyus. Ya maid agé nangammu an Amay Apudyus no faén yanggay haén way anàna ya anat hen anchichay tatagu way piliyê ah mangempaka-ammuwà hen mepanggép an hiya.” ");
INSERT INTO blw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yachi yag nanhagong ah Jesus hen anchichay pasorotna way chicha yanggay hen nangempagngarana yag ekatnéén, “Nagasat-ayu gapo hen chayu mangil-an hen antochay chayu ilan, ");
INSERT INTO blw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","te tot-owa way chuarcha hen anchichay profeta ya are ad namenghan way anchag laylaychén paat koma way mangila ya mangngar hen antochay chayu ilan ya chayu changrén, ngém iggaycha te cha-an hen tempona.” ");
INSERT INTO blw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Angkay hen-argawan, émméy an Jesus hen ihay siguchay cha mintudtuchu hen orchin Apudyus way ina pachasén way manlokop an Jesus, ekatnéén, “Apo, nokay hen ammaà ta ma-adchanà koma hen anchi mannanayun way ataguwan an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yag ekat Jesusén, “Nokay hen ekat hen anchi nesosorat way orchintaaw no nokay hen na-awatam hen cham namasaan.” ");
INSERT INTO blw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yag sommongfat hen anchi tagu way mangaliyén, “Masapor laylaychéntaaw paat ah Apudyus inggana ah patinggan hen aminay hamhamà ya ah aminay a-amma, ah aminay kafaelan ya ah aminay kenaraeng. Yag masapor agé laychéntaaw hen ifataaw kaman hen manlaychantaaw hen achartaaw.” ");
INSERT INTO blw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Usto met hen songfatno,” way ekat Jesus, “wat yachi hen cham amma-ammaan wat mètagua an Apudyus ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngém hen anchi taguwanchi, laychéna way manàchég hen chana ekamkaman, wat ekatnéén, “Oo a, ngém nokay paat hen anchi ekatchéén man-ifà nò.” ");
INSERT INTO blw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yachi yag anat mampani ah Jesus way mangaliyén, “Hen-argawan ano, wacha hen ihay tagu way Judio way narpod Jerusalem way chan éhég way éméy ad Jerico. Yag hen chana manaranan, annag hinib-atat agé hen anchichay futangelo yag anchag penang-or hiya yag innaracha hen aminay wacha an hiya way uray hen lumfongna, yag anchaat lomayaw way manaynan way tég-angay matéy.” ");
INSERT INTO blw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Angkay hiyachi yag niyaphor way wacha agé hen chan éhég hen hiyachiy charan way ihay pachin hen Judio. Ngém hen nangil-ana hen anchi napang-oranchi, ammag hommagigi. ");
INSERT INTO blw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yag angkay na-awni wacha hen kasen nanlooh way ihay Judio agé way ganà Levi way hiya hen ihay cha tomot-orong ah Templo. Yag annag cha wingwingiyén yag hommagigi agé. ");
INSERT INTO blw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yachi way na-awni agé, nanlooh hen ihay eSamaria way pepellohon hen Judio. Yag hen nangil-ana hen anchi napang-or, ammag naség-angan. ");
INSERT INTO blw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wat émméy way i nangagah hen sugatna ah lana ya fayah yag enoppeopana ya annaat aran hiya way nangempasakay hen kafayuna way manginyéy hen ihay faréy way chachag-ohan hen tatagu, wat henalimunana hiya ahchi hen hiyachiy lafi. ");
INSERT INTO blw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Angkay nafigat, inidchatna hen pelak hen anchi nangimfaréy way mangaliyén, ‘Anto ta halimunam hiya yag no mamfangachà, fayachà agé no wachay entaptapem hen gastosna.’ ” ");
INSERT INTO blw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Angkay hiyachi yag ekat Jesus hen anchi tagu way chana mempaniyanén, “Ah hamhamàno hen anchichay torowanchi way nanlooh, nokay hen mangalem ah ustoy ifan hen anchi napang-or.” ");
INSERT INTO blw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yag sommongfat hen anchi tagu way mangaliyén, “Hen anchi nanég-ang an hiya.” “Oo,” way ekat Jesus, “wat in-aat ta yaha agé hen ekamanno.” ");
INSERT INTO blw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Angkay hiyachi way cha émé-éméy ah Jesus ya hen anchichay pasorotna, inumchahcha hen ihay fabréy yag enayagan hen ihay in-ina chicha way ah Marta hen ngachanna. ");
INSERT INTO blw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ya wacha agé hen ihay sonod Marta way ah Maria hen ngachanna way ammag nìtutùchu an Jesus way mamangngar hen chana itudtuchu. ");
INSERT INTO blw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yachi yag ammag lommaweng hen hamhamà Marta te an ihà-an hiya way chan alekatto amin hen ma-ammaan. Wat émméy an Jesus way mangaliyén, “Apo, ay enlasinno way chaà pa-anggayén hen annay ifà way man-alekatto. Wat ay achi mafalin ta ifagam ta toronganà.” ");
INSERT INTO blw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngém ekat Apo Jesus an hiyéén, “Marta, narafus hen chanagno mepanggép hen annachay chuar way ma-ammaan. ");
INSERT INTO blw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ngém faén komaha, te an ihà-an hen masapor paat way yachi hen penelen Maria, wat achi tot-owa maka-anchi an hiya.” ");
INSERT INTO blw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hen-argawan, chan luwaru ah Jesus hen ihay lugar. Angkay narpas hen nanluwaruwana, ekat hen ihay pasorotna an hiyéén, “Apo, ay mafalin ta tudtuchuwam chàni hen ekamanni way manluwaru way kaman hen nanudtuchuwan Juan hen anchichay pasorotna.” ");
INSERT INTO blw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yag anat ekat Jesus an chichéén, “No manluwaruayu, yaton ekamanyu, ekatyuwén, ‘Ama, ta machachayaw koma hen ngachanno, ya ta umchah koma hen mantorayam hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Idchatno hen man-érégna ah anénni ah ka-ag-a-ag-agaw. ");
INSERT INTO blw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ya pakawaném agé hen fasorni way kaman hen chani mamakawanan amin hen anchichay cha fumasor an chàni. Ya hahallimunam chàni ta achiani ma-awis way mangamma hen laweng.’ ” ");
INSERT INTO blw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yachi yag nampani ah Jesus way mangintudtuchu mepanggép hen luwaru, ekatnéén, “An chàyu ngay, non an umat yag wachay anat inumchah ah faréyyu way ifayu way namfiyahi, yag niyaphor way maid senor-atyu, wat uray ngata gawan chi lafi wat éméy-ayu ah faréy hen atògongyu way i mamfaga ah epanganyu. ");
INSERT INTO blw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yag non an umat yag ammag omachi hen anchi atògongyu way mangaliyén, ‘Achi chàni koma faragéén te nan-é-énnéb-ani ya nanasséy-ani amin way himfafaryan, wat chaà matokar way fumangon way umidchat an hea.’ ");
INSERT INTO blw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hen ifagà an chàyu,” way ekat Jesus, “tàén atògongyu wat achi chillu fumangon, ngém gapo ta achiayu mafiinan way ammag chan fagafaga, ammag maslat yag ummidchat hen aminay masaporyu. ");
INSERT INTO blw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Wat hen miyaligana, kaman hen manchawatanyu an Apudyus, te hen ifagà an chàyu, no manchawat-ayu an Apudyus, anyug cha ifagafaga hen ifagayu wat idchatna an chàyu, ya ana-anapényu hen anchi chayu anapén wat ichahanyu way an-ayug mankogkokogkog hen hawang ta mafùtan an chàyu. ");
INSERT INTO blw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Te heno way chan fagafagaat, arana hen anchi chana ifaga. Ya hen anchi cha mangana-anap, ichahana hen chana anapén. Ya hen anchi chan kogkokogkog, mafùtan hen hawang an hiya. ");
INSERT INTO blw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kaman an chàyu way chinàcha-ar, te no mamfaga hen anàyu ah gachiw, achiyu met adchan ah farakkan. ");
INSERT INTO blw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yag no mamfaga ah etlog, ay ammoh gayyaman hen idchatyu. ");
INSERT INTO blw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Wat chàyu way nisissigud way menangfasor, no innilayu way mangidchat hen ammay hen a-anàyu, ay ammoh achi kaskasen hen ekaman Amataaw ad uchu way mangidchat hen Espirituna hen anchichay mangimfaga.” ");
INSERT INTO blw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Angkay hen-argawan, emparyaw Jesus hen anchi nihuhurug way ongtan way nangempatongong hen ihay tagu. Yag yachi way lommayaw hen anchi ongtan, wat inluginat agé hen anchi nattongong way man-ale, wat anchag nahahaang amin hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ngém ekat hen tapenéén, “Ah Beelzebub way ap-apon hen ongtan, hiya angkay hen nangidchat hen kafaelana way nangemparyaw hen ongtan.” ");
INSERT INTO blw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Angkay hiyachi agé yag wachacha hen tapena way manlayad way manlokop an Jesus, wat imfagacha way omamma ah kaskascha-aw ah manot-owaancha way hiya hen narpon Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngém ah Jesus, inni-ilana chillu hen chacha hamham-én wat senongfatana chicha ah pani way mangaliyén, “Uray heno way toray, no maid tempoyugcha way anchag chan sososongel, ammag naraka hen ma-afa-ancha. Ya umat agé hen himfafaryan, no maid péhédcha wat anchag mahihiyan. ");
INSERT INTO blw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yag pachongna agé, no gufatén Chumunyu hen kapachongna way chumunyu, ay ammoh achi machachael hen mantorayancha. Yag hen iha, chayu agé ekatén ah Beelzebub way ap-apon hen chumunyu hen nangidchat hen kafaelà way mangemparyaw hen ongtan. ");
INSERT INTO blw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wat no hiya hen nangidchat hen kafaelà way mangemparyaw hen anchichay nihuhurug, wat achi pay hiya agé hen nangidchat hen kafaelan hen anchichay pasorotyu agé way cha mangemparyaw. Wat hen cha ammaan hen pasorotyu, yachi hen cha mangempàila way enomfat hen annay chayu aryén an haén. ");
INSERT INTO blw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Te ah katot-owana, ah Apudyus hen nangidchat hen kafaelà way mangemparyaw hen ongtan, wat ay ammoh achi ommanayha ah manot-owaanyu way inu-umchah hen mantorayana hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ah Chumunyu hen miyaligan hen anchi ammag orhe way nan-a-armas way cha minyachug amin hen faréyna, yag ammag maid makafael way i mangara hen kok-owana. ");
INSERT INTO blw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ngém no umale hen or-orhe no hiya way mangufat yag enafàna, annag elayaw amin hen armasna way ekatnéén iyafàna yag annaat epayàchang hen ifana hen egachay henamhamna.” ");
INSERT INTO blw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yag ekat Jesus agéén, “Heno way tagu way achi mangifa an haén, wat chana angkay tot-owa fusoron haén. Ya heno agé way achi cha tomorong an haén hen chà ammaan, chana angkay agé kontaréén haén.” ");
INSERT INTO blw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Entoroy Jesus way mampani, ekatnéén, “No lommayaw hen anchi nihuhurug way ongtan hen ihay tagu, ina gégga-ayén hen papenotaw way i man-anap ah fumaryana. Yag mag-ay ta maid ichahana, ekatnéén, ‘Aẁ mamfangachà hen anchi tagu way narpowà.’ ");
INSERT INTO blw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yag yachi way namfangad, inchahana way ammag nacharosat agé peet ya am-ammay no hen anchi nanaynana, ");
INSERT INTO blw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","wat anat i man-ayag ah pitu way ifana way wadwadcha hen kenarawengcha no hiya, yag fummaréycha amin hen anchi taguwanchi. Wat ammag kaskasen way ka-as-ase hen yachiy tagu hen anchi anongohna no hen anchi pés-éyna.” ");
INSERT INTO blw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hen nangaryan Jesus an nadchi, wacha hen ihay in-ina way nangngar way niya-ahrang hen anchichay chuaray tatagu. Yag hen nangngarana ekatnéén, “Laylayad paat hen anchi nanginyanà an hea ya nampasoso an hea.” ");
INSERT INTO blw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yag sommongfat ah Jesus way mangaliyén, “Achi a, te kaskasen hen layad hen anchichay nangngar hen alen Apudyus yag enammaancha.” ");
INSERT INTO blw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Angkay hiyachi way chacha chumuar hen anchichay tatagu way mangamong an Jesus, entoroyna way mantudtuchu, ekatnéén, “Anchag laweng hen tatagu way cha matagu ad uwan, yag chachaat epapelet way mampa-amma ah sinyar way kaskascha-aw ah manot-owaancha way narpowà an Apudyus, ngém ammag maid epàilà an chicha no faén yanggay hen kaman hen anchi sinyar way na-ammaan an Jonas ad namenghan. ");
INSERT INTO blw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Te hen anchi nekaman an Jonas, yachi hen nanot-owaan hen anchichay iNineve way ah Apudyus tot-owa hen nannag an hiya. Yag kaman agéhchi hen mekaman an haén ah manot-owaan hen tatagu ad uwan way ah Apudyus agé hen nannag an haén. ");
INSERT INTO blw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yag no umchah hen kauwisan hen egachay tatagu, fùnag hen anchi fufae way Are ad namenghan ad Seba, yag annag pafasoron chàyu way tatagu ad uwan, te hiyaat acha-achawwéy yag inggagtàna way i paat mangngar hen anchi kenaraeng way intudtuchun Are Solomon. Wat hen ifagà an chàyu, wà-acha angkay ad uwananto hen nangatngato no ah Solomon, ngém anyu chillug anchi changrén. ");
INSERT INTO blw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ya hen anchi ag-agaw agé way kauwisan hen tatagu, wat fùnagcha agé hen anchichay iNineve way mangempafasor an chàyu way tatagu ad uwan, te chichaat, namfafawicha hen nangngarancha hen intudtuchun Jonas. Wat hen ifagà an chàyu, wà-acha angkay agé ahto ad uwananto hen nangatngato no ah Jonas, ngém anyu chillug achi changrén.” ");
INSERT INTO blw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Entoroy Jesus way mampani, ekatnéén, “Maid mamasgéd ah helaw yag annag etaro ono hàufan, te anna an epatang hen ustoy mepatngana ta mahelawan amin hen anchichay hénggép. ");
INSERT INTO blw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ya hen mata agé, yachi hen helaw hen achar. Wat no iggay nakorafuwan hen mata, kaman mahehellawan hen aminay achar. Ngém no nakorafuwan hen mata, ammag helang hen achar. ");
INSERT INTO blw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wat ar-arwachanyu, te awni yag ekatyuwén nahelawan hen acharyu yag helangat agé peet. ");
INSERT INTO blw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ngém no mahelawan tot-owa amin hen achar way maid paat akettoy ah helangna, narawag hen manhamham-anyu way kaman paat nahelawan-ayu ah ammayay helaw.” ");
INSERT INTO blw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Angkay hiyachi way narpas hen anchi intudtuchun Jesus, enayagan hen ihay Fariseo hiya way i mèan, wat émméy ah Jesus ah faréyna yag hinénggép way i tummùchu way mangan. ");
INSERT INTO blw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ngém nascha-aw hen anchi Fariseo hen nangil-ana an Jesus way iggayna tongparén hen liglamenton hen orchincha mepanggép hen mamfuruwan yag chaat mangan. ");
INSERT INTO blw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wat nampani ah Apo Jesus an hiya way mangaliyén, “Chàyu way Fariseo, anyug chachallosan hen anchi mamàila way achar hen tasayu ya pengganyu, ngém ad char-ém way achi maila, ammag aggarémha te nanapno ah gamgam ya laweng. ");
INSERT INTO blw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","An-ayug nawéngwéng, te ah Apudyus way nangamma hen tatagu, ay ammoh anggay hen anchi mamaila way achar hen ilana yag achina agé ilan hen anchi netataro. Ilana met amin. ");
INSERT INTO blw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wat iyam-ammayu unna hen hamhamàyu ta toronganyu hen anchichay ahentaguyu, te no omammay hen anchi achi maila, kapeletan way omammay agé hen anchi mamàila.” ");
INSERT INTO blw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“An-ayug ka-as-ase, chàyu way Fariseo te tàén chayu tongparén amin hen anchichay faén napateg way liglamenton hen orchin, chayu peet iwalin hen anchichay napatpateg. Te pakay paat epapateyu way mangidchat hen pagkaporon hen uray lawa anchichay charoh way omenparamnaw hen missa yag chayuwat agé chillu iyanggayan hen ekat Apudyus way masapor malilimpiyutaaw ya laylaychéntaaw hiya. Ammayha ah ammaan ngém achiyu koma cha iwalin hen anchichay tapena.” ");
INSERT INTO blw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“An-ayug ka-as-ase tot-owa, chàyu way Fariseo, te hen laychényu paat wat chàyu hen i tumutùchu hen anchichay am-ammay way tùchu hen anchi chayu ma-am-amongan, yag an-ayu agég chan paraparamano ah chayu mampàpàil-an hen cha um-umfunan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","An-ayug ka-as-ase, te kaman-ayu lufù way maid markana wat achi melasin yag ginatenan hen tatagu way achicha am-ammu yag nehagémcha.” ");
INSERT INTO blw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Angkay hiyachi yag wacha hen ihay siguchay cha mintudtuchu hen orchin Moses, ekatna an Jesusén, “Apo, hen cham mangaryan ahna wat cham angkay agé etape chàni way manginsorto.” ");
INSERT INTO blw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yag senongfatan Jesus way mangaliyén, “An-ayug ka-as-ase agé, chàyu way cha mintudtuchu hen orchin, te chayu sabsab-atan hen orchin way mamap-aligat hen tatagu hen chayu mempapeletan ah somorotancha, ngém achiyu met paat cha tot-orongan chicha way manorot. Kaman paat chayu epakarga hen ammag chinaghén way karga hen tatagu, ngém an-ayug achi paat fumfumnéh.” ");
INSERT INTO blw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“An-ayu tot-owa ammag ka-as-ase te ilanyu ngén, chayu epa-amma hen a-anam-ammay way kelufuan hen tongar hen anchichay profeta ad namenghan way pinchit hen anap-oyu. ");
INSERT INTO blw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yag yaha agé hen kail-ana way chayu afunan hen enammaan hen anchichay anap-oyu ad namenghan, te chicha hen namchit hen anchichay profeta ya chàyu agé hen cha mangempa-amma hen kelufuancha. ");
INSERT INTO blw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wat yachi hen tommot-owaan hen imfagan Apudyus ah kenaraengna way ekatnéén, ‘Hénagê hen anchichay profeta an chicha ya umat agé hen anchichay i mangimfaga hen laychê.’ Ngém awniyat pédténcha hen tapena ya paligaténcha hen tapena. ");
INSERT INTO blw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wat hiyaha, chàyu way tatagu way cha matagu ad uwan, chàyu hen mangamong way mangenkaro hen chusan hen napchitan hen egachay napchit way profeta nanepod hen na-ammaan hen antoy lota ingganad uwan, ");
INSERT INTO blw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","way nanepod hen napchitan Abel way pés-éy napchit inggana hen napchitan Zacarias way anongoh hen profeta way pinchitcha hen fattan hen Templo ya hen anchi cha mepatpatngan hen michaton an Apudyus. Oo, tot-owa hen antoy ifagà way chàyu way tatagu ad uwan hen machusa mepanggép hen napchitan hen egachay profeta nanepod ad namenghan.” ");
INSERT INTO blw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“An-ayug ka-as-ase, chàyu way cha mintudtuchu hen orchin, te chayu sellaan hen hamhamà hen tatagu way manganap hen tot-owa mepanggép an Apudyus te uray chàyu, achiyu cha epaghép hen kenatot-owaan mepanggép an hiya ah hamhamàyu, yag chayuwat agé epawa hen mangempaghépan hen tapena.” ");
INSERT INTO blw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Angkay hiyachi way narpas hen enalen Jesus yag ginumhad hen anchi faréy hen anchi Fariseo, wat hen anchichay siguchay cha mintudtuchu hen orchin ya hen anchichay Fariseo, anchag achi mahlin way manumsek an hiya. Wat maid achicha sarudsuchun ");
INSERT INTO blw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ah manlokopancha koma ta wacha paat chi aket ah meh-awan hen alena ta wachay mempafasorancha an hiya. ");
INSERT INTO blw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Angkay hiyachi way anchag cha makabkabfuraw hen anchichay kalifulifu way tatagu way chachan in-inippet, tenagépfar Jesus hen anchichay pasorotna paat way mangaliyén, “Ar-arwachanyu hen anchi cha iyipon hen anchichay Fariseo ta achiayu ma-alesan hen yachiy senang a-afurot. ");
INSERT INTO blw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Te tot-owa way amin way achi maila ad uwan, mepadlaw chillu ah pegwana. Ya amin way netataro ad uwan, mepafùnag chillu ah pegwana. ");
INSERT INTO blw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wat amin hen entataroyu way uray anyug inyut-utiyam hen ka-anggayyu, mepagngar chillu hen sangwanan hen aminay tatagu ah pegwana way magénén nèngaw way mepagngar.” ");
INSERT INTO blw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Entoroy Jesus way mangaliyén, “Hen ifagà an chàyu way inib-à, achiayu cha émég-égyat hen anchichay mamchit hen achar way yachi yanggay hen péppég hen kafaelancha. ");
INSERT INTO blw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ta hen émégyatanyu koma, émégyat-ayu an Apudyus way no pédténa hen achar, wacha chillu hen kafaelana way omentap-ar ad imférno. Wat hiya paat hen iyégyatyu. ");
INSERT INTO blw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Ngém achiayu machanagan no ah Apudyus tot-owa hen émmégyatanyu te ilanyu ngén hen hamhamàna. Uray hen tolen way kafafaan way kasole way mafalin melao hen lema ah an chuway sentemos, wat achi chillu matarà hen uray ihà-an an Apudyus te innilana amin. Wat achiayu machanagan te am-améd hen hamhamàna an chàyu no hen tolen, te chàyu, uray hen kabras hen fuùyuwén finifilang Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Entoroy Jesus way mangaliyén, “Yato agé hen ifagà an chàyu. Heno way tagu way manàchég an haén way Pangorowan hen Tatagu hen sangwanan hen anchichay tatagu, tàchégê agé hiya hen sangwanan hen anchichay anghel Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yag heno agé hen mangenhoot an haén way Pangorowan hen Tatagu hen sangwanan hen tatagu, ehoot-o agé hiya hen sangwanan hen anchichay anghel Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Heno way tagu way mangsot an haén way Pangorowan hen Tatagu, mafalin chillu mapakawan. Waman hen anchi mangsot hen Espiritun Apudyus, ammag achi poros mafalin mapakawan.” ");
INSERT INTO blw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mag-ay ta ichérém chàyu hen anchichay chacha ma-am-amongan yag empasango chàyu hen anchichay gubérnador ya nan-angato way chan toray, achiayu machanagan mepanggép hen esongfatyu ya hen ekamanyu way man-ale, ");
INSERT INTO blw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","te hen hiyachiy urasat itudtuchun hen Espiritun Apudyus hen ustoy iyaleyu.” ");
INSERT INTO blw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Angkay hiyachi yag nan-ale hen iha hen anchichay tatagu way nanga-among an Jesus way mangaliyén, “Apo, ay mafalin ta ifagam hen anchi sonod-o ta igudwanà paat hen anchi tawidni.” ");
INSERT INTO blw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngém sommongfat ah Jesus way mangaliyén, “Heay tagu, maid met fiyang-o way manguwis an chàyu ya mangimfanag ah fingfingayyu.” ");
INSERT INTO blw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yachi yag entoroy Jesus way mangintudtuchu hen anchichay tatagu, ekatnéén, “Masapor man-arwad-ayu ta achiayu ma-awis way man-am-ameam, te uray no hommawar hen kafaknang hen ihay tagu, achi angkay ummatchi ah omammayan hen ataguwana.” ");
INSERT INTO blw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yachi yag anat mampani ah Jesus way mangaliyén, “Hen-argawan ano, wacha hen ihay faknang way tagu way ammag péhpéhéd chi mura hen lotana. ");
INSERT INTO blw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yachi yag ekat hen anchi faknang ah hamhamànéén, ‘Nokay lawa hen én-énnê henaỳ te achi ummat hen antochay a-arang-o ah mangempénpénà hen anchi chuar way fintào. ");
INSERT INTO blw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wat yato peet uwa hen ammaà. Fakasê hen anchichay arang-o yag pachinakkarê chicha ta yachi hen mangempénpénà hen aminay fintào ya hen kok-owà. ");
INSERT INTO blw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Wat anà ammag manlamram-ay te hommawar amin chi egad ah uray kamanay tawén, wat achiyà kasen man-am-amma ta anà ammag cha mangmangan ya cha umin-inum ya chan lagragsak.’ ");
INSERT INTO blw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngém hen hiyachi, ammag ekat Apudyus hen taguwanchi way mangaliyén, ‘An-a ammag naong-ong way tagu, te hen hiyato paat way lafi hen matéyam wat heno ngén hen mangen-awa amin hen annachay entarpénno nò way ekatnowén man-awam.’ ” ");
INSERT INTO blw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yachi yag inyanongoh Jesus way mangaliyén, “Yaha agé hen mekaman hen anchi tagu way ammag cha manarpétarpén hen egad hen antoy lota yag maid hamhamàna an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Angkay hiyachi yag imfagan Jesus hen anchichay pasorotna way mangaliyén, “Wat hiyachi, achiayu machachannagan hen mepanggép hen iyataguyu hen antoy lota way anényu ya ilumfongyu. ");
INSERT INTO blw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Te ay ammoh faén wadwadcha hen ataguwanyu no hen anényu, ya hen acharyu no hen ilumfongyu. ");
INSERT INTO blw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ilanyu ngén hen gayang way achichan mura ya achichan fatà, ya maid amin mangentarpénancha ah masaporcha, te ah Apudyus hen cha mamangan an chicha. Yag ay ammoh achi kaskasen hen hamhamà Apudyus an chàyu no hen kasole. ");
INSERT INTO blw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ya maid chillu etorong hen chanag te uray machachannagan-ayu, ay ammoh pa-anchuwén lawa hen anchi chanagyu hen ataguwanyu ah uray ihay uras. ");
INSERT INTO blw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wat no achiayu maka-amma hen kaman an cha nadchi way akettoy, ammag maid sérfina hen machanaganyu ah uray heno. ");
INSERT INTO blw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ilanyu ngén hen anchi charoh way ammag cha lomtà, wat achicha met chan amma ya chan afar, ngém hen ifagà an chàyu, anam-ammay hen sabsafongcha chillu no hen anchi ka-a-ammayan way cha inlumfong hen anchi kafafaknangan way Are Solomon. ");
INSERT INTO blw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yag hen anchi charoh, ammag hen-emad yanggay hen kawad-ancha, te tàén wacha ad uwan, ah wakas ammag narango yag nahèlan. Wat no yachi way cha epa-ammay Apudyus hen an lawag charoh, ay ammoh achi kaskasen hen hamhamàna ah ilumfongyu way tatagu. Wat pakay achiyu manchinlan ah Apudyus nò.” ");
INSERT INTO blw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Wat hiyaha, achiyu koma ammag cha ham-éham-én hen masaporyu ah iyataguyu, ya achiayu amin machanagan an cha nadchi, ");
INSERT INTO blw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","te chichachi hen cha ham-éham-én hen tatagu hen antoy lota way maid afurotcha an Apudyus. Ngém chàyu, inni-ilan chillu Amataaw ad uchu way masaporyu amin cha nadchi. ");
INSERT INTO blw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wat hen hamham-ényu koma, hen mepanggép hen mantorayana, te no yachi, egad hiya way manmanmà hen egachay masaporyu.” ");
INSERT INTO blw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Entoroy Jesus way mangintudtuchu hen anchichay pasorotna, ekatnéén, “Achiayu cha émégyat uray no an-ayu aket, te laylayad ah Apudyus way mangentape an chàyu hen mantorayana. ");
INSERT INTO blw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wat elaoyu hen wachan chàyu ta idchatyu hen laona hen anchichay maid mafalinna te yachi hen mangentarpénanyu hen kafinaknangyu ad uchu, ya ahchi, achi makàka-anan hen kafinaknangyu te maid makapréh ya maid makachachael. ");
INSERT INTO blw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Te ah katot-owana, heno way papattigényu, kapeletan way yachi agé hen haham-ényu.” ");
INSERT INTO blw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Entoroy Jesus way mangaliyén, “Masapor an-ayug mansasaggana ah uray heno way mepasamak way hen miyaligana, kaman-ayu hen anchichay alepan way mamannéd hen apocha way i nèkasar way é-éttég hen lumfongcha ya uray hen helawcha, ta no homàyat hen apocha yag nankogkog, finùtanchaat hen hawang. ");
INSERT INTO blw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wat amchan hen laylayad hen anchichay alepan no ichahan hen apocha chicha way nansasaggana way iggaycha masséy. Yag tot-owa hen antoy ifagà an chàyu way no homàyat hen anchi apocha, ka-anéna hen anchi ammayay lumfongna yag empatùchuna hen anchichay alepanna yag penanganna chicha. ");
INSERT INTO blw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wat anchag laylayad tot-owa no nansasagganacha paat hen umaliyan anchi apocha way uray gawan chi lafi hen umaliyana ono hen tég-angay ma-apeh.” ");
INSERT INTO blw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kasen nampani ah Jesus agé way mangaliyén, “Hamham-ényu ngénto agé te no innilan hen anchi nangimfaréy hen anchi ustoy uras hen aliyan hen anchi i mangakaw ah faréyna, kapeletan way annag hihimnén ta achi makaghép hen anchi mangakaw. ");
INSERT INTO blw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wat kaman agé an chàyu, masapor mansasaggana-ayu te haén way Pangorowan hen Tatagu, ekatyuwén cha-acha-an hen mamfangchà yag inumchaha-at agé.” ");
INSERT INTO blw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yachi yag ekat Pedro an Jesusén, “Apo, hen anchi penanim, ay chàni yanggay way pasorotno hen mangaryam an nadchi ono amin hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yag senongfatan Apo Jesus hiya ah pani way mangaliyén, “Hen anchi natalek ya naham-an way alepan, hiya hen anchi piniyar hen apona way mangemponò hen anchichay ifana way alepan ya mamangan an chicha hen tempon hen manganancha. ");
INSERT INTO blw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wat ammag laylayad hen hiyachiy alepan no enaphoran hen anchi apona hiya way cha mangamma amin hen nipiyar an hiya. ");
INSERT INTO blw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yag tot-owa hen antoy ifagà an chàyu way ah kenataleknaat ammag piyarén hen anchi ap-apo hiya ah mangi-ila hen aminay kok-owana. ");
INSERT INTO blw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ngém non an umat yag ammag ekat hen anchi alepan ah hamhamànéén, maid ménat awanwani ah homàyatan hen anchi ap-apo, yag annaat agég ilugi way mamàpàgang hen anchichay ifana way alepan, yag an yanggay ammag cha mangmangan ya cha umin-inum ya chan futfutang. ");
INSERT INTO blw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yachi way hen-argawan, ammagat agég hommàyat hen anchi apona way iggay napòpo-otan hen anchi alepan hen uras way hommàyatana. Wat kapeletan way annag chuséén hiya ah pararo way chusa way annag etape hiya hen manusaana hen anchichay achi matalek.” ");
INSERT INTO blw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Hen anchi tagu way inni-ilana hen laychén hen anchi apona yag achina chillu ammaan way achi amin mansagana, ammag amchan hen kahapratana. ");
INSERT INTO blw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Waman hen anchi tagu way maid innilana hen laychén hen anchi apona, yag nan-amma agé ah laweng, mangmanghan hen kahapratana. Te tot-owa way heno way tagu way wacha hen nipiyar an hiya, kapeletan way wachan songfatana. Ya hen anchi tagu way chuar hen nipiyar an hiya, chùchùar agé hen songfatana.” ");
INSERT INTO blw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Angkay hiyachi yag kasen nampani ah Jesus way mangaliyén, “Hen ummaliyà hen antoy lota, ta iyà iyapoy hen egad. Yag non an mafalin, loohat koma gummigilab ta marpas. ");
INSERT INTO blw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ya umchah agé hen pararo way kapàgangà, wat an-og ahoopan hen karpasana te amchan hen antoy hamhamào way manmanmà hen hiyachi. ");
INSERT INTO blw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Awni yag ekatyuwén gapo hen ummaliyà hen antoy lota wat mamaid hen probleman hen tatagu ya matornoscha. Ngém faénat angkay, te gapon ummaliyà wat anchag mansesena hen tatagu way achicha mankenna-awatan. ");
INSERT INTO blw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wat manepod ad uwan, mankekennontaracha way tàén hen himfafaryan, no lemacha, kontaréén hen toro hen anchi chuwa, ya kenontaran agé hen anchi chuwa hen anchi toro. ");
INSERT INTO blw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ya achicha agé mantetempoyug hen hen-anamma, ya umat agé hen hen-ininna ya hen man-atoganga, te man-aheginnuracha amin.” ");
INSERT INTO blw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Angkay hiyachi yag nampani ah Jesus hen anchichay chuaray tatagu way mangaliyén, “No ilanyu way cha chumaghén hen funat, innilayu met way naway hen uchan, yag ummuchan tot-owa. ");
INSERT INTO blw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ya no lènéényu way ad lagud hen marpowan hen yawyaw, ekatyuwén ongag ah wakas, yag ammag ommongag tot-owa. ");
INSERT INTO blw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wat chàyu way senang a-afurot, pakay no ilanyu hen lota yad uchu wat maelasinyu hen ma-ammaan ah wakas, yag pakay achiayuwat agé makelasin hen sinyar mepanggép an haén.” ");
INSERT INTO blw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Entoroy Jesus way mangaliyén, “Pakay achiayu makahkahmà hen ammay way ma-ammaan. ");
INSERT INTO blw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","No gag-ara yag wachay mangempafasor an chàyu, pachasényu ah kafaelanyu way mangaliglu ta mifanag ta achiayu koma mepasango hen uwis, te no looh chàyu epasango hen uwis, awni yag idchatna chàyu hen polis yag imfarud chàyu. ");
INSERT INTO blw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yag hen ifagà an chàyu, achiayu angkay meparufus an nadchi ingganah fayachanyu hen aminay kasosyu.” ");
INSERT INTO blw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hen hiyachiy tempo agé, wachacha hen anchichay tatagu way cha manaphapet an Jesus hen nangempapchitan gubérnador Pilato hen tapenay iGalilea hen chacha manginchatonan hen animar an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yag senongfatan Jesus chicha way mangaliyén, “Pakay. Ay ammoh ekatyuwén gapo ta yachi hen inyatéycha yag kaskasen hen fasorcha no hen amin anchichay tapenay iGalilea. ");
INSERT INTO blw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Faén tot-owa. Ngém hen ifagà an chàyu, no achiyu manchùgan hen anchi laweng way a-ammayu, kaman agéhchi hen karaweng hen iyatéyyu. ");
INSERT INTO blw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ya pachongna agé hen natéyan hen anchichay hemporo ya waru hen neorofan hen anchi akayyangay faréy ad Siloe, ay ammoh ekatyuwén yachi hen manot-owaan way chicha hen kapararowan hen fasorna no hen aminay tapen anchichay ininggaw ad Jerusalem. ");
INSERT INTO blw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Faén agé, ngém tot-owa hen antoy ifagà an chàyu way no achiyu manchùgan hen fasoryu, kaman agéhchi hen karaweng hen iyatéyyu.” ");
INSERT INTO blw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Angkay hiyachi yag kasen nampani ah Jesus way mangaliyén, “Wacha ano hen ihay tagu way lenomtà hen anchi away way fig hen anchi lotana. Yachi yag cha émé-éméy way i mangoh-oh no wacha laway fungana, yag ammag maimaid. ");
INSERT INTO blw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wat gapo ta ammag achi mamunga, imfagana hen anchi chan amma hen lotana way mangaliyén, ‘Ilangngén, ma-atlo ad uwan ah tawén ah chà i mangoh-o-oh-ohan way i mangila hen fungan annay awayanna yag ammag maid, wat longhontaat, te pakay annag papoletégtégén yanggay hen lota.’ ");
INSERT INTO blw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ngém sommongfat hen anchi chan amma way mangaliyén, ‘Apo, antag anohan way mamannéd ah ihay tawén lawa ta iyà kaufan hen pongarna yag enafunuwà ");
INSERT INTO blw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ta éhéd yag mamunga ah tawén. Yag no mamunga, ammay. Ngém mag-ay ta ammag achi chillu, yachi hen manlonghanta.’ ” ");
INSERT INTO blw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Angkay hen-argawan way Safachu way ngilin chillu, chan tudtuchu ah Jesus hen anchi chacha ma-am-amongan way Judio. ");
INSERT INTO blw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yag niyaphor way wacha agéhchi hen ihay in-ina way nayùoh way térén hen acharna te ammag penekot hen ongtan yag émméy ah hemporo ya waru way tawén way achin gachang way tomàchég. ");
INSERT INTO blw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Angkay innilan Jesus hiya, yag annaat fagaan way mangaliyén, “Ina, ta maka-an hen annay saketno,” ");
INSERT INTO blw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","yag annaat tad-én hiya. Yag hen hiyachi, ammag nanggachangat agé hen anchi acharna, wat chinayawna ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ngém hen hiyachi, ammag ommaningarngar hen anchi ponò hen anchi chacha ma-am-amongan, te ngilin paat hen nanga-anan Jesus hen anchi saket, wat annaat ekat hen anchichay na-a-among way tataguwén, “Apayto, achi koma mafalinto, te énémay ag-agaw met yanggay hen makachuminggu hen meparafus ah man-ammaantaaw. Wat yachi koma hen umaliyanyu way mangempaka-an hen saketyu ta faén paat hen ngilin way Safachu.” ");
INSERT INTO blw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yag senongfatan Jesus hiya way mangaliyén, “Chàyu way ammag pàpàila yanggay hen afurotna, pakay tàén ngilinén chayu hamham-én hen animaryu way chayu met ùfachan way i mempainum. ");
INSERT INTO blw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yag ammoh maid hamhamàyu hen antoy ganà paat Abraham way hemporo ya waruy tawén hen namaligatan Chumunyu an hiya. Ay ammoh laweng no maka-an hen saketna hen antoy ngilin.” ");
INSERT INTO blw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yag hen yachi, gapo hen anchi songfat Jesus, anchag nafiinan hen anchichay kommontara. Waman hen anchichay lonay way tatagu, anchag laylayad gapon amin anchichay kahahaang way enammaana. ");
INSERT INTO blw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Angkay hiyachi yag ekat Jesusén, “Nokay hen mepachongan hen mantorayan Apudyus ah mangempaniyà. ");
INSERT INTO blw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hen miyaligana, wat kaman hen chumakaran hen anchi ka-ak-akkettoyan way fukar way i inmuran hen ihay tagu hen garchinna. Yag yachi way lenomtà yag ammag ommaway way i hommòfotan hen kasole hen anchichay pangana.” ");
INSERT INTO blw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yachi yag kasen agé nampani ah Jesus way mangaliyén, “Nokay hen manginyaligà hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yato, te kaman hen anchi tenòtò way mangempabnar hen tenapay way inyipon hen fufae hen ihay awit way arina wat annag enpabnar amin.” ");
INSERT INTO blw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Angkay hiyachi way cha éméy ah Jesus ad Jerusalem, enengwana hen kafabréfabréy hen charan way manudtuchu hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yachi yag henanhanan hen ihay tagu an hiya way mangaliyén, “Apo, ay ancha yanggay aket hen tatagu way mahara-an.” Yag anat somongfat ah Jesus ah pani way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kakaratényu way hénggép hen anchi nalepet way hawang ah hénggépanyu ad uchu, te tot-owa hen ifagà an chàyu way chuarcha angkay hen tatagu way safali hen ekamancha way mamachas way hénggép ngém achicha makaghép. ");
INSERT INTO blw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te hen anchi nangimfaréy, no loohna i umfan hen anchi hawang wat mataynan way mataynan hen anchichay wacha ah chara. Wat uray anchag tomatàchég way chan kogkokogkog ya chan apoapo way fùtamto te chàni, somongfat hen anchi nangimfaréy way mangaliyén, ‘Tawwan te maid angkay innilà an chàyu no chuud hen narpowanyu.’ ");
INSERT INTO blw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yag uray iyà-aròcha way mangaliyén, ‘Chàni angkay hen cham nèanèanan, yag ah fabréyni hen cham i nantudtuchuwan.’ ");
INSERT INTO blw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ngém kasenna chillu ifaga way mangaliyén, ‘Maid angkay innilà ah katataguyu ya ah narpowanyu wat lomayaw-ayuwat, chàyu way ammag laweng hen a-ammana.’ ");
INSERT INTO blw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yag hen mangil-ancha hen anap-otaaw way cha Abraham an Isaac yah Jacob ya anat amin hen anchichay profeta way netatappecha amin hen mantorayan Apudyus, anchag mankela ya magénén nanngangalitféncha hen fub-acha te chicha hen anchi metatap-ar way achi mafalin mètape. ");
INSERT INTO blw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Waman hen tatagu way nètape hen mantorayan Apudyus, maid achicha narpowan te marpocha ah karotarota way uray hen anchichay faén Judiowén mètapecha way mèlagsak. ");
INSERT INTO blw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Wat ilanyu ngén,” way ekat Jesus, “te hen anchichay nafafa ad uwan, chicha hen anchi nangato no ah pegwana. Waman hen anchichay kaman nangato ad uwan, chicha hen nafafa ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hen hiyachiy tempo, émméycha hen tapen anchichay Fariseo yag incha imfaga an Jesus way mangaliyén, “Un-unnina ménat Apo no an-ag manakpos way lomayaw ahto te ammag gagar-én angkay Are Herod way i mangempapchit an hea.” ");
INSERT INTO blw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yachi yag nampani ah Jesus way sommongfat, ekatnéén, “Inyu ifaga hen hay masilifanna way ad uwan ya ah wakasat chà chillu eparyaparyaw hen nihuhurug way ongtan ya chà amin ka-aka-anén hen saket hen tatagu, wat ah hin-uchum, ehènad-o hen chà ammaan. ");
INSERT INTO blw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wat hiyaha, masapor etoroy-o hen ayà ad uwan ya ah wakas ingganah hin-uchum, te ammoh wachay safali ah matéyan hen profeta no faén chillu ad Jerusalem.” ");
INSERT INTO blw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yachi yag hemhemmà Jesus hen a-amman hen anchichay iJerusalem yag annaat ekatén, “Anii lawa, chàyu way iJerusalem, ammag sigab hen hamhamào gapon chàyu, te ammag chàyu hen namchit hen anchichay profeta, ya chàyu agé hen namuntò hen anchichay hennag Apudyus way manudtuchu an chàyu. Hen laychê koma, an-og hahallimunan yanggay chàyu way kaman hen anchi cha ekaman hen manò way manahàufu hen anàna, ngém anyu ammag a-adchiyén. ");
INSERT INTO blw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wat ad uwan, an-ayug egad te taynan chàyu an Apudyus. Wat hen ifagà an chàyu, manepod ad uwan, maid kasen mangil-il-anyu an haén ingganah pegwana way yachi hen mangaryanyuwén, ‘Chayawéntaaw hen anchi ummale way hennag Apudyus.’ ” ");
INSERT INTO blw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Angkay hen-argawan way Safachu way ngilin chillu, na-ayagan ah Jesus ah faréy hen ihay nangato way Fariseo way i mèan an chicha. Ya hen anchichay tataguhchi, chacha i sepsepotan hiya no henon ammaana ");
INSERT INTO blw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","te wacha agéhchi hen ihay larae way natayyungaw. ");
INSERT INTO blw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yachi yag inimoh Jesus hen anchichay Fariseo ya hen anchichay cha mintudtuchu hen orchin way mangaliyén, “Chàyu kay, ay marabseng hen orchintaaw no ka-anén hen saket hen uray ngilin way Safachu.” ");
INSERT INTO blw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yag anchag achin ale. Wat inégnanan Jesus hen anchi chan saket yag kena-anna hen saketna yag annaat ifaga way omanamot. ");
INSERT INTO blw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yachi yag annaat agé ekat hen anchichay chan sepsepotén, “Hamham-ényu ngén, te no mag-ah hen anàyu ono uray lawa fakayu hen fito way netongpo hen ngilin, ay ammoh achiyu chillu i aran.” ");
INSERT INTO blw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wat anchag netopò hen anchichay tatagu way achicha makasongfat. ");
INSERT INTO blw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Angkay hiyachi, enlasin Jesus way hen tapen anchichay inimfitar hen anchi Fariseo, chacha paat piliyén hen anchi am-ammay way tùchu ah tumùchuwancha. Wat tinugun Jesus chicha amin way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“No ma-ayaganta way mèlagsak, achita koma ammag i tumùchu hen anchi kapatigan way tutùchuwan, te magat wachay na-ayagan ah nangatngato no chita, ");
INSERT INTO blw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","yag antag mafiinan way térén no umale hen anchi nangayag an chita yag ekatnéén, ‘Pasinsiya, a ta iyuyam hen antoy tummutùchuwam ta tumùchuwan hen anchi nangato way tagu.’ Wat ammag kaskasen hen kafiinan way man-aton way i tumùchu hen anchi pengetna. ");
INSERT INTO blw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wat hen ekaman koma, no ayagan chita way mèlagsak, anta lawa an i pomepenget way tumùchu ta egad hen anchi nan-ayag way mangaliyén, ‘Umaleahto te antoyan hen am-ammayay tùchuwam.’ No hiyachi hen mekaman, machayawta hen sangwanan hen amin anchichay tapen hen naimfitar. ");
INSERT INTO blw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Te heno way mangempachayaw hen acharna, ammag mepafafa chillu. Waman hen anchi mangempafafa hen acharna, hiya hen machayaw.” ");
INSERT INTO blw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Angkay hiyachi yag ekat Jesus agé hen anchi nangayag an hiya way mangaliyén, “No mamparteta way manlagsak, achi ammag cha ayagan yanggay hen anchichay inib-a ya sosnod ya hen anchichay fafaknang way atògong, te chicha, érégcha way somofalet wat kaman an mafayachan hen anchi enkaman an chicha. ");
INSERT INTO blw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ta hen ekaman no manlagsakta, ayagan hen anchichay maid mafalinna ya hen anchichay nan-appelay an cha nan-abfurag, ");
INSERT INTO blw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","te no yachi, wat antag mabindisyunan te achicha makasofalet, wat ah Apudyus hen mangchat ah sofaletna hen anchi man-uchiyan hen ammayay tagu ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Angkay hiyachi way chengngar hen ihay cha mèan an Jesus hen anchi intugunna, annaat ekatén, “Amchan tot-owa hen layad hen anchichay mèlagsak hen mantorayan Apudyus ad uchu.” ");
INSERT INTO blw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yag anat songfatan Jesus hiya ah pani way mangaliyén, “Hen-argawan ano, wacha hen ihay tagu way ekatnéén ammaana hen ammag chakaray lagsak, wat inimfitarna agé hen chuaray tatagu way umale koma way mèlagsak. ");
INSERT INTO blw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Angkay narpas way nesagana amin hen egad, hennagna hen anchi alepanna way i mangimfaga hen anchichay ini-imfitarna ta umalecha te nesagana hen egad. ");
INSERT INTO blw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ngém hen anchichay nai-imfitar, an ihéén nanlason ah achina ayan. Hen iha, ekatnéén, ‘Wacha hen an-owat lenàwan way lota yag masapor iyà paat ilan hen karotana, wat panga-asem paat ta pasinsiyéénà.’ ");
INSERT INTO blw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yag hen iha agé, ekatnéén, ‘Haén, an-owat lenàwan hen hemporo way faka, wat éy-ochi way i mangila hen kafakacha, wat panga-asem paat ta pasinsiyéénà.’ ");
INSERT INTO blw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yag hen iha agé, ekatnéén, ‘Ana-at ommahawa wat yachi hen maid umale an haén.’ ” ");
INSERT INTO blw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Angkay hiyachi yag namfangad hen anchi alepan yag henaphapetna amin chachi hen anchi apona. Yag ammag ommaningarngar hen anchi ap-apo, yag annaat ifaga hen anchi alepanna way mangaliyén, ‘Ag-aggagém ta éméy-aat hen kacharacharan ya hen korsa hen antoy fabréy yag uray heno way ichaham, ayagam amin chicha ta umalecha way i mèlagsak way uray hen anchichay maid mafalinna ya nan-abfurag ya nan-appelay.’ ” ");
INSERT INTO blw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Angkay narpaschi, yag kasen namfangad hen anchi alepan way mangaliyén, ‘Apo, na-ammaan tot-owa hen imfagam, ngém wacha chillu hen maggawan non an wachay umale.’ ");
INSERT INTO blw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yag anat agé ekat hen anchi ap-apowén, ‘Wat kasen-a éméy way uray hen anchi anachawwéy way lugar ingganah penget chi lota, yag im à-aro-on paat hen tatagu ta umalecha paat way i mèlagsak ta mapno koma hen antoy faréy-o. ");
INSERT INTO blw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Te hen ifagà an chàyu, maid angkay paat iha hen anchichay pés-éy naimfitar ah manemhem hen antoy nesagana.’ ” ");
INSERT INTO blw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Angkay hen-argawan way anchag chuar hen anchichay tatagu way cha metnod an Jesus, ammag nanhagong ah Jesus an chicha yag ekatnéén, ");
INSERT INTO blw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Heno way tagu way manlayad way mamfalin ah pasorot-o, masapor chakchakkar hen layadna an haén no hen layadna hen chinàcha-arna ya ah ahawana ya hen a-anàna ya hen sosnodna ya uray hen acharna, te no faén, achi mafalin way mampasorot-o. ");
INSERT INTO blw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ya heno way tagu agé way achina maetorochan hen aminay ligat hen somorotana an haén tàén yachi hen iyatéyna, wat achi agé mafalin way mampasorot-o. ");
INSERT INTO blw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yato hen kapaniyana,” way ekat Jesus. “Non an umat yag wachay manlayad way mangempa-amma ah chakaray faréy, ay ammoh achina ham-éham-én unna hen gastosna ta ilana no érégna hen pelakna ah mangenhènad hen hiyachiy faréy. ");
INSERT INTO blw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Te non an umat yag inlugina way manà-ad yag na-aminat hen pelakna way achi makarpas, wat ammag am-amrangén amin hen anchichay nangi-ila an hiya te korang hen mafalinna. ");
INSERT INTO blw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Yag penelohcha way mangaliyén, ‘Hen yatoy taguwat inlugina way mangamma ngém iggay peet makahènad.’ ");
INSERT INTO blw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ya hen ihay panina agé,” way ekat Jesus, “no wacha hen ihay Are way hemporoy lifu hen sorchachuna, achina ammag iligwat way i mìgufat hen anchi ahen-arena way chuwamporo way lifu hen sorchachuna, no achina ham-éham-én unna no érégna way maka-afà hen anchi kafusorna ono achi. ");
INSERT INTO blw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ngém no elasinna way achicha kafaelan way mangafà, homnag ah iha way i mangentar-éd hen anchichay kafusorcha hen kawad-ancha ah achawwéy ta ifagana no heno hen laychéncha ah mantetempoyugancha. ");
INSERT INTO blw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wat pachongna agé,” way ekat Jesus, “way hen anchi mangaliyén somorot an haén, masapor manhamahamà unna, te achi mafalin somorot hen anchi tagu an haén no achina iyanggayan hen amin way wacha an hiya.” ");
INSERT INTO blw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kasen nampani ah Jesus ah miyaligan hen anchichay cha somorot an hiya ah kaman ahin, ekatnéén, “Ammay met hen ahin te wacha hen kausarana. Ngém non an maka-an hen kenapaketna, ammag maid én-énnén way kasen mangempapaket. ");
INSERT INTO blw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wat ammag maid sérfina te uray iyafunu wat achi mausar, wat an yanggay metap-ar. Chengngaryu hen antoy chà ifaga te naingaan-ayu, wat ma-awatanyu koma hen laychénay aryén.” ");
INSERT INTO blw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Angkay hen-argawan way incha mì-igngar an Jesus hen anchichay cha mangam-among hen furor ya hen anchichay tapenay napepeloh way tatagu, ");
INSERT INTO blw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","wat anchag chan ngangayutongot hen anchichay Fariseo ya umat agé hen anchichay siguchay cha mintudtuchu hen orchin Moses, ekatchéén, “Pakay hay taguwanna way ammag cha mì-ib-ifun hen anchichay menangfasor ya cha amin mèan an chicha.” ");
INSERT INTO blw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yachi yag anat mampani ah Jesus an chicha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Chàyu ngay, non an umat yag wacha an chàyu hen hinggasot chi karnerona yag natarà hen iha, ay ammoh achina ngén taynan hen anchi siyamporo ya siyam ah péchag ta ina anapén hen anchi ihay natarà ingganah ichahana. ");
INSERT INTO blw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yag no ichahana ya gapoh laylayadna, annag fu-uchun way mangenhàyat. ");
INSERT INTO blw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yag yachi way enhàyatna, annag amongon hen anchichay ifana ya atògongna way mangaliyén, ‘Lomaylayadtaaw te inchahà hen antoy natarà way karnerò.’ ” ");
INSERT INTO blw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yag anat ekat Jesusén, “Pachongna agé way kaskasen hen layad hen anchichay ini-inggaw ad uchu hen mamfafawiyan hen ihà-anay menangfasor no hen layadcha hen anchichay siyamporo ya siyam way ammayay tatagu way achicha masapor way mamfafawi.” ");
INSERT INTO blw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Entoroy Jesus way mampani, ekatnéén, “Yag non an umat yag wacha agéy ihay in-ina way hemporo hen faletòna, yag non an gag-ara yag tenêchégna hen iha, ay ammoh achina entég hen helaw yag annaat hagahagachan hen faréyna ah manganapana ingganah ichahana. ");
INSERT INTO blw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yag no inchahana agé, ayagana hen anchichay ifana ya atògongna way mangaliyén, ‘Antaaw ammag lomaylayad te antoy inchahà hen anchi faletò-o way natarà.’ ");
INSERT INTO blw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wat kaman agéhchi,” way ekat Jesus, “hen lomaylaychan hen anchichay anghel Apudyus hen mamfafawiyan hen uray ihà-anay menangfasor.” ");
INSERT INTO blw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Entoroy Jesus way mampani, ekatnéén, “Hen-argawan ano, wacha hen ihay am-ama way chuwa hen anàna way pahig larae. ");
INSERT INTO blw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yag ekat hen anchi uchichiyén, ‘Ama, idchatnowat koma ad uwan hen tawid-o.’ Wat hiyachi yag nan-agwéén amacha hen kok-owana wat empàchangna hen anchichay chuway anàna.” ");
INSERT INTO blw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Angkay hiyachi way nanlooh hen kamanay ag-agaw, enlaon hen anchi enawchi hen aminay penakafingayna yag lommayaw way émméy ah achawwéy way lota, yag annag lenamram amin hen laon hen kok-owana ah lenoroko. ");
INSERT INTO blw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Angkay hiyachi way na-amin hen amin way wacha an hiya, niyaphor way nabtel hen hiyachiy lota way achi mawitwitan wat nakorangan way térén. ");
INSERT INTO blw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yachi yag ammag nepapelet way i mèlabfu hen ihay tagu hen hiyachiy lota, wat piniyarcha hiya way i mampangpangan hen fafuy ah péchag. ");
INSERT INTO blw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yag gapoh henaangna, uray hen anchi fungan hen away way cha anén hen fafuyén laychénay mangan non an mafalin, te ammag maid umidchat an hiya ah ma-an.” ");
INSERT INTO blw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Angkay na-awni way inumchah hen hamhamàna, yag annaat ekatén, ‘Amin hen anchichay chan labfu an Amaat homahawar hen chacha anén, yag antoyana-at ahto way ammag tég-angay matéy ah henaangna. ");
INSERT INTO blw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aẁ, ana-at chillu mamfangad an Ama ayong.’ Wat hen ifagà an hiya, ekat-owén, ‘Ama, nakafasorà an Apudyus ya nakafasorà agé an hea, ");
INSERT INTO blw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","wat uray no achì karébféngan way mifilang ah anàno, anà lawag aran ah mèlabrabfu an hea.’ ");
INSERT INTO blw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yachi hen ekatna ah hamhamàna yag annaat iligwat way éméy an amana.” “Angkay hiyachi way niya-adchawwéy way cha-an chillu umchah ah fabréy, enlarasinat agé amana way anàna peet hen anchi naway yag ammag naség-angan way nangila an hiya. Wat anat managtag way i nanib-at yag finàwarna ah layadna. ");
INSERT INTO blw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yachi yag anat man-ale hen anchi anàna way mangaliyén, ‘Ama, nakafasorà an Apudyus ya hea, wat achì tot-owa karébféngan way mifilang ah anàno.’ ");
INSERT INTO blw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngém chaat agé ekat amana hen anchichay alepannéén, ‘Aggagényu way manginyale hen anchi ka-am-ammayan way lumfong ah ilumfong hen antoy anào. Yag iyaleyu agé hen anchi sapatos ta mansapatosna ya hen sengseng ta mansengseng. ");
INSERT INTO blw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yag anyuwat i aran agé hen anchi tabtafà-an way ubfu yag penarteyu ah manlagragsakantaaw. ");
INSERT INTO blw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Te hen antoy anào, ekat-owat no natéy yag natattagu peet, yag ekat-owat no tarànachi yag antoyan peet way nachahan. Yachi yag inlugicha way manlagragsak.’ ” ");
INSERT INTO blw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Angkay hiyachi, niyaphor way i hommepot hen anchi pangorowana. Yag yachi way cha homàyat way cha homag-én ah faréycha, chengngarnaat agé hen anchichay chan kankanta ya cha mamattong. ");
INSERT INTO blw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yag annaat ayagan hen ihay alepancha way mangimoh an hiya no heno hen anchi chacha ammaan. ");
INSERT INTO blw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yag ekat hen anchi alepanén, ‘Hommàyat hen anchi enawchim wat empaparten amayu hen anchi tabtafà-an way ubfu ah laylayadna hen hommàyatana way étégna peet way natattagu ya maid laweng ah nepasamak an hiya.’ ");
INSERT INTO blw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yachi yag ammag penomtok hen anchi pangorowana yag nanggat wat ammag achi hénggép ah faréy. Wat ginumhad ah amana way i nangà-arò an hiya. ");
INSERT INTO blw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngém annag senongfatan ah amana way mangaliyén, ‘Ilam ngén, ah kamanay tawén, anà yanggay ammag kaman alepan an hea way chan amma-amma way maid amin lenabrabseng-o ah imfagam, yag maid paat agé ekatnowén epartiyam haén ah uray lawa an anà chi gancheng ah elagsak-o hen inib-à. ");
INSERT INTO blw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ngém angkay hommàyat hen annay naroko way anàno way annag lenamram amin hen kok-owam ah pota yag hiyaat agé hen empartiyam hen anchi tabtafà-an way ubfu.’ ");
INSERT INTO blw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Anào,’ way ekat amana, ‘hea, an-ag wawà-acha an haén wat amin way wachan haén, awam amin. ");
INSERT INTO blw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngém ad uwan, masapor manlagsaktaaw ya lomaylayadtaaw te gappiyana ah natagu peet hen annay enawchim way ekat-o nog natéy, ya ammay te namfangad te ekat-owat agé nog tarànachi.’ ” ");
INSERT INTO blw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Angkay hiyachi yag kasen nampani ah Jesus hen anchichay pasorotna, ekatnéén, “Hen-argawan ano, wachan ihay faknang way tagu way nangimpiyar amin hen egad hen ihay cha mèlabfu an hiya. Ngém chengngar hen anchi faknang way ammag cha lamramramén peet hen anchi piniyarna hen kafinaknangna. ");
INSERT INTO blw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wat empa-ayagna hiya yag annaat ekatén, ‘Nokay ngata hen annay chà changrén way ekatchéén cham ammaan. Wat ayé ta elestam amin hen enammaam mepanggép hen napiyaram te eparyaw-o angkay hea.’ ");
INSERT INTO blw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wat ammag chan hamahamà hen taguwanchi ah ekamanna. Yag annaat ekatén, ‘Nokay lawa hen én-énnê way matagu hen antoy chaà eparyaw hen antoy apò, te nakapsotà met way homepot ya afifiin met amin hen mampalemmos. ");
INSERT INTO blw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yato uwa hen ammaà ta uray no eparyawà hen chà mèlabfuwan, mafalin chillu way epaghépà ah tapen chi faréy.’ ");
INSERT INTO blw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yachi yag annaat ayagan amin hen anchichay nakautang an apona, yag annaat ekat hen anchi ihéén, ‘Kamana hen utangno hen anchi apò.’ ");
INSERT INTO blw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yag imfagana way hinggasot way lata way lana. Wat anat ekat hen anchi neparyawén, ‘Yato hen lestaan hen utangno wat pelmaam ta antag késsayan ta an yanggay lemanporo way lata hen utangno.’ ");
INSERT INTO blw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yag imfagana agé hen anchi iha way mangaliyén, ‘Kamana agé hen utangno hen apò.’ Yag imfagana way henlifuy futong way fégah. Yachi yag ekat agé hen anchi neparyawén, ‘Antoyan hen papel hen utangno wat pelmaamat ta kàka-ananta ta an yanggay warunggasot hen fayacham.’ ” ");
INSERT INTO blw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Angkay hiyachi way na-awni yag enlasin hen anchi ap-apo hen kenasilib hen anchi neparyaw wat chinayawna hen kenaraengna way cha manginyanap ah pagsaya-atana ah tapen chi ag-agaw.” Yachi yag anat ekat Jesusén, “Tot-owa way hen anchichay achi omafurot an Apudyus, kaskasen hen kenaraengcha mepanggép hen ekamancha hen antoy ataguwan ad uwan no hen anchichay cha omafurot.” ");
INSERT INTO blw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Entoroy Jesus way manugun an chicha, ekatnéén, “Hen itugun-o an chàyu, usarényu hen kafinaknangyu hen antoy lota ah mangin-ifaanyu ah tapena ta no marpas hen kausarana wat epaghép chàyu ad uchu.” ");
INSERT INTO blw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Heno way natalek way mangchén hen anchi akettoy way nipiyar an hiya, wat matalek agé way mangchén ah chakar. Ya pachongna agé hen anchi chan kétém ah uray aket, kapeletan way mankétém agé ah chakar. ");
INSERT INTO blw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Wat no achiayu matalek way mangchén hen pelak hen antoy lota, wat kaskasen agé way achiayu matalek way mangchén hen tot-oway kafinaknang ad uchu. ");
INSERT INTO blw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te no an-ayug achi matalek way mangchén hen kok-owan hen tapena, ay ammoh wachay midchat an chàyu ah mankok-owayu ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yachi yag kasen nampani ah Jesus way mangaliyén, “Hen alepan, achi mafalin way chuwa hen omapowana, te kapeletan way laylaychéna hen iha yag agorgorana agé hen iha. Ya pelet way tàchégana hen iha yag penelohna agé hen anchi iha. Wat pachongna agé no pelak hen napateg an hea, achi angkay agé mafalin way patigém hen laychén Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hen nangngaran hen anchichay Fariseo hen anchi intudtuchun Jesus, anchag enam-amrang hiya, te laylaychéncha paat hen pelak. ");
INSERT INTO blw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wat anat ekat Jesus an chichéén, “Chàyu, anyu yanggay an cha epàpàila hen kaenammayyu ah sangwanan hen tatagu, ngém inni-ilan chillu Apudyus hen tot-owa way wachah hamhamàyu. Te hen anchi chayu patpatigén paat way tatagu, wat ammag aggarémhachi an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Entoroy Jesus way mangaliyén, “Hen orchin Moses ya hen ensorat hen anchichay profeta, wat cha natongpar ingganah ummaliyan Juan way namfunfunyag. Yag yachi way ummale ah Juan, cha mepagngar hen anchi ammayay chamag mepanggép hen mantorayan Apudyus ya chuarcha hen mangempapelet way metape. ");
INSERT INTO blw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngém achiyu ammag cha ekatén miyat-atob hen uray anchi ka-akettoyan way orchin Apudyus, te narakrakaat agé hen antoy lota ya ad uchu ah maumah no hen anchi ka-akettoyan way orchin Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yag ekat Jesus agéén, “Heno way larae way manginhiyan hen ahawana yag enahawana hen safali, chagchagasnachi hen anchi inyatobna. Ya heno agé way mangahawa hen anchi inhiyanna, wat chagchagasnachi agé.” ");
INSERT INTO blw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Angkay hiyachi way cha etoroy Jesus way mantudtuchu, ekatnéén, “Hen-argawan ano, wachan ihay tagu way ammag faknang ya a-anammay way térén hen lumfongna ya ammag chan lamram-ay ah enag-agaw. ");
INSERT INTO blw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yag wacha agéhchi hen ihay kapos way ammag maid paat mafalinna ya ammag nagguligulid hen acharna way ah Lazaro hen ngachanna. Ah Lazaro, enag-agaw way ammag i-inggaw hen anchi hawang hen faknang ");
INSERT INTO blw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","way cha lawa manhéhhééd no chichana yag wachay mag-ah ah fugtan hen anchi faknang ta wachay manhah-aliwana ah henaangna. Ya uray agé hen anchichay ahowén, chacha hemotan hen gulidna.” ");
INSERT INTO blw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Angkay hen-argawan yag natéy hen anchi maid mafalinna yag enlayaw hen anchichay anghel hiya, wat incha inchapat an Abraham way mèlagsak ad uchu. Yachi yag natéy agé hen anchi faknang yag inlufùcha, ");
INSERT INTO blw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","wat émméy ad Hades way iggaw hen natéy way ammag cha mapap-aligatan way térén.” “Angkay hiyachi way nantangad hen anchi faknang, enlasinna ah Abraham hen achawwéy ya ah Lazaro way nichachapatat agé an hiya. ");
INSERT INTO blw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yag anat man-ongaw way mangaliyén, ‘Apo Abraham, ség-anganà paat ta epalem koma ah Lazarowanna ta uray lawa annag esawsaw hen limanah chanum yag empatedtedna hen antoy tapào ah téménéngan lawa hen chilà te anà ammag napàgang way térén hen antoy pétang hen apoy.’ ");
INSERT INTO blw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngém ekat Abrahamén, ‘Anào, ay naliw-am hen natatagguwam hen lota way pahig ammay hen wacha an hea. Waman hen natatagguwan Lazaro, ammag pahig lawa ligat hen wacha an hiya. Ngém ad uwan, layyalayyad ah Lazaro ahto. Waman hea, an-ag cha mapap-aligatan. ");
INSERT INTO blw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yag faén agé anggaychi te maid chillu én-énnénni way umalehna, te annayan hen chakaray téfang way nanohorchà an chitaaw, wat uray wachan manlayad way gumchang ahna, achi chillu mafalin te maid ayéna. Ya umat agé hen heno way wachahna, achi agé makadchang ahto.’ ");
INSERT INTO blw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yachi yag anat ekat hen anchi faknangén, ‘Wat no yaha, Apo, pangpanga-asem paat ta epééyno ah Lazaro ah faréy cha Ama ");
INSERT INTO blw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","te wachacha hen lemay sosnod-o, ta ina koma warnengén chicha ta falewancha hen a-ammacha ta achicha koma mepalehto hen antoy iggaw hen amchanay ligat.’ ");
INSERT INTO blw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ngém ekat Abrahamén, ‘Oo a, ngém wà-acha met hen anchi ensosorat Moses ya hen anchichay profeta ah kawarnengancha koma no ancha an changrén.’ ");
INSERT INTO blw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Oo tot-owa Apo,’ way ekat hen anchi faknang, ‘ngém awni yag achicha afurotonchi. Ngém non an paat wachay nan-uchi ah natéy ah i mangimfaga an chicha, awni yag manchùgancha hen anchi lawengay a-ammacha.’ ");
INSERT INTO blw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ngém ekat agé Abrahamén, ‘No achicha afuroton hen ensorat cha Moses ya hen anchichay profeta, tàén no wachay man-uchi ah natéyat achi chillu ma-awis hen hamhamàcha.’ ” ");
INSERT INTO blw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Angkay hiyachi yag ekat Jesus hen anchichay pasorotna way mangaliyén, “Wacha tot-owa hen mekaman ah ma-awisan hen tatagu ah manùgancha an Apudyus. Ngém ammag ka-as-ase way térén hen anchi tagu way ommawis ah fumasoran hen tapena, ");
INSERT INTO blw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","te wadwadcha hen machusaana ah pegwana no hen metàchan hen fato ah fagangna yag netap-ar ah fayfay no hen anchi mangammaana ah fumasoran hen anchi uray nakapsot hen afurotna. ");
INSERT INTO blw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wat ar-arwachanyu paat hen chayu ammaan.” “No fumasor hen ihay tagu an chàyu, amhiwényu, yag no changréna, pakawanényu. ");
INSERT INTO blw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ya uray mangappitu hen fumasorana an chàyu hen ihay ag-agaw ya mangappitu agé hen umaliyana way mangimfafawi, masapor pakapakawanényu chillu.” ");
INSERT INTO blw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Angkay hiyachi yag ekat hen anchichay aposel an Jesusén, “Apo, papegséém koma hen afurotni.” ");
INSERT INTO blw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yag anat ekat Apo Jesusén, “No wachay afurotyu ah uray kaman hen kachakar hen fukar hen mostasa, mafalin way ekatyu hen annay awayén, mahònot-a yag nimura-a ah fayfay wat ma-ammaan tot-owa.” ");
INSERT INTO blw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Entoroy Jesus way mangaliyén, “Non an umat yag wacha an chàyu hen wachay alepanna ah hommàyat way i nan-arachu ono i nan-achug ah karnero, ay ammoh ifagan hen anchi nangen-alepan an hiya way umalea ta in-a mangan. ");
INSERT INTO blw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Faénchi met hen ifagana te hen ifagana, ekatnéén, ‘In-an urah yag senokatam hen lumfongno ta ammay hen man-alekattowam ta panganénà unna yag an-aat mangan.’ ");
INSERT INTO blw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yag achi agé manyaman hen anchi nangen-alepan hen nangammaana hen aminay empa-ammana. ");
INSERT INTO blw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wat pachongna agén chàyu no enammaanyu amin hen imfagan Apudyus, achiyu ekatén an-ayug machayaw ta anyug ekatén, ‘An-ani lawa an alepan way anni yanggay an enammaan hen fiyangni.’ ” ");
INSERT INTO blw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Angkay hiyachi way cha éméy cha Jesus ad Jerusalem, chacha engwa hen namfattanan hen provinsiyan hen Samaria ya Galilea. ");
INSERT INTO blw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yag hen chacha homàyatan hen ihay fabréy, hinib-atcha hen hemporo way tatagu way nakkonet amin. Omma-adchawwéy hen anchichay hemporo way cha mangèngaw hen laychéncha, ");
INSERT INTO blw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ekatchéén, “Apo Jesus, ség-angam koma paat chàni.” ");
INSERT INTO blw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yachi way innilan Jesus chicha yag ekatnéén, “Inyu epàila hen acharyu hen anchichay papachi ah manot-owaana way naka-an tot-owa hen annachay saketyu.” Yag hen chacha manaranan way éméy, ammag naka-anat agé hen anchi saketcha. ");
INSERT INTO blw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yag hen anchi iha, hen nangil-ana way naka-an hen saketna, ammag nampangafangad paat way cha manakar hen alena way manayaw an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yag ammag nampalentomang hen henagong Jesus way chan yamayaman an hiya. Yag hen hiyachi paat agé way tagu, wat faén Judio te eSamaria way pepellohon hen anchichay Judio. ");
INSERT INTO blw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yachi yag anat ekat Jesusén, “Ay faéncha ngén hemporo hen anchichay naka-an hen saketna, wat chuudcha kay hen anchi siyam nò. ");
INSERT INTO blw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ay anggay yanggay peet hen antoy faén Judio hen namfangad way i manyaman an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yachi yag annaat agé ekat an hiyéén, “Tomàchég-a ta in-a, te gapon afurotno wat naka-an hen saketno.” ");
INSERT INTO blw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Angkay hiyachi yag senarudsud hen anchichay Fariseo an Jesus no kamana hen manginlugiyan Apudyus way mantoray. Yag anat ekat Jesusén, “Maid ustoh kail-an hen manginlugiyan hen mantorayana. ");
INSERT INTO blw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ya maid agé mangaliyén, ‘Ilanyu ngén, te antoyan hen mantorayan Apudyus ono anchiyan,’ te hen mantorayan Apudyus, wat mantoray ah hamhamà hen tatagu way maid mata ah makaila.” ");
INSERT INTO blw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Angkay hiyachi yag ekat Jesus hen anchichay pasorotna agéén, “Umchah hen tempo way gapon ligat, anyug laychén way térén way mangila koma hen mamfangchà, haén way Pangorowan hen Tatagu, ngém achiyu chillu ilan hen hiyachiy tempo. ");
INSERT INTO blw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wat no wachachay tatagu ah mangaliyén, ‘In-ayuhchi te wachahchi,’ ono ‘umaleayuhto te antoyan peet,’ wat achiayu paat cha éméy way i mangila. ");
INSERT INTO blw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Te hen mamfangchà way Pangorowan hen Tatagu, ammag maid achi mangila an haén hen hiyachi, te kaman yanggay koliyapyap way annag helawan amin hen egachay lota. ");
INSERT INTO blw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngém masapor unna pap-aligaténà hen tatagu way cha matagu ad uwan way achiyà mangiggéén an chicha ya anat umchah chachi. ");
INSERT INTO blw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yag hen ekaman hen tatagu hen mamfangchà way Pangorowan hen Tatagu, wat kaman hen nekaman hen tempon Noe. ");
INSERT INTO blw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Te hen anchi tempon Noe, anchag cha mangmangan ya umin-inum ya chan ah-ahawa way maid kasen hamham-éncha ingganah hinénggép cha Noe hen anchi papor way ammag maid ekat hen tataguwén wachan mepasamak yag nap-ongat agé amin hen antoy lota yag naoforcha amin. ");
INSERT INTO blw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yag kaman agéhchi hen nekaman hen tempon Lot, te wéhchi agéén cha mangmangan ya cha umin-inum ya chan ahelàrào, ya chacha agé manmumura ya man-am-amma ah faréy ");
INSERT INTO blw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","inggana hen anchi ag-agaw way lommayawan cha Lot hen fabréyanchi ad Sodoma. Yag yachi way maid ekat hen tataguwén wachay mepasamak, yag ammag niyuchanat agé hen apoy ya fummafara way asufre way narpod uchu, yag ammag neopoh amin hen egad. ");
INSERT INTO blw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wat kaman agéhchi hen mekaman way maid ekat hen tataguwén wachay mepasamak yag namfangacha-at way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Hen hiyachiy ag-agaw, hen anchichay niyaphor way wachah chara, achicha hénggép unna way mangalekam hen alekaméncha. Ya hen anchichay niyaphor way hommepot agé, achicha agé hamham-én way homàyat ah fabréy. ");
INSERT INTO blw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Te yachi hen enkaman hen ahawan Lot way annag hehemmà paat hen kok-owana wat anchiyat ammag namfalin ah ahin. Wat achiyu cha ar-aliw-an hen nekaman an hiya.” ");
INSERT INTO blw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Hen anchi tagu way mangempapangég hen ataguwana hen antoy lota, matéy chillu. Waman hen anchi tagu way cha mangafurot an haén tàén yachin iyatéyna, midchat an hiya hen mannanayun way ataguwana an Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Hen ifagà an chàyu, non an umat yag lafi hen mamfangchà yag wacha hen nanchachapat way nanasséy, wat ma-ara hen iha ya mataynan hen iha. ");
INSERT INTO blw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yag mag-ay agé no wachay chan fayu ah chuway fufae, wat ma-ara agé hen iha yag nataynan agé hen iha. ");
INSERT INTO blw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yag no chuwacha agé hen hommepot, wat ma-ara hen iha yag nataynan agé hen iha.” ");
INSERT INTO blw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yachi yag inimoh hen anchichay pasorotna way mangaliyén, “Chuud hen ma-ammaan nahha, Apo.” Yag anat mampani ah Jesus way mangaliyén, “Hen anchi iggaw hen natéy, yachi hen ka-amongan hen anchichay kasole way mangissa hen natéy.” ");
INSERT INTO blw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Angkay hiyachi yag nampani ah Jesus hen anchichay pasorotna hen nangintudtuchuwana way ancha komag chan luwaluwaru way achi koma cha machischismaya hen hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ekatnéén, “Hen-argawan ano, wacha hen uwis hen ihay fabréy way ammag maid égyatna an Apudyus ya maid agé ifiinna ah ahentaguna. ");
INSERT INTO blw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Yag hen hiyachiy fabréy agé, wacha hen ihay nà-amfaro way ammag cha émé-éméy an Uwis way i mampatorong way mangaliyén, ‘Toronganà paat ta achiyà afaén hen anchi kakontarà.’ ");
INSERT INTO blw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ammag nafayag way achi pagan-anon Uwis hiya. Angkay hen anongohna way ammag nappég ah Uwis, ekatna ah hamhamànéén, ‘Tàén maid égyat-o an Apudyus ya uray maid iyafiin-o ah tatagu, ");
INSERT INTO blw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","an-o chillug torongan hen annay fufaeyanna te ammag homaliwa yag tenémpég agé ah cha umaleale.’ ” ");
INSERT INTO blw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Angkay hiyachi yag ekat Apo Jesus way mangaliyén, “Tàén lawengay tagu hen anchi uwis, hamham-ényu ngén hen anchi enkamanna. ");
INSERT INTO blw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wat ah Apudyus way ka-a-ammayan, ay achi kaskasen hen ekamanna way somofalet hen anchichay penelena way tatagu no anchag iyar-argaw ya enlabraficha way manchawat an hiya. Ay ammoh mampanaag ah Apudyus way manorong an chicha. ");
INSERT INTO blw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Hen ifagà an chàyu, ag-aggah yag tenoronganaat chicha. Ngém ah pegwana way mamfangchà way Pangorowan hen Tatagu, ay nanggilah wachay ichahà ah nangafurot an haén.” ");
INSERT INTO blw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Angkay hiyachi yag kasen nampani ah Jesus hen anchichay tatagu way anchag nanapnek ah kaenammaycha ya chachaat agé peet pelohon hen tapena. ");
INSERT INTO blw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ekatnéén, “Hen-argawan ano, wachacha hen chuway tatagu way nane-ed ah Templo way i manluwaru way hen iha, Fariseo, ya hen anchi iha, wat ihay cha mangam-among hen furor. ");
INSERT INTO blw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Angkay ah faréy, i tommanig hen anchi Fariseo yag inlugina way manluwaru way mangaliyén, ‘Apudyus, manyamanà te faénà kaman hen anchichay tapena way anchag cha gamgaman hen heno ya nangéttémcha ya chacha amin chumagchagas. Ya manyamanà agé te faénà laweng way kaman hen annay cha mangam-among hen furor. ");
INSERT INTO blw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Te haénat, chinuminggu way manlanganà ah chuway ag-agaw way achi mangmangan, ya chà amin fayachan an hea hen pagkaporon hen egachay wacha an haén.’ ” ");
INSERT INTO blw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Angkay hen anchi cha mangam-among ah furor, oma-adchawwéy way tommatàchég way achi paat mammuhmuhwat way mantangad te mafiinan, wat annag cha pagpagén hen faro-ongna ah mamfafawiyana hen fasorna. Yag ekatnéén, ‘Apudyus, anà ammag ség-angan koma paat an hea te menangfasorà.’ ” ");
INSERT INTO blw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yachi yag inyanongoh Jesus way mangaliyén, “Hen ifagà an chàyu, hen anchi ammayén Apudyus wat hen anchi cha mangam-among ah furor angkay, yag faénat agé hen anchi Fariseo. Te heno way tagu way mangempachayaw hen acharna, ammag mepafiin chillu. Waman hen anchi tagu way mangimpudnu hen karawengna, mepachayaw ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Angkay hiyachi yag wachacha hen anchichay cha manginyéy hen anàcha an Jesus ta tad-éna koma way mamindisyun. Ngém hen nangil-an hen anchichay pasorotna, anchaat agég cha amhiwén chicha. ");
INSERT INTO blw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yag chaat chillu ayagan Jesus hen anchichay ungunga, yag annaat ifaga hen anchichay ifana way mangaliyén, “Eparufusyu hen annachay ungunga ta umalecha an haén, te hen anchichay kaman an chicha, wat chichachi hen metape hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Te tot-owa hen antoy ifagà an chàyu way uray heno way tagu way achi mangempafafa hen acharna hen omafurotana an Apudyus way kaman hen kafafan hen antochay ungunga, wat achi angkay mafalin way metape hen mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Angkay hiyachi yag wacha hen ihay ponò hen Judio way émméy an Jesus way mangaliyén, “Heay ammayay Apo, nokay hen ammaà ta mètaguwà an Apudyus ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Pakay ekatnowén ammayà,” way ekat Jesus, “te maid met kasen ammay no faén yanggay ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yag innilam met chillu hen orchin Apudyus way achita cha chumagchagas ya achita cha pomatéy, achita cha mangakaw ya achi cha istiguwan hen faén tot-owa, ya masapor rispituwén hen chinàcha-ar.” ");
INSERT INTO blw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yag sommongfat hen anchi tagu way mangaliyén, “Oo ngén, tenongpar-o met amin chaha nanepod hen kaong-ongà.” ");
INSERT INTO blw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Angkay chengngar Jesus hen ekatna yag annaat ekatén, “An ihà-an peet yanggay hen korangno way masapor ammaam, wat im elao amin hen kok-owam yag inwarasno hen laona hen anchichay maid mafalinna, wat yachi hen marmuwan hen tot-oway kafinaknangno ad uchu. Yag an-aat umale way somorot an haén.” ");
INSERT INTO blw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngém hen nangngaranan nadchi, ammag ngommehpéy te hen hiyachiy tagu, ammag faknang way térén. ");
INSERT INTO blw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hen nangil-an Jesus hen tenomkarana, annaat ekatén, “Ammag naligat way térén hen metapyan hen faknang hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Te ammag narakrakaat agé hen homroan hen kafayu hen matan hen chagum no hen metapyan hen faknang an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yachi yag anat ekat hen anchichay nangngarén, “Wat no yahaat, ay nanggilah wacha paat laway ihah metape an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ngém ekat Jesusén, “Hen anchi achi mafalin ammaan hen tatagu, mafalin chillu ammaan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yachi yag anat ekat Pedro an Jesusén, “Ilam ngén chàni, te tenaynanni amin hen fabréyni gapoh sommorotanni an hea.” ");
INSERT INTO blw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Oo tot-owa,” way ekat Jesus, “yag hen ifagà an chàyu, heno way manaynan hen fabréyna ya ahawana ya sosnodna ya hen chinàcha-arna ya a-anàna ah manginwarawagana hen mepanggép hen mantorayan Apudyus, ");
INSERT INTO blw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wat chùchùar hen midchat an hiya hen antoy matatagguwana no hen tenaynana. Ya ah pegwana, mètagu agé an Apudyus ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Angkay hiyachi yag enet-én Jesus hen anchichay hemporo ya chuway pasorotna yag imfagana way mangaliyén, “Changrényu ngén, te hen antoy chataaw ayan ad Jerusalem wat ma-ammaan an haén way Pangorowan hen Tatagu hen aminay ensorat hen anchichay profeta ad namenghan. ");
INSERT INTO blw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Te meporangà hen anchichay faén Judio way anà ammag sénsén-én yag ininsortowà ya tenoppaanà, ");
INSERT INTO blw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","henapratanà ya ana-at narég pédtén. Yag hen anchi ma-atloy ag-agaw, man-uchiyà chillu.” ");
INSERT INTO blw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Imfagan Jesus aminchi ngém hen anchichay pasorotna, anchag iggay chillu ma-awatan hen imfagana te kaman paat netataro hen laychénay aryén wat achi éméy ah hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Angkay hiyachi way cha homag-én cha Jesus ad Jerico, wacha hen ihay nabfurag way tummutùchu hen penget hen korsa way chan pap-alemmos. ");
INSERT INTO blw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yag hen nangngarana hen chan lawhan hen anchichay chuar way tatagu, chana imohon no nokay hen cha ma-ammaan. ");
INSERT INTO blw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yag imfagacha way naway ah Jesus way eNazaret way manlooh. ");
INSERT INTO blw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yag nan-ongawat agé hen anchi nabfurag way mangaliyén, “Heay Jesus way ganà David, panga-asem paat ta ség-anganà.” ");
INSERT INTO blw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yag hen anchichay tatagu way cha mamangpango, iningarcha hiya way mangempaginang, yag chanaat chillu chakachakarén way man-ongaw way mangaliyén, “Heay ganà David, panga-asem paat ta ség-anganà.” ");
INSERT INTO blw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Wat entàchég Jesus yag empa-ayagna hen anchi nabfurag. Yag yachi way hommag-én, ekat Jesusén, ");
INSERT INTO blw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nokay hen laychém way ammaà an hea.” Yag ekatnéén, “Apo ta makailaà koma.” ");
INSERT INTO blw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yag anat ekat Jesusén, “Wat ta makaila-aat, te gapo ta manokchum haén wat maka-an hen finuragno.” ");
INSERT INTO blw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yag hen hiyachi, nakailaat hen anchi nabfurag yag anat metnod an Jesus way cha manayachayaw an Apudyus. Wat amin hen anchichay tatagu, chinayawcha agé ah Apudyus hen nangil-anchan nadchi way na-ammaan. ");
INSERT INTO blw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Angkay hiyachi way enengwan cha Jesus ad Jerico, ");
INSERT INTO blw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","yag wachahchi hen ihay tagu way ah Zakeo hen ngachanna way hiya hen ap-apon hen anchichay cha mangam-among ah furor, wat faknang. ");
INSERT INTO blw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yag ah Zakeo, laychéna paat way mangila an Jesus no heno paat hiya, ngém achi makaila gapon ka-attèna ya ah kachuar chi tatagu. ");
INSERT INTO blw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yachi yag nanagtag way mamangpango hen cha ayan cha Jesus yag ommayat hen ihay away ah mangil-ana koma an Jesus no manlooh. ");
INSERT INTO blw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yag yachi way nemamang ah Jesus hen anchi awayanchi, ammag nantangad way mangaliyén, “Zakeo, gumhad-aat man ta intaaw te masapor éméyà ah faréyyu ad uwan.” ");
INSERT INTO blw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yag ginumhachat tot-owa ah Zakeo way ammag amchan hen laylayadna way manmangili an cha Jesus. ");
INSERT INTO blw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ngém amin hen anchichay nangi-ila, anchag chan ngangayutongot way mangaliyén, “Pakay ammag cha i mampamangili hen faréy hen ihay nangakkaw.” ");
INSERT INTO blw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Angkay hiyachi way wachacha ah faréy, tommàchég ah Zakeo yag ekatna an Jesusén, “Apo, an-og idchat hen gudwan hen kok-owà hen anchichay maid mafalinna, yag heno way lenokrokkò way nangara, mangempatê chubliyén ya an-owat ifangad.” ");
INSERT INTO blw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yachi yag ekat Jesusén, “Chàyu way himfafaryan, hen hiyatoy ag-agawat nahara-an-ayu ah ketapyanyu an Apudyus, ya chàyu hen ustoy ganà Abraham. ");
INSERT INTO blw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te haén way Pangorowan hen Tatagu, hen ummaliyà hen antoy lota, ta iyà anapén hen anchichay laweng way tatagu ta hara-à chicha.” ");
INSERT INTO blw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Angkay hiyachi yag nampani ah Jesus hen anchichay mamangngar hen imfagana, te tég-angaycha umchah ad Jerusalem yag hen ekat hen anchichay tatagu, milugi ad uwan hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wat ekat Jesusén, “Hen-argawan ano, wacha hen ihay nangato way tagu way émméy ah achawwéy way lota way i mangara hen kena-arena, yag no mamfangad, ilugina way mantoray. ");
INSERT INTO blw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yachi way tég-angay lumigwat, enayagana hen anchichay hemporoy alepanna yag enadchana chicha ah hen-ih-ay faletò way pelak way mangaliyén, ‘Ilanyu a, ta pachuarényuto hen kamaid-o.’ ");
INSERT INTO blw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ngém hen anchichay tapen hen tatagu, anchag achi laychén hiya way térén, wat empaunudcha hen tapena way i mangimfaga way achicha ano paat laychén way hiya hen man-arecha.” ");
INSERT INTO blw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Angkay hiyachi way innaran hen anchi nangato way tagu hen kena-arena, namfangad, yag annaat epa-ayag hen anchichay alepanna way nangemporangana hen pelak ta ilana no heno hen enkamancha. ");
INSERT INTO blw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yachi yag ummale hen anchi iha yag ekatna way mangaliyén, ‘Apo Are, inyanà hen anchi ihay faletòno hen hemporo.’ ");
INSERT INTO blw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Usto paat hen annay enkamanno,’ way ekat Are, ẁat hea hen ammayay alepan yag gapo ta natalek-a way nangchén hen anchi akettoy, ipiyar-o an hea ad uwan hen hemporoy fabréy ah man-ap-apowam.” ");
INSERT INTO blw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Angkay hiyachi yag i nèsango agé hen anchi ihay alepanna yag imfagana way mangaliyén, ‘Apo Are, inyanà hen anchi ihay faletòno hen lema.’ ");
INSERT INTO blw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yag anat ifagan Are an hiya way mangaliyén, ‘Wat ipiyar-o agé an hea hen lemay fabréy ah man-ap-apowam.’ ” ");
INSERT INTO blw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Angkay hiyachi yag i nèsango hen anchi ihay alepanna agé way mangaliyén, ‘Apo Are, antoyan chillu hen anchi pelakno way enoppeopà yag enhahàfà, ");
INSERT INTO blw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","te émé-égyatà paat an hea te innilà way an-ag térén way tagu ya an-ag cha mèawa hen enlengatan hen tapena way kaman paat annog cha fat-én hen anchi iggayno enhamar.’ ");
INSERT INTO blw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yachi yag anat ekat Areyén, ‘An-ag laweng way alepan, yag hen annay cham aryén hen cha mangchat ya kail-an hen cham fumasoran te inni-ilam met way térénà way tagu way anà ammag cha mèawa hen enlengatan hen tapena yag an-og cha fat-én hen anchi iggay-o enhamar. ");
INSERT INTO blw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wat pakay iggayno lawa i imbangko hen anchi pelak-o ta wacha laway aket ah anàna ah arà hen antoy namfangchà.’ ");
INSERT INTO blw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yachi yag anat ifagan Are hen anchichay tommatàchég an nadchi way mangaliyén, ‘Aranyu hen anchi pelakna yag inidchatyu hen anchi nangchén ah hemporo.’ ");
INSERT INTO blw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Oo Apo,’ way ekatcha, ‘ngém wacha met hen hemporo an hiya.’ ");
INSERT INTO blw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Oo a,’ way ekat Are, ‘ngém hen ifagà an chàyu, hen anchi tagu way natalek way mangchén hen anchi wacha an hiya, an mataptapyanchi. Waman hen anchi tagu way achi matalek way mangchén hen wacha an hiya, ammag maunghor hen uray anchi ak-akettoy way wacha.’ ");
INSERT INTO blw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yachi yag anat ekat Are agéén, ‘Ya hen anchichay kafusor-o way achi manlayad way haén hen man-are, iyaleyu chicha ahto ta mepapchitcha hen sangwanà.’ ” ");
INSERT INTO blw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Angkay hiyachi way narpas hen penanin Jesus, entoroycha way éméy ad Jerusalem. ");
INSERT INTO blw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yag hen chacha homag-énan ad Betfage ya ad Betania way fabréy, entàchégcha hen pénad hen anchi filig way ekatchéén “Olivo,” yag hennag Jesus hen chuway pasorotna way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Epangpangoyu hen fabréyanchi way chichinmangtaaw yag hen homàyatanyu hen anchi fabréy, ichahanyu hen netatàéd way ubfun hen kafayu way cha-an masaksakayan. Ùfachényu yag inyaleyuhto. ");
INSERT INTO blw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yag mag-ay ta wachay mangaliyén pakay ùfachénha, ifagayu way mangaliyén, ‘Masapor hen apotaaw.’ ” ");
INSERT INTO blw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Angkay hiyachi way émméycha, inchahancha hen aminay imfagan Jesus. ");
INSERT INTO blw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yag hen chacha mangùfachan hen anchi ubfu, ekat hen anchi nangen-awa way mangaliyén, “Pakay anyug cha ùfachénha.” ");
INSERT INTO blw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yag ekatchéén, “Masapor hen Apotaaw.” ");
INSERT INTO blw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yag inyéycha an Jesus yag inyap-apcha hen agwan hen lumfongcha hen échég hen anchi ubfu yag empasakaycha ah Jesus. ");
INSERT INTO blw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yag hen cha ayan Jesus, enhapnà agé hen anchichay tapenay tatagu hen lumfongcha hen korsa. ");
INSERT INTO blw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Angkay hiyachi way tég-angaycha umchah ad Jerusalem way chachan éhég hen anchi filig way Olivo, inlugin amin hen anchichay chuaray cha somorot an Jesus way manayaw an Apudyus ya manyaman amin an hiya. Yag chinakarcha hen alecha ah layadcha way manayaw gapo hen aminay kaskascha-aw way innilacha way enammaan Jesus. Ekatchéén, ");
INSERT INTO blw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Antaaw ammag chachayyawén hen antoy Aretaaw way hennag Apudyus. Te gapon hiya, nètempoyugtaaw an Apudyus ad uchu, wat antaaw yanggay ammag chayawén ah Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yachi yag nan-ale hen anchichay tapen hen Fariseo way niya-ahrang hen anchichay tatagu, yag imfagacha an Jesus way mangaliyén, “Apo, paginangémat man hen annachay pasorotno te ammoh hea hen hennag Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yag senongfatan Jesus chicha way mangaliyén, “Hen ifagà an chàyu, machayawà ad uwan way machayaw, wat tàén no guminangchaat pelet way uray hen annachay fato wat èngawcha way manayaw an haén.” ");
INSERT INTO blw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Angkay hiyachi way hommag-én ah Jesus ad Jerusalem way maila hen anchi fabréy, annag kenelaan hen anchichay tataguhchi way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Chàyu way iJerusalem, non anyu koma ma-awatan ad uwan way ag-agaw hen korangyu ah mètempoyuganyu an Apudyus, ngém cha-anyu chillu elasin yag ammag looh nelooh. ");
INSERT INTO blw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Awniyat umchah hen mangalekomkoman chàyu hen kafusoryu, yag enakopcha hen nanliwliwéh hen fabréyyu way maid énnényu way omawid. ");
INSERT INTO blw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ya ancha agég chachaelén hen antoy fabréy ya amin agé way tatagu way ininggaw, wat ammag maid paat ihà-an ah matentenor-og way fato ah mehàfa te metap-archa amin. Ma-ammaan amin cha nahha an chàyu te anyug achi pagan-ano hen ummaliyan Apudyus way manorong an chàyu.” ");
INSERT INTO blw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Angkay hiyachi yag émméy ah Jesus hen fatawan hen anchi Templo yag inluginaat way mangemparyaw hen anchichay chan elàrao. ");
INSERT INTO blw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yag imfagana an chicha way mangaliyén, “Nesosorat hen inyalen Apudyus way ekatnéén, ‘Hen faréy-owat mausar ah manluwaruwan hen tatagu an haén.’ Yaha hen imfagan Apudyus, ngém chàyu, anyuwat agég namfalinén hen antoy faréyna ah chayu i manlokowan hen ahentaguyu.” ");
INSERT INTO blw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yachi yag enag-agaw way cha émé-éméy ah Jesus ah Templo way i mantudtuchu. Yag hen anchichay ap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin ya anat agé hen anchichay ponò hen tatagu, ancha amin ammag cha iyana-anap hen ekamancha way mamchit an hiya, ");
INSERT INTO blw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ngém maid én-énnéncha te amin hen anchichay tatagu, laylaychéncha way térén way mamangngar hen chana itudtuchu. ");
INSERT INTO blw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Angkay hen-argawan way wacha ah Jesus ah Templo way cha manudtuchu hen tatagu way mangempagngar hen anchi ammayay chamag mepanggép an Apudyus, émméycha an hiya hen anchichay ap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin Moses ya anat agé hen anchichay anam-ama way ponò hen Judio, ");
INSERT INTO blw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","yag finistigarcha hiya way mangaliyén, “Henon pam i ammaan hen annay cham ammaan. Yag heno ay paat agé hen nangidchat hen karébféngam way mangamma.” ");
INSERT INTO blw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yag sommongfat ah Jesus way mangaliyén, “Wacha agé hen sarudsuchù an chàyu unna wat songfatanyu. ");
INSERT INTO blw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Heno agé hen nangidchat hen karébféngan Juan way mamfunyag. Ay ah Apudyus ono ammag tatagu.” ");
INSERT INTO blw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yachi yag chacha mahalifunuwan way man-a-atopàpà way mangaliyén, “Nokay lawa hen ekattaaw, te no ekattaawén ah Apudyus hen nangidchat hen karébféngan Juan, wat ma-afàtaaw te awni yag ifagan Jesus no pakay iggaytaaw afuroton hen intudtuchun Juan mepanggép an hiya. ");
INSERT INTO blw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yag no ekattaaw agéén ammag tagu hen nangidchat hen karébféngan Juan way faén ah Apudyus, wat awniyat an chitaaw ammag funto-on hen annachay tatagu te a-abfurotoncha paat way profeta ah Juan.” ");
INSERT INTO blw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yachi yag anchag nanlason an Jesus way mangaliyén, “Tawwan te maid innilani no heno hen nangidchat hen karébféngan Juan.” ");
INSERT INTO blw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yag anat ekat Jesus agéén, “Wat no yaha, achì agé ifaga an chàyu no heno hen nangidchat hen karébféngà way mangamma hen chà ammaan.” ");
INSERT INTO blw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Angkay hiyachi yag nampani ah Jesus hen anchichay tatagu, ekatnéén, “Hen-argawan ano, wacha hen ihay tagu way nanmura hen lotana ah greps way chacha fayahén, yag annaat epa-afang hen anchichay tatagu yag anat lomayaw way émméy ah acha-achawwéy way lota. ");
INSERT INTO blw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Angkay hiyachi way inumchah hen tempon hen namungaan hen anchi nimura, hennagna hen ihay alepanna way i mangara hen penakafingayna. Ngém hen anchichay cha mangafang hen lota, anchag penagoh hiya ya anchaat eparyaw way maid inidchatcha. ");
INSERT INTO blw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yachi yag kasen agé hennag hen anchi nangenlota hen ihay alepanna, yag anchaat agég penagoh yag finibfiincha hiya ya anchaat agé eparyaw way maid inidchatcha. ");
INSERT INTO blw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tàén chilluchi, yag kasen agé hennag hen anchi nangenlota hen anchi ma-atlo. Ngém ancha agég fina-ag hiya yag entap-archa.” ");
INSERT INTO blw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Angkay hiyachi yag anat ekat hen anchi nangenlotéén, ‘Nokay lawa hen én-énnê. Wat yato hen ekaman-o, ta an-og hénagén hen antoy laylaychê way anào ta éhéd yag ifiincha hiya te anào tot-owa.’ ");
INSERT INTO blw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngém hen nangil-ancha agé hen anchi anàna, nan-a-atopàpàcha way mangaliyén, ‘Ayé, annayan tot-owa hen anchi ustoy mangentawid hen antoy lota, wat antaawat pédtén ta chitaaw hen mangen-awa.’ ");
INSERT INTO blw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wat chinpapcha yag inilhincha hen anchi arad way i mamchit.” Yachi yag ekat Jesus hen anchichay tataguwén, “Nokay ngata hen ekatyuwén ammaan hen anchi nangenlota hen anchichay cha mangafang nò. ");
INSERT INTO blw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kapeletan, a, way hiya paat hen mamfangad way i mamchit an chicha yag annaat epa-afang ah safali.” Yag ekat hen anchichay nangngarén, “Hiyaat koma non an maid ma-ammaan ah pachongnaha.” ");
INSERT INTO blw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yag finéfétég Jesus chicha way mangaliyén, “Wat no achi ma-ammaanha, nokay hen ekatyuwén metorongan hen anchi nesosorat ad namenghan nò way ekatnéén, ‘Hen anchi fato way enachin hen anchichay chan sà-ad ah faréy way ekatchéén maid sérfina, wat ammag yachiyat agé hen kapatpatigan ah mepégnad.’ ");
INSERT INTO blw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Heno way tagu way màchég hen hiyachiy fato, ammag mapmaptén. Ngém no hen anchi fato agé hen meposet hen ihay tagu, wat ammag matampò way kaman chapor.” ");
INSERT INTO blw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hen nangngaran hen anchichay ap-apon hen papachi ya hen anchichay cha mintudtuchu hen orchin hen anchi penanin Jesus, anchag laychén way manelew an hiya hen hiyachi, te enlasincha way chicha hen penanina. Ngém iggaycha chillu te chacha émégyat hen anchichay chuaray tatagu. ");
INSERT INTO blw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Angkay hiyachi yag chacha anapén hen mawayaancha way manlokop an Jesus, wat penasoksokancha hen tapen hen tatagu way i mangentot-owa way mansarudsud, te hen laychéncha, mèfat koma ah Jesus ta wachay énnéncha way manginchérém hen anchi gubérnador. ");
INSERT INTO blw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wat émméy hen anchichay i mane-em an Jesus way mangaliyén, “Apo, innilani way usto hen cham itudtuchu ya umat agé hen amin way cham aryén, ya innilani agé way achim wahigén hen tatagu, tàén heno hen kasasa-adna, te cham yanggay itudtuchu hen katot-owaan way laychén Apudyus an chitaaw way tatagu. ");
INSERT INTO blw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wat hen ifagani, ay achitaaw ngata labsengén hen orchintaaw way Judio no fayachantaaw hen furor hen anchi Are ad Roma.” ");
INSERT INTO blw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngém ah Jesus, enlasinna hen kenasilibcha yag annaat ekatén, ");
INSERT INTO blw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Iyaleyu kay chi ihah pelak ta ila-a.” Yachi yag annaat ekatén, “Nokay hen antoy nepepetchor an natto, ya nokay agé hen nangenngachan hen antoy nesosorat.” Yag ekatchéén, “Hen anchi Are met.” ");
INSERT INTO blw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yag anat agé ekat Jesusén, “Umpayat, no yaha, Are chillu peet hen nangen-awa, wat idchatyu kagé an hiya hen para an hiya. Ngém ilanyu agé ta idchatyu an Apudyus hen para an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wat hen anchichay i manlokop an Jesusat, anchag netopò wat anchag nahahaang way nangngar hen songfatna. Wat ammag maid én-énnéncha way mangamma ah omfatan hen alena hen sangwanan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Angkay hiyachi yag wachacha hen tapen anchichay Judio way ekatchéén Saduceo way achi mangafurot way man-uchi hen natéy ah pegwana. Yag émméycha an Jesus way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Apo, hen anchi ensorat Moses ad namenghan way orchintaaw, ekatnéén, ‘No wachay larae ah ommahawa yag natéy way maid anàna, masapor ahaw-én hen anchi sonod hen natéy hen anchi fufae way nafaro ta no wachay anàcha, yachi hen kaman penaka-anà hen anchi natéy ah metoroyan hen ganàna.’ ");
INSERT INTO blw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Angkay hiyachi ano, wachacha hen pituy larae way masosnod. Yag hen anchi pango, ommahawa ngém cha-ancha ummanà yag natéy. ");
INSERT INTO blw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wat hen anchi metéb, enahawana hen anchi nafaro, ngém cha-ancha ummanà yag natéy agé. ");
INSERT INTO blw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yag yaha agé hen nekaman hen anchi ma-atlo ingganah amin hen anchi pitu way masosnod, wat natéycha amin way maid anàcha yag yachiy fufae hen enahawacha amin way masosnod. ");
INSERT INTO blw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yag hen anongohna, natéy agé hen anchi fufae. ");
INSERT INTO blw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wat non an umat yag man-uchicha hen natéy ah pegwana, nokay hen ustoy mangen-ahawa hen anchi fufae, te amincha met way pitu wat enahawacha amin hiya.” ");
INSERT INTO blw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yachi yag ekat Jesus an chichéén, “Hen tatagu hen antoy lota ad uwan, man-ah-ahawacha. ");
INSERT INTO blw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ngém hen anchichay mifilang ah karébféngana way man-uchi way éméy ad uchu, achicha ma-ah-ahawa ahchi, ");
INSERT INTO blw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","te komamancha hen anchichay anghel way achi matmatéy ah ing-inggana. Wat chicha hen anà Apudyus te nan-uchiyéna chicha. ");
INSERT INTO blw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yag mepanggép hen man-uchiyan hen natéy, wacha hen niyale an Moses way tomot-owaan hen man-uchiyan hen natéy. Te hen anchi nesosorat way na-ammaan hen nangil-ana hen gummilafan hen away, ekatnéén, ‘Ah Apudyus, hiya hen cha chayawén cha Abraham an Isaac ya ah Jacob.’ ");
INSERT INTO blw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wat hen laychénay aryén, uray nan-atéy cha Abraham hen hiyachiy tempo, é-éttégcha chillu way natattagu ad uchu, te pakay wachacha way cha manayaw an Apudyus hen hiyachi nò.” ");
INSERT INTO blw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yachi yag hen tapen anchichay siguchay cha mintudtuchu hen orchin, ekatcha an Jesusén, “Apo, ammay hen annay songfatno.” ");
INSERT INTO blw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yaha hen ekatcha te maid torodcha way kasen man-imoh an hiya. ");
INSERT INTO blw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Angkay hiyachi yag ekat Jesus hen anchichay tataguwén, “Henon pacha ekatén, ‘Hen anchi epalen Apudyus hen antoy lota way Cristu wat hiyan ganà David.’ ");
INSERT INTO blw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Te uray met ah David, ensoratna hen anchi libnuna way Salmo way mangaliyén, ‘Ah Apudyus way Ap-apo, imfagana hen anchi Ap-apò way mangaliyén, Tumùchua hen antoy pachawanan-o ");
INSERT INTO blw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ingganah mangafaê hea hen amin anchichay kafusorno.’ ” ");
INSERT INTO blw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Entoroy Jesus way mangaliyén, “Wat no uray ah Are Davichén enawagana hen anchi Cristu ah ap-apona, wat nokay agé hen énnéna way hiya hen ekatchéén ganà David.” ");
INSERT INTO blw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Angkay hiyachi way chachan changar amin hen anchichay tatagu, tinugun Jesus hen anchichay pasorotna way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ar-arwachanyu ta achiayu komaman hen anchichay siguchay cha mintudtuchu hen orchin, te chicha, anchag laylaychén way cha manginggégga-ay hen anchichay anammay way lumfongcha. Ya anchag chan paraparamano hen u-umfunan hen tatagu ah mempàpàil-ancha way maririspitucha. Yag no mìyamongcha hen anchi chacha ka-am-amongan, anchag laylaychén way tumùchu hen anchi am-ammay paat way tùchuwan. Yag umat agé hen incha mèlagsakan wat hen tùchun agé paat hen nangato hen tumùchuwancha. ");
INSERT INTO blw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yag chacha agé usarén hen kenasa-adcha ah manlokkowancha hen nà-amfaro ah mamréhancha hen kok-owana. Ya chachaat i mampaspasekat way mangempa-anchu hen luwarucha. Wat anchag cha héphépén hen kachusaancha an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Angkay hiyachi way nanlangranga ah Jesus, innilana hen anchichay nan-afaknang way cha omentennag ah pelak hen anchi chacha mangententennagan hen pelak ah Templo. ");
INSERT INTO blw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yag annaat agé ilan hen ihay nà-amfaro way maid mafalinna way an yanggay chuway sentemos hen entennagna. ");
INSERT INTO blw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yachi yag ekat Jesusén, “Tot-owa hen antoy ifagà an chàyu way ifilang angkay Apudyus ah chakchakkar hen anchi entennag hen anchi maid mafalinna no hen anchi amin way entennag hen anchichay tapena. ");
INSERT INTO blw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Te hen anchichay tapena, inidchatcha yanggay hen tapen hen hommawar an chicha. Waman hiya, anna paat ammag enonghor way nangidchat hen amin way wacha an hiya ah usaréna koma ah iyataguna.” ");
INSERT INTO blw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Angkay hiyachi yag cha aryén hen tapen anchichay pasorot Jesus hen ka-ammay hen anchi Templo, te ammag chachanakkar hen challug way nausar hen nangammaancha, ya anat agé hen ka-ammay hen anchichay cha michaton ahchi. Wat ekat Jesusén, ");
INSERT INTO blw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Umchah hen ag-agaw way amin hen antoy mailayu wat machachael amin way ammag maid paat mehàfa ah uray ihah matentenor-og ah fato te meorobcha amin.” ");
INSERT INTO blw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yachi yag ekat hen anchichay pasorotnéén, “Apo, kamana hen umchahan hen anchi imfagam, ya nokay agé hen sinyarna no tég-angay mepachah.” ");
INSERT INTO blw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yachi yag ekat Jesusén, “Ar-arwachanyu paat ta achiayu marokop. Te fùnagcha angkay hen chuaray tatagu way ammag mangemparang hen acharcha way chicha ano hen anchi mamahhééd way hennag Apudyus way mantoray. Yag ekatcha agéén, ‘Inumchahat ad uwan hen tempona.’ Ngém achiyu paat cha soroton chicha. ");
INSERT INTO blw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ya achiayu agé cha émégyat no changrényu way wachay chan gugufat ya chan guguru. Te masapor chillu ma-ammaan cha nahha ngém cha-an chillu hen umchahan hen péppég chi ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yag entoroy Jesus way mangaliyén, “Hen mekaman, manggugufatcha hen egachay toray hen antoy lota. Ya hen ihay lomota agé, gufaténa hen henlomota. ");
INSERT INTO blw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yag umchah agé hen ammag amchanay lunig ya hen fitel ya anat agé hen chépar ah karotarota. Yag wachacha agé hen mepàila ad uchu way aggaégyat way sinyar way omenpahaang.” ");
INSERT INTO blw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ngém ta anat ma-ammaan amin cha nadchi, telewén chàyu ya pap-aligatén chàyu, ya michérém-ayu agé hen anchichay cha ma-am-amongan hen tatagu yag imfarud chàyu. Yag gapon ommafurotanyu an haén wat mepasangoayu hen a-are ya hen anchichay chan totoray. ");
INSERT INTO blw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yag yachiyat agé hen wayayu way mangimfaga hen anchi chamag mepanggép an haén. ");
INSERT INTO blw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Papannohonyu hen hamhamàyu ad uwan ta achiayu cha machanagan ah esongfatyu no umchahchi, ");
INSERT INTO blw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","te haén hen mangidchat hen iyaleyu ya ah kenaraengyu wat achicha makasongfat hen anchichay kafusoryu way anyug an afaén chicha amin ta maid én-énnéncha way komontara. ");
INSERT INTO blw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngém hen hiyachiy tempo chillu, uray hen chinàcha-aryu ya hen sosnodyu, hen a-anag-iyu ya hen anchichay ifayuwén inlémrém chàyu way manginchérém. Wat wacha hen tapena an chàyu way mepapchit. ");
INSERT INTO blw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yag an chàyug agorgoran hen aminay tatagu gapoh afurotyu an haén. ");
INSERT INTO blw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ngém tàénat achi chillu taytaynan Apudyus chàyu te uray hen himféras way fuùyu wat achi lawhan Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wat epapateyu paat ta mètaguayu an Apudyus ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Entoroy Jesus way mangaliyén, “No ilanyu way enalekomkom hen chuaray sorchachu ad Jerusalem, ma-awatanyu way tég-angay hen machachaelana ya hen ma-afa-an hen anchichay ininggaw. ");
INSERT INTO blw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wat masapor omawidcha ah filig hen anchichay ininggaw hen sakop hen Judea. Ya hen anchichay wacha ad Jerusalem, masapor mamfakwitcha. Ya hen anchichay aminay émméy ah émméyana, achicha homàyat ah fabréy. ");
INSERT INTO blw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Te hen hiyachiy tempo hen manusaan Apudyus hen egachay machusa ah tomot-owaan hen anchi nesosorat ad namenghan. ");
INSERT INTO blw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wat ammag ka-as-ase lawa hen anchichay nafufugi ya chan pasoso hen hiyachiy tempo te ammag maid achi mepachah ah ligat hen hiyachiy tempo, te yachin térén way manusaan Apudyus an chicha. ");
INSERT INTO blw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wat mepapchitcha hen tapena ya melayawcha hen tapena ah achawwéy way lota way i mifarud. Ya hen antoy fabréy hen Judio paat ad Jerusalem, ammag a-abfaén hen anchichay faén Judio ingganah péppégén Apudyus hen mantorayancha.” ");
INSERT INTO blw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Hen hiyachiy tempo agé, aggaégyat hen mekaman hen init ya hen hérag ya umat agé hen taraw. Ya hen antoy lota, maid mepaniyan hen égyat hen katagutagu te somafali hen fayfay way ammag pomegsa hen challuyunna ya magénén chummakar hen usarna. ");
INSERT INTO blw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ammag matarà hen hamhamà hen tatagu ah égyatcha hen mamannéchancha no heno hen kasen umchah hen antoy lota, te ammag makorkor agé hen egachay maila ad uchu. ");
INSERT INTO blw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yag hen hiyachiy tempo, haén way Pangorowan hen Tatagu, mamfangachà wat ilanà ah katagutagu way iyalen hen funat way anà ammag humili ah kena-apudyus-o ya mamàila agé hen mannakafalin-o. ");
INSERT INTO blw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wat no elasinyu way cha milugi cha natto way ma-ammaan, sésêmémyu ya papegséényu hen hamhamàyu te tég-angay hen kahara-anyu hen egachay ligat.” ");
INSERT INTO blw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Angkay hiyachi yag nampani ah Jesus an chicha way mangaliyén, “Ilanyu ngén hen annay away way fig ya hen tapen hen away agé, ");
INSERT INTO blw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","te no ilugicha way umutar, innilayu met way tég-angay hen tiyargaw te yachi hen sinyarna. ");
INSERT INTO blw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wat umat agé no ilanyu way cha milugi way ma-ammaan hen anchichay imfagà, ma-awatanyu agé koma way tég-angay umchah hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tot-owa hen antoy ifagà an chàyu way achicha amin matéy hen tatagu way cha matagu ad uwan wat ma-ammaan amin hen anchichay imfagà. ");
INSERT INTO blw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Te uray maumah amin hen maila ad uchu ya hen antoy lota, achi chillu miyat-atob hen antochay chà enale ah ing-inggana, te masapor ma-ammaan amin.” ");
INSERT INTO blw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Entoroy Jesus way mangaliyén, “Ar-arwachanyu paat ta achiyu pawadwad-én hen manlagragsakanyu ya hen chayu mì-in-inuman, yag ilanyu agé ta achi marafus hen chanagyu mepanggép hen problema hen antoy ataguwan ad uwan, te awni yag ekatyuwén cha-acha-an hen mamfangchà yag an-ayug makarégnat. ");
INSERT INTO blw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Te hen mamfangchà, ammag mepàrat hen aminay tatagu ah karotarota. ");
INSERT INTO blw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wat anyug hihimnén paat ya chayu chachawatén an Apudyus ta papegsééna hen hamhamàyu ta achiayu ma-afà hen amin anchichay mepasamak, ya ta ammay hen mèsangowanyu an haén way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hen hiyachiy tempo, enag-agaw way cha émé-éméy ah Jesus ah Templo way mantudtuchu. Wat no madhémén émméy hen anchi filig ad Olivo way i umiyan. ");
INSERT INTO blw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ya amin hen anchichay tatagu, anchag fumifiggat way éméy ah Templo way i mamangngar hen chana itudtuchu. ");
INSERT INTO blw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Angkay hiyachi yag tég-angay umchah hen tempon hen anchi lagsak way manganancha hen tenapay way cha-an fumnar way yachi agé hen anchi lagsak way ekatchéén Manmanma-an hen nanlawhan hen anghel hen a-anà hen ganà Israel hen namchitana hen a-anà hen anchichay Egipto. ");
INSERT INTO blw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wat hen anchichay siguchay cha mintudtuchu hen orchin ya hen anchichay anap-apon hen pachi, chachan a-atopàpà no heno hen ekamancha way mamchit an Jesus ah achi koma ma-ammuwan te émmégyatcha ah gumabforan hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Angkay hiyachi yag nihurug ah Chumunyu an Judas Iscariote way iha hen anchichay hemporo ya chuway pasorot Jesus. ");
INSERT INTO blw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wat i nètagépfar hen anchichay anap-apon hen papachi ya hen anchichay kapetan hen guwarcha ah Templo ta itudtuchucha no henon ekamanna way mangentochar an Jesus. ");
INSERT INTO blw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wat anchag laylayad hen anchichay o-okom yag nantotoragcha way mamfayad. ");
INSERT INTO blw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wat enafunan Judas amin yag annaat ilugi way manganap hen ekamanna way mangentochar an Jesus way achi koma ma-ammuwan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Angkay hiyachi yag inumchah hen ag-agaw hen anchi lagsak way manganancha hen anchi tenapay way cha-an fumnar way yachi agé hen mamartiyancha hen karnero way missa hen anchi Manmanma-an. ");
INSERT INTO blw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yachi yag hennag Jesus cha Pedro an Juan way mangaliyén, “In-ayu ta inyu esagana hen manganantaaw hen antoy lagsak way Manmanma-an.” ");
INSERT INTO blw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yag ekatcha an Jesusén, “Wat chuud hen laychém way intaaw manganan nò.” ");
INSERT INTO blw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yag annaat ekatén, “No an-ayuwat cha homàyat ah fabréy ad Jerusalem, hib-atényu hen ihay larae way namfufu-ud ah nahahàchuwan way fanga, wat yachi hen umunuchanyu. Yag hen anchi faréy way hénggépana, ");
INSERT INTO blw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ifagayu hen anchi nangimfaréy way mangaliyén, ‘Hen imfagan hen aponi, chuud anohto hen anchi kowarto way mèanana an chàni way pasorotna hen antoy lagsak way Manmanma-an.’ ");
INSERT INTO blw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wat epàilana an chàyu hen ihay chakar way kowarto hen pegwan hen garachu hen faréyna way wacha hen aminay masapor, wat yachi hen mangensaganaanyu hen manganantaaw.” ");
INSERT INTO blw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Angkay lummigwat cha Pedro an Juan yag inchahancha tot-owa amin hen imfagan Jesus, yag ensaganacha hen manganancha hen hiyachiy lagsak. ");
INSERT INTO blw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Angkay hiyachi way inumchah hen tempon hen manganancha hen hiyachiy lagsak, nìtùchu ah Jesus hen anchichay hemporo ya chuway aposelna way mangan. ");
INSERT INTO blw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yag annaat ekat an chichéén, “An-og laychén paat way mèan an chàyu hen antoy lagsak ta ana-at mapap-aligatan, ");
INSERT INTO blw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","te hen ifagà an chàyu, achiyà kasen mèan hen antoy lagsak way Manmanma-an ingganah umchah hen tomot-owaan hen kapaniyana ad uchu hen mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yachi yag innaran Jesus hen ihay tasa way fayah yag nanyaman an Apudyus yag annaat ekatén, “Aranyuto ta mantebtebyananyu, ");
INSERT INTO blw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","te hen ifagà an chàyu, wat manepod ad uwan, achiyà kasen umin-inum ah fayah ingganah umchah hen mantorayan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yachi yag innarana agé hen ihay tenapay yag nanyaman an Apudyus, yag annaat petpet-angén yag inwarasna an chicha way mangaliyén, “Yato hen achar-o way michaton ah mamarahe an chàyu. Wat chayu amma-ammaan hen antoy mekaman ah manmanma-anyu an haén.” ");
INSERT INTO blw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Angkay hiyachi agé way narpascha way nangan, inidchatna hen fayah an chicha way mangaliyén, “Hen antoy fayah, yato hen sinyar hen anchi kà-amma way torag Apudyus, wat hen charà hen matéyà, yachi hen manot-owaan hen anchi kà-amma way torag, te hen charà, mifùfù para an chàyu.” ");
INSERT INTO blw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ngém hen ifagà agé, wacha an chitaawanto way cha mèan hen mangentochar an haén. ");
INSERT INTO blw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Haén way Pangorowan hen Tatagu, mepapchità te yachi chillu hen nifafagga way ma-ammaan an haén, ngém ammag kaségség-ang lawa hen anchi ammag natorod way mangentochar an haén.” ");
INSERT INTO blw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yachi yag anchaat ilugi way man-ahepennoot no heno an chicha hen mangamman nadchi. ");
INSERT INTO blw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Angkay hiyachi yag chachan sosongel hen anchichay pasorot Jesus no heno an chicha hen kangatowan. ");
INSERT INTO blw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wat tinugun Jesus chicha way mangaliyén, “Hen anchichay chan toray hen antoy lota, sigsigurucha te chacha manchamancharén hen anchichay chacha etorayan. Ya hen anchichay o-okom way wachan fiyangcha, anchag cha epachayaw hen acharcha way mangaliyén chicha ano hen cha manorong hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ngém chàyu, achi koma mafalin way yahan inyu tot-orachén, te hen anchi nangatngato an chàyu, masapor mamfalinéna hen acharna ah enawchin hen tapena ta hiya hen katorongancha. Ya hen anchi man-ap-apo an chàyu, hiya hen fafà-arén hen tapena. ");
INSERT INTO blw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nokay ngata hen nangatngato ah hamhamàyu, hen anchi tumùchu way mangan ono hen anchi katorongna way man-alekatto. Hen anchi tumùchu way mangan, a. Ngém haén, tàén haén hen ap-apoyu, chà chillu ammaan hen katorongan hen tatagu, wat yachi hen torachényu.” ");
INSERT INTO blw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Chàyu, anyu tot-owag ena-annohan aminay ligat-o. ");
INSERT INTO blw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Wat kaman hen nangidchatan Amay Apudyus an haén hen lébféng-o way mantoray, kaman agéhchi hen mangidchatà an chàyu hen lébféngyu way mantoray agé. ");
INSERT INTO blw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ya metatappeayu an haén hen mantorayà ya uray hen chà mangmanganan. Ya chàyu agé hen manguwis hen anchichay kacharaanyu way Judio way ganà hen anchichay hemporo ya chuway anà Jacob way ekatchéén Israel.” ");
INSERT INTO blw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yachi yag ekat Jesus an Pedro way mangaliyén, “Simon changrénà paat te chinawat Chumunyu hen parufus way mamachas amin an chàyu ta ilana no wacha an chàyu hen mahenhen kaman hen mahenhenan hen chugi hen fégah. ");
INSERT INTO blw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ngém inluwaruwà hea Simon, ta achi matarà hen afurotno an haén. Yag no kasen-a manhagong an haén, epas-émno hen afurot hen anchichay ifam.” ");
INSERT INTO blw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngém ekat Pedrowén, “Apo, anà angkay ammag nansasaggana way uray mifarud ya mìyatéy an hea.” ");
INSERT INTO blw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yag ekat Jesusén, “Oo a, ngém ah katot-owana, Pedro, achi manollaò hen manò hen hiyatoy lafi yag empetlomat way mangenhoot an haén.” ");
INSERT INTO blw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Angkay hiyachi yag ekat Jesus hen anchichay pasorotnéén, “Hen nannagà an chàyu way maid entàtaenyu ah pelak ya pah-eng ya uray hen mansokatanyu, ay nakorangan-ayu ah masapor.” Yag ekatchéén, “Cha-an-ani met.” ");
INSERT INTO blw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Ngém safali ad uwan,” way ekat Jesus, “te ad uwan, hen anchi wachan pelakna, masapor etàtaenna, ya masapor mampah-eng-ayu. Yag no wacha an chàyu hen maid fangidna, masapor uray annag elao hen lumfongna ah fangidna. ");
INSERT INTO blw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Te hen ifagà an chàyu, tomot-owa angkay ad uwan hen anchi nesosorat ad namenghan mepanggép an haén way ekatnéén, metakorongà hen anchichay futangelo. Ya tomoroychi te cha tomot-owa amin hen anchi nesosorat mepanggép an haén.” ");
INSERT INTO blw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yag anat ekat agé hen anchichay pasorotnéén, “Ilam ngén Apo, antoyan kay hen chuway fangid yà.” “Aẁ anggay ud-ay,” way ekat Jesus. ");
INSERT INTO blw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Angkay hiyachi yag lomayaw ah Jesus ya hen anchichay pasorotna way émméy hen anchi filig ad Olivo te yachi chillu hen chacha ay-ayan no madhém. ");
INSERT INTO blw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Angkay inumchahcha ahchi, ekat Jesus an chichéén, “Manluwaluwaruayu ta achiayu ma-awis way fumasor gapon annay tég-angay mepasamak.” ");
INSERT INTO blw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yachi yag émméy ah Jesus hen ê-éyna, yag nampalentomang way manluwaru. ");
INSERT INTO blw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ekatnéén, “Ama, no anno koma laychén, achim koma epachah hen yatoy ligat way tég-angay mepasamak an haén. Ngém uray no yahan chawatê, laychê chillu way ma-ammaan yanggay hen laychém.” ");
INSERT INTO blw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yachi yag ammag émméy hen anghel way narpod uchu way i nanorong an hiya. ");
INSERT INTO blw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ammag amchan way térén hen hamhamà Jesus way kaman paat ommanay ah annag iyatéy yag ammag kaskasen hen enkamanna way manluwaru. Yag hen lengatna, kaman chara way chan eheeh hen lota. ");
INSERT INTO blw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Angkay hiyachi way narpas hen luwaruna, tommàchég yag namfangad hen iggaw hen anchichay pasorotna yag inchahanaat agé chicha way nanasséy te kaman anchag naungar mepo-on ah hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yag annaat ekat an chichéén, “Pakay peet nasséy-ayu. Fangon-ayuwat ta manluwaru-ayu ta achiayu ma-awis way fumasor gapo hen annay tég-angay mepasamak.” ");
INSERT INTO blw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Angkay hiyachi way é-éttég Jesus way chan ale, nawaychaat hen anchichay chuaray tatagu. Wat hen anchi nange-etnod an chicha, wat ah Judas way iha hen anchichay hemporo ya chuway pasorot Jesus. Wat émméy ah Judas way i nangentomò hen tapàna hen apeng Jesus. ");
INSERT INTO blw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yag ekat Jesusén, “Judas, ay hen annay sinyar chi layad peet hen annog finalin ah sinyar chi tochar ah mangentocharam an haén way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Angkay enlasin hen anchichay ifan Jesus hen ma-ammaan, anchaat ifaga an Jesus way mangaliyén, “Apo, ay fuma-ag-ani.” ");
INSERT INTO blw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yag fumma-agat tot-owa hen iha an chicha yag narungchanat hen awan hen ingan anchi alepan hen anchi kangatowan way pachi. ");
INSERT INTO blw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngém empawan Jesus way mangaliyén, “Anggay, achiayu cha fuma-ag.” Yag annaat aran hen ingan hen anchi nafa-ag yag entò-opna. ");
INSERT INTO blw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yachi yag anat ekat Jesus hen anchichay ummale way mangara an hiya way anap-apon hen pachi ya hen kakapetan hen guwarchan hen Templo ya hen anchichay anam-ama way ponò hen Judio, ekatnéén, “Ay ammoh futangelowà ta masapor mamfafangngid-ayu ya mampapang-or-ayu way i mangara an haén. ");
INSERT INTO blw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ammag enag-agaw way miya-ahrangà an chàyu ah Templo wat maid met ekatyuwén aranà. Ngém ad uwan hen tempon hen mantorayan hen laweng, wat yachi hen meparufusanyu way mangamma hen ammaanyu.” ");
INSERT INTO blw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Angkay hiyachi way tenelewcha ah Jesus, inyéycha hiya hen faréy hen anchi kangatowan way pachi. Yag ah Pedro, chinuchum-ang way cha umunud. ");
INSERT INTO blw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yag hen anchichay tatagu, nan-apoycha hen fatawan hen anchi faréyanchi way niyéyan Jesus wat i nèanichu ah Pedro an chicha. ");
INSERT INTO blw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yag hen nangil-an hen ihay motmotyu way fafarasang an Pedro way chan anichu, menatmatana yag annaat ekatén, “Yaha ngata agé hen ihay cha metmetnod an Jesusanchi.” ");
INSERT INTO blw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngém enhoot Pedro way mangaliyén, “Heay fafarasang, maid ay paat innilà hen taguwanna way ekatnowa.” ");
INSERT INTO blw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Angkay na-awni agé yag wacha hen ihay larae way nangenlasin an Pedro, yag ekatnéén, “Hean samét hen iha an chicha agé.” “Faénà ayé,” way ekat agé Pedro. ");
INSERT INTO blw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Angkay nanlooh hen ihay uras ménat yag wacha agé hen ihay larae way nangenlasin an Pedro, yag empapeletna way mangaliyén, “Hea kayyà hen ihay ifan Jesus te afab-én way iGalilea-a.” ");
INSERT INTO blw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngém ekat Pedrowén, “Heay taguwanna, maid ay innilà hen annay cham aryénanna.” Yag hen hiyachi way chan ale ah Pedro, yag nanollaòat agé hen manò. ");
INSERT INTO blw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yag ah faréy, namfiliwit ah Jesus way nangila an Pedro, yag hemhemmà Pedro hen enalen Apona ad annad way achi manollaò hen manò hen hiyahay lafi yag penetlonaat way mangenhoot an hiya. ");
INSERT INTO blw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wat lommayaw ah Pedro way ammag chan sigab hen hamhamàna ya amchan chi kelana gapon enammaana. ");
INSERT INTO blw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Angkay hen anchichay chan guwarcha an Jesus, anchag cha sén-ésén-én hiyéén lenopropagcha. ");
INSERT INTO blw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yag anchaat fongoton hen matanéén lenopropagcha way mangaliyén, “Ayé, ifagam kaya no henon nanlopag an hea.” ");
INSERT INTO blw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yag chuar hen enkamakamancha way nanginsorto an hiya. ");
INSERT INTO blw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Angkay pommaway, na-amongcha hen anchichay anam-ama way ponò hen Judio ya hen anap-apon hen papachi ya hen anchichay siguchay cha mintudtuchu hen orchin, yag empasangocha ah Jesus hen anchichay konsel. ");
INSERT INTO blw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yag ekatchéén, “Ifagam an chàni, ay hea hen anchi Cristu way empopostan Apudyus way umale way mantoray.” Yag senongfatan Jesus way mangaliyén, “Tàén no ifagà, achiyu chillu afuroton, ");
INSERT INTO blw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","yag no wacha agéy sarudsuchù, achiyu agé songfatan. ");
INSERT INTO blw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngém no marpas chillu hen antoy ma-ammaan ad uwan, haén way Pangorowan hen Tatagu, tumùchuwà hen pachawanan Apudyus way mannakafalin.” ");
INSERT INTO blw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yag anchaat ekat aminén, “Wat ay ammoh hea hen anà Apudyus tà.” Yag annaat ekatén, “Oo, enaleyu met.” ");
INSERT INTO blw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yag ekatchaatén, “Ay ammoh masapor kasentaaw man-anap ah fasorna, te chengngartaaw met amin hen enalena wat narégnachi ah iyatéyna.” ");
INSERT INTO blw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Angkay hiyachi yag inligwatcha amin way manginyéy an Jesus hen anchi gubérnador way Pilato. ");
INSERT INTO blw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yag yachi way inumchahcha, inlugichaat way mangimfaga hen fasorna. Ekatchéén, “Inchahanni hen yatoy tagu way chana subsufan hen anchichay tatagu ya chana amin epawa ah mamfayachancha hen furor an Are. Yag chanaat agé ekatén hiya ano agé hen Are way Cristu way empopostan Apudyus way umale way mantoray.” ");
INSERT INTO blw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yachi yag senarudsud Pilato an Jesus way mangaliyén, “Ay hea ano hen Aren hen Judio.” Yag ekat Jesusén, “Oo, enalem met.” ");
INSERT INTO blw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yachi yag anat ifagan Pilato hen anchichay anap-apon hen papachi ya hen anchichay chuaray tatagu way mangaliyén, “Maid met inchahà ah fasor hen yatoy tagu ah érégna way iyatéy.” ");
INSERT INTO blw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngém ammag cha ekaskasen hen anchichay tatagu way mangempapelet way mangaliyén, “Chana angkay sinubsufan hen tatagu way inlugina hen provinsiyan hen Galilea ingganad Judea, yag gapon chana intudtuchu wat chacha magabfor amin hen tatagu, yag ad uwan, inumchah agéhto ad Jerusalem.” ");
INSERT INTO blw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Angkay chengngar Pilatochi yag annaat imohon no iGalilea peet ah Jesus. ");
INSERT INTO blw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yag hen nangngarana way narpo peet ah Jesus hen sakopon hen cha etorayan Herod, annaat epééy ah Jesus an hiya te niyaphor way wacha ah Herod ad Jerusalem agé hen hiyachiy tempo. ");
INSERT INTO blw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yag ah Herod, ammag laylayad way mangila an Jesus te nafayag way annag laychén paat way mangila an hiya gapon amin way chana chengngar. Yag hen laychéna paatat ilana koma hen kaskascha-aw way ammaan Jesus. ");
INSERT INTO blw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wat ammag maid achi inimoh Herod an hiya, ngém ammag iggay somongsongfat ah Jesus. ");
INSERT INTO blw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yag hen anchichay anap-apon hen papachi ya hen anchichay cha mintudtuchu hen orchin agé, ammag narafus way térén hen chacha ekaman way mangempafasor an hiya. ");
INSERT INTO blw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yag chaat agé mèpeloh ah Herod ya hen anchichay sorchachuna an Jesus yag senensenacha agé hiya. Ya anchaat eparumfong hen ammag ammay way lumfong yag empafangadcha an Pilato. ");
INSERT INTO blw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wat nanepod hen hiyachiy ag-agaw, nanggayyém cha Herod an Pilato te nafayag way anchag mankokontara. ");
INSERT INTO blw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Angkay hiyachi yag empa-ayag Pilato hen anchichay anap-apon hen papachi ya hen anchichay anam-ama way ponò ya anat amin hen tatagu, ");
INSERT INTO blw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","yag annaat ekat an chichéén, “Empasangoyu hen antoy tagu an haén te ekatyuwén chana subsufan hen tatagu. Wat finistigar-o met hiya hen sangwananyu, ngém maid met inchahà ah enammaana ah kaman hen chayu epafasor an hiya. ");
INSERT INTO blw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Yag umat agé ah Herod, maid agé inchahana te pakay empafangadna an chàni nò. Wat yaha hen kail-ana way maid enam-ammaan hen yatoy tagu ah narégna way iyatéy. ");
INSERT INTO blw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wat an-og epahaprat yag emparufus-o.” ");
INSERT INTO blw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yachi hen ekat Pilato gapo ta nigagangay way tenawénén wachan eparufusna way ihay farud no tempon hen yachiy lagsak. ");
INSERT INTO blw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngém hen anchichay na-a-among way tatagu, anchag aheo-ongaw way mangaliyén, “Pédtényuha ta ah Barabas hen eparufusyu,” ");
INSERT INTO blw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","way ah Barabasanchi, sigud way farud te empataropana hen tatagu hen gubérno hen yachiy fabréy, ya wacha amin hen pinchitna way tatagu. ");
INSERT INTO blw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ngém ah Pilato, laychéna koma way ah Jesus hen meparufus wat penachasna way mangay-ayu hen tatagu. ");
INSERT INTO blw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ngém anchag cha èngaèngaw way mangaliyén, “Anyug elansa hiya hen koros, ta elansayu way elansa.” ");
INSERT INTO blw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yachi way petlon hen namachasan Pilato way mangà-arò hen anchichay tatagu, ekatnéén, “Pakay. Nokay paat hen enammaana ah laweng, te maid met inchahà ah ustoh fasorna ah érégna way iyatéy. Wat an-og epahaprat yanggay yag emparufus-o.” ");
INSERT INTO blw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngém ammag cha èngaèngaw chillu hen tatagu way mangempapelet way melansa ah Jesus ingganah ommafun ah Pilato. ");
INSERT INTO blw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wat yachi yag anat eparufus Pilato way ma-ammaan an Jesus hen chacha epapelet way chawatén. ");
INSERT INTO blw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yag emparufusna hen anchi tagu way nifafarud gapon pommatéyana ya hen nempataropana hen tatagu, te hiya hen laychéncha way meparufus. Yag emporangna ah Jesus an chicha ta ammaancha an hiya hen heno way laychéncha. ");
INSERT INTO blw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Angkay hiyachi way chacha elayaw ah Jesus, lenapchùcha hen ihay tagu way niyaphor way cha homàyat way i hommepot way ah Simon hen ngachanna way eCirene, yag empafu-udcha an hiya hen anchi koros Jesus ta iyunudna. ");
INSERT INTO blw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yachi yag anchag chuar hen anchichay tatagu way cha umunud an Jesus, yag wachacha agé hen anchichay finufae way chacha kelaan hiya ya chachan ifil amin. ");
INSERT INTO blw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yachi yag namfiliwit ah Jesus an chicha way mangaliyén, “Chàyu way finufae way iJerusalem, faén koma haén hen kelaanyu ta hen acharyu hen kelaanyu ya hen a-anàyu. ");
INSERT INTO blw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Te umchah way umchah hen ammag pararo way ligat ahto, wat ammag ekat hen tataguwén anchag nagasat paat hen anchichay maid anàna way iggay umanà ya achichan pasoso. ");
INSERT INTO blw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Te gapon kenapararon hen ligat hen hiyachiy tempo, wat ammag chawatén hen tatagu ta uray hen filig ya tagéytéyén matébcha koma ah matagpénancha ta metarocha paat. ");
INSERT INTO blw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Te ilanyu ngén, no hiyato hen ma-ammaan an haén ad uwan way maid paat fasorna, ay achi kaskasen hen ma-ammaan an chàyu ya hen ganàyu way menangfasor.” ");
INSERT INTO blw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Angkay hiyachi yag wachacha agé hen chuway futangelo way inyéycha agé way meparansa hen hiyachiy tempo. ");
INSERT INTO blw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Yag yachi way inumchahcha hen anchi lota way ekatchéén “alintutugun chi uru,” enlansacha ah Jesus hen away way koros, yag enkoroscha agé hen ihay futangelo hen pachawigina ya hen iha ah pachawananna. ");
INSERT INTO blw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Narpaschi yag anat man-ale ah Jesus way mangaliyén, “Ama, pakawaném chicha te maid innilacha hen chacha am-ammaan.” Yachi yag anchaat manfunfunnot way manginyàchang hen lumfongna. ");
INSERT INTO blw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yag hen anchichay tatagu, anchag tommatàchég way chan fub-uya way mangi-ila no heno hen mekaman. Ya hen anchichay ap-apon hen Judio, chachaat sén-ésén-én hiya way mangaliyén, “Tenorongana hen tapena, wat torongana kagé hen acharna no hiya tot-owa hen Cristu way penelen Apudyus.” ");
INSERT INTO blw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Yachi yag sensennan agé hen anchichay sorchachu hiya way manginchawchaw hen ommelém way fayah, ");
INSERT INTO blw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yag ekatchéén, “Ayé, no hea hen aren hen Judio, wat pakay achim hara-an hen acharno nò.” ");
INSERT INTO blw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Angkay hiyachi yag enhabrotcha agé ah petchayan hen uruna hen nesosorat way ekatnéén, “Yato hen Aren hen Judio.” ");
INSERT INTO blw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Angkay hiyachi yag nì-insorto agé hen ihay futangelo way nelaransa way mangale an Jesusén, “No hea hen Cristu way empopostan Apudyus, wat pam achi hara-an hen acharno ya chàni agé.” ");
INSERT INTO blw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngém enamhew hen anchi iha way mangaliyén, “Ay ammoh maid paat égyatno an Apudyus. Nelansataaw amin, ");
INSERT INTO blw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ngém chita, lébféngta way melansa te chusan hen enammaanta, ngém hen yahay tagu, maid poros enam-ammaana ah laweng.” ");
INSERT INTO blw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yachi yag annaat ekat agé an Jesusén, “Apo Jesus, hamham-énà koma no umchah hen mantorayam.” ");
INSERT INTO blw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yag anat ekat Jesusén, “Tot-owa hen antoy ifagà an hea way hen hiyatoy ag-agaw, mètapea an haén ad uchu.” ");
INSERT INTO blw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Angkay hiyachi way ustoy nanggawa, yag ammag hommelangat agé amin hen lota ingganah fummatangan way ammag iggay homelaw hen init. ");
INSERT INTO blw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yachi agé yag ammag nan-agwa hen anchi séchar way kortena way horchà hen iggaw Apudyus paat ah Templo. ");
INSERT INTO blw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yag chinakarat agé Jesus hen alena way mangaliyén, “Ama, an-og eporang an hea hen lennawà.” Yachi hen ekatna yag natéyat. ");
INSERT INTO blw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Angkay hen nangil-an hen anchi kapetan hen sorchachu amin hen nekaman, annag chinayaw ah Apudyus way mangaliyén, “Yato peet tot-owa hen ihay tagu way ammag maid poros enammaanah laweng.” ");
INSERT INTO blw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ya hen anchichay chuachuar way tatagu agé way na-a-among way chan fub-uya, innilacha amin hen nekaman, wat ancha ammag hommàyat way chan pagpag hen faro-ongcha gapoh hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yag amin hen anchichay ifan Jesus ya hen anchichay finufae way netnod an hiya way narpod Galilea, oma-adchawwéycha way nangi-ila hen amin. ");
INSERT INTO blw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Angkay hiyachi yag wachan ihay tagu way ah Jose hen ngachanna way ad Arimatea hen fabréyna way sakopon hen provinsiyan hen Judea. Machayaw way tagu ah Jose te na-ammuwan hen kena-ammayna, yag hiya agé hen ihay chan héhhééd hen milugiyan hen mantorayan Apudyus. Ya tàén hiya hen iha hen anchichay anam-ama way konsel, iggay chillu mètempoyug hen anchichay ifana hen nantetempoyugancha way mangamma hen na-ammaan an Jesus. ");
INSERT INTO blw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yachi yag émméy ah Joseyanto an Pilato way manawat hen achar Jesus. ");
INSERT INTO blw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yag yachi way neparufus, inna inpah hen achar hen anchi natéy way nelaransa hen koros, yag finunifunana ah am-ammay way uroh yag ina inlufù hen anchi kà-amma way lufù way an napasorag way natoktokan hen chéprah. ");
INSERT INTO blw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hen alemana hen na-ammaan nadchi way tég-angay malihnug hen init way yachi agén milugiyan hen ngilin hen Judio way Safachu. ");
INSERT INTO blw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Angkay hen anchichay finufae way netnod an Jesus hen lummigwatana ad Galilea, inunudcha ah Jose yag innilacha hen iggaw hen anchi lufù ya hen enkamanna way nanginlufù hen achar Jesus, ");
INSERT INTO blw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","yag anchaat homàyat way incha inyam-amma hen anchichay nankarakarase way fangfangru way metape way miyoppeop hen natéy. Yag nawakas way Safachu, nantongawcha way man-inungar te yachi chillu hen orchin hen Judio. ");
INSERT INTO blw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Angkay hen anchi Chuminggu, nahapacha way térén hen anchichay finufae way lummigwat way éméy hen anchi lufù ta iyéycha hen anchichay fangfangru way ensaganacha. ");
INSERT INTO blw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Angkay inumchahcha yag ammag na-a-allinat agé hen anchi tépà way tangéb hen lufù, ");
INSERT INTO blw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","wat henomròcha way i mangila, yag ammag maichat agé hen anchi natéy. ");
INSERT INTO blw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wat anchag naleletag, yag hen hiyachi, ammagat agég niyahad hen chuway larae way nètatàchég an chicha way ammag cha humili hen lumfongcha. ");
INSERT INTO blw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yag hen anchichay finufae, anchag nanyongyong way mampalentomang ah égyatcha. Yag ekat hen anchichay larae an chichéén, “Pakay chayu anapén hen anchi natattagu hen iggaw hen natéy. ");
INSERT INTO blw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maid angkay ahto te nan-uchi. Ay naliw-anyuwat peet hen anchi imfagana an chàyu hen kawad-ana ad Galilea, ");
INSERT INTO blw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","way masapor meporang hen anchi Pangorowan hen Tatagu hen anchichay lawengay tatagu ya melansa hen away yag anat man-uchi chillu hen anchi petlon hen ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yachi yag hemhemmà tot-owa hen anchichay finufae hen enalena, ");
INSERT INTO blw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","wat lommayawcha hen anchi lufù way incha henaphapet aminchi hen anchichay hemporo ya ihay pasorot Jesus ya anat agé hen anchichay tapena. ");
INSERT INTO blw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hen ngachan hen anchichay finufae, wat cha Maria way eMagdalena an Juana yah Maria way inan Jaime ya anat agé hen anchichay tapena way chicha amin hen i nanaphapet hen anchichay aposel. ");
INSERT INTO blw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngém hen anchichay aposel agé, ekatchéén, maid innilan hen anchichay finufae hen chacha ar-aryén, te kamancha chan in-inép, wat anchag iggay afuroton chicha. ");
INSERT INTO blw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngém ah Pedro, lummigwat way nanagtag way i paat mangila hen anchi lufù. Yag nan-eteng-ena paat way nangila ad char-ém, yag ammag anggay hen anchi funifun ah wà-acha way ammag maid ininggaw. Yachi yag anat homàyat way ammag nahahaang way cha manmamanmà no nokay peet hen anchi nekaman. ");
INSERT INTO blw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Angkay hen hiyachiy ag-agaw, lummigwat hen chuwa hen anchichay cha somorot an Jesus way éméy ad Emaus way nasorok ah hemporo ya chuway lometor hen ka-achawwéyna ad Jerusalem. ");
INSERT INTO blw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yag hen chacha manaranan, chachan tagtagépfaran hen aminay na-ammaan. ");
INSERT INTO blw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Angkay hiyachi way chachan ahepennoot ya chacha haphapetén hen anchi na-ammaan, inchahan Jesus chicha yag netnod, ");
INSERT INTO blw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ngém chicha, tawwan no pakay iggaycha elasin way ah Jesus peetchi. ");
INSERT INTO blw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yachi yag anat ekat Jesusén, “Nokaychi hen chayu aryénanna way cha manaran.” Yag entàchégcha way ammag mamàila hen pararo way tokarcha. ");
INSERT INTO blw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yag anat ekat hen iha way ah Cleopas hen ngachannéén, “Ay kàéchah-a ménat ad Jerusalem way hea yanggay ménat hen cha-an mangngar hen cha na-ammaan hen hiyatoy tempo.” ");
INSERT INTO blw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yag anat ekat Jesusén, Henochi. Yag ekatchéén, “Hen anchi na-ammaan an Jesus way eNazaret way hiya, na-ammuwan way profetan Apudyus way ririspituwén Apudyus ya hen tatagu agé, ya nakafael way nangintudtuchu amin hen intudtuchuna ya nangamma agé hen kaskascha-aw.” ");
INSERT INTO blw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Entoroycha way mangaliyén, “Ngém hen anchichay anap-apon hen pachitaaw ya hen anchichay ponòtaaw, anchag emporang hiya an Pilato ah manginyurchinana hen matéyana, wat enlansacha hiya hen koros. ");
INSERT INTO blw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Waman chàni, ekatniyén hiya koma hen anchi mangenharà an chitaaw way ganà Israel. Ngém ammag solet peet te ad chin-argaw hen na-ammaan amin cha nahha an hiya. ");
INSERT INTO blw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yag an-ani agég nahngang hen anchi henaphapet hen anchichay tapen ifani way finufae, te fummigatcha way émméy hen anchi lufù ");
INSERT INTO blw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yag maid ano hen anchi achar hen natéy, wat namfangadcha way i nangimfaga way innilacha ano hen anghel, yag imfagan ano hen anchichay anghel way nan-uchi ano ah Jesus. ");
INSERT INTO blw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yachi yag émméycha agé hen tapen ifani way i nangila hen anchi lufù, yag tot-owa peet hen henaphapet hen anchichay finufae ngém maid chillu innilacha an Jesus.” ");
INSERT INTO blw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Angkay hiyachi yag nan-ale ah Jesus way mangaliyén, “Kaman-ayu paat hay chan ligligummu, te pakay ammag naligat ah mangafurotanyu amin hen imfagan hen anchichay profeta ad namenghan. ");
INSERT INTO blw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ay achiyu peet chillu ma-awatan way masapor mapap-aligatan hen anchi empopostan Apudyus way Cristu yag anat umchah hen machayawana.” ");
INSERT INTO blw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yachi yag anat esoplekar Jesus amin hen anchi nesosorat ad namenghan mepanggép an hiya way inlugina hen anchi pés-éy ensorat Moses inggana hen amin way ensorat hen anchichay profeta. ");
INSERT INTO blw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Angkay hiyachi way tég-angaycha umchah hen anchi fabréy way ayancha, yag kaman paat ichakpos Jesus way mangentoroy, ");
INSERT INTO blw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ngém entar-éd hen anchi chuwa hiya way mangaliyén, “Panga-asem ta umiyantaaw te nanadhém chillu, te kaysan hen ag-agaw.” Wat enafunan Jesus yag nàyéy an chicha. ");
INSERT INTO blw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yag yachi way tummùchucha way mangan, innaran Jesus hen anchi tenapay yag nanyaman an Apudyus yag annaat petpet-angén yag inidchatna an chicha. ");
INSERT INTO blw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yag hen hiyachi, kaman nafùtan hen matacha yag enlasinchaat way ah Jesus peetchi, yag ammag naumahat agé. ");
INSERT INTO blw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hiyachi yag nan-ahepennootcha way mangaliyén, “Ay ammoh faén kaman paat cha gumilab way apoy ah lènata hen chana man-aryan hen charan hen chana nangintudtuchuwan hen anchi nesosorat ad namenghan.” ");
INSERT INTO blw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Angkay hiyachi, lummigwatchaat hen hiyachiy uras way mamfangad ad Jerusalem, yag inchahancha hen anchichay hemporo ya ihay pasorot Jesus ya anat hen anchichay tapena agé way na-a-among. ");
INSERT INTO blw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yag ekatat agé hen anchichay na-a-amongén, “Nan-uchi angkay tot-owa ah Apotaaw te nampàila an Simon Pedro.” ");
INSERT INTO blw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yachi yag henaphapet agé hen anchi chuwa hen anchi nekaman hen anchi nanaranancha ya hen nangenlasinancha an Jesus hen namet-angana hen anchi tenapay hen chacha manganan. ");
INSERT INTO blw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Angkay hiyachi way chacha haphapetén hen nekaman hen charan, ammag niyahachat agé ah Apo Jesus way tommatàchég hen gawana, yag annaat ekatén, “Ta mapanoh hen hamhamàyu.” ");
INSERT INTO blw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yag ancha ammag émmégyat way térén te ekatchéén fanig. ");
INSERT INTO blw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yag annaat ekat agéén, “Pakay cha-ayu émégyat ya pakay cha-ayun finfinafang mepanggép an haén. ");
INSERT INTO blw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilanyu ngén hen antoy limà ya he-è te haénto, wat tad-énà ta mapnek-ayu. Te ay ammoh wachay laman ya tongar chi fanig. Te laman ya tongar met hen achar-o.” ");
INSERT INTO blw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yaha hen enalena yag empàilana agé hen limana ya hen he-ena. ");
INSERT INTO blw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ngém kaman paat chillu achicha afuroton, te ancha lawag naleletag ya tàén amchan hen laylayadcha, kaman paat chillu faén kapapate. Yag anat ekat Jesusén, “Ay wachay enhàfayu ah ma-an ta manganà.” ");
INSERT INTO blw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wat inchawchawcha hen nelopò way files, ");
INSERT INTO blw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","yag innarana yag inissana hen sangwanancha amin. ");
INSERT INTO blw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Angkay hiyachi yag ekat Jesus an chichéén, “Amin hen anchi na-ammaan an haén, chichachi hen chà imfagafaga hen chà netnonetnochan an chàyu, te masapor way tomot-owa hen aminay nesosorat mepanggép an haén nanepod hen ensorat Moses ya hen anchichay profeta ya anat agé hen anchi nesosorat hen anchichay kankanta way Salmo.” ");
INSERT INTO blw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yachi yag kaman paat finùtan Jesus hen hamhamàcha ta ma-awatancha amin hen anchi nesosorat ad namenghan. ");
INSERT INTO blw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yag annaat esoplekar way mangaliyén, “Yato chillu hen nesosorat mepanggép an haén way ekatnéén, ‘Masapor chillu mapàpàgang hen anchi epalen Apudyus way Cristu ya anat matéy ya anat man-uchi hen petlon hen ag-agaw.’ ");
INSERT INTO blw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yag nesosorat agé way masapor mitudtuchu hen antoy chamag mepanggép hen mamfafawiyan hen tatagu ta mapakawan hen fasorcha gapon haén. Wat mitudtuchuchi hen aminay tatagu ah karotarota way milugi ahtod Jerusalem. ");
INSERT INTO blw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yag chàyu paat hen manàchég hen katot-owaan hen aminay nekaman. ");
INSERT INTO blw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yag achi mafayag wat epalè an chàyu hen anchi Espiritu way empopostan Ama chillu way mepale. Ngém masapor i-inggaw-ayu ahtoh fabréy ingganah umchahchi an chàyu te hiya hen anchi mannakafael way marpod uchu.” ");
INSERT INTO blw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Angkay hiyachi yag enetnod Jesus chicha inggana ad Betania yag annaat etànang hen limana yag binindisyunana chicha. ");
INSERT INTO blw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yag hen chana mamindisyunan an chicha, chaat agé matarok way éméy ad uchu way manaynan an chicha. ");
INSERT INTO blw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yag chicha, chinayachayawcha ah Jesus yag anchaat mamfangad ad Jerusalem way maid kepaniyan hen laylayadcha. ");
INSERT INTO blw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yag kankanayén way chacha émé-éméy ah Templo way manyaman an Apudyus.");
INSERT INTO blw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hen anchi péspés-éyna way cha-an ma-ammaan hen antoy lota, nawawà-acha chillu hen anchi na-awagan ah Ale way hiya hen mangempaka-ammu an Apudyus. Yag hen yachiy na-awagan ah Ale, nelarammong an Apudyus, te hiya chilluh Apudyus ");
INSERT INTO blw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","wat nachachà-an way nelarammong hen anchi Ale an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ya piniyar agé Apudyus hiya way mangamma hen egachay wacha, wat maid kasen nangamma hen na-ammaan no faén yanggay hiya. ");
INSERT INTO blw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ya hiya agé hen lugin hen ataguwan hen egad. Ya hiya agé hen anchi Helaw way cha manelaw hen hamhamà hen tatagu. ");
INSERT INTO blw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yag helawan hen yachiy Helaw hen helang way iggaw hen tatagu, yag hen anchi helang, ammag achi makachép an hiya. ");
INSERT INTO blw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wacha hen ihay tagu way finaar Apudyus way ah Juan hen ngachanna. ");
INSERT INTO blw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yag hen namaaran Apudyus an hiya, ta ina haphapetén hen aminay katagutagu mepanggép hen anchi na-awagan ah Helaw ta no changrén hen tatagu, omafurotcha koma. ");
INSERT INTO blw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Faén ah Juan hen anchi manelaw hen hamhamà hen tatagu, te hiya hen anchi an yanggay an ummale way mangimfaga mepanggép hen anchi Helaw. ");
INSERT INTO blw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Te wacha hen kasen umale way hiya hen anchi tot-owa way Helaw way manelaw hen hamhamà hen aminay tatagu hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hen anchi na-awagan ah Ale way ekatcha agéén Helaw, gapon hiya wat na-ammaan amin hen antoy lota ya hen ininggaw. Ngém angkay ummale hen antoy lota, ammag iggayat agé elasin hen tatagu hiya. ");
INSERT INTO blw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ya tàén hen anchichay tatagu ah fabréynéén anchag achi mangiggéén hiya. ");
INSERT INTO blw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngém wachacha chillu hen tapena way nangimfilang an hiya yag ommafurotcha. Wat chicha, namfalinén Apudyus chicha ah a-anàna. ");
INSERT INTO blw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yag hen enkaman Apudyus way nanganà an chicha, faén kaman hen cha ekaman hen tatagun antoy lota no umanàcha te ah Apudyus, wachan enkamanna ta miyanà hen tatagu an hiya ta hiyan man-amacha. ");
INSERT INTO blw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Angkay hen anchi na-awagan ah Ale, namfalin ah tatagu yag nì-iggaw an chitaaw. Pahig tot-owa hen inyalena ya menangség-ang way tatagu. Yag chàni, innilani hen kena-ammayna way ammag maid mepaniyana way yachi chillu hen ka-ammayna te hiya hen anchi sissiguchay anà Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Imfagan Juan hen mepanggép an hiya, ekatnéén, “Hiyaha hen anchi chà aryén hen anchi nangaryaén, ‘Hen anchi meparég an haén, ammag nangatngato no haén te hiya, nawawà-acha chillu uray hen cha-an-o marmuwan.’ ” ");
INSERT INTO blw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Maid agé mepaniyan hen ség-angna an chitaaw way tatagu te annag séség-angan chitaaw amin ya cha matapyatapyanchi ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ah Moses hen nangimfaga hen orchin Apudyus an chitaaw, ngém ah Jesu Cristu hen nangempàila hen ség-ang Apudyus an chitaaw ya hen katot-owaan mepanggép an hiya. ");
INSERT INTO blw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maid poros tagu ah nangila an Apudyus, wat maid mangempaka-awat hen tatagu mepanggép an hiya. Waman hen anchi sissiguchay anàna way kapachongna paat way nelarammong an hiya, wat hiya hen nangempaka-awat hen tatagu mepanggép an Amana. ");
INSERT INTO blw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Angkay hen anchichay anap-apon hen Judio ad Jerusalem, hennagcha hen tapen anchichay papachi ya hen tapen agé hen anchichay cha tomorong an chicha way i mananhan an Juan no heno hen kasasa-adna. ");
INSERT INTO blw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wat maid enhoot Juan te enlawagna way mangaliyén, “Faénà angkay hen anchi Cristu way empopostan Apudyus way umale.” ");
INSERT INTO blw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Wat nokay-a nò,” way chacha ekat, “ono magat hea ah Elias way ekatchéén kasen umale.” Ngém ekatna agéén, “Faénà met.” Yag anchaat agé ekatén, “Wat awni yag hea ngata hen anchi profeta way chani hadhadchén.” Yag ekat Juan chilluwén, “Faénà agé.” ");
INSERT INTO blw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Wat no yaha, henoa kay peet nò. Ifagam ngarud ta wacha agéy haphapeténni hen anchichay nannag an chàni no heno hen mangalem hen acharno.” ");
INSERT INTO blw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yachi yag ensongfat Juan hen anchi ensosorat hen profeta way Isaias ad namenghan way ekatnéén, “Haén hen anchi ini-inggaw hen anchi chanak way cha mangèngaw hen anchichay tatagu ta iyam-ammacha hen engwan hen Ap-apo.” ");
INSERT INTO blw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Angkay hiyachi yag hen anchichay hennag hen anchichay Fariseo agé, ");
INSERT INTO blw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ekatcha an Juanén, “Wat no faén hea hen anchi Cristu ya faén-a agé ah Elias ono hen anchi profeta way chataaw hadhadchén, pakay cha-an funyag nò.” ");
INSERT INTO blw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yag anat somongfat ah Juan way mangaliyén, “An yanggay chanum hen chà ifunyag an chàyu, ngém wacha an chàyu ad uwan hen ihay tagu way cha-anyu elasin ");
INSERT INTO blw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","way hiya hen meparég an haén. Yag tàén an umunud an haén, ammag nangatngato chillu no haén, te uray lawa non anà an man-alepan an hiyéén achì karébféngan.” ");
INSERT INTO blw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Amin hen anchichay nekamkaman, na-ammaan amin ad Betania way chumang hen anchi wangwang way Jordan way yachi hen chan funfunyagan Juan. ");
INSERT INTO blw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Angkay nafigat way innilan Juan ah Jesus way naway, ekatnéén, “Ilanyu ngén, anchiyan hen anchi karnero way inidchat Apudyus way michaton ah mamayadna hen fasor hen katagutagu hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hiya hen anchi chà aryén hen anchi nangaryaén, ‘Wacha hen meparég an haén way nangatngato no haén, te hiya, nawawà-acha chillu uray hen cha-an-o marmuwan.’ ");
INSERT INTO blw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yag uray haén, cha-an-o elasin hiya hen pés-éyna. Ngém hen ganchat-o way mamunyag hen tatagu ah chanum, ta mepaka-ammu an chitaaw way ganà Israel way hiya hen anchi hennag Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Yachi yag imfagan Juan agé way mangaliyén, “Hen anchi pés-éyna, maid tot-owa enlasin-o an hiya, ngém ah Apudyus way nannag an haén way mangimfunyag ah chanum, imfagana way hen anchi tagu way ilà hen émhépan hen Espirituna yag nì-iggaw, yachi hen anchi mangimfunyag hen Espiritun Apudyus hen tatagu. Wat innilà tot-owa hiya ad uwan te innilà hen enémhépan hen Espiritun Apudyus an hiya way kaman karopate yag nì-iggaw. ");
INSERT INTO blw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wat hiyachi, gapo ta innilà, tàchégà way hiya tot-owa hen anà Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Angkay nawakas way nètatàchég ah Juan hen chuway pasorotna, ");
INSERT INTO blw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","innilana ah Jesus way chan looh, yag annaat ekatén, “Anchiyan hen anchi karnero way inidchat Apudyus way michaton.” ");
INSERT INTO blw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hen nangngaran hen anchi chuway pasorot Juan an nadchi, chachaat umunud an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yachi yag namfiliwit ah Jesus yag innilana chicha way cha umunud, yag annaat ekatén, “Nokay hen chayu anapén.” Yag sommongfatcha way mangaliyén, “Rabbi, chokkay hen fabréyno.” (Hen laychén hen anchi ale way Rabbi way aryénat Apo Mistoro.) ");
INSERT INTO blw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yag ekat Jesusén, “Intaaw kaỳ ta inyu ilan.” Yachi yag netnodcha way incha innila hen iggawna, yag nì-iyancha hen hiyachiy lafi te fummatangan chillu. ");
INSERT INTO blw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Hen iha hen anchichay netnod an Jesus wat ah Andres way sonod Simon Pedro. ");
INSERT INTO blw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yag innaat nan-iyanap ah pangorowana way Simon yag imfagana way mangaliyén, “Inchahanni angkay hen anchi Cristu.” (Hen laychén hen anchi ale way Cristu way aryénat hen anchi empopostan Apudyus way umale hen antoy lota way mantoray.) ");
INSERT INTO blw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yachi yag enetnodnaat hen anchi pangorowana way Simon an Jesus. Angkay hiyachi way innilan Jesus hiya, ekatnéén, “Heay Simon way anà Juan, ngadnà heah Cefas.” (Hen anchi ngachan way Cefas, pachongna hen Pedro way hen laychénay aryénat fato.) ");
INSERT INTO blw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Angkay nafigat way ekat Jesusén éméy hen provinsiyan hen Galilea, inchahana ah Felipe yag ekatnan hiyéén, “Inta ta metnod-an haén.” ");
INSERT INTO blw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ah Felipeyanto, hiyan ihay iBetsaida way yachi agé hen fabréy cha Andres an Pedro. ");
INSERT INTO blw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Yachi yag i enanap agé Felipe ah Natanael, yag angkay inchahana, imfagana way mangaliyén, “Inchahanni angkay hen anchi tagu way ensorat Moses hen nangensoratana hen orchin way hiya agé hen anchi inyalen hen anchichay profeta ad namenghan, yag hen ngachannaat ah Jesus way eNazaret way anà Jose.” ");
INSERT INTO blw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yag sommongfat ah Natanael way mangaliyén, “Ay ammoh wachay ammay ah tagu way marpod Nazaret tà.” Yag ekat Felipeyén, “Umalea ngén ta inta ilan ya.” ");
INSERT INTO blw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Angkay hiyachi way innilan Jesus ah Natanael way naway ekatnéén, “Antoyan hen ihay onong way ganà Israel way maid tot-owa kétémna.” ");
INSERT INTO blw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yag ekat Natanaelén, “Nokay hen nangammuwam an haén.” Yag ekat agé Jesusén, “Inni-ilà hea way tummutùchu hen pongar hen anchi away way fig hen cha-an mangchahan Felipe an hea.” ");
INSERT INTO blw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Apo, hea peet hen anà Apudyus,” way ekat Natanael, “ya hea agé hen anchi areni way nepoposta way ganà Israel.” ");
INSERT INTO blw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yag anat ekat Jesusén, “Ay anggay yanggay hen nangimfag-à way innilà hea way tummutùchu hen pongar hen away yag enafurotnowat way haén hen Cristu. Wat chùchùar angkay hen kaskascha-aw way mailayu no yaha.” ");
INSERT INTO blw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yag imfagan Jesus an chicha amin way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way mailayu hen mafùtana ad uchu ya hen mamfangchafangchan hen anchichay anghel Apudyus an haén way Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Angkay hiyachi way nanlooh hen chuway ag-agaw, yag wacha hen mankasar ad Cana way sakop hen Galilea, yag i nèkasar ah inan agé Jesus. ");
INSERT INTO blw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ya naimfitar agé ah Jesus ya hen anchichay pasorotna. ");
INSERT INTO blw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Angkay hiyachi yag ammag na-amin hen anchi mainum way fayah, wat i imfagan inan Jesus an hiya way mangaliyén, “Nokay hen mapoot te antoy na-amin hen anchi mainum.” ");
INSERT INTO blw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yag anat ekat Jesusén, “Ina, achi koma masapor ifagam hen ammaà ta egachà, te cha-an umchah hen tempon hen mangempàil-à hen kafaelà.” ");
INSERT INTO blw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngém imfagan inana chillu hen anchichay chan ap-apag way mangaliyén, “Anyug ammaan hen uray heno way ifagana an chàyu.” ");
INSERT INTO blw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Angkay hen anchichay Judio, gapo ta chuar hen liglamentocha mepanggép hen ekamancha way man-urah wat wacha tot-owa hen éném way chachanakkar way arangfa way na-ammaan ah fato way chacha mangig-iggaan ah chanum way ihaihéén malemaan lataan. ");
INSERT INTO blw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yachi yag ekat Jesus hen anchichay chan ap-apagén, “Ponowényu hen annachay arangfa ah chanum.” Wat pennocha ingganah nanenep. ");
INSERT INTO blw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yag anat agé ifagan Jesus an chicha way mangaliyén, “Iyapagyu hen annay anyuwat henàchu way chanum, yag inyu empahemhem hen anchi cha mangemponponò hen hiyatoy among.” Wat inyéycha hen anchi chanum ");
INSERT INTO blw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","yag namfalinat agé ah fayah yag henemheman hen anchi cha mangemponponò. Yag gapo ta maid innilana hen narpowan hen anchi ammay way fayah, te anggay hen anchichay chan ap-apag ah nangi-ila, wat annaat epa-ayag hen anchi larae way omahawa, yag ekatnéén, ");
INSERT INTO blw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Pakayto, te gagangay met way miwaras unna hen anchi ammayay fayah ta no loohcha uminum hen tatagu yag anat eparég hen anchi faén unay ammay. Ngém hea, safali hen enkamanno te annog inyanongoh hen antoy am-ammay.” ");
INSERT INTO blw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hen yahay enammaan Jesus, enammaana ad Cana way sakop hen Galilea way yaha hen pés-éy kaskascha-aw way enammaana ah mangempàil-ana hen mannakafalinna. Wat ommafurot hen anchichay pasorotna an hiya. ");
INSERT INTO blw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Angkay narpaschi, émméy ah Jesus yah inana, ya hen anchichay sosnodna ya anat hen anchichay pasorotna ad Capernaum, yag ininggawcha ahchi ah kamanay ag-agaw. ");
INSERT INTO blw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Angkay hiyachi, gapo ta tég-angay umchah hen anchi lagsak hen Judio way Manmanma-an hen iggay mapchitan hen a-anà hen ganà Israel ad Egipto, wat émméy ah Jesus ad Jerusalem. ");
INSERT INTO blw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yachi way émméy ah Templo, inchahana hen anchichay tatagu way chan elao ah michaton an Apudyus way faka ya karnero ya karopate, ya wachacha agé hen anchichay tummutùchu hen lamesa-ancha way chan soksokat ah pelak. ");
INSERT INTO blw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wat ammag ommamma ah Jesus ah ehapratna yag enadchugna amin hen anchichay faka ya karnero ah Templo yag emparyawna chicha amin yag lenotwadna agé hen lamesa-an hen anchichay chan soksokat ah pelak wat ammag nelòyag hen pepelakcha. ");
INSERT INTO blw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yag menancharna agé hen anchichay chan elaoh karopate way mangaliyén, “Elayawyuwat hen annachay chayu elao, te ay ammoh anyug mamfalinén hen antoy faréy Ama ah market.” ");
INSERT INTO blw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hen nangil-an hen anchichay pasorot Jesus hen anchi enammaana, hemhemmàcha hen anchi nesosorat way alen Apudyus ad namenghan way ekatnéén, “Wacha tot-owa hen ammag ma-ammaan an haén gapo ta anà ammag mararata way mangi-ila hen chacha ekaman way achi manrispitu hen antoy faréyno, Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yachi yag anat ekat hen anchichay ap-apo way toray hen Judio an Jesusén, “Heno man paat hen kaskascha-aw way sinyar ah ammaam ah manot-owaanni way wachan lébféngno way mangamma an nahhay enammaam.” ");
INSERT INTO blw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yag ekat Jesus way tenomfarén, “No fakkasényu hen antoy Templo wat patàchégê chillu hen ma-atloy ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Ayong-ang,” way ekat anchichay Judio, “ay an-ag mampahear ta an yanggay toroy ag-agaw yag empatàchégnowat hen yatoy Templo way émméy ah opatporo ya éném way tawén hen nangammaan hen anchichay nangamma.” ");
INSERT INTO blw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngém ah Jesus, faén peet anchi Templo way faréy hen chana aryén, te empanina hen anchi Templo ah acharna. ");
INSERT INTO blw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Angkay hiyachiy na-awni way narpas hen nan-uchiyan Jesus, hemhemmà anchichay pasorotna hen yachiy enalena yag am-améd hen ommafurotancha hen anchi nesosorat way alen Apudyus ya anat agé hen enalena. ");
INSERT INTO blw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hen kawad-an Jesus ad Jerusalem hen tempon hen anchi lagsak way Manmanma-an, chuar hen ommafurot an hiya gapo hen nangil-ancha hen anchichay kaskascha-aw way enammaana. ");
INSERT INTO blw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ngém iggay chillu mapnek ah Jesus hen ekatchéén ommafurotancha an hiya, te inni-ilana hen hamhamà hen aminay tatagu. ");
INSERT INTO blw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wat achi masapor way wachan mangintudtuchu an hiya hen kenatatagun hen tatagu te inni-ilana chillu hen wachah hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Angkay hiyachi yag wachan ihay Fariseo way toray hen Judio way ah Nicodemo hen ngachanna. ");
INSERT INTO blw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Angkay henlafiyan, émméy ah Nicodemo an Jesus way mangaliyén, “Apo, innilani way ah Apudyus hen nannag an hea way mantudtuchu, te maid maka-amma hen annachay kaskascha-aw way cham ammaan no maid ah Apudyus an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yachi yag sommongfat ah Jesus way mangaliyén, “Tot-owa hen antoy ifagà an hea way achi angkay mafalin metape hen tagu hen mantorayan Apudyus no achi kasen miyanà.” ");
INSERT INTO blw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yag anat ekat Nicodemowén, “Ay ammoh mafalin lawa kasen miyanà hen looh ommam-ama, te ay ammoh manfangad ah poton inana yag anat kasen miyanà.” ");
INSERT INTO blw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yag ekat Jesusén, “Tot-owa chillu hen antoy chà ifaga an hea way achi mafalin metape hen tatagu hen mantorayan Apudyus no achi miyanà ah chanum ya hen Espiritun Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Te ilamat, hen anchi tagu way iyanà hen tatagu, anà met hen tataguchi. Waman hen anchi tatagu way kasen miyanà way ah Espiritun Apudyus paat hen manginyanà an hiya, hiya agé hen anà Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wat achia mahaang hen antoy mangimfag-à way masapor kasen-a miyanà. ");
INSERT INTO blw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hen miyaligana, kaman hen anchi yawyaw way egad hen laychénay ayan hen chana manyawyawan. Yag tàén chachangréntaaw hen uswarna, maid chillu innilataaw hen chana marpowan ya hen chana ayan. Wat kaman agéhchi hen ekaman hen miyanà ah Espiritun Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yag ekat Nicodemowén, “Henoay agén én-énnén nattowa way ammag achi ma-awatan.” ");
INSERT INTO blw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yag anat ekat Jesus an hiyéén, “Pakay ammag nangatoa way chan tudtuchu an chitaaway ganà Israel yag achim peet ma-awatanto. ");
INSERT INTO blw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Te tot-owa way hen chani aryénat hen anchi tot-owa way innilani ya hen anchi chani haphapeténat hen anchi innilan paat hen matani. Ngém anyug achi chillu afuroton. ");
INSERT INTO blw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yag ilamat, no achiyu afuroton hen chà ifaga mepanggép hen mekaman hen antoy lota, ay ammoh achi kaskasen no ifagà hen mepanggép ad uchu. ");
INSERT INTO blw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yag mepanggép ad uchu, maid poros tagu ah émméy ad uchu no faén yanggay haén way Pangorowan hen Tatagu, te ahchid uchu chillu hen narpowà.” ");
INSERT INTO blw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Yachi yag penanin Jesus hen enkaman Moses, ekatnéén, “Ad namenghan, hen kawad-an cha Moses hen anchi chanak, enammaana hen anchi gamfang ah finab-arakkan yag enhabrotna ah managuwana hen tatagu, wat kaman agéhchi hen mehabrotà way Pangorowan hen Tatagu. ");
INSERT INTO blw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wat heno way mangafurot an haén, midchat an hiya hen mannanayun way mètaguwana an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Te ah Apudyus, gapon anchi amchan way layadna hen tatagu, empalena hen anchi ih-ihà-an way anàna hen antoy lota way matéy ta heno way mangafurot hen anchi anàna, achi metap-ar te mì-iggaw an hiya ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Iggay hennag Apudyus hen anàna hen antoy lota way i manusa hen tatagu, te anna hennag ta wachay kahara-an hen tatagu. ");
INSERT INTO blw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wat heno way omafurot an hiya, achi machusa. Waman hen anchi achi omafurot, looh nifafagga hen machusaana gapon achina mangafurotan hen anchi anà Apudyus way empalena. ");
INSERT INTO blw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yag yato hen gapona ah machusaan hen tatagu, te ummale hen anchi anà Apudyus hen antoy lota way manelaw hen hamhamà hen tatagu, ngém hen tatagu, anchag achi laychén way mahelawan hen hamhamàcha, te anchag laylaychén hen anchi helang. Ya hen manlaychéncha hen anchi helang, te laweng hen a-ammacha. ");
INSERT INTO blw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kapeletan way heno way tagu way cha mangamma hen laweng, achina laychén hen paway ya achina agé laychén way homag-én hen anchi iggaw hen helaw te maila hen kenarawengna. ");
INSERT INTO blw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Waman hen anchichay tatagu way cha mangamma hen usto, chichachi hen manlayad way homag-én hen anchi helaw ya yachi agé hen mail-ana way chacha ammaan hen anchi laychén Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Angkay narpaschi yag émméy ah Jesus ya hen anchichay pasorotna hen provinsiyan hen Judea, yag ini-inggawcha ahchi way cha mamunyag hen tatagu. ");
INSERT INTO blw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yah Juan agé way chan funfunyag, wacha ad Enon way nehag-én ad Salem te chuar hen chanum ahchi wat chana agé funyagan hen anchichay tatagu way cha éméy an hiya way mampafunyag. ");
INSERT INTO blw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hen hiyachiy tempo, cha-an mifarud ah Juan. ");
INSERT INTO blw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Angkay hiyachi, wachacha hen tapen anchichay pasorot Juan way nèsongel hen ihay kacharaancha way Judio mepanggép hen funyag. ");
INSERT INTO blw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wat yachi agé yag émméy hen anchichay pasorot Juan an Juan yag imfagacha way mangaliyén, “Apo, ay matancha-anam hen anchi tagu way nan-ifam hen kawad-antaaw hen chumang hen antoy wangwang ad Jordan way empachamagno an chàni, te cha angkay mamfunyag agé ad uwan, yag hiyaat agé hen cha ayan amin hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ngém sommongfat ah Juan way mangaliyén, “Achiayu machanagan an nahha te maid chillu tatagu ah maka-amma hen ammaana no achi eparufus Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yag chechengngaryu agé hen anchi chà imfagafaga way faén chillu haén hen Cristu, ngém anà yanggay an namangpango way i mangimfaga hen tatagu ta mansaganacha way omafurot an hiya. ");
INSERT INTO blw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Hen mepaniyana, kaman hen larae way mangahawa hen fufae way hiya met hen manhagongan hen anchi fufae ta faén agé hen anchi mamatfar. Ya hen anchi mamatfar, chachangréna hen ifagan hen anchi larae, yag ammag laylayad hen mangenteponana an ahawana. Wat kaman haén hen anchi i namatfar yag ana-at ammag laylayad way mangi-ila hen ayan hen tatagu an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kapeletan way hiya, an cha ngomato, waman haén, anà an cha fumafa.” ");
INSERT INTO blw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Entoroy Juan way mangaliyén, “Hen anchi narpod uchu, hiya hen kangatowan. Waman hen anchi narpon antoy lota, an lawag tatagu yag hen antoy lota yanggay hen péppég hen innilana. Waman hen anchi narpod uchu, nangatngato no hen amin way ininggaw hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ya hiya, chana haphapetén hen amin way innilana ya chengngarna ngém ancha chillu aket way mangafurot an hiya. ");
INSERT INTO blw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yag hen anchi mangafurotancha, yachi hen mangempàil-ancha way chacha agé afuroton way tot-owa hen enalen Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yag hen anchi empalen Apudyus, maid kasen aryéna no achi yanggay hen anchi inyalen Apudyus, te nawawà-acha hen Espiritun Apudyus an hiya. ");
INSERT INTO blw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ammag pararo hen layad Amay Apudyus hen anchi anàna wat impiyarna hen egad an hiya. ");
INSERT INTO blw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wat heno way mangafurot hen anchi anàna, mètagu an Apudyus ah ing-inggana. Waman hen anchi achi omafurot an hiya, achi mètagu an Apudyus te an chuséén Apudyus hiya ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Angkay hiyachi yag hen anchichay Fariseo, chengngarcha way chùchùar ano hen sommorot an Jesus ya hen finunyagana no hen finunyagan Juan way chan funfunyag. ");
INSERT INTO blw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ngém ah katot-owana, maid finunyagan Jesus te hen anchichay pasorotna yanggay hen namfunyag. ");
INSERT INTO blw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ngém angkay na-awatan Jesus hen chacha aryén, lommayawcha hen provinsiyan hen Judea way kasen émméy hen sakop hen Galilea. ");
INSERT INTO blw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ya maid agé kasen màwa no faén hen anchi provinsiyan hen Samaria. ");
INSERT INTO blw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Angkay hiyachi way cha charanén cha Jesus hen sakopon hen Samaria, yag inumchahcha ad Sicar way ihay fabréy way nehahag-én hen anchi lota way inidchat Jacob an anàna way Jose ad namenghan. ");
INSERT INTO blw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yag yachi way nanggawa, tummutùchu ah Jesus hen iggaw hen anchi chaghiyan way kenaufan Jacob te naungar way nanaran. ");
INSERT INTO blw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Waman hen anchichay pasorotna, émméycha ah fabréy way i lommao ah anéncha. Angkay hiyachi, yag émméy hen ihay fufae way eSamaria way i manàchu an nadchi, yag imfagan Jesus an hiya way mangaliyén, “Ay mafalin ta uminumà hen annay henàchum.” ");
INSERT INTO blw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yag ammag nascha-awat agé hen anchi fufae te hen anchichay Judio, chacha marémha way mangusar hen tasan hen eSamaria. Wat annaat ekatén, “Pakay ad uwan yag man-ochaw-a way Judio ah chanum an haén way eSamaria.” ");
INSERT INTO blw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yag sommongfat ah Jesus way mangaliyén, “Non anno koma innila hen mafalin idchat Apudyus an hea, ya non anno agé innila no henowà way chan ochaw ah chanum, wat hea hen man-ochaw an haén yag idchat-o hen anchi chanum way no inumun, antag achi màmàwaw ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yag ekat hen anchi fufaeyén, “Oo Apo, ngém maid met uy-uyum ah iyaram hen annay chanum yag adcharum agé hen antoy chaghiyan, wat nokay lawa hen kasenno i mangar-an hen annay chanum way ekatnowén antag achi màmàwaw no inumun. ");
INSERT INTO blw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Te hen antoy chaghiyananto, yato met hen finùan apotaaw way Jacob ad namenghan yag empatawidna an chitaaw. Yag yato met agé hen nanagu an chicha way hen-anamma ya anat agé hen anchichay animarna. Yag ekatnowat agéén nangatngatoa no hiya ta napatpateg hen chanumno.” ");
INSERT INTO blw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yachi yag anat ekat Jesusén, “Aminay tatagu way manginum hen chanum hen yatoy chaghiyan, kasencha chillu màwaw. ");
INSERT INTO blw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Waman hen anchi manginum hen anchi chanum way idchat-o, achi kasen màmàwaw ah ing-inggana te hen hiyachiy chanum way idchat-o, mìyachar an hiya ah kaman fufun way achi matmatchù, yag idchatna agé hen mannanayun way ataguwana an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yachi yag anat ekat anchi fufaeyén, “Apo, umpayat adchanà hen yahay chanum ta achiyà màmàwaw ya ta achiyà agé cha umaleale ahto way manàchu.” ");
INSERT INTO blw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yag anat ekat Jesusén, “Wat in-a ta im ayagan ah ahawam ta umaleayu ahto.” ");
INSERT INTO blw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Oo a, ngém maid met ahawà,” way ekat hen anchi fufae. Yag ekat agé Jesusén, “Tot-owa hen annay enalem way ekatnowén maid ahawam, ");
INSERT INTO blw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","te lemacha hen enahawam, ya hen anchi wacha an hea ad uwan wat faén chillu ustoy ahawam. Wat tot-owa hen annay enalem way maid ahawam.” ");
INSERT INTO blw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yag tenomfar hen anchi fufae way mangaliyén, “Apo, maelasin-o way profeta-a peet. ");
INSERT INTO blw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wat pakay uwa hen anchichay anap-oni ad namenghan wat hen yatoy filig hen chacha nanayawan an Apudyus. Ngém chàyu way Judio, ekatyuwén ad Jerusalem paat hen ustoy manayawan hen tatagu an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yachi yag ekat Jesus hen anchi fufaeyén, “Afurotom koma hen antoy ifagà way umchah hen tempo way faén hen yatoy filig ya faén agé ad Jerusalem hen manayawan hen tatagu an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Chàyu way eSamaria, maid innilayu an Apudyus way ekatyuwén chayu chayawén. Ngém chàni way Judio, innilani hen chani chayawén te hen Judio hen fùnagan hen anchi manarà hen aminay tatagu. ");
INSERT INTO blw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yag inu-umchah hen tempona way manepod ad uwan, heno way manayaw an Apudyus ah usto paat, masapor chayawéna hiya ah narpoh tot-oway hamhamàna ta faén yanggay marpoh tapàna, te yachi hen laychén Apudyus way ekaman hen manayaw an hiya. ");
INSERT INTO blw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Te ah Apudyus, hiya hen espiritu way achi maila, wat hen anchichay manayaw an hiya, faén ah ancha an epàpàila te masapor marpo ah hamhamàcha paat te yachi hen marpowan hen tot-owa way chayaw.” ");
INSERT INTO blw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yachi yag ekat hen anchi fufaeyén, “Afurotò way ah tapen chi ag-agaw wat umale hen anchi empopostan Apudyus way epalena way ekatchéén Cristu. Yag hiya, itudtuchuna hen aminay maid innilataaw.” ");
INSERT INTO blw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yachi yag anat ifagan Jesus an hiya way mangaliyén, “Haén way cha managépfar an hea, haén hen Cristu.” ");
INSERT INTO blw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hen hiyachiyat agé inumchah hen anchichay pasorot Jesus yag anchag nahahaang way nangchah an Jesus way cha mètagépfar hen anchi fufae. Ngém maid chillu nanarudsud an chicha no heno hen masaporna ya pakay cha tagépfarén Jesus hiya. ");
INSERT INTO blw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Angkay hiyachi yag tenaynan hen anchi fufae hen anchi idchanumanna yag hommàyat ah fabréy way i nangimfaga hen anchichay tatagu way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Intaaw ngén ta intaaw ilan hen anchi tagu way nangimfaga hen angamin way enam-ammaà, te magat hiya hen anchi empopostan Apudyus way Cristu.” ");
INSERT INTO blw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yachi yag naligwatcha amin hen anchichay tatagu ah fabréy way i mangila an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Angkay hen anchichay pasorot Jesus, chacha à-aro-on hiya way mangaliyén, “Apo, pakay achia mangan.” ");
INSERT INTO blw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngém tenomfar ah Jesus way mangaliyén, “Oo a, ngém wacha chillu hen enan-o way maid innilayu.” ");
INSERT INTO blw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yachi yag chachan ahepennoot way mangaliyén, “Ay wacha ngatay nanginyale ah enanna.” ");
INSERT INTO blw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ngém an peet an chan pani ah Jesus, te ekatnéén, “Hen chà anén way cha managu an haén wat hen chà mangammaan hen anchi laychén Apudyus way nannag an haén, ya ta lopasê way mangamma hen anchi impiyarna an haén.” ");
INSERT INTO blw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Entoroy Jesus way mampani, ekatnéén, “Wacha hen mangaliyén egad marpas hen opatay furan yag anat ahebtà. Ngém hen ifagà an chàyu, ahebtà angkay ad uwan. Te ilanyu ngén hen annachay tatagu way naway way mafalin omafurot an haén, te kamancha yanggay pagéy way naggahén way masapor koma mabtà ad uwan. ");
INSERT INTO blw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ya hen anchichay tatagu way cha i mangintudtuchu hen omafurotan hen tapena, kamancha hen anchichay i mamfatà, ya chicha, marabfuwancha. Ya faén agé anggayha, te mannanayun agé hen anchi fat-éncha. Ya hen anchi i nanhamar, pachongna agé hen anchi i mamfatà te amchan hen laylayadcha amin. ");
INSERT INTO blw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Te tot-owa hen anchi ekatchéén, ‘Hen tapena, chicha hen i manmura, ya hen anchichay tapena agé, chicha hen i mamfatà.’ ");
INSERT INTO blw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wat hénagê chàyu way i mamtà hen anchi inmuran hen tapena way yachi hen chayu metapyan hen anchi enammaancha.” ");
INSERT INTO blw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Angkay hiyachi yag chuar hen ommafurot way eSamaria an Jesus gapo hen nanaphapetan hen anchi fufae way imfagan Jesus hen amin way enam-ammaana. ");
INSERT INTO blw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Wat yachi way inumchahcha an Jesus, penaraudcha hiya ta homàyat koma ah fabréycha, wat émméy cha Jesus yag ommargawcha ah fabréycha. ");
INSERT INTO blw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yag chummùchùarcha agé hen ommafurot hen nangngarancha hen intudtuchuna. ");
INSERT INTO blw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yag imfagacha hen anchi fufae way mangaliyén, “Ommafurot-ani met gapo hen nanaphapetam, ngém kaskasen ad uwan hen nangngaranni paat an hiya wat sigurachuani way hiya tot-owa hen anchi hennag Apudyus way mangenharà hen aminay tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Angkay hiyachi way ommargaw cha Jesus ahchi, lummigwatcha way éméy chillu hen sakopon hen Galilea way chummakran Jesus. ");
INSERT INTO blw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yag mepanggép hen ayanchahchi, ekat Jesusén, “Uray heno way profetéén achi tot-owa mangiggéén hen kailiyana hiya.” ");
INSERT INTO blw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Angkay inumchahcha hen provinsiyan hen Galilea, laylayadcha hen tatagu way mangila an hiya, te chicha, nèlagsakcha ad Jerusalem yag innilacha amin hen anchichay kaskascha-aw way enammaana ahchi. ");
INSERT INTO blw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Angkay hiyachi yag namfangad cha Jesus ad Cana way sakop hen provinsiyan hen Galilea way ahchi agé hen anchi namalinana hen chanum ah fayah. Yag niyaphor way wacha agéhchi hen ihay okom way chan saket hen anchi anàna ad Capernaum. ");
INSERT INTO blw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Angkay chengngar hen anchi okom way wacha peet ah Jesus hen provinsiyan hen Galilea way narpod Judea, ina enayagan ta éméy koma ad Capernaum ta ina ka-anén hen saket hen anchi anàna way tég-angay matéy. ");
INSERT INTO blw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yag ekat Jesus an hiyéén, “An-ayug achi tot-owa omafurot no maid ilanyu ah sinyar ya kaskascha-aw.” ");
INSERT INTO blw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yag ekatat hen anchi okomén, “Apo, panga-asemat man ta umaleaat te awni yag matéy hen anchi anào.” ");
INSERT INTO blw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“Wat in-aat,” way ekat Jesus, “te naka-an hen saket hen anchi anàno.” Yachi yag enafurot hen anchi okom hen enalen Jesus yag lommayaw. ");
INSERT INTO blw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yag hen chana homàyatan, hinib-atna hen anchichay alepanna way naway way i mangimfaga way gumminang peet hen saket hen anchi anàna. ");
INSERT INTO blw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yachi yag senarudsudna no heno way uras hen gumminangan hen saketna, yag ekatchéén, “Hen cha magéyéd ad ugga hen naka-anan hen saketna ya uray hen pochotna.” ");
INSERT INTO blw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yachi yag hemhemmà hen anchi am-ama way yachi paatay uras agé hen nangimfag-an Jesus an hiya way mangaliyén, “Naka-an hen saket hen anàno.” Wat amincha way himfafaryan, ommafurotcha amin an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hen anchi namfangchan cha Jesus hen provinsiyan hen Galilea way narpo ad Judea, yachi hen anchi pegwan hen nangammaana hen kaskascha-aw. ");
INSERT INTO blw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Angkay hiyachi way narpas amin chachi, émméy cha Jesus ad Jerusalem way i mèlagsak hen ihay lagsak hen Judio. ");
INSERT INTO blw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yag ahchid Jerusalem, wacha hen ihay po-ong way nehag-én hen anchi fùnagan hen fabréy way chacha mangèwaan hen karnero way hen ngachan hen anchi po-ong ah Henebreo wat Betsata. Ya wacha agé hen lemay kaman afong way nampaliwéh hen anchi po-ong ");
INSERT INTO blw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","way chacha mangempeengan hen anchichay chuaray tatagu way nankarakarase hen saketcha, te wacha ay nabfurag ya nappelay ya napàroy chi acharna. Ya i-inggawcha an nadchi way manmannéd hen omabfuaran ano hen anchi chanum, ");
INSERT INTO blw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","te no hen-argawanén wacha ano hen anghel Apudyus way émhép way i mangehwar hen anchi po-ong, yag hen anchi pés-éy paat pomassong no maehwar, wat maka-an ano hen anchi uray heno way saketna. ");
INSERT INTO blw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Angkay hiyachi yag wacha an nadchi hen ihay larae way émméy ah toronporo ya waru way tawén hen nansaketana. ");
INSERT INTO blw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Angkay innilan Jesus hiya way enlasinna way nafayag hen fummafàtachana yag annaat ifaga way mangaliyén, “Ay laychém way maka-an hen annay saketno.” ");
INSERT INTO blw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","“Oo Apo,” way ekat hen anchi chan saket, “ngém maid ampay manorong an haén way mangempassong no omabfuar hen anchi chanum, yag gapo ta solet hen ekaman-o way éméy, wat achiyà umchahén wachaat hen looh nampassong.” ");
INSERT INTO blw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yachi yag anat ekat Jesus an hiyéén, “Wat fumangon-a yag leno-otno hen annay annapno te makacharan-aat ad uwan.” ");
INSERT INTO blw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yag hen hiyachi, naka-anat tot-owa hen anchi saketna, wat lenabtenna hen anchi annapna yag tommàchég way manaran. Hen anchi ag-agaw way na-ammaan natto wat Safachu way yachi chillu hen anchi siguchay ngilin hen Judio. ");
INSERT INTO blw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wat hen anchichay anap-apon hen Judio, iningarcha hen anchi anat naka-an hen saketna way mangaliyén, “Ammag ngilintaaw ad uwan yà. Wat cham angkay labsengén hen orchintaaw hen annay nanlarabtenam hen annapno.” ");
INSERT INTO blw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yag sommongfat hen anchi nansaket way mangaliyén, “Oo a, ngém hen anchi tagu way nanga-an hen saket-o, hiya hen nangimfaga an haén way labtenê hen antoy annap-o yag nanaranà.” ");
INSERT INTO blw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yag anchaat imohon way mangaliyén, “Nokay paat hen katatagun nahha way nangimfagan nahha an hea.” ");
INSERT INTO blw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngém hen anchi taguwanchi way anat naka-an hen saketna, maid innilana no henoh nadchi hen anchi nanga-an hen saketna, te nekalliwat ah Jesus te ancha chillug chuar hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Angkay na-awni way inchahan chillu Jesus hiya ah Templo, ekatnéén, “Ilamat ammay hen acharno ad uwan te naka-an hen saketno, wat etagayno way cha fumasofasor ta achi am-améd hen kasen mepachah an hea.” ");
INSERT INTO blw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Angkay hiyachi yag lommayaw hen anchi taguwanchi yag ina henaphapet hen anchichay anap-apon hen Judio way ah Jesus peet hen nanga-an hen saketna. ");
INSERT INTO blw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Wat hen anchichay anap-apo, gapon nanga-anan Jesus hen saket hen tempon hen ngilin, anchag inlugi way mangan-a an hiya. ");
INSERT INTO blw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngém senongfatan Jesus chicha way mangaliyén, “Ah Amay Apudyus, maid man-in-inungarana way mangamma hen chana ammaan, wat yachi agé hen ekaman-o.” ");
INSERT INTO blw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yachi yag ommam-améd hen aningarngar hen anchichay anap-apo an Jesus wat anchag térnén paat way mamchit an hiya, te faén yanggay hen chana manlabsengan hen ngilin, te hen iha, hen anchi chana mangempachongan hen acharna an Apudyus hen anchi mangaryanéén, Amana ano ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Angkay hiyachi way entoroy Jesus hen chana ifaga an chicha, ekatna way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way haén way anà Apudyus, maid am-ammaà no anà ammag anggay, te chà yanggay ammaan hen anchi i-illà way cha ammaan Ama. Wat amin way cha ammaan Ama, yachi agé hen chà ammaan. ");
INSERT INTO blw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Te ah Ama, laylaychéna haén way anàna, wat amin way chana ammaan, chana agé epàila an haén. Ya wacha agé hen kasenna epa-amma an haén way wadwadcha way kaskascha-aw no hen anchi anyuwat innila ta wachay kahaanganyu. ");
INSERT INTO blw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Te ah Ama, mafalin man-uchiyéna hen natéy. Wat umat agé haén way anàna, mafalin agé taguwê hen anchichay tatagu way laychê way taguwén. ");
INSERT INTO blw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ya faén agé ah Ama hen manguwis hen tatagu, te piniyarna haén way manguwis hen egachay tatagu, ");
INSERT INTO blw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ta way manayawan hen tatagu an haén way kaman hen manayawancha an Ama. Wat heno way achi manayaw an haén, achina angkay agé cha chayawén ah Ama way nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tot-owa hen antoy ifagà an chàyu way heno way tagu way mangngar hen chà itudtuchu ya afurotona agé hen anchi nannag an haén, wat mètagu an Apudyus ah ing-inggana. Ya achi agé machusachi te inlisiyana hen metap-arana way ad uwan, metatappe an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tot-owa hen antoy ifagà an chàyu way inu-umchah angkay hen tempona way manepod ad uwan, hen anchichay kaman nanattéy an Apudyus, no changréncha hen ifagà way anà Apudyus yag enafurotcha, wat taguwê chicha ta mètagucha an Apudyus ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ah Ama, hiya hen pongar hen ataguwan, yag piniyarna haén way anàna ah pongar hen ataguwan agé. ");
INSERT INTO blw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yag impiyarna agé an haén hen karébféngà way manguwis hen tatagu te haén hen anchi Pangorowan hen Tatagu. ");
INSERT INTO blw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Achiayu mahaang hen antoy chà ifaga way umchah way umchah hen tempona way uray hen anchichay aminay nilurufù, changréncha hen alè, ");
INSERT INTO blw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","wat man-uchicha amin. Wat hen anchichay nangamma hen ammayén Apudyus, mètagucha an hiya ah ing-inggana. Waman hen anchichay nangamma hen lawengén Apudyus, mètagucha agé ah ing-inggana hen anchi kachusaancha.” ");
INSERT INTO blw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yachi yag entoroy Jesus way mangaliyén, “Haén, ammaà yanggay hen anchi nipiyar ah haén. Wat maid am-ammaà ah uray heno no iggay midchat hen karébféngà way mangamma. Ya hen manguwisà hen tatagu, chà agé torachén hen imfagan Ama, wat kapeletan nalimpiyu hen manguwisà hen tatagu te faén hen laychê hen chà ammaan te hen laychén hen anchi nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“No haén yanggay hen man-istigu hen achar-o, awni yag maid mangafurot an haén. ");
INSERT INTO blw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngém wacha hen anchi iha way cha man-istigu an haén, ya innilà way ifagana hen tot-owa mepanggép an haén te hiyah Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yag chàyu, wachacha agé hen anchichay hennagyu way i mangimoh an Juan mepanggép an haén, yag imfagana hen tot-owa. ");
INSERT INTO blw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngém ah katot-owana, achì ekatén masapor-o hen tatagu ah man-istigu an haén, ngém hen mangempahpahma-à an chàyu hen anchi enalen Juan ta omafurot-ayu koma ah kahara-anyu. ");
INSERT INTO blw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Te hen miyaligan Juan, kaman helaw way napapasgichan way cha homelaw yag lelenyadyu hen hommelawana hen hen-aketan te ammag hen-aketan yanggay hen nanlaychanyu hen imfagana. ");
INSERT INTO blw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Angkay ad uwan, wacha hen cha man-istigu an haén way wadwadcha no hen nanàchégan Juan an haén, way yachi hen anchichay chà ammaan way impiyar Amay Apudyus way ammaà. Yag chichachi hen manot-owaan way hiya hen nannag an haén hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ah Amay Apudyus way nannag an haén, chana agé istiguwan haén. Ngém chàyu, maid chengchengngaryu hen alena ya maid agé innilayu hen itchurana. ");
INSERT INTO blw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ya ammag achi paat émtép ah hamhamàyu hen chana ifaga te anyug achi afuroton haén way hennagna. ");
INSERT INTO blw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Chayu acha-acharén hen anchi nesosorat way alen Apudyus te ekatyuwén yachi hen metapyanyu an hiya, ngém chichachiyat agé peet hen cha mangimfaga hen mepanggép an haén. ");
INSERT INTO blw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ngém uray no yaha, anyug achi chillu tot-owéén haén ta idchat-o hen ketapyanyu an Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Haén, achì ammag cha anapén hen manayawanà ah tatagu. ");
INSERT INTO blw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngém innilà hen kenatataguyu way maid angkay poros layadyu an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Haén, ummaliyà hen antoy lota way ah Amay Apudyus paat hen namiyar an haén. Ngém anà ammag achi chillu ifilang an chàyu. Ngém mag-ay ta wachay tagu way annag hemhemmà yag piniyarna hen acharna, ammag hiyachiyat agé hen chayu ifilang. ");
INSERT INTO blw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yag nokay chillu hen én-énnényu way mangafurot an haén way anyug cha anapén hen mangammayan hen tatagu an chàyu yag achiyuwat anapén hen mangammayan Apudyus an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ngém achiyu ekatén haén hen mangempafasor an chàyu an Amay Apudyus, te ah Moses way chayu manchinlan, hiya hen mangempafasor an chàyu te anyug achi afuroton hen ensoratna. ");
INSERT INTO blw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Te non anyu an afuroton hen ensoratna, afurotonyu agé haén, te amin way ensoratna wat mepanggép chillu an haén. ");
INSERT INTO blw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngém gapo ta achiyu afuroton hen ensoratna, kapeletan way achiyu agé afuroton haén.” ");
INSERT INTO blw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Angkay hiyachi yag ginchang cha Jesus hen anchi fayfay way Galilea way ekatcha agéén Tiberias, ");
INSERT INTO blw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","yag ammag chuar way tatagu hen cha umunud gapon nangil-ancha hen kaskascha-aw way enammaana hen nanga-anana hen saket hen anchichay chan sasaket. ");
INSERT INTO blw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yachi yag ommabrat cha Jesus ya hen anchichay pasorotna hen ihay tagéytéy yag intùchucha. ");
INSERT INTO blw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hen hiyachiy tempo, anchag chuar hen tatagu te tég-angay hen anchi lagsak hen Judio way ekatchéén, Manmanma-an hen iggay napchitan hen a-anà hen anap-ocha ad Egipto. ");
INSERT INTO blw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yachi yag nanlangranga ah Jesus yag innilana hen anchichay chuar way tatagu way naway yag annaat ekat an Felipe way ihay pasorotnéén, “Chuud ngata hen lomàwantaaw ah érégna ah anén hen annachay tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A-ammun Jesus chillu hen ekamanna ngém hen nangimohana, ta ilana no nokay hen hamhamà Felipe. ");
INSERT INTO blw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Yag sommongfat ah Felipe way mangaliyén, “Uray ay gastoson hen labfu ah makatawénat achina ay chillu ummat ah uray lawa manemhemancha.” ");
INSERT INTO blw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yachi yag nan-ale ah Andres way sonod Pedro way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wacha hen ihay cha fumafaru way nanhangat ah lemay tenapay ya chuway files, ngém ay ammoh ummat lawachi ah para hen annachay lonay way tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yachi yag anat ekat Jesus an chichéén, “Ifagayu hen annachay tatagu ta tumùchucha.” Yachi yag tummùchucha amin hen anchichay tatagu hen anchi pachinaroh wat émméy ah lemanlifu hen filang hen anchichay lenarae yanggay. ");
INSERT INTO blw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Angkay hiyachi yag innaran Jesus hen anchi tenapay yag nanyaman an Apudyus yag annaat epiyàchang hen anchichay tatagu. Yag yachi agé hen enkamanna hen anchi files wat nanganangancha amin hen anchichay chuaray tatagu ingganah nagipohcha. ");
INSERT INTO blw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Angkay nagipohcha amin yag imfagan Jesus hen anchichay pasorotna way amongoncha amin hen nafay-anan ta maid maramram. ");
INSERT INTO blw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Angkay enamongcha hen anchi finay-anan hen tatagu, yag napnowat agé hen hemporo ya chuway awit way narpo hen anchi yanggay lemay tenapay. ");
INSERT INTO blw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hen nangil-an hen anchichay tatagu hen anchi kaskascha-aw way enammaan Jesus, ekatchéén, “Hiyato angkay hen anchi profeta way hahadchéntaaw way ekat Apudyusén epalena hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yag yachi, gapo ta enlasin Jesus hen hamhamà hen anchichay tatagu way tég-angaycha i peletén hiya way man-are, wat tenaynanaat chicha way i ommanggay hen anchi tagéytéy way futaaw. ");
INSERT INTO blw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Angkay hiyachi way cha madhém, émméy hen anchichay pasorot Jesus hen anchi penget hen fayfay, ");
INSERT INTO blw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","yag hinénggépcha hen anchi fangka way gumchang way éméy ad Capernaum te hommelang yag achi ihéh mamfangad ah Jesus. ");
INSERT INTO blw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Angkay hiyachi way nanlurugancha hen anchi fangka yag ammag inumchah hen séréchay fali, wat ammag chan hibhibyat hen anchi chanum. ");
INSERT INTO blw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tàénchi yag chachaat ichuruchurun hen anchi fangka. Wat angkay ommag-agginawacha way émméy ah énémay lometor ménat, innilachaat agé ah Jesus way cha manaran hen uhun hen anchi chanum way cha homag-én an chicha, yag chachaat agé émégyat way térén. ");
INSERT INTO blw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yag anat man-aleh Jesus way mangaliyén, “Haénto wat achiayu cha émégyat.” ");
INSERT INTO blw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wat laylayadcha way nangempaghép an hiya, yag hen hiyachi agé, inumchahchaat peet hen anchi penget hen fabréy way ayancha. ");
INSERT INTO blw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Angkay hiyachi way nafigat yag enlasin hen anchichay tatagu way nataynan ad chumang, way an ihà-an yanggay hen anchi fangka way wacha ad arubyan way yachi agé hen nanluganan hen anchichay pasorot Jesus, yag innilacha agé way iggay mìlugan ah Jesus. ");
INSERT INTO blw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Angkay hiyachi way inumchahcha hen tapen hen fangka way narpod Tiberias yag tommàchangcha hen hag-én hen anchi namanganan Jesus hen anchichay chuaray tatagu hen narpasan hen nanyamanana an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yag yachi, gapo ta na-ammuwan hen anchichay nataynan way tatagu way maid peet ah Jesus ya umat agé hen anchichay pasorotna, wat anchag hinénggép hen anchichay fangka ta gumchangcha ad Capernaum way i manganap an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Angkay hiyachi way ginumchang hen anchichay tatagu, inchahancha ah Jesus yag anchaat ekatén, “Apo, kamana peet hen ummaliyam ahto.” ");
INSERT INTO blw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yag ekat Jesus an chichéén, “Tot-owa hen antoy ifagà an chàyu way maid kasen manganapanyu an haén no faén yanggay hen anchi enammaà way mibhug way enanyu yag nabhug-ayu, yag faén ah gapo ta na-awatanyu hen pontos hen anchi enammaà. ");
INSERT INTO blw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Faén koma hen anchi ma-an way mibhug hen pa-amchanyu te mapéppég chilluchi. Ta hen pa-amchanyu koma, hen anchi ma-an way mannanayun way yachi hen mangchat hen mètaguwan an Apudyus way maid péppégna ah ing-inggana. Wat yaha hen anchi ma-an way idchat-on chàyu, haén way Pangorowan hen Tatagu, te yachi hen impiyar Amay Apudyus an haén ah ammaà.” ");
INSERT INTO blw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wat ekat hen anchichay tatagu an Jesusén, “Wat nokay hen ekamanni nò ta ammaanni hen laychén Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yag sommongfat ah Jesus way mangaliyén, “Hen laychén Apudyus way ammaanyu wat masapor afurotonyu haén te haén hen anchi hennagna.” ");
INSERT INTO blw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","“Oo a,” way chacha ekat, “ngém nokay hen ammaam way kaskascha-aw ta wachay manot-owaanni ah mangafurotanni an hea. Wacha koma hen epàilam, ");
INSERT INTO blw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","te ilamat, hen anchichay anap-otaaw ad namenghan, wacha hen anchi manna way anchag cha anéanén hen ini-inggawancha hen anchi chanak. Te hen anchi nesosorat met, ekatnéén, ‘Hen anchi ma-an way narpod uchu, yachi hen inidchatna an chicha.’ ” ");
INSERT INTO blw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yachi yag sommongfat ah Jesus way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way hen anchi inidchat Moses, faén angkaychi hen anchi tot-oway ma-an way narpod uchu. Te hen anchi cha idchat Amay Apudyus ad uwan, yachi hen anchi tot-owa way ma-an way narpod uchu. ");
INSERT INTO blw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ya hen hiyachiy ma-an way inidchatna way ad uchu paat hen narpowana, wat yachi hen managu hen tatagu ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yag anat agé ekat hen anchichay tataguwén, “Apo, umpayat adchan chàni hen annay ma-an ta mawawà-acha an chàni.” ");
INSERT INTO blw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yachi yag anat lawrawagén Jesus hen anchi enalena way mangaliyén, “Haén hen anchi ma-an way managu hen tatagu ah ing-inggana, wat hen miyaligana, heno way mangafurot an haén, achin henhenaang, ya achi agé màmàwaw. ");
INSERT INTO blw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngém tot-owa hen anchi imfafaggà an chàyu way tàén chayu ilailan hen chà ammaan, anyug achi chillu afuroton. ");
INSERT INTO blw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ngém amin hen anchichay tatagu way penelen Ama way omafurot an haén, wat omafurotcha tot-owa. Ya aminay omafurot an haén, akseptarê chicha amin. ");
INSERT INTO blw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Te haén way narpo ad uchu, iggayà chillu ummale hen antoy lota way i mangamma yanggay hen laychê te ummaliyà way i mangamma hen laychén hen anchi nannag an haén. ");
INSERT INTO blw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yag hen laychéna, ta amin hen anchichay penelena way omafurot an haén, ammag maid poros mayagyag an chicha, ya ta man-uchiyê agé chicha amin no umchah hen anchi anongoh chi ag-agaw. ");
INSERT INTO blw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta epegwà way mangale hen laychén Ama, te hen laychéna, ta amin hen anchichay mangafurot way haén hen anàna ya haén agé hen manokchuncha, mètagucha an haén ah ing-inggana, te man-uchiyê chicha hen anchi anongoh chi ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hen nangngaran hen anchichay tatagu hen anchi enalen Jesus way hiya hen anchi ma-an way narpod uchu, anchag chan ngangayutongot. ");
INSERT INTO blw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yag chachan ahepennoot way mangaliyén, “Ay ammoh faéntoh Jesus tà way anà cha Jose an Maria way innilataaw. Wat pakay annag cha ekatén hiyaat narpod uchu nò.” ");
INSERT INTO blw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yachi yag sommongfat ah Jesus way mangaliyén, “Achiayu chan ngayungayutongot, ");
INSERT INTO blw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","te maid chillu omafurot no faén ah Ama way nannag an haén hen manorong hen hamhamàna ah omafurotana. Wat hen anchichay omafurot, chicha hen man-uchiyê hen anchi anongoh chi ag-agaw. ");
INSERT INTO blw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wacha agé hen ensorat hen profeta ad namenghan way ekatnéén, ‘Tudtuchuwan Apudyus hen aminay tatagu.’ Wat hiyachi, heno way tagu way mangngar hen imfagan Ama yag enafurotna, kapeletan way omafurot agé an haén. ");
INSERT INTO blw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ngém achì ekatén wacha hen nangila an Ama ad uchu, te haén yanggay hen nangila an hiya, te ahchi chillu hen narpowà. ");
INSERT INTO blw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wat yachi, tot-owa hen antoy ifagà an chàyu way heno way tagu way omafurot an haén, mètagu an Apudyus ah ing-inggana, ");
INSERT INTO blw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","te haén hen anchi ma-an way mangchat hen mannanayun way ataguwan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Hamham-ényu ngén te faén angkay kaman hen anchi manna way enan hen anchichay anap-otaaw ad namenghan hen ini-inggawancha hen anchi chanak, te uray enancha hen yachiy ma-an way ekatchéén narpod uchu, natéycha chillu. ");
INSERT INTO blw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngém heno way mangan hen anchi mannanayun way ma-an way yachin anchi tot-owa way narpod uchu, achi matmatéy ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yag haén hen anchi mannanayun way ma-an way narpod uchu. Wat heno way mangan hen hiyachiy ma-an, mètagu an Apudyus ah ing-inggana. Yag hen anchi ma-an way idchat-o an hiyaat achar-o way yaha hen midchat ah managu hen aminay tatagu hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Angkay hiyachi way enalen Jesuschi, chachan sosongel hen anchichay tatagu way mangaliyén, “Heno ay paat hen én-énnén hen annay taguwanna way mangempangan hen acharna an chitaawa.” ");
INSERT INTO blw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yachi yag ekat Jesusén, “Tot-owa hen antoy ifagà an chàyu way no achiyu anén hen achar-o way Pangorowan hen Tatagu, ya no achiyu agé inumun hen charà, wat achi angkay mafalin way mètaguayu an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Waman hen anchi tagu way mangan hen achar-o ya manginum hen charà, yachi hen mètagu an Apudyus ah ing-inggana ya man-uchiyê agé hiya hen anchi anongoh chi ag-agaw. ");
INSERT INTO blw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Te hen achar-o, yachi hen tot-oway ma-an, ya hen charà, yachi hen tot-oway mainum way yachi hen managu hen tatagu ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wat heno way mangan hen achar-o ya manginum hen charà, mì-i-iggaw an haén ya mì-i-iggawà agé an hiya. ");
INSERT INTO blw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ah Ama way nannag an haén, sigud way natattagu. Yag gapon hiyaat, nisissigud agé hen natatagguwà. Wat kaman agéhchi, heno way mangan hen achar-o, matagu ah ing-inggana agé te haén hen managu an hiya. ");
INSERT INTO blw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wat hiyachi, haén hen anchi ustoy ma-an way narpo ad uchu way faén kaman hen anchi ma-an way enan hen anchichay anap-otaaw yag natéycha chillu. Te heno way mangan an haén, mètagu an Apudyus ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yachi hen intudtuchun Jesus hen nantudtuchuwana hen anchi sinagoga way cha ma-am-amongan hen Judio ad Capernaum. ");
INSERT INTO blw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Angkay hiyachi way chengngar hen anchichay sommorot an Jesus hen anchi annaat intudtuchu, ammag chuar an chicha hen ngommaya hen hamhamàna yag ekatchéén, “Nokay lawa hen cha i mangngar hen annay chana aryénanna way ammag naligat ah hamham-én.” ");
INSERT INTO blw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ngém ah Jesus, ammuna hen chacha ngayutongotan yag annaat ekatén, “Ay anggayha yag epangayana chàyu. ");
INSERT INTO blw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wat nokay agé hen hamhamàyu non an umat yag ilanyu haén way Pangorowan hen Tatagu way ammag matarok ad uchu way mamfangad hen narpowà. ");
INSERT INTO blw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Te hen anchi narpowan hen mannanayun way ataguwan hen tatagu wat hen Espiritun Apudyus way ammag maid sérsérfin hen aminay ammaan hen tatagu. Ya hen anchichay chà imfaga an chàyu, yachi hen mangawatanyu hen Espiritun Apudyus ya yachi agé hen managu an chàyu ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngém wachacha hen tapena an chàyu way ammag achi chillu omafurot an haén.” Enalen Jesuschi te nanepod hen anchi laprapona, inni-ilana chillu no heno hen achi omafurot an hiya ya no heno agé hen anchi mangenlao an hiya. ");
INSERT INTO blw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wat yachi yag anat ekat Jesus agéén, “Yachi hen nangimfag-à an chàyu way maid ihà-an ah omafurot an haén no faén ah Ama hen manorong hen hamhamàna way omafurot.” ");
INSERT INTO blw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nanepod hen hiyachi, chuar hen nangentagay way metnod an Jesus way anchag nanchùgan hiya. ");
INSERT INTO blw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Wat ekat Jesus hen anchichay hemporo ya chuway pasorotnéén, “Chàyu kay, ay etagayà agé an chàyu.” ");
INSERT INTO blw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yag sommongfat ah Simon Pedro way mangaliyén, “Apo, nokay lawa hen kasenni i somorotan nò, te hea met yanggay hen cha mangintudtuchu hen mannanayun way mètaguwan an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wat sigurachu hen antoy afurotni way hea hen anchi kapachong Apudyus way empalena hen antoy lota way mantoray.” ");
INSERT INTO blw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yachi yag ekat Jesusén, “Haén, penelè chàyu way hemporo ya chuwa, ngém wacha chillu hen iha way ena-awwan Chumunyu.” ");
INSERT INTO blw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Enalen Jesuschi mepanggép an Judas way anà Simon Iscariote te tàén hiya hen iha an chicha way hemporo ya chuwa, annag enlao ah Jesus hen na-awni. ");
INSERT INTO blw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nanepod hen hiyachi, achi i manggégga-ay ah Jesus hen provinsiyan hen Judea te innilana way cha anapén hen anchichay anap-apon hen Judio hen ekamancha way mamchit an hiya. Wat ammag hen provinsiyan hen Galilea hen chana i manggégga-ayan yanggay. ");
INSERT INTO blw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Angkay hiyachi way tég-angay hen tempon hen anchi lagsak hen Judio way ekatchéén “Fawi,” ");
INSERT INTO blw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","yag ekat hen anchichay e-enawchin Jesus an hiya way mangaliyén, “Pa-a achi lumigwat way i mèlagsak ad Jerusalem ta im epàila hen kaskascha-aw hen anchichay cha somorot an hea. ");
INSERT INTO blw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Te ay ammoh wachay tagu ah mangentàlilig hen chana ammaan no laychéna way mempaka-ammu hen acharna. Wat no kaskascha-aw hen cham ammaan, epàilam kagé hen katagutagu.” ");
INSERT INTO blw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yaha hen enalen hen anchichay e-enawchin Jesus te uray chichaat cha-ancha omafurot an hiya. ");
INSERT INTO blw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yachi yag ekat Jesus an chichéén, “Oo a, ngém cha-an met umchah hen anchi ustoy tempo way mampàil-à. Waman chàyu, mafalin way farangna hen mampàil-anyu, ");
INSERT INTO blw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","te achi chàyu cha agorgoran hen tatagun antoy lota. Waman haén, anà ammag agorgoran an chicha te chà ifaga hen karaweng hen a-ammacha. ");
INSERT INTO blw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Wat in-ayu ta in-ayu mèlagsak te maid angkay éméy an haén te cha-an umchah hen ustoy mampàil-à.” ");
INSERT INTO blw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yachi hen enalen Jesus yag anat mataynan hen provinsiyan hen Galilea. ");
INSERT INTO blw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Angkay hiyachi way lummigwat hen anchichay sosnod Jesus way i mèlagsak, entat-allingéb Jesus way umunud. ");
INSERT INTO blw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Angkay ahchi, hen anchichay anap-apon hen Judio, chacha anapén hiya way mangaliyén, “Chuud ngata ah Jesus aya.” ");
INSERT INTO blw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ya ammag chuar agé hen cha manginyut-utiyam hen anchichay tatagu mepanggép an hiya, te hen tapena, ekatchéén, “Ammayay tagu ah Jesus.” Waman hen tapena, chachaat agé ekatén, “Faén angkay te chana lokopon hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yaha hen chacha aryén ngém chacha etat-allingéb way mangale te chacha émégyat ah mangngaran hen anchichay anap-apon hen Judio. ");
INSERT INTO blw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Angkay hiyachi way agginawan hen anchi lagsak, émméy ah Jesus ah Templo way i mantudtuchu. ");
INSERT INTO blw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yag anchag nahahaang hen anchichay anap-apon hen Judio yag ekatchéén, “Henoay hen nangacharan nahha hen kenaraengna way iggay met man-uswila.” ");
INSERT INTO blw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yag anat ekat Jesus an chicha way mangaliyén, “Hen anchi chà itudtuchu, faén ammag hamhamào hen narpowana te narpon Apudyus way nannag an haén. ");
INSERT INTO blw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yag heno way tagu way manlayad way mangamma hen laychén Apudyus, maelasinna way ah Apudyus tot-owa hen cha marpowan hen anchi chà itudtuchu ya faén fukod yanggay hen hamhamào. ");
INSERT INTO blw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Te kapeletan, hen anchi tagu way cha mintudtuchu hen anchi narpoh hamhamàna yanggay, anna an cha anapén hen kachayawana. Waman hen anchi cha manganap hen machayawan hen anchi nannag an hiya, hiya hen anchi nalimpiyu way maid kétkétémna. ");
INSERT INTO blw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Tot-owa way inidchat Moses hen anchi orchin Apudyus an chitaaw. Ngém ammag maid angkay cha mangafurot an chàyu hen hiyachiy orchin, te pakay chayu anapén hen mamchitanyu an haén nò.” ");
INSERT INTO blw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yag sommongfat hen anchichay tatagu way mangaliyén, “Ay an-a cha mattagar te heno ay hen tagu way cha manmanmà way mamchit an hea.” ");
INSERT INTO blw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yachi yag ekat Jesusén, “Anggay paat hen nanga-anà hen anchi saket hen tempon hen ngilin yag an-ayu paat ammag nah-ag. ");
INSERT INTO blw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ngém chàyuwat, chayu met agé markaan hen a-anàyu no tempon hen ngilin no yachi hen miyaphorana te yahan imfagan Moses way mekaman, ngém faén chillu ah Moses hen nanginlugi te an natawid hen anchichay chanakkar. ");
INSERT INTO blw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wat no mafalin way mepamarka hen anà hen tempon hen ngilin way Safachu ta achi marabseng hen anchi inyurchin Moses, pa-ayu kay omaningarngar gapo hen nanga-anà hen saket hen ihay tagu hen anchi tempon hen ngilin ah omammayan paat hen ataguwana. ");
INSERT INTO blw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Achiyu ammag cha tenétnéén way laweng hen enammaà ta anyuwat an anapén hen ka-ammayna.” ");
INSERT INTO blw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Angkay hiyachi way chengngar hen anchichay tatagu ad Jerusalem hen cha aryén Jesus, ekat hen tapenéén, “Ay faénha ngén hen anchi tagu way cha anapén hen anchichay anap-apo ta pédténcha ano. ");
INSERT INTO blw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yag pakay annayan nò way chan tudtuchu hen sangwanan hen tatagu yag maid met ammaancha an hiya. Ono napnekcha ngata way hiya tot-owa hen anchi Cristu way empopostan Apudyus way umale.” ");
INSERT INTO blw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“Oo a, ngém no umale hen anchi Cristu, maid ano mangammu hen marpowana, ngém hen yahay tagu, innilataaw met hen narpowana.” ");
INSERT INTO blw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Angkay hiyachi way chan tudtuchu ah Jesus ah Templo, chinakarna way mangaliyén, “Ay nanggila kay ta innilayu tot-owa hen narpowà ya hen kenatatagù. Te faén yanggay ah hamhamào hen ummaliyà hen antoy lota te anà an hennag hen anchi katot-owaan. Ngém chàyu, maid innilayu an hiya. ");
INSERT INTO blw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Waman haén, innilà hiya te hiya hen narpowà ya hiya agé hen nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hen nangaryan Jesus an nadchi, ammag laychén paat hen anchichay anap-apo way manlapchù an hiya way manelew, ngém iggaycha chillu te cha-an umchah hen tempona. ");
INSERT INTO blw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ngém uray chillu yaha hen hamhamà hen tapena, chuarcha chillu hen ommafurot an hiya wat ekatchéén, “Hiyaha man hen anchi Cristu way empopostan Apudyus, te ay ammoh wachay maka-amma ah wadwadcha way kaskascha-aw no hen chana ammaan.” ");
INSERT INTO blw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Angkay hiyachi way cha alengahén hen anchichay Fariseo hen cha aryén hen tatagu mepanggép an Jesus, wat chicha ya hen anchichay anap-apon hen papachi, hennagcha hen anchichay guwarcha way i manelew koma an hiya. ");
INSERT INTO blw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yachi yag ekat Jesusén, “An hen-aketan yanggay hen mì-iggawà an chàyu yag ana-at manfangad hen anchi nannag an haén. ");
INSERT INTO blw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wat uray anà ammag cha ana-anapén an chàyu, achiayu chillu makachah an haén te achiayu maka-ale hen ayà.” ");
INSERT INTO blw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yachi yag chachan ahepennoot hen anchichay anap-apon hen Judio way mangaliyén, “Chuud ngata hen ayana way achitaaw makachah an hiya. Ay an éméy hen iggaw hen anchichay kacharaantaaw way niwa-at ah kafabréfabréy ta ah awni yag tinudtuchuwana agé hen anchichay faén Judio. ");
INSERT INTO blw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Te pakay ekatnéén anapéntaaw hiya, ya nokay ngata hen laychénay aryén hen annay ekatnéén achitaaw makachah an hiya, ya achitaaw agé makaéy hen ayana.” ");
INSERT INTO blw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Angkay hiyachi way anongoh hen ag-agaw hen anchi lagsak way yachin térénay lagsak, tommàchég ah Jesus yag chinakarna way mampani, ekatnéén, “Heno way nàwaw, umale an haén ta painumê hiya, ");
INSERT INTO blw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","te hen anchi nesosorat way alen Apudyus, ekatnéén, ‘Heno way omafurot an haén, ammag fumufùnag an hiya hen anchi fufun way managu hen tatagu ah ing-inggana.’ ” ");
INSERT INTO blw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hen anchi enalen Jesus way chanum way ammag fumufùnag hen tatagu, anna cha paniyén hen anchi Espiritu way epalen Apudyus way mìyachar hen anchichay omafurot an hiya. Ngém hen hiyachiy tempo, cha-an mepale hen anchi Espiritu te cha-an hen kachayawan Jesus way mamfangchana ad uchu. ");
INSERT INTO blw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hen nangngaran hen anchichay tatagu hen anchi anat enalen Jesus, ekat hen tapenéén, “Hiyaha tot-owa hen anchi profeta way antaaw ammag hahadchén.” ");
INSERT INTO blw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yag hen tapena agé, ekatchéén, “Hiyaha angkay tot-owa hen anchi Cristu way empopostan Apudyus way umale.” Waman hen tapena, ekatchéén, “Ay ammoh hen provinsiyan hen Galileaat agé hen marpowan hen anchi Cristu. ");
INSERT INTO blw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Te nesosorat met hen anchi alen Apudyus way hen Cristu, ganà David way ad Bethlehem hen miyana-ana, te yachi hen fabréy David.” ");
INSERT INTO blw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wat ammag achin tetemfuruy hen hamhamà hen anchichay tatagu mepanggép an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yag ammag laychén paat hen tapena way manelew an hiya, ngém maid chillu iha ah nangempachah hen limana. ");
INSERT INTO blw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Angkay hiyachi yag namfangad hen anchichay guwarcha, yag henanhanan hen anchichay anap-apon hen pachi ya Fariseo way mangaliyén, “Payu iggay tenelew ta inyaleyuhto nò.” ");
INSERT INTO blw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yag sommongfatcha way mangaliyén, “Oo a, ngém nanepod hen nataguwanni, maid chengchengngarni ah nantudtuchu ah kaman an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yag ekatat agé hen anchichay Fariseowén, “Ay an-ayu peet agég narokop. ");
INSERT INTO blw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Arwachanyu te ay wacha paat chi iha an chàniyanto way Fariseo ya anap-apo ah nangafurot hen annay taguwanna. ");
INSERT INTO blw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ya hen annachay chuaray tatagu, maid ay innilacha mepanggép hen orchin Moses, wat yasa kaỳ ta etap-ar Apudyus chicha.” ");
INSERT INTO blw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Angkay hiyachi yag wachan iha hen anchichay Fariseo way ah Nicodemo hen ngachanna way hiyan anchi émméy an Jesus hen anchi henlafiyan. Yag imfagana hen anchichay ifana way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Sosnod, ay ammoh parufusun hen orchintaaw way antaaw ammag epagchat way mempafasor hen ihay tagu no achitaaw unna fistigarén no heno hen enammaana.” ");
INSERT INTO blw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yag senongfatan hen anchichay ifana way mangaliyén, “Ay iGalileaat agé. Acharém man hen anchi nesosoratat ichaham way manepod hen lugruginaat maid profeta ah narpod Galilea.” ");
INSERT INTO blw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yachi yag nafuarcha way wéhchiyén homàyat. ");
INSERT INTO blw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ngém ah Jesus, émméy hen anchi filig way Olivo. ");
INSERT INTO blw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Angkay nawakas yag fummigatay térén ah Jesus way kasen émméy ah Templo, yag enamongan amin hen anchichay tatagu hiya, wat intùchuna way manudtuchu an chicha. ");
INSERT INTO blw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yachi yag nawaycha hen tapen anchichay Fariseo ya siguchay cha mintudtuchu hen orchin way chacha iyale hen ihay fufae way na-aphoran way nì-isséy hen faénna ahawa. Yag empasangocha hen anchi fufae hen aminay tatagu, ");
INSERT INTO blw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","yag anchaat ifaga an Jesus way mangaliyén, “Apo, antoyan hen ihay fufae way na-aphoran way nì-isséy hen faénna ahawa. ");
INSERT INTO blw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wat inyurchin met Moses way mafuntò hen fummasor hen kaman hetoy fasor ingganah matéy. Wat hea kaỳ, nokay hen ekatno nò.” ");
INSERT INTO blw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yachi hen enkamancha te laychéncha way sepotan ah Jesus ta wachay mangempafasorancha an hiya. Ngém ammag nanyongyong ah Jesus yag chana esorat hen gammatna hen anchi tapok. ");
INSERT INTO blw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yag chachaat hanéhanétan way mananhan no henon esongfatna. Yachi yag nammuhwat ah Jesus way mangaliyén, “Oo, funto-onyu, ngém hen anchi tagu way maid fasfasorna, hiya hen pés-éy mamuntò.” ");
INSERT INTO blw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yag anat kasen manyongyong way mansos-orat hen anchi tapok. ");
INSERT INTO blw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hen nangngarancha hen anchi enalen Jesus, anchag naéhhaéhha way lomayaw way inlugrugin hen anchi makmakorang an chicha ingganah lommayawcha amin. Wat ammag anggay ah Jesus ah nataynan ya hen anchi fufae way tommatàchég hen henagongna. ");
INSERT INTO blw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yachi, yag tommàchég ah Jesus way mangalen anchi fufaeyén, “Chuudcha hen anchichay cha mangempafasor an hea way manusa an hea nò.” ");
INSERT INTO blw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Maidcha Apo,” way ekat anchi fufae, “te lommayawcha amin.” Yag anat ekat Jesus agéén, “Uray haénat achì agé chuséén hea, wat in-a, ngém achim cha epegpegwa way fumasor.” ");
INSERT INTO blw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Angkay hiyachi way kasen chan tudtuchu ah Jesus, ekatna way mampaniyén, “Haén hen anchi helaw way cha manelaw hen tatagu hen antoy lota. Wat heno way somorot an haén, achi inggaw hen helang te mahehellawan hen anchi helaw way tomagu, wat mètagu an Apudyus ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yag senongfatan hen anchichay Fariseo hiya way mangaliyén, “Ay an-ag mampachinar ta annog cha tàchégan hen acharno. Wat ay ammoh ma-afurot hen anchi manàchég hen acharna.” ");
INSERT INTO blw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","“Faénha,” way ekat Jesus, “te uray no tàchégà hen achar-o, tot-owa chillu hen chà aryén, te haén, innilà hen narpowà ya innilà agé hen ayà. Waman chàyu, maid innilayu hen narpowà ya maid agé innilayu hen ayà. ");
INSERT INTO blw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yag ammag hen patinggan yanggay hen hamhamàyu hen chayu manguwisan an haén. Waman haén, faén kaman hichi hen ekaman-o way manguwis hen tatagu. ");
INSERT INTO blw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ngém non an umat yag uwisê hen tatagu, uwisê chicha ah katot-owaan, te faénà ihà-an way manguwis, te chuwa-ani an Ama way hiyan nannag an haén. ");
INSERT INTO blw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yag nesosorat agé hen anchi orchin Moses way no mantemfuruy hen aryén hen chuway tatagu, wat tot-owa hen chacha aryén. ");
INSERT INTO blw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wat haén hen iha way cha manàchég hen achar-o, ya chaà agé tàchégan an Ama way nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yachi yag anchaat agé ekat an hiyéén, “Chuud ay paat ah Amam hena.” Yag ekat Jesusén, “Maid tot-owa innilayu an Ama ya maid agé innilayu no henowà, te non anyu an innila no henowà, innilayu agé ah Ama.” ");
INSERT INTO blw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Chichachi hen enalen Jesus hen anchi nantudtuchuwana hen anchi iggaw hen chacha mantentennagan ah pelak ah Templo. Yag tàén wachacha hen anchichay anap-apo, maid chillu namachas way manelew an hiya te cha-an umchah hen tempona. ");
INSERT INTO blw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Angkay hiyachi yag wacha hen kasen imfagan Jesus an chicha way mangaliyén, “Umchah hen lomayawà yag wacha hen manganapanyu an haén, ngém looh nelooh te achiayu maka-ale hen ayà, wat an-ayug matéy way achi makàka-an hen fasoryu.” ");
INSERT INTO blw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yachi yag nan-ahetennopà hen anchichay anap-apon hen Judio way mangaliyén, “Ay anna ngata pédtén hen acharna, te pakay ekatnéén achitaaw makaéy hen anchi ayana nò.” ");
INSERT INTO blw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yag ekat agé Jesusén, “Chàyu, an yanggay hen antoy lota hen narpowanyu ya hen antoy lota agé hen patinggan hen innilayu. Waman haén, ad uchu hen narpowà wat faén yanggay antoy lota hen péppég hen innilà. ");
INSERT INTO blw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Wat yachi hen nangimfag-à way matéy-ayu way achi makàka-an hen fasoryu, te anchag metatàen ah ing-inggana, yag netap-ar-ayu no achiyu afuroton way haén hen anchi chà aryén.” ");
INSERT INTO blw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Wat henoa kay paat agé nò,” way ekatcha. Yag sommongfat ah Jesus way mangaliyén, “Nanepod hen laprapona, chà met ifagafaga. ");
INSERT INTO blw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ya chuar agé koma hen ifagà mepanggép an chàyu ya chuar agé hen mangempafasorà an chàyu, ngém an-o yanggay an cha ifaga hen tatagun antoy lota hen anchi chengngar-o way imfagan chillu hen anchi nannag an haén, yag hiya, tot-owa amin hen chana ifaga.” ");
INSERT INTO blw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Angkay hen anchichay Judio, iggaycha ma-awatan way ah Apudyus hen cha aryén Jesus way Amana. ");
INSERT INTO blw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Wat anat ekat Jesusén, “Haén way Pangorowan hen Tatagu, no etoochà hen anchi koros, yachi hen menlasinanyu no henowà way haén hen anchi nawawà-acha, ya yachi agé hen mangawatanyu way maid chà ammaan ah iggay mipiyar an haén, ya maid agé chà aryén no faén ah Ama hen nangintudtuchu. ");
INSERT INTO blw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yag achiyà iyanggayan hen anchi nannag an haén, te hiya, mawawà-acha an haén, ya chà ammaan yanggay hen laychéna.” ");
INSERT INTO blw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Angkay hiyachi yag ommafurotcha hen chuaray tatagu an Jesus hen nangngarancha hen anchichay enalena. ");
INSERT INTO blw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Angkay hiyachi yag imfagan Jesus hen anchichay cha omafurot an hiya way mangaliyén, “No afurotonyu hen aminay intudtuchù an chàyu, wat chàyu hen tot-owa way pasorot-o, ");
INSERT INTO blw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","yag ma-awatanyu no heno hen tot-owa. Ya hen yachiy katot-owaan, yachi hen mangemparufus an chàyu hen kena-alepanyu.” ");
INSERT INTO blw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yachi yag sommongfatcha hen anchichay Judio way mangaliyén, “Oo a, ngém ganà chàni an Abraham wat maid met nan-alepananni, wat nokay hen laychém way aryén hen annay ekatnowén eparufus chàni hen kena-alepanni, te faén-ani met alepan.” ");
INSERT INTO blw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yachi yag anat ekat Jesusén, “Tot-owa hen antoy ifagà an chàyu way heno way tagu way fumasor, hiya angkay hen alepan Chumunyu way pongar hen fasor. ");
INSERT INTO blw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ya hen alepan, gapo ta faén ahimfafaryan, wat mafalin meparyaw no ekat hen anchi nangen-alepanén eparyawna. Waman hen anchi tot-oway anà, achi met meparyaw te hiya hen anà ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wat no hen anchi anà paat Apudyus hen mangemparufus an chàyu hen anchi kena-alepanyu wat meparufus-ayu tot-owa. ");
INSERT INTO blw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Innilà way ganà Abraham chàyu, ngém gapo ta ammag achi éméy ah hamhamàyu hen anchi chà itudtuchu chayuwat agé iyanap hen ekamanyu way mamchit an haén. ");
INSERT INTO blw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Haén, chà ifaga an chàyu hen anchichay chengngar-o an Ama ad uchu, ya pachongna agé an chàyu, te chayu agé ammaan hen chengngaryu an Amayu.” ");
INSERT INTO blw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yag ekatat agé hen anchichay Judiowén, “Maid ay kasen amani no faén yanggay ah Abrahama.” Yag ekat Jesusén, “No ganà chàyu tot-owa an Abrahamat torachényu koma hen enammaana. ");
INSERT INTO blw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Te ilanyu ngén, maid kasen chà ifaga an chàyu no faén yanggay hen anchi tot-owa way chengngar-o an Apudyus yag yachiyat agé hen gapona ah manlaychanyu way mamchit an haén. Wat ay ammoh yachiyat agé hen enammaan Abraham tà. ");
INSERT INTO blw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ngém ah katot-owana, chayu torachén hen a-amman hen amayu.” Yag anchaat agég ekatén, “Ay ammoh an-ani ipos, te an ihà-an met hen amani te ah Apudyus yanggay.” ");
INSERT INTO blw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yag ekat Jesus an chichéén, “Non an ah Apudyus tot-owa hen amayu, lenyadyu koma haén te hiya hen narpowà yag ana-at umale hen antoy lota. Te faén yanggay haén hen namiyar hen achar-o te anà hennag an hiya. ");
INSERT INTO blw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wat pakay paat achiyu ma-awatan hen antoy chà ifaga. Oo a, te anyug achi laychén way mangngar. ");
INSERT INTO blw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Te an-ayug kaman an amayu way Chumunyu way hen laychéna, yachiyat agé hen laychényu. Yag hiya, nanepod hen lapraponaat ammag pattéyan ya maid paat manhagongana hen tot-owa te pahig silib hen wachan hiya. Wat mag-ay ta mankétém, anna cha ammaan hen anchi nisissigud an hiya te hiya hen sigud way pongar chi kétém. ");
INSERT INTO blw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Waman haén, pahig tot-owa hen chà ifaga an chàyu, yag yachiyat agé hen achiyu mangafurotan an haén. ");
INSERT INTO blw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yag heno chillu an chàyu hen mafalin mangentot-owa way wachay fasor-o. Maid a, te maid met chillu fasor-o. Ngém pakay tàén chà ifaga hen tot-owéén achiyu chillu afuroton nò. ");
INSERT INTO blw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Oo a, te chàyu, faén-ayu tatagun Apudyus, te hen anchichay tot-oway tatagun Apudyusat, afurotoncha met hen alena.” ");
INSERT INTO blw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yachi yag senongfatan hen anchichay anap-apon hen Judio ah Jesus way mangaliyén, “Ay faén tot-owa hen anchi ekatniyén eSamaria-a way kafusorni way Judio. An cha-a peet tenagar hen ongtan.” ");
INSERT INTO blw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yag anat ekat Jesusén, “Achiyà cha mattagar te chà yanggay pachayawén ah Amay Apudyus. Ngém chàyu, anyu an cha pelohon haén. ");
INSERT INTO blw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ya haén, faén agé hen kachayawà hen chà gamgaman, ngém wacha chillu hen cha mangamgam hen kachayawà way hiya ah Apudyus, ya hiya, tàchégana agé haén. ");
INSERT INTO blw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tot-owa hen antoy ifagà an chàyu way heno way mangafurot hen antoy chà itudtuchu, ammag achi matmatéy ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yachi yag ekat hen anchichay Judiowén, “Ilamat, cha-a tot-owa mattagar, te uray ah Abrahamat natéy ya umat agé hen anchichay profetaat natéycha amin, yag heaat agé yag ekatnowén, ‘Heno way mangafurot hen cham itudtuchu wat achicha matmatéy.’ ");
INSERT INTO blw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ay ammoh ekatnowén wadwadcha-a paat no ah Apotaaw way Abraham ya hen anchichay profeta way nan-atéy ad namenghan. Henoa kay paat ah mangalem, aya.” ");
INSERT INTO blw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yachi yag sommongfat ah Jesus way mangaliyén, “Non an umat yag haén hen cha mangempachayaw hen achar-o, maid met sérfin nadchi way chayaw. Ngém ah katot-owana, ah Ama hen cha mangempachayaw an haén, yag hiya agé hen ekatyuwén Apudyusyu. ");
INSERT INTO blw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Maid paat innilayu an hiya. Waman haén, innilà hiya. Yag non an-og ekatén maid innilà an hiya, anà ammag nangéttém way kaman agé an chàyu. Ngém ah katot-owana, innilà tot-owa hiya, ya chà agé afuroton hen ifagana. ");
INSERT INTO blw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yah apoyu agé way Abraham, pararo way térén hen layadna ad namenghan hen nangammuwana way ilana hen umaliyà hen antoy lota. Yag ad uwan way innilana tot-owa hen ummaliyà, wat kaskasen hen laylayadna.” ");
INSERT INTO blw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yachi yag ekat hen anchichay Judiowén, “Ammag cha-an malemanporo hen tawénno yag annog ekatat agéén innilam ah Abraham.” ");
INSERT INTO blw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yag ekat Jesusén, “Tot-owa hen antoy ifagà an chàyu way cha-an angkay marmu ah Abrahamat, nawawà-achaà.” ");
INSERT INTO blw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yag anchaat agég ommalekam ah fato ta funto-oncha hiya. Ngém ah Jesus, entat-allingébna way lomayaw ah Templo. ");
INSERT INTO blw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Angkay hiyachi way cha manaran cha Jesus, innilacha hen ihay am-ama way nisissigud hen finuragna nanepod hen natatagguwana. ");
INSERT INTO blw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yag anat hanhanan hen anchichay pasorotna way mangaliyén, “Apo, heno ngata hen fummasor ah gapoh nabfuragan nahhay tagu, ay hiya ono hen chinàcha-arna.” ");
INSERT INTO blw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yag anat ekat Jesusén, “Faén chillu gapoh fasorna ono fasor hen chinàcha-arna hen nabfuragana, te nabfurag ah mepàil-an hen kafaelan Apudyus an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yachi yag nampani ah Jesus mepanggép hen antoy natatagguwan ya hen matéyan, ekatnéén, “Hen kawad-an hen ag-agaw, yachi hen wayataaw way mangamma hen laychén hen anchi nannag an haén, te no umchah hen lafi, maid kasen wayataaw way mangamman cha nadchi. ");
INSERT INTO blw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wat hen kawad-à hen antoy lota, haén hen helaw way manelaw hen hamhamà hen katagutagu hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Angkay enalen Jesuschi, yag annaat toppaan hen anchi lota yag penelotna yag empalidna hen yachiy petà hen matan hen anchi nabfurag, ");
INSERT INTO blw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","yag annaat ifaga way mangaliyén, “In-a ta in-an char-op hen anchi po-ong way Siloe.” (Hen laychén hen anchi ngachan way Siloe way aryénat Nahnag.) Angkay hiyachi way émméy hen anchi nabfurag way i nanchar-op, yag namfangad way naka-anat hen finuragna. ");
INSERT INTO blw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yachi yag hen anchichay atògongna ya hen anchichay nangila an hiya hen kenapalemmosna, chachan ahepennoot way mangaliyén, “Ay ammoh faénto tà hen anchi tagu way ammag tumutùchu way chan pap-alemmos.” ");
INSERT INTO blw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yag ekat hen tapenéén, “Hiyan sa met.” Waman hen tapena, ekatchéén, “Faén aya, te an yanggay kapadpachongna.” Yachi yag anat man-ale hen anchi nabfurag way mangaliyén, “Haén kayyà.” ");
INSERT INTO blw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yag anchaat imohon an hiya way mangaliyén, “Pakay makaila-a ad uwan nò.” ");
INSERT INTO blw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yag annaat haphapetén way mangaliyén, “Wachan ihay tagu way ah Jesus ano hen ngachanna way annag pen-ar hen petà yag empalidna hen matà ya annaat ifaga ta iyà manchar-op ad Siloe. Yag yachi way émméyà way nanchar-op, ammag naka-anat agé hen finurag-o.” ");
INSERT INTO blw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yag ekat hen anchichay tataguwén, “Wat chuud kay hen anchi taguwanchi nò.” “Tawwan, te maid innilà,” way ekat agé hen anchi nabfurag. ");
INSERT INTO blw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Angkay hiyachi yag inyéy hen anchichay tatagu hen anchi anat naka-an hen finuragna hen iggaw hen anchichay Fariseo, ");
INSERT INTO blw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","te niyaphor way hen nangammaan Jesus an nadchi wat Safachu way siguchay ngilin hen Judio. ");
INSERT INTO blw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yachi yag anat hanhanan hen anchichay Fariseo no heno hen enkaman hen finuragna way naka-an. Yag annaat ekasen way manaphapet way mangaliyén, “Annag empalid hen petà hen antoy matà, yag angkay inurahà, nakailaa-at agé.” ");
INSERT INTO blw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yag anat ekat hen tapen anchichay Fariseowén, “Oo a, ngém faén angkay ah Apudyus hen narpowan nahhay tagu, te pakay achina tongparén hen ngilintaaw way Safachu nò.” Yag cha agé ekat hen tapenéén, “Oo a, ngém ay ammoh maka-amma hen menangfasor ah kaskascha-aw way kaman hichi.” Wat ammag nanchuwa hen hamhamàcha. ");
INSERT INTO blw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yachi yag anchaat ekasen agé way mananhan hen anchi nabfurag way mangaliyén, “Nokay hen manmàno hen yachiy tagu, te annay kena-anna hen finuragno.” Yag ekatnéén, “Profeta manchi.” ");
INSERT INTO blw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngém hen anchichay anap-apon hen Judio, anchag achi afuroton way sigud hen finurag hen anchi taguwanchi yag anat makaila ad uwan wat empa-ayagcha hen anchi chinàcha-arna, ");
INSERT INTO blw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","yag henanhahanhanancha an chicha way mangaliyén, “Ay tot-owa way yaton anàyu, yag ay tot-owa way nisissigud hen finuragna. Yag pakay makaila ad uwan nò.” ");
INSERT INTO blw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yachi yag sommongfat hen anchichay chàcha-arna way mangaliyén, “Oo, tot-owa way anànito, ya tot-owa agé way nisissigud hen finuragna. ");
INSERT INTO blw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ngém hen enkaman hen finuragna way naka-an, yachi hen maid innilani. Ya maid agé innilani no henoh nadchi hen nanga-an. Ngém mafalin kay way sarudsuchunyu an hiya te ommam-ama met, wat érégna way manongfat hen ifagayu.” ");
INSERT INTO blw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yaha hen enalen hen anchichay chàcha-arna te émégyatcha hen anchichay anap-apon hen Judio, te chicha, loohcha imfafagga way heno way mangaliyén ah Jesus hen anchi Cristu way empopostan Apudyusat meparyaw way meparyaw hen anchi chacha ma-am-amongan. ");
INSERT INTO blw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Wat yachi hen nangaryan hen chinàcha-arnéén egad hiya way somongfat. ");
INSERT INTO blw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Angkay hiyachi yag kasencha agé enayagan hen anchi nabfurag, yag kasencha inimoh an hiya way mangaliyén, “Ah Apudyusat man hen manyamanam, te innilani way ammag menangfasor hen annay taguwanna.” ");
INSERT INTO blw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yag sommongfat hen anchi nabfurag way mangaliyén, “Maid tot-owa innilà no menangfasorha way tagu ono faén, te hen innilà yanggayat hen pés-éyna, nabfuragà, yag ad uwan, makailaà.” ");
INSERT INTO blw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yag chachaat agé ekat an hiyéén, “No man paat hen enkamanna way nanga-an hen finuragno aya.” ");
INSERT INTO blw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yag annaat agé ekatén, “An-og inyam-amma kay way nangimfaga an chàyu yà, yag anyug achi chillu changrén. Yag pakay laychényu agéy kasen mangngar, ono anyu an laychén agé way somorot an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yachi yag ammag ininsorton hen anchichay Fariseo hiya way mangaliyén, “Ammag heaat hen pasorotna yà, te chàniyat ah Moses paat hen chani soroton, ");
INSERT INTO blw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","te innilani way tenagépfar paat Apudyus ah Moses. Ngém hen annay taguwannaat, maid ay nailah narpowana.” ");
INSERT INTO blw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yachi yag sommongfat hen anchi nabfurag way mangaliyén, “Anà ammag nascha-aw a, te tàén chàyuwén maid peet innilayu ah narpowan hen anchi mannakafael way manga-an hen finurag. ");
INSERT INTO blw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Te innilataaw amin met way achi changrén Apudyus hen laweng way tatagu, te hen anchi yanggay manayaw an hiya ya cha mangamma hen laychéna hen changréna. ");
INSERT INTO blw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yag nanepod hen na-ammaan hen antoy lota inggana ad uwan, maid chengchengngartaaw ah makaka-an hen nisissigud way finurag. ");
INSERT INTO blw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wat no faén ah Apudyus hen narpowana, maid koma kafaelana way manga-an hen finurag.” ");
INSERT INTO blw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yag anchaat agég cha ichaggat way manongfat way mangaliyén, “Ay anno cha tudtuchuwan chàni, hea way menangfasor nanepod hen nataguwam.” Yag chachaat eparyaw hiya way maméppég hen hénggépana hen anchi chacha ma-am-amongan. ");
INSERT INTO blw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Angkay hiyachi way chengngar Jesus hen anchi na-ammaan hen anchi nabfurag, enanapna yag annaat ekatén, “Ay afurotom hen anchi Pangorowan hen Tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yag ekat hen anchi nabfuragén, “Henoh nadchi, Apo, ta omafurotà an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yag ekat Jesusén, “Inni-ilam hiya te hiya hen cha managépfar an hea ad uwananto.” ");
INSERT INTO blw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Apo wat afurotò hea,” way ekat hen anchi nabfurag an Jesus, yag chinayawna hiya. ");
INSERT INTO blw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yachi yag entoroy Jesus way mangaliyén, “Hen ummaliyà hen antoy lota, ta uwisê hen tatagu ta hen anchichay kaman nabfurag way manlayad way mangila wat maka-an hen finuragcha yag makailacha. Waman hen anchichay mangaliyén makailacha ano te cha-ancha mabfurag, wat chicha angkay hen nanabfurag.” ");
INSERT INTO blw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yachi yag hen anchichay tapen hen Fariseo way nehahag-én, hen nangngarancha an nadchi, anchaat ekatén, “Ay ammoh anno ekatén nabfurag-ani.” ");
INSERT INTO blw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yag sommongfat ah Jesus way mangaliyén, “Non anyu an afunan koma way nabfurag-ayu, achì pafasoron chàyu, te achiayu makaila hen tot-owa ya mafalin way maka-an hen finuragyu. Ngém gapo ta ekatyuwén makaila-ayu, wat é-éttég hen fasoryu way yachi hen namufurag an chàyu.” ");
INSERT INTO blw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Angkay hiyachi yag nampani ah Jesus way mangaliyén, “Tot-owa hen antoy ifagà an chàyu way hen anchi tagu way ammag mangayat hen arad way hénggép hen anchi korongan hen karnero way faén hen anchi ustoy hawang hen ayéna, an i mangakawchi ya chumachael. ");
INSERT INTO blw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Waman hen anchi cha mangéy hen anchi hawang, yachi hen anchi ustoy pastor hen anchichay karnero. ");
INSERT INTO blw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wat hen anchi chan guwarcha hen hawang, fùtana agé hen anchi hawang no hen anchi ustoy pastor hen hénggép. Yag hiya, éh-éhhééna way mamaga hen ngangachan hen anchichay karnero way mangighad an chicha, ya chicha, féfênéncha hen alena. ");
INSERT INTO blw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yag no ighad hen anchi pastor chicha agé, hiya hen mangempango hen ayancha, wat umunudcha hen anchichay karnero te féfênéncha hen alena. ");
INSERT INTO blw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Achicha unuchun hen safaliy tagu te fênéncha way faén alen hen ustoy apocha wat ancha an omawid.” ");
INSERT INTO blw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yato hen penanin Jesus hen anchichay tatagu, ngém iggaycha ma-awatan no heno hen laychénay aryén. ");
INSERT INTO blw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Wat hiyachi, kasen nampani ah Jesus way mangaliyén, “Tot-owa hen antoy chà ifaga an chàyu way haén hen anchi hawang hen korongan hen karnero. ");
INSERT INTO blw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wat amin hen anchichay namangpango no haén way nat-én hen chacha intudtuchu, chichachi hen cha chumachael ya manga-akaw. Ngém chicha, iggay enafurot hen anchichay karnerò. ");
INSERT INTO blw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Haén hen anchi hawang, wat heno way mangéy an haén, hahalla-à hiya, ya awway agé way hénggép ya gumhad way i mangan. ");
INSERT INTO blw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngém hen anchi manga-akaw, maid kasen ganchatna no achi an i umarah laychéna ya an i pomatéy ya an i chumachael. Waman haén, hen ummaliyà, ta taguwê hen tatagu way idchat-o hen amma-ammay way ataguwancha ingganah kapnekancha.” ");
INSERT INTO blw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Haén hen anchi ammayay pastor, yag hen anchi ammayay pastor, annag iyanggayan hen ataguwana ah manalimunana hen karnerona. ");
INSERT INTO blw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Faénà kaman hen anchi an marabfuwan way guwarcha way faén ustoy nangen-awa hen karnero. Te hiya, no umale hen aggaégyatay atap way aho, annag iyanggayan hen chana pastoron yag ommawid. Wat issan hen anchi aho hen issana yag anchag mahiyà hen anchichay tapena. ");
INSERT INTO blw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ammag omawid chillu hen anchi an marabfuwan te hen labfuna yanggay hen chana gamgaman te achina tot-owa patigén hen karnero. ");
INSERT INTO blw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Waman haén, haén hen anchi ammay way pastor, ya kaman hen nangammuwà an Ama ya hen nangammuwana an haén, wat kaman agéhchi hen nangammuwà hen anchichay karnerò ya hen nangammuwancha agé an haén. Ya haén, an-og iyanggayan hen ataguwà ah manalimunà hen karnerò. ");
INSERT INTO blw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wachacha chillu agé hen tapen hen karnerò way cha-ancha melamong hen antochay karnerò ah korongan. Wat masapor ayagà chicha agé, yag no changréncha hen alè, wat umalecha ta éméhà-an hen mateponancha amin ya ta an ihà-an agé hen mamastor an chicha.” ");
INSERT INTO blw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Pararo hen layad Amay Apudyus an haén te idchat-o hen achar-o way matéy ah gapoh mataguwan hen anchichay karnero yag uray matéyà, mataguwà chillu. ");
INSERT INTO blw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maid makapréh hen ataguwà no achì afunan, te haén hen mangemparufus hen katéyà. Wacha hen kafaelà way mangemparufus hen matéyà, ya wacha agé hen kafaelà way mamangad hen ataguwà te yachi hen impiyar Ama an haén.” ");
INSERT INTO blw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hen nangngaran hen anchichay Judio hen enalen Jesus, anchag nan-agwa, ");
INSERT INTO blw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","te chuarcha hen cha mangaliyén nattagar ano ya an nahurugan, wat pakay lawa chachangrén hen anchi chana aryén. ");
INSERT INTO blw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waman hen tapena, chacha agé ekatén, “Ay ammoh wachay alen chi nahurugan ah umat hena. Ya ay ammoh kafaelan hen ongtan way manga-an hen finurag.” ");
INSERT INTO blw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Angkay hiyachi way agiléd way tempon hen anchi lagsak way manmanma-an hen niyam-ammaan hen anchi Templo ad Jerusalem, ");
INSERT INTO blw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","yag cha manadchad-aran ah Jesus hen anchi fangsar hen anchi Templo way ekatchéén fangsar Solomon. ");
INSERT INTO blw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yachi yag enamongan hen anchichay Judio hiya way mangaliyén, “An-anig nahédchan ya pasagchi ya achim ihéh lawrawagén an chàni no hea tot-owa hen anchi Cristu way empopostan Apudyus way hahadchénni.” ");
INSERT INTO blw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yag ekat Jesusén, “An-og cha ifagafaga an chàyu yà, ngém anyu chillug achi afuroton. Yag amin way chà ammaan gapon namiyaranà an Ama, chichachi koma hen manot-owaanyu way hiya hen narpowà. ");
INSERT INTO blw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ngém anyug achi chillu afuroton, te faén-ayu chillu karnerò. ");
INSERT INTO blw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Te hen karnerò, afurotoncha hen ifagà ya unuchuncha agé haén yag innilà agé chicha, ");
INSERT INTO blw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","wat idchat-on chicha hen mannanayun way ataguwancha an Apudyus way achicha metap-ar ah ing-inggana. Ya maid poros agé makapréh an chicha, te é-égnanà chicha ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ya ah Ama way hiya hen nangidchat an chicha an haén, maid nangatngato no hiya, wat maid makapréh an chicha an Ama, te a-ayyuwanana chicha. ");
INSERT INTO blw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Haén ya ah Amay Apudyus, an-anig nampachong te ihà-an-ani.” ");
INSERT INTO blw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hen nangaryan Jesus an nadchi, anchag nangalekam hen anchichay anap-apon hen Judio ah fato ta funto-oncha yanggay hiya. ");
INSERT INTO blw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yag nan-aleyat ah Jesus way mangaliyén, “Chuar hen enammaà way anammay way kaskascha-aw an chàyu way empa-amman Ama wat henon cha nadchi hen gapoh mamuntoanyu an haén nò.” ");
INSERT INTO blw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yag sommongfat hen anchichay anap-apo way mangaliyén, “Faén hen ammay way enammaam hen mamuntoanni an hea, te hen mamuntoanni an hea, hen cham mamréhan hen kena-apudyus Apudyus way an-a met lawa ammag tagu yag chamat agé mamfalinén hen acharno ah Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yag anat agé somongfat ah Jesus way mangaliyén, “Oo a, ngém pakay nesosorat hen anchi orchintaaw way ekat Apudyusén, ‘Chàyuwat, apudyus-ayu agé.’ ");
INSERT INTO blw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yag inni-ilataaw met way tot-oway tot-owa amin hen anchi nesosorat. Wat hen anchichay anap-otaaw ad namenghan way nangimfag-an Apudyus hen alena an chicha, ngenadnana chicha ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wat yachi, haén way penepelen Apudyus ya hennagna hen antoy lota, pakay ekatyuwén chà pérhén hen kena-apudyusna hen nangaryaén haén hen anàna. ");
INSERT INTO blw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wat non an umat yag maid enammaà ah kaskascha-aw way anggay yanggay ah Apudyus hen maka-amma, uray ud-ay achiyà afuroton. ");
INSERT INTO blw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngém gapo ta yachi agé hen chà ammaan, uray no achiyu laychén way mangafurot hen aryê, afurotonyu koma hen chà ammaan, te yachi hen manot-owaanyu way wacha ah Ama an haén ya wachaà agé an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yachi yag chacha agé kasen pachasén way manlapchù an Jesus, ngém annag inlisiyan chicha yag lommayaw. ");
INSERT INTO blw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Angkay hiyachi yag kasen ginumchang ah Jesus hen anchi wangwang way Jordan yag émméy hen anchi lugar way pés-éy namfunyagan Juan hen tatagu, wat ahchi hen ininggawana. ");
INSERT INTO blw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yag chuarcha agé chillu hen tatagu way ummunud an hiya, te ekatchéén, “Ah Juan way chan funfunyag, maid empàilana ah kaskascha-aw, ngém amin way imfagana mepanggép hen yahay tagu, tommot-owacha amin.” ");
INSERT INTO blw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wat chuarcha agé hen ommafurot an hiya ahchi. ");
INSERT INTO blw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Angkay ad Betania, wachacha hen toroy masosnod way cha Maria an Marta ya ah Lazaro. Ah Mariaanchi, hiya hen anchi nanginhiyat hen lana hen he-en Jesus yag emponahna hen fuùna. Yachi yag nansaket ah Lazaro ");
INSERT INTO blw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","wat imfilin cha Maria an Marta ah Jesus way mangaliyén, “Apo, chan saket ah Lazaro way ifam way laylaychém.” ");
INSERT INTO blw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Angkay chengngar Jesuschi yag ekatnéén, “Faén matéy hen kahalenonotan hen anchi saket Lazaro, te an kachayawan Apudyus way yachi agé hen machayawà way anàna.” ");
INSERT INTO blw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ah Jesus, laylaychéna tot-owa chicha amin way masosnod, ");
INSERT INTO blw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ngém hen nangngarana hen nansaketan Lazaro, iggay chillu lumigwat hen hiyachi te egad nanlooh hen chuway ag-agaw ");
INSERT INTO blw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","yag annaat ifaga hen anchichay pasorotna way mangaliyén, “Intaaw ta kasentaaw éméy hen sakopon Judea.” ");
INSERT INTO blw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Oo Apo,” way chacha ekat, “ngém tég-angay cha-a funto-on hen anchichay Judio ahchi ad chin-argaw wat ay ammoh kasentaaw agé éméy.” ");
INSERT INTO blw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yachi, yag nampani ah Jesus agé way mangaliyén, “Hemporo ya chuway uras hen umi-innitan hen init hen ihay ag-agaw, wat no manaran hen tatagu hen ag-agaw, achi mehagaw te hehellawan hen init hen charanéna. ");
INSERT INTO blw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ngém no lafi hen manaranana, kapeletan way mehagaw te helang.” ");
INSERT INTO blw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Enalen Jesuschi yag annaat ekat agéén, “Nanasséy hen anchi ifataaw way Lazaro, wat intaaw ta iyà fangonon hiya.” ");
INSERT INTO blw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yag sommongfat hen anchichay pasorotna way mangaliyén, “Oo a Apo, ngém no an nasséy, kapeletan way cha umun-unnina hen saketna.” ");
INSERT INTO blw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ngém hen laychén peet Jesus way aryénat, an peet nanattéy ah Lazaro, yag hen na-awatanchaat an nasséy. ");
INSERT INTO blw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yachi yag anat lawrawagén Jesus way mangaliyén, “An natéy ah Lazaro, ");
INSERT INTO blw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ngém ah pagsaya-atanyu, ammay te maichà hen natéyana ta wachay mangafurotanyu an haén. Wat intaaw ta intaaw ilan hiya.” ");
INSERT INTO blw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yachi yag nan-ale hen ihay ifacha way ah Tomas way kapel, yag ekatnan chichéén, “Antaaw ammag màyéy amin an Apotaaw ta no pédténcha, yag nìyatéytaaw kagé amin an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Angkay hiyachi way inumchah cha Jesus ad Betania, chengngarcha way looh nilurufù ah Lazaro hen opatay ag-agaw. ");
INSERT INTO blw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yag gapo ta an yanggay toroy lometor ménat hen ka-achawwéy Betania ad Jerusalem, ");
INSERT INTO blw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","wat chuarcha hen anchichay iJerusalem way émméy way i mangay-ayu an cha Marta an Maria gapon natéyan hen sonodcha. ");
INSERT INTO blw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Angkay hiyachi way chengngar Marta way naway cha Jesus, ina hinib-at chicha. Waman ah Maria, iggay gumhad. ");
INSERT INTO blw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Angkay inumchah ah Marta an cha Jesus yag ekatnéén, “Apo, non an-a koma wacha wat iggay matéy hen sonodtaaw. ");
INSERT INTO blw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngém innilà chillu way uray ad uwan, wat heno way ifagam an Apudyusat idchatna an hea.” ");
INSERT INTO blw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yachi yag ekat Jesus an hiyéén, “Man-uchi hen annay sonodno.” ");
INSERT INTO blw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Oo, innilà way man-uchi,” way ekat Marta, “te afurotò way man-uchicha chillu hen aminay natéy ah pegwana.” ");
INSERT INTO blw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yag anat ekat Jesus agéén, “Haén hen mangempauchi hen tatagu te haén hen managu an chicha. Wat heno way mangafurot an haén, tàén matéyat taguwê hiya chillu. ");
INSERT INTO blw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ya heno way natattagu, no omafurot an haén, achi matéy ah ing-inggana. Ay afurotomto.” ");
INSERT INTO blw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Oo Apo, afurotòha,” way ekat Marta, “ya afurotò agé way hea hen Cristu way anà Apudyus way empopostana way umale hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Angkay hiyachi way enalen Martachi, yag ommanamot ah faréycha way i nanget-én an Maria way mangaliyén, “Inumchah ah Apotaaw yag chana imohon hea.” ");
INSERT INTO blw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hen nangngaran Mariahchi, enag-aggagna way ginumhad way i manib-at an Jesus, ");
INSERT INTO blw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","te cha Jesus, cha-ancha homàyat ah fabréy, te é-éttégcha hen anchi nanaynanan Marta an chicha. ");
INSERT INTO blw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yachi yag hen anchichay tatagu way inu-umfun ah faréy, innilacha hen ginumhachan Maria wat ummunudcha, te ekatcha ah hamhamàchéén an ménat éméy ah lufù way i mankela. ");
INSERT INTO blw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Angkay inumchah ah Maria hen anchi iggawcha, ammag nampalentomang hen henagong Jesus way mangaliyén, “Apo cha-an angkay matéy hen anchi sonodtaaw non an-a wachahto.” ");
INSERT INTO blw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yachi way innilan Jesus hen chana mankelaan ya hen anchichay netnod way tatagu way ahekekela agé, yag naség-angan way térén yag ammag ommaghéy ah hamhamàna, ");
INSERT INTO blw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","yag annaat ekatén, “Chuud hen nanginlufuanyu an hiya.” Yag ekatchéén, “Ahchi Apo, wat intaaw ta intaaw ilan.” ");
INSERT INTO blw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yachi yag nankela agéh Jesus. ");
INSERT INTO blw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wat ekat hen anchichay tataguwén, “Ammag amchan tot-owa hen hamhamàna an Lazaro.” ");
INSERT INTO blw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ngém ekat agé hen tapenéén, “Oo a, ngém no makaka-an hen finurag hen tatagu, wat pakay emparufusna hen natéyan hen annay ifana nò.” ");
INSERT INTO blw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Angkay hiyachi way chengngar Jesus hen anchi enalecha, ammag kaskasen way nahéphép hen hamhamàna. Yag hiyachi way inumchahcha hen anchi lufù way liyang way natangfan ah tépà, ");
INSERT INTO blw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","yag anat ifagan Jesus way mangaliyén, “Ka-anényu hen annay tangéb hen lufù.” Ngém ommamhew ah Marta way mangaliyén, “Apo, man-agub angkay ad uwan te apatna way ag-agaw hen natéyana.” ");
INSERT INTO blw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yag ekat agé Jesus an hiyéén, “Oo a, ngém imfafaggà met an hea way no afurotona-at ilam hen machayawan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yachi yag kena-ancha hen anchi tangébna yag nantangad ah Jesus way mangaliyén, “Ama, manyamanà an hea te cham changrén haén. ");
INSERT INTO blw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Inni-ilà chillu way chachangrénà, ngém aryêto ah mangngaran hen antochay tatagu ta afurotoncha koma agé way hea hen nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yachi way enalen Jesuschi, yag annaat chakarén way mangaliyén, “Lazaro, fùnag-a.” ");
INSERT INTO blw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yag ammag fummùnagat agé hen anchi natéy way napopottepotan hen limana ingganah he-ena way naoppeopan amin hen uruna. Yag anat ekat Jesus hen anchichay tataguwén, “Ùfachényu ta wachay én-énnéna way omanamot.” ");
INSERT INTO blw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Angkay hen anchichay Judio way i nì-ib-ifun an Maria, chuar an chicha hen ommafurot an Jesus hen nangil-ancha hen anchi enammaana. ");
INSERT INTO blw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ngém wachacha chillu hen tapena way i nanaphapet hen anchichay Fariseo hen anchi enammaana. ");
INSERT INTO blw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yag hen anchichay Fariseo ya hen anap-apon hen papachi, empa-ayagcha hen anchichay toray way konsel, yag nan-a-atopàpàcha way mangaliyén, “Nokay lawa hen én-énnéntaaw hen ihay taguwanna way ammag lonay hen chana ammaan way kaskascha-aw. ");
INSERT INTO blw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te no antaaw ammag igiginnang ta chana payépayéén, ah awni yag hiyaat agé hen somorotan hen katagutagu. Yag no hiyachi hen mekaman, omaningarngarcha hen anchichay toray ad Roma wat awni yag anchag chachaelén hen anchi Templotaaw yag kena-ancha agé hen aminay mantorayantaaw.” ");
INSERT INTO blw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yachi yag nan-ale hen iha an chicha way ah Caifas hen ngachanna way hiya hen anchi kangatowan way pachi hen hiyachiy tawén, ekatnéén, “Aẁ ay ammoh ammag maid pèot chi hamhamàyu, ");
INSERT INTO blw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","te ay ammoh achiyu peet elasin way un-unnina hen ihà-an ah matéy ah sobfot hen kachuaran no hen machachaelantaaw amin way Judio.” ");
INSERT INTO blw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hen hiyachiy enalen Caifas, faén ah hamhamàna hen narpowana te gapo ta hiya hen kangatowanay pachi wat an empahmà Apudyus an hiya way masapor matéy ah Jesus ah sokat hen aminay Judio. ");
INSERT INTO blw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ya faén agé yanggay hen anchichay Judio hen masobfot hen matéyan Jesus, te aminay tatagu way niwaras hen antoy lota way anaén Apudyusat masobfotcha ah kateponancha amin. ");
INSERT INTO blw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nanepod hen hiyachi, inlugin hen anchichay anap-apon hen Judio way mantatagépfar ah ekamancha way mamchit an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Wat yachi, ammag maid én-énnén Jesus way manggégga-ay hen kawad-an hen chuaray Judio, wat inyapetna ad Efraim way fabréy way nehag-én hen anchi chanak, wat ahchi hen ini-inggawancha. ");
INSERT INTO blw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Angkay hiyachi way tég-angay umchah hen anchi lagsak hen Judio way Manmanma-an, wat chacha ma-amoamong ad Jerusalem hen chuaray tatagu way narpoh kafabréfabréy, ta incha mampacharos ah Templo ya anchaat mèlagsak. ");
INSERT INTO blw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yachi way nahibhib-atcha ah Templo chacha langrangéén ah Jesus way manganap ya chachan ahepennoot way mangaliyén, “Nokay ngata hen manmanmàyu, ay umale ngén ah Jesus way i mèlagsak ono achi.” ");
INSERT INTO blw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hen anchichay Fariseo ya anap-apon hen papachi, imfilincha hen anchichay tatagu ta no wacha hen mangila an Jesus, masapor ifagacha ta mepatelew. ");
INSERT INTO blw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Angkay hiyachi way énémay ag-agaw ya anat umchah hen anchi lagsak way Manmanma-an, yag kasen émméy cha Jesus ad Betania way fabréy Lazaro way hiya hen anchi nan-uchiyéna. ");
INSERT INTO blw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yag ah layadcha, senaganacha cha Jesus hen yachiy nadhém way ah Marta hen nan-alekatto yag wacha agé ah Lazaro way cha mèan an chicha. ");
INSERT INTO blw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yag yachi, wacha an Maria hen ihay futilya way natatarwan hen anchi kanginginaan way fangfangru way lanan chi nardo. Wat innarana yag inhiyatna hen he-en Jesus yag annaat eponah hen fuùna. Yag ammag cha homonohon hen anchi fangona ah faréy. ");
INSERT INTO blw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yachi yag ammag nanlili hen ihay pasorot Jesus way ah Judas Iscariote way hiya agé hen anchi mangenlao an Jesus hen ma-awni, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Pakay achi an elao hen annay lanaanna ta wacha laway midchat hen anchichay maid mafalinna, te awniyat éméy ah toronggasot hen laona.” ");
INSERT INTO blw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hen nangaryan Judas an nadchi, faén gapoh hamhamàna hen anchichay maid mafalinna te gapo ta anchu hen limana yag hiya hen mamangchén hen pelak ah chana mangak-akawan. ");
INSERT INTO blw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ngém ekat Jesus an Judasén, “Yasa man ta egad hiya, te enhàfanaha para hen milufuà no matéyà. ");
INSERT INTO blw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ya mepanggép hen anchichay maid mafalinna, sigud way mawawà-achacha an chàyu ah tomoronganyu, ngém haén, achiyà mafayag an chàyu.” ");
INSERT INTO blw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Angkay hiyachi way chengngar hen anchichay chuar way tatagu way wachah Jesus ad Betania, wat anchaat éméy way i mangila an hiya. Ya faén agé yanggay ah Jesus hen incha ilan, te ah Lazaro agé way nan-uchiyéna. ");
INSERT INTO blw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yachi yag hen anchichay anap-apon hen papachi, nan-ahetennopàcha ah ekamancha way mamchit an Lazaro agé, ");
INSERT INTO blw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","te gapon hiya, anchag chuar hen anchichay Judio way cha omafurot an Jesus way anchag nanchùgan chicha. ");
INSERT INTO blw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Angkay nawakas, chengngar hen anchichay chuar way tatagu way i mèlagsak ad Jerusalem way naway ah Jesus. ");
INSERT INTO blw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wat anchag nan-échén amin ah arumfanga yag incha hinib-at hiya way chacha èngaw way mangaliyén, “Ta machayaw ah Apudyus ya ta chayawéntaaw agé hen antoy ummale way narpon Apudyus way hiya hen aretaaw way ganà Israel.” ");
INSERT INTO blw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ah Jesus, nansasakkay hen ubfun hen kafayu way inchahancha te nesosorat chillu hen alen Apudyus way ekatnéén, ");
INSERT INTO blw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Chàyu way tatagu ad Jerusalem way manSion, achiayu cha émégyat te naway hen Areyu way nansasakkay hen ubfun hen kafayu.” ");
INSERT INTO blw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hen anchichay pasorot Jesus, iggaycha ma-awatan hen hiyachi hen anchichay cha mekaman. Ngém angkay namfangad ah Jesus ad uchu, hemhemmàcha hen anchichay na-ammaan an hiya, yag chichachiyat agé peet hen tommot-owaan hen anchichay nesosorat. ");
INSERT INTO blw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Angkay hen anchichay tatagu way nangila hen nangempauchiyan Jesus an Lazaro way annag finagaan yag fummùnag, chacha hapehapeténchi. ");
INSERT INTO blw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wat yachi hen i nanib-atan hen ammag chuar way tatagu an Jesus, te chengngarcha hen anchi kaskascha-aw way enammaana. ");
INSERT INTO blw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Waman hen anchichay Fariseo, chachan a-atopàpà way mangaliyén, “Nokay ngata hen ekamantaaw aya. Ammoh achitaaw peet makepaginang an hiya te ilangngén, amin hen tatagu hen antoy lotaat chacha amin peet somorot an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Angkay hiyachi yag wachacha agé hen anchichay faén Judio way narpod Grecia way i nèlagsak ad Jerusalem. ");
INSERT INTO blw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yag émméycha an Felipe way iBetsaida way sakop hen Galilea yag ekatchéén, “Apo, ay achi mafalin ta ini ilan ah Jesus ta changrénni hiya.” ");
INSERT INTO blw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Yachi yag anat éméy ah Felipe an Andres way i nangimfaga hen anchi imfagacha, yag anchaat éméy way chuwa way i mangimfaga an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yachi yag anat ekat Jesus ah mangngarancha aminén, “Haén way Pangorowan hen Tatagu, inumchah ad uwan hen tempon hen machayawà. ");
INSERT INTO blw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wat hamham-ényu ngén, te tot-owa hen antoy ifagà an chàyu way no ma-ayyuaan hen inilì ta achi mehamar, émé-éttég way ihà-an yag achi chumuar. Waman no mehamar way éméy hen lota yag nilufù, chumuar. ");
INSERT INTO blw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pachongna agé hen antoy ataguwantaaw, te heno way tagu way annag ayyuaan hen ataguwana hen antoy lota way ammag hen pagsaya-atan hen acharna hen chana yanggay patpatigén, maid sérfina te matéy chillu. Waman hen anchi tagu way faén hen ataguwana hen antoy lota hen patigéna, mètaguchi an Apudyus ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wat heno way manlayad way mangamma hen laychê, masapor sorotona haén. Wat yachi hen umunuchana hen ayà. Ya amin agé hen anchichay cha mangamma hen laychê, wat pachayawén agé Ama chicha.” ");
INSERT INTO blw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Angkay hiyachi yag ommaghéy ah Jesus way mangaliyén, “Ammag pararo hen antoy hamhamào, ngém nokay lawa hen ekat-o. Ay chawatê ngén, Ama, ta achi metoroy hen antoy mepachah an haén. Achi, te yato met chillu hen ganchat-o way ummale hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yachi yag nanluwaru way mangaliyén, “Ama, ammaam hen ammaam ta maila hen kachayawam.” Yag wachaat agé hen nan-ale ad uchu way ekatnéén, “Oo, maila hen kachayawà gapon anchi enamma-ammaam, yag kasen agé mepàila gapon anchi tég-angay mepachah an hea.” ");
INSERT INTO blw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hen anchichay tatagu way tommatàchég an nadchi, chengngarcha hen anchi ale, ngém hen ekat hen tapena, an ommechor. Ya hen tapena agé, ekatchéén anghel way an nètagépfar an hiya. ");
INSERT INTO blw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ngém sommongfat ah Jesus way mangaliyén, “Hen anchi ale way chengngaryu, faén angkay ah katorongà yanggay hen nepagngarana, te ah katoronganyu ta ma-awatanyu way chechengngarà an Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Te cha milugi ad uwan hen kachusaan hen katagutagu hen antoy lota way achi omafurot, te ad uwan hen ma-afa-an Chumunyu way chan toray an chicha. ");
INSERT INTO blw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yag haén, no metàépà hen anchi away yag tenoochà, yachi hen mangempa-anamotà hen tatagu hen karotarota an haén.” ");
INSERT INTO blw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hen nangaryan Jesus way metàép hen anchi away yag natood, yachi hen chana mempaka-ammuwan hen ekamanna way matéy. ");
INSERT INTO blw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yachi yag sommongfat hen anchichay na-a-among way tatagu way mangaliyén, “Oo a, ngém hen ekat hen anchi nesosorat way orchintaaw, ekatnéén, ‘Ammag matattagu ah inggana hen anchi Cristu way epalen Apudyus.’ Wat pakay cham ekatén masapor metàép hen away hen anchi Pangorowan hen Tatagu nò. Yag heno ay agé chilluchi hen annay cham aryén way Pangorowan hen Tataguwa.” ");
INSERT INTO blw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yachi yag anat mampani ah Jesus way mangaliyén, “Haén hen anchi helaw way cha manelaw hen ayan hen tatagu ngém achi mafayag yag tenaynà chàyu. Wat u-unnuchunà koma ta achiayu kaman hen anchichay cha mahelngan, te chichachiy tatagu, maid pootoncha ah chacha ayan. ");
INSERT INTO blw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ad uwan antoyanà way helaw, wat afurotonà koma ta mahehellawan-ayu way tatagu.” Angkay narpas way enalen Jesuschi yag anat lomayaw way i nantaro way iggay nampàila hen anchichay tatagu. ");
INSERT INTO blw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Te tàén ammag chuar hen kaskascha-aw way enammaan Jesus hen sangwanan hen anchichay tatagu, anchag achi chillu omafurot an hiya. ");
INSERT INTO blw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Wat yachi hen tommot-owaan hen anchi enalen Isaias way profeta ad namenghan way ekatnéén, “Apo, ammag maid mangafurot hen chani ifaga, ya anchag achi agé pagan-ano hen anchichay kaskascha-aw way enammaam.” ");
INSERT INTO blw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Wat yachi, ammag achi chillu mafalin way omafurotcha, te hen anchi ihay ensorat Isaias agé, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wat finurag Apudyus hen matacha ya empaknégna agé hen hamhamàcha ta achicha elasin hen tot-owa, ya ta achicha agé ma-awatan hen mepanggép an hiya. Te non an umat yag nanhagongcha an hiyaat kena-anna koma hen fasorcha.” ");
INSERT INTO blw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yaha hen enalen Isaias te innilana hen kena-apudyus Jesus wat henaphapetna. ");
INSERT INTO blw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tàén yachi, chuarcha chillu hen ommafurot way ponò hen anchichay Judio. Ngém anchag achi epadlaw hen ommafurotancha te émégyatcha ah mangemparyawan hen anchichay Fariseo an chicha hen anchichay chacha ma-am-amongan way Judio. ");
INSERT INTO blw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Te chacha pawadwad-én hen manayawan hen tatagu an chicha no hen manayawan Apudyus an chicha. ");
INSERT INTO blw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Angkay hiyachi yag chinakar Jesus hen alena way mangaliyén, “Heno way mangafurot an haén, faén yanggay haén hen chana afuroton te chana agé afuroton hen anchi nannag an haén. ");
INSERT INTO blw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ya heno way nangila an haén, innilanaat agé hen anchi nannag an haén. ");
INSERT INTO blw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Haén, ummaliyà hen antoy lota way manelaw hen hamhamà hen tatagu wat heno way omafurot an haén, mahelawan hen hamhamàna ta achi i-inggaw hen helang. ");
INSERT INTO blw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ya heno way mangngar hen chà itudtuchu yag achina chillu afuroton, faén haén hen manusa an hiya. Te iggayà umale hen antoy lota way manusa hen tatagu, te hen ummaliyà, an-o i hara-an hen tatagu. ");
INSERT INTO blw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ngém hen anchi tagu way mangachi an haén ya achina agé afuroton hen anchi chà itudtuchu, wacha chillu hen manusa an hiya ah pegwana, te hen anchi ena-allè, yachi hen kail-an hen kachusaana. ");
INSERT INTO blw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tot-owachi, te amin way enalè, faén ammag hamhamào hen narpowana te narpon Ama way nannag an haén, te hiya hen nangimfaga hen amin way aryê. ");
INSERT INTO blw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wat hen chà yanggay aryénat hen anchi imfagan Ama way aryê, te innilà way yachi hen mangidchat hen mannanayun way mètaguwan an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Angkay hiyachi way mafigat wat lagsak way Manmanma-an hen iggay mapchitan hen a-anà hen ganà Israel ad Egipto, yag innilan Jesus way inumchah hen tempon hen mamfangchana ad uchu an Amana. Yag ammag amchan hen layadna hen anchichay tatagu way sommorot an hiya hen antoy lota way ammag maid mepaniyan hen manlaychana an chicha, yag empàipàilana hen yachiy layadna ingganah natéyana. ");
INSERT INTO blw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Angkay hiyachi way cha mangan cha Jesus ya hen anchichay pasorotna, loohat ena-awis Chumunyu hen hamhamà Judas Iscariote way anà Simon way mangenlao an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ah Jesus, a-ammuna way emporang Amana hen aminay egad an hiya, yag a-ammuna agé way ah Apudyus hen narpowana ya hiya agé chillu hen mamfangchana. ");
INSERT INTO blw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yachi way chacha mangan, yag tommàchég ah Jesus yag kena-anna hen anchi agwan hen lumfongna yag annaat elepat hen towarya hen awàna. ");
INSERT INTO blw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yag tenarwana hen parangga ah chanum yag annaat ilugi way mangurah hen he-en hen anchichay pasorotna way chana eponah hen anchi towarya way enleleppatna ah awàna. ");
INSERT INTO blw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Angkay hiyachi way empachahna an Simon Pedro, ekat Pedrowén, “Apo, ay ammoh heaat agé hen mangurah hen he-è.” ");
INSERT INTO blw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yag ekat Jesusén, “Achim tot-owa ma-awatan ad uwan hen antoy chà ammaan, ngém ma-awatam chillu ah awni.” ");
INSERT INTO blw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yag ekat agé chillu Pedrowén, “Achi angkay poros mafalin way hea hen mangurah hen he-è.” Yag anat ekat Jesusén, “No achì urahan hen he-em, achi mafalin way mampasorot-o hea.” ");
INSERT INTO blw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Wat no yaha peet Apo,” way ekat Pedro, “faén yanggay hen he-è hen uraham ta uray agé hen limà ya hen urù.” ");
INSERT INTO blw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ngém ekat Jesusén, “Hen anchi looh nan-améh, nachachallosan met, wat achi masapor kasen maurahan amin hen acharna te manongad yanggay hen he-ena. Yag chàyu, nau-ullahan-ayu amin, ngém wacha chillu hen anchi iha an chàyu way cha-an.” ");
INSERT INTO blw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hen anchi nangaryan Jesusén wacha chillu hen iha way cha-an maurahan, enalenachi te a-ammuna way wacha hen mangenlao an hiya. ");
INSERT INTO blw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Angkay hiyachi way narpas hen nangurahan Jesus hen he-echa, kasenna inigga hen anchi lumfongna yag i tummùchu, yag ekatna way mangaliyén, “Ay na-awatanyu hen anchi an-owat enammaan an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hamham-ényu ngén, te chayu ekatén haén hen mistoroyu ya Apoyu, yag usto met hen annay chayu aryén te tot-owa. ");
INSERT INTO blw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wat haén way Apoyu ya mistoroyu, no haén hen mangurah hen he-eyu, masapor koma man-innurah-ayu agé ah he-e. ");
INSERT INTO blw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","An-og enammaanchi ta wachay torachényu ta hen anchi enammaà an chàyu, yachi agé koma hen ammaanyu hen tapena. ");
INSERT INTO blw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Te tot-owa hen antoy ifagà an chàyu way maid alepan ah nangatngato no hen apona, ya maid agé fafà-arén ah nangatngato no hen anchi cha mamabfaar an hiya. ");
INSERT INTO blw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wat gapo ta ma-awatanyu hen anchi laychê way aryén, wat an-ayug lomaylayad no ammaanyu.” ");
INSERT INTO blw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Entoroy Jesus way mangaliyén, “Achì aryén chaha an chàyu amin, te innilà chillu hen kenatataguyu way penepelè, ya innilà agé way wacha hen iha way achi metape hen antoy chà aryén. Ngém masapor chillu tomot-owa hen anchi nesosorat way alen Apudyus way ekatnéén, ‘Hen anchi iha way cha mèamèan an haén, hiyaat agé hen anchi mangempapchit an haén.’ ");
INSERT INTO blw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ifagàto an chàyu ad uwan ta anat umchah, ta no umchah, yaha hen manot-owaanyu way haén tot-owa hen anchi empopostan Apudyus way umale. ");
INSERT INTO blw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ya tot-owa hen antoy ifagà an chàyu way heno way tagu way mangimfilang hen anchichay hénagê, chana agé ifilang haén. Yag no ifilangna agé haén, chana agé ifilang hen anchi nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Angkay hiyachi way enalen Jesus amin chachi, ammag lommaweng way térén hen hamhamàna yag annaat elawag way mangaliyén, “Tot-owa hen antoy ifagà way wachan iha an chàyu way mangentochar an haén ah matéyà.” ");
INSERT INTO blw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yachi yag anchaat man-aheinnila amin hen anchichay pasorotna te maid innilacha no henoh nadchi paat hen chana aryén. ");
INSERT INTO blw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yag yachi, wachan ihay pasorot Jesus way laylaychéna way haénchi way Juan, yag nichachapatà an hiya way tummutùchu. ");
INSERT INTO blw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Wat sininyaran Pedro haén ta hanhanà ano an Jesus no henoh nadchi paat hen anchi chana aryén. ");
INSERT INTO blw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wat nànàéyà way nehachag paat an Jesus yag an-owat imohon way mangaliyén, “Apo, heno paat ah nadchi hen cham aryén.” ");
INSERT INTO blw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yag ekat Jesusén, “Hen anchi tagu way mangidchatà hen antoy tenapay way esabfang-o wat hiyachi.” Yachi yag ensabfangna hen anchi tenapay yag inidchatna an Judas way anà Simon Iscariote. ");
INSERT INTO blw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yag yachi way innaran Judas hen anchi tenapay, yag ammag nihurugat ah Chumunyu an hiya. Yag anat ekat Jesusén, “In-a ta ammaamat hen annay cham hamham-én.” ");
INSERT INTO blw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ngém chàniyanchi way cha mèan an hiya, iggayni ma-awatan no pakay yachin enalen Jesus an Judas. ");
INSERT INTO blw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yag gapo ta ah Judas hen nanangchén hen pelak, ekat hen tapenéén an ménat cha hénagén Jesus hiya way i lomaoh masaporni hen hiyachiy lagsak, no achi an i umidchat ah pelak hen anchichay maid mafalinna. ");
INSERT INTO blw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Angkay hiyachi way enawat Judas hen anchi tenapay, lommayawat. Yag lafi hen na-ammaan amin cha nadchi. ");
INSERT INTO blw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Angkay hiyachi way lommayaw ah Judas, imfagan Jesus an chàni way tapena way mangaliyén, “Haén way Pangorowan hen Tatagu, inumchah ad uwan hen tempon hen kachayawà. Yag gapoh machayawà, machayaw agé ah Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wat no haén hen mangempàila hen kachayawan Apudyus, wat epàilan Apudyus agé hen kachayawà way Pangorowan hen Tatagu yag ad uwan hen ka-ammaana. ");
INSERT INTO blw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Chàyu way kaman a-anào, an hen-aketan yanggay hen mì-iggawà an chàyu yag no ah awni, anapénà an chàyu. Wat hen imfagà hen anchichay ponò hen Judio, hiya agé hen ifagà an chàyu way achiayu maka-ale hen ayà. ");
INSERT INTO blw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Wat ad uwan, wacha hen kà-amma way orchin way iyurchin-o an chàyu way hen hiyachiy orchin, masapor man-ahelennayad-ayu ta kaman hen enkaman-o way manlayad an chàyu, yachi agé hen ekamanyu way man-ahelennayad. ");
INSERT INTO blw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Te no man-ahelennayad-ayu, elasin amin hen tatagu way chàyu hen pasorot-o.” ");
INSERT INTO blw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yachi yag nan-ale ah Simon Pedro way mangaliyén, “Oo Apo, ngém chuud peet hen ayam nò.” Yag ekat Jesusén, “Achiayu maka-ale hen anchi ayà ad uwan ngém umunud-ayu chillu ah tapen chi ag-agaw.” ");
INSERT INTO blw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yag chaat chillu ekat Pedrowén, “Apo, pakay achiyà makaunud an hea ad uwan, te nakasaganaà met way metnod an hea uray yachin iyatéy-o.” ");
INSERT INTO blw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yachi yag anat ekat Jesusén, “Ay tot-owa way nansasaggana-a way mìyatéy an haén. Te tot-owa hen antoy ifagà an hea, Pedro, way achi manollaò hen manò ah awni yag penetlomat way mangenhoot an haén.” ");
INSERT INTO blw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Angkay hiyachi yag imfagan Jesus an chàni way pasorotna way mangaliyén, “Achiayu machanagan ah uray heno, ta anyu yanggay ammag manokchun ah Apudyus ya manokchunyu agé haén. ");
INSERT INTO blw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Te ammag nawaya hen iggawan ah faréy Ama, wat epangpangò ta iyà esagana hen iggawanyu. Yag achì agé ammag cha aryén chato no faén tot-owa. ");
INSERT INTO blw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yag no éméyà way mangensagana hen iggawanyu, mamfangachà chillu agé way mangara an chàyu ta hen iggawà, yachi agé hen iggawanyu. ");
INSERT INTO blw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ya chàyu, innilayu met hen charan way éméy hen yachiy ayà.” ");
INSERT INTO blw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yachi yag nan-ale ah Tomas way mangaliyén, “Apo, maid angkay innilani hen ayam wat nokay lawa hen mangil-anni hen charan nò.” ");
INSERT INTO blw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yag anat ekat Jesus an hiyéén, “Haén hen anchi charan way éméy an Apudyus, te maid makaéy an hiya no faén haén hen manginyéy. Ya haén agé hen pongar hen tot-owa way ma-afurot, ya haén agé hen marpowan hen mannanayun way ataguwan. ");
INSERT INTO blw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wat no enlasinyu koma haén, elasinyu agé ah Ama. Yag manepod ad uwan, enlasinyu tot-owa hiya te innilayu hiya.” ");
INSERT INTO blw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yachi yag nan-ale agé ah Felipe way mangaliyén, “Apo, epàilam koma ah Amam an chàni ta mapnek-ani paat.” ");
INSERT INTO blw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yag sommongfat ah Jesus way mangaliyén, “Felipe, ammag nafayag hen nì-i-iggawà an chàyu amin, yag ay cha-anno peet chillu elasin haén. Te ilamat, hen anchi nangila an haén, innilana agé ah Ama. Yag pakay paat ekatno agéén epàilà ah Ama an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Te ay ammoh achiyu afuroton way nawawà-achaà an Ama ya nawawà-acha agé ah Ama an haén. Te amin hen antoy chà enale an chàyu, faén ah hamhamào hen narpowana te narpocha an Ama, ya amin hen chà enammaan, yachi hen chana man-ancharan an haén. ");
INSERT INTO blw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Afurotonyu koma hen chà ifaga way nampachong-anin Ama te nan-ahewacha-ani way chuwa. Yag no achi ummat hen antoy chà aryén ah mangafurotanyu, afurotonyu koma chillu gapo hen anchichay chà ammaan.” ");
INSERT INTO blw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Tot-owa hen antoy ifagà an chàyu way heno way omafurot an haén, mafalin ammaana hen kaman hen chà enammaan. Ya chakchakkar agé hen halenonot hen ammaana no hen enammaà te mamfangachà an Ama ah katoronganyu. ");
INSERT INTO blw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yag heno way chawatényu an Ama gapon afurotyu an haén, ammaàchi ah kachayawan Ama way hen machayawana, gapon haén way anàna. ");
INSERT INTO blw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wat uray heno way ifagayu gapon ommafurotanyu an haén, ammaàchi way ammaan.” ");
INSERT INTO blw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Angkay hiyachi yag entoroy Jesus way mangaliyén, “No tot-owa way laychényu haén, kapeletan way ammaanyu hen ifagà. ");
INSERT INTO blw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yag haén, ifagà agé an Ama ta epalena hen anchi manokat an haén ta hiya hen anchi Tomotorong an chàyu way yachi hen Espirituna. Ya ammag mìyachar an chàyu wat achi chàyu taytaynan ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ya hiya agé hen anchi mangempaka-ammu hen katot-owaan mepanggép an Apudyus. Achi mafalin midchat hen Espiritun Apudyus hen anchichay tatagu way achi omafurot te achicha chillu elasin hiya ya achicha agé ma-awatan hen mepanggép an hiya. Waman chàyu, ma-awatanyu hen mepanggép an hiya wat mì-iggaw an chàyu te ammag mìyachar ah ing-inggana.” ");
INSERT INTO blw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Tàén lomayawà ad uwan, achì iyang-anggayan chàyu te mamfangachà agé chillu. ");
INSERT INTO blw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ngém achi mafayag wat achiyà kasen il-ilan hen anchichay tatagun antoy lota way achi omafurot. Waman chàyu, kasenà chillu ilan te man-uchiyà. Yag gapo ta mannanayun hen ataguwà, mannanayun agé hen ataguwanyu. ");
INSERT INTO blw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yag no umchah hen ma-ammaan cha nadchi, yachi hen mangenlasinanyu way wà-achaà an Ama. Ya kaman agéhchi an chitaaw, te chàyu, wà-acha-ayu an haén ya wà-achaà agé an chàyu.” ");
INSERT INTO blw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Heno way tagu way mangngar hen antoy chà ifaga yag enafurotna, yachi hen anchi tot-owa way manlayad an haén. Yag hen anchi manlayad an haén, hiya hen laychén Ama. Ya haén, laylaychê agé hiya wat epaka-awat-o an hiya hen amin way mepanggép an haén.” ");
INSERT INTO blw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Angkay hiyachi yag nan-ale ah Judas way faén Judas Iscariote yag ekatnéén, “Apo, pakay ta chàni yanggay hen mangempaka-awatam hen mepanggép an hea yag faén hen anchichay tatagu way cha-an omafurot.” ");
INSERT INTO blw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","“Oo,” way ekat Jesus, “te hen anchichay tatagu way manlayad an haén, kapeletan way afurotoncha hen ifagà, wat laylaychén Ama chicha, yag chàni an Ama, an-anig mì-i-iggaw an chicha. ");
INSERT INTO blw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Waman hen anchichay tatagu way achi manlayad an haén, maelasin te anchag achi afuroton hen chà ifaga. Yag amin hen antoy chà agé ifaga, wat faén chillu ah hamhamào hen narpowana te narpon Ama way nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Chà epacha-an amin chato hen antoy kawad-à an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ya hen anchi Tomotorong way epalen Ama an chàyu way hiyan anchi Espiritu way manokat an haén, hiya hen mintudtuchu an chàyu hen aminay cha-an mepaka-awat, ya epahpahmàna agé hen amin way enalè.” ");
INSERT INTO blw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Wat yachi, tàén lomayawà ad uwan, mapapanoh chillu hen hamhamàyu te idchat-o an chàyu hen anchi kapanohan hen hamhamà way marpo paat an haén. Ya hen amin antoy lota, maid makaidchat ah kaman hena way kapanohan chi hamhamà. Wat achiayu machanagan ya achiayu amin émégyat. ");
INSERT INTO blw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chengngaryu hen anchi imfagà way lomayawà yag mamfangachà agé chillu. Wat no tot-owa hen anchi layadyu an haén, an-ayu koma an lomaylayad gapon éméyà an Ama, wat achiayu koma an tomkar, te hiya ahchi, nangatngato no haén ahto. ");
INSERT INTO blw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Empapadcha-an-o amin chato an chàyu ya anat ma-ammaan ta no ma-ammaan, yachi hen manot-owaanyu hen afurotyu an haén. ");
INSERT INTO blw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Wat manepod ad uwan, faén chuar hen mètagépfarà an chàyu te ah Chumunyu way chan toray hen antoy lota, tég-angay hen mamachasana way mangafà an haén, ngém achi chillu makafael. ");
INSERT INTO blw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ngém tàén, ma-ammaan hen ammaana te masapor ma-awatan hen katagutagu hen antoy lota way gapon layad-o an Ama wat an-og ammaan paat amin hen imfagana.” Yaha hen enalen Jesus yag annaat ifaga an chàni way pasorotna way mangaliyén, “Intaawat ta lomayawtaaw ahto.” ");
INSERT INTO blw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Angkay hiyachi yag nampani ah Jesus way mangaliyén, “Haén hen kaman pongar hen ihay mura yag ah Ama hen kaman cha manalimun hen hiyachiy mura. ");
INSERT INTO blw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ya hen anchichay tatagu way cha omafurot an haén, chicha hen kaman pengen hen anchi mura. Yag mag-ay ta wachay pengena ah achi mamunga, porhan angkay Ama. Waman hen anchichay cha mamunga way pengena, charocharosana ta anchag mamullifug ah funga. ");
INSERT INTO blw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pachongna agé an chàyu, te kaman-ayu nacharosan gapon anchi intudtuchù an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wat anyug é-égnanan haén ah hamhamàyu ta ammay hen mì-i-iggawà an chàyu. Te kaman hen anchi penge way no achi mepopoyot hen anchi pongarna, achi mamunga te hen anchi pongarna hen marpowan hen ataguwana. Wat kaman agéhchi an chàyu, te no achiyu agé é-égnanan haén ah hamhamàyu, achiayu mamunga te achiayu maka-amma hen ammayê.” ");
INSERT INTO blw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Haén hen pongar hen mura ya chàyu hen anchichay pengena. Wat hen anchi tagu way é-égnanana haén ah hamhamàna ya i-inggawà an hiya, hiya hen mamullifug ah funga te ammaana hen chuar way ammayê. Ngém no maichà an chàyu, achiayu angkay poros maka-amma hen ammayê. ");
INSERT INTO blw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hen anchi tagu way achina é-égnanan haén ah hamhamàna, hiya hen kaman hen anchi penge way metap-ar. Wat ammag marango yag na-among yag nahèlan. ");
INSERT INTO blw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wat no é-égnananyu haén ah hamhamàyu ya mimura an chàyu hen anchi intudtuchù, wat mafalin chawatényu hen uray heno way chawatényu wat ma-ammaanchi an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","No mamullifug-ayu ah funga, wat yachi hen machayawan Ama yag yachi agé hen mangempàil-ana way chàyu hen tot-oway pasorot-o. ");
INSERT INTO blw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Haén, laylaychê chàyu way hen manlaychà an chàyu, kaman hen manlaychan Ama an haén. Wat ifiinyu koma hen anchi layad-on chàyu. ");
INSERT INTO blw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yag no chayu afuroton hen intudtuchù, chayu tot-owa ifiin hen layad-on chàyu, way kaman an haén way chà agé ifiin hen layad Ama an haén te chà afuroton hen imfagana. ");
INSERT INTO blw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Chà ifaga chato an chàyu ta mèlaylayad-ayu hen layad-o ah achi komorangan hen laylayadyu.” ");
INSERT INTO blw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Yato hen iyurchin-on chàyu way masapor man-ahelennayad-ayu ta kaman hen manlaychà an chàyu wat kaman agéhchi hen manlaychanyu hen ifayu. ");
INSERT INTO blw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maid kasen kachakkaran way layad no faén hen anchi layad hen ihay tagu way ammag mangidchat hen acharna ta matéy ah katorongan hen ifana. ");
INSERT INTO blw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ya chàyu hen tot-oway ifà no afurotonyu hen chà iyurchin an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ad uwan, achì ekatén alepan-o chàyu, te hen alepan, maid innilana hen pontos hen cha epa-amman hen apona an hiya. Ngém iyalig-o chàyu ah ifà, te amin way imfagan Ama an haén, an-og imfaga amin agé an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yag faén agé chàyu hen namele an haén ah omapowanyu, te haén hen namele an chàyu way omafurot an haén, ya chinutokà chàyu ah i mamullifug ah funga. Ya ammag mannanayun agé hen hiyachiy fungayu. Wat no hiyachi, amin way ifagayun Ama gapon haén wat idchatna an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wat yato hen iyurchin-o an chàyu wat masapor man-ahelennayad-ayu amin.” ");
INSERT INTO blw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yachi yag entoroy Jesus way mangaliyén, “Achiayu mahaang no agorgoran chàyu hen tatagu hen antoy lota way achi omafurot, te anà chillug enagorgoran an chicha. ");
INSERT INTO blw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Te non an nampachong hen hamhamàyu hen hamhamàcha, laylaychéncha chàyu. Ngém gapo ta penelè chàyu way omafurot yag nafalewan hen hamhamàyu, wat yachi hen achicha manlaychan an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ay cha-anyu aliw-an hen anchi imfagà an chàyu way maid alepan ah nangatngato no hen anchi apona. Wat yachi hen achi mafalin way ilisiyanyu hen anchi iggay-o ilisiyan. Wat gapo ta penaligatanà hen anchichay achi omafurot, kapeletan way paligatén chàyu agé. Ya hen utopna agé, gapo ta wachan nangafurot hen intudtuchù, kapeletan way wacha agé hen mangafurot hen itudtuchuyu. ");
INSERT INTO blw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngém amin way ammaancha an chàyu, ammaancha gapon ommafurotanyu an haén te maid chillu innilacha an Ama way nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Non an umat yag anà an iggay ummale hen antoy lota way manudtuchu an chicha, maid matot-owaan hen fasorcha. Ngém gapo ta ummaliyà, maid manlasoncha hen fummasorancha. ");
INSERT INTO blw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Te heno way tagu way achi manlayad an haén, achicha agé laychén ah Ama. ");
INSERT INTO blw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yag hen iha agé, non an umat way maid agé enammaà ah kaskascha-aw way achi maka-amma hen tatagu, maid agé matot-owaan hen fasorcha. Ngém ah katot-owana, innilacha met chachi ah manot-owaancha no henowà yag chachaat chillu agorgoran chànin Ama. ");
INSERT INTO blw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ngém ma-ammaan amin chilluchi ah tomot-owaan hen anchi nesosorat way orchincha way ekatnéén, ‘Anà ammag agorgoran an chicha ah maid lapona.’ ” ");
INSERT INTO blw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yachi yag anat ekat Jesus agéén, “Epalè an chàyu hen anchi Tomotorong way marpon Ama way hiya hen Espiritun Apudyus ya hiya agé hen mangintudtuchu hen katot-owaan an chàyu. Yag no umale, tàchéganà an hiya. ");
INSERT INTO blw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ya uray agé chàyu wat tàchéganà an chàyu te chàyu hen cha netnonetnod an haén nanepod hen lugrugin hen anchi chà nantudtuchuwan.” ");
INSERT INTO blw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Empacha-an-o amin cha natto an chàyu ta uray heno way mepasamak, achi koma pomospos-aw hen afurotyu. ");
INSERT INTO blw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Te umchah angkay hen mangemparyawan chàyu hen anchichay chayu ma-am-amongan. Ya am-améd te umchah agé hen tempo way no pédtén chàyu, ekatchéén yachi paat ano hen chacha mangammaan hen laychén Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hen mangammaan hen tatagu an cha nadchi an chàyu, te maid innilacha an Ama ya maid agé innilacha an haén. ");
INSERT INTO blw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ngém chà epacha-anchi an chàyu ad uwan ta no umchah hen mangammaancha, haham-ényu koma way nepapadcha-an chillu.” Entoroy Jesus way mangaliyén, “Iggay-o ifaga cha natto an chàyu hen anchi pés-éyna te wawà-achaà an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ngém imfagà ad uwan te tég-angay hen mamfangchà hen anchi nannag an haén. Ngém ammag maid paat lawa mangempoot an chàyu no nokay hen ayà. ");
INSERT INTO blw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Oo, te innilà way cha-ayu tomkar way térén gapo hen anchichay chà ifaga. ");
INSERT INTO blw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ngém tot-owa angkay hen antoy chà ifaga an chàyu way an angkay pagsaya-atanyu hen antoy lomayawà, te no achiyà lomayaw, achi agé umale hen anchi Tomotorong way mìyachar an chàyu. Wat yachi hen masapor éméyà ta epalè hiya. ");
INSERT INTO blw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yag no umale, epaka-awatna hen tatagun antoy lota way anchag enomfat, te enomfatcha mepanggép hen tot-oway cha fumasoran, ya hen iha, no heno agé hen tot-owa way maid fasfasorna, ya anat agé hen mepanggép hen chusan Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Te ilanyu ngén, anchag enomfat hen anchichay achi omafurot mepanggép hen tot-oway fumasoran, te hen tot-oway fumasoran, wat hen anchi achicha mangafurotan an haén. ");
INSERT INTO blw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yag ancha agég enomfat mepanggép no heno hen tot-oway maid fasfasorna, te hen anchi maid fasfasornaat haén way hen matot-owaana, te man-uchiyà yag ana-at manchakpos an Ama ad uchu way achiyà kasen ilan an chicha. ");
INSERT INTO blw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yag enomfatcha agé mepanggép hen kachusaan hen tatagu te looh nifafagga hen kachusaan Chumunyu way hiyan anchi chan toray hen aminay achi omafurot.” ");
INSERT INTO blw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Entoroy Jesus way mangaliyén, “Chuar koma hen ifagà an chàyu ngém innilà way achiayu maka-ara ad uwan. ");
INSERT INTO blw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngém no umale hen anchi Espiritun Apudyus way mangintudtuchu an chàyu hen katot-owaan mepanggép an Apudyus, wat itudtuchuna agé hen anchi tot-owa way ma-afurot. Ya faén agé hamhamàna hen marpowan hen itudtuchuna, te anna an aryén hen chengngarna. Yag epacha-anna agé hen ma-ammaan ah tapen chi ag-agaw. ");
INSERT INTO blw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ya hen Espiritun Apudyus agé, epachayawna haén te aminay intudtuchù, nipiyarchachi an hiya way mangempaka-awat an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Amin way wacha an Ama, yachi agé hen wacha an haén, wat yachi hen mangaryaén hen Espiritu, haén hen marpowan hen itudtuchuna an chàyu.” ");
INSERT INTO blw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Angkay hiyachi yag entoroy Jesus way mangaliyén, “Achi mafayagat umchah hen achiyu mangil-an an haén, yag achi agé mafayagat kasenyu agé ilan haén.” ");
INSERT INTO blw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yachi yag wachan tapena an chàni way pasorotna way chan ahepennoot no nokay hen laychénay aryén hen anchi enalena way achi mafayagat maid ilanni an hiya, yag achi agé mafayagat kasenni ilan hiya, ya anat agé hen anchi enalena way “hen gapona, te éméy ano an Amana.” ");
INSERT INTO blw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yag hen iha agé, no nokay hen laychénay aryén hen anchi ekatnéén “achi mafayag,” te iggayni ma-awatan no heno hen chana aryén. ");
INSERT INTO blw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Angkay ah Jesus, a-ammuna way makaim-imoh-ani yag annaat ekatén, “Ay chayu anapén no heno hen laychén hen anchi enalè way aryén way ‘achi mafayagat maid ilanyu an haén ya achi agé mafayagat kasenyu agé ilan haén.’ ");
INSERT INTO blw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tot-owa hen antoy ifagà an chàyu way no umchahchi wat mankela-ayu ya an-ayug tomkar way térén. Waman hen anchichay tatagun antoy lota way achi omafurot, anchaat an lomaylayad. Ngém chàyu way tomkar, achi agé mafayagat masokatan hen tokaryu ah pararo way layad. ");
INSERT INTO blw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hen miyaligana, kaman hen fufae way chan pànot way chan totokar gapon sigab hen potona, ngém no fùnag anchi onga, annag aliw-an hen anchi sigab gapoh layadna hen anchi onga. ");
INSERT INTO blw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wat pachongna an chàyu te uray tomkar-ayu ad uwan, achi mahen-awniyanat lomaylayad-ayu chillu te kasentaaw man-aheinnila. Yag achi makàka-an hen hiyachiy layad way ichahanyu.” ");
INSERT INTO blw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Yag no umchahchi way tempo, faén haén hen manchawatanyu, te ah Ama. Ya tot-owa hen antoy ifagà an chàyu way heno way ifagayu an hiya gapon haén, idchatna an chàyu. ");
INSERT INTO blw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ingganad uwan maid imfagfagayu an Ama ah nanginyusaranyu hen ngachan-o, ngém ad uwan, manchawat-ayu wat awatényu ta wachay sém-éman hen laylayadyu ah maid komok-orangana.” ");
INSERT INTO blw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Entoroy Jesus way mangaliyén, “Ammag panpani hen enkaman-o way nangimfaga amin an cha natto an chàyu, ngém umchah hen tempo way achiyà ammag mampanpani te an-og lawagén way mangimfaga hen mepanggép an Ama. ");
INSERT INTO blw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yag no umchah hen hiyachiy tempo, manakchakposonyu way manchawat an Ama way mangusar hen ngachan-o, te achi masapor haén hen manginchawat para an chàyu, ");
INSERT INTO blw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","te amchan hen layad Ama an chàyu gapo hen layadyu an haén ya gapon nangafurotanyu way hiya hen narpowà. ");
INSERT INTO blw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Te tot-owa way ummaliyà hen antoy lota way narpo an Ama, yag ad uwan, lomayawà hen antoy lota ta mamfangachà chillu an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yachi yag nan-aleaniyat way pasorotna, ekatniyén, “Ilamat, ma-awatanni ad uwan hen annay cham aryén te faén pani. ");
INSERT INTO blw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yag ad uwan, sigurachuani way innilam hen egad way uray peet hen hehemmàni, wat achi masapor manhanhan-ani. Wat yachin mangafurotanni way ah Apudyus tot-owa hen narpowam.” ");
INSERT INTO blw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yachi yag ekat Jesus an chàni agéén, “Ay afurotonyu peet tot-owa, ");
INSERT INTO blw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","te umchah angkay hen uras way an-ayug miwa-at way ammag wéhchiyén omanamot ah faréyna way ammag manaynan an haén. Ngém achiyà chillu mataynan te mawawà-acha ah Ama an haén. ");
INSERT INTO blw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Empapadcha-an-o hen antoy cha-an ma-ammaan ta mapapanoh hen hamhamàyu gapon afurotyu an haén, te paligatén angkay chàyu hen tatagu hen antoy lota. Ngém sém-ém koma hen hamhamàyu te ena-afào ah Chumunyu way chan toray hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Angkay hiyachi way imfagan Jesus cha nadchi, nantangad ad uchu yag nanluwaru way mangaliyén, “Ama inumchah tot-owa ad uwan hen tempona. Wat pachayawém haén way yachi chillu hen mangempachayawà an hea. ");
INSERT INTO blw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Impiyarno an haén hen lébféng-o way mangimfiyang hen egachay katagutagu, wat amin hen anchichay penelem way omafurot an haén, adchà agé chicha ah mannanayun way mètaguwancha an hea. ");
INSERT INTO blw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yag hen mangawatancha hen yachiy mannanayun way ataguwan, te afurotoncha way hea yanggay hen tot-oway Apudyus, ya afurotoncha agé way haén hen Cristu way empopostam way umale hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Empàilà hen kachayawam hen antoy lota Ama, te lempas-o way nangamma hen amin way empa-ammam an haén. ");
INSERT INTO blw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Wat ad uwan Ama, kasenno pachayawén haén hen sangwanam way kaman hen anchi pés-éy kachayawanta hen anchi cha-an ma-ammaan hen antoy lota.” ");
INSERT INTO blw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Entoroy Jesus way manluwaru, ekatnéén, “Hen antochay pasorot-o, iggaycha omafurot hen pés-éyna, ngém gapo ta penelem chicha way mangafurot an haén, wat empaka-awat-o an chicha hen mepanggép an hea yag enafurotcha hen imfagam. Tatagum chillu chicha, ngém annog inchat an haén. ");
INSERT INTO blw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yag ad uwan, ma-awatancha way amin way wachan haénat hea hen nangidchat te hea hen narpowana. ");
INSERT INTO blw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Yag intudtuchù an chicha hen amin way imfagam an haén yag enafurotcha amin. Wat tenot-owacha way hea hen narpowà ya hea hen nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Wat hiyaha Ama, chawatê hen torongno an chicha. Achì cha iluwaruwan hen anchichay achi omafurot, te hen anchichay cha omafurot yanggay way inidchatno an haén hen iluwaruwà te tatagum chillu. ");
INSERT INTO blw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Te aminay tatagu way ommafurot an haén wat tatagum chicha amin, ya tatagù chicha agé. Ya chaà agé mepachayaw gapon chicha. ");
INSERT INTO blw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yag ad uwan Ama, mamfangachà an hea way manaynan hen antoy lota, ngém mataynancha amin hen anchichay inidchatno an haén. Wat heay machayaw way Ama, usarém hen mannakafalinno way manalimun an chicha ta mantetempoyugcha way éméhà-an kaman hen nantempoyuganta. ");
INSERT INTO blw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Hen nì-iggawà an chicha, henahallimunà chicha way nangusar hen mannakafalinno way inidchatno an haén. Wat maid nayagyag an chicha way manongad yanggay hen anchi mayayagyag chillu ah tomot-owaan hen anchi looh nesosorat. ");
INSERT INTO blw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yag ad uwan, ta anat umchah hen mamfangchà an hea, epapagngar-o an chicha hen antoy chà ifaga an hea ta mèlaylayadcha hen antoy laylayad-o way maid makorangana. ");
INSERT INTO blw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Intudtuchù an chicha hen aminay imfagam an haén, yag yachiyat agé hen mangagorgoran hen anchichay achi omafurot an chicha. Ya hen ma-agorgoraancha, te kamancha an haén way haén, an-og achi etempoyug hen hamhamào hen anchichay achi omafurot. ");
INSERT INTO blw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ama, achì ekatén aram chicha ah omachawwéyancha hen anchichay achi omafurot hen antoy lota, te hen chawatê, ta anno komag hahallimunan chicha ta achicha marokop an Chumunyu. ");
INSERT INTO blw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Te chicha, kaman hen hamhamào hen hamhamàcha way achi kaman hen hamhamà hen anchichay achi omafurot. ");
INSERT INTO blw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wat usarém hen inyalem way katot-owaan way mangempapegsa hen hamhamàcha an hea ta a-ammaancha yanggay hen imfagam. ");
INSERT INTO blw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Chà hénagén chicha way i mangintudtuchu hen alem hen tatagun antoy lota way kaman hen nannagam an haén. ");
INSERT INTO blw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","An-og idchat hen achar-o an hea way matéy para an chicha ta chicha, midchatcha agé an hea.” ");
INSERT INTO blw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ama faén yanggay hen antochay cha omafurot ad uwan hen chà iluwaruwan, te uray hen aminay omafurot ah pegwana gapon itudtuchucha. ");
INSERT INTO blw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ya hen chà chawatén, ta mantetempoyugcha way kaman chillu hen nantempoyuganta way wacha-a an haén ya wachaà agé an hea. Wat kaman agéhchi koma way wachacha agé an chita. Te hen mantetempoyugancha way éméhà-anat yachi hen mangafurotan hen katagutagu way hea tot-owa hen nannag an haén. ");
INSERT INTO blw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Hen nangempachayawam an haén wat kaman agéhchi hen mangempachayawà an chicha te éméhà-an hen hamhamàcha way kaman agé hen hamhamàta. ");
INSERT INTO blw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mawawà-acha-a an haén ya wawà-achaà agé an chicha ta matorongancha way mantetempoyug, te yachi chillu hen mangil-an hen katagutagu hen antoy lota way hea hen nannag an haén. Ya elasincha agé way laylaychém hen antochay cha omafurot an haén way kaman hen manlaycham an haén.” ");
INSERT INTO blw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Entoroy Jesus way manluwaru, ekatnéén, “Ama, hen laychê paatat hen anchichay penelem way omafurot an haén wat mì-i-iggawcha an haén ya ta i-illancha ah ing-inggana hen kachayawà. Ya hen kachayawà, yachin manachayyawam an haén gapon layadno an haén nanepod hen cha-an ma-ammaan hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ama way ka-ammayan, maid tot-owa innilan hen anchichay achi omafurot an hea, ngém haén, innilà hea, ya hen antochay cha omafurot an haén, innilacha way hea hen nannag an haén ");
INSERT INTO blw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","te intudtuchù an chicha hen mepanggép an hea. Ya an-og etotoroy agé way mangempaka-awat an chicha amin hen mepanggép an hea ta hen ekamanno way manlayad an haén, yachi koma agé hen ekamancha way man-ahelennayad ta mawawà-achaà an chicha.” ");
INSERT INTO blw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Angkay hiyachi way narpas hen nanluwaruwan Jesus, netnod-ani way pasorotna an hiya yag ginchangni hen anchi arug-ug ad Kidron way émméy hen anchi napodchokan hen mura. ");
INSERT INTO blw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yag ah Judas way nangenlao an Jesus, innilana agéchi way lugar te yachi chillu hen chani manibhib-atan an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wat enetnod Judas hen anchichay sorchachu ya hen anchichay guwarcha way hennag hen anap-apon hen papachi ya hen Fafariseo. Yag inna inhib-at chicha an cha Jesus way anchag nan-a-armas ya nanhehelaw amin. ");
INSERT INTO blw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yachi yag gapo ta ena-ammun Jesus chillu hen aminay mepasamak an hiya, wat ammag i nihib-at an chicha way mangaliyén, “Heno hen chayu anapén.” ");
INSERT INTO blw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yag ekatchéén, “Ah Jesus way eNazaret.” “Haén met,” way ekat Jesus. Yag ah Judas way nangentochar, netatappe an chicha. ");
INSERT INTO blw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hen nangaryan Jesusén “haén met,” anchag inyugnud yag narangadcha. ");
INSERT INTO blw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yag anat ekasen Jesus way mangaliyén, “Henoh nadchi hen chayu anapén.” Yag ekatcha agéén, “Ah Jesus man way eNazaret.” ");
INSERT INTO blw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Imfagà met way haén,” way ekat Jesus. “Wat no haén hen chayu anapén, achiyu cha etape hen antochay tapena.” ");
INSERT INTO blw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Imfagan Jesuschi ah tomot-owaan hen anchi imfagana an Amana hen nangaryanéén, “Maid mayagyag ah uray ihà-an hen anchichay tatagu way inidchatno an haén.” ");
INSERT INTO blw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Hen hiyachi, ah Simon Pedro way namfafangngid, nan-uhfùnaat yag fina-agna hen anchi alepan hen anchi ap-apon hen pachi way ah Malco hen ngachanna wat narongchan hen awan hen ingana. ");
INSERT INTO blw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yag anat chégyayén Jesus ah Pedro way mangaliyén, “Ichùchùnowat hen annay fangidno. Te ay ammoh ekatnowén achì eparufus hen antoy hehemmà Ama chillu way ma-ammaan an haén.” ");
INSERT INTO blw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Angkay hen anchichay sorchachu ya hen anchi komandércha ya anat agé hen anchichay guwarcha way Judio, tenelewcha ah Jesus yag finarudcha. ");
INSERT INTO blw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yag anchaat iyéy an Anas way atogangan Caifas way ah Caifasanchi, hiya hen anchi kangatowan way pachi hen hiyachiy tawén. ");
INSERT INTO blw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ya hiya agé hen anchi nanugun hen anchichay ifana way Judio way un-unnina no ihà-an hen matéy ah masobfotan hen chuar no hen machachaelan hen amin. ");
INSERT INTO blw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Angkay hiyachi yag chàni an Simon Pedro way pasorot Jesus, inu-unnudni hiya. Yag gapo ta am-ammuwà hen anchi ap-apon hen pachi, emparufusà way mì-ighép an Jesus hen anchi fatawan hen faréy. ");
INSERT INTO blw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Waman ah Pedro, nehàfa ah lahin hen anchi arad. Yachi yag namfangachà way i mètagépfar hen anchi fufae way cha mammam-at hen anchi hawang ta paghépéna koma ah Pedro. ");
INSERT INTO blw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yag yachi way hinénggép, ekat hen anchi fufae an hiyéén, “Hean samet hen ihay pasorot Jesus agé.” “Faén aya,” way ekat Pedro. ");
INSERT INTO blw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Angkay hiyachi, gapo ta tongnin, nan-apoycha hen anchichay alepan ya guwarcha hen anchi fatawa yag naliubcha way man-anichu, wat i agé nèanichu ah Pedro. ");
INSERT INTO blw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Angkay hiyachi yag ah Anas way kangatowan way pachi hen ar-argaw, finistigarna ah Jesus mepanggép an chàni way pasorotna ya anat hen chana intudtuchu. ");
INSERT INTO blw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yag sommongfat ah Jesus way mangaliyén, “Aminay nantudtuchuwà, nantudtuchuwà met hen sangwanan hen katagutagu hen anchichay chataaw ma-am-amongan ya anat ah Templo way chataaw mahibhib-atan amin, wat maid entàtàlilig-o. ");
INSERT INTO blw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wat pakay haén hen mansarudsucham yag faén hen anchichay cha nangngar, te chicha, chengngarcha met hen aminay intudtuchù an chicha.” ");
INSERT INTO blw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hen nangaryan Jesus an nadchi, ammag tenappet hen ihay guwarcha hiya yag ekatnéén, “Apay yaha hen ekamanno way manongfat hen anchi ap-apon hen pachi.” ");
INSERT INTO blw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yag anat ekat Jesus agéén, “No wachay laweng ah enalè, eparawagno hen anchi karawengna, ngém no usto hen enalè, pakay tappeténà.” ");
INSERT INTO blw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Angkay hiyachi yag empééy Anas ah Jesus an Caifas way kangatowan way pachi hen hiyachiy tempo way é-éttégna way ammag nakakanselan. ");
INSERT INTO blw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Angkay hiyachi yag ah Pedro agé, é-éttégna way nèa-annichu ah fatawa. Yag anat kasen agé hanhanan hen tapen hen anchichay tatagu way mangaliyén, “Ay ammoh faén hea tà hen ihay pasorot Jesusanna.” “Faén aya,” way ekat agé Pedro. ");
INSERT INTO blw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yachi yag nan-ale hen ihay alepan hen anchi kangatowan way pachi way agin hen anchi fina-ag Pedro yag ekatnéén, “Ayong-ang, ay ammoh faén agé hea hen ihay innilà hen anchi papenodchok way nenetnod an Jesus.” ");
INSERT INTO blw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yag ammag tenlén Pedro way mangenhoot chillu yag nanollaoat hen manò. ");
INSERT INTO blw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Angkay hiyachi way figfigatay térén, enlayawcha ah Jesus ah faréy Caifas way manginyéy hen anchi faréy hen anchi gubérnador way eRoma. Ngém hen anchichay anap-apon hen Judio, iggaycha mì-ighép te marémhacha no hénggépcha hen faréy hen faén Judio. Yag non an umat yag hénggépcha, achi agé mafalin way mèancha hen anchi lagsak way Manmanma-an way tég-angay umchah. ");
INSERT INTO blw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yag hen hiyachi, ginumhad ah Gubérnador Pilato way i managépfar an chicha, yag ekatnéén, “Pakay anyug cha iyale hen taguwannahto, no nokay hen epafasoryu an hiya.” ");
INSERT INTO blw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yag ammag nansongfatan hen anchichay Judio way mangaliyén, “Ay ammoh annig cha iyale hiyahto non an maid fasorna.” ");
INSERT INTO blw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yag anat ekat agé Pilatowén, “Umpayat egad-ayu, yag innarayu ta chàyu hen manguwis ah manorotanyu paat hen orchinyu.” “Oo a,” way cha ekat hen anchichay Judio, “ngém chàyu way eRoma, achiyu met parufusun chàni way mamchit hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yachi hen enkamancha an Jesus ah tomot-owaan hen anchi imfafaggana chillu mepanggép hen ekamannay matéy. ");
INSERT INTO blw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Angkay hiyachi yag kasen hinénggép ah Pilato ah faréy, yag annaat epa-ayag ah Jesus, yag senarudsudna way mangaliyén, “Ay hea ano hen Aren hen Judio.” ");
INSERT INTO blw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yag sommongfat ah Jesus way mangaliyén, “Ay laychém tot-owa way ma-awatan no henowà ono annog an cha ar-aryénha te yahan chengngarno way cha aryén hen tatagu.” ");
INSERT INTO blw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yag anat ekat Pilatowén, “Ammoh Judiowà ta innilà hen mepanggép an hea. Te hen annachay kacharaam paat way Judio ya hen anchichay anap-apon hen papachiyu hen nanginchérém an heahto, no henowat paat hen enammaam.” ");
INSERT INTO blw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yachi yag anat ekat Jesusén, “Haén, faén kaman hen man-areyan hen tatagu hen antoy lota hen nan-areyà te non an umat yag anà an man-are hen antoy lota, kapeletan way nèpatéycha hen anchichay pasorot-o ta achiyà telewén hen anchichay anap-aponi way Judio. Ngém faén hen antoy lota hen iggaw hen kena-arè.” ");
INSERT INTO blw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Wat area peet tot-owa no yaha,” way ekat Pilato. Yag ekat agé Jesusén, “Hea kagé ah mangalem. Te ah katot-owana, hen gagarà paat way ummale hen antoy lota way miyanà ah tatagu, ta epaka-ammù hen katot-owaan. Ya heno way manlayad hen katot-owaan, afurotona hen ifagà.” ");
INSERT INTO blw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Ay way nangila ah katot-owaan,” way ekat agé Pilato. Angkay hiyachi yag kasen ginumhad ah Gubérnador Pilato way i managépfar hen anchichay tatagu, yag ekatnéén, “Maid met inchahà ah fasor hen annay taguwanna. ");
INSERT INTO blw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wat gapo ta wacha chillu hen gagangayyu way no umchah hen yatoy lagsak way Manmanma-an, wachay wacha chillu hen ihay farud way eparufus-o, wat ay achiyu laychén ta hen annay areyu way Judio hen eparufus-o.” ");
INSERT INTO blw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yachi yag anchag an heo-ongaw way mangaliyén, “Faén hiya hen parufusum ta ah Bernabe.” Yag ah Bernabeyanchi, ammag futangelo. ");
INSERT INTO blw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Angkay hiyachi yag empahaprat Pilato ah Jesus hen anchichay sorchachuna. ");
INSERT INTO blw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yag hen anchichay sorchachu, anchag finallengawngaw hen anchi pagat yag empahòrongcha an hiya way yachi ano hen koronana te are, ya anchaat agé lumfongan ah chittakan way kaman lumfong chi are. ");
INSERT INTO blw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Yag anchaat agé sénsén-én way mangaliyén, “Anhangén eman hen Aren hen Judio.” Aryén chachiyén chachaat agé tappetén hiya. ");
INSERT INTO blw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Angkay hiyachi yag kasen agé ginumhad ah Pilato way i mangimfaga hen anchichay tatagu way mangaliyén, “Epaghad-o hen annay taguwanna ah mangil-anyu way maid tot-owa inchahà ah fasorna.” ");
INSERT INTO blw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yachi yag anchaat epaghad ah Jesus way étég hen pagat ah uruna ya narurumfongan agé ah chittakan. Yag anat ekat Pilatowén, “Ilanyuto no cha-an-ayu mapnek.” ");
INSERT INTO blw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ngém hen nangil-an hen anchichay anap-apon hen papachi ya hen anchichay guwarcha an Jesus, chachaat èngaw amin way mangaliyén, “Ekorosyuwat man hiya!” Yag anat ekat agé Pilatowén, “Chàyu kaỳ yag enkorosyu ta egad-ayu te maid angkay fasorna ah inchahà.” ");
INSERT INTO blw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yag nansongfatan hen anchichay tatagu way mangaliyén, “Ah katongparan hen orchinni way Judiowat masapor matéyha way tagu way matéy te annag enammaan hen acharna ah anà ano Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hen nangngaran Pilato an nadchi, anat agég kommaskasen hen égyatna. ");
INSERT INTO blw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yag annaat kasen agé epaghép ah Jesus yag senarudsudna way mangaliyén, “No man paat tot-owa hen narpowam aya.” Ngém ammag achin ar-ale ah Jesus. ");
INSERT INTO blw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Pakay achiyà songfatan,” way ekat Pilato. “Ay ammoh maid innilam way wachan kafaelà way mangemparufus an hea ya mangempakoros an hea.” ");
INSERT INTO blw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yachi yag sommongfat ah Jesus way mangaliyén, “Hen karébféngam yanggay an haénat, hen patinggan yanggay hen inidchat Apudyus an hea. Wat hen anchichay nangemporang an haén an hea, chakchakkar hen fasorcha no hea.” ");
INSERT INTO blw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hen nangngaran Pilato agé an nadchi, annag cha iyanap hen ekamanna way mangemparufus koma an Jesus. Ngém ammag cha hanétanat agé hen anchichay tatagu way mangèngaw way mangaliyén, “No parufusum hiyaat, faén angkay ah Are Cesar hen cham tàchégan te hen annay kafusorna. Te heno way mangaliyén hiya hen Are, kaman paat taropa way anna an cha pérhén hen tùchun hen anchi Aretaaw ad Roma.” ");
INSERT INTO blw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Angkay hen nangngaran Pilato hen chacha agé èngaw, annag kasen empaghad agéh Jesus yag annaat iyéy hen anchi chana mangu-uwwisan hen tatagu way am-ammay chi archatna way hen ngachanna ah Henebreo wat Gabata, yag anat i tumùchu hen anchi tùchuna. ");
INSERT INTO blw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hen hiyachiy uras, tég-angay manggawa way hen mafigat, milugi hen anchi lagsak way Manmanma-an. Yachi yag imfagan Pilato hen anchichay tatagu way mangaliyén, “Aya, egad-ayu hen antoy Areyu te areyu chillu.” ");
INSERT INTO blw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Yag anchaat ammag heo-ongaw way mangaliyén, “Ekorosyuwat hiya ta matéy.” Yag anat ekat Pilatowén, “Ay ammoh pédtê lawa hen Areyu.” Yag ekat hen anchichay anap-apon hen papachiyén, “Maid ay kasen Areni no faén yanggay ah Cesar ad Roma.” ");
INSERT INTO blw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yachi yag emporang Pilato ah Jesus an chicha ta egadcha way i mangenkoros. ");
INSERT INTO blw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Angkay hiyachi way innarachah Jesus yag anchaat epafu-ud hen anchi korosna way manginyéy hen anchi lugar way ekatchéén “alentutugun chi uru” way hen ekatchah Henebreo wat Golgota, ");
INSERT INTO blw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","yag enkoroscha hiya ahchi. Yag wachacha agé hen chuway nekoros, wat nanggagaw-éncha ah Jesus. ");
INSERT INTO blw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Yachi yag wacha agé hen anchi empasorat Pilato way empòatcha hen anchi koros Jesus way ekatnéén, “Yato ah Jesus way eNazaret way Aren hen Judio.” ");
INSERT INTO blw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yag toroy karase way ale hen nesoratana te ah Henebreo ya ah Latin ya anat ah Griego. Wat chuarcha hen tatagu way namasa, kaskasen te nehahag-én ad Jerusalem hen anchi nekorosana. ");
INSERT INTO blw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yachi yag émméycha hen anchichay anap-apon hen papachi an Pilato way manlili, ekatchéén, “Faén komachi hen ensoratno way ‘hiya hen Aren hen Judio,’ ta hen ensoratno koma wat ‘annag cha ekatén hiya ano hen Aren hen Judio.’ ” ");
INSERT INTO blw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Yag senongfatan Pilato chicha way mangaliyén, “Hen laychê way mesorat wat yachi yanggay hen mesorat.” ");
INSERT INTO blw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Angkay hiyachi way enlansan hen anchichay sorchachu ah Jesus, innaracha hen lumfongna yag nan-apaténcha ah màmàchangancha way opat. Yag anchaat agé aran hen anchi akrangna way ammag nanlarayyun way maid naogotana, ");
INSERT INTO blw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","yag nantatagépfarcha way mangaliyén, “Achitaaw gissayénto way man-apatén ta antaaw an manfub-unnotan ta ilantaaw no heno hen mangen-awa.” Hen yachiy na-ammaan, na-ammaan ah tomot-owaan hen anchi nesosorat way alen Apudyus way ekatnéén, “Inyà changcha hen lumfong-o ya anchaat mamfub-unnotan hen akrang-o.” Wat yachi tot-owa hen enammaan hen anchichay sorchachu. ");
INSERT INTO blw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Angkay hiyachi, tommatàchég-ani hen anchi hag-én hen koros Jesus, way wachacha agé cha inana way hen-agi ya anat ah Maria way ahawan Cleofas, ya anat agé ah Maria way eMagdalena. ");
INSERT INTO blw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yag yachi way innilan Jesus ah inana ya anat haén way laylaychéna way pasorotna way tommatàchég hen ê-éyna, ekatnéén, “Ina, ifilangno ah Juananna ah anàno.” ");
INSERT INTO blw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yag annaat agé ekat an haénén, “Heay Juan, ah Inaanna wat Inam.” Yag nanepod hen hiyachi, nì-i-iggaw ah Inana an chàni. ");
INSERT INTO blw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Angkay hiyachi way innilan Jesus way lempasna amin hen nipiyar an hiya, yag annaat ekatén, “Nàwawà,” way yachi agé hen enalena ah tomot-owaan hen anchi nesosorat way alen Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yachi yag ensawsawcha hen anchi penapa-atcha way lopot hen anchi elém yag inchawchawcha way mangempasosop an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Angkay senosop Jesuschi yag annaat ekatén, “Narpas amin,” yag anat manyongyong yag étéynaatchi. ");
INSERT INTO blw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Angkay hiyachi yag hen anchichay anap-apon hen Judio, émméycha an Pilato way mangimfaga ta maptén koma hen he-en hen anchichay nekokollos ta ag-aggah yag natéycha ta mapahcha hen koros. Te hen kafigatana, yachi hen anchi lagsak way Manmanma-an way térénay ngilin, wat achi koma mafalin way é-éttég hen anchichay nekokollos. ");
INSERT INTO blw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yachi yag émméy hen anchichay sorchachu way i mamtén hen he-en hen anchichay nekokollos. Yag yachi way penténcha hen he-en hen anchi chuwa, ");
INSERT INTO blw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","yag ekatchéén eparégcha ah Jesus, yag innilachaat agé way looh peet natéy, wat iggaycha pétnén hen he-ena. ");
INSERT INTO blw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ngém tàén, enchootat hen ihay sorchachu hen say-angna hen chinang-ilig Jesus, yag fummùnagat agé hen chara ya chanum. ");
INSERT INTO blw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Haén way nangensorat an cha natto, innilan paat hen matà amin cha nadchi way na-ammaan, wat tàchégà way tot-owa amin, ya tot-owa agé hen antoy chà ifaga. Yag hen chà manaphapetan ta omafurot-ayu koma agé. ");
INSERT INTO blw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na-ammaan amin cha nadchi ah tomot-owaan hen anchi nesosorat way alen Apudyus way ekatnéén, “Maid paat maptén ah uray ihay tongarna.” ");
INSERT INTO blw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ya wacha agé hen ihay nesosorat way ekatnéén, “Fub-uyééncha agé hen anchi chinootcha.” ");
INSERT INTO blw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Angkay narpaschi yag wachan ihay iyAremateo way ah Jose hen ngachanna way omma-abfurot an Jesus, ngém annag entataro hen afurotna gapoh égyatna hen anchichay anap-apon hen Judio. Yachi yag émméy ah Joseyanchi an Pilato way i mangimfaga ta arana hen achar Jesus. Angkay inyafun Pilato, émméycha ");
INSERT INTO blw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","an Nicodemo way i mangpah. Ah Nicodemowanchi, hiyan anchi émméy an Jesus hen henlafiyan. Hen hiyachi, ina-aran agé Nicodemo hen lemanporo way kilo way fangfangru way mira ya aros ta wachay etapecha hen anchi natéy way manginlufù. ");
INSERT INTO blw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Angkay hiyachi way impahcha hen anchi achar Jesus, yag imfunifuncha hen anchi lopot way nasekparan ah fangfangru way yachi chillu hen gagangayni way Judio no wacha hen ini ilufù. ");
INSERT INTO blw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yachi yag wacha agé hen ihay kà-amma way lufù way maid nilubrufù an nadchi way hen iggawna, hen gawan hen ihay podchok way nehahag-én agé hen anchi nekorosan Jesus. ");
INSERT INTO blw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yag gapo ta tég-angay milugi hen anchi ngilin way Manmanma-an, yag gapo amin ta nehahag-én wat ammag yachi hen incha nanginlufuan an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Angkay hiyachi way figfigat hen Chuminggu way chan penen-et, émméy ah Maria way eMagdalena ah lufù. Yag yachi way inumchah, innilana way ammag nafufùtanat agé hen anchi lufù. ");
INSERT INTO blw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wat ammag nanagtag way ummaley mangimfaga an chàni an Pedro. Yag ekatna way mangaliyén, “Enlayawcha angkay hen achar Apotaaw ah lufù yag maid agé innilani no chuud hen nanginyéyancha.” ");
INSERT INTO blw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yag an-aniyat gumhad an Pedro way i mangila hen anchi lufù. ");
INSERT INTO blw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Cha-ani managtag way chuwa yag gapo ta fìfiahà noh Pedro, wat haén hen pés-éy umchah. ");
INSERT INTO blw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yag enteng-éy-o way nangila ad char-ém yag ammag anggay hen anchi funifun ah natotòrong. ");
INSERT INTO blw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Cha-anà hénggép yag nawayat agé ah Simon Pedro way cha umunud, yag ammag nahanorò ad char-ém. Yag innilana agé hen anchi funifun way natotòrong, ");
INSERT INTO blw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ya anat agé hen anchi niyoppeop hen uruna way nakokoppen yag nepapattang hen ê-éyna. ");
INSERT INTO blw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yachi yag hinénggépà agé way i mangila. Yag hen nangil-à hichi, yachi hen nangafurotà paat way nan-uchi ah Jesus. ");
INSERT INTO blw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Te hen hiyachiy tempo, cha-anni chillu ma-awatan hen laychén hen anchi nesosorat ad namenghan way aryén way masapor matéy ya anat man-uchi. ");
INSERT INTO blw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yachi yag an-aniyat omanamot way chuwa. ");
INSERT INTO blw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Angkay ah Maria way eMagdalena, nantaynan hen anchi lufù way chan kelakela. Yag hen chanan kelaan, enteng-éyna way mangila ad char-ém, ");
INSERT INTO blw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yag innilanaat agé hen chuway anghel way nanlurumfongchah pokkawan way tummutùchu hen anchi nepabfégan hen achar Jesus way hen iha, tummutùchu ah ulluwan ya hen iha, tummutùchu ah hégnachén. ");
INSERT INTO blw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yachi yag nan-alecha hen anchichay anghel way mangaliyén, “Pakay mankela-a, sonod.” Yag anat ekat Mariéén, “Okaỳ te enlayawcha hen achar hen anchi Aponi yag maid innilà hen nanginyéyancha.” ");
INSERT INTO blw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yachi yag anat mantuwili yag innilanaat agé ah Jesus way tommatàchég, ngém iggayna elasin way ah Jesuschi. ");
INSERT INTO blw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yachi yag ekat Jesus an hiyéén, “Pakay mankela-a, sonod, ya henokay ah nadchi hen cham anapén.” Hen ekat Maria ah hamhamàna, taguchi way cha mangil-ila hen anchichay mura hen nanagépfar an hiya, yag annaat ekatén, “Panga-asem paat no hea hen nangenlayaw, ta itudtuchum hen nangiggaam ta iyà koma aran.” ");
INSERT INTO blw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yag anat fagaan Jesus hen ngachanna way mangaliyén, “Maria.” Yag ammag nanhagongat ah Maria yag ekatna way nan-aleh Henebreowén, “Raboni!” way hen laychénay aryén, Apo. ");
INSERT INTO blw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","“Oo ngém achiyà cha égnanan,” way ekat Jesus, “te cha-anà éméy an Ama ad uchu. Ngém in-a ta im ifaga hen anchichay ifataaw way éméyà ad uchu an Amay Apudyus way hiya agé hen Amayu way chayu chayawén.” ");
INSERT INTO blw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yachi yag ummale ah Maria way i nangimfaga an chàni amin way pasorot Jesus way innilana ano tot-owa ah Apo Jesus. Yag henaphapetna agé hen amin way imfagana an hiya. ");
INSERT INTO blw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Angkay hiyachi way nadhém hen yachi chillu way ag-agaw way Chuminggu, na-a-among-ani way pasorot Jesus ah faréy way nanchachaig te cha-ani émégyat hen anchichay anap-aponi way Judio. Yachi yag ammag niyahachat agé ah Jesus way nètatàchég an chàni, yag ekatna way mangaliyén, “Antoyanà, wat ta omammay hen hamhamàyu.” ");
INSERT INTO blw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yachi way enalenachi yag annaat epàila hen limana ya hen chinang-iligna. Wat ammag pararo hen laylayadni hen nangil-anni an hiya. ");
INSERT INTO blw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yachi yag anat kasen ifagan Jesus an chàni way mangaliyén, “Omammay paat hen hamhamàyu, yag hénagê chàyu way i mantudtuchu way kaman hen enkaman Ama way nannag an haén.” ");
INSERT INTO blw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yachi yag annaat ehapod an chàni way mangaliyén, “Ta ma-adchan-ayu hen Espiritun Apudyus. ");
INSERT INTO blw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yag heno way fasor hen tatagu way pakawanényu, wat mapakawanchi tot-owa. Yag heno agé way achiyu pakawanén, achi chillu mapakawanchi.” ");
INSERT INTO blw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Angkay ah Tomas way kapel way ihay ifani way pasorot Jesus agé, niyaphor way maid hiya hen anchi pés-éy nampàil-an Jesus an chàni. ");
INSERT INTO blw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wat yachi way henaphapetni hen nangil-anni an Apo Jesus, annag ekatén, “Ay ammoh mafalinha tà. Achì angkay afurotonha ingganah ilà paat hen filat hen lansa hen limana way manchà yag inggana agéh epahrò-o hen limà hen chinang-iligna.” ");
INSERT INTO blw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Angkay hiyachi way kasen Chuminggu yag kasen-ani agé nanchachaig ah faréy way na-a-among way pasorot Jesus, yag hen hiyachi, wacha tot-owa ah Tomas. Yachi yag ammag niyahachat agéh Jesus an chàni yag ekatnéén, “Antoyanà agé wat omammay koma hen hamhamàyu.” ");
INSERT INTO blw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yag annaat agé ekat an Tomasén, “Antoyan hen limà wat ilam yag tenchàno hen antoy filatna, yag empahròno agé hen limam hen antoy chinang-ilig-o ta éhéd yag afurotom ta achia koma chan finafinafang.” ");
INSERT INTO blw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Yag anat ekat Tomasén, “Hea tot-owa hen Apò way hea ah Apudyus.” ");
INSERT INTO blw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yag anat ekat Jesusén, “Ammay te cha-a tot-owa omafurot gapoh nangil-anà, ngém mas am-ammay hen anchichay cha-an mangila an haén yag chacha chillu omafurot.” ");
INSERT INTO blw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Wacha chillu hen ammag lonay way tapenay kaskascha-aw way enammaan Jesus hen sangwananni way pasorotna way cha-an-o esorat hen yatoy libnu. ");
INSERT INTO blw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ngém ensorat-o cha natto ah mangafurotanyu way ah Jesus hen anchi tot-oway anà Apudyus way empopostana way umale. Yag no omafurot-ayu, mètaguayu an hiya ah ing-inggana. ");
INSERT INTO blw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Angkay hiyachi yag wacha hen kasen nampàil-an Jesus an chàni way pasorotna hen anchi fayfay way Tiberias way yato hen na-ammaan. ");
INSERT INTO blw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Hen hiyachi, niyaphor way wacha-ani amin an cha Simon Pedro an Tomas way kapel ya ah Natanael way eCana way sakop hen Galilea, ya anat chàni way chuwa way anà Zebedeo, ya hen kasen chuway ifani agé. ");
INSERT INTO blw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Yachi yag anat ekat Simon Pedrowén, “Ta éméyà lawa manafukora.” Yag anniyat agé ekatén, “Aẁ mìyaleani agé.” Wat émméy-ani amin yag annig lenabrafi way namfafangka way cha manafutafukor yag ammag poros paat chi innarani. ");
INSERT INTO blw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Angkay cha pomaway, wachan ihay tommatàchég hen anchi tarantag way ah Jesus peet ngém cha-anni maelasin. ");
INSERT INTO blw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yag ekatna an chàniyén, “Ay wà-achay ginachiwyu way sosnod.” “Maid umpay,” way ekatni. ");
INSERT INTO blw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yag annaat ekatén, “Wat eporwak hen annay tafukoryu ah apet hen pachawananyu wat wachan aranyu.” Yachi yag anniyat tot-owa eporwak, yag ammag achianiyat agé makarapchù te ammag chuar hen nàna. ");
INSERT INTO blw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Haén, enlasin-o way ah Jesus yag an-owat ekat an Pedrowén, “Ah Apotaaw angkaychi.” Yag hen nangngaran Pedro an nadchi, annag nan-igga hen lumfongna te nanlorohay yag pommassong yag tumifù way éméy an Jesus. ");
INSERT INTO blw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yag chàniy tapena, namfafangka-ani way cha ummunud te chani lapchu-un hen anchi tafukor way nanapno ah gachiw. Ya faén chillu achawwéy hen anchi tarantag te an ménat an hinggasot yanggay way metros. ");
INSERT INTO blw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Angkay hiyachi way tommàchang-ani hen anchi tarantag, yag innilani hen apoy way fummafara ya hen gachiw way neloroppò ya anat hen ma-an. ");
INSERT INTO blw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yag ekat Jesus an chàniyén, “Uminyaleayu hen tapen annay ginachiwyu.” ");
INSERT INTO blw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Wat hinénggép ah Pedro hen anchi fangka yag ininatna hen anchi tafukor way mangentàchang way nanapno ah chachanakkar way gachiw te émméy ah hinggasot ya lemanporo ya toro. Yag tàén hiyachi way ammag chuar, iggay chillu nagissay hen anchi tafukor. ");
INSERT INTO blw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yachi yag enayagan Jesus chàni way mangaliyén, “Wayyu ta mangantaaw.” An chàniyanchi, maid paat ihah nangimoh no hiya tot-owa ah Jesus te innilani amin chillu way hiya. ");
INSERT INTO blw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yachi yag innaran Jesus hen anchi ma-an, yag inwarasna an chàni, ya umat agé hen anchi gachiw. ");
INSERT INTO blw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yachi hen petlon hen nampàil-an Jesus an chàni way pasorotna nanepod hen nan-uchiyana. ");
INSERT INTO blw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Angkay hiyachi way narpas-ani way nangan, ekat Jesus an Simon Pedrowén, “Heay Simon way anà Juan, ay wadwadcha hen layadno an haén no hen annachay tapena.” Yag ekat Pedrowén, “Apo, inni-ilam met way laylaychê hea.” Yag anat ekat Jesusén, “Wat tudtuchuwam hen anchichay karnerò way anat ommafurot an haén.” ");
INSERT INTO blw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yachi yag empegwan Jesus way mangaliyén, “Simon way anà Juan, ay laychém tot-owa haén.” “Oo Apo,” way ekat Pedro, “innilam kayyà way laylaychê hea.” Yag anat ekat Jesus agéén, “Wat halimunam ngarud hen anchichay karnerò way omma-abfurot an haén.” ");
INSERT INTO blw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yachi yag anat epetlon Jesus chillu way mangaliyén, “Simon way anà Juan, ay wacha tot-oway layadno an haén.” Yachi yag ngommehpéy hen hamhamà Pedro te empetlon Jesus way nangalen nadchi, yag annaat ekatén, “Apo, innilam hen egad, wat innilam agé way laylaychê tot-owa hea.” Yag anat ekat Jesusén, “Wat tudtuchuwam hen anchichay karnerò.” ");
INSERT INTO blw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yag entoroy Jesus way mangaliyén, “Tot-owa hen antoy ifagà an heay Pedro way hen kafab-arum, an-ag egachén cha-an lumfong ya egad-ah cham ay-ayan ah laylaychém. Ngém faénha hen mekaman no omawni, te hen marakayamat mamayachém hen limam yag finarudcha-a way manginyéy hen achim laychén way ayan.” ");
INSERT INTO blw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Enalen Jesuschi ah mangempacha-anana hen ekaman Pedro way matéy ah kachayawan chillu Apudyus. Angkay enalen Jesus amin cha nadchi, yag annaat ekat an Pedrowén, “Haén yanggay hen sosollotom.” ");
INSERT INTO blw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Yachi way nantuwili ah Pedro yag innilana haén way pasorot Jesus way laylaychéna way cha umunud. Haén hen anchi nichachallangéy an Jesus hen anchi anongoh hen nèanana an chàni way yachi hen nangimohà no heno hen anchi i mangenlao an hiya. ");
INSERT INTO blw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yag yachi way innilan Pedro haén, annaat ifaga an Jesus way mangaliyén, “Apo, wat nokay agé hen mekaman an hiya nò.” ");
INSERT INTO blw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yag anat ekat Jesusén, “Egachà an hiya, te non an umat yag laychê way manatagu an hiya ingganah kasen-o mamfangchan, faén chillu fiyangnochi. Ngém hea ay, sosollotom paat haén.” ");
INSERT INTO blw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nanepod hen nangaryan Jesus an nadchi, ammag niwarawagat agé hen anchichay ommafurot way achiyà ano matmatéy. Ngém faén metchi hen enalen Jesus te hen imfagana, ekatnéén, “Non an umat yag laychê way manatagu an hiya ingganah kasen-o mamfangchan, faén fiyang Pedrochi.” ");
INSERT INTO blw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Haén way nangensorat amin an cha natto, haén ah Juan way pasorot Jesus wat tàchégà hen katot-owan hen amin antoy ensorat-o. Te inni-ilani amin way tot-owa hen antochay ensorat-o. ");
INSERT INTO blw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ya wachacha agé hen chuar chillu way tapen hen enammaan Jesus way cha-an mesorat te non an umat yag mesorat amin ah libnu, wat ah hamhamàowat awni yag achina érég hen amin antoy lota ah iggawancha.");
INSERT INTO blw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Hen anchi pés-éy sorat-o an heay Apo Teofilu, henaphapet-o hen aminay enammaan Jesus ya hen intudtuchuna nanepod hen nanginlugiyana ");
INSERT INTO blw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","inggana hen namfangchana ad uchu. Yag hen anchi cha-anna namfangchan ad uchu, wacha hen impiyarna hen anchichay penepelena way aposelna way hen anchi impiyarna, narpochi hen Espiritun Apudyus. ");
INSERT INTO blw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yag hen narpasan hen natéyana ya hen nan-uchiyana, ammag cha nampàipàila an chicha hen unig hen opatporoy ag-agaw, ya chuar agé hen tapen hen enkamanna ah manot-owaancha way nan-uchi tot-owa. Ya hen hiyachiy tempo agé, chana intudtuchu an chicha mepanggép hen mantorayan Apudyus. ");
INSERT INTO blw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hen-argawan way nìya-among ah Jesus an chicha, intugunna way mangaliyén, “Achiayu cha lomaylayaw hen antoy fabréyanto way Jerusalem ingganah idchat Ama hen anchi imfafaggà way idchatna an chàyu way yachi hen anchi Espirituna way empopostana. ");
INSERT INTO blw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Te ah Juan, finunyagan chàyu ah chanum, ngém achi mafayagat ifunyag Apudyus hen Espirituna an chàyu way yachi hen umaliyana way mìyachar an chàyu.” ");
INSERT INTO blw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Angkay hiyachi way kasencha na-among, inimoh hen anchichay aposel Jesus an hiya way mangaliyén, “Apo, ay faén ad uwan hen tempon hen ma-afa-an hen anchichay eRoma way chan toray an chitaaw way Judio ta egadtaaw way mangentoray hen antoy lotataaw.” ");
INSERT INTO blw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yag sommongfat ah Jesus way mangaliyén, “Ah Amataaw way Apudyus yanggay hen nangi-ila no kamana hen umchahan hen heno way ammaana te achi mepaka-ammu cha nadchi an chàyu. ");
INSERT INTO blw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ngém innilayu amin hen enammaà ya hen intudtuchù, wat no mìyachar hen Espiritun Apudyus an chàyu, yachi hen mangidchatana hen chakaray kafaelanyu way manàchég an haén. Wat yachi hen itudtuchuyu hen tatagu ahtod Jerusalem inggana hen aminay sakopon hen Judea ya Samaria, ya ingganah péppég hen lota.” ");
INSERT INTO blw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Angkay narpaschi way enalen Jesus yag ammag cha matarokat agé way éméy ad uchu hen nangi-il-ancha an hiya ingganah nalengfan hen funat. ");
INSERT INTO blw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yachi way é-éttégcha way nantatangad way mangi-ila hen émméyana, ammag niyahad hen chuway anghel way nètatàchég an chicha way nanlurumfong ah pokkawan, ");
INSERT INTO blw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","yag ekatchéén, “Chàyu way iGalilea, pakay an-ayug mantatangad way mangi-ila ad uchu, te ah Jesusanna way anat émméy ad uchu wat mamfangad chillu ah tapen chi ag-agaw. Te hen annay enkamanna way lommayaw, yaha agé hen ekamanna way mamfangad.” ");
INSERT INTO blw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Angkay hiyachi yag lommayawcha hen anchichay Aposel hen anchi filig way Olivo yag namfangadcha ad Jerusalem way ihay lometor hen ka-achawwéyna. ");
INSERT INTO blw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yag hen inumchahancha ad Jerusalem, émméycha hen anchi kowarto way ini-inggawancha way chicha cha Pedro an cha Juan an Jaime, ah Andres, ah Felipe yah Tomas, ah Bartolome, ah Mateo yah Jaime way anà Alfeo ya anat ah Simon way ekatchéén natorod yah Judas way anà hen anchi safaliy Jaime. ");
INSERT INTO blw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yag ammag kankanayén agé way cha mìyamoamong an chicha hen anchichay sosnod Jesus ya ah inana way Maria ya anat hen anchichay tapenay finufae way hen pontoscha amin way ma-among, ta incha manluwaru. ");
INSERT INTO blw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Angkay hen-argawan hen hiyachiy tempo way wacha ménat chi hinggasot ya chuwanporo hen anchichay na-a-among, tommàchég ah Pedro way mantudtuchu ");
INSERT INTO blw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","yag ekatnéén, “Sosnod, kapeletan way tomot-owa chillu hen anchi nesosorat way alen Apudyus ad namenghan way empahpahmà hen Espiritun Apudyus an David hen nangensoratana hen mekaman an Judas way hiya hen anchi nangetnod hen anchichay nanelew an Jesus. Yag na-ammaan tot-owa amin hen anchi nesosorat, ");
INSERT INTO blw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","te ah Judasanchi, hiya tot-owa hen iha an chitaaw way napele way mèamma agé hen fiyangantaaw way aposel. ");
INSERT INTO blw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ngém annag lenyad way mangamma hen laweng ah marabfuwana paat ah pelak. Yag hen na-awni, nelao hen anchi pelakanchi ah lota, yag ahchi agé hen namfit-arana ya nàchagana way ammag finumtà hen acharna yag nifùfù amin hen fagisna. ");
INSERT INTO blw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wat nanhemamagchi hen aminay tatagu ad Jerusalem wat ngenadnancha hen anchi lota ah Aceldama way hen laychénay aryénat ‘nachar-an way lota.’ ");
INSERT INTO blw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Te nesosorat chillu ad namenghan hen anchi libnu way kankanta mepanggép an Judas, ekatnéén, ‘Ta mapoh hen antoy tagu ya ta ammag fumaaw hen faréyna way maid inggaw.’ Ya hen ihay nesosorat agé, ekatnéén, ‘Ta wacha hen meparég an hiya way mamiyang hen fiyangna.’ ” ");
INSERT INTO blw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Entoroy Pedro way mangaliyén, “Wat gapo ta yachi hen nesosorat, masapor man-anaptaaw ah sokat Judas ta mètape an chitaaw way manàchég hen nan-uchiyan Apo Jesus. Masapor hiya hen ihay cha netnonetnod an chitaaw hen aminay kawad-an Apo Jesus nanepod hen namunyagan Juan hen tatagu ingganah namfangchan Jesus ad uchu.” ");
INSERT INTO blw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Angkay hiyachi, imfagacha hen ngachan hen chuway larae way cha Mateo ya anat ah Jose way hen agwan hen ngachanna, ah Barsabas way manJusto. ");
INSERT INTO blw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yachi yag anchaat manluwaru way mangaliyén, “Heay Apudyus way nangi-ila hen aminay hamhamà hen tatagu, epàilam an chàni no heno hen penepelem hen antoy chuwa ");
INSERT INTO blw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ah manokat an Judas way man-aposel te ah Judas, inyanggayana hen sa-adna yag émméy hen anchi aggaégyat way lugar way émméyana.” ");
INSERT INTO blw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Angkay narpas hen nanluwaruwancha yag namfunfunnotcha ah mangil-ancha no heno hen mapele, wat ah Mateo hen nafunotan way metape hen anchichay hemporo ya iha way aposel. ");
INSERT INTO blw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Angkay hiyachi way inumchah hen anchi lagsak way ekatchéén Pentecostes, na-amongcha amin hen anchichay cha omafurot hen ihay faréy. ");
INSERT INTO blw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yag hen hiyachi, wachaat agé hen ammag nan-uswar ad uchu way kaman séréd way fali, yag uray ah faréy way ini-inggawanchéén ammag chakar hen nagngarana. ");
INSERT INTO blw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Yachi yag wacha agé hen innilacha way kaman gilab chi apoy way niwa-at yag nènèchang an chicha amin. ");
INSERT INTO blw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yag hiyachiyat agé yag wéhchiyén iné-égnanan hen Espiritun Apudyus hen hamhamàna yag inlugicha amin way manginyale hen alen hen safaliy henlomota way egad hen inidchat hen Espiritun Apudyus an chicha. ");
INSERT INTO blw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hen hiyachiy tempo, wachacha agé hen anchichay Judio way ammag chakar hen hamhamàcha an Apudyus way fummabréy ad Jerusalem way maid achicha narpowan ah tapen chi lota wat nankarakarase agé hen alecha. ");
INSERT INTO blw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yachi way chengngarcha hen anchi chakar way nan-uswar, anchag enamongan hen anchi faréy way ini-inggawan hen anchichay cha omafurot an Jesus. Yag ancha amin ammag nascha-aw te wéhchiyén chana changrén hen anchi sigud way alena way cha iyalen peet hen anchichay cha omafurot. ");
INSERT INTO blw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wat anchag nahahaang way térén yag chachan ahetennopà way mangaliyén, “Pakay cha nahha. Ay ammoh faéncha iGalilea amin chaha. ");
INSERT INTO blw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Wat pakay wéhchin chitaawén chana chillu changrén hen anchi sigud paat way alena way chacha iyale. ");
INSERT INTO blw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Te chitaawat wacha ay narpod Partia yad Media, ad Elam yad Mesopotamia, ad Judea yad Capadocia, ad Ponto yad Asia. ");
INSERT INTO blw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ya wacha agé an chitaaw hen narpod Frigia, ad Pamfilia, ad Egipto ya anat agé hen tapena way narpo hen sakop Libia way nan-apet ad Cirene. Ya hen tapena an chitaaw agé narpod Roma ");
INSERT INTO blw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","way siguchay Judio hen tapena ya faén Judio hen tapena ngém incha tommepon hen anchichay Judio. Yag wachacha agé an chitaaw hen narpod Creta yad Arabia. Wat uray ammag nankarakarase hen narpowantaaw, wéhchiyén chana chillu changrén hen anchi siguchay alena hen antoy chacha manaphapetan hen anchichay kahahaang way enammaan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wat amin hen anchichay na-among, ancha amin ammag nahaang way térén, yag chachaat agé epegwa way man-ahetennopà way mangaliyén, “Nokay lawatoh cha ma-ammaan no henon laychénay aryén.” ");
INSERT INTO blw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ngém wachacha agé chillu hen tapena way cha mameloh an chicha way mangaliyén, “Ancha an nafutang lawa chaha.” ");
INSERT INTO blw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hen hiyachi, tommàchég ah Pedro way nètàchégcha agé hen anchichay hemporo ya ihay ifana way aposel, yag annaat chakarén way mangaliyén, “Chàyu way sosnod way Judio ya chàyu amin way ininggaw ahtod Jerusalem, iyalenangnangyu ta papannaagényu paat hen antoy aryê. ");
INSERT INTO blw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Te awni yag ekatyuwén an-ani an nafutang. Ngém cha-an-ani angkay te ay ammoh wachay mafutang ah anat an cha mà-argaw. ");
INSERT INTO blw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ngém na-ammaanto ah tommot-owaan hen imfafaggan hen anchi profeta way Joel ad namenghan hen nangimfag-ana hen alen Apudyus. ");
INSERT INTO blw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ekat Apudyusén, ‘Yato hen ammaà no umchah hen tempon hen anongoh hen ag-agaw, te an-og idchat hen Espiritù hen aminay tatagu hen antoy lota. Wat hen a-anàyu way larae ya fufae, epagngarcha hen epahpahmào an chicha. Ya hen anchichay finafallu, ilancha hen epàilà an chicha way kaman in-inép. Ya hen anchichay manakkorang, in-inpéncha agé hen epain-inép-o an chicha. ");
INSERT INTO blw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Te amin hen anchichay omma-abfurot an haén way larae man ono fufae, idchat-o hen Espiritù an chicha amin hen hiyachiy tempo ah mangempagngarancha hen epahpahmào an chicha.’ ");
INSERT INTO blw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ekat Apudyus agéén, ‘Epàilà hen kaskascha-aw ad uchu ya umat agé hen antoy lota way hen usarê way mangempàila an cha nadchi wat chara ya apoy ya pararo way asok. ");
INSERT INTO blw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yag ammag homelang hen init ya chumitak hen hérag way kaman chara yag anat umchah hen anchi omenpahaang ya omenpaégyat way ag-agaw way manguwisà hen aminay tatagu hen antoy lota. ");
INSERT INTO blw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ya umchah agé hen tempo way uray heno way tagu way manchawat an haén, wat hara-à hiya ah achina metap-aran.’ Yachi hen ensorat Joel ad namenghan.” ");
INSERT INTO blw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Yachi yag entoroy Pedro way man-ale, ekatnéén, “Chàyu way kacharaà way ganà Israel, papannaagényu koma hen antoy ifagà mepanggép an Jesus way eNazaret. Te tenàchégan Apudyus hiya way ad uchu tot-owa hen narpowana way hen manot-owaanyu te inidchat Apudyus hen kafaelana way mangamma hen anchichay omenpahaang way kaskascha-aw. Yag innilayu met way enammaana chachi tot-owa, te enammaana hen sangwanantaaw. ");
INSERT INTO blw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ngém ah Apudyus, ah tomoroyan hen hemhemmàna chillu way mekaman, wat emparufusna hen midchatan Jesus an chàyu hen nanelewanyu, wat chàyu hen nempapchit an hiya te inidchatyu hiya hen anchichay lawengay tatagu ta elansacha hen koros. ");
INSERT INTO blw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngém tàén natéy ah Jesus, nan-uchiyén Apudyus hiya chillu, wat annag enafà hen matéyan te achi mafalin way mepagud ah Jesus gapon natéyana. ");
INSERT INTO blw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yachi hen laychénay aryén hen anchi ensorat David ad namenghan hen nangaryanéén, ‘Inni-ilà way wawà-acha ah Apudyus an haén way anà ammag achi iyang-anggayan, wat achiyà émég-égyat ah uray heno way mepasamak. ");
INSERT INTO blw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wat anà ammag laylayad gapon hiyachi, ya karaylayad agé hen chà iyale, te tàén matéyà, sigurachuwà way kasenà chillu matagu. ");
INSERT INTO blw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Te innilà, Amay Apudyus, way achiyà iyanggayan an hea ad Hades way kawad-an hen natéy, ya achim agé eparufus hen mabruan hen achar-o, te haén, a-abfurotò hea. ");
INSERT INTO blw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yag sigud way empaka-ammum an haén way matattaguwà ah ing-inggana. Yag gapo ta wawà-acha-a an haén, pararo hen laylayad-o.’ Yaha hen ensorat David ad namenghan.” ");
INSERT INTO blw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yachi yag entoroy Pedro way mangensoplekar, ekatnéén, “Sosnod, iyam-ammà way mangimfaga mepanggép hen ensorat apotaaw way David, te ilanyu ngén, tàén yachi hen ensoratna, faén chillu acharna hen anchi inyalena, te natéy met ah David yag nilufù ad namenghan wat étég hen anchi lufùna inggana ad uwan. ");
INSERT INTO blw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ngém ah David, profeta way cha mangempacha-an hen mekaman ah pegwana wat annag iné-égnanan hen anchi empostan Apudyus an hiya, te ensapatan Apudyus an hiya way ah tapen chi ag-agaw, wacha hen ganàna way mantoray way kaman agé hen kenatorayna. ");
INSERT INTO blw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wat na-awatan David way man-uchi hen anchi epalen Apudyus way mantoray wat yachi hen nangaryana hen anchi enalena way achi miyanggayan hen Cristu ad Hades way kawad-an hen natéy, ya achi agé mabrù hen acharna. ");
INSERT INTO blw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wat hamham-ényu ngén,” way ekat Pedro, “te hen annay tagu way enalen David, hiya angkay ah Jesus way nan-uchiyén Apudyus. Yag tàchéganni amin way nan-uchi tot-owa, te inni-ilan paat hen matani. ");
INSERT INTO blw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yag ad uwan, empangaton Apudyus ah Jesus way i tummùchu hen pachawananna, yag enawat agé Jesus hen anchi empopostan Amana way Apudyus way Espirituna. Wat hen antoy cha ma-ammaan ad uwan way chayu ilan ya chayu changrén, yato hen nangidchatan Jesus hen anchi Espiritun Apudyus an chàni. ");
INSERT INTO blw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yag mepanggép hen anchi i tummùchu hen pachawanan Apudyus ad uchu, tàén ah David hen nangale, faén chillu acharna hen enalena, te enalenachi mepanggép an Jesus, ekatnéén, ‘Imfagan Apudyus hen anchi ap-apò way pangatowéna hiya way i tumutùchu hen pachawananna ");
INSERT INTO blw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ingganah epa-afà Apudyus way térén hen aminay kafusorna.’ ” ");
INSERT INTO blw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Wat hiyachi,” way ekat Pedro, “amin-ayu way sosnod way Judio, masapor ma-awatanyu koma way ah Jesusanchi way enkorosyu, hiya angkay tot-owa hen anchi Cristu way empopostan Apudyus ad namenghan way umale, yag hiya hen piniyarna way man-ap-apon hen aminay egad.” ");
INSERT INTO blw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hen nangngaran hen anchichay na-a-among way tatagu hen aminay enalen Pedro, ammag nachoot hen hamhamàcha yag chachaat hanhanan an Pedro ya hen anchichay tapenay aposel way mangaliyén, “Wat nokay hen én-énnénni nò.” ");
INSERT INTO blw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yag anat ekat Pedrowén, “Wéhchin chàyuwén masapor manchùgana hen anchi lawengay a-ammana ya anat mampafunyag ah mangafunana way ah Jesu Cristu hen omapowana, wat pakawanén Apudyus hen fasoryu yag idchatna hen Espirituna agé an chàyu, ");
INSERT INTO blw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","te yaha chillu hen empopostan Amataaw way Apudyus way idchatna an chitaaw way Judio ya hen ganàtaaw ya uray hen anchichay anachawwéy way tatagu, te idchatna hen Espirituna hen aminay tatagu way penelena way omafurot.” ");
INSERT INTO blw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Chuar hen imfagan Pedro hen nanginyam-ammaana way nangensoplekar hen anchichay na-a-among, yag intugunna agé an chicha way mangaliyén, “Afurotonyuto ta ilisiyanyu hen kachusaan hen anchichay lawengay tatagu.” ");
INSERT INTO blw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yachi yag anchag chuar hen anchichay nangafurot hen imfagan Pedro, yag anchaat mampafunyag hen hiyachiy ag-agaw, wat émméy ah toronlifu hen anchichay netape hen anchichay omma-abfurot an Jesus. ");
INSERT INTO blw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yag empapatecha way mangachar hen intudtuchun hen anchichay aposel, yag nètempoyugcha hen anchichay cha omafurot way cha i mìluwaluwaru ya nan-ahe-è-èancha hen manmanma-ancha hen natéyan Jesus. ");
INSERT INTO blw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hen yachiy tempo, chuar hen cha enammaan hen anchichay aposel way kaskascha-aw ya sinyar, wat nahahaangcha hen aminay tatagu. ");
INSERT INTO blw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ya amin hen anchichay cha omafurot, anchag nantetempoyugun hen hamhamàcha, wat hen kok-owan hen ihéén kok-owacha amin. ");
INSERT INTO blw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Te no elaocha hen lotacha ya kok-owacha, wat anchag iwaras hen laona hen aminay ifacha way egad hen masaporcha. ");
INSERT INTO blw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yag enag-agaw agéén chacha ma-amoamong ah Templo way manayaw an Apudyus. Yag chacha agé man-ahe-è-èan ah afarfaryancha te ammay hen hamhamàcha ya pararo hen laylayadcha, ");
INSERT INTO blw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ya chacha amin chayachayawén ah Apudyus. Yag hen anchichay tapenay tatagu, chacha agé rispituwén chicha. Yag enag-agaw agéén wachacha hen anchichay cha mahara-an way cha etapetapen Apudyus an chicha. ");
INSERT INTO blw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Angkay hen-argawan way fummatangan, cha mane-ed cha Pedro an Juan way éméy ah Templo way i mìluwaru, te yachi chillu hen tempon hen manluwaruwan. ");
INSERT INTO blw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yag hen hiyachi, wacha agé hen ihay am-ama way nisissigud hen penelayna wat achi makacharan. Wat enag-agaw way cha iyéy hen tatagu hiya hen iggaw hen anchi chakaray hawang hen Templo way ekatcheen “ka-ammayan way hawang,” way yachin annag tumutuchuwan way chan pap-alemmos hen anchichay cha hénggép. ");
INSERT INTO blw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Angkay hiyachi way innilana cha Pedro an Juan way cha hénggép ah Templo, chan ochaw ah eka-asecha an hiya. ");
INSERT INTO blw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ngém chicha, anchag finéfétég hiya yag anat ekat Pedrowén, “Ilam ngén chàni.” ");
INSERT INTO blw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yachi yag finétégna te wachan namnamana way wachan idchatcha an hiya. ");
INSERT INTO blw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ngém ekat Pedrowén, “Maid tot-owa pelakni, ngém hen wacha an chàni, yachi hen etorongni an hea. Wat gapo hen kafaelan Jesu Cristu way eNazaret, hen ifagani an hea, ta maka-an hen annay penelayno, wat tomàchég-a yag nanaran-aat.” ");
INSERT INTO blw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yag anat égnan Pedro hen awanay limana way mempatàchég, yag ammagat agég pommegsa hen he-en hen anchi nappelay ");
INSERT INTO blw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","wat ammag lommagtò way tomàchég yag nanaranat, yag anat mì-ighép ah Templo way chan teptepor ya chan lagragtò way manayaw an Apudyus. ");
INSERT INTO blw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yag amin hen anchichay tatagu ah Templo, innilacha hiya way cha manaran ya cha manayaw an Apudyus. ");
INSERT INTO blw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Yag hen nangenlasinancha way hiya peet hen anchi nappelay way palemmos way tummùtchu hen anchi ka-ammayan way hawang hen Templo, anchag nahahaangay térén gapo hen anchi na-ammaan an hiya. ");
INSERT INTO blw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Angkay hiyachi way ammag pommapaud hen anchi nappelay an cha Pedro an Juan ah layadna, anchag hetatagtag hen anchichay chuaray tatagu ah haangcha way i mangamong an chicha hen anchi chakaray fangsar hen Templo way ekatchéén “fangsar Solomon.” ");
INSERT INTO blw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Yag hen nangil-an Pedro hen chacha mangamongan an chicha, annaat ekaten, “Sosnod way ganà Israel, pakay mahahaang-ayu mepanggép hen antoy na-ammaan. Ya pakay anyug féféttékgén chàni. Ay ammoh ekatyuwén hen kafaelanni hen nanga-an hen penelay hen antoy tagu ono gapoh kaenammayni. ");
INSERT INTO blw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Faén, te ah Apudyus hen nanga-an way hiya hen chinayaw hen anap-otaaw way cha Abraham an Isaac yah Jacob ya amin hen anchichay tapenay anap-otaaw ad namenghan. Yag ad uwan, kena-anna hen penelay hen taguwanto ah mangil-anyu hen kena-apudyus hen anàna way Jesus. Ngém chàyu, anyug empatelew hen hiyachiy anana hen anchichay o-okom yag incheremyu an Pilato, yag tàén ekat Pilatowén laychéna way mangemparufus, an-ayug ommachi way iggay mangimfilang an hiya. ");
INSERT INTO blw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Wat tàén ammag ammay way tagu ah Jesus way maid poros fasorna, anyug iggay chillu mangiggéén te hen ihaat agéy pommatéy hen lenyadyu way meparufus. ");
INSERT INTO blw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wat anyug empapchit hen anchi pongar hen mannanayun way ataguwan ngkm nan-uchiyén Apudyus chillu hiya. Yag chàni, tàchéganni way tot-owa amin chato te innilan paat hen matani hiya hen nan-uchiyana. ");
INSERT INTO blw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Wat hen antoy nappelay way chayu ilan way enlasinyu chillu, naka-an hen penelayna yag ommorhe gapo hen kafaelan Jesus, wat amin way anyuwat innila way nekaman hen sangwananyu, na-ammaan yanggay gap0 ta chani manokchun ah Jesus, ya chani agé manchinlan hen kafaelana.” ");
INSERT INTO blw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ngém sosnod, innilani met chillu way amin way enammaanyu an Jesus ya umat agé hen enammaan hen anchichay anap-otaaw, enammaanyu amin chachi yanggay gapo ta iggayyu enlasin way hiya peet hen anchi empalen Apudyus. ");
INSERT INTO blw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yag imfafaggan Apudyus chillu ad namenghan way empaka-ammun hen anchichay profetana way masapor mapap-aligatan ya mepapchit hen anchi epalena way Cristu. Wat hen enkamanyu, yachi hen tommot-owaan hen anchi imfagan Apudyus. r ");
INSERT INTO blw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Wat ad uwan, masapor mamfafawiayu ya manhagong-ayu an Apudyus ta pakawanena hen fasoryu. Yag no yachi agé, ");
INSERT INTO blw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","papegséén Apudyus hen hamhamàyu, yag kasenna agé chillu epale ah Jesus te hiya chillu hen anchi chinuchuttokana way mantoray an chitaaw. ");
INSERT INTO blw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ngém masapor i-inggaw ah Jesus ad uchu ingganah umchah hen anchi tempon hen manginyam-ammaan Apudyus hen egad way yachi chillu hen empasorat Apudyus ad namenghan hen anchichay profeta. ");
INSERT INTO blw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Te hen ensorat apotaaw way Moses ad namenghan ekatnéén, ‘Ah pegwana, epalen Apotaaw way Apudyus hen ihay profeta way kaman an haén way hiya hen kacharaanyu way Judio. Yag masapor afurotonyu paat hen aminay ifagana. ");
INSERT INTO blw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yag heno way tagu way annag achi afuroton hen ifagan hen hiyachiy profeta way epalen Apudyus, ammag mesena hen tatagun Apudyus yag netap-ar.’ Yachi hen ensorat Moses.” ");
INSERT INTO blw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yachi yag entoroy Pedro agé way mangaliyén, “Amin hen anchichay profeta ad namenghan, nanepod an Samuel inggana hen amin anchichay cha nan-eppaepparég way profeta, imfafaggacha amin way ma-ammaan hen antochay cha ma-ammaan ad uwan. ");
INSERT INTO blw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yag amin way empopostan Apudyus way ensorat hen anchichay profetana, nepoposta chachi amin an chitaaw way ganàcha. Wat chitaaw, meawataaw hen entorag Apudyus hen anchichay anap-otaaw ad namenghan, kaman hen anchi imfagana an Apo Abraham. Te hen imfagana an Abraham, ekatnéén, ‘Hen ganano, hen mepàwaan hen torong-o hen egachay tatagu hen antoy lota.’ ");
INSERT INTO blw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Wat yaha, chitaaw way Judio hen pés-éy nempaliyan Apudyus hen anàna way Jesus ah matorongantaaw ya ah mabindisyunantaaw ta manchùgantaaw hen chataaw ammaan way laweng.” ");
INSERT INTO blw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Angkay hiyachi way é-éttég cha Pedro an Juan way chan tudtuchu hen anchichay tatagu. inumchahchaat hen tapenay papachi ya Saduceo ya anat hen anchi ap-apon hen guwarcha ah Templo. ");
INSERT INTO blw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yag anchag ommaningarngar an cha Pedro te chacha itudtuchu way nan-uchi ah Jesus way yachi ano agé hen manot-owaan hen man-uchiyan hen aminay natéy ah pegwana. ");
INSERT INTO blw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Wat anchag tenelew chicha, yag gapo ta cha madhém, imfarudcha chicha ingganah mawakas ta anchaat ano ichéreé. ");
INSERT INTO blw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ngém uray hiyachi hen nekaman, chuar chillu hen ommafurot hen anchichay nanangngar hen intudtuchun cha Pedro mepanggép an Jesus. Wat hen filang hen anchichay larae yanggay way ommafurot wat émméychah lemanlifu. ");
INSERT INTO blw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Angkay nawakas, na-amongcha ad Jerusalem hen anchichay anap-apon hen Judio ya anam-ama way ponò ya anat hen anchichay siguchay cha mintudtuchu hen orchin Moses. ");
INSERT INTO blw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Yag nìya-among agé hen anchi kangatowanay pachi way ah Annas ya anat agé hen anchichay ahimfafaryanna way cha Caifas an Juan yah Alejandro ya hen anchichay tapenay ahimfafaryanna agé. ");
INSERT INTO blw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yachi yag empa-ayagcha cha Pedro an Juan yag empasangocha way mamistigar way mangaliyén, “Heno ay paat hen nangchat hen kafaelanyu way mangamma hen anchi enammaanyu, yag heno ay paat agé hen nangchat hen lébféngyu way mangamma.” ");
INSERT INTO blw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yachi yag sommongfat ah Pedro way iné-égnanan hen Espiritun Apudyus hen hamhamàna yag ekatnéén, “Chàyu way anap-apo ya anam-ama way ponò, ");
INSERT INTO blw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ay hen chayu mamistigaran an chàniyat gapo hen natorongan hen anchi nappelay ya hen naka-anan hen penelayna. ");
INSERT INTO blw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Te no yachi, ma-awatanyu amin koma, ya ma-awatan koma agé hen aminay tapen hen sosnodtaaw way ganà Israel way gapo hen kafaelan Jesu Cristu way eNazaret, wat yachi hen naka-anan hen penelay hen annay tagu way tommatàchéganna hen henagongyu. Te ah jesusanchi, hiya hen anchi emparansayu hen nangempapchitanyu. Ngém nan-uchiyén Apudyus hiya chillu. ");
INSERT INTO blw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ya hiya agé hen niyaligan hen anchi nesosorat way enalen Apudyus way ekatnéén, ‘Hen anchi fato way enachin hen anchichay chan sà-ad ah faréy way ekatchéén maid sérfina, ammag hiyachiyat agé peet hen anchi kapatpatigan way mepégnad.’ ");
INSERT INTO blw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yaha hen nesosorat, wat maid paat kasen makaharà an chitaaw no faén yanggay hiya, te maid kasen empalen Apudyus hen antoy aminay lota ah makafael way manarà hen tatagu ah achicha metap-aran no faén yanggay ah Jesus.” ");
INSERT INTO blw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Amin hen anchichay o-okom way konsel, anchag nahahaang way nangila hen kenatorod cha Pedro an Juan, yag kaskasen hen nangawatancha way maid sa-adcha ya iggaycha amin nan-us-uswila, wat yachi hen nangenlasinancha way chicha peet hen cha netnonetnod an Jesus. ");
INSERT INTO blw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wat ammag netopò hen cha aryén hen anchichay konsel way maid kasencha minchur-ayan te wacha agéhchi hen anchi nappelay way nètatàchég an cha Pedro way naka-an hen penelayna. ");
INSERT INTO blw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wat hen enkamancha, empaghadcha cha Pedro an Juan ya hen anchi anat naka-an hen penelayna, yag anchaat man-ahetoptopà way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nokay ngata hen ekamantaaw an chicha nò, te nanchinngar met hen aminay tatagu ahtod Jerusalem hen anchi enammaancha way kaskascha-aw, wat achi tot-owa mafalin way mahootan. ");
INSERT INTO blw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wat hen ekamantaaw, ta achi koma komaskasen hen mahaphapetan hen anchi nekaman, antaaw ammag warnengén chicha ta achicha kasen epegpegwa way mangale hen ngachan Jesus hen uray heno way tatagu.” ");
INSERT INTO blw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Angkay hiyachi yag kasencha empa-ayag chicha yag imfagacha way masapor etagaycha paat way mangintudtuchu mepanggép an Jesus, ya achicha agé paat cha ar-aryén uray hen ngachanna. ");
INSERT INTO blw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ngém senongfatan cha Pedro an Juan chicha way mangaliyen, “Oo a, ngém ifagayu kaỳ no heno hen laychén Apudyus, ay laychénay afurotonni chàyu ono hiya hen afurotonni. ");
INSERT INTO blw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Te achi angkay mafalin way etmégni hen innilan hen matani ya hen chengngarni mepanggép an Jesus.” ");
INSERT INTO blw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yachi yag enkaskasen hen anchi konsel way manéngténg an chicha ta iginangcha yag anchaat eparufus, te achicha maka-anap ah ustoy lason ah manusaancha an chicha, te amin hen anchichay na-among way tatagu, chacha amin chayawén ah Apudyus gapo hen anchi na-ammaan. ");
INSERT INTO blw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yag hen anchi tagu way nappelay way nanepod hen nataguwana ingganan naka-anan hen penelayna, nasorok ah opatporo hen tawénna. ");
INSERT INTO blw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Angkay hiyachi way neparufus cha Pedro an Juan. namfangadcha hen anchichay ifacha, yag henaphapetcha amin hen imfagan hen anchichay anap-apon hen pachi ya anam-ama way ponò. ");
INSERT INTO blw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wat hen nangngaran hen anchichay cha omafurot hen henaphapet cha Pedro, émméhà-an hen hamhamàcha way manluwaru way mangaliyén, “Heay Apudyus way Aponi, hea hen nangamma hen egachay wacha ad uchu ya hen antoy lota ya hen fayfay, ya amin way ininggaw. ");
INSERT INTO blw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ya hen Espiritum hen nangempahpahmà hen anchi omma-abfurot an hea way Aponi way David hen nangaryanéén, ‘Pakay hen anchichay faén Judio way anchag oma-anningarngar, ya umat agé hen anchichay Judio way anchag manchinar way komontara an Apudyus ah maid kawanwanina. ");
INSERT INTO blw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ya hen anchichay a-are hen antoy lota age, nansasagganacha, wat nètetempoyugcha amin hen anchichay toray te hen ekatcha, afaéncha koma ah Apudyus ya hen anchi Cristu way empalena way mantoray.’ ");
INSERT INTO blw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Amani way Apudyus, tommot-owa hen anchi ensorat David ad namenghan te nìya-amongcha ahtod Jerusalem cha Are Herod an Poncio Pilato yag netapecha hen anchichay faén Judio ya anat agé hen anchichay ahentaguni way Judio. Wat niya-amongcha amin way nètemfuruy way komontara an anàno way Jesus way maid fasfasorna way empalem hen antoy lota way mantoray. ");
INSERT INTO blw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yag amin way ekatchéén ammaancha, yaha peet hen imfafaggam way ma-ammaan, te yaha hen hehemmàno chillu. ");
INSERT INTO blw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wat ad uwan, heay Apudyus way Aponi, changrém hen annay chacha iyég-égyat an chàni, yag idchatno an chàni way chan sérfi an hea hen kaskasen way torodni way mangintudtuchu hen alem. ");
INSERT INTO blw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yag epàilam hen kafaelam way manga-an hen saket, ya ammaam agé hen kaskascha-aw hen mangimfag-anni hen torong hen anchi mannakafael way anàno way Jesu Cristu way maid fasfasorna.” ");
INSERT INTO blw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Angkay hen hiyachi way narpas hen nanluwaruwancha, ammag nanyuhawat agé hen anchi faréy way na-a-ammongancha, yag inégnanan hen Espiritun Apudyus hen hamhamàcha wat anchag tommorod tot-owa way mangimfaga hen alen Apudyus way maid ég-égyatcha. ");
INSERT INTO blw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Angkay hiyachi, amin hen anchichay cha omafurot an Jesus, ammag napapchong hen hamhamàcha amin way maid iha ah mangaliyén awana yanggay hen kok-owana te anchag awa amin. ");
INSERT INTO blw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ya hen anchichay aposel agé, inidchat Apudyus hen chakaray kafaelancha way manàchég hen anchi nan-uchiyan Apo Jesus. Yag amincha, henahallimunan Apudyus chicha amin. ");
INSERT INTO blw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yag maid agé cha makok-orangan ah iha an chicha gapo ah masapor, te hen anchichay wacha hen lotana ya faréyna, elaocha ayén inidchatcha hen laona ");
INSERT INTO blw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","hen anchichay aposel. Yag hen anchichay aposel agé, chacha epayàchang hen hiyachiy torong hen heno way makasapor an chicha. ");
INSERT INTO blw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Wacha hen ihay tagu way a h Jose hen ngachanna way niyanà ad Chipre way hiya hen ihay ganà Levi, yag ngenadnan hen anchichay aposel hiya ah Bernabe way hen laychénay aryén, “omenpas-ém.” ");
INSERT INTO blw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Te ah Joseyanto, enlaona hen ihay lotana yag emporangna hen aminay laona hen anchichay aposel. ");
INSERT INTO blw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Yag hen hiyachi, wacha agé hen ihay tagu way ah Ananias hen ngachanna ya anat ah Safira way ahawana way nangenlao hen tapen hen lotacha. ");
INSERT INTO blw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ngém cha Ananias, nantempoyugancha way hen-ahawa way mangenhoot hen tapen hen laona, yag anchaat iyéy hen anchi tapena hen anchichay aposel way yachi yanggay ano hen laon hen lotacha. ");
INSERT INTO blw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ngém ekat Pedro an hiyéén, “Pakay emparufusno ah Chumunyu way mangawis hen hamhamàno ah mangétkétmam hen Espiritun Apudyus way mangenhoot hen tapen hen laon hen anchi lotayu. ");
INSERT INTO blw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Te kok-owayu met hen anchi lotayu ya anyuwat elao. Yag yachi way nelao, pelakyu chillu hen anchi laona. Wat pakay im ehoot hen anchi tot-oway laona nò way pakay yaha hen hemhemmàno ah ammaam. Te faén angkay tatagu hen nankétmam te ah Apudyus.” ");
INSERT INTO blw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yag hen nangngaran Ananias hen anchi enalen Pedro, ammag narangad yag natéy. Wat ammag pararo hen égyat amin hen anchichay tatagu way nangngar hen na-ammaan. ");
INSERT INTO blw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yachi yag hinénggépcha hen anchichay finafallu way i mangara hen anchi natéy yag finunifunancha yag anchaat i ilufù. ");
INSERT INTO blw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Angkay nanlooh hen toroy uras ménat yag hinénggép ah Safira way ahawan hen anchi natéy way cha-anna ma-ammuwan hen na-ammaan an ahawana. ");
INSERT INTO blw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yag ekat Pedro an hiyéén, “Ay anggay yanggayto hen enawatyu way laon hen anchi lotayu.” “Oo, anggayha hen laona,” way ekatna. ");
INSERT INTO blw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yag anat ekat Pedrowén, “Pakay inyu nantempoyugan way hen-ahawa way mamadpachas way manlokop hen Espiritun Apudyus. Ilam ngén, annachayan way naway hen anchichay i nanginlufù an ahawam, wat icha-a angkay ilufù agé.” ");
INSERT INTO blw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yag chaat agé marangad way matéy. Angkay hiyachi way kasencha hinénggép hen anchichay finafallu, innilacha way natéy agé ah Safira, yag anchaat iyéy way i manginlufù hen anchi lufù ahawana. ");
INSERT INTO blw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wat amin hen anchichay cha omafurot ya anat agé hen amin anchichay tapena way cha nangngar, pararo hen égyatcha amin hen anchi na-ammaan. ");
INSERT INTO blw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hen hiyachiy tempo, ammag chuar hen kaskascha-aw way cha enammaan hen anchichay aposel ah mangil-an hen tatagu. Ya amin hen anchichay cha omafurot, chacha ma-amoamong hen anchi chakaray fangsar hen Templo way ekatchéén “fangsar Solomon.” ");
INSERT INTO blw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ngém hen anchichay tatagu way cha-an omafurot, tàén chacha rispituwén hen anchichay cha omafurot, émégyatcha chillu way miyahrang an chicha. ");
INSERT INTO blw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ngém chacha chillu matapyatapyan hen anchichay cha omafurot an Apo Jesus, wat chacha chumuachuar hen finufae ya lenarae. ");
INSERT INTO blw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yag gapo hen cha ammaan hen anchichay aposel, cha iyéy hen tatagu hen anchichay chan saket way mangempapabfég hen penget hen korsa ah mangi-ihhéchancha hen manlawhan Pedro. Te hen ekatcha, uray lawa ammag milichaw hen à-ahon Pedro wat maka-an hen saketcha. ");
INSERT INTO blw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yag ummalecha agé hen chuaray tatagu way narpo hen anchichay fabréy way sakopon hen Jerusalem way chacha agé inyale hen anchichay chan sasaket ah mangempaka-anancha hen saket ya ah mangempaparyawancha hen nihuhurug way ongtan. Wat amin way ummale, natorongancha amin. ");
INSERT INTO blw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Angkay hiyachi, hen anchi kangatowanay pachi ya anat hen amin anchichay ifana way ekatchéén Saduceo, ancha ammag cha ma-apés hen anchichay aposel, ");
INSERT INTO blw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","wat incha empatelew chicha yag imfarudcha. ");
INSERT INTO blw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ngém hen hiyachiy lafi, émméy hen ihay anghel Apudyus hen anchi pagfaruchan yag finùtana hen anchi hawang, yag annaat etnod hen anchichay aposel way lomayaw, yag annaat ifaga an chicha way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“In-ayu ta éméy-ayu ah Templo way i mangintudtuchu hen tataguhchi hen amin way mepanggép hen anchi mannanayun way ataguwan way marpon Jesu Cristu.” ");
INSERT INTO blw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yachi yag enafurot hen anchichay aposel hen nifaga an chicha. Wat yachi way pommaway, émméycha ah Templo yag inlugicha way mantudtuchu. Angkay hiyachi agé, hen anchi kangatowanay pachi ya hen anchichay ifana, empa-ayagcha amin hen anchichay anam-ama way ponò hen Judio way ekatchéén konsel, yag anchaat i epa-ara hen anchichay farud way aposel ah pagfaruchan ta uwiséncha koma chicha. ");
INSERT INTO blw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ngém hen émméyan hen anchichay i mangara an chicha, ammag maidchaat agé hen anchichay farud. Wat namfangadcha yag henaphapetcha hen anchichay konsel way mangaliyén, ");
INSERT INTO blw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hen inumchahanni ah pagfaruchan, ammag nau-umfan met ya natotorfekan agé hen anchi hawangna ya wawà-achacha amin hen anchichay chan guwarcha, ngém yachi way finùtanni, ammag maid eng-engngawan chi tagu ah pagfaruchan.” ");
INSERT INTO blw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Hen nangngaran hen anchichay anap-apon hen papachi ya hen anchi ap-apon hen guwarcha hen Templo hen yachiy na-ammaan, anchag cha anapén ah hamhamàcha no heno kay hen émméyan hen anchichay nifafarud. ");
INSERT INTO blw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Yag hen hiyachi, inumchahat hen ihay tagu yag imfagana way mangaliyén, “Wachacha angkay ah Templo hen anchichay tatagu way imfarudyu way chacha tudtuchuwan hen anchichay cha ma-among way tatagu ahchi.” ");
INSERT INTO blw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wat hiyachi yag enayagan hen anchi ap-apon hen guwarcha hen anchichay ifana yag incha kasen innara hen anchichay aposel. Ngém inyam-ammacha way nangara an chicha, te chacha émégyat hen anchichay tatagu, te awni yag wachay ma-akar yag finuntòcha chicha. ");
INSERT INTO blw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Angkay hiyachi way inighépcha hen anchichay aposel way mangempasango hen anchichay konsel, inlugin hen anchi kangatowanay pachi way mamistigar an chicha, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Apay henon chayu amma-ammaananna way anni met ammag tenlén paat way mangempawa hen mangintudtuchuwanyu hen mepanggép hen anchi taguwanchi yag chayuwat agé ichaggat ingganah nanchinngar amin ahtod Jerusalem. Ya am-améd te chayu chagtén way mangaliyén chàniyat agé hen nangempapchit an hiya.” ");
INSERT INTO blw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Yachi yag sommongfat ah Pedro ya hen anchichay ifana way aposel way mangaliyén, “Masapor afurotonni chillu hen laychén Apudyus, tàén faénchi hen laychén hen tatagu. ");
INSERT INTO blw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Te ah Apudyus way chinayaw hen anchichay anap-otaaw ad namenghan, nan-uchiyéna angkay ah Jesus way empapchityu hen nangemparansaanyu hen koros. ");
INSERT INTO blw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ngém empangaton Apudyus hiya way i nichapat ah pachawananna ad uchu way ah Jesusanchi, hiya hen ap-apo ya omenharà. Enammaan Apudyus amin chaha ah mawayaantaaw way ganà Israel way mamfafawi ah mapakawanan hen fasortaaw. ");
INSERT INTO blw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yag chàni way aposel, tàchéganni hen katot-owan amin chachi way yachi agé hen afunan hen Espiritun Apudyus, way hen Espirituna, hiya hen idchat Apudyus way mìyachar hen heno way omafurot an hiya.” ");
INSERT INTO blw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Angkay hen nangngaran hen anchichay konsel hen enalen cha Pedro, anchag ommaningarngar way térén wat maid kasen mamosposancha no achicha an pédtén chicha. ");
INSERT INTO blw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ngém hen hiyachi, wachan iha an chicha way ah Gamaliel hen ngachanna. Fariseo ah Gamaliel way ihay siguchay cha mintudtuchu hen orchin Moses, ya ririspituwén hen aminay tatagu hiya. Yachi yag tommàchég ah Gamaliel yag imfagana way mepaghadcha hen anchichay aposel te wachan ifagana hen anchichay ifana way nan-angato. ");
INSERT INTO blw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Angkay nighadcha hen anchichay aposel, yag anat mantugun ah Gamaliel way mangaliyén, “Sosnod-o way ganà Israel, masapor angkay ar-arwachantaaw hen chataaw ekaman hen annachay tatagu. ");
INSERT INTO blw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ta paniyê hen inummat. Hamham-ényu ngén hen anchi ar-argaw way wachan fummùnag way ihay tagu way ah Teudas hen ngachanna. Yag ah Teudasanchi, emparangna hen acharna ah nangato wat sommorotcha an hiya hen opatgasot way tatagu. Ngém yachi way na-awni, ammag napchit ah Teudas yag anchag nawawan amin hen anchichay pasorotna, wat ammag maid tommoroyan nadchi. ");
INSERT INTO blw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Angkay narpas agéchi, yag fummùnag agé ah Judas way iGalilea hen tempon hen nepalestaan hen tatagu. Yag ah Judas agé, enawisna hen anchichay tatagu way sommorot an hiya agé. Ngém angkay na-awni yag napchit agé, wat niwaràcha amin agé hen anchichay pasorotna. ");
INSERT INTO blw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Wat hiyachi, hen itugun-o an chitaaw, yassa ud-ay ta uray maid ammaantaaw an chicha ta egadcha. Te no an yanggay hamhamà hen tatagu hen narpowan hen anchi chacha ammaan ya chacha itudtuchu, kapeletan way maumah way achi metoroy. ");
INSERT INTO blw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ngém no ngay ah Apudyus tot-owa hen narpowana, achitaaw angkay chillu maka-afà an chicha te ammoh wachay mangontara an Apudyus.” Angkay hiyachi way enafunan hen anchichay konsel hen tugun Gamaliel, ");
INSERT INTO blw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","yag anchaat epa-ayag hen anchichay aposel yag empahapratcha yag anchaat térnén way mangempawa hen kasencha mangintudtuchuwan hen mepanggép an Jesus, yag anchaat eparufus chicha. ");
INSERT INTO blw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yag hen anchichay aposel, ammag amchan hen laylayadcha hen lommayawancha hen anchichay konsel te imfilang Apudyus chicha ah wachan karébféngan, way mapàgang gapon Jesus. ");
INSERT INTO blw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Wat entoroycha chillu way enag-agaw way cha émé-éméy ah Templo ya hen fafaréy hen tatagu way i mangintudtuchu hen anchi ammayay chamag mepanggép an Jesus way hiya, ummale hen antoy lota way mantoray. ");
INSERT INTO blw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Angkay hiyachi way chacha chumuar hen anchichay cha omafurot an Jesus, ammag narmu hen chacha mansosongelan, te hen nekaman, hen anchichay Judio way Griego hen alecha, chacha mè-esngel hen anchichay nachachà-an way Judio ad Jerusalem. Yag hen lilicha, ekatchéén cha miyang-anggayan ano hen anchichay ifacha way nà-amfaro hen cha miwarasan hen torong ah ka-arga-argaw. ");
INSERT INTO blw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Angkay hiyachi, nampametencha hen anchichay hemporo ya chuway aposel, yag enayagancha amin hen anchichay cha omafurot yag imfagacha way mangaliyén, “Achi koma mafalin way iyanggayanni way mangempagngar hen alen Apudyus ta hen manginwarasan hen torong hen atenglénni. ");
INSERT INTO blw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Wat hen ekamanyu sosnod, anyu komag chutokan hen pituy larae an chàyu way matalekyu way innilayu way iné-égnanan hen Espiritun Apudyus hen hamhamàna ya na-adchan agé ah kenaraeng, ta piyarénni chicha ta egadcha hen antoy problema, ");
INSERT INTO blw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ta chàni, hen manluwaru ya manginwarawag hen alen Apudyus hen ang-angpelénni.” ");
INSERT INTO blw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hiyachi yag enafunan amin hen anchichay cha omafurot hen imfagan hen anchichay aposel, wat chinutokancha hen anchi pitu way hen iha, ah Esteban way chinumgat way térén hen afurotna ya iné-égnanan hen Espiritun Apudyus hen hamhamàna. Ya hen anchichay tapena way chinutokancha agé, wat cha Felipe, Procoro, Nicanor, ah Timon, ah Parmenas ya anat ah Nicolas way iyAntiokia way faén Judio ngém an tommepon hen Judio. ");
INSERT INTO blw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yachi yag empasangon hen tatagu hen anchichay pitu hen anchichay aposel, yag hen anchichay aposel, inchàépcha hen limacha hen anchichay nachutokan way manginluwaru an chicha. ");
INSERT INTO blw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Angkay hiyachi way cha mepagngapagngar hen alen Apudyus, wat chacha agé chumuachuar hen anchichay cha omafurot ad Jerusalem way uray hen anchichay pachin hen Judiowén chuarcha agé hen ommafurot an Jesus. ");
INSERT INTO blw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Angkay hiyachi, ah Esteban, binindisyunan paat Apudyus hiya ya inidchatna hen kafaelana way mangamma hen kaskascha-aw hen chana manorongan hen tatagu. ");
INSERT INTO blw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ngém wachacha hen anchichay komontara an Esteban way chichachi hen anchichay Judio way achi mangafurot an Jesus way sommorot hen ihay semfa-an hen Judio way ekatchéén Libértin. Yag narpocha ah safaliy fabréy way eCirene hen tapena ya iyAlejandria hen tapena. Wat chicha ya anat agé hen tapen hen Judio way narpo hen provinsiyan hen Cilicia ya Asia, inlugicha way manngel an Esteban. ");
INSERT INTO blw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ngém anchag achi makasokok an hiya te inidchat hen Espiritun Apudyus hen kenaraengna way somongfat. ");
INSERT INTO blw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wat enaparancha hiya way incha penasoksokan hen tatagu ta ilémrémcha way mangaliyén, “Chengngarni angkay hen annay taguwanna way chana kontaréén ah Apudyus ya ah Moses way apotaaw.” ");
INSERT INTO blw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yachi yag ammag nasubsufan tot-owa hen hamhamà hen anchichay tatagu way nangngar, ya umat agé hen hamhamà hen anchichay anam-ama way ponò hen Judio ya hen anchichay siguchay cha mintudtuchu hen orchin Moses. Wat incha tenelew ah Esteban way i mangempasango hen anchi konsel. ");
INSERT INTO blw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yachi agé yag empa-ayagcha hen anchichay mangempafasor ah kétém, wat anchag namparang way mangaliyén, “Ammag achi somarcheng hen antoy tataguwanto way cha mangsomangsot hen anchi na-apudyusan way Templotaaw ya hen orchintaaw way ensorat Moses. ");
INSERT INTO blw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yag chengngarni agé hen anchi enalena way chaelén ano Jesus way eNazaret hen anchi Templotaaw ya falewana agé hen gagangaytaaw way intudtuchun Moses ad namenghan.” ");
INSERT INTO blw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yachi way enalechachi, yag ammag finéfétég hen anchichay konsel ah Esteban, ya chaat agé mamfalew hen féharna hen nangi-il-ancha, te ammag kommaman hen féhar hen anghel. ");
INSERT INTO blw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Angkay hiyachi yag ekat hen anchi kangatowan way pachi an Esteban way mangaliyén, “Ay tot-owa hen annay chacha epafasor an hea.” ");
INSERT INTO blw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yag anat somongfat ah Esteban way mangaliyén, “Chàyu way anap-apo ya sosnod, pangpanga-aseyu koma ta changrénà. Ad namenamenghan hen kawad-an hen apotaaw way Abraham ad Mesopotamia way cha-anna fumabréyan ad Haran, nampàila hen anchi machachayaw way Apudyus an hiya. ");
INSERT INTO blw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yag imfagana way mangaliyén, ‘Lomayaw-a, Abraham, ya taynam hen annachay totorangno ya hen annay lotam ta in-a fumabréy hen safaliy lota way itudtuchù an hea.’ ");
INSERT INTO blw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yachi yag lummigwat tot-owa cha Abraham yag tenaynancha hen anchi lotacha ad Caldeo way incha fummabréy ad Haran ingganah natéy ah amana. Yag angkay natéy ah amana, kasen imfagan Apudyus way kasencha man-aton, wat yachi hen ummaliyancha hen antoy lota way ini-inggawantaaw ad uwan. ");
INSERT INTO blw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Hen hiyachiy tempo, maid poros inidchat Apudyus an cha Abraham ah uray lawa aket hen antoy lota, te anna yanggay an emposta way man-awan Abraham ya hen anchichay ganàna hen amin antoy lota. Ngém hen anchi nangempostaan Apudyus an nadchi an Abraham, maid pay anàna. ");
INSERT INTO blw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ngém hen imfagan Apudyus an Abraham, ekatnéén, ‘Umchah hen tempo way mamfunagcha hen anchichay ganàno ah achawwéy way lota way awan hen safaliy tatagu. Wat anchag mamfalin ah alepan hen hiyachiy fabréy ya mapap-aligatancha ah opatgasot way tawén. ");
INSERT INTO blw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ngém hen karpasana, an-og uwisén hen anchichay mangen-alepan hen anchichay ganàno, wat yachi hen lomayawancha ahchi yag kasencha mamfangad hen antoy lota ta ahto chillu hen manayawancha an haén.’ ");
INSERT INTO blw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yaha hen imfagan Apudyus an Abraham, yag annaat ifaga agé way masapor mamarkaancha hen larae ah kasinyarancha way chacha afuroton hen anchi torag Apudyus an chicha. Yachi yag menarkaan tot-owa Abraham hen anchi anat niyanà way anàna way ah Isaac hen anchi ma-awaru way ag-agawna. Yag kaman agéhchi hen enkaman Isaac hen anchi anat niyanà way anàna way ah Jacob. Ya ah Jacob agé, yachi agé hen enkamanna way nanmarka hen anchichay hemporo ya chuway a-anàna way chichachi hen nanlapowantaaw.” ");
INSERT INTO blw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Entoroy Esteban way nangenpacharan hen chana aryén, ekatnéén, “Hen anchichay anap-otaaw way a-anà Jacob, gapo ta amchan hen apéscha hen anchi enawchicha way Jose, wat anchag enlao hiya ah para alepan hen anchichay iyEgipto. Ngém nawawà-acha ah Apudyus an Jose, ");
INSERT INTO blw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","yag henara-ana hiya hen aminay ligatna. Yag hen nepasangowana hen anchi Are ad Egipto, tenorongan Apudyus hiya yag inidchatna agé hen kenaraengna wat ammay hen enkamkamanna. Wat enlaychan Are hiya yag annaat chutokan hiya ah manggubérnador hen aminay fabréy ad Egipto, yag empafiyangna agé an hiya way mangi-ila hen aminay kok-owana.” ");
INSERT INTO blw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Angkay hen hiyachiy tempo, nabtel hen aminay lota ad Egipto ya umat agé ad Canaan way ininggawan hen anchichay anap-otaaw, wat napaligatancha way térén hen aminay tatagu hen hiyachiy tempo, yag ammag maid manòmonan hen anchichay anap-otaaw ah anéncha. ");
INSERT INTO blw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yachi yag chengngar apotaaw way Jacob way wacha peet hen ma-an ad Egipto wat empaligwatna hen a-anàna way i manòmon ahchi. Wat yachi hen anchi pés-éy émméyan hen anap-otaaw ad Egipto.” ");
INSERT INTO blw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Angkay hiyachi, hen anchi pegwan ayancha ad Egipto, empaka-ammun Jose hen acharna hen anchichay papangorowana te cha-ancha enlasin hiya. Wat yachi hen nangammuwan Are ad Egipto hen anchichay ahimfafaryan Jose. ");
INSERT INTO blw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yachi yag anat epa-ayag Jose ah amacha way Jacob ya hen sosnodna ya amin hen anchichay ahimfafaryancha, ta umalecha amin way fumabréy ad Egipto, wat émméycha ah pitunporo ya lemay tatagu amin. ");
INSERT INTO blw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yachi yag émméy cha Jacob tot-owa ad Egipto yag ahchi hen ini-inggawancha ingganah natéyancha. ");
INSERT INTO blw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yag no ay matéy hen anchichay anap-otaawén, imfangad hen a-anàcha hen acharcha ad Sikem way manginlufù way mangentape hen tongarcha hen anchi lufù way lenàwan hen apotaaw way Abraham ah kamanay pelak hen anchichay a-anà Hamor.” ");
INSERT INTO blw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Angkay hiyachi way tég-angay hen mangammaan Apudyus hen anchi empopostana an Abraham, anchag chummuar way térén hen anchichay ganàna way anap-otaaw ad Egipto. ");
INSERT INTO blw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yag hen hiyachiy tempo, tummùchu hen ihay Are way maid innilana hen mepanggép an Jose ad namenghan. ");
INSERT INTO blw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wat hiya, ammag nasilib hen aminay chana ekamkaman, yag anna agég èmehan hen anchichay anap-otaaw way annag penap-aligat chicha yag annaat peletén chicha way mangentap-ar hen anchichay anat niyanà way a-anàcha ta matéycha. ");
INSERT INTO blw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Yag hen hiyachiy tempo hen niyana-an Moses way ammag am-ammay way onga. Wat henalihalimunan hen chinàcha-arna hiya ah faréycha hen unig hen toroy furan, ");
INSERT INTO blw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","yag anchaat ighad way i mangentaro. Yag yachi hen nangchahan hen anchi anà Are way fafarasang an hiya, yag innarana, wat annag henalimunan ah nan-anàna. ");
INSERT INTO blw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yachi yag intudtuchucha an Moses hen aminay kenaraeng hen anchichay iyEgipto. Wat hen chummakrana, ammag hiyaat agé hen machayaw ad Egipto gapo hen kenaraengna way man-ale ya mangamma hen ammaana.” ");
INSERT INTO blw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Angkay hiyachi way opatporo hen tawén Moses, ekatnéén i mì-ib-ifun hen anchichay inib-ana way ganà Israel ta ilana no henon én-énnéncha. ");
INSERT INTO blw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yag innilanaat agé hen ihay ifana way cha paligatén hen ihay iyEgipto. Wat annag i henara-an yag imfarésna way namchit hen anchi iyEgipto. ");
INSERT INTO blw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Te hen ekat Moses ah hamhamàna, na-awatan chillu hen anchichay ifana way hiya hen chinutokan Apudyus way mangenharà an chicha amin. Ngém anchag iggay peet ma-awatan. ");
INSERT INTO blw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Te hen nawakas way inchahana hen chuway ifana way chan patéy, ekatnéén ina koma forchaén chicha. Wat ommamhew way mangaliyén, ‘Pakay chàyu way masosnod, way ammag yahaat agéy iyu ekaman.’ ");
INSERT INTO blw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ngém ammag achi maingar hen anchi lommapo, wat intùyudna ah Moses way mangaliyén, ‘Heno ay paat hen lébféngno way man-ap-apo ta hea paat hen mangempanoh an chàni. ");
INSERT INTO blw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ay anno agé pédtén haén kaman hen namchitam hen anchi iyEgipto ad ugga.’ ");
INSERT INTO blw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yag hen nangngaran Moses an nadchi, ammag émmégyat te na-ammuwan peet hen anchi enammaana, wat ommawid way nanaynan ad Egipto yag i fummabréy hen anchi achawwéy way lota ad Midian, yag ommahawa ahchi, wat chuwa hen anàna way pahig larae.” ");
INSERT INTO blw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Angkay hiyachi yag émméy ah opatporo way tawén hen ini-inggawan Moses ad Midian. Yag angkay hen-argawan, ammag niyahad hen anghel Apudyus an hiya hen chana manaranan hen anchi chanak way nehag-én hen anchi filig ad Sinai. Yag innilana hen ayéh-ép way away way ammag cha gumilab, yag wachaat agé hen anchi anghel way nanggagawa hen anchi apoy. ");
INSERT INTO blw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ammag nahahaang ah Moses hen nangil-ana wat i koma homag-én way mangenmamad, yag chengngarnaat agé ah Apudyus way nan-ale, yag ekatnéén, ");
INSERT INTO blw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Haén ah Apudyus way cha chayawén hen anap-om way cha Abraham an Isaac yah Jacob.’ Yag hen nangngaran Moses an nadchi, ammag nan-upop yag chan papayagpag ah égyatna. ");
INSERT INTO blw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yag anat kasen man-ale ah Apudyus way mangaliyén, ‘Ka-aném hen annay sapatosno te na-apudyusan angkay hen antoy lota way tommatàchégam te antoyanà.’ ");
INSERT INTO blw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yag annaat agé ifaga way mangaliyén, ‘Inni-ilà way ammag pararo way cha mapaligatan hen anchichay tatagù ahchid Egipto yag chengngar-o hen paràcha ya hen harahagcha yag ana-at umale way mangempaharà an chicha. Wat inta Moses ta epééy-o hea ad Egipto.’ Yaha hen imfagan Apudyus an Moses.” ");
INSERT INTO blw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yachi yag entoroy Esteban way manaphapet hen na-ammaan ad namenghan, ekatnéén, “Ah Mosesanchi, iggay mangiggéén hen anchichay anap-otaaw hiya, te anchag ekatén, ‘Heno man paat hen nangidchat ah man-ap-apowam an chàni ta hea paat hen i mangempanoh an chàni.’ Ngém ah katot-owana, ah Moses peet hen penelen Apudyus ah man-ap-apocha way manarà an chicha way tenorongan hen anchi anghel way nampàila hen gawan hen anchi ammag cha gumilafay away. ");
INSERT INTO blw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yachi yag enetnod Moses hen anchichay anap-otaaw hen lommayawancha ad Egipto, yag enammaana hen chuaray kaskascha-aw ahchid Egipto ya hen nangwaancha hen anchi fayfay way ekatchéén ‘Chittakan,’ ya anat agé hen unig hen anchi opatporo way tawén way nange-etnochana an chicha hen anchi pachinanak way lota. ");
INSERT INTO blw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yag ah Moses, hiya agé hen anchi nangintudtuchu hen anap-otaaw way ganà Israel way mangaliyén, ‘Ah pegwana, epafùnag Apudyus hen ihay profeta way ganàtaaw way kaman an haén.’ ");
INSERT INTO blw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yag ah Moses hen anchi nawawà-acha hen anchichay anap-otaaw hen anchi ini-inggawancha hen anchi pachinanak way hiya agé hen anchi nanagépfar hen anchi anghel hen anchi filig ad Sinai. Ya hiya agé hen neporangan hen anchichay mannanayun way orchin Apudyus ah mangimfag-ana an chitaaw way tatagu.” ");
INSERT INTO blw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ngém hen anchichay a-anap-otaaw, anchag achi afuroton ah Moses, ya anchag achi pagan-ano hiya, te ancha yanggay ammag laychén way mamfangad koma ad Egipto. ");
INSERT INTO blw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wat hen ini-inggawan Moses hen anchi filig ad Sinai way cha mètagépfar an Apudyus, anchag imfaga an Aaron way mangaliyén, ‘Omamma-a man ah mamàila way Apudyustaaw ta wachay mangempangpango an chitaaw, te maid met innilataaw no heno hen na-ammaan an Mosesanna way nangetnod an chitaaw hen lommayawantaaw ad Egipto.’ ");
INSERT INTO blw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yachi yag anchaat ammaan hen finakafaka ta mamàila ah chayawéncha. Yag anchaat mamparte ah ichatoncha ya anchaat manlagsak ah layadcha hen anchi enammaancha way man-apudyuscha ano. ");
INSERT INTO blw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wat ah Apudyus, annag nanchùgan chicha wat inyanggayana hen anchichay anap-otaaw ta egadcha ah chayawéncha te uray hen taraw ad uchuwén chacha chayawén. Wat yachi hen mangaryan Apudyus an chicha hen enalena way ensorat hen profeta ad namenghan, ekatnéén, ‘Chàyu way ganà Israel, amin hen anchi opatporo way tawén way nanarananyu hen anchi pachinanak way lota, faén haén hen empartiyanyu ya faén agé haén hen nanchatonanyu hen anchichay chayu inchaton. ");
INSERT INTO blw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Te anyug entatàen hen anchi finab-alléy way ini-inggawan hen anchi enap-apudyusyu way Molok, yag hiya hen chinad-ayawyu. Yag chinayawyu agé hen anchi tenat-araw way Refam way nan-apudyusyu agé. Chichachi hen enammaanyu ah chayu chinayaw way faén haén. Wat an-og eparyaw chàyu ah achawwéyay lota ingganah lomooh-ayu ad Babilonia.’ Yachi hen enalen Apudyus hen anchichay a-anap-otaaw.” ");
INSERT INTO blw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Cha etoroy chillu Esteban way man-ale hen anchichay konsel, ekatna agéén, “Hen kawad-an hen a-anap-otaaw hen anchi chanak, entatàencha hen anchi torcha way faréy hen torag Apudyus an chicha. Yag hen anchi torcha, an paat an na-ammaan hen nanorachan Moses hen imfagan Apudyus te an empàilan Apudyus hen torachén Moses hen mangammaana. ");
INSERT INTO blw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Angkay hiyachi way natéy ah Moses way neparég Josue, tenawid hen anchichay a-anap-otaaw hen anchi torcha yag entatàencha hen ummaliyancha ahtod Canaan. Wat tenorongan Apudyus chicha way nangemparyaw hen anchichay nankarakarase way siguchay tatagu ahtod Canaan ta man-awan hen a-anap-otaaw hen antoy lota. Wat hen anchi torcha way faréy Apudyus, é-éttégna ahto inggana hen tempon hen nan-areyan David. ");
INSERT INTO blw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wat ah Are David, ammag chakar hen layad Apudyus an hiya yag chinawatna an Apudyus ta eparufusna koma hen mangammaana hen kasen faréy Apudyus way am-ammay ta yachi hen chacha i manayawan way ganà Jacob an Apudyus. ");
INSERT INTO blw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ngém faén ah David hen nangamma hen hiyachiy faréy Apudyus te hen anàna way Solomon.” ");
INSERT INTO blw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ngém ah katot-owana, faén chillu faréy way enammaan hen tatagu hen i-inggawan Apudyus way kangatowan, te hen ensorat hen ihay profeta ad namenghan, ekatnéén, ");
INSERT INTO blw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ad uchu hen tùchù,’ way ekat Apudyus, ỳa hen antoy lota hen gumagattenà. Wat henon ekamanyu way mangamma ah érégna ah mamfaréy-o ya chuud hen mangiggaanyu, ");
INSERT INTO blw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","te haén chillu hen nangamma amin hen egad way wachan antoy lota yad uchu.” ");
INSERT INTO blw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Yachi yag entoroy Esteban way mangaliyén, “An-ayu ammag térén te tàén namarkaan hen acharyu ta mantatagun Apudyus chàyu, ammag maid awanwani chillu hen hamhamàyu way mangamma hen laychéna, te anyug achi changrén hen ifagana. Yag chayuwat agé ekaman hen enkaman hen anchichay a-anap-otaaw ad namenghan way anyug cha kontaréén hen Espirituna. ");
INSERT INTO blw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ay ammoh wachay ihà-anay profeta ad namenghan ah iggay pap-aligatén hen a-anap-otaaw. Maid met te ancha ammag pinchit amin hen anchichay hennag Apudyus way i mangimfaga mepanggép hen umaliyan hen anchi anàna way maid fasfasorna. Yag angkay ummale hen yachiy anàna, chàyuwat agé hen nangentochar ya nangempapchit an hiya. ");
INSERT INTO blw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Achi koma mafalinchi, te chàyu paat hen nanangchén hen anchi orchin Apudyus way intudtuchun hen anchi anghel, ngém anyug achi peet cha afuroton.” Yaha hen ensongfat Esteban hen anchichay konsel ya kangatowan way pachi. ");
INSERT INTO blw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Angkay narpas way chengngar hen anchichay konsel hen enalen Esteban, anchag nanngalitfén hen fub-acha ah aningarngarcha. ");
INSERT INTO blw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ngém ah Esteban way iné-égnanan hen Espiritun Apudyus hen hamhamàna, nantangad ad uchu yag innilanaat agé hen hummiliyan hen kaenammay Apudyus ya anat agé ah Jesus way tommatàchég hen pachawanan Apudyus. ");
INSERT INTO blw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Ilanyu ngén,” way ekat Esteban, “te anchi nafùtan ad uchu wat anchiyan ah Jesus way Pangorowan hen Tatagu way tommatàchég hen pachawanan Apudyus.” ");
INSERT INTO blw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Wat hen anchichay nanangngar, ancha ammag heo-ongaw yag chachaat horatén hen ingacha, yag anchag nagyub ");
INSERT INTO blw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","way i manlakrak an hiya way manginyéy hen anchi fùnagan hen fabréy yag anchaat funfunto-on hiya. Wat hen anchichay nangenlémrém an Esteban, emporangcha hen agwan hen lumfongcha hen ihay larae way ah Saulo hen ngachanna. ");
INSERT INTO blw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yag hen chacha mamunfuntoan an Esteban, chaat manluwaru way mangaliyén, “Apo Jesus, aranà.” ");
INSERT INTO blw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yag nampalentomang way mangèngaw way mangaliyén, “Apo, pakawaném koma chicha hen antoy chacha ammaan.” Yachi hen enalena yag natéyat. ");
INSERT INTO blw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Yag ah Saulo, enafunana hen namchitancha an Esteban. Ngém wachacha hen tapena way omma-abfurot an Apudyus, wat incha inlufù hen achar Esteban way amchan chi nangelaancha an hiya. Hen hiyachi paat way ag-agaw way natéyan Esteban, nilugi hen ammag pararo way mapaligatan hen amin anchichay cha omafurot ad Jerusalem, wat ancha