﻿USE sofia;
DROP TABLE IF EXISTS sofia.bla_vpl;
CREATE TABLE bla_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bla_vpl WRITE;
INSERT INTO bla_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","SIN AK'SIN Jesus Christ David okkuai' Abraham okkuai' un'ix o sĭnaks' oaiĕxĕsts. ");
INSERT INTO bla_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ikuyiu' Isaac; ki Isaac ikuyiu' Jacob; ki Jacob ikuyiau' Judas ki omu' pappiipix; ");
INSERT INTO bla_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ki Judas ikuyiu' Phares ki Zara, Thamar ipau'kaiĭmmiuax; ki Phares ikuyiu' Esrom; ki Esrom ikuyiu' Aram; ");
INSERT INTO bla_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ki Aram ikuyiu' Aminadab; ki Aminadab ikuyiu' Naasson; ki Naasson ikuyiu' Salmon; ");
INSERT INTO bla_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ki Salmon ikuyiu' Booz, Rachab ipau'kaiĭmmiuaie; ki Booz ikuyiu' Obed, Ruth ipau'kaiĭmmiuaie; ki Obed ikuyiu' Jesse; ");
INSERT INTO bla_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ki Jesse ikuyiu' David omŭx'nin'a; ki David omŭx'ina ikuyiu' Solomon, annŏk' ake'uŏk itom'itomiuŏk Urias man'itotsipokaiĭmmiuaie; ");
INSERT INTO bla_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ki Solomon ikuyiu'. Roboam; ki Roboam ikuyiu' Abia; ki Abia ikuyiu' Asa; ");
INSERT INTO bla_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ki Asa ikuyiu' Josaphat; ki Josaphat ikuyiu' Joram; ki Joram ikuyiu' Ozias; ");
INSERT INTO bla_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ki Ozias ikuyiu' Joatham; ki Joatham ikuyiu' Achaz; ki Achaz ikuyiu' Ezekias; ");
INSERT INTO bla_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ki Ezekias ikuyiu' Manasses; ki Manasses ikuyiu' Amon; ki Amon ikuyiu' Josias; ");
INSERT INTO bla_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ki Josias ikuyiu' Jechonias ki o mu' pap piipix, annik' ito'toŏpikau Babylon; ");
INSERT INTO bla_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ki ot'sitotos au Babylon, Jechonias ikuyiu' Salathiel; ki Salathiel ikuyiu' Zorobabel; ");
INSERT INTO bla_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ki Zorobabel ikuyiu' Abiud; ki Abiud ikuyiu' Eliakim; ki Eliakim ikuyiu' Azor; ");
INSERT INTO bla_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ki Azor ikuyiu' Sadoc; ki Sadoc ikuyiu' Achim; ki Achim ikuyiu' Eliud; ");
INSERT INTO bla_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ki Eliud ikuyi u' Eleazar; ki Eleazar ikuyiu' Matthan; ki Matthan ikuyiu' Jacob; ");
INSERT INTO bla_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ki Jacob ikuyiu' Joseph, Mary om'i, annok ipau'kaiĭmmiuŏk Jesus, anĭstau Christ. ");
INSERT INTO bla_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","David otsĭs'tsits'unoauai Abraham itsipuk' sŭpokosĭnimotseiiau ke'pitappiiau nĭssekoputtsi; ki ot'sitotosau Babylon omats'ĭstsits'unoauai David mats'itsipuksŭpokosĭmmotseiiau, matsĭsse'koputtsi; Christ omats'ĭstsits'unoauai ot'sitotosau Babylon mats'itsipuksŭpkosĭmmotseiiau matsĭsse'koputtsi. ");
INSERT INTO bla_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Christ, otsipokai'isĭnni ŭn'niniitsiu: Annik' Mary, Jesus oksĭs'tsi, Joseph otak'okemattŏsaie itop itappi'inai, otse'kosatsok Atsĭm'istaaw. ");
INSERT INTO bla_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph om'i mokŏm'motsitappiu, ki matsitsitau'ats mŏk'aiitsĭnnikŏttŏsaie; osĭme'tsitan mŏksisĭm'ianĭstŭpskoŏsaie. ");
INSERT INTO bla_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ki otai'ksĭmstatosaie, Satsit, Ap'ĭstotokiuăoto'tokatatsĭs otsipopŏk'toakaie ki otan'ikaie, Joseph, David okku'i, pinstŭnnos Mary kŏk'okemattosi, otse'kosatsok Atsĭm'iStaaw. ");
INSERT INTO bla_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ki ai'aksipokaiĭmmiuaie okku'yi, ki kitak'anĭstsĭnnikŏttau Jesus: tŭkkă, otsitappim'ix otsauum'itsitappi'isuauĕsts aiakitaikŏmotse'piuax. ");
INSERT INTO bla_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Itŭn'nitsiuaie mŏk'itsenŭpanĭstŏsi Ap'ĭstotokiuă otse'poawsĭsts, otsipropheti itotse'poawsĭnĕsts, ki an'ĭmai, ");
INSERT INTO bla_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Satsik, mokŏk'iake ai'akopitappiiu, ki ai'aksipokaiĭmmiuaie okku'yi, ki ak'anĭstsĭnnikŏttsiauaie Emmanuel, ito'kĭsasattop Ap'ĭstotokiuă ipokai'tappiĭmmau. ");
INSERT INTO bla_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph otsipuawk'si otso'kani, ŭn'niitsitappiiu Ap'ĭstotokiuă oto'tokatatsĭs otan'iipiaie, ki ito'tuyiuaie otokem'an: ");
INSERT INTO bla_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ki ototom'okkuyi otsauomai'pokaiĭsaie matpoksokamiu'atsaie: kinitsĭn'nikŏttsiuaie JESUS. ");
INSERT INTO bla_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","JESUS otai'pokaiisi Bethlehem, auŏsĭn'ĭm Judæa, annists'ĭsk ksĭstsiku'ĭstsk, Herod otsĭtsĭnaiipi, Satsik, mokŏk'ietappix umut'autstsipi apinŏk'kuyi itsipuk'sipuiau Jerusalem, ");
INSERT INTO bla_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","An'iau, ŭnan'ŏk manipok'auŏk Jews otsĭn'aimoaiauaie? Tŭkkă, annim' apinŏk'kuyi stai'tappiosi nitsĭno'ŭnan okŏkatosim, ki nimut'otopĭnan nŏk'itauatsĭmmimmŏsĭnan. ");
INSERT INTO bla_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herod omŭx'ina otokh'tsĭsaie, otap'itsi-tanaie, ki Jerusalem ĭstokŏnai'tappix ikŏno-nokap'aitsitamiuax. ");
INSERT INTO bla_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ikŏnaumoi'piŭsax omŭk'atoiapiekuax ki ai'sĭnakix, sŭppoŏttsesattsiuax Christ mŏk'itsipokaiipiaie. ");
INSERT INTO bla_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ki an'ĭstsiauaie, Bethlehem, Judæa ĭstauŏsĭn'im, ŭn'nimaie; ŭn'anĭstappi prophet osĭn'aksĭn; ");
INSERT INTO bla_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ki ksĕsto'a Bethlehem, Judæa ĭstauŏsĭn'im, kimats'inŭkstsipuaua, Judah ĭstsĭn'ax; Nin'auŏk, ksesto'a ak'itsĭstauasiu ki osto'i ai'akaukŏkitsĭmau nitsitappim'ĭx Israel. ");
INSERT INTO bla_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod, sĭmi'nikŏtŭssax mokŏk'ietappix, sokap'sŭppoŏtsesattsiuax otsokap'ĭnŏkuyisaie kŏkatosi. ");
INSERT INTO bla_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ki itŭpŭt'okŏttsiuax Bethlehem; kian'iu, kŭkko' sokap'apsŭmmok pokau'ŏk; ki ikonoainoeniki, itŭm'ŭtskĭtsĭnikokĭk nŏk'itsitotosi nŏk'it a tsĭm mĭm mosi. ");
INSERT INTO bla_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Otokh'tsĭsau omŭxina otan'iipiaie, itsĭs'tapuiau; ki satĭsk, anni'isk kŏk'atosiĭsk otsitsinoauaiĭsk umut'autstsipi apinŏk'uyi otsitom'akoaiauaie, ki otai'totosi inŭk'sipokai ot'sitaupipiaie itots'iketsipuyiuaie. ");
INSERT INTO bla_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Otsĭnno'ŏssauaie kŏk'atosi, eks'kamŭk otse'tametŭksuaii. ");
INSERT INTO bla_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ki otaitsipĭs'sau nap'ioyĭs, Mary oksis'tsi ipĭnnu'yiauaie pokai'ĭsk, ki ĭnnĭssi'iau, ki itatsĭm'mĭmmiau: ki otaipasuk'ĭnĭssauĕsts otakomŭtskotuksuauĕsts, ĭssak'okotsiauaie gold ki frankincense ki myrrh. ");
INSERT INTO bla_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ap'ĭstotokiuă papaukŏkianĭstcsax mŏkstaiskĭto'tosau, noke'tsi moksokui itŭp'akaiiau. ");
INSERT INTO bla_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ki otau'mattosau, satsĭk, Ap'ĭstotokiuă sto'tokatatscs papauta'atsiuaie Joseph, an'ĭsitouaie, Nipuat', ki mattos'au pokau' ki oksĭs'tsi ki ikŭm'itappoat Egypt, ki stau'pit ki kĭtak'otŭmanĭsto; tŭk'kă, Herod ai'akapsŭmmiuaie inŭk'sipokau mŏks'enitŏsaie. ");
INSERT INTO bla_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Otai'puawksi, sepiai'akotuyiuax inŭk'sipokau ki oksĭs'tsi ki Egypt itŭp'itappoiau: ");
INSERT INTO bla_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ki itau'piuaie otai'ĭnsaie Herod, mŏksenŭp'anĭstosi Ap'ĭstotokiuă otse'poawsĭn, otsiprophet i totsi'uaie, Egypt, ŭn'nimaie nitsĭt' ŭtŭmmau noko'a. ");
INSERT INTO bla_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod, otai'noŏsax mokŏk'ietappix otap'apĭstotoyĭsax, eks'kaiĭstsetŭkkiu, ki itŭp'otokŏttsiuax (otsen'nakemix) Bethlehem ki sa'akapotsim, ai'stokistuyimix sŏk'umappix ikŏn'ainĭttsiauax; kŭttaistoki'stuyimix sŏk'umappix mat'okŏnainittsiauax, umut'otsksĭnippi otsokap'sŭppoŏtsesattŭsax mokŏk'ietappix. ");
INSERT INTO bla_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Itŭm'enŭpanĭstomaie Jeremy prophet otse'poawsĭn otan'ipi, ");
INSERT INTO bla_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Epo'awsĭnni itsĭk'kitokhtsip Rama, asain'sĭnni ki aiĭm'motseisĭnni ki omŭkoyesĭnni, Rachel o'kosix itau'asŭniu ki matokuikiawpĭketŭkkiu'ats, tŭkkă, itsen'iau. ");
INSERT INTO bla_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod otse'ĭnsi, sat'sĭk, Ap'istotokiuă oto'tokatatsĭs Joseph otsipapau'takaie, Egypt otsitai'tappiisaie. ");
INSERT INTO bla_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","An'ĭstsiuaie, Nipuat'ki mattos'au inŭk'sipokau ki oksĭs'tsi, ki itŭp'itappoat Israel istau'ŏsĭnĭm; tŭk'kă ini'au anniks'isk ap'ŭssummiiskaie otsipai'tappiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ki itsipuau ki aiako'tuyiuax pokau'a ki o ksĭs'tsi, ki Israel ĭstauŏsĭn'im ito'to. ");
INSERT INTO bla_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ki otokh'tsĭssi Archelaus otau'atsuaiitsitapai'naiisi un'ni otsĭn'naiisĭnni, ĭsstŭn'ĭmaie mŏk'ĭttapposaie; ki Ap'ĭstotokiuă otsipapauanĭstosaie, Galilee itanĭs'tŭpitappo: ");
INSERT INTO bla_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ki akapioyis, Nazareth anĭstau, ito'to kiitoko'yiu; mŏkenŭpanĭstosaie prophetix otan'iipiax, akanĭstai'nikŏttau Nazaren'aikuŭn. ");
INSERT INTO bla_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ANNISTS'ISK ksĭstsiku'ĭstsk John Baptist ito'to Judæa istoksĭs'tapiksŏkkui, itŭs'-ksĭnimatstokiu, ");
INSERT INTO bla_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ki an'iu sauai'tsitak, spots'im ĭstsĭn'naiisĭnni aststsiu'. ");
INSERT INTO bla_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Am'auk annŏk' matap'piuŏk Isaiah prophet an'iu Nitsităppiuă ksĭstapitauosĭnim sokse'puyiu, Sŭppoatsĭstotokh'sattoat Nin'a oksokui, oksoku'ĭsts mokŏm'otstsĭsests. ");
INSERT INTO bla_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ki John, Camel oku'yĭsts, itsĭs'totosiu, ki ĭstsikŏp'okui itsep'siu; ki otso'ŏssĭnĕsts tsikatsix ki namap'iniu. ");
INSERT INTO bla_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem istokŏnai'tappix otokŏnitota'akax, ki Judæa ĭstokŏnai'tappix, ki Jordan ĭstauŏssĭn'im ĭstokŏnai'tappix mat'okŏnitautaakax. ");
INSERT INTO bla_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ki nie'tŭktai Jordan (an'istop), otsĭt'ŭstapinopiax, ki otsauum'itsitappiisuĕsts aiinŭp'anĭstomiauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ki otsinno'ŏssax otas'taaiĭssax akai'tappiiax Pharisees ki Saducees, otsittŭp'auauŏkŏssax otsĭtŭsta'pĭnŭkipi, an'ĭstsiuax, Pĭtseksĭnau'kosix, tŭkka' kĭtan'ikoau kŏkanĭstŭpĭstŭpiksatossuai annik' ĭstse'tŭksĭnik astai'tsiik? ");
INSERT INTO bla_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ai'sŭsksattok matsiĭn'ĭsts mŏk'itanĭstosi kĭtsauai'tsitani: ");
INSERT INTO bla_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pini'tsitsiikasik kĭtsitsi' tanauĕsts kok'kĭtŭnĭssuai Kĭn'un Abrahami; kitan'ĭstopuau Ap'ĭstotokiua, am'oxim okotokix ikotsĭstauatomoaiau Abraham pokax. ");
INSERT INTO bla_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kiannok' kŏts'eksĭsts kaxa'kin itsipo'toau: kŏnai'ĭstsĭs saiĭnasĭssi ak'aikakiaiau ki ak'aututsaiau. ");
INSERT INTO bla_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Okke' kimut'sĭtŭstapĭnopuau kŏkkĭtsisauai'tsitasuai: apatots'ĭk annŏk' ai'aksakootoŏk aiĭs'skunitapsiu, nimatsĭkŏkokotopa'tomoauats matsikĭsts': Ostoi' kimutak'ĭstapĭnokoau Atsĭm'istaaw ki ĭs'tsi: ");
INSERT INTO bla_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ose'kotŭkkiatsĭs ai'ĭnĭmaie, kiaupŭx'ĭxtoxixi otsĭt'aisuisuitsipĭk'iakipi aiaksokapse'maie, osos'tsipĭkiapioyĭs aiakitsĭptsĭpotomĕsts otapaiĕn'ĭnsĭmmanĭsts; ki ĭstotox'ksiĭsts ĭstsi'i matakatsiu'ats ai'aketsĭnsimĕsts. ");
INSERT INTO bla_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesus Galilee itŭm'aumatto, Jordani nie'tŭktai ito'to, John mŏkitsĭstapĭniĭsaie. ");
INSERT INTO bla_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ki John paiau'tsimĭuaie, ki otan'ikaie, ksĕsto'a ĭs ta' pĭn o kĭt, kitaketak'sipuksipat to kŏkokotsĭs'tapĭnnŏksi, ki kumauksipuksipaakĭks? ");
INSERT INTO bla_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus an'ĭstsiuaie pokĭtse'tsĭt annok': nŏks'ĭstutsĭsĭnan mokŏm'motsitappiisĭnni. Itŭmipaio'kĭts etomoyiuaie. ");
INSERT INTO bla_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ki Jesus aiĭs'tapĭnnŏssi, itopĭtsĭssoa'tomaie okke': ki, sat'sĭk, spots'im kau'opiu, ki nan'nuyiuaie Ap'ĭstotokiua otatsĭm'istaaw itutui'sŭpĭnŭmaie sĭstsi'i itsĭnauŭni'ĭnai, ki itokhitopi'ĭnai: ");
INSERT INTO bla_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ki, satsik, epo'awsĭnni spots'im itunni'u amok'auk nĭtŭk'omĭmokoa, nitsekŏkh'sĭmau. ");
INSERT INTO bla_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ATSIM'ISTAAW ksĭs'tapiksŏkkui itŭmitŭppĭp'iuaie Jesus, sauum'itsitappiua mŏk saksksĭnnoŏsaie. ");
INSERT INTO bla_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ki nĭsĭp'puyi koku'ĭsts, ki nĭsĭp'puyi ksĭstsikuĭsts otsĭt'saioyipists, itsakoo'notsiu. ");
INSERT INTO bla_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ki Issaks'ksĭnĭmaitappii itoto'yĭnaie an'iĭnai, Ikŭm'ŭmeniki Ap'ĭstotokiua okku'i, am'oxim ok'otokixĭm sĭtsĭp'satsisau mŏkitapaiĕnasau. ");
INSERT INTO bla_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ki itŭnĭs'tsiuaie, Sĭnaip Matap'pi matokot'otsipaitappi'iuats napaiĕn, Ap'ĭstotokiua maoi'i umutokŏnai'poawsĭsts aiakotsepaitappiiu. ");
INSERT INTO bla_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sauum'itsitappiuă otsĭtsitapĭppiok Atsĭm'akapioyĭs, ki itokhit'sipotoyeik Nato'iapioyĭs, ");
INSERT INTO bla_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ki an'ĭstsiuaie, Ikŭm'ŭmeniki Ap'ĭstotokiua okku'i, ĭnĭs'suiauŭnit: sĭn'aip, akanĭstsiuax oto'tokatatsix ksĕsto'a: ki otsu'auĕsts kitakitotsiketsi'enokiau, kokŏt'sĭsts kŏkstai'tŭkŏkhsau ok'otoki. ");
INSERT INTO bla_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus itŭnĭs'tsiuaie, mat'sĭnaip, kimataksaksksĭnoau'ats Nin'a, kitap'ĭstotokă. ");
INSERT INTO bla_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sauum'itsitappiuă spaiĭstŭkki otsittŭmmi'piokaie itaiĭstummŭt'tsiikaie kŏnauau'ŏsinists ki istsap'inatsiikiests; ");
INSERT INTO bla_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ki anĭstsiuaie, am'ostsim kŏnauau'ŏsĭnĭsts kitak'okoto, apĭs'tuksĭsanopieniki, atsĭm'mĭmmokeniki. ");
INSERT INTO bla_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus itŭman'ĭstsiuaie, Mĭs'taput, Satan: sĭn'aip, Nina Ap'ĭstotokiua kitak'atsĭmmĭmmau, ki kitak'aitanĭstaitoau. ");
INSERT INTO bla_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ki Sauum'itsitappiuă otai'skikaie ki, sat'sĭk, oto'tokatatsix ito'toyikiax ki otspum 'okax. ");
INSERT INTO bla_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesus otokh'tsĭmsi John ĕen'ŏsaie itsitap'po Galilee: ");
INSERT INTO bla_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ki otŭnĭstŭpa'atosaie Nazareth, Capernaum ito'to ki itoko'yiu, ĭssoots'i omŭk'sikĭmi ai'aketsksŏkkui Zebulon ki Nephtalim: ");
INSERT INTO bla_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Isaiah otse'poawsin mŏksenŭpanĭstosi otanipi, ");
INSERT INTO bla_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebulon ĭstau'ossĭnni ki Nephthalim ĭstau'ŏssĭnni o mŭk'sikĭmi ĭsta'potsim, Jordan ap'ŭmmotsim, Galilee ĭstok'auaax; ");
INSERT INTO bla_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Anniks'ĭsk matap'pixk, ski'natsi itau'pixk omŭk'anatsi nan'ĭmmiau: ki anniks'ĭsk matap'pixk auŏssĭn'ni eĭnsĭn'ni itstsi'ipi ki eĭniu'tŭxĭssĭnni itstsi'ipi, itau'pixk, ksĭstsikui'natsiu otsŭs'kŏpsiu. ");
INSERT INTO bla_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Annik' Jesus aumŭtŭpsokse'puyiu, ki an'iu, Sauai'tsitak; Spots' ĭmistokŏk'itsimani ăststsiu'. ");
INSERT INTO bla_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ki Jesus, auau'ŏkassi, Galilee ĭstomŭk'sikĭmi, itsĭnnu'yiuax aiĭs'kŭnnĭmotseiyix, Simon, an'ĭstau Peter; ki oskŭn' anĭstau Andrew, ĭsksĭmmatŭk'kiomikatsĭs omŭk'sikĭmi itai'suiapĭxĭmiauaie, tŭk'ka itomik'aitappiisau. ");
INSERT INTO bla_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ki itŭnĭs'tsiuax, noksŭppa'akik, ki kitakitaumik'ottaiau matap'pix. ");
INSERT INTO bla_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ki atomik'atsuai itskĭm'miau ki itopokiuo'iauaie. ");
INSERT INTO bla_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O mŭt'tŭkkiosi matsĭtsĭnnuyeiuax mat'toskŭnĭmmotseiix, James, Zebedee o ku'yi, ki John oskŭn', ipĭt'sŭpĭnnuyiuax ak'iosatsĭs, Zebedee, iin'oauaie, aip'sĭmiax otomik'atsuauax: ki itsĭn'nikŏttsiuax. ");
INSERT INTO bla_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ki ipĭt'skĭttsiiauaie un'oauaie ki ak'iosatsĭs, ki itopokiuo'iauaie. ");
INSERT INTO bla_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ki Jesus Galilee ĭstokŏnau'ŏssĭnni itap'auauŏkau, otatoiapioko'auĕsts itai'pĭstsksĭnimatstokiu ki aisokse'puyiu spots' im istsetam'itsĭniksĭnni; ki matap'pix opŭs'tsĭmmesuai ki otok'tokossĭnuauĕsts ikŏn an'kŭttutuyiuax. ");
INSERT INTO bla_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ki otap'ĭstutŭksĭnni ikŏnauanetŭnĭstopaie Syria ĭstau'ŏssĭnni; ki ikŏnai'oktokosix, ki amianĭstsipŭs'tsĭmisix, ki anniks'isk matap' pixk sauumitsitappiuă itsĭps'tokoyiau, ki mat'tsapsix, ki an'auxenix, ikŏnitautsĭppotoaiax; ki ikŏnau'kuttutuyiuax ");
INSERT INTO bla_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ki Galilee ĭstokŏnai'tappix ikŏnawk'pokiuoiauaie, ki Decapolis, ki Jeiusalem, ki Judæa, ki Jordan ap'ŭmmotsim ĭstŏkonai'tappix matsekŏnawkpokiuo'iauaie. ");
INSERT INTO bla_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kĭ otsĭnno'ossax akai'tappix ni tum'mo ita'mĭsso: ki otau'pĭssi otsitappim'ix ototaakax: ");
INSERT INTO bla_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ki itsipa'kuiakiu ki itŭsksĭnĭm'atsiuax, ki itŭniu, ");
INSERT INTO bla_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Anniks'isk matap'pixk oskĕttsipŏppuauĕxk ĭkikĭn'etŭkkiĭsk, etam'etŭkkiau: spots'im ĭstsĭn'naiisĭnni osto'auai otsinan'oaiau. ");
INSERT INTO bla_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Au'yesĭx etam'etŭkkiau: aiaksikiawpiksĭstotoaiau. ");
INSERT INTO bla_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ikkĭnap'itappiix etam'etŭkkiau: ksŏk'kum otaksĭnan'oaiau. ");
INSERT INTO bla_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ino'tăttomix mokŏm'motsipaitappiisĭnni ki inăk'attomix mokŏm'motsipaitappiisĭnni etam'ĕtukkiau: ai'akokuyian. ");
INSERT INTO bla_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kĭmapi'itappix etam'etŭkkiau: otak'sikĭmokiau ");
INSERT INTO bla_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ksĭkus'skĕttsipŏppix etam'etŭkkiau: ai'aksĭnnuyiauaie Ap'ĭstotokiuă. ");
INSERT INTO bla_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Inŭs'tsetappix etam'etŭkkiau: akanĭstainikŏttaiau Ap'ĭstotokiuă o'kosĭx. ");
INSERT INTO bla_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anniks'isk matap'pixk itsikĭm'atsĭstotoaiau otŏkommo'tsitappiuŏsoauĕsts etam'etŭkkiau; otsinan'oaiau spots' im istsĭn'naiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Oksĭs'totokoeniki ki maka'pi sĭtsĭp'sŭkoeniki, ki aisĭmmĭm'motsenikiau, tŭkka kĭtŭk'omĭmmokoau kitse'tametŭksuai. ");
INSERT INTO bla_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","So poke'tametŭkkĭk, spopai'piĭk; kitakitakai'sakĭnnosŭko spots'im: apatots'ik neto'yik ŭnninetoksĭstotoyiuax Ap'ĭstotokiuă otsiprophetix. ");
INSERT INTO bla_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kĕsto'akauk ksŏk'kum ĭstsĭstsĭxipoku: atstosai'e umut'aiawxipi itsĭx'ipokuyi, tsanĭstapiu ksŏk'kum umutaiaksitsĭxipokuĭstutsip? Matŭtokoapi'uats, ki aksĭs'tapĭxip, ki akitsitautŭtsamiai'osi. ");
INSERT INTO bla_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kĕsto'akauk ksŏk'kum ĭstŭn'natsii. Akap'ioyĭs aitokittokhi netum'moyi matokotsiksĭsattop'ats. ");
INSERT INTO bla_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Matap'pix matotstsĭm'axauaie anak'imatsĭs mŏkitsitaistakhtotosauaie assuyĭn'i, itai'sŭppatomiau itai'sŭpanakĭmatsopi, ki matap'pix itsĭps'taupix napioyĭs itokŏnnauan'akĭmaiau. ");
INSERT INTO bla_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Neto'yik kitan'akimatsĭs ĭstot'ŭnnasayit matap'pix mŏk'itsĭnniĭsau kitawx'ĭstutsipists mŏk'ĭtstsakŭttosauaie kin'a spots'im. ");
INSERT INTO bla_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Pinstak nimut'otopi nŏkitŭnnĭstupipotsĭsau okŏk'itsĭmani, ki prophet ix otŭn' issuai: nimatŭtoto'pa nŏkĭtŭnnĭstŭpipotsĭsau, nimut'oto mŏkĭtsŭpanĭs'tsĭstutsisau. ");
INSERT INTO bla_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kitau'mŭnĭstopuau spots'im ki ksŏk'kum otsauomai'tsĭnikasi, ki okŏk'itsĭmani otsitsauomsŭpanĭstsiopi tŭks'kai sikŭk'sĭnaksĭn okŏk'itsĭmani itstsi'ipi mat'akitsĭnikauatsaie. ");
INSERT INTO bla_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Annŏk tukskai am'ostsim inŭxe'poawsists kŭttai'aksĭstutsĭmŏkaie, ki ai'aksksĭnĭmatsokax matap'pix mŏk'staiĭstutsĭsaxaie, ak'anĭstainikŏttau inŭks'tsĭm spots' im; annŏk' ai'aksistutsimests ki ai'aksksinimatsokax matap'pix mŏks'ĭstutsĭmĕsts, ak'anĭstainikŏttau omŭk'sĭm spots'im. ");
INSERT INTO bla_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kit an'ĭstopuau kitokŏmotsipaitappiisĭnni saiĭs'tŭpŭkuiŏkhsĭssi Scribes ki Pharisees ot'okŏmotsipaitappiisuĕsts kimatakitsipipuauats spots'im ĭstsĭn'naiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kikai'okhtsipuau ŭkkaiiap'ix otan'ikoaiau, Pinuye'nĭkik: ki annŏk'ai'akoyenikiuŏk ai'akesetsĭmaie okŏk'itsĭmani: ");
INSERT INTO bla_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ki kitan'ĭstopuau annŏk' ksĭstapĭstsĭm'iuōk ox'okoă ai'akesetsĭmaie okŏk'itsĭmani; ki annŏk' ak'anĭstsiuŏk ox'okoa Raca, aiakesetsimaie okok'itsĭmani: ki annŏk' ak'anĭstsiuŏk, kĭtŭt'tsapsi, ai'akesetsĭmaie Gihenni ots'tsiĭmiaie. ");
INSERT INTO bla_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Puksipĭp'potomĭniki kitak'iksĭstomŭtskotŭksĭnni natoi'apioyĭs, ki ĭsksĭnĭm'ĭniki kixokoa kĭtsĭs'tsĭmmok, ");
INSERT INTO bla_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ŭn'nim altar ĭstsskit' kitakiksĭstomŭtskotŭksĭnni, ki matskot'; matom'ots matsin'nŭstseik ksĕsto'a ki kĭxokoa, ki tŭm'ŭtsipuksiput ki sakumŭts'kotoat kitsiksĭst'omŭtskotŭksĭnni. ");
INSERT INTO bla_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kipĭnnŭs'tseĭmĭs kikakhtum'o, kĭtsakiokhpokau'pimŏssi: kŏkstaiĭstapĭpiok au'kŏkitsĭmaii, ki au'kŏkitsĭmaii ŏk'staukotsei eĕnake'nai, ki kĭtakitsĭps'tapixik itai'ĭnŭkiopi, ");
INSERT INTO bla_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kitau' mŭnĭsto kitsauomai'ponitatossi kitak'sakookotossi, kimataksuxpa. ");
INSERT INTO bla_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kikai'okhtsipuau otanipuauĕsts ŭkkaiiap'ix, Kimatakauŏkotapuaua: ");
INSERT INTO bla_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ki nestoa kitan'ĭstopuau, annŏk' ŭs'sŭmmiuŏk ake'uŏk mŏk'sta tossaie, ŭkaukhtauauŏkautăttseuaie u'skĕttsipŏppi. ");
INSERT INTO bla_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kinet'oopspi itsuyĭsseeniki, sauau'tos ki mĭs'tŭpapiksĭstsĭs: ŏkh'siu tŭks'kŭma mŏk'saiĭnakuaiĭssi koŏpspi, ŏkstaiĭs'tupapiksĭs kostŭm Gehenna. ");
INSERT INTO bla_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kinet'otsĭs itsuyĭsse'eniki kawksĭnnĭt', ki mĭs'tŭpapĭxit: ŏkh'siu tuks'kaii kotsĭs'i mŏk'saiĭnakuaiĭssi, ŏkstaiĭs'tŭpapiksĭs kostŭm Gehenna. ");
INSERT INTO bla_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ǔk'auanĭstop annŏk' aiaksiksiuatsiuŏk otokem'ani ŭnnianĭst'okotsĭs iksiuo'isĭnaksĭn: ");
INSERT INTO bla_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ki kitan'ĭstopuau annŏk' aiaksiksiuatsiuŏk otokem'ani, otsauomauau'ŏkotasi, nokets'ĭnai otauŏkotăts'okaie; ki annŏk' aiakokkem'iuŏk otai'ksiuatai'ĭsk itau'ŏkatau. ");
INSERT INTO bla_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Stsĭk'i, kikai'okhtsipuau otan'ipuauĕsts ŭk'kaiiap'ix, kimataksiksĭstapatauŭni'pa, ki, kitakitauanĭstau Ap'ĭstotokiua kitatauŭn'ĭssĭnni: ");
INSERT INTO bla_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ki kitan'ĭstopuau, Pinŭt'auŭnik; spots'im pinitŭpŭtauŭnĭk; tŭk'ka Ap'ĭstotokiua otspiso'pŏtsĭsaie: ");
INSERT INTO bla_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ksŏk'kum pini'tŭpŭtauŭnik; itsĭssuikau'piu: Jerusalem pini'tŭpŭtauŭnik; tŭkka Omŭx'ina ot'akapioyimaie. ");
INSERT INTO bla_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kimat'akitŭpŭtauunipa kotokŏn', kimatkotsiksixĭstutsipats nitu'kuyekai ki kimatokotsixĭstutsipats. ");
INSERT INTO bla_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ki anik' A, A; Sa, Sa; mato'ketauanieniki, mat'ŏkhsiu. ");
INSERT INTO bla_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kikai'okhtsipuau, ŭk'auanĭstop sauau'toainiki moŏps'pi, kitak'okŏtanĭstotoko: ki sauau'tsĭmĭniki mokhpe'kĭnni, kitak'okŏtanĭstotoko. ");
INSERT INTO bla_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ki kitan'ĭstopuau pinstsĭmmĭm'motsemis sauum'itsitappiuă: ki annŏk' kitakauaiak'iokŏk kĭtsets'stoksĭs matoko'tsĭs ki mat'stoksĭs'. ");
INSERT INTO bla_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ki matap'pi makitotsĭssĭp'puyĭssaie au'kŏkitsĭmaii, ki stakhts'isokŏsĭm mŏk'otsĭsaie, mat ŭn'nĭstotsĭs kisau'tŭtsisokŏsĭm. ");
INSERT INTO bla_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ki annŏk' kĭtsitappa'atsokŏk tuks'ka ŭskskak'sĭnni, pokom'ĭs na'toki iskskaksĭnni. ");
INSERT INTO bla_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Annŏk' kitau'kŏmŏnikŏk, ko'tsĭs, ki annŏk' kitai'akŭkkumatŭkok, pino'tŭkaatsis. ");
INSERT INTO bla_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kikai'okhtsipuau ŭk'auanĭstop kitak'ŭkomĭmmau kitopokau 'pimokă ki kitak'aukĭmaukikakhtum'o. ");
INSERT INTO bla_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ki kitan'ĭstopuau ŭkomĭm'mĭsau kikakhtum'ix, Atsĭm'mĭmmĭsau anniks'ĭsk matap'pixk kitai'pakosĭnikokoauaxk ŏkhs'ĭstutosau anniks'ĭsk matap'pixk kitau'kĭmokoauaxk, ki aua'tsĭmoiikatomosau anniks'ĭsk matap'pixk kitse'ksĭstotokoauaxk, ki kitai'kĭmatsĭstotokoauaxk; ");
INSERT INTO bla_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kokaukosĭmmi'ĭssuai Kĭn'oau spots'im: tŭk'ka ikkŭnats'iuaie natos'i sauum'itsitappix ki ŏkh'sitappix, ki soio'tŭmstuyiuax mokŏm'otsitappix ki sau'okŏmotsitappix. ");
INSERT INTO bla_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ukomĭm'mainoainikiau anniks'ĭsk matap'pixk kitŭk'omĭmmokoauixk, tsaak'anĭstappiuats kisa'kinosuai? Kŭttomŭnĭstauŭkomĭmmotsein'axau publicanix? ");
INSERT INTO bla_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ki namiksematsĭm'ainoainikiau kĭxokoax, tsanĭstapiu'ats kumutaumotsapiau stsĭk'ix? Kŭttomŭnĭstaiksematsĭmmotseiu'axau publicanix? ");
INSERT INTO bla_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ki sŭp-puiap'sĭk manĭst'sŭppuiapspi kĭn'oau spots'im. ");
INSERT INTO bla_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ISKSKATS'ǏK kŏkstau'kŏmmotsitappiisuai matap'pix kŏkainu'yĭssi; ikŭmits'tsiki kĭn'oau spots'im kimataksakinosŭkoauats. ");
INSERT INTO bla_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mak'aumŭtskotŭkkieniki pinik'it manĭstsik'ipi aiksĭstapokŏmotsitappikasix itai'puyĭssax natoi'apioyists ki moksoku'ĭsts, matappix mŏksĭnnu'yĭssax. Kitau'mŭnĭstopuau sakino'sattaiau. ");
INSERT INTO bla_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ki aumŭts'kotŭkkieniki pinsksĭnĭs' i'aksĭssautsĭs kinet'otsĭsi otai'ĭstutsipi; ");
INSERT INTO bla_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mŏksisĭmĭs'si kitaumŭts'kotŭksĭnni; ki Kĭn'a, aisĭmmiŭs'sŭppiuŏk, kitaksĭnnoam'sakinosŭk. ");
INSERT INTO bla_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ki atsĭmoi'ikainoeniki pinet'omanĭstsĭk aiksĭstap'okŏmotsitappikasix: otŭk'ometsĭmanoaiau mŏkauatsĭmoiikasau otsitai'puyisau natoi'apioyists ki moksoku'ĭsts itsi'kokeĭsts, matap'pix mŏksĭnnu'yĭssau. Kitau'mŭnĭstopuau, sakino'sattaiau. ");
INSERT INTO bla_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ki Ksĕsto'a, a'tsĭmoiikainiki, ĭstsipi koko'ai, okĭm'ĭniki, a'tsĭmoiikamĭs kĭn'a ai'sĭmmiapsiuă; ki kĭn'a, aisĭmmiŭs'sŭppiuŏk, kitaksĭnnoam'sakinosŭk. ");
INSERT INTO bla_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ki atsĭmoi'ikainoeniki piniksĭstape'puawtsĭs, manĭstaiksĭstapepoattopiauaie saie'tŭkkix: tŭk'ka ŭs'taiau ak'aiokhtokiau otakai'puyĭssau. ");
INSERT INTO bla_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pinet'omanĭstsik, tŭkka Kin'oau ĭsksĭnĭm'ests kitsipu'ĭnakitsipists kitsauomauan'ĭstopi. ");
INSERT INTO bla_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ŭn'anĭstŭttsĭmoiikak: Nĭn'an spots' im kitsitau'pipi, ŭnanĭstatsĭm'metsĭs kitsĭn'ikŏsim: ");
INSERT INTO bla_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ŭnanĭsto'tos Kitotŭmap'sĭnni: spots'im Kitsitsi'tan kanĭs'tutsipi, annom' ksŭk'kum nokŭt'anĭstutsit: ");
INSERT INTO bla_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Annok' ksĭstsiku'ik nokkok'inan aau'ŏssĭn: ");
INSERT INTO bla_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ki ŭnniksksĭnĭt'au nitsauum'itsitappiisĭnanĕsts, manĭstŭs'ksĭnoawpi anniks'ĭsk matap'pixk nitsauum'itsĭstotokinanĭxk: ");
INSERT INTO bla_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ki pinĭstskĭm'ŭkĭnan, ki nokitsikŏmotse'piŏkĭnan Sauum'itsitappiuă; kitŭsk'sainaniau nĭn'naiisĭnni, ki otŭnmap'sĭnni, ki ĭstsapĭna'sĭnni. Amen. ");
INSERT INTO bla_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ŭnniksksĭnno'ainoeniki matap'pix otsauum'itsitappiisuauĕsts, Kin'oau spots' im kitak'oksksĭnokoau. ");
INSERT INTO bla_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ki sauoksksĭno'ainoemki matap'pix otsauum'itsitappiisuauĕsts, Kĭn'oau Spots'im kimatakoksksĭnokoau'ats. ");
INSERT INTO bla_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kŭttaioyienoeniki pinomŭs'sŭppik manĭst'omŭssŭppipiau ksĭstapokŏmotsitappikasix: tŭkka iksĭstuts'imiau ostokso'auĕsts, matap'pix mŏks'ksĭnoŏsax kŭttaau'yiau. Kitau'mŭnĭstopuauŭk'otsimiau saiakinosattopiau. ");
INSERT INTO bla_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ki ksĕsto'a, kŭttaiau'yeniki pu'ikĭniit, ki ĭssĭs'kiosit; ");
INSERT INTO bla_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Matap'pix kŏkstai'ĭsksĭnokiau kikŭtauyi, kŏksksĭnnu'yĭssi Kĭn'a aisĭmmiŭssŭppiuă: ki Kĭn'a aisĭmmiŭs'sŭppiuă kitaksĭnnoam'sakinosŭk. ");
INSERT INTO bla_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Pinaumoi'potosik akau'tsapsĭnni annom' ksŏk kum, apŭn'ix ki apĭssu'yei otsĭts'oyipi, ki kŏm os'iepĭtsix otsipĭs'sax ki otsikŏmos'sax: ");
INSERT INTO bla_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ki aumoi'potosik akau'tsapsĭnni spots'im, apŭn'ix ki apĭssu'yei otsitsau'oyipiau, ki kŏmosiepitsix otsitsauaisisŭppokatŭn'akiipiau ki otsitsauai'kŏmospiau: ");
INSERT INTO bla_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Itstsi'piau kitsinan'ĭsts, ŭn'nimauk ku'skĕttsipŏppi. ");
INSERT INTO bla_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mostŭm'i ĭsta'natsii moŏps'piina; nituks'kŭssi koopspi, kostŭm' ak'otuitsiu anat'sii: ");
INSERT INTO bla_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ki koŏps'pi minĭx'ĭssi, kostŭm'i ak'otuitsiu ski'natsii. Anat'sii annik' i tsĭspsts'tsiik kostŭm'i ski'natsĭssi maum'aumŭko ski'natsĭnni! ");
INSERT INTO bla_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tukskŭm matap'pi matokotsapotomoyiuatsax na'tokŭmix nĭn'ax: aksikŭmokkĭmiu tukskum ki aks'ikŭmŭkomĭmmiu stsĭk'i; akikŭme'eniu tuks'kŭm ki aksikŭm'ĭstsĭmmĭmmiu stsĭk'i. Kimatokotapotomoauaxau Ap'ĭstotokiuă ki sauum'itsitappiuă. ");
INSERT INTO bla_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ŭnnikaie kitan'ĭstopuau pinap'itsitatoat kitsipai'tappiisĭnni kitaks'oattoppi ki kitak'sĭmattoppi: ki pinap'itsitatoat kostŭm'i kitai'aksŭpskawsattoppi. Tse'ka ĭsskĭts'tau opai'tappiisĭnni ki aau'ŏssĭn, mostŭm'i ki istotos'ists? ");
INSERT INTO bla_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sŭm'mokau paiu'tax: mat'omaiinsĭmmauaxau ki matomaipokiakiuaxau, ki matomaumoipotŭkkiii'axau ĭnsĭm'apioyĭsts; ki Kĭn'oau spots'im ai'ĭssoyiuax. Tŭkka' ĭsskĭts'tau, ksĕsto'a ki osto'auai? ");
INSERT INTO bla_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ŭs'tainoeniki kŏk'spitappiisuai, tsiksĭm a' ak'aatspitappiiu? ");
INSERT INTO bla_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kumauk'apaitsitatoppuaisksistsaii ĭstotos'ists? Sat'sĭkau anat'suiopokists itai'sŭskiiau; matapotŭkkiu'astsau, matapĭs tutŭkkiu 'ăsts'au ĭstotos'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ki kitan'istopuau Solomon otstsap'ĭstotossi mat skĭt stom'atsĕsts annists'isk suio'pokistsk. ");
INSERT INTO bla_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Is'totosatstopiĕsts saiŭs'kiĭsts manĭstĭs'totosatstoppiĕsts annĭsts'ĭsk annok' ksĭstsikuik na'paitappiiisk ki apinŏk'wĭs apittŭp'apĭxipiau ĭstsi'i: kikŭttomaiakstaiĭsttŭpĭstotosatskokoauats, kitsenŭk'aumaitŭkkipuau. ");
INSERT INTO bla_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ŭn'nikaie pinapai'tsitatoak kŏk'anĭssuai Tse'a nŏks'auattopĭnan? Ki, Tse'a nŏk'sĭmattopĭnan; ki; Tse'a nŏks'ĭstotosattopĭnan? ");
INSERT INTO bla_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Tŭk'ka annists'isk, Gentiles ap'ŭssatsĭmĕsts:) Kĭn'oau spots'im ĭsksĭnĭm'aie kitsĭm'mŭkitatosĕsts. ");
INSERT INTO bla_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ki Matom'apsatsĭk Ap'ĭstotokiuă otsĭn'naiisĭnni ki otokŏmotsitappiisĭnni ki annists'isk kitak'ŭtokŏnokokĕsts. ");
INSERT INTO bla_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ŭn'nikaie pin ap'itsitatok apinok'wis; api'nok'wis ak'apitsitasiu. Tuks'kai ksistsikui, maka'pi sup'anistsiu. ");
INSERT INTO bla_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","PINOKŎK'ITSIMAK ki kimatakokŏkitsĭmŭk o'a ");
INSERT INTO bla_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kanĭstau'kŏkitsĭmapuai kitakanĭstaukŏkitsĭmŭkosuai; ki kanĭstau'kotawpi kitakanistau'kuyĭssi. ");
INSERT INTO bla_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ki kumauk'satsiks kĕskŭn' osŭppa'kŏmosĭnni, ki kimatstatopats kitomŭksŭppa'kŏmosĭnni? ");
INSERT INTO bla_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ki kikŭttaukot'anĭstau kĕskŭn' nŏk'sauautsĭssi kitsŭppa'kŏmosĭnni; ki sat'sit, omŭk'o kitauŭtsŭppa'kŏmosĭnni? ");
INSERT INTO bla_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kitsiksĭstapo'komotsitappiansi, Matom'-sauautsit kitomŭk'sŭppakŏmosĭnni, ki kitakotŭmsokapsatsip kŏksauautsĭssi kĕskŭn' o sŭppa'kŏmosĭnni. ");
INSERT INTO bla_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Annists'ĭsk natoap'ĭstsk piniko'tokau imitax, ki pearls pinitŭp'ĭstŭpapixikau ak'sĭnix, ŏksĭkkŭmitauau'ŏkaiau ki akotŭmotŭkau'auyiau ki kitak'otŭmsixipok. ");
INSERT INTO bla_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Anik: ki kitak'okoko; apsatsik, ki kitak'okonip; ĭstok'iakik, ki kitaksikauai'pixĭk. ");
INSERT INTO bla_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Anniks'isk matap'pixk au'kŏmŏnixk au'kuyiiau; ki annŏk' ap'satsĭmŏk, au'konĭmaie: annŏk ĭstok'iakiuŏk, otak'sikauaipĭxikaie. ");
INSERT INTO bla_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tŭkka' nĭn'naua, aukŏm'ŏnĭstŭssi okku'i napaiĕn, aiakokotsiuaie okotoki? ");
INSERT INTO bla_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ki aukŏm'ŏnĭstŭssi mammi', aiakikotsiuaie pĭtse'ksĭna? ");
INSERT INTO bla_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ksĕsto'au, kitsauum'itsitappiipuau, ĭsksĭnĭm'enoainiki kŏk'okotosuai ko'kosoauax ŏkh'sĭsts, Kĭn'oau spots'im kŭttomaiakokotsiu'atsax ŏkh'sĭsts anniks'isk matap'pixk otau'kŏmŏnikixk? ");
INSERT INTO bla_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kanĭst'sitsitatopnai matap'pix kŏkŭnĭstsitsitaiĭssuaiau, kitak'ŭnĭstsitsitattaiau: ŭnnianĭstap'piu okŏk'itsĭmani ki prophetix otse'puawsuai. ");
INSERT INTO bla_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Apŭt'okĭtsĭmi pi'ik; sokokĭt'sĭmi apŭk'oksokui itŭp'itsiiau akotap'sĭnni, ki akai'tappii itsipim'ix: ");
INSERT INTO bla_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Annik' kĭtsĭm'ik, ki annik' moksoku'ik itŭp'itsiikiau opai'tappiisĭnni, aput'tsiiau; ki unna'tsitappii ikon'imix. ");
INSERT INTO bla_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Stim'nokau ksĭs'tapatoiapiekuax kit'sitotaakĭxk emŭk'ikĭnaĭstotosĭxk, ki o'pĭstokĭni itapis'onotsiau. ");
INSERT INTO bla_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kit-aks'ksĭnoaiau otsĭn'asoauĕsts. Matap'pix kŭttomautuyiu'atsauax ksĭssi'ix mĭn'ĭsts, ki ksĭs'tapsŭskiĭsts kŭttomautsĭm'axau figs? ");
INSERT INTO bla_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Neto'i kŏnai'ŏkhsĭstsix ai'ŏkhsĭnasiau: ki makap'ĭstsix makap'inasiau. ");
INSERT INTO bla_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ŏkhsĭstsĭs matokotokapinasiu'ats, ki makap'ĭstsĭs matokot'ŏkhsinasiuats. ");
INSERT INTO bla_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kŏnai'istsix kŭttaŏkhsinasiix kakiok'au, ki ĭs'tsi itsĭs'tŭpapiksĭstaiau. ");
INSERT INTO bla_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ŭn'nikaie kitaks'ksĭnoaiau otsĭn'asoauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kŏnai'tappixk nitan'ikixk, Nin'a, Nin'a, matakokŏnitaipim'axau spots'im ĭsts'ĭn'naiisĭnni: annŏk' ap'ĭstutsĭmŏk Nin'a spots' im otsitsi'taniaie, ai'akitsipim. ");
INSERT INTO bla_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Annik' ksĭstsiku'ik akai'tappii nitak'anikiau, Nin'a, Nin'a, nikŭttomaisĭtsipspinanats kĭtsĭn'ikŏsĭm? Ki nikŭttomaisŭskounaniauaxau sauum'itsistaawx kitsĭn'ikŏsim? Nikŭttommutaipĭssatskaspĭnana kitsĭn'ikŏsim? ");
INSERT INTO bla_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ki nitakotŭmanĭstaiau, kimats'ksĭnopu aua; Mĭstŭpa'akik, ksĕsto'au kitsauum'itsĭstutsipuaii. ");
INSERT INTO bla_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Annŏk' aiokh'tsĭmiuŏk annĭsts'ĭsk nĭtse'poawsĭstsk aks'ĭstutsiu mokŏkiiĭn'ai annŏk itokhĭt'okoĭskauŭk ok'otoki: ");
INSERT INTO bla_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ki ai'sotau, ki ai'sauksikĭmskau, ki ai'sopu, ki annik' napioyĭs itot'sŭppu; ki matsĭstokhopiu'ats; tŭk'ka, itokh'itokoĭskau ok'otoki. ");
INSERT INTO bla_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ki annŏk' aiokh'tsĭmiuŏk annists'isk nitse'poawsĭstsk, ki matsĭstutsim'atsĕsts aks'istutsiu mattsapsĭn'ai, annŏk' itokhit'okoĭskauŭk spŏts' ikui: ");
INSERT INTO bla_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ki ai'sotau, ki ai'sauksikĭmskau, ki ai'sopu, ki annik' nap'ioyĭs itot'sŭppu; ki ĭstokhopi'u; ki omŭk'o otsĭs'tokhopiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ki ŭn'nitsiu, Jesus otaiksĭste'poattosĕsts annists'isk epo'awsĭstsk, matap'pix skaie'tŭkkiau otsksĭnĭmats'tŭksĭnni; ");
INSERT INTO bla_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ototŭmap'sĭnni itŭs'ksĭnĭmatsiuax, ki sĭnak'ix manĭstŭs'ksĭnĭmatsawpiax, matŭsksĭnĭmatsiu'atsax. ");
INSERT INTO bla_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","OTSĬN'NĬSAATOSSI nitum'mo akai'tappiii itopokiuo'iauaie ");
INSERT INTO bla_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ki, satsĭk, nĭnuau leper otsittotaakaie ki otsĭt'atsĭmmĭmmokaie, Id otsĭt'anikaie, Nin'a, atsi'tatomĭniki kitokotsiksĭxistotok. ");
INSERT INTO bla_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ki Jesus itsau'ksikĭnstsiakiu, ki itsĭxen'iuaie, ki an'iu, nitak'anĭstutsip; ksĭksĭt'. Ki soksiksĭk'siuaie. ");
INSERT INTO bla_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ki Jesus anĭstsiuaie, Sat'sĭt, pinaiitsinikos matap'pi; mĭs'taput, annĭs'tsĭnnosattsĭs natoi'apiekuŭn, ki aniiik' otan'ipik Moses ĭssa'kumŭtskotoat mŏks'ksĭniĭsau. ");
INSERT INTO bla_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ki Jesus otsito'taipiĭssi Capernaum, eĕn'aken'ai otsĭtto'taakaie, ki otau'kŏmŏnikaie, ");
INSERT INTO bla_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ki otan'ikaie Nin'a, anrŏk' nitapotomokŏk noko'ai itsĭs'tokhaitsiu, ai'papuyiu, eks'kaaipuĭnŭm. ");
INSERT INTO bla_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ki Jesus an'ĭstsiuaie, nitak'ittappo nitak'okuttutoau. ");
INSERT INTO bla_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Eĕnaken'ai an'ĭstsiuaie, Nin'a, nimat'sipumapspa kŏkĭtsipĭssi noko'ai: kakse'puyit, ki annŏk' nitapotomokŏk ak'okuttutoau. ");
INSERT INTO bla_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nĕsto'a nitap'otomoki, ki eĕn'akex nitap'otomokiau; ki nitan'ĭstau am'ok mĭs'taput, ki ai'ĭstapu; ki nitan'ĭstau stsĭk'i, puk'siput ki ai'paksipu; ki annŏk' nitap'otomokŏk nitan'ĭstau, am'oi ŭnnianĭs'tutsit, ki au'anĭstutsimaie. ");
INSERT INTO bla_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus otokh'tsĭmsaie, skai'etŭkkiu, ki an'ĭstsiuax anniks'isk matap'pixk ipokiuo'ixk, Kitau'mŭnĭstopuau manĭst'omŭkopi otaumai'tŭksĭnni nimatŭnĭstokonip'ats Israel ĭstauŏsĭn'im. ");
INSERT INTO bla_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ki kitan'ĭstopuau akai'tappii umutautstsipi apinŏk'kuyi ki otsĭt'tistŭkkŏpipi ak'ŭtotoiau, ki akopokau'pimiuax Abraham ki Isaac ki Jacob spots' im ĭstsĭn'naiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ki nĭn'naiisĭnni ĭstokos'ix ak'satŭpiksĭstsiauax ski'natsii; annim asain'sĭnni ki satse'kĭnan ak'itstsiian. ");
INSERT INTO bla_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus an'ĭstsiuaie eĕnaken'ai mĭs'taput, kanĭst'aumaitŭkkipi kitakŭnĭsttutoko ki annŏk' otap'otomokŏk itsok'okuttutoau. ");
INSERT INTO bla_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ki Jesus otsĭtsipĭssaie Peter oko'aiaie, nannuyiuaie otokem'ani o'ksĭstsiaie itsĭs'tokhaitsiĭnaie, ai'okhtokĭm pŭs'tsĭmesĭnni. ");
INSERT INTO bla_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ki kaien'ĭmaie otsĭssi, ki pŭs'tsĭmesĭnni itskĭmaie: ki itsipuau', ki ito'yiuax, ");
INSERT INTO bla_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Autŭkkus'si ito'tsĭpotuyiauaie akai'tappiiau sauum'itsistaawx pakh'tokĭnattsiikiauax: ki otse'poawsĭnni itsa'tŭpiksĭstsiuax staawx, ki ikut'tutuyiuax ikŏnai'okhtokosix: ");
INSERT INTO bla_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mŏks'enŭpanĭstosi otan'ipiaie Esias prophet, ki an'iu, Osto'i mat'sĭmĕsts kĭtsauŭt' tsikotsapsĭnunĭsts, ki ipa'tomĕsts kitokh'tokosĭnunĭsts. ");
INSERT INTO bla_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus otsĭnno'ŏssax akai'tappiiĭx oto'tŭksipuyimokax, ikŏk'itsĭmau mŏk'opŭmmosau. ");
INSERT INTO bla_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ki tukskŭmĭni aisĭnaki'ĭna itoto'yĭnaie ki an'ĭstsiuaie, Nin'a kitak'ittappopi nitak'opokiuo. ");
INSERT INTO bla_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus an'ĭstsiuaie, ota'tuyix au'ŏttsimaniau, ki paiu'tax au'yiiiau; ki Nĭn'nau okku'yi matsĭstokhotom'atsaie otokŏn'. ");
INSERT INTO bla_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ki stsĭk'i otŭsksĭnĭmats'aie an'ĭstsiuaie Nin'a, nŏk'otomitappo nŏk'akitsŏsi nĭn'a. ");
INSERT INTO bla_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ki Jesus an'ĭstsiuaie, sŭppa'kit; ki enix ŭnanĭstak'itsŏsauax enix. ");
INSERT INTO bla_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ki otsŭppopĭs'si akh'iosatsĭs, otŭs'ksĭnĭmatsax ipokitsŭppo'piiax. ");
INSERT INTO bla_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ki satsit iek'opaikĭmskau, ki ai'sikopaikĭmskau akh'iosatsĭs; ki ai'okau. ");
INSERT INTO bla_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ki otŭs'ksĭnĭmatsax otsĭt'totaakikax ki otsitsiksekenokikax, ki an'ĭstsiikiauaie, Nin'a kŏmotse'piokĭnan: nitaks'ĭnetspĭnan. ");
INSERT INTO bla_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ki an'ĭstsiuax kumauk'sikopupuauaisks kitsenŭkumaitŭkkipuan? Itŭmit'sipuau, ki ai'sĭtsĭpsattomĕsts sopu'ĭsts ki pai'kĭmskaiĭsts; ki ikŏnau' maitsiĕsts. ");
INSERT INTO bla_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ki nĭn'ax skai'etŭkkiau, ki an'iau, Tsŏkhtanĭstap'ĭnanŏkhtauts, sopu'ĭsts ki omŭk' sikĭmi manĭstse'tokĕsts? ");
INSERT INTO bla_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ki otopŭmmo'si Gergesenes ĭstauŏsĭn'im ito'tatsemiauaie natsitappii sauumitsistaawx pakh'tokĭnattsiikiax, aken'imanĭsts itsŭx'iax, eks'kainixiikiax, matap'pi matokottotsitsko'pats. ");
INSERT INTO bla_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ki satsit, aisokse'puyiau, ki an'iau, Tsaakanĭstappikitsĭmattopĭnan, ksĕsto'ă ki nĕstŭnan, Jesus, Ap'ĭstotokiuă okku'yi? Kikŭt'tautotopa kŏkkĭtsikĭmatsĭstotoksĭnan otsauomo'tosi itaiksĭstsikumiopi kŏk'kĭtsikĭmatsĭstotoksĭnan? ");
INSERT INTO bla_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ki Pĭstsĭksi'pio akaiĕm ak'sĭnix itau'yiau. ");
INSERT INTO bla_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ki sauum'itsistaawx au'kŏmŏnĭstsiauaie ki an'ĭstsiauaie, saiai'pixĭkĭnaniki, nŏk'itsipĭsĭnaniau ak'sĭnix. ");
INSERT INTO bla_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ki an'ĭstsiuax kŭkku'. Ki otsŭksax, ak'sĭnix itsipim'iax: ki, satsit, kŏnak'sĭnix itsĭn'aukskasiau inno'tsĭstŭppakui, ki omŭk'sikĭmi suioks'kasattomiau, ki inets'iau. ");
INSERT INTO bla_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ki anniks'ĭsk matap'pixk ŭsks'kŭmiĭskax itsĭs'tŭpaukskasiau, ki akap'ioyĭs itsipim'iau ki ai'itsĭnikŏttsiauax, ki anniks'ĭsk matap'pixk pakhtokkĭnattsixk sauum'itsistaawx mats'itsĭnnikŏttsiauax. ");
INSERT INTO bla_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ki, sat'sĭt, Kŏnai'tappix ikŏnai'sŭxkitsĭmiau akap'ioyĭs mŏkittotatsemŏsau Jesus: ki otsĭnno'ŏssauaie, au'kŏmŏnĭstsiauaie mŏks'ĭstapusaie otau'ŏssuai. ");
INSERT INTO bla_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","KI itsŭppo'piu akh'iosatsĭs, ki ito'pŭmmo ki otauŭtakap'ioyim ito'to. ");
INSERT INTO bla_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ki, sat'sit, itotsĭp'iauaie nĭn'nau, ai'pakhpuyiu, ĭstokhai'tsiu ŭksĭn': Ki Jesus otsĭnĭs'saie otaumai'tŭksuaiax anĭstsiuaie ai'pakhpuyiuă, Noko'a, ŏkh'sitŭkkĭt; kitsauum'itsitappiisĭsts ĭsksĭnip'iau. ");
INSERT INTO bla_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ki, sat'sit, stsĭk'ix ai'sĭnakix ĭstai'au am'o (nin'nau) makapie'puyiu. ");
INSERT INTO bla_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ki Jesus ĭsksĭnĭm'ĕsts otŭs'tapuauĕsts ki an'iu, kumauk'itsitatopuauaisks maka'pi ku'skĕttsipŏppuauĕsts? ");
INSERT INTO bla_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tsĭm'a ksĭstspa'pi, kŏk'ansi, kit sauum' itsitappiisĭstsĭsksĭnip'iau; ki kŏk'anĭsi, Nipuat' ki auŏkat'? ");
INSERT INTO bla_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ki kŏks'ksĭniisuai Nin'a okku'yi ikŏts'ksĭnĭmĕsts sauum'itsitappiisĭsts annom' ksŏkkum (itŭm'anĭstsiuaie aipakhpuyii) Nipuat', matsit' kitŭk'sĭn, koko'ai is'taput. ");
INSERT INTO bla_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ki itsipuau' ki oko'ai itsitap'po. ");
INSERT INTO bla_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ki akai'tappiii otsĭnĭs'sax, skai'etŭkkiau, ki a'tsĭmmĭmmiauaie Ap'ĭstotokiua annŏk' ikotsiu'ŏk matap'pix otŭmap'sĭnni. ");
INSERT INTO bla_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ki Jesus otaumatto'si, nannuyiuaie nĭn'nau, an'ĭstau Matthew, itaupii'ĭnai itai'ponitatopiaie, ki an'ĭstsiuaie Sŭppa'kĭt. Ki itsipuau' ki pokio'attsiuaie. ");
INSERT INTO bla_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ki ŭn'niitsiu Jesus otsitsĭps'taupĭssi nap'ioyĭs, otau'yĭssi, sat'sĭt akai'tappiiau publicanix ki sauum'itsitappix, itsito'taipimiau ki ipokau'pimiauax (Jesus) ki otŭs'ksĭnĭmatsax. ");
INSERT INTO bla_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ki Pharisees otsĭnno'ŏssax, itŭnĭs'tsiauax otŭsksĭnĭmats'axaie. Kitsĭn'aimoau maukopoks'oyimiax publicanix ki sauum'itsitappix? ");
INSERT INTO bla_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus otokh'tsĭsaie, an'ĭstsiuax, anniks'ĭsk matap'pixk ikut'totoaxk matsĭmmŭki tappi'uaxau assokinakki, anniks'ĭsk matap'pixk ai'okhtokosixk kĭmŭk'ĭttappiiau. ");
INSERT INTO bla_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Is'tapuk, ŭs'ksĭnĭk manĭstap'ipi, nitŏkh'sitsip kĭm'apiisĭnni, ki nimatŏkhsitsipats ikĭt'stŭksĭnni: tŭk'ka nimat'ŭtotopa nŏk'ainikŏttosau mokŏm'otsitappix mŏks'isauaitsitasau, sauum'itsitappix nimut'oto. ");
INSERT INTO bla_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","John otŭs'ksĭnĭmatsax otsitŭm'ittotaakax, ki an'iau, Tsanĭstapiu'ats nimutsauau'yipĭnan nestŭn'an ki Pharisees, ki kĭtŭsksĭnĭmatsax kŭttaisauauyiu'axau? ");
INSERT INTO bla_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ki Jesus anĭstsiuax kŭttaukotau'yesiuaxau man'okkemiuŏk oko'ai ĭstokos'ix, itsa'kiitawpĭssi man'okkemiuŏk? Ki annists'isk ksĭstsiku'ĭsts ak'otoiau man'okkemiuŏk otai' akitotoawpĭstskaie, ki akotŭmsauau'yiau. ");
INSERT INTO bla_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kimatanipsospuau makap'isokŏsists; annik' psak'sĭnik aksoksipinikau ki saku'apĭnikan aksistŭpaipinikau. ");
INSERT INTO bla_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Matap'pix matomaisŭppasuyĭnĭmĕsts mani'ĭsts mĭn'iokkeĭsts ŭkautokeĭssuyĭnĭsts, ŏks'kakŭmipinikau ŭk'autokeĭssuyĭnĭsts, ki mĭn'iokke ak'saikĭmsskau, ki aks'iksistsuyinasiau: Manĭn'iokkeĭsts itsŭppa'suyĭnĭmiau man'otokeĭssuyĭnists ki ai'aketŏkhsiau. ");
INSERT INTO bla_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Otsakiaisĭtsĭp'sattosax annists'ĭsk epo'awsĭsts, tukskŭm'ĭni eenakin'ai itoto'iĭnai ki a'tsĭmmĭmmiuaie, ki an'iu, Nitŭn'na ŭk'ainiu; puk'siput ki kotsĭs'i tsĭxen'ĭs, ki aks'ipui tappiiu. ");
INSERT INTO bla_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ki Jesus itsipuau', ki itopokom'iuaie, ki otŭsksĭnĭmatsax mat'opokomiauaie. ");
INSERT INTO bla_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ki sat'sit ake'uă, au'atŭnikau ŭsksaumawksaikĭmskau otok'tokossĭnni na'tsikoputtuyi stuyi'ĭsts, itsŭp'paatsiuaie, ki itsĭx'enĭmaie opekakŭn'ĭmaniaie: ");
INSERT INTO bla_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tŭk'ka, ĭs'tau, ksen'ĭmĭniki opekakŭn'ĭmani, nĭtak'okuttotoko. ");
INSERT INTO bla_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ki Jesus ito'tŭkkau; ki otsĭnno'ŏssaie, itŭni'u, Nitŭn'na, ŏkh'sitŭkkit, kitaumai'tŭksĭnni kumut'okuttotoko. Ki ake'uă annik' itokut'totoau. ");
INSERT INTO bla_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ki Jesus otsĭtto'taipiisi eenakin'ai oko'ai, ki otsĭnno'ŏssax au'yesĭx ki matap'pix eĭs'tsekĭniau, ");
INSERT INTO bla_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","An'ĭstsiuax, anĭs'tapaauk, ake'kuŭn matseniu'ats, ai'okau. Ki itai'ĭmiauaie. ");
INSERT INTO bla_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ki otsĭs'tŭpskoŏsax matap'pix, itsipim, ki ito'tsĭmaie, otsĭs'aie, ki ake'kuŭn itsipuau. ");
INSERT INTO bla_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ki otap'ĭstutsipi, annik' auŏsĭn'ik, motŭs'ksĭnĭpaie. ");
INSERT INTO bla_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ki Jesus otsĭstŭpaumatta'atossi, na'tokŭmi naps' tsix nĭn'ax ipokiuo'iax, ki aisokse'puyiax ki an'iau, David okkui', Kĭm'okĭnan. ");
INSERT INTO bla_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ki otsĭtsipĭs'si nap'ioyĭs, naps'tsix itoto'yiauaie: ki Jesus an'ĭstsiuax kikŭtau'maitsipuan nŏk'okotŭnĭstutsĭs? An'ĭstsiiauaie A, Nin'a. ");
INSERT INTO bla_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Itŭm'itsĭxeniuax oŏps'puauax, ki itŭni'u, kanĭsto'maitsipuai, ŭnnianĭstsĭs'. ");
INSERT INTO bla_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ki itsikau'opiii oŏps'puauax: ki Jesus saiemiuax mŏkstanĭs'tosax matap'pix. ");
INSERT INTO bla_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ki osto'auai, otsĭs'tapusau ikŏnai'tsĭnnikoyiauax matap'pix annik'auŏsĭn'ik. ");
INSERT INTO bla_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ki otsŭksax, sat'sit ito'tsĭpiauaie kŭttaiai'puyiua sauum'itsistaaw pakto'kĭnattsiuaie. ");
INSERT INTO bla_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ki sannm'itsistaaw otsai'piksĭstŏssaie, kŭttaiai'puyină itse'puyiu: ki kŏnaitappix skai'etŭkkiau, ki an'iau, matsĭkainip'ats Israel ĭstauŏsĭn'im. ");
INSERT INTO bla_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ki Pharisees an'iau sauum'itsistaawx otsĭn'aimoauai itai'saipiksĭstsiuax sauum'itsistaawx. ");
INSERT INTO bla_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ki Jesus itap'auauŏkau kŏnau'akapioyĭsts, ki inŭk'akapioyĭsts, ki itŭs'ksĭnĭmatstokiu ota'toiapioyimoauĕsts, ki ai'semokiu nin'naiisĭnni ĭstŏkhs'itsĭniksĭnni, ki ŏk'kuttutsĭmĕsts matap'pix otokŏnai'oktokosuauĕsts ki otokŏnau'atŭnikauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ki otsĭnno'ŏssaie otappiisĭn'na, kaiĭm'iuaie, tŭkka ŭs'tsĭmsiu, aneto' manistau'anetopiax emŭk'ikĭnax saiits'tsĭssi ŭsks'kŭmokiuă. ");
INSERT INTO bla_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Itŭman'ĭstsiuax otŭsksĭnĭmatsax, akauo'yi insĭn'manĭsts, ki ap'otŭkkix unna'tosĭmiau; ");
INSERT INTO bla_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Atsĭm'oiikŭttok ĭnsĭm'manĭsts ĭstsĭn'nau mŏk'itŭpskoŏsax otĭnsĭmmanĭsts apotŭkkix. ");
INSERT INTO bla_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","OTSIPUK'SŬPINNIKŎTŬSAX na'tsikoputtsiau otŭsksĭnĭmatsax, ikotsiu'ax otŭma'sĭnni mŏk'saipiksĭstosauax sauum'itsistaax, ki mok'ŏkuttutsĭsax amian'ĭstokhtokosĭsts ki amian'ĭstatŭnikĕsts. ");
INSERT INTO bla_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na'tsikoputtsixk itokŏt'tsiuax otsĭn'ikŏsoauĕsts am'ostsiaukiĕsts; Matom'itappiu, Simon, mat'anistau Peter, ki Andrew oskŭn: James, Zebedee okku'i ki John oskŭn'; ");
INSERT INTO bla_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip, ki Bartholemew; Thomas, ki Matthew, annŏk' publicanŏk; James, Alphæus okku'i. Ki Lebbæus, mat'anistau Thaddæus; ");
INSERT INTO bla_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, Canaanite; Ki Judas Iscariot annŏk' aien'ŭpanistsiuŏkaie. ");
INSERT INTO bla_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Anniks'isk natsikoputsixk Jesus itokŏt'tsiuax ki saiem'iuax ki an'ĭstsiuax, Gentiles oksoku'auĕsts pinitap'pok, ki Samaritans otakap'ioyimoauests pinŭt'sĭtsipik: ");
INSERT INTO bla_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ki Israel oko'au otomŭk'ikĭnaumix ats'ax ĭs'tapuk. ");
INSERT INTO bla_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ki auau'ŏkainoniki sem'okik, ki anik', spots'im ĭstsĭn'naiisĭnni aststsiu'. ");
INSERT INTO bla_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ai'oktokosix kut'tutokau, leperix ĭssin'nomokau, enix' nipua'atsokau, sauum'itsistaawx sai'aipiksĭstokau; Kitsiksist'okoko, ksistoko'tŭkkik. ");
INSERT INTO bla_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gold ki silver ki brass pinitsŭp'pitŭkkik kitsitai'sŭpopumatsopuauĕsts, ");
INSERT INTO bla_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Assuia'tsĭman pinots'ik aumatto'ainoainiki, pinots'ikau na'tokaists spĭks'isokŏsĭsts, ki a'tsikists, ki otoats'ists; ap'otŭkkiuã ak'otsĭmaie otso'ŏsĭn. ");
INSERT INTO bla_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Annik' akap'ioyĭsk kĭtai'akitsipipika sŭppo'ŏttsesatsĭk annok' oks'apsiuok; ki annim' stau'pik kitsauomai'sŭkskitsĭssuai. ");
INSERT INTO bla_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ki pim'ĭnnoainiki nap'ioyĭs, ksematsĭm'attok. ");
INSERT INTO bla_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ki ŏkhs'issi nap'ioyĭs ŭnnianĭstsito'tos kitsĭn'nŭstseisuauĕsts; ki sauŏkhs'ĭssi ŭnnianĭstsska'atok kitsĭn'nŭstseisuauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ki annŏk' kikŭt'tautokŏk, ki kŭt'tauotsĭmikŏk kitse'poawsĭsts, sŭkskitsĭm'ĭnnoainiki annik' akap'ioyĭsk sostsĭk'asattok. ");
INSERT INTO bla_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kitau'mŭnĭstopuau akŏk'itsĭmaiksĭstsikuĭk Sodom ki Gomorrha ak'skĭtstom annik' akap'ioyĭsk. ");
INSERT INTO bla_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sat'sĭk emŭk'ikĭnax mĭs'tŭpskoawkiapis'ix neto'yik kanĭstsĭs'tŭpskopuau: mokŏk'ik manĭstsokŏkipi pitse'ksĭnax, ki ĭkkĭnaps'ik manĭstĭk'kĭnapspi kŭkku'ix, ");
INSERT INTO bla_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ki ŭsks'kŭmokau matap'pix; kitakaumŭts'kaukoau akŏk'itsĭmani, ki otatoi'apioyimoauĕsts kitakitaipstŭsĭstsipĭs'okoau; ");
INSERT INTO bla_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kinĭn'ax ki omŭx'ĭnax kitakittŭpĭp'iokoai, nĕsto'a kumut'aiakaitŭpipiokoai, kŏkkite'nŭpanĭstosau ki Gentiles. ");
INSERT INTO bla_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ki aumŭts'kaukuĭnnoainiki pinstak kŏkŭnĭstse'puyĭsuai; annik' kitak'okokoau kitai'akanipuai. ");
INSERT INTO bla_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kimats'epuyipuau, Kĭn'oau osta'aw ksĕsto'au itsĭpstai'puyiu. ");
INSERT INTO bla_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ki umu'pappiipi akumŭts'kaiuaie umu'pappiipi mŏks'eĭnsi, ki nĭn' a akumŭts'kaiuaie okku'i; ki pokax aksenŭpanĭstaiau un'oauax ki oksĭs'toauax mŏks'enitŏsauax. ");
INSERT INTO bla_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ki kŏnai' tappix kumut'akaukĭmokoaiau nĕsto'i; ki annŏk' eikak'imauŏk umuts'ipaitappiuaspi akitsikŏmotse'piauaie. ");
INSERT INTO bla_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kĭm'atsĭstototsenoainiki tuks'kai akap'ioyĭs, mĭs'tŭpokskasik stsĭk'i: kitau'mŭnĭstopuau kimatakokŏnitotopuau Israel ĭstokŏnau'akapioyists otsauomai'akotosi Nĭn'au okku'i. ");
INSERT INTO bla_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ŭsksĭnĭmats'au matskĭtsĭmiu'ats otŭsksĭnĭmats'tokiuă, ki apotŭk'kiuă matskĭtsĭmiu'ats otsĭn'aim. ");
INSERT INTO bla_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ŏkh'siu ŭsksĭnĭmats'au mŏketŭm'anĭstsau otŭsksĭnĭmats'tokiuă, ki apotŭk'kiuă mŏketŭm'anĭstsau otsĭn'aim. Anĭstsĭn'nikŏttŭsauaie nap'ioyĭs otsĭn'aim Beelzebub, ak'staianĭstsĭnnikŏttaiau itsĭpstaupixk oko'ai? ");
INSERT INTO bla_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pin stŭn'nokau; matsekipats akstaisaiipasokĭnnĭs; matsitsiksĭs'pats ak'staisaiĭsksĭnĭs. ");
INSERT INTO bla_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kĭtse'itsĭnikopuai ski'natsii matai'itsĭnikok ksĭstsiku'inatsii: ki kitai'okhtsipuai kotokhĭs'suai, sem'ik spots' im nap'ioyĭsts. ");
INSERT INTO bla_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ki pinstŭn'nokau anniks'ĭsk akenitomixk mostŭm', ki sta'aw matokotsenĭtsiau'ats: stŭn'nok annŏk' i kots'enĭts iuŏkax mostŭm' ki staaw stakhts'im. ");
INSERT INTO bla_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Natokŭmix sĭstsix kŭttomŭtaiponitau'atsax nitsipŭn'asaini? Ki tuks'kŭm matakittotstsiu'ats ksŏk'kum sauŭs'ksĭnoŭssi Kin'oau. ");
INSERT INTO bla_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kitoku'yikĭnsĭsts ikŏnŭks'topiau. ");
INSERT INTO bla_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Piniko'puk; kitots'ĭtskŭkaiĭxkĭmĭmipuau akaiĕm'ix sĭstsix'. ");
INSERT INTO bla_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Annŏk'aie'nŭpanĭstsiuŏk matap'ii nĕsto'i, osto'i nitaks'enŭpanĭstau nĭn'ă spots'im. ");
INSERT INTO bla_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Annŏk' nĭt'saietokŏk matap'piuŏk, osto'i nĭtak'saietoau nĭn'a spots' im. ");
INSERT INTO bla_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Pinstak nimut'oto ĭnnŭst'sĭnni nŏkitsĭt'apixĭsi ksŏk'kum: nimat'otopa nŏkitsĭt'apĭxĭsi ĭnnŭst'sĭnni, innu'stoan nimut'oto (nŏkitsĭt'apiksĭstos ksŏk'kum). ");
INSERT INTO bla_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nimut'oto nĭn'au ki un'ni mŏk'itsipotsĭstsĭmmotseĭsau, ki otŭn'ni ki oksĭs'tsi, ki ăum'si ki maawks'i mŏkitsipotsĭstsĭmmotseĭsau. ");
INSERT INTO bla_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ki nĭn'au aks'ikatumĭmmiuax otopokau'pimix anniks'isk matap'pixk oko'ai itsĭpsts' taupixk. ");
INSERT INTO bla_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Annŏk' aiĭs'tŭpŭkomĭmmiuŏk un'ni nĕsto'i nimatokotsinanŭk'ats: ki annŏk' aiĭstŭpŭkomĭmmiuŏk oku'yi ki otŭn'ni nĕsto'i nimatokotsinanŭk'ats. ");
INSERT INTO bla_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ki annŏk' sauots'ĭssi otauiĭnan'i sauopokiuo'osi nĕsto'ă, nimatokotsinanŭk'ats. ");
INSERT INTO bla_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Annŏk' ikon'ĭmŏk opai'tappiisĭnni, ak'atstomaie; annŏk' at'stomŏk opai'tappiisĭnni, nĕsto'i itat'stomaie, ai'akokonimaie. ");
INSERT INTO bla_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Annŏk' kĭto'tokŏk nito'tok; ki annŏk' nito'tokŏk ito'toyeuaie annŏk' nitse'tokŭkŏk. ");
INSERT INTO bla_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Annŏk' ito'toyeuŏk prophet otsiprophetisaie otak'okuyĭssi prophet osa'kinosĭnniaie; ki annŏk' ito'toyeuŏk mokŏm'otsitappiuă oto'kŏmotsitappiisaie, otak'okuyĭssi mokŏm'otsitappiuă osa'kinosĭnniaie. ");
INSERT INTO bla_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ki annŏk' ai'akutŭkkuyiuŏk sto'kĭmi tuks'kŭmi anniks'ĭsk inŭks'tsĭmĭxk otŭs'ksĭnĭmatsŏssaie, kitau'mŭnĭstopuau matakatstom'ats osa'kinosĭnniaie. ");
INSERT INTO bla_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","KI un'niniitsiu otai'ksĭstanĭstŏssax na'tsikoputsix otŭsksĭnĭmats'ax itsĭstŭpa'atomaie mŏkŭsksĭnĭmatstoksi ki mŏkatsĭm'semŏksi ot'akapioyimoauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Annok' John itsipsts'taupĭssi itai'okiakiopi otokh'tsĭsĕsts Christ oiapĭstutsipĭsts'aie, itokŏt'tsiuax na'tokŭmix otŭsksĭnĭmats'ax, ");
INSERT INTO bla_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ki an'ĭstsiuaie, kikŭtami'pa annŏk' aiakoto'ŏk, ki nŏk'apsŭmmŏsĭnan noke'tsĭmi? ");
INSERT INTO bla_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus an'ĭstsiuax, mĭs'tapuk, matan'ĭstsĭnnomok John annists'ĭsk kĭtokh'tsipuauĕstsk ki kitŭs'satsipuauĕstsk: ");
INSERT INTO bla_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Naps' tsix ŭs'sŭpiau, ŭs'tsekaiĭx ikŏm'otauauŏkaiau, leperix ĭssin'aiau, kŭttaiai'okhtsĭmix ai'okhtsĭmiau, enix' aipuau'iau ki kĭm'atapsix atsĭmsem'aiau ŏkhs'itsĭniksĭnni. ");
INSERT INTO bla_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ki atsĭm'siu annŏk' kŭttai'itstskĭmskŭkiuŏk nĕsto'i. ");
INSERT INTO bla_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ki otsĭs'tapusax, Jesus otaumŭtŭpaiitsĭnnikoŏsauaie akai'tappix John, Tsanĭstappiuă kumutsitappopuai ksĭs'tapsksŏkkum kŏk'satsipuai? Kŭttaitstsip'a apai' sopu'yi itau'ŭtopăpokaiiu? ");
INSERT INTO bla_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ki tsan'ĭstappiua kumut'sitappopuai kŏk'satsipuai? Kuttaitstsip'a nĭn'naii ĭkikĭn'ĭstotosiu? Anniks'isk ĭkikĭn'ĭstotosĭxk itot'okoyiau Omŭx'ĭnax oko'auĕsts. ");
INSERT INTO bla_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ki tsan'ĭstappiuă kumut'sitappopuai kŏk'satsipuai? Kŭttaitstsip'a prophet? A, kitan'ĭstopuau skĭtsĭm'iuaie prophet. ");
INSERT INTO bla_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Annŏk sĭnau', sat'sit, nitse'tomotokŭttau nito'tokatatsĭsau kostoksĭs', ki ake'tomsokapapĭstutsimaie koksoku'i. ");
INSERT INTO bla_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kitau'mŭnĭstopuau anniks'ĭsk itsipokai'ĭmmokixk akex, mats'itstsipa ŏk'skĭtsĭmiaie John Baptist: ki annŏk' inŭks'tsĭmŏk spots' im ĭstsĭn'naiisĭnni ai'skĭtsĭmiuaie. ");
INSERT INTO bla_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","John Baptist ĭstsiksĭs'tsikuĭsts, puk'sŭpiksĭstsikuĭsts spots'im ĭstsĭn'naiisĭnni itŭsk'o tuitsipiop, ki ŭskotui'tsipimix itŭsk'otuitsipimiau. ");
INSERT INTO bla_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Konai'prophetix ki okŏk'itsĭmani aie'nŭpanistomiauĕsts otsauomo'tosi John. ");
INSERT INTO bla_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ki mak'otsĭmenoainiki, am'auk Elias annŏk' ai'akotoŏk. ");
INSERT INTO bla_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Annŏk itokh'iuŏk mŏk'okhtsĭmsi ŭnanĭststokh'tsĭs. ");
INSERT INTO bla_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tsa nitai'akanipa annŏk' o'tappiisĭnŏk manĭstsĭn'naiipuaiau? Netoinitsi'au pokax annim' itawk'pumauawpim itau'pix ki ai'sĭtsĭpsattsiau otŭk'auauax, ");
INSERT INTO bla_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ki an'ĭstsiauax, kitsik'ŭttomopĭnan ki kimat'spiipuau; kitau'yĭmopĭnan ki kimau'kaiisuauĕsts kimatakipuauĕstsau. ");
INSERT INTO bla_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","John oto'tosi matauyiu'ats ki mataisĭmiu'ats, ki an'iop pakh'tokĭnatsiu sauum'itsistaaw. ");
INSERT INTO bla_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nĭn'au okku'i oto'tosi, au'yiu ki ai'sĭmiu, ki an'iop, sŭm'mĭs, aistoks'oyiu ki aistok'sĭmiu, publicanix ki sauum'itsitappix otŭk'auauax. Ki mokŏk'sĭnni o'kosĭx oto'kŏmotsĭstutokaie. ");
INSERT INTO bla_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Itau'mŭtŭpsĭtsĭpsattomĕsts akap'ioyĭsts annim' otsĭt'apĭstutsipĭsts ot'apĭstutŭksĭsts otsauomai'sauaitsitŭsax. ");
INSERT INTO bla_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kitak'oksĭnip maka'pi, Chorazin! Kitak'oksĭnip maka'pi Bethsaida! Nitsĭt' tsipstsapĭstutsipĭsts kitakap'ioyimoauĕsts nitsĭttsipstsapĭstutŭkkitopiau Tyre ki Sidon ĭstak'apioyĭsts is'taisŭmmisauaitsitauopiau ĭsksĭm'matŭkkiaipĭstsĭsts ki makh'skĭtsĭsts, ");
INSERT INTO bla_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ki kitan'ĭstopuau Okŏk'itsĭmani ĭstsiksĭs'tsikui manĭstaksiksists'papsipi ksĕsto'a, aks'ĭsiksĭstspapiau Tyre ki Sidon. ");
INSERT INTO bla_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ki ksĕsto'a Capernaum, kitspĭn'noko spots'im, hades kitaks'ĭnnĭssimoko; omŭk'apotŭksĭsts kitakap'ioyim itap'ĭstutsipiau ittsipstsapistutŭkkiopiau Sodom, ĭs'taisakiaitaitsiopi. ");
INSERT INTO bla_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ki kitan'ĭstopuau, Okŏk'itsĭmani ĭstsiksĭs'tsikui manĭstaksiksĭsts'papspi ksĕsto'au, aks'ĭsiksĭstspapiu Sodom. ");
INSERT INTO bla_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Annik' Jesus an'iu, nitŏkh'sitŭkki nĭn'a, spots'im ki ksŏk'kum ĭstsĭn'aimi, kitai'ksĭsattokiauests annists'isk mokok'ietappix ki kitaipaso'kĭnomoaiau inŭk'sipokax. ");
INSERT INTO bla_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ŭnnianĭsts'it Nin'a; manĭstŏkh'sipi kitsitsi'tan. ");
INSERT INTO bla_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nin'a otokŏnai'nanĭsts nitokok: ki matsitstsipa ĭsksĭnnu'yiuaie okku'iaie Nin'a nits'ksĭnnuyiuaie; matsitstsipa ĭsksĭnnu'yiuaie Un'ni, okku'i nits'ksĭnnuyiuaie, ki annŏk ĭsksĭnĭmats'stokŏttseuŏk Un'ni. ");
INSERT INTO bla_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Puksipa'akik kŏnai'ikapotŭkkix ki ikŏnŭs'soksĭstsix, ki kitak'okotopuau ĭssĭk'sĭstsikosĭnni. ");
INSERT INTO bla_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nokhkĭn'ni kĭn'attok, ki ĭsksĭno'kik; nitsĭk'kĭnapsi nimat'omŭkimuspa; ki kitak'okonipuau ku'skĕttsipŏppuauĕsts ĭstsĭk'sĭstsikosĭnni. ");
INSERT INTO bla_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nokhkĭn'ni ksĭsts'papiu, ki nitopa'tŭksĭn sŏk'otsiu. ");
INSERT INTO bla_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","AN NIK' Jesus Issĭk'opiiksĭstsikui itsisŭp-poka'atomĕsts napaiĕnĭnsĭmmanĭsts; ki otŭsksĭnĭmats'ax au'notsiax, ki aiin'asĭsts aumŭtŭp'otsĭmiax ki itaumŭtŭp'ioattomiax. ");
INSERT INTO bla_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ki Pharisees otsĭnno'ŏssauax, anĭstsiauaie, sŭm'mĭsau kitŭsksĭnĭmatsax mat'ŏkhsiu otap'ĭstutsipuauĕsts annok' ĭssĭk'opiiksĭstsikuik. ");
INSERT INTO bla_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ki anĭs'tsiuax kikŭttanĭstopuau'ats David otap'ĭstutsipi otau'notssi ki otopokom'ix; ");
INSERT INTO bla_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Manĭst'sipipi Ap'ĭstotokiuă oko'ai, manĭstau'attopiau otsitau'pipi ĭstske'tani annik' kŭt'taŏkhsiik mŏks'auattosi ki otopokom'ix mŏks'auattosaxaie, ki kak'ŏkhsiu natoi'apiekuax mŏksauattosauaie? ");
INSERT INTO bla_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ki kikŭtanĭstopuau'ats okŏk'itsĭmani natoi'apiekuax manĭstap'otŭkkipiau ĭssĭk'opiiksĭstsikui otsitsips'taupĭsau omŭk'atoiapioyĭs kimatsikiu'ats. ");
INSERT INTO bla_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ki kitan'ĭstopuau annom' itstsiu' tuks'kŭm ki skĭt'stom omŭk'atoiapioyĭs. ");
INSERT INTO bla_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ki kitsksĭni'topi manĭstap'ipi nitak'ŏkh-sitsip kĭm'apiisĭnni, ki nimatakŏkhsitsipats ĭkit'stŭksĭnni, kĭs'taisauotui'mauopiau kŭt-tautuitiiaixk. ");
INSERT INTO bla_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nin'a okku'i itsĭn'auattomĭnaai ĭssĭk'opiiksĭstsikiii. ");
INSERT INTO bla_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ota'atsĭstapusi, otatoi'apioyimoai itsipim; ");
INSERT INTO bla_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ki sat'sit, nĭn'au itsĭps'taupiĭnai, ki otsĭs'i ipo'kŏttsiuaie. Ki aisŭppo'ŏtsesattsiuaie, Kŭtai'ŏkhsiuats ĭssk'opiiksĭstsikuĭsts ŏk'okuttotoŏsi? Mŏks'enŭpanĭstŭssauaie. ");
INSERT INTO bla_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ki an'ĭstsiuax, Ŭn'nats nĭn'au kitopokittappi'ĭmmoau maksinan'si tuks'kŭmi emŭk'ikĭna, ĭstsŭp'popiĭssaie atŭn'iaksĭn ĭssĭk'opiiksĭstsikui, Kŭttomai'akstaisautuyiuatsaie? ");
INSERT INTO bla_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nĭn'au kŭttomai'skĭtsimiuats emŭk'ikĭna? Ŭn'nikaie itŏkh'siu mŏk'ŏkhsapĭstutŭksi ĭssĭk'opiiksĭstsikuĭsts. ");
INSERT INTO bla_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Itŭman'ĭstsiuaie nĭn'au, Sauksikĭns'tsiakit. Ki itsauksikĭns'tsiakiu; ki ikut'tutsipaie netoi'nitsiuaie otat'otsĭsi. ");
INSERT INTO bla_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","I tŭmit'sŭksiau Pharisees, ki ikŏnau'kŏk-itsĭmattsiauaie manĭstaks'enitawpiauaie. ");
INSERT INTO bla_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ki Jesus otsksĭnĭssaie, itsĭstapu': ki akai'tappix ipokiuo'iauaie, ki ikŏnau'kuttutuyiuax; ");
INSERT INTO bla_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ki sokap'anĭstsiuax mŏkstaiitsĭnnikoŏsax'aie: ");
INSERT INTO bla_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mŏks'enŭpanĭstosi Esias otan'ipi, ki an'iu, ");
INSERT INTO bla_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Sŭm'mok, nitap'otomok, annŏk' nitse'niniwattauŏk; nitŭk'omĭmmau, nu'skĕttsipŏppi nimut'ŏkhsĭmmau: nitakitsipotoai'ĭnai nitsista'awi ki akanĭs'tsĭnmomoyiuax Gentiles okŏk'itsimani. ");
INSERT INTO bla_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mataketskau'ats mataksoksipŭppisŭm'ats; mat'akitstsipa matap'pi mŏk'okhtsĭsaie otse'poawsists moksoku'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Apai' otŭk'itsĭssi mataksĭnŭkiu'ats: flax setsĭs'si matakŭtsĭm'atsaie otsauomai'tŭpskĭsaie okŏk'itsimani mŏk'itsskitsstani. ");
INSERT INTO bla_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ki otsĭn'ikŏsim Gentiles ak'aumaitsĭmiau. ");
INSERT INTO bla_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tŭks'kŭm ito'tsipotoau pakhts'istŭmattseu Sauum'itsiStaaw, naps'tsiu, ki mataipuyiu'ats: ki ikut'tutuyiuaie, ki naps'tsiuă it'sŭppiu ki kŭttai'puyiuă itse'puyiu. ");
INSERT INTO bla_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ki kŏnai'tappix it'skaietŭkkiau ki aniau kŭtamiu'ats David okkiu? ");
INSERT INTO bla_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pharisees otokh'tsĭmsau, an'iau, Am'o nĭn'au, matomaisaipiksĭstsiu'atsax Sauum'itsiStaawx, Beelzebub Sauum'itsistaawx otsĭn'aimoai, umutai'saipiksĭstopiax ");
INSERT INTO bla_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ki Jesus isksĭnnu'yiuax otŭs'tapiax ki an'istsiuax, Nĭn'naiisĭnni ai'aketotoki ak'eitsĭnikau; ki akap'ioyis ki nap'ioyis aiaketotokiau mataksipuitsiuats: ");
INSERT INTO bla_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sauum'itsitappiuă satŭp'iksĭstussi Sauum'itsitappiuă, aiaketsĭstotosiu; ki otsĭn'naiisinni kŭttomaksipuitsiu'atsaie? ");
INSERT INTO bla_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Satŭp'iksĭstainikiau Sauum'itsiStaawx, Beelzebub nimut'satŭpiksĭstaiau, Tŭkka'ko'kosix itsatŭpiksistsiu'atsax? Ŭn'nikaie osto'auai kitak'okŏkitsĭmŭkoau. ");
INSERT INTO bla_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ki Satŭp'iksĭstainikiau Sauum'itsistaawx Ap'istotokiuă otsista'awmi nimut'satŭpiksĭstaiau Apistotokiuă otsĭn'aiisĭnni kito'taakoai'ĭni. ");
INSERT INTO bla_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mĭskŏpin'ai oko'ai Tsa'akanĭstokotsitsipim'atsaie, mŏk'itauksĭstutsĭsaie ope'kanĭstsaie, sauotŭm'ĭsksipĭstŭsaie mĭskŏpin'ai? Ki ak'otŭmoksĭstutsĭmaie oko'ai. ");
INSERT INTO bla_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Annŏk' nikŭt'taispiimmokŏk, nikŏttum'a: annŏk' nikŭttaupokomoawk'iakimauŏk auanit'apiksĭstŭkkiu. ");
INSERT INTO bla_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ŭn'nikaie kitan'ĭstopuau, amian'ĭstsauumitsitappiisĭnni ki amian'istitŭpsauokŏmotse'poawsists Apĭstotokiuă akitsksĭnoaiau matap'pi; ki annŏk' akitŭpsauo'kŏmotsepuyiuŏk Atsĭm'istaaw matakitsksĭnoau'ats. ");
INSERT INTO bla_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Annŏk' itŭp'sauokŏmotsepuyiuŏk Nĭn'au Okku'i ak'itsksĭnoau, ki annŏk' itŭpsauokŏmotsepuyiuŏk Atsĭm'iStaaw mat'akitsksĭnoau'ats annom' ksŏk'kum ki aie'nĭssi otsĭs'tŭpipuitappiisĭnni, mat'akitsksĭnoauats. ");
INSERT INTO bla_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ŏkhs'apĭstutos mistsĭs', mŏk'ŏkhsinasiii: ki makap'ĭstutos mĭstsĭs mŏk'okapinasi: mistsĭs' ĭsksĭno'au otsin'assĭnni. ");
INSERT INTO bla_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pitse'ksĭnaipokax! Sauum'itsitappiinoainiki Tsa'a kitakokotŭnĭstse'poattopuau'astsaii ŏkh'sĭsts? Manĭsta'kauoopi u'skĕttsipŏppi, maoi' itai'puyiu. ");
INSERT INTO bla_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŏkhsin'auă manĭsta'kauoopi ŏkh'si u'skĕttsipŏppi sau'otsĭmĕsts ŏkh'siĭsts: Sauumitsĭn'nauă manĭsta'kauoopi maka'pi u'skĕttsipŏppi sau'otsĭmĕsts makap'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ki Kitan'ĭstopuau Kŏnai'ksĭstapitse'poawsĭsts otakse'puyisau matap'pix aksenŭp'anĭstomiauĕsts Okŏk'itsĭmani istsiksĭs'tsikui: ");
INSERT INTO bla_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kitse'poawsĭsts kitakokŏmotsitappiets'okoaiau ki kitse'poawsĭsts kitak'saietokoaiau. ");
INSERT INTO bla_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Stsik ix Sĭnak'ix ki Pharisees nokŭt'anĭstsiauaie ki an'iau, Nin'a nŏk'okapipĭnan itots'tsipi ksĕsto'a. ");
INSERT INTO bla_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ki nokŭt'anistsiuax osauum'itsitappiisĭnna ki otau'ŏkotaitappiisĭnna itok'apsatsĭmiau; ki mat'akitstsipa ak'okotawpiau. Tuks'kai ak'okotapiau Jonas prophet. ");
INSERT INTO bla_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Manĭsts'itaupĭsaie Jonas mammi' o'koanniaie nioks'kai ksĭstsikuists ki nioks'kai koko'ĭsts; ŭnniak'anĭstsitaupiuaie Nĭnau Okku'i ksŏk'kum u'skĕttsipŏppi nioks'kai ksĭstsikuists ki nioks'kai koko'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nineveh istsĭn'ax, akopoksipapomiauax o'tappiisĭnna istots'tsĭssi Okŏk'itsĭmani ki akitsautŭtsepuyiopiau; aisauai'tsitaiau otatsĭm'semŏssax Jonas; ki sat'sĭt, annŏk' skĭtsĭm'iuŏk Jonas annom' ĭtau'piu. ");
INSERT INTO bla_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Amskap'iksŏkkui ĭstsĭn'nauake akopoksipapomiuaie o'tappiisĭnna ĭstots'tsĭssi okŏk'itsĭmani, ki akitsauotŭtsepoyiopiau: umuk'itsipi ksŏk'kui ito'to mŏkitokhtsĭssi Solomon otokŏk'sĭniaie; ki annŏk' skĭtsĭm'iuŏk Solomon annom' itau'piu. ");
INSERT INTO bla_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sauum'itsistaaw otsai'piksĭstŭssi nĭn'au, ikĭtksŏk'kuyim itap'auauŏkau ĭssĭk'opĭssĭnni itap'satsĭm ki matokonĭm'atsaie. ");
INSERT INTO bla_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Itŭmau'aniu nitak'ătsko noko'ai numut'sŭx; ki oto'si ikon'ĭm nam'itaitsiiu, namokh'ipaie, ki a'natsĭstutsipaie. ");
INSERT INTO bla_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ki itŭm'itappo ki mat'tuyiuax ikĭt'sikŭmiax sta'awx, itsĭs'tŭpokapsiax, ki itsipim'inx ki itoko'attomiax: ki otsako'itappiisĭnni eikĭs'tŭpokapiuaie ototom'itappiisĭnni. Neto'i ak'anĭstsiuaie ot'okapitappiisĭnna. ");
INSERT INTO bla_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Otsa'kiaisitsĭpsattosax matap'pix, Sat'sĭt, Oksĭs'tsi, ki omu'pappiipix săuauts'im itai'puyiax, ai'puĭnŭmiau mŏk'sĭtsĭpsattŏsauaie. ");
INSERT INTO bla_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tuks'kŭm an'istsiuaie, Sat'sĭt, Kiksĭs'ta ki kumu'păppiipix sauauts'im itai'puyiau, ki ai'puĭnŭmiau kŏksiĭsĭpsaiisau. ");
INSERT INTO bla_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ki anni'ĭsk otan'ikĭsk, an'istsiuaie, Tŭkka' niksĭs'ta? Tŭkka' numu'păppiipix? ");
INSERT INTO bla_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ki itas'kotuyiuax otsĭs' otŭs'ksĭnĭmatsax ki an'iu Sŭm'mokau niksĭs'tsi ki numu'păppiipix! ");
INSERT INTO bla_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Annŏk' ai'aksĭstutsĭmŏknĭni Spots' im otsitsi'tani aie, osto'i numu'păppiipa, nĕskŭn', nit'akem, ki niksĭs'ta. ");
INSERT INTO bla_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ETO'IK ksĭstsiku'ik Jesus it sŭks' ki tsĭm nap'ioyĭs, ki omŭk'sikĭmi ĭssoots'i itakau' piu. ");
INSERT INTO bla_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Isto'tuitappiix oto'taakax, ki akh'iosasĭs itsĭtsŭppo'piu, ki itakau'piu; ki ĭsto'tuitap-piix ikŏn'itŭssuipuyiau ĭssoots'i. ");
INSERT INTO bla_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ki an'ĭstsiuax akauo'iau parables ki an'iu, Sat'sit, aisŭppipum'auă itui'sŭppipummau: ");
INSERT INTO bla_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ki otai'sŭppipummŏssi, moksoku'yi stsĭk'ĭsts itsĭn'nĭssiĕsts, ki paiu'tax itotoiax'ĕsts ki itau'attomiaxĕsts. ");
INSERT INTO bla_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Stsik'ĭsts okotoksskui itsĭn'nĭssiĕsts otsĭts'inŭxksŏkkuaspi; ki otsai'spixksŏkkuaspi itsĭk'kŭmsŭskiiau: ");
INSERT INTO bla_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Oto'tŭmĭskŏpsi natos'i, itse'tsĭnitsiau; ki otsau'okŏtseksau itopo'kŏttsiau. ");
INSERT INTO bla_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Stsĭk'ists itsĭn'nĭssiiau ksĭssi'ix: ki ksĭssi'ix itsŭskiiau ki ito'satsiiauax: ");
INSERT INTO bla_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Stsĭk'ĭsts ŏkhs'ksŏkkui itsĭn'nĭssiau, kiitsĭn'asiau, stsĭk'ists kepĭp'pui, stsĭk'ists nai'ĭppui stsĭk'ists niĭp'pui. ");
INSERT INTO bla_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Annŏk' ito'kiuŏk, ŭnanĭstokh'tsĭms. ");
INSERT INTO bla_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ki; ŭsksĭnĭmats'ax ito'toyiauaie, ki an'ĭstsiauaie, Kumauk'sĭtsĭpsattaiĭsksixau parables? ");
INSERT INTO bla_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nokŭt'anĭstsiuax, kitokokoau kŏk'itsksĭniisuai spots'im istsĭn'naiisĭnni itse'kipi, ki osto'auai matokotau'axau. ");
INSERT INTO bla_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Annŏk' nan'naniuŏk, ak'okotauaie, ki akakai'naniu: annŏk kŭttainan'iiuŏk, otsinanattopi ak'otsipaie. ");
INSERT INTO bla_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ŭn'nikaie numut'ŭnĭstsĭtsĭpsattaiau parables, ĭssŭppĭs'au mŏksta'apsau; okh'tsĭmsau mŏkstau'okhtsĭmsau, mŏkstai'ĭsksĭnnisau. ");
INSERT INTO bla_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aien'ŭpanĭstom'ĕsts Esaias, otan'ipi, okh'tsimeniki kitak'okhtsim, ki kimat'akoksĭnipa; ki sŭppi'niki kitakŭts'api, ki kimat'aksĭnipa: ");
INSERT INTO bla_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Am'o o'tappiisĭnna u'skĕttsipŏppĭsts mi'ĕsts, ki okhtok'oauĕsts matomaipumokhtsĭmiu'axau, ki oŏps'puauax naps'tsiiax; mŏksta'apsax moŏps'pix, mŏksta'okhtsĭmsĕsts mokhtok'ĭsts, mŏkstau'okhtsĭmsĕsts mu' skĕttsipŏppists, mŏkstaisauai'tsitasau, nok'staukuttutuawsau. ");
INSERT INTO bla_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Atsĭm'siau koŏps'puauax, aiapiau; ki kokhtok'ĭsts, ai'okhtsĭmiau. ");
INSERT INTO bla_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kit au'mŭnĭstopuau, akaiĕm'ix prophetix ki mokŏm'otsitappix ai'puĭnŭmiau mŏk'satsĭsauĕsts annists'isk kitai'nipuauĭstsk ki matsiĭnĭm'axauĕsts; ki mŏk'okhtsisauĕsts annists'isk kitai'okhtsipuauĭstsk, ki matokhtsĭm'axauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Okhtok ai'sŭpipummauă parable. ");
INSERT INTO bla_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ma tap' pi okhtsĭs'si nĭn'naiisĭnni istse'poawsĭn, ki sauo'kŏmotokhtsĭssi, itŭm'ipuksipu Sauum'itsitappiuă ki ito'kasattomaie annik' itsŭp'ipumattopik u'skĕttsipŏppi. Annŏk'auk mat'sĭmaie ĭstsŭpipum'ani moksoku'i. ");
INSERT INTO bla_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Annŏk' mat'sĭmŏk ĭstsŭpipum'ani ok'otokskui, ai'okhtsĭmiu epo'awsĭnu, ki otse'tametŭksĭnni mat'sĭmaie; ");
INSERT INTO bla_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mat'auŭtsitstsipa kŏk'seksi, ki matakisŭmsu'ats; ikikĭn'etŭksĭnni ki ŭkksĭstutŭk'sĭnni otos'au, atsim'epoawsĭnni ŭn'nikaie ito'toiau, ĭsts'kĭmskŭkiu. ");
INSERT INTO bla_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Annŏk' mat'sĭmŏk ĭstsŭpipum'ani ksĭssi'ix, ai'okhtsĭmiu atsĭm'epoawsin; ki annok' pai'tappiisĭnni ĭstap'aitsitani, ki spŭkĭs'sists ito'satstomiauaie atsĭm'epoawsĭnni, ki matsinasiu'ats. ");
INSERT INTO bla_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Annŏk' mat'sĭmŏk ĭstsŭpipum'ani ŏkhs'ksŏkkui, ai'okhtsĭmiu Atsĭm'epoawsinni, ki mokŏm'otokhtsĭmaie; ki itsin'asiu, stsikix, kepĭp'puyi, stsik'ix nai'ĭppuyi, stsĭk'ix niip'puyi. ");
INSERT INTO bla_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Stsik'i parable an'ĭstsiuax, ki an'iu, Spots'ĭm'ĭstsinnaiisĭnni netum'anĭstsiu Nĭn'au, annŏk' ai'sŭpipumauŏk ŏkh'sisŭppipum'ani otsĭn'sĭmman; ");
INSERT INTO bla_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","otai'okasax otap'automokix, okatum'i ito'toyiuaie, ki ŏkh'sisŭpipumani ipa'soksŭp'pipumau makap'sŭpipumani, ki itsĭs'tapu. ");
INSERT INTO bla_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ki otsŭs'kĭssi mattuyĭs, ki otsĭn'assi, itŭmĭn'akuo makap'sŭpipumani. ");
INSERT INTO bla_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ki Nin'au otapautomokix otsito'taakax ki an'ĭstsiauaie, Nin'a, Kikŭt'taiĭnsĭmattop'a ŏkhsisŭpipumani kĭtsĭnsĭmman? Tsema ito'to makap'sŭpipumani? ");
INSERT INTO bla_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","An'istsiuax, Katum'a otap'ĭstntŭksĭnaie. Ap'automokix otan'ikax kikŭt'ŏkhsitŭkkipa nŏk'ittotosĭnan nŏk'sauotsĭsĭnaniau? ");
INSERT INTO bla_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ki an'iu, Sa; sauau'tsĭmĭnoainikiau, makap'sŭpipnmani, kŏkskakŭm'sanotsipnaii ŏkh'sisŭpipumani. ");
INSERT INTO bla_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Unnianĭst'sŭskĭsan mŏk'itotosi pokiak'sĭnni: Ki pokiak'sĭnni oto'si, nitak'otŭmanistaiau ai'pokiakix, matom'omoipotokan makap'sŭpipumani, ki ĭs'ksipikan kŏk'ksĭetsĭnsĭssuaiau; ki ĭstŭp'omoipotokan napaiĕn'insĭmman nitapaiĕn'iokoai. ");
INSERT INTO bla_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Stsik'i parable an'ĭstsiuax, ki an'iu, Spots' im istsĭn'naiisĭnni netŭm'anĭstsiu mustard ĭstsĭn'sĭmman, annik' mat'sĭmŏk nĭnau, ki ai'sŭpipumau otsĭn'sĭmman; ");
INSERT INTO bla_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Itsĭs'tŭpskaiinŭkotsiuaie kŏnai'ĭnsĭmmanĭsts; ki sŭs'kiĭssi, itsĭs'tŭpomŭkkuiau insĭm'mansts, ki itsĭs'tsĭsasiu, ki paiu'tax itotoiau ki itoko'attomiax ĭsto'kŭniksĭsts. ");
INSERT INTO bla_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Stsik'i parable an'ĭstsiuax; Spots' im ĭstsĭn'naiisĭnni nitŭm'anĭstsin itai'kopŭtstaupi, annik' mat'sĭmŏk ake'u, ki kaias'attom niuks' kŭmi omŭk'okosix, napaiĕn itui'tsiau, ki ikŏnai'kopŭtstopiau. ");
INSERT INTO bla_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Am'ostsk Jesus ikŏnai'sĭtsĭpsattsiuăsts matap'pix parables itai'sĭtsĭpsattsiu; ki sauomai'sĭtsĭpsĭssi parable matomaisĭtsipsatsiuatsax: ");
INSERT INTO bla_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mŏksenŭp'anĭstossi Prophet otanipi, ki an'iu, nimutaksipa'kuiaki parables; nitakse'poattopiau annists'isk kai'sattop'istsk ksŏk'kumă sauomap'ăstotoawsi. ");
INSERT INTO bla_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ki Jesus aiĭs'tŭpskuyiuax matap'pix, ki itsit'sipim nap'ioyis: ki otŭsksĭnĭmats ax otsitota'akax, ki an'iau noksksĭnĭm'atsokĭnan parable makap'itaisŭppipumaupi ĭnsĭm'man. ");
INSERT INTO bla_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nokŭt'anĭstsiuax, Annŏk' itai'sŭpipumauŏk ŏkh'si ĭnsĭmmani Nĭn'au okku'yi am'ĭni; ");
INSERT INTO bla_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Insĭm'man konai'tappiua; ŏkh'si ĭnsĭmmani, nĭn'naiisĭnni ĭsto'kos'ix; ki makap'iĭnsĭmmani, Sauum'itsitappiuă o'kosix; ");
INSERT INTO bla_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Katum'a annŏk' ai'sŭppipumattomĕsts, Sauum'itsitappiuă itamiu; pokiak'sĭnni ksŏkkum aiksiuo'si; ki aipo'kiakix, atsĭm'otokatatsĭsau, ");
INSERT INTO bla_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Manĭsts'aumoipitŭkkipiau makap'ĭnsĭmmanĭsts ki manĭstse'tsĭnĭtspiau; ak'ŭnĭststsiu aiksiuo'si annom' ksŏk'kum. ");
INSERT INTO bla_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nĭn'au okku'i aks'ĭstŭpskuyiuax otatsĭm'otokatatsix, ki ak'omoipotsĭmiauĕsts ikŏnau'kapiĭsts ki anniks'isk matap'pixk, sauum'itsitappiiau ak'omoipotoyiuax; ");
INSERT INTO bla_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ki akitsĭpst'apiksĭstsiauax omŭx'tsi; annim' ak'itstsiau a sain'sĭnni, ki satse'kĭnani. ");
INSERT INTO bla_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mokŏm'otsitappix akotŭmĭk'kŭnasuyeiau, manistsĭk'kŭnasuyipi nato' si, un'oauai otsĭn'naiisĭnni, akotsĭk' kŭnasuyiauaie. Annŏk' itokh'iuŏk ŭnanistokh'tsĭms. ");
INSERT INTO bla_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Stsĭki, Spots'im istsĭn'naiisĭnni nitŭm'anĭstsiu treasure kaias'attomaie insĭm'man; kon'ĭssi nĭn'au, mat'aiksasattomaie, kĭ otsetam'etŭksĭnni itsĭs'tapu ki ipum'attopiĕsts otokŏnai'nanĭsts, ki ipum'attomaie annik' ĭnsĭm'manĭk. ");
INSERT INTO bla_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Stsik'i, Spotsim ĭstsĭn'naiisĭnni nitŭm'anĭstsiu awkh'pumapiekuŭn otap'sŭmmŏssi ŏkh'six pearls: ");
INSERT INTO bla_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kon'ĭssi tuks'kŭmi pearl akai'ĭxkĭmasiu, itsĭs'tapu, ki ipum'attopiĕsts otokŏnai'nanĭsts ki ipum'attau. ");
INSERT INTO bla_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Stsĭk'i, spots' im ĭstsĭn'naiisinni nitŭm'aniststsiu itau'mikaupi, annŏk itsuia'pĭxĭmŏkaie omŭk'sikĭmi, ki itomian'ĭstomoipitŭkkiu: ");
INSERT INTO bla_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Itui'tsĭssaie, itopĭts'ŭsskŏpattomiauaie ĭssoots'i, ki ito'piiau, ki ŏkh'six itaisŭppitsi'iau ĭskix; ki makaps'ix istsĭs'tapiksĭstsiiau. ");
INSERT INTO bla_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ak'otŭmanĭstsiu aiksiuos'i ksŏk'kum: atsĭm'otokatatsix ak'sipuksŭpsŭxiau, ki akai'aketaipiksĭstsiiau Sauum'itsitappix ki mokŏm'otsitappix; ");
INSERT INTO bla_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ki akitsipst'apiksĭstsiiau (sauum'itsitappix) omŭx'tsii; annim' ak'itstsiau a saĭn'sĭnni ki satse'kĭnani. ");
INSERT INTO bla_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus an'ĭstsiuax kikai'okhtsĭmipuauastsau annists'isk? An'ĭstsiauaie, A, nĭn'an. ");
INSERT INTO bla_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Itŭm' anĭstsiuax Annŏk' ai'sĭnakiuŏk ŭsksĭnĭmats'au spots'im istsĭn'naiisĭnni, nitŭm'aniststsiu nĭn'au, iko'yiuŏk, sauauts'ĭmĕsts treasure manists' ki ŭk'aisĭsts. ");
INSERT INTO bla_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ki itŭnĭsts'tsiu, Jesus otaiksiu'attosĕsts annĭsts'isk parables, itsĭstŭpa'atomaie. ");
INSERT INTO bla_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ki otsito'tosi otau'ŭtauŏsĭni otat'oiapioyimoai itsipst'ŭsksĭnĭmatsiuax, ki ek'skaietŭkkiau, ki, an'iau, Tse'ma itotsĭm'atsĕsts am'ok mokŏk'sĭnik, ki am'ostsk ot'omŭkapĭstutŭksists? ");
INSERT INTO bla_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kŭttomai'sauamiu'ats ai'satsakiuă okku'i? Kŭttomaisauainikŏttsiu'ats Oksĭstsi, Mary? Ki omu'pappiipix kŭttomaisauainikŏttsiu'atsax James, ki Joses, ki Simon, ki Judas? ");
INSERT INTO bla_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ki ot'akemix okŭttomaisaiiokŏnopokomok'atsax? Am'o Nĭn'au, Tse'ma itotsĭm'atsĕsts annists'ĭsk? ");
INSERT INTO bla_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ki itś'tsskĭmskŭkiax osto'i. Ki Jesus an'ĭstsiuax, prophet itŭs'tsakŏttau, sauomai'tapposiĕsts otau'ŏsĭni ki otauŭt'okoai. ");
INSERT INTO bla_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Otsauomai'tuksuai ŭn'nikaie itsauomapĭstutŭkkiu annim' akatio'yiĕsts ŭkkŭk'umapotŭksĭsts. ");
INSERT INTO bla_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ANNIK' Herod tetrarch okhtsĭm'attomĕsts Jesus otap'ĭstutsipists, ");
INSERT INTO bla_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ki an'ĭstsiuax otap'otomokix am'omauk John Baptist; enio'sĭnni mat'sipuau; ŭn'nikaie ŭkkŭk'umapotŭksists itap'ĭtutsimĕsts. ");
INSERT INTO bla_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod ŭkai'eĕniuaie John, ki aiĭs'ksipĭstsiuaie, ki itsok'iuaie osto'iaie Herodias, us Philip otokeman'ĭnaai. ");
INSERT INTO bla_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tŭk'ka John an'ĭstsiuaie matŏkhsiu'ats kŏk'otoŏssi. ");
INSERT INTO bla_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ki otai'aksenitossaie, stun'nuyiuax matap' pix, tŭk'ka ĭsksĭnnu'yiuaxauaie prophet. ");
INSERT INTO bla_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ki otai'totstsĭssi Herod otsit'sipokaiipi, Herodias otŭn'ni itŭt'sikipiu, ki itsŭp'ĭstutuyiuaie Herod. ");
INSERT INTO bla_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Itsiksĭs'toatsiuaie atoŭn'ĭssĭnni mŏk'ittokotossaie otan'ĭstopiaie. ");
INSERT INTO bla_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ki oksĭs'tsi otsĭs'tok, ki an'iu, John Baptist otokŏn' ĭstsŭp'potoat omŭk'okos ki annom' ĭstoko'kit. ");
INSERT INTO bla_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ki omŭx'ina itsĭk'oketŭkkiu: ki otŭtoanĭs'si ki otopokau'yemix, ŭn'nikaie itani'u mŏk'okotŏsaie. ");
INSERT INTO bla_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ki itŭp'skŏkiu, ki itsi'kawkokĭtsiauaie John itsĭpsts'okiawpiaie. ");
INSERT INTO bla_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ki otokŏn'itsipuk'sipĭppotopaie, omŭk'okos itsŭp'potopaie, ki ikotauai'e ake'kuŭn: ki ito'tsĭppotuyiuaie oksĭs'tsi. ");
INSERT INTO bla_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ki otŭs'ksĭnĭmatsax itoto'iau ki mat'sĭmiau mostŭm' i, ki ai'akotomiau, ki i'tappoiau ki itŭnĭs'tsiiau Jesus. ");
INSERT INTO bla_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus otokh'tsĭmsi, itsĭs'tŭpaatomaie akli'iosatsĭs itsui'akhiosiu, ki ksĭs'tapsksŏkkum itŭpanĭstappo'aie: ki matap'pix otokh'tsĭsau itsiksiuopokiuo'iauaie, otakap'ioyimoauĕsts sŭx'iau. ");
INSERT INTO bla_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ki Jesus itopĭtsĭssa'atomaie, ki nan'nuyiuax akai'tappix, ki kaiĭm'iuax, ki ikut'tutuyiuax otai'oktokosimoauax. ");
INSERT INTO bla_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ki otai'ĭstŭkkŏpsi, otŭs'ksĭnĭmatsax otsitota'akax, ki an'ĭstsiauaie, annom' ksĭs'tapsksŏkkumasiu, ki au'mŭtŭputŭkku; o'tappiisĭnna ŭnnĭstŭps'skos, mŏk'ittapposi akap'ioyĭsts, mŏk'opumattosi aau'ŏsĭn. ");
INSERT INTO bla_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ki Jesus an'ĭstsiuax, matokuiĭstapu'iauats; kotok' mŏks'auattopiau. ");
INSERT INTO bla_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ki an'ĭstsiauaie, annom' nitsinan'anĭsts nĭsittu'yi ke'tanĭsts ki na'tokŭmi mammix'. ");
INSERT INTO bla_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","An'iu, puk'sipĭppotokikau. ");
INSERT INTO bla_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ki an'ĭstsiuax kŏnai'tappix mŏk'opasax mattu'yikui; ki mat'sĭmĕsts nĭsittu'yĭsts ke'tanĭsts ki na'tokŭmi mam mix', ki, otspisŭp'si itatsĭm'etsĭmĕsts, ki itau'minotsimĕsts; ki ikotsiu'ax otŭs'ksĭnĭmatsax ke'tanists, ki otŭs'ksĭnĭmatsax ikotsiu'ăsts o'tappiisĭnna. ");
INSERT INTO bla_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ki ikŏnau'yiau, ki itoku'yiau: ki mat'sĭmĕsts iau pi'nikĕsts itstsi'ĭsts na'tsikoputtuyi ĭsksĭmmatŭk'iĭssokaiĭsts. ");
INSERT INTO bla_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ki aiiniks'ĭsk au'yixk nĭsitsi' omŭk'sikepĭppix nĭn'ax, ki akex, ki pokax'. ");
INSERT INTO bla_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ki Jesus eikak'imatsiuax otŭs'ksĭnĭnatsax mŏkĭt'sŭppopĭsax akh'iosatsĭs, mŏkotom'apŭmmosax, otsakiaiĭs'tŭpskoŏsaie tappiisĭn'na. ");
INSERT INTO bla_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ki otsĭs'tŭpskoŏsax otappiisĭn'nă, itsitamĭsso' nitum'mo mŏkatsimoiikasi; ki otau'tŭkkussi itsĭttau'piu. ");
INSERT INTO bla_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ki akli'iosatsĭs ai'itŭtsikioo, ki ipawkh'paikimskawp: tŭk'ka, umut'totsŭppopi. ");
INSERT INTO bla_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ki nĭssoo'yi ĭskska'tŭksĭnni koku'yi Jesus itsitappo'ax, omŭk'sikĭmi itokh'itauauŏkau. ");
INSERT INTO bla_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ki otŭs'ksĭnimatsax otsĭnno'ossauaie umuttokhitauau'okani omŭk'sikimi, ap'aitsitaiau, ki an'iau, Sta'awina; ki oko'pusuai itokum'iau. ");
INSERT INTO bla_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ki Jesus kaiĭp'sĭtsĭpsatsiuax, ki an'iu, Ŏkh'sitŭkkik; nitam'i; Piniko'puk. ");
INSERT INTO bla_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ki Peter nokŭt'anĭstsiuaie, Nin'a kŭm'ămieniki ani'kit ksĕsto'a nŏk'itotosi nŏk'itsitŭpauauŏkasi omŭk'sikĭmi. ");
INSERT INTO bla_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ki an'iu, Puk'siput. Ki Peter otĭnnĭsa'atossi akh'iosatsis, itokh'itauauŏkau omŭk'sikĭmi mŏk'ittapposi Jesus. ");
INSERT INTO bla_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ki otsĭnĭs'si eik'sopuyi, itsiko'pum: ki otaumutŭp'sŭppopiisi omŭk'sikĭmi ita'sainiepuyiu, ki au'aniu Nin'a, Kŏmotse'piokit. ");
INSERT INTO bla_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ki Jesus itŭp'sauksikĭns'tsakiuaie ki itsĕn'iuaie, ki an'ĭstsiuaie, ksĕsto'a enŭkaumai'tŭkkiua, kumauk'saietŭkkiks? ");
INSERT INTO bla_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Otsito'tosau akh'iosatsis, itsiksĭst'sopu. ");
INSERT INTO bla_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Anniks'isk itsŭp'popixk akh'iosatsĭs itoto'iauaie ki atsĭmmĭm'miauaie ki an'iaiu, E'mŭmi kitam'i Ap'istotok'iuă okku'i. ");
INSERT INTO bla_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ki otau'pŭmmossau, itoto'iau Gennesaret ĭstau'ŏssĭni. ");
INSERT INTO bla_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ki annim' ĭstsĭn'ax, ots'ksĭnuoŏssau, itŭp'skŭkiau kŏnŭs'ksŏkkum sa'akapotsi, ki itotsĭp'iauaie ikŏnai'oktokosix: ");
INSERT INTO bla_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ki au'kŏmŏnĭstsiauaie (Jesus) mŏkskaks'ĭxenĭsax oso'kŏsĭm itssaiin'ikaists: ki manĭsts'eipi kaien'ĭmĭx ŭn'nineetsĭmi sokap'okuttotoax. ");
INSERT INTO bla_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","AI'SĬNAKIX ki Pharisees, Jerusalem istsitappimix otsit'totaakax Jesus, ki an'iau, ");
INSERT INTO bla_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Tsanĭstapiuats umut'ŭnĭstŭpaipixipiau ŭkaitappix otŭn'ĭssuaiauĕsts? Oyĭs'sax ke'tan, matŭstsĭmiu'ax. ");
INSERT INTO bla_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nokŭt'anĭstsiuax ku'maukanĭstŭpaipĭxipuaiĭsks Ap'ĭstotokiuă otse'poawsĭnni kŏk'satsĭsaai kiksĭs'tapŭnĭssuai? ");
INSERT INTO bla_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ap'ĭstotokiuă an'iu, atsĭmmĭm'mĭsau kĭn'a ki kiksĭs'ta; ki, annŏk' ai'pakosĭnikuyiuŏk un'ni ki oksĭs'tsi, unnianĭstse'ĭnsă. ");
INSERT INTO bla_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ki kitan'ipuau annŏk' an'ĭstsiuŏk un'ni ki oksĭs'tsi, kotŭk'sĭnaie, kitak'ototokuinanipi nĕsto'a, ");
INSERT INTO bla_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ki kŭt'atsĭmmĭmmiuax un'ni ki oksĭs'tsi, paio'toau. Kitse'poawsuauĕsts kumut'saiepumapĭstutsipaie Ap'ĭstotokiuă otse'poawsăn. ");
INSERT INTO bla_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kitsiksĭs'tapokŏmmotsitappiansuai! Esaias prophet kit'sokapenŭpanikoau, ki an'iu, ");
INSERT INTO bla_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Am' ox matap'pix nimut'astokokiau maau'ĕsts, ki nimut'atsĭmmĭmmokiau oto'ŭniuauĕsts: ki u'skĕttsipŏppuanĕsts nitsĭp'piokokiĕsts. ");
INSERT INTO bla_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nitsiksĭs'tapatsĭmmĭmmokiau, ŏk'aumaitsipĭsts ăt'suaiĭsksĭnĭmats'iauax nĭn'ax otan'ipuauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ki nan'nikŏttsiuax o'tappiisĭnna ki an'ĭstsiuax, Okh'tok, ki sokap'okhtok; ");
INSERT INTO bla_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Annik' itsŭp'popiik maoi'i matokapĭstotok'atsaie nĭn'aii; annik' sŭk'siik maoi'i itokapĭstutuyiu'iu'aie nĭnaii. ");
INSERT INTO bla_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ki otŭsksĭnimats'ax otsĭtota'akax ki otan'ikax kikŭt'ŭsksĭnipa Pharisees otsĭs'kŭksau otokh'tsĭsau annik' epo'awsĭnik? ");
INSERT INTO bla_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ki nokŭt'ŭniu, kŏnai'sŭpipumanĭsts Nin'a spots'im okŭt'taisŭpipumattopĭstsi ak'sŭskŏpattopiĕsts. ");
INSERT INTO bla_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Amau'patokau; naps'tsiotŭppĭnnŭkiau naps'tsix. Ki naps'tsiuă ătŭppĭn'nŭssi napstsi'i, atŭn'iaksĭnni akai'akitsŭppopiiau. ");
INSERT INTO bla_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter itŭman'ĭstsiuaie, noksksĭnĭm'atsokĭnan am'om parable. ");
INSERT INTO bla_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ki Jesus an'iu, kikŭttaisakiaisauaiokhtsĭmipiuaua? ");
INSERT INTO bla_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kikŭttaisauaioklitsimipuaua, annik' itsŭp'opiik maoi'i, itŭp'sŭppopiu mo'koanni ki ipsai'piosop? ");
INSERT INTO bla_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ki annists'ĭsk itsŭks'isk maoi'i u'skĕttsipŏppi itsŭks'iax; ki itokap'ĭstutuyiauaie nĭn'aii. ");
INSERT INTO bla_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","U'skĕttsipŏppi itsŭks'ĕsts sauum'itsitsitanĭsts, inik'sĭsts, auŏk'otanĭsts kŏmos'ists, ĭstŭp'saiepĭtsĭnni, atauŭn'ĭssĭsts; ");
INSERT INTO bla_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Am'ostsk itokap'istutuyiauaie nĭn'ai'i; ki maks'oyissi otsauomŭs'tsĭmĭssi matokapistutuyiuats nĭn'aii. ");
INSERT INTO bla_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus itŭmĭstŭpa'atomaie, ki Tyre ki Sidon ĭstssoots'ĭsts itsitap'po. ");
INSERT INTO bla_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ki sat' sit, Canaan ista'ke itsux'iu annists'isk issoots'istsk, ki itasaine'poattsiuaie, ki an'iu, Kĭm'okit Nin'a, David okku'i! Nitŭn'na eiko'ksĭstutoau maka'pistaaw. ");
INSERT INTO bla_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ki matsitsitsipsattsiuatsaie. Ki otŭsksĭnĭmatsax otsitota'akax ki otau'kŏmŏnikax ki an'iax Ŭnnĭstŭp'skŏs; nitŭsksauasaine'poŭkĭnan. ");
INSERT INTO bla_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ki nokŭt'anistsiuax, nikak'itŭpskoko Israeli ĭstat'stanix emŭk'ikĭnaiĭx. ");
INSERT INTO bla_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Otsitŭmitota'akaie ki otatsĭm'mĭmmokaie, ki an'iu, Nin'a Spum'mokit! ");
INSERT INTO bla_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ki nokŭt'anĭstsiuaie, matŏkhsiu'ats mŏk'otsĭssi pokax otsau'ŏsĭnoaii mŏkitŭp'apĭxĭsĕsts imitax'. ");
INSERT INTO bla_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ki (ake'uă) an'iu, E'mŭniu, Nin'a; ki imitax' au'attomiau pinikĕsts ĭnnĭssi'ĭsts otsin'aimoauai otsitau'yipiaie. ");
INSERT INTO bla_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesus itŭmok'anĭstsiuaie, Ake', omŭk'o kĭtaumai'tŭksĭnni: Ŭnnianĭstsits'tsĭs kitsitsi'tatopi. Ki otŭn'ni ikuttotoai'ĭnai annik' itai'ksĭstsikumiopik. ");
INSERT INTO bla_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ki Jesus itsĭs'tŭpaatomaie annim', ki itast'toto Galilee istomŭk'sikĭmi; ki ita'mĭsso nitum'mo ki itau'piu annim'. ");
INSERT INTO bla_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ki akai'tappix otsito'taakax, ki ipokom'iauax ŭs'tsekaiix, naps'tsix, kŭttaiai'puyix, iko'mŭksix, ki akaiĕm'ix stsĭk'ix ki Jesus okt'sĭsts itsĭn'apiksĭstsiauax; ki ikut'tutuyiuax: ");
INSERT INTO bla_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ki kŏnai'tappix ek'skaietŭkkiau, otsĭnno'ŏssauax kŭttaiai'puyix otse'puyĭssax, ki iko'mŭksĭx otokut'totoŏsax, ki ŭs'tsekaiix otauau'ŏkăsax, ki naps'tsix otsaps'ax: ki ŭs'tsakŏttsiau Israel ĭstap'ĭstotokii. ");
INSERT INTO bla_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus itŭmĭn'nikŏttsiuax otŭsksĭnĭmats'ax, ki an'iu, nitai'kĭmaiau o'tappiisĭnna nioks'kai ksĭstsiku'ĭsts nitopokau'pimokiau, ki matokoyiu'axau: ki nimat'aksĭstŭpskoauaxau otau'notssau ŏkskakŭmitseni'au moksoku'i. ");
INSERT INTO bla_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ki otŭsksĭnĭmatsax an'ĭstsiauaie Tse'ma nŏkitotsipĭnan'a ke'tani manĭsto'mŭkopiau mŏk'otkuĭsĕsts o'tappiisĭnna? ");
INSERT INTO bla_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ki Jesus anĭstsiuax, Tsanetso'a ke'tanĭsts kitsinan'oauĕsts? Ki an'iau, Ikĭt'sikaiau, ki unna'tosĭmi inŭk'umix. ");
INSERT INTO bla_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ki an'ĭstsiuax o'tappiisĭnna, ksŏk'kum mŏkittopasax'ax. ");
INSERT INTO bla_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ki mat'sĭmĕsts ikĭt'sikaiĕsts ke'tanĭsts ki mammix', ki a'tsĭmoiikau, ki a'mĭnotsĭmĕsts, ki ikotsiuax otŭsksĭnĭmats'ax, ki ŭsksĭnĭmats'ax ikotsiu'ax o'tappiisĭnna. ");
INSERT INTO bla_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ki ikŏnau'yiau, ki ikuyi'au; ki mat'sĭmiau pinikĕsts ĭtskim'iauĕsts ikĭt'sikaii ĭsksĭmmatŭk'isokaiĭsts itui' tsĭsts. ");
INSERT INTO bla_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Anniks'isk au'yixk nĭssoyĭm'i omŭk'sikepĭppix nĭn'ax, ki akex, ki pokai. ");
INSERT INTO bla_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ki itsĭs'tŭpskuyiu o'tappiisĭn'na, ki itsĭt'sŭppopiu akh'iosatsĭs, ki ito'to Magdala ĭstssootsĭsts'i. ");
INSERT INTO bla_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","PHARISEES ki Saducees ipok'itotoiau ki as'saksksĭnnuyiauaie, ai'puĭnŭmiau mŏkanĭs'tsĭnnomoŏsax spots'im ĭstap'stosĭnni. ");
INSERT INTO bla_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nokŭt'anĭstsiuax, autŭkkus' si, kitan'ipuan ak'etameksĭstsi ku; ămawk'ĭssoksĭstsikuists. ");
INSERT INTO bla_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ki ksĭskŭnna'tŭnnĭssi, ak'akapiksĭstsiku annok' ksĭstsikui, amawkĭssoksĭstsikuists ki ĭkikĭn'inatsiu. Kitsiksĭs'tapokămotsitappiansuai! Kitokot'ainipuau assoksĭs'tsikuĭsts ostokso'auĕsts; ki kimatokot'ainipuau annists'isk ksĭstsiku'ĭstsk ĭstsap'stosĭsts. ");
INSERT INTO bla_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Otsauum'itsitappiisĭn'na ki otau'ŏkotaitappiisĭn'na ap'satsĭmiau apsto'sĭnni; ki matakokotau'axau apsto'sĭnni; prophet Jonas otap'stosĭnni akokotauaie'. Ki skĭtsiu'ax ki itsĭs'tapu. ");
INSERT INTO bla_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ki otŭs'ksĭnĭmatsax otau'pŭmmosau pakhts'esaiĭsksĭnĭmiau mŏk'atŭksau ke'tani. ");
INSERT INTO bla_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus itŭm'anĭstsiuax Mokŏk'ik ki iskskats'ĭk Pharisees ki Saducees ĭstsi'kopŭtsketatsĭsau. ");
INSERT INTO bla_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ki ai'sĭtsĭpsattseiau, ki an'iau, nimatotsipĭnan'a ke'tani, ");
INSERT INTO bla_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus otsĭnno'ŏsax, an'istsiuax, Inŭk'aumaitŭkkix, kumauk'sĭtsĭpsăttseipuauaisks, kitsauo'tŭksuai ke'tani? ");
INSERT INTO bla_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kikŭt'taisakiaisauokhtsĭmipuaua, kikŭttaisauŭsksĭnipuaua nĭsito'mŭksikepippix matap'pix ĭstsĭsĭttu'ĭsts ke'tanĭsts, ki tsanetso'ă kitots'ipuauĕsts ĭsksĭmmatŭk'isokaiĭsts? ");
INSERT INTO bla_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nĭstoyĭm'i omŭk'sikepĭppix matap'pix ĭstokĭtsikaists ke'tanĭsts ki tsanetso'ă kitots'ipuauĕsts ĭsksĭmmatŭk'isokaiĭsts? ");
INSERT INTO bla_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kumauk'staiokhtsĭmipuauaisks kimat'sĭtsĭpsattopuau'ats ke'tani, kŏkĭskskatsissuai Pharisees ki Saducees ĭstsi'koputsketatsĭsau? ");
INSERT INTO bla_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Itŭm'ĭsksĭnĭmiau matsemiu'atsax mŏksĭskatsĭsaie ke'tani istsi'koputsketatsĭs, ki ai'semiuaxmŏks'ĭskatsĭsaie Pharisees ki Saducees ots'ksĭnĭmats'tŭksuaiax. ");
INSERT INTO bla_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus otsito'tosi Cesarea Philippi, ai'sŭppoŏtsesattsiuax otŭsksĭnĭmats'ax, Tsa aniu'axau matap'pi nesto'a nĭn'au okku'i nŏk'ŭmsi? ");
INSERT INTO bla_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ki an'iau, stsik'ix John Baptist: stsĭk'ix, Elias: ki stsĭk'ix, Jeremias, ki stsĭk'ă prophet. ");
INSERT INTO bla_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","An'ĭstsiuax Tsa kitak'anipuau nŏk'ŭm-si? ");
INSERT INTO bla_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ki Simon Peter nokŭt'anĭstsiuaie ksĕsto'ăkauk Christ, Ap'istotokiuă ipai'tappiiuŭk okku'i. ");
INSERT INTO bla_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus nokŭt'anĭstsiuaie kitatsĭm'si, Simon Bar Jonas. Ik'sisakuyi ki aa'pŭni kimat'ŭsksĭnĭmatsok'astsau: nin'a spots'im kitusksĭnĭmats'ok. ");
INSERT INTO bla_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ki kita'atanĭsto, ksĕsto'akauk Peter, ki am'om ok'otokŭm nitak'ittokhitokoĭska church; ki Hades istokh'sepĭstanĭsts matakatsiu'atsaie. ");
INSERT INTO bla_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ki kitai'akokoto spots' im istsĭn'naiisĭnni itotai'kauaipixĭxtŭkiopi; ksŏk'kum kitai'akomianĭstomopipi, spots'im ak'itomopipo; ksŏk' kum kitai'akomianĭstapotsippi spots'im ak'itapotsip. ");
INSERT INTO bla_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Itŭm'anĭstsiuax otŭsksĭnĭmats'ax mŏkstaitsĭnnikoŏsax'aie osto'i otŭm'si Jesus Christ. ");
INSERT INTO bla_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Annik' Jesus itaumŭtŭp'anĭstsĭnomoyiuax otŭsksĭnĭmats'ax manĭstakittappopi Jerusalem, manĭstaks'ipuinaistoto'awpianaie omŭx'ĭmĭx ki omŭk'atoiapiekuax ki ai'sĭnakix, ki manistaks'enitawpiauaie, manistaks'ipuauĭstotoawpiuaie nioks'kai ksĭstsikui. ");
INSERT INTO bla_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter itŭmo'toyiuaie, ki aumŭtŭp'sitsĭpsattsiuaie, ki an'iu, Nin'a kŏkŭnĭstsĭp'piokosi; matakittotstsiu'ats ksĕsto'a. ");
INSERT INTO bla_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ki itapotŭkau'aie, ki an'ĭstsiuaie Peter apŭt'tokokit, Satan; kŏk'kĭtstsskĭmskŭki; kimatsskŭmau'ats Ap'ĭstotokiŭă kitsksska'tŭksists annom' ksŏkkum. ");
INSERT INTO bla_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Itŭmanĭstsiuax otŭsksĭnĭmats'ax Iststsi'ki matap'pi makopokiuo'ŏssi nĕsto'a, ŭnnianĭst'auŭtsikĭmatsĭstotos, ki ŭnnianĭstto'tsĭs otauai'staksĭnni, ki ŭnnianĭstopokiuos nĕsto'a. ");
INSERT INTO bla_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Annŏk'aiakitsikŏmotsepiosiuok opai'tappiisĭnni, akatstomaie': ki annŏk' itai'akatstomŏk opai'tappiisĭnni, nĕstoi umutak'atstomaie, ai'akokonimaie. ");
INSERT INTO bla_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tsanetso'ă matap'pi ak'okuiĭstŭpasokuiĭm'ats minan'attŭssi kŏnŭs'ksŏkkum, ki atsto'si otsipai'tappiisĭnni? Awx'a otai'akokotawpiaie opai'tappiisĭnni? ");
INSERT INTO bla_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nin'au okku'i akototo'yĭnaie Un'ni ots'tsapĭnasĭnni ki oto'tokatatsix akopokiuo'iax, ki kŏnai'tappix manĭstsi'piĕsts otap'otŭksuauĕsts ak'ŭnĭstokotsiuax. ");
INSERT INTO bla_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kit au'mŭnĭstopuau stsik'ix annom' itai'puyiau, mataksattotsĭm'axau eĭno'sĭnni otsauomai'noŏsau nĭn'au okku'i otsĭn'aipuksipusi mŏks'ĭnaiisi. ");
INSERT INTO bla_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","OTAIKSIUO'ĔSTS nauyi ksĭstsikuĭsts Jesus mat'toyiuax. Peter, James, ki John oskŭn', ki itŭnĭstŭpĭp'iuax spi'tummo. ");
INSERT INTO bla_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ki otsakiainoŏsauaie it'oketsistŭmiĭnai; ki ostoksĭs'i ĭkkŭn'natsiuaie manist'ĭkkŭnnasuyipi nato'si, ki otsĭstotos'ists ksix'ĭnatsiĕsts manĭsti'ksĭxĭnatspi ksĭstsikui. ");
INSERT INTO bla_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ki sat'sit, itsina'kuaiĕmiau Moses ki Elias, ki ai'sĭtsĭpsattsiauaie. ");
INSERT INTO bla_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter itŭm'anĭstsiuaie Jesus, Nin'ă, ŏkh'siu annom' nŏk'ittaupisĭnan: ŏkh'sitŭkkieniki, nŏkapĭstutsĭsĭnan annom' nioks'kai api' manists; tuks'kăii kŏksinan'attosi, ki tŭks'kaii Moses mŏksinan'attosi, ki tuks'kaii Elias mŏk sinanattosi. ");
INSERT INTO bla_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Otsakiai'puyĭssi, sat'sit ĭkkŭn'aisoksĭstsikuyi ituyi'kŭnakoaiau: ki sat'sit, epo'awsĭnni itots'tsiu assoksĭs' tsikui, ki an'iu, Am'o nitŭk'omĭmokos nitsekŏkh'sĭmmau; okh'tok. ");
INSERT INTO bla_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ki ŭsksĭnĭmats'ax otokh'tsĭsauaie itopi'iau ostokso'auĕsts, ki eks'kaikopumiau. ");
INSERT INTO bla_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ki Jesus ito'to, ki i tsĭxen'iuax, ki an'iu, Nipuauk', ki piniko'puk. ");
INSERT INTO bla_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ki ot'sŭpsau matsĭnnuyiau'axau matappix, kaks'ĭnnuyiau Jesus. ");
INSERT INTO bla_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ki nituin'moyi otsĭnĭssat'tosau, Jesus itsem'iuax, ki an'iu, Pinanĭs'tok matap'pi kitsĭnip'uauĕsts, Nĭn'au okku'i otsauomăt'sipuausi eĭnsĭn'ni. ");
INSERT INTO bla_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ki otŭs'ksĭnĭmatsax aisŭppoŏttsesat tsiauaie, ki an'iau, mauk'auaniĭsksĭxau ai'sĭnakix ak'otomoto Elias? ");
INSERT INTO bla_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ki Jesus nokŭt'anĭstsiuax, E'mŭniu, Elias ak'otomoto, ki akokŏnau'kŏmototom. ");
INSERT INTO bla_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ki kitan'ĭstopuau, Elias ŭk'auto, ki matsksĭnnuyiu'axauaie ki nitsĭs'tutuyiauaie manĭstŭp'stapiau. Neto'yi akŭnĭstai'puĭnattsiauaie Nĭn'au okku'i. ");
INSERT INTO bla_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Itŭm'ĭsksĭnĭmiau ŭsksĭnĭmats'ax umutai'sitsĭpsi John Baptist. ");
INSERT INTO bla_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Otsito'tosau o'tappiisĭn'na, nĭn'aii otsito'taakaie itsito'topĭstuksĭsano'piĭnaie, ki an'iu, ");
INSERT INTO bla_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Nin'a kĭm'ĭs noko'a; au'atusĭnau ki eks'ipuĭnŭm: ai'kapitsuiopiu istsii ki ai'kapitsuiopiu okke'. ");
INSERT INTO bla_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ki nitsitotsip'iaiauaie kĭtŭsksĭnĭmats'ax ki matokotokuttotu yiuaxauaie. ");
INSERT INTO bla_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus itŭm'ăniu, o'sauomaitŭkkesĭnna ki otapok'apitappisĭnna! Tsanetso'a kitakopokau'pimopa? Tsanetso'a kitak'itsitattopu aua? Puksipĭp'potokĭk. ");
INSERT INTO bla_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ki Jesus seĭtsĭp'sattsiuaie sauum'itsĭstaaw; ki itsŭksiinai; ki annik' pokau' ikut'totoau. ");
INSERT INTO bla_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ŭsksĭnĭnats'ax itŭm'itotoiauaie Jesus ki an'iau, numauk'sauokotsatŭppiksĭstŭnan? ");
INSERT INTO bla_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ki Jesus an'ĭstsiuax, Kitsauomai'tŭksĭnni: kĭtau'mŭnĭstopuau, kemŭk'enŭkotsĭssi kitaumai'tuksĭnni, manĭst'omŭkopi mustard itotai'sŭpipumauopi kitakokot'anĭstop am'om netum'moyi ŏk'ŭmĭstŭpotosi omim', ki ak'itŭpitsiu; ki matakitstsipa kikŭt'taakokotsĭstutsipuaii. ");
INSERT INTO bla_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Am'oi ŭnanĭstap'pi matomai'sŭxiuats saiits'tsĭsiau a'tsĭmoiikani ki sauau'yisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ki otsa'kiitaupĭssau Galilee, Jesus an'ĭstsiuax, Nin'au okku'i ak'okotau matap'piĭx: ");
INSERT INTO bla_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ki aks'inittsiauaie, ki nioks'kasi ksĭstsiku'ĭsts, akŭtsitsipua'atsau. Ki eks'kaĭkikĭnetŭkkiau. ");
INSERT INTO bla_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ki otsĭtto'tosau Capernaum, anniks'isk au'tujixk mix'kim, itoto'iau Peter, ki an'iau, kŭttomisauaiponitau'atskitsĭn'aim? ");
INSERT INTO bla_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","An'iu, A, ki otsipĭs'si nap'ioyĭs Jesus i'tomsitsipsattsiuaie, ki an'iu Tsa kitsta'pa, Simon? Tŭkka' au'tuyiua mĭx'kĭm ksŏkkum ĭstsĭn'ax? Otauŭt'okosĭx, ki pie'tappix? ");
INSERT INTO bla_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter an'ĭstsiuaie. Pie'tappix. Jesus an'ĭstsiuaie, o'kosoauax matakotŭmaiponitau'atsax. ");
INSERT INTO bla_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ki, nŏkstaisau'kosatsŏsau ĭs'tŭpuk omŭk'sikĭmi, ki suia'piksĭstsĭs amik'atsĭs, ki mammi kitotom'omikani mattos'; ki pakuiĭn'ainiki kitak'okonoau mix'kim: annŏk' mattos', ki ko'tsĭsau, kitak'siponitanuni. ");
INSERT INTO bla_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","AN NIK' otŭsksĭnĭmats'ax itoto'iau Jesus ki an'iau, Tŭkka' mĭstŭpomŭksĭm'a spots' im istsĭn'naiisinni? ");
INSERT INTO bla_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ki Jesus itsĭn'ikŏttsiuaie inŭk'sipoka ki itŭt'sikipotoyiuax. ");
INSERT INTO bla_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ki an'iu, kitau'mŭnĭstopuau saiisau'aitsinoeniki, ki saie'tumanĭstsĭnoeniki inŭk'sipokax, kimataksipi'puaua spots'im ĭstsĭn'naiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Annŏk' aks'inŭksipokaĭstutosiuŏk manĭst'inŭkstsĭmipi am'o pokai'i, itsĭs'tŭpomŭksĭm spots'im ĭstsĭnnaiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ki annŏk' ak'autuyiuŏk tuks'kai inŭk'sipokaiĭstotosiĭsk, nĕsto'i nitau'tok. ");
INSERT INTO bla_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ki annŏk'ĭstsskĭm'skŭkiats'iuŏk tuks'kŭmi anniks'ĭsk inŭk'sipokaxk nitau'maitokixk, ŏkh'siu pikiak'iokotoki kĭn'attossaie, ki inets'ĭssi omŭk'sikĭmi. ");
INSERT INTO bla_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Istsskĭm'skŭksĭnni it'okapiu ksŏkkum, Istsskĭm'skŭksĭsts ak'itotoiau; ki annŏk' nĭn'auŏk paiuk'sipĭppotomŏk ĭstsskĭm'skŭksĭnni, aks'ksĭnĭmaie maka'pi! ");
INSERT INTO bla_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ŭn'nikaie kotsĭs' ki kokŏt'si ĭstsskĭmskŭkiats'otsenikiau, kŏksĭnit'au, ki mĭs'tŭpapiksĭstaiau: itŏkh'siu kŏk'kitsipĭssi opai' tappiisĭnni kŏks'ĭstsekaiisi ki kŏk'opokŏksi, kŏkstaitŭp'apixĭkŏsi kŭttaiaiapunstsiuasi ki kitai'akokŏtsĭsts ki kitai'akŏtsĭsts. ");
INSERT INTO bla_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ki koŏps'pi ĭstsskĭm'skŭkiatsotseniki, sauau'tos, ki mĭs'tŭpapiksĭstsĭs: itŏkh'siu kŏk'kitsipĭssi opai'tappiisĭnni tuks'kŭm moŏps'pa; kŏkstaitŭp'apixĭkosi kŭt'taiaiapunstsiuasii, ki kitaiakoŏpspix. ");
INSERT INTO bla_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mokŏk'ik kŏk'stauksĭstotoawsi tuks'kumă am'oksk inŭks'tsĭmix: kitan'ĭstopuau spots'im oto'tokatatsuauax ŭsks'skatsĭmiau Nin'a ostoksĭs'aie spotsim otsitau'pipi ");
INSERT INTO bla_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nĭn'au okkui ito'to mŏkitsikŏmotse'piŏsaie annŏk' at'stauŏk. ");
INSERT INTO bla_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tsa kitŭs'tapuau? Nin'an minan'attŭssi kepĭp'pi emŭk'ikĭnax ki tuks'kŭmi itŭnĭs'tapu, kŭttomisauŭsskĭtsĭmiu'axau piksĭp'pi piksi'koputsi, ki kŭttomisauaitappo'ats netum'moĭsts, ki kŭttomisauapsŭmmiuats annŏk' nittŭppu'ŏk? ");
INSERT INTO bla_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ki ikŭm'okonoŏssaie, kitau'mŭnĭstopuau manĭstse'tametŭkkipiax piksĭp'pi piksi'koputsi otsaiĭs'tapusax itsĭs'tŭpskaietametŭkkiu annŏk' ikon'ĭmauŏk. ");
INSERT INTO bla_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Neto'i omat'sitsitanats Kin'ă spots'im tuks'kŭmi anniks'isk inŭx'tsimixk mŏk'saiinakuaiĭssau. ");
INSERT INTO bla_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Stsik'i, kumu'pappiipi sauo'kŏmotsĭstototseniki, matan'ĭstsĭs otsauo'kŏmotsitappiisĭnni, ksĕsto'a ki osto'i namĭs tsitappiik; okh'totseniki kitse'motsau kumu'pappiipi. ");
INSERT INTO bla_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ki saiiokh'totseniki, tuks'kŭm tsŏktau na'tokumix pokitappomĭsau, kŏnai'poawsĭsts mŏks'eikosau, otokh'tsĭsau natsitappix, tsoktau nioks'kaitappix. ");
INSERT INTO bla_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ki sauokli'toŭsax, anĭstsĭs'church: ki sauŏkh'tsĭssi church, ŭnnianists'is sai'etŭkkiuă ki publican. ");
INSERT INTO bla_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kitau'mŭnĭstopuau, kitsit'aiipipi ksŏk'kum, akitaiipip spots'im: ki kitsitapotsippi ksŏkkum, akŭtsitapotsip spots'im. ");
INSERT INTO bla_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kimat'anĭstopuau, netum'anistsitsitainoainiki kitak'aukŏmŏnisuai, Nin'a spots'im aks'ĭstutomoyiuaxaie. ");
INSERT INTO bla_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Natokŭmi tsoktau nioks'kŭmi nitsĭn'ikŏsim itsitomo'oaupi nĭt'sitaitŭtsikiaupi. ");
INSERT INTO bla_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peter itŭmitotoaie, ki an'ĭstsiuaie, Tsanetso'awtau numu'pappiipa nŏksauumitsĭstu-tuyĭssi, ki nŏks'ksĭnnoŏssi? Akokitsikaiasts? ");
INSERT INTO bla_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus an'ĭstsiuaie, Kimatanĭstopa ikĭt'sikaiĕsts, ikitsikippuiĕsts ikit'sikaiĕsts. ");
INSERT INTO bla_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Spots'im ĭstsĭn'naiisĭnni nitum'anĭstsiu omŭx'ĭna annŏk' ak'okŏkitsĭmaiauŏk otsitappim'ix. ");
INSERT INTO bla_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ki otau'mŭtŭpŭkstŭkkisi tuks'kŭm ot'sittotsippotokaie, ke'pi omŭk'sikepĭppoyi mix'kĭmix otai'akokotopixaie. ");
INSERT INTO bla_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Otsai'itstsĭssi mŏkokotŏsai'e, Otsĭn'aim an'iĭnaie mŏk'apikosaie, ki otokem'an ki o'kosix ki otokŏnai'nanĭsts, ki mŏkotoku'yĭsax mĭx'kimix. ");
INSERT INTO bla_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Otsitappimi itopĭstuksĭsano'piĭnaie ki atsĭmmĭmmi'ĭnaie ki an'iĭnaie Nin'a, pinane'tŭkkit ki kitaksŭpanĭs'tsokoto. ");
INSERT INTO bla_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ki annŏk' matap'piuŏk otsĭn'aim kaiĭm'iuaie ki paio'toyiuaie ki ŭnnim iks'ksĭnnuyiuaie. ");
INSERT INTO bla_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ki neto'ŏk matap'piuŏk sŭx'iu, ki tukskŭm'i otopok'apotŭkkimix ikon'oyiuaie otai'akokok'isk kepĭp'pii a'pŭnasainix; ki een'iuaie, ki paiu'tsĭniuaie ki an'iu, Ponitat' kitai'akokokipix. ");
INSERT INTO bla_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ki otopokapotŭkkim'i itoipĭstuksĭsanopiĭnaie, ki aukŏm'ŏnĭstsiuaie, ki an'iu, pinane'tŭkkit ki kitaksŭpanĭstsokoto. ");
INSERT INTO bla_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ki matŏkhsitŭkkiu'ats; ki itappo' ki itsipsts'tapiksĭstsiuaie itai'okiakiopi, otsauomaisŭpanĭstsiponitasaie mŏkstaisŭksaie. ");
INSERT INTO bla_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Otopok'apotŭkkimix otsĭnĭs'sax eks'kaĭkikĭnĕtŭkkiau, ki ito'toiau, ki otsĭn'aimoauai aiitsĭnikuyiauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ki otsĭn'aim otsĭn'nikŏttossaie, an'ĭstsiuaie, Sauum'itapotŭkkiuă, kitai'akokokipix kitsĭn'omokitan'ikipi: ");
INSERT INTO bla_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kanĭs'tsikĭmopi kumauk'sauanistsikĭmaisks kitopokap'otŭkkimokă? ");
INSERT INTO bla_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ki otsin'aim ĭstse'tŭkki'ĭnai, ki itsitŭpumŭts'kaiuaie pu'ĭnaitappix otsauomai'sŭppiponitassaie. ");
INSERT INTO bla_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Neto'i Nin'a spots'im kitak'anĭstotokoau saiisin'ĭminoainiki ku'sskĕtsipŏpuauĕsts kumut'aukĭmaupuai kumu'pappiipix. ");
INSERT INTO bla_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","KI Jesus annists'isk epo'awsĭsts otaiksiu'attosĕsts Galilee itsĭstŭpa'atomaie. Ki Judæa istssoots'ists, Jordan mĭs'taputsim, itoto': ");
INSERT INTO bla_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ki akai'tappix ipokiuo'iauaie; ki annim' ikut'totoyiuax. ");
INSERT INTO bla_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pharisees itoto'iauaie, ki as'saksksĭnnuyiauaie ki an'ĭstsiauaie, ŏkhsiu'ats nĭn'au kŏnai' nŭkŭnĭstapĭsts mŏk'anĭstŭpskoŏsaie otokem'an? ");
INSERT INTO bla_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ki nokŭt'anĭstsiuax kikŭtanĭstop'ats sinak'sĭn, annŏk istsitsap'ĭstutuyiuŏkax ap'ĭstutuyiuax nĭn'au ki ake'u. ");
INSERT INTO bla_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ŭn'nikaie nĭn'au itai'akskitsiu ax un'ni ki oksĭs'tsi, ki ai'akŭkomĭmmiu otokem'an: ki akitum'anĭstoksisakumiau. ");
INSERT INTO bla_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ŭn'nikaie matsĭstokŭm'axau, itse'tumanĭstoksisakumiau. Ap'ĭstotokiua otsipo'totopĭsts, pinits'tsĭs matap'pi mŏkai'aketotosĕsts. ");
INSERT INTO bla_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","An'ĭstsiauaie, niauk'anii Moses ŏk'okotŏsi sinak'sin, ki ŏk'ŭnĭstŭpskoawsi? ");
INSERT INTO bla_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","An'ĭstsiuax Moses, kumut'sipotomokoau kitse'usskĕttsipŏppisuai, kŏkotŭnĭstŭp'skoŏssuai kotokem'anoauax; ki istsitsi'i matŭtŭnĭstsiu'ats. ");
INSERT INTO bla_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ki kitanĭstopuau annŏk' akŭnĭstŭp'skuyiuŏk otokem'an, sauau'ŏkotasaie, ki otai'kaokemaitaii stsĭk'i itau'ŏkotau: ki annŏk' ikem'attauŏk itŭp'skoauŏk, itau'ŏkotau. ");
INSERT INTO bla_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Otŭs ksĭnimatsax anĭstsiauaie Ŭnnianĭsts'ĭssau nin'au ki otokem'an, matŏkhsiu'ats mŏk'okemsi. ");
INSERT INTO bla_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ki an'ĭstsiuax kŏnai'tappix matokot'otsimaxaie annik' epo'awsĭnik, anniks'isk iko'taxk nittsĭmiauaie. ");
INSERT INTO bla_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Itstsi'i iuai'itax itsipo'kaiiau; ki stsĭk'ix matappix iuai'itsiauax, ki stsĭk'ix iuai'itastotosiau, Spots' im istsĭnnaisĭnni umut'uaiĭtastotospiau. Annŏk' ikot'totsĭmŏk ŭnnianĭstots'ĭsaie. ");
INSERT INTO bla_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Inŭk'sipokax itotsipotoaii mŏkĭttokhitsikĭns'tsaksax, ki mŏkitatsĭmoiikasi: ki ŭsksĭnĭmats'ax an'ĭstsiauax unnai'e. ");
INSERT INTO bla_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ki Jesus an'iu, Pokĭtsĭm'mokau inŭk'sipokax ki pinanĭs'tokau nŏkstai'puksipaaiĭsau. Ŭn'nianĭstaps'iau spots' im istsĭn'naiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ki itokhitsikĭns'tsakiuax, ki itsĭs'tŭpaatomaie. ");
INSERT INTO bla_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ki, sŭppĭt, tuks'kŭmi itsitotoiĭnaie ki an'iu, Ŏkhsĭn'ai, tsanĭstap'iua nŏk'ŏkhsĭstutsipi, nŏkkuinan'si ŭsk'sipaitappiisĭnni? ");
INSERT INTO bla_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ki an'ĭstsiuaie, Kumauk'ainikŭk'iks ŏkh'si? Matŭtsitstsipa ŏkhsi, nitŭks'kŭm, Ap'ĭstotokiuă, itŏkh'siu: makitsipim'eniki opai'tappiisĭnni, sat'sitĕsts okŏk'itsĭmanĭsts. ");
INSERT INTO bla_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","An'ĭstsiuaie Tsĭstsĭmă? Jesus an'iu, kimataksenik'ipa, kimatakau'ŏkotapa, kimataksikŏmos'pa, kimatakitŭp'saiepitspa. ");
INSERT INTO bla_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ŭkomĭm'mĭsau kĭn'a ki kiksĭs'ta; ki, kitak'anĭstŭkomĭmmau kitopokau'pimau kanĭstŭk'omĭmmospi. ");
INSERT INTO bla_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Man'ikŏppi an'ĭstsiuaie. Nĭtokŏnŭs' satsipiau am'ostsk nitsŏk'umapiisi. Tsanĭstap'iua nikŭt'tomŭssatsipi? ");
INSERT INTO bla_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus an'istsiuaie maksŭpanĭs'tsĭminiki matap'ikŏttoat kitsinan'ipi ki ko'tsĭsau kĭm'atapsix, ki kitak'okuinani treasure spots'im: ki puk'siput, pokiuot' nĕsto'a. ");
INSERT INTO bla_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ki man'ikŏppi otokh'tsĭm'si annik' epo'awsĭnik, itsĭkikĭn'iĭstapu: tŭk'ka ek'akauoi otsinan'ists. ");
INSERT INTO bla_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus itŭm'anĭstsiuax otŭsksĭnĭmats'ax, kitau'mŭnĭstopuau, ako'tsapsiuă ak'skotoitsipim spots'im ĭstsĭn'naiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ki kimat'anĭstopuau aks'ĭstŭpiksĭstspapiu'camel mŏkotsisŭppoksŭx atŭnau'ksis ĭstakŭn'ikai, ki mataksiksĭstspapĭu'ats ako'tsapsiuă mŏk'itsipĭssi spots'im istsĭn'naiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Otŭsksĭnĭmatsax otokh'tsĭmsax ek'skaietŭkkiau, ki an'iau, Tŭkka' akokotsikŏmotse'piau? ");
INSERT INTO bla_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ki Jesus ŭs'sŭmmiuax, ki an'ĭstsiuax matap'pix matokotsĭstutsĭm'axau; Ap'istotokiuă ikotokŏn'apĭstutsimĕsts. ");
INSERT INTO bla_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peter itŭm'anĭstsiuaie, sat' sit, nitokŏnŭsskipĭnan ki nitopokiuo'pĭnan ksĕstu'a. Tsa nitakanĭstokuinan'ipĭnan? ");
INSERT INTO bla_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ki Jesus an'ĭstsiuax, kitau'mŭnĭstopuau, ksĕsto'au kitopokiuo'puau nesto'a, Nĭn'au okkui otak'ittokhittaupĭssi ots'tsapĭnaiso'pŏtsĭs, ksĕsto'au kitak'ittokh ittau pipuau na'tsikoputtuyists asso'pŏtsĭsts kŏkitokŏk'itsĭmattosau Israel ĭstsĭstsikoputsix matap'pix. ");
INSERT INTO bla_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ki anniks'isk skĭm'ixk oko'auĕsts, ki anniks'isk skĭts' ixk umu'pappiipuauax ki ot'akemoauax ki un'oauax, ki oksist'oauax ki otkem'anoauax ki o'kosoauax, kiotsĭn'sĭmmanoauax, nĕsto'i itskĭm' iauĕsts, kepĭp'pi ak'okuyiau, ki akokuinan'attomiau ŭsk'sipaitappiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ki akai'tappix matom'six ak'sakoĭssiau, ki sako'ĭssix ak'otomsiau. ");
INSERT INTO bla_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","SPOTS' IM ĭstsĭn'naiisĭnni netoi'nitsiu nĭn'au, nap'ioyĭs ĭstsĭn'aim, annŏk kŏk'kŏnisuxiuŏk mŏk'anĭstosi ap'autŭkkix, mŏkapotomoyĭsax otsĭn'sĭmman. ");
INSERT INTO bla_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ki ŏkh'situkkisax mŏkokuyĭsax tuks'kai ksĭstsikui tŭks'kŭmi apŭn'asaini itŭp'skuyuiax otsĭn'sĭmmani. ");
INSERT INTO bla_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ki nioks'kaii itai'ksĭstsikumiopi mat'suxiu, ki stsik'ix nan'nuyiuax nam'itaipuyiax itau'pumopi, ");
INSERT INTO bla_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ki an'ĭstsiuax nokŏt'sitappoak ĭnsĭm'man, ki mokŏm'otsĭssi kitak'okotopuau, ki itappo'iau, ");
INSERT INTO bla_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nau'yi itai'ksĭstsikumiopi, ki piksu'yi itai'ksĭstukumiopi, mat'sŭxiu, ki netoi' mat'anĭstsiu. ");
INSERT INTO bla_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ki nitsiko'puttuyi itai'ksĭstsikumiopi, itsŭx'iu ki ikon'oyiuax stsĭk'ix nam'itaipuyix, ki an'ĭstsiuax konai'ksĭstsikuyi kumaukai'amitaipuisks annom'? ");
INSERT INTO bla_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","An'istsiauaie mats'itstsipa matap'pi nŏk' anikĭnan. An'ĭstsiuax, Nokŏt'sitappoak ĭnsĭm'man; ki mokŏm'otsĭssi kitak'okuinanipuau. ");
INSERT INTO bla_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ki autŭkkus'si, insĭm'man ĭstsĭn'aim an'ĭstsiuaie otap'otomoki, ninikŏt'sĭsau ap'autŭkkix, ki ko'tsisau saiak'inosattaupiau, matom'okotsĭsau sako'ĭssix, ki tŭm'okotsĭsau matom'six. ");
INSERT INTO bla_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ki ĭstoto'sau nitsiko'puttuyi itai'ksĭstsikumiopi itaumŭtŭp'apotŭkkix, kŏnai'ĭnax ikŏno'kuyiau apŭn'asaini. ");
INSERT INTO bla_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ki matom'six ĭsto'sau, ŭs'taiau mŏkoku'yĭsauaie stsĭk'i; ki ikŏno'kuyiau apŭn'asaini. ");
INSERT INTO bla_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ki otoku'yĭsauaie, itŭpaukape'poawtsiauaie nap'ioyĭs ĭstŏkhsĭn'ai, ");
INSERT INTO bla_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ki an' iau, anniks'isk sako'ĭsixk nituk'skau itai'ksĭstsikumiopi itapotŭkkiau, ki kanĭstokotaiau kanĭst'okokipĭnan ki ksĭstsiku'i ĭstsiksĭs'tutsĭssĭnni nitap'autŭkkipĭnan. ");
INSERT INTO bla_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ki an'ĭstsiuaie tuks'kŭmi, Napi'a, kimat'omaikĭmatsĭstotopa: kikŭt'tomaiŏkhsitŭkkipa tuks'kŭmi apŭn'asaini? ");
INSERT INTO bla_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Matsit' kitsinan' ki mĭs'taput; nitak'anĭstokotau am'o sako'ĭssiu kanĭst'okotopi. ");
INSERT INTO bla_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kŭttomŏkhsiuats nitsinan' nanĭstsitsitapi nŏk'anĭstutsĭssi? Kŭtaukapiu'ats koŏps'pi, mŏk'ŏkhsĭssi nitsinan'? ");
INSERT INTO bla_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ki sako'ĭssix akotom'siau, ki matom'six ak'sakoĭssiau; tŭkka akaiĕm'ix ni'nikŏttaiau, ki un'natosĭmix mat'toaiau. ");
INSERT INTO bla_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ki Jesus otsitŭpamĭssosi Jerusalem, na'tsikoputtsix otŭs'ksĭnĭmatsax itŭnĭstŭpĭp'iikax, ki an'ĭstsiuax, ");
INSERT INTO bla_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Sat' sit aitŭpamĭssau'op Jerusalem, ki nĭn'au okku'i akitŭpomŭts'kau omŭk'atoiapiekuax ki ai'sĭnakix, ki akŭnĭstokŏkitsĭmŭt'tsiiauaie mŏks'eĭnsaie. ");
INSERT INTO bla_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ki akŭtsitŭp'omŭtskau Gentiles mŏkitapapĭstotoŏssauaie, ki mŏkitstsipĭs'ossauaie, ki mŏkauai'stŏsauaie; otsoks'kaiksĭstsikusi ak'ŭtsipuau. ");
INSERT INTO bla_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedee oku'ix oksĭs'toauai ipok'itotomiauax oku'ix, ki atsĭmmĭm'miauaie, ki au'kŏmŏnĭstsiauaie tuks'kaii. ");
INSERT INTO bla_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ki an'ĭstsiuaie, Tsa kanĭstsitsitapa? An'ĭstsiu aie. Anit am'ox nitai'akokosĭx mŏkittaupĭsau kitsĭn'naiisĭnni, tuks'kŭma netots'i, ki tuks'kŭma e'aksĭsauotsi. ");
INSERT INTO bla_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus an'iu, kimatsksĭnip'uaua kitau'kŏmŏnikipuai, Kikŭtaiakokotsĭmipuau annŏk' kos'ŏk nimutai'aksĭmipŭk? Kikŭtaiakokotŭstapĭnŭkipuau ŭsta'pĭnŭksĭnni nimutai'akŭstapĭnŭkipi? An'ĭstsiauaie, nitokot'ŭnĭstspĭnan. ");
INSERT INTO bla_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","An'ĭstsiuax kitak'ŭtsĭmipuau no'kosă, ki kitak'ŭstapĭnŭkipuau ŭsta'pĭnŭksĭnni nimut'akŭstapĭnŭkiipi; ki nimatsinanĕstsau kŏkokotosuai kŏkittaupisuai netots'i ki e'aksĭsauotsi nesto'a, ki anniks'isk matap'pixk Nin'a ŭk'aisŭppŭtsĭstotomoyiuax, otaksinan'oaiau. ");
INSERT INTO bla_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ke' pix otokh'tsĭmsau ĭstsĭmmĭm'miauax na'tsitappix ipapiĭmmotseiix. ");
INSERT INTO bla_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ki Jesus ninikŏt'siuax, ki an'istsiuax, kits'ksĭnipuau Gentiles otsĭn'aimoauax otain'aiĭskotokoaiauax ki anniks'isk omŭx'ĭnaxk nokŏtai'naiĭskotokoaiauax. ");
INSERT INTO bla_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ki mataketŭmanistsiu'ă ksĕsto'au: annŏk' ak'omŭksĭmŏk, ŭnanĭstap'otŭksi; ");
INSERT INTO bla_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ki annŏk' kitaks'ĭnnauŭkŏk ŭnanĭstap'otŭksi: ");
INSERT INTO bla_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nin'au okku'i matŭtoto'ats mŏk'apotomoŏsaie, mŏk'apotomoŏsi umut'oto, ki mŏk'itatsuaumŭtskotosi akaitappix opai'tappiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ki otsĭstŭpaatosau Jericho, akai'tappix ipokiuo'iauaie. ");
INSERT INTO bla_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ki satsit, natsitappix naps'tsix pitsiko'-otsim i tau' pix otokh'tsĭsau Jesus umutak'itsskosaie awk'umiau, ki an'iau, kĭm'okinan, Nin'a David okku'i. ");
INSERT INTO bla_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ki o' tappiisĭn'na ai'semiauax mŏkstaie'puyĭsax: ki matsĭstawk'umiau ki an'iau kĭm'okinan, Nin'a, David okku'i. ");
INSERT INTO bla_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ki Jesus itsipu'yiu, ki nan'nikŏttsiuax, ki an'iu, Tsa kŏk'anĭstutopuau? ");
INSERT INTO bla_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","An'ĭstsiauaie, Nin'a mŏksikauopiisaii noŏps'pĭnanix. ");
INSERT INTO bla_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ki Jesus kaiĭm'iuax, ki itsĭksen'iuax oŏps'puauax, ki oŏps'puauax kau'opiau, ki itopokiuo'iauaie. ");
INSERT INTO bla_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","OTSITASTOTOSAU Jerusalem otsitotosau Bethphage, itum'uasuaie Olives an'ĭstop Jesus itŭp'skuyiuax na'tsitappix otŭsksĭnĭmats'ax, ");
INSERT INTO bla_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ki an'ĭstsiuax, akap'ioyĭs astsi'ĭm ĭstsipi'ĭk, kikitakstŭmkonau ŭsk'omŭkstokiua aks'ĭsksipĭstau, ki o'kosepokai ak'opokitaipuyimiu: apo'tokau ki puk'sipĭppotokĭkau. ");
INSERT INTO bla_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ki sĭtsĭpsatsenoainiki matap'pi, kitak'anĭstaiau Nin'a au'anĭstsiuax; ki ak'otŭmŭtsitŭpskuyiuax. ");
INSERT INTO bla_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","I kŏnan'ĭstutsip mŏks'enŭpanĭstosi otan'iipiaie prophet ki an'iu, ");
INSERT INTO bla_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","An'ĭstok Sion otŭn'ni, Sŭm'mĭs kitsĭn'aimau kitsipuksipa'ak, ikĭnĭs'siu, ki ŭskomŭk'stoki itokhitopiu, ki o'kosepokai ŭskomŭk'stoki o'kosaie. ");
INSERT INTO bla_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ki ŭsksĭnĭmats'ax itappo'iau, ki Jesus itŭn'ĭstutsimiax manistanĭstopiax. ");
INSERT INTO bla_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ki itsipuksipĭp'piauaie ŭskomŭk'stoki ki okose'pokai, ki itokh'itstomiau otsĭstotos'oauĕsts ki itsittokhitstsi'iauaie osto'i, ");
INSERT INTO bla_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ki ek'akaitappix saie'kuyiiauaie otsĭstotos'suauĕsts moksokui; ki stsĭk'ix kaiak'ĭmiau okŭn'iksĭsts ki moksoku'i itŏkh'tŭmiauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ki anniks'isk matap'pixk i'tomaumattoyixk ki itopokiuo'ixk, awk'umiau, ki an'iau, Hosanna ŭnnianistsitŭp'itsĭs David okkui: Atsĭm'siu annŏk' aipuksipu'ŏk nin'a otsĭn'ikŏsĭm; Hosanna mĭs'tŭpspiu. ");
INSERT INTO bla_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Otsitsipĭs'si Jerusalem, konai'akapioyis ap'aitsitaiau, ki an'iau, Tŭkka'ats? ");
INSERT INTO bla_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ki akai'tappix an'iau annŏk'auk Jesus Nazareth istsiprophet, Galilee ĭstauŏsĭm'im. ");
INSERT INTO bla_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ki Jesus itsipim Ap'ĭstotokiuă otatoi'apioyĭs ki anniks'ĭsk itsipst'anmŭtskotŭkixk, ki itsipstawk'pumaxk natoi'apioyĭs, itsai'tŭpiksĭstsiuax, ki au'ŏtsuautuyixk otsit'aisĭnakipuauĕsts ima'pĭxĭmĕsts, ki au'mŭtskotŭkixk kŭkku'ix otsasso'pŏtsuauĕsts ima'pĭxĭmĕsts. ");
INSERT INTO bla_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ki an'ĭstsiuax, Sĭn'aip, Noko'ai ak'anĭstop a'tsĭmoiikapioyĭs, ki ksĕsto'au kanĭs'tutsipuau kŏmos'iepĭtsix oko'auai. ");
INSERT INTO bla_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ki naps'tsix ki ŭs'tsekaiix itsipstotoyiauaie Natoi'apioyĭs; ki ikuttotoyiuax. ");
INSERT INTO bla_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ki omŭk'atoiapiekuax ki aisĭnakix, otĭnĭs'ĕsts skai'pĭssitapĭsts otap'ĭstutsipĭsts, ki pokax otsitsĭpst'awkkumsau natoi'apioyĭs, otan'ĭssau Hosanna ŭnnianĭstsitŭp'itsĭs David okku'i, eks'kaaisauŏkhsitŭkkiau. ");
INSERT INTO bla_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ki anĭstsiauaie, kikŭttaiaiokhtsĭp'ă otan'iipiau am'oxi? Ki Jesus an'ĭstsiuax, A; kikŭttomisauanĭstopa sĭnaksin, pokax ki ŭs'stax maau'auĕsts kumut'totssŭpanistsĭstutsip ĭstsak'sin? ");
INSERT INTO bla_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ki itskĭt'siuax ki akap'ioyĭs ittŭp'sŭxkitsĭmaie Bethany; ki annim' itsok'au. ");
INSERT INTO bla_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ki ksĭskŭna'tŭnni mat'skitapposi akap'ioyĭs, itun'otsiu. ");
INSERT INTO bla_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ki otsĭtsĭnno'ŏsi moksoku'i omŭx'iniĭstsĭsi, itoto'aie ki matsitokonĭmau'atsaie, nam'itaitsii suio'pokĭsts, ki anĭstsiuaie, Ŭnnianĭst'sauŭsksaiĭn as it ksĕsto'a. Ki omŭx'inĭstsĭs sotŭm'ikŭnipisuiu. ");
INSERT INTO bla_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ki ŭsksĭnĭmatsax otsĭnĭs'au, skai'etŭkkiau, ki an'iau, Mau'maikipikŭnipisuiu! ");
INSERT INTO bla_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus an'istsiuax, kitau'mŭnĭstopuau Aumaitŭkkienoainiki, saietŭkkienoeniki itsĭstuts'ipi omŭx'ĭnistsĭsi kimataksikaksĭstutsipa, ki nokŭt'anĭstomĭnoainiki am'o nitum'moi, ŭnĭstŭp'itsit, ki ŭnĭstŭp'apiksĭstŭkit omŭk'sikĭmi; ak'ŭnĭstutsip. ");
INSERT INTO bla_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kitak'omianĭstau'kŏmŏnipuai a'tsĭmoiikainoeniki aumai'tŭkkienoeniki, kitak'okoksuai. ");
INSERT INTO bla_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ki otsitsipĭs'si natoi'apioyĭs, omŭkatoiapiekuax ki matappix ot'omŭximoauax otŭs'ksĭnĭmatstŭksi ito'toiauaie, ki an'iau, Tsanĭstapotŭmapsĭn'na kumut'anĭstutsipiau am'ostsk? Tŭkka' kit'okokaii am'ok otŭmapsĭnnik? ");
INSERT INTO bla_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ki Jesus an'ĭstsiuax kitak'oksŭppoŏtsesattopuau tuks'kaii anik'ienoainiki kitak'ŏtanĭstopuau otŭmap'sĭnni numut'auanĭstutsipi am'ostsk. ");
INSERT INTO bla_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John ŏtŭs'tapĭnŭksĭnni, Tsema itotstsiu'ats? Spots'im, ki matap'pi? Ki ai'sĭtsĭpsattseiau, ki an'iau, mak'anĭnaniki spots' im; nitak'anikĭnan, kumauk'stauaumaitoauaiĭsksix? ");
INSERT INTO bla_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ki mak'aninaniki ma tap' pi, nitstŭnnauŭnaniau matap'pix; tŭk'ka ikŏn'auaniau John mŏkoprophetsi. ");
INSERT INTO bla_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ki anĭstsiauaie Jesus, ki an'iau, Nimatokot'anipĭnan. Ki an'ĭstsiuax, kimatokot'anĭstopuau otŭmap'sĭnni nimut'auanĭstutsipiau am'ostsk. ");
INSERT INTO bla_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ki Tsa kit'stapuau? Tuks'kŭmi matap'pi, na'tokŭm o'kosix; Ki matom'sii itoto'aie, ki an'iu, noko'ă, matap'otŭk kit annok' ksĭstsiku'i nitsĭn'sĭmman. ");
INSERT INTO bla_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","An'iu Nimat'akittappopa: ki itsako'isauaitsitau ki itsitap'po. ");
INSERT INTO bla_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ki matstsĭk'i itoto'aie ki mat'anĭstsiuaie. Ki an'iu nitak'ittappo, nin'ă; ki matsitappo'atsaie. ");
INSERT INTO bla_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tŭma' amoxi ŭs'satsĭma un'ni otsitsi'taniaie? An'ĭstsiauaie, Matom'siuă. Jesus an'ĭstsiuax, kitau'mŭnĭstopuau kitsauomai'pisuai Apĭstotokiŭa ĭstsĭn'naiisĭnni publicanĭx ki mats'akex ai'aksipimiau. ");
INSERT INTO bla_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tŭk'ka John kitsitota'akuau mokom'otsitappiisĭnni ĭstokh'sokui, ki kimataumaitoauau'ats: ki publicanix ki mats'akex au'maituyiauaie: ki ksĕsto'au kitsĭnĭs'uai kimatsakoisauaitsitapuaua kŏkaumai'toausuai. ");
INSERT INTO bla_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Okh'tsĭk stsĭk'i parable, itstsiu' tuks'kŭmi nĭn'au, nap'ioyĭs ĭstsĭn'aim, itsŭppipumattomaie ĭnsĭm'man min'istsix, ki itsĭstse'pĭskŭnattomaie, ki itatun'iakiu itsĭn'iokkeĭmskaupi, ki spiap'ioyĭs itap'ĭstutsĭmaie, ki itŏk'kumatokuyiuax ai'ĭnsĭmax ki itsi'pio: ");
INSERT INTO bla_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ki otas'tsĭssi mĭn'ĭsts otai'akitsetspiĕsts itŭp'skuyiuax otap'otomokix aiĭnsimax mŏk'okuyĭssi ĭstsĭn'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ki ai'ĭnsĭmax mat'tuyiuax otap'otomok-ix, ki tuks'kŭmi, itauaiak'iauaie, ki stsĭk'i initsi'auaie, ki stsĭk'i okotokix itau'aiakiauaie. ");
INSERT INTO bla_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ki mats'itŭpskuyiuax stsĭk'ix otapotomokix: ki netoi' an'ĭstutuyiauax. ");
INSERT INTO bla_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ki sako'okhtsim, itŭp'skuyiu okku'i, ki aniu, ak'atsĭmmimmiau noko'a, ");
INSERT INTO bla_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ki ai'ĭnsĭmax otsĭnno'ŏssau okku'i an'ĭstseiau Am'o otak'sinan; ki, ŏks'enĭtai, ki nŏksinan'attopĭnaniau otsinan. ");
INSERT INTO bla_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ki een'iauaie, ki itsai'tŭpiksĭstsiauaie ĭnsĭm'man, ki initsi'auaie. ");
INSERT INTO bla_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Oto'si insĭm'man istsĭn'aim, Tsa' akanĭstutuyia'atsax anniks'ĭsk ai'ĭnsĭmaxk? ");
INSERT INTO bla_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Anĭstsiauaie, ak'saiĭnaknaiatsĭstutuyiuax anniks'isk sauum'itsitappixk, ki ai'akŏkkumatuyiuax otsĭn'simman stsik'ix ai'ĭnsĭmax, anniks'isk aiakokotsiauaie ĭstsĭn'ĭsts aits'ĭsau. ");
INSERT INTO bla_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus an'ĭstsiuax, kikŭttomaisauanistopuaiĭsksix natoi'sĭnaksĭsts, Ok'otoki, annŏk itsĭs'tŭpapiksĭstauŭk aiokotoksapiokoĭskaiau, netoi'nitsiu koke'i ĭstotom'okotok; am'ok Nin'a ot'apĭstutŭksĭnni ki skaie'tsip noŏps'pĭnanĭsts? ");
INSERT INTO bla_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ŭn'nikaie kumut'anĭstopuau Spots'im istsĭn'naiisĭnni ak'otsip ksĕsto'au ki ak'okotau noke'tappix, anniks'isk aks'inasiĭxk. ");
INSERT INTO bla_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ki annŏk' ai'akittutŭtsĭnnĭssiuŭk annŏk' ok'otoki, aksi'ksĭsiu, ki annŏk' matap'iuŏk ai'akittutŭtsĭnĭssiuŭk okotoki aksipin'iau. ");
INSERT INTO bla_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ki omŭk'atoiapiekuax ki Pharisees otokh'tsĭmsau parables, ĭsksĭnĭm'iau osto'auai umutai'puyisaie. ");
INSERT INTO bla_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ki otap'sŭmmŏsax mŏk'sixenŏsax, ŭs'stŭnnuyiauax akai'tappix, tŭk'ka ŭ, 'taiau mŏk'siprophetsi. ");
INSERT INTO bla_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","KI Jesus mat'anĭstsiuax parables, ki an'iu, ");
INSERT INTO bla_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Spots'im ĭstsĭn'naiisĭnni netoi'nitsiu tuks'kŭmi omŭx'inau, okuyi otokem'si. ");
INSERT INTO bla_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ki itŭp'skuyiuax otap'otomokix moksĭnikŏttosaxax anniks'ĭsk otŭm'axk: ki matŭskak'sipuksipuax. ");
INSERT INTO bla_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ki mats'itŭpskuyiuax stsĭk'ix otap'otomokix, ki an'ĭstsiuax anĭstok'au anniks'isk ŭm'axk, Sat'sik, nikaw'apastutsip nitso'ŏssĭn: nitap'otskĭnamix ki nitunĭstakhtsimix ŭkainitaiau ŭk'okŏnaiksĭstsiiau: Puksipa'atok okem'sĭnni. ");
INSERT INTO bla_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ki ap'etsĭmiauaie, ki oksoku'oauĕsts itappoiau, tuks'kŭmi otsĭn'sĭmman, stsik'i otsit'aumŭtskotŭkkipi: ");
INSERT INTO bla_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ki stsĭk'ix mat'tuyiuax otap'otomokix, ki au'ksĭstutuyiuax, ki initsiu'ax. ");
INSERT INTO bla_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ki omŭx'ina otokh'tsĭmsi, itsĭs'tsetŭkkiu: ki itŭp'skuyiuax otseĕn'akemix, ki itsaiĭnakuaiĭstutuyiuax anniks'isk inĭk'ixk, ki itsĭn'sĭmaie otakap'ioyimoauaie. ");
INSERT INTO bla_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Itŭm'anĭstsiuax otap'otomokix, ŭk'aiksĭstsiu mak'okemsĭnni, ki anniks'isk ŭm'axk matsipumapsiu'ax, ");
INSERT INTO bla_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Itap'poak moksoku'ĭsts ki kĭt'okŏnaukonoaxk ŭm'mokau mak'okemsĭnni. ");
INSERT INTO bla_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ki anniks'isk apotŭkkixk itsitap'poiau moksoku'ĭsts, ki ikŏnau'moipiauax ot'okŏnokonoauax makap'six ki ŏkh'six: ki itsŭpanĭs'tsĭmiau ŭm'max. ");
INSERT INTO bla_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ki omŭx'ina otsipĭs'si mŏks'ĭnnoŏssax ŭmmax, nan'nuyiuaie nĭn'aii ikem'sĭnni ĭstsiso'kŏsĭmi, mat'sŭpskŏsattomaie; ");
INSERT INTO bla_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ki an'ĭstsiuaie, Napi'a, Tsa kanĭs'tsipipa kitsauomai'sŭpskŏsattosi ikem'sĭnni istsiso'kŏsĭmi? Ki matsepuyiu'ats. ");
INSERT INTO bla_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Omŭx'ina itŭm'anĭstsiuax otap'otomokix ĭs'ksipĭstok otsĭsts' ki okŏt'sĭsts, ki ĭs'tŭppĭppis, ki satŭp'iksĭstsĭs ski'natsi; ak'itstsiu asain'sinni, ki papŭx'ekĭnikani. ");
INSERT INTO bla_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Akai'tappix nanikŏttaiau: un'natosĭmix mat'toaiau. ");
INSERT INTO bla_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Itŭmĭs'tapuiau Pharisees, ki itauŭt'ŭnĭstsiiau mŏkĭtokonĭmŏsauaie ote'poawsĭstsaie. ");
INSERT INTO bla_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ki ipokitŭp'skuyiauax otŭsksinĭmatsauauax ki Herodians, ki an'ĭstsiauaie, Nin'a, nĭts'ksĭnipĭnan kitau'mŭni ki kitau'mŭnĭsksĭnĭmatstŭkki Ap'ĭstotokiuă oksoku'i, ki kimatsŭmman'ax matap'pix: tŭk'ka, kimatsatsipats manistŭp'apitappiipiau. ");
INSERT INTO bla_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Anik'ĭnan, Tsa kit'stapa? Ŏkh'siuats mŏk'otsiponitasi Cæsar, tsŏktau mat'ŏksiuats? ");
INSERT INTO bla_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ki Jesus nan'ĭmaie otsau'okŏmotsitappiisuai, ki an'iu kumauk'saksksĭnokipuauaiists kitsiksĭs'tapokŏmotsitappiansuai? ");
INSERT INTO bla_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ŭnĭs'tsĭnŭmmokĭk mixkĭm, kumut'siponitapi. Ki ito'tsĭpotuyiauaie nitai'pŭnasainiini. ");
INSERT INTO bla_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ki an'ĭstsiuax, tŭkka' am'o ostoksĭs'ă, ki tŭkka' osĭnaksĭn'ats? ");
INSERT INTO bla_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","An'ĭstsiauaie, Cæesar otsinan'. Itŭm'anĭstsiuax kotok' Csesar otsinan'ists, ki Ap'ĭstotokiuă kotok' otsinan'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Otokh'tsĭmsau annists'isk epo'awsĭstsk itskai'etŭkkiau, ki itskĭt'siauaie, ki oksoku'auai itappo'iau. ");
INSERT INTO bla_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Neto'ik ksĭstsiku'ik, Saducees, anniks'isk an'iisk matsitstsipats matsipuau'osĭnni itoto'iauaie, ki ai'sŭppoŏtsesattsiauaie, ");
INSERT INTO bla_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ki an'iau, Nin'a, Moses itŭni'u enĭs'si nĭn'au, ki saiitstsĭssi pokax, oskŭn' akokem'attsi'ĭnaii otokem'an, ki ak'ksĭstauŭttomuyiuaie us'i pŏkax'. ");
INSERT INTO bla_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Annok' ikit'sikŭmiau umu'pappiipix; ki matom'si otokem'attosi, its en'iu, ki otsai'itstsĭssi o'kosix itskĭt'siuaie otokem'an oskŭn' mŏk'okemattosaie: ");
INSERT INTO bla_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Neto'initsiu oskŭni enĭs'aie, ki omat'oskŭni ki ikĭt'sikŭmiau ikŏnen'iau. ");
INSERT INTO bla_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ki itsako'ieniu ake'u. ");
INSERT INTO bla_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Matsipuau'osĭnni tŭkka' otakokeman'atsaie, ikĭt'sikŭmĭx? Tŭk'ka ikŏnau'tuyiauaie. ");
INSERT INTO bla_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus an'ĭstsiuax. Kitai'patsĭstutsipuau kimatsksĭnipuauĕsts natoi'sĭnaksists ki ototŭmap'sĭnni Apĭstotokiuă. ");
INSERT INTO bla_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Matsipuau'sax matokemiu'axau matapikau'axau. Netoi'nitsiau Ap'ĭstotokiuă otatsĭm'otokatatsix Spots'im. ");
INSERT INTO bla_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Annik' matsipuau'awsĭnnĭk kikŭttomisauanĭstop'ats annik' kitan'iipik Ap'ĭstotokiuă. ");
INSERT INTO bla_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nĕsto'akauk Abraham otsinan Ap'ĭstotokiua ki Isaac otsinan' Ap'ĭstotokiuă, ki Jacob otsinan' Ap'ĭstotokiuă Ap'ĭstotokiuă enix' matsinan'oauats, sa'kiaitappiĭx otsinan'oauax Ap'ĭstotokiuă. ");
INSERT INTO bla_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ki akai'tappiix otokh'tsĭmsau skai'etsĭmiau otŭsksĭnĭmats'tŭksĭnni. ");
INSERT INTO bla_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ki Pharisees otokh'tsĭmsau ot'omaupŭtsŏssax Saducees, itauŭtomoi'piotseiau. ");
INSERT INTO bla_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ki tuks'kŭmi, lawyer, ai'sŭppoŏttsesattsiuaie, ki as'aksksĭnnuyiuaie, ki an'iu, ");
INSERT INTO bla_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Nia'a, tse'a omŭk'o okŏk'itsimani ĭstse'poawsĭsts? ");
INSERT INTO bla_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus an'ĭstsiuaie, Kitak'ŭkomĭmmau, Nin'a Ap'ĭstotokiua kitokŏnai'uskĕttsipŏppi, kitokŏnai'staaw, ki kĭtokŏnai'tsitani. ");
INSERT INTO bla_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Am'oi matom'iu ki omŭk'o epo'awsĭnni. ");
INSERT INTO bla_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ki pok'iotomi netoi'nitsiu, Kitak'ŭnĭstŭkomĭmmau kĭtopokau'pimok kanĭstŭk'omĭmmospi. ");
INSERT INTO bla_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Annists'isk na'tokaistsk epo'awsĭsts, ikŏnaukŏkitsimanĭsts ki prophetix otan'ipĭsts ikŏn'itaitsiiĕsts. ");
INSERT INTO bla_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Otsakiaumoi'piotseĭsau Pharisees, Jesus sŭppo'ŏttsesattsiuax, ");
INSERT INTO bla_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ki an'iu, Tsa kitstatau'ats Christ? Tŭkka' oko'atsaie? An'ĭstsiauaie David okoai'e. ");
INSERT INTO bla_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","An'ĭstsiuax, David umut'ainĭstainikŏttaupiaie Nin'ă, otanipi, ");
INSERT INTO bla_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ap'ĭstotokiuă an'ĭstsiuaie nĭn'a, netots'i tŭpo'piĭt, nŏk'ŭnĭstutoŏsau kikatum'ix kitsitautŭtsekau'pipi? ");
INSERT INTO bla_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David ninikŏt'tŭssi Nĭn'a, Tsa otak'anĭstoko'atsaie? ");
INSERT INTO bla_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ki matap'pi matsitstsipa mŏk'okotsĭtsĭpsăttosi tuks'kai epo'awsĭnni, ki annik' ksĭstsiku'ik matap'pi matokot'sakosŭppoŏttsesattau. ");
INSERT INTO bla_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","JESUS itŭm'sĭtsĭpsiuax akai'tappix ki otŭsksĭnĭmats'ax, ");
INSERT INTO bla_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ki an'iu, Ai'sĭnakix ki Pharisees, Moses otsiso'pŏtsĭsaie itau'piau: ");
INSERT INTO bla_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ŭnnikaie kitomian'ĭstaniipuai sat'sĭk ki nĭstutsĭk'. Ki manĭstsĭs'tutsipiau, pinan ĭs'tutsik: tŭk'ka itan'iau, ki matsĭstutŭkkiu'axau. ");
INSERT INTO bla_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Issoksĭs'tsĭsts itau'monĭmiauĕsts soku'ĕsts mŏkopa'tosau ki matap'pix otsĭstsoauĕsts itotom'iauĕsts; ki osto'auai matakotsĭstŭpakiotsĭm'axauĕsts tuks'kŭmi okĭt'suauax. ");
INSERT INTO bla_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Otokŏnap'otŭksuauĕsts itsĭstuts'ĭmiauĕsts mŏksĭnnu'yĭsau matap'pix: itopŭx'ĭstutsĭmiauĕsts phylacteries, ki itomŭx'ĭstutsĭmĕsts otsaieno'tŭksuauĕsts, ");
INSERT INTO bla_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ki ŭkome'tsĭmiauĕsts oye'tanĭsts ĭstotom'iapioyĭsts, ki natoi'apioyĭsts ĭstotom'isopŏtsĭsts. ");
INSERT INTO bla_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ki otsitau'pĭsau itau'pumaupi aiksemattsĭni'otseisĭnni, ki mŏks'ĭnikŏttosau, Rabbi, Rabbi. ");
INSERT INTO bla_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pinĭs'tsĭnikŭkĭk Rabbi: tuks'kŭmă kitsĭn'aimoauă, Christ: ki ksĕsto'au kĭtokŏnaix'okoauax. ");
INSERT INTO bla_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ki Pini'nikŏttok matap'pi, annom' ksŏk'kum, kĭn'a; tuks'kŭmă kĭn'oaua annŏk' spots'im itau'piuŏk. ");
INSERT INTO bla_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ki pinitsĭn'ikŭkĭk Nin'ax: tuks'kŭma kitsĭn'aimoaua, Christ. ");
INSERT INTO bla_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Annŏk' omŭx'ĭmŏk ksĕsto'au, kitak'apotomokoau. ");
INSERT INTO bla_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Annŏk' ak'omuxĭstutosiuŏk, aks'inŭxĭstutoau; ki annŏk' aksinŭx'ĭstutosiuŏk, ak'omŭxĭstutoau. ");
INSERT INTO bla_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kitaks'ksĭnipuau maka'pi ksĕsto'au ai'sĭnakix ki Pharisees, kitsiksĭs'tapokŏmotsitappiansuai! Kitsitaiok'iauaiau matap'pix Spots'im ĭstsĭn'naiisĭnni: ksĕsto'au kimatsitaipipuau'ats, ki aiaksipimix kimats'epokkitsetomauaxau mŏk'itsipĭsau. ");
INSERT INTO bla_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kitaks'ksĭnipuau maka'pi ksĕsto'au ai'sĭnakix ki Pharisees, kitsiksĭs'tapokŏmotsitappiansuai! Nam'akex oko'auĕsts kitau'attopuaiau, ki kitaisŭmiksĭstapatsĭmoiikapuau: mĭs'tŭpkapii kitakoku'yisuai. ");
INSERT INTO bla_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kitaks'ksĭnipuau maka'pi ksĕsto'au ai'sĭnakix ki Pharisees, kitsiksĭs'tapokŏmotsitappiansuai kitotka'atau ksŏk'kum ki omŭk'sikĭmi kŏk'itokonoŏsi tuks'kŭmă matap'iuă mŏkĭtanĭs'tsitsitasi kanĭstsitsi'tawpi kitaumaitu'yĭssi, kanĭstŭm'ipuai ksĕsto'au Hell oku'yix kitak'anĭstsĭstokiaiĭstutoauau. ");
INSERT INTO bla_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kitaks'ksĭnipuau maka'pi ksĕsto'au kitsaps'tsiotŭpĭnŭkipuau, kitan'ipuau annŏk' akitup'ŭtauŭniuŏk omŭk'atoiapioyĭs matsikiu'ats, ki annŏk' akitŭp'ŭtauŭniuŏk omŭk'atoiapioyĭs ĭsto'tokuiĭxkĭm, aks'ĭstutsĭmaie! ");
INSERT INTO bla_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kitŭt'tsapspuau, kitsaps'tsiipuau: Tsĭma' omŭk'o. Otoku'iĭxkĭm, ki omŭk'atoiapioyĭs annik' itatsĭm'mĭmmiik otoku'iĭxkĭm. ");
INSERT INTO bla_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ki annŏk' akitŭp'ŭtauŭniuŏk altar, matsikiu'ats; ki annŏk' akitŭp'ŭtauŭniuŏk kotŭk'sĭnni altar itokhĭts'tsipi, ai'aksĭstutsĭmaie. ");
INSERT INTO bla_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kitŭt'tsapspuau, kitsaps'tsipuau Tsĭma' omŭk'o, kotŭk'sĭnni, ki altar annŏk' itatsĭm'etsĭmŏk kotŭk'sĭnni? ");
INSERT INTO bla_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Annŏk' aiakitŭp'ŭtauŭniuŏk altar, itup'ŭtauŭniu altar ki mian'ĭsttokhĭtstsii. ");
INSERT INTO bla_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ki annŏk' aiakitŭp'ŭtauŭniuŏk omŭk'atoiapioyĭs, itŭp'ŭtauŭniu omŭk'atoiapioyĭs ki annŏk' iko'attomŏk. ");
INSERT INTO bla_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ki annŏk' aiakitŭp'ŭtauŭniuŏk spots' im, itŭp'ŭtauŭniu Ap'ĭstotokiuă otspiso'pŏtsis ki annŏk' itokhittaupiuŏk. ");
INSERT INTO bla_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kitaks'ksĭnipuau makapi ksĕsto'au ai'sĭnakix ki Pharisees, kitsiksĭs'tapokŏmotsitappiansuai! Kitai'ponitasuai mint ki anise ki cummin, ki ĭssoku'ĭsts kimatsatsipuauĕstsau, okŏk'itsimanĭsts, kĭm'apiisĭnni ki aumai'tŭksĭnni: am'osts ŏkh'si kŏk'satsŏsuaiau; ki mat'ŏkhsiuats kŏk staiĭstutsĭssuai stsĭk'ists. ");
INSERT INTO bla_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kits' apstsiotŭpĭnŭkipuau, kitai'soautsauau inŭx'soĭsksĭssi, ki kitaits'ĭssttimauau camel: ");
INSERT INTO bla_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kitaks'ksĭnipuau maka'pi ksĕsto'au ai'sinakix ki Pharisees, kitsiksĭs'tapokŏmotsitappiansuai! Kŏs'ă ki saiĕtso'kosi sauauts'i kitŭs'siipuaiau, ki pĭstots'ĭm itui'tsiau minĭk'otŭksĭnni ki auŭt'tseisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kitsaps'tsii Pharisee, matom'siitau pistots'im kos'ă ki saiĕtso'kosa mŏk'ŭtsitsiksixĭssi sauauts'i, ");
INSERT INTO bla_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kitsaks'ksĭnipuau maka'pi ksĕsto'au ai'sĭnakix ki Pharisee kitsiksĭs'tapokŏmotsitappiansuai! Ksĭkoken'imanĭsts kine'tŭmanĭstspuau ai'ŏkhsĭnipiau sauauts'ĭstsi, ki pĭstots' im itui'tsiau enix' okin'oauĕsts ki makap'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Netoi'nitsiii ksĕsto'au kĭto'kŏmotsitappiĭnipuau matap'pi, ki pĭstots'im kitotuitskitsipuai ksĭs'tapokŏmotsitappiisĭnni ki sauum'itsitappiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kitaks'ksĭnipuau maka'pi ksĕsto'au ai'sinakix ki Pharisees, kitsiksĭs'tapokŏmotsitappiansuai! Kitap'ĭstutsipuaiau prophetix otoken'imanoauĕsts, ki kita'nŭtsĭstutsipuaiau mokŏm'otsitappix otoken'imanoauĕsts, ");
INSERT INTO bla_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ki kitanipuau nitsa'kiaitappiipĭnanopi nĭn'anĭx otsa'kiaitappiisau nĭs'tasauopoksĭstokemaumŭnanopiau prophetix otsa'apŭnoauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ŭn'nikaie kit'auŭtanipuau, ksĕsto'auŭkauk anniks'isk matap'pixk initsixk' prophetsix o'kosoauax. ");
INSERT INTO bla_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tu'itok kĭn'oauax otsauum'itsitappiisuauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Pitseksĭnax, opĭx'exĭnasĭnna, Tsa'a kitakanĭstupĭs'tapixsattopats Hell ĭstokŏk'itsimani? ");
INSERT INTO bla_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ŭn'nikaie, sat'sĭk kĭtakittŭp'skoaiau ksĕsto'au prophetix, ki mokŏk'ietappix ki ai'sĭnakix: ki stsĭk'ĭx kitax'enitauaiau ki kitiikau'aistauaiau; ki stsĭk'ĭx kitakitsipstŭstsipĭs'auaiau kitatoi'apioyimoauests, ki kĭtak'auksĭstutuauaiau amian'ĭstakap'ioyĭsts otai'akitsipĭsau: ");
INSERT INTO bla_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mŏkĭttokh'ittaitsĭssi ksĕsto'au kŏnau'kŏmotsitappiaapŭni ksŏk'kum itsai'kimskaii. Abel mokŏm'otsitappiuă otsa'apŭn itŭpots'tsiuaie Zacharias, Barachias okku'i otsa'apŭniaie annŏk', kitsitsenitauauŏk itŭt'sikatsi omŭk'atoiapioyĭs ki altar. ");
INSERT INTO bla_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kitau'mŭnĭstopuau kŏnai'sĭstskă aunok' o'tappiisĭnna akĭtotu'iĕsts. ");
INSERT INTO bla_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalem, Jerusalem ksĕsto'auă kitai'nitauaie prophetĭx, ki anniks'isk itŭp'skuaxk ksĕsto'auă ok'otokĭx kumutauauaiak'iauaiau, nŏkstanĭstsikapumoi'piauopi ko'kosoauax nipuau'ă manĭstau'moipiopi o'kosĭx ki kimat'ŏkhsitsipuau'ats! ");
INSERT INTO bla_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sat'sĭk, Koko'auai nam'itaitsiu kĭt'skĭtomoko. ");
INSERT INTO bla_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kitan'ĭstopuau, ĭssoots'i kimatakainokipuaua sauanenoainiki Atsĭm'siu annŏk' paiuksipu'ŏk Ap'istotokiuă otsĭn'ikŏsĭm. ");
INSERT INTO bla_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","KI Jesus itsŭx'iu ki itsĭs'tŭpaatomaie omŭk'atoiapioyĭs ki otŭsksĭnimatsax itoto'iauaie mŏkanĭs'tsĭnnomoŏsauaie omŭk'atoiapioyĭs ĭstap'ĭstutŭksĭnni. ");
INSERT INTO bla_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ki Jesus an'ĭstsiuax kikŭttaisauainipuauastsau kŏnai'ĭstsk? Kitau'mŭnistopuau, matakskĭt'aupa okotoki mŏkstaiĭna'piksĭstosi. ");
INSERT INTO bla_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Otsĭt'tokhitaupĭssi nitum'moyi Olives, ŭsksĭnĭmats'ax isĭmitoto'iauaie, ki an'iau, Anik'ĭnan Tsanĭstsĭs' akanĭstsiu'astsau? Ki tsa akanĭstsiu'a kitsipuksipusĭnni, ki punsksŏk'kuasĭsi? ");
INSERT INTO bla_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ki Jesus an'ĭstsiuax Iskskats'ĭk kŏkstaipĭstsiksĭstutu'yisuai. ");
INSERT INTO bla_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Akai'tappix ak'ŭtsitotoiau nitsĭn'ikŏsim ki ak'aniau Christ nĕsto'akauk; ki ak'sipĭstsiksĭstutuyiauax akai'tappix. ");
INSERT INTO bla_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ki kitakokhtsĭmattopuaii auakaw'tseisĭsts ki mak'auakawtseisĭsts: Sats'sĭk kŏkstai'apaitsitasuai; konai'istsk ak'itstsiau; ki umut'aketsĭnikawpi matomoto'ats. ");
INSERT INTO bla_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aiok'auaua aksipua'tseiau aiokauai'i ki nin'naiisĭnni aksipua'atomiau nĭn'naiisĭnni; ki ak'unnatosiu aau'ŏssĭnni, ki ak'itstsiu okh'tokosĭsts, ki ksŏk'kumă otaks'ikauopiisĭsts, ki akokŏnau'toitstsiiau. ");
INSERT INTO bla_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Am'osts Istokŏnau'mŭtŭpipuĭnawkuyii' sists. ");
INSERT INTO bla_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kitakaumŭts'kakipuau kŏkĭtapauksĭstutoksi, ki kĭtaks'enikoaiau: ki kŏnai'okauaua kumutaks'tsĭmmĭmmokoau nitsĭn'ikŏsĭm. ");
INSERT INTO bla_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ki akai'tappix akĭstskĭmskŭkiau ki akaumŭts'katseiau, ki akau'kĭmotseiau. ");
INSERT INTO bla_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ki akaiĕm'ix ksĭs'tapsix prophetix aksipuauiau ki aksipĭsksĭs'tutuyiuax. ");
INSERT INTO bla_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ki sauo'kŏmotsitappiisinni otakau'osi, akai'tappix otŭkome'tŭksuaii akstuyiuaie. ");
INSERT INTO bla_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ki annŏk' eikak'ĭmauŏk umuk'itsipi aksikŏmotse'piau. ");
INSERT INTO bla_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ki am'ok nĭn'naiisĭnni ĭstŏkh'sitsĭniksĭnni ak'anĭstop kŏnŭs'ksŏkkum, kŏnai'okoaua mŏks'ksĭniĭsauaie; ki umuk'itsipi ak'otŭmitoto. ");
INSERT INTO bla_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ninĭm'ĭnnoainiki ŭs'tsĭmetsipi Daniel otan'ĭstopi atsĭm'apii ĭstai'puyĭssi (annŏk' an'ĭstomŏk ŭnnĭsts'ksĭnĭssi:) ");
INSERT INTO bla_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Anniks'isk Judæa itau'pixk ŭnnianĭstitŭpoks'kasau nitum'moĭsts: ");
INSERT INTO bla_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Annok' itokh'itaupiuŏk oko'ai pĭnŭnĭsts'ĭnĭssaatos mŏk'sauautsĭssi itsipsts'tsii oko'ai: ");
INSERT INTO bla_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Annŏk' ĭnsĭmman itau'piuŏk pinŭt'ŭnĭstsskos mŏk'otsĭssi otsĭstotos'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Anniks'isk ipitap'piixk ki ŭs'takataxk aksksĭnĭmiau makapi annists'ĭsts ksĭstsiku'ĭsts! ");
INSERT INTO bla_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Atsĭmoiikak kŏk'stautsĭmutasuai stuyĭssi, ki ĭssĭk'opiiksĭstsikui. ");
INSERT INTO bla_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Annik' omŭx'ipuĭnasĭnni ak'itstsiu, istsitsĭs'si ksŏk'kŭm, ki annok' manĭsts'ipuĭnapspi, aksĭs'tŭpŭnĭstsipuĭnapsiu, ki ĭs'sotsk matakotŭmanĭstsipuĭnapsiu'ats. ");
INSERT INTO bla_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ki annists'ists ksĭstsiku'ĭsts sauun'natsĭstutsĭsĕsts mat'akitstsipa matap'pi itsikŏmotse'piaiau; aumai'tŭkkixk, osto'auai itunnats'ĭstutsĭmĕsts annists'ĭsts ksĭstsikuĭsts. ");
INSERT INTO bla_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kŭmĭts'tsiki matap'pi kitai'akaniki Sŭm'mĭs, am'auk Christ, ki om'auk; pinau'maitos. ");
INSERT INTO bla_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ksĭs'tapsix Christix akitsipuau'iau ki ksĭs'tapsix prophetix, ki akanĭs'tsĭnnŭkiau omŭk'apstosĭsts ki pĭsats'kasĭsts; ki ikŭm'itstsiki aks'ipĭstsiksĭstutuyiauax aumai'tŭkkixk. ");
INSERT INTO bla_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sat'sik, kikau'anĭstopuau. ");
INSERT INTO bla_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kŭm'anĭstsenikiau sat'sit ksĭs'tapsksŏkkuyi ŭn'amauk; pini'tappoat; Sa'sit, sĭmiap'ioyĭsts ŭn'amauk; pinaumai'tŭkkik. ");
INSERT INTO bla_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ksĭstsikum' manĭsttotsipuksipupi umut'autstsipi apinŏk'kuyi, ki manĭstsitŭpikŭnatspi ame'totsi; netoi' ak'ŭnĭststsiu nĭn'au okku'i otos'aie. ");
INSERT INTO bla_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mĭksĭnii otsits'tsipi, ŭn'nim pi'tax akomooi'iau. ");
INSERT INTO bla_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Annists'ĭsts ksĭstsiku'ĭstsk ĭstsipu'ĭnasĭsts otaiksiuos'au, nato'si akski'ĭnŭm, ki kokum'ikesŭm matakanakĭmauats, ki kŏk'atosix akotots'ĭnĭssiau, ki spots'im otsĭs'kŏpsĭnni akauŭt'apixip: ");
INSERT INTO bla_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ki Nin'auă okku'i otap'stosĭnni akitsĭnakoaie spots'im: ki ksŏk'kum ĭstokŏnai'tappix ak'otŭmauyesiau, ki aks'ĭnnoyeiau Nĭn'au okku'i spots'im istsĭssoksĭs'tsikuĭsts itsipsts'otosi, otŭmap'sĭnni ki omŭxĭk'kŭnnasĭnni akopoto. ");
INSERT INTO bla_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ki ak'itŭpskuyiuax otatsĭm'otokatatsix ak'soksĭkkiax, ki aumai'tŭkkixk akitotomoi'piiauax, nĭssoo'ĭsts sopu'ĭsts ki spots'im umuk'itsipi: ");
INSERT INTO bla_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Annok', ĭsksĭnik parable omŭx'ĭnĭstsĭs; okŭn'iksi otsa'kiŭkkĭnĭsĭssi, ki otsuio'pokassi, kitsksĭnipuau nepu'yi itasts'tsiu; ");
INSERT INTO bla_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Neto'i maks'ĭnĭmenoainiki annists'isk, ĭsksĭnik, mŏkaststsĭssi, ito'to okh'sepĭstanĭsts. ");
INSERT INTO bla_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kitau'mŭnĭstopuau am'oi o'tappiisĭnaii mataksĭstapu'ats otsauomaisŭpanĭs'tsiosau annists'isk. ");
INSERT INTO bla_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Spots'im ki ksŏk'kum ak'eitsĭnikau, ki nitse'poawsĭsts matakeitsĭnikau'ĕstsau. ");
INSERT INTO bla_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Annik' ksĭstsiku'ik ki annik' itai'ksĭstsikumiopik matsksĭnĭm'ats matap'pi, Spots'im ĭstso'tokatatsix matsksĭnĭm'axauaie, Nin'a nits'ksĭnĭmaie. ");
INSERT INTO bla_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noe otsiksĭs'tsikumĭsts manistsi'piĕsts, netoi' ak'anĭsttsiiĕsts Nĭn'au okku'i oto'saie ");
INSERT INTO bla_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Otsauomo'kŏnaiokkeuasi ksŏkkum manĭstau'yipiau ki manĭstai'sĭmipiau, manĭstok'kemipiau manĭsta'pikŏttŭkkipiau, itŭp'itsiu annik' ksĭstsikuik, Noe otsit'sŭppopĭssi akh'iosatsĭs. ");
INSERT INTO bla_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ki matsksĭnĭm'axau otsauomo'kŏnaiokkeuasi ki itsau'inakuaiĭstutuaiau; netoi' ak'anĭstsiu Nĭn'au okku'i oto'saie. ");
INSERT INTO bla_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Natsitappiix akotŭmitau'piiau insĭm'man: nituks'kŭmi ak'otoau, ki stsĭk'i ak'skĭtau. ");
INSERT INTO bla_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Natsitappiĭx akex' akĭtaipĭk'iakiau; nituks'kŭmi ak'otoau, ki stsĭk'i ak'skĭtau. ");
INSERT INTO bla_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ŭn'nikaie mokŏkik: kimats'ksĭnipuau annik' itai'ksĭstsikumiopik kitsĭn'aimoau otai'akĭtotopik. ");
INSERT INTO bla_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Am'okă ĭsksĭnĭk', Napioyĭs ĭstŏkhsĭn'auă otsksĭnĭm'opi annik' itai'ksĭstsikumiopik otai'akitotosi kŏmos'iepĭtsĭuă ĭs'taiŭskskŭmiuopi, ĭstai'saiepukĭtsetsĭmopi oko'ai ĭstokitsĭm'i mŏkopokse'ĭsaie. ");
INSERT INTO bla_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ŭn'nikaie ŭk'aisŭppuiapĭstotosĭk; kitsit'sisauaitsitatopuai, Nĭn'au okku'i ak'itoto. ");
INSERT INTO bla_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tŭkka' aumai'tŭkki ap'otŭkkiuă, ki mokŏk'i apotŭkkiuă annŏk' otsĭn'aim otĭnaiăts'okŏk oko'ai ĭstsitappim'ix, mŏk'okŏmotokotŏsax otso'ŏsĭnoauĕsts? ");
INSERT INTO bla_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Atsĭm'siu annŏk ap'otŭkkiuŏk, otsĭn'aim oto'saie otak'okonokaie netoi' it'ŭnĭstsĭstutsimaie. ");
INSERT INTO bla_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kitau'mŭnĭstopuau, akokŏnitainaiăts'iuaie otokŏnai'nanĭsts. ");
INSERT INTO bla_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ki annŏk sauum'itapotŭkkiuŏk, makotots'anĭssi u'skĕttsipŏppi ai'sŭmsiu nitsĭn'aim; ");
INSERT INTO bla_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ki makaumŭtŭpauaiak'iŭssi ot'opokapotŭkkimax, ki makopoks'oyimŭssi ki mak'opoksĭmimŭssi ai'sĭmix; ");
INSERT INTO bla_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Annŏk' ap'otŭkkiuŏk otsĭn'aim ak'oto annik' kustsiku'ik otsauomŭsks'kŭmosaie, ki annik' itai'ksĭstsikumiopik otsauomŭs'ksĭnniĭssi, ");
INSERT INTO bla_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ki akaiaketsĭn'iuaie, ki aiakokotsiuaie mŏk'itaupĭssaie otsitau'pipiax ksĭstapokŏmotsităppiansix: annim' ak'itstsiu asain'sĭnni ki satse'kĭnani. ");
INSERT INTO bla_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","SPOTS' IM ĭstsĭn'naiisĭnni aketum'anĭstsiau ke'pix ake'kuax, anniks'isk mat'tuyixk ot'anakimatsuauĕsts, ki itsux'iau mŏkota'tsemŏsau annŏk' ai'akokemiuŏk. ");
INSERT INTO bla_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ki nĭs'itsix mokŏk'iau, ki nĭs'ĭtsix mat'tsapsiau. ");
INSERT INTO bla_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Anniks'isk mat'tsapsixk nito'tsĭmiau ot'anakimatsuauĕsts, ki, mattotŭkkiu'axau okke'anakĭmatsĭs: ");
INSERT INTO bla_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ki mokŏk'ixk ipok'iotscmiau otanakimatsuauĕsts okke'anakĭmatsis, kos'ĭx itsŭp'pitŭkkiau. ");
INSERT INTO bla_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Annŏk' ai'akokkemiuŏk otai'sŭmsi, ikŏnai'okano'piiau ki ikŏnai'okax. ");
INSERT INTO bla_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ki itŭt'sikiikokoi ikum'iŭstutsip, sat'sik, ak'okemiuă ai'puksipu; Sŭksĭk' kŏkotatsemŏssuai. ");
INSERT INTO bla_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Itŭmokŏnaipuau'iau am'ox ake'kuax, ki ikŏn'itaisŭppasuyĭnŭkiau otanakimatsuauĕsts. ");
INSERT INTO bla_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ki mat'tsapsix an'ĭstsiauax mokŏk'ix, kok'ĭnan kitŏk'keanakĭmatsuai; tŭk'ka, nitan'akimatsĭnanĕsts ŭk'aiitsĭnikaiau. ");
INSERT INTO bla_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ki mokŏk'ix an'ĭstsiauax, Sa; matakakauo'ats ksĕstŭn'un: Is'tapuk aumŭts'kotŭkkix kŏk'opumattosuai. ");
INSERT INTO bla_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ki otsakiaitapposau mŏk'opumattosau, aiakokemi ito'to; ki anniks'isk sopuiap'ĭstotosĭxk ipok'sipimiauaie okkem'sĭnni: ki ai'okip. ");
INSERT INTO bla_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Sako'okhtsi mat'tsapsix nokŭt'otoiau ki an'iau, Nin'a, nin'a, kauai'pĭxĭkĭnan. ");
INSERT INTO bla_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ki an'ĭstsiuax, kitau'mŭnĭstopuau kimats'ksĭnopuauats. ");
INSERT INTO bla_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ŭn'nikaie mokŏkĭk', tŭk'ka, kimats' ksĭnipuauats annik' ksĭstsiku'ĭk ki annik' itai'ksĭstsikumiopik Nin'au okku'i otai'akĭtotopik. ");
INSERT INTO bla_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Spots'im ĭstsĭn'naiisĭnni netum'anĭstsiu nĭn'au annŏk' piuo'ŏk, ki ninikŏt'tsiuax otap'otomokix, ki ikotsiu'ax otsinan'ĭsts. ");
INSERT INTO bla_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ki tuks'kai ikotsiu'aie nĭsĭtsi'i itawk'pumaupix ki stsĭk'i na'tokai, ki stsĭk'i nituks'kai; ki kŏnai'tappix itanistokotsiu'ax manĭst'okotsĭstutsipiau; ki itau'matto. ");
INSERT INTO bla_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Annŏk' ikuyiu'ok nĭsĭtsi'i itawk'pumaupix itsĭs'tapu, ki itau'mŭtskotŭkkiu, ki ikuyiu' stsĭk'ix nĭsĭtsix itawk'pumaupix. ");
INSERT INTO bla_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ki netoi annŏk' ikuyiu'ŏk na'tokŭmi, ikuyiu' stsĭk'ix na'tokŭmĭx. ");
INSERT INTO bla_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ki annŏk' ikuyiu'ŏk nituks'kŭmi itsĭs'tapu, ki itatŭn'akiu ksŏk'kum, ki ai'ksasattomaie otsĭn'aim otsĭxkĭmim'iaie. ");
INSERT INTO bla_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Otai'sŭmmosi, am'ox ap'otŭkkix otsĭn'aimoauai itoto'yiĭnai, ki ipokoks'tŭkimiuax. ");
INSERT INTO bla_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ki annŏk ikuyiu'ŏk nĭsĭtsi'i itawk'pumaupix ito'to ki ito'tsĭpatopiau stsĭk'ix nĭsitsix itawk'pumaupix, ki an'iu, Nin'a, kit'okŏk nĭsitsi'i itawk'pumaupix: Sat'sĭt nitokuinan' matsĭs'ĭtsix. ");
INSERT INTO bla_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Otsĭn'aim an'ĭstsiuaie, kitŏkhs'ĭstututŭkki, ŏkhs'apotŭkkiuă ki emŭn'apotŭkkiuă: kitse'mŭnŭssatsipiau un'natosĕsts, kitakĭnai'atso akauo'iĕsts: Kitsĭn'aim otse'tametŭksĭnni ĭstsipi'it. ");
INSERT INTO bla_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Annŏk' iku'yiuŏk natokŭm itawk'pumaupix ito'to ki an'iu, Nin'a, kit'okok natokŭmi itawk'pumaupix: Sat'sit, nimat'okuinani mats'ĭstokai itawk'pumaupix. ");
INSERT INTO bla_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Otsĭn'aim an'ĭstsiuaie, kitŏkhs'ĭstutŭkki, okhs'apotŭkkiuă ki emŭn'apotŭkkiuă; kitse'mŭnŭssatsipiau un'natosĕsts, kitakĭnai'atso akauo'iĕsts: Kitsĭn'aim otse'tametŭksĭnni ĭstsipi'ĭt. ");
INSERT INTO bla_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Annŏk' ikuyiu'ŏk tuks'kŭmi itawk'pumaupi ito'to ki an'iu, Nin'a kits'ksĭno ksĕsto'a kitse'ĭnai, kikŭt'tomaisŭppipumattopi kitai'pokiaki, ki kikŭttomauanit'apixipi kitomoi'pitŭkki; ");
INSERT INTO bla_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ki nĭtsiko'pum, ki nitsit'tappo ki nitai'ksasattop ksŏk'kum kitsinană itawk'pumaupi: Sat'sit, kĭtsinan. ");
INSERT INTO bla_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Otsĭn'aim an'ĭstsiuaie, kitsauum'apotŭkkiuă ki kitsistap'apotŭkkiuă, kitsksĭnoki nitai'pokiaki nikŭttomai'sŭppipumattopi, ki nitomoi'pitŭkki, ni kŭttomauanit'apĭxipi: ");
INSERT INTO bla_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kumaukstauokotaiĭsksĭxau au'awtsoomŭtskotŭkkix nitsĭx'kĭmĭmĭx, ki nitsitotopi nŏk'staitokuyitopi nitsinan'ix ki umut'okuyesix. ");
INSERT INTO bla_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mattomok'aie itawk'pumaupi, ki kotok' annŏk iku'yiuŏk ke'pix itawk'pumaupix. ");
INSERT INTO bla_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Anniks'isk iku'yixk ak'okotaiau, ki otaksinanoaiau akauo'i: ki annŏk' itsau'okuyiuŏk ak'otomoau annik' ooko'ŏsĭnik. ");
INSERT INTO bla_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ki ĭstŭp'satŭpiksĭstsĭs ap'otŭkkĭuă itsau'okuyiuă ski'natsii: ak'itstsiu asain'sĭnni ki satse'kĭnani. ");
INSERT INTO bla_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Otak'ĭtotosi Nin'au okku'i otstsa'pĭnasĭnni ipokom'ŏssau otokŏnatsĭm'otokatatsĭx, ak'otŭmotokhitaupiu otsĭstsapĭsso'pŏtsĭs: ");
INSERT INTO bla_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ki akokŏnipotamoi'piaiau ikŏnai'okauaua: ki aiakanĭstaiaketaipĭksĭstaiau emŭk'ikĭnaikuŭn manistai'aketaipiksĭstopiax emŭk'ikĭnax ki apomŭk'ikĭnax: ");
INSERT INTO bla_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ki akotŭpĭpiuax emŭk'ikĭnax onet'otsĭs ki ap'omŭkikĭnax otse'aksĭssauotsĭs. ");
INSERT INTO bla_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Omŭx'ina akotŭm'anĭstsiuax anniks'isk onetotsĭs itau'pixk, Puk'sipuk, Nin'a otatsims'imix, ki nĭn'naiisĭnni matsĭk' annik' kitapĭstutomokiiik, otsauomap'astutoŏssi ksŏk'kum. ");
INSERT INTO bla_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nitse'nots, ki kit'okokipuau aau'ŏsĭn; nitse'naki, ki kitsit'tutokokipuau: nitsi'piitappi, ki kito'tokipuau: ");
INSERT INTO bla_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nimatsĭstotospa, ki kitsĭs'totosatskokipuau; nitokh'tokos, ki kitsĭpĭs'kotokipuau; itai'okiakiopi nitsitau'pi, ki kitsittotaakipuau. ");
INSERT INTO bla_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mokŏm'otsitappix akotŭm'anĭstsiauaie, Nin'a, tsanistsi'i kit sits' In o pin an kitau'nots, ki kits is' so pi Q an? Ki kitse'naki, ki kitiitakopinan. ");
INSERT INTO bla_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tsanĭstsi'i kitsĭts'ĭnopĭnan, kitsi'piitappiisi ki kito'tosĭnĭn? Ki kimatsĭstotospa, ki kitsĭstotos'atskopĭnan? ");
INSERT INTO bla_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tsanĭstsi'i kitsĭts'ĭnopĭnan kitai'okhtokos, ki kitsitau'pĭssi itai'okiakiopi ki kĭtsito'taatosĭnan? ");
INSERT INTO bla_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ki omŭx'ina ak'anĭstsiuax, kitau'mŭnĭstopuau kanistitŭpĭstutsipuai tuks'kŭma inŭx'tsĭma am'ox nĭx'okoax, kitanĭsts'ĭstutomokipuau. ");
INSERT INTO bla_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Akotŭm'anĭstsiuax anniks'isk ote'aksĭsautsĭs itau'pixk, ĭs'tapuk emŭtskax mŏkseĭnsau, ŭsksustsinasii ĭs'tapuk, ek'aisepŭtsĭstotomoiiauax au'tutsokiuă ki oto'tokatatsix: ");
INSERT INTO bla_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tŭk'ka, nitau'nots, ki kimatsĭssok'ipuaua: nitse'naki, ki kimat'tutukkokipuaua: ");
INSERT INTO bla_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nitsi'pitappi, ki kimat'otokipuau: nimats'ĭstotospa, ki kimatsĭstotosats'kokipuaua: nitokh'tokos, ki nitsitau'pi itai'okiakiopi, ki kimat'sipĭskotokipuaua. ");
INSERT INTO bla_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Osto'auai ak'otŭmanĭstsiiauaie, Nin'a Tsanĭstsi'i kitsĭts'ĭnopĭnan kitau'nots, ki kitse'naksi, ki kit'sipitappisi, ki kitokh'tokosi, ki kitsitaupĭssi itai'okiakiopi kŏkstaikawk'anĭstotŏsĭnan? ");
INSERT INTO bla_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ai'akotŭmanĭstsiuax, kitau'mŭnĭstopu au kanĭst'saiitŭpĭstutsipuai tuks'kŭmă inŭxtsĭma amox, kimat'anĭstsĭstutomokipuaua. ");
INSERT INTO bla_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ki am'oxi aksĭstŭpitappo'iau ŭsk'sĭtauksĭstototspi: ki mokŏm'otsitappix akittappoiau ŭsk'sipaitappiisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","KI itŭnĭstsiu, Jesus otaiksĭste'poattosĕsts am'ŏsts epo'awsĭsts, itŭn'ĭstsiuax otŭsksĭnĭmatsax, ");
INSERT INTO bla_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Kĭtsksĭnipuau aisto'kŭssi ksĭstsiku'ĭsts ak'itstsiu passover, ki Nĭn'au okka'i itaumŭts'kau mŏk'ĭtsiksĭstoxŏsi. ");
INSERT INTO bla_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Omŭk'atoiapiekuax, ki aisĭnakix, ki matap'pix otsĭn'aimoauax itŭmitŭpaumooiau sp'a'toiapiekuŭn Caiaphas oko'aii. ");
INSERT INTO bla_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ki ai'sĭtsĭpsattseiau mŏk'anistokotsisĭmmiotoŏsauaie Jesus, ki mŏk'itsenitŏsauaie. ");
INSERT INTO bla_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ki an'iau, pinĭts'tsĭs oye'tani ĭstsiksĭs'tsikui ŏkskakŭmĭstsikĭniau matap'pix. ");
INSERT INTO bla_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus otsitau'pĭssi Bethany, Simon leper oko'ai otsitsĭpsts'taupĭssi, ");
INSERT INTO bla_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ake'ua itoto'aie, ipa'tŭkkiu alabaster atŭxak'sin puye' itsŭp'patomaie, akai'ĭnxkĭmasiuaie, ki otau'yisaie itsita'suyĭnĭnmaie otokŏn'iaie. ");
INSERT INTO bla_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ki otŭksĭnĭmats'ax otsĭnĭs'saxaie, ĭstse'tŭkkiax, ki an'iau mauk'etsĭnikatopi? ");
INSERT INTO bla_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Am'ok ipum'atotopi ĭs'taiekekaiĭxkĭmasiuopi, ki kĭm'atapsix ĭs'tauokotauopiauaie. ");
INSERT INTO bla_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus otokh'tsĭmsi, an'ĭstsiuax, kumauk'sauaiksĭxinoauaiisksĭx ake'uă ŏkh'siu nitapĭstutu'yipi. ");
INSERT INTO bla_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ksĕsto'au, kĭmatapsix kitŭsk'sauopoksemokoaiau; ki nĕsto'a kimat'ŭsksauopoksemokipuaua. ");
INSERT INTO bla_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Am'ok puye' nostŭm'i otsĭta'suyĭnĭssi itsĭstuts'imaie mŏkĭtsopuiapĭstutuyĭssi nŏkitak'itsasi. ");
INSERT INTO bla_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kitau'mŭnĭstopuau am'oi ŏkhs'itsĭniksĭnni amianĭstan'ĭstopi kŏnŭs'ksŏkkumă, am'ok, am'o ake'uă otap'ĭstutsipi ak'ŭtanĭstomaie, mŏk'ĭtŭsksĭnoŏsi. ");
INSERT INTO bla_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na'tsikoputsix, tuks'kŭmă, anĭstau Judas Iscariot, itappo omŭk'atoiapiekuax, ");
INSERT INTO bla_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ki an'iu, tsanĭstap'pi kitak'okokipuaii, ki nitakitŭp'omutskau ksĕsto'au? Ki nitsi'tuyiauaie niĭp'pii ksĭxĭx'kĭmĭx. ");
INSERT INTO bla_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ki annik' itot'apsatsim mŏk'itamŭtskŏsaie. ");
INSERT INTO bla_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ke'tani kŭt'taikopŭtstsii, ĭstotom'iksĭs'tsikui, ŭsksĭnĭmats'ax itoto'iau Jesus, ki an'ĭstsiauaie, Tse'a kit'stapa kŏk'sopuiapĭstutosĭnan kŏk'kĭtsoyĭsi passover? ");
INSERT INTO bla_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ki an'iu ĭs'tapuk akap'ioyĭs, ki om'ŭmă nĭn'auŭmă anĭstok', Nin'a, an'iu, nitsiksĭstsikum'i aststsi'u: koko'ai nitŭs'ksĭnĭmatsax nitak'opoksoyimaiau passover. ");
INSERT INTO bla_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ki ŭsksĭnĭmats'ax manĭstan'ĭstopiax itan'ĭsttutsĭmiax; ki itso'poŭtsĭstutsĭmiau passover. ");
INSERT INTO bla_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ki otau'tŭkkusi, ipokitau'pimiuax na'tsikoputsix. ");
INSERT INTO bla_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ki otau'yĭsau, an'iu, kitau'mŭnĭstopuau tuks'kŭmă ksĕsto'au kĭtakaumŭts'kauki. ");
INSERT INTO bla_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ki eks'kaiĭkikĭn'etŭkkiau, ki ikŏnau'mŭtŭpanĭstsiauaie, Nin'a nĕsto'akats? ");
INSERT INTO bla_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ki an'iu, annŏk okĭt'sĭs nitopoksĭstapĭmakemauok kos'i nitakaumŭts'kauk. ");
INSERT INTO bla_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nin'au okku'i itanĭsts'itappo nitsĭn'awpi: ak'itŭpokapiu annŏk' nĭn'auŏk imŭts'kaiuŏk Nĭn'au okku'i! Kŭt'taipokaiiuopi annŏk' nĭn'auŏk, ĭs'taŏkhsiuopi. ");
INSERT INTO bla_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas anni'ĭsk itse'mŭtskaukisk, itŭm'anĭstsiuaie, Nin'a nĕsto'akats? An'ĭstsiuaie, kitan'i. ");
INSERT INTO bla_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ki otau'yĭsau Jesus ito'tsĭmaie ke'tani ki itatsĭm'ĭstutsĭmaie, ki itaumin'ĭmaie, kĭ ikotsiu'ax ŭsksĭnĭmats'ax, ki an'iu, Matsĭk', oyik'; am'oiauk nostŭm'i. ");
INSERT INTO bla_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ki mat'tuyiuaie kos'i ki thanks ikotŭk'kiu, ki ikotsiu'ax, ki an'iu kŏnai'sĭmattok; ");
INSERT INTO bla_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Am'okauk nitsa'apŭn, mananĭsts'etoksĭnni itŭp'itsiu itsai'kimskau akai'tappix otsauum'itsitappiisuauĕsts mŏk'sinĭsĕsts. ");
INSERT INTO bla_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ki kitan'ĭstopuau nimatakŭtsĭmattopa am'ok mĭniokke sauomo'pokitsipstsĭmattomĭnaniki manĭs'si nin'a ots'ĭnnaĭisĭnni. ");
INSERT INTO bla_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ki otinik'sau natoi'ĭniksĭnni itŭp'sŭxiau nitum'moyi Olives. ");
INSERT INTO bla_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesus itŭm'anĭstsiuax, nĕsto'a kĭtak'okŏnŭsskĭmskŭkipuau annok'ă koko'ikă: tŭk'ka, sĭn'aip, nitak'auaiakiau annŏk' ŭsks'kŭmiuŏk emŭk'ikĭnax, ki ot'omŭkikĭnauăsĭnna ĭsto'mŭkikĭnax akŭneto'iau. ");
INSERT INTO bla_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aiksistatsipuau'eniki kitakitŭpotoma'topuau Galilee. ");
INSERT INTO bla_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter an'istsiuaie, ikŭm'okŏnŭstsskĭmskŭkĭssau ksĕsto'a, nimat'akĭstsskĭmskŭkipa. ");
INSERT INTO bla_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus an'ĭstsiuaie, kitau'mŭnĭsto, Annok' koko'ik otsauomit'awkkumsi nipuau'ă nioks' kai kitakani kimatsksĭnok'ipa. ");
INSERT INTO bla_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter an'ĭstsiuaie ŏkskakŭmopoks'eniop, nimat'akanipa kimatsksĭnopa; neto'i ikŏnau'aniiax ŭsksĭnĭmats'ax. ");
INSERT INTO bla_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesus itŭmitŭpopokomiuax Gethsemane an'ĭstop, ki an'ĭstsiuax otŭsksĭnĭmatsax, annom' stau'pik, nitakittappo omim' nŏkĭtŭt'tsĭmoiikasi. ");
INSERT INTO bla_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ki mat'tuyiuax Peter, ki Zebedee otsĭstok'iokuyix, ki itaumŭtŭpĭkikĭn'etukki ki itau'mŭtŭpeikapitsitau. ");
INSERT INTO bla_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Itŭm'anĭstsiuax nitsitŭpĭkikĭnetukki e'ĭnsĭnni: annom' stau'pik, ki ŏk'itŭskskatŭkkiop. ");
INSERT INTO bla_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ki pa'tsiĭstŭpaatsiuax, ki ĭsstokopi'u ostoksĭs', ki itŭt'tsĭmoiikau ki an'iu, Nin'a, ikŭm'okotsitstsĭssi am'oi kos'a ŭnnianistĭs'tŭpipotoŏssi; nimatakitsitan'ats, ksĕsto'a kitak'itsitan. ");
INSERT INTO bla_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ki matskitoto'ax otŭsksĭnimats'ax, ki ikon'oyiuax oto'kaniax, ki an'ĭstsiuaie Peter, Awx'ats? Kikŭttaukotŭskskŭmmokipa tuks'kai itai'ksĭstsikumiopi? ");
INSERT INTO bla_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mokŏk'etsĭk ki a'tsĭmoiikak, kŏkstaitsipĭssuai ĭssaks'ksĭnŭksĭnni; sta'aw itsitsi'tatomaie ki ĭx'isakuyi matsi'uats. ");
INSERT INTO bla_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ki mats'ĭstapu ki itŭt'tsĭmoiikau, ki an'iu, Nĭn'a, am'oi kos'a sauomot'aisĭmmieniki sauomĭs'tŭpipotomokoeniki, kĭtak'itsitan. ");
INSERT INTO bla_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ki mat'oto ki mat'okonoyiuax otsok'asax: tŭk'ka ĭssoksĭm'au oŏps'puauax. ");
INSERT INTO bla_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ki itskĭtsiuax, ki mats'ĭstapu, ki nioks'kai itŭt'tsĭmoiikau, ki netoi' au'aniu. ");
INSERT INTO bla_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Itŭm'itotoiax otŭsksĭnĭmats'ax ki an'ĭstsĭuax okak' annok, ki issĭk'sĭstsikok: sat'sik aststsiu' itai'ksĭstsikumiopix, ki Nin'au okku'i itŭp'aumŭtskau sauum'itsitappix otsu'auĕsts. ");
INSERT INTO bla_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nipuak', ŏkittăppau'op: annŏk' nitakaumŭts'kaukŏk aststsiu'. ");
INSERT INTO bla_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ki otsa'kiai epuyĭssi, Sat'sik, Judas, na'tsikoputsix tuks'kŭmă ito'to ki akai'tappix ipokom'iauaie inus'stoanix ki sŏksĭs'tsĭsts ipa'tŭkkix, itototoiau omŭk'atoiapiekuax ki matap'pix otsĭn'aimoauax. ");
INSERT INTO bla_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ki annŏk' imŭts'kaĭuŏkaie ikotsiu'ax apsto'sinni, ki an'iu, annŏk' nitak'sĭnnauskippauŏk, an'nŏkauk: mi'eenok. ");
INSERT INTO bla_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ki ikŏm'itoto Jesus, ki aniu, Hail, Nin'a; ki itsĭn'nauskĭppiuaie. ");
INSERT INTO bla_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ki Jesus an'ĭstsiuaie, Napi'ă, kumauk'sipuksipuksĭks? Itŭmitoto'iauaie ki een'iauaie Jesus, ki mat'tuyiauaie. ");
INSERT INTO bla_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ki sat' sit, anniks'isk ipokom'iskaie Jesus, tuks'kŭma itsitŭpikĭns'tsakiuaie otsĭn'usstoan itsau'tuyiuaie, ki sp'a'toiapiekuŭn tuks'kŭmi otap'automok ot'auaiakiokaie, ki kŏk'sĭnĭmaie okhtok'ĭsaie. ");
INSERT INTO bla_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus itŭm'anĭstsiuaie, kitsĭn'usstoană otsits'tsipi ĭststsi'ĭs; anniks'ĭsk matap'pixk mat'tuyixk inus'stoan, inus'stoan itax'enittaiau. ");
INSERT INTO bla_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kit'stapa nŏkŭttokotsitŭp'atsĭmoiikani nin'ă, ki annok' nŏk'okuyĭssi otsĭtsksĭstsikoputsix legionix otatsĭm'otokatatsix? ");
INSERT INTO bla_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tsa akokototŭmunĭstsĭstutsipa natoi'sĭnaksĭsts, mŏk'itŭnĭstsĭssi? ");
INSERT INTO bla_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Neto'ik itai'ksĭstsikumiopik Jesus an'ĭstsiuax akai'tappix, kikŭt'anĭstsipuksipa'akipuaua kanĭst'sitappopuau kŏmos'iepĭtsi annŏk' pa'tŭkkiuŏk inus'stoax ki sŏksĭs'tsĭsts, kŏk'otoksuai? Anĭs'tsiksĭstsikuĭsts kitopokau'pimopuau omŭk'atoiapioyĭs kŏkŭsksĭnĭmats'opuau ki kimatseen'okipuauă. ");
INSERT INTO bla_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ki am'ostsk ikŏnaiĭstutsipi mŏks'enŭpanĭstosau prophetix osĭnak'suauĕsts. Ikŏnŭsksĭnĭmatsax itŭm'skĭttsiiau ki ai'tsĭmmutaiau. ");
INSERT INTO bla_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ki anniks'isk een'ixkaie Jesus itŭpĭpiauaie Caiaphas, sp'atoiapiekuŭn, itomoi'piawpiau ai'sĭnakix ki omŭks'ĭmix nĭn'ax. ");
INSERT INTO bla_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ki Peter piaapŭtsitŭpa'tseuaie sp'atoiapiekuŭn oko'ai, kiitsipim' ki ipokau'pimiuax ap'otŭkkix mŏkitokŏnai'nĭsi. ");
INSERT INTO bla_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Annok', omŭk'atoiapiekuax ki omŭks'imix nĭn'ax ki ikŏnau'kŏkitsĭmax, ĭstŭp'iksĭstapenŭpanĭssĭnni ap'satsĭmiau mŏks'enitŏsauaie Jesus; ");
INSERT INTO bla_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ki matokonim'axau; otsito'tosax akai'tappix aiksĭstapenŭpanix, matokonĭm'axau. Sako'okhtsim ito'toĭau na'tsitappiix ai'tapksĭsenŭpanix, ");
INSERT INTO bla_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ki an'iau, am'o nin'au an'iu nitokot'opŭksĭnip Ap'istotok'iuă otatoi'apioyis ki nitokot'sokapĭstutsip nioks'kai ksĭstsiku'i. ");
INSERT INTO bla_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ki Sp'atoi'apiekuŭn itsipuau', ki an'ĭstsiuaie, kitakstaie'puyipa? Tsanĭstapiu'a am'ox kitse'nŭpanipiau? ");
INSERT INTO bla_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ki Jesus matsepuyiu'ats. Ki Sp'atoi'apiekuŭn mat'anĭstsiuaie, kita'tauŭnĭsto Ӑp'istotokiua ipai'tappiiuă, kŏk'aniksĭnan ikŭm'ŭmeniki Christ, Ap'ĭstotokiuă okku'i. ");
INSERT INTO bla_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus an'istsiuaie, kitsemŭniani; ki kitan'ĭsto sako'okhtsim kitaks'ĭnoauai'ĭni Nin'au okku'i, otsitau'pĭssi otŭmap'sĭnni ĭstset'otsĭsi ki umutsipuk'sipusi Spots'im ĭstsisoksĭs'tsikuĭsts. ");
INSERT INTO bla_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sp'atoi'apiekuŭn itŭmai'pinotsĭmĕsts otsĭstotos'ĭsts ki an'iu, itŭpepo'atomaie Ap'ĭstotokiuă; nitak'otsikipĭnana stsik'ix e'ĕnŭpanix? Sat'sik, kikai'okhtoauau oksĭs'tapinikŏttsimani. ");
INSERT INTO bla_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tsa kit'stapuauă? An'iau, mŏks'eĭnsi. ");
INSERT INTO bla_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Itŭm'itaisokuttŭttsiauaie ostoksĭs'aie, ki oto'auĕsts itsĭtauaiak'iauaie: ki stsĭk'ix omi'tsĭxikĭnstspuauĕsts itsĭtauaiak'iauaie. ");
INSERT INTO bla_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ki an'iau, ksĕsto'a Christ e'ĕnŭpanikĭnan, Tŭkka' kĭtauaiak'ioka? ");
INSERT INTO bla_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Annok' Peter sauauts'im itau'piu, ĭstokĭtsĭm'i pĭstots'im: ki ake'kuŭn itoto'aie, ki an'iu, ksĕsto'a kitopokom'au Jesus Galilee ĭstsitappim'i. ");
INSERT INTO bla_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ki paiot'anĭstsiuax matap'pix nimatsksĭnoau'ats nimatsksĭnipa kitan'ipi ");
INSERT INTO bla_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ki otsitŭp'sŭxsi kĭtsĭm'iapioyĭs, stsĭk'i ake'kuŭn nan'nuyenaie ki an'ĭstsiuax anniks'isk matap'pixk itau'pixk, ani'o nin'au nokŭt'opoksimiuaie Jesus, Nazareth istsitappim'i. ");
INSERT INTO bla_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ki mata'toŭniu, ki an'iu, nimatsksĭn oau'ats nĭn'au. ");
INSERT INTO bla_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ki otai'pĭstsĭksisŭmmosi anniks'ĭsk itai'puyixk itoto'iauaie, ki an'ĭstsiauaie Peter, E'mŭniu, ksĕsto'akauk tuks'kŭmă: kitse'poawsĭsts kitse'ĕnŭpaniki. ");
INSERT INTO bla_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Itŭmaumŭtŭpipako'sĭnepuyiu, ki itaumŭtŭpŭtau'ŭniu, nimats'ksĭnoau'ats nĭn'au. Ki nipuau'ă sokĭt'okumiu. ");
INSERT INTO bla_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ki Peter ĭsksĭnĭm'aie Jesus ote'poawsinniaie, annik' itanĭs'tsiuaie, otsauomokh'kumsi nipuau'a nioks'kai kitak'ani kimatsksĭnokĭpats. Ki itsŭx'iu, ki itsok'auasainiu. ");
INSERT INTO bla_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","OTAP'INŎKKUSI, kŏnau'mŭkatoiapiekuax ki matap'pix otsĭn'aimoauax itŭp'okŏkitsĭmaiau Jesus mŏks'enitŏsauaie; ");
INSERT INTO bla_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ki otai'ĭsksipĭstŏssauaie, itŭnĭstŭppĭp'iauaie, ki itŭp'aumŭtskaiauaie Pontius Pilate, anni'ĭsk nĭnai'isk. ");
INSERT INTO bla_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, anni'isk otse'mŭtskaukĭsk, otsĭnno'ŏsaie, otanĭs'sax mŏks'eĭnsi, itsisauai'tsitau, ki mat'skittotsĭpotuyiuax omŭk'atoiapiekuax ki omŭks'imix nĭn'ax niĭp'pix ksĭxĭx'kĭmix, ");
INSERT INTO bla_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ki an'iu, nikai'sauumitsitappi nitse'mŭtskatop mokŏm'otsaapŭnni. Ki an'iau, Tsanĭstappi nitokanĭstappikipĭnan'a? Ksĕsto'a kitak'satsip. ");
INSERT INTO bla_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ki itsipsts'ĭstŭpapiksĭstsiuax ksixĭx'kĭmix omŭk'atoiapioyĭs, ki itsĭs'tapu, ki itsiko'kŏpsiu. ");
INSERT INTO bla_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ki omŭk'atoiapiekuax mat'tuyiauax ksĭxĭx'kĭmĭx, ki an'iau, matŏkhsiu'ats ŏk'itsŭppitsŏsau atsĭm'isokaiĭs, tŭk'ka aa'pŭnni ipum'attomiau. ");
INSERT INTO bla_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ki itau'kŏkotomotseiau ki itopum'attomiau potter otsĭn'sĭmman, pie'tappix mok'itstsŏsau. ");
INSERT INTO bla_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ŭn'nikaie itŭsks'unnĭstainikŏttop a'apŭnni ĭstsĭn'sĭmman. ");
INSERT INTO bla_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Itŭmeĕnŭpanĭstomaie annik' otan'ipikaie Jeremy prophet, ki an'iu, Ki mat'tuyiauax niĭp'pix ksĭxĭx'kĭmix, umutopum'attopiaie annŏk' Israel itŭniau ŭnni mŏkanĭstsĭxkĭmasi; ");
INSERT INTO bla_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ki itopum'attomiauaie potter otsĭn'sĭmman, nanĭstŭn'ik Ap'ĭstotokiuă. ");
INSERT INTO bla_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ki Jesus paio'tsipuyimiuaie, nĭn'aii; ki nĭn'auă ai'sŭppoŏttsesattsiuaie, ki an'iu kikŭtam'ipa Jews otsĭn'aimoauai? Ki Jesus an'ĭstsiuaie, kitan'i. ");
INSERT INTO bla_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ki Omŭk'atoiapiekuax ki omux'ĭnax ote'ĕnŭpanĭstŏsauaie, matsepuyiu'ats. ");
INSERT INTO bla_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilate itŭm'anĭstsiuaie, kikŭttaisauokhtoau'axau akauo'yi kĭtse'nŭpanikoĭsts? ");
INSERT INTO bla_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ki tuks'kai epo'awsĭn matanĭstsiu'atsaie; ki Nĭn'auă eik'skaietŭkkiu. ");
INSERT INTO bla_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Annok' oye'tani nĭn'aua itŭsksaipotoyiuaie tukskŭm'i eĕn'naii ot'statauaie matap'pix. ");
INSERT INTO bla_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Annik', nannan'attsiau tuks'kŭmi eĕn'naii, Barabbas an'ĭstau. ");
INSERT INTO bla_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ŭn'nikaie otokŏnau'moŏsax, Pilate itŭnĭs'tsiuax, Tŭkka' kĭt'statauă kŏks'ipotomosuai? Tsŏktau Barabbas, tsŏktau Jesus, annŏk' anĭstauŏk Christ? ");
INSERT INTO bla_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tŭk'ka ĭsksĭnĭm'aie umutsiksĭssat'siuŏsau, itaumŭts'kau. ");
INSERT INTO bla_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Otsitau'pĭssi okŏk'itsimani ĭstsiso'pŏtsĭs, otokem'an itŭpŭt'okŏttsiuaie ki an'ĭstsiuaie, pinotokan'ĭstappikit om'ă mokŏm'otsitappiuă: tŭk'ka akauo'iĕsts nit'okuyipists pu'ĭnasĭsts ni'papaukanĭsts annok' ksĭstsiku'ik, osto'i itots'tsiĕsts. ");
INSERT INTO bla_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ki omŭk'atoiapiekuax ki omŭx'ĭnax eikakĭmattsiauax matap'pix mŏk'aukŏmŏnĭstŏsauaie Barabbas, ki Jesus mŏks'eĭnsaie. ");
INSERT INTO bla_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nin'auă an'ĭstsiuax, Tŭkka' na'tokŭmix kitstatauau'a kŏks'ipotomoŏssuai? An'iau Barabbas. ");
INSERT INTO bla_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate an'istsiuax Tsa nitakŭnnĭstutoau'ats Jesus, anĭstauŏk Christ. Ikŏn'auanĭstsiauaie, ŭnnianĭstauai'ĭstais. ");
INSERT INTO bla_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ki nĭn'auă an'iu, kumauk'anĭstauaisksĭks? Tsanĭstapiu'ăts otsauum'itsĭstutŭksĭnni? Ki akauo'yi itsokse'puyiau ŭnnianĭstauai'ĭstais. ");
INSERT INTO bla_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Otsĭnĭs'si, otsau'otokanĭstappikĭssaie, ki otai'akitstsĭssi ăsĭnata'pii ito'tŭkkiu okke', ki itŭs'tsĭmmiu otsipot'aipuyimŏsax matap'pix, ki itŭniu', nimat'ototoimoko'ă am'o mokŏm'otsitappiaă otsa'apŭnni: ksĕsto'auă sat'sĭk. ");
INSERT INTO bla_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Itŭmokŏnai'puyiau matap'pix, otsa'apŭnni ŭnnianĭsttots'tsĭsaie nĕstŭn'an ki no'kosĭnanix. ");
INSERT INTO bla_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Itŭmipo'tomoyiuax Barabbas: ki otai'ksĭstĭstsipĭsŏsaie Jesus, emŭts'kaiuaie ŏksiksĭs'toxŏsaie. ");
INSERT INTO bla_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ninauă otseĕnnakem'ix itŭpĭp'iauaie Jesus itokŏno'paupi, ki itokŏnaumoi'piiau eĕn'nakex. ");
INSERT INTO bla_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ki itsau'tomoyiauaie otsĭstotos'ĭstsaie, ki mawks'isokŏsĭmi itsŭps'kaiauaie. ");
INSERT INTO bla_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Otai'amitsĭnĭssau ksĭssiĭstsŭmmokŏni, itsĭs'tsŭmmokiauaie ki apai'i itstom'iauaie onet'otsĭsaie: ki auanaukopĭstuksĭs'akŏttsiauaie, ki ai'ksĭstapanĭstsiauaie, ki an'iau, Hail, Jews otsĭn'aimoauai! ");
INSERT INTO bla_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ki ai'sokotuttsiauaie, ki matsĭmiau apai'i ki otokŏn'iaie itsitau'aiak iauaie. ");
INSERT INTO bla_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Otai'ksĭstsiksĭstapanĭstŭsauaie, asso'kŏsĭmi itsauts'imiauaie, ki otau'ŭtsisokŏsĭmaie itsŭps'kaiauaie, ki itsĭstapĭp'iauaie mŏk'auaiistasauaie. ");
INSERT INTO bla_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ki otsŭks'au, ikonoyiauaie nĭn'aii Cyrene istsitappim'i, otsĭnikŏsim Simon: ĭsskuopa'atsiauaie otauai'staksĭn, ");
INSERT INTO bla_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ki otsito'tosau Golgotha an'ĭstop, itokĭsasiĭk, mŭksikĭnŭkotokŏnik, ");
INSERT INTO bla_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ikotsi'auaie moksĭmatossaiaii' ĭstsipoku'yi ki gall ipa'sokasuyĭnĭmiauaie: ki otŭt'totsĭsaie, mat'skaksĭmattom'atsaie. ");
INSERT INTO bla_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ki itau'aiistaiiauaie, ki otsĭstotos'ĭsts, ki aiaketotsipiests, itsi'kŏtsotsiĕsts: mŏks'eĕnŭpanĭstosi annik' otan'ipik prophet, itai'aketotsipiĕsts nitsĭstotos'ĭsts ki itsi'kŏtsopnaaiua. ");
INSERT INTO bla_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ki ito'piiau ki ŭs'sŭmmiiauaie annim'; ");
INSERT INTO bla_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ki itstom'iauaie otokŏn'i spots'i ksĭs'tapanĭssĭnni sinaip', Am'ok Jesus, Jews otsĭn'aimoauai. ");
INSERT INTO bla_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na'tsitappix kŏmos'iepitsix ipauai'istauax tukskŭm'i onet'otsĭsi ki stsĭk'i otse'aksĭssautsĭs. ");
INSERT INTO bla_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ki anniks'isk itsits'skuixk au'kapsĭtsĭpsattsiauaie, ki auauŭkia'pĭxiau, ");
INSERT INTO bla_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ki an'iau ksĕsto'a annŏk' ipŭxĭn'ĭmŏk omŭkatoi'apioyĭs, ki nioks'kai ksĭstsikuĭsts itsiksĭst'apĭstutsimŏk, kŏmotse'piosit. Ikŭm'ŭmeniki Ap'istotokiuă okku'i ĭnĭsa'atoat auai'staksĭn. ");
INSERT INTO bla_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Neto'i omŭk'atoiapiekuax netoi'nitaiksĭstapanĭstsiauaie, kiai'sĭnakix ki omŭx'ĭmix ipokaniau, ");
INSERT INTO bla_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kŏmotse'piuax stsĭk'ix ki matokotsikŏmotsepiosiu'ats. Ikŭmŭm'ĭssi Israel otsĭn'aim, ŭnanistsĭnnĭsa'atos auai'staksĭn, ki nitakaumai'tauŭnan. ");
INSERT INTO bla_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Au'maituyiuaie Apĭstotoki'i: annok' ŭnnianistsikŏmotse'piŏsaie, maksinan'attŭsaie: tŭk'ka iŭniu', nĕsto'akauk Ap'istotokiuă okku'i. ");
INSERT INTO bla_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kŏmos'iepitsix ipok'auaistapixk neto'yistsk nokŭtsitŭp'apiximiauĕsts okhpe'kĭsts. ");
INSERT INTO bla_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nau'yi itai'ksĭstsikŭmiopi konŭs'ksŏkkumă itŭp'skinatsiu piksu'yi itaiksĭstsikumiopi. ");
INSERT INTO bla_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ki otsipik'susi itai'ksĭstsikumiopi, Jesus aisokse'puyiu. Ki itŭni'u, Eli, Eli, lama sabachthani? Annik' ito'kĭsasiik, Nitap'ĭstotokim, Nitap'ĭstotokim, kumauk'skĭkiks? ");
INSERT INTO bla_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Stsĭk'ix itai'puyĭxk, otokh'tsĭmsau', an'iau, Am'o nĭnau nan'nikŏttsiuaie Elias. ");
INSERT INTO bla_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ki tuks'kŭmă itauks'kasiu ito'tukkiu ai'ksĭppuyĭnip, ki ito'kĭmiuaie ĭstsipoku'yi, ki itstom'aie apai'i, ki ikotsiu'aie mŏksĭmattosaiai'i. ");
INSERT INTO bla_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Stsĭk'ix an'iau, ki'ka, ŏk'satsip maks'ikŭmipuksipusi mŏksikŏmotse'piĭsaie. ");
INSERT INTO bla_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus ota'atsoksepuyĭssi, itaumŭts'kaiuaie Sta'aw. ");
INSERT INTO bla_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ki Sat'sit, omŭk'atoiapioyĭs itsi'koksok'iakiopi ai'aketsĭnikau, spots'im itots'ipinikau; ki ksŏk'kumă itsi'papuyiu, ki ok'otokskuĭsts ai'aketopiiau; ");
INSERT INTO bla_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ki a ken 'i man ists kau'opiiau; ki atsĭm'six anniks'ĭsk ai'okaxk akaiĕm ostŭm'oauĕsts itsipuau'ax, ");
INSERT INTO bla_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ki ota'atsipuawsi Jesus, itsux'iau aken'imanĭsts, ki itŭp'ipimiau atsĭmakap'ioyĭsi, ki otsĭnok'oaiau akai'tappiix. ");
INSERT INTO bla_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Annok' eĕnakin'au'ă, ki otopokom'ixk, otopokŭs'satŭkkimaxk Jesus, otsĭnno'ŏsau ksŏk'kumi otsi'papuyiisi, ki otsĭnĭs'sau annists'isk ĭstutsip'ĭstsk, eks'kaikopumiau, ki an'iau am'o emŭn'iŭmiu Ap'ĭstotokiuă okku'i. ");
INSERT INTO bla_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ki akai'tappix akex' pie'tsi itŭs'sŭmmiauaie, anniks'isk itotopokiuo'iĭxk Jesus Galilee, ki apotomoyiĭxkaie: ");
INSERT INTO bla_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ki ipokom'iauax Mary Magdalene, ki Mary, James ki Joses oksĭs'toauaii, ki Zebedee okku'ix oksĭs'toauai. ");
INSERT INTO bla_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Otau'tŭkkussi, akotsin'auă Arimathæa istsitappim'i anĭstau Joseph, ito'to, tuks'kŭma Jesus otŭsksĭnĭmats'aie: ");
INSERT INTO bla_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Itappo' Pilate, ki ikŏm'ŏnĭstomaie Jesus stŭm' i aie. Pilate itŭmŭn'iu mŏkaumŭtskatosaie mostŭm'i. ");
INSERT INTO bla_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ki Joseph otots'ĭssi mostŭm'i, itsĭsso'monĭmaie ksĭxĭstokh'aipĭstsi, ");
INSERT INTO bla_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ki itsĭpststotomaie otauŭt'sinani aken'iman, maniu'aie, annik' itatŭn'ipik ok'otokskui: ki omŭk'okotoki itŭp'auapĭmiuaie aken'imani ĭstokĭtsĭm'i, ki itsĭstapu. ");
INSERT INTO bla_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ki Mary Magdalene, ki stsĭk'i Mary, itotau'piauaie aken'imani. ");
INSERT INTO bla_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ki annik' ksĭstsiku'ik otŏkhs'apĭstutosau, mat'apinŏkkusi, omŭk'atoiapiekuax ki Pharisees ikŏnitoto'iauaie Pilate, ");
INSERT INTO bla_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ki an'iau, Nin'a, nitŭsksksĭnipĭnan om'ă ai'pĭstsĭksĭstutŭkkiuă otan'ipi, otsakiaitap'piisi, nioks'kai ksĭstsiku'i nitak'aatsipuau. ");
INSERT INTO bla_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Anit' ŏkhs'ĭstutsĭssĭ aken'imani nioks'kai ksĭstsiku'ĭsts, otŭs'ksĭnĭmatsax mŏkstai'sepiotosax, mŏkstai'kŏmosaĭ'ĭsax, mŏkstai'anĭstosauax matap'pix, ŭk'aipuau: ki sako'ipatsĭstutŭksĭnni aks'ĭstŭpskĭts top matom'ipatsĭstutŭksĭnni. ");
INSERT INTO bla_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate an'ĭstsiuax mattok'au eĕn'akex; ĭs'tapuk, mi'ĭstutsik. ");
INSERT INTO bla_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ki itappo' iau, ki mi'ĭstutsĭmiau ake'niman, ĭskskŭm'iauaie ok'otoksŏkh'sepĭstan, ki ĭstsi'iauaie eĕn'akex. ");
INSERT INTO bla_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ISSĬK'SĬSTSIKUYII ksĭstsiku'i otai'ksiuosaie, otaumŭtŭpapinŏk'kusaie ĭssĭk'atoiksĭstsikui, Mary Magdalene ki stsĭk'i Mary itoto'iau mŏks'ĭniĭsau ake'nimani. ");
INSERT INTO bla_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ki, sat'sĭt, ksŏk'kumă ai'papuyiu: tŭk'ka Ap'ĭstotokiua oto'tokatatsĭs spots' im itsĭnnĭsso'iĭnai, ki ito'to ki matskoap'imiuaie ok'otoksokh'sepĭstan ki itop'aiuaie. ");
INSERT INTO bla_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ostoksĭs'si netoinitai'natsiuaie popos'ists, ki kaii'ksĭstotosiu neto'i kon'skui: ");
INSERT INTO bla_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ki ŭsks'katŭkkix stun'noyiauaie, ki ai'papuyeian netoi'nitsiiau enix'. ");
INSERT INTO bla_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ki oto'tokatatsĭs an'ĭstsiuax a kex', piniko'puk; nits'ksĭnip kitap'ŭssŭmmauau Jesus annŏk' kaiĭs'toksauŏk. ");
INSERT INTO bla_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Matsĭnakuaiĕm'ats: tŭk'ka, ŭk'aipuau otan'ipi. Puk'sipuk, sat'sĭk otsit'sipi Nĭn'ă. ");
INSERT INTO bla_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ki kĭpi'tappoak, ki anĭstok'ax otŭs'ksĭnĭmatsax otse'ĭnsĭnni ŭkaipua'atomaie; ki, sat'sit, kitse'tomomattaak Galilee; omim' kitak'itsĭnnoauau: sat'sik, kikau'anĭstopuau. ");
INSERT INTO bla_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ki itsikĭp'ĭstupaatomiauaie ake'niman ai'kopumau, ki eks'kaetametŭkkiau; ki auks'kasiau mokitots'ipotosauaie otŭs'ksĭnĭmatsaxaie otse'poawsĭniaie. ");
INSERT INTO bla_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ki otsitappo'sauax mŏkitsĭnnikoŏsauax otŭs'ksĭnĭmatsaxaie, sŭm'mĭs, Jesus ito'tatsemiuax ki an'ĭstsiuax All hail! Ki ito'toiauaie ki eĭn'ĭmiauaie okŏt'sĭstsaie, ki ita'tsĭmmĭmmiauaie. ");
INSERT INTO bla_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesus itŭm'itŭnĭstsiuax, Pinikopuk; mĭs'tapuk, anĭstok'au nĭx'okoax mŏk'ittapposau Galilee, ki omim' nitak'itsĭnokiau. ");
INSERT INTO bla_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Annok' otsa'kiaitapposau, sŭm'mĭs, stsĭk'ix ŭsks'katŭkii itoto'iau akap'ioyĭs, ki aitsĭn'nikoyiauax omŭk'atoiapiekuax nitap'ii. ");
INSERT INTO bla_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kiotokŏnau'moŏsau ki omŭx'ĭnax otokŏnai'puyĭsau, ikotsi'auax eĕn'akex akaiĕm'i itawk'pumaupix, ");
INSERT INTO bla_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ki an'ĭstsiauax, ŭnnik' otŭs'ksĭmĭmatsax nitsa'kiaiokasĭnan, sepioto'iax ki itsikŏmos'attsiauaie. ");
INSERT INTO bla_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ki nĭn'a okhtsĭs'saie, nitaksemŭnan ki kitakitsikŏmotse'piopĭnan. ");
INSERT INTO bla_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mat'toyiauax itawk'pumaupix, ki otsksĭnĭmatseipuauaiax iia'tutsĭmiau ki annik' anĭssĭn'nik Jews sa'kiauanĭstomiax. ");
INSERT INTO bla_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nitsi'koputsiax otŭs'ksĭnĭmatsax itappo'iax Galilee nitum'mo, Jesus otan'ĭstopi. ");
INSERT INTO bla_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ki otsĭnno'ŏsauaĭe itatsĭm'mĭmmiauaie: ki stsĭk'ix sai'etŭkkiax. ");
INSERT INTO bla_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ki Jesus ito'toax ki ai'sitsĭpsattsiuax, ki an'ĭstsiuax, kŏnau'tŭmapsinni spots'im ki ksŏk'kum nit'okoko. ");
INSERT INTO bla_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ŭn'nikaie, ĭs'tapuk, ĭsksĭnĭmats'okau kŏnau'mianĭstsitappii, ŭs'tapĭnokau ninikŏt'tokĕsts otsĭn'ikŏsĭmĕsts kĭn'un, ki okku'i, ki atsĭm'istaaw: ");
INSERT INTO bla_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Isksĭnĭmats'okau mŏk'satsĭsauĕsts kĭtan'ĭstopuauĕsts; ki sat'sit, kitŭsks'opoksemopuau anĭstsiksĭs'tsikuĭsts aiksiuo'si ksŏk'kum. ");
ALTER TABLE bla_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
